﻿USE sofia;
DROP TABLE IF EXISTS sofia.wed_vpl;
CREATE TABLE wed_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wed_vpl WRITE;
INSERT INTO wed_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Au karena, God, mara ma dobu i vitupui. ");
INSERT INTO wed_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dobu kwakwavina ma eḡa aiwai ita mamae. Gimtona, gabinou i purui. Ma God Aruana, gabinou au tepana i genagenara ḡaira. ");
INSERT INTO wed_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ma God i riwa i pa, “Ina lalai!” Ma i lalai. ");
INSERT INTO wed_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma lalalaina i ʼnanai da i ai. Ma lalalaina ma gimtona i vilamonei. ");
INSERT INTO wed_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ma lalaina i ḡorei Marai ma gimtona i ḡorei Au Pom. Ma au bigai i nae ma ubaubanai i nei, au pom tagogi. ");
INSERT INTO wed_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ma God i riwa i pa, “Parata mara au tepana ina mae da waira au tepana ma waira au gabaurina ina vilamonei.” ");
INSERT INTO wed_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ma parata mara au tepana i terei da waira au dobu ma waira au mara i vilamonei. ");
INSERT INTO wed_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ma parata i ḡorei Mara. Ma au biga i nae ma ubaubanai i nei, nai au pom viruaina. ");
INSERT INTO wed_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ma God i riwa, “Waira, mara au gabaurina, gabu au tagogi ona vitagogiemi ma doa alalana ina eḡa.” Ma nanare i tupua. ");
INSERT INTO wed_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ma doa alalana i ḡorei, Dobu ma waira i vivitagogieia i ḡorei, Boga. Ma i ʼnanai da i ai. ");
INSERT INTO wed_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Anina ma God i riwa i pa, “Dobu, tam modu ma ai ma vigogoi, modu rarauanoi nununai ma ai rarauanoi nununai, ma peii ina gogo ma ina rauano me aloi nanare, ma nanare i tupua.” ");
INSERT INTO wed_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ma dobu, modu ma ai anatapui i vigogoi. Ma i ʼnanai da i ai. ");
INSERT INTO wed_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Au bigai i nae ma ubaubanai i nei, au pom vitonuina. ");
INSERT INTO wed_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ma God i riwa i pa, “Aniravilala au mara ina mae da marai ma waguvara ina vilamonei, ma iri ina vieḡeta ma nanare mara ma borima. ");
INSERT INTO wed_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ma taui, mara ina ravilalai da lalaina dobu ina verei.” Ma nanare i mae. ");
INSERT INTO wed_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ma aniravilala ḡaeḡaei ruaḡa i kauei, voḡaeḡaena marai i vibadei ma voaburuna waguvara i vibadei ma ubona maiteni i kauei. ");
INSERT INTO wed_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Aniravilala au mara i terei da dobu ita ravilalai ");
INSERT INTO wed_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","da marai ma waguvara ita vibadei ma lalalaina ma waguvara ita vilamonei. Ma i ʼnanai da i ai. ");
INSERT INTO wed_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ma au bigai i nae ma ubaubanai i nei, au pom vi-four-na. ");
INSERT INTO wed_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ma God i riwa i pa, “Sia ma lawalawai anatapui waira ona vioai ma kiu ona tupua ma ona lave au aidamo.” ");
INSERT INTO wed_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ma sia ḡaeḡae ma sia tapuna ma tapuna, boga au orana maemaei ma kiu tapuna ma tapuna maiteni i vitupui. Ma God, i ʼnanai da i ai. ");
INSERT INTO wed_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","I viaiaini ma i riwa i pa, “Ona vinatuna ma ona vimaḡaimi da boga ona vioai ma kiu ona vinatuna da ona maḡa au dobu.” ");
INSERT INTO wed_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ma au bigai i nae ma ubaubanai i nei, au pom vi-five-na. ");
INSERT INTO wed_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ma God i riwa i pa, “Doa, ḡamoḡamo nununai ma vitupui, ḡamoḡamo maramaraḡamai ma ḡamoḡamo moduei, ma ḡamoḡamo tetetei ma ina vinatuna da me taui nanare.” Ma nanare i tupua. ");
INSERT INTO wed_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ḡamoḡamo nununai anatapui i vitupui ma taui ina vinatuna da me taui nanare. Ma i ʼnanai da i ai. ");
INSERT INTO wed_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Anina ma God i riwa i pa, “Marina, rava tana kauei me tauta ma ai kaua tauta nanare. Ma taui sia ma kiu ma ḡamoḡamo anatapui au dobu ina vibadei, ḡamoḡamo maramaraḡamai ma ḡamoḡamo moduei, ḡaeḡaei ma muomuoi.” ");
INSERT INTO wed_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ma God, rava i kauei Anina ma oroto ma wavine i kauei, me tauna nanare. ");
INSERT INTO wed_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Rava i viaiaini ma i riwei i pa, “Ona vinatuna ma ona vimaḡaimi da dobu ona vioai ma dobu ona vibadei. Taumi, sia, kiu ma aiwai anatapui au doa tetetei ona vibadei. ");
INSERT INTO wed_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Lam, modu anoi ma ai uana a vereveremi ami lam. ");
INSERT INTO wed_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ma ḡamoḡamo moduei ma kiu ma ḡamoḡamo nununai anatapui aubai; ai rugurugu a vereverei ai lam.” Ma nanare i mae. ");
INSERT INTO wed_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Aiwai anatapui i kaukaueia i ʼnanai da i ai kaua ma i vinuaiai. Ma au bigai i nae ma ubaubanai i nei, aupom vi-six-na. ");
INSERT INTO wed_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ma nanare God mara ma dobu ma anataputapuna au orana i vitupui.");
INSERT INTO wed_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","God ana nola i vorovei ma mara au vi-seven-na i vilauvitau. ");
INSERT INTO wed_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ana nola i vikwai ma lamna aubaina God wei marana vi-seven-na i viaiaini ma i vovivirei.");
INSERT INTO wed_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Wei lamna mara ma dobu ana virarautua. Menanare Bada God mara ma dobu i vitupui. ");
INSERT INTO wed_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ma Bada God doa pokauna i vaia ma oroto i voai ma lavutu lawalawaina au giaganana i uveni ma oroto i lawana.");
INSERT INTO wed_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ma Bada God peipei Eden i paewi au maramatanei ma kampa orotona i vivitupuia i terei da i mae. ");
INSERT INTO wed_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ma Bada God ai inanana aiaina ma uana amna aiaina anatapui i paewi ma peipei au pouna ai vinevinei ruaḡa i gogo. Ai tagogi uana lamna lawana tauvereina ma ai ḡelauna uana lamna nota rava ina verei da metauna aiaina ma metauna apoapoena. ");
INSERT INTO wed_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ma Bada God oroto au peipei Eden i terei da ita nolei ma ita paini. ");
INSERT INTO wed_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma Bada God riwa bagibaginei i riwei i pa, “Ai uana anatapui au peipei am ḡoanei ma ani. ");
INSERT INTO wed_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Wate a viviḡaem da nota aiaii ma nota apoapoei aina uana eḡa ma ani! Mepa da u ani, tam nai au marana ma iraḡe!”");
INSERT INTO wed_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Bada God i riwa i pa, “Oroto ainelana e mamae ma lamna eḡa ita ai. Ana tauagu ana kauei da ina voagui.”");
INSERT INTO wed_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ma Bada God doa pokauna i vaia ma ḡamoḡamo anatapui ma kiu anatapui i kauei. Ma taui i neiai oroto awarina da ita viwavai. Ma oroto aiwai i viwavai, nanare ai wava i mae. ");
INSERT INTO wed_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ma oroto kiu ma ḡamoḡamo maramaraḡamai ma moduei, wava i verei. Wate Adam eḡa ana tauagu ita nelaḡai da ita voagui.");
INSERT INTO wed_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ma Bada God oroto i kauei da i matave ma maranaina i raunuavuru kaua, torotorona tagogi i votawanei ma vioa i pota-melei ana au gabu. ");
INSERT INTO wed_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ma Bada God oroto torotoronei wavine i kauei ma wavinena i neiai oroto awarina.");
INSERT INTO wed_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Anina ma oroto i auepai ma i riwa, “Ee wei tauna! Marina gelama tau gelamiuei ma vioa tauvioauei, wei tauna awariu i votawanei, lamna aubaina, ana ḡorei Wavine.”");
INSERT INTO wed_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ma nanare i tupua ma lamna aubaina oroto, amana ma alona e vovoterei ma awana maiteni e vivitagogiei.");
INSERT INTO wed_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Oroto awana maiteni, ana kovakovai, wate eḡa ita vinimala. ");
INSERT INTO wed_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Anina ma mota lamna terevaideḡa kaukauana eḡa me ḡamoḡamo ḡelaui i kaukaueia nanare. Ma mota wavine i paridadanei i pa, “Riwa kaua bo eḡa da God i riwem da eḡa ai uana au peipei ma ani.” ");
INSERT INTO wed_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ma wavine i paribelei i pa, “Tauai ai uana peipei au orana ana ani. ");
INSERT INTO wed_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Wate God i riwa da peipei au pouna, ai uana eḡa ana ani bo ana vodadani. Mepa da ana ani bo ana vodadani lamna ana iraḡe.” ");
INSERT INTO wed_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ma mota wavine i paribelei, “Eḡateni! Amapo eḡa ma iraḡe. ");
INSERT INTO wed_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nai maranai u ani, matam ina vikalai me God nanare ma aiaina ma apoapoena ona aramanei. Ma God i aramanei, lamna aubaina i viḡaem da avena ma ani.” ");
INSERT INTO wed_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ma wavine i ʼnana da ai uana aniam aiaina ma inanana i ai kaua, ma i ḡoei da ita ani da nuaulaula ita vaini, lamna aubaina tauna ai uana i vaia da i ani. Ma ḡelauna awana au ririvana i mamae i verei da i ani. ");
INSERT INTO wed_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ma matai i kala ma i aramanei da taui ana kovakovai, lamna aubaina ai bawara rugurugui i vaia da i vaturi da tupuai i tere-ḡaḡari. ");
INSERT INTO wed_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Au biga ubana i opuopu ma taui i nonori Bada God au peipei i bababara nae. Ma oroto awana maiteni ai au orai Bada God i raugovaḡei. ");
INSERT INTO wed_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Wate Bada God oroto i kwatuei i pa, “Tam mepa?” ");
INSERT INTO wed_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tauna i paribelei i pa, “A nonorim au peipei ma tau ana kovakovau aubaina a rovo da a raugovaḡem.” ");
INSERT INTO wed_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ma Bada God i riwa i pa, “Aiai i riwem da tam ana kovakovam? Ai uana a viḡaem da avena uta ani, ma u ani bo?” ");
INSERT INTO wed_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ma oroto i paribelei i pa, “Wavine u verevereu, tauna ai uana i vereu da a ani.” ");
INSERT INTO wed_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Bada God wavine i riwei i pa, “Aiwai u kauei?” Ma wavine i paribelei i pa, “Mota i moruiu da a ani.” ");
INSERT INTO wed_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Bada God mota i riwei i pa, “Wei u kauei aubaina, kovoḡa ḡaeḡaena tam awarim, eḡa me ḡamoḡamo ḡelaui nanare, maramaraḡamai ma moduei. Manawamei ma matave-taitaina-nae ma am lam doa ma ani am mara au anatapuna. ");
INSERT INTO wed_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ana kauei da tam ma wavine ona viḡavia nonoa, ma am epaia ma wavine ana epaia ona viḡavia. Tauna kolam ina gwadai ma tam ae karena ma ani.” ");
INSERT INTO wed_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ma wavine i riwa i pa: “Am nuabola ana viratai am au raumanawa, ma am iniviara ina rata am au vinatuna. Tam u ḡoei da awam uta vibadei, wate tauna tam ina vibadem.” ");
INSERT INTO wed_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adam i riwei i pa, “Ma tam awam ponana u rautaniḡanei ma ai uana a viviḡaeia u ani, Tam am kauelei doa u viapoapoeni. Tam ma nola guratana ma inim ina viara da lam ma nelaḡai, am mara au anatapuna. ");
INSERT INTO wed_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ma doa, donadona ma modu viganaganai ina vigogoi aubaim ma tam ma ipi da ma am. ");
INSERT INTO wed_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tam polapolam ina toi da lam ma nelaḡai ma nanare ma mae da ma nae me au doa. Doa pokauna a vaia da tam a kauem ma tam ma nae me doa au pokauna.” ");
INSERT INTO wed_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Oroto i aramanei da awana tauna rava anatapui aloi ma lamna aubaina i ḡorei Eve. ");
INSERT INTO wed_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bada God ḡamoḡamo opina i vaia da iniḡaḡara i kauei Adam awana maiteni aubai ma ini i tere-ḡaḡari. ");
INSERT INTO wed_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Bada God i riwa i pa, “Orotona aiaina ma apoapoena i aramanei, tauna marina tauta nanare. Eḡa tana voterei da urana ina vilolo-melei da lawana aina uana ina vaia da ina ani ma ina mae-nonoa.” ");
INSERT INTO wed_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ma lamna aubaina peipeiei, oroto i viopuni da doa ita ipiei. Bada, doei oroto i voai. ");
INSERT INTO wed_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Anina ma oroto i viaḡaḡana-opunei ma cherub biaḡa au peipei Eden au maramatanei i terei ma ana dabaruma araratana i terei da i nenae ma i nenei ma lawana aina etanaina e gagagaloei. ");
INSERT INTO wed_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ma Adam awana Eve maiteni i matave ma i duama ma tevera orotona i tupua. Ma i riwa, “Bada ana aguei natu a vaia.” Lamna aubaina i ḡorei “Cain.” ");
INSERT INTO wed_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ma muriai tevera orotona ḡelauna i ḡuni ma i ḡorei “Abel.” Ma maranai taui i vilaraga, Abel tauna tauviḡamoḡamo ma Cain tauipi. ");
INSERT INTO wed_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mara tagogi Cain doa uana ḡelaui i neiai da i puloei Bada awarina. ");
INSERT INTO wed_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Wate Abel nanare sipu natuevouii i vunu-naiei ma sia monamonai i apui Bada awarina ana pulo. Bada Abel ma ana pulo i vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Wate Cain ma ana pulo eḡa ita vinuaiaiei. Ma lamna aubaina, Cain amlona i ḡaiḡai ma naona i peu. ");
INSERT INTO wed_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Anina ma Bada Cain i riwei i pa, “Aiwai aubaina amlom i ḡaiḡai? Aiwai aubaina naom i peu? ");
INSERT INTO wed_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mepa da kaua aiaina uta kauei, lamna ata vinuaiai awarim. Wate am nota da apoapoena ma kauei, lamna ma aramanei da apoapoe am au metaeta e daradaraim da ina vovaiubaim. Wate tam ma virewapana da ma vovaiubai.” ");
INSERT INTO wed_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ma muriai Cain ana tevera Abel i riwei, i pa, “Tana nae, tana babara.” Ma maranai i ḡeta au wapu, Cain i vomairi ma ana tevera Abel i vunui da i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ma Bada Cain i paridadani i pa, “Am tevera Abel mepa?” Ma Cain i paribelei, i pa, “Eḡa ata aramanei! Tau au tevera taupainina bo?” ");
INSERT INTO wed_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ma Bada i riwa, i pa, “Aiwai u kauei? Am tevera tarana doei e kwatukwatu raubiwa aubaina. ");
INSERT INTO wed_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Lamna aubaina tam marina apoapoe awarim a tereterei. Am tevera tarana uramei au doa i toi da doa i matave ḡaḡari. ");
INSERT INTO wed_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ma lamna aubaina maranai u ḡoei da doa uta ipiei, lamna uana eḡa ma nelaḡai ma am animae eḡa. Tam ma babara labalababa.” ");
INSERT INTO wed_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain Bada i riwei, i pa, “Au kovoḡa i rata kaua ma eḡa tagotagogina da ana avarai! ");
INSERT INTO wed_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tam wei doanei e viviopuniu da naom eḡa ana inana-melei. Tau ana babara labalababa ma eḡa au animae. Ma rava ina nelaḡaiu ma ina viraḡeniu.” ");
INSERT INTO wed_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ma Bada i paribelei, i pa, “Eḡa! Aiai da i viraḡenim, ana kovoḡa ina rata guratana.” Ma ana mataira Cain awarina i terei da rava ita viḡaei da tauna avena ita vunui, maranai i nelaḡai. ");
INSERT INTO wed_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam awana maiteni i matave ma Eve natui ḡelauna i ḡuni. Eve i riwa, i pa, “Cain ana tevera Abel i viraḡeni. Ma lamna aubaina God natu orotona i vereu da Abel i raviepaiai.” Ma i ḡorei Seth. ");
INSERT INTO wed_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth natuna orotona i tupua ma i ḡorei Enosh. Ma nai marana, rava, Bada wavana vivivireina viborumana i vikarei. ");
INSERT INTO wed_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ma Bada i ʼnanai da rava anatapui au dobu ai ḡoʼapoapoe i rata kaua ma aiwai i viogatarei ma i vinua-notenotei anatapui apoapoei. ");
INSERT INTO wed_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Bada i ʼnanai ma orana i viara kaua ma i vinuabola da aiwai aubaina rava i kauei. ");
INSERT INTO wed_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ma Bada i riwa, “Tau rava a kaukaueia ana vipupui dobu au anatapuna ma nanare ḡamoḡamo ḡaeḡaei ma ḡamoḡamo au doa tetetei ma kiu au aidamo. Nuanuau i bola-kauei da taui a kauei.” ");
INSERT INTO wed_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Wate Bada Noah i ʼnanai ma i vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noah ma ana epaepaeia ai virarautua wenanare. Noah natunatuna nelarai tonuḡa: Shem, Ham ma Japheth. Noah ana ḡoʼapoapoe eḡa, tauna ainelana rava aiaina eḡa me aiai ḡelauna nai au marana. Ma God maiteni i bababani nonoa ma ana au viaiaina i mamae. ");
INSERT INTO wed_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Rava ai ḡoʼapoapoelei dobu i viapoapoeni God au matana ma vigaigaiawa dobu i oai. ");
INSERT INTO wed_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ma God i ʼnanai da rava ai ḡoʼapoapoe i rata kaua ma lawana apoapoena i maemaelei. ");
INSERT INTO wed_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ma God Noah i riwei, “Rava pupunana a vivinua-notenotei. Aubaina rava ai ḡoʼapoapoe dobu i oai, lamna aubaina rava ma dobu anatapuna ana vipupui. ");
INSERT INTO wed_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Lamna aubaina a ḡoei da wei ma kauei. Waga ḡaeḡaena ai bagibaginei ma voai tam aubaim. Ma babalaraḡi ma koltei au orana ma au doa ma pasi. ");
INSERT INTO wed_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Wenanare ma voai. Waga ana manawa 140 mita ma ana dabora 22 mita ma ana ḡae 14 mita ");
INSERT INTO wed_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ma poewi ma gavogavo aburuna ma voterei poewa ma biribiri au poui, ive ma madeḡa aubaina. Ma au ririvana, metaeta ma terei. Ma vatara, au gabaurina, au pouna ma au tepana ma voai. ");
INSERT INTO wed_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","—Ona rautaniḡana! Tau marina ututuva ana paritawaneiai au dobu ma aiwai anatapui lawalawaii ina amoa. ");
INSERT INTO wed_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Wate marina tau parivainuaḡana bagibagina ana kauei tam maiteni. Tam, awam, ma natunatum awawai maiteni au waga ona rui. ");
INSERT INTO wed_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ma ḡamoḡamo anatapui, wavinena ma orotona ma vigerui, kiu, ma ḡamoḡamo au doa tetetei ruaruaḡei ava ina rui da ina lawana. ");
INSERT INTO wed_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma lam taputapunei ava ma vaia da taumi ma ḡamoḡamo aubaii.” ");
INSERT INTO wed_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ma God aiwai anatapuna i ririweia; Noah i kauei. ");
INSERT INTO wed_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ma Bada Noah i riwei, “Tam ainelam rava jijimanim au dobu wei au marana. Lamna aubaina tam ma am numa ravai anatapumi au waga ona geru. ");
INSERT INTO wed_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ma Bada ḡamoḡamo i vianinei aniam ma pulo aubaina, ororotoi 7 ma waivinei 7 ma vaia. Ma Bada ḡamoḡamo eḡa ita vianinei, orotona tagogi ma wavinena tagogi ma vaia. ");
INSERT INTO wed_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ma nanare kiu ma vaia, ororotoi 7 ma waivinei 7. Wei ma kauei da ḡamoḡamo da kiu anatapui lawalawaii ina mae ma ina vinatuna. ");
INSERT INTO wed_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ma au pom 7 au murina ma garewa ana paritawaneiai da mara 40 ma au pom 40 ina atuna. Ma aiwai au dobu a kaukaueia, e mamae ma e lavulavutu anatapui ina pupu.” ");
INSERT INTO wed_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Anina ma Bada anatapuna i ririweia, Noah i kauei. ");
INSERT INTO wed_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ma au pom 40 au orana ututuva i rarata ma waga i tenam epa. ");
INSERT INTO wed_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Anina ma Bada anatapuna lawalawaii au dobu i pupuna-pai, rava ma ḡamoḡamo ma kiu ma ḡamoḡamo tetetei, anatapui i viamoai. Noah ma taui aiavoi au waga i gerugeru, taui ava i lawana. ");
INSERT INTO wed_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ma God Noah i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Tam ma awam ma natunatum ana awawai waga ona oputawanei. ");
INSERT INTO wed_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ma ḡamoḡamo lawalawai anatapui ma taravaina-opunei, kiu anatapui, ḡamoḡamo au doa tetetei da ina vinatuna ma ina maḡa da dobu ina vioai.” ");
INSERT INTO wed_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ma Noah awana ma natunatuna ma awawai waga i opu-tawanei. ");
INSERT INTO wed_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ma ḡamoḡamo anatapui, kiu ma ḡamoḡamo ḡelaui au doa tetetei, ai au dam nununai nanare waga i opu-tawanei. ");
INSERT INTO wed_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ma Noah pulo aniapuna i voai Bada awarina ma ḡamoḡamo aiaii, kiu aiaii tagotagogi ava taputapuna i apui pulo aniapuna au tepana. ");
INSERT INTO wed_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ma maranai Bada pulo ḡabuna i laḡoni ma au nuanuana i pa, “A aramanei da rava melamelaiei ai nota i apoapoe. Wate dobu eḡa ana viapoapoeni ma eḡa melanai lawalawai anatapui ana pupuna-melei me a kauei nanare. ");
INSERT INTO wed_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ma maranai dobu e mamae paewa ma tuaruta, ubauba ma vibola, bodu ma omra, garewa ma madeḡa, maratom ma au pom, ina mae-nonoa ma eḡa ina kwa.” ");
INSERT INTO wed_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ma God Noah natunatuna maiteni i viaiaini ma i riwei i pa, “Ona vinatuna ma ona vimaḡaimi da dobu ona vioai. ");
INSERT INTO wed_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ana kauei da ḡamoḡamo ḡaeḡaei ma ḡamoḡamo tetetei, iana ma kiu, anatapui ina rovoemi. Ma au urami ana terei da ona vibadei. ");
INSERT INTO wed_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Aiwai anatapui lawalawai ami aniam. Modu anoi ma ai uana a veremi, wate marina aiwai anatapuna a vereveremi ami aniam. ");
INSERT INTO wed_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","—Wate vioa taratarana eḡa ona ani, aubaina tara au orana lawana e mamae, ona voterei da tarana ina toi tawanana ma muriai ona ani. ");
INSERT INTO wed_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ma mepa da ḡamoḡamo rava i viraḡeni. Tau ana raubiwa, wate nanare rava, rava turana i viraḡeni. Tau ana raubiwa. ");
INSERT INTO wed_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tau rava a kauei me tau inanau nanare, ma lamna aubaina Rava aiai i viraḡena, rava ḡelauna tauna ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ma tam natunatum ina maḡa da am epaepaia dobu ina maena-pai.” ");
INSERT INTO wed_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ma God Noah natunatuna maiteni i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ona rautaniḡana wei marina, Tau au parivainuaḡana bagibagina taumi ami epaepaia maiteni a kaukauei. ");
INSERT INTO wed_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ma ḡamoḡamo lawalawaii anatapuna, kiu ma ḡamoḡamo numei ma moduei ma anatapui wagei i opuopu, ma ḡamoḡamo anatapui muriai au dobu ina mae. ");
INSERT INTO wed_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Wei riwanei au parivainuaḡana bagibagina taumi maiteni a terei da eḡa melanai ututuva ḡelauna ana paritawanana-meleiai au dobu da purapura lawalawaii ina vipupui.” ");
INSERT INTO wed_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ma God i riwa, “Parivainuaḡana bagibagina a kaukauei taumi ma anatapui lawalawai maiteni anatapui muriai e nenei. Wei parivainuaḡana matairana wenanare: ");
INSERT INTO wed_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Warilolo au apau ana terei da ina vimataira da tau au parivainuaḡana bagibagina a terei tau ma taumi ma anatapui lawalawai au dobu maemaei. ");
INSERT INTO wed_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Maranai mara e ḡuvaḡuvai ma warilolo au apau e eḡaeḡa, ");
INSERT INTO wed_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","lamna ina vieḡeu da au parivainuaḡana bagibagina tau ma taumi ma anatapui lawalawai au dobu. Ma eḡa melanai ututuva lawana ina vipupui.” ");
INSERT INTO wed_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Au naona rava anatapui au dobu pona tagogi ma riwa tagogina i bababaniei. ");
INSERT INTO wed_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nai maranai rava i vaḡavaḡai nae au maramatanei ma wapu au ḡaeḡaena i ḡeta au Shinar ma kampa i mae. ");
INSERT INTO wed_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ma i babani vivira i pa, “Ona nei, doa tana vaia ma brik tana pasi ma tana apui da ina bagibagi.” Ma nanare ai numa brikiei i voai ma koltei i ampasi. ");
INSERT INTO wed_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ma taui i riwa, “Ona nei melagai ḡaeḡaena tana voai tauta aubaita ma numa ḡeḡe dewadewana tana voai da ina ḡae au mara da wavata tana kauei ma eḡa tana vilamoneta dobu au anatapuna.” ");
INSERT INTO wed_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Anina ma Bada i ḡairai da ravai melagai ḡaeḡaena ma numa ḡeḡe dewadewana i voavoaia ita inanai. ");
INSERT INTO wed_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ma Bada i riwa i pa, “Wei taui rava tagogi ma pona tagogina e bababaniei. Wei lamna karena, aburuna ava aiwai ai au nota anatapuna ina kauana-paiei. ");
INSERT INTO wed_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ona nei tana ḡaira da noi ravai ai pona tana vinua-raḡaraḡai ma ina babani labalababa.” ");
INSERT INTO wed_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Anina ma Bada rava anatapui ai pona i vinua-raḡaraḡai ma i vilamonei dobu au anatapuna, lamna aubaina nai melagaina i ḡorei Babel. Ma melagai ḡaeḡaena voana i voterei. Bada taui i vilamonei dobu au anatapuna. ");
INSERT INTO wed_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bada Abram i riwei i pa, “Am dobu, am rava ma amam ana dam ravai ma netawanei ma ma nae dobu ana viatataiem kampa ma mae. ");
INSERT INTO wed_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ma am epaepaia ai dam ana viratai, ma ana viaiainim, ma ana kauei da wavam ina rata, ma tamei viaiaina ina nei rava awarii. ");
INSERT INTO wed_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ma aiai i viaiainim, tau ana viaiaini, ma aiai i parivai-apoapoenim, tauna ana parivai-apoapoeni, ma tamei dam anatapui au dobu ana viaiaini.” ");
INSERT INTO wed_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Ma Bada i ririweia nanare, Abram awana Sarai ma maiana Lot Haran i opu-tawanei, Abram ana madeḡa 75. Ai purapura, ai ḡamoḡamo ma ai laralaraga ma i vomairi Canaan aubaina. ");
INSERT INTO wed_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","I ḡeta Canaan ana au parata ma i verautua da au gabu vinevinena, Shekem melagaina ḡaeḡaena au ririvana. Ma kampa au Moreh ai ḡaeḡaena au ḡouna i rauḡaravu. (Nai maranaina mai Canaan, nai au dobuna i mamae.) ");
INSERT INTO wed_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kampa Bada i viatataeana-melei ma i riwa i pa, “Wei dobuna Canaan am epaepaia ana verei.” Ma Abram pulo aniapuna, i voai Bada awarina ma pulo i apui. Mepa Bada i viatataeana-melei lamna au gabuna aniamapu i voai. ");
INSERT INTO wed_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Maranai Lot, Abram maiteni i vaḡavaḡai, Lot maiteni ana ḡamoḡamo maḡamaḡaui ma ana numa ravai ma ana tauvilaraga. ");
INSERT INTO wed_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ma taui ai ḡamoḡamo i maḡa guratana ma gabu eḡa tagotagogina da anatapui ita ḡamoi, ");
INSERT INTO wed_vpl VALUES ("GN13_7a","002_13_7a","GEN","13","7a","7a","Ma lamna aubaina eḡa tagotagogina da taui ita mae-gogona. ");
INSERT INTO wed_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Anina ma Abram Lot i riwei i pa, “Ma rautaniḡana, tauta tara tagogi ma eḡa tana viparipariniḡai ma ata taunola avena ita viḡaiḡaiawa vivira. ");
INSERT INTO wed_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Weka tana vilamoneta ma ata naei tana nae. Doa au naota e inainanai. Metauna e ḡoeḡoei ma nae ma kampa ma mae. Mepa da tam ma nae au oiena, tau ana nae au kelakela. Mepa da tam ma nae au kelakela, tau ana nae au oiena.” ");
INSERT INTO wed_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Anina ma Lot matana i tawanei da waira Jordan wapuna ma Zoar melagaina au paratana. Ma i ʼnanai da waira i maḡa ma doa maumaurana me Bada ana peipei, me doa maumaurana au Egypt. (Nai marana Bada eḡa Sodom ma Gomorah ita vipupui.) ");
INSERT INTO wed_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ma Lot waira Jordan wapuna i vinei tauna aubaina ma i nae au maramatanei. Taui nanare i vilamonei. ");
INSERT INTO wed_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram au Canaan i mae ma Lot Sodom au ririvana i mae. ");
INSERT INTO wed_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ma mai Sodom ai lawana i apoapoe kaua ma ḡoʼapoapoe i kaukauei Bada au matana. ");
INSERT INTO wed_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ma Lot Abram i netawanei ma muriai Bada Abram i riwei i pa, “Mepa u mamae lana, matam ma tawanei au lavaratei ma au rauanaḡei ma madeḡa e gogogolana ma mepa madeḡa e neneulai. ");
INSERT INTO wed_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Dobu anatapuna e inainanai tam ma am epaepaia ana vere-nonoemi. ");
INSERT INTO wed_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ma am epaepaia ana kauei me doa pokauna ma aiai da pokau e iaiavi lamna am epaepaia tagotagogina ina iavi. ");
INSERT INTO wed_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Dobuna anatapuna taumi a vereveremi, ma nae ma dobuna ana manawa ma ana dabora ma babarani.” ");
INSERT INTO wed_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ma nanare Abram ana numagara i naiei Mamre ana ai ḡaeḡaena au ḡereḡerena au Hebron i mae ma kampa pulo aniapuna i voai ma pulo i apui Bada awarina. ");
INSERT INTO wed_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Gulagulau 4 Sodom ma Gomorah ai purapura ma ai lam i kwalei. Abram maiana Lot au Sodom i mamae i vaia ma ana purapura maiteni i vaia ma i nae. ");
INSERT INTO wed_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Abram tauna Hebrewei ma Mamre ana ai ḡaeḡaena au ḡereḡerena i mamae. Ai taniwagana wavana Mamre tauna Amoriei, varevareina Eskol ma Aner. Anatapui Abram ana tauagu, ḡavia au marana. Ma oroto tagogi ḡavia i rovoei da i rovo-nae ma i ḡeta Abram awarina ma i vibenabenamei. ");
INSERT INTO wed_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ma maranai Abram i nonori da taui maiana Lot i vaia. Tauna ana sorodia vinevinei ana au melagai tuputupuai 318 i kwatuei. Ma ḡaviḡaviai i votaḡoi da i ḡae au Dan. ");
INSERT INTO wed_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Waguvarai ana sorodia i ḡutai ma ḡaviḡaviai i viaḡaḡei da Damaskas i verautuini da au Hobah i ḡeta ma kampa i vovaiubai. ");
INSERT INTO wed_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Purapura anatapui i vai-melei. Maiana Lot ma ana purapura ma waivine ma rava ḡelaui. ");
INSERT INTO wed_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek tauna Salem ai gulau ma God Aidamo Telarana ana pirisi pulo tauapuina. Palawa ma wine i neiai, ");
INSERT INTO wed_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ma Abram i viaiaini ma i pa, ");
INSERT INTO wed_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ma God Aidamo Telarana am ḡavia au uram i terei, lamna aubaina tana voepaepai.” Ma Abram aiwai ana sorodia maiteni i tami i vitagogiei da ḡuta 10 i kauei. Ma ḡuta tagogi i votawanei ma Melkisedek i verei. ");
INSERT INTO wed_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ma muriai Bada Abram ana au rauboni i riwei i pa, “Abram eḡa ma rovo. Tau am taugagalo am pulo ḡaeḡaena.” ");
INSERT INTO wed_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ma Abram i paribelei i pa, “Oo Bada God. Tau eḡa natunatu, ma am pulo eḡa ina voaguiu. Tam eḡa natu orotona uta vereu ma lamna aubaina au iraḡe au murina, Eleasar au taunola Damaskasei au vigulau ina vaia.” ");
INSERT INTO wed_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Anina ma Bada i riwana-melei i pa, “Eḡa! Tauna am vigulau eḡa ina vaia, wate natum orotona tamei ina tupua, tauna am vigulau ina vaia.” ");
INSERT INTO wed_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Anina ma Bada tauna i taravaina-opunei au doa ma i riwei i pa, “Ma ḡoutata au mara ma ubona ma inanai, mepa da tam tagotagogina da uta iavi. Lamna am epaepaia ina maḡa me ubona nanare. Eḡa aiai tagotagogina da ina iavi.” ");
INSERT INTO wed_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram, Bada riwana i vitumaḡanei ma lamna aubaina Bada i riwa da Abram rava jijimanina. ");
INSERT INTO wed_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ma maranai madeḡa i neneulai ma Abram i matave-nuavuru kaua. Ma gimtona ma rovo ḡaeḡaena i nei ma i purui. ");
INSERT INTO wed_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ma Bada i riwei i pa, “Wei ma aramana-kauei! Am epaepaia ina vitaomana au dobu ḡela ma kampa ina vitaunola. Ma dobuna ravai taui ina rau-iviapoapoelei da madeḡa 400 ina kwa. ");
INSERT INTO wed_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Wate muriai tau nai dobuna ravai ana kovoḡi ma am epaepaia ina vipurapura kaua ma ina nememei. ");
INSERT INTO wed_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Ma mai Amori ai ḡoʼapoapoe ina rata guratana, ma nai maranaina ana kovoḡi ma ana viaḡaḡana-opunei wei au dobuna. Ma lamna aubaina am epaepaia eḡa ina nei laḡilaḡinai da kimta au vi-four-na. Wate tam, Abram ma magura kaua ma ana nuaubam ma iraḡe ma ina doboim.” ");
INSERT INTO wed_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Abram au Canaan i mae madeḡa 10 i kwa, awana Sarai aipoi ma eḡa ita vinatuna. Sarai ana taunola wavinena Egyptei wavana Hagar. Ma Sarai Abram i riwei i pa, “Bada i viḡaeu da eḡa ata vinatuna. Ma nae au taunola maiteni ma matave, mepa da ina vinatuna, ma tevera ana vinatunei.” Abram, Sarai ponana i voteletelei ma Hagar i vaia ma i viawanei. ");
INSERT INTO wed_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ma Hagar i vinatuna da Abram natuna orotona i tupua. Ma Abram, natuna i viwavai Ishmael. ");
INSERT INTO wed_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Maranai Abram ana madeḡa 99 ma Bada i vieḡana-melei Abram awarina ma i riwei i pa, “Tau God Vivirewapana Kaukauana. Au naou ma babara ma kaua aiaina ava ma kauei ");
INSERT INTO wed_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","da nanare au Parivainuaḡana bagibagina ana vovai-virewapani tau ma tam awarita ma am dam ana vimaḡa-guratei.” ");
INSERT INTO wed_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ma Abram i mae-ḡaira au doa ma i raudune. Ma God Abram i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Tau au navanava au parivainuaḡana bagibagina tam maiteni wenanare: Ana kauei, da dam patarana maḡamaḡaui tam ina viamanem. ");
INSERT INTO wed_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ma marina wavam Abram, ana terevirai da Abraham; aubaina marina ana kauei da dam patarana maḡamaḡaui ina viamanem. ");
INSERT INTO wed_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ma ana kauei da am epaepaia ina maḡa ma am damei gulau maḡamaḡaui ina nei. ");
INSERT INTO wed_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Au parivainuaḡana bagibagina ana vovai-virewapani, tau ma tam ma am epaepaia muriai e nenei da tau am God ma taui ai God. ");
INSERT INTO wed_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Canaan dobuna taputapuna marina e mamae-gubai, tam am epaepaia maiteni ana vere-nonoemi aubaimi ma tau, taui ai God.” ");
INSERT INTO wed_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ma God Abraham i riwei i pa, “Ma au parivainuaḡana bagibagina, tam ma am epaepaia maiteni ona voteletelei. ");
INSERT INTO wed_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Wei taumi ami au navanava parivainuaḡana bagibagina ona voteletelei, ami nelara anatapui inii ina bori. ");
INSERT INTO wed_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ma taumi inimi ona bori, lamna ata parivainuaḡana matairana. ");
INSERT INTO wed_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Roaroa melamelai nelarai i tupua ma au pom 8 au murina inii ona bori. Wei kauana ona kauei, natunatumi nelarai ma ami taunola natunatui nelarai ma nelara anatapui am au numa e vivitaunola. ");
INSERT INTO wed_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Riwa kaua, maranai roaroa nelarai i tupua am au dam bo maranai taunola o gimarai, taui au mataira lamna inii ona bori. Lamna au parivainuaḡana matairana au tupuami ina mae-nonoa. ");
INSERT INTO wed_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Wate aiai orotona nai matairana eḡa au tupuana, lamna au parivainuaḡana bagibagina i viaigai ma lamna aubaina tauna ina viravaḡela.” ");
INSERT INTO wed_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God Abraham i riwei i pa, “Awam eḡa ma ḡorei Sarai, wate ma ḡorei Sarah. ");
INSERT INTO wed_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Tau ana viaiaini ma natum orotona ina vitupui. Anina ma ana viaiaini da ina vidam ḡaeḡae aloi. Ma dam ai gulau maḡamaḡaui taunei ina opu.” ");
INSERT INTO wed_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham i mae-peu ma i raudune ma i mutu-kaka ma au nuanuana i pa, “Amapo oroto ana madeḡa 100 ma ina vinatuna bo? Ma Sarah ana madeḡa 90 ma ina vinatuna bo?” ");
INSERT INTO wed_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ma Abraham God i riwei i pa, “Ma Ishmael menanare, uta viaiaini bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Wate God i riwa i pa, “Eḡa! Awam Sarah natum orotona ina vitupui ma ma viwavai Isaac. Au parivainuaḡana bagibagina tauna awarina ma ana epaepaia awarii ina mae-nonoa. ");
INSERT INTO wed_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ma Ishmael aubaina, am nuabola a nonori. Ana viaiaini ma natunatuna ana vimaḡai ma ana epaepaia ana vituai. Tauna dam 12 ai babada amai ma ana epaepaia ai dam ana vimaḡai. ");
INSERT INTO wed_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Wate au parivainuaḡana bagibagina ana kauei Isaac maiteni. Ma wei marana nanare, madeḡa ḡelauna Sarah, Isaac ina vinatunei.” ");
INSERT INTO wed_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Au benai Abraham ana numagara au metaetana i kiakiala. ");
INSERT INTO wed_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","I taepai ma nelara tonuḡa i ʼnanai i maimairi. Maranai i ʼnananai i ruba da au naoi i mae-ḡaira ma i raudune. ");
INSERT INTO wed_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ma i riwa i pa, “Au bada. Mepa da u notai da tau anina, eḡa ma tutelareu. ");
INSERT INTO wed_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Waira ana neiai da aemi ana oḡai ma ona vilauvitau ai au ḡouna. ");
INSERT INTO wed_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Lam ana veremi da ina vovai-virewapanimi ma muriai ona vaḡai. Taumi o notaiu da o nei.” Taui i paribelei, “Anina u ririweia ma kauei.” ");
INSERT INTO wed_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Anina ma Abraham laḡilaḡina i nae au numagara ma Sarah i riwei i pa, “Laḡilaḡina, am palawa aiaina baikena ma vaia ma palawa ma apui.” ");
INSERT INTO wed_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ma i ruba ma bulumakau orotona ḡaubona i vaia da ana taunola i verei ma i vokaukauei. ");
INSERT INTO wed_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Anina ma Palawa ma mereki ma mereki ravi taputapui ma sia i neiai taui awarii au ḡou da i am ma tauna i mae-paini. ");
INSERT INTO wed_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Taui i paridadana i pa, “Awam Sarah mepa?” Tauna i paribelei i pa, “Tauna numagara au orana.” ");
INSERT INTO wed_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Taui tagogi Abraham i riwei i pa, “Riwa kaua da wei au marana nanare madeḡa au ḡelauna ana nenememei, lamna awam Sarah tevera orotona ina ḡuni.” Ma Sarah, ravai au muri numagara au metaetana, i rarautaniḡana. ");
INSERT INTO wed_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Sarah ma Abraham i magura kaua ma Sarah ana vinatuna ana mara i kwa. ");
INSERT INTO wed_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah i mutu-kaka ma i riwana-melei, “Tau ma awau a magura kaua ma au vinatuna ana mara i kwa. Ma amapo tagotagogina da duama ana morelanei bo?” ");
INSERT INTO wed_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Bada Abraham i paridadanei i pa, “Aiwai aubaina Sarah i kaka ma i riwa, ‘Tau a magura kaua ma riwa kaua da ana vinatuna bo?’ ");
INSERT INTO wed_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Aiwai i piripiri guratana Bada au matana? Me a ririwem nanare, ana nememei awarim wei marana nanare madeḡa au ḡelauna ma awam Sarah tevera orotona ina ḡuni.” ");
INSERT INTO wed_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah i rovo ma i bovi ma i riwa i pa, “Tau eḡa ata kaka.” Tauna i paribelana i pa, “Eḡa! Tam u kaka.” ");
INSERT INTO wed_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Maranai nelara tonuḡa i vomairi da ita nae, Abraham taui maiteni i nae da au etanai ita tuterei. Ma taui i ʼnana ḡaira au Sodom, ");
INSERT INTO wed_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","19","ma Bada ana au nota i pa, “Aiwai marina ana kauei, eḡa ana tere-govaḡi Abraham awarina. Abraham ana epaepaia ina vidam ḡaeḡaena ma vivirewapanana ma taunei dam anatapui au dobu ana viaiaini. Tauna a vinei da natunatuna ina riwei ma taui natunatui ina riwei da Bada ana lawana ina votaḡotaḡoi da aiaina ma jijimanina, ina kaukauei da tau Abraham a paripari-vainuaḡania ana kauei.” ");
INSERT INTO wed_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ma Bada Abraham i riwei, “Tau, vikaruwaḡawaḡa maḡamaḡaui a nonori da Sodom ma Gomorah melagaii ravai ai ḡoʼapoapoe i rata guratana. ");
INSERT INTO wed_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","A ḡaiḡaira da ana inanai da wei vikaruwaḡawaḡana riwa kaua bo eḡa.” ");
INSERT INTO wed_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Bada Abraham maiteni i maimairi ma nelara ruaḡa i nae au Sodom. ");
INSERT INTO wed_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham i nei Bada awarina ma i riwa i pa, “Riwa kaua da rava aiaii ma vipupui rava apoapoei maiteni? ");
INSERT INTO wed_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mepa da rava aiaii 50 au melagai, amapo melagaina ma vipupui bo? Ma rava 50 notaiei ma melagaina eḡa ma vipupui? ");
INSERT INTO wed_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Lamna eḡa ita ai, ma eḡa ma kauei. Tam eḡa rava aiaii ma viraḡeni rava apoapoei maiteni. Nai kauai e kaukauei rava aiaii awarii, kauana tagogina rava apoapoei awarii e kaukauei, eḡateni! Tam rava anatapui au dobu tauetareina ma ma etarana-kauelai tapa?” ");
INSERT INTO wed_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Bada i riwa i pa, “Mepa da rava 50 aiaii ana nelaḡai au Sodom, dobuna ana voterei taui ai ḡoʼaiaii aubaina.” ");
INSERT INTO wed_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham i paribelei i pa, “Au Bada tau am molaka, wate tau wei babanina a vikarei aubaina amapo ana paridadana me. ");
INSERT INTO wed_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mepa da rava 50 aiaii ma 5 ina deḡa, amapo melagaina ma vipupui bo?” I riwa i pa, “Mepa da rava 45 kampa ana nelaḡai lamna eḡa ana vipupui.” ");
INSERT INTO wed_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham i paridadana me i pa, “Mepa da rava aiaii 40 ava kampa u nelaḡai?” I riwa i pa, “Mepa da kampa 40, amapo eḡa ana kauei.” ");
INSERT INTO wed_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham i riwa i pa, “Au Bada, eḡa awariu ma ḡaiawa ma vianineu da ana babani me, mepa da 30 ava kampa ma nelaḡai?” I riwa i pa, “Mepa da 30 ava ana nelaḡai, amapo eḡa ana kauei.” ");
INSERT INTO wed_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham i riwa i pa, “Tau wei babanina a vikarei, mepa da 20 ava kampa ma nelaḡai?” I riwa i pa, “Mepa da 20 ana nelaḡai lamna, eḡa ana vipupui.” ");
INSERT INTO wed_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham i riwa i pa, “Au Bada, eḡa awariu ma ḡaiawa ma vianineu da mara tagogi ava ana babani me. Mepa da 10 kampa ma nelaḡai?” I riwa i pa, “Mepa da 10 ana nelaḡai, amapo eḡa ana vipupui.” ");
INSERT INTO wed_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Maranai Bada Abraham awarina i babani vorove, tauna i nae ma Abraham i nae ana au melagai. ");
INSERT INTO wed_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ma raviraviai anela ruaḡa au Sodom i ḡeta, Lot melagai au metaetana i kiakiala. Maranai Lot taui i ʼnanai, i vomairi da i nae awarii ma i raudune. ");
INSERT INTO wed_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ma i riwa i pa, “Au babada, tau ami taunola a nei, ona nei au au numa. Aemi ona oḡai ma ona matave. Maratomtomai ona vomairi da ami au aninae ona nae.” Ma taui i paribelei i pa, “Eḡa! Tauai weka au deba ana matave.” ");
INSERT INTO wed_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma i riwana bagibagi da maiteni i nae ana au numa. Lot, palawa eḡa yist maiteni i apui ma taui i am. ");
INSERT INTO wed_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ma ita matave ma mai Sodom nelarai laralaragai ma magumaguri anatapui i nei da numa i kwaipipini, ");
INSERT INTO wed_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ma taui Lot i kwatuei i pa, “Nelara ruaḡa waguvarai i nenei awarim, taui mepa? Ma opuneiai awariai da ana viawawanei.” ");
INSERT INTO wed_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ma Lot i opu taui awarii ma au murina metaeta i gudui. ");
INSERT INTO wed_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ma i riwei i pa, “Au rava a vivibaḡaimi, eḡa wei kauai apoapoei ona kauei. ");
INSERT INTO wed_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ona rautaniḡaneu, tau natunatu waivinei ruaḡa, taui matatapu. Ana opuneiai awarimi da ami ḡoana nanare ona kauei. Wei nelarai a neiai au numa lamna tau au taomana ma eḡa aiwai awarii ona kauei.” ");
INSERT INTO wed_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ma Sodom nelarai i paribelei i pa, “Ma maeria! Tam dobu ḡela ravam weka e mamae-gubai ma marina u ḡoei da ma vibadabada. Marina ana viapoapoena-kauem eḡa me taui ruaḡa!” Ma taui Lot au metaeta i dudu ratui da gudu ita rikai. ");
INSERT INTO wed_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Wate nelara ruaḡa numa au orana urai i tere-opunei ma Lot i taina-ruiei awarii ma metaeta i gudui. ");
INSERT INTO wed_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ma nelara anatapui au metaeta matai i viaipotai mara tupona ava da eḡa tagotagogina metaeta ita inanai. ");
INSERT INTO wed_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Anina ma nelara ruaḡa Lot i riwei i pa, “Tauai marina wei dobuna ana pupuni. Bada, vikaruwaḡawaḡa maḡamaḡaui i nonori wei melagaina ravai awarii ma Tauna, tauai i paritawanelai da dobuna ana pupuni. Am dam ravai ḡelaui weka e mamae bo eḡa? Natunatum nelarai ma waivinei ma poipoiam ma am rava aiavoi au melagai maemaei; ma taravaina-opunei!” ");
INSERT INTO wed_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ma Lot i opu natunatuna ai ḡopapara awarii ma i riwei i pa, “Bada marina dobuna ina pupuni. Laḡilaḡina, wei dobuna ona oputawanei.” Ma taui i notai da tauna i vivinama. ");
INSERT INTO wed_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ma mara karena i tereterei ma anela Lot i vivibaḡai da ita volaḡilaḡina. Ma i riwa i pa, “Eḡa ita ai da ma iraḡe maranai Bada wei dobuna ina pupuni. Laḡilaḡina awam ma natunatum maiteni ona opu.” ");
INSERT INTO wed_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Wate Lot i tatavira. Bada i ḡoei da Lot ita vilawani. Ma anela Lot awana maiteni ma natunatui urai i vojijini ma melagaiei i taravaina-opunei. ");
INSERT INTO wed_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Maranai melagai i opu-tawanei ma anela tagogi taui i riwei i pa, “Ona ruba ami lawana aubaina! Eḡa au murimi ona inana ma eḡa au wapu ona tumairi dadana. Ola aubaina ona ruba da ami lawana eḡa ona vine-boai.” ");
INSERT INTO wed_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ma madeḡa i gogogo ma Lot ana numa ravai maiteni au melagai Zoar i ḡeta. ");
INSERT INTO wed_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Lamna maranai Bada salpa araratana marei i paritawanana ḡaireiai me garewa, Sodom ma Gomorah melagaii au tepai. ");
INSERT INTO wed_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ma melagaii, wapu, rava anatapui ma aiwai gogogoi i aragibui. ");
INSERT INTO wed_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ma Lot awana i vivimuri, i mae-tavirei ma i ravi-taputapui. ");
INSERT INTO wed_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ma ubaubanai boiboḡi Abraham i vomairi ma i nae mepa Bada maiteni i bababani lana. ");
INSERT INTO wed_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ma i ʼnana ḡaira Sodom ma Gomorah ma wapuna ana taputapuna ma kampa bau potopotona i ʼnanai i ḡeḡae. ");
INSERT INTO wed_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Maranai God nai melagaii ma wapuna i pupuni, tauna Abraham eḡa ita notavai-nuavurui. Ma lamna aubaina God Lot i paritawana-opunei ma muriai nai melagaina i vipupui. ");
INSERT INTO wed_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ma Bada Sarah i viaiaini ma i paripari-vainuaḡani nanare i kauei. ");
INSERT INTO wed_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ma God mara i vinevineia nanare, Sarah i duama ma i vinatuna. Natuna orotona i tupua, Abraham i magura ma natuna i tupua. ");
INSERT INTO wed_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham natuna i viwavai Isaac. ");
INSERT INTO wed_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ma au pom 8 au murina Abraham natuna inina i bori me God i ririweia nanare. ");
INSERT INTO wed_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham ana madeḡa 100 maranai wei kauai i tupua. ");
INSERT INTO wed_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaac i rata ma i viedai ma Abraham lam ḡaeḡaena i vokaukauei ma i am gogona. ");
INSERT INTO wed_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ma Sarah Ishmael i ʼnanai Isaac i vivinamei. Ishmael lamna Abraham natuna ḡelauna, ana taunola Hagar Egyptei i ḡuniḡunia. ");
INSERT INTO wed_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ma Sarah Abraham i riwei, “Taunola wavinena ma natuna ma viopuni! Eḡa ata ḡoei da tauna am buderi ina vaia. Natu Isaac ainelana am buderi ina vaia.” ");
INSERT INTO wed_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham wei riwana i nonori ma i vinuabola kaua aubaina tauna natuna Ishmael. ");
INSERT INTO wed_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Wate God Abraham i riwei i pa, “Eḡa natum ma alona ma vinuabolei. Am epaia Isaac wavam ina mairiei. Aiwai Sarah i ririwem ma kauei. ");
INSERT INTO wed_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Wate am taunola wavinena natuna ana epaepaia ana vimaḡai ma ana dam ina rata aubaina tauna tam natum.” ");
INSERT INTO wed_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ubaubanai boiboḡi Abraham tamaina i vokaukauei ma waira i ḡui ma Hagar i viavarai. Ma wavine natuna maiteni i paritawanei da i nelabalababa au mutulua. ");
INSERT INTO wed_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Madeḡa maḡamaḡa i kwa ma muriai God Abraham ana tumaḡana i raudadani. God i riwa i pa, “Abraham!” Abraham i paribelei i pa, “Tau weka!” ");
INSERT INTO wed_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ma God i riwa i pa, “Natum tagotago Isaac nuanuam pouna, ma taravaini ma ona nae au dobu Moriah. Ma ola ana viatataem, kampa natum ma puloei aniamapu.” ");
INSERT INTO wed_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mara i tom ma ubaubanai boiboḡi, Abraham i vomairi, ai i edari pulo apunana aubaina ma ana donki i vokaukauei. Ma ana taunola ruaḡa ma natuna Isaac i taravaini ma anatapui i nae gabu God i ririweiana kampa. ");
INSERT INTO wed_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Taui au pom tonuḡa i babara ma Abraham i taepai ma gabu aueia i ʼnanai. ");
INSERT INTO wed_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ana taunola i riwei i pa, “Weka ona mae. Donki ona paini. Tau natu maiteni ana nae nore ma God ana viborumei. Ma airuaḡa ana nememei awarimi.” ");
INSERT INTO wed_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ma Abraham ai i tavana Isaac i viavarai. Tauna naipi ma ai mutuara i voai ma i negogona. ");
INSERT INTO wed_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Taui i nenae ma Isaac i riwa i pa, “Amau!” Abraham i riwa, “Ee, ma babani natu!” Isaac i riwa, “Ai ma ai mutuara awarita wate pulo aubaina sipu natuna mepa?” ");
INSERT INTO wed_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham i paribelei i pa, “Natu, God sipu ina vereta pulo aubaina.” Ma airuaḡa i babara nae. ");
INSERT INTO wed_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Maranai gabu God i ririweiana i ḡeta, kampa aniamapu ḡaimei i voai ma ai i vatari. Ma natuna Isaac urana ma aena i raḡini ma aniamapu au tepana, ai i vatavataria kampa i vimataveni. ");
INSERT INTO wed_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham urana i viloloi da naipi i vaia da natuna ita viraḡeni. ");
INSERT INTO wed_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Wate lamna maranaina Bada ana anela marei i riwa, “Abraham, Abraham!” Abraham i paribelei, “Tau weka!” ");
INSERT INTO wed_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ma Bada ana anela i riwa, “Eḡa natum ma viraḡeni! Eḡa aiwai apoapoena awarina ma kauei! Tam natum tagotago eḡa uta nuanei ma marina a aramanei da tam anina God e vivivirei.” ");
INSERT INTO wed_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham i taepai ma sipu orotona i ʼnanai, donana ai raḡaraḡai potopotona au orana i tapaiei. Ma i nae ma sipu i viraḡeni ma sia taputapuna i apui ana pulo God awarina, natuna epaiana. ");
INSERT INTO wed_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ma lamna aubaina wei dobuna i ḡorei, “Bada ina verena.” Lamna marana da marina rava e ririwa, “Bada ana au ola ina verena.” ");
INSERT INTO wed_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ma Bada ana anela marei Abraham i ḡorei ");
INSERT INTO wed_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Bada i riwa, ‘Tam u voteleteleu ma natum tagotago eḡa uta nuanei. Tau wavauei a paripari-vainuaḡanim da ");
INSERT INTO wed_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","anina ana viaiainim ma am epaepaia ana vimaḡai me ubona au mara ma bubu au gera. Taui ai ḡavia ina vovaiubai ma ai melagai ina vaia. ");
INSERT INTO wed_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ma am epaepaia wavaiei dam anatapui au dobu ana viaiaini. Tam u voteleteleu aubaina wei ana kauei.” ");
INSERT INTO wed_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ma Abraham natuna maiteni i nae me ana taunola awari ma anatapui i nae me au Beersheba. Ma kampa i mae. ");
INSERT INTO wed_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Wei lamna Abraham natuna Isaac ana virarautua. Isaac amana Abraham ");
INSERT INTO wed_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac ana madeḡa 40 ma Rebekah i ravaḡi. Rebekah tauna Leban novuna aburuna; amai Bethuel. Taui mai Aram au Padan-Aram i mamae. ");
INSERT INTO wed_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebekah aipoi ma Isaac i raupari Bada awarina da awana ita voagui. Bada ana pari i nonori ma Rebekah i duama. ");
INSERT INTO wed_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Raḡaraḡa i vivitua au manawa aubaina Rebekah i nae ma Bada i vibaḡai, “Aiwai aubaina wei e tuputupua awariu?” ");
INSERT INTO wed_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Bada i riwa i pa: “Roaroa ruaḡa au manawam ina vidam ruaḡa, ma vinatuna da dam ruaḡa ma taui ina viḡavia vivira. Tagogi ina virewapana telara ma magurina aburuna awarina ina vitaunola.” ");
INSERT INTO wed_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ana vinatuna ana mara i ḡeta ma riwa kaua da raḡaraḡa nelarai i ḡuni. ");
INSERT INTO wed_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Natuevou opina lebalebarina ma inina ororona ma lamna aubaina i viwavai Esau. ");
INSERT INTO wed_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Natuna ḡelauna i tuputupua turana au ae karena i vojijina ma i opu ma i viwavai Jacob. Isaac ana madeḡa 60 ma awana raḡaraḡa i vinatunei. ");
INSERT INTO wed_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Maranai raḡaraḡa i vilaraga, Esau tauna rava aroarona. Wate Jacob rava genugenuanana ma au numa maemaena. ");
INSERT INTO wed_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac ana ḡoana ḡaeḡaena Esau, aubaina sia moduei i vunuvunui amna i ḡoei. Wate Rebekah, Jacob i ḡoana-kauei. ");
INSERT INTO wed_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mara tagogi Jacob gwada i vivitavi ma Esau i aroaro da i nei ma inina i garigari ma am i ʼraḡe-kaua. ");
INSERT INTO wed_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ma Jacob i riwei i pa, “Tau am a iraḡe kaua. Nai gwada lebalebarina ma taraiḡui da ana ani!” (Wenanare i riwa aubaina wava i verei Edom.) ");
INSERT INTO wed_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ma Jacob i riwa i pa, “Tam natuevou, Mara muriai amata ana buderi voḡaeḡaena ma vaia. Marina ma riweu da am buderi tau ma vereu ma gwada ana verem.” ");
INSERT INTO wed_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau i riwa i pa, “Tau am a iraḡe kaua ma natuevou buderina amapo eḡa ina voaguiu, anina ma vaia!” ");
INSERT INTO wed_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ma Jacob i riwa i pa, “Marina ma parivai-nuaḡaniu da am buderi tau ma vereu.” Ma Esau i parivainuaḡana da natuevou buderina Jacob ina verei. ");
INSERT INTO wed_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ma Jacob gwada i taraiḡui ma palawa da Esau i verei ma Esau i am ma i uma ma i vomairi da i nae. Wenanare i kauei lamna Esau ana buderi eḡa ita vinuabolei. ");
INSERT INTO wed_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Gomara ḡaeḡaena i nei au Canaan, me wariaḡa Abraham ana au mara i tupua nanare. Ma Isaac ana dam maiteni i ḡaira au melagai ḡaeḡaena wavana Gerar, kampa mai Philistia ai gulau Abimelek i mae. ");
INSERT INTO wed_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ma Bada Isaac awarina i eḡa ma i riwa i pa, “Eḡa ma ḡaira au Egypt, ma dobu ana riwem kampa ma mae. ");
INSERT INTO wed_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Weka ma mae-gubai, tam maiteni ana mae ma ana viaiainim. Wei dobuna anatapuna tam ma am epaepaia ana veremi. Ma Abraham aiwai a parivainuaḡani ana kauei aubaimi. ");
INSERT INTO wed_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Am epaepaia ana vimaḡai, ai maḡa me ubona au mara ma wei dobuna anatapuna taui ana verei. Am epaepaia awariei dam anatapui au dobu ana viaiaini. ");
INSERT INTO wed_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abraham ponau i nonori ma au babani ma au viararamana ma au tarawatu i voteletelei, lamna aubaina wei ana kauei am epaepaia aubai.” ");
INSERT INTO wed_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Anina ma Isaac au Gerar i mae. ");
INSERT INTO wed_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac Jacob i kwatuei, i viaiaini ma i riwei i pa, “Eḡa au Canaan awam ma vaia, ");
INSERT INTO wed_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","wate ma vomairi ma ma nelaḡilaḡina au Padan-Aram, ḡoḡam Bethuel ana au dam ma kampa avum Leban natunatuna waivinei e mamae, kampa awam ma vaia. ");
INSERT INTO wed_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ma God Vivirewapana Kaukauana am tavine ina viaiaini ma ina viuaim ma natunatum ina vimaḡai ma tam dam borui ḡaeḡaei ina viamanem. ");
INSERT INTO wed_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ma tam am epaepaia maiteni ina viaiainim me Abraham i viaiaini nanare, da dobu marina e mamae-gubai, God Abraham i verevereia tam ma vibuderiei.” ");
INSERT INTO wed_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob Beersheba i netawanei ma i nenae au Haran. ");
INSERT INTO wed_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Madeḡa i neulai ma gabu au tagogi, i ḡeta ma i rauvirai da i matave ma ḡaima tagogi i vaia ma i viunutanei. ");
INSERT INTO wed_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ma i rauboni da tete i ʼnanai, karena au dobu ma damona au mara ma God ana anela i ḡeḡae ma i ḡaiḡaira. ");
INSERT INTO wed_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ma bada, au ririvana i maimairi ma i riwa i pa, “Tau bada, Abraham ma Isaac ai God, dobu e matamatave lana tam ma am epaepaia ana veremi. ");
INSERT INTO wed_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ma am dam ana vimaḡai da me doa pokauna ma ai parata ana viratai au lavaratei, rauanaḡei ma karuwabuei. Ma am epaepaia maiteni taumiei rava anatapui au dobu ana viaiaini. ");
INSERT INTO wed_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ma notai da tau au ririvam a mamae ma ana painim am au vaḡai. Ma ana neiana-meleiaim wei au dobuna. Eḡa ana voterem da aiwai a parivainuaḡanim ana kauei.” ");
INSERT INTO wed_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob i matave vomairi ma i riwa i pa, “Bada anina weka e mamae ma tau eḡa ata aramanei!” ");
INSERT INTO wed_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Jacob i rovo kaua ma i riwa i pa, “Wei dobuna i vinirovorovo ḡaḡa! Wei anina God ana numa, Mara ana metaeta.” ");
INSERT INTO wed_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ubaubanai boiboḡi Jacob i vomairi ma ḡaima i viviunutaneia i vaia ma i vitura-mairini da ita vimataira. Ma Olive monamonana i buloi ḡaima au tepana da i vovivirei God aubaina. ");
INSERT INTO wed_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Dobuna i ḡorei Bethel (Melagaina au naona i ḡoreḡorei Luz). ");
INSERT INTO wed_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ma Jacob, Bada awarina i parivainuaḡana, “Mepa da tam au ririvau ma mae ma ma inana vaiteteu au vaḡai, lam ma gara ma vereu. ");
INSERT INTO wed_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Ma lawalawaiu ana nememei amau awarina, lamna maranaina Tam tau au God. ");
INSERT INTO wed_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ma wei matairana a tereterei, weka ana viborumem, Ma aiwai u verevereu ana gimai da ḡuta 10 ma ḡuta tagogi ana veremelem.” ");
INSERT INTO wed_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jacob, Padan-Aramei i nememei au Bethel. God i eḡa me Jacob awarina ma i viaiaini ");
INSERT INTO wed_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ma i riwei i pa: “Tam wavam Jacob, wate marina eḡa ina ḡorei Jacob ma wavam vouna Israel.” Ma i viwavai Israel ");
INSERT INTO wed_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ma i pa: “Tau God Vivirewapana Kaukauana Ma vinatuna guratana ma ma vimaḡaimi Am epaepaia ina virava-ḡaeḡaei ma dam borui ḡaeḡaei awarimei ina tupua ma gulagulau maḡamaḡaui ina viamanei. ");
INSERT INTO wed_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Dobu, Abraham ma Isaac a verei, marina tam ana verem ma am epaepaia muriai wei dobuna ana verei.” ");
INSERT INTO wed_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ma God i babani vorovei ma i netawanei. ");
INSERT INTO wed_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","God weka Jacob awarina i babani lamna matairana Jacob gana i vimairini. Ma au tepana wine i waḡi ana pulo ma Olive monamonana i buloi. ");
INSERT INTO wed_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Weka God Jacob awarina i babani ma lamna aubaina wei gabuna i ḡorei Bethel. ");
INSERT INTO wed_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Muriai Jacob ana dam maiteni Bethel i voterei ma i vaḡai, ma taui uama i rata da au Ephrath ita ḡeta. Ma Rachel malana i vaia da ina vinatuna ma vinatuna i voiana-guratei ma ana iniviara i rata kaua. ");
INSERT INTO wed_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ma i voivoia ma iniviara i rata ma tauvipipiavoa i riwa, “Eḡa ma rovo! Tevera orotona ḡelauna i tupua!” ");
INSERT INTO wed_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Wate Rachel iʼrairaḡe ma ana lavutu au damona ma tevera i viwavai “Ben-Oni.” Wate amana i viwavai, “Benjamin.” ");
INSERT INTO wed_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ma Rachel i ʼraḡe ma eta e nenae au Ephrath (marina wavana Bethlehem) au ririvana i doboi. ");
INSERT INTO wed_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ma Jacob gana i vimairini Rachel ana kokoaga au tepana da i vimataira. Matairana amadodo e mamae. ");
INSERT INTO wed_vpl VALUES ("GN35_22b","002_35_22b","GEN","35","22b","22b","Jacob natunatuna nelarai 12: ");
INSERT INTO wed_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leah natunatuna: Reuben; Jacob ana natuevou Simeon, Levi, Judah, Isakar, ma Zebulun. ");
INSERT INTO wed_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rachel natunatuna: Joseph ma Benjamin. ");
INSERT INTO wed_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilhah - Rachel ana taunola wavine natunatuna: Dan ma Naphtali. ");
INSERT INTO wed_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpah - Leah ana taunola wavine natunatuna: Gad ma Asher. Wei lamna Jacob natunatuna anatapui au Padan-Aram i ḡuni. ");
INSERT INTO wed_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ma Jacob i nememei amana Isaac awarina au Mamre au Kiriath-Arba; marina e ḡoreḡorei Hebron. Abraham ma Isaac wariaḡa wei dobuna i mae-gubai. ");
INSERT INTO wed_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac i mae da ana madeḡa 180 ");
INSERT INTO wed_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ma i magura kaua, i lavutu tawanana ma iraḡe ma amamana i votaḡoi. Natunatuna Esau ma Jacob amai i doboi. ");
INSERT INTO wed_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob ana dam maiteni kampa i mae, wariaḡa amana weka i mae, mai Canaan ai au dobu. ");
INSERT INTO wed_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Wei lamna Jacob natunatuna maiteni ai virarautua. Joseph tauna laraga ana madeḡa 17. Tauna tuatuana maiteni, amai awawana Bilhah ma Zilpah natunatui, amai ana sipu ma gote i paipaini. Wate Joseph tuatuana ai kaua apoapoe ḡelaui amai i vibenabenamei. ");
INSERT INTO wed_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jacob ana au magura Joseph i tupua ma lamna aubaina natuna nuanuana i vai-kauei, eḡa me natunatuna ḡelaui nanare. Ma gara girugirumana, maiana ḡaeḡaena i kauei ma Joseph i verei. ");
INSERT INTO wed_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Maranai tuatuana i ʼnanai da amai Joseph i ḡoana-guratei eḡa me taui, ma ai ora-apoapoe ai tevera awarina i rata ma eḡa ita bababani kaua awarina. ");
INSERT INTO wed_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Waguvara tagogi Joseph i rauboni ma maranai tuatuana ana rauboni i riwei, taui ai ora-apoapoe i virata-guratei. ");
INSERT INTO wed_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Joseph i riwa, “Ona rautaniḡana ma au rauboni ana riwemi. ");
INSERT INTO wed_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Anataputa au wapu witi ta bawabawai. Ma tau au bawa au pouna i mairi ma taumi ami bawa i kwaviviroi ma i raudunelei!” ");
INSERT INTO wed_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ma tuatuana i riwa, “Tam u notai da ma vibada bo? Ma tam ma vibadelai bo?” Ma Joseph ana babani ma ana rauboni aubaina taui amloi i ḡaiḡai guratana. ");
INSERT INTO wed_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mara tagogi Joseph tuatuana amai ana sipu ma gote i taravaini ma i naiei au Shekem ma kampa i paini. ");
INSERT INTO wed_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ma Israel (wavana ḡelauna Jacob) Joseph i riwei i pa, “Tuatuam au Shekem sipu ma gote e paipaini. A ḡoem da ma nae taui awari.” Joseph i vianina ma i riwa, “Anina ana nae.” ");
INSERT INTO wed_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Amana i riwa i pa, “Ma nae tuatuam ma ḡamoḡamo ma i ʼnanai, taui anina bo eḡa, ma ma nememei da ma riweu.” Ma Joseph i paritawanei. Hebron wapuna i netawanei ma i nae. Maranai au Shekem i ḡeta, ");
INSERT INTO wed_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ma kampa au wapu i kwavikwaviviro ma oroto tagogi tauna i ʼnanai ma i riwei, “Aiwai e baibaiei?” ");
INSERT INTO wed_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph i paribelei, “Tau tuatuau a baibaiei, taui ai sipu ma gote e paipaini. Uta riweu taui mepa?” ");
INSERT INTO wed_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tauna i paribelei i pa, “Taui i nae. A nonori i bababani i pa, ‘Tana nae au Dothan.” Anina ma Joseph tuatuana i votaḡoi da au Dothan i nelaḡai. ");
INSERT INTO wed_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Maranai tuatuana matai i tawanei ma Joseph i ʼnanai i nenei ma i aramanei da tauna. Muriai da ita ḡetai taui ai oga i tarai da tauna ita viraḡeni. ");
INSERT INTO wed_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Taui i babani vivira i pa, “Taurauboni e nenei. ");
INSERT INTO wed_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ona nei tana vunui ma waira dogona paipairana au orana tana tawana ḡairei. Ma tana riwa da ḡamoḡamo moduei tauna i viraḡeni. Ma tana inanai ana rauboni mena ina ḡoa.” ");
INSERT INTO wed_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Wate Reuben ai ogatara i nonori, ma i ḡoei da ana tevera ita gagaloei ma i riwa i pa, “Eḡa ana lawana tana vaitawanei.” ");
INSERT INTO wed_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","“Eḡa tana viraḡeni. Tana tawana ḡairei waira dogona paipairana au orana weka au mutulua ma eḡa tupuana tana vodadani.” Reuben wenanare i babani aubaina i ḡoei da ana tevera ita naiana-melei amana awarina. ");
INSERT INTO wed_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Maranai Joseph i ḡeta tuatuana awarii, tauna i vojijini ma ana gara girugirumana i ḡiḡi-tawanei. ");
INSERT INTO wed_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ma i vaia ma i tawana ḡairei waira dogona au orana. ");
INSERT INTO wed_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ma taui i kiala da i amam ma i taepai da dam mai Ishmael i ʼnanai au Gilead da i nenae au Egypt. Taui ai gimara lam anitavidagiai ma bunama mur au kamel i vigerui. ");
INSERT INTO wed_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah varevareina i riwei i pa, “Aiwai aiaina tana vaia mepa da ata tevera tana viraḡeni ma tana moru. ");
INSERT INTO wed_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ona nei ma tana gimarei dam mai Ishmael awarii ma eḡa urataiei tarana ina toi, tauna ata tevera, tara tagogi.” Ma varevareina i vianina. ");
INSERT INTO wed_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ma maranai taugimara mai Midian i ḡetai, Joseph tuatuana tauna dogoei i taina-epai ma i gimarei mai Ishmael awarii maiana silva 20 ana ruva nanare ma taui i naiei au Egypt. ");
INSERT INTO wed_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Muriai Reuben i nememei da au dogo i ʼnana ḡaira, ma Joseph kampa eḡa ma i vinuabola kaua ma ana gara i sikai. ");
INSERT INTO wed_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ma i nae me ana roaroa awari ma i riwa, “Ata tevera kampa eḡa. Aiwai ana kauei?” ");
INSERT INTO wed_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Anina ma taui gote i vunui ma au tarana ana gara i virai. ");
INSERT INTO wed_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ma ana gara i naiei amai awarina ma i riwei i pa, “Tauai wei garana a nelaḡai. Ma inanai wei natum ḡarinei bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Amai gara i ʼnanai ma i riwa, “Anina wei tau natu ana gara. Ḡamoḡamo ḡaḡaiawai natui i vunui. Oo natu! Ḡamoḡamo natu i uta-sikasikai.” ");
INSERT INTO wed_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ma Jacob i vinuabola kaua ma ana gara i sikai. Ma ḡamoḡamo opina i oteni ma natuna i moguei da nawaravi biaḡa i kwa. ");
INSERT INTO wed_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ana numa ravai i nae awarina da ita vinuaubai. Wate tauna vinuauba i geduaiei ma i riwa i pa, “Ana tou ma natu ana moguei da au dogo ina tereḡaireu ma ana nae mepa natu i nenelana.” Ma natuna i touei. ");
INSERT INTO wed_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Dam mai Ishmael Joseph i ḡairei au Egypt, ma Potiphar tauna i gimarai da ana taunola. Potiphar tauna Egyptei ma sorodia ai bada ḡaeḡaena. ");
INSERT INTO wed_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Bada Joseph i mae-ratui ma i voagui da anatapuna aiaina i kaukauei ana bada aubaina. Tauna Potiphar ana au numa i mae. ");
INSERT INTO wed_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potiphar i ʼnanai da Bada Joseph i mae-ratui ma i voagui da aiwai anatapuna i kauana-kauei, ");
INSERT INTO wed_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ma wei Potiphar i vinuaiaiei ma Joseph i terei da tauna aubaina ina nola, ma ana taunola numa au orana, ma ana purapura anatapuna ina vibadei. ");
INSERT INTO wed_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nai marana da i nenai, Joseph awarinei ma Bada Potiphar ana numa orana ravai ma ana purapura anatapui au numa ma ana au wapu i viaiaini.");
INSERT INTO wed_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Anina ma Joseph vaivai i verei da Potiphar ana purapura anatapui i paini, ma ana bada ana nola da am ava ina paipaini. Joseph i tupua da karawata ma inanana aiaina. ");
INSERT INTO wed_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kampa eḡa ita mae-pora ma ana bada awana Joseph i ʼnana rauoḡarei ma i riwei i pa, “Ma nei tana matave.”");
INSERT INTO wed_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Wate Joseph i geduai ma wavine i riwei i pa, “Ma i ʼnana, tau au bada weka i tereu da a vivipaipai ma lamna aubaina tauna eḡa aiwai numa au orana ina vinuabolei. Tauna ana purapura anatapuna au urau i terei. ");
INSERT INTO wed_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tau au rewapana wei au numana nanare tauna, ma eḡa aiwai ita nuanei anina tam ainelam. Menanare da kaua apoapoena ana kauei da God au matana au ḡoa ina apoapoe.” ");
INSERT INTO wed_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Wavine marana patapatai Joseph i rarauelari da maiteni ita matave, wate Joseph i gedugeduai ma i nene-tawanei.");
INSERT INTO wed_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mara tagogi Joseph i nae au numa da ita nola, ma kampa eḡa taunola ḡelaui. ");
INSERT INTO wed_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ma Potiphar awana i nae ma Joseph ana au kareko i voa ma i riwa i pa, “Ma nei tana matave!” Wate Joseph i ruba-opu au doa ma kareko wavine au urana i voterei.");
INSERT INTO wed_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Wavine i ʼnanai da Joseph i ruba-opu ma ana gara au urana i voterei, ");
INSERT INTO wed_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ma wavine ana taunola i kwatuei da i nei ma i riwa i pa, “Weka ona inana! Wei Hebreweina awau i neiai awarita, i vinameta. I nei awariu ma i ḡoei da ita viawawaneu wate tau garara a vikarei. ");
INSERT INTO wed_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ma i nonori a garagarara ma i ruba-opu ma ana kareko i ruba-tawanei.”");
INSERT INTO wed_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ma wavine kareko i paini da awana i nememei au numa. ");
INSERT INTO wed_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ma wavine riwana tagogina awana i riwei i pa, “Wei Hebreweina tam u neiai awarita, i vinameta. I nei ma i ḡoei da ita viawawaneu. ");
INSERT INTO wed_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Wate maranaina a garagarara, tauna i ruba-opu ma ana kareko au ririvau i voterei.”");
INSERT INTO wed_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potiphar awana ana babana i nonori ma amlona i ḡaiḡai kaua. ");
INSERT INTO wed_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Anina ma tauna Joseph i vaia ma panipani au numana i tawana-ruiei, mepa gulau ana panipani e mamae ma kampa i mae. Maranai Joseph au panipani-numana ");
INSERT INTO wed_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Bada Joseph i mae-ratui ma i viaiaini, lamna aubaina da panipani taupainina Joseph i vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ma tauna Joseph i terei da panipani ravai ita vibadei ma nola au urana i terei. ");
INSERT INTO wed_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Panipani taupainina ana nuabola eḡa aiwai, aubaina Joseph aiwai anatapuna i paipaini. Ma Bada tauna i mae-ratui ma i voagui da aiwai anatapuna i kauana-kauei. ");
INSERT INTO wed_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ma mara tagogi Pharaoh ana wine taupainina ma palawa tauapuina babadai, i kauana-boai Pharaoh awarina. ");
INSERT INTO wed_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh amlona i ḡaiḡai babadai ruaḡai awari. ");
INSERT INTO wed_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ma i vaia ma panipani au numana i terei mepa Joseph i mamae lana, sorodia ai bada ana au numa. ");
INSERT INTO wed_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sorodia ai bada wei ruaḡai i naiei Joseph awarina ma tauna ravai i paini. Taui i mae-guratana au panipani numana. ");
INSERT INTO wed_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Waguvara tagogi babadai ruaḡai panipani au numana i rauboni. Ma ai rauboni anoi taputapunei ava. ");
INSERT INTO wed_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ma ubaubanai maranai Joseph i nei awari ma i ʼnanai da taui eḡa ita vinuaiai. ");
INSERT INTO wed_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ma ruaḡai i paridadanei, “Aiwai aubaina naomi i peu?” ");
INSERT INTO wed_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Taui i paribelei, “Tauai airuaḡa a rauboni ma eḡa aiai da ai rauboni anona ita vieḡelai.” Joseph i riwa, “God ainelana rauboni e vivieḡai. Ami rauboni ona riweu.” ");
INSERT INTO wed_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Anina ma wine taupainina ana rauboni Joseph i riwei, “Au rauboni au orana grape ḡoroḡorovana a inanai au naou. ");
INSERT INTO wed_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ma ḡoroḡorovana raḡaraḡana tonuḡa. Ma i raurugu ma i talai ma anona tapina i magura. ");
INSERT INTO wed_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh ana aniuma kelakana a vovojijini ma grape a purai ma au kelaka a buloi da Pharaoh a verei.” ");
INSERT INTO wed_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ma Joseph tauna i riwei, “Am rauboni anona wei. Grape raḡaraḡana tonuḡa, anona lamna au pom tonuḡa. ");
INSERT INTO wed_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Au pom tonuḡa au murina, Pharaoh ina tere-opunem ma am au nola ina tere-melem. Ma tam, Pharaoh ana aniuma kelakana au urana ina tere-melei, me au noana nanare. ");
INSERT INTO wed_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Wate maranai wei gabuna u opu-tawanei ma aiwai anatapuna ina ai-me. Tau ma notaiu, am i viaiai ma kauei da au nuabola Pharaoh ma pariverei da panipani-numanei ina tere-opuneu. ");
INSERT INTO wed_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Pharaoh ma riwei aiwai awariu i tupua. Mai Hebrew ai au dobu i daneneu ma weka i neiaiu, wate tau eḡa aiwai ata kauana-boai ma weka au dogo i tawaneu.” ");
INSERT INTO wed_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ma palawa tauapuina i ʼnanai da Joseph nuaiai riwana i vieḡai ma i riwa, “Tau nanare a rauboni. Palawa irigana tonuḡa au kolau a terei. ");
INSERT INTO wed_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Iriga au tepana, lamna palawa apuapunana tapuna ma tapuna Pharaoh aubaina, wate kiu i nei ma au kolau, au iriga palawa i amam.” ");
INSERT INTO wed_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph i paribelei i pa, “Am rauboni anona wei. Iriga tonuḡa lamna au pom tonuḡa. ");
INSERT INTO wed_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Aupom au vitonuina, Pharaoh panipani-numanei ina tere-opunem da uam ina borituini ma tupuam ai au tepana ina vitakei ma kiu ina nei ma vioam ina ani.” ");
INSERT INTO wed_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ma au pom au vitonuina, lamna Pharaoh ana tupua marana ma torela ḡaeḡaena i kauei, ana gabemani babadai aubaii. Ma ana wine taupainina ma palawa tauapuina panipani-numanei i tere-opunei ma i neiai Pharaoh awarina, ana gabemani babadai au matai. ");
INSERT INTO wed_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ana wine taupainina, ana au nola i tere-melei me au naona nanare. Ma tauna, Pharaoh ana aniuma kelakana au urana i tere-melei. ");
INSERT INTO wed_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Wate ana sorodia i egari da ana palawa tauapuina uana i borituini ma tupana ai au tepana i vitakei. Joseph menanare rauboni i vivieḡanei, nanare i tupua. ");
INSERT INTO wed_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Wate wine taupainina, Joseph nuanuana i vuru ma eḡa ita vinua-notenotei. ");
INSERT INTO wed_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ma madeḡa ruaḡa i kwa, ma Pharaoh i rauboni da tauna waira Nile au adana i maimairi. ");
INSERT INTO wed_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ma bulumakau 7 aiaii ma dododoi wairei i ḡeta ma waira au adana gidagida i amam. ");
INSERT INTO wed_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ma bulumakau 7 apoapoei ma kirakiramai wairei i ḡetai da bulumakau aiaii au ririvai i raumairiei waira au adana. ");
INSERT INTO wed_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bulumakau 7 apoapoei ma kirakiramai i vomairi da bulumakau 7 aiaii ma dododoi i lawana-pai. Anina, ma Pharaoh matana i kala. ");
INSERT INTO wed_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ma i matave me ma mara viruaina i rauboni da witi aina tagogi ma rovei 7 aiaii ma dododoi i ʼnanai. ");
INSERT INTO wed_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Anina ma witi rovei 7 muriai i gogogo wate rauanaḡa i ravi da i jinajina. ");
INSERT INTO wed_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ma witi rovei jinajinai 7 i vomairi da witi rovei dododoi 7 i lawani. Anina ma Pharaoh matana i kala ma i aramanei da i rauboni. ");
INSERT INTO wed_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ubaubanai Pharaoh nuanuana i bolai ma riwa i paritawanei da rauboni tauvieḡai ma nuaulaulai anatapui au Egypt i nei. Ma ana rauboni i riwei ma eḡa aiai ravana da ana rauboni anona ita vieḡei. ");
INSERT INTO wed_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ma wine taupainina Pharaoh i riwei, “Amadodo ana rupena da tau a kauana-boai. ");
INSERT INTO wed_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mara tagogi tam amlom i ḡaiḡai palawa tauapuina ma tau awariu, da u paniai ma sorodia ai bada ana au numa a mae. ");
INSERT INTO wed_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ma waguvara tagogi tauai tagotagogi ava a rauboni ma ai rauboni anoi taputapunei ava. ");
INSERT INTO wed_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Laraga Hebrewei kampa tauai maiteni, tauna sorodia ai bada ana taunola. Ai rauboni a riwei ma tauna ai rauboni anona i vieḡelai ");
INSERT INTO wed_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma tauna aiwai i ririweia nanarena i tupua. Tau u tere-meleu au au nola ma palawa tauapuina u viraḡeni.” ");
INSERT INTO wed_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ma Pharaoh, Joseph ana riwa i paritawanei ma panipani-numanei laḡilaḡina i neiai. Joseph i viamḡari ma ana gara aiaina i oteni. Ma i naiei Pharaoh awarina. ");
INSERT INTO wed_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ma Pharaoh Joseph i riwei, “Waguvarai a rauboni ma eḡa aiai au rauboni anona ita vieḡeu. Wate rava i riwa da maranai tam rauboni e nononori, lamna anona e vivieḡai.” ");
INSERT INTO wed_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph i paribelana, “Tau eḡa tagotagogina, wate God am rauboni anona ina verem da oram ina viubai.” ");
INSERT INTO wed_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph i paribelei, i pa, “Oo bada, rauboni ruaḡai anoi tagogina. God aburuna ava da aiwai ina kauei lamna gulau i viatataiei. ");
INSERT INTO wed_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulumakau dododoi 7, ma witi rovei aiaii 7, lamna maura madeḡana 7. ");
INSERT INTO wed_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bulumakau kirakiramai 7 muriai i nei, ma witi rovei jinajinai 7, lamna anona amapo madeḡana 7 au orana gomara. ");
INSERT INTO wed_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","—Aiwai a ririweia, nanare ina tupua. God i viatataiem da aiwai ina kauei. ");
INSERT INTO wed_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Madeḡa 7 au orana, lamna maura ḡaeḡaena Egypt au anatapuna. ");
INSERT INTO wed_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Wate au murina, gomara ḡaeḡaena ina mae da madeḡa 7 da Egypt ana maura marana rava nuanuai ina vuru ma gomara rava ina vipupui. ");
INSERT INTO wed_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Gomara ina rata kaua da maura marana nuanuata ina vuru. ");
INSERT INTO wed_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","God i vianina da wei ina tupua ma eḡa barana ina uama, lamna aubaina rauboni ruaḡa i verei. ");
INSERT INTO wed_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","—Au bada, tam, oroto nuaulaulana ma notanotana uta vinei da Egypt ita vibadei. ");
INSERT INTO wed_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Wei uta kauei, babada uta terei Egypt au anatapuna da tuaruta au marana ḡuta vi-five-na ita vaia madeḡa 7 maura au marana. ");
INSERT INTO wed_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ma rewapana ma verei da au maura, taui lam ina tami da au anara ina vidamni ma ina paini. ");
INSERT INTO wed_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Wei lamii ina tereriei rava aubaii maranai madeḡa 7 gomara au Egypt ina nei. Ma wei taunei, mai Egypt eḡa am ina iraḡe.” ");
INSERT INTO wed_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Anina, ma Pharaoh ana gabemani maiteni oga-tarana i vianinei. ");
INSERT INTO wed_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ma i riwei i pa, “Mepa rava ḡelauna tana nelaḡai me Joseph ma God Aruana tauna au orana e mamae?” ");
INSERT INTO wed_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Anina ma Pharaoh, Joseph i riwei, “God wei anatapuna i viatataiem, eḡa aiai ḡelauna nuaulaulana ma notanota kauana me tam. ");
INSERT INTO wed_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tam ana terem da au dobu ma vibadei ma au rava anatapui am riwa ina voteletelei. Tau Pharaoh, ma am rewapana tau ainelau au rewapana eḡa ina ḡetawanei.” ");
INSERT INTO wed_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ma Pharaoh i riwa, “Marina tau a vinem da Egypt anatapuna ma vibadei.” ");
INSERT INTO wed_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ma Pharaoh au urana ana vigulau ringna i votawanei ma Joseph au urana i terei, ma gara maiana ḡaeḡaena i vioteni ma sein goldei au uana i tere-taḡonei. ");
INSERT INTO wed_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ma Pharaoh Joseph wava Zaphenath-Paneah, i verei ma mai On ai pirisi Potiphera natuna guguinina Asenath, Joseph i verei da awana. Anina ma Joseph, dobu Egypt i vibadei. ");
INSERT INTO wed_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph ana madeḡa 30 ma wei vibadana i vaia. Ma Joseph, Pharaoh i netawanei ma Egypt i naeni ma i tuvirevirei. ");
INSERT INTO wed_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Maura ḡaeḡaena i nelaḡai madeḡa 7 au orana. ");
INSERT INTO wed_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Joseph ai maura ḡelaui i tami maura madeḡana 7 au orana au Egypt, ma au melagai nununai i tere-kauei ma i paini. Melagai anatapui ai lam au anara i terei. ");
INSERT INTO wed_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph lam i vidamni da olana i mairi me bubu au gera ma iavana i kauana-avei aubaina lam i rata dewadewa. ");
INSERT INTO wed_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ma maura madeḡana 7 au Egypt au damona i ḡeta. ");
INSERT INTO wed_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ma gomara madeḡana 7 i raukarei, me Joseph i ririweia nanare. Gomara dobu au anatapuna, wate Egypt au anatapuna lam i mamae. ");
INSERT INTO wed_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Maranai mai Egypt raumolaḡau i vikarei, taui Pharaoh i vibaḡai lam aubaina. Ma taui i riwei da ita nae Joseph awarina ma tauna aiwai i ririweia ita kauei. ");
INSERT INTO wed_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","57","Maranai gomara Egypt anatapuna i vaia, Joseph anara i votawatawanei ma lam mai Egypt awari i gimarei. Anina ma gomara i rata kaua dobu au anatapuna da rava anatapui i nei Joseph awarina au Egypt lam gimarana aubaina. ");
INSERT INTO wed_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ma au Canaan Jacob i nonori da au Egypt lam ma natunatuna nelarai i riwei, “Aiwaina da o mamae labalababa? ");
INSERT INTO wed_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Anina ona rautaniḡana! A nonori da lam au Egypt. Ona ḡaira kampa ma aubaita lam ona gimarai da tana lawana ma eḡa tana iraḡe.” ");
INSERT INTO wed_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Anina ma Joseph varevareina ten i ḡaira au Egypt da lam ita gimarai. ");
INSERT INTO wed_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Wate Jacob eḡa Joseph ana tevera oiena Benjamin ita paritawanei aubaina i rovo mepa da aiwai apoapoena awarina ita tupua. ");
INSERT INTO wed_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Taui rava ḡelaui maiteni i nae au Egypt da lam ita gimarai aubaina gomara ḡaeḡaena dobu Canaan maiteni i vaia. ");
INSERT INTO wed_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph i vibada ḡaeḡaena au Egypt ma tauna lam i gimagimarei dobu anatapui ravai awari. Varevareina i ḡetai ma Joseph au naona i mae-ḡaira au doa ma i raudune. ");
INSERT INTO wed_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph taui i ʼnanai ma maratagogi i aramanei da taui aiavoi ma i kauana-melei da apamina taui eḡa ita aramanei. Ma riwa bagibaginei i vitara-virevirei, “Taumi meiei o nei?” Taui i paribelei, “Tauai Canaanei a nei da lam ata gimarai.” ");
INSERT INTO wed_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph tuatuana i ʼnanai da i aramanei, wate taui ai tevera i vinua-nainei. ");
INSERT INTO wed_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ma ana rauboni wariaḡana i notai ma i riwei, “Taumi i paritawanemi da ai dobu ana ḡokokokara ota inanai bo.” ");
INSERT INTO wed_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Taui i paribelei, “Oo bada eḡa! Tauai am laralaraga a nei da lam ana gimarai.” ");
INSERT INTO wed_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ma taui i babani vivira, “Nai maranaina ata tevera ana ora-viarana agu i toutouei awarita ma, eḡa tata rau-nuʼapoapoelei. Tauta ata wavu lamna kovoḡana marina ta vaivaia.” ");
INSERT INTO wed_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben i paribelei, “Nai maranaina a riwemi, ‘Eḡa ata tevera ona vodadani!’ Wate taumi eḡa ota rautaniḡaneu. Marina ata tevera tarana kovoḡana ta vaivaia.” ");
INSERT INTO wed_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Joseph Egypt ponanei i bababani ma rava ḡelauna taui ai ponei i paripari-verei. Wate taui eḡa ita aramanei da Joseph ai babani i nononori. ");
INSERT INTO wed_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph varevareina i riwei, “Ona nei au ḡereḡereu.” Ma taui i nei au ḡereḡerena. Ma i babani, i pa, “Tau ami tevera Joseph, mai Egypt awari o gimareu. ");
INSERT INTO wed_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Wate eḡa orami ina bolai, ma eḡa ami rava maiteni tau o gimareu aubaina ona viamparipari. Wate God au naona i paritawaneu da rava ata vilawani. ");
INSERT INTO wed_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Wei gomarana dobu e viviapoapoeni marina madeḡa ruaḡa i kwa. Wate madeḡa five ḡelauna e mamae da eḡa tana ipi bo tana tuaruta. ");
INSERT INTO wed_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God i aipari-tawaneu da taumi ma ami dam ravai maiteni ata vilawanimi, ma ami dam avena ita pupu. ");
INSERT INTO wed_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ma eḡa taumi weka ota paritawaneu wate God, ma tauna i tereu da Pharaoh ana taunola ai bada ḡaeḡaena ma ana numa ma aiwai anatapuna au Egypt a vivibadei. ");
INSERT INTO wed_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Marina laḡilaḡina ona nae me amau awarina ma ona riwei, ‘Natum Joseph wenanare i riwa, God i tereu da Egypt anatapuna a vivibadei, ma tam laḡilaḡina ma ḡairai awariu. ");
INSERT INTO wed_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tam au ḡeḡereu ma mae au Goshen; ma nanare natunatum ma ḡoḡoḡam ma am ḡamoḡamo ma aiwai anatapuna ḡarimei. ");
INSERT INTO wed_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Gomara madeḡana five amapo e mamae, aubaina tau lam ana verem. Mepa da wei eḡa ana kauei tam ma am dam ma am laraga ma am ḡamoḡamo anatapui ina vinuapoapoe ma ina raumolaḡau.” ");
INSERT INTO wed_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Anina ma Joseph tuatuana Egypt i opu-tawanei ma i nae me amai Jacob awarina au Canaan. ");
INSERT INTO wed_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ma taui Jacob i riwei, “Natum Joseph lawalawaina e mamae, ma tauna marina Egypt e vivibadei.” Jacob i vinuanaina ma nai babani eḡa ita vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Wate taui aiwai anatapuna Joseph i ririweia amai i pariverei. Ma Joseph ana anigeru i paritawanei da Jacob ita vigerui da ita naiei au Egypt. Maranai wei i ʼnanai, Jacob ana nota i nememe. ");
INSERT INTO wed_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","I pa, “Tau marina a aramanei da natu lawalawaina e mamae, ma ana nae da ana inanai ma muriai da ana iraḡe.” ");
INSERT INTO wed_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Anina ma Jacob ḡarinei anatapuna maiteni i nae au Egypt. Ma au Beersheba i ḡeta, ma kampa pulo i apui amana Isaac ana God awarina. ");
INSERT INTO wed_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ma waguvarai God rauboniei awarina i babani i pa, “Jacob! Jacob!” Ma tauna i paribei, “Tau weka.” ");
INSERT INTO wed_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","God i riwa, “Tau God, amam ana God. Egypt ḡairana eḡa ma rovoei, aubaina tau am epaepaia ai dam boruna ana vimaḡai kampa. ");
INSERT INTO wed_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Tau maiteni tana nae au Egypt ma am epaepaia ana neiana-meleiai wei au dobuna. Joseph amapo au ririvam, maranai ma iraḡe.” ");
INSERT INTO wed_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob, Beersheba i voterei, ma natunatuna nelarai amai i vojijini, ma anatapui awawai ma natunatui maiteni, au anivigeru Pharaoh i paripari-tawaneiana i geru. ");
INSERT INTO wed_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Ai ḡamoḡamo ma ḡariei anatapuna au Canaan i vaivainia i naiei au Egypt. Anina ma Jacob, natunatuna nelarai ma waivinei ma ḡoḡoḡai ma ana numa ravai anatapui i nae au Egypt. ");
INSERT INTO wed_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob Judah i aiparitawanei au Egypt da Joseph ita riwei da au Goshen ita nebelei. Maranai i ḡeta. ");
INSERT INTO wed_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph ana chariot i gerui ma i nae au Goshen. Maranai amana i nebelei, i taragwabai ma i tou guratana. ");
INSERT INTO wed_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jacob Joseph i riwei, “Naom a inanai ma a aramanei da tam lawalawaim, marina ana nuaubau ana iraḡe.” ");
INSERT INTO wed_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Wei kauai au murina, rava Joseph i riwei, “Amam i doria.” Anina ma natunatuna Manasseh ma Ephraim i taravaini ma i nae amana da ita inanai. ");
INSERT INTO wed_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Rava tagogi Jacob i riwei, “Natum Joseph i ḡetai da ina inanaim.” Jacob doridoriana ma i voguratei da i vomairi ma ana animatave au tepanai i kiala. ");
INSERT INTO wed_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Anina ma Jacob natuna Joseph i riwei, “God Vivirewapana Kaukauana awariu i eḡa au Luz (Bethel) au Canaan ma i viaiainiu. ");
INSERT INTO wed_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ma i riweu, ‘Natunatum ana vimaḡai ma am epaepaia ai dam ana viratai; wei dobuna am epaepaia ana verei da ina viḡariana-nonoei.’ ");
INSERT INTO wed_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","—Ma lamna aubaina ḡoḡoḡau ruaḡa Manasseh ma Ephraim au Egypt tuputupuai muriai da a nei; lamna tau ana vaia da natunatu me natunatu Reuben ma Simeon. ");
INSERT INTO wed_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Roaroa muriai e tuputupua lamna tam ḡarimei; ma ai buderi Ephraim ma Manasseh awariei ina vaia.” ");
INSERT INTO wed_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Anina ma Joseph natunatuna ruaḡa i neiai Jacob awarina, Ephraim amana au oiena lamna Jacob au kelakelauna ma Manasseh amana au kelakelauna lamna Jacob au oiena ");
INSERT INTO wed_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Wate Jacob uraoiena i tere-taḡonei ma Ephraim au kolana i terei avena da tauna umau, ma ura-kelakelauna i tere-taḡonei da Manasseh au kolana i terei avena da tauna natuevou. ");
INSERT INTO wed_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Anina ma Joseph i viaiaini i pa, ");
INSERT INTO wed_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ma am anela taugagaloeu au anatapuna wei roaroai ma viaiaini! ");
INSERT INTO wed_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Wate maranai Joseph i ʼnanai da amana aiwai i kaukauei ma tauna eḡa ita vinuaiai; ma amana urana Ephraim au kolana ita vaitawanei ma Manasseh au kolana ita terei. ");
INSERT INTO wed_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph amana i riwei, “Amau eḡa nanare. Wei tauna natuevou uraoiem au kolana ma terei.” ");
INSERT INTO wed_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Wate Amana i riwa, “Natu! Tau a aramanei aiwai a kaukauei. Manasseh maiteni ana dam ina rata kaua. Wate ana tevera wavana ina rata ma ana dam ina rata dewadewa eḡa me tuana.” ");
INSERT INTO wed_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Anina ma Jacob roaroa nai marana i viaiaini i pa, “Mai Israel wavam ina latoni maranai e viviaiaina, taui ina riwa, ‘Tauai a raraupari da God ina viaiainim me Ephraim ma Manasseh i viaiaini nanare.” Wenanare lamna Ephraim wavana i ailatoni ma muriai Manasseh wavana. ");
INSERT INTO wed_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ma Israel, Joseph i riwei, “Tau aburuna ava da ana iraḡe. Wate God awarim ina mae da ina naiana-melem au Canaan, amamam ai au dobu.” ");
INSERT INTO wed_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, varevareim ina voepaepaim, ma amam natunatuna ina raudunelem aubaina tam am ḡavia au uai ma voa ma ma vovaiubai. ");
INSERT INTO wed_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah natu, tam me lion natuna, ana sia i am vorovei da i amruruna ma e matamatave, eḡa aiai ana matave ina viapoapoeni! ");
INSERT INTO wed_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Gulau ana jiḡona Judah ina vojijini ma ana epaepaia ina vibada nonoa, anina da jiḡona taniwagana ina nei maranaina dobu anatapui ravai tauna ina raudunelei ma ina viborumei.” ");
INSERT INTO wed_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ma Jacob natunatuna awarii i babani vorovei, ma tauna ana au animatave i rauvirai ma i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ma maranai Jacob i ʼraḡe, Joseph tuatuana i rovo ma i riwa, “Mepa da Joseph amlona ina ḡaiḡai ma ina raubiwa, kaua apoapoena awarina ta kauei aubaina.” ");
INSERT INTO wed_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ma lamna aubaina riwa i paritawanei Joseph awarina i pa, “Amata maeninai ma wenanare i riwelai i pa, ");
INSERT INTO wed_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Joseph wenanare ona riwei, “Tuatuam kaua apoapoe kaukauana awarim i kauei. Wate a ḡoei da ai kaua apoapoe ma nota-tawanei.” “Tauai amam ana God a vovoepaepai, ma a vivibaḡa-guratem da ai ḡoʼapoapoe ma nota-tawanei.” Maranai Joseph wei riwana i nonori tauna orana i viara kaua ma i tou. ");
INSERT INTO wed_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Anina ma tuatuana i nei ma au naona i mae-peu ma i riwa, “Ma inanaiai tauai am taunola a nei.” ");
INSERT INTO wed_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Wate Joseph taui wenanare i riwei, “Tau eḡa ona rovoeu, tau eḡa God da ana kovoḡimi. ");
INSERT INTO wed_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Wariaḡa o ḡoei da ota viapoapoeniu wate God i virai da aiaina i kauei da rava maḡamaḡaui ina vilawani ma eḡa ina pupu. ");
INSERT INTO wed_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Anina, eḡa ona rovo! Tau ana painimi, natunatumi maiteni.” Ma nanare i babani da orai i rauei. ");
INSERT INTO wed_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Jacob natunatuna ana awawai ma natunatui anatapui maiteni i ḡaira au Egypt. Taui wavai wenanare: ");
INSERT INTO wed_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, Judah; ");
INSERT INTO wed_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakar, Zebulun ma Benjamin; ");
INSERT INTO wed_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad ma Asher. ");
INSERT INTO wed_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jacob natunatuna ma ḡoḡoḡana nelarai, anatapui ai maḡa 70 i ḡaira, Joseph au Egypt maemaena maiteni i ʼavi. ");
INSERT INTO wed_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Muriai Joseph ma varevareina ma nai kimtana i ʼraḡe-pai, ");
INSERT INTO wed_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Wate ai epaepaia - mai Israel, i vinatuna guratana da dam ḡaeḡaena i vitupui ma Egypt anatapuna i vioai. ");
INSERT INTO wed_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Madeḡa maḡamaḡaui au murina Pharaoh vouna i vibada au Egypt, ma Joseph ma aiwai i kauei eḡa ita aramanei. ");
INSERT INTO wed_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Pharaoh ana rava i riwei, “Ona inana, mai Israel i maḡa guratana ma i virewapana kaua eḡa me tauta. ");
INSERT INTO wed_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tauta tana viogatara da menanare tana kauanei da ai vinatuna eḡa ina rata guratana. Ma mepa da wei eḡa tana kauei ma maranai ḡavia ina nei, ma taui ḡavia maiteni ina vitagogiei da ina viḡavieta, ma ina opu-tawaneta.” ");
INSERT INTO wed_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ma nola babadai i terei da mai Israel nolei i vunuvunui. Wei babadai mai Israel i egari da taon ḡaeḡaei ruaḡa i voai wavai Pithom ma Rameses, ma kampa Pharaoh ana lam ma purapura ḡelaui i vidamni. ");
INSERT INTO wed_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mai Egypt amapo da taui i rau-iviapoapoelei, wate mai Israel amapo da i vivinatuna ma ai dam i rarata au Egypt. Ma lamna aubaina mai Egypt mai Israel i rovoei. ");
INSERT INTO wed_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Ma taui mai Israel i egari da nola vivitaina i kaukauei ma i vinuapoapoe. Ma brik i kaukauei ma doa i gwadai da brik anipasina, ma wapu nolai maiteni i kaukauei. Mai Egypt nolei mai Israel i vunuvunui ma eḡa ita rau-nuapoapoelei. ");
INSERT INTO wed_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pharaoh ana rava i riwei, “Maranai wavine Hebrewei tevera orotona i ḡuni, teverana au waira Nile ona tawanei. Wate maranai tevera wavinena i tupua, ona voterei da ina mae.” ");
INSERT INTO wed_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Maranai wei kauai i tuputupua, oroto tagogi Levi ana damei ma wavine ana damei i ravaḡi, ");
INSERT INTO wed_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","wavine i raumanawa ma natuna orotona i ḡuni. Ma wavine i ʼnanai da natuna inanana aiaina i tupua, ma natuna i tere-govaḡi da nawaravi tonuḡa i kwa. ");
INSERT INTO wed_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Wate eḡa tagotagogina da ita teregovaḡa-nonoei ma iriga waira modunei voavoana i vaia ma koltei gavogavo i pasi-tomeni da waira eḡa ina rui. Ma tevera au iriga i poai ma waira modui au orai i terei au waira Nile. ");
INSERT INTO wed_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Tevera tuana wavinena aueia i mae ma ana tevera i vineneḡanei da ita inanai awarina aiwai ita tupua. ");
INSERT INTO wed_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ma Pharaoh natuna gugunina i ḡairai da ita toa. Ma ana taunola waivinei waira au adana i bababara-nae. Pharaoh natuna iriga i ʼnanai modu au orana ma ana taunola i paritawanei da irigana ita neiai. ");
INSERT INTO wed_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Maranai Pharaoh natuna iriga i votawanei ma tevera i toutou i ʼnanai, nuanuana i bolai ma i riwa, “Wei mai Hebrew natui.” ");
INSERT INTO wed_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Tevera tuana wavinena i nae ma Pharaoh natuna i vibaḡai, “Anina bo eḡa da ana nae ma tataovao Hebrewei ana baiei da tevera ina viḡuḡui ma ina ḡamoi?” ");
INSERT INTO wed_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Wavine i vianina ma i riwa, “Anina, ma nae!” Ma tevera i nae ma alo oina i taravainiai. ");
INSERT INTO wed_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ma Pharaoh natuna wavinena i riwei, “Wei teverana ma viḡuḡui aubaiu ma ana vimaiem.” Ma wavine teverana i naiei ana au numa ma i ḡamoi. ");
INSERT INTO wed_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ma tevera i eda ma i naiei Pharaoh natuna awarina ma tauna i vaini da natuna. Ma Pharaoh natuna i riwa, “Au waira a sinaepai.” Lamna aubaina ana viwavai Moses. ");
INSERT INTO wed_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Maranai Moses i vilaraga, ma i nae da ana rava oina ita raugenari, ma i ʼnanai menanare mai Egypt ana rava i egari da i nolanola ma i rau-iviapoapoelei, ma i ʼnanai Egyptei Hebrewei i vunuvunui. ");
INSERT INTO wed_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moses i ʼnana viravira ma eḡa aiai ita inanai, anina ma Egyptei i viraḡeni ma au bubu i doboi. ");
INSERT INTO wed_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ma marana i tom Moses i naeme, da ana rava ruaḡa i viḡaiḡaiawa i ʼnanai ma ḡaiawa tauvikareina i riwei, “Aiwai aubaina turam Hebrewei e raviravi?” ");
INSERT INTO wed_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ma orotona i riwa, “Aiai i terem da ma vibadelai bo ma rauetaralai? Tam ma viraḡeniu me Egyptei u viraḡeni nanare bo?” Kampa Moses i rovo ma i riwa, “Rava boiboḡi i aramanei tau aiwai a kauei.” ");
INSERT INTO wed_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pharaoh wei riwana i nonori ma i ḡoei da menanare Moses ina viraḡenanei, wate Moses Egypt i ruba-tawanei ma i nae au Midian ma waira dogona au adana i kiala. ");
INSERT INTO wed_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses poiana Jethro ana sipu ma gote i ḡamoḡamoi - Jethro lamna mai Midian ai pirisi pulo tauapuna. Mara tagogi Moses ḡamoḡamo i naiei au mutulua au gia dewadewana ma au Sinai i ḡeta, God ana au ola. ");
INSERT INTO wed_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kampa Bada ana anela Moses awarina i eḡa, inanana me ai menamenana, ai rugurugui au orana da i ḡeḡae. Moses ai i lebalebara i ʼnanai wate aina ruguruguna maiteni eḡa ita ararai. ");
INSERT INTO wed_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses i vinua-notanota, “Wei lamna aiwai? Aiwai aubaina ai e lebalebara wate ai eḡa ita ararai? Ana nae au ḡereḡerena ma ana tuvirevirei.” ");
INSERT INTO wed_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Maranai Bada i ʼnanai da Moses i nenei au ḡereḡere da ita tuvirevirei, God ai menamenana au orana Moses i ḡorei, “Moses! Moses!” Ma i paribelei, “Ee, Tau weka.” ");
INSERT INTO wed_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Bada i riwa, “Eḡa ma neguratanai. Wei gabuna au tepana e maimairi lamna doa vivivireina, lamna aubaina am ae uma ma votawanei. ");
INSERT INTO wed_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Tau amamam Abraham ma Isaac ma Jacob ai God.” Maranai Moses wei babanina i nonori i rovo kaua ma naona i tere-govaḡi da avena God naona ita inanai. ");
INSERT INTO wed_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Anina ma Bada i riwa, “A inanai menanare mai Egypt natunatu e rarau-iviapoapoelei. Ma ai tou agu aubaina i ḡetai awariu da vibadabadai awarii ata vaitawanei. Menanare e vinua-apoapoenei a aramanei. ");
INSERT INTO wed_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Lamna aubaina a ḡairai da natunatu Egypt awari ana vaitawanei ma ana opunei da dobu wapuna ḡaeḡaena ma doana maumaurana ina maeni. Kampa marina mai Canaan, mai Hitti, mai Amori, mai Perisi, mai Hivi ma mai Jebus e mamae. ");
INSERT INTO wed_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ai tou a nonori. A inanai menanare mai Egypt taui e rarau-iviapoapoelei. ");
INSERT INTO wed_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tau a paripari-tawanem, marina ma nae vibadabadana Pharaoh awarina da mai Israel au Egypt ma taravaina-opunei.” ");
INSERT INTO wed_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Wate Moses i riwa, “Tau aiai da ata nae Pharaoh awarina ma mai Israel ata taravaina-opunei?” ");
INSERT INTO wed_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ma God i paribelei, “Tau tam maiteni ana mae. Maranai ravai Egyptei ma taravaina-opunei. Taumi wei au olana ona rauduneleu. Lamna ina vimataira da Tau a pari-tawanem.” ");
INSERT INTO wed_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Wate Moses i riwa, “Maranai ana nae au rava awarii ma ana riwei, ‘Amamata ai God i paritawaneu awarimi.’ Ma taui ina paridadaneu, ‘Tauna wavana aiai?’ Ma aiwai ana riwei?” ");
INSERT INTO wed_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God Moses i riwei, “Tau maemae-nonoau. Wei mai Israel ma riwei, Tauna wavana, Tau Maemae Nonoau. i paritawaneu awarimi. ");
INSERT INTO wed_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mai Israel ma riwei, ‘Tau Bada, amamami ai God, Abraham, Isaac ma Jacob ai God, tauna i paritawaneu awarimi.’ —Wei Tau wavau Maemae-Nonoana, kimta anatapui wenanare wavau ina ḡorei.” ");
INSERT INTO wed_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ma Bada Moses i riwei, “Anivinuabola tagogi ava ana neiai Pharaoh ma Egypt awarii. Ma au murina tauna ina voteremi da ona nae ma lamna maranaina ina viaḡaḡana-opunemi. ");
INSERT INTO wed_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ma nae ma mai Israel ma riwei, ‘Anatapumi ona nae ma mae-turami Egyptei ona vibaḡai da ai via goldei ma silvei ina veremi.” ");
INSERT INTO wed_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Bada i kauei da mai Egypt mai Israel i vivirei. Pharaoh ana gabemani babadai ma rava anatapui au Egypt Moses i vivirana-kauei. ");
INSERT INTO wed_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ma Moses i nae ma Pharaoh i riwei, “Bada e ririwa, ‘Nubautuva nanare tau Egypt anatapuna ana babarani. ");
INSERT INTO wed_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Natuevou nelarai au Egypt anatapui ina iraḡe, Pharaoh natuevouna orotona, amana ana epaepaia, awarina ina vikarei, ma ina ḡaira da taunola awarina ina ḡeta, waivinewiti taugudaina natunatui maiteni. Ḡamoḡamo natuevou anatapui ina iraḡe. ");
INSERT INTO wed_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ma dobu Egypt au anatapuna tou ḡaeḡaena ina ḡae, rorova eḡa nanare ma eḡa melanai nanare ina tupua me.’ ");
INSERT INTO wed_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Wate eḡa aiwai apoapoena mai Israel awari ina tupua, eḡa auou tagogi, rava tagogi, bo ḡamoḡamo ina gwauei. Ma kampa ona aramanei da Tau Bada, mai Israel ma mai Egypt awariei a vivilamonei. ");
INSERT INTO wed_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Am gabemani babadai anatapui ina ḡairai awariu ma au naou ina mae-ḡaira ma ina raudune ma ina riwa, ‘Laḡilaḡina ma ruba-nae am rava tauvotaḡotaḡoim anatapui maiteni.’ Lamna au murina tau ana nae.” Moses meji orana i oai ma Pharaoh i netawanei. ");
INSERT INTO wed_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Bada Moses i riwei, “Pharaoh tam eḡa ina rautaniḡanem. Wenanare ina tupua da tau kaua babai ana kauei au Egypt.” ");
INSERT INTO wed_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses ma Aaron kaua ḡaeḡaei ma babai i kauei Pharaoh au matana wate Bada Pharaoh orana i vibadoi da mai Israel eḡa ita paritawanei. ");
INSERT INTO wed_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Bada, wenanare i babani Moses ma Aaron awarii au Egypt, ");
INSERT INTO wed_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Marina da e nenai wei nawaravina lamna nawaravi tagogi ma weka ona vikarei da ami madeḡa ona iavi. ");
INSERT INTO wed_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ona vinolanola mai Israel anatapui awarii, ‘Au pom vi-10-na wei au nawaravina oroto tagotagogi ava sipu ḡaubona bo gote ḡaubona ina rautani ana numa ravai aubai. Ḡamoḡamo tagogi numa tagogi aubaina.’ ");
INSERT INTO wed_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Mepa da numa tagogi ana rava i viruaḡa ma sia i rata guratana, lamna mae-turai maiteni sia ina ḡutai rava ai maḡa ma ai am ana au ruva nanare. ");
INSERT INTO wed_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ḡamoḡamo e rarautani lamna orotona ma ana madeḡa tagogi ma aiaina eḡa ana apoapoe aiwai. ");
INSERT INTO wed_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ona ḡamo-kauei da au pom vi-14-na wei au nawaravina. Ma maranai madeḡa e arearere, mai Israel anatapui ai ḡamoḡamo ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Metauna au numana sia e aniani kampa tara ina taraiḡui ma metaeta au tepana, au gabaurina ma au ririvana ina pasi-naiei. ");
INSERT INTO wed_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Waguvaranaina tagogina taui siana ai moniana au tepana ina apui, ma palawa eḡa yist maiteni ma sipeni viviḡorai maiteni ina ani ");
INSERT INTO wed_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Anatapumi wenanare ona am, vaḡai vigara ona vigarei: Ami ae uma ona oteni, ami jiḡona au urami, Ma ona am laḡilaḡina. Wei lamna Bada ana Raḡona torelana. ");
INSERT INTO wed_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","—Wei waguvaraina, Tau Egypt ana naeni ma ḡamoḡamo da rava natuevoui ororotoi anatapui ana viraḡeni, ma Egypt ai god anatapui ana tuvaidoedoei. Tau Bada. ");
INSERT INTO wed_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Wate tara au metaeta ina vimataira da taumi kampa o mamae. Ma maranai wei matairana ana inanai, ana raḡonimi. Ma eḡa aiwai apoapoena awarimi ina tupua maranai mai Egypt ana kovoḡi, ");
INSERT INTO wed_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Wei torelana ona nota-nonoei madeḡana patapatana, da Tau Bada aiwai a kauei nuanuami eḡa melanai ina vuru. Ami epaepaia anatapui wei marana ina vivirei ai mara au anatapuna.” ");
INSERT INTO wed_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Au pom 7 au orana Palawa eḡa yist maiteni ona ani. Ma torela au karena, au numa yist anatapui ona tawanei. Aiai da palawa yist maiteni i apui ma i ani, wei ravana anina da mai Israel ai damei ona viopuni. ");
INSERT INTO wed_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Au pom tagogi torela au karena ona vitagogiemi ma nanare torela au damona, ma Bada ona voepaepai ma ona viborumei. Wei au marai eḡa aiai ina nola dadana, Wate ami lam ava ona lauvoa. ");
INSERT INTO wed_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","—Taumi palawa eḡa yist maiteni torelana ona kauei da eḡa nuanuami ina vuru aubaina wei au marana, mai Israel au Egypt a taravaina-opunei. Am epaepaia wei torelana ina kaukauei madeḡana au patapatana.” ");
INSERT INTO wed_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ma Moses Israel dam nununai babadai i kwatuei ma i riwei, “Ona nae ma sipu bo gote natuna orotona ona vunui ma ami numa ravai maiteni Raḡona torelana ona ani. ");
INSERT INTO wed_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Rugurugu ona turautuvi sipu au tarana au aboma ma ami numa metaetana au tepana ma au adana ona pasi. Ma eḡa aiai numa ina opu-tawanei da ubaubanai. ");
INSERT INTO wed_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ma waguvarai Bada Egypt anatapuna ina naeni ma mai Egypt ai natuevou ina viraḡeni. Wate maranai tara ina inanai metaeta au tepana ma au adana, Bada wei numana ina raḡoni ma iraḡe-anelana ina viḡaei da eḡa ina rui da ina viraḡenimi. ");
INSERT INTO wed_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","25","—Ma maranai Bada dobu i paripari-vainuaḡanimi ona ḡeta, taumi eḡa nuanuami ina vuru da madeḡana patapatana Raḡona torelana ona kaukauei. Taumi natunatumi maiteni wei tarawatuna ona vojijina-nonoei. ");
INSERT INTO wed_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Maranai natunatumi ina paridadana, ‘Wei torelana anona aiwai?’ ");
INSERT INTO wed_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Ma taumi ona paribelei, ‘Wei torelana lamna Raḡona viegualau pulona Bada awarina, aubaina wariaḡa au Egypt Bada mai Israel ai numa i raḡoni, ma mai Egypt ai natuevou i pupuni, ma tauai natunatuiai i voterei.” Ma mai Israel i mae-ḡaira au doa ma Bada i raudunelei. ");
INSERT INTO wed_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ma mai Israel i nae ma Bada aiwai Moses ma Aaron i riweia i kauei. ");
INSERT INTO wed_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Waguvarai nubautuva Bada natuevou nelarai anatapui i viraḡeni au Egypt. Pharaoh natuna, ana epaia awarina i vikarei, ma i ḡaira da panipani ai natuevou nelarai awari. Ma ḡamoḡamo ororotoi natuevoui anatapui maiteni i pupuni. ");
INSERT INTO wed_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Waguvara au pouna Pharaoh ma ana gabemani babada ma mai Egypt anatapui i vomairi. Numa tagotagogi ava au Egypt tevera tagogi i ʼraḡe, ma tou ma tarakwatu ḡaeḡaena i ḡae. ");
INSERT INTO wed_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pharaoh wei waguvaraina Moses ma Aaron ai riwa i paritawanei da i nei awarina ma i egari, “Ami rava mai Israel maiteni ona vomairi ma au dobu ona oputawanei! O vivibaḡei nanare ona nae ma ami Bada ona voepaepai! ");
INSERT INTO wed_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Taumi ami ḡamoḡamo anatapui ona vaia ma ona opu, ona nae, wate ami God ona vibaḡai da ina viaiainiu.” ");
INSERT INTO wed_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mai Egypt anatapui mai Israel i egari da ina vipaparana ma Egypt ina opu-tawanei ma i riwa, “Mepa da eḡa ona nae tauai anatapuiai ana iraḡe.” ");
INSERT INTO wed_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Mai Israel dobu Rameses i netawanei ma i babara-nae au Sukoth. Nelara anatapui 600,000 nanare, waivine ma roaroa eḡa ita iavi. ");
INSERT INTO wed_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Patara ḡaeḡaena ḡelauna i vomairi mai Israel maiteni. Taui ḡamoḡamo boruna ḡaeḡaena maiteni i nae. ");
INSERT INTO wed_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Maranai mai Egypt i viaḡaḡana-opunei taui eḡa ai tamaina ita vokaukauei ma laḡilaḡina i opu, taui palawa pasipasi nonoana eḡa yist maiteni i vaia ma palawa bagibagina i apui. ");
INSERT INTO wed_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Mai Israel madeḡa 430 i mae au Egypt. ");
INSERT INTO wed_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ma Bada Moses ma Aaron i riwei, Raḡona torelana ana tarawatu wenanare: Dobu ḡela wei torelana eḡa ina ani. ");
INSERT INTO wed_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ami taunola gimagimarana ma inibori i vaia wei torelana ina ani. ");
INSERT INTO wed_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Taomana ma taunola maia aubaina e nolanola taui eḡa ina ani. ");
INSERT INTO wed_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Raḡona sipuna numa tagogiava au orana ona ani, ma eḡa sia aiwaina ona opunei au doa ma gelamina eḡa ona gai. ");
INSERT INTO wed_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mai Israel anatapui Raḡona torelana ina ani. ");
INSERT INTO wed_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Bada Moses i riwei, ");
INSERT INTO wed_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Natuevou nelarai au Israel anatapui ona vovivirei Tau awariu. Roaroa ma ḡamoḡamo natuevoui ororotoi au Israel anatapui, Tau ḡariuei.” Moses mai Israel i riwei,  ");
INSERT INTO wed_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Bada ina ruiemi mai Canaan ai au dobu ma dobuna ina veremi, noinoimi i paripari-vainuaḡani nanare. ");
INSERT INTO wed_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Natuevoumi nelarai ma ami ḡamoḡamo natuevoui ororotoi anatapui Bada ona verei, ");
INSERT INTO wed_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Wate sipu orotona Bada ona verei ma awarina donki natuevouna ona gimara-melei, ma mepa da eḡa ona gimara-melei, lamna donkina uana ona gomui. Taumi natunatumi nelarai natuevoui ona gimara-melei. ");
INSERT INTO wed_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","—Ma mara au murina, natunatumi ina vitara-viravira, ‘Aiwai aubaina wei ta kaukauei?’ Tam ma paribelei, ‘Bada urana vivirewapananei i taravaina-opunelai, panipani numanei au Egypt. ");
INSERT INTO wed_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pharaoh orana i bagibagi ma eḡa mai Israel ita voterei da ita nae. Lamna aubaina Bada natuevou anatapui au Egypt i viraḡeni, rava ma ḡamoḡamo anatapui. Lamna aubaina tau ḡamoḡamo natuevouna Bada a vereverei ma natuevou orotona a gimagimara-melei.’ ");
INSERT INTO wed_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Wei gimara melanana lamna me mataira au uram ma au muruam e oteoteni ma wei e vivimataira da Bada urana vivirewapananei Egyptei i taravaina-opunelai.” ");
INSERT INTO wed_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Mai Israel Sukoth i voterei ma mutulua au giana au Etham i mae-gubai. ");
INSERT INTO wed_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ma marai Bada i vinao me apau maimairina ma waguvarai Bada i vinao me tuatua araratana maimairina ma lalalainei taui i rau-etaraveni. Ma lamnei, taui marai ma waguvarai i bababara. ");
INSERT INTO wed_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Maranai riwa i ḡeta Pharaoh awarina, da mai Israel i ruba. Pharaoh ana gabegabemani maiteni ai nota i virai ma i riwa, “Tauta aiwai ta kauei? Ma ata taunola ta voterei da i nepai!” ");
INSERT INTO wed_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Anina ma Pharaoh ana chariot i vokaukauei, ma ana sorodia i vaia ma i nae. ");
INSERT INTO wed_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ana sorodia anatapui 600 vinevinei ai au chariot i geru, ma chariot ḡelaui au Egypt maiteni i nae. ");
INSERT INTO wed_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Bada, i kauei da Pharaoh, Egypt ai gulau nuanuana i vopotai ma mai Israel i viaḡaḡana-taḡoei, Mai Israel ana tepatorai i nenae. ");
INSERT INTO wed_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Mai Egypt ana sorodia i viaḡaḡa, Pharaoh ana horse ma chariot anatapui ma horse babadai ma ana sorodia anatapui, maiteni i viaḡaḡa da au gera i mamaelana, i votani dobu Pi-Hahiroth, Baal-Sephon au baba ḡelauna. ");
INSERT INTO wed_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Maranai Pharaoh i tuturiai, mai Israel i taepai da i ʼnanai ma i rovo kaukaua da orai i sisi, ma Bada awarina i garara agu aubaina. ");
INSERT INTO wed_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ma mai Israel Moses awarina amloi i ḡaiḡai i pa, “Au Egypt eḡa kokoaga da u taravaina-opunelai da weka au mutulua ana iraḡe bo? Aiwai u kauei awariai? ");
INSERT INTO wed_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tauai au Egypt a riwem, ‘Ma voterelai ma ana mae ma Egypt ai taunola!’ I ai kaua da tauai ata mae Egypt ai panipani, ma eḡa au mutulua ata iraḡe.” ");
INSERT INTO wed_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses ana rava i paribelei, “Eḡa ona rovo! Ona mairi jijina ma ona inana menanarena Bada ina vilawanimi amadodo. Mai Egypt amadodo o inainanai eḡa melanai ona inana-melei. ");
INSERT INTO wed_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Bada aubaimi ina viḡavia. Taumi ona mae-genuatau.” ");
INSERT INTO wed_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ma Bada, Moses i riwei, “Aiwai aubaina awariu agu e toutouei? Mai Israel ma riwei da ina vidagu. ");
INSERT INTO wed_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Am jiḡona ma voepai da ma viloloi boga au tepana ma boga ina vilamonei, ma mai Israel boga au pouna doa au alalana ina babara damana. ");
INSERT INTO wed_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Tam ma raubiga, Tau mai Egypt a vitepatorai da mai Israel ina viaḡaḡei. Maranai Pharaoh ana vovaiubai, ana sorodia, chariot ma ana horse sorodiai, rava Tau ina voepaepaiu. ");
INSERT INTO wed_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tau Pharaoh ana vovaiubai, ana chariot ma ana horse sorodiai da mai Egypt ina vivivireu ma ina aramanei da Tau Bada.” ");
INSERT INTO wed_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Anina ma God ana anela, mai Israel ai eta tauravenia i nae ma mai Israel au muri i mairi. Ma apau maimairina au naoi i nei ma taui au muri i mairi. ");
INSERT INTO wed_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Apau mai Israel ma mai Egypt au poui i mairi, ma maranai au i pom, apau lalalaina mai Israel i verei ma mai Egypt au waguwaguvareina i mae. Ma lamna aubaina mai Israel ma mai Egypt ai au gabu i mae-genuatau. ");
INSERT INTO wed_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses ana jiḡona i viloloi boga au tepana ma Bada kariwabu ḡaeḡaena i paritawanei, ma boga i vilamonei, kariwabu i ruba da mara i tom da doa boga au pouna i alala. ");
INSERT INTO wed_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ma mai Israel boga i damani doa au alalana, Ma boga olana i mairi au oiei ma au kelakelaui. ");
INSERT INTO wed_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Anina ma mai Egypt, Pharaoh ana horse ḡelaui, chariot ma taurubeina mai Israel i votaḡoi da au boga i rui, mai Israel au murii. ");
INSERT INTO wed_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ubaubanai boiboḡi Bada apau maimairina ma ai tuatuana araratana au orana ma i ʼnana ḡaira ma mai Egypt i viaiḡoaḡoai. ");
INSERT INTO wed_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ma chariot ana aniruba i viapoapoeni da ruba i kauana-avei. Ma mai Egypt i riwa, “Bada mai Israel e vovoagui, ma e viviviḡavieta, lamna aubaina tana ruba-tawanei!” ");
INSERT INTO wed_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ma Bada Moses i riwei, “Am jiḡona ma viloloi boga au tepana da boga ina nememei, mai Egypt au chariot ma sorodia horse au tepana anatapui ina puru-pai.” ");
INSERT INTO wed_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Madeḡa i ḡoḡoḡo ma Moses urana i viloloi boga au tepana, ma laḡilaḡina boga i naeme ana au gabu. Mai Egypt ita ruba wate Bada taui au boga i viorereni. ");
INSERT INTO wed_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Boga i naeme ana au gabu ma mai Egypt sorodia anatapuina i ruirui au boga i monu. Eḡa aiai tagogi ita lawana. ");
INSERT INTO wed_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Maranai mai Israel i ʼnanai da Bada wei kauana vivirewapanana i kauei mai Egypt awarii, taui Bada i vivirana-kauei ma i vitumaḡanei ana taunola Moses maiteni. ");
INSERT INTO wed_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Anina ma Moses mai Israel maiteni wei voepaepa welana i ravi Bada awarina: Tau ana wela Bada awarina ma ana voepaepai, aubaina ana ḡavia i vipupui, ma horse ma chariot taugeruii au boga i viorerena-naiei, ");
INSERT INTO wed_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Bada au rewapana ḡaeḡaena, ma welei ana voepaepai; Tauna i vilawaniu Tauna au God ma ana voepaepai, Amamau ai God ma lamna aubaina ana vimae-ḡaeḡaeni ma ana voepaepai. ");
INSERT INTO wed_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Tauna wavana Bada. Tauna ḡavia ravana. ");
INSERT INTO wed_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Pharaoh ana chariot ma ana sorodia au boga i viorereni; Ana sorodia vinevinei au Boga Lebalebarina i monui. ");
INSERT INTO wed_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Gabinou i wanaiwaḡi da taui i purui; ma i monu boga au gabaurina me ḡaima. ");
INSERT INTO wed_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Oo Bada ura-oiem vivirewapana kaukauana, ura-oiem am ḡavia e viviaimutumutui. ");
INSERT INTO wed_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tam ḡeḡetelaram ma taui i viḡaviem u vovaiubai. Am meji araratana u paritawanei da taui i aragibui me ai ragorago. ");
INSERT INTO wed_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Boga au tepana u uvena ma boga olana i mairi, i mairi genuatau me biribiri, ma gabinou i alala. ");
INSERT INTO wed_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Am ḡavia i riwa, “Ana viaḡaḡei, ana vojijini, ai purapura ma ai maura anatapui ana ḡutai, ma aiwai a ḡoeḡoei ana vaia, Au sod ana lavui ma ana vipupui.” ");
INSERT INTO wed_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Wate lavutumei u uvena, ma gabinou taui i purui; i monu me ḡaima rabama au ḡaeḡaena. ");
INSERT INTO wed_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Bada, mepa god ḡelaui me tam bo eḡa? Eḡateni! Tam anina vivivirem, am rewapana i rata dewadewa da tauai a rovorovoem, Tam kaua babai ma virewapanai taukaueina. ");
INSERT INTO wed_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tam uraoiem u viloloi, ma doa am ḡavia i lawani. ");
INSERT INTO wed_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Am rava u vaimelei ma u rauetaraveni am nuavaina patupatutunei, Ma am rewapanei u taravaina-naiei am au animae vivivireina. ");
INSERT INTO wed_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dobu ḡelaui wei riwana i nonori ma orai i sisi kaua. Mai Philistia orai rovo ina vioai. ");
INSERT INTO wed_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom gulagulaui ina rovo kaukaua, Moab nelara rewapana ini ina sisi. Canaan maemaei anatapui inii i wanagwadai. ");
INSERT INTO wed_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Rovo ḡaeḡaena anatapui orai i oai, uram ana rewapanei taui i mairi kwakwa me kokoitau, ma am rava ina verautua Bada, da ravai u vaivai-melei ina verautua. ");
INSERT INTO wed_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Bada ma taravaina da am au ola ina raunuma, Gabu u vinevineiana, tam uramei voavoaina. ");
INSERT INTO wed_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Bada ina vibada nonoa. ");
INSERT INTO wed_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mai Israel doa au alalana i babara damana. Wate maranai mai Egypt ai horse ma ai chariot taugerui i rui au boga, Bada waira i neiana-meleiai da anatapui i purui Lamna aubaina Moses ana rava maiteni wei welana i ravi.  ");
INSERT INTO wed_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Peroveta Miriam, Aaron novuna tambourine i vaia ma waivine anatapui, tauna i votaḡotaḡoi ma tambourine i vikalokaloei ma i ara. ");
INSERT INTO wed_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam wei welana i ravi, “Tana raua Bada awarina, aubaina tauna ḡavia i vilamolamonei ma horse ma chariot taugerui au boga i viorereni.” ");
INSERT INTO wed_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Anina ma Moses mai Israel i taravaini da Boga lebalebarina i netawanei ma i nae au Shur mutuluana. Aupom tonuḡa au mutulua i babara wate waira eḡa ita nelaḡai. ");
INSERT INTO wed_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Maranai au waira vuvura Marah i ḡeta da ita uma wate wairana umana i viḡora da eḡa ita uma, lamna aubaina wei dobu wavana Marah. ");
INSERT INTO wed_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ma rava Moses awarina i pariḡai i pa, “Aiwai tana umai?” ");
INSERT INTO wed_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Anina ma Moses i paritou bada awarina agu aubaina, ma Bada ai tupona i viatataiei. Ma wei aina i tawanei au waira ma waira i viaini aniuma aubaina. Nai au gabuna Bada ana tarawatu rava i verei ai lawana aubaina, ma ai votelatela i raudadani. ");
INSERT INTO wed_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Bada i riwa, “Mepa da riwau ona nonora-kauei ma kaua aiaii ona kauei au matau ma riwau anatapuna ona voteletelei, da kovoḡa mai Egypt a vereverei, eḡa ana veremi. Tau Bada tauvilawanimi.” ");
INSERT INTO wed_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Muriai taui i nei au Elim kampa vuvura 12 ma mutulua ai me pa 70 i maimairi ma kampa waira au adana i mae mara aburuna. ");
INSERT INTO wed_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Anina ma mai Israel Elim i netawanei ma i nae au mutulua wavana Sin, wei dobuna lamna Elim ma Sinai au poui. Egypt i opu-tawanei nawaravi tagogi ma wiki ruaḡa i kwa ma wei au dobuna i ḡeta. ");
INSERT INTO wed_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mai Israel Moses ma Aaron awarii i ḡaiḡaiawa. ");
INSERT INTO wed_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ma i riwei, “Bada boiboḡi au Egypt ita viraḡeniai! Kampa sia nauii a kiala kwaviviroi ma ai ḡoanei a amam, wate taumi o taravaina-opunelai au mutulua da am-iraḡe ana iraḡelei.” ");
INSERT INTO wed_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Anina ma Bada Moses i riwei, “Lam marei ana paritawana-ḡaireiai me garewa. Au pom patapatana rava ina opu ma lam au pom tagogi ruvana ava ina vaia. Wei taunei rava ana raudadani da riwau bagibagina ina voteletelei bo eḡa.” ");
INSERT INTO wed_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Au pom vi-6-na au pom ruaḡa ruvana ina tami da ina vokaukauei. ");
INSERT INTO wed_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Bada Moses i riwei, ");
INSERT INTO wed_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mai Israel ai ḡaiawa a nonori. Ma riwei, ‘Raviraviai taumi sia ona ani, ma ubaubanai lam ona maurei.’ Ma lamna maranai ona aramanei da Tau Bada ami God.” ");
INSERT INTO wed_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Raviraviai kiu iviki boruna i nei da taui i maemae lana gabuna i vioai. Ma ubaubanai ḡelauna doa anatapuna turuvani i vioai. ");
INSERT INTO wed_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Maranai turuvani i paira ma purapura avavai me palawa nanare doa au tepana i mae. ");
INSERT INTO wed_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Maranai mai Israel wei purapurai i ʼnanai ma i vinuanaina ma i vitara-viravira vivira i pa, “Wei aiwai?” Ma Moses rava i riwei, “Wei aniam Bada i veremi.” ");
INSERT INTO wed_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Bada riwana bagibagina lamna wei, “Rava tagogi lam ana au ruva ina tuarui. Nau muomuoi ruaḡa ruvana ona tuarui, rava tagogi au numa aubaina.” ");
INSERT INTO wed_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Aiwai i ririweia nanare mai Israel i kauei, ḡelaui ruva ḡaeḡaena i tami ma ḡelaui ruva aburuna i vaia. ");
INSERT INTO wed_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wate maranai i ruvai ma i ʼnanai da rava anatapui ruva i vaia da tagotagogina, Taui da ruva ḡaeḡaena i tami eḡa aiwai ita mae-terei ma taui da aburuna i tami ma i nelaḡai da lamna tagotagogina taui aubaii. Numa nununai ravai lam ruvaruvana i vaia. ");
INSERT INTO wed_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Anina ma Moses i riwa, “Eḡa aiai lam ina tereriei da au maratom aubaina.” ");
INSERT INTO wed_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Wate rava ḡelaui Moses eḡa ita rautaniḡanei ma lam ḡelaui i tereriei ma ubaubanai motamota lam i oai ma i bova, ma Moses amlona i ḡaiḡai taui awarii. ");
INSERT INTO wed_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ubaubanai patapatana taui lam ai au ruva i tuarui, ma maranai madeḡa i vibola ma lam i viwaira da i amoa. ");
INSERT INTO wed_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ma au pom vi-6-na taui au pom ruaḡa ruvana nanare i tuarui, ma melagai babadai i nei da Moses i pariverei. ");
INSERT INTO wed_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moses taui i riwei, “Bada riwa bagibaginei wenanare i riwa, ‘Maratom lauvitau vivireina Sabate ana mara, Tau aubaiu. Aiwai apuna o ḡoeḡoeia amadodo ona apui ma aiwai vitavana o ḡoeḡoei amadodo ona vitavi. Ma aiwai i mae-terei, ona tereriei au maratom aubaina.” ");
INSERT INTO wed_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ma taui lam i tereriei ma eḡa ita bova ma ita motamota me Moses i ririwa nanare, ");
INSERT INTO wed_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses i riwa, “Wei lamna amadodo ona ani, aubaina amadodo Sabate, lauvitau ana mara vivivireina i terei Bada aubaina. Ma amadodo amapo lam au doa eḡa ona nelaḡai. ");
INSERT INTO wed_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Au pom 6 lam ona tuarui, wate au pom vi-7-na Sabate, amapo lam eḡa ona nelaḡai.” ");
INSERT INTO wed_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ma au pom vi-7-na rava ḡelaui i opu da lam ita tuarui wate eḡa aiwai ita nelaḡai. ");
INSERT INTO wed_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Anina ma Bada, Moses i riwei da rava i riwei i pa, “Mara biaḡa au tarawatu ma au viararamana ona rau-aḡaiḡaiei? ");
INSERT INTO wed_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ona notai da Tau Bada, Sabate a veremi, ma au pom vi-6-na lam a veremi da au pom ruaḡa aubaina. Ma rava anatapui au numa ita mae ma avena ita opu.” ");
INSERT INTO wed_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ma au pom vi-7-na rava i vilauvitau. ");
INSERT INTO wed_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Rava mai Israel wei lamna i ḡorei “manna.” ");
INSERT INTO wed_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ma mai Israel manna i amam da madeḡa 40 i kwa. Taui manna i amam da Canaan ana au parata i ḡeta. ");
INSERT INTO wed_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mai Israel mutulua Sin i netawanei, ma mepa Bada i ririweia nanare kampa i mae-nae. Taui au Rephidim i rauḡaravu, wate kampa eḡa waira da rava ita uma. ");
INSERT INTO wed_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Anina ma taui Moses maiteni i viparipariniḡai i pa, “Waira ma verelai da ana uma!” Ma Moses i paribelei, “Aiwai aubaina o paripariniḡaieu? Aiwai aubaina Bada o raraudadani?” ");
INSERT INTO wed_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Wate rava nuanuai i arelana-kauei waira aubaina ma Moses i eni i pa, “Aiwai aubaina Egyptei u tere-opunelai da natunatuiai ma ai ḡamoḡamo maiteni nuarelana ana iraḡelei?” ");
INSERT INTO wed_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ma Moses i paritoutou Bada awarina i pa, “Aiwai ana kauei wei ravai awarii? Taui ḡaimei marina ina viraḡeniu.” ");
INSERT INTO wed_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Bada Moses i paribelei, “Israel babadai ḡelaui ma taravaini ma kwapu taunei Nile u raviravia ma vaia ma ma vinao. ");
INSERT INTO wed_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Tau kampa au naom au kira ana maimairi au Horeb. Kira ma ravi da waira ina opu da rava ina uma.” Ma Moses nanare i kauei Israel babadai au matai. ");
INSERT INTO wed_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Moses wei dobuna i ḡorei Massah ma Meribah, aubaina weka mai Israel Moses maiteni i viparipariniḡai ma Bada i raudadani maranai i riwa, “Bada weka tauta maiteni bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Mai Amalek i nei ma Mai Israel maiteni i viḡaiḡaiawa au Rephidim. ");
INSERT INTO wed_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses Joshua i riwei, “Rava ma vinei da ona nae mai Amalek maiteni ina viḡaiḡaiawa. Au maratom tau ola au tepana ana mairi ma God ana kwapu ana vovojijini.” ");
INSERT INTO wed_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ma Joshua mai Amalek maiteni i viḡaiḡaiawa me Moses i ririweia nanare. Moses, Aaron ma Hur i ḡae ola au tepana. ");
INSERT INTO wed_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Maranai Moses urana ana kwapuna i voepai mai Israel i vivirewapana wate maranai urana i teretere-ḡairei mai Amalek i vivirewapana. ");
INSERT INTO wed_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Moses urana i garigari ma Aaron ma Hur ḡaima i neiai da i terei ma au tepana Moses i kiala. Aaron ma Hur, Moses au ririvana i mae, tagogi au navanavana ma ḡelauna au navanavana ḡelauna ma urana i voepai ma i vojijini da madeḡa i neulai. ");
INSERT INTO wed_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ma Joshua ana sorodia maiteni Amalek ai sorodia sodiei i vovaiubai. ");
INSERT INTO wed_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Moses poiana Jethro, mai Midian ai pirisi pulo tauapuna i nonori aiwai anatapuna Bada i kaukaueia Moses ma mai Israel awarii; ma menanare Egyptei i taravaina-opunei. ");
INSERT INTO wed_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moses poiana - Jethro, Moses awana ma natunatuna nelarai ruaḡa i nei da Moses ita raugenari au mutulua. Weka Moses ana rava maiteni i rauḡaravu God ana ola au ḡereḡerena. ");
INSERT INTO wed_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jethro riwa i paritawanei Moses awarina da taui i nenei. ");
INSERT INTO wed_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ma Moses i opu da poiana ita nebelei. Tauna i mae-ḡaira ma poiana i raudunelei ma i vigia-laḡolaḡonei. Taui i viegualau vivira ma i rui Moses ana au numagara. ");
INSERT INTO wed_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ma Bada aiwai i kaukaueia Pharaoh ma mai Egypt awari mai Israel aubai; ma apoapoe anatapui au eta i nebelei; ma menanare God taui i vilawani; anatapui poiana i pariverei. ");
INSERT INTO wed_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ma Jethro nuanuana i ai kaua maranai i nonori menanare Bada aiwai anatapuna aiaii i kauei mai Israel aubai maranai Egypt urai vivirewapanana awariei i tere-opunei. ");
INSERT INTO wed_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro i riwa i pa, “Voepaepa Bada awarina. Tauna Pharaoh ma mai Egypt awarii i vai-tawanemi. Ee, Egypt urai vivirewapanana awariei i vai-tawanemi. ");
INSERT INTO wed_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Marina a aramanei da Bada i ḡetelara eḡa me god ḡelaui nanare. Aubaina Bada ḡoḡogulagulaui mai Egypt ai kaua apoapoe mai Israel awarii aubaina i kovoḡi.” ");
INSERT INTO wed_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ma marana i tom, Moses ana au anikiala i kiala da ita rauetara. Ma rava Moses i mairi-kwaviviroi ma i vipaipai ubaubanai da madeḡa i ḡaira. ");
INSERT INTO wed_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Maranai Jethro i ʼnanai aiwai anatapuna Moses i kaukauei rava aubaii. Tauna i vitara-viravira i pa, “Wei aiwai rava awarii e kaukauei? Aiwai aubaina ainelam wei e kaukauei, ma wei ravai e maimairi pompom da am riwa ita nonori?” ");
INSERT INTO wed_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses i paribelei i pa, “Tau wei a kaukauei aubaina rava e nenei awariu da ita aramanei aiwai God e ḡoeḡoei da ita kauei. ");
INSERT INTO wed_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Maranai rava ruaḡa e viviamparipari. Taui e nenei awariu da a teretere-vaijijimani; ma God ana riwa ma ana tarawatu a ririwei.” ");
INSERT INTO wed_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moses poiana i riwa i pa, “Aiwai tam e kaukauei lamna eḡa ita ai. ");
INSERT INTO wed_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nola e kaukaueia i vitai kaua da tam ainelam eḡa tagotagogina uta kauei. Tam ma rava ona voirairaḡe. ");
INSERT INTO wed_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ma rautaniḡana ma ana vinuaterenem; ma God awarim ina mae. Tam anina da rava ma raviepaiai God au naona ma ai viamparipari ma neiai awarina. ");
INSERT INTO wed_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","God ana parivai-araramana ma ana tarawatu ma viararamani ma taui ma viatataiei da menanare ita maenei ma aiwai ita kauei. ");
INSERT INTO wed_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Wate am patara awariei nelara ḡelaui araramanii ma God e viviborumei ma eḡa amkwalakwalai ma vinei da rava ina vibadei: ḡelaui rava 1,000 ina vibadei; ma ḡelaui rava 100; ma ḡelaui rava 50; ma ḡelaui rava 10 ina vibadei. ");
INSERT INTO wed_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Taui rava ai viamparipari ina tere-vaijijimani. Wate aiwai da i piripiri, ina neiai awarim. Taui ina voaguim da am vita ina avarai ma ina votelatelai. ");
INSERT INTO wed_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Mepa da God i ririweia ma kauei amapo eḡa ma voirairaḡe ma rava anatapui ana nuaiaii ina nae ai au numa.” ");
INSERT INTO wed_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses, poiana i rautaniḡanei ma aiwai anatapuna i ririweia i kauei ");
INSERT INTO wed_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ma Moses mai Israel araramani i vinei da rava 1,000 i vibadei, ma 100, ma 50 ma 10 i vibadei. ");
INSERT INTO wed_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Wei babadai, rava ai viamparipari i teretere-vaijijimani ma aiwai da i piripiri i neneiai Moses awarina. Ma kaua telatelai i teretere-vaijijimani. ");
INSERT INTO wed_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Anina ma Moses, poiana Jethro i viegualauei, ma Jethro i naeme ana au dobu. ");
INSERT INTO wed_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Mai Israel Rephidim i netawanei da i nae au mutulua wavana Sinai. Ma kampa ola au karena i rauḡaravu. ");
INSERT INTO wed_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ma Moses i ḡae au ola da God ita nebelei. Ma Bada ola au tepana ma Moses i ḡorei i pa, “Wei mai Israel Jacob noinoina ma riwei. ");
INSERT INTO wed_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","—Taumi matamiei o inanai aiwai mai Egypt awarii a kauei ma me manubada natunatuna au papena e avavarai nanare a avaraimi ma a neiana-melemi awariu. ");
INSERT INTO wed_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Mepa da ona voteleteleu ma au parivainuaḡana bagibagina ona vojijina-kauei, lamna dam anatapui au dobu awariei taumi ana vinemi nuanuau pouna. Avena da dobu anatapuna Tau ḡariuei. ");
INSERT INTO wed_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Wate taumi aubaiu ona vipirisi, ma ami dam ona vovivirei tau ainelau aubaiu, wei babani mai Israel ma riwei.” ");
INSERT INTO wed_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ma Moses i ḡaira me ma dogadogara i kwatuei ma aiwai anatapuna Bada i ririwei i pariverei. ");
INSERT INTO wed_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ma rava anatapui i paribelana gogona i pa, “Tauai aiwai anatapuna Bada i ririwei ana kauei.” Ma Moses ai paribelana i ḡaiana-melei Bada awarina. ");
INSERT INTO wed_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Bada, Moses i riwei, “Tau apau potopotona au orana ana nei, da rava ina nonoriu Awarim ana bababani da ina vitumaḡana-nonoem.” Anina ma aiwai rava i ririwei Moses Bada i riwei. ");
INSERT INTO wed_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ma Bada Moses i riwei, “Ma ḡaira ma rava ma voagui amadodo ma au maratom da orai ina oḡai da tau ina viborumeu. Ma ai gara ina oḡai. ");
INSERT INTO wed_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ma ina vokaukaua au pom vitonuina aubaina. Nai maranaina Tau ana ḡairai au Ola Sinai, rava anatapui au matai. ");
INSERT INTO wed_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Parata ma tere-kwaviviroi au ola. Ma riwa bagibaginei ma riwei ma pa, ‘Ona inana-kaua da eḡa au ola ona ḡae bo ola ona tapedadani. Aiai da ola i tapedadani ina iraḡe.’ ");
INSERT INTO wed_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Mepa da rava bo ḡamoḡamo wei paratana i voraḡoni, taumi eḡa nai ravana bo ḡamoḡamona ona vodadani wate ḡaimei bo aierei ona viraḡeni. Wate maranai taure ponana i rarata lamna rava ina ḡae au ola.” ");
INSERT INTO wed_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ma Moses olei i ḡaira memei ma ana rava i riwei da orai i vokaukauei da God ina viborumei ma ai gara i oḡai. ");
INSERT INTO wed_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ma i riwei, “Ona vokaukaua mara vitonuina aubaina, marina da nai marana eḡa ona viawawana.” ");
INSERT INTO wed_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ubaubanai au pom vitonuina, waiparara, namanamara ma apau potopotona ola i purui, ma taure i tou. Maratagogi rava anatapui kampa i mamae i rovo kaukaua ma i sisi. ");
INSERT INTO wed_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ma Moses rava i ravena-opunei da God ita nebelei. Taui ola au karena i mairi. ");
INSERT INTO wed_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Bada ai araratanei i ḡairai ola Sinai au tepana. Ma bau potopotona olana i puru-pai. Bau kampa i ḡeḡae me modu potopotona e ararai nanare, ma olana anatapuna i vigugui. ");
INSERT INTO wed_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ma taure ponana i rarata. Ma Moses i babani ma God i paribelei ponana nonorana me waiparara. ");
INSERT INTO wed_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Bada i ḡairai ola Sinai au tepana ma Moses i kwatuei da ita ḡei ola au tepana. Ma Moses i ḡae. ");
INSERT INTO wed_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ma God i babani ma wei riwai i latoni, ");
INSERT INTO wed_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Tau Bada ami God, panipaniei au Egypt a taravaina-opunemi. ");
INSERT INTO wed_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Taumi eḡa god ḡelaui ona raudunelei, Tau ainelau ona rauduneleu. ");
INSERT INTO wed_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Taumi eḡa aiwai au mara bo au dobu bo boga au orana dobu au gabaurina kokoitaui ona kauei da ona raudunelei. ");
INSERT INTO wed_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Taumi eḡa kokoitaui ona raudunelei bo ona viborumei, aubaina Tau Bada ami God ununurana. Ma taui i gedugeduaieu ana kovoḡi da kimta au vi-4-na. ");
INSERT INTO wed_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Wate taui aiavoi nuanuau e vaivaini ma au tarawatu e vovojijini au nuavaina maemae-nonoana ana verei da kimta tausan nanare. ");
INSERT INTO wed_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Taumi eḡa Bada ami God wavana ona vinamei. Aiai da Bada wavana e vivinamei ina kovoḡi. ");
INSERT INTO wed_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabate eḡa nuanuami ina vuru ma ona notanotai ma ona vovivirei tau awariu. ");
INSERT INTO wed_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Aupom 6 ami nola ona kauei. ");
INSERT INTO wed_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Wate au pom vi-7-na lamna Sabate, lauvitau marana, i vovivirei Bada ami God aubaina. Wei au marana eḡa aiai ina nola: eḡa tam, natum orotona bo wavinena, am taunola orotona ma wavinena, bo am ḡamoḡamo, ma dobuḡela ravai awarim e mamae. ");
INSERT INTO wed_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Aubaina au pom six au orana Bada mara ma dobu i kauei; boga ma anatapui au orana. Wate i vilauvitau au pom au vi-7-na. Lamna aubaina Bada Sabate i viaiaini ma i vovivirei. ");
INSERT INTO wed_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Amam ma alom ma vivirei, da am lawana ina manawa au dobu, Bada am God e vereverem. ");
INSERT INTO wed_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Eḡa ma viraḡena. ");
INSERT INTO wed_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Eḡa ravaḡela awana ma viawawanei. ");
INSERT INTO wed_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Eḡa ma danene. ");
INSERT INTO wed_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Eḡa ma viwavu-moru ");
INSERT INTO wed_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Eḡa ravaḡela ana numa ma vikwinei. Eḡa ravaḡela awana ma vikwinei, bo ana taunola orotona bo wavinena, ana bulumakau, ana donki, bo aiwai ḡelaui ḡarinei. ");
INSERT INTO wed_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Aiai rava ḡelauna i ravi da i viraḡeni, nai ravana ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Wate mepa da i vunu-boai da i viraḡeni. Tauna ina ruba dobu a vinevineia kampa. ");
INSERT INTO wed_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Wate rava i vioga da i viraḡena, ma ana lawana aubaina i ruba pulo au aniapuna, ravana ina taravaina-opunei ma ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","—Aiai amana bo alona i ravi, nai ravana ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","—Aiai da rava ḡelauna i danenei da i gimarei bo awarina ma i nelaḡai, nai ravana ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","—Aiai da amana bo alona e parivai-apoapoeni nai ravana ina viraḡeni.” ");
INSERT INTO wed_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Mepa da oroto wavine matatapu i gwalai da i viawawanei, ma eḡa aiai wei wavinena ita rautani da ita ravaḡi. Nai orotona wavine mataopana ina vimaiei ma ina ravaḡi. ");
INSERT INTO wed_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Wate mepa da amana i viḡa, lamna maranai oroto matatapu ana mataopa ina vimaiei wavine amana awarina. ");
INSERT INTO wed_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Aiai wavinena e paraparauma lamna ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","—Aiai ḡamoḡamo i viawawanei lamna orotona ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","—Aiai pulo i apui god ḡelauna awarina ma eḡa tau Bada awariu lamna nai ravana ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","—Eḡa dobuḡela ravai ona ḡoa-boai, ona notai da taumi mara tagogi o mae dobuḡela ravami au Egypt. ");
INSERT INTO wed_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","—Eḡa kaikaiababa ma kedakeda ona ḡoa-boai. ");
INSERT INTO wed_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Mepa da nanare ona kauei ma taui ina tou awariu agu aubaina, Tau Bada, ai tou anina ana nonori ma ana voagui. ");
INSERT INTO wed_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ma Tau ana meji guratana ma ḡavia au orana ana viraḡenimi. Awawami ina vikaiababa ma natunatumi eḡa amamai. ");
INSERT INTO wed_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","—Mepa da mane u unelei molamolakana awarina, lamna eḡa mane ḡelauna au tepana ma vibaḡei. ");
INSERT INTO wed_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Mepa da rava ḡelauna ana kwama u vaia da manena ina veremelem ma muriai ma vere-melei, ana kwama ma vere-melei muriai da madeḡa ina ḡaira. ");
INSERT INTO wed_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Kwamana lamnei e purupurui da inina e vivibola. Bo aiwai ḡelauna e mamae da ina vipuruei? Mepa da kwama eḡa uta veremelei ma tauna awariu i tou agu aubaina ma Tau ana paribelei aubaina Tau rau-nuapoapoeu.” ");
INSERT INTO wed_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Eḡa riwa moru ma vituai. Ma eḡa au numa-etara moruei kaua apoapoe ravana ma voagui. ");
INSERT INTO wed_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Eḡa patara ma ḡovaivaitei ma ḡoʼapoapoe ma kaukauei. Maranai au numa etara e maimairi eḡa moruei ḡoʼapoapoe patarai ma voagui. ");
INSERT INTO wed_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses i nae mai Israel awari ma Bada ana viararamana ma ana tarawatu anatapui i riwei ma rava anatapui pona tagoginei i paribelei i pa, “Tauai Bada aiwai i ririwei anatapuna ana kauei.” ");
INSERT INTO wed_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ma Moses, Bada aiwai i ririwei anatapuna i girumi. Ubaubanai boiboḡi i vomairi ma pulo aniapuna i voai ola au karena ma ḡaima ḡaeḡae 12 i vimairini Israel ana dam 12 i vimatairei. ");
INSERT INTO wed_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Anina ma Israel laralaragai i paritawanei da ḡamoḡamo i vununaiei ma pulo i apui Bada awarina ma bulumakau ḡelaui i vunui da ai viturana ma mae-kaua pulona. ");
INSERT INTO wed_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses ḡamoḡamo tarai navanavana i ḡunaiei au aboma ma navanavana ḡelauna pulo aniapuna au tepana i voiwaiwaḡi. ");
INSERT INTO wed_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ma parivainuaḡana bagibagina bukana i vaia ma rava awarii i ʼavi. Taui i paribelei, “Tauai aiwai anatapuna Bada i ririwei ana kauei, ana babani ana voteletelei.” ");
INSERT INTO wed_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ma Moses aboma i vaia ma tara i voiwaiwaḡi rava au tepai. Ma i riwa i pa, “Wei taranei ata tarawatu i vovai-virewapani ma i vianinei. —Maranai Bada tarawatu i veremi, Tauna parivainuaḡana bagibagina taumi maiteni i kauei.” ");
INSERT INTO wed_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Bada, Moses i riwei, “Ma ḡei awariu au ola ma weka ma mae, ma ḡaima dabadabai ruaḡa au tepai, riwau ma au tarawatu a girugirumia ana verem da mai Israel ma viararamani.” ");
INSERT INTO wed_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Ma Moses ana taunola Joshua maiteni i vokaukaua da ita ḡae au ola. Ma Moses babada awarii i babani i pa, “Weka ona painiai da ana opu-memei. Aaron ma Hur e mamae, mepa da ami paripariḡai aiwai da ona nae awarii.” ");
INSERT INTO wed_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ma Moses i ḡeḡae au ola ma apau ola i purui ");
INSERT INTO wed_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ma Bada ana boruma i peu au ola Sinai. Ma au pom six apau ola i purui, ma au pom au vi-7-na Bada apau au orana ma Moses i ḡorei. ");
INSERT INTO wed_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Mai Israel i taepai ma ola au tepana Bada ana boruma i ʼnanai me ai arata ḡaeḡaena ai menamenana ma bauna potopotona. ");
INSERT INTO wed_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ma Moses i ḡae au ola ma apau au orana i rui. Ma au ola i mae au pom 40 ma waguvarai 40. ");
INSERT INTO wed_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Rava Numa Gara Vivivireina ina voai, da taui maiteni ana mae. ");
INSERT INTO wed_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Numa gara ma orana purapurai ana viatataiem nanare ona voai.” ");
INSERT INTO wed_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ma bokisi ai acaciei ina voai, ana manawa 110 cm, ma ana dabora 66 cm, ma ana ḡae 66 cm. ");
INSERT INTO wed_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ma gold aiainei ma viaitani au orana ma au doa, ma au tepana ana via goldei ma tere-kwaviviroi. ");
INSERT INTO wed_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ma ana loji 4 ma vokaukauei ma au aena 4 ma terei; ma au baba ḡelauna loji ruaḡa ina mae ma au baba ḡelauna loji ruaḡa ina mae. ");
INSERT INTO wed_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ma ai acaciei anipawe ma kauei, ma goldei ma viaitani. ");
INSERT INTO wed_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ma anipawe au loji bokisi au babana ma raviai, da ina pawei. ");
INSERT INTO wed_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Anipawe au loji ina mae, eḡa ina taina-lavui. ");
INSERT INTO wed_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ma au tarawatu ḡaima dabadabai ruaḡa au tepai a girugirumia bokisi au orana ma terei. ");
INSERT INTO wed_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","—Ma uḡu, gold aiainei ma kauei, ana manawa 110 cm, ma ana dabora 66 cm. ");
INSERT INTO wed_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ma Cherub ruaḡa ma kauei gold gudagudanei ma uḡu au giana ruaḡa ma terei. ");
INSERT INTO wed_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ma Cherubim ḡelauna au gia ḡelauna ma Cherubim ḡelauna au gia ḡelauna ma kauei da uḡu maiteni ina vitagogi. ");
INSERT INTO wed_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ma Cherubim papei au aidamo ina viloloi, ma ina vinao vereverena, da ḡoʼapoapoe tauvaitawaneina uḡuna ina gagaloei. ");
INSERT INTO wed_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Uḡu au tepana ma terei, ma ḡaima dabadabai ruaḡa bokisi au orana ma terei. ");
INSERT INTO wed_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ma uḡu au tepana, Cherubim ruaḡa au poui kampa tana vinenebelana da au tarawatu ana verem rava mai Israel aubaii.” ");
INSERT INTO wed_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ma God i riwa, Tuam Aaron natunatuna Nadab, Abihu, Eleasar ma Ithamar maiteni mai Israel awariei ma tereriei. Ma ma viaiaini da Tau aubaiu ina vipirisi pulo tauapuina. ");
INSERT INTO wed_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ma pirisi ana ḡara vivivireina ma popoi vareim aubaina da inanana ina vinualaulauna ma rava ina vivirei, ");
INSERT INTO wed_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Rava rarau-ḡaroḡaroi ma nuaulaulai, ma ḡoreiai da Aaron ana pirisi garana ina popoi da ina oteni ma ina viaiaini da aubaiu ina vipirisi. ");
INSERT INTO wed_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ma Bada Moses i riwei, ");
INSERT INTO wed_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ma inana, Tau Besalel, Judah ana damei a vinei, tauna Uri natuna, ma Hur ḡoḡana, ");
INSERT INTO wed_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ma Aruau Vivivireina a verei. Ma nuaulaulaula ma nota ma aramana a verei da rau-ḡaroḡaro anatapui awari tauna tagotagogina. ");
INSERT INTO wed_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Tauna taurauḡaroḡaro amai, Gold, Silver ma Bronze taunoleina aiaina. ");
INSERT INTO wed_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Tauna i ai kaua ḡaima e boribori ma e laḡalaḡai, ma amtai awarina. Tauna rau-ḡaroḡaro anatapuna awarina tagotagogina. ");
INSERT INTO wed_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ma nanare Oholiab a vinei, tauna Ahisamak natuna, Dan ana au dam da ana tauagu. Ma nanare taurauḡaroḡaro nuaulaula ma aramana a verei da aiwai anatapuna a ririwem ina kauei. ");
INSERT INTO wed_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Numagara Vivivireina ma parivainuaḡana bokisi ma uḡu ma numagara ana purapura: ");
INSERT INTO wed_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","kepakepa ma ana purapura; rampa gold aiainei ma purapura ḡelaui ma incense aniapunana. ");
INSERT INTO wed_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Pulo aniapuna ḡamoḡamo taputapuna apuna aubaina. ");
INSERT INTO wed_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ma gara vinualaulaunai ina popoi, gara vivireina ina popoi Pirisi Ḡeḡetelarana Aaron aubaina ma natunatuna pirisi nolana aubaina aubaii, ");
INSERT INTO wed_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","monamona viaiaina aubaina ma incense Bada ana numa aubaina. Taurauḡaroḡaro wei purapurai ina rauḡaroḡaroei me a ririwei nanare.” ");
INSERT INTO wed_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Maranai rava i ʼnanai da Moses barana i uama au ola, taui i nei Aaron awarina ma i riwei, “Ma nei ma god ma voai da ina painita. Wei ravana Moses, Egyptei i neiaita weka, eḡa ata aramanei aiwai i tupua awarina.” ");
INSERT INTO wed_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron i paribelei, “Awawami ma natunatumi waivinei ma nelarai ai loji goldei ona neiai awariu!” ");
INSERT INTO wed_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Anina ma rava anatapui ai loji i votawatawanei ma i neiai Aaron awarina. ");
INSERT INTO wed_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Tauna i vaia ma ai au menamenana i apui da i wanagwadai ma bull natuna kokoitauna i voai. Maranai rava wei i ʼnanai ma i riwa, “Oo mai Israel wei ami god, Egyptei i tere-opunemi.” ");
INSERT INTO wed_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Maranai Aaron wei i ʼnanai ma pulo aniapuna i voai bull au naona ma i vinolanola i pa, “Au maratom tana torela Bada aubaina.” ");
INSERT INTO wed_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ma Ubaubana boiboḡi rava i vomairi da ḡamoḡamo taputapuna i apui ma viturana maiteni pulona i terei. Muriai i kiala da i am gogona ma i uma-bua guratana da i kaua labalababa. ");
INSERT INTO wed_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Anina ma Bada Moses i riwei, “Ma ḡaira ma am rava Egyptei u tere-opunei. Tau i geduaieu ma kaua apoapoena i kauei. ");
INSERT INTO wed_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Taui me marana au tarawatu i geduaiei ma bull natuna kokoitauna i kauei. Ma i raudunelei ma pulo i apui awarina ma i riwa, ‘Wei ami god, Oo Israel, Egyptei i tere-opunemi.” ");
INSERT INTO wed_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ma Bada Moses i riwei, “Wei ravai a inanai ma a aramanei taui kolai bagibagii, ma nuapoui eḡa. ");
INSERT INTO wed_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ma votereu da au meji ana vikwai taui awarii ma ana pupuni. Ma tam Moses ana terem da am epaepaia maiteni dam patarai ḡaeḡaena ona vitupui.” ");
INSERT INTO wed_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Wate Moses God i vigigimanei i pa, “Oo Bada am rewapana ḡaeḡaenei am rava Egyptei u tere-opunei lamna aubaina eḡa am rava awarii ma meji ma ma pupuni. ");
INSERT INTO wed_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mepa da ma pupuni, Mai Egypt ina riwa, ‘Ana nota apoapoena maranai i tere-opunei da au ola anatapui ita pupuni.’ Meji avena, oram ina uba, ma eḡa ma vipupui. ");
INSERT INTO wed_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Am taunola Abraham, Isaac ma Israel ma notai, tam wavamei u parivainuaḡani, ‘Tau am epaepaia ana vimaḡai me ubona au mara ma wei dobuna a paripari-vainuaḡani ami epaepaia ana vere-nonoei.” ");
INSERT INTO wed_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Anina ma Bada orana i uba ma eḡa apoapoena ita neiai awarii. ");
INSERT INTO wed_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ma Moses i ḡaira me, au urana ḡaima ruaḡa dabadabai. God ana tarawatu wei ḡaimai au naoi ma au murii i girumi. ");
INSERT INTO wed_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ḡaima dabadabai lamna God ana kaua. Tauna ainelana i girumi. ");
INSERT INTO wed_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Maranai Moses i turiai mepa rava i rauḡaravu ma bull natuna goldei i ʼnanai i maimairi ma rava i arara i ʼnanai. Tauna meji orana i oai ma ḡaima dabadabai ruaḡa i viorereni au doa. I viaigimagimai ola au karena. ");
INSERT INTO wed_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Moses bull natuna goldei i vaia ma i apui ma i tutu-gwadagwadai da i vipokau ma au waira i tawanei ma mai Israel i egari da i uma. ");
INSERT INTO wed_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ma Aaron i riwei, “Rava aiwai i kauei awarim da u kauei da kaua apoapoe kaukauna i kauei.” ");
INSERT INTO wed_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron i paribelei, “Au bada eḡa ma ḡaiawa, rava ai kaua u aramanei, kaua apoapoe ai ḡai. ");
INSERT INTO wed_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ma i riweu, ‘god ma kauei da ina ravenita. Ma wei ravana Moses, Egyptei i tere-opunelai, tauai eḡa ata aramanei aiwai awarina i tupua.’ ");
INSERT INTO wed_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Lamna aubaina rava a riwei, ‘Aiaia awarina via goldei ona votawanei ma i vereu.’ Ma ai au menamenana a tawana-ruiei ma wei bull natuna i opui!” ");
INSERT INTO wed_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses i ʼnanai da Aaron eḡa tagotagogina da rava ita vibadei, ma ana ḡavia ai anivinama i kauei. ");
INSERT INTO wed_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Lamna aubaina ai rauḡaravu au metaetana i mairi ma i garara, “Aiai da Bada au murina, ona nei awariu!” Ma Levi ana dam i nae Moses au murina. ");
INSERT INTO wed_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ma Moses taui i riwei, “Bada, Israel ana God e ririwa. Nelara sod ona lavui ma ona nae ḡaravu au giana da ona nenememei ma dam turam ma vareim ma mae-turam ma viraḡeni.” ");
INSERT INTO wed_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levi ana dam Moses i voteletelei ma nai au marana nelara 3,000 i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ma Moses i riwa, “Amadodo Bada taumi i voviviremi ma i viaiainimi da aubaina ona vipirisi pulo tauapuina, aubaina taumi Bada o voteletelei da natunatumi ma varevareimi o viraḡeni.” ");
INSERT INTO wed_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ma maratomna Moses rava i riwei, “Taumi ḡoʼapoapoe ḡaeḡaena o kauei wate ana ḡae Bada awarina da ana kauana dadanei da ami ḡoʼapoapoe ina nota-tawanei.” ");
INSERT INTO wed_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Anina ma Moses i ḡae me Bada awarina ma i riwa, “Au rava kaua i apoapoe ḡaḡa i kauei. Taui ai god goldei i kauei ma i raudunelei! ");
INSERT INTO wed_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Wate marina Bada a vivibaḡaim da ai ḡoʼapoapoei ma nota-tawanei ma mepa da eḡa lamna avena ma wavau am au buka ma boa-tawanei.” ");
INSERT INTO wed_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ma Bada Moses i paribelei, “Aiavoi ḡoʼapoapoei i kauei awariu, Tau wavai au buka ana boai. ");
INSERT INTO wed_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Marina ma nae, rava ma naiei dobu a ririweia ma au anela ina ravenim. Wate mara ina ḡeta da ana kovoḡa, taui ai ḡoʼapoapoe aubaina ana kovoḡi.” ");
INSERT INTO wed_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ma Bada doria apoapoenei rava i kovoḡi aubaina taui god bull natuna Aaron i voai i raudunelei. ");
INSERT INTO wed_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Bada, Moses i riwei, “Ḡaima ruaḡa dabadabai ma bori inanana me ruaḡa u wamawamaia, ma au tepana riwana tagogina ana girumi me au naona. ");
INSERT INTO wed_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ma vokaukaua ma ubaubanai ma ḡei ola Sinai au tepana ma nebeleu.” ");
INSERT INTO wed_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ma Moses, ḡaima ruaḡa i bori me au naona nanare. Ubaubanai boiboḡi ḡaimai i voai ma i ḡae au ola Bada i ririwei nanare. ");
INSERT INTO wed_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ma Bada apauei i ḡairai ma au ririvana i raumairiei, ma wavana i latoni, “Bada!” ");
INSERT INTO wed_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ma Moses au naona i babara ma i viḡoreḡore, “Tau maemae nonoana! Tau rarau-nuapoapoeu ma iviu aiaina, tau eḡa laḡilaḡina amlou ita voḡaiḡai. ");
INSERT INTO wed_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Au nuavaina maemaena ina mae au rava awarii da kimta tausan ina kwa ma kaua apoapoe, mae-ḡaeḡae ma ḡoʼapoapoe ina nota-tawanei. Wate tauna eḡa kaua apoapoe taukauei ita inana-tawanei, natunatui ma ḡoḡoḡai, amamai i kaukauei kovoḡana e vaivaia da kimta vitonuina da vi-four-na.” ");
INSERT INTO wed_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses maratagogi i mae-peu au doa ma Bada i viborumei. ");
INSERT INTO wed_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","I riwa, “Au bada mepa da riwa kaua da tam nuanuau u vaia, a vivibaḡaim da uta vinao ma tata nae. Wei ravai orai badobadoi, wate ai kaua apoapoe ma ai ḡoʼapoapoei ma nota-tawanei, ma ma vai-meleiai am buderi.” ");
INSERT INTO wed_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Bada, Moses i riwei, “Ma rautaniḡana! Au parivainuaḡana bagibagina tam maiteni a kaukauei am patara Israel maiteni. Ma au matami kaua ḡaeḡae aniba kauai ana kauei. Eḡa melanai aiai wenanare ita kauei au dobu. Rava anatapui au ririvami e mamae, au rewapana ina inanai da tau, Bada kaua ḡaeḡae ana kauei aubaimi.” ");
INSERT INTO wed_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses kampa i mae Bada maiteni au pom 40 ma waguvarai 40, eḡa ita am ma eḡa ita uma nai au marana. Ma Bada ḡaima au tepana parivainuaḡana riwai - Tarawatu 10 i girumi. ");
INSERT INTO wed_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moses ḡaima ruaḡa au tepai parivainuaḡana riwai i vinimavoei ma ola Sinaiei i ḡairai. Wate eḡa malana ita vaia da naona i lalalai aubaina tauna Bada maiteni i babani. ");
INSERT INTO wed_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron ma Israel patarai i ʼnanai da Moses naona i lalalai ma awarina naena i rovoei. ");
INSERT INTO wed_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Wate Moses taui i ḡorei, ma Aaron ma dogadogara i nei awarina, ma awarii i babani. ");
INSERT INTO wed_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ma mai Israel i riei Moses awarina ma tarawatu ola au tepana i vereverei rava i pariverei. ");
INSERT INTO wed_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moses naona garei i purui maranai awari i babani-vorovei. ");
INSERT INTO wed_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Maranai Moses e ruirui au numagara da Bada maiteni ina babani, ḡarana naona i purupurui lamna, e vovotawanei. Ma e opuopu memei ma Bada aiwai i riwei mai Israel e paripariverei, ");
INSERT INTO wed_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ma mai Israel, i ʼnanai da Moses naona i lalalai. Lamna maranai Moses naona i puru-melei da ina rui me da Bada awarina ina babani. ");
INSERT INTO wed_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ma Bada Moses i riwei, ");
INSERT INTO wed_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Au Numa Gara Vivivireina ma vimairini aupom tagogi, madeḡa au vouna. ");
INSERT INTO wed_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tarawatu 10, Parivainuaḡana bokisina au orana ma poai, ma au naona anitereḡaḡara ma teretaḡonei da numa garana ina babalaraḡi. ");
INSERT INTO wed_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Teibol ma ruiei ma au tepana aiwai i kaukauei aubaina ma terei. Ma rampa anivojijinana ma ruiei, ma rampa ma terei ");
INSERT INTO wed_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ma incense aniapuna goldei ma terei bokisi au naona ma anitereḡaḡara ḡelauna ma terei da Bada ana numa gara vivivireina ina gudui. ");
INSERT INTO wed_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Numa gara au metaetana, au doa, pulo aniapuna ma terei. ");
INSERT INTO wed_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Anirauoḡa numa gara ma pulo aniapuna au poui ma terei ma waira ma vioai. ");
INSERT INTO wed_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Numa gara ma pulo aniapuna anitereḡaḡara ma tere-kwaviviroi da dobuna ma gari. Ma au anirui anitereḡaḡara ma vidawei. ");
INSERT INTO wed_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","—Ma oil viaiainana ma vaia ma numa gara ma purapura anatapui au orana ma buloi ma ma vovivirei da vivivireina. ");
INSERT INTO wed_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ma pulo aniapuna ma ana purapura maiteni ma buloi ma ma vovivirei da vivivireina. ");
INSERT INTO wed_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Anioḡa abomana ma ana animairi maiteni ma buloi ma ma vovivirei da vivivirei. ");
INSERT INTO wed_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","—Aaron natunatuna ma neiai numa gara vivivireina au metaetana ma wairei ma oḡai. ");
INSERT INTO wed_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ma Aaron pirisi ana gara vivivireina ma vioteni ma oilei ma vovivirei da aubaiu ina vipirisi pulo tauapuina. ");
INSERT INTO wed_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ma natunatuna ma neiai ma pirisi pulo tauapuina ai gara ma vioteni. ");
INSERT INTO wed_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ma ma buloi me amai u buloi nanare da ina vipirisi pulo tauapuina. Wei viaiainana Aaron ana epaepaia i vovivirei da mara nonoa kimtana patapatana awari ina vipirisi pulo tauapuina. ");
INSERT INTO wed_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses anatapuna i kauana-paiei me Bada i ririwa nanare. ");
INSERT INTO wed_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","—Anina ma madeḡa au viruaina au pom tagogi nawaravi tagogi, taui numa gara vivivireina i vimairini. ");
INSERT INTO wed_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses dogo i ḡarai ma tuatua i tonei ma terewaba ma anitapejijinana i ragini. ");
INSERT INTO wed_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ma gara ḡamoḡamo opinei i ḡauḡauri au tepana i ebani, Bada i ririwei nanare.” ");
INSERT INTO wed_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Anina ma Moses ḡaima dabadabai ruaḡa bokisi au orana i terei. Ma anipawe loji au orana i vionaḡi bokisi au adana, ma uḡuna i viaitani. ");
INSERT INTO wed_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ma bokisi i ruiei God ana au numa gara vivivireina ma anitereḡaḡara i terei da bokisi i mae-ḡaḡari, Bada i ririwei nanare. ");
INSERT INTO wed_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ma nanare teibol i ruiei God ana au numa gara, anitereḡaḡara i mae ma au doei, au laubadei i terei ");
INSERT INTO wed_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ma teibol au tepana palawa i pulopuloei Bada awarina i terei, Bada i ririwei nanare. ");
INSERT INTO wed_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Rampa aniterenana i vaia ma au numa gara teibol au naona, au babaḡela au rauanaḡei i vikialai. ");
INSERT INTO wed_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ma rampa i apui Bada awarina, me i ririwei nanare. ");
INSERT INTO wed_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Incense aniapuna goldei anitereḡaḡara au naona i terei numa gara vivivireina au orana. ");
INSERT INTO wed_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Anina ma au tepana incense ḡabuḡabui i apui, Bada i ririwei nanare. ");
INSERT INTO wed_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ma anitereḡaḡara i terei da aninae au numa gara vivireina i gudui. ");
INSERT INTO wed_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Pulo aniapuna Bada ana numa gara vivivireina au metaetana. Au tepana ḡamoḡamo ma palawa i apui me Bada i ririwei nanare. ");
INSERT INTO wed_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ma aboma ḡaeḡaena numa gara ma pulo aniapuna au poui i terei, ma au orana waira i waḡi anioḡa aubaina, ");
INSERT INTO wed_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ma kampa Moses ma Aaron ma natunatuna urai ma aei i oḡai. ");
INSERT INTO wed_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Taui aei ma urai e oḡaoḡai maranai e ruirui au numa gara bo e nenae pulo au aniapuna. ");
INSERT INTO wed_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ma Moses Numa gara ma Pulo aniapuna i gari-kwaviviroi. Ma anitereḡaḡara i terei au anirui. Anina ma Moses ana nola i kwa. ");
INSERT INTO wed_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ma apau Bada ana Numa Gara Vivivireina i purui ma ana boruma numana i vioai. ");
INSERT INTO wed_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Apau numa gara vivivireina au tepana i kiala ma Bada ana boruma numana i vioai ma lamna aubaina Moses eḡa tagotagogina da ita rui. ");
INSERT INTO wed_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ma apau i vovoepa lamna maranai mai Israel ina vaḡai au dobuḡela. ");
INSERT INTO wed_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ma mepa da apau eḡa ita voepa lana taui eḡa ina nae. ");
INSERT INTO wed_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Maranai mai Israel e vaḡavaḡai, Bada ana animae apau au orana numa gara vivivireina au tepana ma waguvarai tauna ai apau au orana e ararata. ");
INSERT INTO wed_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Bada au Numa gara Vivivireina ma Moses i kwatuei ma i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Wei au pariverena pulo apunana aubaina. Mai Israel ma riwei ma pa, ‘Aiai da Bada awarina ḡamoḡamo e apuapui, lamna bulumakau tagogi bo sipu bo gote i ḡamoḡamoi ina neiai ana pulo. ");
INSERT INTO wed_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","—‘Mepa da ḡamoḡamo taputapuna e apuapui am pulo, ma inanai da ḡamoḡamo orotona aiaina ma eḡa ana apoapoe aiwai. Ma neiai Numa gara Vivivireina ana au anirui, da Bada ina vianinem.’ ");
INSERT INTO wed_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ma uram ḡamoḡamona au kolana ma terei, wei e vivimataira da ḡamoḡamo i raviepaiam da ina iraḡe am ḡoʼapoapoe ina oḡa-tawanei. ");
INSERT INTO wed_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ma bulumakau Bada au naona ma viraḡeni, ma pirisi Aaron natunatuna tara, ina neiai da pulo aniapuna au adana ina voiwaiwaḡa-naiei. ");
INSERT INTO wed_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Anina ma Ḡamoḡamo ma opai ma ma api. ");
INSERT INTO wed_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ma Aaron natunatuna, ai ina viviri pulo aniapuna au tepana. ");
INSERT INTO wed_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","9","Taui sia apiapina ai araratana au tepana ina terei da ina arai, kolana da monamona maiteni. Wate amoamo da ganigani ma sia aei wairei ina oḡai, ma pirisi siana anatapuna ina apui. Wei pulona apuapunana lamna ḡabuna aiaina Bada ina vinuaiaini.” ");
INSERT INTO wed_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Bada Moses awarina i babani i pa, “Aiai da nuauba amna aubaina ana pulo bulumakau e apuapui, ma inana-kauei da burumakauna orotona bo wavinena, aiaina ma eḡa ana apoapoe aiwai. ");
INSERT INTO wed_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ma urana ḡamoḡamo au kolana ina terei ma ina viraḡeni Numa Gara Vivivireina ana au anirui. Ma pirisi Aaron natunatuna tara pulo aniapuna au adana ina voiwaiwaḡa-naiei. ");
INSERT INTO wed_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","Ma amoamo monamona ava ma kaina monamona ma ganigani ana monamonana, pirisi ina verei da ina apui nuauba pulona. ");
INSERT INTO wed_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ma Aaron natunatuna wei monamonai sia taputapuna e ararai au tepana ina terei ma ina apu-tagogiei, pulo aniapuna au tepana. Wei amgogona pulona ma ḡabuna i ai kaua Bada awarina.” ");
INSERT INTO wed_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Bada Moses ma Aaron i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Mepa da aiai kero bo paramaitua i vaia bo opina i lebara ma e notanotai da wei kerona e viviopidoriana, lamna ana rava tauna ina naiei pirisi Aaron bo natuna tagogi awarina. ");
INSERT INTO wed_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Pirisi kero vioana ina inanai. Mepa da apara au kero e vivimairiana i arapoira ma dogona i ḡaira lamna opidoriana. Ma pirisi ina riwa da tauna eḡa aiaina Bada au matana. ");
INSERT INTO wed_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","—Rava aiai opidoriana i vaia, tauna gara wanasikasikana ina oteni, aparana eḡa ina jinai ma naona ina purui ma ina kwatu ina pa, ‘Tau eḡa aiaiu! Eḡa ona nei au ririvau!’ ");
INSERT INTO wed_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Maranai doriana awarina e mamae lamna tauna anina miramirana, Tauna ainelana ina mae au tano.” ");
INSERT INTO wed_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Aiai Israelieina bo jentail maiteni o mamae, sia taratarana e aniani, Bada tauna ina mae-puputei ma ana rava awariei ina bori-tawanei. ");
INSERT INTO wed_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Aiwai anatapui da lawalawaii ai lawana au tarai e mamae ma lamna aubaina Bada i riwa da tara pulo au aniapuna ona voiwaiwaḡi da rava ai ḡoʼapoapoe ina vaitawanei. Tara lamna lawana, ma lamnei ḡoʼapoapoe e vaivai-tawanei. ");
INSERT INTO wed_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Bada Moses i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Mai Israel awari ma babani ma ma riwei, ‘Tau Bada ami God.’ ");
INSERT INTO wed_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Mai Egypt ai kaua eḡa ona ḡovaivaitei, Wariaḡa kampa o mae, marina a taratara-vainanaiemi au Canaan ma ai kaua eḡa ona ḡovaivaitei. Eḡa ai lawana ona votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Taumi au tarawatu ona voteletelei ma riwau ona votaḡotaḡoi. Tau Bada ami God. ");
INSERT INTO wed_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Mepa da au tarawatu ma riwau ona voteletelei taumi lawana ona nelaḡai. Tau Bada a riwa.” ");
INSERT INTO wed_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Tau Bada wei au babani bagibagii a vereveremi, “Eḡa aiai novuna bo vareina ina viawawanei. ");
INSERT INTO wed_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","—Maranai wavine nawaravi i vunui tauna miramirana, eḡa maiteni ma viawawana. ");
INSERT INTO wed_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","—Eḡa oroto ḡelauna awana maiteni ma viawawana, lamna tam u vimira-melem. ");
INSERT INTO wed_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","—Natunatumi eḡa ona puloei god Molek awarina, aubaina Tau Bada ma vinimala e neineiai awariu. ");
INSERT INTO wed_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","—Eḡa aiai orotona, oroto ḡelauna ina viawawanei, me oroto waivine e viawawanei, wei lamna ḡoʼapoapoe kaukauana God au matana. ");
INSERT INTO wed_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","—Eḡa aiai orotona ḡamoḡamo ina viawawanei bo wavine ina verena-melei da ḡamoḡamo ina viawawanei. Mepa da wei u kauei tam u vimira-melem. ");
INSERT INTO wed_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","—Eḡa wei kauai ona kauei da ina vimiramiraimi. Dam au Canaan maemaei anatapui wei kauai i kauei ma i vimira-melei. Lamna aubaina ana viaḡaḡana-opunei ma taumi ona rui.” ");
INSERT INTO wed_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ma Bada Moses i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Dam Israel anatapui ma tuarui ma ma riwei, ‘Taumi lawana vivivireina ona maeni. Aubaina Tau Bada ami God vivivireiu.’ ");
INSERT INTO wed_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","—Eḡa oram ina raviapiai kaua apoapoena ravana awarina, wate maiteni ona kiala da kaua ona tere-vaijijimani, da eḡa ḡoʼapoapoe ona kauei. ");
INSERT INTO wed_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","—Eḡa ma raubiwa am rava awarii, eḡa aiai ma ḡoaḡaiei, wate rava turam nuanuam ina vaia me tam nuanuam e vaivai-melei. Tau Bada.” ");
INSERT INTO wed_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Aiai ravana i ḡoei da kaua anoi ita aramanei, lamna Tau ina vibaḡaiu. Eḡa vinuaterena aubaina ina nae konakonaḡa awarii ina bababani. Mepa da aiai wei i kauei, nai ravana ana mae-puputei, ma au rava awariei ana viopuni. ");
INSERT INTO wed_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Mepa da aiai turana i vikeroi, aiwai i kaukaueia awarina nanare ina kauei. ");
INSERT INTO wed_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Mepa da gelama i viaigai, gelamina tagogi ina wanagai, mepa da mata tagogi i viapoapoeni, matana tagogi ina apoapoei. Mepa da ivo tagogi i viaigai, ivona tagogi ina wanagai. Aiwai kerona rava ḡelauna i verei, tauna nanare ina kero. ");
INSERT INTO wed_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Aiai ravana ḡamoḡamo i viraḡeni ina vimaiei, wate aiai da rava i viraḡeni, tauna ina iraḡe. ");
INSERT INTO wed_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Wei tarawatuna taumi anatapumi aubaimi, mai Israel ma dobu ḡela ravai, aubaii Tau Bada ami God. ");
INSERT INTO wed_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Bada Moses i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aaron ma natunatuna ma riwei da wenanare mai Israel ina viaiaini ina pa, ");
INSERT INTO wed_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Bada ina viaiainimi ma ina gagaloemi. ");
INSERT INTO wed_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Bada ivina ina ai awarimi ma ina paina-kauemi. ");
INSERT INTO wed_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Bada ana nuaiaina ina mae-tavirei awarimi ma nuauba ina veremi.’ ");
INSERT INTO wed_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ma nanarena, maranai Aaron ma natunatuna Tau wavauei mai Israel e viviaiaini, ma Tau ana viaiaini.” ");
INSERT INTO wed_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Bada Moses i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Mai Israel ai dam 12 au orai rewapana tagotagogi ava ma vinei, da ma paritawanei da Canaan dobuna ina ivui, wei dobuna mai Israel a vereverei.” ");
INSERT INTO wed_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ma Bada i ririweia nanare Moses i kauei. Mai Israel ai dam 12 babadai i paritawanei. Taui ai ḡaravu au mutulua Paran i voterei da i nae au Canaan. ");
INSERT INTO wed_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Maranai Moses ravai i paritawanei da dobuna ita ivui ma i riwei i pa, “Au Negev ona virautua da dobu violaolana ona naeni da au navanava ḡelauna. ");
INSERT INTO wed_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Dobu ona tuvirevirei, ma ana patara ona inanai menanare, rava ai maḡa ma ai rewapana bo ai ḡokokokara? ");
INSERT INTO wed_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Doa maumaurana bo eḡa? Ai melaḡai ona tuvirevirei, garigarina bo e mamae lota? ");
INSERT INTO wed_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Doa maumaurana bo eḡa? Ai e gogogo bo eḡa? Ma ona kauana-guratei da ai anoi ḡelaui ona purai da ona neiai.” ");
INSERT INTO wed_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Anina ma taui dobuna i naeni, au mutulua Zin i vikarei ma dobuna i naeni da au gia dewadewana au Rehob, wei lamna Lebo Hamath au ḡereḡerena. ");
INSERT INTO wed_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Au pom 40 taurauivu dobu i tuvirevirei ma i nememei, ");
INSERT INTO wed_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","27","I nei Moses, Aaron ma Israel patarai awari au Paran mutuluana au Kadesh ma ai anoi au dobuna i vaivaia i viatataiei. Ma i pariverei i pa, “U paritawanelai da dobuna a ivui, marina grape ana ḡou marana ma a inanai da ani ipi gabuna aiaina ma doa maumaurana, ma aina anoi ḡelaui a neiai da ona inanai. ");
INSERT INTO wed_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Wate kampa rava ḡaiḡaiawai e mamae, ma ai melagai i rata kaua ma i gari-kwaviviroi da eḡa ḡavia ina rui. Ma kampa mai Anak a inanai. ");
INSERT INTO wed_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Mai Amalek au mutulua Negev e mamae, ma mai Hitti mai Jebus ma mai Amori au ola e mamae ma mai Canaan au gera, Jordan wairana au ririvana e mamae.” ");
INSERT INTO wed_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ma Caleb, rava i riwei da i genuana ma i riwa i pa, “Tana nae dobuna ravai tana virubai ma dobuna tana vaia!” ");
INSERT INTO wed_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Wate taurauivu maiteni i ḡeḡae i pa, “Eḡa! Ravai i virewapana kaua eḡa me tauta. Eḡa tana viḡaviei.” ");
INSERT INTO wed_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ma nanare taui nai dobuna ana apoapoe riwana i vibabarai mai Israel awari i pa, “Nai eḡa ani ipi doana aiaina ma rava manamanai ma ḡaiḡaiawai kampa e mamae. ");
INSERT INTO wed_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ma kampa rava ḡaiḡaiwai Mai Nephili a inanai (Mai Anak noinoii) tauai a inana-meleiai lamna me kapau ma nanare taui au matai lamna tauai me kapau.” ");
INSERT INTO wed_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ma nai waguvaraina rava anatapui i tou mara. ");
INSERT INTO wed_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Taui anatapui Moses ma Aaron i viḡaviei i pa, “Airake au Egypt ata iraḡe ota! Bo weka au mutulua. ");
INSERT INTO wed_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Aiwai aubaina Bada e nainaieta wei au dobuna da ravai sodei ina viraḡenita ma awawata ma natunatuta ina pani-naiei. I ai kaua da tata wanaviraita au Egypt.” ");
INSERT INTO wed_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ma taui i babani vivira i pa, “Bada tana vinei da ina naiana-meleta au Egypt.” ");
INSERT INTO wed_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Anina ma Moses ma Aaron i mae-ḡaira da naoi au doa Israel patarana au matai. ");
INSERT INTO wed_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nun natuna Joshua ma Jephune natuna Caleb ruaḡai, taui maiteni dobu i tuvirevirei, ai gara i sikai, ");
INSERT INTO wed_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ma mai Israel anatapui i riwei, “Dobuna anatapunana a naeni ma a tuvirevirei ma dobu maumaurana. ");
INSERT INTO wed_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Mepa da Bada nuanuana ina ai awarita ma ina ruieta dobuna maumaurana awarina, weka sia ma lam eḡa anibaiana. ");
INSERT INTO wed_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Wate Bada eḡa ona viḡaviei. Ma ravai dobuna e maemaeni eḡa ona rovoei, tana viaḡaḡana-opunei. Taui ai agu eḡa. Tauta Bada maiteni ta mamae! Ravai eḡa ona rovoei!” ");
INSERT INTO wed_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mai Israel Caleb ma Joshua ḡaimei ita viraḡeni wate Bada ana borumana i eḡa numagara au tepana. ");
INSERT INTO wed_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Bada Moses ma Aaron i riwei, ");
INSERT INTO wed_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Wei ravai apoapoe ai beura awariu a nonora, iauei! Mai Israel ai pariviravira awariu a nonori.” ");
INSERT INTO wed_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Wenanare ma paribelei, “Bada i riwa, ‘Tau wavauei a ririwa da aiwai o vivibaḡei, nanare ana kauei.” ");
INSERT INTO wed_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Taumi au mutulua tupuami urabovai ina nae. O pari-virevireu aubaina taumi ami madeḡa 20 ma e ḡeḡae ona iraḡe. ");
INSERT INTO wed_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","A parivainuaḡami da wei au dobuna ota mae wate eḡa aiai tagogi wei au dobuna ina rui anina Jephune natuna Caleb ma Nun natuna Joshua. ");
INSERT INTO wed_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ma o ririwa da natunatumi ina vaia ai panipani, wate taui kampa ana ruiei da dobuna o gedugeduaieia ina maeni. ");
INSERT INTO wed_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Wate taumi patarami tupuami au mutulua ina bova-nae. ");
INSERT INTO wed_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Eḡa ota vipatutu ma lamna aubaina natunatumi ina vinuapoapoe au mutulua ma ina kovoḡi da ina viḡamoḡamo-nae da madeḡa 40 ina kwa nai maranaina taumi kimta magurimi ona iraḡe-pai. ");
INSERT INTO wed_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Aupom 40 dobuna o tuvirevirei lamna aubaina ana kovoḡimi da madeḡa 40, au pom tagogi maiana madeḡa tagogi. Ami ḡoʼapoapoei aubai au kovoḡa malana ona vaia. ");
INSERT INTO wed_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Tau Bada, A riwa! Tau wei ana kauei taumi ḡoʼapoapoe ravami anatapumi awarimi. Ami rava maiteni o vitagogiemi ma o viḡavieu. Taumi anatapumi au mutulua ona kwa, taumi weka ona iraḡe. ");
INSERT INTO wed_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Nawaravi au vouna mai Israel anatapui au mutulua Zin i ḡeta ma au Kadesh i rauḡaravu. Weka Miriam i ʼraḡe da i doboi. ");
INSERT INTO wed_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Kampa Waira eḡa ma lamna aubaina taui i vitagogiei ma Moses ma Aaron ai ḡavia i vomairi, ");
INSERT INTO wed_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ma Moses maiteni i viparipariniḡai i pa, “Rorova varevareiai maiteni ata iraḡe tagogi Bada au matana!” ");
INSERT INTO wed_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Aiwai aubaina Bada ana rava u neiai au mutulua ana ḡamoḡamoi da ina iraḡe ");
INSERT INTO wed_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Aiwai aubaina Egyptei u tere-opunelai ma u neiai wei dobuna apoapoena awarina? Weka eḡa ani ipi doana aiaina da witi da damala aina bo grape warami bo Pomegranates aina ina gogo, ma eḡa waira aniuma! ");
INSERT INTO wed_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moses ma Aaron, patara i voterei ma i nae Bada ana numagara au metaetana ma i mae-peu au doa ma i raudune. Ma Bada ana borumana i eḡa. ");
INSERT INTO wed_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ma Bada Moses i riwei, ");
INSERT INTO wed_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Am jiḡona ma vaia ma tuam Aaron maiteni rava ona vitagogiei. Ma au matai kira awarina ma babani ma ana waira ina veremi. Nanare waira kirei ina opu da Israel patarana ina uma ai ḡamoḡamo maiteni. ");
INSERT INTO wed_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Anina ma Moses jiḡona Bada au naona i vaia, i ririwei nanare.” ");
INSERT INTO wed_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Ma Moses ma Aaron dam Israel i vitagogiei kira au naona ma Moses i riwa, “Ora potapotami! Ona genuana! Tauai waira kira au orana ana tere-opuniai aubaimi!” ");
INSERT INTO wed_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ma Moses ana jigona i voepai ma kira i ravi mara ruaḡa. Ma waira ḡaeḡaena i ruba-opu da rava ma ḡamoḡamo i uma. ");
INSERT INTO wed_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Anina ma Bada, Moses ma Aaron i riwei, “Taumi eḡa ota vitumaḡana-kaueu da Tau vivivireu ami dam Israel au matai, ma lamna aubaina taumi eḡa wei ravai ona ruiei dobuna a vereveremiana awarina.” ");
INSERT INTO wed_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Au ola Hor, Edom ana au parata, kampa Bada Moses ma Aaron i riwei, ");
INSERT INTO wed_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Taumi riwau o rauaḡaiḡaiei au Meribah ma lamna aubaina, dobu mai Israel a verevereia, Aaron kampa eḡa ina rui. Tauna noinoina ina votaḡoi. ");
INSERT INTO wed_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaron ma natuna Eleasar ma taravaia ma ma ḡaei au ola Hor. ");
INSERT INTO wed_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Kampa Aaron ana pirisi garana ma votawanei ma natuna Eleasar ma vioteni. Aaron kampa ina iraḡe ma noinoina ina votaḡoi.” ");
INSERT INTO wed_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses Bada i ririwei i kauei. Taui ola i ḡaeni, mai Israel anatapui au matai. ");
INSERT INTO wed_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moses Aaron ana pirisi garai i votawanei ma natuna Eleasar i vioteni. Ma kampa ola au tepana Aaron i ʼraḡe. Ma Moses ma Eleasar i ḡaira memei. ");
INSERT INTO wed_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Maranai patarana i aramanei da Aaron i ʼraḡe ma i touei da au pom 30. ");
INSERT INTO wed_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Taui ola Hor i netawanei ma boga lebalebarina etanaina i vaia da Edom ita vorei. Au etanai rava amloi i ḡaiḡai aubaina ai vaḡai i manawa, ");
INSERT INTO wed_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ma Moses ma God i eni i pa, “Aiwai aubaina Egyptei o taravaina-opunelai da au mutulua ana iraḡe? Ai lam eḡa! Ai waira eḡa! Ma wei lam tagogina manna a amgeduaiei.” ");
INSERT INTO wed_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ma Bada mota ḡaiḡaiawai i paritawanei awari ma maḡamaḡaui i ani ma i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Rava i nei Moses awarina ma i riwa, “Tauai ḡoʼapoapoena a kauei maranai Bada ma tam a parivireviremi. Ma raupari da Bada mota ina vaitawanei.” Ma Moses i raupari rava aubaii. ");
INSERT INTO wed_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ma Bada Moses i riwei i pa, “Mota ḡaiḡaiawana kokoitauna ma kauei ma ai au damona ma raḡini. Maranai mota, rava aiai i ani ma i taepai da mota kokoitauna i ʼnanai, ma tauna ina lawana.” ");
INSERT INTO wed_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ma Moses mota bronzei i kauei ma ai au damona i raḡini. Maranai mota aiai i ani ma ravana i taepai da mota i ʼnanai ma i lawana! ");
INSERT INTO wed_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Mai Israel i nae ma au Oboth i rauḡaravu. ");
INSERT INTO wed_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ma Oboth i netawanei ma i nae au Iye-Abarim i mae, wei lamna mutulua, Moab au naona au maramatanei. ");
INSERT INTO wed_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kampa da i nae Zered au wapuna i rauḡaravu. ");
INSERT INTO wed_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ma wei dobuna i netawanei ma i nae waira Arnon au baba ḡelauna au mutulua mai Amori ai au parata. (Moab ma Amori ai dobu au poui wei wairana e viviparata). ");
INSERT INTO wed_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ma mai Israel taupariverena i paritawanei da Sihon mai Amori ai gulau i pariverei i pa, ");
INSERT INTO wed_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Tauai a ḡoei da am au dobu ata verautua. Tauai eḡa ana deḡa ami au wapu bo grape wapuna, bo ami au waira dogona waira ana umai. Tauai gulau ana au etanai ava ana babara da am dobu paratana ana opu-tawanei.” ");
INSERT INTO wed_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Wate gulau Sihon mai Israel eḡa ita vianinei da ana au dobu ita verautua. Ma ana sorodia anatapui i tami ma i nae au mutulua da Israel ita nebelei. Au Jahas i ḡeta da Israel maiteni i viḡaiḡaiawa. ");
INSERT INTO wed_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Wate mai Israel i virewapana ma gulau Sihon i viubai ma ai dobu waira Arnon i ḡae da waira Jabok ana parata i vaia, wei kampa mai Ammon au dobu e viviparata. Mai Ammon ai parata i gagaloana-kauei ma lamna aubaina mai Israel eḡa ai au dobuna ita rui. ");
INSERT INTO wed_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ma mai Israel i viḡavia da, mai Amori ai melagai i vaipai da i maeni, taon Heshbon ma melagai ḡelaui kampa maiteni i vaia. ");
INSERT INTO wed_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nanare mai Israel mai Amori ai dobu i vaia ma kampa i mae ");
INSERT INTO wed_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ma Moses tauivu i paritawanei da Jaser taon i tuvirevirei, ma muriai mai Israel i nae ma ai melaḡai anatapui i vaia ma mai Amori kampa maemaei i viaḡaḡana-opunei. ");
INSERT INTO wed_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ma mai Israel i vira ma etanaiei i ḡae au Bashanei. Ma Bashan ai gulau Og ai sorodia anatapui maiteni i opui da taui i nebelei au Edrei. ");
INSERT INTO wed_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ma Bada Moses i riwei i pa, “Eḡa tauna ma rovoei, aubaina tauna, ana rava anatapui, ma ai dobu maiteni au uram a tereterei. Aiwai u kauei Amori ai gulau Sihon awarina, au Heshbon taon, nanare gulau Og awarina ma kauei.” ");
INSERT INTO wed_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ma gulau Og i viraḡeni natunatuna nelarai ma rava anatapui i viraḡena-pai, eḡa aiai ita mae. Ma mai Israel dobuna i vaia da ai dobu. ");
INSERT INTO wed_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ma mai Israel i vomairi da Moab au wapuna, Waira Jordan au adana i rauḡaravu, ma au baba ḡelauna Jeriko taon. ");
INSERT INTO wed_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ma mai Israel aiwai i kauei mai Amori awari, Zippor natuna Balak anatapuna i ʼnana-pai. ");
INSERT INTO wed_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mai Israel i maḡa kaua ma lamna aubaina mai Moab i rovo kaukaua, rovo ita iraḡelei. ");
INSERT INTO wed_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ma mai Moab mai Midian babadai i riwei i pa, “Aburuna ava ma wei patarana aiwai anatapuna au ririvata ina pupuna-pai, me bulumakau au wapu modu e amam.” ");
INSERT INTO wed_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Anina ma Moab ai gulau Balak, Beor natuna Balaam ana riwa i paritawanei au Pethor, waira ḡaeḡaena wavana Euphrates au ririvana. Ana riwa wenanare, “Dam tagogi Egyptei i opu, ma dobu anatapuna e vaivaia ma marina au ririvau i rauḡaravu. ");
INSERT INTO wed_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Taui i virewapana kaua eḡa me tau, ma nei ma ravai ma parivai-iviapoapoeni, mepa da tau ravai ana vovaiubai ma wei dobunei ana viaḡaḡana-opunei. Aramanei da maranai tam rava e viviaiaini tauna viaiaina e vaivaia ma maranai u parivai-apoapoeni tauna ina apoapoe.” ");
INSERT INTO wed_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ma Midian ma Moab babadai mane i vaia Balaam vimaiana aubaina ma i vomairi. Ma i ḡeta Balaam awarina ma Balak ana riwa i pariverei. ");
INSERT INTO wed_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam ravai i paribelei i pa, “Weka ona matave ma au maratom Bada aiwai ina riweu ana pariveremi.” Ma babadai kampa Balaam maiteni i mae. ");
INSERT INTO wed_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","God i nei ma Balaam i vitara-virevirei i pa, “Aiavoi i nei awarim?” ");
INSERT INTO wed_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam i paribelei, “Zippor natuna Balak, Moab ai gulau wei riwana i paritawaneiai i pa, ");
INSERT INTO wed_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Ma rautaniḡana dam ḡaeḡaena Egyptei i opui ma dobu anatapuna e vivioai. Ma nei ma aubaiu ravai ma ḡaḡalei, da maiteni ana viḡaiḡaiawa ma ana viagagei da ina vinelana.” ");
INSERT INTO wed_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Wate God Balaam i riwei i pa, “Eḡa maiteni ma nae. Eḡa wei ravai ma ḡaḡalei aubaina Tau au viaiaina awarii.” ");
INSERT INTO wed_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Ubaubanai Balaam i nae ma Balak ana taupariverena i riwei, “Ona nae me ami au melaḡai! Bada eḡa ita vianineu da maitemi tana nae.” ");
INSERT INTO wed_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ma Moab babadai i nae me ai bada Balak awarina ma i riwei i pa, “Balaam eḡa ita goei da ita nei.” ");
INSERT INTO wed_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ma ubaubanai Balaam i vomairi ana donki i vokaukauei ma Moab babadai maiteni i nae. ");
INSERT INTO wed_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Wate God amlona i ḡaiḡai kaua da Balaam i nenae, ma ana anela i paritawanei da ana etanai i mae-tomeni. Balaam donki i gerui ma ana taunola ruaḡa maiteni i nenae. ");
INSERT INTO wed_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ma maranai donki Bada ana anela i ʼnanai ana sodna au etanai i maimairi ma i tawana-ruiei au ririva. Balaam donki i kwakwapui da ita opu me au etanai. ");
INSERT INTO wed_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ma Bada ana anela etanai ḡuriḡuririna i mae-potai, Grape ḡoroḡorovai epaepana ruaḡa ḡaimei i garigaria au poui. ");
INSERT INTO wed_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Maranai donki Bada ana anela i ʼnanai ma ita deḡa lamna Balaam aena au gari i viairaturatui. Ma Balaam donki i kwapu-melei. ");
INSERT INTO wed_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ma Bada ana anela i nae ma etanai au ḡuriḡuririna i mairi, weka eḡa gabu ita mamae-dadana da taui ita deḡa. ");
INSERT INTO wed_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Maranai donki anela i ʼnanai, i mae-ḡaira da i kiala, Balaam amlona i ḡaiḡai kaua ma ana jiḡonei donki i kwapui. ");
INSERT INTO wed_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Anina ma Bada donki gamona i votawanei da i babani i pa, “Aiwai apoapoena a kauei awarim da mara tonuḡa u kwapuiu?” ");
INSERT INTO wed_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam donki i riwei i pa, “Tam u vikalokaloeu me bua! Awariu sod lamna marina ata viraḡenim.” ");
INSERT INTO wed_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ma donki Balaam i riwei i pa, “Tau donkina tagogina marana patapatai u gerugeruiu bo? Wenanare a kauana dadanei awarim bo eḡa?” Balaam i riwa, “Eḡa!” ");
INSERT INTO wed_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ma Bada Balaam matana i vikalai da ana anela i ʼnanai ana sodna i maimairi au etanai. Ma i mae-ḡaira au doa ma i raudune. ");
INSERT INTO wed_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ma Bada ana anela i riwa i pa, “Aiwai aubaina am donki mara tonuḡa u ravi? Ma nonori am vaḡai lamna eḡa aiaina, Tau a nei da ata viḡaem. ");
INSERT INTO wed_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","—Mara tonuḡa am donki i ʼnanaiu ma mara tonuḡai i deḡeu. Mepa da eḡa, lamna tau ata viraḡenim ma donki ata voterei.” ");
INSERT INTO wed_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ma Balaam Bada ana anela i riwei i pa, “A kauana-boai. Eḡa ata aramanei da tam au etanai u maimairi da uta viḡaeiu. Marina mepa da u notai da eḡa ita ai au matam, tau ana nae me.” ");
INSERT INTO wed_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Bada ana anela i riwa i pa, “Ravai maiteni ma nae, wate aiwai ana riwem lamna ava ma latoni.” Anina ma Balaam, Balak ana babadai maiteni i nae. ");
INSERT INTO wed_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ma Balaam wei riwana i riwei i pa, “Balak, Zippor natuna ma vomairi; ma Ma rautaniḡana kaua. ");
INSERT INTO wed_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God eḡa rava ota, Tauna eḡa ita morumoru. Bo ana nota ita viravirai. Tauna aiwai i babaniei, nanare ina tupua Aiwai i parivainuaḡani; nanare ina kauei. ");
INSERT INTO wed_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","I riweu da wei ravai ana viaiaini; maranai God e viaiaina, tau eḡa tagotagogina da ana virai. ");
INSERT INTO wed_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Bada ai God taui maiteni e mamae, ma taui e vovoepaepai da Tauna ai gulau. Tauna eḡa nuabola bo apoapoe ita neineiai Jacob ḡoḡoḡana - mai Israel awari. ");
INSERT INTO wed_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God taui Egyptei i tere-opunei, Aubaii i viḡavia me bulumakau moduei. ");
INSERT INTO wed_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Eḡa aiai Israel ina ḡaḡalei, bo ina baravui. Marina rava ina riwa, ‘Ona inanai God aiwai i kauei mai Israel aubai.’ ");
INSERT INTO wed_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Mai Israel lamna me Lion vivirewapanana. E vovomairi da ana ḡavia e viviraḡeni ma tarana e umaumai, Anina ma ina rauvirai da ina matave.” ");
INSERT INTO wed_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“God i viatataieu da rava muriai e nenei, a inanai wate eḡa laḡilaḡina ita nenei, Jacob ana damei gulau ana jiḡona Ana borumana me ubona gamrina Israeliei e opuopu. Moab muruai ma Seth natunatuna anatapui kolai ina viaigwadagwadai. ");
INSERT INTO wed_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ana ḡavia Edom ina vovaiubai ma ai dobu ina vaia, ma mai Israel ina virewapana guratana. ");
INSERT INTO wed_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Gulau, Jacob ana damei ina nei ma mai Moab mae-tereterei ai au melagai ina pupuni.” ");
INSERT INTO wed_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Maranai mai Israel au Shittim i mamae, nelara i vikarei da Moab waivinei i viawawanei. ");
INSERT INTO wed_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Wei waivine, nelara i riwei da i nei da ai god awarii puloi i apuapui. Ma anatapui i am gogona ma ai godna i raudunelei. ");
INSERT INTO wed_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Wei kauanei mai Israel Baal-Peor i voepaepai ma lamnei Bada ana meji i vikalai. ");
INSERT INTO wed_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Bada Moses i riwei i pa, “Babadai anatapui ona vaia ma madeḡai Bada au matana ona viraḡena-naiei, da tau au meji awarimi ina dauva.” ");
INSERT INTO wed_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ma Moses Israel babadai i riwei i pa, “Taumi tagotagogi ava ami au dam anatapui da Baal-Peor i raudunelei ona viraḡeni.” ");
INSERT INTO wed_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Moses ma Israel patarana Bada ana numa gara au metaeta i toutou, ma au matai oroto Israeliei wavine Midianei i taravaina-ruiei ana au numa gara. ");
INSERT INTO wed_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Maranai Aaron ḡoḡana pirisi wavana Phineas wei kauana i ʼnananai, boru i voterei ma pawasi i lavui, ");
INSERT INTO wed_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ma Israel iei i votaḡoi da ana au numa gara ma pawasiei uporana i tonai da wavine au uporana i opu-vivira. Ma doriana apoapoena au Israel i kwa. ");
INSERT INTO wed_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Wate wei gimna rava 24,000 i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Bada Moses i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Aaron ḡoḡana pirisi Phineas au meji mai Israel awari i viubai; da taui eḡa ata pupuni aubaina tauna ana nota me tau au nota, rava eḡa god ḡelaui ina voepaepaei anina Tau ava. ");
INSERT INTO wed_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Lamna aubaina tauna ma riwei da maiteni parivainuaḡana bagibagina ana kauei da ata ruaḡa tana viturana vivira. ");
INSERT INTO wed_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Tau aubaiu ina vipirisi nonoa.” ");
INSERT INTO wed_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Muriai Bada Moses i riwei i pa, “Aruau Nun natuna - Joshua awarina, lamna aubaina ma taravaini ma uram au tepana ma terei da ma vovivirei au nola aubaina. ");
INSERT INTO wed_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ma naei Pirisi Eleasar awarina, Israel patarana anatapui au matai ma ma viaiaini da ina raviepaiem. ");
INSERT INTO wed_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ma vovai-virewapani da Israel patarana tauna ina rautaniḡanei. ");
INSERT INTO wed_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Tauna Pirisi Eleasar maiteni ina nola da ḡaima e ḡoreḡorei urim, awarinei au nota ina vaivaia. Wei taunei Eleasar, ma Joshua ina agui Israel ai au lawana.” ");
INSERT INTO wed_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ma Bada aiwai i ririwei, Moses nanare i kauei. Joshua i taravaini ma Pirisi Eleasar ma Israel patarana au naoi i vimairini. ");
INSERT INTO wed_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ma urana au tepana i terei ma i vinei da ana raviepaia. ");
INSERT INTO wed_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Mai Israel Moab au wapuna, waira Jordan au ririvana i mamae ma, mai Jeriko au baba ḡelauna. Ma Bada Moses i riwei, ");
INSERT INTO wed_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Wei riwai mai Israel ma riwei, ‘Maranai Jordan o damani da au Canaan, ");
INSERT INTO wed_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Dobuna taumaenina anatapui ona viaḡaḡana-opunei. Ai gana da ai kokoitau anatapui ona rika-viamoamoai. ");
INSERT INTO wed_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Dobu a veremi ona vaia, ḡariemi da ona maeni. ");
INSERT INTO wed_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Doa ona ḡutai dam damai awarii, au ḡaima ina viatataiemi nanare. Doa vounaina dam vounaina ona verei ma dam voaburuna nanare ana ḡuta voaburuna. Wate ḡaimei ana pariveremi metauna damna, metauna doana ina vaia. Dam anatapui doa ina vaia. ");
INSERT INTO wed_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","—‘Wate mepa da nai dobuna taumaenina eḡa ona viaḡaḡana-opunei ma o vianinei da ina mae, taui lamna me vunavuna au matami bo donadona au ririvami maemaena, ma wei vita ḡaeḡaena ina veremi wei au doana. ");
INSERT INTO wed_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Mepa da ravai eḡa ona viaḡaḡana-opunei. Lamna taumi ana pupunimi me a viogei da taui ana pupuni.” ");
INSERT INTO wed_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Ma Bada Moses i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Mai Israel ma riwei, ‘Maranai Waira Jordan o damani da au Canaan o rui, ");
INSERT INTO wed_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","melagai ḡelaui ona vinei da rava ai aniḡaḡalo. Maranai rava turana i vunu-boai da i ʼraḡe, taui weka ina ruba da ina gagaloei.’ ");
INSERT INTO wed_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Ona riwei, ‘Weka ma mae da raubiwa ravai eḡa ina vodadanim ma rauetara ma paini.” ");
INSERT INTO wed_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Ma Moses, Israel i riwei i pa, “Mai Israel Ona rautaniḡana kaua! Au Tarawatu ma au viararamana anatapui ona votelatelana-kauei da ona lawana da Bada, noinoita ai God, dobu i vereveremi, ona vaia da ina viḡarimiei. ");
INSERT INTO wed_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Bada ana tarawatu a ririwemi, eḡa tarawatu ḡelaui au tepana ona viruini ma eḡa ona vaitawanei. Anina ona voteletelei.” ");
INSERT INTO wed_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Tarawatui ona vojijina-kauei da dam ḡelaui ami nuaulaula ma ami aramana ina inanai. Ma tarawatu ina nonori ma ina riwa, “Riwa kaua da dam Israel lamna dam nuanuaulaulai ma araramani. ");
INSERT INTO wed_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ata Bada au ririvata ma e vovoaguita maranai ta raraupari awarina. Metauna damna ḡelaui, ḡaeḡae bo muomuoi, ai God nanare ai rava awarii e kaukauei. ");
INSERT INTO wed_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Tarawatui aiaii ma jijimani anatapui amadodo a ririwemi, Eḡa mepa dam ḡelauna aburuna bo ḡaeḡaena ana tarawatu jijimanina me wei.” ");
INSERT INTO wed_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","34","Maranai Bada urana vivirewapananei Egypt ei i tereopunemi, tauna kaua babai ma virewapanai i kauei. Mai Egypt i vipupui aubaimi. Ma i vainimi da natunatuna, ma au ola Sinai o nonori awarimi i babani, ma o nonori ai menamena au orana ma awarimi i babani, ma lawalawaimi o mae! Wenanare wariaḡa i tupua dadana awarii bo eḡa? Eḡa! Ona nae me da au karena, maranai God oroto ma wavine i kauei da marina; ma dobu au giana da dobu ḡela au giana ona baiei. Kaua wenanare aniba i tupua-dadana bo eḡa? ");
INSERT INTO wed_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Amadodo ona aramanei ma eḡa melanai nuanuami ina vuru da Bada lamna God au mara ma au dobu. Eḡa god ḡelauna ita mamae. ");
INSERT INTO wed_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ana tarawatu amadodo a vereveremi anatapuna ona voteletelei. Da aiwai anatapuna ina ai taumi ma ami epaepaia au murimi ma ami mae ina manawa wei au dobuna Bada e verevere-nonoemi. ");
INSERT INTO wed_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“Ona rautaniḡana Oo Israel! Bada ata God, Tauna ava Bada. ");
INSERT INTO wed_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Nuanuami ina vaia orami anatapunei ma aruami anatapunei, ma ami rewapana anatapunei. ");
INSERT INTO wed_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Wei tarawatuna amadodo a vereveremi ona vojijina-kauei. ");
INSERT INTO wed_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Natunatumi ona viararamani. Ona babaniei maranai o viboruboru numa au orana bo o bababara-nae, bo muriai da ona matave bo o matave-vomairi.” ");
INSERT INTO wed_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Ma Moses mai Israel i riwei, “Maranai Bada ami God i ruiemi dobuna i vereveremiana; Tauna au naomi ami ḡavia anatapui ina viaḡaḡana-opunei: mai Hitti, mai Girgash, mai Amori, mai Canaan, mai Perisi, mai Hivi, ma mai Jebus. Dam seven ḡaeḡaei ma vivirewapana kauai eḡa me taumi. ");
INSERT INTO wed_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ma maranai Bada ami God taui au urami i terei ma o vovaiubai lamna taumi wei ravai ona pupuni. Eḡa maiteni aiwai babanina ona kauei; ma eḡa ona rau-nuapoapoelei. ");
INSERT INTO wed_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Eḡa awarii ona tavine. Eḡa natunatumi guguinii bo laragai ona verei da ina ravaḡi. ");
INSERT INTO wed_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Aubaina natunatumi ina raveni da Bada ina voterei ma god ḡelaui ina raudunelei. Ma Bada ana amloḡaiḡai awarimi ina nei ma ina pupunimi. ");
INSERT INTO wed_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Wenanare awari ona kauei. Ai pulo aniapuna ona viairikarikai ma ganai ona viaigwadagwadai; ma Asherah kokoitaui ona viaigaigai ma ai au menamenana ona apui. ");
INSERT INTO wed_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Aubaina Bada taumi i vinemi ma i viaiainimi Tauna aubaina. Bada rava maḡamaḡaui au dobu ma taumi i vinemi da ḡarinei. ");
INSERT INTO wed_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","—Ma Bada eḡa ita rauoḡarem ma ita vinem aubaina taumi dam patarana ḡaeḡaena, eḡa me dam ḡelaui. Riwa kaua da taumi dam aburuoina au dobu. ");
INSERT INTO wed_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Wate Bada nuanuami i vaia ma parivainuaḡana bagibagina noinoimi maiteni i kauei. Ma lamna aubaina urana virewapananei panipani au orana i vai-melemi, Pharaoh - mai Egypt ai gulau awarina. ");
INSERT INTO wed_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Ona aramana-kauei da Bada ami God. Tauna ava God ma tauna God vipatutuna ma aiwai e ririwei e kaukauei. Taui da nuanuana e vaivaia ma ana babani e vovoteletelei, Tauna taui nuanuana e vaivai-kauei ma e viviaiaina-kauei i parivainuaḡani nanare da kimta tausan. ");
INSERT INTO wed_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Wate taumi da Bada o rauaḡaiḡaiei; Tauna eḡa ina volatelatemi ma ina pupunimi. ");
INSERT INTO wed_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Nanare taumi ona inana-kauei da tarawatu ma viararamana anatapui amadodo a vereveremi ona voteletelei.” ");
INSERT INTO wed_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Moses ana rava i riwei i pa, “Nuanuami eḡa ina vuru; menanare Bada ami God au mutulua i ravenimi da madeḡai 40 da volaḡota ota aramanei ma orami ana rewapana ita inanai. Ma ita aramanei ana tarawatu ona voteletelei bo eḡa. ");
INSERT INTO wed_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ee nanare! I viamiraḡenimi da o volaḡota ma mannei i viambagibagim. Amamami maiteni manna o vinuanainei; eḡa mepa ota amdadani. I kauei da ita viararamanimi da rava eḡa lam ava awarinei ita mamae, wate riwa anatapui Bada gamonei e opuopu. ");
INSERT INTO wed_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","—Maranai o amam kaua, ma numa aiaii o maemaeni, ");
INSERT INTO wed_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ma maranai ami bulumakau ma sipu borui e maḡamaḡa, ma e vivipurapura; ma e maumaura-kaua. ");
INSERT INTO wed_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Ona inana-kaua da eḡa ona mae-ḡaeḡae, ma nuanuami ina vuru! Da Bada menanare Egypt ei panipani au dobuna i tere-opunemi. ");
INSERT INTO wed_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","I taravaina-naiemi au mutulua ḡaeḡaena ma viʼnirovorovona mota ḡaiḡaiawai ma tanara ai dobu. Dobu paipairana ma eḡa waira. Wate i kauei da kira i ravi ma waira i ruba-opu taumi aubaimi. ");
INSERT INTO wed_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Au mutulua manna i veremi da o am; amamami nai lamna eḡa ita am-dadani. Wei lamnei i raudadanimi da ota volaḡota; da au damona ami lawana ita ai. ");
INSERT INTO wed_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ona inana-kaua da eḡa au nuanuami ona riwa, ‘Tauai ai rewapanei ma ai egolei a vipurapura ma a maura.’ ");
INSERT INTO wed_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Wate Bada am God eḡa nuanuami ina vuru aubaina tauna tepanei ta maumaura, ma lamnei parivainuaḡana bagibagina noinoimi maiteni i kaukauei e rarauano.” ");
INSERT INTO wed_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Moses mai Israel i riwei, “Bada riwana eḡa nuanuami ina vuruvuru ma ae-tuḡuna ona rereḡi. Ona girumi da au urami ona raḡini ma ḡelaui au muruami ona raḡini ami mataira. ");
INSERT INTO wed_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Natunatumi ona viararamani, ona babaniei: ami au viboruboru bo maranai o bababara bo o vivilauvitau ma maranai o vovobagibagi. ");
INSERT INTO wed_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","—Ona inana! Au naomi viaiaina ma kovoḡa a tereterei, ma tam am ḡoana. ");
INSERT INTO wed_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Marina Bada ami God ana tarawatu a vereveremi. Mepa da Ona votaḡotaḡoi; tauna ina viaiainimi. ");
INSERT INTO wed_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Mepa da ana tarawatu ona geduaiei ma ona mae-taviremi ma god ḡelaui ona viborumei; Bada ina kovoḡimi. ");
INSERT INTO wed_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Lamna aubaina tarawatu ma viararamana a vereveremi, ona kauana-kauei da ona voteletelei.” ");
INSERT INTO wed_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“Maranai Bada ami God dobu e vereveremia o ruiruiana, ma o vaia, ma numa o voanaiei da o maeni. Ma ona riwa, ‘Dam ḡelaui ai gulau e mamae ma tauta menanare?’ ");
INSERT INTO wed_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Ona inana-kauei da Bada ami dam nununai awariei ami gulau ina vinevinei, ma eḡa dobu ḡela ravai ona vinei. ");
INSERT INTO wed_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Ma tauna eḡa ana horse maḡamaḡaui ina ḡamoi. Ma eḡa rava ina paritawanei au Egypt da horse ina gimarai. Aubaina Bada i riwa da natunatuna eḡa melanai ina naeme kampa. ");
INSERT INTO wed_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Ma gulau eḡa awawana ina maḡa, ma eḡa gold ma silver ina maurei da nuapouna ina vinua-raḡaraḡai. ");
INSERT INTO wed_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Ma maranai i vigulau, tauna pirisi Levi ana damei maiteni ina kiala da nimanei tarawatu bukana ina giruma tauna aubaina. ");
INSERT INTO wed_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Wei bukana au ririvana ina mae ma ina iava-nonoei ma lamnei Bada ina vivirei ma ana tarawatu ina vipatutuei. ");
INSERT INTO wed_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Ma lamnei eḡa ina terepa-melei ma ana rava ina inana-ḡairei bo eḡa tarawatu ina mae-puputei ma ina deḡa au kelakelauna bo au oiena. Ma tauna ma ana epaepaia ina mae gulau au Israel da kimta maḡamaḡaui ina kwa.” ");
INSERT INTO wed_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Maranai Bada dobu i vereveremiana o ruirui, eḡa dobuna taumaeni ai kaua apoapoe ma vinimalamai ona ḡovaivaitei. ");
INSERT INTO wed_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Eḡa melanai: aiai tam natum orotona bo wavinena ma verenei da pulo aubaina ina apui; bo ma vimata gamgam, mataira aiwai ma inainanai ma muriai aiwai ina tupua, rava ma ririwei; bo ma parauma; bo ma ḡaḡala; bo ma vigwerigweri; ");
INSERT INTO wed_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ma eḡa konaḡa bo arua maiteni ma babani bo arua ma ḡorei da ina rui awarim. ");
INSERT INTO wed_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Bada taui da wei kauai apoapoe e kaukauei, i geduaina-kauei. Ma lamna aubaina aburuna ava Tauna rava wei dobuna maemaei ina viaḡaḡana-opunei au naomi. ");
INSERT INTO wed_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Marana patapatana Bada ami God ona voteletelei. ");
INSERT INTO wed_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Wei ravai barabaravui ma paraparaumai. Wate aburuna ava da ai doa anatapuna ona kwalei. Ma Bada ami God e viviḡaemi da wei ravai eḡa ai kaua ona ḡovaivaitei. ");
INSERT INTO wed_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Bada ami God, Peroveta me tau ami damei ina paritawaneiai. Taumi nai ravana ona rautaniḡanei. ");
INSERT INTO wed_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Aubaina taumi wei lamna o vivibaḡei maranai o vitagogiemi ola Horeb au karena ma o riwa, “Eḡa Bada ponana tana nonori bo ai ḡaeḡaena menamenana tana inana-melei da tana viʼraḡeraḡelana.” ");
INSERT INTO wed_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Bada i riweu, “Ai vibaḡa i ai. ");
INSERT INTO wed_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Tau ai damei peroveta ana terepai me tam nanare, Ma riwau au gamona ana terei, da aubaiu ina vitau-vibabani. ");
INSERT INTO wed_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Tauna wavauei ina jima, ma pariviravirai ana kovoḡi. ");
INSERT INTO wed_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Wate maranai peroveta i mae-ḡaeḡae ma e ririwa da wavauei e jimajima wate tau eḡa babani ata verei, bo god ḡelauai aubai e nolanola, Nai perovetana ona viraḡeni. ");
INSERT INTO wed_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Mepa da o vinuanaina, ‘Menanare tana aramanei da lamna eḡa Bada ita babani?’ ");
INSERT INTO wed_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Wenanare ona aramanei. Maranai peroveta i babani Bada au wavanei ma anona eḡa ita tupua lamna nai babanina tauna ana babani ma eḡa bada. Lamna tauna ana vinuanotanota, nai ravana eḡa ona rovoei.” ");
INSERT INTO wed_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Ma Moses Joshua i kwatuei da i nei. Ma Israel patarai au matai i riwei i pa, “Ma virewapana ma tepam ina tora. Tam wei patarai ma ruiei dobu Bada noinoim i verevereiana. Dobuna ma ḡutai da Israel dam ma patai ma ma voagui da ina viḡariei. ");
INSERT INTO wed_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Bada Tauoina awarim ina mae ma am etanai ina raveni. Eḡa melanai ina netawanem bo ina voterem. Lamna aubaina eḡa ma rovo bo oram ina peu!” ");
INSERT INTO wed_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Ma Moses Moab wapuna i netawanei ma ola Nebo i ḡaeni da au tepa dewadewana e ḡoreḡorei Pisgah, ma au navanava ḡelauna lamna Jeriko. Weka au Pisgah Bada Moses dobu anatapuna i viatataiei, au Gilead i vikarei da i ḡae au Dan. ");
INSERT INTO wed_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","Ma dobu Naphtali, dobu Ephraim ma dobu Manasseh, dobu Judah, ma i nae da au Mediteranean bogana. ");
INSERT INTO wed_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Ma Bada Moses mutulua e ḡoreḡorei Negev i viatataiei; ma Jordan gaubana da i nae da au Jeriko da i nae da au uama Zoar melagaina. ");
INSERT INTO wed_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Ma Bada i riwa, “Wei dobuna lamna Abraham, Isaac ma Jacob a parivainuaḡani da ‘ami epaepaipaia ana verei.’ A voterem da dobu matamei u inanai, wate au dobuna eḡa ma rui.” ");
INSERT INTO wed_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","9","Muriai Moses urana Joshua, Nun natuna au kolana i terei ma i viaiaini ma nuaulaula orana i ruini. Ma lamna aubaina mai Israel Joshua i voteletelei Moses i ririweia nanare. Ma Bada ana taunola Moses, i ʼraḡe mai Moab ai au dobu, Bada i ririwei nanare. ");
INSERT INTO wed_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Maranai Bada ana taunola Moses i ʼraḡe; ma Joshua, Nun natuna ma Moses ana tauagu i riwei, ");
INSERT INTO wed_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Au taunola Moses i ʼraḡe. Marina mai Israel maiteni ona vokaukaua ma Jordan ona damani da dobu a vereveremiana kampa ona ḡeta. ");
INSERT INTO wed_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Metaui dobui ae-lapalapami o terei, lamna ina viḡarimiei, Moses wenanare a parivainuaḡani. ");
INSERT INTO wed_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Ami dobu lamna mutulua Negev da Lebanon; au waira Euphrates (au maramatanei) da mai Hitti ai dobu anatapuna da i ḡaira madeḡa e arearere lana Mediteranean au bogana. ");
INSERT INTO wed_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Eḡa aiai ina vobelem bo ina viubaim am au lawana. Tau awarim ana mae, me Moses awarina a kaukauei nanare. Tau eḡa melanai ana tere-ḡairem bo ana voterem. ");
INSERT INTO wed_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","—Parivainuaḡana bagibagina a kauei wei ravai noinoii maiteni da wei dobuna ana verei. Lamna aubaina ma virewapana ma tepam ina tora ma am rava ma ruiei wei au dobuna. ");
INSERT INTO wed_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Anina ma virewapana ma tepam ina tora; ma nuanuam eḡa ina vuru da tarawatu Moses i verem, anatapuna ma voteletelei. Ma ma vojijina-kauei da awarina eḡa ma deḡa au oiem bo au kelakelaum da aiwai anatapuna e kaukauei ina ai. ");
INSERT INTO wed_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Marana patapatai wei tarawatuna ma iaiavi. Ma marai da waguvarai ma vinua-notenotei; wei lamnei tarawatu anatapuna ma aramanei. Mepa da wenanare ma kauei lamna tam ma maura ma nuaiai ḡaeḡaena ma nelaḡai kaua au anatapuna.” ");
INSERT INTO wed_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Mai Israel au Gilgal i mae Jeriko au wapuna. Ma Aupom vi-14-na aubigai nawaravi naona taui raḡona torelana i apui. ");
INSERT INTO wed_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","12","Ma ubaubanai ḡelauna, raḡona au murina, taui witi au wapu i tuarui ma palawa dabadabai i apui ma i am. Ma ubaubanai ḡelauna Manna raua i voterei, taui wei lamna eḡa ita am-melei, ma ai lam wapuei i tuarui. Mai Israel eḡa manna ita am-melei, lam ai au doa au dobu Canaan i vaia da i amam. ");
INSERT INTO wed_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Muriai Joshua dam anatapui i ḡorei da au Shekem ita vitagogiei. Maranai kampa i ḡeta Joshua, dogadogara, dam babadai ma melagai babadai i ḡoreiai da ita nae Bada au naona ita mairi. ");
INSERT INTO wed_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Joshua rava anatapui i riwei i pa, “Bada mai Israel ai God e ririwa, ‘Wariaḡa noimi Terah ma natunatuna Abraham ma Nahor waira Euphrates au baba ḡelauna i mae, ma god maḡamaḡaui i raraudunelei. ");
INSERT INTO wed_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Wate noimi Abraham nai dobunei a vaitawanei ma i naiei da Canaan doana ana tapuna a viatataiei, ma ana epaepaia a vimaḡai. Ma natuna Isaac a verei. ");
INSERT INTO wed_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","—‘Tau dobu a veremi ana debagauna ma ana peipeina, doana eḡa ota nolei ma taon gaeḡaei a vereoimi, marina o maemaeni, eḡa ota voai, ma grape ma olive o amam wate eḡa, taumi ota paewi.’ ");
INSERT INTO wed_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","—Lamna aubaina Bada ona voteletelei ma orami taputapunei ona vipatutu. Noinoimi god morumorui kokoitau, i raraudunelei au Egypt bo au waira Euphrates ona kwajiei au modu ma Bada ainelana ona viborumei. ");
INSERT INTO wed_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Wate mepa da Bada viborumeina o geduaiei, lamna amadodo ona vine da noinoimi ai god waira Euphrates au baba ḡelauna bo marina ravai ai au dobu o mamae mai Amori ai god ona nolei. Wate tau au numa ravai maiteni Bada ana viborumei.” ");
INSERT INTO wed_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Ma rava i paribelei, “Tauai eḡa melanai ai Bada ana voterei ma god ḡelaui ana viborumei. ");
INSERT INTO wed_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Bada ata God tauoina au Egypt i tere-opuneta noinoita maiteni maranai au Egypt ta vilaraga. Ma kaua vivirewapanai ma aniba i kauei au mataiai. Ma ai au vaḡai manamanaina i painiai dam ḡelaui au poui da wei au paratana. ");
INSERT INTO wed_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Mai Amori ma dam ḡelaui wei au dobuna i mamae wate Bada aubaiai ravai i viaḡaḡana-opunei. Lamna aubaina tauai Bada ana borumei, aubaina tauna ainelana ata God.” ");
INSERT INTO wed_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Mai Israel Bada i viborumei maranai Joshua lawalawaina i mamae ma i ʼraḡe ma kimtana magumagurii biaḡa i mamae i ʼraḡe-pai, wei ravai Bada kaua ḡaeḡae i kauei i vimatematei.");
INSERT INTO wed_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Nun natuna - Joshua Bada ana taunola ana madeḡa 110 ma i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Ma doa i verevereia au Timnat Herek i doboi, Ephraim au olana, wei lamna Ola Gaash ana au laubadei.");
INSERT INTO wed_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Anina ma wei kimtana i nepai amamai awarii ma kimta ḡelauna ai gabu i vaia. Wate taui Bada eḡa ita aramanei ma nanare aiwai i kauei mai Israel aubai. ");
INSERT INTO wed_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Ma kaua apoapoei i kauei Bada awarina ma Baal kokoitaui i raudunelei. ");
INSERT INTO wed_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Taui Bada amamai ai God i votere-tawanei; Wei Godna taui Egyptei i taravaina-opunei. Ma i nae ma dobuḡela ravai au ririvai maemaei ai god i viborumei. Wei kauana Bada i viamlo-ḡaiḡaini. ");
INSERT INTO wed_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Taui Bada i voterei ma Baal ma awana Ashtoreth kokoitaui i viborumei. ");
INSERT INTO wed_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Ma Bada amlona i ḡaiḡai kaua mai Israel awari, da i veredamanei ai ḡavia awari ma taui ai purapura i tama-naiei. Ma i voterei ai ḡaviai maḡamaḡaui au ririvai awari, ma taui eḡa tagotagogina da ita vobelei. ");
INSERT INTO wed_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Bada mai Israel i viḡaviei maranai i opuopu viḡavia aubaina. Lamna aubaina eḡa ita vovaiuba Bada i ririwei nanare. Ma taui i vinuabola kaua.");
INSERT INTO wed_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Anina ma Bada taurauetara bo ḡavia babadai i terepai, da i voagui da ai ḡavia i vovaiubai. ");
INSERT INTO wed_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Wate taui ai taurauetara i parivirevirei ma god ḡelaui i erawei ma i raudunelei. Taui laḡilaḡina amamai i bababara lana i voterei ma Bada i rau-aḡaiḡaiei. ");
INSERT INTO wed_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Bada mai Israel ai tou i nonori menanare ai ḡavia taui i rau-iviapoapoelei. Bada taurauetara i terei ma i voagui ma i gagaloei. Maranai taurauetara i mae, Bada mai Israel i raunuapoapolei. ");
INSERT INTO wed_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Wate maranai taurauetara i ʼraḡe, rava, Bada i mae-puputei ma i apoapoe kaua eḡa me amamai nanare ma god ḡelaui i vitaunolei ma i raudunelei. Taui i geduai kaua da ai kauai apoapoei ma ai ora pota ita voterei.");
INSERT INTO wed_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Oroto tagogi wavana Elkanah, ana dam Ephraim ma ana melaḡai Ramah, Ephraim au olana i mae. Elkanah amana Jeroham, ḡoḡana Elihu ma noina Tohu, ma ai bariawa Zuph, ai dam Ephraim. ");
INSERT INTO wed_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Tauna awawana ruaḡa Hannah ma Peninah. Peninah i vinatuna ma Hannah aipoi. ");
INSERT INTO wed_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Madeḡana patapatana Elkanah Ramah i netawanei ma i nae au Shiloh da Bada vivirewapana kaukauana ita voepaepai ma pulo ita apui awarina. Weka Eli natunatuna Hophni ma Phineas Bada ana pirisi pulo tauapui i mae. ");
INSERT INTO wed_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Maranai Elkanah pulo i apuapui ma sia sikasikana i ḡutai da awana Peninah ma natunatuna i patai. ");
INSERT INTO wed_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Wate awana Hannah sia vinevinena i verei aubaina awana nuanuana i vai-kauei avena da Bada i kauei da tauna aipoi. ");
INSERT INTO wed_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Bada Hannah manawana i gudui ma lamna aubaina turana i vivinamei ma i vivijiboḡa-nonoei da ita vinuabolai. ");
INSERT INTO wed_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Wei kauana i mae madeḡana patapatana. Maranai Hannah i nae Bada ana au numa, Peninah tauna i vivinuabolai ma i vitoutouni da eḡa ita amam. ");
INSERT INTO wed_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Maranai Elkanah awana Hannah i paripari-dadanei, “Hannah aiwai e toutouei? Aiwai aubaina eḡa uta amam? Aiwai aubaina e vivinuabola, natunatum eḡa lamna e vivinuabolei bo? Tau weka! Natunatum nelarai 10 epaiai!” ");
INSERT INTO wed_vpl VALUES ("S11_9","010_1_9","1SA","1","9","10","Mara tagogi maranai taui i am vorovei Bada ana au numa au Shiloh, Hannah orana i viara kaua ma ana toutouna Bada awarina i raupari. Pirisi Eli kampa ana au gabu tempol au metaetana i kiakiala. ");
INSERT INTO wed_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Ma i parivainuaḡana i pa, “Oo Bada Vivirewapana Kaukauam. Ma inanaiu am taunola au ora-tou uta inanai! Ma uta notaiu ma eḡa nuanuam ina vuru. Mepa da natu orotona uta vereu lamna teverana ana veremelem da ina vilaragem ana au lawana au anatapuna, ma aparana eḡa ina bori-dadanei.” ");
INSERT INTO wed_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Ma i raraupari Bada awarina ma Eli tauna ipirina i ʼnainanai. ");
INSERT INTO wed_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Hannah au nuanuana i raraupari ma ipirina ava i vidagudagu wate eḡa babani ita opuopu. Ma Eli i notai da tauna i uma-bua, ");
INSERT INTO wed_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","ma awarina i riwa, “Ina baem bo, uma bua ma voterei!” ");
INSERT INTO wed_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Wate Hannah i paribelei, “Eḡa nanare au bada tau eḡa waira bagibagina ata umai, tau au nuabola i rata kaua ma lamna aubaina a toutou Bada awarina. ");
INSERT INTO wed_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Wenanare a raraupari aubaina nuanuau i bola-kauei ma eḡa ma notai da tau wavine apoapoeu.” ");
INSERT INTO wed_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Eli i paribelei, “Ana nuaubam ma nae! Ma Bada Israel ana God am vibaḡa ina kauei.” ");
INSERT INTO wed_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Tauna i paribelei, “Au bada egualau kaua ma eḡa ma nota-boaiu.” Ma i nae ma i am da orana i uba. ");
INSERT INTO wed_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Ma ubaubanai boiboḡi Elkanah ana numa ravai i vomairi ma i nae da Bada i raudunelei ma i ḡaira me au Ramah. Elkanah awana Hannah maiteni i matave ma Bada wavine ana pari i paribelei. ");
INSERT INTO wed_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Hannah i duama ma natuna orotona i ḡuni ma wavana i ḡorei Samuel ma i riwa, “Wei lamna aubaina Bada a vibaḡai.” ");
INSERT INTO wed_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ma madeḡa ḡelauna i ḡetai ma Elkanah ana numa ravai maiteni i ḡae au Shiloh da pulo ita apui Bada awarina ma pulo ḡelauna Bada i parivainuaḡani ita kauei. ");
INSERT INTO wed_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Hannah eḡa maiteni ita nae ma awana i riwei, “Maranai tevera ina eda ma ana ḡaiei Bada ana au numa ma kampa ina mae-nonoa.” ");
INSERT INTO wed_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkanah i paribelei, “Ee nanare aiwai e notanotai da i ai ma kauei, ma weka ma mae da tevera ina eda. Ma Bada ina voaguim da am parivainuaḡana anona ina tupua.” Ma wavine au numa i mae da natuna i eda. ");
INSERT INTO wed_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Maranai tevera i viedai ma alona i naiei au Shiloh, bulumakau orotona ana madeḡa tonuḡa, palawa baikena tagogi ma wine wagina ḡaeḡaena maiteni. Avena da tevera melamelana ma alona i naiei da Eli au urana i terei. ");
INSERT INTO wed_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ma burumakauna i apui God awarina ma tevera i naiei Eli awarina. ");
INSERT INTO wed_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Ma Hannah i riwa, “Oo Bada e notanotai rorova tau weka a raraupari Bada awarina. ");
INSERT INTO wed_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Bada a vibaḡai wei teverana aubaina ma a vivibaḡei i vereu. ");
INSERT INTO wed_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Lamna aubaina marina natu a vereverei Bada awarina. Ana lawana anatapuna Bada ina verei.” Ma kampa taui Bada i voepaepai. ");
INSERT INTO wed_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Ma Hannah i raupari Bada awarina i pa, Tau a vinuaiai kaua Bada awarina; Tauna rewapana i vereu. A vinuaiai aubaina Tam u vilawaniu ma lamna aubaina au ḡavia a vivinamei. ");
INSERT INTO wed_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Oo Bada eḡa aiai ḡelauna vivivireina me tam; eḡa mepa god ḡelaui anina tam ava; eḡa taugagalo ḡelauna me tam, ai God. ");
INSERT INTO wed_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Tau a ririwa, “Vogulagulau ma pari-gulagulau ona voterei; Mae-ḡaeḡae babanina ona voterei. Aubaina Bada ami kaua anatapui e araramanei ma ina kovoḡimi.” ");
INSERT INTO wed_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Bada Tam sorodia vivirewapanai ai pidu u viaigaigai; wate vovokokarai u vovai-virewapani ");
INSERT INTO wed_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Amam iauai marina ina nola da ina am; am-irairaḡei eḡa am ina iraḡe. Wavine aipoina roaroa 7 i ḡuni; wate roaroa maḡamaḡaui aloi i netawanei ma tauna ava e mamae. ");
INSERT INTO wed_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Bada, iraḡe ma lawana e neineiai; Tauna rava au kokoaga e teretere-ḡairei ma e vovovai-mairini. ");
INSERT INTO wed_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Bada rava ḡelaui e vivimaurai ma ḡelaui e vivigomari; ma ḡelaui e teretere-ḡairei ma ḡelaui e teretere-ḡaiei. ");
INSERT INTO wed_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Tam rava molamolakai pokau au orana e sinasina-epai; ma rava vigigimanai loḡiloḡi au orana e sinasina-epai; da gulagulau maiteni e kiakiala ma vigulau taui ina viḡariei. Dobu anatapuna tam ḡarimei; ma aiwai anatapuna ana au animae u terei ");
INSERT INTO wed_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Tam am rava patupatutui e gagagaloei; ma apoapoe taukauei e amoamoa au iraḡe Rava eḡa ai rewapanei ita vovaiuba; ");
INSERT INTO wed_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Tam am ḡavia ma pupuni; am meji ina viarapawa me waiparara Bada tam dobu ma rauetarei ma am gulau ma vovai-virewapani, ma am vinevine bulobulona ina virewapana kaua. ");
INSERT INTO wed_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Elkanah natuna Samuel i voterei ma i nae me ana au melagau au Ramah. Samuel pirisi Eli au urana i mae au Shiloh ma Bada aubaina i vitaunola. ");
INSERT INTO wed_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Wei au marai Bada eḡa rava awari ita bababani bo ai au rauboni bo ai au inana ita vivieḡana-melei, mara tagotagogi ava wei i tuputupua. Tevera Samuel Eli i voagui ma Bada awarina i vitaunola. ");
INSERT INTO wed_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Eli matana i apoapoe kaua ma eḡa ita inainana kaua. Ma waguvara tagogi ana au gabu i matamatave. ");
INSERT INTO wed_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Ma Samuel Bada ana au numa i matamatave Parivainuaḡana bokisina au ririvana ma God ana rampa au Gabu vivivireina i ararata. ");
INSERT INTO wed_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Ma Bada Samuel i ḡorei, “Samuel!” Ma Samuel i paribelei i pa, “Ee tau weka!” ");
INSERT INTO wed_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Ma i vomairi ma i ruba Eli awarina ma i riwa, “U ḡoreu da a nei.” Eli i riwa, “Eḡa ata ḡorem, ma nae me da ma matave.” ");
INSERT INTO wed_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Ma Bada i viḡore me, “Samuel!” Samuel i vomairi me ma i ruba Eli awarina ma i riwa, “U ḡoreu da a nei.” Eli i riwa, “Natu tau eḡa ata ḡorem ma nae me da ma matave.” ");
INSERT INTO wed_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Bada eḡa Samuel awarina ita babani dadana lamna aubaina ponana eḡa ita aramanei. ");
INSERT INTO wed_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Anina ma mara vitonuina Bada i viḡore ma Samuel i vomairi ma i nae Eli awarina ma i riwei, “U ḡoreiu da a nei.” Anina ma Eli i aramanei da lamna Bada tevera i ḡoreḡorei. ");
INSERT INTO wed_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Ma Samuel i riwei, “Ma nae me da ma matave. Mepa da ina viḡore me lamna wenanare ma riwei, ‘Bada ma babani, am taunola a rarautaniḡana.” Anina ma Samuel i nae me da i matave. ");
INSERT INTO wed_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Ma Bada i nei ma i mairi ma i viḡore me au naona i kaukaueia nanare, “Samuel, Samuel!” Samuel i paribelei i pa, “Ma babani am taunola a rarautaniḡana.” ");
INSERT INTO wed_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Ma Bada Samuel i riwei, “Tau kaua vivi-inirovorovo kaukauana ana kauei mai Israel awarii ma maranai rava riwana ina nonori taui orai ina sisi. ");
INSERT INTO wed_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Rorova a riwa nanare, Eli ana numa ravai maiteni ana kovoḡi. ");
INSERT INTO wed_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","A riwana-guratei da ana numa ravai ana kovoḡa-nonoei aubaina natunatuna i vijiboḡiu ma i vinimalamalaiu ma tauna natunatuna i vibae-naenaelei. ");
INSERT INTO wed_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Riwa bagibaginei a ririwa da Eli ana numa ravai ai ḡoʼapoapoe eḡa melanai ana nota-tawanei. Avena da pulo ina apui awariu.” ");
INSERT INTO wed_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuel ana au aravi i mae da mara i tom ma Bada ana numagara metaetai i votawatawanei. Bada aiwai Samuel i riwei tauna i rovo da Eli ita pariverei. ");
INSERT INTO wed_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Wate Eli Samuel i ḡorei i pa, “Samuel natu.” Ma i paribelei i pa, “Tau weka.” ");
INSERT INTO wed_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Eli i paridadana, “Bada aiwai i riwem? Anatapuna ma riweiu ma eḡa lamna Bada ina kovoḡa-guratem!” ");
INSERT INTO wed_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Anina ma Samuel anatapuna i riwei, eḡa aiwai ita tajijini. Ma Eli i riwa, “Tauna Bada, ma aiwai awarina i jijimana ina kauei.” ");
INSERT INTO wed_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Bada Samuel i mae-ratui maranai i rarata ma Samuel aiwai i ririweia ma nanare i tuputupua. ");
INSERT INTO wed_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Ma Israel au giana da au giana, au Dan i vikarei da au Beersheba, anatapui i aramanei da Samuel lamna Bada ana peroveta. ");
INSERT INTO wed_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Mara i maḡa Bada au Shiloh Samuel awarina i eḡa ma i babani. ");
INSERT INTO wed_vpl VALUES ("S18_1","010_8_1","1SA","8","1","2","Samuel natunatuna ruaḡa, natuevou wavana Joel ma umauna Abijah. Maranai Samuel i magura ma natunatuna i vinei taurauetara au Israel ma i terei da au Beersheba i nola. ");
INSERT INTO wed_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Wate taui eḡa amai ana kaua ita vaia ma ai nuavaina mane ma lamna aubaina manelei i gwalai ma rauetara i vibarai. ");
INSERT INTO wed_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Ma lamna aubaina Israel babadai i riei Samuel awarina au Ramah. ");
INSERT INTO wed_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Ma i riwei, “Ma rautaniḡana bada! Tam u magura ma natunatum eḡa am kaua ita ḡovaivaitei. Ma lamna aubaina tauai a ḡoei da gulau ma verelai da ina raveniai, me dobu ḡelaui ravai e kaukauei nanare.” ");
INSERT INTO wed_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Wate maranai wenanare i riwa Samuel eḡa ita vinuaiai dadana, ma i raupari Bada awarina. ");
INSERT INTO wed_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Bada i paribelei i pa, “Aiwai anatapuna ravai e ririwem ma kauei, taui eḡa tam ita geduaiem wate Tau ai gulau i geduaieu. ");
INSERT INTO wed_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Maranai Egyptei a teretere-opunei da wei paratana, taui marana patapatana i mae-puputeu ma god ḡelaui i raraudunelei; marina nanare tam awarim e kaukauei. ");
INSERT INTO wed_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Ai ḡoana ma verei wate riwa bagibaginei ma riwei menanare gulau ina kauanei taui awari.” ");
INSERT INTO wed_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Samuel Bada ana babani anatapuna taui gulau i vivibaḡei i riwei ");
INSERT INTO wed_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","i pa, “Maranai gulau ina vibademi lamna awarimi wenanare ina kauei. Tauna natunatumi ina tama-naiei sorodia da ana chariot ma ana horse ina gerui ma ḡelaui ana chariot au naona ina ruba. ");
INSERT INTO wed_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Ḡelaui sorodia 1,000 ma ḡelaui 50 ina vibadei. Ḡelaui ana wapu ina ipiei ma ana lam ina tuarui. Ḡelaui ḡavia apiai iramei ma chariot iramai ina kaukauei. ");
INSERT INTO wed_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Gulau, natunatumi guguinii ina egari da ana monamona ḡabuḡabui ina kaukauei ma ḡelaui ana palawa ina apuapui ma ana taulauvoa. ");
INSERT INTO wed_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Am wapu ma grape wapui ma nanare olive wapui aiaii avavai ina vaia da ana gabemani babadai ina verei. ");
INSERT INTO wed_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Ma maranai ami witi ma grape ma olive o tuarui ma ḡuta 10 ona terei ma tauna ḡuta tagogi ina vaia ma ana gabemani babadai ina ḡutei. ");
INSERT INTO wed_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Ami laraga nelarai ma guguini ma am bulumakau ma donkey vinevinei ina vaia tauna aubaina. ");
INSERT INTO wed_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Ma ami sipu ma gote ḡuta 10 o terei ma tauna ḡuta tagogi ina vaia tauna aubaina, ma taumi ina vainimi ana taunola. ");
INSERT INTO wed_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Maranai wei kauai i tupua ma ona tou guratana Bada awarina da gulau taumi o tereterei awarimi ina vaitawanei, wate Bada eḡa ina voaguimi.” ");
INSERT INTO wed_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Wate rava Samuel ana babani bagibagina eḡa ita rautaniḡanei. Taui i riwa, “Tauai anatapuiai a ḡoei da gulau ina vibadelai, ");
INSERT INTO wed_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","da tauai me dobu ḡelaui ravai nanare ma ai gulau ina raveniai ma ana opu viḡavia aubaina.” ");
INSERT INTO wed_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Anina ma Samuel Bada i riwei aiwai ravai i ririweia ");
INSERT INTO wed_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","ma Bada i paribelei i pa, “Ai ḡoana ma kauei, gulau ma verei.” Ma Samuel ravai i paritawanei ai au numa. ");
INSERT INTO wed_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Benjamin ana au dam rava tagogi wavana naenaena ma manemanena i mae wavana Kish. Tauna amana Abiel, ḡoḡana Zeror ma noina Bekorath ma ai magura Aphiah, Benjamin ana damei. ");
INSERT INTO wed_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kish natuna Saul i tupua kaua ma laraga inanana aiaina eḡa me laraga ḡelaui au Israel, ma tevera ae manawa. ");
INSERT INTO wed_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Maratagogi Kish ana donkey i kwako ma natuna Saul i riwei, “Am taunola ma taravaini ma ona nae donkey ona baiei!” ");
INSERT INTO wed_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Ma maratomna da Saul ana taunola maiteni ita ḡeta Samuel awarina, Bada Samuel i riwei, ");
INSERT INTO wed_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Wenanare marana au maratom oroto laragana Benjamin ana damei ana paritawaneiai. Olive monamonanei kolana ma buloi da ina vimataira da tauna a tereriei da au rava Israel ina vibadei. Tauna mai Israel ina voagui da mai Philistia ina vovaiubai. Au rava mai Israel a inanai i vinuapoapoe ma ai tou awariu agu aubaina a nonori.” ");
INSERT INTO wed_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Ma Samuel olive monamonana wagina i vaia ma monamona i waḡi Saul au kolana. Ma i vigia-laḡolaḡonei ma i riwei, “Wei a kaukauei aubaina Bada i terem ana rava vinualaulaunai Israel ma vibadei. ");
INSERT INTO wed_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Amadodo rava ruaḡa ma nebelei Rachel ana kokoaga au ririvana au Zelsah, Benjamin ana au dobu. Taui ina riwem, ‘Donkina o baibaiei i nelaḡai. Ma marina amam eḡa donkey ita baibaiei wate tam e vivinuabolem, e paripari-dadana, Menanare natu ana nelaḡanei.’ ");
INSERT INTO wed_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","—Ma ona nae God ana au Gibeah ola aburuna, weka mai Philistia ai sorodia i rauḡaravu. Ma ona ruirui au taon ma Peroveta borui olei ina ḡaiḡairai. Taui gitar ma harp, tambourine ma duraio ina vikalokaloei ma Bada ana babani ina garagararei. ");
INSERT INTO wed_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Bada Aruana Vivivireina ana rewapanana oram ina naeni da ina vibadem, ma taui maiteni Bada ana babani ona jimei. Ma oram ina ravivouni da tam me rava ḡela. ");
INSERT INTO wed_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Maranai wei kauai i tupua, aiwai Bada e viviatataiem ma kauei.” ");
INSERT INTO wed_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Samuel i riwa, “Tam ma vinao au Gilgal, ma kampa ana nebelem da ḡamoḡamo ana vunui ma taputapuna ana apui ma ḡamoḡamo ḡelaui ana apui viturana pulona. Wate kampa ma vipaipai aupom 7 da ana ḡetai ma riwa ḡelaui ana riwei.” ");
INSERT INTO wed_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Ma Saul i mae-tavirei da i nenae ma God ana nota i ruini ma orana i ravivouni. Wei marana aiwai anatapuna Samuel i ririwei i tupua. ");
INSERT INTO wed_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Maranai Saul ana taunola maiteni au ola Gibeah i ḡeta, peroveta borui i ʼnanai i nenei awarii. Anina ma God Aruana Saul i ruini ma i vibadei da tauna maiteni God ana babani i garagaraei. ");
INSERT INTO wed_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Maranai ravai Saul i araramaneia Saul i ʼnanai peroveta au borui i jimajima taui orai i auepai ma ai rava i ririwei, “Riwa kaua bo aiwai i tupua Kish natuna awarina? Saul i viperoveta bo?” ");
INSERT INTO wed_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Ma nai dobuna ravana i paribelei i pa, “Amana aiai lamna avena aubaina maraḡela ravarava ota e viviperoveta.” Anina ma wei babanina i mae kampa, “Moina riwa kaua da Saul peroveta?” ");
INSERT INTO wed_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Ma Saul jima i voterei ma i ḡae au ola au dobu vivivireina. ");
INSERT INTO wed_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Muriai maiana Saul ana taunola maiteni i nelaḡai ma i paridadanei i pa, “Mepa o nae?” Saul i riwa, “Donkey a baibaiei ma a baiana-avei da a nae Samuel awarina da ata paridadanei ḡamoḡamoi mepa.” ");
INSERT INTO wed_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Maiana i riwa i pa, “Ma riweu Samuel aiwai i riwem.” ");
INSERT INTO wed_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Saul i paribelei, “I riwelai da donkina i nelaḡai.” Wate maiana eḡa ita riwei Samuel aiwai i riwei, da tauna ina vigulau Israel aubaii. ");
INSERT INTO wed_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Muriai Samuel mai Israel anatapui i ḡorei da ita riei au Mispa da Bada riwana ita nonori. ");
INSERT INTO wed_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Ma Samuel i riwa, “Bada Israel ai God wei e ririwemi, ‘Tau noinoimi mai Egypt vivirewapanai au urai a vaitawanei. Ma a neiaimi wei au dobuna ma nanare ami ḡavia au ririvami a vovaiubai. ");
INSERT INTO wed_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Wate amadodo tau ami God o geduaiei, i kauana-guratei ami au nuabola ma ami au piripiri.’ Ma o riwa, ‘Eḡa! Tauai gulau a ḡoeḡoei da ina vibadelai! Lamna aubaina dam damai ona opui tau ami Bada au naou.” ");
INSERT INTO wed_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Maranai Samuel damdamai i neiai Bada au naona ma Bada Benjamin ana dam i vinei. ");
INSERT INTO wed_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Ma Benjamin ana dam i neiai au naona ma Bada Matri ana epaepaia i vinei ma kampa Bada Kish natuna Saul i vinei. Ma maranai i baibaiei tauna kampa eḡa. ");
INSERT INTO wed_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Ma lamna aubaina i raupari Bada awarina, “Tauna mepa?” Bada i paribelei, “Tauna kampa purapura au orai e raraugovaḡa.” ");
INSERT INTO wed_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Taui i nae da i taravaini da i neiai, tauna rava aena manamanaina ma i mairi ma rava anatapui i votani. ");
INSERT INTO wed_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Samuel rava anatapui i riwei, “Bada rava i tereriei da ami gulau, o inainai bo eḡa? Eḡa aiai ḡelauna au orata me wei orotona.” Ma rava anatapui i garara, “Gulau ana lawana ina manawa.” ");
INSERT INTO wed_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Muriai Samuel mai Israel i riwei, “Ona nei ma anataputa tana nae au Gilgal ma Saul ana vigulau tana vianinei ma tana amei. ");
INSERT INTO wed_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Anina ma anatapui i nae au Gilgal ma Bada i voepaepai ma i riwei da Saul lamna taui ai gulau. Ma taui viturana ma mae-kaua pulona i apui Bada awarina ma mai Israel siana i am ma i uma ma i vinuaiai-kaua.” ");
INSERT INTO wed_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Samuel Saul i riwei, “Tam u bua! Tam Eḡa Bada ana tarawatu uta voteletelei. Uta votelatela lamna am epaepaia maiteni ita teremi da ota vigulau nonoa au Israel. ");
INSERT INTO wed_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Wate marina tam am vibada eḡa ina mae; Bada rava notanotana me tauna nanare i vinei ma i terei da ana rava ina vibadei, aubaina tam Bada eḡa uta voteletelei.” ");
INSERT INTO wed_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Muriai Samuel Saul i riwei, “Bada tau i paritawaneu da a buloim da u vigulau Israel aubaii. Lamna aubaina Bada ana riwa ma nonora-kauei. ");
INSERT INTO wed_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Bada Vivirewapana Kaukauana i riwa i pa, ‘Tau mai Amalek ana kovoḡi aubaina amamai mai Israel i viḡaviei maranai Egyptei i opu da i nenei. ");
INSERT INTO wed_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Marina ona nae mai Amalek ona viḡaviei ma ona pupuni, eḡa tagogi ona voterei, nelara, waivine, roaroa melamelai, bulumakau, sipu, kamel ma donkey.” ");
INSERT INTO wed_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Ma Saul ana sorodia ai riwa i paritawanei da ita nei. Ma anatapui au Telaim taon i vinenebelana. Sorodia 10,000 Judah ana damei i nei ma 200,000 mai Israel ḡelauiei i nei. ");
INSERT INTO wed_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Ma Saul ana sorodia maiteni i opu ma Amalek i vunu-naiei ma i vovaiubai, i viḡavia au Havilah ma au Shur i vikwai Egypt au ḡereḡerena. ");
INSERT INTO wed_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Agag mai Amalek ai gulau lawalawaina i vojijini wate rava anatapui i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Wate Saul ana sorodia maiteni Agag eḡa ita viraḡeni ma ai sipu ma bulumakau vinevinei ma bulumakau ma sipu natunatui aiaii eḡa ita viraḡeni. Taui ḡamoḡamo kirakiramai ava i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Ma Bada Samuel i riwei, ");
INSERT INTO wed_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Tau orau i viara kaua da Saul a terei Gulau aubaina tauna i mae-puputeu ma riwau i rau-aḡaiḡaiei.” Samuel nuanuana i bola-kauei maranai wei riwana i nonori ma Bada awarina i tou-maratom. ");
INSERT INTO wed_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Ubaubana boiboḡi Samuel i nae da Saul ita inanai wate i riwei da Saul i nae au Carmel taon. Kampa gana i vidamni da rava ita nei weka da tauna ita voepaepai, ma i ḡaira me au Gilgal. ");
INSERT INTO wed_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Ma Samuel i ḡeta Saul awarina, Saul, tauna i viegualauei ma i pa, “Samuel, Bada ina viaiainim. Tau Bada riwana a voteletelei.” ");
INSERT INTO wed_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Samuel i paribelei, “Aiwai aubaina sipu ma bulumakau e vivitouana a nononori?” ");
INSERT INTO wed_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Saul i pa, “Sorodia mai Amalek awarii i vaia, bulumakau ma sipu vinevinei i vojijini da ina puloei Bada am God awarina wate ḡelaui anatapui a viraḡena-naiei.” ");
INSERT INTO wed_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Anina ma Samuel Saul i riwei, “Ma genuana! Waguvarai Bada awariu i babani ana riwem.” Saul i paridadanei, “Ma riweu!” ");
INSERT INTO wed_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Samuel i paribelei, “Avena da u nota-melem da tam rava labalababa, tam marina mai Israel ai rauetaravena. Bada i tereriem da mai Israel ai gulau. ");
INSERT INTO wed_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Riwa bagibagina i riwem ma i paritawanem da taniḡa potapotai mai Amalek uta viḡaviei da anatapui uta pupuna-pai. ");
INSERT INTO wed_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Aiwai aubaina Bada eḡa uta voteletelei? I riwem da eḡa purapura i ʼrairaḡe-tawanei ona tami, wate tam vipurapura u ḡoei ma u vai-labalababai da u nuanei, wei lamna kaua apoapoe Bada au matana.” ");
INSERT INTO wed_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Saul i paribelei, “Tau, Bada a voteletelei! I egariu da ana nae, da mai Amalek ana pupuni ma ai gulau Agag a neiai. ");
INSERT INTO wed_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Wate au sorodia sipu ma bulumakau aiaii eḡa ita viraḡeni wate i neiai weka au Gilgal da ita apui pulo Bada am God awarina.” ");
INSERT INTO wed_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Anina ma Samuel i riwa, “Bada metauna e vinuaiaiei? Votelatela bo pulo ma ḡamoḡamo apuapunana. Votelatela i ai-telara, eḡa me pulo apuapunana; Ma rautaniḡana i ai-telara, eḡa me sipu monamonana. ");
INSERT INTO wed_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Pariviravira Bada awarina lamna me parauma ma mae-ḡaeḡae lamna me god ḡelaui e viviborumei Ma tam Bada riwana u geduaiei; lamna aubaina Bada am vigulau i geduaiei, Tam am vigulau i vai-tawanei.” ");
INSERT INTO wed_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Ma Samuel i mae-tavirei da ita nae ma Saul i ḡoei da ita viḡaei ma ana kwama adana i vojijini ma i sikai. ");
INSERT INTO wed_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Samuel i riwa, “Me au ḡara u sikasikai nanare amadodo Bada am vibada mai Israel awarii i vai-tawanei ma rava ḡelauna aiaina eḡa me tam i verei. ");
INSERT INTO wed_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Israel ai God vinualaulaunana eḡa morumoruna bo nuanuana ita viravirai. Tauna eḡa rava da nuanuana ita viravirai.” ");
INSERT INTO wed_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Ma Samuel i nae au Ramah ma Saul i nae me ana au numa au Gibeah. ");
INSERT INTO wed_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Samuel eḡa Saul ita inana-melei da i ʼraḡe wate Saul i vinuabolana-maelei. Ma Bada nuanuana i bola-kauei da Saul i terei mai Israel ai gulau. ");
INSERT INTO wed_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Bada Samuel i riwei, “Amapo da Saul ma mogumoguei bo? Tau Saul a vaitawanei mai Israel ai gulau. Wate olive monamonana ma vaia ma ma nae au Bethlehem ma Jesse ma inanai. Natunatuna awariei gulau a vinei.” ");
INSERT INTO wed_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Wate Samuel i paribelei, “Menanare ana naenei? Saul riwana ina nonori ma ina viraḡeniu.” Bada i riwa, “Cow ḡaubona ma vinimavoei ma ma nae da ma riwa, ‘Tau a nei viturana pulona ana apui Bada awarina.’ ");
INSERT INTO wed_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Jesse ma rauḡorei viturana pulona aubaina ma ana viatataiem aiwai ma kauei, rava ana viatataiem ma buloi Tau aubaiu.” ");
INSERT INTO wed_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Bada Samuel i ririwei nanare i kauei. Samuel au Bethlehem i ḡeta ma taun babadai ana sisisi i nebelei. Ma i paridadanei, “Ana nuaubam u nei bo?” ");
INSERT INTO wed_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuel i paribelei, “Ee! A nei da pulo ana apui Bada awarina. Anatapumi ona vokaukauana-melemi ma tana nae pulo aubaina. Ma Jesse natunatuna maiteni i viaiaini ma i paritawanei da i nae pulo apuna aubaina.” ");
INSERT INTO wed_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Maranai taui i ḡeta ma Samuel Jesse ana natuevou Eliab i ʼnanai ma ana au nota i riwa i pa, “Wei teverana e maimairi Bada au naona lamna anina ana vinevine.” ");
INSERT INTO wed_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Wate Bada Samuel i riwei, “Tau ravana a geduaiei, eḡa inanana bo ana manawa ma notanotai. Bada aiwai e inainanai, rava eḡa ita inananai. Rava tupua e inainanai wate Tau nuapou a inainanai.” ");
INSERT INTO wed_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Nanare da natunatuna anatapui 7 i nei, ma Samuel i riwa, “Bada eḡa aiai ita vinei.” ");
INSERT INTO wed_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Ma Jesse i paridadanei, “Natunatum anatapui weka bo?” Jesse i riwa, “Natu umau e mamae wate tauna sipu e paipaini.” Samuel Jesse i riwei, “Riwa ma paritawanei da ina ḡetai da tana am.” ");
INSERT INTO wed_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Ma Jesse riwa i paritawanei da i nei. Tauna i tupua karawata, tevera inanana aiaina ma matana namanamarana. Bada Samuel i riwei, “Wei tauna! Ma nae ma au kolana olive monamonana ma iwaḡi.” ");
INSERT INTO wed_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Anina ma Samuel olive monamonana i vaia ma David au kolana i waḡi, kampa taui au matai, ma nai au marana da i nenae Bada ana Arua Vivivireina David maiteni i mae. Ma Samuel i nae au Ramah. ");
INSERT INTO wed_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Ma Bada Aruana Saul i opu-tawanei ma Bada arua apoapoei i paritawanei i rui au orana da i virovorovoi. David marina Gulau Saul ana sorodia.  ");
INSERT INTO wed_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Saul, David ḡavia au anatapuna i paripari-tawanei ma i kaukauana-kauei ma ḡavia i vovovaiubai ma lamna aubaina i terei da ai sorodia ai bada ḡaeḡaena. Ma wei kauana patara ma sorodia babadai i vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","David oroto Philistiei ḡaeḡaena ma inanana viʼnirovorovona i viraḡeni ma i nenememei ma waivine taon anatapuiei i nei ma ketaketara ma gita i vikalokaloei ma i arara ma gulau Saul i nebelei. ");
INSERT INTO wed_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Waivine i vikalokalo ma i welawela i pa; “Saul ḡavia tausan i vunui ma David tausan dam viriviri i vunui.” ");
INSERT INTO wed_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Wei welana Saul i vimeji-kauei ma ana au nota i pa, “Taui David e vovoepaepai ma e ririwa da tauna rava tausan dam viriviri i vunui ma tau tausan ava.” Ma marina ina terei ai gulau. ");
INSERT INTO wed_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Ma lamna aubaina tauna David i unurana-kauei ma i ʼnana-vaitetei. ");
INSERT INTO wed_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","David i nae au Nob da Pirisi pulo tauapuna Ahimelek ita inanai. Tauna ana rovona i opu da David i viegualauei, ma i riwa, “Aiwai aubaina u nei, ma am rava mepa?” ");
INSERT INTO wed_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","David pirisi Ahimelek i paribei i pa, “Gulau Saul nola tagogi aubaina i paritawaneu wate wenanare i riweu, ‘Eḡa aiai ina aramanei aiwai a kaukauei.’ Au sorodia a riwei da e paipainiu. ");
INSERT INTO wed_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Awarim lam da uta vereu? Palawa apuapunana 5 ma vereu bo aiwai ḡelauna kampa.” ");
INSERT INTO wed_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Wate pirisi i riwa, “Awariai eḡa palawa ota ita mamae, wate vovivirana Bada awarina. Wei palawana ma vaia mepa da am sorodia aupom biaḡa eḡa waivine maiteni ita viawawana.” ");
INSERT INTO wed_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","David i paribelei, Riwa kaua tauai eḡa waivine maiteni ata matamatave, maranai a opuopu ḡavia aubaina au nelara e ujiuji. Amadodo lamna gulau ana nola a kaukauei ma wei nolana aubaina a vokaukaua kaua. ");
INSERT INTO wed_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Nai marana palawa waduboi i votawanaei ma palawa voui i terei Bada au naona au tempol. Kampa eḡa lam ḡelauna ita mamae ma pirisi palawa vovivirana David i verei. ");
INSERT INTO wed_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Mai Philistia mai Israel i viḡaviei au ola Gilboa ma taui mai Israel i virubai ma maḡamaḡaui i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Mai Philistia Saul ma natunatuna i viaḡaḡei da natunatuna Jonathan, Abinadab ma Malki-Shua i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ḡavia i potopoto kaua Saul au ririvana ma ḡavia ana piduei Saul i tonai ma i vikero-kauei. ");
INSERT INTO wed_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Ma Saul ana apia tauavaraina i riwei, “Am sodei ma viraḡeniu. Eḡa ata ḡoei da Philistia-eteni ina vijiboḡiu ma ina virageniu.” Wate tauna i rovo da viraḡenana i kauana-avei. Ma Saul ana sod i lavui da au manawana i tonei ma au tepana i peu da i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Maranai ana apia tauavaraina wei i ʼnanai ma tauna nanare ana sod au tepana i peu ma gulau au ririvana i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Israel dam damai i nei David awarina au Hebron ma i pa, “Tauta tara tagogi ");
INSERT INTO wed_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Au naona maranai Saul ata gulau, tam sorodia u rauetaraveni ma o viḡavia. —Ma Bada i riwem, ‘Tam au dam Israel ma paini me sipu taupaini ai sipu e paipaini ma aubaii ma vibada.” ");
INSERT INTO wed_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Maranai dam babadai i ḡeta gulau David awarina au Hebron, David parivainuaḡana bagibagina taui maiteni i kauei Bada au matana. Ma olive monamonanei David i buloi da Israel ai gulau. ");
INSERT INTO wed_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","David ana madeḡa 30 ma i vigulau ma i vibada da madeḡa 40 i kwa. ");
INSERT INTO wed_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Ma Bada David i gagaloei ma nanare ana ḡavia anatapui i vovaiubai. Ma ana nuaubana i mae. ");
INSERT INTO wed_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Ma David peroveta Nathan i riwei i pa, “Tau numa vigulauna, ai cedei voavoana a maemaeni wate God ana parivainuaḡana bokisina au numa gara e mamae.” ");
INSERT INTO wed_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Nathan i paribelei, “Aiwai e notanotaia ma kauei aubaina Bada i mae-ratuim.” ");
INSERT INTO wed_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Wate lamna waguvaraina Bada Nathan i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Ma nae ma au taunola David ma riwei ma pa, Bada wei e ririwei ‘Eḡa tam numa ma voai da Tau au animae.” ");
INSERT INTO wed_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Bada i riwa me, i pa, “Au taunola David ma riwei, ‘Bada vivirewapana kaukauana wei i riwei: Tam au naona ravarava ota sipu u paipaini au wapu, wate Tau a terepaim da mai Israel ai bada. ");
INSERT INTO wed_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Mepa u nenelana, Tau tam a mae-ratuim ma au matam am ḡavia anatapui a pupuna-pai. Ma marina wavam ana voepai, me rava wavai naenaei au dobu. ");
INSERT INTO wed_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Ma au rava Israel dobu ana verei da ina raunuma ma ana nuaubai ina mae. Au naona i vivikareiana da marina babada a terei da mai Israel ita vibadei, wate rava apoapoei taui i viḡaviei ma marina amapo ega ina kauana-melei. Tau Bada a ririwem da am epaepaia ana vimaḡai ma tam ma am epaepaia ona vivigulau. ");
INSERT INTO wed_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Ma am epaia tagogi ana vinei, tam natuoim tagogi da ina vigulau maranai tam am mara damona ina ḡetai da amamam ma votagoi. Ma tauna ana kauei da ina vibada ḡaeḡaena, ");
INSERT INTO wed_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","ma ega aiai ana vigulau ina vaitawanei. Ma tauna tempol ina voai Tau aubaiu, ");
INSERT INTO wed_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Tau ina viamaneu ma tauna ana vinatunei. Ma maranai i kauana-boai, ana kovoḡi me ama natuna e kovokovoḡi nanare. ");
INSERT INTO wed_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Wate eḡa melanai au nuavaina awarina ana vaitawanei me Saul awarina a vaitawanei, tauna ana vigulau a vaitawanei ma epaiana tam a terem. ");
INSERT INTO wed_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Am numa ravai rereḡana eḡa melanai ina kwa ma am epaepaia ina vigulau ma ina vibada nonoa.” ");
INSERT INTO wed_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Ma Bada aiwai Nathan ana au rauboni i riwei anatapuna David i pariverei. ");
INSERT INTO wed_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Omra e tomtom maranaina gulagulau e opuopu ḡavia aubaina. David sorodia ai bada Joab ma Israel ana sorodia i paritawanei da mai Ammon ai sorodia ita vipupui. Ma ai taon Rabbah etanaina i matave-potai da ravai eḡa ita rui bo ita opu, David eḡa ita nae ma au Jerusalem i mae. ");
INSERT INTO wed_vpl VALUES ("S211_2","011_11_2","2SA","11","2","4","Mara tagogi aubigai David i matave-vomairi ma ana au poewa vatavatarana i bababara-nae. Ma i ʼnana damana da wavine i ʼnanai i toatoa, i oḡaoḡa-melei aubaina marina ana nawaravi doriana i kwa, wavine inanana aiai kaukauana anina ma David, rava i paritawanei da ita aramanei tauna aiai. Ravana i ḡeta memei ma i pariverei i pa, “Wavine wavana Bathsheba, Eliam natuna ma Uriah Hitti ei awana.” Ma David ana taunola i paritawanei da wavinena i neiai awarina ma tauna maiteni i matave ma i nae me au numa. ");
INSERT INTO wed_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Wavinena i duama ma riwa i paritawanei David awarina i pa, “Tau a duama.” ");
INSERT INTO wed_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","David riwa i paritawanei Joab awarina i pa, “Uriah Hitti ei ma paritawanei awariu.” Ma Uriah i paritawanei David awarina. ");
INSERT INTO wed_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Maranai i ḡeta David awarina ma David tauna i paridadanei, “Joab ana sorodia maiteni menanare, anina bo eḡa? Ma ḡavia menanare?” ");
INSERT INTO wed_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Ma David Uriah i riwei, “Ma nae au numa ma ma vilauvitau.” Ma Uriah gulau ana numa i opu-tawanei da i nae ma au murina David ana pulo i paritawanei Uriah ana au numa. ");
INSERT INTO wed_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Wate Uriah eḡa ita nae ana au numa, ma kampa ana au metaeta ana bada ana taunola maiteni i vimatave lana. ");
INSERT INTO wed_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Ma taui David i riwei, “Uriah eḡa ita nae au numa.” David Uriah i riwei, “Tam u vaḡavaḡai da u nei. Aiwai aubaina eḡa uta nae am au numa?” ");
INSERT INTO wed_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Uriah David i riwei i pa, “Parivainuaḡana bokisina, mai Israel ma Judah ai sorodia au numa gara e matamatave. Au bada Joab ana sorodia maiteni au wapu i rauḡaravu, wei lamna aubaina eḡa ata nae au numa da ata am ma ata uma ma awau maiteni ata matave. Lamna eḡa ana kauei, eḡateni!” ");
INSERT INTO wed_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Anina ma David Uriah i riwei, “Weka ma mae amadodo ma au maratom ana paritawana-melem.” Uriah au Jerusalem i mae da au pom ḡela. ");
INSERT INTO wed_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Ma David Uriah i rauḡorei da maiteni i am ma i viuma-buai. Wate waguvarai Uriah i opu David ana taunola awarii da ana au aravi i matave; eḡa ita nae ana au numa. ");
INSERT INTO wed_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Ma ubaubanaina David pepa i girumi ma i paritawanei Joab awarina. ");
INSERT INTO wed_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Pepa au orana i giruma i pa, “Mepa ḡavia potopotona kampa Uriah ma terei ma am sorodia ma tere-opunei da tauna ava ina mae ma ina kero ma ina iraḡe.” ");
INSERT INTO wed_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Joab Rabbah taona i vivineneḡanei da i aramanei mepa ḡavia i virewapana kaua ma kampa Uriah i terei. ");
INSERT INTO wed_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Ḡavia taonei i opui ma Joab ana sorodia maiteni i viḡavia ma David ana sorodia ḡelaui i viraḡeni. Taui Uriah oroto Hitti ei maiteni i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Ma Uriah awana riwana i vaia da awana Uriah i ʼraḡe ma i touei ma i moguei. ");
INSERT INTO wed_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Maranai i mogu-vorovei David rava i paritawanei da i neiai ana au numa da awana ḡelauna, ma tauna David natuna orotona i ḡuni. Wate David aiwai i kauei, Bada eḡa ita vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Anina ma Bada peroveta Nathan i paritawanei David awarina ma i riwei i pa, “Nelara ruaḡa au taon tagogina i mae, oroto tagogi manemanena ma maumaurana ma gelauna molamolakana. ");
INSERT INTO wed_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Ravana manemanena awarina sipu ma bulumakau maḡamaḡaui. ");
INSERT INTO wed_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Wate ravana molamolakana sipu natuna wavinena i gimarai, ma natunatuna maiteni i ḡamoi da i rata, molamolakana ana sipu tagotago. Ana lam momoḡina sipu i aniani ma waira ana au kelaka i umaumai ma au arona i matamatave, wei lamna me tauna natuna guguinina. ");
INSERT INTO wed_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","—Marina taomana i nei oroto manemanena ana au numa, ma oroto manemanena eḡa ita ḡoei da ana sipu bo bulumakau ita vunui da ana taomana ana lam ita vokaukauei. Eḡa, tauna oroto molamolakana ana sipu natuna wavinena i vunui ma i vitavi ma ana taomana i verei.” ");
INSERT INTO wed_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Nai maranaina David i meji guratana ma Nathan awarina i ḡaiawa, “Bada lawalawaina wavanei a ririwa da aiai wei kauana i kauei anina ina iraḡe! ");
INSERT INTO wed_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Kaua apoapoe kaukauana i kauei lamna aubaina sipu ḡaubona 4, orotona molamolakana ina verei.” ");
INSERT INTO wed_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Anina ma Nathan David i riwei, “Tam nai ravana! Wei lamna aiwai Bada Israel ana God i riwei, ‘A vinem da Israel ana gulau ma Saul au urana a vaitawanem. ");
INSERT INTO wed_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Ma am bada Saul ana vibadana ma ana buderi a vere-tawanem ma awawana au uram a terei. Ma nanare a terem da Israel ma Judah u vibadei. Mepa da wei anatapui i muomuo ḡuratana awarim, tagotagogina au tepana ata viaitepatepani. ");
INSERT INTO wed_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Aiwai aubaina riwau bagibagina u rau-aḡaiḡaiei? Aiwai aubaina wei kauana apoapoena u kauei? Uriah Hitti ei sodei u piaḡi; awana mai Ammon ai sodei u viraḡeni. Ma awana u vaia da awam. ");
INSERT INTO wed_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","U rau-aḡaiḡaieu ma Uriah awana u vaia da awam lamna aubaina am au numa viḡaiḡaiawa ina mae-nonoa.’ ");
INSERT INTO wed_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","—Bada wei e ririwei, ‘Tau aburuna ava da apoapoena ana neiai am au numa. Au matam awawam ana vaia ma oroto au ririvam ana verei. Ma tauna awawam maiteni ina matave, patara au matai. ");
INSERT INTO wed_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Tam u kauana-ḡovaḡei wate tau madeḡai ana kauei, mai Israel au matai.” ");
INSERT INTO wed_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","David Nathan i riwei, “Tau, Bada awarina a kauana-boai!” Nathan, David i riwei, “Ee wate God am apoapoe e vaivai-tawanei. Tam eḡa ma iraḡe. ");
INSERT INTO wed_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Wate kaua apoapoena u kauei ma lamnei Bada u vijiboḡa-kauei lamna aubaina natum ina iraḡe.” ");
INSERT INTO wed_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Nathan i nae ana au numa. Ma Bada doria i paritawanei David ma Uriah awana, natui awarina ma i doria kaua. ");
INSERT INTO wed_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","David i raupari guratana God awarina natuna aubaina. Am i voterei ma i rui ana au numa ma au debidebi i matamatave. ");
INSERT INTO wed_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Ana numa babadai i nei awarina, da au debidebi ita voepai ma maiteni ita am, wate i geduai. ");
INSERT INTO wed_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Aupom 7 au murina tevera i ʼraḡe ma ana numa babadai i rovo da David eḡa ita pariverei. Taui ava i babani vivira i pa, “Maranai tevera lawalawaina David eḡa ita rautaniḡaneta ma marina menanare tana riwanei da natuna i ʼraḡe? Mepa da ina viapoapoena-melei!” ");
INSERT INTO wed_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","David i ʼnanai ana taunola i pari-ararava ma i aramanei da natuna i ʼraḡe. Ma i paridadana, “Tevera i ʼraḡe bo?” Ma taui i paribelei, “Ee tauna i ʼraḡe.” ");
INSERT INTO wed_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Anina ma David debidebiei i vomairi ma i toa ma i vigara ma monamona gabugabui i toai ma i nae au numa gara da i voepaepa. Ma i nae me au numa ma lam i vibaḡei da i neiai ma i am. ");
INSERT INTO wed_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Ana numa babadai i baiei ma i riwa, “Maranai tevera lawalawaina, tam u uji ma u mogu, ma tevera i ʼraḡe, tam u vomairi da e amam!” ");
INSERT INTO wed_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","David i paribelana, “Ee tau a uji ma a mogu maranai natu lawalawaina. A notai da Bada ina rau-nuapoapoeleu ma natu ina lawana. ");
INSERT INTO wed_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Wate marina i ʼraḡe aiwai aubaina ana u uji? Ana neiana-meleai bo? Amapo ana nae awarina wate tauna eḡa ina nei awariu.” ");
INSERT INTO wed_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Anina ma David awana Bathsheba i vinuaubai ma maiteni i matave. Ma tevera orotona i ḡuni ma David i ḡorei Solomon. Bada tevera nuanuana i vaia, ");
INSERT INTO wed_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","ma lamna aubaina Bada peroveta Nathan i paritawanei da tevera wavana i ḡorei Jedidiah. ");
INSERT INTO wed_vpl VALUES ("K12_10","012_2_10","1KI","2","10","11","David Israel i vibadei madeḡa 40; au Hebron madeḡa 7 ma au Jerusalem madeḡa 33. David ana mara i kwa ma au Jerusalem au kokoaga noinoina au ririvai i vimataveni. ");
INSERT INTO wed_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Ma Solomon amana ana gabu i vaia da Israel ai gulau ma God i kauei da ana vibada i virewapana. ");
INSERT INTO wed_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Solomon, Bada nuanuana i vaia ma lamna aubaina amana David ana tarawatu i vojijina-kauei. Wate kaua tagogi i kaukauana-boai lamna pulo i apuapu labalababai nai dobuna ravai ai pulo ai au aniamapuna. ");
INSERT INTO wed_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Wei lamna pulo aniapuna gabuna, wavana naenaena i mae au Gibeon. Solomon i nae weka da ḡamoḡamo 1,000 i apu-tapui Bada awarina. ");
INSERT INTO wed_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Waguvara tagogi Bada, Solomon ana au rauboni i riwei i pa, “Aiwai e ḡoeḡoei, ma vibaḡei ma ana verem?” ");
INSERT INTO wed_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Solomon i paribelei, “Bada au God, tam u tereu da amau a raviepaiai da gulau, wate tau tevera ota ma eḡa ata aramanei menanare ana vibadanei. ");
INSERT INTO wed_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Ma tau weka am rava u vinevineia au poui, taui i maḡa dewadewa da eḡa aniavana. ");
INSERT INTO wed_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Eḡa aiai ainelana tagotagogina am rava, u vinevineia ina vibadei. Lamna aubaina nuaulula ma vereu da ana aramanei metauna aiaina ma metauna apoapoena.” ");
INSERT INTO wed_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Bada i vinuaiai da Solomon nuaulaula i vibaḡei. ");
INSERT INTO wed_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Ma Solomon i riwei, “Tam eḡa lawana manamanaina bo mane, uta vibaḡei bo uta vibaḡaiu da am ḡavia ata viraḡeni. Eḡa! Tam u vibaḡaiu nuaulaula aubaina da au rava ma vibadana-kauei. ");
INSERT INTO wed_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Aiwai u vibaḡei ana verem! Nota aiaina ma nuaulaula ana verem, eḡa me aiai ḡelauna au naona nanare bo aiai ḡelauna muriai ina vaia nanare. ");
INSERT INTO wed_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Avena da mane ma vipurapura ma wavam vimae‑ḡaeḡaenana aubaina, eḡa uta vibaḡei, wate ana verem, da am au lawana eḡa aiai gulauna am vigulau ina votani. ");
INSERT INTO wed_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Ma mepa da ma rautaniḡaneu ma au tarawatu ma voteletelei me amam David i kaukauei nanare, tam am lawana ina manawa.” ");
INSERT INTO wed_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Muriai etanai waivinei ruaḡa i ḡeta gulau awarina da tauna ai ḡaiawa ita okei. ");
INSERT INTO wed_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Wavine tagogi i riwa, “Au bada tauai airuaḡa ai numa tagogi. Ma tau tevera orotona a vinatunei au numa, maranai noi wavinena kampa. ");
INSERT INTO wed_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Ma aupom tonuḡa au murina wavine viruaina nanare tevera orotona i vinatunei. Eḡa aiai ḡelauna au numa anina airuaḡa ava. ");
INSERT INTO wed_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","—Ma waguvara tagogi wavine natuna i matave-jijini da i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Ma waguvarai au pouna i vomairi, ma natu au ririvau i matamatave i vaia. Tauna natuna irairaḡena au ririvau i vimataveni ma tau natu lawalawaina i vaia da au ririvana. ");
INSERT INTO wed_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Ubaubanai a vomairi da natu ata viḡuḡui, lamna a baei da natu i ʼrairaḡena. Ma mara i tom kaua ma ata inana-kauei lamna eḡa tau natu.” ");
INSERT INTO wed_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Wate wavinena ḡelauna i riwa, “Eḡa! Tau natu lawalawaina; tam natum irairaḡena.” Ma wavine au naona i vinatuna i riwa bagibagi i pa, “Tevera irairaḡena lamna tam natum ma lawalawaina lamna tau natu! Ma nanare airuaḡa i viḡeḡae.” ");
INSERT INTO wed_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Anina ma gulau Solomon i riwa, “Wei tauna e ririwa, ‘Tau natu lawalawaina ma tam natum irairaḡena.’ Ma noi tauna e ririwa, ‘Eḡa! Tam natum irairaḡena ma tau lawalawaina.” ");
INSERT INTO wed_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Ma gulau i riwa, “Sod ona neiai.” Ma i neiai gulau awarina. ");
INSERT INTO wed_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","Ma i eḡara, “Tevera lawalawaina au pouna ona viailaraḡi da navanava tagogi wavine tagogi ma navanava ḡelauna wavine ḡelauna.” ");
INSERT INTO wed_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Tevera lawalawaina alo oina, nuanuana i bola-kauei ma gulau i riwei, “Au gulau a vivibaḡaim da tevera lawalawaina noi wavinena ma verei! Eḡa ma viraḡeni!” Wate wavinena ḡelauna i riwa, “Eḡa tam bo tau teverana tana vaia. Tevera au pouna ma viailaraḡi!” ");
INSERT INTO wed_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Anina ma gulau ana paribelana i tere-ḡairei i pa, “Eḡa tevera ona viraḡeni ma wavine au naona i vivinatuna ona verei, tauna tevera alo oina.” ");
INSERT INTO wed_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Maranai mai Israel Solomon ana etara riwana i nonori, marina taui Solomon ina vivirei, ma i aramanei da God, Solomon nuaulaula i verei da lawana ina tere-vaijijimani. ");
INSERT INTO wed_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Mai Judah ma mai Israel ai patara i maḡa dewadewa me bubu au gera. Taui ai lam ma ai uma tagotagogina ma i vinuaiai kaua. ");
INSERT INTO wed_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Ma Solomon dobuna anatapuna i vibadei. Ana parata au waira Euphrates i vikarei da i ḡaira au Philistia ma kampa da i ḡaira Egypt ana au parata. Wei ravai tax i vivimaiei gulau Solomon awarina ma i voteletelei maranai lawalawaina. ");
INSERT INTO wed_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","Maranai Solomon i vibada mai Judah ma Israel ana nuaubai i mae, ai nuabola eḡa aiwai. Au lavaratei Dan ana dam ai au dobu i vikarei da i ḡaira au Beersheba au rauanaḡei, numa nununai ravai anatapui ai numa ma ai wapu i mae. ");
INSERT INTO wed_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Maranai David maemaeninai, tura-kauana lamna Gulau Hiram, Tyre ai gulau. Maranai gulau Hiram riwana i vaia da Solomon i vigulau au Israel, amana David epaiana, Tauna ana taunola i paritawanei da gulau vouna i viegualauei. ");
INSERT INTO wed_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Ma gulau Solomon wei riwana i paritawanei gulau Hiram awarina i pa: ");
INSERT INTO wed_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","Tam u aramanei da amau dam maḡamaḡaui au ririvaiai i mae-kwaviviroi ma maiteni i viḡaiḡaiawa nonoa. Ma lamna aubaina eḡa tagotagogina da tempol ita voai Bada ana God, viborumana aubaina. Wate i vivipaipai da au naona Bada ana aguei ana ḡavia ita vipupui. ");
INSERT INTO wed_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Wate marina Bada nuauba i vereu. Au ḡavia ma au nuabola eḡa. ");
INSERT INTO wed_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","A vinua-notanota da tempol ana voai, Bada God viborumana ma vimae-ḡaeḡaenana aubaina. Me Bada amau i ririwei nanare maranai i riwa i pa, “Natum orotona ana terei gulau, am au gabu, ma tauna numa ina voai tau viborumau aubaina.” ");
INSERT INTO wed_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Lamna aubaina am taunola ma paritawanei au ola Lebanon, da aubaiu ai bagibagi cedar ina tarai. Tam am nelara ai tarana i aramana-kauei. Tau au nelara ana paritawaneiai da ina tara agui. Am nelara ana vimaiei, biaḡa e vivibaḡei nanare ana vimaia. ");
INSERT INTO wed_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Solomon mai Israel i vibadei da madeḡa tonuḡa ma au vi-4-na, nawaravi au viruaina e ḡoreḡorei Ziv, tauna Bada ana tempol voana i vikarei. Wei lamna madeḡa 480 i kwa maranai mai Israel, Egypt i opu-tawanei. ");
INSERT INTO wed_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","Ḡaima ḡaeḡaei numa voana aubaina anatapui au weia i ḡarai ma kampa i bori-naiei, da eḡa irama bo aniambori gugurai numavoa gabuna ita vitaniḡa-potai. ");
INSERT INTO wed_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Ma Bada Solomon i riwei, ");
INSERT INTO wed_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","“Wei Tempolna voana aubaina ana riwem, mepa da riwau ma rautaniḡanei, ma au tarawatu anatapui ma votaḡotaḡoi, ma aiwai a ririwem ma kaukauei, Tau aiwai amam David a parivainuaḡani ana kauei aubaim. ");
INSERT INTO wed_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Ma tau au rava mai Israel maiteni ana mae, ma eḡa melanai ana netawanei.” ");
INSERT INTO wed_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Anina ma Solomon tempol i voa-pai. ");
INSERT INTO wed_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Bada ana parivainuaḡana bokisina au Zion, David ana taon ita vaia da ita neiai au Tempol. Gulau Solomon, Israel babadai ma dam nununai babadai anatapui i ḡoreiai awarina au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Maranai Israel babadai i ḡetai, pirisi parivainuaḡana bokisina i voepai. ");
INSERT INTO wed_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","Pirisi ma Levi ana dam ravai parivainuaḡana bokisina ma numa gara ma ana purapura vivivirei i avara-naiei au Tempol. ");
INSERT INTO wed_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Gulau Solomon ma mai Israel anatapui parivainuaḡana bokisina au naona; sipu da bulumakau i vunuvunu-naiei, ḡamoḡamo i maḡa guratana da iavana i kauana-avei. ");
INSERT INTO wed_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Ma pirisi parivainuaḡana bokisina i ruiei tempol au orana da ana au gabu vivivira dewadewana cherub ruaḡa papei au gabaurina i vikialai. ");
INSERT INTO wed_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Maranai pirisi gabu vivivireina i opu-tawanei, bau potopotona i ḡairai, ma ana boruma numana i purui. ");
INSERT INTO wed_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","Pirisi eḡa tagotagogina da ai nola ita kauei aubaina bau potopotona; Bada ana boruma, tempol i vioai. ");
INSERT INTO wed_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Ma Solomon pulo aniapuna au naona i mairi, ma au murina Israel patarana. Urana i voepai au mara, ");
INSERT INTO wed_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","ma i raupari i pa, “Oo Bada, Israel ana God, eḡa mepa God ḡelauna me tam nanare, au tepana au mara bo au gabaura au dobu! Tam am parivainuaḡana anatapuna e kaukauei, ma mara nonoa am rava nuanuai e vaivaia maranai orai taputapunei e votaḡotaḡoim. ");
INSERT INTO wed_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","—Wate amapo God au dobu ina mae bo eḡa? Eḡateni! Mara, ma nanare mara ḡedewadewa eḡa tagotagogina da tauna ina vojijini. Wei tempolna a voavoaia lamna anina bo eḡa? ");
INSERT INTO wed_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","—Wate au pari ma nonori. Bada au God, tau am taunola ma aiwai amadodo a vivibaḡei ma vereu. ");
INSERT INTO wed_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","Am tempol ma inana-vaitetei, marai ma waguvarai, wei gabuna aubaina u riwa u pa, ‘Tau wavau kampa.’ Lamna aubaina au pari weka ana pariparitawaneiai ma i rautaniḡanei. ");
INSERT INTO wed_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Au pari ma nanare am rava mai Israel ai pari ma nonori, maranai naoi i tereiai weka ma i raupari. Au mara ai pari ma nonori ma ai apoapoe ma nota-tawanei. ");
INSERT INTO wed_vpl VALUES ("K18_41","012_8_41","1KI","8","41","42","—Ma maranai jentail aueia maemaei, riwam ma am rewapana ma kaua ḡaeḡaei u kaukaueia riwai ina nonori; ma ina nei da ina vimae-ḡaeḡaenim. Ma am numa au naona ina mairi ma ina raupari ");
INSERT INTO wed_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","am au animae au mara, ai pari ma nonori ma ai ḡoana ma kauei. Ma jentail wavam ina aramanei ma ina vimae-ḡaeḡaenim me am rava oina mai Israel. Ma jentail ina aramanei da wei tempolna a voai. Tam vimae-ḡaeḡaenam aubaina.” ");
INSERT INTO wed_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Solomon ana vigulau wavana naenaena ma lamnei Bada i vimae-ḡaeḡaeni. Ma Sheba ai gulau wavinena, wei riwana i nonori ma i ḡei au Jerusalem da paridadana piripirinei Solomon ana nuaulaula ita raudadani. ");
INSERT INTO wed_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Wavine ana taunola ma kamel maḡamaḡaui ai pulo i vigerui ma ana borui i derirui. Taui ai pulo lam tauvidagiai, ḡaima maiai ḡaeḡaei ma gold ḡaeḡaena. Wavine i nei Solomon awarina ma kaua maḡamaḡaui i vinua-notenotei Solomon i paridadanei. ");
INSERT INTO wed_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Solomon ana paridadana anatapuna i paribelei, kampa eḡa aiwai tagogi ita piripiri guratana awarina. ");
INSERT INTO wed_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Sheba ai gulau i aramanei da Solomon nuanuana i ulaula kaua ma; i ʼnanai ana gulau-numana, vigulauna i voai, ");
INSERT INTO wed_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","lam au kepakepa, ana gabemani babadai ai gara, ana wine taupainii, ma pulo i apuapui Bada ana au tempol. Ma wavine ana nota i kwa. ");
INSERT INTO wed_vpl VALUES ("K110_6","012_10_6","1KI","10","6","6","Ma Solomon i riwei, “Am kaua anatapuna ma am nuaulaula au au dobu a nononoria lamna anatapuna riwa kaua! ");
INSERT INTO wed_vpl VALUES ("K110_7","012_10_7","1KI","10","7","7","Au naona eḡa ata vitumaḡanei wate marina a nei da matauei a inanai da a vitumaḡana. Ma a inanai da aiwai a nononoria lamna eḡa. Tam am vigulau i rata dewadewa. ");
INSERT INTO wed_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","Am taunola i vinuaiai kaua! Am gabemani babadai au naom e maimairi marana patapatai ma am nuaulaula e rarautaniḡanei. ");
INSERT INTO wed_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Bada am God ana voepaepai, i vinuaiaiem ma i terem Israel ai gulau. Bada ana nuavaina maemaena mai Israel aubai i terem gulau, da riwa kauei ma kaua jijimaninei ma vibada.” ");
INSERT INTO wed_vpl VALUES ("K110_13","012_10_13","1KI","10","13","13","Solomon, Sheba ai gulau aiwai anatapuna i rarau-oḡarei ma i vivibaḡei, i verei, wate ḡelaui i vereoi. Anina ma gulau wavinena i wanavira-melei ana au dobu ana taubagibagi maiteni. ");
INSERT INTO wed_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Gulau Solomon, Egypt ai gulau natuna i ravaḡi ma nanare jentail waivinei i ravaḡa-naiei, ḡelaui mai Moab, mai Ammon, mai Edom, mai Sidon ma, mai Hitti. ");
INSERT INTO wed_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Au naona Bada mai Israel i riwana-guratei i pa, “Jentail waivinei eḡa ona ravaḡi aubaina taui nuanuami ina vovirai da ai god ona voepaepai.” Wate Solomon nai eḡa ita rautaniḡanei, ma awawana nuanuai i vai-kauei. ");
INSERT INTO wed_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Tauna awawana 700, anatapui gulagulau natunatui, wate awawana ḡelaui 300 lamna me ana taunola. Taui Solomon ana vitumaḡana Bada awarina i vikwakoi. ");
INSERT INTO wed_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Maranai Solomon i magura, awawana ana nota i virai da god ḡelaui i votaḡotaḡoi, ma eḡa Bada awarina ita vipatutu me amana David. ");
INSERT INTO wed_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Tauna mai Sidon ai god wavinena Ashtoreth, ma mai Ammon ai god apoapoe kaukauana Milkom i viviborumei. ");
INSERT INTO wed_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Au Ola Olive au Jerusalem kampa Solomon voepaepa gabuna i voai mai Moab ai god apoapoe kaukauana, Chemosh aubaina ma ḡelauna mai Ammon ai god apoapoe kaukauana, Molek aubaina. ");
INSERT INTO wed_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Voepaepa gabui wenanare i voanaiei awawana anatapui aubaii da taui weka incense ma ai pulo ita apuapui ai god awarii. ");
INSERT INTO wed_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Maraotai Bada, Solomon awarina mara ruaḡa i eḡa ma i riwana-guratei da god ḡelaui viborumai ina voterei. Wate tauna eḡa ita voteletelei, ma Israel ai God viborumana i voterei. Lamna aubaina Bada amlona i ḡaiḡai kaua Solomon awarina. ");
INSERT INTO wed_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Ma i riwei i pa, “Wei kauai i visina-viraviraim ma au parivainuaḡana bagibagina ma au tarawatu eḡa uta votaḡotaḡoi, lamna aubaina vibada au uram ana vaitawanei ma am taunola tagogi ana verei. ");
INSERT INTO wed_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Wate amam David notanei wei eḡa ana kauei maranai tam lawalawaim. Wate natum au urana ana vaitawanei.” ");
INSERT INTO wed_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Solomon ana gabemani taunoleina wavana Jeroboam maiteni gulau Solomon i viḡaviei. Tauna Nebath natuna, ana taon Zeredah au Ephraim, ma alona kaiababa wavana Zeruah. ");
INSERT INTO wed_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","Jeroboam ana virarautua wenanare: Solomon ana taunola doa i taratarai da gwagwa i purupurui ma Jerusalem taon garina ḡaimei gavogavoi i vopotapota-naiei. ");
INSERT INTO wed_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Jeroboam oroto araramanina ma maranai Solomon i ʼnanai da tauna i nola kaua, ma i terei da Joseph noinoii dam Ephraim ma Manasseh, ai taunola i vibadei. ");
INSERT INTO wed_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Mara tagogi, Jeroboam Jerusalem i voterei da i nenae ma au mutulua peroveta Shilohei wavana Ahijah maiteni airuaḡa ava i vinenebelana, Jeroboam kwama vouna i oteoteni. ");
INSERT INTO wed_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Ahijah, Jeroboam ana kwama vouna i vojijini ma i sikanaiei da 12. ");
INSERT INTO wed_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Ma i riwei, “Wei garai sikasikai 10 ma vaia aubaim, Bada Israel ana God e ririwa, ‘Tau Israel ana vibadana Solomon au urana ana sikatawanei ma ana dam 10 au uram ana terei.’ ");
INSERT INTO wed_vpl VALUES ("K111_32","012_11_32","1KI","11","32","33","Solomon Tau i geduaieu ma mai Sidon ai god wavinena, Ashtoreth, Moab ai god, Chemosh ma mai Ammon ai god, Milkom i vovoepaepai ma eḡa au iviu ita babara bo ita kauana-kauei au matau bo riwau bo au tarawatu ita votaḡotaḡoi me amana David i kaukauei nanare. Wate au taunola David ma Jerusalem notaiei, Jerusalem a vinei da Tau ḡariuei, lamna aubaina Solomon dam tagogi ana verei da ina vibadei. ");
INSERT INTO wed_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","—‘Wate Solomon natuna au urana Israel ana dam 10 ana verem.” ");
INSERT INTO wed_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Solomon i ḡoei da Jeroboam ita viraḡeni, wate tauna i ruba au Egypt, ai gulau Shishak awarina ma kampa i mae da Solomon i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Solomon au Israel i vigulau da madeḡa 40 i kwa. ");
INSERT INTO wed_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Mai Israel anatapui i nae au Shekem ma i vipaipai da Rehoboam ita nei ma ita terei ai gulau. ");
INSERT INTO wed_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Maranai au Egypt, Nebath natuna Jeroboam, wei riwana i nonori ma Egypt i voterei ma i naeme. (Tauna au naona Solomon i rovoei da kampa i ruba nae.) ");
INSERT INTO wed_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Ma Israel babadai riwa i paritawanei da Jeroboam i nei ma anatapui i nae Rehoboam awarina ma i riwei, i pa, ");
INSERT INTO wed_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“Amam nola vitaikaukauai au tepaiai i terei, wate ai vita marina uta votelatelai, ma ana vitaunolem.” ");
INSERT INTO wed_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Rehoboam i paribelei i pa, “Ona nae ma aupom vitonuina ona nememei ma ana paribelemi.” Ma rava i vilamonei. ");
INSERT INTO wed_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Ma gulau Rehoboam, dogadogara awari vinuaterena i vaia, taui amana Solomon ana taunola maranai lawalawaininai. I paridadanei i pa, “Wei ravai menanarena ana paribelana-nei?” ");
INSERT INTO wed_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Taui i paribelei i pa, “Mepa da u ḡoei da rava ma voagui, ai vibaḡa ma vianinei, ma taui aubaim ina vitaunola nonoa.” ");
INSERT INTO wed_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Wate Rehoboam dogodogara ai vinuaterena i geduaiei ma i nae ana kimta awarii, maiteni i rata tagogi, ma marina tauna e vivitaunolei ");
INSERT INTO wed_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Tauna i paridadana, “Ami nota aiwai? Menanare tana kauanei, wei ravai e ririwa da ai vita tana viaburui?” ");
INSERT INTO wed_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Ma ana kimta i paribelei i pa, “Nai ravai awarim i ririwa, ‘Amam vita ḡaeḡaena i vereverelai marina ai vita ma viaburui.’ Wenanare ma riwei, ‘Tau vita ḡaeḡaena ana veremi eḡa me amau! ");
INSERT INTO wed_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Amau vita ḡaeḡaena i veremi wate tau ḡaeḡaeotana ana terei au tepana! Tauna kwapuei i ravimi wate tau ḡoroḡorova donadonanei ana kwapuimi.” ");
INSERT INTO wed_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Aupom tonuḡa au murina i riwa nanare Jeroboam ana babada maiteni i nememei Rehoboam awarina. ");
INSERT INTO wed_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Gulau Rehoboam dogadogara ai vinuaterena eḡa ita vaia ma pona bagibaginei rava awari i babani. ");
INSERT INTO wed_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Tauna ana kimta ai vinuaterena i rautaniḡanei ma nanare i riwa, “Amau vita ḡaeḡaena i veremi; wate tau ana viaitepatepani. Amau i ravimi wate tau ḡoroḡorova donadonanei opimi ana sikai.” ");
INSERT INTO wed_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Au naona God ana peroveta Ahijah, Shilohei aiwai Nebath natuna Jeroboam i pariverei marina anona i tupua. Gulau rava ai vinuaterena eḡa nonorana ita ḡoei, wate lamna Bada i kaukauei da aiwai peroveta i ririwei nanare ina tupua. ");
INSERT INTO wed_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Maranai Israel patarana i ʼnanai da gulau taui ai babani i parivirevire, ma gulau i riwei i pa: “Tauta eḡa Jesse natuna David ana damei! Eḡa ana dam ravai! Oo Israel ona naeme me ami au numa Oo David am dam oina ma inanai!” Anina ma mai Israel i nae ai au numa. ");
INSERT INTO wed_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Wate Rehoboam mai Israel au Judah maemaei i vibadei. ");
INSERT INTO wed_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Adoniram, mai Israel anatapui ai taunola i vibadei. Gulau Rehoboam, Adoniram i paritawanei au Israel da ai taunola ita neiai au Jerusalem wate taui ḡaimei i viraurauei da i viraḡeni. Gulau Rehoboam laḡilaḡina ana chariot i gerui ma i nae me au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Ma wei marana da i nae mai Israel David ana dam ma ai vigulau i geduaiei ma i parivirevirei. ");
INSERT INTO wed_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Maranai mai Israel anatapui i aramanei da Jeroboam Egyptei i nememei, taui riwa i paritawanei da i nei awarii ma i terei Israel dam anatapuna ai gulau. Dam tagogiava, Judah ava, i mae David maiteni. ");
INSERT INTO wed_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Ma ḡavia rovona aubaina Jeroboam Shekem taon ḡaimei i gari kwaviviroi ma kampa i mae. Wei lamna dobu violaolana, dam Ephraim ai dobu. Muriai i nae ma nanare Penuel taon i gari-kwaviviroi. ");
INSERT INTO wed_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Mara tagogi gulau Jeroboam wenanare i vinua-notanota, “Mai Israel anatapui e ḡeḡae au Jerusalem da au tempol pulo e apuapui Bada awarina. Ma mepa da nuanuai ina virai ma ina audamana Judah gulauna Rehoboam awarina amapo tau ina viraḡeniu.” Ma wei vigulauna ina nae me David ana epaepaia awarii. ");
INSERT INTO wed_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Ma ana dogadogara maiteni i babani da i vinua-terenei ma bulumakau ruaḡa goldei i kauei ma ana rava i riwei, “Jerusalem ḡaena i vinigarigari, Oo Israel wei ami god, tauna Egyptei i tere-opunemi.” ");
INSERT INTO wed_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Ma bulumakau goldei tagogi au Bethel ma ḡelauna au Dan i terei. ");
INSERT INTO wed_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Wei lamnei i ḡoʼapoapoe; aubaina rava ḡelaui uama ḡaeḡaena i naeni da au Dan da burumakauna i voepaepai. ");
INSERT INTO wed_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Jeroboam maiteni voepaepa gabui ma pulo aniapuni i voanaiei ola au tepai ma rava labalababa eḡa mai Levi i vinei da pirisi, pulo tauapuna. ");
INSERT INTO wed_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Omri natuna Ahab, ana ḡoʼapoapoe i rata guratana Bada awarina eḡa me gulau anatapui au naona i vivibada nanare. ");
INSERT INTO wed_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Tauna i notai da lamna kaua labalababa da i ḡoʼapoapoe me Nebath natuna Jeroboam i kaukauei nanare. Wate tauna i kauana-guratei maranai mai Sidon ai Gulau Ethbaal natuna Jezebel i ravaḡi ma i vikarei da ai god Baal i raudunelei. ");
INSERT INTO wed_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Ma Baal ana voepaepa gabuna pulo tauapuna au Samaria i voai ma au orana pulo aniapuna i voai. ");
INSERT INTO wed_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Ahab god wavinena Asherah kokoitauna i vituramairini. Ma kaua maḡamaḡaui i kauei da Bada, mai Israel ai God ita viamloḡaiḡaini, me mai Israel ai gulau au naona i kaukauei nanare. ");
INSERT INTO wed_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Peroveta Tishbelei wavana Elijah ana dobu Tishbe au Gilead, Ahab i riwei, “Riwa kaua! Bada Israel ana God lawalawaina, ma tauna a vivilaragei. Wavanei a riwa da turuvani eḡa ina peu ma garewa eḡa ina atuna madeḡa biaḡa da tau ana riwa da nanare.” ");
INSERT INTO wed_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Ma Bada Elijah i riwei ");
INSERT INTO wed_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Laḡilaḡina ma nae au taon Zarephath, Sidon au ḡereḡerena ma kampa ma mae. Kampa kaiababa e mamae, a riwei da ina viambagibagim.” ");
INSERT INTO wed_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Ma Elijah i nae au Zarephath. Maranai i ḡetai taon ana au anirui, ma kaiababa i ʼnanai ai i ḡunaḡuna, ma i riwei, “A vivibaḡaim da waira aburuna uta neiai da ata uma!” ");
INSERT INTO wed_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Ma i nenae vainana aubaina ma orotona i garara me i pa, “Ma palawa apuapunana aburuna maiteni uta neiai.” ");
INSERT INTO wed_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Kaiababa i paribelana i pa, “Riwa kaua! Am Bada God lawalawaina ma wavanei a ririwa, tau awariu eḡa palawa apuapunana. Awariu palawa aburu kaimojina ma monamona aburuna. Ai a ḡunaḡuna da ana nae au numa ma lam damona ana vitavi da natu maiteni ana am ma au murina ana raumolaḡau da ana iraḡe.” ");
INSERT INTO wed_vpl VALUES ("K117_13","012_17_13","1KI","17","13","14","Wate Elijah kaiababa i riwei, “Eḡa ma vinuabola! Bada Israel ana God e ririwa, ‘Am palawa abomana eḡa ma monamona wagina eḡa ina kwakwava ma Bada garewa ina paritawaneiai da wapu ina gogo me!’ Anina ma nae au numa ma u ririwa nanare ma kauei, wate au naona palawa aburuna ma apui aubaiu. Ma mae-terenana ma apui aubaimi.” ");
INSERT INTO wed_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","I nae ma menanare Elijah i ririwei, nanare i kauei. Ma awari lam i mae da aupom biaḡa i kwa. ");
INSERT INTO wed_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Ma me Bada Elijah i parivainuaḡani nanare palawa au aboma eḡa ita kwa ma monamona au wagi eḡa ita kwa. ");
INSERT INTO wed_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Muriai kaiababa natuna i doria ma ana doria i vovoguratei anina ma i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Ma wavine Elijah awarina i riwa, i pa, “God ana taunola, Aiwai aubaina wei u kauei awariu? U nei weka da au ḡoʼapoapoe uta vieḡai ma natu uta viʼraḡeni bo?” ");
INSERT INTO wed_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Elijah i paribelei i pa, “Natum ma vereu.” Elijah taubeu, alona au urana i vaia ma i avara-ḡaiei au vatavatara mepa i mamae lana ma ana au animatave i vimataveni. ");
INSERT INTO wed_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Anina ma ponana i rata ma i raupari Bada awarina, “Oo Bada au God, aiwai aubaina kaua apoapoe kaukauana u kauei kaiababa awarina? Tauna i taravainiu da ana au numa a mamae, ma u kauei da natuna i ʼraḡe?” ");
INSERT INTO wed_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Anina ma Elijah i taduru ma mara tonuḡa taubeu au tepana i matave ma ponana i rata ma i raupari Bada awarina i pa, “Oo Bada au God, A vibaḡaim da tevera ana lawana ma veremelei!” ");
INSERT INTO wed_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Bada Elijah ana pari i nonori ma tevera lavutu i vikarei ma i lawana. ");
INSERT INTO wed_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Elijah tevera i voepai ma i avara ḡairei alona awarina ma i riwei, “Ma inanai natum lawalawaina.” ");
INSERT INTO wed_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Wavine i riwa, “Marina aramana-kauei da tam God ana taunola, ma Bada ana riwa gamomei e opuopu lamna riwa kaua!” ");
INSERT INTO wed_vpl VALUES ("K118_1","012_18_1","1KI","18","1","2","Madeḡa tonuḡa garewa eḡa ma gomara ḡaeḡaena i mae. Madeḡa au vitonuina Bada Elijah i riwei, I pa, “Ma nae gulau Ahab ma inanai. Ma tau garewa ana paritawaneiai.” Ma Elijah i nae da gulau Ahab ita inanai. ");
INSERT INTO wed_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Maranai tauna Elijah i ʼnanai ma i riwa, “Wei tam bo, mai Israel rauaḡaiḡaii amai?” ");
INSERT INTO wed_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Elijah i paribelei, “Tau eḡa ata rauaḡaiḡai au Jerusalem, wate tam, ma amam ana numa ravai maiteni o rauaḡaiḡai. Taumi Bada ana tarawatu o geduaiei, ma Baal kokoitaui o viviborumei.” ");
INSERT INTO wed_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Marina mai Israel anatapui ma ḡorei da ina nae au ola Carmel ina nebeleu. Baal ana peroveta 450 ma Asherah god wavinena ana peroveta 400 Jezebel ana au aboma e amam, anataputapui ma neiai. ");
INSERT INTO wed_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Ma Ahab mai Israel anatapui ma Baal ana peroveta i ḡorei da au ola Carmel ina vinenebelana. ");
INSERT INTO wed_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Elijah patara au naoi i mairi ma i riwei, “Wei vinua-raḡaraḡai mara aiwai ina kwa, ona vinuanaina nae ma ona vianuanaina nei, metauna notana ona vaia? Mepa da Bada God, tauna ona raudunelei. Mepa da Baal god, tauna ona raudunelei.” Wate rava eḡa aiwai ita riwei. ");
INSERT INTO wed_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Ma Elijah taui awarii i riwa, “Bada ana peroveta anina tau a mamae. Wate Baal ana peroveta 450. ");
INSERT INTO wed_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Aubaita bull ruaḡa ona neiai, ma taui ai sia ina rautani ma ina bori muomuoi ma ai au tepana ina terei, wate eḡa ina ravivoai. Ma tau nanare ana kauei. ");
INSERT INTO wed_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Ma taumi ona raupari ami god awarina, ma tau ana raupari Bada awarina. Metauna godna ai araratanei i paribelana tauna God ririwa kauana!” Ma rava anatapui i vianina. ");
INSERT INTO wed_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Elijah Baal ana peroveta i riwei, “Taumi o maḡa aubaina ona vinao, Bull tagogi ona vinei ma ona vokaukauei. Ami god awarina ona raupari ma eḡa ai ona ravivoai.” ");
INSERT INTO wed_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Ma taui ai bull i vaia ma i vokaukauei. Anina ma Baal awarina i raupari, ubaubanai i vikarei da i raviaubenai. Taui i garagarara, “Oo Baal, ma paribelelai!” Ma pulo aniapuna i arara kwaviviroi, Wate eḡa paribelana; eḡa aiai ita paribelei. ");
INSERT INTO wed_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Aubenai Elijah i vikarei da i vimarumarui i pa, “Ona raupari guratana! Tauna god! Mepa da e rarauboni bo i nae au ririva bo e vaḡavaḡai bo e matamatave! Ona ravidagudagui!” ");
INSERT INTO wed_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Ma taui garara i voguraguratei ma me ai au kaua nanare, naipiei ma aierei tupuai i boribori-melei ma tara i toitoi. ");
INSERT INTO wed_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Taui i garagarara da i garagarara da aubigai pulo apuna ana mara. Wate amapo da eḡa paribelana, eḡa aiai ita paribelei, eḡa aiwai ita nonori. ");
INSERT INTO wed_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Ma Elijah rava i riwei, “Ona nei awariu.” Ma anatapui i nei ma Elijah i mae-kwaviviroi, tauna Bada ana pulo aniapuna i voavoa-melei. ");
INSERT INTO wed_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Elijah ḡaima 12 i vaia, ḡaima tagogi da Israel ana dam tagogi aubaina. Wava Israel Bada taui noii Jacob i verei. ");
INSERT INTO wed_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Ma ḡaimanei pulo aniapuna i voa-melei Bada viborumana aubaina. Ma au adana doba i ḡarai da waira ana ruva 14 Ltr nanare ina vojijini. ");
INSERT INTO wed_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Pulo aniapuna au tepana ai i vatari, bull i bori-naiei ma siana ai au tepana i terei. Ma i riwa, “Nau 4 ḡaeḡaei waira ona vioai, ma sia ma ai au tepana ona iwaḡi.” ");
INSERT INTO wed_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Ma nanare i kauei, ma i riwei, “Ona kauana-melei.” Ma nanare i kauei. Ma i riwei, “Mara vitonuina ona kauana-melei.” Ma nanare mara vitonuina i kauei. ");
INSERT INTO wed_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Waira i toi ḡaira da dogo maiteni i vioai. ");
INSERT INTO wed_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Ma aubigai pulo apuna ana mara i ḡetai, Elijah i babara-ḡae pulo aniapuna au ririvana ma i raupari i pa, “Oo Bada, Abraham, Isaac ma Jacob ai God, amadodo rava ma viatataiei da tam God au Israel ma tau am taunola, ma anatapuna u ririwei a kauei. ");
INSERT INTO wed_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Bada ma paribeleu, Oo Bada ma paribeleu da rava ina aramei da tam, au Bada, tam anina God, ma marina rava orai e taitaina-melei awarim.” ");
INSERT INTO wed_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Maratagogi Bada ana ai marei i ḡairai ma pulo bull, ai, ḡaima ma doa i aragibui. Ma waira i ʼwaiwaḡia i ḡuḡuva-pai. ");
INSERT INTO wed_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Maranai rava wei i ʼnanai taui i mae-ḡaira au doa da i matave-taitaina ma i garara Bada awarina, “Bada anina God! Bada ainelana anina God!” ");
INSERT INTO wed_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Ma Elijah rava i egari, “Baal ana peroveta ona vojijini; Eḡa tagogi ona voterei da ina ruba!” Peroveta anatapui i vojijini ma Elijah taui i riwei da i ḡairei au Kishon gaugaubana ma anatapui i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Ma Elijah gulau Ahab i riwei, “Ma nae da ma am ma garewa ḡaeḡaena gugurana a nononori.” ");
INSERT INTO wed_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Ma Ahab i nae da ita am ma Elijah i ḡae ola Carmel au tepana, ma i mae-ḡaira au doa ma kolana au ae-tutuna ma i raupari. ");
INSERT INTO wed_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Ma ana taunola i riwei, “Ma nae ma au bogei ma inana.” Ana taunola i nae da i nememei Elijah awarina ma i riwei, “Eḡa aiwai ata inanai.” Anatapuna mara 7 i paritawanei da inana. ");
INSERT INTO wed_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Ma mara vi-7-na i nememei ma i riwa, “Apau aburuna ana rata me oroto urana a inanai bogei i ḡeḡae.” Ma Elijah i riwa, “Ma nae ma Ahab ma riwei, ‘Am chariot ma gerui ma ma ḡaira muriai da garewa ina rautomenim.” ");
INSERT INTO wed_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Ma aburuna ava ma lada i ḡei ma dobu i waguvarei ma ivena i ruba ma garewa ḡaeḡae otana i toi. Ahab ana chariot i gerui ma i ruba au Jesreel. ");
INSERT INTO wed_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Ma Bada ana rewapana i rui Elijah awarina; ma ana gara giana i taini da ana au jigoraḡita i raḡita-jijini ma i lavui da Ahab i votani da i aiḡeta au Jesreel. ");
INSERT INTO wed_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Ma Ahab awana Jezebel i vibenabenamei, aiwai anatapuna Elijah i kaukauei ma menanarena Baal ana peroveta anatapui i vununaiei. ");
INSERT INTO wed_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Ma Jezebel taupariverena i paritawanei Elijah awarina ma i pa, “Wenanarena marana au maratom, tau ana viraḡenim me au peroveta u viraḡenanei nanare. Mepa da wenanare eḡa ana kauei, a raraupari da god ina kovoḡa-kaueu bo ina viraḡeniu.” ");
INSERT INTO wed_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Elijah i rovo ma ana lawana aubaina i ruba. I nae au Beersheba au Judah, ma kampa ana taunola i voterei. ");
INSERT INTO wed_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","Ma tauna ainelana i nae aupom au mutulua, ma i ḡeta ai brum au ḡouna ma i kiala ma i raupari da ita iraḡe. I riwa i pa, “Bada, tau malau a vai-avei. Au lawana ma vaitawanei marina, tau irairaḡeu, me noinoiu.” ");
INSERT INTO wed_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Ma i mae-ḡaera ai brum au karena ma i matave. Ma maratagogi Bada ana anela Elijah i vodadani ma i riwa, “Ma vomairi, ma am.” ");
INSERT INTO wed_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","I ʼnana viravira ma i matamatave lana au kolanei palawa apuapunana ma waira aniuma. I am ma i uma ma i matave me. ");
INSERT INTO wed_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Bada ana anela i nememei, i vodadani ma i riwei, “Ma vomairi ma ma am aubaina am vaḡai ina manawa guratana.” ");
INSERT INTO wed_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Elijah i vomairi da i am ma lamnei rewapana i vaia da ina babara aupom 40 ma maratom 40 da au Sinai, Bada ana au ola i ḡeta. ");
INSERT INTO wed_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","Ma kampa i ḡeta au guba ma i matave. Wate Bada i riwa, “Elijah weka aiwai e kaukauei?” ");
INSERT INTO wed_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Elijah i paribelei, “Oo Bada vivirewapana kaukauam, Tau mara nonoa tam a viborumem - tam ainelam. Mai Israel am parivainuaḡana bagibagina i viaigai, am pulo aniapuna i viairikarikai, ma am peroveta i viraḡena-pai, tau ainelau i votereu, ma marina i ḡoei da tau maiteni ina viraḡeniu!” ");
INSERT INTO wed_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Bada i riwa, “Ma opu au ola ma au naoi ma mairi.” Ma Elijah kampa i maimairi ma labu ḡaeḡaena olana i ravi, da i gunevi, wate bada eḡa nai kojikojirana au orana. Ive au murina lolo, wate Bada eḡa nai lolona au orana. ");
INSERT INTO wed_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Lolo au murina ai araratana, wate Bada eḡa nai aina au orana. Ma ai au murina pariararava jinajinana i nonori. ");
INSERT INTO wed_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Maranai Elijah wei i nonori ana kwama i vaia da naona i purui ma i opu guba au naona i mairi. Ma pona i riwa, “Elijah weka aiwai e kaukauei?” ");
INSERT INTO wed_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","I paribelei, “Oo Bada God, vivirewapana kaukauam, mara nonoa tam ainelam aubaim a vivilaraḡa. Wate Israel ravai am parivainuaḡana bagibagina i geduaiei, am pulo aniapuna i rikanaiei, ma am peroveta anatapui i viraḡeni. Tau ainelau a mamae. Ma marina i ḡoei da tau maiteni ina viraḡeniu.” ");
INSERT INTO wed_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Bada i riwa, “Meiei e nenei nanare ma nae me, ma ma‑rui au mutulua Damaskas, maranai u ḡeta au taon, Hasael ma buloi, mai Syria ai gulau; ");
INSERT INTO wed_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","Nimshi natuna Jehu ma buloi Israel ai gulau, ma Shaphat natuna Elisha, ana taon Abel-Mehola ma buloi peroveta da am gabu ina vaia. ");
INSERT INTO wed_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Aiavoi da Hasael i rovoei da e rubaruba, Jehu taui ina viraḡeni ma aiavoi da Jehu i rovoei da e rubaruba, Elisha taui ina viraḡeni! ");
INSERT INTO wed_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Wate mai Israel ai maḡa 7,000 eḡa melanai Baal ita raudunelei bo kokoitaui ita vigia-laḡolaḡonei, ina lawana!” ");
INSERT INTO wed_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Ma Elijah i nae da Shaphat natuna Elisha i viaroni doa i uauatai, bulumakau 12 ruaruaḡei ava raḡiraḡitai aniuata i taitaini ma i uauata. Elisha ana bulumakau, au murioina i nolanola. Elijah i ḡaira awarina ma ana kwama i votawanei ma Elisha i vioteni. ");
INSERT INTO wed_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Elisha bulumakau i votere-tawanei ma Elijah i rubei, ma i riwa, “Au naona ma votereu da ana nae amau ma alou ana inanai ma ana vigia-lagolagonei ma tana nae.” Elijah i paribelei, “Anina ma nae wate aiwai a kauei awarim ma vinuanotenotei!” ");
INSERT INTO wed_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Ma Elisha i nae da ana bulumakau ruaḡai i viraḡeni, pawe bulumakau au uai i viaigaigai da ai i viviri da sia i apui ma rava i verei da i am. Anina ma i opu da Elijah i votagotagoi. ");
INSERT INTO wed_vpl VALUES ("K22_1","013_2_1","2KI","2","1","1","Ma mara i ḡetai da Bada Elijah labuei ita ḡaiei au mara. Elijah ma Elisha Gilgal i voterei ma i nenae. ");
INSERT INTO wed_vpl VALUES ("K22_2","013_2_2","2KI","2","2","2","Ma Elijah, Elisha i riwei i pa, “Weka ma mae ma Bada i riweu da ana nae au Bethel.” Wate Elisha i paribelei, “Riwa kaua da Bada lawalawaina ma nanare tam lawalawaim, tau nanare eḡa melanai ana voterem.” Anina ma airuaḡa i ḡaira au Bethel. ");
INSERT INTO wed_vpl VALUES ("K22_3","013_2_3","2KI","2","3","3","God ana peroveta borui au Bethel maemaei i opui Elisha awarina ma i riwei i pa, “Tam u aramanei da Bada am bada amadodo awarim ina vaitawanei?” Elisha i paribelei, “Ee a ʼramanei, wate lamna eḡa ona babaniei.” ");
INSERT INTO wed_vpl VALUES ("K22_4","013_2_4","2KI","2","4","4","Ma Elijah, Elisha i riwei, “Weka ma mae, Bada i riweu da ana nae au Jeriko.” Wate Elisha i riwa, “Riwa kaua da Bada lawalawaina ma nanare tam lawalawaim, tau nanare eḡa melanai ana voterem.” Anina ma taui i nae au Jeriko. ");
INSERT INTO wed_vpl VALUES ("K22_5","013_2_5","2KI","2","5","5","Ma God ana peroveta borui kampa au Jeriko maemaei i opui ma Elisha i nebelei ma i riwei, “Tam u aramanei bo da Bada am bada amadodo awarim ina vaitawanei?” Elisha i paribelei, “Ee a ʼramanei, wate lamna eḡa ona babaniei.” ");
INSERT INTO wed_vpl VALUES ("K22_6","013_2_6","2KI","2","6","6","Ma Elijah i riwei, “Weka ma mae, Bada e paripari-tawaneu au Waira Jordan.” Wate Elisha i paribelei i pa, “Riwa kaua da Bada lawalawaina ma nanare tam lawalawaim, tau nanare eḡa melanai ana voterem.” Ma airuaḡa i babara nae. ");
INSERT INTO wed_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","God ana peroveta 50 taui i votaḡotaḡoi, ma au muri i tumairi maranai Elijah ma Elisha Waira Jordan au adana i tumairi. ");
INSERT INTO wed_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","Elijah ana kwama i votawanei ma i piri ma lamnei waira tepana i ravi. Da i vilamonei au oiena ma au kelakelauna ma taui au pouna au alalana i babara damana. ");
INSERT INTO wed_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Maranai au baba ḡelauna i ḡeta Elijah, Elisha i riwei, “Ma riweu aiwai ana kauei aubaim muriai da ina ḡaieu.” Ma Elisha i paribelei, “Tau am gabu ana vaia da peroveta ai bada lamna aubaina a ḡoei da am rewapana ḡaeḡaena, ma viaitepatepani ma ma veredamaneu.” ");
INSERT INTO wed_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","Elijah i riwa, “Lamna kaua piripirina e vivibaḡei, wate mepa da u inanai ina ḡaiḡaieu, lamna u vivibaḡei u vaia ma eḡa, lamna eḡa.” ");
INSERT INTO wed_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Ma airuaḡa i bababara ma i vibababani ma hosi araratana, chariot araratana i taina ḡetei ma taui i raviḡori. Ma Elijah ma Elisha au poui i ruba ma Bada Elijah labuei i ḡaiei au mara. ");
INSERT INTO wed_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Elisha wei i ʼnanai ma i garara, “Amau! Amau! Mai Israel taugagaloeina vivirewapana! Tam u nae!” Ma Elijah eḡa ita inana-melei. Nuanuana i bola-kauei ma ana kwama au pouna i sikai. ");
INSERT INTO wed_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Ma Elisha i nae ma Elijah ana kwama au doa i vivipeunia, maranai i ḡaiḡaiei au mara, i voepai ma i nae me waira au adana. ");
INSERT INTO wed_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Ma kwamana i peupeu i vaia ma waira tepana i ravi ma i riwa, “Bada Elijah ana God mepa?” Maranai waira i ravi, waira i vilamonei ma au pouna au alalana i babara damana. ");
INSERT INTO wed_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Jeriko ai peroveta boruna 50 au weia ma i ʼnanai aiwai i tupua ma i riwa, “Elijah ana rewapana i damana Elisha awarina.” Ma i nae da ita nebelei ma i mae-ḡaira au doa ma i raudune. ");
INSERT INTO wed_vpl VALUES ("K22_16","013_2_16","2KI","2","16","16","Ma i riwa i pa, “Tauai rewapana 50, ma paritawanelai da am bada ana baiei. Mepa da Bada Aruana, Elijah i voepai da mepa au ola bo au gaugauba i teretawanei.” Elisha i paribelei, “Eḡa! Eḡa ona nae.” ");
INSERT INTO wed_vpl VALUES ("K22_17","013_2_17","2KI","2","17","17","Wate taui i voiḡiriḡiri da tauna i vinimala da i paritawanei i pa, “Anina ona nae.” Wate taui 50 aupom tonuḡa i baia ma eḡa ita nelaḡai. ");
INSERT INTO wed_vpl VALUES ("K22_18","013_2_18","2KI","2","18","18","Maranai taui i nememei au Jeriko, Elisha taui i riwei, “A riwemi da avena ota nae!” ");
INSERT INTO wed_vpl VALUES ("K24_8","013_4_8","2KI","4","8","8","Mara tagogi Elisha i nae au Shunem taon. Weka wavine manemanena i mae, ma Elisha i vibaḡa-guratei da ita mae da ita am. Ma maranai Elisha wei au dobuna e vaḡavaḡai, tauna weka i amam. ");
INSERT INTO wed_vpl VALUES ("K24_9","013_4_9","2KI","4","9","9","Wavine awana i riwei, “Aramanei da orotona weka e nenei lamna Bada ana peroveta vivivireina. ");
INSERT INTO wed_vpl VALUES ("K24_10","013_4_10","2KI","4","10","10","Ana numa aburuna au poewa tana voai ma ani matave, kepakepa, ani kiala ma rampa tana terei au orana tauna aubaina. Ma kampa ina mae maranai e nenei.” ");
INSERT INTO wed_vpl VALUES ("K24_11","013_4_11","2KI","4","11","11","Mara tagogi Elisha i nei ma i ḡae ana au numa da i rauvirai. ");
INSERT INTO wed_vpl VALUES ("K24_14","013_4_14","2KI","4","14","14","Muriai Elisha ana taunola wavana Gehasi i paridadanei, “Aiwai ana kauei wavinena aubaina.” Ma Gehasi i paribelei, “Tauna eḡa natuna orotona ma awana i magura.” ");
INSERT INTO wed_vpl VALUES ("K24_15","013_4_15","2KI","4","15","15","Ma Elisha i riwa, “Ma ḡoreiai.” Ma Gehasi wavine i ḡoreiai ma i nei da au metaeta i raumairiei. ");
INSERT INTO wed_vpl VALUES ("K24_16","013_4_16","2KI","4","16","16","Ma Elisha wavine i riwei, “Wenanare marana madeḡa au ḡelauna tam natum orotona ma ḡuniḡuni.” Wavine i paribelei, “Eḡa au bada. Tam peroveta ma tau am taunola, eḡa ma morui!” ");
INSERT INTO wed_vpl VALUES ("K24_17","013_4_17","2KI","4","17","17","Wate wavine i raumanawa. Ma marana wenanare madeḡana au ḡelauna wavinena natuna orotona i ḡuniḡuni, Elisha i ririweia nanare. ");
INSERT INTO wed_vpl VALUES ("K24_42","013_4_42","2KI","4","42","42","Mara ḡelauna, oroto tagogi melagai Baal-Shalishahei i nei. Tauna nai madeḡana witina naona i labai ma palawa i apui da iavana 20. Ma witi majiḡai baikena maiteni i neiai da Elisha i verei. Elisha ana taunola i riwei, “Rava lam ma verei da ina am.” ");
INSERT INTO wed_vpl VALUES ("K24_43","013_4_43","2KI","4","43","43","Ma ana taunola i garara, “Aiwai! Wei lam eḡa tagotagogina da rava 100 tana viambagibagi?” Wate i paribelei i pa, “Bada i riwa da rava ma verei da ina am ma lam ina mae-terei.” ");
INSERT INTO wed_vpl VALUES ("K24_44","013_4_44","2KI","4","44","44","Ma lam au naoi i terei ma taui i am ma lam i mae-terei, Bada i ririweia nanare. ");
INSERT INTO wed_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","Namaan lamna mai Syria ai sorodia badana. Bada, Namaan awarina i mae ma lamnei ai ḡavia i vovovai-ubai. Ma lamna aubaina ai gulau, tauna i vivirana-kauei ma i vitumaḡanei. Namaan sorodia wavana naenaena wate doria lepera i vaia. ");
INSERT INTO wed_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Marana patapatai mai Syria i nenei au Israel i viviḡavia. Mara tagogi tevera guguinina i pani da i naiei da ai bada Namaan awana i verei da ana taunola. ");
INSERT INTO wed_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","Mara tagogi guguinina ana bada wavinena i riwei, “Au bada, am bada uta riwana-dadanei mepa da ita nae perovetana au Samaria maemaena awarina. Tauna ana doria ita inanai ma ita vilawani.” ");
INSERT INTO wed_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Ma Namaan ana hosi ma chariot borui i nae ma Elisha ana au metaeta i raumairiei. ");
INSERT INTO wed_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Wate Elisha taupariverena i paritawanei da i riwei i pa, “Ma nae da au waira Jordan ma oḡa-melem mara seven ma lepera doriana ina voterem ma opim ina ai-me.” ");
INSERT INTO wed_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Wate Namaan amlona i ḡaiḡai kaua ma i riwa i pa, “Tau au nota ḡaeḡaena da peroveta ita opui da ita inanaiu da urana, opiu au tepana mataira ita kauei ma ana Bada God awarina ita raupari da ata lawana. ");
INSERT INTO wed_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","Wate waira Amanah ma Pharpar au Syria i ai telera eḡa me Israel wairai. Tau kampa ata toa ma ata lawana.” Ma Namaan i mae-tavirei ma ana amloḡaiḡaina i nae. ");
INSERT INTO wed_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Ana laralaraga i nae awarina ma i riwei, “Au bada mepa da ita riwem da aiwai piripirina uta kauei, lamna uta kauei tapa? Wei lamna kaua telatelana i ririwei nanare, ‘Ma toa ma ma lawana.” ");
INSERT INTO wed_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Ma Namaan i ḡaira au waira Jordan ma mara seven waira au orana i ḡaira, me peroveta i ririwei nanare. Ma opina i ai me da me tevera tupuana nanare ma lepera doriana i kwa. ");
INSERT INTO wed_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Ma Namaan ana laralaraga maiteni i nae me Elisha awarina ma i riwa, “Marina aramanei da au dobu, god eḡa ita mamae anina Israel ana God tauna ava; lamna aubaina au bada pulo a vereverem ma vaia.” ");
INSERT INTO wed_vpl VALUES ("K25_16","013_5_16","2KI","5","16","16","Wate Elisha i paribelei, “Riwa kaua da Bada a vivitaunolei lamna Bada lawalawaina, ma wavanei a ririwa tau eḡa pulo ana vaia.” Ma Namaan i babani bagibagi da Elisha pulona ita vaia, wate tauna pulona i geduaiei. ");
INSERT INTO wed_vpl VALUES ("K25_17","013_5_17","2KI","5","17","17","Ma Namaan i riwa, “Mepa da nanare lamna ma vianineu da donki ruaḡa ai vita ruvana Israel doana ana vigerui da ana naiei au numa. Ma marina da e nenae, eḡa melanai pulo ana apui bo sia taputapuna ana apui god ḡelaui awarii, anina Bada ainelana awarina. ");
INSERT INTO wed_vpl VALUES ("K25_18","013_5_18","2KI","5","18","18","Tau am taunola ma a ḡoei da Bada au ḡoa apoapoei ina nota-tawanei, kaua tagogi ava awarinei; maranai au gulau a ruiruiei ana au tempol ma tauna au urau e vovojijina ma maiteni a mamae-ḡaira ma Syria ai god Rimmon a viviborumei.” ");
INSERT INTO wed_vpl VALUES ("K25_19","013_5_19","2KI","5","19","19","Elisha i riwa, “Ana nuaubam ma nae.” Ma Namaan i nae. ");
INSERT INTO wed_vpl VALUES ("K217_5","013_17_5","2KI","17","5","6","Assyria ai gulau Israel anatapuna i naeni, da i ḡeta da Samaria taon I mae-kwaviviroi, ma i gudu-tomeni da madeḡa tonuḡa i kwa. Maranai Hosea ana vigulau madeḡana 9 i ḡetai, Mai Assyria Samaria taon i ruini mai Israel i pupuna-naiei au Assyria. Ma au Halah, taon, waira Habor au ririvana ma mai Mede ai au taon nununai i verei da i raunuma. ");
INSERT INTO wed_vpl VALUES ("K217_7","013_17_7","2KI","17","7","8","Wei kovoḡai i nei mai Israel awari aubaina taui god ḡelaui i viviborumei. Taui ai ḡoa apoapoe i rata kauaBada ai God awarina, Wariaḡa Tauna Egypt ai gulau Pharaoh au urana Israel i vai-tawanei ma aiaii i ravena-opunei. Mai Israel ai God eteni i pupuna-opunei ai kaua i votaḡotaḡoi da i kaukauei ma kaua waduboi ḡelaui Israel ai gulagulaui i kaukauei. ");
INSERT INTO wed_vpl VALUES ("K217_9","013_17_9","2KI","17","9","10","Mai Israel kaua apoapoei i kaukauei Bada ai God awarina ma Bada wei kauai eḡa ita vinuaiaiei. Taui voepaepa gabui i voanaiei god morumorui voepaepaei aubaina au taon nununai, melagai aburuoina da au taon ḡaeḡaei. Ola muomuoi anatapui au tepai ma ai anatapui au ḡoui gana vinualaulaui i terenaei ma Asherah ana tuatua ma kokoitaui i vituramairini. ");
INSERT INTO wed_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Assyria ai gulau taon nununai ravai mai Babilon, Cuthah, Awa, Hamath ma Sepharvaim i vivaneiai da Samaria, ana au taon nununai kampa i terei da i mae. Taui mai Israel numa i ruba-tawanei i raunumei. ");
INSERT INTO wed_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","Vouvounai wei ravai eḡa Bada ita viborumei, lamna aubaina lion ḡelaui i paritawaneiai da rava i viviraḡeni. ");
INSERT INTO wed_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Ma rava Assyria ai gulau ana riwa i paritawanei i pa, “Rava au Samaria u terenaiei, dobuna Godna ana tarawatu eḡa ita aramanei. Lamna aubaina ma dobuna ana God, lion i paritawanei ma ravai e viviraḡeni.” ");
INSERT INTO wed_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Ma mai Assyria ai gulau rava i egari, i pa, “Pirisi tagogi au Samaria o panipania, ona paritawana-melei ma, dobuna ana God, ana kaua ravai voui ina viararamani.” ");
INSERT INTO wed_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Anina ma pirisi tagogi au naona i naenaei au Assyria i neiana-melei da au Bethel i mae. Kampa rava i viararamani da Bada viborumei. ");
INSERT INTO wed_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","Wate jentail ravai nununai ai god morumorui kokoitaui i kaukauei ma metauna au taona i mamae, kampa ola au tepai au naona mai Israel au Samaria ai voepaepa gabui i voavoailana, kampa i terenaiei. ");
INSERT INTO wed_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","Elah natuna Hosea i vigulau au Israel madeḡa tonuḡa i kwa. Wei maranaina au Judah Hezekiah, Ahaz natuna i vigulau. ");
INSERT INTO wed_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","Tauna ana madeḡa 25 ma i vibada au Jerusalem da madeḡa 29 i kwa. Alona Abi, Zekariah natuna. ");
INSERT INTO wed_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","Tauna kaua aiaii avai i kaukauei Bada awarina me noina David nanare. ");
INSERT INTO wed_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","Ma god morumorui ai ani voepaepa gabui anatapui i votawatawanei. Ma kokoitau i viairikarikai ma Asherah tuatuana i taratuituina-naiei. Ma wariaḡa Moses mota bronzei, kokoitaui i kauei, i viviborumei. Hezekiah motana kokoitauna maiteni i viaigimagimai. (Mai Israel motana i ḡorei Nehushtan.) ");
INSERT INTO wed_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","Hezekiah Bada, Israel ana God i vitumaḡanana-kauei. Eḡa gulau ḡelauna au Judah nanare me tauna, ma eḡa aiai ḡelauna nanare au naona i mae bo muriai i mae. ");
INSERT INTO wed_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","I vipatutu Bada awarina au anatapuna ma i vovoguratei da God ana tarawatu Moses i vereverei anatapuna i vovotaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","Bada tauna awarina i mae ma ana nola anatapuna i davudavu. Tauna Assyria ai gulau i parivirevirei ma eḡa aubaina ita vilaraga. ");
INSERT INTO wed_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","Ma mai Philistia anatapui i vovaiubai, melaḡai da taon ḡaimei garigarina anatapuna i pupuni da au Gaza i ḡeta. ");
INSERT INTO wed_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","Manasseh ana madeḡa 12 ma i vigulau au Jerusalem, ma i vibada madeḡa 55. Tauna alona Hephsibah. ");
INSERT INTO wed_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","Wariaḡa Bada eteni ravai i virubai ai kaua vinuamedamedai aubaina maranai mai Israel i ruirui au Canaan. Manasseh wei ravai ai kaua i votaḡotaḡoi da i kaukauei ma ana ḡoa apoapoe i rata Bada au matana, ");
INSERT INTO wed_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","Manasseh ola muomuoi au tepai god morumorui awari voepaepa gabui amana i viairikarikai, i voa-melei. Ma nanare pulo aniapuna i voanaiei Baal awarina, ma Asherah tuatuana i tonanaiei me Israel ana gulau Ahab. Manasseh wate nanare ubona i viviborumei. ");
INSERT INTO wed_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","Tauna god morumorui ai pulo aniapuna i voanaiei Bada ana tempol au orana, wei gabuna aubaina Bada i riwa i pa, “Wavau au tempol ina mae.” ");
INSERT INTO wed_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","Tempol au metaetana, gabu garigarina au orana Pulo aniapui ruaḡa i voai ubona god aubaii. ");
INSERT INTO wed_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","Manasseh natuna orotona ai au araratana i apui ana pulo, ma parauma ma baravu ma gweri da ginauri ravai i rautaniḡanei. Kaua maḡamaḡaui apoapoe kaukauai i kauei ma Bada amlona i ḡaiḡai kaua. ");
INSERT INTO wed_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","Ma lamna aubaina Bada ana peroveta awariei i babani i pa, ");
INSERT INTO wed_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","“Gulau Manasseh kaua maḡamaḡaui vinuamedamedai i kaukauei, ma tauna i apoapoe kaua eḡa me mai Amori, taui wei dobuna i maeni muriai da mai Israel. Ai kokoitau miramirai awariei mai Judah i raveni da i ḡoʼapoapoe. ");
INSERT INTO wed_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","Lamna aubaina Bada Israel ana God wenanare e ririwa, ‘Kovoḡa ḡaeḡaeotana ana neiai Judah ma Jerusalem awarii da maranai rava anatapui riwana taniḡaiei ina nonori ma orai ina auepai. ");
INSERT INTO wed_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","Ruvana tagoginei Samaria a kovoḡi ma ruvana tagoginei Jerusalem ma Israel ai gulau Ahab ana epaepaia maiteni a kovoḡi. Jerusalem ravai ana amaḡa-tawanei, me aboma ita amamaḡi, ma i vitaragabubui. ");
INSERT INTO wed_vpl VALUES ("K221_14","013_21_14","2KI","21","14","15","Au rava i ḡoʼapoapoe awariu, maranai noinoii Egypt i opu-tawanei da marina. Wei e viviamloḡaiḡainiu. Ma rava mamae‑terenai ana inana-tawanei, ma ana veredamanei ḡavia awarii ma taui ina vovaiubai ma ai purapura ina kwalei.” ");
INSERT INTO wed_vpl VALUES ("K221_16","013_21_16","2KI","21","16","16","Manasseh mai Judah i raveni da god morumorui i viborumei ma Bada i vijiboḡi; wate eḡa lamna ava ma rava aiaii i viraḡena labalababai da tara i kororo da Jerusalem etanaina i vioai au giana da au giana: ");
INSERT INTO wed_vpl VALUES ("K221_18","013_21_18","2KI","21","18","18","Manasseh iʼraḡe ma ana numa au ririvana dobu wavana Uzza ana au wapu i doboi, Ma natuna Amon ana gabu i vaia da i vigulau. ");
INSERT INTO wed_vpl VALUES ("K221_19","013_21_19","2KI","21","19","19","Amon ana madeḡa 22 ma i vigulau. Ma i vibada madeḡa ruaḡa au Jerusalem. Tauna alona Meshulemeth, oroto Jotbahei wavana Harus natuna ");
INSERT INTO wed_vpl VALUES ("K221_20","013_21_20","2KI","21","20","20","Tauna ana ḡoʼapoapoe, i rata kaua Bada awarina me amana nanare. ");
INSERT INTO wed_vpl VALUES ("K221_21","013_21_21","2KI","21","21","21","Amana i ḡovaivaitei ma god morumorui i viborumei. ");
INSERT INTO wed_vpl VALUES ("K221_22","013_21_22","2KI","21","22","22","Tauna noinoii ai God, Bada i rawaḡaiḡaiei ma ana tarawatu eḡa ita votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("K221_23","013_21_23","2KI","21","23","23","Ana gabemani babadai Gulau Amon i viogei da ana au gulau numana i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("K221_24","013_21_24","2KI","21","24","24","Wate mai Judah, rava gulau Amon viraḡenana i viogatarei anatapui i viviraḡena-naiei ma natuna Josiah i terei da i vigulau. ");
INSERT INTO wed_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Josiah ana madeḡa 8 maranai i vigulau au Judah ma i vibada au Jerusalem madeḡa 31. Tauna alona Jedidah, oroto Boskathei Adaiah natuna. ");
INSERT INTO wed_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","Tauna Bada au matana aiwai ana tapuna i kauana-kauei ma noina David au ivina i tua ma Bada ana tarawatu ana tapuna i votaḡotaḡo-kauei. ");
INSERT INTO wed_vpl VALUES ("K222_11","013_22_11","2KI","22","11","11","Maranai gulau i nonori aiwai Tarawatu au bukana i girumi, ma ana gara i viaisikasikai. ");
INSERT INTO wed_vpl VALUES ("K222_12","013_22_12","2KI","22","12","12","Ma gulau Josiah ana taunola pirisi Hilkiah, Saphan natuna Ahikam, Micaiah natuna Akbor, Shaphan gulau ana taugiruma ma Asaiah gulau ana tauvinuaterena i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("K222_13","013_22_13","2KI","22","13","13","“Noinoita wei bukana riwana eḡa ita votaḡotaḡoi, ma aiwai i ririwei eḡa ita votaḡotaḡoi, lamna aubaina Bada amlona i ḡaiḡai awarita. Lamna aubaina ona nae au tempol ma Bada awarina ona raupari tau ma wei dobuna ravai aubaii ma Judah ravai ḡelaui aubai. Ma ona paridadana wei au bukana aiwai i girumi.” ");
INSERT INTO wed_vpl VALUES ("K222_16","013_22_16","2KI","22","16","17","Bada wenanare i riwa, “Tau wei dobuna ma dobuna taumaenina ana kovaḡa kauei.” I girugirumia nanare, ma lamna gulau awarimi i ʼavi, Bada wenanare i riwa, “Taui i geduaieu ma god ḡelaui i viviborumei ma lamna i viamloḡaiḡainiu. Jerusalem awarina orau amapo da e ararai ma amapo eḡa ina dauva.” ");
INSERT INTO wed_vpl VALUES ("K222_18","013_22_18","2KI","22","18","18","Wate ona naeme Judah gulauna, i paritawanemi awarina da ona riwei, “Bada Israel ana God e ririwa da ");
INSERT INTO wed_vpl VALUES ("K222_19","013_22_19","2KI","22","19","19","Maranai u nonori menanare Jerusalem ma taumaenina ana kovoḡanei. Tam u rupena ma u vilamolamona tau Bada awariu, am gara u viaisikasikai ma u tou, Tau ana kauei da ina apoapoe kaua, rava ma dobu ana kovoḡi da eḡa aiai wei doana ina maeni. ");
INSERT INTO wed_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","Ma kovoḡana a neneiai au Jerusalem eḡa ina nei da am iraḡe au murina. Ana voterem da ana nuaubam ma iraḡe.” Ma wei pariverena i naiei ma gulau i riwei. Josiah god morumorui viborumai i viḡaei. ");
INSERT INTO wed_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Gulau Josiah babada anatapui au Judah ma Jerusalem i ḡoreiai. ");
INSERT INTO wed_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","Ma pirisi ma peroveta ma rava molamolakana da manemanena, anatapui i ḡae Bada ana au tempol. Kampa gulau parivainuaḡana bagibagina bukana tempol au orana i nenelaḡaia i iava-tapui awarii. ");
INSERT INTO wed_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Gulau ana au gabu i mairi tempol tuatuana au naona ma Bada maiteni parivainuaḡana bagibagina i ravivouni da tauna Bada ana tarawatu ma ana riwa bagibagina orana ma aruana taputapunei ina vojijini, i ririwei nanare au bukana. Ma rava anatapui nanare i parivainuaḡana. ");
INSERT INTO wed_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","Ma gulau, pirisi ḡetelarana Hilkiah, ana pirisi babadai ma tempol taupainii i egari da Bada ana tempol au orana aiwaiei Baal ma god wavinena Asherah ma ubona godna morumorui i viviborumei anatapui ita opuneiai. Gulau wei purapurai anatapui i naiei da gaugauba Kidron au ririvana i apu-naiei, ma lapukarei i vivanei au Bethel. ");
INSERT INTO wed_vpl VALUES ("R236_14","015_36_14","2CH","36","14","14","Ma pirisi ai babada ma rava anataputapui, Bada ana parivainuaḡana bagibagina eḡa ita vojijini ma jentail au ririvai maemaei ai kaua apoapoei kaukauai ma ai bua i ḡovaivaitei. Ma lamnei Bada ana Tempol vivivireina au Jerusalem i vimiramirai. ");
INSERT INTO wed_vpl VALUES ("R236_15","015_36_15","2CH","36","15","15","Mai Judah ḡoḡoḡai ai God Bada, ana rava ma ana tempol nuanuana i bolai ma lamna aubaina ana peroveta nununai i paripari-tawanei da rava ai ḡoa apoapoe ita rupeni. ");
INSERT INTO wed_vpl VALUES ("R236_16","015_36_16","2CH","36","16","16","Wate taui God ana peroveta i vijiboḡi ma eḡa ita vivirei ma au damona Bada ana amloḡaiḡai i rata guratana da menanare ita viubanei. ");
INSERT INTO wed_vpl VALUES ("R236_17","015_36_17","2CH","36","17","17","Anina ma Bada mai Babilon ai gulau i paritawanei da Jerusalem i vipupui. Ai sorodia nelara voui tempol au orana i viraḡena-naiei. Taui mai Judea eḡa ita rau-nuapoapoelei ma waivine ma laraga ma rava magumaguri ma doridoriai. Bada mai Judea anatapui i verenei Babilon ai gulau Nebuchadnezzar au urana. ");
INSERT INTO wed_vpl VALUES ("R236_18","015_36_18","2CH","36","18","18","Tauna Tempol ana purapura ḡaeḡaei da muomuoi ma mane anatapui i pupuna-naiei. Gulau ana gabemani babadai ai numa i viairikarikai ma mane ma purapura i pupuna-naiei au Babilon. ");
INSERT INTO wed_vpl VALUES ("R236_19","015_36_19","2CH","36","19","19","Ma God ana Tempol i apui ma Jerusalem garina i viairikarikai; ma gulau ana numa ma numa ḡelaui anatapui ma purapura mae-terenana anatapui i viairikarikai ma i apu-naiei, eḡa aiwai ita mae. ");
INSERT INTO wed_vpl VALUES ("R236_20","015_36_20","2CH","36","20","20","Ma aiavoi lawalawaii i mamae, anatapui i paninaiei au Babilon da i vitaunola. Ma muriai mai Persia nai dobunaBabilon i pupuni ma i vibadei. ");
INSERT INTO wed_vpl VALUES ("R236_21","015_36_21","2CH","36","21","21","Mai Israel ai doa ipipipiei taui madeḡa au vi-7-na ai doana eḡa lauvitau ita verei, lamna aubaina i kovoḡi, da i pupuna-naiei au Babylon da madeḡa 70 i kwa. Bada ana peroveta Jeremiah i ririweia nanare i tupua. ");
INSERT INTO wed_vpl VALUES ("R236_22","015_36_22","2CH","36","22","22","Au Persia gulau Sairas ana vibada madeḡana tagogi, ma Bada ana peroveta Jeremiah aiwai i ririweia marina i tupua, Persia ai gulau orana i ravi-dagudagui da i giruma ma i vibabarai ana au vigulau au anatapuna. ");
INSERT INTO wed_vpl VALUES ("R236_23","015_36_23","2CH","36","23","23","Mai Persia ai gulau Sairas, wei i riwei, “Bada, Aidamo ana God, dobu anatapuna vibadana au urau i terei. Ma i vineu da ana Tempol au Jerusalem, Judah au paratana ana voa-melei. Ma taumi aiavoi Bada ana rava, o ḡoeḡoei da ona nae me kampa, lamna anina da ona nae. Ma Bada ami God ina gagaloemi.” ");
INSERT INTO wed_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Mai Israel ai au dobu i mae nawaravi vi7na ma marina taui anatapui i netagogiai au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","Nai maranai Josadak natuna Jeshua ana rava pirisi ḡelaui maiteni, ma Shealtiel natuna Zerubabel ana dam ravai maiteni; pulo aniapuna i voai Israel ana God awarina. Me God ana peroveta Moses, ana Tarawatu i ririweia nanare. ");
INSERT INTO wed_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Avena da taui nai dobuna taumaeni i rovorovoei; wate pulo aniapuna ana au gabu wadubona i voai. Ma i vikarei da ubaubanai ma aubigai patapatana pulo i apuapui Bada awarina. ");
INSERT INTO wed_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Gulau Sairas i riwa da wenanare ita kauei. Taui mane ḡaima taubori ma kamda ravai ita verei. Ma lam, wain ma oil mai Sidon ma mai Tyre ita verei da ai cedar au Lebanon bogei ita towana-neiai au Joppa. ");
INSERT INTO wed_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Ma Madeḡa viruaina nawaravina au viruaina Zerubabel ma Jeshua ma varevarei (pirisi ma mai Levi ma rava ḡelaui maiteni i vivipanipani i nememei au Jerusalem) ma Bada ana Tempol voana i vikarei. Ma Levi ana damei nelara ai madeḡa 20 da nore i ḡeḡae i terei da nola i vibadei. ");
INSERT INTO wed_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Anina ma Mai Israel piripirisi ma dam Levi ravai ma rava anatapui panipaniei i nenememei ana nuaiaii God ana Tempol i vovivirei God voepaepana aubaina. ");
INSERT INTO wed_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Rava anatapui Jerusalem ana au anirui e ḡoreḡorei Samaim, i vitagogiei. Ma taui tarawatu badana Ezra i riwei da Moses ana tarawatu bukana ita neiai, wei tarawatuna Bada mai Israel i verevereia. ");
INSERT INTO wed_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Ma aupom naona au nawaravi au vi-7-na, pulo tauapuna pirisi Ezra tarawatu bukana i neiai patarana i vitagogieina awari, nelarai ma waivinei ma roaroa awari metaui da iava i aramanei. ");
INSERT INTO wed_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Ma Ezra au deba i mairi ma ponana ḡaeḡaenei bukana i ʼavi rava awarii, maratomtomai i vikarei da aubenai ma anatapui i rautaniḡana kaua. ");
INSERT INTO wed_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Ezra vatara au tepana i mairi rava au matai ma maranai buka i votawanei, rava anatapui i vomaimairi. ");
INSERT INTO wed_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Anina ma Ezra Bada God ḡaeḡaena i voepaepai; ma rava urai i voepai ma i paribelei i pa, “Amen, Amen!” Ma i raudune au doa ma Bada i voepaepai. ");
INSERT INTO wed_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","Ma Levi ana dam ravai, bukana rava awari i ʼavi ma i viararamani da taui riwana anona i aramanei. ");
INSERT INTO wed_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Anina ma Gavena Nehemiah, ma pirisi, taugiruma Ezra ma dam Levi ravai, rava awari i viararamana. Marina rava awarii i riwa i pa, “Wei marana tana vovaivivirei Bada ata God awarina. Lamna aubaina eḡa ona vinuabola ma ona tou.” ");
INSERT INTO wed_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Ma Nehemiah i riwa, “Ona nae ami au numa ma ona am kaua ma ona uma-kaua ma rava eḡa ita lauvoa, ona taraiḡuei. Wei marana lamna mara vivivireina Bada awarina. Lamna aubaina Bada ina vinuaiainimi, eḡa ona vinuabola, aubaina Bada ana nuaiai awarimi lamna ami rewapana!” ");
INSERT INTO wed_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Oroto wavana Job au Uz i mae. Tauna rava jijimana kaukauana ma ḡoʼapoapoei i geduaiei. Tauna God i vivirei ma ḡoa aiaii ava i kaukauei. ");
INSERT INTO wed_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Tauna natunatuna nelarai 7 ma waivinei tonuḡa, ");
INSERT INTO wed_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","ma ana sipu 7,000; kamel 3,000; uata bullna 1,000 ma donkey waivinei 500 ma ana taunola maḡamaḡaui. Ma i vipurapura ma i maura kaua eḡa aiai ḡelauna nanare nai au dobuna, au maramatanei. ");
INSERT INTO wed_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Ai mara i tereterei nanare Job natunatuna nelarai nununai ai au numa i toretorela, ma varevarei ma novunovui i rauḡoreiai ma anatapui i amam ma i umauma gogona. ");
INSERT INTO wed_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Aupom biaḡa nanare torela au murina, Job ubaubanai boiboḡi ina vovomairi ma natunatuna nununai ina rauḡoreiai ma epaiai ḡamoḡamo taputapuna ina apuapui Bada awarina da natunatuna ina viaiaini. Tauna i notanota da, “Mepa da roaroa i kauana-boai ma au orai God i parivaiapoapoeni.” ");
INSERT INTO wed_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Marina mara i ḡetai da anela au mara i ḡeta Bada awarina ma tauviwavu - Satan taui i votaḡoi da i ḡeta. ");
INSERT INTO wed_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Bada Satan i paridadanei, “Tam meiei e nenei?” Satan i paribelei i pa, “Tau were ma nare a nenae ma a nenei, dobu a tetetei.” ");
INSERT INTO wed_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Ma Bada i paridadana, “Au taunola Job u inanai bo eḡa? Tauna rava aiaii kaukauana, eḡa aiai ḡelauna au dobu nanare. Tauna rava jijimanina ma patupatutuna. E vivivireiu ma e paipaina-melei da eḡa kaua apoapoe ita kaukauei.” ");
INSERT INTO wed_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Satan i paribelei, “Tam Job e paipaina-kauei lamna aubaina e voepaepaim! ");
INSERT INTO wed_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","Marana patapatai tauna ana numa ravai ma ana purapura e gagagaloei, ma anatapuna uranei e vovodadani e viaiaini, ma bulumakau u verei da wapuna i oai. ");
INSERT INTO wed_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","Wate uram ma viloloi ma anatapuna ḡarinei ma vaitawanei, ma au matam ina parivai apoapoenim.” ");
INSERT INTO wed_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Bada i riwa i pa, “Anina, ana purapura anatapuna au uram a tereterei, wate eḡa tupuana aiwaina ma vodadani.” Ma Satan Bada i netawanei. ");
INSERT INTO wed_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Mara tagogi, Job natunatuna nelarai ma waivinei i toretorela, tuai ana au numa, ");
INSERT INTO wed_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","ma taupariverena i ḡeta Job awarina ma i riwei i pa, “Am taunola burumakauei doa i uauatai ma au ḡereḡerei donkey modu i amam, ");
INSERT INTO wed_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","ma mai Sabea i ruba-ḡairai ma ḡamoḡamo anatapui i kwalei, am taunola anatapui i viraḡena-naiei, ma tau ainelau a ruba da ata pariverem.” ");
INSERT INTO wed_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","I bababani ma taupariverena ḡelauna i ḡetai ma i riwa, “Namanamara marei i ḡairai da sipu ma taupainii i viraḡena-pai, ma tau ainelau a rubai da ata paripariverem!” ");
INSERT INTO wed_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Ravana i bababani ma taupariverena ḡelauna i ruba ḡetai ma i riwa, “Mai Caldia boru tonuḡa ana melaḡina i ḡairai ma am kamel i viaḡaḡana-naiei ma taupainii i viraḡena-pai, tau ainelau a ruba da ata paripariverem!” ");
INSERT INTO wed_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Amapo i bababani ma wate taupariverena ḡelauna i ruba ḡetai ma i riwa, “Natunatum nelarai ma waivinei, natuevou ana au numa i toretorela, ");
INSERT INTO wed_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","ma maratagogi kojikojira mutuluei i opui ma numa i vipeuni au tepai ma anatapui i viaijijini, tau ainelau a ruba da ata pariverem!” ");
INSERT INTO wed_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Anina ma Job i vomairi ma ana kwama i sikai. Kolana i ḡari ma i peu ḡaira au doa ma Bada i voepaepai. ");
INSERT INTO wed_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","Ma i riwa, “Ana kovakovau a nei; ana kovakovau ana nae. Bada i verena ma i vai-melei; Bada wavana ana voepaepai ma ana viborumei.” ");
INSERT INTO wed_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Wei anatapuna au orana, Job eḡa ḡoʼapoapoe aiwaina ita kauei bo God ita viwavui. ");
INSERT INTO wed_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Mara ḡelauna, anela au mara i ḡeta me, Bada awarina ma tauviwavuna - Satan taui i votaḡoi. ");
INSERT INTO wed_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Ma Bada Satan i paridadanei, “Tam meiei e nenei?” Satan i paribelei i pa, “Tau were ma nare a nenae ma a nenei, dobu a tetetei.” ");
INSERT INTO wed_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Ma Bada i paridadana, “Au taunola Job u inanai bo eḡa? Tauna rava aiaii kaukauana eḡa aiai ḡelauna au dobu nanare. Tauna rava jijimanina ma patupatutuna. Ma e vivivireiu ma ḡoʼapoapoe e gedugedaiei. Ana lawana anina jijimanina e maemaeni avena da orau u taini da a kovoḡa labalababai.” ");
INSERT INTO wed_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Tauviwavu Bada i paribelei, “Tauna ana lawana ava e vinuabolei, me rava ana purapura anatapuna ina verenei da eḡa ina kero. ");
INSERT INTO wed_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Wate uram ma viloloi ma tupuana ma ḡelamina ma ravi, ma au matam ina parivai-apoapoenim!” ");
INSERT INTO wed_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Bada i riwei, “Anina, tauna au uram a tereterei wate eḡa ma viraḡeni.” ");
INSERT INTO wed_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Ma Satan Bada i netawanei ma i nae da Job kero apoapoei i verei, au loulouna da i ḡaira au ae lapalapana. ");
INSERT INTO wed_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Ma Job nau gebona i vaia da kerona i kakakaroi ma au lapukare i kiakiala. ");
INSERT INTO wed_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Awana Job i riwei i pa, “Amapo da am lawana jijimanina ma vovojijini bo? God ma parivai-apoapoeni ma ma iraḡe!” ");
INSERT INTO wed_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Wate Job i paribelei i pa, “Tam opaopam! Eḡa nanare ma babani. Tauta God kaua maḡamaḡaui ma aiaii e verevereta, ma apoapoei e paripari-tawaneiai, maiteni tana vaia.” Wei kauai maḡamaḡaui apoapoe Job awarina i tupua, wate tauna ana babani awarinei eḡa ḡoʼapoapoe ita kauei. ");
INSERT INTO wed_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","11","Maranai ana rava tonuḡa riwana i vaia da Job wenanare ma menanare i vinuʼapoapoenei, taui i vitagogiei ma i nae Job ita raugenari ma ita vinuaubai. Taui wavai Eliphas tauna Temanei, Bildad tauna Shuahei ma Zophar tauna Naamah ei. ");
INSERT INTO wed_vpl VALUES ("JB2_12","019_2_12","JOB","2","12","12","Taui tapunei Job i ʼnanai ma i vinuanainei da lamna Job. Maranai i ʼnana-kauei. Taui i vitouana, ma ai kwama i viaisikasikai ma pokau au tepai i tawatawanei. ");
INSERT INTO wed_vpl VALUES ("JB2_13","019_2_13","JOB","2","13","13","Ma aupom ma waguvarai 7 taui au doa i vikiakialei, Job i mae-vereverei. Ma i ʼnanai da ana nuabola i rata guratana ma gamoi i pota ma i kiala genuatau. ");
INSERT INTO wed_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Wiki tagogi au murina Job gamona i laḡi ma ana tupua marana i parivaiapoapoeni. ");
INSERT INTO wed_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","I pa, ");
INSERT INTO wed_vpl VALUES ("JB3_3","019_3_3","JOB","3","3","3","Au tupua marana ma boai, ma waguvaraina i vinolanola da tevera orotona i tupua. ");
INSERT INTO wed_vpl VALUES ("JB3_4","019_3_4","JOB","3","4","4","Nai marana ina waguvarei! Ma God au aidamo wei marana ina nota-tawanei, ma au tepana eḡa ina rarana. ");
INSERT INTO wed_vpl VALUES ("JB3_5","019_3_5","JOB","3","5","5","Waguvara ma gimtona potopotona wei marana ina vibadei; ma lada marana ina purui ma gimtona lalalaina ina purui. ");
INSERT INTO wed_vpl VALUES ("JB3_6","019_3_6","JOB","3","6","6","Gimtona nai waguvaraina ina viamoai wei marana eḡa ma iava-melei; madeḡana bo nawaravina. ");
INSERT INTO wed_vpl VALUES ("JB3_7","019_3_7","JOB","3","7","7","Nai waguvaraina eḡa aiai ina tupua, ma eḡa nuaiai gararana ina nonori. ");
INSERT INTO wed_vpl VALUES ("JB3_8","019_3_8","JOB","3","8","8","Vijiboḡa amamai, mepa da ai vijiboḡa boga bariawana ina vidagui; taui wei marana ina vijiboḡi. ");
INSERT INTO wed_vpl VALUES ("JB3_9","019_3_9","JOB","3","9","9","Maratomtom ubonana ina ḡuvai ma mara karena ina paina-avei ma madeḡa vuduna eḡa ina inanai. ");
INSERT INTO wed_vpl VALUES ("JB3_10","019_3_10","JOB","3","10","10","Aubaina taui manawa metaetana eḡa ita gudui ma vita maḡamaḡaui i vereu. ");
INSERT INTO wed_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","Airake, boiboḡi ita gomuiu! Bo ata i ʼraḡe maranai a tuputupua. ");
INSERT INTO wed_vpl VALUES ("JB3_12","019_3_12","JOB","3","12","12","Aiwai aubaina au arona i vimataveniu ma ḡuḡunei i viḡuḡuiu? ");
INSERT INTO wed_vpl VALUES ("JB3_13","019_3_13","JOB","3","13","13","Maranaina a tupua, matau ita pota; ma ata matave ma ata vilauvitau. ");
INSERT INTO wed_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Ma Eliphas rava Temanei Job i paribelei i pa, ");
INSERT INTO wed_vpl VALUES ("JB4_2","019_4_2","JOB","4","2","2","Job eḡa amlom ina ḡaiḡai ma ana babani, tau ata genuana ava, ana babani! ");
INSERT INTO wed_vpl VALUES ("JB4_3","019_4_3","JOB","4","3","3","Rava maḡamaḡaui u viararamani ma ḡokokokarai u vovaivirewapani. ");
INSERT INTO wed_vpl VALUES ("JB4_4","019_4_4","JOB","4","4","4","Riwam, rava peupeui u duḡui, ma ae tutui viviarai u duḡui. ");
INSERT INTO wed_vpl VALUES ("JB4_5","019_4_5","JOB","4","5","5","Wate marina nuabola i nei awarim, ma am nota i peu i vodadanim ma u rovo-kaua. ");
INSERT INTO wed_vpl VALUES ("JB4_6","019_4_6","JOB","4","6","6","Am vitumaḡana God awarina, ma am lawana jijimanina. Lamna, am rewapana, tapa? ");
INSERT INTO wed_vpl VALUES ("JB4_7","019_4_7","JOB","4","7","7","Ma tumairi ma ma vinua notanota! Rava jijimani e irairaḡe bo? Mara aiwai rava jijimani i kero ma iʼraḡe? ");
INSERT INTO wed_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","A inanai rava ḡoa apoapoe i paewi ma nuabola i tuarui. ");
INSERT INTO wed_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Ma Bada labu au orana ma Job i paribelei, i pa, ");
INSERT INTO wed_vpl VALUES ("JB38_2","019_38_2","JOB","38","2","2","“Tam aiai e bababani labalababa, ma au nuaulaula e paripari-virevirei? ");
INSERT INTO wed_vpl VALUES ("JB38_3","019_38_3","JOB","38","3","3","Ma mairi jijimana me oroto, ana vitaravirevirem ma ma paribeleu! ");
INSERT INTO wed_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","Tam mepa maranai dobu tuatuana i tonei? Ma riweu, mepa da u aramanei? ");
INSERT INTO wed_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","Aiai dobu ana manawa ma ana dabora i terei? U aramanei tapa? Ma aiai i ruvai? ");
INSERT INTO wed_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","Aiwai dobu tuatuana e vovojijini? Ma aiai dobu tuatuana i tonei, ");
INSERT INTO wed_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","maranai maratomtom ubonai i wela tagogi, ma Bada ana anela ana morelanai i voepaepa ma i vigaragaraei? ");
INSERT INTO wed_vpl VALUES ("JB38_8","019_38_8","JOB","38","8","8","Aiai boga ana au parata i terei maranai boga manawana ana goba i wanaiwaḡi?” ");
INSERT INTO wed_vpl VALUES ("JB40_1","019_40_1","JOB","40","1","1","Ma Bada Job i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("JB40_2","019_40_2","JOB","40","2","2","“Tam, God Vivirewapana Kaukauana e viviwavui; Aiai God e viviwavui, ina paribelei.” ");
INSERT INTO wed_vpl VALUES ("JB40_3","019_40_3","JOB","40","3","3","Anina ma Job Bada i paribelei, ");
INSERT INTO wed_vpl VALUES ("JB40_4","019_40_4","JOB","40","4","4","“Tau rava labalababa, menanare ana paribelananem? Gamou ina pota. ");
INSERT INTO wed_vpl VALUES ("JB40_5","019_40_5","JOB","40","5","5","Boiboḡi a babani guratana. Eḡa aiwai ḡelauna ana latoni.” ");
INSERT INTO wed_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Ma Job i babani me, i pa ");
INSERT INTO wed_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","“Tau a aramanei da tam aiwai anatapuna e kaukauei; Eḡa aiai am oga ina viḡaei. ");
INSERT INTO wed_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","U paridadaneu, ‘Tam aiai e bababani labalababa, ma au nuaulaula e pari-virevirei?’ Riwa kaua am boruma vivinualaulaunana eḡa ata aramanei, da a voḡana guratana.” ");
INSERT INTO wed_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","“U riweu, ‘Ma rautaniḡana, ma ana babani, Ana paridadanem ma tam ma paribeleu.’ ");
INSERT INTO wed_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Taniḡau ava riwam i nonori Wate marina matau i ʼnanaim. ");
INSERT INTO wed_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","A vinimala, ma au lapukare ma au debidebi ana kiala. A ruperupena ma a mae-tavireu awarim ma au ḡoʼapoapoe ma nota-tawanei.” ");
INSERT INTO wed_vpl VALUES ("JB42_7","019_42_7","JOB","42","7","7","Bada i babani vorovei Job awarina ma marina Eliphas rava Temanei awarina ina pa, “Amlou i ḡaiḡai awarim am rava ruaḡa maiteni, taumi eḡa riwa kaua ota babaniei me Job nanare. ");
INSERT INTO wed_vpl VALUES ("JB42_8","019_42_8","JOB","42","8","8","Lamna aubaina, bull 7 ma sipu ororotoi 7 ona vaia ma ona nae au taunola Job awarina ma siai taputapuna ona apui awariu. Tauna aubaimi ina raupari ma ana pari ana nonori da eḡa ana vinimalaimi ami kaua apoapoei aubaina. Taumi eḡa riwa kaua ota babaniei me au taunola Job nanare.” ");
INSERT INTO wed_vpl VALUES ("JB42_9","019_42_9","JOB","42","9","9","Anina ma Eliphas, Bildad ma Zophar Bada aiwai i ririweia nanare i kauei, ma Bada Job ana pari i nonori. ");
INSERT INTO wed_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Ma maranai Job i raupari-vorovei, Bada ana maura i veremelei ma raviai-tepatepani. ");
INSERT INTO wed_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Varevareina ma novunovuna ma ana rava waduwaduboi i nei ana au numa ma maiteni i am ma i uma gogona. Ma Job i vinuaubai aubaina Bada vita ḡaeḡaena Job i verei. Ma taui anatapui kampa i ḡeḡeta mane ma loji goldei Job i verei. ");
INSERT INTO wed_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Bada, Job i viaiaina-kauei eḡa me au naonei. Awarina sipu 14,000; kamel 6,000; uata bullna 2,000 ma donki waivine 1,000. ");
INSERT INTO wed_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Ma nanare, natunatuna nelarai seven ma waivinei tonuḡa. ");
INSERT INTO wed_vpl VALUES ("JB42_14","019_42_14","JOB","42","14","14","Natuna wavinena magurina wavana Jemimah, ma keikeina wavana Keziah ma vitonuina Keren-Hapuk. ");
INSERT INTO wed_vpl VALUES ("JB42_15","019_42_15","JOB","42","15","15","Job natunatuna guguinii inanai i ai dewadewa eḡa me guguini ḡelaui nai au dobuna. Ma Job natunatuna nelarai ma waivinei ai buderi i terei da anatapui ruvana tagogina ina vaia. ");
INSERT INTO wed_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","Job i mae madeḡa 140 ḡelauna; da ḡoḡoḡana ma nonoina da i nae kimta au vi-4-nainanai. ");
INSERT INTO wed_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Anina ma i magura kaua ma iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Rava viaiainana, lamna eḡa ḡoʼapoapoe ravai ita votaḡotaḡoi, ma ponai eḡa ita rarautaniḡanei; ma vivijiboḡai eḡa awarii ita kiakiala. ");
INSERT INTO wed_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Wate Bada ana tarawatu i vinuaiaiei, aupom ma marai e notanota-vaitetei. ");
INSERT INTO wed_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Tauna me ai, waira au adana gogogona, ana au mara e rarauano; ma rugurugui eḡa ita poipoi. Wei ravanana, aiwai anatapuna e kaukauana-kauei. ");
INSERT INTO wed_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Wate ḡoʼapoapoe ravai eḡa nanare! Taui me rugurugu, ive i kapupuana-naiei; ");
INSERT INTO wed_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Lamna aubaina ḡoʼapoapoe taukauei Bada ana au etera ita mairi ava, ma nanare ḡoa apoapoei ta kauei rava jijimani ai au dam ita mae ava. ");
INSERT INTO wed_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Bada ḡoa aiaii ravai e rarauetaraveni ma e paipaini; wate ḡoʼapoapoe ai etanai au damona, pupui. ");
INSERT INTO wed_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","David ana wela Bada taupainiu ma eḡa aiwai ana voladaḡei. ");
INSERT INTO wed_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Gidagida majimajiḡai au tepana i vimataveniu, ma i raveniu waira au raraunairina au adana. ");
INSERT INTO wed_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Au rewapana e raviravivouni ma wavana aiaina aubaina etanai jijimaninei i raveniu. ");
INSERT INTO wed_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Avena da gwagwa waguwaguvareina ana naeni, wate eḡa aiwai apoapoena ana rovoei. Aubaina tam au ririvau da am kwapuei ma jiḡonei e gagagaloeu ma e vivinuaubaiu. ");
INSERT INTO wed_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Aubaiu torela e vokaukauei au ḡavia au naoi. Oilei kolau u volaḡolaḡoi da tam u vinuavaineu, ma au kelaka i oa-karagelai. ");
INSERT INTO wed_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ee! Riwa kaua da am iviaiai ma am raunuapoapoe maemae nonoana awariu ina mae, da au mara au damona. Ma Bada ana au numa ana mae-nonoa. ");
INSERT INTO wed_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","David ana wela Bada au lalalaina ma au tauvilawana, aiwai ana rovoei! Bada au taugagagalo aiwai ana rovoei!");
INSERT INTO wed_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Maranai ḡoʼapoapoei ravaii i ḡetai da ita vunuiu, au ḡavia aei ina pakana-melei da ina peu.");
INSERT INTO wed_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Avena da sorodia borui ina mae-gariḡuruviu, tau eḡa ana rovo dadana. Maranai au ḡavia i vomairi, tau anina da God ana vivitumaḡanei.");
INSERT INTO wed_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Kaua tagogi ava aubaina a vivibaḡa. Au ḡoana ḡaeḡaena da, Bada ana au numa, boruborumana ana mae, ma ana voepaepai. Au lawana au anatapuna.");
INSERT INTO wed_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Nuabola au marana ina tereḡaḡariu. Ana gabu au vivivireina, ina teregovaḡiu. Ma ola au tepana ina tereu da ḡavia eḡa ina vodadaniu.");
INSERT INTO wed_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Ma au ḡavia i garigari kwaipipiniu, ana tuvaidoedoei. Da au tempol ana morelanau pulo ana apui Bada awarina. Ana vinuaiai ma welei ma arei ma ana voepaepai.");
INSERT INTO wed_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Bada ma rautaniḡaneu maranai awarim a kwatukwatu, ma raunuʼapoapoleu ma ma paribeleu.");
INSERT INTO wed_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Au orau u riwa, u pa, “Ma nei da ma rauduneleu.” Tau a paribelem a pa, “Bada a nenei.”");
INSERT INTO wed_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Eḡa ma raugovaḡeu, eḡa awariu ma ḡaiawa. Am taunola eḡa ma inana geduaiei, au anatapuna tam, au tauagu. Eḡa ma netawaneu, au God, tam au tauvilawana.");
INSERT INTO wed_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Avena da amau ma alou ita teretawaneu, wate Bada ina paina-kaueu.");
INSERT INTO wed_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Bada, ma viararamaniu da am ḡoana ana kauei. Ma etanai au ḡadaḡadarana ma taravainiu aubaina au ḡavia i maḡa");
INSERT INTO wed_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Taui moruei ma parivairovorovoei e vunuvunuiu. Lamna aubaina, eḡa ma teretawaneu awarii");
INSERT INTO wed_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","A ʼramanei da Bada ana viaiaina ana inanai, weka lawalawai ai au dobu.");
INSERT INTO wed_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Bada ma vitumaḡanei, da ma virewapana ma tepam ina tora. Anina Bada ma vitumaḡanei! ");
INSERT INTO wed_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Bada ana vimaeḡaeḡaeni marana patapatai, ma ana viborumana-nonoei.");
INSERT INTO wed_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Orau taputapuneiBada ana voepaepai; Vilamolamonai riwau ina nonori ma ina vinuaiai.");
INSERT INTO wed_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Ona nei ata Bada tana vimaeḡaeḡaeni wavana tana voepae-gogonei.");
INSERT INTO wed_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","A raupari Bada awarina ma i paribeleu, awariu rovo anatapui i vaitawanei.");
INSERT INTO wed_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Aiavoi awarina e inainana, taui naoi ina ravilalai ma eḡa melanai ina vitepa-ubaubai.");
INSERT INTO wed_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Au nota i kwa da a ḡorei, ma i nonori ma nuabola au orau i vaitawanei.");
INSERT INTO wed_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Aiai da Bada e vivivirana-kauei, ana anela taui e inana-vaitetei, ma e vivilawani.");
INSERT INTO wed_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Taumi ona raudadani ma ona aramanei da Bada i aii. Taui Bada au ḡouna maemae nuaiai ḡaeḡaena awari.");
INSERT INTO wed_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Taumi vivitumaḡanami eḡa aiwai ona voladaḡei. Lamna aubaina, Bada ona vivirei.");
INSERT INTO wed_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Lion ḡauboi mara ḡela am e irairaḡe, wate aiavoi da Bada awarina e vitumaḡana eḡa ina voladaḡa.");
INSERT INTO wed_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Natunatu, ona nei, ona rautaniḡana, ma ana viararamanimi da Bada ona vivirei.");
INSERT INTO wed_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Taumi o ḡoei da ami lawana ina aii ma ina manawa bo?");
INSERT INTO wed_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Nanare, lamna menami ona paina-melei da eḡa babani apoapoe bo moru ona babaniei.");
INSERT INTO wed_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ḡoa apoapoe ona geduaiei ma kaua aiaii ona kaukauei, ma ona voguratei da nuauba lawanana ona maeni.");
INSERT INTO wed_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Bada, matana ḡoa aiaii ravai awari e tereterei, ma taniḡana e tonetonei mepa da agu e toutouei.");
INSERT INTO wed_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Wate tauna ḡoʼapoapoei ravai e mamae-puputei taui ina iraḡe ma rava nuanuai ina vuru.");
INSERT INTO wed_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Rava jijimanii agu aubaina e viviḡoreBada awarina tauna e rarautaniḡana ma ai vita e vaivaitawanei.");
INSERT INTO wed_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Tauna rava peupeui, rovorovoi, ma vinuabolai e vivilawani, tauna rava orana i peu kaua e vovoepai.");
INSERT INTO wed_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Rava jijimanii ai nuabola i maḡa wate Bada taui e vovoagui ai au nuabola.");
INSERT INTO wed_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","E inainana-vaitetei da eḡa gelamina tagogi ina wanagai.");
INSERT INTO wed_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Ḡoa apoapoe ravai ai apoapoe ina vunumelei, ma aiavoi da ḡoa aiaii ravai e gedugeduaiei, ina kovoḡi.");
INSERT INTO wed_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Bada ana taunola e gagagaloei, aiai da e nenei Bada au ḡouna, kovoḡa ina vorei. ");
INSERT INTO wed_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Mara tagogi, Gulau David ana taunola Uriah awana Bathsheba i tavimatanei da maiteni i matave. Oo God, ma raunuʼapoapoeleu. Tam nuavaina maemae-nonoana amai. Tam raraunuapoapoei amai au ḡoʼapoapoe ma notatawanei. ");
INSERT INTO wed_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Au rauaḡaiḡai ma oḡai ma au ḡoʼapoapoe ma oḡa-tawanei. ");
INSERT INTO wed_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Au rauaḡaiḡai a aramanei marana patapatai a notanotai. ");
INSERT INTO wed_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Kaua apoapoei a kauei. Tam ainelam awarim Ḡoa apoapoei a kauei, ma am viwavu lamna riwa kaua. Amapo anina da ma kovoḡiu. ");
INSERT INTO wed_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Tau rauaḡaiḡaiu, melamelauei da marina Au manawa da marina tau ḡoʼapoapoe taukaueina. ");
INSERT INTO wed_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Wate tam u ḡoei da riwa kaua au ora-dewadewau ina mae. E viviararamaniu da nuaulaula orau ina oai. ");
INSERT INTO wed_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Au ḡoʼapoapoei ma oḡa-tawanei, ma oḡaiu da ana arapoira da gonu rovena arapoirana ana ḡetawanei. ");
INSERT INTO wed_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ma riweu da au ḡoʼapoapoe u nota-tawanei da ana vinuaiaii ma ana morelana avena da gelamiu u viaigaigai, marina ana vinuaiai. ");
INSERT INTO wed_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Au goʼapoapoe ma inana-tawanei ma au apoapoe mirai ma boai. ");
INSERT INTO wed_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Oo God nuanua ma ravivouni da ana vipatutu kaua awarim. ");
INSERT INTO wed_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Eḡa au naom ma tawana-opuneu ma awariu eḡa Aruam Vivivireina ma vaitawanei. ");
INSERT INTO wed_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Vilawana nuaiaina ma ravivouni me au naona nanare aruau ma viaiaini da ana voteletelem. ");
INSERT INTO wed_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Lamnei, ḡoʼapoapoei taukauei am kaua ana viararamani, da ina mae-tavirei awarim. ");
INSERT INTO wed_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Oo God, viʼraḡena vitana awariu ma vaitawanei, da am kaua jijimanii ana welei. ");
INSERT INTO wed_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Oo Bada ipiriu ma votawanei da gamou ina vimaeḡaeḡaenim. ");
INSERT INTO wed_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Au pulo, ḡamoḡamo ata apui awarim, wate tam pulo apuapunana eḡa uta vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Bada, pulo e ḡoeḡoei lamna vilamolamona. Bada, eḡa au vilamolamona ma au rupena ma geduaiei! ");
INSERT INTO wed_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Am nuavaina Jerusalem ma viaiaini, ma ana gari ma voa-melei. ");
INSERT INTO wed_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Anina ma ai pulo nota aiainei ina vikarena-melei da ina kaukauei ma ma vinuaiaiei. Taui pulo tapuna ma tapuna ina apui awarim. Bull maḡamaḡaui am au aniamapu ina apuapui. ");
INSERT INTO wed_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Oo God ma raunuʼapoapoelelai ma ma viaiainiai, ma naom weka ma tereiai da ma voaguiai! ");
INSERT INTO wed_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Da au dobu am kaua ina aramanei, da rava anatapui au dobu ina aramanei da tam ai tauvilawana. ");
INSERT INTO wed_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Rava ina voepaepaim Oo God, rava anatapui ina vimaeḡaeḡaenim. ");
INSERT INTO wed_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Rava anatapui au dobu ina vinuaiai ma ana morelanai ina wela, aubaina tam rava anatapui au dobu, kaua jijimaninei e vivibadei ma e paipaini. ");
INSERT INTO wed_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Rava ina voepaepaim Oo God. Rava anatapui ina voepaepaim. ");
INSERT INTO wed_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Anina ma doa maura ḡaeḡaena ina vereta ma God ina viaiaina-kaueta ");
INSERT INTO wed_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Riwa kaua, God ina viaiainita ma rava anatapui au dobu tauna ina vivirei. ");
INSERT INTO wed_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Bada ai animae kimta wariaḡa da marina. ");
INSERT INTO wed_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Tam God maemae nonoana muriai da ola ma dobu uta kauei. ");
INSERT INTO wed_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Tam rava e ririwei da e vipokau, ma e ririwei, “Rava ona wanaviraimi” ");
INSERT INTO wed_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Tam awarim madeḡa 1,000 lamna me aupom tagogi, i tupo kaua me raviravi, eḡa ita manawa dadana. ");
INSERT INTO wed_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Rava ai lawana e vaivaitawanana laḡilaḡinei me rauboni damona. Taui me modu, ubaubanai e raraupairei, ");
INSERT INTO wed_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","da e rarata ma e talatalai, wate aubigai e ḡiviḡivi. ");
INSERT INTO wed_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Nanare am meji tauai e lagulaguriai ma maranai e ḡaiḡaiawa tauai a rovorovo kaua. ");
INSERT INTO wed_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ai ḡoʼapoapoe anatapui au naom u lavaei, ai ḡoʼapoapoe govagovaḡana, wate anatapuna e inainanai. ");
INSERT INTO wed_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Am meji ai lawana i vitupoi, ma ai madeḡa laḡilaḡina e kwakwa, a lavutu-tawanana. ");
INSERT INTO wed_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Madeḡa 70 i vereta da tana mae, mepa da tana virewapana lamna 80; Wate wei lamna nuabola ava ina vereta, eḡa tana mae-pora ma tana nae. ");
INSERT INTO wed_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Eḡa aiai am ḡaiawa malana ita vai-kauei. Mepa da am ḡaiawa ata aramana-kauei, lamna tauai ata vivirana-kauem. ");
INSERT INTO wed_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Ma nanare, ma viararamaniai da ai lawana i tupo kaua, ma lamna aubaina awarim nuaulaula ana vaia. ");
INSERT INTO wed_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Oo Bada! Ma nememei awariai. Ma mae-tavirem, ma vinuabolelai, tauai am taunola. ");
INSERT INTO wed_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Ubaubanai marana patapatai am nuavaina maemaena ma verelai, da ana morelanai ana logoiai ma ai au mara anatapuna ana vinuaiai. ");
INSERT INTO wed_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Madeḡa biaḡa u kovoḡiai, nuaiai ma verelai da madeḡana biaḡa a vinuapoapoe ina kovoḡi. ");
INSERT INTO wed_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Tauai am taunola, am nola vivirewapanana ma viatataielai. Ma natunatuiai am boruma ma viatataiei. ");
INSERT INTO wed_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Ma Bada ata God ana vianina ina viatataieta ma ina kauei da aiwai anatapuna ta kaukauei anona ina tupua. Nanare ai nola ma viuai. ");
INSERT INTO wed_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Aiai ravana e nenae Aidamo Telarana awarina agu aubaina, lamna Vivirewapanana Kaukauana au ririvana ina mae. ");
INSERT INTO wed_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Bada au God awarina ana riwa ana pa, “Tam au anigagalo ma au tauviḡavia. Tam au God, a vivitumaḡanem.” ");
INSERT INTO wed_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Aubaina tauna, ḡavia ana waro govagovaḡai ma numa rarauabubu awarinei ina gagaloemi. ");
INSERT INTO wed_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Tauna papenenei ina tereḡovaḡimi ma papena au gabaurina ina gagaloemi; ana vipatutu, am rawena ma am anigagalo. ");
INSERT INTO wed_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Waguvara kauai viʼni-rovorovoi eḡa ona rovoei, bo ḡavia madeḡai e viviḡavia, ");
INSERT INTO wed_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","bo numa rarauabubu waguvara e viviḡavia, bo doria madeḡai e viviraḡena. ");
INSERT INTO wed_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Avena da rava tausan au ririvam i peu, bo ten tausan au oiem i peu; wate tam ita vodadana-avem. ");
INSERT INTO wed_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Matamiei ona inana ma ona inanai ḡoʼapoapoe ravai ai kovoḡa. ");
INSERT INTO wed_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Aubaina Bada o vaia ami rawena; Ḡetelarana ami taugagalo. ");
INSERT INTO wed_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Eḡa aiwai apoapoena awarimi ina tupua bo au numa ina ḡeta. ");
INSERT INTO wed_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","God ana anela ina terei da ina painimi ma ina gagaloemi ami au babara. ");
INSERT INTO wed_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Taui uraiei ina voepaim da aem eḡa ḡaima au tepana ma rauei. ");
INSERT INTO wed_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Taumi lion ma mota ona vovaiubai, lion ḡaiḡaiawai ma mota viviwaiawai ona tugwadagwadai. ");
INSERT INTO wed_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","God i riwa i pa, “Aiai nuanuau e vaivainonoei, ana vilawani; ma ana gagaloei, aubaina i aramana-kauei. ");
INSERT INTO wed_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Maranai i kwatu awariu, ana paribelei. Tau kampa ai au nuabola, ana taravaini ma ana voepaepai. ");
INSERT INTO wed_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ai lawana ana vimanaini, ma au vilawana mamae-nonoana ana viatataiei.” ");
INSERT INTO wed_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ona nei! Tana wela Bada awarina. Ana nuaiaita tana wela God ata tauvilawana vivirewapana awarina. ");
INSERT INTO wed_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Tana nei au naona ma tana viegualauei ma welei tana voepaepai. ");
INSERT INTO wed_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Aubaina Bada lamna God virewapana kaukauna, ma god anatapui e inainana-ḡairei. ");
INSERT INTO wed_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Dobu anatapuna au urana, guba ḡaeḡaei doa au orana da ola ḡaeḡaei au tepai. ");
INSERT INTO wed_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Boga tauna ḡarinei, tauna i kauei ma nanare tauna uranei dobu alalana i tere-kauei. ");
INSERT INTO wed_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ona nei ma tana raudune ma tana vimaeḡaeḡaeni, ae tututa tana tapeḡaroei taukaueta Bada awarina. ");
INSERT INTO wed_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Aubaina tauna ata God. Tauta natunatuna. Ana sipu ma e ḡamoḡamoita ana au wapu. Mepa da ponana o nonori amadodo, ");
INSERT INTO wed_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","E riwei i pa “Eḡa orami ona gudui me amamami au Meribah; me au mutulua au Massah. ");
INSERT INTO wed_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Kampa amamami i ʼnanai, kauababai a kauei wate eḡa ita vitumaḡaneu, ma i raudadaniu. ");
INSERT INTO wed_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Madeḡa 40 wei kimtana awari amlou i ḡaiḡai ma a riwa, ‘Wei ravai orai i bagibagi ḡaḡa! Eḡa ita rarautaniḡaneu.’ ");
INSERT INTO wed_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Ana mejiu a parivainuaḡani, ‘Gabu a vokaukauei ami lauvitau aubaina wate kampa eḡa melanai ona rui.” ");
INSERT INTO wed_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Rava anatapumi au dobu ona logoimi Bada awarina!");
INSERT INTO wed_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Ana nuaiaimi Bada ona voepaepaei, ona nei au naona ma ona welei.");
INSERT INTO wed_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Ona aramanei da Bada anina God. Tauna i kaueta. Ma tauta tauna ḡarinei. Tauta tauna natunatuna. God ana sipu ma e gagaloeta me sipu taupainina.");
INSERT INTO wed_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Ana welami ana au gari ona rui ma voepaepami ana au aniviboru ona rui, ma ona vimaeḡaeḡaeni.");
INSERT INTO wed_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Aubaina Bada i aii; natunatuna e vivinuavaina-nonoei, ana vipatutu e mamae-nonoa, kimta au anatapui. ");
INSERT INTO wed_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","David i girumi Orau taputapunei Bada ana voepaepai. Wavana vivivireina ana voepaepai. ");
INSERT INTO wed_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Orau taputapunei Bada ana voepaepai, kaua aiaii i kauei aubaiu eḡa nuanuau ina vuru. ");
INSERT INTO wed_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Au ḡoʼapoapoe anatapui e notanota-tawanei, ma doria awarinei e vivilawaniu. ");
INSERT INTO wed_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Ata iraḡe ma i sinaepaiu ma nuavainei ma raunuapoapoelei e vivigulaueu. ");
INSERT INTO wed_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Au lawana au anatapuna purapura aiaii avai i verevereu, au vilaraga marana i raviravivouni me manubada. ");
INSERT INTO wed_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Bada ana kaua anatapuna jijimanina. ");
INSERT INTO wed_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Ana oga Moses i viatataiei, ma mai Israel Bada ana kaua vivirewapanai i ʼnanai. ");
INSERT INTO wed_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Bada raraunuapoapoena ma ivina aiaina, Eḡa laḡilaḡina amlona ita voḡaiḡai. Ana nuavaina maemae-nonoana. ");
INSERT INTO wed_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Eḡa mara nonoa ina enita, ma ana amloḡaiḡai eḡa ita mamae-nonoa. ");
INSERT INTO wed_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Anina da ita kovaḡa-kaueta, wate i raunuʼapoapoeleta da kovoḡa eḡa ḡaeḡaena ita verevereta. ");
INSERT INTO wed_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Dobu weka ma mara nore au tepadewadewana. Nanare, Bada ana nuavaina i rata guratana taui da Bada e vivivirei awarii. ");
INSERT INTO wed_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Mepa madeḡa e gogogolana da mepa e ḡaiḡairalana, lamna uama, ma nanare ata ḡoʼapoapoe vinimalana e vaivaitawana-naiei aueia. ");
INSERT INTO wed_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Me ama natunatuna e rarau-nuapoapoelei, nanare Bada natunatuna e rarau-nuapoapoelei. ");
INSERT INTO wed_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Aubaina i aramanei da tauta pokauei i kaueta. ");
INSERT INTO wed_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Ata mara au dobu lamna me modu. Ta gogogo ma ta rarata me berana moduei; ");
INSERT INTO wed_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Anina ma ive i uvena-kapupuei, eḡa ita mamae, ana gabu i kwakwava. ");
INSERT INTO wed_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Taui da Bada e voepaepai ana nuavaina maemae-nonoana awarii ma nanare noinoii ma ai epaepaia awarii ");
INSERT INTO wed_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","taui aiavoi da ana parivainuaḡana bagibagina e vovojijini ma ana patupatutui tarawatu e vovojijini. ");
INSERT INTO wed_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Bada ana vigulau anikialana au mara i terei, ma kampa ana vigulau e vivibadei. ");
INSERT INTO wed_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Bada ana anela, vivirewapanami, Bada riwana o rarautaniḡanei ma o kaukauei, Bada ona voepaepai. ");
INSERT INTO wed_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Anina Bada ana anela marei, Bada ona voepaepai taumi ana taunola ma ana ḡoana anatapuna o kaukauei. ");
INSERT INTO wed_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Taumi anatapumi Bada uranei i kauei, ana au vigulau maemaei, Bada ona voepaepai. Tau nanare orau taputapunei Bada ana voepaepai. ");
INSERT INTO wed_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","David ana wela Bada au bada wenanare i riwei, “Au oieu ma kiala da am ḡavia au ae karem ana terei da ma tuvaidoedoei.” ");
INSERT INTO wed_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Bada, am gabemani vivirewapanana Zion ana parata ina viratai, da am ḡavia ma vibadei. ");
INSERT INTO wed_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Am laraga ana nuaii ina verena-melei da ina visorodia, ma ona ḡae Bada ana ola au tepana viḡavia aubaina, ma ami rewapana ina ravivouni ubaubanai patapatana me ubaubanai turuvanina. ");
INSERT INTO wed_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Bada i parivainuaḡanim ma eḡa nuanuana ina virai; “Tam pirisi maemae nonoana me Melkisedek.” ");
INSERT INTO wed_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Bada au oiem e maimairi da e paipainim; tauna gulagulau ina piaḡi maranai amlona ina ḡaiḡai. ");
INSERT INTO wed_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Dobu nununai ai ḡoa apoapoe ina kovoḡi, ma taubeu dobuna ina vioai ma dobu gulagulaui anatapui kolai ina viaigwadagwadai. ");
INSERT INTO wed_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Wate au etanai au vuvura ina uma ma rewapana ina verei ma ina vovaiuba. ");
INSERT INTO wed_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Rava vouna menanare lawana aiaina ina maeni? Tauna riwamei ina paina-melei. ");
INSERT INTO wed_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Lamna aubaina a baibaiem orau taputapunei; eḡa ma votereu da riwam ana geduaiei. ");
INSERT INTO wed_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Riwam a iaiavi ma au nuanuau a tereterei, da eḡa ḡoʼapoapoei awarim ana kauei. ");
INSERT INTO wed_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Bada, a voepaepaim! Am tarawatu ma viararamaniu. ");
INSERT INTO wed_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Ipiriuei ana bababani ma am tarawatu anatapui u verevereiu ana jimei. ");
INSERT INTO wed_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Am tarawatu votelatelana a vinuaiainana-kauei, eḡa me vipurapura bo vimane. ");
INSERT INTO wed_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Riwam ana iavi ma ana vinuanotenotei. ");
INSERT INTO wed_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Am tarawatu a vinuaiaina-kauei, eḡa riwam ana voteretawanei. ");
INSERT INTO wed_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","David ana wela Bada orau u inanai ma au kaua anatapui u aramanei. ");
INSERT INTO wed_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","U aramanei mara aiwai a kiala ma a vomairi. Avena au uama wate au nota e araramanei. ");
INSERT INTO wed_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","E inainanaiu maranai a babara bo au numa a vivilauvitau. Anatapuna a kaukauei e araramanei. ");
INSERT INTO wed_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Muriai da ata babani tam e araramanei aiwai ana latoni. ");
INSERT INTO wed_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Tam e garigari-kwaipipiniu, ma uram virewapananei e paipainiu. ");
INSERT INTO wed_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Lamna riwa kauana, awariu i aii kaua ma i ḡe-dewadewa da kolau i kwauna-kauei. ");
INSERT INTO wed_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Mepa ana nae da Aruam ana raugovaḡei? Mepa ana ruba da ana raugovaḡem? ");
INSERT INTO wed_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Ata ḡae au mara da tam kampa; mepa da i ʼrairaḡei ai au dobu ata rauviraiu, tam kampa. ");
INSERT INTO wed_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Mepa da ana lave nae au maramatanei, bo mepa madeḡa e neneulai, ");
INSERT INTO wed_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","avena kampa ma uram ina raveniu, ma am rewapana ina painiu. ");
INSERT INTO wed_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Mepa da ana riwa, “Gimtona ina tereḡovaḡiu ma lalalaina ina gimtona.” ");
INSERT INTO wed_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Wate avena da gimtonana amapo eḡa ana raugovaḡem. Tam awarim gimtona ina rarana me marai, aubaina tam awarim gimtona ma lalalaina lamna tagogina. ");
INSERT INTO wed_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Tam tupuau anatapuna u voai da alou au manawana u teretagogieu. ");
INSERT INTO wed_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","A viviegualauem aubaina tam am nuavainei ma am borumei u voa-kaueu! Am rauḡaroḡaro i aii, A voepaepaim aubaina a aramana-kauei. ");
INSERT INTO wed_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Tam u vivineneḡaneu maranai a tuputupua au govagovaḡana, alou au manawana, tam ainelam anatapuna u aramanei. ");
INSERT INTO wed_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Tam u inanaiu muriai da a tupua. Aupom biaḡa u vereu da ana mae lamna au buka u girumi, muriai da aupom naona i ḡotai. ");
INSERT INTO wed_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","God! I piripiri guratana da am nota ana aramanei. Am nota kolau i kwauni, eḡa aiwai ḡelaunei am kaua ana aramanei. ");
INSERT INTO wed_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","I maḡa guratana eḡa me bubu, iavana ana kauana-avei, avena da ata iava-pai, tau amapo da tam ana vivinuanainem. ");
INSERT INTO wed_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Oo God! A ḡoei da ḡoʼapoapoei ravai uta viraḡeni. Tauviraḡena uta viaḡaḡei da eḡa ina nei awariu. ");
INSERT INTO wed_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Aubaina e vivijiboḡim, ma wavam eḡa ita vivivirei. ");
INSERT INTO wed_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Bada, rava e gedugeduaiem, tau ravai a gedugeduaiei. Taui eḡa ita voteletelem lamna aubaina taui au ḡavia. ");
INSERT INTO wed_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Taui a geduaiana-kauei, anina taui au ḡavia. ");
INSERT INTO wed_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Ma tuvirevireu, ma orau ma inana-pai. Ma raudadaniu da nuanuau ma aramanei. ");
INSERT INTO wed_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Mepa da ḡoa apoapoe au orau, ma viatataieu, ma ma raveniu etanai e nenae au lawana maemae-nonoana awarina. ");
INSERT INTO wed_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Bada vivirana, lamna aramana karena, Wate opaopai, nuaulauala ma aramana e gedugeduaiei. ");
INSERT INTO wed_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Natu, amam ma alom ai vinuaterena anatapui ma voteletelei. ");
INSERT INTO wed_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Ai vinuaterena lamna me kunuteia au kolam, bo gadogado au uam da inanam ina ai. ");
INSERT INTO wed_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Wavine matana maḡamaḡauna ma ruba-tawanei! Eḡa ma nae dadana ana au metaeta! ");
INSERT INTO wed_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Mepa da nanare lamna rava eḡa ina vivivirem. Tam am vilaraga ma am lawana aiaina ma vitupoi. ");
INSERT INTO wed_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Bada rava ai kaua anatapui e inainanai, Metauna etanaina e vaivaia, tauna kampa da e inana-vaitetem. ");
INSERT INTO wed_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Taniḡapota ravana ana ḡoʼapoapoelei ina waro-melei. Ana ḡoʼapoapoe tauna ina tupajijini. ");
INSERT INTO wed_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Tauna opaopana ma eḡa ita paina-melei, Ana kaua opaopai aubaii iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Natu, amam ma alom ai vinuaterena anatapui ma voteletelei. ");
INSERT INTO wed_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Ma vojijina-kauei au nuanuam; marana patapatai au uam ma gadoi. ");
INSERT INTO wed_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Maranai e bababara, ai vinuaterena am etanai ina rauḡadaḡadari. Maranai e matamatave, ai vinuaterena ina matave-painim. Maranai u vomairi, ai vinuaterena awarim ina babani. ");
INSERT INTO wed_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Aubaina wei tarawatui lamna rampa. Wei viararamana lamna ravilala, etanaina e lalalai. Nuaterena bagibagina lamna lawana aiaina etanaina. ");
INSERT INTO wed_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Taui ina aguim da wavine matai maḡamaḡaui ma vorei, ma wavine tavitavinena ana gwalameru. ");
INSERT INTO wed_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Eḡa wavinena inana aiaina ma erawei. Eḡa! Ma voterei da matanei oram ina taini da ina waroim. ");
INSERT INTO wed_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","“Au karena, Bada tau i tereu. Muriai da aiwai ḡelaui i kauei. ");
INSERT INTO wed_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Tau kampa au kare oina, muriai da dobu. ");
INSERT INTO wed_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Tau a tupua muriai da Bada gabinou i kauei, muriai da waira vuvura i kwakwa-ḡetai. ");
INSERT INTO wed_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Tau a tupua muriai da ola, muriai da ola muomuoi ai au gabu i terei, tau kampa. ");
INSERT INTO wed_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Muriai da dobu bo wapu bo doa pokauna. ");
INSERT INTO wed_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Tau kampa maranai mara ana au gabu i terei, maranai parata i taini da mara au tepana ma boga au gabaura. ");
INSERT INTO wed_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","Maranai apau i terei au mara ma vuvura doa au orana i votawanei. ");
INSERT INTO wed_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Tau kampa, ma boga ana parata i terei ma i egari da nai paratana eḡa ina raḡoni. Tau kampa, maranai dobu oḡona i tonana-naiei. ");
INSERT INTO wed_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Nai marana tau Bada au ririvana a mamae me tauvioga, marana patapatai a vinuaiaini ma tau a vinuaiai. ");
INSERT INTO wed_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","A vinuaiai kaua maranai dobu i kaukaueia a inanai, a vinuaiai kaua maranai rava a inanai.” ");
INSERT INTO wed_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Nuaulaula ana numa i voai tuatua ḡaeḡae 7 i tai ana numa aubaina. ");
INSERT INTO wed_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Torela ḡaeḡaena i apui, sia i api ma wain aiaii iʼwaḡi ma kepakepa i vokaukauei, ");
INSERT INTO wed_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","ma ana taunola ḡelaui i paritawanei, au deba da i viḡoreḡore, ");
INSERT INTO wed_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","i riwa i pa, “Taumi eḡa notanota kauami ona nei!” Ma opaopai i riwei, ");
INSERT INTO wed_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Ona nei au lam ona ani ma wine a viravirai ona umai. ");
INSERT INTO wed_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Ami lawana opaopai ona voterei ma ona lawana, ma aramana lawanana ona maeni.” ");
INSERT INTO wed_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Tevera nuaulaulana Amana ana vinuaterena e nonori, wate tevera maeḡaeḡaena vinuaterena e gedugeduaiei. ");
INSERT INTO wed_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Mata-galagalawana purapura e raurauoḡarei eḡa ina vaia, wate egoegolana ana ḡoana aiwai anatapui ina vaia. ");
INSERT INTO wed_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Aiai natuna ora-potapotana eḡa ita kwapukwapui, lamna natuna nuanuana eḡa ita vaivaia. Wate aiai da natuna nuanuana e vaivaia lamna ina viararamani. ");
INSERT INTO wed_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Ama tevera opaopana i vinatunei lamna nuabola ava e vivitupui, laragana amana awarina eḡa nuaiai. ");
INSERT INTO wed_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Rava mata galagalawana e paepaewa labalababa, eḡa iri ita votaḡotaḡoi; tuaruta ana mara e baibaia ma eḡa aiwai. ");
INSERT INTO wed_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Natunatumi lawana aiaina ona viararamani, da maranai i vorata, nai lawanana eḡa ina voterei. ");
INSERT INTO wed_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Natum e viviorapota eḡa ma inana-tawanei, boreborelei u kwapui Amapo eḡa ma viraḡeni. ");
INSERT INTO wed_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","U raukwapui lamna iraḡe awarinei u gagaloei. ");
INSERT INTO wed_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Rava mata-galagalawana ana wapu adanei a nae, ravana opaopana ana grape wapuna au ririvana. ");
INSERT INTO wed_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","A inanai da modu i gogo-nae, ma donadona wapuna i vioai. Ma ana gari, i wanarikarikai. ");
INSERT INTO wed_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Lamna a inanai ma a vinua-notanotei. A tuvirevirei ma wei i viararamaniu. ");
INSERT INTO wed_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Matam ma potai, ma rauviraim. Wapu nolana avena, uram au nuanuam ma terei ma ma matave. ");
INSERT INTO wed_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Ma gomara ina ravim me taudanene; anatapuna ina pupuni. ");
INSERT INTO wed_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Rava mata-galagalawana e ririwa, “Ḡamoḡamo ḡaiḡaiawana au doa! Ḡamoḡamo ḡaiḡaiawana au etanai!” ");
INSERT INTO wed_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Mata-galagalawana lam au urana e vaivaiaia wate eḡa ina voepai au gamona. ");
INSERT INTO wed_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Aiai ravana nuaulaula i ḡoana-guratei, nuaiai ḡaeḡaena amana e vereverei. Wate aiai da etanai waivinei maiteni e nenae lamna ana mane ma ana purapura anatapuna e vikalokaloei. ");
INSERT INTO wed_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Kwapu ma nuaterena riwai, natum nuaulaula e vereverei. Wate tevera eḡa viararamanana, alona e vivitepaubaubai. ");
INSERT INTO wed_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Natunatumi ona vinuaterenei, da mara nonoa awarim nuauba; ma oram ina vinuaiaini. ");
INSERT INTO wed_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Mepa nanare wavine aiaina ma egoegolana uta nelaḡai? Wavinena i vinualaulauna kaua eḡa me ḡaima lebalebarina maiana ḡaeḡaena. ");
INSERT INTO wed_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Oroto awana i vitumaḡanei, ma eḡa aiwai ina voladaḡei. ");
INSERT INTO wed_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Wavine, kaua aiaii ma eḡa kaua apoapoe ita neneiai awana awarina ana lawana au anatapuna. ");
INSERT INTO wed_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Wavine sipu aparana ma waiape i vaia ma i vinuaiai da ina rauḡaroḡaro. ");
INSERT INTO wed_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Wavine sipu aparana ma waiape ina metani ma gara ina ḡauḡauri. ");
INSERT INTO wed_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Ana numa ma orana i votawanei molamolakai ma vovoladaḡai awarii. ");
INSERT INTO wed_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Erawa lamna kaua morumoruna ma inanana aiaina ina amoa; wate wavine Bada e vivivirei, rava tauna ina voepaepai. ");
INSERT INTO wed_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Wavinena ina voepaepai aubaina i kauana-kauei. Rava anatapui, wei wavinena ona voepaepai. ");
INSERT INTO wed_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","Wei lamna tauviararamana, David natuna, mai Israel ai gulau ana viararamana; ");
INSERT INTO wed_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Tauviararamana i riwa, “Anona eḡa! Anatapuna kwakwavina!” ");
INSERT INTO wed_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","Ma nolanola da ma magura ma anona aiwai? ");
INSERT INTO wed_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Kimta e nenei ma e nenae, wate dobu maemaena e mamae. ");
INSERT INTO wed_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","Madeḡa e gogogo ma e arearere, ma e wanawanavirai da ina vikarena-melei. ");
INSERT INTO wed_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Kariwabu e ḡotaḡota, rauanaḡa e opuopu, e kwavikwaviviro ma e wanawanavirai da ina vikarena-melei. ");
INSERT INTO wed_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Waira anatapui au boga e opuopu, wate boga eḡa ita oaoai. Waira matanei, e ḡaiḡairai ma e nenae me au matana. ");
INSERT INTO wed_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Kaua anatapuna i viʼnigarigari, menanare tana riwa nei? Matata eḡa melanai ina inana iaua; Taniḡata eḡa melanai ina nonora iaua. ");
INSERT INTO wed_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Aiwai wariaḡa i tupua ina tupua me, aiwai wariaḡa i kauei ina kauana-melei. Eḡa aiwai, kaua vouna wei au dobuna! ");
INSERT INTO wed_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","E ririwa, “Ona inanai! Wei kaua vouna.” Wate eḡa! Wei kaua maemaena; wariaḡana, muriai da ta tupua. ");
INSERT INTO wed_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Kaua wariaḡa i tuputupua, eḡa aiai ita notanotai. Ma kaua marina da muriai e tuputupua, eḡa aiai ina notai. ");
INSERT INTO wed_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","Tau lamna tauviararamana ma Israel ai gulau au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","Orau a terei da aiwai anatapuna au dobu e tuputupua, nuaulaulei ana girumi. Ma a aramanei da God vita ḡaeḡaena rava i verei. ");
INSERT INTO wed_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","Aiwai e tuputupua au dobu a vinua-notenotei ma a inanai da; anatapui anona eḡa, kwakwavina. Ive ava ta viviaḡaḡei. ");
INSERT INTO wed_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","Aiwai barabarai amapo eḡa ma vojijimana-melei, aiwai awarim eḡa, lamna menanare ma iavanei. ");
INSERT INTO wed_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","Au orau a riwa, “Tau a nuaulaula guratana, eḡa me aiai ḡelauna au Jerusalem i vivigulau nanare. A ʼramanei nuaulaula aiwai ma aramana aiwai. ");
INSERT INTO wed_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","A ḡoei da ata aramana-kauei nuaulaula aiwai ma bua ma opa aiwai. Wate a aramanei da wei lamna me ive a viviaḡaḡei. ");
INSERT INTO wed_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","Aubaina au nualaula e rarata, mae-boaboa e rarata au aramana e rarata, au nuabola e rarata.” ");
INSERT INTO wed_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","A vinotanota a pa, “Abeka nuaiai ana baiei, ana raudadani, da i aii bo eḡa.” Wate a nelaḡai da wei lamna kwakwavina. ");
INSERT INTO wed_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","Lamna aubaina a riwa da kaka labalababa ma erawa lamna bua. Ma erawana aiwai aiaina e vereverem? ");
INSERT INTO wed_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","Nuaulaula a ḡoana-guratei, ma a ḡoei da wine ata umai da orau ita telatela ma kaua opaopai ata kauei, da ata aramanei metauna i aii rava au dobu awari, maranai mara tupona ava au dobu e mamae. ");
INSERT INTO wed_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","Kaua ḡaeḡaei a vikarei, au numa ḡaeḡaei a voa-naiei ma grape wapui a paewi. ");
INSERT INTO wed_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","Wapu da peipei a kauei ma ai uauai tapuna ma tapuna a paewi. ");
INSERT INTO wed_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","Dogo a ḡarai da garewa ma wapaketa i vojijini, lamnei wei wapui a vivituvanei. ");
INSERT INTO wed_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","Awariu taunola au numa tuputupuai, ma taunola maḡamaḡaui nelarai ma waivinei a gimarai. Au bulumakau ma sipu i maḡa guratana eḡa me aiai ḡelauna au naona au Jerusalem nanare. ");
INSERT INTO wed_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","Awariu gold ma silver gaegaena ma nanare dobuḡela gulaui ai via. Tauwela nelarai ma waivinei a vimaiei ma guguini inanai aiaii a vivaneiai au numa, au ani vieraerawa. Aiwai a ḡoeḡoei ana tapuna awariu. ");
INSERT INTO wed_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","Tau a maura ma a vipurapura kaua eḡa me aiai ḡelauna au Jerusalem nanare. Ma wei anatapuna au orana au nuaulaula i mae-kaua. ");
INSERT INTO wed_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","Aiwai a inanai ma a rauoḡarei a vaia, anatapuna a notai da ita vinuaiainiu. Au nola anatapui a kauana-kauei, ma nuaiaina lamna au nola maiana. ");
INSERT INTO wed_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Anina ma aiwai anatapuna a voavoai ma a polepolei, a vinua-notenotei ma a aramanei da wei anatapui lamna anona eḡa, lamna me ive ata viviaḡaḡei wei au dobuna amapo eḡa aiwai tana vaia. ");
INSERT INTO wed_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Nuaulaula, bua ma opa anoi a vinua-notenotei. Gulau ana raviepaia, aiwai ḡelauna ina kauei? ");
INSERT INTO wed_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","Ma aramanei da nuaulaula i aii kaua eḡa me opa, ma lalalaina i aii kaua eḡa me gimtona. ");
INSERT INTO wed_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","Rava nuaulaulana matana au kolana e mamae wate opaopana waguwaguvareina e bababara. Ma aramanei da ravai ruaḡai ai damona tagogi. ");
INSERT INTO wed_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","A vinua-notanota a pa, “Tau ma opaopana ai damona tagogina. Au nuaulaula aiwai ḡelauna ina vereu?” Au nota a pa, “Wei maiteni anona eḡa.” ");
INSERT INTO wed_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","Rava nuanuaulaulai lamna me rava opaopai amapo nai ravaii nuanuata ina vuru. Kapore! Rava nuaulaulauna ma rava opaopana e irairaḡe. ");
INSERT INTO wed_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","Tau lawana a geduaiei, au dobu aiwai anatapuna ta kaukauei iniviara ava e verevereta. Anatapuna kwakwavina, me ive taviviaḡaḡei. ");
INSERT INTO wed_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Anatapuna au dobu a polepolei a geduaiei, aubaina nai ana voterei, da rava au muriu e nenei aubaii. ");
INSERT INTO wed_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","Ma aiai i aramanei da tauna rava nuaulaulauna bo rava opaopana? Wate tauna aiwai a polepolei ma au aramanei a vitupui ina vaia. Wei anona eḡa. ");
INSERT INTO wed_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Au bagibagi anatapuna wei au dobuna a notai ma orau i peu. ");
INSERT INTO wed_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","Aubaina rava ana nuaulaulei ma ana aramanei i nola kaua, da i maura ma anatapunana ina voterei da rava gelauna, eḡa taunoleina ina vaia. ");
INSERT INTO wed_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","Marana patapatai nola ma nuabola inina e viviarei au dobu ma aiwai ina vitupui? ");
INSERT INTO wed_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","Tauna ana nola da iniviara ma nuabola; waguvarai maiteni eḡa ita matamatave. Wei maiteni eḡa anona. ");
INSERT INTO wed_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","I aii da rava ita am ma ita uma ma ana nola ita vinuaiaiei, ma a inanai da vinuaiai lamna God uranei. ");
INSERT INTO wed_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","Aubaina God eḡa. Lamna eḡa am ma eḡa nuaiai. ");
INSERT INTO wed_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","Aiai God e vivinuaiaini, God tauna nuaulaula, aramana ma nuaiai, e vereverei. Wate ḡoa apoapoe ravana ana nola i verei da mane ma maura ḡaeḡaena ina vitupui, Wate God nai maurana ina vaivaitawanei ma aiai e vivinuaiaini ina verei. Ḡoa apoapoe taukauei ai nola lamna kwakwavina, me ive i taviviaḡaḡei! ");
INSERT INTO wed_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Mara ma iri i terei da aiwai anatapui au dobu ai au mara e tuputupua. ");
INSERT INTO wed_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Vinatuna ana mara ma iraḡe ana mara paewa ana mara ma tuaruta ana mara. ");
INSERT INTO wed_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","Viraḡena ana mara ma vilawana ana mara, amrika ana mara ma voa ana mara. ");
INSERT INTO wed_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","Tou ana mara ma kaka ana mara, mogu ana mara ma ara ana mara. ");
INSERT INTO wed_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","Ḡaima viorerena ana mara ma tama melanana ana mara, taragwaba ana mara ma eḡa taragwaba ana mara. ");
INSERT INTO wed_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","Baia ana mara, ma baia voterena ana mara, ma purapura vojijinana ana mara ma purapura vineboana ana mara. ");
INSERT INTO wed_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","Sika ana mara ma popo ana mara, genuana ana mara ma babani ana mara. ");
INSERT INTO wed_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","Nuavaina ana mara ma ḡoaḡai ana mara viḡaiḡaiawa ana mara ma nuauba ana mara. ");
INSERT INTO wed_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Rava ruaḡa i aii eḡa me rava tagogi, aubaina taui ina viagu vivira ma maura ina nelaḡai. ");
INSERT INTO wed_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Mepa da tagogi ina peu, turana e mamae da ina voepai. Wate tam ainelam ma u peu lamna i apoapoe kaua, aubaina kampa eḡa aiai da ina voaguim. ");
INSERT INTO wed_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Ma nanare mepa da rava ruaḡa i matave tagogi, taui eḡa inii ina ubauba. Rava tagogi menanare ainela ina vibolabola-melei? ");
INSERT INTO wed_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","Am ḡavia, ainelam ina viḡaviem ma ina vovaiubaim, wate maranai taumi ruaḡami e viviḡaviem amapo ona vobelei. Ma rava tonuḡa i virewapana kaua me ḡurava barawa tonuḡei metametanana. Wei ḡuravana viaituinana ma kauana-avei. ");
INSERT INTO wed_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Aiavoi mane nuanuai e vaivaia eḡa melanai nuanuai ina rauei; aiavoi e ḡoeḡoei da ina vipurapura; taui eḡa melanai ai rauoḡara anatapuna ina vaia. A inanai da wei anona eḡa. ");
INSERT INTO wed_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Maranai am maura e rarata, lamna maranai patara e ḡeḡetai da e amam vereverem. Wate wei maurana aiwai aiaina e vereverem? Eḡa aiwai, anina e viatataim da tam maumauram, wate rava ḡelauna am maura ina tawanei aubaim. ");
INSERT INTO wed_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Taunola e amam kaua bo eḡa, wate e matamatave kaua. Mane ravana eḡa nanare, tauna ana maura e notanota-maratomei. ");
INSERT INTO wed_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","Au dobu kaua apoapoe kaukauana a inanai; Mane ma purapura ravana ana maura au anara e tereterei muriai aubaina. Wate wei lamnei, ana nuabola ḡaeḡaena i tuarui. ");
INSERT INTO wed_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Ana mane ma ana maura i kauana labalababai ma anatapuna i vine-boai. Natuna eḡa ana buderi ita terei. ");
INSERT INTO wed_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","Menanarena dobuna ta ruinei nanarena tana nae me, kovakovata ma ana ura kwakwavita. Amapo eḡa ata purapura, ta vopolepolei tana vinimavoei. ");
INSERT INTO wed_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","Au lawana kwakwavina au orana kaua ruaḡa a inanai; Rava aiaina Bada ana nola e kaukauei iʼraḡe laḡilaḡina ma ḡoʼapoapoe taukaueina God ana tarawatu e viviaigai wate ana lawana i manawa. ");
INSERT INTO wed_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Lamna aubaina eḡa ma viḡoa aiaina guratana bo ma vinuaulaula guratana, mepa da ma viraḡena-melem. ");
INSERT INTO wed_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Wate nanare, eḡa ma vitaniḡapota guratana ma eḡa ma opa; eḡa ita ai da ma iraḡe muriai da am mara. ");
INSERT INTO wed_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","I aii mepa da wei riwai bagibagina ma nonori Aiai God e vivivirei lamna ina paina-melei da wei kauai ruaḡai eḡa ina kauei. ");
INSERT INTO wed_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","Rava nualaulaunana tagogi rewapana ḡaeḡaena ina verei eḡa me gulagulau 10 au taon. ");
INSERT INTO wed_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Riwa kaua! Weka au dobu eḡa aiai tagogi kaua aiaii ava taukaueina. Ma eḡa ḡoʼapoapoe ita kaukauei. ");
INSERT INTO wed_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","A ḡoei da nuanuau ita ulaula lamna aubaina rava ai mae au dobu a inanai, ma lamnei a aramanei da marai ma waguvarai eḡa matave kaua. ");
INSERT INTO wed_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","God aiwai i kaukauei eḡa ata aramana dadanei. Ma voguratei da ma nelaḡai, wate amapo eḡa ma aramanei. Nuaulaulai e ririwa da i aramanei, wate eḡateni dadana. ");
INSERT INTO wed_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Laralaraga, ami vilaraga ona vinuaiaiei. Nuanuami ina morelana ami au vilaraga. Orami ma matami ana rauoḡara ona kauei. Wate ona aramanei da aiwai o kaukauei God ina etaremi, anatapuna aubaina. ");
INSERT INTO wed_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Lamna aubaina nuabola au murimi ona terei ma tupuami ona paina-melei, aubaina amapo eḡa ona vilaraga nonoa. ");
INSERT INTO wed_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Ami au vilaraga, taukauemi eḡa nuanuami ina vuru, muriai da nuabola ona nelaḡai; maranai magura i tuḡereḡerei, ma ona riwa, “Lawana marina eḡa ita ai!” ");
INSERT INTO wed_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","Lamna maranai madeḡa, nawaravi ma ubona ina ḡuvai, ma apau ina nememei da mara ina ḡuva-nonoei. ");
INSERT INTO wed_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","Anina ma nimami, taugagaloemi ina sisi aemi marina vivirewapanana ina vokokokara. Ivomi ina viruaḡa da ami lam eḡa ona uta gwadagwadai, matami ina vinawanawa da eḡa ona inana kaua. ");
INSERT INTO wed_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","Taniḡami ina pota da gugura au etanai eḡa ona nonori, kiu ina logologoi ina ravidagudaguimi wate ai wela anatapui ina amoa. ");
INSERT INTO wed_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Taukauemi ona vinuanotenotei: Maranai aidamo ona gagatei ma babara ona rovoei, maranai kora ina tonaimi me rei talana, ma tam ma gwaḡa-nae me kapau e gwaḡagwaḡa-nae iraḡe aubaina. Erawa ma morelana anatapui ina kwa. Tauta kokoaḡa ta tuḡereḡerei ma tou ina vikarei au doa. ");
INSERT INTO wed_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","Taukauemi ona vinuanotei, muriai da lavutu ḡuravana ina wanautuini, bo nau goldei ina wanawamai ma reduḡoru ina wanakabakabari. ");
INSERT INTO wed_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Ma tupuami ina naeme au doa ma aruami ina naeme God, tauverena awarina. ");
INSERT INTO wed_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Tauviararamana i riwa, “Anona eḡa! Anona eḡa! Anatapuna anona eḡa.” ");
INSERT INTO wed_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Tauviararamana nuanuana i ulaula kaua, ma aiwai i aramanei rava i viararamani. Riwa nuaulaulaui maḡamaḡaui i ʼavi ma i girumei ma i rereḡa-kauei. ");
INSERT INTO wed_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","Tauna riwa vinuaubana i baiei ma aiwai i girumi lamna jijimanina ma ririwa-kauana. ");
INSERT INTO wed_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Tauviararamana riwai lamna me kwapu ma riwa nuaulaulai i gam me tutu, nuanuam ita tonatonai. Wei anatapuna Bada i vereta. ");
INSERT INTO wed_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Anina natu, ma aramanei da kaua ḡelaui ma inana-kauei. Buka girumai eḡa ina kwa ma giruma ḡiriḡiri i vinigarigari. ");
INSERT INTO wed_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Wei anatapui au murina. Riwa tagogiava ma aramanei: God ma vivirei ma ponana ma voteletelei. Wei lamna aubaina rava i vitupui. ");
INSERT INTO wed_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","God ata kaua anatapui govagovaḡai, aiaii bo apoapoe, ina kovoḡi. ");
INSERT INTO wed_vpl VALUES ("IS2_1","024_2_1","ISA","2","1","1","God ana pariverena, Judah ma Jerusalem aubaii wenanare, Isaiah - Amoz natuna i verei. ");
INSERT INTO wed_vpl VALUES ("IS2_2","024_2_2","ISA","2","2","2","Mara au murina, ola mepa tempol marina e maimairi, ina mae-nonoa. Ina ḡetelara kaua eḡa, me ola ḡelaui. Dam nununai patarai ina taini kampa da ina voepaepa. ");
INSERT INTO wed_vpl VALUES ("IS2_3","024_2_3","ISA","2","3","3","Dam patarai ina nei ma ina riwa, “Ona nei, tana ḡae Bada ana au ola, Jacob ana God ana au numa. Weka ana kaua ina viararamanita da au ivina tana babara. Aubaina Bada Riwana au Zion da ina opu, Bada ana tarawatu Jerusalemei ina opu. ");
INSERT INTO wed_vpl VALUES ("IS2_4","024_2_4","ISA","2","4","4","Tauna dam ḡaeḡae ai viḡaiḡaiawa ina rauetarei, ma ina kovoḡa. Ai sod ina guda-virai da ipa uata, ma ai pawasi ina guda-virai da naipi ai raḡaraḡai kosii aubaii. Dam damai eḡa ina viḡaiḡaiawa vivira me, bo ina vokaukaua, ḡavia aubaina. ");
INSERT INTO wed_vpl VALUES ("IS2_5","024_2_5","ISA","2","5","5","Ona nei Israel natunatui, Bada ana au ravilala au ivina tana babara.” ");
INSERT INTO wed_vpl VALUES ("IS5_1","024_5_1","ISA","5","1","1","Ona rautaniḡana ma au nuavainana ana wela ana ravi. Au nuavainana ana grape wapuna i paewi, doa au maumaurana, ola au barana. ");
INSERT INTO wed_vpl VALUES ("IS5_2","024_5_2","ISA","5","2","2","I auni ma ḡaima i viopuni ma i gari ma grape ḡoroḡorovai aiaii, avavai, i paewi. Violaḡa numana i voai ma nanare wine anigudana i bori au kira. Anina ma i vipaipai da grape uena aiaii ita verei, Wate grape anatapui i viḡora. ");
INSERT INTO wed_vpl VALUES ("IS5_3","024_5_3","ISA","5","3","3","Marina taumi Mai Jerusalem ma Mai Judah, Tau ma au grape wapuna ona babiniei! ");
INSERT INTO wed_vpl VALUES ("IS5_4","024_5_4","ISA","5","4","4","Aiwai ḡelauna eḡa ata kauei au wapu? Anatapuna a kauana-paiei! A notai da grape uena aiaii ita vereu wate viviḡorai i vereu. ");
INSERT INTO wed_vpl VALUES ("IS5_5","024_5_5","ISA","5","5","5","Marina ana riwem, wenanare ana kauei au wapu awarina. Garina ana viairikarikai da ḡamoḡamo ina rui Ma wapuna ina ḡara-viravirai. ");
INSERT INTO wed_vpl VALUES ("IS5_6","024_5_6","ISA","5","6","6","Ana voterei da modu ura gogoi ina vinelana ma eḡa aiai grape ina taraḡadaḡadari bo modu ina tuparaguragui. Modu ma donadona, wapuna ina puru-pai. Apau ana egari da eḡa kampa garewa ina atuna. ");
INSERT INTO wed_vpl VALUES ("IS5_7","024_5_7","ISA","5","7","7","Bada Vivirewapana Kaukauana ana grape wapuna lamna, Israel ma grape ḡoroḡorovana ae tuḡuna e rerereḡi lamna ana dam mai Judah, I notanotai da lawana aiaina ita maeni wate i ʼnanai da tara i vitoini; kaua jijimanina ita nelaḡai wate viḡaiḡaiawa gararai i nonori. ");
INSERT INTO wed_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Madeḡana gulau Uziah i ʼraḡe, tau Bada a inanai. Tauna ana au anikiala, au aidamo telarana i kiakiala ma ana gara adana tempol i vioai. ");
INSERT INTO wed_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Au ririvana lamna Seraph ruaḡa. Tagotagogi ava papei six; papena ruaḡei naoi i purui, ruaḡei aei i purui ma ruaḡei, i lavelave. ");
INSERT INTO wed_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Ma tauiava i viḡoreḡore vivira; “Vivivirem, vivivirem, vivivirem tam Bada, Vivirewapanana; Dobu anatapuna am boruma i oai.” ");
INSERT INTO wed_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Ponai gugurana tempol tuatuana i gui ma bau tempol i vioai. ");
INSERT INTO wed_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Ma a riwa, “Aio! A kauana-boai! Babani apoapoei gamou i vimiramirai, ma rava gamoi miramirai au poui a mamae, wate matauei gulau, Bada vivirewapana kaukauana a inanai.” ");
INSERT INTO wed_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Ma seraph tagogi incense aniapuna au tepana ai moniana i kavini ma i lavenei awariu. ");
INSERT INTO wed_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Ma ai monianei gamou i vodadani ma i riwa, “Ma inanai, wei ipirim i vodadani; am apoapoe vinimalana i vaitawanei ma am ḡoʼapoapoe i notatawanei.” ");
INSERT INTO wed_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Anina ma Bada ponana a nonori i riwa i pa, “Aiai ana paritawanei? Aiai aubaita ina nae?” Ma a riwa a pa, “Tau weka. Ma paritawaneu!” ");
INSERT INTO wed_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Muriai, Bada, gulau Ahaz i riwana-melei i pa, ");
INSERT INTO wed_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Bada am God ma vibaḡai da mataira piripirina, doa au ipu dewadewana, irairaḡei ai au animae bo mara au tepa dewadewana, ina viatataiem.” ");
INSERT INTO wed_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","Wate Ahaz i paribelei, “Tau eḡa Bada ana vibaḡai mataira aubaina. Eḡa ata ḡoei da Bada ana raudadani.” ");
INSERT INTO wed_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Ma Isaiah i riwa i pa, “Gulau David ana epaepaia, ona rautaniḡana kaua! Taumi ami orapotei rava orai o vivibadoi ma marina o ḡoei da kauana tagogina ona kauei Bada awarina bo? ");
INSERT INTO wed_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Lamna aubaina Bada ainelana mataira ina viatataiemi: Matatapu ina duama ma tevera orotona ina ḡuni ma ina viwavai Imanuel.” Wei anona God tauta maiteni. ");
INSERT INTO wed_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Taui i vivinuʼapoapoe, ai vinuapoapoe ina kwa. Rorova dobu Zebulun ma dobu Naphtali i kwalai ma i vinimalamalai, wate muriai dobuna ina viboruma-kauei. Galili, jentail ai dobu, au boga Mediteranean ina vikarei da maramatanei ina nae da waira Jordan au baba ḡelauna. ");
INSERT INTO wed_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Taui waguwaguvareina taubabarai lalaina ḡaeḡaena i ʼnanai; Taui gimtona taumaenina awarii lalalaina i lalai. ");
INSERT INTO wed_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Tam ai dam u vimaḡai ma ai nuaiai u viratai; am viturana i vinuaiaiei; me tuaruta au marana e vivinuaiai, me sorodia e vivinuaiai, maranai, ḡavia purapurai i tuarui, e ḡutaḡutai. ");
INSERT INTO wed_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Aubaina, awarita tevera i tupua! Tevera orotona i vereta! Tauna ina vibada. Tauna ina ḡorei: Tauvinuaterena Aiaii telarana, God Vivirewapanana; Amata Maemae Nonoana; Nuauba Badana. ");
INSERT INTO wed_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Ana vigulau ma ana nuauba ina tua, eḡa damona ita mamae. Noina Gulau David ana au vigulau gabuna ina kiala, ma nuavainei ma jijimaninei ina vibada kaua; Ina mae-nonoa, marina da mara au damona. Bada Vivivirewapana Kaukauana ana nuavainei wei anatapuna ina kauei! ");
INSERT INTO wed_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Me ai tuḡutuḡu ita nabinabi Mara e nenei maranai Jesse ana damei gulau ina nei. ");
INSERT INTO wed_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","Ma Bada Aruana tauna au tepana ina rauei da: Nuaulaula ma aramana ḡaeḡaena ina verei, ana oḡa tara aiaina ma tepa tora ina verei, da ana rava ina paina-kauei. Bada ina aramanei ma ina vivirei. ");
INSERT INTO wed_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","3","Bada votelatelana, lamna ana nuaiai ḡaeḡaena, ma eḡa kaua tepana inanana bo viarautu awarinei, ina kovoḡimi; ");
INSERT INTO wed_vpl VALUES ("IS11_4","024_11_4","ISA","11","4","4","Tauna molamolakai ina rauetarana-kauei, ma vivinuapoapoe au dobu aubaii ina mairi. Ma gamona bolabolana dobu ina kovoḡi, ma ponanei ḡoʼapoapoe ravai ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Tauna kaua jijimanina ina vijiḡoratei ma patutu ina vitairoroei. ");
INSERT INTO wed_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","Nanare auou moduei sipu natuna maiteni ina mae, ma leopard gote ḡaubona au ririvana ina matave, nanare cow ma lion natunatui ina laba-tagogi; ma tevera ina viḡamoḡamo. ");
INSERT INTO wed_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","Bulumakau ma bear ina am tagogi, natunatui ina matave tagogi, ma lion gidagida ina ani me bulumakau. ");
INSERT INTO wed_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","Tevera daradarana mota ana au nibo ina vikalokalo Ee! Ma tevera edaedana mota aiara ana au nibo, urana ina tereḡairei. ");
INSERT INTO wed_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","Au Zion, au ola vivivireina eḡa aiwai ina vikeroi bo ina viapoapoeni. Aubaina Bada aramanana dobu ina vioai, me waira boga e vivioai. ");
INSERT INTO wed_vpl VALUES ("IS11_10","024_11_10","ISA","11","10","10","Nai maranaina gulau vouna, Jesse ana damei, ina vomairi da ina vimataira dobu au ana tapuna. Dam ḡaeḡaei anatapui ina deri ḡeta awarina, ana au animae boruborumana. ");
INSERT INTO wed_vpl VALUES ("IS35_1","024_35_1","ISA","35","1","1","Mutulua ma dobu poipoina ina vinuaiai, dobu dariḡaḡa ina vinuaiai ma ina talai! ");
INSERT INTO wed_vpl VALUES ("IS35_2","024_35_2","ISA","35","2","2","Berana ina numoi, ma ina vinuaiai ma ina logologoi! Inanana i vinualaulauna me Lebanon olai ma ana maura me Carmel olana ma Sharon wapuna. Kampa Bada ana boruma rava ina viatataiemi, Bada ana vigulau ina inanai. ");
INSERT INTO wed_vpl VALUES ("IS35_3","024_35_3","ISA","35","3","3","Ura vogarigarii ona vovaibagi, ae tutu gwaḡagwaḡana ona vovaibagi; ");
INSERT INTO wed_vpl VALUES ("IS35_4","024_35_4","ISA","35","4","4","Rava rovorovoi ona riwei, “Eḡa ona rovo! Ona virewapana! Ona inana! God ana mejina e nenei; da ami ḡavia ina vipupui.” ");
INSERT INTO wed_vpl VALUES ("IS35_5","024_35_5","ISA","35","5","5","Ma mata potapotai ina inana ma taniḡa potapotai ina nonora ");
INSERT INTO wed_vpl VALUES ("IS35_6","024_35_6","ISA","35","6","6","Gwaḡagwaḡai ina viauauepa me deer, ma gumgum ana morelanai ina vigaragararei. Waira au dobu dariḡaḡa ina wanaiwaḡi, ma vuvura ina raupaipairei. ");
INSERT INTO wed_vpl VALUES ("IS35_7","024_35_7","ISA","35","7","7","Doa paipairana ina vitopa vuvura ina raupaipairei au dobu dariḡaḡa, modu ma gonu ina gogo labalababa auou moduei ana au animae. ");
INSERT INTO wed_vpl VALUES ("IS35_8","024_35_8","ISA","35","8","8","Ma kampa etanai ḡaeḡaena e ḡoreḡorei Etanai vivivireina, ina mae. Etanaina lamna taui God ana babara e nenaeni, taui ava aubaii, Rava orai miramirai eḡa ina babarani. Bubuai weka eḡa ina babara dadana. ");
INSERT INTO wed_vpl VALUES ("IS35_9","024_35_9","ISA","35","9","9","Eḡa lion bo raviuru kampa ina babara. Eḡa ḡamoḡamo ḡaiḡaiawai kampa ina mae Bada rava i vivilawania, taui ava kampa ina babara. ");
INSERT INTO wed_vpl VALUES ("IS35_10","024_35_10","ISA","35","10","10","Bada aiavoi i gimara-melei wenanare ina nememei ana welawelai ina rui au Zion Nuaiai maemaena ina vikunuteiei, nuaiai ma morelana ḡaeḡaena ina peu au tepai, nuabola ma iniviara ina amoa. ");
INSERT INTO wed_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Ami God e ririwa, “Au rava, ona vinuaubai! Nuauba riwai ona riwei.” ");
INSERT INTO wed_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Riwa egolanei mai Jerusalem ona riwei ona riwei da ai vinuapoapoe marana i kwa, ai ḡoʼapoapoe i nota-tawanei. Bada ai ḡoʼapoapoe i vimaiei mara ruaḡa. ");
INSERT INTO wed_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Rava e viḡoreḡore; “Bada ana aninae au mutulua ona vokaukauei! Etanai jijimanina ata God aubaina au mutulua ona kauei. ");
INSERT INTO wed_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Gwagwa ona dobo-naiei, ma ola anatapui ona ḡara tawatawanei doana anatapuna ona vimataveni, ona ḡara-laboḡi. ");
INSERT INTO wed_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Bada ana boruma ina vieḡai, ma rava anatapui ina inanai. Lamna Bada gamonei i riwa!” ");
INSERT INTO wed_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Zion, tam pariverena aiaina e garagararei. Ma ḡae ola ḡaeḡaena au tepana ma ponam ḡaeḡaenei, pariverena aiaina ma raugugulei ma eḡa ma rovo! Taon ḡaeḡaei Judah au paratana ma pariverei, “Ami God e nenei!” ");
INSERT INTO wed_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Ona inana Bada God ana rewapanana e nenei da ina vibadeta. Ona inanai! Maiana, lamna rava i vivilawania, maiteni e nenei. ");
INSERT INTO wed_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Ana rava ina ḡamoi me sipu tauḡamoina, ana sipu natunatui au nuanuana ina raparapai. ma tatauvao ina ravena-kauei. ");
INSERT INTO wed_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","Bada i riwa, “Wei au taunola, a vinei, a vovaivirewapani ma a vinuaiaiei. Aruau au orana a terei ma tauna lawana aiaina, ma kaua jijimanii ina neiai dobu au anatapuna. ");
INSERT INTO wed_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","Tauna eḡa ina garara bo ponana ina rata au deba. ");
INSERT INTO wed_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","Rava me gonu barabarana eḡa ina gai, bo rava me wiki tupona eḡa ina boi. Wate lawana aiaina ma kaua jijimanii ina neiai dobu anatapui awarii da ai lawana. ");
INSERT INTO wed_vpl VALUES ("IS42_4","024_42_4","ISA","42","4","4","Eḡa orana ina peu bo ina vokokokara, lawana jijimanina ina terei au dobu; bonabona ravai aueia nanare, e vivipaipai.” ");
INSERT INTO wed_vpl VALUES ("IS42_6","024_42_6","ISA","42","6","6","“Tau Bada jijimaniu, a vinem ma ana vovaivirewapanim da lawana aiaina ma neiai; ma ana raunimavoaim ma ana gagaloem. Tamei, parivainuaḡana bagibagina rava anatapui au dobu maiteni ana kauei, ma vilalalaina jentail awari. ");
INSERT INTO wed_vpl VALUES ("IS42_7","024_42_7","ISA","42","7","7","Ma mata-potapotai matai ma vikalai; ma ravai au panipani numana; nai taui gimtona maemaei ma tereopunei.” ");
INSERT INTO wed_vpl VALUES ("IS49_3","024_49_3","ISA","49","3","3","Bada i riweu i pa, “Israel tam au taunola ma tamei au boruma ana vieḡai.” ");
INSERT INTO wed_vpl VALUES ("IS49_5","024_49_5","ISA","49","5","5","Au manawa ma Bada i vineu da ana taunola; da ana rava mai Israel kwakokwakoi ana neiana-meleiai awarina. Bada i vimaeḡaeḡaeniu; Tauna au rewapana. ");
INSERT INTO wed_vpl VALUES ("IS49_6","024_49_6","ISA","49","6","6","I riweu “Au Taunola, Jacob ana dam ma voepana-melei ma mai Israel kwakokwakoi ma neiana-meleiai; lamna nola aburuna. Wate nola ḡaeḡaena a vereverem; lalalaina ma naiei jentail awarii ma lawana mamae-nonoana ma naiei da dobu au gia dewadewana ina ḡeta.” ");
INSERT INTO wed_vpl VALUES ("IS49_14","024_49_14","ISA","49","14","14","Wate mai Jerusalem i riwa, “Bada i netawaneta! Tauta nuanuana i vuru” ");
INSERT INTO wed_vpl VALUES ("IS49_15","024_49_15","ISA","49","15","15","Ma Bada i paribelei, “Moina! Tatauvao natuna melamelana au ḡuḡuna, nuanuana ina vuru bo; bo natuna i ḡuniḡunia nuanuana ina vuru Mepa da alo nuanuana ina vuru, wate tau, eḡa nuanuau ina vuru!” ");
INSERT INTO wed_vpl VALUES ("IS49_16","024_49_16","ISA","49","16","16","Jerusalem eḡa melanai nuanuau ina vuru Ona inanai! Wavami, au ura lapalapau a rurui. ");
INSERT INTO wed_vpl VALUES ("IS50_4","024_50_4","ISA","50","4","4","Bada God i viararamaniu aiwai ana latoni, da ḡokokokarai ma peupeui ana vovairewapani. Ubaubanai patapatai e ravidagudaguiu, ma taniḡau a tonetonei da ana rautaniḡanana ma ana viararamana kaua. ");
INSERT INTO wed_vpl VALUES ("IS50_5","024_50_5","ISA","50","5","5","Bada God aramana i vereu ma eḡa ata pariḡaiei bo ata mae-puputei. ");
INSERT INTO wed_vpl VALUES ("IS50_6","024_50_6","ISA","50","6","6","Uporau a verei da i kwapu-kauei, ma a voterei da mutuorou i amui. Eḡa naou ata govaḡi maranai i vinimalamalaiu ma naou i ovai. ");
INSERT INTO wed_vpl VALUES ("IS50_7","024_50_7","ISA","50","7","7","Wate Bada God au muriu e maimairi, lamna aubaina eḡa ita vitepaubaubaiu. A vokaukaua da ana nebelei, aramanei da eḡa ina vinimalamalaiu. ");
INSERT INTO wed_vpl VALUES ("IS50_8","024_50_8","ISA","50","8","8","God au ririvau, ma ina vitaubabani aubaiu. Tauna ina riwemi da tau eḡa aiwai ata kauana-boai. Aiai ina viwavuiu? Tana nae tana etara Au ḡavia mepa, taumi ona nei? ");
INSERT INTO wed_vpl VALUES ("IS50_9","024_50_9","ISA","50","9","9","Anina Bada tauoina e gagagaloeiu, Aiai ina riwei da tau a kauana-boai? Taui anatapui ina gumaḡa me gara wadubona. Komaḡana ina ambaubauni. ");
INSERT INTO wed_vpl VALUES ("IS52_7","024_52_7","ISA","52","7","7","I ai ḡaḡa, taupariverena a inanai olei e taḡotaḡonai. Riwa Aiaina e jimejimei: nuauba ma nuaiaii riwai ma Bada ana vilawana. Ma Zion i riwei, “Ami God e vivibada.” ");
INSERT INTO wed_vpl VALUES ("IS52_8","024_52_8","ISA","52","8","8","Ona rautaniḡana! Ami tauvineneḡana e vigaragararei; ana morelanai e logologoi; Taui mataiei Bada i ʼnanai e nenememei au Zion. ");
INSERT INTO wed_vpl VALUES ("IS52_9","024_52_9","ISA","52","9","9","Jerusalem wanarikarikana, ana morelanami ona wela-gogona Bada awarina. Tauna ana rava i vinuaubai, ma ana melagai Jerusalem, i vai-melei. ");
INSERT INTO wed_vpl VALUES ("IS52_10","024_52_10","ISA","52","10","10","Dobu anatapui au matai ana rewapana vivivireina e vivieḡai. Rava anatapui au dobu Bada ana vilawana, ina inanai. ");
INSERT INTO wed_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Bada i riwa, “Au taunola ana nola ina kauana-kauei! Rava tauna ina voepai au tepa dewadewana. ");
INSERT INTO wed_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Au naona rava maḡamaḡaui tauna i ʼnanai ma i virovorovoanei. I vunu-kauei ma i vitaratarai; da inanana eḡa me rava. ");
INSERT INTO wed_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Wate marina dobu patarai ina raviḡori ma gulagulau gamoi i pota tauna voepaepa aubaina. Eḡa ita pariverei, marina mataiei ina inanai, ma aiwai eḡa ita nonori, ina aramanei.” ");
INSERT INTO wed_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","“Aiai wei pariverenana ita vitumaḡanei? Bada aiai awarii ana rewapana i viatataiei?” ");
INSERT INTO wed_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","God au matana, i rata me ai-nabina, me aiwarama au kemara e gogogolana. Eḡa ita tupua karawata bo vigulauna, eḡa aiwaina vinualaulaunana da tata rauoḡarei. ");
INSERT INTO wed_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Ta inana geduaiei ma ta inana-tawanei, iniviara ma vinuapoapoe malana i vaia, ta raugovaḡei, ta mae-puputei ma ta riwa da tauna rava labalababa. ");
INSERT INTO wed_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Tauna, ata nuabola kovoḡana i vaia ma ata iniviara i avarai. Wate ta notai da ana ḡoʼapoapoe aubaina, God i kovoḡi. ");
INSERT INTO wed_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Ata kaua apoapoe aubaina i vitonei, ata ḡoʼapoapoe aubaina i vikeroi. Kovoḡanei, nuauba i vereta; kwapu keronei i vilawanita. ");
INSERT INTO wed_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Anataputa me sipu kwakokwakona, ana nuaita ma ata ḡoanei ta mamae; wate ata ḡoʼapoapoe kovoḡana, Bada tauna i viavarai. ");
INSERT INTO wed_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Au taunola i rauiviapoapoelana-kauei, wate i volaḡota; eḡa aiwai ita latoni. I taravaina-naiei viraḡenana aubaina me sipu ḡaubona. Me sipu ana genugenuanana e nenae aparabori aubaina eḡa aiwai ita latoni. ");
INSERT INTO wed_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","I pani ma i naiei ma eḡa aiai tauna ita vinuabolei, eḡa ana epaepaia ma ina iraḡe. Ana lawana au pouna i kwa labalababa. Ana rava oina ai ḡoʼapoapoe aubaina iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Tauna eḡa morumoruna bo ḡaiḡaiawana. Wate taui i ḡoei da danedanei maiteni ita doboi, ma purapura ravana ana au kokoaḡa i vimataveni. ");
INSERT INTO wed_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Maranai ana lawana i puloei ata ḡoʼapoapoe aubaina. Lamna, Bada ana ḡoana da tauna ita vunu-boai ma iniviara ḡaeḡaena ita vaia. Ma ana epaepaia ina maḡa guratana ma ana lawana ina manawa. Ma taunei, Bada ana ḡoana ina kauana-paiei. ");
INSERT INTO wed_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Ana nola anona ina inanai ma ina vinuaiaei da ana nuabola eḡa kwakwavina. Bada i riwa, “Au taunola patupatutuna a vinuaiaiei, rava maḡamaḡagaui ai kovoḡa i avarai ma lamnei taui ana ḡorei Rava-Jijimanii. ");
INSERT INTO wed_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Ma lamna aubaina ana vimaeḡaeḡaeni, tauna rava ḡaeḡaena. Ma ana au gabu ana terei rava ḡaeḡaei ma virewapanai maiteni ma ana maia ina ḡutai. Aubaina ana nuaina ana lawana i verenei. Tauna ora‑potapotai maiteni iʼraḡe, ma ḡoʼapoapoe ravai maḡamaḡaui aubai i mairi.” ");
INSERT INTO wed_vpl VALUES ("IS54_4","024_54_4","ISA","54","4","4","Eḡa ona rovo aubaina eḡa ina vitepa-ubaubaimi. Tepami ina tora, eḡa ina vinimalamalaimi. Ami laraga kauai nunuami ina vuru. Ami vikaiababa nuabolana ina amoa. ");
INSERT INTO wed_vpl VALUES ("IS54_5","024_54_5","ISA","54","5","5","Aubaina, taukauem lamna awam, wavana Bada Vivirewapana Kaukauana. Israel ana God Vivivireina am taugimaramelana, Tauna dobu anatapuna ai God. ");
INSERT INTO wed_vpl VALUES ("IS54_6","024_54_6","ISA","54","6","6","Israel, tam me wavine tavine vouvou ma awam i geduaiem ma u vinuabola kaua. Wate Bada ina ḡore-melem awarina ma ina pa, ");
INSERT INTO wed_vpl VALUES ("IS54_7","024_54_7","ISA","54","7","7","“A voterem mara aburuna, wate raunuapoapoe ḡaeḡaenei ana vaimelem. ");
INSERT INTO wed_vpl VALUES ("IS54_8","024_54_8","ISA","54","8","8","Au meji i rata kaua da a mae-puputem mara aburuna. Wate au nuavaina mamae-nonoanei, ana raunuapoapoelem.” Bada taugimaramelana i riwa me, ");
INSERT INTO wed_vpl VALUES ("IS54_9","024_54_9","ISA","54","9","9","“Awariu, wei me Noah ana au mara, maranai parivainuaḡana bagibagina a kauei da eḡa melanai wairei dobu ana purui-melei. Marina, nanare parivainuaḡana bagibaginei a ririwem da eḡa melana amlou ina ḡaiḡai da ana kovoḡimi. ");
INSERT INTO wed_vpl VALUES ("IS54_10","024_54_10","ISA","54","10","10","Ola ina vidagu ma ina amoa. Wate, au nuavaina mamae-nonoana, ma au nuauba mamae-nonoana tam awarimi ina mae-nonoa.” Bada tauraunuʼapoapoelemi i riwa. ");
INSERT INTO wed_vpl VALUES ("IS55_1","024_55_1","ISA","55","1","1","“Ona nei, nuanuarelanami! Waira wei! Awarimi mane eḡa ona nei ona gimara ma ona am! Ona nei, wine ma mereki ona gimarai maiana eḡa, ona vaioi. ");
INSERT INTO wed_vpl VALUES ("IS55_2","024_55_2","ISA","55","2","2","Aiwai aubaina lam apoapoei awari mane e tawatawanei. Aiwai aubaina e nolanola labalababa. Ona rautaniḡana kaua ma ona am-iaua, ma lam aiaii dagidagiaii ona vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("IS55_3","024_55_3","ISA","55","3","3","Taniḡami ona toneiai ma ona nei awariu ona rautaniḡana da ona lawana. Au parivainuaḡana mamae-nonoana ana kauei tam maiteni. Ma viaiaina David a parivainuaḡani ana verem.” ");
INSERT INTO wed_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","“Bada ona baiei da ona nelaḡai, marina au ḡereḡeremi, ona vibaḡai. ");
INSERT INTO wed_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","Ḡoa apoapoe ravai, ami lawana apoapoei ona geduaiei ma nuanuami ona virai. Ee! Ma ona wanavirai Bada awarina da ina raunuʼapoapoelemi ma ami ḡoʼapoapoe ina notatawanei.” ");
INSERT INTO wed_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","Bada i riwa, “Au nota eḡa me ami nota nanare, ma au kaua tapuna, eḡa ami kaua nanare.” ");
INSERT INTO wed_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","Mara i ḡetelara eḡa me dobu ma nanare au kaua i ḡetera eḡa me ami kaua. Ma nanare au nota i ḡetelara eḡa me ami nota nanare. ");
INSERT INTO wed_vpl VALUES ("IS55_10","024_55_10","ISA","55","10","10","Garewa ma turuvani marei e peupeu eḡa kwakwavina ina naeme au mara, wate dobu ina viutuvanei da lam ina gogo, da pei ina vereta, paewa aubaina ma lam, aniam. ");
INSERT INTO wed_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","Ma wenanare riwau gamouei e opuopu; eḡa kwakwavina ina nememei awariu da aiwai a pariparitawanei ina kauei; au ḡoana anatapuna ina vikwai. ");
INSERT INTO wed_vpl VALUES ("IS56_1","024_56_1","ISA","56","1","1","Bada wei e ririwei: “Aburuna ava, ana nei da ana vilawanimi ma au viaiaina ana vieḡai. Lamna aubaina, kaua aiaii ma jijimanii ona kaukauei.” ");
INSERT INTO wed_vpl VALUES ("IS56_6","024_56_6","ISA","56","6","6","“Mai jentail, aiai da tau i vituraneu ma i vitaunoleu, ma wavau i vinuavainei ma i vimaeḡaeḡaeniu. Au Sabate i vivirei, ma au parivainuaḡana bagibagina e vovojijina-kauei. ");
INSERT INTO wed_vpl VALUES ("IS56_7","024_56_7","ISA","56","7","7","Taui ana neiai au ola vivivireina - Zion ma nuaiai ana verei au parinumana. Ma ai pulo e apuapui awariu ana vianinei. Anina ma rava, au tempol ina ḡorei pari numana, dam anatapui au dobu aubaii.” ");
INSERT INTO wed_vpl VALUES ("IS58_7","024_58_7","ISA","58","7","7","“Am-irairaḡei lam ona taraiḡuei, ma ami numa ona votawanei, nelabalabai ma vinuapoapoe awarii. Kovakovai gara ona vioteni, ma taraoim eḡa ona inana-tawanei.” ");
INSERT INTO wed_vpl VALUES ("IS58_8","024_58_8","ISA","58","8","8","“Maranaina, au viaiaina ina ravilalaimi me maratomtom madeḡana, ma ami doria laḡilaḡina ana vilawani. Au naomi ana nae da ami aninae ana vovaijijimani, ma murimiei, au boruma ina gagaloemi. ");
INSERT INTO wed_vpl VALUES ("IS58_9","024_58_9","ISA","58","9","9","Nai maranaina ona viḡore ma Tau Bada, ana paribelemi. Agu ona gararei ma ana riwa, ‘Tau weka.” “Eḡa rava, vita ona verei, eḡa ona viwavuwavu ma eḡa babani morumorui ona kaukauei. ");
INSERT INTO wed_vpl VALUES ("IS58_10","024_58_10","ISA","58","10","10","Maranai am-irairaḡei o viambagibagi, ḡokokokarai o vovoagui. Lamnei, ami lalalaina gimtona ina lalai, ina ravilalai me aubenai madeḡana.” ");
INSERT INTO wed_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","“Bada God, aruana i vereu. I vineu ma i paritawaneu da: Riwana Aiaina ata naiei molamolakai awari ma vinuanuabolai ana vinuabai. Ma panipani ana pariverei da deriei ina viopuni. ");
INSERT INTO wed_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","I paritawaneu da rava ata pariverei, da mara i turiai maranai Bada ana rava ina vilawani ma ana ḡavia ina kovoḡi. Ma i paritawaneu da vinuabolai ana vinuaubai. ");
INSERT INTO wed_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Da taui e mogumogu au ola Zion, nuaiai ina vikunuteiei ma eḡa ina vidolodolo. Nuaiai logologona ma eḡa tou. Taui ina vinuaiai ma eḡa ina vinuabola. Ai kaua jijimanina aubaina ina ḡorei Bada ana labarava ai jijimanina da tauna ina vimaeḡaeḡaeni.” ");
INSERT INTO wed_vpl VALUES ("IS61_6","024_61_6","ISA","61","6","6","“Ma taumi ina ḡoremi Bada ana pirisi. Ina ḡoremi, God ana taunola. Taumi dobu ḡelaui ai maura ona ani ma ona vigulagulauei.” ");
INSERT INTO wed_vpl VALUES ("IS61_8","024_61_8","ISA","61","8","8","“Aubaina Tau, kaua aiaii a ḡoeḡoei, danene ma ḡoʼapoapoe a gedugeduaiei. Au rava ai vinuapoapoe aubaina ana vimaiana-kauei; au parivainuaḡana bagibagina mamae-nonoana maiteni ana kauei. ");
INSERT INTO wed_vpl VALUES ("IS61_9","024_61_9","ISA","61","9","9","Dam anatapui, am epaepaia ina aramanei ma e inainana ḡaei.” Ma ina pa, “Bada i viaiaina-kauei.” ");
INSERT INTO wed_vpl VALUES ("IS61_10","024_61_10","ISA","61","10","10","Bada awarina a vivinuaiai kaua ma Aruau God awarina i vinuaiai kaua. Aubaina vilawana garanei i vigaraiu Ma jijimana vianei ma garanei i vioteniu. Me tavitavinevou orotona e vivigarai nanare bo me wavine tavitavinevou ana viana e tavitavine. ");
INSERT INTO wed_vpl VALUES ("IS61_11","024_61_11","ISA","61","11","11","Me doa, pei e vivigogoi ma debagau lam e verevereta, nanare Bada God, rava e teretere-vaijijimani au dobu da tauna ina voepaepae. ");
INSERT INTO wed_vpl VALUES ("IS64_4","024_64_4","ISA","64","4","4","Oo Bada wariaḡa da marina, eḡa aiai god ḡelaui ponana ita nonori, ita inanai, bo ita aramana dadanei. Anina Tam ainelam. Taui da e vivipaipaiem e vovoagui. ");
INSERT INTO wed_vpl VALUES ("IS64_5","024_64_5","ISA","64","5","5","Tam kaua aiaii ravai e vovoagui, am tarawatu e vovojijini. Wate maranai ta ḡoʼapoapoe ḡiriḡiri tam amlom e voḡaiḡai. Aiwai aubaina ma vilawaniai? ");
INSERT INTO wed_vpl VALUES ("IS64_6","024_64_6","ISA","64","6","6","Anatapuiai a ḡoʼapoapoe, Au matam, ai kaua jijimanii anatapui miramirai me gara wadubona. Anataputa ta poipoi me ai-rugurugu, Ata ḡoʼapoapoe e kapupuana-naieta. ");
INSERT INTO wed_vpl VALUES ("IS64_7","024_64_7","ISA","64","7","7","Ma eḡa aiai wavam ita voepaepai bo ita voguratei da naom ita inanai. Lamna aubaina tam u netawanelai da ai ḡoʼapoapoei e vunuvunuiai. ");
INSERT INTO wed_vpl VALUES ("IS64_8","024_64_8","ISA","64","8","8","Wate Bada, tam amaiai. Tauai dogodogo ma tam nau tauvoaina. Tam anatapuiai uramei u rauḡaroḡaroelai. ");
INSERT INTO wed_vpl VALUES ("IS64_9","024_64_9","ISA","64","9","9","Lamna aubaina, eḡa ma meji guratana awariai. Ma eḡa ai ḡoʼapoapoe ma nota-nonoei. Ma i ʼnanaiai, anatapuiai tam natunatum. ");
INSERT INTO wed_vpl VALUES ("JR1_4","025_1_4","JER","1","4","4","Bada i riweu i pa: ");
INSERT INTO wed_vpl VALUES ("JR1_5","025_1_5","JER","1","5","5","“A vinem, muriai da alom au manawana a teretagogiem. Muriai da uta tupua, A tereriem, rava anatapui ai peroveta.” ");
INSERT INTO wed_vpl VALUES ("JR1_6","025_1_6","JER","1","6","6","A paribelei, “Oo Bada God, tau tevera ota, ma babani eḡa ata aramanei.” ");
INSERT INTO wed_vpl VALUES ("JR1_7","025_1_7","JER","1","7","7","Bada i riweu, “Eḡa ma riwa, ‘Tau tevera ota.’ Ma nae mepa a pariparitawanem, ma aiwai a ririwem taui ma pariverei. ");
INSERT INTO wed_vpl VALUES ("JR1_8","025_1_8","JER","1","8","8","Eḡa ma rovoei aubaina Tau a paritawanem. Tau tam maiteni ana mae da ana gagaloem. Tau Bada a babani.” ");
INSERT INTO wed_vpl VALUES ("JR1_9","025_1_9","JER","1","9","9","Anina ma Bada urana i viloloi da ipiriu i tapedadani ma i riweu, “Marina riwau au gamom a terei. ");
INSERT INTO wed_vpl VALUES ("JR1_10","025_1_10","JER","1","10","10","Ma aramana-kauei da marina rewapana a vereverem, da dobu anatapui ai gulagulau ai kovoḡa ma vinolenolei wenanare, Ḡelaui ma orumi, ma viairikarikai, ma vovaiubai ma vipupui. Ḡelaui ma voepai ma ma paewi.” ");
INSERT INTO wed_vpl VALUES ("JR1_17","025_1_17","JER","1","17","17","“Ma vokaukaua Jeremiah! Ma vomairi ma aiwai anatapuna a riwem ravai ma pariverei. Eḡa ravai ma rovoei, bo au matai, ana virorovoim. ");
INSERT INTO wed_vpl VALUES ("JR1_18","025_1_18","JER","1","18","18","Amadodo a vovaivirewapanim me melagai vivirewapanana, tuatuana ma garina iramei voavoana. Tam ma mairi ma eḡa maiJudah ma ai gulagulau, ai gabemani ravai, ai pirisi ma dobuna ravai ina tereḡairem. ");
INSERT INTO wed_vpl VALUES ("JR1_19","025_1_19","JER","1","19","19","Taui ina viḡaviem wate ina kauana-avei. Aubaina tau tam maiteni, ma ana gagaloem. Tau Bada a babani!” ");
INSERT INTO wed_vpl VALUES ("JR6_13","025_6_13","JER","6","13","13","“Rava anatapui, ḡaeḡaei da muomuoi, e ḡoeḡoei da moruei mane ina kauei; peroveta da pirisi anatapui nanare rava e morumorui. ");
INSERT INTO wed_vpl VALUES ("JR6_14","025_6_14","JER","6","14","14","Taui, au rava keroi ḡaeḡaei e bunabunamai apamina me kero aburuna. E ririwa da aiwai anatapuna anina, Wate eḡa anina!” ");
INSERT INTO wed_vpl VALUES ("JR17_5","025_17_5","JER","17","5","5","Bada e ririwa, “Aiavoi da ai vitumaḡana rava ota awarii e tereterei, ma ai rewapana e vitumatumaḡaneiei; ma e gedugeduaieu, ana parivaiapoapoeni. ");
INSERT INTO wed_vpl VALUES ("JR17_6","025_17_6","JER","17","6","6","Taui me, ai podapodai au dobu dariḡaḡa eḡa aiwai aiaina ita inainanai. Taui dobu au paipairana ina mae, ai ma modu eḡa, me au dobu au vivibogana ita mamae kampa eḡa rava ita mamae.” ");
INSERT INTO wed_vpl VALUES ("JR17_7","025_17_7","JER","17","7","7","“Wate aiavoi awariu e vivipatutu ma e vivitumaḡana da Bada ai tepamairi, taui ana viaiaini. ");
INSERT INTO wed_vpl VALUES ("JR17_8","025_17_8","JER","17","8","8","Taui me ai, vuvura au adana i paewi, ma warami i ḡaira waira au orana. Eḡa marapoi ina rovoei, ma rugurugui majimajiḡai ina maimairi. Ma marapoi ana au mara, eḡa ua ita vovoterei.” ");
INSERT INTO wed_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","“Rava nuapoui lamna morumoru kauana, i apoapoe kaua, aiai i aramana-kauei, da ina vilawani. ");
INSERT INTO wed_vpl VALUES ("JR17_10","025_17_10","JER","17","10","10","Tau Bada rava nuapouii a tuvirevirei ma kaua govagovaḡai au orai a inana-pai. Rava anatapui ai kaua ana inanai. ma ai kaua awarinei ana puloi.” ");
INSERT INTO wed_vpl VALUES ("JR20_5","025_20_5","JER","20","5","5","Tau, Jerusalem ma ai mane ma ai maura ma aiwai anatapui polapolai i toitoiei ana veredamanei ai ḡavia awarii. Ina nei ma Judah, ai gulagulau ai purapura maiai ḡaeḡaei maiteni ina pupuna-naiei au Babilon. ");
INSERT INTO wed_vpl VALUES ("JR20_7","025_20_7","JER","20","7","7","Oo Bada! u gwala-kaueu da a viperoveta ma a voterem da u kauei. Tam u virewapana guratana da u tereḡaireiu. Marina tau rava ai anivinama. Rava anatapui e vivinameu, marai ma waguvarai. ");
INSERT INTO wed_vpl VALUES ("JR20_8","025_20_8","JER","20","8","8","Maranai a paripariverena, Riwa ana nuaii e rubaruba-opu. “Viḡaiḡaiawa! Pupu e nenei!” Bada ana pariverena aubaina, vinama ava a nenelaḡai. ");
INSERT INTO wed_vpl VALUES ("JR20_9","025_20_9","JER","20","9","9","Mepa da ana geduai ma wavana eḡa ana latoni bo wavanei ana jima Lamna maranaina riwam lamna me ai araratana, orau e ararai. Amapo eḡa ana vojijina-guratei. Amapo eḡa! ");
INSERT INTO wed_vpl VALUES ("JR20_10","025_20_10","JER","20","10","10","A nonori patara e viviarautueu. Au ḡavia i maḡa kaua, ma e vineneḡaneu da ana neboa, ma ina viwavuiu ina pa, “mepa da i jima boa, ina waro-melei ma tauta ata biwa tana vaia.” ");
INSERT INTO wed_vpl VALUES ("JR20_11","025_20_11","JER","20","11","11","Wate Bada tau maiteni me tauviḡavia vivirewapana kaukauana. Lamna aubaina au ḡavia eḡa ina tereḡaireu. Taui ina vunu-aveu ma ina vinimala kaua. Ina vinimalana-nonoei ma eḡa nuanuai ina vuru. ");
INSERT INTO wed_vpl VALUES ("JR20_12","025_20_12","JER","20","12","12","“Oo Bada Vivirewapanam! Tam rava jijimanii e raraudadani, ma ai nota ma orai e araramanei. Au vita au uram a terei ma ana inanaim, au ḡavia ma kovoḡi. ");
INSERT INTO wed_vpl VALUES ("JR20_13","025_20_13","JER","20","13","13","Ona wela Bada awarina. Ona voepaepai. Maranai Rava vivirewapanai, gwaḡagwaḡai e rarau-iviapoapoelei, lamna Bada ana rewapanei taui ina gagaloei.” ");
INSERT INTO wed_vpl VALUES ("JR23_1","025_23_1","JER","23","1","1","Bada e ririwa, “Au rava ai babada nuabola ḡaeḡaena ina nelaḡai! Taui sipu taupaini apoapoei. I vipaipai-boa da sipu i vidabararai.” ");
INSERT INTO wed_vpl VALUES ("JR23_2","025_23_2","JER","23","2","2","Lamna aubaina Bada, Israel ana God, wenanare Israel babadai awari e ririwa, “Taumi ami kauelei au sipu o vidabararai ma o vilamolamonei. Eḡa ota vipaipai kaua. Lamna kauai apoapoei aubaina ana kovoḡimi. ");
INSERT INTO wed_vpl VALUES ("JR23_3","025_23_3","JER","23","3","3","Anina ma Tau au sipu ḡelaui a virubai au dobuḡela, ana neiana-meleiai ai au gari. Wei mamae‑terenai ina vinatuna ma ina maḡa guratana. ");
INSERT INTO wed_vpl VALUES ("JR23_4","025_23_4","JER","23","4","4","Taupainii rava kaua ana tere-naiei da ina viḡamoḡamo kaua ma eḡa ina rovo me bo orai ina sisi. Eḡa tagogi ina kwako. Tau Bada a riwa.” ");
INSERT INTO wed_vpl VALUES ("JR23_5","025_23_5","JER","23","5","5","Bada e ririwa “Mara vouna e nenei maranai gulau ana terei David ana damei. Wei gulauna ina vibada kaua ma kaua aiainei ma jijimaninei dobu anatapuna ina vibadei. Nota aiainei Judah ravai ina rauetaraveni ma Israel ravai au nuauba ina mae. ");
INSERT INTO wed_vpl VALUES ("JR23_6","025_23_6","JER","23","6","6","Wei maranaina mai Judah, ina vilawani ma Israel ana nuaubai ina mae. Ma wavana ina ḡorei, Bada Tauterevaijijimanita.” ");
INSERT INTO wed_vpl VALUES ("JR31_7","025_31_7","JER","31","7","7","Bada i riwa: “Ana nuaiaimi ona wela Jacob ana dam aubaina ponami ona voepai dam vigulauna aubaii. Ona voepaepa, ona jima ma ona riwa, ‘God, am rava mai Israel mamae‑terenai ma vilawani!’ ");
INSERT INTO wed_vpl VALUES ("JR31_8","025_31_8","JER","31","8","8","Au kariwabuei au rava ana neiana-meleiai, dobu au giana da au giana anatapui. Maiteni mata-potapotai ma sigesigei, duaduamai ma tautauvaoi. Dam patara ḡaeḡaena ina nememei. ");
INSERT INTO wed_vpl VALUES ("JR31_9","025_31_9","JER","31","9","9","Ana rupenai ma ana toutoui agu aubaina, ana neiana-meleiai Waira adanei ana taravainiai, etanai abuabunei da eḡa ina peu. Tau Israel amana, Ephraim au natuevou.” ");
INSERT INTO wed_vpl VALUES ("JR31_31","025_31_31","JER","31","31","31","Bada e ririwa i pa, “Mara e nenei maranai parivainuaḡana bagibagina vouna ana kauei mai Israel ma Judah maiteni. ");
INSERT INTO wed_vpl VALUES ("JR31_32","025_31_32","JER","31","32","32","Wei lamna eḡa me noinoi maiteni a kauei nanare; maranai a raunimavoai ma Egyptei a taravaina-opunei. Aubaina au parivainuaḡana i viaigai avena da nuanuai a vaia me oroto awana nuanuana e vaivaia. ");
INSERT INTO wed_vpl VALUES ("JR31_33","025_31_33","JER","31","33","33","Wei parivainuaḡanana mai Israel maiteni ana kauei nai marana au murina.” Bada e ririwa, “Au tarawatu ai au nota ana terei ma au nuanuai ana girumi. Wei ina terekauei da Tau ai God ma taui au rava. ");
INSERT INTO wed_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Ma eḡa ai rava ina viararamana-melei bo riwa vivira, ‘Bada ona aramanei!’ Aubaina au aburuna da au magurina anatapui ina aramaneu. Tau ai ḡoʼapoapoe ana nota-tawanei ma eḡa ana nota-melei.” Bada e ririwa. ");
INSERT INTO wed_vpl VALUES ("JR33_14","025_33_14","JER","33","14","14","Bada i riwa, “Mara e nenei maranai au parivainuaḡana bagibagina mai Israel ma mai Judah maiteni a kaukaueia anona ina tupua. ");
INSERT INTO wed_vpl VALUES ("JR33_15","025_33_15","JER","33","15","15","Nai maranaina, rava kaua David ana damei ina nei; Ma Tauna kaua aiaii ma jijimanii ina kauei au dobu. ");
INSERT INTO wed_vpl VALUES ("JR33_16","025_33_16","JER","33","16","16","Nai au marana Judah ina vilawani ma Jerusalem ana nuaubana ina mae. Wei melagaina ina ḡorei, Bada Tauterevaijijimanita.” ");
INSERT INTO wed_vpl VALUES ("JR38_4","025_38_4","JER","38","4","4","Babadai, gulau Zedekiah i riwei, “Wei ravanana Jeremiah tana viraḡeni. Ana babaniei, sorodia ruaḡauta lawalawai ma rava ḡelaui e viviorabadoi. Tauna eḡa rava ita vovoagui wate e viviorabadoi.” ");
INSERT INTO wed_vpl VALUES ("JR38_5","025_38_5","JER","38","5","5","Gulau i paribelei, “Tauna au urami, ami ḡoana nanare ona kauei. Tau eḡa ana viḡaemi.” ");
INSERT INTO wed_vpl VALUES ("JR38_6","025_38_6","JER","38","6","6","Ma Jeremiah i vaia ma i tere-ḡairei gulau natuna Malkijah, ana au dogo, wei lamna gulau ana sorodia ai au potuma au ririvana. Ma ḡuravei Jeremiah i tere-ḡairei au dogo. Au orana dogodogo ava, ma Jeremiah i monu ḡaira da i mairi dogodogo orana. ");
INSERT INTO wed_vpl VALUES ("LM1_1","026_1_1","LAM","1","1","1","Kapore! Zion wariaḡa am patara i rata ḡaḡa, marina u kwakwava. Dam patarai ai voepaepa, marina i vikaiababa. Wariaḡa dobuḡela gulagulaui ai voepaepa. Tauna i ʼnana ḡaei. Marina i vitaunola. ");
INSERT INTO wed_vpl VALUES ("LM1_2","026_1_2","LAM","1","2","2","E toutou maratom, jirigwegwena au navanavana e toitoi. Ana nuavainana maḡamaḡaui i ruba-tomana, eḡa aiai da ina vinuaubai. Ana rava anatapui i mae-puputei ma i viḡaviei. ");
INSERT INTO wed_vpl VALUES ("LM1_3","026_1_3","LAM","1","3","3","Judah i pani ma i pupuna-naiei. Au dobu ḡela i vivipanipani, e rarau-iviapoapoelei, i vitaomana au dobuḡela. Ḡavia i mae-kwaviviroi, menanare ina onaḡanei? ");
INSERT INTO wed_vpl VALUES ("LM1_4","026_1_4","LAM","1","4","4","Zion etanaina e mogumogu eḡa aiai kampa ita nenae torela aubaina. Ana anirui i kwakwava, Pirisi e gunugunura, ana guguini e vivitouana; Nuapouna i wanagwadgwadai. ");
INSERT INTO wed_vpl VALUES ("LM1_5","026_1_5","LAM","1","5","5","Ana ḡavia i vibada, au urai e mamae. Bada nuabola ḡaeḡaena i neiai Zion awarina aubaina ai ḡoʼapoapoe i rata. Natunatui i paninaiei aueia, ai ḡavia au mataii. ");
INSERT INTO wed_vpl VALUES ("LM1_6","026_1_6","LAM","1","6","6","Kapore wariaḡa Zion na! Wavana naenaena, vinualaulaunana marina mepa? Marina, Zion ana babada lamna me deer, nuanuai i arelei ma i raumolaḡau ma lam i baiana-avei. Inina i garigari ma eḡa tagotagogina da ai ḡavia ina rubatawanei. ");
INSERT INTO wed_vpl VALUES ("LM1_7","026_1_7","LAM","1","7","7","Zion i kwakwava, ravana eḡa. Ana maura, wadubona e vinuanotenotei. Maranai ana rava i peu ai ḡavia au urai, eḡa aiai ita nei da ita rauagui. Ana ḡavia Zion ana peu i ʼnanai ma i vinamei. ");
INSERT INTO wed_vpl VALUES ("LM3_19","026_3_19","LAM","3","19","19","Bada, A tenam nae, eḡa matave kaua, iniviara maiteni, a vinuapoapoe kaua, notana i viḡora kaua. ");
INSERT INTO wed_vpl VALUES ("LM3_20","026_3_20","LAM","3","20","20","A notanota-maelei ma au orau a toutou. ");
INSERT INTO wed_vpl VALUES ("LM3_21","026_3_21","LAM","3","21","21","Wate Bada a vinua-notenotei ma orau e vovovaivirewapani. Lamnei a vitumaḡana: ");
INSERT INTO wed_vpl VALUES ("LM3_22","026_3_22","LAM","3","22","22","da Bada ana nuavaina mamae-nonoana. Ma ana raunuapoapoe eḡa ina kwa. ");
INSERT INTO wed_vpl VALUES ("LM3_23","026_3_23","LAM","3","23","23","Ubaubanai, e raviravivouni; am vipatutu i rata kaua. ");
INSERT INTO wed_vpl VALUES ("LM3_24","026_3_24","LAM","3","24","24","A ririwana-meleu, Bada au buderi lamna a vivitumaḡanem. ");
INSERT INTO wed_vpl VALUES ("LM3_25","026_3_25","LAM","3","25","25","Taui daBada e vivitumaḡanei ma e baibaiei, ina viaiaini. ");
INSERT INTO wed_vpl VALUES ("LM3_26","026_3_26","LAM","3","26","26","I ai da tana volaḡota ma Bada tana paini da ina vilawanita. ");
INSERT INTO wed_vpl VALUES ("LM3_27","026_3_27","LAM","3","27","27","I aii da vilamolamona ma nola ma aramanei. Am au vilaraga, ");
INSERT INTO wed_vpl VALUES ("LM3_28","026_3_28","LAM","3","28","28","maranai Bada e viviaramanita, ma mae genuatau. ");
INSERT INTO wed_vpl VALUES ("LM3_29","026_3_29","LAM","3","29","29","Tana mae-ḡaira au debidebi, mepa da agu ina nei. ");
INSERT INTO wed_vpl VALUES ("LM3_30","026_3_30","LAM","3","30","30","Navanavami ona verei da ina ravi, ma ina vijiboḡimi. Wate eḡa ona vobelei aubaina. ");
INSERT INTO wed_vpl VALUES ("LM3_31","026_3_31","LAM","3","31","31","Bada eḡa ina geduaiana-nonoeta. ");
INSERT INTO wed_vpl VALUES ("LM3_32","026_3_32","LAM","3","32","32","Avena da maraḡela nuabola e neineiai, wate ana raunua apoapoe i rata kaua. Aubaina ana nuavaina i rata kaua, eḡa damona. ");
INSERT INTO wed_vpl VALUES ("LM3_33","026_3_33","LAM","3","33","33","Wate wei kauai eḡa ita vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","Bada ana boruma a inanai ma au doa a peu. Ma a nonori pona i riweu, i pa, “Rava ota natuna, ma vomairi ma awarim ana babani.” ");
INSERT INTO wed_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","I bababani ma God aruana au orau i rui ma i voepaiu ma a nonori awariu i bababani. ");
INSERT INTO wed_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","I riwa, “Rava ota natuna, a pariparitawanem dam paripariviravirai mai Israel awarii. Amamai maiteni eḡa ita voteleteleu ma awariu i pariviravira da marina. ");
INSERT INTO wed_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","Rava paripariviravirai ma orai badobadoi ma eḡa ita vivivireu. A pariparitawanem da ma riwei, ‘Wei Bada riwana.’ ");
INSERT INTO wed_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","Taui paripariviravirai ma ina rautaniḡanem bo eḡa lamna avena, wate ina aramanei da peroveta i ḡetai awarii.” ");
INSERT INTO wed_vpl VALUES ("EK17_22","027_17_22","EZK","17","22","22","Bada God wenanare i riwa, “Tau ai cedar manamanaina nuanuana ana vogai da ana paewi. Raḡana au tepadewadewana nabina ana gai da ola manamanaina au tepana ana paewi. ");
INSERT INTO wed_vpl VALUES ("EK17_23","027_17_23","EZK","17","23","23","Israel ola au tepai ana paewi, ina raḡai ma ina raunumo, ai gulauna. Kiu tapuna ma tapuna au raḡai ina raunoḡi ma au ḡoui ina viḡou. ");
INSERT INTO wed_vpl VALUES ("EK17_24","027_17_24","EZK","17","24","24","Ai anatapui nai au dobuna ina aramanei da tau Bada, ai manamanaii ana taragai ma ai tupotupoii ana voepai. Ma ai majimajiḡana ana vipoini ma ai poina ina raurugu ma ina rata, Tau Bada a babani, ma aiwai a riwei nanare ana kauei.” ");
INSERT INTO wed_vpl VALUES ("EK33_7","027_33_7","EZK","33","7","7","“Rava ota natuna, Tau a vinem tauvineneḡana dam Israel aubai; riwa a vereverem ma nonori ma babani bagibaginei ma riwei. ");
INSERT INTO wed_vpl VALUES ("EK33_8","027_33_8","EZK","33","8","8","Maranai ḡoʼapoapoe ravana a ririwei, ‘Tam, ḡoʼapoapoe ravana, amapo ma i ʼraḡe.’ Ma ravana eḡa uta pariverei da ana ḡoʼapoapoe ita voterei, ma ina iraḡe. Marina ana iraḡe au uram a tereterei. ");
INSERT INTO wed_vpl VALUES ("EK33_9","027_33_9","EZK","33","9","9","Wate mepa da ḡoʼapoapoe ravana u riwei da ana lawana ita virai ma eḡa ana lawana ita virai, ana ḡoa apoe ina iraḡelei, ma tam am lawana ina mae.” ");
INSERT INTO wed_vpl VALUES ("EK34_11","027_34_11","EZK","34","11","11","Bada God wenanare e ririwa, “Tau ainelau au sipu ana baiei ma ana ḡamoi. ");
INSERT INTO wed_vpl VALUES ("EK34_12","027_34_12","EZK","34","12","12","Sipu taupainina, ana sipu kwakokwakoi e baibaiei da e nenemeleiai. Nanare tau, au sipu e kwakokwako-nae. Ana nelaḡai ma ana neiana-meleiai, maranaina dobu i waguvarei ma i gimtonei. ");
INSERT INTO wed_vpl VALUES ("EK34_15","027_34_15","EZK","34","15","15","—Tau ainelau au sipu ana ḡamoi ma ana terei da ina matave kaua, Tau Bada God a babani. ");
INSERT INTO wed_vpl VALUES ("EK34_16","027_34_16","EZK","34","16","16","Tau kwakokwakoi ma nelabalababai ana baiei, ma ana neiana-meleiai. Ma keroi ana bunamai ma ḡokokokarai ana vovaivirewapani. Wate dododoi ma virewapanai ana pupuni. Jijimaninei au sipu ana ḡamoi. ");
INSERT INTO wed_vpl VALUES ("EK34_17","027_34_17","EZK","34","17","17","—Taumi au sipu Tau Bada God a ririwana-kauemi da taumi tagotagogi ava ana rauetaremi. Aiaii ma apoapoei ana vilamonei, sipu ma gote ana vilamonei.” ");
INSERT INTO wed_vpl VALUES ("EK36_16","027_36_16","EZK","36","16","16","Bada i riweu, i pa, ");
INSERT INTO wed_vpl VALUES ("EK36_17","027_36_17","EZK","36","17","17","“Rava ota natuna, maranai Israel ai au dobu i mamae, taui ai kaua apoapoenei ai dobu i vimirai. Tau au matau lamna i vimira-melei me wavine ana nawaravi e vaivaia. ");
INSERT INTO wed_vpl VALUES ("EK36_18","027_36_18","EZK","36","18","18","Marina, au meji ana iwaḡa-tawanei awarii aubaina taui tara i vitoini au dobu, ma nanare kokoitauei dobu i viapoapoeni. ");
INSERT INTO wed_vpl VALUES ("EK36_19","027_36_19","EZK","36","19","19","A vidabararai ma a vilamolamonei au dobuḡela, ai ḡoʼapoapoei ma ai kaua awariei a kovoḡi. ");
INSERT INTO wed_vpl VALUES ("EK36_20","027_36_20","EZK","36","20","20","Wate metauna au dobuna i rui taui wavau vivivireina i vijiboḡi, aubaina nai dobuna ravai e ririwa, ‘Wei lamna Bada ana rava wate ana dobu i opu-tawanei.’ ");
INSERT INTO wed_vpl VALUES ("EK36_21","027_36_21","EZK","36","21","21","A ḡoei da au rava au wava vivivireina ita vimaeḡaeḡaeni, wate noi rava mai Israel dobu anatapui i naeni ma i vitepaubaubaiu. ");
INSERT INTO wed_vpl VALUES ("EK36_22","027_36_22","EZK","36","22","22","—Lamna aubaina, marina dam Israel ma pariverei, Bada God wei i riwei, ‘Tau a neineiana-meleiaimi, eḡa tam am kaua aiaina aubaina. Tau a kaukauei wavau vivivireina aubaina, taumi wavau o viapoapoena-naiei jentail ai au dobu. ");
INSERT INTO wed_vpl VALUES ("EK36_23","027_36_23","EZK","36","23","23","Ana viatataiemi da wavau, ḡetelarana ma vivivireina. Wavau taumi dobu au anatapuna o vitepaubaubai. Taumiei dobu ana viatataiei da tau vivivireu ");
INSERT INTO wed_vpl VALUES ("EK36_24","027_36_24","EZK","36","24","24","aubaina dobudobuai ana taravainimi ma ana neiana-meleiaimi ami au dobu.’ ");
INSERT INTO wed_vpl VALUES ("EK36_25","027_36_25","EZK","36","25","25","—Wairei ana vitoaimi da ona aii, ami mira ma kokoitau viborumai mirana ina oḡa-tawanei. ");
INSERT INTO wed_vpl VALUES ("EK36_26","027_36_26","EZK","36","26","26","Ma nuanuami vouna, ma aruami vouna ana veremi. Nuanuami badobadoi ana votawanei ma aiaina ana terei. ");
INSERT INTO wed_vpl VALUES ("EK36_27","027_36_27","EZK","36","27","27","Ma Aruau au oram ana terei da au tarawatu ma au viararamana ona votaḡotaḡoi.” ");
INSERT INTO wed_vpl VALUES ("EK37_1","027_37_1","EZK","37","1","1","Bada i raunimavoaiu ma aruanei i naieu da gwagwa ḡaeḡaena au pouna i tereu, rava gelamii gwagwanana i oai. ");
INSERT INTO wed_vpl VALUES ("EK37_2","027_37_2","EZK","37","2","2","Gwagwanana a naeni ma a inanai da gelama i maḡa guratana ma i poi. ");
INSERT INTO wed_vpl VALUES ("EK37_3","027_37_3","EZK","37","3","3","I paridadaneu, “Rava ota natuna, amapo wei gelamii ina virava me bo eḡa?” A paribelei, “Oo! Bada God, tam ainelam u aramanei.” ");
INSERT INTO wed_vpl VALUES ("EK37_4","027_37_4","EZK","37","4","4","Ma i riweu, “Riwauei gelama ma riwei, ‘Gelama poii, Bada riwana ona nonori.” ");
INSERT INTO wed_vpl VALUES ("EK37_5","027_37_5","EZK","37","5","5","Bada God wenanare gelama i riwei, “Lavutu au orami ana terei ma ona lawana me! ");
INSERT INTO wed_vpl VALUES ("EK37_6","027_37_6","EZK","37","6","6","Vioa ma warowaro ana veremi, ma opi da gelama ina purui. Ma lavutu ana veremi da ma lawana. Kampa ma aramanei da Tau Bada.” ");
INSERT INTO wed_vpl VALUES ("EK37_7","027_37_7","EZK","37","7","7","I ririweu nanare a babani, a vikarei da a bababani ma dobuna ura ketarana i nae da dobuna i oai, gelama anatapui i vitagogiei. ");
INSERT INTO wed_vpl VALUES ("EK37_8","027_37_8","EZK","37","8","8","A inainana ma warowaro ma vioa gelama au tepana i ampasi ma au tepai opi i tupua da i purui, wate awari eḡa lavutu. ");
INSERT INTO wed_vpl VALUES ("EK37_9","027_37_9","EZK","37","9","9","Ma i riweu i pa, “Rava ota natuna, Bada God riwanei ive ma riwei, ‘Bada God e ririwa, ive meiei da meiei e uveuvena, au orami lavutu ina opui ma taubeu patarai e matamatave ona uveni da ina lawana me.” ");
INSERT INTO wed_vpl VALUES ("EK37_10","027_37_10","EZK","37","10","10","Ma i ririweu nanare a babani, ma lavutu ravai tupuai i ruini. Anatapui i lawana ma i mairi sorodia boruna ḡaeḡaena. ");
INSERT INTO wed_vpl VALUES ("EK37_11","027_37_11","EZK","37","11","11","I riwa me, “Rava ota natuna, mai Israel lamna me wei gelamii. Taui e ririwa i pa, ‘Tauta gelama poi ava ma ata tumaḡana i kwa, ata dam i kwa.’ ");
INSERT INTO wed_vpl VALUES ("EK37_12","027_37_12","EZK","37","12","12","Lamna aubaina ma riwana-melei, Bada God wenanare e ririwa, ‘Ona inana! Ami kokoaga ana votawanei ma ana voepaemi ma ana neiana-meleiaimi au Israel.’ ");
INSERT INTO wed_vpl VALUES ("EK37_13","027_37_13","EZK","37","13","13","Au rava! Maranai wei i tupua, ona aramanei da Tau Bada. ");
INSERT INTO wed_vpl VALUES ("EK37_14","027_37_14","EZK","37","14","14","Ma Aruau au orami ana terei ma ona lawana ma ana neiana-meleiaimi ami au dobu oina. Maranaina, ona aramanei da Tau Bada. Ee! A ririweia; ana kauei.” ");
INSERT INTO wed_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Waguvarai inana a inanai, ma kaua aiwai a inanai me Rava Natuna apau oraninei i nenei, ma i taravaina-naieiMaemae Nonoana awarina. ");
INSERT INTO wed_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Maemae Nonoana vibadana ma rewapana ma vimaeḡaeḡaena, tauna i verei da ina vibada, da dam anatapui ma dobu anatapui ai ponei ina voepaepai ma ina voteletelei. Ma ana rewapana ina mae-nonoa, ma ana vigulau vibadana eḡa ina kwa. ");
INSERT INTO wed_vpl VALUES ("DN12_1","028_12_1","DAN","12","1","1","Ma nai maranaina anela vivirewapanana Michael, Israel ana taugagalo, ina eḡa. Amapo nuabola ḡaeḡae otana ina nei, eḡa melanai nanare tata inainanai, au karena da marina. Wate wei au marana rava aiavoi da wavai au buka i girugirumia ina lawana. ");
INSERT INTO wed_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","Maḡamaḡaui irairaḡei ina vomairi me, ma ina nae, ḡelaui au lawana maemae nonana ma ḡelaui vinimala maemae-nonoana. ");
INSERT INTO wed_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","Rava nuaulaulaui ina lalai me mara madeḡana. Ma taui maḡamaḡaui e raveraveni da lawana jijimanii e maemaeni, ina lalai me ubona. ");
INSERT INTO wed_vpl VALUES ("HS11_1","029_11_1","HOS","11","1","1","Bada Hosea i riwei, i pa, “Maranai Israel ana au vitevera, a vinuavainei ma Egyptei a ḡore-opunei. ");
INSERT INTO wed_vpl VALUES ("HS11_2","029_11_2","HOS","11","2","2","Wate a viḡoreḡore ma tauna amapo da i nenetawaneu. Tauna ana pulo i apuapui Baal awarina, ma daji ḡabuḡabui, i apuapui kokoitau ḡelaui awarii.” ");
INSERT INTO wed_vpl VALUES ("AM8_4","031_8_4","AMO","8","4","4","Ona rautaniḡana! Taumi voladaḡai o kwalekwalei ma molamolakai o tugwadagwadai. ");
INSERT INTO wed_vpl VALUES ("AM8_5","031_8_5","AMO","8","5","5","O ririwa, nawaravi vouna torelana ina kwa laḡilaḡina ma Sabate ina kwa. Ma witi tana gimarei, witi ruva aburuna tana terei ma maiana tana ḡaiḡaiei ma sikere morumorunei tana gimagimarei. ");
INSERT INTO wed_vpl VALUES ("AM8_6","031_8_6","AMO","8","6","6","Witi loḡiloḡii o tami da witi o tavipotoi ma o gimarei ma lamnei, molamolakai o gimarai ami taunola. Taui maiai me busi, maiana aburuna. ");
INSERT INTO wed_vpl VALUES ("AM8_7","031_8_7","AMO","8","7","7","Bada parivainuaḡana-bagibagina, ana wava i kauei, nai wavana mai Israel e vimaeḡaeḡae, I pa, “Ami ḡoʼapoapoei eḡa melanai nuanuau ina vuru.” ");
INSERT INTO wed_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Mara tagogi Bada, Amitai natuna Jonah i riwei, ");
INSERT INTO wed_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Ma vomairi ma nae au taon ḡaeḡaena Niniveh. Ma riwei, da ai ḡoʼapoapoei a inanai da i rata kaua ma lamna aubaina ana kovoḡi.” ");
INSERT INTO wed_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Wate Jonah, Bada i voterei ma etanai ḡelauna i vaia ma ina ruba ḡaira au Joppa. Ma kampa waga i nenae au Tarshish i nelaḡai. I vimaia ma i geru da ita nae. I notai daBada ita ruba govaḡei. ");
INSERT INTO wed_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Wate Bada kojikojira ḡaeḡaena i paritawanei da waga ita viairikarikai. ");
INSERT INTO wed_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Waga ravai ai lawana aubaina i rovo-kaukaua ma ai god awarii i tou agu aubaina, ma purapura au boga i viorereni da waga ita telatela. Wate Jonah waga au orana i raunuavuru. ");
INSERT INTO wed_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Kapena i ḡaira awarina ma i eni i pa, “Mara i apoapoe ḡaḡa ma e matamatave! Ma vomairi, ma tou am god awarina da ina voaguita. Mepa da ina raunuʼapoapoeleta da eḡa tana iraḡe.” ");
INSERT INTO wed_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Waga ravai i babani vivira i pa, “Ḡaima tana vikalokaloei da tana aramanei aiai ana wavu.” Kalona i kauei ma wavuna Jonah awarina i peu ");
INSERT INTO wed_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ma taui Jonah i paridadanei, “Aiwai aubaina kojikojira awarita i peu? Tam aiai? Tam am nola aiwai, tam meiei?” ");
INSERT INTO wed_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Jonah taui i paribelei i pa, “Tau Hebrewei ma tau Bada, Mara ana God a voepaepai, Tauna boga ma doa i kauei.” ");
INSERT INTO wed_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Waga ravai i rovo kaukaua ma i vigaragararei, “Aiwai aubaina lamna u kauei!” Jonah boiboḡi i vieḡa da tauna Bada i rovoei da i rubaruba. ");
INSERT INTO wed_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Mara i apoapoe kaua ma taui Jonah i vitaravirevirei, “Aiwai tana kauei da kojikojira ina kwa?” ");
INSERT INTO wed_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Jonah i riwa, “Ona tawaneu au boga ma ive ina raumairiei. Aramanei da tau au kauelei wei ivena i vomairi.” ");
INSERT INTO wed_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Wate waga ravai i lare-guratana da waga ita ḡairei au gera, wate eḡa tagotagogina, kojikojira i voguratei. ");
INSERT INTO wed_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Anina ma taui anatapui i tou Jonah ana God awarina i pa, “Oo Bada! eḡa ma voterelai da wei ravana ana ḡoʼapoe aubaina, ana iʼraḡe, ma eḡa tarana wavuna ana avarai!” ");
INSERT INTO wed_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ma Jonah i vojijini ma i tawana-opunei au boga ma maratagogi kojikojira i wanatuini ma daumora i matave. ");
INSERT INTO wed_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ma ravai i rovoana-kauei da pulo i apui Bada awarina ma i parivainuaḡani da tauna ina vivirei. ");
INSERT INTO wed_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Wate Bada iana ḡaeḡaena i paritawanei da Jonah i lawani. Ma Jonah iana au manawana i mae aupom ma waguvara tonuḡa. ");
INSERT INTO wed_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jonah iana au manawana ma i raupari Bada, ana God awarina. ");
INSERT INTO wed_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","I pa, “Au nuabola au orana a tou Bada awarina, ma i paribeleu. Irairaḡei, ai au dobu ma agu a gararei ma au tou u nonori. ");
INSERT INTO wed_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Au gabinou u tawana ḡaireu, boga au gabaura dewadewana. Boga i kwaviviroiu. Rabamam ḡaeḡaei i viaimonumonui. ");
INSERT INTO wed_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Oo Bada! A notai da tau u tereopuneu, ma a notai da eḡa melanai am tempol vivireina ana inana-melei.” ");
INSERT INTO wed_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","“Boga i puruiu lavutui i tupo ma aragoma kolau i pani. ");
INSERT INTO wed_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","A monu ḡaira ola au kare dewadewana, a vipanipani nai au dobuna, dobuna metaetana guduguduna maemaena. Wate tam Bada au God, u vilawaniu. Lawalawaiu gabinouei u sinaepaiu, ");
INSERT INTO wed_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Malana a vaia au lawana i opuopu, ma Bada a raupari awarim, am au tempol, ma u nonoriu. ");
INSERT INTO wed_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Taui kokoitau labalababa e viviborumei, am nuavaina mamae-nonoana i geduaiei. ");
INSERT INTO wed_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Wate tau ana welem, ana voepaepaim ma au pulo ana apui awarim. Au parivainuaḡa awarim ana kauei lawana maemae nonoana Badei e nenei.” ");
INSERT INTO wed_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ma Bada iana i egari da Jonah i medana-tawanei au gera. ");
INSERT INTO wed_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ma Bada i babani me Jonah awarina, ");
INSERT INTO wed_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","I pa, “Ma nae taon ḡaeḡaena vinualaulaunana Niniveh ma au riwa a vereverem ma pariverei.” ");
INSERT INTO wed_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jonah, Bada riwana i voteletelei ma i nae au Niniveh. Niniveh lamna taon ḡaeḡae otana ma aupom tonuḡa i vaia da i verautuini. ");
INSERT INTO wed_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jonah i vikarei nai au taona ma aupom tagogi i babara ma i jima i pa, “Aupom 40 ina kwa ma Niniveh ina pupu.” ");
INSERT INTO wed_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Mai Niniveh Bada riwana i vitumaḡanei ma i vioga da anatapui magurina da aburuoina i vianina tagogi da ina uji ma uji garana i oteni da ina vimataira. ");
INSERT INTO wed_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Maranai Niniveh ana gulau wei riwana i nonori, tauna ana anikiala i opu-tawanei ma ana gulau garana i ḡiḡi. Uji garana i oteni ma au lapukare i kiala. ");
INSERT INTO wed_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ma mai Niniveh awarii wei vinolanolana bagibagina i paritawanei tauna au wavanei. Wenanare i riwa: Eḡa rava bo bulumakau bo sipu, aiwai ina ani bo ina umai. ");
INSERT INTO wed_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Ma ḡamoḡamo ma rava uji garana ina oteni ma ina raupari guratana Bada awarina. Ma kaua apoapoe ma ḡoaḡai ina geduaiei. ");
INSERT INTO wed_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Aiai i aramanei? Mepa da God nuanuana ina amviravira ma nuavainei ana meji ina vojijini da eḡa ina pupunita. ");
INSERT INTO wed_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Maranai God inanai aiwai i kaukauei ma menanare ai kaua apoapoe i geduaiei, Tauna nuanuana i virai ma eḡa ita pupuni. ");
INSERT INTO wed_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Wate Jonah wei ogana eḡa ita ḡoei ma amlona i ḡaiḡai kaua. ");
INSERT INTO wed_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ma i raupari Bada awarina, i pa, “Bada a notai da amapo nanare ita tupua muriai da au melagai ata opu-tawanei. A ʼramanei da tam God raunuapoapoem ma iviaiaim, eḡa laḡilaḡina amlom ita voḡaiḡai ma am nuavaina maemae-nonoana. Tam eḡa am ḡoana da ḡoʼapoapoe ravai ma pupuni wate ma tere-kauei. Lamna aubaina a ruba nae au Tarshish. ");
INSERT INTO wed_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ma marina Bada, au lawana ma vaitawanei, i ai da ata iraḡe ma avena ata mae!” ");
INSERT INTO wed_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Wate Bada i paribelei, i pa, “Tam aiwai e ḡaiḡaiawei?” ");
INSERT INTO wed_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jonah i opu melagai au metaetana, au maramatanei. Kampa ḡou i voepai ma au gabaurina i kiala ma i vipaipai da Bada aiwai ita kauei nai taona awarina. ");
INSERT INTO wed_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ma Bada ḡoroḡorova i vigogoi da i tuaḡeta Jonah au tepana da ana ḡou. Ma Jonah wei i vinuaiaina-kauei. ");
INSERT INTO wed_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Wate ubaubana boiboḡi aupom ḡela, Bada motamota i paritawanei da ḡoroḡorovana i ani da iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Maranai madeḡa i gogo, God ive maramatanei i paritawaneiai. Ma madeḡa Jonah kolana i rarani da i ḡokokokara. I ḡoei da ita iraḡe ma i riwa, “Iraḡe i aii, eḡa me lawana.” ");
INSERT INTO wed_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Wate God Jonah i paridadanei, “Am nola aiwai da amlom i ḡaiḡai kaua wei ḡoroḡorovana awarina?” Jonah i paribelei, “Amloi i ḡaiḡai kaua da a ḡoei ana iʼraḡe.” ");
INSERT INTO wed_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Bada i riwa, “Wei ḡoroḡorovana u vivinuabolei lamna eḡa tam uta kauei bo uta paini. Tauna waguvarai i gogo ma waguvarai iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Wate nai taon ḡaeḡaena Niniveh ma ana patara 120,000, taui gimtona taumaenina ma ai ḡamoḡamo maḡamaḡaui. Wei taona a vinuabolei tapa?” ");
INSERT INTO wed_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Sorodia ona vomairi! Ona vokaukaua! Ḡavia Jerusalem i matave kwaipipini. Israel ana gulau ina kwapui, jiḡonei navanavana ina kwapui. ");
INSERT INTO wed_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Tam, Bethlehem Ephrathah, melaḡai aburu oina dam Judah au orai. Wate awarimiei, Israel ai gulau ina opu. Tauna wariaḡana, au karena da marina. ");
INSERT INTO wed_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Bada mai Israel i voterei ai ḡavia au urai, da wavine marina au manawa, tevera orotona ina ḡuni. Ma ai rava ḡelaui a tuvai-opunei, ina nememei ai au gana au Israel. ");
INSERT INTO wed_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Tauna Bada ana rewapanei, ina mairi ma ana sipu ina raveni, ana vinualaulaunei ma Bada wavana ḡaeḡaenei. Rava anatapui au dobu, Tauna ina vivirana-kauei ma lamna aubaina taui kampa ina mae-kaua. ");
INSERT INTO wed_vpl VALUES ("ZC9_9","039_9_9","ZEC","9","9","9","Bada i riwa, “Ona morelana Zion Ona logoimi Jerusalem, ona inana! Ami gulau e nenei awarim. Orana Jijimanina ma ana ḡavia i vovaiubai. Ana volaḡotana donkey e gerugerui, donkey ḡaubona i gerui. ");
INSERT INTO wed_vpl VALUES ("ZC9_10","039_9_10","ZEC","9","10","10","Dam Ephraim awarii Chariot ina vaitawanei, ma Jerusalem awari ḡavia horse ina vaitawanei. Ma viḡavia ana pidu ina gai. Tauna rom ina neiai. Ma ana vibada boga i taḡoni da au boga ḡela, au waira Euphrates da dobu au gia dewadewana.” ");
INSERT INTO wed_vpl VALUES ("ZC12_10","039_12_10","ZEC","12","10","10","Tau-Bada, David ana epaepaia ma mai Jerusalem awarii, raunuapoapoe ma rupena aruana ana iwagi. Taui ina taepai ma i tonatonaiu ina inanai, ma ina touei ma ina moguei me rava natuna tagotago iʼraḡe; me natuevouna ina irairaḡe. ");
INSERT INTO wed_vpl VALUES ("ZC12_11","039_12_11","ZEC","12","11","11","Nai marana, tou ma tarakwatu au Jerusalem ina rata kaua me au Hadad-Rimmon au wapuna, au Meggido maranai gulau Josiah i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("ZC13_1","039_13_1","ZEC","13","1","1","Bada Virewapana Kaukauana i riwa i pa, “Mara ina ḡetai maranai vuvura ina votawanei au Jerusalem. David ana epaepaia ma mai Jerusalem anatapui ina nei ma ai ḡoʼapoapoe ma ai mira ina oḡa-tawanei.” ");
INSERT INTO wed_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wei lamna Iesu Keriso Messiah God natuna Riwana Aiaina karena. ");
INSERT INTO wed_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wariaḡa peroveta Isaiah i girugirumia nanare: ");
INSERT INTO wed_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Peroveta au mutulua e viviḡoreḡore: ");
INSERT INTO wed_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ma taupariverena John i nei au mutulua da rava i bababataitoi ma God riwana i jimejimei i pa, “Ami ḡoʼapoapoe ona voterei, ma ona mae-taviremi God awarina ma ami ḡoʼapoapoe ina nota-tawanei ma ana babataitoimi.” ");
INSERT INTO wed_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma rava anatapui Judea au paratana ma au Jerusalem i nae da John ita rautaniḡanei. Maranai ai ḡoʼapoapoe i rupeni, John, taui i babataitoi au waira Jordan. ");
INSERT INTO wed_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma John, kamel aparana metametanana i oteoteni ma ana tairoro ḡamoḡamo opina. Ana lam kapau ma manigewa. ");
INSERT INTO wed_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma tauna, rava i ririwei i pa, “Rava au muriu e nenei i ḡetelara, eḡa me tau. Eḡa tagotagogiu da ana ae uma ḡuravana ana rupeni. ");
INSERT INTO wed_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tau wairei a babataitoimi, wate tauna, Arua Vivivireinei ina babataitoimi.” ");
INSERT INTO wed_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lamna maranaina Iesu, Nasaret, Galili i netawanei ma i nei ma John au waira Jordan, tauna i babataitoi. ");
INSERT INTO wed_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma maranai Iesu wairei i ḡeḡetai, i ʼnana da mara i wanatawanei ma Arua Vivivireina me gabubu i ḡairai. ");
INSERT INTO wed_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma God ponana marei i opu ma i riwa i pa, “Tam, tau natu au nuavaina ma u vinuaiainiu.” ");
INSERT INTO wed_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma lamna au murina God Aruana Vivivireina Iesu i paritawanana-opunei au mutulua. ");
INSERT INTO wed_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma au pom 40 au mutulua i mae. Ma Satan, tauna i rauelari. Ḡamoḡamo ḡaiḡaiawai nai au dobuna i mamae ma God ana anela marei tauna i paini. ");
INSERT INTO wed_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ma gulau Herod, John i pani. Ma muriai Iesu i nae au Galili da rava awarii God Riwana Aiaina i jimei. ");
INSERT INTO wed_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ma Iesu i ririwa i pa, “God ana mara vinevinena i ḡetai. God ana vibadana vouna rava aubai, lamna i turiai. Ami ḡoʼapoapoena ona rupeni ma ona mae-tavirem ma Riwana Aiaina ona vitumaḡanei!” ");
INSERT INTO wed_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mara tagogi Iesu Galili topana au gerana i bababara nae. Ma lebalebaḡai ruaḡa i ʼnanai, Simon ma ana tevera Andrew au topa i rarauagida. ");
INSERT INTO wed_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu i riwei i pa, “Ona nei ma ona votaḡotaḡoiu. Ma me marina iana o tutuarui; nanare, ana viararamanimi da rava ona tuarui da ina vitumaḡaneu!” ");
INSERT INTO wed_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma maratogogi ai agida i voterei ma Iesu i votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma taui au gera i verau-nae. Iesu, Zebedi natunatuna i ʼnanai, James ma John ai au waga ai agida wanawanarorona i vokaukauei. ");
INSERT INTO wed_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma maratagogi taui i ḡorei, “Taumi ona nei ma ona votaḡotaḡoiu!” Ma taui amai Zebedi ana taunola maiteni i voterei ma Iesu i votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu ana Tauvotaḡotaḡo maiteni i nae au Capeniam. Ma au Sabat, Iesu i rui au pari numana ma God Riwana Aiaina, viararamanana i vikarei. ");
INSERT INTO wed_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tauna ana rewapanana i viararamana eḡa me mai Jew ai tarawatu babadai nanare. Ma taurautaniḡana ana viararamana i baiei. ");
INSERT INTO wed_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Maranai Iesu pari au numana i viviararamana ma oroto arua-apoapoena orana i ruiruinia i garara ");
INSERT INTO wed_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","i pa, “Iesu Nasaretei, aiwai e ḡoeḡoei awariai. Tam weka u nei da ma viapoapoeniai bo? Tau a aramanei tam aiai. Tam Vivivirem Godei!” ");
INSERT INTO wed_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Iesu riwa bagibaginei i riwei i pa, “Ma genuana! Nai orotona ma opu-tawaneii!” ");
INSERT INTO wed_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma arua-apoapoena orotona i viaikwajiei ma ponana i rata, i garara ma i opu-tawanei. ");
INSERT INTO wed_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma rava anatapui i bana-kauei ma taui ava i vitarapiri, “Wei aiwai? Wei viararamana vouna ma ana rewapana maiteni! Wei ravana awarina rewapana e mamae da arua-apoapoena i riwei ma tauna i vovoteletelei!” ");
INSERT INTO wed_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iesu nolana, maratagogi i tua Galili au anatapuna. ");
INSERT INTO wed_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nai marana pari numana i opu-tawanei ma ana tauvotaḡotaḡo maiteni i nae Simon ma Andrew ai au numa. James ma John maiteni i nae. ");
INSERT INTO wed_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon poiana wavinena ini ḡuḡurana ana au animatave i matamatave ma maranai Iesu i ḡeta ma numa ravai, tauna i pariverei. ");
INSERT INTO wed_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tauna i nae wavine awarina, nimana i vojijini ma i voagui da i vomairi. Lamna maranaina, ini ḡuḡurana i voterei ma wavinena, taui i paini. ");
INSERT INTO wed_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma au bigai madeḡa i neulai au murina, rava, ai rava doridoriai ma aiavoi arua-apoapoei au orai maemae, i neiai Iesu awarina. ");
INSERT INTO wed_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma rava anatapui nai au melagaina i vitagogiei numa au metaetana. ");
INSERT INTO wed_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Iesu, maḡamaḡaui ai doria nununai i vilawani ma arua-apoapoe maḡamaḡaui rava awari i viaḡaḡana-opunei. Ma arua-apoapoena i aramanei da tauna anina God natuna ma lamna aubaina taui i viḡaei da i genuana. ");
INSERT INTO wed_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ubaubanai boiboḡi, Iesu i vomairi ma numa i opu-tawanei ma i nae gabu au genugenuanana. Ma kampa, God awarina i raupari. ");
INSERT INTO wed_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Muriai, Simon ana rava maiteni i nae da i baiei. ");
INSERT INTO wed_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma maranai Iesu i nelaḡai, ma i riwei i pa, “Rava anatapui e baibaiem.” ");
INSERT INTO wed_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesu i paribelei i pa, “Tana nae taon ḡelaui au ḡereḡere, ma kampa maiteni God Riwana Aiaina ana raugugulei. Tau wei lamna aubaina a nei.” ");
INSERT INTO wed_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma Galili au anatapuna i naeni ma pari au numai i raraugugula ma arua-apoapoei i viopuni. ");
INSERT INTO wed_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Anina ma rava awarina opi doriana, i nei Iesu awarina ma au naona i peu ma i raudune ma agu i vibaḡei i pa, “Mepa da ma ḡoei, anina da ma viaiainiu.” ");
INSERT INTO wed_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma Iesu nuabola orana i oai ma urana i viloloi da i vodadani ma i riwa i pa, “Anina a ḡoeḡoei, ma aii!” ");
INSERT INTO wed_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma maratogogi opi-doriana, oroto i voterei ma tauna i aii me. ");
INSERT INTO wed_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Anina ma Iesu i riwana-guratei i pa, ");
INSERT INTO wed_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tam ma nae! Aiwai i tuputupua awarim, eḡa rava ma vieḡei! Ma jijimanina ma nae pirisi pulo tau apuna awarina ma vietataiana-melem ma viaiaina pulona Moses i ririweia ma kauei da ina vimataira taui awari! Pirisi pulo tauapuina ana vianina ina verei da tam u lawana.” ");
INSERT INTO wed_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wate orotona i nae ma aiwai awarina i tuputupua lamna melagai au anatapuna i babaniana-naiei. Ma lamna aubaina Iesu melagai anatapui i vorei ma mepa eḡa rava ita mamaelana kampa i nae. Wate rava mepa maemaei i nei Iesu awarina. ");
INSERT INTO wed_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iesu ana tauvotaḡotaḡo maiteni i wanavira-melei au Capeniam. Ma au pom ruaḡa au murina, rava nolana i nonori da tauna i nememei au melagai. ");
INSERT INTO wed_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma rava maḡamaḡaui i vitagogiei au numa. Patara i rata guratana da numa i oai ma metaeta maiteni i mae-potai. Iesu, God riwana i raraugugulei. ");
INSERT INTO wed_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nelara ruaḡa ma ruaḡa, oroto gwaḡagwaḡana rasirasiei i avarai da i neiai Iesu awarina. ");
INSERT INTO wed_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rava i maḡa guratana ma eḡa tagotagogina da ita neiai Iesu awarina, lamna aubaina da tetelei i amḡaena da au poewa ma gavogavo i bauni ma kampa gwaḡagwaḡana ana rasirasina i tere-ḡairei Iesu au naona. ");
INSERT INTO wed_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma Iesu, nai ravai i ʼnanai da ai vitumaḡana i rata, lamna aubaina gwaḡagwaḡana i riwei i pa, “Natu, am ḡoʼapoapoei, a nota-tawanei.” ");
INSERT INTO wed_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Anina mai Jew ai tarawatu babadai ḡelaui kampa i kiakiala, au orai i vinua-notanota i pa, ");
INSERT INTO wed_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“God ainelana ḡoʼapoapoei e notanota tawanei. Aiwai aubaina wei ravana nanare e bababani? Tauna, God e vivijiboḡi ma e ririwa da tauna, God nanare.” ");
INSERT INTO wed_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Maratagogi, Iesu Aruanei ai nota i vaia ma i riwei i pa, “Aiwai aubaina wei kauai o vivinua-notenotei? ");
INSERT INTO wed_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Metauna i telatela: ḡwaḡagwaḡana ata riwei, ‘Am ḡoʼapoapoe a nota-tawanei.’ Bo ata riwei, ‘Ma vomairi, am animatave ma vaia ma ma babara?’ ");
INSERT INTO wed_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A ḡoei da taumi ona aramanei da Rava Natuna au dobu ana rewapana e mamae da rava ai ḡoʼapoapoe ina nota-tawanei ma ina vilawani.” Ma gwaḡagwaḡana i riwei i pa ");
INSERT INTO wed_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A riwem, ma vomairi, am animatave ma vaia ma ma nae au numa!” ");
INSERT INTO wed_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Orotona i vomairi ma maratagogi aravi i vaia ma i babara nae. Ma patara i raraubiga, i bana-kauei ma God i voepaepai ma i ririwa, “Tauai eḡa melanai kaua wenanare ata inanai!” ");
INSERT INTO wed_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu, Capeniam i voterei ma Galili topana au gerana i bababara ana tauvotaḡotaḡo maiteni. Ma patara i nei awarina ma tauna God riwana viararamanana i vikarei. ");
INSERT INTO wed_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma i verau-nae aburuna ma Apius natuna Levi i ʼnanai, ana bagibagi au gabuna i kiakiala ma tax i tamitami Rome gabemanina aubaina. Iesu i riwei i pa, “Ma votaḡotaḡoiu!” Levi i vomairi ma i votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tax tautami ma ḡoʼapoapoei ravai maḡamaḡaui, Iesu ma ana tauvotaḡotaḡo i votaḡotaḡoi. Ma anatapui, Levi ana au numa i kiala gogona ma i amam. ");
INSERT INTO wed_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tarawatu Babadai ḡelaui lamna Pharisi, ma taui i ʼnanai da Iesu tax tautami ma ḡoʼapoapoe ravai maiteni i amam. Anina ma Iesu ana tauvotaḡotaḡo i riwei i pa, “Aiwai aubaina Iesu tax tautami ma ḡoʼapoapoei ravai maiteni e amam?” ");
INSERT INTO wed_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma maranai Iesu wei riwana i nononori ma taui i riwei i pa, “Rava lawalawai, doketa eḡa ita ḡoeḡoei ma rava doridoriai, doketa e ḡoeḡoei. Tau a nei ḡoʼapoapoei ravai aubai ma eḡa rava jijimani aubai.” ");
INSERT INTO wed_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mara tagogi, John Taubabataito ma Pharisi ai tauvotaḡotaḡo i ujiuji. Ma rava ḡelaui i nei Iesu awarina ma i vitara-virevirei, “Aiwai aubaina John Taubabataito ma Pharisi ai tauvotaḡotaḡo e ujiuji, wate tam am tauvotaḡotaḡo eḡa ita ujiuji?” ");
INSERT INTO wed_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu i paribelei i pa, “Taumi o notanotai da taui aiavoi i raukwatuei tavine ana au torela, ina mae lota bo? Eḡateni kaua! Maranai tavitavine vou orotona, taui maiteni e mamae, taui eḡa ina uji. ");
INSERT INTO wed_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wate mara ina ḡeta maranai tavitavine vou orotona ina vaitawanei ma lamna maranaina ana rava ina uji.” ");
INSERT INTO wed_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma riwa e mamae, “Tau kaua vouna a neiai eḡa me taumi ami kaua wadubona nanare. Eḡa aiai ravana, gara vounei gara au wadubona ina popo-ratui da gavogavo ina vopotai. Mepa da nanare lamna, gara vouna gara wadubona ina roroi ma gavogavo ina rata. ");
INSERT INTO wed_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma nanare, eḡa aiai wine vouna ina vaini da wine aniterenana wadubona ḡamoḡamo opinei au orana ina iwaḡi. Mepa da ina kauei, lamna wine vouna ina dodo ma wine aniterenana wadubona ina viairoroi ma wine ma aniterenana ina wanabauni. Wate wine vouna, anina da wine aniterenana vouna au orana ina iwaḡi.” ");
INSERT INTO wed_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mara tagogi au Sabat, Iesu ana tauvotaḡotaḡo maiteni, witi wapuna au orana i nenae. Ma ana tauvotaḡotaḡo witi rovei i vaini ma i amam. ");
INSERT INTO wed_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pharisi ḡelaui i ʼnanai wei kauana i kaukauei ma taui Iesu i riwei, “Ma inanai, ata Tarawatu e mamae da Sabat, lamna lauvitau ana mara. Aiwai aubaina taui e vovobagibagi?” ");
INSERT INTO wed_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu i paribelei i pa, “Me peroveta i girugirimia nanare. David ana tauvotaḡotaḡo maiteni am-iraḡe ma aiwai i kauei? Taumi o iavi ma aiwai aubaina anona, eḡa ota vinua-notenotei? ");
INSERT INTO wed_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pirisi Ḡeḡetelarana Abiathar ana au mara, David, God ana au numa i rui ma palawa vovivirana i vaia ma ḡelaui ana tauvotaḡotaḡo maiteni i verei da i ani. Moses ana Tarawatu e mamae da pirisi ava palawana e aniani.” ");
INSERT INTO wed_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma Iesu ana riwa au damona i riwa i pa, “God, Sabat i kauei da rava voaguna aubaina ma eḡa rava ita kauei Sabat voaguna aubaina. ");
INSERT INTO wed_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ona vinuanotenotei, tau Rava Natuna, lamna aubaina tau anina Sabat badana.” ");
INSERT INTO wed_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mara ḡelauna au Sabat, Iesu i naeme au pari numana ma oroto urana irairaḡena i ʼnanai kampa i kiakiala. ");
INSERT INTO wed_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma Pharisi ḡelaui i ḡoei da aiwaiei Iesu ita viwavui. Lamna aubaina i ʼnana-taḡotaḡoi da oroto ita vilawani bo eḡa au Sabat. ");
INSERT INTO wed_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma Iesu, orotona i riwei, “Ma nei, au naoi ma mairi!” ");
INSERT INTO wed_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma Iesu, ravai i vitara-virevirei i pa, “Sabat au marana, metauna i aii: Aiaina tana kauei bo apoapoena? Tana vilawana bo tana viraḡena? Tarawatu aiwai i riwei?” Ma anatapui i genuana. ");
INSERT INTO wed_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu ana amloḡaiḡaina i ʼnana viravira ma i ʼnanai da taui orai i bado ma nuanuana i bola-kauei. Ma orotona i riwei i pa, “Uram ma viloloi!” Ma i viloloi ma i lawana. ");
INSERT INTO wed_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma Pharisi maratagogi i opu ma i nae Herod ana rava awarii ma ai oga i tarai da Iesu mena ita viraḡenanei. ");
INSERT INTO wed_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Iesu ana tauvotaḡotaḡo maiteni, taui i netawanei ma i nae au gera da ita vilauvitau; ma mai Galili patara ḡaeḡaena i votaḡotaḡo. Rava maḡamaḡaui, Iesu aiwai i kaukaueia nolana i nonori ma mai Galili ma Judea, Jerusalem taon, Idumea ma taon ḡelaui waira Jordan taon au babagelauna, Taia taon ma Sidon taon, taui anatapui i nei Iesu awarina. ");
INSERT INTO wed_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Iesu, rava maḡamaḡaui i vilawani. Ma lamna aubaina doridoriai maḡamaḡaui i viviamdudu ma i ḡoei da tauna ita vodadani. Lamna aubaina ana tauvotaḡotaḡo i riwei da waga i vokaukauei. ");
INSERT INTO wed_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Maranai, arua-apoapoei rava au orai maemaei, Iesu i ʼnanai ma au naona i peu ma i garara, “Tam God Natuna!” ");
INSERT INTO wed_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma Iesu taui i viḡaei da avena ita vieḡa da tauna aiai. ");
INSERT INTO wed_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Anina ma Iesu i ḡae au ola ma ana ḡoanei nanare, rava i kwatuei da awarina i ḡei. ");
INSERT INTO wed_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tauna, nelara 12 i vinei da maiteni ita mae ma muriai ita paritawanei da ita raugugula. Ma i ḡorei Apasol. ");
INSERT INTO wed_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma i vovai-virewapani da arua-apoapoei rava au orai ina viopuni. ");
INSERT INTO wed_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Taui i vinevinei 12 ai wava wenanare, Simon i ḡoreḡoreia Peter ");
INSERT INTO wed_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma Zebedi natuna James ma ana tevera John i ḡorei Boaneges, anona waiparara natunatuna, ");
INSERT INTO wed_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Batolomeo, Matthew, Thomas, James, tauna Apius natuna, Thadeus, Simon, tauna Ununurana, ");
INSERT INTO wed_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iskariotei; tauna, Iesu tauvibenabenameina. ");
INSERT INTO wed_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma Iesu ana tauvotaḡotaḡo maiteni i rui au numa. Ma patara i rieiai da taui eḡa tagotagogina da ita am. ");
INSERT INTO wed_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma Iesu ana numa ravai nolana i nonori ma i riwa i pa, “Tauna i bua.” Lamna aubaina i nei da ina taravaini. ");
INSERT INTO wed_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tarawatu babadai ḡelaui Jerusalemei i nei ma i riwa i pa, “Arua-apoapoei, ai bada Bielsibul, Iesu au orana i rui ma lamnei arua-apoapoei e viviopuni.” ");
INSERT INTO wed_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lamna aubaina Iesu, wei Babadai i ḡorei ma awanainei i pa, “Satan amapo Satan eḡa ina viopuni. ");
INSERT INTO wed_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mepa da dobu ravai ina viḡavia vivira, lamna dobuna ita mae ava. ");
INSERT INTO wed_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma nanare dam ina viḡavia vivira, nai damna ita mae ava. ");
INSERT INTO wed_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma Satan ita vomairi ma ita viḡaviana-melei, amapo ita mae ava. ");
INSERT INTO wed_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Taudanene amapo eḡa rava virewapanana ana au numa ina danene, eḡa da au naona ravana ḡuravei ina raḡini ma muriai ina danene. ");
INSERT INTO wed_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Riwa kaua a ririwemi da God ami ḡoʼapoapoei ma ami vijiboḡa anatapui ina nota-tawanei. ");
INSERT INTO wed_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wate aiai da Arua Vivivireina e vivijiboḡi, God, nai ravana ana ḡoʼapoapoei eḡa melanai ina nota-tawanei ma ana ḡoʼapoapoe ina mae-nonoa.” ");
INSERT INTO wed_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu wenanare i babani, aubaina rava ḡelaui e ririwa, “Iesu au orana arua-apoapoei e mamae.” ");
INSERT INTO wed_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesu alona ma varevareina i nei ma au doa i maimairi ma riwa i paritawanei Iesu awarina da ita nei. ");
INSERT INTO wed_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ma patara Iesu i kiala kwaviviroi, ma taupariverena i riwei i pa, “Alom ma novunovum ma varevareim au doa ma e ḡoeḡoem.” ");
INSERT INTO wed_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu i paribelei i pa, “Aiai alou ma aiavoi varevareiu?” ");
INSERT INTO wed_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Anina ma taui i kiakiala i ʼnanai ma i riwa i pa, “Ona inana! Wei taui alou ma varevareiu. ");
INSERT INTO wed_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aiai God ana ḡoana e kaukauei, tauna alou ma novu ma vareiu.” ");
INSERT INTO wed_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu, giu i raukarena-melei Galili topana au adana. Ma patara i riei da ita rautaniḡanei. Ma patara i rata, da tauna au waga i geru ma i kiala ma waga i dudui da i virauopu au topei ma patara au gera i mae. ");
INSERT INTO wed_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma kaua maḡamaḡaui awanainei i giu ma i viararamana i pa, ");
INSERT INTO wed_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ona rautaniḡana! Taupaewa, ana wapu i vokaukauei ma pei i ravi awawari. ");
INSERT INTO wed_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pei ḡelaui au eta i peu. Ma kiu i ḡeta ma i ani. ");
INSERT INTO wed_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma pei ḡelaui doa au ḡaiḡaimana i peu, doa au avavana. Ma lamna aubaina maratagogi i gogo. ");
INSERT INTO wed_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wate maranai madeḡa i rarani, maratagogi i poi, anona warami eḡa ita ḡaira guratana doa au orana. ");
INSERT INTO wed_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pei ḡelaui, modu donadonai au poui i peu. Ma modu donadonai i gogo ma pei i gogogo i lavani, ma eḡa ita ua. ");
INSERT INTO wed_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma pei ḡelaui doa au aiaina i peu ma i gogo kaua ma i ua, ḡelaui 30, ḡelaui 60 ma ḡelaui 100.” ");
INSERT INTO wed_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma Iesu i riwa i pa, “Mepa da taniḡami e mamae, riwa ona nonori!” ");
INSERT INTO wed_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Maranai Iesu ainelana i mamae ma ana tauvotaḡotaḡo 12 ma taurautaniḡana ḡelaui i ḡeta ma Iesu i vibaḡai da awanaina anona ita riwei. ");
INSERT INTO wed_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma Iesu i paribelei i pa, “God ana vigulau ana kaua mamae govaḡana; taumi i vieḡemi ma rava au tano maemaei, taui aiwai anatapui awanainei e paripari-verei. ");
INSERT INTO wed_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Lamna ana kauei da wariaḡa peroveta aiwai i girugirumia ina tupua: ");
INSERT INTO wed_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Anina ma Iesu i riwei i pa, “Wei awanainei a babani ma anona eḡa ota aramanei bo? Ma awanaina ḡelaui menanare ona aramananei? ");
INSERT INTO wed_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Taupaewa, God riwana, rava anatapui e paripari-verei. ");
INSERT INTO wed_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Rava ḡelaui orai i bagibagi me etanai. Riwa au tepana e raurauei, wate maratagogi Satan e nenei da riwa rava au orai e vaivai-tawanei. ");
INSERT INTO wed_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma rava ḡelaui orai me doa viḡaiḡaimana. Taui, riwa i nonori ma maratagogi ana nuaiaii riwa e vaivaia. ");
INSERT INTO wed_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wate warami eḡa da eḡa ita mamae guratana. Ma maranai nuabola bo rau-iviapoapoe e nenei taui awari, aubaina taui ai tumaḡana God awarina e tereterei. Taui maratagogi e peupeu. ");
INSERT INTO wed_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Rava ḡelaui orai me pei, modu donadonai au orai e gogogolana. Taui anina riwa e nononori. ");
INSERT INTO wed_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Wate lawana ai nuabola ma mane ai nuavainana ma kaua ḡelaui ai au nuaiai e ruirui ma God riwana e lavalavani da eḡa ita uaua. ");
INSERT INTO wed_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma ḡelaui, taui me pei doa au aiaina i peu. Taui, lamna anina riwa e nononori ma e vaivai-kauei ma e uaua: ḡelaui 30 ma ḡelaui 60 ma ḡelaui 100.” ");
INSERT INTO wed_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu i riwei i pa, “Rava, eḡa rampa ita neineiai da iriga au gabaurina ita tereterei bo vatara au gabaurina ta pa? Rampa ana au anikiala e tereterei ta pa? ");
INSERT INTO wed_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kaua mamae govaḡai, anataputapui a vieḡai ma kaua govagovaḡai nanarena ana vieḡai. ");
INSERT INTO wed_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mepa da taniḡami e mamae, riwa ona nonori!” ");
INSERT INTO wed_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu i riwa i pa, “Aiwai o nononoria ona rautaniḡanana-kauei, ruva o ruveruveia, God nanare awarimi ina ruvai ma ḡelauna ina tavipotoi. ");
INSERT INTO wed_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Lamna aubaina, mepa da riwau ona aramanei, tau ḡelauna ma ḡelauna ana veremi. Ma taui eḡa ita aramanei, lamna aiwai aburuna i nononoria, ina vine-boai.” ");
INSERT INTO wed_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu e ririwa i pa, “God ana vigulau me rava, witi peina au doa ita ravi-awawari. ");
INSERT INTO wed_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma waguvara e matamatave ma maratom e vovomairi ma pei e gogogo ma e rarata. Wate aiwaiei e gogogo, tauna e vivinuanainei. ");
INSERT INTO wed_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Doa ana nuaina, pei me witi e vivigogoi ma e uaua. Au naona e raraupairei ma muriai e roverove ma muriai anona e magumagura au tapina. ");
INSERT INTO wed_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maranai i magura, rava petona e raraukarei. Tuaruta marana i ḡetai.” ");
INSERT INTO wed_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu i riwa i pa, “God ana vigulau aiwaiei ana parivai-patepatei bo aiwai awanainei ana pariveremi? ");
INSERT INTO wed_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wenanare, wei aina peina, lamna me gaga peina, pei aburuoina au dobu ma au doa i paewi. ");
INSERT INTO wed_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma peina i gogo ma i rata da ai muomuoi i ḡetawanei ma raḡaraḡai ḡaeḡae i terei ma au ḡoui, kiu ai noḡi ita voai.” ");
INSERT INTO wed_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ma Iesu, awanaina maḡamaḡaui, rava au matai i raugugulei da taui ai rau-taniḡana ana au ruva nanare. ");
INSERT INTO wed_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Awanainei, rava awari i giugiu, wate ana tauvotaḡotaḡo ava awari kaua anatapui i vivieḡai. ");
INSERT INTO wed_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nai aubigaina Iesu, ana tauvotaḡotaḡo i riwei i pa, “Tana damana topa au baba ḡelauna.” ");
INSERT INTO wed_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Anina ma taui patara i voterei. Ma anatapui Iesu, maiteni au waga i geru ma i damana, waga ḡelaui maiteni. ");
INSERT INTO wed_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Iesu, waga au murina unutana i terei ma i raunuavuru. Ma kojikojira ḡaeḡaena i tupua ma rabama, waga au tepana i raurauei ma waira, waga i oaoai. Ma ana tauvotaḡotaḡo, tauna i ravi-dagudagui ma i riwei i pa, “Taugiu, nuanuam e bolabolai bo eḡa da tana iraḡe?” ");
INSERT INTO wed_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma tauna i vomairi ma ive i viḡaei ma i riwei i pa, “Ma genuana!” Ma rabama i riwei i pa, “Ma mae-genuatau!” Ma ive i wanatuini ma daumora ḡaeḡaena i matave. ");
INSERT INTO wed_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu ana tauvotaḡotaḡo i riwei i pa, “Aiwai aubaina o rovorovo? Taumi amapo da eḡa ota vitumaḡana!” ");
INSERT INTO wed_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma taui i rovo kaua ma i riwa vivira i pa, “Wei aiai ravana da ive ma rabama tauna e vovoteletelei?” ");
INSERT INTO wed_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu ana tauvotaḡotaḡo maiteni Galili topana au baba ḡelauna i ḡeta, mai Gerasa ai au dobu. ");
INSERT INTO wed_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wei au dobuna, arua-apoapoena oroto au orana maemaena. ");
INSERT INTO wed_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","Eḡa aiai tagotagogina da ita vovaiubai. Mara maḡamaḡauna, aena ma urana seinei i pani. Wate wei i viaituituini, ma eḡa tagotagogina da seinei ita pani. Marai ma waguvarai i nene-labalababa ma i garagarara ma ḡaimei tupuana i boribori-melei ma au kokoaga ma au ola i raunuma. ");
INSERT INTO wed_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Maranai Iesu wagei i opuopu, arua-apoapoei orotona i ruiruinia, aueia Iesu i ʼnanai ma kokoagei i ruba ma Iesu au naona i mae-peu ma i raudune. ");
INSERT INTO wed_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Iesu, ravana i riwei i pa, “Arua-apoapoena, wei orotona ma opu-tawaneii!” Ma orotona, ponana au aidamo ma i garara, “Iesu, God Aidamo Telarana Natuna! Aiwai awariu e ḡoeḡoei? God wavanei a vivibaḡaim da eḡa ma kovoḡiu!” ");
INSERT INTO wed_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu, orotona i vitara-virevirei i pa, “Tam wavam aiai?” I paribelei i pa, “Tauai a maḡa, aubaina tau wavau lamna Ḡavia Patarana.” ");
INSERT INTO wed_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma arua-apoapoei, Iesu i vibaḡa-guratei da avena nai dobunei ita viopuna-tawanei. ");
INSERT INTO wed_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma poro boruna ḡaeḡaena au ḡereḡere ola au adana i labalaba. ");
INSERT INTO wed_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma arua-apoapoei, Iesu i vibaḡai, “Ma paritawanelai poro au orai ana rui.” ");
INSERT INTO wed_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu i vianina. Ma arua-apoapoei, orotona i opu-tawanei ma poro au orai i rui. Poro boruna 2,000 nanare olei i ruba ḡaira da au topa i monu. ");
INSERT INTO wed_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma poro taupainii i ruba nae au melagai ma au wapu; ma riwa i vibabarai. Ma rava i nei da ita inanai aiwai i tupua. ");
INSERT INTO wed_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma maranai i nae Iesu awarina, orotona au naona arua-apoapoei patarai au orana i mamae; tauna i kiakiala, gara i oteni ma ana nota jijimanina. Ma taui i rovo kaua. ");
INSERT INTO wed_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma aiwai i tupua orotona ma poro awari, taui i ʼnainanaia, rava i riwana-naiei. ");
INSERT INTO wed_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma dobuna ravai, Iesu i vibaḡai da dobuna ita oputawaneii. ");
INSERT INTO wed_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu au waga i gerugeru ma orotona, Iesu i vibaḡai i pa, “Tau maiteni tana nae.” ");
INSERT INTO wed_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iesu i viḡaei ma i riwei i pa, “Ma naeme am au dam. Ma Bada kaua aiwai ḡaeḡaena i kaukaueia ma ana iviaiai tam awarim, taui ma pariverei.” ");
INSERT INTO wed_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma anina orotona, Iesu i netawanei ma i nae au Dekapolis (melagai 10) da Iesu aiwai awarina i kaukaueia, rava i riwana-naiei. Ma taui anatapui i nononoria i baiei. ");
INSERT INTO wed_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu wagei i damana me topa au baba ḡelauna. Maranai kampa i ḡeta ma topa au adana, ma patara i rieiai. ");
INSERT INTO wed_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pari numana badana wavana Jairus i nei weka ma maranai Iesu i ʼnanai, tauna Iesu au aena i mae-peu ");
INSERT INTO wed_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma i vibaḡa-guratei i pa, “Natu guguinina e irairaḡe. Ma nei ma uram au inina ma terei ma ina lawana.” ");
INSERT INTO wed_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Anina ma Jairus, Iesu maiteni i nae ma patarana i mae gariḡuruvi ma i votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wavine tagogi kampa patarana au orana awarina tara-doriana i mae da madeḡa 12 i kwa. ");
INSERT INTO wed_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ana mane anataputapuna, dokedoketa maḡamaḡaui awarii i tawanei ma eḡa tagotagogina ita vilawani ma amapo da ana doria i rarata. ");
INSERT INTO wed_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Tauna, Iesu nolana ma ana babani i nonori ma au orana i vinua-notanota i pa, “Mepa da ana gara ava ana vodadani ma ana lawana.” Ma tauna, Iesu murinei i nei ma ana gara i vodadani. ");
INSERT INTO wed_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Maratagogi, tara-doriana i wanatuini ma malana i vaia da i lawana. ");
INSERT INTO wed_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nai maranaina, Iesu malana i vaia da ana rewapana i opu-tawanei ma i mae-tavirei patara au poui ma i riwa i pa, “Aiai au gara i vodadani?” ");
INSERT INTO wed_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana tauvotaḡotaḡo, tauna i riwei, “Ma inanai, patara i mae gariḡuruvim! Ma menanare da u riwa ‘Aiai i vodadaniu?” ");
INSERT INTO wed_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wate Iesu i ʼnana viravira da ita inanai aiai i vodadani. ");
INSERT INTO wed_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wavine i rovo kaua ma i sisisi, wate i aramanei aiwai awarina i tupua ma i nei ma Iesu au naona i raupari ma aiwai anatapui i vieḡei. ");
INSERT INTO wed_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Anina ma Iesu, wavine i riwei i pa, “Natu, am tumaḡana i vilawanim. Am doria i kwa, ana nuaubam ma nae!” ");
INSERT INTO wed_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Maranai i bababani ma rava ḡelaui Jairus ana numei i nei ma i riwei i pa, “Natum ana mara i kwa. Eḡa Taugiu ma visina-viravirai.” ");
INSERT INTO wed_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu ai babani i nonora-tawanei ma Jairus i riwei i pa, “Eḡa ma rovo, ma vitumaḡana!” ");
INSERT INTO wed_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesu, rava ḡelaui i viḡaei ma Peter ma James ma ana tevera John maiteni i nae. ");
INSERT INTO wed_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma Jairus ana au numa i ḡeta ma Iesu, patara i ʼnanai; i toutou ma i taratarakwatu ");
INSERT INTO wed_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ma i rui ma taui i riwei i pa, “Aiwai aubaina o taratara-kwatu ma o toutou? Tevera eḡa ita iraḡe, tauna e matamatave ota.” ");
INSERT INTO wed_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma taui, Iesu i kakei, ma lamna aubaina rava i viopuni au doa ma tevera alona ma amana ma tauna ana tauvotaḡotaḡo tonuḡa maiteni i rui mepa tevera i matamatave lana. ");
INSERT INTO wed_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iesu, tevera nimana i vaia ma i riwei i pa, “Talitha koum!” wei anona, “Kukuma, ma vomairi!” ");
INSERT INTO wed_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Maratagogi i vomairi ma babara i vikarei (Tauna ana madeḡa 12). Ma taui i ba kaua. ");
INSERT INTO wed_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu, taui i riwana-guratei da eḡa aiai ita vieḡei ma i riwa da ita viambagibagi. ");
INSERT INTO wed_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu ana tauvotaḡotaḡo maiteni nai dobuna i netawanei ma i naeme ana au melagai. ");
INSERT INTO wed_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma Sabat marana i ḡeta ma tauna giu i vikarei au pari numana. Ma rava maḡamaḡaui i riei da i rautaniḡanei. Taui anatapui i baiei ma i vitara-viravira vivira i pa, “Wei tauna nuaulaula ma aramanana mepa i vaia?” Ma, “Kaua aiwaiei e kaukauei?” ");
INSERT INTO wed_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Anina ma taui ava i babani vivira i pa, “Tauna tauvoa. Mary ana natuevou ma varevarena James, Joses, Judas ma Simon ma novunovui weka e mamae tauna bo?” Ma lamna aubaina mai Nasaret, Iesu i parivirevirei. ");
INSERT INTO wed_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu, taui i riwei i pa, “Peroveta dobu au ḡelaui e vivivirei, wate ana au melagai, ana rava ma ana dam oina, eḡa ita vivivirei.” ");
INSERT INTO wed_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Tauna i baiei da rava eḡa tauna ita vitumaḡanei. Ma eḡa tagotagogina da kaua vivirewapanai kampa ita kauei. Tauna urana, rava ruaḡa ota doridoriai au tepai i terei ma i vilawani. Ma muriai, melagai nununai au ḡereḡerei i viararamana nae. ");
INSERT INTO wed_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ma Iesu, taui 12 i ḡoreiai ma ruaruaḡei ava i paritawanana-opunei ma rewapana i verei da arua-apoapoei ina viaḡaḡana-opunei. ");
INSERT INTO wed_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma riwa bagibaginei i riwei i pa, “Ami au vaḡai, eḡa aiwai ona vaia anina jiḡona ava; eḡa lam, eḡa autu bo mane au urami. ");
INSERT INTO wed_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ae uma ona oteni ma eḡa kwama ḡelauna ona vaia.” ");
INSERT INTO wed_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma i riwei i pa, “Metauna melagaina o ruiruiana ma i vianinemi. Numa tagoginina au orana ona mae da melagaina ona oputawanei. ");
INSERT INTO wed_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mepa da au melagai o ḡeta ma rava eḡa ita vianinemi bo eḡa ita rautaniḡanemi. Nai melagaina ona oputawanei ma aemi pokauna ona rauabuabui da ina aramanei da taui ai wavu!” ");
INSERT INTO wed_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma taui i opu ma rava awari i raugugula ma i riwei i pa, “Taumi ami ḡoʼapoapoei ona voterei ma ona mae-taviremi God awarina!” ");
INSERT INTO wed_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Taui, arua-apoapoei i viaḡaḡana-opunei. Ma rava doridoriai maḡamaḡaui, olive oirana au kolai i buloi ma i vilawani. ");
INSERT INTO wed_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Iesu nolana i nae da rava anatapui i aramanei ma tauna i babaniei. Ma rava ḡelaui i ririwa i pa, “Tauna, kaua vivirewapanai e kaukauei, aubaina tauna John Taubabataito iraḡelei i vomairi me.” Ḡelaui i ririwa i pa, “Tauna Elijah i nememei.” Ma ḡelaui i ririwa i pa, “Tauna peroveta wariaḡai nanare.” Ma gulau Herod, nolana i nonori ma i riwa i pa, “Tau, John Taubabataito uana a borituini; marina i vomairi me.” ");
INSERT INTO wed_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","John ana virarautua, lamna wenanare. Muriai da Iesu ana viararamana nolana ita vikarei. Herod, tuana Philip awana i kwalei ma i ravaḡi. Wavinena wavana Herodias. Au murina John, Herod i riwana ḡiriḡiriei i pa, “Tarawatu e mamae da eḡa vareim awana ma kwalei.” Ma Herod, riwa i paritawanei da John i pani da panipani au numana i terei. Herod ana nuaiaina, John i rarautaniḡanei. Wate nuanuana i raḡaraḡa. Ma Herodias, John awarina amlona i ḡaiḡai ma viraḡenana i ḡoei. Herod i aramanei da John, lamna rava jijimanina ma vivivireina ma i gagaloei. Herod, John i rovoei ma lamna aubaina wavinena eḡa tagotagogina da aiwai ita kauei. ");
INSERT INTO wed_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma wavine, gavogavo i ʼnanai, maranai Herod ana tupua marana i ḡeta ma torela i vokaukauei. Ma gabemani babadai ḡaeḡaei ma sorodia ai babada ḡaeḡaei ma Galili babadai i raukwatuei. ");
INSERT INTO wed_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma Herodias natuna wavinena i nei ma i ara. Herod ma taui maiteni i amam i vinuaiaini. Ma gulau, guguini i riwei i pa, “Aiwai u ḡoeḡoeia ma vibaḡaiu ma ana verem!” ");
INSERT INTO wed_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma i parivainuaḡani i pa, “God au matana a ririwem da aiwai u vivibaḡeiu ana verem da au vigulau navanavana au paratana.” ");
INSERT INTO wed_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma tevera wavinena i opu ma alona i paridadanei i pa, “Aiwai ana vibaḡei?” Ma i paribelei i pa, “John Taubabataito kolana.” ");
INSERT INTO wed_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma maratagogi i vipaparana ma gulau awarina i rui ma i vibaḡai i pa, “A ḡoeḡoei da marina John Taubabataito kolana ma vereu au aboma!” ");
INSERT INTO wed_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma gulau nuanuana i bola-kauei. Wate parivainuaḡana boiboḡi i kauei taui i amam au matai. Ma lamna aubaina guguini, aiwai i vivibaḡei anina i vianinei. ");
INSERT INTO wed_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma tauviraḡena i paritawanei ma i riwei da John kolana ita neiai. Ma i nae panipani au numana ma John uana i borituini. ");
INSERT INTO wed_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ma kolana au aboma i terei ma guguini i verei ma guguini, alona i verei. ");
INSERT INTO wed_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma John ana tauvotaḡotaḡo, nolana i nonori ma i nei ma taubeuna i vaia ma au kokoaga i vimataveni. ");
INSERT INTO wed_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apasol i ḡeta memei ma aiwai anataputapuna i kaukauei ma i raraugugulei, Iesu i vieḡei. ");
INSERT INTO wed_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lamna maranai, rava maḡamaḡaui i nenei ma i nenae da Iesu ana tauvotaḡotaḡo maiteni eḡa gavogavo ita maemae da ita am. Lamna aubaina Iesu, taui i riwei i pa, “Taumi ava ona nei ma tana nae au mutulua da laumi ina tau mara aburuna.” ");
INSERT INTO wed_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma anatapui wagei i nae au mutulua. ");
INSERT INTO wed_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wate rava maḡamaḡaui i ʼnanai i nenae ma i aramanei taui aiavoi. Ma melagai nununai anatapui geraei i ruba gogona da au dobuna i aiḡeta. ");
INSERT INTO wed_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Maranai Iesu wagei i tuopu au gera ma patara ḡaeḡaena i ʼnanai ma nuanuana i bola-kauei. Taui me sipu ma eḡa ai tauvipaipai. Ma Riwana Aiaina viararamanai i raukarei. ");
INSERT INTO wed_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma au biga e tuturiai ma ana tauvotaḡotaḡo i nei awarina ma i riwei i pa, “Wei mutulua ma madeḡa e arearere. ");
INSERT INTO wed_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Rava ma paritawanei da ina nae au melagai ma au wapu au ḡereḡere da ai lam ina gimarai.” ");
INSERT INTO wed_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wate Iesu i paribelei i pa, “Taumi ona viambagibagi!” Ma taui i paribelei i pa, “Mepa 200 denarii tana vaia da wei patarana tana viambagibagi?” ");
INSERT INTO wed_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma Iesu i paridadanei i pa, “Palawa biaḡa awarimi? Ona nae ma ona baiei!” Maranai i nelaḡai ma i riwa i pa, “Awariai, palawa five ma iana ruaḡa.” ");
INSERT INTO wed_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Anina ma Iesu, patara i riwei i pa, “Boru nununai, gidagida au majimajiḡai ona kiala nae.” ");
INSERT INTO wed_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma taui ai au boru 50 da 100 nanare i kiala nae. ");
INSERT INTO wed_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Iesu, palawa five ma iana ruaḡa i vaia ma i ḡoutata au mara ma God i viegualauei. Ma palawa i vogimagimai ma iana i ḡutai da ana tauvotaḡotaḡo i verei ma taui, rava i verei. ");
INSERT INTO wed_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma patara i am ma i am-iaua. ");
INSERT INTO wed_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma ana tauvotaḡotaḡo, lam am tereterenai i tuarui da poa muomuoi 12 i vioai. ");
INSERT INTO wed_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nelara 5,000 i viambagibagi. ");
INSERT INTO wed_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Anina ma Iesu, ana tauvotaḡotaḡo i egari da ita aidamana au Bethsaida. Taui au waga i geru da i nenae ma tauna, patara i paritawanei. ");
INSERT INTO wed_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Patara i paritawanei ma tauna ava i ḡae au ola da ita raupari. ");
INSERT INTO wed_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma waguvara ana tauvotaḡotaḡo au waga au topa ma Iesu au alala. ");
INSERT INTO wed_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma ana tauvotaḡotaḡo, lare i vovoguratei da ita ḡota wate ive i viraumatamatani. Ma maratomtom nanare, Iesu i nae awari. Tauna waira au tepana i bababara ma i ḡoei da taui ita tutelarei. ");
INSERT INTO wed_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ma maranai taui, Iesu i ʼnanai topa au tepana i bababara ma i notai da tauna konaḡa ma i rovo kaukaua ma i vigaragararei. Ma maratagogi Iesu i riwa i pa, “Tepami ina tora! Tau, eḡa ona rovo!” ");
INSERT INTO wed_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma au waga i geru ma ive i wanatuini ma taui i bana-kauei. ");
INSERT INTO wed_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Avena da kaua palawa awarina i kauei i ʼnanai, wate ana rewapana eḡa ita aramana-kauei. Taui orai i bado ma i vinuanaina. ");
INSERT INTO wed_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Taui, topa i damani ma au Genesaret i ḡota ma ai waga i raḡini. ");
INSERT INTO wed_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Taui, waga i oputawanei ma rava, Iesu i ʼnanai ma maratagogi i aramanei da tauna. ");
INSERT INTO wed_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Iesu nolana, Galili provins anatapui i naeni ma i nonori da tauna mepa i mamae. Ma kampa, doridoriai rasirasiei i vivaneiai. ");
INSERT INTO wed_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesu mepa i nenelana, melagai ḡaeḡaei ma muomuoi ma wapu mepa rava e mamae lana. Ma rava, ai rava doridoriai nai au melagaina i neiai au deba. Ma i vibaḡa, da doridoriai, Iesu ana gara adana ava ita vodadani. Ma aiavoi Iesu ana gara i vodadani i lawana. ");
INSERT INTO wed_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Pharisi ma Jew anatapui, magumagura ai giu maḡamaḡaui e notanota-jijini. Taui, ai aniuma ma ai aniam anatapui e oḡaoḡai lamnei taui e viaiaina-melei God au matana. Ma maranai au maket da e nenei, urai ina oḡai ma ina am. Taui eḡa ina am da au naona urai ina oḡa kauei me ai magumagura ai giu nanare. Maratagogi Pharisi ḡelaui ma Tarawatu Babadai, Jerusalem ei i nei Iesu awarina da ita rautaniḡanei. Ma taui i ʼnanai da Iesu ana tauvotaḡotaḡo ḡelaui, urai eḡa ita oḡai ma i amam. ");
INSERT INTO wed_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma taui, Iesu i vitara-virevirei i pa, “Aiwai aubaina am Tauvotaḡotaḡo magumagura ai giu, eḡa ita votaḡotaḡoi ma ana ura miramirai e amam?” ");
INSERT INTO wed_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma Iesu i paribelei i pa, “Taumi morumorumi ma o vikaua-aiaina-melemi. God ana peroveta Isaiah i riwa kaua maranai i riwa, i pa: ");
INSERT INTO wed_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Taui rava ai giu e viviararamani. ");
INSERT INTO wed_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Taumi, God ana Tarawatu o teretere-tawanei ma ami giu o votaḡotaḡoi.” ");
INSERT INTO wed_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma i riwana-melei i pa, “Taumi o aramana kaua da God ana Tarawatu o gedugeduaiei ma amamami ai giu o vovotaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","God ana Tarawatu, Moses i girugirumia nanare: Amam ma alom ma vivirei ma Aiai amana ma alona e enaena-boai, tauna ona viraḡeni. ");
INSERT INTO wed_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wate taumi o viararamana da aiai awarina mane bo purapura, amana bo alona ita voagui ma ita riwei, ‘Awariu e mamae da ata voaguim; wate lamna Corban - a tereriei pulo, God aubaina.’ ");
INSERT INTO wed_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wei viararamanana, taui e viviḡaei da amana ma alona ina voagui. ");
INSERT INTO wed_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma wei taunei viararamana, rava awari o vividamani; ma God riwana o vivikwakwavi. Ma kaua maḡamaḡaui ḡelaui maiteni o kaukauei.” ");
INSERT INTO wed_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu, patara i kwatuana-melei ma i riwei i pa, “Anatapumi ona rautaniḡaneu ma aiwai a ririwemi ona aramanei. ");
INSERT INTO wed_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Aiwai au tanoei au orami e ruirui, lamna eḡa ita vivimiraimi ma aiwai da oramiei e opuopu, lamna e vivimiraimi God au matana.” ");
INSERT INTO wed_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Anina Iesu, patara i voterei ma i rui au numa. Ma ana tauvotaḡotaḡo, i vitara-virevirei da wei awanainana anona aiwai. ");
INSERT INTO wed_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Iesu i paribelei i pa, “Taumi maiteni eḡa ota aramanei bo? Kaua aiwai au tano, rava au orai e ruirui amapo eḡa ina vimirai. Anona lamna wei kauai, eḡa ita ruirui rava au nuapouna, wate au manawana da e opuopu.” (Wei riwanei Iesu, lam anatapui i viaiaini). ");
INSERT INTO wed_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Anina ma i riwa i pa, “Aiwai, rava oranei e opuopu; lamna, rava e vivimirai God au matana. ");
INSERT INTO wed_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Anina rava nuanuanei vinuanotanota apoapoei e opuopu me: viawawana labalababa, danene, viraḡena, awadanene, ");
INSERT INTO wed_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ambo, rau-iviapoapoe, moru, erawa, unura, terevaideḡa, mae-ḡaeḡae ma opa. ");
INSERT INTO wed_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wei kauai apoapoei anatapui oranei e opuopu ma rava e vimiramirai.” ");
INSERT INTO wed_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ma dobuna i voterei ma i nae Taia ana au parata. Ma i rui govaḡa au numa ma eḡa ita ḡoei da rava ita aramanei da tauna kampa, wate eḡa tagotagogina da ita raugovaḡa. ");
INSERT INTO wed_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Wavine tagogi, Iesu nolana i nonori ma i nei awarina. Tauna eḡa Jew ma Jentail au Phonisia i tupua, Siria ana au parata. Arua-apoapoena, tauna natuna wavinena aburuna i ruini; ma alona i nae Iesu au naona i mae-peu ma ma i vibaḡai da arua-apoapoena ita viopuni. ");
INSERT INTO wed_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iesu i aramanei da tauna Jentail; lamna aubaina i riwei i pa, “Eḡa ita ai da roaroa ai lam ata vaia da auou ata verei da au naona roaroa ina am-iaua.” ");
INSERT INTO wed_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma wavine i paribelei i pa, “Bada, aiwai u riwei; lamna riwa kaua. Wate auou, roaroa ai lam momoḡina, kepakepa au gabaurina e rauraua e aniani.” ");
INSERT INTO wed_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma Iesu wei i riwei i pa, “U paribelana kaua, aubaina ma nae au numa. Arua-apoapoena natum i opu-tawanei.” ");
INSERT INTO wed_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma wavine i naeme au numa. Natuna wavinena i ʼnanai i matamatave, arua-apoapoena boiboḡi tevera i opu-tawanei. ");
INSERT INTO wed_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu Taia ma Sidon ana parata i netawanei ma au babaḡela Dekapolis i verautuini ma i nae au Galili topana. ");
INSERT INTO wed_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Oroto taniḡana potapotana ma menana birebirena i neiai Iesu awarina ma i vibaḡai da urana au inina ita terei da ita vilawani. ");
INSERT INTO wed_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu, oroto i taravaina-opunei da taui ava ma ura-gigina, oroto au taniḡana i terei ma ura-gigina ḡelauna i ovai ma menana i vodadani. ");
INSERT INTO wed_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nuanuana i bolai ma i ḡoutata au mara; i lavutu tawanana ma oroto i riwei i pa, “Ephatha!” Wei anona, “Ma wanatawanei!” ");
INSERT INTO wed_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Maratagogi taniḡana i wanatawanei ma menana i vidagudagu ma i babani kaua. ");
INSERT INTO wed_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma Iesu, taui i viḡaei da aiwai i tuputupua, avena rava ita vieḡei. Iesu, rava i viḡaei; wate taui eḡa ita rautaniḡana ma riwa i vituai. ");
INSERT INTO wed_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma maranai ravai wei i nonori, taui i bana-kauei ma i riwa i pa, “Aiwai anatapui i kauana-kauei. Tauna, rava taniḡa potapotai e vivilawani da e rarautaniḡana ma menabirebirei e bababani.” ");
INSERT INTO wed_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nai maranai, patara ḡaeḡaena i riana-melei. Patara eḡa ai lam. Ma Iesu, ana tauvotaḡotaḡo i kwatuei da i nei ma i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Au pom tonuḡa patara maiteni a mae ma ai lam eḡa ma a rau-nuapoapoelei. ");
INSERT INTO wed_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Taui ḡelaui, uamei i nei. Mepa da ana am-iraḡe ana paritawanei ai au numa, ma au etanai ina raumolaḡau.” ");
INSERT INTO wed_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma ana tauvotaḡotaḡo i paribelei i pa, “Wei mutulua ma mepa lam tana vaia da wei patarana tana viambagibagi?” ");
INSERT INTO wed_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Iesu, taui i paridadanei i pa, “Awarimi palawa biaḡa?” Taui i riwa i pa, “seven.” ");
INSERT INTO wed_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma Iesu, patara i riwei da au doa i kiala. Ma palawa seven i vaia ma God i viegualauei ma i vogimagimai ma ana tauvotaḡotaḡo i verei da patara i verei. ");
INSERT INTO wed_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma taui awari, iana muomuoi ruaḡa ota. Iesu i vaia; God i viegualauei ma ana tauvotaḡotaḡo i verei da patara i verei. ");
INSERT INTO wed_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Taui anatapui i am da i am-iaua. Ma lam am tereterenai i tuarui da poa ḡaeḡaei seven i vioai. ");
INSERT INTO wed_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Rava 4,000 i viambagibagi. Ma muriai i paritawanei ai au numa. ");
INSERT INTO wed_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Maratagogi, Iesu ana tauvotaḡotaḡo maiteni au waga i geru ma i nae Damanuta ana au parata. ");
INSERT INTO wed_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisi ḡelaui i nei ma viparipariḡai i vikarei Iesu maiteni. Taui i ḡoei da Iesu ita raudadani da mataira Godei ita viatataiei. ");
INSERT INTO wed_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu, Aruanei i lavutu tawanana ma i riwa i pa, “Wei kimta voui, aiwai aubaina mataira e ḡoeḡoei? A ririwana-kauemi, amapo mataira eḡa ona inanai.” ");
INSERT INTO wed_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anina ma Iesu, patara i netawanei ma ana tauvotaḡotaḡo maiteni au waga i geru me ma i damana Topa Galili au baba ḡelauna. ");
INSERT INTO wed_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma ana tauvotaḡotaḡo, nuanuai i vuru da ai palawa ita vaia ma palawa tagogi ava au waga i mamae. ");
INSERT INTO wed_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu, taui I parivainotai i pa, “Pharisi ma Herod ai giu ma ai viararamana morumoruna ona inana-kauei! Lamna me yist.” ");
INSERT INTO wed_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma taui i babani vivira i pa, “Tauta eḡa ata palawa aubaina da e ririweta.” ");
INSERT INTO wed_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Iesu i aramanei ma taui i riwei, “Aiwai aubaina o bababani da taumi awarimi eḡa palawa? Taumi amapo da eḡa ota aramana ma o vivinuanaina? Orami i bado bo? ");
INSERT INTO wed_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matami e mamae ma eḡa ota inainana. Ma taniḡami e mamae ma eḡa ota nonora. Ma o vinuanotanota bo eḡa? ");
INSERT INTO wed_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Maranai palawa five a vogimagimai rava 5,000 aubaii, lam am tereterenai o tami da poa biaḡa o vioai?” Taui i paribelei, “Twelve.” ");
INSERT INTO wed_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma maranai palawa seven a vogimagimai rava 4,000 aubaii, lam am tereterenai o tami da poa ḡaeḡaei biaḡa o vioai?” Taui i paribelei, “Seven.” ");
INSERT INTO wed_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma taui i riwei i pa, “Ma amapo da o vivinuanaina!” ");
INSERT INTO wed_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Taui i nei au Bethsaida ma rava ḡelaui, oroto matana apoapoena i neiai Iesu awarina ma i vibaḡa-guratei da ita vodadani. ");
INSERT INTO wed_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma Iesu, oroto matana apoapoena i raunimavoai ma melagaiei i taravaina-opunei. Ma kampa matana i ovai ma urana au matana i terei ma i paridadanei, “Aiwai e inainanai bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma i taepai ma i riwa, “Rava a inainanai ma taui me ai ita bababara.” ");
INSERT INTO wed_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iesu, urana i tere-melei oroto au matana. Ma matana i wanatawanei da aiwai anatapuna i ʼnana-kauei. ");
INSERT INTO wed_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu, tauna i paritawanei ana au numa ma i riwei, “Eḡa ma nae au melagai! Wate jijimanina ma nae au numa.” ");
INSERT INTO wed_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu, ana tauvotaḡotaḡo maiteni i nae melagaii Caesarea Philipai au ḡereḡerei. Maranai i nenae ma Iesu, taui i paridadanei, “Rava e ririwa; tau aiai?” ");
INSERT INTO wed_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma taui i paribelei, “Ḡelaui e ririwa da tam, John Taubabataito. Ma ḡelaui Elijah. Ma ḡelaui e ririwa da peroveta wariaḡana tagogi.” ");
INSERT INTO wed_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma Iesu, taui i paridadanei, “Wate taumi, mena o notanota-nei? O ririwa da tau aiai?” Peter i paribelei, “Tam God ana Messiah - anona Keriso.” ");
INSERT INTO wed_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu, taui i viḡaei da eḡa aiai ina riwei da tauna aiai. ");
INSERT INTO wed_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma Iesu i raukarei da ana tauvotaḡotaḡo i giuni i pa, “Rava Natuna ina vinuapoapoe kaua. Ma dogadogara, pirisi babadai ma tarawatu babadai, tauna ina pari-geduaiei ma ina viraḡeni. Ma au pom tonuḡa au murina ina vomairi me.” ");
INSERT INTO wed_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu jijimaninei wei kauai i bababaniei ma lamna aubaina Peter, tauna i taravaini au ririva ma enana i vikarei. ");
INSERT INTO wed_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wate Iesu i mae-tavirei ma ana tauvotaḡotaḡo i ʼnanai. Ma Peter i eni, i pa, “Satan ma nae au muriu! Tam am nota eḡa Godei ita nenei, eḡa da ravei.” ");
INSERT INTO wed_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma Iesu, patara ma ana tauvotaḡotaḡo i raukwatuei ma i riwei, “Mepa da aiai ita votaḡotaḡoiu. Tauna ina boviana-melei ma ana korosi ina avarai ma ina votaḡotaḡoiu. ");
INSERT INTO wed_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aiai ana lawana e tatajijini, ina vine-boai. Ma aiai da ana lawana i verenei; Tau ma Riwana Aiaina aubaina. Tauna ana lawana ina vaimelei. ");
INSERT INTO wed_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ana aii bo anona aiwai, mepa da wei dobuna lawanana ma vigulauna ma vaipai ma am lawana maemae-nonoana ma vine-boai. ");
INSERT INTO wed_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wate aiwaiei am lawana ma gimara-melei. ");
INSERT INTO wed_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mepa da aiai: tau ma au viararamana ina vinimalei; ma i mae-puputeu; ma ana ḡoanei kaua apoapoe ina kaukauei. Rava Natuna, tauna ina vinimalei maranaina ina nememei; Amana ana au boruma anela vivivirei maiteni.” ");
INSERT INTO wed_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma Iesu, wenanare i riwei, “Taumi a ririwana-kauemi; rava ḡelaumi weka o maimairi amapo eḡa ona iraḡe da God ana vigulau ona inanai ana rewapanana ina nei.” ");
INSERT INTO wed_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Au pom six muriai, Iesu, Peter, James ma John i taravaini. Ma taui ava i ḡae ola ḡaeḡaena au tepana. Ma kampa taui au matai, Iesu inanana i virai. ");
INSERT INTO wed_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ana gara i arapoira ma gamrina i vimata-kamokamota; eḡa me aiwai ḡelauna au dobu nanare. ");
INSERT INTO wed_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma kampa au matai, Elijah ma Moses i eḡa. Ma Iesu maiteni i bababani. ");
INSERT INTO wed_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma Peter Iesu i riwei, “Tauviararamana, i aii da tauta weka. Ma vianinelai da numakweta tonuḡa ana voai: tagogi tam aubaim, ḡelauna Moses ma ḡelauna Elijah aubaina!” ");
INSERT INTO wed_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma taui i rovo kaua ma Peter eḡa ita aramanei da aiwai i latolatoni. ");
INSERT INTO wed_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Anina ma apau i eḡa ma taui i purui. Ma pona apauei i opu ma i riwa i pa, “Wei Tau Natu au nuavainana, ona rautaniḡanei!” ");
INSERT INTO wed_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Maratagogi taui i ʼnana viravira ma eḡa aiai ḡelauna ita inanai ma Iesu, tauna ava. ");
INSERT INTO wed_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ma maranai olei i ḡaiḡairai ma Iesu, taui i viḡaei da aiwai i ʼnananaia eḡa ina vieḡai da au naona Rava Natuna iraḡelei ina vomairi me. ");
INSERT INTO wed_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma taui, wei riwana i voteletelei ma i babani vivira i pa, “Iraḡelei vomairi me anona aiwai?” ");
INSERT INTO wed_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma taui, i vitara-virevirei i pa, “Aiwai aubaina, tarawatu babadai e ririwa da Elijah au naona ina nei?” ");
INSERT INTO wed_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu i paribelei, “Riwa kaua Elijah au naona ina nei da aiwai anatapuna ina vokaukauei. Aubaina wariaḡa i girumi da Rava Natuna ina vinuapoapoe kaua ma ina inana-geduaiei. ");
INSERT INTO wed_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wate a ririwana-kauemi da Elijah anina i nei ma rava, ai ḡoanei tauna i rau-iviapoapoelei me i girugirumia nanare.” ");
INSERT INTO wed_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iesu ana tauvotaḡotaḡo tonuḡa maiteni olei i ḡaira memei ai rava awari ma patara ḡaeḡaena, taui i gariḡuruvi. Ma Jew ai tarawatu babadai, taui maiteni i vivitarapiri. ");
INSERT INTO wed_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Maranai patara, Iesu i ʼnanai. Taui orai i auepai ma awarina i ruba ma i viegualauei. ");
INSERT INTO wed_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu, taui i vitara-virevirei, “Aiwai o vitarapiriei?” ");
INSERT INTO wed_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Oroto tagogi patara au poui i paribelana, “Tauviararamana, arua-apoapoena natu orotona au orana e mamae ma i kauei da eḡa ita bababani, lamna aubaina a neiai awarim. ");
INSERT INTO wed_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maranai ana doria e ururu-melei, lamna arua-apoapoena: tauna au doa e tawatawanei; gamona e vivipuropuro; ivona e utauta ḡiriḡiriei; ma inina e badobado. Am tauvotaḡotaḡo a vibaḡai da arua-apoapoena ita viopuni, wate eḡa tagotagogina da ita kauei.” ");
INSERT INTO wed_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma Iesu i paribelei, “Oo mara aiwai ona vitumaḡana! Ta mae ḡaḡa ma ami vita ana ʼvara ḡaḡalei? Tevera awariu ona neiai!” ");
INSERT INTO wed_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma tevera i neiai Iesu awarina. Ma maranai arua-apoapoena, Iesu i ʼnanai, maratagogi tevera i viaikwajiana-guratei da au doa i tonei ma i vitatauvira ma i vivipuropuro. ");
INSERT INTO wed_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu, tevera amana i vitara-virevirei, “Wei teverana ana doria mara aiwai i vikarei?” I paribelei i pa, “Maranai aburunai. ");
INSERT INTO wed_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Arua-apoapoena mara au anatapuna, tauna ai au araratana ma au waira e tawatawanei ma i ḡoei da ita viraḡeni. Mepa da tam tagotagogina; ma raunuʼapoapoelelai ma ma voaguiai!” ");
INSERT INTO wed_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu, tauna i riwei, “Menanare da u riwa, ‘Mepa da tam tagotagogina?’ Aiai ravana e vivitumaḡana, God anatapuna ina kauei tauna aubaina.” ");
INSERT INTO wed_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Maratagogi tevera amana i garara, “A vitumaḡana, wate au tumaḡana eḡa ita rata ma ma voaguiu da ina rata!” ");
INSERT INTO wed_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu i ʼnana da patara i rierieiai awarii ma lamna aubaina arua-apoapoena i egari i pa, “Tam arua taniḡa-potapotana ma gumgum. Tau a egaegarim da tevera ma opu-tawanei. Ma eḡa melanai au orana ma rui me!” ");
INSERT INTO wed_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma arua i garara ma tevera i viaikwajiana-guratei ma i opu-tawanei. Ma tevera inanana me taubeu. Ma rava maḡamaḡaui kampa i riwa, “Tauna iʼraḡe!” ");
INSERT INTO wed_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Iesu, tauna urana i vojijini ma i sinaepai da i mairi. ");
INSERT INTO wed_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muriai Iesu, ana tauvotaḡotaḡo maiteni i rui au numa. Ma maranai taui ava ma i paridadanei i pa, “Aiwai aubaina tauai eḡa tagotagogina da arua-apoapoena ata viopuni?” ");
INSERT INTO wed_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu, i riwa, “Arua-apoapoei me wenanare, pari ainelana ina viopuni.” ");
INSERT INTO wed_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu, ana tauvotaḡotaḡo maiteni dobuna i netawanei ma Galili i verautuini. Iesu eḡa ita ḡoei da rava ita aramanei da taui mepa. ");
INSERT INTO wed_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Aubaina tauna, ana tauvotaḡotaḡo i viararamani i pa, “Taui Rava Natuna ina amverenei rava ḡelaui au urai. Ma taui ina viraḡeni. Wate au pom tonuḡa au murina ina vomairi me.” ");
INSERT INTO wed_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wate taui eḡa ita aramanei tauna aiwai i bababaniei. Ma pari-dadanana i rovoei. ");
INSERT INTO wed_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iesu ana tauvotaḡotaḡo maiteni i ḡeta au Capeniam ma au numa i rui. Ma Iesu, taui i vitara-virevirei, “Au etanai aiwai o vitarapiriei?” ");
INSERT INTO wed_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wate taui i genuana, aubaina au etanai taui i vitarapiri vivira da aiai i ḡetelara. ");
INSERT INTO wed_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu i kiala ma Apasol 12 i raukwatuei awarina ma i riwei i pa, “Aiai e ḡoeḡoe da ina vibada. Tauna ina tereḡairana-melei ma ina vimuri dewadewa ma ina vitaunola rava aubai.” ");
INSERT INTO wed_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ma Iesu, tevera i vaia ma au poui i vimairini. Ma urana au jiḡona i tere-taḡonei. Ma taui i riwei i pa, ");
INSERT INTO wed_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aiai ravana; tau wavauei, tevera wenanare i rauḡorei. Lamna tau maiteni e rarauḡoreiu. Ma aiai da tau e rarauḡoreiu. Lamna tauparitawaneu maiteni e rarauḡorei.” ");
INSERT INTO wed_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Anina ma John, Iesu i riwei, “Tauviararamana! Tauai, oroto tagogi a inanai; tam wavamei arua-apoapoena i viviopuni ma tauna eḡa turata. Lamna aubaina a viḡaei da eḡa ina kauana-melei.” ");
INSERT INTO wed_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu i riwa, “Eḡa ona viḡaei! Eḡa aiai au wavau kaua babai ina kauei ma muriai ina parivai-apoapoeniu. ");
INSERT INTO wed_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aiai ravana eḡa ata ḡavia; lamna turata. ");
INSERT INTO wed_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tau a ririwana-kauemi. Mepa da aiai ravana, waira i veremi tau au wavau; aubaina taumi au Tauvotaḡotaḡo. Taui ai maia eḡa ina vine-boai.” ");
INSERT INTO wed_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Aiai ravana i kauei da wei teverana ana tumaḡana Tau awariu i viapoapoeni da ḡoʼapoapoe i kauei. Lamna i ai da ḡaima ḡaeḡaena ravana au uatabana ina duri ma au boga ina tawanei aubaina God, tauna ina kovoḡa-guratei. ");
INSERT INTO wed_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mepa da nimam i kauem da ḡoʼapoapoe u kauei. Ma bori-tawanei! I aii da nimam tagogiava ma lawana mamae-nonoana ma vaia. Ma eḡa ma kauei da nimam ruaḡa aiaii ma ma nae ai au menamenana; mepa ai eḡa melanai ita bobo. ");
INSERT INTO wed_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mepa da aem i kauem da ḡoʼapoapoena u kauei. Ma bori-tawanei! I aii da sigesigem au lawana mamae-nonoana ma rui. Eḡa me aem ruaḡa aiaii ma ai au menamenana ina tawanem. ");
INSERT INTO wed_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma mepa da matam ina kauem da ḡoʼapoapoena u kauei. Ma vaitawanei! I aii da matam tagogi ma God ana vigulau ma rui. Eḡa me matam ruaḡa ma ai au menamenana ina tawanem; ");
INSERT INTO wed_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","dobuna motamotana eḡa ita irairaḡe ma ai eḡa ita bobo. ");
INSERT INTO wed_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Au Tauvotaḡotaḡo anataputapui, ai araratanei ina bogai. ");
INSERT INTO wed_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Nia i ai lam viaiainana aubaina. Ma mepa da i tomatoma, mena ma vidagianei. Nia au orami ina mae ma ona viturana vivira!” ");
INSERT INTO wed_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma Iesu, dobuna i netawanei ma i nae Judea ana paratana. Ma Waira Jordan i damani da au baba ḡelauna. Patara ḡaeḡaena i riana-melei. Ma Iesu i viararamana, me mara patapatana i kaukauei nanare. ");
INSERT INTO wed_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma Pharisi ḡelaui i ḡoei da tauna ita waroi. Ma lamna aubaina i vitara-virevirei, “Tarawatu e mamae bo eḡa da rava, awana maiteni ita vilamonei?” ");
INSERT INTO wed_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma Iesu i paribelei, “Moses ana Tarawatu aiwai e ririwei?” ");
INSERT INTO wed_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma taui i riwa, “Moses ana Tarawatu e ririwa da oroto vilamona pepana ina girumi ma awana ina verei. Ma taui ina vilamonei.” ");
INSERT INTO wed_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu i paribelei, “Taumi orami i bada. Au baina Moses wei Tarawatuna i terei. ");
INSERT INTO wed_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wate ona notai da au karena, maranai God rava i kauei ma tauna oroto ma wavine i kauei. ");
INSERT INTO wed_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ma lamna aubaina oroto amana ma alona ina netawanei ");
INSERT INTO wed_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma awana maiteni ina vitagogi da taui eḡa ruaḡa me au naona ma tupua tagogi. ");
INSERT INTO wed_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God aiwai i vitagogiei, eḡa aiai ina vilamonei.” ");
INSERT INTO wed_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Maranai taui i naeme au numa, ma tauvotaḡotaḡo, Iesu i vitara-virevirei wei kauai aubaii. ");
INSERT INTO wed_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesu i paribelei, “Mepa da oroto, awana i voterei. Ma wavine ḡelauna i ravaḡi. Lamna tauna, awana awarina i rauiviapoapoe. ");
INSERT INTO wed_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma nanarena mepa da wavine, awana i voterei ma oroto ḡelauna i ravaḡi. Lamna awana, awarina i rauiviapoapoe.” ");
INSERT INTO wed_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Rava ḡelaui, roaroa i neiai Iesu awarina da urana au tepai ita terei. Ma ana tauvotaḡotaḡo, ravai i viḡaei. ");
INSERT INTO wed_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Maranai Iesu wei kauai i ʼnanai. Ma ana tauvotaḡotaḡo i eni ma i riwa, “Roaroa ona voterei da awariu ina nei. Ma eḡa ona viḡaei. Au baina God ana vigulau, lamna rava wenanare aubai me wei roaroai. ");
INSERT INTO wed_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A ririwana-kauemi. Aiai, God ana vigulau eḡa ina vaia me tevera aburuna nanare. Tauna, eḡa God ana au vigulau ina rui.” ");
INSERT INTO wed_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma roaroa i taravaini ma i rapai, urana au tepai i terei, i raupari ma i viaiaini. ");
INSERT INTO wed_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ma maranai Iesu i vomairi da i nenae. Oroto i ruba ḡeta ma au naona i raudune ma i riwa i pa, “Taugiu vinualaulaunam. Aiwai ana kauei da lawana maemae-nonoana ana vibuderiei?” ");
INSERT INTO wed_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Iesu i paribelei i pa, “Aiwai aubaina, tau u vikaua vinualaulauneu? God, tauna ava vinualaulaunana. ");
INSERT INTO wed_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tam, God ana Tarawatu u aramanei, Eḡa ma viraḡena! Eḡa ma awadanene! Eḡa ma danene! Eḡa ma viwavu-moru! Eḡa ma amkwalakwala! Amam ma Alom ma vivirei!” ");
INSERT INTO wed_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma tauna i riwei, “Taugiu! Maranai tau aburueu da amadodo, wei tarawatui anatapui a voteletelei.” ");
INSERT INTO wed_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu, tauna i ʼnanai ma i vinuavainei ma i riwei, “Kaua tagogi e mamae eḡa uta kaukauei. Ma nae ma am purapura anatapuna ma gimarei. Ma manena, rava molamolakai ma verei. Ma au mara God, tam ina vimaiem. Ma ma nei ma ma votaḡotaḡoiu!” ");
INSERT INTO wed_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma maranai oroto wei riwana i nonori. Naona i peu ma ana nuabolana i nae; aubaina tauna, purapura ravana. ");
INSERT INTO wed_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu i ʼnana viravira ma ana tauvotaḡotaḡo awari i riwa, “I piripiri kaua da purapura ravana, God ana au vigulau ina rui.” ");
INSERT INTO wed_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tauvotaḡotaḡo riwana i baiei maranai Iesu wenanare i babani. Ma Iesu i riwa me, “Natunatu! I piripiri kaua da purapura ravana, God ana au vigulau ina rui. ");
INSERT INTO wed_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I telatela kaua da ḡamoḡamo ḡaeḡaena wavana kamel, iḡoma au gavogavona ina rui. Ma i piripiri guratana da purapura ravana, ana lawana God ina verei. Ma God, tauna ina vibadei.” ");
INSERT INTO wed_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Taui i vinuanaina ma ai nota i kwa. Ma taui ava i babani vivira i pa, “Mepa da nanare; amapo aiai lawana mamae-nonoana ina vaia?” ");
INSERT INTO wed_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu awarii i ʼnana ma i riwei, “Rava awarii wei kauai i piripiri. Wate eḡa God awarina. God awarina aiwai anatapuna i telatela kaua.” ");
INSERT INTO wed_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma Peter i riwei, “Ma tauai menanare? Tauai ai purapura a voterei ma tam a votaḡoim.” ");
INSERT INTO wed_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu i paribelana, “A ririwana-kauemi. Aiai da ana numa bo varevareina bo novunovuna bo alona bo amana bo natunatuna bo ana wapu ina voterei ma tau ina votaḡotaḡoiu; tau ma Riwana Aiaina aubaina. ");
INSERT INTO wed_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Tauna ana maia ina rata kaua wei au dobuna. Tauna ana maia ina viaitepatepani da ana numa, varevareina, novunovuna, alona, natunatuna ma ana wapu, anatapui ina maḡa. Rava ina rau-iviapoapoelem; aubaina tam, tau au Tauvotaḡotaḡo da mara au murina tauna lawana mamae-nonoana ina vaia. ");
INSERT INTO wed_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wate maḡamaḡaui marina e vivinao; taui ina vimuri. Ma maḡamaḡaui da e vivimuri; ina vinao.” ");
INSERT INTO wed_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu, ana tauvotaḡotaḡo maiteni i ḡeḡae au Jerusalem. Iesu, taui au naoi i nenae. Tauvotaḡotaḡo i baiei. Ma rava ḡelaui au muri i nenei i rovo kaua. Ma taui 12 i rauḡorei au ririva ma i raukarei da kaua amapo da awarina ina tupua; taui i vieḡei ");
INSERT INTO wed_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I pa, “Ona inana, tauta ta ḡeḡae au Jerusalem. Ma Rava Natuna ina verenei pirisi babadai; ma tarawatu babadai awarii. Ma taui ana iraḡe ina vianinei. Ma Mai Jentail ina verei. ");
INSERT INTO wed_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma tauna ina vijiboḡi ma ina ovai ma ina kwapui ma ina viraḡeni. Au pom vitonuina ina vomairi me.” ");
INSERT INTO wed_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","- Zebedi natunatuna James ma John i nei Iesu awarina ma i vibaḡai i pa, “Tauviararamana! Tauai ai ḡoana a vivibaḡei uta kauei.” ");
INSERT INTO wed_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu i riwa i pa, “Aiwai o ḡoeḡoei ana kauei aubaimi?” ");
INSERT INTO wed_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Taui i paribelana, “Ma verelai da ana kiala, tagogi au oiem ma ḡelauna au kelakelaum am au vigulau.” ");
INSERT INTO wed_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iesu i paribelei, “Taumi eḡa ota aramanei aiwai o vivibaḡei! Iniviara kelakana ana umai. Taumi tagotagogina da ona umai bo? Tagotagogina ona babataito me tau ina babataitoiu?” ");
INSERT INTO wed_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","I paribelei, “Tauai tagotagogina!” Iesu i riwei, “Iniviara kelakana anina ona umai ma ona iraḡe me tau ana iraḡe. ");
INSERT INTO wed_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wate tau au rewapana eḡa ita mamae da ana veremi da mepa ona kiala au oieu bo au kelakelau. God, rava i vinevinei; taui ai gabu i vokaukauei.” ");
INSERT INTO wed_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Maranai Tauvotaḡotaḡo 10 ḡelaui, wei riwana i nonori. Taui James ma John awarii i ḡaiawa. ");
INSERT INTO wed_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Iesu, taui anatapui i ḡorei da awarina ma i riwei, “O aramanei da jentail ai babada, dobu ḡela ravai jentail awarii e mamae-ḡaeḡae ma e rarau-iviapoapoelei. Wate taui ai babada ḡaeḡaei, ai rewapana i ḡetelera da ai rava e vibadebadei da ai ḡoana e kaukauei. ");
INSERT INTO wed_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wate au tauvotaḡotaḡo eḡa nanare. Eḡa da aiai i ḡoei da ina ḡetelara taumi au poumi; tauna anina da ina vitaunola. ");
INSERT INTO wed_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aiai i ḡoei da ita vinao. Tauna ina vitaunola rava anatapui aubai. ");
INSERT INTO wed_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ma nanare Rava Natuna eḡa ita nei da tauna, tana nolei. Wate ita vitaunola rava aubaii. Ma ana lawana ita verenei da rava maḡamaḡaui ai lawana ita gimara-melei.” ");
INSERT INTO wed_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ma taui i ḡeta au Jeriko. Iesu, ana tauvotaḡotaḡo, patara ḡaeḡaena maiteni dobuna i opuopu-tawanei. Ma oroto mata-potapotana, wavana Batimeias, Timaeus natuna au etanai i kiakiala ma i viamgigimana. ");
INSERT INTO wed_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Maranai i nonori da tauna, Iesu Nasaretei; garara i raukarei i pa, “Iesu, tam David natuna! Ma raunuʼapoapoeleu!” ");
INSERT INTO wed_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Rava maḡamaḡaui, tauna i rai ma i riwei da ita genuana. Wate tauna, garara i voguratei, “David Natuna! Ma raunuʼapoapoeleu!” ");
INSERT INTO wed_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu i tumairi ma i pa, “Ona ḡoreiai!” Anina taui, mata-potapotana i ḡoreiai i pa, “Tepam ina tora ma ma vomairi! E ḡoreḡorem!” ");
INSERT INTO wed_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tauna, ana puru i tawanei ma i vomairi laḡilaḡina ma i nei Iesu awarina. ");
INSERT INTO wed_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu i paridadana i pa, “Aiwai u ḡoei ana kauei aubaim?” Mata-potapotana i paribelei, “Tauviararamana! A ḡoei da ana inana me.” ");
INSERT INTO wed_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu i riwa, “Ma nae! Am tumaḡana i vilawanim.” Maratagogi tauna i ʼnana me ma Iesu au eta i votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ma maranai Jerusalem i tuḡereḡerei ma i rui au Betphagi ma Bethani au ola Olives. Ma ana tauvotaḡotaḡo ruaḡa i paritawanei, ");
INSERT INTO wed_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma i riwei i pa, “Ona nae au melagai au naomi. Maranai o ruirui, kampa donki natuna ḡaubo, raḡiraḡitana ona nelaḡai. Tauna eḡa aiai ita geru-dadanei. Ona rupeni ma ona neiai. ");
INSERT INTO wed_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mepa da aiai ina paridadana, ‘Aiwai aubaina wei o kaukauei?’ Ona riwei, ‘Bada e ḡoeḡoei ma maratagogi ina paritawana-melei.” ");
INSERT INTO wed_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma i nae ma donki ḡaubona au doa au metaeta raḡiraḡitana i rupeni. ");
INSERT INTO wed_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Rava ḡelaui kampa i maimairi i paridadana i pa, “Aiwai o kaukauei donki ḡaubona o ruperupeni?” ");
INSERT INTO wed_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma i paribelei me Iesu i ririweia nanare ma taui i voterei da i nae. ");
INSERT INTO wed_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Taui donki i neiai Iesu awarina ma ai puru au uporana i tawana-epai ma au tepana Iesu i kiala. ");
INSERT INTO wed_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma rava maḡamaḡaui, ai puru au eta i ebani ma ḡelaui, ai rugurugu i tarataraia i ebani. ");
INSERT INTO wed_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Taui i vivinao ma taui au muri i nenei i garara: ");
INSERT INTO wed_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Viviaiainana amata David ana vigulau e nenei!” ");
INSERT INTO wed_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu i ḡeta au Jerusalem ma i rui au Tempol ma anatapuna i tuvirevirei ma au i biga aubaina, i opu me au Bethani, taui 12 maiteni. ");
INSERT INTO wed_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ma marana i tom, taui Bethani i opu-tawanei ma Iesu am-iraḡe. ");
INSERT INTO wed_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Au weia ma damala aina i ʼnanai ana ruguruguna. Ma i nae da ita inanai da i ua bo eḡa. Maranai kampa i ḡeta, eḡa aiwai ita nelaḡai. Anina ai ruguruguna ava, aubaina eḡa damala ana mara. ");
INSERT INTO wed_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iesu, damala aina i riwei i pa, “Eḡa aiai amadodo ma amapo anom ina am-melei!” Ma ana tauvotaḡotaḡo i nonori aiwai i latoni. ");
INSERT INTO wed_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Maranai taui i ḡeta au Jerusalem, Iesu i rui Tempol garina au orana ma taugimara i viaḡaḡana-opunei, mane tauviraina ai kepakepa ma gabubu taugimareina ai anikiala i vitauvirai. ");
INSERT INTO wed_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma i viḡaei da eḡa aiai ana gimara Tempol au orana ita avarai-naiei. ");
INSERT INTO wed_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma rava i viararamani i pa, “I girugirumia nanare, ");
INSERT INTO wed_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pirisi Babadai ma tarawatu Babadai i nonori ma i ogei da ita viraḡeni. Taui, Iesu i rovoei aubaina patara ana viararamana i baiei. ");
INSERT INTO wed_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma au bigai Iesu ana rava, Jerusalem i opu-tawanei. ");
INSERT INTO wed_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ma ubaubanai taui i nenae ma damala aina i ʼnanai anatapuna i poi. ");
INSERT INTO wed_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter i notai ma i riwa “Tauviararamana ma inana! Damala aina u parivai-irairaḡenia i poi.” ");
INSERT INTO wed_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu i paribelei, “God ona vitumaḡanei! ");
INSERT INTO wed_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A ririwana-kauemi. Rava wei olana ita riwei, ‘Ma vomairi ma au boga ma tawanem!’ Ma nuanuana eḡa ina raḡaraḡa ma ina vitumaḡana da aiwai e ririweia, ina tupua. ");
INSERT INTO wed_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lamna aubaina a ririwemi. Aiwai ami au pari o vibaḡei, ona vitumaḡana da taumi boiboḡi o vaia ma ina viḡarimiei. ");
INSERT INTO wed_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ma maranai e raraupari, au naona rava anatapui ai ḡoʼapoapoe awarim ma nota-tawanei. Ma nanare amam au mara am ḡoʼapoapoe ina nota-tawanei.” ");
INSERT INTO wed_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Taui i nememei au Jerusalem ma Tempol au orana i bababara. Ma Pirisi Babadai, Tarawatu Babadai ma dogadogara i nei Iesu awarina. ");
INSERT INTO wed_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma i paridadanei i pa, “Aiwai vibadanei wei kauai e kaukauei? Aiai vibadana i verem da wei kauai uta kauei?” ");
INSERT INTO wed_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu i paribelei i pa, “Au vitaraviravira tagogi ana terei ma ona paribeleu. Ma ana riwemi; aiwai vibadanei wei kauai a kaukauei. ");
INSERT INTO wed_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aiai, John taubabataito vibadana i verei da rava ita babataitoi, God bo rava? Ona riweu!” ");
INSERT INTO wed_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Taui i vitarapiri vivira, “Mepa da tana riwa, ‘Godei.’ Tauna ina riwa, ‘Ma aiwai aubaina eḡa ota vitumaḡanei?’ ");
INSERT INTO wed_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wate eḡa tana riwa da, ‘Ravei.” Taui rava i rovoei, aubaina rava anatapui, ai nota da John anina peroveta. ");
INSERT INTO wed_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma i paribelei, “Tauai eḡa ata aramanei.” Iesu i riwa, “Tau nanare eḡa ana riwemi aiwai vibadanei wei kauai a kaukauei.” ");
INSERT INTO wed_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu i vikarei ma awanainei awari i babani i pa, “Mara tagogi oroto, ana wapu i kauei ma grape i paewi ma i gari ma grape anigudana ma violaḡa numana i voai. Ma tauipi ḡelaui i verei da ita nolei taui anatapui aubai. Ma i vaḡai au dobu ḡela. ");
INSERT INTO wed_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tuaruta ana mara i ḡetai ma taniwaga, ana taunola i paritawanei tauipi awarii da ana ḡuta ita vaia. ");
INSERT INTO wed_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wate tauipi, tauna i vojijini ma i kwapui ma kwakwavina i paritawanei. ");
INSERT INTO wed_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ma taniwaga, taunola ḡelauna i paritawanei. Ma taui, kolana i viaibauni ma i vitepaubaubai. ");
INSERT INTO wed_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma taunola ḡelauna i paritawanei ma tauna i viraḡeni ma i maḡa ḡelaui i paritawanei, ḡelaui i kwapui ma ḡelaui i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ma tagogi ava e mamae da ina paritawanei. Lamna natuna orotona tagotago ana nuavainana. Ma tauna au murioina i paritawanei ma i pa, ‘Taui, natu ina vivirei.’ ");
INSERT INTO wed_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wate taui, tauna i ʼnanai ma i riwa vivira i pa, ‘Wei taniwaga natuna. Ona nei, tana viraḡeni ma ana buderi ina viḡaritaiei!’ ");
INSERT INTO wed_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma i vunui ma i viraḡeni ma tupuana wapuei i tawanana-opunei. ");
INSERT INTO wed_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—Wapu taniwagana marina aiwai ina kauei taui awarii? Tauna ina nei ma tauipi ina viraḡeni ma grape wapuna ina veredamanei tauipi ḡelaui awari. ");
INSERT INTO wed_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wei girumana o iavi bo eḡa? ‘Wei ḡaimana, tauvoa i geduaiei, wate muriai i nelaḡai da tauna ḡaima kaua. ");
INSERT INTO wed_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wei lamna, Bada ana kaua ma inanana i vinualaulauna.” ");
INSERT INTO wed_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jew babadai i aramanei da awanaina lamna taui i bababaniei ma i ḡoei da ita pani. Wate taui patara i rovoei, lamna aubaina Iesu i voterei ma i nae. ");
INSERT INTO wed_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ma Pharisi ḡelaui ma Herod ana rava ḡelaui i nae Iesu awarina da riwei ita waroi. ");
INSERT INTO wed_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Taui i nei ma i riwa, “Tauviararamana, tauai aramanei da tam rava jijimanim. Ma rava wavai naenaei ma rava labalababa eḡa uta vibainaenaei ma anatapui e vaivaia da tagogi. Wate tam God ana babani riwa kauei e viararamani. Ma riwelai tax tana terei Rome gulauna wavana Caesar awarina, i aii bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wate Iesu, ai moru i ʼnana-bauni ma i riwei, “Aiwai aubaina o raudadaniu? Mani tagogi ona neiai da ana inanai!” ");
INSERT INTO wed_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Denarius tagogi i neiai Iesu awarina ma taui i vitara-virevirei, “Wei aiai aruana ma wavana?” I paribelei, “Caesar.” ");
INSERT INTO wed_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iesu i riwa, “Aiwai Caesar ḡarinei, Caesar ona verei. Ma aiwai God ḡarinei, God ona verei!” Ma taui i baiei. ");
INSERT INTO wed_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mai Sadusi ai vitumaḡana da rava eḡa ita vovomairi-me maranai e irairaḡe. Anina ma ḡelaui i nei Iesu awarina ma i paridadanei, ");
INSERT INTO wed_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tauviararamana! God ana tarawatu, Moses wenanare i girumi: Mepa da oroto iʼraḡe ma kaiababana i netawanei ma eḡa natunatui. Oroto vareina kaiababana ina ravaḡi ma roaroa ina ḡuni vareina aubaina. ");
INSERT INTO wed_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mara tagogi varevarei seven i mae. Ma natuevou i tavine ma eḡa natunatuna ma oroto i ʼraḡe. ");
INSERT INTO wed_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Vareina viruaina kaiababa i ravaḡi ma tauna maiteni eḡa natuna ma i ʼraḡe. Ma nanare vareina vitonuina. ");
INSERT INTO wed_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma nanare anatapui seven, wavinena i ravaḡi ma eḡa natunatui. Au muriai wavine iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Anatapui seven, wavinena i ravaḡi. Vomairi me au marana, lamna aiai awana?” ");
INSERT INTO wed_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu, taui i riwei, “Aiwai Moses i girumi ma God ana rewapana eḡa ota aramanei. ");
INSERT INTO wed_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maranai taui iraḡelei ina vomairi, taui eḡa ina tavine bo ina vitavinei. Wate ina mae me anela au mara. ");
INSERT INTO wed_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma rava iraḡelei ai vomairi babanina, Moses ana tarawatu eḡa ota iavi bo? Mepa ai i ararata lana, kampa God Moses i riwei: Tau Abraham ana God ma Isaac ana God ma Jacob ana God. ");
INSERT INTO wed_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tauna eḡa rava irairaḡei ai God, wate rava lawalawai ai God. Taumi o moru kaua!” ");
INSERT INTO wed_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma tarawatu badana tagogi i nae ma ai vitarapiri i nonori. Ma i nonori da Iesu i babani kaua, lamna aubaina tauna i vitara-viravira, “God ana tarawatu metauna i ḡetelara?” ");
INSERT INTO wed_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu i paribelei, “Ḡeḡetelarana tagogi lamna wei: Ona rautaniḡana Israel! Bada ata God, tauna ava Bada. ");
INSERT INTO wed_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bada ami God nuanuami ina vaia orami anatapunei ma aruami anatapunei ma ami nota anatapunei ma ami rewapana anatapunei! ");
INSERT INTO wed_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma viruaina lamna wei: Rava ḡelaui nuanuam ina vaia me tam nuanuam e vaivai-melei! Wei tarawatui ruaḡa i ḡetelara, eḡa me ḡelaui nanare.” ");
INSERT INTO wed_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tarawatu badana i riwa, “Tauviararamana u babani kaua! Riwa kaua u babaniei, Bada Tauna ava God ma eḡa mepa ḡelauna. ");
INSERT INTO wed_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma nuanuami ina vaia orami anatapunei ma ami nota anatapunei ma ami rewapana anatapunei. Ma, Rava turam nuanuam ina vaia me tam nuanuam e vaivai-melei. Wei tarawatui ruaḡa lamna i ḡetelera, eḡa me pulo apuapunana bo pulo ḡelaui.” ");
INSERT INTO wed_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu i ʼnanai da tauna i paribelana kaua ma i riwei, “Tam, God ana vigulau au ḡereḡerena e ḡeḡeta.” Ma eḡa aiai tepana ita tora da Iesu ita vitara-viravirana-melei. ");
INSERT INTO wed_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Maranai Iesu au Tempol i viararamana ma i vitara-viravira i pa, “Aiwai aubaina Tarawatu Babadai e ririwa da Keriso tauna David natuna? ");
INSERT INTO wed_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Arua Vivivireina, David nota i verei ma tauna i riwa: ");
INSERT INTO wed_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","—David, tauoina wei gulauna i ḡorei bada. Ma menanare da badana lamna, David natuna?” Patara ḡaeḡaena riwana i nonori ma i vinuaiai. ");
INSERT INTO wed_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma Iesu, taui i viararamani i pa, “Tarawatu babadai ona rovoei. Ai gara manamanai ma e bababara nae au deba da rava taui e vivivirei. ");
INSERT INTO wed_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Taui anikiala vinevinei pari au numana ma au torela, gabu aiaii e vaivaia. ");
INSERT INTO wed_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Taui, kaikaiababa e morumorui ma ai numa e kwalekwalei, e morumoru ma e raraupari-vai-manamanawa. Taui ai kovoḡa ina apoapoe guratana.” ");
INSERT INTO wed_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ma Iesu, pulo aniterenana au baba ḡelauna i kiala ma rava i ʼnananai mane i tereterei. Rava maḡamaḡaui vivimanei, mane maḡamaḡaui i terei. ");
INSERT INTO wed_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wate kaiababa molamolakana i nei ma mane muomuoi ruaḡa i terei, ruvana i aburu kaua. ");
INSERT INTO wed_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ana tauvotaḡotaḡo i ḡorei ma i riwei, “Anina a ririwemi, wei kaiababa molamolakana i tere-guratei, eḡa me taui ḡelaui. ");
INSERT INTO wed_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Taui ḡelaui ai maurei i verena, wate wei kaiababa molaka ma ḡarinei anatapuna i terei, ana anilawana anatapuna.” ");
INSERT INTO wed_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu, Tempol i nene-tawanei ma ana tauvotaḡotaḡo tagogi i riwa, “Tauviararamana! Numa i viḡulau ḡaḡa ma numa ḡaimai i rata ḡaḡa.” ");
INSERT INTO wed_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu i paribelei, “Wei numai ḡaeḡaei u inanai, eḡa ḡaimai tagogi, turana au tepana ina mae. Ḡaima anatapui ina rikai.” ");
INSERT INTO wed_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu i kiakiala au ola Olives, Tempol au navanavaḡela ma Peter, James, John ma Andrew i nei ma i vitaraviravirana govaḡei ");
INSERT INTO wed_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","i pa, “Ma riwelai mara aiwai wei kauai ina tupua? Ma aiwai ina vimataira da wei kauai anatapui ina tupua?” ");
INSERT INTO wed_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu, taui i riwei, “Ona inana kaua da eḡa aiai ina terevaideḡaimi! ");
INSERT INTO wed_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Rava maḡamaḡaui, wavauei ina nei ma ina riwa, ‘Tau Keriso tauvilawana!’ Ma rava maḡamaḡaui ina terevaideḡai. ");
INSERT INTO wed_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma maranai viḡavia ona nonori ma viḡavia aueia riwana ona nonori; eḡa ona rovo! Wei kauai anina da ina tupua, wate wei eḡa damona. ");
INSERT INTO wed_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dam, damai ina viḡavia vivira ma dobu, dobuai ina viḡavia vivira. Ma lolo ma gomara dobu au anatapuna. Wei kauai, lamna me wavine ana iniviara e vivikarei maranai e vivinatuna. ");
INSERT INTO wed_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Ona inana kaua! Taumi ina panimi ma ina etaremi ma pari numana au orana ina kwapuimi. Ma gavena ma gugulau au naoi ona mairi, aubaina taumi o votaḡotaḡoiu. Ma taui awarii, Riwa Aiaina ona raugugulei. ");
INSERT INTO wed_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Riwana Aiaina ona raugugulei rava anatapui awari ma muriai damona ina nei. ");
INSERT INTO wed_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma maranai i panimi ma i etaremi. Eḡa ona vinuabola da aiwai ona latoni. Aiwai riwana God i veremi, lamna ona latoni. Aiwai o latoni lamna eḡa taumi ota babani, wate Arua Vivivireina. ");
INSERT INTO wed_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Rava, vareina ina verenei da ina viraḡeni. Ma ama, natunatuna ina verenei da ina viraḡeni. Ma roaroa, amamai ma aloloi ina viḡaviei da ina iraḡe. ");
INSERT INTO wed_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Rava anatapui ina geduaiemi tau aubaiu. Wate aiai da e maimairi-jijina da au damona, tauna ina lawana.” ");
INSERT INTO wed_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Maranai ‘Kaua apoapoe kaukauana’ e maimairi mepa avena ita mairi. (Buka tauiavana wei ina aramanei anona aiwai). Taui aiavoi au Judea ina ruba laḡilaḡina au ola. ");
INSERT INTO wed_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aiai numa au tepana eḡa ina ḡaira bo ina rui au numa da aiwai ina vaia. ");
INSERT INTO wed_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aiai au wapu eḡa ina naeme au numa da ana gara ina vaia. ");
INSERT INTO wed_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma iniviara ḡaeḡaena, waivine duaduamai ma taui da e viviḡuḡu awari nai au marana! ");
INSERT INTO wed_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","God awarina ona raupari da wei kauai eḡa au bodu ina tupua. ");
INSERT INTO wed_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ma nai au marana amapo iniviara ḡaeḡaena. Ma maranai God dobu i kauei, iniviara ḡaeḡaena eḡa nanare ita tupua ma amapo eḡa nanare ina tupua me. ");
INSERT INTO wed_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wate Bada nai marana ina vitupoi. Mepa da eḡa ina vitupoi, rava anatapui ina iraḡe. Wate rava, tauna ana vinevine ina vilawani lamna aubaina mara ina vitupoi. ");
INSERT INTO wed_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","—Muriai keriso tauvilawana morumorui ma peroveta morumorui ina nei ma mataira ma kaua babai ina kauei ma ina kauana dadanei da God ana vinevine maiteni ita terevaideḡai. Lamna aubaina mepa da aiai ina riwemi, ‘Ma inanai, Tauvilawana noi!’ bo ‘Tauna noi!’ Nai babanina eḡa ona vitumaḡanei! ");
INSERT INTO wed_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ona inana kaua; anatapuna a riwana-nonoemi!” ");
INSERT INTO wed_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesu wenanare i riwa, “Ma iniviara ḡaeḡaena au murina. ");
INSERT INTO wed_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma ubona marei ina peu ");
INSERT INTO wed_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","—Nai maranaina, Rava Natuna ana rewapanana ma ana borumana apauei ina nei. ");
INSERT INTO wed_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma Tauna, ana anela ina paritawanei dobu au anatapuna da rava tauna ana vinevine ina tuarui dobu au damona da dobu ḡela au damona.” ");
INSERT INTO wed_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Damala aina ana awanaina ona aramanei. Maranai ai e numonumoi, lamna ona aramanei da maura e tuturiai. ");
INSERT INTO wed_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ma nanare, maranai wei kauai anatapui ina tuputupua, ona aramanei da Rava Natuna i turiai; au metaeta i ḡetai. ");
INSERT INTO wed_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Anina a ririwemi da wei kauai au naona ina tupua ma muriai da rava marina lawalawaii ina iraḡe. ");
INSERT INTO wed_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mara ma dobu ina amoa. Wate riwau eḡa ina amoa.” ");
INSERT INTO wed_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ma eḡa aiai ita aramanei nai marana bo madeḡa aiwai ina nei. Anela au mara eḡa ita aramanei ma Natuna eḡa ita aramanei. Amana, tauna ava i aramanei. ");
INSERT INTO wed_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ona vineneḡana ma matami ina kala! Eḡa ota aramanei mara aiwai, wei kauai ina tupua. ");
INSERT INTO wed_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wei me rava ana numa i netawanei ma i vaḡai. Ma ana taunola nununai i terei da ita vipaipai ma tagotagogi ava ai nola i verei da ita kauei. Ma tauvineneḡana i riwei da ita vineneḡana. ");
INSERT INTO wed_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ona vineneḡana! Eḡa ota aramanei mara aiwai, numa taniwagana e nenei; mepa da au bigai bo au nubautuva bo maratomtomai bo ubaubanai. ");
INSERT INTO wed_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma eḡa matamatavemi ina nelaḡaimi. ");
INSERT INTO wed_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aiwai riwana a ririwemi, riwana tagogina rava anatapui a riwei, ona vineneḡana!” ");
INSERT INTO wed_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Au pom ruaḡa muriai da Raḡona ma Palawa Bagibagina torelai, Pirisi babadai ma Tarawatu Babadai eta i baibaiei da menanare govagovaḡanei Iesu ita vunui. ");
INSERT INTO wed_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma i riwa, “Au torela wei kauai eḡa tana kauei, mepa da viḡaiḡaiawa ḡaeḡaena ina tupua.” ");
INSERT INTO wed_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Maranai Iesu au Bethani, Simon i ḡoreḡorei lepeleperana ana au numa i kiala ma i amam. Wavine, wagi wavana alabaster i voai ma i ḡeta ma wagi uana i vogai ma daji ḡabuḡabuna, maiana ḡaeḡaena e ḡoreḡorei nard, Iesu au kolana i waḡi. ");
INSERT INTO wed_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rava ḡelaui kampa i mamae i ḡaiawa ma i riwa, “Aiwai aubaina daji u vikalokaloei? ");
INSERT INTO wed_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wei dajina ita gimarei 300 denarii ruvana ma manena molamolakai ita verei.” Ma taui, wavine i vienenei. ");
INSERT INTO wed_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wate Iesu i riwa, “Ona voterei! Aiwai aubaina o vinuabolai? Tauna, kaua aiaina awariu i kauei. ");
INSERT INTO wed_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Molamolakai awarimi e mamae-nonoa ma ona ḡoei ma taui ona voagui. Wate tau awarimi eḡa ata mamae-nonoa. ");
INSERT INTO wed_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wavine ana nola i kauei. Tauna, dajiei tupuau i vokaukauana-nonoei vikokoaga aubaina. ");
INSERT INTO wed_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A ririwana-kauemi, mepa Riwana Aiaina i raugugulei dobu au anatapui, wei wavinena aiwai i kaukauei ina babaniei, ma eḡa nuanuai ina vuru.” ");
INSERT INTO wed_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskariotei tauna Apasol tagogi, Pirisi Babadai awari i ḡeta da Iesu ita vibenabenamei. ");
INSERT INTO wed_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Taui i vinuaiai kaua maranai wei i nonori ma Judas i parivainuaḡani da mane ita verei. Ma Judas i ʼnana da mepa gavogavo ita inanai da Iesu ita amverenei. ");
INSERT INTO wed_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ma Palawa Bagibagina torela ina vikarei. Maranai sipu orotoi ḡauboi e vunuvunui Raḡona torelana aubaina. Tauvotaḡotaḡo, Iesu i paridadanei, “Mepa u ḡoeḡoei Raḡona torelana ana vokaukauei aubaim?” ");
INSERT INTO wed_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iesu, taui ruaḡa i riwei ma i paritawanei, “Ona nae au Jerusalem ma oroto, waira wagina e avavarai ona inanai ma ona votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Au numana e ruiruiana, numa taniwagana ona riwei, ‘Ai tauviararamana i riwa, “Numa vokaukauana mepa ma au Tauvotaḡotaḡo maiteni Raḡona torelana ana ani?” ");
INSERT INTO wed_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Ma tauna, numa vatavatara ina viatataiemi i vokaukauana-nonoei ma kampa aubaita ona vokaukaua.” ");
INSERT INTO wed_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tauvotaḡotaḡo i nae au Jerusalem ma i ririweia nanare i nelaḡai ma Raḡona torelana i vokaukauei. ");
INSERT INTO wed_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Au i biga ma Iesu i nei Apasol maiteni. ");
INSERT INTO wed_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Taui au kepakepa i amam ma Iesu i riwa, “Anina a ririwemi. Taumi tagogi ina vibenabenameu; tagogi weka maiteni amam.” ");
INSERT INTO wed_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tauvotaḡotaḡo i vinuabola ma tagotagogi ava i pa, “Eḡa tau tapa?” ");
INSERT INTO wed_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu i paribelei, “Taumi tagogi weka palawa e vivigaloi au aboma tau maiteni. ");
INSERT INTO wed_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wariaḡa i girugirumia nanare, Rava Natuna ina iraḡe. Wate aiai da Rava Natuna i vibenabenamei; tauna, kovoḡa ḡaeḡaena ina vaia! I aii da alona avena ita vinatunei.” ");
INSERT INTO wed_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Maranai i amam ma Iesu palawa i vaia ma i viegualau, i vogimagimai ma Tauvotaḡotaḡo i verei ma i riwa, “Ona vaia; wei tupuau.” ");
INSERT INTO wed_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Anina ma wine kelakana i vaia ma i viegualau ma i verei da anatapui i umei, ");
INSERT INTO wed_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Wei tau tarau i toi rava maḡamaḡaui aubai ma au parivainuaḡana bagibagina ina vovai-virewapani. ");
INSERT INTO wed_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anina a ririwemi, wine eḡa ana uma-melei da maranai God ana rava aubaii ana vigulau.” ");
INSERT INTO wed_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ma taui voepaepa welana i ravi ma i ḡae au Ola Olives. ");
INSERT INTO wed_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu, taui i riwei “I girumi nanare, God i riwa, ‘Tauviḡamoḡamo ana viraḡeni ma sipu ina vilamonei.’ Ma nanare anatapumi ona ruba-tawaneu. ");
INSERT INTO wed_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wate au vomairi au murina ana aivinao au Galili.” ");
INSERT INTO wed_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter i riwa, “Mepa da anatapui ina rubatawanem, wate eḡa tau!” ");
INSERT INTO wed_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu, Peter i riwei, “A ririwana-kauem da amadodo waguvarai muriai da kokorereko ina tou mara ruaḡa; tam mara tonuḡa ma bovieu.” ");
INSERT INTO wed_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wate Peter, ponana i bagibagi ma i riwa, “Avena mepa da tau, tam maiteni ana iraḡe. Eḡa melanai ana boviem!” Ma taui ḡelaui riwana tagogina i latoni. ");
INSERT INTO wed_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ma au Gethsemani i ḡeta ma Iesu, ana tauvotaḡotaḡo i riwei, “Weka ona kiala ma ana raupari.” ");
INSERT INTO wed_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma Peter, James ma John i taravaini ma nuanuana iʼraḡe ma nuanuana i bola-kauei. ");
INSERT INTO wed_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma taui i riwei, “Au nuabola i rata kaua au orau da e vunuvunuiu. Weka ona mae ma ona vineneḡana.” ");
INSERT INTO wed_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma aburuna i verau-nae ma au doa i peu ma i raupari da mepa da tagotagogina, lamna wei marana apoapoena tauna ita netawanei. ");
INSERT INTO wed_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I riwa i pa, “Abba Amau! Aiwai anatapuna tagotagogina tam awarim. Wei kovoḡa kelakana ma vaitawanei. Wate eḡa tau au ḡoana, wate tam am ḡoana.” ");
INSERT INTO wed_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ma Iesu i nememei ma taui tonuḡa rarau-nuavurui i nelaḡai. Ma Peter i riwei, “Simon! tam aiwai matavena? Mara aburuna uta vineneḡana bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma Iesu, taui i riwei, “Ona vineneḡana ma ona raupari da eḡa au rauelara ona peu! Arua e ḡoeḡoei, wate tupua i ḡokokokara.” ");
INSERT INTO wed_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma i naeme ma parina tagogina i raupariei. ");
INSERT INTO wed_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Maranai i nememei ma i nelaḡai, i matamatave; taui, matai i vitai. Ma taui eḡa ita aramanei aiwai ita riwei. ");
INSERT INTO wed_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mara vitonuina i nene-memei ma taui i riwei, “Taumi amapo ona matamatave ma laumi ina tautau? Anina! Mara i ḡetai, ona inanai. Rava Natuna ina vibenabenamei ḡoʼapoapoe ravai au urai. ");
INSERT INTO wed_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ona vomairi; tana nae; ona inana! Tauvibenabenameu e nenei!” ");
INSERT INTO wed_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu i bababani ma Judas, tauna ana Tauvotaḡotaḡo tagogi i ḡetai. Tauna, patara ana apiai maiteni i nei. Pirisi Babadai ma Tarawatu Babadai ma dogadogara, wei ravai i paritawaneiai. ");
INSERT INTO wed_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Muriai da Iesu awarina ita ḡeta; Judas, patara ai mataira i verei, “Orotona ana vigia laḡolaḡonei; nai tauna. Ona pani ma ona naiei ma ona inana-kauei!” ");
INSERT INTO wed_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Maranai Judas i ḡeta ma i nae Iesu awarina ma i riwei, “Tauviararamana!” Ma i vigia-laḡolaḡonei. ");
INSERT INTO wed_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma taui, Iesu i vojijini ma i pani. ");
INSERT INTO wed_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma tagogi kampa i maimairi, ana sword i taina-lavui ma Pirisi ḡeḡetelarana ana taunola taniḡana i borituini. ");
INSERT INTO wed_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma Iesu, taui i riwei, “Taumi ana apiami o nei da ota paniu bo, apamina tau amkwalakwalau? ");
INSERT INTO wed_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Marana patapatai taumi maiteni ta mamae au Tempol ma a viararamana ma eḡa ota paniu. Ma i girugirumia nanare, ina tupua.” ");
INSERT INTO wed_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ma Tauvotaḡotaḡo anatapui, Iesu i voterei ma i ruba-tawanei. ");
INSERT INTO wed_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma laraga tagogi, i vikareko ma Iesu i votaḡotaḡoi. Taui i ḡoei da ita vojijini, ");
INSERT INTO wed_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wate ana kareko i vojijini ma tauna ana kovakovana i ruba. ");
INSERT INTO wed_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ma taui, Iesu i naiei Pirisi Ḡeḡetelarana. Pirisi Babadai, dogadogara ma Tarawatu Babadai mepa i vitagogieiana. ");
INSERT INTO wed_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Peter i votaḡotaḡo da Pirisi Ḡeḡetelarana ana numa. Ma ana au debadeba, purusimani maiteni i kiala ma i viviairara. ");
INSERT INTO wed_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pirisi Babadai ma mai Jew ai boru ḡeḡetelarana, Iesu ana apoapoe i baiei da ita viraḡeni; ma i baiana-avei. ");
INSERT INTO wed_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Matamata maḡamaḡaui, Iesu i viwavu-morumoruei, wate ai viwavu taputapunei ava. ");
INSERT INTO wed_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma ḡelaui i vomairi ma wei wavuna morumoruna i kauei Iesu awarina, ");
INSERT INTO wed_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tauai a nonori tauna i riwa, ‘Wei tempolna i voavoaia. Tau ana rikai ma au pom tonuḡa au murina, Tempol ḡelauna ana voai ma lamna eḡa rava ita voai.” ");
INSERT INTO wed_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wate nanare ai viwavu taputapunei ava. ");
INSERT INTO wed_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pirisi ḡeḡetelarana i mairi taui au naoi ma Iesu i vitara-virevirei, “Wei ravai e viviwavuim ma eḡa aiwai ma paribelei bo?” ");
INSERT INTO wed_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Iesu i genuana ma eḡa ita paribelei. Ma Pirisi ḡeḡetelarana i vitaraviravirana-melei, “Tam Keriso tauvilawana bo? Viviaiainana Natuna bo?” ");
INSERT INTO wed_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu i paribelana, “Tau tauna! Ma Rava Natuna ona inanai, Vivirewapanana au oiena ina kiala ma mara ladanei ina nei. ");
INSERT INTO wed_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pirisi ḡeḡetelarana, amlona i ḡaiḡai ma ana gara i sikai ma i riwa, “Aiwai aubaina matamata ḡelaui tana ḡoei? ");
INSERT INTO wed_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Taumi, vijiboḡa o nonori ma ami nota aiwai?” Taui anatapui i riwa, “Tauna ana ḡoʼapoapoe aubaina anina da ina iraḡe!” ");
INSERT INTO wed_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma ḡelaui i raukarei ma Iesu i ovai ma naona i purui; i raunavanavai ma i riwei, “Ma pariverelai, aiai i ravim!” Ma tauvipaipai, Iesu i vaia ma i vunui. ");
INSERT INTO wed_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ma Peter au gabaura i mamae ma Pirisi ḡeḡetelarana ana taunola guguini i ḡetai. ");
INSERT INTO wed_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Maranai tauna, Peter i ʼnanai i viviairara; ma i ʼnana-tunutunui ma i riwa, “Tam maiteni Iesu Nasaretei, ana tauvotaḡotaḡo!” ");
INSERT INTO wed_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wate tauna i bovi ma i riwa, “Eḡa ata aramanei aiwai e bababaniei, a vinuanainei!” Ma i tuopu au metaeta ma kokorereko i tou. ");
INSERT INTO wed_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Taunola guguini, Peter i ʼnanai ma i raukarena-melei ma rava au ḡereḡere i maimairi i riwei, “Wei ravana, taui tagogi!” ");
INSERT INTO wed_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wate Peter i bovi me. Mara aburuna muriai, taui au ḡereḡere i maimairi, Peter i riwana-melei, “Tam anina, taui tagogi; aubaina tam, Galiliei!” ");
INSERT INTO wed_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma Peter i riwa, “God au matana, tau a ririwa kaua, ravana o ririweia a vivinuanainei!” ");
INSERT INTO wed_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Maratagogi kokorereko i tou mara viruaina ma Peter, Iesu riwana i notai - Muriai da kokorereko ina tou mara ruaḡa, tam mara tonuḡa ma bovieu. Ma Peter i vinuabola kaua ma i tou. ");
INSERT INTO wed_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ubaubanai boiboḡi, pirisi babadai ma dogadogara ma tarawatu babadai anatapui i viboru ma i vianina da Iesu i pani ma i veredamanei Pilate au urana. ");
INSERT INTO wed_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate, Iesu i vitara-virevirei i pa, “Tam mai Jew ai gulau bo?” Iesu i paribelei i pa, “Anina e ririwa nanare.” ");
INSERT INTO wed_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pirisi Babadai e viviwavuim kaua maḡamaḡaui aubai. ");
INSERT INTO wed_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma nanare Pilate, Iesu i vitaraviravirana-melei i pa, “Tam ma paribelana bo eḡa? Ma nonori e viviwavuim kaua maḡamaḡaui aubai!” ");
INSERT INTO wed_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wate Iesu i genuana ma eḡa ita paribelei. Ma Pilate i ba kaua. ");
INSERT INTO wed_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Taui ai kaua maemaena da Raḡona Torelana au marana, Pilate, panipani tagogi, rava ai ḡoanei e ruperupeni ma e vovoterei da e nenae. ");
INSERT INTO wed_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oroto tagogi wavana Barabas; tauna Rome gabemani i viḡaviei ma i pani da panipani au numana i mamae. Ana rava maiteni tauviraḡena. ");
INSERT INTO wed_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ma patara i ḡeta da Pilate ita vibaḡai da panipani tagogi ita rupeni Raḡona Torelana au marana. ");
INSERT INTO wed_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilate i paribelei, “Taumi o ḡoeḡoei da mai Jew ai gulau ana rupeni aubaimi bo?” Pilate i aramanei da Pirisi Babadai, Iesu i unurei ma lamna aubaina Iesu i veredamanei tauna awarina. ");
INSERT INTO wed_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wate Pirisi Babadai, patara i egari da Pilate, Barabas ita rupeni ma eḡa Iesu. ");
INSERT INTO wed_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate, patara i paridadana-melei i pa, “Tauna o ḡoreḡoreia mai Jew ai gulau mena ana kauanei?” ");
INSERT INTO wed_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Taui i garara, “Ma tuparatui!” ");
INSERT INTO wed_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate i riwa, “Aiwai apoapoena i kauei?” Ma taui i garara guratana, “Ma tuparatui!” ");
INSERT INTO wed_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate i ḡoei da patara ita vinuaubai ma Barabas i rupeni ma sorodia i egari da Iesu i kwapui da i vitaratarai ma i naei da ita tuparatui. ");
INSERT INTO wed_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sorodia, Iesu i taravaina-ruiei Pilate ana au numa ma ai rava ḡelaui i ḡoreiai. ");
INSERT INTO wed_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma gara lebalebarina me gulau ana gara Iesu i vioteni ma kunuteia ai donadonanei i viri da au kolana i terei. ");
INSERT INTO wed_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma vinamana i raukarei ma i garara, “Egualau mai Jew ai gulau!” ");
INSERT INTO wed_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma kolana gonuei i raviravi ma i ovaovai. Ma ae-tutuiei i mae-ḡaira au doa ma i raudunelei ma i vivinamei. ");
INSERT INTO wed_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma i vijiboḡa vorovei ma gara lebalebarina i voḡiḡi-tawanei ma ana gara i vioteni. Ma i taravaina-opunei da ita tuparatui. ");
INSERT INTO wed_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Taui i nenae ma Simon i nelaḡai, rava Sairiniei (tauna Rufus ma Alexander amai). Simon wapuei i nenei. Ma sorodia, tauna i egari da Iesu ana korosi i avarai. ");
INSERT INTO wed_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Taui, Iesu i naiei da gabu i ḡoreḡorei Golgotha, lamna anona unu gabuna. ");
INSERT INTO wed_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sorodia, wine bunama myrrh maiteni i virai ma Iesu i veredadani, wate tauna i geduaiei. ");
INSERT INTO wed_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma Iesu i tuparatui ma ana gara, taui ava au orai i ḡutai. ");
INSERT INTO wed_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ubaubanai 9 kilok nanare, Iesu i tuparatui. ");
INSERT INTO wed_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aniviwavuna i girumi ma i tutui, “Mai Jew ai gulau.” ");
INSERT INTO wed_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Danedanenei ruaḡa, Iesu au ririvana i tuparatui; tagogi au oiena ma ḡelauna au kelakelauna. ");
INSERT INTO wed_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Taubabara, kolai i kwajikwajiei ma Iesu i vivinamei, “Na! Tam Tempol taurikaina ma au pom tonuḡa ma voa-melei. ");
INSERT INTO wed_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ma vilawana-melem ma korosiei ma ḡairai!” ");
INSERT INTO wed_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma nanare Pirisi Babadai ma Tarawatu Babadai maiteni, Iesu i vivinamei, “Rava ḡelaui i vilawani, wate ainelana ita vilawana-melana-avei. ");
INSERT INTO wed_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keriso Tauvilawana, Israel ana gulau; marina korosiei ma ḡairai ma tana inanai da tana vitumaḡanei!” Danedanenei i tupatuparatui maitenai, Iesu i vinamei. ");
INSERT INTO wed_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ma au benai dobu anatapuna i waguvarei da 3 kilok au bigai. ");
INSERT INTO wed_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Lamna maranaina Iesu ponana i rata ma i kwatu, “Eloi, Eloi, lama sabachthani?” Lamna anona, “Au God, au God aiwai aubaina u netawaneu?” ");
INSERT INTO wed_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma rava ḡelaui au ḡereḡere i maimairi i nonori ma i riwa, “Ona rautaniḡanei, Elijah e kwatukwatuei!” ");
INSERT INTO wed_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma rava tagogi i ruba da gara ai au damona i pani ma au wine tomatomana i vigaloi ma i voepai Iesu au ipirina ma i riwa, “Ona vipaipai ma tana inanai mepa da Elijah ina nei da ina tereḡairei.” ");
INSERT INTO wed_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Iesu ponana i rata ma i kwatu ma i lavutu tawanana. ");
INSERT INTO wed_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma Tempol au orana anitereḡaḡara au pouna i wanasikai au tepana da i ḡaira au doa. ");
INSERT INTO wed_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma sorodia ai bada, Iesu au naona i maimairi; i ʼnanai da i lavutu tawanana ma i riwa, “Wei anina God Natuna.” ");
INSERT INTO wed_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Waivine ḡelaui aueia i mae ma i raraubiga: Mary Magdalene ma Mary (James keikeina ma Joses aloi) ma Salome. ");
INSERT INTO wed_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Taui, Iesu i votaḡotaḡoi ma i vovoagui maranai au Galili i mamae ma waivine ḡelaui maḡamaḡaui, tauna maiteni i ḡeḡae au Jerusalem, anatapui kampa. ");
INSERT INTO wed_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma au biga i tuturiai Joseph Arimatheaei tauna rava ḡaeḡaena tagogi boru ḡetelarana au orana. Tauna God ana vigulau ana nei i vipaipaiei. Ma vokaukaua marana (Lamna Sabat au naona) ma Joseph ana tepatorana, Pilate awarina i rui ma Iesu taubeuna i vibaḡei. ");
INSERT INTO wed_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate i baiei da Iesu boiboḡi iʼraḡe. Tauna, sorodia ai bada i kwatuei ma i vitara-virevirei da Iesu iʼraḡe bo eḡa? ");
INSERT INTO wed_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Maranai sorodia ai bada i pariverei da anina riwa kaua. Ma Pilate, Joseph i riwei da Iesu tupuana i vaia. ");
INSERT INTO wed_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph, gara maiana ḡaeḡaena i gimarai ma Iesu tupuana i tere-ḡairei. Garei i umai ma au guba tupuana i vimataveni ma ḡaima ḡaeḡaena i kaipeuri da kokoaga metaetana i viaitomeni. ");
INSERT INTO wed_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene ma Mary - Joses alona i ʼnanai mepa Iesu taubeuna i vimataveni. ");
INSERT INTO wed_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ma Sabat au murina, Mary Magdalene ma Mary - James keikeina alona ma Salome, bunama ḡabuḡabui i gimarai da i naiei da Iesu tupuana ita buloi. ");
INSERT INTO wed_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ma Sunday ubaubanai boiboḡi maranai madeḡa i gogogo, taui i nae au kokoaga. ");
INSERT INTO wed_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma i nenae ma i bababani, “Aiai aubaita ḡaima kokoaga au metaetana ina kaipeura-tawanei?” ");
INSERT INTO wed_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Maranai taui i taepai, i ʼnanai da boiboḡi ḡaima i kaipeura-tawanei - ḡaima ḡaeḡae kaukauana. ");
INSERT INTO wed_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Maranai i rui au guba ma oroto laragana ana gara ararapoirina i ʼnanai au oiena. Ma taui orai i auepai. ");
INSERT INTO wed_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Oroto laragana i riwa, “Eḡa orami ina auepai, taumi, Iesu Nasaretei o baibaiei bo? I tupatuparatuia; tauna i vomairi! Ona inana, tauna eḡa weka! Taui weka taubeuna i vimataveni. ");
INSERT INTO wed_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Marina ona nae ma ana tauvotaḡotaḡo ona riwei, ma Peter eḡa nuanuami ina vuru da Iesu e vivinao au Galili. Kampa ona inanai i ririwemi nanare.” ");
INSERT INTO wed_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Taui i opu ma kokoagei i viruberubei ana ini sisisi ma ana rovoi. Taui i rovo kaua, lamna aubaina eḡa rava ita riwei. ");
INSERT INTO wed_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu iraḡelei i vomairi me au Sunday ubaubanai boiboḡi ma i ainae da Mary Magdalene awarina i eḡa. Maraotai Iesu, Mary awarina arua-apoapoei seven i viopuni. ");
INSERT INTO wed_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iesu, ana tauvotaḡotaḡo i vivinuabola ma i toutou ma Mary i ḡeta da i pariverei. ");
INSERT INTO wed_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma Mary i pariverei da Iesu i lawana me ma tauna matanei Iesu i ʼnanai. Wate taui eḡa ita vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wei au murina Iesu inanana tapuna ma ana tauvotaḡotaḡo ruaḡa awari i eḡa; maranai taui i nenae au melagai. ");
INSERT INTO wed_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Taui i naeme ma tauvotaḡotaḡo ḡelaui i vieḡei. Wate taui nanare eḡa ita vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muriai taui 11 i amam ma Iesu awarii i eḡa. Ma i eni aubaina taui orai i bado ma eḡa ita vitumaḡana maranai rava, i riwei da Tauna i vomairi me. ");
INSERT INTO wed_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iesu ana Apasol i riwei, “Ona nae dobu au anatapuna. Ma God Riwana Aiaina ona jimei rava anatapui awarii. ");
INSERT INTO wed_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aiai da i vitumaḡana ma i babataito; tauna ina lawana. Ma aiai da eḡa ita vitumaḡana ina kovoḡi. ");
INSERT INTO wed_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma taui aiavoi da i vitumaḡana, rewapana ina verei da kaua babai ina kauei. Ma arua-apoapoei ina viopuni ma pona tapunei ina babani. ");
INSERT INTO wed_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Taui, mota uraiei ina vaia ma waiawa ina umai ma eḡa ina rauputei. Ma urai doridoriai au kolai ina terei ma ina lawana.” ");
INSERT INTO wed_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bada Iesu, awari i babani vorovei. Ma tauna i ḡaiei au mara ma God au oiena i kiala. ");
INSERT INTO wed_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tauvotaḡotaḡo i opu ma dobu au anatapuna i raraugugula. Ma Bada, taui i voagui ma kaua babai i kaukauei da tauvotaḡotaḡo aiwai i bababaniei i vovai-virewapani. ");
INSERT INTO wed_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Egualau Theophilus, buka au naona a girugirumia lamna Iesu ana tupua ma ana nola i vikarei da i kaukauei ma i viviararamana a pariverem ");
INSERT INTO wed_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","i nae da ana ḡae au marana. Muriai da Iesu i ḡaiei au mara, Tauna Arua Vivivireinei ana apasol vinevinei riwa bagibaginei i pariverei. ");
INSERT INTO wed_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iesu ana iraḡe au murina i vieḡana-melei ana apasol awarii. Ma kaua maḡamaḡaui i kauei da apasol i vitumaḡana kaua da Tauna anina i lawana me. Taui awarii i eḡa au pom 40 au orana ma God ana vigulau i babaniei. ");
INSERT INTO wed_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Maranai ana apasol maiteni i vitagogiei ma i riwana-guratei i pa, “Eḡa Jerusalem ona oputawanei, wate pulona amau i paripari-vainuaḡanimi ona paini, maraotai a ririwemi nanare. ");
INSERT INTO wed_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John wairei i babataito, wate mara aburuna ava Amau, Arua Vivivireinei taumi ina babataitomi.” ");
INSERT INTO wed_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Muriai maranai Iesu ma Apasol i vitagogiei ma taui Iesu i vitara-virevirei i pa, “Bada! Marina, Israel ana vigulau ma vere-melei bo?” ");
INSERT INTO wed_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma Iesu i paribelei, “Amau ainelana ana rewapanei mara ma iri e vivibadei, aubaina da taumi eḡa ona aramanei. ");
INSERT INTO wed_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wate maranaina Arua Vivivireina au orami ina rui, maranaina taumi rewapana ona vaia. Ma aubaiu ona vitaunola au Jerusalem, Judea, au Samaria ma dobu au anatapuna.” ");
INSERT INTO wed_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I babani vorovei ma au matai God Iesu i ḡaiei au mara. Ma apau i nei da i purui ma taui eḡa ita inana-melei. ");
INSERT INTO wed_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma taui i ḡoḡouta au mara ma nelara ruaḡa ai gara ararapoiri au ririvai i raumairiei. ");
INSERT INTO wed_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma i riwa, “Mai Galili, aiwai weka o maimairiei ma o ḡoḡoutatei? Wei ravana menanarena o inanai i ḡaenei, amapo nanare ina nememei.” ");
INSERT INTO wed_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Anina ma Apasol Ola Olive, i voterei ma i ḡaira me au Jerusalem lamna eḡa uama ma au ḡereḡere. ");
INSERT INTO wed_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ma au Jerusalem i ḡeta ma i ḡae numana i mamae lana au tepana au vatavatara. Taui ai wava, Peter, John, James ma Andrew, Philip ma Thomas, Batolomeo ma Matthew, James - Apius natuna, ma Simon tauna au naona Zealot ma Judas - James natuna. ");
INSERT INTO wed_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ma wei ravai mara patapatana i vivitagogiei ma i raraupari gogona, waivine ḡelaui ma Iesu ana roaroa ma aloi Mary maiteni kampa. ");
INSERT INTO wed_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Wei au marana, tauvitumaḡana 120 i vitagogiei ma Peter i vomairi ma wenanare awari i babani, ");
INSERT INTO wed_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Varevareiu, Judas Iskariot lamna turata tagogi ma maiteni ta nola gogona, wate muriai i voagu da Iesu i pani. Arua Vivivireina wei riwana wariaḡa gulau David i riwei da ina tupua; ma aiwai i ririwei anina nanare i tupua.” ");
INSERT INTO wed_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas Iesu i amverenei mane vainana aubaina, ma wei manenei doa i gimarai. Ma nai au doana tauna kolanei i peu ma manawana i wanawamai da amoamona i opu. ");
INSERT INTO wed_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma rava anatapui au Jerusalem wei iraḡena riwana i nonori, lamna aubaina taui nai dobuna ai ponei i viwavai Hakeldama, wei anona Tara Doana. ");
INSERT INTO wed_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Wariaḡa Gulau David i girugirumia, nanare i tupua, Ana animae ina kwakwava, ma eḡa aiai au orana ina mae. Ma ");
INSERT INTO wed_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Lamna aubaina marina awarita, rava ḡelauna tana vinei da ina raviepaiai. Tauna ravanana Iesu maiteni ta bababara-nae madeḡa tonuḡa au orana, ");
INSERT INTO wed_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","John rava i babataitoi au marana ma i nae da Iesu i ḡaiei au mara. Ma maiteni tana nola ma rava tana riwei menanarena God Iesu iraḡelei i vovaimairini.” ");
INSERT INTO wed_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ma taui rava ruaḡa i vinei, Joseph-Barsabas (ana wava ḡelauna Justus) ma Matthias. ");
INSERT INTO wed_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Anina ma taui i raupari, “Bada tam rava anatapui orai u aramanei. Ma vieḡelai da wei ravai ruaḡa, ma metauna u vinei da Judas ana gabu ina vaia da ina viApasol, aubaina Judas i voterelai da i nae ana au gabu.” ");
INSERT INTO wed_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Anina ma taui i vine, ma vinevine Matthias awarina i peu, ma tauna i vi-Apasol, ma Apasol 11 au orai i rui. ");
INSERT INTO wed_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecost torelana i ḡetai ma tauvitumaḡana anatapui numa tagogi au orana i vitagogiei. ");
INSERT INTO wed_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Maratagogi gugura ḡaeḡaena, nonorana me ive vivirewapanana marei i ḡairai ma tauvitumaḡana i mamae numana i vioai. ");
INSERT INTO wed_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Taui purapura inanana me ai menamenana i ʼnanai, i ḡairai ma rava tagotagogi ava au kolai i kiala. ");
INSERT INTO wed_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma Arua Vivivireina anatapui i vioai ma pona taputapunei ava i bababani Arua ana aguei. ");
INSERT INTO wed_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nai maranaina mai Jew patupatutui dobu au anatapuna i vitaomana au Jerusalem da Pentecost torelana ita apui. ");
INSERT INTO wed_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma patarai kampa i viruberubei, ma i nonori da gugurana lamna tauvitumaḡana taui tagotagigiava ai ponei i bababani ma taui ai nota i kwa. ");
INSERT INTO wed_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Taui anatapui i baei ma taui ava i babani vivira i pa, “Wei mai Galili bo? ");
INSERT INTO wed_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma menanarena da anataputa awarita ata ponei e bababani! ");
INSERT INTO wed_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Tauta ḡelauta mai Parthia, Mede ma Elam, ma mai Mesopotamia, Judea, Capadosia, Pontus ma Eisia, Pirijia, Pamphilia, Egypt ma Libya navanavana, au Sairini au ḡereḡerena, ma ḡelauta mai Rome, ");
INSERT INTO wed_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ḡelaui mai Jew ma ḡelaui Jentail wate inibori i vaia da i vimai Jew. Ma ḡelauta mai Crete ma mai Arabia. Wate God kaua ḡaeḡaena i kaukaueia, ata ponei i bababaniei ma ta nononori!” ");
INSERT INTO wed_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Taui anatapui i vinuanaina, nuanuai i raḡaraḡa ma i bababani vivira, “Wei aiwai kauana e tuputupua?” ");
INSERT INTO wed_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wate ḡelaui taui i vinamei i pa, “Wei ravai i uma bua!” ");
INSERT INTO wed_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Anina ma Peter i vomairi Apasol 11 maiteni, ma ponana ḡaeḡaenei patara awarii i babani, Au rava mai Jew ma anatapumi au Jerusalem maemaemi, babani ana tere-kauei da ona aramanei. Ona rautaniḡana kaua. ");
INSERT INTO wed_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wei marinaota, 9 kilok ubaubanai! Wei ravai eḡa ita uma bua me taumi o notanotai nanare, ");
INSERT INTO wed_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wei lamna wariaḡa peroveta Joel i ririweia e tuputupua: ");
INSERT INTO wed_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mara au damona, ");
INSERT INTO wed_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wate nanare, Aruau ana iwaḡi au taunola nelarai ma waivinei awarii, ");
INSERT INTO wed_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma kaua babai au mara ana kauei, ");
INSERT INTO wed_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma madeḡa ina waguvarei ");
INSERT INTO wed_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nai au marana aiavoi da Bada awarina e viviḡore agu aubaina Bada taui ina vilawani. ");
INSERT INTO wed_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ma Peter i babani me: Mai Israel ona rautaniḡana: God Iesu Nasaretei i vovai-virewapani da kaua babai, ma mataira ḡaeḡaei i kauei da ita viatataiemi da tauna anina Godei i nei. ");
INSERT INTO wed_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wate God wariaḡa i viogei ma ana ḡoana nanare da Iesu au urami i terei, ma taumi ḡoʼapoapoe ravai ai aguei, Tauna au korosi o tuparatui da o viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wate God, Iesu iraḡelei i vovaimairini, ma iraḡe iniviarana i vaitawanei ma iraḡe eḡa tagotagogina da tauna ita vojijini. ");
INSERT INTO wed_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wariaḡa David Iesu i bababaniei maranai i riwa: ");
INSERT INTO wed_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Lamna aubaina nuaiai orau i oai ma menau i morelana, ");
INSERT INTO wed_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ma aruau eḡa rava irairaḡei ai au dobu ma voterei, ");
INSERT INTO wed_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tam lawana etanaina u viatataieu, ");
INSERT INTO wed_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Au rava, A riwana-kauemi da amata gulau David iʼraḡe da i doboi, ma ana kokoaga weka e mamae. ");
INSERT INTO wed_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wate David lamna peroveta, ma i aramanei da God i parivainuaḡani da ana damei gulau ina opu, me tauna nanare. ");
INSERT INTO wed_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ma David i ʼnanai God muriai aiwai ina kauei ma i riwa, ");
INSERT INTO wed_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ma God Iesu-na tagogina iraḡelei i vovaimairini, ma tauai anatapuiai a vimatamata. ");
INSERT INTO wed_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ma God i ḡaiei ma au oiena i vikialai. Ma Arua vivivireina i verei me i parivainuaḡana nanare, ma nai Aruana tagogina Iesu awariai i waḡi, lamna marina o nononori ma o inainanai. ");
INSERT INTO wed_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David eḡa ita ḡae au mara, ma wate i riwa, Bada au Bada i riwei, “Au oieu ma kiala ");
INSERT INTO wed_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ma am ḡavia au ae karem ana terei. ");
INSERT INTO wed_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Lamna aubaina mai Israel anatapumi ona aramana-kauei da wei ravana Iesu o tupatuparatuia, God i terei da Bada ma Tauvilawana. ");
INSERT INTO wed_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma maranai rava wei riwana i nononori, taui orai i rautonai da Peter ma Apasol ḡelaui i riwei, “Varevareiai, tauai aiwai ana kauei da ana lawana?” ");
INSERT INTO wed_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ma Peter i paribelei, “Taumi tagotagogi ava Iesu Keriso wavanei ona rupena ma ona babataito ma ami ḡoʼapoapoei ina nota-tawanei, ma God ana pulo Arua Vivivireina ona vaia. ");
INSERT INTO wed_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wei parivai-nuaḡanana lamna taumi natunatumi maiteni aubaimi. Ma wate nanare mai jentail - aiavoi da e kwatukwatuei ina nei Tauna awarina.” ");
INSERT INTO wed_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma Peter riwa ḡelaui maiteni rava i vinua-terenei, ma i egari, “God ona vianinei da ina vilawanimi, ma eḡa kovoḡa ona vaia.” ");
INSERT INTO wed_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma rava maḡamaḡaui Peter ana babani i vitumaḡanei ma i babataito ma nai au marana rava 3,000 ai au boru i rui. ");
INSERT INTO wed_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma tauvitumaḡana Apasol ai viararamana i nononori, ma i viboruboru, i amam ma i raraupari gogona. ");
INSERT INTO wed_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apasol kaua babai ma mataira ḡaeḡae maḡamaḡaui i kaukauei ma anatapui i rovo ma God i vivirana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma tauvitumaḡana anatapui gabu tagogi i vivitagogiei ma aiwai ḡariei ai rava maiteni i ḡutaḡutai. ");
INSERT INTO wed_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Taui ai doa, ai numa, ai wapu ma ai purapura i gimagimarei ma manena ai rava ḡelaui maiteni i ḡutaḡutai. ");
INSERT INTO wed_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Taui mara patapatai au tempol i vivitagogiei, ma ai au numa ana nuaiaii ma ana morelanai i amam gogona. ");
INSERT INTO wed_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ma taui God i vovoepaepai ma rava anatapui i vivinuaiaini. Ma marana patapatai rava voui i neneiai Iesu awarina ma tauvitumaḡana ai boru i viviratai. ");
INSERT INTO wed_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mara tagogi au bigai 3 oklok, Peter ma John pari aubaina i ḡeḡae au Tempol. ");
INSERT INTO wed_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ma oroto tagogi aena gwaḡagwaḡana i tupuei, ma mara au anatapuna ana rava i avavara neiai da Tempol metaetana, e ḡoreḡorei, metaeta aiaina, kampa i vivikialai ma rava i ruirui tempol au orana i vivigigimanei mane aubaina. ");
INSERT INTO wed_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Maranai i ʼnanai da Peter ma John aburuna ava da au metaeta ita rui, ma i vibaḡai mane aubaina. ");
INSERT INTO wed_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter ma John orotona i ʼnana-tunutunui ma Peter i riwa, “Ma inanaiai!” ");
INSERT INTO wed_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ma orotona taui i ʼnanai ma i notanotai da aiwai awarii ita vaia. ");
INSERT INTO wed_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma Peter, orotona i riwei, “Awariu silva ma gold eḡa wate aiwai awariu lamna ana verem. Iesu Keriso Nasaretei, wavanei ma vomairi, ma babara!” ");
INSERT INTO wed_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ma Peter oroto nimana au oieina i vojijini ma i voagui da i vomairi. Ma maratagogi oroto aena ma ae kwarukwaruna i ai ma i virewapana, ");
INSERT INTO wed_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ma aenei i viauepa ma babara i vikarei. Anina ma taui maiteni i rui au tempol ma tauna tempol oraninei i bababara, i viviauepa ma God i vovoepaepai. ");
INSERT INTO wed_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ma rava anatapui orotona i ʼnanai i bababara ma God i vovoepaepai, ");
INSERT INTO wed_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ma i aramanei da tauna ravana tagogina tempol metaetana e ḡoreḡorei inanana aiaina au naona, i kiakiala ma i vivigigimana. Ma rava anatapui i ʼnanai aiwai i tupua wei orotona awarina ma i ba-guratana. ");
INSERT INTO wed_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ma orotona Peter ma John i vovojijini ma rava anatapui i bana-kauei, ma i viruberubei taui awari au lovelove e ḡoreḡorei, Solomon ana lovelove. ");
INSERT INTO wed_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ma maranai Peter patarai i ʼnanai ma i riwei: Au rava mai Israel, aiwai aubaina o vivinuanaina? Ma aiwai aubaina o inainana-tunutunuiai, apamina tauai ai rewapanei bo ai vipatutuei, wei ravana a kauei da i babara? ");
INSERT INTO wed_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Wei lamna amamata Abraham, Isaac ma Jacob ai God, ana taunola Iesu i viborumei, ma taumi Tauna o verenei da ita viraḡeni, ma Pilate au matana o geduaiei. Pilate i ḡoei da ita rupeni wate taumi eḡa ota vianinei. ");
INSERT INTO wed_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iesu lamna rava vivivireina ma jijimanina, wate o geduaiei. Ma Pilate i ḡoei da Iesu ita rupeni, wate taumi o ḡoei da tauviraḡena i rupeni aubaimi. ");
INSERT INTO wed_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ma taumi lawana maemae-nonoana tauvereina o viraḡeni, wate God i vilawana-melei, tauai wei a vimatematei. ");
INSERT INTO wed_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Wei ravana aena gwaḡagwaḡana Iesu au wavana i vitumaḡana ma lamna aubaina i lawana. Taumi o aramanei ana doria menanare, Wate ana tumaḡana Iesu awarina i vilawani. ");
INSERT INTO wed_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ma au rava marina a aramanei da taumi ami babada maiteni Iesu o viraḡeni, aubaina taumi eḡa ota aramanei da tauna tauvilawana. ");
INSERT INTO wed_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wate wei lamna wariaḡa God ana peroveta anatapui i ririweia i tupua, God i riwa da ana tauvilawana ina vinuapoapoe. ");
INSERT INTO wed_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ami ḡoa apoapoe Ona voterei ma ona mae-taviremi God awarina da tauna ami ḡoʼapoapoe ina nota-tawanei. ");
INSERT INTO wed_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ma lamna maranaina God aruami nualawalawana ina verei, God Iesu i vinei da ami Tauvilawana ma ina paritawaneiai. ");
INSERT INTO wed_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iesu au Mara ina mae da God kaua anatapui ina ravivouni, me God ana peroveta vivivirei wariaḡa i ririweia nanare. ");
INSERT INTO wed_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses i riwa, “Bada ami God peroveta, me tau nanare, ina terei ma tauna ami dam oinei ina nei. Ma aiwai anatapuna e ririwemi ona rautaniḡanana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ma aiai da wei perovetana eḡa ina rautaniḡanei lamna God ana rava awariei ina vilamonei.” ");
INSERT INTO wed_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Peroveta Samuel ma muriai Peroveta maḡamaḡaui, kaua i ririweia marina e tuputupua. ");
INSERT INTO wed_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Taumi nai perovetai natunatui ma taumi maiteni parivainuaḡana bagibagina au orana. Au baina God Abraham i riwei, “Am epaepaia awariei dam anatapui au dobu ana viaiaini.” ");
INSERT INTO wed_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ma maranai God ana taunola i vinei, ma au naona i paritawaneiai awarimi da ita viaiainimi, ma lamnei taumi tagotagogi ava ami ḡoʼapoapoe ota opu-tawanei ma ota nei Tauna awarina. ");
INSERT INTO wed_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter ma John rava awari i bababani ma pirisi pulo tauapuina ma tempol taupainii ai bada ma Sadusi ḡelaui i ḡetai. ");
INSERT INTO wed_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Taui amloi i ḡaiḡai kaua Peter ma John awari aubaina taui i viviararamana da God, Iesu iraḡelei i vovaimairini ma wei i viatataiana da God rava anatapui iraḡelei ina vovaimairini. ");
INSERT INTO wed_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Taui Peter ma John i pani ma au i pom aubaina panipani au numana i terei da i mae mara. ");
INSERT INTO wed_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wate rava maḡamaḡaui riwa i nonori ma i vitumaḡana, ma ai maḡa nelara 5,000 waivine eḡa ita iavi. ");
INSERT INTO wed_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ma mara i tom ma Jew babadai, dogadogara ma tarawatu babadai au Jerusalem i vitagogiei. ");
INSERT INTO wed_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ma pirisi ḡeḡetelarana Annas kampa ma Caiaphas, John, Alexander ma pirisi ḡeḡetelarana ana rava maiteni. ");
INSERT INTO wed_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ma taui Peter ma John i neiei da au naoi i vimairini ma i riwei, “Aiwai rewapananei, ma aiai wavanei wei o kauei?” ");
INSERT INTO wed_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Arua Vivivireina Peter orana i vioai ma taui i riwei, “Rava ai babada ma dogadogara; ");
INSERT INTO wed_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tauai kaua aiaina a kauei gwaḡagwaḡana awarina ma amadodo taumi o vitara-virevirelai, da menanare tauna i lawananei. ");
INSERT INTO wed_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ma wei ona aramana-kauei, da taumi ma mai Israel anatapui, da Iesu Keriso Nasaretei o tuparatui, Wate God tauna iraḡelei i vovaimairini ma tauna wavanei wei orotona au naomi lawalawaina e maimairi. ");
INSERT INTO wed_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Taumi tauvoa nai ḡaimana o geduaiei, wate wei gaimana lamna numa ogona, numa ana tapuna e vovojijini. ");
INSERT INTO wed_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","—Lamna aubaina Iesu ainelana ina vilawanita. Ma God eḡa aiai ḡelauna au dobu rewapana ita verei da ina vilawana.” ");
INSERT INTO wed_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ma taui Peter ma John ai tepatora inanai ma maranai i aramanei da taui eḡa girugirumai, ma i baei. Ma i aramanei da taui Iesu ana tauvotaḡotaḡo. ");
INSERT INTO wed_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma wate i ʼnanai oroto i vivilawania Peter ma John maiteni i maimairi, lamna maranai taui gamoi i pota. ");
INSERT INTO wed_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Anina ma Peter ma John i riwei da boru gabuna i opu-tawanei, ma taui ava i vitarairavira vivira. ");
INSERT INTO wed_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Taui i vitaraviravira-viravira i pa, “Aiwai tana kauei wei nelarai awari? Rava anatapui au Jerusalem i aramanei da taui kaua babai i kaukauei, lamna eḡa tana boviei. ");
INSERT INTO wed_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wate tana viḡaei da wei kauai eḡa ina tua rava ḡelaui awari, ma riwa bagibaginei tana viḡaei da eḡa aiai awarina Iesu wavanei ina raugugula.” ");
INSERT INTO wed_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Anina ma taui i ḡorei da i rui me, ma riwa bagibaginei i viḡaei da eḡa aiai awarina Iesu wavanei ina raugugula bo ina viararamana. ");
INSERT INTO wed_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wate Peter ma John taui i paribelei, “Taumi ami nota aiwai. Tauai God ana voteletelei bo taumi? ");
INSERT INTO wed_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tauai aiwai a inainanaia ma a nononoria babanina eḡa ana voterei.” ");
INSERT INTO wed_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Wei Orotona i vivilawani lamna gwaḡagwaḡana ma ana madeḡa 40. Lamna aubaina rava anatapui God i vovoepaepai, ma babada eḡa ita aramanei menanare Peter ma John ina kovoḡanei. Ma i parivairovorovo-melei ma i paritawanei da i nae. ");
INSERT INTO wed_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peter ma John i nae me ai rava awari ma pirisi ḡaeḡaei ma dogadogara aiwai i ririweia taui i vieḡei. ");
INSERT INTO wed_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Maranai tauvitumaḡana wei riwana i nonori, taui anatapui i raupari gogona God awarina: Bada tam ai gulau, Tam mara, dobu, boga ma anatapuna au orana maemaei taukaueina. ");
INSERT INTO wed_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tam Arua Vivivireinei am taunola, amaiai David gamonei u babani ma u riwa, ");
INSERT INTO wed_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ma dobu ai gulagulau i vokaukaua ma babada ḡaeḡaei ḡelaui maiteni i vitagogiei da ");
INSERT INTO wed_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Anina riwa kaua. Wei kauai weka au Jerusalem i tupua, Herod ma Pontius Pilate, Jentail ma mai Israel maiteni i vitagogiei, da am taunola vivivireina Iesu u bulobuloia i viḡaviei. ");
INSERT INTO wed_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ma tam am rewapanei ma am ḡoanei am oga menanare u tarataranei marina nanare i tupua. ");
INSERT INTO wed_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bada, nai ravai ai parivai-rovorovo au uram ma am taunola ma vovai-virewapani da ana tepatorai riwam ina raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uram ma viloloi da ma vilawana ma kaua babai ma mataira ḡaeḡaei ma kauei, am taunola Vivivireina Iesu wavanei. ");
INSERT INTO wed_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ma pari au murina, taui mepa i vivitagogiei gabuna i vigu. Ma Arua Vivivireina anatapui orai i vioai. Ma ana tepatorai God riwana i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tauvitumaḡana anatapui ai nota ma orai tagogi. Ma ai purapura tagogi ma eḡa aiwai ita nuanei. ");
INSERT INTO wed_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ma Apasol ana tepatorai ma rewapanai Bada Iesu ana iraḡe, ma ana vomairi me i raugugulei. Ma God ana viaiaina ḡaeḡaena taui anatapui awari i peu. ");
INSERT INTO wed_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ma taui au orai eḡa aiai aiwai ita voladaḡei aubaina, ai rava ḡelaui ai doa bo ai numa i gimagimarei ma manena i neneiai Apasol awari i tereterei, ma aiai da aiwai i vovoladaḡei nanare i vovoagui. ");
INSERT INTO wed_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Me Joseph, tauna Levi ana damei, au Saipras i tupua, ma Apasol tauna i ḡoreḡorei Barnabas, wei wavana anona lamna tauduḡu. ");
INSERT INTO wed_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tauna ana doa i gimarei, ma manena i neiai da Apasol awari i terei. ");
INSERT INTO wed_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anina ma Ananias awana Saphaira maiteni ai doa navanavana i gimarei. ");
INSERT INTO wed_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma airuaḡa i vianina tagogi da mane navanavana i nuanei, ma Ananias mane navanavana i naiei da Apasol awari i terei. ");
INSERT INTO wed_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Anina ma Peter tauna i vitaravirevirei, “Ananias aiwai aubaina Satan u vianinei da au oram i rui ma Arua Vivivireina u morui, ma doa u gimagimarei manena navanavana u nuanei? ");
INSERT INTO wed_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Doa lamna tam ḡarimei da uta gimarei bo eḡa. Ma maranai u gimarei lamna manena tam ḡarimei da uta verenei, aiwai aubaina nota apoapoena au oram i rui? Tam eḡa rava awarina uta moru, wate God awarina u moru.” ");
INSERT INTO wed_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Maranaina Ananias wei riwana i nononori, tauna i peu da iʼraḡe. Anina ma nelara i rui da tupuana i umai ma i naiei da i doboi. Ma aiavoi da wei riwana i nonori i rovo kaua. ");
INSERT INTO wed_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Taui eḡa ita mae guratana, ora tonuḡa nanare ma awana i nei, aiwai i tupua eḡa ita aramanei. ");
INSERT INTO wed_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma Peter wavine i paridadanei, “Abe uta riweu, tam awam Ananias maiteni doa o gimagimarei maiana anina wei bo?” Ma tauna i paribelei, “Ee, doa maiana anina nai.” ");
INSERT INTO wed_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ma Peter i riwa, “Aiwai aubaina taumi o vianina da Bada Aruana ota raudadani? Nelarai awam i dobodoboi ma inanai au metaeta da tam maiteni ina avara-opunem.” ");
INSERT INTO wed_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Maratagogi wavine Peter au ae karena i peu da iʼraḡe. Maranai nelara i rui au numa ma i ʼnanai da wavine iʼraḡe, anina ma i avara-opunei da awana au ririvana i doboi. ");
INSERT INTO wed_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lamna maranaina ekalesia anatapui, ma rava aiavoi da wei riwana i nonori i rovo kaua. ");
INSERT INTO wed_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ma Apasol mataira ma aniba kauai maḡamaḡaui i kaukauei rava awari. Ma tauvitumaḡana Solomon ana au lovelove i vivitagogiei. ");
INSERT INTO wed_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wate rava ḡelaui ai au boru ruina i rovoei, wate rava taui i vivirana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wate nelara ma waivine maḡamaḡaui Iesu awarina i vitumaḡana ma tauvitumaḡana ai au boru i ruirui. ");
INSERT INTO wed_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ma lamna aubaina rava ai rava doridoriai i avavara-opunei au eta ma ai au animatave i vimataveni, da Peter inii ita vodadani bo eḡa da ḡouna taui ita ḡouni da ita lawana. ");
INSERT INTO wed_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma melagai ḡelaui Jerusalem au ririvana ravai maḡamaḡaui ai rava doridoriai, ḡelaui arua-apoapoei i ruiruinia i neiai ma anatapui i vilawani. ");
INSERT INTO wed_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Anina ma pirisi ḡeḡetelarana ma ana rava mai Sadusi anatapui orai unura i oai. ");
INSERT INTO wed_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ma Apasol i pani, ma panipani au numana i terei. ");
INSERT INTO wed_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wate waguvarai Bada ana anela i nei da panipani numana metaetana i votawanei, ma taui i taravaina-opunei ma i riwei, ");
INSERT INTO wed_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ona rui tempol au orana, ona mairi ma lawana vouna riwana anatapuna rava ona pariverei.” ");
INSERT INTO wed_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Anela i ririwei nanare, taui au tempol i rui ma rava viararamanai i vikarei. Nai maranai pirisi ḡeḡetelarana ana rava maiteni i ḡetai ma boru ḡaeḡaena e ḡoreḡorei Sanhedrin i terei. Ma rava i paritawanei au panipani numana da Apasol ita neiai awari. ");
INSERT INTO wed_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Taui panipani au numana i ḡeta ma i baina-avei, ma i naeme da i vieḡa. ");
INSERT INTO wed_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","I pa, “Panipani numana anina i gudu-kauei, ma tauvipaipai au metaeta i maimairi; wate maranai tauai metaeta a votawanei lamna eḡa aiai kampa.” ");
INSERT INTO wed_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Maranai tempol taupainina ai bada ma pirisi babadai wei riwana i nonori, taui i vinuanaina da aiwai i tupua. ");
INSERT INTO wed_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ma rava tagogi i nei ma i riwa, “Ona rautaniḡana! Nelara panipani au numana o teretereia, taui au tempol e maimairi ma rava e viviararamani.” ");
INSERT INTO wed_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Anina ma tempol taupainina ai bada, ma babada ḡelaui maiteni i nae ma Apasol i neiai. Taui i rovo ma eḡa ita egari mepa da rava ḡaimei ita ravi. ");
INSERT INTO wed_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ma Apasol i neiai boru ḡeḡetelarana au naoi, ma pirisi ḡeḡetelarana taui i vitara-virevirei. ");
INSERT INTO wed_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","I pa, “A riwana-guratemi da wei ravana au wavana avena ota viararamana, wate ami viararamana i tua da Jerusalem i oai. Ma wei ravana tarana wavuna tauai o vereverelai.” ");
INSERT INTO wed_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ma Peter Apasol ḡelaui aubai i vitauvibabani i pa, “Tauai God ana voteletelei ma eḡa rava. ");
INSERT INTO wed_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Taumi Iesu au korosi o tuparatui ma o viraḡeni, wate amamata ai God Tauna i vovaimairini. ");
INSERT INTO wed_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ma marina Tauna God au oiena e kiakiala, Tauna Bada ma Tauvilawana, Da mai Israel ai ḡoʼapoapoe ina rupeni, ma ai ḡoʼapoapoe ina nota-tawanei. ");
INSERT INTO wed_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ma tauai Arua Vivivireina maiteni wei kauai anatapui mataielai a inanai. Ma nanare God Arua Vivivireina i paritawanei rava votelatelai awari.” ");
INSERT INTO wed_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Taui wei babanina i nonori ma amloi i ḡaiḡai kaua, ma i ḡoei da Apasol ita viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wate Pharisi ma tarawatu badana wavana Gamaliel, rava anatapui wei ravana e vivivirei. Tauna Sanhedrin boruna au orana i mairi, ma rava i riwei da Apasol i opunei au doa mara aburuna ava. ");
INSERT INTO wed_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Anina ma ana rava i riwei, “Mai Israel, ona inana kaua ma muriai da aiwai wei ravai awari ona kauei. ");
INSERT INTO wed_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mara tagogi oroto wavana Theudas viḡavia i vikarei ma i kauana-melei da tauna rava ḡaeḡaena, ma rava ai maḡa 400 nanare tauna i votaḡotaḡoi. Ma maranaina tauna i viraḡeni ana tauvotaḡotaḡo i vilamonei ma aiwai anatapuna kampa i kwa. ");
INSERT INTO wed_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wate tauna au murina oroto Galiliei wavana Judas i ḡeta, census au marana ma rava maḡamaḡaui tauna i votaḡotaḡoi, ma tauna maiteni i viraḡeni, ma ana tauvotaḡotaḡo i vilamonei. ");
INSERT INTO wed_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lamna aubaina a ririwemi da wei ravai ona voteretawanei! Mepa da taui ai nola ravei, amapo ina peu. ");
INSERT INTO wed_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wate mepa da Godei, taumi eḡa tagotagogina da wei ravai ona viḡaei, taumi mepa da God o viviḡaviei.” ");
INSERT INTO wed_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Taui Gamaliel ana babani i voteletelei. Ma Apasol i riwei da i rui, ma i wipiei i kwapui ma i viḡaei da Iesu wavanei ina jima, ma i paritawanei da i nae. ");
INSERT INTO wed_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aubaina i aramanei da God taui i vinei da Iesu wavana aubaina ina vinuapoapoe. Anina ma Apasol ana nuaiaii Sanhedrin i opu-tawanei, ");
INSERT INTO wed_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Taui mara patapatana tempol au orana ma au numa God riwana aiaina i raraugugulei ma i viviararamana da Iesu tauna Keriso. ");
INSERT INTO wed_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tauvitumaḡana ai boru i rarata, ma au orai mai Jew Greek taubabanieina, mai Jew kampa maemaei i viamparipariei. Taui i beubeura da ai kaikaiababa ai ḡuta eḡa ita tereterei. ");
INSERT INTO wed_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Anina ma Apasol 12 tauvitumaḡana ai boru i raukwatuei. Ma i riwei, “Tauai Apasol ma ai nola lamna God riwana ata jimejimei ma avena mane nolana maiteni ata kaukauei. ");
INSERT INTO wed_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Lamna aubaina au rava, awarimi rava 7 ona vinei, taui orai Arua Vivivireina i oai ma nuaulaulai da wei nolana ina kauei, ");
INSERT INTO wed_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma tauai ai nola da pari ma God riwana ava ana jimei.” ");
INSERT INTO wed_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Rava anatapui wei ogatarana i vianinei, ma Stephen i vinei, Arua Vivivireina orana i oai, ma ana tumaḡana God awarina i rata kaua. Ma nanare Philip, Prokoras, Nikano, Timon, Pamenas ma Nicolas tauna Jentail, Antiokei ma ini bori i vaia ma i vikeresiana. ");
INSERT INTO wed_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ma wei ravai i neiai ma Apasol nimai taui au tepai i terei ma i raupariei. ");
INSERT INTO wed_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Anina ma God riwana i vituai ma au Jerusalem rava maḡamaḡaui Iesu i vitumaḡanei, ma nanare pirisi maḡamaḡaui i vitumaḡana. ");
INSERT INTO wed_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Anina ma God Stephen i viaiaini ma i vovai-virewapani da mataira ma kaua babai i kaukauei rava awari. ");
INSERT INTO wed_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wate mai Jew ḡelaui provins nununai i nei mai au Sairini, mai Alexandria, ma Silisia ma Eisia ai parinumana e ḡoreḡorei panipani waduboi, Stephen ana ḡavia i vomairi. ");
INSERT INTO wed_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wate Arua Vivivireina, Stephen nuaulaula ma riwa i verei ma i bababani da taui i vigamopotai. ");
INSERT INTO wed_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lamna aubaina taui rava ḡelaui i gwalai da moruei Stephen ita vibenabenamei, ma ita riwa, “Tauai a nonori Stephen, Moses ma God i vivijiboḡi.” ");
INSERT INTO wed_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ma lamnei patara i viamlo-ḡaiḡaini, dogadogara ma tarawatu babadai maiteni. Anina ma taui Stephen i vojijini ma i naiei mai Jew ai Boru Ḡeḡetelarana awarina. ");
INSERT INTO wed_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ma taui rava ḡelaui i neiai da moruei Stephen i vibenabenamei, ma i riwa, “Wei ravana mara patapatana Tempol vivivireina ma Moses ana tarawatu i vivijiboḡi. ");
INSERT INTO wed_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tauai a nonori i riwa da Iesu Nasaretei tempol ina rikai ma tarawatu Moses i verevereta anatapui maiteni ina virai.” ");
INSERT INTO wed_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma rava anatapui nai au boruna i kiakiala, Stephen i ʼnana-tunutunui, ma i ʼnanai da tauna naona i lalalai me anela. ");
INSERT INTO wed_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Anina ma Pirisi ḡeḡetelarana Stephen i paridadanei, “Wei viwavuna, riwa kaua bo?” ");
INSERT INTO wed_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen i paribelei: Varevareiu ma amamau, au babani ona rautaniḡanei. God boruborumana noita Abraham awarina i eḡa au Mesopotamia, muriai da ita nae au Haran. ");
INSERT INTO wed_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ma God tauna i riwei, Am dobu ma am dam ma netawanei da ma nae dobu ana viatataiem lana. ");
INSERT INTO wed_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Anina ma Abraham Mesopotamia i netawanei ma i nae da au Haran i mae. Amana iʼraḡe ma au murina God Abraham i paritawanei da marina dobuna o mamae lana kampa ita mae, ");
INSERT INTO wed_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nai maranaina God eḡa Abraham doa ita verei, eḡa aburu dadadana! Wate i parivainuaḡani, da ina verei tauna ma ana epaepaia aubaii. Nai au marana Abraham eḡa natunatuna, ");
INSERT INTO wed_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ma God wenanare Abraham i riwei, Am epaepaia au dobu ḡela ina mae ma ina vitaunola, nai dobuna ravai taui ina rau-iviapoapoelei da madeḡa 400 ina kwa. ");
INSERT INTO wed_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wate ravai, awarii e vivitaunola ana kovoḡi, ma muriai mai Israel ina opui ma wei au dobuna ina voepaepaiu. ");
INSERT INTO wed_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Anina ma God inibori parivai-nuaḡanana bagibagina Abraham maiteni i kauei, ma maranai Isaac i tupua ma au pom vi-8-na Abraham natuna inina i bori. Muriai Isaac natuna Jacob inina i bori, ma nanare Jacob natunatuna 12 anatapui inii i bori. Wei babadai lamna tauta noinoita. ");
INSERT INTO wed_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jacob natunatuna varei Joseph i unurei ma i gimarei da ita vitaunola au Egypt, wate God tauna awarina i mae. ");
INSERT INTO wed_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ma ana au nuabola i gagaloei. Ma God nuaulaula i verei ma i kauei da Egypt ai gulau nuanuana i vaia, anina ma i terei da Egypt i vibadei ma ana numa orana i vibadei. ");
INSERT INTO wed_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ma gomara ḡaeḡaena i ḡeta au Egypt ma au Canaan, ma vinuapoapoe ḡaeḡaena i tupua. Ma noinoita eḡa ai lam. ");
INSERT INTO wed_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ma maranai Jacob i nonori da au Egypt lam, ma noinoita i paritawanei au Egypt, wei ai babara naona. ");
INSERT INTO wed_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma muriai i nae me ma wei maranai Joseph i vieḡana-melei varevareina awarii, ma kampa mai Egypt ai gulau Pharaoh, Joseph ana numa ravai i aramanei. ");
INSERT INTO wed_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Anina ma Joseph riwa i paritawanei amana Jacob awarina ma i riwei da ana numa ravai anatapui, ai maḡa 75, ita nei au Egypt. ");
INSERT INTO wed_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Anina ma Jacob i nae au Egypt. Tauna kampa iʼraḡe ma nanare natunatuna anatapui. ");
INSERT INTO wed_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Taubeui i naiana-melei au Shekem ma Abraham Hamor natunatuna awarii kokoaga i gimagimaraia, kampa i vimataveni. ");
INSERT INTO wed_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Maranai mara i tuḡereḡerei da God Abraham i paripari-vainuaḡania ita kauei, ata patara i maḡa guratana au Egypt. ");
INSERT INTO wed_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ma Pharaoh vouna au Egypt i vibada ma tauna noita Joseph eḡa ita aramanei. ");
INSERT INTO wed_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tauna amamata i morui ma i rau-iviapoapoelei, i egari da natunatui melamelai numei i viopuni da ita iraḡe. ");
INSERT INTO wed_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wei au marana Moses i tupua, tevera inanana aiaina. Amana ma alona natui i ḡamoi da nawaravi tonuḡa i kwa. ");
INSERT INTO wed_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma maranai tevera numei i tere-opunei, gulau natuna guguinina tevera i vaia ma i ḡamoi da natuna. ");
INSERT INTO wed_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ma mai Egypt ai nuaulaula Moses i viararamani ma i virewapana, babani ma nola awarina. ");
INSERT INTO wed_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses ana madeḡa 40 ma i nota da ita nae ana dam ravai ita raugenari. ");
INSERT INTO wed_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ma i ʼnanai da Egyptei, Moses ana rava oina i raviravi, ma tauna turana bainei Egyptei i vunui da i viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses i notai da ana rava ita aramanei da God tauna i paritawanei da ita agui da Egypt ita oputawanei. Wate taui wei eḡa ita aramanei. ");
INSERT INTO wed_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ma maratomna Moses i nae me ma ana rava ruaḡa i viḡaiḡaiawa i ʼnanai, ma i riwei, “Taumi ava ma aiwai aubaina o viḡaiḡaiawa?” ");
INSERT INTO wed_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wate ḡaiawa tauvikareina Moses i vokaririei ma i riwei, “Tam aiai i terem da ma vibadelai bo tauai ai taurauetara? ");
INSERT INTO wed_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tam ma viraḡeniu me pom Egyptei u viraḡeni nanare bo?” ");
INSERT INTO wed_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Maranai Moses wei i nonori tauna Egypt i ruba-tawanei ma i nae au Midian, wei eḡa ana dobu wate kampa i mae. Muriai dobuna wavinena i ravaḡi ma natunatuna nelarai ruaḡa i tupua. ");
INSERT INTO wed_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ma kampa i mae madeḡa 40 i kwa ma Bada ana anela au mutulua ola Sinai au ḡereḡerena tauna awarina i eḡa, inanana me ai menamenana ai aburuna rugurugui au orana i ḡeḡae. ");
INSERT INTO wed_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Wei i ʼnanai ma i baei ma i nae au ḡereḡere da ai arata ita tuvirevirei ma i nonori Bada i riwa i pa, ");
INSERT INTO wed_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Tau amamam ai God, Abraham ma Isaac ma Jacob ai God.” Maranai Moses wei i nononori i rovo kaukaua ma naona i tere-govaḡi. ");
INSERT INTO wed_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ma Bada i riwa, “Am ae uma ma votawanei! Wei gabuna au tepana e maimairi, lamna doa vivivireina ma Viaiainana. ");
INSERT INTO wed_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A inanai menanare mai Egypt, natunatu e rarau-iviapoapoelei. Ai ora-tou a nonori ma a ḡairai da taui ata vai-tawanei. Ma marina ma nei, Tau ana paritawanem au Egypt.” ");
INSERT INTO wed_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stephen i riwa: Wei Moses na tagogina, mai Israel i parivirevirei i pa, “Aiai i terem da tauai ma vibadelai ma ma rauetarelai?” Moses i paritawaneiai da ita vibademi ma ita tereopunemi, anela i eḡaeḡa ai menamenana au poui, ana aguei. ");
INSERT INTO wed_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ma Moses taui Egyptei i ravena-opunenei ma mataira babai ma vivirewapanai i kaukauei au Egypt, Boga lebalebarina ma ai au vaḡai madeḡa 40 au mutulua. ");
INSERT INTO wed_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wei Moses-na tagogina, mai Israel i riwei, “God muriai peroveta ami damei ina paritawaneiai me tau.” ");
INSERT INTO wed_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses Israel patarana maiteni Egypt i opu-tawanei i vitagogiei au ola Sinai ma anela Moses awarina i bababani, tauna kampa noinoita maiteni. Ma riwa mamae-nonoana i nonori ma wei lamna i veredamanei tauta awarita. ");
INSERT INTO wed_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wate noinoita Moses i parivirevirei ma au orai i ḡoei da ita nae me au Egypt. ");
INSERT INTO wed_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ma taui Aaron i riwei, “Nai ravana Moses, Egyptei i taravai-opunelai, tauai eḡa ata aramanei aiwai awarina i tupua. Ma tauai ai god kokoitau ma kauei da ina rauetaraveniai.” ");
INSERT INTO wed_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Anina ma bulumakau ḡaubona kokoitauna i kauei, ma pulo i apui awarina ma i amei ma i umei, da aiwai uraiei i kaukauei i vimae-ḡaeḡaeni. ");
INSERT INTO wed_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wate God taui i mae-puputei ma i voterei da ubona ma nawaravi ma madeḡa au mara i vimae-ḡaeḡaeni. Wei lamna peroveta nununai i ririweia i tupua: ");
INSERT INTO wed_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Taumi ami god Molek ana numa gara ma ami ubona god kokoitauna Rephan o avarai. ");
INSERT INTO wed_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Noinoita, God ana numagara, i avarai maranai au mutulua i mamae. Moses wei i voai, me God i viatataiei nanare. ");
INSERT INTO wed_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Muriai Joshua noinoita i rau-etaraveni ma God ana numagara i avarai ma ana aguei i rui ma nai dobuna ravai i viopuni ma ai dobu ta vaia. Ma numagara kampa i mae da gulau David ana au mara. ");
INSERT INTO wed_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","God, David nuanuana i vai-kauei ma David i vibaḡa da tauna God ana numa ita voai. ");
INSERT INTO wed_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wate David eḡa numa ita voai ma natuna Solomon numa i voai. ");
INSERT INTO wed_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Wate God ḡeḡetelerana eḡa rava uranei numa ita voavoai au orana ita mamae, me peroveta wariaḡa i riwa i pa: ");
INSERT INTO wed_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","Aubaina Tau aiwai anatapuna au mara ma au dobu a kauei. Tapa? ");
INSERT INTO wed_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ma Stephen i riwa: Taumi orami badobadoi. Ma eḡa ota ḡoeḡoei da God ona voteletelei ma taniḡami o vopotai da ana riwa eḡa ota nononori. Taumi Arua Vivivireina o viviḡaviei me noinoimi i kaukauei nanare. ");
INSERT INTO wed_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Noinoimi metaui perovetai eḡa ita rau-iviapoapoelei. Wariaḡa perovetai, God ana tauvilawana, ana nei i vinolenolei; Wate noinoimi wei perovetai maiteni i viraḡeni. Ma marina Tauna i nei ma o vibenabenamei ma o viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","God ana anela i paritawaneiai da ana tarawatu noinoita i verei, wate taumi tarawatuna eḡa ota voteletelei. ");
INSERT INTO wed_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Maranai babada wei riwana i nonori ma i meji guratana ma ivoi i uta-ḡiriḡiriei Stephen awarina. ");
INSERT INTO wed_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wate Arua Vivivireina Stephen orana i oai, i taepai au mara ma God ana boruma i ʼnanai, ma Iesu God au oiena i maimairi. ");
INSERT INTO wed_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma i riwa, “Ona inana! Mara metaetana i wanatawanei ma Rava Natuna a inainanai God au oiena e maimairi.” ");
INSERT INTO wed_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Marina taui anatapui taniḡai i vopotai, i vigaragarei ma Stephen aubaina i ruba, ");
INSERT INTO wed_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ma i taina-opunei au doa, taon i opu-tawanei da au ririva ma ḡaimei ravina i vikarei. Ma tauviwavu ai kwama i votawanei ma tevera laragana wavana Saul au aena i vidamni. ");
INSERT INTO wed_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Taui i viraurauei ma tauna i raupari i pa, “Bada Iesu, aruau ma vaia! ");
INSERT INTO wed_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma ae-tutunei i peu ma i garara, “Bada ai ḡoʼapoapoe ma nota-tawanei.” Wenanare i riwa ma iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ma Saul kampa da Stephen ana iraḡe i ʼnanai ma i vianinei. Rava patupatutui ḡelaui ana toutoui ma ana tarakwatui i nei ma Stephen taubeuna i naiei ma au kokoaga i terei. Nai maranaina rau-iviapoapoe ḡaeḡaena i vikarei ekalesia awarii au Jerusalem, Ma anatapui i viruba-tomana au Judea provins ma Samaria provins. Apasol ava au Jerusalem i mae. ");
INSERT INTO wed_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wate Saul i vikarei da ekalesia ai boru ita viamoai. Numa anatapui i ruini ma nelara ma waivine i taina-opunei ma i paritawanei au panipani-numana. ");
INSERT INTO wed_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wate tauvitumaḡana Jerusalem i rubaruba-tawanei taon ma dobu anatapuna i naeni ma Riwana Aiaina i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ma Philip i nae au taon tagogi au Samaria ma kampa Bada ana Vinevine Keriso i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Maranai patarana, Philip i raraugugula i nonori, ma i ʼnanai kaua babai ma mataira ḡaeḡae i kaukauei taui anatapui orai taputapunei i rautaniḡana. ");
INSERT INTO wed_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tauna arua-apoapoei rava maḡamaḡaui au orai i egari da ana garagararai i viopuopuana, ma nanare rava maḡamaḡaui gwaḡagwaḡai ma sigesigei i vilawani. ");
INSERT INTO wed_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ma nuaiai ḡaeḡaena i mae nai au taona. ");
INSERT INTO wed_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wenanare, nai au taona oroto tagogi i mae wavana Simon, ma tauna wariaḡa ava ana baravu i kaukauei ma mai Samaria i baibaiei. Ma i voepaepana-melei da tauna rava ḡaeḡaena. ");
INSERT INTO wed_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Rava labalababa, ma wavai naenaei anatapui ana babani i rarautaniḡana-kauei ma i ririwa, “Tauna, God ana rewapana e ḡoreḡorei, Rewapana Ḡaeḡaena.” ");
INSERT INTO wed_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Taui i vineneḡanana-kauei aubaina mara nonoa taui Simon ana baravu i baebaei. ");
INSERT INTO wed_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wate taui Philip i vitumaḡanei maranai, God ana vigulau Riwana Aiaina ma Iesu Keriso rava awari i raugugulei. Ma lamna aubaina nelara da waivine i nei da i babataito. ");
INSERT INTO wed_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon maiteni i vitumaḡana ma i babataito. Ma Philip mepa i nenae tauna kampa aubaina kaua babai ma mataira vivirewapanai i kaukauei. Tauna wei pulona i bana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Maranai Apasol au Jerusalem i nonori da mai Samaria, God Riwana i vitumaḡanei, taui Peter ma John i paritawanei awari. ");
INSERT INTO wed_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Ma auSamaria i ḡeta ma taui i raupariei da Arua Vivivireina ita rui au orai. Aubaina taui Iesu wavanei ava i babataito. Ma arua vivivireina eḡa ita rui. ");
INSERT INTO wed_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peter ma John urai taui au tepai i terei ma i raupari da Arua Vivivireina au orai i rui. ");
INSERT INTO wed_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Maranai Simon i ʼnanai da mai Samaria Arua Vivivireina i vaia, maranai Apasol urai au kolai i terei, ma Simon mane i vilololoi, ");
INSERT INTO wed_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ma i vibaḡa i pa, “Tau maiteni nai rewapanana ma vereu da rava au kolai urau ana terei ma taui Arua Vivivireina ina vaia.” ");
INSERT INTO wed_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wate Peter i paribelei i pa, “Anina da God tam am mane maiteni ina tawanem ai au menamenana, aubaina tam e notanotai da God ana pulo manelei ma gimarai! ");
INSERT INTO wed_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tam wei nolana au orana am gabu eḡa ita mamae, aubaina oram eḡa ita ai God au matana. ");
INSERT INTO wed_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Am nota apoapoe ma votere-tawanei. Ma mae-tavirem Bada awarina ma ma vibaḡai da am nota apoapoe ina nota-tawanei. ");
INSERT INTO wed_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aubaina a inanaim da unura oram i oai tauai awariai ma wei notai apoapoei e panipanim.” ");
INSERT INTO wed_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon marina Peter ma John i riwei, “Aubaiu Bada awarina ona raupari da aiwai o ririwei eḡa ina tupua awariu!” ");
INSERT INTO wed_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ma Peter ma John ai lawana ma Bada Riwana Aiaina ekalesia voui awari i raugugulei. Ma i raugugula nae Mai Samaria ai au taon nununai da i ḡeta au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mara tagogi Bada ana anela, Philip i riwei, “Ma vokaukaua ma ma nae au rauanaḡei, etanai au Jerusalem da e ḡaiḡaira au Gaza.” (Wei etanaina lamna au mutulua). ");
INSERT INTO wed_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Anina ma Philip i vokaukaua ma i nae. Ma wei au etanaina oroto Ethiopiei i ʼnanai. Tauna mai Ethiopia ai kwin Kandake, ana mane taupainina. Wei orotona i nae au Jerusalem God viborumana aubaina, ");
INSERT INTO wed_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ma i nenae-me ana au dobu. Ma ana au chariot i kiala ma wariaḡa peroveta Isaiah buka i girugirumia i ʼaiavi. ");
INSERT INTO wed_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma Arua Vivivireina Philip i riwei, “Ma nae ma chariot au ririvana ma babara-nae.” ");
INSERT INTO wed_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Anina ma Philip i ruba chariot au ririvana ma i nonori badana peroveta Isaiah ana buka i ʼaiavi. Ma Philip i paridadana, “Aiwai e iaiavia e araramanei bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Orotona i paribelei, “Menanare ana ʼramananei mepa da rava eḡa ita parivai-araramaniu!” Ma Philip i vibaḡai da i ḡeta da au ririvana i kiala. ");
INSERT INTO wed_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Buka au orana, wei riwana i ʼaiavi, ");
INSERT INTO wed_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tauna i vijiboḡi ma i vinimalamalai ma eḡa ita kauana-kauei awarina. ");
INSERT INTO wed_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ma orotona, Philip i paridadanei, “Isaiah e babaniana-melei bo rava ḡelauna e babaniei?” ");
INSERT INTO wed_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ma Philip, wei riwana awarina i vikarei ma riwa ḡelaui maiteni ma Iesu Riwana Aiaina i viararamani. ");
INSERT INTO wed_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ma i nenae da waira i ʼnanai ma Ethiopiei i riwa, “Ma inana waira noi, aiwai aubaina da eḡa ana babataito?” ");
INSERT INTO wed_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Badana, chariot taurubeina i riwei, “Chariot ma vojijini” Ma tauna ma Philip i ḡaira waira au orana ma Philip, badana i babataitoi. ");
INSERT INTO wed_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Maranai wairei i ḡeta, Bada Aruana maratagogi Philip i vai-tawanei ma turana eḡa ita inana-melei, ma ana morelanana i nae ana au dobu. ");
INSERT INTO wed_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wate Philip au Asotus i raueḡa ma dobuna i naeni ma Riwana Aiaina i raugugulei da au Caesarea taon i ḡeta. ");
INSERT INTO wed_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wate Saul amapo da i mejimeji ma i ḡoeḡoei da Bada ana tauvitumaḡana ita viraḡeni. Ma i nae Pirisi Ḡetelarana awarina, ");
INSERT INTO wed_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma i vibaḡai da pepa ita girumi boru-numai babadai awarii au Damaskas da rewapana ita verei da Iesu ana etanai tauvitumaḡanai, nelara ma waivine ita pani ma ita neiai au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ma Saul, Damaskas i tuḡereḡerei, nanare ma lalalaina marei i ḡairai da tauna i ravilalai. ");
INSERT INTO wed_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tauna i peu au doa ma pona i nonori awarina i babani i pa, “Saul, Saul! Aiwai aubaina e rarau-iviapoapoeleu?” ");
INSERT INTO wed_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul i paridadana, “Tam aiai bada?” Ma pona i paribelei, “Tau Iesu, tauna e rarau-iviapoapoelei! ");
INSERT INTO wed_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Marina ma vomairi ma ma rui au Damaskas, ma kampa aiwai ina riwem ma kauei.” ");
INSERT INTO wed_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nelara Saul maiteni i nenae i mairi kwakwa, ana gamopotai, taui pona i nonori wate eḡa aiai ita inanai. ");
INSERT INTO wed_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ma Saul au doa i matamatave i vomairi ma matana i kala, wate eḡa aiwai ita inanai. Ma ana rava i raunimavoai ma i taravaina-naiei au Damaskas. ");
INSERT INTO wed_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ma au pom tonuḡa eḡa ita inana, eḡa ita am bo ita uma. ");
INSERT INTO wed_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Au Damaskas tauvitumaḡana i mae wavana Ananias. Bada ana au inana i viatataiei i pa, “Ananias!” Ma i paribelei, “Bada, tau weka!” ");
INSERT INTO wed_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bada tauna i riwei, “Etanai wavana Etanai Jijimanina ma vaia da Judas ana au numa, kampa oroto Tarsusei wavana Saul ma baiei. Tauna marina e raraupari awariu. ");
INSERT INTO wed_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ma ana au inana i ʼnanai oroto wavana Ananias i nei awarina ma urana au inina i terei da ita inana-me.” ");
INSERT INTO wed_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Wate Ananias i paribelei, “Bada, rava maḡamaḡaui i riweu da wei ravana ana kaua i apoapoe kaua tauvitumaḡana awarii au Jerusalem! ");
INSERT INTO wed_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma weka i nei pirisi ḡaeḡaei ai rewapanei da aiai wavam e viviborumei ina pani.” ");
INSERT INTO wed_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wate Bada, Ananias i riwei, “Ma nae! Tau a vinei da aubaiu ina vitaunola ma wavau ina jimei, Jentail ma ai gulagulau awarii ma nanare mai Israel awarii. ");
INSERT INTO wed_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tau ana viatataiei da aubaiu ina jima ma rau-iviapoapoe ḡaeḡaena ina nei awarina.” ");
INSERT INTO wed_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anina ma Ananias i ḡeta au numa ma i rui. Ma urana Saul au tepana i terei ma i riwei, “Vareiu Saul, Bada Iesu, Tauna au etanai awarim i eḡa maranai weka u nenei, i paritawaneu awarim da ma inana me ma Arua Vivivireina oram ina vioai.” ");
INSERT INTO wed_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Maratagogi purapura inanana me iana wenavina au matana i peu, ma tauna, inana me. Ma i vomairi ma i babataito. ");
INSERT INTO wed_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma i am ma ana rewapana i vai-melei. ");
INSERT INTO wed_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma tauna maratagogi i nae ma pari au numai i raraugugula da Iesu anina God natuna. ");
INSERT INTO wed_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Taui aiavoi da Saul i nonori i ba kaua ma taui ava i babani vivira i pa, “Wei ravana tagogina, rau-iviapoapoe ḡaeḡaena Iesu ana tauvitumaḡanai awarii i kaukauei au Jerusalem bo? Tauna i nei weka nolana tagogina aubaina da tauvitumaḡana ita pani ma ita naiei Pirisi babadai awarii bo.” ");
INSERT INTO wed_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wate Saul ana raugugula i virewapana kaua ma lamnei mai Jew au Damaskas i aramanei da Iesu anina Keriso, Vinevinena, ma lamna aubaina ana babani eḡa ita parivirevirei. ");
INSERT INTO wed_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma au pom biaḡa au murina Jew babadai i viogatara da Saul ita viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mai Jew marai ma waguvarai taon garina au metaetana i vipaipai da Saul ita viraḡeni. Wate Saul ai ogatara riwana i nonori. ");
INSERT INTO wed_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma waguvarai tauvitumaḡanai ḡelaui ai bada Saul i taravaini ma iriga ḡaeḡaena au orana i poai ma gavogavo aburuna taon au garina, kampa ḡuravei i tere-ḡairei au doa ma i ruba. ");
INSERT INTO wed_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul i ḡeta au Jerusalem ma maranai i ḡoei da tauvitumaḡanai ai au boru ita rui. Wate taui i rovoei ma eḡa ita vitumaḡanei da tauna Iesu ana tauvotaḡotaḡo. ");
INSERT INTO wed_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Wate Barnabas tauna i taravaini ma i naiei Apasol awarii, ma i riwei menanare au etanai Saul, Bada i ʼnanai ma aiwai awarina i babaniei. Ma menanare au Damaskas ana tepatorana i raugugula Iesu wavanei. ");
INSERT INTO wed_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Anina ma taui Saul i taravaini ma maiteni i mae ma Jerusalem i naeni ma ana tepatorai i raugugula Bada wavanei. ");
INSERT INTO wed_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma nanare Saul mai Jew pona Greek taubabanieina maiteni i babani ma i viparipariḡai, ma taui i viogatara da tauna ita viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Maranai tauvitumaḡana ḡelaui wei i nonori, ma Saul i taravaina-naiei au Caesarea da i paritawanei au Tarsus. ");
INSERT INTO wed_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Anina ma ekalesia au Judea, Galili ma Samaria ana nuaubaii i mae. Ma Arua Vivivireina ana aguei ekalesia ai tumaḡana i vovai-virewapani, Ma ai boru i rarata, ma taui Bada i vivirana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nai maranaina Peter dobu maḡamaḡaui i naeni, ma God ana tauvitumaḡana awarii i ḡeta au Lidda. ");
INSERT INTO wed_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kampa oroto wavana Aeneas i nelaḡai, tauna gwaḡagwaḡana madeḡa 8 ana au aravi i matave. ");
INSERT INTO wed_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter i riwa, “Aeneas, Iesu Keriso i vilawanim! Ma vomairi ma am aravi ma noui!” Ma maratagogi i lawana. ");
INSERT INTO wed_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Anina ma rava maḡamaḡaui au Lidda ma Sharon wapuna melagaina, i mae-tavirei Bada awarina. ");
INSERT INTO wed_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Au Joppa tauvitumaḡana tagogi wavana Tabitha (Greek ponanei lamna Dorkas) tauna marana patapatana kaua maḡamaḡaui aiaii i kaukauei molamokai aubaii. ");
INSERT INTO wed_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wei marana tauna i doria ma iʼraḡe ma tupuana i oḡai ma numa vatavatara au aidamo, i vimataveni. ");
INSERT INTO wed_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda, lamna Joppa au ḡereḡerena ma maranai tauvitumaḡana i nonori da Peter au Lidda, taui ai rava ruaḡa i paritawanei da Peter i egari i pa, “Laḡilaḡina ma nei!” ");
INSERT INTO wed_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ma Peter taui maiteni i nae da i ḡeta ma i taravaina-ruiei au numa vatavatara. Kaikaiababa maḡamaḡaui ana toutoui Peter i mairi kwaviviroi. Maranai Dorkas lawalawaina ma kwama da gara i popopoia Peter i viatataiei. ");
INSERT INTO wed_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wate Peter anatapui i vibaḡai da i opu au doa, ma ae-tutunei i mae-ḡaira ma i raupari, ma taubeu i riwei, “Tabitha, ma vomairi!” Tabitha matana i kala ma maranai Peter i ʼnanai, i vomairi da i kiala. ");
INSERT INTO wed_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter urana i viloloi ma i voagui da i vomairi. Ma tauvitumaḡana anatapui ma kaikaiababa maiteni i kwatueiai, ma wavine lawalawaina taui i verei. ");
INSERT INTO wed_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ma wei riwana dobu Joppa i naeni ma rava maḡamaḡaui Iesu i vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter au Joppa i mae au pom biaḡa nanare Simon ḡamoḡamo opina taurauḡaroḡaroeina ana au numa. ");
INSERT INTO wed_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Au Caesarea oroto wavana Cornelius, tauna mai Italy sorodia boruna ai bada. ");
INSERT INTO wed_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tauna rava jijimanina ma patupatutuna, ma ana numa ravai maiteni God taurauduneleina. Ma molamolakai i paipaina-kauei ma marana patapatai i raraupari God awarina. ");
INSERT INTO wed_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Au bigai tagogi 3 oklok nanare i raraupari ma ana au inana, God ana anela au aiaina i ʼnanai, i nei awarina ma i riwa, “Cornelius!” ");
INSERT INTO wed_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius ana rovona anela i ʼnana-tunutunui ma i riwa, “Au bada, menanare!” Ma anela i paribelei, “Am pari ma am verena molamolakai awarii, i ḡeta God awarina me pulo apuapunana ḡabuna. ");
INSERT INTO wed_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ma marina nelara ḡelaui ma paritawanei au Joppa ma ravana wavana Simon wavana ḡelauna Peter ina taravainiai. ");
INSERT INTO wed_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tauna rava wavana Simon, ḡamoḡamo opina taurauḡaroḡaroeina awarina e mamae gera au ririvana.” ");
INSERT INTO wed_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Maranai anela i nae, Cornelius ana taunola ruaḡa i ḡoreiai, ma ḡelauna lamna sorodia, tauna ana tauvipaipai, tauna God tauvitumaḡaneiana. ");
INSERT INTO wed_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tauna aiwai anatapuna taui i riwei ma i paritawanei au Joppa. ");
INSERT INTO wed_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Maratomna au benai nanare maranai nelarai Joppa i tuḡereḡerei, Peter i ḡeta numa au tepana da ita raupari. ");
INSERT INTO wed_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma am i ʼraḡe ma i ḡoei da aiwai ita ani, maranai taui lam i vovokaukauei, ma Peter matanei rauboni i ʼnanai. ");
INSERT INTO wed_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I ʼnanai mara i wanatawanei ma purapura inanana me puru ḡaeḡaena au adana 4 i vojijini ma marei i tere-ḡaireiai au dobu. ");
INSERT INTO wed_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Au orana lamna sia tapuna ma tapuna, tetetei me mota ma kiu au aidamo lavelavei. ");
INSERT INTO wed_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma pona i riwa, “Peter ma vomairi, ma viraḡena ma ma am!” ");
INSERT INTO wed_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wate Peter i paribelei, “Eḡa! Lamna eḡa melanai ana kauei. Eḡa melanai lam viviḡana ata am-dadani.” ");
INSERT INTO wed_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wate pona i babani me, “Aiwai God i viviaiainia, eḡa ma riwa da i apoapoe.” ");
INSERT INTO wed_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mara tonuḡa wenanare i tupua ma me marana puruna i ḡaiana-melei au mara. ");
INSERT INTO wed_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ma Peter aiwai i ʼnainanai anona i vinua-notenotei, nanare ma Cornelius nelara i paripari-tawanei, taui Simon ana numa i nelaḡai ma i ḡeta ana au metaeta. ");
INSERT INTO wed_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Taui i paridadana, “Weka rava wavana Simon-Peter e mamae bo eḡa?” ");
INSERT INTO wed_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter amapo da wei i vivinua-notenotei maranai Arua vivivireina i riwa, “Simon, nelara tonuḡa e baibaiem! ");
INSERT INTO wed_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lamna aubaina ma vomairi ma ma ḡaira au gabaura, eḡa ma geduai, aubaina tau a paritawanei awarim.” ");
INSERT INTO wed_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peter i ḡaira ma awarii i riwa, “Taumi tau o baibaieu bo, Ami ḡoana aiwai?” ");
INSERT INTO wed_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ma nelarai i paribelei, “Tauai Cornelius mai Rome ai sorodia ai bada i paritawanelai, tauna rava jijimanina ma God tauvoepaepana, ma mai Jew maḡamaḡaui tauna e vivivirei. Anela vivivireina i riwei da uta nei ana au numa da aiwai u araramanei uta riwei.” ");
INSERT INTO wed_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ma Peter nelarai i ḡorei da i rui au numa ma kampa i matave. Ma maratomna anatapui i nae, Tauvitumaḡana ḡelaui au Joppa maiteni i vomairi. ");
INSERT INTO wed_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ma au pom ḡelauna taui au Caesarea i ḡeta. Cornelius taui i paipaini, ma ana numa ravai ma ana rava i ḡorei da i nei. ");
INSERT INTO wed_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ma maranai Peter i ruirui au numa, Cornelius Peter i ʼnanai ma i mae-ḡaira au ae karena ma ana vivirana i raudune. ");
INSERT INTO wed_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Wate Peter tauna i voepai ma i riwa, “Ma vomairi, Tau rava ota me tam.” ");
INSERT INTO wed_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peter ma Cornelius i bababani ma i ruirui au numa. Ma i ʼnanai da patara tauna i paipaini. ");
INSERT INTO wed_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peter taui i riwei, “Taumi o aramana-kauei da tauta mai Jew ata tarawatu e viviḡaeta da Jentail maiteni tana mae-gogona bo tana raugenari. Wate God i viatataieu da eḡa rava ana ḡorei rava apoapoena bo miramirana. ");
INSERT INTO wed_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lamna aubaina maranai u vibaḡaiu da ata nei, Tau au nota aiainei a nei. Tau ata pari-dadanem, Marina ma riweu aiwai aubaina au riwa u paritawanei?” ");
INSERT INTO wed_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius i paribelei, “Au benai wenanare au pom 4 marina i kwa, au numa a raraupari, nanare ma rava ana gara ararapoirina ma namanamarina au naoiu i raumairiei. ");
INSERT INTO wed_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ma i riwa, ‘Cornelius! God am pari i nonori ma am verena molamolakai awarii i vinuaiaiei! ");
INSERT INTO wed_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ma nelara ma paritawanei au Joppa da Simon e ḡoreḡorei Peter awarina. Tauna Simon, ḡamoḡamo opina taurauḡaroḡaroena ana au numa e mamae.’ ");
INSERT INTO wed_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lamna aubaina da am riwa laḡilaḡina ava a paritawanei, ma i ai da tam u nei. Tauai anatapuiai marina weka God au matana a vivipaipai da Bada aiwai i riwem ana nonori.” ");
INSERT INTO wed_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ma Peter babani i raukarei, “Marina a inana-kauei da God rava anatapui e vaivaia da tagogina. ");
INSERT INTO wed_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wate dobu dobuai ravai God e vivivirei ma kaua aiaii e kaukauei, Tauna wei ravai e ḡoeḡoei, ");
INSERT INTO wed_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Taumi o aramanei God Riwana Aiaina i paritawanei mai Israel awarii da rava ina mae-kaua God maiteni, maranai Iesu Keriso ina vitumaḡanei ma tauna ai lawana ina vibadei. ");
INSERT INTO wed_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Taumi o aramanei Iesu aiwai i kauei Judea au anatapuna, au Galili i vikarei maranai John babataito ai kaua i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","God Arua Vivivireina ma rewapana Iesu Nasaretei i verei da dobu maḡamaḡaui i naeni ma kaua aiaii i kaukauei, ma rava au orai arua apoapoe i ruiruini, i vilawani. ");
INSERT INTO wed_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","—Aiwai anatapuna au Judah provins ma au Jerusalem i kaukauei tauai anatapuiai a vimatematei ma a bababaniei. Tauna au korosi i tutui da iʼraḡe. ");
INSERT INTO wed_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wate God tauna iraḡelei i voepa-melei aupom au vitonuina ma i kauei da ḡelauai awariai i eḡa. ");
INSERT INTO wed_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Eḡa rava maḡamaḡaui tauna ita inanai, anina tauvimatamata i vinevinei awari ava i ḡeta. Lamna tauai maiteni a uma ma am ana vomairi au murina. ");
INSERT INTO wed_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma i egariai da dobu au anatapuna ana raugugula ma ana jima da God Iesu i vinei da rava anatapui lawalawaii ma irairaḡei ina rauetarei. ");
INSERT INTO wed_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peroveta anatapui i jimei da maranai rava Iesu i vitumaḡanei, Tauna wavinei God taui ai ḡoʼapoapoe ina vaitawanei.” ");
INSERT INTO wed_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Maranai Peter i bababani ma Arua Vivivireina i ḡairai ma rava i raurautaniḡana i vioai. ");
INSERT INTO wed_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ma mai Jew Joppei i nenei Peter maiteni, i ba kaua maranai God Arua Vivivireina i paritawana ḡairei Jentail awarii. ");
INSERT INTO wed_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Au baina mai Jew i nonori taui pona tapunei i bababani ma God i vivimae-ḡaeḡaeni. Anina ma Peter i riwa, ");
INSERT INTO wed_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Taui Arua Vivivireina i vaia me tauta. Wei lamna aubaina eḡa aiai ina viḡaeta da wei ravai tana babataitoi.” ");
INSERT INTO wed_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ma taui Cornelius ana numa ravai maiteni ma ana rava ḡelaui Iesu Keriso wavanei i babataitoi, ma taui Peter i vibaḡai da maiteni ita mae mara aburuna. ");
INSERT INTO wed_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apasol ma tauvitumaḡana au Judea provins i nonori da Jentail maiteni God riwana i nonori ma i vitumaḡana. ");
INSERT INTO wed_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ma maranai Peter i ḡeta me au Jerusalem tauvitumaḡana mai Jew ḡelaui tauna i eni i pa, ");
INSERT INTO wed_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Tam Jentail ai au numa u rui, ma maiteni u am!” ");
INSERT INTO wed_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Anina ma kaua menanare i tuputupuanei anatapuna Peter taui i pariverei: ");
INSERT INTO wed_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","I riwa i pa: Maranai a raraupari au Joppa ma matauei kaua a inanai, ma purapura inanana me puru ḡaeḡaena adana 4 i vojijini ma marei i tere-ḡaireiai awariu. ");
INSERT INTO wed_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Au orana a inana lamna ḡamoḡamo maramaraḡamai ma moduei, tetetei me mota ma kiu au aidamo lavelavei. ");
INSERT INTO wed_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ma pona a nonori i pa, “Peter ma vomairi, ma viraḡena ma ma am!” ");
INSERT INTO wed_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tau a paribelei, “Eḡa! Lamna eḡa melanai ana kauei. Eḡa melanai lam viviḡana ata am-dadani.” ");
INSERT INTO wed_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wate pona marei mara viruaina i babani, “Aiwai purapurana God i riwa da i ai, tam eḡa ma riwa da i apoapoe.” ");
INSERT INTO wed_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mara tonuḡa wenanare i tupua, ma puruna i ḡaiana-melei au mara. ");
INSERT INTO wed_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nai maranaina mai Caesarea ai rava tonuḡa i paripari-tawaneiai, au metaeta i raumairiei. ");
INSERT INTO wed_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma Arua Vivivireina i riweu da eḡa aiwai ana notai ma orau taputapunei ana nae. Mai Joppa tauvitumaḡana 6 maiteni a nae ma ravana ana au numa a rui. ");
INSERT INTO wed_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Cornelius i riwelai da anela awarina i eḡa, ma i riwei, “Rava ma paritawanei au Joppa da rava wavana Simon Peter ina neiai.” ");
INSERT INTO wed_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tauna wei riwana ina neiai ma lamnei tam ma am numa ravai maiteni ina vilawanimi. ");
INSERT INTO wed_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ma babani a raukarei ma Arua Vivivireina i ḡairai da taui i vioai me au naona awarita i tupua nanare. ");
INSERT INTO wed_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Anina ma Iesu aiwai i ririwei a notai, “John wairei i babataito, wate taumi Arua Vivivireinei ina babataitoimi.” ");
INSERT INTO wed_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Inanana au aiaina da God Jentail pulona tagogina i verei, me tauta i verevereta maranai Iesu Keriso ta vitumaḡanei, ma tau aiai da God ata viḡaei? ");
INSERT INTO wed_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Taui i vigamopotai maranai wei i nonori, ma God i viborumei i pa, “Riwa kaua da God Jentail maiteni i vianinei da ina rupena ma ina lawana.” ");
INSERT INTO wed_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ekalesia ḡelaui rau-iviapoapoe i rovoei maranai Stephen i viraḡeni ma i vilamonei au uama. Ḡelaui i ruba nae au Phonisia, au Saipras ma Antiok, ma kampa Iesu Riwana Aiaina i raugugulei mai Jew ava awarii. ");
INSERT INTO wed_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wate ekalesia ḡelaui mai Saipras ma mai Sairini i nae au Antiok Jentail awarii ma Iesu Riwana Aiaina i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bada ana rewapana taui au orai i mae ma Jentail maḡamaḡaui i vitumaḡana ma i mae-tavirei Bada awarina. ");
INSERT INTO wed_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Wei riwana i ḡeta ekalesia awarii au Jerusalem, ma taui Barnabas i paritawanei au Antiok. ");
INSERT INTO wed_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Maranai i ḡeta ma i ʼnanai da God ravai i viaiaina-kauei, tauna i vinuaiai ma i egari da Bada awarina ina vipatutu orai taputapunei. Barnabas tauna rava aiaina, Arua Vivivireina orana i oai ma ana tumaḡana i rata, ma God ana aguiei, i rauguga ma rava maḡamaḡaui i taini Bada awarina. ");
INSERT INTO wed_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ma Barnabas i nae au Tarsus da Saul ita baiei. ");
INSERT INTO wed_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ma i nelaḡai ma i neiai au Antiok, ma kampa tauvitumaḡana maiteni i mae madeḡa tagogi i kwa, ma patara ḡaeḡaena awarii i viararamana. (Weka au Antiok lamna i vikarei da tauvitumaḡana i viḡorei Kerisiana) ");
INSERT INTO wed_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wei au marana peroveta ḡelaui Jerusalem ei i ḡairai. ");
INSERT INTO wed_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Peroveta tagogi wavana Agabas i vomairi ma God ana rewapanei i vieḡa da gomara e nenei au naoii dobu au anatapuna (Caesar Claudius ana vibada au marana gomarana i nei). ");
INSERT INTO wed_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tauvotaḡotaḡo au Antiok i vianina da taui ava ita kauana-guratei da mane vounaina ita kauei da ai rava ekalesia au Judea ita voagui. ");
INSERT INTO wed_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Taui nanare i kauei ma manena Barnabas ma Saul au urai i terei ma taui ekalesia ai babada au Jerusalem i verei. ");
INSERT INTO wed_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lamna maranai, gulau Herod Agrippa i raukarei da ekalesia ḡelaui i rau-iviapoapoelei. ");
INSERT INTO wed_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","James, John tuana uana sodei i bori-tuini. ");
INSERT INTO wed_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ma maranai Herod i ʼnanai da mai Jew wei kauana i vinuaiaiei, ma ana sorodia i egari da Peter maiteni ita pani da au pani numana ita terei. Wei kauana Palawa Bagibagina ana au torela i tupua. ");
INSERT INTO wed_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ma Peter i pani ma au pani numana i terei ma sorodia 16 tauna i paini. Sorodia 16 i terei da borui 4 ma i vipaipai. Herod i ḡoei da Peter ita vojijini da raḡona torelana au murina ma au deba ita rauetarei. ");
INSERT INTO wed_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ma lamna aubaina Peter au pani numana i vojijini mara aburuna. Wate ekalesia i raraupari guratana God awarina Peter aubaina. ");
INSERT INTO wed_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ma nai waguvaraina, ma maratomna da Peter ita rauetarei, Peter sorodia ruaḡa au poui i matamatave. Urana seinei i raḡini sorodia ruaḡa au urai, ma sorodia ḡelaui au metaeta i vipaipai. ");
INSERT INTO wed_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Maratagogi Bada ana anela i eḡa ma pani numana i ravilalai. Ma Peter i vogugui da matana i kala ma i riwei, “Laḡilaḡina ma vomairi!” Ma sein au urana i dabarara. ");
INSERT INTO wed_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ma Peter i riwei, “Ma vigara ma ae uma ma oteni.” Ma nanare i kauei. Ma i egari, “Am kwama potopotona ma oteni ma ma votaḡotaḡoiu.” ");
INSERT INTO wed_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter anela i votaḡotaḡoi da pani numana i opu-tawanei, wate eḡa ita aramanei anela aiwai i kaukauei, tauna i notai i rarauboni. ");
INSERT INTO wed_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Taui, sorodia boruna ruaḡa au doa i netawanei, da i opu au metaeta iramei, wei e opuopu au taon. Metaeta ainelana i wanatawanei aubaii ma i opu. Taui etanai tagogi i ḡairani ma maratagogi anela tauna i voterei. ");
INSERT INTO wed_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter ana nota i nememei ma i riwa, “Wei anina riwa kaua! Bada ana anela i paritawaneiai da Herod au urana i vaitawaneu, da mai Jew aiwai i notanotai da ita tupua lamna eḡa ita tupua.” ");
INSERT INTO wed_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Maranai ana nota i nememei tauna i nae Mary ana au numa. (Mary lamna John alona. John wavana ḡelauna Mark). Kampa rava maḡamaḡaui i vitagogiei ma i raraupari. ");
INSERT INTO wed_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter au metaeta i raupewapewa ma taunola wavana Rouda i nei da metaeta ita votawanei. ");
INSERT INTO wed_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ma Peter ponana i nonori ma i aramanei da tauna, ma i vinuaiai guratana da eḡa metaeta ita votawanei ma i ruba-rui da i vinolanola i pa, “Peter au metaeta e maimairi!” ");
INSERT INTO wed_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wate taui eḡa ita vitumaḡanei ma i riwei, “Tam ma bubua!” Wate tauna i riwa bagibagi. Ma taui i riwa, “Nai Peter ana anela.” ");
INSERT INTO wed_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wate Peter i rarau-pewapewa ma maranai taui metaeta i votawanei ma i ʼnanai da tauna, taui orai i auepai. ");
INSERT INTO wed_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peter urana i voepai da rava i genuana ma i riwei menanare Bada pani numanei i tere-opunei. Ma i riwei, “James ma ekalesia ḡelaui wei ona pariverei.” Ma Peter i nae au dobuḡela. ");
INSERT INTO wed_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Maranai mara i tom kampa au pani numana nuabola ma vinuanaina ḡaeḡaena i peu sorodia awarii da aiwai i tupua Peter awarina ");
INSERT INTO wed_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod, ana sorodia i egari da Peter i baiei wate eḡa ita nelaḡai. Lamna aubaina sorodia 16 i etarei ma i viraḡeni. Muriai Herod Judea i netawanei ma i nae au Caesarea da ita mae mara aburuna. ");
INSERT INTO wed_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Marina Herod amlona i ḡaiḡai kaua Taia ma Sidon ravai awarii, lamna aubaina taui ana borui i nei da Herod maiteni wei i babaniei. Taui Herod ana taunola ḡaeḡaena Blastus, i taravaini da ita voagui. Taui rom i vibaḡei Herod maiteni. Aubaina ai lam Herod ana dobuei i nenei. ");
INSERT INTO wed_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ma marana i ḡetai da Herod maiteni ita viboru ma tauna ana vigulau garana i vigarei ma ana au anikiala i kiala ma awarii i babani. ");
INSERT INTO wed_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ma patara ana babani i nonori ma i logoi i pa, “Wei lamna god e bababani ma eḡa rava!” ");
INSERT INTO wed_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Maratagogi Bada ana anela Herod i vipeuni au doa ma motamota orana i ani da iʼraḡe, aubaina tauna rava ai voepaepa i vinuaiaiei ma eḡa rava ita riwei da Bada ita voepaepai. ");
INSERT INTO wed_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma ekalesia Bada riwana i raraugugulei ma rava maḡamaḡaui i nenei Bada awarina ma ekalesia i rarata. ");
INSERT INTO wed_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Maranai Barnabas ma Saul ai nola au Jerusalem i vikwai, taui John-Mark i taravaini da maiteni i nei au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kerisiana au Antiok au orai peroveta ma taugiu wavai wenanare, Barnabas, Simeon (e ḡoreḡorei Gawara), Lusias Sairiniei, Manaen (Tauna gulau Herod Antipas maiteni i rata tagogi), ma Saul. ");
INSERT INTO wed_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mara tagogi maranai taui i ujiuji ma Bada i vovoepaepai ma Arua Vivivireina i riwa i pa, “Tau, Barnabas ma Saul a vinei, ona tereriei au nola aubaina.” ");
INSERT INTO wed_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Anina ma uji ma pari au murina taui urai Barnabas ma Saul au tepai i terei ma God ruaḡai i viaiaini ma i paritawanei. ");
INSERT INTO wed_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ma Arua Vivivireina Barnabas ma Saul i paritawanei da i ḡaira au Selusia ma kampa i amkuka damana au bonabona Saipras. ");
INSERT INTO wed_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ma au Salamis i ḡota ma i nae mai Jew ai au boru numana ma God riwana i raugugulei. John-Mark taui maiteni i nae da ai tauagu. ");
INSERT INTO wed_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","7","Taui bonabonana i kwaviviroi da au Paphos taon i ḡeta. Weka Jew ei barabaravuna ma peroveta morumoruna i nebelei wavana Bariesu. Tauna bonabonana ana gavena Segius Paulus i vituranei, Segius Paulus rava nualaulaunana ma i ḡoei da God ana babani ita nonori ma lamna aubaina Barnabas ma Saul i rauḡoreiai. ");
INSERT INTO wed_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wate barabaravuna Bariesu (Greek ponanei lamna Elimas) Saul ma Barnabas i viḡaviei da gavena ana tumaḡana ita viapoapoeni. ");
INSERT INTO wed_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saul wavana ḡelauna Paul, Arua Vivivireina orana i oai ma barabaravuna matana i ʼnana-tunutunui. ");
INSERT INTO wed_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ma i pa “Tam Satan natuna ma kaua aiaii ma jijimani tauviapoapoenina! Tam morumoru kaukauam ma gwalagwalamerum. Ma amapo da Bada ana kaua ma voviravirai da moru. ");
INSERT INTO wed_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ma marina Bada urana ina kovoḡim da matam ina apoapoe mara aburuna ma eḡa madeḡa lalalaina ma inanai.” Maratagogi matana i vinawanawa ma i gimtona ma nare da were i voladaḡa-nae da rava au urana ita vojijina. ");
INSERT INTO wed_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Maranai gavena i ʼnanai aiwai i tupua ma i vitumaḡana, aubaina tauna Bada ana viararamana i bana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul ana rava maiteni Paphos i voterei ma i amkuka damana au Perga taon au Pamphilia provins, Ma weka John-Mark taui i voterei ma i naeme au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perga i voterei ma i rui da au Antiok taon au Pisidia provins. Ma au Sabate i rui au boru-numana ma i kiala. ");
INSERT INTO wed_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ma rava ḡelaui, Moses ana tarawatu bukana ma peroveta ḡelaui ai buka i ʼavi, ma babada riwa i paritawanei Paul ma Barnabas awari i pa, “Varevareiu! Mepa da awarimi nota aiwai da ota voaguiai lamna marina ona ḡei da ona babaniei.” ");
INSERT INTO wed_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul i vomairi ma urana i voepai da rava i genuana ma babani i vikarei i pa: Mai Israel ma taumi eḡa mai Jew ai God tauviborumeina, ona rautaniḡaneu! ");
INSERT INTO wed_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mai Israel ai God noinoita i vinei, ma i vimaurai ai au mae au Egypt, ma ana rewapana ḡaeḡaenei dobunei i taravaina-opunei. ");
INSERT INTO wed_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Madeḡa 40 au mutulua ami kaua apoapoei ami beura ma ami gunura anatapui am-iauei. ");
INSERT INTO wed_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Dam ḡaeḡaei 7 i vipupui au Canaan ma dobuna mai Israel i verei da i viḡariana-nonoei. ");
INSERT INTO wed_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Wei anatapuna madeḡa 450 au orana i tupua. Wei au murina God taurauetara i terei da taui i vibadei da peroveta Samuel ana mara. ");
INSERT INTO wed_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Anina ma rava God i vibaḡai da gulau ita verei. Ma God Saul, Kish natuna Benjamin ana damei i terei; ai gulau da madeḡa 40 i kwa. ");
INSERT INTO wed_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ma God Saul i tere-opunei ma David i terei ai gulau. Ma wenanare i riwa i pa, “Tau a aramanei da David, Jesse natuna orau ana rauoḡara, ma au ḡoana anatapuna ina kauei.” ");
INSERT INTO wed_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Muriai me God i parivainuaḡani nanare, Mai Israel ai Tauvilawana, Iesu David ana damei i nei. ");
INSERT INTO wed_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Muriai da Iesu ita nei, John mai Israel anatapui awari i jima da ai ḡoʼapoapoe ina voterei ma ina mae-tavirei God awarina ma ina babataito. ");
INSERT INTO wed_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ma John ana nola au damona i riwa, “Taumi o notanotai da tau Tauvilawana bo? Eḡa! Tau eḡa tauna. Wate ona rautaniḡana, rava au muriu e nenei tauna i ḡetelara, tau eḡa tagotagogina da ana ae uma ḡuravana ana rupeni.” ");
INSERT INTO wed_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Varevareu - Abraham natunatuna ma taumi Jentail God tauviviborumeina, God tauta awarita, kwakokwakoi vilawanai riwana i paritawaneiai! ");
INSERT INTO wed_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mai Jerusalem ai babada maiteni God ana Tauvilawana i vinua-nainei, ma lamnei Iesu i kovoḡi, Peroveta wei lamna i jimejimei au Sabate marana patapatana. ");
INSERT INTO wed_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Taui eḡa ana apoapoena aiwai ita nelaḡai da Iesu ita viraḡeni, wate Pilate i vibaḡai da ita viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Maranai rava ai babada maiteni, ai nuabola Iesu awarina i kauana-paiei me peroveta i ririwei nanare, ma tupuana au korosi i tere-ḡairei ma au guba i vimataveni. ");
INSERT INTO wed_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wate God Iesu iraḡelei i vovaimairini. ");
INSERT INTO wed_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ma au pom maḡamaḡaui Iesu taui maiteni au Galili da i ḡeḡae au Jerusalem awari i eḡa. Wei ravai marina e vivimatamata rava awarii. ");
INSERT INTO wed_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Marina tauai Riwana Aiaina a paripariveremi. Wei parivainuaḡanana wariaḡa noinoita awari i kauei. ");
INSERT INTO wed_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ma God nanare i kauei tauta eda muri aubaita, da Iesu iraḡelei i vovaimairini, au Psalm viruaina wenanare I girumi, ");
INSERT INTO wed_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God Iesu iraḡelei i vovaimairini da eḡa tupuana ina buda. Me i girugirumi nanare i pa, ");
INSERT INTO wed_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Psalm ḡelauna wenanare i girumi, ");
INSERT INTO wed_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Maranai David i mamae ma God ana nola i kauei ma iʼraḡe, ma amamana maiteni i doboi ma tupuana i buda. ");
INSERT INTO wed_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wate God Iesu iraḡelei i vovaimairini ma tupuana eḡa ita buda. ");
INSERT INTO wed_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Lamna aubaina au rava, ona aramanei da Iesu awarinei God ami ḡoʼapoapoe ina nota-tawanei. Rava anatapui da Iesu e vivitumaḡanei, ai ḡoʼapoapoe e notanota-tawanei ma ai viturana e viviaiaini. Wei Moses ana tarawatu eḡa ita kaukauei. ");
INSERT INTO wed_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ona paina-melemi da peroveta aiwai i ririwei eḡa awarimi ina tupua. Aubaina i riwa; ");
INSERT INTO wed_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ona rautaniḡana vivijiboḡami, ");
INSERT INTO wed_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul ma Barnabas i opuopu ma rava i nei ma i vibaḡa-guratei da ita nememei au Sabate ḡelauna da Tauvilawana ana kaua ita babanana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Boru i kwa da rava i vilamonei, mai Jew borui ma ḡelaui marina ina bori i vaia da i vimai-jew, taui Paul ma Barnabas i votaḡoi, ma i riwana-guratei da Iesu ana aguei ina mae jijina. ");
INSERT INTO wed_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Au Sabate ḡelauna taon ravai anatapui i ḡeta da Iesu riwana aiaina ita nonori. ");
INSERT INTO wed_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Maranai mai Jew wei patarana i ʼnanai ma orai unura i oai ma Paul i vikaua-morumoruei ma i vitepaubaubai. ");
INSERT INTO wed_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ma Paul ma Barnabas ana tepatorai i babani, “God riwana a jimei awarimi au naona, wate taumi wei riwana o geduaiei. Wei e viviatataiana da taumi lawana mamae-nonoana eḡa ota ḡoeḡoei. Lamna aubaina ana voteremi ma God riwana ana jimei Jentail awarii. ");
INSERT INTO wed_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bada wenanare riwa bagibaginei i riwelai, ");
INSERT INTO wed_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Maranai Jentail wei riwana i nonori, taui i vinuaiai kaua ma Bada Riwana Aiaina i voepaepai, ma taui da God i vinei lawana mamae-nonoana ita vaia, i vitumaḡana. ");
INSERT INTO wed_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ma Bada Riwana Aiaina i vituai nai au paratana. ");
INSERT INTO wed_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wate mai Jew Jentail waivinei manemanei ma mai Jew ḡelaui i egari da Paul ma Barnabas ai ḡavia i vomairi ma dobunei i viaḡaḡana-opunei. ");
INSERT INTO wed_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Anina ma taui aei pokauna i rauabuabui da ita viatataiei da Bada eḡa ita vinuaiai awarii ma i nae au Ikoniam taon. ");
INSERT INTO wed_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wate Arua Vivivireina kerisiana voui au Antiok orai i oai ma i vinuaiai kaua. ");
INSERT INTO wed_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kauana tagogina i tupua au Ikoniam. Paul ma Barnabas i nae mai Jew ai au boru numana ma menanare i babaninei da mai Jew ma Jentail maḡamaḡaui i vitumaḡana. ");
INSERT INTO wed_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Wate mai Jew ḡelaui eḡa vivitumaḡanai Jentail i kelari ma ai nota i barai da Paul ma Barnabas i geduaiei. ");
INSERT INTO wed_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Avena ma Paul ma Barnabas kampa i mae guratana ma ana tepatorai Bada ana aguei i jimajima. Ma kaua babaii ma vivirewapanai maḡamaḡaui i kauei. Wei i vimataira da ai jima lamna riwa kaua. ");
INSERT INTO wed_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Taon i kai ḡelaui mai Jew aubaii i mairi ma ḡelaui Aposol aubaii i mairi. ");
INSERT INTO wed_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ma mai Jew ma Jentail ḡelaui i vioga da Paul ma Barnabas ḡaimei ita viraurauei. ");
INSERT INTO wed_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wate taui riwana i vaia ma dobuna i ruba-tawanei ma i nae au taon ḡaeḡaei Listara ma Derbi au Laikonia provins ma taon au ririvai. ");
INSERT INTO wed_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ma weka Riwana Aiaina i jimana-naiei. ");
INSERT INTO wed_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Au Listara oroto aena ḡokokokarana, alona manawanei gwaḡagwaḡana i vinatunei ma eḡa ita babara dadana. ");
INSERT INTO wed_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kampa i kiala ma Paul i bababani i rarautaniḡanei. Paul matana i tawanei ma i ʼnanai da tauna i vitumaḡana da ita lawana ");
INSERT INTO wed_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ma i garara awarina, “Aemei ma mairi!” Ma orotona aenei i mairi ma babara i vikarei. ");
INSERT INTO wed_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Maranai patara i ʼnanai Paul aiwai i kauei taui ava ai ponei i babani vivira, “god ruaḡa i ḡairai awarita me rava.” ");
INSERT INTO wed_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Taui i riwa da Barnabas lamna mai Greek ai god Zeus ma Paul i vitauvibabani aubaina i riwa da tauna Hermes. ");
INSERT INTO wed_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeus ana pulo gabuna, taon au giana, Zeus ana pirisi patara maiteni bull ma berana ulaulai i neiai taon au metaetana da Apasol ita puloi. ");
INSERT INTO wed_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wate maranai Paul ma Barnabas wei riwana i nonori, taui ai gara i sikai ma i ruba-opu patara awarii ma i garara, ");
INSERT INTO wed_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Aiwai aubaina wei kauana o kaukauei? Tauai rava ota me taumi nanare! Tauai Riwa Aiaina a neneiai da nai kauai kwakwavi ona voterei ma ona nae Bada lawalawaina ona viborumei. Tauna mara ma dobu ma boga ma aiwai anatapuna au orai i kauei. ");
INSERT INTO wed_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Wariaḡa tauna rava i voterei da ai ḡoanei i mae. ");
INSERT INTO wed_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Wate marana patapatai e viviatataiemi da tauna e mamae ma ana nuavaina e verevereta, garewa marei ma maura ma lam e vereveremi ma au orami nuaiai e oaoai.” ");
INSERT INTO wed_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Apasol i bababani ma i kauana-guratei da ravai ita viḡaei da taui avena ita puloi. ");
INSERT INTO wed_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mai Jew ḡelaui Antiok ei ma Ikoniamei i nei ma patarana i egari da Paul ḡaimei i viraurauei ma taonei i taina-opunei, i notai da tauna iraḡe. ");
INSERT INTO wed_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wate maranai vivitumaḡanai i ḡeta da i mae-kwaviviroi, tauna i vomairi ma i naeme au taon. Aupom ḡelauna tauna ma Barnabas i nae au Derbi. ");
INSERT INTO wed_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul ma Barnabas Riwana Aiaina i jimei au Derbi ma ekalesia voui maḡamaḡaui i rui. Ma i nae me au Listara, Ikoniam ma Antiok. ");
INSERT INTO wed_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Metauna au dobuna i jimajima kampa tauvitumaḡana i ririwana-guratei ma i vovai-virewapani da ina mairi-jijina ai au tumaḡana i pa, “Piripiri maḡamaḡaui au orana ona rui wate au murina God ana au vibadana ona rui.” ");
INSERT INTO wed_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paul ma Barnabas ekalesia nununai ai babada i vinei ma i raupari ma i uji Bada awarina, da ai ekalesia ma ai babada ina paini. ");
INSERT INTO wed_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Anina ma au Pisidia provins i verautua da i nae me au Pamphilia provins. ");
INSERT INTO wed_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Au Perga Bada riwana i jimei ma i ḡaira au Atalia. ");
INSERT INTO wed_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ma kampa i amkuka ma i nae me au Antiok au Syria provins, weka ai nola i vikarei, maranai ekalesia kampa God i vibaḡai da taui ita viaiaini ai au nola ma i paritawanei ma marina ai nola e vivikwai. ");
INSERT INTO wed_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ma kampa i ḡeta ma ekalesia i vitagogiei, ma aiwai anatapuna God ana aguei i kaukauei rava i vieḡei, ma menanare Iesu metaeta i votawanei da Jentail maiteni Tauna i vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ma kampa tauvitumaḡana maiteni i mae guratana. ");
INSERT INTO wed_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wate nelara ḡelaui Judeaei i ḡairai au Antiok ma ekalesia i viararamani i pa, “Mepa da eḡa inibori ona vaia Moses ana tarawatu e ririwei nanare, God taumi eḡa ina vilawanimi.” ");
INSERT INTO wed_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ma karuwaḡawaḡa ḡaeḡaena i bauni Paul ma Barnabas maiteni. Ma taui Paul, Barnabas ma rava ḡelaui i vinei da i ḡae au Jerusalem da Apasol ma babada ita inanai wei babanina aubaina. ");
INSERT INTO wed_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ma i paritawanei au Jerusalem, Ma ai au vaḡai ekalesia au Phonisia ma Samaria provins i pariverei menanare Jentail i mae-tavirei God awarina. Ma taui i vinuaiaii kaua maraina wei i nonori. ");
INSERT INTO wed_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Maranai i ḡeta au Jerusalem, ekalesia ma Apasol i nei da i nebelei. Taui i pariverei menanare kaua anatapui God ana aguei i tupua. ");
INSERT INTO wed_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wate ekalesia ḡelaui mai Pharisi, i vomairi ma i babani guratana i pa, “Jentail anina da inibori ina vaia ma ona egari da Moses ana tarawatu ina voteletelei.” ");
INSERT INTO wed_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apasol ma babada i viboru da wei babanina i okei. ");
INSERT INTO wed_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ma i vitarapiri guratana ma Peter i vomairi ma taui i riwei i pa, “Au rava! O aramanei da au orata God i vineu da Riwana Aiaina ana jimei Jentail awarii da taui ina nonori ma ina vitumaḡana. ");
INSERT INTO wed_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God rava anatapui ai nota e araramanei, ma Jentail Aruana Vivivireina i verei me tauta nanare. Wei matairana i viatataieta da God i vianina. ");
INSERT INTO wed_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tauna Jentail ma tauta e vaivainita da tagogina, ma ata vitumaḡanei orata i viaiaiani. ");
INSERT INTO wed_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Marina aiwai aubaina God o viviamlo-ḡaiḡaini? Tauta amamata maiteni eḡa tata virewapana da tarawatu tata vojijina-kauei. Wate marina wei vitana Jentail ta verevere-damanei. ");
INSERT INTO wed_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Eḡateni! Tauta anataputa ta vivitumaḡana da Bada Iesu ana aguei tana lawana, ma nanare Jentail maiteni.” ");
INSERT INTO wed_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Rava anatapui i genuana ma Barnabas ma Paul i rautaniḡanei, taui i bababani menanare ana au vaḡai God ana aguei kaua aniba ma vivirewapanai i kauei Jentail awarii. ");
INSERT INTO wed_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Maranai i babani vorovei, James babani i vikarei, “Au rava ona rautaniḡaneu. ");
INSERT INTO wed_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","—Peter au naona i pariveremi menanare God Jentail i raugenari ma ḡelaui i vinei da tauna ḡarinei. ");
INSERT INTO wed_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ma Peroveta nununai wei kauai i bababaniei marina nanare e tuputupua: ");
INSERT INTO wed_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Wei au murina ana nememei, ");
INSERT INTO wed_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Da rava mamae-terenai ");
INSERT INTO wed_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wariaḡa da marina wei ta aramanei. ");
INSERT INTO wed_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","21","—Lamna au baina eḡa tana kauei da ina piripiri Jentail aubaii, taui e mamae-tavirei God awarina. Wate pepa tana girumi ma tana egari da lam e pulopuloei god morumorui awarii eḡa ina ani, eḡa ina viawawana labalababa, ḡamoḡamo uai e kikiki eḡa ina ani ma sia ana tarana eḡa ina ani. Aubaina wariaḡa da marina Moses ana tarawatu e raugugulei boru au numai Sabatena patapatana.” ");
INSERT INTO wed_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ma Apasol, babada ma ekalesia anatapui rava ḡelaui i vinei ma i paritawanei au Antiok au Syria provinsPaul ma Barnabas maiteni. Taui ai babada ruaḡa i vinei wavai Judas wavana ḡelauna Barsabas ma Sailas. ");
INSERT INTO wed_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ma wei pepana au urai i terei, Aposol, ekalesia babadai, varevareimi. Jentail ekalesia au Antiok, Syria provins ma Silisia provins. Varevareiai, egualau! ");
INSERT INTO wed_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tauai riwana a vaia da rava ḡelaui ai au boru i ḡairai ma ai viararamani i vinuabolaimi ma i visina-viraviraimi, wate tauai nai ravai eḡa ata paritawanei. ");
INSERT INTO wed_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Lamna aubaina tauai a viboru ma a vianina da taupariverena ata paritawaneiai, ata rava Paul ma Barnabas maiteni, ");
INSERT INTO wed_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","taui i verena-melei ma ai lawana eḡa ita vinuabolei Bada Iesu Keriso wavana aubaina. ");
INSERT INTO wed_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Judas ma Sailas a pariparitawanei da taui gamoiei ina riwemi aiwai tauai a girumi. ");
INSERT INTO wed_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Arua Vivivireina ma tauai ai ḡoana da eḡa vita ḡaeḡaena ana veremi, anina wei tarawatuna ava. ");
INSERT INTO wed_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Lam god morumorui i puloi eḡa ona ani, Eḡa tara ona umai, Eḡa ḡamoḡamo uana kikikina vioana ana tarana ona ani. Eḡa ona viawawana labalababa, Mepa da wei tarawatui ona vojijina-kauei, taumi kaua aiaina o kaukauei. Egualau kaua. ");
INSERT INTO wed_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ma nelarai i paritawanei da i ḡaira au Antiok, ma ekalesia i rieiai da pepa i verei. ");
INSERT INTO wed_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ma taui i ʼavi ma i vinuaiai kaua pariverena aiaina aubaina. ");
INSERT INTO wed_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ma Sailas taui God ana peroveta ma i babani guratana awarii ma wei taui i vinuaiaiei ma ai tumaḡana i vovai-virewapani. ");
INSERT INTO wed_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ma kampa i mae mara aburuna ma ekalesia ana nuaubai i paritawana-melei au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Wate Paul ma Barnabas au Antiok i mae, ma taui maiteni Bada Riwana Aiaina i viararamani ma i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ma muriai Paul, Barnabas i riwei, “Tana nae dobu au anatapuna mepa Bada Riwana Aiaina ta raugugulei ma ekalesia tana raugenari, ma tana inanai taui anina bo eḡa.” ");
INSERT INTO wed_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas i ḡoei da John-Mark ita taravaini. ");
INSERT INTO wed_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Wate Paul wei notana eḡa ita ḡoei aubaina au naona John taui au Pamphilia i ruba-tawanei ma eḡa ita mae da maiteni ita nola. ");
INSERT INTO wed_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ai viparipariniḡai i apoapoe guratana da taui i vilamonei. Barnabas, Mark i taravaini ma kukei i damana au au Saipras. ");
INSERT INTO wed_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paul, Sailas i vinei. Ma ekalesia, Bada i vibaḡai da ana aguei taui ai au nola ina paini. ");
INSERT INTO wed_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Taui Syria da Silisia i naeni ma ekalesia i raugenari ma i vinua-terenei. ");
INSERT INTO wed_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul i nae au Derbi da au Listara, kampa tauvotaḡotaḡo i mae wavana Timothy. Tauna alona Jew ei ma kerisiana, Wate amana Jentail. ");
INSERT INTO wed_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ekalesia au Listara ma Ikoniam Timothy i voepaepana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul i ḡoei da tauna ita taravaini ana au vaḡai, lamna aubaina ini bori i verei aubaina mai Jew kampa i aramanei da tauna amana Jentail. ");
INSERT INTO wed_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Maranai taon nununai i nenaeni, ma ekalesia kampa i paripari-verei Apasol ma babada au Jerusalem ai nota, ma i riwei da tarawatu i ririwei ina votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ma ekalesia ai vitumaḡana i vovai-virewapanai ma tauvitumaḡana voui i ruirui marana patapatai. ");
INSERT INTO wed_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Arua Vivivireina Paul ana rava maiteni i viḡaei da eḡa Bada riwana ita jimei au Eisia provins, ma Pirijia ma Galatia paratana i naeni. ");
INSERT INTO wed_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Maranai i nei Maisia ana au provins ma i ḡoei da ita damana au Bithinia provins. Wate Iesu Aruana eḡa ita vianinei. ");
INSERT INTO wed_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ma Maisia i verautuini da i nae au Troas. ");
INSERT INTO wed_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Waguvaraina Paul ana au inana i ʼnanai oroto Macedoniei i maimairi ma i vivibaḡai i pa, “Ma damanai au Masedonia da ma voaguiai!” ");
INSERT INTO wed_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul ana rauboni au murina tauai a vioga da laḡilaḡina ana vomairi Masedonia provins aubaina. Tauai a vitumaḡana da God i ḡorelai da Riwana Aiaina kampa ana jimei. ");
INSERT INTO wed_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Au Troas tauai amkuka, a viaruana damana au Samotreis bonabonana a ḡeta ma au pom ḡela a kuka-nae au Neapolis. ");
INSERT INTO wed_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ma kampa da a babara nae au Philipai taon au Masedonia provins, weka mai Rome ai sorodia ai bareki ḡaeḡaena i mae, kampa a veraumae. ");
INSERT INTO wed_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ma au Sabate taon a opu-tawanei ma a nae au waira, a notanotai da kampa boru gabuna wate eḡa. A kiala ma waivine ruaḡa ota kampa i rauriei awari a babani. ");
INSERT INTO wed_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Taurautaniḡana tagogi lamna Jentail wavinena wavana Lidia ma ana dobu Thaiataira. Tauna gara lebalebarina maiana ḡaeḡaena taugimareina ma God i vitumaḡanei, ma God orana i votawanei da aiwai Paul i bababaniei i rautaniḡanana kauei. ");
INSERT INTO wed_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Maranai wavine ana numa ravai i babataito ma i rauḡorelai i pa, “Ona nei au numa mepa da o notanotai da tau kerisiana ririwa kauana.” Ma i egariai da ana au numa a mae. ");
INSERT INTO wed_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mara tagogi a nenae boru au gabuna ma taunola guguini a nebelei, Tauna au orana arua apoapoena i mae ma lamnei aiwai amapo da ina tupua i vivieḡai. Ma mane ḡaeḡaena i kaukauei ana taniwaga aubaina. ");
INSERT INTO wed_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tauna Paul ma tauai i votaḡotaḡoiai ma i garagarara “Wei nelarai God ḡeḡetelarana ana taunola! E vivinolanola menanare God e vivilawananei.” ");
INSERT INTO wed_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wei kauana i kauei au pom biaḡa da Paul i viamlo-ḡaiḡaini da i mae-tavirei ma arua apoapoena i riwei, “Iesu Keriso wavanei a egaegarim da wavine ma opu-tawanei!” Maratagogi arua apoapoena wavine i opu-tawanei. ");
INSERT INTO wed_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Maranai taunola guguini ana taniwaga i aramanei da ai mane etanaina i vine-boai, taui Paul ma Sailas i vojijini ma i taina naiei au deba Gabemani awarii. ");
INSERT INTO wed_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Taui i nei ai taurauetara awarina ma i riwa, “Wei nelarai mai Jew wei dobuna ravai e vivinuaraḡaraḡai. ");
INSERT INTO wed_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Taui ata rava kaua ḡelaui e viviararamani ma wei ata giu e teretereḡairei.” ");
INSERT INTO wed_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ma patara i rui Paul ma Sailas vunuai aubaina. Ma gabemani Paul ma Sailas, ai gara i sikai ma wipiei i kwapui. ");
INSERT INTO wed_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","I vunu-kauei ma i tawana-ruiei au panipani numana. Ma numana badana i egari da ita paina-kauei da eḡa ita ruba. ");
INSERT INTO wed_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Anina ma Panipani badana taui i tawana-ruiei, panipani numana au orana ma aei, ai vivitainei au orana i raḡita-jijini. ");
INSERT INTO wed_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nubautuvai Paul ma Sailas i raraupari ma i welawela God awarina ma panipani ḡelaui i rarautaniḡana. ");
INSERT INTO wed_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nanare ma lolo ḡaeḡaeotana dobuna i gui. Ma maratagogi pani numana metaetana i wana-tawatawanei ma panipani anatapui ai sein i dabarara. ");
INSERT INTO wed_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Pani numana badana i vomairi ma ita inanai da metaeta wanatawanana ma i notai da panipani i ruba ma lamna aubaina ana sod i lavui da ita viraḡena-melei. ");
INSERT INTO wed_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wate Paul i garara, “Eḡa ma vunu-melem! Tauai anatapuai weka!” ");
INSERT INTO wed_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pani numana badana ana taunola i ḡorei da lalalaina ita neiai ma i ruba-rui ma ana sisisina i mae-peu Paul ma Sailas au naoi. ");
INSERT INTO wed_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ma i opunei au doa ma i paridadanei, “Babada aiwai ana kauei da ana lawana?” ");
INSERT INTO wed_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Taui i paribelei, “Bada Iesu Keriso ma vitumaḡanei ma ma lawana, am numa ravai maiteni.” ");
INSERT INTO wed_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ma God riwana i raugugulei tauna ma ana numa ravai awari. ");
INSERT INTO wed_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nai maranaina avena da waguvarai, pani numana badana Paul ma Sailas i naiei ma keroi i oḡai, Ma maratagogi tauna, ana numa ravai maiteni i babataito. ");
INSERT INTO wed_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Paul ma Sailas i ḡaiei ana au numa da i viambagibagi. Tauna ana numa ravai maiteni i vinuaiai kaua da marina God i vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ma marana i tom ma tauetara ana taunola i paritawanei pani numana badana awarina ma i egari i pa, “Nelara ma voterei da ina nae.” ");
INSERT INTO wed_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pani numana badana Paul i riwei, “Taurauetara i egariu da ana voteremi da ona nae. Marina ana nuaubami ona nae.” ");
INSERT INTO wed_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Wate Paul, taurauetara i riwei, “Tauai eḡa ita rauetarelai ma i vunu-kauelai patara au matai. Ma avena da tauai mai Rome, wate marina i ḡoei da govagovaḡanei ina paritawanelai bo? Eḡateni kaua! Ona voterei da taurauetara ina nei weka da ina naielai.” ");
INSERT INTO wed_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Taui wei babanina i naiana-melei da babada i riwei ma taui i rovo kaukaua maranai riwana i nonori da Paul ma Sailas lamna mai Rome. ");
INSERT INTO wed_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ma i nei au pani numana ma i riwa, “Tauai a kauana-boai, ai ḡoʼapoapoe ona nota-tawanei.” Ma i tere-opunei ma i vibaḡa-guratei da dobuna ita oputawanei. ");
INSERT INTO wed_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ma Paul ma Sailas pani numana i opu-tawanei ma i nae Lidia ana au numa ma kampa kerisiana maiteni i viboruboru ma i vovai-virewapani. Anina ma taui dobuna i netawanei. ");
INSERT INTO wed_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul ma Sailas Amphipolis taon ma Apolonia taon i voterei da i nae au Thesalonika taon. Weka mai Jew ai boru numana i mamae. ");
INSERT INTO wed_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ma i rui au boru numana au Sabate me mara patapatai i kaukauei nanare, kampa Sabate tonuḡa rava awari God riwana i viararamani. ");
INSERT INTO wed_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ma God riwanei i viararamana da Keriso ina vinuapoapoe ma iraḡelei ina vomairi me, “Wei ravana a bababaniei awarimi, tauna Iesu Keriso.” ");
INSERT INTO wed_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Mai Jew ḡelaui orai i taini ma taui i votaḡotaḡoi. Ma nanare Jentail nelara maḡamaḡagaui God taurauduneleina ma waivine wavai naenaei maḡamaḡaui. ");
INSERT INTO wed_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Wate mai Jew i unura ma rava ora-potapotai maḡamaḡaui au etanai i tami ma au taon vikaruwaḡawaḡa i vikarei. Ma oroto wavana Jason ana numa i ruini Paul ma Sailas i baibaiei da ita opunei patara awari. ");
INSERT INTO wed_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Wate maranai eḡa ita nelaḡai taui Jason ma kerisiana ḡelaui i taina-naiei taon babadai awari, ma i garara, “Wei ravai dobu au anatapuna apoapoe maḡamaḡaui i kauei, marina i ḡetai ata au dobu.” ");
INSERT INTO wed_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ma Jason, Paul ma Sailas i taravaini ana au numa. Taui Caesar ana tarawatu e viviaigai ma e ririwa da gulau ḡelauna e mamae wavana Iesu. ");
INSERT INTO wed_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Maranai patara ma taon babadai wei babanina i nonori taui amloi i ḡaiḡai kaua, ");
INSERT INTO wed_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ma Jason i egari da mane ḡaeḡaena i vimaiei da eḡa mae boaboa ḡelauna ina vitupui. Ma taui Jason i voterei da i nae. ");
INSERT INTO wed_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ma waguvarai tauvitumaḡana Paul ma Sailas i paritawanei au Berea. Maranai kampa i ḡeta, ma i rui au boru numana. ");
INSERT INTO wed_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mai Berea i viaiaii, eḡa me mai Thesalonika. Taui i rautaniḡana ma i votelatela ma marana patapatana God ana buka i ʼaiavi da ita aramanei da Paul aiwai i bababaniei lamna riwa kaua. ");
INSERT INTO wed_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ma lamnei mai Jew maḡamaḡaui i vitumaḡana, ma nanare mai Greek waivinei wavai naenaei ma nelara. ");
INSERT INTO wed_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Maranai mai Jew au Thesalonika paratana i nonori da Paul God riwana i raraugugulei au Berea, taui maiteni i nae kampa, ma rava i rauegari da ḡavia ita vikarei. ");
INSERT INTO wed_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Maratagogi kerisiana Paul i paritawanei au gera wate Sailas ma Timothy au Berea provins i mae. ");
INSERT INTO wed_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ma nelara Paul i tauvigwanigwaniei da au Athens, ma Paul nelarai i riwei ma i paritawanei au Berea da Sailas ma Timothy ita riwei da laḡilaḡina ita nei awarina. ");
INSERT INTO wed_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ma Paul au Athens ana rava i paipaini, ma i ʼnanai da kampa kokoitau i maḡa kaua ma i vinuabola kaua. ");
INSERT INTO wed_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mai Jew ma mai Greek God tauviborumeina awari i jima guratana au pari numana ma nanare au deba, aiai da i ḡeta ma i rautaniḡana. ");
INSERT INTO wed_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ma rava ḡelaui nuaulaulai i ḡetai ma maiteni i vitarapiri, taui e ḡoreḡorei mai Epicure ma mai Stoic, taui lawana ai kaua tauviararamanai. Ma ai rava ḡelaui i paridadana, “Wei ravana aiwai e voḡavoḡanei?” Ḡelaui i riwa, “Mepa da tauna dobu ḡelaui ai god e bababaniei.” Taui wenanare i babani aubaina Paul Iesu Riwana Aiaina ma ana iraḡe ma ana vomairi me, i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ma i taravaini ma i naiei ai au boru e ḡoreḡorei Areopagus ma i riwei, “Ma nei ma a ḡoei da am viararamanana vouna e bababaniei, ata aramanei. ");
INSERT INTO wed_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kaua ḡelaui e babaniei tauai a vivinuanainei, ma a ḡoei da ana aramanei anona aiwai?” ");
INSERT INTO wed_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Taumana ma mai Athens marana patapatai ai nola eḡa aiwai, da kaua voui ina virarautuei ma ina nononori.) ");
INSERT INTO wed_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ma Paul babadai au naoi i mairi ma i riwa: Dogadogara mai Athens! A inana da taumi vipatupatutumi ami god awarii, ");
INSERT INTO wed_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","A bababara ma ami pulo aniapunana a inainanai, ma tagogi a inanai au tepana i giruma, “Wei God eḡa ata araramaneia aubaina.” Wei Godna o viviborumei wate eḡa ota aramanei. Tau ana riwemi nai Godna aiai. ");
INSERT INTO wed_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tauna God mara ma dobu ma aiwai anatapuna au orana i kauei. Ma tauna mara ma dobu badana, ma numa rava uranei e voavoai au orana eḡa ita mamae. ");
INSERT INTO wed_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ma eḡa rava ai agu ita paipaini, tauna agu eḡa ita ḡoeḡoei. Aubaina tauna rava lawana ma lavutu ma anatapuna e vereverei. ");
INSERT INTO wed_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Au karena rava tagogi i kauei ma nai ravanei dam patarai i vitupua ma dobu i maeni. Tauna ainelana rava ai mara i terei da ina mae ma ina iraḡe ma animae paratana i aiterei. ");
INSERT INTO wed_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God wenanare i kauei da rava tauna ina baiei da mepa ina nelaḡai. Wate tauna au ḡereḡereta, eḡa au uama. ");
INSERT INTO wed_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Taugiruma ḡelauna Greekei i riwai pa, “Taunei ta mamae ma ta bababara ma anatapuna ta kaukauei.” Ma wate ami taugiruma ḡelauna i girumi i pa, “Tauai nanare tauna natunatuna.” ");
INSERT INTO wed_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ma tauta God natunatuna, eḡa tana notai da God lamna me kokoitau, goldei bo silvei i kauei. Rava uraiei ma ana nuaulaulauei i kauei. ");
INSERT INTO wed_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Wariaḡa rava God eḡa ita aramanei wate God taui i ʼnana-tawanei, wate marina anataputa egaegarita da tana rupena ma tana mae-tavireta awarina. ");
INSERT INTO wed_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Aubaina mara i vinei maranai rava anatapui aiainei ma jijimaninei ina kovoḡi. Rava i vinei da taunei ina kovoḡa. God wei ravana iraḡelei i vovaimairini lamna ina vimataira rava awari da ravana anina tauna. ");
INSERT INTO wed_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Maranai Paul iraḡelei vomairina i babaniei, rava i nonori ma ḡelaui tauna i vinamei wate ḡelaui i riwa, “Tauai a ḡoei da muriai wei babanina ma babaniana-melei.” ");
INSERT INTO wed_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ma Paul ai boru i opu-tawanei ma boru i gudu. ");
INSERT INTO wed_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wate ḡelaui i vitumaḡana ma Paul i votaḡotaḡoi. Tagogi lamna Dionisius, Areopagus boruna au orana, ma wavine wavana Damaris, ma rava ḡelaui. ");
INSERT INTO wed_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paul Athens i netawanei ma i nae au Corinth. ");
INSERT INTO wed_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kampa Akwila tauna Jew au Pontus i tupua, marinaota au Italy da i nei awana Prisila maiteni. Aubaina Rome ai gulau Claudius mai Jew anatapui i viaḡaḡei da Rome i opu-tawanei. Paul i nae da taui ita inanai. ");
INSERT INTO wed_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paul taui maiteni i mae, taui tauampopo, (ḡamoḡamo opina ma gara i popopoi numa aubaina ma i gimagimarei) me Paul ai nola tagogina. ");
INSERT INTO wed_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabate patapatana au pari numana tauna mai Jew ma Jentail awari i jima guratana da orai ita sinavirai. ");
INSERT INTO wed_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Maranai Sailas ma Timothy au Masedonia da i ḡetai, Marina Paul Bada riwana ava i raugugulei mai Jew awarii da Iesu tauna anina God ana Vinevine Keriso. ");
INSERT INTO wed_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Wate mai Jew Paul i viḡaviei ma riwa apoapoenei i ririwei. Ma tauna ana gara i rauabuabui ma awari i riwa, “Mepa da o kwako, lamna ona viwavu-melemi, eḡa tau ona viwavuiu! Marina da e nenae, ana nae Jentail awari.” ");
INSERT INTO wed_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ma taui i voterei ma i nae Jentail wavana Titus Justus ana au numa i mae, tauna God tauviborumeina ma ana numa pari numana au ḡereḡerena. ");
INSERT INTO wed_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, pari numana ai bada, Bada i vitumaḡanei ana numa ravai maiteni, ma mai Corinth maḡamaḡaui Paul i rautaniḡanei, i vitumaḡana ma i babataito. ");
INSERT INTO wed_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Waguvara tagogi Bada Paul ana au inana i babani i pa, “Eḡa ma rovo, ma babani ma eḡa ma genuana.” ");
INSERT INTO wed_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Aubaina Tau tam maiteni. Ma rava eḡa ina rau-iviapoapoelem aubaina au tauvotaḡotaḡo i maḡa wei au dobuna. ");
INSERT INTO wed_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ma Paul kampa i mae madeḡa tagogi ma nawaravi six, ma God riwana i jimei. ");
INSERT INTO wed_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wate maranai Galio i vi-Gavena au Akaia provins, mai Jew kampa i vitagogiei ma Paul i vojijini ma i naei Gavena awarina da ita rauetarei. ");
INSERT INTO wed_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ma taui i viwavui ʼpa, “Wei orotona ana moruei rava orai e taitaini da God e viviborumei ma ata tarawatu e viviaigai.” ");
INSERT INTO wed_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ma Paul gamona i laḡi da ita babani ma Galio i babani mai Jew awari i pa, “Mepa da taumi wei ravana o viviwavui da kaua ḡaeḡaei bo kaua apoapoe aubaina, lamna tau au nola da ata rau-taniḡanemi. ");
INSERT INTO wed_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Wate wei taumi ami babani ami wava ma ami tarawatu, ana voterei au urami. Tau eḡa wei kauai ana rauetarei.” ");
INSERT INTO wed_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ma etara numanei i viaḡaḡana-opunei. ");
INSERT INTO wed_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Taui anatapui pari numana ai bada Sothenis i vojijini ma i vunui etara numana au naona wate Galio taui i ʼnana-tawanei. ");
INSERT INTO wed_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul i mae mara aburuna tauvitumaḡana maiteni au Corinth ma wagei i nae au ḡereḡere au Cenkirei waga ai au animae. Prisila ma Akwila maiteni. Ma kampa Paul ana parivainuaḡana aubaina aparana i ḡari, ma anatapui i nae au Syria ");
INSERT INTO wed_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Taui au Ephesus i ḡeta ma Paul, Prisila ma Akwila i voterei. Ma i nae au boru numana Mai Jew awari i jima. ");
INSERT INTO wed_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Rava i vibaḡai da ita mae mara aburuna wate tauna eḡa ita vianina. ");
INSERT INTO wed_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Wate maranai i opu da ita nae ma taui i riwei, “Ana nememei mepa da God ana ḡoana, ma Ephesus i netawanei ma wagei i damana.” ");
INSERT INTO wed_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Maranai i ḡeta au Caesarea ma i nae au Jerusalem da kerisiana i raugenari ma i nae au Antiok. ");
INSERT INTO wed_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Au Antiok i mae mara aburuna ma Galatia provins ma Pirijia provins i naeni ma kerisiana i vovai-virewapani. ");
INSERT INTO wed_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Wei marana Apolos tauna Jew, au Alexandria da Egypt da i nei au Ephesus. Tauna Bada riwana ma ana giruma i aramana-kauei ma rava bababanina. ");
INSERT INTO wed_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Rava ḡelaui, Apolos Bada ana etanai babanina, i viararamani, ma ana tepatorana i jima ma Iesu ana kaua ma ana lawana i viararamana-kauei. Wate tauna John Taubabataito ana babataito babani ava i aramanei. ");
INSERT INTO wed_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ma i vikarei da ana tepatorana i raugugula au boru-numana. Wate maranai Prisila ma Akwila tauna ana babani i nonori. Ma i ḡorei da maiteni i nae ai au numa ma Bada ana etanai ana babani i viaramana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Maranai Apolos i nenae au Akaia, kerisiana Apolos i vovai-virewapani. Ma kerisiana au Akaia ai pepa i giruma da ita pariverei da tauna ita nebelei. Maranai au Akaia i ḡeta ma taui God ana aguei i vivitumaḡana, agu ḡaeḡaena i verei. ");
INSERT INTO wed_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tauna ana babaniei au deba mai Jew i vovaiubai. Ma God riwana i vaia ma lamnei rava i viararamani da Iesu anina Keriso. ");
INSERT INTO wed_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos au Corinth taon Akaia provins i mae, ma Paul ola i taḡoni da au Ephesus i ḡeta. Kerisiana ḡelaui kampa ");
INSERT INTO wed_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ma i paridadanei i pa, “Arua vivivireina o vaia bo eḡa maranai o babataito?” Taui i paribelei i pa, “Eḡa, Tauai eḡa ata aramanei da Arua vivivireina e mamae.” ");
INSERT INTO wed_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ma Paul i paridadana, “Aiwai babaitona o vaia?” Taui i paribelana, “John ana babataito a vaia.” ");
INSERT INTO wed_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul i riwa, “John ana babataito lamna mataira da taui ai ḡoʼapoapoelei i mae-tavirei; ma mai Israel i riwei da Tauna au muriu e nenei ona vitumaḡanei lamna Iesu.” ");
INSERT INTO wed_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Maranai wei i nonori ma i aramanei taui i babataito Bada Iesu wavanei. ");
INSERT INTO wed_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ma Paul urana au kolai i terei ma Arua vivivireina au orai i rui. Ma i vikarei da pona tapunei i bababani ma God riwana i raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Taui nelara iavana twelve. ");
INSERT INTO wed_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul i nae au boru-numana ma kampa nawaravi tonuḡa au orana ana tepatorana mai Jew awarii i bababani. Da rava orai ita sinavirai da Bada ana vigulau ita vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Wate ḡelaui kampa orai i bagibagi ma eḡa ita ḡoei da ita vitumaḡana, ma patara au matai Iesu ana etanai i vijiboḡi. Ma Paul taui i voterei ma kerisiana i taravaini ma i nae Tairanus ana au numa, ma kampa i viararamana ma i giugiu pompom. ");
INSERT INTO wed_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ma nanare i mae madeḡa ruaḡa i kwa, da mai Jew ma Jentail ravai maḡamaḡaui au Eisia provins maemaei Bada riwana i nonori. ");
INSERT INTO wed_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ma God ana rewapanei Paul kaua ḡaeḡaei ma aniba i kaukauei, ");
INSERT INTO wed_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","lamna avena wate rava ai agesi da ai nola garai i naiei Paul awarina da i vodadani ma i naei da rava doridoriai i vodadani, ma arua apoapoei i opu-tawanei ma i lawana. ");
INSERT INTO wed_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mai Jew ḡelaui dobuna i naeni ma arua apoapoei i viviaḡana-opunei ma i raudadana Iesu wavanei da arua apoapoei i viviaḡaḡei. Taui arua apoapoei i riwei i pa, “Iesu wavanei, taunei Paul e raraugugula, Tau a egarim da ma opu.” ");
INSERT INTO wed_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Skeva, pirisi ai bada natunatuna nelarai seven wei kauana i kaukauei. ");
INSERT INTO wed_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Wate mara tagogi arua apoapoena i paribelei, “Iesu a aramanei ma Paul a aramanei ma taumi aiavoi?” ");
INSERT INTO wed_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ma rava au orana arua apoapoena maemaena i auepai ma taui i vunui da eḡa ita vikalokaloei. Ai gara i sika-naei ma ana kovakovai ma tararatai numei i viopuopuana ma i viruberubei. ");
INSERT INTO wed_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mai Jew ma Jentail ravai au Ephesus maemaei wei riwana i nonori ma rovo orai i ḡaeni ma Iesu wavana i vivirana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Maḡamaḡaui i vitumaḡana ma i nae kerisiana awarii ma ai ḡoʼapoapoe i rupeni. ");
INSERT INTO wed_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tauvitumaḡana voui maḡamaḡaui paraparaumai, ai buka i vidamni au deba ma i apui. Maranai bukai ai maia i ʼavi da silver 50,000. ");
INSERT INTO wed_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kaua babai me wei, Iesu riwana i vibabarai nai au dobuna ma rava maḡamaḡaui i vitumaḡana. ");
INSERT INTO wed_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wei anatapuna au murina Paul au orana i vinua-notanota da au Masedonia da Akaia ita verautuini da ita damana au Jerusalem ma i riwa, “Ana nae au Jerusalem ma muriai ana nae da Rome ana inanai.” ");
INSERT INTO wed_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ma Paul ana tauagu ruaḡa Timothy ma Erastus i aiparitawanei au Masedonia provins, ma tauna kampa i mae mara aburuna au Eisia provins. ");
INSERT INTO wed_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Iesu ana babani ma ana kaua vouna aubaina, ma viḡaiḡaiawa ḡaeḡaena i tupua au Ephesus. ");
INSERT INTO wed_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Silver taunoleina wavana Demetrius, mai Greek ai god wavinena ana numa taparoro kokoitaui i rarau-ḡaroḡaroei da i gimagimarei, ma wei nolana mane ḡaeḡaena e neineiai silver taunoleina nai au dobuna aubaii. ");
INSERT INTO wed_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ma taui anatapui ai rava nolana tagogina e kaukauei maiteni i rauḡoreiai ma i riwa, “Au rava, o aramanei da ata maura wei nolanei ta vaivaia. ");
INSERT INTO wed_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ma o inanai ma o nonori menanare wei ravana Paul e kaukauei, Rava ai nota i sinavirai da maḡamaḡaui god Artemis raudunena i voterei au Ephesus ma dobu Eisia paratana anatapuna. Ma e ririwa da ‘rava god i rauḡaroḡaroei, lamna eḡa god.’ ");
INSERT INTO wed_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tauta tana inana kaua da wavata ma ata mane ani kauana eḡa ina apoapoe. Ma ata god ḡetelarana Artemis ana numa taparoro ma wavana eḡa ina vijiboḡi, eḡa au Eisia provins ava ma dobu au anatapuna.” ");
INSERT INTO wed_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Maranai patara wei babanina i nonori taui i meji kaua ma i vigaragarei, “Artemis mai Ephesus ai god i ḡetelera!” ");
INSERT INTO wed_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ma taui i garagarara rava nai au dobuna i nonori ma taui maiteni i garara labalababa. Anina ma patara Gaius ma Aristakas i vojijini taui ruaḡai mai Masedonia Paul ana tauvigwanigwaniana, ma i rubana-naiei nai dobuna ana boru gabuna. ");
INSERT INTO wed_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul i ḡoei da patara au naoi ita rui da ita babani wate kerisiana eḡa ita vianinei. ");
INSERT INTO wed_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wate nanare Paul ana rava ḡelaui au gabemani tauna i viḡaei da eḡa ina nae au boru. ");
INSERT INTO wed_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Patara i vinuanaina, i logologoi ma i garagarara labalababa ma eḡa ita aramanei aiwai aubaina weka i nei. ");
INSERT INTO wed_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mai Jew oroto tagogi i dudu-opunei au naoi wavana Alexander ma patara ḡelaui i garara awarina da ita babani. Alexander urana i voepai da taui ita genuana ma tauna ana rava aubai ita babani. ");
INSERT INTO wed_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Wate maranai i aramanei da tauna Jew. Taui anatapui pona tagoginei wenanare i garagarara, “Tauta mai Ephesus ata god Artemis i ḡetelera!” da hour ruaḡa i kwa. ");
INSERT INTO wed_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ma taon badana patara i riwei da i genuana ma i riwa, “Au rava mai Ephesus, rava anatapui au dobu i aramanei da tauta tauvipaipai mai Ephesus ai god ḡeḡetelarana Artemis ana numa taparoro ma ana ḡaima vivireina marei i peuai aubaina. ");
INSERT INTO wed_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Eḡa aiai wei ina vikaua-moruei. Lamna aubaina orami ina rauei ma eḡa aiwai apoapoena ona kauei. ");
INSERT INTO wed_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Wei ravai o neiai weka wate taui eḡa au numa taparoro aiwai ita danenei bo ata god ita riwana-boei. ");
INSERT INTO wed_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Mepa da Demetrius ana rava maiteni e viviwavui taui ina nae ina rauetara ma ami viwavu ona naei kampa taurauetara awarina. ");
INSERT INTO wed_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ma mepa da ami nuabola ḡelaui e mamae lamna taon babadai ai au boru ona babaniei ma ona tere-jijimani. ");
INSERT INTO wed_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ma amadodo aiwai i tupua, tau a rovo da ina viwavuita mae-boaboa aubaina. Wei vikaruwaḡawaḡana anona eḡa, ma mepa da Rome ina paridadana ma tauta menanare tana paribelananei. ");
INSERT INTO wed_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Anina ma boru i gudui ma rava i vilamonei.” ");
INSERT INTO wed_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Vikaruwaḡawaḡa au Ephesus taon i kwa ma au murina Paul kerisiana i raukwatueiai da i vinua-terenei, i viegualauei ma i netawanei da i nae au Masedonia provins. ");
INSERT INTO wed_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ma dobuna ḡaeḡaenana i naeni ma kaua maḡamaḡaui kerisiana i vinua-terenei. Anina ma au Akaia i ḡeta. ");
INSERT INTO wed_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kampa nawaravi tonuḡa i mae. Tauna i vokaukaua da ita nae au Syria ma wate i nelaḡai da mai Jew ḡelaui viraḡenana i viviogatarei lamna aubaina da i nae me au Masedonia. ");
INSERT INTO wed_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nelara ḡelaui i votaḡotaḡo taui lamna Piras natuna Sopater ana dobu Berea; Aristakas ma Sekundus, mai Thesalonika, ma Gaius tauna ana dobu Derbi; ma Tijikus ma Trophimus ai dobu Eisia provins; ma Timothy. ");
INSERT INTO wed_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Taui wagei i ainae au Troas ma kampa i painiai. ");
INSERT INTO wed_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ma palawa bagibagina torelana au murina, wagei Philipai taon au Masedonia provins a netawanei. Ma aupom 5 au murina au Troas a ḡeta ai rava awari, kampa aupom 7 a mae. ");
INSERT INTO wed_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Wiki au karena - Sunday tauai a vitagogielai voepaepa ma Bada ana amgogona aubaina, ma kampa Paul i jima da nubautuva, aubaina maratomna da ita nae. ");
INSERT INTO wed_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Numa vatavatara au tepana a vitagogielai, ma kampa rampa maḡamaḡaui i ararata. ");
INSERT INTO wed_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Oroto laragana wavana Eutikus au windo i kiakiala ma Paul i raraugugula, ma tauna matana i pota kaua da i raunuavuru, ma kampa au tepa dewadewana i peu-ḡaira da au doa i rauei. Maranai taui i ḡaira da ita voepai, tauna irairaḡena. ");
INSERT INTO wed_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paul i ḡaira, i matave-tepani ma i rapai ma rava i riwei i pa, “Eḡa ona vinuabola, tauna lawalawaina!” ");
INSERT INTO wed_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Anina ma Paul i ḡae me au numa ma kerisiana maiteni Bada ana amgogona amna i ani ma awari i babani maratom. Ma Paul nai dobuna i netawanei. ");
INSERT INTO wed_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Taui laragana lawalawaina i naiei au numa ma rava orai i rauei. ");
INSERT INTO wed_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paul aenei i nae au Assos ma tauai i riwelai da wagei ana nae au Assos da tauna kampa ana vigerui. ");
INSERT INTO wed_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ma au Assos a vigerui ma a nae au Miletus ");
INSERT INTO wed_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Maratomna bonabona Kios au ḡereḡerena a nae. Ma marana i tom au Samos a ḡeta, ma maratom ḡela au Miletus a ḡota. ");
INSERT INTO wed_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul i ḡoei da jijimanina ina nae ma avena ita rui au Ephesus, eḡa ita ḡoei da au Eisia provins ina mae-guratana. Tauna i vipaparana ma mepa da tagotagogina au Jerusalem ina ḡeta muriai da Pentecost torelana. ");
INSERT INTO wed_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Au Miletus Paul riwa i paritawanei au Ephesus taon kerisiana babadai awari da ita nebelei. ");
INSERT INTO wed_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Maranai au Ephesus taon i ḡetai ma taui i riwei i pa: O aramanei au lawana menanare maranai vovounai weka au Eisia provins a ḡetai. ");
INSERT INTO wed_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mai Jew i ḡoei da ita rau-iviapoapoeleu wate tau a vilamolamona ma ana toutou Bada awarina a vivitaunola. ");
INSERT INTO wed_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","O aramanei da maranai God Riwana Aiaina awarimi a raugugulei, riwa aiaina aniaguimi eḡa ata tajijini. Au deba a raraugugula rava maḡamaḡaui au naoi, ma ami au numa a viararamanimi ");
INSERT INTO wed_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Riwa bagibagina mai Jew ma Jentail a verei, A riwei da ita rupena ma ita mae-tavirei God awarina ma Iesu ita vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ma marina Arua Vivivireina i riweu da ana nae au Jerusalem. Eḡa ata aramanei kampa aiwai awariu ina tupua. ");
INSERT INTO wed_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wate taon nununai awari a nenae ma Arua Vivivireina e vivieḡeu da amapo ina paniu ma au deri ina tereu ma ina rau-iviapoapoeleu. ");
INSERT INTO wed_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ma mepa da ina viraḡeniu, wei lamna eḡa kaua ḡaeḡaena tau awariu. Wate kaua ḡaeḡaena lamna Bada Iesu nola i verevereu da ana vikwai. Wei nolana lamna, God ana iviaiai maemaena, riwana ana raugugulei. ");
INSERT INTO wed_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Maḡamaḡaumi awarimi a nei ma God ana vigulau a raugugulei wate marina a aramanei da amadodo da i nenae, naou eḡa ona inana-melei. ");
INSERT INTO wed_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","God ana vilawana ogatarana rava aubaii eḡa ata govaḡi awarimi lamna aubaina riwa bagibaginei a ririwemi da mepa da rava au babani eḡa ina vitumaḡanei ma ana lawana maemae-nonoana ina vine-boai, lamna eḡa tau au wavu. ");
INSERT INTO wed_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Taumi babada ma ona paina-melemi, nanare tauvitumaḡana taui aiavoi da Arua vivivireina au urami i teretereia. Ona inana-vaitetei me sipu taupainana ana sipu e paipaini. Taui lamna God ana vinevine taranei i gimarai. ");
INSERT INTO wed_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A aramanei da ana nae ma au muriu tauraugugula morumorui ina nei awarimi ma rava ai tumaḡana ina viapoapoeni, me auou moduei sipu au boruna viraḡena aubaina. ");
INSERT INTO wed_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ma rava ḡelaui ami au dam oina ina vomairi ma ina viararamana ma moruei rava orai ina taini da taui ina votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Lamna aubaina matami ina kala ma ona aramanei da madeḡa tonuḡa marai ma waguvarai a notanotaimi ma ana toutou a viviararamanimi. ");
INSERT INTO wed_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ma marina God au urana a tereteremi. Ana agu e verevereoimi ona vivitumaḡanei. Wei aguina e vovaivirewapanimi, ma ami pulo ina veremi, aubaina taumi God natunatuna viaiainai. ");
INSERT INTO wed_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ma tau eḡa rava ana mane bo ana purapura ata rauoḡarei ");
INSERT INTO wed_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Taumi o aramana-kauei da tau nimauei a nola da mane a vaia da tau au taubagibagi turau aubaiai. ");
INSERT INTO wed_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nanare, a viatataiemi da ona nola guratana da mane ona vaia ma molaka ona voagui. Iesu ana babani eḡa nuanuami ina vuru, Tauna i riwa i pa, “Verena i ai kaua eḡa me vainana.” ");
INSERT INTO wed_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul i babani vorovei ma anatapui i mae-ḡaira au doa ma i raupari. ");
INSERT INTO wed_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","I vinolanola i pa, “Amapo eḡa naou ona inana-melei.” Wei riwana i vinuabolai da i vitouana, Paul i taragwabai ma i vigia-laḡolaḡonei. Ma i naiei da au waga i vigeruei. ");
INSERT INTO wed_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ephesus kerisiana babadai a viegualauei ma wagei jijimanina a nae au Cous bonabonana ma ubaubanai a nae au Roudes bonabonana, kampa da a damana au Patara taon. ");
INSERT INTO wed_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Weka waga ḡelauna i nenae au Phonisia a gerui, ");
INSERT INTO wed_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","da au Saipras bonabonana a rubatawanei, au kelakelauai da a nae au Taia au Syria provins a ḡota, da purapura ita viopuni. ");
INSERT INTO wed_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kampa tauvitumaḡana a baiei ma aupom 7 maiteni a mae. Arua Vivivireina kerisiana i riwei da Paul awarina aiwai ina tupua, ma lamna aubaina Paul i viḡaei da eḡa ina nae au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ma mara i ḡetai da ata vomairi, kerisiana awawai maiteni da natunatui taon i voterei ma anatapuiai a ḡaira au gera, a raupari gogona. ");
INSERT INTO wed_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","A viegualau da tauai au waga a geru ma taui i nae-me ai au numa. ");
INSERT INTO wed_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Au Taia ma a nae au Tolemais taon a ḡeta. Tauvitumaḡana kampa a nebelei ma aupom tagogi maiteni a mae. ");
INSERT INTO wed_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ma marana i tom ma dobuna a voterei ma a nae au Caesarea, kampa God riwana taujimeina Philip ana au numa a mae, tauna oroto vi-7-na au Jerusalem i vinevinei da lam taupainina. ");
INSERT INTO wed_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tauna natunatuna waivinei 4 eḡa tavitavinei, taui God ana riwa i vivieḡai rava awari. ");
INSERT INTO wed_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Aupom vomaḡaui i kwa, kerisiana wavana Agabas, tauna nanare God riwana i vivieḡai, Judeaei i ḡairai au Caesarea. ");
INSERT INTO wed_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ma i nei awariai da Paul ana tairoro i vaia ma tauna urana ma aena i raḡina-melei ma i riwa i pa, “Arua Vivivireina e ririwa, da Jew babadai wei tairorona taniwagana wenanare ina raḡini, ma Jentail au urai ina terei.” ");
INSERT INTO wed_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Maranai wei riwana a nonori, tauai kerisiana ḡelaui maiteni Paul a vibaḡana-guratei, da avena ita nae au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Wate i pa, “Aiwai aubaina o vivitouana ma orau o viviapoapoeni! Tau a vokaukaua nonoa da ina raḡiniu, wate eḡa lamna ava ma ina viraḡeniu au Jerusalem, Bada Iesu a vovotaḡotaḡoi aubaina.” ");
INSERT INTO wed_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tauai a viviḡaei ma eḡa tagotagogina da nuanuana ata sinavirai lamna aubaina riwanana a voterei ma a riwa a pa, “Bada ana ḡoanei nanare ina tupua.” ");
INSERT INTO wed_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wei au murina a vokaukaua ma a vomairi au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kerisiana ḡelaui mai Caesarea I naielai Nason ana au numa ma kampa a mae. Tauna oroto Saiprasiei, ma Iesu votaḡona i vikareni maranaina rava vouvounai i vikarei da Iesu Riwana Aiaina i rarau-gugulei. ");
INSERT INTO wed_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Maranai au Jerusalem a ḡeta kerisiana ana nuaiaii i nebelelai. ");
INSERT INTO wed_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Maratom ḡela Paul maiteni a nae da James a raugenari, dogadogara anatapui kampa. ");
INSERT INTO wed_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul taui i viegualauei ma ana au vaḡai God aiwai i kaukauei Jentail awari anatapuna taui i pariverei. ");
INSERT INTO wed_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Maranaina wei riwai i nonori, taui God i voepaepai ma Paul i riwa i pa, “Turaiai u aramanei mai Jew ai maḡa tausan nanare weka Iesu e vivitumaḡanei, ma God ana tarawatu e vovotaḡo-kauei. ");
INSERT INTO wed_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wate rava Jew kerisiana weka au Jerusalem am kaua i vibenabenaei, da tam Jew Jentail maiteni e mamae e viararamani da Moses ana tarawatu ina gedugeduaiei. Ma u riwei da natunatui ini eḡa ina bori ma ai kaua ḡelaui eḡa ina votaḡotaḡoi. ");
INSERT INTO wed_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Taui i aramanei da tam u ḡetai, Marina aiwai tana kauei? ");
INSERT INTO wed_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Aiwai a ririwemi ona kauei. Au nelara 4, taui parivainuaḡana bagibagina God awarina i kauei. ");
INSERT INTO wed_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ma taravaini ma ona nae au Tempol ma ona viaiaina-melemi ma ma vimaia da taui ai viaiaina pulona ina kauei. Anina ma taui kolai ina ḡari ma rava anatapui ina aramanei da tam Moses ana tarawatu anina e vovotaḡotaḡoi, ma babani au naona lamna anatapuna moru kaua. ");
INSERT INTO wed_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ma Jentail marina i vivitumaḡana aubaii pepa a girumi ma wenanare a riwei, sia e pulopuloei kokoitau awarii eḡa ina ani, Tara eḡa ina umai, Rava ḡamoḡamo uai e kikiki tarai eḡa ita toi-tawanana, eḡa ona ani. Eḡa ona viawawana labalababa.” ");
INSERT INTO wed_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Anina ma marana i tom Paul nai nelarai 4 maiteni i viaina-melei God au matana. Muriai Paul i rui Tempol au orana ma i vinolanola pirisi awarii da mara aiwai taui ai viaiaina ina voterei. Ma maranaina pulo ita terei taui tagotagogi ava aubai. ");
INSERT INTO wed_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","29","Ma aupom 7 aburuna ava da ita kwa ma Jew ḡelaui au Eisia provins maemae taui Paul i ʼnanai Tempol au orana. Au naonei taui Paul i ʼnanai oroto Ephesusei wavana Trophimus maiteni, au taon i bababara ma i notai da tauna Trophimus i ruiei Tempol au orana. Taui Paul i vojijini ma i garara i pa, “Nelara mai Israel ona nei, ona voaguiai! Wei orotona dobu anatapuna e nenaeni ma rava anatapui e viviararamani da mai Jew ma ata tarawatu ma Tempol i parivirevirei. Tauna Jentail i neiai gabuna au vivivireina ma i tuvaidoedoei God au matana!” ");
INSERT INTO wed_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ma rava anatapui i nonori da au Tempol viḡaiḡaiawa i tupua ma anatapui kampa i ruba. Ma Paul i vojijini ma i taina-opunei au doa ma Tempol metaetana i gudui. ");
INSERT INTO wed_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Maranai taui Paul viraḡenana i kaukauei, Mai Rome sorodia ai bada ḡaeḡaena i nonori da viḡaiḡaiawa ḡaeḡaena i tupua au Tempol. ");
INSERT INTO wed_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Tauna laḡilaḡina ana sorodia ma ai babada i vaini ma i ruba kampa, maranai rava taui i ʼnanai, Taui Paul vunuana i voterei. ");
INSERT INTO wed_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Sorodia ai bada i nei Paul awarina da i vojijini ma ana sorodia ruaḡa i riwei da seinei Paul urana au urai i pani jijini. Anina ma tauna patara i vitara-virevirei i pa, “Wei aiai orotona? Aiwai i kauei?” ");
INSERT INTO wed_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Patara au orana rava ḡelaui babani tagogi i gararei, ma rava ḡelaui babani tapuna i gararei. Rava were da nare i garagarara da sorodia ai bada menanare ita nelaḡai gaiawa karena aiwai, lamna aubaina ana sorodia i egari da Paul ita naiei, ai au bareki. ");
INSERT INTO wed_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Maranai Paul bareki tetena i tutuḡereḡerei, patara i ḡaiawa guratana aubaina sorodia Paul i voepai da i avarai da ita gagaloei. ");
INSERT INTO wed_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Patara amapo da taui i vovotaḡotaḡoi ma i garagarara i pa, “Ona viraḡeni, ona viraḡeni!” ");
INSERT INTO wed_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Maranai taui aburuna ava da au bareki ita rui, Paul Greekei sorodia ai bada i riwei i pa, “Anina bo eḡa da awarim ata babani?” Ma tauna i auepai ma i riwa i pa, “Tam Greek u aramanei bo? ");
INSERT INTO wed_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tau a notai da tam Egyptei, rorova ai babada u viḡaviei, Ma rava 4,000 orai potapotai u opunei au mutulua, Tam nai ravana bo?” ");
INSERT INTO wed_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul i paribelana i pa, “Eḡa! Tau Jew ei, au taon Tarsus a tupua, au Silisia provins, a vivibaḡaim da rava awari ana babani.” ");
INSERT INTO wed_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tauna i vianina ma Paul au tete i mairi. Tauna urana i voepai da patara garara i voterei. Maranai taui i genuana, Paul taui awarii ai ponanei i babani i pa. ");
INSERT INTO wed_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Amamau ma varevareiu, ona rautaniḡaneu ma ana viatataiemi da tau eḡa aiwai ata kauana-boai.” ");
INSERT INTO wed_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Maranai patarana Paul i nonori da taui ai ponei i bababani, taui i genuana ma i rautaniḡana. ");
INSERT INTO wed_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","I riwa: Tau Jew ei, Tarsus au Silisia provins a tupua wate weka au Jerusalem a rata ma a giruma. Amamata ai tarawatu a girumei ma au tauviararamana Gamaliel. A ḡoana-guratei da God ata voepaepa-kauei me taumi anatapumi nanare. ");
INSERT INTO wed_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tau Iesu ana etanai tauvotaḡotaḡoina a rau-iviapoapoelei da ḡelaui iʼraḡe. Nelara ma waivine a pani ma au numa panipani a tawana-ruiei. ");
INSERT INTO wed_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pirisi ḡeḡetelarana ana boru ḡeḡetelarana maiteni i aramanei da tau a ririwa kaua. Taui ai vianina pepana i vereu da ai rava au Damaskas ata verei ma a nae au Damaskas da kerisiana ata pani ma a neiai da kovoḡa ita vaia weka au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Aubenai Damaskas a tuḡereḡerei ma maratagogi lalaina gamrina ḡaeḡaena marei i ḡairai da i tunuiai. ");
INSERT INTO wed_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","A peu au doa ma pona a nonori i pa, “Saul! Saul! Aiwai aubaina e rarau-iviapoapoeleu?” ");
INSERT INTO wed_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tau a paribelei, “Bada tam aiai?” Tauna i paribelei, “Iesu Nasaretei e rarau-iviapoapoelei.” ");
INSERT INTO wed_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Rava maiteni a nenae lalalaina i ʼnanai wate babani eḡa ita nonori. ");
INSERT INTO wed_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","A paridadana a pa, “Bada Aiwai ana kauei?” Ma Tauna i riwa i pa, “Ma vomairi ma nae au Damaskas. Kampa rava am nola ina pariverem.” ");
INSERT INTO wed_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Lalalaina gamrina i rata guratana ma matau i kamoi da eḡa ata inainana. Ma tauvigwanigwaniana au urai i voa ma i naieu au Damaskas. ");
INSERT INTO wed_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Oroto wavana Ananias kampa i mae tauna God i voepaepai ma ana tarawatu i vovojijina-nonoei. Mai Jew tauna i vivirana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","I nei da au ririvau i mairi ma i riwa, “Vareiu Saul ma inana me!” Nai marana a inana me. ");
INSERT INTO wed_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Anina ma i riwa, “Amamata ai God i rautanim, da ana ḡoana ma aramanei, ana Taunola Jijimanina - matamei ma inanai, ma riwana taniḡamei ma nonori. ");
INSERT INTO wed_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Aiwai u inainanai ma u nononori ma vimatematei rava anatapui awarii. ");
INSERT INTO wed_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Marina aiwai e paipaini! Tauai ana babataitoim ma Bada awarina ma raupari da am ḡoʼapoapoei ina oḡa-tawanei.” ");
INSERT INTO wed_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Anina ma a nae au Jerusalem. Au Tempol a raraupari ma matauei kaua a inanai. ");
INSERT INTO wed_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","A inanai Bada awariu i bababani i pa, “Rava weka am jima tau aubaiu eḡa nonorana ita ḡoeḡoei. Laḡilaḡina Jerusalem ma opu-tawanei.” ");
INSERT INTO wed_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Wate tau a paribelei, “Bada wei ravai i aramanei da pari numai a nepai da kerisiana a vunui ma a pani-naiei. ");
INSERT INTO wed_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma maranai am peroveta Stephen tarana i toi, tau kampa a maimairi ma ana iraḡe a vianinei ma ḡaima tautawanai ai gara a paipaini.” ");
INSERT INTO wed_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ma Bada i riweu, “Ma nae a paripari-tawanem aueia Jentail awarii.” ");
INSERT INTO wed_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Patarana Paul i rarautaniḡanei ma maranai wei babanina i kauei taui i meji guratana ma i vigaragararei i pa, “Ona viraḡena-tawanei, eḡa ina mae!” ");
INSERT INTO wed_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Taui i vigaragararei, ai kwama i kwajikwajiei ma pokau i tawatawanei awarina. ");
INSERT INTO wed_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ma sorodia ai bada sorodia i egari da Paul i naiei ai au bareki. Ma i riwei da Paul ita wipi da ita vieḡa aiwai aubaina ana rava amloi i ḡaiḡai ma awarina i garagarara. ");
INSERT INTO wed_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ma urana ruaḡa i terepai au aidamo ma i raḡiraḡini da ita wipi ma Paul sorodia ai bada i riwei i pa, “Tau Rome-ei, Eḡa ota etareu ma o vunuvunu-labalababaiu. Lamna menanare?” ");
INSERT INTO wed_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Maranai sorodia ai bada wei i nonori ma i nae da ai bada ḡaeḡaena i pariverei. Ma tauna i vitara-virevirei i pa, “Aiwai e kaukauei? Wei ravana Rome-ei!” ");
INSERT INTO wed_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Sorodia ai bada i nae Paul awarina ma i paridadanei, “Ma riweu! Riwa kaua da tam Rome-ei bo?” Ma Paul i paribelei, “Ee, lamna riwa kaua!” ");
INSERT INTO wed_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Sorodia ai bada Paul i riwei, “Tau mane ḡaeḡaena Rome gabemanina a verei da a vimai Rome.” Paul tauna i riwei, “Tau a tupua da Rome-ei.” ");
INSERT INTO wed_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sorodia i ḡoei da Paul ita etarei wate maratagogi ita ḡori-melei. Ai bada ita ḡori ma i rovo-kaukaua maranai i aramanei da i kauana-boai da Paul, Rome-ei seinei i pani. ");
INSERT INTO wed_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Au maratomna sorodia ai bada i ḡoei da ita aramana-kauei mai Jew ai viwavu aiwai Paul awarina. Ma lamna aubaina Paul ana seini i votawatawanei ma i opunei boru ḡetelarana au naona i vimairini. ");
INSERT INTO wed_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul boru ḡeḡetelarana i ʼnana-jijini ma i riwa, “Varevareiu tau au nola God awarina i jijimana ma orau aiaina da wei paratana.” ");
INSERT INTO wed_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ma Pirisi ḡeḡetelarana Ananias rava ḡelauna Paul au ririvana i maimairi i egari da Paul i raunavanavai. ");
INSERT INTO wed_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ma Paul Ananias i riwei, “God ina raunavanavaim, tam morumorum! Moses ana tarawatuei e rarauetareu wate maranai am rava u riwei da i raunavanavaiu tam tarawatu u viaigai.” ");
INSERT INTO wed_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Taui Paul au ḡereḡerena i maimairi Paul i riwei, “Aiwai aubaina God ana Pirisi Ḡetelarana e vivijiboḡi?” ");
INSERT INTO wed_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul i paribelei, “Varevareiu eḡa ata aramanei da tauna God ana Pirisi ḡeḡetelarana. Au buka i terei da Eḡa God ana taunola ma parivai-apoapoeni.” ");
INSERT INTO wed_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Anina ma Paul i ʼnanai da Sadusi ma Pharisi ḡelaui kampa ma ponana i rata ma i riwa, “Varevareiu tau Pharisi, amau maiteni Pharisi. A vivitumaḡana da God rava iraḡelei ina vovaimairini wei lamna aubaina taumi o etaetareu!” ");
INSERT INTO wed_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Maranai wei i latoni Pharisi ma Sadusi viparipariniḡai i raukarei ma boru i kai da ruaḡa. ");
INSERT INTO wed_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Aubaina Sadusi e ririwa da rava e irairaḡe lamna eḡa ita vovomairi me, ma anela da aruarua eḡa ita vivitumaḡanei, wate Pharisi wei anatapui e vivitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ḡaiawa ḡaeḡaena i tupua ma tarawatu babadai ḡelaui taui Pharisi, i vomairi ma i babani guratana i pa, “Tauai eḡa aiwai apoapoena ata inanai wei ravana awarina! Mepa da anela bo Bada Aruana tauna awarina i babani?” ");
INSERT INTO wed_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Viḡaiḡaiawa ḡaeḡaena i tupua ma sorodia ai bada i rovo mepa da rava Paul ina viaisikasikai ma sorodia i egari da i rui ma Paul i taravaina-opunei ma ina naieiau bareki. ");
INSERT INTO wed_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ma waguvarai ḡelauna, Bada Paul au ririvana i mairi ma i riwei, “Tepam ina tora! Me aubaiu u jima au Jerusalem nanare aubaiu au Rome ma jima.” ");
INSERT INTO wed_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ubaubanai mai Jew ḡelaui i vitagogiei ma i viogatara ma i parivainuaḡana da eḡa ina am bo ina uma da Paul ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nelara 40 nanare i vianina da Paul ina viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Taui i nae pirisi babadai ma dogadogara awarii ma i riwei, “Tauai parivainuaḡana bagibagina a kauei da eḡa ana am da Paul ana viraḡeni.” ");
INSERT INTO wed_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Taumi Boru ḡeḡetelarana maiteni ona moru ma riwa ona pari-tawanei sorodia badana awarina da Paul ina neiai ma ona vitara-virevirei da riwa kaua ona vaia. Tauai ana vipaipai da ana viraḡeni muriai da weka ina ḡetai. ");
INSERT INTO wed_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Wate maranai Paul avuna wei ogatarana i nonori ma i nae sorodia ai au bareki ma Paul i pariverei. ");
INSERT INTO wed_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ma Paul sorodia badana i ḡoreiai ma i riwei, “Wei laragana laḡilaḡina ma naiei ami bada awarina da ana riwa ina riwei.” ");
INSERT INTO wed_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ma i naiei ai bada ḡaeḡaena awarina ma i riwei, “Panipani wavana Paul riwa i paritawanei awariu ma i riweu da wei laragana ata neiai awarim aubaina am riwa awarina.” ");
INSERT INTO wed_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Sorodia ai bada ḡaeḡaena laraga i vinimavoai ma i maeria ma i paridadanei, “Am riwa aiwai ma riweu?” ");
INSERT INTO wed_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","I riwa, “Mai Jew i riwa da ita vibaḡaim da au maratom Paul uta naiei ai au Boru ḡeḡetelarana, Wei anatapuna moru. ");
INSERT INTO wed_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Wate eḡa ma rautaniḡanei aubaina rava 40 nanare pota e paipaini da ina viraḡeni. Taui i vioga da eḡa ina am da Paul ina viraḡeni. Taui i vokaukaua ma am vianina ava e paipaini.” ");
INSERT INTO wed_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ma bada laraga i riwei da eḡa aiai ina riwei ma i paritawanei. ");
INSERT INTO wed_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Anina ma sorodia ai bada ḡaeḡaena babada ruaḡa i ḡoreiai ma i riwei, i pa, “Sorodia sod ravai 200, aiera ravai 200 ma hos ravai 70 ma vaia ma ona vokaukaua da waguvarai 9 oklok ona vomairi. ");
INSERT INTO wed_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Hos biaḡa ona vaia Paul aubaina da aiaina ona naiei gavena Felix awarina au Caesarea.” ");
INSERT INTO wed_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ma sorodia ai bada pepa wenanare i girumi: ");
INSERT INTO wed_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Tau Claudius Lisias, a girugiruma awarim au bada vinualaulaunam, Gavena Felix. Egualau. ");
INSERT INTO wed_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mai Jew wei orotona i vojijini ma ita viraḡeni, wate maranai a nonori da tauna Rome-ei ma lamna aubaina au sorodia maiteni a opu da au urai a vaitawanei. ");
INSERT INTO wed_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","A ḡoei da ata aramanei ana apoapoe aiwai, da ata naiei ai Boru ḡeḡetelerana awarina. ");
INSERT INTO wed_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ma a nelaḡai da viwavuna lamna tauiava ai tumaḡana kauai ma Rome ana tarawatuei lamna tauna eḡa aiwai apoapoena ita kauei da ata viraḡeni bo ata pani. ");
INSERT INTO wed_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Maranai riwana a vaia da mai Jew i ḡoei da govagovaḡanei tauna ita vunui. Lamna maratagogi a paritawanei awarim, ma nanare tauviwavu a riwana-guratei da kampa ina ḡetai da ai viwavu ina kauei. ");
INSERT INTO wed_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ma sorodia ai babada i ririweia nanare i kauei ma waguvarai Paul i taravaini ma i naiei da au taon Antipatris i ḡeta. ");
INSERT INTO wed_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Au maratomna aiera ma sod sorodiai i naeme au Jerusalem ma hosi sorodia Paul i naei au Caesarea. ");
INSERT INTO wed_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Maranai hosi sorodiai au Caesarea i ḡeta pepana ma Paul gavena i veredamanei au urana. ");
INSERT INTO wed_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gavena pepa i ʼavi ma Paul i paridadanei metauna provins-na u tupua ma i riwa, “Silisia.” ");
INSERT INTO wed_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Gavena i riwa i pa, “Am etara ana nonori maranai am tauviwavu ina ḡetai.” Ma sorodia i naiei Herod numa i voavoaiana da ita inana-vaitetei. ");
INSERT INTO wed_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Aupom 5 au murina Pirisi ḡeḡetelarana Ananias ma dogadogara i ḡaira au Caesarea ai taurauetara wavana Tertelus maiteni. ");
INSERT INTO wed_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ma Paul i ḡoreiai gabemani au naona. Ma Tertelus i vomairi ma viwavuna i vikarei: Au bada Felix vinualaulaunam, Am vibadanei ta mae ubauba ma ata nota eḡa aiwai. Ma kaua vouii ma aiaii u kaukauei ata dobu voana aubaina i voagu-kaueta. ");
INSERT INTO wed_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Anatapuiai mepamepa a mamae a vinuaiai kaua tam awarim. ");
INSERT INTO wed_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Wate eḡa ata ḡoei da ana visina-viraviraim. Ma lamna aubaina a ḡoeḡoei da uta rautaniḡaneu mara aburuna ava. ");
INSERT INTO wed_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tauai a nelaḡai da wei ravana lamna orana potapotana ma viḡaiḡaiawa tauvikareina mai Jew awarii dobu au anatapuna. Tauna boru vouna e ḡoreḡorei mai Nasaret ai bada. ");
INSERT INTO wed_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Taui i ḡoei da Tempol maiteni ita tuvaidoedoei ma lamna aubaina a pani. ");
INSERT INTO wed_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ma rauetarei ma ma nelaḡai da ai viwavu lamna anatapui riwa kaua. ");
INSERT INTO wed_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ma mai Jew Tertelus au murina i mairi ma i riwa, “Wei babani anatapui riwa kaua!” ");
INSERT INTO wed_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Anina ma Gavena Felix Paul i raumotemotei da ita babani. Paul babani i vikarei i pa: Au bada vinualaulaunam, a aramanei da tam madeḡa biaḡa wei dobuna ai taurauetara lamna aubaina tau ana nuaubau ana babani aubaiu. ");
INSERT INTO wed_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Am rava ina riwem da tau pom ota aupom 12 nanare a ḡeta memei au Jerusalem da Bada ata voepaepai. ");
INSERT INTO wed_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Au tauviwavu eḡa ita nelaḡaiu ata viḡaiḡaiawa au Tempol bo au boru-numana bo mepa nanare au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma ai viwavu tau awariu menanare tana aramanei da lamna riwa kaua? ");
INSERT INTO wed_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Wate riwa kaua da tau amamata ai God a voepaepai ma Bada Iesu ana etanai, a votaḡotaḡoi ma taui e ririwa da wei lamna taparoro morumoruna. Wate nanare Moses tarawatu i girugirumi ma God ana peroveta nununai i girugirumia anatapuna a vivitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Tau God awarina a vitumaḡana guratana me ravai nanare, da tauna muriai rava anatapui iraḡelei ina vilawana-melei, ravai aiaii ma rava apoapoei. ");
INSERT INTO wed_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Lamna aubaina a kaukauana guratei da orau ina ai rava ma Bada awarii. ");
INSERT INTO wed_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Jerusalem a netawanei madeḡa biaḡa i kwa ma pom ota a nememei da molamolakai ata puloi ma pulo ata kauei God awarina. ");
INSERT INTO wed_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tau aiaiu, maranaina i nelaḡaiu au Tempol viaina pulona a kaukauei. Eḡa patara maiteni ma eḡa visinaviravira. ");
INSERT INTO wed_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Wate mai Jew ḡelaui Eisia provinsei i nei kampa. Taui mepa marina! Ita nei au naom da ai viwavu ita terei. ");
INSERT INTO wed_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bo babada weka ita riweta au apoapoe aiwai maranai boru ḡeḡetelarana au naona a mairi. ");
INSERT INTO wed_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Wate mepa da maratagogi awarii a garara a pa, “A vitumaḡana da God rava anatapui iraḡelei ina vovaimairini! Lamna aubaina tau weka a maimairi.” ");
INSERT INTO wed_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix tauna Bada Iesu ana Etanai riwana i aramana-kauei, boru i gudui ma i riwa, “Maranai sorodia ai bada Claudius Lisias ina nei, ma ina paribelem.” ");
INSERT INTO wed_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ma sorodia ai bada i egari da Paul ita inana-vaitetei ma ita voterei da ita bababara ma ana rava ita nei da ita raraugenari. ");
INSERT INTO wed_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Aupom biaḡa au murina Felix awana Drusila maiteni i nei. Drusila lamna wavine Jew ei. Ma riwa i paritawanei da Paul i neiai, ma rava ai tumaḡana Iesu Keriso awarina i babaniei ma Felix i rautaniḡana. ");
INSERT INTO wed_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Wate maranai Paul babani i vikarei da God ana ḡoana, da rava lawana aiaina ma jijimanina ina maeni, ma erawa kauai ma ḡoʼapoapoe ina geduaiei, aubaina mara e nenei maranai rava anatapui ina etarei. Felix wei babanina i nonori tauna i rovo ma Paul i riwei, “Ma nae! Ma maranai ana ḡoem lamna ana kwatuem.” ");
INSERT INTO wed_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ma Felix i ḡoeḡoei da Paul tauna manelei ita gwalai ma lamna aubaina mara i maḡa i raukwatuei ma awarina i babani. ");
INSERT INTO wed_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Madeḡa ruaḡa au murina Felix i rautom ma ana gabu Posias Festus i vaia. Felix i ḡoei da wavana ita ai mai Jew awarii lamna aubaina Paul au numa panipani i votere-tawanei. ");
INSERT INTO wed_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus i ḡeta au Caesarea da ana nola ita vikarei ma aupom vitonuina i ḡae au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Weka pirisi ḡeḡetelarana ma dogadogara Festus i nebelei ma ai viwavu Paul awarina tauna i verei. ");
INSERT INTO wed_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ma Festus i vibaḡai da ita voagui da Paul ita paritawanei au Jerusalem. Taui ava i vioga da Paul au etanai ita viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Wate Festus i paribelei i pa, “Paul au deri au Caesarea ma tau a ḡaiḡaira me kampa aupom ruaḡa au murina. ");
INSERT INTO wed_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mepa da Paul aiwai i kauana-boai lamna ami Babada maiteni ana ḡaira da kampa ami viwavu ina terei.” ");
INSERT INTO wed_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Aupom 8 da 10 nanare au murina Festus i ḡaira me au Caesarea ma maratomna au numaetara i kiala ma ana sorodia i eḡara da Paul ita ruieiai au naona. ");
INSERT INTO wed_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Maranai Paul i ruieiai, ma Jew babadai Jerusalem ei i ḡairai i nei awari ma ina viwavui, kaua maḡamaḡaui apoapoei aubaii. Wate taui ai viwavu anatapui anona eḡa. ");
INSERT INTO wed_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paul wei viwavui i vinua-nainei ma i pa, “Tau eḡa aiwai apoapoena ata kauei mai Jew ai tarawatu awarina bo ai Tempol awarina bo Caesar awarina.” ");
INSERT INTO wed_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Wate Festus i ḡoei da mai Jew ita vinuaiaini lamna aubaina Paul i paridadanei i pa, “E ḡoeḡoei bo eḡa da tana ḡae au Jerusalem ma etara?” ");
INSERT INTO wed_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul i riwa, “Tau marina Caesar ana au etara gabuna a maimairi, weka ina etareu. Tam u aramana-kauei da tau eḡa aiwai apoapoena ata kauei mai Jew awarii. ");
INSERT INTO wed_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Wate mepa da aiwai apoapoena a kauei lamna ma viraḡeniu. Tau eḡa iraḡe ata rovoei. Wate mepa da wei lamna viwavu moru lamna eḡa aiai ana rewapana ita mamae da ina veredamaneu. Tau a vivibaḡa Caesar awarina!” ");
INSERT INTO wed_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus Caesar ana dogadogara ai nota i vaia ma i paribelana i pa, “Tam u vibaḡa Caesar awarina, Anina Caesar awarina ma nae.” ");
INSERT INTO wed_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Aupom biaḡa au murina gulau Agrippa novuna Benisi maiteni i nei au Caesarea da gavena vouna Festus i raugenari da ita viegualauei. ");
INSERT INTO wed_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ma i mae aupom vomaḡauna ma Festus Paul i rarauetara gulau i pariverei i pa, “Felix panipani tagogi weka i voterei. ");
INSERT INTO wed_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ma maranai a nae au Jerusalem mai Jew ai pirisi babadai ma dogadogara ai viwavu i neiai awariu ma i vibaḡaiu da Paul ata viraḡeni. ");
INSERT INTO wed_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","—Ma a riwei da tauai mai Rome ai tarawatu e ririwa da eḡa rava ana kovoḡa labalababai da au naona ana rauetarei. Taui ina ḡetai da ai viwavu taurauetara au naona ina mairi da ina gagaloana-melei. ");
INSERT INTO wed_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Maranai tauviwavu maiteni weka a ḡetai. Tau eḡa ata vipaipai ma maratomna a egara da ravana i neiai da ita etara. ");
INSERT INTO wed_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Tauviwavu i vomairi ma a notai da aiwai apoapoena aubaina ita viwavui wate eḡa. ");
INSERT INTO wed_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Anina kaua biaḡa ava ai taparoro kauaii, ma rava tagogi irairaḡena wavana Iesu i vitarapiriei. Wate Paul e ririwa da Iesu lawalawaina. ");
INSERT INTO wed_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tau nuanuau i raḡaraḡa menanare riwa kaua ana vainei ma Paul a paridadanei da i vianina da maiteni ata ḡae au Jerusalem da kampa ata etarei. ");
INSERT INTO wed_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wate Paul i vibaḡa da Caesar ana viwavu ina rautaniḡanei. Ma sorodia a egari da au numa panipani ina paini da ana paritawanei Caesar awarina.” ");
INSERT INTO wed_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ma Agrippa Festus i riwei, “A ḡoei da ravana ana babani ana rautaniḡanei.” Ma Festus i paribelei, “Anina, au maratom ma rautaniḡanei.” ");
INSERT INTO wed_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Au maratomna gulau Agrippa ma Benisi gulau garai i oteni ma ana gabemani babadai ḡaeḡae maiteni, i arana-ruiei au boru numana. Festus ana sorodia i egari da Paul i ruieiai. ");
INSERT INTO wed_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus i riwa, “Gulau Agrippa ma anatapumi o rieiai weka, wei ravana o inainanai! Tauna mai Jew au Jerusalem ma weka au Caesarea e ḡoeḡoei da ina iraḡe. ");
INSERT INTO wed_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Wate tau a nelaḡai da tauna eḡa aiwai ita kauana-boai da ina iraḡe. Wate i vibaḡa da Caesar tauna ina rauetarei. Lamna aubaina a pariparitawanei Caesar awarina. ");
INSERT INTO wed_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Wate Caesar aiwai ana riwei, eḡa ata aramanei aiwai ana girumi? Lamna aubaina a neiai awarimi ma tam gulau Agrippa maiteni da tana babaniei da nota ona vereu da aiwai ana girumi. ");
INSERT INTO wed_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Aubaina eḡa ita ai da panipani ana paritawanei Caesar awarina ma ana viwavuna eḡa!” ");
INSERT INTO wed_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ma Agrippa Paul i riwei, “A vianinem da ma babani.” Ma Paul urana i voepai ma ana gudu tarana i vikarei ");
INSERT INTO wed_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","i pa: I ai kaua gulau Agrippa da amadodo tam au etara e rarautaniḡanei da Jew babadai ai viwavu awariu ana tere-vaijijimani. ");
INSERT INTO wed_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tau aramanei da tam mai Jew ai giu ma ai paripariḡai u aramanana-kauei. Lamna aubaina a vivibaḡaim da au paribelana ma rautaniḡanana-kauei. ");
INSERT INTO wed_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Mai Jew anatapui au lawana i aramanei, aburu da marina, au dobu oina da au Jerusalem. ");
INSERT INTO wed_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Taui rorova ava i aramaneu ma ina riwem da tau ai boru bagibagina ma piripirina, Pharisi au orana a rui ma tarawatu anatapuna a vojijina-kauei. ");
INSERT INTO wed_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ma marina a vivitumaḡana da God aiwai noinoita i parivainuaḡani ina kauei. Ma lamna aubaina tau weka a maimairi. ");
INSERT INTO wed_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Wei parivai-nuaḡanana ata dam 12 e vipaipaiei da ina nei lamna aubaina ata rava i vipatutu ma marai ma waguvarai God e viviborumei. Au gulau wei vitumaḡanana aubaina mai Jew e viviwavuiu. ");
INSERT INTO wed_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Aiwai aubaina o notanotai da God eḡa tagotagogina da rava iraḡelei ina vovaimairini? ");
INSERT INTO wed_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Tau au naona a notai da aiwai anatapuna ata kauei da Iesu Nasaretei ata viḡaviei. ");
INSERT INTO wed_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma anina lamna a kauei au Jerusalem. Pirisi ḡeḡetelerana babadai pepa i verei ma lamna i vovai-virewapaniu ma kerisiana vivivireii maḡamaḡaui au numa panipani a terei, ma nanare ai iraḡe a vianinei. ");
INSERT INTO wed_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mara maḡamaḡaui boru numai a naeni da kerisiana a vununaiei da ai tumaḡana ita boviei. Amlou i ḡaiḡai kaua da dobu ḡelaui a naeni kerisiana a baibaiei. ");
INSERT INTO wed_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Mara tagogi pirisi babadai au Jerusalem pepa i vereu da rewapana i vereu ma a nae au Damaskas. ");
INSERT INTO wed_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ma aubenai nanare, tau au etanai a nenae ma a inanai, lalalaina marei i ḡairai ma i lalaiai, gamrina madeḡa i ḡetawanei! Au rava maiteni a bababara i lalaiai. ");
INSERT INTO wed_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Anatapuiai a vipeuana au doa ma pona Hebrewei awariu i bababani. I riwa, “Saul, Saul aiwai aubaina e viviḡavieu? Tam e ḡoeḡoei da Tau ma viapoapoeniu wate eḡa da tam e viviapoapoena-melem!” ");
INSERT INTO wed_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ma a paridadana, “Bada tam aiai?” Ma Bada i paribelei, “Tau Iesu, ravana tauna e viviḡaviei. ");
INSERT INTO wed_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Wate ma vomairi. Tau a nei awarim da vaivai ata verem da ma vitaunola Tau aubaiu, ma amadodo aiwai u inanai ma aiwai ana viatataiem, ma vimatamatei rava awarii. ");
INSERT INTO wed_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Tau ana gagaloem am rava mai Israel awarii ma nanare Jentail ravai awari, ma ana paritawanem Jentail awarii, ");
INSERT INTO wed_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","da matai ma vikalai, da ai lawana apoapoe ina voterei ma ina nei au lalalaina, ma Satan ana rewapana ina votere-tawanei ma ina nei God awarina. Tauna ai ḡoʼapoapoe ina nota-tawanei, ma ina taravaini natunatuna rarautanii, ai tumaḡana awariu aubaina.” ");
INSERT INTO wed_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Lamna aubaina Gulau Agrippa, tau riwa marei au inana a inanai a voteletelei. ");
INSERT INTO wed_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Au naona a jima mai Jew awarii au Damaskas ma nanare au Jerusalem ma Judea anatapuna ma muriai Jentail maiteni awarii. A jima da ai ḡoʼapoapoe ina votere-tawanei ma ina mae-tavirei God awarina, ma ai lawana ina vimataira da ai kaua apoapoe i voterei-tawanei. ");
INSERT INTO wed_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Wei babanii aubaina mai Jew au Tempol i vojijiniu ma i ḡoei da ita viraḡeniu. ");
INSERT INTO wed_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Wate God i vilawaniu da marina, ma weka a maimairi da a vimatamata rava muomuoi ma nanare rava ḡaeḡaei awarii. Aiwai a bababaniei lamna peroveta nununai ma Moses i ririweta ina tupua. ");
INSERT INTO wed_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Taui i riwa da tauvilawana Keriso ina vinuapoapoe. Ma tauna ina iraḡe ma ina vinao da ina vomairi me ma wei matairana ina vinolanola da tauna God lalalaina mai Jew ma Jentail aubaii. ");
INSERT INTO wed_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Weka Festus i vionaḡi ma i garara Paul awarina, “Tam u bua! Am aramana i vibuaim!” ");
INSERT INTO wed_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Wate Paul i paribelei, “Au bada Festus tau eḡa ata bua. Tau aiwai a bababaniei lamna riwa kaua ma babani anona. ");
INSERT INTO wed_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wei kaua eḡa govagovaḡana ma aramanei da Gulau Agrippa anatapuna i aramanei, ma lamna aubaina ana tepatorau wei kauai ana babaniei awarina.” ");
INSERT INTO wed_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Paul Gulau Agrippa i riwei i pa, “Peroveta e vivitumaḡanei bo eḡa? A aramanei da nanare!” ");
INSERT INTO wed_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ma Agrippa i paribelei, “U notai da tau laḡilaḡina ma sinaviraiu da ana vikerisiana!” ");
INSERT INTO wed_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul i paribelei, “Laḡilaḡina bo amapo, a raraupari God awarina da tam ma rava anatapui wei au boruna ina tupua-vira me tau nanare wate eḡa sein maiteni.” ");
INSERT INTO wed_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Anina ma gulau ma gavena ma Benisi i vomairi ma i nae. ");
INSERT INTO wed_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ma anatapui i nenae ma i babani vivira ma i vianina i pa, “Wei ravana eḡa aiwai apoapoena ita kauei da tana viraḡeni bo tana pani.” ");
INSERT INTO wed_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ma Agrippa Festus i riwei, “Mepa da eḡa ita vibaḡa ḡae Caesar awarina, lamna marina tata rupeni.” ");
INSERT INTO wed_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Festus mara i tereterei i ḡetai da tauai ata nae au Rome. Paul ma tau ma panipani ḡelaui maiteni au waga a geru ma a vaḡai Rome aubaina. Rome ai sorodia badana wavana Julius au urana i terelai. Tauna Caesar ana sorodia vinevinena. ");
INSERT INTO wed_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Waga Adaramitei i nei da a geru ma wagana i ḡota-nae au Eisia provins gerana. Oroto wavana Aristakas ana dobu Thesalonika au Masedonia provins tauna maiteni i geru. ");
INSERT INTO wed_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Au maratomna au Sidon taon a ḡota, Julius ivina i ai Paul awarina ma i voterei da i opu au gera da ana rava ita raugenari ma ana ḡoana aiwai ita vibaḡei. ");
INSERT INTO wed_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Muriai wagei a opu da a nenae ma ive i verau-matamataniai ma lamna aubaina bonabona au Saipras ma dobu ḡaeḡaena au pouna au mulaḡina ambori. ");
INSERT INTO wed_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ma boga ḡaeḡaena a bori da Silisia provins da Pamphilia provins geraii a voterei da au Maira taon a rui au Lisia provins ");
INSERT INTO wed_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Au Maira taon kampa sorodia badana mai Egypt ai waga Alexandriei i nenae au Italy kampa i vigeruiai. ");
INSERT INTO wed_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ma aupom maḡamaḡaui nuatauai a ruba ma a voia guratana da Cinidus taon a tuḡereḡerei wate ive i verau-matamataniai da kampa waga a virai da Crete bonabonana ma mutu Samone au poui au mulaḡina a nae. ");
INSERT INTO wed_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ma kampa nuatauai bonabona Crete gerana a naeni aubaina mara i apoapoe ma a ḡeta dobu e ḡoreḡorei U Aiaina, Lasea taon au ḡereḡerena. ");
INSERT INTO wed_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Mara ḡaeḡaena a vine-boai au vaḡai ma Rupena Ujina marana boiboḡi i kwa, marina lamna ive ma rabama ai mara ma boga babarana i vinirovorovo. ");
INSERT INTO wed_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Ma Paul i riwa, “Nelara, malana a vaivaia da ata vaḡai ina apoapoe kaua ma waga ma purapura tana vine-boa-pai. Ata lawana maiteni tana vineboai.” ");
INSERT INTO wed_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Wate sorodia ai bada, kapena ana babani i rautaniḡanei ma eḡa Paul da kampa ata mae ma eḡa ata nae. ");
INSERT INTO wed_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Wei gabuna eḡa ita ai wei ivena au marana ma rava maḡamaḡaui i goei da waganei ata nae da Phinix una, Crete au bonabonana da kampa ata mae da bodu ita kwa. Wei u ḡaeḡaena ma mutuii lavarata ma rauanaḡa e vinao-vereverei, da au mulaḡina e mamae. ");
INSERT INTO wed_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Maranai rauanaḡa i vikarei ma waga ravai i notai da marina mara aiaina da ita nae au Phinix una. Ma anika i taini ma Crete bonabona geraei i nae. ");
INSERT INTO wed_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ma eḡa barana ita uama ma kojikojira olei iveiai. ");
INSERT INTO wed_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ive wagana i verau-matamatani ma waga eḡa tagotagogina da ita vobelei ma i voterei da ive waga i avara-opunei. ");
INSERT INTO wed_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Bonabona aburuna Kauda gerana au mulaḡina a ruba ma kampa a voia guratana da dingy a terepai au waga da a ragita-jijini. ");
INSERT INTO wed_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Wei i kauana vorovei ma ḡuravei waga au gabaurina da waga adana i raḡita-kwaviviroi. Taui i rovo mepa da au maratete ina amḡaena au Syrtis, Libya au gerana. Lamna aubaina ḡuravei ai da kuka, i raḡita-tagogiei ma au boga i viorereni da waga ita bibi. Ma i voterei da kojikojira waga i avara-naiei. ");
INSERT INTO wed_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Maratomna kojikojirana i rarau-guratanelei da purapura ḡelaui au boga a viorereni. ");
INSERT INTO wed_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Aupom vitonuina taui waga purapurai i viorereni au boga. ");
INSERT INTO wed_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kojikojira i ruba da aupom biaḡa da madeḡa ma ubona i purui. Ravai ai nota i kwa. ");
INSERT INTO wed_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Wei au marana rava au waga am i kauana-avei, anina ma Paul i vomairi ma taui i riwei, “Nelara ota rautaniḡaneu ma Crete eḡa tata oputawanei, amapo waga eḡa tata viapoapoeni ma ata purapura eḡa tata vineboai. ");
INSERT INTO wed_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Wate a ririwana-guratemi da eḡa orami ina peu! Aubaina avena da waga ina monu wate eḡa ina iraḡe. ");
INSERT INTO wed_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","God lamna tau au Bada ma ana taunola tau. Waguvarai God ana anela i paritawaneiai awariu. ");
INSERT INTO wed_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ma i riwa, ‘Eḡa ma rovo! Tam anina da Caesar au naona ma etara! Ma ḡelauna lamna God ana nuavaina maemaena rava anatapui maiteni e vaḡavaḡai ina lawana.’ ");
INSERT INTO wed_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Lamna aubaina tepami ina tora! Aubaina tau God a vivitumaḡanei ma menanare i ririweia nanarena ina tupua. ");
INSERT INTO wed_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Wate tauta au maratete tana amḡaena.” ");
INSERT INTO wed_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kojikojira i avara-naielai au Mediteranean Bogana da aupom 14 i kwa ma nubautuva waga ravai malana i vaia da taui gera i tuḡereḡerei. ");
INSERT INTO wed_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ma barawa au giana ḡaima i raḡini ma au boga i tawanana-ḡairei da topa ana gabinou ita aramanei. Ma i aramanei da 40 meter ma i mae aburuna ma i raudadana-melei lamna marina 30 meter. ");
INSERT INTO wed_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ma taui i rovo mepa da rabama waga au kira ina viairikarikai lamna aubaina waga au ipuna anika 4 i tawana ḡairei ma i vipaipai da mara ina tom tawanana. ");
INSERT INTO wed_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ma waga ravai ai kaua i kaukauei da ita ruba-govaḡa. Ma i vioga da dingiei ita opu waga au naona da anika ita dubara-naiei, ma lamna aubaina dingy i teretere-ḡairei au boga, ");
INSERT INTO wed_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Wate Paul sorodia ai bada maiteni i riwei, “Mepa da waga ravai ina rubatawanemi lamna anatapumi ona iraḡe.” ");
INSERT INTO wed_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ma sorodia dingy ḡuravana i borituini ma dingy kwakwavina i peu au boga ma i avara-naiei. ");
INSERT INTO wed_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ma maratomtomai Paul rava anatapui i egari da ita am, i pa, “Taumi marina aupom 14 rovo i kauemi ma eḡa ota am.” ");
INSERT INTO wed_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","“Tau a vivibaḡa-guratemi da ona am da ona virewapana, eḡa aiai tagogi ina iraḡe.” ");
INSERT INTO wed_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Paul i babani vorovei ma au matai palawa i vaia, Bada i viegualauei ma i vogimai ma i ani. ");
INSERT INTO wed_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ma rava anatapui inanai ma orai i bagibagi ma am i vikarei. ");
INSERT INTO wed_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tauai anatapuiai 276 au waga. ");
INSERT INTO wed_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ma rava anatapui i am da i am-iaua. Ma witi baikei au boga i viorereni da waga ita votelatelai da au gera ita ḡota da avena ita amḡaina. ");
INSERT INTO wed_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Maranai mara i tom tawanana taui dobu i ʼnanai wate gerana eḡa ita aramanei, wate U inanai da gerana aiaina ma i notai da gerana aiaina da waga kampa ita viḡaeni. ");
INSERT INTO wed_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Anina ma anika ḡuravai i viaituituini, ma labilabi i tere-ḡairei, ma waga au naona kuka voaburunei i votawatawanei ma gera aubaina i ruba. ");
INSERT INTO wed_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Wate waga au maratete i amḡaena da i tapaiei, ma rabama waga ipuna i viairikarikai. ");
INSERT INTO wed_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sorodia i ḡoei da panipani ita viraḡeni, da avena ita toa-ḡaira au gera ma ita viruberubei. ");
INSERT INTO wed_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Wate sorodia ai bada i ḡoei da Paul ita vilawani ma i viḡaei, anina ma ai viogatara eḡa ita kauei. Ma taui aiavoi toa i aramanei i egari da i viauepa au boga ma i toa-ḡaira au gera. ");
INSERT INTO wed_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ma ḡelaui aiwai da i tenatenam i vidauei. Ma nanare anatapui lawalawaii au gera i ḡota. ");
INSERT INTO wed_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Maranai a ḡota au gera ma a aramanei da tauai au Malta bonabonana. ");
INSERT INTO wed_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Dobuna ravai i nebelelai ma ivii i ai kaua awariai. Garewa atuna i vikarei ma i ubauba, ma taui au gera ai i viviri. ");
INSERT INTO wed_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Ma Paul ai ragorago i ḡuna da ai au tepana i tereterei ma mota ḡaiḡaiawana ai bolana malana i vaia da i opui ma Paul nimana i ani. ");
INSERT INTO wed_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Dobuna ravai i ʼnanai da motana Paul au nimana i dawedawe ma i pari-ararava, “Wei ravana lamna tauviraḡena ma eḡa ita monu wate ata god e ririwa da tauna eḡa ina lawana.” ");
INSERT INTO wed_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Wate Paul motana i viaikwajiei da ai au menamenana i rauei ma tauna eḡa ita kero. ");
INSERT INTO wed_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Rava i vipaipai da Paul nimana ita dodo bo ita peu da ita iraḡe. Wate maranai i vipaipai guratana ma i ʼnanai da tauna anina, taui ai nota i virai ma i riwa da tauna god ḡelauna. ");
INSERT INTO wed_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Au gerana a ḡotaḡota - lana au ḡereḡerena lamna dobuna badana Publius ana wapu ḡaeḡaena. Tauna i taravainiai ma i paina-kauelai da aupom tonuḡa ");
INSERT INTO wed_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publius amana i doria manawa ruba ma iniḡuḡura i vaia da i matamatave, Paul i rui inanana aubaina ma urana au tepana i terei ma i raupariei ma i vilawani. ");
INSERT INTO wed_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Anina ma rava anatapui doridoriai au bonabona i nei ma i vilawani. ");
INSERT INTO wed_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","11","Kampa mai Malta maiteni a mae nawaravi tonuḡa. Ma ravai i voagu-kauelai ma maranai ata vomairi, ai ḡoana vaḡai aubaina anatapuna i verelai. Ma waga ḡelauna a gerui lamna mai Alexandria ai waga bodu aubaina kampa i mae. Waga au naona lamna ai god ruaḡa kokoitaui i tai. ");
INSERT INTO wed_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kampa ma a amkuka-nae da au Sairakius a ḡota ma a mae aupom tonuḡa ");
INSERT INTO wed_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kampa da ambori damana au Regium ma maratomna rauanaḡa i wanabauni ma amkuka ma geraei a ruba da maratom ḡela au Puteoli a ḡota. ");
INSERT INTO wed_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kerisiana kampa a nelaḡai ma i riwelai da maiteni a mae wiki tagogi. Anina ma a babara-nae da au Rome taon a ḡeta. ");
INSERT INTO wed_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kerisiana au Rome riwaiai i vaia da a nenei ma i ḡei da ita nebelelai, ḡelaui i ḡei au taon e ḡoreḡorei Vaḡavaḡai Tonuḡa ai Numa ma ḡelaui i ḡae Apius ana au maket. Maranai Paul wei ravai i ʼnanai, ma i vinuaiai kaua ma God i viegualauei. ");
INSERT INTO wed_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Maranai au Rome taon a ḡeta taui Paul numa i verei da ainelana i mae ma sorodia i terei da i ʼnana-vaitetei. ");
INSERT INTO wed_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ma aupom tonuḡa au murina Jew babadai kampa maemaei i rauḡoreiai ma awarii i babani, “Varevareiu tau eḡa aiwai ata kauana-boai ata rava awarii bo amamata ai tarawatu ata viaigai. Wate au Jerusalem i paniu ma i veredamaneu Rome gavena awarina. ");
INSERT INTO wed_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Mai Rome i etareiu ma i ḡoei da ita rupeniu aubaina eḡa aiwai apoapoena ata kauei da ina viraḡeniu. ");
INSERT INTO wed_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Wate Jew babadai wei eḡa ita ḡoei ma lamna aubaina Rome babadai a riwei da tau eḡa ana mae wate ana ḡae au ḡaeḡaena Caesar awarina da ita rauetareiu. Wate lamna eḡa au rava ata viviḡaviei, eḡa. ");
INSERT INTO wed_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Lamna aubaina a ḡoremi weka da tata babani gogona, ma ata riwemi da tau a vipanipani aubaina a vitumaḡana da mai Israel ai tauvilawana wariaḡa i ririwei boiboḡi i nei.” ");
INSERT INTO wed_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Taui i paribelei, “Tauai eḡa pepa Judeaei ata vaia bo ai rava riwa ita neiai. ");
INSERT INTO wed_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Tauai aramanei da ravai anatapui kerisiana boruna e paripari-virevirei. Wate tauai a ḡoei da am nota ana vaia.” ");
INSERT INTO wed_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ma taui mara i terei da Paul maiteni ita viboru, ma patara i ḡetai mepa Paul i mamaelana. Ma ubaubanai Paul God ana vigulau jimana i vikarei da waguvarai i vorovei. Moses ana tarawatu ma peroveta nununaii ai au buka i mairi ma i jima. I ḡoei da orai ita taini da Iesu ita vitumaḡanei. ");
INSERT INTO wed_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ana babaniei ḡelaui orai i taini ma ḡelaui eḡa ita vitumaḡana. ");
INSERT INTO wed_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ma taui ava babanina i viparipariniḡaiei ma muriai da ita vilamonei Paul wei riwana tagogi i latoni i pa, “Arua Vivivireina riwa kaua Peroveta Isaiah ponanei amamami i riwei i pa: ");
INSERT INTO wed_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ma nae am rava mai Israel awari da ma riwei, ona nononora wate eḡa ona araramanei ona inanai wate eḡa anona ona aramanei. ");
INSERT INTO wed_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Aubaina wei ravai orai i bado. Taniḡai i gudui, Taui matai i vopotai. Mepa da taui mataiei ita inainana, taniḡaiei ita nononora oraiei ita araramanei, ma ita mae-tavirei awariu ma ata vilawani. ");
INSERT INTO wed_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","—Lamna aubaina ona aramanei da God Riwana Aiaina vai-melana aubaina i paritawanei Jentail awarii. Taui ina rautaniḡana.” ");
INSERT INTO wed_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paul kampa numa i vivimaiei ma i mae madeḡa ruaḡa taputapuna. Ma rava maḡamaḡaui i nenei da i raraugenari ma wei i vinuaiaiei. ");
INSERT INTO wed_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ana tepatorana God ana vigulau ma Iesu Keriso riwana Aiaina i jimei. Ma eḡa aiai ita viḡaei. ");
ALTER TABLE wed_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
