﻿USE sofia;
DROP TABLE IF EXISTS sofia.wed_topura_vpl;
CREATE TABLE wed_topura_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wed_topura_vpl WRITE;
INSERT INTO wed_topura_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Weꞌi yamna God natuna Yesu Keriso Tuyeghana Ahiahina me ivi karenanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Warihagha peroveta Aisaiya, wenanaꞌarena God ponana i girumi: “Ona rau-tanighana! Taupariverena ana aipari-tawaneꞌi da am etanai inavo kaukauwei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Taupariverena au mutuyuwa evivi ghoreghore, ‘Taumi ana aninae ona vokaukauwei, ana eta ona vovai-didimani.’” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Anina ma taupariverena John i neꞌi au mutuyuwa da rava i bababataitohi ma God riwana i dimedimei ipa, “Ghohaꞌapoapoe kauwana ona voterei ma ona wanavira-meyemi God awarina. Maranai ana babataitomi, yamna inavi matakiraha da taumi, God ami ghohaꞌapoꞌapoe ina nota-tawaneꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma rava anatapuhi, Judiya au paratana ma mai Jerusalem hi nae da John hita rau-tanighanei. Naꞌi marana ahi apoapoe hivi heghai ma tauna, Jordan wairana au horana i babataitohi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma John, ghamoghamo ana wava kamel aparana metametanana i oteoteni ma ana tairoro ghamoghamo opina. Tauna ana yam kapaꞌu ma tawaya. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma tauna, rava i ririwehi ipa, “Muriyai rava ghehauna e neneꞌi, tauna i ghe vavahagha, egha me tau. Tau egha tagotagogiu da ana aehuma ghuravana ata rupeni. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tau wairei a bababataitomi ma tauna, Aruwa Vivivireinei ina babataitomi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naꞌi maranaina Yesu Nasaretei, Galili ana au parata i voterei ma i ghaꞌira, mepa John i bababataito-yana. Ma John au waira Jordan, Yesu i babataitoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma maranaina Yesu wairei i gheꞌegheꞌeta, i inana da mara i wana-tawaneꞌi ma Aruwa Vivivireina me gabubu i ghaꞌiraꞌi ma horana ivi howai. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma God ponana marei i hopui ma i riwa ipa, “Tam, tau natuꞌu au nuwavaina ma uvi nuwa-ahiahiniu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma yamna au murina God Aruwana Vivivireina, Yesu i pari-tawanana hopuneꞌi au mutuyuwa. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma maratom 40 Yesu au mutuyuwa i maꞌae ma Satan, tauna i rau-dadani. Tauna, ghamoghamo moduwei maitehi nai au dobuna hi maꞌae ma God ana aneya marei, tauna hi paꞌini. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ma Guyau Herod, John i pani da deri au numana i terei. Ma au murina Yesu i nae au Galili ma rava auwarihi, God Riwana Ahiahina i dimei. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ma Yesu i ririwa ipa, “God ana mara i ririweiya i gheꞌetai. God ana vibadana vouna, rava aubaihi yamna i turiyai. Ami ghohaꞌapoapoena ona rupeni ma riwana ahiꞌahina onavi tumaghanei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma mara tagogi maranaina Galili topana au gerahana i bababara nae; ma tauyebagha ruwagha i inanahi. Simon ma ana tevera Andrew, ahi hagida hita yetayei au boga. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu i riwehi ipa, “Ona nei ma ona votaghou. Ma me marina o yebayebagha; nanaꞌarena anavi haraharamanimi da rava ona tuaruhi da hinavi tumaghaneu!” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma maratagogi ahi hagida hi voterei ma Yesu hivo taghotaghoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma tauhi gerahei hi veraunae ma Yesu, Zebedi natunatuna i inanahi James ma John ahi auwaga; ahi hagida wanawana-rorona hi yaruyarumi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma maratagogi tauhi i ghorehi ipa, “Taumi ona neꞌi ma taꞌu ona votaghou!” Ma tauhi, amahi Zebedi ana taunoya maitehi hivo terehi ma Yesu hivo taghotaghoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu, ana tauvotaghotagho maitehi hi nae au Kapernaum. Ma Sabate au marana i ruipari au numana ma God Tuyeghana Ahiahina, viharaharamanana ivi kareni. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma taurautanighana, tauna ana viharaharamana hi bahei; aubaina tauna ana riwapaneꞌi ivi haraharamana, egha me Raugagayo Tauviharaharamanahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Maranai Yesu, pari au numana ivivi haraharamana ma oroto aruwa-apoapoena horana i ruiruiniya i garara ");
INSERT INTO wed_topura_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ipa, “Yesu Nasaretei! Am ghohana awariꞌai aiwaꞌi? Tam weka u neꞌi da ma rau-iviꞌapoapoyeꞌai bo? Tau, a haramanei tam aiyaꞌi; tam, tagogi vivivireim Godei!” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Yesu i rau-gamopotai, “Ma genuwana! Na orotona ma hopu-tawaneꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aruwa-apoapoena, orotona ivo vaitatatavi ma ana gararana i hopu tawanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma rava anatapuhi hi bahei ma tauhi hivi tarapirivivira, “Aiwaꞌi kauwana e tuputupuwa? Weꞌi vihegha vouna, ravana ana rewapana e maꞌamaꞌae. Yamna aubaina aruwa-apoapoehi e ririwehi ma hevivi ponavowei!” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesu ana vighegha vouna tuyeghana, maratagogi Galili dobuna i howai. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ma pari au numana hivo tereꞌi. Yesu ana tauvotaghotagho maitehi hi nae Simon ma Andrew ahi au numa; James ma John maitehi hi nae. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon pohiyana wavinena ana gaugaururuna ana au anieno i enoeno. Maranaina Yesu i neꞌi; numana ravahi, doria tuyeghana hi pari-verei. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tauna i nae wavine i enoeno yana; ma nimana i vaini, ivo haguꞌi da ivo mahiri. Maratagogi gaugaururu i voterei ma wavinena, tauhi i inana vaitetehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Madegha i harere ma raviraviyai, tauhi ahi rava doridoriahi ma tauhi aruwa-apoapoena i ruiruinihi, hi neiyahi maꞌi Yesu awarina. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Meyagai ghaeghaena ravahi anatapuhi, numana au naona hivi tagogiyehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Rava maghamaghauhi ahi doria tapuna da tapuna ivi yawahanihi ma aruwa-apoapoehi rava i ruiruinihi ivi hopunihi. Ma aruwa-apoapoehi hi haramaneꞌi da tauna aiyaꞌi. Yamna aubaina i rau-gamopotahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Au maratomtom, Yesu enowei ivo mahiri; numa i hoputawaneꞌi ma i nae gabu au rauraugovaghana. Ma kampa, God maiteni hi dedede. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma muriai, Simon varevarehina maitehi hi nae da hi baihei. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma maranai Yesu hi tuhaghai; hi riwei hipa, “Rava anatapuhi he baibaihem.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu i pari-beyehi ipa, “Tana nae meyagai ghehauhi au ghereghere. Ma kampa, God Tuyeghana Ahiahina ana rau-guguyei. Taꞌu yamna aubaina a neꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ma Galili meyagaihi anatapuna i naenihi ma pari au numahi, God tuyeghana i rau-guguyehi ma aruwa-apoapoehi rava au horahi ivi hopunihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maratagogi oroto opina pagapagana i nae Yesu awarina, au naona i peꞌu, i rau-duneyei ma hagu ivi baghei ipa, “Inapa am ghohaghohana; yamna mavi ahiahiniu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu, orotona ivi nuwaboyei da urana ivi yoyoi ma ivo dadani ma i riwei ipa, “A ghohei. Ma ahi!” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma maratagogi, paga doriana orotona i voterei ma tauna i yawahana. ");
INSERT INTO wed_topura_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu ivi ghaꞌana guratei ma i pari-tawaneꞌi, ");
INSERT INTO wed_topura_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tam, aiwaꞌi i tuputupuwa awarim; rava egha mavi heghehi! Didimanim ma nae da metauna pirisina. God, rava ahi puyo e amꞌamverenei, tauna awarina mavi atataiyana meyem! Ma Moses yawahana puyona i ririweiya, ma ghohai da yamna inavi heghehi da tam u ahi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma orotona i nae da ana viyawahana tuyeghana, meyagai ravahi anataputapuhi i pari-verenaiyehi. Yamna aubaina, Yesu egha au meyagaihi ita rui ma i nae da au mutuyuwa i maꞌamaꞌae. Wate meyagai ravahi hi naenae awarina. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu ana tauvotaghotagho maitehi hi wanavira-meyehi au Kapernaum. Ma au pom ruwagha au murina, tuyeghana hi nonori da Yesu i nememei au meyagai. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yamna aubaina rava maghamaghauhi hivi tagogiyehi au numana. Patara hi magha guratana da numa metaetana maiteni i howai. Yesu, God riwana i rarauguguyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Rava 4, vatavatarei oroto gwaghagwaghana hi avarai da hi neiyai Yesu awarina. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rava hi magha guratana da egha tagotagogina hita neꞌi Yesu awarina. Yamna aubaina teteyei hi amghaena da numa au pohewana gavogavo hi bauni. Gwaghagwaghana vatavatarana hivo vai-hariharirini Yesu au naona. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu, ravahi i inanahi da hivi tumaghanei. Yamna aubaina da orotona gwaghagwaghana i riwei ipa, “Natuꞌu, am ghohaꞌapoapoe a nota-tawaneꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mai Jew ahi Raugagayo Tauviharaharamananahi ghehauhi kampa hi tughutughura ma ahi aunota wenanaꞌarena hivivi nuwa-notanota, ");
INSERT INTO wed_topura_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“God, Tau avana ghohaꞌapoapoei e notanota-tawaneꞌi. Aiwaꞌi aubaina da tauna we ravana nanaꞌarena e dedede? Tauna, God e teretere-ghaꞌirei; ma tauna e tereteregheꞌetana-meyei da tauna me God nanaꞌarena.” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Maratagogi, Yesu aruwanei i haramanei da tauhi nanaꞌarena hivivi nuwa notanota, aubaina i riwehi ipa, “Aiwaꞌi aubaina weꞌi riwana ovivi nuwa-notenotei? ");
INSERT INTO wed_topura_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Metauna kauwana i teatea: da gwaghagwaghana ata riwei, ‘Am ghohaꞌapoapoe a nota-tawaneꞌi.’ Bo, ‘Ma vomahiri, am anieno ma vaini ma ma nae?’ ");
INSERT INTO wed_topura_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Weꞌi kauwana a kaukauwei da taumi ona haramaneꞌi da Rava Natuna ana riwapana au dobu e maꞌamaꞌae da ghohaꞌapoapoe ina nota-tawanehi.” Ma gwaghagwaghana i riwei ipa, ");
INSERT INTO wed_topura_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A riwem; ma vomahiri; am anieno ma vaini ma ma nae am au numa!” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Oroto ivo mahiri ma ana anieno i vaini ma maratagogi i nae. Patara hi inanai ma hi bahana guratei. Tauhi hi hauhepahi ma God hivo hepahepai ma hi ririwa, “Tauꞌai egha meyanai kauwa wenanaꞌarena ata inanai!” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ana tauvotaghotagho maitehi Kapernaum hi hopu-tawaneꞌi ma Galili topana au gerahana hi naenae. Ma patara hi neꞌi, awarina ma tauna God riwana ahiꞌahina ivi haraharamanihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma i verau-nae ma oroto wavana Levi Alphaeus natuna, ana bagibagi au gabuna i tughutughura ma mane i tamitami Rome gabemanina aubaina. Yesu i riwei, “Ma votaghotaghoiu!” Levi ivo mahiri ma ivi muri-taghotaghoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu ana tauvotaghotagho, mane tautamina ghehauhi, ma ghohaꞌapoapoe ravahi; tauhi, Yesu maitehi hivo taghotaghoi. Anatapuhi, Levi ana au numa hi amꞌam gogona. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pharisee ma tauhi tagogihi Raugagayo Tauviharaharamanahi; tauhi hi inanai da Yesu mane tautamina ma ghohaꞌapoapoe ravahi maitehi hi amꞌam. Anina ma tauhi, Yesu ana tauvotaghotagho i riwei, ipa, “Aiwaꞌi aubaina Yesu, mane tautamahi ma ghohaꞌapoapoe ravahi maitehi he amꞌam?” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma maranai Yesu weꞌi dedena nanaꞌarena i nononori; tauna, tauhi i riwehi, “Rava yawayawahanihi, tauvi yawahana egha hita ghoheghohehi. Ma rava doridoriahi; tauhi, tauvi yawahana he ghoheghohehi. Taꞌu egha ata neꞌi rava ahiahihi aubaihi. Eꞌegha da rava deghadeghahi aubaihi a neꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maratagogi, John Taubabataito ana tauvotaghotagho ma Pharisee hi hudihudi. Ma rava ghehauhi, Yesu awarina hi neꞌi ma hi rau-bayadei hipa, “Aiwaꞌi aubaina John Taubabataito ana tauvotaghotagho ma Pharisee maitehi he hudihudi ma tam am tauvotaghotagho eꞌegha?” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu i pari-beyehi ipa, “Taumi o notanotai da tauhi tauviyaraga, tavine ana au am egha hina am bo? Eꞌegha! Maranai tavitavine vou-orotona, tauhi maitehi he maꞌamaꞌae, tauhi hita hudi ava. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma mara ina neꞌi da tavitavine vou-orotona, ana ghavia hina vaina-tawanei ma naꞌi maranaina ana rava hina hudi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma i riwa ipa, “Taꞌu kauwa vouna a neiyaꞌi, egha me taumi ami kauwa wadubona nanaꞌarena. Egha aiyaꞌi ravana, gara wadubona ma wanawana-sikana, gara vounei ina hirahirama potaꞌi. Anona yamna rauogha awarina garana vouna, wadubona ina roroꞌi da gavogavona ina raꞌata. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma nanaꞌarena egha aiaꞌi, wine vouna ina vaini da wage wadubona awarina ina hiwaghi. Mepa da ina ghohai; yamna na wine wagena ina wana-vaipawai ma wage ina wana-hedari da wine ma wage ina apoapoe.” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Maratagogi au Sabate, witi debagauna au horana, Yesu ana tauvotaghotagho maitehi hi naenae. Ma ana tauvotaghotagho, witi hi vaini da hi amꞌam. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pharisee ghehauhi, we kauwana hi kaukauweiya hi inanai. Yamna aubaina da Yesu hi riwei, “U haramanei da ata Raugagayo i riwa da Sabate, yamna viyawahi marana. Aiwaꞌi aubaina da tauhi hevovo bagibagi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu i pari-beyehi ipa, “David ana tauvotaghotagho maitehi am hi hiraghe. Ma aiwaꞌi hi ghohai? Taumi o hiyavi ma aiwaꞌi aubaina anona egha otavi nuwa-notenotei? ");
INSERT INTO wed_topura_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pirisi Gheghe Vavahaghana, Abiata ana au mara; David, God ana au numa i rui ma payawa ivi baghei. Pirisi Abiata, payawa ghehauhi i verei; payawana yamna God awarina amꞌamverenana ma i verehi. Raugagayo e ririwa da piripirisi tauhi ava, nai payawana he aniani. David ana tauvotaghotagho maitehi, payawana hi ani ma God egha ita riwa da yamna kauwa apoapoena.” ");
INSERT INTO wed_topura_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma Yesu ana riwa au damona i riwa ipa, “God, Sabate i ghohai rava vohaguna aubaina ma egha rava ita ghohai Sabate vohaguna aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Taꞌu Rava Natuna. Yamna aubaina taꞌu anina Sabate badana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mara gheha au Sabate, Yesu i naeme pari au numana ma oroto urana kebekebena i inanai; kampa i tughutughura. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma Pharisee ghehauhi hi ghohei da Yesu hitavi wavui. Yamna aubaina tauhi hi inana taghotaghonaiyei da hita inanai; apo au Sabate orotona itavi yawahani bo eꞌegha. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma Yesu, orotona urana kebekebena i riwei, “Ma neꞌi au naona ma mahiri.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma Yesu, rava i rau-bayadehi ipa, “Sabate au marana, metauna kauwana i ahi: ahi bo apoapoe, tanavi yawahana bo tanavi hiraghena?” Tauhi anatapuhi hi genuwana. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ana amoghaighaina i inana viravira. Au baina tauhi, koyahi i bagibagi ma tauna horana i boya kauwei. Yesu, oroto urana kebekebena i riwei ipa, “Uram mavi yoyoi.” Tauna urana ivi yoyoi ma urana i yawahana. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma Pharisee hi nae Herod ana rava auwarihi, ma ahi oga hi tarai da Yesu me hitavi hiraghenanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu ana tauvotaghotagho maiteni hita vainameyehi ma hi nae Galili topana au gerahana. Ma rava maghamaghauhi, Yesu aiwaꞌi i kaukauweiya tuyeghana hi nonori aubaina mai: Judiya, Jerusalem, Idumea ma dobu ghehauhi, Jordan wairana au babagehauna, Tyre ma Sidon; anatapuhi, tauna awarina hi neꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesu, rava maghamaghauhi ivi yawahanihi. Ma yamna aubaina da doridoriahi hivi am-dududu nae; tauna vodadanana aubaina. Tauna egha ita ghohei da hina gariuꞌumi. Aubaina da ana tauvotaghotagho i riwehi da waga hivo kaukauwei. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Maranaina, aruwa-apoapoehi rava au horahi, Yesu hi inainanai. Tauhi, tauna au naona hi peꞌupeꞌu ma hi garagarara, “Tam God Natuna.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma Yesu i rau-gamopotahi da havena tauhi hitavi hegha da tauna aiyaꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu ana tauvotaghotagho maitehi au oya hi ghae ma kampa oroꞌoroto ana ghohanei i ghorehi ma hi nae awarina. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Oroto 12 i vinehi ma ivi wavahi Apostle. Ma ipa, “A vinemi da maiteꞌu tana maꞌae ma muriyai ana paritawanemi rauguguya aubaina.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma God ana rewapanei aruwa-apoapoehi rava au horahi onavi hopunihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tauhi 12 i vinevinehi ahi wava yamna, Simon ivi wavai Peter, ");
INSERT INTO wed_topura_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma Zebedi natunatuna James ma ana tevera John, ivi wavahi Boanerges, anona waiparara natunatuna, ");
INSERT INTO wed_topura_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James, Alphaeus natuna, Thaddaeus, Simon tauna Zealot, ");
INSERT INTO wed_topura_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iscariot tauna, Yesu tau-vibenabename ina. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ana tauvotaghotagho maitehi hi naeme au numa. Ma patara upumahi hi riyehi da tauhi egha tagotagogina da hita am. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma Yesu ana ghughuni tauna, tuyeghana hi nonori ma hipa, “Tauna i buꞌuwa.” Yamna aubaina ana ghughuni hi neꞌi da tauna hita taravaini. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Raugagayo Tauviharaharamanahi ghehauhi, Jerusalemei hi nei ma hipa, “Aruwa-apoapoehi ahi bada Beꞌelzebub, Yesu au horana i rui. Ma yamnei aruwa-apoapoehi evivi hopunihi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yamna aubaina Yesu, Raugagayo tau-viharaharamanahi i ghorehi ma i awanaꞌi, ipa, “Menanaꞌarena ma Satan, aineyana inavi hopuna meyei? ");
INSERT INTO wed_topura_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mepa da dobu ravahi hinavi kahakaha ma hinavi ghaviya vivira, yamna dobuna ina peꞌu. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma nanaꞌarena ghughuni hinavi kahakaha ma hinavi ghaviya vivira; nai ghughuni ina peꞌu. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Inapa Satan ana dam hinavi kahakaha ma hinavi ghaviya vivira, apo hina peꞌu. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Taudanene egha tagotagogina da oroto virewapanana ana au numa ina rui ma ana purapura ina danenei. Au naona orotona ghuravei ina raghiraghihi ma muriyai ina danene. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Riwa vaimahiei a ririwemi, God, ami ghohaꞌapoapoe ma ami terevaidegha anatapuhi ina nota tawaneꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma aiyaꞌi ravana, Aruwa Vivivireina e tereterevaideghei; God apo egha na ravana ina rupeni. Tauna, yamna ghohaꞌapoapoe maemae vavahaghana i ghohai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu wenanaꞌarena i babani, aubaina tauna, Aruwa Vivivireinei aruwa-apoapoehi ivivi hopunihi ma rava hipa “Tauna, aruwa-apoapoena i ruini.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesu ayona ma varevarehina hi nei da au dowa hi mahimahiri ma riwa hi pari-tawaneꞌi da tauna ita nei tauhi auwarihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ma patara, tauna hi tughura kwaviviroi ma tauhi, Yesu hi riwei hipa, “U nonori! Ayom ma varevarehim au dowa ma he ghoheghohem.” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu i pari-beyehi ipa, “Aiyaꞌi ayoꞌu ma varevarehiu?” ");
INSERT INTO wed_topura_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Anina ma Yesu, tauhi hi tughutughura i inanahi ma ipa, “Ona inana! We tauhi ayoꞌu ma varevarehiu! ");
INSERT INTO wed_topura_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aiyaꞌi God ana ghohana e kaukauweiya tauna, ayoꞌu, novuꞌu ma varehiu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu, viharaharamana ivi karena meyei Galili topana au gerahana. Ma rava maghamaghauhi hi neꞌi da hita rau-tanighanei. Patara i magha guratana, aubaina tauna au waga i geru, i tughura ma waga hivo dudu-hopuneꞌi au topa ma patara au geraha hi maꞌae. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ghoha maghamaghauhi awanaꞌineꞌi ivi haraharamanihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tauna awanaꞌineꞌi i riwehi ipa, “Ona rau-tanighana! Tauvao ana vaovao i ghohai ma pehi i ravi-hawari. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pehi ghehauhi au eta hi peꞌu ma kiu i neꞌi da i anihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma pehi ghehauhi dowa au vighaꞌighaꞌimana hi peꞌu mepa dowa i habuhaburuyana ma mara tagogi hi gogo. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma marainana madegha i rararana, mara tagogi tauhi he poꞌipoꞌi, weꞌi aubaina waramihi egha hita rui guratana dowa au horana. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pehi ghehauhi dowa au modumoduna ma vividonadonana i ravihawari. Pehihi hi gogo ma donadona i yavanihi da egha hita rau-ano. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma pehi ghehauhi dowa au ahiꞌahina i ravi-hauwarihi ma hi gogo kauwa ma hi rau-ano da ghehauhi 30, ghehauhi 60 ma ghehauhi 100.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu i riwa ipa, “Tanighami, ina maꞌamaꞌae yamna ona rau-tanighana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Maranaina Yesu tau avana i maꞌamaꞌae, ana tauvotaghotagho ma rava ghehauhi hi neꞌi da hivi baghai da awanaina dededena anona itavi heghehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma Yesu i pari-beyehi ipa, “God ana vibadana dededena, taumi marina avivi heghemi. Ma rava au uputa maemaehi, nonora maghamaghauhi awanaꞌinei he nononora. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yamna aubaina: ‘Tauhi he inainana ma he inainana ma egha hita inainanaꞌi. Tauhi he rau-rautanighana ma he rau-rautanighana ma egha hita haraharamanei. Tauhi hita inanaꞌi ma hita haramaneꞌi, apo hita amvereyana meyehi God awarina ma tauna ahi ghohaꞌapoapoe ita nota-tawanei.’” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu i rau-bayadehi, “Moina, weꞌi awanaꞌinana egha ota haramanei? Awanaina ghehauhi apo me ona haramanei? ");
INSERT INTO wed_topura_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tauvao, God riwana e pahepahewi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Rava ghehauhi yana me etanai ma pehi au tepahi e raviravihauwarihi. Riwa he nonori, wate Satan e tamatamavivirihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Rava ghehauhi horahi, yana we nanaꞌarena, tauvao dowa au vikirakirana pehi e raviravihawari. Marainana riwa he nononori, yamna riwana he teretereriyei ma hevivi nuwaꞌahiahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tagogi naꞌi riwana egha au horahi ita maemae-nonowa. Marainana rava vivitumaghanaeghahi he rau-iviꞌapoapoeyehi, yamna yaghiyaghina ava he deghadegha. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Rava ghehauhi horahi, yamna me pehi, modu au vidonadonahi he raviravihauwarihi. Tauhi riwa he nonori, ");
INSERT INTO wed_topura_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wate weꞌi dobuna ana yawahana nuwaboyana, ana viguyau morumoruna ma ana raughoghara maghamaghauhi riwana evivi tapiai da egha ita raurauano. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wate rava ghehauhi horahi, yamna me pehi, dowa au ahiꞌahina he raviravihauwarihi. Tauhi yamna, riwa he nonori ma he vaivaini da he raurauano: ghehauhi 30, ghehauhi 60 ma ghehauhi 100.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu i am dabi ipa, “Aiyaꞌi ravana, rampa e ruiruiyei da au gabaꞌura bo au rauraugovaghana e tereterei? Eꞌegha da ana au anitake evivi hanai. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aiwaꞌi riwana rauraugovaghana, yamna ina rau-gheꞌegheꞌetei ma aiwaꞌi riwana humahumana, yamna ina wana-tawatawanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ina pa ona rau-tanighana vaimahi, yamna ona nota tuhaghai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Tauna maiteni i riwehi, ipa, “Aiwaꞌi o nononoriya, ona nota-vaimahiei. Am nota-vaimaiha ruvanei inavi kahaim ma ina rau-tepani. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tauhi aiwaꞌi auwarihi, yamna ghehauhi ina rau-tepani. Ma tauhi egha aiwaꞌi auwarihi, yamna aiwaꞌi haburuna hi vaivainiya ina vaina-tawanana pahiyei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu i amdabi ipa, “Weꞌi dededena, yamna God ana vibadana ghohana inanana, me nanaꞌarena. Oroto, witi pehina ana au vaovao i pahewi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tauna waguvara eꞌenoeno ma madeghai ana ghohaghohana ghehauhi e ghohaghohahi ma ana pehina yamna mara nonowa e gogogo. Tauna egha ita haramanei me pehina e gogogonei. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tano tau avana e ghohai da e gogogo ma anona e tereterei. Au naona e rau-pairei, muriyai borina e teretereꞌi. Anina ma e roverove da e rau-ano. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Marainana anona e magumagura, yamna oroto e amꞌam-tuꞌaruta.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu i rau-bayada, “God ana vibadana inanana me nanaꞌarena? Aiwaꞌi dededenei apo tana parivai-etaꞌetai? ");
INSERT INTO wed_topura_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eyagi pehina, yamna me gaga porana muhomuhohi; ma rava he vaghovaghoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Marainana e gogo, yamna e raꞌaraꞌata da ragharaghana e tereterei. Ma kiu ragharaghana au ghoꞌuna he rau-rau numa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu, awanaina maghamaghauna ana au dede i rau-guguyei da tauhi hita nota-tuhaghai, ahi nota au ruvana. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tauhi, awanaꞌineꞌi ava auwarihi ivi haraharamana ma marainana tauna, ana tauvotaghotagho maitehi tauhi ava, yamna awanaina ano ohohina e ririwehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Madeghana tagogina au bigaina, Yesu ana tauvotaghotagho i riwehi ipa, “Tana damana Galili topana au tupoghehauna.” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tauna au waga i maꞌamaꞌae ma tauhi hi geru da maiteni hi nae. Tauhi, rava boruhi hivo terehi ma hi damana, waga ghehauhi maitehi kampa. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hive ghaeghaena i towa, yaghina waga i raviravi ma niu waga i howahowai. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu, unuꞌununa au unutana i terei ma waga au murina i enoeno. Ana tauvotaghotagho hi ravi-dagudagui ma hipa, “Tauviharaharamana, tauta tana hiraghe ma tam aiwaꞌi e notanotaꞌi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tauna ivo mahiri ma hive i riwei ipa, “Ma rautautau!” Ma yaghina i riwei ipa, “Ma genuwana!” Hive i wanautuini ma daumora i eno. ");
INSERT INTO wed_topura_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu i riwehi ipa, “Aiwaꞌi aubaina o rovorovo? Aiwaꞌi aubaina egha otavi tumaghana?” ");
INSERT INTO wed_topura_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tauhi hi baheꞌi ma hivi tarapiri vivira, “Tauna aiyaꞌi da hive ma yaghina maitehi hivi ponavowehi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ana tauvotaghotagho maitehi hi damana Galili topana au tupo gehauna, mepa mai Gerasa ravahi hi maꞌemaꞌeyana. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Marainana Yesu wageꞌi i hopuhopu, oroto kokowagei i hopuꞌi. Weꞌi orotona yamna aruwa-apoapoena ivi howaꞌi ma ivi taniwagei. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","Egha tagotagogina da aiyaꞌi ita vovai-hubai, mara maghamaghauna, tauhi aiena ma urana seiniyei hi raghiraghihi, wate mara anataputapuna hi raurau-seini ma seinihi i raurau-tuituinihi, aubaina egha tagotagogina da hita raghita dawai. Waguvarai da madeghai i mahimahirinae, i garagarara ma ghaꞌimei i hapihapi meyei. Au oya ma au kokowaga i maꞌamaꞌae. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Oroto kokowagei tauna au uwama ma Yesu i inanai ma i ruba da au naona i peꞌu. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ma ponana ghaeghaeneꞌi i garara, “Yesu, God au aidamo maemaema natuna, am ghohana awariꞌu aiwaꞌi? God wavanei, avivi baghaim, egha ma rau-iviꞌapoapoyeꞌu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","We nanaꞌarena i riwa, aubaina au naona Yesu aruwa-apoapoena i hegahegari da orotona ita hoputawaneꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu i rau-bayadei, “Wavam aiyaꞌi?” I paribeyana ipa, “Tauai a magha, aubaina aꞌu wava yamna Legion.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tauna Yesu ivi bagha maeyei da tauhi havena da naꞌi dobuna hita hopu-tawaneꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Au barabara, poro maghamaghauhi hi yabayaba, ");
INSERT INTO wed_topura_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","aubaina aruwa-apoapoehi, Yesu hivi baghai hipa, “Ma pari-tawaneyai poro auwarihi da tauai, tauhi ana ruinihi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu ivi aninehi, anina ma aruwa-apoapoehi, oroto hi hopu-tawaneꞌi ma poro hi ruinihi. Porohi au aihariri hi ruba da Galili au topana hi harere. Tauhi maghauhi me 2000. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tau-vighamoghamo, hi rovo ma hi ruba au meyagaigheha dobugheha da rava maghamaghauhi hi pari-verehi. Rava hi nae da aiwaꞌi i tuputupuwa hita inanai, ");
INSERT INTO wed_topura_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Marainana hi naꞌe Yesu awarina, tauna orotonana aruwa-apoapoehi hi riruiniya, yamna i tughutughura, gara i oteni ma ana nota ahiꞌahina. Ma tauhi hi rovo kauwa. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aiwaꞌi oroto ma aruwa-apoapoena da poro auwarihi i tuputupuwa, tau-inanahi, rava ghehauhi hi riwehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","M tauhi Yesu hivi baghaꞌi da ahi dobu ita hopu-tawaneꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Marainana Yesu i gerugeru au waga, orotona aruwa-apoapoena i ruiruiniya, Yesu ivi baghai da maiteni hita nae. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu egha itavi aninei ma i riwei ipa, “Manaeme, am au numa ma am rava ma pariverehi, weꞌi kauwana ghaeghaena Bada i kaukauweiya tam aubaim ma tauna ana ivi ahiahi tam awarim.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Anina ma orotona, tauhi ivo terehi ma i naeme au Dekapolis (meyaghai 10) ma meyagai maghamaghauhi i naenihi ma rava i pari-verehi, aiwaꞌi Yesu i kaukauweiya tauna awarina. Ma tauhi tau-rautanighana, hi bahei. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wageꞌi i damaname Galili topana au navanavagheha, marainana i damana vivira au navanavagheha, tauna yohora au geraha ma rava maghamaghauhi hi gariwabui. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Oroto tagogi i neꞌi awarina, tauna ana wava Jairus ma tauna pari numana tau paꞌinina. Marainana tauna Yesu i inanai, i nae da au aiena i peꞌu ma i rau-duneyei, ");
INSERT INTO wed_topura_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ivi baghaguratei, “Natuꞌu totopana i doria kauwa, maneꞌi da ma vodadani ma tauna ina yawahana ma ina maꞌae.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Anina ma Yesu maiteni i naꞌe. Rava maghamaghauhi hi neꞌi da hi gariuꞌumi. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wavine ghehauna tara i doridoriei, borima 12 au horana, tauna maiteni kampa. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wavinena money ghaeghaena i tawanei tau viyawahana auwarihi ma egha tagotagogina da hita hagu kauwei, doriana egha ita kwahakwaha ma i raꞌaraꞌata. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Tauna Yesu tuyeghana i nonori ma ivi mayavaina meyei ipa, “Ana gara ava ana vodadani, apo ana yawahana.” Yamna aubaina da wavinena rava maghamaghauhi horahiyei i nae da Yesu murineꞌi ana gara ivo dadani. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mara tagogi tara doriana i kwaha ma tauna au horana mayana i vaina meyei da ana doria i kwaha. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu mayana i vaini da ana boyaboya i hopu tawaneꞌi, anina ma i maetavirei boru au pouhi ma ipa, “Aiyaꞌi aꞌu gara ivo dadani?” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ana tauvotaghotagho hipa, “Ma inanaꞌi, weꞌi ravahi hi gariuꞌumim, yamna aubaina apo me mariwanei da aiyaꞌi ivo dadanim?” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma Yesu i inana viravira, i ghoheghohei da naꞌi ravana ita inanai. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wavinena i haramaneꞌi da aiwaꞌi i tupuwa awarina ma i rovo kauwa da i tatatava. Anina ma i neꞌi da Yesu au aena i peꞌu ma aiwaꞌi anataputapuna riwa vaimahiei i riwana pahiyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Anina ma i riwei ipa, “Natuꞌu, am tumaghana awariꞌu, ivi yawahanim, am doria i kwaha nonowa. Nuwahubei ma nae.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu yohora i bababani ma, Jairus ana tau vituyetuyegha hi neꞌi da hi riwei hipa, “Natum totopana i kwaha. Havena da tau viharaharamana utavi sinaviravirai?” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tauhi aiwaꞌi hi ririweiya, Yesu egha itavi ponavowehi ma Jairus, i riweꞌi ipa, “Egha marovo mavi tumaghaneꞌu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Rava maghamaghauhi ivi ghaehi da hi maꞌae, Peter, James ma varehina John, tauhi ava i taravainihi ma hi nae. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairus ana au numa hi gheꞌeta ma Yesu tauhi i inanahi da hivi nuwa ragharagha, hivivi nuwaboya ma hivivi touwana. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu au numa i rui ma i riwehi ipa, “Aiwaꞌi aubaina o toutou? Weꞌi teverana egha ita hiraghe, tauna e enoeno.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tauna, hi inana vai diboghi ma hivivi namei, yamna aubaina da tauhi ivi hopunihi ma teverana amana, ayona ma ana tauvotaghotagho tonugha i taravainihi ma hi rui teverana i enoenoyana. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tevera au urana ivo wa ma i riwa ipa, “Talita koum,” anona yamna, “Totopa, taꞌu a ririwem ma vomahiri.” ");
INSERT INTO wed_topura_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tauna yaghiyaghina ava ivo mahiri ma i babaranae. (Tauna ana borima yamna 12) Weꞌi ghohana hita inanai, yamna tauhi anataputapuhi hi ghohorihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu ivi ghaꞌanaghagharehi havena da, rava ghehauhi hita riwehi ma ipa, “Aiwaꞌi ona verei da ina am.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ana tauvotaghotagho maitehi naꞌi dobuna hi voterei ma hi naꞌeme ana au meyagai ohohina. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Au Sabate, viharaharamana ivi kareni, pari au numana. Rava maghamaghauhi kampa ma marainana tauna hi nonori, tauhi anataputapuhi hi ghohorihi. Tauhi hi rau-bayadana vivirihi, “Weꞌi haramanana mepa i vaini? Ma meiyei i rau-nuwahuyahuya ma menanaꞌarena da anibaha ghaeghaehi e ghohaghohaꞌi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tauhi hi riwana vivirihi, “Tauna yamna tau vowa, Mary natuna tautuwaghina, James, Joses, Judas ma Simon varehihi. Ma novunovuna muhomuhohi weka he maꞌamaꞌae, tauna bo?” Yamna aubaina tauhi, hi hinidodorei. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu i riwehi ipa, “God ana tau dede rava hevivi ponavowehi ma ahi meyagai ohohina ravahi, ahi dam ma ahi ghughuni ravahi egha hitavi ateateyehi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Rava tauna egha hitavi tumaghanei ma tauna i baheꞌi. Yesu egha anibaha ghaeghaehi ita ghohahi aubaina tauhi egha itavi tumaghanei aubaina, tauna rava doridoriahi hi yahiyavahi ava ivo dadanihi ma hi yawahana. Ma tauna meyagai i naenihi ma rava ivi haraharamanihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu ana tauvotaghotagho 12 i ghorehi da hivi tagogiyehi ma ruwaruwaghei ava, i pari-tawanehi au meyagai gheha. Tauna, aruwa-apoapoehi ani vovaihubahi, riwapanana i verehi, ");
INSERT INTO wed_topura_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ma i riwehi ipa, “Weꞌi ami naena au horana, ami dighona ava ona vaini, egha purapura ghehauhi egha yam, egha autu, egha money autuna. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ae humahuma ona oteni ma egha kwama ghehauhi ona vowai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tauna maitena i riwehi ipa, “Metauna au meyagaina ona enae ma aiyaꞌi ravana e maꞌaemaꞌae naonaowemi, ana au numana ava ona maꞌamaꞌae da meyagaina ona voterei. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ina pa metauna meyagaina ravahi egha hina maꞌe naonaowemi, bo egha hina rau-tanighanemi, yamna ona voterehi ma aemi vunavunana ona rau-habuhabui. Yamna tauhi ahi pariputu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Anina ma hi nae ma rava auwarihi hi rau-guguya ma hi riwehi hipa, “Ami ghoha, apoapoehi ona voterehi ma God awarina ona nememeꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tauhi aruwa-apoapoehi maghamaghauhi hivo vaihubahi ma hivi hopunihi ma olive oil rava doridoriahi, au koyahi hi hiwaghihi da hi yawahana. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","15","Dobu taputapuna ravahi, Yesu he dededei ma riwana i raꞌata. Rava ghehauhi hipa, “John tau babataito i yawahaname. Yamna aubaina da anibaha ghaeghaehi e ghohaghohahi.” Rava ghehauhi hipa, “Tauna Elijah.” Ma rava ghehauhi hipa, “Tauna yamna God ana peroveta, warihagha.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Guyau Herod i nonori ma ipa, John tau babataito koyana taꞌu a tarautuini ma i yawahaname; ");
INSERT INTO wed_topura_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod i am hegara da John hi pani ma au deri hi terei, weꞌi aubaina, tauna Herod i riwana haigiriyei ipa, “Ghoha apoapoena u ghohai da varehim Philip awana u vaini.” Herod i am hegara da John hi pani ma au deri hi terei, aubaina tauna, varehina Philip awana Herodias, i ravaghi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John tau babataito, Herod i riwananonowei ipa, “Ghoha apoapoena u ghohai da varehim awana u ravaghi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yamna aubaina Herodias, John i rau-amoghaighaiyei ma i ghoheghohei da itavi hiragheni ma Herod i taraghaghari. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod, John i rovorovowei, aubaina tauna yamna rava ahiꞌahina mavi vivireina. Yamna aubaina vihiraghenana i taraghaghari. Tauna i ghoheghohei da mara maghamaghaunana John ita rau-rautanighanei, havena da ana au dede, tauna evivi nuwaragharagha. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herod ana tupuwa au marana, Herodias, ana gavogavo ivi aꞌroni. Herod, ana tupuwa marana, torehana i terei ma dobu babadahi, ahitaunoya, ghavighaviyana babadahi da mai Galili rava ghaeghaehi ghehauhi maitehi, aubaihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias natuna guguhinina, au torehana i hara, Herod ana taomana maitehi hi inanai ma hivi eraerawei. Yamna aubaina Guyau Herod, guguhinina i riwei ipa, “Am ghohaghohana aiwaꞌi? Am ghohaghohana anataputapuna ana verem. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","God au matana, a ririwem da am ghohaghohana anataputapuna ana verem, ina pa aꞌu viguyau tupona ma ghoheghohei yamna maiteni ana verem.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Guguhinina i nae da ayona i rau-bayadei, “Aiwaꞌi ana vibaghei?” Ayona i pari-beyana ipa, “John tau babataito koyana mavi baghei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Guguhinina, yaghiyaghina ava i naeme Guyau awarina ma i haighiriyei ipa, “A ghoheghohei da weka ma marina, John Taubabataito koyana au aboma ma terei ma mavereꞌu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Guyau i nonori ma ivi nuwaboya kauwa, wate egha tagotagogina da itapari virevirei, aubaina tauna ana taomana au matahi ma iparivai nuwaghani. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yaghiyaghina ava, tau vihiraghena ghehauna i hegari da John koyana ita neiyaꞌi. Tau vighaviya i nae, au deri ma John uwana ita rau-tuini, ");
INSERT INTO wed_topura_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma au aboma i terei ma i naiyai da guguhinina hi verei ma tauna ayona i verei. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Marainana John tau babataito ana tauvotaghotagho tauna, hiraghena tuyeghana hi nonori, yamna hi neꞌi da tupuwana hi vaini da au kokowaga hivi enoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu ana Apostle, ahi au bagibagi hi neneyana, hi wana virameyehi awarina ma aiwaꞌi hi ghohaghohahi da hivi haraharamaneiya, hivi heghei. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma na marainana, rava maghamaghauhi, hi naenae auwarihi ma hi wanawana virameyehi. Yesu ana tauvotaghotagho maitehi egha mepa ahi gavogavo da hita am. Yesu i riwehi ipa, “Tautaiava tana nae, au mutuyuwa, mepa rava egha hita maꞌemaꞌeyana ma tanavi yawahi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Au waga hi geru ma hi damana au mutuyuwa, mepa rava egha hita maꞌemaꞌeyana. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Rava maghamaghauhi, tauhi hi inanahi da hi naenae ma hi inana tuhaghahi, aubaina geraha, meyagaina ravahi maghamaghauhi, gerahei hi ruba da hi aigheꞌeta au mutuyuwa ma Yesu ana tauvotaghotagho maitehi muriyai hi ghota. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu wageꞌi i hopu ma rava maghamaghauhi i inanahi ma i rau-nuwaꞌapoapoeyehi aubaina tauhi me sipu ma egha taupainihi. Anina ma tauna God ana ghoha maghamaghauhi ma ana vibadana vaivaina, ivi haraharamanihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Au hegoya, ana tauvotaghotagho, hi neꞌi awarina ma hipa, “Au e pompom ma weꞌi au dobuna rava egha hita maꞌamaꞌae.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Rava ma paritawanehi da tauhi hina nae, meyagai au muhomuhohi bo au ghaeghaehi da yam hina baiha da hina am. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Yesu i pari-beyana ipa, “Taumi yam ona verehi da hina am.” Ma hi riwehi ipa, “Tam u ghoheghohei da tauai 200 denarii.” Ruvanei yam tana gimarai da ravahi maghamaghauhi tana ghamohi bo. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu i rau-bayadehi, “Payawa bihagha awarimi? Ona nae da ona inanai.” Hi nae ma hi nememei da hi riwei hipa, “Payawa 5 ma i yana 2 hemaꞌamaꞌaꞌe.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Anina ma Yesu i riwehi ipa, “Upumei, au gidagida ona tughura.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Anina ma tauhi upuma 50 da 100 awarinei hi tughuranae. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Yesu payawa 5 ma i yana 2 i vaini ma au mara i watata ma God ivi egwayauwei ma payawa da i yana i tomutomui ma ana tauvotaghotagho i verehi da tauhi rava hi verehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ana taputapuhi hi am ma hi amhiyauwa. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yesu ana tauvotaghotagho, payawa ma i yana amꞌamterenahi hi tami da poha 12 hivi howahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Oroꞌoroto maghauhi 5000 hi gamohi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu Yaghiyaghina ava ana tauvotaghotagho, i hegarihi da au waga hi geru da hita ai damana au Bethsaida, Galili topana au navanava ghehauna. Ma tauna, patara ivo tawanehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tauhi, ivo tawanehi ma tauna i ghae au oya pari aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Waguvaraina, Yesu tau avana au geraha i maꞌae ma ana tauvotaghotagho yamna au waga, Galili topana au pouna. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yaghina ma hive ivo guratei ma Yesu ana tauvotaghotagho i inanahi da tauhi hive ma yaghina hi tupatupamatani mavi wewehanei hi yareyare. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Maratomtomai Yesu topa tepanei i bababara nae ma tauna i ghoheghohei da ana tauvotaghotagho ita terevivirehi ma marainana tauhi hi inanai ma hi notai da tauna yamna konagha, hi rovo ma hi otu. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Marainana anataputapuhi, tauna hi inanai ma hi rovo kauwa. Ma Yesu, i riwehi ipa, “Taꞌu, egha ona rovo.” ");
INSERT INTO wed_topura_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Tauna au waga i geru ma hive i wanautuini ma tauhi hi nota ava, havena da, tauhi payawa ani bahana i kaukauweiya hi inanai ma tauhi yohora egha tauna ana riwapana hita haramanei. Au baina, tauhi ahi nota i pupu. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tauhi, Galili topana hi damani da au Genesareta hi ghota ma waga hi tainagheꞌetei. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waga hi hopu tawaneꞌi ma rava Yesu, mara tagogi hi inana tuhaghai. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yesu tuyeghana, dobuna ghaeghaenana hivi babarai ma tauhi, rava doridoriahi hivi hihivanehi tauna awarina. ");
INSERT INTO wed_topura_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu, me au meyagaihi, i naenae yana, yamna rava, ahi rava, doridoriahi hivi hihivanehi, boru au gabuhi da itavi yawahanihi. Doria ravahi ahi rava, hivi bagha hipa, “Ma vianinehi da am gara mutuna ava ana vodadani.” Ma tauhi aiyavoꞌina ava da ana gara hivo vodadaniya, anataputapuhi, tauna ana riwapanei, hi yawahana. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","(Pharisee ma mai Jew anatapuhi, muriyai da hita am, au naona, nimahi hina oghai. Me warihagha waghawaghahi ahi vaivai hi teretereiya nanaꞌarena. Maranaina boruwei he nene memei, egha hina am da au naona gobuhi hina ogha tawaneꞌi. Ahi ghoha maghamaghauhi ghehauhi maiteni hevo taghotaghohi, me ani am da ani uma, me he oghaꞌoghanei). Pharisee ma raugagayo tauvi haraharamanahi ghehauhi Jerusalemei hi nei Yesu awarina da hita rau-tanighanei ma hi inanai da ana tauvotaghotagho ana nima gobuhi hi amꞌam. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ma tauhi Yesu hi rau-bayadei hipa, “Aiwaꞌi aubaina, am tauvotaghotagho waghawaghata ahi vaivai egha hita votaghotaghoi ma ana ura mirahi he amꞌam?” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma Yesu i pari-beyana, “Taumi morumorumi, God ana peroveta Isaiah i riwa kauwa, tauna i girugirumia nanaꞌarena, God i riwa, ‘Taumi gamomiyei o vovohepahepaꞌu, wate nuwanuwami au horana tapuna ava. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tauhi rava ahi vaivai hevivi damani ma egha yamna God ana raugagayo. Yamna aubaina ahi vohepahepa yamna kwakwavina.’ ");
INSERT INTO wed_topura_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Taumi God ana raugagayo o teretere riyei ma taumi ami vaivai o vovo taghotaghoi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma i riwana meyehi ipa, “Taumi ami haramanei God ana raugagayo o teretere riyei ma taumi ami vaivai o vovo taghotaghoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses God ana raugagayo i teretereiya yamna, ‘Amam ma ayom mavi virehi,’ ma ‘Aiyaꞌi amana ma ayona e enaena boꞌahi, tauna onavi hiragheni.’ ");
INSERT INTO wed_topura_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wate taumi o viharaharamanihi da ayo ma ama he rau-rau boviyehi ma, God awarina; he amꞌam verena. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ami viharaharamanei, tauhi ama ma ayo egha hita vohaguhi. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma weꞌi, viharaharamana taumi, rava auwarihi o vividamani ma God riwana o vivihamoaꞌi. Ma kauwa maghamaghauhi ghehauhi maitehi o kaukauwei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu patara i ghore meyehi ma ipa, “Ana tapumi ona rau-tanighaneu ma aiwaꞌi a ririwemi ona haramanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Aiwaꞌi da au gamomi e ruirui tauna egha itavivi miraimi ma aiwaꞌi da horamiyei e hopuhopu, tauna evivi miraimi, God au matana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu patara ivo terehi ma i naeme au numa ma ana tauvotaghotagho hivi taravirevirei da awanaina anona itavi heghehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesu ipa, “Taumi maiteni egha ota haramanei bo? Kauwa aiwaꞌi upuneꞌi rava au horahi e ruirui apo egha inavi mirai, anona yamna weꞌi kauwana egha tauna au nuwanuwana ita ruirui ma au manawana da e hopuhopu.” (Weꞌi riwanei Yesu yam anatapuhi ivi aninei da tauhi egha waꞌiyawa). ");
INSERT INTO wed_topura_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","I amdabi ipa, “Aiwaꞌi rava horanei e hopuhopu yamna rava evivi mirai, God au matana. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Rava ghohaꞌapoapoe, nuwanuwahiyei hevivi tetei ma ghohana he ghohaghohai nota apoapoehi me, rauhoghara yabayababa, danene, vihiraghena, awadanene, ");
INSERT INTO wed_topura_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","amboho, rau ivi apoapoe, moru, erawa, unura, terevaidegha, maeghaeghae ma buꞌuwa kauwahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Weꞌi ghohahi apoapoehi rava horahiyei he hopuhopu ma rava hevivi mirahi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ma naꞌi meyagaina i voterei ma i nae Tyre au paratana ma au numa i rui, aubaina egha ita ghohei da rava hita haramanei, wate tauna egha tagotagogina da ita rau-govagha. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Wavine tagogi Yesu tuyeghana i nonori ma i nei awarina, weꞌi wavinena tauna egha Jew, tauna eteni au Fonisia i tupuwa, Siria au paratana. We wavinena natuna wavinena haburuna aruwa-apoapoena, i ruini. Yamna aubaina ayona i nae Yesu awarina, au naona i raudune ma ivi baghai da aruwa-apoapoena natuna awarina ita vaina tawaneꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu i haramanei da wavinena eteni, yamna aubaina i riwei, “Egha ita ahi da rowarowa ahi yam ana vaini ma ouꞌou ana verei, eꞌegha da, au naona rowarowa hina am hi yauwa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma wavine i pari-beyei, “Bada, yamna riwa kauwa wate rowarowa ahi yam hamohamoghina kepakepa au gabaurina e dabadabarara yana ouꞌou he aniani.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma Yesu i riwei, “Ma naeme am au numa. Tam am paribeyana i ahi aubaina aruwa-apoapoena natum au horana tauna i hopuna tawaneꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma i nae me ana au numa ma i tuhaghai da teverana ana au ani eno i enoeno ma aruwa-apoapoena i hopu tawaneꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu Tyre paratana i ne tawaneꞌi da au Sidon ma i kwaviviro da au Dekapolis Galili topana au ririvana. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Rava ghehauhi oroto tanighana potapotana ma menana birebirena hi neiai ma Yesu hivi baghai da urana au opina ita terei da itavi yawahani. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yamna aubaina Yesu oroto i taravaina hopunei da tauhi ava ma ura gigina oroto au tanighana i tere ruꞌiyei ma ura gigina i hovai ma menana ivo dadani. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma au mara i inana ma nuwanuwana i boyai ma i yavutu tawanana ma oroto i riwei, “Efata,” weꞌi anona “Mawana tawaneꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Maratagogi tanighana i wanatawanei ma menana ivi dagudagu ma i dede kauwa. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma Yesu rava ivi ghaehi, i riwana guratehi da egha rava ghehauhi hina riwei da aiwaꞌi i tupuwa. Rava i riwana guratehi wate tauhi egha hita rau-tanighana ma hivi tuyetuyeghei. ");
INSERT INTO wed_topura_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma maranai rava weꞌi riwana hi nonori, tauhi hi bahana guratei ma i riwa, “Aiwaꞌi anatapuhi i kauwana anatapuna ahiꞌahina ava. Tauna rava tanigha potapotana ivi yawahani da e rau-tanighana ma menana birebirena e dedede kauwa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naꞌi marana patara ghaeghaena hivi tagogi yana meyehi. Patara ahi yam eꞌegha, yamna aubaina Yesu ana tauvotaghotagho i ghorehi da hi naꞌe awarina ma ipa, ");
INSERT INTO wed_topura_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Madegha tonugha au horana, patara maiteꞌu a maꞌae ma ahi yam eꞌegha ma tauhi a rau-nuwapoapoeyehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ana amhiraghehi ana paritawanehi, apo au etanai hina rau-moyaghahu ma ghehauhi uwamei hi neꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ana tauvotaghotagho hi pari-beyei, “Weꞌi mutuyuwa ma mepa yam tana vaini da weꞌi patarana tana ghamohi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Yesu tauhi i rau-bayadehi ipa, “Payawa bihagha awarimi?” Tauhi hi riwa, “Seven.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma Yesu patara i riwehi da hi tughura ma payawa seven i vaini ma God ivi egwayauwei ma ivo tomutomuhi ma ana tauvotaghotagho i verehi ma patara hi ghutehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma tauhi auwarihi iyana muhomuhohi ruwagha, Yesu i vaini, God ivi egwayauwei ma ana tauvotaghotagho i verehi ma tauhi patara hi ghutehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tauhi anatapuhi hi am da hi am hi yauwa. Tauvotaghotagho yam amtereterenana hi tamaꞌaruaruhi da poha seven hivi howai. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Rava ahi magha 4000 nanaꞌarena ivi anihi. Au murina i pari-tawanehi da hi naeme ahi au numa. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Maratagogi, Yesu ana tauvotaghotagho maitehi au waga hi geru da hi damana Dalmanuta ana au parata. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee ghehauhi hi neꞌi Yesu awarina ma maiteni hivi awahegahigahiyana. Tauhi hi ghohei da Yesu hita rau-dadani da matakiraha, Godei itavi heghai. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu aruwanei i yavutu tawanana ma i riwa, “Taumi, tupumuri ravami, aiwaꞌi aubaina matakiraha o ghoheghohei da ota inanai? A ririwana kauwemi apo matakiraha egha ona i inanai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu Pharisee ivo terehi ma ana tauvotaghotagho maitehi au waga hi gerume ma hi damana Galili topana au tupo ghehauna. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ana tauvotaghotagho nuwanuwahi i vuru da payawa egha hita vaini, payawa tagogi ava au waga i maꞌamaꞌae. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu iparivai nuwa i daghihi “Pharisee ma Herod ahi viharaharamana boꞌa, e raꞌaraꞌata me yist, ona inana vaimahiei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma tauhi hi dede hipa, “Payawa eꞌegha aubaina e dedede.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Yesu ahi dede i haramanei aubaina da i riwehi, “Payawa eꞌegha ma aiwaꞌi ovivi tarapiriyei? Taumi yohora egha ota inana tuhaghai bo? Koyami i bagibagi bo? ");
INSERT INTO wed_topura_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matami e maꞌamaꞌae ma egha ota inainana ma tanighami e maꞌamaꞌae ma egha ota nononora bo? Ma o notanotai bo eꞌegha? ");
INSERT INTO wed_topura_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Maranaina payawa 5 a votomutomui rava 5000 aubaihi, payawa amtereterenana o tami da poha bihagha ivi howai?” Tauhi hi pari-beyei, “12” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma maranaina payawa 7 a votomutomui rava 4000 aubaihi ma payawa amtereterenana o tami da poha ghaeghaehi bihagha ovi howai? Tauhi i pari-beyei, “7” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma tauhi i riwehi ipa, “Taumi yohora da ovivi nuwanaina bo?” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tauhi hi neꞌi au Bethsaida ma rava ghehauhi oroto matana apoapoena hi neiyai Yesu awarina ma hivi baghai da matana ita vodadani. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Orotona matana apoapoe i rau-ꞌurana ma meyagaiyei i taravaina hopunei. Ma kampa matana i hovaꞌi ma uranei matana ivo dadani ma i rau-bayadehi, “aiwaꞌi e inainanai bo eꞌegha?” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma i tahepai ma i riwa, “Rava a inainanahi ma tauhi me eyagi, he bababara.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu uranei oroto matana, ivo dadana meyei, matana i yawahana, i ahi ma aiwaꞌi anatapuna inana kauwei. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu tauna i pari-tawanei ana au numa ma i riwei, “Egha au meyagai manaeme.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ana tauvotaghotagho maitehi i nae au meyagaigheha Sisiria Pilipai au gheregherena. Au etanaiyei ma i rau-bayadehi, “Rava he ririwa da Taꞌu aiyaꞌi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma tauhi hi pari-beyei, “ghehauhi e ririwa da tam John Taubabataito ma ghehauhi he ririwa da Elijah ma ghehauhi he ririwa da peroveta tagogi warihagha maemaena.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma Yesu tauhi i rau-bayadehi, “Wate taumi me o notanotanei ma i riwa da Taꞌu aiyaꞌi?” Peter i pari-beyei, “Tam Keriso, Tauvi yawahana Godei!” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu tauhi ivi ghaehi da egha aiyaꞌi hina riwei da tauna aiyaꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma Yesu ana tauvotaghotagho vinuwaterenehi ivi kareni ipa, “Rava Natuna inavi nuwaꞌapoapoe kauwa ma Jew babadahi, piripirisi ghehauhi ma raugagayo tauvi haraharamanahi, hina pari-virevirei tauna ina hiraghe ma madegha tonugha au murina inavo mahiri me.” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu didimaninei weꞌi kauwahi ivi heghehi ma yamna aubaina Peter tauna i taravainariyeai ma i pari-virevirei. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wate Yesu i maetavirei ma ana tauvotaghotagho i inanai ma Peter i pari-ghahiyei, ipa, “Satan manae au muriꞌu! Tam am nota egha Godei ita neneꞌi, eꞌegha da raveꞌi” ");
INSERT INTO wed_topura_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu tauna patara ma ana tauvotaghotagho i ghorehi ma i riwehi, “Mepa da aiyaꞌi itavi muritaghoiu, tauna ina boviyana meyei, ana korosi ina avarai ma inavo taghotaghoꞌu. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aiyaꞌi ravana ana yawahana evo vodidini ma e paꞌipaꞌini apo ina vineboai ma aiyaꞌi da ana yawahana e amverenei taꞌu ma tuyeghaꞌu ahiꞌahina aubaina, tauna ana yawahana ina vaina meyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mepa da wei dobuna ana yawahana ma ana viguyau ina vainapahi ma yawahana Godei ina geduaiyei, wei dobuna viguyauna tauna me ina hagunei? ");
INSERT INTO wed_topura_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wate aiwaꞌiyei am yawahana ma gimara meyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mepa da aiyaꞌi taꞌu ma au viharaharamana inavi hinimayei weꞌi ghohaꞌapoapoehi kauwana au marana, Rava Natuna tauna inavi hinimayei maranaina ana aneya vivivireina maitehi, amana ana borumei hina nenememei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma tauna, tauhi i riwehi, “Taumi a ririwana kauwemi, rava ghehaumi weka o mahimahiri apo egha ona hiraghe ma God ana vibadana ona inanai ana rewapanana ina nei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Maratom 6 au murina Yesu Peter, James ma John tauhi ava i taravainihi ma hi ghae au oya damo. Ma kampa tauhi au matahi Yesu i tupuwa vira. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ana gara i arapoira ma ivi mataꞌam, egha me aiwaꞌi ghehauna au dobu nanaꞌarena. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma kampa au matahi Elijah ma Moses hi hegha ma tauhi Yesu maiteni hi dedede. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter Yesu i riwei, “Tauviharaharamana, i ahi da tauta weka mavi anineꞌai da ghoꞌughoꞌu tonugha ana vowai, tagogi tam aubaim, gehauna Moses ma ghehauna Elijah.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tauhi hi rovo kauwa aubaina da Peter i dede yabayababa. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Anina ma hapau i hura ma tauhi i puruhi ma pona hapauwei i hopui ma i riwa ipa, “Weꞌi Taꞌu Natuꞌu, aꞌu nuwavainana ona rau-tanighanei!” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Maratagogi tauhi hi inana viravira ma egha aiyaꞌi ghehauna hita inanai, maitehi, eꞌegha da Yesu tau avana. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ma tauhi maranai oya damonei hi ghaꞌighaꞌirai ma Yesu tauhi ivi ghaehi da aiwaꞌi hi inainanaiya egha hinavi heghai da au naona Rava natuna hiragheyei inavo mahirime ");
INSERT INTO wed_topura_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma tauhi, tauna riwana hivo teꞌeteꞌei ma hivi tarapiri vivira hipa, “hiragheyei vomahirime,” anona aiwaꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma tauhi tauna hi rau-bayadei ipa, “Aiwaꞌi aubaina raugagayo tauvi haraharamanahi he ririwa da Elijah au naona ina neꞌi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu i pari-beyei, “Anina Elijah, ina ai nememei da aiwaꞌi anatapuna inavo kaukauwehi. Aiwaꞌi aubaina warihagha i girumi da Rava Natuna inavi nuwaꞌapoapoei kauwa ma hina hini dodorei. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma a ririwemi da Elijah anina i neꞌi, rava ahi ghohana tauna awarina hi kauwana pahiyei me i girugirumia nanaꞌarena.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu ana tauvotaghotagho tonugha maiteni oyei hi ghaꞌighaꞌiramemei ahi rava auwarihi, hi inanai da patara ghaeghaena tauhi hi mae kwavivirohi ma mai Jew ahi raugagayo tauvi haraharamanahi maitehi hivivi pariparighahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Maranai, tauhi Yesu hi inanai hi ghohorihi ma hi veraubeyebeyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu tauhi i rau-bayadehi, “Aiwaꞌi ovivi pariparighahiyei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Oroto tagogi patara au horahi i pari-beyana, “Tauviharaharamana aruwa-apoapoena natuꞌu orotona au horana e maꞌamaꞌae ma i kauwei da egha ita dedede, Yamna aubaina a neiyai awarim. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maranai ana doria e huruhuru meyei, Yamna aruwa-apoapoena tauna au dowa e tawatawanei, gamona evivi puropuro, ivo na e utaꞌuta didini ma e hirahiraghe madigha. Am Tauvotaghotagho avi baghahi da aruwa-apoapoena hitavi hopuni, wate egha tagotagogina da hita kauwei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma Yesu i pari-beyehi, “O ma meyanai onavi tumaghana! Ta maeghagha ma aubaimi yohora da ami vita ana avaꞌavarai? Tevera ona neiyai awariꞌu!” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma tauhi tevera hi neiyaꞌi Yesu awarina. Ma maranai aruwa-apoapoena Yesu i inanai, tevera i ghohai da i rau-moyaghahu, i tawanei au dowa ma ivo vai tatatavi ma gamona ivi puropuro. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu tevera amana i rau-bayadei, “Ana doria mara aiwaꞌi ivi kareni?” I paribeyei ma i riwa, “Au meyameyanei ivi kareni. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aruwa-apoapoena mara maghamaghauna tauna au eyagi araꞌaratana ma au waira e tawatawanei ma i ghohei da itavi hiragheni. Mepa da tam tagotagogina yamna ma raunuwaꞌapoapoeyeai ma mavo hagui.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu tauna i riwei, “Menanaꞌarena ma u riwa, ‘Mepa da tam anina?’ Aiyaꞌi ravana evivi tumaghana, God aiwaꞌi anataputapuna ina kauwanapahiyei tauna aubaina!” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Maratagogi teverana amana i garara, “A vitumaghana. Wate aꞌu tumaghana i tapia aubaina ma mavohagui da ma vovai raꞌatai!” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu i inana da patara yohora da i riyeriyehi auwarihi, aubaina aruwa-apoapoena i hegari ipa, “Tam aruwa tanighapota ma dede egha, Taꞌu a hegahegarim da tevera ma hopu tawanei ma egha meyanai ma ruina meyei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma aruwa-apoapoena i garara ma teverana ivo vaitatatavi ma i hopu tawanei. Ma tevera inanana me taubeu ma rava kampa hi ririwa, “Tauna i hiraghe!” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Yesu au urana ivo wa ma i sinahepai da i mahiri. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muriyai Yesu ana Tauvotaghotagho maiteni hi rui au numa ma maranaina tauhi ava ma hi pari-dadanei hipa, “Aiwaꞌi aubaina tauꞌai egha tagotagogina da aruwa-apoapoena atavi hopuni?” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tauna tauhi i riwehi, “Aruwa apoꞌapoeihi me we nanaꞌarehi yamna pariyei ava inavi hopuni” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu ana Tauvotaghotagho maitehi dobuna hi netawanei ma Galiliyei hi nae. Yesu egha ita ghohei da rava hita haramanei da tauhi kampa, ");
INSERT INTO wed_topura_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aubaina tauna ana Tauvotaghotagho ivivi haraharamanihi ipa, “Tauhi Rava Natuna hina amverenei rava ghehauhi au urahi ma tauhi hinavi hiragheni, wate maratom tonugha au murina inavo mahirime.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma tauhi egha hita haramanei tauna aiwaꞌi i dededei ma tauhi raubayadana hi rovowei. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu ma ana Tauvotaghotagho au Capernaum i gheꞌeta ma au numa hi rui ma tauna tauhi i rau-bayadehi, “Au etanaꞌi aiwaꞌi ovi awahe gahigahiyanei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wate tauhi hi genuwana, aubaina au etanaꞌi, tauhi hivi awahe gahigahiyana da aiyaꞌi itavi bada. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tauna i tughura ma Apostle 12 i ghorehi awarina ma i riwehi ipa, “Aiyaꞌi e ghoheghohei da inavi bada tauna ina tereghaꞌirana meyei ma anatapuna inavi taunoyei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tauna tevera i vaini ma au pouhi ivi mahirini ma i tarahaghavui. Ma tauhi i riwehi ipa, ");
INSERT INTO wed_topura_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ma aiyaꞌi ravana taꞌu wavaꞌuwei teverana e rau-warowarorowei yamna taꞌu maiteu evivi anineu ma tauparitawaneu maiteni evivi aninei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John Yesu i riwei, “Tauviharaharamana, tauꞌai oroto tagogi a inanai tam wavamei aruwa-apoapoehi ivi hopunihi ma tauna egha turata yamna aubaina avi ghaei da egha ina kauwana meyei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu i riwa, “Egha onavi ghaei, egha tagotagogina da matakiraha ina kauwei au wavaꞌu ma naꞌi au marana inaparivai apoꞌapoeniu ");
INSERT INTO wed_topura_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aiyaꞌi ravana egha ata ghavia yamna tauna turata. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taꞌu a ririwana kauwemi mepa da aiyaꞌi ravana waira i veremi aubaina tam aꞌu tauvotaghotagho, tauna ana maiha apo egha ina vineboai ma apo ina tuhaghai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mepa da ayaꞌi ravana, we rowarowahi ina kauwei da ahi tumaghana awariꞌu ina peꞌu ma ghoha apoapoe i kauwei, God tauna ina kovogha guratei. Egha me ghaꞌima ghaeghaena rava au uwana e raghiraghihi ma au boga e tawatawanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mepa da uꞌram i kauwem da ghoha apoapoe u ghohai, ma bori da ma tawanei. I ahi da uꞌram tagogiava ma yawahana ahiꞌahina ma tuhaghai ma egha ita ahi da uꞌram ruwagha ahi ahihi ma manae au Gehena*, mepa eyagi araꞌaratana egha meyanai ita bohobohoyana. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mepa da aem i kauwem da ghoha apoapoena u ghohai, ma bori da ma tawanei. I ahi da ana ae kukukum ma yawahana ahiꞌahina ma tuhaghai, egha me aem ruwagha ahi ahihi ma ma nae au Gehena*. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma mepa da matam ina kauwem da ghoha apoapoena u kauwei ma vaina tawanei, i ahi da matam tagogiava ma God ana au vibadana ma rui, egha me matam ruwagha ma ma nae au Gehena*. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Naꞌi dobuna kwairoro maꞌemaꞌe nonowahi rava e anianihi ma egha hita hirahiraghe ma eyagi araꞌarata nonowana e araꞌarata. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Maꞌe boꞌaboꞌa au horana ona rau-hiraghe da God inavi aninemi, me purapura e araꞌara ghadari. Ma nanaꞌarena niha au puyo tereterenana God evivi aninei. ");
INSERT INTO wed_topura_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Niha yamna purapura ahiꞌahina. Mepa da anavi nihaniha ina kwaha, apo me ma kauwananei da ina dagihame. Mepa da vibadana onavi ghaighaiyanei, yamna taumi me niha vivimayavaina eghana. Anatapumi ona viniha ma ona maꞌae.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu Capernaum i voterei ma i nae au Judiya ma Waira Jordan i damani da au tupo gheha au maramatanei. Patara maghamaghauhi hi nememei ma tauna ivi haraharamana, me marana ghaeghaena i kaukauweiya nanaꞌarena. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisee ghehauhihi hi ghohei da tauna hita rau-dadani ma yamna aubaina hivi taravirevirei, “Raugagayo e maꞌamaꞌae bo eꞌegha da rava awana inavi aihabei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu i pari-beyehi, “Moses ana Raugagayo aiwaꞌi i riwei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tauhi hi riwei, “Moses ana raugagayo i riwa da oroto viaihaba pepana ina girumi da awana ina verei ma muriyai hinavi aihabei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu tauhi i pari-beyehi, ipa “Moses raugagayona i terei aubaina taumi horami hi pota. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wate ona notai da au karena maranaina God rava i kauwehi, ‘Tauna i kauwehi da oroto ma wavine. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ma yamna aubaina, oroto amana ma ayona inavo terehi ma awana maiteni hinavi tagogi ");
INSERT INTO wed_topura_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma wavine maiteni hina maꞌae,’ da tauhi tupuwa tagogi, egha ruwagha me au naona. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God ivi tagogiyeta, egha ayaꞌi inavi yamonei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Muriyai hi wanavira meyehi au numa ma weꞌi kauwana aubaina, Yesu ana tauvotaghotagho Yesu hi rau-bayadei. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu i pari-beyei ipa, “Mepa da oroto awana ivi aihabei ma wavine ghehauna i ravaghi, yamna awana wadubona ivi gobuꞌani.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma mepa da nanaꞌarena wavine awana ivi aihabei ma oroto ghehauna i ravaghi, yamna awana wadubona ivi gobuꞌani. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Rava ghehauhi rowarowa hi neiyai da Yesu itavi ahiahinihi ma ana Tauvotaghotagho ravahi hi pari-vivighaehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Maranaina Yesu wei kauwana i inanai, i rau-amoghaighai ma ana Tauvotaghotagho i riwehi, “Rowarowa ona voterehi da hina nei awariꞌu, egha onavi ghaehi aubaina God ana vibadana yamna rava aubaihi me we rowarowahi nanaꞌarehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A ririwana kauwemi, aiyaꞌi ravana God ana vibadana egha ina vaini, me tevera haburuna, tauna egha God ana au vibadana ina rui. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma rowarowa i taravainihi au naona, urana au koyahi i terehi ma i raupari ma ivi ahiahinihi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu ivo mahiri da i naenae, oroto i ruba awarina ma au naona i raudune ma i riwa ipa, “Tauviharaharamana vinuwavaivainana, aiwaꞌi ana kauwei da yawahana ahiꞌahina anavi buderiyei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Yesu i pari-beyei ipa, “Aiwaꞌi aubaina, Taꞌu uvi kauwa vinuwavaivaineu? God tauna ava vinuwavaivainana. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tam God ana raugagayo u haramanei: ‘Egha mavi hiraghena, egha awam mavi gobuani, egha ma danene, egha mavi wavu moru, egha moruwei ma danane, Amam ma Ayom mavi virehi.’” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ivi heghana meyei ipa, “Tauviharaharamana, haburuꞌuwei da marina, weꞌi raugagayohi a votaghotaghopahi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu tauna i inanai ma ivi nuwavainei ma i riwei, “Kauwa tagogi ava egha uta kaukauwei. Ma nae me da am mahura anataputapuna ma gimarehi ma manena, rava viyamoyamonahi ma verehi, God, tam, au mara inavi maihem. Ma ma nememeꞌi da ma votaghotaghou.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma maranaina oroto weꞌi i nonori, i nao hariri ma ana nuwaboyana i nae, aubaina tauna rava mahumahurana. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu i inana viravira ma ana tauvotaghotagho i riwehi, “I piripiri guratana da rava mahumahurana we au dobuna, God ana au vibadana ina rui.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tauvotaghotagho, riwana hi buꞌuwei, maranai Yesu wenanaꞌarena i babani ma Yesu i riwana meyehi, “Natunatuꞌu, i piripiri guratana da mahura ravana God ana au vibadana ina rui. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ma egha ita piripiri da ghamoghamo ghaeghaena wavana kamel, i ghoma au matana ina rui wate i piripiri da i piripiri kauwa da mahura ravana, ana yawahana God ina verei ma God tauna inavi badei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tauvotaghotagho ahi nota i hamoꞌa ma tauhi ava inavi tarapiri ipa, “mepa da nanaꞌarena apo aiyaꞌi yawahana maemaenonowana ina vaini?” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu inanahi ma i riwa, “Rava auwarihi wei kauwana i piripiri, Ma God awarina eꞌegha; God awarina aiwaꞌi anatapuna yamna anina ava.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter, tauna i riwei, “Ma inanai, tauꞌai menanaꞌarena? Aꞌi purapura a voterehi ma tam avotaghotaghom.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu i pari-beyei, “A ririwana kauwemi, aiyaꞌi da ana numa, varevarehina, novunovuna, ayona, amana, natunatuna, ana debagau inavo terehi, taꞌu ma riwa ahiꞌahina aubaina, ");
INSERT INTO wed_topura_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tauna ana maiha ina raꞌata vavahagha maraina tauna weka emaꞌamaꞌae. Tauna ana numa, varevarehina, novunovuna, ayoyona, natunatuna, ana debagau, anatapuhi hina magha. Rava maiteni hina rau-iviꞌapoapoeyehi; ma mara au murina yawahana maemae vavahaghana ina vaini. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wate maghamaghauhi hevi vinao, hinavi muri ma hevivi muri hinavi nao.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ma ana tauvotaghotagho etenaꞌiyei hi ghaeghae au Jerusalem ma Yesu etanai i raveraveni ana tauvotaghotagho hivi nuwanaina aiwai aubaina da tauna eta i rave raveni, patara ghehauhi hivivi muri tagho maitehi hi rovo kauwa. Tauna, Aposel 12 i taravainariyehi ma aiwaꞌi kauwana ina tuputupuwa awarina, dededena ivi kareni. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ma tauna tauhi i riwehi, “Ona haramanei da tauta ta ghaeghae au Jerusalem, yamna Rava Natuna ina am verenei, pirisi ghaeghaehi ma raugagayo tauvi haraharamanahi auwarihi ma tauhi tauna ana hiraghe hinavi aninei ma eteni ravahi a warihi hina am verenei. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tauhi hinavi diboghi, hina hovai, hina kwapui ma hinavi hiragheni ma mara au vitonuina inavo mahirime.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","James ma John, Zebedi natunatuna, hi nei Yesu awarina ma hivi baghai, “Tauviharaharamana, a ghoheghohei da aiwaꞌi anavi vibaghaiya ma kauwei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma i riwehi, “Aiwaꞌi o ghoheghohei da aubaimi ana kauwei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tauhi hi pari-beyana hipa, “Ma vianineꞌai da tauai tagogi au ahuohohim au mara, tam maitem ana tughura ma ghehauna au ahukehakehaum ina tughura am au boruma.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu i riwehi, ipa, “Taumi egha ota haramaneꞌi aiwaꞌi ovivi baghei, Taumi hini viyara keyakana a umeꞌumeiya apo moina ona uꞌmeꞌi? Ma babataito a bababataitoweiya apo moina ona babataitowei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tauhi hi pari-beyana hipa, “Tauai apo ana ghohai” Yesu i riwehi ipa, “Keyaka aꞌumeꞌuꞌmeiya ona uꞌmeꞌi ma babataito a bababataitoweiya ona babataitowei, ");
INSERT INTO wed_topura_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ma au ahuohohiꞌu ma au ahukehakehaꞌu tughurana, ghutana taꞌu egha atavivi badei ma wei gabuhi yamna tauna ivo kaukauwei tauhi ayaivoi da hivo kaukauwa aubaihi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Maranaina Aposel 10, weꞌi dedena hi nonori, tauhi hi rau-amoghaighai James ma John auwarihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu tauhi ivi tagogiyana meyehi ma i riwehi, “Taumi aꞌu rava ona haramanei da eteni ravahi ahi babada hivi riwapana kauwa, yamna aubaina da rava au gabaurihi he rau-iviꞌapoꞌapoeyehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma taumi awarimi apo egha nanaꞌarena. Aiyaꞌi ana ghohana da au poumi inavi bada, yamna inavi taunoya, ");
INSERT INTO wed_topura_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ma tauna aiyaꞌi i ghoheghohei da ina teregheꞌetana meyei yamna inavi taunoya, anatapumi aubaimi. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tau Rava Natuna, egha ata nei da onavi taunoyei eꞌegha da tau ana vitaunoya ma au yawahana ana amverenei rava maghamaghauhi ahi yawahana gimara meyanana aubaina.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tauhi hi nei au Jericho. Ma marainana, Yesu ma ana tauvotaghotagho ma patara ghehauhi maitehi Jericho hi hopuhopu tawanei, Mataꞌapoapoe Bartimaeus Timaeus natuna, etanai au ririvana i tughutughura ma ivivi gigimana. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma maranaina i nonori da Yesu Nasaretei i naenae, tauna i garara, “Yesu, David natuna, ma rau-nuwaꞌapoꞌapoyeꞌu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Patara hi pari-ghahiyei da ita genuwana ma eꞌegha da tauna i garara guraguratana, “David natuna, ma rau-nuwaꞌapoꞌapoyeꞌu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu i tumahiri ma i riwehi, “Ona ghoreiyaꞌi” Anina ma mataꞌapoapoe hi ghorei, “Mavi nuwa ahiahi ma ma vomahiri Tauna e ghoreghorem.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Puru i tawananaiyei ma ivi hauhepa ma i nei Yesu awarina. ");
INSERT INTO wed_topura_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu i rau-bayadei, “Aiwaꞌi ana ghohai aubaim?” Mata apoapoe ipa, “Tauviharaharamana, a ghohei da ana inana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma Yesu i pari-beyei, “Ma nae, am vitumaghana, ivi yawahanim.” Ma maratagogi i inana ma ivo taghoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tauhi Jerusalem hi tutugheregherei, au Bethphage ma Bethany, Olives oyana au gheregherena ma ana tauvotaghotagho ruwagha i aiparitawanehi, ");
INSERT INTO wed_topura_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma we nanaꞌarena i riwehi, “Ona nae meyagaina au naota awarina ma marainana au meyagaina ona ruirui, apo donki ghaubona raghiraghitana ma egha aiyaꞌi ita gerugeruiya ona inanai, ona kaiweni ma weka ona neiyai. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","We kauwana ona ghohaghohai ma aiyaꞌi ina rau-bayademi da aiwaꞌai aubaina o ghohaghohai, yamna ona riwei, ‘Bada i ghoheghohei, mara tupona ava aubaina ma inapari tawanana meyeiyai.’” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tauhi hi nae da donki raghiraghitana, metaeta au naona hi inanai ma hi kaiweni. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Taumahiri, hi inanahi ma hipa, “Aiwaꞌi aubaina donkina o kaikaiweni?” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesu ponana hi pari-verehi ma tauhi hivi aninehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Donki hi naiyei Yesu awarina ma gara au uputuwana hi hesi ma tauna i geru. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Rava maghamaghauhi gara au etanai hita uri ma ghehauhi ai ruguruguna hi yavahehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma rava ghehauhi etanai hi raveni ma ghehauhi hivi muri ma hi garagarara: “Hosanna, viahiꞌahinana, aiyai tauna God wavanei, i neꞌi, ");
INSERT INTO wed_topura_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Viꞌahiꞌahinana, e nenei da inavi bada me amata David; Hosanna au aidamo.” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu au Jerusalem i rui ma i ghae au temple, aiwaꞌi anatapuna i tuvirevirei ma madegha i kwahakwaha aubaina ana Aposel 12 maitehi hi nae au Bethany. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mara tomgheha, tauhi au Bethany da hi ghaeghae au Jerusalem ma Yesu am i hiraghe. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Au uwama ma kaiyaha ana ruguruguna i inanai, i nae da ita inanai, anaꞌanona bo eꞌegha. Kaiyahana ruguruguna ava aubaina ai uwauwa egha ahi mara. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ana tauvotaghotagho, hi rau-rautanighana ma kaiyahana i kuvari, “Egha meyanai aiyaꞌi anom ina ammeyei!” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Maranana au Jerusalem hi gheꞌeta ma Yesu au temple i rui ma tauvi gimagimara ivi yaghaghana hopunehi. Mane tausenisihi ma kiu taugimarehi ahi teiboro ma ahi anitughura ivi touvirahi, ");
INSERT INTO wed_topura_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ma ivi ghaꞌa da temple au orana egha aiyaꞌi inavi gimagimara. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Viharaharamana ivi kareni ma i riwehi, “God riwana hi girumi da, aꞌu numa yamna pari numana aubaihi ma taumi o ghohai da me taudanedanene ahi gabu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pirisi ghaeghaehi ma raugagayo tauvi haraharamanahi hi nonori mavi hiraghenana ogatarana hivi kareni, anona tauhi hi rovowei aubaina patara ghaeghaenana ana viharaharamana hi bahebahei. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aubigai, Yesu ana tauvotaghotagho maitehi Jerusalem hi netawanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hubahubanai tauhi hi naenaeme ma kaiyahana hi inanai da i poi. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter Yesu ana dede i notai ma i riwei, “Ma inana! Kaiyahana u kuvakuvariya i hiraghe.” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu i pari-beyehi, “God awarina onavi tumaghana. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A ririwana kauwemi, aiyaꞌi da wei oyana ina riwei da inavo mahiri ma ina tawanana meyei au boga ma egha ina nuwahaburu ma aiwaꞌi i yatoyatoniya inavi tumaghanei apo i ririweiya ina tupuwa. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wei yamna aubaina a riwemi, maranana o rau-raupari ma aiwai ovivi baghei ma ovi tumaghana da o vaini ma aiwai ovivi baghei God ina veremi. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ma marainana o rau-raupari, maeturaturam ahi ghohaboa awarimi ona nota tawanei, yamnei amam au mara taumi ami ghohaboꞌa ina nota tawanei. Ma ina pa egha ona nota tawanei apo amami au mara egha ami ghohaboꞌa ina nota tawanei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tauhi hi nememei au Jerusalem ma Yesu temple au horana i rui, piripirisi ghaeghaehi, raugagayo tauvi haraharamanahi ma babada ghehauhi hi nei Yesu awarina, ");
INSERT INTO wed_topura_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ma hi rau-bayadei, “Aiwaꞌi riwapananei wei ghohahi e ghohaghohahi? Aiyaꞌi riwapanana i verem?” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu i pari-beyehi, “Taꞌu raubayada tagogi ana raubayademi ma ina pa onapari beyeꞌu, yamna ana riwemi da aiwaꞌi riwapananei we ghohahi a ghohaghohai. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ona riweꞌu, John mepa ana riwapana i vaini da i bababataito: yamna Godei bo ravei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tauhi hivi tarapiri vivira, “Aiwaꞌi tana yatoni? Ina pa tana riwa da Godei; apo ina pa, aiwaꞌi aubaina da John egha otavi tumaghanei? ");
INSERT INTO wed_topura_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ina pa tana riwa da ravei...” Tauhi rava hi rovowehi aubaina rava anataputapuhi hi ririwa da John anina peroveta. ");
INSERT INTO wed_topura_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yamna aubaina tauhi Yesu hi pari-beyei hipa, “Tauai egha ata haramanei.” Yesu tauhi i riwehi, “Yamna aubaina da taꞌu egha ana riwemi, aiwaꞌi riwapananei we kauwahi a kaukauwehi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Anina ma Yesu awanaꞌinei auwarihi i dede, “Mara tagogi oroto grape vaovaona i vaghoi, i gari, grape anibuyona i gharai ma anivipaꞌipaꞌi numana ivo wai.” Anina ma rava ghehauhi auwarihi i am verenei da grape vaovaona hitavi bagibagi ma tauna i nae au dobugheha. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Marainana grape tamana ana mara i gheꞌeta, ana taunoya i pari-tawanei da ana ruva vainana aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Grape vaovana tauvi bagibagina ravahi, taniwaga ana taunoya hi vunuboꞌai ma kwakwavina hi pari-tawanana meyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Taniwaga, taunoya ghehauna i pari-tawanei ma grape vaovaona tauvi bagibagina ravahi, koyana hi rau-mutumutui ma hivi tepahubai. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ma taunoya ghehauna i pari-tawanei ma tauna hivi hiragheni ma kauwana tagogina hi kauwei taunoya ghehauhi auwarihi, ghehauhi hi rau-mutunaiyehi ma ghehauhi hivi hiraghenihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Rava tagogiava i maeterei yamna taniwaga natuohohina ma au damona taniwaga natuohohina ana nuwavainana, i pari-tawanei ma ipa, “natuꞌu, hinavi virei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma grape vaovaona tauvi bagibagina ravahi, hi riwanameyehi hipa: weꞌi taniwaga natuna, ona neꞌi, tana vunui ma ana grape vaovaona tanavi taniwagei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Anina ma tauhi taniwaga natuna hi vunui ma hivi hiragheni ma tupuwana hi tawanana hopunei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu i rau-bayada, “Grape vaovaona taniwagana aiwaꞌi ghehauna ina ghohai?” Tauna ina nei da grape vaovaona tauvi bagibagihi inavi pupuhi ma grape vaovaohi rava ghehauhi ina verehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Taumi warihagha hi girugirumiya o hiyavi bo eꞌegha? “Tau raunuma tuwatuwaꞌoroto hi paripari-viraiya muriyaꞌi hi inana da tauna tuwatuwa kauwa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Weꞌi yamna Bada i ghohai; ma au matata inanana i ahi kauwa. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jew babadahi hi ghohei da Yesu hita pani, anonana tauhi hi haramanei da wei awanaꞌina yamna tauhi e dededehi. Wate tauhi patara hi rovowehi aubaina hi voterei ma hi nae. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Parisis ma Herod ana rava, ghehauhi hi pari-tawanehi, da Yesu hita rau-dadani. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hi nei awarina ma hi riwei, “Tauviharaharamana, tauai a haramanei da tam egha uta morumoru, ma utavi bainaenae. Anonana tam egha rava uta rovorovowehi ma riwa kauwei God ana ghoha evivi haraharamanei. Ma riweꞌai da raugagayo e maꞌamaꞌae bo eꞌegha da Rome ahi guyau wavana Sisa ana takisi atavi maihei? Tauꞌai ana vimaiha bo eꞌegha?” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma Yesu ahi moru i haramanei, aubaina i pari-beyei, ipa, “Aiwaꞌi aubaina o rau-raudadaniu? Roman manena ona neiyaꞌi da ana inanai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mane tagogi hi neiyaꞌi Yesu awarina ma i rau-bayadehi, “Weꞌi ayaꞌi aruwana ma wavana?” Ma hi pari-beyei, hipa, “Sisa wavana ma aruawana” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu i riwehi, “Yamna aubaina, aiwaꞌi da Sisa gharinei, Sisa ona verei ma aiwaꞌi da God gharinei, God ona verei.” Ma Yesu hi bahei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi ghehauhi, hiragheyei vomahirina egha hitavi tumaghanei yamna aubaina hi nei Yesu awarina ma hi rau-bayadei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tauviharaharamana, Moses ana raugagayo wenanaꞌarena i girumi aubaita: mepada oroto ina hiraghe ma hiwapena egha itavi natuna, orotona ana teverana hiwapena ina ravaghi da rowarowa hinavi tupui da turana hirahiraghena aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mara tagogi oroꞌoroto 7 (ayohi tagogi) ma hi maꞌamaꞌae. Tautuwagha i tavine da egha natunatuna ma i hiraghe. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ma viruwaina wavinena tagogina iravaghi. Wate nanaꞌarena egha hitavi natuna ma orotona i hiraghe. Kauwana tagogina turahi vitonuina awarina i tupuwa, ");
INSERT INTO wed_topura_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","maemae terenahi 7 wavinena tagogina hi ravaghi ma egha hitavi natuna ma hi hiraghe. Au damona wavinena i hiraghe. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Maranaina vomahirime ana au mara metauna orotona apo awana?” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu i pari-beyehi ipa, O nota boꞌa ghagha! Ma o haramanei aiwaꞌi aubaina? Anonana taumi God riwana ana riwapana egha ota haramanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maranaina hirahiraghehi, hiragheyei, hina vomahiri, yamna tauhi me aneya au mara ma egha hina tavine. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma marina, hirahiraghehi ahi vomahirime, vitarapirina. Moses ana buka o hiyavi bo eꞌegha; eyagi i araꞌarahiyana awarina, kampa i girumi da, God, Moses i riwei, “Tau Abraham ana God, Isaac ana God ma Jacob ana God. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yamna yawayawahanihi ahi God ma egha hirahiraghehi. Anina o nota boꞌa kauwa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anina ma raugagayo tauvi haraharamanana tagogi, i neꞌi ma aiwaꞌi hivivi tarapiriyei i nonori ma i inanai da Yesu, Sadusi, i pari-beyana kauwehi. Yamna aubaina i nei Yesu awarina ma i rau-bayadei, “Metauna raugagayona i gheꞌeta guratana?” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu i pari-beyei ipa, “Raugagayo ghaeghaena ma gheghe guratanana weꞌi: ‘Mai Israel ona rau-tanighana! Bada ata God yana tauna ava ata Bada. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nuwanuwami taputapunei, horami taputapunei, ami nota taputapunei ma ami riwapana taputapunei onavi nuwavainei.’ ");
INSERT INTO wed_topura_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Raugagayo gheghe guratanana, viruwaina yamna weꞌi: ‘Rava ghehauhi mavi nuwavainei me tam evivi nuwavaina meyem nanaꞌarena. Weꞌi raugagayohi ruwaghahi i ghe vavahagha, egha me ghehauhi nanaꞌarena.’” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Raugagayo tauvi haraharamanana, Yesu i riwei, “U riwa kauwa, God tagogiava ma egha mepa ghehauna ita maꞌamaꞌae.” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yamna aubaina God mavi nuwavainei, horam taputapunei, am nota taputapunei ma am riwapana taputapunei ma maeturam mavi nuwavainei me tam evivi nuwavaina meyem, nanaꞌarena. Wei raugagayohi ghe guratana egha me puyo apuꞌapunana bo puyo ghehauhi nanaꞌarena. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu ravana, mayana i vaini da nuwahuyehuyei i pari-beyana aubaina da i riwei, “Wei raugagayohi i raꞌata guratana egha me puyo araꞌaratana bo puyo ghehauhi nanaꞌarena.” Wei au murina, egha ayaꞌi ghehauna, ita rau-tepatora da Yesu ita rau-bayadana meyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu au temple ivivi haraharamana ma wenanaꞌarena i rau-bayada, “Aiwaꞌi aubaina, raugagayo tauvi haraharamanahi, he ririwa da Mesaiya yamna David, natuna? ");
INSERT INTO wed_topura_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aruwa Vivivireina David i rau-hepai da we nanaꞌarena i riwa: ‘Bada aꞌu Bada, i riweꞌi. Weka, au ahuohohiu ma tughura, da maranana am ghaviya, aem au gabaurina ana terehi.’ ");
INSERT INTO wed_topura_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“David taunei e ririwa da au Bada menanaꞌarena ma Mesaiya, David natuna?” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu ana au viharaharamana, ipa, “Raugagayo tauvi haraharamanahi ona inana kauwehi. Tauhi hi ghohei da gara manamanaihi hina oteni ma hina bababaranae, boru au gabuhi ma au maketi rava anavi virahi, hina nenebeyehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pari au numana tauhi anitughura, vinevinena he vaivaini ma au toreha, gabu ahiahihi he vaivaini. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tauhi hiwahiwape he rau-kwayekwayehi ma he rau-iviꞌapoapoeyehi ma pari manamanainei au matamata hevivi morumoru. Tauhi ravahi nanaꞌarena ahi kovogha ina raꞌata guratana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Maranaina Yesu mane aniterenana au ririvana i tughutughura ma ivi neneghana ma rava hi puyopuyo. Rava mahumahurahi mane ghaeghaena ma maghamaghauhi hi tereterei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Anina ma hiwape dabudabuꞌarana, i nei ma ana puyo mane haburuna i terei. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu ana tauvotaghotagho i rau-ghoreghorehi ma i pari-verehi, “A ririwana kauwemi, Weꞌi hiwapena dabudabuꞌarana ana puyo i teretereꞌiya yana i raꞌata guratana egha me rava ghehauhi. ");
INSERT INTO wed_topura_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Rava ghehauhi ahi mahura maemaeterenana hi puyowei ma wei wavinena dabudabuꞌarana, aiwaꞌi da awarina i maꞌamaꞌae, anatapunana i amverenei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Maranaina Yesu temple i hopuhopu tawanei ana tauvotaghotagho tagogi i riwai ipa, “Tauviharaharamana ma inanahi, ghaꞌimahi hi raꞌata ghagha ma numahi inanahi hi ahi ghagha!” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu i pari-beyei, “Weꞌi numahi ahiahihi, e inainanahi hina dabarara pahi da egha metauna ana au gabu ina mae terei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu Olives au oyana i tughutughura temple au baba ghehauna ma Peter, James, John ma Andrew hi nae da govagovaghanei hi rau-bayadei. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ma riweꞌai, wei kauwahi meyanai hina tupuwa ma matakirahana aiwaꞌi” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu i riwehi “Ona inana kauwa da egha aiyaꞌi ina morumi, ");
INSERT INTO wed_topura_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muriyai rava wavaꞌuwei hina nei. Ma hina riwemi da, yamna Keriso ma rava maghamaghauhi hinavi deghahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maranai ghaviya tuyeghana ma gugurana u nonori, egha ma rovorovo. Weꞌi kauwahi hina tupuwa, wate yamna egha damona. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dam hina vomahiri ma dam ghehauhi maitehi hinavi tonavivira ma guyaguyau hina vomahiri ma hinavi tonavivira. Yoyo ma gomara, dobu ghehauhi auwarihi hina tupuwa. Weꞌi kauwahi yamna me wavine ana viyara evivi kareni vinatuna au marana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Matami ina kaya ma ona inana kauwa! Rava hina panimi ma hina naiyemi rauhetara au gabuna. Ma pari au numana hina kwapumi ma babada da guyaguyau hina rau-hetahetaremi ma aubaiu onavi taudede. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wate muriyai da mara damona ina gheꞌeta, tuyegha ahiꞌahina, rava anatapuhi auwarihi hina rau-guguyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Maranaina hina panim, rauhetara aubaina, aiwaꞌi ona yatoyatoniya aubaina egha onavi nuwaboya. Rauhetara au marana aiwaꞌi o yatoyatoniya anina ona yatoni, aubaina na riwana yamna egha tamei ma Aruwa vivivireinei. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Rava varehihi hinavi benabenamehi ma hinavi hiraghenhi, ama nanaꞌarena natuna auwarihi ina kauwehi. Ma rowarowa amamahi da ayoyohi hinavi ghaviyehi ma hinavi hiraghenihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Rava anatapuhi hinavi ghaviyemi aubaiu. Ma aiyaꞌi da evivi patutu ghavata au damona ina yawahana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu i riwa, “Apo inana vihini rovorovona au naomi, ona inanai, mepa egha uta ghoheghoheiyana, ina mahimahiri.” (Ona haramanei da weꞌi anona aiwaꞌi) “Tauhi au Judiya maemaehi hina ruba da hina nae au oya. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aiyaꞌi numa au tepana, e maꞌamaꞌae egha ina ghaꞌira numa au horana, purapura vainana aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nanaꞌarena aiyaꞌi da ana au vaovao evo vobagibagi egha ina naeme au numa, ana puru vainana aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Waivine duwaduwamahi mavivi ghughuhi apo hinavi nuwa apoapoe kauwa ");
INSERT INTO wed_topura_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","God onavi baghai da weꞌi kauwahi egha ina tupuwa au marahuba. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ma nai au marana vinuwaꞌapoꞌapoe ma hini viyara ghaꞌeghaꞌena ina tupuwa. Marainana God dobu i kauwei ma i nei da marina egha nanaꞌarena ita tupuwa. Ma egha meyanai ina tupuwame. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bada mara i ravi tupoi da rava hina yawahana ma ita pa eꞌegha, apo egha aiyaꞌi ghehauna ita yawahana dadana. Bada ana rava vinevinehi aubaihi da mara ivi tupoi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nai au marana mepa aiyaꞌi da e ririwem, ‘Mesaiya weka’, bo ‘Ma inana, Mesaiya noꞌore!’ Egha mavi tumaghanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anona yamna Mesaiya ma peroveta morumoruhi he nenei. Tauhi apo matakiraha ma anibaha kauwahi hina kauwehi, rava ma God ana rava vinevinehi maitehi hitavi deghahi. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Matami ina kaya ma ona inana kauwa! Aiwaꞌi anataputapuna a riwanapahiyemi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Wate nai apoꞌapoena au murina, ‘madegha egha ina rarana ma nawaravi ina gimtonei. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Au yada Kipora hina dabadabarara’ ma mara purapurahi ghaeghaehi ma viviriwapanahi hinavi guhuguhu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ma nai au marana, Rava Natuna hapauwei ana riwapanana ma ana boruborumana ona inanai ina neꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma tauna aneya inapari tawanehi da hina nae dobu au mutuna da au mutuna ma God rava i vinevinehi anatapuna hina taravainihi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Anina ma Yesu i riwa, “Kaiyaha ona inanai ma inavi haraharamanimi. Maranaina raghana e numonumo, ma haramanei da aiꞌuwaꞌuwa e tuturiyaꞌi. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nanaꞌarena, maranaina, weꞌi kauwahi u inanai da e tuputupuwa yamna ma haramanei da Rava Natuna e tuturatum. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taꞌu, anina a ririwemi, weꞌi kauwana ina tupuwa, muriyai da rava we au dobuna maemaehi hina hiraghe pahinihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mara ma dobu ina hamoꞌa wate taꞌu riwaꞌu egha meyanai ina hamoꞌa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Egha aiyaꞌi ita haramanei, Bada me au madeghana bo au marana ina nei, egha aneya au mara bo Natuna, anina, Amana tauna ava i haramanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Onavi neneghana! Matami ina kaya! Egha ota haramanei mara aiwaꞌi nai marana ina gheꞌetai. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Me oroto au dobugheha e naenae ma ana numa e nenetawanei ma tau-bagibagi vibadana i verehi da ana numa hita paꞌini ma metaeta taupainina i riwei, “Ma vipaꞌipaꞌi kauwa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Yamna aubaina onavi neneghana taniwaga ana nememei marana aiwai, egha ota haramanei, mepa da raviraviyai, au poniwana, maratomtom bo hubahubanai. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mepa da ina nememei, egha ma enoeno ma ina ravighorim. ");
INSERT INTO wed_topura_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aiwaꞌi a ririwemi tagogina rava anatapuhi a ririwehi.” Matami ina kaya! Onavi neneghana! ");
INSERT INTO wed_topura_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Madegha ruwagha i maꞌamaꞌae muriyai da Raghona amna ma Payawa dododo eghana torehana ana mara. Piripirisi ghaeghaehi ma raugagayo tauvi haraharamanahi etanai hi baibaihei da govagovaghanei ma Yesu hita vunui da hitavi hiragheni. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hipa, “Wei ghohana, egha toreha au marana, tana kauwei, apo rava hina voghahighahiyawa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Maranaina Yesu au Bethany Simon ana au numa, i maꞌamaꞌae. Simon au naona opina pagapagana, ana au numa i amꞌam ma wavine dadi ghabughabuna maihana ghaeghaena, dadi wavana nard, taunei ava hi kaukauwei. Wavinena reduna i kaiweuni ma Yesu au koyana i hiwaghi. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rava ghehauhi kampa hi maꞌamaꞌae, hi rau-amoghaighai ma hivi tarapiriyei, “Aiwaꞌi aubaina da niura ahiꞌahina ivi kayokayowei?” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ita gimarei da mane ghaeghaena ita vaini da rava vivinuwa apoapoehi ita verehi ma tauhi nanaꞌarena wavinena hi enieni. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu i riwehi, “Ona voterei! Aiwaꞌi aubaina o enieni? Tauna kauwa ahiꞌahina i kauwei aubaiu. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Rava vivinuwa apoapoehi maitehi ona maꞌamaꞌae ma ona vovo haguhi wate taꞌu egha maitemi tana maꞌamaꞌae. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tauna ana bagibagi i kauwei da, niura au opiꞌu i hiwaghi da tupuwaꞌu i ai vokaukauwei am ghurughuruva aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A ririwana kauwemi, mepa aiyai da tuyeghaꞌu ahiꞌahina, e rau-guguyei, dobu anatapuna, weꞌi wavinena aiwaꞌi i kaukauweiya, maiteni hina dededei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Anina ma Judas Iscariot, Yesu ana Aposel tagogi, tauhi 12 au horahi i nae piripirisi ghaeghaehi auwarihi da Yesu itavi benabenamei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Marainana wei riwana hi nonori tauhi hivi nuwa ahiahi kauwa da hiparivai nuwaghani da, mane hina verei. Anina ma Judas, gavogavo i baibaihei da Yesu ita amverenei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Payawa Dododo Eghana Amna vokaukauwana ana au mara, au naonei yamna, sipu ghaubona he vunuvunui Raghona amna aubaina. Yesu ana tauvotaghotagho hi rau-bayadei, “Mepa u ghohei da ana nae ma Raghona amna ana vokaukauwei aubaim?” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Anina ma ana tauvotaghotagho ruwagha, ivi tauririwahi ma i pari-tawanehi, “Ona nae au Jerusalem ma oroto tagogi waira nauna e avaꞌavaraiya ona inanai, tauna onavi muri taghoi, ");
INSERT INTO wed_topura_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","da metauna au numana e ruiruiyana, kampa ona rui ma numa taniwaga ona riwei, ‘Tauviharaharamana i riwa, me au hayana ana tauvotaghotagho maitehi Raghona amna ina ani?’ ");
INSERT INTO wed_topura_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tauna haya au aidamo, ghaeghaena ma vovononoghana inavi heghemi, kampa aubaita ona vokaukauwa.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tauvotaghotagho hi nae au Jerusalem ma Yesu aiwaꞌi i ririweiya nanaꞌarena hi tuhaghai ma Raghona amna hivo kaukauwei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aubigai Yesu ana tauvotaghotagho 12 maitehi hi nei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Maranaina hi amꞌam ma Yesu i riwehi “A ririwana kauwemi, apo au horami rava tagogi inavi benabenameu. Aiyai da maiteni a amam” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Anatapuhi hi rau-genuwanehi ma tagotagogei ava hi rau-raubayada viravira, “Taꞌu bo?” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu i pari-beyehi, “Taumi 12 au horami tauna, aiyaꞌi da ana payawa taꞌu maiteu au aboma avivi gayo tagogi. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Rava Natuna apo ina hiraghe hi girugirumiya nanaꞌarena. Ma aiyaꞌi da Rava Natuna ina amamverenei apo ana yawahana ina apoꞌapoe kauwa. I ahi da ravana havena da ayona ita ghuni!” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Maranaina hi amam ma Yesu payawa i vaini ma God ivi egwayauwei ma ivo tomui ma ana tauvotaghotagho i verehi ma i riwehi, “Ona vaini, weꞌi tupuwau.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Muriyai keyaka i vaini, God ivi egwayauwei ma keyaka i verehi ma hi uma. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","I riwei “Weꞌi taraꞌu, i wanahiwaghi maghamaghauhi aubaihi, taraꞌuna God ana parivai nuwaghana vouna aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A ririwana kauwemi, weꞌi wainina egha meyanai ana umameyei nai au marana da wain vouna ana umai, God ana au vibadana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Anina ma rauwa tagogi hi ravi ma hi nae au Oya Olives. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ana tauvotaghotagho i riwehi, “A ririwemi, anatapumi apo ona rovo ma ona rubatawaneu ma tau avau ana maꞌae, me warihagha i girugirumiya nanaꞌarena. God sipu taupainina, inavi hiragheni ma sipu hina rovo ma hinavi yamonehi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wate God inavo mahirime au murina, anavi nao, au Galili ma muriyai ona nei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter i pari-beyei, “Mepa da ghehauhi hina netawanem ma tau egha meyanai ana netawanem.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu, Peter i riwei, “Taꞌu a ririwem, we au waguvaraina, muriyai da kamkam mara ruwagha ina tou, tam apo mara tonugha ma rau-boviyeu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter pona bagibaginei i pari-beyei, “Havena da hinavi hiragheniu, taꞌu egha meyanai ana rau-boviyem.” Ma tauvotaghotagho ghehauhi nanaꞌarena hi riwa. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu ana tauvotahotagho maitehi hi nei da au Getsameni ma i riwehi, “Weka ona tughura ma ana raupari.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesu, Peter, James ma John i taravainihi ma maiteni hi nae. Yesu nuwaboya horanina i nughunughuri. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yamna aubaina Yesu i riwehi, “Aꞌu nuwaboya i raꞌata guratana da evivi hiragheniu. Weka onavi paꞌipaꞌi ma onavi neneghana.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I veraunae haburuna ma aetutuna au dowa i tapegharowei ma i raupari, mepa da tagotagogina, yamna wei hinivi yarana marina ita veruvireu. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yesu i riwa, “Amaꞌu! Amaꞌu! Aiwaꞌi anatapuna awarim tagotagogina, awariu hini viyara keyakana ma vaina tawanei da taꞌu egha ana umai, wate egha tau aꞌu ghohana ma tam am ghohanei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anina ma i wanavirai ma i inanai da ana tauvotaghotagho hi enoeno, yamna aubaina Peter i riwei, “Simon, o enoeno bo? Apo matami ita kaya mara haburuna bo eꞌegha?” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Onavi neneghana ma ona raupari da egha au rauweyara ona peꞌu. Aruwa i ghoheghohei ma tupuwa i tapia.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","I nae me ma i rauparime da parina au naona i iyatoyatoniya tagogina i yatona meyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tauna i nememei ma i inanahi da ana tauvotaghotagho yohora hi rau-raumatadudu: egha tagotagogina da matahi ita kaya. Ma tauhi hivi nuwanaina da, aiwaꞌi hita yatoni. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mara vitonuina i nememei ma i riwame, “Taumi yohora o rau-matadudu ma ovivi yawahi bo? Raumatadudu anina. Ana mara i gheꞌetai, ona inana, Rava Natuna hi amverenei ghohaꞌapoapoe ravahi, ahi au vibadana. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ona vomahiri ma tana nae. Tauvi benabenameꞌu, ona inanai eneneꞌi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu yohora i dedede ma Judas tauna tagogi, tauvotaghotagho 12, au horana i gheꞌeta. Rava maghamaghauhi, ahi apia dabaruma ma kwasikwasi hivo wahi ma tauna maitehi hi nei. Piripirisi ghaeghaehi, raugagayo tauvi haraharamanahi ma babada ghehauhi, wei ravahi hi hegarihi da hi nei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tauvi benabenama ana matakiraha patara ivi heghehi, “Metauna orotona ana taratara haghavuiya ma navanavana ana yaghoyaghoniya tauna ona vodidini, ona pani ma ona taravaina naiyei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Maranaina Judas i gheꞌeta ma i nae Yesu awarina ma i riwei, “Tauviharaharamana” ma i tarahaghavui ma navanavana i yaghoni. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Anina ma Yesu hivo didini ma hi pani. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wate Yesu ana tauvotaghotagho ghehauna kampa i mahimahiri, kwasikwasi i sina yavui ma pirisi ghaeghaena ana tau bagibagi tanighana i tara huvitawanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu i riwehi ipa, “Aiwaꞌi aubaina apia o vowahi ma oneꞌi vunuwaꞌu aubaina da, me tau aiwai apoapoena ata kaukauweya. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Marana patapatana Temple au horana avi haraharamana ma egha ota paniu. Wate wei kauwahi i tupuwa da God riwana anina da ina hegha.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Anina ma ana tauvotaghotagho anatapuhi tauna hi rovo ma hi ruba tawanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Oroto tagogi, gara tagogiava ma maihana ghaghaena, i vaini da ivi garei ma Yesu ivo taghotaghonaiyei ma maiteni hi ghoheꞌi da hita pani. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Wate ana gara ava, hisina kaiweuni ma ana kovakovana i rovo ma i ruba. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu hi taravaini da hi naiyei pirisi ghaeghae guratanana ana au numa. Piripirisi ghaeghaehi, babada ghehauhi ma raugagayo tauvi haraharamanahi kampa hivivi tagogiyehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter au heiya ma muriyai ivo taghohi da rauhetara au gabuna, i rui, pirisi ghaeghae guratanana ana au numa, kampa i tughura ma rom tau painihi maitehi, au eyagi hivi viꞌirara. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Piripirisi ghaeghaehi ma babada anatapuhi Yesu ana apoapoe hi baibaihei da hitavi hiragheni, wate egha aiwaꞌi hita tuhaghai. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Rava maghamaghauhi Yesu hivi wavui wate ahi viwavu tapuneitapunei ava. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Rava ghehauhi hivo mahiri ma moruwei Yesu hivi wavui. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tauꞌai a nonori ma i riwa da, ‘wei tempolna, rava nimahiyei hivo wavowaiya ana goruhi ma madegha tonugha au horana, ana vowameyei, egha aiyai ghehauna ina vowai.’” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Marina ahi dede maitena tapuna da tapuna, aubaina, i piripiri da ana apoꞌapoe hita tuhaghai. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pirisi ghaeghae guratanana ivo mahiri rava au naohi ma Yesu i rau-bayadei, “Rava he viviwavum ma am paribeyana aiwaꞌi bo eꞌegha?” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wate Yesu i genuwana taitaina ma egha aiwaꞌi ita yatoni. Pirisi ghaeghae guratanana i rau-bayadana meyei, “Tam Keriso, God vivivireina Natuna bo?” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu i pari-beyei, “Taꞌu. Ma apo ona inanai Rava Natuna, Vivirewapanana au ahuohohina ina tughutughura ma hapauwei au mara da ina nei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pirisi ghaeghae guratanana ana gara i hogiri ma i riwa, “Aiwai aubaina rava ghehauhi ahi dede ta ghoheghohehi, ");
INSERT INTO wed_topura_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ana vidibogha o nonori: ami nota aiwaꞌi?” A ghoheꞌi da hitavi hiragheni. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma ghehauhi, Yesu hi hovai, matana garei hi humai ma hi raviravi ma hi ririwei, “Ma riweai aiyaꞌi i ravim.” Ma taumahirighaghara hi vaini ma hi rau-navanavai. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Maranai Peter, au gabaꞌura, numa au naona ma pirisi gheghetehaharana ana tau-bagibagi wavinena i nei. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter i inanai au eyagi ivi viꞌirara da i riwei ipa, “Tam, Yesu Nasaretei maiteni o naenae.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma i rau-boviyei ipa, “Tau egha ata haramanei tam aiwaꞌi e dededei.” Ma nai gabuna i netawanei. Nai maranaina kamkam i tou. ");
INSERT INTO wed_topura_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tau-bagibagi wavinena i inana meyei ma rava kampa hivi mahiriyana i riwehi ipa, “Wei tauna turana tagogi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wate Peter i rau-bovime ma i riwa da yamna egha riwa kauwa. Hiveraumaꞌamaꞌae haburuna ma kampa rava hi mahimahiri, Peter hi riwei, “Anina riwa kauwa da tam turahi, aubaina tam Galiliyei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma Peter i pari-beyehi ipa “A ririwana kauwemi, tau egha ata haramanei, ina pa amorumoru yamna God ina kovoghiu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Anina ma kamkam mara viruwaina i tou ma Peter Yesu ana riwa i notai, “Muriyai da kamkam viruwaina ina tou, tam apo mara tonugha ma rau-boviyeu.” Ma tauna i rau-gararei ma i tou. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Au maratomtom, piripirisi ghaeghaehi, babada ghehauhi, raugagayo tauvi haraharamanahi ma mai Jew ahi raugagayo babadahi anatapuhi hivi boru da Yesu me hita ghoanei. Tauhi hivi anina ma hi pani da hi amverenei Pilate awarina. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate Yesu i rau-bayadei, “Tam anina, mai Jew ahi guyau bo?” Yesu i pari-beyei, “Anina, u riwa nanaꞌarena.” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Piripirisi ghaeghaehi Yesu ghoha maghamagha aubaina, hivi wavui. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate i rau-bayadana meyei, “ma inanai! Ghoha maghamagha aubaina hevivi wavum ma tam egha aiwaꞌi uta paripari-beyehi?” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu egha aiwai itapari beyei ma yamna aubaina Pilate i bahei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mai Jew ahi vaivai da Raghona torehana au marana yamna, panipani tagogi, hevi viꞌinaghaniya ma hevivi bagheiya Pilate inavo tawanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oroto wavana Barabas yana au panipani ma tauna gabemani ahi au vighahighahiyawa, ivi hiraghena. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Patara hi nae da Pilate hivi baghai da Raghona torehana, ma tauna maemae warihaghana ma apo ahi nuwahegoya ita kauwei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilate yana i haramanei da piripirisi, Yesu hi unuꞌunurei ma aubaina ma hi amverenei tauna awarina. Ma yamna aubaina da rava i rau-bayadehi, “O ghoheghohei da mai Jew ahi guyau ana votawanei bo?” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wate piripirisi ghaeghaehi patara hivi medihi da Pilate hivi baghai da Barabas ita votawanei ma egha Yesu. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate patara i rau-bayadehi, “Ma tauna o ghoreghoreiya, mai Jew ahi guyau, aiwaꞌi o ghoheghohei da ana ghohai awarina?” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hi garara ma hipa, “Ma tuparatui.” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Pilate tauhi i rau-bayadehi, “Aiwaꞌi aubaina? Aiwaꞌi apoapoena i ghohai?” Ma tauhi hi garara guraguratana, “Ma tuparatui!” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma Pilat i ghohei da patara itavi nuwahubahi, yamna aubaina da Barabas ivo tawanei. Ma i riwa da Yesu hi kwapui ma i am verenei da hita tuparatui. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ghavighaviyahi Yesu hi taravainanaiyei Pilate ana au numa (wavana Praetorium) ma kampa ghavighaviyahi ghehauhi maitehi hivi tagogiyehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma gara vikabekaberona me guyaguyau ahi gara, hivi oteni ma kunuteiya eyagi donadonana au koyana hi terei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma we nanaꞌarena hivivi diboghi, “Ona inanai mai Jew ahi guyau!” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kwapuweꞌi koyana hivi rau-rauwei, hi hovahovai, aetutuhi hi tapegharowei ma hivo hepahepa morumoruwei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Maranaina hivi dibogha vorovei, gara vikabekaberona hivo tawanei ma ana gara ohohina hivi otena meyei ma tuparatuna aubaina, hi taravainanaiyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simon tauna Sairiniyei (Alexander ma Rufus amahi) dobu ghehauwei inenei ma au etanai hi tuhaghai. Mai Rome ahi tauvi ghaviya, hi hegaradubadubari da Yesu ana korosi ita avarai. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yesu hi taravainanaiyei au Golgota. (Golgota anona yamna unu gabuna) ");
INSERT INTO wed_topura_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kampa wine, bunama megh maiteni hivi raviraiya hi verei da ita umai ma Yesu i geduaiyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma kampa Yesu hi tuparatui ma ana gara hivi kasiyei ");
INSERT INTO wed_topura_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Madegha i tugheꞌetai me 9 koroki ma Yesu hi tuparatui. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ahi Viwavu riwana, we nanaꞌarena, hi girumi, “Mai Jew ahi Guyau.” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Tau danedanene ruwagha maitehi hi tuparatuhi, tagogi au ahuohohinei ma ghehauna au ahukehakehanei ");
INSERT INTO wed_topura_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Rava ghehauhi hi veverauvirei ma hivi unukwadikwadi ma hi paripari-vaiapoapoeni, hipa, “Ha! Da! Tam u riwa da numa taparoro uta goruhi ma madegha tonugha au horana uta vowameyei ");
INSERT INTO wed_topura_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mavi yawahana meyem ma ma hopui!” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Piripirisi ahi babada ma raugagayo tauvi haraharamanahi we nanaꞌarena tauna hivivi diboghi, “Rava ghehauhi ivi yawahanihi ma egha tagotagogina da tauna inavi yawahana meyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Korosiyei ita hopui da tata inanai ma tata vitumaghanei da tauna God ana vinevine, mai Israel ahi guyau.” Tauhi ruwagha Yesu maiteni hi tupatuparatuiya maitehi hivi diboghi. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ahubena au kayakayana ma dobuna ghaeghaenana i ravigimtonai ma nanaꞌarena i maꞌae da au hegoya, me 3 koroki nanaꞌarena. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Au hegoya ma Yesu ponana ghaeghaenei i garara, “Eloi! Eloi! Lama sabatani?” Riwana anona yamna, “Aꞌu God, Aꞌu God aiwaꞌi aubaina u votereu.” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Taumahiri, hi nonora boꞌai ma hipa “Tauna Elijah e ghoreghorei.” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Oroto tagogi i ruba da ani rauogha i vaini ma wain viꞌivohirahiraghena awarina ivi gayoi, eyagi au mutuna i avehi ma ivi yoyoi da Yesu ita uma. Tauna maiteni ipa, “Tana vipaipai mepa da Elijah ina nei ma ina terehopunei tana inanai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu, ponana ghaeghaenei i garara ma i hiraghe. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gara numa taparoro au horana gabu au viyouyou ateꞌatena ani rughagharana, i wanatevai au tepana da au gabaurina da i rau-ruwaghei. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tauvi ghaviya ahi bada ghehauna korosi au naona i mahimahiri i inanai da Yesu me i hiraghenei ma ipa, “Riwa kauwa, weꞌi orotona anina God natuna.” ");
INSERT INTO wed_topura_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Waivine ghehauhi au ririva hi mahiri ma hivi neneghana. Ma kampa taumahiri au horahi yamna Mary Magdalene, Mary James haburuna ma Joses ayohi ma Salome. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","We waivinehi yana au Galili Yesu hivo votaghonaiyei ma hivo vohagui. Waivine ghehauhi, au Jerusalem Yesu hivo votaghonaiyei, yamna maitehi kampa. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Paraide yana mai Jew ahi vokaukauwa marana, (au ibigabiga) ");
INSERT INTO wed_topura_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","yamna aubaina Joseph tauna Arimatheayei ma boru badana ghehauna, wate tauna God ana vibadana ivi paipaiyei. Tauna tepatorei i nae ma Pilate ivi baghai Yesu tupuwana ita vaini aubaina. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate Yesu hiraghena riwana i nonori ma egha itavi tumaghanei. Yamna aubaina da tauvi ghaviya badana, i ghorei ma i rau-bayadei da Yesu i hiraghe bo eꞌegha. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Maranaina Pilate, Yesu hiraghena riwa kauwana i nonori, yana Joseph ivi aninei da Yesu tupuwana ita vaini. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Anina ma Joseph gara araꞌarapoirina vouna i gimarai, Yesu tupuwana ivo tawanei, i humai ma au kokowaga me guba, kira au horana i gharagharaiyana kampa hivi enoi. Ma ghaꞌima ghaeghaena hivi toutouviranaiyei da metaeta hi rau-tomeni. ");
INSERT INTO wed_topura_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene ma Joses ayona Mary hi inanai mepa Yesu hivi enoi. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Maranaina Sabate i kwaha au murina, Mary Magdalene ma James ayona Mary ma Salome dadi ghabughabuna hi gimarai da Yesu, tupuwana hitavi niuri. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sunday maratomtom boiboghi hivo mahiri ma hi nae au kokowaga. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hi naenae ma hivi tarapiri da aiyaꞌi ghaꞌima inavi tovitovira riyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wate maranaina hita inana nae yana ghaꞌima boiboghi hivi tovitovira riyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Maranaina hi rui au kokowaga, oroto tagogi gara araꞌarapoirina i oteni ma tauhi au ahu ohohihiyei hi inanai i tughutughura ma tauhi hi ghohorihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma i riwa “Egha ona rovo! Taumi Yesu Nasaretiyei hi tupatuparatuiya o baibaihei bo? Tauna egha weka, i yawahana da ivo mahirime. Ona inana! Wei au gabuna hivi enoi.” ");
INSERT INTO wed_topura_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wate ona nae ana tauvotaghotagho ona riwehi ma Peter maiteni onapari verei. Tauna i ainae au Galili. Kampa ona inanai me i ririwa nanaꞌarena. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Anina ma, ana rovohi ma ana nuwa ragharaghahi hi rubame. Tauhi hi rovo kauwa da egha aiyaꞌi ghehauna hitavi heghei. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Maranaina Yesu au Sunday hubahubanai boiboghi, hiragheyei ivo mahirime Mary Magdalene awarina i hegha. Tauna aunaonei aruwa-apoapoehi seven auwarina ivi hopunihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Anina ma Mary Magdalene i naeme da Yesu ana tauvotaghotagho hivivi nuwaboya ma hi toutou i riwehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma maranaina ana tauvotaghotagho tuyeghana hi nonori da tauna i yawahaname ma Mary Magdalene tauna i inanai, wate tauhi egha hitavi tumaghanei. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Muriyai Yesu inanana tapuna ma i hegha ana tauvotaghotagho ruwagha auwarihi, maranaina tauhi hi naenae au meyagai gheha. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tauhi, hi wanavirahi da ahi rava ghehauhi hi pari-verehi ma egha hitavi tumaghanehi. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muriyai, Apostle eleven, hi amꞌam ma Yesu auwarihi i hegha. Tauhi koyahi i bagibagi kauwa da ahi rava Yesu hi inanai da ivo mahirime ma egha hitavi tumaghanehi. Yamna aubaina da Yesu tauhi i enihi. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tauna, we nanaꞌarena i riwehi, “Ona nae meyagai au anatapuna ma rava anatapuhi auwarihi tuyegha ahiꞌahina ona rau-guguyei. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aiyaꞌi da evivi tumaghana ma i babataito yamna ina yawahana ma aiyaꞌi da egha itavivi tumaghana apo God inaparivai apoapoeni. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma tau vitumaghana apo wavaꞌuwei, wei matakirahahi hina ghohahi. Aruwa-apoapoehi rava au horahi hinavi hopunihi ma pona ghehei hina dede. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mota hina vaini ma waꞌiyawa hina umai, egha apoapoe hina tuhaghai.” ");
INSERT INTO wed_topura_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Maranaina Yesu ana Apostle auwarihi i dede vorove, God i taravaini da i ghaiyei au mara da gabu au vinevinena i tughura. ");
INSERT INTO wed_topura_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anina ma tauvotaghotagho hi nae meyagai ma dobu au anatapuna ma rava auwarihi riwa ahiꞌahina hi rau-guguyei. Bada ana riwapanei hi noya, aubaina da tauhi matakiraha hi ghohahi da rava hi inanai da anina kauwa anona. ");
ALTER TABLE wed_topura_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
