﻿USE sofia;
DROP TABLE IF EXISTS sofia.wbq_vpl;
CREATE TABLE wbq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wbq_vpl WRITE;
INSERT INTO wbq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","द्यावार कोडकु येशु ख्रिस्तन शुभवर्तमान दी इदी सुरवात उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","यशया संदेष्टान ग्रंथला राशीनेलेका, “सुड, नीन ना दुतनी नि मुंदार आंपतान, वाड, नी कस्रोम दावा तैयार शेशी; ");
INSERT INTO wbq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","मरु भूमीला येवार्दी तरी कीरलेद आवाज इना वच्या, ‘प्रभुनदी दावा तैयार शेयांडा, वानदी दावा सरळ शेयांडा.’” ");
INSERT INTO wbq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","दानलेकाने योहान वच्या, वाड मरू भूमीला बाप्तिस्मा इच्चू इंगा पापला क्षमा कस्रोम पश्चाताप बाप्तीस्माद घोषणा शेयदु. ");
INSERT INTO wbq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","आंता यहुदिया प्रांत इंगा यरुशलेम शहरनुस शेंगेम मंदी योहान तिकुड वचीर. वार स्वताय पापलु स्वीकार शेशी वान तिकनुस यार्देन वंकाला बाप्तिस्मा तीस्कुनीर. ");
INSERT INTO wbq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","योहान वंट्या येन्डकालनुस बनास्ने बट्टाल फेटकुंदू. वान नडमूलाक तोलदी पट्टा उंड्या इंगा वाड मिडताल इंगा आडवी तेन्या तिंदू. ");
INSERT INTO wbq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","वाड घोषणा शेशी आनदु, “नाकानापण शक्तिशाली इल्ला यवाड तरी वगाड ना यंकाकेल वस्तुणाळ इंगा नीन वंगी वान बुटलाद दाराम खोलाशे लायकिक पण लेन. ");
INSERT INTO wbq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","नीन तर मिद बाप्तीस्मा नेळाता शेस्तान पण वाड मिद बाप्तिस्मा पवित्र आत्माता शेशी.” ");
INSERT INTO wbq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","आ दिन्मुलाला इल्ला आय्या की, येशुड गालील प्रांतलोन नासरत नगर लोन्केल वच्ची यार्देन वंकाला योहान शेयता येशुड बाप्तिस्मा तीस्कोन्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","येशुड नेळा लोन्केल मिन्दिक वचेतापुड, लगेच मोडाम उघडाशिनेद इंगा पवित्र आत्मा वान्मिंदा कबुतर लेका दिगतुनाद, इल्ला वांकी कमशा. ");
INSERT INTO wbq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","आप्पुड मोडाम नुस आवाज आय्या की, “नु ना प्रिय कोडकु उंडाव, नि बद्दल नीन संतुष्ट उंडान.” ");
INSERT INTO wbq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","मग आत्मा येशुन लगेच मरु भूमीलोंग येकाफोया. ");
INSERT INTO wbq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","शैतान वांदी परीक्षा सुशेतापुड वाड जंगलला नलपाय नाळ नीलच्या. वाड जंगली प्राणीला नडमा उंड्या. इंगा देवदूतलु वचीगास वांदी सेवा शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","योहाननी फट्टीनेन्का, येशुड गालील प्रांतला वच्या इंगा द्यावार राज्यद शुभ वर्तमानदी प्रचार शेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","वाड आन्या, “वेळ पूर्ण आयनेद उंडाद, द्यावारदी राज्य देग्गार वचीनाद, पश्चात्ताप शेयांडा इंगा शुभ वर्तमान मिंदा विश्वास फेटना.” ");
INSERT INTO wbq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","येशुड गालील सरोवर देगार फोयेतापुड शिमोन इंगा वान तम्मुन अंद्रियान सरोवरला जाळी येशेतापुड सुश्या, येनटीक की वार मिल फटेतोर उंडीर. ");
INSERT INTO wbq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","येशुड वारनी आन्या, “नायंका दांडा आंटे नीन मिमलान मंसलान फटेतोर बना मत्तुतान.” ");
INSERT INTO wbq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","इंगा वार लगेच जाळी इडशिगास वान यंका नडदेंग आंटीर. ");
INSERT INTO wbq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","आंदनुस रवा मुन्दार फोई नेन्का वानकी जब्दी कोडकु याकोब इंगा वान तम्मुड योहान इर जहाजला जाळी शिंगार शेशेतापुड कमशीर. ");
INSERT INTO wbq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","वाड लगेच वारनी फिलच्या; इंगा वार मना आब्बान जब्दीन नोकरला जताक जहाजला इडशी वान यंका येल्लीर. ");
INSERT INTO wbq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","मग येशुड इंगा वान शिष्यल कफर्णहुम नगरकी फोईर, इंगा लगेच येशुड शब्बाथ दिन्मु सभास्थानला फोईगास शिक्षण इद्देंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","वाड नेरपु तर वार चकीत आयफोईर, येनटीक की येशुड नियमशास्त्रला शिक्षकला लेका शिकाय मत्ताकुंदु, पूर्ण अधिकार उंडीन लेका नेरपु. ");
INSERT INTO wbq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","आ वेळला यहुदी सभास्थानला खराब आत्मा आंटीने वगा मनशी उंड्या, वाड शेंगेम बेग्गे कीरली आन्या, ");
INSERT INTO wbq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“नासरतोड येशु नु मा नडमा येनटीक फडताव? नु माद नाश शेयदेंग वचीनाव येम? नु यवार उंडाव नाक यरका उंडाद, यवाड द्यावार पवित्र मनशी वाड नुये उंडाव.” ");
INSERT INTO wbq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","पण येशुड वान धमकाशी आन्या, “शांत उंड इंगा इन लोन्केल येल्ली फो.” ");
INSERT INTO wbq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","“मग अशुद्ध आत्मा वान फिन्डया इंगा आदी बेग्गे कीरलीगास वान लोन्केल येल्ली फोया.” ");
INSERT INTO wbq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","आंता मंदी चकीत आय्यीर इंगा वगामेगारणी आडगेदेंक आंटीर, “इदी येम उंडाद? इदी तर कोत्ता उपदेश उंडाद. इंगा अधिकारता वाड खराब आत्मालकी पण आज्ञा इस्ताड इंगा आय वांदी आयकास्ताय!” ");
INSERT INTO wbq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","इंगा येशुन बद्दलदी इदी माटा लगेच गालील देगार आन्नी तीकुड फैलाशी फोया. ");
INSERT INTO wbq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","येशुड इंगा वान शिष्यल यहुदी सभास्थानलेल येल्लीर इंगा लगेच योहान इंगा याकोब संगा शिमोन इंगा अंद्रिया इर इल्लुक फो. ");
INSERT INTO wbq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","शिमोन आत्ता जडमुता पलंग मिंदा फडीन्या. आप्पुड वाड लगेच येशुनकी दानबद्दल शेप्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","आप्पुड वाड दान देगार फोई शेई फट्टी दान लेप्या इंगा दांदी जडमू दिगी फो इंगा आदी वारदी सेवा शेशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","मापसार आंटे सूर्य मुन्गीनेन्का मंदी आंता बिमार इंगा दैय्याल फटीनोरनी वान देगार येकोचीर. ");
INSERT INTO wbq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","इंगा नगरलोन शेंगेम मंदी दरवाजा मुंदार जमा आयफोईर. ");
INSERT INTO wbq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","वाड अलग-अलग रोगलाता बिमारील उंडीने मंदीन शिंगार शेषा इंगा शेंगेम मंदी लोन्केल दैयाल तिशा. पण वाड दैयालनी माटलाडा नियालेद येनटीक की आय वान ओळखायदु. ");
INSERT INTO wbq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","मग वाड नस्कुला मोबू उंडीनाप्पुडे लगेच येल्ल्या इंगा एकांतला फोई प्रार्थना शेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","शिमोन इंगा वान संगा येवार उंडीर वार येशुन फुडकेदेंक आंटीर, ");
INSERT INTO wbq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","इंगा वाड शिक्कीनेन्का वार वान आनीर, “मिम आंदार नीनु फुडकूदुम.” ");
INSERT INTO wbq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","आप्पुड येशुड वारणी आन्या, “मनाम देगार उळलाक फोदाम, आंटे नाक आंदू पण उपदेश शेया दावाला दिनकस्रोम मनाम इंगोगो तीकुड फोदाम येनटीक की दिनकस्रोम नीन इंदुक यल्ली वसतीन.” ");
INSERT INTO wbq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","मग वाड आन्नी गालील प्रांत लोन्केल, वार सभास्थान नुस उपदेश इच्का इंगा दैयाल तीस्का तीरग्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","दान बाद वगा कुष्ठरोगी मनशी येशुन देग्गार वच्या इंगा वान मुंदार मोकाळलु टेकाशी वाड स्वतान शिंगार शेशेदेंक वान विनंती शेश्या. वाड येशुन आन्या, “नीद इच्छा उंटे तर नन्नु शुद्ध शेशेदेंक नु समर्थ्य उंडाव.” ");
INSERT INTO wbq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","येशुनकी वान मिंदा दया वच्या, वाड शेय मुन्दारकी शेशी वान मुट्ट्या इंगा आन्या, “नाद इच्छा उंडाद नु शुद्ध कावाला.” ");
INSERT INTO wbq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","इंगा लगेच वांदी कुष्ठ रोग येल्ली फोया इंगा वाड शुद्ध आय फोया. ");
INSERT INTO wbq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","येशुड वांकी चेतावनी इच्ची आंप्या. ");
INSERT INTO wbq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","इंगा आन्या, “सूड, दिनबद्दल येवारकी येमीच शप्पाक, गान, फोई स्वतान याजक की सुप्पी इंगा वारकी साक्ष कावाला दिन कस्रोम नु स्वतः शुद्धी कस्रोम मोशेड नेमास्नेद अर्पण शेय.” ");
INSERT INTO wbq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पण वाड आंदनुस येल्ली फोया इंगा घोषणा शेशी इदी बातमी इंता पसरा मत्या की येशुनकी मोकळा शहरकी फोवा दाकुंदु, दिन कस्रोम वाड मरू भूमीला नीलच्या तरी आन्नी तीकनुस मंदी वान तीकुड वच्चेद इडवा कुंदुर. ");
INSERT INTO wbq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","काही नाळा बाद येशुड कफर्णहुम नगरकी वापस वच्या आप्पुड वाड इल्काडा उंडाड इल्ला मंदी गुम्मामिंदा फड्या. ");
INSERT INTO wbq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","आप्पुड इंता मंदी जमा आय्यीर की इंटल्या वारकी जागा मिग्लाले, इंते लेद तर दरवाजा बैट्या पण जागा लेकुंड्या. आप्पुड वाड वारकी वचन शपदू. ");
INSERT INTO wbq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","मग काही मंदी वान देगार लकवा आंटीने मंशीन येकोचीर. वान नलगुर मोस्का वचीर. ");
INSERT INTO wbq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","पण गर्दी कस्रोम वारकी आ मंशीन येशुन देगार एका फोवा दाकुंदू, मग येशुड येंदू नीला फडीन्या वान मिन्दुडदी छप्पर वार तीशीर इंगा या मंचाम मिंदा आ मणशी उंड्या, आदी मंचाम वार छप्पर नुस किंदा वान देगार इडशीर. ");
INSERT INTO wbq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","वारदी विश्वास सुशी येशुड लकवा आंटीने मनशीन आन्या, “कोडका, नि पापलाद क्षमा आयनाद.” ");
INSERT INTO wbq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","आंदू काही नियमशास्त्र शिक्षकलु कुशींडीर. वार स्वता मनला आनेदेंक आंटीर की, ");
INSERT INTO wbq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“इ मनशी इल्ला येनटीक माटलाडताड? इड द्यावारदी अपमान शेस्तुनाड! द्यावारनी इडशी येवारूच पाप क्षमा शेशी शकायार?” ");
INSERT INTO wbq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","इंगा आप्पुड वार स्वता ने विचार शेस्तुणार, इदी येशुड आप्पुडे मना आत्माला ओळखाशी वारनी आन्या, “मीर मी मनला इल्ला येनटीक विचार शेस्तार? ");
INSERT INTO wbq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","नि पापलाद क्षमा आयनाद, इल्ला इ लकवा आंटीने मंशीन आनेद का लेय इंगा नीद मंचाम येतकेन नडू; दिंटल्या याद सोपा उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पण मनशी कोडकुक पृथ्वी मिंदा पाप क्षमा शेशेद अधिकार उंडाद वारकी तेल्वाला आंका, वाड लकवा आंटीने मंशीन आन्या, ");
INSERT INTO wbq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“नीन नीक शेप्तान, लेय, नीद मंचाम येतकेन इल्लुक येल्ली फो.” ");
INSERT INTO wbq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","मग वाड लगेच लेश्या. वाड वानदी मंचाम येतकेन आंदार मुंदार वाड इल्लु बैटीक फोया; दिन कस्रोम वार आंदार आश्चर्य चकीत आय्यीर इंगा द्यावारदी गौरव शेस्का आनीर, “मिम इल्ला येप्पुडूच सुडा लेकुंटीम.” ");
INSERT INTO wbq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","येशुड वापस गालील सरोवर तीकुड फोया इंगा संगेम मंदी वान देगार वच्चीर इंगा वाड वारकी शिक्षण इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","यंकसार वाड फोयेताप्पुड अल्फीन कोडकु लेवी इन जकात नाका मिंदा कुस्नीनोन सुश्या. इंगा येशुड लेवीन आन्या, “नायंका दा.” आप्पुड लेवीड लेश्या इंगा येशुन यंका फोया. ");
INSERT INTO wbq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","इंगा इल्ला आय्या की येशुड लेवीन इंटल्या तिनदेंक कुसन्या; आंदू जकातदार इंगा पापी मन्सूल येशुन इंगा वान शिष्यल संगा तिनदुर येनटीक की वार संगेम मंदी उंडी वान यंका वचीनीर. ");
INSERT INTO wbq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","तिनेताप्पुड काही नियम शास्त्र शिक्षकलु यवार परुशी उंडीर वार येशुन पापी मंदी इंगा जकातदारला संगा तिनेताप्पुड सुशीर. वार वान शिष्यलनी आनीर, “इड पापी इंगा जकातदारला संगा येनटीक तिनटूनाड?” ");
INSERT INTO wbq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","इदी इनी येशुड वारनी आन्या, “शिंगार मंदीक वेद्यद गरज लेकुन्टाद, बिमारोरकी उंटाद. नीन नीतिमान मंदीन लेद, पण पापी मंदीन कुतेदेंक वचीनान.” ");
INSERT INTO wbq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यप्पुड योहान शिष्यल इंगा परूशील उपवास शेयदूर आप्पुड काही मंदी येशुन तीकुड वचीर इंगा वान आनीर, “योहान शिष्यल इंगा परुशी मंदी उपवास शेस्तार पण नी शिष्यल येनटीक उपवास शेय्यार?” ");
INSERT INTO wbq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","येशुड वारनी आन्या, “वर्हाड जताक फेंडली कोडकु उंडाड आड नंताक उपवास शेशेद शक्य उंडाद येम? फेंडली कोडकु जताक उंडाड आड नंताक वारकी उपवास शेशेद शक्य लेद. ");
INSERT INTO wbq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पण इल्ला दिन्मुल वच्ची की, फेंडली कोडकु वार देगाटेल तीस्कून कामला वच्ची इंगा मग वार आ दिन्मुला उपवास शेश्यार. ");
INSERT INTO wbq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","यवार कोत्ता बट्टालकी फाता बट्टा जोडवार, जर वाड इल्ला शेस्ताड तर कोत्ता बट्टा फाता बट्टालनी शिंपी इंगा आदी पहिला काना जास्त शिंगी फोई. ");
INSERT INTO wbq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","आल्ले कोत्ताद दाखरस फाता तोल थैलीला येय्यार. जर वाड इल्ला शेस्ताड तर दाखरस तोल थैलीन तेगी फोई इंगा दाखरस खराब आय्यी इंगा दाखरस तोल थैलीद नाश आय्यी. दिनकस्रोम कोत्ता दाखरस कोत्ता तोल थैलीला ने येस्तार.” ");
INSERT INTO wbq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","मग इल्ला आय्या की, शब्बाथ दिन्मु नाबद शेल्लोन्केल फोयेताप्पुड, वान शिष्यल उंब्याल तेम्पुदूर. ");
INSERT INTO wbq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","आप्पुड परूशील येशुन आनीर, “सूड, शब्बाथ दिन्मु येम शैयाराद आदी इर येनटीक शेस्तार?” ");
INSERT INTO wbq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","येशुड वारनी आन्या, “यप्पुड दावीद इंगा वान संगा उंडीन मंदीक आकाल आय्या इंगा वारकी तिनदेंक बेकुंड्या. आप्पुड वार येम शेशीर दिन बद्दल मीर वाचायलेद येम? ");
INSERT INTO wbq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","अब्याथार महायाजक उंडीनाप्पुड, वाड द्यावार गुडीला यल्ला फोया इंगा द्यावारकी एकपिचीने रोट्याल, याय नियमशास्त्रला राशीने लेका याजक शिवाय यवारूच तिना राद आय यल्ला तीन्या इंगा यवार वान संगा उंडीर वारकी पण यल्ला इच्या?” ");
INSERT INTO wbq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","वाड वारनी आन्या, “शब्बाथ दिन्मु मंदी कस्रोम बनाशिनाद. मंशीन शब्बाथ दिन्मु कस्रोम बनाया मतालेद. ");
INSERT INTO wbq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","दिन कस्रोम मनशी कोडकु शब्बाथ दिन्मुक पण प्रभूड उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","मग येशुड इंगोगो शब्बाथ दिन्मु नाड सभास्थानलोंग फोया, आंदू यंडीन शेय्योड मणशी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","येशुन मिंदा आरोप शेयदेंग कारण शिक्का बेक आंका काही मंदी शब्बाथ दिन्मु नाड येशुड आ मंशीन बागा शेस्ताड की लेद इदी सुदेंक वान मिंदा बारीक नजर फेटीनीर. ");
INSERT INTO wbq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","येशुड यंडीने शेई मंशीन आन्या, “लेय इंगा मंदी मुन्दार नीला फड.” ");
INSERT INTO wbq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","मग वाड वारनी आडग्या, “शब्बाथ दिन्मु नाड बागा शेस्काम बरोबर उंडाद का खराब शेस्काम, जेम वाचाय मतेद का जेम तीस्कुनेद दिन्टल्योन्केल येम बरोबर उंडाद?” गान वार आंदार तेप्पांग उंडीर. ");
INSERT INTO wbq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","मग वाड वार कठोर मन कस्रोम दुखी आय्यी वारनी शिट्टता सुश्या इंगा आ मंशीन आन्या, “निद शेय मुन्दारकी साप,” वाड शेई मुन्दारकी शेश्या इंगा वाड बागा आय्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","आप्पुड परूशील येल्ली फोईर इंगा लगेच वान यल्ला जेमफडा मतेशेद दिन बद्दल हेरोदीयोर संगा येशुन विरुद्ध योजना शेस्का कुसनीर. ");
INSERT INTO wbq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","मग येशुड वान शिष्यला जताक गालील सरोवर तीकुड फोया, गालील इंगा यहुदिया प्रांतकेल फेद्दाद गर्दी वान यंका-यंका वच्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","येरुशलेम शहर, इदोम प्रांत, यार्देन वंका आतकुड प्रदेश नुस, सोर इंगा सिदोन शहर देगार प्रदेश नुस फेद्दाद समुदाय, वाड याय फेद्दा फेद्दाय फनील शेसू आटला बद्दल इनी वान देगार वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","मग गर्दी कस्रोम चेंगराशी फोवाराद आंका येशुड स्वता शिष्यलनी वगा जहाज तैयार फेटदेंग शेप्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","येनटीक की वाड संगेम मंदीन बागा शेशिन्या दिन कस्रोम यवारकी रोग ग्रस्त उंडीर वार वान फटेदेंक वान फयमिंदा फडदूर. ");
INSERT INTO wbq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","इंगा यप्पुड अशुद्ध आत्माल येशुन सूदू आप्पुड वार वान मुंदार किंदा फडी कीरलुदू की, “नु द्यावार कोडकु उंडाव!” ");
INSERT INTO wbq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","पण वाड आटलाक कडक चेतावनी इच्चू की नन्नु प्रकट शैयाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","मग येशुड कोंडामिंदीक फोया इंगा वानकी येवार शिष्यल बेकुंडीर? वारनी वाड वान तीकुड कुतेश्या इंगा वार वान देगार वचीर. ");
INSERT INTO wbq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","आप्पुड वाड बारा मंदीद निवड शेश्या वारकी वाड प्रेषित इदी फेर इच्या. वाड वारदी दिनकस्रोम निवड शेश्या की, वार वान संगा उंडाला इंगा वारनी इंगोगो जागाला उपदेश शेशेदेंक आंपाला. ");
INSERT INTO wbq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","इंगा वारकी दैयाल तीशेद अधिकार उंडाला. ");
INSERT INTO wbq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","आप्पुड येशुड इ बारा मंदीद निवड शेश्या इंगा येवाड शिमोन वानकी पेत्र फेर इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जब्दीन कोडकु याकोब इंगा याकोब तम्मुड योहान इरनी वाळ बोआनेर्गेश, आंटे गर्जना कोडकु इदी फेर इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अंद्रिया, फिलीप, बर्थलयम, मतय, थोमा, अल्फीन कोडकु याकोब, तद्दय, शिमोन कनानी ");
INSERT INTO wbq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","इंगा यहूदा इस्कर्योती येवाड यंकसार येशुनदी विश्वासघात शेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","मग येशुड इल्लुक वच्या आप्पुड इंता मंदी जमा आयनीर की वारकी तीनेदेंक पण दाकुंदू. ");
INSERT INTO wbq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","यप्पुड वान इल्काटोर मंदी दिन बद्दल इनीर आप्पुड वार वान फटेदेंग फोईर येनटीक की वाड पागल आयनाड इल्ला वारदी आनकाम उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","इंगा येरुशलेम शहरनुस वचीनोर नियम शास्त्र शिक्षकलु आंदुर की, वानलोना बाल-जबुल उंडाद इंगा वाड दैयाल सरदार मदतता दैयाल तीस्ताड. ");
INSERT INTO wbq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","मग येशुड वारनी वान देगार फिलची दाखला द्वारे शेपदेंग आंट्या, “शैतान शैताननी यल्ला तिशी शकास्ताद? ");
INSERT INTO wbq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","जर यादाना राज्यला फुट फड्या तर आदी राज्य टीकाशी शेकायाद. ");
INSERT INTO wbq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","जर यादाना इंटल्या फूट फड्या तर आदी इल्लु पण टीकाशी शेकायाद. ");
INSERT INTO wbq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","जर शैतान स्वतःक विरोध शेस्ताड जर वार दान्टल्या ने फूट फडतुनाद तर आदी टीकाशी शेकायाद, इंगा दांदी शेवट आय्यी. ");
INSERT INTO wbq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","येवारकीच बलवान मनशी इल्काडदी मालमत्ता लुटाया दाद. पहिला आ ताकत वर मंशीन कट्टा बेक, दान बाद वांदी इल्लु लुटास शकास्ताड.” ");
INSERT INTO wbq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","नीन मिक खरेम शप्तान की, “मंदी आन्नी पापलाद इंगा द्यावार निंदाद क्षमा आय्यी. ");
INSERT INTO wbq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","जर यवाडाना पण पवित्र आत्माद निंदा शेशी, वानकी यपुडूच क्षमा शिक्काक फोई इंगा आ मनशी सार्वकालिक पाप कस्रोम दोषी उंडी.” ");
INSERT INTO wbq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","येशुड इल्ला आन्या येनटीक की वान लोना अशुद्ध आत्मा उंडाद इल्ला वार वान बद्दल आंदुर. ");
INSERT INTO wbq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","आप्पुड येशुन आम्मा इंगा तम्मुळलु वच्चीर इंगा बैट्या नीला फडीर वानकी निरोप आंपी वान कुतेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","मंदीद समुदाय येशुन गोलुंग कुशींड्या, वार वान आनीर, “नि आम्मा इंगा नी तम्मुळलु बैट्या नीद दावा सुस्तुणार.” ");
INSERT INTO wbq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","येशुड वारकी उत्तर इच्या, “ना आम्मा इंगा तम्मुळलु यवार उंडार?” ");
INSERT INTO wbq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","मग वाड वान देगार कुस्नीनोर तीकुड सुशी आन्या, “सुडांडा! ना आम्मा इंगा ना तम्मुळलु इर उंडार. ");
INSERT INTO wbq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","येनटीक की यवारबी द्यावार इच्छा लेका नडस्तार वारे ना तम्मुळलु, ना शेल्यांलु इंगा ना आम्मा उंडार.” ");
INSERT INTO wbq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","वापस येशुड सरोवर कंटाम मींदा शिक्षण इद्देंक आंट्या, आप्पुड वान देगारा संगेम फेदाद समुदाय जमा आय्या, दिनकस्रोम वाड सरोवरलोन वगा जहाजला फोई कुसन्या इंगा आंदार मंदी सरोवर कंटामकी भुमी मिंदा नीला फडनीर. ");
INSERT INTO wbq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","वाड वारकी दाखलाल इच्ची संगेम माटलु शिका मतुदू इंगा वाड आन्या; ");
INSERT INTO wbq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“इनांडा, वगाड पेराशेतोड पेरणी शेशेदेंक येल्ल्या ; ");
INSERT INTO wbq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","इंगा वाड पेराशेताप्पुड इल्ला आय्या की, काही बी दावा मिंदा फड्या, आय पक्षील वच्ची तीनेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","काही बी खडक भुमी मिंदा फड्या, आंदू आटलाक जास्त मनु लेकुंड्या. येनटीक की जास्त मनु लोत लेकुंड्या तर आय लग्गान येल्ल्या. ");
INSERT INTO wbq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","पण सूर्य मिन्दिक येल्लीनेंका आदी काली फोया इंगा दानकी मूळलु लेकुंड्या आंका आदी येंडी फोया. ");
INSERT INTO wbq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","काही बी मुंडला झुड्पुलाला फड्या इंगा झुडपुल फेद्दाय वाढाशी आटलाद वाढ थांबाश्या, दिनकस्रोम आटलाक येमीच पिक दालेद. ");
INSERT INTO wbq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","काही बी मंची भुमी मींदा फड्या आय वच्या, फेद्दाय आय्या आटलाक पिक वच्या; इंगा आटलाक तीसपट, साठपट, शंभरपट इल्ला उत्पन्न वच्या.” ");
INSERT INTO wbq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","मग वाड आन्या, “यवारकी गुम्माल उंडाय वार इनांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","वाड वक्काडे उंड्या आप्पुड वान संगा बारा मंदी संगा यवार उंडीर वार वान दाखला बद्दल आडगीर. ");
INSERT INTO wbq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","वाड वारनी आन्या, “द्यावार राज्यद रहस्यदान मिक इचीनेद उंडाद, पण बेटूटोरकी दाखलाता शेपदेंक वस्ताद. ");
INSERT INTO wbq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","दिनकस्रोम की वार सुशेताप्पुड सुडाला पण वारकी कमसा राद, इंगा इनेताप्पुड वार इनाला, पण तेल्वाराद. लेकाते कदाचित वारी मनल तीरगी इंगा द्यावार वारनी क्षमा शेशी.” ");
INSERT INTO wbq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","वाड वारनी आडग्या, “इदी दाखला मिक तेल्वालेद येम, तर इंगा इंगोगोय दाखलाल मिक यल्ला तेल्ची? ");
INSERT INTO wbq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","पेराशेतोड द्यावारदी वचन पेरास्ताड. ");
INSERT INTO wbq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","दावा मिंदा पेरास्नेड वचन आन्दुटोर मंदी इर उंडार की, वार इनीन नग्रेम शैतान वच्ची वार दिंटल्या पेराशीनेद वचन दोंगा शेस्कुंटाद. ");
INSERT INTO wbq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","आल्ले खडक भुमीला पेरासनेद इदी उंडाद की, वचन इनीन नग्रेम वार आनंदता स्वीकार शेस्तार; ");
INSERT INTO wbq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","तरीपण वार लोना मुळलु लेकुन्ने कस्रोम आय काही वेळ टीकास्ताय ; इंगा वचन कस्रोम संकटलु वच्या लेकाते छळ आय्या आंटे वार लगेच अटकास्तार. ");
INSERT INTO wbq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","इंगोगो मंदी मुंडला झुडूपला पेरास्नेर बी लेका उंडार, वार वचन इंटार, ");
INSERT INTO wbq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","गान संसारदी काळजी, संपतीद लालच इंगा इंगोगो माटलाद लालच इदी वारलोना दुरी वचनदी वाढ थांबा मत्तुताद इंगा आय निष्फळ आयताय. ");
INSERT INTO wbq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","याय मंची भुमीला पेरासनार आय इ उंडाय, यवार वचन इनी दान ग्रहण शेस्तार इंगा यवार तीसपट, यवार साठपट, यवार शंभरपट पिक इस्तार.” ");
INSERT INTO wbq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","इंगा येशुड वारनी आन्या, “दिव्वा गंपा किंदा किंवा पलंग किंदा फेटदेंक येकोस्तार येम? दिव्वा फेटे जागाला फेट्टाला आंका एकोस्तार गरा? ");
INSERT INTO wbq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","येनटीक की प्रत्येक माटा याद दाशी फेट्टीनेद उंडाद आदी उघडाशी इंगा प्रत्येक गुप्त माटा उघड आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“यवारकी गुम्माल उंडाय वार इनाला.” ");
INSERT INTO wbq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","मग वाड वारनी आन्या, “मीर येम पण इंटार दान बद्दल सावधान उंडांडा, या मापता मीर कोल्ची इस्तार आद्दे मापता मिक कोल्ची इद्देंक वच्ची. ");
INSERT INTO wbq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","येनटीक की यवार देगार दया उंडाद वारकी इंगा इद्देंक वच्ची इंगा यवान देगार लेद वानदेगार येम उंडाद आदीपन तीस्कुन्यार.” ");
INSERT INTO wbq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","मग येशुड आन्या, “द्यावार्दी राज्य इल्ला उंडाद की, यल्ला वगा मनशी भुमीला बी पेरास्ताड. ");
INSERT INTO wbq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","मब्बुल्ला फंडकुंटाडड इंगा फदिना लेस्ताड इंगा आदी बी बुडताद इंगा वाढास्ताद इदी यल्ला आताद इदी वानकी तेल्वाद. ");
INSERT INTO wbq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","भुमी आपोआप पिक इस्ताद, पहिला कोंब इंगा उंब्या, मग कंसला नींडीनेय दानाल. ");
INSERT INTO wbq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पिक तैयार आताद आप्पुड दानकी लगेच वाड कडवाल आंचताड येनटीक की सोंगाशेद वेळ वचीनेद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","इंगा वाड आडग्या, “मनाम द्यावार राज्यद तुलना येंटी संगा शेशी शेकास्ताम किंवा इंगा या दाखलाता शप्पी शेकास्ताम? ");
INSERT INTO wbq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","आदी मोहरी दाना लेका उंडाद. याद भुमीला पेराशेताप्पुड पृथ्वीमिंदूड आन्नी दानालला आंदारकाना शिन्नाद उंटाद तरी, ");
INSERT INTO wbq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","आदी पेरासनेंका आन्नी माकला काना फेद्दाद आताद. दान्की फेद्दाय डांगील वस्ताय इंगा मोडामलोन पक्षील दान मिंदा घरटाल बनाय मती शकास्ताय.” ");
INSERT INTO wbq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","इल्ला शेंगेम दाखलाल इच्ची, येल्ला वारकी तेल्ची आल्ला वाड वारकी वचन शपदु. ");
INSERT INTO wbq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","इंगा दाखला इडशी वाड वारनी माटलाडाकुंदु. गान वगातळा वाड वान शिष्यलाक आंता समजायमत्ती शपदु. ");
INSERT INTO wbq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","आ दिवसनाडा मापसार आयनेंका येशु वान शिष्यालनी आन्या, “मनाम आतुक फोदाम दांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","दिन कस्रोम वार मंदी समुदायनी इडशीर इंगा वाड जहाजला उंड्या आल्ले वार वान एका फोईर. वार संगा इंगोगो जहाजलु पण उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","आप्पुड घालीद फेद्दा वादळ वच्या इंगा लाटलु जहाज मिंदा इल्ला आदळासु की, जहाज नेळाता निंडेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","गान येशुड यंकाड भागला गादीमींदा फंडका फोइन्या. वार वान लेपी आनीर, “गुरुजी, मनाम मुनगुतुनाम तरी निक काळजी वाटायाक वचीनाद येम?” ");
INSERT INTO wbq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","मग वाड लेश्या इंगा वाड घालीन धमकामत्या इंगा समुद्रन आन्या, “शांत उंड! तेप्पांग उंड,” मग घाली थांबाश्या इंगा आंदू फेद्दाद शांतता पसराश्या. ");
INSERT INTO wbq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","वाड वारनी आन्या, “मीर येनटीक आद्रुतार? मिदेगार इंगाना पन विश्वास येल्ला लेद?” ");
INSERT INTO wbq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","गान वार शेंगेम आद्रीर इंगा वगामेगारणी आनीर, “इड उंडाड तरी येवाड, घाली इंगा समुद्र पण इनदी इंटाय,” इल्ला इड उंडाड तरी येवाड? ");
INSERT INTO wbq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","मग येशुड इंगा वान शिष्यल सरोवर आतुक, गरसेकर प्रदेशला वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","येशुड जहाज लोन्केल दिगीन नग्रेम अशुद्ध आत्मा आंटीने वगा मनशी कब्रनुस येल्ली वानकी भेटाश्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","वाड कब्रला निलदू इंगा वान साखळ दंडलाता कट्टी फेट्टेद इप्पुड यवारकीच शक्य लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","येनटीक की वान संगेम तुकुल बेड्यालता इंगा साखळीलाता कट्टीगास पण, वाड साखळील तेम्पेस काडीन्या इंगा वान ताबाला फेट्टेद शक्ती यवार यंताच लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","वाड नेहमी मोबुफगुल कब्रला इंगा कोंडा मिन्दा उंडी कीरलु इंगा कुशिंग रायता वान शरीरनी मतकुनु. ");
INSERT INTO wbq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","येशुन दुराम नुस सुशीगास, वाड फारका वच्या इंगा वानी काळलु मोक्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","इंगा बेग्गे कीरलीगास आन्या, “हे येशु, परात्पर द्यावार कोडकु, नु नडमा येनटीक फडताव? नीन निक द्यावारदी वटु इस्तान, नाक त्रास इयाक.” ");
INSERT INTO wbq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","येनटीक की येशुड वान आनदु, “अरे अशुद्ध आत्मा, इ मनशी लोन्केल येल्ली फो.” ");
INSERT INTO wbq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","येशुड आप्पुड आडग्या, “नीद फेर येम?” वाड उत्तर इच्या, “ना फेर सैन्य, येनटीक की मिम शेंगेम उंडाम. ");
INSERT INTO wbq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","इंगा मंमलान इ प्रदेश नुस बैटीक गेदमाक” इल्ला वाड वान आग्रहद विनंती शेयदु. ");
INSERT INTO wbq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","आंदू कोंडामिंदा फंदुलाद वगाट फेद्दा खांड मेस्तुन्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","आप्पुड अशुद्ध आत्माल वान विनंती शेशेदेंक आंट्या की, “मिम आ फंदीला दुराला, दिनकस्रोम आटला तीकुड मोमलान आंपकाड.” ");
INSERT INTO wbq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","इंगा वाड वारकी परवानगी इच्या. आप्पुड आ अशुद्ध आत्माल येल्ली फंदुलाला दुऱ्या इंगा आदी दोन हजार फंदुलाद खांड फारका फोई कंटाम नुस सरोवरला फड्या इंगा नेळाला मुनगी सच्ची फोया. ");
INSERT INTO wbq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","फंदुल मेपेतोर फारीर इंगा वार उळ्या इंगा शेल्लाला इदी बातमी शप्पीर, आप्पुड येम आय्या इदी सूदेंक मंदी वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","वार येशुन देगार वचीनेन्का वाड दैयाल फटीनोड, आंटे यवानलोना सैन्य उंड्या वाड, बट्टाल फेटकुन्नोड इंगा शुद्धीमिंदा वच्चीनोड वारकी कमशा, इंगा वारकी येरपू आय्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","येवार आदी सुशीनीर वार दैयाल फटीनोन्की येम आय्या आदी इंगा फंदुला बद्दल हकीकत इंगोगोरकी शप्पीर. ");
INSERT INTO wbq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","आप्पुड मनाम मा प्रांत नुस येल्ली फोवाला इल्ला वार वानकी विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","इंगा मग वाड जहाजला फोयेताप्पुड, पहिला येवाड दैयाल फटीने मनशी वानकी विनंती शेशा की, नन्नु पण मी संगा तीस्को. ");
INSERT INTO wbq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","गान वाड वान मना संगा दानीयाले, तर वान आन्या, “नु स्वता इल्लुक इल्काटोर देगार फो इंगा प्रभूड निकस्रोम येंता फेद्दा फनी शेश्या इंगा निमिंदा यल्ला दया शेश्या इदी वारकी शप.” ");
INSERT INTO wbq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","आप्पुड वाड येल्या इंगा येशुड याद फेद्दा फनी वानकस्रोम शेशिन्या आदी दकापलीस इंदू जाहीर शेशेदेंक आंट्या. आप्पुड आंदारकी आश्चर्य वाटाश्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","मग येशुड जहाजला कुसनी आतुक फोया वान देगार मंदिद फेद्दा समुदाय जमा आय्या इंगा वाड सरोवर देगार उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","आप्पुड याईर फेरोड वगा सभास्थानोड अधिकारी आंदूक वच्या इंगा वान सुशी वानी काळलु मोक्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","वाड आग्रहता वानकी विनंती शेश्या की, “ना शिन्ना कुतुर सचीदेंक टेकास्नाद. आदी बागा आय्यी जगायाला आंका नु वची दान मिंदा शेय फेट.” ");
INSERT INTO wbq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","मग वाड वानसंगा येल्या आप्पुड शेंगेम मंदी वान यंका नडदूर इंगा वानभोवती गर्दी शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","इंगा आंदू रक्तस्त्रावता बारा वर्ष त्रासला उंडीने वगा आंडीद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","आदी संगेम वैद्यला शेतलाता संगेम हाल सोसासी दानदेगार येम उंड्या आदी आंता खर्च शेशिन्या तरी दानकी गुन्मू दान्दे दांदी दुखुम जास्तने आईन्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","येशुन बद्दल माटलू इनी आदी आ गर्दीला दुरया इंगा वान यंका वच्ची वान बट्टान मुट्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","येनटीक की आदी आनदु, “फक्त वान बट्टान जरी मुटतीन तरी नीन बागा आय्यान.” ");
INSERT INTO wbq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","आप्पुड लगेच दांदी नेत्तुर वहाशेद थांबाश्या इंगा मंनाम आ रोगनुस बागा आतीम इल्ला दानकी शरीरला अनुभव वच्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","मनालोन्केल शक्ती येल्या इदी येशुड स्वता बद्दल लगेच ओळखाश्या इंगा गर्दीला तीरगी आन्या, “ना बट्टान येवार फट्टीर?” ");
INSERT INTO wbq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","वान शिष्यल वान आनीर, “मंदिद समुदाय मनाभोवती गर्दी शेस्तुणार इदी मनाम सुस्तुनाम, तरी नु आंटाव, नाक यवार धक्का आंचीर?” ");
INSERT INTO wbq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","मग येवात इदी शेशीन्या दान सूदेंक वाड आन्नी तीकुड सुश्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","आप्पुड आ आंडीद स्वता बद्दल येम पन घडाश्या, आदी जानाशी आद्रुका-आद्रुका इंगा नडगुका-नडगूका वानदेगार वच्या इंगा वानी काळलु मोक्की आदी वानकी आंता खरेम शेप्प्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","वाड दान आन्या, “कुतुरा, नी विश्वास नीनु शिंगार शेशिनाद. शांतीता फो इंगा नी पिडा नुस मुक्त का.” ");
INSERT INTO wbq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","येशुड इदी माटलाडतुनाड इंताटला सभास्तान अधिकारी इल्लु तीकनुस काही मनसुल वच्ची वान आनीर, “नी कुतुर सच्ची फोईनाद, इप्पुड गुरुजीक त्रास येनटीक इस्ताव?” ");
INSERT INTO wbq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","गान येशुड वार माटला तीकुड ध्यानाम इयांदे, सभास्थान अधिकारीन आन्या, “आद्राक फक्त विश्वास फेट.” ");
INSERT INTO wbq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","वाड पेत्र, याकोब इंगा याकोब तम्मुड योहान, इरशिवाय यवारनीच वान जताक दानीयाक फो. ");
INSERT INTO wbq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","मग वार सभास्तान अधिकारी इल्लु देगार वच्चीर, आप्पुड येडशेतोर इंगा कीरलेतोर मंदीद गडबड वाड सुश्या. ");
INSERT INTO wbq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","वाड लोनीक फोई वारनी आन्या, “मीर येनटीक येडस्तार इंगा गडबड शेस्तार? बिडा सैया लेद, फंडकुन्नाद.” ");
INSERT INTO wbq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","आप्पुड वार वान नग्गुदूर. गान वाड आ आंता मंदीन बैटिक तीशेश्या इंगा आन्बीडा आम्मा-आब्बाड इंगा वान सोबत शिष्यल इरनी तीस्केन आन्बीडा उंड्या आंदूक वाड नोनिक फोया. ");
INSERT INTO wbq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","मग आन्बीडाद शेय फट्टी वाड आन्या, “तलीथा कुम,” दिनदी अर्थ, “बीडा, नीन निक शेप्तान, लेय.” ");
INSERT INTO wbq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","इंगा लगेच आदी आन्बीडा लेशी नडदेंक आंट्या; (आदीबारा वर्षद उंड्या.) वार संगेम आश्चर्य चकीत आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","इदी यवारकी येरका कावाराद, इल्ला वाड वारकी आज्ञा इच्या इंगा दानकी तिनदेंक इयांडा इल्ला शप्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","मग येशुड कफर्णहुम नुस येल्ली नासरथकी वान नगरकी वच्या इंगा वान शिष्यल वान संगा वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","शब्बाद दिनमू वाड यहुदी सभास्थानला शिका नेरपु. शेंगेम मंदी वानदी शिक्षण इनीर आप्पुड वार थक्क आय्यीर. वार आनीर, “इ मनशीक इदी शिकवण यानुस वच्या? वानकी द्यावार याद ज्ञान इच्चीनाड इंगा इन शेयता इ येन्नी चमत्कारलु आताय? ");
INSERT INTO wbq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","येवाड सुतार, मरिया दान कोडकु इंगा याकोब, योसे, यहुदा इंगा शिमोन इर तम्मूड वाड इडे उंडाड गरा?” इंगा इर मना संगा उंडार वार इन शेल्यान्लू लेर येम? वांदी स्वीकार शेशे बद्दल वारकी प्रश्न फड्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","इंगा येशुड वारनी आन्या, “संदेष्ट्यालदी सन्मान काद इल्ला लेद. फक्त वान नगरला, वान नातेवाईकलाला इंगा वान परिवारला वानदी सन्मान काद.” ");
INSERT INTO wbq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","काहीक बिमार मंदी मिंदा शेई फेट्टी वाड वारनी बागा शेश्या, दिन इडशी इंगोगोट यादुच चमत्कार वानकी आंदू शेय्यादाले. ");
INSERT INTO wbq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","वार अविश्वास कस्रोम वारकी आश्चर्य वाटाश्या. मग येशुड उपदेश इच्केन उळाउळाक तीरग्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","मग येशुड बारा शिष्यलनी वान तिकुड फिलच्या इंगा वारनी जोडीजोडीता आंप्या, वाड वारकी अशुद्ध आत्माल मींदा अधिकार इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","इंगा वारकी आज्ञा इच्या की, “कट्या इडशी प्रवास कस्रोम इंगोगोट येमीच एका फोकुंडा. रोट्याल, झोळी इंगा खिशाला दुडलु तीस्कोना कुंडा. ");
INSERT INTO wbq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","गान शप्पुल फेटकेन नडवांडा; रोंड आंगुल तिस्कूनाकुंडा.” ");
INSERT INTO wbq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","इंगा वाड वारनी आन्या, “यादुपण इल्लुक मीर फोतार आंदू मीर आदी शहर इडशी नंताक निलवांडा. ");
INSERT INTO wbq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","इंगा या जागाला मिद स्वागत काक फोई लेकाते मिद इनाक फोयार आंदनुस येलेताप्पुड, वारकी साक्ष कावाला आंका मी काळाद मन्नु आंदे झाड्सकाडना.” ");
INSERT INTO wbq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","मग शिष्यल आंदनुस येल्लीर इंगा मंदी पश्चाताप शैयाला दिनकस्रोम वार घोषणा शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","वार शेंगेम दैयाल तीशीर इंगा शेंगेम बिमार मंदीन नुन्या तीक्की वारनी बागा शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","हेरोद राजा येशुन बद्दल इन्या येनटीक की येशुनदी फेर आन्नी तीकुड गाजास्न्या. काही मंदी आंदूर, “बाप्तिस्मा शेशेतोड योहान सचीनेन्का लेशीनाड, दिनकस्रोम वान देगार चमत्कार शेशेद सामर्थ्य उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","बाकी मंदी आंटार, “येशुड एलीया उंडाड.” तर काही मंदी आंदूर, “इड संदेष्टा शेंगेम पहिला संदेष्ट्याल पैकी वगाड उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","इंगा हेरोद यप्पुड इन्या आप्पुड वाड आन्या, “या योहानदी नीन तलकाया कोशिन्टीन वाडे लेशीन्डाड.” ");
INSERT INTO wbq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","हेरोद स्वता योहाननी फटी तुरुंगला येशेद आज्ञा इच्चीन्या येनटीक की वान तम्मूड फिलीप्प इन वडती हेरोदियाद दिनसंगा हेरोद फेंडली शेस्कुंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","इंगा योहान हेरोदकी शपदु की, “नु नी तम्मुन वडती फेटकुणाला इदी शास्त्र नुसार लेद.” ");
INSERT INTO wbq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","दिनकस्रोम हेरोदियाद योहान बद्दल मनला कोफाम फेटन्या. आदी वान मत्तेसकाडेद मोका सूदू. गान आदी वान मती शेकायाले, ");
INSERT INTO wbq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","येनटीक की योहान नीतिमान इंगा पवित्र मनशी उंडाड इदी जानाशी हेरोद वानकी आद्रु इंगा वानदी रक्षा शेयदु. हेरोद योहानी माटलु इनदु आप्पुड, शेंगेम गोंधळाशी फोदू, तरी वाड वानी माटलु खुशीता इनदु. ");
INSERT INTO wbq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","मग वगा नाड इल्ला वेळ वच्या की हेरोदियाद येमतरी शेशी शकाश्या. हेरोद वान वाढदिवस नाबद वान प्रधान, सेनापतीलाक इंगा गालील प्रांतलोंन मुख्य मंदीक तिनकाम इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","हेरोदियादान कुतुर लोनीक फोई नाचाशी हेरोद इंगा वच्चीने सुट्टालनी खुश शेश्या. आप्पुड हेरोद राजा कुतुरनी आन्या, “निक येम बेक आदी आडगु नीन निक इस्तान.” ");
INSERT INTO wbq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","वाड वटू येस्केन दान आन्या, “ना आर्दाम राज्य नंताक येम पन नु आडग्याव आदी नीन निक इस्तान.” ");
INSERT INTO wbq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","आदी बेटीक फोया इंगा दान आम्मान आन्या, “नीन येम आडगुदून?” आम्मा आन्या, “बाप्तिस्मा शेशे योहानदी तलकाया.” ");
INSERT INTO wbq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","मग आदी आन्बीडा लगेच लोनीक राजा तीकुड फोया इंगा आन्या, “नाक नु इप्पुडे बाप्तिस्मा शेशे योहानदी तलकाया वगा तेल्याला येतकेन वच्ची इ इल्ला नाद इच्छा उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","राजाक शेंगेम वाईट वाटाश्या, गान वान वटु कस्रोम इंगा तिनदेंक वच्चीने सुट्टाल कस्रोम वानकी दान लेद आना दाक फो. ");
INSERT INTO wbq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","आप्पुड राजा लगेच जल्लादनी आंपी योहानदी तलकाया येकेन दा इल्ला आज्ञा इच्या. मग वाड फोया इंगा जेललोंक फोई योहानदी तलकाया कोश्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","आदी तलकाया तल्याला फेट्टी कुतुरकी येकेन वच्ची इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","इदी इनी. योहान शिष्यल वच्चीर इंगा वार वानदी फिनग्या येकेन फोईर इंगा कब्रला फेट्टीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","दिनबाद प्रेषितलु येशुन देगार जमा आय्यीर इंगा वार येम शेशीर इंगा नेरपीर आदी आंता वानकी शप्पीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","इंगा वाड वारनी आन्या, “मीर जंगल्लोंग शांत जागालोंक नंडा इंगा रवा आराम शेयांडा.” येनटीक की आन्दु संगेम मंदी फोयेद वच्चेद शेयदूर इंगा वारकी तिनदेंक पण वेळ शिक्का कुंदु. ");
INSERT INTO wbq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","आप्पुड वार आंदार जहाजला कुसनी शांत जागालोंक फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","गान शेंगेम मंदी वारनी फोयेताप्पुड सुशीर इंगा वार येवार उंडार इदी वारकी तेलच्या आप्पुड उळ्योन्टोर मंदी नडस्का फारका येल्लीर इंगा वार दावाकाना मुंची वार आंदुक पोहोचाशीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","येशुड कंटाम मिंदा दिगीनेन्का, वाड शेंगेम मंदिद समुदाय सुश्या; वार मेपेतोड लेकुन्ने मेंढरयाल लेका उंडीर, दिनकस्रोम वानकी वारदी दया वच्या; दिनकस्रोम वाड वारकी शेंगेम माटला बद्दल नेरपेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","शेंगेम फददु मुनगी फोईनेन्का वान शिष्यल वान तीकुड वच्ची आनीर, “इदी सुनसान जागा उंडाद इंगा इप्पुड शेंगेम मुनगीनाद. ");
INSERT INTO wbq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","मंदीन फोनी आंटे वार देगार शेलालोंक इंगा उळ्ळाक फोई वार कस्रोम तीनदेंग येमाना कोंकेन वच्यार.” ");
INSERT INTO wbq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","गान वाड वारकी उत्तर इच्या, “मिरे वारकी तिनदेंक येमाना इयांडा.” वार वान आनीर, “मिम फोई वारकी तीनदेंक दोनशे यंडी नाण्याल रोट्याल कोंका दावाला येम?” ");
INSERT INTO wbq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","वाड वारनी आन्या, “फोंडा इंगा सुडांडा की मी देगार यन्नी रोट्याल उंडाय?” सुशीनेन्का वार आनीर, “मादेगार आय्यीद रोट्याल इंगा रोंड मिल उंडाय.” ");
INSERT INTO wbq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","येशुड आंता मंदीक आज्ञा इच्या की गड्डी मिंदा कुसनांडा. ");
INSERT INTO wbq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","आप्पुड वार शंभर-शंभर इल्ला पंगतता कुसनीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","येशुड आय्यीद रोट्याल इंगा रोंड मिल तीस्केन फईक स्वर्ग तीकुड सुशी, आशीर्वाद इच्या इंगा रोट्याल तेंपी फंचेदेंक वान शिष्यल देगार इच्या इंगा मिलपण फंची इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","इंगा वार आंदार तिनी तृप्त आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","इंगा वार मिग्लीने तुकडाली बारा फुटकाल निंचकुनीर इंगा मिलाय पण तुकडाल एका फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","रोट्या तीनेतोर पाच हजार मंदी उंडीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","यंकसार नीन मंदीन इल्लुक आंपतान इंगा मीर जहाजला कुसनी आतुक बैतसदा इंदूक फोडा, इल्ला शप्पी येशुड लगेच शिष्यलनी वान मुन्दारकी फोयदेंक शेप्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","मंदीन आंपी वाड प्रार्थना शेशेदेंक कोंडा मिंदीक फोया. ");
INSERT INTO wbq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","फददु मुनग्या आप्पुड जहाज सरोवर नडमा उंड्या इंगा येशुड वक्काडे भुमी मिंदा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","इंगा वारकी वल्ही मतेदेंक कठीण फोतुनाद इल्ला वानकी कमशा, येनटीक की घाली वार उलटा उंड्या. इंगा फदिना मुड ते सहा वागीन नडमा येशु सरोवर मिन्देल नडस्का वार तीकुड वच्या, वार देगार नुस वानकी मुन्दारकी फोयेद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","गान वान सरोवर नेळामिंदा नडशेताप्पुड सुशी, वारकी वाड दैयाम उंडाड इल्ला वाटाश्या इंगा वार कीरलीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","येनटीक की वार आंदार वान सुशीर इंगा वार आद्री फोईर. वाड लगेच वारनी आन्या, “दम फटना, आद्रा कुंडा, नीन उंडान.” ");
INSERT INTO wbq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","मग वाड वार तीकुड जहाजलोंक फो आप्पुड घाली शांत आय्या. आप्पुड वार शेंगेम आश्चर्य चकीत आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","येनटीक की वारकी रोट्याद माटा तेलवा लेकुंड्या इंगा वारी मनलु कठोर आईन्या. ");
INSERT INTO wbq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","वार सरोवर दाटीनेन्का गनेसरेतकी वच्चीर इंगा जहाज कट्टेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","वार जहाजलेल दिगे ताप्पुडे मंदी येशुन ओळखाशीर. ");
INSERT INTO wbq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","इंगा वार आसपास आन्नी भागला आन्नी तीकुड फारका तीरगीर इंगा येंदू पण वाड उंडाड इल्ला मंदी गुम्मा मिन्दा फडू, आंदु-आंदु मंदी बिमार मंदीन मंचाम मिंदा येकाफोदूर. ");
INSERT INTO wbq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","वाड उळ्योंक किंवा शेल्लोंग येंदूक पण फोइना, आंदूक मंदी बिमार मंदीन भर संताला येकोची फेटदूर इंगा वान बट्टाल गोंड्यालनी तरी फट्टानिंडा इल्ला विनंती शेयदूर इंगा यंता मंदी वान फट्टीर आंता मंदी बागा आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","काही परुशील इंगा नियम शास्त्र शिक्षकलु यवार येरुशलेम शहरनुस वचीनीर, वार येशुन देगार जमा आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","इंगा वार वान काही शिष्यलनी अशुद्ध, आंटे विधी ग्रंथ अनुसार शेईल कडगांदे तीनेताप्पुड सुशीर. ");
INSERT INTO wbq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","येनटीक की परुशी इंगा आंदार यहुदी तातागार परंपरा लेका नियम शेईल शिंगार कडगीन शिवाय तीनार. ");
INSERT INTO wbq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","संतानुस एकोचीनेद वस्तू कडगीन शिवाय वार तीनार. वार पुर्वजलाय इंगोगो संगेम चालीरीतील इंगा शम्बुल, तेप्याल, राग्याय बतकुल कडगेद इल्ला इंगोगो नियमलू पाळास्तार. ");
INSERT INTO wbq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","मग परुशी इंगा नियम शास्त्र शिक्षकलु इर येशुन आडगीर, “नी शिष्यल तातागार परंपरा नियम लेकाने येनटीक जगायार? शेईल कडगांदे येनटीक तींटार?” ");
INSERT INTO wbq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","येशुड वारनी आन्या, “यशयाड यप्पुड मी ढोंगी मंदीबद्दल भविष्यवाणी शेश्या आप्पुड वानदी बरोबर उंड्या. यशया रास्ताड, ‘इ मंदी तोट्टालता नाद सन्मान शेस्तार पण वारी अंतकरणलु ना देगारनुस दुराम उंडाय. ");
INSERT INTO wbq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","वार विनाकारण नाद उपासना शेस्तार येनटीक की वार मंदीक शास्त्र आंका येम नेरपुतार आय मनसुल शेशीनेय नियमलु उंडाय.’” ");
INSERT INTO wbq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“मीर द्यावार आज्ञाद त्याग शेशी, मीर मनशीद परंपरा पाळास्तुणार.” ");
INSERT INTO wbq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","इंगा वाड वारनी आन्या, “मीर मि परंपराल पाळायदेंक द्यावारदी आज्ञा तेम्पेदेंक मंचीद पद्धत फुडकी तीशीनार. ");
INSERT INTO wbq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","मोशेळड शप्पीनाड की, ‘नु नि आम्मा-आब्बानदी सन्मान शेय इंगा या मनशी स्वता आम्मा आब्बान बद्दल खराब माटलाडताड, वान मतेसकाडेद.’ ");
INSERT INTO wbq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","गान मीर नेरपुतार, वगाट आर्दाम मनशी मना आब्बान इंगा आम्मान इल्ला आनी शेकास्ताड की, ‘मिक मदत शेयदेंग नातीकुड रवासाने उंडाद, गान मिक मदत शैयदेंग नीन आदी वापरायान, नीन आदी द्यावारकी अर्पण शेशेदेंक फेटीनान.’ ");
INSERT INTO wbq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","तर मीर वान आब्बान इंगा आम्मा कस्रोम मुन्दारकी येमीच शैय्यानीयार. ");
INSERT INTO wbq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","इ प्रकारता मीर मी स्वताय परंपराल चालू फेट्टी द्यावारदी वचन रद्द शेस्तार इंगा दिनलेका शेंगेम माटलु शेस्तार.” ");
INSERT INTO wbq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","आप्पुड येशुड मंदी समुदायनी वापस फिल्ची आन्या, “प्रत्येक मनशी नाद इनांडा इंगा इदी समजाशी तीस्कोंडा.” ");
INSERT INTO wbq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“बैटीनुस मनशी लोनिक फोई वान अपवित्र शेशी इल्ला येमीच लेद, तर मनशी नोनुस येम येलताद आद्दे वारनी अपवित्र शेस्ताद. यवारकी बी गुम्माल उंटे वार इनाला.” ");
INSERT INTO wbq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","17","मंदीसमुदाय इडशी येशुड इल्लुक फोया आप्पुड शिष्यल वान आ दाखला बद्दल आडगीर, ");
INSERT INTO wbq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","वाड वारनी आन्या, “मिक पण इदी तेलवाद येम? येम बैटीकेल मनशी लोना फोताद आदी वान अपवित्र शैयाद इदी मिक तेल्वाद येम? ");
INSERT INTO wbq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","येनटीक की आदी वान अंतकरणलोंक फोद तर वान कडपुलोंक फोताद इंगा यंकसार बैलिकला शरीरबैट्या फडताद.” इल्ला शेप्पी आन्नीप्रकारी आन्नामलान वाड शुद्ध घोषित शेशा. ");
INSERT INTO wbq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","इंगा वाड आन्या, “येम मनशी अंतकरण नुस बैट्या फडताद आदी मनशीन अपवित्र शेस्ताद. ");
INSERT INTO wbq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","येनटीक की नोनुस आंटे अंतकरणनुस खराब विचारलु बैट्या फडताय. खराब माटलु, दोंगा, खून, ");
INSERT INTO wbq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","व्यभिचार, लालच, वाईटपणा, कपट, असभ्यता, हेवा, तीटलु, अहंकार इंगा मूर्खपना, ");
INSERT INTO wbq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","इ आन्नी वाईट माटलु नोनुस बैटीक फडताय इंगा मनशीन अपवित्र शेसताय.” ");
INSERT INTO wbq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","येशुड आ जागानुस येल्ली इंगा सिदोन प्रांतलोंक फोया. आंदू वाड वगा इल्लुक फोया इंगा इदी यवारकी तेल्वाराद इल्ला वानदी इच्छा उंड्या. तरी वानकी दोक्केन निल्चेद शक्य लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","गान यादान शिन्ना कुतुरकी अशुद्ध आत्मा आंटीन्या इल्ला वगा आंडीद वानबद्दल लगेच इन्या इंगा आदी वच्ची वानी काळलु मोक्या. ");
INSERT INTO wbq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","आदी आंडीद ग्रीक उंड्या इंगा सिरीयालोन फिनीशिया इंदू फुट्टीन्या. आदी येशुन दान कुतुरदी दैयाम तीदेंक विनंती शेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","वाड दान आन्या, “पहिला बीळ्ळान कडपु निंडा तिनानी येनटीक की बीळ्ळाद रोट्या तीस्केन आदी कुक्कालकी येशेद शिंगार लेद.” ");
INSERT INTO wbq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","गान आदी वान आन्या, “प्रभू, कुक्कालपण बीळ्ला शेतल्योन्केल पलंग किंदा फडीने चुरा तीनटाय.” ");
INSERT INTO wbq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","वाड आ आंडीदान आन्या, “नी इ माटला कस्रोम फो, नी बीळानुस दैयाम येल्ली फोयनाद.” ");
INSERT INTO wbq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","इंगा आदी इल्लुक वच्या आप्पुड दान कुतुर गादीमींदा फडीनाद इंगा दाननुस दैयाम येल्ली फोयनाद. इल्ला आदी सुश्या. ");
INSERT INTO wbq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","येशुड सोर देगार प्रदेश नुस वापस वच्या इंगा सिदोननुस दकापलीस दावाता गालील सरोवर तीकुड वच्या. ");
INSERT INTO wbq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","आंदू काही मंदी वगा बहिर्या तोतर्या मनशीन येशुन तीकुड येकोचीर इंगा नु वान मिंदा शेई फेट इल्ला विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","येशुड वान आ मंदी देगारनुस वगा बाजूक एका फोई वान गुम्माला बोटलु येश्या इंगा उमशी वान न्यालकाक शेय आंच्या. ");
INSERT INTO wbq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","वाड स्वर्गतीकुड सुशी श्वास इडश्या इंगा आन्या, “इफ्फाथा.” आंटे, “मोकळा का.” ");
INSERT INTO wbq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","इंगा आद्दे वेळ वानी गुम्माल मोकळा आय्या इंगा न्यालका मोकळा इडया इंगा वानकी माटलाडा वच्या ");
INSERT INTO wbq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","आप्पुड इदी यवारकी शप्पा कुंडा इल्ला वाड वारकी आदेश इच्ची शेप्या. गान वाड वारनी यंता मना शेश्या, आल्ला वार जास्तने शेपका फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","वार मंदी शेंगेमे आश्चर्य चकीत आय्यीर इंगा आनीर, “वाड आंता बागा शेशिनाड. वाड बहिर्योरकी इनेद इंगा मुक्योरकी माटलाडेद शक्ती इसताड.” ");
INSERT INTO wbq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","आ दिनमुलाला वापस मंदीद फेद्दा समुदाय जमा आय्या इंगा वारदेगार तिनदेंक येमी लेकुंड्या. येशुड वान शिष्यलनी फिलच्या इंगा वारनी आन्या, ");
INSERT INTO wbq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“नाक इ मंदिद मैया वस्ताद, येनटीक की इबद मूड नाळ वार ना संगा उंडार इंगा वार देगार तिनदेंक येमीच लेद. ");
INSERT INTO wbq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","नीन जर वारनी उपास इल्लुक आंपतीन तर वार दावाताने चक्कर वच्ची फड्यार इंगा वार दिंटल्या काही मंदी तर दुराम नुस वचीनार.” ");
INSERT INTO wbq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","वान शिष्याल उत्तर इच्चीर, “इंदू सुनसान जागाला वार तृप्त आय्यार इन्नोट रोट्याल यानुस एका दावाला?” ");
INSERT INTO wbq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","वाड वारनी आडग्या, “मी देगार येन्नी रोट्याल उंडाय?” वार आनीर, “योड.” ");
INSERT INTO wbq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","वाड मंदीक किंदा कुसनेद आज्ञा इच्या. वाड योड रोट्याल तीस्कोन्या, आभार मानाश्या इंगा आय तेम्प्या इंगा वान शिष्यलाक आय फंचीदेंक इच्या इंगा वार आय मंदीक फनचीर. ");
INSERT INTO wbq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","वार देगार शिन्नाय मिल उंड्या, आटलाक वाड आशीर्वाद इच्ची आय पण फंचीदेंक शेप्या. ");
INSERT INTO wbq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","वार तिनी तृप आय्यीर इंगा मिलगीने योडं फुटकाल शिष्यल निम्पीर. ");
INSERT INTO wbq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","वार सुमारे नालुंग हजार मनसूल उंडीर. इंगा येशुड वारनी इल्लुक आंप्या. ");
INSERT INTO wbq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","इंगा लगेच वाड शिष्यल संगा जहाजला कुसन्या इंगा दल्मनुथा प्रदेशलोंक फोया. ");
INSERT INTO wbq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","मग काही परुशील वच्ची वान संगा जगडाम आडदेंक आंटीर. वानदी परीक्षा सूडाला आंका वार वान स्वर्गनुस चिन्हल आडगीर. ");
INSERT INTO wbq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","वान आत्माला फेद्दा श्वास इडशी वाड आन्या, “इदी पीढी चिन्ह येनटीक आडगुताद? नीन खरेम शेपतान की, इ पिढीक चिन्हल इयाक फोयार.” ");
INSERT INTO wbq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","मग वाड वारनी इडशी इंगा जहाजला फोई कुसन्या इंगा सरोवर आतकुड बाजूक फोया. ");
INSERT INTO wbq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","आप्पुड शिष्यल रोट्याल येकोचेद मरशी फोईर इंगा जहाजला वार देगार वगाटे रोट्या उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","सुडांडा येशुड चेतावनी इच्ची आन्या “सांभाळींडा, परुशीला खमीर इंगा हेरोद खमीरनुस सावधान उंडांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","मग वार आपसला चर्चा शैयदूर की, “मना देगार रोट्याल लेव आंका वाड आन्या येम?” ");
INSERT INTO wbq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","वार येम माटलाडदुर इदी ओळखाशी येशुड वारनी आन्या, “मी देगार रोट्याल लेव दिन बद्दल चर्चा येनटीक शेस्तार? इंगाना मी लक्षला दालेद येम इंगा मिक तेलची पण तेलवाले येम? मि अंतकरण कठोर आयनाद येम? ");
INSERT INTO wbq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","कंडलु उंडी पण कमसाद येम? ");
INSERT INTO wbq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","नीन पाच हजार मंदीक पाच रोट्याल फंचतीन आप्पुड मीर रोट्या तुकडाली येन्नी फुटकाल निंचकुंटीर.” शिष्यल उत्तर इच्चीर, “बारा.” ");
INSERT INTO wbq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“इंगा नालुंग हजार कस्रोम नीन सात रोट्याल तेन्पुतीन, आप्पुड मीर तुकडाली येणी टोपलील जमा शेस्तीर?” शिष्यल उत्तर इच्चीर, “योड.” ");
INSERT INTO wbq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","मग येशुड वारनी आन्या, “मिक इप्पुड पण तेलवाद येम?” ");
INSERT INTO wbq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","वार बेथसैदा इंदूक वच्चीर. आप्पुड मंदी वान देगार वगा गुड्ड्योन येकोचीर इंगा वाड वान मुट्टाला इल्ला विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","मग वाड गुड्ड्योनदी शेय फट्टी वान उर बैटीक येका फोया येशुड आ गुड्ड्योन कंडला मिंदा उमश्या इंगा वान शेयला मिंदा शेईल फेट्टी आडग्या, “निक येमाना कमस्ताद येम?” ");
INSERT INTO wbq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","वाड फईनिक सुश्या इंगा आन्या, “नाक मनसुल कमस्तुनार इल्ला वाटास्तुनाद येनटीक की वार नाक माकला गता कमस्तुनार, तरी पण वार नडस्तुनार.” ");
INSERT INTO wbq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","मग येशुड वापस वानी शेईल मनशी कंडला मिंदा फेट्या. वाड कंडलु तेरश्या आप्पुड वानी कंडलु उघडाश्या इंगा वानकी आंता स्पष्ट कमशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","येशुड वान आन्या, “आ उळ्या काल पण फेट्टाक” इल्ला शेप्पी इल्लुक आंप्या. ");
INSERT INTO wbq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","मग येशुड इंगा वान शिष्यल फिलीप्प कैसरीया फेर प्रदेशकी फोयदेंक येल्लीर. दावाता वाड वान शिष्यलनी आडग्या, “मंदी नन्नु येम आंका ओळखास्तार?” ");
INSERT INTO wbq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","वार वानकी उत्तर इच्चीर, “काही मंदी आंटार, नु बाप्तिस्मा इच्चेतोड योहान, तर काही मंदी एलीया समजास्तार, तर इंगोगोर काही मंदी नु संदेष्ट्याल पैकी वगाड उंडाव इल्ला आंटार.” ");
INSERT INTO wbq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","मग येशुड वारनी आडग्या, “मिक नीन येवार उंडान इल्ला वाटास्ताद?” पेत्रड उत्तर इच्या, “नु ख्रिस्त उंडाव.” ");
INSERT INTO wbq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","येशुड शिष्यलनी आन्या, “नीन यवार उंडान इदी यवारकीच शेप्पाकुंडा.” ");
INSERT INTO wbq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","वाड वारकी नेरपेदेंक आंट्या, मनशी कोडकु शेंगेम दु:ख सहन शेय्याला. आब्बागार, मुख्य याजक मंदी, नियमशास्त्र शिक्षकलु इर तीकनुस नाकारादेंक दावाला, वान जेमफडा मत्ताला इंगा मुड नाळाक वाड इंगा जिवंत आय्यी इदी आय्येद नक्की उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","वाड इदी स्पष्ट मनता शेप्या, आप्पुड पेत्रड येशुन बाजूक तीस्कुनी वान बेद्रीच्या. ");
INSERT INTO wbq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","येशुड तीरगी वान शिष्यल तीकुड सुश्या इंगा पेत्रन बेद्रीची आन्या, “ये शैतान, ना देगार नुस येल्ली फो! येनटीक की नु द्यावार माटला तीकुड ध्यानाम इयाव, तर मनशी माटला तीकुड ध्यानाम इस्ताव.” ");
INSERT INTO wbq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","मग येशुड मना शिष्यलान इंगा मंदीन फिलच्या इंगा वारनी आन्या, “जर यवारकी आना ना यंका वच्चेद उंटे तर वाड स्वताद नकार शेय्याला. स्वतःद क्रूस येतकेन नायंका दावाला. ");
INSERT INTO wbq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","यवारकी पण स्वताद जेम वाचाय मतेदेंक सुशी वाड गमायमती इंगा यवार पण ना कस्रोम इंगा सुवार्ता कस्रोम जेम इडशी वाड स्वताद जेम वाचायमती. ");
INSERT INTO wbq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","मणशी आंता दुन्याम जिंकाश्या इंगा स्वता जेमुद नाश शेश्या तर वांकी येम फायदा? ");
INSERT INTO wbq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","जेमबदल मनशी येम इच्ची? ");
INSERT INTO wbq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","व्यभिचारी इंगा पापी पिढीला यवार पण नाद इंगा ना वचनलाद शिगु फेटतार तर मनशी कोडकु येप्पुड मना आब्बान गौरवला पवित्र दुतला संगा वच्ची आप्पुड वारदी शिगु फट्टी.” ");
INSERT INTO wbq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","येशुड आ मंदीन आन्या, “नीन मिक खरेम शप्तान की, इंदू नीला फडीनोर काही मंदी इल्ला उंडार की, यवार की द्यावारदी राज्य सामर्थ्यता वचीनेद कमशी नंताक सावूद अनुभव दाक फोई.” ");
INSERT INTO wbq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","आर नाळा बाद येशुड पेत्र, याकोब इंगा योहान इरनी वान यंका फेद्दा कोंडा मिन्दिक एका फोया इंगा वार मुंदार वानदी रुपांतर आय्या. ");
INSERT INTO wbq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","वानी बट्टाल चमकदार, शेंगेम तेल्लांग, इंता की पृथ्वीमिंदा येवारूच इंता तेल्लांग उत्की शेकायार, इल्ला आयन्या. ");
INSERT INTO wbq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","आप्पुड एलीयाड इंगा मोशेड वान मुंदार प्रकट आय्यीर, वार येशुन संगा माटलाडदूर. ");
INSERT INTO wbq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","पेत्र येशुन आन्या, “रब्बी, मनाम इंदू उंडाम इदी बागुंडाद. मनाम मूड मंडपलु बना मतुदाम. वगाट निक, वगाट मोशेन कस्रोम इंगा वगाट एलीयान कस्रोम.” ");
INSERT INTO wbq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","पेत्र इल्ला आन्या येनटीक की, येम माटलाडेद इदी वान्की तेलवाकुंडू येनटीक की वार आद्री फोइनीर. ");
INSERT INTO wbq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","आप्पुड वगाट मोडाम वच्या इंगा वार मिंदा सावली शेश्या इंगा मोडाम नुस वगाट आवाज वच्या, “इड ना प्रिय कोडकु उंडाड वानदी मीर इनांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","अचानक, वार आजु बाजूक सुशीर आप्पुड वारकी येशुन शिवाय येवारूच कमसालेद. ");
INSERT INTO wbq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","वार कोंडा मिंदनुस किंदीक वच्चेताप्पुड, येशुड वारकी आज्ञा इच्या की, “मीर येम सुस्तीर आदी मनशी कोडकु सावनुस लेशी नंताक यवारकीच शप्पाकुंडा.” ");
INSERT INTO wbq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","दिनकस्रोम वार पण इदी माटा वार नडमाने फेट्टीर, पन सावनुस लेशेद दिंदि अर्थ येम दिन बद्दल आपसला चर्चा शेयदुर. ");
INSERT INTO wbq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","वार येशुन आडगीर, “पहिला एलीयाड दावा बेक इल्ला नियम शास्त्र शिक्षकलु येनटीक आंटार?” ");
INSERT INTO wbq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","वाड वारनी आन्या, “इंग्या, एलीयाड पहिला वच्चीगास आंता शिंगार शेशी इदी खरेम उंडाद. गान मनशी बिडा बद्दल वाड शेंगेम दु:खल सहन शेशी इंगा नकार शेस्कामला वच्ची इल्ला पवित्र शास्त्रला येनटीक राशिनार? ");
INSERT INTO wbq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","नीन मिक शेपतान, एलीयाड वच्चीनाडूच इंगा वानबद्दल राशिन लेका, वारकी वाटाश्या आल्ला वार वान संगा शेशीर.” ");
INSERT INTO wbq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","यप्पुड येशुड इंगा मुग्गुर शिष्यल बाकी शिष्यला देगार वच्चीर, आप्पुड वार यंका फेद्दाद मंदी समुदाय उंड्या इंगा नियमशास्त्र शिक्षकलु वारसंगा जगडाम शेयदूर इल्ला वारकी कमशा. ");
INSERT INTO wbq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","आंता मंदी येशुन सुशी नग्रेम आश्चर्य चकीत आय्यीर इंगा वार वानदी स्वागत शेशेदेंक फारीर. ");
INSERT INTO wbq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","येशुड शिष्यलनी आडग्या, “मीर वार संगा येनटीक जगडाम आडतुनार?” ");
INSERT INTO wbq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","आप्पुड समुदायलोन वगाड वानकी उत्तर इच्या, “गुरुजी, नीन ना कोडकुन नि देगार येकोस्तीन. वान लोना दृष्ट आत्मा उंडाद याद वान माटलाडा नियाद. ");
INSERT INTO wbq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","यप्पुड पण आदी वान फटताद आप्पुड वान किंदा आपटास्ताद इंगा मुतिक फेस येकोस्ताद, फंडलु कोरकुताद इंगा अकडाशी फोयताड. नीन नि शिष्यलनी तीदेंक शेपतीन गान वार तीशी शकायाले.” ");
INSERT INTO wbq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","येशुड वारनी आन्या, “हे अविश्वासी पिढी, नीन याडनंताक मी संगा उंड्यान? नीन मी संगा याडनंताक सहन शेयदून? बिडान नादेगार एकादांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","मग वार बीडान येशुन देगार येकोचीर, यप्पुड आ दृष्ट आत्मा येशुन तीकुड सुश्या आप्पुड बीडान फिंडेस काड्या इंगा वाड भुमी मिंदा फडी नोरूक फेस एकोची लोळायदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","मग येशुड वान आब्बान आडग्या, “यप्पुड नुस इड इल्ला उंडाड?” आब्बाड उत्तर इच्या, “फुट्टीननुस इड इल्ला उंडाड. ");
INSERT INTO wbq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","शेंगेम तुकुल मत्तेदेंग आदी वान आग्गीला इंगा नेळाला येश्या. जर नि शेयता येमाना आय्येद शक्य उंटे तर मा मिंदा दया शेय इंगा माक मदत शेय.” ");
INSERT INTO wbq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","येशुड वान आन्या, “शक्य उंटे तर, इल्ला येनटीक आंटाव? विश्वास फेटेतोरकी आंता शक्य उंटाद.” ");
INSERT INTO wbq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","आप्पुड लगेच मोगबिडा आब्बाड बेग्गे कीरली आन्या, “नीन विश्वास शेस्तान, नाद अविश्वास तीशेसकाड.” ");
INSERT INTO wbq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","येशुड मंदी समुदाय मना तीकुड फारका वस्तुनाद इल्ला सुश्या आप्पुड येशुड आ दृष्ट आत्मान बेद्रीची आन्या, “अरे मुकी बहिरी आत्मा, नीन निक आज्ञा इस्तान की, इन नोनुस बैटीक येल इंगा यपुडच इन नोना दुराक.” ");
INSERT INTO wbq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","नग आदी कीरली इंगा वान शेंगेम फिंडी बैटीक येल्या इंगा मोगबीडा सचीन लेका आय्या इंगा मंदीक वाटाश्या, वाड सची फोया. ");
INSERT INTO wbq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","गान येशुड वान शेय फट्टी लेप्या इंगा वाड नीला फड्या. ");
INSERT INTO wbq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","मग येशुड इल्लुक फो इल्काडा वान शिष्यल वान एकांतला आडगीर, “मिम आदी अशुद्ध आत्मा येनटीक तिशी शकायालेम?” ");
INSERT INTO wbq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","येशुड वारनी आन्या, “इदी जात प्रार्थना इडशी इंगा दुसरा येनटीताच येल्लेद शक्य लेद.” ");
INSERT INTO wbq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","येशुड इंगा वान शिष्यल आंदनुस येल्लीर इंगा गालील प्रांतनुस प्रवास शेस्का नडदूर. इदी यवारकीच येरका कावाराद इदी येशुनदी इच्छा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","येनटीक की वाड मना शिष्यलकी नेरपु. वाड वारनी आन्या, “मनशी कोडकुन विश्वासघात शेशी फट्टी मन्सुला शेतल्या इच्काम्ला वच्ची. वार वान मतेश्यार. गान सचीनेन्का वाड मुड नाळाक लेशी.” ");
INSERT INTO wbq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","गान इ माटाद अर्थ वारकी तेल्वालेद इंगा आ विषयला वान आडगेदेंक वार येरस्कूनदूर. ");
INSERT INTO wbq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","येशुड इंगा वान शिष्यल मुंदारकी कफर्णहुमकी वच्चीर. येशुड इल्काडा उंड्या आप्पुड वाड वारनी आडग्या, “दावाता मीर या माटामिंदा चर्चा शेयदूर?” ");
INSERT INTO wbq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","गान वार तेप्पांग निलचीर येनटीक की दावाता आंदार काना फेद्दावोड येवाड इ माटामिंदा चर्चा नडशिन्या. ");
INSERT INTO wbq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","मग येशुड किंदा कुसन्या, वाड बारा शिष्यलनी फिलची वारनी आन्या, “जर यवारकी आना फेद्दावोड आय्येद उंटे तर वाड आंदारकाना शिन्नावोड कावाला इंगा आंदार सेवक कावाला.” ");
INSERT INTO wbq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","मग येशुड वगा बीडान वार नडमा नीला फडामत्या इंगा आन्या? ");
INSERT INTO wbq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“यवाड पण इ शिन्ना बीडान ना फेरता स्वीकार शेस्ताड वाड नन्नु स्विकार शेस्ताड इंगा यवार पण नन्नु स्वीकार शेस्ताड वाड फक्त नन्ने स्वीकार शेस्ताड इल्ला लेद तर यवाड नन्नु आंपीनाड वान पण स्वीकार शेस्ताड.” ");
INSERT INTO wbq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","योहान येशुन आन्या, “गुरुजी, मिम वगान नी फेरता दैयाल तीशेतापुड सुस्तीम इंगा मिम वान लेद आंटीम, येनटीक की वाड मना दिंटल्योनटोड लेकुंड्या.” ");
INSERT INTO wbq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","गान येशुड आन्या, “वान लेद आनाकुंडा, येनटीक की यवार पण ना फेरता चमत्कार शेस्ताड वाड इंगा ना विषयला वाईट माटलाडाड. ");
INSERT INTO wbq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","यवार मना विरुद्ध लेर वार मनातीकुड उंडार. ");
INSERT INTO wbq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","नीन मिक खरेम शेपतान, ख्रिस्त सेवक आंका येवाडाना मिक वगा शंबाड नेळ इच्यार वाड नक्की वान प्रतीफळकी चुकायाक फोई.” ");
INSERT INTO wbq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","नामिंदा विश्वास फेटेतोर इ शीन्नावोरलोन वगान पण येवाडाना पाप शेयामती, वान गोन्तुला इसरायदी पाट कट्टी वान समुद्रला फेकेशेद वान कस्रोम बागुंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","जर नीद मंची शेय नीनु पाप शेशेदेंक आंस्ते तर आदी कोसकाड. रोंड शेतुल उंडी नरकला यप्पुडूच आराद इल्लोन आग्गीला फोये काना वगा शेय लेन्दे अनंतजीवनला फोयेद शिंगार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","इंगा जर नीद काल नीनु पाप शेयदेंग आंस्ते तर आदी तीस्काड. रोंड काळलु उंडी नरकला फोयेकाना लंगडा आय्यी अनंतजीवनला फोयेद शिंगार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","जर नीद मंची कन्नु नीनु पाप शेयदेंग आंस्ते तर आदी तीस्काड. रोंड कंडलु उंडी यंदु फुल्गुल येपुडूच सैयाव इंगा आग्गी आराद इल्लोन नरकला फेकेस्कामला दावाला दानकाना वगा कन्नु उंडी द्यावार राज्यला फोयेद इदी शिंगार उंडाद, ");
INSERT INTO wbq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","येनटीक की आंदारदी आग्गीता परीक्षा तीस्कुनदेंक वच्ची. ");
INSERT INTO wbq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“उप्पु शिंगार उंडाद. जर उप्पु दानदी खारटपना इडस्ते तर आप्पुड दान यल्ला रोस शेस्यार. मीर स्वताला उप्पु उंडा निंडा इंगा वगामेगार संगा शांतीता निलवांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","मग येशुड आदी जागा इडश्या इंगा यहुदिया प्रांत दाटी यार्देन वंका आतुक फोया. मंदी समुदाय वगातळा आय्यी वान देगार वच्चीर इंगा वाड वान रितीलेका वारकी नेरप्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","काही परूशी मंदी येशुन तीकुड वच्चीर. वार वान आडगीर, “मोगुड वडतीन इडवाला इदी बरोबर उंडाद येम?” इदी वार वानदी परिक्षा तीस्कुनदेंक आडगीर. ");
INSERT INTO wbq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","येशुड वारकी उत्तर इच्या, “मोशेड मिक येम आज्ञा इच्चीनाड?” ");
INSERT INTO wbq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","वार आनीर, “मोशेड मनशीक सोडचिट्ठी राशी मना वडतीन इडशेद परवानगी इच्चीनाड.” ");
INSERT INTO wbq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","येशुड वारनी आन्या, “फक्त मी अंतकरण कठोरपणा कस्रोम मोशेड इदी आज्ञा मीकस्रोम राशीन्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","गान उत्पत्ती सुरवातनुस द्यावार वारनी आंडीद इंगा मनशी इल्ला बनायमतीन्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","दिन कस्रोम मनशी मना आम्मा-आब्बान इडशी वडतीसंगा नीलची. ");
INSERT INTO wbq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","इंगा वार इद्दार वगा शरीर आय्यार. दिन कस्रोम वार इद्दार लेर तर वगा शरीर उंडार. ");
INSERT INTO wbq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","दिनकस्रोम द्यावार येम जोडशिनाद, आदी मनशी तेम्पाराद.” ");
INSERT INTO wbq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","यप्पुड येशूळड इंगा शिष्यल इल्काडा उंडीर, शिष्यल इ विषय बद्दल वापस वान आडगीर. ");
INSERT INTO wbq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","वाड वान आन्या, “येवाड मना वडतीन इडस्ताड इंगा इंगोगो फेंडली शेस्कुंटाड वाड पहिला वडती विरुद्धला व्यभिचार शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","इंगा जर वडती मना मोगुन इडस्ताद इंगा इंगोगो फेंडली शेस्कुंटाद, तर आदी पण व्यभिचार शेस्ताद.” ");
INSERT INTO wbq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","येशुड बिळ्ळामिंदा शेय फेट्टाला इंगा आशीर्वाद इयाला आंका मंदी बिळ्ळान वान तीकुड येकोचीर, पण शिष्यल वारनी बेद्रीचीर. ");
INSERT INTO wbq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यप्पुड येशुड इदी सुश्या आप्पुड वाड कोफामला वारनी आन्या, “शिन्ना बिळ्ळान ना देगार दानिंडा. वारनी लेद आनाकुंडा येनटीक की द्यावारदी राज्य वारलेकाने उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","नीन मिक खरेम शेपतान, येवार पण बिळ्ळालेका द्यावार राज्यद स्वीकार शेय्यार वारदी प्रवेश द्यावार राज्यला काक फोई.” ");
INSERT INTO wbq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","आप्पुड वाळ बिळ्ळन येतकेन देगार तीस्कुन्या. मना शेय वार मिंदा फेट्या इंगा वारकी आशीर्वाद इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","येशुड प्रवासकी फोयेताप्पुड वगा मनशी वानतीकुड फारका वच्या इंगा वान मुंदार मोकाळलु टेकाशी आन्या, “हे उत्तम गुरु, अनंतकाळदी जीवन मिळामतदेंक नीन येम शेयदून?” ");
INSERT INTO wbq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","येशुड वान आन्या, “नु नन्नु उत्तम येनटीक आंटाव? द्यावारशिवाय यवारूच उत्तम लेर. ");
INSERT INTO wbq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","निक आज्ञाल येरका उंडाइच; खून शेयाक, व्यभिचार शेयाक, दोंगा शेयाक, खोटा साक्ष इयाक, फसा मत्ताक, मना आब्बानदी इंगा आम्माद सन्मान शैय.” ");
INSERT INTO wbq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","आ मनशी आन्या, “गुरु, नीन जवानी नुस इ आज्ञाल पाळास्तुनान.” ");
INSERT INTO wbq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","येशुड वान तीकुड सुश्या वाड वान मिंदा प्रीती शेश्या इंगा वान आन्या, “नि लोना वगा माटाद कमी उंडाद. फो, नि देगार येम उंडाद आदी आंता आंमु इंगा गरीबोरकी इच्काड, आंटे स्वर्गला निक संपती शिक्की इंगा मग नडू, ना यंका दा.” ");
INSERT INTO wbq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","इदी माटा इनी आ मनशी शेंगेम उदास आय्या इंगा दुखी आय्यी येल्ली फोया येनटीक की वान देगार शेंगेम संपती उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","येशुड आजुबाजूक सुश्या इंगा वाड वान शिष्यलनी आन्या, “द्यावार राज्यला धनवान मनशीद प्रवेश यंता कठीण उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","वानी माटलु इनी शिष्यलकी नवल वाटाश्या, गान येशुड वारनी वापस आन्या, “ना बिळ्ळालाला, द्यावार राज्यला प्रवेश यंता कठीण उंडाद! ");
INSERT INTO wbq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","श्रीमंत मनशीद द्यावार राज्यला प्रवेश आय्येकाना वंट्याक सुदी लोन्केल फोयेद सोपा उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","वार इंगा जास्त आश्चर्य चकीत आय्यीर इंगा वगामेगारनी आनीर, “तर मग यवारदी तारण आय्येद शक्य उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","वारतीकुड सुशी येशुड आन्या, “मनसुलाक इदी अशक्य उंडाद पण द्यावारकी लेद, येनटीक की द्यावारकी आंता शक्य उंडाय.” ");
INSERT INTO wbq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पेत्र वान आनेदेंक आंट्या, “सूड, मिम आंता इडशिनाम इंगा नियंका वच्चीनाम.” ");
INSERT INTO wbq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","येशुड आन्या, “नीन मिक खरेम शेपतान, यवार-यवार नाकस्रोम इंगा सुवार्ता कस्रोम इल्लु, शेल्याल, तम्मुड, आमाआब्बाड, बिळ्ळू इंगा शेनशटटू इडशिनार, ");
INSERT INTO wbq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","इल्ला प्रतेक मनशिक शेवट काळला छळनुकसंगा शंभरपटता इंडलु, तम्मुळलु, शेल्यानलु, आम्मा, बीळ्ळू, शेनलू इंगा वच्चे युगला अनंतकाळदी जीवन मिळाय मत्यार. ");
INSERT INTO wbq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","गान शेंगेम मंदी येवार पहिला उंडार वार आखरीक आय्यार इंगा आखरीक उंडार वार पहिला आय्यार.” ");
INSERT INTO wbq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","येशुड इंगा शिष्यल यरुशलेम शहर दावाता फोयेताप्पुड येशुड वार मुंदारकी नडदु. वान शिष्यल विस्मित आय्यीर इंगा वानयंका वचेतोर आद्री फोईनीर. मग येशुड आ बारा शिष्यलनी वापस वगा तीकुड तीस्कुन्या इंगा वान बद्दल येम आय्यी इदी वारकी शेप्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“सुडांडा! मनाम मिन्दिक येरुशलेम शहरकी फोतूनाम इंगा मनशी कोडकुन फट्टी मुख्ययाजक मंदी इंगा नियमशास्त्र शिक्षकलु इर शेतला इच्यार. वार वानकी सच्चेद शिक्षा इच्यार इंगा वार वान इंगोगो यहूदी मंदी शेतला इच्यार. ");
INSERT INTO wbq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","वार वानदी मजाक येगरा मत्यार, वानमिंदा उमश्यार, वानकी देब्बाल मत्यार, मतेश्यार इंगा मूड नाळाक वाड इंगा लेशी.” ");
INSERT INTO wbq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","आप्पुड याकोब इंगा योहान इर जब्दी कोडकुल वान देगार वच्चीर इंगा वान आनीर, “गुरु, मिम येम नीदेगार आडग्याम आदी नु आदी मा कस्रोम शेय इल्ला माद इच्छा उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","येशुड वारनी आडग्या, “नीन मी कस्रोम येम शेयदून इल्ला मिद इच्छा उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","वार आनीर, “नी वैभवला मानुस वगान मंची शेय तीकुड इंगोगोन रोड्डा शेय तीकुड कुसनेद अधिकार माक इ.” ");
INSERT INTO wbq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","येशुड वारनी आन्या, “मीर येम आडगुतुनार इदी मिक येरका लेद. नीन याद प्याला तागतान, आदी मिक तागेद शक्य उंडाद येम? का नीन याद बाप्तिस्मा तीस्कुंटूनानन आदी मिक तीस्कुनेद शक्य उंडाद येम?” ");
INSERT INTO wbq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","वार वान आनीर, “माक शक्य उंडाद.” मग येशुड वारनी आन्या, “नीन याद प्याला तागतान आदी मीर ताग्यार इंगा याद बाप्तिस्मा नीन तीस्कुन्यान आदी मीर तीस्कुन्यार, ");
INSERT INTO wbq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","गान ना मंची शेय तीकुड किंवा रोड्डा शेय तीकुड कुसना निच्चेद ना शेतल्या लेद. येव्वार कस्रोम आय जागाल तैयार शेशिनार, वार कस्रोमे आय राखाशी फेट्टीनाम.” ");
INSERT INTO wbq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","फदी शिष्यल इदी विनंती इनीर आप्पुड वार याकोब इंगा योहान मिंदा शेंगेम कोफाम फडीर. ");
INSERT INTO wbq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","आप्पुड येशुड वारनी देगार कुतेश्या इंगा आन्या, “मिक येरका उंडाद की, यहुदी लेनोर यवार अधिपतील उंडार वार वारमिंदा स्वामित्व गाजामतुतार इंगा वारमिंदा अधिकार शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","गान मी बद्दल आल्ला लेद. मी नडमा येवारकी आना फेद्दावोड आयदेंक सुस्तार वाड सेवक कावाबेक. ");
INSERT INTO wbq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","इंगा यवारकी पण पहिला आय्येद उंटे वानकी आंदार सेवक कावाबेक. ");
INSERT INTO wbq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","येनटीक की मनशी कोडकु पण सेवा शेस्कुनदेंक दालेद तर सेवा शेशेदेंक वच्चीनाड, शेंगेम मंदी सूटकारा कस्रोम स्वताद जेम इद्देंक वच्चीनाड.” ");
INSERT INTO wbq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","येशुड इंगा शिष्यल यरीहो शहरकी वच्चीर. मंदीसमुदाय संगा यरीहो इडशी फोयेताप्पुड तीमया कोडकु बार्तीमय इड वगा गुड्ड्योड भिकारी दावा बाजूक कुशींड्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","यप्पुड वाड इन्या की, नासरथ येशुड फोयतुनाड आप्पुड वाड बेग्गे कीरली आनेदेंक आंट्या, “येशु, दावीद कोडका नामिंदा दया शेय.” ");
INSERT INTO wbq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","आप्पुड वाड तेप्पांग उंडाला आंका शेंगेम मंदी वान बेद्रीचीर. गान वाड इंगा बेग्गे कीरली आनदु, “येशु दावीद कोडका ना मिंदा दया शेय.” ");
INSERT INTO wbq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","मग येशुड थांबाश्या इंगा आन्या, “वान कुतेयंडा,” आप्पुड वार आ गुड्डी मनशीन कुतेशी आनीर, “दम फट, येशुड नीनु कुतेस्तुनाड.” ");
INSERT INTO wbq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","आ गुड्डी मनशी वानदी झगा फेकेश्या, इंगा लगेच लेशी येशुन तीकुड वच्या. ");
INSERT INTO wbq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","येशुड वान आन्या, “नीन नि कस्रोम येम शेयदून इल्ला नीद इच्छा उंडाद?” गुड्डी मनशी वान आन्या, “रब्बी, नाक वापस कमसाला.” ");
INSERT INTO wbq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","मग येशुड वान आन्या, “फो! नि विश्वास नीनु शिंगार शेश्या.” लगेच वाड सुदेंक आंट्या इंगा दावाता वाड येशुन यंकाने नडदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","यप्पुड येशुड इंगा शिष्यल यरुशलेम शहर देगार जैतुन कोंडा देगार बेथफगे इंगा बेथानी उरदेगार वच्चीर आप्पुड येशुड वान इद्दार शिष्यलान इल्ला आनी आंपताड की, ");
INSERT INTO wbq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“मुंदार उळ्योंक फोंडा, उळ्योंक फोइनेंका या दान मिंदा यवार कुसना लेद इल्ला गाडदी फिल्ला कट्टीनेद शिक्की. आदी इडशी इंदूक येकादांडा. ");
INSERT INTO wbq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","जर यवाराना मिमलान आडगीर, ‘मीर इदी येनटीक येका फोतूनार?’ तर मीर इल्ला आनांडा, ‘प्रभून की दिंदी गरज उंडाद.’ इंगा वाड आदी लगेच आंपी.” ");
INSERT INTO wbq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","मग वार येल्लीर इंगा वारकी दावा मिंदा, वगा इल्लु दरवाजा देगार वगा गाडदी फिल्ला कट्टीनेद कमशा मग वार दान इडशीर. ");
INSERT INTO wbq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","आंदू नीला फडीने मंदीपैकी काही मंदी वारनी आनीर, “इदी येम शेस्तुनार इ गाडदी फिल्लान येनटीक इडस्तुनार?” ");
INSERT INTO wbq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","शिष्यल उत्तर इच्चीर येशुड वारकी येम शेपीन्या आदी वार शप्पीर. आप्पुड आ मंदी गाडदी फिल्लान एका फोनीचीर. ");
INSERT INTO wbq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","वार आदी गाडदी फिल्ला येशुन तीकुड येकोचीर. वार मना बट्टाल दान मींदा कप्पीर इंगा येशुड दान मिंदा कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","शेंगेम मंदी वारी बट्टाल दावा मिंदा फरशीर इंगा इंगोगोर शेल्लोनी तेम्पीनेय डाळ्याल फरशीर. ");
INSERT INTO wbq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","मुंदारकी नडशेतोर इंगा यंका नडशेतोर घोषणा शेयदूर, “होसान्ना, प्रभून फेरता वचेतोड धन्यवादीत उंडाला. ");
INSERT INTO wbq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","मा पूर्वज दावीद इनदी वचेद राज्य धन्यवादित उंडाला. स्वर्गला होसान्ना.” ");
INSERT INTO wbq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","मग येशुड यरुशलेम शहरकी फोई नेंका वाड परमेश्वर भवनलोंक फोया इंगा आजुबाजूक आंता सुश्या. आ वेळला फददु मुनगीन्या दान कस्रोम वाड वान बारा शिष्यल जताक बेथानिक येल्ली फोया. ");
INSERT INTO wbq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","इंगोगो नाड, येशुड इंगा शिष्यल बेथानीनुस येल्लीनेंका येशुनकी आकाल आय्या. ");
INSERT INTO wbq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","वानकी आकुलाता निंडीनेद वगा माक कमशा. दान मिंदा येमाना शिक्की इ आशाता वाड आंदूक फोया पण वानकी आंदू आकुलान इडशी येमीच शिक्काक फो येनटीक की अंजीरदी सीजन लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","मग वाड दान आन्या, “दिन बाद नि फळलु यवारूच तीनाक फोयार.” वान शिष्यल इदी इनीर. ");
INSERT INTO wbq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","यप्पुड येशुड इंगा वान शिष्यल यरुशलेम शहरकी वच्चीर इंगा येशुड परमेश्वर भवनलोंक फोया आप्पुड भवनला यवार आंमेद इंगा कोंकूनेद व्यवहार शेयदूर वारनी येशुड बैटीक तीदेंक आंट्या. वाड सराफाली चौरंगलु इंगा यवार कबुतर आंमुदूर वारी कुसनेय पाट्याल उलटा मतेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","वाड यवारकीच यादुच वस्तुलाद परमेश्वर भवनलेल वचेद फोयेद शैयानियालेद. ");
INSERT INTO wbq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","मग येशुड नेरपेदेंक आंट्या. वाड वारनी आन्या, “ना इल्लुन आन्नी जातीला कस्रोम प्रार्थना भवन आन्यार, इल्ला पवित्र शास्त्रला राशीनेद लेद येम? पण मीर दान दोंगालदी इल्लु बना मतीणार.” ");
INSERT INTO wbq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","मुख्य याजकलु इंगा नियमशास्त्र शिक्षकलु इदी इनीर इंगा वार वानदी जेम तीस्कुनेद दावा सुदूर येनटीक की आंता मंदी वान शिक्षणता थक्क आयनीर आंका वार वानकी आद्रुदूर. ");
INSERT INTO wbq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","यप्पुड फददु मुनग्या येशुड इंगा वान शिष्यल शहर बैटीक फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","फद्दीना येशुड इंगा वान शिष्यल फोयेताप्पुड आदी अंजीरदी शटटू मुळालनुस येंडीनेद सुशीर. ");
INSERT INTO wbq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पेत्रक ध्यानाम वच्या. वाड येशुन आन्या, “रब्बी, सूड! या अंजीर शटटूक नु श्राप इच्चीनिंटी आदी येंडी फोयानाद.” ");
INSERT INTO wbq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","येशुड उत्तर इच्या, “द्यावार मींदा विश्वास फेटना. ");
INSERT INTO wbq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","नीन मिक खरेम शेपतान की, यवार पण इ कोंडान ‘फिकीगास समुद्रला फोई फड’ इल्ला आनी इंगा मना मनला शक शेय्याक फोई मनाम येल्ला आंटाम आल्ले आय्यी इल्ला विश्वास फेट्टी तर आल्ले आय्यी. ");
INSERT INTO wbq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","दिन कस्रोम नीन मिक शेपतान येम पण मीर प्रार्थनाला आडग्यार आदी शिक्कीनादुच इल्ला विश्वास फेटना आंटे आदी मिक शिक्की. ");
INSERT INTO wbq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","यप्पुड मीर प्रार्थना शेस्का नीला फडतार आप्पुड मी मनला जर येवाराना बद्दल येमाना उंटे तर दानदी क्षमा शेयना. दिन कस्रोम की, मी स्वर्गलोन आब्बाड मी पापलाद क्षमा शेय्याला. ");
INSERT INTO wbq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","पण मीर जर क्षमा शेय्याक फोतीर तर मी स्वर्गलोन आब्बाड पण मी अपराधलाद क्षमा शेय्याक फोई.” ");
INSERT INTO wbq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","येशुड इंगा वान शिष्यल वापस यरूशलेम शहरकी वच्चीर इंगा येशुड परमेश्वर भवनला तीरगेताप्पुड मुख्य याजक मंदी, नियमशास्त्र शिक्षकलु इंगा आब्बागार वान तीकुड वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","इंगा वार वान आडगीर, “नु या अधिकारता इ माटलु शेस्ताव? इ माटलु शेशेद अधिकार निक येवार इच्चीर?” ");
INSERT INTO wbq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","येशुड वारनी आन्या, “नीन पण मिमलान वगा प्रश्न आडगुतान इंगा जर मीर नाक दानदी उत्तर इस्तीर तर नीन इ माटलु या अधिकारता शेस्तान इदी मिक शेप्यान. ");
INSERT INTO wbq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","योहानदी बाप्तिस्मा स्वर्गकनुस उंड्या की मनशीनुस उंड्या? दिंदी उत्तर इयांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","दान बद्दल वार आपसला चर्चा शेशीर इंगा आंदूर जर मनाम आदी स्वर्गनुस आंटीम तर वाड आनी, “मग वान मिंदा मीर विश्वास येनटीक फेट्टाले? ");
INSERT INTO wbq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","जर मनाम आदी मनशी नुस आंटे तर मंदी मना मिंदा कोफाम फड्यार.” वारकी मंदीद येरपू आदू येनटीक की मंदीद विश्वास उंड्या की योहान खरेमे संदेष्टा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","मग वार येशुनकी उत्तर इच्चीर, “माक येरका लेद.” आप्पुड येशुड वारनी आन्या, “मग नीन पण इ माटलु या अधिकारता शेस्तुनान इदी मिक शप्पान.” ");
INSERT INTO wbq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","येशुड वारकी दाखला शेप्पी नेरपेदेंक आंट्या, “वगा मनशी अंगूरलाद बगीचा आंच्या इंगा दानभोवती कुंपण आंच्या. वाड द्राक्षरस कस्रोम गुंताल तव्या इंगा लक्ष फेटदेंक मच्च्या कट्या. वाड आदी शेतकरीक भाडाता इच्ची दुराम प्रवास शेशेदेंक येल्ली फोया. ");
INSERT INTO wbq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","अंगूरलाद फंटा येल्ले वेळला शेतकरी मंदी तीकनुस अंगुरला फळलाद हिस्सा शिक्काला दिन कस्रोम वाड वगा नोकरनी आंप्या. ");
INSERT INTO wbq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पण वार नोकरनी फट्टीर, मत्तीर इंगा उत्ता शेतलाता आंपी. ");
INSERT INTO wbq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","मग वाड इंगोगो नोकरनी आंप्या. वार वानदी नत्ती फगला मत्तीर इंगा वानदी अपमान शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","मग मालकुड इंगा वगा नोकरनी आंप्या.वार वान जेमफडा मतेस काडीर. वाड शेंगेम मंदीन आंप्या. शेतकरी मंदी काही मंदीन मत्तीर तर काही मंदीन जेमफडा मतेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","माल्कुन देगार आंपदेंक इप्पुड फक्त वान कोडकु उंड्या. वाड आन्या, नक्कीच वार ना कोडकुक मान इच्यार. वाड वान प्रिय कोडकु उंड्या आखरीक वाड वान आ शेतकरीला तीकुड आंप्या. ");
INSERT INTO wbq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","मग वार शेतकरील वगा मेगारनी आनीर, इड तर वारीस उंडाड. नंडा, मनाम इन जेमफडा मतेशेद आंटे भुमी मनाद आय्यी! ");
INSERT INTO wbq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","मग वार वान फट्टीर, जेमफडा मतेशीर इंगा अंगूरबगीच्या बैट्या फेकेस काडीर. ");
INSERT INTO wbq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","तर मग अंगूर बगीचा माल्कुड येम शेशी? वाड वच्ची शेतकरी मंदीन मतेशी इंगा अंगुरला बगीच्या इंगोगोरकी इच्ची.” ");
INSERT INTO wbq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“मीर इदी शास्त्रलेख वाचायालेद येम? याद राय कट्टेतोर नाकाराशीर आदी कोनशीला आय्या. ");
INSERT INTO wbq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","इदी परमेश्वर तीकनुस आय्या, इंगा आदी मा नजरला आश्चर्यद फनी उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","धार्मिक पुढारील येशुन अटक शेशेद दावा सुदूर. पण वारकी मंदीद येरपू आदू. वान अटक शेशेद वारदी इच्छा उंड्या येनटीक की वारकी यरका उंड्या की, इदी दाखला वाळड वारनी सुशीने शपन्या. मग वार वान इडशी येल्ली फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","यंकसार यहुदी पुढारील वान चुकीता माटलाडेताप्पुड फट्टाला आंका काही परुशी इंगा काही हेरोदी मंदीन वान देगार आंपीर. ");
INSERT INTO wbq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","वार वान देगार वच्चीर इंगा आनीर, “गुरुजी, नु इमानदार उंडाव इंगा पक्षपात शेय्यांदे नु द्यावारदी खरेम दावा नेरपुताव इदी माक येरका उंडाद तर मग कैसरकी कर इच्चेद शिंगार उंडाद का लेद? इंगा मिम आदी इय्याला की इया राद?” ");
INSERT INTO wbq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","पण येशुड वारदी ढोंगीपना ओळखाश्या इंगा वारनी आन्या, “मीर नाद परीक्षा येनटीक सुस्तार? ना तीकुड वगाट यंडीद कलदार एका दांडा आंटे नीन आदी सुस्तान.” ");
INSERT INTO wbq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","मग वार वान तीकुड वगा कलदार एकोचीर. वाड वारनी आडग्या, “इ कलदार मिंदूडदी चित्र इंगा लेख येवारदी उंडाद?” वार वान आनीर, “कैसरदी.” ");
INSERT INTO wbq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","मग येशुड वारनी आन्या, “याद कैसरदी आदी कैसरकी इंगा याद द्यावारदी आदी द्यावारकी इयांडा.” आप्पुड वार शेंगेम आश्चर्य चकीत आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","मग, याद पुनरुत्थान लेद इल्ला मानाशेतोर सदुकी मंदी वान देगार वच्चीर वार वान आडगीर, ");
INSERT INTO wbq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“गुरुजी, मोशेड मा कस्रोम पवित्रशास्त्रला इल्ला राशीनाड की, जर यादाना मनशी तम्मुड सच्ची फोया इंगा वान वडती नीलच्या, गान दानकी बीळ्ळू लेर तर मना तम्मुनदी वंश मुंदारकी नडवाला आंका आ मनशी दानसंगा फेंडली शेस्कुनाला इंगा सच्चीने तम्मुनदी वंश वाढाय मताला. ");
INSERT INTO wbq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","इल्ला येवारो तरी योड तम्मुळलु उंडीर. फेद्दा तम्मुड वडती शेस्कुन्या इंगा वाड बीळ्ळू कावांदे सच्ची फोया. ");
INSERT INTO wbq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","दुसरा तम्मुड दान संगा फेंडली शेस्कुन्या, वाड पण बीळ्ळू कावांदे सच्ची फोया. ");
INSERT INTO wbq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","तिसरा तम्मुन संगा पण आल्ले आय्या. आ योड तम्मुळाला वगारकी पण आ आंडीदान देगारनुस बीळ्ळू कालेद. आखरीक आदी आंडीद पण सच्ची फोया. ");
INSERT INTO wbq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","योड तम्मुळलु पण दानसंगा फेंडली शेस्कुनीर तर पुनरुत्थान वेळला यप्पुड मंदी सच्चीनेंका लेश्यार आप्पुड आदी येवार वडती उंडी? येनटीक की योड तम्मुळलु पण दानसंगा फेंडली शेस्कुंडीर.” ");
INSERT INTO wbq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","येशुड वारनी आन्या, “शास्त्रलेख इंगा द्यावारदी सामर्थ्य मिक येरका लेद दिन कस्रोम मीर इल्ला चुक शेस्तुनार. ");
INSERT INTO wbq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","येनटीक की यप्पुड मंदी सच्चीनेंका लेश्यार आप्पुड वार फेंडली शेस्कुनाक फोयार इंगा शेशीयाक पण फोयार, गान वार स्वर्गलोन देवदूत लेका उंड्यार. ");
INSERT INTO wbq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","गान सच्चीनोर लोन्केल वापस लेशे बद्दल मीर मोशेन पुस्तकला आग्गी आंटीने झुडपु बद्दल वाचायाले येम? आंदू द्यावार मोशेन आन्या, नीन अब्राहम द्यावार, इसहाक द्यावार इंगा याकोब द्यावार उंडान. ");
INSERT INTO wbq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","वाड सच्चीनोर द्यावार लेड तर जिवंत मंदी द्यावार उंडाड. मीर शेंगेम फेद्दाद चुक शेस्तुनार.” ");
INSERT INTO wbq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","यंकसार वगा नियमशास्त्र शिक्षक वारनी जगडाम आडेताप्पुड इन्या. येशुड वारकी शिंगार उत्तर इच्या आदी सुश्या. आप्पुड वाड आडग्या, “आन्नी आज्ञाल काना महत्वद इल्ला पहिला आज्ञा याद?” ");
INSERT INTO wbq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","येशुड उत्तर इच्या, “पाहिला आज्ञा इदी, ‘हे इस्राएला, इन, प्रभूड मना द्यावार वक्काडे द्यावार उंडाड. ");
INSERT INTO wbq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","नु नि पूर्ण अंतकरणता, पूर्ण जेमता, पूर्ण मनता इंगा पूर्ण शक्तीता नि प्रभू द्यावारमिंदा प्रेम शेय.’ ");
INSERT INTO wbq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","दुसरा आज्ञा इदी उंडाद, ‘येल्ला स्वतः मिंदा आल्ले नि शेजारी मिंदा प्रेम शेय.’ इटलाकाना फेद्दाद यादुच आज्ञा लेद.” ");
INSERT INTO wbq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","आ मनशी उत्तर इच्या, “द्यावार वक्काडे उंडाड, गुरुजी इंगा वान इडशी येवारुच लेर इल्ला नु आंटी आदी खरेम उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","वान मिंदा पूर्ण अंतकरणता, पूर्ण बुद्धीता, पूर्ण शक्तीता इंगा यल्ला स्वता मिंदा आल्ले शेजारी मिंदा प्रेम शेशेद इ आन्नी यज्ञल इंगा अर्पणलु, याय मनाक शेशेद आज्ञा इचीनेद उंडाद, दानकाना जास्त महत्वद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","येशुड सुश्या की, आ मनशी इमानदारीता उत्तर इच्चीनाड. आप्पुड वाड वान आन्या, “नु द्यावार राज्यनुस दुराम लेव.” दिन नंतर वान प्रश्न आडगेद येवारुच हिम्मत शेय्यालेद. ");
INSERT INTO wbq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","येशुड परमेश्वर भवनला नेरपेताप्पुड, वाड आन्या, “ख्रिस्त दावीद कोडकु उंडाड इल्ला नियमशास्त्र शिक्षकलु आंटार आदी येल्ला शक्य उंडाद? ");
INSERT INTO wbq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दावीद स्वता पवित्र आत्माता प्रेरित आय्यी आन्या, ‘प्रभूड द्यावार, ना प्रभून आन्या, नीन नी दुश्मननी नि काळाकिंदा येशीनंताक, नु ना मंची शेय तिकुड कुसुन.’ ");
INSERT INTO wbq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दावीद स्वता ख्रिस्तन ‘प्रभू’ आंटाड तर मग ख्रिस्त दावीद कोडकु येल्ला?” इंगा मंदिद समुदाय वानदी आनंदता इनदूर. ");
INSERT INTO wbq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","नेरपेताप्पुड वाड आन्या, “नियमशास्त्र शिक्षकला विषयला सावधान उंडांडा. वारकी फेद्दा-फेद्दा झगाल येस्केन मिर्वादेंक इंगा संताला दंडाम तीस्कुनदेंक आवडास्ताद. ");
INSERT INTO wbq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","सभास्थानलोन इंगा पंगतलोन आंदारकाना मंची जागाद वारकी आवड उंटाद. ");
INSERT INTO wbq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","वार विधवाली इंडलु तीनेस्तार इंगा मंदीक सुपिदेंक वार फेद्दा-फेद्दा प्रार्थनाल शेस्तार. इ मंदीक शेंगेम कडक शिक्षा आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","येशुड द्यावार भवनला दानपेटी मुंदार कुसनी मंदी पेटीला दुडलु येयदुर इदी सूदू इंगा शेंगेम धनवान मंदी शेंगेम दुडलु येयदुर. ");
INSERT INTO wbq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","मग वगा गरीब विधवाद वच्या इंगा आदी रोंड राग्याय कलदारलु आंटे वगा दमडी येश्या. ");
INSERT INTO wbq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","येशुड मना शिष्यलनी कुतेश्या इंगा आन्या, “नीन मिक खरेम शेपतान की, आंदार येवार आ पेटीला दान येशीर वार आंदारकाना इ विधवाद जास्त येशिनाद. ");
INSERT INTO wbq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","नीन इल्ला आंटान येनटीक की वार देगार याद शेंगेम उंड्या दांटल्योन्केल वार काहीक दान इच्चीर, गान आदी गरीब उंडी पण दान देगार येम उंड्या आदी आंताच इचकाड्या. आदी आंताच दानदी जीवन जगाशेद सहारा उंड्या.” ");
INSERT INTO wbq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","मग येशुड परमेश्वर भवननुस येल्लेताप्पुड वान शिष्यलपैकी वगाड आन्या, “गुरुजी, सूड, इ येल्ला अद्भुत राळ इंगा फेद्दा भवन उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","येशुड वान आन्या “नु फेद्दाद भवन सुस्तुनाव? आन्दु वगा राय इंगोगो राय मिंदा निल्वाक फोई. दांटल्योन्केल प्रत्येक राय किंदा फडी फोई.” ");
INSERT INTO wbq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","येशु परमेश्वर भवनमुंदार जैतुन टेकड्या मिंदा कुस्नीन्या. पेत्र, याकोब, योहान इंगा अंद्रिया इर वान एकांतला आडगीर, ");
INSERT INTO wbq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“इ माटलु यप्पुड घडाशी इदी माक शेप इंगा इ माटलु पूर्ण आय्येद वेळ वच्ची आप्पुड याद चिन्ह घडाशी?” ");
INSERT INTO wbq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","मग येशुड वारकी शेप्या, “मिमलान यवार फसाय मताराद आंका सावध उंडांडा. ");
INSERT INTO wbq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","शेंगेम मंदी ना फेरता वच्यार इंगा आन्यार की, ‘नीन ख्रिस्त उंडान’ इंगा वार मंदीन फसाय मत्यार. ");
INSERT INTO wbq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","यप्पुड मीर लढाईला बद्दल इंगा लढाईला अफवालबद्दल इन्यार आप्पुड आद्राकुंडा. इदी नक्की आय्यीच. पण दिनता शेवट काक फोई. ");
INSERT INTO wbq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","वगा राष्ट्र इंगोगो राष्ट्रमिंदा लेशी, वगा राज्य दुसरा राज्यमिंदा लेशी, जागा-जागा मिंदा भूकंप आय्यी इंगा दुष्काळ फडी. पण इ माटलू आंटे नाशदी सुरवात उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“मीर सावध उंडांडा. वार मिमलान न्यायसभाला इच काड्यार इंगा सभास्थानला मिमलान मत्यार. वारकी साक्ष कावाला दिन कस्रोम मिक राज्यपाल इंगा राजाल नीला फडा बेक आय्यी. ");
INSERT INTO wbq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","इ माटलु घडाशेकाना मुंची आन्नी जातीलाक सुवार्ताद घोषणा कावाने बेक. ");
INSERT INTO wbq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","यप्पुड वार मिमलान अटक शेशी चौकशी इचांग येकोच्यार आप्पुड पहिलाने मीर येम माटलाडेद दिंदी काळजी शैयाकुंडा, येनटीक की आप्पुडे सुचाय मतदेंक वच्ची आदी माटलाडांडा, येनटीक की माटलाडेतोर मीर लेर तर पवित्र आत्मा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","तम्मुड तम्मुन इंगा आब्बाड स्वता कोडकुने मतेशेदेंक विश्वासघात शेशी फटीच्यार, बीळलु आम्मा आब्बान मिंदा लेश्यार इंगा वार वारनी मत्तेश्यार. ");
INSERT INTO wbq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","इंगा ना फेरता आंता मंदी मी मिंदा कोफाम शेशार, पण येवार आखरी नंताक टीकाशार वारदी तारण आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“यप्पुड मीर नाशकी कारण इल्ला भयंकर माटा, दानिएल संदेष्टा शेप्पीनेद ‘उजाड शेशेद अमंगळ पदार्थ’ याद यंदू बेकालेद आंदू सुश्यार. (वाचाशेतोर दिंदि अर्थ येम इदी समजाशी तीस्कुनाला) आप्पुड यवार यहुदिया प्रांतला उंडार वार कोंडा तीकुड फारी फोव्वाला. ");
INSERT INTO wbq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","या मनशी मना इल्लु माडीमिंदा उंडी वाड इंटल्योनुस येमाना येकोदेंक किंदीक दिगाराद. ");
INSERT INTO wbq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","इंगा जर यादाना मनशी शेल्ला उंटे तर वाड मना झगा येकोदेंक यंकाक इल्लुक फोवाराद. ");
INSERT INTO wbq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","आ दिनमुलाला या आंड्योर रंजलमंशी इंगा बीळ्ळाक फाल तापेतोर उंड्यार वार कस्रोम इदी यंता भयानक उंडी. ");
INSERT INTO wbq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","इदी सलीकालाम कावाराद आंका प्रार्थना शेयना. ");
INSERT INTO wbq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","येनटीक की आ दिनमुलाला याद त्रास आय्यी आदी द्यावार दुन्याम निर्माण शेशीननुस इबद नंताक काले कुंड्याला इंगा यप्पुडूच काक पन फोई. ");
INSERT INTO wbq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","परमेश्वर जर आदी दिनमु कमी शेय्या लेकुंटे तर येवारुच बतका कुनीर. गान येवारनी वाड निवडाशीनाड इल्ला निवडासने मनशी कस्रोम आदी दिनमु वाळड कमी शेशीनाड. ");
INSERT INTO wbq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","इंगा येवाराना मिमलान आनीर की ‘सुडांडा, ख्रिस्त इंदू उंडाड लेकाते आंदू उंडाड,’ तर वानमिंदा विश्वास फेट्टाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","येनटीक की खोटा ख्रिस्त इंगा खोटा संदेष्ट्याल नीला फड्यार इंगा शक्य आयते तर वार निवडासने मंदीन फसाय मतदेंक चिन्हल इंगा आश्चर्यय फनुल शेश्यार. ");
INSERT INTO wbq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","सुडांडा, आप्पुड मीर सावध उंडांडा. नीन वेळ कावाकाना मुंची मिक आंता शेप्पी फेटनान.” ");
INSERT INTO wbq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","गान आ दिनमुलाला इ संकटलु वच्ची फोईनेंका, 'सूर्य अंधकारमय आय्यी, चंद्र प्रकाश इयाक फोई.' ");
INSERT INTO wbq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","'मोडाम नुस सुक्काल फडी इंगा मोडामलोनदी शक्ती हालाशी फोई.' ");
INSERT INTO wbq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","इंगा मंदी मनशी कोडकुन ढगला मिंदा कुसनी फेद्दा सामर्थ्यता इंगा वैभवता वच्चेताप्पुड सुश्यार. ");
INSERT INTO wbq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","मग वाड वान देवदूतलान आंपी इंगा नालुंग दिशाल नुस, पृथ्वी सीमाल नुस वार मोडाम सीमाल नंताक वान निवडासने मंदीन जमा शेश्यार. ");
INSERT INTO wbq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“अंजीर माक तिकनुस नेरुना. यप्पुड दानी डांकुल कवळांग आताय दानकी आकुल फुटताय आप्पुड येंडाकालाम देगार वच्या इदी मिक तेलस्ताद. ");
INSERT INTO wbq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","आल्ले मीर यप्पुड इ माटलु आय्येताप्पुड सुश्यार आप्पुड मिक तेलची की, आदी वेळ कवाड देगार वच्ची टेकाशिनाद. ");
INSERT INTO wbq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","नीन मिक खरेम शपतान की, इ आन्नी माटलु आय्यी नंताक इ पिढीद शेवट काक फोई. ");
INSERT INTO wbq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","मोडाम इंगा पृथ्वीद शेवट आयफोई पण ना माटलाद अंत काक फोई.” ");
INSERT INTO wbq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“आ दिनमु बद्दल लेकाते आ वेळ बद्दल येवारकीच येरका लेद, स्वर्ग देवदुतलाक पण लेद इंगा कोडकुक पण लेद. फक्त आब्बानकी येरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","सावध उंडांडा, प्रार्थनाला सावध उंडांडा येनटीक की आदी वेळ यप्पुड वच्ची इदी मिक येरका लेद. ");
INSERT INTO wbq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","आदी वेळ इल्ला उंडाद की, वगा मनशी प्रवासकी फोयेताप्पुड इल्लु इडस्ताड इंगा वान प्रत्येक नोकरकी फनी नेमाशी इस्ताड. वाड लक्ष फेटेतोरकी जागरण शेशेद आज्ञा इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","दिन कस्रोम मीर लेशी उंडांडा, येनटीक की इल्लु मालकुड यप्पुड वच्ची इदी मिक येरका लेद. वाड फददु मुनगेताप्पुड, निम्मा मोबुल्ला, फद्दीना कोडी आरवाकाना मुंची लेकाते फद्दीना यप्पुड वच्ची इदी मिक येरका लेद. ");
INSERT INTO wbq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","जर वाड अचानक वच्या तर मीमलान निद्दारला उंडेताप्पुड सुडाराद. ");
INSERT INTO wbq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","येम मिक शेपतान, आदी आंदारकी शेपतान, जागृत उंडांडा.” ");
INSERT INTO wbq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","वल्हांडण इंगा बेखमीर रोट्या फंडगा काना रोंड नाळा मुंची मुख्य याजक मंदी इंगा नियमशास्त्र शिक्षकलु वान जेमफडा मतेद दावा फुडकुदूर. ");
INSERT INTO wbq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","येनटीक की वार आंदूर “मनाम इदी फंडगाला शेयाराद लेकाते मंदी दंगा शेश्यार.” ");
INSERT INTO wbq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","येशुड बेथानी इंदू शिमोन कृष्ठरोगी इन इल्काडा मेज मिंदा तीनदेंक कुसनीन्या आप्पुड यादो वगा आंडीद स्पाइकनार्ड वनस्पतीनुस बनाशीने शुद्ध सुगंधी अत्तरदी शेंगेम किंमती अलबास्त्र कुप्पी एका वच्या. आदी अलबास्त्र कुप्पी तेंप्या इंगा सुगंधी अत्तर येशुन नत्तीमिंदा येश्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","आंदू उंडीने मंदी कोफाम फडीर, वार वगा मेगारनी आनीर, “सुगंधी अत्तरदी इल्ला नाश शेशेद शिंगार लेद. ");
INSERT INTO wbq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","येनटीक की इदी सुगंधित अत्तर तीनशे बंगार कलदार पेक्षा जास्त किंमतला आंमा वस्तुन्या इंगा आय दुडलु गरीबोरकी इया वस्तुन्या.” इल्ला आनी वारदान उलटा कुरकुर शेयदुर. ");
INSERT INTO wbq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","पण येशुड आन्या, “दान वगादान इडना. दानकी येनटीक त्रास इस्तार? आदी ना कस्रोम वगाट शिंगार फनी शेशिनाद. ");
INSERT INTO wbq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरीबोर तर नेहमी उंटार इंगा मिक वाटाशी आप्पुड मीर वारकी मदत शेशी शेकास्तार. पण नीन नेहमी मी संगा उंड्यान इल्ला लेद. ");
INSERT INTO wbq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","दानकी येम शक्य उंड्या आदी शेश्या. आदी अंतिम संस्कार तैयारी काना मुंची ना फयमींदा सुगंधी अत्तर येश्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","नीन मिक खरेम शेपतान, आन्नी दुन्यामला यंदू पण सुवार्ताद घोषणा शेश्यार आंदू दानदी ध्यानाम आंका आदी येम शेश्या आदी नेहमी शेपकामला वच्ची.” ");
INSERT INTO wbq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","मग बारा शिष्यल नुस वगाड, यहुदा इस्कर्योत येशुन विश्वासघातता फट्टी इद्देंक मुख्य याजक तीकुड फोया. ");
INSERT INTO wbq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","यप्पुड याजकलु इदी इनीर वारकी शेंगेम आनंद आय्या इंगा वार वानकी दुडलु इच्चेद वचन इच्चीर. मग यहुदाड येशुन फट्टी वार शेतल्या इच्चेद दावा सुदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","बेखमीर रोट्या फंडगा पहिला दिनमु यप्पुड वल्हांडण फंडगाक गोर्याद बली इददुर आप्पुड येशुन शिष्यल वान आनीर, “मिम यंदूक फोई नी कस्रोम वल्हांडण फंडगा वंटाद तैयारी शेय्याला इल्ला नीद इच्छा उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","येशुड वान इद्दार शिष्यलनी आंप्या इंगा वारकी शेप्या, “शहरलोंक फोंडा इंगा नेळाद बतकु येका फोयेतोड मनशी मिक भेटाशी, वान यंका फोना. ");
INSERT INTO wbq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","इंगा यंदूक वाड नोनिक फोई आ इल्लु मालकुन की शेपना, ‘गुरुजी आंटाड, यंदू नाक ना शिष्यल संगा वल्हांडण फंडगाद वंटा तीनेद शक्य आय्यी इल्ला खोली यंदू उंडाद?’ ");
INSERT INTO wbq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","इंगा वाड मिक माडी मींदुडदी खोली सुपीच्ची, आंदू मना कस्रोम तैयारी शेयना.” ");
INSERT INTO wbq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","शिष्यल येलीर इंगा वार शहरलोंक फोईर इंगा येशुड शेप्पीन गता वारकी आल्ले कमशा. मग वार वल्हांडण फंडगा वंटाद तैयारी शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","माप आय्या आप्पुड येशुड बारा शिष्यल संगा वच्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","मेज मिंदा कुसनी वार तीनेताप्पुड येशुड आन्या, “नीन मिक खरेम शेपतान, मीपैकी येवाड वगाड नन्नु शत्रूला शेतल्या इच्ची, वाड ना संगा इंदू तिनटूनाड.” ");
INSERT INTO wbq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","शिष्यल शेंगेम खिन्न आय्यीर इंगा आंदार वान आडगेदेंक आंटीर, “वाड नीन उंडान येम?” ");
INSERT INTO wbq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","वाड वारनी आन्या, “बारा मंदी पैकी वगाड येवाड नासंगा तल्याला रोट्या आददु तुनाड वाडे उंडाड. ");
INSERT INTO wbq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","वान बद्दल पवित्र शास्त्रला यल्ला राशी उंडाद, आल्ले मनशी कोडकुन फट्टी इच्यार गान येवान शेयता मनशी कोडकुन फट्टी इच्यार, वानी यंता येल्याल आय्यी. वाड फुट्टा लेकुंटे तर आदी वान कस्रोम शिंगार उंटून्या.” ");
INSERT INTO wbq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","वार रोट्या तिनेताप्पुड येशुड रोट्या तीस्कोन्या, उपकार स्तुती शेश्या आदी इरगामत्या इंगा वारकी इच्या. वाड आन्या, “तीस्कोंडा, इदी नाद शरीर उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","मग येशुड प्याला तीस्कोन्या, उपकारस्तुती शेश्या. आदी प्याला वारकी इच्या इंगा आंदार दांटल्योन्केल तागीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","मग येशुड आन्या, “इदी नाद कोत्ता करारदी नेत्तुर उंडाद. शेंगेम मंदी कस्रोम आदी इस्तुनार. ");
INSERT INTO wbq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","नीन मिक खरेम शेपतान की, द्यावार राज्यला नीन कोत्ताद द्राक्षरस ताग्यान आड नंताक नीन दिन मुंदारकी अंगुरदी उपज तागाक फोयान.” ");
INSERT INTO wbq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","मग वार उपकारस्तुती फदुल फाडीर इंगा जैतुन कोंडा तीकुड येल्ली फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","येशुड शिष्यलनी आन्या, “मीर आंदार अटकाशी फड्यार येनटीक की पवित्र शास्त्रला इल्ला राशी उंडाद की, ‘नीन मेंढपाळनी मत्यान इंगा मेंढऱ्यालदी दाणादाण आय्यी’”. ");
INSERT INTO wbq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“पण नाद पुनरुथान आयनेंका नीन मी मुंदारकी गालील प्रांतकी फोयान.” ");
INSERT INTO wbq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पेत्र आन्या, जरी आंदार अटकाशीर तरी नीन अटकायाक फोय्यान. ");
INSERT INTO wbq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","मग येशुड वान आन्या, “नि निक खरेम शेपतान की इबद मोब्बुला रोंड तुकुल कोडी आरवाकाना मुंची नु मूड तुकुल नाद नकार शेश्याव.” ");
INSERT INTO wbq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","तरीपण पेत्रड जोर इच्ची आन्या की, “जर नाक निसंगा सच्चेदबी फनी फड्या तरीपण निन नीद नकार शेयाक फोयान.” इंगा आंदार इल्ले आनीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","मग वार गेथशेमनी फेर जागामिंदिक वच्चीर, आप्पुड येशुड वान शिष्यलनी आन्या, “निन प्रार्थना शेशी नंताक इंदू कुसुंडा.” ");
INSERT INTO wbq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","येशुड वान संगा पेत्र, याकोब इंगा योहान इरनी तीस्कुन्या. दु:खता इंगा पिडाता वारदी मन निंडी फोइन्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","वाड वारनी आन्या, “ना जेम सय्याकाना जास्त पिडा सहन सेस्तुनाद. इंदू उंडा इंगा जागरण शेसका उंडा.” ");
INSERT INTO wbq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","वार देगारनुस रव्वासा दुराम फोय्यी वाड भुमीमिंदा फड्या इंगा वाड प्रार्थना शेश्या की, “शक्य उंटे तर इदी घटना ना देगारनुस येल्ली फोवाला.” ");
INSERT INTO wbq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","वाड आन्या, “हे अब्बा-यब्बा, निक आंता शक्य उंडाद. इदी प्याला ना देगारनुस दुराम शेय तरी नाद इच्छा काद तर निद इच्छा पूर्ण कावाला.” ");
INSERT INTO wbq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","आप्पुड येशुड वच्या इंगा वानकी आंदार फंडकेन कमशीर. वाड पेत्रन आन्या की, “शिमोन, नु फंडकुनीन्टी येम? वगा घंटा नु मेल्का नीलची शेकायाव येम? ");
INSERT INTO wbq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जागरण शेसका उंडा इंगा प्रार्थना शेयांडा आंटे मीर परीक्षाला फडाक फोयार. आत्मा उत्सुक उंडाद पण फय कमजोर उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","इंगा येशुड दुराम फोया इंगा आय्ये माटलु आनिगास वाड प्रार्थना शेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","मग वाड वापस वच्या इंगा आंदू वार फंडकेन कमशीर येनटीक की वारी कंडलु भोरू आय्यी फोइन्या इंगा वानकी येम उत्तर इच्चेद इदी वारकी तेलवाकुंदू. ");
INSERT INTO wbq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","वाड इंगा तिसरा तुक वच्या इंगा वारनी आन्या, “मीर इंगाना फंडकुन्नार इंगा आराम शेस्तूणार येम? पूर्ण आय्या! इप्पुड वेळ वच्चीनाद. मनशी बिडान पापीमंदी शेतल्या फट्टी इस्तुनार. ");
INSERT INTO wbq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","लेयांडा, मनाम यल्ली फोदाम. सुडांडा, नन्नु फट्टी इच्चेतोड मनशी इक्काड वस्तुनाड.” ");
INSERT INTO wbq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","यप्पुड येशुड माटलाडदु आप्पुड बारा मंदीपैकी वगाड यहुदाड आंदूक वच्या. वान संगा मुख्य याजक मंदी इंगा नियमशास्त्र शिक्षकलु इंगा आब्बागार आंपीने आंदार मंदी तलवारलु इंगा कोलाकटलु येकोचीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","विश्वासघात शेशेतोड वारकी इल्ला निशाणी इच्चीन्या की, “नि येवारदी मुत्ता तीस्कून्यान, वान फटकेन संभाळीची येका फोंडा.” ");
INSERT INTO wbq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","मग यहूदाड वच्ची वाड येशुन देगार फोया इंगा आन्या, “रब्बी!” इंगा इल्ला आनी यहुदाड येशुनदी मुत्ता तीस्कुन्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","मग वार वानमिंदा शेय येशीर इंगा वान अटक शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","आंदू देगार नीला फडीनोरपैकी वगाड तलवार तिश्या इंगा महायाजक नोकर मिंदा वार शेशी वानदी गुम्मा कोशेश्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","मग येशुड वारनी आन्या, “नन्नु डाकू समजाशी तलवारलु इंगा कोलाकटलु तीस्केन नन्नु फटदेंक वच्चीनार येम? ");
INSERT INTO wbq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","नीन धीन्नाम द्यावार भवनला मी मुंदार नेरपेताप्पुड मी संगा उंटीन आप्पुड मीर नन्नु फट्टालेद. गान इदी आय्या दिन कस्रोम की पवित्र शास्त्रला राशीनेद पूर्ण कावाला.” ");
INSERT INTO wbq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","आंदार शिष्यल वान इडशी फारी फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","वगा जवान मनशी फई मिंदा चादर कपकेन वान यंका नडदू. वान मंदी फट्टीर, ");
INSERT INTO wbq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","गान वाड चादर येशी बेत्तालगाने फारी फोय्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","मग वार येशुन आंदनुस महायाजक तीकुड एका फोईर इंगा मुख्य याजक मंदी, आब्बागार इंगा नियमशास्त्र शिक्षकलु जमा आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","रव्वा अंतर फेट्टी पेत्र येशुन यंका महायाजक इल्लुक फोया. आंदू पेत्र रक्षा शेशेतोर संगा आग्गी कास्का कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","मुख्य याजक मंदी इंगा आंता यहुदी सभा येशुन मत्तेशेद पूर्ण प्रयत्न शेयदूर. पण वारकी येमी शिक्का कुंदु. ");
INSERT INTO wbq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","शेंगेम मंदी वान उलटा खोटा साक्ष इच्चीर. गान वारदी साक्ष सारखा लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","मग काही मंदी नीला फडीर इंगा वान उलटा साक्ष इच्ची आनीर, मिम वान इल्ला आनेताप्पुड इंटीम की, ");
INSERT INTO wbq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“शेयता कट्टीने परमेश्वरदी भवन नीन केडपेश्यान इंगा याद शेयता कट्टालेद इल्ला इंगोगो भवन मुड नाळाला कट्ट्यान.” ");
INSERT INTO wbq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","गान तरीपण इ माटाला वार साक्षला मेळ लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","मग महायाजक वान मुंदार नीला फड्या इंगा वाड येशुन आडग्या, “नु उत्तर इयाव येम? इ मंदी नी उलटा साक्ष इस्तुनार इदी येल्ला येम?” ");
INSERT INTO wbq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","गान येशुड तेप्पांग नीलच्या. वाड उत्तर इयाक फो. मग महायाजक इंगा आडग्या, “परम धन्य परमेश्वर उंडीने कोडकु वाड नुये उंडाव येम?” ");
INSERT INTO wbq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","येशुड आन्या, “नीन उंडान, इंगा मीर मनशी कोडकुन सर्वसमर्थ द्यावार मंची शेय तीकुड कुशीन्नोड इंगा मोडामलोन ढगला संगा वच्चेताप्पुड सुश्यार.” ");
INSERT INTO wbq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","महायाजक स्वताय बट्टाल शिंप्या इंगा आन्या, “मनाक इंगा साक्षीदारलाद येम गरज उंडाद? ");
INSERT INTO wbq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","मीर इदी निंदा इंटीर. मिक येम वाटास्ताद?” आंदार वानकी सच्चेद शिक्षा योग्य उंडाड इल्ला आनीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","काही मंदी वान मिंदा उमशेदेंक आंटीर. वानदी मुती मुशी वान गुद्देदेंक आंटीर इंगा वान आनेदेंक आंटीर, “ओळखाय बर, नीन्नु येवार मत्तीर?” रक्षा शेशेतोर सैनीकलु वान ताबाला तीस्केन वान मत्तीर. ");
INSERT INTO wbq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","पेत्रड आंगळामला उंडीनाप्पुड महायाजक दासीलापैकी वगात आंदूक वच्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","इंगा आदी पेत्रन कास्कुने ताप्पुड सुश्या. आप्पुड आदी वान तीकुड टकटक सुश्या इंगा आन्या, “नु पण नासरथोन संगा उंटी गरा?” ");
INSERT INTO wbq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","पण पेत्र लेद आनी आन्या, “नु येम आंटाव आदी नाक तेलवाद.” पेत्र आंगळाम दरवजामिंदीक फोय्या इंगा कोडी कीरल्या. ");
INSERT INTO wbq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","यप्पुड दासीद वान सुश्या आप्पुड येव्वार मंदी आंदू उंडीर वारनी आदी आनदु की, “इ मनशी वार दिंटल्योन्टोडे वगाड उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पेत्र वापस लेद आन्या इंगा आन्या. मग काही वेळ आय्यीनेंका आंदू नीला फडीने मंदी पेत्रन आनीर, “नक्कीच नु वार दिंटल्योन्टोडे वगाड उंडाव, येनटीक की नु पण गालीली उंडाव.” ");
INSERT INTO wbq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","पेत्र श्राप इच्केन इंगा वटू येस्केन आन्या, “मीर या मनशी बद्दल माटलाडतुनार वान नीन ओळखायान!” ");
INSERT INTO wbq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","इंगा लगेच इंगोगो तुक कोडी कीरल्या, “रोंड तुकुल कोडी आरवाकाना मुंची नु नन्नु नकार शेश्याव,” इल्ला येशुड आनिन्ड्या दिंदी पेत्रक ध्यानाम वच्या इंगा वाड शेंगेम दुखी आय्या इंगा शेंगेम बेग्गे येडशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","फदू फुट्टीन नग्रेम मुख्य याजक मंदी, आब्बागार, नियमशास्त्र शिक्षकलु इंगा आंता महासभालोन मंदी वगार मेगारनी माटलाडी येशुन कट्टी पिलात शेतल्या इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलात वान आडग्या, नु यहुद्योर राजा उंडाव येम? येशुड उत्तर इच्या, “नु आंटाव आल्ले.” ");
INSERT INTO wbq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","मुख्य याजकलु शेंगेम माटलाला येशुन मिंदा आरोप आंचीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","मग पिलात वान इंगा प्रश्न आडग्या, नु उत्तर इयाव येम? सूड, येन्नी दोषलाद नि मिंदा आरोप आंचतुनार! ");
INSERT INTO wbq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","पण तरी येशुड उत्तर इया लेद तर पिलातूस की आश्चर्य वाटाश्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","वल्हांडण फंडगा आप्पुड वार वगा कैदीन इडवाला आंका आंदूर. वान पिलात रिती रिवाज लेका मंदी कस्रोम इड्सकाडदू. ");
INSERT INTO wbq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","बरब्बा फेरोड वगा मनशी, दंगलखोरला संगा जेलला उंड्या. वाड दंगलला खून शेशीन्या आंका वान फटीनीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","मंदी वच्चीर इंगा पिलातनी वाड नेहमी वार कस्रोम शेयदु आल्ले शेयदेंग आंचीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलात आडग्या, मी कस्रोम यहुद्याल राज्यान इडवाला इल्ला मिद इच्छा उंडाद येम? ");
INSERT INTO wbq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","पिलात इल्ला आन्या येनटीक की वानकी येरका उंड्या की, जलन कस्रोम मुख्य याजकलु वान फट्टी इच्चीनीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पण पिलात वान बद्दल बरब्बान इडवाला इल्ला मुख्य याजकलु मंदीक शेप्पीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","पण पिलात वारनी इंगा आन्या, तर मग येवान मीर यहुद्याल राजा आंटार वानदी नीन येम शेयदून इल्ला मिद इच्छा उंडाद? ");
INSERT INTO wbq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","वार इंगा बेग्गे कीरली आनीर, वान क्रूसमिंदा खिळाय! ");
INSERT INTO wbq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलात वापस आडग्या, येनटीक? वाड येम गुन्हा शेशीनाड? वार आंदार इंगा बेग्गे कीरलीर, वान क्रूस मिंदा खिळाय! ");
INSERT INTO wbq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","पिलातकी मंदीन खुश शेशेद उंड्या दान कस्रोम वाड बरब्बान इडश्या इंगा येशुन देब्बाल मत्ती क्रूस मिंदा खिळायदेंक शिपाईलाक इचकाड्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","शिपाईल येशुन राज्यपाल इल्लुक, (प्रिटोरियम आंटे कोर्टला) एका फोईर इंगा वार सैनिकलाद वगाट गट कुतेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","वार वान फयमिंदा जांभळा झगा येशीर इंगा मुंडलाद मुकुट शेशी वानकी फेट्टीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","वार वानकी दंडाम शेयदूर इंगा आंदुर, यहुद्योर राजानदी जयजयकार शेयना. ");
INSERT INTO wbq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","वार गेंटला कट्याता जामुजामुक वान नत्तीमिंदा मत्तीर. वानमिंदा उमशीर इंगा किंदा कुसनी वान मोक्कीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","वार वानदी मजाक येगरा मत्तीनेंका वान फय मिंदूडदी जांभळा झगा तीस्कुनीर इंगा वानी स्वताय बट्टाल वानकी येशीचीर. यंकसार क्रूसमिंदा खिळायाला आंका वार वान बैटीक येका फोईर. ");
INSERT INTO wbq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","दावाला वारकी कुरेनेकर शिमोन फेरोड वगा मनशी कमशा. वाड आलेक्सांद्र इंगा रुफ इर आब्बाड उंड्या वाड वान शेननुस इल्लुक वापस फोयतुन्या. मग सैनिकलु वान जबरदस्ती येशुनदी क्रूस येतेदेंक आंचीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","इंगा वार येशुन गुलगुथा आंटे कवटी जागा मिंदीक येकोचीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","वार वानकी बोळ मिसळासनेद अंगूरदी रस इच्चीर पण वाड आदी तीस्कुनालेद. ");
INSERT INTO wbq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","वार वान क्रूसमिंदा खिळाशीर, येवार याय बटाल तीस्कुनाला दिन कस्रोम वार चिट्ठील येशीर इंगा वानी बट्टाल फंचकुनीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","वार वान क्रूसमिंदा खिळाशीर आप्पुड फद्दीनी नऊ वागीन्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","इंगा वान फइना दोष आरोपदी लेख, “यहुद्याल राजा” इल्ला राशिनेद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","वार वान संगा इद्दार दोंगालनी वगान वान मंची शेय तीकनुस इंगा इंगोगोन वान रोड्डा शेय तीकनुस क्रूसमिंदा खिळाशिनीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","देगारनुस फोयेतोर मंदी वानदी निंदा शेयदुर. वार मना नत्ती हालायमती आनीर, अरे! परमेश्वरदी मंदिर केडपी आदी मुड नाळाला कट्टेतोड वाड नुये उंडाव गरा! ");
INSERT INTO wbq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","क्रूसमिंदनुस किंदीक दा इंगा स्वतान वाचाय मत. ");
INSERT INTO wbq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","आल्ले मुख्य याजकलु, नियमशास्त्र शिक्षकलु येशुनदी थट्टा शेशीर इंगा वगामेगारनी आनीर, वाड इंगोगोरदी तारण शेश्या पण वानकी स्वतान वाचाय मत्ता दाद! ");
INSERT INTO wbq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इ इस्त्राएल राजान ख्रिस्तन क्रूसमिंदनुस किंदीक दानिंडा मग मिम सुश्याम इंगा वानमिंदा विश्वास फेट्ट्याम इंगा येवार वानसंगा क्रूसमिंदा उंडीर वार पण वानदी अपमान शेशीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","मध्यानदी वेळ आय्या. आंता देशला मोब्बू फड्या, आदी मोब्बू मुड वागी नंताक नीलच्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","मग मूड वागता येशुड बेग्गे कीरली आन्या, “एली, एली, लमा सबकथनी, आंटे, ना द्यावारा, ना द्यावारा नु नाद त्याग येनटीक शेस्ती?” ");
INSERT INTO wbq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","देगार नीला फडीने काही मंदी इदी इनीर आप्पुड वार आनीर, इनांडा, वाड एलीयान कुतेस्तुनाड. ");
INSERT INTO wbq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","वगाड फारका वच्ची स्पंज विनेगरला आद्दी गेंटला कोलामिंदा फेट्टी येशुनकी तागदेंक इच्या इंगा आन्या, थांबायंडा! एलीयाड वच्ची वान किंदीक दिंपताड का लेद इदी मनाम सूदाम. ");
INSERT INTO wbq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","मग बेग्गे कीरली येशुड जेम इडश्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","आप्पुड परमेश्वर भवन लोंदी परदा मिंदनुस किंदुड नंताक शिंगी फो इंगा दानी रोंड भागलु आय्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","येशुन मुंदार नीला फडीने अधिकारी यप्पुड वानदी आवाज इन्या इंगा वाड यल्ला सच्या इदी सुश्या आप्पुड वाड आन्या, खरेमे इ मनशी द्यावार कोडकु उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","आंदू उंडीने काही आंड्योर दुरामनुस सूदूर. वार नडमा मग्दालिया नगरदी मरियाद, याकोब इंगा योसेफ आम्मा मारियाद इंगा सलोमीद इर उंडीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","येशुड यप्पुड गालील प्रांतला उंड्या आप्पुड इर आंड्योर वान यंका फोदूर इंगा वानदी सेवा शेयदुर. इर इडशी यरुशलेम शहरनुस वच्चीने शेंगेम आंड्योर उंडीर. ");
INSERT INTO wbq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","आ वेळला माप आयन्या इंगा आदी तैयारीद आंटे शब्बाथ पहिला नाड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","योसेफ अरिमथाईकर न्यायसभावोड माननीय सभासद उंड्या इंगा वाड पण द्यावारदी राज्य वच्चेद दावा सूदू. वाड योसेफ हिम्मत शेशी पिलात तीकुड फोय्या इंगा वाड येशुनदी फिनग्या आडग्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","येशूळड इंता लग्गान येल्ला सच्या दिंदी पिलातकी आश्चर्य वाटाश्या. मग वाड सेना अधीकारीन कुतेशी आडग्या. येशुनकी सच्ची शेंगेम शप आयनाद येम? ");
INSERT INTO wbq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","सेनाधिकारी तीकनुस तेल्ची नेंका, आप्पुड वाड आदी फिनग्या योसेफकी इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","मग योसेफ तागुय बट्टाल कोंका वच्या इंगा येशुन क्रूसमिंदनुस तीशीर इंगा वान ताग बट्टाला गुंडाळीची आदी खडकुला तव्वीने कब्रला फेट्ट्या. मग वाड कब्र मुती मिंदा राय फेट्या. ");
INSERT INTO wbq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","येशुन यंदू फेटीर इदी मग्दालीया नगरलोन मरियाद इंगा योसेफ इन आम्मा मरियाद इर सुदुर. ");
INSERT INTO wbq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","शब्बाथदी दिनमु संपाश्या आप्पुड मग्दलीयाद मरिया, याकोब आम्मा मरीयाद इंगा सलोमीद इर वानकी तीकदेंक सुगंधित नुन्या कोंका वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","इंगा हप्ता पहिला दिन्मु, एकदम नस्कुला फदु फुट्टेताप्पुड आय कब्र तीकुड फोय्या. ");
INSERT INTO wbq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","वार वगा मेगारनी आंदूर की, कब्र मुती मिंदनुस मना कस्रोम राय यवार बाजूक तीश्यार? ");
INSERT INTO wbq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","मग वार फइक सुशीर इंगा वारकी राय दोब्बीनेद कमशा. आदी शेंगेम फेद्दाद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","वार कब्रला नोनीक फोईर आप्पुड वारकी नवल वाटाश्या. वारकी वगा जवान मनशी मंची शेय तीकनुस कुस्नीनोड कमशा. वाड तेल्लांग झगा फेटकुनीन्या. ");
INSERT INTO wbq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","वाड वारनी आन्या, आद्रा कुंडा, मीर नासरेथकर येशुन येवान क्रूसमिंदा येशीनीर वान फुडकुतुनार. गान वाड लेशीनाड. इंदू लेड. वार वान फेट्टीनीर आदी जागा सुडांडा. ");
INSERT INTO wbq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","फोंडा इंगा वान शिष्यलकी इंगा पेत्रक पण शेपना की, वाड मिकाना मुंची गालील प्रांतकी फोयतुनाड, वाड मिक शेपीने लेका आन्दु वाड मिक कमशी. ");
INSERT INTO wbq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","मग वार बैटीक फोईर, इंगा आद्रकेन कब्रनुस दुराम फारीर. वारकी आश्चर्य आय्या. वार येवारकीच येमीच शेप्पालेद येनटीक की वार आद्री फोइनीर. ");
INSERT INTO wbq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हप्ता पहिला दिन्मु नाबद येशुड लेशी नेंका वाड पहिला मग्दालीया नगरलोन मरियादान, यादान नुस वाड योड दैयाल तीशिन्या, दानकी पहला दर्शन इच्या. ");
INSERT INTO wbq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","आदी फोय्या इंगा येडस्केन शोक शेशेतोर वान शिष्यलकी इदी बातमी शेप्या. ");
INSERT INTO wbq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","वार इनीर की वाड जिवंत उंडाड इंगा आदी वान सुशीनाद. आप्पुड वार दान माटा मिंदा विश्वास फेट्टालेद. ");
INSERT INTO wbq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","दिन नंतर वार पैकी इद्दार शिष्यल यरुशलेम दावाता उर तीकुड फोय्येताप्पुड येशुड वारकी इंगोगो रुपता प्रकट आय्या. ");
INSERT INTO wbq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","वार वापस वच्चीर इंगा इंगोगोरकी शेप्पीर गान वार वारमिंदा पण विश्वास फेट्टालेद. ");
INSERT INTO wbq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","मग अकरा शिष्यल तिनेताप्पुड येशुड वारकी कमशा. वाड शिष्यल अविश्वास कस्रोम इंगा वार अंतकरण कठोरपणा कस्रोम वारनी बेद्रीच्या येनटीक की येवार वान लेशिनेन्का शुशीनीर वार मिंदा वार विश्वास फेट्टालेद. ");
INSERT INTO wbq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","वाड वारनी आन्या, “आंता दुन्यामलोंक फोंडा इंगा आंता पृथ्वीक सुवार्ताद घोषणा शेयांडा. ");
INSERT INTO wbq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","येवाड पण विश्वास फेट्टी इंगा बाप्तिस्मा तीस्कुनी वानदी तारण आय्यी, पण येवार विश्वास फेट्टाड वानकी शिक्षा आय्यी. ");
INSERT INTO wbq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","पण येवार विश्वास फेट्यार वार संगा इ चिन्हल आय्यी, वार ना फेरता दैयाल तीश्यार, वार कोत्ता कोत्ताय भाषाल माटलाड्यार. ");
INSERT INTO wbq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","वार स्वता शेयता फामुल येत्यार इंगा वार यादपन जेम फोयेद पदार्थ तागते तरी वार सय्याक फोयार. वार बिमार मंदी मिंदा शेय फेट्ट्यार इंगा बिमारोर शिंगार आय्यार.” ");
INSERT INTO wbq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","मग प्रभू येशुड वारसंगा माटलाडी नेंका वान स्वर्गला तीस्कुनीर इंगा द्यावार मंची शेय तीकुड फोई कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","शिष्याल बैटीक फोईर इंगा वार प्रत्येक जागाला सुवार्ताद घोषणा शेशीर. प्रभुड वार संगा फनी शेश्या इंगा वाड वचन संगा उंडीने चिन्हलता वारदी खात्री शेसका उंड्या. आमेन.");
INSERT INTO wbq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","या माटलाद माक पक्का खातरी आयनाद, आय माटलु येवार पहिलानुस सुशतोर इंगा वचनटोर सेवक उंडीर, ");
INSERT INTO wbq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","वार आय यल्ला नाक सोपाशी इच्चीर आदी आल्ले शेप्पेद आंका आ विषयदी वृत्तांत अनुक्रमता राशेद फनी शेंगेम मंदी शेतल्या तिस्कुन्नार. ");
INSERT INTO wbq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","दिन कस्रोम हे थियफिला महाराज, नीन आन्नी माटलाद बोड्ड्यानुस शिंगार शोध शेशीनेंका नाक पण इदी बागा वाटाशा की, इ आन्नी घटनाल बद्दल निक अर्थपुर्ण माहिती रायाला. ");
INSERT INTO wbq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","दीन कस्रोम की या माटलाद शिक्षण मनाक शिक्कीनाद दानदी सत्य मनाक पूर्णपणे येरका कावाला. ");
INSERT INTO wbq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहुदीया प्रांतोड राजा हेरोद इन दिन्मुलाला, जखऱ्या फेरोड येवाडो याजक उंड्या. वाड अबीया याजक घरानाटोड उंडी वान वडती अहरोन वंशलोंदी उंड्या इंगा दान फेर अलीशिबा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","वार ईद्दार द्यावारदी येरपु फेट्टेतोर उंडीर इंगा परमेश्वर आन्नी आज्ञालदी इंगा विधिलाद पालन शेयदुर. ");
INSERT INTO wbq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","गान वारकी बीडा लेकुंड्या, अलीशिबाद गोडूद उंड्या इंगा वार ईद्दार पण मुस्ल्योर आयनीर. ");
INSERT INTO wbq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","मग इल्ला आय्या की, वाड वान बारी नुसार परमेश्वर मुंदार वाड याजकदी फनी शेशेताप्पुड, ");
INSERT INTO wbq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","याजकला रीतीलेका परमेश्वर भवनला धूप कालचेदेंक चिठ्ठ्याल येशी वानदी निवड शेशेदेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","इंगा आंता मंदीद समुदाय धूप कालचेताप्पुड बैटया प्रार्थना शेस्केन निलाफडीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","आप्पुड परमेश्वर दूत, धूपवेदी मंची शेय तीकुड निलाफडीनोड वानकी कमशा. ");
INSERT INTO wbq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","वान सुशी जखऱ्याड आद्री फोया. ");
INSERT INTO wbq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","गान द्यावारदूत वान आन्या, जखऱ्या येरस्कुनाक, येनटीक की नी प्रार्थना इना वच्चीनाद इंगा नी वडती अलीशिबादान तीकनुस निक कोडकु आय्यी, नु वानदी फेर योहान फेट. ");
INSERT INTO wbq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","इंगा आप्पुड निक आनंद इंगा उल्लास आय्यी इंगा वान जन्मता शेंगेम मंदी खुश आय्यार. ");
INSERT INTO wbq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","येनटीक की वाड परमेश्वर कंडलाला महान आय्यी इंगा वाड द्राक्षरस इंका सराय यप्पुडूच तागाक फोई इंगा वाड आम्मा कडपुला उंडी आप्पुडे पवित्र आत्माता निंडीनोड उंडी. ");
INSERT INTO wbq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","वाड शेंगेम इस्त्राएल संतानलान, प्रभूड वार द्यावार तीकुड मन तीप्पेदेंक कारण आय्यी. ");
INSERT INTO wbq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","इंगा द्यावार मंदीन तैयार शेशी, आब्बागारी मनलु वार बीळ्ळा तीकुड तीप्पी इंगा या बीळ्ळू आज्ञाल मानायार वारनी नीतिमान आज्ञाला येकाफोई प्रभून कस्रोम तैयार शेशीने मंदीन नीलाफडामती वाड एलीयान आत्माता इंगा सामर्थ्यता वार मुंदार नडशी. ");
INSERT INTO wbq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","इंगा जखऱ्याड द्यावारदूतनी आन्या, “इदी आय्यीच दिनमिंदा नीन यल्ला विश्वास फेटदून? येनटीक की नीन तर मूसल्योड उंडान इंगा ना वडती पण मुसलीद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","आप्पुड द्यावारदूत वानकी उत्तर इच्या, “निन द्यावार मुंदार निला फडेतोड गब्रीयल उंडान इंगा नी संगा माटलाडदेंक इंगा निक सुवार्ता शपदेंक नन्नु आंपीनार. ");
INSERT INTO wbq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","सूड, इदी आय्यी नंताक निक माटलाडा दाक फोई इंगा नु मुक्योड निलच्याव येनटीक की नाय माटलु याय योग्य वेळला पूर्णपणे खरेम ठराशी आ माटला मिंदा नु विश्वास फेट्टा लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","आप्पुड जखऱ्याद दावा सुशेतोर मंदीक वाड परमेश्वर भवनला इंता शप येनटीक निलच्या दिंदी नवल वाटाशा. ");
INSERT INTO wbq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","वाड बैटीक वच्चीनेंका वानकी वार संगा माटलाडा दाकुंदू. आप्पुड वारकी तेलच्या की, परमेश्वर भवनला वाड दृष्टांत सुशिनाड. वाड वारकी इशाराल शेस्का उंड्या गान वाड आल्ले मुक्योड निलच्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","मग इल्ला आय्या की वान सेवाद वेळ पूर्ण आयनेंका वाड इल्लुक फोया. ");
INSERT INTO wbq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","काही नाळा नंतर वान वडती अलीशिबाद रंजल मनशी निलच्या इंगा आय्यीद नेलाल दोक्केन निलच्या, आदी आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","मंदीला आय्येद नाद अपमान दुराम शेशेदेंक प्रभूड ना तीकुड सुशा आप्पुड वाड ना कस्रोम इल्ला शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","अलीशिबाद यप्पुड आर नेलालदी रंजल मनशी उंड्या द्यावार गब्रियल दूतनी गालील प्रांतला नासरेथ फेर उरुक, ");
INSERT INTO wbq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","वगा कुंवारीदान तीकुड आंप्या. दानदी दाविद घरानालोन योसेफ संगा इड्याम आयन्या इंगा आ कुंवारीदानदी फेर मरिया उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","स्वर्गदूत दानतीकुड वच्चीगास आन्या, अभिवादन! निमिंदा द्यावारदी शेंगेम कृपा आयनाद. प्रभूड निसंगा उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","गान आदी वान माटलाता येरस्कुन्या इंगा इ अभिवादनदी अर्थ येम उंडी दिंदी आदी नवल शेशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","द्यावारदूत दान आन्या, “मरीये, आद्राक, परमेश्वर निमिंदा कृपा शेशीनाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","सुड! नु रंजल मनशी आय्याव इंगा निक कोडकु आय्यी वान फेर नु येशु फेट. ");
INSERT INTO wbq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","वाड महान आय्यी इंगा वान महान द्यावार कोडकु आन्यार इंगा प्रभूड द्यावार वानकी वान आब्बाड दावीद इनदी सिंहासन इच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","वाड याकोब घराणामिंदा सार्वकालिक राज्य शेशी इंगा वान राज्यद अंत काक फोई.” ");
INSERT INTO wbq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","आप्पुड मरियाद द्यावारदूतनी आन्या, इदी येल्ला आय्यी? येनटीक की नाक मनशी येरका लेद. ");
INSERT INTO wbq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","द्यावारदूत दान आन्या, पवित्र आत्मा निमिंदा वच्ची इंगा महान द्यावारदी सामर्थ्य निमिंदा सावली शेशी इंगा दिन कस्रोम या पवित्र बिडाद जन्म आय्यी, वान परमेश्वर कोडकु आन्यार. ");
INSERT INTO wbq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","सूड, नी गोनगोतला अलीशिबाद पण मुस्लीद उंडी रंजल मनशी उंडाद इंगा दान कडपुला कोडकु निलचीनोड उंडाड इंगा यादान गोडूद आंदूर आदी इप्पुड आर नेलालदी गर्भवती उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","येनटीक की द्यावारकी यादुच माटा अशक्य लेद. ");
INSERT INTO wbq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियाद आन्या, खरेमे “निन प्रभून दासीद उंडान, नु आंटी आल्ले नाक कावाला.” मग द्यावारदूत आंदनुस येल्ली फोया. ");
INSERT INTO wbq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","आ दिन्मुलाला मरियाद लेशा इंगा लगालगा यहुदिया प्रांतलोन कोंडाल दावाता वगा नगरकी फोया. ");
INSERT INTO wbq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","आदी जखऱ्यान इंटल्योंग फोया इंगा अलीशिबा दानकी अभिवादन शेश्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","येल्ला मरिया दानदी अभिवादन अलीशिबाद इन्या दान कडपुलोन बीडा उडी मत्या इंगा अलीशिबाद पवित्र आत्माता निंडी फोया. ");
INSERT INTO wbq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","आदी बेग्गे आवाज शेशी आन्या, “आंड्योरला नु धन्य उंडाव इंगा नी कडपुलोन फळ धन्य उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ना प्रभून आम्मा नातीकुड दावाला इदी मान नाक यंदुकेल?” ");
INSERT INTO wbq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","यप्पुड नी अभिवादनदी आवाज ना गुम्मामिंदा फड्या, आप्पुड ना कडपुलोन बीडा आंनदता उडी मत्या ");
INSERT INTO wbq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","येवार विश्वास फेट्टीर आदी धन्य उंडाद, येनटीक की याय माटलु प्रभूड दानकी शेप्या आय पूर्ण आय्यी? ");
INSERT INTO wbq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","मरियाद आन्या, “नाद जेम प्रभुन महान मानास्ताद, ");
INSERT INTO wbq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","इंगा परमेश्वर येवाड ना ताराशेतोड इन ठायी नाद आत्मा आनंदित आयनाद. ");
INSERT INTO wbq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","येनटीक की वाड मना दासी दानदी दैन्य परिस्थिती सुशिनाड. इप्पुडनुस आन्नी पिढ्याल नन्नु धन्य आनी. ");
INSERT INTO wbq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","येनटीक की येवाड सर्वसमर्थ परमेश्वर उंडाड वाड ना कस्रोम फेद्दा फनी शेशिनाड; इंगा वान फेर पवित्र उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","येवार वानदी येरपु फेटतार वार मिंदा वानदी दया पिढ्यानपिढ्याल उंडी ");
INSERT INTO wbq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","वाड वान शेयता सामर्थी फनील शेशिनाड; येवार घमंडी अंत:करणटोर उंडार वारदी वाड पांगापाग शेशीनाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","वाड राज्य शेशेतोरनी वार सिंहासन मिंदकेल जगी तिशिनाड इंगा गरीबोरनी उंच शेशिनाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","वाड आकालता उंडीने मंदीन उत्तम पदार्थलाता तृप्त शेशिनाड. इंका धनवानोरनी उत्ता शेतलाता वापस आंपीनाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","दया कस्रोम वाड मान सेवक इस्राएलकी मदत शेशिनाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","मना पूर्वजलाक वाड शेप्पीनेलेका अब्राहम इंगा वान संतान इरमिंदुडदी दया नेहमी ध्यानाम शेयाला. वाड मना सेवक इस्राएल इनकी मदत शेशीनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","अलीशिबादान संगा मूड नेलाल निलची नेंका आप्पुड मरियाद दान इल्लुक वापस फोया. ");
INSERT INTO wbq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","अलीशिबा दानदी डीलेवरीद वेळ आयनेंका, आदी वगा मोगाबीडाक जन्म इच्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","प्रभूड दानमिंदा फेद्दा दया शेशीनाड, इदी दान शेजाऱ्याल इंगा नातेवाईकलु इनीर इंगा वार दान आंनदला सहभागी आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","मग इल्ला आय्या की, योड नाळाक बीडाद खतना शेशेदेंक वार वच्चीनाप्पुड वान आब्बान फेरमिंदा वार बीडाद फेर पण जखऱ्या फेटेतोर उंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","गान वान आम्मा उत्तर इच्चा, लेद दानपेक्षा वानदी फेर योहान फेट्टेद. ");
INSERT INTO wbq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","वार दान आनीर, नी गोनगोतला इ फेरोर येवारूच लेर. ");
INSERT INTO wbq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","यंकसार वार वान आब्बान शेय फइक शेशी आडगीर, वानदी फेर येम फेट्टाला, इल्ला निद इच्छा उंडाद ");
INSERT INTO wbq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","आप्पुड वाड रायदेंक पाटी आडग्या इंगा, वानदी फेर योहान उंडाद, इल्ला राशा दिन मिंदनुस वार आंदारकी शेंगेम नवल वाटाशा. ");
INSERT INTO wbq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","आद्दे वेळला वानदी नोर उघडाश्या इंगा वानदी न्यालका मोकळा आय्या इंगा वाड माटलाडदेंक आंट्या इंगा द्यावारकी धन्यवाद इद्देंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","आप्पुड आंदार शेजारोर आद्री फोइर इंगा यहुदीया प्रांतला कोंडाल प्रदेशला मंदी इ आन्नी माटलु माटलाडदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","येवार इदी इनीर वार आंदार मनला विचार शेशेदेंक आंटीर, वार आनिर, इड बीडा मुंदारकी येवाड आयेतोड उंडाड? प्रभुड वान संगा उंडाड इल्ला वार लक्षला वच्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","वान आब्बाड जखऱ्याड पवित्र आत्माता निंड्या इंगा वाड पण भविष्यवाणी शेश्या; वाड आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“इस्राएल द्यावार प्रभुड, इनदी स्तुती उंडाला, येनटीक की वाड मना मंदीत भेट तुस्कुन्या इंगा मंदीद किंमत इच्ची सुटका शेशीनाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","वाड मना सेवक दावीद इन घरानानुस मना कस्रोम सामर्थशाली तारणहार इच्चीनाड. ");
INSERT INTO wbq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","इदी प्रभुड वान पवित्र संदेष्ट्यालद्वारे युग सुरवातनुस शेप्पीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","येवार मा शत्रुल उंडार इंगा येवार मामिंदा कालतार वार देगारनुस सुटका शेशेद अभिवचन वाड माक इच्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","मा पूर्वजला मिंदा दया सुपदेंक वाड इदी शेशेतोड उंडाड इंगा मना पवित्र करारदी ध्यानाम फेट्टेतोड उंडाड, ");
INSERT INTO wbq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","इदी करार वगाट वटू उंड्या इदी वाड मना पूर्वज अब्राहाम संगा शेशीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","आदी इल्ला की, मीर मी शत्रुला शेतल्योन्केल इडी फोईगास, ");
INSERT INTO wbq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ना मुंदार पवित्रता इंगा नितीमत्वता आयुष्यभर नाद सेवा येरस्कुनान्दे शेश्यार, इल्ला नीन शेश्यान. ");
INSERT INTO wbq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","हे बिडा, निनु परात्पर द्यावार संदेष्टा आन्यार येनटीक की प्रभुनदी दावा तैयार शेशेदेंक नु वान मुंदार नडशाव. ");
INSERT INTO wbq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","दिन कस्रोम की, वान मंदीक वार पापला क्षमाता तारणदी अनुभव शिक्काला. ");
INSERT INTO wbq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","द्यावार दया कस्रोम स्वर्गीय दिन्मुद फदु फुट्टी इंगा साव दट्टाम सावलीला येवार जगास्तार वार मिंदा यलगु फडी. ");
INSERT INTO wbq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","दानतीकनुस येवार मोब्बुला उंडार इंगा साव सावलीला कुसनीनार वारकी येलगु इद्देंक इंगा माय काळलु शांती दावाक आंचेदेंक दिनमुद फदु फुट्टामती माद भेट तिस्कुनी.” ");
INSERT INTO wbq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","मग वाड बीडा वाढास्केन फोया इंगा आत्माला सामर्थशाली आय्या. इस्राएल मंदीक प्रकट आय्ये दिन्मुनंताक वाड जंगलला निलच्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","आ दिन्मुलाला रोमी सम्राट अगस्तद आज्ञा आय्या की, आंता प्रांतदी फेरनोंदणी शेशेदेंक दावाला. ");
INSERT INTO wbq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","इदी पहिलाद फेरनोंदणी उंड्या यप्पुड क्वीरीनिय इड सिरीया प्रांतोड राज्यपाल उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","आंदार फेरनोंदणी शेशेदेंक मनामना उरुक फोईर. ");
INSERT INTO wbq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","इंगा योसेफ पण गालील प्रांतलोन नासरेथ उरनुस यहुदीया प्रांतलोन दाविदान बेथलहेम इ उरुक फोया येनटीक की वाड दाविद घराणा लोन्टोड इंगा कुळ लोन्टोड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","फेर राशी इद्देंक, येवात दानसंगा वानदी इड्याम आयन्या आ रंजलमनशी मरीया दान वाड संगा येतकेन फोया. ");
INSERT INTO wbq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","मग इल्ला आय्या, वार आंदे उंडीनाप्पुड दानी दिनाल पूर्ण आय्यी, ");
INSERT INTO wbq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","आदी दान पहिला बीडाक जन्म इच्या इंगा आदी वान बट्टाला गुंडाळीच्या इंगा कोट्टामला फेट्या येनटीक की धर्मशाळाला निल्चेदेंक वारकी जागा शिक्का लेद. ");
INSERT INTO wbq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","आद्दे भागला, मेंढपाळलु मोब्बुलोन वेळला शेल्ला नीलची मनाद खांड राखायदूर. ");
INSERT INTO wbq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","अचानक, परमेश्वर वगा दूत वार मुंदार प्रकट आय्या इंगा प्रभुनदी महिमाद तेज वारभोवती पसराशा इंगा वार शेंगेम आद्रीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","द्यावरदूत वारनी आन्या आद्रा कुंडा; याद फेद्दा आनंद आंता मंदीक आय्येद उंडाद दानदी सुर्वाता नीन मिक शेपतान. ");
INSERT INTO wbq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","बेथलेहेम, दाविद नगरला इबद मी कस्रोम ताराशेतोड फुट्टीनाड! वाड ख्रिस्त प्रभुड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","मी कस्रोम इदी खून उंडी की, बीडा बट्टाला गुंडाळीची कोट्टामला फंडामतीनोड मिक कंपीच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","मग येकायेकी मोळामलोन सैन्यद समुदाय द्यावारदूत देगार वच्या इंगा स्वर्गदूत द्यावारदी स्तुती शेस्का आनीर, ");
INSERT INTO wbq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“मोडामला द्यावारकी गैारव इंगा पृथ्वीमिंदा या मनसुला बद्दल वाड संतूष्ट उंडाड वार नडमा शांती.” ");
INSERT INTO wbq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","इंगा इल्ला आय्या की द्यावारदूत वार देगारनुस स्वर्गलोंग फोया, आप्पुड मेंढपाळलु वगामेगारनी आनीर, नंडा, मनाम बेथलहेमकी फदाम इंगा याद माटा परमेश्वर मनाक शेप्या आदी सुदाम. ");
INSERT INTO wbq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","आप्पुड वार घाईघाईला फोईर इंगा वारकी मरीयाद, योसेफ इंगा कोट्टामला फेट्टीने बीडा वारकी कमशा. ");
INSERT INTO wbq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","आप्पुड मेंढपाळलु वारनी सुशीर आ बीडा बद्दल येम शेपनेद उंड्या आदी वार आंदारकी शेप्पीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","आप्पुड इनेतोर आंदारकी आ मेंढपाळलु शेप्पीने माटा मिंदनुस आश्चर्य चकीत आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","गान मरीयाद इ आन्नी माटला मिंदा मनन शेशी आय मना अंत:करणला फेट्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","यंकसार वार मेंढपाळलु वारकी शेपदेंक वच्चीन्या दानलेकाने इ आन्नी माटलु इनी इंगा सुशी द्यावारदी गैारव इंगा स्तुती शेस्का वापस फोय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","यन्मीद नाळाक आंटे सुंताद दिनमु वच्चीनेंका वान फेर येशु फेटदेंक वच्या. इदी फेर वाड कडपुला उंडाकाना मुंची द्यावारदूत फेट्टीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","मुंदारकी मोशेन नियमशास्त्रनुसार वानदी शुध्दीकरनदी दिन्मु वच्चीनेंका वार वान फइक यरुशलेम शहेरकी येतकेन वच्चीर; आदी दिन कस्रोम की, वान प्रभुनकी समर्पण शेय्याला. ");
INSERT INTO wbq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","आंटे प्रत्येक पहिला फुट्टीने नर प्रभून कस्रोम पवित्र आनाला इल्ला याद प्रभुन नियमशास्त्रला राशिनेद उंडाद दानलेकाने शेय्याला. ");
INSERT INTO wbq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","इंगा प्रभून नियमशास्त्रला शेप्पीनेलेका पारव्यालदी जोडा लेकाते कबुतरी रोंड फील्लाल यज्ञ अर्पणशेय्याला आंका वार वान आंदूक येकेन वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","आप्पुड सुडांडा, यरुशलेमला शिमोन फेरोड येवाड तरी वगा मनशी उंड्या. वाड नीतीमान इंगा भक्तिमान उंड्या. वाड इस्राएल सांत्वनदी दावा सुदू इंगा पवित्र आत्मा वान मिंदा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","इंगा प्रभून ख्रिस्तन सुशीन शिवाय निक साव दाक फोई इल्ला पवित्र आत्मा वानकी प्रकट शेशीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","इंगा वाड आत्माला उंडीनाप्पुड परमेश्वर भवनलोंक वच्या इंगा आप्पुड आम्मा आब्बाड येशु बीडान, वान बद्दल नियमशास्त्र रीतीलेका शेशेदेंक, नोनिक येकेन वच्चीर, ");
INSERT INTO wbq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","आप्पुड शिमोन येशुन मना शेतल्या तीसकुन्या इंगा वाड परमेश्वरकी धन्यवाद शेशा इंगा आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“हे प्रभु, इप्पुड नू नी वचनलेका नी दासनी शांतीता फोनीस्तुनाव. ");
INSERT INTO wbq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","येनटीक की ना कडंलु निद तारण सुशिनाय, ");
INSERT INTO wbq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","आदी नू आन्नी राष्ट्रला मंदी समक्ष सिद्ध शेशीनाव. ");
INSERT INTO wbq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","आदी यहुदी लेनोरकी प्रगटीकरण आयदेंक येलगु इंगा नी इस्राएल मंदीद वैभव इल्ला उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","वान बद्दल शेप्पीने माटलाता वान आम्मा आब्बाड आश्चर्यचकीत आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","इंगा शिमोन वारकी आशीर्वाद इच्या इंगा वान आम्मा मरिया दान आन्या, सूड, इस्रायलला शेंगेम मंदीद फडेद इंगा लेशेद आयदेंक इंगा येवान विरुद्ध मंदी माटलाड्यार इल्ला वगा चिन्ह आयदेंक इन नेमाशिनाड. ");
INSERT INTO wbq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","दीन कस्रोम की, शेंगेम मंदी अंत:करणलोन विचारलु उघड कावाला इंगा नी स्वता:द जेम पण तलवारता आरपार आय्यी. ");
INSERT INTO wbq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","आंदू हन्ना फेरुद वगा संदेष्टीद निलदू. आदी आशेर वंशलोन फनूएल कुतुर उंडी आदी शेंगेम मुसलीद आयन्या. आदी फेंडली आयनेंका दान मोगुन संगा योड यंडलु निलच्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","आदी चैाऱ्याऐंशी यंडलाद विधवा उंड्या इंगा परमेश्वर भवन इडशी फोवांदे उपवास इंगा प्रार्थना शेशी आदी फद्दीनमाप निरंतर आराधना शेस्तुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","आदी आद्दे वेळला देग्गार वच्ची द्यावारकी धन्यवाद इच्या. येवार यरुशलेम सुटकाराद दावा सुदूर वार आंदारकी आदी वान बद्दल शेप्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","आप्पुड वार प्रभून नियमशास्त्र लेका आंता पूर्ण शेशिनेंका, वार गालील प्रांतलोन नासरेथकी वार ऊरुक वापस फोय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","बीडा फेद्दावोड आयका फोया इंगा शक्तीला इंगा ज्ञानला वाढास्का फोया इंगा द्यावारदी कृपा वानमिंदा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","दर याडाद वान आम्मा आब्बाड वल्हांडण फंडगा कस्रोम यरुशलेम शहरकी फोदुर. ");
INSERT INTO wbq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","आप्पुड वाड बारा यंडलावोड उंड्या, वार फंडगा रितीलेका फइक यरुशलेम शहरकी फोय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","आप्पुड फंडगाय आन्नी दिन्मुल आंदु नीलचीनेंका वार इल्लुक वापस वच्चेदेंक येल्लीर. गान बीडा येशुड यरुशलेमलाने यंकाक निलची फो गान वान आम्मा आब्बानकी येरक्का लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","वाड जताक प्रवास शेशेतोर प्रवासीला संगा उंडी इल्ला समजाशी वार वगा नाडदी दावा नडस्केन फोय्यीर यंकसार वार गोनगोतला इंगा मित्रलाला वान फुडकेदेंक सुरु शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","आप्पुड वाड वारकी शिक्काक फो, आंका वार यरुशलेम शहरकी वापस वच्चीर इंगा आंदू वार वान फुडकेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","इल्ला आय्या की, मूड नाळा बाद वार यरूशलेमकी वापस वच्चीर आप्पुड वाड वारकी परमेश्वर भवनला शिक्या, वाड शिक्षकलाला कुसनी वारदी इनदू इंगा वारनी प्रश्नल आडगुदू. ");
INSERT INTO wbq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","येवार वानदी इनीर वार आंदार वान समजबुद्धीता इंगा उत्तरलाता चकीत आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","यप्पुड वार वान सुशीर आप्पुड वार आश्चर्य चकीत आय्यीर. वान आम्मा वान आन्या, “बीडा, नू मासंगा इल्ला येनटीक शेस्ती? मेब्बाड इंगा नीन यंता चिंता शेस्का नीनु फुडकुका वस्तीम.” ");
INSERT INTO wbq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","येशुड वारनी आन्या, “मीर नन्नु येनटीक फूडकुदूर? नीन ना परमेश्वर आब्बान इंटल्या उंड्याला, इदी मीक यरका लेकुंड्या येम?” ");
INSERT INTO wbq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","गान वाड याय माटलू वारसंगा माटलाड्या आय वारकी तेलवालेद. ");
INSERT INTO wbq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","इंगा वाड वारसंगा नासरेथ नगरकी फोया इंगा वाड वार आज्ञाला निलच्या. वान आम्मा इ आन्नी माटलु दान अंत:करणला दाशी फेट्या. ");
INSERT INTO wbq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","येशुड ज्ञानला इंगा शरीरला द्यावार इंगा मनसुला कृपाला वाढास्केन फोया. ");
INSERT INTO wbq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","इप्पुड तीबिया कैसर इन पंधरा यंडला राजकारणला, यप्पुड पंत पिलात यहुदीया प्रांतोड शासक उंड्या इंगा हेरोद अनतिपस चौथाई गालील प्रांतोड शासक उंडी इंगा वान फेद्दा तम्मुड फिलीप्प इड चौथाई इतुरीया इंगा त्राखोनीती इ देशला शासक इंगा लुसनिय इड चौथाई अबिलेनकी शासक उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","हन्नाड इंगा कयफाड इर मुख्य याजकलु उंडीर, आप्पुड मरू भुमीला द्यावारदी वचन जखऱ्यान कोडकु योहान तीकुड वच्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","वाड यार्देन देगार आंता परिसरला पापला क्षमा कस्रोम पश्चाताप शेशी बाप्तिस्मा तिस्कुनाला इल्ला घोषणा शेस्का तिरग्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","यशया संदेष्ट्यान पुस्तकला राशीनेलेका इदी आय्या: “मरू भुमीला घोषणा शेशेतोनदी आवाज आय्या आदी इल्ला, ‘प्रभुनदी दावा तैयार शेयांडा, वानदी दावा सरळ शेयांडा. ");
INSERT INTO wbq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","प्रत्येक दरी निंडी फोई, इंगा प्रत्येक कोंडा इंगा टेकड्या सपाट आय्यी, वर्रांग सरळ आय्यी, इंगा खडबड दावाल सपाट शेशी. ");
INSERT INTO wbq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","इंगा आंता मनुष्य जाती परमेश्वरदी तारण सुशी.’” ");
INSERT INTO wbq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","वान तीकनुस बाप्तिस्मा तीस्कुना वच्चीने मंदीन योहान आन्या; “हे, जहरी फामला फिल्लालाला, वच्चे शिट्टनुस फारदेंक मिमलान येवार सावधान शेशीर? ");
INSERT INTO wbq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","पश्चात्तापकी योग्य इल्ला फळ इयांडा इंगा मी मनलाला इल्ला आनाकुंडा की, ‘अब्राहम मा आब्बानलेका उंडाड.’ येनटीक की नीन मिक शेपतान की, अब्राहम कस्रोम इ राळानुस बीळ्ळू पैदा शेशेदेंक द्यावार समर्थ उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","इप्पुडे माक बोड्याक गोडली फेट्टी उंडाद. दिन कस्रोम प्रत्येक माक याद शिंगार फळ इयाद आदी तेंपिगास आग्गीला येयदेंक वच्ची.” ");
INSERT INTO wbq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","यंकसार समुदायलोन मंदी वान आडगीर, “इप्पुड मीम येम शेशेद?” ");
INSERT INTO wbq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","वाड उत्तर इच्या, “यवार देगार रोंड आंगुल उंडाय वार येवानकी लेव वानकी वगाट इय्याला इंगा येवार देगार आन्नाम उंडाद वाड पण आल्ले शेय्याला.” ");
INSERT INTO wbq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","काही जकातदारलु पण बाप्तिस्मा तीस्कुनदेंक वच्चीनीर. वार आनीर, “गुरुजी, मिम येम शेय्याला?” ");
INSERT INTO wbq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","वाड वारनी आन्या, मिक येम नेमाशी इच्चीनेद उंडाद दानकाना जास्त दुडलू तीस्कुनाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","इंगा शिपाइल पण वान आडगी आनीर, “इंगा माबद्दल येम, मीम येम शेशेद?” वाड वारनी आन्या, “येवार तीकनुस जबरदस्ती दुडलू तिस्कुनाकुंडा, यवार मिंदा खोटाद आरोप येय्या कुंडा, मीक शिक्कीने पगारलाने समाधानी उंडांडा.” ");
INSERT INTO wbq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","आप्पुड मंदी आनंदता दावा सुदूर प्रत्येक मनशी मना अंत:करणला इडे ख्रिस्त उंडी येम आंका विचार शेयदुर. ");
INSERT INTO wbq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","वार आंदारकी योहान उत्तर इच्या, “नीन मीद बाप्तिस्मा नेळाता शेसतान, गान वगाड येवाड नाकाना सामर्थ्यशाली उंडाड वाड वस्तुनाड इंगा नीन वान शपूलाद दाराम ईडशेदेंकबी पात्र लेन, वाड मीद बाप्तिस्मा पवित्र आत्माता इंगा आगीता शेशी. ");
INSERT INTO wbq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","वानी खडाल स्वच्छ शेशेदेंक इंगा गोदमाल वान कोठारीला जमा शेशेदेंक वानदी शाटा वान शेतल्या उंडाद, पण वाड फोटटू आराक फोई इल्लोन आग्गीला कालचेस काडी.” ");
INSERT INTO wbq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","योहान इंगा शेंगेम उत्तेजन इच्चे माटलाता वारकी बोध शेशी सुवार्ता शेप्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","योहान चौथाई शासक हेरोद इन बेद्रीच्या येनटीक की वानदी वान फेद्दा तम्मुन वडती हेरोदीया दानसंगा अनैतिक सबंध उंड्या, इंगा आले इंगा शेंगेम वाईट माटलु वाड शेशीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","इदी आंता शेशी सूद्धा वाड इंगा वगा दुष्कर्म शेशा आदी आंटे वाड योहाननी जेलला येश्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","आप्पुड इल्ला आय्या की, यप्पुड आंता मंदीद बाप्तिस्मा योहान शेयदु, आप्पुड येशुनदी पण बाप्तिस्मा आय्यी वाड प्रार्थना शेशेताप्पुड मोडाम उघडाश्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","इंगा पवित्र आत्मा फयरुपता कबुतरलेका वानमिंदा दिग्या इंगा मोडामलेल इल्ला आवाज आय्या की, “नू ना प्रिय कोडकु उंडाव, निन नी बद्दल शेंगेम संतुष्ट उंडान.” ");
INSERT INTO wbq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","यप्पुड येशुड वान सेवाक सुरुवात शेशा आप्पुड वाड सुमारे तीस यंडलावोड उंड्या. मंदी वान योसेफ कोडकु समजायदुर. योसेफ एलीन कोडकु उंड्या ");
INSERT INTO wbq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एली मत्ताथान, मत्ताथ लेवीन, लेवी मल्खीन, मल्खी यन्रयान, यन्रयाड योसेफ कोडकु उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","योसेफ मत्तीथ्यान कोडकु उंड्या मत्तीथ्याड अमोस, अमोस नहुमान, नहुम हेस्लीन, हेस्ली नग्गयान, ");
INSERT INTO wbq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नग्गय महथान, महथ मत्तीथ्यान, मत्तीथ्य शिमयीन, शिमयीड योसेखान, योसेख योदान कोडकु उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदा योहान कोडकु उंड्या. योहान रेशान, रेशा जरुब्बाबेल, जरुब्बाबेल शल्तीएलान, शल्तीएल नेरीन, ");
INSERT INTO wbq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरी मल्खीन, मल्खी अद्दीन, अद्दी कोसोमान, कोसोम एल्मदामान, एल्मदाम एरान. ");
INSERT INTO wbq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एर येशुन, येशु अलिएजर, अलिएजर योरीमान, योरीम मत्ताथन, मत्ताथ लेवीन कोडकु उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेवी शिमोन कोडकु उंड्या. शिमोन यहूदान, यहूदा योसेफान, योसेफ योनामान, योनाम एल्याकीम, ");
INSERT INTO wbq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एल्याकीम मल्लयान, मल्लया मिन्नान, मिन्ना मत्ताथान, मत्ताथ नाथानान, नाथान दाविदान, ");
INSERT INTO wbq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दावीद इशायान, इशाय ओबेदान, ओबेद बवाजान, बवाज सल्मोनान, सल्मोन नहशोन कोडकु उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहशोन अम्मीनादाब कोडकु उंड्या, अम्मीनादाब अदामीन, अदामीन अर्णयान, अर्णय हेस्रोनान, हेस्रोन पेरेसान, पेरेस यहूदान, ");
INSERT INTO wbq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहूदा याकोबान, याकोब इसहाकान, इसहाक अब्राहामान, अब्राहम तेरहान, तेरह नाहोरान, ");
INSERT INTO wbq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोर सरुगान, सरुग रऊन, रऊ पेलेगान, पेलेग एबरान, एबर शेलहान कोडकु उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","शेलह केनान कोडकु उंड्या. केनान अर्पक्षदान, अर्पक्षद शेमान, शेम नोहान, नोहा लामेखान, ");
INSERT INTO wbq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लामेख मथुशलहान, मथुशलह हनोखान, हनोख यारेदान, यारेद महललेलान महललेल केनानान, ");
INSERT INTO wbq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनान अनोशान, अनोश शेथान, शेथ आदामान, आदाम द्यावारद कोडकु उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","येशुड पवित्र आत्माता पूर्ण निंडी यार्देन वंकानुस वापस वच्चा. इंगा, आत्मा वान मरू भुमीलोंग येतकेन फोया. ");
INSERT INTO wbq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","आंदू शैतान वानदी नलपाय दिन्मुल परीक्षा तिस्कुन्या. आ दिन्मुलाला येशुड येमीच तीनालेद इंगा उपाशी दिन्मुल पूर्ण आयनेंका येशुनकी आकाल आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","आप्पुड शैतान वान आन्या, जर नू परमेश्वर कोडकु उंडाव तर इ रायदी रोट्या कावाला, इल्ला आज्ञा शेय. ");
INSERT INTO wbq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","येशुड वानकी उत्तर इच्या, “पवित्र शास्त्रला इल्ला राशीनेद उंडाद की, मनशी फक्त रोट्याता जगाशी इल्ला लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","मग शैतान वान उंच जागामिंदीक येकेन फोया इंगा वगा क्षणला जगलोनी आन्नी राज्यल वानकी सुपीच्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","शैतान वान आन्या, “नीन निक इ आन्नी राज्यलाद अधिकार इंगा वैभव इच्यान येनटीक की आय नाक इद्देंक वच्चीनाय इंगा नीन ना मर्जी लेका आय इच्ची शेकास्तान. ");
INSERT INTO wbq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","दिन कस्रोम जर नु नाय काळ मोकती इंगा नाद आराधना शेस्ती तर इदी आंता नीद आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","येशुड उत्तर इच्चा, “पवित्र शास्त्रला इल्ला राशीनेद उंडाद. प्रभुड नी परमेश्वर इन्दे आराधना शेय इंगा फक्त वान्दे सेवा शेय.” ");
INSERT INTO wbq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","यंकसार शैतान येशुन यरुशलेम शहरकी येकेन फोया इंगा परमेश्वर भवन टोकमिंदा वान नीला फडामत्या इंगा वाड वान आन्या, “जर नु द्यावार कोडकु उंडाव तर इंदकेल किंदा उडी मत! ");
INSERT INTO wbq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","पवित्र शास्त्रला इल्ला राशीनेद उंडाद की, ‘नीद रक्षण 'शेशेदेंक वाड वान दूतलाक निविषयला आज्ञा शेशी, ");
INSERT INTO wbq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","इंगा नीद काल रायमिंदा आपटायाराद आंका वार नीनु मना शेतलामिंदा झेलास कुन्यार.’” ");
INSERT INTO wbq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","येशुड उत्तर इच्या, “पवित्र शास्त्रला इल्ला पण आनिनार; नी प्रभु परमेश्वर इनदी परीक्षा सूडाक.” ");
INSERT INTO wbq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","दिन कस्रोम शैतान आन्नी प्रकारदी परीक्षा तीस्कुनेद आयनेंका योग्य वेळ वच्चीनंताक वाड येशुन इडशी फोया. ");
INSERT INTO wbq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","मग पवित्र आत्मा सामर्थ्यता येशुड गालील प्रांतकी वापस फोया इंगा वान बद्दल बातमी आंता तीकुड पसराश्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","वाड वार यहुदी सभास्थानला नेरप्या इंगा आंदार वानदी स्तुती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","इंगा यंदू वाड शिन्नाप्पुड नुस फेद्दावोड आयन्या आ नासरेथकी वाड वच्या इंगा शब्बाथ दिनमु वाड प्रथालेका यहुदी सभास्थानला फोय्यी ग्रंथ वाचायदेंक निला फड्या, ");
INSERT INTO wbq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","इंगा यशया संदेष्ट्यान ग्रंथपट वानकी इद्देंक वच्या. वाड आदी पुस्तक तेरशा इंगा याद भाग फुडकी तिशा, आ जागाला इल्ला राशिनेद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“प्रभूनदी आत्मा नामिंदा वच्चीनाद, येनटीक की, गरीबोरकी सुवार्ता शेपदेंक वाड नाद अभिषेक शेशीनाड. कैदी शेस्का येका फोईनोरकी स्वातंत्र्यद घोषणा शेशेदेंक, इंगा गुड्ड्योरकी कंडलु वापस शिक्काला, येवारमिंदा जुलूम आयनाद वारदी सुटका शेशेदेंक ");
INSERT INTO wbq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","इंगा प्रभून कृपा वर्षाद घोषणा शेशेदेंक वाड नन्नु आंपीनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","मग वाड ग्रंथपट बंद शेशिगेस यहुदी सभास्थानाला सेवकनी वापस शेशी वाड किंदा कुसन्या. सभास्थानलोंटोर प्रत्येकजन वानदेगार रोखाशी सुस्तुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","वाड वारसंगा माटलाडदेन्क सुरुवात शेशा की, “मीर इनीने कस्रोम इबद इदी शास्त्रलेख पूर्ण आयनाद.” ");
INSERT INTO wbq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","आप्पुड आंता मंदी वान बद्दल साक्ष इद्देंक आंटीर इंगा वान नोरनुस येल्लीने कृपा माटला बद्दल वार आश्चर्य चकीत आय्यीर इंगा वार वगामेगारनी आनीर, इड योसेफ कोडकुने लेड येम? ");
INSERT INTO wbq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","येशुड वारनी आन्या, “नक्कीच, मीर नन्नु इल्ला पण आन्यार; हे वैद्या, नु स्वतःन बागा शेय. कफर्णहुमला याय माटलु नु शेशीनेय मीम इंटीम आय माटलु नी स्वतः उळ्या नासरेथला पण शेय.” मग वाड मुंदारकी आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“मीन मीक खरेम शेपतान, यादुच संदेष्टाक वान स्वतः नगरला मान्यता शिक्काद. ");
INSERT INTO wbq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","नीन मीक खरेम शेपतान, इस्राएलला एलीयान काळला शेंगेम विधवाल उंडीर, यप्पुड साडेतीन यंडला नंताक मोडामनुस वाना फडालेद इंगा आंता प्रदेशला फेद्दा दुष्काळ फडीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","तरी पण एलीयान इंगोगो यादुच विधवादान देगार आंपदेंक दालेद. वान यहूदी लेने सिदोन प्रांतलोन सारफथ इंदुड विधवादान देगार आंपदेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अलीशा संदेष्टान वेळला इस्रायलला शेंगेम कुष्ठरोगील उंडीर पन वारपैकी येवारुच शुद्ध कालेर. फक्त सुरिया इंदूड नामान कुष्ठरोगीन शुद्ध शेशेदेंक वच्चीन्या.” ");
INSERT INTO wbq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","इदी इनी यहुदी सभास्थानला आंता मंदी कोफाम फडीर. ");
INSERT INTO wbq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","वार मंदी लेशीर इंगा वार येशुन शहर बैटीक गेदमेशीर इंगा या कोंडामिंदा वानदी उर उंड्या, दान कंटाम नुस वान दोब्बेस काडदेंक आडनंताक येकाफोईर. ");
INSERT INTO wbq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पण वाड वार दिंटलोनुस येल्ली वान दावाता फो. ");
INSERT INTO wbq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","मग वाड गालील प्रांतलोन कफर्णहुम ऊरुक फोया. वाड शब्बाथ दिनमु यहुदी सभास्थानला वारकी नेरपुतुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","वार वान शिक्षणता आश्चर्य चकीत आय्यीर, येनटीक की वानी माटलु अधिकारयुक्त उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","आबद सभास्थानला, अशुद्ध आत्मा आंटीने वगा मनशी उंड्या इंगा वाड बेग्गे कीरली आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","हे नासरेथकर येशु, नू मा नडमा येनटीक फडताव? नू माद नाश शेशेदेंक वच्चीनाव येम? नु यवाड उंडाव इदी नाक येरका उंडाद! परमेश्वरान पवित्र! वाड नुये उंडाव. ");
INSERT INTO wbq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","येशुड वान धमकामती आन्या, “तेप्पांग उंड इंगा वानलोनुस येल!” आप्पुड आ अशुद्ध आत्मा आ भुमीमिंदा किंदा केडप्या इंगा आ मनशीक येमीच शेय्यांदे आदी वानलोनुस बैटीक येल्ली फो. ");
INSERT INTO wbq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","आप्पुड आंदार आश्चर्य चकीत आय्यीर इंगा वगामेगारनी माटलाडदेंक आंटीर, इदी या प्रकारदी शब्द उंडाद? अधिकारता इंगा सामर्थ्यता वाड अशुद्ध आत्मालकी सुद्धा आज्ञा शेस्ताड इंगा आय बैटीक येलताय. ");
INSERT INTO wbq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","इ प्रकारता वान बद्दल कीर्ती नालुंग तीकुड प्रदेशलाला पसरास्का फो. ");
INSERT INTO wbq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","आबद येशुड सभास्थाननुड येलीगास शिमोन इल्लुक फो. शिमोन आत्ता जडमुता बिमार उंड्या. वार दान बागा शेशे कस्रोम वानकी विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","येशुड दानदेगार नीला फड्या इंगा वाड जडमून बेद्रीच्या इंगा दान लोनुस जडमु येल्ली फो. लगेच लेशी आदी वानदी सेवा शेशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","फददु मुनगेताप्पुड, अलग-अलग बिमारीलाता बिमार उंडीने आंता मंदीन वानदेगार येकेन वच्चीर. वाड आंदार नत्तीमिंदा शेय फेट्टी वारनी बागा शेश्या. ");
INSERT INTO wbq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","यंतातरी मंदीलोनुस अशुद्ध आत्माल बैटिक येल्या. आय अशुद्ध आत्माल किर्लुदू इंगा आनदु, नु परमेश्वर कोडकु उंडाव. गान वाड ख्रिस्त उंडाड इदी आटलाक येरका उंड्या आंका वाड आटलान बेद्रीच्या इंगा येमीच माटलाडा नियालेद. ");
INSERT INTO wbq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","फदु फुट्टीन नग्रेम, वाड एकांत जागालोंक फो. गान मंदी वान फूडकुदूर. वाड यंदू उंड्या आंदूक वार लगेच वच्चीर इंगा वार लोनुस वाड येल्ली फोवाराद आंका वार प्रयत्न शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पन वाड वारनी आन्या, “द्यावार राज्यद सुवार्ता नाक बाकी उळ्ळाला पण शेप्पाबेक येनटीक की दिन कस्रोमी नन्नु आंपीनेद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","मग वाड आंता यहुदीया प्रांतला सभास्थानलाला उपदेश शेस्का फो. ");
INSERT INTO wbq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","मग वगा नाड, येशुड गनेसरेत सरोवर कंटामकी निलाफडीन्या आप्पुड मंदी परमेश्वरदी वचन इनदेंक येशुन भोवती गर्दी शेशेदेंक आंटीर, ");
INSERT INTO wbq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","आप्पुड वाड सरोवराला रोंड जहाजलु सुश्या, गान जहाज लोन्टोर मिल फट्टेतोर बैट्या उंडीर इंगा वारी जाळील कडगुदूर. ");
INSERT INTO wbq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","दांटल्योन वगा जहाजलोंग येशुड फोया आदी शिमोनदी उंड्या इंगा, वाड कंटामनुस रवा दूराम येतका फोयेदेंक शेप्या. मग वाड जहाजला कुसन्या इंगा मंदीक शिक्षण इद्देंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","येशुनदी माटलाडेद आयनेंका येशुड शिमोननी आन्या, “जहाज लोत नेळालोंग तिस्को इंगा मिल फटदेंक नीद जाळी किंदीक इडु.” ");
INSERT INTO wbq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","शिमोन उत्तर इच्या, “गुरूजी, मोब्बूलाला मिम शेंगेम मेहनत शेस्तीम पण येमीच शिक्कालेद. तरी नु आंटाव आंका जाळी किंदीक इडस्तान.” ");
INSERT INTO wbq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","मग वार आल्ले शेशीनेंका वार जाळीला मिलाद फेद्दाद घोळका शिक्या इंगा वानदी जाळी शिंगेदेंक आंट्या ");
INSERT INTO wbq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","आप्पुड वार इंगोगो जहाजलोन मना सहकारीलाक मदत शेशेदेंक कुतेशीर. वार वच्चीर मग इल्ला आय्या की आय रोंडू जहाजलु मिलाता इंता निंड्या की, आय मुन्गेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","आप्पुड इदी सुशी शिमोन पेत्र येशुनी काळलु मोक्की आन्या, “ना देगारनुस दुराम येल्ली फो येनटीक की नीन पापी मनशी उंडान.” ");
INSERT INTO wbq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","येनटीक की वार फट्टीने मिलाद घोळका सुशी वाड इंगा वान संगा उंडीनोर आंदार आश्चर्यचकीत आयनीर. ");
INSERT INTO wbq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","आप्पुडे शिमोनान भागीदारलु जब्दीन कोडकु याकोब इंगा योहान इर पण वारलेका आश्चर्यचकीत आय्यीर. इंगा येशुड शिमोननी आन्या, “आद्राक, येनटीक की इंदनुस मुंदारकी नु मनसुलान फट्टेतोड आय्याव.” ");
INSERT INTO wbq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","मग वार जहाजलु कंटामकी आंचीनेंका वार आंता काही इडशीर इंगा वान यंका फोइर. ");
INSERT INTO wbq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","मग इल्ला आय्या की, येशुड यादो वगा उळ्या उंडीनाप्पुड आंदु कुष्ठरोगता निंडीनोड वगा मनशी उंड्या, यप्पुड वाड येशुन सुश्या आप्पुड वाड बोरकाला फड्या इंगा वानकी विनंती शेशा, “प्रभू, जर नीद इच्छा उंटे तर नन्नु शुद्ध शेशेदेंक नु समर्थ उंडाव.” ");
INSERT INTO wbq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","आप्पुड येशुड वानदी शेय मुंदारकी शेशी वानकी स्पर्श शेश्या इंगा आन्या “नाद इच्छा उंडाद शुद्ध का!” इंगा लगेच वानदी कुष्ठ येल्ली फोया. ");
INSERT INTO wbq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","मग येशुड वानकी आदेश इच्ची शेप्या की, “यवारकीच शेप्पाक, पण फोईगास स्वतान याजककी सूपी इंगा वारकी साक्ष कावाला आंका मोशेड आज्ञा शेशीनेलेका शुद्धीकरण कस्रोम अर्पण शेय.” ");
INSERT INTO wbq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","परंतु येशु विषयी बातमील इंगा पसरास्का फोया इंका फेदाद जमाव वानदी ऐकादेंक इंगा मना रोगलाता शिंगार आदेंक जम आदूर. ");
INSERT INTO wbq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पन येशुड जंगला एकांतला फोई प्रार्थना शेयदू. ");
INSERT INTO wbq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","इल्ला आय्या की, ओकानाळ वाड शिक्षण इस्तांना आंदू परुशील इंगा नियमशास्त्रटोळ शिक्षक कुशिंडीर वार गालील इंका यहूदीया प्रांत इंगा यरुशलेम शहर इ भागलोन यंनीतरी जागाललोंकेल वचीनीर. प्रभूनदी सामर्थ्य वान ठायी उंड्या दानइचांग वाड रोग बागा शेयदु. ");
INSERT INTO wbq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","इंगा मंदी वगा लकवा आइने मंशीन मंचाममिंदा येतकेन वचीर इंका वार वान नोना येतकेन इंगा येशुन मुंदार किंदा फेटदेंक प्रयत्न शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","पन गर्दीगोन नोना येतकेन वचेळदी दावा वारकी शिकाद, दांचांग वार इल्लु छतमिंदा यकी वान मंचाम सोबत कौल्याल मिन्द्केल येशुन मुंदार किंदा इडशीर. ");
INSERT INTO wbq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","वानदी विश्वास सुशि, येशुड आन्या, “बीडा नि पापलाद क्षमा आयनाद.” ");
INSERT INTO wbq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","नियमशास्त्र शिक्षक इंगा परुशी स्वत:संगा विचार शेस्देन्क आंटीर “इदी दुर्भाषण शेशातोड यवार? परमेश्वर शिवाय यवार पापलाद क्षमा शेशु शकास्ताड?” ");
INSERT INTO wbq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","इंगा येशुड वारी विचारलु जाणास्केन वारकी उत्तर इच्चीगेस आन्या, “मीर स्वता अंत:करणला इल्ला विचार यला शेस्तार? ");
INSERT INTO wbq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","नि पापलाद क्षमा आइनेद उंडाद इंका लय इंगा नडू इटला लोंकेल याद सोपा उंडाद? ");
INSERT INTO wbq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पण मीक इदी तलवाबेक की मनशी,. कोडकुक पृथ्वीमिंदा पांपलाद क्षमा शेशेळदी अधिकार उंडाद, दांचांग वाड लकवा आइने मनशीन आन्या, नीन निक शेपतान लय, नीद मंचम यत्तीगेस नि इल्लुक फो.” ");
INSERT INTO wbq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","लगानाने वाड निलाफडया इंगा आ मंचाम मिंदा वाड फंडकोणी उंड्या आदी येतीगात परमेश्वरदी गौरव शेस्केन स्वता इल्लुक फोया. ");
INSERT INTO wbq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","वार आंदार आश्चर्यचकीत आय्यीर इंका परमेश्वरदी स्तुती शेशेदेंक आंटीर, वार संगेम आद्रीगात आनीर, मीम इफोद अद्भुत गोष्टील सुशिमटीम. ");
INSERT INTO wbq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","'इ माटलु आयनेंका येशुड बेट्या फोया इंका वाड लेवी फेर जकातदार नी जकात नाका मिंदा कुसनेन सुशा, येशु वान आन्या, “ना यंकाक दा!” ");
INSERT INTO wbq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","आप्पुड लेवीड आन्त्तायम आंदे इडशा लेशी वानयंकाक फोया. ");
INSERT INTO wbq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","मग लेवीड वान इंटल्या येशुन इचांग फेदाद वन्टा इच्या इंगा जकातदार ड व इंगा मंदीद फेद्दा जमाव वानबराबर तिंदू. ");
INSERT INTO wbq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","पन परुशी इंका नियमशास्त्रटोळ शिक्षक इर वान शिष्यलतीकुड तक्रार शेशा, वार आनीर, मीर जकातदार इंका पापी मंदीसंगा येनटीक टीनताव? ");
INSERT INTO wbq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","येशुड वारनी आन्या, “यवार निरोगी उंडार वारकी वैद्यनदी यवार्की गरज लेद, पण यवार रोगी उंडार, वारकी वैद्यनदी गरज उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","नीन नितीमानलान कुतेदेंक दालेन तर पापी मंदीक पश्चात्पाइचांग शपिदेंक वचीनान.” ");
INSERT INTO wbq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","वार वान आनीर, योहान शिष्यल नेहमी उपवास इंका प्रार्थना शेस्तार इंका काही फरुसी इंगा नियम शास्त्र गुरु वार समूह ला उंडिर, वार पण आले शेशार, पण नि शिष्यल तर तिनी तागी उंटार. ");
INSERT INTO wbq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","येशु वारनी आन्या, “यवार इल्ला शेशार? वऱ्हाडलासंगा फेनली कोडकु उंडाळ तोपर्यंत मिक वारनी उपवास शेयपिदेंक वची यम? ");
INSERT INTO wbq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","पण इल्ला दिनाम वचीनेद उंडाद की, फेनली कोडकुन वारदेगारकेल तीस्कोनी इंका आ दिनाला वार उपवास शेशार.” ");
INSERT INTO wbq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","वाड वारकी इंगा ओकाट दाखला शप्या, “यवारबी कोता बटाद तुकडा शिनगामती फातादांकी आंचार, जर वाड इल्ला शेस्ताड तर वाड कोताद बटा शिनगामतुताड पण कोता बटाद तुकडा फाता बटाक बागा कमपियक फोई. ");
INSERT INTO wbq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","इंका यवारबी कोता द्राक्षरस फाता द्राक्षरस कतोल थैलीला फेटार जर वाड इल्ला शेस्ताड तर कोता द्राक्षरस कातडी थैली शिनगी बेट्या उसळाशी इंगा आदि थयली खराब आयी. ");
INSERT INTO wbq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","कोताद द्राक्षरस कोताद कातडी थैलीला फेटा बेक. ");
INSERT INTO wbq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","यवारकीबी फाताद द्राक्षरस तागीनेन्का वारकी कोताद बेक लेकूंनटाद येनटीक की वाड आंटाड, फाताद द्राक्षरसे बागा उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","आंन्ट्यागा ईळा आय्या की, वगा शब्बाथ दीनामला येशुड शेलानेळ यळीन्याआन वान शिष्यल् कनसल् तैम्पी शेतल्या चोळाशी तिंटुडीर. ");
INSERT INTO wbq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","आप्पुड परुशयांलोंटोर आनीर, “शब्बाथ दिनामला येम योग्य लेद, आदी मिर याला शेस्तार?” ");
INSERT INTO wbq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","येशुड वारीक आन्या, “यप्पुड दाविद आन वानबरोबर मंदिक आकाल आईन्या आप्पुड वार येम शेशीनाड ईदी मीर शास्त्र लेख ला वाचायाले येम? ");
INSERT INTO wbq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","वाड द्यावार ईटला फो आन समर्पित रोट्याल याजकांन शिवाय यवारच तिनेद योग्य लेद आवी वार यळा तिनीर आन मनाबरोबर उंडीनोरक् वार्कबी ईच्चीर.” ");
INSERT INTO wbq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","इंगा येशु ड वारीक आन्या, “मनशी कोडकु शब्बाथ प्रभु उंडाळ.” ");
INSERT INTO wbq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ईळा आय्या की, दुसरा वगा शब्बाथ दिनामला येशुड यहुदी सभास्तानला व्हो आन शिकामतीदेंक आन्ट्या. यवानद उजवा शेई सुकाशिंद यीळा आंद ऊंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","येशुड शब्बाथ दिनामला यवारक् बागा शेस्ताड येम ईदी सुशेईच्चागा काही नियमशास्त्र लोंट्योर शिक्षक आन परुशी वानमिंदा धानाम फटी उंडीर. ईचांग की वारीक आरोप फैटदैंक येमतरी कारण शिक्काबेक. ");
INSERT INTO wbq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","गान वाड वारी विचारल् तेलस्कुनी सुकाशिन शेत ऊंडीनोड मनशिक आन्या, “लेईआन आंदार मुंदारा निला फड,” आन हा मनशी लेशी आंद निला फड्या. ");
INSERT INTO wbq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","येशुड वारीक आन्या, “नीन मिक आडगतान, शब्बाश दिनामला या गोष्टील शेशेय परवानगी ऊंडाद? बागा शेशेद की वाईट शेशेद? याद कायदेशीर ऊंडाद, वगानक जेम वाचाशेद येम वांद नाश शेशेद?” ");
INSERT INTO wbq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","आन्ट्यागा वाड सभाला हा आंदार तीक सुशा आन आन्या, “नी शेई फेदाद शेई.” आप्पुड वाड आळा शैशा आन वांद शेत बागा आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","इंगा परुशी आन नियमशास्त्रलोंट्यो शिक्षक सना किरलिर आन येशुन विषयी येम शेशाक वच्ची ही विषयी वगामेगारक चर्चा शेशेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","हा दिवसला ईला आय्या की, येशुड प्रार्थना शेशेईचागा कोंडामींदा व्हो. वाड आदी मबु द्यावारद प्रार्थना शेसदेन्क घालवाशा. ");
INSERT INTO wbq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","यप्पूड फदु फुट्या, आप्पुड वाड शिष्यलनी स्वतादैगारा कुतेश्या. वाड वारदांट्ल्या बारा जनन निवडाशा आन वारिक 'प्रेषित' ईळा फेर ईच्या. ");
INSERT INTO wbq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","शिमोन वानिक पेत्र ईदी सुद्धा फेर ईचा वाड अंद्रिया (प्रेत्रन तंमुड), याकोब आण योहान, फिलीप्प, बर्थलमय, ");
INSERT INTO wbq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्तय, थोमा, अल्फीन कोडकु याकोब, शिमोन वानीक जिलोत आंटार, ");
INSERT INTO wbq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकोब कोडकु यहूदा आन यहूदा इस्कर्यौत, यवार मूंदारा विश्वासघात शेशेतोड यल्या. ");
INSERT INTO wbq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","येशु वारबरोबर कोंडामींदेळ किंदा दिग्या आन सपाट जागामिंदा निला व्हड्या इंका वान अनुयायील व्हेदा समुदाय आंद वच्चा आन यहुदीया प्रांत, यरुशलेम ऊर, सोर आन सिदोन समुद्र थट शहर, कडेळ ईळा सना मंदि आंद वचीरनीर. ");
INSERT INTO wbq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","वार आंद येशु द ईनदैक आन रोगामगोन बागा आयदेंक वच्चीनीर आन यवारक्. अशुद्ध आत्माद् बाधा ऊंड्या वारीक पण हा पिढान मोकळा शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","आंता मंदी घोळका वानिक स्पर्श शेसदेन्क सुस्तुंड्या, कारण वानदांटळेल सामर्थ वस्तुंड्या आन आंदारक आदी बागा शेसस्तुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","यंकसार येशुड मना शिष्याल् तीक सुशा आन आन्या, “हे दिनमनशी, मीर धन्य ऊंडार कारण द्यावार राज्य मीद ऊंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","हे मीर यवार इप्पुड आकालकोन्योर ऊंडार, वार मिर धन्य ऊंडार, कारण मीर तृप्त ऐय्यार. हे मीर यवार इप्पुड येडस्तार, आदी मीर आशीर्वादित ऊंडार कारण मीर नग्यार. ");
INSERT INTO wbq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","यप्पूड मन्शी कोडकु गोन मंदि मीद द्वेष शेशार आन येपुन वार मना समाजनुट मिक धुराम शेशार आन मिद निंदा शैशार आन मीद फेर वार चुकीद आंका कुकेश्यार आन मन्शी कोडकु ईचागा मीक नाकाराशीर, आप्पुड मीर धन्य ऊंडार. ");
INSERT INTO wbq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","हा दिनामला एला अवते आनंद शेशी उड्याल मत्तना, कारण खेरेमे स्वर्गला मिद प्रतिफळ व्हेदाद ऊंडाद! कारण वार पुर्वजल् पण संदेष्ट्याल् क आळे शैशीर. ");
INSERT INTO wbq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","पण श्रीमंतलोर, मीक दुःख काबेक् कारण मीक पौल आंता सुख शिक्कीन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","यवार मिर तृप्त उंडार मिक दुःख काबेक, कारण मीर आकालनोर आय्यार. यवार इप्पुड नग्गतार वारीक दुःख आवान कारण मिर शोक शेशार आन येडश्यार. ");
INSERT INTO wbq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","यप्पूड आंदार मिबद्दल बागा आन्यार आप्पुड मीक दुःख आवान कारण वार अब्बागारल खोट्टी संदेष्ट्याल्योंटोर क यीळे शेशीनार.” ");
INSERT INTO wbq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“परंतु मिर ईनेतोरक् निन शेपतान, मी शत्रुमिंदा प्रिती शेईना. यवार मिद व्देष शेश्तार, वारद् बागा शैईना. ");
INSERT INTO wbq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","यवार मीक श्राप ईस्तार वारीक आशीर्वाद ईना. यवार मीद अपमान शैस्तार वार ईच्चागा प्रार्थना शैईना. ");
INSERT INTO wbq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जर यवार मी वगा शम्पाक मततार तर वानमुंदारा दुसरा पण शाम्पा शैई. जर यवार मी बंटाल तुस्कुंटार तर वानिक नीद कुर्ता पण येतकेन व्ह्यदेंक मना शैयाक. ");
INSERT INTO wbq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","यवार मीक आडगुतार वार आंदारक ई आन यवार मीद वस्तू जग्गी तुस्कुटाड वानदैगारा इंगा आडगाक. ");
INSERT INTO wbq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","आन यळा मंदी मीसंगा वागायाबेक आनकेन मीद ईच्छा ऊंटाद आंळे मीरपण वागायना.” ");
INSERT INTO wbq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“मीमींदा यवार प्रिती शेसतार वारमींदा प्रिती शेयडा, तर दांट्ल्या मीद उपकार तो यम? कारण पापी मंदिपण मनामिंदा प्रिती शेशेतोर मींदा प्रिती शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","मीद यवार बागा शेश्तार, वारद् जर मीर बागा शेश्तार तर मीक येम फायदा? पापी पण ईळे शैश्तार. ");
INSERT INTO wbq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","यवार तिकेळ मीक परत शिक्की ईळा आशा ऊंटाद, वारीक जर उसना ईस्टार तर मिक येम फायदा? पापीपण परत शिक्काबेक ही उद्देश गोन दुसरा पापीक उसना ईस्ताड. ");
INSERT INTO wbq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","परंतु मिर मना शत्रूमींदा प्रिती शेईना आन वारद बागा शैईना आन निराश न आता उसना ईना आंटे मीद प्रतिफळ व्हेदाद आयी आन मीर परम कोडकु आय्यार कारण वाड अनुपकारी आन वाईट विरमीदां दया शेशेतोड ऊंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","यळा मी परमेश्वर आब्बाड दयाळू ऊंडाळ आळा मीरपण दयाळू ऊंडना.” ");
INSERT INTO wbq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“यवारद् न्याय शैय्याकुंडा, आंटे मीदपण न्याय काक फोई. यवार मिन्दा दोष ईय्याकना आंटे मिक दोषी ठरवायाक फैय्यार. उन्गोरण क्षमा शैईना आंटे मिक क्षमा शिक्की. ");
INSERT INTO wbq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ईना आंटे मिक ईच्चार. बागा माप दाबाशी, हालवाशी शीग निंड्डी मि व्हदरामला येशार कारण या मापगोन मिर मापाशी ईच्चार हाच मापनेळ मिक परत मापाशी ईच्चार.” ");
INSERT INTO wbq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","वाड वारीक वगा उदाहरण शैप्या, “वगा गुड्योळ दुसरा गुड्योंनक दावा सुपी यम? वार ईद्दारपण खड्याला फडार यम? ");
INSERT INTO wbq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","यापण शिष्य वान गुरू पेक्षा थोर लेद. पण प्रत्येक शिष्य येपुड पूर्ण नेरस्ताड आप्पुड वाड गुरुनलेकाच आवताड. ");
INSERT INTO wbq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","स्वतः कनलोन मुसळ ध्यानामला न फेटता नु मना तंमुनद् कन्नलोंद् कुसळ याला सुस्ताव? ");
INSERT INTO wbq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","लेद आंटे नु मना कन्नलोंद मुसळ सुडांदे मना तंमुनक् यळा आन्याव की, आन्ना, नी कन्नलोंद कुसळ नाक तियान? अरे ढोंगी, प्रथम नी कन्नलोंद मूसळ ती आंन्ट्यागा निक आप्पुड नी तंमुनद् कुसळ तिशेतापुड बागा कंमशी.” ");
INSERT INTO wbq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","यादच माक बागा लेद की, आदी वाईट फळ ईस्ताद किंवा यादच वाईट माक लेद की, आवी बागा फळल् ईस्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","कारण प्रत्येक माक ईदी दानी फळलगोन गुडतू फेटतार. मंदि काट्याल् झुडूपनेळ अंजीरलु गोळा शयार आळे काटेरी झुडूपनेळ वार द्राक्षल् गोळा श्यार. ");
INSERT INTO wbq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","बागा मनशी वान अंतकरणला या बागा गोष्टील् साठाशिनी ऊंडाय आंवे तीस्ताड आन दुष्ट मनशी वान अंतकरणला येम वाईट ऊंडाद आद्दे बैटीक तीस्ताड कारण अंतकरणला येम निंड्डीनाद आद्दे नोरनेळ यळी. ");
INSERT INTO wbq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“मीर नाक ‘प्रभू, प्रभू,’ अन्टार, पण नीन यम शप्पतान आदी मिर याला शेयार? ");
INSERT INTO wbq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","प्रत्येक जण यवाड नादैगारा वस्ताड आन ना वचनलु ईनी आवी आज्ञाल पाळास्ताड वाड यळा ऊंडाळ ईदी नीन मिक सुप्तान. ");
INSERT INTO wbq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","वाड वगा ईलु कटेळ मनशी लेका ऊंडाळ. वाड नोत तव्या आन राईमिंदा पाया कट्या. आंन्ट्यागा पुर वच्चा आन नेळाद लोंढा ईल्लमिंदा आदळाशा, पण नेळागोन आदी हालायाले, कारण आदी बागा कट्टीनद् ऊंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","पण यवाड नाई वचनल् ईंन्टाड पण आवी पाळायाले तर वाड मना 'ईल्ल पाया फेटान्दे जमीनमींदा कटीनार हा मनशीलेका ऊंडाड, हा ईल्लमिंदा नेळाद लोंढा आदळाशा आन आदी लगेच फड्या आन हा ईलुद संगेम नाश आय्या.” ");
INSERT INTO wbq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ईनेतोर मंदिक वाड मना आंता वचनलु शेप्पेय संपाशीनंका वाड कफर्णहुमला प्रवेश शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","आप्पुड यवाड वगाड शताधिपतीद् आवडाशेतोड दास बिमार आय्यीगेस सच्चेक टेकाशीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","आप्पुड रोमी अधिकारी येशुनदी ईनी यहुदीयाल आब्बान वानदैगारा आमशी, नु वची ना दासक वाचवाय, ईळा वानिक विनंती शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","यपुदड वार येशुन दैगारा वच्चीर आप्पुड वार वानिक आग्रहगोन विनंती शेशीर, यवान कसरम नु ईदी शैय्याबेक, वाड योग्य ऊंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","कारण वाड मा यहूदी मंदी मींदा प्रिती शेस्ताड आन यवाड मा कसरोम माद सभास्थान कट्टीईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","दानईच्चागा येशुड वारबरोबर दावाला नेडस्केन हो आन वाड ईल्लनेळ सना धुराम लेकुन्या, वाड्ये हा शताधिपतीलद् मित्रलक वानदैगारा आमशी आन्या, प्रभु, मीर त्रास शेशी तुस्कुणाकना, कारण मीर ना ईल्लक दाबेक आनकेन ईळा नीन योग्य लेन. ");
INSERT INTO wbq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","आनकेन मिदैगारा वचानक नाक योग्य मानाशेले, परंतु मीर फक्त शब्दाम माट्लाडना, आंटे ना सेवक बागा आयी. ");
INSERT INTO wbq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","कारण नीनपण उन्गोर अधिकारकिंदा ऊंडीनोड मनशी ऊंडी ना शेइ किंदा शिपायाल्ल ऊंडार; आन वनीक नीन आंटाड हो, आंटे वाड फोताड आन दुसरावरक दा आंटाड, आंटे वाड वस्ताड अन ना दासक आंटाड, ईदी शेई आंटे वाड आदी शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","येपुड येशुड आदी ईन्या आप्पुड वानिक वानविषयी आश्चर्य वाटाशा, वाड वान येंनका वंचेय घोळकाक वळाशी आन्या, “निन मिक शप्पतान, ईन्ता विश्वास नाक इस्त्राईल ला देखील कंपीयाले.” ");
INSERT INTO wbq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","आन यवार आमशिनीर, वार ईल्लक व्हईर, आप्पुड वारीक कंपीशा की, वाड सेवक बागा आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","आन दुसरा दिनामला ईळा आय्या की, वाड नाईन व्हेरद उरला येळीन्या आन वान सना शिष्यल् आन व्हेदा घोळका ईदी वानबरोबर होतुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","यळा वाड उर दैगारा वच्चीन्या आप्पुड सुडना यवार वगाड सच्चीनोड मनशिन बुडशांक येतकेन यळीनीर. वाड मना आम्माक वगाडे कोडकु ऊंड्या आन आदी विधवा ऊंड्या; आन ऊरलोंट्योर सना मंदी दानबरोबर ऊंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","आप्पुड दानिक सूशी प्रभुनक दान्द कळवळा वच्चा आन वाड दानिक आन्या “यडवाक” ");
INSERT INTO wbq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","आन्ट्यागा दैगारा व्हई वाड तिरडीक स्पर्श शेशा; आप्पुड खांदा ईच्चेतोर स्थिर निळा व्हडीर आन वाड आन्या, “मोगाबीडा, नीन निक शप्पतान, लैई!” ");
INSERT INTO wbq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","आन वाड सच्चीनोड लेशी कुसन्या आन माटलादेंक आन्ट्या; आन येशुड वानिक वान आमम्मादेग्गारा ईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","आप्पुड आंदारक येरपु आय्या आन वार द्यावारक गौरव ईच्ची आनिर, “मादांटल्ल्या व्हेदा संदेष्टा उदयासक वंचिनाड आन द्यावार मना मंदिद भेट तुस्कुनीनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","येशुन विषयी ईदी बातमी हांता यहूदीया प्रांतला आन सभोतालद् परिसरला पसराशा. ");
INSERT INTO wbq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","बतीस्मा इचा वाड योहानक शिष्यल व्हई आंता मटल शैप्पीर, ");
INSERT INTO wbq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","आन्ट्यागा बतीस्मा इचा वाड योहान मना रोंन्ड शिष्यलक व्हीलच्च्या आन वाड वारिक प्रभुं दैगारा आडगदेंक आमशा की, यवाड वंच्चेतोड ख्रिस्त वाड नुव्वे ऊंडाव की मीम दुसरावरद् दावा सुशेद? ");
INSERT INTO wbq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","येपुड हा मंदी वानदैगारा वच्चीर, वार आनीर, “बाप्तिस्मा शेशेतोड योहान माक निदैगारा ईदी आडगदेंक आमशिनाड की, यवाड वच्चेतोड ख्रिस्त वाड नुव्वे ऊंडाव येम मीम दुसरावंद दावा सुशेद?” ");
INSERT INTO wbq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","हाच घटकाला येशुड सना मंदिद रोगाम, बिमारी बागा शेशा, सना मंदी लोंद दुष्ट आत्मा तिशा, गूड्योरक कन्डल्ल ईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","येशुड वारीक उत्तर ईच्चा, “होंडा आनमीर यम ईनीनार आदी योहानक शेप्पना, गुड्योर सुस्तार, लंगड्याल नेडस्तार, कुष्ठरोगी शुद्ध आतार, बहिर्याल ईन्टार, सच्चीनोर जीवंत शेशस्तार आन गरीब मंदी सुवार्ता ईन्टार. ");
INSERT INTO wbq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","आन यवाड नाविषयी आडखळाशेले वाड धन्य.” ");
INSERT INTO wbq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","आन्ट्यागा योहानद निरोप फैईनंका वाड योहानविषयी समुदायसंगा माटलाडदेंक आंन्ट्या, “मिर येम सुस्देन्क बैट्या शेलाला फईनटीर? गालिगोन हालशीनद् बोरु यम? ");
INSERT INTO wbq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","तर मीर येम सुशाक बैटीक फईन्टीर? मऊ बंटाल यस्कुनीन्योड मनशी यम? सूडना, भडक बंटाल येस्कुनीन्योर आन चैनीला ऊंडीनोर मदी राजवाडाला उंटार. ");
INSERT INTO wbq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","तर मीर येम सुज्जेग बैटीक फैन्टीर? संदेष्ट्याल् क येम हा, नीन मीक शप्पतान, संदेष्ट्याल् गोन पण यवाड श्रेष्ठ फेदावड उंडाळ वानिक. ");
INSERT INTO wbq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","सूड, ‘नीन ना दुतनी नी मुंदरा आमस्तान वाड नी मुंदरा फी नीद दावा तयार शेशी,’ इळा वान बद्दल ग्रथलाराशिंद उंडाद वाड इडे उन्डाड. ");
INSERT INTO wbq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","नीन मीक शप्पतान कि आनंती तीकनोळ यवाड जन्मास्ताड वान्ता योहान पेक्षा फेदावड इळा यवाड लेद, तर द्यावार राज्याला यवाड अगदी शिनावाड उंडाळ, वाड वार गन्टा फेदावड उंडाळ.” ");
INSERT INTO wbq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","इंका जकातदार संगा आंता मंदी इनीगास 'द्यावारक न्याय उन्डाद' इळा अन्टार इंका वार योहानद बाप्तिस्मा तीस्कुनडीर. ");
INSERT INTO wbq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","पण परुशी नियमशास्त्रान्द शिक्षक इर वान तीक्नोळ बाप्तिस्मा न तुस्कूटा मना देगार द्यावारदी योजना तीस्कुनालेद. ");
INSERT INTO wbq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","प्रभूड आन्या, “तर इंगा नीन इ पिढीक मंदीक याद उपमा इतून? इंका आधी यवार लेका उन्डाद? ");
INSERT INTO wbq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","या मोग्बिळलु संताला कुसनी ओगार मेगार की कुते स्तार वारलेख आदी उंडाद, इळा अंन्टार, मिम मि इच्चाका फेटालिद हलगी वाजास्तिम तरी मीर नाचाशीतोर लेद, मिम मयेत द विलाप फदुल आंटीम तर मीर येडवा लेद. ");
INSERT INTO wbq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","यळा कि बाप्तिस्मा शेस्तोड योहान रोट्ट्या न तीनटा इन्का द्राक्षीरस न ताकता वच्चीनोड उन्डाड आनकेन मीर आंटार, वानिक दैयाम आंन्टीद उन्डाद. ");
INSERT INTO wbq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मन्शीद कोडकु तिनी तागी वच्ची नोड उंडाळ इंका मीर आंटार, सूड, इड खादाड आरवा व दारूडोड जकातदार न्द व उनगो पाप्योड मित्र! ");
INSERT INTO wbq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पण ज्ञान मनाक आंता बिळातीगोन न्याय ठरवाशिंद उन्डाद.” ");
INSERT INTO wbq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","आप्पुड परुश्यांपेकी यवाड वगाड, “नू ना बरोबर तिनाबेक.” इळा येशु क विनंती शेषा. आंटे वार परुश्याकडा इटल्या व्हइ तिनदेन कुसण्या. ");
INSERT INTO wbq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","इंका सूड, यवाडवगाड पापी आरवती आ नगर उंड्या; येशु परुश्याकडा इनटल्या तिनदेन कुसनीनोड उंडाळ इदी इनी वाड गहुल नुन्या अलबास्त्र कुपी यतका वच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","इंका आदी यन्का वानकडा काळा द्यग्गारा येडस्केन नीलाफडी कन्यळगोन वानिक काळ नानस्देन्क आंन्ट्या व आधी तना नतीद यन्टकालगोन तुडशी, वान कालाद शना मुकाल तीस्कुन्या व वार्की सुगंधी नुन्या आंच्या. ");
INSERT INTO wbq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","आप्पुड या परुशाड येशुन फिलच्चीनुड उंड्या, वाड इदी सुशीगास स्वतः मन दिंटल्या, आन्या “वाड संदेष्टा तर उन्टे आ आरवती वारीक द्यग्गारा. शेशिंद उंडाद आधी यवार व यवारद यळा प्रकारद उन्डाद, आंटे आधी पापी उन्डाद, इदी वारीक तेलचींद उन्डाद.” ");
INSERT INTO wbq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","आप्पुड येशुड वारीक उत्तर इच्चीगास आन्या, “शिमोन, आन्या नी संगा नीन येम तरी माटलाडतोन उन्डान.” आप्पुड वाड आन्या, “गुरुजी माटलाड.” ");
INSERT INTO wbq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","येशुड आन्या, “वगा सावकरड इद्दार कर्जदाराल उन्डीर; वगांता चांदी पाचशे नाणल व उन्गोन ता वंग याबय इळा. ");
INSERT INTO wbq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","पण कर्ज फेडाशेक वारद्यग्गारा येम लेकुंड्या आनकेन वाड इद्दार्क क्षमाशेशा. तर वारनुट यवाड वानमिन्दा सना प्रीती शेशाव्हाट?” ");
INSERT INTO wbq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","आप्पुड शिमोनाड उत्तर इच्चीगेस आन्या, “यवारक सना माफ शेशावाड, इळा नाक वाटास्ताद.” इंगा येशुड वान्क आन्या, “बागा ठरवाशिणाव.” ");
INSERT INTO wbq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","आप्पुड वाड आ आरवतीकडा वळाशीगेस शिमोनान्क आन्या “इदी आरवती निक कमस्ताद यम? नीन नी इटल्या वस्तीन, नु ना काळाइच्चाका नेळ इय्या लेद; पण इदी यडशीगेस ना काळ भिजवाशा इंका मना यंडकाळगुना आदी तुडशा. ");
INSERT INTO wbq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","नू ना स्वागत कस्रोम मुका तुकस्कूण्या लेद, परंतु नीन न्वाना वच्चानुट इदी नाद काळाद मुके तीस्कुनेद थाबवाशा लेद, ");
INSERT INTO wbq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","नू नाद नतिक नुन्या आंची नाद स्वागत शया लेद परंतु इदी नाद काळाक सुगंधी नुन्या आंच्या. ");
INSERT INTO wbq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","या कारण इच्चाका नीन निक शेपतान, दान्द जी सना पापुल वान्द क्षमा आइनेद उन्डाद; आंका इदी सना प्रीती शेशा; यावर्क रवा दान्दे क्षमा अवताद वार रवाने प्रीती शेस्ताड.” ");
INSERT INTO wbq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","आप्पुड येशुड दानिक आन्या, “नी पाप क्षमा आय्येनाद.” ");
INSERT INTO wbq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","आंटे वान बरोबर तिनदेन कुसनीडीर वार आपस. ला आंदेन आंटीर, “पापुलदबी क्षमा शेशातोड इडे यवार उंडाळ?” ");
INSERT INTO wbq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","इंगा वाड आ आंडीदान आन्या, “विश्वासगों निक ताराशिंदी उंडाद, शांतीता फो.” ");
INSERT INTO wbq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","आंन्टेका वार लगाना इळा आय्या कि, येशु उपदेश शेस्ताड व परमेश्वर राज्याद सुवार्ता शपतुन्ड्या नगरीनगरला उरू-ऊर तिरगत उंड्या, आप्पुड वाड बारा शिष्युल वानसंगा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","दुष्ट आत्माल व नपूल द्यग्गार नुट मुक्त शेशीनिव इळा यंता तरी आन्डेर वानसंगा उंड्या, आंटे मग्दालिया उरुद मरीये नुट योड द्ययाल यळइड्या, आधी, ");
INSERT INTO wbq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","राजा हेरोदाद कारभाऱ्याड खुजा वानीद वडती योहान्ना आळेच सुसान्ना व इप्पुड संगेम आंडेर, इदी मनाद द्रव्य गोन वानदी सेवा शेयदुर. ");
INSERT INTO wbq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","इंका व्हदाद समुदाय वगातडा कुडइनडीर ऊरऊर मंदी वानद्यग्गारा वस्तू उंडीर वाड दाखला इच्चीर आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“पेराशीतोड मनाद बिजनाम इसदेन इळीइन्ड्या; इंका वार पेराशेद आप्पुड यम बिजनाम दावामिन्दा व्हड्या इंका वाड तोक्या व आकाशातील गुआल आदी तिने कुकीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","इंका यम खडकाळ राई मिंदा मंदा व्हड्या इंका आय्यी हुटीनिव यन्डी हो, आंटे दाटल्या व्हच्चीद लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","इंका येम मूडलामिन्दा माकुलझुडपूल बराबर वाढाशी वारीव वाढ खुंटाशा. ");
INSERT INTO wbq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","इंका यम मन्ची भुमीमिंदा व्हड्या इंका वाड फुटीगेस वानिक नूरपट फनटा वच्ची.” इळा आनी वाड बैग्या कीरली आन्या, “वानिक इनदेन्क गुम्माल उन्डाय वाड आय्कायांडा.” ");
INSERT INTO wbq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","आप्पुड वान शिष्याड आप्पुड वाड आडग्गा, दाखल्याद अर्थ येम उन्डाद? ");
INSERT INTO wbq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","आंटे येशु आन्या, “परमेश्वर राज्यालोन गुजाल जाणाशी देणगी मिक इच्चीम, टीम आंन्टेगा मंदीमंदीला आदी दाखलाशी शप्पीमटीम, दिनइच्चाका वानिक कुमस्तूउंड्या सुडाराद व वाड इनटू उंड्या तलवारद. ");
INSERT INTO wbq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","तर आदी दाखला इदी उन्डाद बोजनाम इदी परमेश्वर द वचनाम उन्डाद. ");
INSERT INTO wbq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","इंन्का इप्पुड दावामिंदुडद वाड इनातुर उनडार, इंन्का आंन्टेका सैतानानूड वस्ताड इंन्का वाड इस्वास व्हटी तारण सुडाराद आनकेन वान अंत:करणातुन वचन तिशीर तीस्कूणार. ");
INSERT INTO wbq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","इंन्का जो खडकामिंदाइर उंडार की, वार इन्टार आप्पुड वचनाल आंनदाने तिस्कूनटार, इंन्का वारीक मुळानुट लेकुंड्याद; आप्पुड आदीयम यळादणका इश्वास व्हटटतार व परिक्षेला यळाला गळाशी फडताय. ");
INSERT INTO wbq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","इंका काटेरीला माक ला फडीनीव बीजनाम इन्यातोर उंटीम, पण मुन्दारा फोता-फोता चिंता इंगा धन इंगा इ जीवनालोद सुखुम वार गुदमारशी फोतार इंगा भरदार फळुल इयाव. ");
INSERT INTO wbq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","पण बागा भुमीमिंदा फडीणी बीजाल आवी ईवी ऊंडाय, की वार वचन ईनी बागा मंची अंतकरणला घट्ट शेशी व्हेटताद आन धीरामगोन धान्याम ईचकेन होतात. ");
INSERT INTO wbq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","आन येवार दिवा आंचीनेंका भांडालकिंदा मुशी व्हेटेले किंवा पलंग किंदा व्हेटेले तर नवनीक वंचेतोरक यलगु कंपीया बेक आनकेन आदी फईक फेटताम. ");
INSERT INTO wbq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","कारण प्रकट आय्येद लेद ईळा येम मुशीनद लेद किंवा तेलचेद लेद आन कंप्पीयाक व्हय्येदकाद इळा येम गुप्त लेद. ");
INSERT INTO wbq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","आनकेन मीर येळा ईनटार दानविषयी जपस्केन उंडना, कारण यवार दैगारा ऊंडाद वारीक ईच्चार आन यवार दैगारा लेद ईला की रवा उन्डाद वानिक वाटासताद वारद येम ऊंडाद आदी पण वानतिकेड तुस्कुण्यार.” ");
INSERT INTO wbq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","आप्पुड येशु द आम्मा इंगा तंमुड वानदैगारा वंचिर आन गर्दी गोन वारीक वानदैगारा व्हयदेक दावाले. ");
INSERT INTO wbq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","आप्पुड येवार वानिक शप्पीर, नी आम्मा शीना तंमुडल नीक भेटाशेंक बैट्या नीलाफडीनार. ");
INSERT INTO wbq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","आन वाड वारीक उत्तर ईची आन्या, “द्यावार वचन ईनेतोर व पाळाशेतोर इर ना आम्मा इंगा शीना तंमुडल.” ");
INSERT INTO wbq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","आन हा दिवसला ईळा आय्या की, वाड मना शिष्यल् बरोबर नावला कुस्नीन्या आन “मनाम सरोवर मुंदारा फोदाम” ईळा वाड वारीक आन्या आन वार नाव तोलीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","आन्ट्यागा वार नाव तोलेतापुड येशुड फंड्या. आन सरोवर ला घालिद वादळ ईड्या आन नाव नेळागोन निंड्या आन वार संकट ला फडीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","आप्पुड वार वानदैगारा वची वानिक जागा शेशी आनिर, गुरुजी, मनाम बुडाजेग आन्टीनाम. आप्पुड वाड नीदारनेळ लेशी घालीक आन खवळाशिन नेळाख ताकिद शेशा; आन आदी बंद आय्यी शांत आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","आप्पुड वाड वारिक आडग्या, “मिद विश्वास यकाडा ऊंडाद?” आन वार यरस्केन थक्क ऐईर आन वगामेगारक आनिर, वीड ऊंडाड तरी यवाड? की, घाली आन नेळ वीरीक आज्ञा ईस्काड आन वार विनदी ईनटार. ");
INSERT INTO wbq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","आन्ट्यागा येशु इंगा वान शिशाल गलील सरोवर मुंदारा गरसेकर प्रदेश ला पोहचाशिर. ");
INSERT INTO wbq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","आन वाड भुमी मिंदा दिग्या, आप्पुड उरलोन्ट्योड यवाड वगाड मंनशी वानीक भेटाशा; वानिक सना धैय्याम, आंन्टीन्या आन वाड सना वर्षे ल बंटाल येस्कुना लेकुन्या आन वाड ईन्ट्या निलवा कुन्या वाड थडग्यालमिंदा नीलस्तुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","आप्पुड वाड येशु नक सूशी सना किरल्या आन वानमुंदारा फडी बेग्याता आन्या, हे येशु, परात्पर परमेश्वर बिडा, नाद नीद येम संबंध? निन नीक विनंती शेस्तान, नाक त्रास ईय्याक. ");
INSERT INTO wbq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","येनटीक की वाड इ अशुद्ध आत्माक हा मनषीनेळ यळी फैयेद आज्ञा ईस्तुन्या; कारण वाड वानिक सना दमुल फेटीन्या; आन मंदि वानिक पहारामिंदा फेटी साखळ्यानगोन आन बेड्यालगोन कट्टूतूनीर पण वाड आवी बंधनलु तेंम्पी धैय्यामतिकेळ शेलाला हाकलाशी होतूण्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","आन येशुड वानीक आडग्या, “नी फेर येम?” आप्पुड वाड आन्या, सेन्य, कारण वानदांटल्या संगनेम दयामलू घुसाशिन्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","आन नु माक अगाधकुपला व्हयेद आज्ञा शेशेद लेद, इळा आदी दैयाम विनंती शेसतू उनड्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","आप्पुड आदू पुष्कळ फनदुलात कळप कोडा मिन्दा मेस्तून उड्या; इंका दान मिन्दा सोरशा वाड मनाख परवानगी इन्डा, वार विनंती शेशीर. आंटे वाड वारक परवानगी इच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","आप्पुड आदी दैयाम आ मनशी मिन्दुड येळी आदी फमदुलाला शिराशा इंगा वाड कळप कडामिन्दुडधडक व्हारकेन व्हई किन्दा सरोवराला व्हड्या व गुदमारशी मरणपावाश्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","मग कळप मिन्दुडी जे आय्या आदी सुशी व्हारीर व वार आन्द नगरला व शेयलाला व्हई शप्पीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","आप्पुड इदी आय्या आदि सुसदेन्क वार मिन्दा बयट्या येळीर इंगा येशु द्ग्गारा वच्चीर इंका आ मन्शिनोट दैयाम येळीनिव उन्डया वाड वस्त्र कपकुड्या व शुद्धीमिन्दा वच्चीड्या इळा येशुन्द काळा द्ग्गारा कूसनिन्द वारीक आढळाशा; इंगा वार येस्कुनीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","इंगा यवार इदी सुशीन्द उन्डया वार वानिक भूतग्रस्त येळा बागा आय्या इदी वारीक शप्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","आप्पुड गरसेकराथ नालुग भागानुट आंता मदी वारक विनंती शेशीर की नू मादग्गारानुट फो कारण वार व्हेदाद भायगोन व्याप्त आइ नीर. मग वाड जहाजला कुसनी यंका वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","इंका आदी मन्शिनोट दैयाम फइन उन्डया, वानबरबर निलवान इच्चेद इळा येशु दग्गारा विनंती शेशेन्द उनडीर परंतु वाड वान्क निरोप इच्ची आन्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“नु मना इल्लक यन्काक हो व परमेश्वर नीइच्चाका यन्ता व्हेदाद व्हनी शेशा आदी शेप.” मग वाड यळी येशुड वानइच्चाका आंता व्हेदाद फनी शेशिन्द उनडीर वार वाड संबंधनगरानुट घोषीत शस्केन हो. ");
INSERT INTO wbq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","नंतर येशुड यन्का वचीनेन्का समुदयाने वारीख आनंदाने स्वीकारशीर, कारण वार आंदार वान्द दावा सुसतून उन्डया. ");
INSERT INTO wbq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","आप्पुड सूड, याइर व्हेरद यवार मनशी वच्चा; वाड इंगा यहुदी सभास्थानाला अधिकारी उनडया; इंका वाड येशुन्द काळाममोकी, नु ना इल्लुक वच्चेद, इळा वान्क विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","आंका वानिक सुमोर बारा यडलुद एकुलती वगा आडबीदा उनड्या व आदी सच्चीदेन्क टेकाशिन्द उन्डया. आंटे वाड होताड आप्पुड लोकसमुदाय वानदग्गारा दाटी शेशतूण्डया. ");
INSERT INTO wbq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","इंका बारा यडलुद रक्तस्त्राव आईन्द उन्डीर यवार वगा आरवाती, आदी (मनाद आंता उपजिविकता वैद्या मिन्दा खर्च येशी) यवार द्ग्गार नुटबी बागा आवाद, ");
INSERT INTO wbq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","आदी वाद येन्का वच्ची वान्द बडटलद काटाला स्पर्श शेशा इंका लगाना दान्द रक्तस्त्राव बंद आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","इंका येशु आन्या, “नाक यवार स्पर्श शेशीर?” आप्पुड आंदार नाकरास्केन उन्डीर पेत्र व वार वानबराबर उन्डीर वार वान्क आनीर हे गुरुजी समुदाय गर्दीशेशकेन्द मिरक चेंगरास उन्डया. ");
INSERT INTO wbq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","आप्पुड येशु आन्या, “यवराणा नाकस्पर्श शेशीर कारण नातिकनोळ सामर्थ्या यळ्या इदी नाक तेलच्या.” ");
INSERT INTO wbq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","इंका आदी आरवातीमिम, तप्पाका नीलावा लेद इळा सुशी, थरथर कांपास्केन वच्चा इंका वान मुदारा बोरकालका फडी नीन याद कारण इच्चाका स्पर्श सेशा व लगाना मनाम यळा बागा आतिम, इदी आदी आंता मंदी मुदारा शेप्या. ");
INSERT INTO wbq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","आप्पुड येशु दानिक आन्या, “आन्बीडा, नीद ईश्वसगोन निक तारा शिन्द उनडाद. शांतीगोन हो.” ");
INSERT INTO wbq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","वाड इंका माटलाडस्केन उनडाद इनताला सभास्थानाला अधिकारी आदनुट यवार वच्चा व आन्या. नी आनबिडा सच्चीनाद; गुरूजींनक यींक्का त्रास ईयांकना. ");
INSERT INTO wbq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","पण येशुड आदी ईनी उत्तर ईच्चा, “यरस्कुनाक, विश्वास फक्त व्हेट, आंटे दानिक बेस आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","आंन्ट्यागा ईनट्ल्या वंचिन्नका पेत्र, योहान, याकोब आन आनबिडागार आब्बाड, दान आम्मा विर शिवाय नौना यवारकच दानी इय्याले. ");
INSERT INTO wbq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","आन आंदार दानईच्चागा येडशीगेन शोक शेश्तुनीर, पण वाड आन्या, “येडवाकना, कारण आदी सयालेद, निद्दारला ऊंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","आदी सच्चींनद ऊंडाद ईदी सुशी वार नगदेंग आंटीर. ");
INSERT INTO wbq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पण वाड दांदी शेइ शेतल्या तुस्केन आवाज ईच्ची आन्या, “आनबिडा, लैई.” ");
INSERT INTO wbq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","आपूड दान आत्मा परत वच्चा आनी आदी लैशा; दानिक तिनदेंक ईना आनकेन आज्ञा ईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","आन दान आब्बाड आम्माक आश्चर्य आय्या; परंतु येम आईनेद यवारक् शप्पाकना ईळा ताकीत शप्पी ईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","आन्ट्यागा वाड बारा शिष्यक ओगातडा फिलची वारीक आंता दैयाममिंदा आन रोग बागा शेजेंग, सामर्थ्य, अधिकार ईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","आन वाड वारीक द्यावार राज्यविषयी संदेश शप्पेईच्चागा आन रोगामक् बागा शेज्जेग आमशा. ");
INSERT INTO wbq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","वाड वारीक आन्या, “दावाईच्चागा येम तुसकुनाकना; कट्या किंवा झोळी किंवा रोंट्या किंवा दुड्लु आन रोन्डं, रोन्डं बट्टाल् तुसकुनाकना. ");
INSERT INTO wbq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","आन या पण इंटल्यामीर फोयार, आंदे निलूना आन आंदेळेले फोंडा. ");
INSERT INTO wbq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","यंता मंदी मीक दैगारा तुसकुनार आंतामंदिविरुध्द साक्ष काबेक आंका मीर हा ऊरणेळ येळेतापूड मना कालद् धुळ झटकायना.” ");
INSERT INTO wbq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","आप्पुड वार यळीर आन हांता ठिकाणी वचन शपकेन आन रोग बागा शेशकेन तिरगकेश फोईर. ");
INSERT INTO wbq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","घडास्का उंडीने आन्नी माटलु हेरोद राजा ईनीनंका सना घोटाळला फड्या, कारण बाप्तिस्मा इचा वाड “योहान सचैदांटलेळ लेशीनाड.” ईळा सना जण आन्टुनीर; ");
INSERT INTO wbq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","अन सना जण आन्टुनीर “एलीयाड प्रकट ऐनाड” आन उनगोर ओर आनटुनीर “पेईलाटोर संदेष्ट्याल्योंटोर यवार वगाड लेशीनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","आप्पुड हेरोद आन्या, बतीस्मा इचा वाड “योहानद नेत्ती नीन तेम्पतीन, पण यवारईच्चागा नीन ईदी कता ईनटान वाड यवार उंडाव?” आन वाड वानिक भेटादेंक सुस्तुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","यंकसार प्रेषित तोर वापस वच्ची मनाम येम शेशिनाम आदी-आदी येशु क सविस्तर शेप्पीर. मग वाड वारक संगातीस्कीनगेस बेथसैदा फेरदी उरकडा वगातिकड फोया. ");
INSERT INTO wbq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","परंतु दिनबद्दल मंदी ईनीनकास वार वानयेनका फोईर. आप्पून वाड वारद् स्वागत शेशी वारसंगा परमेश्वर राज्याविषयी माट्लादेंक आन्ट्या आन येवारक बागा आय्येद गरज ऊंड्या वारीक वाड बागा शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","दिवस संपास्का वच्चा, आप्पून बारा जण देग्गारा वच्ची आनीर, “ही समुदायीक निरोप यी, आंटे इकानोळ आकानोळ उरुक दिगी तिनदेंक सोय शेशार; कारण मनाम ईंद् रानमाळ ठिकाणला ऊंडाम.” ");
INSERT INTO wbq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","पण वाड वारीक आन्या, “मिरच वारीक तिनदेंक ईना.” वार आनीर “मिम फोई मंदिईच्चागा वंन्टा कोनकेन दाले, तर आय्यीद रोट्यांल आन रोंन्ड मील दानशिवाय मादैगारा येम लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","कारण वार जवळपास आय्यीद हजार मोगोर ऊंडीर. आप्पुड वाड मना शिष्यालक शप्प्या, “पन्नास-पन्नास जणद पंगत शेशी वारीक कुसनामंतना,” ");
INSERT INTO wbq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","आन वाड शप्पीनळा शेशी आंदारक कुसनामत्तीर. ");
INSERT INTO wbq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","वाड आवी आय्यीद रोट्याल आन रोंन्ड मील तुस्कुण्या आन व्हईक स्वर्ग तिक सुशी दानिक आशिर्वाद ईच्चा आन दानी तुकडाल शेशी आवी मंदी घोळकाक सदरदैक शिष्यल् दैगारा ईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","आप्पुड वार आंदार तिनी तृप्त आय्यीर; आन वार तैमपीनी रोट्याल तू कडाल मिगल्या आवी बारा फुटकाल निंडा वार तुस्कुनीर. ");
INSERT INTO wbq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","आन ईळा आय्या की वाड एकांतला प्रार्थना शेशेतापूड शिष्यल् वानबरोबर ऊंडीर, आप्पुड वाड वारीक आडगी आन्या, “मंदी समुदाय नाक यवार आनकेन आंटार?” ");
INSERT INTO wbq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","आन्ट्यागा वार उत्तर ईच्ची आनिर, “बाप्तिस्मा शेशेतोड योहान, पण सनाजन आंटार ‘एलीया,’ सनाजन आंटार की, पूरातन संदेष्ट्याल्योंटोर यवार वगाड परत लेशीनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","वाड वारीक आन्या, “पण मीर नाक यवार आनकेन अंन्टार?” आप्पुड पेत्रड उत्तर ईच्ची आन्या, “द्यावारद ख्रिस्त.” ");
INSERT INTO wbq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","पण ईदी यवारक शप्पाकना ईळा वाड वारीक निक्षाशी आज्ञा ईच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","आन आन्या, “मनशी कोडकु सना दु:खल सोसायाबेक आन आब्बाड, मुख्य याजक मंदी, नियमशास्त्र शिक्षक वारतिकेळ नाकाराशी फोबेक आन जेमगोन मतेयाबेक आन तिसरा दिनामला पुन्हा लेशीर फोबेक, दीनद् आगत्य ऊंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","आन वाड आंदारक् आन्या, “जर यवार नायेनका वच्चेद ईच्छा ऊंन्ड्या तर वाड स्वतः क नाकरायाबेक आन दीन्नाम मनाद वधस्तंभ येत्ती तुस्कुनाबेक आन नायेनका नेडवाला. ");
INSERT INTO wbq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","कारण यवाडपण मनाद जेम वाचवाशी वाड दानिक गमवाशी, परंतु यवाड पण नाईच्चागा मनाद जेम होनीईच्ची वाड दानिक वाचवाशी. ");
INSERT INTO wbq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","कारण मनशी आंता दुन्याम मिळवाशी स्वतः क गमवाशा किंवा स्वतः द नाश शेशी तुस्कुण्या तर वानिक येम फायदा आयी? ");
INSERT INTO wbq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","यवाड पण नाविषयीद आन वचनविषयी शीगु फटी वारविषयीपण शिगु मनशी कोडकु येपुन मना स्वतः, आब्बानद, पवित्र दूत लाद गौरवगोन वच्ची आप्पुड व्हट्टी. ");
INSERT INTO wbq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","आन नीन मीक खरेम शप्पतान की, ईन्द नीला व्हडीनोर दांटल्या ईळा ऊंडार की, वार द्यावारद राज्य सुशार तोपर्यत वारीक सच्चेद अनुभव दाकच व्हेई.” ");
INSERT INTO wbq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","आन ही गोष्टी ल् शप्पीन्यंका सुमारे आठ दिनामगोन ईळा आय्या की, पेत्र इंगा योहान इंगा याकोब वीरीक तुस्कुनी वाड कोंडामींदा प्रार्थना शेशेग हो. ");
INSERT INTO wbq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","आप्पुड वाड प्रार्थना शेशेतापुड वानद मुतीद रुप पालाटाशा आन वानी बट्टाल तैलागा शुभ्र लखलखीत आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","आन सुडना, ईद्दार मोगोर वानसंगा माट्लातूनीर; वार मोशे आन एलीया ऊंड्या, ");
INSERT INTO wbq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","वार तेजस्वी कंपीस्तुनीर आन येम वानद प्रयाण वाड येरुसलेम शहरला पूर्ण शेशेतोड ऊंड्या, हा विषयी वार माट्लातुनीर ");
INSERT INTO wbq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","आप्पुड पेत्र आन वानबरोबर यवार ऊंडीर वार निद्दारगोन भारवाशी उन्ड्या, परंतु वार पूर्णपणे जागा ऐईर आप्पुड वारद् तेज आन वार ईद्दार मोगोर वानदैगारा निला फडींद वार सुशीर. ");
INSERT INTO wbq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","आन यिळा आय्या की आदी वानतिकेड दुराम आयेतापुड पेत्रड येशुन आन्या, “हे गुरु, यिंद ऊंडदेग माक बेस ऊंडाद; तर मीम मुड मंडप ल् शेशस्ताम, निच्चागा, मोशेन ईच्चागा, एलीया ईच्चागा.” मनाम येम माट्लाताम आदी वानीक भानाम लेकुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","वाड ईदी कता माटलाडेतापुड वगा मोडाम वच्ची वारमिंदा साट शेज्जेग आन्ट्या आन आदी मोडामला दाशा आप्पुड वार येरस्कुनीर. ");
INSERT INTO wbq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","आन मोडामनेळ आवाज आय्या, आदी आन्या, “वाड ना नीवडाशिन्योड कोडकु ऊंडाड, वींद मीर यीनांडा.” ");
INSERT INTO wbq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","इदी आवाज आयनेंका येशुड वगाडे कमशा आन वार गप्प निलच्चीर आन या गोष्टील वार सुशिनी ऊंडीर दांल्टोनी येमच वार हा दिवसला यवारक शप्पालेद. ");
INSERT INTO wbq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","आन यीळा आय्या की दुसर्या दिनामला वार कोंडामींदुट किंदा वंचिनैका फेद्दाद मंदिद घोळका वारीक भेटाशा. ");
INSERT INTO wbq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","आप्पुड सुडना, घोळका लोंल्ट्योड वगा आरवा जोरात कीरली आन्या, हे गुरु, नीन नीक विनंती शेस्तान, ना मोगाबीडा तीक सुडना, कारण वाड ना वगाडे बिडा उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","आन सुडना, या आत्मा वानिक व्हटताद आन विड अचानक किर्लताड, यंकसार वाड वानिक यिळा व्हिन्डताड की, वान मुतीक फेसाम् वस्ताद, वाड वानिक सना त्रास यिस्ताड आन वानिक व्हेदा प्रयत्नगोन यिडशी होताद. ");
INSERT INTO wbq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","आन आदी येळाबेक आंका नीन नी शिष्यल्क विनंती शेस्तीन, परंतु वारतिकेळ यळाले. ");
INSERT INTO wbq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","आप्पुड येशुड उत्तर यीच्ची आन्या, “हे विश्वासहीन आन भाटकाशिंद पिढी, नीन येपुड पर्यंत मि बरोबर निल्लजन आन मीद सहन शेज्जन? नू नी मोगाबीडाक ईकाडा येत्ता.” ");
INSERT INTO wbq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","आप्पुड वाड दैगारा वच्चेतापुड, आंतादांट्ल्या धैय्याम वानिक किंदा आपटाशा आन भारी व्हिन्डी येशा, पण येशुड हा अशुद्ध आत्माक दम यीच्चा आन मोगाबीडाक बागा शेशी वान आब्बांनदैगारा परत यीच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","आन्ट्यागा द्यावारद ईदी महान सामर्थ सुशी आंदार मंदीक आश्चर्य ऐइर आन वाड आवी येम फनील शेस्तुन्या हा आन्तादान्ट्ल्या आंतामंदी आश्चर्य शेस्तुनीर आप्पुड वाड मना शिष्यल्क आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“इवी माटाल् मीर ध्यानामला फेटना कारण मनशी कोडकुक मन्दीशेट्ल्या यीचेतोर ऊंडार.” ");
INSERT INTO wbq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पण इवी माटाल वारीक तेलवाले आन वारीक तेलवा वद्दो आनकेन आवी वारदैगारनेळ गूप्त राखाशिनी ऊंड्या; आन वार इदी माट्लादेंक वार वानिक आडगदैक येरस्कुतुनीर. ");
INSERT INTO wbq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","आन्ट्यागा मनादान्ट्या यवार फेदावोड ऊंडार दानविषयी वारदांट्ल्या वादविवाद नेडशिन्या. ");
INSERT INTO wbq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","आप्पुड येशुड वार मनसुलोंद माटा सुशी वगा बिडाकदैगारा तुस्केन वानिक मनादैगारा निला केडप्या, ");
INSERT INTO wbq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","आन वारीक आन्या, “यवार आदी ना फेरगोन यी बीडाक स्वीकारास्ताड वाड नाक स्विकारास्ताड आन यवाड नाक स्विकारास्ताड वाड यवाड नाक आमशीनाड वानद् स्विकार शेस्ताड; कारण मि आंदार दांट्ल्या यवाड आंदार' दांट्ल्याशिंनावड ऊंडाड वाडे फेदावड.” ");
INSERT INTO wbq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","आप्पुड योहान उत्तर इच्ची आन्या, “हे गुरु, मीम यवार ओगानक् धैय्याम तिशेतापुड सुस्तीम आन मीम वानिक लेद आंटीम. कारण वाड माबरोबर नी येंका नेडशेले.” ");
INSERT INTO wbq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","आप्पुड येशुड वारिक आन्या, “मना शैय्याकना, कारण यवार मीकविरोध लेर वार मीक अनुकूल ऊंडार.” ");
INSERT INTO wbq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","आन ईळा आय्या की वानिक फईक तुस्कुणेद व्हयेद वेळ दैगारा वंच्चा आप्पुड यरुशलेम उरुक फोयेद दृढनिश्चय गोन वाढ मनाद मुती वळवामत्या. ");
INSERT INTO wbq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","अपून वाड मना मुंदारा निरोप आमशा, आप्पुड वार येळी वान इच्यागा तयारी शेज्जेंग शोमरोन लोंद वगा ऊरला फोईर, ");
INSERT INTO wbq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पण वार वारीक स्वीकारा लेद, कारण येरुशलेम ऊरुक फोयेद वारद रोख ऊंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","आप्पुड वाण शिष्यल् याकोब आण योहान ईदी सुशी आनीर, “हे प्रभू, एलीयाड शेशीन्या आळे आकाश नेळ आग्गी फडी वानद् नाश, शैय्याबेक. आनकेन मीम आज्ञा शैय्याबेक, ईळा नीद इच्छा ऊंडाद येम?” ");
INSERT INTO wbq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","परंतु वाड वारीक दम ईच्ची आन्या, “मिर या आत्माद उंडार ईदी मीक येरका लेद येम; ");
INSERT INTO wbq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","कारण मनशी. कोडकु मनशी जेमद् नाश शैजैग लेद, तर वारीक उद्धार शेशेदेंक वचीनाड.” आंटे वार दुसरा उरक फोइर. ");
INSERT INTO wbq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","आन वार दावागोन नेडशेतापुड यवाड वागाड वारीक आन्या, “यंद यकाडा नु फोयाव आंद नीन नीयेंनका वंचान.” ");
INSERT INTO wbq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","आप्पुड येशुड वारीक आन्या, “खोकडास बोक्का आन आकाश लोंद पक्षालक् ईल्ल ऊंडाद, परंतु मनशी कोडकुक मना नैत्ती फटदेन्क ठिकाण लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","आन्ट्यागा वाड दुसरा वगानक आन्या, “ना येंनका दा,” परंतु वाड आन्या, “हे प्रभु, पहील्यांदा नाक व्हई ना आब्बांनक बुडशी दानी,” ");
INSERT INTO wbq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","आप्पुड येशुड वानिक आन्या, “सच्चीनोरक मना सच्चैदांटल्या बुडशी फोनी, परंतु नु व्हई द्यावार राज्याविषयी घोषणा शेई.” ");
INSERT INTO wbq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","आप्पुड इंगा वगाड आन्या, हे प्रभू, नीन नी येनका वंचान, परंतु पहिला नाक व्हई ना ईंटल्या यवार ऊंडार वारद् निरोप तुस्कुणान. ");
INSERT INTO wbq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","पण येशुड वानिक आन्या, “यवारपण नांगरक् मना शैई येशिन्यंका यंनकाड गोष्टीलतीक सूस्केन कुसुंटाड ईळा यवाडच् द्यावारद राज्यक उपयोगी लेड.” ");
INSERT INTO wbq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","आन्ट्यागा प्रभुड ईंगा सत्तर जणक् निवडाशी या-या उरला वाड स्वतः फोयेतोड ऊंड्या आंद यीद्दार ईळा वारीक मनामुंदारा आमशा. ");
INSERT INTO wbq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","वाड वारणी आन्या, “धान्याम, सना ऊंडाद परंतु व्हनी शेशेतोर कडमा ऊंडार, आंटे धान्याम द्यावारा मना धान्यामक् फन्योर आमसा बेक आनकेन मीर वानद् प्रार्थना शैईना.” ");
INSERT INTO wbq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","फोडा; सुडना, लांडगाल नडमा यळा मँका फिल्लाक् आमसाबेक आळा नीन मिक आमस्तान. ");
INSERT INTO wbq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","थैली किंवा झोळी किंवा शप्पुल तीस्कूनाक ना आन दावाला यवारक् दंडाम शैया कुंडा. ");
INSERT INTO wbq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","मीर यवारपण ईनटल्या व्हय्यार आंद पहिल्यांदा, ही इंटल्या शांती ऊंडान ईळा. आंडा. ");
INSERT INTO wbq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","जर आंद यवार शांतिप्रिय मनशी ऊंड्या तर मीद शांती वानमिंदा निलची; पण आदी लेकुन्या तर आदी मीतीक परत वस्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","मीर आद्दे ईंटल्या निलची वार येम ईच्चार आदी तीनंडा तागंडा फोंडा; कारण फन्योर मना मजुरीक योग्य ऊंडार; ईलु, ईलुक तिरगा कुंडा. ");
INSERT INTO wbq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","आन मीर यापण नगरला फोयार आन वार मीक स्विकारास्तार, दांटल्या वार येम मी मुंदारा वेटतार आदी तिंडा, ");
INSERT INTO wbq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","आन दांटल्या यवारद येम नस्तुंटे वारीक बागा शेईना आन वारीक शेपना, द्यावारद राज्य मी दैगारा वचीनार. ");
INSERT INTO wbq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","परंतु मीर यापण नगरला फोयार वार मीद स्वागत शैयाले तर बैट्या दावा मिंदा फोई ईळा आंडा, ");
INSERT INTO wbq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","मी नगरदी मनु मा कालक आंटीनाद आदी पण मीम मिविरुद्ध झाडशी येस्ताम; तरी ईदी तेलस्कोना की द्यावारदी राज्य दैगारा वचीनार. ");
INSERT INTO wbq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","नीन मीक शपतान की, हा दिनामला सदोमक हा नगर पेक्षा सोपा फोई. ");
INSERT INTO wbq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“हे खोराजिना, नीक हाय! हे बेथसैदा, नीक हाय कारण मीदांट्ल्या आवी सामर्थल फनील आताय आवी जर सोर आन सिदोन वीरदांटल्या आईंनी ऊंड्या तर वार येनका के फईमिंदा तुस्कुनी, राखला कुसनी पश्चात्ताप शेशींतुन्डीर. ");
INSERT INTO wbq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","आनकेन न्यायम दिवशी सोर आन सिदोन वारिक जास्त सोपा व्हई. ");
INSERT INTO wbq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","हे कफर्णहुमा, नु आकाश पर्यंत येत्ती फोयाव येम? नु नरक दनका दिग्याव. ");
INSERT INTO wbq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","यवाड शिष्यल् द इन्टाड वाड नाद ईन्टाड आन यवाड शिष्यल क नाकारास्तार वाड नाक नाकारास्ताड वाड यवाड नाक आमशीनाड वानिक नाकाडास्ताड.” ");
INSERT INTO wbq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","हा सत्तर मंदि आनंद गोन वचीर आन आनीर “प्रभू, नी फेरगोन दैयाल पण वश अवताद!” ");
INSERT INTO wbq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","आप्पुड वाड वारीक आन्या, “नीन शैताननी आकाशनेळ वीजलेका फडेतापुड सुस्तीन! ");
INSERT INTO wbq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","सूडना, नीन मिक फाम आन विंचूलकतुडवा शेद आन शत्रुन हांता सामर्थमिंदा, अधिकार ईच्चीनान आन यमटीगोनच मिक एमी हानी काकाफोई. ");
INSERT INTO wbq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","तरी पण मीक दुष्ट आत्माल वश आताय दिन्द आनंद शय्याकना तर मिद फेर स्वर्गला राशिंद ऊंडाय दींदी आनंद शयंडा.” ");
INSERT INTO wbq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","आ क्षणला वाड पवित्र आत्म्याला आनंदीत आय्या आन आन्या, “हे आब्बा, स्वर्ग आन पृथ्वी द प्रभू स्तुती शेस्थान, कारण नु इवी गोष्टी ल् ज्ञानी आन बुद्धिमान मनशी तिकेळ दाशी व्हटी हा शीन्ना बिडा क प्रकट शेशीनाव. आऊ, आब्बा कारण नीक येम योग्य वाटाशा आदी नु शेस्तु. ");
INSERT INTO wbq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ना आब्बाड हांनी गोष्टील नाईचागा ईचीन्या आन कोडकु यवार ऊंडाड ईदी आब्बानशिवाय यवारकच येरका लेद आन कोडकूशिवाय आब्बाड. यवार ऊंडाड यवारक् च येरका लेद आन यवारक् आदी प्रकट शेशेद कोडकुद ईच्छा ऊंडी वानिकच फक्त यरका आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","आन शिष्यलतीकुड तीरगी वाड एकांतला आन्या, “मीर येम सुस्तार आवी सुशेय कडन्ल धन्य. ");
INSERT INTO wbq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","नीन मीक शपतान, शेंगेम राजाल आन संदेष्ट्याल मीर येम सुस्तार आदी सुशेद ईच्छा शेशतीर, परंतु वार आदी सुडाले आन मीर येम ईनटार आदी ईनेद ईच्छा, बाळगायाशिर, परंतु वार आदी ईनाले.” ");
INSERT INTO wbq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","यंकसार वगा नियमशास्त्रलोंट्योड शिक्षक निला व्हड्या आन वाड येशुनदी परीक्षा तुस्कुणेद प्रयत्न शेशा. वाड आन्या, “गुरुजी, अनंतकाळदी जीवन शिक्केईच्चागा नीन येम शैयाबेक?” ");
INSERT INTO wbq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","आप्पुड येशुड आन्या, “नियमशास्त्रला येम लिवाशिनार? नु दांटल्या येम वाचास्ताव?” ");
INSERT INTO wbq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","वाड आन्या, “नु नी परमेश्वर मिंदा पूर्ण अंतकरणता, पूर्ण आत्माता, पूर्ण शक्ती गोन प्रिती शैई.” आन स्वतः मिंदा यळा प्रिती शेस्ताव आळा मना शेजार्यालमिंदा प्रिती शैई. ");
INSERT INTO wbq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","आप्पुड येशुड वारीक आन्या, “नु बरोबर उत्तर यीस्तू, ईदीच शैई आंटे नु बतक्याव.” ");
INSERT INTO wbq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पण मनाम योग्य प्रश्न आडगीनाम ईदी दुसरावरक सुबेईच्चागा वाड येशुन आडग्या, “आंटे ना शेजारी यवाड?” ");
INSERT INTO wbq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","येशुड उत्तर ईच्चा, “वगा मनशी यरुशलेम ऊरनेळ यरीहोक यळीन्या आन वाड दोंगाल शेतल्या शिक्या. वार वानी बंटाल तिशी वानिक मत्तीर आन आरधाम ससिनेन इडशी फोईर. ");
INSERT INTO wbq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","आप्पुड हाचवेळी वगा याजक हा रस्तागोन यळीन्या. याजकाड वानिक सुशा, पण दावा दुसरा बाजुनेळ यळी हो. ");
INSERT INTO wbq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","हाच दावानेळ वगा लेवीड वानिक सुशा. आन वाडपण दावा दुसरा बाजुक येळी फो. ");
INSERT INTO wbq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","आन वगा शोमरोनी हाच दावानेळ यळीन्या वाड ऊंड्या आंद वचा इ मनशीन सुशी वानिक वानदी कळवळा वच्या ");
INSERT INTO wbq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","वाड वानदैगारा वच्या वान जखम मींदा नुन्या आन द्राक्षालदी रस फोशी आदी कट्या आन वान स्वता गाडदीमींदा कुसनामती उतारशाळाला येतकावचा आन वानद सेवा शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दुसरा दिनामला वाड रोंड चांदीई नाणल् तिशा आन उतारशाळालोन मालकनक ईच्चा आन आन्या, ‘विनदी बागा काळजी तुस्को आंटे दिनपेक्षा जास्त खर्च जर नु शेस्तु आदी नीन नीक परत वचीनेन्का निक ईचान.’ ");
INSERT INTO wbq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","दोंगाल शेटल्या या मनशी शिक्कीन्या, वानद् हा मुग्गुरलोंट्योर यवार खेरेम शेजारीऊंड्या ईळा निक वाटास्ताद?” ");
INSERT INTO wbq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","हा नियमशास्त्रटोळ शिक्षक आन्या, “यवाड वानमिंदा दया शेशा वाड,” आप्पुड येशुड वारीक आन्या, “फो आन नु पण आले शैई.” ");
INSERT INTO wbq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","यंकसार येशुड आन वान शिष्यल् वान मार्गनेळ व्हयेतापूड, वाड वगा ऊरला वंच्चा. आंद मार्था फेरद आंती वानद स्वागत शेशी आदरातिथ्य शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","दानिक मरिया फेरूद शेल्याल ऊंड्या, आदी द्यावार काळादैगारा कुसन्या आन वाड येम आंटाड आदी ईनटून्या. ");
INSERT INTO wbq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पण मार्थाद जास्त फनीगोन तारांबळ आय्या. आदी येशुन दैगारा वच्या आन आन्या, “प्रभू, ना शल्याल आंता फनी नामिंदा येशा दीनदी काळजी निक लेद येम? तर नाक मदत शेशेदेंक दानिक शप्प.” ");
INSERT INTO wbq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभुड उत्तर ईच्या, “मार्था, मार्था, नु संगेम माटलाविषयला दगदग शेस्ताव. ");
INSERT INTO wbq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","पण ओकाटे माटा आवश्यक ऊंडाद. ईदी नीन शपतान आन मरीयाद दान ईचांग बागा वाटा निवडाशिनाद. आदी दानतिकेळ तिशी तीस्कोनदेंक दाद.” ");
INSERT INTO wbq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","इंगा इल्ला आय्या की, वाड वगा ठीकाण्या मिन्दा प्रार्थना शेसतुन्ड्या. आधी आईन्का शिष्यांनलोट ओकाजण वान आन्या, “प्रभु, इल्ला योहानाड वान्द शीष्यलकी नेरफ्या; वानलका मीरदेखील माक प्रार्थना शेसदेन्क नेर्फन्डा.” ");
INSERT INTO wbq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","आंटे वाड वारनी आन्या, “यपुड मीर प्रार्थना शेसतार आप्पुड मीर इळा आन्डा: ये मा स्वर्गलोन आबा, नीद फेर पवित्र मानादेंक फोवाला, नीद राज्य दावाला, ");
INSERT INTO wbq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","माद दिन्नामद आन्टेद रोट्या माक ई, ");
INSERT INTO wbq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","मा पापुलद माक क्षमा शय, आनकेन मिमबी माद परतेक आपराध्यांक वान आपराध्यानदी क्षमा, शेसतांम इंका माक परीक्षेला यतकेन दावाक तर माक वाईटानोट इडू.” ");
INSERT INTO wbq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","इंका येशुड वान आन्या, “समजांयडा मीरपैकी यवाड इळा उंडाड वानकी मित्र उंडाळ इंका वाड वानतिक मापकाडा फो व वानिक आन्या, ‘मित्रा, नाक मूड रोट्या उसना इ, ");
INSERT INTO wbq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","आनकेन ना मित्रांड इपुडच परवास शेशी नातिक वचीनाड आनकेन वानिक वाढ्यासदेन्क ना देगारा यम बी लेद.’ ");
INSERT INTO wbq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","आंटे वाड आरवा नोनिकेल आन्या, ‘नाक तरास इयाक! नीन पहिलाने वाकील आनशीन्द उंडाद इंका ना बिळ नादग्गारा फंडीनार. नीन मिक रोट्ट्या इसदेन्क इचाका लेशा लेद.’ ");
INSERT INTO wbq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","नीन मिक शपतान कि, जरी वाड लेशी वानिक येम इसदेन्क इचाका टाळाटाळ शेसतूंटे तरी वान मित्रान आग्रहागोन वाड खात्रीगोन लेशी वानिक यंता रोट्ट्यालद गरज उंडाद आंता वानिक इच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","इंका आनकेन निन मिक शप्तान, आडगण्डा आंटे मिक इच्चार फुडकयंण्डा. आंटे शिक्की इंका ठोकायंण्डा आंटे मिर इच्चाका उघडाशी फोइ. ");
INSERT INTO wbq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","आनकेन यवार आडगताड वानिक शिक्की. इंका यवार फुडकताड वानिक शिक्की इंका यवार ठोकाशी वानइच्चाक वाकील त्यरशीगेस फइ. ");
INSERT INTO wbq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","मिता इल्ला यवाड आबाड उंडाळ कि, वान कोडकु मील आडग्यातर वानिक मीलऐवजी फाम इच्ची?. ");
INSERT INTO wbq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","इळा जर बीडा गुडू आडग्यातर याद आबाड वानिक तेल इच्ची? ");
INSERT INTO wbq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","इंका मीर वाईट उंडीगेस मिक मि बिळाक मंचिद देनग्याल इच्चेद तेलस्ताद, तर मग स्वर्गीय आब्बानतिक यम आडग्यार वारीक वाड यंता विशेषगोन पवित्र आत्मा इच्ची?” ");
INSERT INTO wbq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","येशुड वगा दैयाम तीसतुंड्या. वाड मुक्योड उंड्या. इंका इळा आय्या कि, या आरवांक माटलाडदेन्क, वस्तून लेकुड्या आदी दैयम बैयट्या वच्चीनका, वाड माटलाडदेन्क आंट्या व मंदी जमाव आचर्य चकीत आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","आनकेन आ जमावालोन सनगोट मंदी इळा अनिर कि, दैयाम सरदार इड बालजबूल इन साय्यागोन वाड दैयाम तीसताड. ");
INSERT INTO wbq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","इंगा काहीजण वांदि परीक्षा सुसदेन्क स्वर्गुनोट चिन्हाल आडगीर. ");
INSERT INTO wbq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पण वार मनसला यम उंडाद इदी वाड जाणाशी उंड्या आनकेन वाड वारीक आन्या, “आपसात फुट फडींद परतेक राज्य ओसाड फडी इंका यवार या इंकलोन मंदी वगामिगाद विरुद्याला जगडाम शेसतार आप्पुड वार इल्यूद तुकडाल आताय. ");
INSERT INTO wbq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","इंका मीर आंटार इळा जर दैयामला फुट फड्या तर वांद राज्य यळा टीकाशी? नीन मिक इदी आडगतान, कारण 'मीर आंटार बाल्जबुलांन्द साय्यागोन दैयाम तीसतान' ");
INSERT INTO wbq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","इंगा जर नीन बालजबुलान साहाय्यागोन दैयाम तीसतान, तर मीर शिष्य यवार साहाय्यागोन दैयाम तीसतार? आनकेन वार मिद न्याय शेशार. ");
INSERT INTO wbq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","परंतु जर नीन द्यावार्द साहाय्यागोन दैयाम तीसतान तर मग दिनमिन्दूर इदी स्पष्टच उंडाद कि, द्यावार्द राज्याम मीरदग्गारा वाच्चींद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","यपूड यावाराना बलवान आरवा मना इलुंद सूरक्षीतते इच्चाका आंता शस्त्रसामग्री बाळगासताड आप्पुड वान्द मालमत्ता सुरक्षित नीलस्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","परंतु यवार वारकिंटा शना बलवान वानमिदा हाल्ला शेशी वान्द पराभव शेसस्ताड, आप्पुड आ शस्त्रसामग्रीमिन्दा वाड इश्वास फटींद उड्या, आदी वाड तीस्केन फोताड व वान्क शिक्किंद लुट मना मित्रांक फनस्ताड. ");
INSERT INTO wbq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जो नाद बाजूगोन लेद, वाड ना इरोदला उंडाड आनकेन जो नाबरोबरीगोन गोळा शेशालेर, तर वाड उधलाशी कुक्कताड. ");
INSERT INTO wbq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","यपुड अशुद्ध आत्मा मनसिबैट्या वस्ताद व वाड इसावा तीस्कूनदेन्क निर्जल प्रदेशाला जागा फुडकताद. पण वान्क आदी इश्रांती शिक्या लेद. आप्पुड वाड आंटाड, 'नीन या इंकाल्यानुट बैट्या वच्चीनांन आच इंकल्या एनकाक फयान.' ");
INSERT INTO wbq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","वाड आ इंकल्या यक्का फोताड आप्पुड वान्क आदी इल्लु झाडशी नीटनेटका शेशिंद कमस्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","यंकसार वाड फोताड इंका मनापेक्षा शना बळकट व दुष्ट इळा योड आत्माला तीस्कूंताड इंका वार आ इंकल्या फोतार इंका आंदच निलस्तार आप्पुड आ मनसिंद शेवटंद परिस्थिती पहिल्या पेक्षा वाईट आताद.” ");
INSERT INTO wbq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","वाड इदी गोष्टी माडलाडशा आप्पुड इळा आय्या कि, गर्दीलोन वगा आरवाती बैग्या कीरलीगेस वान्क आन्या, “धन्य आदी गर्भाशय, वार नीद भार वाह्याशा व धन्य आदी सनल जी नु चोकास्तीव.” ");
INSERT INTO wbq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","परंतु वाड आन्या., “जे द्यावरक वचन इंटार इंका पाळास्तार वारच खरेम धन्य उंडार!” ");
INSERT INTO wbq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","यळायळा मंदीकुडीगेस वाढासदयेन्क आंटीर, आप्पुड वाड माटलाडदयेंक आंट्या, “इदी पिढी दुष्ट पिढी उंडाद. आदी चिन्हाल आडगताद इंका योनान्द चिन्हाशिवाय यादिबी चिन्ह दानिक इस्देंक आयदकाद. ");
INSERT INTO wbq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","कारण यळा योनाड निनवेन्द मंदीइचाका चिन्ह उंडाद आळा मनसि कडंकुबी इ पिढीद चिन्ह आइ. ");
INSERT INTO wbq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","दक्षिणेकडाद राणी न्यायाम्द दिनाम इ पिढीबराबर लेशी वारक दोषी ठरवाशी कारण इनदी पृथ्वीद टोकानुट शलमोनान्द शहाणपण इनेद इच्चाका वचीर इक्का सुड, शलमोनादानपेक्षाबी फेदावड इळा वगा इन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","न्यायाम्द दिनूम निनवेन्द मंदी इदी पिढीसंगा नीला फडीगेस दानिक दोषी ठरवाशार कारण योनान्द उपदेश इनी वार पश्चात्ताप शेशीर इंका सूड, योनाकिंनटा पण फेदावड इळा वगा इन्द उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“यवारबी दिवा आणशिगेस किंदुडइटल्या इंका भांड्यालकिन्दा फेट्या लेद, तर नोना वचीनोरक यंलग कमसाबेक आनकेन दिवणीमिन्दा फेटतार. ");
INSERT INTO wbq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","कन्न इनदी मिद फयद दिवा उंडाद. जर मिरद कन्नल मन्चीव उट्या, तर मीरद फय्यबी यलगगोण निंडीनेद उंडी. ");
INSERT INTO wbq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","पण वार जर वाईट उंडार तर मिरद फय्य गडदमय उंडाद आनकेन निमिदोर्द यलग इदी गडदू तर लेद ना, दिंन्द काळजी तीस्कोण्डा. ");
INSERT INTO wbq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","जर मिद आंता फय्य यलगमय उंडाद इंका दांदलोन यादिबी बगल गडदुमय लेद तर, यळा दिव्यांद यलग किराणाल निक यलग इस्तार, अळा वार निक आंदातीकोट यलग शेशीं.” ");
INSERT INTO wbq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","येशुड वान्द माट संप्पवाशा आप्पुड वगा परुशाड वान्क मन्ना इटल्या वच्ची स्वतः संगा तीदेंन्क फिलच्या. वाड नुनिक फो इंका मना जगामिन्दा तीदेंन्क कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","गान वाड तीन्याका मुंच्ची शेतल कडग्या लेद इदी सुशी परुश्यान्क शना आश्चर्य वाटाशा. ");
INSERT INTO wbq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","आप्पुड प्रभु वान्क आन्या, “मीर परुशी पेला व तल्या ब्यटीनुट साफ शेस्तार पण मीर न्वानुट लोभीपणागोन इंका गब्बूगोन नीडींनोर उंडार. ");
INSERT INTO wbq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","अरे बुद्धीहीन मंदीनो! यवार ब्यटीद बाजू बनवाशीर वारच न्वानोड बाजू बनवाशा लेड येम? ");
INSERT INTO wbq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","पण य्याद न्वाना उंडा.द, आदी गरिबोरक इडा इंका यंकसार आन्तांयम मिरइच्चाका शुद्ध आय्यी. ");
INSERT INTO wbq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","आंका मिर परुशान्क हाय उंडान कारण मीर पुदिना, जीर व प्रत्येक भाजीपाल्यान्द दशांश इसतार. परंतु मीर न्याय इंका परमेश्वर इषयन्द प्रीती दिनतिक दुर्लक्ष शेसतार. मीर नितीगोन बत्केद व परमेश्वर मिंन्दा प्रीती शेशेद इदी गोष्टील प्रथम शेशेदआवश्यक उंडाद आ येळक इतर गोष्टील तिक दुर्लक्ष शेशेद लेद. ");
INSERT INTO wbq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","मिर पुरुश्यान्द यन्ता दुर्दशा आइ, कारण मीरक यहुदी सभास्थानातीला महत्वाद जागी कुसनेद इंका बाजारला नमस्कार तीस्कूनेद आवडास्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","मिद यन्ता दुर्दशा आय्यी! कारण मीर न कमशिंद कबरलका उंडार, इल्ला कबरालमिन्दा मंदी नत्लस्ता काळ इच्ची न्यडस्तार.” ");
INSERT INTO wbq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","वगा नियमशास्त्रद शिक्षक येशुन आन्या, “गुरुजी, मीर इळा माटलाडस्तार आप्पुड मीर मादसुद्धा अपमान शेस्तार.” ");
INSERT INTO wbq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","आप्पुड येशुड आन्या, “नियमशास्त्रन्द शिक्षकल मिदपन धिक्कार उंडाला, कारण मीर मंदीक वाहशांक अवगढ इळा बरु वारमिंदा इस्तार इंका वार यतीदेन्क मिर्द वगा येळगोन सुद्धा मदत शेशा शयार. ");
INSERT INTO wbq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","मिर्द धिक्कार उंडाला, कारण मिर्द पूर्वजानी ठार शेशिंद संदेष्ट्यालइच्चाका मीर कबराल कटंतार. ");
INSERT INTO wbq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","इळा शेशी मीरद पूर्वजांनी शेशिंन्द कृत्यांलद समर्थन शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","दिनइच्चाका परमेश्वर ज्ञान सुद्धा इळा आन्या, 'नीन प्रेषित इंका संदेष्ट्याल वारतीक आमशान. वारपैकी काही मन्दिक वार ठार मतेशार व काही जणांन्द वार छळ शेशार!' ");
INSERT INTO wbq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","तर, संदेष्ट्यालद आदी नेत्तुर दुन्याम ममुंदगानोट सली फो दानइच्चाका दंड इ पिढीक नीनचीगेस इयाबेक. ");
INSERT INTO wbq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","का, नीन मिक खरेम शप्तान कि हाबेलान्द रक्तातनुट, आदी द्यावारद भवन व वेदी इर्ता मतेशी फइनोर जखऱ्या इरद नेत्तुर दंका इदी पिढीक जबाबदार फट्देन्क वच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","मीर्द नियमशास्त्र. शिक्षकान्द यंता दुर्दशा आइ कारण मिर ज्ञानाद किल्ली तीस्केन फोडाव, मीर स्वत: नोनिक फव्वा लेद इंका जे नोना फय्येद प्रयत्न शेस्तूनटार, वारबी फइदेन्क इया लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","येशुड आंदूट यळी फोतुड्या नियमशस्त्रल्द शिक्षकाल व परुशाल वारद शना इरोध शेसदेंक आंटीर व वारीक संगेम गोष्टीलविषइ प्रश्नल आडगदेन्क आंटीर. ");
INSERT INTO wbq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","वाड आदी माटलाडशा आ शब्दांला वार फटदेन्क इच्चाका वार टपाशी उंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","इंका आदरम्यान हजारो मंदीद समुदाय जमाशिंद उंड्या इंका इन्ता कि वार वगामिगारक तुकुदेन्क आंडीर, आप्पुड येशुड प्रथम मना शिष्याल्क माटलाडशा: “परुशांन्द खामिरा इषय जपायंडा, आंटे वारद ढोंगाइषय जपायंडा. ");
INSERT INTO wbq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","उघड शेशा फइंन्द लेद इळा यमच मुय्या लेद व यम तलचेंद लेद इळा यमच गुप्त लेद. ");
INSERT INTO wbq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","आनकेन मीर जे यम गडदला माटलांडतार आदि यलगला इनी फइ इंका मीर यवार गुम्माला यमबी वगाताडला शप्यार आदी इल्लु छतमींदोट घोषित शेशी फइ.” ");
INSERT INTO wbq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“परंतु नाद मित्रांनो, नीन मिक शप्पतान, यवार फय्क मत्ततार वारीक मीर यरस्कुंनाक, कारण दाननंतर वारकींटा शना वारीक यम शेसदेंक वच्चा लेद. ");
INSERT INTO wbq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मीर यवार्द यरपू बाळगायला इदी नीन मिक शप्पतान. मीक ठार मत्तीरआंटाका मिर्क नरकाला कुक्की इसदेंक वारीक अधिकार उंडाद, वार्द यरपू फंटंडा. का, नीन मिक शप्पतान, वान्दच यरपू फंटंडा. ");
INSERT INTO wbq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","आयद गुवाल रोंड शिनाय नाण्यालकी आंबूतार यम लेद? तरी दांटलोन्द वगारदबी परमेश्वर क विसर फड्या लेद. ");
INSERT INTO wbq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","पण मिर्द न्यतीमिंदोट आंता यडकाल देखील वाड कोल्चीनोड उंडाद. यरस्कुनाकड. सनगेम गुवालकिंटा मिद मूल्य शना उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","जो नाक आता, मंदीमुंदारा स्विकरस्ताड, आ प्रत्येक मनसीक द्यावरदूत लामुन्दारा मनसीद कड्कू स्वीकारशी. ");
INSERT INTO wbq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","परंतु जो नाक इतर मंदिमुंदरा. नाकराडस्ताड, वाड द्यावरदूत लामुन्दारा नाकराशी फइ. ");
INSERT INTO wbq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","प्रत्येक मन्शी जो मन्शीद कोडकूविरुद्ध माटलाडशी, वानीक क्षमा शेशीफइ. परंतु जो पवित्र आत्माविरूद्धला दुर्भाषण शेशस्ताड वान्क क्षमा आयद लेद. ");
INSERT INTO wbq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","आप्पुड वार मिक सभास्थाणागोन, राजकर्तेल इंका अधिकारी वारमुंदारा फटी यतकेनवच्चार आप्पुड मीर यम माटलाडशेद इका स्वत:द बचाव यळा शैयाला आइषयला मुंची चिंता शेसकेन कुस्नाकंडा. ");
INSERT INTO wbq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","कारण मीर यम माटलाडेद हे पवित्र आत्मा आचयेळक मिक नेरफी.” ");
INSERT INTO wbq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","यंकसार मंदीसमुदायलोन ओकोळ वान आन्या, “गुरुजी, नाद तमूनक ना हिसा लोन्द नाद नाक इसदेंक शपना!” ");
INSERT INTO wbq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","परंतु येशुड वान आन्या, “आरवा, नाक मिरमिन्दा मध्यस्थी इंका न्यायादिशाड आनकेन यवार नेमाशीर?” ");
INSERT INTO wbq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","इंका येशुड वारनी आन्या, “साभाळयंण्डा इंका आंता प्रकारद लोभानूट स्वता:न्क दूराम फटण्डा कारण यप्पूड वगा मनशीदग्गारा वान गरजेंपेक्षा शना उंडाद आप्पुड आदि संपत्ती वार्द जीवन उंडी इळा लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","नंतर वाड वारक वगा दाखला शप्या, “यवागांक धनवान मनशिद शेतजमिनीला शनामचिद पिक वच्या. ");
INSERT INTO wbq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","वाड स्व:ताक विचार शेशीगेस इळां आन्या, 'नीन यम शेषेद, कारण धान्याल साठवायला नातिक जागा लेद?' ");
INSERT INTO wbq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","मग वाड इळां आन्या, 'नीन इप्पुड इळा शेसतान नीन नाद धान्याल कोठारे केडपीगेस फेदाद कटतान नीन नाद आंता धान्याल व माल आन्द साठवास्तान' ");
INSERT INTO wbq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","इंका नीन नाद जेमक आनटान ‘हे जीवा, इप्पुड निइच्चाका सनगेम यड्लू साली इळा सनगोट मंची माटलु साठ्वाशिगेस फेटीनेय उंडाय. आराम शय, तिनी, तागी मजा शय.’ ");
INSERT INTO wbq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पण परमेश्वर वान आन्या, 'अरे मूर्खा, जर ईबद निद जेम फो तर नु साठवाशीने माटलु यवारक शिक्की?' ");
INSERT INTO wbq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","जो यवाड मना इचागा संपत्ती जमा शेस्ताड परंतु द्यावार दृष्टीगोन जो धनवान लेद, इळा मंदि लका इर उंडार.” ");
INSERT INTO wbq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","आंटे येशुड वार शिष्यलनी आन्या, “आंका नीन मिक शपतान, तान स्वत:न्द जीवनइषयाला इंका मीर यम तीनेद इदी इषयला चिंता शयाकण्डा. इंका मिद शरीर आंटे याद बटाल येस्कुनेव इदी विषयला चिंता शय्याकण्डा. ");
INSERT INTO wbq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","कारण आन्नामकाना जेम इका बटालपेक्षा फय महत्वाद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","काकीद विचार शयना वार पेरायार इंगा कापणीही शेषार. वारीक कोठार लेद व कणगीही लेद. तरीही परमेश्वर वारद पोषण शेस्ताड. पक्षलकना मीर यन्तातरी मौल्यवान उंडार! ");
INSERT INTO wbq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","चिंता शेशीगेस मीरपैकी यवार स्वत: आयुश्याद दोरी शेतभर वाढवावयास यवार समर्थ उंडार? ");
INSERT INTO wbq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","जर मिर अन्दाला शिनाद माटलू शेश्या लेद, तर इतर माटला विषयदी चिंता याला शेस्तार? ");
INSERT INTO wbq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","रानफुले यळा फूटताद दाण्द इचार शेयडा. आदी कष्ट्याम शेश्या लेद व कातीत लेद. तरी नीन मिक शपतान, शलमोनदेखील मनाद आंता वैभवला दानटलोन वगालेकाही सजाशीन्द लेकुड्या. ");
INSERT INTO wbq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","तर, जे इबद उडाद व रेफाक भटीला कुकी फइ इळा आ शेनलोंड गडीक इळा द्यावर इळां पोशाख येशीन्द उडाद, तर मीर जे अल्पविश्वासू आ मिक वाड यतातर शना मंचीद पोशाख यसकुन्या लेद यम! ");
INSERT INTO wbq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","मीर यम तीनेद व यम तागेद याविषयला चिंताला उंडेद लेद इंका इदी गोष्टीइषयला चिंता शेशेद लेद. ");
INSERT INTO wbq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","कारण परराष्ट्री इदी मिळवासदेंक खटपट शेस्तार पण इ माटलु मिक गरज उंडाद, हे मिद स्वर्गीय आबाक यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","आऐवजी प्रथम वानदी राज्य शिक्कीइच्चाका झटा आंका इ माटलु मिक इच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ये शिना कळप यरस्कुनाक, कारण मीरक वानदी राज्य इच्चेद आ दिंटल्या स्वर्गीय आबांक संतोष वाटास्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","मिंद मालमत्ता आंबूना इंका गरिबोंक फंच. फाताद न आयद व न झिजाशेव इळा तितील स्व :ता कसरोम स्वर्गाला बनवायडा. आंदु दोगालपण फयतोरकाड व कसरही दान्द नाश, शेयातोडकाड. ");
INSERT INTO wbq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","कारण यंदु मीद धन उंडाद आंदू मीद मनपण आंटी. ");
INSERT INTO wbq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","मीद नळमूळ कटीनेय इंका दिवाल आणशीनेय उंडा निंडा. ");
INSERT INTO wbq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","फेनलीद वन्टामिदुट यका वचिंद मालकदी दावा सुस्तार आ मंदिललेका का आनकेन, वाड यका वस्ताड व वाकील ठोकस्ताड आप्पुड वारइच्चाका इर ताबडतोब वाकील तेरशेद. ");
INSERT INTO wbq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","मालकड यका वचीनेन्का या नोकरलु वानकी मेल्का व तयारीला उडीनेर कमशार वार धन्य. वार नीन मिरक खरेम शप्पतान वाड स्वत:वानदी सेवा, शेसदेन्कइच्चाका कंबर कसाशी, वारक मेजामिंद कुसुनिदेन्क शप्पीगेस वानदी सेवा शेशी. ");
INSERT INTO wbq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","वाड मुनीमंबुला इंका दानकंटाइंक्सरा वचा जर वार कुलोर तयारीला अाढळाशार तर वार धन्य. ");
INSERT INTO wbq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","पण दिनइषयला खात्री बाळगायन्डा; दोगाल यपूड वस्तार इदी जर इल्लु मालकोडकू यरका उन्ड्या तर वाड मनाद इल्लु वान्क फगला मती इस्तून लेकुड्या. ");
INSERT INTO wbq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","मीरबी तयार उंडाला कारण मिर्क वाटाश्या लेद इळा क्षणी? मन्शी कडकू वच्ची.” ");
INSERT INTO wbq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","मग पेत्रड आन्या, “प्रभू, मीर इदी दाखला माकच शपतार की आदारक?” ");
INSERT INTO wbq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","आप्पुड प्रभू आन्या, “प्रभु वान्द इंगा कुलोरद वाद धान्य योग्य याळक इच्चेदइच्च्का यवार्द नेमणूक शेशी इळां व विश्वासू कारभारीड यवाड उंडाळ? ");
INSERT INTO wbq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","वान मालकड वच्ची आयेळक इळा शस्ताना जो कुल्योर वान्क आढळाशी वाड धन्य. ");
INSERT INTO wbq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","नीन मिरक खरेम शप्पतान, मालकड वानिक वान्द आंता मालमत्तेमिन्दा अधिकारी आनकेन नेमाशी. ");
INSERT INTO wbq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पण जर वाड कुल्योड मनसला आंटाड, ‘नाद मालकड वस्देंक शना वेळ शेशातोड उंडाड,’ इंका मग वाड वान्द आंडेर इंगा मनसलू कुल्योरक मारहाण शेसदेंक व तीनदेकताग्देक सुरवात शेस्ताड व झिंगास्ताड, ");
INSERT INTO wbq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तर वाड कुल्योर दावा सूशा लेद आदिनम इका वारीक यरका लेद आप्पुड वार्द मालकड वच्ची व वार्क कोशी वार्द तुकडाल शेशी इका अविश्वासी मंदिबराबर वार्द वाटा फेटी. ");
INSERT INTO wbq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","मना मालकन्द इच्छा यरका उडीगेस जो कुल्योर तयार निलचा लेद इका मना मालकन इच्च्यायोन शेश्या लेद, आ कुल्योरक शना मार शिक्की. ");
INSERT INTO wbq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","परंतु वानिक यरका लेकुडी आनकेन वाडा मालकड्क न आवडाशिन्द यळा कृत्य जर कुल्योड शेश्यातर वानिक कडमा मार कुसनी. यवारक शना इचीन्द उडाद वारतिकुट संगेमोरदी अपेक्षा शेशीफइ. वान्तीक शना अपेक्षा फेटीन्द उंडाद वानतिकूड शना आडग्यार.” ");
INSERT INTO wbq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“निन पृथ्वीमिंदा आगी आनसदेग वचीनान इंका जर आदी मुंदू पेटाशिंद उडी तर मग नाक इक्का येम बेक? ");
INSERT INTO wbq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","नाक बाप्तिस्मा तिस्कूनेद उंडाद इक्का आधि आइन्दन्का निन यता अस्वस्थ उंडान! ");
INSERT INTO wbq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","निन पृथ्वीमिंदा शांतता प्रस्थापित शेसदेग वचीनान उंडान, इळा मीक वाटास्ताद यम? लेद, निन मिक शप्पतान, निन मिता फूट कडपदेगइच्चाका वचीनोन उंडान. ");
INSERT INTO wbq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","निन इळा आटान कारण इपू डनुट इकनोलोर आय्यीद जानान्क वागामेगाइरुद फूट फंडी. मुगूर इद्दार इरोध व इद्दार मुगूर इरोध इळा फूट फडी. ");
INSERT INTO wbq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","दान्टला आबान इरोध कंडकू व कंडकू इरोध आबाड इळा फूट फंडी, आम्मा इरोध कुतुर व कुतुर इरोध आम्मा इळा फूट फंडी, आता इरोध कोडाल व कोडाल इरोध आता इळां वार्ता फूट फंडी.” ");
INSERT INTO wbq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","वाड मंदीसमुयाक आन्या, आप्पुड पश्चिमेतीकुनुट मोळाम वच्चाता आप्पुड सुशार आप्पुड मीर लगेच आंटार कि, वाना फडी इंका आळच आताद. ");
INSERT INTO wbq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","यपूड दक्षिणेतिकुट गाली वाहास्ताद, आप्पुड मीर आंटार उकाडा आइ इंका, आळच आताद. ");
INSERT INTO wbq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","अरे ढोंग्यानो! मिक पृथ्वीमिंदुट व आकाशालोन चिन्हालीव लक्षनाल यरका उंडाद, पण सध्यान्द कालामद आर्थम मिर्क याला तिसदेयक दाद यम्म? ");
INSERT INTO wbq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“इंका मिर मिर्दइचाका यम योग्य उडाद इदी मिर स्वतान्द स्वतः याला ठरवाशा लेद? ");
INSERT INTO wbq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","मीर मिर्द वाद्यानसंगा न्यायमला फोतार आप्पुड दावाक वारसंगा समेट शेयडा लेकुटे वाड मिक न्यायाधीशान मुदारा येतकेन फइ इंका न्यायाधीशाड मिक दंडाधिकाऱ्याक स्वाधीन शेशार इंका अधिकारी मिर्क तुरुंगाला कुक्की. ");
INSERT INTO wbq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","नीन मिक शपतान, अगदी शेवटीद दमडी न दमडी फेडाशीनदन्का मिर आदुनुट इडशातोरच कार.” ");
INSERT INTO wbq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","आ वेळला येशूनकी आंदू उपस्थित मंदी, पिलातुट गालील प्रांतलोन मनसीद रक्ताम वारद यज्ञपशुन्द रक्ताम येल्ला मिसळाशिन्द उंड्या, दानइषयी शेप्या, ");
INSERT INTO wbq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","वाड वारकी उत्तर इच्या, “इगालीलकराल इंदी वाड वारकी भोगाशीर दानमिदूट वार इतर गालीलकरानपेक्षा शना पापी उंडीर, इल्ला मिक वाटास्ताद येम? ");
INSERT INTO wbq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","निन मिक शप्पतान की इल्ला लेद, जर मिर पश्चात्ताप श्यालेद तर वार येल्ला सचीर आले मीर बी सचार. ");
INSERT INTO wbq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","इंका जीनमिदा शिलोहान्द बुरुज फड्या इंगा दानकिंदा दबाशी सच्ची फइनोर वार आठराजन यरुशलेम शहरला निलच्चेतोर इतर आंता मंदीपेक्षा शना पापी उंडीर इळा मिक वाटास्ताद येम? ");
INSERT INTO wbq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","लेद, नीन मिक शेपतान जर मिर पश्चाताप शय्या लेद तर मीर आंदार वारलेकाने सच्चार.” ");
INSERT INTO wbq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","आंट्यांगा येशुड इदी दाखला शेप्या, “ओका मणशी वानदी द्राक्षमळ्याला अंजिराद माक आनशिनोड उंड्या, दानमिंदा येम फळ उंडी आनकेन वाड आदी सुसदेंक वच्चा गान वानिक आंद येम बी कामसा लेद. ");
INSERT INTO wbq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","आनकेन वाड माळ्याक आन्या, सुंडा, इदी अंजीराद शटू मिंदा फळ सुसदेंक कस्रोम नीन यनकोड मूड यंडलानोट वस्तान, परंतु नाक दानमिंदा येम बी आढळाशी लेद. आदी नरकेस कानडा. उत्याका आदि जागा तरी येल्ला आडवाशेद? ");
INSERT INTO wbq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","माळ्याड उत्तर इच्चा मालक, इदी वगायाडाद दांक्क निलवानी. आन्टे नीन दानभवती तव्वीगेस दानिक खत एशान. ");
INSERT INTO wbq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","मग वची याडादला फळ वच्या तर बागाच! जर दावा लेद तर मग मनाम आदी नरकी वाहशेदे.” ");
INSERT INTO wbq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","इंका शब्बाथ दिनमुनाड येशुड वगा यहुदी सभास्थानाला शिका मतून्या. ");
INSERT INTO wbq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","आंद वगा आरवाती उंड्या, दानिक दृष्ट आत्म्याने अठरा यडलादण्का अपंग शेशिंड्या आदी कुबडी उंड्या इंगा दानिक सक्कांगा. नीला फडदेंक वस्तून लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","येशुड दान सुशी दान फिलच्या इन्का वाड दानिक आन्या, “आनबीडा, नीद आजारनुट नु मुक्त आइद उंडाव.” ");
INSERT INTO wbq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","आनट्याका वाड मना शई दानमिंदा फेट्या इन्का आदी लगाना सक्कांगा आय्या इन्का आदि द्यावारद स्तुती शेसदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","इंक्सारा आनट्याका, येशुड दानिक बागा शेशिनड्या आदी शब्बाथ दिनमु उंड्या आनकेन यहुदी सभास्थान्द आधिकारीड वारमिंदा शीटू शेशा शब्बाथ दिनमुनाड यादबी फनी शेशेद लेद इल्ला यहुद्यान्द नियम उंडाद. वाड मंदीक आन्या, “फनी शेसदेंक इच्चाका आर दिनाल उंडाय आनकेन इ आर दिनमुला दांडा इंगा बागा कांडा. पण शब्बाथ दिनमुनाड वच्चीगेस बागा काकांडा.” ");
INSERT INTO wbq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","येशुड वारीक उत्तर इच्चा इन्का आन्या, “ढोंगानो, मीरपैकी प्रत्येकजण वान्द यद्दक व गाडदीक शब्बाथ दिनमू वार्द ठिकान्यानूट इडशी नेळ ताकदेक यतकेन फोलेद येम? ");
INSERT INTO wbq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","इदी तरी अब्राहमान्द कुतूर उंडाद. सैतान दिनिक आठरा यंडलु कटी फेटीन्द उंड्या. आ बंधनानूट दानिक शब्बाथ दिनमुनाड इडशेद तप्पू आताद एयेम?” ");
INSERT INTO wbq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","वाड इल्ला आनिनका दाद इरोद शेशातोरोक शिग्ग आय्या व यवार आ आदभूत गोष्टील शेशीद उंड्या दानगोन आन्त्ता समुदाय आनंद शेसदेक आंटया. ");
INSERT INTO wbq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","इंगा वाड आन्या, “द्यावारद राज्य यवारल्यका उंडाद? इन्का नीन वानिक यमटीद उपमा इदून. ");
INSERT INTO wbq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","द्यावारद राज्य वगा मोहरी दाण्यालका उंडाद. आ मोहरी दाणा वगा मनशी तीसकुन्या इंगा मना बागला आनशा इंगा आदी वाडाशी दांदी फेदाद माक आय्या इका आकाशानिव गुवाल दान फांद्याल मिंदा घरटयाल कटीर.” ");
INSERT INTO wbq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","वाड इंगा आन्या, “नीन द्यावार राज्यमला इनका यमटीद उपमा इदून? ");
INSERT INTO wbq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","आदी खमिरालका फिंडी इंका इतर पदार्थालका आंबवाशिन इच्चाका उपयोगाला वच्चेद पदार्थ उंडाद. वगा आंती मूड मापूल फिंडीला खमिर मिसळाशा इंका आदी आन्ता खामिरागोन फुगाशा.” ");
INSERT INTO wbq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","येशुड यरुशलेम शहराद दिशेगोन वाटचाल शेशदेंक आनट्यां, उरउरूनुट इंका खेड्यापाड्यानुट वाड मंदीक नेरपूतुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","यवारतरी वानिक आडगिर, “प्रभू, अगदी रव्वाच मंदीद तारण आय्यी येम?” वाड वारीक आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“शिंन्ना दरवाजाता नोनीक फोयेद प्रयत्न शेयना, येनटीक की नीन मिक शेपतान, की शेंगेम मंदी नोनीक वच्चेद प्रयत्न शेश्यार, पण वारकी आदी शक्य काका फोई. ");
INSERT INTO wbq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","इल मालकुड लेशी दरवाजा बंद शेशीनेका. मीर बयट्या नीला फडयार इंगा दरवाजा वाशार इनका आन्या; प्रभू, ना कस्रोम दरवाजा तेरवांडा! गान वाड मिक उत्तर इच्ची, मीर यानुस वच्चीणार इदी नाक यरका लेद. ");
INSERT INTO wbq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","आंट्याका मीर आन्यार, मिम नीसंगा तीनटीम, मिम नीसंगा ताकतीम, मा दावामिंदा नु शिक्षण इस्ती! ");
INSERT INTO wbq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","इनका वाड मिंगलान आनी, मीर यंदुट वच्चीनार इदी नाक यरका लेद, अन्याय शेशातोर मीर आन दार ना तिकनुस दुराम आवंडा. ");
INSERT INTO wbq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","आंदू येडशेद इंगा फंडलु तीनेद नडशी, अब्राहामकी इंगा इसहाककी इंगा याकोबकी इंगा आंता संदेष्ट्यालकी द्यावारदी राज्यला सुश्यार, पण मिक स्वताने बैट्या येशीनोर उंडयार. ");
INSERT INTO wbq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","पुर्वतीनुस, पश्चिमतीकनुस, उत्तरतीकनुस इंगा दक्षिणतीकनुस वच्यार इंगा द्यावारदी राज्यला पंगतला मना-मना जागा मिंदा कुसन्यार. ");
INSERT INTO wbq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","जे आखरीक उंडार वार पहिला आय्यार इंगा जे पहिला उंडार वार आखरीक आय्यार, इदी ध्यानाम फटना.” ");
INSERT INTO wbq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","आयेळक काही परुशाल येशुनतिक वचीर इनका वार वारीक आनीर, “इदूट येळ इंगा दुसरा तिक यकाडा तरी फो, कारण हेरोदाड मीक ठार मत्तीशेतोड उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","येशुड वारीक आन्या, “फो इंका आ कोल्हयाक शेप, 'इन, नीन मंदीलानुट दैय्याम तीशान, इफोद इंगा रेपकाळ रोग बागा शेशान इनका मूडनाळानाड नाद फनी संपवाशान.' ");
INSERT INTO wbq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","इंका बी इफोद, रेफ इंका मरनाड नाक मुंदरा फोवा बेक कारण संदेष्टा यरुशलेम शहरबैटया मतीफोवाला इदी शक्य लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","यरुशलेमे, यरुशलेमे, इदी नू संदेट्यांलाक मतूताव व द्यावारा आनशीनोरक राळ मतुताव! कोडी येल्ला फीलांलाक मना पंकाल किंदा वगाताडल्या तीस्कूंटात आला येल्ला मीर्द मंदीक वगाताडल्या तीस्कूनेद नाद इच्छा उंडया, पण मिद इल्ला इच्छा लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","“सुंडा, परमेश्वर मी इलुद त्याग शेशिंद उंडाद. नीन मीक शेपतान, ‘परमेश्वर फेरगोन धन्यवादिद उंडाला’ इल्ला आनेद वेळ वचीनदण्का मीर ननु सुडांर.” ");
INSERT INTO wbq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","वगा शब्बाथ नाड दिनम वाड पुरूशालक अधिकाऱ्यालपैकी वगान इल्लूक तीनदेन्क फोय्या आप्पुड आंदू जमाशीने मंदी बारकाईगोन नजर फेटीगेस उंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","इनका आंद वानमुंदारा जलोदर आईनोड वगा मनशी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","येशुड नियमशास्त्र शिक्षिकांक इंगा पपरुशीलान आडग्या, “शब्बाथ दिनमुनाड बागा शेशेद नियमशास्त्रक फटी उंडाद की लेद?” ");
INSERT INTO wbq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","गान वार गपाना निलचीर. आप्पुड येशुड आ आजारी मनशिक फटीगेस वान बागा शेशा इंगा वानिक आमप्डीच्या. ");
INSERT INTO wbq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","आनटे वाड वारकी शप्या, “जर मिरपैकी वगारयवांक वगा मोगाबिडा किंवा वगा यद्द उंडाद इंगा वाड बायला फडीनाड, तर शब्बाथ नाळ मीर वानिक लेगेचच बैठ्या तीशातोर लेद येम?” ");
INSERT INTO wbq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","इनका इ प्रश्नद उत्तर इसदेंक वारीक जमाया लेद. ");
INSERT INTO wbq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","इंगा, आंमत्रित सुटाल स्व:ता कस्रोम मान जागाला येल्ला निवडाशी तीसकुनतुनटीर इदी सुशी, वाड वारीक वगा दाखला शेप्या, वाड आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“यप्पुड यवाडाना मीक फेनली मेजवानिक आमंत्रित शेश्यार, आप्पुड मानद जागा मिन्दा कुसनाकंडा येनटिक की मिरकिंटा शना महत्वाद आरवाक वाड कदाचीत आमंत्रण इचींड्याला. ");
INSERT INTO wbq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","मग यवाड मि इदारकी आमंत्रित शेशींनड्यार वाड वच्ची इंगा मिंगलान आनी, इ मंशिक नीद जागा इ. आंटे अपमानिक आइगेस मीक किदोट जागाला कुसना बेक आय्यी, ");
INSERT INTO wbq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","पण यप्पुड मीक आमंत्रित शेशेंद उंडी, आप्पुड फो इनका अगदी कींदोडद जागाला फोय्यीगास कुसुंडा. दिनकस्रोम की, यप्पुड यजमान वच्ची, आप्पुड वाड मीक आनी, मित्रा, फ्यनोड आसनमिन्दा वच्चीगेस कुसून. आप्पुड नी सुट्टाल मुंदारा नीद गौरव आई. ");
INSERT INTO wbq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","येनटिक की यवार स्वतः क उंच शेशताड वाड नमवाशी फइ इंगा जो स्वताक नमवाशी वाड उंच शेशी फइ.” ");
INSERT INTO wbq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","मग यवार आमंत्रण इच्चीद उंड्या वानिक वाड आन्या, “नू यप्पुड मद्याना इंका मापकाडा तीदेंक फिलच्याव आप्पुड मिद मित्रांक, तमुलांक, मिद नातेवाईनकांक इंका श्रीमंताड शेजाऱ्यालक फीलवाकन्डा, आनकेन वार बी निक परत आमंत्रण इच्च्यार इंगा इ रीतीता नीद आमंत्रणाद परतफेड शेशर. ");
INSERT INTO wbq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","पण यप्पुड नू मेजवानी इच्चाव, आप्पुड गरीबबोर, कुंट्योर, पांगळ्याल, गुंड्ड्योर इरिक आमंत्रण इ. ");
INSERT INTO wbq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","आंटे नू धन्य अय्याव, कारण नीद परत फेड शेसदेंकइच्चाका वानतिक यमबी लेद. तर नितीमानांन्द पुनरुत्थानान्द येळक नीद परत फेड आई.” ");
INSERT INTO wbq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","मेजासभवताला कुसूनीन पैकी वगार यप्पुड इदी इन्या, आप्पुड वाड येशुन्क आन्या, “जो परमेश्वर राज्याला रोट्या तीनी, वाड प्रत्तेकड धन्य.” ");
INSERT INTO wbq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","मग येशुड वान्क आन्या, “वगा मन्शी वगा फैदाद वंटाद तैयारी शेशस्तुन्ड्या. वाड सना मंदीक आमंत्रण इच्या. ");
INSERT INTO wbq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","तिनेद वेळला यवारक आमंत्रण इच्चीद उंड्या वारनी ‘दांडा आनकेन आंता तैयार उंडाद’ इला निरोप शेपदेंक नोकरनी आम्प्या. ");
INSERT INTO wbq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","वार आंदार सबब शेप्पदेंक आन्टीर. पहिलावड वान आन्या, ‘नीक शेण कोनकेन तिस्कुनान इंन्का नाक फईगेस आन्दू सुडाबेक. कृपा शेंशी नाक क्षमा शेय.’ ");
INSERT INTO wbq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दूसरावड आन्या, ‘नीन यदुलाद आइद जोड्याला कोनकेन तीस्कूनडान इंगा आटलाद पारक शेदेंक निन फोतोनान, कृपा शेशी नाक क्षमा शेय.’ ");
INSERT INTO wbq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","इंका तीसरावळ आन्या, ‘नीन फेंनडली शेस्कुनान दानकस्रोम नीन दाका फियान.’ ");
INSERT INTO wbq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","वाड कुल्योंड यणका वच्या इंगा वाड मना मालकंक इदी आंनी माटलु शेप्या. आंटे इल्लु मालकुड शीटू लेशा इंका कुल्योंडक आन्या, ‘बेटया दावा मिंदा इंका नगराद फाळयामल लग्गाना फो इंगा गरीब, गुडेर, यवारक शक्य लेद, वारीक कुनटयोरक तीस्केन इकाड दा!’ ");
INSERT INTO wbq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","कुल्योंड आन्या, ‘मालक, नीद आज्ञा लेका शेस्तीन इंगा तरीबी इंन्का जागा खाली उंडाद.’ ");
INSERT INTO wbq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","मालकुड कुल्योन आन्या, ‘दावा मिंदा फोया, कुंपनादेग्गार फोया इला आंद उंडीव मंदीक आग्रहांगोन नोन वचिदेंक शेप आंटे नाद इल्ल निंडी फोई’ ");
INSERT INTO wbq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","कारण नीन मीक शे पतान की, आमंत्रीत मंदीपैकी वागानकी बी ना वंटालोन येम नाकीदेंक शिकाक फोई.” ");
INSERT INTO wbq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","फेदा संख्येने मंदी येशुन संगा न्यडस्केन उंडीर. वाड वारतिक तिरग्या व आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“जर यवाडाना नादेग्गार वस्ताड इंगा मना आब्बाड, आम्मा, वडती, बीळ, तम्मूड, शेल्याल इंन्ताच लेद, तर स्वतः जेमुदसुद्धा द्वेष शेयार, तर वाड नाद शिष्य आयातोड काड. ");
INSERT INTO wbq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जो यवाड स्व:तान्द क्रूस तीस्केन ना ये न्का वच्यातोड काड, वाड ना शिष्य आई शकायाड. ");
INSERT INTO wbq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","जर मीर पैकी यवारक बुरूज कटेद उंड्या तर मुंद्गा कुसुनीगेस खर्चद अंदाज शेशी आदी पुरा शेशदेंक वानदेग्गारा साली इंता दुड्लू उंडाद येम लेद इदी सुशातोर लेद येम? ");
INSERT INTO wbq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","लेद तर कदाचित वाड पाया येशी इंन्का पुरा शेश्यातोर लेर इंन्का जे सुश्यातोर उंडार वार वारद थट्टा शेश्यार इंन्का आन्यार, ");
INSERT INTO wbq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","इ, आरवा कटदेंक सुरुवात शेश्यापण पूर्ण शेषु शकालेद! ");
INSERT INTO wbq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","इंका वगा राजाड दुसऱ्या राजांनसंगा लढाई शेस्देंक येल्या, तर वाड मुंनसरा कुसनी दानीद इच्चार शेषातोड लेद यम? की, वान्द फदी सावर मंदी संगा वान शत्रूसंगा, यवाड इरवाय सावरल सैन्यासंगा न्यडशी वस्ताड, वानिक वान्द सामना शेशेद शक्य उंडाद येम? ");
INSERT INTO wbq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","जर वाड वान्क मुती इचनीदेन्कआयद कादा, तर वान्द शत्रू दुराम अंतरामिन्दा उंडाकाच वाड मध्यस्थ आमशी शांतते इच्चाका सलोख्याद माटा सुरु शेशी. ");
INSERT INTO wbq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","आच प्रकारे मिर पैकी की जो यवाड सर्वस्वाद त्याग शेषा लेद वान्क नाद शिष्य आय्यीदेंक वच्चेद काद. ");
INSERT INTO wbq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","उप्पु बागा उंडाद, पण उप्पुद चव फो, तर दानिक रोसपण येमटीगोन वच्ची? ");
INSERT INTO wbq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","आदी जमीनदी इंका खतादपण पूर्ण पणे नीरुपयोगी ठराशी इंगा मंदी आदी कुकी इचार. यवारक इनदेन्क गुम्माल उंडाय वाड इनाला.” ");
INSERT INTO wbq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","आंदार जकातदार ल इंगा पापी वानदी इनदेक वार देग्गारा वस्तुंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","आप्पुड पुरुशील इंगा नियमशास्त्राद शिक्षक कुरकुर शेसदेंक आन्टीर. वार आन्देक आन्टीर, “इड पाप्यानक देग्गार शेशी वार बराबर तीनटाड!” ");
INSERT INTO wbq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","आंटे येशुड वारीकबी दाखला शेप्या. ");
INSERT INTO wbq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“मि पैकी यवार वगानदेग्गार नूर गोऱ्याल उंडी दान्टलोड वगाट फामी फोया, तर वाड नव्याण्णव शेनला इडशी फामीने गोऱ्यान येनकाक आदी शिकीनंतक फोक फोई येम? ");
INSERT INTO wbq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","इगा यप्पुड वांकी आदी शिक्ताद आप्पुड वाड आनंदागोन दानिक गुजुमिंदा तीसकुनटाड. ");
INSERT INTO wbq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","इंका इलुक वस्ताड, आप्पुड सोपतीलाक इंगा शेजारोर की वगातडला शेशी आन्टाड, नासंगा आनंद शेयडा येनटीक की नाद फामीनेद गोऱ्या शिकीनाद. ");
INSERT INTO wbq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","दानलेका यवार्क पश्चात्तापत गरज लेद इल्ला नव्याण्णव नीतीमानांबद्दल आइंद आनंदाकिटा पश्चात्ताप शेशिनोड वका पापी मनशीबद्दल स्वर्गाला शना आनंद आइ, इदी नीन मीक शेपतान. ");
INSERT INTO wbq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","इंगा वगा आंतीदान देग्गारा यंडी फदी कलदारलू उंडाय इंका जर दांदी वगाट कलदार फोमफोते तर आदी दिवा आनशी इलु झाडशी आदी शिकीनदन्का काळजीपूर्वक फुडकाद यम? ");
INSERT INTO wbq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","इंका दानिक यप्पुड आदी कलदार शिक्की आप्पुड आदी सोबतीनलाक इंका शेजाऱ्यारन्क फिलस्ताद इंका आंटाद, नासंगा आनंद शयना कारण नाद फोमिनेद कलदार शिकीनाद. ");
INSERT INTO wbq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","दानलेका पश्चात्ताप शेशातोड वगा पापी बद्दल द्यावारदूत लामुन्दारा आनंद आताद इदी नीन मीक शेपतान.” ");
INSERT INTO wbq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","इंगा येशुड आन्या, “वगा मानशिक इदार कोडकुल उंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","वार इद्दार किंटा शिन्ना कोडकु आन्या, आब्बा, मालमत्तेलोन नाद वाटा नाक इंडा. आन्टे मग वारद आब्बाड मनाद संपत्ती इद्दार कोडकुलाक फनची इच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","दाननंतर काइ दिनालनंतर लगाना शिन्ना कोडकु मनाद आंता गोळा शेशा इंका दुराम देशाक येळीगेस फोय्या आंदू वाड वानदी आंता संपती चैनीला इंगा मौजमजेद जीवन जगाशी उधळाशी कुक्या. ");
INSERT INTO wbq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","वाड आन्ता दुडलू खर्चाशी कुक्या इंका आंट्याका देशामला भयंकर दुष्काळ फड्या इंगा वानिक गरज भासासदेन्क आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","आ दशानलोन वगा नागरीकदेगारा वाड फो इंका वान्द आश्रय फटीगेस नीलच्या. आ नागरीकोड वान्क मना शेनला फादीलाक तिन्देक आमशिनार. ");
INSERT INTO wbq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","आप्पुड यवाड वान्क यमबी न इयाले, आप्पुड फंदिल आदी काया तिनटाय आदी तिनीगास तरी मनाद कडपू निनडेद इल्ला वारक शन्ना इच्छा आय्यी. ");
INSERT INTO wbq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","दान बाद वाड सुदधीमिन्दा वच्छा व स्वतःन्क आन्या, ना आब्बाड इटल्या यन्ता तरी कुल्योरक साली गेस मिगली इन्त्ता कुड उंडाद इंका सूड निन तर इंद आकालगोन सस्तान! ");
INSERT INTO wbq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","आंटे, निन लेशी ना आब्बानतिक फोतान इंका वान आंनटान, याबा, निन स्वर्गाविरूद्ध इंका निविरूद्ध निन पाप शेशीनान. ");
INSERT INTO wbq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","नी कोडकु आनकेन तीस्कोनेद योग्यताद नीलवा लेद. नाक मनाद चाकराप्रमाणगोन वगा कुल्योर लेका फेट्टीतिस्को. ");
INSERT INTO wbq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","आनंटे वाड शिनाद कोडकु लेशा इंगा मना आब्बान्तिक फो. वाड इलकडानुट दुराम उंड्या आप्पुड, वान् आब्बाड सुश्या इंका वान्क वान्द दया वच्चा इंका फारकेन फईगेस वान्द मेडाला फड्या इंगा वान्द शना मुकाल तिस्कून्या. ");
INSERT INTO wbq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","कोडकु वान आन्या, आब्बा, निन स्वर्गाविरूदध इंगा निविरूद्ध पाप शेशिंद उंडाद. इप्पुड नी कोडकु आनकेन तीस्कुनेद नाक अधिकार लेद. ");
INSERT INTO wbq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","गान आब्बाड मना कुल्योरक आन्या लग्गाना शेयंडा, मनच्चीद झगा यतकेन वानकी यइंडा. वार शेठल्या अंगठी इंगा आणि इंका काळलाला, शपूल फेटानडा. ");
INSERT INTO wbq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","इंका फेदांद वंटा शेइंडा, मनाम तिनटाम इंका आनंद शेसस्ताम! ");
INSERT INTO wbq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","कारण इदी ना कोडकु सच्चीन्द उंड्या पण जिवंत आईडाद! वाड तपिनडया, पण इपूड शिकिन्द उंडाद व वार आंनद शेसदेनक अंटीर. ");
INSERT INTO wbq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","आ याळाक, वान्द फेद्दाद कडकू शेनल्या उंड्या. वाड इलतिक यन्का वच्चा इंका इलूदेगारा वच्चीनंका, वाड गायन वादन व नाचास्तार आदी आवाज इन्या. ");
INSERT INTO wbq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","वाड वगा कुल्योरक फिलचिगेस आडग्या, इदी आंता येम नेडशिन्द उंडाद? ");
INSERT INTO wbq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","वाड कुल्योर वानिक आण्या, निद तंम्मूड वचीनाड. वाड मिरद आब्बांक सुखरूप शिक्या आनकेन वाड फेद्दाद वंटा फटीन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","आप्पुड वाड शिट्टक वच्च्या इंका वाड न्वाना फोवा लेद. आप्पुड वान्द आब्बाड बैट्या वच्चीगेस वानिक समजावासदेन्क आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","परंतु वाड आब्बानकी उत्तर इच्या, सूड, यंताइंडलू नीन मिरद सेवाचाकरी शेशिंद उंडाद इंगा यप्पुडबी निद आज्ञा तेंपाल्या! मित्रालसंगा आंनद शेयदेंक मिर नाक यप्पूड सादा म्याका सुदधा इय्यालेद. ");
INSERT INTO wbq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","इंका यवाड मिद आंता संपती वेश्यांमिंदा उदाळाशा वाड कोडकु यन्काक वच्चादन्द उंडाद आप्पुड मीर वान इच्चाका फेदाद वंटा शेस्तीर. ");
INSERT INTO wbq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","आप्पुड आब्बाड वारनी आण्या, बिडा, नू नेहमी नासंगा उंडाव इंका जे नाद उंडाद आदी आंता निद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","गान इबद मनाम आंनद इंका उत्सवशायाबेक, कारण निद तम्मूद सच्चीन्द उंड्या वाड जिवंत आय्यीनाड. वाड तपिडया, वाड शिक्कीनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","येशुड वान शिष्यलकी ओकाट दाखला शेप्या, “यवाडू वगा श्रीमंताड मन्शी उंडीगेस, वान्द वगाट कारभारीड उंड्या. आ कारभारीड मि दुडल उधळास्ताड, इल्ला तक्रार आ श्रीमंत मनशीदेग्गारा शेसदेंक वच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","आनकेन आ श्रीमंत मनशी कारभारीन नोना फिलचीगेस आन्या, नी इषयला नीन इदी यम इंटूनान? तर इप्पुड नी कारभारीइंदी हिशोब इ, आनकेन इंदुटमुंदार निक कारभार सुशेद लेद. ");
INSERT INTO wbq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","आप्पुड कारभारीड स्वतःक आन्या, ना मालकड नाद कारभारीइंदी फनी तीशी तीस्कूनटार तर नीन इप्पुड येम शेसदून? शेणल्या कष्टाम शेसदेन्क इच्चाका नाता इता ताकत ना फयला लेद इंका भिक आडगेद नाक शिगू वाटस्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ननु कारभारी द फनी मिन्दुल के वार तीशार तरीबी मंदिल नाक वार इंटल्या तिस्कनाला दिनकस्रोम नीन एम शय्याबेक इदी नाक यरका लेद. ");
INSERT INTO wbq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","इंगा कारभारीड वानमालकन्दी आंता कर्जइच्चीनोर कि फीलच्या. पहिलावन वाड आन्या, नु ना मोलकड इकानुट यंता कर्जाम तीस्कीनिंद उंड्या आदी निक फेडाशेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","वाड आन्या, मूड सावेर नुन्या. वाड वान्क आन्या, इदी नीद हिशेबदी वही तीस्को इंका लगाना कुश्नीगेष दिनमिंदा दीड सावेर राय ");
INSERT INTO wbq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","इंका दुसऱ्यान्क आन्या, निक यंता देणा उंडाद? वाड आन्या इरवय सावेर किलो गोदमाल वाड वान आन्या, इदी नीद हिशोबाद वही तीस्को इंका सोळा सावेर राय. ");
INSERT INTO wbq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","अन्यायी कारभारीड शहाणपणा शेश्या. दीनमिंदूट मालकड युगोर मंदी मनलेका विषयला यल्गतूंड मन्शीपेक्षा शहाण्याल उंटार. ");
INSERT INTO wbq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","नीन मीक शेपतान, मीकस्रोम मी अन्यायी दुडलागुना सोबत्याल मिळवायंडा. आइच्चाका की, यप्पूड इदी धन संपाशी आप्पुड वारे मीक आंताकालला वस्ती ला तीस्कीनाबेक ");
INSERT INTO wbq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","वगामींदा रव्वाबी विश्वास फेटेद शक्य उंडाद तर वानमिंदा; सना विश्वास फटदेंक शक्य उंडाद इंका वाड यवाड कडमा माटला विषयला अन्यायी उंडाड वाड शना माटला विषयला अन्यायी उंडेफट. ");
INSERT INTO wbq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","दिनइच्चाका मीर अन्यायी लेका दुडल विषयला विश्वासू लेर, तर मग खरेम दुड्लविषयला मि मिन्दा यवार विश्वास फेट्यार? ");
INSERT INTO wbq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","याद दुसऱ्यालद उंडाद आविषयला मीर विश्वासू लेद तर याद मीद उंन्डाद आदी मीक यवार इच्यार? ");
INSERT INTO wbq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","यादबी नोकरन्की इद्दार मालकुलाद सेवा शेसदेंक दाद. वगानदी वाड शीट शेशी इंगोगोन मिंदा वाड प्रेम शेशी तर वगान वाड फटीगेश नीलची इंगा इंगोगोन कडमा समझाशी. मीर वगाटे दमुक द्यावार्दी इंगा दुडलाद सेवा शेशी शकायार.” ");
INSERT INTO wbq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","इंका आ परुश्याल दुडलाद लोभी उंडीर वार इदी आंता इनीर इंका वार येशुनदी तिरस्कार शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","येशुड वारनी आन्या, “मीर स्वतःन मंशीलमुंदारा नीतिमान आनिगेस मिरवास्तार, पण द्यावार मि मन्सूल वळकास्ताड, याद मन्शीक वारदि कंडलला फेदावर वाटास्ताद आदी द्यावरदि कंडलला अमंगळ उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","मोशेय द नियमशास्त्राम इंका संदेष्ट्याला लेखन योहान बाप्तिस्मा शेशेटोन नंताक उंडीर इंका आप्पुडनुट द्यावार्दी राज्यामदि सुवार्ता गाजवाशीगेष उंडाद इंका प्रत्येकजण दांटल्या दूरदेंग बेग्याता प्रयत्न शेशका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","नियमशास्त्रलोंदी वगाट काना किंवा मात्रा रद्द आया कना मोडाम इंगा पृथ्वी खतम आयेद सोपा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","यवाडबी मना वडतीन इडस्काडताड इंगा इंगोगो फेंडली शेस्कूनटाड वाड व्यभिचार शेस्ताड इंगा यवाडबी, मोगुड इडशींद वडतीसंगा फेंडली शेस्कूनटाड वाड व्यभिचार शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","येवाडू वगावड श्रीमंत मंशी उंड्या वाड जांभळा इंका फिर्याम खादी बट्टल फेटकितोड उंड्या. दिन्नाम वाड ऐश आरामला दिवसल तीस्तुन्ड्या. ");
INSERT INTO wbq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","वान वाकील देग्गार लाजर फेरटोळ वगा गरीब मंशी फडीगेष उंड्या इंका वान-वान फईक फुंडलू आय्यीन्या. ");
INSERT INTO wbq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","आ श्रीमंत मंशीद तीनेद मेज लामिन्दूट येमबी किंदा फडी आदी तरी मनाकतीनेक शिक्की इल्ला आशा शेयदू दानशिवार कुक्काल वच्चीगेस वानदी फोडूल चाटास्तूंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","इंगा इल्ला आया की, वाड गरीबड मन्शी सच्च्या इंका द्यावारदूत अब्राहम देग्गारा फोई फेट्या. इंकाश्रीमंत मन्शीबी सच्च्या इंका वान बुडशीर. ");
INSERT INTO wbq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","श्रीमंत मंशी मृतलोकला नरकला यातनाल भोगास्नेळ उंडया, आंदूट वाड फयना सुशा इंका सनाफयना उंडीनोड अब्राहमनी इंगा लाजरनी वान बाजूक सुश्या, ");
INSERT INTO wbq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","वाड कीर्लीगेश आन्या, हे आब्बा आब्राहाम, नामिंदा दया शयइंका लाजरणी आंप दिनिचांग की वाड बटद टोक नेळाला मुंची ना न्यालकान गार शेशी, येनटिक की इ आग्गीला नीन सना दु:ख सहन शेश्स्तान. ");
INSERT INTO wbq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","पण आब्राहामड आन्या ना कोडकू, ध्यानामला तीस्को की नी जीवनामला यळा निक मंचीय माटलू शिक्या, आल्ला लाजरकी वाईट माटलू शिक्या. पण इप्पूड वांकी आराम शिकतुनाद इंका नू दु:खमला उंडाव. ");
INSERT INTO wbq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","इंका आ आंताशिवाट, मिद इन्का माता वगाट व्ह्यद्दाद दरी फेतीनेद उंडाद, दिन्क्स्रोम कि, इंदूट मिकडा वचदेंक दाद इंका. ");
INSERT INTO wbq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","वाड श्रीमंत मनशी आन्या, इंका निक नीन विनंती शेस्तान कि, आब्बा, लाजरान्क नाद आब्बान इलुक आंप, ");
INSERT INTO wbq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","लाजरानी नाद शीना आईद तम्मूडला देग्गारा व्हय्यीगेस वारक सावध शय्यान आंटे वार तरी इ दु:खल ठिकाणाला वच्चोतोर काद. ");
INSERT INTO wbq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","पण आब्राहामाड आन्या, नी तम्मूडला देग्गारा मोशेड इंका संदेष्ट्याल उंडार वारदी वार इनाबेक. ");
INSERT INTO wbq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","वाड श्रीमंत मन्शी आन्या, लेद, ये आब्बा आब्राहाम, साय वच्चीनाद आंदुट यवार ना तम्मूडला देग्गारा फोयीर तर वार पश्चाताप शेश्यार. ");
INSERT INTO wbq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","आब्राहाम वान्क आन्या, जर वार मोशेन इंगा संदेष्ट्या लेद इने लेद तर सचीनेकेल जर यवार लेशा तरी वारदी खात्री आय्येद काद.” ");
INSERT INTO wbq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","आंटे येशुड वान शिष्यलनी आन्या, “येमटी इचांग मंदी पापुल शेस्तार आयी वचीच पण एमटीगुना आदी वस्ताद वारदि यंता दुर्दशा आई! ");
INSERT INTO wbq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","वाड इ शीन्ना शिनोर लोन्केल वगान पापुल शेसदेंक आनशेपेक्षा वांदी गोन्तुला जात्यांद तळी कट्टीगेस वांकी समुद्राला कुक्काबेक दिंटल्या वांन्दि हित उंन्डाद. ");
INSERT INTO wbq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","स्वतः कडा ध्यानाम इंडा! जर मि तम्मूड पापलू शेस्ताड तर वान्क धमकवाय इंका जर वाड पश्चाताप शेस्ताड तर वान माफ शेयना. ");
INSERT INTO wbq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","जर वाड फग्लनुट योड वेळा नीविरुद्धला पापुल शेस्ताड इंका योड टायमक निकडा वस्ताडइंका आंताड, नीन पश्चाताप शेस्तान, तरी पण वान्क माफ शेय.” ");
INSERT INTO wbq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","मग प्रेषित प्रभूयेशुंक आनीर, “माद विश्वास वाढवाय.” ");
INSERT INTO wbq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभु येशुड आन्या, “जर मिंद विश्वास मोहऱ्याल दाण्याल आंता उंडाद तर मीर इ तूत्तीद माकन आनी शकास्तार, मुळासकट उपटाशीगेश समुद्रला आन्शीगेश फो. तर आदी शटू मिद इनी. ");
INSERT INTO wbq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","मी पैकी इल्ला यवाड उंडाड की, वांदी नांगरशेतोड इंका गोऱ्याल राकाशेतोड कामगारड शेननुट वच्चीनका वाड वान्क आन्यार, ‘इप्पुडे वच्चीगेस तीन्नेक कुसून.’ ");
INSERT INTO wbq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","उलटा नादे वंन्टा तैयार शेय, ‘नाद तिन्नितागी आय्यींतका नडमुल कटीगेश नाद सेवा शेय इंका इंगा नु तीन इंका ताग,’ इल्ला वाड वान्क आनेद काद येम? ");
INSERT INTO wbq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","आ गोष्टील आदी शेशेडबद्दल मीर कामगारन्क हुकुम शेस्तार आदी शेसदेइच्चाका मीर वान्क धन्यवाद आंटार येम? ");
INSERT INTO wbq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","मी बाबतलाबी आलाच उंडाद. यप्पुड मिक शेसदेंक वच्चींदि आंता फनील शेशिनेन्का मीर इल्ला आना बेक, मिम यादबी मानद लायकिक लेंकुंडी कामगारड उंडाम मिम फक्त माद कर्तव्य शेशिनाम.” ");
INSERT INTO wbq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","इंगा इल्लाआय्या की, येशु यरूशलेम शहरकडा फोतुंड्या आप्पुड, शोमरोन इंका गालील प्रांताधि सीमाल दिंटनुट फोय्या. ");
INSERT INTO wbq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","वाड यादूवगा उरूक फोयेत आप्पुड आंदू वांकी कुष्ठरोगगुना ग्रस्त फदी मन्शील भेटाशीर ");
INSERT INTO wbq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","इंका वार दुराम नीला फडीगेस बेग्याबेग्याता किरलीगेश आनीर “येशुड, स्वामी, मामिंदा दया शयंडा,” इल्ला आनिगेष वार वान्कडा आवाज शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","आप्पुड येशुड कुष्ठरोग्यालक सुशा, आप्पुड वाड वान आन्या, “फोंडा इंका स्वतःक याजकालकी सुपंडा.” वार याजकदेग्गारा फोय्येद आप्पुडच शुद्ध आय्यीर, ");
INSERT INTO wbq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","यप्पुड वारतूट वगाड सुशा कि मनाम बागा आयीनाम आप्पुडवाड वापस वच्च्या इंका वाड बेग्याता किरलीगेश द्यावारदि गौरव शेयदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","वाड येशुंदी कालदेगारा किंदा फड्या इंका वान्द वान्क काळ मोक्या. आळेच वाड वान्दी उपकार मानाश्या. वाड वगा शोमरोनीड देश्मोड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","येशुड वान आन्या, “फदीजण शुद्ध कालेर येम? इंकातोमिद मन्दी यंद उनार?” ");
INSERT INTO wbq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","इ विदेशी मन्शीशिवाट यवारबी द्यावरदि गौरव शेयदेंक वापस दालेड येम? ");
INSERT INTO wbq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","वाड वान आन्या, “लय इंका फो, नीद विश्वास नीनु बागा शेशिनाद.” ");
INSERT INTO wbq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","परुश्याल येशुन आडगिर, द्यावारदि राज्य यप्पुड वच्चाफट, येशुड वार्की उत्तर इच्च्या, “द्यावारदी राज्याम कमशेद स्वरूपला वच्चेद काद. ");
INSERT INTO wbq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","सुडना, आदी इंद उंडाद इंका आंद उंडाद! इल्ला आणार येनटिक की द्यावारदी राज्याम मिता उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","शिष्यालक वाड आन्या, “मनशी कोडकु वच्चेद दिनालपैकी वगा दिवसदी मीर आतुरते गोंन दावा सुशार. पण आ दीनाम मीर सुशोतोर काद, इल्ला दिनाल वची. ");
INSERT INTO wbq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","इंका मंदी मिमलान आन्यार, सूड, वाड तर इंद उंडाड तर सूड, वाड आंदू उंडाद, आप्पुड मीर ननु सुदेंक वारयंकाक फोयेद लेद. ");
INSERT INTO wbq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","येनटिक की यल्ला विज आकाशला वगा सीमाकेल दुसरा सीमा नंताक चमकास्ताद आला मन्शीद कोडकुद वच्चेद वांनदे दिनालला आताद. ");
INSERT INTO wbq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पण पयला वाड दु:ख भोगाशेक बेक इंका पिढीइकानुट नाकारशेक बेक दिंद अगत्य उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","येल्ला नोहान दिनालला आय्या आल्ला मन्शीद कोडकु दिनालला पण आय्याफट. ");
INSERT INTO wbq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","नोहाड जहाजला फोया इंका नेळादप्रलयगुना वच्चीगेस आंदारदी नाश आय्या दिनमूनंतक मशील तिनका उंडीर, तागकेन उंडीर, फेनली शेशकेन उंडीर इंका फेंडली शेशी इस्तूंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","दानलेका, लोटाद दिनालला आय्या आल्ला आयीफट: वार तिनकेन उंडीर, तागकेन उंडीर. कोनकेन तीस्कूनदूर. आंबका बी उंडीर. लागवड शेस्तुंडीर. कटका उंडदूर ");
INSERT INTO wbq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पण या दिन्मक लोट सदोम इडशीगेस बैटा येल्ला आ दिन्मक आकाशनुट आग्गी इंका गंधामदी दिन्दी वाना फड्या इंका आंदारदी नाश शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","मन्शी कोडकु प्रगट आयेंद दिन्मकबी इल्ले आयाफट ");
INSERT INTO wbq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","आ दीन्मक जर वगाड छतमिन्दा उंडाड इंका वांनदी सामान इंटल्या उंडाद, तर वाड आदी बैटा तीशेइच्चाका इंटल्या फोयेद लेद. दानलेका यवाड शेणल्या उंडाड वाड परत फोय्येद लेद. ");
INSERT INTO wbq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लोटद वडतीद आठवण शेयंडा. ");
INSERT INTO wbq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","यवार यवाड मनाद जेम वाचवाशेक सुस्ताड वाड मनाद जेम गमवाशी इंका यवार यवाड मनाद जेम गमवाशी वाड दान वाचामती. ");
INSERT INTO wbq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","नीन मिक शेपतान, आ मोब्बला बिछाना मिंदा इदार उंड्याला, दांटल्यानुट वगाट तीस्कीनेक वस्ताद इंका दुसराओन्क फटदेन्क वस्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","इद्दार आंडेर इस्रायमिंदा इस्रूतुंटे, तर दाननुट वगाट तीस्कीनेक वस्ताद इंका दुदुसरा दान दुसराद फेटदेन्क वस्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","शेणला इद्दार उंडीर वगावन तीस्कीनी इंका दुसऱ्यान्क फेटदेन्क वस्ताद.” ");
INSERT INTO wbq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","शिष्यल वान आडगिर, यंदू प्रभू? येशुड उत्तर इच्या, “यंदू सच्चीनोर उंडार आंद ग्यदाल जमा आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","निराश आय्येद लेद तर दिनाम प्रार्थना येल्ला शय्याबेक इदी शिष्याल न्यरवाबेक, आनकेन वाड वारकी वगाट दाखला शेप्या. ");
INSERT INTO wbq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","वाड आन्या, “वगा नगरला वगा न्यायाधिशड उंड्या. वाड द्यावार्की यर्स्कुना कुंदू इंका मन्शीकबी सम्मान फेटकेन लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","आ नगरला वगा विधवाद उंड्या. आदी दिन्नाम वच्चीगेश न्यायाधिशनि आन्का उंडदू, ‘ना इरोधक विरोधला नाद न्याय शेय!’ ");
INSERT INTO wbq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","वांदी इच्छा रव्वा काळ लेकुंड्या पण शेवटक वाड मनला आन्या, 'नीन जरी परमेश्वरकी आद्रकुंड इंका मन्शीलाक मान इयान, ");
INSERT INTO wbq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तरीआ, विधवा नाक तरास इस्ताद आनकेन नीन दान्दी न्याय शेशान, लेद तर आदी दिन्नाम वच्चीगेश नाक सना त्रास इची होताद.” ");
INSERT INTO wbq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","मग प्रभूड आन्या, “ध्यान इंडा अन्यायी न्यायाधीशड येम आन्या. ");
INSERT INTO wbq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","इंका मग याद परमेश्वर निवडाशिंद मन्शील दिन्म -मोब्ब वांन्दी धाव शेस्तार वारदी वाड न्याय शेशेतोड लेद येम? वाड वार्क मदत शेसदेंक वेळ लावाशी येम? ");
INSERT INTO wbq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","नीन मिक शेपतान, वाड वारदी न्याय लग्गाना शेशाफट, तरीपण यप्पुड मन्शी कोडकु वच्याफट, आप्पुड वानकी पृथ्वीमिंदा विश्वास आढळाशी येम?” ");
INSERT INTO wbq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","मनाम नीतिमान उंडाम इळा यवार अंधार स्वतःविषयला विश्वास फेटी दुसरा अंधारक तुच्छ मानास्तूंडीर वारकबी वाड दाखला शप्प्या, आदी इल्ला, ");
INSERT INTO wbq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“इद्दार जण प्रार्थना शेसदेंक फयना द्यावार भवनला फोय्यीर. वगा परुशी उंड्या इंका दुसरा ओड जकातदार उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","परुशाड निला फड्या इंका वाड इल्ला प्रार्थना शेशा, ‘हे परमेश्वर, नीन नीद उपकार मानास्तान येनटिक की, नीन दुसरा मंदील्यका आंटे दोंगा, अन्यायी, व्यभिचारी इंका इ जकातदार लेका लेद. ");
INSERT INTO wbq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","उलटा नीन वारामला रोन्ड तीकुल उपास शेस्तान इंका ना अंता उत्पन्नद दहावा भाग इस्तान.’ ");
INSERT INTO wbq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","पण जकातदार दुराम नीला फडीगेश फोयना स्वर्गकडा कनलु आन्शेक न धजवाजता मना यदामिंदा मत्तीगेश आन्या, ‘हे द्यावार ना पाप्यामिन्दा दया शेय.’ ");
INSERT INTO wbq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","नीन मिक शेपतान इ मन्शी आ दुसरा मन्शी पेक्षा न्यायी ठराशीगेश इल्लूक फोंडा येनटिक की यवार यवाड स्वतान फेद्दावड शेस्ताड वान्क कडमा शेसदेंक वच्चाफट इंका यवार यवाड स्वतान कडमा शेस्ताड वानकि वाद उंच शेसदेंक वच्चाफट.” ");
INSERT INTO wbq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","इंका मन्शील मना बिळालकबी वानतीकुड स्पर्श शेदेंग येकास्तानी इदी शिष्याल सुशीनेका वार मंदीक धमकामतीर. ");
INSERT INTO wbq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","पण येशुड बीळ्ळाल्क मनादेग्गार फीलचीगास आन्या, “बीळाल्क नादेग्गार दानीनडा. वारक अडवाशेक वद्दो येनटीक की द्यावार राज्याम राज्य वारलेकाने उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","नीन मिक खरेम शेपतान, यवार यवाडबी बीळलालेका द्यावार राज्यद स्वीकार शेयाक फोई, वान्दी स्वर्गला प्रवेश आय्येद काका फोई.” ");
INSERT INTO wbq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","वगा यहुदी अधिकाऱ्याड वान आडग्या, “उत्तम गुरुजी, अंताकालिक जीवन शिकदेनइच्चाका नीन येम शेयदून?” ");
INSERT INTO wbq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","येशुड वान आन्या, “नाक बेस येल्ला आन्टाव? द्यावारशिवाय यवारबी शिंगार लेड. ");
INSERT INTO wbq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","निक आज्ञाल यरका उंडाय ‘व्यभिचार शेयाक, खून शेयाक, दोन्गा शेयाक, बेका साक्ष इयाक, नी आम्मा आब्बांद मान फेट.’” ");
INSERT INTO wbq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","वाड अधिकारीड आन्या, “इ आंता आज्ञाल नीन ना जवान उंटीन आप्पुडनुट पाळाशिंद उंडाय.” ");
INSERT INTO wbq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","यप्पुड येशुड आदी इन्या, आप्पुड वाड वान आन्या, “नीता इंका वगा माटा कडमा उंडाद. निदेगारद आंताएमबी आम्मीगेश आदी गरिबोरकी इ, आंटे स्वर्गला निक दुडलु शिक्क्याफट. इंका दा. ना यंका फदा.” ");
INSERT INTO wbq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","पण यप्पुड आ अधिकाऱ्याड इदी इन्या आप्पुड वाड सना दुःखी आय्या, येनटीक की वाड सना श्रीमंतड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","वाड दुःखी आय्य फोंडा इदी यप्पुड येशुड सुशा आप्पुड वाड मंदीक आन्या, “यवारदेगारा संपत्ती उन्डाद, आ मंदीद द्यावार राज्यामला प्रवेश आय्येद यंता कठीण उन्डाद! ");
INSERT INTO wbq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","हा, श्रीमंत मन्शीद द्यावार राज्याला प्रवेश आय्येद दानपेक्षा वंट्याद सुदीद मुक्कुनूट फोयेद सोपा उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","आन्टेगा या मन्शील आदी इनीर, वार आनीर, “आंटेगा यवारद तारण आय्या फट?” ");
INSERT INTO wbq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","वाड आन्या, “या गोष्टील मन्शील्क अशक्य उंन्डाय आदी द्यावार्की शक्य उंडाय.” ");
INSERT INTO wbq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","आन्टेगा पेत्रड आन्या, “सूडंडा, मादेग्गार येम उंड्या, आदी आंता येशीगेस मिम मि यन्का वच्चीनाम.” ");
INSERT INTO wbq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","येशुड वारक आन्या, “नीन मिक खरेम शेपतान, परमेश्वर राज्यइच्चाका यवाड मनाद इल्लू, वडती, तम्मूड, आम्मा अब्बाड इंका बीळ्ळाल्क इडशीर ");
INSERT INTO wbq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","वारक इ युगोर क सना पटीगुणा इंका वच्चे युग ला आंताकलिक जीवनाम शिक्केद लेद इल्ला यवाड लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","येशुड निवडाशिन्द बाराजनाल्क बाजूक तीश्केन्या इंगा वार्की आन्या, “इनंडा! मनाम मिंदा यरुश्लेम शहरला फोतुनाम उंडाम इंका संदेष्टंतोड मन्शीद कोडकु विषयला याद येमबी राशिंदी उंडाद आदी आंता पूर्ण आई. ");
INSERT INTO wbq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","आन्टेगा वांकी परराष्ट्रीयालदी हवाली शेशाफट, वान्दी थटा आय्याफट, वान्दी निंदा शेशाफट, वानमिंदा उंचार ");
INSERT INTO wbq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","वांकी फटकाल इच्चार, इच्चार जेम तीस्कीन्याफट इंका वाड तिसरा दिन्मक इंन्का लेशाफट.” ");
INSERT INTO wbq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","वाड आनीन्दी येमबी शिष्यालक समजया लेद येनटिक की इदी वचनाम वारदेगारनुट लपवाशी फटीदेंक वच्चीनाद इंका वाड या माटलाविषयला माटलाडतुन्ड्या आदी वारक यरका लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","येशुड यरीहोदेगारा वस्तूड्या आप्पुड वगा गुडेळ दावामिंदा कुशनीगेस भिक आडगतुन्ड्या. ");
INSERT INTO wbq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","यप्पुड आ आंधळा मन्शी देग्गारनुट फोय्येतोर मन्शिल्द आवाज इन्या आप्पुड वाड आडग्या, इदी येमटीद गडबड न्यडशीनाद. ");
INSERT INTO wbq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","मन्शील वान्क शेप्पीर, “नासरेथकर येशुड देग्गारनुट फोतूनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","वाड किरलीगेश आन्या, “अरे येशू, दाविदान्द कोडकु नामिंदा दया शेय.” ");
INSERT INTO wbq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","यवार मुंदारा न्यडसतूंडीर वार वान्क चूप कुसुदेंक शेप्पीर. पण वाड इंका बेग्याता कीर्लीगेश आन्या, “दाविद कोडकु नामिंदा दया शेय!” ");
INSERT INTO wbq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","येशुड थांबाशा इंका वाड गुड्डेन स्वतःदेगारा एकोचेद आज्ञा इच्च्या, वाड गुडन देग्गार वचीनेका येशुड वान्क आडग्या, ");
INSERT INTO wbq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“नीन नीइच्चाका येम शय्याबेक आनकेन नीद इच्छा उंडाद?” वाड आन्या, “प्रभू नाक इंका दृष्टी दाबेक.” ");
INSERT INTO wbq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","येशुड वान आन्या, “निक दृष्टी दाला, नी विश्वास निक बागा शेशिंद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ताबडतोब वान्क कमशेक आंट्या इंका वाड द्यावारदीगौरव शेस्केन येशुंदी यंकाक फोय्या आंता मंदी इदी सुशीर इंका द्यावार्दी स्तुती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","येशुड यरीहोला प्रवेश शेशा इंका दानलोन्केल फोतुन्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","आप्पुड सुयंड, जक्कय फोयेतोड यवाड वगा मन्शी उंड्या, वाड मुख्य जकातदार उंडीगेश सना श्रीमंतड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","येशुड यवाड उंडाड इदी सुशेद वाड प्रयत्न शेस्तूंड्या पण गर्दीमुळा वान्दी येमी न्यडवाद, येनटिक की वाड गिड्डा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","आप्पुड वाड आंधारमुंदारा फारका फोया इंका येशुंक सुदेंक वगा उंबराद माकमिंदा यक्क्या कारणाम वाड आच रस्तागुना मुंदारा फोयेतोड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","इंगा येशुड आठीकाणक वस्ताद कनला मिंदा शेशीगेस वान आन्या, “जक्कय, लग्गाना कींदा दिगीगेश दा, येनटिक की इबद नाक नी इंटल्या दिगेद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","आप्पुड वाड लग्गाना किंदा दिगीगेश आनंदगुना वान्दी आगत स्वागत शेशा. ");
INSERT INTO wbq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","इदी सुशीगेश आंता मंदी कुरकुर शेशीर की, “पापुल मनशी इंटल्या वाड निल्चेंक फइनाड.” ");
INSERT INTO wbq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","आप्पुड जक्कयाड निला फडीगात प्रभून आन्या, “प्रभुजी, सूडंडा, नीन नाद आर्धाम संपत्ति गरीबलक इस्तान इंका नीन अन्यायगुना यवारदि येमबी तश्कीनीटे तर आदी चारपटगुना वापस.” ");
INSERT INTO wbq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","येशुड वान आन्या, “इबद इ इल्लद तारण आयेद उंडाद येनटिक की इ मनशीबी अब्राहम कोडकू उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","येनटिक की मनशी कोडकू यवार हरवाशिनार वारन सुसदेंक इंका तारणचांग वचीन्द उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","वार इ माटल इनतूंटीर आप्पुड वाड वारक वगाट दाखलाबी शेप्या येनटिक की वाड यरुशलेम ऊर देग्गारा उंड्या इंका द्यावार्दी राज्य इप्पुडे प्रकट आय्येद उंडाद इळा वारक वाटास्तुन्ड्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","वाड आन्या, “यवारवगाट उमराव, मनाम राज्याम मिळवाशीगेश वापस दाला आ उंद्देशगुणा दूरदेशक फोया. ");
INSERT INTO wbq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","वाड मना फदी दासलान फिलच्या इंगा वारकी फदी कलदारलू शेप्या, ‘नीन वच्चीतका दिनमिन्दा व्यापार शेयना.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","वान्दी नगराद मन्शील वान्दी शिट्ट शेस्तार आन्केन वार वान नगरलोन मंदी वांदी शीटू शेयदूर शप्पीर, ‘इड मामिंदा राज्य शय्याबेक इल्ला माद इच्छा लेद.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","मग इल्लाआय्या की, वाड राज्य मिळवाशीगेश इंगा वापस वचीनेन्का वारकी वाड व्यापार शेयदेंक दुडलू इचीन्या उंड्या, दानमिंदा यंता नफा आय्या इदी त्यलवाबेक आनकेन दासलक आज्ञा इच्चीगेश वारक फीलच्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","पयलांड मुंदार वच्च्या इंका आन्या, ‘मालक नू इचीने कलदारला मिंदा नीन इंगा फदी कलदारलू कमास्तीन’ ");
INSERT INTO wbq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","आप्पुड वाड वांकी आन्या, ‘मंची दासड, बागा शेस्तीव, नु रव्वाविषयला विश्वासू आय्यीनाव, आनकेन नु दहा नगरलामिंदा अधिकारी आय्याव.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","मग इंगोगाड वच्या इंका आन्या, ‘मालक, मिद आयद कलदारला मिन्दा नीन आयीद नाणील इंका मिळवाशीनान.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","इंका वाड वांकी आन्या, ‘नु आईद नगरामिन्दा उडयाव.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","मग इंका व अधिकारी दास वच्या इंका आन्या, ‘नु इचीनेय कलदारलु नीन दस्तीला कटीगेश फेटीनटीन. ");
INSERT INTO wbq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","नू कठोर उंडाव, याद मीर फटींद लेद, आदी मीर तिस्तार या आनशिंद लेद, आदी कोस्ताव, आनकेन नाक नीद बिता वाटादू,’ ");
INSERT INTO wbq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","वाड वांकी आन्या, ‘दुष्ट दास, नीद माटागुना नीन मिद न्याय शेस्तान, निक यरका उंड्या की नीन कोडकु शिस्तीद मणशी उंडान नीन याद इच्चीन्दी लेद आदी तीस्कीटान इंका याद आन्शिंद लेद आदी कोस्तान, ");
INSERT INTO wbq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तर नु नाद दुडल पेढीमिंदा येनटीक फेटाल्या? इंगा यप्पुड नीन परत वस्तीन आप्पुड आदी नाक व्याजासकट शिकतुंड्या.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","वानदेगारा नीला फडीडीर वारक वाड आन्या, ‘वानदेग्गार केल आई कलदारलु तीस्कोंडा इंका यवारदेग्गार फदी कलदारलु उंडाय आई तीस्कुंडा, वांकी इंडा.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","वार वान्क आनीर, ‘मालक, वानद्यग्गारा पहिला ने फदी नाण्याल उंडाय.’ ");
INSERT INTO wbq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","मालकुड उत्तर इच्या, ‘नीन मिक शेपतान, येवारदेग्गार उंडाद, वान्क इन्का इदेंक वच्याफट इंका येवारदेग्गार लेद, वानदेग्गार येमबी उंन्डाद आदिसुद्धा तीस्कूनदेंक वच्याफट. ");
INSERT INTO wbq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पण नीन राज्य शेशेद लेद इल्ला इच्छा शेशेतोरदी ना दुश्मनलान इकाडा येकादांडा इंका नामुंदारा मतेसकडना.’” ");
INSERT INTO wbq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","येशुड आ गोष्टील शेप्पीनेका वाड फेयना यरुशलेम ऊरद्यग्गारा फोया. ");
INSERT INTO wbq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","वाड मिंदीक फोतूनड्या आप्पुड, यप्पुड वाड जैतूनदी क्वंडा आनिंदी टेकडीदेग्गार उंडीद बेथफगे इंका बेथानीदेगारा वच्या आप्पुड वाड मना रोंड शिष्यालक फिल्चीगास इला शेप्पिगास आम्प्या, ");
INSERT INTO wbq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","इंका आन्या, “मिमुंदारा उंडीद उरला फोनडा. मीर प्रवेश शेस्तार आप्पुड, दानमिंदा यवार कुन्शींद लेद इळोटीद गदाडी पिल्ला मिक कटीद कमशाफट. आदी इडशीगेस आंदुट येतांडा. ");
INSERT INTO wbq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","जर मिक यवार आडगिर की, ‘मीर आदी येल्ला इडस्तार? तर आनन्डा की, प्रभून की दिंदी गरज उंडाद.’” ");
INSERT INTO wbq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","यवारक आम्पीन्या, वार फोयीर इन्का वाड शेप्पीने लेका वारक आढळाश्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","आदी गाडदी पिल्ला इंडस्तूंटीर आप्पुड वान मालकड वारक आन्या, “मीर गाडदी पिल्ला येनटीक इडस्तार?” ");
INSERT INTO wbq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","वार आनीर, “प्रभूनकी दिंदी गरज उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","वार आदी येशुन तीकुड येकोचीर. वार मना आंगील गाडदी पिल्ला मिन्दा येशीर इंका येशुन्क दानमिंदा कुसनामतिर. ");
INSERT INTO wbq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","येशू रस्तामिन्दा फोतुंड्या आप्पुड मन्शील मना बट्टाल रस्तामिन्दा पसरवास्तूंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","वाड यप्पुड जैतून कोंडा उतारमिंदा वच्च्या आप्पुड आंता शिष्यालदिसमुदाय, वार याद चमत्कार सुशिंदी उंड्या दानइच्चाका फेद्दा आनंद गुना परमेश्वरद स्तुती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","वार आनीर, “प्रभूनदी फेरगुणा वच्चेतोड राजा धन्यवादला उंडान! स्वर्गला शांती इंका मिन्दिकाना बी मिन्दिक मोढामला गौरव.” ");
INSERT INTO wbq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","जमाव उंड्या दाटल्यानोट रव्वा परुशील येशुंक आनीर, “गुरुजी, मी शिष्यलाक गप कूसनेक शपंडा.” ");
INSERT INTO wbq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","वाड उत्तर इच्या, “नीन मिक शेपना, जर वार शांत कुसूनीर तर इ राळ किरली.” ");
INSERT INTO wbq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","वाड यप्पुड देग्गार वच्या इंका वाड उरीक सुश्या, आप्पुड वाड दान्कास्रोम यडशा इंका आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“या माटलू निक शांती इच्च्याव्हाट आदी जर इबद नु जाणाशीगेष तीस्कीनाव तर! पण इप्पुड आ नी कडलामुंदारनुट लपवाशी फयदेंक वच्चेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","निमींदा इल्ला दिनाल वच्च्याव्हाट की, नी वैऱ्याल निभोवतालला कडाल निलचार. निक वेढा इच्चार इंका आंता बाजूगुना निक कोंडाशी फेट्यार. ");
INSERT INTO wbq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","वार निक, नी बीळलाक नी गोडालन धुळीला मिळवाश्यार इंका राळामिन्दा राळ नील्ची फटेतोर काद कारण नु द्यावारदी निकडा वच्चेद वेळ नु वळकाशालेद.” ");
INSERT INTO wbq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","येशुड परमेश्वर भवनला प्रवेश शेश्या इंका आम्मेद फनी शेस्तूंडीर वारक बैयटा तिदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","इंका वाड आन्या, “पवित्र शास्त्रामला इला राशिंद उंडाद की, नाद इल्ला प्रार्थनाद भवन आई, पण मीर दान लुटाशेतोरदी गुहा शेशिनार.” ");
INSERT INTO wbq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","वाड दिन्नाम परमेश्वर भवन नरपतुंड्या. मुख्य याजकड मनशी, नियमशास्त्राद गुरुजीर, मन्शीलद पुढरीड वानक ठार मत्तेइच्चाका प्रयत्न शेस्तुंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","पण आला शेसदेइच्चाका वारक येमी दावा शिक्का कुंदू येनटिक कीअंधार मन्शील वान्दी मन आंची इनदूर. ");
INSERT INTO wbq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","वगा दिन्मुनाळ येशुन परमेश्वर भवनला मन्शीलक शिक्षण इस्तूंड्या आप्पुड इंका सुवार्ता शेपतुंड्या आप्पुड, मुख्य याजक मनशी, नियमशास्त्राद शिक्षकड इंका आब्बागार वक्ताडा फयना वानतीकुड वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","वार वान आनीर., “या अधिकारगुना नु इ माटलु शेसकेन उंडाव इदी माक शेप, निक इदी अधिकार यवार इच्चीर?” ");
INSERT INTO wbq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","आप्पुड वाड वारक उत्तर इच्या, “निनसुद्धा मिक ओकाट प्रश्न आडूगुतान मीर नाक शेपुना. ");
INSERT INTO wbq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","योहानदी बाप्तिस्मा स्वर्गतीकुनुस उंड्या की मनशीतीकुनुस उंड्या?” ");
INSERT INTO wbq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","वार आपसला चर्चा शेशीर इंका वगामेगारक आनीर, “जर मनाम स्वर्गतीकुनुस आंटाम, तर वाड आन्या फट, ‘तर मग मीर वानमिंदा विश्वास येल्ला फटा लेद?’ ");
INSERT INTO wbq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","जर मनाम मन्शी मनशीतीकुनुस आनाला, तर आंता मंदी मनाक रायीदमार शेश्यार येनटीक की वारद खात्री उंन्डाद कि योहान आ वगाट संदेष्टा उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","आनकेन, “वाड यवारद्यग्गारनुट उंड्या इदी मनाक यरका लेद.” इला वार वारक उत्तर इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","मग येशुड वारक आन्या, “मग नीनबी आ कथाल या अधिकाऱ्याड शेस्ताड इदी नीनसुद्धा मिक शेप्पान.” ");
INSERT INTO wbq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","इंगा वाड मंदीक आ दाखला शेपाक उंड्या, “वगा मंदीक द्राक्षालद शेण आनशा इंका वाड रव्वा शेतकऱ्यालक मोलगोंना इच्चीगेस सना दिनालइच्चाका परदेश फोय्या. ");
INSERT INTO wbq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","हंगामदि वेळक वाड नोकरनक शेतकऱ्यालकडा आमशा. आइच्चाका की, वार द्राक्षालशेनद रव्वा फळाल इय्याबेक. पण शेतकऱ्याल आ नोकरन्क मत्तीर इंका उत्ता शेइता वापस आम्शीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","आंन्टे वाड इंगोगा नोकरनी आम्प्या, वार पण वान्कबी वार मत्तीर. आ नोकरनी वार अपमान शेशी लेका वागाशीरइंका रिकामा शेतगुना यन्काक आम्पीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","आप्पुड वाड तिसरा नोकरनी आम्प्या. पण वान बी वार जखमी शेशिगेस बयटा फेकास कडीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","अंगूरला बगीचा तोड मालकड स्वतं आन्या, ‘नीन येम शेसदून? नीन ना स्व:ताद प्रिय कोडकू आमस्तान. कदाचीत वार वानकी मान इच्यार.’ ");
INSERT INTO wbq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","पण यप्पुड शेतकऱ्याल कोडकू सुशीर, आप्पुड वार आपसला चर्चा शेशीर इंका आनीर, ‘इड तर वारसड उंडाड, मनाम वान मत्तेदाम, आंटे वतनाम मनाद आयी.’ ");
INSERT INTO wbq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","वार वान अंगूर बगिच्यालोनुस बैटीक फेकेशीर इंका मत्तेशीर. तर मग अंगूरला बगिच्या लोन मालकुड येम शेशी? ");
INSERT INTO wbq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","द्राक्ष बाग मलकोड वच्च्याव्हाट इंका आ शेतकऱ्यालक मतेशाफट इंका आ अंगूरलाद बगिच्या इंगोगानकी इचकाडी.” वार मंदी इदी इनीर आप्पुड वार आनीर, “इला यपोदुच का रोद.” ");
INSERT INTO wbq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","येशुड वारतीकुड सुशा इंका आन्या, “तर मग याद राय कट्टेतोर सुद्धा नाकारशीर आदीच कोनशीला आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","यवार यवाड दानमिन्दा फडीर वानी तुकडाल आई पण या यवाडमिन्दा आदी फडी वानदी चुराडा आयी.” ");
INSERT INTO wbq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","नियमशास्त्राद शिक्षक इंगा मुख्य याजक मन्शील वार आ वेळला वान्क अटक शेशेद प्रयत्न शेशीर, पण वारकी मन्शीलद यरपू वाटास्तुंड्या. वारकी वान्क अटक शेशेद उंड्या, कारनाम वारकी यरका उंड्या कि, इ दाखला वाड वार्कच उद्देशगुना शेप्पिनेदउंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","आप्पुड वार वानमिन्दा पाळन फटीर इंका वान्क माटाला फटीगेश राज्यपालाद इंका अधिकाऱ्यांद आधीन शेय्याला आनकेन मनाम प्रामाणिक धार्मिक उन्डाम इला भासवाशातोर हेर आम्शीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","आनकेन आ हेराल वांकी प्रश्न आडगिर. वार आनीर, “गुरुजी, माक यरका उंडाद की, येट खरेम आदी मीर माटलडस्तार व नेरपुतार इंका मीर पक्षपात शेशेलेद. तर सत्यगुना द्यावारदी रस्ता नेरपूतार. ");
INSERT INTO wbq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","मिम कैसरकी कर इय्याबेक इदी योग्य उन्डाद किंवा लेद?” ");
INSERT INTO wbq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","वार धूर्तगुना मनाक फसामतूदेंक सुस्तोनार दिंदी येशुन की कल्पना उंड्या. आनकेन वाड वारकी आन्या, “नाक वगाट कलादर सुपिंडासुपंडा. ");
INSERT INTO wbq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","दानमिंदा यवार्दी प्रतिमा इंका लेख उंडाद?” वार आनीर, “कैसरदी.” ");
INSERT INTO wbq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","आप्पुड वाड वारकी आन्या, “कैसरदी आदी कैसरकी इंका आदी द्यावारकी इंडा.” ");
INSERT INTO wbq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","आप्पुड मन्शीलमुन्दरा वाड याद येम माटलाड्या दांटल्या वान्क फटेद वारकी शक्य आव्वा लेद. वान्दी उत्तरगुना वार आश्चर्यचकिला आय्यीर इंका निरुत्तर आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","इंगा पुनरुत्थान लेद इला आनेतोर रव्वा सदूकिल वानतीकुड वच्चीर. वार वांकी प्रश्न आडगिर. वार आनीर, ");
INSERT INTO wbq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“गुरुजी मोशेड माइच्चाका राशी फेटीनेड उंडाड कि जर वगान तम्मूड सच्चीनाड इंगा आ तम्मून की वडती उंडाद पण बीळलु लेर, तर वान तम्मूड आ विधवासंगा फेनडली शेंस्कुनाला इंका तम्मून कस्रोम वांकी वानकी बीळ काला. ");
INSERT INTO wbq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","योळ तम्मुळलु उंडीर. पहिला तम्मूड फेनली शेस्कुन्या इंका वाड बीळ कांदे सच्ची फोया ");
INSERT INTO wbq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","आंन्टेगा दुसरा तम्मूड विधवा दानसंगा फेन्डली शेस्कुन्या इंगा वाड सची फो. ");
INSERT INTO wbq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","आंटेगा तीसराड दानसंगा फेन्डली शेस्कुन्या. योळबी तम्मूळसंगा आदे आय्या यवारकबी बीळ न आता वार सच्चीर. ");
INSERT INTO wbq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","आंटेगा आदी आंतीदभी सच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","तर मग पुनरुत्थानदी टायमक आदी यवारदी वडती आयी? येनटीक की आ योळजनबी दानसंगा फेन्डली शेस्कूनडीर.” ");
INSERT INTO wbq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","आप्पुड येशुड वारकी आन्या, “इ युगोर मन्शील फेन्डली शेस्कूनटार इंगा फेन्डली शेशी इस्तार. ");
INSERT INTO wbq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","जर यवार मन्शील आ वच्चेद युगला इंका सच्चींद पुनरुत्थानला भाग तीस्केने इच्चाका पात्र ठरास्तार, वार फेन्डली शेस्कुणार ");
INSERT INTO wbq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","इंका वार सच्चेतोर काद, कारणाम वार द्यावारदूत लेका उंडार. वार पुनरुत्थानद कोडकु उंडेन इच्चाका वार परमेश्वर कोडकुल बी उंडार. ");
INSERT INTO wbq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","काले झुडूपविषयला मोशे राश्या, आप्पुड वाड परमेश्वर न ‘आब्राहामांन्द प्रभु, इसाकान्द प्रभु इंका याकोबन्द प्रभु’ इळा आन्या व सच्ची व्ह्य्यदिंसुद्धा लेफेदेंक वचाफट इदी सुपिगेस इच्च्या. ");
INSERT INTO wbq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","द्यावार सच्चेतोरक लेद तर जिवंतालद द्यावार उंडाद. आंता मन्शील याद वान्दी उंन्डाद वार जिवंत उंन्डार.” ");
INSERT INTO wbq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","आप्पुड रव्वा मंदी नियमशास्त्रालद शिक्षकल आनीर “गुरुजी, बागा माटलाडताव.” ");
INSERT INTO wbq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","मग वांकी इन्का प्रश्न आडगेद कोशिश यवार शेय्या लेद. ");
INSERT INTO wbq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","पण येशुड वारनी आडग्या मंदी येल्ला शकास्तर की, “ख्रिस्तड दाविदान्द कोडकु उंडाड इल्ला वार येल्ला आनटार? ");
INSERT INTO wbq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","येनटीक कीदावीदड स्वतः स्तोत्रद पुस्तकला आनताड, ‘परमेश्वर ना प्रभून की शेप्या, ");
INSERT INTO wbq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","नीन नी शत्रून्क नी काळाला शेयान आप्पुड नंतक नु ना तिने शेय किंदा कुसून,’ ");
INSERT INTO wbq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","इ रीतीगुना दावीद वांकी प्रभू आनताड, तर मग ख्रिस्तड दाविदान्द कोडकु येल्ला?” ");
INSERT INTO wbq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","आंता मंदी इनतुंटीर आप्पुड वाड शिष्यालक आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“नियमशास्त्राद शिक्षकाविषय सावध उंडाडा, वारक लंबा झगाल येशीगेस तीरगेन आवडास्ताद, वारक उरल्या नमस्कार तीस्कोंदेंग, सभास्थानला महत्वद आसनमिन्दा इंका तीन्नेद येळक मानद जागाक कुस्केन आवडास्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","वार विधवालद इनलु तीन्नीगेस लुटास्तर शेस्तार इंका देखावा इच्चाका फेदा-फेदा प्रार्थनाल शेस्तार. आ मन्शीलक वाईट शिक्षा आय्याफट.” ");
INSERT INTO wbq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","येशुड दृष्टी फयन्या शेशी श्रीमंताड मंदीक दानपेटीला दान येशेताप्पुड सुश्या. ");
INSERT INTO wbq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","वाड वगा गरीब विधवा तांबाय रोंड कलदारलू इंका वगा दमडी येशेद सुशा. ");
INSERT INTO wbq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","आप्पुड येशुड वान शिष्यलनी न आन्या, “नीन मिक खरेम शेपतान, इदी गरीब विधवेन्क इंगा आंदारकना शन्ना येश्या. ");
INSERT INTO wbq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","अनकेन इर आंदार मना शन्ना संपप्तीनुट येम भाग दान आनकेन ऐशा. इंगा इदी गरीब उन्डीगेस मनाद जिवंत निल्चेद आन्ताचऐशा.” ");
INSERT INTO wbq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","शिष्यालनुट, यवारना परमेश्वरान्द भवन विषयला इल्ला माटलाडशिन्द उंड्या की, “आदी बागा राळगोन इंका अपर्णागोन सुशोभित शेशिंद उंडाद.” येशुड आन्या, ");
INSERT INTO wbq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","की “इल्ला दिनमलू वच्ची की, इदी जे मीर सुस्तार दाननुट आदी केडपी ऐशादांक आयेद काद इला राळमिंन्दा राळ इन्द निलचेद काद.” ");
INSERT INTO wbq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","वार वानिक प्रश्न आडगीर, “गुरुजी इदी माटलू यप्पुड आयद? इंगा इ माटलू आयद उंडाद यासंबंधी याद चिन्हाल उंडाय?” ");
INSERT INTO wbq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","येशुड आन्या, “मिरक यवार फसवारायाद अनकेन सावध निलना येनटिक की नाद फेरगोन शना वच्चार इंनका 'वाड नीन उंडान' इल्ला आन्यार, 'इंका वार आन्यार वेळ देग्गार वचीनाद. वार यंका फो कुंडा!' ");
INSERT INTO wbq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","आप्पुड मीर लढाइल व दगाल इदी विषयला इन्यार आप्पुड एरस्कुनाक अनकेन इ माटलू काने बेक. पण इनताळा शेवट आयाद काद.” ");
INSERT INTO wbq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","इंगा वाड वारनी आन्या “वगा राष्ट्र दुसऱ्या राष्ट्रा मिंदा लेशी, वगा राज्य दुसऱ्या राज्यमिंदा लेशी. ");
INSERT INTO wbq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","फेदाद भूकंप आई, दुष्काळ फडी इंका इंगा वेग-वेगळा जागाल्ला पिडा उद्भवाशी, एरस्कुनेद इळां घटना आई इका आकाशाला फेदाद चिन्हे आई. ");
INSERT INTO wbq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","गान इदी आंता आईनदन्का वार मिता शेय येशार इंका मिद छळ शेशार. चौकशी इच्चाका वार मिंगलान यहुदी सभास्थाना मुंदार नील केडप्यार इंका तुरुंगाल येशार. नाद इच्चाका वार मिंगलान राजे व राज्यपाल वानमुदारा यतकेन फयार. ");
INSERT INTO wbq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","दिनकस्रोम मिरख नाद विषयला साक्ष इस्देन्क संधी शिक्की. ");
INSERT INTO wbq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","आप्पुड उत्तर येल्ला इछेद इ विषयला मनचिद विचार शेशेद लेद इल्ला मनस्द तैयार शेयडा, ");
INSERT INTO wbq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","कारण नीन मिख इल्ला शब्द इंगा इल्ला बुद्धी इच्चान की दान्कासरोम वान्क मिद विरोध शेसदेन्क इंका मीरविरुद्धला माटलाडसदेन्क मुळीच दाका फी. ");
INSERT INTO wbq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","जर आम्मा आब्बा, तम्मुल, गणगोत इंका मित्राल मिरद विश्वास घात शेशार इंका मीरदिनटलोर इंगा काई मंदीक ठार मत्ती. ");
INSERT INTO wbq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","नाद फेरगोर आनदार मिद द्वेष शेशार. ");
INSERT INTO wbq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","गान मिद न्यतीमिन्दूट वगाटबी यंडकाल लेद इल्ला आय्यद काद. ");
INSERT INTO wbq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","मीर मनाद धीरागोन मना जेमदी रक्षा शेयंडा. ");
INSERT INTO wbq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","मीर यप्पुड यरुशलेम शहराला दुश्मन सैन्याल वेढा येसकुनीद सुशार, आप्पुड मिरख यरका आई कि दान्द नाश आयद वेळ वच्चीन्द, उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","यव्वार यहुदीया प्रांताला उंडार वार कोन्डामिन्दा फारी फय्या बेक, जे शेणल्या उंडार वार शहराला फयद लेद. ");
INSERT INTO wbq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","इदी आन्ता गोष्टील राशिंद उंडाय आदी पूर्ण आय्या इच्चाका इदी शिक्षाद दिनाल उनडाय. ");
INSERT INTO wbq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","आ दिनुमला यवार रोंजलमनशी आंडेर उंडीर इंगा बिळाद पोषण शस्ताद आरवातलाद, खरेम दुर्दोशार आय्यी. इंका पृथ्वीमिंदा फेदाद संकट वच्ची इंका मंदी मिन्दा शिटटू वच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","वार तलवारीद धारगोन फड्यार इंका वार कैदला शेशी राष्ट्राला येतकेन फयार इंका परराष्ट्राल मंदीद काळ आईन दण्का परराष्ट्रीय यरूशलेम शहरान कालकिंदा तोक्यार. ");
INSERT INTO wbq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","सूर्य, चंद्र, तारे वारला, चिन्हाल आय्यार पृथ्वीफैनुट राष्ट्रांला हतबल आय्यार व इंका समुद्रान्द गर्जाशिंद लाटागोन वार यरस्कुनी फोय्यार. ");
INSERT INTO wbq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","यरप्पूगोन इंगा दुन्याममिंदा कोसळाशे माटलाद दावा सुशा इच्चाका मनशी शन्ना यरस्कुन्यार आकाशा लोद शक्ति तारल न योग्य जागा नुस एक फी वांन मार्ग तोंन संचालित शेशी. ");
INSERT INTO wbq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","आनकेन वार मन्शी कोडकून सामर्थ्यागोन इंका वैभवागोन मोडामला वच्चीन्द आप्पुड सुशार. ");
INSERT INTO wbq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","गान इ माटलू आय्यीदेन्क शुरुवात आय्यी, आप्पुड सखाका नीला फडन्डा इंका मिरद नत्ती फयण्या शयन्डा, अनकेन मीर सूटकाद वेळ दैगार वच्चेद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","नंतर वाड वारक ओका दाखला शेप्या, “अंजीरद माक इंगा दुसऱ्या माककुन्तिक सूड. ");
INSERT INTO wbq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","वारीक पालवी वचीदेन्क आंट्या की, मीर मिद समजास्तार कि, यंडाकालाम शेंगेम देग्गार वचीदेंक आंटीनाद. ");
INSERT INTO wbq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","दानलेकाने इ माटलु आयद मीर सुशार आप्पुड ओळखाशेद कि द्यावारद राज्या दैग्गार वच्चीन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","नीन मिरक खरेम शेपतान की, इदी आन्ता माटा घडाशी वचीन दन्का इदी पिढी लेद आय्यदकाद. ");
INSERT INTO wbq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","आकाश इंगा पृथ्वी नाश आय्यी पण नाद वचनल काका फोई. ");
INSERT INTO wbq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","परंतु मीर स्वतः क सभालायंडा, दारूबाजी इंगा आधाशी पणा व या हालीन्द जेमुंद संबंधीला चिंताल इंग्या मिद अंतःकरणे भाराशिंद फव्वाराद, आदी दिनम पाशालका आकस्माला मीर मिंदा वच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","खरेम, वाड पृथ्वीमिंदा उंडीनोर आंदार मिंदा वच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","यास्तव मीर इ आंनी आयेड माटलान तपीदेन्क इंगा मन्शी कोडकू मुंदार नीला फद्देनक तय्यार उंडाला आनकेन आन्ता प्रसंगाला प्रार्थना शेसकेन मेलका निलू.” ");
INSERT INTO wbq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","प्रत्येक दिनाल वाड परमेश्वर भवनला शिक्षण इस्तुन्डा इंका मबुकमात्र वाड जैतुनाद कोंडा आनीने कोंडामिंदा नीलस्तुन्ड्या. ");
INSERT INTO wbq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","आन्ता मंदी भवनला फोदेंक इंगा वांदी इनिदेंकनसकुला लेशी वान देग्गारा वस्तून्डीर. ");
INSERT INTO wbq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","इंगा बेखमीर रोट्ट्याद फंडग्गा दान्क वल्हांडण आंटार, आदी दयगारा वच्च्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","मुख्य याजक मंदी इंगा नियमशास्त्रद शिक्षक, येशुन येल्ला मत्तेदेन्क वच्ची इ माटला बदल चर्चा शेस्तूडीर अनकेन वांकी मंदीद यरप्पू आव. ");
INSERT INTO wbq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","आप्पुड बारा प्रेषितांकिंटा, वगाड, इंका यहूदायन्त इस्कर्योता मिंन्दा सैतान शिराशा. ");
INSERT INTO wbq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","यहूदा मुख्य याजका मंदी इंगा परमेश्वारांन्द भवनाद अधिकारी वान कडा फो इंगा वांन्क शेट्टल्या येशुन येल्ला-येल्ला फटीगेस इस्देन्क वच्ची या इ विषयला माटा शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","वार यहूदी प्रमुखुल वान्क शन्ना आनंद आय्या व वान्क वार दुडलू इछेद मान्य शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","अनकेन वार संमती सुप्पा इंका वाड येशुन गर्दी लेकुन्या आप्पुड फटी वार शेतल्या इच्चेद संधी वटेदेंग आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","बेखमीर रोट्ट्याद फंडगा, इदी दिनाम्क वल्हांडणाडनाद गोऱ्हा मत्तेयद इदी दिनाल वच्च्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","आप्पुड वाड पेत्र व योहान वारक शेपिगेस आमशा की, “फो इंका मनाइच्चाका वल्हांडण फंडग्गाद वंन्टा तैयार शेय इंन्का मनाम आदी तिनदाम.” ");
INSERT INTO wbq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","पेत्र व योहान येशुन आन्या, “मीम दानद तयारी यन्द शयाला मिरद इच्चा उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","वाड वारीक आन्या, “मीर नगराला प्रवेश शेशार आप्पुड नेळाद भांड्याल येतकेन फेयातोर वगा आरवा मिरक भेटाशी. वाड ज्या इन्टल्या फई आंन्द फो. ");
INSERT INTO wbq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","इंगा वाड घरमालकाक शेपंडा, ‘गुरुजीड मिरक आडगिंद उंडाद की, नाद शिष्यांसंगा वल्हांडण फंडग्गाद वंन्टा शेसदेन्क वच्ची आदी सुटालद खोली यन्द उंडाद?’ ");
INSERT INTO wbq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","आ मणशी मिक माडीमिंदूडडी सजामतीनेद खोली सुपीची आंदू तयारी शेयन्डा.” ");
INSERT INTO wbq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","आप्पुड पेत्र व योहान आंन्दनूट येल्लीर. इला येशुड शेप्या आल्ले आन्ता आय्या आप्पूड वार वल्हांडण वंन्टाद तैयारी शेशीर. ");
INSERT INTO wbq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","वेळ आय्या आप्पूड येशु वान बार प्रेषित सगा तिनदेन्क कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","वाड वारीक आन्या, “नीन दू:ख भोगाशामुंची मीरसंगा वल्हांडण फंडग्गाद वंन्टा तीस्कुनेद इल्लानाद शना इच्छा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","अनकेन नीन मिक शपतान की, द्यावारद राज्याला इदी परिपूर्ण आइनदन्का नीन इंका इदी वंन्टा तिनेदोन कान.” ");
INSERT INTO wbq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","नंतर येशुड पेला तिस्केन इंगा उपकार स्तुती शेसकेन वाड प्रेषित न आण्या, “इदी तिस्को इंन्का आपसाला दान्द वाटणी शेय. ");
INSERT INTO wbq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","अनकेन नीन मिक शपतान की, द्यावारद राज्य वच्चीनद्क्का दिन मुदारा नीन द्राक्षरस तीस्कुनान.” ");
INSERT INTO wbq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","इंका वाड रोट्ट्या तिस्केन इंगा उपकार स्तुती शेसकेन आदी इर्गामत्ती इंगा वारक इच्चीगेस आण्या, “इदी नाद फेय उंडाद इदी मीरइच्चाका इच्छी फईन्द उंडाद. नाआठवण इच्चाका इदी शेयडा.” ");
INSERT INTO wbq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","वान्द प्रमाणगोन वान्द वंन्टा आईनक्का वाड प्याला तिस्कुन्या इंका आन्या, “इदी प्याला नाद रक्तामला कोता करार उंन्डाद, इदी मीरइच्चाका फोशा फईन उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","इंगा सूड! नाद इस्वासघात शेशातोर्क शेय ना बराबरच मेजामिन्दा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","इंका मन्शी कोडकु ठरल्या प्रमाणगोन फोताड खरेम पण वार शेतगोन वाड फट्टी इच्ची फई मन्शीन्द येन्ता दुर्दशा आई.” ");
INSERT INTO wbq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","इंन्का वार आपपासाला वगामेगार प्रश्न आड्गदेंन्क आंन्टीर, “इदी शेशातोर मापैकीं यवार उंडाला?” ");
INSERT INTO wbq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","आले, वान्ता इळासंबधी माटाक माटा आया की, वारदान्टल्या आंदारकना फेदोड यवाड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","आप्पुड वाड वांकी आन्या, “यहुदीलेनोर राजाल वारमिंदा प्रभूत्व शेस्तार इंगा जे वारमिंदा अधिकार गाजवास्तार वारकी आदी परोपकारी इला वाटास्ताद. ");
INSERT INTO wbq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","गान मीर इला लेद. दानबद्दल मीदीन्टल्योनकेल आन्दारकना फेदोड उडीनोड अंदारला शिन्नावड आय्येद जो अधिकाऱ्या उंन्डाद वाड सेवक आय्येद. ");
INSERT INTO wbq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","आप्पुड फेदावड यवाड वाड मेजामिंन्दा कुसूनताड वाड जो सेवा शेस्ताड? जो मेजामिंन्दा कुसूनडाड वाड लेद येम? गान नीन मीरता सेवा शेशातोर लेका उंडान. ");
INSERT INTO wbq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","गान ना परिक्षाला नाद पाठीशी निलाफडीनीर इला मीरच उंडार. ");
INSERT INTO wbq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","दान प्रमाणगोन नाद आब्बाड नाद नियुक्ती शेशा इळा नीन मीर्द नियुक्ती राज्यामिंन्दा शेस्तान. ");
INSERT INTO wbq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","अनकेन मीर ना राज्याला नाद मेजामिंन्दा तीनेद व तागेद इंन्का आसणामिंन्दा कुसणी इस्त्रालयान्द बारा वंशाला न्याय शेशेद.” ");
INSERT INTO wbq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“शिमोना, शिमोना, इन! सैतानाड मीर गोदमाललेखा चाळशेद अनकेन आडगीन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","गान शिमोना, निद विश्वास ढळाशेद लेद, अनकेन नीन मीर इच्चाका प्रार्थना शेशीन्द उंडाद इंका नू इगा ना कडा तिरग्याव आंटे निद तंम्मूलक स्थिर शेय.” ");
INSERT INTO wbq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","इंका शिमोन पेत्र वांन्क आन्या, “प्रभू, नीन निबराबर तुरुंगाला फईनइच्चाका व सचीदेंक तयार उंडान.” ");
INSERT INTO wbq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","पण येशुड आन्या, “पेत्रा, नीन निख शेपतान, नू नाक गुरुतु फेटताव इदी मूड दमूल नाकराशाव तो पर्यंत इबद फुन्जू आरशालेद.” ");
INSERT INTO wbq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","येशुड शिष्यलनी आन्या, “यप्पूड नीन मीक थैली, तिति व शपूल शिवाय आमशिर, आप्पुड मिरक येम कड्मा फेट्या यम?” वार आनीर, “यमबी लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","वाड वान्क आन्या, “पण इप्पुड, वानद्ग्गारा थैली उंडाद वाड आदी तीस्कुनेद व वाड तितीसुदधा तीस्कुनेद इंन्का वानद्ग्गारा तलवार लेद वाड वान्द झगा आम्मेद इंन्का आदी कोनकेन तीस्कुनेद. ");
INSERT INTO wbq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","नीन मिख शेपतान, वाड आपराधाला गणाशिंन्द उंड्या, इला इदी शास्त्रलेख उंडाद वाड नादठायी पूर्ण आव्वाबेक अनकेन नाद विषयला गोष्टील पूर्ण आय्येद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","वार आनीर, “प्रभू, सूड, इदू रोन्ड तलवारलु उंडाय.” वाड वारनी आन्या, “आन्ता साल!” ");
INSERT INTO wbq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","मग वाड येल्ली मना रीती प्रमाणगोन जैतुनांन्द कोंडा कडा फोव शिष्यालबी वान यन्का-यन्का फइर. ");
INSERT INTO wbq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","आप्पुड आ ठिकाणा मिन्दा वच्चीनंन्का वाड वान्क आन्या, “मीर परिक्षाला फडेद लेद अनकेन प्रार्थना शेयंडा.” ");
INSERT INTO wbq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","वाड वार कडानूट राळाला टप्पाइंता दुर फइन्का वाड मॅाकाल टेकवाश्य इळा प्रार्थना शेशा, ");
INSERT INTO wbq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“आब्बा, जर निद इच्चा उंडाद इदी प्याला ना कडानुट दुराम शय. इंगा नाद इच्छेप्रमाणगोन लेद इंका निद इच्छेप्रमाणगोन आव्वा बेक.” ");
INSERT INTO wbq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","स्वर्गानूट वगाट द्यावरदूत वच्चा व वाड वान्क सामर्थ्य इस्केन नीलच्या ");
INSERT INTO wbq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","दु:ख गोन ग्रासाशिन्द उंड्या वाड शना कळकळीगोन प्रार्थना शेशा इंका वान्द घमाम रक्तामंद थेंबूलका न्याला मिंदाफडतुन्ड्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","इंका यप्पुड प्रार्थना शेसकेन वाड लेशा इका शिष्यनकडा वच्चा वाड सूडाडा वार खिन्न आय्यागुना निदारक फइंन्द वानिक कम्पिच्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","वाड वारकी कम्पिच्याआन्या, “मीर येल्ला फंडार? लय इंगा परीक्षाला फडेद लेद आनकेन प्रार्थना शेयेंडा.” ");
INSERT INTO wbq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","वाड माटलाडस्तुनडया आप्पुड मंदीद जमाव वच्च्या इंगा बारा शिष्यांलनुट यहुदा इस्कर्योत अनीनोर वगावड वानमुदारा नेडस्तुनडया. येशुनदी चुंबन तिस्कुनइच्चाका वाड वानदग्गारा वच्च्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","आंन्टे येशुड वांकी आन्या, “यहूदा, चुंबन तिस्केन मनशी कोडकुद इस्वासघात शेस ताव येम?” ");
INSERT INTO wbq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","वानभोवती जे उनडी इदी येम आयेद इदी गुरतुगोन वान्क आन्या, “प्रभू, मीम तलवार न्यडशेद यम?” ");
INSERT INTO wbq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","वानपैकी वगाड महायाजकान्द नोकरामिंन्दा वार शेशा इंका वान्द उजवा गुम्मा कोशा. ");
INSERT INTO wbq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","येशुड उत्तर इच्या, “इदी साल उन्डान.” इंका वाड वान्द गुम्माक स्पर्श शेश्या व वान्क बागा शेश्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","आंन्टे येशुड मुख्य याजक मंदी, परमेश्वरान्द भवन द मुख्य अधिकारी इंका आब्बार इर वानमिंदा नेडशी वच्चीन्द उनडीर, वान आन्या, “मीर तलवारी इंका सोटे येतकेन नामिंन्दा नेडशीगेस वच्चीर, इल्ला येम नीन लुटारू उनडान. ");
INSERT INTO wbq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","नीन इंगा मीसंगा दररोज परमेश्वरान्द भवनला इंका मीर नामिंन्दा शेय्य ययालेद लेद. अनकेन इदी मीरद वेळ इंका गड्दुद सत्ता उनडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","वार वान्क अटक शेशीर व वार वान्क महायाजकान्द इलूक येतकेन फोइर. पेत्र दुरामनूट वानयक्का नेडशा. ");
INSERT INTO wbq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","वार अंगणाला मध्यभागांला दिग्ळ आनशा इंका वान्द भोवती कुसणीर व पेत्रबी वार ता कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","आप्पुड वगा यवारक दासीने आन्द वांकी दिग्ळद उजेडाला कूसणीन्द सुशा. आदी वानदग्गारा निरखून सुशा इंका आदी आन्या, “इदी मनशी वानसंगा उंडया.” ");
INSERT INTO wbq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पेत्र आदी नाकरास्केन आन्या, “बाई नीन वान्क गुर्तु फेट्या लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोडा येळगोन दुसऱ्या मनशी वान्क सुशा इंका आन्या, “नू सूदधा वानपैकी वगाट उंडाव!” इगा पेत्र आन्या, “गृहस्था, नीन लेद!” ");
INSERT INTO wbq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","इंका सुमारे वगा तास आइनक्का इंगा वगाजण ठामगोन आन्या, “खात्रीगोन इ मणशी बी वानसंगा उंडया, अनकेन उड गालील प्रांतान्द उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","गान पेत्र आन्या, “मंची मनशी नू येम माटलाडस्ताव इदी नाक तेलच्या लेद!” वाड माटलाडस्तुनडया आप्पुड आ क्षणी फुंजू आरशा. ");
INSERT INTO wbq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","इंका प्रभूड वळाशी पेत्रादग्गारा सुशा आप्पुड पेत्रान्क प्रभूडशापिनी माटल गुरतु वच्च्या, “इबद फुन्जू आरशा आप्पुड मूडदमूल नाक नाकराशाव,” इल्ला शपीन्द वांकी द्यान्नाम वचा. ");
INSERT INTO wbq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","इंगा वाड बैयटया फई फेदाद दु:खागोन यड्शा. ");
INSERT INTO wbq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","येशूमिंदा पहाराइच्यातोर मंदी वांदी उपहास शेसदेन्क व वान मतेदेंग आन्टीर. ");
INSERT INTO wbq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","वार वान्द कंडलु कटीर इंगा व वान्क प्रश्न इच्याराशीर, वार आनीर, “गुरतु फेट! नीख यवार मत्तीर?” ");
INSERT INTO wbq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","इंका वार वान्द निदा शेशेद इच्चाका इंका पुष्कळ येम माटलाडीर. ");
INSERT INTO wbq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","फदू फुट्टया आप्पुड आब्बगार मंदी इंका वारता रोन्ड प्रकारद मंदी, मुख्य याजक मंदी व नियमशास्त्राद शिक्षक वारद सभा निटया इंका वार वान वार सभेला येतकेन फईर. ");
INSERT INTO wbq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","वार आनीर, “इंगा नू ख्रिस्त उनडाव तर माक शेप” येशुड वांकी आन्या, इंका “नीन मिख शेपतान इंका मीर ना मिंन्दा विश्वास फेट्या लेद. ");
INSERT INTO wbq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","इंका इल्ला नीन मिख प्रश्न आडग्ताण आंन्टे मीर उत्तर इच्यातोर लेद. ");
INSERT INTO wbq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","आंन्टे इपुनूट मनशी कोडकु सर्व समर्थ द्यावार उजवी तिक कुसनी उंडी उनडी.” ");
INSERT INTO wbq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","वार हानदार आनीर, आंन्टे इंगा नू द्यावार्द कोडकु उनडाव येम? वार वान्क उत्तर इच्चीर, “मीर आंतार की, नीन उंडान.” ");
INSERT INTO wbq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","इंका वार आनीर, “इप्पुड मनाख इंका साक्षीन्द येम गरज उंडाद? मनाम स्वत:वान्द नोटलोन्द शब्द इनीद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","इंगा वान्द आन्ता समुदाय लेशा इंगा वार येशुनकी पिलातान कडा येतकेन फिर. ");
INSERT INTO wbq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","वार वान मिंदा आरोप शेसदेन्क आंटीर. वार आनीर, “मिम, इदी मन्शी मंदीद दिशाभूल शेस्तान फटतीम. वाड कैसरन्क कर इसदेंक इच्चाका इरोध शेस्ताड इन्का आनटाड की, वाड स्वतः ख्रिस्त, वगा राजा उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","आनकेन पिलातुड येशुनकी आडग्या, नू यहुदान राजा उंडाव येम? आन्या “मनाम आटाम आले.” ");
INSERT INTO wbq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","आन्टे पिलात मुख्य याजकाड इन्का जमावाला आन्या, इ मन्शी मिंदा दोष फेटदेन्क नाक येम कारण आढळाशा लेद. ");
INSERT INTO wbq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","गान वार आग्रह फट्या. वार आनीर, “यहुदिड प्रांतूड आन्ता मंदीद वाड मनाद शिकवणीगोन भडकायामतांड वाड गालील प्रांतानुट सुरुवात शेशी इन्का इडदन्का वच्चीन्द उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","पिलातुड इदी इन्या, आप्पुड वाड आडग्या की, “इड मन्शी गालील प्रांतूड उंडाड येम?” ");
INSERT INTO wbq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","आप्पुड वान्क तेलच्चा की येशुड हेरोदाला अधिकार किंदा वस्ताड, आप्पुड वाड वान्क हेरोददानकडा आम्मशा. वाड आ दिनमला यरुशलेम शहराला उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदाड येशुनकी सुशा आप्पूड वान्क शना आनंद आय्या, आनकेन वाड वान विषयाला इनीन्द उंड्याव वान्क इळा वाटासतुन्ड्या की, वार वगाट चमत्कार शेशी व मनाक वाड सुसदेन्क शिक्की इल्ला आशा वानिक उन्डया. ");
INSERT INTO wbq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","वाड येशुनकी इन्का प्रश्नाल आडग्या, पण येशुड वांकी उत्तर इयाक फोया. ");
INSERT INTO wbq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","मुख्य याजकाड मंदी इन्का नियमशास्त्राद शिक्षक आंदू नीला फडीगेस वान विरोधला जोरदारपणागोन आरोप शेसस्तुंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","हेरोदाड वान शिपायासंगा येशुनकी अपमानस्पद वागणूक इच्चा, वानीद थट्टा शेशीर वाड वानमिंदा वगाट तलमात झगा येसकुन्या इंगा वार पिलातान तींक यन्का आम्मशा. ");
INSERT INTO wbq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","हाच दिनमला हेरोद इन्का पिलात वगामिगारद सोबतील आईर दिन काना पहिले वगामिगारद दुश्मन उंडीर,. ");
INSERT INTO wbq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुड महायाजक मंदी, पुढाऱ्याला इन्का मंदीक वगातडा फिलच्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“इड मन्शी मंदीक फितवाशातोड आनकेन वान मीर नातीक येकोस्तीर; इन्का सूड, हा गोष्टीलद आरोप मीर वान मिंदा फेटतार हाचसंबंधीला नीन समक्ष चौकशी शेशीन्का नाक इ मन्शीतीक यादपन दोष शिक्का लेद. ");
INSERT INTO wbq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","हेरोदान्क आरोपइषयला येम बी आधार शिक्का लेद आनकेन वाड वान्क यंका मना तिकड यतकेन वस्तीम. मीर पण सुशार की, मातेशेद शिक्षा इसदेन्क योग्यइळा वाड यमच शय्या लेद. ");
INSERT INTO wbq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","अनकेन नीन वानिक द्यब्बाल मत्ती इडशी इसतान.” ");
INSERT INTO wbq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","येनटिक की वान आ फंडगाला वगा कैदीन इडा बेक आताद. ");
INSERT INTO wbq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","पण वार आन्दार वगातडा वत्या किर्लीर, “इ मन्शिक मत्तेसकंडा! इंका मा इच्चाका बरब्बान्क इडुंडा!” ");
INSERT INTO wbq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","बरब्बाड यरुशलेम शहरला खळबळ माजवाशिंदी उंड्या. वाड रव्वा मनशीक मत्तीशिंदी उंड्या, आनकेन वान्क तुरुंगला येशिंदी उंड्या ");
INSERT INTO wbq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","इंगा पिलातड येशुंक इडशेद इच्चा फेट्टीगेस तीरगीगेस वारसंगा आन्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","पण वार किरलीगेसच नीलचीर, “वान्क वधस्तंभमिन्दा खिळायंडा, वान्क वधस्तंभमिन्दा खिळायंडा!” ");
INSERT INTO wbq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","पिलातड तिसरादम वारणी आन्या, “येम? इ मन्शी इल्ला याद गुन्हा शेशिंद उंडाद? मत्तेशेद शिक्षा इच्चदेइच्चा का इल्ला नाक इडविरोधला येम बी शिक्कालेद. यास्तव नीन वान्क द्यबाल्द मत्तेद शिक्षा शप्पीगेस इडशी इस्तान.” ");
INSERT INTO wbq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","गान वान वधस्तंभमिंदा खिळाच इल्ला वार वत्या किर्लीगेस आग्रह नडपिनडीर इंका वार्दी किर्लीदेंक यश वच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","आप्पुड पिलातुड वार्दी आडगिनल्यका आव्वा बेक इल्ला ठरवाशा. ");
INSERT INTO wbq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","यवाड मन्शी दंगा इंका खून दिनइच्चाका तुरुंगला कुकिं फइन्द उंड्या इंका यवारद यवार मागणी शेशिंदी उंड्या वान्क वाड इडशी इच्चा पिलातड वारद इच्छाल्यका शेसदेनइच्चाका येशुंक वारद शेतला इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","वार वांकी पिलातुस महल नुस येतकेन फियेद अप्पुड, कुरेनेकर शिमोन फेरद यवाड वगा शेणमिंदूट वस्तुन्ड्या वार वान्क फट्टीर इंगा वाड येशुन यन्का नडशीगेस क्रूस येतकेन नडाला आनकेन आदी वानमिन्दा फेट्टीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","मंसलाद इंगा आंतीलाद फेद्दा समुदाय वान यंकाक न्यडशा, आ आरवतील वान इच्चाका यदा मत्तकेन शोक शेस्तुंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","येशुड वारकडा तीरगीगेस आन्या, “यरुशलेमेद आंडबिळानो, नाइच्चाका यडशेद लेद, तर मना स्वतःइच्चाका इंका बीळालइच्चाका येडूंडा. ");
INSERT INTO wbq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","येनटीक की इल्ला दिनाल वच्चेद उंडाय, आप्पुड मान्शिल्द आन्यार, धन्य आ आरवातील वांझ उंडाय इंका धन्य आ गर्भाशय, यवार जन्म इय्या लेद इंका धन्य आदी स्तने, यवार यबद तापशा लेद. ");
INSERT INTO wbq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","आप्पुड ‘वार पर्वतन्क आन्यार, मामिन्दा फड इंका वार कोंडालनी आनी. ममलान मुइंडा’ ");
INSERT INTO wbq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","फच्ची माकुक इल्ला शेस्तार तर यंडी माकुद येम?” ");
INSERT INTO wbq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","इन्का इदार मंदी अपराधी उंडीर वान्कबी वार सगा जीव मत्तदेन यतकेन फो. ");
INSERT INTO wbq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","इन्का आप्पुड वाड गुन्हेगारासंगा “कवटी” आनिद ठिकान्या मिन्दा वच्चीर, आंदु वार वान्क हा अपराध्यांन्क, वगान्क वान उजवीतीकड व वगान्क डावितिकड इल्ला वधस्तंभामिन्दा खिळाशीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","आंटेका, येशुड आन्या, “हे अब्बा, वारनी क्षमा शेय इन्का वार येम शेस्तार इदी वारीक तेलवाद.” वार चिठ्ठ्याल येशीर वान्द बट्टाल फन्ची तीस्कुनीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","मंदी आंदु सुस्केन नीलाफडीडीर इन्का पुढाऱ्याल थट्टा शेसकेन आनीर, वाड इन्गोर्ण वाचायमत्या, तर वाड ख्रिसतोड, द्यावरद निवडाशिंन्द उंडया तर वाड स्वतान्क वाचायमती! ");
INSERT INTO wbq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","शिपायोड वान थट्टा शेशा. वाड वान्तिक वच्चा वाड वानिक फुलाका इच्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","इंका वाड आनीर, “जर नु यहुदियांद राजा उंन्डाव तर स्वताण वाचवाय!” ");
INSERT INTO wbq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","वान मिन्दा इळा राशींद उंड्या “इदी यहुदिया मंदिद राजा उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","आंदू खिळाशिंद वगा गुन्हेगारुड वान्द निन्दा शेशीर. वाड आन्या, नु ख्रीस्ताड लेद येम? स्वतः क व माम्लान भी वाचवाय! ");
INSERT INTO wbq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","पण दुसराड गुन्हेगारड वानिक दटावाशा इंका आन्या, “नीक द्यावारक आद्र लेद येम? निक बी आदी शिक्षा आइन्डाद. ");
INSERT INTO wbq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","पण मनाद शिक्षा योग्य उंडाद कारण मनाम जे शेस्तिम दान्द योग्य फळ मनाक शिक्कताद. पण इदी मन्शी यमबी अयोग्य शेशा लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","आंटे का वाड आन्या, “येशुड, नू मनाद राज्याद वच्चाव आप्पुड नाद आठवण शय.” ");
INSERT INTO wbq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","येशुड वानिक आन्या, “नीन निक खरेम शपतान, इबद नू ना संगा सुखमंदीला उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","आ वेळला द्यग्गाद्यग्गारा मध्याणीव बारा वागीनड्या उन्ड्या इंका मूड वागीनदनका हन्नी देशमिंदा गड्दू फड्या हायाळेला सूर्याप्रकाशा लेद. ");
INSERT INTO wbq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","इन्का परमेश्वरान्द भवन मिंदूडद पडदा नडमानडमा शिंनग्या इन्का दाणी रोन्ड भागुल आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","येशुड बैग्या किरल्या, “आब्बाड, ना आत्मा नी शेतल्या सोपवाशी इस्तान.” इळा माटलाडशी वाड जेम इड्षा. ");
INSERT INTO wbq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","आप्पुड रोमी शताधिपतिंन्द एम घडाशा आदी सुशी आप्पुड वाड द्यावारद गौरव शेशा इंका आन्या, “खरेम-खरेम इड नीतिमान मन्शी उंड्या.” ");
INSERT INTO wbq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","इदी सुशेदेंक कसरोम कुडीनोर मंदीक घडाशिणीव गोष्टील सुशीर, आप्पुड वाड यदामिन्दा मत्तकेन यन्का फोइर. ");
INSERT INTO wbq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","परंतु वाड ओळखींद आंदार सुशदेन्क इच्चाका दुराम नीला फडीर. वाटलोन गालील प्रांतानुट वान इंका वाच्चींद आरवातल उंडीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","आंद योसेफ फेरद वगा मन्शी उंड्या. वाड यहुदी सभास्तानाद सभासद व बागा इंका नीतिमान मन्शी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","वाड उंगो धार्मिक पुढारी निर्णय इंगा वान्क फनीक व इच्चरासदेन्क समती इच्चींद लेकुंड्या. वाड याहुदिया प्रांतालद अरिमथाई नगरालद उंड्या. वाड द्यावारद राज्यंद दावा सुस्कुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","इदी मन्शी पिलताकडा फो इंका वाड येशुंद फय आडग्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","आदी वार वधस्तंभांमिन्दानुट किंदा तीशीर इंका ताग्यात वस्त्राला गुड्लाशेर. आप्पुड नंतर वार खडकाला खोदाशिंद कबरेला फेटीर. इदी कबर इळा उंड्या कि, दानमिन्दा आडदणका यवारकबी फेटीन्द लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","आदी तयारिंद दिनम उंड्या इंका शब्बाथ सुरु आय्यद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","गालील प्रांतानुट येशू बराबर वच्चीन्द आरवतल योसेफानद यन्का फोयीर. वार आधी कबर व दानटल्या आधी फय यळा फेटीनार आधी सुसीर. ");
INSERT INTO wbq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","इंगा वार इलक फय्यीर व वार सुगंधी मसालाल इंका लेप तयार शेशीर. शब्बाथ दिनम वार आज्ञा प्रमाणगोन विसावा तीस्कोनीर. ");
INSERT INTO wbq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","हप्ताद पहिला दिनम वार आंतील येशु सगा गालील नुस वचीडिर लगाना नस्कुला कब्रदेग्गार वच्चीर इंका वार स्वत:तयार शेशीन्द सुगंधी मसाला येतकेन वच्चीर. ");
INSERT INTO wbq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","वारीक राय कबरेमिदुट दबिंद कमशा. ");
INSERT INTO wbq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","वार नोना फोईर, गान वारकी प्रभु येशुनदी फय शिक्या लेद. ");
INSERT INTO wbq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","दिन कस्रोम गोटालाल आईंद उडताना, अचानक चम चंमकशेद बटाल येसकुनीनोर इदार मन्सुल वार बाजूक नीला फडीर. ");
INSERT INTO wbq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","आप्पुड सना आद्री गास वार वारद मुतुल जमीनतीकुड शेशीर वार वारकी आनीर, जो जिता उंडाड वान मीर सच्चींनार दाटल्या येल्ला फूडकुतुनार? ");
INSERT INTO wbq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","वाड इंदू लेड; वाड लेशीनोड उंडाड! वाड गालील प्रातांला उंन्डाना वाड मिक येम शेफ्या दांदी ध्यानाम तीस्कुंडा. ");
INSERT INTO wbq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","आदी इल्ला, की, “मानशी कोडकून फटेकेन पापी मंदिंद शेतला इचेद, वानक वधस्तंभामिंन्दा खिळाशेद इंका मरनांडा वाड लेशी.” ");
INSERT INTO wbq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","आंन्टे आडीयोरक येशुनदी शब्दाद आठवण आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","आ कबरेनोट यक्का वचीर इंका वार आ आंनी माटलाद अंद उडीनोर अकरा प्रेषितांना व इंगा आन्दार्क शेप्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","वार आंतील मग्दालीया नगरद मरिया, योहान्ना इंगा याकोबाद आम्मा मरिया इदी उंड्या. वार इंका इतर आडेर सुदधा वार बराबर उंडीर, प्रेषित लाक इ माटलू शेपदूर. ");
INSERT INTO wbq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पण प्रेषित टोर क वान्द शपेन्द एटीव्हानिक लेद वाटाशा इंगा वार वारमिंदा विश्वास फेटा लेद. ");
INSERT INTO wbq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","पण पेत्र लेशा इंगा कबरेकडा फारया. वाड किंदा वंगी सुश्या गणी वांकी तागाद गुडळाशिन्द बटालशिवाय यमच कमसा लेद. जे आय्या दानमिंदा वाड स्वताने सगा आश्चर्य शेशी दुराम फोय्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","आफोदे दानलोनट्योर इदार शिष्यल यरुशलेम शहर कडा नुट सुमारे आकरा किलो मीटर अंतरामिंन्दा उंडीने अम्माऊस फेरद उरूक होदूर. ");
INSERT INTO wbq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","वार वगामेगारक संगा इदी घडाशींन्द आन्तां ईश्यला माटलाडदर. ");
INSERT INTO wbq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","वार इदार शिशाल माटलाडेद आप्पुड इंगा इ माटलाद चर्चा शेशदर अचानक आप्पुड येशुड स्वत: वच्या इंगा वानबराबर नेडस्देन्क आनटया. ");
INSERT INTO wbq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पण वगामेगन माटलाडदूर वारी कनलू वान ओळखन्यानुस बंद शेस्देक वाचिन्द उंड्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","येशू वारीक आन्या, “नडशेताप्पुड मीर वगामेगारनी माटलाडतुनार आय्यी माटलू याय उंडाय?” नेडस्ता-नेडस्ता वार थांबाशीर. वार शना दु:खी कमशीर. ");
INSERT INTO wbq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","वार दानलोड वगाट यवार फेर क्लयपा उंड्या, वाड वानीक उत्तर इचा, “आ दिनमला घडाशिने माटलू यरका लेनोर इल्ला यरुशलेम शहराला नीलचेतोड नू वगाडे उंडाव येम?” ");
INSERT INTO wbq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","येशुड वारीक आन्या, “मी मतला याय माटलू?” वार वारीक उत्तर इचा, “नासरेथकर येशुड विषयला आंनी माटलू. इधिच वाड मनशी जो मनाद फनी इंका शब्दागोन द्यावार मुंदार इंगा मनशी मुदारा वगाट महान संदेष्टावड आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","इंगा मीम चर्चा शेसतुन्ड्या की, येल्ला मा महायाजक इंगा अधिकाऱ्यांल वारीक मरणदंड भोगण्याइच्चाका स्वाधीन शेशीर इंगा वार वानिक वधस्तंभी खिळाशीर. ");
INSERT INTO wbq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","मीम इल्ला आशा शेशीनटीम की, वाडच वगाट उंडाड जो इस्राएलद मुक्तता शेशी आनी इ आंता शिवाय इदी आन्ता घडशी फोईने माटलाद इफोद मूड नाड आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","इंगा मा परिवाराला काई आंतील मंमलान आश्चर्यचकीत शेशिनडीर. इब्द अगदी नसकला आका डा कबरेकडा फईर, ");
INSERT INTO wbq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","गान वारकी वांदी फय शिक्या लेद. वार वच्ची माक शपीर की, वारीक द्यावरदूत लाद दर्शन आय्या इंगा द्यावरदूत लु शेप्या की, वाड जिवंत उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","आप्पुड मा दान्टलोड यवार कबरेकडा फईर इंगा आडेर इल्ला शपीन्द उनडया, आलेच वारीक अढळाशा, पण वार येशुड सुशा लेद.” ");
INSERT INTO wbq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","आंन्टे येशुड वारनी आन्या, “संदेष्टोर शपिणीव आंनी माटला मिंदा इश्वास फेटदेन्क मीर अति मूर्ख इंगा मंद उंडार. ");
INSERT INTO wbq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ख्रिस्ताइच्चाका इवी आंनी माटलू सहन शेशेद इंन्का वान्द गौरवाला फयेद आवश्यकता लेद येम?” ");
INSERT INTO wbq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","इंगा आनकेन वाड मोशेन तिकुट सुरुवात शेशी इंका आन्ता संदेष्टयांलद्न्का शेपी, शास्त्रलेखात वार विषयला येम राशीन्द उंडाद आदी आन्ता वार वानीक स्पष्ट शेशी शेपीर. ");
INSERT INTO wbq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","या खेड्याकडा वाड फोतुन्ड्या, वानदेग्गार वार वच्चीर इंन्का येशुड इल्ला बहाणा शेशा की, जणू वाड मुंदार फोयेतोड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","गान शना आग्रह शेशी वार आनीर, “मासंगा निलू कारण मब्बू आईन्दच उन्डाद इंन्का फदूबी मावळाशिंद उंडाद.” आंन्टे वाड वारसंगा निलचीदेंक नोना फोय्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","यप्पुड वाड वारसंगा तिनदेंन्क मेजासभोवताला कुसन्या, वाड रोट्ट्या तिसकुण्या इंन्का उपकार मानाशा. नंतर वाड आदी ईरगामत्तया व आदी वार्क इसदेन्क आंट्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","आप्पुड वानी कडलू तेरशा इन्का वार वानिक ओळकाश्या. पण वाड दाटल्यानुट गायब आय्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","आन्टे वाड वगामेगारक शपदूर, “वाड दावामिंदा मनासंगा माटलाडस्तुन्ड्या आप्पुड इंगा शास्त्रलेखान्द उलगडा शेस्तुन्ड्या आप्पूड मना अंतःकरनाला नोंनुड नोना उकळी वस्तुन लेकुंड्या येम?” ");
INSERT INTO wbq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","आन्टे वाड लगाना लेशीर व यरूशलेम शहराला यन्का फोइर. आप्पुड वारक अकराल प्रेषित व वानसंगा उंडीनोर इतर वगातडा जमाशीनोर कमशिर. ");
INSERT INTO wbq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","इंगा वार प्रेषित तोरद माटा इनीर इंगा प्रेषित इंगा उंगो मदि इ यिदार प्रेषित तोरन आनिर, “खरेम-खरेम प्रभुड लेशिनोड उंडाड! इंका शिमोनक कमशिन्या.” ");
INSERT INTO wbq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","नंतर आ इदार शिष्यांल दावाला येम घडश्या आदी वार शेपीर इंका वाड रोट्ट्या इरगी मत्ताना वार वारीक येल्ला ओळकाशा आदी शेपीर. ");
INSERT INTO wbq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","वार इ माटलू वारीक शेपतान येशुड वार दान्टल्या निलाफड्या इंका वारीक आन्या, “मिक शांती उंडान.” ");
INSERT INTO wbq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","वार दचकाशीर इंका भयभीत आईर. वारीक इल्ला वाटाशा की, वार दैयाम सुस्तार. ");
INSERT INTO wbq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","परन्तु येशु वनीक आन्या, “मीर इल्ला आस्वस्थ येल्ला आईर? मीर मन्नसला शंका याला निर्माण आय्या? ");
INSERT INTO wbq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","नीं दयाम कान नाय शेईळ इंगा काळ सूडना मिक नीन कमस्तान वाड आदीच नीन उंडान. नाक शई अन्वनडा इंका सुड की, नाक उंडाद इळा हाडमांस दैयामक लेकून्टाद.” ");
INSERT INTO wbq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","इल्ला माटलाडी वाड वानक मनाद शेतलकाळ सुप्या. तरीही वान आनंदागोन वारकी आदी खरेम वाटायाद. ");
INSERT INTO wbq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","इंगा आनंदागोन विश्वास न फेटता आश्चर्यचकीत आईर आप्पुड येशुड वान आन्या, “इंद नीदग्गारा तिनदेन्क इच्चाका येम उन्डाद?” ");
INSERT INTO wbq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","इंगा वार वांकी येपीने मिलद तुकडा इच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","वाड आदी तीस कुण्या इंगा वारमुंदार तिन्या. ");
INSERT INTO wbq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","वाड वारनी आन्या, “इये आय्यी माटलू याय नीन मीर बराबर उंडेताप्पुड शपीनिन्टीन की, मोशिंन्द नियमशास्त्र, संदेष्टे इंका स्तोत्र इनमिंदा ना विषयला येम शपिनेद उंडाद इदी आन्ता पूर्ण आय्याचबेक.” ");
INSERT INTO wbq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","इंगा शास्त्रलेख तेलच्याइच्चाका वाड वान्द मनसु तेरशा. ");
INSERT INTO wbq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","मग वाड वारकी आन्या, “पवित्र शास्त्राला इल्ला राशिंन्द उंडाद कि, ख्रिस्तद दुख भोगाशेद इंका सचीनदाटनुट तिसऱ्या दिनाम लेशेद, ");
INSERT INTO wbq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","इंका यरुशलेम शहरानुट आरंभ शेशी आन्तां राष्ट्राला वान्द फेरद पश्चाताप इंगा पापुलद क्षमा घोषित शेसदेन्क वच्ची. ");
INSERT INTO wbq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","इदी गोष्टीद मीर साक्षी उंडाय. ");
INSERT INTO wbq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","सूड, नाद आब्बाड इच्ची शेशीन्द देणगी नीन मीरकडा आमस्ताण; मीर स्वर्गीय सामर्थ्यागोन युक्त आय्याव आदन्का यरुशलेम शहराला निलू.” ");
INSERT INTO wbq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","इंगा वाड शिशालन बयट्या दुरामिंदा बेथानि नगर दनका येतकेन फो इंका वाड शेतुल फयक शेशी आशीर्वाद इच्चा. ");
INSERT INTO wbq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","वाड आशीर्वाद इस्ताना इंका तवर मोडामला तिसकुण्या फो. ");
INSERT INTO wbq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","इंगा वार वांदी उपासना शेशीर इंगा वार फेदाद आनंदागोन यरूशलेम शहराला फोईर. ");
INSERT INTO wbq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","इंगा वार परमेश्वर गुड्डीला द्यावारकी धन्यवाद सतत शेसकेन निलचीर.");
INSERT INTO wbq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ये थियफीला, येशुड येम सिखा मत्या इंगा शेश्या, इंगा या विषयला नीन ग्रंथला लीवाशिनान, ");
INSERT INTO wbq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","आ दिवस नंताक यपुड वान स्वर्गलोन्क मिन्दिक तीस्कोनीर. इ आज्ञाल वाड पवित्र आत्मा तीकेल वाड निवडासने प्रेषितलाक इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","सचीनेन्का पण येशुड स्वतान संगेम प्रमाणलाता वार मुन्दार जिवंत सुपिच्या. इदी सुपीची चाळीस दिवस पर्यंत वाळ वारकी दर्शन इदू, इंगा द्यावार राज्यद दावा शपदु. ");
INSERT INTO wbq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","यपुड वाड वार संगा ओकाताळा उनडिर आज्ञा शेश्या की, “यरुशलेम शहर इळशी फो कुंडा तर आबाड इचीने, प्रतिज्ञाल विषयला, मीर ना देगार नुस ऐकाशिणार दांदी दावा सूळना. ");
INSERT INTO wbq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","येनटीक की योहान मिद न्यळाता बाप्तिस्मा शेशिनाळ खरेम; काही दिवसला नंतर मिद बाप्तिस्मा पवित्र आत्माता आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","तर यपुड प्रेषितलु येशुन सांगा उंडीर येशुन आळगिर, “प्रभू, येम नु इदे वेळला इस्राएलदी राज्य इंगा स्थापन शेस्ताव?” ");
INSERT INTO wbq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","येशुड उत्तर इच्या, “आबाड स्वता अधिकारला काळ इंगा वेळ फेटीनाळ आइ ओळखास्काम मी तीकुड लेद. ");
INSERT INTO wbq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","यपुड पवित्र आत्मा मी मिंदा वची, आप्पुड मीर सामर्थ्य तीस्कोन्यार, इंगा यरुशलेम शहरला आंदार यहुदील इंगा शोमरोन प्रांतला, इंगा पृथ्वी शेवट नंताक मीर ना साक्षिल आयार.” ");
INSERT INTO wbq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","इल्ला शपी नेन्का वार कनला मुंदार वान मिन्दिक तीस्कोनीर, इंगा ढगला इचांग वान सूडसु शका कुंटूनीर. ");
INSERT INTO wbq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","दान बाद वाड फोतांना वार मोळाम तीकुड बारकाईता सूळदूर, आप्पुड सूळना, तेल्लाय बटाल येस्कोननेर इद्दार मंसूल वार देगारा नीला फडीर. ");
INSERT INTO wbq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","इंगा वार इल्ला माटलाळीर, “अरे गालीलटोर मंदी, मीर आंदू नीला फडी मोळाम तीकुड येनटीक सुस्का नीला फडीणार? इन जो येशुन मी देगार नुस मिम्दिक तीस्कोन्डार? मीर वान येला मोळामला फोतांना सुस्तुणार आले वाड वापस वची.” ");
INSERT INTO wbq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","मग वार जैतुन टेकडी नुस यरुशलेम शहर कि वापस वचीर याद यरुशलेम शहर देगारा उंडाद ओकात शब्बाद दिवस दी यात्रा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","मग यपुड वार शहरला पोहोचाशीर आप्पुड वार खोलीला यंदू वार उंडीर पेत्र, योहान, याकोब, अंद्रिया, फिलीप्प, थोमा, बर्थलमय, मत्तय, अल्फिन कोडकु याकोब, इंगा शिमोन जीलोत इंगा याकोब कोडकु यहुदा आंदूक फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","इ आंदार मंदी इंगा वार येंटा येंनी तरी आंडेर, येशुन आम्मा मरिया, इंगा वान तमुळलु वगा चित्तता ओकालेका प्रार्थना शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","आ नाळाला पेत्र तमुडवर्गला, तरी नूर मिंदा इर्वाय मंदी गर्दीला नीला फडी आन्या, ");
INSERT INTO wbq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“तमुडलु, येशुन फटी इचेतोळ यहुदान विषयला पवित्र आत्मा दावीद नोरता याद भविष्यवाणी पाहिलाने शपीन्या, शास्त्रलेख पूर्ण आकाम फनीद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहुदा मना गटटोळ मणशी उंड्या इंगा इ सेवाला सहभागी आईन्या.” ");
INSERT INTO wbq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(वाड स्वता दृष्ट कमाईता शेन कोनका तीस्कोंन्या. इंगा वाड नती मिंदा फड्या दिनकस्रोम वानदी कडपु नडमा ने फगल्या, इंगा वाणी फेगुल बेटीक फड्या. ");
INSERT INTO wbq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","इदी यरुशलेम शहरला निलचेतोर आंदार की यरका आयनाद दांचांग वार भाषाला आ शेननी हकलदमा, आंटे रक्तामदी शेन, इल्ला फेर फडनेद उंडाद.) ");
INSERT INTO wbq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","स्तोत्रसहिताला लीवाशी उंडाद की, वानदी इल्लु उजडास फोवाला, इंगा दान्टल्या यवार नीला रोद. इंगा वांद पद इंगोगोड तीस्कोनाला. ");
INSERT INTO wbq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","दांचांग, प्रभू येशु, मना मधातला नोनिक बेटीक वचका फोका उंड्या आई आन्नी काळला, ");
INSERT INTO wbq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","योहान बाप्तिस्मा नुस तर या दिवस प्रभू येशुन मनादेगार नुस मिन्दिक तीस्कुनीर, आ दिवस पर्यंत तर या मनस्लू मना संगा सोबतीला उंडीर वार लोन्केल ओकोळ मना संगा वान पुनरुत्थानदी साक्षी का बेक. ");
INSERT INTO wbq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","आप्पुड यवानदी उपनाव युस्त उंड्या, वाड बर्सबा आंटार योसेफ इंगा मत्थिया, इर इद्दार मंसलान मुंदारकी येकोचीर. ");
INSERT INTO wbq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","इंगा वार इल्ला प्रार्थना शेशीर, “इ आंदारी मनलू जानाशेटोळ प्रभू, ");
INSERT INTO wbq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","इ सेवक पदलु इंगा प्रेषित पदलु इडशी स्वता जागाला फोइनेळ यहुदांदी पद यवार्की शिकाला इल्ला इ इद्दार पैकी नु यवार निवडाशीनाव आदी शप.” ");
INSERT INTO wbq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","इंगा वार-वार इचांग चीठ्ठील येशी नेन्का मत्थियांदी चिठ्ठी येल्या; आप्पुड वान अकरा प्रेषितला संगा मोजादेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","नंतर पेन्टेकॉस्ट म्हणजे याबाय नाळ वचीन्या आप्पुड आंदार विश्वासील वगा ताळा जमा उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","अचानक फेदा घाली लेका मोळाम लोन्केल आवाज आय्या, इंगा इदी आ इंटल्या ऐकू वच्या यंदू वार कुशींडीर. ");
INSERT INTO wbq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","इंगा अलग-अलग आयका फोये आग्गी न्याल्कालेका न्याल्काल वार्की कमशा इंगा वार लोन्केल आंदारला वगा वगाट इल्ला कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","आप्पुड वार आंदार पवित्र आत्माता परिपूर्ण आयीर इंगा यला आत्मा वारकी सामर्थ्य इच्या वार अलग-अलग भाषाला माटलाळदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","“आ वेळला मोळाम किंदूटोर प्रत्येक मणशी यहुदील परमेश्वर भक्तिमान यहुदी येरुशलेम शहरला नीलदूर. ");
INSERT INTO wbq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","आदी आवाज आयनेंका मंदिद समुदाय ओकाताळा जमा आय्यी गोंधळाशी फोयीर, येनटीक की प्रत्येकोर वारकी स्वतास्वता भाषाला माटलाळतांना ऐकाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","वार आंदार आश्चर्यता थक्क आय्यी: वार आळगिर, आंदार जो माटलाळतुणार गालील दी लेद? ");
INSERT INTO wbq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तर मनाम आंदार स्वता स्वताद फुटीनेद भाषा माटलाळतांना यला ऐकास्ताम? ");
INSERT INTO wbq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","पार्थी, मेदी, एलामी, मेसोपटेम्या, यहुदिया, कप्पदुकीया, पंत, आशिया, ");
INSERT INTO wbq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रुगीया, पंफुलीया, मिरसइंगा कुरेण देगार्दी लीबुवा देश दिंटल्या नीलचेतोर, यहुदी इंगा यहुदीमतला लेका इल्ला रोमन उंडाद, ");
INSERT INTO wbq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","क्रेतीय, अरब, इल्ला मनाम वारनी स्वतास्वता भाषाला द्यावार्दी महत्वय फनील शपेत आप्पुड ऐकास्ताम.” ");
INSERT INTO wbq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","आप्पुड वार आंदार आश्चर्य चकीत आय्यी; इंगा गोंधळाशी येकमेकोरनी आळगिर, “दिंदी अर्थ येम उंड्याला?” ");
INSERT INTO wbq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पण इंगोगोर यंता चेष्टा शेस्का आनीर, “वार कोताद द्राक्षरस नशाला उंडार.” ");
INSERT INTO wbq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","आप्पुड पेत्र अकरा प्रेषितसंगा नीला फडी, स्वताद आवाज येत्या इंगा गर्दीन आनेदेंक आंट्या, अरे यहुदी मंदी इंगा यरुशलेम शहरला नीलचेटोर, नाद माटा ध्यानामता ऐकांडा इंगा नीन मिक शप्तानकि दिंदी अर्थ येम आताद. ");
INSERT INTO wbq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","मिक यला वाटास्ताद की इर नशाला उंडार आला लेद येनटीक की फदिनी नऊ वाजाशीनाय. ");
INSERT INTO wbq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","पण योएल संदेष्ट्याळ येम शपिन्या आदी इदी उंडाद: ");
INSERT INTO wbq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","द्यावार आंटाळ, “शेवट दिवसाला इल्ला आय्यी, नीन मनुष्यमात्राल मिंदा नीन आंदार मंदी मिंदा स्वता आत्माद वर्षाव शेश्यान, आप्पुड मी कोडकूल इंगा मी कुतुरलु भविष्यवाणी शेश्यार. मी जवानोर दृष्टांत सुश्यार इंगा मी मुसलेरकी कलाल फडी. ");
INSERT INTO wbq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","इंगा आ दिवसाला नीन स्वता दास इंगा दासिला मिंदा इंगा स्वता दासील मिंदा स्वता आत्माद वर्षाव शेश्यान, म्हणजे वार भविष्यवाणी शेश्यार. ");
INSERT INTO wbq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","इंगा मिंदा मोळामला अद्भुत इंगा पृथ्वी मिंदा चिन्हल, म्हणजे नेत्तुर, सिच इंगा धुवाद वाफ इल्ला नीन सुपिच्यान. ");
INSERT INTO wbq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","परमेश्वरदी महान इंगा प्रसिद्ध दिवस दाकाना मुंची सूर्य मबुगडद इंगा चंद्र रक्तामदी आय्यी. ");
INSERT INTO wbq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","आप्पुड इल्ला आय्यी की यवार पण परमेश्वर फेरता वांदी आशा शेस्का उंड्यार वानदी तारण आयी.” ");
INSERT INTO wbq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“इस्रायेळटोर मंदी एकांडा: नासरत येशुन ओक मणशीउंड्या यवांकी द्यावार चमत्कार अद्भुत फनील इंच चिन्हलता मी इचांग मान्यता इच्चीन्या यवान परमेश्वर वान इंगा मी मधातला शेशिन्या यला कि मिक स्वताके यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","वाड द्यावार योजना लेका पाहिला लेका मी शेतल्या इच्या, मीर वान फट्टी नास्तीकोर शेयता क्रुस्मिंदा एकामती मततीर; ");
INSERT INTO wbq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","वान द्यावार साव दुखलोन्केल इडपिची लेप्या, येनटीक की वांकी साव शेतल्या निल्चेद अशक्य उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","दावीद वान विषयला इल्ला आंटाड, ‘नीन परमेश्वरनी ना मुंदार नित्य सुशीनान; नीन फडाराद आंका वाड ना मंची तीकुड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","दांचांग नाद मन आनंदित इंगा नाद न्याल्का उल्हासित आयनाद इंगा नाद फय इदी आशामिंदा उंडी. ");
INSERT INTO wbq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","येनटीक की नु नाद जेम सचीने मंदीला फेटाव, इंगा नाही स्वता पवित्र मंदीन कब्रला सडानिच्याव. ");
INSERT INTO wbq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","जीवनि दावाल नु नाक शापिनाव; नु नन्नु स्वता उपस्थितीला आनंदता निमपेश्याव.’” ");
INSERT INTO wbq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“तमुलू इंगा शेलालू, कुलाधीपती दावीद राजा: इन विषयला नीन मी संगा प्रशस्तपणता माटलाळताळ वाळ सची फोया, बुळशीर वांदी कब्र इफोद पण मना देगारा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","वाळ संदेश इचेतोळ उंड्या, इंगा वांकी यरका उंड्या की द्यावार वांकी अभिवचन इच्चीनाड की नि बीळलालोन्केल ओकोन नि राजासन मिंदा कुसना मत्यान. ");
INSERT INTO wbq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","दिंदी पाहिलाद माहिती उंडीने इचांग वाळ ख्रीस्तन: पुनरुत्थान विषयला इल्ला माटलाळ्या की, वान सचीने मंदीला इळा लेळ, इंगा वान शरीर की सडाशेळदी अनुभव दाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","आ येशुन द्यावार लेप्या, दिन विषयला मिम आंदार साक्षी उंडाम. ");
INSERT INTO wbq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","दांचांग येशु द्यावार मंचीतीकुड कुशिंडेळ उंडाळ वानिक पवित्र आत्मा बदल द वचन आबान तिकोल वचा, इंगा मीर येम सुस्तार इंगा ऐकास्तार दांदी वाळ वर्षाव शेश्याव.” ");
INSERT INTO wbq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“येनटीक की दावीद राजा स्वर्गला येकी फोल्या, पण वाळ स्वता आंटाळ, ‘परमेश्वर ना प्रभूनकी शप्या की, ");
INSERT INTO wbq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","नीन नि शत्रूलाद नीद पादासन शेशी पर्यंत नु ना मंची तीकुड कुसनी उंड.’” ");
INSERT INTO wbq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“दांचांग, इस्राएली आन्नी मनसल इदी निश्चय पूर्वक समजाशी तीस्कोनाला की, या येशुन मीर क्रूस मिंदा येशी मतुतीर वान द्यावार प्रभू इंगा ख्रिस्त इल्ला शेशी फेटीनाळ.” ");
INSERT INTO wbq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","पेत्र शब्दल वार अंतकरणकी चूटपुट शेषेश्या इंगा वार पेत्र इंगा दुसरा प्रेषितलान आन्या, “तमुडलु मनाम येम शेयाला?” ");
INSERT INTO wbq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पेत्र वारणी आन्या, “पश्चाताप शेयना इंगा मी पापुद क्षमा काला, दांचांग मीर प्रत्येक जन येशु ख्रीस्तन फेरता बाप्तिस्मा तीस्कोंडा, म्हणजे मिक पवित्र आत्माद दान शिक्की. ");
INSERT INTO wbq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","येनटीक की इदी वचन मिक मी बीळलाक इंगा यवार दुराम उंडार, वार आंदार इचांग उंडाद यंता मंदीन मना प्रभु परमेश्वर कुतेशी परमेश्वर यंता मंदीन देगारा कुतेशी आंता मंदीक इच्चीनाड.” ");
INSERT INTO wbq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","इंगा वाळ दुसरा संगेम माटलु शपी वांकी साक्ष इच्या इंगा समजाशी आन्या, “इ कुटण पिढीकेल वाचाशी उंड.” ");
INSERT INTO wbq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","आप्पुड यवार वान संदेशनि स्वीकार शेशीर वारदी बाप्तिस्मा आय्या, इंगा आफोद वारलामंदीद मंडळीला वचीर मुड हजार मंदीद वजन फड्या. ");
INSERT INTO wbq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","वार प्रेषितला शिक्षणला इंगा सोबतीला, रोट्या तेम्पुदेंक इंगा प्रार्थना शेशेदेंक तत्पर उंडदूर. ");
INSERT INTO wbq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","आप्पुड प्रत्येक मंशिक बिता आय्या, इंगा प्रेषितळा शेईकेल संगेम अद्भुत फनील इंगा चिन्हल घडादू. ");
INSERT INTO wbq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","आप्पुड विश्वास फेटेतोर आंदार ओकाताळा उंडीर इंगा वारला आंताच सारखा उंड्या, ");
INSERT INTO wbq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","वार स्वता स्वताद भुमी इंगा मालमता आंबी यला-यला प्रत्येकोर्की गरज फडदू, आला-आला आंदारकी फंची इदूर. ");
INSERT INTO wbq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","वार दिन्नाम वगा चित्तता इंगा तत्परता परमेश्वर भवनला जमा आदूर, इलूइलूक रोट्या तेम्पुदूर इंगा द्यावार्दी स्तुती शेस्का हर्षतागोन इंगा खरेम मनता तिन्दूर; ");
INSERT INTO wbq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","आंदार मंदी वारकी खुश उंडदूर इंगा प्रभू तारण शिकेळ, मनुश्यलाद दिन्नाम मंडळीला वजन येयदूर. ");
INSERT INTO wbq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","इंगा मग पेत्र इंगा योहान इदी प्रार्थना वेळला मद्यानी मूळ वाजता मिन्दिक परमेश्वर भवनला फोदूर. ");
INSERT INTO wbq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","इंगा फुट्टीनोट अपंग इल्ला वगा मणशी उंड्या, भवनला सुंदर फेर दरवाजा देगार भवनलोंग फोयेतोर्णी भिक आडगेदेंक धीन्नाम वान येवार तरी येकाफोई फेटदूर. ");
INSERT INTO wbq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","पेत्र इंगा योहान भवनला फोतुणार, इल्ला सुशी वाड वारणी भिक आळग्या. ");
INSERT INTO wbq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","आपुळ पेत्र, योहान संगा वान टकटक सुस्का, आन्या, “मा तीकुड सूळ.” ");
INSERT INTO wbq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","आप्पुड वार तीकेल येमाना शिकी, इल्ला आशा फेटी वाळ वार तीकुड लक्ष आंच्या. ");
INSERT INTO wbq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","इंगा पेत्र आन्या, “येंडी इंगा बंगार ना देगारा येमीच लेद; पण येम ना देगारा उंडाद. आदी नीन निक इस्तान, नासरतटोळ येशु ख्रीस्तन फेरता लेशी नळदेंक आंट.” ");
INSERT INTO wbq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","इंगा वाड वांदी मंची शेई फेटी वान लेप्या: आप्पुड लगेच वान पंजाल इंगा घोट्याल की ताकत वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","इंगा वाड उडी मती नीला फड्या इंगा नळदेंक आंट्या, इंगा वाड नळस्का इंगा उडी मतका इंगा द्यावार्दी स्तुती शेस्का वान संगा परमेश्वर भवनला फोया. ");
INSERT INTO wbq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","इपुड आंदार मंदी वान नळस्ताना इंगा द्यावार्दी स्तुती शेस्तांना सुश्यार. ");
INSERT INTO wbq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","इंगा यवाड मंदिरदी सुंदर फाटक देगारा भिक आळगुदू भिक आळगीदेंक वाड इळे उंडाळ वान ओळखाशीर आप्पुड वांकी येम आय्या दीनता संगेम चकीत इंगा आश्चर्य आयीर. ");
INSERT INTO wbq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","आप्पुड वाड पेत्रन इंगा योहान सांगा ने उंड्या, आंदार मंदी संगेम आश्चर्य शेस्का शालमोनदी दरवाजा मंडप आनीने जागाला, वान तीकुड फारका वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","इदी सुशी पेत्र आ मंदीक उत्तर इच्या, वाड आन्या, “अरे इस्राएल मन्ससलू, दिन मिन्द्केल मीर आश्चर्य येनटीक शेस्तार? नाही तर मिम स्वता सामर्थ्यता किंवा सुभक्तीता इन नळदेंक आंचीनाम, इल्ला समजाशी मा तीकुड येनटीक लक्ष इच्ची सुस्तार? ");
INSERT INTO wbq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम, इसहाक, इंगा याकोब द्यावार, मा पूर्वजला द्यावार, वाड स्वता सेवक येशु इनदी गौरव शेशिनाळ. वान मीर मतीदेंक इचाकाळतीर, इंगा पिलात वान ईळशेळदी ठहरा मतीनेन्का पण मीर वान देगारा नाकारास्तीर. ");
INSERT INTO wbq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","मीर तर यवाड पवित्र इंगा नीतिमान वान नाकारास्तीर, इंगा घातक मणशीन माक इयाला आंका इल्ला आळगुतीर. ");
INSERT INTO wbq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","इंगा जीवन इचेटोन मीर जेमता मतुतीर; वान द्यावार सचीनेकेल लेप्या दिंदी मिम साक्ष उंडाम. ");
INSERT INTO wbq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","इंगा वान फेरता वान फेर मिन्दुल विश्वास तीकेल यवारणी मीर सुस्तार, इंगा ओळखास्तार आ इ मंशीन शक्तीमान शेशिनाळ. इंगा, वान तीकेल शिकीने विश्वासताने मीर आंदार मुंदार इनकी इदी पूर्ण आरोग्य इच्चीनाड.” ");
INSERT INTO wbq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“तर इपुड हे तमुळलु नीन जाणास्तान की अज्ञानता मीर आले मी अधिकारील पण इदी शेशिणाळ, ");
INSERT INTO wbq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पण मना ख्रिस्तड दुख येत्ती, आंका द्यावार वान आन्नी संदेष्ट्याल आयी, संदेष्ट्याल नोरता येम पहिलाने शपीन्या, आदी दिन लेका पूर्ण शेशीनाड. ");
INSERT INTO wbq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","तर मि पापलू तुड्सकाडाला, आंका पश्च्याताप शेयना, इंगा तीर्गुंडा दिन इचांग की आरामदी वेळल प्रभून देगारकेल दावाला; ");
INSERT INTO wbq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","इंगा मी इचांग पहिला नेमाशीनेळ, ख्रिस्त येशु इन वाड आम्पडीयाला. ");
INSERT INTO wbq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","आन्नी माटलाद सुस्थिती डबल स्थापित आईळ काळपर्यंत स्वर्गला वांकी नीलचकाम अवश्य उंडाद, आ काळ बद्दल युग सुरवात नुस द्यावार स्वता पवित्र संदेष्ट्याल नोरता शापिनाळ. ");
INSERT INTO wbq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","यला मोशेळ तर शापिनाळ की, ‘प्रभू द्यावार मी इचांग ना लेका संदेष्टा मी तमुळला लोन्केल येल्यार. वाड येम पण मिक शपी आदी आंता वांदी एकांडा.’ ");
INSERT INTO wbq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","इंगा इल्ला आय्यी की यवार पण जेम आ संदेष्ट्याल दी ऐकायार वाड मंदी लोन्केल अगदी नष्ट शेशी. ");
INSERT INTO wbq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","इंगा, शमुवेल नुस येम संदेष्ट्याल परंपराता आय्या, यंता माटलाळका वचीर, आ आंदारकी आ दिवस बद्दल कळामत्या. ");
INSERT INTO wbq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","मीर संदेष्ट्याल बीळलु उंडार इंगा नि संततीता पृथ्वी मिन्दुली कुळलु आशीर्वादित आय्यी, इल्ला अब्राहमनि माटलाळी, ‘द्यावार मी पूर्वजला संगा जो करार शेश्या आ करारटोर मीर बीळलु उंडार.’ ");
INSERT INTO wbq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","द्यावार सेवक येशु इन लेपि पहिला मी तीकुड आम्पडीच्या, दिनकस्रोम की, वाड मी लोन प्रत्येकोन मी दुष्कर्मकेल तीर्गुते मिक आशीर्वाद इयाला.” ");
INSERT INTO wbq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पेत्र इंगा योहान मंदीन माटलाळतांना, याजक परमेश्वर भवनदी रखवाली शेशेटोळ सरदार इंगा सदुकी इर वार देगारा वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","वार कोफामता उंडीर कि पेत्र इंगा योहान मंदीक सिखा मतुदूर कि, येशुन तीकनुस सचीने मंदीक पुनरुत्थान उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","आप्पुड वार वारणी फटीर इंगा मापकाळ आईन्या दांचांग बंदीशाळाला फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","तरी वचन ऐकाशेटोर नुस संगेम जन विश्वास फेटीर; इंगा विश्वास फेटीने मंसलाद संख्या सुमारे पाच हजार मंदी उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","मग दुसरा दिवस इल्ला आय्या, की वारदी अधिकारी, आब्बागार इंगा नियाम्शास्त्रटोर शिक्षकलु इर यरूशलेम शहरला ओकाताळा जमा आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","दांटल्या महायाजक हन्ना इंगा कयफा, योहान, आलेक्सांद्र मुख्य याजक सिकंदर इंगा यावार आंदार महायाजकला नातेवाईकलु उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","इर पेत्र इंगा योहान नि मधातला नीला फेटी आळगिर, “इदी मीर या सामर्थ्यता, किंवा या फेरता शेस्तीर?” ");
INSERT INTO wbq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","आप्पुड पेत्र पवित्र आत्माता पूर्ण आईन्यापुड, वारणी आन्या, “अरे मंदी अधीकारीलाला, इंगा आब्बागार, ");
INSERT INTO wbq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","वगा बिमार मणशी मिंदा उपचार आय्या म्हणजे वाड येटतोन शिंगार शेशीर इ विषयला जर इफोद माद चौकशी इफोद आतुनाद? ");
INSERT INTO wbq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","तर मिक आंदार की इंगा इस्राएल मंदीक इदी यरका उंडाला, की यवान मीर क्रूस मिंदा इस्तीर, यवान द्यावार सचीनोरकेल लेप्या, आ नासरत येशु ख्रिस्त फेरता, इ मणशी शिंगार आय्या इड मी मुंदार नीला फडीनाळ. ");
INSERT INTO wbq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","या राय मीर कटेतोर नाकारास्तीर आदी कोनशिला राय आय्या आदी इदे उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","इंगा तारण दुसरा येवार लोना लेद येवार तीकेल मनाद तारण आय्यी; इल्ला दुसरा यादुच फेर मोडामकिंदा मन्सुलाला इचीनेद लेद.” ");
INSERT INTO wbq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","आप्पुड पेत्रद इंगा योहानदी हिम्मत सुशी, इंगा इदी निरक्षर इंगा बिना शिकाशिनेर मनसलू उंडार, इदी ओळखाशी वारनी आश्चर्य शेशीर इंगा इर येशुन संगतीला उंडीर इल्ला वार ओळखाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","आप्पुड वाड शिंगार आईने मणशीन वार देगारा नीला फडीनेळ सुशी, दिनकस्रोम वार पेत्र इंगा योहानदी विरोध शेशेटी खोटा येम पण आनेदेंक पूर्ण लेकुंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","इंगा वारन सभा बेटीक फोयेळदी आज्ञा इच्ची वार आपसाला चर्चा शेशेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","वार आनीर, “इ मनुष्यलान मनाम येम शेयाला? येनटीक की खरेमे वार शेईता प्रसिद्ध चमत्कार आयीनाय यरुशलेम शहरला नीलचेटोरकि अन्दार्क यरका उंडाद; इंगा दांदी मनाम नकार शेशु शकाम. ");
INSERT INTO wbq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पण इदी मंदीला इंगा पसरारोद, दांचांग मनाम इल्ला धमकी इयाला की, दिन मुंदार मीर इन फेरता यवारनीच माटलाळा कुंडा.” ");
INSERT INTO wbq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","मग वार पेत्र इंगा योहाननि वापस कुतेशी आज्ञा शेशीर की मीर येशुन फेरता येमीच माटलाळा कुंडा इंगा शिका पण मता कुंडा. ");
INSERT INTO wbq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पण पेत्र इंगा योहान वारकी उत्तर इच्ची आनीर, “द्यावार पेक्षा मिद इनेद इदी द्यावार विचारता बरोबर का चुक उंडाद, इदी मिरे ठरायमत्ना. ");
INSERT INTO wbq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","येनटीक की याय माटलु मिम सुशीनाम इंगा ऐकाशिनाम आय मिम शपकाम बंद शेयाम.” ");
INSERT INTO wbq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","आप्पुड वार वारनी धमका मती ईळशेशीर, येनटीक की मंदी कस्रोम वारकी शिक्षा येला शेयाला. इदी वारकि एमी समजा कुंदु, यणटिकी घडाशीने माटला इचांग आंदार मंदी द्यावार्दी गौरव शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","येनटीक की या मणशी मिंदा इदी बागा शेशेळदी चमत्कार घाडाशिन्या वाळ चाळीस वर्ष कना जास्त वयटोळ उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","आप्पुड पेत्र इंगा योहान इळीनेन्का, वार स्वता मंदी तीकुड वचीर इंगा मुख्य याजकलु इंगा आब्बागार येम पण आंनीनडीर वार आंदार आंता शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","आदी ऐकाशी वार एकचित्त आय्यी उंच शब्दता द्यावार्नी आंटार, “ये प्रभू, मोळाम, पृथ्वी, समुद्र इंगा दांटलोनी आंताच यवाड निर्माण शेश्या वाड नुये उंडाव. ");
INSERT INTO wbq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","नी सेवक, मा पूर्वज दावीद इन नोरता पवित्र आत्माता नु आंटी, ‘राष्ट्र्ल येनटीक चीडाश्या इंगा मंदी उतेंगाणे कल्पनाल येनटीक शेशीर? ");
INSERT INTO wbq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","प्रभून उलटा इंगा वान ख्रीस्तन उलटा पृथ्वीटोळ राजा युद्ध इचांग तैयार आयीर इंगा अधिकारी ओकाताळा जमा आयीर.’ ");
INSERT INTO wbq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","येनटीक की खरेखरेमे यवारकी नु अभिषेक शेस्ती वाड नि पवित्र सेवक, येशु दिन उलटा इ नगरला इंगोगो राष्ट्र इंगा इस्राएल मंदी इर संगा हेरोद इंगा पंतय पिलात जमा आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","दिनकस्रोम की येम पण आते दिनकस्रोम नि शेईता इंगा नि इच्छाता पहिला नेमाशिण्या आदी वार शेयाला. ");
INSERT INTO wbq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","तर ये प्रभू, इपुड नु वार धमकील तीकुड सूळ इंगा मिम मा दासला तीकुड स्वता वचन संदेशलाक संगेम हिमंतता माटलायेळदी समर्थ इयाला. ");
INSERT INTO wbq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","नु नीद शेई मंदीन बागा शेशेदेंक मुंदार शेस्ताना इल्ला शेय नि पवित्र सेवक येशु इन फेरता चमत्कार इंगा अद्भुतलु घडाला इल्ला पण शेय.” ");
INSERT INTO wbq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","इंगा वार प्रार्थना शेशी नेन्का या जागाला जमा आयनीर आदी हालाश्या, इंगा वार आंदार पवित्र आत्माता निंडी फोईर, द्यावार्दी वचन हिमंतता माटलाळदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","आप्पुड विश्वास शेशेटोर वगा मनुद इंगा वगा जेमुद उंड्या: इंता की यवार पण स्वताद धन स्वताद आना कुंदुर. वारद आणता आंता मदिद उन्डाद. ");
INSERT INTO wbq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","इंगा प्रेषित फेदा सामर्थ्यता, प्रभू येशुन पुनरुत्थान विषयला साक्ष इदू, इंगा वार आंदार मिंदा फेदाद कृपा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","वार लोन्केल यवारकीच एमी कमी लेकुंड्या, येनटीक की यंता मंदी भुमी इंगा इलूटोर मालक उंडीर आंता मंदी आदी आम्मीर इंगा आम्मीने वस्तुलाद किंमत येकोचीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","इंगा आदी प्रेषितला काळळा देगारा फेटीर, मग यलायला यवार्की गरज आंटूदू, आला-आला वार प्रत्येकोर्की फंची इदूर. ");
INSERT INTO wbq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","इंगा कुर्प बेटला नीलचेटोर लेवी योसेफ, यवान प्रेषितलु बर्णबा, म्हणजे उत्तेजन कोडकु इल्ला फेर इचनीर. ");
INSERT INTO wbq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","वांदी भुमी उंड्या, आदी आंबी दानी दुडलु येकोची प्रेशितला काळला देगारा फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","आप्पुड हनन्या फेरटोळ वगा मनुष्य इंगा वान वळती सप्पीरा इर स्वताद भुमी आम्बीर, ");
INSERT INTO wbq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","मग वाड आ दुडलाटा काही भाग वळती संमतीता फेट कोण्या, इंगा काही भाग येकोची प्रेशितला काळला देगारा फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","आप्पुड पेत्र आन्या, हनन्या, नु पवित्र आत्मा संगा खोटा माटलाळाला इंगा भुमी किंमत लोन्केल काही फेटकोनाला इल्ला शैतान नि मनला येनटीक निम्प्या? ");
INSERT INTO wbq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","यपुड नीता उंड्या आदी नी स्वत: लेकुंड्या एम्? इंगा यपुड आंबुती दान्द्द वचिं दुडलू नी देगार लेकुंड्या? नु इदी माटा नी मनला येनटीक येकोस्ती? नु मणशी संगा लेद तर परमेश्वर संगा लबाडी शेस्ती. ");
INSERT INTO wbq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","हनन्याड इ माटलु ऐकाशीन्या गरमे जेम इळश्या इंगा ऐकाशेटोर आद्री फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","आप्पुड काही जवानोर लेशी वान गुंडाळीचीर, इंगा बेटीक एका फोई बुळशी वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","दान नंतर मुड घंटाल आयीनेन्का वान वळती नोनिक वच्या, पण येम आय्या आदी दांकी समजाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","आप्पुड पेत्र दान आन्या, “नाक शप मीर इंताळलाने भुमी आम्बुतीर येम.” इंगा आदी आन्या, “हाऊ, इंनीलाने.” ");
INSERT INTO wbq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पण पेत्र दान आन्या, “नु इंगा नी मोगुड प्रभून दी परीक्षा सूळदेंक येनटीक सहमत आतीर? सुळना यवार नि मोगुन बुळशीर वारी काळलु दरवाजा देगाराने उंडाय, आयी निनु पण येतकोन बेटीक फोयी.” ");
INSERT INTO wbq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","आप्पुड लगेच वान काळळा देगारा फडी जेम ईळश्या, इंगा मोबीळलु नोनिक वचीर आप्पुड आदी सचीनेद; इल्ला आढळाश्या इंगा वार दान बेटीक एका फोई दान मोगुन देगारा बुळशीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","इंगा आंता मंडळी इंगा यवार इ माटलु ऐकाशीर वार आंदारला आदिर फडया. ");
INSERT INTO wbq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","आप्पुड प्रेषितला शेईकेल मंदीला संगेम चमत्कार इंगा अद्भुतलु घडादू. इंगा वार आंदार ओकाचित्तता शलमोन दरवाजा मंडपला जमा आदूर. ");
INSERT INTO wbq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","इंगा अविश्वासी मंदी लोन्केल यवार वार संगा मिळादेंक धसा कुंदुर; तरी मंदी वारनी थोर मानादूर, ");
INSERT INTO wbq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","इंताने लेद तर विश्वास फेटेतोर संगेम मनसलू इंगा आंडेर दी समुदाय प्रभूनकी शिकु. ");
INSERT INTO wbq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","इंनी चमत्कारलु घडाश्या की मंदी बिमारोरनी येतकोन दावा मिंदा येकोचीर इंगा मंचाम मिंदा इंगा पलंगला मिंदा फंडा मतुदूर कि पेत्र वस्ते तर वानदी सावली ने वार लोन्केल यवाराना मिंदा फडाला. ");
INSERT INTO wbq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","इंगा यरुशलेम शहर, देगारी चारुतीकुडी उरटोर संगेम मंदी बिमार इंगा अशुद्ध आत्माळ आंटी नोरणी येकोन वदुर. ");
INSERT INTO wbq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","आप्पुड महायाजकलु इंगा वार आंदार सोबतील यवार सदुकी पंतटोर सदस्य उंडीर प्रेषितलाद संगेम कोफाम शेशेदेंक आंटीर दिनकस्रोम वार कारवाई शेशेळदी ठहरा मतीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","इंगा वार मना शेतलू प्रेषितला मिन्दा येशी वारणी सार्वजनिक बंदीशाळाला फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पण आफोद प्रभून दूत जेलूय दरवाजा उघडाश्या इंगा वारणी बेटीक येकोची आन्या, ");
INSERT INTO wbq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“फोंडा, इंगा परमेश्वर भवनला नीला फडी इ जीवन दी आंता संदेश मंदीक शपना.” ");
INSERT INTO wbq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","इदी इनी फदु फुटीन नग्रेम वार परमेश्वर भवनलोंक फोई उपदेश इद्देंक आंटीर, इक्काड महायाजक इंगा वान सोबतीक उंडीर वार वची महासभान इंगा इस्रायेलटोर आंदार प्राचीन मंदीन वगातळा कुस्तेशीर, इंगा वारणी ऐकोदेंक बंदीशाळातीकुड आम्पीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","पण आकाड फोईनेर शिपाईलनी वार जेलला शिका लेर, दांचांग वार वापस वची शपीर, ");
INSERT INTO wbq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“बंदीशाळा शिंगार व्यवस्थित बंद शेशिनेय इंगा दरवजा देगारा पहारेकरील नीला फडीनेर माक काम्पीचिर, पण जेल उघडाशी नेन्का माक नोना यवार काम्पियाल्या.” ");
INSERT INTO wbq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","इदी बातमी ऐकाशी दिंदी येम परिणाम आय्यी, दिन बद्दल परमेश्वर भवन सरदार इंगा मुख्य याजक मंदी घोटाळयाला फडीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","इंताळला यवार तरी वाची वारकी इल्ला शपीर, सूळना, “या मंशीन मीर जेलला फेटीनिन्टीर आदी तर परमेश्वर भवनला नीला फडी मंदीक शिक्षण इस्तुणार.” ");
INSERT INTO wbq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","आप्पुड सरदार शिपाइला संगा फोई वार संगा येकोन वच्या, पण ताकत आनचांदे येनटीक की वारकी बिता आदू की मंगलान गुंडलु मतारोद. ");
INSERT INTO wbq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","वार वारणी ऐकोन वाची महासभा मुंदार नीला फेटीर, आप्पुड महायाजक वारणी आळग्या, ");
INSERT INTO wbq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“इ फेरता शिक्षण इया कुंडा, इल्ला मिम मिक लक्षता शपीनीन्टीम की लेद, तरी सूळना, मीर स्वता शिकवनिता यरुशलेम शहर निम्पेशीनाळ इंगा इ मणशी रक्तामपात दी दोष मा मिंदा येकोदेंक सुस्तुणार.” ");
INSERT INTO wbq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","पण पेत्र इंगा इंगोगो प्रेशितलु उत्तर इच्चीर, “मिम मणशी पेक्षा द्यावार्दी आज्ञा माना बेक, ");
INSERT INTO wbq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","या येशुन मीर क्रूस मिंदा टांगाशी मतुतीर, वान मना पूर्वजला द्यावार येत्या. ");
INSERT INTO wbq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","वाड इस्रायलकि पश्चाताप इंगा पापलाद क्षमा इदी इद्देंक द्यावार वान मंची शेई तीकुड अधिपती इंगा ताराशेतोड इल्ला उंचपद इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","इ माटा विषयला मिम साक्षी उंडाम इंगा द्यावार स्वता आज्ञा पाळाशेटोरकी याद पवित्र आत्मा इचीनेद उंडाद आदी पण साक्षी उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","इदी ऐकाशी वार चीडास फोईर इंगा वारणी जेमता मतेळदी विचार शेशेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पण आंदार मंदी प्रतिष्टीत मानाशिनेळ गमलीयेल फेरटोळ वगा परुशी शास्राध्यापक उंड्या, वाड न्यायसभाला नीला फडी आ मनुष्यलान रवा वेळ बेटीक आंपडीदेंक शप्या. ");
INSERT INTO wbq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","मग वाड वारणी आन्या, “अरे इस्राएल मंदी, मीर मनुष्यलाद येम शेस्तार दिन बदल जपाशी उंडा. ");
INSERT INTO wbq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","येनटीक की काही दिवसला पहिला, ठुदास इड मुंदार वची नीन यवार तरी उंडान, इल्ला आंटूनाळ, वांकी सुमारे चारशे मंदी शिकाला. वान मतिर इंगा यंता जन वान मानादूर वार आंदारदी दाणादान आय्यी वाळ लेद आंका आईणार. ");
INSERT INTO wbq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","वान यंकाकेल गालीलटोळ यहुदा नावनिशी आयेळ दिवसला मुंदार वच्या इंगा वाड स्न्गेम मंदीन फीटवाशी स्वता नाडला आंच्या वानदी पण नाश आय्या. इंगा यंता जन वान मानादूर वार आंदारदी पांगापांग आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","दांचांग नीन मिक इपुड शप्तान, इ मनुष्य देगार नुस दुराम उंडा इंगा वारणी फोनिंडा येनटीक की इदी बेत किंवा फनी मनुष्यद उंटे नष्ट आय्यी. ");
INSERT INTO wbq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पण इदी द्यावार्दी उंटे मिक इदी येपुड नष्ट शेशेदेंक दाकाफी, मीर फक्त द्यावार विरोधी ठहराश्यार.” ");
INSERT INTO wbq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","आप्पुड वार वारदी शप्काम मान्य शेशीर, वार प्रेषितलान कुतेशी वारणी मतिर इंगा येशुन फेरता माटला कुंडा इल्ला बारकाईता शपी ईळशेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","वार इ माटाता खुश आय्यी महासभा मुंदार येली फोईर की मनाम वान फेर इचांग अपमान आयेळ इचांग तर ठहराला. ");
INSERT INTO wbq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","इंगा दिनाम, परमेश्वर भवनला इंगा इलूइलूक शिकामतेळदी, इंगा येशु इळे ख्रिस्त उंडाळ इदी सुवार्ता गाजामतेळदी वार इळा लेकुंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","आ दिवसाला यपुड शिष्यालदी संख्या संगेम वाढादेंक आंट्या, ग्रीक भाषा माटलायेटोर इंगा इब्री भाषा माटलायेटोर मिंदा कुरकुर शेशेदेंक आंटीर दिन्नाम सेवाला मा विधवालदी काळजी तीस्कुणार. ");
INSERT INTO wbq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","आप्पुड बारा प्रेषिटळू शिष्यगणलान कुतेशी आनीर, “मिम द्यावार्दी वचन शपेळदी इडशी तिनेळदी सेवा शैयाला इदी ठीक उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","तर बंधूल, मीर मना लोन्केल पवित्र आत्माता इंगा ज्ञानता पूर्ण इल्ला सात, प्रतिष्टीत मनसलू फुळकी तिंडा, वारणी मिम इ फनिक नेमाला. ");
INSERT INTO wbq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","म्हणजे, मिम स्वता प्रार्थना इंगा वचन सेवाला तत्पर उंडाला.” ");
INSERT INTO wbq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","इदी माटा आंदार मंदीक पसंत वच्या. वार विश्वासता इंगा पवित्र आत्माता पूर्ण इल्ला मणशी स्तेफन इंगा फिलीप्प, प्रखर, निकलाव तीमोन, पार्मिना इंगा यहुदी मतलेका निकआंच अंत्यखियकर इरदी निवड शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","वारणी वार प्रेषितला मुंदार नीला फेट्या, इंगा वार प्रार्थना शेशी वार मिंदा शेई फेट्या. ");
INSERT INTO wbq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","मग द्यावार वचन पसरास्का फोय यरुशलेम शहरला शिष्यालाद संख्या संगेम वाढास्का फोया; याजक वर्गलोन्टोर संगेम मंदी इ विश्वासकी मान इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तेफन कृपा इंगा सामर्थ्य इटलाता पूर्ण आय्यी, मंदीला फेदाय अद्भुतलु इंगा चिन्ह शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","आप्पुड सिबिर्तीन फेर मंदी स्भास्थान्लोन काही मंदी आल्ले कुरेनेकर इंगा आलेक्सांद्रीये नगरलोन काही मंदी, इंगा किल्कीया इंगा आशिया प्रांतलोन काही मंदी लेशीर इंगा स्तेफन जताक वादविवाद शेशेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","पण वाड या ज्ञानता इंगा या आत्माता माटलाळदू वारकी वार शेईता मुती इया दा कुंदु. ");
INSERT INTO wbq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","आप्पुड वार काही मंदिद दोंगाता मनलू तीपीर, “मिम स्तेफननि मोशेन उलटा इंगा द्यावार उलटा दुर्भाषण शेस्तांना ऐकास्तीम इल्ला आनेदेंक फारामातीर.” ");
INSERT INTO wbq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","इंगा मंदीक, आबागारकी इंगा नियमशास्त्र शिक्षकलान चिता मत्या, वार स्तेफन मिंदा चाल शेशी वान फटी न्यायसभा मुंदार एकाफोया. ");
INSERT INTO wbq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","इंगा वार खोटा साक्षी दारलू नीला फेटीर, वार आनीर, “इ मणशी इ पवित्र जागा इंगा नियमशास्त्र उलटा दुर्भाषण शेशेळदी इळाळ. ");
INSERT INTO wbq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","येनटीक की मिम वान इल्ला माटलाळतांना ऐकास्तीम, इ नासोरी येशु जागा मोडास काळी इंगा मोशेळ माक आंची इचीनेय चालीरीतील बदला मतेशी.” ");
INSERT INTO wbq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","आप्पुड न्याय सभाला कुशिंडेर आंदार मंदी वान तीकुड टकटक सुस्तांना वारकी वांदी मुती देवदूत मुती लेका काम्पिच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","महायाजक आन्या, “इ माटलु इले उंडाय येम?” ");
INSERT INTO wbq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","आप्पुड वाड आन्या, “बंधूजनलू इंगा आब्बागार, एकांडा, मना पूर्वज अब्राहम हारान प्रांतला फोई निलचेळ पहिला मेसोपटेम्या देशला उंडतांना गौरवशाली द्यावार वांकी दर्शन इच्या.” ");
INSERT INTO wbq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","इंगा आन्या, “नु स्वताद देश इंगा स्वता मनमाळलान इडशी नीन सुपिच्यान आ देशाला फो.” ");
INSERT INTO wbq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","आप्पुड वाड खास्द्येर देशकेल येली हारान नगरला फोई निलच्या; मग वान आबाड सचीनेन्का द्यावार वान आंदनुस तिशी सध्या मीर निलस्तार आ देशला येकोच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","पण दान्टल्या वांकी वतन इया लेकुंडीर. वान की बीळलु लेकुंडा पण द्यावार वांकी अभिवचन इच्या की इदी देश निक इंगा नि यंकाक नि बीळलाक वतन इल्ला इच्यान. ");
INSERT INTO wbq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","द्यावार इंगा इल्ला शप्या वान बीळलु इंगोगो देशला फोयी काही काळ निलच्यार, इंगा आ मंदी वारणी दास शेशी चारशे वर्ष वाईटता वागाश्यार. ");
INSERT INTO wbq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'या राष्ट्र दासला वार उंड्याला वारदी न्याय नीन शेश्यान' इंगा दान नंतर वार आंदकेल येली 'इ जगाला नाद उपासना शेश्यार,' इल्ला द्यावार आन्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","वाड अब्राहम की सुन्ताद करार आंची इच्या इदी करार आयीनेन्का अब्राहम की इसहाक आय्या, वांदी वाड आठवा दिवसनाळ सुंता शेश्या मग इसहाककी याकोब आय्या इंगा याकोब की बारा कुलपती आयीर. ");
INSERT INTO wbq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","मग कुलपतीर हेवा इचांग योसेफनि मिसर देशला आम्बेशीर, पण द्यावार वान संगा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","वाड वान मिन्दुळी आन्नी संकटला लोंकेल ईळपीच्या, इंगा मिसर देश राजा फारो इन मुंदार वांकी कृपा शिकीणेळ इंगा ज्ञानी इल्ला शेश्या. दांचांग फारो वान मिसर देश मिंदा इंगा स्वता आन्नी इनला मिंदा अधिकार नेमाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","मग आंदार मिसर: इंगा कनान इ देशला दुष्काळ फडी वार मिंदा संगेम संकटलु वच्या इंगा स्वता पुर्वाजलाक आन्नाम शिका कुंदु इल्ला आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","आप्पुड मिसर देशला धान्यल उंडाय, इदी ऐकाशी याकोब मी ना पूर्वजलाक पहिला खेपला आम्पडीच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","मग दुसरा खेपला योसेफ स्वता तमुळलाक ओळख इच्या; इंगा योसेफदी कुळ फारो राजाक तेलच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","आप्पुड योसेफ स्वता आबाड याकोब इंगा स्वता आंदार देगारटोर, म्हणजे पंच्याहत्तर मंदी इरनी फिल्चा. ");
INSERT INTO wbq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","दिन लेका याकोब मिसर देशला फोया; इंगा आंदू वाड, इंगा स्वता पूर्वजलु पण सची फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","वारी स्चीने फइल शकेमला पहुचामतीर फोई आ कब्रला फेतेशिर यादान अब्राहम शकेमला हमोर बिळा तीकेल कोनकोन्ड्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","पण यपुड प्रतिज्ञा पूर्ण आयेळदी दिवस देगार वच्या याद परमेश्वर अब्राहम नी शेशिन्या, तर मिस्रला आ मंदी वाढास फोईर इंगा संगेम आय फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","योसेफ दी माहिती लेनेळ इल्ला दुसरा राजा मिसर देश गादी मिंदा कुसनी पर्यंत इल्ला नळश्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","वाड मा जाती संगा हुशारी शेशी मा आब्बा तातागार संगा इंदुळ नंताक खराब वागाश्या कि वार्की स्वता बीळलान फेक्या बेक आय्या कि वार जिवंत उंडा रोद. ");
INSERT INTO wbq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","आ काळला मोशेंदी जन्म आय्या, वाड द्यावार नजरता संगेम शिंगार उंड्या; वांदी पालन पोषण मूळ महिनाल पर्यंत वान आबान इलकाडा आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","मग वान बेटीक येस्काळ देंक वचीनेन्का, फारोन कुतुर वान तीस्कोनी स्वता कोडकु आंका वान फेदोळ शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मोशेन की मिसरी मंदिद आंता ज्ञान शिक्या; इंगा वाड भाषणला इंगा फानीला पराक्रमी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","मग वाड देगार देगारा चाळीस वर्षटोळ आय्या, आप्पुड मना बांधव म्हणजे इस्राएलटोर बीळलु इरदी भेट तीस्कोनाला इल्ला वान मनला वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","आप्पुड मोशेळ इस्राएललोन यवार तरी ओकोन मिंदा अन्याय आतुनाद, इल्ला सुशी इ जाचाशीने मंशीद कैवार तीस्कोन्या इंगा मिसरीन मती वांदी बदला तीस्कोन्या: ");
INSERT INTO wbq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","आप्पुड द्यावार वान शेईकेल बांधवलाड सुटका शेस्तुनाळ इदी वारकी तेलचीन्याला इल्ला वांकी वाटाशिन्याला, पण आदी वारकी समजाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","मग दुसरा दिवस यवारु इस्राएलटोर जगडाम आळतांना वाड वार मुंदार वच्या इंगा वारनि जमा शेस्तुनाळ; वाड आन्या. 'इलूटोर, मीर बांधव; उंडार येकमेकोर मिंदा अन्याय येनटीक शेस्तार?' ");
INSERT INTO wbq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","आप्पुड यवाळ स्वता शेजारी मिंदा अन्याय शेयदू, वाड वान दोबीची आन्या, 'निक मा मिंदा अधिकारी इंगा न्यायाधीश यवार शेशीर? ");
INSERT INTO wbq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","नीना नु मिसरनि मतेस्ती, आला नन्नु पण मतेदेंक सुस्ताव येम?' ");
INSERT INTO wbq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","इदी शब्द ऐकास्ने गरमे मोशेळ फ्री फोया इंगा मिद्यान देशला परदेशी आय्यी नीलच्या; आंदू वांकी इद्दार कोडकूल आयीर. ");
INSERT INTO wbq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","मग चाळीस वर्ष निंडी नेन्का, सिनाय पर्वत जंगला वगा झुडूपलोन अग्नीज्वालाला वगा देवदूत वांकी काम्पिच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मग मोशेळ अग्निज्वालाद दृश्य सुशी नेन्का, वाड संगेम आश्चर्य चकीत आय; इंगा इदी दृश्य सुल्देंक वाड देगार फोया, आप्पुड प्रभूनदी वाणी आय्या की, ");
INSERT INTO wbq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'नीन नि पूर्वजला द्यावार, अब्राहम द्यावार, इसहाक द्यावार, इंगा याकोब द्यावार उंडान.' आप्पुड मोशेळ थरथर नळग्या इंगा वांकी आकाळ सुशेळदी हिम्मत काल्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","येनटीक की प्रभु परमेश्वर वान आन्या, 'नु नि काळला लोनी शपूल ती, येनटीक की या जागा मिंदा नु नीला फडीनाव आदी पवित्र जागा उंडाद.' ");
INSERT INTO wbq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मिसर देशालोन ना मंदीद विपत्ती नीन खरेमे सुशीनान; वारी आवाजलु नीन ऐकाशिनान;वारणी इळपिदेंक नीन दिगीनान तर इपुड नळ, नीन नीनु मिसर देशला आम्पडीस्तान. ");
INSERT INTO wbq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","नीनु अधिकारी इंगा न्यायाधीश यवार शेशिणार, इल्ला आनी, 'या मोशेन वार झिडकासनीर?' वानकीने झुडूपला आईने देवदूत तीकेल, द्यावार अधिकार इंगा मुक्तीदाता आंका आम्पडीच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","मिसर देशला, तांबडा समुद्रला, इंगा जंगला चाळीस वर्ष अद्भुत फानील शेशी इंगा चिन्हल सुपीची आ मंदीन बेटीक एका फोया. ");
INSERT INTO wbq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","वाले मोशे इस्राएल मंदीन आन्या, 'द्यावार मी बांधवला लोन्केल, ना लेका संदेष्टा मी इचांग तैयार शेशी.' ");
INSERT INTO wbq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","जंगललोन मंडळीला सिनाय पर्वत मिंदा वान संगा माटलाळेटोळ देवदूत संगा इंगा मना पुर्वजला संगा यवाड उंड्या वाड इळे उंडाळ. वान्के मनाक इचेळ इचांग जिवंत वचनलु शिकीनाय. ");
INSERT INTO wbq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","वांदी ऐकाशेळदी मना पूर्वजलाड इच्छा लेकुंड्या; तर वार वान धिकार शेशीर इंगा स्वताद अंतकरण मिसर देश तीकुड तीपी. ");
INSERT INTO wbq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","वार अहरोननि आनीर, 'मा मुंदार नळश्यार इल्ला देवताल माक शेशी. येनटीक की यवाळ मंगलान मिसर देशकेल येकोचीर आ मोशेंदी येम आय्या, इदी माक तेलाद.' ");
INSERT INTO wbq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","मग आ दिवसाला वार वासरदी मूर्ती बना मतिर, इंगा दान मुंदार 'यज्ञ शेशी' स्वता शेई फनी बद्दल आनंद उत्सव शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","आप्पुड द्यावार वार तीकुड बेनु तीप्या इंगा वारकी मोळामलोनी सेनाग्नाद पूजा शेस्काम इडशेश्या; इ विषयला संदेष्ट्याल पुस्तकला लीवाशी उंडाद 'इ इस्राएल घराण्या, मीर चाळीस वर्ष जंगला बलिदान इंगा यज्ञ नाक शेस्तीर येम? ");
INSERT INTO wbq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","मोलखदी मंडप इंगा रेफान दैवलाड तारा म्हणजे पूजा शेशेदेंक: मीर या प्रतिमाल शेस्तीर आय मीर येतकोनी तीस्कोन्टीर; नीन पण मिंगलान बाबेल आतुक ऐकोन फोई फेट्यान. ");
INSERT INTO wbq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","साक्षीद मंडप जंगलला मना आब्बा तातागार मधातला उंड्या यला वाड ठहरा मत्या यवाड मुसान आन्या याद फोई नु सुस्ती दान लेका दिन बना मत. ");
INSERT INTO wbq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","याय राष्ट्रळ द्यावार वार मुंदारकेल घालामत्या, वारदी देश स्वता ताबाला तीस्कोन्या, आप्पुड वाड मिळामतीने मंडप वार यहोशवा संगा आ देशला येकोच्या. इंगा दावीद काळ पर्यंत परंपरा नंताक आले फेट्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दावीद मिंदा कृपा दृष्टी आय्या; इंगा याकोब गंगोद इचांग निलचेळदी जागा मिळामतेळदी विनंती शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","इंगा शालमोन वान इचांग इल्लु कट्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","तरी पण याय परात्पर वाड शेईता क्तीने इलकाळा नीलाळ; संदेष्ट्याळ आणिडाळ. ");
INSERT INTO wbq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","प्रभुळ आंटाळ, मोळाम नाद राजसन उंडाद, पृथ्वी नाद पादासन उंडाद. मीर ना इचांग या प्रकारदी इल्लु कट्यार? किंवा ना विशाव्याद जागा याद? ");
INSERT INTO wbq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ना शेईता इ आन्नी वस्तूल शेस्तीर येम? ");
INSERT INTO wbq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“अरे तट गन्तुटोर इंगा मनता इंगा गुमालता सुंता न आईनेर, मंदी मीर तर पवित्र आत्मान; हमेशा विरोध शेस्तार यला मी पूर्वजलु आले मीर पण. ");
INSERT INTO wbq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","यावार्दी पाठलाग मी पूर्वजलु शेया लेर इल्ला संदेष्ट्यालला यवार आयीर येम? यवार आ नीतिमान मनशि वचेळ विषयला पहिला शप्या वारणी वार जेमता मतिर; इंगा इपूद वान फटी इचेटोर इंगा जेमता मतेटोर मीर येलीणार. ");
INSERT INTO wbq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","इल्ला मिक देवदूतला योगता योजाशिनेद नियाम्शास्त्र शिक्कीन्या, पण मीर आदी पाळा लेर.” ");
INSERT INTO wbq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","वांदी भाषण ऐकाशेटोर सभाला सभासदला अंतकरणकी इंता झोंबाश्या, वार फनलु तोटाल तिनटूणार. ");
INSERT INTO wbq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पण पवित्र आत्माता पूर्ण आय्यी वाड मोळाम तीकुड टकटक सुश्या, आप्पुड द्यावार्दी तेज इंगा द्यावार मंची तीकुड येशुड नीला फडीणेळ वांकी काम्पिच्या. ");
INSERT INTO wbq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","इंगा वाड आन्या, “सूळना, मोळाम उघडासनेद इंगा मणशी कोडकु द्यावार मंची तीकुद नीला फडीनेळ नाक काम्पिस्तुनाळ.” ");
INSERT INTO wbq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","आप्पुड वार बेग्याता गीरली, इंगा गुमा बंद शेस्का, ओकाजूटता वान फई मिंदा फारका फोईर; ");
INSERT INTO wbq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","मग वार वान शहर बेटीक तीशेशी गुंडलु मातीदेंक आंटीर: इंगा साक्षीदारलु स्वताय बटाल शौल फेरटोळ वगा माबिळा काळळा देगारा फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","वार गुंडलु मतुतांना स्तेफन प्रभुंदी धावा सेस्का आन्या, “ये प्रभू येशु, ना आत्माद स्वीकार शेय.” ");
INSERT INTO wbq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","मग मोकाळलु तेकाशी वाड बेग्याता गिरल्या, “ये प्रभू, इदी पाप वान तीकुड मोजाक,” इल्ला माटलाळी, वाड सची फोया. ");
INSERT INTO wbq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","स्तेफनदी याद खून आय्या वांकी शौलदी संमती उंड्या. आ दिवस नुस यरुशलेम शहर; इंदूळ ख्रिस्तन मंडळीद संगेम छळ सुरु आय्या, प्रेषितला शिवाय इंगोगोर आंदार विश्वास फेटेटोर शिष्य यहुदिया इंगा शोमरोन प्रांतलोन, कानकोपराला पांगाशी फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","काही धार्मिक मंदी स्तेफननि बुळशीर इंगा वान इचांग वार संगेम शोक शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","शौल ख्रिस्त मंडळीद छळ शेशेदेंक सुरुवात शेश्या; वाड इल्लु इल्लुक फोदू विश्वास फेटेटोर मनसलू इंगा आंडेर इरनी फटी जगुका एका फोदू, इंगा जेलला येस. ");
INSERT INTO wbq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","विश्वास फेटेटोर आन्नी तीकुड पस्राशीनीर यंदाना विश्वास फेटेतोर फोदूर आंदू मंदीक सुवार्ता शपदूर. ");
INSERT INTO wbq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलीप्प शोमरोन प्रांतलोन वगा शहरला फोया, वाड ख्रीस्तद घोषणा शेश्या आंदूटोर मंदी फिलीप्पी माटलु ऐकाशीर, इंगा वाड शेशीने चमत्कारलु सुशीर. ");
INSERT INTO wbq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","फिलीप्प याय चिन्हल शेयदू इंगा याय माटलु वारकी शपदू, आय वार लक्षपूर्वक इंदूर. ");
INSERT INTO wbq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","येनटीक की यवार्की अशुद्ध आत्माल आंटीन्या वार लोन्केल संगेम मंदीलोन्केल वार कीरली येली फोईर; आंदू संगेम लंग्ड्योर इंगा पक्षघाती मंदी शिंगार आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","दान इचांग शहर लोन्टोर मंदी संगेम खुश आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","शिमोन फेरटोळ मणशी आ नगरला नीलदू, वाड जादूय प्रयोगलु शयदू; वान प्रयोग इचांग शोमरोन प्रांत लोन्टोर मंदी आश्चर्य चकीत आदूर, वाड स्व्तान संगेम फेद्दावाड समजास. ");
INSERT INTO wbq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","शिन्नावोर नुस फेद्दावार पर्यंत मंदी वांदी लक्षपूर्वक इंदूर, वार आंदुर, “द्यावार्दी महान शक्ती इल्ला यवारनी आंटार वाडे इ मणशी उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","वाड स्वता जादूता संगेम काळ पर्यंत मंदीन चकीत शेयदु, आंका मंदी वांदी इंदूर. ");
INSERT INTO wbq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पण यपुड द्यावार्दी राज्य इंगा येशु ख्रिस्तन दी फेर दिन बद्दल फिलीप्प आ मंदीक सुवार्ता शपेतापुड वार वान मिंदा विश्वास फेटीर, आद्दे वेळ वार बाप्तिस्मा तीस्कोनीर, वारला यला मन्सूल उंडीर आले आंडेर पण उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","स्वता शिमोने विश्वास फेट्या: इंगा वांदी बाप्तिस्मा आयनेंका, वाड फिलीप्प संगा निलदेंक आंट्या; इंगा आईनेय चमत्कारलु इंगा अद्भुत चिन्हल सुशी, शिमोन आश्चर्यता थक्क आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","यरुशलेम शहरलोन प्रेषितलु इदी ऐकाशीर की शोमरोनलोन मंदी द्यावार वचनदी स्वीकार शेशीर, दांचांग प्रेत्र इंगा योहान इरनी प्रेषितलु शोमरोनटोर मंदी तीकुड आम्पडीचीर. ");
INSERT INTO wbq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","पेत्र इंगा योहान वचीर, आप्पुड वार शोमरोनी विश्वास फेटेटोर मंदीक पवित्र आत्मा शिकाला आंका, प्रार्थना शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","इ मंदीद प्रभू येशुन फेरता बाप्तिस्मा आईन्या, पण पवित्र आत्मा इंगा वार मिंदा दा लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","मग पेत्र इंगा योहान वार नत्ती मिंदा शेई फेट्टीर, इंगा वारकी पवित्र आत्मा शिक्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","शिमोन सुश्या की, प्रेषितलाद शेई फेटुते मंदीक पवित्र आत्मा शिकताद आप्पुड शिमोन प्रेषितलाक दुडलु इच्ची आन्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“नीन यवार मिंदा शेई फेट्यान वांकी पवित्र आत्मा शिकी, इल्ला अधिकार नाक पण इयांडा.” ");
INSERT INTO wbq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पेत्र शिमोननि आन्या, “नीद इंगा नि दुडलाद नाश कावाला; येनटीक की, द्यावार्दी दान दुडला ताकतता कोंकेन तीस्कोन्देंक नु विचार शेस्ती.” ");
INSERT INTO wbq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","इ फनीला नु मा सहभागी आइ शकायाव, येनटीक की नीद अंतकरण द्यावार मुंदार शिंगार लेद. ");
INSERT INTO wbq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","नु याय इ खराब माटलु शेशिनाव, दांचांग पाश्चयाताप शेय, प्रभून प्रार्थना शेय, कदाचित नि अंतकरणलोन विचारलाद वाड नीनु क्षमा शेशी. ");
INSERT INTO wbq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","येनटीक की नि मनला कडूपणा निंडीनेद उंडाद इंगा नु पाप बंधनला उंडाव, इदी नाक कम्पिच्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","शिमोन उत्तर इच्या, मीर शप्तीर दान लोंदी येमीच ना मिंदा दावाराद आंका मिरे प्रभून तीकुड ना इचांग प्रार्थना शेयना. ");
INSERT INTO wbq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","मग पेत्र इंगा योहान इर स्वताद साक्ष मंदीक इच्ची, “प्रभूनदी वचन गाजाशीनेन्का वार यरुशलेम शहरकी वापस वचीर, वापस वच्चेतापुड दावाला वार संगेम शोमरोनी उळाला सुवार्ता शपीर.” ");
INSERT INTO wbq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","परमेश्वर दूत फिलीप्प संगा माटलाळ्या वाड आन्या, “लेय इंगा यरुशलेम शहर नुस गज्जा शहर तीकुड फोताद आ दावाता दक्षिण तीकुड फो.” आदी दावा वाळवंट लोन्केल फोताद. ");
INSERT INTO wbq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","मग वाड लेश्या. इंगा फोया, दावाला वांकी ओकोळ इथिओपियाटोळ ओगा मणशी भेटाश्या, आ मणशी षंढ उंड्या, वाड इथिओपिया कांडके राणी तीकुड फेदा पदमिंदा अधिकारी आंका फनिक उंड्या. वाड राणी दान खजाना टोळ मुख्य उंड्या, वाड यरुशलेम शहरला उपासना शेशेदेंक फोईन्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","इपुड वाड वापस फोयेतापुड स्वता रथला कुसनी यशया संदेष्ट्याद पुस्तक वाचादू. ");
INSERT INTO wbq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","पवित्र आत्मा फिलीप्पनि आन्या, “आ रथ देगारा फो.” ");
INSERT INTO wbq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","मग फिलीप्प आ रथदेगार फारका-फारका फोया, आप्पुड वाड वान यशया संदेष्ट्यानदी पुस्तक वाचाशेतापुड इन्या, फिलीप्प वान आन्या, “नु येम वाचास्तुनाव आदी निक समजास्तुनाद येम?” ");
INSERT INTO wbq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","आ अधिकारी आन्या, “नाक इदी यला, समजाशी यवार तरी दिंन सोपा शेशी नाक शपा बेक?” इंगा वाड फिलीप्पकी रथाला येकी स्वता देगार कुशीनदेंक कुतेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","शास्त्र लेख लोंदी जो भाग वाड वाचादू आदी भाग दिनलेका उंड्या, “बली इचांग एका फोये मेंढर्या लेका वाड उंड्या; लोकरलु कातरा शेटोर मुंदार शांत निलचे कोकरला लेका वाड शांत नीलच्या, वाड स्वताद नोर उघडायाले: ");
INSERT INTO wbq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","वान ईज्जत तीशीर वान लीन अवस्थाला वांकी न्याय शिकाल्या: वान गोन्गोतदी वर्णन यवार शेश्यार? येनटीक की पृथ्वी मिंदूळदी वांदी जीवन संपा मतीर.” ");
INSERT INTO wbq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","आ अधिकारी फिलीप्पनी आन्या, “कृपा शेशी नाक शप, इदी यवार बद्दल माटलाडीनार? वाड स्वता बद्दल माटलाडतुनाड, की दुसरा यवार विषयला माटलाडतुनाड?” ");
INSERT INTO wbq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","मग फिलीप्प नोर उघडाश्या; इंगा शास्त्रलेखलोन यशया संदेष्ट्यान भागकेल सुरुवात शेशी येशुन विषयदी सुवार्ता वांकी शप्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","वार इद्दार प्रवास शेशेतापुड. वगा तळ देगारा वचीर; आप्पुड अधिकारी आन्या, “सूड, इंदू नेळ उंडाय; नाद बाप्तिस्मा शेशेदेंक याद अडचण उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्प आन्या, जर मनाम स्वता आंता अंतकरणता विश्वास फेटतार तर बरोबर उंडाद, वाड उत्तर इच्या, येशु ख्रिस्त द्यावार कोडकु उंडाड इल्ला नीन विश्वास फेटतान. ");
INSERT INTO wbq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","इंगा षंढाड रथ थांबा मतेद आज्ञा इच्या, नंतर फिलीप्प इंगा षंढ इर इद्दार दिगी नेळाला फोईर, इंगा फिलीप्प वांदी बाप्तिस्मा शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","वार यपुड नेळा बेटीक वचीर, आप्पुड प्रभून आत्मा फिलीप्पनि दुराम येका फोया; इंगा आ आधिकारिक फिलीप्प डबल कम्पियाल्या, पण वाड अधिकारी मुंदारकी आले संगेम आनंदता प्रवास शेस्का इल्लुक फोया. ");
INSERT INTO wbq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","मनाम अजोत नगरला उंडाम. इल्ला फिलीप्पकी काम्पिच्या इंगा मुंदारकी फोतांना या-या उरलू आंट्या आ आन्नी उरला वाड सुवार्ता शप्या, नंतर वाड कैसरीया शहरकी फोया. ");
INSERT INTO wbq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","शौल यरुशलेम शहरला प्रभून अनुयायीलनी इंगा पण धमकामतेद इंगा जेमता मतेशेद प्रयत्न शेयदू, दांचांग वाड महायाजक तीकुड फोया. ");
INSERT INTO wbq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","शौल दामिश्क शहर इंदूळ यहूदी सभास्थानलोन महायाजक तीकेल ख्रिस्त अनुयायीलनि फटीदेंक इल्ला अधिकार पत्रल आडग्या की, जर वांकी आंदू यवार 'आ दावामिन्दा' नडशेतोड, मग वाड मणशी उंटे किंवा आंडीद, शिकुते तर वाड वारणी कटी यरुशलेम शहरला एका दाला. ");
INSERT INTO wbq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","इंगा शौल दिमिष्क देगारा वच्या आप्पुड येकायेक, मोडाम लोन्केल संगेमे फेद्दा येलगु वानभोवती चमकाश्या; ");
INSERT INTO wbq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","शौल भुमी मिंदा फड्या इंगा ओगाट आवाज वान संगा माटलाडेतापुड वाड ऐकाश्या, हे “शौल, शौल, नु नाद छळ येनटीक शेस्ताव?” ");
INSERT INTO wbq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","शौल आन्या, “प्रभू नु यवार उंडाव?” आदी आवाज आन्या, “नीन येशुड उंडान, यवांदी नु छळ शेस्ती वाड नीने उंडान; ");
INSERT INTO wbq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","इपुड लेय, इंगा नगरलोंग फो, निक येम शेशेद उंडाद, आदी निक आंदु यवार तरी शप्यार.” ");
INSERT INTO wbq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","या मन्सूल शौल संगा प्रवास शेस्का उंडीर, वार आंदे शांत नीला फडीर आ मंदी आवाज ऐकाशीर, पण वारकी यवार कम्पियाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","शौल भुमी मिंदकेल लेश्या, वाड कनलू तेरश्या, पण वांकी येमीच कम्पिया कुंदु, दांचांग या मंदी वार संगा उंडीर वार वांदी शेई फटी वान दिमिष्क शहरला येका फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","मुड दिवस पर्यंत शौल की येमीच कम्पियाकुंदू, वाड येमी तीनाल्या किंवा तागाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दिमिष्कला येशुन ओगा शिष्य उंड्या वांदी फेर हनन्या उंड्या; प्रभू वान संगा दृष्टांतला माटलाड्या वाड आन्या, “हे हनन्या.” हनन्याड उत्तर इच्या, “नीन इंदू उंडान, प्रभू.” ");
INSERT INTO wbq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","प्रभूड हनन्यान आन्या, “लेय इंगा नीट फेर दावाता फो, आंदू यहुदांदी इल्लु फुडकू इंगा तार्सास शहर नुस वचीने शौल फेरोड मणशी बद्दल आडगु सध्या वाड आंदू उंडाड; इंगा प्रार्थना शेस्तुनाड. ");
INSERT INTO wbq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","शौल दृष्टांतला सुश्या की दांटल्या हनन्या फेरोड मणशी मना तीकुड एलुक वचीगास मना मिंदा शेई फेटतुनाड इंगा दान नंतर वांकी कम्शांक आंट्या वच्या, इल्ला वांकी कम्पिच्या.” ");
INSERT INTO wbq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","गान हनन्याळ उत्तर इच्या, “हे प्रभू, नीन आ मणशी विषयला संगेम मंदी नोरकेल ईननान; यरुशलेम शहर लोन्टोर नि संतला संगा वाड यंता खराब रीतीता वागाश्या इदी नीन इनीनान. ");
INSERT INTO wbq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","इंगा इपुड यवार नि फेर मिंदा विश्वास फेटतार इल्ला मंदीन कटी ऐकोन फोयेदेंक मुख्य याजकला तीकेल अधिकार पत्र तीस्कोनी इ शौल इंदू वचीणाड.” ");
INSERT INTO wbq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पण प्रभुड आन्या, “फो, राजालकी इंगा इंगोगो राष्ट्रलकी इंगा इस्राएल बीळलु इर मुंदार नाद फेर येका फोयेदेंक वाड ना निवडासने पात्र उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ना फेर इचांग याय माटलू वांकी सहन शैया बेक आय्यी नीन वांकी सुपीची इच्यान,” ");
INSERT INTO wbq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","हनन्या येल्या इंगा यहुदान इल्लुक फोया, वाड शौल नती मिंदा शेई फेट्या इंगा आन्या, “शौल, तमूडा, प्रभू येशुड नीक इकाड वचेतापुड दावा मिंदा दर्शन इच्या वाडे नन्नु नि तीकुड आम्पडीच्या, दिनकस्रोम की, नीक वापस दृष्टी दावाला इंगा नु पवित्र आत्माता परिपूर्ण कावाला.” ");
INSERT INTO wbq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","लगेच फक्कू लेका येम तरी शौल कनला मिंदकेल किंदा फड्या, इंगा वांकी कम्पिदेंक आंट्या शौल आंदकेल लेशिनेन्का वांदी बाप्तिस्मा शेस्काम्ला वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","नंतर वाड आन्नाम तिनी नेन्का वान शरीरला ताकत वच्या, शौल काही दिवस दिमिष्क इंदुळ शिष्याल संगा नीलच्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","दान नंतर सरळ सभास्तानला फोई शौल येशुन फेरुद घोषणा शेशेदेंक आंट्या, येशुड इड द्यावार कोडकु उंडाड. ");
INSERT INTO wbq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","या मंदी शौलय माटलु इनीर वार आंदारकी संगेम नवल वाटाश्या वार आनीर, “यरुशलेम शहर लोन्टोर या मंदिद येशुन फेर मिंदा विश्वास उंडाद, वार आंदार्दी नाश शेशेदेंक सुशेतोड इडे लेड येम? वाड येशुन अनुयायीलनि अटक शेशेदेंक इंदू वचीनाड इंगा वाड वारणी यरुशलेम शहर लोन मुख्य याजकला मुंदार नीला फडा मतेतोड उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पण शौल जास्तीतजास्त सामर्थ्य शाली आका फोया, वाड इदी सिद्ध शेश्या की येशुड इडे ख्रिस्त उंडाड इंगा वानी पुराव्याल इंता पक्का उंड्या. दिमिष्क इंदूटोर यहुदील वान संगा जगडाम आडी शकाया लेर. ");
INSERT INTO wbq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","काही नाळा बाद, यहुदी मंदी शौलनि जेमता मतेशेद कट रचाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","यहुदी मबूफगुल शहर गेटमिन्दा पहारा इदूर इंगा शौलनि फटदेंक दावा सुदूर. वारकी शौलनि मतेशेद उंड्या, पण वारदी इदी माटा शौल की समजाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ओगानाड मबुला शौल यवार्की सिखा मतीन्या इल्ला काही अनुयायील शहर नुस फोयेदेंक शौल की मदत शेशीर, अनुयायील शौलनि वगा डाल्याला फेटीर, मग डाल्यान उर कूस मिन्द्केल मबुलोन टाईमला किंदीक इडशीर. ");
INSERT INTO wbq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","मग शौल यरुशलेम शहरला फोया आंदू विश्वास फेटेतोर परिवारला मिसळाशेद वाड प्रयत्न शेश्या, पण वार वांकी आदृदूर वारकी विश्वासे कुसनाकुंदू शौल खरेमे येशुन शिष्य आयिनेड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","पण बर्णबा शौलनि स्वीकार शेश्या इंगा वान तीस्कोनी प्रेषितला तीकुड फोया. बर्णबा शप्या की, शौल प्रभुन दामिश्क दावाला सुशीनाड प्रभुड वान यला माटलाड्या इदी पण वाड पूर्ण शप्या, मग वाड प्रेषितलाक शप्या की येशुन विषयला सुवार्ता शौल फेदा धेर्याता दिमिष्क इंदुड मंदीक शप्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","मग शौल अनुयायीला संगा आंदू नीलच्या, वाड यरुशलेम शहरला आन्नी तीकुड फोया. इंगा धेर्यता प्रभुंदी सुवार्ता शपिदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","शौल हमेशा ग्रीक भाषा माटलाडेतोर यहुदील संगा माटलाडदू वाड वार संगा जगडाम आडदू, पण वार वान मतशेद प्रयत्न शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","यपुड बंधू जनलाक इदी तेलच्या आप्पुड वार वान कैसरीया इंदूक येकाफोयीर, दानबाद वान आन्देल तार्सासकी आम्पीर. ");
INSERT INTO wbq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","इ प्रकारता आंता याहुदिया, गालील प्रांत, शोमरोन इ प्रदेशलोन मंडळीक शांती लाभाश्या; इंगा मंडळी पवित्र आत्मा सांत्वनला इंगा परमेश्वर येर्पुला वाढास्का फोया. ");
INSERT INTO wbq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","मग इल्ला आय्या की, पेत्र यरुशलेम शहर भोवती उळाला तीरग्या, लोद इ नगर यवार द्यावार पवित्र मंदी उंडीर वारनी भेटाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","लोद इंदू वांकी ऐनेयास फेरटोळ मणशी शिक्या, वान शरीर लोन्केल घाली फोईने इचांग वाड पंगु आय फोइन्या इंगा आठ वर्ष पलंग मिंदाने उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पेत्र वान आन्या, “हे ऐनेयास येशु ख्रिस्त नीनु शिंगार शेशी; लेय स्वताद गादी शिंगार शेय.” ऐनेयास ताबडतोबड नीला फड्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","लोद इंदू नीलचेटोर आंदार मंदी इंगा शारोनला नीलचेटोर वान सुशीर, आप्पुड वार आंदार प्रभून तीकुड तीरगीर. ");
INSERT INTO wbq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","यापो शहरला येशुन वगा शिष्याद निलदू, दांदी फेर तबिथा उंड्या, (ग्रीक भाशाला दांदी फेर “दुर्कास” उंड्या, दांदी अर्थ हरण) आदी हमेशा मंदी इचांग शिंगार फनील शेयदू गरीबोरकी दानधर्म शेयदू. ");
INSERT INTO wbq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","यपुड पेत्र लोदला उंड्या, आप्पुड तबिथाद बिमार फड्या इंगा सची फोया ; मंदी दांदी फई कडगी इंगा माडीमिन्दुड ओगा खोलीला फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","यापो इंदूटोर शिष्यल इनीर की, पेत्र लोदला उंडाड, लोद इदी यापो देगार उंडाद, दांचांग वार इद्दार मंसलान आंपीर, वार वान विनंती शेशीर, वार आनीर, “लगान शेयंडा, मा तीकुड लगान दांडा.” ");
INSERT INTO wbq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","पेत्र तयार आय्या इंगा वार संगा फोया, यपुड वाड आंदू पोहोचाश्या आप्पुड वार वान माडीमिन्दुड ओगा खोलीला एका फोईर, आंदार विधवाल आंडेर पेत्र गोलुंग नीला फडीर, वार यडदूर, दुर्कस जिता उंडीने आप्पुड याय झगाल आदी कुर्शिन्या आय वार प्रेत्रक सुपिचीर. ");
INSERT INTO wbq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","पेत्र खोलीलोन आंदारणी बेटीक तिश्या वाड मोकाळ टेकाशी प्रार्थना शेश्या इंगा दुर्कसदान शरीर तीकुड तीरगी वाड आन्या, “हे तबिथा लेय” आप्पुड आदी कनलू उघडाश्या, यपुड आदी पेत्रन सुश्या आप्पुड आदी लेशी कुसन्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","वाड दानकी स्वताद शेई इच्ची नीला फडदेंक मदत शेश्या, नंतर तबीथादान वारकी सुपिच्या, आदी जिवंत उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","यापोलोन आंदार मंदीक इदी समजाश्या, दांटल्योन संगेम मंदी प्रभून मिंदा विश्वास फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","यंक्सार इल्ला आय्या की, वाड यापोतला शिमोन फेरोड यवारतरी तोललु कमाशेटोळ चांभारोन इंदू संगेम नाळ नीलच्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कर्नेल फेरटोळ मणशी कैसरियाला नीलदू, वाड इटलीक फेर पलटणला शताधीपती उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","कर्नेल इड भक्तीमान उंडी स्वता परिवार जताक द्यावार्दी येर्पू फेटेतोड उंड्या; वाड गरीबोरकी संगेम दान धर्म शेयदू इंगा वाड हमेशा द्यावार्दी प्रार्थना शेयदू. ");
INSERT INTO wbq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ओगा नाळ मदयाम मूड वाजशेद आप्पुड, कर्नेलकी दृष्टांत आय्या, वाड आदी स्पष्टपणे सुश्या, आ दृष्टांतला द्यावार वगा दूत वान तीकुड वच्या इंगा वान आन्या, “कर्नेला!” ");
INSERT INTO wbq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","कर्नेल द्यावार दूत तीकुड सुशी आद्री फो अन आन्या. “येम उंडाद, प्रभू?” द्यावार दूत कर्नेलान आन्या, “द्यावार नीद प्रार्थना इनिनाड, या माटलू नु गरीबोर की इचीनाव, आय द्यावार सुशीनाड द्यावार्की नीद मतीक उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","नु यापो उरला मन्सूल आंपडी इंगा शिमोन फेरोन मंशीन एका दा, शिमोननी पेत्र इल्ला पण आंटार. ");
INSERT INTO wbq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","वाड शिमोन फेरोड चांभार ईलकाडा नीलस्तुनाड वांदी इल्लु समुद्र कंटामकी उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","कर्नेलनि माटलाडी नेन्का द्यावार दूत येली फोया मग कर्नेल वान इद्दार विश्वासी नोकरलान इंगा ओगा धर्मशील शिपाईन कुतेसकुन्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","कर्नेल इ मुगुरकी आईनेद आंताच शप्या इंगा वारणी यापोक आम्पीच्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दुसरानाळ आ मन्सूल यापो उरदेगारा वचीर, आदी मद्यानदी टाईम उंड्या, आद्दे टाईमला प्रार्थना शेशेदेंक पेत्रड माडी मिन्दिक फोया. ");
INSERT INTO wbq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","पेत्रक आकाल आयीन्या, वांकी येम तरी तिना बुदि आय्या, वार पेत्र इचांग तिनेद तैयारी शेशेतापुड पेत्र बेशुद्ध आय्फो. ");
INSERT INTO wbq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","इंगा मना मुंदार मोडाम उघडाशी फेदा सुकाल लेका नालुंग कोपर्याल फटी ईडशिनेद ओगाट चादर पृथ्वी मिंदा दिगतुनाद इल्ला दृष्टांत वांकी आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","दांटल्या पृथ्वी मिंदूळी आन्नी प्रकारी नडशेय, जरगुका फोयेय, मोडामला येगरेय पक्षील उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","मग ओकाट आवाज पेत्र इन्या, “पेत्र, लेय; दिनलोनी याय पण प्रानील मतका मुड.” ");
INSERT INTO wbq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पण पेत्र आन्या, “नीन आला यपुडूच शैयान, प्रभू याद अशुद्ध इंगा अपवित्र उंडाद इल्ला याद पण तींडी नीन यपुडूच तिना लेन.” ");
INSERT INTO wbq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","पण आदी आवाज वान इंगा आन्या, “द्यावार इ माटलु शुद्ध शेशिनाड, आटलान अशुद्ध आनाक.” ");
INSERT INTO wbq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","इल्ला मूड तूकुल आय्या; मग आदी पात्र मोडामला मिन्दिक तीस्कुनीर. ");
INSERT INTO wbq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","पेत्र आद्रीगास इ दृष्टांत दी अर्थ येम उंडी इविषयला विचार शेयदेंग आंट्या, या मंदीन कर्नेल आम्पडीचीन्या, वारकी शिमोनदी इल्लु कम्पिच्या वार दरवाजा मुंदार नीला फडीनीर. ");
INSERT INTO wbq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","वार आडगीर, “शिमोन पेत्र इंदे नीलस्ताड येम?” ");
INSERT INTO wbq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पेत्र इ दृष्टांत विषयलाने विचार शेशेतापुड, आत्मा वान आन्या, “इन, मुगुर मन्सूल नीनु फुडकुतुणार. ");
INSERT INTO wbq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","लेय इंगा पायऱ्याल दिगी किंदीक फो, येनटीक की नीने वारणी आम्पडीचीनान, एमी विचार शेयांदे वार येन्का फो.” ");
INSERT INTO wbq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","मग पेत्र किंदा आ मन्सूला तीकुड फोया, इंगा आन्या, “मीर यवारणी फुडकुतुणार वाड नीने उंडान मीर इंदूक येनटीक वचीणार?” ");
INSERT INTO wbq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","आ मन्सूल आनीर, “ओगा पवित्र द्यावारदूत मिक आमंत्रण इद्देंक कर्नेलकी शपिन्या कर्नेल इड शताधीपती उंडाड, वाड नीतिमान मणशी उंडाड वाड द्यावार्दी उपासना शेस्ताड, आंदार यहुदी मंदी वांदी आदर शेस्तार, नीनु इल्लुक कुतेशी निय माटलु इनाला इल्ला द्यावारदूत वांकी शापिनाड.” ");
INSERT INTO wbq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","पेत्र वारणी नोनिक कुतेस कोण्या इंगा मबुलाला मुक्काम शेशेदेंक शप्या, दुसरानाळ पेत्र तैयार आय्या इंगा आ मुगुर मंसुला संगा फोया, यापो इंदूटोर काही तम्मुळ पण पेत्र संगा फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","दुसरानाळ पेत्र कैसरीया शहरला वच्या, कर्नेल वांदी दावा सूदू, वाड स्वता देगार टोर सोबतील इंगा नातेवाईक इरनि पण स्वता ईलकाडा जमा शेशिन्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","यपुड पेत्र नोनिक फोया, आप्पुड कर्नेल वांकी भेटाश्या, कर्नेल पेत्रन काळ मोक्की आदरता वान नमन शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पण पेत्र आन्या, “नीला फड, नीन नि लेकाने मणशी उंडान.” ");
INSERT INTO wbq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","पेत्र वान संगा माटलाळका इंटलोन्ग फोया इंगा नोना संगेम मंदी जमा आईनोर वाड सुश्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","पेत्र आ मंदीन आन्या, “मिक इदी यर्का उंडाद की, यहुदी मणशी इंगोगो विदेश मंदी इल्लुक फोकाम किंवा वार संगा संबंध फेटकाम इदी यहुदी नियमलान फट्टी लेद, पण द्यावार नाक सुपिचीनाद कि, निन इंगोगो मन्सूलान अशुद्ध किंवा अपवित्र मानायाराद. ");
INSERT INTO wbq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","इद्दे कारण इचांग यपुड इ मंदी नन्नु कुतेदेंक वचीर, आप्पुड नीन वार संगा जगडाम शेयालेद, इपुड, कृपा शेशी नाक शपना, मीर नन्नु इंदू येनटीक कुतेस्तीर?” ");
INSERT INTO wbq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","कर्नेल आन्या, “नालुंग दिवस पहिला, ना इंटल्या नीन प्रार्थना शेयदुन, बरोबर इदे टाईमला आंटे मद्यांनी मूड वागता नीन प्रार्थना शेयदुन, अचानक ओगा मणशी नामुन्दार नीला फड्या, वाड लखलखीत चमकदार बटाल येस्कोंड्या.” ");
INSERT INTO wbq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","आ मणशी आन्या, “कर्नेल द्यावार नीद प्रार्थना ऐकाश्या, गरीब मंदीक याय वस्तूल नु इस्ती आय द्यावार सुश्या, द्यावार नीद मतीक तीस्ताड. ");
INSERT INTO wbq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","दांचांग यापो इ शहरला काही मन्सूल आंपडी इंगा शिमोन पेत्रन कुतेसको, पेत्र इड शिमोन चांभार ईलकाडा नीलस्तूनाड इंगा वांदी इल्लु समुद्र देगार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","आप्पुड नीन लगाने मिक निरोप आंपडीस्तीन, मीर इंदूक वचीणार इदी मिद फेदाद कृपा उंडाद, इपुड माक येम पण शपेद आज्ञा प्रभूड मिक इच्चीनाड, आदी ईनदेंक मिम आंन्दार इपुड इंदू द्यावार मुंदार जमा आईनाम.” ");
INSERT INTO wbq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","पेत्र माटलाडदेंक सुरुवात शेश्या नाक इपुड इदी खरेम तेलचीनाद की, “द्यावार्की प्रत्येक मणशी सारखाने उंडाड. ");
INSERT INTO wbq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","प्रत्येक राष्ट्रला यवार पण वांदी भक्ती शेस्ताड इंगा योग्य आदी शेस्ताळ, वान द्यावार स्वीकारास्ताळ, मणशी या देशटोड उंडाड, इदी महत्वद लेद. ");
INSERT INTO wbq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","द्यावार इस्राएल मंदीन माटलाळ्या, द्यावार वारकी सुवार्ता आम्पडीच्या की, येशु ख्रिस्ततीकेल शांती दुन्यामला वचीनाद, येशुड आंदार प्रभू उंडाड.” ");
INSERT INTO wbq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","“आंता यहुदिया प्रांतला येम आय्या इदी मी आंदारकी यरका उंडाद, दांदी सुरुवात योहान मंदीक बाप्तिस्मा विषयला गालील प्रांतला याद संदेश इच्च्या, दांता आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","नासरथ येशुन विषयला मिक यरका उंडाद, द्यावार वांकी पवित्र आत्माद इंगा सामर्थ्यद अभिषेक शेश्या, येशुड आन्नी तीकुड मंदी इचांग शिंगार शेस्का फोया, या मंदी खराब आत्माता फटीनोर उंडीर वारणी येशुड शिंगार शेश्या, येनटीक की द्यावार वान संगा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","येशुड पूर्ण यहुदिया प्रांतला इंगा यरुशलेम शहरला येम-येम शेश्या आय आन्नी माटलु मिम सुस्तीम इंगा मिम वान साक्षीदार उंडाम, पण येशुन मतेशीर, कट्या क्रूस मिंदा वार वान टांगाशी मतीर. ");
INSERT INTO wbq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","पण द्यावार तिसरा दिवस वान जिवंत शेश्या द्यावार येशुन मंदीक स्पष्ट सुडानीच्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","पण आंदारच मन्सूल येशुन सुडा लेर, द्यावार वारणी पहिलाने साक्षीदार आंका निवडाशिन्या, वारे वान सुशीर, आ साक्षीदार मिम उंडाम येशुड सचीनोर लोन्केल लेशीनेन्का मिम वान सोबत तिन्टीम ताग्तीम. ");
INSERT INTO wbq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","येशुड माक 'मंदीक उपदेश शेशेदेंक शप्या, जिता उंडीनोरदी इंगा सचीनोरदी न्याय शेशेदेंक द्यावार वान निवडासनाड' इदी शपिदेंक वाड माक आज्ञा शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","यवार पण येशुन मिंदा विश्वास फेटतार, वान क्षमा शेस्काम्ला वच्ची, येशुन फेरला द्यावार आ मणशी पापलाद क्षमा शेशी, आंदार संदेष्ट्याल इदी खरेम उंडाद इल्ला आंटार.” ");
INSERT INTO wbq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पेत्र इदी माटलाडेतापुडे वानी माटलु इन्का कुशिन्नोर आंदार मंदी मिंदा पवित्र आत्मा दिग्या. ");
INSERT INTO wbq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","यहुदी सुंता आईनोर विश्वास फेटेतोर यवार पेत्र जताक वचीनीर, वार चकीत आय्यीर, यहुदी लेनेर मंदीमिंदा पण पवित्र आत्मा दानद वर्षाव आयनाद, दांचांग वार चकीत आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","इंगा यहुदी लेनेर मंदीक वेगवेगळा भाषा माटलाडेतापुड इंगा द्यावार्दी स्तुती शेस्तापूड यहुदी मंदी इनीर. ");
INSERT INTO wbq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","मग पेत्र आन्या, “इ मंदीक नेळाता बाप्तिस्मा इद्देंक मनाम लेद आनी शकायाम, यला माक शिक्या, दान लेकाने वार की पण पवित्र आत्मा शिकीनाद.” ");
INSERT INTO wbq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","दांचांग पेत्र कर्नेल, वान नातेवाईक इंगा सोबतील वारकी येशु ख्रिस्तन फेरता बाप्तिस्मा इचेद आज्ञा शेश्या, मग पेत्र इंगा काही नाळ वार संगा नीलवाला इल्ला आ मंदी वान विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","यहुदी लेनेर मंदी पण द्यावार वचनदी स्वीकार शेशीर इदी यहुदिया प्रांतलोन प्रेषितलु इंगा विश्वास फेटेटोर बंधूल ऐकाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","पण यपुड पेत्र यारुशलेम शहर की वच्या, आप्पुड सुंता आईनेद यहुदी विश्वासी गट वान मिंदा टीका शेशेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","वार आनीर, “यवार सुंता काणेर इंगा इंगोगो राष्ट्रटोर उंडार इल्ला विश्वास फेटेटोर मंदी इल्काडा मीर फोतीर, इंताने लेद तर मीर वार संगा रोट्या पण तींटीर.” ");
INSERT INTO wbq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","दांचांग पेत्र वारकी आंता घटना सविस्तर स्पष्ट शेशी शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","पेत्र आन्या, नीन यापो शहरला प्रार्थना शेस्तांना नाक तंद्री आंटीने लेका आय्या इंगा नीन वगा दृष्टांत सुस्तीन की, फेदा सुकाल लेका नालुग कोपर्याल फटी ईळशिनेद वगा चादर ना देगारा वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","नीन दान तीकुड टक सुशी विचार शेसुदुन, नीन वार्दिन्त्ला पृथ्वी मिन्दुद नालुग काळलाय प्राणील, जंगली पशुल, जरगेटी प्रानील इंगा मोळामला उडाशेटी पक्षीळ नीन दानटल्या सुस्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ओकाट वाणी ना संगा माटलाळतांना नीन ऐकास्तीन, “पेत्र लेय, मतेस गास मुड!” ");
INSERT INTO wbq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","पण नीन आंटीन, “प्रभू, नीन इल्ला यपुडूच शैयान, नीन अपवित्र किंवा अशुद्ध इल्ला यपुडूच इल्ला तीना लेन.” ");
INSERT INTO wbq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","मोळाम लोन्केल आ वानिता इंगा उत्तर इच्छा, “द्यावार इ माटलु शुद्ध शेशिनाद, आटलान अशुद्ध आनाक.” ");
INSERT INTO wbq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","इल्ला मूळ तीकुला घाडाश्या, इंगा वाड आन्नी इंगा मिंदा मोळामला तीस्कोन्या. ");
INSERT INTO wbq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","इंताळला सूळना, मुगुर मनसलु या इंटल्या मिम उंटीम दान मुंदार कैसरीया नुस ना तीकुड आम्पडीचिनेर मुगुर मनसलू वची नीला फेडीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","आत्माता नाक यादू प्रकारदी शक न शैयांदे वार संगा फोयेदेंक शप्तीन, इदी सहा बंधूल यवार उंडार, वार पण ना संगा उंडीर, मिम कर्नेल इल्लुक फोतीम. ");
INSERT INTO wbq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","कर्नेलकी स्वता इलकाडा द्यावार दूत येला नीला फडीनेळ काम्पिच्या इदी माक शप्या, द्यावार दूत कर्नेलनि आन्या, “काही मनसलू यापो नगर आम्पडी, शिमोन पेत्रन कुतेस्को. ");
INSERT INTO wbq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","वाड नीनु माटलाळी, वाड याय माटलु निक शपी, दांचांग नीद इंगा नि परीवारदी तारण आई.” ");
INSERT INTO wbq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","दान नंतर नीन ना भाषण की सुरुवात शेस्तीन, सुरुवातला यला पवित्र आत्मा मना मिंदा वच्या आले वाड वार मिंदा पण वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","आप्पुड नाक प्रभुंदी शब्द आठवण वच्या, प्रभूड आनिंड्या, “योहान मंदिद बाप्तिस्मा न्यळाता शेयदू इदी खरेम, पण मिद बाप्तिस्मा पवित्र आत्माता आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","मनाम प्रभू येशु ख्रिस्त मिंदा विश्वास फेट्या आप्पुड यला मनाक आले वारकी पण सारखाने दान इच्चीन्या, मग द्यावारणी अडामतेटोळ इल्ला नीन यव्वार? ");
INSERT INTO wbq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","यपुड इर इ माटलू ऐकाश्या, आप्पुड वार शांत निलचीर, वार द्यावार्दी स्तुती शेशीर इंगा आनीर, “तर मग द्यावर यहूदी लेनोर की पण जीवन शिकाला दांचांग पश्चात्ताप बुद्धी इच्चीनाड.” ");
INSERT INTO wbq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्तेफननि सचिन बाद काळला याद छळ आय्या, दांचांग विश्वास फेटेटोर यरुशलेम शहरकेल दुराम जागाला फेनिका प्रांत, कुप्र बेत इंगा अंत्युखीया शहर पर्यंत पसरास फोईर, विश्वास फेटेटोर इ जागाला फक्त यहुदी मंदीक सुवार्ता शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","दिन लोन्केल काही विश्वास फेटेटोर कुप्र इंगा कुरेने इंदू नीलचेटोर उंडीर, यपुड इ मंदी अंत्यखीयाला वचीर, आप्पुड वार यहूदी लेनोर येशुन विषयला सुवार्ता शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभू विश्वास फेटेटोरकी मदत शेयदू इंगा बगाने फेदा गटता विश्वास फेट्या इंगा वार प्रभून दावाता फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","इविषयदी बातमी यरुशलेम शहरलोन विश्वास फेटेटोर मंडळी गुमा मिंदा वच्या, दांचांग यरुशलेम शहरलोन विश्वास फेटेटोर बार्णबान अंत्यखियाक आम्पडीचीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","यपुड बर्णबा अंत्यखियाक फोया, आप्पुड वाड सुश्या की, द्यावार इ मंदी मिंदा संगेम कृपा शेशिनाळ, दांचांग बर्णबा संगेम खुश आय फोया, अंत्यखियालोन आंदार विश्वास फेटेटोरणी वाड उत्तेजन इच्या, वाड वारकी शप्या, यपुड पण मिद विश्वास गमामता कुंडा, येपुड भी प्रभुंदी आज्ञा अंतकरनकेल पाळाय. ");
INSERT INTO wbq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","वाड शिंगार मणशी उंड्या इंगा पवित्र आत्माता इंगा विश्वासता पूर्ण उंड्या; आप्पुड प्रभूनकी संगेम मंदी शिकीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","यपुड बर्णबा तार्सासकी फोय आप्पुड वाड शौलनी फुळकुदू. ");
INSERT INTO wbq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","यपुड बार्णबा वान फुडक्या आप्पुड वाड शौलनि स्वता संगा अंत्यखियाक ऐकोन वच्या, शौल इंगा बर्णबा वर्षभर आंदू मंडळीला नीलची संगेम मंदीक शिका मत्या, अंत्यखियाला येशुन अनुयायील 'ख्रिस्त इदी फेर पहल्यांदा शिक्या. ");
INSERT INTO wbq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","इडे काळला काही संदेष्ट्याल यरुशलेम शहरकेल अंत्यखियाक वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","वार पैकी ओकोनदी फेर अगब उंड्या, अंत्यखियाला वाड नीला फड्या इंगा माटलाळदेंक आंट्या, पवित्र आत्मा मदतता वाड आन्या संगेम खराब काळ आंता पृथ्वी मिंदा वस्तूनाद, मंदीक तिनदेंक आन्नाम शिका फोई, सम्राट क्लौदिया राजा राज्य शेस्का उंड्या आप्पुड वान काळला इदी घडाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","विश्वास फेटेटोर ठरामतीर की, यहुदिया इंदूटोर मना तम्मुडलू इंगा शेल्यानलू की जास्तीत जास्त मदत आम्पडीचेळदी प्रयत्न शेयाला वगा-वगा शिष्य जास्तीत जास्त मदत आम्पडीचेळदी ठहरामतीर. ");
INSERT INTO wbq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","वार दुडलु जमा शेशी बार्णबा इंगा शौल इर तीकुड इच्या, मग बार्णबा इंगा शौल इर आय्यी दुडलु यहुदिया लोन आब्बागार तीकुड आम्पडीचीर. ");
INSERT INTO wbq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","आ वेळ सुमारला हेरोद राजा मंडळीलोन काही जनदी छळाला आंका वार मिंदा शेई येश्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","योहान तमूड याकोब इनकी वाड तलवारता जेमता मतेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","हेरोद सुश्या की, यहुदी अधिकारीलाक इदी आवडाश्या, दांचांग वाड पेत्रन सुद्धा अटक शेशेळदी ठहरामत्या, आदी बेखमीर रोट्याद दिवस उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","हेरोद पेत्रन अटक शेशी जेलला येश्या, वान रखवाली इचांग वान शिपाईला नालुंग चौकड्याळ स्वाधीन शेशीर, वल्हानडन फंडगा आयनेंका पेत्रन्की मंदीमुंदार येकोचेळदी योजना उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","दांचांग पेत्रन जेलला फेटीदेंक वच्या, पण मंडळी सातत्याता पेत्रन इचांग द्यावार तीकुड प्रार्थना शेस्का उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","पेत्र दोन शिपाईला नडमा फन्डकोंड्या, वान रोंड साखळीलता कटीनीर, जेलला दरवाजा देगारा इंगा काही शिपाईल पहरा इदूर, आदी मोबूलोंदी टाईम उंड्या इंगा हेरोद इल्ला विचार शेश्या की, दुसरा दिवस पेत्रन मंदी मुंदार एकादावाला. ");
INSERT INTO wbq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","आप्पुड सूडना, अचानक परमेश्वरदी दूत आंदू नीला फड्या, जेललोन खोलीला एकदम यलगु फड्या, द्यावारदूत पेत्रन संकान फटी वान लेप्या, द्यावारदूत आन्या, “लगान लेय!” आप्पुड पेत्रन शेईलोन साखळील गळाशी फड्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","द्यावार दूत पेत्रन आन्या, “बट्टाल येस्को इंगा नी शप्पूल फेटको,” मग पेत्र बटाल येस्कोन्या, मग द्यावार दूत आन्या, “नीद झगा फयला येस्को इंगा ना यंका दा.” ");
INSERT INTO wbq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","मग द्यावार दूत बेटीक फड्या इंगा पेत्र वान यंका नडदू, पेत्रंकी तेला कुंदु की, इदी खरेमे येम नडशिनाद, वांकी वाटाश्या मनाम दृष्टांत सूस्तूनाम. ");
INSERT INTO wbq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","पहिला इंगा दुसरा फेरी लोन पहारेकऱ्यालनी दाटीगास पेत्र इंगा द्यावार दूत लोखंडी दरवाजा देगारा वची पोहोचाशीर, आय्यी वार इचांग आपोआप उघडाश्या, पेत्र इंगा द्यावार दूत दरवाजा लोन्केल बेटीक फडीर, वार ओगा दावा पार शेशीर इंगा अचानक द्यावार दूत पेत्रन इडशी येली फोया. ");
INSERT INTO wbq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","पेत्रक मग तेलच्या की नक्की येम आय्या इंगा वाड आन्या, “इपुड नाक समजाश्या की प्रभूड खरेमे वान दुतनी ना तीकुड आंपिन्या इंगा वाड नन्नु हेरोद शेतलोन्केल इंगा यहुदी मंदीद पूर्ण आशा तेंपी नन्नु ईडपिचीनाड.” ");
INSERT INTO wbq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","इ माटाद जाणीव आयनेंका पेत्र मरियमदान इल्लुक फोया, आदी योहान यवान मार्क पण आंदूर वान आम्मा उंड्या, संगेम मंदी आ जागाला जमा आयनीर, वार आंदार प्रार्थना शेयदुर. ");
INSERT INTO wbq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पेत्र फाटकदी दरवाजा ठोकाश्या, आप्पुड रुदा फेरुद दासी फाटक उघडादेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","आदी पेत्रद आवाज लगेच ओळखाश्या इंगा संगेम खुश आयफोया, आदी फाटक उघडाशेद सुद्धा भूलाशी फोया, आदी नोनिक फारका फोया इंगा मंदीक शप्या, “पेत्र दरवाजा देगार नीला फडीनाड.” ");
INSERT INTO wbq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","विश्वास फेटेतोर रुदा दान आनीर, “नु पागल आईनाव येम!” पण पेत्रड दरवाजा देगार नीला फडीनाड, इल्ला रुदाद संगेम कळकळीता शपदु, आंका मंदी आनीर, “वाड पेत्र दूत उंडा बेक.” ");
INSERT INTO wbq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","पण पेत्र बेटीकेल फाटक सारखा कोटतुन्या, यपुड विश्वास फेटेतोर फाटक उघडाशीर, आप्पुड वार पेत्रन सुशीर, वार चकीत आयनीर. ");
INSERT INTO wbq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","पेत्र शेईता खूनवाशी तेपांग निलदेंक शप्प्या, मग वाड प्रभूड जेल लोन्केल यला ऐकोन वच्या इदी पूर्ण शप्या, वाड आन्या, “याकोब इंगा इंगोगोर तम्मुळलाक येम आय्या आदी शपना,” मग पेत्र आंदकेल येली दुसरा जागाला फोया. ");
INSERT INTO wbq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","दुसरा नाळ नस्कला शिपाईल संगेम दुखी आयफोइनिर, पेत्रद येम आईन्याला दिंदी वार विचार शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","हेरोद पेत्रन आन्नी तीकुड फुडक्या पण वाड वान फुडकी शकायाल्या, मग हेरोदाड पहारीकरलान प्रश्न आडग्या इंगा वारकी मृत्यू दंड इच्या, नंतर हेरोद यहुदिया प्रांतलोन्केल येली फोया, वाड कैसरीया शहरला फोया इंगा काही काळ नीलच्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोद सोर इंगा सिदोन नगरलोन मंदी मिंदा कोफाम फडीन्या, आ मंदी मिळाशी हेरोदनी भेटादेंक वचीर, ब्लस्तनी वार बाजूक तीपुदेंक वार जिंकाशीर, ब्लस्त इड राजान खाजगी सेवक उंड्या, मंदी हेरोद तीकुड शांतताद मागणी शेशीर येनटीक की वारदी देश तीने धान्यला बाबतीला हेरोदान देश भरोसा मिंदा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","हेरोद वारणी भेटादेंक वगा दिवस ठरायमत्या, आफोद हेरोद वांनी सुंदर दरबारी बट्टाल येस्कोनिंड्या, वाड न्यायासन मिंदा कुसनी मंदी मुंदार भाषण शेशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","मंदी बेग्गे आरोळी शेशी आनीर, “इदी तर द्यावार्दी वाणी उंडाद, मनशीद लेद!” हेरोदाळ इ स्तुतीद स्वीकार शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","इंगा वाड द्यावार्की गौरव इयाक फोया, दांचांग परमेश्वर दूत वान मिंदा वार शेश्या, वाड फुलगुल फडी सची फोया. ");
INSERT INTO wbq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","द्यावार्दी वचन जास्तीत जास्त मंदी नंताक पसरास्का फोया इंगा मंदीन प्रेरित शेयदू, विश्वास फेटेतोरदी गट दिनादिनाम फेदाद आदु. ");
INSERT INTO wbq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","बर्णबा इंगा शौल इरी यरुशलेम शहरलोनी फनील संपा मतीनेन्का वार अंत्युखियाक वापस वचीर, वार मार्क योहान इन वार संगा तीस्कोनीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अंत्यूखिया इंदुड ख्रिस्ती मंडळीलाकाई संदेष्ट्याल इंगा शिक्षकलु उंडीर, वार दिन लेका: बर्नबा, शिमोन निग्र, लुक्य कुरेनेकर, मनाएन (येवाड हेरोद संगा शिनाओड नुस फेदाओड आईन्या) इंगा शौल. ");
INSERT INTO wbq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","इर आंदार मन्सूल परमेश्वरदी आराधना शेस्का इंगा उपवास शेशेतापुड, पवित्र आत्मा वारणी आन्या, “बर्णबा इंगा शौलनि इरनी या फनीइचांग नीन कुतेशिनान दांचांग वारनी ना इचांग अलग शेयना.” ");
INSERT INTO wbq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","दिनिचांग मंडळी उपवास इंगा प्रार्थना शेश्या, वार बर्णबा इंगा शौल इर नती मिंदा शेई फेटी प्रार्थना शेशीर, मग वारणी आंपडिच काडीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","पवित्र आत्मातीकेल बर्णबा इंगा शौल इरनी आम्पीच कामला वच्या, वार सलुकीयालोंग फोईर, मग आंदकेल समुद्र दावाता कुप्र बेटमिंदीक फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","वार यपुड सलमी शहरला वचीर, आप्पुड वार द्यावार्दी वचन यहुदी मंदी सभास्थानला शेपीर मार्क आनीनोड योहान इड पण वार मदत इचांग उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","वार आंता बेट दाटीगास पफे शहरलोंग फोईर, पफे इंदू वारकी ओगा यहुदी मणशी भेटाश्या, वाड जादुय करामतलु शेईदू, वांदी फेर बर्येशु उंड्या, वाड खोटा संदेष्टा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","बर्येशु हमेशा सिर्ग्य पौल राज्यपाल उंड्या इंगा वाड हुशार उंड्या, वाड बर्णबा इंगा शौल इरनी मना तीकुड कुतेश्या, वाड वार तीकेल द्यावार्दी वचन इनेद उत्सुकता सुपिच्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पण अलीम “जादूगर” (वान फेरुद अर्थ इदे ग्रीक ला उंडाद) इड बर्णबा इंगा शौल इर विरुद्ध उंड्या, राज्यपाल विश्वास फेटाराद आंका अलीम वांदी मन तीपेद प्रयत्न शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","पण शौल, यवान पौल पण आंटार, वाड पवित्र आत्माता निंडीनोड उंड्या, पौल वान तीकुड उर्मी सुश्या इंगा आन्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“हे शैतान कोडकु नु दृष्टता इंगा खोटा पनता निंडीनोड उंडाव, आंता नीतिमानलाओर दुश्मना, नु प्रभुनि सरळ दावाल उलटा शेशेद इडवाव येम? ");
INSERT INTO wbq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","तर इपुड सूड, प्रभुंदी शेई नी मिंदा उंडाद, नु गुड्योड आयाव इंगा काही वेळ नंताक निक सूर्य कम्पीयाक फोई,” मग लगेच अलीम मिंदा धुके इंगा मोबू फड्या इंगा मनालनी यवारतरी शेई फटी नडपियाला आंका इकाडआकाड तीर्गुका मन्सुलाद फुडकुदेंग आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","आप्पुड येम आय्या आदी सुशी राज्यपाल विश्वास फेट्या, प्रभून शिक्षणता वाड चकीत आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौल इंगा यवार वान सोबतील उंडीर वार पफे तीकेल समुद्रदावाता यलीर, वार पंफुलीयालोन पिर्गा उरूक वचीर, पण योहान (मार्क)वारणी इडशी वापस यरुशलेम शहरकी फोया. ");
INSERT INTO wbq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पौल इंगा वान सोबतील बरनबा प्रवास मुंदारकी चालू फेटीर, पिर्गादेग्गार्केल मुन्दार्की वार पिसिदियालोन अंत्युखीयाक फोईर इंगा शब्बाथ दिवसनाड वार सभास्थानला फोईर इंगा आंदू कुसनीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","आप्पुड नियमशास्त्र इंगा संदेष्ट्याल लेखुद वाचास्काम आयनेंका सभास्तान अधिकारील पौल इंगा बर्णबा निरोप आम्पीर, “हे तमुलू, इंदूड मंदीक येमाना मदत आय्यी इल्ला काही बोधवचनलु शेपना.” ");
INSERT INTO wbq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","पौल नीला फड्या इंगा स्वताद शेई मिन्दिक शेशी आन्या, “हे इस्राएल मंदीलाला इंगा द्यावारकी येर्स्कुनेतोर यहूदी लेनोर ऐकायना. ");
INSERT INTO wbq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इ इस्राएल मंदी द्यावार मना आबातातागारदी निवड शेश्या इंगा वार या काळला मिसरला इंगोगोर आंका निलदूर, आ काळला द्यावार वारणी वाढायमत्या इंगा शेईल सापी वारणी आंदकेल बेटीक येकोच्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","इंगा द्यावार जंगललोन चाळीस वर्षला वारकी सहनशीलता सुपिच्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","द्यावार कनान प्रदेशलोन सात राष्ट्रलदी नाश शेश्या, द्यावार वारी जमीनलु वान मंदीक इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","इदी साधारणपणे चारशेपन्नास वर्षला घडाष्या, दान नंतर द्यावार शमुवेल संदेष्ट्यान नंताक स्वता मंदीक न्यायाधीश नेमाशी इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","मग मंदी राजाद मागणी शेशीर, द्यावार वारकी किश कोडकु शौल इन इच्या, शौल इड बन्यामीन वंशटोळ उंड्या, वाड चाळीस वर्ष नंत्ताक राजा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","मग द्यावार शौलनी तीशेश्या, द्यावार दावीदनी वार राजा शेश्या, दावीद विषयला द्यावार इल्ला माटलाळ्या इशायान कोडकु, दावीद नाक ना मन लेका शिकीनाड, वाड नाय आन्नी इच्छाल पूर्ण शेशी. ");
INSERT INTO wbq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","इ दावीद वंशकेले द्यावार इस्राएल मंदीक ताराशेतोड ऐकोन वच्या, वाड वंशज येशुड उंडाड, द्यावार इदी शेशेद अभिवचन इच्चीन्या.” ");
INSERT INTO wbq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","येशुड दाकाना पहिला आंता इस्राएल मंदीक योहान उपदेश शेश्या, वार अंतकरणला बदल कावाला आंकान योहान मंदीक शप्या की, वार बाप्तिस्मा तीस्कोना बेक. ");
INSERT INTO wbq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","यपुड योहान स्वताय फनील संपा मतुतून्या, आप्पुड वाड आन्या, “नीन यवार उंडान इल्ला मिक वाटास्ताद? नीन ख्रिस्त लेन, वाड यंक्सार वस्तूनाड, वान बुटलाद दाराम पण इडशेद नाद लायकी लेद.” ");
INSERT INTO wbq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ना तम्मुळलाला, अब्राहम परिवारलोन कोडकूलाला इंगा मीर यहुदी लेनोर पण खरेम द्यावार्दी उपासना शेशेतोर, एकायना! इ तारणदी बातमी माक शपकामला वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यरुशलेम शहरला निलस्चेतोर यहुदी इंगा वार अधिकारील इर वान ओळखायालेर, येशुड इड ताराशेतोड उंड्या, येशुन बद्दल याय शब्दल संदेष्ट्याल लीवाशीर आय्यी यहुदी मंदी इचांग प्रत्येक शब्बाथ दिन्मूनाड वाचास्काम्ला वच्या, पण वारकी आदी समजायाल्या, यहुदी मंदी येशुन दोषी ठहरा मतीनेन्का वार आ भविष्यवाद्यली शब्दल खरेम ठरामतीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","येशुड यंटिक सैयाला दिंदी खरेम कारण वार फुडकी शकायालेर, पण वार पिलातकी विनती शेशिर वान जेमता मतेयाला. ");
INSERT INTO wbq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","शास्त्रला येशुन बद्दल इ माटलू लीवाशिनेय उंड्या की, याय वाईट आय वान बद्दल घडाशेय उंड्या, आय आंता इ यहुदी मंदी येशुन शेशीर, मग वार येशुन क्रूस मिंदकेल किंदीक तीस्कोनीर इंगा वान कब्रला फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पण द्यावार वान सचीनलोन्केल लेप्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","दिन नंतर, संगेम नाळ नंताक येवार वान सोबत उंडीर, वारकी गालील प्रांतकेल यरुशलेम शहर नंताक येशुड दर्शन इच्या, वार मंदी इपुड वान साक्षीदार आंका मंदी मुंदार उंडार. ");
INSERT INTO wbq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","मिम मिक द्यावार याद अभिवचन मा आबातातागारकी इच्या आ विषयला सुवार्ता शप्ताम. ");
INSERT INTO wbq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","मिम वार बीळलु (संतान) उंडाम इंगा द्यावार इदी अभिवचन मा बाबतीला खरेम शेशी सुपिच्या, द्यावार इदी येशुन सचीनलोन्केल डबल लेपीन दीनता शेश्या, मिम इ विषयला स्तोत्रसंहिताला पण वाचास्ताम: “नु ना कोडकु उंडाव, इफोद नीन निक जन्म इचीनान.” ");
INSERT INTO wbq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","शिवाय वाड सडाशी परिस्थिती नंताक फोवा राद दांचांग वाड वान सचीनलोन्केल लेप्या, इ विषयला वाड इल्ला शपिनाड की, 'दावीदकी इच्काम्ला वचीनेद पवित्र इंगा पक्का आशीर्वाद मिक इच्यान.' ");
INSERT INTO wbq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","दांचांग इंगा वगा स्तोत्रला वाड आंताळ: “नु नि पवित्र मनशीक कब्रला सडाशेद अनुभव दानियाक फोयाव.” ");
INSERT INTO wbq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“कारण दावीद वान पिढीद द्यावार इच्छालेका सेवा शेशी सची फोया, मना आबातातागार शेजारी वान बुडशीर इंगा कब्रला वांदी शरीर शडी फो. ");
INSERT INTO wbq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पण यवान द्यावार सचीनलोन्केल डबल लेप्या, वानकी सडाशेद अनुभव दाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","आण्णागारलाला, मिम याद घोषणा शेस्तुनाम आदी मीर समजाशी तीस्कोना बेक: इ वगान तीकेले मी पापलाद क्षमा मिक शिक्की शेकास्ताद. ");
INSERT INTO wbq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","मोशेंदी नियमशास्त्र मिक मी पापकेल मुक्त शेयाद, पण प्रत्येक मणशी यवार वान मिंदा विश्वास फेटतार, आदी वान तीकेल आ आंदार विषयला न्यायी ठरामत कामला वस्ताद. ");
INSERT INTO wbq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","संदेष्ट्याल शपिनेय काही माटलु घडाशी, सावध निलना! इ माटलू मी बद्दल कावाराद आंका जपाशी उंडा. ");
INSERT INTO wbq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","अरे धिक्कार शेशेतोरलाला, सूडना, आश्चर्य शेयना इंगा गायब कांडा, येनटीक की मी काळला नीन ओकाट फनी शेस्तान, यवानमिंदा मिद विश्वास कुसनाक फोई येवाराना आदी स्पष्ट शेशी शपते तरी मीर वान मिंदा विश्वास फेट्टाक फोयार.” ");
INSERT INTO wbq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","यपुड पौल इंगा बर्णबा फोयेदेंक आंटीर, आप्पुड मंदी आनीर की, मुंदार शब्बाथ दिवसनाड वापस दांडा इंगा माक इ विषयला इंगा शपना. ");
INSERT INTO wbq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","सभास्थानलोन बैठक संपाशीनेन्का संगेम यहुदी मंदी इंगा यहुदी मणसाला गता नडशेतोर इंगोगो धार्मिक मंदी पौल इंगा बर्णबा इर यंका फोईर, पौल इंगा बर्णबा इर आ मंदीन द्यावार कृपाला टीकाशी निलदेंक कळकळीता विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","मुंदार शब्बाथनाड शहरलोन देगार-देगार आंदार मंदी परमेश्वरदी वचन ऐकादेंक ओकाताळा जमा आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","यहुदी मंदी आ आंदारनि आंदू सुशीर, दांचांग यहुदी मंदीक कोफाम वाटादू, वार पण काही संगेम खराब माटलु माटलाडीर इंगा येम पौल माटलाड्या दान उलटा जगडाम उपस्थित शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","पण पौल इंगा बर्णबा संगेम धेर्यता माटलाडीर, वार आनीर, “द्यावार्दी वचन मी यहुदीओर्की पहिला माक शपाने बेक, पण मीर ईनदेंक नकार इस्तुणार, मीर मिद स्वतादे नुकसान शेस्कोनटूनार इंगा अनंतकाळदी जीवन तीस्कोन्देंक अपात्र ठरास्तुणार! दांचांग मिम इपुड दुसरा देशलोन इंगोगो राष्ट्रलोन मंदीतीकुड फोयाम.” ");
INSERT INTO wbq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","प्रभूड माक आज्ञा इच्चीनाड की, “इंगोगो राष्ट्रवाल्योर इचांग नीन मिम्लान यल्गु इल्ला शेस्तीन दिनकस्रोम की, मीर पृथ्वी मिन्दुड आंदार मंदीक तारणदी दावा सुपिची शकाश्यार.” ");
INSERT INTO wbq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","“यपुड यहुदी लेनेर पौलनि इल्ला माटलाडेतापुड इनीर आप्पुड वार संगेम खुश आय्यीर, परमेश्वर वचनकी वार गौरव इच्चीर इंगा आ मंदी पैकी संगेम जन वचन मिंदा विश्वास फेटीर, येनटीक की वार अनंत काळ जीवन इचांग निवडाशिनोर उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","इंगा परमेश्वरदी संदेश पूर्ण देशला शपीर.” ");
INSERT INTO wbq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","आप्पुड यहुदी मंदी शहरलोन काही धार्मिक आंडेर इंगा पुढारी इरनी भडका मतेशीर, आ मंदी पौल इंगा बर्णबा इर उलटा संगेम खराब माटलु शेशीर इंगा वारणी शहर बेटीक तीशेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","मग पौल इंगा बर्णबा इर स्वता काळलाद धूळ झटकाशीर इंगा वार इकुन्या शहरलोंग फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","इकाड येशुन शिष्यल खुशीता इंगा पवित्र आत्माता पूर्ण आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","पौल इंगा बर्णबा इकुन्या शहरलोंग फोईर, वार आंदूड यहुदी सभास्थानलोंग फोईर, आंदूड मंदी संगा वार माटलाडीर, पौल इंगा बर्णबा इप्रकार्ता माटलाडीर की, संगेम यहुदी मंदी इंगा यहूदी लेनोर मंदी वार येम शपीर दान मिंदा विश्वास फेट्टीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पण काही यहुदी मंदी विश्वास फेटालेर, वार यहूदी लेनोर मंदीय मनलु भडकामतीर इंगा बंधूजनला विषयला मनलु खराब शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","दांचांग पौल इंगा बर्णबाड आ जागाला संगेम दिवस मुक्काम शेशीर इंगा परमेश्वर ताकतता येशुन बद्दल धेर्यता शपका निलचीर, पौल इंगा बर्नबाड द्यावार कृपा विषयला साक्ष इच्या, परमेश्वर वारकी पौल इंगा बर्नबानकी चमत्कार इंगा अद्भुत फनील शेशेदेंक मदत शेशी वार येम पण शपदूर आदी खरेम ठरा मत्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पण शहरलोन काही मंदीक यहुदी मंदिय माटलु पटाश्या, दुसरा मंदीक प्रेषित पौल इंगा बर्नबानदी आनकाम पटाश्या, दांचांग शहरला रोंड भागलु फड्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","काही इंगोगो राष्ट्रटोर मंदी, काही यहुदी मंदी इंगा वार पुढारी इर पौल इंगा बर्नबान कटीर इंगा वारनी मतेद प्रयत्न शेशीर, वारकी पौल इंगा बर्नबा इरनी गुंडलाता मती मतेशेद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","पौल इंगा बर्नबा इरकी यपुड दान बद्दल यरका आय्या आप्पुड वार आदी शहर इडशीर, वार लुस्र इंगा दब्रे इ लुकवनिया देश नगरला फोयीर इंगा आ शहर आजुबाजूक परिसरलोंग फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","इंगा आंदू वार सुवार्ता शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्र इंदू वगा मनशी उंड्या वानी काळलु लंगडा उंड्या वाड फुटीनकेले लंगड्याड फुटीन्ड्या इंगा यपुडूच नडवा लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","पौल भाषण शेशेतापुड इ मणशी ऐकायदु, पौल वान तीकुड कंडलु आन्ची इंगा वानदी नीन शिंगार आय्यान इल्ला आ मणशीद विश्वास उंडाद इल्ला सुशी. ");
INSERT INTO wbq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","बेगाता आन्या, “नि काल मिंदा शिंगार नीला फड!” आप्पुड आ मणशी उडी मत्या इंगा नडदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","पौल शेशिनेद मंदी यपुड सुशीर, आप्पुड वार स्वता लुकवनिया भाषाला किर्लीर, वार आनीर “द्यावार मणशी रुपला मा नडमा दिगीनाड.” ");
INSERT INTO wbq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","मंदी बर्णबान ज्युपिटर आनीर इंगा पौलनी मर्क्युरी आनीर, येनटीक की पौल मेन माटलाडेतोड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ज्युपिटरदी मंदिर देगार उंड्या, आ मंदिरोड पुजारी काही यद्दुल इंगा फुवूल तीस्कोनी वेशी देगार वच्या, पुजारी इंगा मंदी पौल इंगा बर्णबा इर्दी उपासना शेशेदेंक वार मुंदार बळी इचेद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पण वार येम शेस्तुणार, इदी यपुड प्रेषित पौल इंगा बर्णबा इरकी समजाश्या आप्पुड वार स्वताय बटाल शिम्पीर इंगा मंदी गर्दीला घुसाशीर इंगा बेग्गे आनीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","हे मंदीलाला, इ माटलु मीर येनटीक शेस्तुणार? मिम द्यावारलु लेम! मिक यला भावनाल उंडाय, आले माक पण उंडाय! मिम मिक सुवार्ता शपिदेंक वचीनाम, मिम मिक शपतुनाम की इ व्यर्थ माटलाकेल मीर मिद मन तीपाला, खरेम जिवंत द्यावार तीकुड स्वताद मन आंचाला, वाडे मोडाम, पृथ्वी, समुद्र इंगा येम पण उंडाद आदी निर्माण शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","भूतकाळला, द्यावार आन्नी राष्ट्रलान वारकी यला बेक आले वागायनीच्या. ");
INSERT INTO wbq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","पण द्यावार इल्ला माटलु शेश्या, की दान मिंदेल वाड खरेम उंडाळ इदी सिद्ध कावाला, वाड मी इचांग शिंगार माटलु शेस्ताड, वाड मिक मोडाम लोंकेल वाना इस्ताड, योग्य वेळला वाड मिक शिंगार पिक इस्ताड, वाड मिक संगेम आन्नाम इस्ताड इंगा वाड मिय अंतकरणलु आनंदता निम्पताड. ");
INSERT INTO wbq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","पौल इंगा बर्णबाड इ माटलु मंदीक शपीर इंगा संगेम प्रयत्नता वार्की यज्ञ अर्पण शेशेदेन नुस वारणी प्रवृत्त शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","नंतर अंत्यूखिया इंगा इकुन्या इंदुड काही यहुदी मंदी आंदूक वचीर, वार मंदी समुदायलाय मनलू स्वता बाजूक तीप्पीर इंगा पौलकी गुंडलु मतिर, दांटल्या पौल सची फोया इल्ला समजाशी वार वान जगुका फोई नगर बैट्या येशीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पण शिष्यल पौलभोवती जमा आयनेंका पौल लेशी वापस शहरलोंग फोया इंगा दुसरानाड बर्णबा संगा वाड दर्बे शहरलोंग फोया. ");
INSERT INTO wbq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","इंगा आ नगरला वार सुवार्ता शपी संगेम मंदीन शिष्य शेशीर, दान नंतर वार लुस्र, इकुन्या इंगा अंत्युखीया नगरलाक वापस वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","इंगा वार आंदूळ शिष्यलनि येशुन मिंदूड विश्वासला मजबूत शेशीर, वार स्वता विश्वासला मजबूत उंडाला दांचांग उत्तेजन इच्चीर, वार आनीर, “संगेम दुखलाक मुती इचका मनाम द्यावार राज्यला प्रवेश शैया बेक.” ");
INSERT INTO wbq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","पौल इंगा बर्णबाड प्रत्येक मंडळीला आबागारदी नेमणूक शेश्या, वार इ आब्बागार इचांग उपवास इंगा प्रार्थना शेशीर, प्रभू येशुन मिंदा विश्वास उंडीनोर इल्ला आंदार आब्बागार उंडीर दांचांग पौल इंगा बर्णबाड वारणी प्रभून शेईला सोपाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","पौल इंगा बर्णबा पिसिदिया प्रदेश लोंकेल फोईर नंतर वार पंफुलीया इंदू वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","वार पिर्गा शहरला द्यावार संदेश इच्चीर नंतर वार अत्तलीया शहरलोंग फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","नंतर आंदकेल मुंदारकी पौल इंगा बर्णबा सिरीया प्रांत लोंटोर अंत्युखीयाक समुद्र दावाता फोईर, याद फनी वार पूर्ण शेशिनीर दांदी सुरवात वार द्यावार कृपाता अंत्युखीया केले शेशिनीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","वार यपुड आंदूक पोहोचाशीर, आप्पुड वार मंडळीला ओगातळा कुतेशीर इंगा द्यावार वार बाबतीला याय-याय माटलु शेश्या आय्यी वारकी शपीर आले दुसरा देशलोन इंगोगो राष्ट्र टोर मंदीला द्यावार विश्वासलाय दरवाजाल यला उघडाश्या आदी शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","मग वार विश्वास फेटेतोर सोबत आंदू संगेम नाळ निलचीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","आप्पुड काही यहूदी विश्वास फेटेटोर मंदी यहुदियाकेल दिगी बंधूजनलाक इल्ला शिकवण इच्चीर की, मोशेड आंची इचीने नियमला लेका मिद सुंता आईने शिवाय मिद तारण आय्येद शक्य लेद. ");
INSERT INTO wbq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","आप्पुड पौल इंगा बर्णबा इरदी वार संगा संगेमे मतभेद इंगा वाद विवाद आयनेंका इल्ला ठरामतीदेंक वच्या की, पौल इंगा बर्णबा इर इंगा वार पैकी इंगोगो मंदी इ वादविषयला यरुशलेम शहरलोन प्रेषित इंगा आब्बागार इर तीकुड फोवाला. ");
INSERT INTO wbq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","मग मंडळी वारणी आंपीची नेन्का वार फेनिके इंगा शोमरोन इ शहरलोन्केल फोईर इंगा इंगोगाराष्ट् तीकुड तीर्गीनेद सविस्तर वर्तमान शपी वार आंता बंधूजनलाक संगेम खुश शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","नंतर वार यरुशलेम शहरकी वची नेन्का आंदूड मंडळी, प्रेषित इंगा आब्बागार इर वारदी आगतस्वागत शेशीर, आप्पुड मनाम द्यावार सहवासला उंडीनेन्का वाड जे-जे शेश्या आदी वार शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","तरी पण परुशी पंथ लोंटोर यंतातरी विश्वास फेटेतोर इल्ला आनीर, वारदी सुंता कावाने बेक इंगा मोशेंदी नियमशास्त्र पाळाशेळद वारकी आज्ञा शैयाने बेक. ");
INSERT INTO wbq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","मग प्रेषित इंगा आबागारदी वर्ग इ प्रकरणदी विचार शेशेदेंक जमा आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","आप्पुड संगेम वादविवाद आयनेंका पेत्र नीला फडी वारणी आन्या हे बंधूजनलु, मिक यरका उंडाद की, ना नोरकेल सुवार्ता ऐकाशी इंगोगो राष्ट्रटोर विश्वास फेटाला दांचांग सुरवाती दिवसाकेल मी नडमा द्यावार नाद निवड शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","इंगा हृदयलु जानाशेतोड द्यावार यला मनाक आले वारकी पण पवित्र आत्मा इच्ची वार विषयला साक्ष इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","दान्ता वारी अंतकरनलु विश्वासता शुद्ध शेशी वार नडमा इंगा मना नडमा येमीच अंतर फेटा लेद. ");
INSERT INTO wbq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","इल्ला उंडीनापुड याद जोखड मना पूर्वजलु इंगा मनाम येतेदेंग समर्थ लेकूनटीम आदी शिष्यल मेडाल मिंदा येशी मीर द्यावार्दी परीक्षा येनटीक सुस्तार? ");
INSERT INTO wbq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","तर मग वार लेकाने मनाद तारण प्रभू येशुन कृपाता आय्यी इल्ला मनाद विश्वास उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","आप्पुड आंदार मंदी तेपांग निलचीर इंगा बर्णबा इंगा पौल इर द्वारे द्यावार इंगोगो राष्ट्रटोरला याय चिन्हल इंगा अद्भुतलु शेश्या वारी शेशिनेय वर्णनलु वार ऐकाशी तीस्कोनीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","मग वारदी भाषण संपाशी नेन्का याकोब आन्या; आण्णागारलाला, नाद एकायंडा. ");
INSERT INTO wbq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","15","इंगोगाराष्ट्र लोंटोर मना फेर इचांग काही मंदी तिशी तीस्कोणाला आंका द्यावार वारदी भेट यला तीस्कोन्या, इदी शिमोन शापिनाड; इंगा दिन संगा संदेष्ट्याल युक्तीद पण मेळ कुसुंटाद, इल्ला शास्रलेख उंडाद की, ");
INSERT INTO wbq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","दिन नंतर नीन वच्यान इंगा दावीद दी फडीनेद मंडप डबल नीलाफडामत्यान; इंगा खंडर बुडशी दान परत शिंगार शेश्यान, ");
INSERT INTO wbq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","दिनकस्रोम की, बाकी नीलचिने मन्सूल इंगा या राष्ट्रलाक नाद फेर इचीनेद उंडाद वार आंदार प्रभूनदी शोध शेयाला. ");
INSERT INTO wbq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","इदी जे वान्की युगकाना पहीलाकेल यरका उंडाद आदी शेशेतोड प्रभूड इल्ला आंटाड. ");
INSERT INTO wbq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","आप्पुड नाद तर मत इल्ला उंडाद की, यवार इंगोगो राष्ट्रकेल द्यावार तीकुड तीरगुतार वारकी त्रास इया राद; ");
INSERT INTO wbq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","तर वारकी इल्ला लीवाशी आम्पीयाला की, मूर्तीद अमंगळपण, जारकर्म, गोंतू फिस्की मतीनेय प्राणील इंगा नेत्तुर दिनकेल मीर दुराम निलना. ");
INSERT INTO wbq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","येनटीक की प्राचीन काळकेल प्रत्येक शब्बाथ नाळ सभास्थानला मोशेंदी पुस्तक वाचाशी सुपीची वांदी घोषणा शेशेतोर मंदी प्रत्येक नगरला उंडार. ");
INSERT INTO wbq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","आप्पुड पौल इंगा बर्णबा इरसंगा मना लोन्केल निवडाशिनोर मन्सूल आंटे बंधूजनलोन्टोड प्रमुख बर्शब्बा आनिनोड यहुदा इंगा सिला इरनी अंत्युखीयाक आंपडीच्या तर शिंगार आय्यी इल्ला आंता मंडळी जताक प्रेषित इंगा आब्बागार इरकी वाटाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","इर शेईता वार इल्ला लीवाशी आंपीर: “अंत्युखीया, सिरीया इंगा किलीकीया इंदूटोर इंगोगो राष्ट्रलोंटोर तम्मुळलु इरकी प्रेषित इंगा आबागारदी वर्ग ई तम्मूळलाद सलाम. ");
INSERT INTO wbq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","मा पैकी काही मंदीक फोई वार माटलाता मिद जेम घोटाळाला केडपी त्रास इच्या इल्ला मा गुम्मामिंदा वचीनाद: पण वारकी मिम आला शेशेदेंक शपा लेकुन्टीम. ");
INSERT INTO wbq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","दांचांग माद ओकामत आय्यी नेन्का माक इदी बरोबर वाटाश्या की, ");
INSERT INTO wbq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","मना प्रभू येशु ख्रिस्तन फेर इचांग जेम धोकाला येशीने मना प्रिय बंधूल बर्णबा इंगा पौल इर संगा काही निवडाशिनेर मन्सूल मी तीकुड आंपाला. ");
INSERT INTO wbq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","दिनकस्रोम यहूदा इंगा सिला इरनी मिम आंपीनाम वार स्वता इ माटलु मिक नोरता शप्यार. ");
INSERT INTO wbq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","येनटीक की मुंदार इचीनेय इ आवश्यक माटला शिवाय मी मिंदा जास्त वजन येया राद इल्ला पवित्र आत्माक इंगा माक योग्य वाटाश्या: ");
INSERT INTO wbq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","आय आंटे मूर्तीलाक अर्पण शेशिनेय पदार्थल, नेत्तुर, गोंतू फिस्की मतीनेय प्रानील इंगा जारकर्मल इ मीर इड्स्काडाला; इटलाता स्वतान वाचायमत्यार तर मिद शिंगार आय्यी, मुन्दार प्रवास इचांग शुभेच्छा.” ");
INSERT INTO wbq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","वारणी आंपीची नेन्का वार अंत्युखीयाक फोईर इंगा वार आंदार मंडळीन जमा शेशी आदी पत्र सादर शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","दांटल्योंदी बोध वाचाशी वारकी आनंद आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहुदा इंगा सिला इर स्वता संदेष्ट्याल उंडीर, दांचांग वार संगेम माटलाळी तम्मुळलाक बोध शेशीर इंगा स्थिर आय्यीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","आंदू वार काही नाळ नीलचीनेन्का यवार वारणी आंपीनीर वार तीकुड फोयेदेंक तम्मुळलू वारणी शांतीता आंपडीच काडीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","पण सिलान्की आंदू इंगा निलदेंक शिंगार वाटाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","इंगा पौल अन बर्णबा इतर संगेम मंदी सोबत प्रभूनदी वचन शिकामतका इंगा सुवार्ताद घोषणा शेस्का अंत्युखीयाक निलचीर. ");
INSERT INTO wbq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","मग काही दिवस नंतर पोल बर्णबान आन्या “या-या नगरला मनाम प्रभून वचनलाद घोषणा शेशीर आंदू डबल फोईगास बंधू जनलान भेटाशी वार यला उंडार इदी सूदाम.” ");
INSERT INTO wbq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","बर्णबानदी इच्छा उंड्या की, यवान मार्क आंटार आ योहाननी बरोबर तीस्कोनाला. ");
INSERT INTO wbq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पण पौल की वाटाश्या की, पंफुलीया नुस यवाड मनालनी इडशी फोइन्या इंगा मना संगा फनी शेशेदेंक दाल्या वान सोबतिक तीस्कूनेद बरोबर लेद. ");
INSERT INTO wbq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","दिन मिन्द्केल शेंगेम मतभेद निर्माण आय्यी वार वगारमेगार नुस अलग आय्यीर इंगा बर्णबा मार्कनी तीस्कोनी जहाजला कुसनी कुप्रास की फोया; ");
INSERT INTO wbq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पौल सिलान निवडाशी तीस्कोन्या इंगा बंधू जनलु वान प्रभून कृपा मिंदा सोपाशी नेन्का वाड आंदकेल यल्या. ");
INSERT INTO wbq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","इंगा मंडळीक धेर्य इचका सिरीया इंगा किलीकीया दिन्टल्योन्केल फोया. ");
INSERT INTO wbq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","मग पौल दर्बे इंगा लुस्र इंदू किंदीक वच्या; इंगा सूडना, आंदू तीमथ्य फेरोड येवाडो ओगाड शिष्य उंड्या; वाड विश्वास फेटेदान यादो ओगा यहुदी आंडीदान कोडकु उंड्या, वान आबाड हेल्लेनी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","वांदी लुस्रलोन इंगा इकुन्या लोनटोर विश्वास फेटेटोर तम्मूळ बागा स्वागत शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","तिमती मना संगा दावाला इल्ला पौलदी इच्छा उंड्या; आप्पुड आ जागाला यवार यहुदील उंडीर वार इचांग वाड वान तीस्कोनी वादी सुंता शेश्या; येनटीक की वान आबाड ग्रीक उंडाड इदी आंदारकी यरका उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","आप्पुड वार नगरकेल फोता-फोता यरुशलेम शहरलोन प्रेषित इंगा आब्बागार इर याद ठराव शेशिनीर वारकी पाळायदेंक नेमाशी इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","दिन मिंदकेल मंडळील विश्वासला स्थिर आय्या इंगा दिवसान दिवस वाढास्का नडश्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","यंक्सार आशिया प्रांतला वचन शपिदेंक वारकी पवित्र आत्मा तीकेल प्रतिबंध आईने इचांग वार फुग्रीया इंगा गलतिया इ प्रांत लोन्केल फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","इंगा मुसिया प्रांत नंताक वचीनेन्का बिथुनिया प्रांतला फोयेद वार प्रयत्न शेशीर; पण येशुन आत्मा वारनि फोनीयाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","मग वार मुसिया देगारकेल फोई त्रोवस शहरकी किंदीक फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","आंदू मोबुला पौलकी इल्ला दृष्टांत आय्या की, मासेदोनियाला यवार तरी वगा मणशी नीला फडी मनालनी विनंती शेस्तुनाळ की, “इकाड मासेदोनीयाला वची माक मदत शेय.” ");
INSERT INTO wbq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","वांकी इल्ला दृष्टांत आयनेंका आ मंदीक सुवार्ता शपदेंक द्यावार मंमलान कुतेशिनाड इल्ला अनुमान शेशी मिम मासेदोनीयाला फोयेदेंक लगेच विचार शेस्तीम. ");
INSERT INTO wbq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","आप्पुड त्रोवसाकेल जहाज ला कुसनी मिम शिंगार समथ्राकेस बेटकी फोतीम इंगा दुसरा नाळ नियापुलीस शहरकी फोतीम. ");
INSERT INTO wbq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","आंदकेल फिलीप्पी शहरकी फोतीम; आदी मासेदोनियालोन इ भागलोंदी पहिलादे नगर उंडी आंदू रोमन मंदीद वसाहत उंडाद आ नगरला मिम तोडेम नाळ नीलस्तिम. ");
INSERT INTO wbq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","मग शब्बाथ नाड मिम वेशी बेटीक वंका कंटामकी, यंदू प्रार्थना आतूनटाद इल्ला माक वाटाश्या आंदू फोई कुसुंटीम; इंगा या आंडेर आंदू जमा आयनीर वार संगा माटलाड देंक आंटतीम. ");
INSERT INTO wbq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","आंदू लुदिया फेरूद यादो ओगा आंडीद उंड्या; आदी थुवतीरा नगरदी उंडी जांभळाय बटाल आंमदु; आदी द्यावार्दी उपासना शेशेद उंड्या, आदी माद भाषण ऐकाश्या; दांदी अंतकरण प्रभूड इल्ला तयार शेशाकी पौल शप्काम तीकुड आदी लक्ष्य इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","मग दांदी इंगा दान घरानाद बाप्तिस्मा आयनेंका आदी इल्ला विनंती शेश्या की, “नीन प्रभून मिंदा विश्वास फेटेदान उंडान इल्ला जर मीर मानास्तुनार तर ना ईलकाडा वची निलूना.” दान आग्रह इचांग आदी विनंती माक मान्य शेय्या बेक आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","मग इल्ला आय्या की, मिम प्रार्थना जागा तीकुड फोयेताप्पुड येवात तरी ओगा दृष्ट आत्मा आंटीनेद आन्बीडा माक कमशा, दान फईला वच्चू, आदी भविष शपी दान धन्यालकी संगेम दुडलु कमाशी इच्चू. ");
INSERT INTO wbq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","आदी पौल इंगा मा यंका वची बेग्गे आन्या, “इ मंदी परात्पर द्यावार दास उंडार, इर मनाक तारणदी दावा शेप्तार.” ");
INSERT INTO wbq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","इल्ला आदी संगेम नाळ शेयदू; मग पौलकी संगेम खराब वाटाश्या इंगा यंकाक तीरगी वाड आ दृष्ट आत्मान आन्या, “येशु ख्रीस्तन फेरता नीन नीक आज्ञा शेस्तान की, नु दिन लोन्केल येली फो.” इंगा आदी लगेच येली फोया. ");
INSERT INTO wbq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","मग मनाद कमाशेद आशा फोया इल्ला सुशी दान धन्याल पौल इंगा सिला इरनि फटी बाजार अधिकारीला तीकुड जगुका फोइर. ");
INSERT INTO wbq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","इंगा वार वारणी अधिकारीला मुंदार नीला फडा मती आनीर, “इ मंदी यहुदी उंडी मा नगरकी त्रास इस्तार. ");
INSERT INTO wbq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","इंगा मा रोमन मंदीक याद रिती रिवाज स्वीकार शेशेदेंक इंगा आचरायदेंक योग्य लेद वार इदी शप्तार.” ");
INSERT INTO wbq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","आप्पुड मंदी वार मिंदा लेशीर इंगा अधिकारील वारी बटाल शिंपी इंगा वारनि छडील मतेद आज्ञा इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","मग संगेम फटकाल मतीनेन्का वारणी बंदी शाळाला येशी वार बंदी शाळा नायककी वारणी बंदोबस्तला फेटेद हुकुम इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","वांकी इल्ला हुकुम शिकीनेन्का वाड वारणी बंदी खानाला येशी वारी काळलु खोडाला अडका मत्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","आर्दाम मबुला पौल इंगा सिला इड प्रार्थना शेस्तापुड इंगा फदुल फाडी द्यावार्दी स्तुती शेस्तापूड उंगो बंदीवान वारदी ऐकादूर. ");
INSERT INTO wbq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","आप्पुड येकायेक इल्ला फेदाद भूकंप आय्या की बंदीशाळाय काळलु डगमगाश्या, आन्नी दरवाज्याल लगेच उघडाश्या इंगा आंदारि बंधनलु तेगी फोया. ");
INSERT INTO wbq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","आप्पुड बंदीशाळा नायक लेशिगास बंदीशाळाय दरवाजाल उघडा उंडाय सुशा; इंगा बंदिटोर फारी फोईर इल्ला विचार शेशी वाड तलवार उपसाशी स्वताद घात शेशेतोड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","इंताळला पौल बेग्गे कीरली आन्या नु स्वताक येमी नुकसान शेस्कोनाक; येनटीक की मिम आंदार इंदे उंडाम. ");
INSERT INTO wbq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","मग दिवा येकोची वाड नोनिक फारका फोया, नडगुका-नडगुका पौल इंगा सिला इरी काळलु मोक्या. ");
INSERT INTO wbq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","इंगा वारणी बेटीक तिशी आन्या “साहेब, नाद तारण कावाला दांचांग नीन येम शैया बेक?” ");
INSERT INTO wbq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","वार आनीर, “प्रभू येशुन मिंदा विश्वास फेट आंटे नीद इंगा नि घराणाद तारण आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","वार वान इंगा वान इंटलोन आंदारकी प्रभुंदी वचन शपीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","इंगा आ मबुलोन आद्दे टाईम वाड वारणी देगार तीस्कोनी वारी जखमलु कडग्या; इंगा आपुडे वाड इंगा वान इलुटोर आंदार मनुष्यल बाप्तिस्मा तीस्कीनीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","इंगा वाड वान इल्लुक एका फोई तिना मत्या इंगा द्यावार मिंदा विश्वास फेटी वाड इंगा वान इलूटोर मंडळी आनंद शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","फदु फुटी नेन्का अधिकारील शिपायीलान आंपडीची शपीर की, “आ मन्सूलान इडस्काड.” ");
INSERT INTO wbq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","आप्पुड बंदीशाळालोन नायक पौलकी इल्ला बातमी शपीर की, “मिमलान इडवाला आन्कान अधिकारी मन्सूल आंपिनाड; तर इपुड शांतीता फो.” ");
INSERT INTO wbq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पण पौल वारणी आन्या, “मिम रोमन मन्सूल उंडीगास अपराधी ठरायान्दे वार मंमलान उघडपणे देबाल मती बंदीशाळाला येशीर इंगा इपुड वार मंमलान तेपांग आम्प्तार येम? इदी नडवाद; तर वार स्वता वची मंमलान बेटीक तीयाला.” ");
INSERT INTO wbq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","इंगा शिपाईल इदी बातमी आधिकारिक शपीर, आप्पुड वार रोमन उंडार इदी ऐकाशी वार आद्री फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","इंगा वार वच्ची वारकी समजा मतीर; इंगा वारणी बेटीक येकोची नगर लोन्केल येली फोयेद विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","मग वार बंदी शाळाकेल येलीगास लुदियान इल्लुक फोईर, बंधूजनलान भेटाशी वार वारकी धीर इच्चीर इंगा आंद नुस वार फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","नंतर वार अंफीपुली इंगा अपुल्लोनिया इ शहर नोनिकेल फोई थेस्सलनीका शहरकी फोईर, आंदू यहुदीलदी सभास्थान उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","आंदू पौल स्वता रिती रिवाज लेका वान तीकुड फोई मूड शब्बाथ वार संगा शास्त्रलेख मिंदकेल वादविवाद शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","वाड शास्त्र लेखदी उलागडा शेशी इल्ला प्रतीपादन शेश्या की, ख्रिस्तड दुख येताला इंगा सचीने नुस इंगा लेपाला दिंदी आवश्यक उंड्या इंगा या येशुनदी नीन मी मुंदार घोषणा शेस्का वाडे वाळ ख्रिस्त उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","आप्पुड वार पैकी काही जनदी खात्री आयी पौल सिला इरनी वची मिळाशीर; इंगा ग्रीक उपासक इर्दी फेदाद समुदाय वारकी शिक्या, दांटला प्रमुख आंडेर काही रवा रवाने लेकुंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पण याहुदील शिगक मना बरोबर संता लोन्टोर रवा गुंडाळ मंदी ऐकोन इंगा घोळका जमा शेशी नगरला अधीर निर्माण शेश्या इंगा यासोन इल्लु मिंदा हल्ला शेशी वारणी मंदी तीकुड बेटीक तिशी ऐकोन वचेळदी खटपट शेशी सुश्या. ");
INSERT INTO wbq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","पण वारदी शोध आंटाल्या आप्पुड वार यासोन नि इंगा रवा मंदीन नगर लोन अधिकारीला तीकुड जगुका फोई किर्लुका आनीर, यवार जगदी उलटा पालटा शेशीर वार इंदू पण वचीणार. ");
INSERT INTO wbq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","वान यासोन स्वता इलकाडा तीस्कोनडार इंगा इदी आंदार कैसर आज्ञा उलटा वागास्तार, आटे येशु आंका दुसरोळे यवार राजा उंडाळ इल्ला आंटार. ");
INSERT INTO wbq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","इदी ऐकाशी वार मंदीक इंगा शहर अधिकारीक खवळाशी इडशीर ");
INSERT INTO wbq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","मग वार यासोनदी इंगा इंगोगोरदी जामीन तीस्कोनी वारणी ईळशेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","नंतर बंधूजनलू पौल इंगा सिला इरनी लगेच मोबुलोन मबुला बिरुया शहर की आंपडीचीर, वार आंदू पोहोचाशी नेन्का यहुदाल सभास्थानला फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","आंदूटोर मंदी थेस्सलनीटोर मंदी पेक्षा फेदा मनटोर उंडीर; वार फेदा उत्सुकताता स्वीकार शेशीर इंगा इ माटलु इले उंडाय की येम दिन विषयला वार शास्त्रलेखला दीनांम फुळकुका फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","दान लोन्टोर इंगा संगेमे प्रतीष्टीट ग्रीक आंडेर इंगा मनसलू इर विश्वास फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","तरी पण पौल द्यावार्दी वचन बिरुयाला पण शप तुणार इदी थेस्सलनिकालोन यहुदील की समजाश्या आप्पुड वार आकाड पण फोई मंदीन खवलाशी चिता मतीर. ");
INSERT INTO wbq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","दान मिंदकेल बंधूजनलू पौलनी समुद्र तीकुड फोयेदेंक लगाने आंपडीचीर; इंगा सिला इंगा तीमथ्य इर आंदे निलचीर. ");
INSERT INTO wbq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","आप्पुड पौलनि पोहोचा मतेटोर वान अथेनै पर्यंत एका फोईर इंगा सिला इंगा तीमथ्य इर स्वता तीकुड आय्यी आंता लगान दाला इल्ला इर्दी आज्ञा तीस्कोनी वार यलीर. ");
INSERT INTO wbq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पौल अथेनैस वारदी दावा सुस्तांना, वार शहर मूर्तील निंडीनेय उंडाय इल्ला सुशी वान मनुद संताप आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","दिनकस्रोम वाड सभास्तानला यहुदील संगा इंगा उपासक मंदी संगा इंगा संताला यवार वांकी आढळादूर वार संगा दिन्नाम जगडाम आळदू. ");
INSERT INTO wbq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","आप्पुड एपिकुरपंथी इंगा स्तोयिकपंथी इर संगा यंता तरी तत्वज्ञानलु वानदी विरोध शेशीर, यंता तरी जन आनीर, “इड बडबडेळ येम माटलाळ तुनाळ?” दुसरोर आनीर, “ईद इंगोगो द्यावारलाड घोषणा शेशेतोळ काम्पीस्ताळ” येनटीक की येशु इंगा पुनरुत्थान इ विषयदी सुवार्ताद घोषणा शेस्का उंडदू. ");
INSERT INTO wbq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","नंतर वार वान फटी अरीयपग टेकडी मिंदा एका फोई आन्या, “मीर इचीनेद इदी कोताद शिकवण येम इदी माक समजाशी शप्यार येम? येनटीक की मीर माक अनोळखी माटलु ऐका मतुतूनार दिंदी अर्थ येम इदी समजाशी तीस्कोनाला इल्ला माड इच्छा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","येनटीक की मीर माक अनोळखी माटलू ऐका मतुतुणार; दिंदी अर्थ येम उंडाद इदी समजाशी तीस्कोनाला इल्ला माड इच्छा उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","येम तरी कोताद विषय शप्या ऐकाशीन शिवाय आंदार अथेनेकर इंगा आंदू नीलचेटोर इंगोगार मंदी इर्दी वेळ फोवा कुंदु. ");
INSERT INTO wbq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","आप्पुड पौल अरियपग नाडमा नीला फडी आन्या अरे अथेनैकरटोर, मीर आन्नी बाबतीला द्यावार द्यावारलाक संगेम मान इचेटोर इल्ला नाक कंपीस्ताद. ");
INSERT INTO wbq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","येनटीक की नीन तीर्गुका-तीर्गुका मी उपासनाय वस्तूल सुस्तांना, अनोळखी द्यावार्की इ अक्षरलु लीवाशिनेद वेदी नाक आढळाश्या येमटीद मीर अज्ञानता भजन शेस्तार आदी नीन मिक जाहीर शेस्तान. ");
INSERT INTO wbq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","या द्यावार दुन्याम इंगा दांटलोनी आंताच निर्माण शेश्या वाड स्वर्ग इंगा पृथ्वीटोळ उंडी शेईता बनामतीने इंटल्या नीलवाड. ");
INSERT INTO wbq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","इंगा वांकी एमी कमी लेद, दांचांग मणशी शेईकेल वांदी सेवा घडाला इल्ला पण लेद; येनटीक की जीवन जेम इंगा आंताच वाड स्वता आंदारकी इस्ताळ. ");
INSERT INTO wbq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","इंगा वाड ओकोन देगार नुस मनुष्यलाय आन्नी राष्ट्रल निर्माण शेशी वार पृथ्वी संबंध बेनु मिंदा नीलाला इल्ला शेशिनाळ; इंगा वांदी नेमाशिनेद वेळ इंगा वारदी इनलाद सीमा वाळे ठहरा मतीनद उन्डाद. ");
INSERT INTO wbq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","दिनकस्रोम की, वार द्यावारनी फुळकुकाम इ आशाता शेइयाला इंगा दान यला तरी शिकाआला, वाड मना पैकी यवार तीकेल पण दुराम लेळ. ");
INSERT INTO wbq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","येनटीक की मनाम वान इचांग जगास्ताम, वागास्ताम इंगा उंडाम आले मी कवील पैकी पण यंता तरी जन आनीर की, मनाम वास्तविक वान वंश उंडाम. ");
INSERT INTO wbq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","तर मग मनाम द्यावार वंशज उंडतांना माणशी हुशारीता इंगा कल्पनाता कोराशिनेर बंगार, रूप किंवा राय, इर आकृती लेका द्यावार उंडाम इल्ला मनाक वाटा रोद. ");
INSERT INTO wbq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","अनोळखी काळ तीकुड द्यावार कनलू मुस्कोन्या, पण इपुड आंदार आन्नी तीकुड पश्चात्ताप शैयाला इल्ला वाड मनुष्यलाक आज्ञा शेस्ताळ. ");
INSERT INTO wbq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","वाड इल्ला वगा दिवस नेमाशीनाळ की, यफोद वाड मनाम नेमाशीने मणशी इन तीकेल जगदी न्याय निवाडा नीतीमत्वता शेशेतोळ उंडाळ; वाड वांकी सचीनेन्का लेपीगात इ विशयदी प्रमाण आंदारकी पटामतीडाड. ");
INSERT INTO wbq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","आप्पुड सचीनोर पुनरुत्थान विषयला ऐकाशी यंता तरी जन थट्टा शेस्तुनार, यंता तरी जन आनीर, “इ विषयला मिम मिद इंगा ऐकशाम.” ");
INSERT INTO wbq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","इंता आय्यी नेन्का वार लोकेंल येली फोया. ");
INSERT INTO wbq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","तरी काही मनसलू वांकी चीपकाशी उंडी विश्वास फेटीर; दांटल्या दिओनुस्य अरिय-पगकर, दमारी फेरूद यादू आंडीद इंगा वार संगा इंगोगोर यंता तरी जन उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","येंगसारा पौल अथेनै शहर ईळश्या इंगा करिंथ शहर्की फोया. ");
INSERT INTO wbq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","करिंथला पौल वगा यहुदी मनशिक भेटाश्या यवांदी फेर अक्कीला इल्ला उंड्या, वाड पंत प्रांतटोळ उंड्या, स्वता वळती प्रीस्कील्ला दिन संगा वाड इटली नुस वचिन्या, येनटीक की आंदार यहुदी मंदी रोम शहर इडशी फोवा बेक इल्ला हुकुम क्लौद्याळ तीशिन्या, पौल वारणी भेटादेंक फोया. ");
INSERT INTO wbq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","पौल लेकाने वार तंबू बनामतेटोर उंडीर, वाड वार संगा नीलच्या इंगा वार संगा फनी शेशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","प्रत्येक शब्बाथनाळ पौल सभास्थानला यहुदी मंदी इंगा ग्रीक मंदी संगा माटलाळदू, इंगा वाड यहुदी इंगा ग्रीक मंदीय मनलू तीपेळदी प्रयत्न सेस्का उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","यपुड सिला इंगा तीमथ्य इर मासेदोनीया नुस वापस वचीर, आप्पुड पौल यहुदी मंदीक उपदेश शेशेदेंक स्वताद वेळ इद्देंक आंट्या, येशु इळे ख्रिस्त उंडाळ. इल्ला साक्ष इद्देंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पण यहुदी मंदी पौलकी विरोध शेशीर, वान यहुदी मंदी खराब रीतीता माटलाळीर, आप्पुड मनाद निषेध दर्शवादेंक पौल स्वता फई मिंदूळी बटाल झटकाशा, वाड यहुदी मंदीन आन्या, “जर मिड तारण काल्या, तर दान ला मिद दोष उंडी! मिद नेत्तुर मी नतीके उंडाला! नीन निर्दोष उंडान, आंदकेल मुंदार नुट नीन इंगोगो राष्ट्रटोर मंदी तीकुडे फोयान.” ");
INSERT INTO wbq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","पौल आंदकेल येल्या इंगा सभास्थान देगार निलचेटोळ तीत युस्त फेरटोळ द्यावार उपासक इन इल्लुक फोया. ");
INSERT INTO wbq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","आ सभास्थान क्रिस्प इळ पुढारी उंड्या, क्रिस्प इंगा वान इल्काटोर आंदार प्रभून मिंदा विश्वास फेट्या, करिंथ इंदूटोर मंदी पौलुय मातलू ऐकाशीर इंगा विश्वास फेटीर, करिंथ इंदूटोर संगेम मंदी पौलइ माटलु ऐकाशीर इंगा विश्वास फेटीर इंगा वारदी बाप्तिस्मा शेशेदेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","वगा मबुला, प्रभूद स्वप्नला पौलनि आन्या, “आद्राक, माटलाळका उंड, शांत नीलाक. ");
INSERT INTO wbq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","नीन नि संगा उंडान, यवार पण नि मिंदा हल्ला शेयार इंगा निक इजा शेया खोयार; येनटीक की इ शहरला ना संगेम मंदी उंडार.” ");
INSERT INTO wbq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","दांचांग पौल इंदू दीड वर्ष द्यावार्दी वचन आ मंदीक शिका मतका नीलच्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","यपुड गल्लीयो अखया प्रांतटोळ राज्यपाल उंड्या, आ वेळला काही यहुदील पौल उलटा ओकाताळा वचीर इंगा वान न्यायासन मुंदार नीला फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","यहुदी मंदी आनीर, “इ मणशी इल्ला रितीता मंदीक उपासना शेशेदेंक शिका मतुतुनाळ की, याद नियमशास्र उलटा उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पौल येमी माटलाळी इंताळला गल्लीयो हे यहुदी मंदीन आन्या, “ओकाट आळदाम अपराध किंवा खराब माटा उंटे तर मिद आनकाम ऐकाशी तीस्कुकाम बरोबर ठहरास्तुन्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पण या अर्थी इदी बाब शब्द, फेरलु इंगा मी नियम शास्रलोन प्रश्न संबंधित न्याय शेशेदेंक नीन नकार इस्तान.” ");
INSERT INTO wbq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","मग गल्लीयोर इरनी न्यायासन मुंदारकेल येशिगात इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","इंगा वार आंदार सभास्थानदी प्रमुख सोस्थनेस इन न्यायासन मुंदार मतीर, पण गल्लीयोर दान तीकुड लक्ष इया लेर. ");
INSERT INTO wbq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पौल बंधू जनोर संगा संगेम दिवस नीलच्या, ऐन्ग्सारा वाड येल्या इंगा सिरीया प्रांतला समुद्र दावाता फोया इंगा वान संगा प्रीस्किल्ला इंगा अक्कीला इर इद्दार उंडीर, पौल किंख्रिया शहरला स्वता नतीद मुंडण शेश्या, येनटीक की वाड नवस शेशिन्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","इंगा वार इफिस इंदू वचीर, पौल प्रीस्किल्ला इंगा अक्कीला इरनी इंदू इडशीर, वाड सभास्थानला फोया इंगा यहुदी मंदी संगा वादविवाद शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","यपुड वार वान आंदू इंगा काही वेळ थांबादेंक शपीर, आप्पुड वाड कबूल कालेळ. ");
INSERT INTO wbq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पण फोता फोतांना वाड आन्या, “द्यावार्दी इच्छा उंटे तर नीन वापस मी तीकुड वच्यान” इंगा वाड समुद्र दावाता इफिस नुस येल्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","यपुड पौल कैसरीया इंदू वच्या, आप्पुड वाड आंदकेल मींदीक यरुशलेम शहरकी फोया इंगा मंडळीक भेटाश्या, इंगा वाड किंदा अंत्युखीयाक फोया. ");
INSERT INTO wbq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","आंदू काही दिवस नीलची नेन्का वाड फोय इंगा गलतिया इंगा फुग्रीया इ प्रदेशकेल जागा जागाला प्रवास शेस्का फोया, वाड येशुन अनुयायलान विश्वासता बळकट शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अपुल्लो फेरटोळ वगा यहुदी उंड्या, वाड आलेक्सांद्र शहरला जन्माशिन्या, वाड जास्त शिकाशीनेळ उंड्या, वाड इफिस इंदू वच्या, वांकी शास्रलेखदी सखोल ज्ञान उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","परमेश्वर दावाद शिक्षण वांकी इद्देंक वचीनीर, वाड आत्माला उत्साह उंड्या दान्कासारोम येशुन विषयला अचूकता शिका मतका इल्ला इंगा माटलाळदू, तरी वांकी फक्त योहानदी बाप्तीस्माने यरका उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","वाड सभास्थानला आदराकुना माटलाळदू, आप्पुड प्रस्कीला इंगा अक्कीला इर वारदी भाषण ऐकाशी वान देगार कुतेशी इंगा वांकी द्यावार्दी दावा इंगा स्पष्ट पनता सुपिच्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","अपुल्लोला अखया देशला फोयेळदी उंड्या, आप्पुड बंधूल वानकी उत्तेजन इच्चीर इंगा आंदूटोर येशुन शिष्यलनि वान स्वागत शेशेळ विषयला लीवाश्या, यपुड वाड पोहोचाश्या, आप्पुड यवार कृपा इचांग विश्वास फेटीनीर, वारकी वार संगेम मदत शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","जाहीर वाद विवाद वाड यहुदी मंदीक संगेम जोरदार पणता पराभूत शेश्या इंगा पवित्र शास्रलेख आधारता येशु इडे ख्रिस्त उंडाळ इदी सिद्ध सेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","आप्पुड इल्ला आय्या की, अपुल्लो करिंथ इंदू उंडतांना पौल वेगवेगळा भागलोन्केल प्रवास शेस्तांना इफिस इंदू वच्या, आंदू वांकी काही शिष्यल आढळाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","पौल वारणी आळग्या, “यपुड मीर विश्वास फेटतीर, आप्पुड मीक पवित्र आत्मा शिकीनाद येम?” वार अनुयायी आनीर, “पवित्र आत्मा उंडाद इदी पण मिम ऐकालेम.” ");
INSERT INTO wbq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","वाड आन्या, “इंगा याद बाप्तिस्मा मीर तीस्कोनटीर?” वार आनीर, “योहानदी बाप्तिस्मा.” ");
INSERT INTO wbq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पौल आन्या, “योहानदी बाप्तिस्मा पश्चात्तापदी उंड्या, वाड मंदीक शप्या की, दान नंतर यवाड वस्तूनाळ, वान मिंदा मंदी विश्वास फेटाला, वाड वचेटोळ म्हणजे येशुड उंडाळ.” ");
INSERT INTO wbq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","यपुड वार इदी ऐकाशीर, आप्पुड वार प्रभू येशुन फेरता बाप्तिस्मा तीस्कोन्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","इंगा यपुड पौल वांदी शेई वान मिंदा वच्या इंगा वेगवेगळा भाषा माटलाळदेंक आंटीर इंगा भविष्य शपतुनार. ");
INSERT INTO wbq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","इ गटला आंदार मिळाशी बारा मनसलू उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","पौल यहुदी सभास्थानला फोदूर इंगा मूड महिनालधेर्यता माटलाळदू, द्यावार राज्य विषयला चर्चा शेस्का इंगा यहुदी मंदी मनलु तीपुदु. ");
INSERT INTO wbq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पण वार लोन्केल काही कठीण मनता आय्यीर इंगा वार विश्वास फेटीदेंक नकार इच्चीर इंगा ख्रिस्त दावाविषयला खराब माटलाळीर, मग पौल वार लोन्केल येली फोया इंगा शिष्यलान पण वार लोन्केल वेगडा शेश्या इंगा तुरंना शाळाला दिनाम वार संगा चर्चा शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","इदी इल्ला दोन वर्ष नळश्या, दिंदी परिणाम इल्ला आय्या की, आशियाला प्रान्त निलचेटोर आंदार यहुदीळ इंगा ग्रीक मंदी पर्यंत प्रभू येशुनदी वचन पोहोचाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","द्यावार पौल शेईता असामान्य चमत्कार घडमत्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","पौल शरीर मिंदा द्स्ती इंगा बटाल पण येकोची काही, मंदी इ माटलू बिमार मंदी मिंदा फेटूदू, यपुड वार इल्ला शेयदूर आप्पुड बिमार मंदी शिंगार आतार इंगा दृष्ट आत्मा वारणी इडशी फोदू. ");
INSERT INTO wbq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","काही यहुदील सुद्धा आंता तीकुड प्रवास शेस्का उंडदूर इंगा मंदीलोन्केल दृष्ट आत्मा तिदूर, वार दृष्ट आत्माता आंटीने मणशीलोन्केल प्रभू येशुन फेरता वार आत्माल तीदूर. ");
INSERT INTO wbq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","वार आंदुर, “पौल या येशुन फेरता घोषणा शेस्ताड आ फेरता नीन निक आज्ञा शेस्तान,” स्कीवा फेरोन यहुदी मुख्य याजक सात कोडकूल इल्ला शेयदूर. ");
INSERT INTO wbq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","पण वगा तुक ओगाट दृष्ट आत्मा वारणी आन्या, “नीन येशुन ओळखास्तान, पौल नाक यरका उंडाड, पण मीर यवार उंडार?” ");
INSERT INTO wbq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","मग यावान दुष्ट आत्मा आंटीन्या आ मणशी वार मिंदा उडी मत्या, वाड वार मिंदा ताबा तीस्कोन्या इंगा वारणी हारा मत्या, आप्पुड वार इद्दार भोन्गळा इंगा जखमी आय्यी इंटलोन्केल फारीर. ");
INSERT INTO wbq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","इफिस इंदू नीलचेटोर आंदार यहुदी इंगा ग्रीक मंदीक इदी समजाश्या, आप्पुड आंदारकी येर्पू आय्या इंगा मंदी प्रभू येशुन फेरुद जास्तने आदर शेशेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","संगेम विश्वास फेटेटोर पाप कबुली इद्देंक आंटीर इंगा याय खराब माटलु वार शेशीनीर आय्यी शपतुनीर. ");
INSERT INTO wbq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","काही विश्वास फेटेतोर जादुय फनील शेशिनीर, इ विश्वास फेटेतोर स्वताय जादूय पुस्तकलु मंदी मुंदार येकोचीर इंगा कालचीर, आ पुस्तकलाद किंमत पन्नास हजार येंडी शिकाल इंता निन्ड्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","इ रीतीता प्रभून वचनदी दुराम नंताक प्रसार आय्या इंगा आदी संगेम परिणाम कारक ठराश्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","इ माटलु घडाशी नेन्का पौलकी आत्मा सुचा मत्या की, मासेदोनीया इंगा अखया इ प्रांतलोन्केल प्रवास शेस्का मुंदार यरुशलेम शहरकी फोवा बेक, वाड आन्या, “नीन आंदू फोई नेन्का नाक रोम शहर पण सुडाने बेक.” ");
INSERT INTO wbq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","दांचांग वान इद्दार मदत शेशेतोर तीमथ्य इंगा एरास्त इरनी वाड मासेदोनीयाक आंपडीच्या इंगा वाड इंगा काही काळ आशियाला नीलच्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","इ काळला 'आ दावा विषयला फेदाद गोंधळ येगर्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","देमेत्रीय फेरोड ओगा मणशी उंड्या, वाड सोनार उंड्या, वाड अर्तमी द्यावारी गुडील बनामतुदू, यवार कारागीर उंडीर वारकी आटलाकेल संगेम दुडलु शिकुदू. ");
INSERT INTO wbq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","वार आंदारनी इंगा धंदा जताक संबंध उन्डीनोर आंदारनी वाड ओगातळा शेश्या इंगा वाड आन्या, मंदीलाला, मिक यरका उंडाद की, इ धंदालोन्केल मनाक शिंगार दुडलु शिकताय. ");
INSERT INTO wbq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","पण सूडना वाड पौल फेरटोड मणशी येम शेस्तुनाड वाड येम आंटूनाड आदी ऐकांडा! पौल संगेम मंदीन प्रभावित शेशिनाड इंगा बदलाशीनाड, वाड इदी इफिसला इंगा आंता आशियाला शेशिनाड, वाड आंटाड, मणशी शेयता बनामतीने द्यावारलु खरेम द्यावारलु लेव. ");
INSERT INTO wbq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","दिनकस्रोम इ मना धंदालदी बदनामी आय्येद धोका उंडाद; इंते लेद तर या महादेवी अर्तमिद पूजा आंता आशिया प्रांत किंवा जगपण शेस्ताद दांदी मंदिर निरूपयोगी ठरायमतेद इंगा दांदी स्वताद महत्व नष्ट आय्येद धोका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","यपुड वार इदी इनीर आप्पुड वार संगेम कोफाम फडीर इंगा बेग्गे कीरली आनेदेंक आंटीर, “इफिसटोरदी अर्तमीद फेदाद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","शहर लोन मंदीला गोंधळ येगर्या इंगा मंदी गायस इंगा अरीस्तार्ख इ पौल संगा आनी प्रवास शेशेतोरनी मासेदोनीयाला निलचेतोरनी फटी नाट्यगृहला एका फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पौलकी मंदी मुंदारकी फोयेद इच्छा उंड्या पण येशुन अनुयायील वान इल्ला शेयानिया कुंदुर. ");
INSERT INTO wbq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","पौलुय काही सोबतील यवार प्रांत अधिकारी उंडीर, वार निरोप आंपडीची वाड नाट्यगृहाला फोवारोद इल्ला कळकळीद विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ओगातळा जमा आयनेंका मंदी ओगाट घोषणा शेशेदेंक आंटीर तर दुसरा मंदी इंगोगाट घोषणा शेशेदेंक आंटीर, दांचांग आंता जमा आईनोर गोंधळाशी फोइर इंगा दान्टल्योन संगेम मंदीक यरका लेकुंड्या की, मनाम इ न्याय भवनला ओगातळा येनटीक वचीनाम. ");
INSERT INTO wbq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","यहुदी मंदी आलेक्स्रांद्र फेरोन ओगा मंशीन दोबुका एका फोई आंदार मुंदार नीला फडामतीर, वाड वान स्वता शेतलाता खुनवाशी वारकी समजा मतेद प्रयत्न शेशेदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पण यपुड मंदीक समजाश्या की, वाड यहुदी उंडाड, आप्पुड देगा-देगार रोंड घंटाल सारखा वार वगा आवाजता किर्लुका निलचीर, “इफिसटोरदी अर्तमी द्यावार फेदाद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","शहरटोड लेखनिक मंदीन शांत शेस्का आन्या, “इफिसटोर मंदी, फेदा अर्तमी द्यावार्दी इंगा स्वर्गकेल फडीने पवित्र गुंडूद इफिस इदी रक्षणकर्ता उंडाद, इदी यवार्की यरका उंडाद इल्ला ओगाड तरी मणशी दुन्यामला उंडाड येम? ");
INSERT INTO wbq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","या अर्थता इ माटलु नकार शैया दाव दांचांग मीर शांत नीलवाने बेक, उतावळा पना शेया राद. ");
INSERT INTO wbq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","मीर इ इदारणी इंदूक ऐकोन वचीणार, खरेम तर वार मंदिर लोंदी येमटीद पण दोंगा शैया लेद किंवा मना द्यावार्दी निंदा शेया लेद. ");
INSERT INTO wbq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","जर देमेत्रीय इंगा वान संगा उंडीने कारागीरलाय येमाना तक्रारील उंटे, तर दांचांग न्यायलयलु उघडा उंडाय, आंदू वार वगामेगार मिंदा आरोपलु येशी शकास्तार. ");
INSERT INTO wbq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पण जर मिक यादाना माटाद चौकशी शेशेद उंटे तर हमेशा सभाला दान संबंधला विचार शेस्काम्ला वच्ची. ");
INSERT INTO wbq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","इफोद इंदू येम पण घडाशीनाद, दान बदल योग्य इदी कारण मनाक शपा दाद, दांचांग मनामे इदी दंगल चालू शेस्टतीम इल्ला आरोप मना मिंदा वचेद येरपु उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","इल्ला शपकाम आय्यी नेन्का वाड जमा आईनोरनी फोयेदेंक शप्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","यपुड गोंधळ थांबाश्या, आप्पुड पौल येशुन अनुयायीलनि भेटादेंक कुतेश्या इंगा वारकी उत्तेजन इचीनेन्का वारदी निरोप तीस्कुन्या इंगा वाड मासेदोनीयाक येल्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","मासेदोनियाकेल फोयेतापुड वेगवेगळा जागाला उंडीनोर येशुन अनुयायीलाक वाड संगेम माटलु शपी धीर इच्या, मग पौल ग्रीस प्रांत वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","आ जागाला वाड मूड महिनाल नीलच्या, पौल सिरीया प्रांतला समुद्र दावाता एलीनेन्का, यहुदी मंदी वान उलटा कट रचाशीर, इदी सुशी वाड मासेदोनीया नुस वापस वचेद ठरा मत्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","वार संगा काही मंदी उंडीर वार इल्ला: बिरुया नगरलोन पुर्रोन कोडकु सोपत्र, थेस्सल्निका इंदुड अरीस्तार्ख इंगा सकुंद, दर्बा इंदुड गायस इंगा तीमथ्य, तुखीक इंगा त्रफिक इर आशिया प्रांतलोनटोर उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","इ मन्सूल मा मुंदारकी फोईर इंगा त्रोवस शहरला माद दावा सुदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","बेखमीर रोट्याद यहुदी फंडगा बाद मिम फिलीप्पी इंदकेल समुद्र दावाता यलतीम इंगा आय्यीद नाळाक त्रोवस इंदू वारकी फोई भेटास्तीम इंगा आंदू सात दिवस निलस्तीम. ");
INSERT INTO wbq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","मग हप्ता पहिला नाळ मिम आंदार रोट्याल तेमपुदेंक ओगातळा उंन्याप्पुड, पौल वार संगा माटलाडदेंक आंट्या येनटीक की दुसरा नाळ येल्लेद वांदी बेत उंड्या, वाड आर्दाम मबुनंताक माटलाडका नीलच्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","माडी मिंदुड या खोलीला मिम जमा आय्यी निंटीम आंदू संगेम दिवाल उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","युतुख फेरोड ओगा जवान खिडकिला कुसिंड्या, पौल माटलाडेतापुड वाड निद्दारला इंता गुंगाशीन्या की, वाड तिसरा मजली मिंदकेल किंदा फड्या, यपुड वान येतीर, आप्पुड वाड सचीनोड शिक्क्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पौल किंदीक फोया इंगा वान झाकाश्या इंगा वान स्वता शेईता दोक्काला फटी आन्या, “चिंता शेया कुंडा! वानला इंगाना जेम उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","मग पौल मींदीक फोया, रोट्या तेम्प्या इंगा आदी तिन्या, फदु फुटी नंताक वार संगा माटलाड्या, मग वाड फोया. ");
INSERT INTO wbq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","आ मोग्बिडान वार जिवंत इल्ला इल्लुक एका फोईर, वार आंदारकी समाधान आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","आंदकेल मिम मुंदार की एलतीम इंगा अस्सा इ नगरला समुद्र दावाता येलतीम, आंदू मीं पौलनी येस्केन तुन्टीम, वाडे इल्ला प्रकारता योजना शेशिन्या, आदी म्हणजे वाड स्वता नळस्का हियेद. ");
INSERT INTO wbq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","यपुड माक वाड अस्सा इंद भेटाश्या, आप्पुड मिम वान जहाजला तीस्कोनटीम इंगा मिम मितुलेने शहरला फोतीम. ");
INSERT INTO wbq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","दुसरा नाळ मिम जहाजता मितुलेनकेल यलतीम इंगा खियास बेट मिंदा वस्तीम, मग दुसरा नाळ सामा बेट दाटटीम इंगा वगा नाळ नंतर मिलेत शहरला वस्तीम. ");
INSERT INTO wbq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","येनटीक की पौल ठहरा मतीन्या की इफिस इंदू थांबा रोद, आशियाला वांकी जास्त वेळ थांबा शेळदी लेकुंड्या, वाड घाई शेस्का उंड्या येनटीक की शक्य आते पन्नासवा दिवस फंडगा इचांग वांकी यरुशलेम शहरला निलचेळदी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","मिलेत नुस इफिस इंदू निरोप आंपडीचीपौल इंदुळ मंडळी आबागारनि कुतेस्कोन्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","यपुड वार वचीर, आप्पुड वाड वारणी आन्या, आशियाला वस्तीन आफोदोळ नुस नीन मी संगा उंडतांना यला निलस्तीन इदी मिक यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","नीन प्रभुंदीसेवा नम्रतागोन इंगा यडस्का शेसतीन, यहुदी मंदी शेशीने कट इचांग निर्माण आयीने उपद्रवलाक नोर इस्तांना नीन वांडी सेवा शेस्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","येम पण मी शिंगार इचांग उंड्या वार मिक शपदेंक याद पण कसर फेटालेर, इदी मिक यरका उंडाद इंगा इ माटलु जाहीर पनता इन इलूइलूकेल शपीदेंक नीन यपुड पण यंकाक मुंदार सुळा लेन. ");
INSERT INTO wbq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","पश्चात्ताप शेशी द्यावार तीकुड तीरगेळ विषयला इंगा स्वता प्रभू येशु ख्रिस्त विषयला यहुदी इंगा यहूदी लेनोर मंदीक सरखाने साक्ष इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","इंगा इपुड आत्मा आज्ञाता यरुशलेम शहरकी फोतुनाम इंगा आंदू ना बद्दल येम घाडाशी इदी यरका लेद. ");
INSERT INTO wbq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","नाक फक्त ओकाटे माटा यरका उंडाद की प्रत्येक शहरला पवित्र आत्मा नन्नु सावध शेस्ताद, तुरुंगवास इंगा संकटलु नाद दावा सुस्तुनाय इदी वाड नाक शप्ताळ. ");
INSERT INTO wbq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","नीन ना जीवनविषयला काळजी शेयान, आंदार कना महत्वद माटा आंटे नीन नाद फनी पूर्ण शेशेद, प्रभू येशुड याद फनी नाक इच्या आदी नाक पूर्ण शेयाने बेक आदी फनी आंटे द्यावार कृपा बद्दलदी सुवार्ता मंदीक शपा बेक. ");
INSERT INTO wbq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","राज्यद घोषणा शेस्का या मंदीला नीन तीरगुतीन आ मी दिन्टल्योन्केल येवार्कीच नीन डबल काम्पियाक फोयान इदी इपुड नाक यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","दांचांग नीन मिक जाहीर पणता शप्तान की, आंदार नेत्तुर संबंधता नीन निर्दोष इल्ला उंडान. ");
INSERT INTO wbq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","द्यावार्दी पूर्ण इच्छा येम उंडाद इदी प्रकट शेशेदेंक नीन यपुड पण यंकाक मुंदार सुडालेन. ");
INSERT INTO wbq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","मिद स्वताद इंगा द्यावार आंता मंदीद, यवारनी द्यावार मिक इच्चीनाड, वारदी काळजी तीस्कोंडा, द्यावार कळपदी काळजी तीस्कुणेद फनी पवित्र आत्मा मिक इच्चीनाड, मीर मंडळी इचांग पण मेंढऱ्याल साकेटोर लेका उंडा बेक, इदी मंडळी द्यावार स्वताद नेत्तुर इच्ची कोंकूडाद. ");
INSERT INTO wbq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","नाक यरका उंडाद की, नीन फोई नेन्का मी नडमा दृष्ट लांडगाल वच्ची, आय्यी कळपलान इडवाक फोई. ");
INSERT INTO wbq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","मी लोन्केल पण मंदी लेशिगास शिष्यलकी, चुकीद इल्ला शिका मती मना यंका एका फोयार. ");
INSERT INTO wbq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","दिनकस्रोम सावध उंडा, मी लोन्केल प्रत्येकोरनि फोईने मूड वर्षल कंडलाला कण्येळलु येकोची सावध शेशेद नीन यपुडूच थांबा मता लेन इदी ध्यानाम शेयना. ");
INSERT INTO wbq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","इंगा इपुड नीन मिमलान द्यावार इंगा वचन कृपाला अधीन शेस्तान, याद मिद वाढ शेशेदेंक समर्थ उंडाद इंगा आंता पवित्र शेशिनोरकी वतन इद्देंक समर्थ उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","नीन यवार्दी पण बंगारदी येंडीद इंगा बटालदी लालच फेटा लेन. ");
INSERT INTO wbq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","नीन मना स्वताद इंगा ना संगा उंडेटोरि गरजलु ना शेईता भागा मतुतीन इदी मिक शिन्गाराने यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","इल्ला रीतीता नीन मिक उदाहरण शेशी इचीनान की यवार कमजोर उंडार इलोनटोरनि मनाम स्वता मेहनत शेशी मदत शेया बेक इंगा प्रभू येशुन शब्दल लक्षला फेटा बेक, वाड स्वता आन्या, “तीस्कोणे पेक्षा इच्चेद जास्त धन्यद उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","इंगा इदी माटलाडी नेन्का पौल मोकाळ टेकाश्या इंगा अनदार सग्गा प्रार्थना शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","आप्पुड प्रत्येकोरकी संगेम यडपु वच्या, वार पौल गोन्तुला फडीर इंगा वाणी मुत्ताल तीस्कूका निलचीर. ");
INSERT INTO wbq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","वार इंगा वान यपुडूच सुशी शकायार, इ वाक्यता वारकी संगेम दुःख आय्या, मग वार वान जहाज नंताक ईडदेंक फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","वारदी निरोप तीस्कुनी नेन्का मिम समुद्र दावाता येलतीम इंगा सरळ प्रवास शेस्का कोस बेट की वस्तीम, दुसरा नाळ मिम रूप बेटकी फोतीम, आंदकेल मिम पातरा शहर की फोतीम. ");
INSERT INTO wbq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","आंदू फेनीकप्रान्त की फोयेळदी जहाज माक काम्पिच्या, आप्पुड मिम जहाजला कुसनी मुन्दाएकी येलटीम. ");
INSERT INTO wbq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","यापुड कुर्प बेट मा नजरला वच्या, पण वार दावा शरीरकी येशी सरळ सिरीया प्रांतकी येलटीम इंगा सोर इंदू दिगटीम, येनटीक की आंदू जहाजलोंदी माल दिम्पेळदी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","आंदू येशुन काही शिष्यल माक आढळाशीर इंगा मिम वार संगा योडंनाळ नीलस्तिम, पवित्र आत्मा सुचना मिंदकेल वार पोलकी इल्ला शपीर की, वाड यरुशलेम शहरकी फोवा रोद. ");
INSERT INTO wbq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","मा भेटाशेय नाळ साम्पादेंक वचीनेन्का मिम आंदकेल येली मा मुंदार प्रवास इंगा सुरु आय्या, आ वेळला आंदूटोर बंधू जन स्वता वळती बीळला संगा मा संगा शहर बेटीक वचीर इंगा आन्दुळ समुद्र काटमिंदा मिम मोकाळलु टेकास इंगा प्रार्थना शेस्तिम. ");
INSERT INTO wbq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","इंगा वगार मेगार्द निरोप तीस्कोनी मिम जहाजला कुशिन्टीम इंगा आ मंदी स्वता-स्वता इल्लुक फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","सोराकेल मिम मा प्रवास सुरू शेस्तीम इंगा पोलेमा शहर इंदू दिगटीम इंगा आंदूटोर मंडळीलनी भेटास्तिम, वार संगा वगा नाळ नीलस्तिम. ");
INSERT INTO wbq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","इंगा उन्गो नाडा येळी मिम कैसरीयाक वस्तीम इंगा सुवार्तिक फिलीप्प इन इलकाडा फोई निलस्तीम, वाड निवडाशोनर सात सेवकला लोन्केल ओकोड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","इंगा नालुग अड्बीळ उंडीर, वारी फेनलील काले कुंड्या, इ अंदबिळाक द्यावारी माटलु शपेळदी दान उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","आ बंधूल संगा बागाने दिनमुल नीलची नेन्का अबग फेरटोळ संदेष्टा यहुदीया नुस इंदू वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","वाड माद भेट तीस्कोनी पौल नळमुलाद पट्टा आळकोन्या, वाड स्वताय शेईल इंगा काळलु कट इंगा वाड आन्या, “पवित्र आत्मा इल्ला आंटाद ; इदी पट्टा या मणशी नळमुलाद उंडाद, वान यरुशलेम शहरलोन यहुदी मंदी इलाने कट्यार इंगा इंगोगो राष्ट्रटोर शेतला इच्यार.” ");
INSERT INTO wbq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","मिम इंगा आंदूटोर आंदार आयी माटल ऐकाशीर, आप्पुड मिम इंगा इंगोगो मंदी पौलनी कळकळीद विनंती शेस्तिम, वाड यरुशलेम शहर की फोवा रोद. ");
INSERT INTO wbq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पण पौल आन्या, “मीर इदी येम शेस्तुणार, इल्ला यडशीगात मीर नाद मन खचामतका उंडार येम? नीन फक्त कटी तीस्कोन्देंक लेद तर प्रभू येशुन फेर इचांग यरुशलेम शहरला सचीदेंक पण तयार उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","यरुशलेम शहर नुस दुराम निलदेंक मिम वांदी मन तीरगामतु शकालेम, दांचांग मिम वान विनंती शेशेळदी इडशीर इंगा आनीर, “प्रभून इच्छालेका कानी.” ");
INSERT INTO wbq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","दान बाद मिम तयार आतीम इंगा यारुशलेम शहरकी येलटीम. ");
INSERT INTO wbq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरीया इंदुळ येशुन काही शिष्यल मा संगा वचीर इंगा माक म्नासोन फेरटोळ माणशी तीकुड एका फोईर, येनटीक की वान तीकुड मिम नीलचेटोर उंटीम, वाड कुप्रटोळ उंडी सुरवाती काळला पहिला शिष्य आयीनेर लोन्केल ओकाट उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","मिम यपुड यरुशलेम शहरकी पोहोचास्तीम, आप्पुड आंदूटोर बंधूजनलु फेदा आनंदता माद स्वागत शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","उन्गो नाडा पौल मा संगा याकोबनि भेटादेंक वच्या, आप्पुड आंदार आब्बागार हजर उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","पौल वारणी भेटाश्या, दान बाद वान शेईता द्यावार इंगोगो यहूदी लेनोर मंदीला येलायेला सेवा शेस्कोन्या, इविषयला वगा वगाट सविस्तर माहिती शप्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","यापुड वार इदी ऐकाशीर आप्पुड वार द्यावार्दी गौरव शेशीर इंगा वार वान आनिर, “तामुडू, नु सुश्याव की हजारो यहुदील विश्वास फेटेतोर आयीर, वारकी इल्ला वाटास्ताद की, मोशेंदी नियम पाळासकाम संगेम महत्वद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","इ यहुदी मंदी मी बदल ऐकाशीनार की, या यहुदील इंगोगो देशला निलस्तार वारकी नु मोशेंदी नियम पाळाक आंका इल्ला शप्ताव, आले स्वता बीळलाद सुंता शैया कुंडा आंका इल्ला शप्ताव इंगा मानाय चालीरीतील पाळा कुंडा इल्ला शप्ताळ. ");
INSERT INTO wbq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","मग इपुड येम शैया बेक? नु इंदू वचीनाव इदी वारकी नक्की तेलची. ");
INSERT INTO wbq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","इंगा इपुड मिम येम शप्ताम आला शेय; मा लोन्केल नाल्गुर मंदी नवस शेशिणार. ");
INSERT INTO wbq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","आ नाल्गुरन जननी तीस्को इंगा स्वताद वार संगा शुद्धीकरन शेस्को, आ नाल्गुर जनकी वारदी मुंडन शेया दाला दांचांग वारकी खर्च नु शय, इंगा आंदारकी इदी तेलच्या की, वार येम काही नि बद्दल ऐकाशिणार आदी खरेम लेद, उलटा नु नियम शास्रद पालन शेस्ताव इदी काम्पीची. ");
INSERT INTO wbq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","यवार यहूदी लेनोर विश्वास फेटेटोर उंडार वारकी मिम पत्र लीवाशिनाम, आदी इल्ला, मूर्तिक एकपिचीनेद आन्नाम वार तीनारोद, नेत्तुर जर गोंतू फिस्की मतीने प्राणीलाड वार तिनारोद इंगा व्यभिचार शेयारोद.” ");
INSERT INTO wbq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","इंगा पौले आ नाल्गुर मंदीन स्वता संगा तीस्कोन्या, उन्गो नाळ शुद्धीकरन विधीला वाड सहभागी आय्या, इंगा वाड परमेश्वर भवनला फोया, शुद्धीकरनी दिवसलु यपुड संपाशी इदी जाहीर शेशीर, शेवटनाळ प्रत्येकोर इचांग अर्पण इद्देंक वची. ");
INSERT INTO wbq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","योडं नाळ देगार-देगार संपास्का वचीन्या, गान आशियाटोर काही यहुदीळ मंदी पौलनी परमेश्वर भवनला सुशीर, वार मंदीन भडकामतीर इंगा पौलनी फटीर. ");
INSERT INTO wbq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","वार बेग्याता कीरली आनीर, “इस्राएलटोर मंदी, मदत शेयना! इडे वाड मणशी उंड्या, यवाड आंदार मंदीक आंता तीकुड स्वता मंदी उलटा नियमउलटा इंगा इ जागाबद्दल शिका मतुतुणार इंगा इपुड वाड यहूदी लेनोर मंदीन सुधा परमेश्वर भवनला येकोचीर इंगा इदी पवित्र जागा अपवित्र शेशा.” ");
INSERT INTO wbq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","वार इल्ला आनीर, येनटीक की इफिसटोळ त्रफीमनि वार पौल संगा यरुशलेम शहरलोनटोर सुशीनीर, त्रफिम यहुदी लेकुंड्या, वाड ग्रीक उंड्या, मंदीक वाटाश्या, पौलने वान परमेश्वर भवनला एकोची डाड. ");
INSERT INTO wbq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","आंता शहर खवळाशी लेशीर, आंदार मंदी फारदेंक आंटीर, वार पौलनि फटीर इंगा परमेश्वर भवनलोन्केल बेटीक जगीगात तीशीर, लगेच दरवाजाल बंद शेशेदेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","वार वान ठार मतेळदी प्रयत्न शेस्तांना रोमी सैन्यला सरदार तीकुड बातमी फोया की, आंता यरुशलेम शहरला आंदार तीकुड गोंधळ उडाशीनाद. ");
INSERT INTO wbq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","लगाने वाड काही शिपाईळ इंगा काही शताधिपतील तीस्कोन्या इंगा वाड यहुदी यंदू पौलनी मतुतूदूर, आंदू फारका फोया, आप्पुड यहुदी मंदी रोमी सरदारनि इंगा सैन्यन सुशीर आप्पुड वार पौलनि मतेळदी थांबा मतिर. ");
INSERT INTO wbq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","इंगा सरदार पौल तीकुड वच्या इंगा वान फट्या इंगा वान साखळीलता कटेळदी आज्ञा इच्या, इंगा सरदार पौल यवाड उंडाळ इंगा वाड येम शेश्या इविषयला आळग्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","गर्दी लोन्केल अलग-अलग प्रकारी आवाज ऐकासीवच, गोंधळ इचांग इंगा किरलीने इचांग सरदार की खरेम येम उंडाद इदी यरका काक फो, दांचांग सरदार शिपाइलकी आज्ञा इच्या की, पौलनी इमारतला ऐकोन फोवाला. ");
INSERT INTO wbq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","यपुड पौल इमारत पायरी देगार वच्या आप्पुड शिपाईलाक वान लेशी येतकोण फोवा बेक आय्या. ");
INSERT INTO wbq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","येनटीक की जमाव हिंसक बनासका फोतुन्या, जमाव वान यंकाक फोदू इंगा किर्लुका उंड्या, “वान जेमता मतना.” ");
INSERT INTO wbq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","शिपाई पौलनी इमारतला एका फोयार इंताळला पौल सरदारनि आन्या, “नीन येमाना माटलाळू शकास्ताळ येम?” आ सरदार आन्या, “निक ग्रीक माटल वस्ताद येम? ");
INSERT INTO wbq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","इंगा नाक वाटास्ताद, आ मणशी नु लेव, नाक वाटाश्या या मिसरी मजूर काही दिवसला पहिला बंड शेशी सरकारकी त्रास इचेळदी प्रयत्न शेश्या, वाड नु उंडाव, आ मिसरी मनशी नालुग हजार दहशत टोरन मरूम प्रदेश ला एका फोया.” ");
INSERT INTO wbq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौल आन्या, “किल्कीया प्रांतलोन्टोर तार्सस नगरला नीलचेटोळ नीन वगा यहुदी उंडान, नीन वगा महत्व शहरटोळ नागरिक उंडान, नीन मिक विनंती शेस्ताम, नाक मंदीन माताला नीयीयांडा.” ");
INSERT INTO wbq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","आप्पुड सरदार वांकी माटलाळेळदी परवांगी इच्या आप्पुड वाड पायरील मिंदा नीला फड्या इंगा स्वता शेईता मंदीक शांत निल्देंक शप्या, यपुड आन्नी तीकुड तेपांग आय्यीर आप्पुड पौल इब्री भाषाला माटलाळ देंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","बंधू जनलू इंगा आब्बागार मंडळीळ, नीन येम पण इपुड मिक प्रत्युत्तर शेस्तान आदी एकांडा. ");
INSERT INTO wbq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","वाड मना संगा इब्री भाषाला माटलाळतुनाल इदी एकाशी वार इंगा शांत आयीर, इंगा वाड आन्या. ");
INSERT INTO wbq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","नीन यहुदी उंडान, नाद जन्म किल्कीयालोन तार्स नगरला आय्या इंगा नीन इ शहरला गमलीयेल काळला देगार शिनावोळ नुस फेदोळ आयी इनाक आबातातागार नियम शास्रद शिक्षण कडकडीत रीतीता शिकीनाद इंगा यला मीर आंदार इफोद द्यावार विषयला आवेशी उंडार आले नीन पण उंटीन. ");
INSERT INTO wbq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मंस्लान इंगा आंडेरणी कटी तुरुंगला येशी शरीरला शिक्षा इच्ची पण नीन 'इ दावाद' पाठलाग शेस्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","आ विषयला महायाजक इंगा आंदार आबातातागार वर्ग पण ना साक्षी उंडार; नीन वा तीकेल बंधू जनलाक पत्रल तीस्कोनी दिमिष्की फोदुन; दिनकस्रोम की, यवार आंदू उंडीर वारणी पण कटी यरुशलेम शहरला शासन शेशेदेंक एका दाला. ");
INSERT INTO wbq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","इंगा इल्ला आय्या की, फोता-फोता नीन दिमिष्क शहर देगारा पोहोचास्तीन आप्पुड आंटे मद्यान वेळला मोळामकेल ना भोवती वगा फेदाद यलगु चमकाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","आप्पुड नीन भुमी मिंदा फडतीन इंगा “शौल, शौल, नाद छळ येनटीक शेस्ताव?” इल्ला वाणी ना संगा नीन माटलाळ तांना ऐकास्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","नीन आळगुतीन, प्रभू, नु यवार उंडाव? वाड नन्नु आन्या, “या नासरी येशुनदी नु छळ शेस्ताव वाड नीने उंडान.” ");
INSERT INTO wbq_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","आप्पुड ना संगा यवार उंडीर वारकी यलगु काम्पिच्या खरेम, पण ना संगा माटलाळेतोंदी आवाज वार ऐकालेर. ");
INSERT INTO wbq_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","इंगा नीन आंटीन, प्रभू नीन येम शेयाला? प्रभूड नन्नु आन्या, “लेशी दिमिष्कला फो;इंगा नु येम पण शेयाला दांचांग ठहरामतीनाळ, आ आंदार विषयला नीक इंदू शपिदेंक वची.” ");
INSERT INTO wbq_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","आ यलगु तेज इचांग नाक काम्पिया कुंदु; दांचांग ना सोबतील नाद शेई फटी नन्नु दिमिष्ककी एका फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","इंगा हनन्या फेरटोळ यवार तरी ओकोळ मणशी उंड्या, वाड नियमशास्रलेका नीतिमान उंड्या इंगा इंदू नीलचेटोर आंदार यहुदीळ वान विषयला शिंगार माटलाळदर. ");
INSERT INTO wbq_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","वाड ना देगारा नीला फडी नन्नु आन्या, शौल तमुळ, इकाड सूळ, आद्दे वेळला नीन इंगा वान तीकुड मिन्दिक सुस्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","इंगा वाड आन्या मना पूर्वजला द्यावार निसंबंधला ठहरामतीनाळ की, वांडी इच्छा येम उंडाद इदी नु समजाशी तीस्कोनाला; इंगा आ नीतिमान मंशीन सुळाला इंगा वान नोरदी आवाज ऐकाला. ");
INSERT INTO wbq_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","येनटीक की येम नु सुशीनाव इंगा यीनिनाव आ विषयला नु आंदार मंदी मुंदार दान साक्षी आयाव. ");
INSERT INTO wbq_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","तर इपुड उशीर येन्टीक शेस्ताव? लेव, वान फेरुद धावा शेशी बाप्तिस्मा तीस्को इंगा स्वता पापलाद कडगी लय. ");
INSERT INTO wbq_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","इंगा इल्ला आय्या की, नीन यरुश्लेम शहरकी माघारी वचीनेन्का, परमेश्वर भवनला प्रार्थना शेस्तांना नाद भान लेकुंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","आप्पुड नीन वान सुस्तीन; वाड नन्नु आन्या, “बेगाना शेय, येरुशलेम शहरकेल लगान येली फो; येनटीक की नु ना विषयला इचीनेद साक्ष वार मानायाक खोयार.” ");
INSERT INTO wbq_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","आप्पुड नीन आंटीन, प्रभू, वारकी यर्क उंडाद की, नि मिंदा विश्वास फेटेटोरनी नीन बंदीला येशी प्रत्येक सभास्थानला वारणी मातुतूदून. ");
INSERT INTO wbq_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","नीद साक्षी स्तेफन इनदी रक्तामता निंडी फोया आप्पुड स्वता देगार नीला फडी सहमत उंटीन मतुदू इंगा वान मतेटोरी बटाल संभाळीदुम. ");
INSERT INTO wbq_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","आप्पुड वाड नाक शप्या, “फो नीन नीनु इंगोगो राष्ट्रतीकुड दुराम आम्पडीस्ताम.” ");
INSERT INTO wbq_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","इ वाक्य पर्यंत मंदी वांदी ऐकाशीर; मग वार किर्लुका आनीर, दुन्याम लोन्केल इन फेटा कानडा, इनदी जगाशेळदी लायकी लेद. ");
INSERT INTO wbq_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","वार किर्लुका इंगा स्वताय बेटूळी बटाल शरीर मिंदकेल तीशेशी मोळामला दुमू उडा मतुतांना. ");
INSERT INTO wbq_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","सरदार शिपाइलकी शपीर, पौलनी चाबूकता मतना, इ प्रकारता मंदी पौल उलटा येनटीक किर्लूतुणार इदी सरदार की यरका शेस्कोनेळदी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","इंगा वार वान वादयलता कटीर, आप्पुड देगार उंडीने शताधिपतीन पौल आन्या, “रोमन मंशीन इंगा यवान दोषी ठहरामता लेद यीलोन देबाल मतकाम कायदेशीर उंडाद येम?” ");
INSERT INTO wbq_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","इदी ऐकाशी शताधीपती सरदार देगार फोई आन्या, मनाम इदी येम सेस्तुनाम? आ मणशी रोमन उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","आप्पुड सरदार वान देगारा वची आन्या, “नाक शप, नु रोमन उंडाव येम?” वाड आन्या, “हाऊ.” ");
INSERT INTO wbq_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","सरदार उत्तर इच्या, “नीन इदी नागरिक पनदी हक्क संगेम दुडलु इच्ची कोणकोणडान.” पौल आन्या, “नीन तर फुटीने गालाने रोमन उंडान.” ");
INSERT INTO wbq_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","दिन मिंदकेल यवार वांदी चोकशी शेशेटोळ उंड्या वार लगाने वान देगार नुस येली फोया; शिवाय इड रोमन उंडाळ इल्ला सरदारकी तेलच्या आप्पुड वांकी पण येर्पू आय्या, येनटीक वाड वान कटीन्या. ");
INSERT INTO wbq_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","यहुदी मंदी वान मिंदा याद आरोप येकोचीर वाड येम उंडाड इदी खरेम तेल्वाला इल्ला सरदार मनला उंड्या, दांचांग इन्गोगा नाड वाड वान मोकळा शेश्या इंगा मुख्य याजक मंदी इंगा आंता न्याय सभा इरनी ओगातळा आय्येद हुकुम शेशी पौलनी किंदा ऐकोन वची वान मुंदार नीला फडामतीर. ");
INSERT INTO wbq_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","मग पौल न्याय सभातीकुड स्थिर दृष्टी शेशी आन्या, “बंधूजनलू, नीन इफोदपर्यंत द्यावार संगा पूर्ण सद्भावता वागास्का वचीनान.” ");
INSERT INTO wbq_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","आप्पुड महायाजक हनन्या इड वान देगार नीला फडीनोन्की वान मुतीक मतेद आज्ञा इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","आप्पुड पौल वान आन्या, “इ सुन्नाम आंचीनेय गोडाल, नीनु द्यावार मती; नु नियमशास्र लेका नाद न्याय शेशेदेंक कुसुन नेन्का नियमशास्र विरुद्ध नन्नु मतेद आज्ञा इस्ताव येम?” ");
INSERT INTO wbq_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","आप्पुड देगार नीला फडीनोर आनीर, “नु द्यावार महायाजकदी निंदा शेस्ताव येम?” ");
INSERT INTO wbq_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौल आन्या, “बंधूजनलू, इड महायाजक उंडाड इदी नाक यरका लेकुंड्या; येनटीक की नु नी अधिकारीला विरुद्ध खराब माटलाडाक इल्ला शास्रला लीवाशी उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","आप्पुड वार नडमा ओगा भाग सदुकी इंगा ओगा भाग परुशी उंडाद, इदी ओळखाशी पौल न्यायसभाला बेग्गे आन्या, “बंधूजनलू, नीन परुशी इंगा परुश्याल कोडकु उंडान; माद आशा इंगा सचीनोर्दी पुनरुत्थान इसंबंधता नाद चौकशी आतुनाद.” ");
INSERT INTO wbq_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","वाड इदी माटलाडतुन्या आपुडे परुशी इंगा सदुकी इरला जगडाम आंटी मंदीला फुट फड्या. ");
INSERT INTO wbq_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","येनटीक की पुनरुत्थान लेद इंगा द्यावार दूत इंगा आत्मापण लेद, इल्ला सदुकील आंटार; परुशील तर इ रोंडू माटलु मान्य शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","आप्पुड फेदाद गडबड आय्या; इंगा याद नियमशास्र शिक्षक, परूशील पक्षद उंड्या वार लोन्केल काईमंदी लेशी तणतण शेस्का आनीर, “इ मणशीला माक एमी खराब कम्पीयाद; जर आत्मा किंवा द्यावार दूत वार संगा माटलाडी निन्टे तर मग यला?” ");
INSERT INTO wbq_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","इल्ला वारला शेंगेम जगडाम आय्येतापुड; वार पौलनी शिंपेश्यार इल्ला येर्पू आय्यी शिपाईलाक हुकुम इच्चीर की, किंदा फोई वान वार लोन्केल इडपिची बंडीला एका दांडा. ");
INSERT INTO wbq_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","आबदे मबुला प्रभूड वान मुंदार नीला फडी आन्या, “दम फट; यला नु यरुशलेम शहरला ना विषयला साक्ष इस्ती आले रोम शहरला पण निक इया बेक आय्यी.” ");
INSERT INTO wbq_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","मग फदू फुटीनेन्का, यंता तरी यहुदयाल ओगातळा आय्यी वटू तीस्केन आनीर, पौलदी जेम तीस्कुनी नंताक मिम तिनाक तागाक फोयाम. ");
INSERT INTO wbq_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","इदी कट रचाशेतोर मन्सूल चाळीस कना जास्त उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","वार मुख्य याजक मंदी इंगा आब्बागार इरतीकुड वची आनीर, “पौलदी जेम तीस्कुनी नंताक मिम अन्नामकी धक्का आंचा फोयाम, इल्ला कडकडीत वट्टूता मिम मोमलान बद्ध शेशीगास तीस्कुन्नार. ");
INSERT INTO wbq_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","तर इपुड वान विषयला इंगा रवा बारकाइता विचारपूस शेशेद उंडाद, इ निमित्तता वान मना तीकुड एकादावाला इल्ला मीर न्याय सभाला पण सरदारकी समजामताला; आंटे वाड देगार वस्ताड न वस्ताड आपुडे वांदी जेम तीस्कोनदेंक मिम तयार उंडाम.” ");
INSERT INTO wbq_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","आप्पुड वारमिन्दा लक्ष फेटका कुशीननोड पौल शेल्याल कोडकु ऐकाश्या इंगा गढला फोई वाड पौलकी शप्या. ");
INSERT INTO wbq_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","आप्पुड पौल ओगा शताधीपतीन कुतेशी आन्या, इ मोग्बीडान सरदार तीकुड एका फो, इनकी वांकी येम तरी शपेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","आप्पुड वाड वान सरदारतीकुड एका फोई आन्या, बंदीवान पौल इड नन्नु कुतेशी विनंती शेश्या की, इ मोग्बीडान नीतीकुड एका फोवाला, वानकी नि संगा माटलाडेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","आप्पुड सरदार वांदी शेई फटी वान ओगा बाजूक एका फोई आडग्या, “निक येम शपेद उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","वाड आन्या, “यहुदयाल इल्ला एकी शेशिनार की, पौल विषयला इंगा रवा बारकाईता विचारपूस शेशे निमितता वान किंदा सभाइचांग एका दावाला, इल्ला निक विनंती शेयाला. ");
INSERT INTO wbq_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","तर नु वार्दी इना राद; येनटीक की वारपैकी चाळीस कना जास्त मन्सूल वान इचांग कन्नू फेटकेण कुशिंडार; वार वटू येस्कुन्नार की, वान जेमता मती नंताक मनाम तीना तागा राद; इंगा इपुड वार तयार आयी नी संमतिद दावा सुस्तुनार.” ");
INSERT INTO wbq_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","इपुड, “नु इदी नाक शपीनाव इदी यवार्की शपाक, इल्ला आ मोग्बीडाक बारकाईता शपी सरदार वांकी निरोप इच्या.” ");
INSERT INTO wbq_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","मग वाड रोंड शताधिपतीलनी कुतेशी शप्या, “कैसरीयाक फोयेदेंक दोनशे शिपाइल, सत्तर घोडेस्वार इंगा दोनशे भालेकरलू निम्मा मबुला तयार फेटना.” ");
INSERT INTO wbq_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","इंगा गुर्राम तयार फेटना, दान मिंदा पौलनी कुसना मती फेलिक्स सुभेदार तीकुड संभाळीची एका फोंडा. ");
INSERT INTO wbq_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","अन वाड इल्ला मजकूरदी पत्र लीवाश्या. ");
INSERT INTO wbq_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“महाराज फेलिक्स इनकी सुभेदार क्लौद्य लुसिया इनदी सलाम. ");
INSERT INTO wbq_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","इ मंशीन यहुदयाल फटीनीर इंगा वार तीकेल वाड सस्तुन्या, इंताळला इड रोमी उंडाड इल्ला तेलची नेन्का नीन शिपाइल तीस्कोनी वान इडपिस्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","इंगा इन मिंदा आरोप आनचेद येम कारण उंड्या इदी समजाशी तीस्कुणे इच्छाता वार न्याय सभाला किंदीक एका फोतीन. ");
INSERT INTO wbq_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","आप्पुड वार नियमशास्रलोन जगडाम माटला संबंधला वान मिंदा यादो दोष आन्चीनीर, पण सचेद किंवा बंधनदी शिक्षा इच्चे लेका आरोप वान मिंदा लेकुंड्या, इल्ला नाक कमपीच्या. ");
INSERT INTO wbq_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","इ मणशी उलटा कट आय्येद उंडाद इल्ला नाक बातमी शिक्कीन नगरेमे नीन वान मी तीकुड आम्पडीचीनान, दोष आन्चेतोरकी पण नीमुंदार नीला फडला आंका शपिनान, सुखरूप उंडाला.” ");
INSERT INTO wbq_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","शिपाइल हुकुमलेका पौलनि मबुला अंतीपत्रीसकी शहर एका फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","इंगा दुसरा नाळ वान संगा फोयेदेंक घोडस्वारलान फेटी वार गढलोंग वापस वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","कैसरीयाक फोईनेन्का घोडेस्वारलु सुभेदारकी फेलिक्स पत्र इच्चीर पौलनी वान मुंदार नीला फडा मतीर. ");
INSERT INTO wbq_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","पत्र वाचाशी वाड आडग्या, इड या प्रांतटोड उंडाड; वाड किलकीयाटोड उंडाड तेलचीनेन्का, ");
INSERT INTO wbq_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","वाड आन्या, “निक दोष आन्चेतोर वच्चीर आंटे नीन नीद आनकाम ऐकाश्यान.” इंगा 'इन हेरोद राजवाडाला फेटाला' इल्ला वाड हुकुम इडश्या. ");
INSERT INTO wbq_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","आय्यीद नाळा बाद महायाजक हनन्या, काही आब्बागार इंगा तीर्तुल्ल फेरोन यादो तरी ओगा वकील इर किंदेक वचीर; इंगा वार सुभेदार मुंदार पौल विरुद्ध दोष आन्चीर. ");
INSERT INTO wbq_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","यपुड पौल शासकमुंदार नीला फड्या आप्पुड तीर्तुल्ल वान मिंदा दोष आंची आन्या, “फेलिक्स महाराज, मी इचांग माक संगेम शांती शिकीनाद इंगा मी दूरदृष्टी इचांग इ राष्ट्रला सुधारणा आतुनाद. ");
INSERT INTO wbq_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","दांचांग वारदी मिम पूर्ण कृत्यज्ञतागोन, आंता प्रकारता इंगा आन्नी तीकुड स्वागत शेस्ताम. ");
INSERT INTO wbq_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","तरी नीद जास्त टाईम तीस्कुणान्दे विनंती शेस्तान की, मेहरबानी शेशी माद रवासा इनाला. ");
INSERT INTO wbq_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","इ मणशी म्हणजे ओगाट पिडा उंडाद इल्ला माक आढळाशी वच्या इंगा जगलोन आंदार यहुदी मंदीला इड बंड लेपेतोड उंडी नासोरी पंथोड पुढारी उंडाड. ");
INSERT INTO wbq_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","इड परमेश्वरदी भवनपण अपवित्र शेशेद प्रयत्न शेश्या; वान मिम फटतीम; इंगा मा नियमशास्रलेका इनदी न्याय शेशेदेंक मिम सूदुम. ");
INSERT INTO wbq_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पण लुसिया सरदार वची संगेम जबरदस्तीता इन मा शेतलोन्केल तिशी एका फोया. ");
INSERT INTO wbq_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","इंगा दिंदी चौकशी मीर शेश्यार तर या माटलाय दोषलु मिम वान मिंदा शेस्ताम आ आन्नी विषयला वान तीकेले मिक समजासी.” ");
INSERT INTO wbq_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","आप्पुड इ आन्नी माटलु इल्ले उंडाय, इल्ला आनिगास दुसरा यहुदील पण जोर इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","मग सुबेदार माटलार देंक खूनवाशीनेन्का पौल उत्तर इच्या, “नु संगेम वर्षकेल इ मंदी न्यायाधीश उंडाव इदी नाक यरका उंडाद, दांचांग नीन नि माटलाद संतोषता समर्थन शेस्तान. ");
INSERT INTO wbq_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","निक पुर्णपणे तेलची की, नाक यरुशलेम शहरला उपासना शेशेदेंक फोई इंगाना बारा पेक्षा जास्त दिवसलू कालेव. ");
INSERT INTO wbq_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","इंगा परमेश्वर भवनला, सभास्थान किंवा नगरला यवार संगा जगडाम शेस्तांना किंवा मंदीन भडका मतेतापुड नीन वारकी कम्पियाल्या. ");
INSERT INTO wbq_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","या माटलाद दोष वार ना मिंदा इपुड शेस्तुणार, आय माटलु वारकी नी मुंदार साबित शैया दाद. ");
INSERT INTO wbq_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","तरी नीन मी देगारा इंता कबूल शेस्तान की, या दावान वार पाखंड आंटार आ दावालेका येम-येम नियमशास्रलेका उंडाद इंगा या-या संदेष्ट्याल लेखला उंडाद आ आंदार मिंदा विश्वास फेटी नीन पुर्वजला द्यावारदी नीन सेवा शेस्तान. ");
INSERT INTO wbq_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","इंगा नीतीमानलाद अन अनीतिमानलाद पुनरुत्थान आयी, इल्ला याद आशा फेटतार आद्दे आशा नीन द्यावार तीकुड सुशी फेटतान. ");
INSERT INTO wbq_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","दिनकस्रोम द्यावार संबंधता इंगा मणशीसंबंधता नाद विवेकभाव नेहमी शुद्ध राखाशेद नीन प्रयत्न शेस्तान. ");
INSERT INTO wbq_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","नीन संगेम वर्षबाद मना मंदीक दानधर्म शेशेदेंक इंगा यज्ञार्पणे वहायदेंक वस्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","शुद्धीकरन विधीला नीन व्रतस्थ इल्ला परमेश्वर भवनला कम्पीस्तीन, ना संगा मंदिद घोळका लेकुंड्या किंवा दंगा का कुंड्या; पण इंदू आशिया प्रांतलोंटोर यंतातरी मंदी यहुदी उंडीर. ");
INSERT INTO wbq_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","वारदी ना उलटा येमी उंटे तर वार मना मुंदार वची ना मिंदा दोष आंचेद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","किंवा नीन न्यायसभा मुंदार नीला फडनेन्का नाद याद गुन्हा इरकी कमशा आदी इर तरी शपाला; ");
INSERT INTO wbq_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","इर नडमा नीला फडी, सचीनोर पुनरुत्थान विषयला नाद न्याय इबद मी मुंदार आतुनाद, इ शब्दल नीन बेग्गे आंटीन, इदी इंता फेद्दाद गुन्हा उंटे तर उंडी.” ");
INSERT INTO wbq_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलीक्सकी आ दावाद संगेम माहिती लेकुंड्या दानीचांग वाड खटला तहकूब शेशी आन्या, “लुसियाटोड सरदार वची आप्पुड मी प्रकरणदी निकाल शेशी.” ");
INSERT INTO wbq_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","इंगा वाड शताधीपतीक हुकुम इच्या की, इन पहाराला फेटाला; तरी इनकी मोकळीकता उंडाला इंगा इन स्वकीयालकी इनदी सेवा शेशेदेंक मनाई लेवाराद. ");
INSERT INTO wbq_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","मग काही नाळ बाद फेलिक्स स्वता यहुदी वडती द्रुसिल्ला दिन संगा वच्या इंगा वाड पौलनि कुतेशी ख्रिस्त येशुन मिंदुड विश्वास विषयला वान देगाटेल ऐकाशी तीस्कोन्या. ");
INSERT INTO wbq_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","आप्पुड नितीमत्व, इंद्रियदमन इंगा मुंदार आय्येद न्याय इ विषयला वाड भाषण शेस्तापूड, फेलिक्स आद्री आन्या, “इपुड फो, संधी शिक्या आंटे नीनु कुतेश्यान.” ");
INSERT INTO wbq_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","इंगा नाक पौल तीकेल दुडलु शिकी इल्ला आशापण वांकी उंड्या, दांचांग वाड वान डबल-डबल कुतेशी तीस्कुनी वान संगा माटलाडदू. ");
INSERT INTO wbq_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","मुंदारकी रोंड वर्षला बाद फेलिक्स जागामिंदा पुर्क्य फेस्त इड वच्या; आप्पुड यहुदयाल्दी मर्जी संपादन शेशे इच्छाता फेलिक्स पौलनी कैदलाने फेट्टी फोया. ");
INSERT INTO wbq_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","मग फेस्त सुभ्यांत वचीनेन्का मूड नाळा बाद कैसरीयाकेल मिंदीक यरुशलेम शहरकी फोया. ");
INSERT INTO wbq_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","आप्पुड मुख्य याजक इंगा यहुदीलोन्केल मुख्य मन्सूल इर वान तीकुड पौल विरुद्ध फिर्याद एका फोईर. ");
INSERT INTO wbq_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","इंगा, कृपाशेशी वान यरुशलेम शहरला कुतेस कोणाला इल्ला वान तीकुड विनंती शेशीर; दावाला दबा फटकोन वान मतेद इर्दी बेत उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तद उत्तर, “पौल कैसरीयाला कैदला उंडाड; नीन स्वता लगाने आकाड फोयेतोड उंडान. ");
INSERT INTO wbq_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","दांचांग आ मंशीद येमाना गुन्हा उंटे मीलोन्केल प्रमुखलु नासंगा वची वान मिंदा आरोप फेटाला.” ");
INSERT INTO wbq_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","मग वार नडमा आठदहा दिवस नीलची कैसरीयाक किंदीक फोया इंगा दुसरानाड न्यायासनमिंदा कुशिनेन्का वाड पौलनी येकोचेद हुकुम इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","वाड वचीनेन्का यहुदील वानभोवती नीला फडी यवार्दी पुरावा वारकी इया दाल्या इल्ला संगेम इंगा भयानक आरोप वान मिंदा फेटीर. ");
INSERT INTO wbq_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पौल उत्तर इच्या की, “नीन यहुदीला नियमशास्रद, परमेश्वर भवनदी किंवा कैसरीयाद येमीच गुन्हा शेया लेद.” ");
INSERT INTO wbq_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","आप्पुड यहुदयाल मर्जी संपादन शेशे इच्छाता फेस्त पौलनी आन्या, “यरुशलेम शहरला फोई आंदू नामुंदार इ माटला विषयला नीद न्याय कावाला इल्ला नीद इच्छा उंडाद येम?” ");
INSERT INTO wbq_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","आप्पुड पौल आन्या, “कैसरीया न्यायासन देगार नीन नीला फडीनान; इंदे नाद न्याय कावा बेक, नीन यहुदयाल्दी येमी गुन्हा शेयालेन, इदी मिक पण शिंगारे यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","नीन गुन्हा शेस्तीन किंवा सच्चे इचांग योग्य इल्ला येमाना शेशीनिन्टे तर नीन तयार लेन इल्ला लेद ; पण वार ना मिंदा याद आरोप फेटीनार दानलोंदी ओगाट पण खरेम ठराया कुंटे, तर नन्नु वार स्वाधीन शेशेद यवारकी पण अधिकार लेद; नीन कैसर देगार न्याय आडगुतान.” ");
INSERT INTO wbq_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","आप्पुड फेस्त सभाद मसलत तीस्कोनी उत्तर इच्या, “नु कैसरदेगारा न्याय आडगीनाव तर कैसर मुंदारकी फोयाव.” ");
INSERT INTO wbq_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","मग काही दिवसलू आय्यी नेन्का अग्रीप्पा राजा इंगा बर्णिका इर इद्दार कैसरीयाक वची फेस्तकी भेटाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","आंदू वार संगेम दिवसलू नीलचीर, आप्पुड फेस्त राजा मुंदार पौलदी प्रकरण तिशी आन्या, “फेलिक्स बंदीला फेटीनोड ओगा मणशी इंदू उंडाड. ");
INSERT INTO wbq_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","नीन यरुशलेम शहरकी फोइन्टीन आप्पुड यहुदीला मुख्य याजकलु इंगा आब्बागार फिर्याद शेशी वान विरुद्ध ठराव कावाला दांचांग विनंती शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","वारकी नीन उत्तर इस्तीन की, आरोपी इंगा दोष आन्चेतोर इर मुंदारमुंदार वची आरोपी विषयला स्वताद उत्तर इचेद आरोपीक संधी शिक्काकाना मुंची यवारकी पण शिक्षाइचांग सोपाशी इचेद रोमी मंदिद रित लेद.” ");
INSERT INTO wbq_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","दांचांग वार इंदूक वचीनेन्का एमी दावा सुडांदे, दुसरा नाळ न्यायासन मिंदा कुसनी आ मंशीन येकोचेद हुकुम शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","वान मिंदा आरोप शेशेतोर यपुड वान विरुद्ध माटलाडदेंक नीला फडीर, आप्पुड ना अपेक्षा लेका येमटी पण गुन्हाल बद्दल वार वान मिंदा आरोप शेया लेर. ");
INSERT INTO wbq_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","उलटा मना धर्मविषयला इंगा यादो ओगा मणशीविषयला यवांदी फेर येशु उंडाद, वान मिंदकेल यहुदी मंदी आ मणशी संगा जगडाम आडीर, येशुड इड जरी सचीनोड उंड्या, तरी पौलदी इल्ला आनकाम उंडाद की, येशुड जिवंत उंडाड. ");
INSERT INTO wbq_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","इ प्रश्नद चौकशी येला शेयाला इदी नाक समजाकुंदू, आप्पुड इ यहुदी मनुष्य विरुद्ध यहुदी मंदी याय आरोपलु उंडाय, दान बद्दल वान यरुशलेम शहरकी एका फोई वांदी न्याय शेयाला इल्ला वांदी इच्छा उंडाद येम, इल्ला नीन वान आडगुतीन. ");
INSERT INTO wbq_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","सम्राटतीकेल मनाद न्यायनिवाडा आय्यी नंताक नीन कैदला उंटान इल्ला यपुड पौल आन्या, आप्पुड नीन आज्ञा शेस्तीन की, कैसरतीकुड आम्पेदेंक शक्य आयी नंताक वान जेलला फेटाला. ");
INSERT INTO wbq_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","दिनमिंदा अग्रीप्पा फेस्तन आन्या, “नाक स्वताक इ मंशीद आनकाम इना बुदी आताद,” फेस्त वांकी उत्तर इच्या, “रेपकाडा,” वांदी आनकाम “मीर इनी शकाश्यार.” ");
INSERT INTO wbq_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","दांचांग दुसरानाळ अग्रीप्पा इंगा बर्णिका फेदा थाटमाटता वचीर इंगा लष्करी सरदार इंगा शहरलोन्टोर मुख्य नागरिकला संगा दरबारला प्रवेश शेशीर, आप्पुड फेस्त आज्ञालेका पौलनी आंदूक ऐकोन वचीर. ");
INSERT INTO wbq_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","मग फेस्त आन्या, “राजा अग्रीप्पा महाराज इंगा मा संगा इंदू उपस्थित उंडीनोर आंदार मंदी, इ मंशीन सूडना! वान विषयला यरुशलेम इंगा कैसरीया इंदूटोर आंदार यहुदी मंदी नातीकुड अर्ज इच्चीनार, इन जिवंत उंडानिया राद, इल्ला विनंती वार शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पण इनकी सचेद शिक्षा इयाला इल्ला इड एमी शेया लेद, इल्ला नाक आढळाशी वच्या इंगा वाड स्वताने नाक सम्राट तीकेल न्याय शिकाला इल्ला मागणी शेश्या, दांचांग नीन वान कैसरमुंदार न्याय इचांग आम्पेद ठरा मतीनान. ");
INSERT INTO wbq_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","पण सम्राटकी इन विषयला नक्की इल्ला यरका शेय्याला, इल्ला ना तीकुड एमी लेद, दांचांग नीन इन मी मुंदार इंगा विशेषतः राजा अग्रीप्पानमुंदार ऐकोनवची नीला फडा मतीनान, आदी दिनकस्रोम की, इ चौकशी नंतर नाक इ मणशीविषयला येमतरी लिवादेंक दाला. ");
INSERT INTO wbq_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","आखरीक ओगाट आर्दाम कैदीक यादू आरोप फेटान्दे कैसर तीकुड आंपडीचकाम नाक बरोबर वाटायाद.” ");
INSERT INTO wbq_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्रीप्पा पौलनी आन्या, “निक नीद बाजू मांडाशेळदी परवानगी उंडाद.” दिन मिंदा पौल स्वताद शेई मिन्दिक शेशी स्वता न वाचय मतेद भाषण सुरु शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","अग्रीप्पा महाराज, नीन स्व्तान धन्य स्म्जास्तान येनटीक की यहुदील मी मुंदार ना उलटा शेशीने आरोपलाद बचाव शेशेळदी संधी इफोद नाक शिक्या. ");
INSERT INTO wbq_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","विशेषता, यहुदी रिती रीवाज इंगा प्रश्न संगेम माटलाद मनाक शिंगार प्रकारता यरकाउंडाद तर इदी जास्तने खरेम आणाला, आप्पुड मीर नाय माटलु धीरता ऐकाशी तीस्कोनाला इल्ला नीन विंनती शेस्तान. ");
INSERT INTO wbq_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","नीन नाद जीवन जवानीकेल ना प्रांतला इंगा यरुशलेम शहरला या रीतीता जगादून इदी आंता यहुदी मंदीक शिंगारे यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","वार नन्नु संगेम काळकेल ओळखास्तार इंगा वारदी इच्छा उंटे तर नीन वगा परुशी म्हणजे मा यहुदी धर्मटोळ वगा कट्टर गटटोळ सभासद इ नाताता यला जगास्का वस्तीन इविषयला वार साक्ष इचू शकाश्यार. ");
INSERT INTO wbq_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","इपुड परमेश्वर मा पूर्वजलाक याद वचन इच्या दांदी आशा फटीने इचांग नाद न्याय आदेंक नीन नीला फडीनान; ");
INSERT INTO wbq_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","आयी वचनलु शिकीदेंक आशा फेटी मा बारा वंशळ परमेश्वरदी सेवा मबुदिवस एकाग्रताता शेस्तुनान, महाराज, आद्दे आशा फटीने इचांग ना मिंदा यहुदील आरोप फेटीनार. ");
INSERT INTO wbq_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","परमेश्वर सचीनोरनी इंगा लेफिस्ताड, इल्ला मी पैकी यंता जनकी विश्वास फेटीदेंक अयोग्य येनटीक वाटाला. ");
INSERT INTO wbq_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","नासरथ येशुन फेरउलटा येम-येम शेया वची आदी-आदी नीन शेयाला इल्ला नाकपण वाटादू. ");
INSERT INTO wbq_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","इंगा नक्की इदे नीन यरुशलेम शहरला शेस्तिम, येनटीक की मुख्य याजकला तीकेल नाक आला अधिकार शिकीन्या, दांचांग नीन द्यावार संगेम संतलान जेलला येस्तीन इंगा इदी संतजनलान जेमता म्तेस फारशीर, वार उलटा नीन नाद मत नोंदा मतुतीन. ");
INSERT INTO wbq_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","संगेम सभास्थानला नीन वारकी शिक्षा शेस्तीन इंगा द्यावार उलटा जबरद्स्तीता खराब भाषण शेशेदेंक आंचेळदी नीन प्रयत्न शेस्तीन, इ मंदी मिंदूळदी नाद कोफाम इंता मींदीक फोइन्या आंका की, नीन वारदी छळ शेशेदेंक इंगोगो शहरला पण फोदुन. ");
INSERT INTO wbq_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","वगा दिमिष्क शहरला फोयेदेंक मुख्य याजकलु नाक अधिकार इंगा परवानगी इच्चीर आप्पुड महाराज. ");
INSERT INTO wbq_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","दावाला भर मध्याम वेळला नीन ना इंगा नादेगार उंडीने भोवती स्वर्गीय यलगु फाकास्नेद सुस्तीन, आदी यलगु सूर्यपेक्ष पण जास्त प्रखर उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","मिम आंदार किंदा भुमी मिंदा फडतीम इंगा इब्री भाषाला ना संगा माटलाळतांना ओकाट आवाज नीन ऐकास्तीन, आदी आवाज आन्या, “शौल, शौल, नाद छळ नु येनटीक शेस्ताव? अणकुचीदार कट्या मिंदा तनकाम निक हानिकारक उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","इंगा नीन आंटीन, 'प्रभू, नु यवार उंडाव?' प्रभूड उत्तर इच्या, “नीन येशुड का, यवांदी नु छळ शेस्तुनाव. ");
INSERT INTO wbq_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","इपुड लेय इंगा नीला फड! इ कारण इचांग नीन निक दर्शन इचीनान नीनु सेवक आंका नेमाला इंगा येम पण निक सुपिस्तीन इंगा येम सुपिच्यान दान साक्षीदार आंका नीनु नेमाला. ");
INSERT INTO wbq_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","इ मंदीकेल इंगा इंगोगाराष्ट्रटोर इचांग नीन नीद रक्षण शेश्यान. ");
INSERT INTO wbq_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","नीन नीनु वार तीकुड आंपडीस्तान, दिनकस्रोम की, वार मबूलोन्केल येली मंचीतीकुड इंगा शैतान अधिकारता परमेश्वर अधिकार तीकुड तीर्गाला, दांचांग नु वारी कनलू उघडामताला इंगा वारकी पापलाद क्षमा काला इंगा ना मिंदूळदी विश्वासता पवित्र आयीने मंदीला वतन शिकाला.” ");
INSERT INTO wbq_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","दिनकस्रोम, अग्रीप्पा महाराज नाक जो स्वर्गदी दृष्टांत आय्या, दांदी नीन आज्ञाभंग शेयालेन. ");
INSERT INTO wbq_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","उलटा पहला तीकुल दिमिष्कलोनटोर इंगा नंतर यरुशलेम शहरलोन, यहुदिया प्रांतलोंटोर आंदार इंगा इंगोगो राष्ट्रटोर मंदीकपण प्रभून वचनदी साक्ष इच्या, वार पश्चात्ताप शेयाला, परमेश्वर तीकुड तीर्गाला इंगा पश्चात्ताप शोभाशी इल्ला फनील शेयाला इल्ला नीन वारकी शप्तीन. ");
INSERT INTO wbq_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","इ कारण इचांग नीन परमेश्वर भवनला उंडतांना काही यहुदी मंदी नन्नु फटीर इंगा जेमता मतेळदी प्रयत्न शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पण परमेश्वर नाक मदत शेश्या दांचांग नीन इंदू नीला फडी समाजलोन्टोर शिनावरकी साक्ष इस्तुनान, येम पण मुंदारकी आयेळदी उंड्या, दान विषयला संदेष्ट्याल इंगा मोशेळ येम शप्या दानपेक्षा दुसराद नीन शपान. ");
INSERT INTO wbq_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","दान लेका परमेश्वर अभिषिक्त जो ख्रिस्त वाड दुःखसहन शेशी इंगा सचीनेन्का लेपेळला वाड पहिला उंडी, यहुदी मंदीक आले यहूदी लेनोर्क पण परमेश्वर प्रकाशाद घोषणा शेशी. ");
INSERT INTO wbq_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","पौल स्वतान वाचामतेळ संबंधला माटलाळतांना फेस्त वान बेग्याता आन्या, “पौल, निक तिका फटीनाद, जास्त ज्ञानइचांग निक तिका फटीनाद.” ");
INSERT INTO wbq_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पौल उत्तर इच्या, “फेस्त महाराज, नाक तिका फटालेद; तर याय माटलु खरेम उंडाय इंगा संगेम बरोबर उंडाय, आटलाविषयलाने नीन माटलाळतुनान. ");
INSERT INTO wbq_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","यंदू हजर उंडीने महाराजलाक इविषयला शिंगार माहिती उंडाद इंगा दिनकस्रोम नीन वार संगा मोकळापणता माटलाळू शकास्तान, वान ध्यान लोन्केल येमी इळा लेकुंटे, इल्ला नाक खात्रीता वाटास्ताद, नीन इदी आंटान, येनटीक की इदी माटा यादाना कोपऱ्याला कालेद. ");
INSERT INTO wbq_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","अग्रीप्पा महाराज, संदेष्ट्याल याद लीवाशीर दान मिंदा मिद विश्वास उंडाद येम? मिद दानमिंदा विश्वास उंडाद.” इदी नाक नक्की यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","दिनमिंदा अग्रीप्पा आन्या, “इंता कमी वेळला ख्रिस्ती आदेंक नु नाद मन तीपु शकाश्याव इल्ला निक वाटास्ताद येम?” ");
INSERT INTO wbq_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौल उत्तर इच्या, “रवा वेळला आंडा किबा जास्त वेळला आंडा, नीन यला उंडान आले फक्त मिरे लेदतर इफोद यवार-यवार इंदू कुसनी नाय माटलु ऐकास्तुनार वार आंदार नालेका इ साकळीशिक्षालेका, विश्वास फेटेटोर काला, इल्ला नाद परमेश्वरकी नम्र विनंती उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","दिन नंतर राजा, बर्णिका, राज्यपाल इंगा वार संगा इंगोगोर यवार कुशिंडीर, वार आंदार लेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","वार न्यायालयकेल बेटीक फडीनेन्का एकमेकोरणी माटलाळदूर, वार आनीर, “येमटी इचांग तुरुंगवास किंवा सचेळदी शिक्षा इयाला इल्ला येमीच इ मणशी शेया लेळ.” ");
INSERT INTO wbq_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रीप्पा फेस्तनि आन्या, “इ मणशी कैसरतीकुड न्याय आळगा लेकुंटे, तर वान इळा वस्तुन्या.” ");
INSERT INTO wbq_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","यपुड मिम समुद्रदावाता इटलीक फोयेळदी ठहरामत्या आप्पुड पौल इंगा इंगोगो काही कैदील युल्य फेरटोळ शताधीपतीन शेईला सोपवाशीर, युल्य इड अगस्तस सेनाटोळ वगा अधिकारी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","अद्र्मूत्तीय इंदूळ वगा जहाजकेल मिम फोयेटोर उंटीम, इदी जहाज आशिया काटमिंदूळी बंदरलु तीस्कोनी मुंदार फोतुन्या, मिम इ जहाजकेल प्रवासला येलतीम, आप्पुड मासेदोनियालोन थेस्सलनिका इंदू नीलचेटोळ अरीस्तार्ख मासंगा उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","उन्गो नाळ मिम सिदोन नगरकी पोहोचास्तिम, युल्य पौलसंगा संगेम शिंगार वागाश्या, पौल मित्रलकी वांदी काळजी तीस्कोना दाला आंका वाड मोकळीकता इच्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","आंदकेल मिम समुद्रदावाता मुंदारकी येलतीम इंगा कुप्र कंटाम कंटामता येलतीम येनटीक की घाली मा तीकेड उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","किलीकीया इंगा पंफुलीया प्रांतदेगारदी समुद्र पार शेशी लुक्य प्रांतलोन मुर्या बंदरला पोहोचास्तीम. ");
INSERT INTO wbq_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","आंदू शताधीपतिक इटलीक फोयेटोर आलेक्सांद्रदी ओकाट जहाज आढळाश्या, वाड ममलान आ जहाजला कुसना मत्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","मिम संगेम दिवस मेलामेलांग प्रवास शेयदुम, कनिदा शहरपर्यंत वदेंक माक संगेम कष्ट फड्या येनटीक की घाली मुतीतीकेल उंड्या, माक मुंदार फोवा ये दाणकदाका फो, दांचांग मिम क्रेत दक्षिण तीकेल सलमोन शहर मुंदार बाजूक फोतीम. ");
INSERT INTO wbq_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","दिन मुंदार माद जहाज क्रेत बेट काटता फेदा अडचणला सुरक्षित बंदर इंदू पोहोचाशीर, आंदू देगारे लसया नगर उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","संगेम वेळ वाया फोइन्या इंगा मुंदारदी प्रवास शेशेदेंक संगेम कठीण आयीन्या, येनटीक की येव्हान यहुदीला उपासाद काळ पण येली फोइन्या, आप्पुड पौल वारणी सावधानदी इशारा इच्चीन्या, पौल आन्या, ");
INSERT INTO wbq_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“मोगुरळू, नाक वाटास्ताद, मना प्रवासला जहाजलोन मालनी इंगा जहाजकीने लेद तर मना जेमुकपण धोका उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पण पौल मतसंगा जहाजदी कप्तान इंगा मालक सहमत कालेर, उलटा जहाज कप्तान इंगा मालक माटला मिंदाने शताधीपतीद जास्त विश्वास उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","पण इदी सुरक्षित आनीनेद बंदर सलीकालाम मुक्काम शेशेदेंक सोईद लेकुंड्या, दांचांग संगेममतलाता येलाला इल्ला ठहराश्या इंगा फेनिककी फोयेळदी प्रयत्न शेयाला इंगा शक्य आते तर आंदे सलीकालाम तीयाला इल्ला ठहराश्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","आप्पुड दक्षिणतीकेल मंद घालील फारतुनाय, आप्पुड वार नागर येती क्रेत कंटाम कंटामक तारू हाकादेंक फोयेदेंक आंटीर, जहाज मिन्दुळ मंदीक वाटादू की, इलोळ प्रकारता घाली माक बेकस उंड्या इंगा आले फारतूनाद. ");
INSERT INTO wbq_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पण लगाने क्रेत बेटकेल 'ईश्यान्यद' आनिनेद वादळी ला घाली फारतुनाद. ");
INSERT INTO wbq_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","इंगा जहाज वादळी शिक्या इंगा दानक मुदरा फेयादांक दाकुंड इंगा मुदारा फेयेद यीडशी घालीता जहाज भरकटून फोतिम. ");
INSERT INTO wbq_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","मग कौदा फेरूद शिना बेट कंटाम कंटामक मिम फोयेदेंक मिम फोतुनाम, इंगा रवा खटपटीनंतर जीवन रक्षक होडी मिंदा येतकोन तीस्कोन्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","जीवन रक्षक होडी नोनिक तीस्कूनेन्का मंदी जहाज दारामखंडता आव्राशी कटीर, जहाज रेती उंडीने सुर्ती फेरूद उथळ जागाला आदळाशी इ बिताता वार शीड किंदा तीशीर, आप्पुड घालिता आदी भरकुटादेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","संगेम वादळी घालीय तडाखाल तिनाबेक आयीने इचांग मंदी उन्गो नाळ जहाज मिन्दुळदी सामान बेटीक येशेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","तिसरा नाळ जहाजदी काही समान वार स्वता शेईता बेटीक तीशेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","संगेम दिवस माक सूर्य इंगा अ चंद्र काम्पीयालेव, वादळ संगेमे भयंकर इल्ला माक वाटादू. ");
INSERT INTO wbq_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","संगेम काळपर्यंत मंदीक उपवास घडाशी नेन्का, इंगा पौल वान मुंदार नीला फड्या इंगा आन्या, “नीलचेटोर, क्रेतमिंदकेल मुक्काम हालामता कुंडा, इदी नाद सल्ला मीर ऐकादेंक बेकस उंड्या, आंटे इदी त्रास इंगा इदी नुकसान टाळास वस्तुन्या.” ");
INSERT INTO wbq_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","गान इपुड मीर धीर फटाला इल्ला नाद विनंती उंडाद, येनटीक की मीपैकी ओकोनपण जेमुक धोका पोहोचाखोई, मनाद जहाज फक्त गमवाबेक आयी. ");
INSERT INTO wbq_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","नीन या परमेश्वर सेवक उंडान इंगा यवांदी उपासना नीन शेस्तान, वान दूत नीना ना बाजूक नीला फड्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","इंगा वाड दूत आन्या, “पौल आद्राक! निक कैसरमुंदार नीला फडाने बेक, नि संगा प्रवास शेशेटोर आंदार मंदी परमेश्वर वान दयाता निक इच्चीनाड. ");
INSERT INTO wbq_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","आप्पुड नीलचेटोर, मीर आंदार धीर फटना! येनटीक की नाक यला परमेश्वर शप्या, अगदी आले आयी इल्ला नाक विश्वास उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","पण मनाक यादाना बेटमिंदा दिगी थांबाबेक आयी.” ");
INSERT INTO wbq_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","चौदावा मबुला माद जहाज अद्रिया समुद्रकेल फोदू, आप्पुड खलाशेर जहाज यादाना भुमी मिंदा पोहोचाशीर इल्ला अंदाज शेशीर. ");
INSERT INTO wbq_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","वार न्यळाद लोत मोजाशीर आप्पुड आदी चाळीस मिटर निंड्या, इंगा काही वेळता वार इंगा ओकादम समुद्रद लोत मोजाशीर आप्पुड आदी तीस मीटर निंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ओबडधोबड खडक जागा मिंदा म्नाद जहाज आदळाशी इल्ला बीता आंट्या तर वार नालुंग नांगरलु जहाज यंकाळ बाजूक येशीर इंगा फदू फुटेळदी प्रार्थना शेस्का दावा सूळदूर. ");
INSERT INTO wbq_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","खलाशील जहाजलोन्केल ईळेळदी प्रयत्न शेशीर, वार जहाजमुंदार भागकेल नांगर येशिनेद भास आयी जीवन रक्षक होडील समुद्रला येशीर. ");
INSERT INTO wbq_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","पण पौल शताधीपतीक इंगा इंगोगो शिपाईलान आन्या, “जर इ मंदी जहाजला निलार, तर मीर वाचायार.” ");
INSERT INTO wbq_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","दिन मिंदा शिपाइल जीवन रक्षक होडीदाय दारामलु कोशेशीर इंगा आयी किंदा न्यळाला फडा निचिर. ");
INSERT INTO wbq_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","फदु फुटेळ पहिला पौल वार आंदारकी येम तरी तीणेलदी आग्रह शेश्या, वाड आन्या, “इफोद चौदावा दिवस उंडाद, मीर आतुरतागोन दावा सुस्तुणार पण तीनातागालेर, अन्नामदी कणपण तिनालेर. ");
INSERT INTO wbq_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","मीर रवा तरी तिंडा, येनटिकीमीर वाचायाला आंटीदेंक मीद तिनकाम फनीद उंडाद, मीर तीनाला इल्ला नीन मिक विनंती शेस्तान, मीपैकी यवार यंडकाक पण धक्का आंटाखोई.” ");
INSERT INTO wbq_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","इल्ला माटलाळीनेन्का पौल रोट्या तीस्कोन्या इंगा आंदार मुंदार परमेश्वरदी उपकार मानाशीर, आदी रोट्या तेंपी वाड तिनदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","आदी सुशी वार आंदारकी धीर वच्या इंगा वार तीनीर. ");
INSERT INTO wbq_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","मिम आंदार मिळाशी जहाजला दोनशे शहात्तर मंदी उंटीम. ");
INSERT INTO wbq_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","वार आंदार संगेम तिनी तागी नेन्का धान्य समुद्रला येशेशीर इंगा जहाजलोंदी वजन कमी शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","फदु फुटीनेन्का वारकी भूमीद ओळख पटालेद, पण आंदू काट उंडीने लेका उपसागरलेका आदी जागा काम्पीचीवच्या, दांचांग शक्य आते आंदूळ काटूक जहाज आंचेळदी वार ठहरामतीर. ");
INSERT INTO wbq_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","दांचांग वार नांगरलु कोशिर इंगा समुद्रला फडा निचिर, दान संगाने सुकाणूलाय दारामलु ओकाताळा शेशीर, इंगा वार जहाज मुंदार भागुद शीड घाली नीनडाला दांचांग नीला फेटीर इंगा जहाज काटूक येकोचीर. ");
INSERT INTO wbq_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","इंगा रोंड समुद्रलोंटोर इसका मिन्दिक वचीने ढीग मिंदा जहाज बेग्याता आदळाश्या, आप्पुड जहाजदी मुंदारदी बाजू उसका सचकोनी कुसन्या इंगा गलबताद यंकाळदी भाग लाटला तडाखाइचांग तेगदेंक आंट्या. ");
INSERT INTO wbq_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","आप्पुड शिपाइल कैदीलान मतेळदी ठहरामतीर, दिनकस्रोम की वार लोन्केल यवार पोहाशीगात फारारोद. ");
INSERT INTO wbq_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","गान शताधीपतीक पौलनी वाचामतेळदी उंड्या दांचांग वाड शिपाइलाक आदी विचार इडशीदेंक शपीर इंगा यवार्की पोवादेंक वस्ते वार जहाजलोन्केल उडील मती काटूक फोवाला इल्ला आज्ञा शेश्या ");
INSERT INTO wbq_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","बाकी मंदी फळलाद अगर जहाजइ तेगीनेय कटला आधारता भूमी गाठाला इल्ला शप्या, इल्ला रीतीता जहाजलोन्टोर आंदार सुखरूपता भूमीमिंदा पोहोचाशीर. ");
INSERT INTO wbq_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","यपुड माय काळलु सुखरूपता आंदूड भुमिक आंट्या, आप्पुड माक तेलच्या की, आ बेटूद फेर मिलिता इल्ला उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","आंदू नीलचेटोर मासंगा संगेम ममताता वागाशीर, वार ओगाट शेकोटी आंशिर इंगा माद स्वागत शेशीर, येनटीक की वाना फडू इंगा सलीपण उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","पौल कटलु जमा शेसु इंगा आ शेकोटीला यैयदू, शका कसरोम आंदकेल ओगाट जाहिरीला फाम येल्या इंगा आदी पौल शेईन गुंडाळीच्कुण्या. ");
INSERT INTO wbq_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","आदी सुशी आंदू नीलचेटोर वगामेगारणी आनेदेंक आंटीर, “इ मणशी खुनी उंडा बेक, समुद्रलोन्केल जरी इड वाचाश्या तरी न्याय द्यावारपण इन जगाय नियाड.” ");
INSERT INTO wbq_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","पण पौल आदी फाम आग्गीला झटकाशी येश्या इंगा पौलकी येमी कालेद. ");
INSERT INTO wbq_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","आ बेटमिन्दुड मंदीक वाटाश पौलदी शरीर वास्कुन्नेद किंवा येम पण विकार आईनेद कम्पीयाकुंदू, आप्पुड आ मंदिद विचार पलटाश्या इंगा पौल द्यावारे उंडाड इल्ला वार आनेदेंक आंटीर. ");
INSERT INTO wbq_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","आंदकेल देगारे पुब्ल्य फेरोन मंशीद शेन उंड्या, पुब्ल्य इड आ बेटटोड अधिकारी उंड्या, वाड मा आंदारदी वान ईलकाडा स्वागत शेश्या इंगा मूड नाळ माद शिंगार पाहूनचार शेशा. ");
INSERT INTO wbq_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुब्ल्यान आब्बाड जडमुता इंगा कडपु खराब उंडीने इचांग बिमार उंड्या, दांचांग पलंग मिन्दा फडी उंड्या, पौल आ बिमार मंशीन भेटादेंक फोया प्रार्थना शेशी पौल स्वताद शेई वानमिंदा फेट्या इंगा आ मन्शीन शिंगार शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","इदी घडासनेद सुशीनेन्का आ बेट मिन्दुटोर इंगोगो बिमार मंदी पौलतीकुड वचीर इंगा शिंगार आयीर. ");
INSERT INTO wbq_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","वार माक सन्मानता संगेम वस्तूल भेटलु पण इच्चीर इंगा यपुड मिम वापस प्रवास इचांग येलतीम आप्पुड माक आंटेळी संगेम माटलु पुरामतीर. ");
INSERT INTO wbq_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","मिम इंदू सलीकालाम नीलचीनेन्का आलेक्सांद्र शहरलोन वगा जहाजता मुंदार प्रवासकी येलतीम, आदी जहाज आ बेटमिंदा सलीकालामभर मुक्कामकी उंड्या, आ जहाजला मुंदार बाजूक जुळवा तमुळलाय चिन्हळ उंड्या. ");
INSERT INTO wbq_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","इंगा मिम सुराकुस शहर इंदूक फोई पोहोचास्तिम इंगा आंदू मूड नाळ नीलस्तिम. ");
INSERT INTO wbq_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","आंदकेल तीर्गीगास मिम येलतीम इंगा रेगीयोन नगरकी फोतीम, आंदू ओगा नाळ मुक्काम शेस्तीम, यंक्सार दक्षिणतीकुड घाली तीर्गी नेन्का इन्गो नाळ पुत्यूलकी शहर फोतीम. ");
INSERT INTO wbq_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","आ शहरला माक काही बंधूजनलु भेटाशीर, वार शपकाम मिंदा मिम इंदू योड नाळ नीलस्तिम, मग मिम रोम इंदूक फोई पोहोचास्तीम. ");
INSERT INTO wbq_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","आंदूटोर ताम्मुल इंगा शेलालू मा बद्दलदी माटा ऐकाशीनीर, वार मा भेटइचांग अप्पीयान संतापेठ नंताक इंगा मूड धर्मशाळाल नंताक वचीर, पौलदी वारदी भेट आयीनेन्का वाड द्यावार्दी उपकार मानाश्या इंगा वांकी धीर वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","मिम रोम इंदू पोहोचाशिनेन्का पौलकी वकांकी निलचेद परवानगी शिक्या, पण वान मिंदा देखरेख शेशेदेंक ओगा शिपाईन फेटदेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","मूड नाळा बाद पौल आंदार यहुदी पुढारीलान ओगातळा कुतेश्या, यपुड आंदार जमा आय्यीर आप्पुड पौल वारणी आन्या, “बंधूलाला, मना तम्मूळा विरुद्ध नीन येमपण शेया लेन, तरी नन्नु यरुशलेम इंदू फटीगास रोमी मंदी शेतल्या कैदी आंका इच्चीर. ");
INSERT INTO wbq_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","इंगा यपुड वार नाद चौकशी शेशीर, आप्पुड वारदी नन्नु इडशेद इच्छा उंड्या, येनटीक की मरण शिक्षाक योग्य इल्ला यादूच गुन्हा नीन शेया लेकुंटीन. ");
INSERT INTO wbq_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पण यहुदी मंदी यपुड नन्नु ईडशेदेंक लेद आनीर, आप्पुड कैसरतीकुड न्याय आडगुकाम नाक भाग फड्या, दिंदी अर्थ इल्ला लेद की, यहुदी मंदी उलटा नाक दोष आंचेद इच्छा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","इ कारण इचांग मींमलान भेटाशेद इंगा मी संगा माटलाडेदी नीन इच्छा सुपिस्तीन, येनटीक की इस्राएल आशा तोंन नीन इ साकळीलता कटीनोड उंडान.” ");
INSERT INTO wbq_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","यहुदी पुढारी पौलनी आनीर, “माक निबाबत यहुदीया नुस यादुच पत्र दालेद, जर आला नुस वचेतोर बंधूजनला पैकी ओगाड पण तमूड मीविषयला खराब शपालेद किंवा माटलाडालेद.” ");
INSERT INTO wbq_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पण मि मतलु येम उंडाय इदी समजाशी तीस्कुनेद माद इच्छा उंडाद, येनटीक की इ गट विरुद्ध आन्नी तीकुड माटलाडतार इदी माक यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","आप्पुड यहुदी मंदी ओगाट बैठकदी नाड ठरामतीर, यंदू पौल निलदू, आंदू वार फेदा संख्याता जमा आय्यीर, आप्पुड पौल वारकी समजामती शप्या इंगा द्यावार राज्य बद्दल स्वताद साक्ष इच्या, मोशेन नियमशास्रकेल इंगा संदेष्ट्यालकेल फग्लामती शेप्या येशुन विषयला वारदी खात्री पटामतेद प्रयेत्न शेश्या इदी वाड फदिनकेल मापसार नंताक शेश्या. ");
INSERT INTO wbq_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","वाड फग्लामती शपीने माटला विषयला काही मंदीद खात्री पटाश्या, तर काही मंदी वाड माटलाडे माटलामिंदा विश्वास फेटालेर. ");
INSERT INTO wbq_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","पौल मुंदार्दी ओगाट माटा माटलाड्या, दान मिन्द्केल मतभेद आयी वार पैकी काही मंदी लेशीर इंगा आंदकेल फोयेदेंक आंटीर, पौल आन्या, “यशया संदेष्ट्याल तीकेल पवित्र आत्मा मना आबातातागार संगा येम आन्या, आदी खरेखरेमे येंता खरेम उन्डाद! यशया आनिंड्या.” ");
INSERT INTO wbq_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","इ मंदीतीकुड मीर फोंडा इंगा वारकी शपना: मीर ऐकाश्यार तर खरेम पण मिक समजाक फोई, मीर सुश्यार मिक कम्पीची पण मीर येम सुस्तुणार आदी मिक तेला फोई. ");
INSERT INTO wbq_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","येनटीक की इ मंदि अंतकरणलु जड आयीनाय वार गुम्मालता वारकी इना दाद इंगा वार स्वताय कंडलु बंद शेशिणार लेकाते वार स्वता कंडलाता सुस्तुनीर इंगा स्वता गुम्मालता ऐकास्तुनीर इंगा ना तीकुड तीर्गु तुनीर इंगा नीन वारणी शिंगार शेस्तुन्टीन. ");
INSERT INTO wbq_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","दांचांग द्यावार इदी तारण इंगोगो राष्ट्रटोर मंदीतीकुड आम्पीच कामला वच्या, इदी मी यहुदी मंदीक तेलाला, वार ऐकाश्यार. ");
INSERT INTO wbq_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","वाड इल्ला माटलाडीनेन्का यहुदयाल वार दिन्टल्या संगेम विवाद शेस्का येलीर. ");
INSERT INTO wbq_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","पूर्ण रोंड येन्डलु वाड वान भाडा इंटल्या नीलच्या, यवार वान भेटादेंक वदुर, वारदी वाड स्वागत शेयदू. ");
INSERT INTO wbq_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","वाड द्यावार राज्यविषयला प्रचार शेश्या, वाड प्रभू येशुन विषयला शिक्षण इच्या, वाड इदी फनी संगेम धेर्यता शेयदू इंगा यवार पण वान माटलाड देंक अडाय मती शकायलेर.");
INSERT INTO wbq_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","द्यावार इच्छाता ख्रिस्त येशुन प्रेषित आयदेंक फिल्चीनोड, नीन पौल इंगा तम्मूड सोस्थनेस तीकनुस, ");
INSERT INTO wbq_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","करिंथ शहरला उंडीने द्यावार मंडळीक नीन पत्र रास्तान, आंटे ख्रिस्त येशुन तीकनुस पवित्र शेशिनोर इंगा पवित्रमंदी आयदेंक फीलचीनोर आंदार कसोम येवार प्रत्येक जागाला मना प्रभु येशु ख्रिस्तन फेरता प्रार्थना शेस्तार, वाड वारकी इंगा मनाक पण प्रभुड उंडाड ");
INSERT INTO wbq_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","द्यावार मना आब्बाड इंगा प्रभु येशु ख्रिस्तन तिकनुस कृपा इंगा शांती उंडाला. ");
INSERT INTO wbq_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ख्रिस्त येशुला मी मिंदा आय्यीने द्यावार कृपा कसोम नीन नेहमी मी कसोम ना द्यावारदी उपकार मानास्तान. ");
INSERT INTO wbq_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","येनटीक की, द्यावार मिमलान ख्रिस्त येशुन तीकनुस प्रत्येक बाबतीला, आन्नी माटलाला इंगा आंता आत्मिक ज्ञानला समृध्द शेशीनाड. ");
INSERT INTO wbq_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","इल्ले ख्रिस्त बद्दल माद साक्ष खरेम उंडीनेद मि नडमा खात्री आय्या. ");
INSERT INTO wbq_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","इप्पुड मी नोना यादुच आत्मिक दानलाद कमी लेद, यल्ला मीर मना प्रभु येशु ख्रिस्तंदी वापस वच्चेद दावा सुस्तार. ");
INSERT INTO wbq_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","द्यावार मीमलान आखरी नंताक टीकायामती पण फेट्टी, दिन कसोम की मना प्रभु येशुन ख्रिस्तन वापस वच्चे दिनमुला मीर निर्दोष उंडाला. ");
INSERT INTO wbq_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","वाड द्यावार विश्वासु उंडाड, यवाड मना कोडकु येशु ख्रिस्त, मना प्रभुन सहभागिताला मीमलान फीलचीनाड. ");
INSERT INTO wbq_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","तर इप्पूड, तम्मूडलु इंगा शेल्यांलू, प्रभु येशु ख्रिस्तन फेरला नीन मिक शेतुल जोडशी विनंती शेस्तान की, मीर आंदार वगामेगारसंगा वगा मनता वगातळा कावाला इंगा मीनडमा मतभेद उंडाराद, पण मीर वगाटे माटा माटलाडाला. ");
INSERT INTO wbq_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","येनटीक की ना तम्मूडलु इंगा शेल्यान्लू ख्लोवेन इल्काटोर मंदीतिकनुस नाक इल्ला येरका आय्या की, मी नडमा जगडाल उंडाय. ");
INSERT INTO wbq_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","नाद म्हणणं इल्ला उंडाद की मी दिन्ल्योन्टोड प्रत्येक मणशी आंटाड की, “नीन पौलनी मानास्तान.” “नीन अपुल्लोन मानास्तान,” “नीन कैफान मानास्तान,” “नीन ख्रिस्तन मानास्तान.” ");
INSERT INTO wbq_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ख्रिस्तय भागलू फडनाय येम? पौल क्रूसमिंदा मीकस्रोम खिळायदेंक वचीन्या येम? पौल फेरता मिद बाप्तिस्मा आयनाद येम? ");
INSERT INTO wbq_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","इल्ला यवारूच आनाराद की, ना फेरला मीद बाप्तिमा शेयदेंक वचीनाद. ");
INSERT INTO wbq_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","नीन द्यावारदी आभार मानास्तान की, क्रिस्प इंगा गायस इरनी इडशी नीन यवारदीच बाप्तिमा शेया लेद. ");
INSERT INTO wbq_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","स्तेफन इंटल्योन्टोरदी पण नीन बाप्तिस्मा शेशीनान, दिन इडशिगास, तर इंगा येवारदीच बाप्तिस्मा सेशीनेद नाक ध्यानाम लेद. ");
INSERT INTO wbq_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","येनटीक की ख्रिस्तड ननू बाप्तिस्मा शेयदेंक लेद तर शुभवर्तमान शपदेंक आम्पीनाड, आदी पण मनशी ज्ञानगोन लेद, इल्ला कावाराद की, ख्रिस्तंदी क्रूसमिंदा सच्चेद सामर्थ्य वाया फोवाराद. ");
INSERT INTO wbq_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","येनटीक की यवारदी नाश आतुनाद इलोन्टोरकी क्रूसदी संदेश मूर्खपनाद उंडाद, पण मनाक तारण आय्येतोरकी आदी द्यावारदी सामर्थ्य उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","येनटीक की पवित्र शास्त्रला इल्ला राशीनेद उंडाद, “शहाण्योरदी शहाणपण नीन नष्ट शेश्यान इंगा बुद्धी उंडीनोरदी बुध्दी नीन वाया फोवा मत्यान.” ");
INSERT INTO wbq_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ज्ञानीला ज्ञानुक महत्व यंदु नीलच्या? नियमशास्त्र गुरूलाद महत्व यंदु नीलच्या? इ दुन्यामला फोर फेटकुनेतोरदी महत्व यंदु नीलच्या? द्यावार दून्यामदी ज्ञान मूर्खपणाद ठराय मतालेद येम? ");
INSERT INTO wbq_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","येनटीक की, द्यावार वान ज्ञानता निर्णय तीस्कुन्या की, ज्ञानी वान ज्ञानता द्यावारनी गुरतू फट्टाड, दिन कसोम, द्यावारकी इदी शिंगार वाटाश्या की मा संदेश “मूर्खता नुस” यवार विश्वास फेटतार वारदी तारण शेय्याला. ");
INSERT INTO wbq_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","येनटीक की शेंगेम यहुदी मंदी चमत्कारी चिन्हल आडगुतार इंगा ग्रीक मंदी ज्ञान फुडकुतार, ");
INSERT INTO wbq_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","पण मीम क्रूसमिंदा खिळाशिने ख्रिस्तन गाजामतुताम. इदी संदेश यहुदी मंदीकस्रोम अडथळा इंगा यहुदी लेनोर मंदीकस्रोम मूर्खपणा इल्ला उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","पण यवारनी फिलचिनेद उंडाद, इल्लोन यहुदी इंगा यहुदी लेनोर इद्दार कसोम इदी संदेश ख्रिस्त उंडाड. येवाड द्यावारदी सामर्थ इंगा द्यावारदी ज्ञान उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","येनटीक की याद मीर द्यावारदी “मूर्खपणा” आंटार आदी मनसुला ज्ञान काना जास्त ज्ञानी उंडाद इंगा येनटीन मीर द्यावारदी “अशक्तपणा” समजास्तार आदी मनसुला शक्ती काना जास्त शक्तीशाली उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","तर इप्पूड तम्मुडलू इंगा शेल्यांलू, द्यावार मिमलान फिल्चीने बद्दल विचार शेयांडा. मनशी कंडलाला मीदिंटल्योन्टोर शेंगेम बुद्धिमान, सामर्थ्यशाली, फेद्दा कुळलोन्टोर लेकुंडीर, ");
INSERT INTO wbq_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","पण द्यावार दून्याम लोन मूर्ख समजास्ने माटलू निवडाशीनाड, दिनकस्रोम की, ज्ञानी समाजास्ने माटलान शिग्गुना केडपाला. इंगा अशक्त समजास्ने माटलू निवडाश्या की शक्तीशाली समजास्ने माटलान शिग्गुना केडपाला. ");
INSERT INTO wbq_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","येनटीक की द्यावार दुन्यामलोन नीच, तुच्छ मानाशीनोर, येवारनी “कोलवार” वारनी निवडाश्या. दिनकस्रोम की येवार “येमाना उंडार” वारनी कोल्वाराद. ");
INSERT INTO wbq_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","दिनकस्रोम यवाडबी मनशी द्यावार मुंदार घमंड शेय्याराद. ");
INSERT INTO wbq_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","द्यावार मिमलान ख्रिस्त येशुन संगा भेटाय मतनाड, मना फायदा कसोम द्यावार वान ज्ञान बनायमत्या, ख्रिस्त मनालनी द्यावार संगा भेटायमत्या; वाड मनालनी पवित्र शेश्या इंगा मनालनी पापलानुस मुक्त शेश्या. ");
INSERT INTO wbq_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","दिनकस्रोम पवित्र शास्त्रला इल्ला राशीनेद उंडाद, “यवाड घमंड, शेस्ताड वाड प्रभुन बद्दल शेय्याला.” ");
INSERT INTO wbq_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","हे तम्मूडलु इंगा शेल्यांलू, यप्पुड नीन मीतीकुड वस्तीन आप्पूड नीन द्यावारदी रहस्य मनशी ज्ञानता लेकाते शिंगार भाषण शेशी शेपदेंक दालेद. ");
INSERT INTO wbq_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","येनटीक की मि नडमा उंडीनापुड फक्त येशु ख्रिस्त इंगा वाड पण क्रूसमिंदा खिळाशिनोड, दिन इडशी यादुच माटाद ज्ञान नाक नील्वाराद इल्ला नीन पक्का निश्चय शेशीनान. ");
INSERT INTO wbq_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","इंगा नीन मि तीकुड अशक्त, येरस्का इंगा थरथर नडगुका मनशी गता वसतीन. ");
INSERT INTO wbq_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","नाद संदेश इंगा प्रचार मनशी ज्ञानता भुलायामते माटाता लेकुंड्या पण आत्मा इंगा दान सामर्थ्य तीकनुस उंडया. ");
INSERT INTO wbq_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","दिनकस्रोम की, मीद विश्वास मनशी ज्ञानमिंदा लेद तर द्यावार सामर्थ्य मिंदा उंडाला. ");
INSERT INTO wbq_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","तरीपण, यवार आत्मिक रुपता पक्का उंडार वारकी मीम ज्ञानुय माटलू शेपताप पण आदी ज्ञान इ दुन्यामदी लेद इंगा इ युगलोन्टोर नाश आय्येतोर यवार अधिकारील वारदी पण लेद. ");
INSERT INTO wbq_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","पण द्यावारदी रहस्यमय ज्ञान मीम शेपताम आदी दाशी फेटीनेद उंड्या, आदी द्यावार युगकाना पहिला मना सन्मान कसोम नेमाशी फेट्टीनेद उंड्या. ");
INSERT INTO wbq_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","इदी ज्ञान इ युगलोन यादुच अधिकारीक यरका लेकुंड्या येनटीक की जर वारकी यरका उंटे, तर वार गौरवी प्रभुन क्रूसमिंदा खिळाया कुंटुनीर. ");
INSERT INTO wbq_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","पण पवित्रशास्त्रला इल्ला राशीनेद उंडाद, “येम कन्नु सुडा लेद, गुम्मा इना लेद इंगा मंदी मनला याद दालेद, आदी द्यावार वानमिंदा प्रेम शेशेतोर कसोम तैयार शेशीनाड.” ");
INSERT INTO wbq_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","पण द्यावार आद्दे माटलान आत्माता मनाक प्रकट शेशीनाड येनटीक की, आत्मा आन्नी माटलाद इड नंताक की द्यावार खोल विचारलान पण फुडकुताद. ");
INSERT INTO wbq_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","येनटीक की, मनशी आत्मा इडशी मनशी माटलू जानाशेतोड इंगोगोड या मनशी उंडाड? आल्ले द्यावार आत्मान इडशी द्यावारी खोल विचारलू येवारूच जानाशी शकायाड. ");
INSERT INTO wbq_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","इंगा इप्पुड मनाक जगलोंदी आत्मा शिकालेद, पण आदी आत्मा शिकीनाद याद द्यावार तीकनुस उंडाद. दिन कसोम की, आय आन्नी माटलु याय द्यावार मनाक फुकटला इच्चीनाड, आदी मनाम जाणायाला. ");
INSERT INTO wbq_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","येनटीक की, इये माटलु मनशी ज्ञानता नेरपीने माटलाता मिम आनाम, पण आत्मा नेरपीने आत्मिक माटलान उपयोगला येकोची आत्मिक माटलाद स्पष्टीकरण शेस्केन आंटाम. ");
INSERT INTO wbq_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","दुन्यामगता नडशेतोड मनशी द्यावार आत्माय माटलु स्वीकार शेयाड येनटीक की, आय वान्की मूर्खपणाय माटलु वाटास्ताय इंगा वाड आय जानाशी शकायाड, येनटीक की आटलान आत्मागोने ओळखाशेद उंटाद. ");
INSERT INTO wbq_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","येवाड आत्मिक उंडाड वाड तर आन्नी माटलु ओळखास्ताड पण वान यवारच ओळखाशी शकायार. ");
INSERT INTO wbq_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","येनटीक की पवित्र शास्त्रला इल्ला राशीनेद उंडाद, “प्रभुनदी मन यवाड जानासनाड? येवाड वान्की नेरपी?” येनटीक की, मनाक तेलस्ताद की ख्रिस्तद याद मन उंडाद आदी मना देगार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","हे तम्मूडलू इंगा शेल्यांलू, यल्ला नीन आत्मिक मंदीसंगा माटलाडतान आल्ला मी संगा माटलाडी शकायालेद. पण नाक मी संगा दुन्यामगता नडशेतोर मंदीलेका इंगा ख्रिस्तला बीळ्ळालेका माटलाडा बेक आय्या. ");
INSERT INTO wbq_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","नीन मीक द्यावार संदेशता फक्त सोपा माटलु नेरपुतीन, यल्ला वगा आम्मा दान बिळ्ळाक तागदेंक फक्त फाल इस्ताद, नीन मिक दिनकाना कठीन माटलु नेरपालेद याय फक्त पक्का विश्वासीले समजास्तार, येनटीक की मीर इप्पुड नंताक इल्लोन शिक्षा समजायदेंक तैयार लेकुन्टीर इंगा इप्पुड पण समजायदेंक तैयार लेर. ");
INSERT INTO wbq_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","मीर इप्पूड पण शारीरिक उंडार येनटीक की मी नोना कोफाम इंगा जगडाल उंडाय, तर मीर शारीरिक लेर येम इंगा दून्यामलोन मंदीलेका नडवार येम? ");
INSERT INTO wbq_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","येनटीक की यप्पुड वगाड आंटाड, “नीन पौलनी मानास्तान,” इंगा इंगोगोड आंटाड, “नीन अपुल्लोन मानास्तान,” तर येम मीर साधारण मन्सुल लेर? ");
INSERT INTO wbq_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","तर मग अपुल्लोस येवाड उंडाड? इंगा पौल येवाड उंडाड? वार फक्त सेवकलु उंडार येवार तीकेल मीर विश्वास फेटतीर. मा दिंटल्योन्टोड प्रत्येक मनशी फक्त आदी फनी शेशा याद प्रभूड माक सोपाशीन्या. ");
INSERT INTO wbq_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","नीन द्यावारदी वचन मी हृदय ला आनस्तीन, इंगा अपुल्लोस वान शिक्षाता दान्की नेळ येश्या, पण इड द्यावारे उंड्या येवाड दान वाढायमत्या. ");
INSERT INTO wbq_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","दिन कसोम आनचेतोड येमीच लेड इंगा नेळ येशेतोड येमीच लेड, पण द्यावारे आंता उंडाड येवाड वाढाय मतेतोड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","येवाड बी आनस्ताड इंगा नेळ येस्ताड वार इद्दार वगा उद्देश्य कसोम फनी शेस्तार इंगा प्रत्येक मंशीक वान मेहनत लेका पगार शिक्की. ");
INSERT INTO wbq_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","येनटीक की अपुल्लोस इंगा नीन द्यावार कसोम इद्दार कुडी फनी शेस्ताम. मीर द्यावार्दी शेन इंगा द्यावार्दी इमारत उंडार. ");
INSERT INTO wbq_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","द्यावार कृपाता याद नाक इच्चीनेद उंडाद दान लेका नीन सुज्ञ, कुशल कट्टेतोन लेका पाया येस्तीन इंगा इंगोगोड दानमिंदा कटताड तर दान मिंदूडदी बांधकाम मनाम यल्ला शेस्ताम, दिन बद्दल प्रत्येक मनशी काळजी तिस्कूनाला. ");
INSERT INTO wbq_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","येनटीक की येशु ख्रिस्त इड याद येशीनेद पाया उंडाद, दान इडशी इंगा येवारूच इंगोगोट पाया येशी शकायार. ");
INSERT INTO wbq_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","जर येवाडाना आ पायामिंदा बंगार, यंडी, मौल्यवान राळ, कट्या, गड्डी इंगा पेंड्यालदी उपयोग शेशी कटतार, ");
INSERT INTO wbq_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","तर कट्टे तोरदी प्रत्येक मनशीद फनी स्पष्ट कमशी येनटीक की आ दिन्मू आदी यलगुला येकोची, आदी दिन्मू आग्गी जताक प्रकट आय्यी, इंगा आद्दे आग्गी प्रत्येक मनशी फनीद परीक्षा शेशी की यल्ला उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","येवारदी आना फनी आ पाया मिंदा कटीनेद टीकाशी, वान्की प्रतीफळ शिक्की. ");
INSERT INTO wbq_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","जर येवारदी आना फनी काली फोई इंगा वानदी नुकसान आय्यी पण वानदी तारण आय्यी. तरी पण यल्ला येवाडाना आग्गी आन्टीने भवन लोन्केल फारी वाचाशी. ");
INSERT INTO wbq_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","मीर द्यावारदी निवासस्थान उंडार इंगा द्यावार आत्मा मी नोना नीलस्ताद इदी मीक यरक्का लेद येम? ");
INSERT INTO wbq_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","जर यवाड द्यावार निवासस्थानद नाश शेस्ताड तर द्यावार आ व्यक्तीद नाश शेशी; येनटीक की द्यावारदी निवासस्थान पवित्र उंडाद इंगा आदी मीर उंडार. ");
INSERT INTO wbq_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","यवारूच स्व:तन फसाय मताराद, जर मि दिनल्योन्टोड यवाडाना इ दुन्याम दृष्टीगोन स्वतःन ज्ञानी समजास्ताड, तर वाड खरेमे ज्ञानी आय्ये कसोम “मूर्ख” कावाला. ");
INSERT INTO wbq_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","येनटीक की इ दुन्यामदी ज्ञान द्यावार दृष्टीला मूर्खपणा उंडाद; येनटीक की पवित्र शास्त्रला इल्ला राशीनेद उंडाद की, “द्यावार ज्ञानीन वान धूर्तपणाला फसाय मतताड.” ");
INSERT INTO wbq_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","इंगा “द्यावार जाणास्ताड की ज्ञानीयोरी विचारलु व्यर्थ उंडाय.” ");
INSERT INTO wbq_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","तर मग यादुच मंदी मिंदा घमंड शेयाराद, येनटीक की आन्नी माटलु मीये उंडाय. ");
INSERT INTO wbq_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","मग वाड पौल उंटे, अपुल्लोड उंटे केफा उंटे, दुन्याम उंटे, जीवन उंटे का साव उंटे, वर्तमान उंटे लेकाते भविष्य उंटे, इ आन्नी माटलु मी उंडाय. ");
INSERT INTO wbq_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","मीर ख्रिस्तद उंडार इंगा ख्रिस्त द्यावारद उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","मंदी ममलान फक्त ख्रिस्तन सेवक समजायला येवारनी परमेश्वरदी रहस्य शेप्पेतोर कारभारी बनाय मतनार. ");
INSERT INTO wbq_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","इल्ला सुस्ते इदी नक्की उंडाद की, जबाबदारी उंडीनोड कारभारी विश्वासयोग्य उंडाने बेक. ");
INSERT INTO wbq_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ना कसोम इदी शेंगेम शिन्नाद माटा उंडाद की मीर लेकुटे मन्सुलाला येवाडाना न्यायाधीश नाद न्याय शेय्याला, नीन स्व:त पण नाद न्याय शेय्यान. ");
INSERT INTO wbq_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","येनटीक की जरी नाद विवेक नाक दोष इयाद तरी दानता नीन निर्दोष ठरास्तान इल्ला लेद. इड प्रभुड उंडाड यवाड नाद न्यायनिवाडा शेशेतोड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","आनकेन योग्य वेळ वच्ची नंताक यप्पुड नंताक प्रभुड दाड आडनंताक येनटीदुच न्यायनिवाडा शेयाकुंडा. वाडे मोब्बू गडदुला दागिने माटलान यलगुला सुपीची इंगा अंत:करण लोन विचारलान प्रगट शेशी, आप्पुड द्यावार तीकनुस वगोगोंदी प्रशंसा आय्यी. ");
INSERT INTO wbq_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","इप्पुड, तम्मुडलु इंगा शेल्यांलू, इ माटलाला नाद स्वतःद इंगा अपुल्लोनदी उदाहरण आंका मिक शप्पीनान. दिन कसोम की, पवित्र शास्त्रला राशीने माटलाद उल्लंघन कावाराद आंटे वगा मनशीद पक्ष तीस्केन इंगोगोनकी विरोध शेशी मीर गर्वता निंडी फोवाराद. ");
INSERT INTO wbq_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","येनटीक की नीदिंटल्या इंगा इंगोगोरदिंटल्या फरक येवाड शेस्ताड? इंगा निक शिक्का लेद इल्ला निदेगार येम उंडाद? जर निक आंता शिक्कीनाद, तर निक शिक्कालेद आंका घमंड येनटीक शेस्ताव? ");
INSERT INTO wbq_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","मीर पहिलाने तृप्त आयनार, धनवान आयनार, मीक इल्ला वाटास्ताद की माशिवाय मीर राजाल आइनार इंगा मीर राजाल आइंटे तर शिंगार आतुन्या, दिन कसोम की मिम पण मी बरोबर राजाल आयतुंटीम. ");
INSERT INTO wbq_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","येनटीक की नाक वाटास्ताद की द्यावार ममलान प्रेषितलान आंदार आयनेंका आ मंदी लेका ठराय मतनाड, येवारदी सच्चेद आज्ञा आय फोईनाद, येनटीक की मिम जगला द्यावारदूत इंगा मंदी कसोम तमाशा बनाशीनाम. ");
INSERT INTO wbq_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","मीम ख्रिस्तन कसोम मूर्ख उंडाम, मिक इल्ला वातास्ताद येम? की मीर ख्रिस्तन संगतीता बुद्धिमान आयनार! मीम अशक्त उंडाम, पण मीर बलवान उंडार! मीक आदर शिक्ताद, पण माद आदर काद! ");
INSERT INTO wbq_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","इप्पुड नंताक मीम तीनान्दे इंगा तागान्दे उंडाम, इंगा फाताय शिंगीने चिंध्याल फेटकुनीनाम, मा संगा वाईट वागास्तार इंगा माक निल्देंक इल्लु लेद. ");
INSERT INTO wbq_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","मा शेयता फनी शेशिगास मिम मेहनत शेस्ताम. माद निंदा आयताद आप्पुड मिम वारकी आशीर्वाद इस्ताम. ");
INSERT INTO wbq_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","यप्पुड माद सताव आयताद, आप्पुड मीम सहन शेस्ताम इंगा यप्पुड माद बदनामी आयताद, आप्पुड पण मीम शिंगारे माटलाडताम, इबद नंताक मीम दुन्याम कसोम गाळ इंगा कचरा लेका उंडाम. ");
INSERT INTO wbq_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","नीन मिमलान शिग्गुना केडपाला आंका इदी रायान, पण ना बीळ्ळालेका समजाशी मिक चेतावणी इस्तान. ");
INSERT INTO wbq_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","येनटीक की जरी मीक ख्रिस्तला फदी सावुर गुरुल उंटे तरी शेंगेम आब्बागार लेर येनटीक की ख्रिस्त येशूला शुभवर्तमान तीकनुस नीन मिक जन्म इच्चीनान. ");
INSERT INTO wbq_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","दिन कसोम नीन मिक शेतलु जोडशी शेप्तान की नाद अनुकरण शेयांडा. ");
INSERT INTO wbq_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","दिन कसोम नीन तीमथ्यन मी तिकुड आमशीनान. प्रभुला वाड ना प्रिय इंगा विश्वासयोग्य कोडकु उंडाड. यल्ला नीन प्रत्येक जागाला प्रत्येक मंडळीला नेरपुतान, आल्ले वाड ख्रिस्तला ना जीवन दावाद मिक ध्यानाम शेशी इच्ची. ");
INSERT INTO wbq_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","काही मंदी तर इल्ला फुगाशीनार जस्काय नीन मी तीकुड वच्चेतोडे लेन. ");
INSERT INTO wbq_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","पण प्रभुनदी इच्छा उंटे तर नीन लगेच मीतिकुड वच्यान इंगा आप्पुड नाक तेलची की, येवार गर्वता फुगाशी फोईनार वार यंता बागा उंडार इदी सुदेंक लेद, तर वार देगार द्यावारदी यंता सामर्थ्य उंडाद इदी नीन सुश्यान. ");
INSERT INTO wbq_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","येनटीक की द्यावारदी राज्य मनशी माटलाला लेद तर द्यावार सामर्थ्यला उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","मीद येम इच्छा उंडाद? नीन मी तीकुड मिक शिक्षा शेशे कसोम कट्या येतकेन दावाला, का प्रेम इंगा नम्रता आत्मा संगा दावाला? ");
INSERT INTO wbq_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","इल्ला माटा इने दिंटल्या वच्चीनाद की, मी दिंटल्या व्यभिचार आयताद. वगा मनशी वान आब्बान इंगोगो वडती संगाने अनैतिक संबंध फेटताड. इल्लोन व्यभिचार याद यहुदी लेनोरला पण काद. ");
INSERT INTO wbq_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","इंगा तरी मीर गर्वता फुगाशीनार, पण मीर दान कसोम शोक शेय्यार? यव्वाड इल्ला फनी शेशीन्या वान मीदिंटल्योंकेल तिस्काडाल सुंटीर. ");
INSERT INTO wbq_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","नीन जरी फय रूपता मीनडमा लेन तरी आत्मा रूपता तर नीन आंदे उंडान. आंदु उंडीगास पण येवाड इल्लोन वाईट फनी शेशीनाड, वान विरुद्ध नीन आज्ञा इच्काडनान, ");
INSERT INTO wbq_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","यप्पुड मीर प्रभु येशुन फेरता वगातळा जमा आयतार, आप्पुड मना प्रभु येशुन सामर्थ्यता नाद आत्मा मी संगा उंटाद, ");
INSERT INTO wbq_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","मीमलान इल्लोन मन्सुलाद फय नाश कसोम शैतानकी इच्काडना; दिन कसोम की, प्रभुन दिन्मुला वान आत्माद तारण कावाला. ");
INSERT INTO wbq_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","मीद घमंड शेशेद शिंगार लेद. मिक येरका लेद येम की रव्वासा खमीर पूर्ण फिस्कीने फिंडीन खमीर शेस्काडताद? ");
INSERT INTO wbq_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","तिशी फेकेस काडना इ फाता खमीरनी, स्वतःन शुद्ध शेयांडा दिन कसोम की मीर कोत्ताद फिस्कीने फिंडी कावाला की मीर अखमीरी उंडार येनटीक की मनाद पण वल्हांडण येवाड ख्रिस्त उंडाड, अर्पण आइनाड. ");
INSERT INTO wbq_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","दिन दांडा मनाम मनाद वल्हांडण फंडगा वाईट इंगा दुष्टताता निंडीने फाता खामिरता लेद तर विश्वासूपणा इंगा सत्यता निंडीने बेखमीर रोट्याता पाळादाम. ");
INSERT INTO wbq_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","नीन मीक ना पत्रला राशीनान की व्यभिच्यारी मंदी संगा संबंध फेटाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","नाद आनेद अर्थ इल्ला बिलकुल लेकुंड्या की मीर इ दुन्यामलोन व्यभिचारी, लोभी, लुबाडीच्चेतोर इंगा मूर्तीपूजकला संगा संबंध फेट्टाके उंडा; इल्ला कावाराद की मिक दुन्याम नुस बैटीक फोवाबेक आय्यी. ");
INSERT INTO wbq_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","पण इप्पुड, नीन मीक राशीनान की, येवाराना ख्रिस्तला तम्मुड आनीनोड व्याभिचारी, लोभी इंगा मूर्तीपूजक, तीट्टेतोड, तगेतोड इंगा लुबाडीच्चेतोड उंटे तर वानसंगा सबंध फेटाकुंडा; इल्लोन मनशी संगा रोट्ट्याबी तीनाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","यव्वार बैटूटोर उंडार मंडळीलोन्टोर लेर वारदी न्याय शेशद नाद येम फनी? मिक वारदे न्याय शेय्यादाद येम यव्वार मंडळीलोन्टोर उंडार? ");
INSERT INTO wbq_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","पण द्यावार बैटूटोरदी न्याय शेस्ताड दिन कसोम 'मीर मीदिंटल्योन्केल आ दुष्ट मनशीन बैटीक तिस्काडना'. ");
INSERT INTO wbq_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","मीपैकी येवाडाना इल्ला उंडाड, येवाड मना मित्र संगा जगडाम आयते तर द्यावार पवित्र मंदी देगार फोयेद इडशी अनीतिमान मंदी न्यायालय लोंग फोयेद हिम्मत शेस्ताड? ");
INSERT INTO wbq_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","पवित्र मंदी दुन्यामदी न्याय शेश्यार इदी मीक येरका लेद येम? इंगा जर मीक दुन्यामदी न्याय शेशेद उंडाद, तर मीर येम शिन्ना-शिन्ना जगडालदी न्याय शेयदेंक पण योग्य लेर येम? ");
INSERT INTO wbq_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","मनाम द्यावार देवदुतलाद न्याय शेश्याम, इदी मीक येरका लेद येम? दिन कसोम इ जीवनलोन शिन्नाय जगडाल इडपीदेंक मीर नक्की दम फट्टाबेक? ");
INSERT INTO wbq_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","जर मिक संसारीक माटलाद न्याय शेशेद उंटे, तर येम वारने कुसना मत्यार येवार मंडळीला येमीच लेर? ");
INSERT INTO wbq_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","मीक शिग्गु कावाला आंकेन नीन इल्ला आंटान, येम खरेमे मी दिंटल्या वगाड पण बुद्धिमान शिक्काड येम येवाड मना तम्मुळलाद न्याय निवाडा शेशी? ");
INSERT INTO wbq_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","पण वगा तम्मुड यप्पुडाना इंगोगो तम्मुन मिंदा केस शेस्ताड येम, आदी पण अविश्वासी मंदी मुंदार? ");
INSERT INTO wbq_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","खरेम आंटे मीर इंदे हारास्तीर की मी नडमा केसलु चालू उंडाय, दानपेक्षा मीर स्वताने अन्याय येनटीक सहन शेय्यार? मीर फसवणूक येनटीक सहन शेय्यार? ");
INSERT INTO wbq_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","पण मीर स्वता अन्याय शेस्तार इंगा फसाय मतुतार आदी पण मना विश्वासी तम्मुळलान इंगा शेल्यांलान. ");
INSERT INTO wbq_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","अनितीमान मंदीक द्यावार राज्यद वतन शिक्काक फोई, इदी मिक येरका लेद यम? फसायाकुंडा; येवारुच व्यभिचारी, मूर्तीपूजक इंगा वडती इडशी इंगोगो आंडीदान संगा व्यभिचार शेशेतोर, विपरीत संभोग शेय्यानीचेतोर इंगा विपरीत संभोग शेशेतोर, ");
INSERT INTO wbq_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","दोंगा, लोभी, सराय तागेतोर, तिट्टेतोर इंगा लुबाडीचेतोर इरकी द्यावार राज्याद वतन शिक्काक फोई. ");
INSERT INTO wbq_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","इंगा मीपैकी यंता तरी मंदी इल्ले उंडीर;पण प्रभु येशु ख्रिस्तन फेरता इंगा मना द्यावार आत्माता कडगीनोर, पवित्र शेशीनोर इंगा नीतिमान ठराशीनोर उंडार. ");
INSERT INTO wbq_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","“आन्नी माटलु ना कसोम शिंगार तर उंडाय,” पण आन्नी माटलु ना फायदा कसोम लेव, “आन्नी माटलु ना कसोम शिंगार तर उंडाय,” पण नीन यादुच वस्तु अधीन काका फोयान. ");
INSERT INTO wbq_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","मीर आंटार वंटा कडपु कसोम उंडाद पण द्यावार आ रोंडू इटलाद नाश शेशी. पण व्यभिचार कसोम फय लेद, तर फय प्रभुन कसोम उंडाद इगा फय कसोम प्रभुड उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","इंगा द्यावार प्रभुन लेप्या इंगा वाड वान सामर्थ्यता मनालनी सुध्दा लेपी. ");
INSERT INTO wbq_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","मीद फय ख्रिस्तन अवयवलु उंडाय, इदी मीक येरका लेद यम? मग नीन ख्रिस्तन अवयवलु तिस्केन आटलान वेश्यादानी अवयवलु शेयदून येम? अजिबात लेद. ");
INSERT INTO wbq_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","मीक इदी येरका लेद यम की, येवाडाना वेश्या दान संगा जुडासताड वाड दान संगा वगाट आताड? येनटीक पवित्र शास्त्र आंटाद की, वार इद्दार वगाफय आय्यार. ");
INSERT INTO wbq_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","पण येवाडाना प्रभुन संगा जुडासताड वाड वानसंगा वगा आत्मा आयफोताड. ");
INSERT INTO wbq_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","व्याभिचारनुस दुराम फारना. इंगोगोट यादबी पाप मनशी शेस्ताड आदी फय बैट्या आयताद. पण व्यभिचार शेशेतोड मना फय विरुद्धलाने पाप शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","मीक येरका लेद येम की, मीद फय मी नोना नीलचेद याद पवित्र आत्मा द्यावार तिकनुस मिक शिक्कीनाद दानदी मंदिर उंडाद. इंगा मीर स्वतःक मालक लेर? ");
INSERT INTO wbq_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","येनटीक की मीर मोल इच्ची कोंकेन तिस्कुनीनोर उंडार; आंकेन मीर मी फयगोन द्यावारदी गौरव शेयांडा. ");
INSERT INTO wbq_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","इप्पुड आय माटलु येनटी बद्दल मीर नाक पत्रला राशीन्टीर इप्पुड आटलाद उत्तर नीन इस्तान; मनशी कसोम इदी बागा उंडाद की वाड आंडीदान संगा संबंध फेट्टाने राद. ");
INSERT INTO wbq_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","गान व्यभिचारनोट वाचायदेंक प्रत्येक मनशीक वडती इंगा प्रत्येक आंडीदानकी मोगुड उंडाला. ");
INSERT INTO wbq_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","मोगुड वडतीक दानदी हक्क इय्याला; इंगा आल्ले वडती पण मोगुनकी. ");
INSERT INTO wbq_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","वडतीक दान फयमिंदा अधिकार लेकुंटाद, पण मोगुनकी उंडाद; इंगा आल्ले मोगुनकी पण वान फयमिंदा अधिकार लेकुंटाद, पण वडतीक उंटाद. ");
INSERT INTO wbq_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","मीर वगामेगारनी इडशी निल्वाकुंडा, पण मीक प्रार्थनाक वेळ शिक्काला आंकेन वगामेगार संमतीगोन काही वेळ कसोम दुराम निलुंडा इंगा वापस वगाट कांडा दिन कसोम की, सैतान मी असंयम कसोम मीमलान मोहला केडपाराद. ");
INSERT INTO wbq_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","गान नीन इदी संमती आनकेन शपतान, आज्ञा आनकेन लेद. ");
INSERT INTO wbq_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","नाद इच्छा इल्ला उंडाद की, आंता मंदी नालेका फेंडली शेस्कुनांदे उंडाला पण प्रत्येक व्यक्तीक द्यावारनुस विशेष दानलु शिक्कीनाय. वगानकी वगा प्रकारे निलचेद इगा इंगोगोनकी इंगोगो प्रकारे निलचेद. ");
INSERT INTO wbq_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","दिन कसोम आंदार फेंडली कानोर इंगा विधवा आंड्योर बद्दल आंटान की, वार कसोम इल्ले उंडेद शिंगार उंडाद यल्ला नीन उंडान. ");
INSERT INTO wbq_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","पण जर वारकी दम यल्लाकुंटे तर वार फेंडली शेस्कुनाला; येनटीक की वासनाला कालेपेक्षा शिंगार उंडाद फेंडली शेस्कुनेद. ");
INSERT INTO wbq_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","इंगा फेंडली आयनोर की निन आज्ञा इस्तान, (निन लेद तर प्रभुड आज्ञा इस्ताड ) की वडती मना मोगून इडवाराद इंगा मोगुड पण वडतीन पण इडवाराद ");
INSERT INTO wbq_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","पण, जर अलगबी आयते तर फेंडली शेस्कुनाराद आल्ले निलवाला इंगा मना मोगुनसंगा वापस समेट शेस्कुनाला इंगा मोगुडपण वडतिन इडवाराद. ");
INSERT INTO wbq_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","पण इंगोगोरकी इदी प्रभु शप्पालेद, पण नीन शपतान की, जर यादाना विश्वासी तम्मुन वडती विश्वास फेट्टाकुंटे इंगा वान संगा निल्चेदेंक संमती उंटे तर वाड दान इडवाराद. ");
INSERT INTO wbq_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","इंगा या विश्वासी आंडीदान मोगुड विश्वास फेट्टाकुंटे इंगा दानसंगा निलचीदेंक समंती उंटे तर आदी वान इडवाराद. ");
INSERT INTO wbq_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","येनटीक की, विश्वास फेट्टाकुनिनोड मोगुड वडती कसोम पवित्र आताड इंगा विश्वास फेट्टाकुन्ने वडती मोगुन कसोम पवित्र आताद, लेकाते मी बीळलु बिस्काल अशुध्द उंटूनीर पण वार इप्पुड पवित्र उंडार. ");
INSERT INTO wbq_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","पण येवाड विश्वास फेट्टाड इडशी फोय्यान आंटाड तर वान फोनिंडा; येनटीक की येवाड तम्मूड इंगा शेल्याल इल्लोन बाबतीत बंधनाला लेद. पण द्यावार मनालनी शांतीला निलचेदेंक कुतेशीनाड. ");
INSERT INTO wbq_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","येनटीक की हे वडती, इदी निक येल्ला येरका उंडाद की, नु नी मोगुनदी तारण शेशाव? इंगा हे मोगुड, इदी निक यल्ला येरका उंडाद की, नु नी वडतीद तारण शेशाव? ");
INSERT INTO wbq_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","तर यल्ला प्रभुड प्रत्येक वगानकी फंची इच्चीनाड, इंगा यल्ला द्यावार प्रत्येक वगान फीलचीनाड, आल्ले वाड नडवाला. नीन आन्नी मंडळीलाक इल्ले आज्ञा इस्तान ");
INSERT INTO wbq_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","येवाड वगाड सुंता आय्यीने मनशी द्यावार तीकनुस फिल्चीनोड उंटे? तर वाड सुंताद चिंन्ह खोडायाराद. येवानदी सुंता कालेद इल्लोन मनशी द्यावार तीकनुस फिल्चीनोड उंटे? वाड सुंता शुस्कुनाराद. ");
INSERT INTO wbq_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","येनटीक की ना सुंताद येमाना महत्व उंडाद इंगा ना बेसुंताद येमाना महत्व उंडाद; पण द्यावार आज्ञालदी पालन शेशेदे आंता उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","विश्वासी आल्ले निल्वाला यल्ला वारनी द्यावार फिल्चीन्या, यप्पुड वार ख्रिस्त येशुन मिंदा विश्वास फेट्टीर. ");
INSERT INTO wbq_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","जर नु गुलाम उंडीनाप्पुड फीलचेदेंक वच्चीनाव? तर चिंता शेयाक; पण निक स्वंतत्र आय्येद उंटे तर दानदी उपयोग शेय. ");
INSERT INTO wbq_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","येनटीक की येवाड गुलाम उंडीनाप्पुड प्रभूला फीलचीनोड उंडाड वाड प्रभूला स्वतंत्र मनशी उंडाड; आल्ले येवाड स्वतंत्र उंडीनाप्पुड फीलचीनोड उंडाड वाड ख्रिस्तन दास उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","द्यावार मिमलान किंमत इच्ची कोनकेन तिस्कुनीनेद उंडाद, दिन कसोम मीर मनसुला दास कावाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","हे तम्मूडलु इंगा शेल्यांलू यवाड या स्थितीला फीलचीनोड उंडाड वाड आद्दे स्थितीला द्यावार संगा निलचेद. ");
INSERT INTO wbq_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","इप्पुड फेंडली कानोर कसोम नाक प्रभुन तिकनुस यादुच आज्ञा शिक्का लेद; पण, विश्वासयोग्य निलचेदेंक येवान मिंदा प्रभुड दया शेशीनाड इल्ला नीन वगाड उंडान आंकेन नीन संमती इस्तान. ");
INSERT INTO wbq_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","नाक वाटास्ताद की, इप्पुड परिस्थितीलोन संकटलान सुशी इदी बागा उंडाद की येवाड यल्ला उंडाड वाड आल्ले उंडाला. ");
INSERT INTO wbq_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","जर निक वडती उंडाद तर अलग आय्येद प्रयत्न शेय्याक. जर निक वडती लेद तर नु नी कसोम वडती फुडकाक. ");
INSERT INTO wbq_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","पण जरी नु फेंडली शेस्कुंटे तर नु पाप शेय्या लेद; इंगा कुवारी आनबीडा फेडली शेस्कुंटे तर आदी पाप शेय्या लेद; पण इल्लोनटोरकी संसाराला शारीरिक दुखल आय्यी इंगा इल्लोन शारीरिक दुखल मिक कावाराद इल्ला नाद इच्छा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","पण तम्मूडलाला नीन इदी आंटान की, इदी वेळ रव्वा उंडाद. इप्पुड, यवारकी वडतुल उंडाय वार वडती लेकुन्ने लेका बतकाला; ");
INSERT INTO wbq_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","इंगा येडशेतोर येडवाक वच्चीनार इल्ला, येव्वार आनंद शेस्तार वार आनंद शेय्यानोर लेका इंगा येव्वार कोंकेन तिस्कुन्टार वार इल्ला उंडाला की वार देगार येमीच लेद. ");
INSERT INTO wbq_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","इ दुन्याम संगा व्यवहार शेशेतोर इल्ला उंडाला की दुन्यामटोर कावाराद येनटीक की इ दुन्यामदी रिती इंगा व्यवहारलु बदलास्का फोयताय. ");
INSERT INTO wbq_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","नाक इल्ला वाटास्ताद मीर दुन्यामलोन वासनालनुस मुक्त उंडाला. येवाड फेंडली कानोड उंडाड वाड प्रभुन संगा संबंधित माटलाला, आंटे मनाम प्रभून यल्ला संतुष्ट शेशाम दानदी काळजी शेस्ताड; ");
INSERT INTO wbq_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","पन येवाड फेंडली आयनोड उंडाड वाड दुन्यामलोन माटलाद, आंटे वडतिन यल्ला संतुष्ट शेय्याला दानदी काळजी शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","इल्ला वारी भागलु आयताय येवार फेंडली कानोर इंगा कुंवारी आनबिडा उंडार आदी मनाम फयला इंगा आत्माला पवित्र उंडाला, इल्लोन प्रभुन माटला बद्दल चिंता शेस्ताद; पण याद फेंडली आयनेद उंडाद आदी दुन्याम माटलाद, आंटे मना मोगुन यल्ला संतुष्ट शेयदून दानदी काळजी शेस्ताद. ");
INSERT INTO wbq_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","इदी नीन मी फायदा कसोमे आंटान, मीमलान फसाय मताला आंकेन लेद; पण मीर विचलित कावान्दे प्रभुन सेवाला आंटी उंडाला आंकेन शपतान. ");
INSERT INTO wbq_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","जर येवारकी आना इल्ला वाटास्ताद की, वाड वान आनबिडाद हक्क मतेस्तुनाड, इंगा येवात दानदी फेंडली वय यल्ली फोयतुनाद इंगा आल्ले गरज उंडाद, तर यल्ला वानदी इच्छा उंडी आल्ला वार शेय्याला, दिंटल्या पाप लेद, वाड फेंडली शेस्कुनाला. ");
INSERT INTO wbq_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","पण यवाड फेडली शेस्कुनेद लेद इल्ला निर्णय तिस्कुनीनाड, येवानकी येमीच गरज लेद इंगा येवाड वान इच्छामिंदा अधिकार फेटताड इंगा इल्ला येवाड मना कुतुरनी कुंवारी फेट्टेद मनला ठराय मतनिन्टे तर वाड शिंगार शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","दिन कसोम येवाड मना कुंवारी आन्बिडाद फेंडली शेशी इस्ताड वाड बागा शेस्ताड; पण येवाड फेंडली शेशीयाड वाड शेंगेम शिंगार शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","फेंडली आयने आंडीदान मोगुड जित्ता उंडाड आड नंताक आदी वान संगा कट्टीनेद उंडाद, पण जर दान मोगुड सच्ची फो तर, फक्त प्रभूला विश्वासीने उंटे, दानदी इच्छा उंटे तर दानकी वाटाशी वान संगा आदी फेंडली शेस्कुनी शेकास्ताद. ");
INSERT INTO wbq_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","पण आदी जर फेंडली शेस्कुनांदे निलच्या तर, नाद मत इल्ला उंडाद, आदी आंडीद शेंगेम आशीर्वादित आय्यी इंगा नीन मानास्तान की, ना नोना पण द्यावारदी आत्मा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","'इप्पुड मूर्तीलाक येक्पिचीने नंजुर बद्दल, दिन बद्दल मनाक आंदारकी येरका उंडाद की इदी आनिनेद माटा उंडाद; पण आदी ज्ञान मनशीन घमंडी बनाय मतुताद, तर प्रेम मंदीन विश्वासला प्रोत्साहित शेस्ताद. ");
INSERT INTO wbq_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","मनाक वगा माटा येरका उंडाद, येवानकी इल्ला वाटास्ताद की, वानकी येमाना येरका उंडाद पण वानकी आल्ला येरका लेद यल्ला वानकी येरका बेक. ");
INSERT INTO wbq_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","पण येवाडाना द्यावारमिंदा प्रेम शेस्ताड तर आ मनशीन द्यावार गुरुतु फटताड. ");
INSERT INTO wbq_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","दिन कसोम, मुर्तींला मुंदार येक्पिचिने माटलु तिने बद्दल मनाक येरका उंडाद की, “खरेम आंटे दुन्यामला मूर्तीद येमीच अस्तित्व लेद” इंगा “वगान इडशी इंगा येवाडच द्यावार लेड,” ");
INSERT INTO wbq_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","काही मंदी इल्ला आंटार स्वर्गला इंगा पृथ्वी मिंदा शेंगेम द्यावारलु उंडाय, येनटीक की काही मंदी शेंगेम द्यावारलाद इंगा शेंगेम प्रभुलाद पुजा शेस्तार, ");
INSERT INTO wbq_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","पण मनाकसोम फक्त वक्काडे द्यावार उंडाड, येवाड मना आब्बाड उंडाड. वानकसोमे मनाम जगास्ताम इंगा वाडे आंता बनाय मतनाड इंगा वक्काडे प्रभु येशु ख्रिस्त उंडाड. वाननोट आन्नी माटलु अस्तित्वला वच्चीनाय इंगा वाननोटे मनाद जीवन उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","पण इदी ज्ञान प्रत्येक मनशी देगार लेद येनटीक की काही मंदी इप्पुड पण मूर्तीला संगा इंता जुडाशी उंडार, तर वार यप्पुड मुर्तिलाक येक्पिचिनेद आन्नाम तीन्टार वारकी वाटास्ताद की इदी मुर्तिलाक येक्पिचिनेद उंडाद इंगा वारदी विवेक निर्बल उंडीने कसोम अशुद्ध आय फोइताद. ");
INSERT INTO wbq_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","पण आन्नाम मनालनी द्यावार देगार येकाफोद, मनाम आदी तिनाक उंटे तरी येमीच नुकसान लेद इंगा तिन्टे येमीच फायदा लेद. ");
INSERT INTO wbq_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","पण मिद इदी स्वातंत्र विश्वासला कमजोर उंडीने मंदी कसोम, यादबी प्रकारे, अडखळन कावाराद आंकेन काळजी तिस्कोंडा. ");
INSERT INTO wbq_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","जर येवारदी आना विवेक कमजोर उंडाद इंगा वाड नी लेकोन ज्ञानी मनशीन मुर्ती उंडीने गुडीला तीनेताप्पुड सुसते, तर वाड मुर्तिलाक येक्पिचिनेद आन्नाम तिनदेंक उत्साहित काका फोई येम? ");
INSERT INTO wbq_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","इंगा नी इल्लोन ज्ञान कसोम विश्वासला कमजोर उंडीने नी तम्मुळलाद इंगा शेल्यांलाद आत्मिक रुपता नाश आय फोई येवार कसोम ख्रिस्तड जेम इडश्या. ");
INSERT INTO wbq_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","पण मीर यप्पुड इल्ला मी विश्वासी तम्मुळला इंगा शेल्यांला विरुद्धला पाप शेशी वार कमजोर विवेक की तकलीफ इस्तार, आप्पुड मीर ख्रिस्तन विरुध्दला पाप शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","दिन कसोम, जर नाद तिनेद आन्नाम ना विश्वासी तम्मुन इंगा शेल्याल कसोम पापदी कारण आयताद तर नीन वार कसोम पाप शेशेद कारण कावाराद दिन कसोम नीन वापस यप्पुडूच नंजुर तीनाक फोयान. ");
INSERT INTO wbq_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","इंगोगोर लेका नीन स्वतंत्र लेन येम? नीन प्रेषित लेन येम? नीन मना प्रभु येशुन सुडालेद येम? प्रभुला मीर ना मेहनतदी फळ लेर येम? ");
INSERT INTO wbq_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","जरी नीन इंगोगोर कसोम प्रेषित लेकुंडा, तरी नीन मीकसोम प्रेषित उंडान येनटीक की मीर प्रभुला नीन प्रेषित उंडान आंका शिक्का उंडार. ");
INSERT INTO wbq_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","येवार नाक दोष आंचतार वारकी उद्दे नाद उत्तर उंडाद: ");
INSERT INTO wbq_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","माक येम मी इंटल्या नीलची तिनेदतागेद अधिकार लेद यम? ");
INSERT INTO wbq_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","इंगोगोर प्रेषितलु, प्रभुन तम्मुळलु इंगा कैफाड, शेस्तार आल्ले मिम यादाना विश्वासी शेल्यालनी वडती बनाय मतकेन, मा संगा येतकेन तीरगेद माक अधिकार लेद येम? ");
INSERT INTO wbq_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","का फक्त नाक इंगा बर्णबानकी फनी शेशेद लेद इल्ला अधिकार उंडाद? ");
INSERT INTO wbq_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","स्वतः खर्चता सैनिक आंकेन सेवा शेशेतोड इल्ला येवाड उंडाड? येवाड अनगुरदी बगीचा आंचताड इंगा दानलोनी फळलु तिनाड? इंगा येवाड मेंढर्यालदी खांड राखास्ताड इंगा मेंढर्यालदी फाल तागाड? ");
INSERT INTO wbq_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","नीन इ माटलु मनशी रीतलेका शेपतुनान येम? मोशेन नियमशास्त्र पण इद्दे शप्पाद येम? ");
INSERT INTO wbq_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","येनटीक की, मोशेन नियमशास्त्रला राशिनेद उंडाद की, 'मळणी शेशे यद्दद मुती कट्टाक.' द्यावारकी फक्त यद्दद चिंता उंडाद येम? ");
INSERT INTO wbq_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","इंगा विशेष शेशी मना कसोम आंटाड? इदी नक्की मना कसोमे राशिनेद उंडाद येनटीक की नागराशेतोड आशाता नागरायाला इंगा येवाड पेरणी शेस्ताड वाड मनाक हिस्सा शिक्के आशाता शेय्याला. ");
INSERT INTO wbq_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","मिम जर मी कसोम आत्मिक माटा पेराशीनाम, तर माक मी तीकनुस दैहिक माटलाद कापणी शेशेद उंडाद इदी शेंगेम फेद्दाद माटा उंडाद येम? ");
INSERT INTO wbq_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","जर इंगोगोर मी मिंदुडदी इदी अधिकार फंचकुंटार, तर मीम विशेष शेशी इल्ला येनटीक शेय्याराद? इंगा तरी मीम इ अधिकारदी उपयोग शेय्यालेद, पण ख्रिस्तन शुभवर्तमाननी मिम थांबाय मताराद दिन कसोम, मिम आंताच सहन शेस्ताम. ");
INSERT INTO wbq_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","येव्वार गुडी लोन पवित्र वस्तुलाद सेवा शेस्तार वार गुडीलोन वंटा तीन्टार इंगा येव्वार वेदी मुंदार सेवा शेस्तार वार वेदी संगा भागीदार आतार, इदी मिक येरका लेद यम? ");
INSERT INTO wbq_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","प्रभुड आल्ले आज्ञा इच्चीनाड की, येव्वार शुभवर्तमानदी घोषणा शेस्तार वार शुभवर्तमानताने जगाश्यार, ");
INSERT INTO wbq_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","पण नीन दिंटल्योन यादुच अधिकारदी उपयोग शेय्यालेद इंगा नीन इ माटलु दिन कसोम रायान की ना कसोम येमाना शेय्याबेक येवाडाना नन्नु ना ई गर्वनुस दुराम शेशी दिनकाना नीन नाद सच्ची फोय्येद शिंगार समजास्तान. ");
INSERT INTO wbq_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","येनटीक की जरी नीन शुभवर्तमानदी घोषणा शेस्तान, तरी घमंड शेशेद नाक येमीच कारण लेद येनटीक की इदी नाक शेय्याने बेक; नीन शुभवर्तमान शप्पान, तर ना मिंदा धिक्कार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","येनटीक की, नीन जर नाच्छाता शुभवर्तामानदी घोषणा शेस्तान, तर नाक पगार शिक्ताद, पण ना इच्छा विरुध्दला उंटे, तरी नाक इदी जबाबदारी इच्चीनेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","तर नाद पगार येम उंडाद? इद्दे की, नीन शुभवर्तमान शेप्पेताप्पुड आदी फुकट शेप्पाला इंगा शुभवर्तमान अधिकारदी नीन दुरुपयोग शेय्याराद. ");
INSERT INTO wbq_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","येनटीक की नीन आन्नी तीकनुस स्वतंत्र उंडी पण इंगा शेंगेम मंदी शिक्काला आंकेन नीन आंदार दास आयतीन. ");
INSERT INTO wbq_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","नीन यहुद्योर कसोम यहुदी आयतीन; नीन नियमशास्त्र अधीन लेकुंटीन तरी नीन नियमशास्त्र अधिन आयतीन दिन कस्रोम की, वारनी जक्का दावाला येव्वार नियमशास्त्र अधीन उंडार. ");
INSERT INTO wbq_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","(नीन द्यावार नियमला बैट्या लेन, पण ख्रिस्तन नियमला अधीन उंडान) नीन नियमशास्त्र अधीन उंडीनोरनी जक्का दावाला, आंकेन नियमशास्त्र अधीन इल्ला आयतीन. ");
INSERT INTO wbq_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","इंगा नीन कमजोर उंडीनोरनी जक्का दावाला, आंकेन नीन कमजोर उंडीनोर कसोम कमजोर आयतीन. नीन आंता मंदी कस्रोम आंताच आयतीन, दिन कसोम की यल्लाना यल्ला वार लोन वगानदी तरी तारण कावाला. ");
INSERT INTO wbq_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","इंगा नीन इदी आंता शुभवर्तमान कस्रोम शेस्तान, दिन कसोम नीन पण दांटल्या सहभागी कावाला. ");
INSERT INTO wbq_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","स्पर्धाला फारेताप्पुड तर आंदारुच फारतार पण बक्षीस वगानके शिकताद, इदी मीक येरका लेद यम? दिन कसोम इल्ला फारना की, मिरे झिकायाला. ");
INSERT INTO wbq_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","स्पर्धा कसोम मेहनत शेशेतोड प्रत्येक मनशी प्रत्येक माटाला दम फटेतोड उंटाड. वार नाशवंत मुकुट शिक्के कसोम इल्ला शेस्तार पण मनाम अविनाशी मुकुट मिळाय मतेदेंक इल्ला शेस्ताम. ");
INSERT INTO wbq_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","दिन कसोम नीन तर इल्ले फारतान पण व्यर्थ लेद, नीन पण आल्ले गुद्दीगास लढास्तान, घालीमिंदा गुद्दलाडेतोन तीरना लढायान. ");
INSERT INTO wbq_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","पण नीन ना फईक वगा खिलाडी लेका शिस्त आंचतान इंगा दानकी आदी शेयदेंक नेरपुतान याद दानकी शेय्याबेक लेकाते इल्ला कावारादकी नीन इंगोगोरकी नेरपी स्वताने अयोग्य ठरायाराद. ");
INSERT INTO wbq_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","हे तम्मुडलु इंगा शेल्यांलु, नाक इल्ला वाटास्ताद की मिक इदी येरका उंडाला, मना आंदार पूर्वजलु मोडाम किंदा सुरक्षित उंडीर. वार आंदार तांबडा समुद्र दाटी फोईर. ");
INSERT INTO wbq_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","मोशेन अनुयायी रूपला वार आंदार मोडाम इंगा समुद्रला बाप्तिस्मा तिस्कुनीर. ");
INSERT INTO wbq_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","वार आंदार वक्काटे आत्मिक आन्नाम तीनीर. ");
INSERT INTO wbq_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","इंगा वार वक्काटे आत्मिक नेळ तागीर येनटीक की वार-वार यंका नडशे आत्मिक खडकनुस तागतुनीर इंगा आदी खडक ख्रिस्त उंड्या. ");
INSERT INTO wbq_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","गान द्यावार वारदिंटल्या शेंगेम मंदी बद्दल आंनदी लेकुंड्या इंगा वारी फिनग्याल मरू भुमिला फडीन्या. ");
INSERT INTO wbq_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","इंगा इ माटलु मना कसोम उदाहरण आंकेन घडाश्या, दिन कसोम की मनाम पण वार लेका वाईट माटलाद लालुच शेय्याराद यल्ला वार शेशीनीर. ");
INSERT INTO wbq_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","वारपैकी काहीमंदी मूर्तिपूजक उंडीर आल्ला कावाकुंडा. पवित्रशास्त्रला राशीनेद उंडाद, “मंदी तीनदेंक तागदेंक किंदा कुसनीर इंगा वार मूर्तीलामुंदार नाचायदेंक लेशीर.” ");
INSERT INTO wbq_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","यल्ला वार दिंटल्या काही मंदी शेशीर आल्ला व्यभिचार मनाम पण यप्पुडूच शेय्याराद. दानदी परिणाम इल्ला आय्या की, वगा नाळाला तेविस हजार मंदी सच्ची फोइर. ");
INSERT INTO wbq_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","इंगा वारदिंटलोन काही-काही मंदी सुशीर आल्ला मनाम ख्रिस्तद परीक्षा सुडाराद. दानदी परिणाम इल्ला आय्या की, वार फामलु कोरक्या आंका सच्ची फोइर. ");
INSERT INTO wbq_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","कुरकुर शेयाकुंडा, यल्ला वार दिंटल्योन काही मंदी शेशीर, दानदी परिणाम इल्ला आय्या की, वार मृत्यूदूत शेयता सच्ची फोइर. ");
INSERT INTO wbq_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","इ माटलु वार संगा दिन कसोम आय्या की मनाक उदाहरण कावाला आय मना चेतावणी कसोम मनाम यवारमिंदा युगदी शेवटला नीलस्तुनाम राशे दिंटल्या वच्चीन्या. ");
INSERT INTO wbq_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","दिन कसोम नीन विश्वासला मजबूत नीला फडी उंडान इल्ला येवार विचार शेस्ताडर वाड मनाम फडाराद आंकेन जपायाला. ");
INSERT INTO wbq_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","याद मनशिक सामान्य लेद इल्ला यादुच परीक्षाला मिर फडालेद. पण द्यावार विश्वसनीय उंडाड. मी सहनशक्ती काना आतुक वाड मिद परीक्षा तिस्कुनाक फोई. पण आ परीक्षासंगा, दांटलेल बैटीक फडेद दावा पण तैयार शेशी. आंटे मिक सहन शेय्या दावाला. ");
INSERT INTO wbq_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","दिन कसोम, ना प्रिय मंदी मूर्तीपूजा नुस फारी फोंडा. ");
INSERT INTO wbq_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","नीन मीमलान बुध्दीमान समजाशी माटलाडतुनान. नीन यम माटलाडतुनान दानदी मीरे न्याय शेयांडा. ");
INSERT INTO wbq_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","याद अंगूरदी रस मनाम प्रभुभोज वेळला द्यावारकी धन्यवाद इच्ची तागताम आदी ख्रिस्तन रक्तामदी सहभागीता उंडीनेद प्याला लेद येम? याद रोट्या मनाम इरगा मतुताम आदी ख्रिस्तन फइद सहभागीताद रोट्या लेद येम? ");
INSERT INTO wbq_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","इंगा मनाम सनामंदी उंडी वगाटे रोट्या तेम्पी तिन्टाम, दिन कसोम शेंगेम उंडी पण मनाम वगाट उंडाम, येनटीक की मनाम आंदार वगाटे रोट्याक भागीदार उंडाम. ");
INSERT INTO wbq_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","इंगा येवार फुट्टीनगाला इस्रायली उंडार वारनी सुडांडा.येम पण वेदीमिंदा अर्पण शेस्तार आदी वार तीनीगास वेदीक भागीदार आयतार. ");
INSERT INTO wbq_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","तर नीन यम दानदी अर्थ येम उंडाद? मुर्तिक येक्पिचीने वस्तुद येमाना महत्व उंडाद येम? का आ मूर्तीद येमाना महत्व उंडाद? ");
INSERT INTO wbq_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","लेद, पण उलटा नाद आनेद अर्थ इल्ला उंडाद की, याद अर्पण द्यावार कसोम यहूदी लेनोर मंदी शेस्तार आदी अर्पण दैयालकी शेस्तार, द्यावारकी शेय्यार इंगा मीर दैयालकी भागीदार कावाला इल्ला नाक वाटायाद. ");
INSERT INTO wbq_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","मीर द्यावार इंगा दैयाम इल्ला रोंडू प्यालाल तागी शकायार. मीर प्रभुन मेज इंगा दैयामदी मेज इल्ला रोंडू इटलाक भागीदार आय्यी शकायार. ");
INSERT INTO wbq_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","मनाम प्रभुनकी कोफाम येका वस्ताम यम? मनाम द्यावारकाना सामर्थ्यशाली उंडाम येम? ");
INSERT INTO wbq_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","“इंगा मी दिंटल्योन्टोर काही मंदी आंटार मिम येमी पण शेयदेंक स्वतंत्र उंडाम.” पण आन्नी माटलु मंदी कसोम हितकारक लेव. “दिंटल्योन्टोर काही मंदी आंटार मिम येमी पण शेयदेंक स्वतंत्र उंडाम.” पण आन्नी माटलु मंदीक सामर्थ्ययुक्त आयदेंक मदत शेय्याव. ");
INSERT INTO wbq_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","येवारुच स्वतादे फायदा सुडाराद तर इंगोगोरदी पण सुडाला. ");
INSERT INTO wbq_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","संताला याद नंजूर आम्मुतार विवेक बुद्धीता चौकशी शेय्यानदे आ नंजूर बद्दल यादुच प्रश्न आडगांदे तिनांडा. ");
INSERT INTO wbq_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","येनटीक की यल्ला पवित्रशास्त्र आंटाद, “पृथ्वी मिदुंडदी आंताच प्रभुनदी उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","अविश्वासी मंदी पैकी येव्वाराना मीमलान तीनदेंक फिलची इंगा मीक फोयेद उंटे तर विवेक बुद्धीता चौकशी शेय्यानदे यादुच प्रश्न आडगानदे मी मुंदार सदरीनेद आंता तीनांडा. ");
INSERT INTO wbq_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","पण जर येवाडाना मीक शप्पीर की, “इदी नंजूर मुर्ती कसोम अर्पण इच्चीनेद उंडाद,” तर विवेक बुद्धी कसोम इंगा या मनशी शेप्या वान कसोम तीनाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","इंगा यप्पुड नीन “विवेक” आंटान तर नाद आनेद अर्थ नीद विवेक लेद तर इंगोगोरदी इदी फक्त वगाट कारण उंडाद येनटीक की ना स्वतंत्र्यद इंगोगोर सदसदविवेक बुध्दीता न्याय येनटीक कावाला? ");
INSERT INTO wbq_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","जर नीन धन्यवाद शेशी रोट्या तीनटान तर नन्नु दोषी येनटीक ठराय मतुतार येनटीक की इ माटला कसोम तर नीनद्यावारकी धन्यवाद इस्तान. ");
INSERT INTO wbq_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","दिन कसोम मीर तीनना का तागना, इंगा येमाना शेस्ते आंताच द्यावार गौरव कसोम शेयंडा. ");
INSERT INTO wbq_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","यहुदी मंदी, यहूदी लेनोर मंदी इंगा द्यावार मंडळीलाक अडखळन आय्येद कारण कावाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","यल्ला नीन प्रत्येक बाबतीला आंदारनी संतुष्ट शेशेद प्रयत्न शेस्तान इंगा ना कसोम यम हितकारक उंडाद इदी शेय्यान पण इंगोगोर कसोम शेस्तान की शेंगेम मंदीद तारण कावाला. ");
INSERT INTO wbq_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","नीन यल्ला ख्रिस्तद अनुकरन शेस्तान आल्ले नाद अनुकरण शेशेतोर कांडा. ");
INSERT INTO wbq_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","नीन मीद प्रशंसा शेस्तान येनटीक की मीर नाद नेहमी ध्यानाम तीस्तार इंगा नीन मीक नेमाशी इच्चीने शिक्षान, मजबुतीता पाळास्तार. ");
INSERT INTO wbq_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","पण मीक इदी येरका कावाला इल्ला नाक वाटास्ताद की, ख्रिस्त इड प्रत्येक मणशी प्रमुख उंडाड इंगा प्रत्येक मनशी इड आंडीदान प्रमुख उंडाड इंगा द्यावार ख्रिस्तन प्रमुख उंडाड ");
INSERT INTO wbq_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","प्रत्त्येक मणशी यवार प्रार्थना शेशेताप्पुड इंगा संदेश इच्चेताप्पुड मनाद नत्ती मुस्कुंटाड वाड मना प्रमुखदी आंटे ख्रिस्तद अपमान शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","पण प्रत्येक आंडीद याद मनाद नत्ती मुस्कुनान्दे प्रार्थना शेस्ताद इगा मंदीला द्यावारदी संदेश शपताद आदी मनशीद आंटे मोगुनदी अपमान शेस्ताद येनटीक जी आदी आंडीद टकली शेस्कुन्ने आंडीदान लेकाने उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","जर आंडीद मनाद नत्ती मुस्कुनाद तर आदी मना यंडकाल कोस्काडाला येनटीक की यंडकाल कोशेद लेकुटे टकली शेस्कुनेद आंडीदानकी शिग्गुद माटा उंडाद. तर आदी मनाद नत्ती मुस्कुनेद. ");
INSERT INTO wbq_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","येनटीक की मनशी द्यावार स्वरूप इंगा गौरवदी चित्र उंडाड दिन कसोम मनशी नत्ती मुस्कुनेद शिंगार लेद. पण आंडीद मणशी गौरव उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","येनटीक की मनशी आंडीदान तीकनुस कालेद पण आंडीद मणशी तिकनुस आय्यीनाद. ");
INSERT INTO wbq_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","इंगा मनशी आंडीदान कसोम निर्माण कालेद, तर आंडीद मनशी कसोम निर्माण शेशीदेंक वच्चीनाद. ");
INSERT INTO wbq_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","येनटीक की देवदूतलु सुस्तुनार दिन कसोम वगा आंडीदानकी मना नत्तीमिंदा आधीकारदी चिन्ह धारण शेशेद इदी योग्य उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","तरीपण प्रभूला आंडीद मनशी नुस वेगळा लेद इंगा मणशी आंडीदान नुस वेगळा लेड. ");
INSERT INTO wbq_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","येनटीक की आंडीद मणशी तीकनुस उंडाद, आल्ले मनशीक पण आंडीदे जन्म इच्चीनाद. पण आन्नी माटलु द्यावार तिकनुस उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","इदी मीर स्वताने ठराय मतना की, नत्ती मुस्कुनान्दे आंडीद द्यावारदी प्रार्थना शेशेद इदी योग्य उंडाद यम? ");
INSERT INTO wbq_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","मनशी फेद्दा यंडकाल वाढाय मतुते तर इदी वान कसोम शिग्गुद माटा उंडाद. इल्ला निसर्ग सुध्दा मीक नेरपाद यम? ");
INSERT INTO wbq_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","पन आंडीद फेद्दा यंडकाल फेटते इदी दानकी गौरव उंडाद येनटीक की दानकी दानी यंडकाल मुशेदेंक इच्चीनेय उंडाय. ");
INSERT INTO wbq_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","जर यवारकी आना वाद शेशेद उंटे तर वारकी इदी येरका बेक, माद इल्ला रीत लेद इंगा द्यावार मंडळीलादबी लेद. ");
INSERT INTO wbq_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","इप्पुड मुंदारदी आज्ञा इच्चेताप्पुड नीन मीद प्रशंसा मंडळीला शेय्याक वच्चीनान येनटीक की मीद वगातळा वस्ते फायदा लेद पण नुकसान आयताद. ");
INSERT INTO wbq_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","पहिला, नीन इदी इंटान की, यप्पुड मीर मंडळीला वगातळा वस्तार, आप्पुड मिनडमा फुट उंटाद इंगा काही प्रमाणला दानमिंदा विश्वास फेटताम. ");
INSERT INTO wbq_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","दिन कसोम की, येव्वार मी नडमा खरेम उंडार वार प्रकट कावाला आंकेन मीनडमा फुट उंडा बेक. ");
INSERT INTO wbq_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","यप्पुड मीर वगातळा वस्तार आप्पुड मीर येम तीन्टार आदी प्रभू भोज लेद. ");
INSERT INTO wbq_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","येनटीक की मीर भोजन शेस्तार आप्पुड मी दांटल्योन प्रत्येक मनशी मुंदारकी फोई स्वताने तिनका फडताड. वगाड आकालता आल्ले निलस्ताड तर इंगोगोड अतीतृप्त आय फोइतार. ");
INSERT INTO wbq_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","तीनदेंक तागदेंक मीक इल्लु लेद यम? का मीर द्यावार मंडळीन तृच्छ मानास्तार इंगा या गरीब तम्मूळलु इंगा येल्यांलु येव्वार देगार येमीच लेद वारनी शिग्गुना केडपुतार? नीन मीमलान यम आनाला? नीन मीद प्रशंसा शेयदून यम? इ बाबतीला नीन मीद प्रशंसा शेय्यान. ");
INSERT INTO wbq_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","येनटीक की प्रभुन तीकनुस याद शिक्षा नाक शिक्या आद्दे नीन मीक इस्तीन. प्रभु येशुन, या मोब्बुला विश्वासघात शेशी फट्टी इद्देंक वच्या. वाड रोट्या तिस्कुन्या, ");
INSERT INTO wbq_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","इंगा उपकार माना आदी इरगा मत्या इंगा आन्या, “इदी नाद फय उंडाद, याद नीन मी कसोम इस्तान. नाद ध्यानाम शेशे कसोम इदी शेयांडा.” ");
INSERT INTO wbq_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","इल्ले वाड भोजन शेशीनेंका प्याला तिस्कुन्या इंगा आन्या, “इदी प्याला ना रक्तामगोन आईनेद कोता करार उंडाद. यप्पुड पण मीर इदी ताग्यार आप्पुड नाद ध्यानाम शेशे कसोम इदी शेयांडा.” ");
INSERT INTO wbq_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","येनटीक की यन्नी तुकुला मीर इदी रोट्या तीन्टार इंगा इदी प्याला तागतार, आन्नी तुकुला मीर प्रभुन सावनी वाड वच्ची नंताक घोषणा शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","दिन कसोम येवाडाना अयोग्य रितीता प्रभुनदी रोट्या तिनी लेकुटे प्याला तागी वाड प्रभुन फय इंगा रक्ताम विषयी दोषी ठराशी. ");
INSERT INTO wbq_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","आंकेन मनशी स्वतःद परीक्षा शेयाला इंगा आप्पुड इदी रोट्या तीनाला इंगा इ प्यालान तागाला. ");
INSERT INTO wbq_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","येनटीक की जर प्रभुन फइद अर्थ तेल्चकुनान्दे येवाड इ रोट्यान तिन्टाड इंगा प्यालान तागताड तर वाड तिनीगेस इंगा तागीगेस स्वतःमिंदा दंड जक्कुंटाड. ");
INSERT INTO wbq_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","इद्दे दिन कसोम मी दिंटल्योन शेंगेम मंदी कमजोर, बिमार उंडार इगा काही मंदी सच्ची पण फोइनार. ");
INSERT INTO wbq_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","पण जर मीम माद परीक्षा शेशाम तर मा मिंदा न्यायदी प्रसंग दाकाफोई. ");
INSERT INTO wbq_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","पण प्रभुड माद न्याय शेशी आप्पुड माक शिस्त आंची, दिन कसोम की, दुन्याम लोन बाकी मंदी लेका माक पण शिक्षा कावाराद. ");
INSERT INTO wbq_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","आंकेन ना तम्मूळलु इंगा शेल्यांलु यप्पुड मीर भोजन शेयदेंक वगातळा वस्तार, आप्पुड वगामेंगार कसोम थाबायंडा. ");
INSERT INTO wbq_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","जर येवारकी आना खरेमी आकाल आय्यींटे वाड इंटल्या तीनाला दिन कसोम की मिद वगातळा वच्चेद दंडकी कारण ठरायाराद. नीन वच्यान आप्पूड इंगोगो माटलान शिंगार शेशान. ");
INSERT INTO wbq_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","हे तम्मुडलु इंगा शेल्यांलू आत्मिक दानला बद्दल, मिक येरका लेवाराद इल्ला नाक वाटायाद. ");
INSERT INTO wbq_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","यप्पुड मीर यहूदी लेनोर उंटीर, आप्पुड यल्ला नडवा मतदुर आल्ला मीर आ मुकी मुर्तीला यंका नडदुर. इदी मीक येरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","आनकेन नीन मीक शपतान की, द्यावार आत्मा गोन माटालाडेतोड यादुच मनशी इल्ला आनाड की, “येशु शापित उंडाड.” इगा पवित्र आत्मा शिवाय येवारुच “येशुड प्रभुड उंडाड,” इल्ला आनी शकायार. ");
INSERT INTO wbq_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","इप्पुड दानलु तर वेगवेगळा प्रकारी उंडाय, पण आत्मा वक्काटे उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","आल्ले सेवा पण वेगवेगळा प्रकारदी उंडाद, पण प्रभुड वक्काडे उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","इंगा फनुल पण वेगवेगळा प्रकारी उंडाय पण आन्नी फनुल शेशेतोड वाड द्यावार वक्काडे उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","पण आत्माद प्रकटीकरण इदी आंदार फायदा कसोम प्रत्येक मनशीक इच्चीदेंक वच्चीनाद. ");
INSERT INTO wbq_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","येनटीक की वगानकी आत्मा तीकनुस बुद्धी माटलु शिकताय, इंगा वगानकी आद्दे आत्मा इच्छाता ज्ञानता निंडी माटलाडेद योग्यता शिकताद. ");
INSERT INTO wbq_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","इंगोगोनकी आद्दे आत्माता विश्वास, इंगा वगानकी आद्दे आत्माता शिंगार शेशेद दान, ");
INSERT INTO wbq_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","इंगा वगानकी चमत्कार शेशेद शक्ती इंगा इंगोगोनकी भविष्य शेप्पेद शक्ती, तर येवारकी आत्माल ओळखाशेद, इंगा वगानकी वेगवेग‍‍‌ळा प्रकारी भाषाल माटलाडेद, इंगा वगानकी भाषालदी भाषांतर शेशी अर्थ शेप्पेद शक्ती इच्चीनेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","पण इ आन्नी माटलाला वक्काटे आत्मा फनी शेस्ताद. वादी मना इच्छालेका प्रत्येक मनशीक कृपादान फंची इस्ताद. ");
INSERT INTO wbq_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","येनटीक की यल्ला फय वगाट उंडाद इंगा दानी अवयवलु शेंगेम उंडाय इंगा वगा फइक आन्नी अवयवलु कुडी शेंगेम उंडी पण वगा फय उंडाद आल्ले ख्रिस्त उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","येनटीक की मनाम यहुदी इंगा युनानी उंटे, दास इंगा स्वतंत्र उंटे तरी वगा आत्माताने मना आंदारदी वगा फयलाने बाप्तिस्मा आइनाद इंगा मना आंदारकी वक्काटे पवित्र आत्माता शक्ती शिक्कीनाद. ");
INSERT INTO wbq_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","येनटीक की फय इदी वगाटे लेद तर शेंगेम अवयवलु कुडीगास वगाट उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","जर काल आन्या, 'नीन शेय लेन आंकेन नीन फइद भाग लेन', तर दान मिंदनुस आदी फइद भाग लेद इल्ला लेद. ");
INSERT INTO wbq_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","इंगा गुम्मा आन्या, 'नीन कन्नु लेन आंकेन फइद भाग लेन', तर दान मिंदनुस आदी फइद भाग लेद इल्ला लेद. ");
INSERT INTO wbq_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","आंता फय जर कंडले उंटे तर इनेदेंक यंदनुस वस्तुन्या? इंगा आन्नी गुम्माले उंटे तर घऊल यंदनुस तिस्कुना वस्तुन्या? ");
INSERT INTO wbq_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","पण, फइद प्रत्येक अवयव द्यावार वान इच्छाता आनशी फेट्टीनाड. ");
INSERT INTO wbq_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","जर आंता फय कुडी वक्काटे अवयव उंटे, तर येम फय उंटून्या? ");
INSERT INTO wbq_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","पन, इप्पूड शेंगेम अवयवलु तर उंडाय पण फय वक्काटे उंडाद, ");
INSERT INTO wbq_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","इंगा कन्नु शेइन आनी शकायाद की, 'नाक नीद गरज लेद', आल्ले नत्ती कालनी आनी शकायाद की, 'नाक नीद गरज लेद', ");
INSERT INTO wbq_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","तर उलट, फयलोनी आय अवयवलु याय शेंगेम अशक्त कमस्ताय आय आवश्यक उंडाय. ");
INSERT INTO wbq_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","इंगा फयलोन या अवयवकी मनाम सम्मान इस्ताम, आटलाद मनाम जास्त काळजी तीस्कुंटाम. दिन कसोम मनाम आ अवयवलान एटलान सुपियाराद आटलाक बट्टाल फेटताम. ");
INSERT INTO wbq_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","येनटीक की मनाक शोभाशी कमशे अवयवलाक बट्टालदी गरज लेद पण या भागकी गरज उंड्या दानके जास्त मान इच्ची द्यावार फय जोडस्नेड उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","दिन कसोम फयला यादुच मतभेद कावाराद तर अवयवलु वगामेगारदी सारखा काळजी तीस्कुनाला. ");
INSERT INTO wbq_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","इंगा वगाट अवयवकी दुख आयते तर दान संगा आंन्नी अवयवलाक दू:ख आयताद इंगा वगा अवयवदी गौरव आयते तर दान संगा आन्नी अवयवलु आनंद शेस्ताय. ");
INSERT INTO wbq_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","इप्पुड, मीर ख्रिस्तद फय उंडी इंगा अलग-अलग अवयवलु उंडार. ");
INSERT INTO wbq_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","इंगा द्यावार मंडळीला इल्ला नेमाशिनाड पहिला प्रेषित, दुसरा संदेष्टे, तिसरा शिक्षक; दाननंतर चमत्कार शेशेतोर, दान बाद रोगलु शिंगार शेशेतोर, सहाय्यक सेवा, व्यवस्था इंगा विविध प्रकारी भाषाल माटलाडेतोर इल्ला नेमाशीनाड. ");
INSERT INTO wbq_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","आंदारच प्रेषित उंडार यम? आंदारच शिक्षक उंडार यम? आंदार चमत्कार शेशेतोर उंडार यम? ");
INSERT INTO wbq_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","आंदारकीच रोगलु शिंगार शेशेद दान शिकीनाद यम? आंदार अन्य भाषाल माटलाडतार यम? आंदारच भाषालदी भाषांतर शेशी अर्थ शपतार यम? ");
INSERT INTO wbq_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","पण मीर शेंगेम फेद्दा-फेद्दा कृपादानलु शिक्केद इच्छा फेटना इंगा दिन शिवाय, नीन मिक वगाट शेंगेम शिंगार दावा सूपतान. ");
INSERT INTO wbq_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","जरी नीन मन्सुलाद इंगा द्यावारदूत भाषाला माटलाडतुन्याला पण ना नोना प्रेम लेद, तर नीन वाशेद तल्या इंगा झणझनाशेद झांज उंडान. ");
INSERT INTO wbq_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","इंगा जरी ना नोना संदेश इच्चेद वरदान उंडाद, नाक आन्नी रहस्यल इंगा आंता ज्ञान अवगत उंडाद इंगा कोंडाल हलाय मत्यान इंता ना नोना विश्वास उंडाद पण ना नोना प्रेम लेकुंड्या, तर नीन येमीच लेन. ");
INSERT INTO wbq_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","इंगा जरी नीन नाद आंता धन कंगाल इंगा गरीबोरकी तिनदेंक इच्यान इंगा नाद फय होमार्पण कसोम इच्यान पण जर नानोना प्रेम लेकुंड्या तर नाक येमीच फायदा लेद. ");
INSERT INTO wbq_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","प्रेम शेशेतोड व्यक्ती मना जीवनला दम फटताड, इंगा इंगोगोरमिंदा प्रेम शेस्ताड; इंगा इंगोगोरमिंदा कालाड, इंगा वाड स्वताद बढाई शेय्याड, इंगा वाड घमंडी पण लेकुंटाड. ");
INSERT INTO wbq_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","वाड इंगोगोरमिंदा अन्याय शेय्याड, वाड फक्त स्वतादे फायदा सुडाड, वानकी लग्गान कोफाम दाद, इंगा येवाराना वान संगा वाईट वागास्ते तर वाड वारनुस बदला तीस्कुनाड. ");
INSERT INTO wbq_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","इंगा वाड वाईट फनुलाता यप्पुडूच आनंदित काड. पण सत्यता आनंद मानास्ताड. ");
INSERT INTO wbq_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","वाड आन्नी माटलु सहन शेस्ताड, वाड आन्नी माटला मिंदा विश्वास फेटताड, इंगा वाड आन्नी माटलाद आशा फेटताड. ");
INSERT INTO wbq_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","वानदी प्रेम यप्पुडूच संपायाद; भविष्यवाणील संपाशी, अन्य भाषाल उंटे आय गायब आयफोई, ज्ञान उंटे तर नष्ट आयफोई; ");
INSERT INTO wbq_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","येनटीक की मनाद ज्ञान अपूर्ण उंडाद, नीन अपूर्ण भविष्य शपतान. ");
INSERT INTO wbq_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","पण यप्पुड पूर्णत्व वच्ची आप्पूड जे अपूर्ण उंडाद आदी नष्ट आयफोई. ");
INSERT INTO wbq_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","यप्पुड नीन बिडा उंटीन, आप्पुड बीडालेका माटलाडतुंटीन, नीन बीडालेका विचार शेस्तुंटीन. बीडालेका समजास्तुंटीन. पण यप्पुड नीन फेद्दावोड आतीन, आप्पुड नीन शिन्नावोरी माटलु इड्सकाडतीन. ");
INSERT INTO wbq_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","इप्पुड मनाक आरसाला अस्पष्ट कमस्ताद, पण यप्पुड पूर्णत्व वच्ची आप्पुड कंडला मुंदार सुशाम. इप्पुड मनाक आन्नी माटलाद ज्ञान लेद, पण यप्पुड मनाम स्वर्गलोंक फोयाम मनाद ज्ञान आल्ले आयफोई, यल्ला इप्पुड द्यावारदी मना बद्दल उंडाद, ");
INSERT INTO wbq_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","दिन कसोम इप्पुड मुड माटलु उंडाय याय मनाक शेस्केन उंडा बेक द्यावार मिंदा विश्वास फेट्टेद, आत्मविश्वासता वाड येम मनाक इच्ची आदी शिक्केद आशा फेट्टेद, इंगा इंगोगोर संगा प्रेम शेशेद. पण इ मुड माटलाला आंदारकाना फेद्दाद इंगोगोर संगा प्रेम शेशेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","इंगोगोर मिंदा प्रेम शेस्केन मिद जीवन जगायना इंगा आत्मिक दानला कसोम उत्सुक उंडांडा इंगा विशेष शेशी भविषवाणी शेशेद इच्छा फेटना. ");
INSERT INTO wbq_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","येव्वारकी अन्य भाषा माटलाडेद दान उंडाद वाड खरेम सुस्ते मनशीसंगा माटलाडाड तर द्यावारसंगा माटलाडताड येनटीक की वाड येम माटलाडताड इदी येव्वारकीच तेलवाद. पवित्र आत्मा तीकनुस वाड रहस्यय माटलु माटलाडताड. ");
INSERT INTO wbq_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","पण यवाड भविष्यवाणी शेस्ताड वाड मंदीद आत्मिक वाढ, प्रोत्साहन इंगा शांती माटलु माटलाडताड, ");
INSERT INTO wbq_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","येवान देगार अन्य भाषाला माटलाडेद दान उंडाद, वाड आध्यात्मिक रूपता स्वताद वाढ शेस्कुंटाड, पण येवानकी भाविषवानी शेशेद दान उंडाद वाड संपूर्ण मंडळीद वाढ शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","मीर आंदार अन्य भाषाला माटलाडाला, पण विशेष शेशी मीर भविष्यवाणी शेय्याला इल्ला नाद इच्छा उंडाद येनटीक की येवाड अन्य भाषाला माटलाडताड, वानकाना येवाड भविष्यवाणी शेस्ताड वाड फेद्दावोड उंडाड. दिन कसोम की, मंडळीद वाढ कावाला. ");
INSERT INTO wbq_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","इप्पुड, तम्मूडलु इंगा शेल्यांलु, जर नीन मितिकुड अन्य भाषाला माटलाडेदेंक वस्तीन की मिक येम फायदा? मि फायदा आय्ये कसोम नीन मीतिकुड प्रकटीकरण, द्यावारदी ज्ञान, द्यावार तिकनुस भविष्यवानी लेका नेरपुकाम येतकेन दावा वद्दो येम? ");
INSERT INTO wbq_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","जर निर्जीव संगीत वाद्यल उदा. बासरी, विणा लेका आवाज तीशेदेनलेका उंडाय जर आ वाद्यल आटला तीकनुस येल्ले वेगवेगळा आवाजाला फरक स्पष्ट कमसाक फो, तर येव्वारकी बासरी इंका वीणा मिदां याद संगीत वास्तुनार आदी यल्ला तेलची? ");
INSERT INTO wbq_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","इंगा जर कर्णा अस्पष्ट आवाज तिस्ते तर लढाई कसोम यवाड तैयार आय्यी? ");
INSERT INTO wbq_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","आल्ले मीर पण इंगोगोर संगा साफ-साफ माटलाडा कुंटे तर मिद येवारकी आना यल्ला तेलची? येनटीक की मीर हवाला माटलाडेतोर आय्यार. ");
INSERT INTO wbq_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","निःसंशय, दुन्यामला शेंगेम प्रकारी भाषाल उंडाय इंगा यादुच बिना अर्थदी लेद. ");
INSERT INTO wbq_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","दिन कसोम जर नाक भाषाद अर्थ तेलवाक फो तर वाड माटलाडेतोन कसोम नीन विदेशी ठराशान इंगा येवाड माटलाडतुनाड वाड ना कसोम विदेशी ठराशी. ");
INSERT INTO wbq_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","बिलकुल इद्दे माटा मीक पण लागू आयताद जर मीर आध्यात्मिक दानला कसोम उत्सुक उंडार तर मंडळी उन्नती कसोम, मंडळीला आध्यात्मिक रुपता मजबुती वच्चे कसोम जोरदार प्रयत्न शेयंडा. ");
INSERT INTO wbq_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","दिन कसोम, यवाड अन्य भाषाला माटलाडताड वाड आदी जे माटलाडीनाड दानदी अर्थ शेप्पा दावाला आंकेन प्रार्थना शेय्याबेक. ");
INSERT INTO wbq_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","येनटीक की जर नीन अन्य भाषाला प्रार्थना शेस्तान तर ना आत्मा पण प्रार्थना शेस्ताद पण नाद बुद्धी निष्फळ नीलस्ताद. ");
INSERT INTO wbq_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","तर येम शेय्या बेक? नीन ना आत्माता प्रार्थना शेश्यान पण आल्ले नीन ना बुद्धीगोन पण प्रार्थना शेश्यान. ");
INSERT INTO wbq_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","येनटीक की जर नु नी आत्माता द्यावारदी धन्यवाद शेस्ताव तर यवाड इनेतोड सामान्य मनशी येवाड आंदू कुसनीनाड तर वाड नी उपकारस्तुती प्रार्थना मिंदा “आमेन” यल्ला आनी? येनटीक की नु यम आंटाव आदी वानकी तेलवाद. ");
INSERT INTO wbq_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","येनटीक की नु उपकारसुस्ती शिंगार शेस्ताव, खरेम इदी शिंगार उंडाद तरी दानता इंगोगोनदी उन्नती काद. ");
INSERT INTO wbq_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","नीन द्यावारकी धन्यवाद इस्तान, येनटीक की नीन मी आंदार काना जास्त अन्य भाषा माटलाडतान. ");
INSERT INTO wbq_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","पण नीन मंडळीला अन्य भाषाला फदी सावीर शब्दल माटलाडेदपेक्षा, इंगोगोरकी पण नेरपाला आंकेन, नीन ना बुद्धीगोन आय्यीद शब्दल माटलाडेद इदी नाक शिंगार वाटास्ताद. ");
INSERT INTO wbq_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","तम्मुडलु इंगा शेल्यांलु, मीर विचारला बीळांलेका काकुंडा. दानऐवजी दुष्टता बाबतिला शिन्ना बिडालेका नीरागस पण मना विचारला परिपक्व कांडा. ");
INSERT INTO wbq_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","पवित्र शास्त्र आंटाद, “इंगोगो भाषा माटलाडे तोरदी उपयोग शेशी इंगा अन्य भाषाता नीन इ मंदीसंगा माटलाड्यान तरीसुद्धा वार नाद इनेतोर लेर.” इल्ला प्रभुड आंटाड. ");
INSERT INTO wbq_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","दिन कसोम अन्य भाषाला माटलाडेद दान इदी विश्वास फेट्टेतोर कसोम लेद अविश्वासी मंदी कसोम चिन्ह उंडाद पण भविष्यवाणी विश्वासी मंदी कसोम चिन्ह उंडाद अविश्वासी मंदी कसोम लेद. ");
INSERT INTO wbq_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","दिन कसोम जर आंता मंडळी वगातळा वस्ताद इंगा प्रत्येक मनशी अन्य भाषाला माटलाडतुनी इंगा जर बैटूटोड इंगा अविश्वासी नोनीक वच्या, तर मीर पागल उंडार इल्ला वार मीमलान आनाक फोयार येम? ");
INSERT INTO wbq_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","पण जर आंदार भविष्यवाणी शेयदेंक आंटीर इंगा जर अविश्वासी इंगा बैटूटोड नोनीक वच्या, तर आंदार येम माटलातुन्यार आदी इनेतोनकी वान पापदी जाणीव आय्यी वार आंदार वानदी न्याय शेस्तार; ");
INSERT INTO wbq_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","वान अंतःकरणदी गुपित येरका आतादआय्यी इंगा वाड बोरकाला फडी इंगा द्यावारदी आराधना शेशी इंगा आनी “खरेमे द्यावार मी नडमा उंडाद”. ");
INSERT INTO wbq_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","हे तम्मूडलु इंगा शेल्यांलु येम शेयाबेक? मीर वगातळा वस्तार आप्पुड मीपैकी प्रत्येकोर येवाड भजन फाडेदेंक, येवार शिक्षण इच्चेदेंक, येवार द्यावार इच्चीनेद प्रकटीकरण शेपदेंक, येवाड अन्य भाषाला माटलाडदेंक, तर यवाड अर्थ शपदेंक तैयार उंटाड. आंताच मंडळी वाढ कसोम कावाला. ");
INSERT INTO wbq_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","जर येवाराना अन्य भाषाला माटलाडेतोड उंटे तर इद्दार इंगा जास्तीत जास्त मुग्गुरे माटलाडाला, वगा वेळला वक्काडे माटलाडाला इंगा वगा वक्काडे इ माटाद अर्थ शेप्पाला. ");
INSERT INTO wbq_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","जर मंडळीला अर्थ शेप्पेतोड येवाडूच लेकुंटे तर अन्य भाषा माटालाडेतोड सभाला शांत उंडाला, स्वता संगा इंगा द्यावार संगा माटलाडाला. ");
INSERT INTO wbq_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","इद्दार लेकाते मुग्गुर भविष्यवाणी शेय्याला इंगा बाकीचे मंदी वार येम माटलाडतुनार दानदी परीक्षा शेय्याला. ");
INSERT INTO wbq_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","कुशीनोर पैकी वगा व्यक्तीक जर येमाना द्यावार सुपिस्ते तर पहिला संदेश इच्चेतोड गप्प कुस्नाला. ");
INSERT INTO wbq_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","जर आंदार भविष्यवाणी शेशी शेकास्तार, तर मीर वगान यंका वगाड भविष्यवाणी शेशी शेकास्ताड, दिन कसोम की आंदार नेरवाला, इंगा आंदार प्रोत्साहित कावाला. ");
INSERT INTO wbq_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","इंगा संदेष्ट्याली आत्माल आ संदेष्ट्यान स्वाधीन उंटाय. ");
INSERT INTO wbq_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","येनटीक की द्यावार गडबडी शेशेतोड द्यावार लेड, शांती येतकेन वच्चेतोड द्यावार उंडाड. यल्ला आन्नी द्यावार पवित्र मंदी मंडळीला शांती बनाशी उंटाद. ");
INSERT INTO wbq_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","आंड्योर मंडळीला शांत निलवाला, येनटीक की वारकी मंडळीला माटलाडेद परवानगी लेद, पण अधीन निल्चेद आज्ञा उंडाद; येनटीक की नियमशास्त्र पण इल्ले आंटाद. ");
INSERT INTO wbq_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","वारकी जर येमाना नेरशेद उंटे तर वार स्वतः मोगुन इल्काडा आडगेद येनटीक की आंडीदानदी मंडळीला माटलाडेद इदी दानकी लज्जास्पद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","द्यावारदी वचन मीतीकनुस येल्लीनाद येम? का आदी फक्त मी नंताके वचीनाद येम? ");
INSERT INTO wbq_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","वगाड जर स्वतःन संदेष्टा समजास्ते इंगा जर वाड स्वतान आत्मिक मनशी समजास्ते तर वाड इदी येरका बेक की, याय माटलु नीन मिक रास्तुनान आय द्यावार इच्चीनेय आज्ञाल उंडाय. ");
INSERT INTO wbq_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","पण जर येवाराना नीन येम राशीनान आदी मानायाकुंटे, तर वानदी माटा पण मीर मानायाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","दिन कसोम हे ना तम्मूडलु इंगा शेल्यांलु भविष्यवाणी शेशेदेंक उत्सुक उंडांडा, अन्य भाषा माटलाडदेंक मना शेय्याकुंडा. ");
INSERT INTO wbq_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","पण आन्नी माटलु योग्य रितोता इंगा व्यवस्थित उंडाला. ");
INSERT INTO wbq_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","इप्पुड तम्मुडलु इंगा शेल्यांलु नीन मिक ध्यानाम शेशी इस्तान, की याद शुभवर्तमान नीन मिक शेपतीन इंगा याद मीर स्वीकार शेस्तीर इंगा दांटल्या मीर टिकाशी उंडार. ");
INSERT INTO wbq_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","यादान तीकनुस मिक तारण शिक्कीनाद आद्दे शुभवर्तमान नीन मिक शेपतान. या वचनगोन मिक पण शुभवर्तमान शप्पिंटीन आ वचन लेका आदी मीर मजबूत फट्टी उंडना दानताने मिद तारण आताद; लेकुंटे मिद विश्वास व्यर्थ उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","येनटीक की येम नाक पहिला शेप्पेदेंक वच्या आदी नीन मिक शपतीन, दांटल्या महत्वद इदी माटा उंडाद की, पवित्र शास्त्रला राशीनेलेका ख्रिस्त मना पापला कसोम सच्या. ");
INSERT INTO wbq_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","वान बुडशीदेन्क वच्या इंगा पवित्र शास्त्रला राशिने लेका मूड नाळाक वान इंगा लेपदेंक वच्या. ");
INSERT INTO wbq_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","इंगा मग वाड कैफानकी कमश्या, यंकसार बारा प्रेषितलाक, ");
INSERT INTO wbq_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","मग वाड आयनूर काना जास्त तम्मूळलाक कमश्या. वारपैकी जास्त मंदी इंगाना जित्ता उंडार, तर काही मंदी सच्ची फोईनार. ");
INSERT INTO wbq_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","इंगा मग वाड याकोबकी कमश्या, इंगा मग वाड आन्नी प्रेषितलाक कमश्या. ");
INSERT INTO wbq_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","इंगा आंदारकाना आखरीक नाक पण कमश्या, वेळ कावाकाना मुंची फुट्टीनगते. ");
INSERT INTO wbq_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","येनटीक की प्रेषितला नीन शिन्नावोड उंडान, नीन प्रेषित आने योग्यतावोड लेन, येनटीक द्यावार मंडळीद नीन छळ शेशीन्टीन. ");
INSERT INTO wbq_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","पन द्यावार कृपाता नीन येम पण उंडान आदी नीन उंडान इंगा वानदी नामिदुंडदी कृपा व्यर्थ फोलेद, पण नीन वार आंदारकाना जास्त कष्ट शेस्तीन, इदी फनी नीन शेय्यालेद, पण द्यावारदी कृपा याद नासंगा उंड्या, आदी शेस्तुन्या. ");
INSERT INTO wbq_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","दिन कसोम नीन उंटे का वार उंटे मिम इद्दे घोषणा शेस्ताम इंगा मीर दिन मिंदाने विश्वास फेटतीर. ");
INSERT INTO wbq_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","इप्पुड जर मिम ख्रिस्त सचीनोर लोन्केल लेशिनाड इल्ला शुभवर्तमान शेपताम, तर सचिनोरदी पुनरुत्थान लेद इल्ला मी पैकी काही मंदी आंटार इदी यल्ला? ");
INSERT INTO wbq_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","जर सच्चीनोरदी पुनरुस्थान लेद तर ख्रिस्त पण सचीनोर लोन्केल लेय्यालेद, ");
INSERT INTO wbq_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","इंगा जर ख्रिस्त सचीनोर लोन्केल लेय्या लेद तर माद संदेश व्यर्थ उंडाद इंगा मिद विश्वास पण व्यर्थ उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","इंगा मिम द्यावार खोटा साक्षील ठरास्तिम येनटीक की द्यावार ख्रिस्तन सचीनोर लोन्केल लेप्या इल्ला मिम वान बद्दल साक्ष इस्तीम. जर इदी इल्ला उंटे की, सचीनोर लेपदेंक दार तर द्यावार पण ख्रिस्तन लेपा लेद. ");
INSERT INTO wbq_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","इंगा जर सचीनोरणी लेपा दाद, तर ख्रिस्तड पण सचीनोर लोन्केल लेय्या लेद. ");
INSERT INTO wbq_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","इंगा, जर ख्रिस्त लेय्या लेद, तर मिद विश्वास व्यर्थ उंडाद इंगा मीर इंगाना पापला फडी उंडार. ");
INSERT INTO wbq_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","इंग्या इंगा येव्वार ख्रिस्तला सच्ची फोइनार, वारदी पण नाश आय फोइनाद. ");
INSERT INTO wbq_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","जर ख्रिस्त मिंदा उंडीनेद माद आशा, फक्त इद्दे जीवन कसोम उंटे, तर आन्नी मन्सुलाला मिम दयनीय उंडाम. ");
INSERT INTO wbq_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","पन इप्पुड खरेमे ख्रिस्त सावनुस लेशी जिवंत आयनाड. येव्वार सच्ची फोयतार आ मंदीला वाड प्रथमफळ उंडाड. ");
INSERT INTO wbq_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","येनटीक की दिनदी अर्थ उंडाद यल्ला मनशी तीकनुस साव वच्या आल्ले सच्चीनोरदी पुनरुत्थान पण मनशी तीकनुस वच्या. ");
INSERT INTO wbq_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","येनटीक की यल्ला आदाम पाप शेशीने कसोम आंदार सस्तार आल्ले ख्रिस्त मिंदा विश्वास फेट्टीन कसोम आंदार जित्ता शेशेदेंक वच्यार. ");
INSERT INTO wbq_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","पण प्रत्येकोर वार क्रमानुसार, ख्रिस्त जो प्रथम फळ उंडाड इंगा मग ख्रिस्त वचेद येळी वान्द उंडीन्द मंदी जिता शेशी फइ. ");
INSERT INTO wbq_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","आप्पुड इ संसारदी शेवट आय्यी, प्रत्येक अधिपतीन, प्रत्येक सत्तान, प्रत्येक सामर्थ्यन यप्पुड ख्रिस्त नष्ट शेशी, आप्पुड ख्रिस्तड द्यावार आब्बानकी राज्य इचकाडी. ");
INSERT INTO wbq_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","येनटीक की वाड आन्नी शत्रूलान वान काळाकिंदा फेट्टीनंताक वानकी राज्य शेय्याने बेक. ");
INSERT INTO wbq_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","यवाड आखरी शत्रू साव वाड नष्ट शेशेदेंक वच्ची. ");
INSERT INTO wbq_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","पवित्र शास्त्र शपताद, “येनटीक की द्यावार, वान काळाकिंदा आंताच येस्काडनाड.” पण यप्पुड वाड आंटाड की, “आंताच वान अधीन शेस्कामला वच्चीनाद,” आप्पुड येवाड आंताच वान अधीन शेश्या, वाड द्यावार स्वतः दांटल्या लेड. ");
INSERT INTO wbq_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","इंगा, यप्पुड द्यावार आंताच कोडकु शेतल्या इच्या तर कोडकु पण स्वतःन परमेश्वर शेतल्या इच्या दिन कसोम की द्यावारे आन्नी माटलामिंदा राज्य शेशेतोड कावाला. ");
INSERT INTO wbq_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","लेकाते, येव्वार मंदी सच्चीनोर कसोम बाप्तिस्मा तीस्कुंटार वार येम शेशार? जर सच्चीनोर लेय्यारुच तर वार मंदी वार बद्दल बाप्तिस्मा येनटीक तीस्कुंटार? ");
INSERT INTO wbq_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","इंगा मिम पण प्रत्येक वेळला संकटाला येनटीक फडताम? ");
INSERT INTO wbq_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","हे तम्मूडलु इंगा शेल्यांलू ख्रिस्त येशु मना प्रभूला, नीन मी बद्दल उंडीने घमंडदी वटू येस्केन इदी आंटान की, नीन दिना-दिनाम सस्तान. ");
INSERT INTO wbq_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","मनशी स्वभाव लेका इफीसला नीन रानटी प्राणीला संगा लढास्तीन, तर नाक येम फायदा आय्या? जर सच्चीनोर लेय्याकुंटे तर फदांडा “मनाम तिनदाम-तागदाम, येनटीक रेफाक तर सच्चेदे उंडाद!” ");
INSERT INTO wbq_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","इंगा येवाडाना इल्ला माटलाडताड तर वान माटलु इनी फसायाकुंडा, येनटीक की “वाईट संगती मचीं चरीत्रनी खराब शेस्ताद.” ");
INSERT INTO wbq_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","नितीमत्व कसोम लेयांडा इंगा पाप शेय्याकुंडा येनटीक की मिपैकी काही मंदी इल्ला उंडार येव्वार द्यावारनी गुरतू फट्टार. इदी नीन मिमलान शिग्गुना केडपाला आंकेन आंटान. ");
INSERT INTO wbq_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","इप्पुड येव्वाराना इल्ला आन्यार? “सच्चीनोर यल्ला लेशार? वार यल्लोन फयला वच्चार?” ");
INSERT INTO wbq_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","नु इंता अज्ञानी उंडाव येम? नु येम पेरास्ताव आदी पहिला सच्चीन शिवाय जित्ता काक फोई. ");
INSERT INTO wbq_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","इंगा नु येम पेरास्ताव दानदी फंटा आय्येद फय पेरायाव, तर फक्त बी पेरास्ताव ; आदी गोदमाद लेकाते इगोगोट येमाना उंडी. ");
INSERT INTO wbq_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","इंगा आंटे द्यावार निवडाशीन लेका वाड दानकी आकार इस्ताड. वाड प्रत्येक दानाक दानदी स्वताद “फय” इस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","जित्ता प्राणीलाय आंदारीच फईल सारखा लेकुंटाय. दिन शिवाय मन्सुलाय फयलु वगा प्रकारी उंटाय. प्राणीलाय फइल इंगोगो प्रकारी उंटाय, गुव्वाल इंगोगो प्रकारी उंटाय; इंगा मिल अलग-अलग प्रकारी उंटाय. ");
INSERT INTO wbq_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","आल्ले स्वर्गीय फइल उंडाय इंगा पृथ्वी मिंदूड फइल उंडाय, पण स्वर्गीय फइद वैभव वगा प्रकारदी उंडाद, तर पृथ्वी मिंदूड फइद इंगोगोट उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","सूर्याद येलगु वगा प्रकारदी तर चंद्रद येलगु वेगळा प्रकारदी उंटाद. सुक्काद येलगु वेगळा प्रकारदी उंटाद इंका चमकाशे दिंटला वगा सुक्का इंगोगो सुक्काकाना वेगळा उंटाद. ");
INSERT INTO wbq_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","आंकेन सच्चीनोर पुनरुत्थान संगा पण इल्ले आय्यी, फय याद भुमीला बुडशीनेद उंडाद आदी नाश आय्येद उंडाद, पण आदी फय यादान लेपेदेंक वस्ताद आदी अविनाशी उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","याद अपमानता बुडशे दिंटल्या वस्ताद आदी गौरवाला लेपे दिंटल्या वस्ताद याद अशक्तपणाला बुडशे दिंटल्या वस्ताद आदि सामर्थ्याता लेस्ताद. ");
INSERT INTO wbq_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","याद भुमीला बुडशीदेंक वच्चीनाद आदी नैसर्गिक फय उंडाद याद पुनर्जीवित आयताद आदी आत्मिक फय उंडाद. जर नैसर्गिक फइल उंडाय तर आध्यात्मिक फइल सुद्धा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","इंगा पवित्रशास्त्र इद्दे शपताद, “पहिला मनशी, आदाम इड जिता प्राणी आय्या,” पण ख्रिस्त येवाड आखरी आदाम आय्या वाड जीवन इच्चेतोड आत्मा आय्या. ");
INSERT INTO wbq_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","याद फय मनाक पहिला इच्चीनार आदी संसारिक उंडाद पण याद फय मनाक यंकसार इच्चे दिंटल्या वच्ची आदी आत्मिक उंडी. ");
INSERT INTO wbq_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","पहिला मनशी भुमीलोन मन्नुता बनाशीन्या, तर इंगोगो मनशी स्वर्ग लोन्केल वच्या. ");
INSERT INTO wbq_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","यल्ला आ पहिला मनशीद रचना मन्नुनोट बनाशीन्या, आल्ले मनाम आंदार पण मन्नुता बनाशीनाम इंगा यल्ला इंगोगो मनशीद फय स्वर्गीय उंडाद आल्ले मनाद फय पण स्वर्गीय आय्यी. ");
INSERT INTO wbq_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","इंगा येवाड मन्नुता बनाशीन्या वानदी रूप मनाम धारण शेस्तीम, आल्ले येवाड स्वर्गीय उंडाड वानदी रूप मनाम धारण शेशाम. ");
INSERT INTO wbq_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","इप्पुड तम्मूडलु इंगा शेल्यांलू नीन इदी शपतान की, नंजूर इंगा रक्ताम द्यावार राज्यद अधिकारी आय्यी शेकायाद इंगा नाशवान अविनाशीक अधिकार आय्यी शेकायाड. ");
INSERT INTO wbq_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","सुडांडा! नीन मिक वगाट रहस्यमय सत्य शपतान. मनाम आंदार सच्चेतोर लेम. मनाम आंदार बदलाशी फोय्याम. ");
INSERT INTO wbq_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","इंगा इदी लगेच आय्यी, कन्नुद रेक्का आंटा काना मुंची, यप्पुड आखरी कर्णा वागी आप्पुड, येनटीक की कर्णा वागी तर येव्वार सच्चीनोर उंडार, वार नेहमी इचांग जिवंत आय्यार इंगा मनाम येव्वार जित्ता उंडार, मनाम पण बदलाशी फोयाम. ");
INSERT INTO wbq_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","येनटीक की इदी जे विनाशी उंडाद आदी अविनाशीन धारण शेशी इंगा इदी याद सच्चेदेंक उंडाद आदी अमरत्व धारण शेशी इदी नक्की उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","इदी याद विनाशी आदी अविनाशीपण धारण शेशी इंगा इदी सच्चेद उंडाद आदी अमरत्व फेटकुनी, इल्ला यप्पुड आय्यी आप्पुड, पवित्रशास्त्रला राशिने लेका; “विजय सावनी मिंगी तीस्कुनीनाद.” ");
INSERT INTO wbq_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","“अरे साव नीद विजय यंदु उंडाद? साव नीद नांगी यंद उंडाद?” ");
INSERT INTO wbq_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","सावदी नांगी पाप उंडाद इंगा पापदी सामर्थ्य नियमशास्त्र तीकनुस वस्ताद. ");
INSERT INTO wbq_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","पण द्यावारकी धन्यवाद, येवाड मना प्रभू येशु ख्रिस्त तीकनुस मनाक पाप इंगा सावमिंदा विजय इस्ताड! ");
INSERT INTO wbq_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","दिनकसोम ना प्रिय तम्मूडलु इंगा शेल्यांलु प्रभूला स्थिर इंगा मजबूत निलवांडा. नेहमी स्वतःन प्रभुन फनी कसोम इच्काडना येनटीक की मीक येरका उंडादकी प्रभुला मिद कष्ट व्यर्थ लेद. ");
INSERT INTO wbq_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","इप्पुड, पवित्र मंदी कसोम वर्गणी जमा शेशे बद्दल, यल्ला नीन गलतीलोन मंडळीक आज्ञा इच्चीनान मीर पण आल्ले शेयांडा. ");
INSERT INTO wbq_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","मी पैकी प्रत्येक मनशी, वानकी शिक्कीने पगारलोन्केल, प्रत्येक हफ्ता पहिला दीनमुनाड दुडलु जमा शेशी फेटना. ");
INSERT INTO wbq_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","इंगा यप्पुड नीन वच्यान, मीर स्वीकार शेशीने मंदीक मीद देणगी यरुशलेम शहरलोंग येतकेन फोयेदेंक आमश्यान; ");
INSERT INTO wbq_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","इगा जर नादसुध्दा फोयेद योग्य उंटे तर वार ना संगा वच्यार. ");
INSERT INTO wbq_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","नीन मासेदोनिया प्रांतनुस फोयान आप्पुड मीतीकुड वच्यान येनटीक की मासेदोनियानुस फोयेद नाद योजना उंडाद. ");
INSERT INTO wbq_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","इंगा जमास्ते तर नीन मी संगा निलच्यान इंगा सली कालाम घालवाशान, आंटे नीन फोयान आकाडा मीर नन्नु दावाक आमशार. ");
INSERT INTO wbq_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","पण नाक रव्वा वेळ कसोम मीमलान भेटाशेद नाद इच्छा लेद येनटीक की जर प्रभुनदी इच्छा उंटे तर मि देगारा काही वेळ निल्वाला इल्ला नीन आशा फेटतान. ");
INSERT INTO wbq_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","याबय दिनमुद फंडगा (पेन्टेकॉस्ट) नंताक नीन इफीसला नीलच्यान ");
INSERT INTO wbq_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","येनटीक की ना कसोम फेद्दाद इंगा सामर्थ्यशाली कवाड तेरशीनेद उंडाद इंगा इल्लोन शेंगेम मंदी उंडार येव्वार नाक विरोध शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","जर तीमथ्य वच्या तर वाड मीर देगार आदरान्दे यल्ला निलची दानतिकुड लक्ष इंडा येनटीक की वाड पण ना लेकाने प्रभुनदी फनी शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","दिन कसोम येवारुच वान तुच्छ मानायाकुना. पण वाड नातीकुड दावाला आंकेन वान शांतीता आमस काडना आंटे इंगोगो विश्वासी तम्मूळला संगा वानदी वच्चेद नीन दावा सुस्तुनान. ");
INSERT INTO wbq_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","गान तम्मूड अपुल्लोन बदल इल्ला उंडाद की, वाड इंगोगो तम्मूळला संगा मीतिकुड दावाला, इल्ला नीन वानकी शेंगेम विनंती शेस्तीन पण वारदी इप्पुड वच्चेद खरेमे इच्छा लेकुंड्या गान वानकी यप्पुड वानकी वेळ शिक्की आप्पुड वाड वच्ची. ");
INSERT INTO wbq_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","सावध उंडाडा, मीरद विश्वासला मजबूत निलुंडा. धैर्यशाली कांडा. सशक्त कांडा. ");
INSERT INTO wbq_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","प्रत्येक माटा याद मीर शेश्यार आदी प्रेमता शेयांडा. ");
INSERT INTO wbq_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","इप्पुड तम्मूळलू इंगा शेल्यांलू स्तेफन घरानाद मीक शिंगार माहिती उंडाद. वार अखया प्रांतलोंन पहिला फळ उंडार; इंगा पवित्र मंदी सेवा कसोम वार तैयार उंटार. नीन मिक विनंती शेस्तान की, ");
INSERT INTO wbq_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","प्रत्येक व्यक्ती येवाड इ फनीला कुडताड इंगा प्रभुन कसोम श्रम शेस्ताड मीर इल्लोन मंदी अधीन नीलुंडा. ");
INSERT INTO wbq_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","स्तेफन, फर्तुनात, इंगा अखायिक इर वच्चीर आंका नाक आनंद आय्या येनटीक की वार नाद आदी गरज पूर्ण शेशीर याद मीर शेशी शकाया कुंटीर. ");
INSERT INTO wbq_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","येनटीक की वार ना इंगा मी आत्मान पण प्रसन्न शेशीर. इल्लोन मंदीन मानायंडा. ");
INSERT INTO wbq_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","आशिया खंडलोन मंडळीला तीकनुस मिक नमस्कार. अक्कीला, प्रीस्कील्ला इंगा याद मंडळी वार इंटल्या जमा आयताद, आदी प्रभूला मिक नमस्कार आंटार, ");
INSERT INTO wbq_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","आंदार तम्मुळलु मीक नमस्कार शपतार, प्रेमता शेतल्या शेय इच्ची वगामेगारकी दंडाम शेयंडा. ");
INSERT INTO wbq_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","नीन, पौल स्वत: ना शेयता इदी सलाम रास्तान. ");
INSERT INTO wbq_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","जर येवाडाना प्रभुन मिंदा प्रेम शेय्याड, तर वाड शापीत कावाला, “हे मा प्रभु दा” ");
INSERT INTO wbq_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","प्रभु येशुनदी कृपा मीसंगा उंडाला! ");
INSERT INTO wbq_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ख्रिस्त येशूला नाद प्रेम मी आंदार संगा उंडाला. आमेन.");
INSERT INTO wbq_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","2","गलती शहर लोन मंडळीक; मनसला तीकेल किंवा मनसला द्वारा लेद, तर येशु ख्रिस्ततीकेल इंगा यवार वान सचीनेका जिवंत शेशा वाळ परमेश्वर आब्बळ, इन तीकेल आईनेर प्रेशीद पौल, इंतीकेल इंगा ना सोबतील आन्नी बंधूला तीकेल, ");
INSERT INTO wbq_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","द्यावर जो मना आब्बळ इंगा मना प्रभू येशु खिस्त इंतीकेल मिक कृपा इंगा शांती उन्डाला ");
INSERT INTO wbq_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","मना द्यावर आब्बन इच्छातीकेल, इ इपुळी दुष्ट काळकेल मनालनी इळपीदेंग, प्रभू येशु ख्रिस्तळ मना पापलाबद्दल, स्वताक इच्या. ");
INSERT INTO wbq_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","द्यावर आब्बन की युगानयुग गौरव उन्डाला. आमेन. ");
INSERT INTO wbq_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","नाक आश्चर्य वाटास्ताद की, यवार मिक ख्रिस्तान कृपाला निवडा शीर वानतिकेल, इंता लगान, मीर दुसरा मंची बातमी तीकुड फोईणार. ");
INSERT INTO wbq_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","दुसरा इंगोगाय मंची बातमील लेव; पण मिंलान घोटाळाला येशेळी इंगा ख्रीस्ताय मंची बातमी अलग शेशेळडी इच्छा उंडीनेय इल्ला यन्ता जन उंडार. ");
INSERT INTO wbq_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","तर याय मंची बातमी मिम मिक शपतीम दाणकना वेगळा मंची बातमी जर मिम शपतीम किंवा स्वर्ग नुस वचीनेय द्यावर दूत पण शप्या, तरी वाड शापित उन्डाला. ");
INSERT INTO wbq_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","मिम पहिला शपिनाम आल्ले नीन इंगा शेप्ताम की, यवार मिक, येम मीर स्वीकार शेस्तीर दानकना, वेगळा मंची बातमी यवार मिक शेपिंयार वार शापित उन्डाला. ");
INSERT INTO wbq_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","नीन इप्पूळ मनस्लाद किंवा नीन द्यावार्दी मन तीपेळदी सुस्तुनान? नीन मन्सलान संतुष्ट शेयदेंद सुस्तुनान येम? नीन इप्पूळ नंतक मनसलान खुश शेस्तुंटान, तर नीन ख्रिस्तान दास लेकुंन तूनटीन. ");
INSERT INTO wbq_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","येनटीक की, बंधू, नीन मिक शेप्तान की, नीन या मंची बातमीद घोषणा शेस्तीन आदी मनसलु शेप्पीने लेका लेद. ");
INSERT INTO wbq_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","येनटीक की आदि नाक मनसूला तीकेल शिक्काल्या आल्ले आदी नाक यवार शिका पण मत्तालेद; पण येशु ख्रीस्तद प्रगटीकरनता आदी नाक शिक्क्या. ");
INSERT INTO wbq_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","मीर ना, यहुदी धर्मालोन्केल, पहिला वागणूक लेका ऐकाशिनान कि, नीन यला द्यावार मंडळीद संगेम त्रास इच्ची दांदी नाश शेसका उंटीन. ");
INSERT INTO wbq_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","इंगा नीन ना पुर्वजल्दी रीतील बद्दल संगेम जास्त उत्साह उंड्या मा मंदीला ना वय टोर संगेम मंदी कना यहुदी धर्मला नीन मुंदार फोइंटीन. ");
INSERT INTO wbq_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","पण या द्यावर नन्नु आम्मा कळपुकेल वेगळा शेश्या इंगा स्वत कृपा ता नन्नु विलचा, वांकी येपूळ शिंगार वाटाश्या की, ");
INSERT INTO wbq_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","स्वता कोळकून ना तीकेल प्रकाट शेईयाला, म्हणजे इंगोगो राष्ट्रला नीन वांदी मंची बातमी घोषणा शेयाला आपुळ नीन यवार पण मंसलाद तीस्कनाले, ");
INSERT INTO wbq_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","इंगा ना पहिला आईनेय प्रेशित्ला तीकुड येरुशलेमकि मिन्दिक फोले, पण नीन लगनाणे अरबस्तान देशुक यल्ली फोतीन इंगा आन्केल दिमिष्कास कि डब्बल वस्तीन. ");
INSERT INTO wbq_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","मुंदार, मूळ याडाद नंतर, नीन केफनि भेटादेंग मिन्दिक येरुशलेमकि फोतीन इंगा पंधरा दिवस नीन वान देगारा निलस्तीन ; ");
INSERT INTO wbq_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","गान प्रभू तम्मुड याकोब इंशिवाय नीन इंगोगो प्रेशित्ला लोन्केल दुसरा यवर पण नाक कम्पियाले. ");
INSERT INTO wbq_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","नीन जो मिक लीवास का उंडान, आय्यी सूळना, द्यावर मुंदार, नीन खोटा माटलान. ");
INSERT INTO wbq_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","दान नंतर नीन सिरीया इंगा किलीकीया शहरला वस्तीन ");
INSERT INTO wbq_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","इंगा ख्रिस्तला उंडीनेर, यहुदिया शहरटोर मंडळीक नीन अनोळखी उंटीन. ");
INSERT INTO wbq_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","वारकी येकादेंग इंतेने, वचाका उंडी की, 'पहिला माद त्रास इचेतोळ या विश्वास येनकाक नाश शेयदू वांदी वाळ इप्पुळ सुवारता शपतुणाळ.' ");
INSERT INTO wbq_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","इंगा वार ना बद्दल द्यावार्दी गौरव शेदेंग आंटीर. ");
INSERT INTO wbq_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","नंतर, चौदा वर्षकेल नीन इंगा, बर्णबाबरोबर, येरुशलेम शहरला मिन्दिक फोतीन, नीन नाबरोबर तीतालान पण एका फोतीन. ");
INSERT INTO wbq_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","नाक प्रकटी करण आईन्या लेका नीन फोतीन इंगा याद मंचीद बातमी नीन इंगोगो राष्ट्रला शेप तुंटान, आदी नीन वान मुंदार फेटत्तीन; पण जो विशेष मानास्नेयद उंड्या वारकी ओकोरला मांडास्तीन; लेद तर, नीन विनाकारण फारतान किंवा फारतीन, इल्ला शायद आतुण्या. ");
INSERT INTO wbq_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","पण नाबरोबर उंडीनेळ तीत इड ग्रीक उंड्या आंका, वांकी पण सुंता शेशी तीस्कूनदेंग भाग शेयदेंग दाल्या. ");
INSERT INTO wbq_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","इंगा गुप्तता नोनिक एकोचीनेय खोटा बंधूल कसरोम पण भाग केळपीदेंग दाल्या; वार मंलान गुलाम गिरीला येदेंग, ख्रिस्त येशु न दीतटला याद मोकळीक पना मनाक उंडाद आदी हेराशांदाणक, दोनगा शेशी नोनिक वचीनीर. ");
INSERT INTO wbq_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","मंची बातमीद खरेंम मी तीकुड उन्डाला दानचांग मिम वारणी रवा भी वेळ वार शेतला एयाक होतीम. ");
INSERT INTO wbq_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","तरीपण, यवार विशेष मानास्नेर यवारना उंडीर वार तीकेल (वार येल्लापन उंडदूर दांदी नाक येमी लेद; द्यावर या मंशीद बी पक्षपात शयाड.) येनटीक की यवार विशेष मानासनेर उंडीर वार नाक एमी जास्त इयालेद. ");
INSERT INTO wbq_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","तर उलटा सुंता आईनेर येहुदिलकी मंची बातमी शप्काम यला पत्रस मिंदा इळशिन्या आल्ले सुंता कालेर इंगोगो राष्ट्र मंदीक मंची बातमी शपकाम नामिंदा सोपाशिनेद उंडाद, इदी वार सुशीर. ");
INSERT INTO wbq_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","येनटीक की यवार पत्रस देगारकेल सुंता आईनेर मंदी प्रेशीद पना चाला मत्तीदेंग ताकत पुरामत्या वाळ नाक पण इंगोगो राष्ट्रला वाळ नळपिदेंग ताकत पुरामत्या. ");
INSERT INTO wbq_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","इंगा वाळ नाक इचीनेय कृपाद दान ओळखाशी, याकोब, केफा इंगा योहान इर जो आधर इचेटोर उंडीर वार नाक इंगा बर्णबान मंची शेईता संगती शेश्या, इदी दिनकस्रोम की, मनाम द्यावार फनीला सहभागी उन्डाम इदी सुपियाला इंगा मिम इंगोगो राष्ट्र तीकुड इंगा वार सुंता आईनेर तीकुद फोवाला. ");
INSERT INTO wbq_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","मिम फक्त गरीबोर दी आठवण फेटाला, इल्ला वारदी इच्छा उंड्या; नीन तर आइ माटाल्लाचंग उत्साहित उंटीन. ");
INSERT INTO wbq_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","इंगा दान बाद, केफा अनत्युखीयास वची नेन्का, नीन वान मुंदार वांकी आडाम वस्तीन, येनटीक की वाळ दोषी उंड्या. ");
INSERT INTO wbq_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","येनटीक की याकोबदेगार नुस यंता मंदी वचेळ पहिला वाळ इंगोगो मंदी बरोबर तिनु पण वाळ वचीनेका वाळ सुंता आईनेर मंदीक आद्री वाळ यंकाक आय्यी वेगळा नीलदू. ");
INSERT INTO wbq_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","आपुळ आल्ले दुसरा येहुदील विश्वास फेटेतोर पण वान सोबत ढोंग शेशीर; दानचांग बर्नबापण वार ढोंगता प्रभावित आय्या. ");
INSERT INTO wbq_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","पण नीन येपूळ इदी सुस्तीन की, मंची बातमी खरेंम लेका आदी बरोबर नळाद, आप्पुड नीन आंदार मुंदार नीन केफान आनटीन, “नु स्व:ता यहुदी उंडी नु जर इंगोगो राष्ट्र लेका उंटाव इंगा येहुदील लेका निलवाव, तर यवार इंगोगो राष्ट्र टोर येहुदील लेका वागायला आंका नु वार मिंदा अत्याचार शेस्ताव येम?” ");
INSERT INTO wbq_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","मिम जन्म केले यहुदी उंडाम, पापी इंगोगो राष्ट्रटोर लेर. ");
INSERT INTO wbq_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","तरी मनशिल नियमशास्त्रालोणी फनिलता नीतिमान ठहरार तर येशु ख्रिस्तमिंदा विश्वास द्वारा ठहरास्तार, इदी ओळखाशी मिम पण येशुन मिंदा विश्वास फेटतीम; दिनकस्रोम की, विश्वासता मनशी नीतिमान ठहरादेंग वस्ताद, दानचंग मिम येशु ख्रिस्तानमिंदा विश्वास फेटतिम; आंटे मिम ख्रिस्तामिंदा विश्वास्टोर नीतिमान ठरस्ताड, नियमशास्त्रलोणी फनिल शेया रोद, येनटीक की नियम शास्त्रालोणी फनिलता मनशीजातीपैकी यवार पण नीतिमान ठहरार. ");
INSERT INTO wbq_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","पण ख्रिस्तला नीतिमान ठेहरा मत्तीदेंग सुस्तार जर मनामपण पापी काम्पिस्तिं तर ख्रिस्त पापदि सेवक उंडाळ येम? येपुळूच लेद. ");
INSERT INTO wbq_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","येनटीक की नीन जे केढपितान मातीनान नान आदी इंगा बना मत्तुतीन तर नीन स्व:ताण नियमशास्त्र मोडाशेटोळ ठेहेराशान. ");
INSERT INTO wbq_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","येनटीक की नीन नियमशास्त्र तीकेल नियम शास्त्रकोलोनकेल सची फोईनान, दिनकस्रोम की, नीन द्यावर कसरोम जगायाला. ");
INSERT INTO wbq_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ख्रिस्ताबरोबर क्रूसमिंदा खिळाशिणेळ उंडान इंगा दिन मुंदरा नीन जगास्तान इल्ला लेदत तर ख्रिस्त ना-ना दिन्टला जगास्ताळ इंगा इपूळ ह्रदला जो नाद जगास्काम उंडाद आदी द्यावार कोळकूद विश्वासद्वारे उंडाद. वाळ नामिंदा प्रेम शेश्या इंगा स्वतान ना कसरोम इच्या. ");
INSERT INTO wbq_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","नीन द्यावार्दी कृपा व्यर्थ शेयान येनटीक की जर नीतीमत्व नियमशास्त्रतीकेल उंटे त ख्रीस्तानदी सचकाम विनाकारण आय्या. ");
INSERT INTO wbq_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","अरे बुद्धी लेनेर गलती ओर, क्रूस मिन्दा खिळासणेल येशु ख्रिस्त यवार कनला मुंदार वर्णन शेशी फेटीन्या, आय्यी मिमलान यवार भुला मत्तीर? ");
INSERT INTO wbq_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","नाक नि देगार नुस इंताने समजाशी तीस्कुनेद उंडाद की, मिक जो पवित्र आत्मा शिक्या आदी नियमशास्त्रलोन्केल फनिलता शिक्या की, सुवार्ता ऐकाशी विश्वास फेटीनाम आंका शिक्या? ");
INSERT INTO wbq_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","मीर इंताने कमी बुद्धी टोर उंडार येम? मीर द्यावार आत्माता चालू शेशी नेन्का इप्पूळ शरीरस्वभावता पूर्ण येस्केन देंग सुस्तुणार येम? ");
INSERT INTO wbq_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","मीर इंता दुख सहन शेस्तीर इदी व्यर्थ येम? दिन व्यर्थ आंदाम येम! ");
INSERT INTO wbq_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","दानचांग यवार मिक द्यावार आत्मा पुरामत्तुत्ताळ इंगा मी मधातला चमत्कार शेस्ताल वाळ जो इ आंता शेस्ताळ आय्यी नियमशास्त्रली फनिकेल शेस्तार की, सुवार्ता एकाशी विश्वास फेटतींम आंका आदी वाळ शेस्ताळ? ");
INSERT INTO wbq_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","येल्ला अब्राहम द्यावार मिंदा विश्वास फेटीनाळ इंगा आदी नितीमत्व इल्ला मोजास्कामला वच्या. आला इदी आय्या. ");
INSERT INTO wbq_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","दिन मिन्दुकेल मीर समजास्कोंडा की, यवार विश्वास फेटतार वारे अब्राहम गंगोदटोर का. ");
INSERT INTO wbq_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","इंगा द्यावार इंगोगो राष्ट्रटोरनी विश्वास्ता नीतिमान ठेहेरामतुताल इ पहिला ज्ञानकोळोन्ग शास्त्रलेखकोळ, अब्राहम की पहिलाने मंचीबातमी शेप्या की, 'नितीकेल आन्नी राष्ट्रल की आशीर्वाद शिक्की.' ");
INSERT INTO wbq_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","तर नंतर यवार विश्वास फेटतार वारकी विश्वासु अब्राहम संगा आशीर्वाद इच्चीनाड. ");
INSERT INTO wbq_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","येनटीक की नियमशास्त्रलोनि फनील मिंदा येण्ता जन अवलंबून उन्डार आंता जन शापला उंडार येनटीक की पवित्र शास्र्ला इल्ला लीवाशी उंडाद की, 'नियमशास्रद पुस्तक ला जो लीवाशी उंडाद आय्यी आन्नी पाळादेंग जो टीकाशी उंडार वाळ शापित उंडाळ.' ");
INSERT INTO wbq_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","नियमशास्त्राटोर यवार पण द्यावार मुंदरा नीतिमान ठेहेरार, इदी उघडासी उंडाद; येनटीक की 'नीतिमान विश्वास ता जगास्ताळ.' ");
INSERT INTO wbq_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","इंगा नियमशास्त्रा तर विश्वासदी लेद पण 'यवार दान फनील लेका शेस्तार वाळ वार लेका जगश्यार.' ");
INSERT INTO wbq_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","मना बद्दल ख्रिस्त शाप आय्या इंगा वाळ मनालनी नियमशास्त्र शापकेल कोंकोनी तीस्कोन्या; इल्ला शास्त्रलेख आटाद 'यवार पण शेटूमिंदा टानगाशिणार वाळ शापित उंडाळ', इल्ला शास्रलेख उंडाद. ");
INSERT INTO wbq_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","दिं-दि उद्देश इल्ला की, अब्राहम कि इचीनेद आशीर्वाद ख्रिस्त येशुन द्वारा इंगोगो राष्ट्रक शिक्काला, म्हणजे मना विश्वास लेका आत्माविषयाला अभिवचन शिक्काला. ");
INSERT INTO wbq_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","ताम्मुल इंगा शेल्यालु, नीन इदी व्यवहारीत नजरता माटलाळतान. ओकाटआळदम मनशीद करार सुद्धा वाळ स्थापित शेशी नेका यवार मिटा मत्तार किंवा दान्तल्या भारी निम्पार. ");
INSERT INTO wbq_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","इप्पूळ, यादि वचनलु अब्राहाम इंगा वान बीळलाक इच्चीन्या. वाळ 'बीळलाक' इल्ला जास्त जन बद्दल आनाळ, पण 'नि बीळलाक' इल्ला ओकोन विषयला आंटाळ इंगा वाळ ओकोळे ख्रिस्त उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","इंगा, नीन इदी आणटान की, द्यावार आदी करार पहिलाने स्थापासनेका चारशेतीस वर्ष नंतर आईने नियमशास्त्र कोळोन्ग संपुष्टाला वची दानकोळोन्ग अभिवचन रद्द काद. ");
INSERT INTO wbq_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","येनटीक की वतन जर नियमशास्त्रता शिकतात, तर आदी दिन मुन्दार अभिवचन ता काक फोई; पण अब्राहमकी द्यावार आदी कृपाता अभिवचन द्वारा इच्या. ");
INSERT INTO wbq_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","मग इदी नियम शास्त्र येनटीक? येनटीक की, या वंश क वचन इच्चीन्या वानदी वचकाम आय्यी पर्यंत आय्यी मोळाशेळ कोळोन्ग नियमशास्त्र इच्चीनार; वार मधातलोनटोर शेतला द्यावार दुतलातीकेल नेमाशी वच्या. ");
INSERT INTO wbq_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","मधातलोनटोळ इळ ओगारकना जास्त जन कोळोन्ग उंटाळ; तरीपण द्यावार ओकोळे उंदाड. ");
INSERT INTO wbq_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","'तर येम नियमशास्त्र इदी द्यावार वचनाविरुद्ध उंडाद? येपुळूच लेद येनटीक की जेम इद्देंग समर्थ उंडीनेद नियमशास्त्र इदेंग ओचका उंटोन्या तर, नितीमत्व खरेमे नियमशास्त्रता शिकतुन्या. ");
INSERT INTO wbq_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","तरी दान कना, नियमशास्त्रता आंदार पापला कोंडाशी फेट्या, इ उद्देशचंग की, विश्वास फेटेतोरकी येशु ख्रिस्त तोंन विश्वासता याद अभिवचन उंडाद आदी इयाला. ");
INSERT INTO wbq_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","पण ख्रीस्तला विश्वास वच्या दान पहिला, इदी जो विश्वास प्रकट आयेळदी उंड्या, वाड वचेकना पहिला मनाम कब्जाला उंनिमटीम मनालनी नियमशास्त्र किंदा इल्ला रखवालीला फेटीनीर. ");
INSERT INTO wbq_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","दिन मिंदीकेल मनाम विश्वास ता नीतिमान ठहराला दानचांग नियमशास्त्र मनालनी ख्रिस्त तीकुळ पोहोचा मत्तेळदी बीळा रक्षक उंड्या. ");
INSERT INTO wbq_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","गान इपूळ, विश्वासता वचकाम आयनाद उंडाद दानचांग मनाम दिन मुंदार बीळारक्षक भरोसाला नीला लेम. ");
INSERT INTO wbq_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","पण मीर आंदार ख्रिस्त येशुन मिंदा विश्वासद्वारा द्यावार कोडकु उंडार. ");
INSERT INTO wbq_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","येनटिक्की ख्रीस्तला मीदीनटल्या येंतामंदीद बाप्तीस्मा आयनाद आंता जन ख्रीस्तन परिधान शेस्तीनार. ");
INSERT INTO wbq_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","येहुदील किंवा ग्रीक, दास किंवा मोकळा लेद, मनशी किंवा आंडी इदी भेदे लेद येनटीक की ख्रिस्त येशुला मीर आंदार ओकोरे उंडार. ");
INSERT INTO wbq_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","इंगा मीर जर ख्रिस्ताटोर उंडार; तर अब्राहाम बीळा इंगा अभिवचन लेका वारीस उंडार. ");
INSERT INTO wbq_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","इप्पूळ नीन आणटान की, वारीस शिंना बीळा उंडाद, आपुळ नंताक वाळ आंदार कना वेदवाड उन्डीगाद पण वारदीनटल्या इंगा दासला एमी फरक लेकुंटाद. ");
INSERT INTO wbq_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","जर आब्बळ ठहरामतीने लेका मुदत लेका वाळ शिक्षकलाद इंगा कारभारी वशला उंटाळ. ");
INSERT INTO wbq_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","इल्ला प्रकार ता मनाम पण बीळलु उंडीनाप्पुड, मनाम जगाला पहिला शिक्षण दासला उंटाम. ");
INSERT INTO wbq_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","गान काळद पूर्णता आय्या आपुळ द्यावार स्वता कोळकून आंपळीच्या; वाळ आंडीदान देगारकेल जन्माश्या, नियमशास्त्र आधीन इल्ला जन्माश्या, ");
INSERT INTO wbq_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","दीनटल्या उद्देश इल्ला उंड्या की, नियमशास्त्र किंदा उंडीनेर नी मोल इच्ची इळपियाला; म्हणजे मनाक कोळकु आयेळदी हक्क शिक्काला. ");
INSERT INTO wbq_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","इंगा मीर कोळकुल उंडार आंका, द्यावार आब्बा-आब्बाड, इल्ला आवाज इच्छा वार, स्वता कोडकु आत्माद मिर नाद अंतकरणला आंपळीची नार; ");
INSERT INTO wbq_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","दानचांग नु इपूळ नुस दास लेव तर कोडकु उंडाव; इंगा कोडकु उंडाव, तर द्यावार द्वारा वारीस पण उंडाव. ");
INSERT INTO wbq_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","इंगा पहिला मीर द्यावार नी ओळखा कुंदुर, आपुळ, यवार स्वभाव ता द्यावार लेद वार दास उंनिंटी; ");
INSERT INTO wbq_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","पण इप्पूळ मीर द्यावार नि ओळखास्ताना किंवा द्यावर मिम्लान ओळखास्ताना मीर आ कमीबळ इंगा बिन इमफानिक लेद प्राथमिक शिक्षणतीकुड इंगा यल्ला वापस फोतार? इंगा वान दासला उणेद इच्छा शेस्तार? ");
INSERT INTO wbq_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","मीर दिनमूल, महिनाल, ऋतू इंगा वर्षल पण पाळास्तार. ");
INSERT INTO wbq_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","मीचंग शेशिनेय कस्टल कदाचित व्यर्थ फोइन्याला, इल्ला नाक मिबद्दल आदर वाटास्ताद. ");
INSERT INTO wbq_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","तामुलू इंगा शेल्यालु, नीन मिक विनंती शेस्तान की, मीर ना लेका कांडा, येनटिक्की नीन पण मी लेका उंटीन. मीर नाद एमी वाईट शेयाले. ");
INSERT INTO wbq_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","पहिला मीक मंची बातमी शेपेळदी पहिला घटना नाक ना शारीरिक त्रासलाता शिक्क्या इदी मिक यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","इंगा ना फईद कमजोरिद मिद परीक्षा आऊताना, मीर तिरस्कार शेइयाले पण ना द्यावार दूतलेका, ख्रिस्त येशु लेका स्वीकार शेश्स्तीर. ");
INSERT INTO wbq_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","तर आपुळदी मिद आशीर्वाद यंदू उंडाद? येनटीक की, नीन मि विषयला साक्ष इस्तान की, शक्य उंटे तर मीर नाक मिय स्वताय कनलु तिशी इस्तुंटीन. ");
INSERT INTO wbq_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","इंगा नीन मिक खरें शपतान दानचांग नीन मी वैरी आतीन येम? ");
INSERT INTO wbq_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","आ मंदी मी विषयाला बेक आंका तरी शिंगार प्रकार ता लेद पण मीर वार विषयला बेक आंका दानचांग वार मिंलान देगारकेल दुराम शेयदेंग सुस्तार. ");
INSERT INTO wbq_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","तर शिंगार शेशे इचांग हमेशा तयार उंडेद इदी शिंगार इंगा नीन मी देगारा प्रत्यक्ष उंडान आपुळे तयार उन्डला इल्ला लेद. ");
INSERT INTO wbq_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ना मंची बीळलु, मिदीनटल्या ख्रीस्तानदि रूप निर्माण आय्यी पर्यंत नाक मी कोळोन्ग इंगा गर्भवती त्रास आतुनाद. ");
INSERT INTO wbq_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","इ वेळ ला नीन मी संगा उन्टे इंगा आवाज चढा मत्ती माटलाळा वस्ते तर नाक शिंगार वाटास्तुन्या येनटीक की मिविषयला नीन चिंता ला उंडान. ");
INSERT INTO wbq_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","याय मीर नियमशास्त्र. लेका आदेंग सुस्तार आदी मीर नियमशास्त्र ऐकार येम? इदी नाक शपना. ");
INSERT INTO wbq_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","येनटीक की पवित्र शास्त्रला इल्ला लीवाशिणार की, अब्राहम की इद्दार कोळकुल उंडीर: ओगाळ दासी दान कोडकु इंगा ओगाळ मोकळा आंदी दान तीकेल आयनाद. ");
INSERT INTO wbq_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","गान दासी दान देगारकेल आईनेळ शरीरस्वभाव लेका जन्माशिन्या; तर मोकळा आंडीदान देगार नुस आईनेळ वचनता जन्माश्या. ");
INSERT INTO wbq_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","इ माटळू उदाहरण रुपता समजामत्तू शकास्ताम. आ आंडेर रोंड करारला लेका उंडार ओगाट सीनाय पर्वत मिन्दकेल शेशिनेद इंगा दासीला कोळोन्ग बीळलाक जन्म इचेतोळ करार म्हणजे हागार का. ");
INSERT INTO wbq_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","येनटीक की इदी हागार अरबस्तान लोंदी सिनय पर्वत उंडाद इंगा आदी इप्पूळदी येरुशलेम जोडीद उंडाद. स्वता बीळलासंगा दासला उंडाद. ");
INSERT INTO wbq_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","कोता मिन्दुळ दी यरुशलेम मोकळा उंडाद; इदि मना आंदर आम्मा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","पवित्र शास्त्राला इल्ला लीवाशिणार की, “हे गोडूदान, निक बीळलु का कुंडा पण, नु खुश उंड याय निक गर्भ त्रास काव, आय्यी नु खुशी ता जयघोष शे! खुशीता कीरली आन! येनटीक की यवार की मोगुळ उंडाळ वार बीळला पेक्षा, आशा ईडशिनेर बीळलु संगेम उंडार.” ");
INSERT INTO wbq_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","इप्पूळ बंधूल, इसहाकलेका मीर अभिवाचान टोर संतती उंडार. ");
INSERT INTO wbq_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","पण आ वेळ ला फईस्वभाव लेका यवार जन्माशिन्या, वाळ जो आत्मा लेका जन्मासने कोळकु लेका त्रास इच्या, आला इप्पूळ पण आतुनाद. ");
INSERT INTO wbq_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","पण शास्त्र लेख येम शप्ताद? 'नु आ दासी दानकी इंगा दान कोळकुक तीसुडू, येनटीक की दासी, दान कोडकु मोकळा आंडीदान कोडकु संगा वारीस काडच.' ");
INSERT INTO wbq_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","तर इंगा, तामुलू इंगा शेल्यालु, मनाम दासिदान बीळलु लेद, पण मोकळा आन्डीदान बीळलू उंडाम. ");
INSERT INTO wbq_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","इ स्वतंत्र कोळोन्ग ख्रिस्ता मनालनी मोकळा शेश्या दानचांग दानटल्या मीर टीकाशी उंडा इंगा दास पण लेका जुवा किंदा इंगा शिकाक कंडा. ");
INSERT INTO wbq_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","सुंडा, नीन पौल मिक इदी शेप्तान की, मीर जर सुंता शेसकोन्तीर आंटे तर मिक ख्रीस्तनदी उपयोग लेद. ");
INSERT INTO wbq_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","येनटीक की सुंता आईने हर वगा-वगा, मंशिक नीन इंगा दटाशी शप्तान की, वाळ पूर्ण नियम शास्त्र पाळादेंग कटीनेळ उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","नीयमशास्त्र: गों नीतिमान ठहराशेळ दी इच्छा फेटतार आदी मीर ख्रीस्तान अंतराशी उंडार; मीर कृपा अंतराशी उंडार, ");
INSERT INTO wbq_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","येनटीक की मनाम द्यावार आत्माता, विश्वासता, नितीमत्वद आशा फेटकोन उंडाम. ");
INSERT INTO wbq_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ख्रिस्त येशूनदीनटला सुंता एमी फनीद लेद इंगा सुंता नकानेद एमी सामर्थ्य उंडाद इल्ला लेद; त प्रेमलेका फनी शेशेळदी विश्वास दानटल्या सामर्थ्य उंदाद. ");
INSERT INTO wbq_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","मीर शिंगार फारका उंटीर ; मीर खरेंम पणाक मान्य का रोद आंका मिक यवाराना अडचण शेशीर? ");
INSERT INTO wbq_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","मिंलान यवार माटलाळ तुणार आ परमेश्वर इदी शिकवन काद, ");
INSERT INTO wbq_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","'रवा ने खमीर आंता फिन्डीदगोळा फुगा मत्तुताद.' ");
INSERT INTO wbq_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","नाक मी बद्दल प्रभूला खात्री उंडाद की, मीर दुसरा विचार शेयार पण मींलान घोटाला एकोचेतोळ मग वाळ येवार पण उंडानीवाळ दंड भोगाश्यार. ");
INSERT INTO wbq_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","इंगा तमुलू इंगा शेल्यालु, नीन जर इंगा सुंताद उपदेस शेस्ते, तर इंगा नाद छळ येनटीक आतुनाद? इंगा आल्ले उंटे तर क्रूसदी अडखन लेकुंतुन्या च. ");
INSERT INTO wbq_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","मी लोंदी ठायी अस्थिरता उत्पन्न शेषेटोर स्वताण फई कोसी वारते बागा आय्यी. ");
INSERT INTO wbq_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","येनटीक की बंधूल, मिक स्वातंत्र्य कोळोन्ग कुतेशिनार. तरी आ स्वातंत्र्य ला शरीर आकाल टोरकी संधी इया कुंडा. पण प्रेमता एकमेकोरदी सेवा शेईना. ");
INSERT INTO wbq_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","येनटीक की, 'यला स्वतामिंदा आल्ले शेजारील मिंदा प्रेम शेईना.' इदी ओकाटे वचन पाळास्ते पूर्ण नियमशास्त्र पाळा देंग वचीनाद. ");
INSERT INTO wbq_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","पण मीर जर एकमेकोरनी कोरकुतार अन तीनेस काळतार, तर मीर एकमेकोरदी नाश शेइया रोद आंका जपायणडा. ");
INSERT INTO wbq_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","दानचांग नीन आणतान, आत्मा दावाता नळना, म्हणजे मीर शरिरदि लालच पूर्ण शेयाके फोयार. ");
INSERT INTO wbq_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","येनटीक की शरीरदि लालच द्यावार आत्माविरुद्ध उंडाद इंगा आत्मा शरीर लालचविरुद्ध उंडाद ; इदी परस्पर विरुद्ध उंडाद, दिनकस्रोम येम पण मिद इच्छा उंटाद आदी मीर शेइयारोद. ");
INSERT INTO wbq_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","मीर द्यावार आत्मा प्रेरनाता नळशिनेर उंडार तर मीर नियमशास्त्र अधीन लेर. ");
INSERT INTO wbq_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","इपूळ शरीर फनील उघडा उंडाय इंगा आय्यी इ: व्यभिचार, अमंगलपना, कमजोरी, ");
INSERT INTO wbq_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","मूर्तीपूजा, करणी, वैर, झगडम, इर्शाम कोफाम, दुश्मन, फुट, गट, ");
INSERT INTO wbq_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","जलास्ता, धुंदी, दंगल इंगा इटला लेका इंगा; इटला विषयला नीन यला पहिला शप्पीनिटीन आल्ला इपूळ पहिला शप्तान की, इ माटलू शेशेटोरकि द्यावार राज्यद वतन शिक्का फोई. ");
INSERT INTO wbq_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","पवित्र आत्माद्वारे निष्पन आयेटी फळलु पण उंडाय प्रेम, खुशी, शांती, सहनशीलता, ममता, मंचीलेका, विश्वास पना, ");
INSERT INTO wbq_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","नम्रता संयम इ उंडाय; इटलाविरुद्ध नियम शास्त्र लेद. ");
INSERT INTO wbq_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","यवार ख्रिस्त येशुला उंडार वार शरीर दी भावना इंगा लालचला संगा शरीरस्वभावता क्रूस मिंदा खिळासनेर उंडार. ");
INSERT INTO wbq_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","मनाम, जर द्यावार आत्माद सामर्थता जागास्ताम तर मनाम आत्मा प्रेरणाताने नळाला. ");
INSERT INTO wbq_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","मनाम खाली अभिमान फेत्तेटोर, एकमेकोरणी चीड येकाचेटोर इंगा एकमेकोरदी हिरश्या शेशेटोर इल्ला उंडा; रोद. ");
INSERT INTO wbq_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","तमुलू इंगा शेल्यालु, यवरना मनशी ओको गुन्हाला शिक्या, तर मीर जे आत्मिक उंडार आदी वान सौमेताद आत्माता इंगा स्थापित एक्का दांडा; नु स्वता पण परीक्षाला फडारोद आंका स्वता तीकुड लक्ष इ. ");
INSERT INTO wbq_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","मीर एकमेकरदी बोरू, येतना म्हणजे इल्ला ख्रीस्तद नियम पूर्ण शेश्यार. ");
INSERT INTO wbq_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","येनटिक्की मनाम यवार लेकुंटे यवार तरी उंडार इल्ला मानास्ताम, वार स्वतान फसामत्तुतार. ");
INSERT INTO wbq_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","पण आंदार स्वता फनीद परीक्षा शेयाला इंगा, वांकी दुसरोंदी संबंध लेद, पण फक्त मनाला अभिमानला जागा शिक्की. ");
INSERT INTO wbq_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","येनटीक की, प्रत्येकजन स्वताद बोरू येत्ताने बेक. ");
INSERT INTO wbq_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","यवार की वचन दी शिक्षण शिक्ताद वाळ शिक्षण इचेटोरकी आन्नी प्रकारी शिंगार पदार्थद भाग इयाला. ");
INSERT INTO wbq_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","फसाया कानडा, द्यावार्दी उपहास काक फोई येनटिक्की मनशी येम पण पेरास्ताळ आद्दे पिक वानकी शिक्ताद. ");
INSERT INTO wbq_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","येनटीक की यवार मना शरीर कोळोन्ग पेरास्ताळ वांकी शरीर तीकेल नाशदी पीक शिक्ताद, पण यवार द्यावार आत्मा कोळोन्ग पेरास्तार वानकी आत्मातीकेल सर्वकाळदी जीवनदी पिक शिक्ताद. ");
INSERT INTO wbq_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","इंगा मंचीद शेशेळदी मनाम कंटाळ शेयारोद; येनटिक्की मनाम निराश का रोद, तर ठहरासने वेळेला कोयाला. ");
INSERT INTO wbq_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","येनटिक्की मनाक संधी उंटे आले मनाम आंदारदी शिंगार शेयाला इंगा विशेषतः विश्वासता वगा इलुटोर ओकातळा वचीनेर विश्वास फेटेतोरदी शिंगर शेयाला. ");
INSERT INTO wbq_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","सूडना, यंता फेदाद अक्षरला, नीन मिक स्वता: शेईतोंन लीवास्तुनान. ");
INSERT INTO wbq_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","यंता शारीरिक माटालदी शहाणपणा मीरवादेंग सुस्तार आंता वारदी ख्रीस्तद क्रूस कोळोन्ग वारदी छळ का रोद दानचांग मींलान सुंता शेयदेंग भाग केळपुतार; ");
INSERT INTO wbq_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","येनटीक की यवार्दी सुंता आयनाद वार स्वत: त नियमशास्त्र पाळायार पण मी शरीर दा गर्व शयला, दानचांग, मिद सुंता काला इल्ला वारदी इच्छा फेटतार. ");
INSERT INTO wbq_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","मना प्रभू येशु ख्रिस्त इनदी क्रूस अभिमानशिवाय याद पण अभिमान शेस्काम ना देगारकेल दुराम उंडाला पण यवार द्वारा दुन्याम नाक शिक्या इंगा नीन जगनी क्रूस मिंदा खिळाशीनान. ");
INSERT INTO wbq_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","येनटिक्की सुंता आईदेंग किंवा सुंता का कुंटे एमी लेद, तर कोत्ताद शुरुवात इदे येम आदी का. ");
INSERT INTO wbq_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","इंगा यवार इ नियमता नळस्तार इल्ला आंदार मींदा इंगा द्यावार इस्राइल मिंदा शांती इंगा मया उंडाला. ");
INSERT INTO wbq_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","इपूड नुस यवार नाक त्रास इया रोद, एनटिक्की नीन स्वता शरीर मिंदा येशुन निशानलू धारण शेशिना. ");
INSERT INTO wbq_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","'तामुल इंगा शाल्यालू, मना प्रभू येशु ख्रीस्तद कृपा मी बरोबर उंडाला. आमेन.");
INSERT INTO wbq_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","परमेश्वर आब्बा इंगा प्रभू येशु ख्रिस्ता वारता उंडीन्द थेस्सलनिका शहराल्द मंडळी दान्क पौल, सील्वान तिमथ्य वानद्वारे मीरक कृपा व शांती उंडान. ");
INSERT INTO wbq_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","मीम मनाद प्रार्थनाला मीद आठवण शेस्केन सर्वदा मीर आंदार ईशयला परमेश्वरदी उपकार स्तुति शेस्ताम. ");
INSERT INTO wbq_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","मनाद द्यावार आब्बा मुदारा मीरद इश्वासागोन शेशीद फणी, प्रीतीगोन शेशीन्द श्रम व मनाद प्रभू येशु ख्रिस्तामिदूडद आशेगोन फटीन्द सहनशीलता दान्द मीम निरंतर आठवण शेस्ताम. ");
INSERT INTO wbq_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","तम्मूलु, मीर द्यावारद प्रिय उंडार, मीद आईन्द निवड माक यरका उंडादच; ");
INSERT INTO wbq_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","कारण माद सुवार्ता केवळ शब्दागोन लेद, तर सामर्थ्यागोन, पवित्र आत्म्यागोन व पूर्ण खात्रीगोन मीरक तेलपदेन्क वच्या आळाच मीर इचाका मीम मीरबराबर उंडीनाप्पुड यळा वागास्तीम इदी मीक यरक्का उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","मीर शना संकटाला उंडीनाप्पुड पवित्र आत्म्याद आनंदागोन वचन अंगीकार शेशी माद प्रभून्द अनुकरण शेशातोर आयिर; ");
INSERT INTO wbq_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","एलाकी मासेदोणीया व अखया दाटलोन्द आंता इश्वास फेट्या तोरक मीर उदाहरण इळा आइनेद उंडार. ");
INSERT INTO wbq_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","मासेदोणीया व अखया दानटल्या मिरतिकूट प्रभून्द वचनाद घोषणा आईन्द उंडाद; इन्ताच केवळ लेद तर परमेश्वर मिन्दुडदी मिद इश्वासाद बातमीही आन्तातिक पसराशिंद उंडाद; दानगोन दानइश्य माक यम शपेद गरज लेद. ");
INSERT INTO wbq_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","कारण मिरता माद वचेद याद प्रकारद आय्या, इदी वार मनाम आइ माईशयला शपतार; मीर मूर्तीदग्गारनूट परमेश्वरतीक यळा वळास्तीम इंगा जीवंत व खरेम परमेश्वर सेवा शस्देन्क, ");
INSERT INTO wbq_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","इंगा वान्द कोडकु येशु वान्द स्वर्गानूट वच्चेद दावा सूस्देन्क, वाड कडंकु आंटे येशु वान्क द्यावारा सावानूट लेफ्या व वाड मना भावी क्रोधानूट इडशातोड उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","तम्मूडलु, मिरता माद वच्चेद व्यर्थ आइनेद लेद, इदी मिरकबी यरक्का उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","पन पूर्वी फिलीप्पैला मीम दु:ख भोगाशी व अपमान सोसाशी, इदी मीरक यरक्काच उंडाद, फेदाद इरोध उंडीनाप्पुड, परमेश्वरदी सुवार्ता मीरक शपेद धैर्य मना परमेश्वरतीकूट माक शिक्या. ");
INSERT INTO wbq_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","आनकेन माद बोध फसवाशी लेकाते अशुद्धपणा दाटलोण्द निर्माण आइनेद लेद तर कपटाद लेकुण्ड्या; ");
INSERT INTO wbq_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","तर सुवार्ता माता सोपवाशी इस्देन्क परमेश्वर माक पारखाशी पसंत शेशा आणकेन मीम आदि शपतान; मीम आरवाल्क खुश शेशातोर ल्यका न माटलाडता माद अंतकरणलु पारखाशातोड द्यावारा इड दानगोन खुश आइ आळा माटलाडस्तान. ");
INSERT INTO wbq_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","कारण मीम खुशामत शेशातोर भाषण यप्पुड शेशा लेकुण्डतीम, इदी मीरक यरक्का उंडाद आळाच लोभ फेटी ढोंगीपणागोन वागाया लेद. परमेश्वर साक्षी उंडाद; ");
INSERT INTO wbq_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","मीम ख्रिस्ताद प्रेषित उंडाम आनकेन जरी माक मनाद विशेष अधिकार नेडस्देन्क वसतूण्ड्या तरी मीम आरवालतिकूट, मीरतिकूट इंका दुसऱ्यालतिकूट गौरव शिक्काला आणकेन खटपट शेशा लेकुनडतीम; ");
INSERT INTO wbq_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","तर मनाद बिळा बिस्काल्द पालनपोषण शेशातोर आम्माल्यका मीम मिरता सैम्य व्रत्तीद उंडाम. ");
INSERT INTO wbq_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","माक मीरदइश्यला कळकळ वाटास्तूण्ड्या आणकेन मीम मीरक केवळ द्यावारद सुवार्तेद दानच इस्देन्क लेद, तर मीरमिदूडद माद अत्यंत प्रीतीगोन मीरइच्चाका मनाद जेमबी इस्देन्क तयार उंडतीन. ");
INSERT INTO wbq_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","तम्मूलु, माद श्रम व कष्ट दान्द आठवण मीरक उंडाद; मीतूडद यवारक माद भर आवाक आणकेन मीम फदूमाफुक उद्योग शेशी मिरमुदारा द्यावारद सुवार्तेद घोषणा शेस्तीम. ");
INSERT INTO wbq_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","मीर ईशवास फेट्यातोरला मीम पवित्रतेगोन, नितीगोन व निर्दोषतेगोन यळा वागास्तीम दानईशयला मीर साक्षी उंडार व परमेश्वरदीबी उंडाद ");
INSERT INTO wbq_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","मीक यरकाच उंडाद की, आब्बा मनाद बिळाक शेस्ताड आळा मीम मीरपैकी प्रत्येकोरक बोध शेस्केन, धीर इच्ची व आग्रहपूर्वक विनंती शेस्केन शपतीन की, ");
INSERT INTO wbq_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","जो परमेश्वर मना राज्यला इंगा गौरवाला मीरक पाचारण शेस्ताड वान्क शोभाशी इळा मीर नेडशेद. ");
INSERT INTO wbq_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","इदी कारणामगोन मीम सुद्धा द्यावारद निरंतर उपकारस्तुति शेस्ताम की, मीर मादग्गारनूट इनीन्द द्यावारद वचन स्वीकारशा आदि आरवाद आणकेन लेद तर द्यावारद आणकेन स्वीकाराशा इंका खरेम सुस्ते आदि आळाच उंडाद; आदि मिरता ईशवास फेट्यातोरला कार्य शेस्तात. ");
INSERT INTO wbq_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","तम्मूनो, यहुदीयाल परमेश्वर ज्या मंडळ्या ख्रिस्त येशून्द ठायी उंडाय दान्द अनुकरण शेशातोर आय्या, आंटे वार यहुद्यांद शेय्यनूट जी दु:ख सोसाशीर आळाच मिरबी मनाद स्वदेशीवारद शेय्यनूट सोसास्तिम; ");
INSERT INTO wbq_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","आ यहुदी वार प्रभू येशुन व संदेष्टयालवारकबी जीवे मतिर इंगा माद छळ शेशी माक बयट्या आमशिर; वार परमेश्वरक संतोषवाशा लेद व आंता आरवालद इरोधी आइनेद उंडार; ");
INSERT INTO wbq_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","परराष्ट्रीयान्द तारण आवाला आणकेन मीम वानसंगा माटलाडशेद दान्द वार मनाई शेस्तार; इदी दानइच्चाका की, वार मनाद पापुल्द माप सर्वदा निचका उंडला निलवाला; वान्द मिदूडद द्यावारद क्रोधाद परिसीमा आइनेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","तम्मूनो, मीम हृदयगोन लेद तर देहागोन मिरतिकूट रव्वा येळ येगळा आइनेद माक वीरह दु:ख आय्यी मीरद मुती सुशेद मीम शना उत्कंठेगोन इशेष प्रयत्न शेस्तिम; ");
INSERT INTO wbq_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","दानगोन मीम मिरतीक वच्चेद इच्छा फटतीम; नीन पौल ओकादम लेद तर रोन्डदमूल इच्छिले परंतु सैतानाड माक आडवाशा. ");
INSERT INTO wbq_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","आणकेन मनाद प्रभू येशु ख्रिस्ताद समक्षतेला, वान्द वच्चेद येळक माद आशा इंका माद आनंद इंका माद अभिमानाद मुकुट यम उंडाद? मिरच उंडार रा? ");
INSERT INTO wbq_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","कारण मीर माद गौरव व माद आनंद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","आणकेन मादगोन इन्का दम फटाद, आप्पुड अथेनै शहराला वागाडे यंका निलवाला, इदी माक बागा वाटाशा. ");
INSERT INTO wbq_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","इंगा मीम मनाद तम्मू तिमथ्या, ख्रिस्ताद सुवार्तेला परमेश्वरद सेवक वान्क दानइच्चाका आमशा की, वाड मीरक स्थिर शेयाल इंका मीरद ईशवासान्द वाढी ईशयला उपदेश शेयाला; ");
INSERT INTO wbq_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","आदि इळा की, इदी संकटाला यवार यरस्कूनेद लेद; आणकेन मनाम दानइच्चाकाच नेमाशीन्द उंडाम. इदी मीर स्वतः जाणाशी उंडार. ");
INSERT INTO wbq_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","कारण मीम मीरदग्गारा उंडतीम आप्पुड मीम मीरक शपी फेटतीम की, मनांम्क संकटाल भोगाशेद उंडाद इंका वान प्रमाणगोन घडाशीन्द, इदी मिरक यरकाच उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","दानगोन नाकबी इंन्का दम फटाद, आणकेन नीन मीरद ईशवासाद संबंधागोन ईचारपुस शेशेद आमस्तीम; यवार जाणे, कदाचित परीक्षा तीस्कोनोर मीरक मोह येस्कूनीर आणकेन माद फनी व्यर्थ आईन्द उंडी. ");
INSERT INTO wbq_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","इप्पुड तिमाथ्याद मीर द्यग्गारनूट मातीक वच्ची, मीरद इश्वास व प्रीती दानईशयला इंगा यळा मीम मीरक भेटायदेन्क उत्साहित उंडाम आळा मिरबी माक भेटायस्देन्क उत्साहित उंडार माद प्रेमागोण नेहमी आठवन शेस्ता दिन विषय शुभवर्तमान मातीक येतकेणवच्चीर; ");
INSERT INTO wbq_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","दानगोन तम्मूनो, माक मनाद आंता अडचणला व संकटाला मीरद ईश्वासमिंदूडद मीरईशयंद समाधान शिक्क्या; ");
INSERT INTO wbq_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","कारण जर मीर प्रभूला खंबीरपणागोन टीकास्तार तर इप्पुड मीम जेमूलाजेम वच्चीन्दल्यका निलस्तार. ");
INSERT INTO wbq_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","आणकेन मना परमेश्वर मुदारा, मीम मिकसारोम, याय आंता आनंदागोण आनंद शेस्ताम आबद्दल मीम परमेश्वरक मीरकस्रोम यम धन्यवाद ईस्ताम? ");
INSERT INTO wbq_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","मीम मब्बू माफक पुष्कळ प्रार्थना शेस्ताम की, मीम मीक मुतीमुदारा सुडाला इंगा मीरद ईशवासाला कमी उंडाद आदि पूर्ण शेयाला. ");
INSERT INTO wbq_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","परमेश्वर, मानाद आब्बा वाड स्वतः व मनाद प्रभू येशु वाड, माद मिरतीक वच्चेद यमटीदबी अडचण न वस्ता आइ इयाला; ");
INSERT INTO wbq_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","इंका जशी माद प्रीती मीरमिंन्दा उंडाद, इळा प्रभू मीरद प्रीती वगारमेंगारमिंदा व आंदारमिंदा वाढवाशी विपुल शेयाल; ");
INSERT INTO wbq_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","दिन कसरोम की, मनाद प्रभू येशु मनाद आंदार पवित्र जनालसह वच्ची आयेळक वाड मीरद अंतकरणलु द्यावारा मनाद आब्बा वानमुदारा पवित्रतेला निर्दोष आयद इच्चाका स्थिर शेयाल. ");
INSERT INTO wbq_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","तम्मूडलु, शेवटी मीम मीरक विनंती शेस्ताम व प्रभू येशूनडमा बोध शेस्ताम की, याद वागणुकीगोण द्यावारक संतोष आवाला इदी मीरक मातीकानोल इनी तिस्कूनीर व मीर आप्रमानगोन वागास्तार, दानटल्या मीरद शना-शना वाढ आवाला. ");
INSERT INTO wbq_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","कारण प्रभू येशून्द तीकनोल यादयाद आज्ञाल मीम मीरक इस्तीम आदि मीरक यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","कारण परमेश्वरद इच्छा इदी उडाद की, मीरद पवित्रकरण आवाला, आंटे मीरद जारकर्मानूट दुराम निलवाला ");
INSERT INTO wbq_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","इंका मीरदाटलोर प्रत्येकोरक समजायला की, यवार वारक मनाद देहाला पवित्रतेगोन व आदरबुद्धीगोन मनाद स्वाधीन यळा शेशी इयाला. ");
INSERT INTO wbq_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","द्यावारक न ओळखाशातोर उन्गोजातीगों वासनेद लोभागोन शय्या कला. ");
INSERT INTO wbq_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","यवाड इदी कथालोंद उल्लंघन शेशी मनाद व तम्मून्द गैरफायदा तिस्कूनेद लेद कारण प्रभू इदी आंता कथालबद्दल शासन शिशातोड उंडाद; इदी मीम मीरक पहिला शपीन्द उंड्या व बजावाशीन्द उंड्या. ");
INSERT INTO wbq_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","कारण परमेश्वर मनाक अशुद्धपणा कस्रोम लेद तर पवित्रतेकसरोम पाचारण शेशीन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","आणकेन यवाड बी नकार शेस्ताड वाड मंशीद लेद तर मीरक मनाद पवित्र आत्मा इच्च्यातोड द्यावारा वान्द नकार शेस्ताड. ");
INSERT INTO wbq_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","तम्मू प्रेमाविषला मीम मीरक राशेद दान्द मीरक गरज लेद; कारण वगारमेंगारमिंन्दा प्रीती शेयाला, इळा मीरक द्यावाराच नेरपीन्द उंडाद; ");
INSERT INTO wbq_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","इंका संपूर्ण मासेदोनियाल्द आंता तम्मूवर्गामिंदा मीर आदि शेस्केन उंडाम. तरी तम्मूलु, मीम मीरक बोध शेस्ताम की, आदि शना-शना शेयाला. ");
INSERT INTO wbq_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","मीम मीरक आज्ञा शेशीन्द प्रमाण शांतीगोण निलू. ओगार मेगार्दी फनील शेषेद इंगा स्वताय शेता फनी सेयाबेक दिंदि आवड मिक नीलाला. ");
INSERT INTO wbq_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","बयटूडद मंदीबराबर सभ्यतेगोन वागाशेद इंगा मीरक यमटीदबी गजर फडायाद. ");
INSERT INTO wbq_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","पण तम्मूडलु, नीन इच्छित लेद की, जे सच्चिनार दानइश्यला मीर अज्ञानी उंडाला, आंटे यवारक आशा लेद इळा इतरांप्रमान मीर दु:ख शय्याक. ");
INSERT INTO wbq_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","कारण येशु सच्चा व इंन्का लेशा इळा जर मनाम इश्वास फेटताम, तर येशूनडमा जे सचतार वारकबी द्यावारा वान्दबराबर यतकण्यार. ");
INSERT INTO wbq_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","कारण प्रभून्द वचना मिदूडद मीम मीरक इदी शपताम की, मनाम जिता उंडाम व जे प्रभून्द वच्चीनदन्का यक्का नील्ताम, आदि मीम आडदन्का सच्चीन्द मुदारा फयातोर कान. ");
INSERT INTO wbq_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","कारण आज्ञा शेशातोरक गर्जणेगोन, आद देवदुतान्द वाणी इंका परमेश्वरद कण्ऱ्यानदी आवाज वच्ची, आप्पुड प्रभू स्वतः स्वर्गानूट उतराशी इंगा ख्रिस्ताला सच्चीन्द प्रथम लेशार. ");
INSERT INTO wbq_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","मग मनाम जे जिंता उंडाम व यक्का नीलस्ताम, आदि प्रभून्क अंतराळला भेटायदेन्क मॉडामला उचलाशी फयाम इंगा आंता कालाम प्रभुबराबर निलचेद. ");
INSERT INTO wbq_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","आणकेन मीर इदी वचनाद ओकामेकोर्दी सांत्वन शयडा. ");
INSERT INTO wbq_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","तम्मूलु, काळ व समय दानइशय मीर यम राशेद गरज लेद. ");
INSERT INTO wbq_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","कारण मी स्वताक पक्का यरका उंडाद की यळा मब्बुक दोंगाल वसताड, आळाच प्रभून्द दीनुम वच्ची. ");
INSERT INTO wbq_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","“शांती उडाद, सुरक्षितता उंडाद” इळा वार आणटार, आप्पुड रंजल्मान्सी आन्तिक यला अचानक वेदना सुरू आवताद आप्रमानगोन वारद अचानक नाश आय्यी इंगा आदि निभावाशा लेद. ");
INSERT INTO wbq_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","तम्मूलु, आ दिनूमला दोंगालल्यका मीर गाठाशेद इळा मीर गंडदला लेद. ");
INSERT INTO wbq_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","कारण मीर आंदार यलगद प्रजा व दीनुम्द प्रजा उंडार; मनाम मब्बूद व गडदल्द लेद. ");
INSERT INTO wbq_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","दानमिदूडद मनाम इनगोरगता निदार तिस्कूनाक, तर मेलका व सावध निलवाला. ");
INSERT INTO wbq_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","निदार तिस्कून्यालोर मब्बूक निदार तिस्कूनतार इंगा झिंगाशातोर मब्बूक झिंगास्तार. ");
INSERT INTO wbq_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","इंगा या मनाम दिनूमूद उंडाम आ मनाम सावध उंडाला; इश्वास व प्रीती इदी उरस्त्राण व तारणद आशा इदी शिरस्त्राण यसकूनेद. ");
INSERT INTO wbq_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","कारण मनामिंदा क्रोध आवाला आणकेन लेद तर मनाद प्रभू येशु ख्रिस्त वानद्वारे मनाद तारण आवाला आणकेन द्यावारा मनाम्क नेमाशीन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","प्रभू येशु क्रिस्त मानाकास्रोम दिन्कासारोम सच्च्या की, मनाम जरी यक्का नीलस्तीम इंका सचतीम तरी मनाम वानसंगा जीता निलवाला. ");
INSERT INTO wbq_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","आणकेन मीर वगामेंगारद उस्त्साहीद शयडा इंगा वगामेंगारद येतंडा वाहिक; इदी मीर शेस्तारबी. ");
INSERT INTO wbq_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","इंगा तम्मूलु, मीम मीरक विनंती शेस्ताम की, जे मिरता परिश्रम शेस्तार, यावार प्रभूला मिरमिन्दा उंडार इंगा मीरक बोध शेस्तार वारतीक लक्ष्य इडा; ");
INSERT INTO wbq_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","इंका वारिक वारद फानीमिदुट प्रीतीगोन शना वेदाद मानायण्डा इंका वगारमेंगार संगा शांती गोन निलू. ");
INSERT INTO wbq_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","इप्पुड तम्मूलु, मीम मीरक बोध शेस्ताम की, याव्वर अव्यवस्थित उंडार वारिक मीर इशारा इडा, यावार अल्पधिराद उंडार वारिक धीर इडा, अशक्त उंडार आधार इडा; आंदार संगा सहनशील उडण्डा. ");
INSERT INTO wbq_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","इंका मीर इदी सुडा की, यवार यवारक वाईटाबद्दल वाईट इळा निची एयाकाला; पण मिरता वगारमेंगार कसरोम व आंन्तामंदीक याद बागा उंडाद दान्द्द सतत यक्का आन्टनडा. ");
INSERT INTO wbq_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","येपुड भी आनंद शयडा. ");
INSERT INTO wbq_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","नित्य प्रार्थना शयडा. ");
INSERT INTO wbq_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","प्रत्येक कथाला उपकार मानायंण्डा कारण मीर संबंदी ख्रिस्त येशुला द्यावारद इच्छा इदीच उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","पवित्र आत्म्याला आरपाकुंडा. ");
INSERT INTO wbq_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","संदेशाल्द उपहास शयाकण्डा. ");
INSERT INTO wbq_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","आंता कथाल्द पारख शयडा. याद मंचीद उडाद आदि मजबूत फटण्डा. ");
INSERT INTO wbq_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","वाइटादआंता प्रकारानूट दुराम निलू. ");
INSERT INTO wbq_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","इंगा स्वतः शांतिद द्यावारा मीरक पूर्ण पवित्र शेशी; इंका मनाद प्रभू येशु ख्रिस्त वान्द वच्चेद आइ आप्पुड मीरद आत्मा, जेम इंगा फय पूर्ण निर्दोष निलवाला. ");
INSERT INTO wbq_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","मीरक जो फीलस्ताड वाड ईशवासू उंडाड; वाड आदि शेशीच. ");
INSERT INTO wbq_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","तम्मूलु, माइच्चाका प्रार्थना शयण्डा. ");
INSERT INTO wbq_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","आंता तम्मून्क पवित्र प्रीती तोंन नमस्कार शपण्डा. ");
INSERT INTO wbq_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","नीन मीक प्रभून्द आज्ञा आणकेन शपतान्की की, इदी पत्र आंता तम्मून्क वाचाशी सूपण्डा. ");
INSERT INTO wbq_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","मनाद प्रभू येशु ख्रिस्त वान्द कृपा मीर संगा उन्डला. आमेन.");
INSERT INTO wbq_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","परमेश्वर माद आब्बा व प्रभू येशु ख्रिस्त वान्द दिन टला उंडीद थेस्सलनिका शहराल्द मंडळीक पौल, सील्वान व तिमाथ्य वानतीकूट: ");
INSERT INTO wbq_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","द्यावार आब्बा व प्रभू येशु ख्रिस्त वानद्वारे मीरक कृपा व शांती उंडाला. ");
INSERT INTO wbq_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","तम्मूलु इंगा शेल्यानलु, मीम सर्वदा मीरईशयला द्यावारद उपकारस्तूती शेस्देन्क बेक इंगा इदी योग्यच उंडाद कारण मीरद इश्वास संना वाडास्तात इंका मीर आनदारला प्रत्येकोरक वगामिगारमिंदूडद प्रीती संग्याम वाडास्ताद ; ");
INSERT INTO wbq_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","दानमिंदुट मीद आंता छळाला व मीर जी सहनशीलता व जो इश्वास सुपतार आबद्दल द्यावारद मंडळ्यानूट मीम स्वतः मीरद माक गर्व उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","वार परमेश्वरद योग्य न्यायाद प्रमाण आदि; न्याय इदी की, आइच्चाका मीर दु:खम सोसासतार आ परमेश्वरद राज्याला मीर योग्य ठराशी फोवाला. ");
INSERT INTO wbq_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","मीर मिंदा संकट येतकेण वच्च्यातोर मंदिद संकटागोन परतफेड शेशेद इंगा संकट सोशातोर मीरक मासंगा विश्रांती इच्चेद, इदी द्यावारद दृष्टीगोन न्याय उंडाद, ");
INSERT INTO wbq_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","आणकेन प्रभू येशु प्रकट आय्येद समयी ला आइ; वाड मनाद सामर्थ्यवान देवदूतासंगा स्वर्गानूट अग्निज्वाला संगा प्रकट आइ. ");
INSERT INTO wbq_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","आप्पुड यावार द्यावारक गुड तू फेट्यालेद व मनाद प्रभू येशून्द सुवार्ता मानाशा लेद वानिक वाड दंड इच्ची. ");
INSERT INTO wbq_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","आप्पुड वारन प्रभू न्द मुदारनूट व वान्द सामर्थ्याद गौरवानूट दुराम शेसदेन्क वच्ची सार्वकालिक नाश इदी शिक्षा वारक शिक्की. ");
INSERT INTO wbq_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","मनाद पवित्रजनांद ठायी गौरव शिकाला आणकेन इंका आ दिवस ला पवित्रजनांद ठायी आश्चर्यपात्र आवाला आणकेन वाड वची कारण मीम इच्चीन्द साक्षी मिंदा मीर इश्वास फेटीन्द उंडार. ");
INSERT INTO wbq_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","दानइच्चाका तर मीम मीर इच्चाका सर्वदा इळा प्रार्थना शेस्ताम की, मनाद द्यावारा मीरक आइनेद वांद पाचारानक योग्य इळा मानाशेद इंका चांगुलपणाद प्रत्येक मनोदय व ईशवासाद कार्य सामर्थ्यागोन पूर्ण शयाला; ");
INSERT INTO wbq_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","दानइच्चाका की, मनाद परमेश्वर प्रभू येशु ख्रिस्त वान्द कृपेगोन मनाद प्रभू येशु वान्द फेरक मीरद ठायी व मीरक वानठायी, गौरव शिकाला. ");
INSERT INTO wbq_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","तम्मूडलु इंगा शेल्यानलु, मनाद प्रभू येशु ख्रिस्ताद वच्चेद इंगा वानदेगारा मनाद वगातडा आय्येद इदी संबंधागोन मीम मीरक इळा विनंती शेस्ताम की, ");
INSERT INTO wbq_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","मीर लगेच दचकाशी थांबा वायाकांडा इंगा यरसकुणाकण्डा; प्रभून्द दीनुम वची ठेपाशीन्द उंडाद इळा शप्यातोरक आत्म्यागोन इंन्का जणूयेम मतीकनोल वचीन्द वचनागोन लेकाते पत्रागोन यरस्कुणाक; ");
INSERT INTO wbq_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","यादबी प्रकारे यवारतिकूट फसायाक; कारण आ दीनुम्द पहिला विशावासद त्याग आइ वाड अनीतीमान मणशी, नाशाद कोडकु प्रकट आइ; ");
INSERT INTO wbq_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","वाड नाशाद कोडकु, इरोधी व यवारक परमेश्वर इंका उपासणीय आणकेन आणटार आ आंदार किन्टा स्वत वेर वेदाद शेशातोड, आंटे नीन परमेश्वर उंडान, इळा स्वताद प्रदर्शन शेशी परमेश्वरद भवनाला कुसण्यातोड इळा उंडाड. ");
INSERT INTO wbq_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","नीन मिरसंगा उंडीनाप्पुड इदी मीरक शपतूण्ड्या इळा वान्द मीरक द्यानम लेद यम? ");
INSERT INTO wbq_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","वाड नेमाशीन्द समयीच प्रकट आवाला, उन्गो येळी आवाराद, आणकेन यवार इप्पुड बंध शेस्तार आदि मीरक यरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","कारण अनीतीद रहस्य इप्पुडच मनाद कार्य नेडस्ताड, पन जो इप्पुड अडथळा शस्ताड वान नडमीनुट तिशी फेकाशी आय्यी पर्यंत अडथळा शेस्केन निलची; ");
INSERT INTO wbq_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","मग वाड अनीतीमान मणशी प्रकट आइ, वान्क प्रभू येशु मनाद नोटलोंन्द श्वासागोन मती वर्षी इंगा वाड वच्यातापूड मनाद दर्शनागोन वान्क नष्ट शेशी; ");
INSERT INTO wbq_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","सैतानाद कृतीगोन वान्द वचेद आय्यी; वाड आंता प्रकारे खोटी सामर्थ्य, आळाच चिन्हल व अद्भूते शेस्केन वची ");
INSERT INTO wbq_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","यवारद नाश आवाका वचीद उंडाद वार मनाद तारण साधायाला आनकेन सत्याईशयद प्रीती फेट्या लेद; दानकसरोम वानकसारोम सैतनाद कृतीप्रमानगोन आंता प्रकारद खोटी महत्क्रत्ये, चिन्हल, अद्भूते इंगा आंता प्रकारद अनीतीजन्क कपट दिनगोन युक्त इळा आ अनीतीमानाद वच्चेद आय्यी. ");
INSERT INTO wbq_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","वार असत्यमिंदा ईशवास फेटाला आणकेन परमेश्वर वानठायी भ्रांतीद कार्य नेडशी इळा शेस्ताड; ");
INSERT INTO wbq_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","यवार सत्यामिंदा ईशवास फेट्या लेद, तर अनीतीला संतोष मानशा आ आनदारद न्याय निवाडा आवाला आणकेन इळा आइ. ");
INSERT INTO wbq_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","प्रभूद प्रियजनहो, मीर ईशयला मीम द्यावारद उपकारस्तुति नेहमी शायला कारण पवित्र आत्म्याद्वारे आईन्द पवित्रत्री करणाला सत्यामिदूडद इश्वासाला परमेश्वर मीरक प्रथमफळ आनकेन तारणाइच्चाका नेमिशिन्द उन्डाद; ");
INSERT INTO wbq_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","दानटल्या वाड मीमलान माद सुवार्तेद द्वारे मनाद प्रभू येशु ख्रिस्ताद गौरव प्राप्त शेशी तिस्कून्याइच्चाका पाचारण शेशीन्द उंडाद. ");
INSERT INTO wbq_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","इंगा मग तम्मूलु इंगा शेल्याल, स्थिर निलूण्डा इंका मुती इंका माद पत्राद्वारे जे संप्रदाय मीर्क नेरप्या आदि बळकट फटी निलूण्डा. ");
INSERT INTO wbq_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","मनाद प्रभू येशु ख्रिस्त वाड इंका यवार मनामिंदा प्रीती शेशी आंता कालाम्द सांत्वन इंगा बागा इळा कृपेगोन इच्चा वाड परमेश्वर मनाद आबाड, ");
INSERT INTO wbq_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","मीद मनसद सांत्वन शेयाला इंका प्रत्येक बागा फनीला इंगा कथाला मीक स्थिर शेयाला. ");
INSERT INTO wbq_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","आखरीक तम्मूडलु इंगा शेल्यानलु, इप्पुड इन्ताच शपेद उंडाद की, माकसरोम प्रार्थना शेस्केन उंडानडा की, यळा मिरता आय्या आप्रमानगोन प्रभून्द वचनाद लगाना प्रगती आवाला व वान्द गौरव आवाला; ");
INSERT INTO wbq_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","इंका हेकेखोर व दृष्ट माणशी तीकनोल माद संरक्षण आवाला; दान कसरोम प्रथांना शयांनडां कारण आंदार ठायी इश्वास उंडाद इळा लेद. ");
INSERT INTO wbq_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","परंतु प्रभूड ईश्वसणीय उंडाद, वाड मीरकस्थिर शेशी व आ दुष्टातीकानोल राखाशी. ");
INSERT INTO wbq_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","मीर इशय प्रभूला माद इळा इश्वास उंडाद की, मीम मीरक जे आज्ञा इस्ताम आदि मीर शेस्तार व मुदाराबी शेशार. ");
INSERT INTO wbq_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","प्रभु मीरद मनस परमेश्वर मिदूडद प्रीतीतीक व ख्रिस्ताद सहनशीलतेतीक अनु. ");
INSERT INTO wbq_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","तम्मूडलु इंगा शेल्यानलु, मीम मनाद प्रभू येशु ख्रिस्ताद फेरगोन मीरक आज्ञा शस्ताम की, अव्यवस्थितपणा वागाशातोरक व नेडशातोरक संप्रदायप्रमानगोन प्रत्येक तम्मूलतिकूट मीर दूर आवाला. ");
INSERT INTO wbq_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","माद अनुकरण याद रितीगोन शेस्देन्क बेक इदी मीरक स्वत क यरका उंडाद; कारण मीम मिरता निल्चेद आप्पुड अव्यवस्थितपणा वागाया लेद; ");
INSERT INTO wbq_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","इंका मीम यवारद अनाम हुकाट तिना लेद; परंतु मिरपैकी यवार मिंदाबी बोरू येशेद लेद दान्कासारोम मीम मब्बूदीनुम श्रम व कष्ट शेशी फणी शेस्तीम. ");
INSERT INTO wbq_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","आळा माक अधिकार लेद इळा लेद, पण माद अनुकरण शेस्देनक मीम मीरक उदाहरण येस्देन्क इयाला आणकेन इळा शेस्तीम. ");
INSERT INTO wbq_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","कारण मीर संगा उंडतीम आप्पुड देखील मीम मीरक इळा आज्ञा शेशीन्द उंड्या की, यवारक फणी शेशेद इच्छा लेद तर वार तिनेद बी लेद. ");
INSERT INTO wbq_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","तरी मिरता कित्येक अव्यवस्थितपणागोन वागाशातोर उंडार वार यम वगा फणी न शेस्ता लुडबूड शेस्तार, इळा मीम इनटाम. ");
INSERT INTO wbq_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","इळा मंदीक मीम प्रभू येशु ख्रिस्ताद फेरगोन आज्ञा उत्तेजन ईस्ताम की, वार शांतगोन फणी शेशी स्वताद आन्नाम तिनेद. ");
INSERT INTO wbq_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","मीर तर तम्मूडलु इंगा शेल्यानलु, बागा शेशा दाणक खचाया कानडा. ");
INSERT INTO wbq_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","इदी पत्राला माद वचन जर यवार मानायार तर आ मंशीन ध्यानाम फेट इंका वान्क शिग वाटायला आणकेन वारद संगत फटाकण्डा; ");
INSERT INTO wbq_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","तरी वान शत्रू समजाया कानडा, तर वान्क तम्मूड समजाशी वान्द कानउघडणी शेय. ");
INSERT INTO wbq_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","शांतीद प्रभू वाड आंताकाळ ला आंता प्रकारे मीरक शांती इयाला. प्रभू मी आंदारसंगा उंडान. ");
INSERT INTO wbq_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","नीन, पौलाड, स्वत गोण राशीन्द नमस्कार; इदी प्रत्येक पत्राला खून उंडाद. नीन इळा रितीगोन रास्तान. ");
INSERT INTO wbq_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","मनाद प्रभू येशु ख्रिस्त वान्द कृपा मीर आंदार संगा उंडान.");
INSERT INTO wbq_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","परमेश्वर मनालनी ताराशेतोड इंगा ख्रिस्त येशुड मना आशा इर आज्ञाता ख्रिस्त येशु न प्रेषित पौल तीकनुस: ");
INSERT INTO wbq_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","विश्वासला ना खरेम कोडकु तीमथ्य मना परमेश्वर आब्बाड इंगा ख्रिस्त येशुड मना प्रभू इन तीकनुस निक कृपा, दया इंगा शांती उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","मासेदोनिया प्रांतकी फोयेतापुड यला नीन निक कळकळीद विनंती शेशीन्टीन आल्ले इप्पुड पण शेस्तान की, नु इफिसला नील्वाला, दिन इचांग नु संगेम जनकी निक्षून शपाला की, वार इंगोगो शिक्षण शिका मतारोद. ");
INSERT INTO wbq_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","इंगा या परमेश्वर व्यवस्था विश्वास लेका उंडाद दान उपयोगी न फडेळदी पण वाड पण उत्पन्न शेशेळ कथाल तीकुड इंगा संगेम वंशावळ तीकुळ लक्ष इया कुंडा. आद्दे नीन इपूळ पण शप्तान. ");
INSERT INTO wbq_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","इंगा इ आज्ञा द उदिष्ट प्रेम उंडाद, याद शुद्ध अंतकरण लोन्केल, शिंगार विवेक भाव लोन्केल इंगा निष्कपट विश्वासलोंदी उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","इ माटलू इळशी यंता जन व्यर्थ माटला तीकुड वळा शिंडार. ");
INSERT INTO wbq_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","वारकी नियम शास्त्र शिक्षक आयेळदी उंड्या पण वार या माटा विषयला फेदा आत्मविश्वासता माटलाळतार इंगा शप्तार आय्यी वारके तेलवाव. ");
INSERT INTO wbq_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","पण माक इदी यरका उंडाद की, यवारू नियम शास्त्रद खरेमे यथार्थ उपयोग शेस्ते आदी शिंगार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","इंगा मनाक इदी यरकाने उंडाद की, नियमशास्त्र इदी नीतिमान मंदी इचांग शेशिनेद लेद तर आज्ञाभंग शेशेटोर इंगा विद्रोही, पापी, भक्ती लेनोर, अधर्मी, अशुद्ध, आबागारणी मतेशेतोर इंगा आमान मतेटोर, मनुष्यघात शेशेटोर ");
INSERT INTO wbq_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","जारकर्मी, समलैंगिक, मनुष्यलाद व्यापार शेशेतोर, खोटाडेर, खोटा वटू तीस्कोनेटोर वार इचांग उंडाद इंगा शुद्ध शिकवण उलटा जर येमाना दुसराद उंटे तर दान इचांग पण उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","गौरवदी सुवार्ता याद धन्यवाद परमेश्वर तीकेल वस्ताद इंगा याद ना मिंदा सोपवाशी इचीणाळ, दांकी इदी अनुसरून उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","यवाळ नाक शक्ती इच्चीनाड आ ख्रिस्त येशु मना प्रभुंदी नीन उपकार मानास्तान येनटीक की वाळ नाक विश्वासी मानाशी सेवाला फेटीनाळ. ");
INSERT INTO wbq_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","जर नीन पहिले परमेश्वर निंदा शेशेतोळ, छळाशेतोळ इंगा हिंसक उंटीन पण नीन आदी अनजानता इंगा अविश्वासता शेस्तीन दांचांग ना मिंदा दया आय्या. ");
INSERT INTO wbq_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","पण विश्वास इंगा प्रेम याद ख्रिस्त येशुला शिक्ताद आदी मना प्रभू कृपाता ओसाडीची वाहाशीर. ");
INSERT INTO wbq_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","इदी माटा विश्वासदी इंगा पूर्ण अंगीकार शेशेळ योग्य उंडाद की, ख्रिस्त येशु पापी मंदीन तारादेंक दुन्यामला वच्या इंगा आ पापी मंदी पैकी नीन फेदा पापी उंडान. ");
INSERT INTO wbq_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","पण फक्त इदे हेतुगोन ना मिंदा दया सुपिचीर की नालेका संगेम पापील मिंदा ख्रिस्त येशु ळ पूर्ण सहन शीलता सुपिच्या आ उदाहरण मिन्दकेल, मुंदार काळळा यवार वान मिंदा विश्वास फेट्यार वारकी सर्वकाळद जीवन शिकाला. ");
INSERT INTO wbq_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","इपूळ आन्नी काळटोळ राजा यवार अविनाशी इंगा अदृश्य उंडाद इल्ला ओकाते परमेश्वरकी सन्मान इंगा गौरव हमेशा काळ इचांग उंडाळा. आमेन. ");
INSERT INTO wbq_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","तीमथ्य, ना कोडकु लेका उंडाव, नीन निक नि विषयला पाहिलाने शपीने संदेशलेका इदी आज्ञा सोपास्तुनान. दिनकस्रोम की नु आटलाता शिंगार लढाई शेयाला. ");
INSERT INTO wbq_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","इंगा विश्वास इंगा शिंगार विवेक भाव फट. यंता जन इदी झुगारून इच्चीन्या इचांग वारी विश्वास रूपता जहाज मुंग्या. ");
INSERT INTO wbq_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","दांटला हुमनाय इंगा आलेक्स्रांद्र उंडार वारनी नीन शैतान की इचेस्तीन दिनकस्रोम की, निंदा शैयारोद आंका शिकायला. ");
INSERT INTO wbq_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","यीपुड आंदार कना पहिला इदी बोध शेस्तान की, आळगुकाम, प्रार्थना, विनंतील इंगा उपकार सुपिचकाम आन्नी मंदी इचांग शेयाला. ");
INSERT INTO wbq_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","इंगा विशेषता राजाल इचांग इंगा यवार फेदा अधिकारी उंडार आ आंदार इचांग प्रार्थना शेयना, दिनकस्रोम की मनाम पूर्ण सुभक्ती इंगा गंभीरपणता शांतीद इंगा स्थिरपणता इल्ला जीवन जगायाला. ");
INSERT INTO wbq_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","येनटीक की मना ताराशेटोळ द्यावार नजरता शिंगार इंगा स्वीकार शेशेदेंक शिंगार उंडाद, ");
INSERT INTO wbq_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","वांदी इच्छा उंडाद की आंता मंदिद तारण काला इंगा वार खरेम पणदी पूर्ण ज्ञानता पोहोचा मताला. ");
INSERT INTO wbq_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","येनटीक की ओकोळे परमेश्वर उंडाळ इंगा परमेश्वर इंगा मनसलू इर नडमा ख्रिस्त येशु इड मनुष्य ओकाडे नडमीलोनटोळ उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","वाळ आंदार किंमती इचांग स्वतान इच्चीनाड. इ विषयदी साक्षी शिंगार वेळी इचे उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","इंगा इ साक्षीद प्रसार शेशेदेंक नाक घोषणा शेशेतोळ इंगा प्रेषित नीन खरेम शप्तान; खोटा शपान, इल्ला इंगोगो इंगोगाराष्टीय मंदीला विश्वास इंगा सत्यटोळ गुरु आंका नेमाशिणेळ उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","दांचांग नाद इल्ला इच्छा उंडाद की आन्नी जागाला मागोरल शिट्ट इंगा जगडाम इडशी पवित्र शेई येती शेशी प्रार्थना शेयाला. ");
INSERT INTO wbq_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","दान लेकाने, नाद इल्ला इच्छा उंडाद की, आंडेर स्वतान यंडकाल गुपास्काम, बंगार किंवा मोती किंवा महाग बटाल इर लेद तर सभ्य वेशता विनयाता इंगा मर्यादाता सुशोभीत शेयाला. ");
INSERT INTO wbq_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","आले परमेश्वर इचांग समर्पित जीवन जगाशेतोर आंडेरकी यला शोभास्ताद, आले स्वताय शिंगार फनीलातोंन शोभाशी शेयाला. ");
INSERT INTO wbq_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","आंडीद शांत पनता इंगा पूर्ण अधिनताला शिकायला. ");
INSERT INTO wbq_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","नीन आंडेरकी शिकामतेळदी परवानगी इयाड लेकुंटे मणसला मिंदा अधिकार गाजामतीदेंक परवानगी इयान. दान शिवाय आदी शांत उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","येनटीक की पहिला आदामनी निर्माण शेशेदेंक वच्या येंगसार हव्वा. ");
INSERT INTO wbq_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","इंगा आदाम न फसाया मतालेद तर आंडीद फसायामत्या इंगाआदी पापला फड्या. ");
INSERT INTO wbq_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","तरी पण बीळलाक जन्म इचेळ वेळला दांदी रक्षण आय्यी, आदी मर्यादाला विश्वास, प्रेम इंगा पवित्रपण ला उंटे इदी आय्यी. ");
INSERT INTO wbq_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","इदी वचन विश्वास योग्य उंडाद जर यवाराना अध्यक्ष आंदार इचांग काळजी तीस्कोनेटोर आयेळदी इच्छा फेटताळ तर वाळ शिंगार फनीद इच्छा फेटताळ. ");
INSERT INTO wbq_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","तर अध्यक्ष इड एमी गुन्हा शेयालेळ, वगा वळती मोगुळ, शांत, मर्यादाला, आदर इचावाड, पाहूनचार शेशेतोळ, शिकामतुदेंक निपुण उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","वाळ सराय तागेतोळ किंवा मतेतोळ (किंवा घाणरडेळ फायदाद आवड फेतेतोळ) बेकाल्या तर वाळ सौम्य, जगडाम न आळेटोर, दुडलाद लालच न फेटारोद बेक. ");
INSERT INTO wbq_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","मना स्वता इल्लु मिंदा शिंगार प्रकारदी अधिकार नळपिचेटोर, पूर्ण गंभीर पणता स्वता बीळलाक हर माटा एकशेटोळ इल्ला वाळ उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","जर ओकोनकी स्वता परिवार दी देखभाल शेशेदेंक दा कुंटे तर वाळ परमेश्वर मंडळीद काळजी यला तीस्कोनी? ");
INSERT INTO wbq_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","वाळ इ फनीला कोता नेड शावाड बेका लेद आंटे वाळ गर्वला फुगाशी शैतान दंडला फडा काला. ");
INSERT INTO wbq_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","वांदी मंडळी बेटीटोळ मंदीला शिंगार फेर उंडाला. दिनकस्रोम की वान मिंदा टीका का रोद इंगा वाळ शैतान जाळीला फडाकाला. ");
INSERT INTO wbq_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","दान लेकाने सेवकलाक पण गंभीर का बेक, वाळ रोंड नोरवालेर किंवा सराय तागेटोर बेकालेर इंगा वाईट पणता दुडलु कमाशी श्रीमंत आयेळदी वारकी इच्छा बेका लेद. ");
INSERT INTO wbq_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","परमेश्वर जो माक प्रकट शेशिनाळ आदी मा विश्वासदी संगेम लोत सत्य वार शुद्ध विवेकता फटीगात फेटाला. ");
INSERT INTO wbq_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","आब्बागार लेका इरदी पण पहिला परीक्षा काला, मग निर्दोष ठहरास्ते, वाळ सेवक पण शेयाला. ");
INSERT INTO wbq_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","दान लेकाने, आंडेर पण गंभीर उंडाळा, वार चुगली शेशेतोळ नीलारोद. तर सभ्य इंगा प्रत्येक बाबतीला विश्वासटोर उंडाळा. ");
INSERT INTO wbq_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","प्रत्येक सेवक वगा वळती मोगुळ उंडाला इंगा वार-वार बीळलाद इंगा परिवारदी शिंगार प्रकारता काळजी तीस्कोनाला. ");
INSERT INTO wbq_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","येनटीक की यवार सेवक पण शिंगार शेशीर, वार मनाक शिंगार पदवी इंगा ख्रिस्त येशुन मिन्दुळदी विश्वासला संगेम धेर्य तीस्कोनतार. ");
INSERT INTO wbq_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","नीन नीतीकुड लगाने वचेळदी आशा फेटतीन तरी नीन निक इ माटलू राशिंद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","तरी नाक वेळ आंटते, परमेश्वरदी इल्लु आंटे जिवंत परमेश्वरदी मंडळी याद सत्यद खांब किंवा पाया उंडाद, आ परमेश्वर इलकाडा नीनु यला वागाया बेक, इदी निक समजाला. ");
INSERT INTO wbq_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","सुभक्तीद रहस्य निर्विवाद फेदाद उंडाळ वाळ शरीरला प्रकट आय्या, आत्माता वाड नीतिमान ठहाराश्या, वाळ परमेश्वर दूत नजरला फड्या, राष्ट्रला गाजामतीणार, दुन्यामला वान मिंदा विश्वास फेटीर, वान गौरवला मिन्दिक तीस्कोनीर. ");
INSERT INTO wbq_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","परमेश्वरदी आत्मा स्पष्ट आंटाद की, अंत काळला रवा मंदी विश्वास ईळश्यार, वार भविष्य शपेतोर आत्माल, याय फसामतेटी उंडाय वार तीकुड लक्ष इच्यार, ");
INSERT INTO wbq_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","या मनुष्यद सद्सदविवेक बुद्धी तर डाग काम्पीचीन्या लेकाने उंडाद इंगा दयाम देगारकेल वचेटी शिक्षणला तीकुड इंगा ढोंगी फसामतेतोर तीकुड ध्यानाम इच्यार. ");
INSERT INTO wbq_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","वार मंदीक फेनली शेस्कोनदेंक लेद आन्यार इंगा याद अन्न विश्वास फेटेतोर खरेम पण जानाशेटोर उपकारस्तुती शेशी स्वीकाराला दांचांग परमेश्वर अस्तित्वला येकोच्या आदी मानायारोद इल्ला शेप्यार. ");
INSERT INTO wbq_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","तर परमेश्वर बनाशीद उंडाद एकोचीनेद प्रत्येक वस्तू शिंगार उंडाद इंगा उपकार स्तुती शेशी तीस्कोन्टे एमीपण नाकाराशेळदी लेदउत्पती. ");
INSERT INTO wbq_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","येनटीक की प्रत्येक वेळी आदी परमेश्वर शब्दता इंगा प्रार्थनाता पवित्र शेशतार. ");
INSERT INTO wbq_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","जर नु इ माटलु ख्रिस्ती तमुळलाक शिकामतुतीम, तर नून जो सत्यला इंगा विश्वासला वाढास्तीर इंगा शिंगार शिक्षणला लेका शेस्ते नु ख्रिस्त येशुन शिंगार सेवक आयाव. ");
INSERT INTO wbq_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","पण मुसली आंडेरदी आवडता अमंगलपणी कथालदी स्वीकार शेयाक, नु स्वतान परमेश्वर सुभक्ती विषयला तैयार शेय. ");
INSERT INTO wbq_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","येनटीक की शरीर फनीलाक कडमा महत्व उंडाद पन परमेश्वर सेवा इचांग आन्नी प्रकारता महत्त्व उंडाद येनटीक की आदी सध्या जीवन विषयला इंगा भविष्यलोंन जीवन विषयला आशीर्वाद दी अभिवचन उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","इदी वचन विश्वास फेटेळ लेका उंडाद याद यपुडपण स्वीकार शेशेदेंक शिंगार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","दिनइचांग मिम मेहनत इंगा खटपट शेस्ताळ यवार आंदार मंदीटोळ इंगा विशेष आणते विश्वास फेटेतोरनी ताराशेतोळ, आ जिवंत परमेश्वर मिंदा मिम आशा फेटीनाम. ");
INSERT INTO wbq_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","इ माटलु आज्ञारुपता शप इंगा शिका मत. ");
INSERT INTO wbq_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","यवार पण नीद जवानीपण खराब मानारोद, तर माटलाळताना, वर्तणूकिला, प्रेमला, (आत्माला) विश्वासला, शुद्धपणला, विश्वास फेटेतोरदी आदर्श उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","नीन वचीन दांका वाचास्काम, बोध शेस्काम इंगा शिकामतकाम, इटला तीकुड ध्यानाम इचका उंडू. ");
INSERT INTO wbq_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","निमिंदा आब्बागार वर्ग शेई फेटेळ वेळ ला संदेश तीकेल इचीनेय इल्ला याद कृपाद दान निनोना उंडाद, दान तीकुड दुर्लक्ष शेयाक. ");
INSERT INTO wbq_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","इ आन्नी माटळा तीकुड पूर्ण लक्ष इ, दांतल्या पूर्ण गळास फो. दिनकस्रोम की नीद प्रगती आन्नी मंदीला काम्पियाला. ");
INSERT INTO wbq_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","मना तीकुड इंगा मना शिक्षण तीकुड लक्ष इ. दांटल्या टीकाशी उंड येनटीक की इल्ला शेस्ते नु स्वताद इंगा यवार नीद यीनटार, वारदी चूकिद शिक्षण तीकुड नुस वाचा मतयाव. ");
INSERT INTO wbq_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","आब्बागार वयातोड मंशीन कठोरपणता माटलाळाक, उलट आबानलेका वांकी शप. ");
INSERT INTO wbq_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","जवानोरणी तमुळला लेका, मुसली आंडेरनी आमागारलेका, जवान आंडेरनि शेल्यांलालेका पूर्ण शुद्ध भावा गोंन वागायमत. ");
INSERT INTO wbq_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","याय विधवा खरेखरेमी गरजवंत उंडाय आटलाद सन्मान शेय. ");
INSERT INTO wbq_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","पण जर ओकाट आळदम विधवा दांकी बीळलु किंवा मनमाळलु उंटे तर वार पहिला ईलकातोर संगा धार्मिकता गोन वागादेंक इंगा मना आबागारदी उपकार फेडाशादानक शिकावा याला येनटीक की इदी द्यावार नजरला शिंगार उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","तर याद खरेखरेम विधवा उंडाद इंगा दांदी काळजी तीस्कोनदेंक यवार लेर आदी परमेश्वर मिंदा स्वताद आशा फेटीनाद इंगा आदी मबूफगुल परमेश्वर तीकुड प्रार्थना इंगा विनंती शेस्का नीलस्ताद. ");
INSERT INTO wbq_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","पण याद विधवा चैनता नीलस्ताद, आदी जिवंत उंडी सचीनेद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","वार निर्दोष काला दांचांग इ माटलू आज्ञा रुपता विश्वासोरकी शप ");
INSERT INTO wbq_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","पण जर यवाराना वान स्वता देगाटोर इचांग इंगा विशेष वान परिवारलोन देगातोर इचांग योजना शेयार, तर वाळ विश्वास नाकाराशिनाळ इंगा वाळ अविश्वासी मणशी पेक्षा खराब उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","याद विधवा साठ वर्ष नोना उंडी वगा मोगुन वळती आय्यी निन्टे. ");
INSERT INTO wbq_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","याद शिंगार फनील इचांग गाजाशिनेद उंटे म्हणजे यवार बीळलान वाढामतीर, यवार अनोळखी मंदिद स्वागत शेशीर, पवित्र मंदीद स्वागत शेशीन्याला, पवित्र मांदिय काळलु कळगीन्याला, त्रासला उंडीनेरदी मदत शेशीर इंगा आन्नी शिंगार फनील शेशेदेंक स्वतान वाहाशी तीस्कोनिन्टे, इल्ला विधवालदी यादीला समावेश शेयाल्या. ");
INSERT INTO wbq_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","पण जवान विधावालदी यादीला नोंद शेशेळदी टाळायला यलकी यपुड वार ख्रिस्तन इडशी शारीरिक विचार (वासना) आवतार, आप्पुड वारकी इंगा फेनली सेस्कोना बुदिक आवताद. ");
INSERT INTO wbq_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","इंगा आय्यी दोशील फटा मत्यार, येनटीक की वार वारदी पहिला विश्वास एडशीर. ");
INSERT INTO wbq_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","इंगा आय्यी इलूइलूक तीरगी आळशी बनास्तार इंगा इंताने लेद तर वटवटील इंगा लुडबुड्याळ आयीगात याय माटलु माटलाळा बेकाल्या, आयी माटलु माटलाळताय. ");
INSERT INTO wbq_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","दिनकस्रोम नाद इल्ला इच्छा उंडाद की, जवान विधवा आंडेर फेनली शेस्कोनाला. बीळलाद संगोपन शेयाला इंगा स्वताद इल्लु नळपियाला. स्वता विरोधीन मनादनिंदा शेशेदेंक मोका इया रोद. ");
INSERT INTO wbq_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","यळा कि नीन तर इल्ला आणतान की काही विधवाल शैतान यांकाक फोयेदेंक तीरगीनाय पण. ");
INSERT INTO wbq_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","जर यवाराना इलकाडा विधवा उंटे तर वार दांदी काळजी तीस्कनाला इंगा मंडळी मिंदा वजन येया रोद. दिनकस्रोम की याय विधवाल खरेमे गरजवंत उंडाय वारकी वार मदत शेशु शकास्तार. ");
INSERT INTO wbq_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","यवार उपदेश शेशेळदी इंगा शिका मतेळी फनील शेस्तार वारकी इंगा आब्बागार मंडळीद सेवा शिंगार सेवा सेस्तार वारकी दोन पट मान इचेदी विशेष योग्य समजायानडा. ");
INSERT INTO wbq_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","येनटीक की शास्त्र लेखला राशिंद उन्डाद, “धान्यलाद मळणी शेस्ताना यदुक मुस्काल कटाक” इंगा “मजूरदी वान मजुरी मिंदा हक्क उंडाद.” ");
INSERT INTO wbq_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","इद्दार किंवा मोगुर साक्षीदारलू पाठीम्बा इचीने शिवाय आब्बानमिंदा आरोप दाखल शेयाक. ");
INSERT INTO wbq_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","यवार पाप शेस्का उंटार वारदी जाहीर पणता विरोध शेय. दिनकस्रोम की, इंगोगोर्की बिता वाटाल्या. ");
INSERT INTO wbq_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","परमेश्वर, येशु ख्रिस्त इंगा निवडाशिनेर परमेश्वर दूतलु इरमुंदार नीन निक्षून आज्ञा शप्तान की, नु यदुपण पहिलाग्रह न फेटी इ माटलू पाळाय इंगा पक्षपातता एमीपण शेयाक. ");
INSERT INTO wbq_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","घाइता यवार मिंदा शेई फेटाक इंगा इंगोगोर पापला हिसेदार काक. हमेशा स्वतान शुद्ध फेट. ");
INSERT INTO wbq_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","दिन मुंदार न्यळे तागका नीलाक, तर स्वता कळपु इचांग, म्हणजे स्वता इंगा -इंगा आयेळी बिमारीला इचांग, रवासा अंगूरदी रस तीस्को फो. ");
INSERT INTO wbq_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","यंनता मनुष्यय पापलु उघडाशी उंडीगास पहिला न्यायनिवाडी इचांग फोतार इंगा यंता जन यंकाक फोतार. ");
INSERT INTO wbq_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","दानलेकाने, शिंगार फनी स्पष्ट उंडाय आय्यी सुद्धा हमेशा इचांग दाशी फेटाक दाद. ");
INSERT INTO wbq_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","यवार आंदार दास आंका जुवाकिंदा उंडार आंता जन स्वत-स्वता आन्नी सन्मान लेका मानायला दिनकस्रोम की परमेश्वरदी फेर इंगा शिकवण दिंदी निंदा का रोद. ");
INSERT INTO wbq_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","इंगा यवार मालक विश्वास फेटेतोर उंडार वारकी वार बंधू उंडार आंका वारदी अपमान शेया रोद तर इंगा आदरता दास्य शेयाला येनटीक की यवार्की सेवाद फायदा आताद वार विश्वास फेटेतोर इंगा प्रिय उंडार इ माटलु शिका मती बोध शेय. ");
INSERT INTO wbq_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","जर यवाराना काही इंगोगो शिका मतुताळ इंगा ख्रिस्त येशु स्वता प्रभू इंनि याय सुवचनलु इंगा परमेश्वर द सेवाद शुद्ध शिक्षण मानायार ");
INSERT INTO wbq_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","तर वाळ गर्वता फुगाशीनेळ उंडाळ इंगा वांकी एमी तेलाद. दान शिवाय वाळ जगडाम इंगा शब्दकलह इटलाटा तीकावाड आईनाळ. इ माटलाकेल हेवा, जगडाम, निंदा, दृष्ट तर्क पण आताद. ");
INSERT INTO wbq_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","मन बीघडाशीनेय इंगा खरेम पण विरहीत आयनेद भक्ती इदी कमाईद साधन उंडाद इल्ला कल्पना शेशेतोळ मनुष्यद हमेशा जगदाम आताय, वार देगारकेल दुराम उंडा. ");
INSERT INTO wbq_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","वास्तविक सुस्ते संतोषता परमेश्वर सेवा शेस्ताना शिकेटी समाधान इदी फार फेदाद फायदा उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","येनटीक की मनाम दुन्यामला एमी एका दाल्या इंगा मना इचांग इ दुन्यामला एमपण बेटीक एका फोवा दाद. ");
INSERT INTO wbq_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","जर मनाक आन्नाम, वस्त्र उंटे आंता दांटलाने संतुष्ट उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","पण यवार श्रीमंत आदेंक वार परीक्षाला इंगा सापळ्याला इंगा संगेम मुर्खपणदी इंगा हानीकारक इच्छा इचांग फोई नाश आतार. ");
INSERT INTO wbq_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","येनटीक की दुडलाद प्रेम इदी आन्नी वाईटलाड दुडलु उंडाय. काही मंदी वांदी हाय फटीनेन्का विश्वास तीकेल दुराम फोईणार दानइचांग वार स्वताने संगेम दुख शेस्कोंडार. ");
INSERT INTO wbq_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","ये परमेश्वर मणशी, नु इ माटळा नुस दुराम नील. न्यायी पण, सुभक्ती, विश्वास इंगा प्रेम, सहनशीलता इंगा लीनता इर यंकाक आंट. ");
INSERT INTO wbq_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","विश्वास संबंधला शिंगार युद्ध शेय, येमटी इचांग नीनु कुतेशिन्या. आ आनिकाळूद जीवननि फेटीगात फट. नु संगेम साक्षीदारला संगा शिंगार साक्ष इस्ती, ");
INSERT INTO wbq_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","यवार आंदारकी जीवन इस्ताळ आ परमेश्वर मुंदार इंगा पंतय पिलात मुंदार यवार शिंगार साक्ष इच्या आ ख्रिस्त येशुन मुंदार नीन निक आज्ञा इस्तान. ");
INSERT INTO wbq_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","मना प्रभू येशु ख्रिस्त प्रकट आय्यी पर्यंत बिना कलंक इंगा निर्दोष उंडाला दांचांग इदी आज्ञा पाळायंडा. ");
INSERT INTO wbq_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","यवार धन्यवादित, ओकाते सार्वभौम, राजाल राजा इंगा प्रभून प्रभू, ");
INSERT INTO wbq_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","यवान ओकोन की अमरत्व उंडाद, यवाळ अगम्य प्रकाशला निलस्तामयावारणी या मनुष्य सुळाल्या इंगा यवार्कीबी सुस्काम काद, वाळ आदी वांदी प्रकट आकाम यथा काळला सुपीची, वांकी सन्मान इंगा आन्नी काळदी सामर्थ्य उंडाद. आमेन. ");
INSERT INTO wbq_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","इ युगलोन श्रीमंतोर की आज्ञा शेय की, गर्विष्ठ का कुंडा. दुडलु जो चंचल उंडाद दान मिंदा वार आशा फेटा रोद, पण परमेश्वर जो विपुलता उपयोग इचांग आंता पुरामतुताळ वान मिंदा आशा फेटाला. ");
INSERT INTO wbq_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","शिंगार आदी शेयाला, शिंगार फनीला श्रीमंत उंलाला, उदार इंगा इंगोगोर मिंदा उपकार शेशेतोळ उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","याद खरेम जीवन आदी मजबूत पतीदेंक मुंदार काळला शिंगार आधार आय्यी इल्ला साठा स्वता इचांग शेयाला. ");
INSERT INTO wbq_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","तीमथ्य, नि देगारा विश्वासता सांभाळादेंक इचीने ठेवीद रक्षण शेय. अधर्मद खाली वटवटीकेल इंगा चुकीता यवार्की कथा कथित “विद्या” आंटार वान संगा संबंधला उंडीनेद परस्पर उलटा मतलाकेल दुराम फो. ");
INSERT INTO wbq_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","आदी विद्या स्वीकार शेशी येंतक विश्वास नुस बहकाशी फोईणार परमेश्वरदी कृपा मी संगा उंडाला.");
INSERT INTO wbq_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","ख्रिस्त येशुन दीनटल्या उनिनेद जीवन विषयद अभिवचनदी घोषणा शेदेंग, परमेश्वर इच्छाता ख्रिस्त येशुनदी प्रेषित पौल इन्तीकुड नुस, ");
INSERT INTO wbq_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","प्रिय कोडकु तिमथ्य इनकी, परमेश्वर आबा इंगा ख्रिस्त येशुड मा प्रभूळ इन देगार नुस कृपा, दया इंगा शांती उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ना पूर्वजलेका या परमेश्वरदी नीन शुध्द विवेकभावता सेवा शेस्तान, आ परमेश्वरदी नीन उपकार मानास्तान इंगा मोबू फगुल ना प्रार्थनाला नीद नेहमी आठवन शेस्तान. ");
INSERT INTO wbq_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","निद येडस्काम ध्यानाम शेशी नीनु भेटाशेद शेंगेम इच्छा उंडाद दिनकस्रोम कि नीन आंनदता पूर्ण काला. ");
INSERT INTO wbq_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","नि दिंटलोनदि निष्कपट विश्वासदि नाक येरका उंड्या जे पहिलानदा नि मुचामा लोईस दिनटल्या उंड्या इंगा नि आम्मा युनिकेद दिनटल्या उंड्या इंगा ना खात्री उंडाद कि आद्दे विश्वास नि दीनटल्या पण उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","दीनचांग नीन निक आठवन शेशीस्तान कि, परमेश्वर जे कृपादान ना शेइ निमिंदा फेटीन मुड आंका नि ठायी उंडाद, आदी प्रज्वलीत शेय. ");
INSERT INTO wbq_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","येनटीक की परमेश्वर माक येरस्कुनेद आत्मा इयाल्या तर सामर्थ्यद, प्रेमदी इंगा धम फटेद आत्मा इच्ची नाड. ");
INSERT INTO wbq_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","दानचांग मना प्रभून विषयला साक्ष इदेंग शिगु फटाक नाई तर नीन येवाड वानइचांग कैदी आतीन आदी नाद शिगु फट्टाक. तर सुसमाचार इचांग परमेश्वरदी सामर्थ्य लेका नु नाबरोबर दु:खद फाल तीस्को. ");
INSERT INTO wbq_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","वाळ मोमलान ताराश्या इंगा पवित्र पाचारन शेषा. मिम काही शिंगार फनील शेस्तीम आंका लेद तर वान स्वता इच्छाता इंगा कृपाता शेषा. इदी कृपा युगदी सुरुवात केले परमेश्वर ख्रिस्त येशुन दीनटल्या माक इच्चीन्या. ");
INSERT INTO wbq_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","पण याद इपूळ मंमलान मा तारण शेषेटोळ ख्रिस्त येशुनदी प्रकट आयेळदी सुपिदेंग ओचीनाद. ख्रिस्ताड सचकाम्दी नाश शेषा इंगा सुसमाचार द्वारे अविनाशीपण इंगा जीवन एलगुला येकाच्या. ");
INSERT INTO wbq_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","नाक आदी सुसमाचार दि घोषनाचंग, प्रेषित इंगा शिक्षक इल्ला नेमाशी नीर. ");
INSERT INTO wbq_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","इंगा इदी कारण चांग नीनसुध्दा दु:ख भोगास्तुनान. पण निन शिगु फडान येनटीक की येवार मिंदा नीन विश्वास फेटी नान वान नीन ओळखास्तान इंगा नाद खात्री उंडाद कि, आदी दिवस ओचीनतक वाड जे नाक सोपाशी नाळ दांदि वाड रक्षण शेशी. ");
INSERT INTO wbq_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","याद सुवचनदी नमुना नु ना तीकुड नुस आयकाशी तीस्कूनटी, आदी नमुना ख्रिस्त येशूनलोन दि विश्वास इंगा प्रेम दीनटल्या मजबूत फट. ");
INSERT INTO wbq_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","मनादीनटल्या नीलचे पवित्र आत्माद्वारे आ शिंगार फेटने माटलाद रक्षण शेय. ");
INSERT INTO wbq_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","आशिया प्रांतला उंडेटोर आंदार नन्नु इडशी नार इदी निक येरका उंडाद. दानटल्या फुगल इंगा हर्मगणेस उंडार. ");
INSERT INTO wbq_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","अनेसीफर इल्लु मिंदा प्रभुड दया सुपीयाला येनटीक की वाड संग्याम तुकुल नाद समाधान शेशीनाड इंगा नाद तुरुंगला निल्चेद वांकी शिगु वाटायल्या. ");
INSERT INTO wbq_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","उलटा रोम शहरला उंडेतापुड वाळ नाद तपास आंटी नंताक पूर्ण जोर आन्ची नाद शोध शेशा. ");
INSERT INTO wbq_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","प्रभूळ शेयाला इंगा आद्दे दिवस नाळ प्रभूनतीकुळ नुस दया शिक्काला येनटीक कि नाद इफीसला येनि तरी प्रकारता नाद सेवा शेश्या इदी निक शिंगार येरका उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","ना कोडका नु ख्रिस्त येशुन ठायी उंडीने कृपाला बलवान का. ");
INSERT INTO wbq_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","नातीकुळ नुस याय माटलु नु सनगेम साक्षीदारला मुंदार इन्ती आय्यी तीस्को इंगा इंगोगर की नेरपेदेंग समर्थ इल्ला विश्वासु मंदीक सोपास काळ. ");
INSERT INTO wbq_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","ख्रिस्त येशुन मनची सैनिक इ नातागोन ना बरोबर दु:ख सोसाय. ");
INSERT INTO wbq_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","सैनिकी फनिल शेषेटोळ येवार पण जीवनलोंदी जगलोनी फनिल फटाला दीनटल्या अटकायाड. दिनकस्रोम कि वान्की वान फेदा अधिकारीन कि संतुष्ट शेय्या दावाला. ");
INSERT INTO wbq_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","जर येवार पण मल्ल युध्द शेस्ताळ, तर आदी नियम अनुसार शेशीन शिवाय वांकी मुकुट शिकाद. ");
INSERT INTO wbq_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","कष्ट शेषेटोळ शेतकरी मंदी पहिलाणे पीकदी हिसा तीस्कुनेद योग्य उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","जे नीन माटलाळतान आदी समझाशी तीस्को, येनटीक कि प्रभू ळ निक इ आणि माटलाद समज इच्ची. ");
INSERT INTO wbq_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","ना सुसमाचार लेखा जो सची फोईणे नुस लेपिणाळ दाविदान पिढीटोळ येशु ख्रिस्तळ, इनदी ध्यानाम शेय. ");
INSERT INTO wbq_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","येनटीक की आ सुसमाचार इचांग दु:ख सहन शेस्का उंडान, इडदाणका कि गुन्हेगारलेखा साखडीलता नाक कटदेंग ओच्या, पण परमेश्वरदी वचन कटदेंग दाल्या. ");
INSERT INTO wbq_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","दिनकस्रोम परमेश्वरदी निवडाशिनेरचांग नीन आंता काही आराम शिरता सहन शेषका उंडान, आंटे वारकी पण ख्रिस्त येशूनद्वारे शिक्येद तारण इंगा अनंत काळदी गौरव प्राप्त कावाला. ");
INSERT INTO wbq_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","इदी वचन विश्वासदी उंडाद कि, जर मिम वान संगा सची फोतिम, तर वानबरोबर जिवंत पण उंड्याम ");
INSERT INTO wbq_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","जर मिम दु:ख सहन शेस्तिम तर मिम वानबरोबर राज्यसुध्दा शेशाम जर मिम वांकी नाकारास्तिम, तर वाळसुध्दा माद नकार शेशी ");
INSERT INTO wbq_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","जर मिम अविश्वासी उंडाम तरी वाड इपूड पण विश्वासू उंडाड येनटीक की वाड वान्दी नाकार शेशी शकायाळ. ");
INSERT INTO wbq_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","मंदीक इ माटलाद द्यानाम इच्का उंड. प्रभु मुंदरा वार्की समजा मती शप की तीटलाडा कुंडा. इल्ला जगळाल यादुच फायदाय लेव. जे येवारकी पण फनिक फडान्दे एकाशोतोर नाश दि कारण आताद. ");
INSERT INTO wbq_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","नु सत्यद वचन योग्य रितीता शेपेतोड इल्ला इंगा याद फनी शेस्ताव दानटल्या शिगुवाटायदेंग येमीच कारण लेकून न्योड परमेश्वर की स्वीकृत इल्ला फनी शेशेतोड आय्येद प्रयत्न शे. ");
INSERT INTO wbq_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","पण अमंगळपन दि रिकामिद जगडाल आडेळदी इडु येनटीक की वाड मंदीन परमेश्वर देगार नुस सना आंटे सना दुराम येका फोताळ. ");
INSERT INTO wbq_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","इंगा दिन लेका जगडाल आडेतोर्दी शिकवन कर्करोगलेका पसरास्ताड. इ मंदीला हुमनाय इंगा फिलेत उंडाळ, ");
INSERT INTO wbq_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","वार सत्यदेगार नुस दुराम फोई नार. पुनरुत्थान आय्यी गास फोई नाद इल्ला वार आंटार इंगा येंतातरी मंदी विश्वासदी नाश शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","तरी परमेश्वर येशीणे जोता स्थिर उंडी उंडाद, वांदी इदी शिक्का उंडाद की, “प्रभूड जे वानटोर उंडार वार्नी ओळखास्ताड,” इंगा “येवार पण प्रभूनदी फेर तीस्कून टार वार वाईट मार्ग नुस दूराम उंडाला.” ");
INSERT INTO wbq_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","फेदा इंडलाला फक्त बंगारयेंडीय बतकुल उंटाय इल्ला लेद तर कटलु इंगा मनु दीनदेगर नुस बनामतीणेय पण उंटाय. काहीक सन्मान इचांग इंगा काहीक अनमाण इचांग नेमाशिनेय उंटाय. ");
INSERT INTO wbq_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","दानचांग जर येवार पण दान देगार नुस दुराम उंडी स्वतान शुद्ध शेशी, तर वाळ पवित्र शेशीणे, मालकूनकि फनिक फडदेंग, प्रत्येक शिंगार फनिक तयार शेशीने इल्ला मान दि बतकु आयार. ");
INSERT INTO wbq_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","पण जवानी वासनादेगार नुस दुराम उंड इंगा जे प्रभून कि शुध्द अंत:करनाता कुतेस्तार इंगा प्रभून मिंदा विश्वास फेटतार, इल्ला मंदी बरोबर, नितीमत्त्व, विश्वास, प्रेम इंगा शांती इटला येन्का आन्ट. ");
INSERT INTO wbq_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","पण मूर्खपणदि इंगा अज्ञानी जगळाल देगार नुस दुराम उंडा येनटीक की निक येरका उंडाद कि, दानचंग जगडाल निर्माण आताय. ");
INSERT INTO wbq_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","परमेश्वर सेवकलु जगडाल शेयारोद, तर आंता मंदी संगा सौम्यताने वागायला, आले शिक्षनला कुशल इंगा सहनशील उंडाला. ");
INSERT INTO wbq_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","येवार वांकी विरोध शेस्तार, वार्की शांत तों शिक्षण इयाला कदाचित वार खरेम ओळखायला दानचांग परमेश्वर वार्की पश्चाताप शेशेद बुद्धी इच्ची. ");
INSERT INTO wbq_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","इंगा शैतान मना इच्छा लेका फटी येका फोईणे वान फासालोन नुस इळीगात शुद्धीला ओच्यार. ");
INSERT INTO wbq_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","पण आकरी काळला संकटदी दिवस मना मिंदा ओची इदि समझाशी तीस्को. ");
INSERT INTO wbq_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","मंदी स्वार्थी, धनलोभी, बढाई शेशेतोर, गर्विष्ठ, निंदा शेशेतोर, आम्मा आबानदि आज्ञा न मानाशेतोर, उपकार न शेशेतोर, परमेश्वरनी न मानाशेतोर ");
INSERT INTO wbq_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","इंगोगार मिंदा प्रेम न शेशेतोर, क्षमा न शेशेतोर, चुगली शेशेतोर, येपूळ पण, कोफाम, शिंगारबद्दल प्रेम न शेशेतोर. ");
INSERT INTO wbq_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","विश्वासघातदी, उतावीळ, गर्वाता फुगाशीनेर, परमेश्वर मिंदा प्रेम शेषाकना पेक्षा सुखता जास्त आवड फेटेतोर इल्ला आयार; ");
INSERT INTO wbq_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","वार परमेश्वर सेवाद बेटूळदी स्वरूप शिंगार फेट्यार पण वांदी सामर्थ्य नाकाराश्यार. वार देगार नुस नेहमी दुराम उंडा. ");
INSERT INTO wbq_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","नीन इदी आंटान कारण वारपैकी काहीक इंगोगार इंटल्या लक्ष इस्तार इंगा पापता निंडीगास, आणि प्रकारता खराब माटलाता निंडीगास, कमजोर आंड्यर मिंदा ताबा तीस्कूनतार. ");
INSERT INTO wbq_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","इल्ला आंडेर नेहमी शिकाशेळदि प्रयत्न शेस्तार. पण सत्यद पूर्ण ज्ञान नंताक वार फोई शेकायार. ");
INSERT INTO wbq_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","यान्नेस इंगा यांब्रेस इर येला मोशन कि विरोध शेशीर आला, इ मंदी सत्यक विरोध शेस्तार. येवारदि मन भ्रष्ट उंडाय इंगा विश्वास दीनटल्या अयशस्वी ठराशेंद इल्ला मंदी उंडार. ");
INSERT INTO wbq_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","वार मुंदरा जास्त प्रगती शेयाक फोयार येनटीक कि येला वार्दी मूर्खपणा प्रकट आय्या आला वार्दी मूर्खपणा आंदार की प्रकट आय्यी. ");
INSERT INTO wbq_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","तरी पण नु नाद शिकवण, वागणूक, जीवनलोंदी नाद ध्येय, नाद विश्वास, नाद धीर, नाद प्रेम, नाद सहनशेस्कम, नाद आय्यी नेद छळ, ना मिंदा ओची ने संकटलु, इ ओळखाशी उंडाव, ");
INSERT INTO wbq_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","अंत्युखिया, इकुन्या इंगा लुस्र इ शहरलाला या माटलु नाबदल घडाश्या, याद भयंकर छळ नीन सोसास्तीन आय्यी नाद दु:ख निक येरका उंडाद, पण प्रभूळ इ आंता त्रासलोन्केल नन्नु इडपीच्या. ");
INSERT INTO wbq_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","खऱ्यामनी सुस्ता, येवार-येवार ख्रिस्त येशूनला शुध्द जीवन जगाशेद इच्छाशेस्तार, वार आंदार छळ आय्यी. ");
INSERT INTO wbq_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","पण दुष्ट मंदी इंगा पसामतेटोर मंदी इतरमंदीक मीनदुळमिंदा फसामत्काने उंड्यार इंगा स्वता पण फसाशी जास्त वाईट तीकुळ फोयार. ");
INSERT INTO wbq_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","पण निबदल, याय माटलु नु शिकास्ती इंगा येवारमिंदा नीद विश्वास उंडाद आय्यी नु आले फटी उंड. ");
INSERT INTO wbq_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","निक येरका उंडाद की, नु नि शिना आपुळ केले निक पवित्र शास्त्रद माहिती उंडाद. वार ख्रिस्त येशूनदीन लोन टोर विश्वासद्वारे निक हुशार बनामतेद इंगा तारण तीकुळ येका फोयेळ दि सामर्थ्य उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","प्रत्येक शास्त्रलेख परमेश्वर प्रेरणाता लीवाशीगास उंड्या आंका आदी शिकामदेंग, वाईटद निषेध शेदेंग, चुक सुधारशेदेंग इंगा योग्य जीवन जगाशेद दावासुपीचेद उपयुक्त उंडाद. ");
INSERT INTO wbq_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","दिनकस्रोम की, परमेश्वर मनशी तरबेज आय्यी पूर्ण पणे हर एक शिंगार फनिल चांग तयार कावाला. ");
INSERT INTO wbq_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","परमेश्वर मुंदार इंगा जो ख्रिस्त येशु जीवंत उंडीनोर्दी इंगा सचीनोरदी न्याय शेशी वानमुंदार वान्दी प्रकट आय्येद इंगा वान राज्यद ध्यानाम शेशी नि समजामती शेप्तान कि, ");
INSERT INTO wbq_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","वचनदि घोषणा शेय प्रत्येक वेळी आणि वेळ लेकुना बी पण तयार उंडा, आंता प्रकारदि सहनशीलताने इंगा शिक्षण ता दोष सुपी, निषेध शेय इंगा शिका मत. ");
INSERT INTO wbq_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","नीन इल्ला आंटान येनटीक की इल्ला टाईम ओची येपूळ मंदी शिंगार शिक्षण सहन शेयार. दानबदल वार स्वताद इच्छाल कि साली इल्ला शिक्षक वार वारीक जमा शेषार. ");
INSERT INTO wbq_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","सत्य देगार नूट वार मनाय गुम्माल दुसरा तीकुळ तीपप्यार इंगा मनाद लक्ष वार काल्पनिक कथाल तीकुळ आनशार. ");
INSERT INTO wbq_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","पण नु आनि परीस्थीतीला सावधान पणे वागाय, दु:ख सहन शेय; सुसमाचार दि घोषणा शेशेळ दि फनी शेय; परमेश्वर इच्ची नेद सेवा पूर्ण शेय. ");
INSERT INTO wbq_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","येनटीक की इपूळ नाद अर्पण आतु नाद इंगा नाद इदी जग्लोन नुट फोयेद वेळ ओची नाद. ");
INSERT INTO wbq_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","नीन स्वता युध्द शेशी नान. नीन नाद धाव संपामती नान. निन विश्वास राखाशी उंडान. ");
INSERT INTO wbq_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","इपुळ मुंदार नाइचंग जे नीतिमत्वद मुकुट फेटीगास उंडाद, आदी आ दिवस नाड नीतिमान न्यायाधीश प्रभूड नाक इच्ची इंगा फक्त नाके काद, तर वांदी प्रकट आय्येद येवार कि प्रिय उंडाद आ आंता मंदीक पण इच्ची. ");
INSERT INTO wbq_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","नादेगार लगन ओचेळ दि प्रयत्न शे. ");
INSERT INTO wbq_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","येनटीक की देमास नन्नु इडशी थेस्सलनीक शहरला फोई नाळू येनटीक की वान्की जगदी सुख प्रिय उंडाद. क्रेस्केस गलतिया प्रांताला फोई नाळू इंगा तीत दालमतीया प्रांताला फोई नाळू. ");
INSERT INTO wbq_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","लुक फक्त नादेगार उंडाळ, येपूळ नु ओच्याव आपुळ मार्कनी निबरोबर येता कारण सेवाकस्रोम वाळ नाक उपयोगी उंडाळ. ");
INSERT INTO wbq_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","तुखीकालनि नीन इफीस शहरला आपीनान. ");
INSERT INTO wbq_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","त्रोवस शहरला कार्पान इंकल्या नीलचीनेद ना झगा वचेतापुड येकादा. आले आय पुस्तकलू, विशेषत: चर्मपत्रद गुंडाळयाल येकादा. ");
INSERT INTO wbq_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","आलेक्सांद्र तांबटाळ नाद सना लुक्सान शेशी नाळ. वाळ शेशीने वाळ फनीबदल द्यावर वांदी फेड शेशी. ");
INSERT INTO wbq_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","वानदेगार नुस स्वताद रक्षण शे येनटीक की वाळ मनाद शिक्षण नि जोरदार पाने विरोध शेशी न्या. ");
INSERT INTO wbq_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","पहिलानदा येपूळ नाक नाद बचाव शेशेळदी उंड्या आपुळ नाक येवार पण साथ इयाला. दानबद्दल वार आंदार नन्नु इडशी फोईर. परमेश्वर तीकुळ इदी वारउलटा मोजसकम दारोद. ");
INSERT INTO wbq_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","प्रभूळ ना बाजूला नीला फळ्या इंगा नाक सामर्थ्य इच्या दिनकस्रोम की, नातीकुळ नुस संदेशदी पूर्ण घोषणा काला इंगा आंता इंगोगाराष्ट्र मंदी आद्दे आयकाला इंगा वाळ नन्नु फुली नोटलोन नुस इडपीच्या. ");
INSERT INTO wbq_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","प्रभूळ नन्नु हर वगा वाईट फनिल देगारनुट इडशी इंगा वान स्वर्गीय राज्याला तीस्कूनदेंग ताराशी. वांदी सदा सर्वकाळलापर्यंत गौरव काला. आमेन. ");
INSERT INTO wbq_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","प्रीस्कीला, अक्कीला इंगा अनेसीफर इंकल्योनटोर की सलाम शेपना. ");
INSERT INTO wbq_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","एरास्त करींत शहरला नीलच्या. त्रफिमाला नीन मिलेता शहरला इडस्तीन येनटीक की वाड बिमार उंड्या. ");
INSERT INTO wbq_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","नु सलीकलाम कना पहिले ओचेडदी जास्त प्रयत्न शेय. युबुल, पुदेस, लीन इंगा क्लौदिया इंगा इंगोगार आंदार तमूळलू निक सलाम शेप्तार. ");
INSERT INTO wbq_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","प्रभूड नी आत्मासंगा उंडाला. परमेश्वरदी कृपा मी आंदारबरोबर उंडाला.");
INSERT INTO wbq_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","परमेश्वर निवडासनेरदी विश्वासइचांग इंगा भक्तीलेका उंडीने खरेंमदी पूर्ण ज्ञानइचांग नेमाशिनेळ येशु ख्रीस्त प्रेशीत इंगा परमेश्वर दास पौल, इन तीकेल: ");
INSERT INTO wbq_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","जो सर्वकाळदी जीवन यवारकी खोटा मातलु नळाव आ परमेश्वर युग काळपूर्वी इच्या, ");
INSERT INTO wbq_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","आ जीवन दी आशा फत्तेटोर, द्यावर निवडास्ने मंदी विश्वास इचांग इंगा सुभक्ती लेका खरेंम ज्ञानइचांग, आविषयदी वचन वांदी मना ताराशेतोळ द्यावार्दी आज्ञाता नाक इचीने घोषणाला यथाकाळला वाळ प्रकट शेश्या. ");
INSERT INTO wbq_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","मना सामाईक उंडीने विश्वास लेका ना खरेम बिडा तीत इनकी; परमेश्वर आबन तीकेल इंगा मना तारासेटोळ प्रभू येशु ख्रिस्त वान्तिकेल कृपा, मया इंगा शांती उंडाला. ");
INSERT INTO wbq_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","नीन नीनु क्रेत बेट मिंदा दिनकस्रोम फेटीवस्तीन की, नु पूर्ण न आयनेय माटलाद व्यवस्था शेईयाला इंगा नीन निक आज्ञा शेशीनेलेका नु हर नगरला आब्बन नेमाय. ");
INSERT INTO wbq_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","यवारणी नेमाला वाळ निर्दोष उंडाला, वगा आंडीदान मोगुल उंडाला, वान बीळलु विश्वास फेतेटोर उंडी वार्मिंदा घयरेट पनाद आरोप वचीनेद लेकुंडी वार अनावर बेक्काल्या. ");
INSERT INTO wbq_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","प्रमुख इळ द्यावारतोल कारभारी उंडाळ दांचांग वाळ निर्दोष उंडाला, वाळ मोकाट, रागिस्त, सराय तागेटोर, मत्तेटोर डोंगतारला दुडलु कामाशेतोर बेकाल्या; ");
INSERT INTO wbq_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","तर सुत्ताल बद्दल मंचीद, स्वभावादी आवड फेत्तेतोल; मर्यादाला, द्यावर मणशी, पवित्र, सहन शेशेतोळ, ");
INSERT INTO wbq_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","इंगा इचीनेय शिक्षण लेका जो विश्वासदी वचन फेटी निलचेतोल इल्ला उन्डला; दिन्चांग कि वाळ शिक्षणदी माहिती शेयदेंग व उलटा मातालायेतोर की बरोबर उत्तर इचेतोर बेक. ");
INSERT INTO wbq_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","इदी महत्वद उंडाद येनटीक की संगेंम मंदी बंड शेशेतोर उंडार. यवार व्यर्थ माटलाविषइला बडबड शेस्तार इंगा मंदीन फसामत्तुतार. नीन विशेष आंटे, यवार सुंता आईनेर उंडार वारणी संबोधाशी माटलाळतुनान. ");
INSERT INTO wbq_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","वार नोरलू बंद शेया बेक; वार शिका मत्ता बेकालेद आय्यी माटलु वार चुक लाभ इचांग शिका मत्तुतार इंगा पूर्ण इल्लूद उलटापालता शेस्तार. ");
INSERT INTO wbq_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","वारला वगा संदेष्ट्याल आनीर कि, 'क्रेती बेट मनसलू इर हमेशा लबाड, पक्षीलेका खतरनाक, आळशी इंगा खादोळेर उंडार.' ");
INSERT INTO wbq_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","इदी साक्ष खरेंम उंडाद. तरी वार वीश्वासला स्थिर उनडाला दानचांग नु वांदी निषेध शेय. ");
INSERT INTO wbq_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","दिनकस्रोम कि, वार यहूदी कथालतीकुड इंगा खरेमतीकुडकेल तीप्पेटोळ, मणशी आज्ञालतीकुड लक्ष इया रोद. विश्वासला पक्का काबेक. ");
INSERT INTO wbq_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","यवार शुद्ध उंडार इल्ला मंदी पूर्ण माटलू शुद्ध उंडाय पण जो नष्ट आईनेय उंडाय इंगा विश्वास फेटार इलोटोर्की एमी शुद्ध लेद पण वारी मनलु इंगा विवेक इद्दीपण घाण उंडाय. ");
INSERT INTO wbq_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","वार मंदी 'मिम परमेश्वर न ओळखास्ताम' इल्ला उघड शेप्तार, पण वार आ फणीन नाकारास्तार. वार अमंगळ इंगा अंदाज शेशेटोर इंगा यादपन मंची फनिला परीक्षा बिना दिगीनेर आढळास्तार. ");
INSERT INTO wbq_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","नू तर शिंगार शिक्षण कि शोभाशेळ लेका माटलू माटलाळताफो. ");
INSERT INTO wbq_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","आय्यी इल्ला की, मुसलेर मनसलू सहन शेशेळलेका, गंभीर इंगा समजदार का बेक इंगा विश्वास, प्रेम इंगा सहनशीलता दिंटल्या पक्का का बेक. ");
INSERT INTO wbq_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","मुसलेर आंडेर, दांलेकाने, स्वताद स्वभाव पवित्रक शोभाशेळ लेका बेक; चुगली शेशेटोर, सराय तागेटोर बेका लेद; शिंगारा शिक्षण इचेळी उंडाला; ");
INSERT INTO wbq_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","इंगा मनालोन्केल जवान आंडेरकि इल्ला शिक्षण इयाला की, वार स्वता मोगुड इंगा बीळला मिंदा प्रेम शैयाला. ");
INSERT INTO wbq_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","इंगा वार समजदार, शुद्धचरण, इल्लु सांभाळाशेटोर, मैयाद इंगा मोगुन माटा ऐकाशेटोर का बेक; म्हणजे परमेश्वर द वचनदी निंदा का काफोई. ");
INSERT INTO wbq_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","इंगा आल्ले जवान मनसलू समजदार आवा बेक दानीचांग, नु वारकी शिकामत. ");
INSERT INTO wbq_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","नु आन्नी माटलाला शिंगार फनीद उदाहरण इल्ला स्वतःचांग सुपी; नि शिक्षण ला निर्मळपणा, गंभीरता, ");
INSERT INTO wbq_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","इंगा निरपवाद शिंगार शिक्षण कम्पियानी, म्हणजे निमिंदा टीका शेशेटोरकी नि बद्दल माटलाळदेंग एमी वाईट न शिकी इंगा वाळ शिग्गुना फळाला. ");
INSERT INTO wbq_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","इंगा दासलू आन्नी माटलाला वार गुरु आज्ञाला उन्डाला, वार संतोष इचेटोर बेक इंगा उलटा माटलाळा बेकाल्या; ");
INSERT INTO wbq_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","वार दोंगा शैया बेकाल्या तर आणि माटलाला शिंगार विश्वास सुपियाला; इंगा मना तारक परमेश्वर शिकवण कि, आणि मंदीला, वार शोभा एकादाला; इल्ला नु वारकी बोध शेय. ");
INSERT INTO wbq_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","येनटीक की, आंता मंदीक ताराशेळ परमेश्वरदी कृपा प्रकट आयनाद. ");
INSERT INTO wbq_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","आय्यी मनाक इल्ला शिका मत्तुताय कि, बिनभक्तीद इंगा दुन्याम लालचनी इळशी, मनाम इ इप्पूळ काळला धीरजता, नीतीता इंगा सुभक्ती लेका वागा बेक. ");
INSERT INTO wbq_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","इंगा मना धन्य आशाद, म्हणजे मना महान परमेश्वर इंगा ताराशेटोळ येशु ख्रिस्त इन गैरव तोंन वचेळदी दाव्वा सुडाला; ");
INSERT INTO wbq_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","मना इचांग वाळ स्वताद दान शेशा दिनकस्रोम की, मनाय आन्नी गलत माटलाकेल इळप्याल्या इंगा शिंगार फनिक बेक उंडेर मना स्वता मंदी मनाइचांग शुद्ध शेईयाला. ");
INSERT INTO wbq_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","नु इ माटलु समजाशी शेप, बोध शैय इंगा आणि अधिकारता गुन्हा पदरला येय. यवार नीद उपवास शेइया रोद. ");
INSERT INTO wbq_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","क्रेत विश्वास फेटे टोर वार्की इल्ला सुचामत की सरकारी सत्यद न्याय शेशेटोळ इंगा अधिकारी इर शेई किंदा उंडाला. इरी आज्ञा पाळाला, हर वगा फनीला तैयार उंडाला. ");
INSERT INTO wbq_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","यवार्दी निंदा शैयारोद, जगडाल आळेटोर बेकाल्या पण सहनशील आय्यी आंदारकी आन्नी माटलाला नम्रता सुपीयाला, इल्ला वारकी आठवण इ. ");
INSERT INTO wbq_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","येनटीक की मनाम पण पहिला अविचारी, अवमान शेशेटोर इंगा बेहेकासनेर उंटीम; अलग-अलग वासनाली इंगा सुखटोर दासलु उंटीम, वाईट फनीद इंगा घमंडला आताद. मनाम अमंगळ आनेतोर इंगा एकमेकोरदी कोफाम शेशेटोर उंटीम; ");
INSERT INTO wbq_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","पण मना ताराशेळ द्यावार्दी मय्या इंगा प्रेम मनुष्य मदा प्रकट आय्या, ");
INSERT INTO wbq_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","आप्पुड मनाम शेशिनेय, नितीमत्व फनिलाद लेद, पण वाळ मनालनी वान मयाइचांग, कोत्ता जन्मद तीस्कुनी गात पवित्र आत्माता कोतालेका ताराश्या. ");
INSERT INTO wbq_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","इंगा मना तारक ख्रीस्त तीकेल मना मिंदा आदी आत्मा जास्तता येशा. ");
INSERT INTO wbq_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","म्हणजे मनाम वान कृपाता नीतिमान ठहराशी आंनीकाळदी जीवन आशा लेका वारीस काला. ");
INSERT INTO wbq_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","इदी ओक्का विश्वास दी वचन उंडाद इंगा नाद इच्छा उंडाद की, नु इ माटलु ताकदता शेपता फो. म्हणजे, यवार परमेश्वर मिंदा विश्वास फेटीनार वार शिंगार फनीला उंडेळदी काळजी तीस्कोनाला. इ माटलु शिंगार उंडी आंदार मंदी कोळोन्क हितूद उंडाद. ");
INSERT INTO wbq_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","पण मुर्खपणदी जगळाम, गणगोद्दी, झगडाल इंगा मोशेद नियमशास्त्र विषयला जगडाम टाळा मतुता फो येनटीक की इ माटलु बिना फनीय इंगा व्यर्थ उंडाय. ");
INSERT INTO wbq_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","मी मधातला जगळाल आनचेतोर मनशिक वगा तीकुड इंगा रोंड तीकुड शिका मतीनेका मना देगारकेल दुराम फेट. ");
INSERT INTO wbq_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","निक यरका उंडाद, इल्ला मणशी बेहेकासणेळ उंटाल इंगा पाप शेसका उंटे वान तिकेल वानदी स्वताद न्याय आताद. ");
INSERT INTO wbq_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","नीन अंतर्मान इंगा तुखीकलान नीतीकुड आम्पदिचीनेका, नातीकुड निकापलीस शहरकी एल्ली वचेळदी प्रयत्न शेय येनटीक की नीन आंदू सलीकालाम तीशेळदी ठहरामतीनान. ");
INSERT INTO wbq_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","जेना शास्त्री इंगा अपुल्लो इरकी एमी कमी फळाखोयी इल्ला प्रकारता पोहोचा मत. ");
INSERT INTO wbq_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","इंगा मना मंदी स्वता गरजला इचांग शिंगारफनी शेयदेंग शिक्का मत्तेळदी काळजी तीस्कोनाला; म्हणजे वार फळ लेनेर का फोयार. ");
INSERT INTO wbq_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","नाबरोबरटोर आंदार निक दंडाम शेप्तार. यवार मना मिंदा विश्वासइचांग प्रेम शेस्तार वारकी नाद दंडाम शप. मी संगा कृपा उंडाला.");
ALTER TABLE wbq_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
