﻿USE sofia;
DROP TABLE IF EXISTS sofia.wbp_vpl;
CREATE TABLE wbp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wbp_vpl WRITE;
INSERT INTO wbp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nyampu yimi, ngulaju yupuju-warnu-juku nyiyarningkijarraku. Kamparruju nyurru-wiyiji, ngulaju Kaatuju nyinajalpa yangarlu-wiyi nyanungu-mipa. Lawarni-jarralpa yalkiriki manu walyaku karrija, murnma-juku. Ngula-jangkaju, ngurrju-manu nyiyarningkijarra yangka kuja karlipa nyanyi jalangurlulku. ");
INSERT INTO wbp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ngapa-wiyilpa ngunaja warrukirdikirdi ngurujarraranypa yurnilyka-maninja-warnu. Ngulalpa parra-wangu-juku karrija murnma-juku. Kaatukujurla warlpa wiri-nyayirni marlaja wangkajarni kuja-purda-jarra ngapangka kankarlumparra. ");
INSERT INTO wbp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ngula-jangkaju, Kaatuju wangkaja, “Parra, marlajaju parrarl-pantika!” Junga-juku, parrajurla marlaja parrarl-panturnu ngurujarraranypalku. ");
INSERT INTO wbp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ngularla Kaatuju nyanjarla wardinyi-jarrija parrakuju. Ngula-jangkaju, munga manu parra, ngalya-pangurnu-palangu. ");
INSERT INTO wbp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ngalya-pangirninjarla, yirdilki-palangu yungu ‘Parra’ manu ‘Munga’. Ngulaju ngula-juku. Munga-ngurlu, mungalyurru-kurra, ngulaju parra kamparru-warnu-juku. ");
INSERT INTO wbp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Parra-karirlalku, Kaatuju wangkaja, “Yalkiri, marlajaju palka-jarriya ngami wiri-jarlu-piya rdakurlpari kuja-ka kaninjarra-kari karrimi!” Junga-juku, kujarlunya ngurrju-manu yalkiriji. Ngulangku yalkirirli yangka ngami wiri-jarlu-piyarlu ngapaju ngalya-pangurnu. Ngalya-kari ngapa kankarlarni yalkirirlalpa ngunaja. Ngalya-kari ngapa, ngulajulpa ngunaja kanunju. ");
INSERT INTO wbp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nyampu ngami-piya rdakurlpari, ngulakujurla yungu Kaaturluju yirdi ‘Yalkiri’. Ngulaju ngula-juku. Munga-ngurlu, mungalyurru-kurra, ngulaju parra-karirlalku. ");
INSERT INTO wbp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ngula-jangka, Kaatuju wangkaja, “Ngapa, marlajaju kanunju-jarrinja-yanta yungu walya parduna palka-jarri!” Junga-juku, ngapajulurla marlaja kanunju-jarrija. Kujarlunya ngurrju-manu walya pardunaju. ");
INSERT INTO wbp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kuja walya parduna palka-jarrija, ngulakujurla Kaaturluju yirdiji yungu ‘Walya’. Kujarla ngapa marlaja kanunju-jarrija manulpa palka-juku ngunaja, ngulakujurla Kaaturluju yirdiji yungu ‘Ngapa Mangkuru’. Kuja-palangu nyangu walya manu ngapa mangkuru, ngulakuju-palangu wardinyi-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Ngula-jangkaju, Kaatuju wangkaja, “Yukuri-kari yukuri-kari, marlajaju purrulyun-pardiya ngurlu-kurlu manu miyi-kirli!” Kuja wangkaja, junga-juku, marlajarla purrulyun-pardija watiya-kari watiya-kari ngurlu-kari ngurlu-kari-kirli. Kujarlunya ngurrju-manu-jana yukuri-kari yukuru-kariji. Ngula kuja-jana nyangu, ngulakuju-jana wardinyi-jarrija ");
INSERT INTO wbp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ngulaju ngula-juku. Munga-ngurlu, mungalyurru-kurra, ngulaju parra-karirlalku. ");
INSERT INTO wbp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ngula-jangka, Kaatuju wangkaja, “Nyumpala mirilmiril-karrinja-palka-jarra, marlajaju-pala ngirra-manta yalkirirla yungunpala ngalya-pangirni munga manu parra! Nyinaka-pala yalkirirla yungunpala ngirra-mani walya warrukirdikirdi! Ngaka kajili-nyarra yapangku nyanyi yalkirirla, ngulaju kapulu milya-pinyi parra manu munga, manu kapulu milya-pinyi nyangurlarlu yungulu purlapa-kari purlapa-kari pinyi pirriya-puru marda manu marda karapurda-puru.” Junga-juku, kujarlunya-palangu ngurrju-manu mirilmiril-karrinja-palka-jarraju yalkirirlaju. ");
INSERT INTO wbp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","18","Kaaturluju-palangu ngurrju-manu yurrupupu manu kirntangi yungu-pala ngalya-pangirni munga manu parra. Jinta-kari wiri, jinta-kari wita-karrikarri. Jinta-kari wiri-ka nyina parra-kurlangu. Jinta-kari wiri-ka nyina munga-kurlangu. Manu yanjilypiri, panu-jarlu-jana witawita manu wiriwiri yirrarnu yalkirirla. Ngulakuju-jana nyanjarla wardinyi-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ngulaju ngula-juku. Munga-ngurlu, mungalyurru-kurra, ngulaju parra-karirlalku. ");
INSERT INTO wbp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ngula-jangkaju, Kaatujurla wangkaja ngapa mangkuruku, “Nyuntu-ngurlu, ngajuku kapu-julu marlaja palka-jarri yawu-kari yawu-kari ngapa-ngawurrpa-waja panu-jarlu-nyayirni!” Ngula-jangkajurla wangkaja yalkiriki, “Nyuntu-ngurlu, ngajuku kapu-julu marlaja palka-jarri jurlpu-kari jurlpu-kari panu-jarlu-nyayirni yungulu warru paarr-pardimi kankarlumparra!” ");
INSERT INTO wbp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Junga-juku, Kaaturlu-jana ngurrju-manu yawu-kari yawu-kari wiri-jarlu kulu-parnta-nyayirni, nyiyarningkijarra kuja kalu warru wapa manu nyina ngapangka kanunjumparra. Kaaturluju-jana ngurrju-manu jurlpu-kari jurlpu-kari pinkirrpa-kurlu witawita, wiriwiri. Ngulaju Kaaturlu-juku-jana muku ngurrju-manu, manu ngulakuju-jana nyanjarla wardinyi-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kaaturlu-jana wangkanjarla pirrjirdi-manu kujarlu, “Kurdukurdu panu-nyayirnijili marlaja kurduwarr-kijika, manulu warru wapaya kujarla yalarnirla ngurujarraranypa!” ");
INSERT INTO wbp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ngulaju ngula-juku. Munga-ngurlu, mungalyurru-kurra, ngulaju parra-karirlalku. ");
INSERT INTO wbp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ngula-jangkaju, Kaatujurla wangkaja walyaku, “Nyuntu-ngurlu, ngajuku kapu-julu marlaja palka-jarri kuyu-kari kuyu-kari panu-jarlu-nyayirni yungulu walyangka wapami manu warru kiripi-kanyi manu kiwirlki-parnka!” Junga-juku, kujarlunya-jana ngurrju-manu kuyu-kari kuyu-kariji. ");
INSERT INTO wbp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Puluku-kari puluku-kari manu wardapi-kari wardapi-kari manu warna-kari warna-kari, ngulaju-jana Kaaturluju ngurrju-manu witawita wiriwiri kuja kalu warru wapami manu kalu kiripi-kanyi manu kalu kiwirlki-parnka warru walya-wana. Ngula-jana nyangu, ngulakuju-jana wardinyi-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ngula-jangka, Kaatuju wangkaja, “Yapalkurlipa-jana ngurrju-mani ngalipa-piya. Nyampurra yapa yungulu-jana wiri-nyayirni nyinami pulukuku, yawuku, jurlpuku, warnaku, wardapiki. Yungulu-jana wiri nyina warru wapanja-palkaku, kiripi-kanja-palkaku, manu kiwirlki-parnkanja-palkaku.” ");
INSERT INTO wbp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Junga-juku, Kaaturluju-jana ngurrju-manu yapaju nyanungu-piya-juku. Wati manu karnta kuja-jana ngurrju-manu, ngulajulu nyanungu-piya-juku. ");
INSERT INTO wbp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ngula-jangkaju yapaju-jana wangkanjarlu pirrjirdi-manu kujarlu, “Kurdukurdu panu-nyayirnijili marlaja kurduwarr-kijika yungulu panu-jarlu-nyayirni pirri-matirni nyurrurla-nyanguju kujarla yalarnirla ngurujarraranypa. Ngulaju kapulu-jana wiri-nyayirni nyina nyiyarningkijarrakuju kuja kalu walya-wana warru wapa manu kuja kalu warru paarr-pardi yalkiri-wana. ");
INSERT INTO wbp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nyurru-jukurna-nyarra yirrarnu watiya-kari watiya-kari miyi-kirli manu nguru kuntukuntu ngurlu-kurlu pirdaku ngarninjaku nyurrurlakuju. ");
INSERT INTO wbp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Nyiyarningkijarraku jurlpuku manu pulukukuju manu ngula kalu warru kiripi-kanyi, ngulakujurna-jana yirrarnu yukuri-mipa-juku pirdaku ngarninjaku yungulu yukuri-mipa-juku ngarni.” Kujanya-jana Kaatuju wangkaja yapakuju. Junga-juku, kujarlunya-jana yapa ngurrju-manu. ");
INSERT INTO wbp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ngula-jangka, marlaja nyangu-nyanu nyiyarningkijarra kuja nyanungurlu ngurrju-manu ngarlarrpa. Ngulaju ngula-juku. Munga-ngurlu, mungalyurru-kurra, ngulaju parra-karirlalku. ");
INSERT INTO wbp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yuwayi, kujarlunya Kaaturlu nyiyarningkijarra ngurrju-manu. ");
INSERT INTO wbp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ngurrju-manu nyiyarningkijarra jika-pala parrakuju. Ngula-jangka parra-pardu-karirlalku nyanjarla yampija warrki Kaaturluju. ");
INSERT INTO wbp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ngula-jangka-nyanu wangkaja parra yalumpurla-juku, “Ngula-juku kapurna nyina warrki-jarrinja-wangu. Nyampukuju parra-nyayirni-wanguku karnajurla jaarl-karri tarrukuku ngaju-nyanguku.” Kujarlunya Kaaturlu tarruku-manu parra-nyayirni-wangu yali nampa wirlki ngulaju yungulu yapa nyinami warrki-wangu-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nyampuju yimi ngulaju yangka kuja YAAWIYI Kaaturlu ngurrju-manu walya manu yalkiri. ");
INSERT INTO wbp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Kuja ngurrju-manu nyiyarningkijarra walyangka, kamparrujulpa lawa-wiyi karrija watiya-wangu manu marna-wangu. Yapa-wangu-wiyilpa karrija nyiyarningkijarraku nyampuku warrawarra-kanjaku. Kulalpa yalkiri-ngirli-wiyi wantija ngapaju nyurru-wiyiji murnma-juku. ");
INSERT INTO wbp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ngarilpa puyukuyukurlu walykarra-manu nguruju ngapa-piyarlu-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ngula-jangkaju, YAAWIYI Kaaturluju walya yaku-manu. Ngula-jangkaju, yaku-maninjarla rdakangku-juku ngurrju-manu wati walya-jangka. Ngula Kaaturluju mulyu-wanarlu purrujungu, ngulajurla ngaanypa yungu ngaany-kijirninjaku. Ngula-jangkaju, ngaany-kijirninjarla wankaru-jarrijalku watiji. ");
INSERT INTO wbp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ngula-jangkaju, ngaka-karilkirla, YAAWIYI Kaaturluju ngayi yarlu-pungu ngurraju kaatiniji kakarrumparra-warnu yirdiji Yitini. Ngula-jangkaju, yarlu-pinjarla watiyalku-jana jukajuka-yirrarnu walyangka yama ngurrju-nyayirni. Ngulangkanya wati yaliji yirrarnu nyinanjaku tarnngaku yangka kuja ngurrju-manu rdakangku. ");
INSERT INTO wbp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kuja-jana yirrarnu watiya, ngulajulpalurla marlaja purrulyun-pardija panu-jarlu yama manu mangarri-kirli. Ngurrju-nyayirni miyi-kirli manu ngurrju-nyayirni watiya ngarnkulku nyanjaku. Ngulangka kaatinirla yirdingka Yitinirla, YAAWIYI Kaaturluju-palangu yirrarnu watiya-jarra kulkurru-jarra kaatinirla. Jinta-kari watiya ngulaju ngurrju yirrarnu miyi-kirli ngurrju-kurlu. Kajirla watiji jatu-pardiyarla miyiki ngarninjaku, ngulaju kapu wankaru-juku warrarda nyinayarla palinja-wangu. Jinta-kari watiya, ngulaju ngurrju-yijala yirrarnu miyi-kirli ngurrju-yijala. Kajirla watiji jatu-pardiyarla miyiki ngarninjaku, ngulaju kapu rdirrinypa-jarriyarla maju milya-pinjaku manu ngurrjuku milya-pinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yangkangka ngulangka, karrujulpa parnkaja kulkurru-jarra kaatini-wana Yitinirla. Ngulangkarlu karrungkarlu, ngapangkujulpa-jana watiyaju yarlurnu. Ngula-jangka karru jinta-jangka, ngulajulu panu-jarrijalku kuja-purda kuja-purda. ");
INSERT INTO wbp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","14","Karru nyampu-paturlu, ngulajulpalu yirdi jarnkujarnku mardarnu Pijana, Kiyana, Tirrkiji, manu Yupirayiti. Yangka karru yirdiji Pijana, ngulaju kiwirlki-parnkanja-yanu nguru-kari-wana yirdi-wanaju Yapila-wana. Ngulangkaju panu-nyayirnilpa kawurlu ngunaja manu panu-kari-juku pamarrpa mirilmirilpa-nyayirni-yijala. Manu palya-piyalpalu ngurrju ngunaja yalirlaju ngurungka. Karru-kari jinta-kari yangka yirdi Kiyana, ngulaju jingijingi parnkanja-yanu nguru-kari-wana yirdi-kari-wana Kuuju-wana. Yangka karru jinta-kari yirdi Tirrkiji, ngulaju parnkanja-yanu kakarrumparra-warnu nguru-karirla Yajiriyarla. ");
INSERT INTO wbp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nyurru-wiyi kuja yangka YAAWIYI Kaaturlu yirrarnu wati yaliji yangka Yitinirla, ngulaju miyiki wiri-maninjaku manu watiyaku jina-mardarninjaku manu nyiyarningkijarraku warrawarra-kanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ngula-jangka, YAAWIYI Kaaturlujurla pututu-pungu jarungkuju pirrjirdi-nyayirnirli watikiji, “Nyampurra ngula kalu watiya karrimi, ngularra-ngurlu-puka nganja. ");
INSERT INTO wbp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ngula-ka nyampu kulkurrirni watiya-kari karri, ngula-jangkaju yampiya ngarninja-wangurlu! Kajilpanpa wiljingki kutu nganjarla, ngulaju kajikanpa rdirrinypa-jarri maju milya-pinjaku manu ngurrju milya-pinjaku. Ngula-jangkaju, rdirrinypa-jarrinjarla kajikanpa ngarninjarla palimilki tarnnga-juku. Junga karnangku kujaju wangka.” ");
INSERT INTO wbp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ngulajulpa wati yaliji nyinaja jinta-wiyi-jiki yangarlu kali-nyanu-wangu. Ngula-jangkaju, YAAWIYI Kaaturlujulpa warrawarra-kangu watiji kujalpa nyarrpakupurda yirraru nyinaja. Kaatuju-nyanu manngu-nyanjarla wangkajalku, “Nyampu ngula-ka wati nyinami yangarlu, ngulakuju karnarla marilki nyina. Kukurnarla-ngarra ngurrju-mani puntu jungu yungu-pala nyina manu warrki-jarri.” ");
INSERT INTO wbp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Junga-juku, YAAWIYI Kaaturluju-jana ngurrju-manu walya-jangka jurlpu-kari jurlpu-kari, manu nyiyarningkijarra yangka kuja kalu wapa walyangka puluku-waja, nantuwu-waja. Junga-juku, kangurnulkurla jurlpu-kari jurlpu-kari manu nyiyarningkijarra watikiji yungu-jana nyanungurlulku miimii-nyanjarla yirdi-kari yirdi-kari yinyi. ");
INSERT INTO wbp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Junga-kirli-jana watingkiji nyangu yangkaju nyiyarningkijarra manu jurlpu-kari jurlpu-kari, yinjakulku-jana yirdiki rdirri-yungu. Ngalya-karikiji-jana muku yungu yirdiji kuyu-kari kuyu-kariki manu jurlpu-kariki. Ngulaju ngula-juku. Kala nyanungu-piyakuju yapakulparla puta purda-nyangu yangka jungu nyinanjaku manu jungu warrki-jarrinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ngula-jangkaju, YAAWIYI Kaaturluju jarda yirrarnu. Kujalpa wati jardalku ngunaja, ngula-kurra-juku ramarralku yungkurnu wilypi-manu. Ngula-jangkaju, wilypi-maninjarla ngurljuju pina nimirr-yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","YAAWIYI Kaaturlu kuja ramarra maninjarla kangu, ngula-jangkaju, ramarra-jangka ngurrju-manu karntalku. Karnta palkalku milki-kangurla watikiji. ");
INSERT INTO wbp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ngula-jangkaju, wardinyilki wangkaja watiji, “Wardardayi! Ngaka jalangurna nyampu-piya nyangu! Ngaju-nyangu-jala ramarraju manu yilara! Kaaturlu ngurrju-manu ngaju-nyangu-jangka ramarra yungkurnu-jangka. Ngulaju karna yirdi-mani ‘karntalku’.” Kujanya watiji wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","25","Ngula-jangka, wati yali manu nyanungu-parnta karnta, ngulajulpa-pala nyinaja lawa-juku jalya-wiyi jurnarrpa-wangu, ngulajulpa-pala kutu nyinaja kurntakurnta-wangu. Junga kujaju. Kuja-ka jalangu-jarra wirriya wiri-jarri, wiringkiji yungulpa-palangu yampiyarla nyanungukupalangu-jarra kirda-nyanu manu ngati-nyanu yupukarra-jarrinjakungarntirlilki. Kuja-ka karntalku mani, ngulaju jungu kapala jintangkalku nyina jawirdikilki. ");
INSERT INTO wbp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yangkangka kaatinirla Yitinirla, ngulangkajulpa warna nyinaja rdirrinypa-nyayirni panu-kari kuyu-kari-piya-wangu yangka kuja-jana YAAWIYI Kaaturlu ngurrju-manu. Junga-juku, ngula warnangku jatu-pardinjarla payurnu karntaju, “Junganya ngantangkupala Kaaturluju warla-pajirninjarla pututu-pungu nyampu-kujakuju watiya-kari watiya-kari-kijaku nganta mayi kulanpala miyi nganta ngarni nyampu-patu-jangkaju watiya-jangkaju?” ");
INSERT INTO wbp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Karntangkuju jangku-manu pina, “Lawa kujakuju. Wangkaja-jarrangku panu-karikiji miyikiji maninjaku manu ngarninjaku. Ngulaju kajikarlijarra miyiji ngarni. Yalumpu-jangka-mipa watiya kuja-ka karri kulkurrurni, kulalparlijarra ngula-jangkaju miyiji marnpikarla manu nganjarla. Kajilparlijarra marnpikarla, ngulaju nganta kajikarlijarra palimi.” ");
INSERT INTO wbp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Warnajurla wangkaja, “Lawangka warlka! Kajinpala ngarni, ngulaju kulanpala palimi! ");
INSERT INTO wbp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kaaturluju-ka milya-pinyi kajilpanpala nyampu miyi nganjarla, ngulaju kajikanpala rdirrinypa nyinami nyanungu-piya. Rdirrinypa-jarrinjarla kajikanpala pina-nyayirni nyinami ngurrju milya-pinjaku manu maju milya-pinjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Junga-juku kujarlaju, karrinja-pardijalku karntaju. Yarnkajarralku watiya-kurraju, ngulalpa miimii-nyangulku. Ngula-jangka-nyanu wangkaja kanunju-kari, “Nyampuju ngurrju, ngarirna nyampu miyi ngarni, kapurna rdirrinypa-nyayirni nyina Kaatu-piyaju.” Junga-juku, miyi manu, maninjarla rdilyki-ngarnu. Ngula-jangka, yungurla nyanungu-parntakulku watiki karntangkuju. Muku-pala ngarnu jirramarlu-juku. ");
INSERT INTO wbp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yungka-pala muku ngarnu miyi, ngula-jangkarluju-pala-nyanu parlu-pungu jalyalku. Ngula-jangkaju, kurnta-jarrijalku-pala-nyanu nyanjarla. Wijirrki-piya parlalku-pala pajurnu majardikingarntirliji, manu-pala-nyanu parnta-yirrarnu. Palkangka-pala-nyanu warru wayurnu. ");
INSERT INTO wbp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Jintangka parrangkaju, YAAWIYI Kaatuju yanurnu wuraji walykangka. Warrulpa wapaja yangkangkaju kaatinirla Yitinirla. Warrurnulpa-palangu warru yangka-jarraku. Purda-nyangu-pala nyanungu-jarrarluju warru wapanja-kurra manu yirily-karrinja-kurra. Ngula-kujakuju nyanungu-jarraju, lanilki-pala lurru-wantija Kaatu-kujaku. ");
INSERT INTO wbp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Junga-juku, YAAWIYI Kaatujulpa warru purlanja-karra wapaja, purlajalparla warru watiki, “Nyarrpararlanpayi?” ");
INSERT INTO wbp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Junga-juku, jangku-manu watingkiji, “Nyampurlarnawu! Purda-nyangurnangku yirilyirily-yaninjarni-kirra. Lanilkirna wuruly-parntarrija kurntangka kujarnaju jalya nyangu.” ");
INSERT INTO wbp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kaaturlu payurnu watiji, “Nganangku ngantangku ngarrurnu jalyakuju? Yangka kuja-ka watiya yali karri kulkurru-warnu, yangkarnangku wangkaja yampinjaku ngarninja-wangu, ngula-jangkanyanpa miyiji ngarnu?” ");
INSERT INTO wbp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Watingkiji jangku-manu, “Yalumpu yangka kujanpaju karnta yungu, ngulangkunyaju miyiji yungu. Ngayirna miyiji kutu ngarnu.” ");
INSERT INTO wbp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","YAAWIYI Kaatuju wangkajarla karntakulku, “Junganya?” Karntangku jangku-manu, “Nyampurluju warnangku yimirr-yungu warlkangku, manurna ngarnulku miyiji.” ");
INSERT INTO wbp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","YAAWIYI Kaatuju wangkajalkurla warnakuju, “Nyampu-jangkaju kapurnangku warntarla-mani kuja-purda-kari kuyu-kari kuyu-kari-kijaku. Kularna-jana yalumpu-patu-kari juyurdurlu-yunparni, kapurnangku nyuntulu-puka juyurdurlu-yunparni. Kapunpa nyinami yangarlu jinta kuyu-kari kuyu-kari-wangu. Kapunpa tarnngangku-juku miyalurlu pirirr-pinja-yani, manu kapunpa kiwirlki-parnka. Kapunpa walya ngarni pirdakuju tarnngangku.” Wangkaja-jukurla warnakuju: ");
INSERT INTO wbp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","“Kari-nganta kapunpala-nyanu warna manu karnta mingany-karri tarnnga-juku. Nyanungu-nyangu kurdukurdu, nyuntu-nyangu kapulu-nyanu mingany-karri-yijala tarnnga-juku. Karnta-kurlangurlu kurdungku kapungku jurrungka-juku warrarda jalkuly-katirni. Nyuntu-nyangurlu kapu tarnngangku-yijala warrarda lukungka-juku yarlkirni.” Kujanyarla wangkaja warnakuju. ");
INSERT INTO wbp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ngula-jangkaju, karntakulkurla wangkaja YAAWIYI Kaatuju, “Kajinpa kurdu nyuntu mardarni, ngulakungarntiji kapunpa-nyanu murrumurru-nyayirni purda-nyanyi. Manu nyuntu-parnta kali-nyanu kapungku wiri-jiki nyina tarnnga-juku jinjinpaku, ngulakuju nyuntuju kapunparla warrarda yulkami kuja kanpa wardu-pinyi miyalurlu.” Kujanyarla wangkaja karntakuju. ");
INSERT INTO wbp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ngula-jangka, watikilkirla wangkaja YAAWIYI Kaatuju, “Kujarnangku yangka pututu-ngarrurnu yampinjaku miyiki nyampuku watiya-jangkaku, nyuntulurlulkunpa wiljingkiji kutu ngarnu. Kulanpaju ngajuju purda-nyangu. Nyuntu-parnta-mipanpa purda-nyangu. Jalangurlu kapurna-nyarra nyampuju walya jurnta juyurdurlu-yunparni. Kujarlaju, miyi kapungku walyangku tarlangku jurnta mardarni. Kapunpa warrki-jarrimi miyikipurda mata-wangu, kala lawa. ");
INSERT INTO wbp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Jilkarla-mipa manu putunarri-mipa kapungku marlaja pardi ngulaju jilkarla-jarra-kurlu-juku. Kapunpa yukuri-kari yukuru-kari ngarni. ");
INSERT INTO wbp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kapunpa wapa mangarrikipurda mukarniki mukarniki warrirninja-karra. Kala kajinpa puta wiri-mani mangarri walya-jangka, kapunpa mata-jarri-nyayirni, manu mukarni wita-wangu kapunpa karlimi warrki-jarrinja-karra. Nyuntujunpa walya jurdu-jangka-jala, ngula-jangkanyarnangku nyuntuju ngurrju-manu. Kajinpa pali, ngulaju kanpa pina-yuka jurdu-kurra-yijala nyuntuju.” Kujanyarla wangkaja watiki. ");
INSERT INTO wbp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Yali wati, ngulaju yirdiji Yatumu. ‘Yatumu’ yirdiji ngulaju ‘Walya’. Ngulangkuju kali-nyanurlu karntaju yirdi-manu yirdiji Yiipi. ‘Yiipi’ yirdiji ngulaju ‘Wankaru’. Ngulajulpa-jana nyinaja ngati-nyanu yapaku jintawarlayiki. ");
INSERT INTO wbp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ngula-jangka, YAAWIYI Kaaturluju-palangu jurnarrpa ngurrju-manu pinti-jangka, manu-palangu parnta-yirrarnulku. ");
INSERT INTO wbp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ngula-jangka, YAAWIYI Kaatu-nyanu wangkaja kanunju-kari, “Yali wati, ngulaju ngalipa-piya-yijala, kuja-ka miyi ngarninja-warnu nyinami ngurrju milya-pinjaku manu maju milya-pinjaku. Kuja kapala watiya-jarra karri kulkurrurni Yitinirla kaatinirla, watiya-kari ngulaju wankaru-jarrinja-kurlangu. Watingki kajilpa nganjarla miyi nyampu-jangka watiya-jangka, ngulaju kajika wankaru-juku warrarda nyina palinja-wangu.” ");
INSERT INTO wbp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ngula-kujaku yali-kijaku watiya wankaru-jarrinja-kurlangu-kujaku, YAAWIYI Kaaturluju yilyaja-palangu kakarrara-purda yalumpu-ngurlu Yitini-ngirliji nguru-kari-kirralku, yalirla ngurungka yungu-pala-nyanu miyiji wiri-mani. Junga-juku, miyilki-pala-nyanu wiri-manu walya-jangka jurrku-jangka kuja yangka Kaaturlu ngurrju-manu wati jinta walya-jangka. ");
INSERT INTO wbp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kuja-palangu yilyaja kakarrara-purda, marramarra-jana kakarrara-yijala kulkurru yirrarnu yungulu-palangu warla-pajirninjarla pina-yilya kajilpa-pala yangka watiya-kurra wankaru-jarrinja-kurlangu-kurra pina-yantarlarni. Manu junma kirrirdi-palangu jaarl-yirrarnu. Ngulajulpa warru kurrulykurruly-wantija kulkurruju, manulpa jarra wiri jankaja junmaju. Ngula-wanaju kula-pala pina-yantarlarni Yitini-kirraju miyiki watiya-jangkaku ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Kuja-palangu Kaaturlu yilyaja kakarrara-purda, ngulajulpa-pala nyinaja jintangka-juku kalinja. Ngula-jangkaju-palangu kurdu jinta palka-jarrija, ngulakujurla yirrarnu Yiipirliji yirdi Kayini Ngula wangkaja Yiipiji, “Wirriyajurnajurla marlaja manu YAAWIYI-kiji.” ");
INSERT INTO wbp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ngula-jangkaju, yali-pardu-karirlalku jinta-karilkirla palka-jarrija kurdu-karilki wirriya-yijala, ngulakujurla yirdiji yirrarnu Yiipirliji Yapulu. Kuja-pala jirrama-juku wiri-jarrija, jinta-karirli kukurnu-nyanurlu Yapulurlu, jiyipi kala-jana warrawarra-kangu manu jina-mardarnu. Jinta-karirli papardi-nyanurlu Kayinirli, ngulaju kala mangarri wiri-manu walyangka. ");
INSERT INTO wbp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","Ngaka-pardu-karilki, kukurnu-nyanurluju jiyipi-pardu wita kamparru-warnu ngurrju-nyayirni miimii-nyanjarla milarnurla Kaatukuju warntarri-nyayirni-wangu. Ngulaju kipili-nyayirnirla pajirninjarla yirrarnu, kujarlunyalparlajinta pulka-pungu YAAWIYI-ki. Ngulakujurla YAAWIYI-ji wardinyi-jarrija manu rdakurl-kujurnu nyanungu-kurra-pinangu. Yangka jinta-karirli papardi-nyanurlu, ngulajurla miyi walya-jangka kanjarla-yirrarnu warntarri-nyayirni-wangu nganta. ");
INSERT INTO wbp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ngulaku miyiki kularlajinta marlaja wardinyi-jarrija YAAWIYI-ji, manu nyanunguku kularla wardinyi-jarrija. Kujarlaju Kayiniji warlirna-jarrija, manu miparrpaju muntuku-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","YAAWIYI-rli payurnu, “Nyiyarlanpa kulu-jarrinjarla muntuku-jarrija miparrpaju? ");
INSERT INTO wbp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kajilpanpaju ngurrju nyinayarla, ngulaju kajikarnangku rdakurl-kijirni. Kala kajilpanpa ngurrju-wangu-juku nyinayarla, ngulaju kalakanpaju karlirr-yaninja-yani tarnnga-juku. Juju Ngawungku kangku wurru-kanyi nyuntuku yungungku rdarri-mardarninjarla karlirr-kanyi. Ngula-kujakuju-nyanu warrawarra-kangka muurlparlu karlirr-yaninja-kujaku.” ");
INSERT INTO wbp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Parra-pardu-karirlalku, Kayiniji wangkajarla nyanungukupurdangkaku kukurnu-nyanuku, “Yanirli wirlinyi!” Junga-juku, yarnkajalku-pala. Yanurra-pala yarlu-kurra warlangarrangarra-kurra. Yalumpurla-juku warlangarrangarrarla, Kayinirli jatu-pardinjarla pakarnu kukurnu-nyanu tarnnga-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ngula YAAWIYI-rliji rdipinjarla payurnu parrangka jintangka-juku, “Nyarrpararla kukurnu-puraji?” Kayinirliji jangku-manu, “Karija, kulalparna nyiyaku warrawarra-kangkarla!” ");
INSERT INTO wbp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","YAAWIYI-rliji yarda payurnu Kayiniji, “Yuwa, nyarrpa-manunpa nyuntukupurdangkaju? Nyanyi karna yalyu pirlpirl-wantinja-warnu, kuja yawarra-jangkaju pirlpirl-wantija walya-kurra, ngulaju karna nyanyi. Kari-nganta kaju yalyungkuju muku yimi-ngarrirni nyuntuju linjarrpa wiri-jangka! ");
INSERT INTO wbp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","Kari-nganta nyuntulurlunpa rdakangkuju pakarnu parumpurra-kurra-pinangu! Yalyu kuja pirlpirl-wantija walya-kurra, ngulaju yukaja yalyu. Nyampurla ngurungka kajinpa puta wiri-mani miyi, ngulaju kapunpa puta wiri-mani, lawa-juku. Kulangku miyiji wiri-jarrimi, wita-kari wita-kari kapungku puta wiri-jarri nyuntukuju, lawa-juku. Warrkirinyi-panu kapunpa nyuntuju warru wapakarra wapami tarnnga-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","14","Ngula-jangkaju, Kayinijirla wangkaja YAAWIYI-ki, “Waranpayi! Nyiyaku kanpaju yilyami nguru nyampu-ngurlu ngurrju-ngurlu? Kularnangku jirrnganja nyinamilki. Kula karna ngurulku mardarni warrkirinyirli ngajulurluju. Kapurna kujarla yalarnirla warru wapakarra wapami. Nganangku-puka kajili parlu-pinyi ngaju, ngulaju kapujulu nyurunyuru-jarrinjarla jangkardu parnkami kulu. Wiyarrpakunpaju ngajuku karrikarri-wangu-nyayirni kulu-jarrija marrka-nyayirni kunka-maninja-karra.” ");
INSERT INTO wbp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kujaju YAAWIYI-ji wangkajarla Kayinikiji, “Kujaju lawangka kanpa wangkami. Nganangku-puka kajingki yapangku jangkardu parnkanjarla pakarni, ngulaju kapurnangkurla kunka-mani. Kula ngula jinta-mipa, panu-jarlu-juku yapa nyanungu-nyangurlangu warlalja kapurnangkurla kunka-mani. Kapurnangku palkangkaju rdipa yirrarni, ngula kajingkili nyanyi rdipa-kurlu, rdipa nyanjarla kulangkulu ngula-kurluju murrumurru-mani.” Junga-juku, YAAWIYI-rlijirla palkangkaju rdipa yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ngula-kurlu rdipa-kurluju Kayinijirla jurnta yarnkaja YAAWIYI-ki kakarrara-purda nguru-kari-kirra yirdi-kirraju Nuurdu-kurra. Nuurduju ngulaju kakarrara Yitinikiji. ");
INSERT INTO wbp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayinirli kangu nyanungu-parnta karnta nguru-kurra Nuurdu-kurra. Yalirla ngurungka, ngulaju-palangu kalinjaku kurdu wirriya palka-jarrija. Ngulakujurla yirdiji yungu Yiniki. Ngulangkaju, Kayinirliji yungurla yirdiji ngurrakuju Yiniki-yijala. Yalirla kirringka, Kayinirlijilpa-jana yuwarli-kari yuwarli-kari nganturnu. ");
INSERT INTO wbp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Yinikiji, ngulakujurla ngalapi-nyanu-yijala palka-jarrija yirdiji Yirati. Yiratikijirla ngalapi-nyanu-yijala palka-jarrija yirdiji Yujalu. Yujalukujurla ngalapi-nyanu-yijala palka-jarrija yirdiji Jujajulu. Jujajulukujurla ngalapi-nyanu-yijala palka-jarrija yirdiji Lamiki. ");
INSERT INTO wbp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamiki kuja wiri-jarrija, ngulangkuju-palangu yupukarra-jarrinjarla manu jirrama karnta-jarra. Jinta-kariji yirdiji Yaata, jinta-kariji yirdiji Jiila. ");
INSERT INTO wbp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","21","Jinta-kariki yirdiki Yaataku, ngulakujurla kurdu wirriya palka-jarrija, ngulaju yirdiji Japala. Ngula-jangkaju, jinta-karilki kurdu-kari wirriya-yijala yardarla palka-jarrija jintaku-juku Yaataku, ngulaju yirdiji Jupulu. Papardi-nyanurlu yirdingki Japalarlu, ngulangkuju kala-jana warrawarra-kangu puluku-wati, manu kala nyinaja kalukurla. Nyanungu-wangurla-wiyi kula-jana nganangku warrawarra-kangu pulukuju, manu kula ngana nyinaja kalukurlaju, lawa. Kala yangka kukurnu-nyanu yirdi Jupulu, ngulajulpa kamparru-warnu manyu-karrija kurlumpurrngu wita-piya-kurlu manu kita-piya-kurlu. Nyanungu-wangurla-wiyi kula ngana yapa manyu-karrija kurlumpurrngu wita-piya-kurlu manu kita-piya-kurlu, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Yangka jinta-kari Lamikiki kali-nyanu-yijala yirdi Jiila, ngulakujurla kurdu-yijala palka-jarrija wirriya. Yirdijirla yirrarnu Tupulu-Kayini. Ngaka-pardu-karilki jinta-karilki kurdu-yijala palka-jarrijarla nyalali. Yirdijirla yirrarnu Naama. Tupulu-Kayinirli ngulaju kala nyiyarningkijarra ngurrju-manu yayini-jangka manu yangka yayini-piya-jangka: mangulpa, kurlarda, junma, mayingka, kuruparlangu. ");
INSERT INTO wbp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","24","Ngula-jangkaju, Lamikiji wangkaja-palangu karnta nyanungu-nyangu-jarraku, “Yaata manu Jiila, purda-nyangkaju-pala yunparninja-kurra kajirna nyampu yunparni: Nyurru-wiyiji jintangku yapangku pinjarlaju yirrarnu kurdu-warnurlu. Ngulajurnajurla ngajulurluju kunka-manu. Tarnnga-kurrarna pungu kurdu-warnuju. Kajilpa nganangku-puka pungkarla Kayini, ngula-wanawana kajika Kaaturlu kunka-maninjarla murrumurru-mani wirlki-pala-mipaku. Kala ngajulu, kajilpaju nganangku-puka pungkarla, ngula-wanawana kajika Kaaturlu murrumurru-mani 77-palaku.” Kujanya-palangu yunparnu Lamikirli nyanungu-parnta-jarrakuju. ");
INSERT INTO wbp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Kujalpa-pala nyinaja Yatumu manu Yiipi, ngulakuju-palangu yarda palka-jarrija jinta-karilki kurdu-kari wirriya-yijala. Ngulaju Yiipirlijirla yirdi yirrarnu Jiiti Yiipiji wangkaja, “Kuja Kayinirli pakarnu kukurnu-nyanu Yapulu, ngula-jangkarlanya yunguju jinta-karilki wirriya-kari Kaaturluju.” ");
INSERT INTO wbp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Jiiti kuja wiri-jarrija, ngulangkulkunya manu karnta. Manu kurdulkurla palka-jarrija wita wirriya, ngulakujurla yirdiji yirrarnu Jiitirli Yinaji. Yalirlanya ngurrangkajulu rdirri-yungu jinta-jarrinjakuju yapaju. Jinta-jarrinjarlalu yalumpurla-juku rdirri-yungu YAAWIYI-ki yirdi-maninjaku manu pulka-pinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Nyampuju yimi-pardu-karilki Yatumu-kurlu-yijala manu nyanungu-nyangu-purnu-kurlu kuja nyanungurlu kurduwarr-kujurnu. Kaaturlu kuja-jana yapa ngurrju-manu, ngulajulu nyanungu-piya-juku. ");
INSERT INTO wbp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wati manu karnta-jana ngurrju-manu, ngulaju-jana pirrjirdi-maninjarla warrawarra-kangu, manu-jana yirdiji yungu ‘yapa’. ");
INSERT INTO wbp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Yatumu kuja nyinaja ngulaju yukuriki 130-palaku, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Jiiti. Ngulajulpa nyinaja nyanungu-piya-juku miparrpaju. ");
INSERT INTO wbp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ngula-jangkaju, kurdukurdu-karilki-jana Yatumurluju panu manu, ngulaju yarda nyinaja purlka-nyayirni 800-palaku yukuriki. ");
INSERT INTO wbp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ngula-jangka, yukuri-jangka 930-pala-jangka yawu-pardija. ");
INSERT INTO wbp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Yangka Jiiti, Yatumu-kurlangu ngalapi-nyanu, ngulaju nyinaja yukuriki 105-palaku. Ngula-jangka, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Yinaji. ");
INSERT INTO wbp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Jiitirliji, ngulaju yarda nyinaja purlka-nyayirni yukuriki 807-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ngula-jangkaju, yukuri-jangka 912-pala-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Yangka Yinaji, Jiiti-kirlangu ngalapi-nyanu, ngulaju nyinaja yukurikiji 90-palaku. Ngula-jangkaju, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Kinini. ");
INSERT INTO wbp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Yinajirli, ngulaju yarda nyinaja purlka-nyayirni yukuriki 815-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ngula-jangkaju, 905-pala-jangka yukuri-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Yangka Kinini, Yinaji-kirlangu ngalapi-nyanu, ngulaju nyinaja yukuriki 70-palaku. Ngula-jangka, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Mayalala. ");
INSERT INTO wbp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Kininirliji, ngulaju yarda nyinaja purlka-nyayirni yukuriki 840-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ngula-jangkaju, yukuri-jangka 910-pala-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Yangka Mayalala, Kinini-kirlangu ngalapi-nyanu, ngulaju nyinaja yukuriki 65-palaku. Ngula-jangkaju, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Yarrata. ");
INSERT INTO wbp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Mayalalarlu, ngulaju yarda nyinaja purlka-nyayirni yukuriki 830-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ngula-jangkaju, yukuri-jangka 895-pala-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yangka Yarrata, Mayalala-kurlangu ngalapi-nyanu, ngulaju nyinaja yukuriki 162-palaku. Ngula-jangkaju, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Yiniki. ");
INSERT INTO wbp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Yarratarlu, ngulaju yarda nyinaja purlka-nyayirni 800-palaku yukuriki. ");
INSERT INTO wbp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ngula-jangkaju, yukuri-jangka 962-pala-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Yangka Yiniki, Yarrata-kurlangu ngalapi-nyanu, ngulaju nyinaja 65-palaku yukuriki. Ngula-jangkaju, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Jujala. ");
INSERT INTO wbp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Yinikirliji, ngulakujurla Kaatuju wardinyi-jarrija-nyayirni manu ngampurrpa-jarrija. Ngulaju Kaatu manu Yiniki, wungulkulpa-pala nyinaja puntu-nyayirni yukurikiji 300-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Ngula-jangkaju, 365-pala-jangka yukuri-jangka Kaaturluju kangu wankaru-juku nguru-nyayirni-wangu-kurra nyanungu-nyangu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Yangka Jujala, Yiniki-kirlangu ngalapi-nyanu, ngulaju nyinaja yukuriki 187-palaku. Ngula-jangkaju, ngulakujurla kurdulku palka-jarrija wirriya yirdiji Lamiki. ");
INSERT INTO wbp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Jujalarluju, ngulaju yarda nyinaja purlka-nyayirni 782-palaku yukuriki. ");
INSERT INTO wbp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ngula-jangkaju, yukuri-jangka 969-pala-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Yangka Lamiki, Jujala-kurlangu ngalapi-nyanu, ngulaju nyinaja 182-palaku yukuriki. Ngula-jangkaju, ngulakujurla kurdulku palka-jarrija wirriya, ngulakujurla yirdiji yirrarnu Lamikirliji Nawa. Ngula-jangkaju, Lamikiji wangkaja, “YAAWIYI-rliji nyampuju walya manu nguru juyurdurlu yunparnu. Kujarlaju kulalparlipa nyarrparlulku miyiji wiri-mantarla nyampurlaju walya tarlangka. Jalangu-jarra ngulaju karlipa wakurturdu warrki-jarri miyiki maninjaku. Kala kaji Nawa wiri-jarri, ngulaju kapurlipa-nyanu rarralyparlulku wiri-mani mangarri. Ngula-purunya kapurlipa nyinami wardinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ngula-jangkaju, kurdukurdu-karilki-jana panu manu Lamikirliji, ngulaju yarda nyinaja purlka-nyayirni yukuriki 595-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ngula-jangkaju, yukuri-jangka 777-pala-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Yangka Nawa, Lamiki-kirlangu ngalapi-nyanu, ngulaju nyinaja yukuriki 500-palaku. Ngula-jangkaju, kurdu-patulkurla palka-jarrija wirriya-patu yirdi-patuju Jiimi, Yaamu, Japaji. ");
INSERT INTO wbp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ngula-puruju, yapa-paturlulu-jana kurduwarr-kujurnu. Panu-jarlu-nyayirnilpalu-jana mardukuja kurduwarr-kujurnu yuntardi-yuntardi. ");
INSERT INTO wbp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ngula-jangkaju, ngalya-kari Kaatu-kurlangu marramarra, ngulajulu majungka-jarrija. Nyangulu-jana karntakarnta yangka kujalpalu yuntardi nyinaja. Ngulalu-jana manu kali-nyanuku. ");
INSERT INTO wbp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","4","Ngula-jangkaju, kurdukurdu panu-jarlu-nyayirnili-jana kurduwarr-kujurnu. Kujalu kurdukurdu wiri-jarrija, ngulajulu nyinaja pirrjirdi-nyayirni. Ngulajulpalu nyinaja Nipili-patu turnu-warnu. Nyampurranya nyurru-warnu kuja karlipa-jana yirri-purami ngurujarraranypa. Ngati-nyanu ngulajulpalu nyinaja yapa-nyayirni. Kirda-nyanu ngulajulpalu nyinaja marramarra maju-nyayirni. Ngula-jangka, YAAWIYI-ji-nyanu wangkaja, “Nyampu yapa-kangukangu kuja kalu nyina ngurungka maju, kulalu nyina tarnnga marda 200-pala marda 300-pala yukuriki, lawa. Jalangu-jarra, kaji yapa ngana-puka nyinami 120-pala yukuriki, ngula-jangka kapu palimilki.” ");
INSERT INTO wbp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","YAAWIYI-rli yapaju kala-jana warrawarra-kangu kurturdurru maju-kurlu pirlirrpa maju-kurlu. Ngula-kurlurluju kalalu manngu-nyangu maju warntarla tarnngangku-juku. ");
INSERT INTO wbp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ngulakujulpa-jana YAAWIYI mari-jarrija miyalu kanunjumpajumpa, manu-nyanu wangkaja, “Nyiyakurna-jana yapaju ngurrju-manu, yungurna nyinayarla kuja-kujakuju ngurrju-maninja-wangu. Kajirna-jana yampiyarla ngurrju-maninja-wangurlu, ngulaju kapurna ngurrju-juku nyinayarla mari-wanguju. ");
INSERT INTO wbp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yapa yangka kujarna-jana nyurru-wiyi ngurrju-manu, ngulaju kapurna-jana muku pinyi. Manu jurlpu, puluku, manu kuja kalu nyiyarningkijarra warru wapa manu warru kiripi-kanyi, ngulaju kapurna-jana muku riwarri-mani. Kujarlaju karna-jana mari-jala nyina ngurrju-maninja-warnuku.” ");
INSERT INTO wbp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kala jinta nyinaja watiji yangka yirdiji Nawa. Ngula-mipakulparla YAAWIYI-ji yimiri nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nyampuju yimi-pardu-karilki, ngulaju Nawa-kurlu. Nawangku kala warrarda purda-nyanjarla langa-kurra-manu Kaatu, manu kala-pala wungu-juku nyinaja puntu-nyayirni. Nyanungu-puka jintalparla nyinaja jungarni Kaatukuju yapa ngalya-kari-piya-wangu. ");
INSERT INTO wbp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Yangka kujalpa-jana ngalapi-nyanu-patu mardarnu, ngulaju yirdi-patuju Jiimi, Yaamu, Japaji. ");
INSERT INTO wbp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ngalya-kari panu-kari ngulajulpalu maju-nyayirni nyinaja. Warrarda kalalu-nyanu kulungkuju pakarnu nguru-kari nguru-karirla. ");
INSERT INTO wbp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kaaturlu kujalpa-jana warrawarra-kangu, ngulajulpa-jana kulu-kurra-juku nyangu. Kujarrajulu maju-nyayirni. Milya-pungulpa-jana kurturdurru kuja kalalu-nyanu yapaju kulu-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kujarlaju, wangkajalkurla Nawakuju Kaatuju, “Warru nyangka-jana yapa nyampu warrukirdikirdi kuja kalu-nyanu warrarda pakarni kulungkuju. Ngula-panuju kapurna-jana muku pinyi ngapangku ngawarra-kurlurlu manu riwarri-mani muku. ");
INSERT INTO wbp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nyuntuju, ngula-kujakuju pawurturlu ngurrju ngantika wiri-nyayirni wita-wangu pirrjirdi-nyayirni rdalyku-kurlurlu panu-kurlurlu, manu yujuku-jana ngurrju-manta kaninjarniji wita-kari wita-kari ruumu-kari ruumu-karirla. Manu palya-piya-kurlurlu muku mapaka kaninjarni pawurturlaju manu kanunjumparra-warnu warrukirdikirdi ngapa-kujaku. ");
INSERT INTO wbp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ngulakuju wiri-nyayirni-jana kaji ngurrju-manta pawurtuju kirrirdi-nyayirni 150-pala mita, manu wantiki-nyayirni 25-pala mita, manu kankarlarra-nyayirni 15-pala mita. ");
INSERT INTO wbp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ngulangkaju kankarlarni yamalku parnta-yirraka manu rurrpa wantiki yampiya kankarlumparra warrukirdikirdi mayawunpaku. Kulkurru-jarra, yirraka-jana marnkurrpa ruumu-patu: kanunju-warnu ruumu-kari, kulkurru-warnu ruumu-kari, kankarlu-warnu ruumu-kari. Manu tuwa jinta wiri yirraka ramarrarlaju. ");
INSERT INTO wbp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Purda-nyangkaju, kari-nganta kapurna muku muru-pungu walyaju manu nyiyarningkijarra ngurujarraranypa kujarla yalarnirla ngawarra-kurlurluju. Nyiyarningkijarra kuja kalu warru wapa nyampurla walyangka, ngulaju kari-nganta ngawarra-kurlurlu kapurna-jana tarnnga-juku pinyi! ");
INSERT INTO wbp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Junga karnangku wangka: Nyuntu manu nyuntu-parnta manu nyuntu-nyangu-patu ngalapi-nyanu-patu marnkurrpa manu nyanungu-patuku kali-nyanu, ngulaju kapunkulu yukami pawurtu-kurraju ngawarra-kujaku. Kujarlunya karnangku punpun-ngarrirni muurlparlu mardarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Kuyu-kari kuyu-kariki manu jurlpu-kari jurlpu-kariki-jana nguru-yirraka pawurtu-kurraju jirrama-kariki manu jirrama-kariki wirriyaku mardukujaku. Jintawarlayikiji-jana nguru-yirraka yangka kuja kalu wankaru nyina walyangka manu yalkirirla. Ngulangkunya yungulu-nyanu wankarurluju nyanungu-piyarlu kurduwarr-kijirni ngakaju ngawarra-jangkarlaju. ");
INSERT INTO wbp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Miyilki-jana kaji-manta nyuntu-nyanguku manu kuyu-kari kuyu-kariki. Miyiji maninjarla wuruly-yirraka kaninjarni pawurturla, ngulanya yungunkulu ngarni miyiji ngawarra-puruju.” ");
INSERT INTO wbp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Junga-juku, Nawangkuju linpangku purda-nyangu Kaatuju. Ngula-jangkaju, rdurrjurnulkurla pawurtuku ngantirninjakuju. ");
INSERT INTO wbp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ngula-jangkaju, YAAWIYI-jirla wangkaja Nawakuju, “Nyuntu-miparlu kanpaju jungarnirli purami, manu kanpaju wala nyina. Kujarlaju, nyuntu-nyangu-purnu-kurlu yukayalku pawurtu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kuyu-kari kuyu-kariki 14-pala-kari 14-pala-kariki-jana nguru-yirraka pawurtu-kurraju, ngula kalu yangka ngurrju nyina kuyuju nyuntuku ngarninjaku, ngamaku wirlki-palaku, wirriyaku wirlki-palaku. Kala yangka punku-kangukangu ngarninjaku, ngulaju-jana nguru-yirraka jirrama-pukaku ngamaku jintaku, wirriyaku jintaku. ");
INSERT INTO wbp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Manu jurlpu-kari jurlpu-kariki 14-pala-kari 14-pala-kari-jana nguru-yirraka pawurtu-kurraju ngamaku wirlki-palaku, wirriyaku wirlki-palaku. Kuyu-kari kuyu-kari manu jurlpu-kari jurlpu-kari yangka kuja kanpa-jana nguru-yirrarni pawurtu-kurra, ngulaju yungulu-jana ngawarra wiri-jarlu-jangka ngakalku kurduwarr-kijirni ngurujarraranypa. ");
INSERT INTO wbp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ngulaju kapurna jinta-jangkarla wiyiki-jangkarlaju yilyamirni ngapa. Ngulaju kapu wantimi parrakuju manu mungakuju 40-palaku. Ngulaju ngawarra-kurlurlu kapurna muku muru-pinyi walya kujarla yalarnirla. Manu nyiyarningkijarra kuja kalu warru wapa wankaru nyampurla walyangka, ngularlanguju kapurna-jana muku pinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Junga-juku-jana YAAWIYI purda-nyanjarla nguru-yirrarnulku yapaku nyanungu-nyangu-purnuku manu nyiyarningkijarraku Nawangkuju pawurtu-kurraju. ");
INSERT INTO wbp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","16","Ngularla rdipija 600-pala yulyurrpu Nawakuju, kirntangi jirrama-jangka manu parra 16-pala-jangka, ngula-jangkaju ngapa wiri-jarlulku wantinjunurnu. Nyampu-patunya yirdi-patuju kujalu yukajalku pawurtu-kurraju: Nawa manu nyanunguku kali-nyanu, manu nyanungu-nyangu ngalapi-nyanu-patu yirdiji Jiimi, Yaamu, Japaji, manu nyanungu-parnta karnta-patu. Ngulaju yapaju 8-pala-mipa. Kujalu yukaja manu yangka kuyu-kari kuyu-kari jurlpu-kari jurlpu-kari, ngurrju manu ngawu, ngama manu wirriya, witawita manu wiriwiri, kulu-parnta manu pululu, kujalu nyanungurrarlangu yukaja, ngulakuju-jana YAAWIYI-rliji tuwaju wamany-kujurnu. Junga-juku, wiyiki jinta-jangka ngapaju pata-karrunjunurnu, wantija parra-patuku 40-palaku manu munga-kariki. Ngula-puru-yijala walya-jangka rawu-jangka kaninjarra-jangka ngukulkulpa purlpurl-pardija manu jintararra-rarra-pardija. Ngawarrarluju muku muru-pungu kujarla yalarnirla ngurujarraranypa. ");
INSERT INTO wbp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","23","Ngapaju warrarda wantija 40-palaku parrakuju, kujalpa kanunju-jangkaju kankarlu-jarrinja-yanu. Ngulaju junga-juku-jana yapa panuju muku muru-pungu. Kala yangka pawurtu kujalpa kankarlarra pirlingka karrija, ngulaju ngapangkuju ngawarrarluju puranjarla manurra warru. Kulalu pirli wakirdi nyarrpara-wanarlangu nyangkarla, lawa. Nyiyarningkijarra kujalpalu warru wapaja nyampurla walyangka manu ngaany-kujurnu, jurlpurlangu, manu wardapirlangu, manu pulukurlangu, manu nantuwurlangu, ngulaju YAAWIYI-rli ngawarra-kurlurlu muku-jana pungu. Kala Nawa manu nyanungu-nyangu-purnu, ngula-mipalu wankaruju yanu. ");
INSERT INTO wbp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ngawarrajulpa parnkaja ngurujarraranypa 150-pala parraku kanunju-jarrinja-wangu-juku. ");
INSERT INTO wbp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","3","Ngulaju Nawaju manu nyanungu-nyangu-purnu manu yangka kuyu-kari kuyu-kari, Kaaturlu-jana manngu-nyangu wajawaja-maninja-wangurlu kujalpalu yangka pawurturla-juku nyinaja. Ngulakuju mayawunpalku yilyajarni walyaku parduna-maninjaku, manu ngapa warla-pajurnu wantinja-kujaku manu yangka walya rawu-jangka purlpurl-pardinja-kujaku. Mayawunpajulpa parnkaja ngapangka kankarlumparra. Ngulangkujulpa ngapaju kanunju-maninja-yanu 150-pala parraku. ");
INSERT INTO wbp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yangkaju pawurtu ngulajulpa warru wapaja ngawarrarla wiringka-wiyi. Kala kuja ngapa kanunju-jarrinja-yanulku, yangkaju pawurtu warru yaninjarla pirli wararrarlalku rdarrparl-wantija yirdingkaju Yarrarratarla. ");
INSERT INTO wbp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ngakarrangakarra kirntangi-jarra-jangka, pirli wararraju wita-kari wita-karilki wakirdi-wiyi palka-jarrinja-yanu manu parduna-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nawajulpa pawurturla-juku nyinaja ngulaju 40-palaku parrakuju nyanja-wangu-juku. Ngula-jangkaju, rdilypirrpa wintawu-piyalku lakarn-pungu ramarrarla pawurturlaju. ");
INSERT INTO wbp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ngula ngurulku nyangu. Nyanjarla Nawangkuju kaarnkalku manu, manu yilyajalku kaarnkaju walyaku pardunaku yungulparla rdipiyarla. Ngulajurla warru paarr-pardinjarla nyangu lawa-juku. ");
INSERT INTO wbp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ngula-jangkaju, jinta-karilki yilyaja jurlpu-kari kurlukuku walyaku-yijala pardunaku warru nyanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ngulaju kurlukukuju warru paarr-pardija lawa-yijala. Kularla rdipija walyaku pardunakuju. Ngula pina-yanurnu pawurtu-kurraju. Ngulaju Nawangkuju nganjirni puuly-mardarnu kurlukukuju, ngula pina-kangu kaninjarni pawurtu-kurralku. Ngulaju Nawangkujulpa milya-pungu walyaju yakiri-jiki. ");
INSERT INTO wbp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ngula-jangkaju, yarda pina-yilyaja yangka-yijala jurlpu kurlukuku wiyiki-pardu-kari-jangka jinta-jangka. ");
INSERT INTO wbp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ngulaju jurlpuju pina-yanurnu palka-kurlulku jalyirrpa-kurlu lirrangka-kurlu pawurtu-kurraju. Ngulaju Nawangkuju milya-pungu walyaju palkalku pardunaju. ");
INSERT INTO wbp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Jinta-jangka wiyiki-pardu-kari-jangka, yangka-yijala jurlpu yarda pina-yilyaja Nawangkuju. Ngulaju jurlpuju tarnngalku-juku wuruly-yanurra. Kula pina-yanurnulku pawurtu-kurraju. ");
INSERT INTO wbp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Kuja ngawarra lawa-jarrijalku, Nawajulpa nyinaja-juku purlka-nyayirni 601-palaku-juku yukuriki. Ngula-puruju ngapaju marra-pardijalku. Kala walya ngulajulpa yakiri-jiki ngunaja. Yangka pawurturla kankarlumparra-warnu yama, ngulakujurla rdurrjurnu rurruny-pinjakulku. Ngula-jangkaju, ngurulkulpa nyangu pawurtu-ngurluju kujalpa walyaju parduna-jarrinja-yanulku. ");
INSERT INTO wbp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kirntangi-jarra-jangka jirrama-jangka, ngula-jangkaju, muku parduna-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Kaatujurla wangkaja Nawakuju, “Ngulakuju pawurtukuju jurntalkulurla wilypi-pardiya, nyuntulu manu nyuntu-parnta manu nyuntu-nyangu-purnu. ");
INSERT INTO wbp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nyiyarningkijarraku-jana nguru-yirraka yalumpu-ngurlu pawurtu-ngurlu yungulu pirri-yani kujarla yalarnirla ngurujarraranypa, manu yungulu kurdukurdulku kurduwarr-kijirni.” ");
INSERT INTO wbp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Junga-juku, Nawaju-jana jirrnganja wilypi-pardija nyanungu-nyangu-purnuku warlaljaku lakarn-pinjarla tuwa-wanaju. ");
INSERT INTO wbp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ngula-jangkaju, junga-juku, kuyu-kari kuyu-kari, jurlpu-kari jurlpu-kari manu nyiyarningkijarra, wilypi-pardinjarlalu turnu-kari turnu-kari yanu-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ngula-jangka, Nawangkuju warru manulpa yarturlu-kari yarturlu-kari, manu turnu-maninjarla-jana murnju-yirrarnu, ngulangkanya yungurla kuyu warntarri purranjarla yinyi YAAWIYI-ki. Ngula-jangkaju, Nawangkulpa-jana warru wapanjarla warru manu kuyu-kari kuyu-kari kirlka-mipa yangka kujalpalu kuyu ngurrju nyinaja ngarninjaku. Ngulangkaju yurturlurla kankarlarni, jinta-kari jinta-karilparla purraja wanapi-jiki YAAWIYI-kiji kuyu warntarri. Kujalpa Nawangkuju purraja kuyu-kari manu kuyu-kari warlungka, yangka warlu-jangkaju kunjuru ngurrju parntirrparntirrpa kankarlu-jarrinja-yanulparla yalkiri-kirra YAAWIYI-kilki. ");
INSERT INTO wbp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","22","YAAWIYI-rli kuja kunjuru parnti-nyangu, wardinyi-jarrija-jana yangka yapa-patuku. Ngula-jangkaju-nyanu wangkaja, “Ngurrju-nyayirni karna parnti-nyanyi kunjuru kuyu warntarri-jangka. Kujarlaju kularna walyaju juyurdurlu-yunparni, manu kularna-jana yapaju manu nyiyarningkijarra yardalku muru-pinyi ngawarra-kurlurlu. Nyampurranya karna-jana milya-pinyi yapa Nawa-kurlangu-mayamaya. Kajilpalu ngurujarraranypa kurduwarr-kijikarla, kajikalu marda majungka-jarrinjarla karlirr-yani maju-kurra-pinangu, manu kajikalu warrarda manngu-nyanyi maju-mipa wiriwirirli manu witawitarlangurlu. Ngulaju ngula-juku, kularna-jana yarda muru-pinyi ngawarra-kurlurlu. Jalangu-jangkaju, walyaju kapu-jana ngurrju karri yulyurrpu-kari yulyurrpu-kariki manu karapurda-kari karapurda-kariki tarnnga-juku nyanungu-patukuju. Ngula-puruju kapulu-nyanu ngurlu yirrarni walyangka warrarda miyiki wiri-maninjaku, kapulu-nyanu warrarda miyi warru maninjini walya-jangkaju.” ");
INSERT INTO wbp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ngula-jangkaju, Kaaturlu-jana pirrjirdi-maninjarla wangkaja Nawaku manu nyanungu-nyangu-purnuku, “Kurdukurdu panu-nyayirnijili marlaja kurduwarr-kijika! Ngula-jangkaju yungulu-jana ngurujarraranypa pirri-yaninjarla panu-yijala kurduwarr-kijirni nyanungurlulku nyurrurla-nyangu-purnurlu. ");
INSERT INTO wbp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Jurlpu-kari jurlpu-kari, yawu-kari yawu-kari, kuyu-kari kuyu-kari, ngulaju kapulu-nyarra nyurrurlakuju lani-jarrimi nyiyarningkijarra tarnnga-juku. Ngulakuju kapunkulu-jana wiri nyina nyurrurlaju. ");
INSERT INTO wbp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","“Nyurru-wiyilpankulu nyinaja kuyu ngarninja-wangu. Miyi-mipalpankulu ngarnu. Jalangu-jarra kapurna-nyarra yinyi kuyulku yungunkulu kuyu ngarni jurlpu, yawu, manu kuyu-kari kuyu-kari. ");
INSERT INTO wbp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ngulakungarntirliji, yampiyalu yalyu ngarninja-wangurlu kuyu-kari kuyu-kari-jangka pinja-warnu. Nyiyaku kuja kujaju? Yalyuju ngulaju wankaru, kulalpa nyiya wankaru nyinayarla yalyu-wanguju. Kujarlajulu ngarninja-wangurlu yampiya yalyuju. ");
INSERT INTO wbp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kuruwarri nyampuju ngaju-nyangu: Yampiyalu-nyanu tarnnga-kurra pakarninja-wangurlu. Kajinpa tarnnga-kurra pakarni jinta-kari, ngulaju ngaju kapurnarlajinta kunka-mani. Pulukurlangurlu kaji pinyi yapa tarnnga-kurra, ngulaju kapurnarlajinta kunka mani-yijala yapaku nyurnukuju. ");
INSERT INTO wbp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Nyurru-wiyirna-jana yapa ngurrju-manu, ngulaju ngaju-piya. Ngulakujulu-nyanu yampiya tarnnga-kurra pakarninja-wangurlu! Kajinpa pakarni tarnnga-kurra, ngulaju nyurnukuju kapulurlajinta kunka-mani tarnnga-kurra nyuntuju linjarrpa wita-wangu.” ");
INSERT INTO wbp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ngula-jangkaju, Kaatulku-jana yarda wangkaja Nawaku manu nyanungu-nyangu-purnuku, “Nawa, kurdukurdu panu-nyayirnijili kurduwarr-kijika yungulu-jana ngurujarraranypa pirri-yaninjarla panu-yijala kurduwarr-kijirni nyanungurlulku nyurrurla-nyangu-purnurlu. ");
INSERT INTO wbp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","17","Jalanguju karna-nyarra yimi-ngarrirni nyampu-kurluju pararri-kirli. Kularna riwarri-manilki ngawarra-kurlurluju nyampuju walya manu ngurujarraranypa kujarla yalarnirla, lawa. Kajirna nyanyi mangkurdu-wana yalkirirla ngapa-jangka, kapurna-nyarra manngu-nyanyi nyurrurla ngaju-nyangu-patu yapa, manu kapurna-jana manngu-nyanyi nyiyarningkijarra yangka kujalu wilypi-pardija pawurtu-ngurlu nyurrurla-kurluju. Kularna-nyarra wajawaja-mani nyurrurlaju, lawa. Pararri karna-nyarra milki-yirrarni nyurrurlaku jintawarlayiki-juku, kujankulu wilypi-pardija pawurtu-jangka, manu nyiyarningkijarraku manu kujarla yalarnirlaku ngurujarraranypaku. Ngulaju yungunkujulu marlaja nyanyi kajinkili pararriji nyanyi, ngulaju ngula-jukurna-nyarra wangkaja.” ");
INSERT INTO wbp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nyampu-patu yirdi ngalapi-nyanujulurla Nawakuju: Jiimi, Yaamu, manu Japaji. (Yaamuku ngulakujurla ngalapi-nyanu wirriya palka-jarrija yirdiji Kanana.) ");
INSERT INTO wbp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nyampu-patu-kurlangu kurdukurdu ngulalu palka-jarrija, ngulalu-jana kurduwarr-kujurnu jaya-kurra-nyayirnilki ngurujarraranypa nguru-kari nguru-karirla. ");
INSERT INTO wbp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ngula-jangkaju kamparruju, Nawangkuju-nyanurla yarlu-pungu walyaju kaatiniki yungu-nyanu ngulangkaju yirrarni marnikiji-piya. Ngula-jangkanya yungu pamalku ngurrju-mani. Ngula-jangkaju, julkulku ngurrju-manu nyurlanjarla. Ngula-kurlurluju pamalku ngurrju-manu. ");
INSERT INTO wbp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ngula-jangka, julku-jangkarluju pamalku Nawangkuju ngarnu. Ngarninjarla warungka-jarrija. Warungka-jarrinjarla, palkangkalku-nyanu jurnarrpa rurruny-pungu, ngulalpa jurnarrpa-wangulpa jalyalku ngunaja kalukurla. ");
INSERT INTO wbp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Nyanungu-nyangu ngalapi-nyanu Yaamu, yanurnurla kirda-nyanuku kaluku-kurra. Yukajarni kalukurla, ngula parlu-pungu kirda-nyanuju jalyalku, ngulalpa karrinjarla lirlki-nyangu. Lirlki-nyanjarla pina-yanu yurlapardi-kirra. Manu-palangu yanu nyanungukupurdangka-jarraku jirrama-kariki. Ngula-palangu yimi-ngarrurnu jirrama-karikiji. ");
INSERT INTO wbp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Purda-nyanjarla manulku-palarla wawarda jirrama-karirliji parnta-yirrarninjakungarntirli. Ngula-jangkaju, wawarda-kurlurluju parnta-yirrarnu-pala-nyanu purdangirli jimanta-wana. Ngula-palarla kunamurrumurru-juku yanu kirda-nyanukuju, wawarda-palarla parnta-yirrarnu nyanja-wangurlu-juku. Kula-pala kirda-nyanuju nyangkarla jalyaju. ");
INSERT INTO wbp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nyanungujulpa Nawaju jarda-juku waparlku ngunaja. Ngula-jangkaju, yakarra-pardija langarrpalku warungka-wangu-juku. Nyarrparlu mayi milya-pungu ngalapi-nyanuju Yaamuju kujalpa jalya lirlki-nyangu kurnta-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ngulakujurla kulu-jarrija Nawaju yangkakuju Kananaku ngalapi-nyanuku Yaamu-kurlanguku. Yaninjarla juyurdurlu-yunparnu Kanana, manurla wangkaja, “Nyuntu kapurnangku juyurdurlu-yunparni. Nyuntukupurdangka-patuju kapungkulu kamparru-juku nyina wiri-jiki nyuntukuju tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","YAAWIYI, ngulaju Wiri-nyayirni! Ngulakuju pangkalarla Jiimiji marlaja nyina Kaatuku wardinyi-nyayirni tarnnga-juku! Jiimilki ngulaju pangkalangku wiri-yijala nyina nyuntukuju. ");
INSERT INTO wbp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Pangkalarla Japajikiji Kaaturlu yinyi walya wiri-nyayirni. Ngulajulu pangkala nyina Jiimi-kirlangurla jintawarlayi-jiki Jiimi-kirlangu-mayamaya manu Japaji-kirlangu-mayamaya. Pangkalangkulu wiri-jiki-yijala nyinami nyuntuku Kananakuju. Nyampunya ngula-jukurnangku wangkaja.” ");
INSERT INTO wbp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","29","Ngula-jangkaju, Nawaju yarda purlka-nyayirni nyinaja yukurikiji 350-palakuju yangka-jangka ngawarra wiri-jangka. Yukuri-jangka 950-pala-jangka yawu-pardijalku Nawaju. ");
INSERT INTO wbp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nyampunya Nawa-kurlu manu nyanungu-nyangu-patu-kurlu ngalapi-nyanu-kurlu yangka Jiimi-kirli manu Yaamu-kurlu manu Japaji-kirli. Yangka-jangka ngawarra wiri-nyayirni-jangka, nyampurra-patukujulu-jana kurdu panu-nyayirni palka-jarrija wirriyawirriyaju. ");
INSERT INTO wbp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Nyampurranya Japaji-kirlangu-patu ngalapi-nyanu-patuju yirdi-patuju: Kuuma, Makaku, Mardayi, Japana, Tupulu, Mijiki manu Tiraji. ");
INSERT INTO wbp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Nyampurranya Kuuma-kurlangu-patu ngalapi-nyanu-patuju yirdi-patuju: Yajikani, Ripiraji manu Tukurrma. ");
INSERT INTO wbp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Nyampurranya Japana-kurlangu-patu ngalapi-nyanu-patuju yirdi-patuju: Layiju, Tarrjiji Kitimi manu Rurdani. ");
INSERT INTO wbp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yapa kuja kalalu nyinanja-yanu warru mangkuru wiri-nyayirni-wana Mirditirinu-wana, ngulajulu muku palka-jarrija yangka Japana-kurlangu-jangka ngalapi-nyanu-warnu. Ngulajulu panu-jarrija yapaju. Jarnkujarnku nyinaja warru kalalu nguru-kari nguru-karirla, manu kalalu jarnkujarnku wangkaja jaru-kari jaru-kari nyanungurra-nyanguju. ");
INSERT INTO wbp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Nyampurranya Yaamu-kurlangu-patu ngalapi-nyanu-patu yirdi-patuju: Kuuju, Mijirami, Puurtu manu Kanana. ");
INSERT INTO wbp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Nyampurranya Kuuju-kurlangu-patu ngalapi-nyanu-patu yirdi-patuju: Jipa, Yapila, Japatayu, Raama manu Japatika. Nyampurranya Raama-kurlangu-patu ngalapi-nyanu-patu yirdi-patuju: Jiipa manu Tirtanu. ");
INSERT INTO wbp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Yangkaku yirdiki Kuujuku, ngulakujurla kaja-nyanu nyinaja yirdiji Nimurdu. Nimurdu, ngulaju kala nyinaja pirrjirdi-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kala nyinaja kuyu-pungu-nyayirni YAAWIYI-kirlangu. Kujarlanya kalalu yapa wangkaja yapa ngalya-kari-kirli, ngulaju kuja, “Yalumpu yapa, ngulaju kuyu-pungu-nyayirni Nimurdu-piya YAAWIYI-kirlangu.” ");
INSERT INTO wbp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ngulaju ngula-juku. Yali Nimurdu kala-jana wiri nyinaja yapa panukuju. Kamparru-wiyi kala-jana wiri nyinaja ngurrararla Papilunurla kuja kalalu yapaju nyinaja kirri-paturlaju yirdi-paturlaju Papulu, Yirikarla manu Yakada. ");
INSERT INTO wbp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Ngula-jangkaju, Nimurduju yanu ngurrara-kari-kirra yirdi-kirraju Yajiriya-kurra. Ngulangkalpa-jana kirri-patu wiri-patuju ngurrju-manu yirdi-patuju Ninupu, Riyupuju-Yiri, Kaala manu Rijini. Rijini, ngulaju kirri wita-wangu-nyayirni kulkurrirni kirri-jarrarlaju yirdi-jarrarlaju Ninupurla manu Kaalarla. ");
INSERT INTO wbp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Yalumpu Mijirami, ngulaju kala-jana nyinaja warringiyi-nyanu panu-karirlanguku Luurdu-mayamayaku, Yanama-mayamayaku, Liyapa-mayamayaku, Napurtu-mayamayaku, Patiri-mayamayaku, Kajala-mayamayaku, manu yangka kuja kalalu nyinaja nguru-karirla yirdi-karirla Kiritirla. (Kuja kalalu nyinaja yapa nguru-karirla yirdi-karirla Pilijiyarla, ngulajulurla nyinaja warlalja warringiyi-nyanuku yalumpuku Kajalaku.) ");
INSERT INTO wbp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Yangka Kanana, ngulakuju-palarla kirda-nyanuku nyinaja wirriya-jarraju: Kampurru-warnu wirriya yirdiji Jirdana, manu purdangirli-warnu wirriya yirdiji Yiiji. ");
INSERT INTO wbp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","Kananaju kala-jana nyinaja warringiyi-nyanuju panu-karirlanguku yapakuju, ngularrajulu yirdiji: Jiipu-mayamaya, Yamuri-mayamaya, Kirrkaji-mayamaya, Yiipi-mayamaya, Yarrka-mayamaya, Jini-mayamaya, Yarrparda-mayamaya, Jimarra-mayamaya manu Yamaja-mayamaya. Nyampurranya Kanana-kurlangu-mayamaya warlaljaju. Ngakarralku ngulajulu muku pirri-maturnu nguru-kari nguru-kari-kirra ngulaju kirri-ngirli yirdi-ngirliji Jirdana-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Panu-karijili yanu kurlirra kirri-kirra yirdi-kirraju Karara-kurra, ngulajulpa karrija ngurrararla yirdingkaju Kaajarla. Ngula-jangkajulu kakarrara-jarrinja-yanu ngurrara-kari-kirra yirdi-kirraju Laaja-kurra, ngulangkajulpalu nyinaja kirri-paturlaju yirdi-paturlaju Jatamarla, Kumarrarla, Yardamarla manu Jipuyirla. ");
INSERT INTO wbp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nyampurrajulu yapa panuju palka-jarrija Yaamu-ngurlu yangka-ngurlu Nawa-kurlangu ngalapi-nyanu-ngurluju. Ngulaju kalalu wangkaja jaru-kari jaru-kari nyanungurra-nyanguju, manu kalalu nyinanja-yanu ngurrara-kari ngurrara-karirla nyanungurra-nyangurlaju. ");
INSERT INTO wbp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jiimi, yangka Japajikipurdangka papardi-nyanu, ngulakujulurla palka-jarrija wirriyawirriya. Jinta-kari warringiyi-nyanuju, ngulajulpa-jana warringiyi-nyanu-yijala nyinaja yapa panukuju yangka kuja kalalu-nyanu yirdi-pajurnu ‘yapa Yiipu-kurlangu’. ");
INSERT INTO wbp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Nyampurranya Jiimi-kirlangu-patu ngalapi-nyanu-patuju yirdi-patuju: Yilimi, Yajurru, Yarrpakaja, Luurdu manu Yarrama. ");
INSERT INTO wbp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Nyampurranya Yarrama-kurlangu-patu ngalapi-nyanu-patuju yirdi-patuju: Yuuju, Yuulu, Kiiju manu Mijiki. ");
INSERT INTO wbp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Yangka Yarrpakaja, ngulajurla kirda-nyanuju Jaalayaku. Jaalaya ngulajurla kirda-nyanuju Yiipuku. ");
INSERT INTO wbp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Yiipu ngulaju-palangu kirda-nyanuju wirriya-jarraku yirdi-jarrakuju Pilikiki manu Jakurturnuku. Kuja wiri-jarrija Pilikiji, ngula-puruju-jana Kaaturlu yapa muku yilyaja nguru-kari nguru-kari-kirra yungulu wangkami jaru-kari jaru-kari ngurujarraranyparlalku. ");
INSERT INTO wbp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Yangka Jakurturnuju, ngulajulpa-jana kirda-nyanu nyinaja wirriyawirriyaku yirdi-patukuju Yalmurda, Julupuku, Yamapitiki, Jiiraku, Yardumuku, Yuujuluku, Tikilaku, Yupala, Pimuluku, Jiipaku, Yupiriki, Yapilaku manu Juupupuku: Nyampurranyalu nyinaja jintawarlayiji yapa Jakurturnu-kurlangu warlaljaju. ");
INSERT INTO wbp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ngulaju kalalu nyinanja-yanu pamarrparla kakarrumparra-warnu kulkurrirni yirdi-jarrarlaju Miijirla manu Jipararla. ");
INSERT INTO wbp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nyampurralu Jiimi-kirlangu-mayamaya ngulaju yangka kuja kalalu wangkaja jaru-kari jaru-kari manu kuja kalalu nyinanja-yanu ngurrara-kari ngurrara-karirla nyanungurra-nyangurlaju. ");
INSERT INTO wbp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nyampurralu yapaju ngulaju Nawa-kurlangu-patu-jangka ngalapi-nyanu-patu-jangka yangka kuja kalalu nyinanja-yanu ngurrara-kari ngurrara-karirla. Nyampurra-jangkanyalu yapa-kari yapa-kari pirri-maturnu ngurujarraranypa yali-jangka ngawarra wita-wangu-jangkaju. ");
INSERT INTO wbp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ngawarra-jangka yangka wiri-jangka, ngulaju kalalu jinta-wiyi-jiki jaruju wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kujalu kakarrara-purdalku yanu nguru-kurra yirdi-kirraju Papiluniya-kurra, ngulangkanyalpalu nyinaja jintawarlayi-jiki manangkarrarla pirli-wangurla. ");
INSERT INTO wbp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wangkajalkulu-nyanu nyanungu-patu yuwarli-kari yuwarli-kariki ngantirninja-ngarnti. Ngulajulu-jana ngurrju-manu pirikiji-kirlirli kujalu ngurrju-manu pirikiji pirrjirdi walya-jangka manu palya-piya-jangka. ");
INSERT INTO wbp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ngula-jangkaju, wangkajalu-nyanu, “Yirrarnirlipa kirri wiri-nyayirni nyampurla-juku, manu jinta-karirlipa ngantirni yuwarliji kirrirdi-nyayirni kankarlumpayi yungu paarl-mardarni kankarlarra yalkiri. Kajili-ngalpa yapa-karirli nyanyi, ngulaju kapulu-ngalpa rdirrinypa-pajirni. Kula-ngalpa nganangku nyampu-ngurluju yilyami.” ");
INSERT INTO wbp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Junga-juku, rdirri-yungulurla yuwarli kirrirdiki ngantirninjakuju manu kirri wiriki yirrarninjaku. Ngula-kurraju YAAWIYI-rliji, ngulajulpa-jana warrawarra-kangu ngantirninja-kurraju. ");
INSERT INTO wbp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ngula-jangkaju, YAAWIYI-ji wangkajalku-nyanu, “Nyampurra-patu, ngula kalu nyina jintangka, ngulaju kalu jinta-juku jaru wangka. Nyampuju kalu-nyanu nyanungurlu-puka ngantirni kirriji manu yuwarli kirrirdiji kuja kalu-nyanu nyanungu-juku wala nyina ngaju-kurra-wangu. Jalangu-jarrarlu kulalpa-jana nganangku-puka warla-pajikarla, kalakalu maju-juku kanyi wiljingki-juku tarnngangku. ");
INSERT INTO wbp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kuja-kujakuju, kanunju-jarrinjarla yinyilkirlipa-jana jaru-kari jaru-kari yungulu-nyanu ngulaju jarnkujarnku kanginy-pinyi ngurrpangkulku jaru-kari jaru-kari.” ");
INSERT INTO wbp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Junga-juku, jaru-kari jaru-kari-jana yungu nyanungurlu YAAWIYI-rli. Ngula-jangkaju, kulalpalu-nyanu milya-pungulku jaru-kari jaru-kari wangkanja-kurra. Ngulajulpalu-nyanu kanginy-pungulku. Kujalpalu-nyanu kanginy-pungu jarnkujarnku jaru, lawa-jarrijalu yuwarli kirrirdimpayiki ngantirninjaku, manulurla marlaja pirripirri-maturnu nguru-kari nguru-kari-kirra YAAWIYI-kiji. Kujarlunya-jana YAAWIYI-rli warla-pajurnu yuwarli-kijaku kirrirdi ngantirninja-kujaku. Ngulajulu kirriji ngarrurnu ‘Papulu’, ngulaju nyampuju yirdiji, ‘Warungka-manu-ngalpa Purda-nyanja-wangu’. ");
INSERT INTO wbp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","11","Nyampuju yimi Jiimi-kirli Nawa-kurlangu-kurlu ngalapi-nyanu-kurlu manu nyanungu-nyangu-purnu-kurlu. Ngawarra wiri-jangka yukuri-jarra-jangkarla, kujalpa nyinaja 100-palaku yukuriki, Jiimikijirla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Yarrpakuju. Manu panu-karilki kurdukurdu yardalurla palka-jarrija. Ngularla palka-jarrija yangka Yarrpakuju, ngula-jangkarlaju Jiimijilpa wankaru-juku nyinaja yarda 500-palakuju yukurikiji purlka-nyayirni. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","13","Yangka Yarrpakuju ngalapi-nyanu Jiimiki, kujalpa nyinaja 35-pala yukuriki, ngulakujurla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Jaala. Manu panu-karilki kurdukurdu yardalurla palka-jarrija Yarrpakujuku. Ngularla palka-jarrija yangka Jaala, ngula-jangkarlaju Yarrpakujujulpa wankaru-juku nyinaja yarda 403-palakuju yukuriki purlka-nyayirni-yijala. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","15","Yangka Jaala ngalapi-nyanu Yarrpakujuku, kujalpa nyinaja 30-pala yukuriki, ngulakujurla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Yiipu. Manu panu-karilki kurdukurdu yardalurla palka-jarrija Jaalaku. Ngularla palka-jarrija yangka Yiipu, ngula-jangkarlaju Jaalajulpa wankaru-juku nyinaja yarda 403-palakuju yukurikiji purlka-nyayirni-yijala. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","17","Yangka Yiipu ngalapi-nyanu Jaalaku, kujalpa nyinaja 34-pala yukuriki, ngulakujurla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Piliki. Manu panu-karilki kurdukurdu yardalurla palka-jarrija Yiipuku. Ngularla palka-jarrija yangka Piliki, ngula-jangkarlaju Yiipujulpa wankaru-juku nyinaja yarda 430-palakuju yukurikiji purlka-nyayirni-yijala. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","19","Yangka Piliki ngalapi-nyanu Yiipuku, kujalpa nyinaja 30-pala yukuriki, ngulakujurla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Ruu. Manu panu-karilki kurdukurdu yardalurla palka-jarrija Pilikiki. Ngularla palka-jarrija yangka Ruu, ngula-jangkarlaju Pilikijilpa wankaru-juku nyinaja yarda 209-palakuju yukurikiji purlka-nyayirni-yijala. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","21","Yangka Ruu ngalapi-nyanu Pilikiki, kujalpa nyinaja 32-pala yukuriki, ngulakujurla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Jirruku. Manu panu-karilki kurdukurdu yardalurla palka-jarrija Ruuku. Ngularla palka-jarrija yangka Jirrukuju, ngula-jangkarlaju Ruujulpa wankaru-juku nyinaja yarda 207-palaku yukurikiji purlka-nyayirni-yijala. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","23","Yangka Jirruku ngalapi-nyanu Ruuku, kujalpa nyinaja 30-pala yukuriki, ngulakujurla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Nayuru. Manu panu-karilki kurdukurdu yardalurla palka-jarrija Jirrukuku. Ngularla palka-jarrija yangka Nayuruju, ngula-jangkarlaju Jirrukujulpa wankaru-juku nyinaja yarda 200-palakuju yukurikiji purlka-nyayirni-yijala. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","25","Yangka Nayuru ngalapi-nyanu Jirrukuku, kujalpa nyinaja 29-pala yukuriki, ngulakujurla kurdu jinta-wiyi palka-jarrija wirriya yirdiji Tiira. Manu panu-karilki kurdukurdu yardalurla palka-jarrija Nayuruku. Ngularla palka-jarrija yangka Tiiraju, ngula-jangkarla Nayurujulpa wankaru-juku nyinaja yarda 119-palakuju yukurikiji purlka-nyayirni-yijala. Ngula-jangka yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Yangka Tiira ngalapi-nyanu Nayuruku, kujalpa 70-palaku yukuriki nyinaja jarlu-pardu, ngulaju-jana marnkurrpa mardarnu wirriya-patu yirdi-patuju kamparru-warnuju Yipurumu, kulkurru-pajaju Nayuru, purdangirli-warnuju Yarrana. ");
INSERT INTO wbp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","29","Nyampunya yimi Tiira-kurlangu manu nyanungu-nyangu-purnu-kurlu. Ngulajulpalu nyinaja yangkangka-juku ngurungka Papiluniyarla kirringka yirdingkaju Yuurrungka. Yangka Yarrana ngalapi-nyanu Tiira-kurlangu, ngulakujulurla palka-jarrija marnkurrpa kurdu-patu: Kamparru-warnuju yirdiji wirriya Laati, kulkurru-pajaju ngulaju ngama yirdiji Milkaya, purdangirli-warnuju yirdiji Yijika. Ngula-jangkaju, Yarranaju yawu-pardijalku. Kala nyanungukupalangu Tiira, ngulajulpa wankaru-juku nyinaja. Tiira-kurlangu-yijala ngalapi-nyanu kulkurru-paja yirdiji Nayuru, ngulangkuju karnta kangu nyanungukupurdangka-kurlangu Yarrana-kurlangu yurntalu-nyanu yangkaju Milkayaju, ngulaju kangu karnta nyanungukulku. Tiira-kurlangu-yijala ngalapi-nyanu kamparru-warnu yirdiji Yipurumu, ngulangkuju manu karnta-yijala nyanungu-parnta yirdiji Jaarayi. ");
INSERT INTO wbp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Kularla palka-jarriyarla kurdu Jaarayikiji nyarrparla mayi. ");
INSERT INTO wbp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","32","Ngula-jangkaju, ngakalku-yijala Tiiraju jirrnganja-jana yarnkajalku Kanana-kurra, kangu-jana yapaju nyanungu-nyangu warlalja. Ngulaju-jana nguru-yirrarnu yatijarra karlarra, Yipurumuku manu Yipurumuku kali-nyanuku Jaarayiki, manu nyanunguku warringiyi-nyanuku Laatiki. Kirri-ngirliji Yuurru-ngurlu-jana kangu wurnturu kirri-kari-kirra-wiyi yirdi-kirra Yarrana-kurra. Ngulangkalkulpalu nyinaja tarnnga. Ngula-jangkaju, kujalpa Tiiraju nyinaja 205-palakuju yukurikiji, yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ngula-jangkaju, ngaka-pardu-karilki, YAAWIYI-ji wangkajarla Yipurumukuju, “Nguru nyampu, ngulaju yampinja-yantalku manu nyuntukupalangu manu nyuntu-nyangu-purnurlangu. Kapurnangku ngajulurlu-juku nguru-yirrarni nguru-kari-kirralku jinta-kari-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Kapunpa-jana nyuntuju wiri-jiki nyina yapakuju jaya-kurraku nyuntu-nyanguku kujarla yalarnirlaku. Kapurnangku yirdiji nyuntuju wiri-pajirni. Kapurnangku pirrjirdi-maninjarla warrawarra-kanyi. Ngulakuju yapa-patu-kari kapungkulu wardinyi-yijala manu ngampurrpa marlaja nyina nyuntukuju. ");
INSERT INTO wbp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","“Kajingkili yapa nyinami nyuntuku wardinyi, ngulaju ngula-juku. Ngulakuju kapurna-jana ngajuju pirrjirdi-maninjarla warrawarra-kanyi. Kala kajingkili karla-karri maju manu juyurdurlu-yunparni, ngulaju kapurnangkurla juyurdurlu-yunparninjarla kunka-mani-yijala. Kuja kanpaju nyuntu wala-juku nyina ngajuku, kujarlaju yapa-kari yapa-kari kapungkulu marlaja nyina wardinyi nyuntuku kujarla yalarnirla ngurujarraranypa.” ");
INSERT INTO wbp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Junga-juku, YAAWIYI purda-nyangu linpangku Yipurumurluju. Yangka-ngurlu Yarrana-ngurlu jirrnganja-jana yarnkaja Yipurumuju nyanungu-parntaku Jaarayiki manu nyanungukupurdangka-kurlanguku ngalapi-nyanuku Laatiki manu warrkini-patuku nyanungu-nyanguku kujalpalurla warrki-jarrija, manu nyiyarningkijarraku kawartawaraku manu narnukutuku manu pulukuku manu tangkiyiki manu jurnarrpaku, ngulaju-nyanu muku kangu nyanunguku nguru-kari-kirralku yirdi-kirraju Kanana-kurra. Kuja yarnkajalku Yarrana-ngurlu Yipurumuju, ngulaju jarlu-pardu-nyayirnilki nyinaja 75-palaku yukurikilki. ");
INSERT INTO wbp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ngula yukajarra nguru-kurra Kanana-kurra, ngulangkajulpalu jaya-kurra-nyayirni yapaju nyinaja Kanana-wardingki-patuju. Ngula-jangkaju, jingijingi-jana jirrnganja yanu Kanana-wana jinta-kari-kirra kirri-kari-kirra yirdi-kirraju Jikimi-kirra Muuri-kirlangu-kurra maralypi-kirra. Ngulangkajulpa watiya-nyayirni-wangu jinta karrija tarruku nganta. Yalumpurla-juku Yipurumuju jupu-karrija. ");
INSERT INTO wbp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ngula-jangkaju, YAAWIYI-rliji-nyanu milki-yirrarnu Yipurumu-kurra, wangkajalkurla Yipurumukuju, “Nyampu nguru, yinyi kapurna-nyarra nyuntuku manu nyuntu-nyangu-purnuku kurdukurduku.” Ngula-jangkaju, Yipurumurluju yarturlulku-jana turnu-maninjarla yurturlurla murnju-yirrarnu YAAWIYI-ki pulka-pinjakungarntirli manu kuyu warntarri purranjakungarntirli. ");
INSERT INTO wbp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ngula-jangka, Jikimi-jangkaju yarda-jana jirrnganja yarnkaja, ngulaju kurlirralku pirli-kari pirli-kari-wana yaninja-yanu. Ngulaju ngurraju yirrarnu kulkurru mardangka kirri-jarrarla kulkurru. Jinta-kari kirri yirdiji Yayi kakarrara, jinta-kari kirri yirdiji Pijili karlarra. Ngulangkaju jinta-karilki yurturlurla murnju-yirrarnu yarturluju YAAWIYI-ki yati-wangkanjaku, manurla kuyu warntarri purraja nyanunguku. ");
INSERT INTO wbp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ngula-jangkaju, jirrnganja yarnkaja-jana yarda, kurlirra-jana kanja-yanu, ngula-jana yarda jirrnganja ngunanja-yanu kurlirra-juku jilja-kurra yirdi-kirra Nikipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ngulangka Nikipirla nyinajarra lirrjirdi-nyayirnirla ngurungkaju. Ngakarrangakarralku ngapa-wangulku manu miyi-wangulkulpalu nyinaja yapaju. Yarnunjukulpalu nyinaja miyi-wangu. Ngula-jangkaju, Yipurumuju yarda-jana nguru-yirrarnu karlarralku nguru-kurra Yijipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","12","Kujalu yanurnu nguru-kurra Yijipi-kirra, ngulangkajurla Yipurumuju lanilki wangkaja karnta kali-nyanuku nyanungu-parntaku, “Kari-nganta nyuntuju yuntardi-nyayirni. Kajingkili Yijipi-wardingkirli nyanyi nyuntulu, ngulaju kapujulu ngurru-nyanjarla pakarni ngaju ngaju-parnta-ngurlu, manu kapujulu jurnta kanyi nyuntuju. ");
INSERT INTO wbp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ngula-kujaku, nyuntuju wangkaya-jana ngajukupurdangkanpa ngawurru-nyanu nganta. Kajinpa-jana kuja wangka, ngulaju kapujulu yampimi. Kulajulu pakarni.” ");
INSERT INTO wbp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Junga-juku, kujalu yukajarni Yijipi-kirra, Jaarayilkili nyangu yuntardi-nyayirni Yijipi-wardingkirli. ");
INSERT INTO wbp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kujalpalurla kingiki warrkini-patu warrki-jarrija, ngularlangurlujulu Jaarayiji nyangu yuntardi-nyayirni. Ngula-jangkaju, kingikilkilirla yimi-ngarrurnu yuntardi-nyayirni karnta. Jungajukulu karntaju manunjunu. Kangurnulu kingi-kirlangu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Junga-juku, kingijilparla ngurrju-nyayirni nyinaja Yipurumukuju, manulparla warntarri yungu panu-jarlu-nyayirni: puluku, kawartawara, tangkiyi manu yapa-patu warrkini wati manu karnta kujalpalurla jamulu warrki-jarrija pirijina-piya Yipurumukuju miyi-mipaku. Kujarlaju nyanungujulpa Yipurumuju nyinaja ngampurrpa-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","YAAWIYI-ji wardinyi-wangulpa nyinaja kingikiji kujarla Jaarayi puntarnu Yipurumukuju. Ngula-jana YAAWIYI-rli nyurnuku ngurrju-manu yalumpu kingi manu nyanungu-nyangu yapa yangka kujalpalurla jirrnganja nyinaja yuwarli nyanungu-nyangurla. ");
INSERT INTO wbp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Junga-juku, kingirlijirla jarulku yilyaja, wangkajarla nyanungu-nyanguku warrkiniki yajarninjaku Yipurumuku. Junga-juku, Yipurumuju yanurnu kingi-kirlangu-kurra yuwarli-kirra. Ngulangkajurla wangkajalku kingiji, “Nyarrparlanpaju warlkangku yimirr-yungu kujanpa Jaarayi ngarrurnu nyuntukupurdangkalku ngawurru-nyanu nganta? Nyuntu-nyangu-jala karnta yalumpuju! Pina-kangka nyanungu! Manu pardiyarra nyampu-ngurluju nguru-ngurlu!” ");
INSERT INTO wbp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ngula-jangkaju, wangkaja-jana kingiji nyanungu-nyanguku warrmarlaku, “Purayalu-jana yungunkulu-jana yilyamirra kulkurru-ngurlu.” Junga-juku, Yipurumurluju yampinja-yanu nguruju, kangu-jana nyanungu-nyangu yapa, nyanungu-nyangu nyiyarningkijarra. ");
INSERT INTO wbp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Yijipi-jangkaju, Yipurumu pina jirrnganja yanu-jana kakarrara yatijarra nguru-kurra yangka Nikipi-kirra jilja-kurra. Ngulajulpa mardarnu nyiyarningkijarra jaya-kurra-nyayirni tala, puluku, kawartawara, jurnarrpa. Panu-kari warlalja yangka nyanungukupurdangka ngalapi-nyanu Laati-kirlangurlangu, yanurralu jintangka-juku Nikipi-kirra-yijala. Ngula-kurranyalu muku yukajarra Yipurumu-kurlangu, Laati-kirlangu. ");
INSERT INTO wbp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Ngula-ngurluju, yardalu yarnkaja yatijarralku. Ngurra-kari ngurra-kari ngunanja-yanulu. Yangka-kurra-yijalalu pina-yanurnu kamparru-warnu-kurra yangka kirri-jarra-kurra-yijala kulkurru-kurra Pijili-kirra manu Yayi-kirra kuja yangka kamparru-wiyi ngunaja Yipurumuju manu yangka kuja-jana yarturlu murnju-yirrarnu YAAWIYI-kirlangu pulka-pinja-kurlangu maralypi yarturlu yurrujurla. Yalumpurla-juku YAAWIYI wiri-pajurnu Wiri-nyayirni Yipurumurlu. ");
INSERT INTO wbp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Yipurumukupurdangka-kurlangu ngalapi-nyanurlu yirdingki Laatirli, ngulajulpa-nyanu jaya-kurra-yijala mardarnu nyiyarningkijarraju puluku manu jiyipi manu kaluku. Ngulajulpa-pala-nyanu jarnku-mardarnu panu-mirnimirni. ");
INSERT INTO wbp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","(Yalumpurla ngurungka, ngulajulpalu kamparru-juku nyinaja yalumpu-wardingki-juku Kanana-wardingki-patu-juku, manu ngalya-kari yapa turnu-warnu-yijala yirdiji Piriji-patu, ngulajulpalu yalumpurla-yijala ngurungka warru nyinaja.) Marna yukuri kulalpa wiri karrija puluku ngarninjaku, manu ngapaju kulalpa wiri ngunaja. Ngula-jangka kujarlaju, Yipurumu-kurlangurlu Laati-kirlangurlu warrkinirli, ngulangkujulu-nyanu wiljiwilji-manu marna-ngurlu ngapa-ngurlu. Marna-wangurla manu ngapa-wangurla lirrjirdirla, kulalu nyiyakulku nyinakarla panu-kariji yalumpurlaju ngurungka. ");
INSERT INTO wbp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ngula-jangka, Yipurumujurla wangkaja Laatikiji, “Ngalipaju karlipa nyina turnu-warnu-jala-ngarra. Kulu-wangurlipa nyina waparlku rarralypa. ");
INSERT INTO wbp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Walyanya kanpa yinya nyanyi kakarrumparra-warnu kurlirra manu karlumparra-warnu kurlirra? Milaka nyarrparanpa kanyi walya. Kajinpa yani karlumparra-warnu kurlirra, kapurna ngajuju yani kakarrumparra-warnu kurlirra.” ");
INSERT INTO wbp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","13","Junga-juku, Laatirliji walyajulpa nyangulku. Nyangu wirri wantiki-wana-juku karru ngapa-kurlu-wana kakarru-kurlirra. Parlu-pungu yukuri-nyayirni manu watiya ngurrju-nyayirni wiriwiri karru-wana yirdi-wana Jurdunu-wana, yangka kuja-ka wirri wiri ngunamirra kurlirra yirdi-kirraju kirri-kirraju Jura-kurra. Ngula-kurra-pinanguju ngapa-ka ngunanjarra-yani jaya-kurra. Ngurujulpa ngunaja yangka-piya-yijala yukuri-jarlu kaatini yirdi-piya Yitini-piya manu nguru-kari jinta-kari-piya Yijipi-piya. (Kurlarra wurnturulpa-pala karrija kirri-jarra jirrama. Yirdiji jinta-kariji Jatama, jinta-kariji kirri-kariji yirdiji Kumarra. Murnma-juku-palangu YAAWIYI-rli yampija kirri-jarraju riwarr-pinja-wangurlu.) Nyampu walya milarninjarla puranja-yanu-jana jirrnganja Laatirliji. Ngulaju yanurra kirri-kirra Jatama-kurra kakarru-kurlirra. Ngurralku yirrarnu yungkaparri-jiki kirringka Jatama-pirdi. Yapa yali kujalpalu nyinaja Jatamarla, ngulajulpa punku-nyayirni nyinaja, kulalpalu YAAWIYI puraja, lawa. Yipurumujulpa-jana jirrnganja nyinaja purdangirli yalumpurla yangkangka-juku ngurungka lirrjirdirla. ");
INSERT INTO wbp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ngula-jangkaju, YAAWIYI-ji wangkajarla Yipurumukuju, “Walya nyampu miimii-nyangka warru yatijarra, kakarrara, kurlirra, karlarra. ");
INSERT INTO wbp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nyampuju kapurnangku yinyi nyuntuluku manu nyuntu-nyangu-purnuku kurdukurduku. Kajinpa-jana kurdu panu mani, ngulakunya kanpa-jana ngayi-mardarni nyuntulurlu tarnnga-juku. Ngulakunya-jana karrimi nyampuju walya. ");
INSERT INTO wbp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nyuntu-nyangu kurdukurdu kapulu panu-jarrimi panu-nyayirni jaya-kurra nama-piya. Kula-jana nganangku yiin-pura nama-piya kurdukurduju. ");
INSERT INTO wbp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Karrinja-pardinjarla jirrnganja-jana warru wapaya nyampurla walyangka, kurlurlumpayi, karlumpayi, yatujumpayi, kakarrumpayi. Kari-nganta kapurnangku muku yinyi nyuntukulku nyampuju walya.” ");
INSERT INTO wbp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Junga-juku, Yipurumu-jana purda-nyanjarla jirrnganja yarnkaja karlarra kurlirra. Ngurra-kari ngurra-kari ngunanja-yanu-jana jirrnganja. Yanurnu jinta-kurra yirdi-kirraju kirri-kirraju Yipurana-kurra. Ngulangkalkulpa-jana jirrnganja nyinaja. Ngulangka kirringka Yipuranarla karrijalpalu watiya panu wiriwiri ngurrju-nyayirni maralypi. Nyampurra watiyajulpalurla karrija warlalja watiki jinta-karikiji yirdikiji Mamiriki. Ngulangkaju Yipurumurluju yarturlu-yijala yarda yurturlurla murnju-yirrarnu yurrujurla, ngulaju YAAWIYI-ki pulka-pinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Kuja-puru wati jintalpa nyinaja kingi Papilunuku yirdiji Marapiliji. Jinta-kari yirdiji Yarukuju kingilpa nyinaja Yalujuku. Jinta-kari yirdiji Kirdulayumuju nyinajalpa kingi Yilimiki, manu jinta-kari yirdiji Tituluju nyinajalpa kingi Kuyimiki. ");
INSERT INTO wbp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Nyampurra murntu-pala kingi-patu manu nyanungurra-nyangu warrmarlalu-jana jangkardu yanurnu kulu rdaka-pala kingi-patu-kariki manu nyanungurra-nyangu warrmarlaku. Yirdi nyanungurra-nyanguju Piira, Piirrja, Jinapa manu Jimipa. Piirajulpa kingi nyinaja Jatamaku. Piirrjajulpa kingi nyinaja Kumarraku. Jinapajulpa nyinaja kingi Yardamaku, manu Jimipajulpa nyinaja kingi Jipuyiki. Wati jinta-karijilpa nyinaja kingi Piilaku. (Yirdi jinta-kari ngurra yinya-kurlangu Jura.) ");
INSERT INTO wbp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kujalu-jana murntu-pala kingi manu nyanungurra-nyangu warrmarla jangkardu yanurnu kulu yinyaku rdaka-pala kingi-patuku, rdaka-pala kingijili-jana jinta-jarrija nyanungurra-nyanguku warrmarlaku karru-wana yirdi-wanaju Jiirdurnu-wana. (Jalangurlu karlipa nyampuju ngurra yirdi-mani ‘Mangkuru Punku’. Kula-ka nyiya wankaru nyina ngapangka yinyarlaju.) ");
INSERT INTO wbp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kujakungarntiji, kingi Kirdulayumulpa-jana wiri nyinaja yinyaku rdaka-pala-kari kingiki 12-palaku yulyurrpuku. Yulyurrpu-kari wangkajalu kulalurla warrki-jarrimi nganta nyanunguku. Wangkajalpalurla jangkardu nganta kulu. ");
INSERT INTO wbp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kuja-jangkanya-jana yulyurrpu-karirlaju, kingi Kirdulayumuju wangkaja kingi-patuku yirdi-patukuju Marapiliki, Yarukuku manu Tituluku yungulu-jana nyanungurra-nyangu warrmarla kanyirni kuluku yungulu-jana jangkardu yani panu-kariki. Yinyarra murntu-pala kingi manu nyanungurra-nyangu warrmarla kamparruju yanulu ngurra-kurra yirdi-kirraju Yajara-Karnami-kirra kuluku Ripayiti-patu yapaku. Ripayiti-patujulu-jana muku pungu kingi Kirdulayumu-kurlangu-paturlu warrmarlarlu kulu wiringka. Ngula-jangka, kingi Kirdulayumu-kurlangu warrmarlalu yanu Yaamu-kurra kujalpalu yapa-patu Jujiyi-patu nyinaja, ngulalu-jana Jujiyi-patuju muku pungu-yijala nyanungurrarluju. Ngula-jangka, Kirdulayumu-kurlangu warrmarlajulu yanu Jaapa-Kirija-kurralku. Yinyarla Yimiti-patu yapalu-jana muku pungu-yijala nyanungurrarluju. ");
INSERT INTO wbp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ngula-jangka, Kirdulayumu-kurlangu warrmarlalu yanu pirli-patu-kurra ngurrangka Yitamarla ngurra yirdi-kirraju Yala-Parana-kurra. Nyampuju kutu jiljangka. Yinyarlalu-jana muku pungu yapa Yuuriti-patu nyanungurrarluju. ");
INSERT INTO wbp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ngula-jangka, Kirdulayumu-kurlangu warrmarlalu yanu pirli-patu-jangka Yanimiji-kirra. (Yirdi jinta-kari ngurra nyampukuju Katiji.) Yinyarlalu-jana Yamili-patu muku pungu nyanungurrarluju. Manu Yamuri-patulu-jana muku pungu-yijala kulu wiringka. Yamuri-patuju kalalu nyinaja Yajaja-Tamururla. ");
INSERT INTO wbp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Yinyarra rdaka-pala-kari kingi-patu Jatama-wardingki, Kumarra-wardingki, Yardama-wardingki, Jipuyi-wardingki manu Piila-wardingki, purda-nyangulu kujalpalu kingi Kirdulayumu manu kingi marnkurrpa-kari manu warrmarla nyanungurra-nyangu yanurnu kuluku. Junga-juku, yanulu karru-kurra Jiirdurnu-kurraju kuluku. ");
INSERT INTO wbp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ngurra yinyarla, kulu wiringkili-jana pakarnu kingi-patu-kari yirdi-patuju Kirdulayumu, Titulu, Marapili, Yaruku manu panu-kari warrmarla. Murntu-palarlu panu-jarlu turnu-warnurlu warrmarlarlulpalu-jana kulungku pakarnu rdaka-pala turnu-warnu-kari. ");
INSERT INTO wbp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Karru Jiirdurnu-wana karrijalpa parlju-nyayirni. Kaji ngana yinya-wana wapayarla, kapu yukayarla kanunju manu paliyarla. Kulu wiri-puru, kingi Jatama-wardingki manu Kumarra-wardingki manu nyanungurra-nyangu warrmarla parnkajalu lani. Ngulalu wantija parlju-kurra, mukulu palija yalirla-juku. Yangka-patu kingi-patu marnkurrpa-kari manu nyanungurra-nyangu warrmarla, ngulalu wuruly-parnkaja pirli-kirra pinja-kujakuju. ");
INSERT INTO wbp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ngula-jangka, kingi Kirdulayumu manu nyanungurra-nyangu warrmarla yanulu Jatama-kurra manu Kumarra-kurra, manulu-jana jurnta kangu nyiyarningkijarra yapaku kujalpalu yinyarla nyinaja. Miyirlangulu-jana jurnta kangu. ");
INSERT INTO wbp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nyampukungarnti, kala Laati nyinajayi Jatamarlaju. Ngulajulpa Yipurumukupurdangka-kurlangu kaja-nyanu nyinaja. Ngula-jangkalu Kirdulayumu-kurlangu warrmarlarlu kangu Laatirlangu pirijina. Ngulalurla Laati-kirlangu nyiyarningkijarrarlangu jurnta kangu. Ngulalu pina-yanu nyanungurra-nyangu ngurra-kurralku. ");
INSERT INTO wbp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Wati jinta wuruly-parnkaja Jatama-ngurluju. Yaninjarlarla wangkaja Yipurumuku yangka Yipuruku kuja Kirdulayumurlu kangu Laati manu nyanungu-nyangu nyiyarningkijarra. Yinya-puru Yipurumujulpa nyinaja kutu watiya kirrirdiki yangka kujalparla karrija Mamiriki Yamuriki. Mamiriji papardi-nyanu Yijikuku manu Yanuruku. Nyampukungarnti, jirrama-juku-palarla wangkaja Yipurumukuju kajilirla yapa jangkardu yanirni kulu, kapu-pala nyanungu-jarrarlu muurl-mardarni. ");
INSERT INTO wbp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","15","Junga-juku, Yipurumurlulku-jana turnu-manu yapa Mamirikipurdangka-jarra-kurlangu-yijala yapa warrmarla kunka-maninjakulku. Junga-juku, jurnarrpalkulu manu wurrumpurru, kurdiji, junma, kuturu, mayingka manu nyiyarningkijarra. Yarnkajalu yatijarra-purda kirri-kari-kirra yirdi-kirra Taanu-kurra. Taanurla ngurungka ngula-pirdi, Kirdulayumu manu nyanungu-nyangu yapa warrmarla ngunajalpalu kutu. Yipurumu manu yapa nyanungu-nyangu warrmarla 318-pala, ngulajulpalu-jana wurru-kanja-yanu mungangka kutu-kari, manulu-jana warru jarijari-parnkanjarla yurnturru-manulku. Ngaamalyamalyalkulu jangkardu rdipijarni manu purlanja-karra purlanja-karra kulu. Jungajukulu-nyanu rdiily-yirrarnulku kuluju warrmarlaju Yipurumu-kurlangu-mayamaya, Kirdulayumu-kurlangu-mayamaya. Yipurumu-kurlangurluju pakarnulpalu-jana ngalya-kari tarnnga-kurra. Ngalya-karilpalu-jana lani-maninjarla wajirli-pinja-yanu yatijarra kirri-kari-kirra yirdi-kari-kirra Tamaka-kurraju. Ngula-jangkanyalu-jana wajirli-pinja-yanu kirri-kari-kirra yirdi-kirra Yuupu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ngula-jangkarlu Yipurumurlu kulu-jangkarlu-jana manu pina Laati manu nyanungu-nyangu kurdukurdu manu karntakarnta manu jurnarrpa, puluku, nyiyarningkijarra. Kangu-jana pina kurlirra yangka-kurra kirri-kirra Jatama-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ngulangka Jatamarla, ngula-purujulpa nyinaja kingi-pardu-kariji. Ngula kuja purda-nyangu jaru Yipurumu-kurlangu, ngulajurla purda-nyanjarla wapirdi yanu Yipurumukuju kingiji yangkaju Jatama-wardingki. Kulkurru-pala-nyanu jarnku-rdipija wirri wantikirla yirdingkaju Jaaparla. (Yapangku kalulu wirri wiri yali yirdi-pajurnu ‘Wirri Kingi-kirlangu’.) ");
INSERT INTO wbp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Jinta-kari kingi yanurnu Jalamu-jangka yirdiji Kijirdiki. Ngula kala nyinaja kingi Jalamu-wardingki-patuku. Ngula kalarla warrki-jarrija maralypikingarduyu Kaatuku yangka kuja-ka kankarlarra nyina. Kujarla wapirdi yanu Yipurumuku, ngularla rdipijarla kulkurru. Witarla warntarri yungu miyi manu pama Yipurumukuju, manu pulka-pungurlajinta. ");
INSERT INTO wbp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Wangkajalkurla Yipurumukuju, “Wangkami karnangkurla Kaatuku kuja-ka Wiri-nyayirni nyina kankarlarra, Kaatuju yangkangku kuja nyiyarningkijarra ngurrju-manu yalkiri manu walya lawa-jangka. Ngulaku yungunparla marlaja nyina wardinyi-nyayirni tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Manurlipa ngurrju-pajirni-yijala ngaliparluju yangkangku kujangku ngarlkirn-maninjarla wankaru-manu nyuntulu linjarrpa-puru Kaaturlu yangka kuja-ka kankarlarra nyina.” Kujanyarla wangkaja Yipurumuku. Junga-juku ngula-wanawanaju, yinyarra yangka nyiyarningkijarra kuja-jana Yipurumurlu jurnta kangu murntu-palaku kingi-patuku, yirrarnu-jana karlarla-pala yurturlurla, manurla karlarla-jangka jinta yurturlu-kari yungu Kijirdikiki warntarriji. ");
INSERT INTO wbp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ngula-jangka, yangkalkurla kingi Jatama-wardingki wangkaja Yipurumuku, “Yungkaju pina yapa-patu ngaju-nyangu-patu, kujaju yangka Kirdulayumurlu jurnta kangu linjarrpa wiri-puru. Jurnarrpa manu tala, ngulajungku nyuntuku mardaka.” ");
INSERT INTO wbp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Yipurumurlu yalu-manu, “Lawa, kularna jurnarrpaju kanyi. Nyampurla-juku, kuja kaju YAAWIYI-rli purda-nyanyi wangkanja-kurra, yangka kuja nyurru-wiyi yirrarnu nyiyarningkijarra YAAWIYI-rli, wangkami karnangku junga. ");
INSERT INTO wbp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Kularnangku marlaja kanyi jurnarrpaju jinta jirrirdi-puka wita-puka manu jamana-kurlangu jinta putu-puka. Lawa kujakuju. Kajikanpa-jana warru yimi-ngarrirni kujanpaju jurnarrpa yungu jaya-kurra. Ngula-kujakunya karna nyina. ");
INSERT INTO wbp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ngaju-nyangurlu warrmarlarlu ngulajulu ngalya-kariji nyurru miyiji ngarnu. Nyampurrakunya-jana yungka nyampu-warnu-juku jinta-warnu miyi-parduju. Manu jurnarrpaju manu mangarriji-jana yungka nyampu-patu-kariki ngalya-kariki yangka-kurlanguku Mamiri-kirlanguku manu Yijiku-kurlanguku manu Yanuru-kurlanguku yapaku, ngula-kurlunya yungulu pina-yani ngurra-kurra nyanungu-nyangu-wana-kurra.” Junga-juku, jurnarrpa manu miyi maninjarla mukulu jarnkujarnku yanu. ");
INSERT INTO wbp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kulu wiri-warnurla ngaka-pardu-karilki, yuruyururla YAAWIYI yaninjarla wangkaja Yipurumuku, “Yipurumu, lani-jarrinja-wangu nyinaya! Ngajujurnangku kurdiji, warla-mardarninjarla kapurnangku muurl-mardarni, manu kapurnangku warntarri-nyayirni-wangu yinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yipurumurlulku payurnu, “Yuwa YAAWIYI, ngurrju kujaju kajinpaju warntarri-nyayirni-wangu yinyi. Kala jalanguju karna kurdu-wangu wirriya-wangu nyinami, lawa-nyayirni. Ngulaju nganakulkurnarla yinyi jurnarrpaju ngaju-nyanguju kajirna yawu-pardimi, yapa ngalya-kariki mayirnarla yinyi? Kajilparna yawu-pardiyarla kaja-nyanu-wangu-juku, ngulaju-ka nyampurlu-juku ngaju-nyangu warrkinirli nyiyarningkijarra maninjarla kanyi yampinyiji nganayirli yirdingki Liyujurlu kirri-wardingkirli Tamaka-wardingkirli. ");
INSERT INTO wbp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kulanpaju kurduju yungu ngajukuju. Kajirna yawu-pardimi lawa-juku kaja-nyanu-wangu, nyampu Liyuju kuja kajana wiri nyina ngaju-nyanguku warrkini-patu-kariki, ngulaju-ka ngulangku-juku nyiyarningkijarra maninjarla kanyi ngaju-nyangu.” ");
INSERT INTO wbp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","YAAWIYI-lkirla wangkaja Yipurumukuju, “Lawangka kujaju. Kula yalumpurlu Liyujurluju mani yampinyiji nyuntu-nyanguju. Kapunpa nyuntulurlu jinta warlalja mardarni kurdu wirriya. Nyanungurlunya kapu maninjarla kanyi nyiyarningkijarraju.” ");
INSERT INTO wbp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ngula-jangkaju, Yipurumuju kangulku kaninjarni-jangka kaluku-jangkaju yurlapardi-kirra YAAWIYI-rliji. Wangkajarla Yipurumukuju, “Nyampu-jana nyangka parlpa-warnu kankarlumparra, nyajangu? Kulalpa-jana nganangku nyampurraju yiin-purayarla. Nyampu-piyanya ngulaju kapulu nyina yapa nyuntu-nyangu-mayamaya parlpa-warnu-piya-yijala.” ");
INSERT INTO wbp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Junga-juku, Yipurumurluju manngu-nyangu YAAWIYI. Manngu-nyanjarla wala nyinajarla YAAWIYI-kiji yangka kujarla jangku-pungu kurdukurdu panu-jarlu yuruyururlarlu. Kujarlaju, YAAWIYI-rliji Yipurumuju jungarni-pajurnu wala nyinanja-kurra, manu-nyanu wangkaja, “Wati nyampuju kaju jungarni nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ngaka-pardu-karilki, YAAWIYI wangkajarla, “Ngajurna YAAWIYI. Ngajurnangku yajarninjarla kangurnu yangka yali-ngirli nguru-ngurlu Papiluniya-ngurlu kirri-ngirliji Yuurru-ngurlu. Nyampurnangku kangurnu nyampu-kurra nguru-kurra. Kapurnangku yinyi nyampu nguru nyuntuku yungunpa nyina nyampurla tarnnga-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Yipurumurluju payurnu, “Yuwa YAAWIYI, kula karnangku kanunju-mirnimirnirli purda-nyanyi nyarrpa kanpaju wangka junga marda, lawa marda nguruku nyampuku. Junga mayi kapuju nguruju karrimi ngajukuju?” ");
INSERT INTO wbp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","YAAWIYI-jirla wangkaja Yipurumukuju, “Yuwayi, ngula-juku, kapurnangku milki-yirrarni junga ngaju-nyangu jaruju marrka. Puluku jinta ngamaju maninjarla kangkarni manu narnukutu jinta ngama manu jiyipi wirriya, yangka ngula kalu nyinami marnkurrpaku yukuriki ngakurru-nyayirni. Ngulanya-jana kangkarni. Manu jurlpu-jarra-palangu kangkarni kurlukuku jinta, jinta-kari ngapilkiri.” ");
INSERT INTO wbp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Junga-juku, Yipurumurluju-jana manunjunu. Ngula-jangkaju, waninja-jana muku pajurnu puluku manu narnukutu manu jiyipi manu jurlpu-jarra. Puluku-wiyiji kulkurru-jarra ngujurl-pajurnu, manu narnukutu manu jiyipi ngujurl-pajurnu-yijala-palangu. Jurlpu-jarraju ngulaju-palangu yampija wanapi-jiki ngujurl-pajirninja-wangurlu. Ngula-jangkaju, ngujurl-pajirninjarla yirrarnu-jana yurruju-paturla. ");
INSERT INTO wbp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yipurumurlujulpa nyinanjarla warrawarra-kangu kuyu-watiji jurlpu-kujaku warlawurru-kujaku. Kapulu jurlpungku jayirr-maninjarla kangkarla. Ngula-kujakunyalpa warrawarra kangu, manulpa-jana yilyajarra. ");
INSERT INTO wbp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Yipurumujulpa warrarda nyinaja yalumpurla-juku jintangka yurrujurla. Wanta kujalpa yukanjarra-yanu, nyanunguju ngula-puruju jarda-jarrijalku-yijala. Kujalpa jarda ngunaja, mungalku wuuly-wantija. Ngula-warnuju lani-jarrija-nyayirnilkilpa nyiya-kujaku mayi. ");
INSERT INTO wbp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","YAAWIYI wangkajalkurla, “Nyuntu-nyangu kurdukurdu manu kurdukurdu-kari manu kurdukurdu-kari, ngulaju kapulu yapa-kari-nyayirni nyinami yalirlaju nguru-karirla. Yapa yali-wardingki-patu kapulu-jana wiri-jiki nyinami nyuntu-nyangukuju kurdukurduku. Kapulu-jana jinyijinyi-mani pirijina-piya warrkikiji kulu-parntarlu. Kapulu-jana murrumurru-mani 400-palaku yukuriki. ");
INSERT INTO wbp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ngula-jangkarlaju, ngakarranyi-karirla kapurna-janarla kunka-mani yali-wardingki-patuju kulu-parntaju nyuntu-nyanguku kurdukurduku. Manu kapurna-jana nguru-yirrarni pina nyuntu-nyangu kurdukurdu yali-ngirliji nguru-ngurlu. Ngula kajili nguru yampimi, ngulaju kapulu-nyanu nyiyarningkijarra muku kanyi jurnarrpa manu tala. ");
INSERT INTO wbp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nyuntu Yipurumu kapunpa rarralypa nyinami tarnnga-nyayirni jarlu-pardu-pinangu-kurra. Kulangku ngana rdapakarrkami. Nyuntu kajinpa yawu-pardimi, ngulaju kapungkulu milyingka yirrarni. ");
INSERT INTO wbp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Jalanguju nyampurla ngurungka Kananarla, ngulaju kalu yardayarda majungka-jarrinja-yani yapa-patu Yamuri-patuju. Murnma-juku karna-jana yampimi yilyanja-wangurlu. Ngaka kajili pina-yani nyampu-wana Kanana-wana nyuntu-nyangu kurdukurdu, ngulangkuju kapulu-jana ngurl-kanjarla yilyami Yamuri-patuju maju panuju yapaju. Nyampunyarnangku wangkaja nyuntukuju.” ");
INSERT INTO wbp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kuja wanta yukaja, ngula-jangkaju, mungangkalku yakarra-pardija Yipurumuju, manu-palangu nyangu jirrama warlu-jarra jankanja-palka jinta-kari ngiji-piya jarra-kurlu, jinta-kari kunjuru-piya. Warlu-jarrajulpa-pala yurirrija kanardirla kulkurru-jarra kuyu-patukuju. ");
INSERT INTO wbp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ngula-kurlunyajurla ngungkurr-nyinaja YAAWIYI-ji Yipurumukuju jungarni-nyinanja-kurraku. Ngula-jangkaju, wangkajalkurla Yipurumukuju yungurla jangku-pinyi nguruju, “Nyampu nguru kuja-ka ngunamirra karlarra Yijipi-ngirli karru wiri-ngirli manu kakarrara-kurra karru wiri-kirra Yupirayiti-kirra, ngulaju kapurna-jana nyuntu-nyangu-purnuku kurdukurduku yinyi. ");
INSERT INTO wbp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Kuja kalu jalangu nyina yapa nyampurla ngurungka yapa-kari yapa-kari yapa-kari nganayi-patu Kinini-patu, Kiniji-patu, Katimuni-patu, Yititi-patu, Piriji-patu, Ripayiti-patu, Yamuri-patu, Kanana-wardingki-patu, Kirrkaji-patu, manu Jipuji-patu, nyampurra-kurlangunya nyampu nguru kapurna-jana puntarninjarla yinyi nyuntu-nyangukulku yapaku.” ");
INSERT INTO wbp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Yipurumujulpa nyinaja yukurikiji karlarla-palaku ngurungka Kananarla. Karnta nyanungu-nyangu Jaarayi, ngulajulpa nyinaja lawa-juku murnma-juku kurdu-wangu-juku. Yalumpurla-yijala jinta-karilpa karntaju Yijipi-wardingki yirdiji Yakarru nyinaja, ngulalparla warrki-jarrija Jaarayikiji. Ngakaju Jaarayiji yanurla Yipurumuku, manu wangkajarla, “YAAWIYI-rli kurdu-wangu-manuju, manu kurdu-wangu-juku karna nyina. Yantarla Yakarruku, manu ngunanjinta-pala. Kajingki kurdulku marlaja mardarni, ngulaju yungkaju-pala yungurnaju wiri-mani ngajukulku.” Junga-juku, Yipurumuju yanurla karnta-karikilki Yakarruku. ");
INSERT INTO wbp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Junga-juku, ngunajalku-pala Yipurumuju manu Yakarruju. Ngula-jangkaju, Yakarrujulparla marlaja nyinaja wartardilki. Kuja-nyanu purda-nyangu wartardilki, ngulangkuju-nyanu manngu-nyangu ngurrjungku nganta. Manyu-pinjakulkurla rdirri-yungu, manu jiliwirri-manulpa muturnaju Jaarayiji. Kujarluju manyungkuju muntuku-manulku Jaarayiji. ");
INSERT INTO wbp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Junga-juku, yanurla Jaarayiji Yipurumuku, manu kululkurla wangkaja Yipurumukuju, “Muturna nyanjarla kaju manyu-pinyi manu jiliwirri-mani warrarda yikarna kurdu-wangu nyina. Nyuntu-panurla kujarluju kaju manyu-pinyi. Nyuntukurnangku yungu. Wartardilki kuja-nyanu purda-nyangu, ngula-jangkaju, yinkalku kaju ngarlarrimi, manu warrarda manyu-pinyi kaju. Ngaju mardarnarla rampal-yanu YAAWIYI-ki, mardanparla nyuntu rampal-yanu. Karija! Pardarnirlirla YAAWIYI-ki ngana marda karla jungarni nyina nyanunguku.” ");
INSERT INTO wbp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Yipurumulkurla wangkaja Jaarayikiji, “Nyuntukungku yalumpuju warrkini. Ngulaju nyuntu-wurru nyarrpa-manta!” Junga-juku, Jaarayirla kululku jangkardu yanumpa Yakarruku, manu paka-pungulku. Ngula-jangkaju, paka-pinja-warnuju wuruly-parnkajalku. ");
INSERT INTO wbp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ngula-jangka, Yakarru paka-pinja-warnu yaninja-yanu yirdiyi-wana jilja-wana. Yaninja-yanulpa jilja-kurra nguru-kurra yirdi-kirraju Juuru-kurra. Ngulangkaju parlu-pungulku muljulku. Ngulajulpa nyinajalku yalumpurla-juku matalku. Ngula-kurraju-kurla YAAWIYI-rliji yilyajarni marramarralku kankarlarra-ngurluju. ");
INSERT INTO wbp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Marramarrajurla parlu-pinjarla wangkaja Yakarrukuju, “Yakarru, nyarrpara-jangkanpa yanurnu, manu nyarrpara-kurra kanpa yani?” Yakarrurluju yalu-manu marramarraju, “Ngaju-nyangulku wirikirnarla jurnta yanu kulu panuku.” ");
INSERT INTO wbp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Marramarrajurla yarda wangkaja Yakarrukuju, “Yantarla pina nyuntu-nyanguku wiriki. Nyiyaku-puka kajingki jinyijinyi-mani warrkiki, ngulajurla kapanku-manta ngampurrparlu jukuru-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kapurnangku yinyi jaya-kurra-nyayirni kurdukurduju, ngulaju kula-jana nganangku ngulaju yiin-pura. ");
INSERT INTO wbp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nyuntulu-wiyi kanpa wartardi nyina. Yungkaparri-yijala kapunpa ngaka mardarni wirriya kurdu. Yirdiji kapunparla yirrarni Yijimali. YAAWIYI-rli milya-pungulpangku kulu-warnuju murrumurruju, manulpangku purda-nyangu yulanja-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ngulakuju kapu nyuntu-nyanguju kurduju marrka-nyayirni nyina pirrjirdi kulu-parnta tangkiyi-piya. Kaji wiri-jarri, kapu yani kuja-purda kuja-purda-kari nyarrpara-wana-puka kaji nyanungu ngampurrpa nyinami yaninjaku. Kaji warru wapa, ngulaju kula nganangku warrarda jinyijinyi-mani. Kapu-jana yapa-kariji warrarda pakarni kulungkuju, manu yapa-karirli kapulu nyanungu warrarda-yijala pakarni. Ngulaju kapu-jana jangkardu yaninjarla pakarni nyanungukupurdangka-purnu.” Kujanyarla marramarraju wangkaja Yakarrukuju. ");
INSERT INTO wbp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ngula-jangka, Yakarruju-nyanu wangkaja, “Junganyarna nyangu Kaatu? Nyanja-warnu kula-ngantarna palija nyampurla-juku.” Ngula-jangkaju, Kaatulkurla yirdi yirrarnu ‘Yiliruyu’ Yakarrurluju, ngulaju yirdiji-ka wangka, ‘YAAWIYI-rli kaju ngaju nyanyi’. ");
INSERT INTO wbp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yangka Yakarru kujalpa nyinaja muljungka, ngulaju kirri-jarrarla kulkurru yirdi-jarrarla Katijirla manu Pirirdirla. Yapangkuju kalalu yirdi-manu yangkaju mulju ‘Piirilayiruu’. ");
INSERT INTO wbp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Junga-juku, ngaka parra-pardu-karirlalku wita wirriya palka-jarrijarla Yakarrukuju ngati-nyanukuju. Ngulajurla yungu Yipurumuku, ngulangkujurla yirdilki yungu witakuju wirriyakuju Yijimali. ");
INSERT INTO wbp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Yakarrurlu kujarla wita wirriya yungu Yipurumuku, ngulajulpa Yipurumuju nyinaja jarlu-pardulku yukuriki 86-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ngakarranyi-karilki kujarla rdipija Yipurumukuju yulyurrpu 99-pala, ngula-jangkaju, YAAWIYI-lkirla warraja-jarrinjarla wangkaja, “Ngajujurna PIRRJIRDI-NYAYIRNI WITA-WANGU! Ngulaju nyinaka ngaju-nyangurla kuruwarrirla jungarni manu junga, manuju puraya warrarda ngajulu-juku jarrwara-wangurlu tarnngangku-juku. ");
INSERT INTO wbp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kajinpaju ngaju pura, ngulaju karnangku jangku-pinyi kurdukurdu panu-jarlu kapurnangku yinyi. Nyampunya kuruwarri ngaju-nyangu nyuntuku.” ");
INSERT INTO wbp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yipurumurlu kuja purda-nyangu Kaatu wangkanja-kurra, ngulakujurla mirdijirrpijirrpi-jarrija, manu ngalyangku walya marnpurnu. Kaatujurla wangkaja, ");
INSERT INTO wbp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Jalangunya karnangku wangkami. Nyuntuju kapunpa-jana kirda-nyanu nyina jaya-kurraku yapaku nguru-kari nguru-karirla. Nyampunya kuruwarri ngaju-nyangu nyuntuku. ");
INSERT INTO wbp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nyampu jalangu-ngurlu-nyayirni nyuntu-nyangu yirdi kula Yipurumulku. Kapurnangku kurruly-yirrarni yirdi-karilki Yipuruyamulku, ngulaju yungunpa-jana kirda-nyanu nyina yapa-kariki jaya-kurraku kujarla yalarnirlaku ngurujarraranypaku. ");
INSERT INTO wbp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nyuntuju kapungkulu jaya-kurrarlu turnu-warnu-karirli turnu-warnu-karirli kirdarna-pajirni, manu kapulu kingi-kari kingi-kari palka-jarrimi panu-jarlu nyuntu-nyangu-purnu-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Tarnnga-juku kapurna-nyarra ngajuju ngungkurr-nyina nyuntuku manu yapaku nyuntu-nyanguku. Jalangujurnangku Kaatu nyuntukuju, manu ngakarna-jana Kaatuju nyina nyuntu-nyangu-purnuku yapaku. ");
INSERT INTO wbp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nyampu walya kapurna-nyarra yinyi nyuntuku manu nyuntu-nyangu-purnuku kuja kankulu nyampurla walyangka warru wapa nyampurla Kananarla kutukutu. Ngulaju-jana tarnnga-juku nyanungu-patuku nyampuju walya, manu tarnnga-juku ngajujurna-jana Kaatuju.” ");
INSERT INTO wbp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kaatujurla yarda wangkaja Yipuruyamukuju, “Nyuntulurlu Yipuruyamurlu yungulpanpaju purayarla tarnngangku-juku manu nyuntu-nyangu-purnurlangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nyampunya kuruwarri ngaju-nyangu yungulpankulu jungarnirli purayarla. Ngula-jangkarlunya ngungkurr-nyinanja-warnurluju, ngarrka-kijikalu-nyanu jintawarlayirli-juku. ");
INSERT INTO wbp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kajirna-nyarra nyanyi ngarrka-kijirninja-warnu, ngulaju kapurna-nyarra milya-pinyi yangka-warnu kujarna-nyarra jangku-pungu manu kuja kankujulu purami-juku. ");
INSERT INTO wbp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Nyampunya ngaju-nyanguju kuruwarriji. Jalangu-jarra kaji kurdu palka-jarrimi wirriya, ngulaju kapunpa-jana ngarrka-kijirni wiyiki-jangka jinta-jangka. Nyuntu-nyangurlangu warrkini-paturlangu kujalpalu palka-jarrija nyuntu-nyangurla ngurrangka, ngulaju-jana kapankurlu ngarrka-kijika, manu yapa-kari warrkini-patu kujanpa-jana maninjarla kangurnu nguru-kari-jangka, ngularlangu-jana kapankurlu-yijala ngarrka-kijika. Kajirna-jana nyuntu-nyangu-purnu manu nyuntu-nyangu-patu warrkini-patu nyanyi ngarrka-kijirninja-warnuju, ngulaju kapurna-jana milya-pinyi yangka-warnu kujarna-nyarra jangku-pungu manu kuja kankujulu purami-juku. ");
INSERT INTO wbp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nganangku-puka kajingki wurra-mani ngarrka-kijirninja-kujaku, ngulangkuju-ka rdilyki-pinyi kuruwarri ngaju-nyangu. Kuja-panuju, jurntalurla yilyayarra nyurrurla-nyangu turnu-warnu-ngurlu.” ");
INSERT INTO wbp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","“Nyuntu-parnta karnta ngulaju kula yirdi-manta Jaarayilki. Jalangu-jarrarlulkuju jinta-kari yirdi-manta Jiira. ");
INSERT INTO wbp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ngulaju kapurna pirrjirdi-maninjarla warrawarra-kanyi, kapurnarla wita wirriya yinyi. Nyanunguju kapulu ngati-nyanu-pajirni panu-jarlurlu turnu-warnu-kari turnu-warnu-karirli, manu kapulu kingi-kari kingi-kari nyanungurra-nyangu ngurungkaju palka-jarrimi panu-jarlu nyanungu-nyangu-purnu-ngurlu.” ");
INSERT INTO wbp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Wangkanja-kurra kuja purda-nyangu Kaatuju, ngulajurla Yipuruyamuju mirdijirrpijirrpi-jarrinjarla parntarrija, manu manyulkulpa-nyanu ngarlarrija. Wangkaja-nyanu, “Ngaju karna yukurikiji nyina 100-palaku. Manu ngaju-parntaju-ka yukurikiji 90-palaku nyinami. Ngulangkujunya kapurlijarra kurdunya mardarni jarlu-pardurlulkuju manu muturnarluju?” ");
INSERT INTO wbp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Yipuruyamurluju payurnu Kaatulku, “Ngaju-nyanguju yangka kaja-nyanuju yirdiji Yijimali, ngula-wiyi milaka yungunparla kurdukurdu yinyi manu ngururlangu.” ");
INSERT INTO wbp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kaaturlu jangku-manu Yipurumuju, “Ngulakuju kularna-jana ngungkurr-nyina Yijimali-kirlangukuju, lawa. Jungaju nyuntu-parntarlu karntangku kapu wita wirriya mardarni palka-yijala. Kapunparla yirdiji yirrarni Yijaki. Ngulangkuju ngakaju kapu-jana nyuntu-nyangurluju kaja-nyanurlu panu-yijala mardarni, ngula-mipakunya kapurna-jana ngajulurluju jangku-pinyi kuruwarriji tarnnga-juku. Kularna-jana wajawaja-manilki. ");
INSERT INTO wbp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“Yangkaku Yijimaliki, ngulajurnangku purda-nyangu wangkanja-kurraju. Yuwayi, ngulaju kapurna ngurrju-yijala pirrjirdi-maninjarla warrawarra-kanyi, ngajukuju kapujulu marlaja kurduwarr-kijirni kurdukurdu panu-nyayirni. Kapurnarla yinyi wirriyawirriya 12-pala. Nyampurra-patuju kapulu-jana wiri nyinami yapa-patu-kariki nyampurraku nyanungu-mayamayaku. ");
INSERT INTO wbp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ngaka jinta-karirla yukuri-karirla, kaji wita wirriya mardarni Jiirarlu, ngula-mipakunya kapurnarla ngungkurr-nyina. Nyampunyarnangku wangkaja nyuntukuju ngula-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Junga-juku, wangkanjarla Kaatuju pina-yanulku kankarlarra. ");
INSERT INTO wbp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kuja Kaatu pina-yanu kankarlarra, ngula-jangkarlaju Yipuruyamurluju warrulku-jana turnu-manu yapa nyanungu-nyangu manu warrkini nyanungu-nyangu manu yangka Yijimali manu kurdukurdu wirriyawirriya. Yalumpurla-juku, Yijimali-wiyi ngarrka-kujurnu, manu-jana ngarrka-kujurnu jintawarlayi-jiki. ");
INSERT INTO wbp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","27","Ngulaju jintangka-juku parrangkajulu-nyanu jintawarlayirli-juku muku ngarrka-kujurnu. Yipuruyamukujurla rdipija yulyurrpu 99-pala, manu ngalapi-nyanuku Yijimalikijirla rdipija yulyurrpu 13-pala. ");
INSERT INTO wbp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Parra-kari jinta-karilki, Yipuruyamujulpa nyinaja yamangka lakarnparirla ngulyangka kalukurla, ngulaju Mamiri-kirlangurla ngurrangka ngawurrngawurrpa-puru. Kujalpa nyinaja yamangka kulayikulayilki, ngula-kurrakujurla YAAWIYI-ji warraja-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Jarturn-karrinja-warnu jurruju kankarlu-jarrija, manu milpa tirl-pardija. Ngula-jangka palkalku-jana nyangu wati-patu marnkurrpa ngulalurla kutu karrija. Ngulakuju-jana karrinja-pardinjarla wapirdi parnkaja. Parnkanjarla mirdijirrpijirrpi-jarrija-jana, ngularla wangkaja jintakuju, ");
INSERT INTO wbp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Kajinkijili ngampurrpa nyina ngaju-nyangurlaku kalukurlaku nyinanjaku, ngulajulu yukayarni yama-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","5","Ngaparna-nyarra maninjini-wiyi mayi yungurna-nyarra wirliya-jarra kirlka-mani? Miyikinkili ngampurrpa yungurna-nyarra maninjini? Miyi ngarninjarla yungunkulu yanilki nyampu-jangka jijanu kujankujulu yanurnu wiyarrpaku.” Junga-juku, jangku-manulkulu Yipuruyamuju, “Yuwayi, ngula-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Junga-juku, Yipuruyamuju yaninjarla yukajalku kalukurlaju, manurla wangkaja nyanungu-parntaku karntaku, “Yuwa, yarujurlu-jana manta pulawa nyampu-kurlurlu wiri-kirlirli yakuju-kurlurlu. Ngulaju pulawaju ngapa yarlarninjarla kapanku nyurlaya, manu-jana kapurdukapurdu-maninjarla purraya yali wati-patukuju.” ");
INSERT INTO wbp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kuja Yipuruyamurlu jinyijinyi-manu Jiira mangarri purranjaku, ngula-jangkaju, yanulku yarlu-kurra kujalpalu nyanungu-nyangu-patu puluku-patu karrija. Ngulangkanya jinta milarnu pulukuju kurdu-warnu kipili-nyayirni. Jinyijinyi-manu warrkini nyanungu-nyangu yungu pulukuju pakarni. Junga-juku, rdarri-mardarninjarla kapankurlu-jana purraja kilyirrparla. ");
INSERT INTO wbp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ngula-puru-juku Yipuruyamuju yanu lampurnu maninjaku manu kuyuku murntuku manu mangarriki maninjaku. Junga-juku-jana maninjarla yungu yangka wati-patuku marnkurrpaku. ");
INSERT INTO wbp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ngula-jangka, miyi ngarninja-karrarlu-juku payurnulu Yipuruyamuju, “Nyarrpara nyuntu-parntaju karntaju Jiiraju?” Yipuruyamurlu-jana yalu-manu, “Nyampu-ka palka kaninjarni nyina kalukurla.” ");
INSERT INTO wbp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wati ngularla wangkaja Yipuruyamukuju, ngulaju Kaatu-jala. Wangkajalkurla, “Kirntangi 9-pala-jangka kapurna pina-yanirni nyampu-kurra kaji nyuntu-parntarluju palkalku kurdu wirriya mardarni.” Jiirarlujulpa-palangu wuruly-purda-nyangu kaluku-ngurlu tuwa-ngurlu kujalpa-pala wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Kuja-palangu purda-nyangu wangkanja-kurra Jiirarlu, kujarlaju manyulku ngarlarrija, manu-nyanu wangkajalku, “Nyarrparlu-yijalalparlijarra kurduju mardakarla muturnarlu kapi jarlu-pardurlu? Yungulparnarla jirrnganja ngunanjinkarla kapanku kamina-piyaju? Kujaju lawangka.” ");
INSERT INTO wbp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","14","YAAWIYI-rliji purda-nyangu Jiiraju manyu ngarlarrinja-kurra, manu Yipuruyamulku payurnu, “Nyiyaku-ka kujaju manyuju ngarlarri? Kulalpa nganta mardakarla kurdu muturnarluju? Marda kaju kapuru nyina ngajuku wangkanja-kurraku? Kulalparnarla mayi kurduju yungkarla pirrjirdi-wangurlu nganta? Junga kajirna pina-yanirni kirntangi 9-pala-jangka, ngulaju kapurna parlu-pinyi palka kurduju kaji mardarni ngati-nyanurluju.” ");
INSERT INTO wbp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Kujarlaju, Jiiraju kurnta-jarrija-nyanu, manurla lani-jarrinjarla wangkaja warlkalku, “Kularna ngajuju ngarlarrija.” YAAWIYI-rliji jangku-manu, “Junganpa ngarlarrija. Purda-nyangurnangku ngarlarrinja-kurra.” ");
INSERT INTO wbp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Junga-juku, ngula-jangkaju, karrinja-pardinjarla pardijarralkulu wungu-juku yangka wati-patu marnkurrpa manu Yipuruyamu. Yaninja-yanulu yirdiyi-wana, yirdiyi kujalpa ngunajarra yangka-kurra kirri-kirra Jatama-kurra. Ngulalpalu nyanjarra yanu yuwarliji wurnturu-kurraju yaninja-karrarluju. ");
INSERT INTO wbp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kujalpalu yaninja-yanu yirdiyi-wana, yangkangku YAAWIYI-rliji manngu-nyangu, “Wangkami mayirnarla nyampukuju Yipuruyamuku yangka kapurna riwarri-mani nyampuju kirri warlu-kurlurlu? ");
INSERT INTO wbp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Yipuruyamu-kurlangu kurdukurdu kapulu jaya-kurra-nyayirni panu-jarri, kapulu pirrjirdi-jarrinja-yani nguru nyampurlaju. Nyampukunya kapulurlajinta marlaja wardinyi-jarri yapa-kari yapa-kari kujarla yalarnirla ngurujarraranypa. ");
INSERT INTO wbp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nyampunyarna Yipuruyamu milarnu yungu-jana pinarri-mani yapa nyanungu-nyangu kuruwarri-kirlirli ngaju-nyangu-kurlurlu jungarni-karda yungulu nyina. Kaji-jana pinarri-mani, kapurnarla muku yinyi nyiyarningkijarra kujarnarla nyurru-wiyi jangku-pungu. Ngula-juku kapurnarla wangkami nyarrpa-mani kajirna jalangu kirri yaliji.” ");
INSERT INTO wbp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Junga-juku, YAAWIYI-ji wangkajalkurla Yipuruyamuku, “Yimirna purda-nyangu wita kuja kalu nganta yalirla kirringka nyina ngawu-nyayirni manu kuruwarri rdilyki-pinja wita-wangu. Nyampuju marda junga yimi, marda lawa. ");
INSERT INTO wbp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ngajulurlu-wiyi-juku kajirna nyanja-yani. Kajirna-jana yapa ngurrju parlu-pinyi, ngulaju kapurna-jana yampimi riwarri-maninja-wangurlu. Kala kajirna-jana yapa ngawu-nyayirni parlu-pinyi, ngulaju kapurna-jana warlu yilyami riwarri-maninjaku. Nyampu-kurlurlu kapurna-jana muku purrami.” ");
INSERT INTO wbp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","YAAWIYI manu Yipuruyamu, ngulajulpa-pala karrinjarla wangkaja kulkurru yirdiyirla. Kala jirrama-kari wati-jarra, ngulajulu-palangu yampinja-yanu kirri-kirrarlu Jatama-kurrarlu. ");
INSERT INTO wbp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Yipuruyamurluju kutu-jarrinjarla payurnu Kaatulku, “Kapunpa-jana mayi ngurrju manu ngawu jintangka-juku muku pinyi warlu-kurlurluju? ");
INSERT INTO wbp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kala kajilpanpa-jana yaninjarla parlu-pungkarla yalirla kirringka 50-pala ngurrju yapa, ngulaju mayi kajikanpa-jana muku pinyi-jiki kirri-wardingki-patuju jintawarlayi? ");
INSERT INTO wbp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Karrimirra kuja! Nyuntulu kanpa-jana milya-pinyi yapa ngurrju manu ngawu. Nyuntulu kanpa-jana wiri-jiki nyina tarnnga-juku. Ngurrju yapaju kapunpa-jana mayi riwarri-mani panu-kari-piya ngawungawu-wati-piya?” ");
INSERT INTO wbp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","YAAWIYI-rli jangku-manu, “Kari lawangka! Kajirna-jana 50-pala-mipa parlu-pinyi ngurrju, ngulaju kapurna yampi kirriji, manu yapaju kapurna-jana yampimi jintangka-juku ngurrju kapi maju wankaru-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ngula-jangkaju, Yipuruyamurluju yarda payurnu, “Ngajuju karnaju milya-pinyi kujanpaju walya-jangka ngurrju-manu manu yurlpulypa-jangka. Ngarirnangku witalku yarda payirni lani-wangurlu. Kajilpanpa-jana parlu-pungkarla 45-pala-mipa ngurrju, ngulangkaju mayi kajikanpa-jana muku pinyi-jiki kirri-wardingki-patuju?” ");
INSERT INTO wbp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","YAAWIYI-rliji yarda jangku-manu-yijala, “Kari lawangka! Kajirna-jana 45-pala-mipa parlu-pinyi ngurrju, ngulaju kapurna-jana yampi jintangka-juku wankaru-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ngula-jangkaju, Yipuruyamurluju yarda payurnu, “Kajilpanpa-jana parlu-pungkarla 40-pala-mipa ngurrju, ngulangkaju mayi kajikanpa-jana muku pinyi-jiki kirri-wardingki-patu?” YAAWIYI-rliji yarda jangku-manu-yijala, “Kari lawangka! Kajirna-jana 40-pala-mipa parlu-pinyi ngurrju, ngulaju kapurna-jana yampi jintangka-juku wankaru-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ngula-jangkaju, Yipuruyamurluju yarda payurnu-yijala, “Kajirnangku yarda payirni, miyalu jumati-wangurluju yampiya! Kajilpanpa-jana parlu-pungkarla 30-pala-mipa ngurrju, ngulangkaju mayi kajikanpa-jana muku pinyi-jiki kirri-wardingki-patuju?” YAAWIYI-rliji yarda jangku-manu-yijala, “Kari lawangka! Kajirna-jana 30-pala-mipa parlu-pinyi ngurrju, ngulaju kapurna-jana yampimi jintangka-juku wankaru-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ngula-jangkaju, Yipuruyamurluju yarda payurnu-yijala, “Yati! Kulanpaju wurra-manu, yardarnangku payirni lani-wangurlu. Kajilpanpa-jana parlu-pungkarla 20-pala-mipa ngurrju, ngulangkaju mayi kajikanpa-jana pinyi-jiki kirri-wardingki-patuju?” YAAWIYI-rliji yarda jangku-manu-yijala, “Kari lawangka! Kajirna-jana 20-pala-mipa parlu-pinyi ngurrju, ngulaju kapurna-jana yampimi jintangka-juku wankaru-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ngula-jangkaju, Yipuruyamurluju yarda payurnu-yijala, “Kajirnangku yarda payirni jintakulku witaku jaruku, miyalu jumati-wangurluju yampiya! Kajilpanpa-jana parlu-pungkarla 10-pala-mipa ngurrju, ngulangkaju mayi kajikanpa-jana muku pinyi-jiki kirri-wardingki-patuju?” YAAWIYI-rliji yarda jangku-manu-yijala, “Kari lawangka! Kajirna-jana 10-pala-mipa parlu-pinyi ngurrju, ngulaju kapurna-jana yampimi jintangka-juku wankaru-juku. Kapulu wankaru-juku nyina nyampurlaju kirringka Jatamarla.” ");
INSERT INTO wbp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ngula-jangkaju, YAAWIYI-rli yampinja-yanulku Yipuruyamuju. Yipuruyamuju pina-yanulku jurrku-kurra ngurra-kurra nyanungu-nyangu-kurra yangka-kurra Mamiri-kirlangu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Yangka-jarra marramarra-jarra, ngulajulpa-pala yanurra-juku yirdiyi-wanaju yangka-kurra kirri-kirra Jatama-kurra. Ngula-pala rdipijarra kirri-kirraju wurajiwuraji. Ngula-pala parlu-pungu Laatilki kujalpa nyinaja kiirtirla. Nyanungurlulku kuja-palangu wapirdi nyangu, ngula-palangu karrinja-pardinjarla wapirdi yanu. Mirdijirrpijirrpi-jarrinjarla parntarrinjunu kamparru nyanungu-jarrarla. ");
INSERT INTO wbp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Wangkajalku-palangu, “Yuwa, ngajurna warrkini nyumpala-nyangu. Yantarni-pala ngaju-nyangu-kurra yuwarli-kirra yungunpala-nyanu wirliya yarlirninjarla kirlka-mani manu yungunpala ngula-jangkaju nguna jardalku. Jukurra mungalyurru yungunpala yakarra-pardinjarla yarnkamirra wurnalku.” Marramarra-jarraju wangkaja-palarla, “Lawa, nyampurla-juku karlijarra yarda nguna munga-karikilki yarlungka.” ");
INSERT INTO wbp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Laatiji-palangu yarda wangkaja pirrjirdi-nyayirniji jaruju, “Lawa kujaju! Jukuru-wangu yantarni-pala kaninjarra yuwarli-kirra!” Junga-juku, marramarra-jarraju-palarla ngungkurr-nyinaja. Ngula-jangkaju, Laatirliji ngayi-palangu purraja miyilki lalypa-nyayirni. Ngula-jangkaju, ngarnulkulu jintawarlayirli-jiki. ");
INSERT INTO wbp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","5","Laati manu nyampu-jarra marramarra-jarra kapulu jarda-jarriyarla-jala. Ngula-kujakuju, wati-patu Jatama-wardingki-patu, jintawarlayi-jikilpalu warrukirdikirdi purlanja-karra purlanja-karra wangkaja manu parnkaja warru yalumpurla yuwarlirlaju, “Nyarrpara-pala jirrama-kariji ngarrka-jarraju kuja kapala nyampurla nyuntu-nyangurla yuwarlirla ngunami? Kangkarni-palangu nganimpa-kurra yungurnalu-jana kurakukuraku-mani!” ");
INSERT INTO wbp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Junga-juku, Laatiji wilypi-pardijarni kaninjarni-jangkaju, ngula tuwaju pina wamany-kujurnu. ");
INSERT INTO wbp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Wangkaja-jana yapa panukuju, “Lawa, yampiyalu-palangu kurakukuraku-maninja-wangurlu! ");
INSERT INTO wbp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Nyampu karna-palangu ngaju-nyangu-jarra yurntalu-nyanu-jarra mardarni, ngula-jarra karna-nyarra yinyi yungunkulu-jana kurakukuraku-mani. Nyampu-jarraju kula-pala ngarrka-kurlu ngunaja kamparru-wiyi, lawa. Kala nyampu-jarra ngarrka-jarraju, yampiyalu-palangu! Jaarl-karri karna-palangu, pangkala-pala nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kuja-panuju, Laatijilpalu ngarrurnu kulungku wiringki mularrpa-nyayirnirli, purlajalurla, “Kuja warntarla-jarriya-nganparla jurnta! Ngananpa nyuntuju nganta? Yapa-karinpa nyuntuju kutukutu. Nyiyaku kanpa-nganpa yirrayirra-mani yalumpu-jarra-kujaku, manu kanpa-nganpa punku-pajirni? Ngayi kapurnalu-jana nganimparlu-wurru wurrangku-juku kurakukuraku-mani yalumpu-jarraju. Ngula-jangkaju, nyuntulku kapurnangkulu panungku mayangku-juku kurakukuraku-mani-yijala.” Junga-jukulpalu Laatiji ngurl-kanja-yanu pina tuwa-kurraju yungulu nganta tuwaju rdilyki-pungkarla. ");
INSERT INTO wbp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","11","Kala yangka marramarra-jarra kujalpa-pala nyinaja kaninjarni, ngula-jarrarlunya-pala tuwaju lakarn-pungu, manu-pala lakarn-maninjarla Laatiji wilil-manurnu waku-ngurlu kaninjarni-ngirlirliji. Kapulu tuwaju rdilyki-pungkarla yangka Jatama-wardingki-paturlu. Ngula-kujaku, tuwaju ngulaju-pala-jana jurnta pina wamany-kujurnu, manu-pala-jana milpakulku wapirrija. Ngulalpalu milpa-parntaju jarnkujarnku paa-karrija manu kawarr-karrija. Kujalpalu kawarr-karrija, ngulangkuju kulalu paniya-kurlurlu parlu-pungkarlalku tuwaju. ");
INSERT INTO wbp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ngula-jangkaju, marramarra-jarrarlu-pala payurnu Laatiji, “Nganarlangu nyuntu-nyangu-mayamaya-patuju nyampurla kirringkaju? Nyuntu-nyangurlangu ngalapi-nyanu-patu manu yurntalu-nyanu-patu mayi kalu nyina nyampurlaju kirringkaju manu nyuntu-nyangu lamparra-nyanu mayi? Yajaka-jana muku, manu yajarninjarla-jana yarujurlu kangka nyampu-ngurlu kirri-ngirli. ");
INSERT INTO wbp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nyampu kirri kapurlijarra jalangurlu-juku riwarr-pinyi. Kujakunya-jarrangku YAAWIYI-rliji yilyajarni kuja purda-nyanjarla milya-pungu jaru maju.” ");
INSERT INTO wbp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Junga-juku, Laatiji-palangu wapal-yanu lamparra-nyanu-jarraku-wiyi kuja-palangu yali jangku-pungu yurntalu-nyanu-jarraju. Junga-juku, parlu-pinjarla-palangu pututu-pungu, “Nyampu-ngurlu kirri-ngirli yarujulu parnkaya! Kapu ngayi YAAWIYI-rli riwarr-pinyi nyampuju kirri.” Kula-palarla ngungkurr-nyinaja Laatikiji kuja nyarrpa wangkaja. Kula-nganta ngari-kirla-palangu manyu-kirli wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Junga-juku, rangkarr-kurlu-wana, marramarra-jarrarluju-palarla pututu-pungu Laatikiji, wangkaja-palarla, “Yarujurlu-jana nguru-kangka nyuntu-parntaku manu nyuntu-nyangu-jarraku yurntalu-nyanu-jarraku! Kajinkili wilji-kirli nyina nyampurla kirringka, ngulaju kapu-nyarra YAAWIYI-rli riwarr-pinyi nyurrurlarlangu-juku, manu kaji nyampuju kirri riwarr-pinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Laatijilpa karrinjarla paa-karrija. Manngu-nyangulpa, “Nyarrpa-jarrirna? Nyinami-jukurna? Yani-japarna?” Kuja-kurra-kujaku-pala-jana marramarra-jarraju yarnkaja wakuku Laatiki manu nyanungu-parntaku karntaku manu yurntalu-nyanu-jarraku, manu waku-ngurlu maninjarla jirri-kanja-yanulkulu-jana wajirlirli-jiki kirri-ngirliji. Yuwayi, YAAWIYI-ji ngampurrpa-jarrija-nyayirni-jana muurl-mardarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kujalu kirri-ngirli wilypi-pardijarra yurlapardi-kirralku manangkarra-kurra, ngulangkanyarla wangkaja marramarra jinta-kariji Laatikiji, “Yarujulu parnkaya nyampu-ngurlunya! Kulalu nyampurla yarlu wirringka jupu-karriya, manu kulalu jupu-karrinjarla kulpari warirr-karrinjarla nyangka kirriji. Tarnngajukulu parnkaya yinya pirli-patu-kurra warlu wiri-kijaku.” ");
INSERT INTO wbp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Laatirliji-palangu jangku-manu, “Lawangka kujaju! Nyumpalanpajupala ngampangampa-nyayirni nyinaja, manunpajupala warrawarra-kangu manu wankaru mardarnu. Kulalparna parnkayarla yinya-kurraju wurnturu pirli wararra-kurraju. Kajilparna wurnturu yinya-kurra pirli-kirra parnkayarla, ngulaju kajikaju warlungkuju puranjarla mani-juku. ");
INSERT INTO wbp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yinya mayi kanpala kirri-pardu kutu nyanyi? Yinya-kurranyarna parnka kirri wita-kurra yungurna wuruly-nyina warlu-kujakuju.” ");
INSERT INTO wbp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Marramarrajurla wangkaja, “Yuwayi, ngula-juku parnkayalu yaruju-nyayirni wita kirri-kirra. Kularna riwarr-pinyi kirri yalumpuju. ");
INSERT INTO wbp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kajinkili yukamirra kirri wita-kurra, ngula-purunya kapurna riwarr-pinyilki nyampuju kirri wiriji.” Junga-juku, ngula-kurranyalu parnkanjarla muku yukaja yangka kirri wita-kurra yirdi-kirraju Jura-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Jungajukulu Laati-pinkiji mungalyurru yukajarra Jura-kurra kirri-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ngula-puru-juku warlulku kaninjarra-kari kujurnu YAAWIYI-rliji yangka-jarra-kurra Jatama-kurra manu Kumarra-kurra. Warlujulpa kujurnu yarturlu-piya jarra-kurlu kujalpa jankaja, ngulajulpa parntija pirrjirdi-nyayirni manu maju-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ngulangkunya karrkurrmirnti muku jankaja yapa manu yuwarli Jatamarlaju manu Kumarrarla manu kirri-kari kirri-karirla kujalpalu jarnkujarnku ngunaja yuwarli-kari yuwarli-kari, manu ngurra-kari ngurra-kari ngulaju-jana muku jankaja yangka yalirla wirringka, manu watiya muku-jana jankaja manu yukuri, marna manu walya. ");
INSERT INTO wbp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Yangka kuja-jana Laati jirrnganja parnkaja lani warlu-kujaku, nyanungu-parntaju jupu-karrinjarla kulpari nyangu kirri. Kuja kulpari nyangu, warlungkuju puranjarla-manu-juku manu muku jankaja palkaju, ngulajulpa tarnnga-juku juka-karrija palka-juku mingkirri wiri-piya-yijala kala ngayi yurlpulypa-piya jarlti-piya. ");
INSERT INTO wbp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Yangka Yipuruyamu kujalpa nyinaja nyanungu-nyangurla ngurrangka yatijarra, mungalyurru-pardu-karilki yakarra-pardinjarla yanu pirli-kirra yangka-kurra-yijala, kujalparla pirrarni wangkaja YAAWIYI-kiji. ");
INSERT INTO wbp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kuja ngurulku nyangu kurlirra-purda wirri wantiki-wana, kunjurulku parlu-pungu wiri-jarlu wurnturu-nyayirni, kujalpa-pala kirri-jarra rduyu-karrija manyangarnpa-piya. ");
INSERT INTO wbp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nyampunya yimiji Yipuruyamu-kurlu kujalpa Kaaturlu manngu-nyangu ngurrju jungarni, kula wajawaja-manu yangka kujarla kamparru-wiyi wangkaja. Kujarlaju Laati Yipuruyamukupurdangka-kurlangu muurlparlu mardarnu warlu-kujaku, kuja-palangu yangka kirri-jarra wiri-jarra karrkurrmirnti jankaja warlungku. ");
INSERT INTO wbp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Yangka Laati, kuja-palangu jirrnganja yukajarra kirri wita-kurra yirdi-kirra Jura-kurraju yurntalu-nyanu-jarraku, ngula ngari witakulpa nyinaja yalirla kirringka witangka warlu wiri-puru-wiyi. Lani-jarrija-juku-jalalpa, ngula-jangka jirrnganja yarnkaja-palangu pirli-kirralku, ngulangkanya-palangu jirrnganja yukaja pirnkingkalku, manulpalu nyinaja yalumpurla-juku tarnngalku. ");
INSERT INTO wbp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kapirdi-nyanujurla wangkaja ngawurru-nyanukuju, “Kari-nganta lawa-jana nyampurlaju watikiji. Kularli nyarrpararla kali-nyanuju parlu-pinyi. Nyampuju ngalikipalangu purlkalku. ");
INSERT INTO wbp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Pama mayirlirla jangkardu mani nyampuku purlkaku ngali-jarrakupalanguku yungu ngarninjarla warungka-jarrimilki? Ngula-jangkalkunya yungurlirla ngunanja-kurraku kurdu-yukami. Ngula-jangkanya yungurli palkakupalangu-jarrimilki.” ");
INSERT INTO wbp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Junga-juku, yangkangka jintangka mungangkaju-palarla yungulku pamaju. Junga-juku, pama ngarninjarla warungkalkulpa ngunaja Laatiji. Junga-juku, ngulakujurla kapirdi-nyanu-wiyi kurdu-yukaja. Ngunaja-pala. Kujaju kulalpa milya-pungu Laatirli, muwarnkulpa ngunaja. Kapirdi-nyanuju yangka karnta, yakarra-pardinjarlalku yanurla jurnta jardangkarni-juku. ");
INSERT INTO wbp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ngula-jangka parra-pardu-karirlalku, yimi-ngarrurnurla ngawurru-nyanuku yangka kuja-pala ngunaja munga-karirla. Yardarla wangkaja, “Yarda manirlirla jangkardu pama yarda warungka-maninjaku, yungunparla nyuntulku kurdu-yuka? Ngula-jangkanya yungunpa nyunturlangu palkakupalangu-jarri-yijala.” ");
INSERT INTO wbp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Junga-juku, jintangka mungangka-juku-palarla yarda yungu pamaju. Ngula-jangkanyalpa Laatiji pama ngarninjarla warungka-juku ngunaja. Junga-juku, ngawurru-nyanulkurla kurdu-yukaja. Ngula-pala ngunaja. Ngulaju kulalpa milya-pungu yangka jarlu-pardurlu Laatirliji. Jarda-jukulpa nyanunguju ngunaja purlkaju. Yangka karnta yakarra-pardinjarla yanurla jurnta jardangkarni-juku. ");
INSERT INTO wbp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Junga-juku, yangka karnta-jarraju-palarla palkakupalangu-jarrija marlaja nyanungukupalanguku-juku kirda-nyanuku-juku warlaljaku. ");
INSERT INTO wbp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kapirdi-nyanukujurla palka-jarrija kurdu wirriya, yirdijirla yirrarnu Muwapu. Kuja wiri-jarrijalku, Muwapujulpa-jana wiri-nyayirni nyinaja kirda-nyanu-piya warlalja nyanungu-nyanguku Muwapu-patuku kuja kalu jalangu nyinami-juku. ");
INSERT INTO wbp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ngawurru-nyanukujurla palka-jarrija wirriya-yijala, yirdijirla yirrarnu Pinami. Ngula wiri-jarrija Pinami, wiri-nyayirnilpa-jana nyinaja kirda-nyanu-piya-yijala warlalja nyanungu-nyangu-patukuju Yamuni-patuku kuja kalu nyinami-juku jalangu. ");
INSERT INTO wbp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Yangka Yipuruyamu kuja yanu Mamiri-kirlangu-kurra yapa warlalja nyanungu-nyangu-kurlu, Mamiri-kirlangu-ngurlu yarda-jana nguru-yirrarnu karlarra kurlirra jilja wiri-kirra yirdi-kirraju Nikipi-kirra. Ngulangkanyalpa-jana jirrnganja nyinaja ngurungka jiljangka kulkurru-jarra kirri-jarrakuju Katijiki manu Juuruku. Ngulangkanya-jana jalangu ngayi jirrnganja nyinajarra, ngula-jana yarda jirrnganja yarnkaja yatijarra-purdalku kirri-kari-kirra yirdi-kirraju Karara-kurra. Ngulangkalpa-jana tarnngalku jirrnganja nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Yalirla kirringka Karararlaju, ngulajulpa kingi wiri nyinaja yirdiji Pimaliki. Yipuruyamu kuja yukajarra kirri-kirra, ngulajulpa-jana warru yimi-ngarrurnu Jiiraju nganta nyanungukupurdangkalku nganta ngawurru-nyanu. Kala nyanungu-parnta-jala karnta. Kuja kingirli purda-nyangu kuja yimi Yipuruyamu-kurlangu, ngulakuju-jana yilyaja nyanungu-nyangulku warrkini-patu maninjininjaku Jiirakulku. Junga-juku, maninjarla kangurnulu pina kingi-kirlangu-kurra yuwarli-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Jintangka mungangka, Pimalikijilpa jarda ngunaja. Ngula-kurraju-kurla Kaatuju yanurnu jukurrparla, manurla wangkaja, “Nyuntu Pimaliki kapunpa palimi-jala kujanparla karnta jurnta kangu Yipuruyamuku lijijarlu. Nyanunguku-jalarla karnta.” ");
INSERT INTO wbp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pimalikirli jangku-manu Kaatuju, “Kularlijarra ngunaja, manu kularna pampirlji-pungu. Yapa ngaju-nyangu, ngulaju kalu jungarni-jala nyina! Nyarrparlanpa-nganpa muku pinyi? ");
INSERT INTO wbp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Wangkajaju-pala nganta wati manu karnta, watijiji wangkaja nyampuju nganta nyanungukupurdangka ngawurru-nyanu. Nyampulkuju karnta wangkaja nganta yalumpuju nganta nyanungukupurdangka papardi-nyanu. Kujarlanyarna kangurnu nyampu-kurraju ngurrpangku-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kaaturlulku jangku-manu Pimalikiji, “Milya-pinyi karnangku kujanpa ngurrpangku karalyarr-karrinja-wangurlu karnta yalumpuju yampija manu pampirlji-pinja-wangurlu. Kulanpa karalyarr-karrija nginyinginyirla manu kurturdurrurla manu miyalurla. Kuja-kujakujurnangku ngajulurluju warla-pajirninjarla kapakapa-manu ngunanja-kujaku manu ngaju-nyangu-kujaku kuruwarri-kijaku rdilyki-pinja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nyampuju wati Yipuruyamu ngaju-nyangu warrkini jarukungarduyu. Pinarla yungka yalumpu karnta. Kajinpa wiljingki-jiki warla-pajirninjarla mardarni, ngulaju kapurna-nyarra muku pinyi nyuntu manu nyuntu-nyangu yapa warlalja manu nyuntu-nyangu warrkini-patu. Kala kajinparla pina-yinyi karnta nyanungu-nyangu, ngula-jangka kapuju payirnilki Yipuruyamurluju yungurna-nyarra wankaru-juku yampimi.” ");
INSERT INTO wbp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mungalyurru-pardu-karilki wanta pardinjakungarnti, Pimalikirliji-jana yakarra-pardinjarla yapa nyanungu-nyangu turnu-manu. Ngula-jangka, yimi-ngarrurnu-jana jukurrpa jukurr-maninja-warnu. Kujalu yimi jukurr-maninja-warnu purda-nyangu munga-jangka Pimaliki-kirlangu, ngulajulu kanunjumpajumpa-nyayirni lani-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Junga-juku-jana yilyaja Pimalikirliji ngalya-kari warrkini-patu yajarninjaku Yipuruyamuku. Manunjunulu, maninjarlalu kangurnu pina Yipuruyamuju Pimaliki-kirlangu-kurra yuwarli-kirra. Ngula-jangka Pimalikirli payurnu, “Kularnangkulu murrumurru-manu. Nyiya-jangkarlunpa-nganpa warlkangku yimirr-yungu kuja nganta Jiiraju ngawurru-nyanu nyuntukuju? Kujaju maju-nyayirni yimirr-yinjakuju! Kujarlanya kajika-nganpa Kaaturluju muku pinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Yipuruyamurluju jangku-manu Pimalikiji, “Kujarna nyuntu-nyangu-kurra kirri-kirra yukajarni, ngulajurna manngu-nyangu manu wangkajarnaju kuja, ‘Kula-ka nganangku linpangku purda-nyanyi Kaatuju nyampurlaju kirringka. Kula karla ngana lani-jarri nyanunguku. Kujarlaju kapujulu pinyi, manu ngula-jangkaju kapujulu jurnta kanyi nyampuju ngaju-parnta karnta.’ Kujarlanyarnangku yimirr-yungu. ");
INSERT INTO wbp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Nyampuju karnta ngajukupurdangka-juku ngawurru-nyanu. Jinta-juku karlijarra mardarni kirdarnaju. Ngati-nyanuju karlijarra-jana jinta-mirnimirni jarnku-mardarni. Ngula-jangka kujarlujarra yupukarra-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Nyurru-wiyi Kaatuju wangkajaju yampinjaku nguru ngaju-nyanguku kamparru-warnukuju. Kujarna-jana jirrnganja yarnkaja yali-ngirli nguru kamparru-warnu-ngurlu, manurna-jana jirrnganja warru wapaja nguru-kari nguru-kari, ngulajurnarla wangkaja Jiirakuju kuja, ‘Kajilpanpaju junga-nyayirni yulkayarla, ngula-jangka yungulpanpaju purda-nyangkarlalku nyarrpa kajirnangku wangkami. Kajinpa-jana yapa-kari ngana-puka nyanyi, ngulaju-jana wangkaya ngajujurnangku nyuntukupurdangka papardi-nyanu nganta. Kulaju wurra-manta!’ Kujarnarla wangkaja Jiirakuju.” ");
INSERT INTO wbp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","15","Junga-juku, Pimalikiji wangkajalkurla, “Yuwayi ngula-juku, ngurrju kujaju.” Junga-juku, yungulkurla jiyipi-wati, puluku-wati manu warrkini-patu wati-patu manu mardukuja-patu, manu ngula-jangka kulparirla yungu Jiira Yipuruyamuku, manu talarla yungu. Wangkajalkurla, “Nyampuju nguru warrukirdikirdi ngajuku-kirli. Kajinparla nyarrparaku-puka nguruku ngampurrpa nyina, ngulaju yalumpurla-juku-jana kutu jirrnganja nyinaya.” ");
INSERT INTO wbp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ngula-jangkaju, Pimalikiji wangkajalkurla Jiirakulku, “Nyampunya karnarla tala 1,000-pala pamarrpa-wati yinyi nyuntu-parntaku kurntangku, manu nyuntu karnarla pina-yinyi. Manu nyuntuju kulangku nganangkulku yarda ngawu-pajirni manu kurnta-ngarrirni, lawa. Kapungkulu jungarni-pajirni-puka.” ");
INSERT INTO wbp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Kaatu kulalparla wardinyi-wiyi nyinaja Pimalikiki kuja yangka karnta Yipuruyamu-kurlangu manu Jiira. Kujarlaju-jana murrumurru-manu karntakarnta yangka Pimaliki-kirlangu warrkini-patuju kurdu-kujaku mardarninja-kujaku. Junga-juku-janarla Yipuruyamurluju kaji-payurnu Kaatulku Pimaliki-parntaku manu nyanungu-nyangu-mayamayaku yungu-jana wankaru-juku murrumurru-maninja-wangurlu yampimi. Junga-juku, Yipuruyamuju purda-nyangu payirninja-kurra, manu karnta-jana Pimaliki-mayamaya ngurrju-manu pina-palkakupalangu-jarrinjaku. Ngakalku junga-juku, karntakarntarlujulu-jana kurdukurdulku panu manu. ");
INSERT INTO wbp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ngula-puru-juku, Jiirajulpa manngu-nyangu YAAWIYI-rliji kujarla yangka nyurru-wiyi jangku-pungu kurdu wirriya. ");
INSERT INTO wbp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Jiiraju kujalpa nyinaja muturna-nyayirnilki, ngulaju kurdukupalangu-jarrijalku. Yangka kujarla jangku-pungu nyurru-wiyi Kaaturlu, 9-pala kirntangi-pala-jangka, kurdulkurla palka-jarrija wirriya. ");
INSERT INTO wbp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Yipuruyamurluju, yirdijirla yirrarnu Yijaki. ");
INSERT INTO wbp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ngula-jangkaju, Yipuruyamurluju ngarrka-kujurnu pirltirrka-juku wiyiki jinta-jangkarla kujarla Kaatuju wangkaja kamparru-wiyi ngarrka-kijirninjakuju. ");
INSERT INTO wbp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ngula-puruju, Yipuruyamukujurla rdipija 100-pala yulyurrpu purlka-nyayirnikilki. ");
INSERT INTO wbp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ngula-jangkaju, Jiiraju wangkaja, “Kujaju yungu kurdu wirriya muturnakulku, kujarlanya karnarla marlaja ngarlarrimi. Kajijili yapa ngalya-karirli purda-nyanyi kuja karna kurdu wita wirriya mardarni, ngulakuju kapulu ngarlarrimi, manu ngulakuju kapujulu wardinyilki nyinami. ");
INSERT INTO wbp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Nyurru-wiyi ngana kularla wangkayarla Yipuruyamukuju kujaju, ‘Kapu mardarni nyuntu-parntarlu karntangku kurdu wirriya, manu kapurla lampurnu yinyi muturnarlu.’ Kala jalangurlu karna ngajulurlu muturnarlu kurdu wirriyaju mardarni.” ");
INSERT INTO wbp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kuja wirriya yangka Yijaki wiri-jarrijalku, ngulakujurla ngati-nyanuju lampurnuju lawa-jarrijalku. Kujarla lampurnu witaku lawa-jarrija, kujarlaju kurapakalku yirrarnu wiri-jarlu-nyayirni miyi manu kuyu Yipuruyamurluju. ");
INSERT INTO wbp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ngulangka kurapakarla, palka-yijalalpa-pala ngamarlanguju nyinaja yangka Yipuruyamu-parnta-yijala yirdiji Yakarru manu nyanungu-nyangu kurdu-nyanu yirdiji Yijimali. Ngula-jangka, Yijimalijilpa manyu-karrija. ");
INSERT INTO wbp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kuja Jiirarlu nyangu Yijimali manyu-karrinja-kurra, ngulajurla muntuku-jarrija-nyayirni kululku. Manurla yaninjarla wangkaja Yipuruyamukuju, “Yilyaya-palangu ngamarlangu ngati-nyanu manu kurdu kapankurlu. Kajirna kali-puka-jarri, kulangku Yijimalirli marlaja mani nyiyarningkijarraju nyuntu-nyangu kujangu-jangkaju. Ngaju-nyangurlu-puka kurdungku kapungku marlaja mani kujangu-jangkaju nyiyarningkijarra manu yampinyi.”. ");
INSERT INTO wbp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Yipuruyamurluju kuja purda-nyangu Jiira wangkanja-kurra, ngula-jangkaju, mari-jarrijalkurla Yijimalikiji kujalparla nyanungurlanguku yulkaja. Kula-palangu yilyayarla ngamarlangu ngampurrparlu. ");
INSERT INTO wbp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kaatulkurla wangkaja Yipuruyamukuju, “Kula-palangu wajampa-jarriya ngamarlanguku Yakarruku manu Yijimalikiji. Kajingki nyarrpa-puka wangka Jiira, ngulaju-palangu kapankurlu yilyaya yalumpu-jarra-kariji. Kujarnangku yangka jangku-pungu kaja-nyanu nyurru-wiyi nyuntuku, ngulaju Yijaki-jala. Ngula-kurlangu kurdukurdu kapulu panu palka-jarri jaya-kurra-nyayirni. Ngulajulu ngaju-nyangu yapa warlalja. ");
INSERT INTO wbp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Yalumpu Yijimali, ngulaju nyuntu-nyangu-yijala kaja-nyanu. Kapu-jana panuku-yijala kirda-nyanu nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Junga-juku, mungalyurru-pardu-karirlaju, yungulkurla miyi kapu ngapa pintingka yakuju-piyarla pilikutu-jangkarla nyanungu-parntakuju Yakarrukuju. Ngapa yangka pintingka pilikutu-jangkarla, ngulajurla jarna-maninjarla yirrarnu jimantarla Yakarru-kurlangurla Yipuruyamurluju. Ngula-kurlunya-palangu yilyajalku ngamarlangu Yakarru manu Yijimali. Jirrnganjarla warru wapakarra yaninja-yanu jilja-wana parduna-wana yirdi-wana Piirrjipa-wana. ");
INSERT INTO wbp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ngapa yangka kuja kangu pintingka pilikutu-jangkarla, ngulaju-pala muku ngarnu kulkurrukulkurru-juku. Ngula-jangka, kurdu wirriyaju ngapa-wangurlalku mata-jarrija. Ngula-jangka, ngati-nyanurlulkurla yama-kurra kangu ngula yamangkalku yirrarnu. Yamangkalkulpa ngunaja nyurnu yulanja-karra. ");
INSERT INTO wbp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ngati-nyanuju yanu yama-kari-kirra marilki ngulalpa nyinaja yama-pardu-karirla. Wangkaja-nyanu Yakarruju, “Kulalparna nyiyakulku tarda-nyangkarla palinja-kurraju.” Mariji yulajalku. ");
INSERT INTO wbp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kaaturluju purda-nyangu wirriya kurdu yulanja-kurraju. Ngula-jangkaju, purlajarla ngati-nyanukulku, “Yuwa, nyiyarla kanpa muntuku-jarrinjarla yulami? Lani-jarrinja-wangu nyinaya, ngulajurna nyurru purda-nyangu nyuntu-nyanguju kurdu wirriyaju yulanja-kurraju yamangkaju. ");
INSERT INTO wbp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kulpari maninjinta kurdu nyuntu-nyangu. Maninjarla ngamirljirli mardaka. Ngulaju kaji wiri-jarri, kapu-jana nyina kirda-nyanu panuku nyanungu-nyanguku yapaku.” ");
INSERT INTO wbp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Junga-juku, Kaaturlujurla muljulku milki-yirrarnu Yakarrukuju. Junga-juku, ngula yangka-kurra pinti-kirra turla-maninjarla ngapalku-yijala pina winjurnu. Winjirninjarla ngapajurla yungu kurdukuju. ");
INSERT INTO wbp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Junga-juku, yangkaju Yijimali, Kaaturlujulpa warrawarra-kangu. Kuja wiri-jarrija manu wati-jarrija, ngulajulpa kuyu-pungu-nyayirni nyinaja. Kala kuyu panturnu pikirri-piya-kurlurlu ");
INSERT INTO wbp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Kala nyanunguju nyinaja jiljangka yirdingkaju Paranarla. Ngularla ngati-nyanurlu-juku maninjarla yungu karntaju Yijipi-wardingki nyanungukuju Yijimalikiji. ");
INSERT INTO wbp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Yangkajulpa Yipuruyamuju nyinaja-juku ngurungka Pimaliki-kirlangurla. Parra-pardu-karirlalku, Pimalikiji yanurnurla jirrnganja jintaku ngarrkaku yirdikiji Payikuluku Yipuruyamu-kurlangu-kurraju. Yirdi nyampuju Payikulu, ngulaju kala-jana wiri nyinaja jinjinja-kurlangu warrmarlakuju Pimaliki-kirlanguku. Yaninjarla-palarla wangkaja Yipuruyamuku, “Nyarrpa-jarri-puka kuja kanpa nyiyarningkijarrakuju, ngula-kurraju kangku Kaaturluju pirrjirdi-maninjarla warrawarra-kanyi. ");
INSERT INTO wbp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Nyampurla-juku kuja kangalpa Kaaturlu nyanyi manu purda-nyanyi wangkanja-kurra, kula-nganpa warlkangku yimirr-yungka ngaju manu ngaju-nyangu-purnu manu ngaju-nyangu kurdukurdu-kurlangu-mayamaya. Kujanpa yanurnu nyampu-kurra nguru ngaju-nyangu-kurra, rarralypalparnangku nyinaja ngurrju. Kajinpajurla jalangu rarralypa-yijala ngungkurr-nyina, ngulaju ngurrju.” ");
INSERT INTO wbp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Junga-juku, Yipuruyamurluju jangku-manu Pimalikiji, “Yuwayi, junga karnangku wangka, ngurrju karnangku rarralypa nyina. ");
INSERT INTO wbp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kala milya-pinyinya kanpa kujalu-jana ngaju-nyangu warrkini-patu manu puluku manu jiyipi wajirli-pungu yangka yali-ngirli ngapa mulju-ngurlu nyuntu-nyangu-paturlu kulungkuju? Kulalu nyarrpalku pina-yani mulju-kurraju ngaju-nyanguju jiyipi manu puluku.” ");
INSERT INTO wbp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Pimalikirliji jangku-manu, “Lawa, kulajulu kujaju yimi-ngarrurnu. Ngaka jalangu kanpaju yimi-ngarrirni.” ");
INSERT INTO wbp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Yipuruyamurluju jangku-manu, “Ngulaju ngula-juku.” Ngula-jangkaju, Yipuruyamurluju turnu-manulku-jana jiyipi, puluku. Ngula-jangka, yungulkurla ngalya-kariji Pimalikikiji warntarri. Jarnkulku-pala-nyanu ngungkurr-nyinaja rarralypaku nyinanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Junga-juku, Yipuruyamurluju-jana ngalya-pangurnu wirlki-pala jiyipi ngama-patu-mipa. ");
INSERT INTO wbp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Pimalikirliji payurnu Yipuruyamuju, “Nyarrparlanpa-jana ngalya-pangurnu nyampu-patuju jiyipi-patu?” ");
INSERT INTO wbp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Junga-juku, Yipuruyamuju wangkajalkurla, “Nyampu-patu jiyipi-patu kajinpa-jana maninjarla kanyi ngurra nyuntu-nyangu-kurra, kujaju kanpajurla ngungkurr-nyina ngajukuju yangkaju mulju ngulaju ngajukulku kujarna nyurru-wiyi pangurnu muljuju.” ");
INSERT INTO wbp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","32","Junga-juku, Pimalikirliji maninjarla kangulku-jana jiyipi-patuju, manurla wangkaja Yipuruyamukuju, “Yuwayi, yangkajungku muljuju ngulaju nyuntukulku.” Junga-juku, ngula-jangkaju, Pimaliki manu Payikulu karrinja-pardinjarla yarnkajalku-pala wungu nguru-kurraju Pilijiya-wardingki-patu-kurlangu-kurra. Junga-juku, ngula-jangkaju, Yipuruyamurluju yirdijirla yirrarnu muljukuju ‘Piirrjipa’. Nyanungu-nyangurla jarungka-ka nguna yirdi muljuju ‘Ngungkurr-nyinaja-pala-nyanu Muljuku’. Ngulangkanya kuja-pala-nyanu ngungkurr-nyinaja rarralypaku nyinanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Yangka yalirla ngurungka Piirrjiparla, watiya jinta karlanjarla yirrarnu kirrirdimpayi, ngulangkanyalparla yunparninja-karrarluju pulka-pungu YAAWIYI-kiji JUKURRARNU-kuju. ");
INSERT INTO wbp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Yangkaju Yipuruyamu, kutukutu nyinajalpa warrarda yalirla-juku tarnnga-juku ngurungka yapa-kari-kirlangurla Pilijiya-wardingki-patu-kurlangurla. ");
INSERT INTO wbp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ngaka-pardu-karilki, Kaaturluju waalparrurnu Yipuruyamuju junga-japa kajilparla nyanunguku wala nyinaja kapuru-wangu-japa. Kaatuju wangkajalkurla, “Wayinpa, Yipuruyamu.” Junga-juku, Yipuruyamurluju jangku-manu, “Yuwayi, nyampu karna ngajuju nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kaaturla wangkaja yarda, “Yangka nyuntu-nyangu ngalapi-nyanu Yijaki, yangka kuja kanparla nyuntulu ngula yulkami-nyayirni, ngulaju maninjarla kangka nguru-kurra yirdi-kirraju Muriya-kurra. Yalirlanya kapurnangku pirli wararra milki-yirrarni. Ngulangkanya pantika yangka nyuntu-nyangu ngalapi-nyanu, manu warlungkuju ngajuku yingkirninjarla purraya warntarri.” ");
INSERT INTO wbp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Junga-juku, Yipuruyamuju mungalyurru-pardu-karirlalku yakarra-pardija, manu yakarra-pardinjarla tangkiyi rdarri-mardarnu. Jatirlilkirla yirrarnu. Ngula-jangkaju, warrulpa manu jiwirri, turnu-manu jiwirri, ngula turnulku yirrarnu tangkiyirlaju. Manu nyanungu-nyangu ngalapi-nyanu Yijaki yajarnu manu-palangu nyanungu-nyangu-jarra warrkini-jarra. Yajarninjarla-jana nguru-yirrarnu yangka-kurraju Muriya-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ngulaju parra-jarra jirrama-jangka yaninja-yanulu kulkurrukulkurru-juku. Ngula-jangkaju, parra-pardu-karirlalku, Kaaturlujurla Yipuruyamuku milki-yirrarnulku pirli wararraju wurnturu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Yipuruyamu wangkaja-palangu nyanungu-nyangu-jarraku warrkini-jarraku, “Nyampurla-juku pardakalu-jarrangku tangkiyi-kirliji kajirna nyampu kurdu wirriya kanyi yinya-kurra pirli wararra-kurra, ngulangka yungurlijarrarla warntarri kuyu purrami Kaatuku. Karlijarra ngaka kulpari yanirni.” ");
INSERT INTO wbp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Junga-juku, jiwirriji rurruny-pungulku tangkiyi-jangkaju Yipuruyamurluju, ngularla rurruny-pinjarla jiwirriji purturlurla yirrarnu ngalapi-nyanurla. Nyanungurlujulpa mardarnu ngiji manu junma rdakangka, ngulalpa nyangu pirli wararraju wurnturu-kurra. Ngula-kurranya-pala kirdarlangu yanu. ");
INSERT INTO wbp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ngula-jangkaju, payurnulku nyanungukupalangu kirda-nyanuju Yijakirliji, wangkajarla, “Ngiji manu jiwirri palka-jala karli mardarni. Kala nyarrpara jiyipi yungurlurla yingkirninjarla purrami warntarriji Kaatuku?” ");
INSERT INTO wbp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Yipuruyamuju wangkajarla Yijakikiji, “Kaaturlu kapu-nyanu jiyipiji parlu-pinjarla kanyirni warntarriji yungurlirla purrami nyanunguku.” Junga-juku, yaninja-yanu-pala yarda wurra-juku. ");
INSERT INTO wbp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kuja-pala pirli-kirra yanu, Yipuruyamurluju warrulpa turnu-manu yarturluju. Murnju-yirrarninja-parnkajalpa yurturlurla jintangka, manu ngula-jangkaju yangkajurla jiwirri ngalapi-nyanukuju puntarnulku. Puntarninjarla yirrarnu yangkangka yurturlurla kankarlarni yarturlurla. Ngula-jangkaju, waku-jarralku wayurnu nyanungu-nyangu-juku ngalapi-nyanu. Jakurr-maninjarla kankarlarni yirrarnulku yangkangka yarturlurla manu jiwirrirla. ");
INSERT INTO wbp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Junga-juku, junmalku wilypi-manu Yipuruyamurluju nyanungu-nyangu-jangka wirriji-jangkaju yungu pantirni. ");
INSERT INTO wbp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Wakuju kankarlu-jarrijalku pantirninjakungarntilki. Ngula-pururla yalkiri-ngirli yirdi-manu marramarrarlu YAAWIYI-kirlangurlu, “Yipuruyamu, Yipuruyamu!” Yipuruyamurlu jangku-manu-yijala, “Yuwayi, nyampurna.” ");
INSERT INTO wbp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Marramarrajurla wangkaja, “Pantirninja-wangurlu yampiya nyuntu-nyangu ngalapi-nyanu wiyarrpa! Yuwayi, junga karnangku milya-pinyilki nyuntuju kuja kanparla ngungkurr-nyina Kaatuku. Kulanparla jurnta mardarnu wiljingki nyuntu-nyanguju marulu ngalapi-nyanuju.” ");
INSERT INTO wbp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Junga-juku, Yipuruyamurluju karrinjarlalpa yirrilki warru nyangu. Junga-juku, parlu-pungulku jiyipilki wiri wirriya watiyarla kuja purlkunparla rdarrparl-wantija marlpirntirri-jarraju. Kula nyarrpalku wilypi-pardinjarla parnkayarla. Junga-juku, Yipuruyamujurla jiyipiki jangkardu yanurra. Jakurr-maninjarla yirrarnulku kankarlarni yangka jiwirrirla. Junga-juku, yingkirninjarla purrajarla Kaatuku warntarri kuyuju. Kujaju ngulajurla kunka-pardija jiyipiji yangkaku Yijakiki Yipuruyamuku ngalapi-nyanuku. ");
INSERT INTO wbp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ngula-jangkaju, yangka pirli wararra ngulaju Yipuruyamurluju yirdikirla yirrarnu, yalirla yangkangka kuja kapu ngalapi-nyanu pungkarla. Ngulaju yirdiji, ‘Kapuju Nyiyarningkijarra Tarnngangku-juku Warrarda Rdanjarr-yinyi YAAWIYI-rliji’. Jalangu-jarra ngulaju kalu-nyanu wangka yapa-patu, ‘Wararrarla YAAWIYI-kirlangurla Kapu-ngalpa Nyiyarningkijarra Warrarda Rdanjarr-yinyi’. ");
INSERT INTO wbp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yarda-yijalarla purlaja Yipuruyamukuju YAAWIYI-kirlangu marramarraju kankarlarra yalkiri-ngirli, ");
INSERT INTO wbp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","17","“Nyampunya kangku wangka YAAWIYI-ji kuja. ‘Nyampunya karnangku junga wangka yirdingka ngaju-nyangurla. Kapurnangku pirrjirdi-maninjarla warrawarra-kanyi. Kapurnangku yinyi kurdukurdu panu-jarlu kujanpaju yangka kurdu nyuntu-nyangu ngalapi-nyanu yungu jurnta mardarninja-wangurlu. Kurdukurdu nyuntu-nyangu kapulu jaya-kurra-nyayirni nyina nyampu-piya yanjilypiri-piya manu yarturluyarturlu-piya witawita-nyayirni kuja-ka pirlpirl-nguna karrungka. Kajili-jana yapa-kari jangkardu yanirni kurdukurduku nyuntu-nyanguku, ngulaju nyuntu-nyangu-paturlu kapulu-jana pinyi. ");
INSERT INTO wbp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kujalpanpaju nyuntu wala nyinaja ngajuku kapurunju-wangu, kujarlaju nyuntukuju kapungkulu wardinyi marlaja nyinami nyuntu-nyanguju kurdukurduju. Ngula-jangkaju, nyuntu-nyanguku kurdukurduku kapulu-jana yapa-kari panu-nyayirni marlaja wardinyi nyina-yijala kujarla yalarnirla nguru-kari nguru-karirla.’” ");
INSERT INTO wbp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Junga-juku, ngula-jangkaju, jirrnganjarla pina-yanulku Yipuruyamuju nyanungu-nyanguku ngalapi-nyanuku yangka-jangkaju pirli wararra-jangka. Pina-pala-jana yanu yangka-jarraku warrkini-jarraku. Ngula-jangkaju, panulkujukulu pina-yanu yangka-kurra mulju Piirrjipa-kurra. Yalumpurla-jukulpa-jana jirrnganja nyinaja nyanungu-mayamayakuju. ");
INSERT INTO wbp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ngakarranyilki, yapajurla jinta yanurnu nguru-kurraju Yipuruyamu-kurlangu-kurra jaru-kurlu. Junga-juku, wangkajalparla manu yirri-purajarla, “Nyuntukupurdangkarluju yangkangkuju kukurnu-purajirli yirdingki Nayururlu manu nyanungu-parntarlu yirdingki Milkayarlu, ngulaju kapala-jana wirriyawirriyaju mardarni 8-pala. ");
INSERT INTO wbp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","22","Yirdijili nyampu-patunya: Yuuju manu nyanungukupurdangka-patu kukurnu-nyanu-patu yirdi-patuju Puuju, Kimulu, Kijirdi, Yaaju, Piltaji, Jirtilapi, manu Pijulu. Ngulajulparla yangka Kimuluju kirda-nyanu nyinaja Yarramaku. ");
INSERT INTO wbp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Yangka jinta-kari kaja-nyanu Nayuru-kurlangu yirdiji Pijulu, ngulaju palkakupalangu-jarrija-yijala ngulaju karntakupalangu yirdikipalanguju Ripikakupalangu. ");
INSERT INTO wbp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nayururluju jinta karnta-karilki yarda manu yirdiji Ruuma. Ngulakujulurla palka-jarrija kurdu-patu-yijala jirrama-kari jirrama-kari yirdiji Tiipa, Kayama, Tayaja, manu Maaka.” ");
INSERT INTO wbp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Kujarla Jiiraku rdipija 127-pala yulyurrpu, muturna-nyayirni nyanunguju palija ngurrangka yirdingkaju Kiri-Yarrparla yangka ngurungka Kananarla. Jinta-kari yirdi yinya ngurraku ngulaju Yipurana. Yipuruyamuju yaninjarla yulajalparla ngumparna-nyanuku kuja palija. Nyanunguju nyinajalpa nyanungu-nyangu palka-wana wajampa-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ngakalku, karrinjarla yanu-jana Yititi-patuku wiriwiriki kujalpalu nyinaja yinyarla ngurrangka. Nyinajalpalu mapirri kiirtirla kutu kirri wiriki. Nyanungujulpa nyinaja nyanungurra-kurlu, manu wangkaja-jana, ");
INSERT INTO wbp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nyampu ngurrara ngulaju nyurrurlaku. Ngari ngajuju yapa-kari. Yungurna-nyarra wita payirni jalangurlu. Yinyinyankujulu nguru wita talakupurdarlu yungurna milyingka yirrarni ngaju-parnta?” ");
INSERT INTO wbp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Yititi-paturlulu jangku-manu Yipuruyamuju, ");
INSERT INTO wbp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Purlka-pardu, nyuntujunpa paaju wiri-piya nganimpakuju. Nganimparlu karnalu jarnkujarnku mardarni nguruju yangka nganimpa-nyangu warlalja. Kajinpa-nganpa payirni, nganangku kulalpangku jurnta mardakarla nguruju. Yimirirli kapurnangkulu yinyi yungunpa nyuntu-parnta milyingka yirrarni.” ");
INSERT INTO wbp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yipuruyamuju-jana parntarrinjarla wangkaja Yititi-watiki, ");
INSERT INTO wbp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Kajinkili ngampurrpa nyina ngajuku yungurna milyingka yirrarni ngaju-parnta nyurrurla-nyangurla ngurungka, wangkayajulurla Yipiraku. Nyanunguju Juuruku kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Nyanungu-nyangurla ngurungka, pirnki wita-ka karri ngurrangka Makapilarla. Kajiji ngungkurr-nyina ngajuku pirnki-wanawana, ngulaju kapurnarla yinyi tala. Nyurrurlarlujulu nyangka tala kajirnarla yinyi yungunkulu milya-pinyi yinya pirnki kaju karri ngaju-nyangulku. Yungurna milyingka yirrarni ngaju-parnta.” ");
INSERT INTO wbp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Yinya wati Yipira, nyinajalpa Yititi-patu-kurlu wiriwiri-kirli kiirtirla. Purda-nyangu Yipuruyamu wangkanja-kurra, wangkajarla Yipuruyamuku, ");
INSERT INTO wbp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Purlka-pardu, purda-nyangkaju. Panungku kajulu purda-nyanyi ngaju nyuntuku wangkanja-kurra. Ngajulurlu kapurnangku yinyi wita nguru manu pirnki. Ngula karnangku yinyi yungunpa milyingka yirrarni nyuntu-parnta.” ");
INSERT INTO wbp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ngula Yipuruyamuju parntarrinjunu kamparru yangka Yititi-paturla wiriwirirla. ");
INSERT INTO wbp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Wangkajarla Yipiraku, “Lawa, purda-nyangkaju ngaju. Kulalparnangku jurnta kangkarla nguru ngari tala-wangurlu. Yungurnangku tala yinyi ngurukungarduyuku. Mpa, kangka nyampu tala! Yungurna yaninjarla milyingka yirrarni ngaju-parntalku.” ");
INSERT INTO wbp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ngularla Yipira wangkaja Yipuruyamuku, ");
INSERT INTO wbp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Purlka-pardu, lawarna wiljiwilji-maninjaku nyuntukuju! Kajinpaju yinyi 400-pala tala pirli, kapurnangku yinyilki nguruju yungunpa nyuntu-parnta milyingka yirrarni yinyarla.” ");
INSERT INTO wbp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Junga, Yipuruyamujurla ngungkurr-nyinaja Yipirakuju, manurla yungu 400-pala tala pirli. Yititi-patu wiriwirirlilpalu-jana nyangu. Kujarlunya kalalu nguruju jali-manu talakupurdarlu nyurru-wiyiji. ");
INSERT INTO wbp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Yuwayi, kujalpalu nyinaja kiirtirla yinya Yititi-patu wiriwirirli, ngulajulu nyangu Yipuruyamu kujarla tala yungu Yipiraku. Kujarla Yipuruyamurlu yungu tala Yipiraku, Yipirarlurla jali-manu nguru wita yinya ngurungka yirdingka Makapilarla. Makapilaju, ngulaju kakarru jinta-kari nguruku yirdikiji Mamiriki. Junga, Yipuruyamuju warlaljamarrilpa nyinaja yinya nguru witaku manu pirnkiki manu watiya-watiki kujalpalu karrija yinyarla. ");
INSERT INTO wbp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ngula-jangka, Yipuruyamuju yaninjarla milyingka yirrarnu ngumparna-nyanuju yangka ngurrangka Makapilarla kutu Mamiriki. Yangka ngurra Makapila, ngulajulpa karrija ngurungka Kananarla. Ngaka kalalu yapangkuju yirdi-manu ngurra yinyaju Yipurana. ");
INSERT INTO wbp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Panungkulpalu milya-pungu yinya nguru-pardu manu pirnkilparla karrija Yipuruyamukulku. ");
INSERT INTO wbp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ngulajulpa nyinaja Yipuruyamu jarlu-pardu-nyayirnilki. Ngulaju YAAWIYI-rliji warrarda-jukulpa pirrjirdi-maninjarla warrawarra-kangu, manulparla nyiyarningkijarra yungu. ");
INSERT INTO wbp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Parrangka jintangka, Yipuruyamuju wangkajarla nyanungu-nyangu warrkiniki jintaku wiriki kujalpa-jana kamparru wiri-juku nyinaja warrkini-patu-kariyi-nyanuku, wangkajarla, “Nyuntu-nyangu rdaka-nyanu yirraka kanunjumparra wanarri-jarrarla ngaju-nyangurla. ");
INSERT INTO wbp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Kujarluju kanpaju ngarrirni yapirli-nyanuku maninjaku ngaju-nyanguku ngalapi-nyanuku Yijakiki. Nyampurla-jukuju jungarnirli jangku-manta kuja kangali YAAWIYI-rli nyanyi manu purda-nyanyi, yangka Kaatu kuja-ka wiri-jiki nyina nyiyarningkijarraku yalkiriki manu walyaku. Nyampurla Kananarla ngulaju maju-nyayirni kalu nyina nyampu-wardingki-patuju karntakarnta, ngulaju-jana milarninja-wangurlu yampiya. ");
INSERT INTO wbp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Wangkayaju yungunpa pina-yani yangka-kurra ngaju-nyangu-kurra ngurra-kurra kujarna yangka ngaju palka-jarrija. Ngulangkanya kapunparla parlu-pinyi yapirli-nyanuju ngaju-nyanguku ngalapi-nyanuku, manu milarninjarla kangkarnirla.” ");
INSERT INTO wbp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Junga-juku, jangku-manu Yipuruyamuju yangkangku warrkinirli nyanungu-nyangurlu, “Yuwayi, ngulaju ngula-juku. Kala kajirna yani ngurrara nyuntu-nyangu-kurra, manu kajirna milarni karntaju, nyarrpa-jarri kajikarnarla kajilpaju wurra-mantarla? Ngula-jangkaju, kajirna pina-yanirni marlajarra karnta-wangu, kanyi mayirna nyuntu-nyangu ngalapi-nyanuju nyuntu-nyangu-kurra ngurrara-kurraju?” ");
INSERT INTO wbp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Junga-juku, Yipuruyamurluju jangku-manu-yijala, “Lawa kujaju! Kulalpanpa pina-kangkarla yatijarra ngaju-nyangu ngalapi-nyanu. ");
INSERT INTO wbp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","YAAWIYI kuja-ka wiri-jiki nyina nyiyarningkijarraku yalkiriki, nyurru-wiyi kujaju ngaju kangu yali-jangka ngurrara ngajukupalangu-kurlangu-ngurlu nyampu-kurra nguru-kurra, ngulajuju jangku-pungu kapuju yinyi nyampuju walya ngajuku manu ngaju-nyangu-purnuku. Ngulakunya kapu yilyami jinta marramarra nyuntuku kamparru. Ngulanya kapungku kamparru yani yatijarra. Kajinpa ngurrara ngaju-nyangu-kurra yukamirra, kapungku milki-yirrarni nyangunguju karnta. ");
INSERT INTO wbp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kala kajingki wurra-mani, ngulaju ngula-juku. Yampiya! Kulalparnangku nyiyaku nyuntukuju kulu-jarriyarla. Yarda karnangku wangka, lawa, kulalpanpa kangkarla kurdu ngaju-nyangu yali-kirra!” ");
INSERT INTO wbp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Junga-juku-nyanu warrkinirliji rdakaju yirrarnu kanunjumparra wanarri-jarrarla Yipuruyamu-kurlangurlaju, wangkajarla, “Yuwayi, nyiyarningkijarra kujanpaju wangkaja, ngulaju karnangku ngungkurr-nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Junga-juku, yangkangkuju warrkinirli manu-jana karlarla-pala kawartawara-wati Yipuruyamu-kurlangu. Ngulangkaju yirrarnu nyiyarningkijarra jurnarrpa yangkangkaju kawartawara-paturla. Junga-juku, ngula-jangkaju, jirrnganja-jana yarnkaja yangka yaliji warrkini warrkini-patu-kariki yatijarra ngurrara-kari-kirra yirdi-kirra Mijuputamiya-kurra. Yaninja-yanulu parra-kari parra-kariki kulkurrukulkurru-juku. Ngaka-pardu-karilki kutu-jarrijarra kirri-kirraju Nayuru-kurlangu-kurra, ngulangka kujalpa nyinaja nyurru-wiyi Yipuruyamukupurdangka kukurnu-nyanu yirdiji Nayuru. ");
INSERT INTO wbp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kuja-jana jirrnganja kutu-jarrija kirri-kirra, ngulangkarluju parlu-pungu muljulku. Yalirla muljungka ngulangka-juku-jana kawartawaraju muku nyinanja-yirrarnu. Ngulangkanyalpa-jana pardarnu karntakarntakuju kajili yanirni yali-kirra mulju-kurra ngapaku maninjaku. Wuraji-kari wuraji-kari kalalu warrarda yanurnu yali-kirra mulju-kurra ngapa maninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kujalpalu yanurnu karntakarnta ngapaku maninjaku turnu-juku, ngula-puru wangkajalkurla warrkini Yipuruyamu-kurlangu Kaatukuju, “YAAWIYI, kuja kanparla nyuntu wiri nyina ngaju-nyangu wiriki Yipuruyamuku, ngulakuju-jarrangku wardinyi-jarriya jalangu. ");
INSERT INTO wbp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nyampunya karna karri mulju-pirdi-jiki kutu lurljungka kankarlarni. Nyampunyalu yananyarnilki karnta-kangukangu murlukurnpa-kurlu rdakangka-kurlu ngapaku maninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Milki-yirrakaju nyampu-paturla karntaju jinta nyarrpara yungurnarla maninjarla kanyi Yijakiki. Kajirna payirni ngapa yinjaku, yunguju ngapa yinyi ngajuku ngarninjaku, pangkalaju ngulaju wangkami, ‘Yuwayi, yumpa ngapa nganja! Manu mayirna-jana kawartawara-paturlanguku-juku yinyi ngapaju?’ Kajiji kuja wangka, ngulaju kapurna milya-pinyi nyampuju ngulaju Yijakiki kali-nyanu, manu kapurna kujarlaju milya-pinyi nyuntulu kanparla yulkami ngaju-nyanguku wiriki Yipuruyamuku.” ");
INSERT INTO wbp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Kujalparla yangka warrkini Kaatuku yati-wangkaja-juku, ngula-purujulpa kamina yanurnu murlukurnpa wiri-kirli jimantarla-kurlu. Nyanunguju yirdi Ripika. Karnta nyanungu yirdiji Ripika, nyanunguku warringiyi-nyanu ngulaju yirdiji Nayuru, Yipuruyamukupurdangka kukurnu-nyanu. Ripikakupalangu kirda-nyanuju, ngulaju yirdiji Pijulu. Pijulukupalanguju ngati-nyanuju yirdiji Milkaya, ngulaju Nayuruku kali-nyanu. ");
INSERT INTO wbp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nyanungu yirdi Ripika, ngulajulpa yuntardi-nyayirni nyinaja manu jilimijilimi. Kularla wati jirrnganja ngunaja, lawa, jilimijilimi-jikilpa nyinaja. Jitinja-yanurnu yangka yali-kirra mulju-kurra murlukurnpa-kurlu jimantarla-kurlu. Yaninjarla ngapaju yaku-manu murlukurnpa-kurlurluju, ngula-jangka kulpari yanurnu mulju-ngurluju. ");
INSERT INTO wbp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kuja nyangu Ripika kulpari yaninja-kurra, ngulakujurla watiji wajirli-jiki wapirdi yarnkajarra. Parnkanjarla payurnu yangka karntaju, “Ngapajunpaju winjirninya?” ");
INSERT INTO wbp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Karntajurla wangkaja, “Yuwayi, winjirnirnangku.” Junga-juku, jimanta-ngurluju jakurr-manu murlukurnpaju, kanunju-maninjarla yungulkurla watiki yangkaku. ");
INSERT INTO wbp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Kuja watingki ngapa ngarnu, karntangkuju payurnulku, “Ngapaju mayirna-jana yinyi nyuntu-nyanguku kawartawararlangukuju purrakuku?” ");
INSERT INTO wbp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Junga-juku, murlukurnpaju manu, maninjarla winjurnulku-jana mardu-kurra wiri-kirra ngapaju. Yarda maninjarla winjirninja-parnkajalpa-jana mardu-kurraju. ");
INSERT INTO wbp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kujalpa winjirninja-parnkaja ngapa mardu-kurra karntangku, watingkijilpa karrinjarla warrawarra-kangu wurulyparlu kujalpa yali karnta yirdiyi-pungu warrarda. Karrinjarlalpa manngu-nyangu nyampunya marda karntajurla Yijakikiji. Pardarnulparla YAAWIYI-ki yungurla milki-yirrarni karnta Yijaki-parnta, ngulanya yungurla maninjarla kanyi. ");
INSERT INTO wbp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Junga-juku, mukulu ngarnu ngapaju kawartawararluju purraku-nyayirnirli, ngula-jangka warrkini yangka wati-jana yanumpalku warntarriki maninjaku yakujurlaku kapurduku mulyu-kurlanguku waku-kurlangu-jarraku. Mulyu-kurlangu, waku-kurlangu-jarralpa-pala ngunaja kawurlu mirilmirilpa-nyayirni. Nyampu-patuju wiri-nyayirni tala wurnturu-nyayirni. Wilypi-maninjarla jilypi-yirrarnurla mulyungka wakirdirla karntangkaju. Waku-kurlangu-jarralku-palangu manu, maninjarlarla yirrarnu waku-jarrarla. ");
INSERT INTO wbp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Payurnulku yangkaju karnta, “Ngana nyuntu-nyanguju kirda-nyanu? Yungurna ngayi ngunami yuwarlirla nyanungu-nyangurla jintaku mungaku. Lawangkanyalparna yantarlarra yuwarli-kirraju warlangarrangarrarla yapa-wangurla-japa.” ");
INSERT INTO wbp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ripikarluju jangku-manu yangkaju wati warrkini, “Ngajukupalanguju kirdarnaju yirdiji Pijulu. Ngaju-nyangu warringiyiji yirdiji Nayuru, manu ngajuku yapirli yirdiji Milkaya. ");
INSERT INTO wbp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Jaya-kurra-jana yukuriji marnaju kawartawarakuju manu yuwarliji warlangarrangarra kangku karri nyuntukuju ngunanjakuju.” ");
INSERT INTO wbp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Junga-juku, yangkaju Yipuruyamu-kurlangu wati warrkini jurrulkurla kanunju-jarrija, wangkajalkurla YAAWIYI-kilki, ");
INSERT INTO wbp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ngularla pulka-pungulku kujarlu, “YAAWIYI, wangka karnangku. Nyuntu kanpa ngurrju nyina, manu kanparla nyina Kaatu Yipuruyamukuju ngaju-nyanguku wirikiji. Ngurrjunparla nyinaja, manunparla jungarni wangkaja. Ngula-jangkanyanpaju nyampu-kurra kangurnu Yipuruyamu-mayamaya-kurlangu-kurra yangka Nayuru-kurlangu-kurra.” ");
INSERT INTO wbp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Junga-juku, kuja purda-nyangu kuja wangkanja-kurra yangkangkuju karntangku, ngulaju purda-nyanjarla parnkaja pina yuwarli-kirralku ngati-nyanu-kurlangu-kurra. Yimi-ngarrurnu-jana turnu-warnuku jintangkaku-juku nyanungukupurdangkaku manu nyanungukupalangu-watiki. ");
INSERT INTO wbp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Kuja yimi purda-nyangu jintangku watingki yirdingki Lapanarlu Ripikakupurdangkarlu papardi-nyanurlu, manu kuja-palangu nyangu yangka wakurnji-jarra manu kapurdu wita mulyungka, karrinja-pardinjarla wajirli-parnkaja yangka-kurra mulju-kurra yangka kujalpa Yipuruyamu-kurlangu warrkini karrija-juku lurljungka kawartawara-paturlajinta. ");
INSERT INTO wbp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Yangkajurla Lapana parnkanjarla wangkaja, “Kuja kangku nyuntu YAAWIYI-rli pirrjirdi-maninjarla warrawarra-kanyi, nyiyakulku kanpa nyampurlaju warrarda karri? Yanurli ngaju-nyangu-kurra yuwarli-kirra. Nyurrurnangku nyiyarningkijarra jungarni-manu nyuntukuju, manu nyuntu-nyanguku kawartawarakurna-jana yukuriji jungarni-manu.” ");
INSERT INTO wbp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Junga-juku, Lapana manu yangka wati warrkini yarnkajalku-pala yuwarli-kirraju. Kuja-pala yanurnu yuwarli-kirra manu kangurnu-pala-jana kawartawara manu ngalya-kari warrkini-patu Yipuruyamu-kurlangu-patu, Lapanarlu jurnarrpalku muku rurruny-manu kawartawara-jangkaju, manu yukurilki-jana kanjarla yungu kawartawara-watiki. Manu ngapalkurla maninjarla kangurnu Yipuruyamu-kurlanguku warrkiniki yungulu-nyanu kirlka-mani wirliya-jarra warrkini-paturlu. ");
INSERT INTO wbp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yangkangku yirdingki Lapanarlu, ngulangku-jana mangarrilki maninjarla kangurnu. Yangka wati warrkini wangkajarla Lapanakuju, “Kularna ngarni mangarri, ngaka kapurna ngarni. Yungurnangku jaru-wiyi yimi-ngarrirni ngaju-nyangu. Ngaka karna ngula-jangkarlunya mangarriji ngarni.” Lapanaju wangkajarla, “Yuwayi, ngula-juku, wangkaya-wiyi-nganpa.” ");
INSERT INTO wbp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Junga-juku, yangkangkuju warrkinirli yimi-ngarrurnu-jana, wangkaja-jana, “Ngajuju karnarla warrki-jarri Yipuruyamuku. ");
INSERT INTO wbp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","YAAWIYI-rliji-ka pirrjirdi-maninjarla warrawarra-kanyi, manulparla nyiyarningkijarra yungu: jiyipi, puluku, tangkiyi, kawartawara, tala panu-jarlu manu warrkini-patu panu-jarlu karnta manu wati. ");
INSERT INTO wbp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ngaju-nyangurlu wiringki yangkangku Yipuruyamurlu, yangka kujalpa karnta mardarnu yirdiji Jiira, ngula kuja muturna-jarrija, muturnalku kujalpa nyinaja, ngulakujurla palka-jarrija kurdu yirdiji Yijaki muturnakulkuju. Yipuruyamurluju ngulakunyarla yungu nyiyarningkijarraju nyanungu-nyangu ngalapi-nyanuku. ");
INSERT INTO wbp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ngulanyaju wangkaja ngaju-nyangu wiri yaninjarniki nyampu-kurraku, ngulakunyarnarla ngungkurr-nyinaja. Wangkajaju ngajukuju, ‘Kularla parlu-pinjarla milaka yapirli-nyanuju nyampu-wardingki Kanana-wardingki nyampurla ngurungka kuja karna ngaju nyina, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kala pina-yanta yatijarra ngajukupalangu-kurlangu-kurra ngurrara-kurra.’ ");
INSERT INTO wbp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Wangkajarnarla ngaju-nyangukuju wirikiji, ‘Kajirna yani yali-kirra yajarninjaku karntaku, kajilparna milakarla, nyarrpa-jarrimi kajikarnarla kajilpaju wurra-mantarla?’ ");
INSERT INTO wbp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Junga-jukuju jangku-manu ngaju-nyangurluju wiringki, ‘Ngajuju karna tarnngangku warrarda pura YAAWIYI, manu karna jalangurlu purami-jiki. Kapu yilyamirni nyanungurlu marramarra, manu kapungku kamparru yani marramarraju, manu kapurla milarni nyanungurlu yapirli-nyanuju nyampukuju ngaju-nyanguku. Kapungku milki-yirrarni nyanunguju karnta warlalja ngajukupalangu-kurlangu, manu kapunpa milya-pinyi kajingki wapirdi yanirni. ");
INSERT INTO wbp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kajingkili wurra-mani nyanungukupalangu-purnurlu, ngulaju-jana yampiya wajampa-jarrinja-wangurlu. Kulalparnangku nyiyaku nyuntukuju kulu-jarriyarla kajinpaju purda-nyanyi yalyangku manu kajinpa puta yajarni nyampuku Yijakiki yapirli-nyanu.’ ");
INSERT INTO wbp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Jalangu kujarna yanurnu nyampu-kurra mulju-kurra kawartawara-kurlu, muljungka yalirla-jukurna jupu-karrija. Yalumpu-wardingki-jukulparnarla wangkaja Kaatukuju, kujanyalparnarla wangkaja, ‘YAAWIYI, kuja kanparla wiri-jiki nyina ngaju-nyanguku wiriki Yipuruyamuku, milki-yirrakaju karnta Yijakiki kali-nyanu. ");
INSERT INTO wbp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nyangkaju, nyampunya karna mulju-pirdi-jiki karri lurljungka. Kajili karntakarnta yanirni ngapaku maninjaku, ngulaju kapurna jinta-kari karnta payirni ngapaku. Kapurnarla wangkami kuja, “Ngapaju yungka yungurna ngarni purrakurlu.” ");
INSERT INTO wbp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kajirna jungarnirli milarni, ngulaju pangkalaju wangkami karntaju, “Yuwayi, yumpa, nganja, manu mayirna-jana ngapaju yinyi-yijala kawartawarakuju?” Kajirna kuja-kurra purda-nyanyi, ngulaju kapurna milya-pinyi ngulaju Yijakiki kali-nyanu.’ ");
INSERT INTO wbp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kujalparnarla wurra-juku wangkaja Kaatuku, ngula-puruju Ripikajulpa yanurnu mulju-kurra ngapaku maninjaku murlukurnpa wiri-kirli jimantarla-kurlu. Junga-juku, yaku-manu ngapaju. Junga-juku, payurnurna, ‘Ngapaju yungka.’ ");
INSERT INTO wbp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Junga-juku, jimanta-jangkaju murlukurnpaju manu, maninjarlaju yungu murlukurnpaju ngapa-kurluju, manuju wangkaja, ‘Yuwayi, nganja. Ngapaju mayirna-jana yinyi nyuntu-nyanguku kawartawararlangukuju purrakuku?’ Junga-juku, ngapajurna ngarnu, manu ngula-jangka, Ripikarluju ngapa-jana maninjarla yungu ngaju-nyangukuju kawartawara-patuku. ");
INSERT INTO wbp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ngula-jangkaju, yardarna payurnu Ripikaju, ‘Ngana nyuntukupalanguju kirda-nyanuju?’ “Ripikarluju jangku-manuju, ‘Ngajukupalanguju kirdarnaju yirdiji Pijulu. Ngaju-nyangu warringiyiji yirdiji Nayuru, manu ngajuku yapirli yirdiji Milkaya.’ Kujarna kuja-kurra purda-nyangu, ngulajurnarla maninjarla yirrarnu kapurdu kawurlu mulyungka, manu wakurnji-jarra waku-jarrarlaju Ripikaku. ");
INSERT INTO wbp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ngula-jangkarnarla jurrulku kanunju-jarrija, pulka-pinjarlalparnarla yati-wangkajalku YAAWIYI-ki. Ngulaju nyanunguju karla nyina wiri-jiki Yipuruyamukuju ngaju-nyangukuju wiriki. Manu kujaju junga-juku nguru-yirrarnurnu nyampu-kurra ngurrara-kurra yungurnarla karnta milarni Yijakiki Yipuruyamu-kurlanguku kaja-nyanuku. Ngularlangukunyarnarlajinta pulka-pungu YAAWIYI-ki. ");
INSERT INTO wbp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ngulaju ngula-juku. Wangkayajulu, wardinyi mayi kankulurla nyina ngaju-nyanguku wirikiji Yipuruyamuku? Yinyi mayinkijili yalumpuju kamina? Kajinkijili mamparl-pinyi, ngulaju ngula-juku. Kaaturlu kapuju milki-yirrarni nyarrpa-jarri kapurna.” ");
INSERT INTO wbp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kuja-pala kirdarlangurlu purda-nyangu Pijulurlu manu Lapanarlu kuja-kurra wangkanja-kurra, ngula-pala jangku-manu, “Nyuntu-nyangu jaru ngulaju YAAWIYI-kirlangu. Nyanungungku wangkaja, manungku nguru-yirrarninjarla kangurnu nyampu-kurraju ngurra-kurraju. Ngali-jarrarlu kulalparlijarra mamparl-pungkarla. ");
INSERT INTO wbp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ngula-juku nyampujurla kangka kalyakalya-nyanu Yipuruyamu-kurlanguku ngalapi-nyanuku kujangku YAAWIYI-rli milki-yirrarnu nyampuju karnta-pardu.” ");
INSERT INTO wbp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Yangkangku warrkinirli Yipuruyamu-kurlangurlu, kuja-palangu purda-nyangu wangkanja-kurra, ngula-jangkaju, nyanunguju jarntarru-jarrinjarla parntarrinjunu. Parntarrinjarla YAAWIYI-kilkirla yati-wangkaja manu pulka-pungurlajinta. ");
INSERT INTO wbp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Junga-juku, karrinja-pardinjarla warru yarnkajarra yangkaju wati warrkini Yipuruyamu-kurlangu. Yanurra yangka jurnarrpa nyanungu-nyangu-kurra. Ngula-jangkaju, jurnarrpalku turnu-manu, turnu-maninjarlalkurla yungu warntarrilki Ripikaku wawarda manu kawurlu manu pirli yaltiri ngulaju rdaka-kurlangu, langa-jarra-kurlangu, mulyu-kurlangu manu yinirnti-wati, yangka kuja kalu waninja-kurlangu mardarni. Manu ngati-nyanuku manu Ripikakupurdangkaku papardi-nyanuku Lapanaku, ngularlangukupalangu yungu warntarri wiri-nyayirniji. ");
INSERT INTO wbp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ngula-jangkaju, wati-paturluju kurapakalkulu wiri ngarnu, manulu yalumpurla-juku ngurrangkajulu yarda ngunaja yangkaju warrkini-patu Yipuruyamu-kurlangu. Ngula-jangkaju, mungalyurru-wana yakarra-pardijalu. Yangkaju wati warrkini Yipuruyamu-kurlangu, wangkajarla Lapanakuju, “Yilyayalku-nganpa yungurnalu pina-yani manu yungurnalu Ripika kanyilki wiri-kirlangu-kurra nganimpa-nyangu-kurlangu-kurra Yipuruyamu-kurlangu-kurra.” ");
INSERT INTO wbp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Lapana manu Ripikakupalanguku ngati-nyanu, wangkaja-palarla yangka watiki warrkiniki, “Lawa, pangkala nyina-juku parra-patuku karlarla-palaku. Ngula-jangkanya kanpa kanyilki.” ");
INSERT INTO wbp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yangka wati warrkini wangkajarla, “Lawa kujaju, wurra-maninja-wangurluju yinjarla kijika-puka! Kujaju nyampu karntaju YAAWIYI-rli milki-yirrarnu, ngulajurna kanyi jalangurlu-juku ngaju-nyangu-kurra wiri-kirra.” ");
INSERT INTO wbp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Junga-juku, yangka-jarrarluju-pala jangku-manu, “Yuwayi, ngula-juku karlijarra payirninjini-wiyi Ripikalku nyarrpa kaji wangka.” ");
INSERT INTO wbp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Junga-juku, yaninjarla-pala payurnu Ripikaju, “Yani mayinpa nyuntuju nyampu-wanaju wati-wana?” Junga-juku, jangku-manu-palangu Ripikarluju, “Yuwayi, yani karna jalangu-juku nyampu-wana wati-wana.” ");
INSERT INTO wbp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Junga-juku, Lapanarla wangkaja Ripikaku yungu pirrjirdi-mani, “Yuwayi ngula-juku wita ngawurru. Kapungkulu kurdukurdu jaya-kurra palka-jarri. Kajili-jana yapa-karirli kulukukuluku-mani nyuntu-nyangu-purnu kurdukurdu, ngulajulu-jana nyuntu-nyangu-purnurlu pinyi.” Junga-juku, yilyajalku-pala Pijulurlu manu Lapanarlu. ");
INSERT INTO wbp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Manu Ripika-kurlangu warrkini-patu panu-kari karntakarnta, ngulajulu mapirri yanu Ripikaku jirrnganja, yangka kujalu wiri-manu wita-ngurlu. Ngulangkujulu puraja Ripika. Yangkangku wati warrkinirli Yipuruyamu-kurlangurlu, nguru-yirrarnu-jana kamparrurlu, ngulaju panu-jukulpalu kawartawara-kurlu yanurra. ");
INSERT INTO wbp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kuja-purujulpa nyinaja Yijakiji manangkarrarla yirdingka Nikipirla. Ngulaju kamparru-juku pina-yanurnu mulju-ngurlu Pirilayiru-ngurlu Nikipi-kirraju, ngulangkanyalpa pina-nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wuraji-pardu-karilki warrulpa wapaja ngurra-wana nyanungu-nyangu-wana, manulpa manngu-nyangu nyiya mayi Kaatu-kurlangu. Kujalpa warru wapaja, ngula-jana kawartawaralku parlu-pungu wurnturu-nyayirni kujalpalu yanurnu. ");
INSERT INTO wbp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ripikajulpa nyinanja-yanurnu kawartawararlaju. Kuja kutu-jarrija, jurruju kankarlu-jarrija, parlu-pinjarla nyangulku Yijakiji, manu jitija kawartawara-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Jitinjarla payurnulku yangkaju wati warrkini Yipuruyamu-kurlangu, “Ngana yalumpuju wati yananyarni?” Jangku-manu yangkangkuju warrkinirli, “Yalumpuju ngaju-nyangu wiri-kirlangu ngalapi-nyanu yirdiji Yijaki.” Kuja purda-nyangu kuja-kurra yirdi-maninja-kurra, kujarlaju-nyanu wawardalku parnta-yirrarnu kurntangka miparrpa-wana. Milpa-jarrarlu-pukalpa nyangu. ");
INSERT INTO wbp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kuja Yijaki kutu-jarrija, yangkaju warrkini wangkajarla, manu mukurla yimi-ngarrurnu nyiyarningkijarra. ");
INSERT INTO wbp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Junga-juku, Yijakirliji yajarninjarla Ripika kangulku kaluku-kurra nyanungukupalangu-kurlangu-kurra ngati-nyanu-kurlangu-kurra. Ngulangkanyalpa-pala nyinaja manu ngunaja. Kujarlajulpa muntuku-wangulku manu mari-wangulku nyinaja kujalpa palkalku mardarnu karnta nyanungu-parnta Ripika. Kala kamparru-wiyi Ripika-wangurla-wiyiji, ngulajulparla yirraruyirraru nyinaja manu muntuku ngati-nyanu nyurnuku, kuja kurdu-puka-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Yangka kuja Yipuruyamurlu wajawaja-manu nyanungu-parnta karnta yirdiji Jiira, ngula-jangkarluju, jinta-karilki manu karnta-karilki yirdiji Kitura. ");
INSERT INTO wbp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ngulakujulurla panu-yijala kurdukurdu wirriyawirriya palka-jarrija yirdi-patuju Jimirani, Jakajani, Mirdini, Mirdiyanu, Yijipa manu Juwa. ");
INSERT INTO wbp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yangka yirdi Jakajani, ngulaju-palangu kirda-nyanu nyinaja wirriya-jarraku yirdi-jarraku Jiipaku manu Tirtanuku. Tirtanu-mayamaya yapa, ngulaju kalalu nyinanja-yanu ngurrara-kari ngurrara-karirla yirdi-paturlu Jiriyarla, Litujurla manu Luumurla. ");
INSERT INTO wbp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Yangka yirdi Mirdiyanu, Kitura-kurlangu ngalapi-nyanu, ngulaju-jana kirda-nyanu nyinaja wirriyawirriyaku yirdikiji Yiipaku, Yipiruku, Yanakaku, Yapita manu Yirltaku. ");
INSERT INTO wbp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ngulaju ngula-juku. Kujalpa Yipuruyamuju purlka-juku nyinaja, ngulaju-jana wangkaja nyanungu-mayamayaku turnu-warnuku, “Kajirna ngaju mata-jarri, ngulaju-ka Yijakirli mani ngaju-nyanguju nyiyarningkijarraju kujanguju.” ");
INSERT INTO wbp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Yipuruyamurlu-jana mardarnu ngalya-kari-patu karntakarnta, ngulaju nyanungu-parnta-yijalalpalu nyinaja, manulpalu-jana wirriyawirriya mardarnu. Kulalu nyampurrarlu wirriyawirriyarlu nyiya wita manu kujangu Yipuruyamu-kurlangu, lawa. Ngari-jana warntarriji yungu wirriyawirriyaku, manu-jana muku yilyaja kakarrara wurnturu yungulurla wurnturu jurnta nyinami Yijaki-kijaku. ");
INSERT INTO wbp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Ngula-jangkaju, Yipuruyamuju kuja ngurrju nyinaja 175-palaku yukuriki, ngula-jangkaju, lawa-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Junga-juku, kuja nyanungu lawa-jarrija, nyanungu-nyangu-jarrarlu ngalapi-nyanu-jarrarlu Yijakirli manu Yijimalirli, ngulaju-pala nyurnu palkaju kangu pirnki-kirra yirdi-kirra Makapila-kurra, manu-pala wardu-yirrarnu nyanungu-parnta-wana Jiira-wanaju kuja yangka kamparru-wiyi wajawaja-manu. Pirnkiji ngulaju jinta-juku yangka kuja-jana kamparrurlu-wiyi Yipuruyamurlu tala yinjarla manu Yiiji-kirlangu-patuku yapaku. Ngula pirnkiji-ka karri kakarrara Mamiri-kirlangu, ngulajurla kamparru warlalja wati-kariki yirdiki Yipiraku, ngulaju ngalapi-nyanu Juuruku Yiiji-kirlangurlanguku. ");
INSERT INTO wbp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ngula-jangkaju, Yijaki kuja kurdu-puka-jarrija, nyanungu-mayamayaju kulpari yanulkulu yangka yali-kirra mulju-kurra yirdi-kirraju Pirilayiru-kurra, ngulangkalkunyalpalurla pirrjirdi marlaja nyinaja Kaatukuju. ");
INSERT INTO wbp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nyampu yimi ngulaju Yijimali-kirlangu-kurlu warlalja-patu-kurlu. Yijimaliji kaja-nyanu kamparru-warnu Yipuruyamu-kurlangu. Ngati-nyanuju mardukuja Yijipi-wardingki yirdi Yakarru. Yakarruju warrkinilparla nyinaja Jiiraku Yipuruyamu-parntaku. ");
INSERT INTO wbp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Nyampu-patunya kaja-nyanu-patuju 12-palaju yirdi-patuju. Ngulaju papardi-jurrkuju yirdiji Napata. Nyanungu-warnuju palka-jarrija Kirduru, ngula-warnuju Yapitili, Mipijama, Mijima, Tuuma, Maaja, Yatata, Tiima, Jituru, Napiji manu Kirtima. ");
INSERT INTO wbp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nyampu-patu kaja-nyanu-patulu wiri-jarrija, manulu jarnkujarnku yanu kirri-kari kirri-kari-kirra manu ngurra-kari ngurra-kari-kirra nyinanjaku. Ngurra-kari ngurra-karilpalu-jana wiri nyinaja warlaljayirriki. Yalumpurra ngurra-paturlulpalu yirdi-patu jurrku-juku mardarnu yangka-patu 12-pala-kurlangu yirdi kaja-nyanu-patu-kurlangu. ");
INSERT INTO wbp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Kala Yijimali palija purlka-nyayirnilki kujarla yulyurrpu 137-pala rdipija. ");
INSERT INTO wbp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Warlalja-patu kaja-nyanu-patu-kurlangu 12-pala-kurlangu, kujalu-jana palka-jarrija Yijimali-kirlangu-patuku, ngulajulpalu nyinaja kulkurru-jarra ngurrara-jarraku yirdi-jarraku Yapilaku manu Juuruku. Ngurrara nyampuju kutu-karrikarri ngayingayi ngurrararla Yijipirla kakarrarni-nginti ngurrara Yajiriya-kurra-pinangu. Panungku Yijimali-kirlangurlu warlalja-paturlu kalalu-jana warlalja yinya-patu-kari nyanungukupurdangka-kurlangu-purnu pungu. ");
INSERT INTO wbp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Yimi nyampuju Yijaki-kirli Yipuruyamu-kurlangu-kurlu kaja-nyanu-kurlu. Yuwayi, kaja-nyanujulpa palka yirdi Yijaki Yipuruyamurluju mardarnu. ");
INSERT INTO wbp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Kujarla yulyurrpu 40-pala Yijakikiji rdipija, mardukujalku-nyanu manu Ripika, yurntalu-nyanu Pijulu-kurlangu. Nyanunguju Ripikaju Lapanakupurdangka ngawurru-nyanu. Pijulu manu Lapana, ngula-jarraju nguru Patana-Yarrama-wardingki-jarra. ");
INSERT INTO wbp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ripikaku Yijaki-parntaku, kularla kurduju palka-jarriyarla. Kujarlaju, Yijakirla wangkaja YAAWIYI-ki, payurnu yungu nyanungu-parnta ngurrju-mantarla kurdu yungu-palangu palka-jarriyarla. Purda-nyangu YAAWIYI-rliji Yijakiji wangkanja-kurra. Ngula-jangka, ngaka-karilki, Ripikaju juni-parnta-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kala ngulaju jirrama-kurlu kurdu-jarra-kurlu miyalurla-kurlu, kula-nganta jinta-kurluju. Miyalurlajulpa-palangu Ripikarluju kurdu-jarraju purda-nyangu yirntirninja-kurraju manu yangka kula-ngantalpa-pala-nyanu pungulku. Manngu-nyangulpa-nyanu Ripikarluju, “Nyiya-jangka karnaju kujaju purda-nyanyi?” Kujarlaju, payirninjaku YAAWIYI-ki yanu Ripikaju. ");
INSERT INTO wbp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ripikakurla wangkaja YAAWIYI, “Ngulaju kula-ngantanpa yapa-kurlu turnu-warnu-jarra-kurlu miyalurla-kurluju. Kaji-pala kurdu-jarra nyampu-jarra palka-jarrimi, ngaka warlalja-jarra-warnu-jangka nyanungu-nyangu-jarra-warnulku kapulu-nyanu wurnturu-mirnimirni jurnta nyinami. Warlalja-patu-kari kapu pirrjirdi-nyayirni-jiki panu-karikiji warlalja-patu-karikiji nyinami. Kala kurdu-jarra yalumpu-jarra, kaji-pala wiri-jarrimi, kapurla papardi-nyanuju warrki-jarrimi kukurnu-nyanuku.” ");
INSERT INTO wbp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ngaka-kariji, kutulkulparla karrinja-yanu Ripikakuju karrmulypa-jarrinjakuju. Miyalurlaju jurrku-jarra-juku wirriya-jarrajulpa-palangu kanja-yanu. ");
INSERT INTO wbp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kuja kamparru-warnu kurdu-pardu wirriya palka-jarrija, ngulaju pintiji yalyuyalyu, manu palkakuju mukurla wapirrija wakurlu wawarda-piya wamulu-kurlu-piya. Ngula-palarla kurduku nyampuku jaji-nyanurlu manu ngati-nyanurlu yirdiji ‘Yijuwu’-palarla yirrarnu ");
INSERT INTO wbp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Yijuwu kuja palka-jarrija, ngula-jangkaju nyanungukupurdangkalku kukurnu-nyanulku palka-jarrija. Kujalpa palka-jarrinja-yanu, purdangirli-warnurlu kukurnu-nyanurlujulpa tari puuly-mardarninja-yanu kamparru-warnu. Kujarluju, jaji-nyanurlu manu ngati-nyanurluju yirdiji-palarla yirrarnu ‘Jakupu’ Kuja-palangu kurdu-jarra nyampu-jarra Ripikarlu mardarnu, ngulajurla Yijakikiji yulyurrpu 60-pala rdipija. ");
INSERT INTO wbp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kujalpa-pala nyanungu-jarra wirriya-jarra wiri-jarrinja-yanu, Yijuwujulpa nyanungu-nyayirni kuyu-pungu nyinaja, manu kala nyanunguju ngampurrpa wirlinyiji warrarda yanu. Kukurnu-nyanu Jakupuju pulya-parnta yantarli kala wardinyi ngurrangka nyinaja kaninjarni kalukurla nyanungukupalangu-kurlangurla. ");
INSERT INTO wbp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yijakirli kalarla kuyu-pinja-warnu Yijuwuku marlaja ngarnu. Yijuwurlu kalarla purraja nyanungukuju manu kuja-jangkaku kalarla yulkaja-nyayirni Yijuwukuju. Kala Ripikarluju kurturdurrurluju kukurnu-nyanu mardarnu. ");
INSERT INTO wbp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ngaka-kari, Jakupurlu purraja yalyuyalyu jupujupu kartakurla wiringka. Papardi-nyanuju wirlinyi-jangka ngurra-kurra pina-yanurnu yarnunjuku-nyayirni kuyukuju. ");
INSERT INTO wbp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Nyanunguju wangkajarla Jakupuku, “Wayinpa! Ngajujurna yarnunjuku-nyayirni! Kapankurluju yalumpu nganayi yalyuyalyu jujujupu kartaku-jangka ngarninjaku yungkarni!” (Kuja-jangkarlunya Yijuwurluju yirdi-kariji jinta-kariji ‘Yitama’ manu. Yirdi kujaju ‘Yalyuyalyu’-yijala.) ");
INSERT INTO wbp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ngula-jangka, Jakupurla wangkaja papardi-nyanuku, “Nyuntuju kanpaju ngajukupurdangka papardi-nyanu nyinami. Kaji jaji-pardu ngalijarrakupalangu palimi, kapunpa nyanungu-nyangu nyiyarningkijarra mani warntarri nyuntulurlu yungunparla marlaja mardarni. Ngajulurlu kularna nyiya witarlangu mani, lawa. Ngampurrpa kanpaju nyinami ngajuku yungurnarla marlaja mardarni nyiyarningkijarra nyanungu-nyangu warntarri-jangka? Kajinpaju nyiyarningkijarra yinyi ngalijarrakupalangu-kurlangu warntarri-jangka, ngula-jangkaju kapurnangku yinyi ngalya-kari jupujupu ngarninjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yijuwurla wangkaja kukurnu-nyanuku, “Wayinpa! Kajilparna yarnunjuku paliyarla jalangurlangu, kularna mani nyiyarningkijarraju warntarri-jangkaju. Kulalparna yalumpuju nyarrpa-marntarla.” ");
INSERT INTO wbp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kala kujalkurla Jakupu wangkaja papardi-nyanuku, “Wangkayaju yungurna yinya nyiyarningkijarra mani warntarri-jangka, manu ngula-jangkarluju kapurnangku jupujupu nyampulku yinyi nyuntuku ngarninjaku.” Junga-juku, Yijuwurlurla jangku-pungu nyiyarningkijarraku yinjaku warntarri-jangkaku. ");
INSERT INTO wbp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ngula-jangkarluju, Jakupurlurla mangarri manu yalumpu jupujupu yungu papardi-nyanuku ngarninjaku. Ngula jupujupu Yijuwurlu muku ngarnu, ngulaju karrinja-pardinjarla yanulku nyanunguju. Nyanungurlu Yijuwurlu rampal-manngu-nyanjarla juwa-kujurnu warntarri nyanungukupalangu-kurlangu. Yungurla marlaja mardakarla warntarri nyiyarningkijarra warungka-wangurlu papardi-nyanu-katurlu. ");
INSERT INTO wbp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ngaka-kari yinyarla ngurrararla, kuyuku manu mangarriki lawalpa karrija, manu yapa panujulpalu yarnunjuku-nyayirni nyinaja. Nyampuju-jana yangka-piya-jala kamparru-warnu-piya-yijala karrija kujalpa Yipuruyamu wankaru-wiyi nyinaja. Ngula-jangka yanu Yijaki kirri-kirra Karara-kurra wangkanjaku Pimalikiki. Nyanunguju wirilpa-jana nyinaja yapa-patuku Pilijiya-wardingki-patuku. ");
INSERT INTO wbp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ngula-jangkaju, YAAWIYI-ji wangkajarla nyanunguku Yijakiki, “Kula yanta ngurrara-kurra yinya-kurra Yijipi-kirra. Nyinaka nyampu-miparla ngurrara-miparla yangka kuja karnangku nyuntu yimi-ngarrirni ngajulurlu. ");
INSERT INTO wbp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nyinaka nyampurla-juku ngurrararlaju, kapurnangku palka jirrnganja nyinami. Kapurnangku nyuntuju pirrjirdi-maninjarla warrawarra-kanyi. Kapurnangku yinyi nyuntuku ngurra-kari ngurra-kari nyampurla ngurrararla manu nyuntu-nyanguku kurdukurduku manu warringiyi-patuku nyuntu-nyangu-paturlanguku. Nyampuju yangka kujarnarla nyurru-wiyi jangku-pungu yinya nyuntukupalangu Yipuruyamuku. ");
INSERT INTO wbp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Yuwayi, kapurna panu yapa yirrarni nyuntu-nyangu warlalja-kurraju. Kapulu panu-jarlu nyinami yanjilypiri-piya-juku ngula kalu karri yalkirirla, panu-juku yapakuju yirdiyirdi-maninjakuju. Ngajuju kapurna-jana yimiri nyina nyanungu-patuku. Ngula-jangka, yapa nguru-kari nguru-kari kapulurla marlaja nyinami wardinyi-nyayirni nyuntu-nyanguku warlaljaku. ");
INSERT INTO wbp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kujalpaju Yipuruyamurlu nyuntukupalangurlu ngaju warrarda purda-nyangu, kujarlaju kapurnangku panu yapa yirrarni nyuntu-nyangu warlalja-kurra. Nyanungurlu kalaju warrarda purda-nyangu nyiyarlanguku kuja kalarnarla ngaju wangkaja. Nyanungurlu kalaju nyiyarningkijarrakuju warrarda purda-nyangu ngularna nyanungu pinarri-manu. Warrarda purajalpa nyanungurluju kuruwarri ngaju-nyangu jungarnirli-jiki.” Kujanyarla YAAWIYI-ji wangkaja Yijakikiji. ");
INSERT INTO wbp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ngula-jangka, Yijaki nyinajalpa yinyarla Karararla, kula yanu Yijipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Yijaki-parnta kali-nyanu Ripika yuntardi-nyayirni. Wati-patu kujalpalu Karararla nyinaja, ngulajulu yanurnu, manulu payurnu Yijaki nyanunguku mardukujaku, “Ngana yalumpuju?” Yijakirli yimirr-yungu-jana, manu-jana yalu-manu nyanungu-patu kujarlu, “Yalumpuju ngajukupurdangka ngawurru.” Lani-jarrijalpa-jana nyanungu-patuku. Yungu-jana yimirr-yinja-wangurlu jungangku yimi-ngarrikarla mardukuja yalumpuju kali-nyanu nyanungu-parnta. Purda-nyangulpa-nyanu kapulu marda nyanungu-paturlu pungkarla, manu mardukuja kapulurla nyanunguku jurnta kangkarla. Kujarlanya-jana yimirr-yungu nyanungu-patu nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yijaki nyinajalpa yinyarla Karararla tarnnga. Ngaka-kari, Pimaliki wiri Pilijiya-wardingki-patuku yapa-patuku kujalpa-jana nyinaja, ngulangkujulpa kaninjarni-ngirlirli yuwarli nyanungu-nyangu-ngurlurlu wintawu-ngurlurlu nyangu. Nyanungurlu nyangu Yijaki ngamirlji-maninja-kurra manu nyunjirninja-kurra Ripika-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ngula-jangka, yilyaja-jana Pimalikirli nyanungu-nyangu wati-patu maninjaku Yijaki. Kuja Yijaki yanurnulku, Pimalikirla wangkaja nyanunguku, “Wayinpa, mardukuja nyampuju kali-puraji nyuntu-parnta-nyayirninya? Nyiyakulkunpa-nganpa yimirr-yungu? Wangkajanpa-nganpa ngawurru nganta yalumpuju nyuntukupurdangka.” Yijakirli yalu-manu nyanunguju, “Lani-jarrijalparna. Manngu-nyangulparnaju kapunpaju pungkarla manu ngula-jangkarlu kapunpa-nyanu marda mardukujaju nyuntulurlulku kangkarla.” ");
INSERT INTO wbp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ngula-jangkaju, Pimalikirla wangkaja Yijakiki, “Nyiyakunpa-nganpa kujarluju yimirr-yungu? Kapulu watingki nyampu-wardingkirli kirri-wardingkirli marda jarrarda-kangkarla mardukuja yalumpu. Nganangku-puka kaji jarrarda-kangkarla, kujaju majumaju-nyayirni, manu Kaaturlu kapu-nganpa panu-juku marda muku pungkarla.” ");
INSERT INTO wbp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ngula-jangkaju-jana Pimalikirliji pututu-ngarrurnu nyanungu-nyangu yapa-patuju, “Kaji nganarlangurlu-puka marnpirni nyampu mardukuja, ngaju kapurna-jana ngaju-nyanguku warrmarlaku wangkami yungulu pinyi tarnnga-kurra.” ");
INSERT INTO wbp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ngula-jangkarlu, ngurlu-wati-jana Yijakirli yirrarnu walyangka ngulangka yungu pardimi mangarri. Ngaka wantangka yalumpurla-yijala ngulaju nyanungurlulpa manu panu mangarri watiya-jangka kujalpa pardija yalumpurla. Kujarlunyalpa YAAWIYI-rli nyanunguju pirrjirdi-maninjarla warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yijakiji palka-kurlulku nyiyarningkijarra-kurlujulpa nyinaja. Nyanungurlu tarnngangku-jukulpa nyiyarningkijarraju mayangku-juku yardayarda manu. ");
INSERT INTO wbp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Nyanungurlu warlaljalpa-nyanu panu wati manu mardukuja mardarnu kujalpalurla warrki-jarrija nyanunguku tarnnga. Manulpa-jana nyanungurlu panu jiyipi turnu-kari turnu-kari mardarnu, manu panu pulukulpa-jana turnu-kari turnu-kari mardarnu. Kujarlanyalpalurla Pilijiya-wardingki-patu yapa-patuju nyanungukuju yunnganji-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ngula-jangka, nyanungulu warla-pajurnu jiyipi-kijaku manu puluku-kujaku walyuru-maninja-kujaku, warru yanulu nyanungu-patu, mulju-kari mulju-karilpalu walya-kurlurlu warru jutu-manu. Nyampurraju yangka-patu-juku mulju-patuju kujalpalu warrkinirli Yipuruyamu-kurlangurlu warru pangurnu nyurru-wiyirli kamparrurlu-wiyi kujalpa jaji-nyanu Yijakikipalangu Yipuruyamu nyinaja wankaru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ngula-jangka, Pimaliki yanurnu, manu wangkajarla Yijakiki, “Yanta ngurrara nganimpa-nyangu-ngurlu! Nyuntu manu yapa-patu nyuntu-nyangu pirrjirdi-nyayirni-jiki nganimpakuju.” ");
INSERT INTO wbp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ngula-jangka, Yijaki manu nyanungu-nyangu yapa-patujulu yanu yalumpu-ngurlu kurlirra kakarru-karrikarri, manulu ngurrangka-jarrija wirringka yirdingka Karararla-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Wirringka ngulangka, nyurru-wiyi kamparru-wiyi, jaji-nyanurlu Yijakikipalangurlu Yipuruyamurlu-jana pangurnu panu-jarlu muljuju. Ngakalku kuja nyanungu palija, yapa-paturlu Pilijiya-wardingki-paturlulu-jana muljuju panu-juku jutu-manu walya-kurlurlu. Ngula-jangka, Yijaki manu nyanungu-nyangu yapa-patu manu nyanungu-nyangu wungu-warnu, ngulalu yanu nyinanjaku ngula-kurra wirri-kirra, ngulaju-jana nyanungurluju yangka-patu-yijala mulju-patuju yarda pangurnu ngapakupurdarluju, manu-jana nyanungurlu mulju-patukuju yirdiji yirrarnu yangka-patu-yijala kuja-jana jaji-nyanurlu-wiyi mulju-patu kamparrurlu yirdi-manu. ");
INSERT INTO wbp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Yijaki-kirlangurlu warrkini-paturlulu yarda-yijala pangurnu mulju-karilki jalangu-warnu wirringka yinyarla. Rdipijalurla ngapaku winjirriki kujalpa purlpurl-pardija walya-jangka. ");
INSERT INTO wbp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Yangka ngula-wanarlu-yijalalpalu-jana panu-karirli watingki Karara-jangkarlu puluku-patu warrawarra-kangu. Kujalu nyanungu-paturlu yalumpu mulju jalangu-warnu nyangu, nyanungu-patulu-jana rdiily-yirrarnu wiljiwilji-maninjaku wati-patuku Yijaki-kirlangu-patuku kujalpalurla nyanunguku panu puluku warrawarra-kangu. Nyanungujulu-jana wangkaja wati-patuku Yijaki-kirlangu-patuku, “Ngapa nyampuju nganimpa-nyangu.” Ngula-jangka, Yijakirli manu nyanungu-nyangurlu yapa-paturlulu mulju yinya yampija, ngulalu yanu ngurra-kari-kirra. Kujalu-nyanu yinya-ngurlu mulju-ngurlu wiljiwilji-manu, kuja-jangkanya Yijakirli yirdi-manu mulju yinya ‘Yijiki’, ngulaju ‘Wiljiwilji Wiri’. ");
INSERT INTO wbp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Yungkaparri wurnturu-wangu, yapa-paturlu Yijaki-kirlangu-paturlulu mulju-kari pangurnu. Kala wiljiwilji-manulu-jana nyanungu-patu-yijala panu-karirli mulju yalumpu-ngurluju. Ngula-jangka, Yijakirli mulju yalumpu yirdi-manu ‘Jitina’, yirdi ngulaju ‘Kulu Wiri’. ");
INSERT INTO wbp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ngaka ngula-jangka, Yijaki manu nyanungu-nyangu yapa-patu yanulu ngurra-kari-kirra, manu yinyarla mulju-karili nyanungu-paturlu pangurnu. Kulalu-jana yangka-paturlu mulju nyampuju jurnta kangu, lawa. Ngulakujurla Yijakirli yirdiji muljukuju yirrarnu ‘Riyupu’. Yirdi ngulaju ‘Wantiki Nyampu Ngalipaku Nyinanjaku’. Wangkaja-jana nyanunguju yapa-patuku nyanungu-nyangu-patuku, “YAAWIYI-rli-ngalpa yungu nyampu ngurra ngalipaku! Kapurlipa nyinami nyampurla ngurrju-nyayirni.” ");
INSERT INTO wbp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Riyupu-jangka, Yijaki manu nyanungu-nyangu yapa-patulu yaninjarla nyinaja Piirrjiparla. ");
INSERT INTO wbp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kujalu nyanungu-patu yalumpu-kurra yukajarralku, ngulangka mungangka jintangka, YAAWIYI-ji palka-jarrijarla Yijakiki jukurrparla, manurla wangkaja nyanunguku, “Ngajuju Kaatu jinta-juku kujalparnarla nyuntukupalanguku Yipuruyamuku wangkaja. Nyanungurlu ngajuju kalaju warrarda purda-nyangu. Kula lani-jarriya! Palka-juku karnangku nyina nyunturlangukuju. Kapurnangku pirrjirdi-maninjarla warrawarra-kanyi. Wangkajarnarla jaji-purajiki, kapurnarla nyanunguku yinyi panu kurdukurdu manu warringiyi-watirlangu! Kujakuju kapurnangku nyunturlanguku yinyi panu kurdukurdu manu warringiyirlangu.” ");
INSERT INTO wbp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ngula-jangka, Yijakirli panu pirli yurturlurla murnju-yirrarnu yungurla ngulangkanya purranjarla kuyu yinyi warntarri YAAWIYI-ki. Manu nyanunguju rdiily-yirrarnurla YAAWIYI-ki pulka-pinjaku, manu-jana yapaku yimi-ngarrurnu kuja-ka nyina ngurrju YAAWIYI. Ngula-jangka, nyanungu manu yapa-patulu ngurrangka-jarrija yalumpurla kaluku-paturla, manu nyanungu-nyangu warrkini-patulu yanu, ngulalu mulju jinta-kari pangurnu. ");
INSERT INTO wbp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ngula-jangka, Pimaliki yanurnu Karara-jangka wangkanjaku Yijakiki. Wati-jarra-karirlangu-pala nyanungu-kurluju yanurnu: Yajujaju pinangkalpa manu nyanunguku kurdungurlu manu jinta-kari Payikuluju kujalpa-jana warrmarla-patuku Pimaliki-kirlangu-patuku paaju nyina. ");
INSERT INTO wbp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yijakirli-jana payurnu nyanungu-patu, “Nyiyakunkulu yanurnu nyampu-kurraju? Kulankujulu ngurrju ngajukuju nyinaja. Manunkujulu kulungku yilyaja.” ");
INSERT INTO wbp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nyanungu-paturlulu Yijaki yalu-manu, “Wurrangkulparnangkulu nyangu nyuntuju, manu karnalu milya-pinyi YAAWIYI-rli kangku palkangku mardarni. Ngula-jangka, wangkajarnalu-nyanu, ‘Yanirlipa manu wangkamirliparla Yijakiki nyampu-kurluku walya-kurluku manu ngapa-kurluku, ngula yungurlipa-nyanu yalala-yirrarni wiljiwilji-maninja-wangurlulku, manu kulu-wangulku yungurlipa nyinami rarralypa.’ Ngulakunyarnangkulu nyanjakuju nyuntukuju yanurnu. ");
INSERT INTO wbp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Kularnangkulu kulukukuluku-manurlangu-wiyi. Ngurrju-jukulparnangkulu nyinaja nyuntukuju tarnnga-juku, manu yilyajarnangkulu rarralypa kulu-wangurlu. Wangkaya-nganpa yungunpa-nganpa kulu-wangu pakarninja-wangu nyina. Manu jalangu, YAAWIYI-ji yimiri-nyayirni kangku nyina, manu kangku pirrjirdi-maninjarla warrawarra-kanyi.” ");
INSERT INTO wbp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ngula-jangka, Yijakirli yirrarninjarla purraja wiri kurapaka nyanungu-patuku, manulu panungku-juku ngarnu. ");
INSERT INTO wbp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mungalyurru-karilki, nyanungu-paturlulu-nyanu ngarrurnu yungulu nyiyarlangurlajinta kulu-wangulku nyinami. Kaaturlu-jana nyanungu-patu nyangu kuja-kurraju. Ngula-jangka, Yijakirli-jana jakuru-pungu wurnakungarntirli. Nyanungu-patuju, yipiljilkilpalu nyinaja rarralypa. ");
INSERT INTO wbp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Parrangka jintangka, Yijaki-kirlangu-patu warrkini-patulu kulpari yanurnu, manulurla nyanunguku wangkaja, “Pangurnurnalu mulju, manu palka-manurnalu ngapa yinya.” ");
INSERT INTO wbp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ngula-jangka, Yijakirli yirdi-manu ngula mulju ‘Jiipa’. Jalangujalangurlangu kirri ngula-wana mulju-wana kalu yirdi-mani ‘Piirrjipa’, ngulaju ‘Kirri Jangku-pinja-warnu’. ");
INSERT INTO wbp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kujarla 40-pala yulyurrpu rdipija kaja-nyanuku Yijaki-kirlanguku papardi-jurrkuku Yijuwuku, nyanungurlu-palangu mardukuja-jarra maninjarla rdakurl-kujurnu nyanungukulku. Kamparru-warnu yirdiji Jurdiji, manu nyanunguju yurntalpa Piirii-kirlangu, ngulalpa-jana nyinaja yapaku ngurrara-kari-wardingkiki ngula kalu-nyanu yirdi-mani ‘Yititi’. Jinta-kari mardukuja ngulaju yirdiji Pajama, manu nyanunguju Yalunu-kurlangu yurntalpa, ngulaju Yititi-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nyampu-jarra mardukuja-jarra, ngula-palangu Yijuwurlu nyanungu-kurra-manu, ngula-jarrarluju kulalu-palangu wardinyi-manu Yijaki manu Ripika, yalparukulu-palangu kalinjaju ngurrju-manu. ");
INSERT INTO wbp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Purlkalkulpa Yijakiji nyinaja. Nyanungu-nyangu milpa-jarraju ramalku yarrkayi-nyayirni, kulalpa jungangku nyiyarlangu nyangu. Ngaka-kari, nyanungujurla wangkaja yapaku yungu maninjini nyanungu-nyangu kaja-nyanu kamparru-warnu Yijuwu. Kuja yanurnu Yijuwu, Yijakiji wangkajarla nyanunguku, “Kaja.” Nyanungu yalu-manu Yijuwurlu, “Yuwayi, nyampu-wajarna.” ");
INSERT INTO wbp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ngula-jangka, Yijakirla wangkaja nyanunguku, “Ngajujurna purlkalku. Kalakarna marda palimirlangu. ");
INSERT INTO wbp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yanta, nyuntu-nyangu maninjinta yuurlarri, nyuntu-nyangu kurlarda-patu wita-patu manu kijirninja-kurlangu kurlarda wita-kurlangu, manu yanta yupuju-kurra wirlinyi. Yanta, manu kuyuju pungka ngajuku ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Purraya yangka-piya-juku yangka kuja karna ngampurrparlu ngarni, manu kangkarniji ngajuku. Ngula-jangka, palinjakungarntirli ngajulurlu kapurnangku nyuntuku miti-yirrarni nyiyarningkijarra yungunpa wiri nyina ngaju-wangurlalku. Kapurnangku ngajulurlu milki-yunparni nyuntuku panu-kurlu nyiyarningkijarra-kurlu ngurrju-kurlu kajingkili ngaka nyuntuku rdipimi.” ");
INSERT INTO wbp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Junga-juku, Yijuwuju wirlinyilki yanu yupuju-kurra. Ngulalparla Yijaki wangkaja nyampurra Yijuwuku, ngulaju kula-nganta yangarlu jirrama-mipalpa-pala-nyanu wangkaja. Kutu-yijala Ripikaju karrija, purda-nyangulpa-palangu, kulalpa-pala milya-pungu kujalpa nyanungu karrija palka yalumpurla, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ripikaju yanu, manu wangkajarla Jakupuku nyanungu-nyanguku kaja-nyanuku, “Wayinpa, purda-nyangurna jaji-puraji wangkanja-kurra nyuntukupurdangka-kurra papardi-puraji-kirra Yijuwu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Nyanungurla wangkaja Yijuwuku yungu wirlinyi yani, manu yungurla kanjarla ngurrju kuyu purrami nyanunguku. Nyanungu wangkajarla kuja Yijuwukuju, ‘YAAWIYI-rli yunguju ngajuku nyampu jaru-nyayirni-wangu, ngula-jangka palinjakungarntirli ngajulurlu karnangku nyuntuku milki-yunparni nyampu yungunpa tarnngangku mardarni.’ Kujanyarla Yijuwukuju wangkaja nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Yuwa, ngaju-nyangu kaja, ngajuju yalyangku purda-nyangka nyiyarlanguku kajirnangku wangka! ");
INSERT INTO wbp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Yanta yangka-kurra kuja kalu-jana warrkinirli ngalipa-nyangurlu warrawarra-kanyi ngalipa-nyangu jiyipi-wati manu narnukutu-wati. Manta-palangu kurdu-warnu-jarra narnukutu-jarra. Kangkarni-palangu ngaju-kurra, ngula-jangkarlu yungurna-palangu purrami ngurrju-nyayirnirli yangka-piya-juku kuja-ka ngampurrparlu Yijakirli ngarni. ");
INSERT INTO wbp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kangkarla kuyu jaji-purajiki ngarninjaku. Ngula-jangka, palinjakungarntirli, nyanungurlu kapungku nyuntuku milki-yunparni jaru-nyayirni-wangu yungunpa mardarni tarnngangku.” ");
INSERT INTO wbp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kala Jakupurla wangkaja kuja ngati-nyanuku Ripikaku, “Wurra, wurra! Papardi ngajukupurdangka Yijuwuju palkaju yumurrumurru. Ngajuju karalypa-nyayirni! ");
INSERT INTO wbp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kajilpaju ngajukupalangurlu jaji-pardurlu marnpikarla, kajikaju nyanungurlu milya-pinyi ngajuju kularna Yijuwu! Ngula-jangkarlu kulaju nyanungurlu ngajuku milki-yunparnilki jaru-nyayirni-wangu yalumpurra-kurlu ngurrju-kurlu nyiyarningkijarra-kurlu. Lawa, nyanungurlu kapuju juyurdurlu yunparni ngajulu yimirr-yinja-panu!” ");
INSERT INTO wbp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ngati-nyanurla wangkaja nyanungu-nyanguku kaja-nyanuku, “Kajilpangku jaji-purajirli yunpakarla nyuntu juyurdurlu, ngulaju ngaju-mipaju karlangka nyuntulurlaju yunparni juyurdurluju. Ngayiji ngaju kutu purda-nyangka, yanta manu maninjinta-palangu kurdu-warnu-jarra narnukutu-jarra.” ");
INSERT INTO wbp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ngula-jangka, Jakupu yanu, manu kurdu-warnu-jarra narnukutu-jarra-palangu manu, kangu-palangu ngati-nyanu-kurra nyanungukupalangu-kurra. Ngati-nyanurlu Ripikarlu-palangu pajurnu narnukutu-jarra wita-kari wita-kari-kirra, manu-palangu purraja yirnmi-karda-nyayirni yangka-piya-juku kuja kala ngampurrparlu Yijakirli ngarnu. ");
INSERT INTO wbp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ngula-jangka, Ripikaju yanu, jurnarrpa panu-kari manu kaja-nyanu-kurlangu Yijuwu-kurlangu papardi-nyanu-kurlangu, nyanungu-nyangu ngurrju-wati kujalparla kaninjarni yuwarlirla ngunaja. Nyanungurlurla yungu jurnarrpa Jakupuku yungu yukami. ");
INSERT INTO wbp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ngula-jangka, nyanungurlurla maninjarla rdaka-jarra-palangu Jakupu-kurlangu jutu-manu palkangku narnukutu-jangkarlu manu waninja-wanarlangu kujalpa karalypa nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ngula-jangka, nyanungurlujurla Jakupuku yungu kuyu manu mangarri kuja nyanungurlu-yijala purraja. ");
INSERT INTO wbp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kangurla Jakupurlu kuyu manu mangarri jaji-nyanuku, manu wangkajarla nyanunguku, “Wapirra.” Yijakirli yalu-manu, “Yuwayi, kaja, ngananpa nyuntuju?” ");
INSERT INTO wbp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakupuju nyanunguku wangkajarla, “Ngajujurna Yijuwu, nyuntu-nyangu kaja-puraji kamparru-warnu. Ngajurna wirlinyi yanu, manu karnangku kuyu mardarni nyuntuku, yangka ngulanpaju ngaju payurnu, ngulakunya. Nyinakalku, manu nganja nyampu kuyu ngularnangku nyuntuku wirlinyi-jangkarlu kangurnu. Ngula-jangkarlu yungunpaju milki-yunparni ngajuku jaru-nyayirni-wangu panu-kurlu ngurrju-kurlu nyiyarningkijarra-kurlu kajiji ngaka rdipimi ngajuku.” ");
INSERT INTO wbp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kala kuja Yijakirli payurnu nyanungu kujarlu, “Nyarrparlunpa palka-manu kuyuju, manu nyarrpa-karrarlunpa kapanku pinja-yanu?” Jakupurlu yalu-manu nyanungu, “YAAWIYI-rli nyuntu-nyangurlu Kaaturluju milki-yirrarnu nyarrpararla kuyuku yungurna parlu-pinjarla pinyi kuyuju.” ");
INSERT INTO wbp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ngula-jangka, Yijakirla wangkaja Jakupuku, “Kaja, kutu-jarriyaju ngajuku, ngula-jangkarlu yungulparnangku nyuntu marnpikarla. Kajirnangku ngajulurlu nyuntu marnpirni, ngula-jangkarlu kapurnangku milya-pinyi nyuntuju marda Yijuwu ngaju-nyangu kaja-nyanu-nyayirni, lawa yapa jinta-kari mardanpa.” ");
INSERT INTO wbp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ngula-jangka, Jakupurla kutu-jarrija Yijakiki jaji-nyanuku nyanungukupalanguku. Yijakirli nyanunguju marnpurnu, manu wangkajarla, “Kuja kanpa wangkami, nyuntu-nyangu linpaju Jakupu-piya karnangku purda-nyanyi. Kala kajilparnangku waku-jarra nyuntu-nyangu marnpikarla, ngulaju Yijuwu-kurlangu-piya yumurrumurru.” ");
INSERT INTO wbp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kuja-jangka, kujalpa waku Jakupu yumurrumurrulku nyinaja papardi-nyanu-piyalku Yijuwu-piyalku waku-jarraju, Yijakirli kula milya-pungu ngulaju Jakupu-nyayirni yalumpuju. Ngula nyanungurlu marnpurnu, kanginy-pungu nyanungurlu kula-nganta wati yalumpu Yijuwu. Ngula-jangka, wangkaja-nyanu kanunju-kari Yijakiji, “Nyampu-juku marda Yijuwuju, yungurnarla milki-yunparni jaru-nyayirni-wangu ngaju-nyanguju palinjakungarnti.” ");
INSERT INTO wbp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kala, yunparninjakungarntirli jaru-nyayirni-wangukungarntirli, nyanungurluju payurnu jintakulku, “Nyuntuju mayi junga kaja-nyanu ngaju-nyangu Yijuwu?” Jakupurlu nyanungu yalu-manu, “Yuwayi, ngajuju Yijuwu.” ");
INSERT INTO wbp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ngula-jangkajurla Yijakiji wangkaja nyanunguku, “Kujaju ngula-juku, kaja ngaju-nyangu! Kangkarniji ngajuku yalumpu panu-kari kuyu yungurna ngarni. Kajirna ngarni-wiyi, ngula-jangkarlu kapurnangku milki-yunparni nyuntuku jaru-nyayirni-wangu.” Ngula-jangka, Jakupurlurla kangurnu kuyu panu-kari Yijakiki, manu ngulaju ngarnu. ");
INSERT INTO wbp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ngula-jangka, wangkajarla jaji-nyanu Yijaki nyanunguku, “Yantarni nyampu-kurra, kutu-jarriya ngaju-kurra, manuju ngaju nyunjika.” ");
INSERT INTO wbp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ngula-jangka, Jakupurla yanu, manu nyunjurnu nyanungu. Yijakirli parnti-nyangulpa jurnarrpa yalumpurraju Yijuwu-kurlangu, ngula-jangka rdirri-yungu nyanungurlu yungurla milki-yunparni yalumpu jaru-nyayirni-wangu Jakupuku. Nyanungurlu yunparnu kuja-piyarlu, “Waraa! Kaja ngaju-nyangu-ka ngurrju-nyayirni parntimi yupuju-piya ngurrara-piya yangka kuja-ka parntimi. Ngulaju ngurrara kuja-ka YAAWIYI-rli nyiyarningkijarra ngurrju-mani pardinjaku wajirrki-nyayirniki! ");
INSERT INTO wbp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ngajulurlu karnangkurla payirni Kaatu yungungku wiri ngapa yilyamirni, manu yungu ngurrju-karda walya ngurrju-mani nyiyarningkijarra yungu ngulangka pardimi. Ngula-jangka, kapunpa mani panu ngurlu-wati kajili watiya-wati pardimi miyi-kirli, manu marna mangarriki kaji palka-jarrimi, kapunpa pama manu mangarrilki ngarniyi. ");
INSERT INTO wbp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ngajulurlu kapurnangkurla Kaatu payirni yungungku wiri yirrarni yapaku panuku ngurrara-kari ngurrara-karirlaku. Nyanungu-patu kapulu yanirni, manu kapungkulu parntarrimi kamparru nyuntuku, kuja-karrarlu yungungkulu wiri-pajirni. Ngajulurlu kapurnangkurla Kaatu payirni yungungku wiri yirrarni yungunpa-jana kukurnu-puraji-patuku wiri nyinami. Panu kapungkulu kaja-nyanu-patu ngati-puraji-kirlangu-patu parntarrimi kamparru nyuntuku. Kajingki nganangku-puka yunparni nyuntu juyurdurlu, Kaaturlu kapu-jana nyanungu-patuju maju-mani. Kajingki ngana-puka ngurrju nyuntuku nyinami, Kaaturlu kapu-jana nyanungu-patu pirrjirdi-maninjarla warrawarra-kanyi.” Kujanyarla Yijakirliji milki-yunparnu, manurla yungu Jakupuku yalumpu jaru-nyayirni-wangu, kuja nyanungurlu kanginy-pungu Jakupu kula-nganta nyanunguju Yijuwu-juku. Ngula-jangka, Jakupurlu kapankurlu yampinja-yanu jaji-nyanu yalumpurla-juku. ");
INSERT INTO wbp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kuja Jakupu yanu, nyanungukupurdangka papardi-jurrku Yijuwulku kulpari yanurnu wirlinyi-jangka. ");
INSERT INTO wbp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nyanungurlu pajirninjarla kuyuju purraja ngurrju-karda-nyayirni, manu kangurnurla jaji-nyanuku nyanungukupalanguku. Yijuwurla nyanunguku wangkaja, “Wapirra, yakarra-pardinjarla kuyu nyampu nganja kujarnangkurla yanu wirlinyi nyuntuku. Ngula-jangkarlu yungunpaju ngajuku milki-yunparni ngula jaru-nyayirni-wangu yungurnangku marlaja mardarni tarnngangku.” ");
INSERT INTO wbp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kala jaji-nyanurlu kuja Yijakirli nyanungu payurnu, “Wayinpa, ngananpa nyuntuju?” Yalu-manu Yijuwurlu, “Ngajujurna kaja-puraji papardi-jurrku Yijuwu, junga!” ");
INSERT INTO wbp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kuja purda-nyangu nyampu Yijakirli, ngarrurda nyanunguju rdirri-yungu mirrmirr-karrinjaku. Nyanungurlu payurnu Yijuwu, “Yuwa, nganalku yinyaju kujajurla ngajuku kuyuku wirlinyi yanu? Nganangkulkuju kuyuju kanjarla ngajukuju yungu kamparrurlu-wiyi nyuntulku kujanpa yanurnu? Nyurrurna ngajulurlu kuyuju ngarnu, manurnarla milki-yunparni jaru-nyayirni-wangu ngaju-nyangu yinyaku watiki! Kulalparnarla nyarrparlu puntakarla pina nyuntuku yunparninjakungarntirli, lawa! Yuwayi, panu yalumpurra ngurrju nyiyarningkijarra, ngula-jangka yimi-jangka kapurla rdipimi ngaka yinyaku watiki.” ");
INSERT INTO wbp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kuja Yijuwurlu nyampu purda-nyangu, kapanku yulaja nyanunguju kilji-nyayirni karrikarri-wangu. Nyanunguju maju-jarrija-nyayirni, manu wangkajarla jaji-nyanuku, “Wapirra, wapirra! Ngajurlanguku! Milki-yunpakaju ngajuku ngurrjurlangu yimirlangu! Muku yunpakaju ngurrju nyiyarningkijarra kajiji rdipimi ngaka ngajurlanguku!” ");
INSERT INTO wbp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kala Yijakirla wangkaja nyanunguku, “Nyuntukupurdangka kukurnu-puraji yanurnu, manu ngajuju yimirr-yungu. Nyurru-jukungku jurnta kangu nyanungurlu ngaju-nyangu jaru-nyayirni-wanguju nyuntu-kujakuju!” ");
INSERT INTO wbp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ngula-jangka, Yijuwurla wangkaja jaji-nyanuku nyanungukupalanguku, “Jakupu-kurlangu yirdi ngulaju-ka karri ‘Yimirr-yinja Wita-wangu!’ Ngulaju junga! Jirramaku nyanungurluju yimirr-yungu ngajuju. Nyurru-wiyiji jinyijinyi-manu ngaju yungurnarla yinyi nyiyarningkijarra nyuntu-nyangu warntarri-jangka kajinpa palimi. Jalangurlulkuju nyanungurlu jurnta kangu nyuntu-nyangu jaru-nyayirni-wangu ngajukuju!” Ngula-jangka, Yijuwurlu payurnu jaji-nyanu nyanungukupalangu, “Milki-yunpakaju kajikaji marda ngurrju nyiyarningkijarra mayi ngajuku ngaka rdipimi?” ");
INSERT INTO wbp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yijakirli yalu-manu nyanungu, “Nyurrurna milarninjarla wiri yirrarnu yungungku wiri nyinami nyunturlanguku. Panu nyanungukupurdangka-patu kapulurla nyanunguku warrki-jarrimi. Manu ngajulurlurna yurdujurra-manu nyanungu kuyu manu mangarri panu-kurlurlu manu pama-kurlurlangurlu. Kaja, kulalparnangku nyiyarlangu yungkarla, lawa.” ");
INSERT INTO wbp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Kala Yijuwurlu warlkurnulpa, manulpa mayangku-juku payurnu, “Jintarlangu marda kanpa jaru-nyayirni-wanguju mardarni, wapirra? Yungkaju jintarlangu! Milki-yunpakaju nyiyarlangu ngurrju marda nyiyarningkijarra yungulpaju ngajuku rdipiyarla!” Ngula-jangka, Yijuwu yulajalku. ");
INSERT INTO wbp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ngula-jangka, Yijakirlirla Yijuwuku milki-yunparnulku nyiya kajirla nyanunguku ngaka rdipimi, Yijakirli kujarlu yunparnu, “Kapunpa nyuntu wurnturu nguru-karirla ngurrju-wangurla nyinami, manu kuja-ka ngapa wita-mipa wantimi. ");
INSERT INTO wbp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kapunpa-jana nyuntulurlu warrarda pinyi kulungku panu-kari yapa-patu nyuntu-nyangu junma wiri-kirlirli, manu kapunparla warrki-jarri pirijina-piya nyuntukupurdangkaku kukurnu-purajiki. Kala kajinparla jurnta parnkami, kulalpangku wajirli-pinjarla warla-pajikarla, lawa.” ");
INSERT INTO wbp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ngula-jangkaju, Yijuwuju kalarla nyurunyuru-jarrija Jakupuku kujarla yangka kurdarrirdarrirli jurnta manu jaru-nyayirni-wangu nyanungu-jarrakupalangu-kurlangu jaji-nyanu-kurlangu Yijaki-kirlangu. Manngu-nyangu-nyanu Yijuwurlu, “Ngajukupalanguju kapu nyurru-wiyi-wangu palimi, manu kapurnarla nyanunguku yalparu-jarrimi. Kala ngula-jangkarlu kapurna pinyi Jakupulku.” ");
INSERT INTO wbp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Yaparla wangkaja Ripikaku ngulalparla Yijuwurlu jangkardu purda-nyangu yungu nganta Jakupu pinyi. Ngula nyanungurlu yapa jinta yilyaja maninjaku Jakupuku. Kuja nyanungu yanurnu, Ripikaju wangkajarla nyanunguku, “Ngajuju purda-nyangka. Nyuntukupurdangka papardi-puraji Yijuwuju, miyalu maju. Kala nyanungurluju kanyanu ngarrirni kujarlu nyarrparlungku pinyi nyuntulu. ");
INSERT INTO wbp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kajilpangku Yijuwurlu jalangurlangurlu nyuntu pungkarla, ngula-jangka yapa jinta-karirli marda kajikalu nyanunguju pinyi, kajikarna marda ngati-puka-jarrimi. Kuja-kujakuju, purda-nyangkaju nyarrpaku kajirnangku wangka. Ngajukupurdangka papardi-nyanu Lapana-ka nyinami Yarranarla. Yampiya nyampu nguru jalangurlu, manu yanta nyanungu-kurra! ");
INSERT INTO wbp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nyinaka nyanungurla ngari jalangu-wiyi kaji nyuntukupurdangka pulya-jarrimi, manu kajingki kulu wiri-wangulku nyuntuku nyinami. ");
INSERT INTO wbp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ngaka, nyuntukupurdangka papardi-puraji kapungku nyuntuku kulu-wangulku nyinami. Nyanungurlu kapu wajawaja-mani nyiyarningkijarra kujanparla nyanunguku jurnta kangu nyuntulurlu. Ngula-jangka kapurna ngajulurlu yilyamirra warrkini jinta yungungku nyuntu kulpari kanyirni nyampu-kurra.” ");
INSERT INTO wbp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ngula-jangka, Ripikaju yaninjarla wangkajarla kali-nyanuku Yijakiki, “Ngaju karna-jana rdunjurdunju-jarrimi nyampu-patuku mardukuja-patuku Yititi-patuku ngula kalu nyinami nyampurla-yijala ngurrararla. Ngali-nyangu kaja-nyanu Yijuwu, nyurru-juku yupukarra-jarrija jirrama-kurlu maju-jarra-kurlu Yititi-jarra-kurlu. Kajilpa-nyanu Jakupurlu nyanungu-paturlajinta mardukuja nyanungu-kurra-mantarla, ngulaju yungurna kutu-palimi ngajuju.” ");
INSERT INTO wbp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yijakirlirla yilyaja yimi Jakupuku yungu yaninjarla nyanyi nyanungu. Kuja Jakupu yanurnu, jaji-nyanu nyanungukupalangurla wangkaja nyanunguku yungu pirrjirdi-mani, “Kulalpanpa-jana mantarla mardukuja-patu Kanana-wardingki-patu, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Karrinja-pardinjarla-mipa Patana-Yarrama-kurra yanta. Ngulangkanya kala ngati-purajikipalangu jaji-nyanu nyinajayi yirdi Pijulu. Jalangu, Lapana ngati-purajikipurdangka papardi-nyanu-ka nyinami-juku yinyarlaju. Yanta, manu-nyanu yurntalpa nyanungu-nyangu nyuntuku manta.” ");
INSERT INTO wbp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ngula-jangka, Yijakirla wangkaja nyanungu-nyanguku kaja-nyanuku yimi-nyayirni-wangu panu-kurlu ngurrju-kurlu nyiyarningkijarra-kurlu ngulangku Kaaturlu kajirla nyanunguku yinyi, wangkajarla nyanungu: “Ngaju karnangkurla wangkami Kaatuku yangka YALJATAYI-ki. Ngaju karnangkurla nyanungu payirni nyunturlanguku, ngula-jangka yungungku nyuntu pirrjirdi-maninjarla warrawarra-kanyi, manu kurdukurdu panu-nyayirni yungunparla marlaja kurduwarr-kijirni. Ngajulurlu karnangkurla nyanungu payirni jalangurlu, ngula-jangka ngaka kapungkulu panungku yapa-kari yapa-karirli turnu-kari turnu-karirli nyuntu nyanungurrarlu wapirra-pajirni. ");
INSERT INTO wbp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngajulurlu karnangkurla payirni yungungku warringiyi-puraji-piya pirrjirdi-maninjarla warrawarra-kanyi manu nyuntu-nyangu kurdukurdurlangu. Nyanungurlu jangku-pungurla nyampu nguru yungurla yinyi nyanunguku. Nyinami kanpa nyuntu ngurungka nyampurla jalangu, kala nyampu nguru kajana tarnnga-juku karrimi yapaku panu-kariki. Ngula-jangka, ngaju karna payirni Kaatu yungunkulu-nyanu ngaka nyurrurlarlu nguru nyampu mani.” ");
INSERT INTO wbp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ngula-jangkaju, Yijakirli yilyaja Jakupu. Jakupu yanu wurnturu yinya-kurra ngurrara Patana-Yarrama-kurra kujalpa ngulangka nyinaja malirdi-nyanu Lapana. Lapana, ngulaju Ripikakupurdangka papardi-nyanu. Nyanungu-jarrakupalanguju Pijulu, ngulalpa nyinaja ngurrararla Yarramarla. Ripikaju ngamardilpa-palangu nyinaja yalumpu-jarraku papardirlanguku Jakupuku manu Yijuwuku. ");
INSERT INTO wbp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yijuwurlujulpa-palangu nyurru-juku kali-nyanu-jarra mardarnu. Nyanungurlu purda-nyangu ngularla Yijaki nganta wangkaja Jakupuku yungu pirrjirdi-mani manu nganta yilyaja nyanungu yungu nyinami Patana-Yarramarla manu yungu-nyanu nganta mani kali-nyanu yalirlalku. Yijuwurlu purda-nyangu kujarla nganta Yijakirli pututu-pungu Jakupuku yungu Kanana-wardingki mardukuja yampimi maninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yijuwurlu milya-pungu kuja-palangu Jakupu ngungkurr-nyinaja jaji-nyanuku manu ngati-nyanuku manu kuja nyurru-juku yanu Patana-Yarrama-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Nyanungurlu manngu-nyangu kuja, “Kajilparlipa-jana ngali-jarrarlu karnta mantarla Kanana-wardingki, kujarlaju kajika miyalu maju-jarrimi jaji-nyanuju ngalikipalangu. Kala ngajulurlu kapurna mardukuja jintarlanguju kutu-mani.” ");
INSERT INTO wbp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ngula-jangka, Yijuwu yanu jaji-nyanu Yijakikipurdangka-kurlangu-kurra papardi-nyanu-kurra Yijimali-kirra, ngulajulparla kaja-nyanu kamparru-warnu nyinaja Yipuruyamuku. Nyanungurlu-nyanu nyanungu-kurra-manu Yijimali-kirlangu yurntalpa Mayala ngulalpa nyinaja ngurrararla Kananarla. Mayalaju ngawurru-nyanu Napatakupurdangka. ");
INSERT INTO wbp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nyampu yimi ngulaju Jakupu-kurlu ngula yampija ngurrara nyanungu-nyangu manu yanu nyinanjaku Patana-Yarrama-kurra. Kuja Jakupurlu yampija ngurrara nyanungu-nyangu Piirrjipa, nyanunguju kamparruju yanu Yarrana-kurra-pinangu. ");
INSERT INTO wbp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Munga-karirla, yaninja-karra jalja-juku, ngula wanta yukajarra, nyanunguju ngurrangka-jarrijalku. Nyanungurla rdipija pirliki, manu-nyanu jurruku katarlpi yirrarnu, manu ngulangka jarda ngunanja-wantija. ");
INSERT INTO wbp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nyanungurlu jukurr-manu, manu nyangu nganayi wari-yaninja-kurlangu-piya kujalpa walyangka karrija kankarlarra-kari nguru-nyayirni-wangu-kurra Kaatu-kurlangu-kurra. Jakupurlu-jana marramarra panu Kaatu-kurlangu-patu nyangu warrkarninja-kurra manu jitinja-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Wayinpa! Yinyaju YAAWIYI kankarlarni-nyayirni karrinya wari-yaninja-kurlangurla! Ngula-jangka, wangkajarla YAAWIYI jukurrparla Jakupuku, “Ngajujurna YAAWIYI. Ngajuju Kaatu, yangka-juku kujalpaju nyuntu-nyangurlu warringiyirli Yipuruyamurlu puraja. Manu ngajujurna Kaatu yangka-juku kujalpaju jaji-purajirli Yijakirli puraja. Nyampurla walyangka kuja kanpa jalangu jardalku ngunami, kapurnangku yinyi nyuntuku manu nyuntu-nyanguku panuku kurdukurduku manu yapaku nyanungurra-nyanguku. ");
INSERT INTO wbp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nyanungu-patu yapa-patu kapulu panu-nyayirni nyina, nama-piya. Nyanungu kapulu pirri-yani yinya-kari yinya-kari-kirra, karlarra-kurra, kakarrara-kurra, yatijarra-kurra manu kurlirra-kurra. Nyuntu manu nyuntu-nyangu-purnu kuja kankujulu wala nyina ngajuku, kujarlanya yapa-kari yapa-kari nguru warrukirdikirdi kapulu-nyarra marlaja nyina wardinyi nyurrurlaku. ");
INSERT INTO wbp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ngajuju palka karnangku nyina, manu kapurnangku muurlparlu nyuntu warrawarra-kanyi nyarrpararlangu kajinpa yani. Ngaka kapurnangku kulpari kanyirni ngurrara nyampu-kurra. Ngajulurlu kularnangku nyuntu yampimi. Nyiyarningkijarra kujarnangku jangku-pungu, kapunpaju marlaja mardarni kujarnangku yangkaju wangkaja.” ");
INSERT INTO wbp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Ngula-jangka, yakarra-pardija Jakupu jukurr-maninja-warnu. Nyanungu lani-jarrijalku, manu-nyanu wangkaja nyanungu-juku, “Junga, YAAWIYI-ka palka jalangu nyinami nyampurla, kala kularna milya-pungu kujaju kamparruju! Tarrukurlu ngurungku nyampurlu kaju ngaju lani-mani! Nyampuju yuwarli Kaatu-kurlangu-juku, manu nyampu wari-yaninja-kurlangu-ka yani kankarlarra-kari nguru-nyayirni-wangu-kurra Kaatu-kurlangu-kurra.” Ngula-jangkaju, pina jarda-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mungalyurrulku, Jakupuju yakarra-pardija. Nyanungurlu jarna-manu ngula pirli kujalpa jarda katarlpirla nyanungurla ngunaja, manu juka-yirrarnu kankarlarra-kari walyangka. Ngula-jangka, jararla winjurnu kankarlarniki. ");
INSERT INTO wbp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Jakupurlu yirdi-manu ngula ngurrara ‘Pijili’. Kamparru-wiyi, yapangku kalalu kirri ngula-wana yirdi-manu ‘Luuju’. ");
INSERT INTO wbp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kujalpa nyanungu Kaaturlu nyangu jara winjirninja-kurra, Jakupu-nyanu wangkaja, “Ngajulurlu yungurna Kaatu purami, manu yunguju ngaju muurlparlu warrawarra-kanyi nyiyarningkijarra-kujaku maju-kujaku wurnangka nyampurla. Nyanungurlu yunguju ngajuku yinyi kuyu, mangarri ngarninjaku manu jurnarrpa rdarnka-yirrarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Ngula-jangka, kularna nyiyarlanguku wajampa-jarri, manu ngaka kapurna kulpari yanirni yuwarli-kirra jaji-pardu-kurlangu-kurraju nyinanjaku. YAAWIYI-ji kapu ngaju-nyangu tarnnga-juku nyinami. ");
INSERT INTO wbp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kajiji nyanungu ngajuku yimiri jirrnganja nyinami manu muurlparlu ngaju warrawarra-kanyi, manu kajiji yinyi kuyu, mangarri, manu jurnarrpa, ngula-jangka nyampu pirli kapurna walyangka kankarlarra-kari juka-yirrarni, ngulaju yuwarli Kaatu-kurlangu. Nyiyarlangu kuja karna ngajulurlu mardarni, kapurna-jana yurturlu-patu-kurra karlarla-pala-kurra yira-kari yira-kari mani, manu yurturlu jinta-kariji kapurnarla Kaatuku kulpari yinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Pijili-ngirli, Jakupu yanu kakarrara-purda. Ngakalku, nyanungu ngurrara-kurra yukajarra ngulalpalu yapa-patu nyinaja kuja kalalu-jana nyanungu-patu kakarrara-wardingki-pajurnu. ");
INSERT INTO wbp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Kujalpa nyanungurlu ngurrara warru nyangu, rdipijarla muljuku. Wiri-jarlu lalypa pirlilparla muljuku kankarlumparra wapirrija. Kutu-yijalalpalu jiyipiji yurturlu-paturla parntarrija. Jiyipi yalumpurra kalalu yanurnu parra-kari parra-kari ngula-kurra mulju-kurra ngapaku ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Parra-kari parra-kari, jiyipikingarduyu-paturlu kalalu-jana jarnku-mirnimirnirli turnu-kari turnu-kari warrawarra-kangu, ngulangku kalalu-jana yalumpurraku jiyipiki nguru-yirrarninja-yanu ngula-kurra mulju-kurra walyuru-maninjaku. Nyanungu-paturlu kalalu ngula wiri-jarlu pirli ngurl-kangu kankarlarni-jangka mulju-jangka, ngula-jangkarlu nyanungurra-nyangu jiyipi kalalu-jana ngapangku walyuru-manu. Ngaka kuja kalalu jiyipi ngapangku walyuru-manu, kulpari ngurl-kangu kalalu pirli mulju-kurra kankarlarni-kirra parnta-yirrarninjaku jiyipikingarduyu-paturlu. ");
INSERT INTO wbp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakupurlu-jana payurnu yalumpu jiyipikingarduyu-patu, “Ngajukupurdangka-patu, nyarrpara-wardingkinkili nyurrurlaju?” Yalu-manulu nyanungu-paturlu, “Nganimpaju Yarrana-wardingki-patu.” ");
INSERT INTO wbp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ngula-jangka, Jakupurlu-jana nyanungu-patu payurnu, “Milya-pinyi mayi kankulu wati yirdi Lapana warringiyi-nyanu Nayuru-kurlangu?” Yalu-manulu nyanungu-paturlu, “Yuwayi, nyanunguju milya-pinyi karnalu.” ");
INSERT INTO wbp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ngula-jangka, Jakupurlu-jana nyanungu-patu payurnu, “Ngurrju mayi nyanunguju, nyiyarningkijarra-kurlu palka-kurlu mayi-ka nyina nyanunguju?” Yalu-manulu nyanungu-paturlu, “Yuwayi, nyanunguju ngurrju. Nyangka! Nyampunya-ka yanirnilki Rajulu yurntalpa nyanungu-nyangu, nguru-yirrarni kajana jiyipilki nyanungukupalangu-kurlangu.” ");
INSERT INTO wbp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ngula-jangka, Jakupu-jana wangkaja nyanungu-patuku, “Murnma-juku, nyampuju parra wiri karlarla-puru! Nyampuju mirntangali-jiki murnma-juku munga-wangu jiyipiki ngunanja-yirrarninjakuju. Yungkalu-jana ngapa yungulu ngarnilki, manu ngula-jangka, marna-kurralu-jana kulpari nguru-yirraka, manu yungulu wuraji-kardarlu warrarda ngarni.” ");
INSERT INTO wbp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kala yalu-manulu nyanungu-paturlu, “Kularnalu-jana jiyipiji ngapangkuju walyuru-manu murnma-juku. Pardarni karnalu-jana kajili panu-kari jiyipikingarduyu-patu rdipimirni jiyipi nyanungurra-nyangu-kurlu. Ngula-jangka, turnungku karnalu pirli ngurl-kanyi mulju-jangka yungurnalu-jana jiyipi nganimpa-nyangu ngapangku walyuru-mani.” ");
INSERT INTO wbp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ngulalpa-jana Jakupu wangkaja-juku yalumpurraku jiyipikingarduyu-patuku, Rajuluju yanurnu jiyipi-kirli nyanungukupalangu-kurlangu-kurlu. Nyanunguju jiyipikingarduyu-yijala, manu jiyipi nyanungukupalangu-kurlangu kala-jana nyanungurlu warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jakupurlu nyangu Rajulu yaninjarni-kirra, yurntalpa Lapana-kurlangu, manu-jana nyangu nyanungurlu jiyipi Lapana-kurlangu. Nyampu wati Lapana, ngulaju papardi-nyanu Ripikakupurdangka kujalparla nyinaja ngati-nyanu Jakupuku. Ngula-jangka, Jakupu yanu, manu pirli yinya wiri mulju-jangka kankarlarni-jangka ngurl-kangu, manu ngula-jangka, nyanungurlu-jana walyuru-manu jiyipi Lapana-kurlangu. ");
INSERT INTO wbp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ngula-jangka, nyanungurlu yaninjarla nyunjurnu Rajulu, manulparla yulajalku. ");
INSERT INTO wbp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ngula-jangkarlu-nyanu Rajulu-kurra yimi-ngarrurnu, wangkajarla, “Ngajujurna ngarrmara-puraji nyuntukuju. Ripikaju ngaju-nyangu ngati-nyanu, nyuntuku pimirdi-nyanu Lapanakupurdangka.” Ngula-jangka, Rajulu ngurra-kurra parnkaja, warnkiri-manunjunu jaji-nyanuju. ");
INSERT INTO wbp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kuja purda-nyangu yimi Lapanarlu ngawurru-nyanu-kurlangu kaja-nyanu-kurlu Jakupu-kurlu, nyanungu parnkaja ngamurlu-mardarninjaku. Lapanarlu ngamirlji-manu Jakupu, manu nyunjurnu wirlki-jarra. Nyanungu kulparirli kangu yuwarli nyanungu-nyangu-kurra. Yinyarla, Jakupurlu-nyanu yirri-puraja Lapana-kurra wurna-kurlu nyiyarningkijarra-kurlu kuja nyanungu yanurnu. ");
INSERT INTO wbp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lapana wangkajarla nyanunguku, “Nyuntu ngaju-nyangu miyalu wungu-warnu, nyuntu jinta-warnu-juku yalyu-warnuju manu palka-warnuju.” Junga-juku, Jakupuju yalumpurla-juku nyinaja Lapanarla kirntangiki jintaku, manulparla nyanunguku warrki-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ngula-jangka, Lapanarla wangkaja Jakupuku, “Nyuntuju ngaju-nyangu miyalu-warnu, kala kajinpaju ngajuku warrarda warrki-jarrimi, yungurnangku nyuntu payi-mani nyiyarla-ngurlu. Nyiyarnangku nyuntukuju yinyi warrki-jangkakuju?” ");
INSERT INTO wbp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lapanarlulpa-palangu yurntalpa-jarra mardarnu. Yirdi kapirdi-nyanuju Liiya, manu ngawurru-nyanuju Rajulu. ");
INSERT INTO wbp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","18","Liiyaju ngawu-karrikarri, manu milpa-jarraju yurrini. Kala Rajuluju yuntardi-nyayirni, manulparla nyanungukuju yulkaja-nyayirni Jakupuju. Ngula-jangka, nyanungurlu payurnu Lapana, “Ngurrju mayi kajilpanpaju Rajulu nyuntu-nyangu walyirri yurntalpa yungkarla? Kajinpaju nyanungu yinyi ngajuku, kapurnangku nyuntuku warrki-jarri wirlki-palaku yulyurrpuku.” ");
INSERT INTO wbp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lapanarla ngungkurr-nyinaja Jakupukuju, manurla wangkaja, “Kujaju ngula-juku. Kala kajilpanpa yampiyarla Rajulu nyuntu-kurra-maninja-wangurlu, ngulaju kajika-nyanu kutu mani wati-karirlanguju ngajulurla ngampurrpa-wangurla ngayi. Kala ngampurrpa karnangku nyina nyuntuku yungunpa nyampurla-juku nyinami ngajulurla.” ");
INSERT INTO wbp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ngula-jangka, Jakupurla warrki-jarrija Lapanaku yulyurrpu wirlki-palaku yungu-nyanu yangka ngari Rajulu nyanungu-kurra-mani. Ngulaju tarnnga-nyayirnilparla warrki-jarrija, ngulaju ngula-juku. Nyanungu Rajuluku yulkaja-nyayirnilparla, manu ngula yulyurrpu wirlki-pala-jarrija, ngulajurla nganta tarnnga-nyayirni-wangu karrija rdangkarlpa. ");
INSERT INTO wbp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ngakalku, yulyurrpu wirlki-pala-jangka warrki-jangka, Jakupuju yaninjarla wangkajarla Lapanaku, “Kujaju ngula-juku, ngajulurlurnangku nyuntuku warrki nyurru yulyurrpu wirlki-palaku lawa-manu ngari yangka kujarnangku nyuntu wangkaja. Yungkaju Rajulu yungurlijarra nyinamilki.” Ngulakujurla Lapanaju ngungkurr-nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ngula-jangka, Lapanarlu-jana yapa nyanungu-nyangu muku turnu-manu, manulu-jana jirrnganja ngarnu kuyu manu mangarri. ");
INSERT INTO wbp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","Ngulangka mungangka jintangka, Lapanarlurla kangu Liiya kapirdi-nyanu yurntalu-nyanu Jakupuku. Ngurrangka-pala ngunaja. ");
INSERT INTO wbp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mungalyurrulku, Jakupuju jurnta kinyirr-ngarnu. Nyanungurlu manngu-nyangu kula-ngantalpa ngunaja Rajulu-kurlu, kala Liiya-kurlu. Ngula-jangka, nyanungurla yaninjarla wangkaja Lapanaku, “Wayinta! Nyarrpa-jarrijanpaju ngajukuju? Nyiya-jangkanpaju yulyurlku-yungu kujarluju? Ngajurnangku mata-karda nyuntuku warrki-jarrija yungurnaju ngula-jangkarlu ngaju-kurra-mani Rajulu, kula Liiya!” ");
INSERT INTO wbp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lapanarlu yalu-manu nyanungu, “Nganimpa-nyangurla ngurrararla, kapirdi-nyanu-wiyi-ka watingkiji nyanungu-kurra-mani kamparruju ngawurru-nyanukuju, kujanya kuruwarri nganimpa-nyangu. ");
INSERT INTO wbp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nyinaka Liiya-kurlu-wiyi wiyiki jintaku purlapa-puru yungunpa-nyanu nyuntu-kurra-mani, manu ngula-jangka ngajulurlu kapurnangku Rajulurlangu yinyi yungunpa-nyanu nyuntu-kurra-mani. Rajulu-wanawanaju yungunpaju warrki-jarri ngajuku yulyurrpu wirlki-pala-karikilki.” ");
INSERT INTO wbp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ngula-jangka, Jakupurla ngungkurr-nyinaja Lapanaku, manu nyinaja Liiya-kurlu wiyiki jintaku. Ngula-jangka, Lapanarlurla nyanunguku yungu Rajuluku yungu-nyanu nyanungu-kurra-mani. ");
INSERT INTO wbp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","30","Jakupu manu Rajulu, ngurungka-pala ngunaja. Nyanunguju yulkaja-juku-jalalparla wita-karrikarri Liiyakuju. Kala nyanungu junga-nyayirnilparla Rajulukuju karrikarri-wangu-nyayirni yulkaja. Manu ngula-jangka, warrki-jarrijalparla nyanungu Lapanakuju yulyurrpu wirlki-pala-karikilki. Ngaka-karilki, Lapanarlurla yungu Rajuluku nyanungu-nyangu jinta karnta warrkini yirdiji Piilya, ngula-jangka yungurla nyinami manu warrki-jarrimi nyanunguku. ");
INSERT INTO wbp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","YAAWIYI-rli nyangu Jakupu ngulalparla yulkaja Rajuluku karrikarri-wangu Liiya-piya-wanguku. Ngula-jangka, nyanungu jalajala-jarrija yungurla nganta kurdukurdu yinyi Liiyaku. Kala ngawurru-nyanuku kularla kurdukurduju palka-jarrija nyiya-jangkaku mayi? ");
INSERT INTO wbp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liiyaju juni-parnta-jarrija, manu karrmulypa-jarrija, kurdu wirriya mardarnu. Ngula-jangka, wangkaja, “YAAWIYI-rliji ngaju manngu-nyangu jata-nyanja-kurra. Kuja karna kurdu kajalku mardarni, kali-nyanu ngaju-parnta kapuju ngajuku yulkami!” Kujarlaju, yirdiji Ruupunuju kaja-nyanukuju Liiyarluju yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ngula-jangka, Liiyaju yarda juni-parnta-jarrija, manu karrmulypa-jarrija, kurdu wirriya-karilki yarda mardarnu. Ngula-jangka, nyanungu wangkaja, “YAAWIYI-rliji purda-nyangu ngula kaju kali-nyanu ngaju-parnta nyinami ngajuku yulkanja-wangu. Ngula-jangkanyaju YAAWIYI-rliji kaja nyampu yunguju ngajuku.” Kujarlaju, Liiyarluju kaja-nyanu-kariji yirdi-manu Jimiyani ");
INSERT INTO wbp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ngula-jangka, Liiyaju yarda juni-parnta-jarrija, manu karrmulypa-jarrija, kurdu wirriya-karilki yarda mardarnu. Ngula-jangka, nyanungu wangkaja, “Ngajurnarla yungu ngaju-parntaku kaja-nyanu-patu yunguju nyanungurlu ngamurlu-mani ngaju.” Kujarlaju, nyanungurlu jinta-kari nyampu kaja-nyanu yirdi-manu Liipi ");
INSERT INTO wbp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ngaka-kari Liiya yarda karrmulypa-jarrija kurdu-kari-kirlilki wirriya-kari-kirli. Ngula-jangka, nyanungu wangkajarla, “Jalangurlu kapurnarla YAAWIYI-ki pulka-pinyi!” Kujarlaju, nyanungurluju purdangirli-warnu nyampu kaja-nyanu yirdi-manu Juurda ");
INSERT INTO wbp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ngula-pururlu kularla Rajulurlu kurdu manu nyanungu-parntaku Jakupuku. Ngula-wanawanaju, kapirdi-nyanukujurla yunnganji-jarrija. Manu yaninjarlarla wangkaja Jakupuku, “Kajinpaju kurdu yinja-wangurlu mardarni, kapurna ngajuju palimi!” ");
INSERT INTO wbp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakupurla nyanunguku kulu-jarrija, manurla wangkaja, “Wayinpa! Kularna ngajuju Kaatu! Kulalparnangku nyarrparlu yungkarla! Kaaturlunyangku nyuntuju warla-pajurnu kurdukurdu mardarninja-kujakuju!” ");
INSERT INTO wbp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ngularla Rajulu nyanunguku wangkaja, “Mpa! Kangka warrkini ngaju-nyangu karnta Piilya, manu ngunaka nyanungu-kurlu. Kaji kurdu nyanungurlu mardarni, ngulaju kaju yinyi ngajuku, ngula-jangkarlu yungurnaju wungu-warnu ngajuku warlalja mardarni manu wiri-mani.” ");
INSERT INTO wbp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ngula-jangka, Rajulurlurla karnta warrkini Piilya yungu Jakupuku yungu-nyanu jinta-kari kali-nyanu mardarni, manu ngunaja nyanungu-kurlulku. ");
INSERT INTO wbp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Piilyaju juni-parnta-jarrija, manu ngaka-karilkirla kurdu wirriya mardarnu Jakupuku. ");
INSERT INTO wbp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ngula-jangka, wangkaja Rajulu, “Kaaturluju ngaju jungarni-pajurnu warntarla-wangu. Purda-nyanguju payirninja-kurra ngaju, yangka-piya kuja purda-nyangu Liiya, manuju yungu kaja ngajukuju.” Kujarlaju, Rajulurlu yirdi-manu yalumpu kurdu wirriya Taanu. ");
INSERT INTO wbp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ngula-jangka, yarda juni-parnta-jarrija Piilyaju, manu kurdu-karilkirla mardarnu wirriya Jakupukuju. ");
INSERT INTO wbp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rajulu wangkaja, “Ngajulurlulparna Kaatu warrarda payurnu kurdukurduku ngula yungurnarla Liiyaku kapirdiki ngajukupurdangkaku parrparda-juku nyinami. Ngajujurna parrpardalku nyanunguku.” Kujarlaju, Rajulurlu kurdu wirriya yirdi-manu Napatali. ");
INSERT INTO wbp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liiyarlulpa-jana kaja-nyanuju mirdi-pala-juku mardarnu panu-wangu. Kujarlajurla nyanungu-nyangu karnta warrkini Jiilpa yungu kali-nyanu jinta-kari Jakupuku. ");
INSERT INTO wbp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ngaka, Jiilparlajinta Liiyaku kurdu wirriya-kurlu karrmulypa-jarrija yalumpu yungurla Liiyarlu kaja-nyanu yinyi Jakupuku. ");
INSERT INTO wbp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liiya wangkaja, “Kuja-piyaju ngurrju-nyayirni ngajuku rdipija!” Kujarlaju, kurdu yalumpu yirdi-manu Kaardu. ");
INSERT INTO wbp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ngaka-karilki, Jiilparlajinta Liiyaku kurdu wirriya-kari-kirlilki karrmulypa-jarrija yalumpu yungurla Liiyarlu yinyi Jakupuku. ");
INSERT INTO wbp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liiya wangkaja, “Wardinyi-nyayirni ngajuju jalanguju. Panungku mardukujarlu kapujulu ngaju wardinyi-pajirni.” Kujarlaju, yalumpu kurdu wirriya yirdi-manu Yaaja. ");
INSERT INTO wbp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ngaka-karilki, mangarri ngurlu-piya kujalpalu yalumpurlarlu ngurrararlarlu yapangku maninja-parnkaja, Ruupunu yanu yinya-kurra kujalpalu warrki-jarrija, manu rdipijarla watiya witaku jinjirla-kurluku. Ruupunurlurla yalumpu maninjarla kulpari kangu ngati-nyanuku Liiyaku. Rajulurlu nyangu kuja-kurra, manurla Liiyaku wangkaja, “Mari-jarriyaju, yungkaju parrka panu-kari nyuntuku kujangku manu kaja-purajirli.” ");
INSERT INTO wbp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Liiyarlu yalu-manu, “Yampiyarla! Nyurrunpaju ngaju-parntaju puntarnu. Yungunparla marda ngaju-nyangu kajarlanguku marda parrka juni-parnta-maninja-kurlangu jurnta kangku!” Kala Rajulujurla yarda wangkaja, “Kajinpaju ngajuku yinyi panu-kari parrka kaja-puraji-kirlangu, kapunpa yaninjarla ngunami Jakupu-kurlu mungangka jalangu.” Ngula-jangka, kujakujurla ngurrju-jarrija Liiyaju Rajulukuju. ");
INSERT INTO wbp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ngulangka mungangka jintangka, kuja Jakupu ngurra-kurra kulpari yanurnu warrki-jangka, Liiyajurla yaninjarla rdipija jalja-juku. Wangkajarla Jakupuku, “Ngajurnarla Rajuluku juni-parnta-maninja-kurlangu parrka yungu kujaju manu Ruupunurlu kajangku ngaju-nyangurlu. Ngalijarra karli ngunanjarla jinta-jarrimi mungangka jalangu.” Junga-juku, ngulangka mungangka Jakupuju ngunaja Liiya-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kamparru nyampukungarnti, Liiyarlu kala Kaatu payurnu yungu yarda ngurrju-mani juni-parnta-jarrinjaku. Kaaturlu purda-nyangu wangkanja-kurra, junga nyanunguju yarda juni-parnta-jarrija, manu karrmulypa-jarrija wirriya-kari-kirli, mardarnulpa-jana kaja-nyanuju rdaka-palalku. ");
INSERT INTO wbp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ngula-jangka, Liiyaju wangkaja, “Ngajurna Kaatu yipiljipilji-manu kaja jinta-karikilki. Ngajurnarla Jakupuku ngaju-nyangu karnta warrkini Jiilpa yungu kali-nyanuku yungu-nyanu mardarni. Kuja-jangkarlunyaju Kaaturluju ngajukuju kaja-kariji yungu.” Kujarlaju, Liiyarlu kaja-nyanu yirdi-manu Yijaka. ");
INSERT INTO wbp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ngaka-karilki, Liiyaju yarda juni-parnta-jarrija manu karrmulypa-jarrija kurdu-kurlu wirriya-kurlu jinta-kari-kirli, ngulajulpa-jana kaja-nyanuju jika-palalku mardarnu. ");
INSERT INTO wbp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ngula-jangka, wangkaja nyanunguju, “Kaaturluju ngajukuju yungu warntarri ngurrju-nyayirni! Ngajurnarla yungu ngaju-parntaku jika-pala kaja-nyanu-patu. Ngula-jangka kapuju nyanungurlangurlu warntarriji ngajukuju yinyi!” Kujarlaju, Liiyarlu kaja-nyanu yirdi-manu Jupulunu. ");
INSERT INTO wbp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ngaka-karilkirla Liiyaju karrmulypa-jarrija kurdu-kurlu karnta-kurlu, manu yirdi-manu Tiina. ");
INSERT INTO wbp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nyampurra-pururlu, Rajulurlu kala Kaatu payurnu yungu ngurrju-mani nyanungu juni-parnta-jarrinjaku. Junga Kaaturlu ngurrju-manu nyanunguju yungu-jana palka-maninjarla kurdukurdu mardarni. ");
INSERT INTO wbp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","Rajuluju juni-parnta-jarrijalku, manu karrmulypa-jarrija kurdu-kurlu wirriya-kurlu. Wita nyanungu yirdi-manu Jajupu manu wangkaja, “Kurdu-wangu kamparru, ngajulparnaju kurnta-jarrija. Kala jalangurluju Kaaturluju wardinyi-manu kurnta-wangulku. Kala yunguju ngajuku YAAWIYI-rli kaja jintalku yarda yinyi.” Kujarlaju, Rajalurlu kaja-nyanu yirdi-manu Jajupu. ");
INSERT INTO wbp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kuja Jajupu palka-jarrija, ngula-jangka Jakupurla wangkaja Lapanaku, “Yungurna warlalja-kurra ngurra-kurra kulpari-jarrimi ngurrara ngaju-nyangu-kurra. Kulaju ngaju warla-pajika jarraly-pinja-wangurlu! ");
INSERT INTO wbp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Yungkaju ngaju-parnta-patu manu kurdukurdu ngaju-nyangu, ngularra-kurlu yungurna ngurrara-kurra kulpari yani. Ngajurnangku nyuntuku warrki-jarrija mata-karda, ngularrarlajinta yungurnaju mardarni ngajulurlulku. Milya-pinyi kanpa junga kujaju.” ");
INSERT INTO wbp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kala Lapanarla wangkaja, “Kajilpanpaju wardinyi nyinayarla ngajuku, ngulaju nyinaya nyampurla-juku yaninja-wangu. Jirrinyparluju nyuntuju ngajuku yimi-ngarrurnu. Kujalpanpa nyuntu nyinaja ngaju-kurlu nyampurla, YAAWIYI-rlingki nyuntuju pirrjirdi-maninjarla warrawarra-kangu. Kujarlanyaju ngajurlangu warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Wangkaya ngayiji ngajuku. Nyiyarnangku nyuntukuju yinyi ngula-warnu yungunpa nyinami nyampurla-juku?” ");
INSERT INTO wbp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","30","Jakupurlu yalu-manu, “Nyuntulurlu kanpaju ngaju milya-pinyi kujalparnangku nyuntuku mata-karda warrki-jarrija. Kujarna nyurru-wiyi kamparru-wiyi nyampu-kurra yanurnu, ngulajulpanpa-jana marnkurrpa-mipa jiyipi manu narnukutuju mardarnu. Kala kujalparna-jana ngajulurlulku warrawarra-kangu jiyipi manu narnukutu, ngulajulu panu-jarrijalku, manu jalangurlu panulku kanpa-jana mardarni. Nyarrpararlangurla kujalparnangku yaninjarla warrki-jarrija, YAAWIYI-rlijilpangku pirrjirdi-maninjarla warrawarra-kangu. Kala nyiya-jangka ngajuju? Nyangurlarlu kapunpaju ngajuluju jarraly-pinjarla yilyami yungurnaju warrawarra-kanyi wungu-warnu warlalja ngaju-nyangu?” ");
INSERT INTO wbp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ngula-jangka, Lapanarlu payurnu, “Nyiyarnangku yinyi?” Jakupurlu yalu-manu, “Kulanpaju nyiyalku ngajukuju yungku. Kala yungurnangku nyuntu payirni jinta-mipakulku. Kajinpaju yimiri nyina ngajuku yungurnaju mani nyuntu-nyangu jiyipi manu narnukutu ngajuku, ngula-jangka ngajulurlu kapurna-jana kulpari yaninjarla jiyipi manu narnukutu nyuntu-nyangu warrawarra-kanyi. ");
INSERT INTO wbp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nyuntu-nyangu jiyipi panuju kardirri-nyayirni, marnkurrpa-mipaju yurrpurlu manu marnkurrpa-mipaju kuruwarrikuruwarri. Nyuntu-nyangu narnukutu panuju yurrpurlu, marnkurrpa-mipaju kardirri manu marnkurrpa-mipaju kuruwarrikuruwarri. Yungkaju nyampurra jiyipi yurrpurlu manu kuruwarrikuruwarrirlangu. Kardirri-mipa narnukutuju manu kuruwarrikuruwarrirlangu ngajukuju yungka. Kapurna-jana nyanungu-patuju wurntururlangurlu kanjarla warrawarra-kanyi. ");
INSERT INTO wbp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ngaka, kajinpa yanirni nyanjaku ngajuku, yungunpaju ngaju milya-pinyi kujalparnangku nyuntuku jungarni purunju-wangu nyinaja. Nyuntu kanpa-jana yaninjarla nyanungu-patu miimii-nyanyi. Kajinpa-jana narnukutu yurrpurlu nyanyi, manu marda kajinpa-jana jiyipi kardirri nyanyi, ngulaju kapunpaju milya-pinyi kujarnangku yalumpurraju nyuntuku purungku jurnta manu.” ");
INSERT INTO wbp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lapanarla Jakupuku ngungkurr-nyinaja, manu wangkajarla, “Ngurrju kujaju! Nyampurra jiyipi manu narnukutu, yirrarnirli-nyanu yurturlu-kari yurturlu-kari.” ");
INSERT INTO wbp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kala ngulangka parrangka jintangka, Lapanarlu-jana yaninjarla ngularra jiyipi manu narnukutu yurturlu-kari yurturlu-kari-manu. Nyanungurlu-jana manu jiyipi kurdukurdu yurrpurlu panu-juku manu narnukutu wirriya manu karnta yangka kuruwarrikuruwarri. Nyanungurluju-jana jinta-kurra-maninjarla jiyipi manu narnukutu yurturlurla yirrarnu Jakupuku. Ngula-jangka, kaja-nyanu-patuku-jana wangkaja yungulu-jana warrawarra-kanyi. ");
INSERT INTO wbp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ngula-jangka, Lapanarlu manu kaja-nyanu-paturlulu-jana jiyipiki manu narnukutuku Jakupu-kurlanguku jirrnganja nguru-yirrarnu wurnangkulku parra-patuku. Ngula-jangka, Jakupurlulpa-jana jiyipi manu narnukutu warrawarra-kangu Lapana-kurlanguju yalumpurla-juku. ");
INSERT INTO wbp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jakupurlu-jana pajurnu jalangu-warnu watiya-kari watiya-kari. Pinti kirrirdiji-jana yalyi-manu wita-kari wita-kari nyampurra-ngurlu watiya-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yirrarnu-jana nyampurra watiya pinti yalyi-maninja-warnu kutu-juku wiringka rdakurlparla ngapa-kurlangurla. Ngula-kurra kuja kalalu jiyipi manu narnukutu yanurnu walyuru-maninjaku, ngula-karrarlu kalalu-nyanu wajirli-pungu kurlangkarrarlangurlu jinta-jarrinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kalalu yurrpurlu narnukutu-patu karntakarnta manu wirriya-patu jinta-jarrija kamparru ngayirni watiya-paturla yangka pinti yalyi-maninja-warnurla. Kujalpalu nyampurra karrmulypa-jarrija, ngulajulu kurdukurduju palka-jarrija kuruwarrikuruwarri. ");
INSERT INTO wbp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kala jiyipi kurdu-warnu-patu, ngulaju-jana Jakupurlu yurturlu-kari yurturlu-kari-manu jiyipi wiriwiri-kijakuju. Ngayirni-manu-jana yungulu-jana nyanyi Lapana-kurlangu narnukutu-patu yurrpurlu-patu manu kuruwarrikuruwarrirlangu. Kujarlunya kala-nyanu jiyipiji Jakupurluju yurturlu-kari-maninjarla mardarnu Lapana-kurlangu-kujakuju. ");
INSERT INTO wbp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","42","Kujalpalu nyanungu-patu pirrjirdi-patu jinta-jarrija kurlangkarra, Jakupurlu kala watiya-paturla pinti yalyi-maninja-warnurla yirrarnu kamparru nyanungu-paturla yungulu nyanyi kurlangkarrarlu. Kujalpalu nyampurra karrmulypa-jarrija, ngulajulu kurdukurduju palka-jarrija pirrjirdi-nyayirnirlangu. Nyampurraju kalalurla nyinaja Jakupuku. Kala kuja kalalu rampaku-patu jinta-jarrija kurlangkarra, kulalpa-jana kamparru yirrarnu watiya-paturla pinti yalyi-maninja-warnurla nyanungu-patuku. Kujalpalu nyampurra nyurnu-patu karrmulypa-jarrija, ngularrajulu palka-jarrija kurdukurduju rampaku-nyayirnirlangu. Nyampurraju kalalurla nyinaja Lapanaku. ");
INSERT INTO wbp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kujarlunya-nyanu manu Jakupurlu panu-nyayirni jiyipi manu narnukutu. Nyanungujulpa jiyipi-kirli manu narnukutu-kurlu panu-nyayirni-kirli nyinaja marlajarra-wangu, manulpa-nyanu panu wati manu mardukuja warrkini mardarnu. Mardarnulpa-nyanu panu tangkiyi manu panu kawartawararlangu. ");
INSERT INTO wbp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ngaka-kari, Jakupurlu-jana kaja-nyanu-patu Lapana-kurlangu-patu purda-nyangu kujalpalurla nyanunguku nginji-wangkaja. Kujanyalpalu-nyanu wangkaja, “Ngalipakupalangurlu jaji-pardurlu kamparrurlu nyiyarningkijarra kala-nyanu mardarnu. Kala Jakupurlulkurla muku manu jurnta panuju, manu jalangu-ka nyina nyiyarningkijarra-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Lapanaju kalarla Jakupuku yipilji-wiyi nyinaja. Kala kuja kala Jakupurlu yungka nyangu Lapana, kala-nyanu kujarlu manngu-nyangu, “Lapanaju kula kaju marda yulkalku ngajukuju, lawa marda.” ");
INSERT INTO wbp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ngula-jangka, YAAWIYI-rla wangkaja Jakupuku, “Kulpari yanta ngurrara-kurra kujalpalu nyuntu-nyangu-patu nyurnunyurnu-patu nyinaja. Ngajuju kapurnangku palka jirrnganja nyinami nyuntukuju.” ");
INSERT INTO wbp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Junga-palangu Jakupuju nyanungu-parnta-jarraku Rajuluku manu Liiyaku wangkaja yungu-palarla kamparru yani kujalpalu panu jiyipi manu narnukutu nyinaja nyanungu-nyangu. ");
INSERT INTO wbp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jakupuju ngakalku-palangu yaninjarla rdipija nyanungu-jarraku, manu-palangu wangkaja, “Nyumpalakupalangu kalaju yipilji-wiyi ngurrju-wiyi ngajuku nyinaja, kala jalangujalangu kula kaju yulkalku. Ngulaju ngula-juku. Kaatu yangka ngulalpa puraja Yijakirli ngajukupalangurlu, ngulaju kaju palka-juku nyina ngajurlangukuju Kaatuju. ");
INSERT INTO wbp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nyumpalarlu kanpajupala milya-pinyi kujalparnarla mata-karda tarnnga warrki-jarrija nyuntu-jarrakupalanguku. ");
INSERT INTO wbp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Nyanungurluju tala jangku-pungu yunguju nganta payi-mani kujalparnarla panu jiyipi nyanungu-nyangu warrawarra-kangu. Kala ngajuluju yulyurlku-yungu karlarla-palakuju tala-ngurlu. Kapuju marda pakakarla. Kuja-kujakuju Kaaturluju nyanunguju jurnta warla-pajurnu jarraly-pinja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kamparru ngajukuju Lapana wangkaja, ‘Jiyipi-wanawana, ngulajungku mardaka nyuntulurlu panu narnukutu kuja kalu palka-jarri kuruwarrikuruwarri.’ Kujanyaju Lapanaju wangkaja. Ngula-jangkaju, narnukutu-watili palka-jarrija kuruwarrikuruwarri. Ngula-jangka, Lapanaju yarda wangkaja, ‘Jalangu nyampu-jangkarlu, mardaka-nyanu panu narnukutu kuruwarrikuruwarri warntawarnta-kurlu.’ Ngula-jangka, narnukutu-patu kujalu palka-jarrija ngulaju kuruwarrikuruwarri warntawarnta-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ngulaju Kaaturlurla nyampurra panu jiyipi manu narnukutu-patu nyuntukupalanguku jurnta kangu, manu ngulangku kujaju yungu ngajuku.” ");
INSERT INTO wbp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ngula-jangka, Jakupu-palangu nyanungu-parnta-jarraku wangkaja, “Yangka-puru kujalpalu panu jiyipi manu narnukutu-patu jinta-jarrija kurlangkarra, ngajurna ngunaja jukurrpa. Yinyarla jukurrparla, nyangulparna-jana wirriya-patu narnukutu-patu kujalpalu karntangka narnukuturla jinta-jarrija. Kulalu wirriya-patu narnukutu-patu yurrpurlu-patu kurlangkarra karntangka jinta-jarrija. Wirriya-patu-mipa yangka kujalpalu kuruwarrikuruwarri karrija, ngula-mipalpalu kurlangkarraju jinta-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Jintaju marramarra Kaatu-kurlangu ngajuku wangkaja jukurrparla yinyarla, ‘Jakupu!’ Ngajulurlurna marramarra yinya yalu-manu, ‘Nyiya?’ ");
INSERT INTO wbp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ngula-jangka, ngajukuju wangkaja marramarra, ‘Nyangka-jana yalumpu narnukutu-patu wirriya-patu. Kuruwarrikuruwarri-mipa karntangka kurlangkarra kalu jinta-jarrimi. Ngajulurlulparnangku nyuntu warrawarra-kangu, manu karna Lapana nyanjarla milya-pinyi kuja kangku nyuntuku nyinami yimiri-wangu. ");
INSERT INTO wbp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ngaju Kaatu yangka-juku kujarnaju Pijilirla nyuntu-kurra milki-yirrarnu. Ngulaju yangkangka kujanpa pirli juka-yirrarnu kankarlarra-kari, manu kujanpa kankarlarni jarangku yarlurnu. Ngulangkanyanpaju wangkaja kapunpaju nganta purami ngaju-mipa nganta. Ngula-juku, ngaju karnangku nyina ngampurrpa yungunpa ngurrara nyampu yampimi, manu yungunpa kulpari yanirra yangka-kurra kujanpa nyuntu palka-jarrija.’ Kujanyaju wangkaja ngajuku marramarra jukurrparla yinyarla.” ");
INSERT INTO wbp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ngula-jangka, Rajulu manu Liiya-palarla Jakupuku wangkaja, “Kaji ngajarrakupalangu palimi, kularlijarra nyiyarlangu mani yampinyi nyanungu-nyangu-jangka, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kulalpa-jarrangku nyanungu-wiyi yimiri ngajarraku nyinaja, lawa. Kala-jarrangku nyurunyuru-jarrija-nyayirni kula-nganta yapa-kari-jarra-piyaku ngurrara-kari-wardingki-jarra-piyaku. Kamparrurlu yungu-jarrangku nyuntuku talakupurdarla. Ngula-jangka, panu tala nyanungurlu yiily-ngarnu ngulanparla yungu ngajarra-wanawana. ");
INSERT INTO wbp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kaaturlurla panu jiyipi manu narnukutu-patu jurnta kangu ngajarrakupalanguku, ngula-jangka kalu-ngalpa nyinami ngalipakulku manu ngalipa-nyanguku kurdukurduku. Kajingki nyiyarlanguku nyuntuku Kaatu wangkami, purda-nyangka!” ");
INSERT INTO wbp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ngula-jangka, Jakupurlu-jana wari-yirrarnu kurdukurdu panu nyanungu-nyangu manu nyanungu-parnta-patu purturlu-kurra kawartawara-patu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ngulalu rdirri-yinjarla wurna kulpari yanu Kanana-kurra, ngulangka kujalpa nyinaja-juku Yijaki nyanungukupalangu. Kangu-jana panu jiyipi manu narnukutu panu nyanungu-nyangu kamparrurlu jakumanu-piyarlu. Nyiyarninykijarra-nyanu kangu kujalpa nyinaja ngurrararla Patana-Yarramarla-wiyi. ");
INSERT INTO wbp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Jakupu kuja yarnkajarra nyanungu-nyangu-patu-kurlu warlalja-kurlu, ngulakungarntiji Lapana yanu yangka-kurra kujalpalu-jana panu jiyipi wamulu-piya pajurnu. Kuja nyanungu yanu ngurra nyanungu-nyangu-ngurlu, Rajulurlurla yukanjarla pirli-pardu juju purungku nyanungukupalanguku jurnta manu. ");
INSERT INTO wbp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Manu Jakupurlu Lapana yimirr-yungu, kula warnkiri-manu kuja nyanungu wuruly-yanu. ");
INSERT INTO wbp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yampinjarlalu ngurra Lapana-kurlangu-jangka kapanku yanumpa karru wiri-wana Yupirayiti-wana, manulu yanu ngurrara pirli-patu-kurra yirdi-kirra Kiliyata-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ngakalku, Lapanarlu milya-pungu parra-patu-jangkarlu kujarla Jakupu warlalja-patu-kurlu nyanungu-nyangu-kurlu wuruly-yanu. ");
INSERT INTO wbp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ngula-jangka, wungu-warnu wati-mipa-nyanu Lapanarlu turnu-manu, manulu-jana yapa-patu Jakupu-kurlangu wajirli-pungu purdangirli-wanarlu. Ngakalku-jana nyanunguju wiyiki jinta-jangka puranjarla rdipija nyanungu-patuku ngurrararla pirli-paturla Kiliyatarla. ");
INSERT INTO wbp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ngulangka mungangka jintangka, Kaaturla yaninjarla jukurrparla Lapanaku wangkanjarla pututu-pungu, “Purda-nyangkaju! Kularla kulu japirdiya Jakupuku!” ");
INSERT INTO wbp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jakupu manu warlalja-patu nyanungu-nyangulu ngurrangka-jarrija pirli pirli-paturla ngurrararla yirdingka Kiliyatarla. Lapana manu nyanungu-nyangu wati-paturlu ngurrangka-jarrija pirlingka jintangka kutu-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ngula-jangka, yaninjarlarla wangkaja Jakupuku, “Nyiya-jangkanpaju yimirr-yungu? Nyiya-jangkarlunpa-palangu yurntalpa ngaju-nyangu-jarraju kangu ngaju-kujakuju kulu wiri-piya-jangka? ");
INSERT INTO wbp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nyiyakunpaju ngajukuju jurnta wuruly-yanu kamparrurlu ngatingki-maninja-wangurlu? Kajinpaju ngajulu ngatingki-mantarla, ngajulurlu kapurnangku nyuntuku kurapaka wiri ngurrju-mantarla. Kapurlipa nyinakarla wardinyi-nyayirni, manu kapurlipa jintangkarlu yunpakarla manu manyu-karriyarla rdimpirdimpirl-pinja-kurlangu-kurlu manu kita-piya-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kuja-kujaku, nyuntunpa-jana kangu, manunpa ngaju-kujaku wuruly-parnkaja, kularna-jana nyunjakarla nyarrparlu ngaju-nyangu jamirdi manu yurntalpa-jarra, lawa. Manu kularna-jana nyarrparlu jakuru-pungkarla. Kujarlu miyalunpaju maju-manu! ");
INSERT INTO wbp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kala kajirna ngaju ngampurrpa-jarriyarla, kapurnangku marda pakakarla. Kala mungangka, ngajukuju Kaaturlu pututu-pungu yungurnangkulu nyuntulu yampimi kulukukuluku-maninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Milya-pinyi karnangku kuja kanparla yirraru-jarrimi nyuntukupalanguku manu ngurrara nyuntu-nyanguku. Kala nyiyakunpaju pirli-pardu juju-kurlangu purungkuju jurnta manu.” ");
INSERT INTO wbp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yalu-manu Jakupurlu, “Lani-jarrijalparnangku. Ngajulurlurna manngu-nyangu kapunpaju marda yurntal-puraji-jarra jurnta kangkarla. Ngula-jangkanyarna ngatingki-maninja-wanguju wuruly-yanu. ");
INSERT INTO wbp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kala ngulaku nyuntu-nyanguku pirli-pardu jujuku, karijarna ngurrpa ngulakuju. Ngulakujurla warru nyangka jurnarrparla nganimpa-nyangurla. Ngalipa-nyangu wungu-warnu panu kalu karrimi nyampu, purda-nyanyi kalu-ngalpa ngalipa. Kajinpa rdipinjarla mani nyuntu-nyangu juju-kurlangu yakujurla yapa jinta-kari-kirlangurla, kapurna-jana jangkardu wangkami wati-patuku ngaju-nyanguku yungulu pinyi tarnnga-kurra puru-jangka.” Kujanyarla Jakupuju Lapanakuju wangkaja. Kala kulalpa milya-pungu kuja nyanungu-parntarlu Rajulurlu purungku-manu jujuju. ");
INSERT INTO wbp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ngula-jangka, Lapanarlu rdirri-yungu warrirninjaku pirli-pardu jujuku. Kamparrurlu warrurnurla kaninjarni kalukurla Jakupu-kurlangurla, manu ngula-jangkaju kaninjarni kalukurla Liiya-kurlangurlalku. Ngula-jangka, yaninjarlarla warrurnu kaninjarni kaluku-jarrarla kujalpa-palangu karrija karnta-jarraku warrkini-jarraku Piilyaku manu Jiilpaku, kala kula-jana rdipinjarla palka-manu. Ngula-jangka, nyanungu yanu kaluku Rajulu-kurlangu-kurra warrirninjaku jujukuju. ");
INSERT INTO wbp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rajululpa kaninjarni nyinaja kalukurla yinyarla. Nyanungujulpa nyinaja kankarlarni nyanungu-nyangurla nyinanja-kurlangurla kawartawara-kurlangurla, kujalu yalyi-maninjarla yirrarnu purturlu-jangka kawartawara-jangka. Kujarla Lapana rdirri-yungu warrirninjaku jujuku, kujakungarntirli Rajulurlu-jana kaninjarni wuruly-yirrarnu nyinanja-kurlangurla kawartawara-kurlangurla. Lapana yaninjarla yukaja kaluku-kurra Rajulu-kurlangu-kurra, manurla muku warrurnu kaninjarni, kula-jana palka-manu, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ngularla Rajulu wangkajalku, “Wapirra, kulalpanpaju ngajuku kulu-jarriyarla. Ngajujurna murrumurru-karrikarri, manu kulalparnangku nyarrpalku karrinja-pardiyarla.” Ngula-jangka, yampija nyanungu Lapanarlu, manu yarlu-kurra wilypi-pardinjarla yanu, manu kaluku-kari kaluku-kari muku nyangu, lawa-juku pirli-pardu juju palka-maninjakuju. ");
INSERT INTO wbp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ngularla Jakupuju kulu-jarrija-nyayirni Lapanakuju. Nyanungukujurla jangkardu jurduwarrawarra-pungu, manurla wangkaja, “Yuwa, wangkayaju! Nyarrpa-manurnangku? Kularnangku majungka-jarrija jurnta nyuntuku ngula kanpaju ngajulu wajirli-pinyi? Ngayiji yimi-ngarrika-puka! ");
INSERT INTO wbp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nyuntunparla muku warrurnu jurnarrparla nganimpa-nyangurla, kala kulanpa jintarlangu witarlangu nyiyarlangu palka-manu nyuntu-nyangu, lawa. Kajinparla rdipimi nyuntu-nyanguku nyiyaku-puka, ngulajuju milki-yirraka ngajukuju! Yirraka nyampurla kamparru panungka wungu-warnurla ngalijarra-nyangurla. Ngula-jangka yungulu-ngalingki miimii-nyanyi ngana-ka jungarni wangkami, manu ngana-ka warntarla wangkami! ");
INSERT INTO wbp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ngajuju purda-nyangka! Ngajurnangku warrki-jarrija nyuntuku yulyurrpu-patuku 20-palaku. Ngularra-puru, kula jinta nyuntu-nyangu kurdu-warnu jiyipi manu kurdu-warnu narnukuturlangu palija yangka murnma-wiyi palka-jarrinjakungarnti. Kularna ngarnu wirriya jiyipi nyuntu-nyangurlangu jintarlangu, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kujalpa-jana warnaparirli pungu nyuntu-nyangu jiyipi, kularnangku yimirr-yungu, lawa. Ngarirnangku jiyipi ngaju-nyangu yungu. Manu yangka kuja yapa jinta-karirli purungku-manu nyuntu-nyangu mungangka manu marda parrangka, kuja-wanawana ngarinpaju jinyijinyi-manu ngaju-nyanguku kulpari yinjaku. Lawa, kalarnaju warlalja-juku jiyipiji mardarnu, manu jinyijinyi-maninja-warnurlu kalarnangkurla jiyipiki palinja-warnuku nyuntu-nyanguku yardajirri-yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Panu-puru kalaju wantangku kampaja parrangka, manu mungangka kalarna putaputa laalka-jarrija palinja-piyakungarnti pirriya-jangka, manu kula kalarna jardarlangu ngunaja. ");
INSERT INTO wbp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kuja-piya kalarnangku mata-karda-nyayirni nyuntuku warrki-jarrija 20-palaku yulyurrpuku. Warrki-jarrijarnangku 14-palaku yulyurrpuku nyuntu-nyangu yurntalpa-jarra-wanawana. Manu ngula-jangka, ngajurnangku warrki-jarrija jika-palaku yulyurrpuku jiyipi manu narnukutu-wanawana. Karlarla-palakunpaju yimirr-yungu. Jangku-pungunpaju yungunpaju ngaju payi-mani jiyipi warrawarra-kanja-warnu, kalanpaju wurra-manu-juku. Nyuntulurlu kalanpaju tarnngangka wita-kari wita-karirli payi-manu. ");
INSERT INTO wbp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kala Kaatu ngulalpa-pala ngajukupalangurlu Yijakirli manu warringiyirli Yipuruyamurlu puraja, ngulaju kaju jalangurlanguju nyinami ngajukuju palka-juku. Nyanungu-wangu kajirna nyinayarla ngaju-mipa, ngulaju marlajarra kapunpaju yilyayarla. Kalaju nyangu Kaaturlu kujalparna mata-karda warrki-jarrija, manu kulu kujalpanpaju ngurrju-manu. Kuja-jangkanyangku wangkaja Kaatu nyuntuku mungangka yungunpaju yampimi kulukukuluku-maninja-wangurlu!” ");
INSERT INTO wbp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ngula-jangka, Lapanarla wangkaja lamparra-nyanuku, “Nyampu-jarra mardukuja-jarra ngulaju ngaju-nyangu-jarra yurntalpa-jarra, manu nyanungu-jarra-nyangu kurdukurdu kajulu ngajuku nyinami. Panu yalumpurra jiyipi manu narnukutu ngularraju ngajuku-juku. Kulalparnangku warla-pajikarla nyarrparlu yurntalpa-jarra-kujaku manu kurdukurdu kanja-kujakuju. Ngari-jana kangka. ");
INSERT INTO wbp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Wangkamirli-nyanu ngalijarra yungurlipa nyinami jintangka kulu-wangu ngurrju walyka. Manu yurturlurlarli pirli-patu ngalijarrarlu murnju-yirrarni ngulangku yungu-ngalingki ngatingki-mani kujarli-nyanu ngungkurr-nyinaja.” Jakupuju ngurrjurla wangkaja kujakuju. ");
INSERT INTO wbp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Junga-juku, nyanungurlu pirli lalypa wiri maninjarla juka-yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Wangkaja-jana wati-patuku nyanungu-nyanguku wungu-warnuku yungulu yaninjarla turnu-mani panu pirli witawita manu yungulu pirlingka wiringka warrukirdikirdi yirrarni, ngulalu yalumpurla-juku kuyu karlarla nyanungu-paturluju ngarnu. ");
INSERT INTO wbp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lapanarlu yalumpu walya pirli-patu-kurlu yimingki nyanungu-nyangurlu yirdi-manu ‘Jika-Jataja’. Manu Jakupurlu walya jurrku-juku yimingki nyanungu-nyangurlu yirdi-manu ‘Kaliti’. ");
INSERT INTO wbp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ngula-jangka, Lapanarla wangkaja lamparra-nyanuku, “Ngaka, kajirli ngalijarrarlu nyampu pirli-patu yurturlurla nyanyi, kapu-ngalingki ngatingki-mani kujarli-nyanu ngalijarra ngungkurr-nyinaja nyinanjaku walykaku kulu-wangu.” Kuja-jangkanya nguru yinya pirli-patu-kurluju yirdi-manu ‘Kaliti’. ");
INSERT INTO wbp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ngula-jangka, Lapana yarda wangkaja, “Kajirli ngalijarra jarnku yani, ngampurrpa karnarla YAAWIYI-ki nyina yungu-ngalingki ngalijarra warrawarra-kanyi kulu-kujaku. Kalakarli-nyanu pakarninjarla murrumurru mani!” Ngula-jangkarlunyalpa ngurrararlu yinyarluju mardarnu yirdi-kari ‘Mijipa’. ");
INSERT INTO wbp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ngula-jangka, Lapanarla yarda wangkaja, “Purda-nyangka nyampu wajawaja-maninja-wangurlu: Kaaturlu kangalingki nyampurla jalangurlu warrawarra-kanyi. Kajinpa-palangu ngaju-nyangu-jarra yurntalpa-jarra murrumurru-mani, marda karnta-karirlangu kajinpa-nyanu nyuntu-kurra-manku, marda karija kularna kuja-kurlu milya-pinyi. Kala Kaatu-miparlu kapungku nyanyi yurnilyka-jarrinja-kurra punku-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Nyampu wiri pirli manu pirli panu-kari kujarna-jana yurturlurla yirrarnu, ngula-warnurlu ngalingki kapurli warrarda purda-nyanyi ngarrirninja-warnurlu ngula yungurlu nyinami jintangka walyka kulu-wangu. Kularna nyampu-paturla pirli-paturla jingijingi yani ngurrara nyuntu-nyangu-kurra pinjaku nyuntuku, lawa. Manu nyunturlangu kula yalumpurla pirli-paturla jingijingi yanta ngajuku pinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kaatu kujalpa-pala puraja Yipuruyamurlu manu Nayururlu, ngulangkuju kapu-ngali nyanyi kajirli nyiyarlangurla nyarrpa-jarrimi. Kajinpaju ngajulu pinyi, ngulaju kapujurla Kaaturlu kunka-mani. Kala kajilparnangku pungkarla, ngulaju Kaaturlu kajikangkurla kunka-mani-yijala.” Ngula-jangka, Jakupurla wangkaja Lapanaku, “Kaaturla yirdingka, ngulalpa Yijakirli ngajukupalangurlu puraja, wangkami karnangku kularna pirli-paturla yalumpu-paturla jingijingi yani nyuntu-nyangu-kurra ngurrara-kurra nyuntuku pinjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ngula-jangka, Jakupurlurla jiyipi pinjarla purraja warntarri-nyayirni-wangu Kaatuku. Ngula-jana wati-patuku wungu-warnuku wangkaja yungulu yaninjarla ngarni kuyu manu mangarri nyanungu-kurlurlu. Ngulalu ngarninjaku lawa-jarrija, ngurrangka-jarrijalu yalumpurla pirlingka. ");
INSERT INTO wbp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mungalyurru-karilki, Lapanarlu-jana nyanungu-nyangu jamirdi-nyanu-patu nyunjurnu, manu-palangu yurntal-nyanu-jarra jakuru-pungu, manu-jana wangkaja, “Kaaturlu kapu-nyarra pirrjirdi-maninjarla warrawarra-kanyi.” Ngula-jangka kulpari yanu nyanungu ngurrara nyanungu-nyangu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kujalpa Jakupu wapanja-yanu warlalja-patu-kurlu manu nyanungu-nyangu-kurlu nyiyarningkijarra-kurlu, marramarra-patulurla nyanunguku rdipija. ");
INSERT INTO wbp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kuja-jana nyanungu-patu nyangu Jakupurlu, wangkaja-nyanu kuja, “Ngurra nyampuju Kaatu-kurlangu!” Ngula-jangka, ngurra yalumpu yirdi-manu ‘Mayami’. ");
INSERT INTO wbp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakupukupurdangka papardi-nyanulpa nyinaja ngurrararla witangka yirdingka Jiirirla kujalpa karrija ngurrararla wiringka yirdingka Yitamarla. Ngula-jana Jakupurlu yilyaja wati-patu nyanungu-nyangu Yijuwu-kurra yimi-kirli. ");
INSERT INTO wbp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yilyanjakungarntiji-jana yimi nyampu nyanungu-patuku yungu, “Yimi nyampu ngulaju kukurnu-puraji-kirlangu Jakupu-kurlangu. Nyuntujunpa paaju ngajuku, manu kapurnangku purda-nyanyi kajinpaju nyiyarlanguku wangka. Yungurnangku yimi-ngarrirni nyuntuku kujalparna nyarrpa-jarrija. Nyinajalparna Lapana-wana ngurrararla nyanungu-nyangurla. Kapurna yangka-juku nyampu-kurraju kulpari-jarriyarla, kala ngulangkuju ngajuju warla-pajurnu kulpari yaninja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ngaju karnaju mardarni panu-jarlu warlalja puluku, tangkiyi, jiyipi manu narnukutu. Manu karnaju mardarni wati manu mardukuja panu-jarlu ngula kajulu ngajuku warrki-jarrimi. Ngaju karnangku yimi nyampu nyuntuku yilyamirra yimiri-maninjaku yungurnangku yaninjarla jirrnganja nyinami nyuntukuju.” (Ngula-jangka, Jakupu-kurlangu-paturlu wati-paturlulurla yimi-ngarrurnu Yijuwuku. Nyanungujurla nyurru-jukurla wapirdi yanunjunu Jakupuku.) ");
INSERT INTO wbp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ngula-jangka, Jakupu-kurlangu wati-patulurla yaninjarla nyanunguku kulpari wangkaja, “Rdipijarnalurla jalja-juku papardi-purajiki Yijuwuku. Nyanungurlu kanyanu watiji 400-pala mardarni, manu kangku nyurru nyuntuku yanirni.” ");
INSERT INTO wbp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ngula Jakupurlu kuja purda-nyangu, yalyu-wangu-jarrija laniji! Manngu-nyangu kula-ngantarla Yijuwuju kulu jangkardu yanurnu pinjakungarnti. Kuja-kujakuju, nyanungu-nyangu yapa-jana yurturlu-jarra-kurra yira-kari-manu, nyanungu-nyangu panu jiyipirlangu, narnukutu, puluku manu kawartawara-jana yurturlu-jarrarla yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Manngu-nyangu-nyanu Jakupurlu, “Kajilpa-jana Yijuwurlu yaninjarla muku pungkarla yurturlu-kari, kajikalu marda yurturlu-kariji wankaruku wuruly-parnka!” ");
INSERT INTO wbp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ngula-jangka, Kaatu-kurla wangkaja, “Nyuntujunpa Kaatu ngulalpangkupala warringiyirli Yipuruyamurlu manu ngajukupalangurlu Yijakirli puraja. Purda-nyangkaju, wiyarrpa! YAAWIYI, ngajukunpaju wangkaja yungurna kulpari yanirni nyampu-kurra ngurrara warlalja-kurra manu wungu-warnu warlalja-kurra. Ngajukunpaju wangkaja yungunpaju nganta yimiri nyinami. ");
INSERT INTO wbp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ngajurnangku nyuntuku jurnta yanu, nyiya-jangka kanpaju ngajukuju yimiriji warrarda nyinami? Nyiyaku kanpaju warrawarra-kanyi ngajulu? Nyurru-wiyi kujarna ngapa-wana Jurdunu-wana yanu Mijuputamiya-kurra, jukati-mipa-kurlurna yanu watiya-kurlu. Kala jalangurlu ngajulurlu karnaju warlalja nyiyarningkijarra mardarni yurturlu-jarrarla. ");
INSERT INTO wbp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ngula karnangku nyuntulu payirni yungunpaju muurlparlu mardarni ngajukupurdangka-kujaku papardi-kijaku Yijuwu-kujaku. Lani-jarri karnarla kajika-nganpa yaninjarla marriwarlu muku pinyi panu-juku mardukuja-paturlangu manu kurdukurdurlangu! ");
INSERT INTO wbp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nyuntunpaju wangkaja kapunpaju yimiri nganta nyina ngajuku, manunpaju wangkaja kapunpaju ngajuku nganta yinyi panu kurdukurdu manu warringiyi-walka panu-nyayirni nganta pingi-piya-juku nganta, kulalpa-jana nganangku-puka jinta-kari jinta-kariji yirdiyirdi-maninjintarla!” ");
INSERT INTO wbp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jakupu ngunaja yinyarla mungaku jintaku. Parra-karirla rdirri-yungu maninjaku nyanungu-nyanguku panu-kariki jiyipiki, narnukutuku manu kawartawaraku yungurla yinyi nganta warntarri papardi-nyanuku. ");
INSERT INTO wbp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yirrarnu-jana ngama narnukutu 200-pala manu wirriya narnukutu 20-pala jinta-kurra yurturlu-kurra. Ngula-jangka-jana ngama jiyipi 200-pala manu wirriya jiyipi 20-pala yurturlu-karirla yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Ngula-jangka-jana ngama kawartawara 30-pala yirrarnu manu nyanungu-nyangu kurdu-warnu-patu yurturlu-karirla. Ngula-jangka-jana ngama puluku 40-pala yirrarnu manu wirriya karlarla-pala yurturlu-karirla. Ngula-jangka-jana yirrarnu ngama tangkiyi 20-pala manu wirriya tangkiyi karlarla-pala yurturlu-kari-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ngula-jangka-jana milarninjarla manu nyanungu-nyangu warrkini rdaka-pala, ngulangku yungulu-jana yinya yurturlu-paturla palkangku warrawarra-kanyi. Ngula-jana wangkaja nyanungu-patuku, “Nyurrurlarlu kangkalu-jana yalumpurra yurturlu-kari yurturlu-karirla kamparrurlu, manulurla yungka ngajukupurdangkaku papardiki. Nguru-yirrakalu-jana yurturlu-paturla yira-kari yira-kari-maninjarla. Nguru-yirrakalu-jana yurturlu-kari-jangkaku manu yurturlu-kari-jangkaku.” ");
INSERT INTO wbp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ngula-jangka, Jakupurla kamparru-warnuku jintaku warrkiniki wangkaja ngulalpa-jana panu narnukutu warrawarra-kangu, “Kajingki papardi Yijuwu ngajukupurdangka nyuntuku yaninjarla wangkami, kapungku payirni nganaku kanparla warrki-jarrimi. Kapungku payirni nyarrpara-kurra kuja kanpa yani, manu kapungku nyuntu payirni-yijala ngana kajana warlaljamarriji nyinami yalumpurraku panuku jiyipiki, narnukutuku, tangkiyiki manu kawartawaraku. ");
INSERT INTO wbp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kajingki payirni nyuntu kujarlu, yalu-manta kujarlu, ‘Nyampurraju nyuntukupurdangka kukurnu-puraji Jakupu-kurlangu ngula kangku nyinami warrkini nyuntukulku. Nyanungurlu nganta kangku yinyi nyampurraju nyuntukulku. Yijuwu, nyuntu paajulku kanparla nyanungukuju nyinami. Jakupu kanganpa purdangirli-wana yanirni ngaka.’ Kujanyarla wangkaya Yijuwukuju.” ");
INSERT INTO wbp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ngula-jangka, warrkini-patu-kariki-jana Jakupu wangkaja, “Kuja-piya-yijala nyurrurlajulurla Yijuwukuju wangkaya, kaji-nyarra yanirni. ");
INSERT INTO wbp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Wangkayalurla kuja nyanunguku, ‘Nyuntu-nyangu warrkini Jakupu kanganpa purdangirli-wana yanirni ngaka.’” Jakupurlu-nyanu manngu-nyangu, “Kajilparnarla nyampurra warntarri papardiki ngajukupurdangkaku yilyayarla, ngula-jangka kajirna nyanungu nyanyi, kapuju marda yawuru-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ngula-jangka, ngula-warnu, Jakupurlu-jana wati-patu warrkini yilyaja kamparrurlu panu-kurlu jiyipi-kirli, narnukutu-kurlu, tangkiyi-kirli manu kawartawara-kurlu, kala nyanungujulpa nyinaja purdangirli yalumpurla-juku. ");
INSERT INTO wbp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Ngulalpa munga-juku karrija, Jakupu yakarra-pardija jarda-jangka, yakarra-manu-jana nyanungu-parnta-jarra, nyanungu-nyangu karnta-jarra warrkini-jarra manu nyanungu-nyangu 11-pala kaja-nyanu-patuju. Kamparru-jana yilyaja, yanumpalu ngapa-wana murrarninginti-kirra karru-wana yirdi-wanaju Japaka-wana. ");
INSERT INTO wbp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kala Jakupu purdangirlilpa nyinaja yangarlu. Ngula-jangka, wati yanurnu, manu rdirri-yungu jurr-yarnkanjarla Jakupuku, manulpa-pala-nyanu putaputa kujurnu. Puuly-mardarnulpa-pala-nyanu, manu jirri-mardarnulpa-pala-nyanu rdiily-parnkanja-wangurlu jintaku mungaku. Watingkijilpa putaputa kujurnu Jakupu walya-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yinyarlu watingki kula Jakupu walya-kurra kujurnu, lawa. Ngayilpa putaputa mamparl-pinjarla wirri-pungu Jakupulku. Ngula-jangka, rangkarr-kurlurlu nyanungurlu pakarnu yardipi Jakupu, ngula wanarri lirrija yardipirla. ");
INSERT INTO wbp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ngula-jangka, nyanungurla wangkaja Jakupuku, “Wayinpa! Yampiyalkuju! Wantaju-ka kankarlu-jarrinja-yanilki!” Jakupurlu yalu-manu, “Ngulaju ngula-juku! Ngulakungarntiji ngajukuju wangkaya yungunpaju pirrjirdi-maninjarla warrawarra-kanyi tarnngangku-juku!” ");
INSERT INTO wbp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ngula watingki payurnu, “Nyiyanpa yirdi nyuntu?” Yalu-manu Jakupurlu, “Ngajurna Jakupu.” ");
INSERT INTO wbp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ngula-jangka, watirla wangkaja, “Jalangu-jangka, yirdi nyuntu-nyangu kula Jakupulku, nyuntuju yirdi Yijirali. Panu-kari watinpa-jana jintangku muku pungu. Kaaturlu manu nyuntulurlunpala-nyanu puuly-mardarninjarla putaputa kujurnu. Kulangku nyuntuju walya-kurra kujurnu.” ");
INSERT INTO wbp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ngula-jangka, Jakupurla wangkaja nyanunguku, “Ngaju karnangku nyuntu payirni jinta-mipaku. Nyiyanpa nyuntu yirdi?” Watingki yalu-manu, “Nyiya-jangkakurnangku yimi-ngarrirni ngaju-nyangu yirdiji?” Ngula-jangka, watijirla wangkaja Jakupuku yungu nganta pirrjirdi-maninjarla warrawarra-kanyi tarnngangku-juku. Ngula-warnu, watingki yampija Jakupu, manu yanulku. ");
INSERT INTO wbp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ngula-jangka, Jakupu wangkaja, “Ngajurna nyangu yinngirri Kaatu-kurlangu milpangku ngajulurlu, kala ngajuju wankaru-juku!” Ngula nyanungurlu yalumpu ngurra yirdi-manu Piniyali. ");
INSERT INTO wbp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","32","Kujalpa wanta kankarlu-jarrinja-yanu, Jakupurlu yampija yinya ngurra. Nyanungu-nyangu yardipi wijini pakarninja-warnu yinya-jangka, manulpa jarntinja-yanu. Ngula-jangkanya, jalangurlangu yapangku Yijirali-pinkirli kula kalu ngarni kuyu yilara yardipi-jangka jiyipi-jangka, narnukutu-jangka manu puluku-jangkarlangu. ");
INSERT INTO wbp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ngula-jangka, Jakupurlu nyangu Yijuwu nyanungu-nyanungu-kurlu wati-kirli 400-pala-kurlu kujalpalu wurnturu yanurnu. Ngula-jana warlalja wungu-warnu nyanungu-nyangu yira-kari-maninjarla yirrarnu yurturlu-paturla murntu-palarla. ");
INSERT INTO wbp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yirrarnu-palangu karnta warrkini-jarra kurdukurdu-kurlu kamparru. Liiya manu kurdukurdu nyanungu-nyangu-jana kulkurru yirrarnu. Ngula-jangka-palangu Rajulu manu nyanungu-nyangu kaja-nyanu Jajupu yirrarnu purdangirli. ");
INSERT INTO wbp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ngula-jangka, Jakupuju rdirri-yungu wapanjaku Yijuwu-kurra-pinangu, manulu nyanungu-parnta-paturlu kurdukurdu-kurlurlu purdangirli-wanarlu puranja-yanu yurturlu-paturlarlu. Kujalpa nyanungu wapanja-yanu nyanungu-nyangu papardi Yijuwu-kurra-pinangu, Jakupurla parntarrinjunu walyangka yinngirri-purdanji wirlki-palaku. ");
INSERT INTO wbp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ngula-jangka, Yijuwurla yanu Jakupuku. Nyanungurlu ngamirlji-maninjarla Jakupu nyunjurnu wirlki-jarrarla. Ngula-pala rdirri-yungu yulanjakulku. ");
INSERT INTO wbp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ngula-jangka, Yijuwurlu-jana nyangu karntakarnta kurdukurdu-kurlu yaninjarni-kirra. Payurnu Jakupu, “Yapa nyampurraju nyuntu-nyangunya?” Jakupurlu yalu-manu, “Yuwayi, papardi, ngajuku kajulu nyinami. Yimirilpaju Kaatuju nyinaja, manu yapa yalumpurraju yungu ngajuku.” ");
INSERT INTO wbp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ngula-jangka, karnta warrkini-jarra-palarla kurdukurdu-kurlu yanurnu Yijuwuku, manulurla parntarrija walyangka yinngirri-purdanji. ");
INSERT INTO wbp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ngula-jangka, Liiyarlangu kurdukurdu-kurlurla yaninjarla nyanunguku parntarrinjunu. Ngula-warnu, Jajupu manu nyanungukupalangu Rajulurlulku-palarla yaninjarla Yijuwuku parntarrinjunu. ");
INSERT INTO wbp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ngula-jangkarla wangkaja Jakupukulku, “Yangkurrarlu kujarna-jana nyangu panu-jarlu narnukutu, jiyipi, puluku, kawartawara manu tangkiyi, kujalpalu-jana watingki nyuntu-nyangurlu nguru-yirrarninja-yanu, ngularra nyuntulurlu kapunpa-jana nyarrpa-mani?” Jakupurlu yalu-manu, “Ngajulurlu yungurnangku yalumpurraju yinyi nyuntuku warntarri nganta, ngula-jangka yungunpaju nyina ngajuku wardinyilki.” ");
INSERT INTO wbp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kala Yijuwurlu kamparrurlu wurra-manu, manurla wangkaja, “Ngaju karna-jana nyurru panu-yijala mardarni. Mardakangku nyuntulurlu, ngula panu-jala mardakangku yajarri-wangurlu!” ");
INSERT INTO wbp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kala wilji-jikilparla Jakupuju wangkaja, “Yuwa, ngayi-nyanu kutu kangkarlangu! Kajilpanpaju wardinyi nyinakarla, kajikanpa-nyanu warntarri kangkarla ngaju-nyangu. Ngulanpaju yaninjarla ngamirlji-mardarnu, manu ngularnangku yinka-kurlu nyangu, ngulaju kula-ngantarnangku nyangu yinngirri Kaatu-juku! ");
INSERT INTO wbp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngajukulpaju Kaatu yimiri nyinaja, manu yunguju panu nyiyarningkijarra. Kulalparna-jana nyampurraju nganjarla nyarrparlu. Kangka-nyanu warntarri ngaju-nyangu.” Wilji-jikilparla Yijuwukuju kuja-juku wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Yijuwu ngungkurr-nyinajarla Jakupuku, manurla wangkaja, “Ngula-juku, kanyilki karnaju. Wurnarlu mapirrilki kulpari yani ngurra ngaju-nyangu-kurra. Kapurnalu wapanja-yani nyurrurla-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kala Jakupurlu wurra-manu Yijuwu, manurla wangkaja, “Murnma, papardi ngajukupurdangka! Milya-pinyi kanpa-jana panu kurdukurdu ngaju-nyangu kalu murnma kurdu-warnu nyinami nyurnu wapanja-warnu. Manu panu jiyipi, narnukutu, tangkiyi, puluku manu kawartawara, kuja karna-jana mardarni, ngulaju kalu mata karrimi wapanja-warnu, manu kurdu-warnurlu kalu-jana lampurnu-juku ngati-nyanu ngarni. Kajilparna-jana jinyijinyi-mantarla wurntururlanguku yaninjaku parraku jintarlanguku marda, kajikalu nyampurraju marda muku palimirlangu. ");
INSERT INTO wbp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ngajulu kapurnangku nyuntu purda-nyanyi, papardi ngajukupurdangka, kajinpaju nyarrparlangu wangkami. Kala yanta kamparru nyuntuju. Ngajulurlu kapurnangku puranja-yani purdangirli-wanarlu. Ngaju karna panu-kurlu pingka wapanja-yani. Kulalparna-jana jinyijinyi-mantarla wapanjaku kiljiki. Papardi, ngakarnangku nyanyi Jiirirla.” ");
INSERT INTO wbp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ngula-jangka, Yijuwurla wangkaja, “Ngula-juku, kala ngurrju mayi kajilparnangku wati panu-kari ngaju-nyangu yirrakarla marlpa yungungkulu nyuntu warrawarra-kanyi yapa-kari-kijaku?” Yalu-manu Jakupurlu, “Lawa, ngulaju ngula-juku, kangka-jana panu-juku. Yungurnangku ngari nyuntu-puka yawuru-mani.” ");
INSERT INTO wbp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ngulangka parrangka jintangka, Yijuwu nyanungu-nyangu-kurlu wati panu-kurlu kulpari yanu ngurra-kurra Yitama-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kala Jakupu ngulaju yanu Jakaja-kurra-puka. Ngulangka-nyanu nganturnu yuwarli, manu-jana yuwarli witawita nganturnu nyanungu-nyanguku jiyipiki, narnukutuku, pulukuku manu tangkiyiki. Kujarlanya ngurra ngulaju yirdi-manu Jakaja. ");
INSERT INTO wbp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Nyampurlu-ka lawa-mani yimi Jakupu-kurlu kujalpa wurna wapaja wurnturu-jangka Mijuputamiya-jangka kirri-kirra Jikimi-kirra yirdiyi-wana yangka-wana kuja-ka ngunamirra yirdiyiji Patana-Yarrama-kurra. Jikimiji kirri, ngulaju-ka karrimi Kananarla. Nyanungujulpa warrawarra-kangu Kaaturlu wurna-puruju. Jakupu-kurlangu ngurralpa kakarrara kirringka ngulangka karrija. ");
INSERT INTO wbp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ngakalku-nyanu nguru ngula manu nyanungurlu. Yungu-jana tala 100-pala pirli-piya yarltiri kaja-nyanu-patuku Yamuru-kurlangu-patuku ngulalpalurla nguruku yinyaku nyinaja warlaljamarri. ");
INSERT INTO wbp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ngakalku kuja Jakupurlu manu nguru yinya, yurturlu-pinjarla Kaatuku ngurrju-manu pirli-patu purranja-kurlangu. Manu nyanungurlu ngurrara ngulaju yirdi-manu Yalaluyi-Yijirali. ");
INSERT INTO wbp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Tiinajulpa nyinaja Liiya-kurlangu yurntalu-nyanu manu Jakupuku kirda-nyanukuju. Parra jintangka, yanu-jana karntakarnta Kanana-wardingki-patuku jijanu kujalpalu kutu nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kujalpa wapanja-yanu, watingkilpa nyangu yaninjarni-kirra. Nyanungu-nyangu yirdiji Jikimi, kaja-nyanu Yamuru-kurlangu kujalpa Yiipiti nyinaja. Manulpa-jana wiri nyinaja yapa nyanungu-nyanguku. Yuwayi, kuja Jikimirli nyangu Tiina, puuly-mardarninjarla kurntaku ngurrju-manu. Jinyijinyi-manu ngunanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Junga, ngampurrpa-nyayirnilparla nyinaja karntakuju. Yulkaja-nyayirnilparla, manu puuly-mardarninjarla maju-manu. Ngula-jangka, wangkajarla ngurrju-nyayirni, manu puta walyka-manu. ");
INSERT INTO wbp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ngula-jangka, Jikimi yanu pina ngurra-kurra, manu wangkajarla nyanunguku kirdanaku, “Payirninjinka Jakupu yungurna yupukarra-jarri nyanunguku yurntalu-nyanu-kurlu Tiina-kurlu.” Junga-juku, Yamuruju yanu payirninjaku Jakupuku. ");
INSERT INTO wbp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ngula-puruju, Tiinakupalangurlu Jakupurlu purda-nyangu Jikimiji kuja ngunaja nganta nyanunguku yurntalu-nyanu-kurluju. Jakupu-kurlangu kaja-nyanu-patujulpalu nyinaja yuwurrkurla, pulukulpalu-jana mardarnu. Jungalpa-jana Jakupuju pardarnu kaja-nyanu-watiki kajili pina-yanirni warrki-jangka. ");
INSERT INTO wbp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ngula-jangkaju, Yamuru yanurnu kaja-nyanu Jikimi-kirli Jakupu-kurlangu-kurra ngurra-kurra. Payurnu kajilpa Jikimi yupukarra-jarriyarla Tiina-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ngaka-pardu-kari, yukajarnili Jakupu-kurlangu kaja-nyanu-patuju ngurra-kurralku. Kujalu yanurnu ngurra-kurra, Jakupurlu-jana yimi-ngarrurnu kuja Jikimirli puuly-mardarninjarla Tiina maju-manu. Kurnta-jarrijalu, manu kula-jarrijalurla Jikimikiji. Kurnta-manu-nyayirni nganta-jana nyanungu-nyangu warlaljaju Yijiralirlaju. Manu Jikimirli nganta kaji yampiyarla-juku marnpirninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ngula-jana Yamuru wangkaja nyanungukupurdangka-patuku, puta-jana walyka-manu, “Ngaju-nyangu kaja-nyanu ngampurrpa karla ngawurru-purajikiji nyina. Ngurrjulu-jana wangkaya yungulpa-pala nyinakarla. ");
INSERT INTO wbp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nyuntu-nyangu warlaljarlu manu ngaju-nyangu warlaljarlu karlipa-jana panu-jarlu karnta kaminakamina mardarni. Yinyi jarnkujarnkurlipa-nyanu yupukarra yupukarra ngalipa-nyangu kaja-wati-kirra. Yungurlipa warlalja-patu wiri nyina tarnnga-juku jintangka-juku. ");
INSERT INTO wbp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nyurrurla yungunkulu nyina nyampurla ngurungka tarnnga. Nguru wiri-ka karri. Kajikankulu nguna kutu, manu kajikankulu-nyanu mani nyiyarningkijarra.” Kujarlunyalpa-jana Yamururluju yipiljiyipilji-manu Jakupuju manu nyanunguku kaja-nyanu-patuju. ");
INSERT INTO wbp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ngula-jangka-jana Jikimi wangkaja Jakupuku manu kaja-nyanu-patuku, “Yuwa, yimiri nyinayajulu yungurna yupukarra-jarri nyuntu-nyangu yurntalpa-kurlu. Ngula-wanawanaju kapurna-nyarra nyiyarningkijarra yinyi kajinkijili payirni. ");
INSERT INTO wbp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Marda tala wirirlanguku kajinkijili payirni yungurna yupukarra-jarri, kapurna-nyarra yinyi. Ngarijili yimiri nyinaya yungurna karnta-kurlu yupukarra-jarrimi!” ");
INSERT INTO wbp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kala Jakupu-kurlangu kaja-nyanu-paturlu kulalu-jana yalu-manu Jikimi manu Yamuruju jungarnirli. Manngu-nyangulpalu kuja Jikimirliji nganta maju-manu nyanungurra-nyanguku ngawurru-nyanu, manulpalu-nyanu wangkaja nyarrparlu yungulu-jana pinyi. Yulyurlku-yirrarnulu-jana, manu wangkajalurla Yamuruku, ");
INSERT INTO wbp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Kulalparnalurla yungkarla nganimpaku ngawurru-nyanuju nyuntu-nyangu kaja-nyanu Jikimiki yupukarraju, kulangku nganangku ngarrka-kujurnu. Kajilparnangkulu Tiina yungkarla yupukarraku, kujaju kurntangka-nyayirni! ");
INSERT INTO wbp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kajinpa ngampurrpa nyina nganimpakupurdangkaku ngawurru-nyanuku kaja-purajiki yupukarra maninjaku, ngulakungarntirlijili-nyanu ngarrka-kijika-wiyi. Kujanya kuruwarriji nganimpa-nyangu. ");
INSERT INTO wbp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kajinkili-nyanu ngarrka-kijirni, ngulaju kajikarnalu nyina nguru nyampurla nyurrurla-kurlu. Kajikarlipa-nyanu jarnkujarnku yinyi yurntalu-nyanuju yungurlipa jintangka nyina. ");
INSERT INTO wbp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kala kajinkili nyina ngarrka-kijirninja-wangu-juku, kapurnalu yampinjarla yani nyampuku ngurraraku, ngulaju ngawurru kapurnalu kanyi-yijala nguru-kari-kirra.” ");
INSERT INTO wbp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yamuru manu kaja-nyanu Jikimili-jana ngungkurr-nyinaja Jakupu-kurlangu kaja-nyanu-patuku, manulu-jana wangkaja, “Ngulaju ngula-juku. Kapurnalu-nyanu ngarrka-kijirni jintawarlayirli.” ");
INSERT INTO wbp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Yalumpurla ngurrangka, panulpalurla yulkaja Jikimikiji, manulparla ngampurrpa nyinaja yupukarra-jarrinjaku Jakupu-kurlangu yurntalu-nyanuku. ");
INSERT INTO wbp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kujakungarntiji, Yamuru manu Jikimi-pala pina-yanu ngurra-kurra yungulu-jana wati-patu-kariki wangkami. ");
INSERT INTO wbp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Wangkajalu-jana, “Nyampurra-wati Jakupu manu nyanunguku kaja-nyanu-patu, ngulaju ngurrju-nyayirni kalu-nganpa nyina. Wangkami yungurlipa-jana yungulu tarnnga nyinami nyampurla. Nguru wiri-ka nguna nyanungurrarlanguku. Yungurlipa-jana yupukarra-mani yurntalu-nyanu-wati, manu yungulu ngalipa-nyangu yurntalu-nyanu-kurlu yupukarra-jarrimi. Manu yungurlipa jintangka-juku nyina. ");
INSERT INTO wbp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kujakungarntiji yungurlipa-nyanu ngarrka-kijirni nganta. ");
INSERT INTO wbp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nyarrpa kankulu manngu-nyanyi? Kajirlipa-nyanu ngarrka-kijirni, nyanungurra-nyangu puluku manu jiyipi-wati yungulu ngalipa-nyangu-jarrimi. Yuwayi, ngarrka-kijirnirlipa-nyanu yungurlipa-jana jirrnganja nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yuwayi, ngungkurr-nyinajalu-palangu Yamuruku manu Jikimikiji. Jinta-jarrinjarlalu-nyanu ngarrka-kujurnu. ");
INSERT INTO wbp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Parra jirrama-jangka, wati-patujulpalu jata-nyangu murrumurru kujalu-nyanu muku ngarrka-kujurnu. Ngarilpalu waparlku ngunaja-puka jaarl-nyanja-wangu. Ngula-jangkaju, jirrama yangka Jakupu-kurlangu kaja-nyanu-jarra Jimiyani manu Liipi, Tiinaku papardi-nyanu-jarra, yaninjarlalu-jana muku pakarnu junma yiri-kirlirli. Ngarili-jana riwarr-pungu. ");
INSERT INTO wbp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Yaninjarlalu-jana pungu Yamuru manu nyanunguku kaja-nyanu Jikimirlangu. Manulu Tiina pina-kangu Jikimi-kirlangu-jangka ngurra-kurra nyanungu-nyangu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ngulalu Jakupuku kaja-nyanu-watiji pina-yanu yinya kirri wiri-kirra Yamuru-kurlangu-kurra. Nyangulu-jana nyurnu ngunanja-kurra, manulpalu purungku-manu nyiyarningkijarra, kuja Jikimirli nganta ngawurru-nyanu maju-manu. ");
INSERT INTO wbp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Purungkulu-jana jurnta kangu puluku, jiyipi, narnukutu manu tangkiyi kujalpalu nyinaja yinyarra yapa-kurlangu. ");
INSERT INTO wbp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ngarili yaninjarla manu nyiyarningkijarraju, kangulu-jana muku karntakarnta manu kurdukurdu, manulpalu yuwarli-kari yuwarli-kari-kirra yukaja purunjuku. ");
INSERT INTO wbp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kujalu pina-yanurnu Jakupu-kurlangu ngurra-kurra nyiyarningkijarra-kurlu, kurnta-ngarrurnu-palangu Jimiyani manu Liipiji, “Nyiyakunpajupala kurntaku ngurrju-manu. Yangka Kanana-wardingki-wati manu Piriji-wati yapa-patu, kuja kalu nyina nyampurla ngurungka, kapulu-nyarra purda-nyanyi kujankulu-jana pungu Yamuru manu Jikimi manu wati-patu-kari. Kapulu wangka ngaju nganta punku pukulyu kuyu-piya! Ngalipa-nyangu warlaljaju wita yapa-kurlu. Kala yinyarra Kanana-wardingki manu Piriji-wati, ngulajulu panu-jarlu-nyayirni. Kajili jinta-jarri, kapulu-ngalpa muku pinyi!” ");
INSERT INTO wbp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Jimiyanirli manu Liipirli-pala yalu-manu kirda-nyanuju, “Yuwa! Nyiyaku kanpa-jarrangku kurnta-ngarrirni? Yinyarlu Jikimirli maju-manu ngajarrakupurdangka. Nyanungurlu jinyijinyi-manu nganimpaku ngawurru-nyanu ngunanjaku nyanungu-kurluku yangka karnta punku-piya kuja-ka talakupurda warru nguna!” ");
INSERT INTO wbp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ngaka-pardu-kari, Kaaturla wangkaja Jakupuku, “Yanta pina nyuntu-nyangu warlalja-patu-kurlu Pijili-kirra, yinya ngurra yangka kujarnaju ngajulurlu milki-yirrarnu nyuntu-kurra, kujanpa wuruly-parnkaja papardi-puraji Yijuwu-kujaku. Kajinpa yani yinya-kurra, yarturlu-patuju murnju-yirraka yurturlurla yungunpaju pulka-pinyi ngajuku.” ");
INSERT INTO wbp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Junga-juku-jana Jakupuju wangkaja nyanungu-nyangu warlalja-patuku manu yapaku kujalpalurla warrki-jarrija nyanunguku, “Kajinkili-jana nyurrurlarlu mardarni nyiyarlangu juju, ngulajulu-jana yampiya. Kulalu-jana parntarriya, ngarili puraya Kaatu-mipa. Yukayalu ngurrjungka jurnarrparla wurnakungarnti. ");
INSERT INTO wbp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pinarlipa yani ngurra pirli-kirra pirli-patu-kurlu-kurra Pijili-kirra. Yinyarlanya kapurna-jana yarturlu-patuju turnu-maninjarla murnju-yirrarni Kaatuku pulka-pinjakungarnti. Nyanungurlunyalpaju warrawarra-kangu ngajuku papardi-nyanu Yijuwu-kujakuju kujalpaju wajirli-pungu. Warrawarra-kangulpaju warrarda kujalparna nyarrpara-wanarlangu wapaja.” ");
INSERT INTO wbp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Junga-juku, yapangkujulurla yungu muku nyiyarningkijarraju Jakupukuju kujalpalu-nyanu mardarnu juju manu langa-kurlangurlangu. Kangu-jana Jakupurluju, manu yanu kirri-kirra Jikimi-kirra. Ngulangkaju-jana yangkarra juju milyingka yirrarnu kanunju watiya wiringka kujalpa yupa-patuku karrija. ");
INSERT INTO wbp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ngula-jangkaju, Jakupurlu manu nyanungu-nyangu warlaljarlu yampinja-yanu yinya ngurra manu yanulu Pijili-kirra. Ngula-puruju, yangka yapa-patu-kari kujalpalu nyinaja yinya ngurra-wana, kululpalu-jana pardarnu. Kala Kaaturlu-jana lani-manu, kulalu-jana wajirli-pungulku. ");
INSERT INTO wbp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ngaka-pardu-kari, Jakupu manu nyanungu-nyangu warlalja-patu yukajarralu Luujurla yirdi-pardu-kari Pijiliki. Yinya ngurra ngulaju Kananarla. ");
INSERT INTO wbp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yinyarlanya-nyanu Kaaturluju milki-yirrarnu Jakupu-kurraju kamparrurlu-wiyi, yangka kujalpa wuruly-parnkanjinaanu papardi-nyanu Yijuwu-kujaku. Ngula Jakupurluju turnu-maninjarla murnju-yirrarnu yarturlu-patu yurturlurla Kaatuku pulka-pinjakungarnti, manu yirdirla yirrarnu ngulaju ‘Yal-Pijili’. ");
INSERT INTO wbp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Jakupu-kurlangu warlaljarlalpa nyinaja muturna yirdiji Tipuru. Wiri-manu Jakupu-kurlangu ngati-nyanu Ripika. Kuja Ripika palija, ngulajulpa Tipuru warrarda nyinaja-juku Jakupu-kurlangu warlalja-kurlu. Yuwayi, yinya muturna palijalku, ngulalu milyingka yirrarnu kanunju watiyarla kurrkapirla pirlingka kanunju Pijili-ngirli. Yirdi-manurla yinya ngurra ‘Yalana-Pakuju’. ");
INSERT INTO wbp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kujalu Jakupu manu nyanungu-nyangu warlalja-patu yukajarra yinya ngurrangka Pijilirla yinya wurna-jangka Patana-Yarrama-jangka, Kaaturlu-nyanu yarda milki-yirrarnu, manurla ngurrju-nyayirni wangka, wangkajalparla kapu warrarda pirrjirdi-maninjarla warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nyanungurla kuja wangkaja, “Jalangu nyuntu-nyangu yirdiji Jakupu. Jalangu-ngurlu kulangkulu nganangku yirdi-mani kujaju. Nyuntu-nyangu yirdiji Yijirali.” Junga-juku, Kaaturlu Yijiralirla yirdiji yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ngula-jangka, Kaaturla wangkaja, “Ngajujurna PIRRJIRDI-NYAYIRNI WITA-WANGU! Kurdu panu-jarlujulu kurduwarr-kijika! Nyuntu-nyangurlu kurdukurdurlu kapulu-jana mardarni kurdu panu-jarlu ngurarra-kari ngurarra-karirla, ngularraju wiri-jarrinjarla kapulu-jana wiriwirilki nyina yapaku nguru-kari nguru-karirla. ");
INSERT INTO wbp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nyampu nguru kujarnarla yungu warringiyi-purajiki Yipuruyamuku manu nyuntu-nyangu kirdanaku Yijakiki, ngajulurlu karnangku yinyi nyuntukulku, manu ngaka kajinpa nyuntu palimi, ngajulurlu kapurna-jana yinyi nyuntu-nyangu kurdukurduku.” ");
INSERT INTO wbp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kujarla Kaatu kuja wangkaja Jakupuku yinya ngurrangka, yampinjarla pina-yanu kankarlarra. ");
INSERT INTO wbp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ngula-jangka, Jakupurlu jinta-kari pirli lalypa manu, manu juka-yirrarnu walyangka yinya yangka kujarla Kaatu wangkaja nyanunguku. Kuja yinya pirli juka-yirrarnu, ngularla pama manu jara kankarlumparra winjurnu Kaatuku yati-wangkanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ngula-jangkaju, yirdilkirla yirrarnu ‘Pijili’. ");
INSERT INTO wbp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ngaka-pardu-kari, Jakupu manu nyanungu-nyangu warlaljarlulu yampinja-yanu yinya ngurra Pijili, manulu yanu ngurra jinta-kari-kirra yirdi-kirraju Yiparata-kurra. Jakupu-parnta Rajulu, ngulajulpa nyinaja miyalu-pardu, kulkurru-juku mardarnu wurna-puru-juku kurduju. Murrumurru-nyayirnilpa-nyanu purda-nyangu, manulpa manngu-nyangu kurdu nganta wajawaja-maninja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kurdu yinya kula wilypi-pardija. Karnta jinta-karilpa nyinaja Rajulu-kurluju jija-piya kurdu-kurlangu-piya. Ngakalku palka-jarrija kurduju, ngulaju wirriya. Karntarla wangkaja Rajuluku, “Kula lani-jarriyalku, kaja jinta-kari kanpa mardarni.” ");
INSERT INTO wbp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rajulujulpa murrumurru-nyayirni nyinaja palinjakungarnti. Palinjakungarntirli yirdirla yirrarnu kurdukuju ngulaju Pinuni. Kala Jakupurlurla yirdi jinta-kari yirrarnu Pinyamini. ");
INSERT INTO wbp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ngula-jangkaju, Rajulu palijalku. Jakupurlu palka nyanungu-nyanguju kangu, milyingka yirrarnu Yiparatarla. Yirdi jinta-kariji Pijilimi. ");
INSERT INTO wbp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kankarlu yinya milyingka, Jakupurlu juka-yirrarnu jinta pirli lalypa yungulu yapangku milya-pinyi kujalpa nyarrpararla Rajulu milyingka ngunaja. Yinya pirli ngulaju palka-juku jalanguju-ka karrimi. ");
INSERT INTO wbp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yinya-jangkaju, Yijirali manu nyanungu-nyangu warlalja-patu, ngulajulu ngunaja murrarninginti ngurrangka yirdingkaju Mikitu-Yitururla. ");
INSERT INTO wbp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Nyinajalpalu yinyarlaju. Ngula Yijirali-kirlangu kaja-nyanu yangka kamparru-warnu-paja Ruupunu yaninjarla ngunaja Piilya-kurlu. Piilyaju ngulajulpa nyinaja Rajulu-kurlangu warrkini. Kali-nyanu-piyalkulparla nyinaja Yijiralikiji. Yijiralirliji purda-nyangu kuja nyarrpa-jarrija Ruupunu. ");
INSERT INTO wbp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","26","Nyampurranya yirdi-watiji kaja-nyanu-wati-kirlanguju kujalurla palka-jarrija Jakupuku Patana-Yarramarla. Nyanungu-parnta Liiyarlurla palka-manu-jana nyampu jika-pala: Ruupunu yangka Liiya-kurlangu kaja-nyanu kamparru-warnu, Jimiyani, Liipi, Juurda, Yijaka manu Jupulunu. Jakupu-parnta jinta-kari Rajulurlu ngulaju-palangu mardarnu nyampu-jarra Jajupu manu Pinyamini. Rajulu-kurlangu warrkinirli Piilyarlu, ngulaju-palangu mardarnu jirrama-yijala Taanu manu Napatali. Liiya-kurlangu warrkinirli Jiilparlu, ngulaju-palangu mardarnu jirrama-yijala Kaardu manu Yaaja. ");
INSERT INTO wbp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ngaka-pardu-karilki, Jakupu manu nyanungu-nyangu warlalja-patu pina-yanulu Mamiri-kirra kujalpa nyanungukupalangu Yijaki wankaru-juku nyinaja. Mamirijilpa kutu karrija ngurra-karikiji Kiri-Yarrpakuju. (Yirdi jinta-kariji Yipurana.) Yinyarlanya Yipuruyamu manu Yijakiji kala-pala nyinaja kamparru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Kujarla Yijakiki rdipija 180-pala yulyurrpu, ngulaju palijalku. Junga, purlka-pardu-nyayirnilpa nyinaja. Nyanungu-nyangu kaja-nyanu-jarrarlu Yijuwurlu manu Jakupurlu-pala milyingka yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nyampuju wati Yijuwu, ngulalpa yirdi mardarnu jinta-kari Yitama. Nyampuju yimi nyanungu-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Yijuwurluju, karnta marnkurrpa-jana manu, ngulalpalu nguru ngulangka nyinaja Kananarla. Nyampu karnta kamparru-warnu nyanungu-parnta ngulaju Yaata, ngulajulpa yurntalpa Yaluna-kurlangu. Yalunu, ngulaju Yititi yimi-kari. Yijuwu-parnta karnta kulkurru-warnu yirdi Yulipama, ngulalparla yurntalpa nyinaja Yaana-kurlangu manu Jipunu-kurlangu warringiyi-nyanu. Jipunujulpa Yiipiti nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Yijuwu-kurlangu karnta nyanungu-parnta jinta-karilki ngulaju Pajama, ngulalparla yurntalpa nyinaja nyampuku Yijimaliki manu ngawurru-nyanu nyampuku Napataku. ");
INSERT INTO wbp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Yijuwu-kurlangu karnta nyanungu-parnta Yaata, ngulakujurla palka-jarrija wirriya Yilipaja. Ngula-jangka, jinta-kariki karntakujurla palka-jarrija Pajamaku wirriya-yijala yirdiji Ruulu. ");
INSERT INTO wbp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Yinyarlu kulkurru-warnurlu karnta jinta-karirli yirdingkiji Yulipamarlu, ngula-jana mardarnu wirriya-patu marnkurrpa yirdi-patuju Jiyuju, Jalama manu Kuura. Nyampurra ngulaju Yijuwu-kurlangu kaja-nyanu-patu, palka-jarrijalu ngulangka-juku ngurungkaju Kananarla. ");
INSERT INTO wbp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","Nyinaja kujalpalu nguru Kananarla, Yijuwurlulpa-jana mardarnu panu-nyayirni puluku, jiyipi, manu ngula-piya-yijalalpa-jana nyanungukupurdangkarluju Jakupurluju mardarnu panu-yijala. Ngulangka kulalpa mangarri karrija miyi, marna manu ngapa nyampuku ngarninjaku pulukuku manu jiyipiki, lawa. Nyampu-jangkaju, Yijuwurluju kangu-jana nyanungu-parnta, yurntalu-nyanu, kaja-nyanu manu yapa-patu-kari nyanungu-nyangu wungu-warnu, puluku, jiyipi manu nyiyarningkijarra. Muku-jana kangu Kanana-ngurluju wurnturu-nyayirni pamarrpa-kurra yirdi-kirraju Jiiri-kirra. Ngulangkalkujulpalu nyinaja tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nyampunya yimi Yijuwu-kurlu, nyanunguku kaja-nyanu-patu-kurlu, manu panu yapa-kurlu ngulalu-jana palka-jarrija nyanunguku kaja-nyanu-patuku, ngularra-kurlu nyampuju yimi. ");
INSERT INTO wbp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Kala kamparru-warnuku karntaku, ngulajurla palka-jarrija Yaatakuju, Yijuwurlu ngulalpa jinta kaja-nyanu mardarnu yirdiji Yilipaja. Ngula nyampu-parnta kamparru-warnu-kurlangu kurdukurduju rdaka-pala: Timina, Yaamuru, Jiipuyu, Katama manu Kinaja. Kala jinta-kari-kirlangu Timina-kurlangu, ngulaju Yilipajarlu mardarnulpa jinta-kari kaja-nyanu Yamaliki. Ngula-jangka, jinta-kari kulkurru-warnu karnta ngula-kurlanguju, Pajamaku ngulajurla nyinaja kaja-nyanu jinta Ruulu. Ruulukuju kaja-nyanuju ngulajulpalurla karrija murntu-pala Naaja, Jiiruyu, Jaama manu Miija. ");
INSERT INTO wbp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Kala nyanungu-parnta kulkurru-warnuku Yulipamaku, nyanungu-parnta Yijuwukuju ngulaju marnkurrpa-jalalpalurla nyinaja Jiyuju, Jalama manu Kuura. Nyampu Yulipama ngulajulpa yurntalpa nyinaja Yaanaku Jipunu-kurlangu warringiyi-nyanu. ");
INSERT INTO wbp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Nyampurra wiriwiri ngulajulpalurla palka-jarrija Yilipajaku yangka Yijuwu-kurlangu manu Yata-kurlangu kaja-nyanu: Timina, Yaamuru, Jiipuyu, Kinaja, Kuura, Katama manu Yamaliki. Ngulajulpalu-jana wiriwiri nyinaja yapa panukuju kujalpalu nyinaja ngurungka Yitamarla. ");
INSERT INTO wbp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nyampurra yirdi-patu ngulajulpalurla palka-jarrija Ruuluku yangka Yijuwu-kurlangu manu Pajama-kurlangu kaja-nyanu: Naaja, Jiira, Jaama manu Miija. Ngulajulpalu-jana wiri-yijala nyinaja yapa panukuju. ");
INSERT INTO wbp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","19","Nyampurra yirdi-patu ngulalpalurla palka-jarrija Yulipamaku yangka yurntalpa-nyanu Yaana-kurlanguku: Jiyuju, Jalama manu Kuura. Ngulajulpalu-jana wiri-yijala nyinaja yapa panukuju. ");
INSERT INTO wbp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Nyampu wati yirdi Jiiri ngulajulpa nyinaja Yuuri-kirlangu yapa. Nyanungu manu yapa panu, ngulajulpalu kamparru-warnuju nyinaja Yitamarlaju. Jiiri-kirlangu kaja-nyanu ngulaju yirdi-patuju Lutunu, Jupulu, Jipunu, Yaana, Tijana, Latana manu Tiijana. ");
INSERT INTO wbp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lutunu-kurlangu ngulaju jirrama kaja-nyanu-jarraju: Yuuri manu Yumama. Lutunukupurdangka ngawurru-nyanu yirdiji Timina. ");
INSERT INTO wbp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Jupulu-kurlangu kaja-nyanu-patu ngulaju Yalpana, Manyata, Yipulu, Jiipu manu Yunama. ");
INSERT INTO wbp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Jipunu-kurlangu kaja-nyanu-jarra ngulaju jirrama: Yaaya manu Yaana. Nyampurlu Yaanarlu ngulaju kuja palka-manu ngapa jila-jangka kujalpa warlu-piya ngapa yarnkaja kankarlarra walya-ngurlu nyurru-wiyi kujalpa warrawarra-kangu jiyipi jaji-nyanu-kurlangu. ");
INSERT INTO wbp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Yaana-kurlangu ngulaju jirrama yirdi Tijana manu karntaju Yulipama. ");
INSERT INTO wbp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Tijana-kurlangu kaja-nyanu-patu ngulaju yirdi-patuju Yantama, Yajipana, Yijirana manu Karana. ");
INSERT INTO wbp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Latana-kurlangu kaja-nyanu-patu ngulaju yirdi-patuju Pilyana, Jaapana manu Yakana. ");
INSERT INTO wbp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Tiijana-kurlangu kaja-nyanu-jarra ngulaju jirrama yirdi-jarraju Yuuju manu Yarana. ");
INSERT INTO wbp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Nyampurra ngulajulpalu yirdi wiriwiriji nyinaja kujalpalu ngurungka Yuuriti-wardingki yapa-patu nyinaja Jiirirla: Lutunu, Jupulu, Jipunu, Yaana, Tijana, Latana manu Tiijana. ");
INSERT INTO wbp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Yalirla ngurungka Yitamarla, kamparru-wiyi Yijirali-pinki-kirlangu kingi-wangurla-wiyi, kujalpa lawa karrija yinyarla, panu parliya yapalpalu kingi-kari kingi-kari nyinaja, ngulalpalu-jana yapakuju nyinaja jinta-kari-jangka jinta-karilki. Nyampurranya yirdi: ");
INSERT INTO wbp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Kamparru-warnu wiri yinyarla ngurungka ngulaju Piila, Piyuru-kurlangu kaja-nyanu. Ngulajulpa nyinaja nguru kirri-kari-wardingki Tinyapa-wardingki. ");
INSERT INTO wbp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Kuja Piila palija, Juyupu-jalalpa wiriji nyinaja, marlaja kangurla nyanungurlulku ngurungkaju. Ngulajulpa kaja-nyanu nyinaja Jiira-kurlangu ngulaju kirri Paajara-wardingki. ");
INSERT INTO wbp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kala kuja Juyupu palija, Yuujamalku-jala wirijilpa nyinaja, marlaja kangurla nyanungurlulku ngurungkaju. Ngulaju kirri-kari-wardingki-jala kujalpalu Timina-kurlangu yapa nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kuja Yuujama palija, Yatatalku-jalalpa wiri nyinaja, marlaja kangurla nyanungurlulku ngurungkaju. Nyanungukupalanguju Pititi kujalpa kulu wirikingarduyu nyinaja nyurru-wiyi manu yangka kuja pungu Mirdiyanu nguru-karirla Muwapurla. Yatata, ngulajulpa nyinaja kirri-kari-wardingki Yapiti-wardingki. ");
INSERT INTO wbp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kala kuja Yatata palija, Jamalalku wiri nyinaja, marlaja kangurla nyanungurlulku ngurungkaju. Ngulaju kirri-kari-wardingki Majaraka-wardingki. ");
INSERT INTO wbp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kala kuja Jamala palija, Jawurlulku wiri nyinaja, marlaja kangurla nyanungurlulku ngurungkaju. Ngulaju kirri-kari-wardingki Riyupuju-wardingki ngula-ka karri kirriji karru-wana. ");
INSERT INTO wbp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kala kuja Jawurlu palija, Paal-Yananalku wiri nyinaja, marlaja kangurla nyanungurlulku ngurungkaju. Nyanungukupalangu jaji-nyanu ngulaju Yakipuru. ");
INSERT INTO wbp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kala kuja Paal-Yanana palija, Yardurulku wiri nyinaja, marlaja kangurla nyanungurlulku ngurungkaju. Ngulaju kirri-kari-wardingki Pawu-wardingki. Nyanungu-parnta karnta yirdiji Mitapulu, ngulaju yurntalpa-nyanu Marturtu-kurlangu. Marturtukupalangu ngati-nyanu yirdiji Miijapa. ");
INSERT INTO wbp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Nyampurraju yirdi-patu wiriwiri Yijuwu-kurlangu yapa ngurungka yinyarla Yitamarlaju: Timina, Yaalpa, Jititi, Yulipama, Yiila, Pinana, Kinaja, Timina, Mipijara, Makatila manu Yirama. Nyampu-patu kaja-nyanu-patulu wiri-jarrija, manulu jarnkujarnku yanu kirri-kari kirri-kari-kirra manu ngurra-kari ngurra-kari-kirra nyinanjaku. Ngurra-kari ngurra-karilpalu-jana wiri nyinaja warlaljayirriki. Yalumpurra ngurra-paturlulpalu yirdi-patu jurrku-juku mardarnu yangka-patu yirdi kaja-nyanu-patu-kurlangu. ");
INSERT INTO wbp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jajupukupalangu kirda-nyanu Jakupu nyinajalpa ngurrara Kananarla, ngurra jinta-juku kujalpa Jakupukupalangu Yijaki wapaja ngurra-kari ngurra-kari. ");
INSERT INTO wbp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Nyampuju yimi Jakupu-kurlu manu nyanungu-nyangu warlalja-kurlu. Jakupu-kurlangu kaja-nyanuku Jajupukujurla rdipija 17-pala yulyurrpu. Nyanunguku papardi-nyanu-patujulpalu nyinaja ngati-nyanu-patu-kurlangu marnkurrpa-kurlangu Liiya-kurlangu, Piilya-kurlangu manu Jiilpa-kurlangu. Piilya manu Jiilpa, ngulaju yangka kuja kalalu-palangu warrki-jarrija Jakupu-parnta-jarraku yirdikiji Liiyaku manu Rajuluku. Jakupujulpa-jana kirda-nyanu nyinaja yinyakuju wirriyawirriyakuju. Jajupurlu manu papardi-nyanu-paturlu kalalu-jana warrawarra-kangu jiyipi manu narnukutu-wati. Jajupuju kala pina-yanurnu yimi-kirli Jakupu-kurra yangka kuja kalalu nyanunguku papardi-nyanu-patu maju-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Nyampukungarnti, Jakupujulpa nyinaja purlkalku kuja Jajupu palka-jarrija. Kujarlanya, kalarla karrikarri-wangu-nyayirni yulkaja Jajupukuju nyanunguku papardi-nyanu-piya-wanguku. Kuja kalarla yulkaja Jajupuku, nyanungurlurla jinajina-piya kirrirdi ngurrju-nyayirni ngurrju-manu kuruwarrikuruwarri. ");
INSERT INTO wbp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Jajupuku papardi-nyanu-paturlulpalu milya-pungu kujalparla nyanungurrakupalangu kirda-nyanu yulkaja Jajupu-mipaku. Kujarlanya kalalurla nyurunyuru-jarrija. Kula kalalurla ngurrjurlangu wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ngaka-pardu-karirla, Jajupujulpa jarda ngunaja. Ngula-puru mungangka ngulaju jukurr-manu. Ngula-jangka mungalyurru pardinjarla yarnkajarra, yimi-ngarrurnu-jana nyanungukupurdangka-patuku kuja nyangu jukurrparlu. Kujalu purda-nyangu nyampu jukurrpa, ngulajulpalurla nyurunyuru-jarrija-nyayirnilki. ");
INSERT INTO wbp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nyampunya-jana jukurrpaju yirri-puraja Jajupurluju ngula-jana wangkaja, “Purda-nyangkajulu kujarna jukurr-manu mungangkarlu! Nyampunyarna nyangu mungangkarlu. ");
INSERT INTO wbp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Panu-juku ngantalparlipa warrki-jarrija yupuju-wana, manu wayipurrurnurlipa mangarri. Ngulalparlipa warru pajurnu warrukirdikirdi kirrirdikirrirdi marna. Ngula-jangka, jinta-kari jinta-kari ngantalparlipa warurnu, manu jungarni-maninjarla yirrarnulparlipa walya-kurra ngaka yungurlipa mani ngurluju mangarriki. Ngula-jangka, yinya ngaju-nyangu warirninja-warnu marna ngulaju karrinja-pardija yangka yapa-piya. Manu panu-kariji nyurrurla-nyanguju warirninaja-warnu-patu-karili karrinja-pardija-yijala, ngulalu yanurnu. Karrijalu warru ngaju-nyangu-wana warrukirdikirdi. Ngula-jangkaju, parntarrijalurla warru ngaju-nyanguku kamparru. Nyampunyarna jukurrpaju nyangu.” ");
INSERT INTO wbp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ngulalurla wangkaja nyanungukupurdangkaku, “Nyampuju mayi kanpa manngu-nyanyi yungu ngantanpa-nganpa wiri nyina nyuntulu nganimpaku marda kingi-piya nganta?” Nyanungukupurdangka-patu papardi-nyanu-patu yijardulkulpalurla nyurunyuru-jarrija yungu nyampu jukurrpa nyangu manu kuja-jana yimi-ngarrurnu nyanungu-patuku. ");
INSERT INTO wbp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ngaka-pardu-kari Jajupurlu yarda jukurr-manu. Mungalyurru pardinjarla wangkaja-jana papardi-nyanu-patuku, “Mungangka jukurr-manurna. Ngulajurna nyangu wanta, kirntangi manu 11-pala yanjilypiri, ngulajulpajulu parntarrija warru ngajuku yapa-piya-jala.” ");
INSERT INTO wbp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ngula Jajupuju yanurla, yimi-ngarrurnu jaji-nyanuku Jakupuku nyampu kuja nyangu jukurrpa. Kuja purda-nyangu jaji-nyanurlu jukurrpa, ngulangkuju kulungku ngarrurnu Jajupuju, manurla wangkaja Jakupuju, “Yampiyarlanpa nyampuju jukurrpa yimi-ngarrirninja-wangurlu! Nyiyakunpa-nganpa yirri-puraja maju nyampu jukurrpa? Ngati-puraji, nyuntukupurdangka-patu manu ngaju manu panu-kari, kularnangkulu parntarri nyuntuku kamparru!” ");
INSERT INTO wbp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Jajupukupurdangka-patu ngulajulpalurla jankanjarla mimayi-jarrija-nyayirni. Kala jaji-nyanurlu Jakupurlu ngulajulpa manngu-nyangu-juku kuja yalirli yimi-ngarrurnu jukurrpa Jajupurlu. ");
INSERT INTO wbp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","14","Ngaka-pardu-karirla, Jakupu manu nyanungu-nyangu yipilji nyinajalpalu manangkarrarla kutu kirriki Yipuranaku. Jajupukupurdangka papardi-nyanurlu, kangulu-jana panuju jaji-nyanu-kurlangu jiyipi-patu yali kirri-kirra Jikimi-kirra yungulu-jana warrawarra-kanyi yalumpurla-juku. Ngaka-pardu-karilki, Jakupu wangkajarla Jajupuku, “Nyuntukupurdangka-paturlu kalu-jana mardarni jiyipi-patu kutu Jikimirla. Kapirnangku nyuntuju yilyami yinya-kurra. Yanta ngayi-jana, nyanjanka-jana ngurrju-japa kalu-jana mardarni jiyipi ngaju-nyangu-patu. Ngula-jangka pina-yantarni yungunpaju yimi-ngarrirni nyarrpa-jarri kalu.” Jajupu wangkajarla nyanungukupalangu jaji-nyanuku, “Yuwayi, kapirna yani Jikimi-kirra.” Junga-juku, Jakupurluju yilyaja. Ngaka-pardu-karirlalku yukajarra Jikimi-kirraju. ");
INSERT INTO wbp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Yaninjarla kawarr-karrijalpa ngula-wana-juku nguru-kari nguru-kari, warrurnulpa-jana nyanungukupurdangka-patuku manu jiyipi-watiki. Ngula watingki parlu-pungu kawarr-karrinja-kurra manu payurnu, “Nyiyaku kanparla warrirni?” ");
INSERT INTO wbp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Jajupurlu yalu-manu watiji, “Ngaju karna-jana warrirni ngajukupurdangka-patuku kuja kalu-jana mardarni jiyipi-patu. Milya-pinyi marda kanpa-jana nyarrpararla kajikalu nyina?” ");
INSERT INTO wbp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Watirla wangkaja Jajupukuju, “Kala yanu mardalu kirri-kari-kirra kujarna-jana purda-nyangu kujalpalu wangkaja yaninjaku jiyipi-patu-kurlu ngurra-kari-kirra yirdi-kirraju Tajana-kurra.” Ngula-jangka, Jajupuju yarda yanu Tajana-kurralku. Kuja yukajarra yali-kirra, ngula-jana nyangu nyanungu-patu manu jiyipi wurnturu-kurra-juku. ");
INSERT INTO wbp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ngulalu nyangu nyanungukupurdangka-paturlu yaninjarni-kirra wurnturu-kurra-juku. Ngulalpalu-nyanu wurulywuruly-wangkajalpa jinta-kari jinta-kariki, ");
INSERT INTO wbp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Wayi! Nyangkalu, nyampunya yangkaju rdipija Jajupu yangka jukurrpa wita-wangu! ");
INSERT INTO wbp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Pinyirlipa jalangurlu-juku, kijirnirlipa palkaju kanunju rdaku-kurra. Kaji-ngalpa ngalipakupalangurlu payirni nyanunguku, kajikarliparla yimi-ngarrirni kuja malikirli yarlkurnu manu pungu. Yuwayi, pinyirlipa! Kula-ngalpa wiri nyina ngalipakuju. Yimi kuja-ngalpa yirri-puraja jukurrpa-jangka nganta, ngulaju yungulparla yalirrpa-karriyarla.” ");
INSERT INTO wbp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ngula-jana papardi-nyanurlu Ruupunurlu purda-nyangu wuruly-wangkanja-kurra kujalpalurla japirdija Jajupuku, puta-jana wangkaja wurra-waja. Ngula-jana wangkaja, “Murnma, kulalparlipa pungkarla nyanunguju! ");
INSERT INTO wbp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Yampiyalu, pakarninja-wangurlu! Ngayili kijika-puka kaninjarra rdaku-kurra wankaru-juku nyampurla.” Kujanya-jana wangkaja Ruupunuju nyanungukupurdangka-patukuju. Kujanyalpa manngu-nyangu Ruupunurluju yungu wilypi-maninjarla yilyayarla rdaku-jangkaju manu yungu pina-yilyayarla jaji-nyanu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Kujalpalurla japirdija-juku, wangkajalpalu-nyanu jinta-kari jinta-kari. Jajupu kutu-jarrijalku nyanungukupurdangka-patu-kurra. Ngulalu puuly-mardarnu, yalyi-manulurla kujalpa jinajina-piya ngurrju-nyayirni mardarnu kujarla jaji-nyanurlu yungu. Ngula-jangka, maninjarla kujurnulu kaninjarra rdakungka ngapa-wangurla-yijala pardunarla. ");
INSERT INTO wbp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ngula-jangka, pirri-manulu, ngarnulpalu kuyu manu miyilki. Kujalpalu ngarnu, nyangulu-jana yapa wurnturu-kurra. Nyangulpalu-jana Yijimali-patu-piya yapa, ngulajulpalu wapanja-yanu jungarni jinta yirdiyirla kuja yanurra kirri nyampu-ngurlu Kiliyata-ngurlu nguru-kari-kirra Yijipi-kirra. Kawartawara-wati ngulaju yulypari kanunju yangka nyiyarningkijarra-kurlu yakujurla-kurlu. Jali-maninjakulpalu kanja-yanu yapa-patuku Yijipi-wardingki-patuku talakupurdarlu. Nyampuju yakuju-patu ngulaju jujuminyiminyi-piya-kurlu manu yangka-kurlu kuja kalalu-nyanu maparnu jara-piyarlu manu palya-piya-kurlu ngurrju-nyayirni-kirli. ");
INSERT INTO wbp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ngula-jangka wangkaja-jana Juurda nyanungukupurdangka-patukuju, “Kajilparlipa pungkarla ngalipakupurdangka, manu kajilparliparla yimirr-yungkarla ngalipakupalanguju jaji-nyanu, kulalparlipa mantarla nyiyarningkijarralku. ");
INSERT INTO wbp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kala kajilparlipa-jana yungkarla nyanunguju Yijimali-patu yapa-patuku, ngulaju kajikarlipa yampimi wankaru-juku pakarninja-wangurlu. Nyanunguku kirda-nyanuju ngulaju ngalipaku kirda-nyanu-yijala. Kala ngayirlipa-jana yinyi yapa-patuku nyampuku pinja-wangurlu.” Juurdakupurdangka-patujulurla ngungkurr-nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ngula yanulu wilypi-maninjaku yinya rdaku-jangkaku. Kala lawa. Nyurrujukulu yapa-patu-kari Mirdiyanu-wardingki-patu yanurnu, ngulalu nyangulku Jajupu, wilypi-manulu rdaku-ngurluju. Ngula-jangka yungulu-jana nyampuku Yijimali-patuku talakupurdarlu 20-pala wita pirli yaltirikipurdarlu. Ngula-jangka, Yijimali-paturlu yampijalu ngurra, yarnkajarralu wurnalku Jajupu-kurlu Yijipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ngakalku, Ruupunu yanu rdaku-kurraju, nyangu kaninjarra-kari. Ngula nyangu lawa Jajupu-wangulku rdakuju. Ngula-jangkaju, larra-pajurnu jurnarrpalku nyanungu-nyangu, yulajalkulpa. ");
INSERT INTO wbp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ngula pina-yanu, wangkaja-jana, “Waraa! Nyarrpara mayi yanu ngalipakupurdangkaju? Kula karna milya-pinyi nyarrpara yanu. Nyarrpa-jarri karna ngajuju?” ");
INSERT INTO wbp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Yalu-maninja-wangurlulu purda-nyangu jamulu. Yanu-pukalu pinjaku narnukutu, pungulu. Kangurnulu, manulu jinajina-piya Jajupu-kurlangu julyurl-yirrarnu yalyungka narnukutu-jangkarla. ");
INSERT INTO wbp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ngula kangulurla milki jaji-nyanuku, milki-yirrarnulurla. Wangkajalurla, “Nyampuju jinajina-piyarlipa palka-manu yurrkuyurrkurla. Nyampuju mayi nyuntu-nyangu kaja-puraji-kirlangu?” ");
INSERT INTO wbp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ngula Jakupurlu purda-nyangu, kuja wangkaja, “Waraa, nyarrparla! Nyampuju ngaju-nyangu kaja-kurlangu jinajina-piya. Mardalu pungu warnaparirli. Nyanungujulu ngarnulku, palija nyurru, pajurnulu muku yira-patu yira-patu.” ");
INSERT INTO wbp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ngula Jakupurlulku-nyanu jurnta larra-pungu jurnarrpaju, yulajalkulpa. Ngula pirri-manu walya-kurra. Nyimin-pungulpa-nyanu yulypulyparlu nyanungurlu. Ngulangka-jukulpa juntu-maninjarla yulaja tarnnga. ");
INSERT INTO wbp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ngula nyanungu-nyangu-patu yurntalu-nyanu kaja-nyanu parnkajarnili, mukulu pirri-manu warru nyanungu-wana. Yulajalpalu wungulku. Putalu wurdungu-maninjarla wardinyi-manu yungu ngantalpa wajawaja-mantarla kaja-nyanu kuja nganta palija. Jakupuju wajampa-nyayirni-jukulpa nyinaja, wangkaja-jana, “Yampiyajulu jinta yungurna yulamiyi tarnnga-juku kaja-ngurlu. Yungurna ngajulku palimirra ngakaju, manu ngaju-nyangu pirlirrpa yungu yani Jiyulu-kurra kuja kalu panu-kari pirlirrpa nguna nyurnu-patu-kurlangu. Ngulangkanya kapirna ngaju wurulypa-jarri yulanja-wangu.” Junga, ngula-warnuju Jakupuju nyinaja tarnnga-nyayirni wajampaju kaja-nyanu-ngurlu Jajupu-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kujalu kangu Mirdiyanu-wardingki-paturlu yapangku Jajupu Yijipi-kirra, ngulalurla yungu yarda yapa-kariki nyampuku yirdiki watikiji Putipuruku talakupurdarlu. Nyampu wati wirikilirla Jajupuju yungu, wati wiri kujalparla warrki-jarrija Kingiki Yijipi-wardingkiki. ");
INSERT INTO wbp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ngakalku, Juurda manu nyanungukupurdangka-patu yanulu ngurra-kari-kirra ngurrararla jurrkungka-juku Kananarla. Yalirlaju nyinaja wati-kirli yirdi-kirli Yiira-kurlu. Ngulajulpa Yiiraju ngurra wita-wardingki nyinaja. Ngurraju yirdiji ngulaju Yatulama. ");
INSERT INTO wbp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kujalpa yalirla Kananarla nyinaja Juurda, yalirliji nyangu kamina. Nyanungukupalangu-kurlangu yirdiji ngulaju Juuwa. Wati yaliji yupukarra-jarrija kamina yali-kirli. Ngula-jangkaju ngunaja-pala. ");
INSERT INTO wbp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ngakalku, yali kamina ngulaju juni-parnta-jarrija, manu karrmulypa-jarrija kurdu wirriya-kurlu. Juurdarlurla yirdiji yirrarnu wirriyakuju ngulaju Yuuru. ");
INSERT INTO wbp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ngula-jangkaju, ngakalku yarda karrmulypa-jarrija kurdu wirriya-kari-kirli. Ngulajurla yirdiji yirrarnu Yunana. ");
INSERT INTO wbp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ngulaja-jangkaju, ngakalku karrmulypa-jarrija yarda kurdu wirriya-kari-kirli. Ngulajurla yirdiji yirrarnu Jaalaya. Ngulajulpa Juurdaju ngurrangka nyinaja yirdingkaju Kijiparla nyampu-puruju. ");
INSERT INTO wbp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kuja Juurdaku kaja-nyanu kamparru-warnu Yuuru wiri-jarrija, Juurdarlurla milarnu kamina yungu maninjarla yupukarra-jarri. Ngulajulpa yirdiji Tamuru nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kala Yuurujulpa punku nyinaja. Kuja YAAWIYI-rli nyangu maju-kurra ngurrju-maninja-kurra, ngulaju tarnnga-kurra pungu. ");
INSERT INTO wbp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kuja YAAWIYI-rli palu-pungu Yuuru, nyanungukupalangujurla wangkaja Yuurukupurdangka kukurnu-nyanuku Yunanaku, “Ngunanjinka Tamuru-kurlu yungulpa kurdu mantarla. Yali kurdu ngulaju papardi-puraji-kirlangu-juku. Kujaju ngalipa-nyangu kuruwarri.” ");
INSERT INTO wbp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kulalpa Yunana ngampurrpa nyinaja kujaku. Wangkajarla nyanunguku kirda-nyanuku, “Kajilparna Tamuru-kurlu ngunakarla, kajilpa kurdu mardakarla, kulaju ngajuku nyina.” Ngula-jangkaju, yaninjarla nyinajalpa Tamuru-kurlu, kala kula ngunaja nyanungu-kurlu. Ngula-jangkanya, kula juni-parnta-jarrija, manu kularla kurdu mardarnu nyanunguku kali-nyanuku nyurnuku. ");
INSERT INTO wbp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","YAAWIYI-rli nyangu kulalpa Yunana ngunaja Tamuru-kurlu. Kujarlanya pungu Yunanarlangu. ");
INSERT INTO wbp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ngula-jangkaju, wangkaja-nyanu Juurda, “Kapi marda YAAWIYI-rli pinyi ngaju-nyangu kaja-nyanu purdangirli-warnu kuja-palangu pungu Yuuru manu Yunana.” Ngula-jangkaju, yanurla Tamuruku, manurla wangkaja, “Yanta pina nyuntukupalangu-kurlangu-kurra yuwarli-kirra manu nyinaya yalirla-juku nyanungu-kurlu. Kula-jana yupukarra-manta wati-kari. Ngaju-nyangu kaja-nyanu Jaalaya ngulaju wirriya jalanguju. Kapu wiri-jarri. Pardakarla nyanunguku. Kaji wiri-jarri, kapunparla yupukarra nyina.” Junga-juku, Tamuruju pina-yanu ngurra-kurra kirda-nyanu-kurra nyinanjakungarnti. ");
INSERT INTO wbp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","14","Ngula-jangka, Juurdajulpa nyinaja nyanungu-parnta-kurlu kali-nyanu-kurlu Juuwaku yurntalu-nyanu-kurlu ngulaju yulyurrpu panuku. Nyanungurra-nyangu kaja-nyanu Jaalaya, ngulaju wiri-jarrija manu wati-jarrija. Kala kularla Juurda wangkaja Jaalayaku yungu yaninjarla mantarla Tamuru yungu-pala yupukarrarla nyinayarla, lawa. Ngula-jangkaju, Juurdaju kali-puka-jarrija. Juurdalpa jangkayirla nyinaja jinta. Ngula-jangkaju yanu nyanungu-nyangu-kurlu marlpa-kurlu Yiira-kurlu ngurra yirdi-kirra ngulaju Timina-kurra kujalpalu-jana wati-paturlu mardarnu jiyipi-patu. Manurnulpalu-jana yumurru jiyipi-ngirli. Yiira, ngulajulpa nyinaja ngurra wita-wardingki Yatulama-wardingki. Yapa-karirli yaninjarla yimi-ngarrurnu yali karntaku Tamuruku kujalpa Juurda nyanunguku jurdalja-nyanu yanu Timina-kurra pajirninjaku nganta yumurruku nganta jiyipi-jangkaku nganta. Kuja Tamuru kali-puka-jarrija kamparru-wiyi, yali-jangka-jukulpa jinajinaju palkangkaju mardarnu kujalpalu kali-puka-paturlu mardarnu yalirla ngurrararla. Milya-pungulpa yali Juurda kularla kaja-nyanu Jaalaya yinyi nyanunguku kali-nyanu nganta. Kanunju-kariji-nyanu wangkaja, “Nyarrparna juni-parnta-jarri kurdukungarnti?” Ngula-jangka yali jinajina nyurru-warnu yalyi-manu, manu jalangu-warnurla jinajinarla yukaja. Ngula-jangkaju, yinngirriki-nyanu parnta-yirrarnu wita pijiji. Kulalu nganangku milya-pungkarla. Ngula-jangkaju, yaninjarla pirri-manu kiirti-wana ngurrangkaju yirdingka Yinayimirla. Yali kiirti, ngulajulpa yirdiyi-wana karrija kujalpa ngunaja yirdiyi Timina-kurra. Yalirla pirri-maninjarlalparla pardarnu Juurdaku kaji jingijingi yani. ");
INSERT INTO wbp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ngaka-karrikarrilki, Juurdaju jingijingilki yanu yali-wanaju kiirti-wana. Nyangu Tamuruju. Kula milya-pungu nyanungu-nyanguju yinngirriji ngulaju parnta-yirrarninja-warnu. Nyanungurlulpa-nyanu purda-nyangu, “Ngana nyampuju karnta? Kajirnarla tala yinyi, kapu marda ngaju-kurlu nguna.” ");
INSERT INTO wbp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Junga-juku, Juurdajurla yaninjarla wangkaja, “Yanirli yungurlu nguna!” Tamururlu japurnu, “Kajilparna ngunayarla nyuntu-kurlu, nyiya kapunpaju ngajukuju yinyi?” ");
INSERT INTO wbp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Juurdarlu yalu-manu nyanunguju, “Kajinpa ngaju-kurlu nguna, kapurnangku jinta kurdu-warnu narnukutu yilyamirni.” Ngula-jangkaju, Tamururla wangkaja, “Ngulaju ngula-juku. Kala nyiya-wiyinpaju yinyi jalangurlu narnukutu yilyanjakungarntirli?” ");
INSERT INTO wbp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juurdarlu payurnu, “Nyiyaku kanpa ngampurrpa nyina yungurnangku yinyi jalangurlu?” Yalu-manu nyanunguju, “Yungkaju waninja-kurlangu manu nyuntu-nyangu watiya jukati.” Junga-jukurla Juurdarlu yungu nyanungu-nyangu waninja-kurlangu manu jukati. Ngula-jangkaju, yaninjarla-pala ngunaja. Tamuruju juni-parnta-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ngula-jangka, Tamuruju ngurra-kurralku pina-yanu. Yalyi-manu pijiji yinngirri-ngirli, manu pina-yukaja jurrkungka jinajinarla kujalpa kamparru-wiyi mardarnu. Yangka jurrku kuja kalalu kali-pukarlu mardarnu. Yapangkujulpalu nyangu kujalpa kali-puka-juku nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juurdaju pina-yanu yangka-kurra jurrku-kurra ngurra-kurra kujalpalu-jana nyanungu-nyangurlu wati-paturlu mardarnu jiyipi-patu. Yungurla kurdu-warnu narnukutu nyanungu-nyanguku marlpaku Yiiraku, manurla wangkaja, “Kangka nyampu narnukutu, manurla yungka yaliki karntaku kuja-ka kiirti-wana nyina ngurrangka Yinayimirla. Pina mantaju waninja-kurlangu manu jukati nyanungu-ngurlu, manuju pina-kangkarni ngaju-kurra.” Junga-juku, Yiiraju yanu Yinayimi-kurra, manulparla warru nyangu nyanunguku. Kala kula palka-manu nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Payurnu-jana wati-patuju kujalpalu karrija yalirla, “Nyarrpara yangkaju karnta kuja kalarla nyinaja nyampurla kiirtirla, yangka kujalpa ngunaja wati-kirli talakungarnti?” Yalu-manulu, “Kula-ka ngana karntaju majuju kujangu-piya nyina nyampurlaju.” ");
INSERT INTO wbp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Junga-juku, Yiiraju pina-kangu kurdu-warnu narnukutu Juurda-kurra, manurla wangkaja, “Kularna palka-manu yangkaju karnta. Kuja kalu wati-patu nyina yalirla, wangkajajulu kula-ka maju karnta kuja-piya yalirla nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ngula-jangkaju, Juurdarla wangkaja, “Ngula-juku. Putanparla warrurnu yungunparla nyampu narnukutu yungkarla kujarnarla jangku-pungu. Kularla pina-yanta warrirninjakungarnti. Kajinpa pina-yani, kapulu-ngalpa manyu-pinyi ngalipaju.” ");
INSERT INTO wbp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kirntangi-patu-jangka, wati-patulurla yaninjarla wangkaja Juurdaku, “Wayinpa! Nyuntu-nyangu jurdalja-puraji Tamuruju, ngulaju juni-parnta. Watingka mardalpa warru ngunaja talakupurda.” Ngula-jangkaju, Juurdarla kulu-jarrija-nyayirni, manu-jana wangkaja, “Yaninjarlalu manta, manulu pinarni kangka nyampu-kurra! Yungurlipa tarnnga-kurra purra warlungka nyanunguju!” ");
INSERT INTO wbp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Junga-juku, yajarninjakulkulurla yanu. Warla-pajurnu-jana, manu-jana wangkaja, “Murnma. Yungurnarla yimi yilyami ngajuku jurdalja-nyanuku Juurdaku. Kangkalu nyampu waninja-kurlangu manu nyampu jukati, manulurla milki-yirraka nyanunguku. Payikalu kajilpa ngana-kurlangu nyampurra milya-pungkarla. Ngajujurna wati-kirli ngunaja kujalpa nyampurra mardarnu. Kuja-jangkanya karna ngajuju juni-parntaju nyina.” ");
INSERT INTO wbp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kujalurla yalirrarlu wati-paturlu milki-yirrarnu waninja-kurlangu manu jukati Juurdaku, kaaku-nyayirnirli milya-pungu nyanungu-nyangu. Wangkaja-jana wati-patukuju, “Ngajujurna maju, kala Tamuruju ngurrju. Kula-ngantarnarla yungkarla ngaju-nyangu kaja-nyanu Jaalaya nyanunguku kali-nyanu kujarnarla jangku-pungu nyurru-wiyi.” Ngula-jangkaju kangu Tamuru nyanungu-nyangu-kurra yuwarli-kirra, kula-pala ngunajalku, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kirntangi jika-pala-jangka, Tamurujulpa nyinaja karrmulypa-jarrinjakungarnti. Karnta-karilpa nyinaja nyanungu-kurlu. Milya-pungulpa kujalpa-palangu kurdu-jarra mardarnu kaninjarni miyalurla Tamuru-kurlangurla. Putalpa-palangu wilypi-manu yali-jarra kurdu-jarra. ");
INSERT INTO wbp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Yali-puruju palka-jarrinjakungarnti, rdaka-wiyi wilypi-pardija. Yali karntangku ngulaju jirrirdirli yalyuyalyurlu warurnu kurdu-kurlangu rdaka. Wangkajarla Tamuruku, “Nyampuju kurdu kamparru-warnu kapu palka-jarri.” ");
INSERT INTO wbp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kala yalirli kurduju-nyanu pina-yirrarnu wakuju kaninjarni Tamuru-kurlangurla miyalurla. Ngula-jangka, kurdu-karilki wilypi-pardija kamparruju. Ngula-jangkaju, karntajurla wangkaja, “Waraa! Kamparrunpa wilypi-pardija nyuntukupurdangkakuju.” Ngulajulurla yirdi yirrarnu Piiriji. Yaliji yirdiji ngulaju nganta ‘Wilypi-pardija Kamparru’. ");
INSERT INTO wbp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ngula-jangkaju, kurdu-karilki palka-jarrija yangka kujalpa yalyuyalyu jirrirdi mardarnu waku-wana. Ngulajulurla yirdiji yirrarnu Jiira. ");
INSERT INTO wbp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nyurru-wiyi, kujalu-jana Jajupukupurdangka-paturlu yungu Jajupu Yijimali-patuku talakupurdarlu, ngulajulu kangu Yijipi-kirra. Jali-manulu wati wiri-kirra yirdi-kirraju Putipuru-kurra. Putipuruju kalarla warrki-jarrija yurrkunyu-piya yangka Kingiki Yijipi-wardingkiki. Kala-jana wiri nyinajayi warrkini-watiki yangka kuja kalalu warrki-jarrija kingi-kirlangurla yuwarlirla. Yinya warrkini-patu ngulaju yurrkunyu-piya-wati. ");
INSERT INTO wbp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Jajupu kala nyinaja manu warrki-jarrija Putipuru-kurlangurla yuwarlirla yangka wati Yijipi-wardingki-kirlangurla. Yinya-puruju, YAAWIYI Kaatulpa palka nyinaja Jajupu-kurlu, warrawarra-kangulpa. Kuja-puruju, Jajupurlulpa mardarnu nyiyarningkijarra, manu nyinajalpa ngurrju. ");
INSERT INTO wbp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Putipururlu nyangu Jajupu ngulalparla ngurrju warrki-jarrija. Putipururluju milya-pungu YAAWIYI Kaatu kujalpa nyinaja Jajupu-kurlu manu kujalparla jirrnganja warrki-jarrija nyanunguku. ");
INSERT INTO wbp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Putipurujulparla wardinyi-nyayirni nyinaja Jajupukuju. Wangkajarla, “Jajupu, nyuntujunpa warrkini ngurrju-nyayirni. Nyuntulu-mipa kapunpaju ngajuju warrawarra-kanyi. Ngaju karnangku wiri yirrarni nyuntu ngaju-nyangu yuwarliki manu ngaju-nyangu warlaljaku manu ngaju-nyangu warrkini-patuku. Jalangurlu-juku kanpa warrawarra-kanyi nyiyarningkijarra kuja karna ngajulurlu mardarni.” ");
INSERT INTO wbp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ngula-jangka, Jajupurlulpa warrawarra-kangu Putipuru-kurlangu warlalja manu nyiyarningkijarra kujalpa Putipururlu mardarnu. YAAWIYI kujalparla jirrnganja nyinaja Jajupuku, kujarlanya Putipuru-kurlangu warlaljarlulpalu-nyanu manu warrarda nyiyarningkijarra. Manu yinyarla ngurungka Putipuru-kurlangurla, YAAWIYI Kaatukulparla nyiyarningkijarra marlaja pardija miyi panu-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Yuwayi, Putipururlu wiri yirrarnu Jajupu nyiyarningkijarraku kujalpa nyanungurlu mardarnu. Kulalpa Putipuru wajampa-jarrija nyiyarlanguku. Ngarilpa manngu-nyangu miyi nyiyarningkijarra ngarninjaku. Jajupulpa nyinaja pirrjirdi manu yuntardi-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Putipuru-parntarlu kala warrarda nyangu manu manngu-nyangu nyanunguju. Parra jintangkarla wangkaja Jajupuku, “Jajupu, yantarni manu ngunaya ngaju-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Jajupurlu wurra-manu, manu wangkajarla, “Lawa, kularna nguna nyuntu-kurluju! Nyuntu-parntaju ngaju-nyangu paaju. Ngajukuju yungu nyiyarningkijarra kuja-ka nyanungurlu mardarni yungurna ngajulurlu warrawarra-kanyi. ");
INSERT INTO wbp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ngajujurna-jana wiri warrkini-watiki. Kula kaju ngana jinta-kari warrkini wiri nyina ngajuku. Nyuntu-parnturluju ngajuku yungu nyiyarningkijarra. Kulaju nyiya jurnta mardarnu. Nyuntujunpa nyanungu-parnta. Nyuntu-mipa kulaju yungu ngajukuju. Kajilparna ngunayarla nyuntu-kurlu, kajikarnarla majungka-jarrimi jurnta Kaatuku.” ");
INSERT INTO wbp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","11","Parra-kari parra-kari kala yanu Jajupuju Putipuru-kurlangu-kurra yuwarli-kirra warrki-jarrinjaku. Putipuru-parntarlu kala warrarda payurnu Jajupu nyanungu-kurlu ngunanjaku. Kala wurra-manu warrarda. Kula kala purda-nyangu, manu kula kala pirri-manu nyanungu-wana. Parra jintangka yanu Putipuru-kurlangu-kurra yuwarli-kirra warrkiki. Warrki-jarrijalpa nyanungu jinta. Kulalpa ngana wati-kari nyinaja yuwarlirla nyanungu-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ngula-jangka, Putipuru-parnta yanurnu, manu puuly-mardarnu Jajupu-kurlangu jaati. Nyanungurlu yarda japurnu, “Ngunamilki mayi kanpa ngaju-kurlu?” Jajupu wurnturu-jarrija nyanungu-kujakuju, manu jaatijirla jurnta larra-yanulku. Nyanunguju Jajupu wuruly-parnkajalku karnta-kujakuju yuwarli-ngirliji. Karntangkujulpa mardarnu-juku jaatiji. ");
INSERT INTO wbp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","15","Kuja Jajupurlu jaati yampinja-yanu purdangirli manu parnkaja yuwarli-ngirli, karntaju-jana purlaja kilji-nyayirni wati warrkini-patu-kariki kujalpalu karrija yarlungka yuwarlirla. Yanurnulu kaninjarni, manu wangkaja-jana nyanungurraku, “Nyangkalu nyampu jaati! Nyampuju yangka Yipuru-kurlangu wati-kirlangu kuja ngaju-parntarlu kangurnu nyampu-kurra. Marda ngari kangurnu nyampu-kurra yungu-ngalpa kurnta-mani ngalipa. Yinya wati warrkini yanurnu nyampu-kurra, manu jinyijinyi-manu ngaju yungu ngantarna ngunayarla nyanungu-kurlu. Ngajujurna purlaja manu wajirli-pungurna. Lani-jarrinjarla parnkaja, yampinja-yanu jaati purdangirli. Nyampunya!” ");
INSERT INTO wbp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ngulalpa karntangkuju mardarnu jaatiji, manulparla pardarnu nyanungu-parntaku ngurra-kurra yaninjarniki. ");
INSERT INTO wbp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kuja yanurnu ngurra-kurra, nyanungurlu yimi-ngarrurnu yimi jurrku-juku kuja-jana yimi-ngarrurnu warrkini-patuku. Wangkajarla nyanungu-parntakuju, “Yangka Yipuru warrkini Jajupu, kujanpa kangurnu nyampu-kurra warrkiki, nyanunguju yanurnu kaninjarni yuwarli-kirra jalangu, puta kurnta-manuju. ");
INSERT INTO wbp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Yanurnu kutu ngaju-kurra marnpirninjaku ngajuku, kala purlajarna kilji, manurna wajirli-pungu. Nyanunguju parnkaja yuwarli-ngirli, yampinja-yanu jaati nyanungu-nyangu. Nyampunya!” ");
INSERT INTO wbp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kuja Jajupu-kurlangu paajurlu yinya wati Putipururlu purda-nyangu kuja-kurra, nyanunguju kulu-jarrija-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Wangkaja-jana yurrkunyu-watiki puuly-mardarninjaku Jajupuku yungulu kijirni rdaku-kurra. Yinyarlanya kalalpa-jana yirrarnu yapaju kujalparla kulu-jarrija kingiki. Ngulalu yanu yurrkunyu-patu, manulu puuly-mardarnu Jajupu, manulu yirrarnu rdakungka. Nyinajalpa tarnnga rdakungka. ");
INSERT INTO wbp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","YAAWIYI-lpa palka nyinaja Jajupu-kurlu rdakungka, manulparla yimiri-juku nyinaja. Kala-jana jinta yurrkunyu nyinaja wiri yurrkunyu panu-kariki yangka kuja kalalu-jana warrawarra-kangu wurulypa parnkanja-kujaku. YAAWIYI-puru kalarla yinya yurrkunyu wiri yulkaja Jajupuku. ");
INSERT INTO wbp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Nyanungurluju milarnu Jajupu yungu-jana warrawarra-kanyi panu-kari pirijina-patu. Kuja yinya yurrkunyu wiri wangkaja Jajupuku, Jajupurlulpa-jana warrawarra-kangu rdakungkaju. ");
INSERT INTO wbp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yuwayi, YAAWIYI-lpa palka-juku nyinaja Jajupu-kurlu. Kujalpa-jana panu-kari warrawarra-kangu, kuja-jangkaju kulalpa wajampa nyinaja yinyaju yurrkunyukungarduyu wiri nyiyarlanguku. Yangka kujalpa Jajupu nyinaja rdakungka, YAAWIYI-rlilparla yungu nyiyarningkijarra ngurrju nyinanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Ngaka-pardu-kari, yangka Yijipi-wardingki kingi-palangu kulu-jarrija nyanungu-nyangu warrkini-jarraku nyiya-jangka mayi. Jinta-kari warrkinirli kalarla pama kangurnu ngarninjaku. Manu jinta-kari watingki kalarla miyi purranjarla kangurnu nyanungukuju. Warrkiji kujanya nyanungu-jarrakuju. ");
INSERT INTO wbp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kuja-palangu kingi kulu-jarrija nyanungu-nyangu warrkini-jarraku, yirrarnu-palangu rdakungka, yangka rdaku kujalpa Jajupu nyinaja. Nyanungurla wangkaja yurrkunyukungarduyuku wiriki yungu-palangu mardarni kaninjarni yulyurrpu-patuku. ");
INSERT INTO wbp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ngularla wangkaja yurrkunyukungarduyu wiri Jajupuku, “Muurlparlu-palangu mardaka nyampu wati-jarra.” Junga-juku, Jajupurlulpa-palangu warrawarra-kangu tarnngangku-juku. ");
INSERT INTO wbp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Munga jintangka, kujalpalu jarda ngunaja rdakungka, yinya-jarrarlu-pala jukurr-manu, yangka kuja kalarla kangurnu pama kingiki manu yangka kuja kalarla miyi purranjarla kangurnu. Jirramarlu-juku-pala jukurr-manu jukurrpa-jarra. ");
INSERT INTO wbp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mungalyurru, Jajupu-palangu yanurnu nyanungu-jarraku. Nyangu-palangu mularrpa-nyayirni. Nyiyaku mayilpa-pala nyinaja mularrpaju. ");
INSERT INTO wbp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Junga-juku, Jajupurlu-palangu japurnu nyanungu-jarraju, “Nyiya-jangka kanpala nyina mularrpa-nyayirni jalanguju?” ");
INSERT INTO wbp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wati-jarrarlu-pala yalu-manu, “Jirramarlurlujarra jukurr-manu jukurrpa-jarra mungangkarlu. Nyangurlujarra nyiya mayi. Kula karlijarra milya-pinyi nyiya kujarlijarra nyangu. Nganangku-wiyi-jarrangku yirri-pura nyampuju jukurrpa-jarra?” Jajupu-palangu wangkaja wati-jarraku, “Kaatu-miparlu kajikangkupala yirri-pura yangka kujanpala jukurr-manu. Ngariji-pala wangkaya nyarrpa kujanpala jukurr-manu.” ");
INSERT INTO wbp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Junga-juku, wati jintarla wangkaja yangka kuja kalarla pama kangurnu kingiki, wangkajarla Jajupuku, “Ngaju-nyangu jukurrparla nyangurna marnikiji-piya pardinja-kurra walya-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Marnkurrpa marnikiji-piya watiyalpalu pardija. Watiya-wiyi palka-jarrija, manu jinjirlalku. Nyangulparna pardinja-kurra, ngulalu marnakiji-piya palka-jarrija manu yirnmi-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Manurna-jana marnikiji-piyaju, manu kurn-mardarnurna-jana kartaku-kurra. Manurnarla kangu yarlkurrngu kingiki ngarninjaku. Kujanyarna nyangu jukurrparluju. Nyiya kujaju?” ");
INSERT INTO wbp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ngularla Jajupu wangkaja nyanunguku, “Ngajulu kapurnangku yimi-ngarrirni nyunturlu kujanpa nyangu. Yinya watiya marnkurrpa kujanpa-jana nyangu pardinja-kurra, ngulaju parra marnkurrpa. ");
INSERT INTO wbp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Jukurra-pardu-kari-wana kapungku kingirli mani pina nyampu-ngurlu rdaku-ngurlu yungunparla warrki-jarrimi nyanunguku. Nyunturlu kalanparla pama yungu yangka kamparru-wiyi rdakukungarntirli. Ngula-piya-yijala kapunparla yinyi pamaju. ");
INSERT INTO wbp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kajinpa wilypi-pardimi rdaku-ngurlu, kulaju ngajuju wajawaja-manta. Ngampangampaju nyinaya ngajukuju, manu yimi-ngarrika kingiki ngajuku marda yunguju wilypi-mani pina rdaku-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nyurru-wiyi, yapa-paturlujulu ngajuju kangurnu nyampu-kurra Yijipi-kirra ngaju-nyangu nguru-ngurlu yangka kuja kalu Yipuru-patu nyina. Kularnarla nyarrpa-jarrija majukungarntiji kingikiji.” Kujanyarla Jajupuju wangkaja watikiji. ");
INSERT INTO wbp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Yinya wati jinta-kari, yangka kuja kalarla mangarri purraja kingiki, ngulaju purda-nyangu yimi ngurrju kujarla Jajupu wangkaja wati jinta-kariki. Manurla wangkaja Jajupuku, “Ngajurlangurlurna jukurr-manu mungangkarlu. Ngaju-nyangu jukurrparla ngulajulparna karrija marnkurrpa-pala-kurlu parraja-kurlu jurrungka-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Parraja-paturlajulpalu ngunaja miyi nyiyarningkijarra kujarnarla purraja kingiki. Jurlpungkulpalu ngarnu muku kujalpalu ngunaja parraja-paturla. Nyiya kujaju?” ");
INSERT INTO wbp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jajupurla wangkaja nyanungurlu, “Kapurnangku yimi-ngarrirni nyarrpa kuja-ka jukurrpaju wangka. Yinya marnkurrpa-pala parraja kujalpanpa-jana mardarnu jurrungka, ngulaju marnkurrpa parra. ");
INSERT INTO wbp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Jukurra-pardu-kari-wana kapungku kingirli jurru muruly-pakarni! Kapungku waraly-yirrarni watiyarla palkaju, manu kapungkulu jurlpungku ngarni muku!” Kujanyarla Jajupuju wangkaja wati jinta-karikiji. ");
INSERT INTO wbp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","22","Yangka yimi kuja-palangu yimi-ngarrurnu Jajupurlu wati-jarraku, ngulaju junga. Marnkurrpa parra-jangka, kingi-jana wangkaja nyanungu-nyangu warrkini-patuku manu yurrkunyu-patuku yungulu yanirni miyi wiri-jarlu kurapaka ngarninjaku. Yanurnulu yangka yungulu manngu-nyanyi kuja kingi palka-jarrija. Yangka kujalpalu ngarnu, kingirlirla yilyaja yurrkunyukungarduyu wiriki yungu-palangu warrkini wati-jarra wilypi-mani rdaku-ngurlu, yangka kuja kalarla kangurnu pama nyanunguku manu jinta-kari kuja kalarla miyi purranjarla yungu. Kuja-pala wati-jarra yanurnu nyanungu-kurra, wangkajarla kamparru-warnuku, “Yuwayi, warrki-jarri pina kanpaju pama yungunpaju pina-yinyi ngarninjaku.” Junga-juku, wati yinyarlulparla kangurnu pamaju. Kala kingirla wangkaja wati jinta-kariki, “Kapurnangku nyuntuju tarnnga-kurra pinyi.” Junga-juku muruly-pajurnu jurru, manu waraly-yirrarnu palkaju watiyarla. ");
INSERT INTO wbp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yinya kamparru-warnu wati, yangka kujarla pama kangurnu kingiki, ngulajurla wajawaja-jarrija Jajupuku, ngulalpa nyinaja rdakungka. Kularla wangkaja kingiki nyanungu-kurlu marda yungu wilypi-mantarla rdaku-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Jajupujulpa nyinaja rdakungka yulyurrpuku jirramaku. Ngula-jangka, kingirli Yijipi-wardingkirli jukurr-manu. Nyampunya jukurrparlaju nyangu: Nyangu-nyanu kujalpa ngapa-wana karrija karru wiringka yirdi Niilingka ");
INSERT INTO wbp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nyangu-jana wirlki-pala puluku-wati ngurrju-nyayirni-wati karrinja-kurra ngapangka. Wiriwiri-nyayirni ngurrju-wati. Yinya puluku-patu yanurnulu ngapa-jangka, manulpalu ngarnu marna. ");
INSERT INTO wbp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ngula nyangu-jana yarda jukurrparlu wirlki-pala puluku yinya ngapangka, yarnma-wati-nyayirni, kula ngurrju. Yanurnulu ngapa-jangka, manulpalu kutu karrija yangka wiriwiri-wana puluku-wati-wana karru wiringkaju. ");
INSERT INTO wbp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ngulalu-jana yarnma-watirli muku ngarnu puluku wiriwiriji. Ngula-jangka Kingiji yakarra-pardija. ");
INSERT INTO wbp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Munga jintangka-juku yarda jukurr-manu jinta-karilki. Yinya jukurrparla ngulaju nyangu watiya yuparli-piya pardinja-kurra. Wirlki-pala yuparlilpalu pardija wiriwiri-nyayirni jintangka watiyarla, ngurrju-nyayirni-wati. ");
INSERT INTO wbp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ngula jinta-karilki pardija watiya yinya kamparru-warnu-wana-juku. Wirlki-pala-kurlu yuparli-kirli. Warlpa warlu-nyayirni wangkajarni kakarrara-ngurlu, ngula-jana jankaja muku. Linji-jarrijalu muku yuparli-piya-watiji. ");
INSERT INTO wbp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Yinya linji-wati yuparli wirlki-palarlu, ngulajulu-jana muku ngarnu ngurrju-wati yuparli. Ngula kingiji yakarra-pardijalku. Wangkaja-nyanu, “Waraa! Kula-ngantarna-jana nyangu yuparli-wati, kala ngarirna jukurr-manu!” ");
INSERT INTO wbp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mungalyurrulku, kingijilpa nyinaja wajampa-nyayirni kuja jukurr-manu. Ngula-jana yimi yilyaja wati pina-patuku manu ngangkayi-kirli-watiki yungulu nyanungu nyanjanjinirni. Kujalu yanurnu, nyanungurlu-jana yimi-ngarrurnu nyiyarningkijarra kuja-palangu jukurrparlu nyangu. Payurnu-jana, “Nyiyakurna nyampu jukurrpa-jarra jukurr-manu? Nyarrpaku?” Kularla nganangku jungarni-maninjarla yimi-ngarrurnu kingikiji. ");
INSERT INTO wbp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ngula-jangkaju, wati warrkini jinta yanurnu kingi-kirra, yangka kujarla pama kangurnu, yangka kujalpa rdakungka nyinaja Jajupu-kurlu, wangkajarla kingiki, “Ngajuju punku. Yungurnangku yimi-ngarrikarla kamparrurlu-juku, kala lawa. ");
INSERT INTO wbp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Manngu-nyanyi kanpa yangka kujanpa-jarrangku kulu-jarrija ngajuku manu warrkini jinta-kariki, yangka kuja kalangku miyi purraja? Nyuntunpa-jarrangku kulu-jarrinjarla rdakungka yirrarnu. Yinyarlu yurrkunyukungarduyurlu wiringki-jarrangku mardarnu yinyarlaju. ");
INSERT INTO wbp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Munga jintangka, jarnku-jukurr-manurlijarra. Ngaju-nyangu jukurrparla, ngulajurna-jana nyangu marnikiji-piya-wati pardinja-kurra. Yinya jinta-karirli ngulaju nyangu miyi-wati yakujurla. Kularlijarra milya-pungu yinya jukurrpa-jarra. ");
INSERT INTO wbp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ngula-puruju watilpa jinta Yipuru nyinaja rdakungka nganimpa-kurlu. Yangka kujalparla Putipuruku warrki-jarrija yangka yurrkunyukungarduyu wiriki. Yimi-ngarrurnurlijarrarla ngajarra-nyangu jukurrpa-jarra, ngula-jangkarlu-jarrangku jungarni-maninjarla yimi-ngarrurnu. ");
INSERT INTO wbp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Nyiyarningkijarra kuja-jarrangku yimi-ngarrurnu, ngulaju junga-nyayirni. Nyunturlunpaju wilypi-manu rdaku-ngurlu yungurnangku pina warrki-jarri nyuntuku, yungurnangku pama kanyirni warrarda. Yinya wati jinta-kari, kuja kalangku miyi purranjarla yungu, ngulajunpa pungu. Kuja-piya-yijala-jarrangku kamparru-wiyi wangkaja yinya wati Yipuru. Marda kajikangku nyanungurlu yimi-ngarrirni nyarrpa kuja-ka wangka jukurrpa nyuntu-nyangu.” ");
INSERT INTO wbp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ngula-jana kingi warrkini-watiki wangkaja maninjaku Jajupu rdaku-ngurlu. Kapankurlulu manunjunu nyanunguju. Kingi nyanjakungarntirli, Jajupurlu-nyanu jangarnngka pajurnu manu jurru, manu yukaja kirlkangka jurnarrparla. Ngula yukajarralku yuwarli wiri-kirra kujalpa kingi nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kingirla wangkaja nyanunguku, “Mungangka, ngajulurlurna jirrama jukurr-manu, kulaju nganangku jungarni-maninjarla yimi-ngarrurnu. Purda-nyangurnangku nyuntu-kurlu. Kuja kangkulu yimi-ngarrirni yapangku nyanungurra-nyangu jukurrpa, ngulaju kanpa-jana jungarni-maninjarla yimi-ngarrirni nganta. Junga mayi kujaju?” ");
INSERT INTO wbp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jajupurlu yalu-manu nyanunguju, “Ngajulurlu kulalparnangku yimi-ngarrikarla jukurrpaju, kala Kaaturlu kapungku yimi-ngarrirni yungunpa wardinyi-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ngularla kingiji wangkaja Jajupukuju, “Yuwayi, nyampunyarna jukurrparlaju nyangu: Ngaju-nyangu jukurrpaju, ngulajurnaju nyangu ngaju karrinja-kurra ngapa-wana karru wiringka Niilingka. ");
INSERT INTO wbp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ngularna-jana nyangu wirlki-pala puluku-wati karrinja-kurra ngapangka. Wiriwiri-nyayirni-wati ngurrju-wati. Yinya puluku-patu yanurnulu ngapa-jangka, manulpalu marna ngarnu. ");
INSERT INTO wbp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ngularna-jana yarda nyangu wirlki-pala puluku karrinja-kurra ngapangka. Yinyaju ngulaju yarnma-wati punku-wati-nyayirni. Kularna-jana nyangu puluku punku-wati nyampurra-piya-wati nyampurla Yijipirla. ");
INSERT INTO wbp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Yinya wirlki-pala puluku yarnma-wati, ngapa-ngurlulu yanurnu, manu muku ngarnulu-jana puluku wiriwiri. ");
INSERT INTO wbp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ngajulurna manngu-nyangu yinya yarnma-wati puluku kula-nganta kapulu wiri-jarriyarla ngarninja-warnuju, kala lawa. Yarnma-jukulpalu nyinaja yangka kamparru-wiyi kujalpalu yarnma karrija ngapangka. Ngula-jangkarna yakarra-pardija. ");
INSERT INTO wbp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mungangka jintangka-jukurna warnpa-jarrija, manurna yarda jukurr-manu. Yinyarla jukurrparla, ngulajurna nyangu yuparli-kirlangu watiya pardinja-kurra. Yinyarla watiyarla, ngulajulu pardija wirlki-pala yuparli wiriwiri-nyayirni watiya jintangka ngurrju-wati. ");
INSERT INTO wbp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ngula jinta-kari watiya yuparli-piya pardija kutu-juku kamparru-warnukuju. Wirlki-pala-kurlu-yijala yuparli-kirli. Nyampurraju ngulaju-jana warlpa warlungku jankaja muku kakarrara-ngurlurlu. Linji-jarrijalu muku punku-wati. ");
INSERT INTO wbp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ngula-jangka, yinya wirlki-pala linji yuparlirlili-jana ngarnu muku yangka ngurrju-wati yuparli. Ngula-jangkarna yakarra-pardijalku. Mungalyurrurlurna-jana yimi-ngarrurnu ngaju-nyangu ngangkayi-kirli-watiki jukurrpa. Kulajulu nyarrparlu jungarni-maninjarla yimi-ngarrikarla.” ");
INSERT INTO wbp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ngularla Jajupu wangkaja kingiki, “Yinya puluku-wati manu yuparli-wati kujanpa-jana nyangu jukurrparlu, ngulaju yangka yimi kuja kangku Kaaturlu yinyi nyuntuku. Nyanungurlu kangku yimi-ngarrirni nyarrpa-jarri kaji nguru nyampuku. ");
INSERT INTO wbp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","31","Yuwayi, junga nyampuju! Yangka wirlki-pala wiriwiri puluku manu yuparli wiriwiri kujanpa-jana jukurr-manu, ngulaju wirlki-pala yulyurrpuku Kaaturlu kapungku yinyi panu-nyayirni ngurlu. Ngula-puru, yapangku kapulu jayakurra ngarni ngurluju Yijipirlaju. Kala yinya wirlki-pala yarnma-wati puluku manu wirlki-pala linji yuparli kujanpa jukurr-manu yangka kuja-jana warlpangku luwarnu manu jankaja, ngulaju wirlki-pala yulyurrpuku Kaaturlu kula pardinjaku ngurrju-mani ngurluju. Yapangku kulalu nyiya ngarni nguru-kari nguru-kari, manu kapulu kujanya wangkami, ‘Mangarri-wangulku kapurlipa nyina nyampurla nguru punkungka! Kapurlipa yarnunjuku muku palimi!’ Yuwayi, punku-nyayirni kapu karri nyiyarningkijarra wirlki-pala yulyurrpuku. ");
INSERT INTO wbp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kulanpa jukurr-manu jintaku, nyuntulurlunpa jukurr-manu jirramaku. Kujaju kapu nyampu yimi jukurrpa-jangka junga-jarri. Kaaturlu manngu-nyangu nyampuju ngurlu-kurlu. Ngaka-pardu-kari kapu-nyarra Yijipi-wardingki-patuku yinyi jayakurra ngurlu wirlki-pala yulyurrpuku. Ngula-jangkaju kula pardimilki nyiyarlangu miyi wirlki-palaku-yijala.” ");
INSERT INTO wbp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ngula-jangka, Jajupurla wangkaja kingiki, “Purda-nyangkaju ngaju! Jinta wati manta pina-nyayirni yungu-jana wiri nyina yapa panuku nguru nyampurla. Kapu nyanungurlu milya-pinyi muku yirrarninjaku ngurlu-wati yangka wirlki-pala yulyurrpuku kajili ngurlu pardimi. ");
INSERT INTO wbp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Manta-jana panu-kari wati-patu yungulu-jana wiri-yijala nyina ngurra-kari ngurra-kariki nyampu ngurungka. Wangkaya-jana yinya wiri-watiki yungulu muku mani ngurlu yapa-kurlangu yangka wirlki-pala yulyurrpu-puru kajili ngurlu pardimi. Kulalpa-jana panu jurnta kangkarla, ngari wita-mipa. Kajilpalu mardakarla rdaka-palarla ngurlu yakujurla, jinta-mipa-jana puntaka. Ngurlu-jana kujangunya jurnta manta. ");
INSERT INTO wbp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Yangka ngurlu-wati kajili-jana puntarni yapaku wiri-watirli yangka wirlki-pala yulyurrpu-puru, wangkayalu-jana yungulu muku yirrarni yuwarli wiriwirirla. Wangkaya-jana yungulu warrawarra-kanyi purunju-kujaku yangka wirlki-pala yulyurrpuku yangka kaji yapa lawa nyinami miyi pardinja-wangu. ");
INSERT INTO wbp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yangka kuja-puru ngaka kaji ngurlu pardinja-wangu karri nyampurla Yijipirla, wiri-watirli yungulu-jana wita-kari wita-kari ngurluju yinyi yapakuju yungulu nyina yarnunjuku-wangu.” Kujanyarla Jajupuju wangkaja kingikiji. ");
INSERT INTO wbp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ngularla Jajupurlu yimi-ngarrurnu kingiki jukurrpa manu ngurlu, kingi manu warrkini-patulurla ngungkurr-nyinaja Jajupuku. ");
INSERT INTO wbp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ngula-jangka, kingi-jana wangkaja nyanungu-nyangu warrkini-patuku, “Ngana kula-ka ngurrju nyina wati nyampu-piya Jajupu-piya! Kaatu-kurlangu Pirlirrpa-ka mardarni!” ");
INSERT INTO wbp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ngularla kingiji wangkaja Jajupuku, “Kaaturlungku yimi-ngarrurnu nyiyarningkijarra ngurrju manu punku kaji-ngalpa nyarrpa-jarri ngaka. Kujakuju nyuntujunpa pina-nyayirni yapa panu-kari-piya-wangu. ");
INSERT INTO wbp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","41","Jalangurlu ngajulurlu karnangku nyuntuju wiri yirrarni yapa panuku nguru nyampurla. Ngaju-mipa kapurnangku wiriji nyina nyuntukuju. Panungku kajulu purda-nyanyi ngaju nyarrparlu kajirna-jana yimi-ngarrirni. Kuja-piya-yijala kapungkulu nyuntuju purda-nyanyi.” Kujanyarla kingiji wangkaja Jajupukuju. ");
INSERT INTO wbp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kingirli yalyi-manu nyanungu-nyangu ringi rdaka-jangka. Yinyarla ringingka, ngulajulpa kingi-kirlangu pija ngunaja. Yalyi-maninjarla yirrarnurla Jajupu-kurlangu rdakangka, manurla yungu Jajupuku jurnarrpa ngurrju-wati yukanjaku, manurla yirrarnu kawurlu waninja-kurlangu waninjarla. ");
INSERT INTO wbp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","45","Ngularla kingi wangkaja Jajupuku, “Ngajurna kingi. Jalangu-jangka panungku yungungkulu purda-nyanyi nyuntu. Kapunpa warru yani ngurra-kari ngurra-kari-kirra nyampurla ngurungka Yijipirla. Nyuntu kapunpa-jana wangka panu yapaku nyiya yungulu-nyanu miyi wiri-mani manu yungulu-nyanu nyiyarlangu ngurrju-mani. Kaji nganangku-puka nyiyarlangu ngurrju-mani, manu kaji nyiyarlangu miyi wiri-mani, ngulakungarntirliji ngulaju yungungkulu nyuntu japirni. Kajili payirninja-wangu nyina nyuntuku, ngulaju kulalu nyiyarningkijarra ngurrju-mani. Yirdi jinta-kari karnangku yirrarni. Jalangu ngulaju nyuntu-nyangu yirdiji Japina-Paniya, manu karnangku karnta yinyi yirdiji Yajanaja yungungku nyuntuku kali-nyanu nyina. Nyanunguju Putipura-kurlangu yurntalu-nyanu kuja-ka maralypikingarduyu nyina yangka kirringka Yuunurla.” Ngula-jangka, kingirla wangkaja Jajupuku warrkarninjaku nantuwu-kurlangurla wirli-jarra-kurlu jinta-karirla nyanungu-nyangurlaku. Nyanungu-jana wangkaja wati-patuku yungulu kamparru wapanja-yani Jajupuku yangka kujalpa yaninja-yanu nantuwu-kurlangurla wirli-jarra-kurlurla. Kujalpalu wapanja-yanu yinya wati-patu, purlajalu-jana kuja yapa-patuku, “Parntarriyalu panu-juku!” Kuja-jangkaju, yapangkujulpalu milya-pungu Jajupuju wiri. ");
INSERT INTO wbp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Kujalpa kingirli wiri yirrarnu Jajupu yapaku Yijipirlaku, ngulakujurla Jajupukuju rdipija jalangu-warnuku-juku 30-pala yulyurrpu. Ngula-jangkaju, yampinja-yanu kingi-kirlangu yuwarli wiri, manu yanu warru ngurra-kari ngurra-kari-kirra Yijipirla. ");
INSERT INTO wbp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Jajupuju yanu warru ngurra-kari ngurra-kari-kirra wirlki-pala yulyurrpuku. Kuja-puruju, panu-jarlu-nyayirni ngurlu pardija nguru-kari nguru-kari. ");
INSERT INTO wbp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Jajupu manu nyanungu-nyangu warrkini-patulu yanu ngurra-kari ngurra-kari-kirra, manu warrulpalu ngurlu-wati yangka kujalu yapangku wiri-manu, maninjarla kangulpalu ngurluju yuwarli wiri-patu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kulalu witalku manu ngurluju yapa-patu-kurlanguju. Panu-nyayirnili manu ngurluju. Yuwarli-watiji panu-kurlu-nyayirnilpalu karrija ngurlu-kurlu. Kulalpa nganangku yapangku yirdiyirdi-mantarla ngurluju. ");
INSERT INTO wbp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kuja-puruju, Jajupu-parntarlu Yajanajarlu-palangu mardarnu wirriya wita-jarra. ");
INSERT INTO wbp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jajupurlu yirdi-manu wirriya wiriji Manaja, manurla wangkaja, “Kujarna nyampu-kurra yanurnu nguru-kurra, ngajurna-jana wajawaja-manu ngaju-nyangu kirdana manu ngaju-nyangu warlalja. Yijipi-wardingki-paturlujulu jinyijinyi-manu warrki-jarrinjaku. Ngulaju ngula-juku. Kaatujulpalu ngurrju nyinaja, manurna wardinyilki. Kuja-jangkanya karnangku yirdi-mani Manaja.” ");
INSERT INTO wbp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Jajupurlu kukurnu-nyanuju yirdi-manu Yipirayimi, manurla wangkaja, “Ngajulurlu kalarna jata-nyangu nyampu Yijipirla. Ngulaju ngula-juku. Kaaturluju yungu kurdu-jarra. Kuja-jangkanya karnangku yirdi-mani Yipirayimi.” ");
INSERT INTO wbp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Yangka wirlki-pala-jangka yulyurrpu-jangka kujalpa pardija ngurlu panu Yijipirla, ngula-jangkaju Kaaturluju warla-pajurnu miyi pardinja-kujaku yangka kuja Jajupu wangkaja kamparru-wiyi. Kula pardija ngurlu Yijipirlaju manu nguru-kari nguru-karirlangurlaju, lawa. Mangarri palka-jukulpa ngunaja ngarninjaku Yijipirla, yangka ngurlu-wati kujalu Jajupurlu manu warrkini-paturlu yirrarnu kamparrurlu-wiyi yuwarli wiri-paturla ngurlu-kurlangu-paturla. ");
INSERT INTO wbp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ngula-jangka yangka Yijipi-wardingki-patu yarnunjuku-jarrijalu muku miyiki. Ngulalu kingi yaninjarla japurnu, “Yungka-nganpa miyi ngarninjaku!” Nyanungu-jana wangkaja, “Japirninjintalu Jajupu miyikiji! Kapu-nyarra wangka kuja-ka nyarrpararla miyi nguna.” ");
INSERT INTO wbp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","57","Yuwayi, yapa panulpalu yanunjuku-jarrija Yijipirla. Miyi yinjakungarnti, Jajupurlu lakarn-manu-jana yuwarli-wati kujalu yirrarnu nyanungurlu manu warrkini-paturlu ngurlu-wati. Yapa-patu kalalu-jana yanurnu Jajupuku manu warrkini-patuku. Kalalu-jana tala yungu ngurlu payi-maninjaku. Yapa panulpalu yarnunjuku nyinaja miyiki, kula Yijipi-wardingki-patu-puka. Yapa panulpalu yanurnu nguru-kari nguru-kari-jangka Yijipi-kirra miyi maninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yinya purlkangku Jakupurlu purda-nyangu kujalpa miyi panu-jarlu ngunaja Yijipirla, manu-jana wangkaja nyanungu-nyangu kaja-nyanu-patuku, “Nyiyaku kankulu-nyanu nyinanjarla nyanyi? ");
INSERT INTO wbp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Purda-nyangurna miyi panu nganta-ka nguna Yijipirlaju. Yakarra-pardinjarla yantalu Yijipi-kirra ngurluku yungurlipa ngarninjarla wankaru nyina. Kajinkili nyina nyampurla yaninja-wangu, kapurlipa muku palimi.” ");
INSERT INTO wbp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Junga-juku, Jajupukupurdangka-patu karlarla-pala papardi-nyanu-patu yampinja-yanulu kirda-nyanu-kurlangu ngurraju, manu yanulu Yijipi-kirra miyiki. ");
INSERT INTO wbp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jakupurlu warla-pajurnu Jajupuku kukurnu-nyanu Pinyamini yaninja-kujaku nyanungurra-kurlu. Jakupulpa-nyanu wangkaja, “Kajilparna yilyayarla Pinyamini Yijipi-kirra, kajikalu marda pinyi. Mardarni karna nyampurla-juku.” ");
INSERT INTO wbp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Yapa panu-nyayirnilpalu yarnunjuku nyinaja Kananarla miyi-wangu. Junga-juku, panu-jarlu yapa-patulu yanu Yijipi-kirra Jakupu-kurlangu kaja-nyanu-wati-kirli. Nyanunguju ngurrangkalpa nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","9","Kujalu yapa yinya-patu yukajarra Yijipi-kirra, Jajupulpa-jana wiri nyinaja yapa panukuju yinyarlaju. Jali-manulpa-jana ngurlu. Jajupuku papardi-nyanu-patulurla yanurnu nyanunguku. Kulalu milya-pungu nyanunguju nyanungurrakupurdangka kukurnu. Parntarrijalurla nyanungukuju. Jajupurlu-jana milya-pungu, kula-jana yimi-ngarrurnu ngana nyanunguju. Manngu-nyangu yangka jukurrpa kuja jukurr-manu nyurru-wiyi kujalurla papardi-nyanu-patu manu ngati-nyanu manu kirda-nyanu parntarrija nyanunguku. Ngula-jana kulu wangkaja, “Nyarrpara-ngurlunkulu yanurnu?” Yalu-manulu, “Yanurnurnalu Kanana-ngurlu miyi maninjaku.” Jajupu-jana wangkaja, “Lawa, kula kujaju junga! Nyurrurlankulu ngari yanurnu yungunkulu-nganpa nyanyi marda pirrjirdi marda rampaku. Kajinkili-nganpa manngu-nyanyi nganimpa nganta rampaku, ngulaju kajikankulu-nganpa kululku jangkardu yanirni!” ");
INSERT INTO wbp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wangkajalurla Jajupuku, “Kula kujaju junga! Nyuntunpa-nganpa wiri nganimpaku. Ngarirnalu yanurnu miyi maninjaku nganimpa-nyangu warlaljaku. ");
INSERT INTO wbp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kirdana jinta-jangka nganimpaju. Kula karnangkulu warlka wangka! Kularnalu nyampu-kurraju yanurnu nyiyarningkijarra wuruly-nyanjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Jajupurlu-jana wurdungu-manu nyanungurraju, “Lawa, kula kujaju junga! Ngarinkili yanurnu nyampu-kurraju yungunkulu-nganpa nyanyi nganta nganimpaju marda pirrjirdi marda rampaku!” ");
INSERT INTO wbp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nyanungurralurla wangkaja, “Wangkami karnangkulu junga-nyayirni! Nganimpaju Kanana-wardingki, manu karnalu kirdana jinta-juku mardarni. Nganimpakupurdangka kukurnu-nyanu kula yanurnu nganimpa-kurlu. Nyinami-ka nganimpa-nyangu kirdana-kurlu, manu-ka palka nyina yinya-juku. Kalarnalu mardarnu kukurnu-nyanu-kari, kala nyurru-wiyi lawa-jarrija.” ");
INSERT INTO wbp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Jajupujulpa ngungkurr-nyinanja-wangu-juku karrija, wangkaja-jana, “Milya-pinyi karna-nyarra ngarinkili yanurnu nyanjaku nganimpaku Yijipi-wardingki-patu nganta pirrjirdi marda rampaku! ");
INSERT INTO wbp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","Ngulaju ngula-juku. Yungurna-nyarra wangka yungurna-nyarra milya-pinyi marda ngurrju marda punku. Ngajulu kapurna-nyarra yirrarni rdakungkalku. Jinta kapurna yilya pina ngurra-kurra yungu maninjini kukurnu-nyanu manu yungu pina-kanyirni nyampu-kurra. Kaji pina-kanyirni, kapurna-nyarra yilyamilki yungunkulu ngurra-kurralku pina-yani. Kala kaji pina-kanja-wangu nyinami-juku ngurrangka nyurrurla-nyangurla-juku, ngulaju kapurna-nyarra mardarni nyampurla-juku rdakungka tarnnga!” ");
INSERT INTO wbp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Junga-juku, Jajupurlu-jana yirrarnu rdakungka nyanungukupurdangka-patu. Nyinajalpalu parra jirramaku. ");
INSERT INTO wbp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mungalyurru-karilki Jajupu-jana wangkaja, “Ngaju karnarla nyinami jungarni Kaatuku. Kajinkijili purda-nyanyi ngaju, kularna-nyarra pinyi. ");
INSERT INTO wbp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Marda kankujulu junga wangka. Kajinkijili junga wangkami, ngulaju jinta-mipa kapu nyina rdakungkaju. Panu-kariji kapurna-nyarra pina-yilyami ngurra-kurra miyi-kirli yungunkulu-jana yinyi warlaja-watiki nyurrurla-nyanguku. ");
INSERT INTO wbp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ngula-jangkaju, kangkarnili nyurrurlaku kukurnu-nyanu ngaju-kurra. Kajinkili pina-kanyirni, kapurna-nyarra milya-pinyi kuja kankujulu junga wangkami. Kularna-nyarra pinyi.” Yinya karlarla-pala papardi-nyanu-patu, ngungkurr-nyinajalurla Jajupuku. ");
INSERT INTO wbp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kulalu milya-pungu paaju yinya kujalpalurla wangkaja ngulaju Jajupu. Ngulalu-nyanu wangkaja, “Kaaturlu kangalpa murrumurru-mani kujarlipa pungu ngalipakupurdangka Jajupu. Kujarlipa rdaku wiringka yirrarnu, warlkurnu-ngalpa yungurlipa wilypi-mantarla pakarninja-wangurlu. Kularlipa purda-nyangu. Ngula-jangkanya kangalpa jinyijinyi-mani nyampurlu watingki maninjaku Pinyaminiki.” ");
INSERT INTO wbp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ngula-jana Ruupunu wangkaja nyanungurraku, “Yangkarna-nyarra wangkaja pakarninja-wangurlipa yampiyarla Jajupuju! Kulankujulu purda-nyangu ngaju! Lawa, ngarinkili yirrarnu rdaku wiringkaju! Kuja-jangkanya kangalpa murrumurru-mani Kaaturluju!” ");
INSERT INTO wbp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yinya karlarla-pala papardi-paturlu manngu-nyangu kula-nganta Jajupuju ngurrpa-juku Yipuru yimikiji wangkanjaku. Yangka kuja kala-jana Jajupu wangkaja nyanungukupurdangka-patuku, kula kala-jana wangkaja yimi warlalja Yipuru. Kala-jana Yijipi-wardingki yimi wangkaja, manu wati jinta-kari kalarla marlaja wangkaja nyanunguku. Kala-jana purda-nyangu-juku Yipuru wangkanja-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ngula-jana purda-nyangu wangkanja-kurra, yampinja-yanu-jana. Yulajalku. Ngaka yanurnu pina, manu wangkaja-jana, “Yuwa, yantalu pina ngurra-kurra. Kapurna jinta mardarni rdakungka.” Jajupu-jana wangkaja warrkini-patuku nyanungu-nyanguku, ngulalu rdarri-mardarninjarla wayurnu Jimiyani. Mardarnulpalu yangka kujalu nyanungukupurdangka-paturlu nyangu. ");
INSERT INTO wbp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ngula-jangka, Jajupurlu-jana yampinja-yanu yinyarla-juku. Wangkanjunu-jana warrkini-watiki, “Mantalu-jana nyanungurra-nyangu yakuju-wati, manulu-jana panu-jarlu yirraka ngurlu-wati yakuju-watirlaju. Kujalu-nyarra tala yungu miyiki, ngulajulu-jana pina-yirraka yakuju-paturla. Nyiyarningkijarralu-jana yungka miyi-kari miyi-kari wurnakungarntikiji.” Jungajukulu warrkini-paturlu ngurlu yirrarnu yakuju-patu-kurra manu tala. ");
INSERT INTO wbp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ngula-jangka, yangka papardi-paturlulu yirrarnu yakuju-wati ngurlu-kurlu tangkiyi-watirla nyanungurra-nyangurla, manulu yanu nguru Kanana-kurra. Kulalu milya-pungu tala kujalpa ngunaja yakuju-watirla. ");
INSERT INTO wbp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Parra jintakulu yanu, manulu ngunaja kulkurru. Jinta-karirli lakarn-manu yakuju nyanungu-nyangu yungurla ngurlu yungkarla tangkiyiki ngarninjaku. Kuja lakarn-manu yakuju, palka-manu tala kankarlu ngurlungka. ");
INSERT INTO wbp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Wangkaja-jana nyanungukupurdangka-patuku, “Yuwa, nyampunya talaju kujarlipa payi-manu ngurlu! Nyampunya yakujurla ngaju-nyangurla!” Ngula-jangkalu Jajupukupurdangka-patuju lani-jarrija-nyayirni, manulu-nyanu purlaja, “Waraa! Nyarrpa-jarri kangalpa Kaatuju? Kapurlipa muku palimilki!” ");
INSERT INTO wbp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Yinya kartaku-pala papardi yanulu parra-patuku ngurlu-kurlu. Yukajarnili ngurra-kurra kirda-nyanu-kurlangu-kurra Kanana-kurra. Manulurla yimi-ngarrurnu nyiyarningkijarra. ");
INSERT INTO wbp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Wangkajalurla, “Kujarnalu yanu Yijipi-kirra, paajurlu-nganpa kulungku ngarrurnu. Nyanungu wangkaja-nganpa nganimpaku ngantarnalu yanu nyanjaku marda pirrjirdi kalu nyina marda rampaku. ");
INSERT INTO wbp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kalarnurnalurla wangkaja, ‘Lawa, lawa! Kula karnangkulu warlka wangka! Kularnalu yanurnu nyanjaku nyiyarningkijarraku.’ ");
INSERT INTO wbp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ngularnalurla wangkaja watiki wiriki, ‘Mardarni karnalu kirdana jinta. Mardarni kajana 11-palalku kaja-nyanuju. Karlarla-palarnalu yanurnu nyampu-kurra, manu jinta-ka nyina ngurrangka nyanungu-kurlu Kananarla. Jinta-karirlajurnalu papardi-puka-jarrija nyurru-wiyi.’ Kujanyarnalurla wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ngula-nganpa wiriji wangkaja, ‘Kajinkijili purda-nyanyi ngaju, ngulaju kapurna-nyarra milya-pinyi kuja kankujulu junga wangkami. Yanta pinalu ngurra-kurra miyi-kirli nyuntu-nyangu warlalja-kurra. Jintalu yampiyarra rdakungka. ");
INSERT INTO wbp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ngula-jangka, kangkarnili kukurnu-puraji nyampu-kurra Yijipi-kirra, manujulu milki-yirraka ngajuku. Ngula-jangka kapurna-nyarra milya-pinyi kuja kankujulu junga wangka. Manu kapurna-nyarra ngungkurr-nyina kulankulu yanurnu wuruly-nyanjaku nyiyarningkijarraku nyampurla ngurungka. Kajinkili kanyirni kukurnu-puraji, kapurna wilypi-mani jinta-kari rdaku-ngurlu. Ngula-jangka kapunkulu yani warru Yijipi-wanaju. Kula-nyarra nganangku-puka warla-pajirni manu murrumurru-mani.’ Kujanya-nganpa wiriji wangkaja.” ");
INSERT INTO wbp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ngula-jangka manulu yakuju-wati ngurlu-kurlu, manulu winjurnu walya-kurra. Kujalu ngurlu winjurnu, jinta-kari jinta-karirlili palka-manu talaju, yangka tala kujalurla yungu Yijipi-wardingki-patuku ngurluku. Nyanungurraku kirdanarlu Jakupurlu talaju nyangu-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Wangkaja-jana, “Waraa! Nyurrurlarlu kankujulu jurnta kanyi muku kurdukurdu ngajuku! Kamparrujurna kirda-puka-jarrija Jajupuku-wiyi, manu jalanguju Jimiyanilki-ka rdakungka nyina Yijipirla. Manu kankujulu payirni Pinyamini yilyanjaku Yijipi-kirra. Nguru kaju wuurnpalku karri!” ");
INSERT INTO wbp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ngula-jangka, Ruupunurla wangkaja nyanungu-nyangu kirdanaku Jakupuku, “Yungkaju Pinyamini ngajuku yungurnarla milki-yirrarni wati wiriki Yijipirla. Ngajulu kapurna warrawarra-kanyi. Kapurna pina-kanyirni nyuntu-kurra. Kajirna pina-kanja-wangurlu yampimi Yijipirla-juku, ngulaju-palangu pungka ngaju-nyangu kaja-nyanu-jarra!” ");
INSERT INTO wbp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jakupurlu wurra-manu, “Lawa, lawa! Kularna yilyami Pinyaminiji nyuntu-kurluju! Nyurru-jukurna wajawaja-manu papardi-nyanuju. Pinyamini ngulaju ngaju-parnta-kurlangu Rajulu-kurlangu. Kajilparna yilyayarla Yijipi-kirra nyuntu-kurlu, kajikarla nyiya maju rdipimi. Kajilpa paliyarla, ngulaju kajikarna ngarrurda-jarri warrarda palinjakungarnti.” ");
INSERT INTO wbp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tarnnga-nyayirnilpa miyi pardinja-wangu karrija ngurrangka Kananarla. ");
INSERT INTO wbp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jakupurlu manu nyanunguku warlalja-paturlu, mukulu ngarnu miyi kujalu nyanunguku kaja-nyanu-watirli pina-kangurnu Yijipi-ngirli. Yarnunjuku-jarrijalpalu. Jakupu-jana wangkaja kaja-nyanu-patuku, “Yardalu yanta pina Yijipi-kirra, manu mantalu ngurlu ngarninjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Jakupu-kurlangu kaja-nyanu Juurda wangkajarla nyanunguku, “Yangka Yijipi-wardingki kingirli-nganpa warnkiri-manu kulungku, nyanungu-nganpa wangkaja kuja, ‘Pina-kangkarnili yangka kukurnu-puraji nyampu-kurra. Kajinkili kanjarni-wangu nyina, ngulaju ngaju-nyangu warrkini-paturlu kapulu-nyarra warla-pajirni ngaju-kujakuju nyanja-kujakuju.’ Kujanya-nganpa Yijipi-wardingki kingiji wangkaja. Kajinpa Pinyamini yilya nganimpa-wana Yijipi-kirra, kapurnalu yani yali-kirraju miyi payi-maninjaku. Kala kajinpa Pinyamini mardarni yilyanja-wangurlu nganimpa-kurlu, ngulaju kularnalu yani Yijipi-kirraju.” ");
INSERT INTO wbp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yinya purlka-pardu, wangkajarla kaja-nyanuku Juurdaku, “Waraa! Nyiyakunkulurla wangkaja yali Yijipi-wardingkiki kingiki kuja kankulu mardarni kukurnu palka? Nyurrurlarlu kankujulu waarn-pinyi!” ");
INSERT INTO wbp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kaja-nyanu-paturlujulu yalu-manu Jakupuju, “Yinya Yijipi-wardingkirli kingirli-nganpa miimii-nyanjarla payurnu nyiyarningkijarra. Wangkaja-nganpa, ‘Kirda-purajiji wankaru-juku mayi? Mardarni kankulu kukurnu-nyanu?’ Ngularnalurla yimi-ngarrurnu nyuntu manu Pinyamini nganimpa-nyangu kukurnu-nyanu. Kularnalu milya-pungu kapu-nganpa wangkami Pinyaminiki kanjarniki Yijipi-kirraku.” ");
INSERT INTO wbp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ngularla Juurda wangkaja nyanunguku kirda-nyanuku, “Yilyaya Pinyamini ngaju-wana yungurnalu jalangu yani wuraji Yijipi-kirra. Kajinpa-nganpa muku yilyami Yijipi-kirra jalangurlu, kulalparlipa paliyarlalku miyi-wangu-jangka. Nyuntulurlu manu nganimpa-nyangu kurdukurdurlu kapurlipa miyi panu-jarlu mardarni ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kajinpa yilya Pinyamini ngaju-wana Yijipi-kirra, wangkami karnangku kapurna warrawarra-kanyi. Kularna tarda-kijirni murrumurru-kurra. Kajirna pina-yanirni ngurra-kurra nyanungu-wangu, ngula-juku warrarda ngarrikaju kulungku. ");
INSERT INTO wbp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kapanku! Yilyaya Pinyamini nganimpa-wana Yijipi-kirra! Kajinpa yilyayarlarni kamparru-wiyi, kapurnalu japaku-kari japaku-kari yantarlarra Yijipi-kirra, manu kapurnalu japaku-kari japaku-kari-yijala pina-yantarlarni miyi panu-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ngula-jana wangkaja Jakupuju, “Yuwayi. Junga marda kujaju. Kala kangkalurla warntarri Yijipi-wardingki kingiki, manu yungkalurla. Kangkalurla yangka ngurrju-wati nyiyarningkijarra ngarninjaku nyampu-wardingki nguru-wardingki: ngarlu, kanta-piya, manu yangka kuyungka kuja karlipa yirrarni ngakurru pajarninjaku. Kangkalurla jara yangka kuja karlipa-nyanu maparni palka manu jara kuja-ka ngurrju-nyayirni parntimi. ");
INSERT INTO wbp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kujankulu yanu Yijipi-kirra yangka kamparru-wiyi miyi maninjaku, yungunkulurla yinyaku watiki jinta yakuju tala-kurlu miyiki. Kala kujankulu pina-yanurnu miyi-kirli, ngulajunkulu talaju palka-juku nyangu miyi-wati-kirlirla. Yapangku marda rampal-yirrarnu. Kajinkili pina-yani miyiki, kangkalu-jana yakuju jirrama tala-kurlu-jarra miyikiji. ");
INSERT INTO wbp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kangkalu Pinyamini nyurrurlarlu. Yantalu pina Yijipi-kirra miyi yungunkulurla payi-mani jurnta yinya watiki. ");
INSERT INTO wbp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kaatuju PIRRJIRDI-NYAYIRNI WITA-WANGU! Kapurna-nyarrarla wangka nyanunguku nyurrurlaku yungurla wangkami Yijipi-wardingki kingiki yungu-nyarra ngurrju nyina. Kapurnarla wangka Kaatuku yunguju kanyirni pina Pinyamini manu Jimiyani manu nyurrurlarlangu. Kala kajilparna nyanja-wangu nyinayarla nyanungu-jarraku, ngulaju ngula-juku. Kapurnarla wala-juku nyinami Kaatuku.” ");
INSERT INTO wbp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ngula-jangkaju, yanulkulu pina Yijipi-kirra. Kangulu yangka warntarri nyiyarningkijarra manu yakuju-jarra tala-kurlu manu Pinyaminirlangu. Kapankulu yanu Yijipi-kirra, manulu kamparru karrija Jajupurla. ");
INSERT INTO wbp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Jajupurlu-jana nyangu kamparru karrinja-kurra. Nyangu nyanunguku kukurnu-nyanurlangu Pinyamini. Ngularla Jajupu wangkaja nyanunguku warrkiniki kujalparla warrawarra-kangu nyiyarningkijarra yuwarlirla, “Kangkarni-jana yinya wati-patu ngaju-nyangu yuwarli-kirra. Puluku pakarninjinka manu purraya. Yungurna karlarla ngarni nyampu-patu wati-patu-kurlurlu jalangu.” ");
INSERT INTO wbp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Junga-juku, yinya warrkini yanu, puluku pinjarla purraja. Ngula-jana kangurnu Jajupukupurdangka-patu yuwarli-kirra karlarlaku ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kujalu yinya-patu yukaja Jajupu-kurlangu yuwarli-kirra, lani-jarrijalpalurla. Wangkajalu-nyanu, “Yuwa, nyiyaku-ngalpa kangurnu kaninjarni? Marda talaku kuja yapangku yirrarnu yakujurla kujarlipa yanu ngurra-kurra. Marda kapu-ngalpa pinyi, manu marda kapu-ngalpa jinyijinyi-mani warrki-jarrinjaku pirijina-piyaku. Marda kapu-ngalpa jurnta kanyi tangkiyi.” Kujanyalpalu manngu-nyangu. ");
INSERT INTO wbp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ngula-jangka, yanulurla yangka wati warrkiniki kujalpa karrija tuwa-wana yuwarlirla. ");
INSERT INTO wbp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Wangkajalurla, “Warlaljamarri, nganimparnalu yanurnu nyampu-kurra Yijipi-kirra kamparru-wiyi miyi maninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Kujarnalu pina-yanu ngurra-kurra miyi-kirli, jupu-karrijarnalu ngunanjaku. Rurrpa-manurnalu yakuju miyi maninjaku. Jinta-kari jinta-karirlirnalu palka-manu tala yakujurla. Kangurnu pinarnalu nyampu tala nyuntuku yinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kangurnalu jinta-kari yakuju tala-kurlu yungurnalu miyi yarda mani. Kala kula karnalu milya-pinyi nganangku kuja pina-yirrarnu tala nganimpa-nyangu yakujurla kamparru-wiyi.” ");
INSERT INTO wbp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Warrkini-jana wangkaja, “Yuwa, ngurrju. Kulalu lani-jarriya. Marda yangka Kaatu kuja-ka nyurrurlakupalangurlu purami, marda nyanungurlu pina-yirrarnu talaju. Mardarni karna talaju kujankujulu yungu miyiki yangka kamparru-wiyi.” Ngula-jangkaju, warrkini watingki rdaku-jangka wilypi-maninjarla pina-kangurnu-jana nyanungurrakupurdangka Jimiyaniji. ");
INSERT INTO wbp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ngula-jana warrkinirli kangu yinya wati-patu Jajupu-kurlangu yuwarli-kirra. Yungu-jana ngapa wirliya parljirninjaku, manu miyi-jana manu tangkiyiki ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kujalpalu tangkiyirli miyi ngarnu, wati-paturlulu warntarri manu yungulurla yinyi Jajupuku. Warrkini-jana wangkaja yangka kapulurla karlarla jirrnganja ngarni Jajupuku. ");
INSERT INTO wbp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ngula Jajupu pina-yanurnu ngurra-kurra, yungulurla warntarri nyiyarningkijarra nyanunguku. Parntarrijalurla kamparru nyanunguku. ");
INSERT INTO wbp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Jajupurlu-jana payurnu, “Ngurrjunya yangkaju purlka kirdana-puraji yangka kujankujulu yimi-ngarrurnu kamparru-wiyi? Ngurrju mayi-ka nyina? Wankaru mayi?” ");
INSERT INTO wbp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yalu-manulu, “Yuwayi, nganimpakupalanguju ngurrju manu wankaru. Nyanunguju nyuntu-nyangu warrkini.” Ngulalurla muku parntarrija Jajupuku pulka-pinjaku. ");
INSERT INTO wbp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","30","Ngula Jajupurlu nyangu nyanunguku kukurnu-nyanu Pinyamini ngati-nyanu jinta. Jajupu kapu yulayarlalku. Ngula-jana payurnu papardi-nyanu-patu, “Nyampuju mayi kukurnu-puraji kujankujulu yimi-ngarrurnu?” Ngularla Jajupuju wangkaja Pinyaminiki, “Kaja, yati-wangka karnangkurla Kaatuku yungungku ngurrju nyina nyuntuku.” Jajupuju-jana kapanku jurnta yanu. Nyanungukupurdangka-paturlu kapulu nyangkarla yulanja-kurra. Nyanungu-nyangu ruumu-kurra yanu, manu yulajalpa. ");
INSERT INTO wbp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ngula-nyanu Jajupurlu ngapa-kurlurlu parljurnu yinngirri. Yanurnu pina-jana nyanungukupurdangka-patuku. Warla-pajurnu-nyanu yulanja-kujaku, manu wangkajarla warrkiniki, “Kangkarni kuyu yungulu nyampu-paturlu ngarni.” ");
INSERT INTO wbp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","33","Jajupu-kurlangu warrkini yaninjarla kangurnu kuyu yuwarli-kirra. Jajupulpa nyinaja jinta tayipulu-wana, manu-jana wangkaja nyanungukupurdangka-patuku jinta-karirla nyinanjaku nyanungurla kamparru. Pirrilyi-yirrarnu-jana kamparru jungarnirla. Yirrarnu papardi-nyanu-wiyi jampu-purdanji, manu-jana kukurnu-nyanu-patulku kanardirla yirrarnu nyanungu-wana kutu. Ngula Pinyaminiji purdangirli yirrarnu jungarni-purdanji. Ngulalu-nyanu muku payurnu paa-karrinjarla, “Yuwa! Nyarrparlu kangalpa milya-pinyi ngana papardi-nyanuju manu ngana kukurnu-nyanuju?” Kulalpalu milya-pungu Jajupuju. Panu Yijipi-wardingkilpalu nyinaja tayipulu jinta-karirla. Yijipi-wardingki-patuju kalalu-jana nyurunyuru-jarrija Yipurukuju, manu kula kalalu-jana jirrnganja ngarnu. Kujarlanya kulalpalu nyinaja Jajupukupurdangka-patu-kurluju. ");
INSERT INTO wbp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Warrkini-paturlulu miyiji manu Jajupu-kurlangu-jangka tayipulu-jangka, manu yungulu-jana wati-patuku. Yungulu-jana jinta-kari jinta-kari miyiji. Pinyaminikiji yungulurla rdaka-pala panu-nyayirni. Yungulurla nguku ngarninjaku. Ngula-jangka, Jajupu manu nyanungukupurdangka-paturlulu muku ngarnu miyi manu pama, manulu pama-jangka warungka-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Jajupurla wangkaja warrkiniki yangka kujarla nyiyarningkijarra warrawarra-kangu yuwarlirla, “Manta-jana yakuju-wati kujalu-jana nyampurrarlu kangurnu. Ngurlu panu-nyayirni-jana yirraka. Manu tala kujangkulu yungu miyiki, pina-jana yirraka yakuju-watirla miyi-kirlirla. ");
INSERT INTO wbp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nyampunya ngaju-nyangu kartaku. Yirraka yakujurla kukurnu-nyanu-kurlangurla. Talarlangurla yirraka pina.” Junga-juku, yinya warrkinirli yaninjarla kartaku manu tala yirrarnu kukurnu-nyanu-kurlangurla yakujurla. ");
INSERT INTO wbp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mungalyurru-karilki, kuja wanta kankarlu-jarrija, Jajupukupurdangka-paturlulu yirrayirrarnu jurnarrpa tangkiyi-paturla. Ngula-jana warrkinirli ngurra-kurra pina-yilyaja. ");
INSERT INTO wbp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wilypi-pardinjarlalu yanu yinya-ngurlu ngurra-ngurlu yirdiyi-wana kutu-juku. Ngularla Jajupu wangkaja warrkiniki, “Yanta purdangirli-jana wati yangka-patuku. Kajinpa-jana rdipimi, kuja-jana wangkaya, ‘Ngaju-nyangu paajujulpa-nyarra ngurrju nyinaja. Nyarrpa-jarrijankulurla? ");
INSERT INTO wbp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Mardankulurla jurnta manu kartakuju yangka kuja-ka ngarni. Jampita yinyaju tarruku. Yinya-kurlurlunya kajana yapakuju jukurrpaju jungarni-maninjarla yimi-ngarrirni. Nyurrurlaju punku-nyayirni!’ Kujanya-jana wangkaya!” ");
INSERT INTO wbp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ngula-jana warrkinirliji puranjarla warla-pajurnu yirdiyirla. Wangkaja-jana, “Ngaju-nyangu paajujulpa-nyarra ngurrju nyinaja, nyarrpa-jarrijankulurla? Jurntankulurla manu kartaku, yangka kuja-ka ngarni. Jampita tarruku. Yinya-kurlurlunya kajana jukurrpaju jungarni-maninjarla yimi-ngarrirni. Nyurrurlaju punku-nyayirni!” ");
INSERT INTO wbp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wangkajalurla, “Kula kujaju junga! Nyarrpa kanpa wangkami? Kularnalu purungku-manu kartakuju! ");
INSERT INTO wbp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nganimparlujurnalurla pina-kangurnu talaju kujarnalu palka-manu yakujurla yangka tala ngulajurnalu palka-manu Kananarla. Yungurnangkulu pina nyuntuku. Kulalparnalu purungku-mantarla pirli yaltiri manu kawurlurlangu nyuntu-nyangu paaju-kurlangurla yuwarlirlaju, nyiyaku-wiyi? ");
INSERT INTO wbp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nyangkarla kaninjarni nganimpa-nyangu yakuju-paturla. Kajinpa palka-mani kartaku yapa-kurlangurla, ngulaju pungka tarnnga-kurra. Manu-nganpa jinyijinyi-manta warrki-jarrinjaku pirijina-piya.” ");
INSERT INTO wbp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Warrkiniji wangkaja-jana, “Yuwayi. Kala kajirna palka-mani kartaku yapa-kurlangurla yakujurla, kularna pinyi. Kapurna ngari jinyijinyi-mani warrki-jarrinjaku pirijina-piya. Kularna-nyarra kulu-jarri nyurrurlakuju.” ");
INSERT INTO wbp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Junga-juku, manulpalu jurnarrpa tangkiyi-ngirliji, manu yirrarnulu walyangka. Rurrpa-manu mukulu-jana yakuju-patuju yungu-jana warrkinirli marlaja nyanyi. ");
INSERT INTO wbp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Warrkinirli muku parily-pungu papardi-nyanu-kurlangurla-wiyi. Kula kartaku palka-manu. Jinta-kari jinta-kari-kirlangurla muku raa-pinjarla nyangu, lawa-juku. Ngula-jangka raa-pinjarla nyangu kukurnu-nyanu-kurlangurla yakujurla yangka Pinyamini-kirlangurla. Ngulangka palka-manu kartaku yangka nyanungu-nyangu paaju-kurlangu Jajupu-kurlangu. ");
INSERT INTO wbp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kujalu nyangu kartaku, wajampa-jarrinjarlalu-nyanu larra-pungu jurnarrpa. Ngulalu pinapina warurnu muku yakujuju nyanungurra-nyanguju. Ngulalu pina-yirrarnu jurnarrpaju tangkiyi-paturla-jala. Ngulalu pina-yanu ngurra-kurra Jajupu-kurlangu-kurralku. ");
INSERT INTO wbp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Kujalu Juurda manu nyanungukupurdangka-patu yanu kaninjarni Jajupu-kurlangu-kurra yuwarli-kirra, Jajupuju palka-jukulpa karrija. Parntarrijalurla yinngirri kaninjarra-kari walyangka. ");
INSERT INTO wbp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ngula-jana Jajupurlu payurnu, “Nyiyakunkulu manu kartakuju purungkuju ngaju-nyanguju? Kula kankujulu milya-pinyi mayi ngajuju ngangkayi-kirli? Kulalpankujulu nyiya jurnta wuruly-yirrakarla ngajuku. Ngaju-nyangu yartarnarri-kirlirli kajikarna nyanyi nyiyarningkijarra jukurrparla.” ");
INSERT INTO wbp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ngularla Juurdaju wangkaja nyanungukuju, “Warlaljamarri, kulalparnangkulu nyarrpa wangkayarla nyuntukuju. Kularnalu kangu yinya kartaku. Kaaturlungku yimi-ngarrurnu nganimpaju punku. Kujaju junga. Nganimpa yungurnangkulu warrki-jarrimi pirijina-piya, kula Pinyamini-puka.” ");
INSERT INTO wbp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Jajupuju kula-jana ngungkurr-nyinaja, nyanungu-jana wangkaja, “Lawa, kularna-nyarra jinyijinyi-mani nyurrurlaju pirijina-piya warrki-jarrinjaku. Pinyamini-puka kapurna jinyijinyi-mani yangka kuja purungku-manu ngaju-nyangu kartaku. Kapurna-nyarra panu-kariji pina-yilyami rarralypa ngurra-kurra kirda-nyanu-kurra.” ");
INSERT INTO wbp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ngularla Juurda wangkaja Jajupuku, “Wurra, wurra! Yungurnangku jungangku yimi-ngarrirni. Kulaju kulu-jarriya ngajuku. Milya-pinyi karnangku kuja kanpa pirrjirdi nyina yangka Yijipi-wardingki kingi-piya. ");
INSERT INTO wbp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Kujarnangkulu kamparru-wiyi yanurnu, nyunturlunpa-nganpa payurnu, ‘Nyurrurlaku kirda-nyanu wankaru-juku mayi? Mardarni mayi kankulu kukurnu-nyanu nyurrurlarlu?’ Kujarlunyanpa-nganpa payurnu kamparruju. ");
INSERT INTO wbp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Yimi-ngarrurnurnangkulu yangka kuja-ka nganimpakupalangu wankaru nyina manu kuja karnalu kukurnu-nyanu mardarni kuja-ka ngurrangka nyina nyanungu-kurlu. Nganimpaku kukurnu-nyanuju palka-jarrija kujalpa nganimpaku kirda-nyanu purlkalku nyinaja. Ngati-nyanu nganimpaku kukurnu-nyanukuju ngulajurnalu wajawaja-manu. Manu nyanungu-nyangu kaja-nyanu jinta-karijirnalu wajawaja-manu-yijala. Nganimpaku kirda-nyanu ngulaju karla yulkami-nyayirni kukurnu nganimpakupurdangkakuju. Kujanyarnangkulu kamparruju wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ngula-jangka wangkajanpa-nganpa, ‘Kangkarnili kukurnu-puraji Pinyamini nyampu-kurra yungurna nyanyi ngajulurlu.’ ");
INSERT INTO wbp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ngularnangkulu wangkaja nyuntukuju, ‘Lawa, kularnalu kanyirni nyampu-kurraju nyuntulurlu yungunpa nyanyi. Kajirnalurla jurnta kanyi nyanunguku kirda-nyanuku, kapu purlka-parduju palimi.’ ");
INSERT INTO wbp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nyuntunpa-nganpa wangkaja nganimpakuju, ‘Yaruju kangkarnili kukurnu-puraji nyampu-kurra! Kajinkili kanjarni-wangu pina-yanirni, kapurna-nyarra warla-pajirni yaninjarni-kijaku nyampu-kurra Yijipi-kirra miyi maninjaku.’ Kujanyanpa-nganpa wangkaja kamparruju. ");
INSERT INTO wbp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Junga-juku, pinarnalu yanu nganimpakupalangu-kurra, manurnalurla yungunpa nganta nyanyi Pinyamini. Kujarlaju kula wardinyi-jarrija, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ngaka-karilki, mukurnalu ngarnu miyiji, manulparnalu yarnunjuku-jarrijalku yarda. Ngula-nganpa kirdanaju wangkaja, ‘Yantalu yarda Yijipi-kirra miyi panu maninjaku ngalipaku.’ ");
INSERT INTO wbp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Wangkajarnalurla nyanunguku, ‘Lawa, kulalparnalu yantarla Yijipi-kirra kukurnu Pinyamini-wangu. Kajirnalu yampimirra nyuntu-kurlu, ngulaju Yijipi-wardingki paajurlu kapu-ngalpa wurra-mani nganta nyanja-kujaku.’ Kujarlunyarnalu yimi-ngarrurnu nganimpakupalangukuju. ");
INSERT INTO wbp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ngula-nganpa wangkaja nganimpaku, ‘Milya-pinyi kankulu yangka ngaju-parnta jinta-kari Rajulu, mardarnulpa-palangu jirrama kaja-nyanu-jarra. ");
INSERT INTO wbp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Jinta-karirliji yampinjarla jurnta yanu nyarrpara mayi. Mardalu ngarnu malikirli. Kularna yinngirriji nyangu yarda. ");
INSERT INTO wbp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Jalangurlu kankujulu payirni yungurna nganta yilya Rajulu-kurlangu marulu kaja-nyanu yangka kuja karnarla yalarni-wangu yulkami. Kajirna yilyami nyurrurla-wana, kajika marda palimi nyanungurlangu. Kajilparna wajawaja-mantarla nyanungu, ngajuju kajikarna warrarda yulami.’ Kujanya-nganpa purlka-pardu kirdanaju wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Nyarrpalku kanpa manngu-nyanyi? Kajirnalu yampimirra kukurnu Pinyamini nyampurla, manu kajirnalu pina-yani ngurra-kurra nyanungu-wangu, nyarrpa-jarri kapu nganimpakupalanguju kirdanaju? Pinyaminiki karla wajampa-jarri-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Kajirnalu pina-yani ngurra-kurra nganimpaku kukurnu-nyanu-wangu, kuja-jangkanya kajika kirdanaju wajampa-jarrinjarla palimilki. ");
INSERT INTO wbp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“Ngajulurlurnarla wangkaja nganimpakupalanguku ngajulurlu kapurna warrawarra-kangkarla Pinyaminiji. Ngajurnarla wangkaja, ‘Kajirna Pinyamini pina-kanjarni-wangu nyina, ngulajuju warrarda kulungku ngarrika!’ Kujanyarnarla wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Payirni karnangku yungurnangku nyuntukuju warrki-jarrimi pirijina-piya. Yilyaya ngajuku kukurnu Pinyamini ngurra-kurra ngaju-nyangu papardi-patu-kurlu nyanunguku kirdana-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kulalparna yantarla ngurra-kurra Pinyamini-wangu. Kajilparna yantarla ngurra-kurra nyanungu-wangu, kajikaju wajampa-jarri ngajuku kirdana. Kularna ngampurrpa kujakuju.” Kujanyarla Juurdaju wangkaja Jajupukuju. ");
INSERT INTO wbp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ngula Jajupurlu purda-nyangu kuja-kurra wangkanja-kurra Juurda, kula nyarrpa-jarriyarla, kapu yulayarlalku. Kapulu warrkini-paturlu nyangkarla yulanja-kurra. Kuja-kujakuju-jana wangkaja kuja, “Yantalu yarlu-kurra yuwarli-ngirli, manu yangarlujulu yampiya nyampu-patu Yipuru-patu wati-patu-kurlu.” Jungalu warrkini-paturluju yampinja-yanu Jajupuju, karrijalpa nyanungukupurdangka-patu-kurlu. ");
INSERT INTO wbp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ngulalpa yulaja kilji-nyayirni. Yangka Yijipi-wardingki-paturlulu purda-nyangu yulanja-kurra, manulu-jana yaninjarla wangkaja panu-kariki yapaku kujalpalu kingi-kirlangurla nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ngula-jana Jajupu wangkaja nyanungukupurdangka-patuku, “Ngajurna nyurrurlakupurdangka Jajupu! Kirdana ngajukupalangu wankaru-juku mayi-ka nyina?” Kulalu nyanungukupurdangka-paturlu yalu-manu, lawa. Lani-jarrijalu nyanungu-kujaku. ");
INSERT INTO wbp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Jajupu-jana wangkaja, “Yantarnili kutu ngaju-kurra! Junga, ngajuju nyurrurlakupurdangka Jajupu. Nyurru-wiyinkijili yungu yapa-kari-kirra talakupurdarlu, manujulu jinyijinyi-manu warrki-jarrinjaku pirijina-piya. ");
INSERT INTO wbp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ngulaju ngula-juku. Kulalu wajampa-jarriya! Kularna-nyarra murrumurru-mani. Kulalu-nyanu kulu-jarriya kujankujulu yilyajarni nyampu-kurra. Kaaturluju yilyajarni kamparru nyampu-kurra yungurna-jana mardarni yarnunjuku-kujaku. ");
INSERT INTO wbp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Jirramaku yulyurrpuku kula miyi nyampurla Yijipirla pardija manu nyurrurla-nyangu ngurrararla. Manu kula miyiji pardimi rdaka-pala-kariki yulyurrpuku. Kuja-puru kula nganangku ngurlu yirrarni walya-kurra pardinjaku, manu kula nganangku miyiji mani, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kujakunyaju Kaaturluju yilyajarni kamparru nyurrurlakuju. Kajirna nyinayarla yaninjarni-wangu, kapunkulu kurdu mapirri paliyarla yarnunjuku. Kaaturlu yungu-nyarra yartarnarri-kirlirli mardarni wankaru-juku. ");
INSERT INTO wbp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Yungurna-nyarra yimi-ngarrirni kujaju nyarrpa-jarrija Kaatu ngajuku. Kulankujulu nyurrurlarlu jinyijinyi-manu nyampu-kurraku, lawa. Kaaturlu nyanungurluju yilyajarni nyampu-kurraju. Milarnuju yungurna-jana wiri nyina Yijipi-wardingki-patuku yapaku. Ngajurnu kingi-kirlangu warrkini ngurrju-nyayirni. Warrawarra-kanyi karnarla nyiyarningkijarra yuwarlirla. Ngajurna wiri nyampuku nguruku Yijipiki.’ ");
INSERT INTO wbp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ngajukupurdangka-patu, yampinjarlalu yaruju yanta nyampu-ngurlu ngurra-ngurlu, manu pina-yantalu ngajukupalangu-kurlangu-kurra ngurra-kurra. Kujalurla wangkaya, ‘Nyampunya kaja-puraji Jajupu-nganpa wangkaja: Kaaturlu nganta milarnu wiri nyinanjaku yapaku Yijipi-wardingki-patuku. Yantarni nganta kapanku Yijipi-kirra nyanungu nyanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kajinpa yanirni Yijipi-kirra nganta, nyuntu yungunpa kutu nyina nyanungu-kurlu nganta ngurungka yirdingkaju Kujunurla. Kangkarni nganta-jana nyuntu-nyangu kurdukurdu manu warringiyi-puraji-patu. Kangkarni nganta-jana nyuntu-nyangu jiyipi, narnukutu manu puluku-wati, manu nyuntu-nyangu warrkini-patu yungunkulu nganta nyinami nyanungu-kurlu kutu-juku. ");
INSERT INTO wbp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Rdaka-pala yulyurrpu-kariki nganta kapu miyi-wangu karri nguru-kari nguru-kari. Kuja-puru kapu-nyarra nyanungurluju warrawarra-kanyi nganta palinja-kujaku yarnunjuku.’ Kujarlunyalu yimi-ngarrika ngajukupalanguju.” ");
INSERT INTO wbp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Jajupu-jana wangkaja nyanungukupurdangka-patuku, “Nyangkajulu! Nyanyi-yijala kankujulu ngajuju Jajupu kuja karna-nyarra wangkami. Ngajuku kukurnu Pinyaminirlangurlu yunguju nyanyi ngajuju Jajupu. ");
INSERT INTO wbp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Yuwa, yimi-ngarrirninjinkalu ngajukupalangu nyarrparlu kuja kajulurla pulka-pinyi Yijipi-wardingki-paturlu. Ngajujurna wiri-nyayirni. Yimi-ngarrikalu kujankulu nyiyarningkijarra nyangu milpangku. Yaruju maninjintalu ngajukupalangu, manulu kangkarni nyampu-kurra kapankurlu!” ");
INSERT INTO wbp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Jajupurlu ngamirlji-manu nyanunguku kukurnu-nyanu Pinyamini, manurla yulaja. Pinyaminiji yulaja-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Jajupurlu-jana nyanungukupurdangka-patu nyunjurnu muku. Ngamirlji-manulpa-jana yulanja-karrarlu-juku. Ngula-jangka, nyanungukupurdangka-patulpalurla wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yapa jinta-jana yanu wangkanjaku kingiki manu warrkini-patuku, “Yinyarra Yipuru wati-patu kujalu yanurnu Kanana-jangka, ngulajulu Jajupukupurdangka-patu!” Kujalu kuja yimi purda-nyangu, wardinyi-jarrijalu muku. ");
INSERT INTO wbp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ngularla kingi wangkaja Jajupuku, “Wangkaya-jana nyuntukupurdangka-patuku yungulu yakuju-kurra-mani miyi yungulu yirrarni tangkiyi-wati-kirra manu yungulu kanyi pina nyanungurra-nyangu ngurra-kurra Kanana-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Wangkaya-jana yungulu nyanungurra-nyangu kirdana manu warlalja-patu kanyirni nyampu-kurra ngaju-nyangu-kurra. Kajili yukamirni Yijipi-kirra, kapurna-jana ngurrju-nyayirni nguru yinyi nyinanjaku yungulu miyi ngurrju ngarni nyampurla kuja karlipa mardarni. ");
INSERT INTO wbp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Yaninjakungarntiji, yungkalu-jana puluku-kurlangu rarra-kanja-kurlangu-patu yungulu-nyanu kanyi. Kajili pina-yanirni Yijipi-kirra, yungulu nyanungurra-parnta manu kurdukurdu nyinanjarni yani rarra-kanja-kurlangu-paturla yukayi-kijakuju. Nyanungurrakupalangurlangu yungu yanirni ngulangka-yijala. ");
INSERT INTO wbp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Kajili pina-yanirni nyampu-kurra, yungulu miyi manu jurnarrpa manu nyiyarningkijarra purdangirli yampinja-yani. Panu karlipa mardarni Yijipirla. Kapurlipa-jana yinyi nyiyarningkijarra ngurrju kuja karlipa mardarni nyampurla.” Kujanyarla kingi wangkaja Jajupukuju. ");
INSERT INTO wbp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ngula-jangka, Jajupurlu-jana yungu puluku-kurlangu rarra-kanja-kurlangu-patu nyanungukupurdangka-patuku kujarla wangkaja kingi. Manu miyi panu-jana yungu wurnaku. ");
INSERT INTO wbp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Jajupurlu-jana yungu jinta-kari jinta-kari jurnarrpa yungulu yukamilki wurnakungarnti. Yungurla nyanunguku kukurnu-nyanuku Pinyaminiki rdaka-pala wawarda, manurla yungu 300-pala pirli yaltiri-wati tala. ");
INSERT INTO wbp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Jajupurlu-jana nyanungukupurdangka-patuku yungu karlarla-pala wirriyawirriya tangkiyi miyi-kirli panu-kurlu Yijipi-jangka. Manu-jana karlarla-pala karntakarnta tangkiyi yungu panu-kurlu ngurlu-kurlu, miyi-kirli manu nyiyarningkijarra-kurlu yungulurla yinyi nyanungukupalanguku. ");
INSERT INTO wbp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ngula-jana Jajupu wangkaja nyanungukupurdangka-patuku, “Yantalu pina ngurra-kurra, kulungku kulalu-nyanu ngarrika!” Ngulalu jakuru-pungu, manulu yanulku. ");
INSERT INTO wbp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yampinjarlalu yanu Yijipi-ngirli, manulu yanu kirda-nyanu-kurlangu nguru-kurra Kanana-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Kujalu yukajarra, wangkajalurla kuja, “Nyuntu-nyangu kaja-puraji Jajupu, ngulaju-ka wankaru-juku nyina! Nyanunguju wiri Yijipi-wardingki-patuku yapaku.” Nyanungurrakupalangu Jakupuju ngarrurda-jarrija-nyayirni ngula kuja purda-nyangu. Kula-jana ngungkurr-nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yimi-ngarrurnulu kuja-jana Jajupu nyarrpa wangkaja. Jakupurlu-jana nyangu puluku-kurlangu rarra-kanja-kurlangu-patu kujarla Jajupurlu yilyaja nyanunguku maninjaku manu kanjaku Yijipi-kirraku. Ngula miyaluju ngurrju-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Wangkaja-jana kaja-nyanu-patuku, “Ngungkurr-nyinamilki karna-nyarra kuja-ka ngaju-nyangu kaja nyina wankaru. Palinjakungarnti, yani karna Yijipi-kirra nyanjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jakupurlu-jana manu muku yapa warlalja nyanungu-nyangu manu nyiyarningkijarra, manu nyanungu-nyangu ngurra yampinja-yanu Yijipi-kirrarlu. Kulkurru ngunajarra Piirrjiparla. Yinyarla pungu puluku yungurlajinta Kaatuku pulka-pinyi. Nyanungukupalangurlu Yijakirli kalarla kujarlu-yijala purranjarla yungu jintaku-juku Kaatuku. ");
INSERT INTO wbp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mungangka kujalpa Jakupu jarda ngunaja, Kaaturlu-nyanu milki-yirrarnu. Jukurrparla wangkajarla, “Jakupu, Jakupu!” Jakupurlu yalu-manu, “Nyampunyarna.” ");
INSERT INTO wbp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ngularla Kaatu wangkaja, “Ngajujurna yangka jurrku-juku Kaatu kujalpaju nyuntukupalangurlu Yijakirli puraja. Ngurrju kajinpa yani Yijipi-kirra, kula-jana lani-jarriya Yijipi-wardingki-watiki. Kajinpa yinyarla nyina, nyuntulurlu kapunpa-jana kurdukurdu panu mardarni warringiyi-nyanu, jamirdi-nyanu, jaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ngaju kapurna yani nyuntu-wana Yijipi-kirra. Kajinpa pali, kapungku kaja-puraji Jajupu palka karrimi, kapungku milpaku wapirrimi rdakaju. Ngaka-kari kapurna-jana nyuntu-nyangu warlalja pina-kanyi Kanana-kurra.” Kujanyarla Kaatuju wangkaja Jakupukuju jukurrparla. ");
INSERT INTO wbp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Parra-karirla, Jakupurlu yampinja-yanu yinya ngurra Piirrjipa nyanungu-nyangu warlalja-kurlurlu. Kaja-nyanu-paturlulpalu-jana wari-yirrarnu kali-nyanu-wati manu kurdukurdu puluku-kurlangu-kurra rarra-kanja-kurlangu-patu-kurra kuja-jana kingirliji yilyaja Kanana-kurra. Ngulangka-jukulpalu nyinanja-yanu Yijipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Kangu mukulu-nyanu jiyipi, narnukutu, manu puluku, manu nyiyarningkijarra nyanungurra-kurlu, nyiyarningkijarra kujalpalu-nyanu panu-manu kamparru-wiyi Kananarla. Yuwayi, Jakupuju yanu Yijipi-kirra kaja-nyanu-wati-kirli manu yurntalu-nyanu-wati-kirli manu kurdukurdu-kurlu. Muku-jana kangu panu-juku Yijipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nyampu-patunya yirdi-patuju yapaju kujalu Jakupu-kurlu yanu Yijipi-kirra. Ruupunu Jakupu-kurlangu kaja-nyanu kamparru-warnu; ");
INSERT INTO wbp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruupunu-kurlangu kaja-nyanu-patu-kurlangu yirdiji Yanaka, Paalu, Yijirunu manu Karrmi. ");
INSERT INTO wbp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Jakupu-kurlangu jinta-kari kaja-nyanu yirdiji Jimiyani. Jimiyani-kirlangu kaja-nyanu-patu-kurlangu yirdiji Jimulu, Jamini, Yuyarda, Jakana, Juuru manu Jawurlu. (Jawurlu-kurlangu ngati-nyanu Kanana-wardingki.) ");
INSERT INTO wbp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Jakupu-kurlangu kaja-nyanu-kariji Liipi. Liipi-kirlangu kaja-nyanu-patu-kurlangu yirdiji Kurrjuna, Kuyaja manu Mirari. ");
INSERT INTO wbp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Jakupu-kurlangu kaja-nyanu-kariji yirdiji Juurda. Juurda-kurlangu kaja-patu-kurlangu yirdiji Yuuru, Yunana, Jaalaya, Piiriji manu Jilaya. Yuuru manu Yunana-pala nyurru-juku palija Kananarla. Piiriji-kirlangu kaja-nyanu-jarraju Yijirunu manu Yaamulu. ");
INSERT INTO wbp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Jakupu-kurlangu kaja-nyanu-kariji Yijaka. Yijaka-kurlangu kaja-nyanu-patu-kurlangu yirdiji Tuula, Puwa, Jajapa manu Jimirana. ");
INSERT INTO wbp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Jakupu-kurlangu kaja-nyanu-kariji Jupulunu. Jupulunu-kurlangu kaja-nyanu-patu-kurlangu yirdiji Jirarda, Yalunu manu Jalili. ");
INSERT INTO wbp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Liiyaju ngati-nyanu Ruupunuku, Jimiyaniki, Liipiki, Juurdaku, Yijakaku manu Jupulunuku. Jakupulpa-jana kirdana nyinaja. Palka-jarrija mukulu kujalpa-pala Jakupu manu Liiya nyinaja ngurrangka yirdingkaju Patana-Yarramarla. Jakupuku yurntalu-nyanu Tiina palka-jarrija yinyarla-yijala. Yuwayi, Jakupuku manu Liiyakulu-palangu marlaja palka-jarrija 33-pala yapa. ");
INSERT INTO wbp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Jakupu-kurlangu kaja-nyanu-kariji Kaardu. Kaardu-kurlangu kaja-nyanu-patu-kurlangu yirdiji Jiipuyunu, Yaaki, Juuni, Yijipana, Yuuruu, Yarurti manu Yarili. ");
INSERT INTO wbp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Jakupu-kurlangu kaja-nyanu-kariji Yaaja. Yaaja-kurlangu kaja-nyanu-patu-kurlangu yirdiji Yimina, Yijipa, Yiiji manu Piriya. Nyanungurrakupurdangkaju karntaju Jiira. Piriya-kurlangu kaja-nyanu-jarraju Yipiru manu Malkilu. ");
INSERT INTO wbp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Jiilpaju ngati-nyanu Kaarduku manu Yaajaku. Nyanunguju karnta warrkini Liiya-kurlangu kujarla Lapanarlu yungu Liiyaku kamparrurlu-wiyi. Yangka-juku kujarla Liiyarlu yungu Jakupuku ngunanjaku. Yuwayi, Jakupuku manu Jiilpakulu-palangu yapaju 16-pala marlaja palka-jarrija. ");
INSERT INTO wbp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jakupu-parnta jinta-kariji Rajulu. Nyanungu-nyangu kaja-nyanu-jarraju yirdiji Jajupu manu Pinyamini. ");
INSERT INTO wbp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kujalpa Jajupu nyinaja Yijipirla, nyanungu yupukarra-jarrija karnta-kurlu yirdi-kirliji Yajanaja-kurlu. Nyanunguku kirdana yirdiji Putipura. Kala warrki-jarrija maralypikingarduyu ngurungka yirdingkaju Yuunurla. Jajupu-kurlangu kaja-nyanu-jarra yirdiji Manaja manu Yipirayimi. ");
INSERT INTO wbp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Pinyamini-kirlangu kaja-nyanu-patu-kurlangu yirdiji Piila, Pikuru, Yajipulu, Kiira, Namana, Yiiyi, Ruuju, Mupimi, Yupimi manu Yaarda. ");
INSERT INTO wbp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jakupuku manu Rajulukulu-palangu marlaja palka-jarrija 14-pala yapa-patu. ");
INSERT INTO wbp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Jakupu-kurlangu kaja-nyanu-kariji Taanu. Taanu-kurlangu kaja-nyanuju yirdiji Yujimi. ");
INSERT INTO wbp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Jakupu-kurlangu kaja-nyanu-kariji Napatali. Napatali-kirlangu kaja-nyanu-patuju yirdiji Jajilu, Kuni, Jijuru manu Jilumu. ");
INSERT INTO wbp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Piilyaju ngati-nyanu Taanuku manu Napatali. Nyanunguju karnta warrkini kujarla Lapanarlu yungu Rajuluku kamparrurlu-wiyi, yangka kujarla Rajulurlu yungu Jakupuku ngunanjaku. Jakupuku manu Piilyakulu-palangu marlaja palka-jarrija 7-pala yapa-patu. ");
INSERT INTO wbp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","27","Nyajangulu yapaju yanu Jakupu-kurluju Yijipi-kirraju? 70-palalu yanu. Nyanunguju yanu nyampu-patu-kurlu yapa-kurlu kuja kalu yirdiji nguna nyampurla pipangka. Jajupu-kurlangu kaja-nyanu-jarra Manaja manu Yipirayimi-pala palka-jarrija Yijipirla. ");
INSERT INTO wbp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kujalpa Jakupu yanurnu murnma-juku Yijipikiji nyanungu-nyangu warlalja-kurlu, nyanungurlu yilyaja kaja-nyanu Juurda kamparru yaninjarla palka-maninjaku Jajupuku kujalpa nyinaja ngurungka Kujunurla. Juurdarlu yimi-ngarrurnunjunu Jakupuku kujalpalu nyanunguku warlalja-patu yanurnulku. Ngula-jangka, Jakupu manu nyanungu-nyangu warlaljalu yanu yangka-kurra Kujunu-kurralku. ");
INSERT INTO wbp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Kuja Jajupurlu purda-nyangu kujalpa nyanungukupalangu yanurnu, manu nyanungu-nyangu nantuwu-kurlangu wirli-jarra-kurlu, ngularla wapirdi yanu. Kuja nyangu nyanungukupalangu, yaninjarla ngamirlji-mardarnu waninja-wana. Karrinjarlalpa yulalyi-mardarnu tarnnga-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jakupurla wangkaja kaja-nyanuku, “Nyangulkurnangku yinngirriji. Milya-pinyi karna kuja kanpa wankaru nyina. Kujakuju kajilparna paliyarla, kujaju ngurrju.” ");
INSERT INTO wbp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ngula-jana Jajupu wangkaja nyanungukupurdangka-patuku manu kirda-nyanu-kurlangu-patuku warlalja-patuku, “Yimi-ngarrirninjini karna kingi kujankulu nyurru yanurnu. Ngaju kapurnarla kuja wangkami, ‘Ngajukupurdangka-paturlu manu ngajuku kirdana-kurlangu-paturlu warlalja-paturlulu yampija ngurrara Kanana, yanurnujulu ngajuku nyampu-kurra. ");
INSERT INTO wbp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Jiyipikingarduyu kalu nyina. Warrawarra-kanyi kalu-jana jiyipi, narnukutu manu puluku-wati. Kangurnulu-nyanu nyiyarningkijarra nyampu-kurra.’ Kujanya kapurnarla wangkami kingikiji. ");
INSERT INTO wbp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kapu-jana yilyamirni warrkini-wati yungulu-nyarra nyurrurla maninjinirni nyanunguku nyanjaku. Kajinkilirla yani nyanunguku, kapu-nyarra payirni kujarlu, ‘Nyarrpa-jarrimi kankulu warrkiki?’ ");
INSERT INTO wbp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Kaji-nyarra payirni kujarlu, wangkayalurla kuja, ‘Nganimpaju jakumanu-wati. Warrarda karnalu-jana warrawarra-kanyi jiyipi, narnukutu manu puluku-wati nganimpa-nyangu-piyarlu nyurnunyurnu-piyarlu-yijala. Kapurnangkulu warrki-jarrimi nyuntukulku.’ Kujanyalurla wangkaya. Kajinkilirla kuja wangkami kingiki, kapu-nyarra yimi-ngarrirni nyurrurla yungunkulu nyampurla ngurungka Kujunurla nyinami wurnturu-juku Yijipi-wardingki-patukuju. Yijipi-wardingki-patuju kula kalu ngampurrpa nyina jiyipikingarduyu-wati-wanaku nyinanjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jajupurla yaninjarla wangkaja kingiki, “Ngajukupalangu kirdana manu ngajukupurdangkalu nyurru yukajarni Kanana-ngurlu. Kangurnulu-nyanu warlaja jiyipi manu puluku manu nyiyarningkijarra. Nyinami kalu Kujunurla.” ");
INSERT INTO wbp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ngula Jajupu pina-yanu, milarnu-jana rdaka-pala nyanungukupurdangka-patu nyanjaku kingiki. ");
INSERT INTO wbp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kujalu yukajarni kingi-kirlangu-kurra, nyanungurlu-jana payurnu, “Warrki nyiya-piya-kurlu nyurrurlaju?” Yalu-manulu, “Nganimpaju jakumanu. Nganimparlu karnalu-jana warrawarra-kanyi jiyipi manu narnukutu manu puluku-wati nganimpakupalangu nyurnunyurnu-piyarlu. Kapurnangkulu warrki-jarrimi nyuntukulku. ");
INSERT INTO wbp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Yanurnalu yungurnalu nyinami nyampurla ngurrangka. Marna yukuri-wangu nganimpa-nyangurla ngurrararla Kananarlaju nganimpa-nyangu jiyipi manu pulukuku ngarninjaku. Nganimpa manu yapa panu-karilparnalu yarnunjuku nyinaja. Kula-nganpa yilyaya! Nyinami yungurnalu Kujunurla.” ");
INSERT INTO wbp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kingirla wangkaja Jajupuku, “Yuwayi, nyuntukupalangu manu nyuntukupurdangkalu yanurnu nyuntuku nyanjaku. ");
INSERT INTO wbp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Milaka-jana ngurra nyampurla Yijipirla yungulu nyina. Ngurrju-nyayirni-jana yungka nyuntukupalanguku manu nyuntukupurdangka-patuku. Yuwayi, yungulu nyinami Kujunurla. Kajili nyina ngurrju jakumanu, yungujulu ngajurlanguku warrawarra-kanyi ngaju-nyangu jiyipi manu puluku-wati.” ");
INSERT INTO wbp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","9","Jajupurla yanu maninjaku nyanungukupalanguku Jakupuku, manurla kangurnu nyanjaku kingiki. Kingirli payurnu Jakupu, “Nyajangu-patu yulyurrpa-jangkaju kanpa nyinami?” Jakupurlu yalu-manu, “130-pala-mipa yulyurrpu-jangkaju karna nyinamilki. Ngajukupalangu-patu nyurru-warnu-patu kalalu nyinaja wankaru-juku tarnnga-nyayirni ngaju-piya-wangu. Ngajuju kalarna warrarda wapaja ngurra-kari ngurra-kari-kirra. Ngarilparna witaku warru nyinaja, kalarna jata-nyangu-nyayirni.” ");
INSERT INTO wbp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ngula-jangkaju, Jakupurlu Kaatu payurnu kingiki warrawarra-kanjaku. Ngula-jangka yanulku. ");
INSERT INTO wbp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Jajupurlu-jana nguru ngurrju-nyayirni yungu nyanungukupalanguku manu nyanungukupurdangka-patuku. Yinya ngurra ngulaju kirri wiriki kutu Ramijiki. ");
INSERT INTO wbp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yungu-jana miyi panu-nyayirni ngarninjaku nyanungu-nyangu warlaljaku. Yarnunjuku-wangulkulpalu nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ngapa wantinja-wangu-jukulpa karrija Yijipirla manu Kananarlaju. Yapangkujulu muku ngarnu miyiji, miyi-wangulpalu nyinaja, lawa. ");
INSERT INTO wbp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kuja-jangka kalalurla yanu Jajupuku payi-maninjaku ngurluku ngurlu yangka kuja yirrarnu kamparrurlu-wiyi yuwarli wiri-paturla. Yungu mukulurla talaju, ngula kala-jana ngurlu yungu ngarninjaku. Ngaka kujalurla tala muku yungu, Jajupurlu talaju kangu kingi-kirlangu-kurra yuwarli wiri-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Yapa-patu Yijipi manu Kanana-wardingki-patulpalu tala-wangu nyinaja miyiki payi-maninjaku, lawa. Yanurnulurla Jajupuku, manu wangkajalurla, “Waraa! Yungka-nganpa nyiyarlangu ngarninjaku! Tala-wangu lawa nganimpaju! Kajinpa-nganpa miyi yinja-wangu nyina, kapurnalu palimi nyuntulurla-juku!” ");
INSERT INTO wbp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Jajupurlu-jana yalu-manu, “Nyurrurlaju tala-wangu-wati, ngulaju ngula-juku. Yungkajulu nyurrurla-nyangu nantuwu, puluku, jiyipi, narnukutu manu tangkiyi-wati. Kujakuju kapurna-nyarra miyi yinyi ngarninjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Junga-juku, yangka Yijipi-wardingkirli manu Kanana-wardingkirlilirla kangurnu nantuwu, puluku, narnukutu manu tangkiyi-wati, manulurla yungu Jajupuku. Kuja-jangka, yungu-jana miyi. Kujanya yungu-jana miyi yulyurrpu jintaku yungulu wankaru nyinami. ");
INSERT INTO wbp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Yulyurrpu-karirla yapalurla yanurnu pina Jajupuku, manu wangkajalurla, “Milya-pinyi-jala kanpa-nganpa nganimpaju tala-wangulku. Manu nganimpa-nyangu nantuwu, puluku, jiyipi, narnukutu manu tangkiyi kangkulu karrimi nyuntukulku. Kulalparnangkulu nyiyalku yungkarla? Nganimpa-puka kajikarnalu-nyanu yinyi nyuntu-kurraju manu nganimpa-nyangu nguru. ");
INSERT INTO wbp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nyangkalu warru! Nyanyi-yijala kanpa nguruju pirntayi-nyayirni, kula-ka nyiya pardimi. Nyiyarningkijarraju kapulu palimi manu nganimparlangu! Kajinpa-nganpa miyi yinyi ngarninjaku, kapurnalu-nyanu nganimpa yinyi nyuntu-kurra manu nganimpa-nyangu ngururlangu. Kapurnalu nyina kingi-kirlangulku, manu kapurnalurla warrki-jarrimi pirijina-piyalku. Yungka-nganpa ngurlu yungurnalu walyangka yirrarni. Kajirnalu yirrarni, marda kajika yukurirlangu pardimi. Kala kajirnalu nguru yampimi ngurlu yirrarninja-wangurlu, kapu nguruju pirntayi-nyayirni karri.” Kujanyalurla yapaju wangkaja Jajupukuju. ");
INSERT INTO wbp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Jajupurlu-jana nguru muku puntarnu yapa-patukuju, manurla yungu kingiki. Yapa-patulpalu yarnunjuku-nyayirni nyinaja. Kuja-jangkanya jinta-kari jinta-karilirla nguruju yungu Jajupukuju. Ngula-jangka, nguru-wati yangka Yijipirla, karrijalpalurla kingikilki. ");
INSERT INTO wbp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yapa panu Yijipi-wardingki-paturlangu nyinajalpalu kingi-kirlangulku. Jajupurlu-jana jinyijinyi-manu warrki-jarrinjaku miyi-mipaku. Nguru-kari nguru-karirlalurla warrki-jarrija Yijipirla kingikiji. ");
INSERT INTO wbp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Yangka maralypikingarduyu-paturlu Yijipi-wardingki-paturlulpalu palka-juku talaju mardarnu kuja-jana kingirli yungu warrki-ngirli. Miyijilpalu payi-manu-juku tala warrki-jangka-kurlurlu. Kuja-jangkanya Jajupurlu kula-jana nguruju jurnta kangu. ");
INSERT INTO wbp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Jajupu-jana wangkaja yapa-patuku, “Nyurrurla manu nguru nyurrurla-nyangu kankulurla nyina kingiki. Ngajulurlurnarla yungu nyurrurlaju warrki-jarrinjaku. Kapurna-nyarra ngurlu yinyi yirrarninjaku walyangkaku. Jinta-kari jinta-karirlili ngurlu kangka ngurra-kurra. Walyangkalu yirraka miyi yungu pardimi. ");
INSERT INTO wbp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kaji pardimi ngurlu palka, pajirninjarlalu-jana yirraka yurturlurla. Yirrakalu-jana rdaka-pala-karirla, manulurla jinta-kari yungka kingiki. Murntu-pala-karili-nyanu mardaka nyurrurla-nyangu warlaljaku manu kurduku yungulu ngarni. Panu-kari ngurlujulu yarda yirraka walyangka miyiki pardinjaku.” ");
INSERT INTO wbp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yapalurla wangkaja Jajupuku, “Mardarnunpa-nganpa palinja-kujaku. Kajinpa-nganpa jinyijinyi-mani warrki-jarrinjaku, ngulaju kapurnalurla warrki-jarrimi kingiki pirijina-piya miyi-mipaku.” ");
INSERT INTO wbp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Jajupurlu kuruwarri yirrarnu pipangka. Kujanya-ka kuruwarriji wangkami: “Nyampu kuruwarri kula maralypikingarduyuku puranjaku. Ngari ngalya-kariki yapa Yijipi-wardingki-patu-mipaku. Kajili yirrarni ngurlu walyangka miyi pardinjakungarnti, kajili yirnmi-jarri, yungulu yurturlu-kari yurturlu-kari yirrarni, jinta-kariji kingiki manu murntu-palaju nyanungurraku.” Kujanya kuruwarriji yirrarnu Jajupurluju Yijipi-wardingki-patukuju. Yapangku kalu purami-jiki jalangurlu. ");
INSERT INTO wbp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ngula-jangka, yangka Yijirali-pinkilpalu nyinaja nguru Kujunurla yangka Yijipirla 17-pala yulyurrpuku. Mardarnulpalu-nyanu nyiyarningkijarra, manulu-jana kurduwarr-kujurnu kurdukurdu panu-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yinya purlka-pardu Jakupu, nyanungurlangu nyinaja 17-pala yulyurrpuku Kujunurla. Kuja palija, ngulaju 147-pala yulyurrpu-jangkalku. ");
INSERT INTO wbp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Palinjakungarntirli yimirla yilyaja kaja-nyanu Jajupuku nyanunguku nyanjaku. Kuja Jajupu yanurnu, Jakupurla wangkaja, “Kaja, ngajuju kapurna palimilki. Kajinpaju yulkami-nyayirni, manyu-wanguju wangkaya! Wangkayaju kajirna palimi, kulaju milyingka yirraka nyampurla Yijipirla. ");
INSERT INTO wbp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","31","Kangka ngaju-nyangu palka Yijipi-ngirli. Milyingka yirraka yangkangka-juku kuja kalu ngajukupalangu-patu nguna. Kujaju wangkaya!” Jajupurla wangkaja, “Yuwayi, kapurnangku pina-kanyi milyingka yirrarninjaku nyuntu-nyangu nguru-kurra.” Ngula-jangkaju, Jakupuju wangkanjarla ngunanja-wantija pangkingka mata, ngularla pulka-pungu Kaatuku. ");
INSERT INTO wbp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ngaka-pardu-kari, Jajupurlu purda-nyangu nyanungukupalangu Jakupu nyurnulpa nyinaja palinjakungarnti. Kangu-palangu kaja-nyanu-jarra Manaja manu Yipirayimi nyanjaku Jakupuku. ");
INSERT INTO wbp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kuja Jajupu yukajarra kaja-nyanu-jarra-kurlu, yapa jintarla yanu yimi-ngarrirninjaku Jakupuku, “Kaja-puraji nyurru yukajarni yungu ngantangku nyuntu nyanyi.” Jakupujulpa ngunaja rampaku-nyayirni, ngunajalpa karrinja-wangu. Kuja Jajupu yukaja wirriya-jarra-kurlu, Jakupuju yakarra-pardinjarla pulya-nyayirnilpa nyinaja. ");
INSERT INTO wbp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ngularla Jakupu wangkaja Jajupuku, “Nyurru-wiyi-nyayirni PIRRJIRDI-NYAYIRNI WITA-WANGURLU Kaaturlu-nyanu milki-yirrarnu ngaju-kurra Luujurla yangka nguru Kananarla. Wangkajaju kapuju pirrjirdi-maninjarla warrawarra-kanyi warrarda, manu kapuju kurdu panu-jarlu yinyi. ");
INSERT INTO wbp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Nyanunguju wangkaja ngajuku, ‘Kurdukurdu panu-nyayirni kapunpaju marlaja kurduwarr-kijirni. Kapunpa-jana kirdana nyina yurturlu-kari yurturlu-kari yapaku. Ngaju kapurna-jana yinyi nyampu nguru nyuntu-nyangu kurdukurduku manu nyanungurra-nyangu kurdurlanguku. Kapu-jana karri nyanungurrakulku tarnnga-juku.’ Kujanyaju Kaatuju wangkaja. ");
INSERT INTO wbp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Jajupu, nyuntu-nyangu kaja-nyanu-jarra Yipirayimi manu Manaja, ngulaju-pala palka-jarrija nyampurla ngurungka Yijipirla. Ngajurna ngakalku yanurnu. Jalangurlu karna-palangu rdakurl-kijirni ngaju-nyangu kaja-nyanu-jarra-piya Ruupunu manu Jimiyani-piya. ");
INSERT INTO wbp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kala ngaka, kajinpa-jana kaja panu yarda mardarni, kapungkulu nyuntuku nyina. Ngajulurlu kularna-jana nguruju yinyi, lawa. Yungulu yani nyinanjaku ngurungkaku kuja karna-palangu yinyi Yipirayimiki manu Manajaku. ");
INSERT INTO wbp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nyurru-wiyi, kujarna yanurnu ngurra-ngurlu Patana-ngurlu ngaju-parnta Rajulu-kurlu, wurnalparlijarra yaninja-yanu Yiparata-kurra-pinangu. Kulkurru-juku Kanana-kurrajurna kali-puka-jarrija. Kujarna wajampa-jarrija-nyayirni, ngularna milyingka yirrarnu yirdiyi-wana kuja-ka nguna Yiparata-kurra.” Kujanyarla Jakupuju wangkaja Jajupukuju. (Yinya ngurra yirdi Yiparata, jalangurlu yapangku kalu yirdi-mani Pijilimi.) ");
INSERT INTO wbp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ngula-jangkaju-palangu Jakupurlu nyangu wirriya-jarra karrinja-kurra Jajupu-kurlu. Jakupurlu payurnu, “Ngana-jarra nyampu-jarra wirriya-jarra?” ");
INSERT INTO wbp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jajupurlu yalu-manu kirda-nyanu, “Nyampu-jarra ngaju-nyangu kaja-nyanu-jarra kujaju Kaaturlu yungu ngajuku nyampurla Yijipirla.” Ngularla Jakupu wangkaja Jajupuku, “Kangkarni-palangu nyuntu-nyangu kaja-nyanu-jarra ngaju-kurra yungurna-palangu milki-yunparni kuruwarri.” ");
INSERT INTO wbp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Manngu-nyangkalu yinya purlka-pardu Jakupu. Nyinajalpa purlkalku, manu kulalpa nyangu pampalku. Junga-juku, Jajupurlu-palangu wirriya-jarra kutu kangurnu Jakupu-kurra. Jakupurlu-palangu nyunjurnu manu ngamirlji-mardarnu. Nyinajalpa-pala ngamirljirla. ");
INSERT INTO wbp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ngularla wangkaja Jajupuku, “Kula-ngantanpa lawa-jarrija. Kula-nganta kapurna nyinakarla nyuntu nyanja-wangu, kala lawa. Kaatujulpaju ngurrju nyinaja. Ngajuju kangurnu yungurna-nyarra nyanyi nyuntu manu nyuntu-nyangu-jarra kurdu-jarra.” ");
INSERT INTO wbp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","13","Jajupurlu-palangu kaja-nyanu-jarra jarna-manu kirda-nyanu-kurlangu ngamirlji-ngirli, karrinja-yirrarnu-palangu kamparru yungu-palangu Jakupurlu rdaka yirrarni jurrungka manu yungu-palangu milki-yunparni kuruwarri. Karrinja-yirrarnu Yipirayimi jungarni-purdanji kutu Jakupu-kurlangu jampu-purdanji rdakaku, manu karrinja-yirrarnu Manaja jampu-purdanji yungu kutu karrimi Jakupu-kurlangu jungarni-purdanji rdakaku. Ngularla Jajupulku parntarrinjunu purdangirli-wana wirriya-jarrakuju. Ngula yinngirrirli marnpurnu walya. Pardarnulparla Jakupuku yungu rdaka jungarni-purdanji yirrarni Manaja-kurlangu jurrungka. Manajaju Yipirayimikipurdangka papardi-nyanu. ");
INSERT INTO wbp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kujarlanya, Jakupurlu yungujurla jungarni-purdanji rdaka yirrakarla Manaja-kurlangurla jurrungka. Kala lawa. Jakupurlu jungarni-purdanji rdaka yirrarnu kankarlu Yipirayimi-kirlangu jurrungka kamparruju. Ngula jampu-purdanji rdaka yirrarnu Manaja-kurlangu jurrungka. ");
INSERT INTO wbp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Jakupurlurla milki-yunparnu kuruwarri Jajupuku-wiyi kamparruju, kuja yunparnu: “Ngaju-nyangu warringiyi Yipuruyamurlu, manu ngajukupalangu Yijakirli-pala puraja ngalipa-nyangu Kaatu. Tarnnga-nyayirnirli Kaaturluju ngaju warrawarra-kangu yangka kuja-ka jiyipikingarduyurlu warrawarra-kanyi jiyipi, ngula-piyanya. ");
INSERT INTO wbp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nguru yangka kujaju wuurnpa-jarrija, ngula-puruju Kaatu-kurlangu marramarrarluju ngajuju muurl-mardarnu. Jalangurlu karna Kaatu payirni yungu-palangu tarnngangku nyampu-jarra pirrjirdi-maninjarla warrawarra-kanyi. Kaji-pala wiri-jarrimi, yungulu-jana nyanungu-jarra-kurlangu kurduku milki-wangkami ngaju-kurlu manu ngaju-nyangu warringiyi-kirlangu Yipuruyamu-kurlu manu ngajukupalangu Yijaki-kirli. Payirni karna Kaatu yungu-palangu kurdu panu-jarlu yinyi nyampu-jarra wirriya-jarraku. Yungulu nguru-kari nguru-karirla nyina. Yungulu-ngalpa warrarda langangku mardarni wajawaja-maninja-wangurlu.” Kujanya-palangu Jakupurluju milki-yunparnu kuruwarriji wirriya-jarraku. ");
INSERT INTO wbp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Jajupurlu nyangu kirda-nyanu kuja rdaka jungarni-purdanji yirrarnu Yipirayimi-kirlangu jurrungka. Kula Jajupuju ngurrju-jarrija kujakuju. Rdaka manu nyanungukupalangu-kurlangu jungarni-purdanji yungu nganta mantarla Yipirayimi-kirlangu-ngurlu jurru-ngurlu manu yungu nganta yirrakarla Manaja-kurlangu jurrungka. ");
INSERT INTO wbp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Wangkajarla Jakupuku, “Wapirra, rampal-yirrarni kanpa jungarni-purdanji rdaka Yipirayimi-kirlangu jurrungka. Yirrakarlanpa rdakaju Manaja-kurlangu jurrungka. Nyanunguju papardi-nyanu. Yirraka rdaka jungarni-purdanji nyanungu-nyangu jurrungka.” ");
INSERT INTO wbp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kirda-nyanurluju wurra-manu nyanunguju, manu wangkajarla, “Kaja, kularna rampal-yirrarnu rdaka jungarni-purdanji Yipirayimi-kirlangu jurrungka. Kaji Manaja wiri-jarrimi, kapu wiri nyinami, manu kapu-jana panu-nyayirni kurduju mardarni manu warringiyi-wati. Manu nyanungu-nyangu kukurnu-nyanu kapu wiri-nyayirni-jiki nyinami Manaja-piya-wangu, kapulu yapa panu nyina Yipirayimi-kirlanguju, manu kapulu pirri-yani muku nguru-kari nguru-kari.” ");
INSERT INTO wbp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ngula-palangu Jakupurlu milki-yunparnu yarda Yipirayimiki manu Manajaku, “Ngaka kajili Yijirali-pinkirli yapangku yunparni kuruwarri nyanungurra-nyangu kurdukurduku, kapulu kuja wangkami, ‘Ngaliparlu karlipa Kaatu payirni yungu-nyarra warrawarra-kanyi Yipirayimi manu Manaja-piya.’” Kujarlunya Jakupurlu yunparninjarla milarnu Yipirayimi yungurla wiri nyina papardi-nyanu Manajaku. ");
INSERT INTO wbp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ngularla Jakupu wangkaja Jajupuku, “Nyangkaju ngaju. Kapurna ngajuju palimilki. Kaatu kapu nyina nyuntu-kurlu. Kapungku ngurrara-kurra pina-kanyi kujalpa-jana karrija ngalipakupalangu-purnuku. ");
INSERT INTO wbp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ngajurnangku nguru yungu, kularna-jana yungu nyuntukupurdangka-purnuku-wiyi. Ngajulurnangku yungu nguru yirdiji Jikimi. Nguru yinyajurna-jana puntarnu Yamuri-patu yapaku. Puntarnurna-jana kulu wiri-puru.” ");
INSERT INTO wbp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jakupu-jana wangkaja nyanungu-nyangu kaja-nyanu-watiki nyanjaku yungulurla yanirni nyanunguku. Kujalu yanurnu, nyanungu-jana wangkaja, “Yantarnili kutu ngaju-kurra yungurna-nyarra kuruwarri milki-yunparni jinta-kari jinta-kariki. Ngajulurlu kapurna-nyarra yimi-ngarrirni nyarrpa-jarrimi kapunkulu ngaka.” Ngulalpa-jana milki-yunparnu nyanungurraku: ");
INSERT INTO wbp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ngaju-nyangu kaja-nyanu-patu, yantarnijili kutu ngaju-kurra yungunkujulu purda-nyanyi yunparninja-kurra. Ngajujurna Jakupu, nyurrurlaku kirdana, manu ngaju-nyangu yirdi jinta-kariji Yijirali.” ");
INSERT INTO wbp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ngularla Jakupurlu milki-yunparnu kuruwarri Ruupunukulku: “Ruupunu, nyuntujunpa ngaju-nyangu kaja-nyanu kamparru-warnu. Nyurru-wiyi kujalparna pirrjirdi-juku nyinaja, nyuntukupalangurna yajarnu, nyuntunpa kamparru-warnu palka-jarrija. Kujarlanyarna milya-pungu ngajuju pirrjirdi-jiki. Nyuntujunpa papardi-jurrku ngaju-nyangu kaja-nyanu-wati-karikiji, manu nyuntujunpa pirrjirdi nyanungurra-piya-wangu. ");
INSERT INTO wbp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nyuntujunpa kulinypa-nyayirni! Kulalpangku nganangku warla-pajikarla nyiyarningkijarra maju-maninja-kujakuju. Nyurru-wiyi nyuntunpa ngunaja ngaju-nyangu karnta warrkini-kirli, kurnta-manu-nyayirninpaju. Kujarlanya jalangu kula kanpa-jana paaju wiri nyina nyuntuku kukurnu-puraji-patuku.” ");
INSERT INTO wbp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Ngula-palangu Jakupurlu milki-yunparnu Jimiyaniki manu Liipikilki: “Jimiyani manu Liipi, nyuntu-jarraju papardirlangu. Nyuntu-jarraju kulu-ngawurrpa-jarra. Nyurru-wiyi, murrumurru-manunkulu-jana yapa junma wiri-kirlirli. ");
INSERT INTO wbp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Nyuntu-jarraju kankulu-jana yapakuju nginji-wangkami nyarrparlu yungunkulu-jana murrumurru-mani yapa-patu-kariji. Kula karnangkupala ngungkurr-nyina kujakuju. Nyuntu-jarrajulpankulu-jana nyurunyuru-jarrija warrarda yapakuju nyurru-wiyiji, manunkulu-jana muku pungu. Junma-kurlurlu kalalpankulu-jana puluku pulyku pajurnu wapanja-kujaku ngari manyu-wanarlu. Kujaju maju! ");
INSERT INTO wbp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nyuntu-jarraju kurnta-jarrinja-wangu yapa-patu-karikiji, kulu-parnta-nyayirninpala! Kuja-jangkaju kapurna Kaatu payirni yungungkupala juyurdurlu-yunparni. Kularnangkupala nguruju yinyi nyuntu-jarrakuju manu nyuntu-jarra-kurlangu kurdukurduku manu nyanungurra-nyangu kurduku, lawa. Kapulu lawa nyinami nguru-wangu tarnnga-juku. Kala kapulu nyina ngurungka nyanungu-jarrakupurdangka-patu-kurlangurla kajirna-jana nyanungurra-mipaku yinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ngularla Jakupurlu milki-yunparnu kuruwarri Juurdakulku: “Juurda, nyuntukupurdangka-paturlu kapungkulurla pulka-pinyi nyuntukuju. Manu kapulu parntarrimi kamparru nyuntuku. Yapa kuja kangkulu nyurunyuru-jarrimi, kajinpa yani kuluku nyanungurraku, kapunpa-jana pinjarla-nyayirni yirrarni. ");
INSERT INTO wbp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Nyuntujunpa ngaya wiri-jarlu-piya kuja karla warrirni kuyu-kariki nyanungu-piyaku pinjarla ngarninjaku. Pinyi kajana, manu ngarni kajana, ngula-ka pina-yanirni ngurra-kurralku. Ngunanjini-ka walyangka jardaku. Panu kalurla lani-jarrimi yinyaku ngaya wiri-jarlu-piyaku. Nganangku kulalpa yakarra-mantarla. Juurda, nyuntujunpa pirrjirdi kuja-piyanya! ");
INSERT INTO wbp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ngajulu karnangku nguru nyampuju yinyi. Nyuntu kapunpa wiri nyina. Ngaka nyuntu-nyangu kaja-nyanu-patu manu warringiyi-puraji-patu kapulu wiri-patu nyina kingi-piya. Ngula-jangka yapa yirdi Jiilu kapu yanirni. Yapa nguru-kari nguru-kari kapulurla yanirni purda-nyanjaku, manu kapulu linpangku purda-nyanyi nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Juurda, kapunpa ngurra ngurrju mardarni, manu kapunpa pama panu mardarni ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Kapunpa milpa yalyuyalyu-jarri pama ngarninjarla, manu kapunpa kartirdi yarltiri-jarri lampurnu ngarninja-warnu.” ");
INSERT INTO wbp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ngularla Jakupurlu milki-yunparnu kuruwarri Jupulunukulku: “Jupulunu, nyuntu-nyangu ngurraju kapu yatijarra Jirdanakuju karri kutu-juku ngapa mangkuru wirikiji. Kapu ngurrju ngurra karri yangka pawurtu-watiki kajili jupu-karrimi.” ");
INSERT INTO wbp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ngularla Jakupurlu yunparnu kuruwarri Yijakakulku: “Yijaka, nyuntujunpa tangkiyi pirrjirdi-piya kuja-ka jurnarrpa panu kanja-yani. Ngula-jangka-ka ngunami walyangkalku. ");
INSERT INTO wbp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kuja-piyarlu-yijala kapunparla ngurra ngurrjuku warrirni yungunpa mata nyina. Kapunpa-nyanu wangkami, ‘Yuwa, nyampuju ngurra ngurrju-nyayirni!’ Junga kujaju! Yinyarla ngurrangka kapunpa warrki-jarri pirijina-piya yapa-kariki yungunpa-nyanu mani nyiyarningkijarra.” ");
INSERT INTO wbp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ngularla Jakupurlu milki-yunparnu kuruwarri Taanukulku: “Taanu, nyuntuju kapunpa nyina nyuntukupurdangka-piya-wati. Jinta-kari jinta-kari kapulu-jana wiri-patu nyina nyanungurra-nyangu warlaljaku, manu nyuntu kapunpa-jana wiri-yijala nyina nyuntu-nyangu-watiki. ");
INSERT INTO wbp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Kapunpa kulu-parnta nyina warna-piya kuja-ka nguna yirdiyi-wana. Kaji yapa yanirni nantuwurla yinyarla yirdiyirla, kapu warnangkuju yarlkirni nantuwu-kurlangu mirriji. Kapu nantuwuju juurl-pinyi murrumurru, manu kapu yinya yapa kijirni walya-kurra.” ");
INSERT INTO wbp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“YAAWIYI, payirni karnangkurla Taanuku yungunpa-nganpa warrawarra-kanyi, yapa-karirli kajikalu-nganpa murrumurru-mani.” ");
INSERT INTO wbp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ngularla Jakupurlu milki-yunparnu kuruwarri Kaardukulku: “Kaardu, yapangku kapungkulu nyuntuju putaputa pinyi, manu kapungkulurla puruku jangkardu parnkami. Kala nyuntulurlu kapunpa-jana pinjarla yirrarni, manu kapunpa-jana wajirli-pinyi.” ");
INSERT INTO wbp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ngularla Jakupurlu milki-yunparnu kuruwarri Yaajakulku: “Yaaja, nyuntu-nyangu ngurrangka kapulu pardimi ngurrju-nyayirni miyi kingirli yangka kuja-ka ngarni.” ");
INSERT INTO wbp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ngularla Jakupurlu milki-yunparnu kuruwarri Napatalikilki: “Napatali, kapunpa karnta nantuwu-piya parnkami yuwurrku-wana rarralypa. Nyuntu-nyangu yimiji kapu karri ngurrju-nyayirni.” ");
INSERT INTO wbp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ngularla Jakupurlu milki-yunparnu kuruwarri Jajupukulku: “Jajupu, nyuntuju kapunpa nyina watiya-piya yangka kuja-ka miyi marnikiji-piya pardimi. Kapunpa pirrjirdi nyina watiya-piya kuja-ka karrimi jilangka ngapa yangka ngula-ka tarnnga-juku warrarda nguna, ngula-piya kapunpa nyina. Kapunpa yuparli-piya parrka nyina kuja-ka warrukirdikirdi pardimi pinjingka. ");
INSERT INTO wbp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wati-patu marda kajikangkulu jangkardu yanirni kulukupurda, kajikangkulu marda yuurlarri-kirlirli pantirni kurlarda witawita-kurlurlu. ");
INSERT INTO wbp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nyuntuju kulanpa mirrmirr-karri lani, lawa. Kapunpa lalka-karrimi, manu kapunpa-jana jiily-ngarrirni kurlarda-kurlurlu. Ngaju-nyangu Kaatu kuja-ka pirrjirdi nyina, kapungku yinyi yartarnarri. Kaatuju pirli wiri-piya ngajukuju Yijiralikiji. Kapungku pirrjirdi-mani. Yulkami kaju ngajuku yangka kuja karla jiyipikingarduyu yulkami nyanungu-nyangu jiyipiki. ");
INSERT INTO wbp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ngaju-nyangu Kaatu kapu nyina nyuntu-kurlu. Nyanunguju PIRRJIRDI-NYAYIRNI WITA-WANGU! Kapungku pirrjirdi-maninjarla warrawarra-kanyi, kapungku ngapa yilyamirni yalkiri-ngirli, manu kapungku ngapa yinyi walya-ngurlu kaji purlpurl-pardimi. Nyuntu-parntarlu kapu-jana kurdu panu mardarni, manu nyuntu-nyangu pulukurlu, jiyipirli manu narnukuturlu kapulu-jana kurdu panu-yijala mardarni. ");
INSERT INTO wbp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nyampu kuja karnangku milki-yunparni kuruwarri, ngulaju nyuntuku. Kuruwarri ngaju-nyangu pirrjirdi-jiki pirli wirikiji kuja-ka tarnnga warrarda karrimi. Pirrjirdi-jiki nyiyarningkijarrakuju kuja-ka pirlingka pardimi. Nyurru-wiyi nyuntukupurdangka-paturlungkulu nyuntuju wurnturu yilyaja. Nyampurlu kuruwarrirli kapungku pirrjirdi-mani.” ");
INSERT INTO wbp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ngularla Jakupurlu milki-yunparnu kuruwarri Pinyaminikilki: “Pinyamini, nyuntujunpa warnapari yarnunjuku-piya. Warru nyanyi karla nyiyarningkijarraku mungalyurrurlu. Pinjarla ngarni kajana. Mungangka kuyu-ka pinyi, manu kajana kanyirni kurdukurduku.” ");
INSERT INTO wbp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","12-pala kuruwarri-jana milki-yunparnu Jakupurlu 12-palaku-yijala kaja-nyanu-patuku. Milya-pungu-jana nyiya-piya kujalpalu nyinaja ngurrju-japa, punku-japa, kulu-parnta-japa. Kujanya-jana milya-pungu kuruwarri-kari kuruwarri-kari nyanungurraku milki-yunparninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","32","Ngula-jana Jakupu wangka kaja-nyanu-patuku, “Ngajuju kapurna palimilki. Kajirna palimi, kulajulu milyingka yirraka nyampurla Yijipirla. Kangka pina-julu pirnki-kirra yangka kujalparla karrija Yipiraku Yititiki. Pirnki yinyaju-ka karri Makapilarla kakarrara Mamirikiji ngurrararla Kananarla. Yinya pirnki ngulaju manu Yipuruyamurlu Yipira-kurlangu tala yinja-warnurlu. Yinyarlanya ngaju-nyangu warlaljajulu-jana milyingka yirrarnu. Yinyarla pirnkingka kalu nguna ngajuku warringiyi Yipuruyamu manu nyanungu-parnta Jiira. Ngajukupalangu Yijaki manu ngati Ripika manu ngaju-parnta Liiya, yinyarla kalu nguna. Milyingka yirrakajulu yinyarlanya ngajuju.” ");
INSERT INTO wbp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ngula-jana Jakupu kuja wangkaja nyanungu-nyangu kaja-nyanu-patuku, wari-yanu pina pangki-kirra, ngula ngunanjunu, ngula ngaanypaku lawa-jarrija, ngula palijalku. ");
INSERT INTO wbp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kuja Jakupu palija, Jajupu wardu-karrija nyanungurla manu nyunjurnu. Yulajalparla nyanunguku kirdanaku. ");
INSERT INTO wbp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Yinya ngurrararla Yijipirla, ngangkayi-kirlirli kalalu-jana jarangku manu mirrijinirli maparnu palka nyurnungka 40-pala parraku milyikingarntiji. Kujarlunya kalalu-jana linji-manu palkaju, manu kalalu warurnu jurnarrparla pukulyu-jarrinja-kujaku. Junga-juku, Jajupu-jana wangkaja ngangkayi-kirli-patuku yangka kuja kalalurla nyanunguku warrki-jarrija, “Kangkalu ngajuku kirdana-kurlangu palka, manu wurdujarra-mantalu milyikingarnti.” Jungajukulu yinya wati-paturlu kangu Jakupu-kurlangu palkaju. 40-pala parrakulu maparnu jarangkuju manu mirrijinirli, warurnulu jurnarrparla, manulu linji-manu pukulyu-jarrinja-kujaku. Ngulalu milyingka yirrarnu. Yuwayi, yinya Yijipi-wardingki-patulu nyinaja malamalarla Jajupukupalanguku 70-pala parraku. ");
INSERT INTO wbp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ngula-jangka, Jajupu-jana wangkaja kingi-kirlangu warrkini-watiki, “Kajinkijili ngajuku yulkami, yimi-ngarrirninjakulurla yanta kingiki, ");
INSERT INTO wbp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ngajuku kirdana kujalpa nyinaja wankaru-wiyi, wangkajarnarla yungurna palka nyanungu-nyangu pina-kanyi Kanana-kurra. Wangkajarnarla kapurna milyingka yirrarni pirnkingka kuja-nyanu nyanungurlu pangurnu. Jarraly-pungkaju ngajuju yungurna kirdana milyingka yirrarni yinyarla. Kapurna ngula-jangkaju pina-yanirni.’” ");
INSERT INTO wbp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ngularla kingilki wangkaja Jajupuku, “Ngurrju kujaju. Milyingka yirrarninjinka nyuntukupalangu ngurrara nyanungu-nyangurla.” ");
INSERT INTO wbp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Yapa panulu pina-yanu Jajupu-kurlu Kanana-kurra milyingka yirrarninjaku nyanungukupalanguku. Kingi-kirlangu warrkini-watili yanu, manu paaju-wati, manu yangka wiri-wati Yijipi-wardingki-patu yanulu Jajupu-kurlu. Timinarlalu yanu panu-kariji, manu panu-kariji karrinja-yanu nantuwu-kurlangu wirli-jarra-kurlurla. Jajupu-kurlangu warlalja manu nyanungukupurdangka-patu manu yapa panu kujalpalu nyinaja nyanungukupalangu-kurlu Jakupu-kurlu, pinalu yanu Kanana-kurra. Yampijalu-jana kurdukurdu manu jiyipi, narnukutu manu puluku purdangirli Kujunurla. ");
INSERT INTO wbp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kujalu yukajarra Kananarla, yanulu ngurra-kurra yirdi-kirraju Yatata-kurra. Kakarrara-purda karruku Jurdunukuju. Yalirlanya kalalu kipurnu ngurlu miyikiji. Jajupuju-jana yalirlanya yapakuju yirrkinpa-nyinaja 7-pala parraku. Kuja-purulpalurla kilji-nyayirni yulaja Jakupukuju, manu Jajupurlulpa yunparnu yirrarurlu, manulpa purlapa pungu malamalarla. ");
INSERT INTO wbp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanana-wardingki-patu yapangkulu-jana nyangu Yijipi-wardingki-patu malamala wiringka yinya Yatatarla, manu wangkajalu-nyanu, “Yinyarra Yijipi-wardingki-patu yarlparu wiri-nyayirni kalu nyina kujalu yapa marda wajawaja-manu.” Kuja-jangkanya yinya ngurraju yirdiji ‘Yapulu-Mijirayimi’. ");
INSERT INTO wbp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Ngula-jangka, Jakupu-kurlangu kaja-nyanu-paturlulu milyingka yirrarnu yangka kuja-jana nyanungu kamparru-wiyi wangkaja. Milyingka yirrarnulu pirnkingka yirdingkaju Makapilarla. Nyampuju nguru kuja manu Yipuruyamurlu tala-kurlurlu Yipira-kurlangu Yititi-kirlangu. Nyanungurlu manu yinya nguru nyanunguku warlaljaku milyingka yirrarninjaku. ");
INSERT INTO wbp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Malamala-jangka, Jajupu manu yapa-patu-karili yanu pina Yijipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jajupukupurdangka-patulu-nyanu wangkaja, “Ngalipajurlipa yapunta-jarrijalku. Marda Jajupuju kangalpa kulu-juku nyina. Marda kapu-nyanurla pina-kunka-mani kujarlipa ngaliparlu puuly-mardarninjarla yilyajarni pirijina nyampu-kurra Yijipi-kirra. Nyarrpa-jarrimilkirlipa?” ");
INSERT INTO wbp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ngulalurla yimi yilyaja Jajupuku, wangkajalurla, “Palinjakungarnti, ngalipakupalangu-nganpa kuja wangkaja, ");
INSERT INTO wbp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nyurrurlajunkulu punku-nyayirni! Nyurunyuru-jarrijalpankulurla Jajupukuju, manunkulu murrumurru-manu. Wangkayalurla Jajupuku yungu-nyarra yawuru-jarrinjarla yampimi kunka-maninja-wangurlu.’ Kujanya-nganpa wangkaja ngalipakupalanguju. Warlkirni karnangkulu nyuntukuju yungunpa-nganpa yawuru-jarrinjarla yampimi kunka-maninja-wangurlu. Purami karnalu jinta-juku Kaatuju kujalpa ngalipakupalangurlu puraja.” Kuja-jana Jajupurlu kuja purda-nyangu, yulajalpa nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ngulalurla Jajupukupurdangka-patu parntarrinjunu nyanungurla kamparru. Wangkajalurla, “Nyuntukulku karnangkulu nyina, kapurnangkulu warrki-jarrimi pirijina-piya.” ");
INSERT INTO wbp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Jajupu wangkaja-jana, “Lawa, kulalu lani-jarriya ngaju-kujaku! Ngaju kularna Kaatu! Kularna-nyarra pakarni! ");
INSERT INTO wbp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nyurru-wiyi kapunkujulu pakakarla. Kaaturluju ngajuju mardarnu yungurna-jana yapaku ngurrju nyina manu yungurna-jana mardarni, kapulurla paliyarla yarnunjuku. Junga kujaju. Kapunkujulu ngajuju pakakarla, Kaaturluju ngajuju milarnu yungurna-jana yapa mardarni wankaru jalangurluju. ");
INSERT INTO wbp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kujarlaju, kulajulu ngajuku lani-jarriya! Kapurna-nyarra warrawarra-kanyi nyurrurla manu nyurrurla-nyangu kurdukurdu.” Kujalu Jajupukupurdangka-paturlu purda-nyangu nyanungu-nyangu yimi, ngurrju-jarrijalkulu wajampa-wangu. ");
INSERT INTO wbp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","26","Jajupuju warrardalpa nyinaja tarnnga Yijipirla, manu purlka-jarrijalku. Nyanungu-nyangu kaja-nyanurlu Yipirayimirli mardarnu-jana kurdukurdu manu warringiyi-patu. Manu Jajupu-kurlangu kaja-nyanurlu Manajarlu mardarnu kaja yirdiji Makirri. Makirrirli kurdu panu-jarlu-jana mardarnu. Jajupurlu-jana rdakurl-kujurnu nyanungu-nyangulku. Palinjakungarnti, Jajupu-jana wangkaja nyanungukupurdangka-patuku, “Kapurna ngajuju palimilki. Kaaturlu kapu-nyarra warrawarra-kanyi-jiki nyurrurlaju. Kapu-nyarra nguru-kanyi nyurrurlaku manu nyurrurla-nyangu warlaljaku nyampu-ngurlu nguru-ngurlu Yijipi-ngirli, manu kapu-nyarra nguru-kanyi Kanana-kurra kuja-jana jangku-pungu nyurru-wiyi Yipuruyamuku, Yijakiki manu Jakupuku. Wangkayajulu kajirna palimi yungunkujulu yungkurnu kanyi kajinkili pina-yani Kanana-kurra.” Ngula-jangka, Jajupuju palijalku 110-pala-jangka yulyurrpu-jangkalku. Ngangkari-kirlirlilpalu maparnu palka jarangku manu mirrijinirli, warurnulu jurnarrparla yungulu milyingka yirrarni Yijipirla. Nyampurlanya-ka lawa-jarrimi yimi Jajupu-kurluju. ");
INSERT INTO wbp_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Yinya purlka-pardu Jakupu, yirdi jinta-kariji Yijirali. Kuja yanu Yijipi-kirra, kangu-jana nyanungu-nyangu kaja-nyanu-wati manu warlalja-wati nyanungu-kurlu 70-pala panu-juku. Nyampurranya yirdi nyanungu-nyangu kaja-nyanu-watiji: Ruupunu, Jimiyani, Liipi, Juurda, Yijaka, Jupulunu, Pinyamini, Taanu, Napatali, Kaardu manu Yaaja. Jakupu-kurlangu kaja-nyanu-karijilpa Jajupu nyurru-juku nyinaja Yijipirla tarnnga-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Jujupuju palija Yijipirla. Yapa panu-karirlangu kujalu yanurnu Yijipi-kirra Jakupu-wana, ngulajulu palija-yijala. Kala nyanungurra-nyangu kurdukurdu nyinajalpalu yalumpu-wardingki Yijipirlaju tarnnga-juku yulyurrpuku 300-palaku. ");
INSERT INTO wbp_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Yalirra Yijirali-pinkirlilpalu-jana mardarnu panu-nyayirni kurdukurdu. Pirrjirdi-jarrija-nyayirnili, manu panu-nyayirnilpalu nyinaja warru kirri-kari kirri-karirla Yijipirlaju. ");
INSERT INTO wbp_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ngaka-pardu-kari, wati jinta-karilki kingi-jarrija Yijipi-wardingki-patuku yapaku. Kula milya-pungu jaru Jujupu-kurlu kujalpa nyurru-wiyi nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Parra jintangka wangkaja-jana kapumanu-patu paaju-watiki, “Yuwa, nyangkalu-jana Yijirali-pinki! Panu-jarlu-nyayirni, manu kalu pirrjirdi nyina! Kajikalu-ngalpa kulungku pinyi! ");
INSERT INTO wbp_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Marda kajili-ngalpa ngurra-kari-wardingki jangkardu yanirni pinjaku, kajikalu Yijirali-pinkiji nyanungurra-kurlu jinta-jarri, marda kajikalu-ngalpa pinyi! Kajikalu-ngalpa jurnta wuruly-parnkami ngurra-kari-kirra! Nyarrpa-jarrimirlipa? Nyarrparlurlipa-jana warla-pajirni panu-jarrinja-kujakuju?” ");
INSERT INTO wbp_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Junga-juku, kingirli manu paaju-watirlili-jana jinyijinyi-manu Yijirali-pinki warrki-jarrinjaku pirijina-piya. Milarnulu-jana wati yungulu-jana jinyijinyi-mani Yijirali-pinki warrki-jarrinjaku. Jinyijinyi-manulu-jana ngurra-jarra wiri-jarraku ngantarninjaku yirdi-jarrarlaju Pijamarla manu Ramijirla kingiki nganta. Yijipi-wardingki-paturlu kalalu ngurlu panu turnu-maninjarla yirrarnu yalumpu-jarrarla ngurra-jarrarlaju. ");
INSERT INTO wbp_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yuwayi, kalalu-jana Yijirali-pinkiji jinyijinyi-manu warrarda warrkiki. Kalalu-jana pakarninjarla murrumurru-manu, manu kalalu-jana kurdu mardarninja-kujaku puta warla-pajurnu, kala lawa. Yijirali-pinkirliji kalalu-nyanu wurrangku-juku mardarnu kurduju panu-jarlu. Kalalu pirri-yanu muku Yijipirlaju. Kujarlanyalpalu Yijipi-wardingki-patuju lani-jarrija nyanungurra-kujakuju. ");
INSERT INTO wbp_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Pakarninjarlalpalu-jana Yijirali-pinkiji wurrangku-juku jinyijinyi-manu warrki-jarrinjaku. ");
INSERT INTO wbp_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Jinyijinyi-manulpalu-jana yuwarli panu ngurrju-maninjaku pirli-jangka kujalu pirikiji ngurrju-manu walya-jangka marna-jangka. Kalalu-jana jinyijinyi-manu walya pangirninjaku miyi pardinjaku. Kulalu-jana Yijipi-wardingki-patuju mari-jarrija yangka kujalpalu warrki-jarrija mata-wangu. ");
INSERT INTO wbp_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Karnta-jarra jija-jarra jirrama Yipuru-jarraju kala-pala nyinaja yinyarla ngurrangka. Yirdi-jarraju Jiparra manu Puwa. Yangka kuja kalalu-jana kurdu pirltirrka mardarnu Yipuru-paturlu karntakarntarlu, kurdu palka-jarrinjakungarntiji kalalu-jana nyanungu-jarraju jija-jarraju jirrnganja nyinaja karnta wartardi-patuku. Parra jintangka, Yijipi-wardingki kingi-palangu wangkaja jija-jarraku, ");
INSERT INTO wbp_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Kajinpala Yijirali-pinki karntakarnta-kurlu nyina, yangka kuja kalu kurdu pirltirrka mardarni, kajili-jana karntakarnta mardarni, ngulajulu-jana yampiya karnta pinja-wangurlu. Kala kajili-jana wirriyawirriya mardarni, ngulajulu-jana pakaka!” ");
INSERT INTO wbp_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kala-pala yinya-jarrarlu jija-jarrarlu puraja Kaatu, manu kala-pala yirriyirrirli purda-nyangu. Kujarlanya kula-pala purda-nyangu kingiji. Kulalpalu-jana pungu wirriyawirriya kujalu palka-jarrija. ");
INSERT INTO wbp_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kingirli yilyaja warrkini jinta maninjaku jija-jarraku. Kuja-pala yanurnu kingi-kirlangu-kurra, payurnu-palangu, “Nyiya-jangka kulanpajupala purda-nyangu? Wangkajarnangkupala pinjaku wirriyawirriyaku. Lawa, wankaru kankulu-jana mardarni.” ");
INSERT INTO wbp_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Jija-jarra-palarla wangkaja, “Yipuru-patu karntakarntaju kalu pirrjirdi nyina Yijipi-wardingki-patu-piya-wangu. Kurdu kalu-jana kapankurlu mardarni. Wangkami kalu-nganpa ngajarraku yungurlujarra yaninjarla nyina nyanungurra-kurlu kurdu palka-jarrinjakungarnti. Kala kapankurlu-juku kalu-jana mardarni kurduju ngajarra-wangurla-wiyi!” ");
INSERT INTO wbp_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Yuwayi, yinya-jarra jija-jarrarlu-pala Kaatuju jungangku purda-nyangu. Kuja-jangkaju, Kaaturlu-palangu kurdukurdu panu yungu nyanungu-jarraku. Yijirali-pinkirlijilpalu mayangku-juku kurdukurduju mardarnu. ");
INSERT INTO wbp_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ngaka-pardu-karilki, kingi-jana wangkaja nyanungu-nyangu yapaku, “Purda-nyangkajulu! Kajili-jana Yipururlu karntangku kurdu wirriyawirriya mardarni, maninjarla kijikalu-jana karru wiri-kirra yirdi-kirraju Niili-kirra yungu-jana ngawarrarlu kanjarla pinyi! Yampiyalu-jana karntakarnta pirltirrkaju pinja-wangurlu!” ");
INSERT INTO wbp_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ngula-puruju wati nyinajalpa warlalja turnu-warnurla Liipi-kirlangurla. Karnta yupukarra-manu turnu-warnu-jangka jurrku-jangka. ");
INSERT INTO wbp_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ngakalku miyalu-jarrija, ngula kurdu wirriya mardarnu. Yuntardi-nyayirni, kala kaninjarni yuwarlirla wuruly-mardarnu Yijipi-wardingki-patu-kujaku, kajikalu maninjarla pinyi. ");
INSERT INTO wbp_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Marnkurrpa-jangka kirntangi-patu-jangka, ngati-nyanurlu kulalpa nyarrparlu wuruly-yirrakarla pirltirrkaju kaninjarni yuwarlirla. Ngati-nyanurlu manu yakuju wita parraja-piya, manu palyangku maparnu yungu ngapangka kankarlu warru yani yukanja-kujaku. Yirrarnu kurduju kaninjarni witangka, manu kangu karru-kurra kujalpalu marna kirrirdikirrirdi karrija ngapangka. Yirrarnu ngapangka kulkurru marna kirrirdi-wana yungu nguna yapa-kujaku nyanja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Yinya kurduku kapirdi-nyanurlulpa puranja-yanu purdangirli-wanarlu. Kutulpa karrija, ngulalpa ngati-nyanuju nyangu karrinjarla kuja yakuju parraja-piya yirrarnu ngapangka. Manngu-nyangu nyanungurluju, “Nyarrpa-jarri marda kapu kukurnuju?” ");
INSERT INTO wbp_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ngula-jangka, Yijipi-wardingki kingiki yurntalu-nyanu yanurnu karru-kurraju parljirninjaku. Wapanja-yanulpa karru-wana karnta warrkini-patu-kurlu marna kirrirdikirrirdi-wana. Nyangulku yangkaju yakuju parraja-piya ngapangka, manurla wangkaja warrkiniki karntaku maninjaku. ");
INSERT INTO wbp_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Maninjarlarla kangurnu kingi-kirlangu yurntalu-nyanuku. Kuja raa-pungu, nyangu wirriya kurdu kaninjarni. Nyanungujulpa yulaja, ngularla mari-jarrija. Wangkajarla karnta warrkiniki, “Waraa! Nyampuju kurdu Yipuru-patu-kurlangu!” ");
INSERT INTO wbp_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kurduku kapirdi-nyanurlu yaninjarla japurnu, “Yuwa, maninjini mayirna Yipuru karnta yungungku kurdu nyampu warrawarra-kanyi nyuntuku?” ");
INSERT INTO wbp_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kingiki yurntalu-nyanurla wangkaja, “Yuwayi, ngurrju! Maninjinta!” Kaminarlu yinyarlu yaninjarla manunjunu kurdukupalangu ngati-nyanu, manu kangurnu karru-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kingiki yurntalu-nyanurla wangkaja, “Kangka nyampu kurdu, manu lampurnurla yungka! Kapurnangku tala yinyi kujakuju.” Junga-juku, kangu kurduju ngurra-kurra, manu lampurnulparla yungu. Wiri-manu jirramaku yulyurrpuku marda marnkurrpaku. ");
INSERT INTO wbp_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ngula-jangkaju, kujalpa wirriyarlu ngarnu miyi manu kuyu, ngula-jangkaju ngati-nyanurlu pina-kangurla Yijipi-wardingki kingiki yurntalu-nyanuku, manurla pina-yungu nyanunguku. Ngula-nyanu rdakurl-kujurnu nyanungukulku kaja-nyanu. Yirdijirla yirrarnu Mujuju. Ngulaju yirdiji kuja ‘Wilypi-manurna Ngapangka’. ");
INSERT INTO wbp_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mujujuju wiri-jarrinjarla wati-jarrijalku. Ngula parra jintangka yanu ngurra-kurra kujalpalu nyanungu-nyangu ngurrara-jinta Yipuru yapa warrki-jarrija. Nyangu-jana Yijipi-wardingki-patu kujalpalu-jana jinyijinyi-manu warrki-jarrinjaku. Jintangku Yijipi-wardingkirlilpa pinjarla yirrarnu warrkini jinta Yijirali-pinki wati Mujuju-piya-juku. ");
INSERT INTO wbp_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mujujurlu warru nyangu yapa ngalya-kari-kijaku. Lawa, kulalpa ngana nyangu. Ngula pungulku yinya Yijipi-wardingki, rdaku pangirninjarla milyingka yirrarnu walyirirla. Ngula pina-yanu ngurra-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Parra-karirla, Mujujuju pina-yanu ngurra yangka-kurra-yijala, manu nyangu-palangu Yipuru-jarra wati-jarra, kulungkulpa-pala-nyanu ngarrurnu. Kuja jinta-karirliji pakarnu, Mujujurla wangkaja watiki kuja pakarnu jinta-kari, “Yuwa! Nyiya-jangka kanpa pakarni nyampuju? Nyuntu-jarrajunpala Yipuru-jarra-juku!” ");
INSERT INTO wbp_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Watingki yalu-manu Mujuju, “Nganangkungku nyuntuju milarnu kuwurtukungarduyu-piya nganta nganimpaku warla-pajirninjaku kulu-kujakuju? Kapunpaju pinyi mayi yangka-piya Yijipi-wardingki-piya kujanpa pungu pirrarnirli?” Kuja Mujujurlu kuja-kurra purda-nyangu, nyanunguju lani-jarrija-nyayirni, manu-nyanu wangkaja, “Waraa! Marda kalu panungku milya-pinyi kujarna wati yangka pungu!” Ngula wuruly-parnkaja Yijipi-ngirliji wurnturu-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kingirli purda-nyangu kuja Mujujurlu pungu Yijipi-wardingki. Junga, wangkaja-jana nyanungu-nyangu-patuku yurrkunyu-patuku pinjaku Mujujuku. Kala lawa. Kulalu palka-manu nyanunguju. Nyurru-juku wuruly-parnkaja Yijipi-ngirliji. Yaninja-yanu-jukulpa ngurra-kurra yirdi-kirraju Mirdiyanu-kurra. Nyinaja warrarda yinyarla-juku muljungka. ");
INSERT INTO wbp_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Yinyarla ngurrangka Mirdiyanurla kala wati jinta nyinaja yirdiji Juturru. Nyanungu-nyangu yirdi jinta-kariji Ruulu. Nyanunguju maralypikingarduyu, mardarnulpa-jana wirlki-pala yurntalu-nyanu. Kalalurla warrawarra-kangu jiyipi-wati, manu kalalu-jana kangu mulju-kurra ngapa ngarninjaku. Parra jintangkalu yanurnu ngapa maninjaku, ngulajulpalu ngapa puta winjurnu parraja wiri-piya-kurra jiyipi-watikiji. ");
INSERT INTO wbp_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kala panu-kari jiyipikingarduyu-patulu yanurnu, manulu-jana jaarl-manu ngapa karntakarntaku jiyipi-kirliki. Karnta-patu yinya-patu kulalu ngapa-kurraju kutu-jarriyarla. Mujujurlu-jana nyangu, manu-jana wajirli-pungu yinya jiyipikingarduyu-patu ngula-jana ngapalku manu jiyipi-patuku. ");
INSERT INTO wbp_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ngulalu yinya karntakarnta pina-yanu ngurra-kurra kirda-nyanu Juturru-kurra. Nyanungurlu-jana payurnu, “Yuwa, nyiya-jangkankulu pina-yanurnu kapankuju? Kula wantaju kanunju-jarrija murnma-juku. Kula-ngantalpankulu-jana murnma-juku ngapaju yungu jiyipikiji muljungkaju.” ");
INSERT INTO wbp_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Karnta-paturlulu yalu-manu, “Jiyipikingarduyu-paturlulu-nganpa jaarl-manu muljuju. Yijipi-wardingki watingki-jana wajirli-pungu muku. Ngula-jangka-jana ngapalku yungu jiyipi-watiki.” ");
INSERT INTO wbp_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ngula-jana payurnu, “Nyarrparalku nyampuju wati? Nyiyakunkulu yampinja-yanu purdangirliji? Maninjintalu yungu ngarni ngalipa-kurlurlu!” Ngula-jangka, yanunjunurnulu Mujujuju. ");
INSERT INTO wbp_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mujujuju yanurnu Juturru-kurlangu-kurra yuwarli-kirra, ngulalpa nyinaja Juturru-kurlangu warlalja-kurlu. Juturrurlurla yungu nyanungu-nyangu yurntalu-nyanu Jipura Mujujuku yupukarra-jarrinjaku. ");
INSERT INTO wbp_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ngaka, Jipurarlu kurdu wirriya pirltirrka mardarnu, ngula Mujujurlu yirdi-manu Kurrjama Mujuju-nyanu wangkaja, “Ngajujurna yapa-kari nguru nyampurlaju. Kujarlanya karna yirdi-mani ngaju-nyangu kaja-nyanuju Kurrjama.” ");
INSERT INTO wbp_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ngakalku, yulyurrpu-patu-jangka palijalku Yijipi-wardingkiji kingiji. Yijipi-wardingki-paturlujulpalu-jana jinyijinyi-manu-juku Yijirali-pinkiji warrki-jarrinjaku, manulpalu-jana murrumurru-manu-nyayirni. Yulanjarlalpalu warlkurnu Kaatu yungu-jana muurl-mardarni Yijipi-wardingki-kijaku. ");
INSERT INTO wbp_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Kaaturlu-jana purda-nyangu yulanja-kurra, ngula-jana manngu-nyangu nyanungurra-nyangu-patu nyurnunyurnu-patu Yipuruyamu, Yijaki manu Jakupu. Wangkaja-jana kamparru-wiyi kapu-jana tarnngangku-juku warrawarra-kanyi nyanungurrarlangu. ");
INSERT INTO wbp_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Yuwayi, Kaaturlu-jana nyangu Yijirali-pinki warrki-jarrinja-kurra pirijina-piya Yijipirla, ngulalpa-jana wajampa-jarrija-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mujujurlu kala-jana warrawarra-kangu jiyipi manu narnukutu nyanunguku lamparra-nyanu-kurlangu Juturru-kurlangu. Juturrujulpa nyinaja maralypikingarduyu ngurrangka Mirdiyanurla. Parra jintangka, Mujujurlu-jana nguru-yirrarnu jiyipiki manu narnukutuku jilja-wana ngulalu kutu-nyayirni yanurnu pirli wiri-kirra tarruku-kurra yirdi-kirraju Jayinayi-kirra. ");
INSERT INTO wbp_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Yinyarlanya warraja-jarrija YAAWIYI Kaatu-kurlangu marramarraju, milki-yirrarnu-nyanu Mujuju-kurra. Watiya wita parrka-kurlu kampajalpa jarra wiri-kirli. Mujujurlu nyangu jankanja-kurra, kulalpa jankaja junga-nyayirni, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mujuju-nyanu wangkaja, “Waraa! Nyiya nyampuju? Nyampuju-ka jankami-jiki-jala-ngarra! Kala lawa, yukuri-jiki-ka karrimi. Kutu-ngurlu karna nyanyi nyiya marda!” ");
INSERT INTO wbp_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Watiya kulkurru-jarra-ngurlu kujalpa jankaja, ngula-ngurlu YAAWIYI-rli nyangu Mujuju yaninjarni-kirra, ngularla wangkaja nyanunguku, “Mujuju, Mujuju!” Mujujurlu yalu-manu, “Nyiyaku-wiyi?” ");
INSERT INTO wbp_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ngularla Kaatulku wangkaja, “Kutu-jarrinja-wangu ngulangka-juku karriya! Nyampurlaju kanpa karrimi maralypi-nyayirnirla ngaju-nyangurla. Kujarlaju, rurruny-pungka jamana-kurlangu nyuntu-nyangu. ");
INSERT INTO wbp_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ngaju karna-jana nyinami Kaatuju nyampurra-patuku Yipuruyamukuju manu Yijakikiji manu Jakupukuju nyurnunyurnukuju yangka kujalpalu nyinaja nyurru-wiyi.” Mujujuju lani-jarrija-nyayirni Kaatu-kujaku nyanja-kujaku, ngula-nyanu jurnarrpalku parnta-yirrarnu yinngirrirla. ");
INSERT INTO wbp_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ngularla YAAWIYI-lki wangkaja Mujujuku, “Nyanyi karna-jana Yijipi-wardingki-patu kuja kalu-jana murrumurru-mani ngaju-nyangu yapa, manu kalu-jana jinyijinyi-mani warrki-jarrinjaku. Purda-nyangurna-jana kujalpajulu ngajuku yulaja yungurna-jana muurl-mardarni. Milya-pinyi karna-jana kuja kalu murrumurru wiri nyina. ");
INSERT INTO wbp_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kujarlanyarna yanurnu nguru-nyayirni-wangu-jangkaju. Ngajurna yanurnu yungurna-jana muku kanyi Yijipi-wardingki-patu-kujaku. Kapurna-jana kanyi Yijipi-ngirliji, manu kapurna-jana nguru-yirrarni nguru ngurrju-kurra kuja kalu miyi jaya-kurra nguna. Jalangu yapa panu-kari kalu nyina yinyarla ngurrangka Kanana-wardingki-wati, Yititi-wati, Yamuri-wati, Piriji-wati, Yiipiti-wati manu Jipuji-wati. ");
INSERT INTO wbp_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yuwayi. Purda-nyangurna-jana ngaju-nyangu yapaju yulanja-kurra. Milya-pinyi-jala karna-jana yangkaju kuja kalu-jana Yijipi-wardingki-paturlu jinyijinyi-mani warrkiki yungulu warrki-jarrimi pirijina-piya. ");
INSERT INTO wbp_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kujarlanya karnangku yilyami nyuntuju kingi-kirraju yungunpa-jana ngaju-nyangu yapa kanyi yinya-ngurlu Yijipi-ngirli nguru-kari-kirra. Yanta yaruju! Maninjinta-jana jalangurlu-juku!” ");
INSERT INTO wbp_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mujujurlu wurra-manu Kaatuju, manurla wangkaja, “Kularna ngajuju wiri-jarlu! Kulaju kingirliji purda-nyanyi! Kulalparna-jana nyarrparlu yinyaju Yijirali-pinki kangkarla Yijipi-ngirliji, lawa!” ");
INSERT INTO wbp_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ngularla Kaatulku wangkaja nyanungukuju, “Ngaju kapurna yani nyuntu-kurlu Yijipi-kirraju. Kajinpa-jana kanyirni ngaju-nyangu yapa yinya-ngurlu, kangkarni-jana nyampu-kurra pirli-kirra yungunkujulurla pulka-pinyi. Yapangku kapulu milya-pinyi kujarnangku ngajulurlu yilyaja.” ");
INSERT INTO wbp_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ngula Mujujurlu japurnu Kaatu, “Yuwayi. Kapurna-jana yaninjarla kuja wangkami, ‘Yangka Kaatu kujalpalu ngalipakupalangurlu puraja nyurru-wiyi, ngulangkuju yilyajarni nyampu-kurraju.’ Kajirna-jana kuja wangkami, kapujulu kapuru nyinanjarla japirni, ‘Yuwa! Nyiya yirdi nyanunguju, manu nyiya-piya nyanunguju?’ Kujarlu kapujulu payirni. Nyarrpalkurna-jana wangkami? Nyiyanpa nyuntuju yirdi?” ");
INSERT INTO wbp_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ngularla Kaatulku wangkaja, “NGAJU-JURNA JUKURRARNU. Ngaju-nyangu yirdiji YAAWIYI. Wangkaya-jana yinya yapaku kujarnangku ngajulurlu YAAWIYI-rli yilyajarra. ");
INSERT INTO wbp_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","16","Yimi-ngarrika-jana ngajuju yangka-juku Kaatu kujalpalu puraja nyurrurlakupalangurlu nyurnu-paturlu Yipuruyamurlu, Yijakirli manu Jakupurlu. Wangkaya-jana kujarnangku ngajulurlu yilyaja yungunpa-jana nguru-yirrarni Yijipi-ngirliji. YAAWIYI ngaju-nyangu yirdiji tarnnga-juku. Jalangu-jangkanya yungulpajulu yirdi-mantarla YAAWIYI. Yajarninjinta-jana purlka-patu Yijirali-pinki. Wangkaya-jana kujarnaju milki-yirrarnu ngaju nyuntu-kurra manu kujarnangku wangkaja. Wangkaya-jana kujarna-jana nyangu Yijipi-wardingki-patu jinyijinyi-maninja-kurra manu murrumurru-maninja-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ngajulurlu kapurna-jana pina-kanyirni ngaju-nyangu yapa Yijipi-ngirli kuja kalu-jana murrumurru-mani-nyayirni. Kapurna-jana nguru-yirrarni ngurra ngurrju-kurra kuja-ka miyi jayakurra nguna. Jalangu yapa panu-kari kalu nyina yinyarla ngurrangka Kanana-wardingki-wati, Yititi-wati, Yamuri-wati, Piriji-wati, Yiipiti-wati manu Jipuji-wati. Kapurna-jana ngurra jurnta kanyi, manu kapurna-jana yinyi ngaju-nyangu yapaku.” ");
INSERT INTO wbp_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ngularla Kaatu wangkaja Mujujuku, “Kajinpa-jana yimi nyampu wangkami ngaju-nyangu yapaku, kapungkulu purda-nyanyi. Ngula-jangka, nyuntu manu purlka-patu Yijirali-pinkilirla yanta kingiki Yijipi-wardingkiki, kujalurla wangkaya, ‘Nganimpa Yipuru-paturlu karnalu purami Kaatu yirdiji YAAWIYI. Milki-yirrarnu-nyanu nganimpa-kurra. Yungurnalu jilja-kurra yani marnkurrpaku parraku, ngulangka yungurnalurla kuyu purrami YAAWIYI-ki. Yungurnalurla pulka-pinyi yinyarla-juku. Ngurrju mayi kajirnalu yani yinya-kurra?’ Kujanyalurla wangkaya nyuntu manu yinya purlka-patu kingikiji. ");
INSERT INTO wbp_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Kingi yinyarlu kulangku purda-nyanyi. Kapu-nyarra warla-pajirni jilja-kurra yaninja-kujaku. Kuja-kujakuju kapurna jinyijinyi-mani yungungku nyuntu purda-nyanyi wangkanja-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kala ngaju-nyangu-kurlurlu yartarnarri-kirlirli kapurna jinyijinyi-mani nyurrurlaku yilyanjaku. Kapurna-jana murrumurru-mani-nyayirni yinyaju Yijipi-wardingki-patu yungujulu lani-jarrimi-nyayirni ngajuku. Ngula-jangka, kapu-nyarra kingirli yilyamilki Yijipi-ngirliji. ");
INSERT INTO wbp_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Yuwayi, yinyarra Yijipi-wardingki-patu kapulu-nyarra lani-jarrimi nyuntuku manu Yijirali-pinkiki. Kujarlaju kajinkili nyurrurla yapa-paturlu yampinja-yani Yijipi, kulankulu rdaka-jarra yani, lawa. Laningki kapulu-nyarra nyiyarningkijarra yinyi. ");
INSERT INTO wbp_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Yijipi yampinjakungarntirli Yijirali-pinki karntakarntarlu kapulu-jana japirni Yijipi-wardingki-patu karntakarnta kuja kalu kutu nyina marda yangka kuja kalu-jana warrki-jarri nyanungurra-nyangurla ngurrangka. Kapulu-jana japirni jurnarrpaku manu waninja-kurlanguku manu rdaka-kurlanguku kujalu ngurrju-manu pirli yaltiri-jangka manu kawurlu-jangka. Yijipi-wardingki-paturlu karntakarntarlu kapulu-jana yinyi Yijirali-pinki karntakarntaku, manu kapulu-jana Yijirali-pinkirli karntakarntarlu yinyi nyanungurra-nyangu yurntalu-nyanuku manu kaja-nyanuku. Kujarlunya kapulu-jana Yijirali-pinkirliji jurnta kanyi nyiyarningkijarraju Yijipi-wardingki-patukuju.” Kujanyarla wangkaja Kaatuju Mujujukuju. ");
INSERT INTO wbp_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mujujurla wangkaja YAAWIYI-ki, “Yijirali-pinkirli, kula mardajulu purda-nyanyi ngajuju. Kalakajulu marda wangka, ‘Lawa, kula-nyanu YAAWIYI-rli milki-yirrarnu nyuntu-kurra!’ Kajijili kuja ngajuku wangkami, nyarrpalkurna-jana wangkami ngajuju nyanungurrakuju?” ");
INSERT INTO wbp_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ngula YAAWIYI-rlilki payurnu, “Nyiya ngulaju nyuntu-nyangu rdakangka?” Mujujurlu yalu-manu, “Ngaju-nyangu watiya jukati nyampuju.” ");
INSERT INTO wbp_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ngularla YAAWIYI-lki wangkaja, “Kijika walya-kurra!” Junga-juku, Mujujurluju kujurnu watiyaju walya-kurra. Ngula kapanku warna-jarrija, manu Mujujuju parnkaja lani. ");
INSERT INTO wbp_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","YAAWIYI-rli warla-pajurnu, manu wangkajarla, “Kula parnkaya! Wipi-ngirli manta!” Junga-juku, Mujujurlu wipi-ngirli manu yinyaju warna. Kuja yungka marnpurnu rdakangku, warnaju pina watiya-jarrija. ");
INSERT INTO wbp_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ngularla YAAWIYI wangkaja, “Kajinpa-jana yani Yijirali-pinkiki, ngulaju kijika watiya jukati nyuntu-nyangu walya-kurra yangka-piyarlu-yijala. Kaji warna-jarri, wipi-ngirli manta yungu watiya-jarrimi pina. Kajingkili nyanyi kuja-kurra, ngulaju kapungkulu nyanjarla ngungkurr-nyinalku nyuntu-nyangu yimikiji. Yimi-ngarrirni kapunpa-jana ngajulurlu YAAWIYI-rlirnaju milki-yirrarnu nyuntu-kurra. Kapunpa-jana yimi-ngarrirni ngajuju yangka-juku Kaatu kujalpajulu puraja nyanungurrakupalangurlu Yipuruyamurlu, Yijakirli manu Jakupurlu nyurru-wiyiji.” ");
INSERT INTO wbp_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Rdaka-nyanu yirraka jaatingka!” Junga-juku-nyanu Mujujurluju rdakaju yirrarnu jaatingka. Kuja wilypi-manu pina, ngulaju wijini palka-wangu lipiriji-piya. ");
INSERT INTO wbp_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ngularla YAAWIYI wangkaja nyanunguku, “Rdaka-nyanu pina-yirraka kanunju jaatingka!” Mujujurlu-nyanu rdaka yirrarnu pina kaninjarni jaatingka. Kuja wilypi-manu, ngulaju ngurrjulku wijini-wangu. ");
INSERT INTO wbp_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ngularla YAAWIYI wangkaja, “Kajinpa-jana milki-yirrarni Yijirali-pinkiki yinya watiya jukati kuja-ka warna-jarrimi, marda kulangkulu ngungkurr-nyina kujarnangku ngajulurlu yilyajarra. Manu kajinpa-jana milki-yirrarni nyuntu-nyangu rdaka wijini-kirli, manu kaji ngurrju-jarrimi pina, marda kulangkulu ngungkurr-nyina-juku. ");
INSERT INTO wbp_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kala lawa-juku kajili nyina ngungkurr-nyinanja-wangu nyuntuku, ngulaju ngapa manta karru Niili-jangka, winjika walya-kurra nyanungurra-puru-juku, manu kapu yalyu-jarrimilki.” ");
INSERT INTO wbp_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mujujujulparla jukuru-juku nyinaja YAAWIYI-ki purda-nyanjakuju, wangkajarla nyanunguku, “Ngajurna ngurrpa, kularna-jana nyurru-wiyi yapa panuku wangkaja. Nyuntulurlunpa-nyanu milki-yirrarnu ngaju-kurra, pulya-juku karna wangkami, manu karna yurrkurduju kapakapa-jarri. Kularna milya-pinyi nyarrpa yungurna-jana wangkami.” ");
INSERT INTO wbp_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ngularla YAAWIYI wangkaja nyanunguku, “Ngajujurna YAAWIYI. Ngurrju-manurnangku lirraju. Ngampurrparluju kajikarnangku marnpirni yungunpa nyina wangkanja-wangu manu purda-nyanja-wangu. Manu ngampurrparluju kajikarnangku pampa-mani. Kajilpanpa pampa nyinayarla, kajikarnangku nyanjaku ngurrju-mani pina. ");
INSERT INTO wbp_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kulaju wiljiwilji-manta! Kula-nyanu yurrkurduju-ngarrika! Yanta-jana Yijirali-pinkiki! Ngaju kapurna yani nyuntu-kurlu. Ngajulurlu kapurnangku jungarni-mani nyarrpa yungunpa-jana wangkami.” ");
INSERT INTO wbp_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mujujurlu kulalpa purda-nyangu jukururlu-juku, wangkajarla YAAWIYI-ki, “Waraa! Kulaju ngaju yilyaya! Yilyaya yapa jinta-kari!” ");
INSERT INTO wbp_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","YAAWIYI-jirla kulu-jarrijalku Mujujukuju, manurla wangkaja, “Ngulaju ngula-juku. Ngula-jangkaju kapurnangku nyuntukupurdangka papardi-puraji Yarurnu yilyamirni. Nyanunguju Liipi-kirlangu turnu-warnu-kurlangu. Nyanunguju pirrjirdi-ka wangkami. Kajingki nyuntu nyanyi, kapungku wardinyi-jarrimi-nyayirnilki. ");
INSERT INTO wbp_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","16","Kapurna nyinami palka-juku nyuntu-jarrakuju, manu kapurnangkupala jungarni-mani nyarrpa wangkanjaku. Kapurnangku nyuntu-wiyi jungarni-mani yungunpa nyarrpa wangka, ngula-jangka yimi-ngarrikarla ngaju-nyangu yimi Yarunukulku. Kapungku purda-nyanyi nyuntuju, manu kapungku marlaja wangkami nyuntuku yapa-patu-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kangka nyuntu-nyangu watiya jukati Yijipi-kirra. Kajirnangku ngaju nyarrpa wangkami, jukati-kirlirli-jana milki-yirraka ngangkayi yapa-kurra yungungkulu nyanyi manu yungungkulu milya-pinyi nyuntuju yartarnarri-kirli ngaju-nyangu-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ngula-jangka, Mujuju pina-yanu nyanunguku lamparra-nyanu-kurra Juturru-kurra. Nyanungurla wangkaja, “Lamparra, ngurrju mayi kajirna pina-yani Yijipi-kirraju? Yungurna-jana pina-yani ngaju-nyangu yapaku wankaru-juku-japa kalu nyina.” Juturrurlu yalu-manu nyanunguju, “Yuwayi, ngurrju kujaju. Yanta yaruju! Kaaturlu kapungku warrawarra-kanyi.” ");
INSERT INTO wbp_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mujujuju ngari witaku nyinaja Mirdiyanurlaju, jungarni-manulpa nyiyarningkijarra wurnaku. Ngularla YAAWIYI wangkaja nyanunguku, “Yanta pina Yijipi-kirra yaruju! Yinya-patu wati-patu kujalpangkulu japirdija kulu, ngulajulu palija muku.” ");
INSERT INTO wbp_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mujujurlu-jana manu nyanungu-parnta manu kaja-nyanu-jarra, manu yirrarnu-jana tangkiyirla. Nyanunguju wapanja-yanulpa Yijipi-kirra-pinangu kujalpalu yaninja-yanurnu purdangirli-wana tangkiyirla. Mujujulpa wapanja-yanu jukati-kirli Kaatu-kurlangu yartarnarri-kirli. ");
INSERT INTO wbp_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ngularla YAAWIYI wangkaja Mujujuku, “Kajinpa Yijipi-kirra yukamirra, purda-nyangkaju wangkanja-kurra. Purda-nyangkaju yungungkulu yapangku nyanyi ngaju-nyangu-kurlu yartarnarri-kirli. Nyurrurnangku kurru-pungu yartarnarriji nyuntukuju. Kingirli kapungku nyanyi nyiyarningkijarra-kurra ngaju-nyangu yartarnarri-kirli. Kala kapurna jurru marntarla-mani yungungku purda-nyanja-wangu nyina. Kulangku purda-nyanyi, manu kula-jana yapa nyuntu-nyangu yilya Yijipi-ngirli. ");
INSERT INTO wbp_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kajingki warla-pajirni yaninja-kujaku, wangkayarla kuja, ‘Kujanya kangku YAAWIYI-ji wangkami nyuntukuju, “Nyuntu kanparla yulkami-nyayirni nyuntu-nyangu kaja-nyanuku kamparru-warnuku. Ngula-piya-yijala karna-jana Yijiraliji-wardingki-patuku yapaku yulkami. ");
INSERT INTO wbp_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Yilyaya-jana Yijipi-ngirli yungujulu ngaju purami manu yungujulurla pulka-pinyi! Kajinpa-jana mardarni-juku Yijipirla-juku, ngulaju kapurna pinyi nyuntu-nyangu kaja-nyanu kamparru-warnu.” ’ Kujanyarla wangkaya kingikiji.” ");
INSERT INTO wbp_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ngula-jangka, Mujujuju yanulku Yijipi-kirra nyanungu-parnta-kurlu manu kaja-nyanu-jarra-kurlu. Ngunajalu kulkurru. Ngula-wangurla-wiyi, Mujujurlu kula ngarrka-kujurnu kaja-nyanu yangka purdangirli-warnu. Kujarlanya kapu YAAWIYI-rli pungkarla tarnnga-kurra Mujujuju. ");
INSERT INTO wbp_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Kuja-kujakuju, Mujuju-parntarlu Jipurarlu manu kanti, manu wirriyaju ngarrka-kujurnu. Yalyulpa karlija wijini-jangka. Ngula-jangka manu yinyaju pangki wita, manu ngula-kurlurlu marnpurnu Mujuju-kurlangu wirliya. Ngularla wangkaja, “Nyampu-kurlurlu yalyu-kurlurlurna Kaatu warla-pajurnu nyuntu-kujaku pinja-kujaku. Nyuntuju ngaju-parnta-juku.” Ngularla Jipurarlu ngarrka-kujurnu wirriya, kujarlanya Kaaturluju yampija Mujujuju pinja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Kujalpa Mujuju yanurnu-juku kulkurru, YAAWIYI-rla wangkaja Yarunuku, “Yanta jilja-kurra yungunpa Mujuju nyanyi.” Junga-juku, Yarunuju yanu Mujuju nyanjaku kulkurru jilja-kurra, manu nyangu Mujujuju pirli tarrukurla yirdingkaju Jayinayirla. Ngula Yarunurlu yaninjarla nyunjurnu Mujuju. ");
INSERT INTO wbp_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ngularla Mujujurlu yimi-ngarrurnu Yarunuku kujarla nyarrpa YAAWIYI wangkaja kamparru-wiyi Yijipikingarnti. Milki-yirrarnurla Yarunuku yangka watiya jukati Kaatu-kurlangu yartarnarri-kirli. Mujujurla wangkaja Yarunuku, “Kaatuju wangkaja yungurna-jana yartarnarri milki-yirrarni yapaku. Kajirna nyampu jukati kijirni walya-kurra, kapu warna-jarrimi. Manu kajirnaju rdaka yirrarni jaatingka, ngulaju kapurna wijini-jarrimi. Kujakunyaju wangkaja Kaatuju.” ");
INSERT INTO wbp_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ngakalku kuja-pala Mujuju manu Yarunu yukajarra Yijipi-kirra, ngulajulu-jana warru turnu-manu purlkapurlka manu kurdungurlu manu kirda Yijirali-pinki. ");
INSERT INTO wbp_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ngula-jana Yarunurlu yimi-ngarrurnu nyiyarningkijarra nyarrpa kujarla YAAWIYI wangkaja Mujujuku. Ngula Mujujurlu kujurnu watiya jukati walya-kurra, ngulaju warna-jarrija. Ngula pina manu, jukati-jarrija pina. Ngula rdakalku-nyanu yirrarnu jaatingka, kuja wilypi-manu pina, ngulaju wijini palka-wangu. Rdaka-nyanu pina-yirrarnu jaatingka. Kuja wilypi-manu pina, ngurrjulku karalypa-nyayirni wijini-wangu. ");
INSERT INTO wbp_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ngulalu nyangu Yijirali-pinkirli kuja-kurra, milya-pungulu kuja YAAWIYI-rli yilyajarni Mujuju yartarnarri-kirli. Wangkajalu-nyanu, “Kaaturlu-nganpa manngu-nyangu nganimpa. Kula-nganpa yampija. Nyangu-jana Yijipi-wardingki-patu nganimpa kujalpalu-nganpa murrumurru-manu.” Ngulalu muku parntarrinjunu walyangka, manulurla pulka-pungu nyanunguku. ");
INSERT INTO wbp_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Yangka Mujujurlu manu Yarunurlu kujalpalu-jana Yijirali-pinkiki milki-yirrarnu Kaatu-kurlangu yartarnarri, ngula-jangka-palarla yanu nyanjaku kingiki. Wangkaja-palarla nyanunguku, “YAAWIYI, yangka Kaatu kuja karnalu Yijirali-pinki yapangku purami, kujanya kangku nyanunguju wangka, ‘Kula-jana ngaju-nyangu yapa-patu warla-pajika! Yilyaya-jana jilja-kurra yungulu kurapaka wiri ngarni ngajuku pulka-pinjaku!’” ");
INSERT INTO wbp_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Kingirli-palangu wurra-manu, manu-palangu wangkaja, “Ngana YAAWIYI-ji? Nyiyaku-wiyilparna purda-nyangkarla? Kula karna milya-pinyi! Kularna-nyarra Yijirali-pinkiji yilyami jilja-kurraju, lawa!” ");
INSERT INTO wbp_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ngula-palarla Yarunu manu Mujuju wangkaja, “Yangka Kaatu kuja karnalu Yipuru-paturlu purami, nyanungu-nganpa wangkaja jilja-kurra yaninjaku. Yinyarlanya kapurnalurla kuyu warntarri yinyi YAAWIYI Kaatuku. Kajinpa-nganpa warla-pajirni, marda kajika-nganpa nyurnu-mani, marda kajikarlipa palimi kulu wiri-jangka.” ");
INSERT INTO wbp_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kingirliji-palangu wurra-manu-juku, manu-palangu wangkaja Mujujuku manu Yarunuku, “Lawa! Nyiyaku kankulu-jana wangkami yapaku nyuntu-nyangu-patuku warrki yampinjaku manu yungulu nganta yani jilja-kurra? Pina-yanta-pala, manu wangkayalu-jana warrki-jarrinjaku! ");
INSERT INTO wbp_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kulalparna-jana yilyayarla! Panu-jarlu-nyayirni nyanungurraju! Nyiya-jangka-wiyinkili warrkikiji lawa-jarrimi?” ");
INSERT INTO wbp_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ngakalku parra jintangka-juku, kingi-jana wangkaja warrkini-patuku yangka-patu kujalpalu-jana Yijirali-pinki jinyijinyi-manu warrkiki pirijina-piyaku, wangkaja-jana, ");
INSERT INTO wbp_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","8","“Nyurrurlarlu kalankulu-jana Yijirali-pinkiki yungu marna yungulu jurnungu-kurlurlu ngurrju-mani pirikiji yuwarli-wati ngantirninjaku. Kalalu panu-nyayirni pirikiji ngurrju-manu kuja-piyaju parra-kari parra-kari. Kala jalangu mata-jarrijalkulu. Kulalu ngurrju-mani piriki panu-jarluju, lawa. Kujarlanya kajulu ngajuju payirni yungulu yampimi warrki manu yungulu yani jilja-kurra yungulurla warntarri purrami Kaatuku. Kula karnarla kujakuju ngungkurr-nyina! Jalangu-jangka kulalu-jana yungka marna! Wangkayalu-jana yungulu-nyanu warlalja-mani marna pirikiki ngurrju-maninjaku. Jinyijinyi-mantalu-jana yungulu-jana panu-jarlu ngurrju-mani piriki yangka-piyarlu-yijala kuja kalankulu-jana yungu marna. Kajili-jana marnkurrpa-mipa wita-kari wita-kari ngurrju-mani, ngulajulu-jana kurnta-ngarrika kajikalu mata-jarrimi. ");
INSERT INTO wbp_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Yuwayi, mayangkujukulu-jana jinyijinyi-manta warrki-jarrinjaku! Kulalu-jana wangkaya warrki-wangu nyinanjaku! Kajili kuja-piya-juku warrki-jarrimi, ngulaju kulalu purda-nyanyi Mujuju kuja-ka warlka wangkami.” Kujanya-jana kingiji wangkaja warrkini-patukuju nyanungu-nyangu-patukuju. ");
INSERT INTO wbp_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Junga-juku, yinya warrkini-patulu yanu Yijirali-pinki-kirra, manu wangkaja-jana, “Kingi wangkaja kula-nyarra yinyi marna piriki ngurrju-maninjaku. ");
INSERT INTO wbp_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Wangkaja nyanunguju yungunkulu-nyanurla warrirni marnaku. Kulalu mata-jarriya nganta! Nyanungu wangkaja yungunkulu-jana ngurrju-mani piriki panu-jarlu yangka-piyarlu-yijala kuja kalarnalu-nyarra yungu marna kamparrurlu-wiyi.” ");
INSERT INTO wbp_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Junga-juku, ngula-jangkaju, Yijirali-pinkijili yanu Yijipi-wana, marnalpalu manu warru piriki ngurrju-maninjakungarntirli. ");
INSERT INTO wbp_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Yijipi-wardingki-paturlujulpalu-jana jinyijinyi-manu warrki-jarrinjaku, manu wangkajalu-jana, “Yaruju jungalu warrki-jarriya! Kingi wangkaja yungunkulu-jana ngurrju-mani piriki-wati panu-jarlu yangka-piya-yijala kujarnalu-nyarra yungu marna.” ");
INSERT INTO wbp_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Nyampukungarnti, Yijipi-wardingkirlili-jana milarnu Yijirali-pinki ngalya-kari paaju nyinanjaku warrkini-patuku. Wangkajalu-jana, “Kajili nyurrurla-nyangu ngurrara-jinta mata-jarri, manu kajili wita-mipa warrki-jarrimi, ngulaju kapurnalu-nyarra pinjarla yirrarni!” Ngula-jangkaju, Yijirali-pinkirlilpalu-jana putaputa ngurrju-manu piriki, kala lawa. Kulalu marna panu palka-manu, ngari wita-mipa. Yijipi-wardingki-paturlulu-jana pungu Yijirali-pinki paaju-wati, manulu-jana japurnu, “Yuwa! Nyiya-jangka kalu mata-jarrimi nyurrurlaku ngurrara-jinta-watiji? Wita-mipa kalu-jana pirikiji ngurrju-mani, kula panu-jarlu kamparru-piya!” ");
INSERT INTO wbp_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ngulalu Yijirali-pinki paaju-patu yanu kingiki payirninjaku, “Wiyarrpaku! Nyiya-jangka kanpa-nganpa kuluju nyina? Ngari karnangkulu warrkini nyina! Nyiya-jangka kalu-nganpa nyuntu-nyangu warrkini-paturlu pinyi? ");
INSERT INTO wbp_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nyuntu-nyangu wati-paturlu kula kalu-nganpa marna yinyi. Jinyijinyi-mani-jiki kalu-nganpa pirikiki panuku ngurrju-maninjaku kamparru-piya! Kuja karnalu-jana wita-mipa ngurrju-mani, ngulaju kalu-nganpa kulu-jarrimi, manu pinyi kalu-nganpa. Kula-nganpa kulu-jarriya! Yampiya-nganpa mata-pajirninja-wangurlu! Kulu-jarriya-jana nyuntu-nyangu wati-mipaku, kulalu-nganpa yinyi marnaju!” ");
INSERT INTO wbp_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Kingi-jana wangkaja, “Nyurrurlaju mata ngari! Warrki-wangu yungunkulu nyina nganta! Kujakunya kankujulu japirni yungunkulu yani jilja-kurra manu yungunkulurla kuyu warntarrri purranjarla yinyi nyampuku YAAWIYI-ki! ");
INSERT INTO wbp_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Yanta pinalu warrki-kirralku! Kularnalu-nyarra yarda yinyi marnaju. Kala kapunkulu-jana wurrangku-juku panu-jarlu piriki-wati ngurrju-mani yangka kamparru-piyarlu kuja kalarnalu-nyarra marna yungu. Lawangkaju kapurna-nyarra pinjarla yirrarni!” ");
INSERT INTO wbp_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kujalu Yijirali-pinkirli paajurlu purda-nyangu, wangkajalu-nyanu, “Waraa! Nyarrpa-jarrimilkirlipa? Kajirlipa-jana wita-kari wita-kari-mipa ngurrju-mani piriki, ngulaju kingi-kirlangu watingki kapulu-nganpa muku pinyi!” ");
INSERT INTO wbp_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ngula-jangkaju, yampinja-yanulu kingi-kirlangu ngurra, ngulalu pina-yanu Mujuju manu Yarunu-kurlangu ngurra-kurra kujalpalu-jana pardarnu. ");
INSERT INTO wbp_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Wangkajalu-palangu Mujujuku manu Yarunuku, “Kaaturlu yungulpangkupala nyuntu-jarraju pungkarla! Nyuntu-jarrarlajintanya kalu-nganpa kuluju nyina kingi manu nyanungu-nyangu warrkini-watiji. Nyumpalanpalarla kingikiji wangkaja nganimpaku yilyanjaku jilja-kurraku. Kujarlanya yungu-nganpa pinyi muku!” ");
INSERT INTO wbp_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mujujuju jinta yanu YAAWIYI-ki wangkanjaku, payurnu nyanunguju, “YAAWIYI, nyiya-jangka kanpa-nganpa murrumurru-mani nyampurla Yijipirla? Nganimpaju nyuntu-nyangu yapa. Yilayajarni mayinpaju yungunpa-nganpa murrumurru-mani? ");
INSERT INTO wbp_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ngajurnarla yanu kingiki wangkanjaku yangka kujanpaju wangkaja. Ngula-jangkaju-jana kulu-jarrija nyuntu-nyangu yapaku, manu murrumurru-mani kajana karrikarri-wangu-nyayirnirli. Nyiya-jangka kula kanpa-jana muurl-mardarni?” ");
INSERT INTO wbp_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ngularla YAAWIYI wangkaja Mujujuku, “Kapunpaju nyanyi ngaju kajirna kingi warla-pajirni Yijirali-pinki murrumurru-maninja-kujaku. Yartarnarri ngaju-nyangu-kurlurlu kapurna pinyi yungu-jana yapa yilyami Yijipi-ngirli jilja-kurra. Kapuju yapaju marlaja yilya ngajuku.” ");
INSERT INTO wbp_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ngularla Kaatu wangkaja Mujujuku, “Ngajujurna YAAWIYI. ");
INSERT INTO wbp_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nyurru-wiyirnaju milki-yirrarnu Yipuruyamu-kurra, Yijaki-kirra manu Jakupu-kurra. Wangkajarna-jana ngaju-nyangu yirdiji yangka PIRRJIRDI-NYAYIRNI WITA-WANGU Kaatu. Kulalpalu milya-pungu ngaju-nyangu yirdiji YAAWIYI. ");
INSERT INTO wbp_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Jangku-pungurna-jana walya Kanana. Nyinajalpalu yinyarla walyangka, kula nyanungurra-nyangurla. Yapa-karikilpa-jana karrija. ");
INSERT INTO wbp_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Jalangurlurna-jana purda-nyangu Yijirali-pinki yulanja-kurra. Milya-pinyi karna kuja kalu-jana Yijipi-wardingki-paturlu murrumurru-maninjarla jinyijinyi-mani warrkiki pirijina-piya. Ngajulurlu kularna-jana wajawaja-manu ngaju-nyangu yapa kujarna-jana walya Kanana jangku-pungu nyanungurraku. ");
INSERT INTO wbp_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Yaninjarlalu-jana yimi-ngarrika Yijirali-pinkiki ngaju. Wangkaya-jana kuja, ‘Ngajujurna YAAWIYI. Kapurna-jana warla-pajirni Yijipi-wardingki-patu murrumurru-maninja-kujaku manu jinyijinyi-maninja-kujaku warrkiki. Kulankulu-jana yarda warrki-jarrimilki. Ngaju-nyangu yartarnarri-kirlirli kapurna-nyarra kanyi Yijipi-wardingki-patu-kujaku, manu kapurna-jana murrumurru-mani-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kapunkulu ngaju-nyangulku yapa nyina, manu ngaju kapurna-nyarra nyurrurlaku Kaatu nyina. Kapunkujulu milya-pinyi ngajuju YAAWIYI Kaatu. Ngajulurlunya kapurna-nyarra kanyi Yijipi-wardingki-patu-kujaku, kulalu-nyarra jinyijinyi-manilki warrkikiji. ");
INSERT INTO wbp_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kapurna-nyarra nguru-yirrarni walya yangka-kurra kujarna-jana jangku-pungu nyurru-wiyi Yipuruyamuku, Yijakiki manu Jakupuku. Kapurna-nyarra walya yinyi nyurrurlaku. Kapu-nyarra karri nyurrurlakulku. Ngajujurna YAAWIYI.’ Kujanyalu-jana wangkaya Yijirali-pinkiki.” ");
INSERT INTO wbp_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Junga-juku, Mujujurluju yaninjarla-jana yimi-ngarrurnu Yijirali-pinkiki yimi yangka-juku kujarla Kaatu wangkaja. Kala lawa, kulalurla ngungkurr-nyinaja. Yijipi-wardingki-paturlulpalu-jana jinyijinyi-manu-juku warrki-jarrinjaku, manulpalu-nyanu Yijirali-pinkiji wajampa-jarrija-nyayirni. Kujarlanya kulalurla Mujujukuju ngurngkurr-nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Ngularla YAAWIYI wangkaja Mujujuku, “Ngarrirninjinka kingi yungu-jana Yijirali-pinki yilyami Yijipi-ngirli warla-pajirninja-wangurlu!” ");
INSERT INTO wbp_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mujujurla wangkaja YAAWIYI-ki, “Yuwa! Yijirali-pinkirli kulajulu purda-nyanyi! Kingirlangurlu kulaju purda-nyanyi! Ngajurna ngurrpa, kularna-jana nyurru-wiyi yapa panuku wangkaja, manu nyarrparnarla wangkami nyanunguku?” ");
INSERT INTO wbp_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","YAAWIYI-palangu wurra-juku wangkaja Mujujuku manu Yarunuku yungu-palarla wangkami kingiki Yijipi-wardingkiki yungu-jana Yijirali-pinki yilyami Yijipi-ngirli warla-pajirninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Yijirali-pinkiji kalalu nyinaja warlalja-kari warlalja-kari turnu-warnurla. Nyampunya yirdi-watiji yangka paaju-watiji yangka kujalpalu-jana wiriwiri nyinaja yapaku warlalja-kari warlalja-kariki turnu-warnurlaku. Yijirali-kirlangu kamparru-warnu kaja-nyanuju yirdiji Ruupunu. Ruupunurlulpa-jana kaja-nyanu murntu-pala mardarnu yirdi-watiji Yanaka, Paalu, Yijirunu manu Karrmi. Nyampu-patu wati-patujulpalu paaju nyinaja murntu-palaku warlalja-kari warlalja-kariki turnu-warnurlaku. ");
INSERT INTO wbp_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Jimiyani-kirlangu kaja-nyanu-patuju yirdiji Jimulu, Jamini, Yuyarda, Jakana, Juuru manu Jawurlu. Jawurluku ngati-nyanuju Kanana-wardingki. Nyampu-patu jika-pala wati-patulpalu paaju nyinaja jika-palaku warlalja-kari warlalja-kariki turnu-warnurlaku. ");
INSERT INTO wbp_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Liipikijirla rdipija 137-pala yulyurrpu. Kaja-nyanu nyanungu-nyangu-patuju yirdiji Kurrjuna, Kuyaja manu Mirari. Nyinajalpalu marnkurrparla warlaljarla turnu-warnurla. ");
INSERT INTO wbp_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kurrjunarlulpa-palangu kaja-nyanu-jarra mardarnu yirdi-jarraju Lipini manu Jimayi. Nyinajalpa-pala jirramarla warlaljarla turnu-warnurla. ");
INSERT INTO wbp_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kuyajakujurla rdipija 133-pala yulyurrpu. Nyanungu-nyangu kaja-nyanu-patuju yirdiji Yamarama, Yijara, Yipurana manu Yujiyali. ");
INSERT INTO wbp_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mirari-kirlangu kaja-nyanu-jarraju Maali manu Muuji. Nyampurranya warlalja-kari warlalja-kari Liipi-kirlangu. Kalalu-nyanu yirdi-watiji manngu-nyangu wajawaja-maninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Wati yinya yirdi Yamarama yupukarra-jarrija nyanungu-nyangu kirdana-kurlangu ngawurru-nyanu-kurlu yirdiji Jakapati. Jakapatirli-palangu mardarnu Yarunu manu Mujuju. Yamaramakujurla rdipija 137-pala yulyurrpu. ");
INSERT INTO wbp_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yinya wati yirdiji Yijara, kaja-nyanu-patu yirdi-patuju Kuura, Nipiki manu Jikiri. ");
INSERT INTO wbp_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wati yinya yirdiji Yujiyali, nyanungu-nyangu kaja-nyanu-patu yirdi-patuju Mijali, Lajapana manu Jijiri. ");
INSERT INTO wbp_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Wati yinya Yarunu yupukarra-jarrija Yilijipa-kurlu yurntalpa Yaminitapa-kurlangu, manu kapirdi-nyanu Naajanaku. Yilijipaju karrmulypa-jarrija Natapa-kurlu, Piyu-kurlu, Yalijara-kurlu manu Yijama-kurlu. ");
INSERT INTO wbp_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wati yinya yirdiji Kuura, nyanungu-nyangu kaja-nyanu-watiji yirdiji Yaajiri, Yalkana manu Yapijapa. Nyampu-patu kaja-nyanu-patujulpalu paaju-patu nyinaja marnkurrpa warlalja-kari warlalja-kari turnu-warnurla Kuura-kurlangurla. ");
INSERT INTO wbp_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Yarunu-kurlangu kaja-nyanu Yalijara yupukarra-jarrija karnta-kurlu, kirda-nyanuju Putiyali. Ngula kurdu pirltirrka mardarnu Piniyaja. Yuwayi, nyampunya yirdi-wati paaju-watikiji kujalpalu Liipi-kirlangurla turnu-warnurla nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Yinya-jarra papardirlangu Yarunu manu Mujuju, yinya-jarrakunya-palangu YAAWIYI-ji wangkaja, “Kangkarnili-jana ngaju-nyangu yapa-patu Yijirali-pinki Yijipi-ngirli. Kangkarnili-jana warlalja-kari warlalja-kari yinya-ngurlu nguru-ngurlu.” ");
INSERT INTO wbp_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Junga-juku, yinya-jarranya-palarla yanu wangkanjaku Yijipi-wardingki kingiki. Wangkaja-palarla yilyanjaku Yijirali-pinki Yijipi-ngirli warla-pajirninja-wangu. ");
INSERT INTO wbp_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kujalpa Mujuju nyinaja-juku Yijipirla, YAAWIYI-rla wangkaja, ");
INSERT INTO wbp_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Ngajurna YAAWIYI. Yaninjarla yimi-ngarrika Yijipi-wardingkiki kingiki nyiyarningkijarra kuja karnangku ngaju wangkami.” ");
INSERT INTO wbp_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mujujurla wangkaja nyanunguku, “Lawa, kula ngajuju ngurrju wangkanja-panu. Nyarrpa kularnarla wangkami. Kulaju ngajuju purda-nyanyi.” ");
INSERT INTO wbp_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Ngajurnangku nyuntuju milarnu yungunparla Kaatu-piya nyina Yijipi-wardingkiki kingiki. Manu ngajurna milarnu nyuntukupurdangka papardi-nyanu Yarunu yungungku nyina nyuntuku jarukungarduyu, yungungku marlaja wangkami. ");
INSERT INTO wbp_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kapurnangku ngajulurlu nyuntuju yimi-ngarrirni nyarrpa wangkanjaku. Yimi-ngarrika Yarunuku ngaju-nyangu yimi, ngula-jangka yungurla wangka kingikilki. Kapurla kuja wangkami kingikiji, ‘Kula-jana warla-pajika Yijirali-pinki yapa kajili yampinja-yani Yijipi!’ ");
INSERT INTO wbp_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ngajulurlu kapurna kingiji jurru marntarla-mani yungungkupala purda-nyanja-wangu nyina. Ngula-jangka, parra-patu panuku kapurnarla ngaju-nyangu yartarnarrilki milki-yirrarni kingiki. ");
INSERT INTO wbp_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Kapu jurru marntarla-juku nyina. Kulangku purda-nyanyi. Ngula-jangka, kapurna-jana murrumurru-mani Yijipi-wardingki-patu yapaju. Ngula-jangka, kapurna-jana nguru-yirrarni warlalja turnu-warnu-kari turnu-warnu-kari ngaju-nyangu yapa Yijirali-pinki Yijipi-jangka. ");
INSERT INTO wbp_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kajirna-jana murrumurru-mani Yijipi-wardingki-patu yapa, manu kajirna-jana nguru-yirrarni Yijirali-pinki Yijipi-ngirli, ngula-jangka Yijipi-wardingki-paturlu kapujulu milya-pinyi ngaju YAAWIYI.” Kujanyarla YAAWIYI-ji wangkaja Mujujukuju. ");
INSERT INTO wbp_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Junga-juku, Mujujurlu manu Yarunurlu-palarla kingikiji yimingki yangkangku-juku yimi-ngarrurnu kuja-palangu YAAWIYI wangkaja kamparru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Kuja-palarla Mujuju manu Yarunu yanu wangkanjaku kingiki, purlka-jarralpa-pala nyinaja. Mujujukujurla rdipija 80-pala yulyurrpu, manu Yarunukujurla 83-pala yurlyurrpu rdipija. ");
INSERT INTO wbp_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","9","Ngula-jangkaju, YAAWIYI-palangu wangkaja Mujujuku manu Yarunuku, “Kajinpalarla yani nyuntu-jarra Yijipi-wardingki kingiki, kapungkupala payirni yungunpalarla milki-yirrarni yartarnarri. Mujuju, kajingki kujarlu payirni, wangkayarla Yarunuku yungu kijirni nyanungu-nyangu jukati walya-kurra kamparru kingikiji. Kapu warna-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Junga-juku, Mujuju manu Yarunu-palarla yanu nyanjaku kingiki. Kuja-palangu payurnu yartarnarri nyanjaku, Yarunurlu jukati kujurnu walyangka kamparru kingikiji manu nyanungu-nyangu warrkini-watiki. Yinya jukati warna-jarrija. ");
INSERT INTO wbp_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ngula-jana kingirli yajarnunjunu nyanungu-nyangu pinangkalpa-patu manu ngangkayi-kirli-wati, jinta-kari jinta-karirlilpalu mardarnu yartarnarri. ");
INSERT INTO wbp_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kujurnulu-jana muku jukati walya-kurra, manu nyanungurra-nyangu jukati-wati warna-jarrijalu muku. Kala Yarunu-kurlangu warnangku-jana muku ngarnu warna-wati-kariji. ");
INSERT INTO wbp_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kingijilpa jurru marntarla-juku nyinaja. Kulalpa-palangu purda-nyangu Mujuju manu Yarunu. Kujanya-palangu kamparru-wiyiji wangkaja YAAWIYI kingi-kirliji. ");
INSERT INTO wbp_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Kingiji jurru marntarla-juku. Warla-pajirni-jiki kajana yapaju Yijipi-kijaku yampinja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Jukurra mungalyurru, yanta karru Niili-kirra. Pirntinyarrarla karriya karru-wana. Kangka nyuntu-nyangu watiya jukati yangka kuja warna-jarrija. Pardakarla kingiki kaji yanirni karru-kurra julyurlpaku. ");
INSERT INTO wbp_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kaji yani yali-kirra, kujarla wangkaya, ‘YAAWIYI-ji Kaatu ngulaju Yipuru-patuku yapakuju. Yilyajarniji nyuntuku wangkanjaku. Kujanya kangku wangkami nyanunguju, “Kula-jana warla-pajika ngaju-nyangu yapa jilja-kujaku. Ngajuku yungujulurla pulka-pinyi yalirlaju.” Kujanya kangku YAAWIYI-ji wangkami nyuntukuju. Nyuntulurlunpa jawirri purda-nyangu wangkanja-kurra kamparrurlu-wiyi. ");
INSERT INTO wbp_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Kujanya kangku wangkamilki nyanunguju, “Nyuntulurlunpa payurnu Mujuju ngana nganta ngajuju. Ngurrju, kapurnangku ngaju-nyangu yartarnarri milki-yirrarni yungunpaju milya-pinyilki ngana ngajuju.” Junga kujaju. Mujujurlu kapu ngapa pakarni karrungka Niilirla nyampu-kurlurlu jukati-kirlirli. Kaji pakarni, kapu ngapaju yalyu-jarrimi. ");
INSERT INTO wbp_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ngula-jangka, kapulu yawu-watiji karru Niilirlaju palimi muku, manu kapu ngapaju pukulyu-nyayirni parntimi. Kulankulu Yijipi-wardingki-paturlu ngapaju ngarni yalirlaju.’” ");
INSERT INTO wbp_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Wangkayarla Yarunuku yungu nyanungu-nyangu jukati mani yungu-jana karru manu mangkuru-kari mangkuru-kari jiily-ngarrirni manu mulju-wati Yijipirla. Kaji-jana jiily-ngarrirni jukati-kirlirli, ngapa-watiji kapulu yalyu-jarrimi muku, manu ngapa-wati kartakurla manu ngamingka kapulu muku yalyu-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Junga, kujalu Yijipi-wardingki kingi manu nyanungu-nyangu warrkini-patu yanurnu karru Niili-kirra, Mujujurla wangkaja Yarunuku ngapa pakarninjaku jukati-kirlirli. Kuja Yarunurlu ngapa pakarnu, yalyu-jarrija muku. Kingirli manu warrkini-paturlulu nyangu kuja-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ngulalu ngapa-ngawurrpa yawu-wati ngapangka palija muku, manu pukulyu-jarrijalkulpalu. Karrujulpa punku-nyayirni parntija. Kulalpalu ngapaju ngarnu. Ngapa-wati Yijipirla yalyu-jarrija mukulu. ");
INSERT INTO wbp_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ngula-jangka, Yijipi-wardingki-paturlu ngangkayi-kirlirlili ngapa maninjarla yalyu-kurra-manu-yijala Mujuju-piyarlu. Kuja-jangka Yijipi-wardingki kingi yarda jurru marntarla-jarrija. Kulalpa-palangu Mujuju manu Yarunu purda-nyangu. Warla-pajurnu-juku-jana Yijirali-pinki yapa-patu yaninja-kujaku Yijipi-jangka. Kujanya-yijala-palangu YAAWIYI-ji wangkaja Mujujuku manu Yarunukuju kingi-kirliji. ");
INSERT INTO wbp_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kingiji-palangu Mujujuku manu Yarunukuju jurnta yanu nyanungu-nyangu yuwarli-kirra. Kula-palangu purda-nyangu nyanungu-jarra. ");
INSERT INTO wbp_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Yijipi-wardingki-paturlu yapangku kulalu ngapa ngarnu karru Niilirla. Kalalu karru-wana pangurnu ngapakupurdarlu, kala lawa. Ngapakulpalurla warrarda warrurnu. ");
INSERT INTO wbp_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yangka kuja YAAWIYI-rli ngapa yalyu-manu karru Niilirla, yalyuju ngunaja karrungka wirlki-pala parraku. ");
INSERT INTO wbp_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Yaninjarla kujarla wangkaya Yijipi-wardingki kingiki, ‘Kujanya kangku YAAWIYI-ji wangkami nyuntukuju, “Ngaju-nyangu yapangku yungujulurla ngajuku pulka-pinyi jiljangka. Kula-jana warla-pajika! ");
INSERT INTO wbp_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kajinpa-jana warla-pajirni, kapurna-nyarra jangkardu yilyamirra panu-jarlu-nyayirni jarlji-wati Yijipi-wardingki-patukuju. ");
INSERT INTO wbp_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kapu karru Niiliji karri panu-nyayirni-kirli jarlji-kirli. Kapulu yanirni karru-ngurlu, manu kapulu yukami nyuntu-nyangu yuwarli-kirra kuja kanpa nyuntu nyina. Kapulu yani yangka-kurra kuja kanpa jarda nguna, manu kapulu juurl-pinyi warru nyuntu-nyangu pangkarrarla. Yuwayi, kapulu jarlji-watiji warru yani, manu kapulu yuka nyuntu-nyangu yapa-kurlangu yuwarli-paturla manu wiriwiri-kirlangu yuwarli-paturlangurla. Kapulu juurl-pinyi purranja-kurlangu-kurra manu parraja-kurra kuja kalu warrkini-watirli mangarri ngurrju-mani. ");
INSERT INTO wbp_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Yuwayi, kapulu jarlji-watiji warru juurl-pinyi nyuntu-wana manu nyuntu-nyangu wiriwiri-wana manu yapa-patu-wana.” ’ Kujanya yungunparla wangka Yijipi-wardingkiki kingikiji.” ");
INSERT INTO wbp_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Wangkayarla Yarunuku yungu nyanungu-nyangu watiya jukati mani manu yungu jiily-ngarrirni karru manu marluri-kari marluri-kari manu mulju-wati. Kaji kuja-jarri, ngari kapulu panu-jarlu-nyayirni jarlji-wati wilypi-pardimi muku ngapa-kari ngapa-kari-jangka Yijipirla.” ");
INSERT INTO wbp_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Junga-juku, Yarunurlu jiily-ngarrurnu muku karru, marluri-kari marluri-kari manu mulju-wati Yijipirla. Panu-jarlu-nyayirni jarlji-watili wilypi-pardija ngapa-ngurlu, manulpalu juurl-pungu warru Yijipirla. ");
INSERT INTO wbp_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ngula-puru, ngangkayi-kirli-patu Yijipi-wardingki-patulu yanurnu nyanungurra-nyangu yartarnarri-kirli, manulu-jana jarlji-wati muku marlaja wilypi-pardija ngapa-ngurlu. Panu-jarlu-nyayirni jarlji-watilpalu juurl-pungu Yijipirla. ");
INSERT INTO wbp_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ngula-jangka, Yijipi-wardingki kingirli-palangu yimi yilyaja Mujujuku manu Yarunuku yungu nganta-palarla yani nyanjaku. Kuja-pala yukajarra, wangkaja-palangu, “Wangkayaju-palarla YAAWIYI-ki yungu-nganpa jurnta kanyi nyampu jarlji-wati ngajuku manu ngaju-nyangu yapaku. Kaji-jana kanyi muku, ngula-jangka kapurna-nyarra jilja-kirra yilyamilki yungunkulurla pulka-pinyi nyanunguku yinyarla.” ");
INSERT INTO wbp_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mujujurlu japurnu kingiji, “Wangkayaju jalangu! Nyangurlarnarla wangkami YAAWIYI-kiji nyuntuku manu nyuntu-nyangu warrkini-watiki manu yapakuju? Kajirnarla wangka, ngula-jangkaju kapulu-nyarra jarlji-watiji jurnta yanilki nyurrurlakuju, manu kapulu yani nyurrurla-nyangu yuwarli-kijakuju. Kapulu pina-yani karru Niili-kirra yangka kujalpalu kamparru-wiyi nyinaja.” ");
INSERT INTO wbp_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Kingirla wangkaja Mujujuku, “Wangkayajurla YAAWIYI-ki jukurra.” Mujujurla wangkaja nyanunguku, “Yuwayi, kajirnarla wangka YAAWIYI-ki jukurra, kapulu jarlji-watiji muku yani nyuntu-kujaku manu nyuntu-nyangu warrkini-kijaku manu yapa-kujaku. Kapulu yani yuwarli-ngirli, manu kapulu nyina karru Niili-miparla. Ngula-jangka kapunpa milya-pinyi YAAWIYI kanganpa Kaatu nyina ngajuku manu ngaju-nyangu yapaku.” ");
INSERT INTO wbp_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ngula-jangka, Mujujurlu manu Yarunurlu-pala yampinja-yanu kingiji. Parra-karirla Mujujurla wangkaja YAAWIYI-ki, “Wiyarrpaku! Kangka-jana jurnta nyampu jarlji-wati Yijipi-wardingki yapa-kujaku, yangka kujanpa-jana nyuntulurlu jangkardu yilyajarni!” ");
INSERT INTO wbp_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","YAAWIYI-rlilpa Mujujuju purda-nyangu wangkanja-kurra, ngula yalu-manu. Jarlji-watijili muku palija kaninjarni yuwarli-watirla manu yarlu-kari yarlu-karirla ngurujarraranypa. ");
INSERT INTO wbp_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Yijipi-wardingki-paturlulpalu-jana manu warru jarlji-wati kujalu palija. Jarlji-watijilpalu pukulyu-jarrija, manulpa punku-nyayirni parntija. ");
INSERT INTO wbp_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kuja-jana kingirli nyangu nyurnu-wati jarlji-wati, yarda jurru marntarla-jarrija. Kula-palangu purda-nyangu Mujuju manu Yarunu kuja-palarla yanurnu wangkanjaku. Kuja-yijala yangkaju YAAWIYI kamparru-wiyiji wangkaja kingi-kirliji, yangka kapu jurru marntarla-jarri-pina purda-nyanja-wangu nganta. ");
INSERT INTO wbp_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Wangkayarla Yarunuku yungu nyanungu-nyangu jukati mani manu yungu pakarni walya. Kaji walya pakarni, kapu walya-jangkaju kiwinyi palka-jarrimi panu-nyayirni ngurujarraranypa Yijipirla.” ");
INSERT INTO wbp_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Junga-juku, Yarunurlu manu jukati nyanungu-nyangu, ngula pakarnu walya kujarla Mujuju wangkaja. Kuja yungka pakarnu, walya-jangkaju kiwinyi panu-jarlu-nyayirni palka-jarrijalu Yijipirlaju. Kiwinyijilpalu paarr-pardija yapa-wana manu puluku-patu-wana. ");
INSERT INTO wbp_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ngula-jangkalu Yijipi-wardingki-paturlu ngangkayi-kirlirli walya-yijala pakarnu jukati-kirlirli nyanungurra-nyangu-kurlurlu. Yartarnarri-kirlirli yungulu walyaju kiwinyi-mantarla, kala lawa. Kiwinyijilpalu paarr-pardija-juku yapa-wana manu puluku-patu-wana. ");
INSERT INTO wbp_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ngulalurla ngangkayi-kirli-wati wangkaja kingiki, “Lawa, kulalparnalu nyarrparlu walya kiwinyi-mantarla nganimpa-nyangu yartarnarri-kirlirli. Kaatu-kurlangu-mipa-kurlurlu yartarnarri-kirlirli-ka Yarunurluju walyaju kiwinyi-mani.” Kingijilpa nyinaja jurru marntarla-juku, purda-nyanja-wangu. Kuja-yijala YAAWIYI-ji kamparru-wiyiji wangkaja kingi-kirliji yangka kapu jurru marntarla-jarri purda-nyanja-wangu. ");
INSERT INTO wbp_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","YAAWIYI-rla wangkaja Mujujuku, “Yakarra-pardiya jukurra mungalyurru, manu yanta karru-kurra. Pardakarla Yijipi-wardingki kingiki yalirla kaji yanirni. Kaji yanirni, kujarla wangkaya, ‘Kujanya kangku YAAWIYI-ji wangkami nyuntukuju, “Ngaju-nyangu yapangku yungujulurla pulka-pinyi ngajuku jiljangka. Kula-jana warla-pajika! ");
INSERT INTO wbp_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kajinpa-jana warla-pajirni, kapurnangku jangkardu yilyamirra yimangi-wati nyuntukuju. Kapulu paarr-pardimi yuwarli nyuntu-nyangu-kurra, kapulu warru paarr-pardimi nyuntu-wana manu nyuntu-nyangu warrkini-wana manu yapa-wana. Manu kapulu-nyarra kii-purrami-nyayirni. Yuwarli-wati Yijipirla kapulu yimangi panu-jarrimi manu walyarlangurla. ");
INSERT INTO wbp_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kularna-jana yimangiji yilyami nguru-kurra Kujunu-kurraju, lawa. Ngaju-nyangu yapa kalu nyina yalirlaju Yijirali-pinki. Kulalu-jana mata-mani yimangi-watirliji yalirlaju Kujunurla. Kajinpa-jana nyanyi yali yimangi-wati, kapunpaju milya-pinyi ngajuju YAAWIYI nyampurla ngurungka. ");
INSERT INTO wbp_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Yuwayi, jukurra ngaju-nyangu yartarnarri-kirlirli kapurna-jana jangkardu yilyami yimangi-watiji Yijipi-wardingki-patukuju. Kajili-nyarra jangkardu yanirni nyuntuku manu nyuntu-nyangu yapaku, kapurna-jana muurl-mardarni ngaju-nyangu yapa.” ’ Kujanyarla wangkaya Yijipi-wardingki kingikiji.” Junga-juku, Mujuju yanu kingiki yimi-ngarrirninjaku yangka kuja kapu-jana YAAWIYI-rli yimangi jangkardu yilyamirni nyanunguku manu nyanungu-nyangu yapaku. ");
INSERT INTO wbp_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Junga kujaju. YAAWIYI-rli-jana jangkardu yilyaja yimangi panu-jarlu-nyayirni. Paarr-pardijalu kingi-kirlangu yuwarli-kirra manu yuwarli panu-kari-kirra yangka warrkini-kirlangu-kurra. Yimangiji panu-nyayirni Yijipirlaju. ");
INSERT INTO wbp_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ngula-palangu kingirli yimi yilyaja Mujujuku manu Yarunuku yungu-pala nganta nyanyi. Kuja-pala yanurnu, nyanungu-palangu wangkaja, “Yuwayi, nyuntulurlu manu nyuntu-nyangu yapangkulurla warntarri kuyu yungka Kaatuku nyampurla-juku ngurungka.” ");
INSERT INTO wbp_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mujujurlu yalu-manu nyanunguju, “Lawa! Kajirnalu-jana puluku-wati pinyi, manu kajirnalurla purranjarla yinyi YAAWIYI-ki Kaatuku, kapulu-nganpa Yijipi-wardingki-paturlu nyanyi, manu kapulu-nganpa kulu-jarrimi kajirnalu-jana puluku-wati jurnta pinyi. Kapulu-nganpa wangkami, ‘Yuwa! Nyiya-jangka kankulu-jana pulukuju pinyi? Mukunypa kalu-nganpa nyina. Purami karnalu-jana!’ Ngula-jangka kapulu pirli mani, kapulu-nganpa luwarni tarnnga-kurra pinjakungarntirli! ");
INSERT INTO wbp_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kujarlanya kularnalurla YAAWIYI-kiji warntarriji purrami nyampurlaju. Kujakuju kapurnalu jilja-wana wapami parra marnkurrpaku. Yinyarlanya kapurnalurla kuyuju purrami nyanungukuju. Kujakunya-nganpa YAAWIYI-ji wangkaja.” ");
INSERT INTO wbp_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ngula kingirli yalu-manu Mujujuju, “Yuwayi, nyuntu manu nyuntu-nyangu yapalu yanta jilja-kurra Yijipi yampinjarla. Kulalu wurnturu yanta. Ngarili kutu-mipa yanta yungunkulurla YAAWIYI-ki kuyu purranjarla yinyi Kaatuku. Yaninjakungarntijirla wangkaya yungu-nganpa yimangi jurnta yilyami.” ");
INSERT INTO wbp_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mujujurla wangkaja nyanunguku, “Yuwayi, yampinja-yanilki karnangku. Kapurnarla wangkami YAAWIYI-ki. Jukurra kapu-nyarra yimangirli yampimilki nyuntu manu nyuntu-nyangu warrkini manu yapa-patu. Purda-nyangkaju! Kula-nganpa yulyurlku-yungka yarda! Kula-nganpa warla-pajika jilja-kujaku yungurnalurla purrami kuyu warntarri-nyayirni-wangu YAAWIYI-ki.” ");
INSERT INTO wbp_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ngula-jangka, Mujujurlu yampinja-yanu kingiji, manurla wangkaja YAAWIYI-ki. ");
INSERT INTO wbp_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","YAAWIYI-rli purda-nyangu Mujuju wangkanja-kurra. Parra-karirla-jana yimangiji jurnta yilyaja kingiki manu nyanungu-nyangu warrkini-patuku manu yapa-patuku. Kulalpa jintarlangu-puka yimangi wankaru nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Kingiji yarda jurru marntarla-jarrija. Kula manngu-nyangu yangka kujarla kamparru yijardu-wangu wangkaja Mujujuku yangka kapu-jana yilya nganta Yijirali-pinki Yijipi-ngirli, lawa. Warla-pajurnu-juku-jana jilja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","YAAWIYI-rla wangkaja Mujujuku, “Yaninjarla wangkayarla Yijipi-wardingki kingiki, ‘Kujanya kangku wangka YAAWIYI-ji yangka Yipuru-patu-kurlangu Kaatuju nyuntukuju, “Ngaju-nyangu yapangku yungujulurla pulka-pinyi ngajuku jiljangka. Kula-jana warla-pajika!” ’” ");
INSERT INTO wbp_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ngula-jangka, Mujujurla yaninjarla wangkaja kingiki, “Marda kapunpa-jana warla-pajirni Yijirali-pinki yapaju. Marda kapunpa-jana nyampurla Yijipirla mardarni. ");
INSERT INTO wbp_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Kajinpa-jana mardarni, YAAWIYI-rli kapungku murrumurru-mani nyanungu-nyangu yartarnarri-kirlirli. Kapu-jana murrumurru-mani nyuntu-nyangu puluku-wati, manu kapu-jana murrumurru-mani nantuwu-wati, tangkiyi-wati, kawartawarta-wati manu jiyipi-wati ngurujarraranypa Yijipirla. Kapulu nyurnu-jarrinjarla muku palimi. ");
INSERT INTO wbp_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kala Yijirali-pinki-kurlanguju kuyu-watiji, YAAWIYI-rliji kapu-jana warrawarra-kanyi. Kula jintarlangu-puka nyurnu-jarrinjarla palimi. ");
INSERT INTO wbp_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yuwayi, YAAWIYI-ji wangkaja jukurrarlu kapu-jana kuyu-watiji muku pinyi tarnnga-kurra, manu kapulu palimi.” ");
INSERT INTO wbp_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Junga, parra-karirla YAAWIYI-rli-jana puluku-wati Yijipi-wardingki-kirlangu muku pungu yangka kujarla wangkaja Mujuju kamparru-wiyi. Kuyu-watijili muku palija. Kulalu Yijirali-pinki-kirlangu palija, lawa. Kula jintarlangu-puka, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Yijipi-wardingkirli kingirli-jana nyangu nyanungu-nyangu puluku-wati palinja-kurra, manu puluku-wati nyanungu-nyangu yapa-kurlangu. Ngula-jana nyanungu-nyangu-wati yilyaja Kujunu-kurra kujalpalu Yijirali-pinki yapa-patu nyinaja. Yaninjarlalu-jana nyangu Yijirali-pinki-kirlangu puluku-wati wankaru-juku. Yanu-pinalu, manulurla wangkaja kingiki. Nyanungujulpa nyinaja jurru marntarla-juku. Kula manngu-nyangu yangka kujarla wangkaja Mujujuku kapu-jana nganta Yijirali-pinki yapa yilyami jilja-kurra, lawa. Warla-pajurnu-jana yaninja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ngula-jangka, YAAWIYI-palangu wangkaja Mujujuku manu Yarunuku, “Nyuntu-jarrarlu-juku-pala turla-manta yulypulypa kilyirrpa-jangka. Mujuju, nyunturlu kijika yulypulypaju kankarlarra nguru-kurra yungungku Yijipi-wardingkirli kingirli nyanyi. ");
INSERT INTO wbp_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Kapu yulypulypa jurdu-piya-jarrimi, manu kapu warlpangku kanyi Yijipi-wana. Jurduju kapu-jana pirri-mani Yijipi-wardingki yapangka manu kuyu-watirla yungu-jana japirnpa rdirr-pinyi palkangka. Japirnpaju kapu wiri-jarrimi, manu kapu-jana yapaju palkaju wijini-mani.” ");
INSERT INTO wbp_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ngula-jangka, Mujuju manu Yarunu-pala yanu yulypulypa maninjaku kilyirrpa-jangka. Yaninjarla-pala karrija kamparru kingirla. Ngula-jangka, Mujujurlu yulypulypaju kankarlarra kujurnu nguru-kurra. Yijipi-wardingki-patu yapa manu kuyu-watili muku japirnpa-kurlu-jarrija, mukulu rdirr-yanu japirnpaju. ");
INSERT INTO wbp_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Yijipi-wardingki-patu yapajulu muku japirnpa-kurlu-jarrija, manu ngangkayi-kirli-watirlangu. Kujarlanya kulalpalu kamparru karrija Mujujurla, kulalpalu waalparrurnulku yangka-piyarlu-yijala. ");
INSERT INTO wbp_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Junga kujaju! YAAWIYI-kijirla marlaja jurru marntarla-jarrija pina kingiji. Kulalpa-palangu purda-nyangu Mujuju manu Yarunu. Kuja-yijala-palangu YAAWIYI-ji wangkaja kamparru-wiyi yangka kapu kingi jurru marntarla-jarri pina nganta. ");
INSERT INTO wbp_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","YAAWIYI-rla wangkaja Mujujuku, “Jukurra mungalyurru yakarra-pardinjarlarla yanta Yijipi-wardingkiki kingiki. Kujarla wangkaya, ‘Nyampunya kangku YAAWIYI-ji yangka Yipuru-patu-kurlangu Kaatu wangkami nyuntukuju, “Ngaju-nyangu yapangku yungujulurla pulka-pinyi jiljangka. Yilyaya-jana, warla-pajirninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kajinpa-jana warla-pajirni warrarda, kapurnangku murrumurru-mani ngaju-nyangu yartarnarri-kirlirli. Kapurna-nyarra nyuntu manu nyuntu-nyangu warrkini-patu manu yapa-patu murrumurru-mani nyampu Yijipirla. Yungunpa milya-pinyilki kula-ka ngana ngaju-piyaju nyina nyampurlaju. ");
INSERT INTO wbp_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kajirna ngampurrpa-jarriyarla kamparru-wiyi, ngaju-nyangu yartarnarri-kirlirli kapurna-nyarra nyurrurlaju muku pungkarla nyurru-juku. Kapurna-nyarra riwarr-mantarla muku. ");
INSERT INTO wbp_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kala lawa! Wankaru-juku karna-nyarra mardarni yungunkulu ngaju-nyangu yartarnarri nyanyi. Ngajurna-nyarra wankaru mardarnu yungulu-jana yapa ngurujarraranyparlu yimi-ngarrirni ngaju-nyangu yimi, ngaju-nyangu yirdi purda-nyanjarla. ");
INSERT INTO wbp_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kala lawa kanpa-nyanurla pulka-pinyi-puka. Kulu-jarrimi kanpa-jana ngaju-nyangu yapaku. Warla-pajirni warrarda-puka kanpa-jana yungulu nganta nyina Yijipirla-juku. ");
INSERT INTO wbp_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Purda-nyangkaju! Jukurrarluju kapurna yilyamirra kunarda ngapa kunarda-kurlu yungu rdilyki-pinyi muku nyiyarningkijarra. Kulalu Yijipi-wardingki-paturlu nyangu kuja-piya wantinja-kurra nyurru-wiyi, lawa! ");
INSERT INTO wbp_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Yuwayi, yilyaya-jana nyuntu-nyangu warrkini-wati ngurra-kari ngurra-kari-kirra. Wangkaya-jana yungulu-jana puluku-wati turnu-mani, manu panu-kari kuyu-wati kuja kalu karri yarlungka. Yungulu-jana yirrarni muku yuntangka. Jukurra kapu ngapa kunarda-kurlu wantimi nguru-jangka. Kapu-jana pakarni yapa manu puluku-wati kajili karrimi yarlungka-juku. Ngana-puka kaji karri yarlungka, ngulaju kapu palimi.” ’ Mujuju, kujanyarla wangkaya Yijipi-wardingkiki kingikiji.” ");
INSERT INTO wbp_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ngula-jangka, Mujujurlu yaninjarla yimi-ngarrurnu kingikiji nyarrpa kujarla YAAWIYI wangkaja nyanunguku. Kingi-kirlangu warrkinirlili purda-nyangu Mujuju wangkanja-kurra. Panu-karirlijilpalu yirriyirrirli purda-nyangulku Mujujuju, lani-jarrijalpalu YAAWIYI-kijaku. Yaruju-jarrijalu kujalpalu warrkini pirijina-piya nyinaja manu puluku-wati, manulu-jana kangurnu kaninjarni yuwarli-wati-kirra manu yunta-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Kala panu-kari kingi-kirlangu warrkini-paturlu, ngulalu jamulu purda-nyangu Mujuju wangkanja-kurra kujarla YAAWIYI wangkaja kamparru-wiyi. Kulalu-jana pirijina-patu manu puluku-wati kangu kaninjarni yuwarli-wati-kirra, lawa. Yampijalu-jana yarlungka. ");
INSERT INTO wbp_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Waku-nyanu kankarlu-manta nguru-kurra-pinangu! Ngula-jangka kapurna panu-nyayirni kijirni ngapa kunarda-kurlu Yijipirla. Kapu-jana pakarni yapa panu manu puluku-wati manu watiya kuja kalu pardimi Yijipirla.” ");
INSERT INTO wbp_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Junga-juku, Mujujurlu manu nyanungu-nyangu watiya jukati, ngula jiily-ngarrurnu nguru. Ngula YAAWIYI-rli kujurnu ngapa kunarda-kurlu walya-kurra. Kuluwurru-wangkajalkulpa, manu wirnpalkulpa karrikarrija, manu panu-nyayirnilpa wantija ngapa kunarda-kurluju Yijipirlaju. Yuwayi, junga kujaju. Panu-jarlu-nyayirni kunarda ngapa-jangka ngunaja walyangkaju. Ngula-wangurla-wiyi, kujalpalu Yijipi-wardingki-patu nyinaja yinyarla walyangka, kula nganangku nyangu kuja-piya ngapa kunarda-kurlu wantinja-kurra! ");
INSERT INTO wbp_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ngapa kunarda-kurlu kuja wantija, muku rdilyki-pungu nyiyarningkijarra kujalpa yarlungka karrija Yijipirla. Muku-jana riwarr-pungu yapa Yijipi-wardingki manu puluku-wati yangka kujalpalu yarlungka karrija. Muku maju-manu kujalpalu miyi pardija, manu watiya-wati-jana muku rdilyki-pajurnu. ");
INSERT INTO wbp_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kala yangka ngurrangka Kujunurla, kujalpalu Yijirali-pinki nyinaja, kula ngapa kunarda-kurlu wantija yalirla, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ngula-jangka, Yijipi-wardingki kingirli-palangu yimi yilyaja Mujujuku manu Yarunuku yungu-palarla yani nyanunguku nyanjaku. Kuja-pala yukajarra, nyanunguju-palangu wangkaja, “Ngaju-panuju ngarrika! Ngaju karna warntarla nyina YAAWIYI-kijaku. YAAWIYI-mipaju-ka jungarni nyina ngaju-piya-wangu. Ngajulurlu manu ngaju-nyangu yapangkurnalu-nyarra yilyayarla kutu Yijipi-ngirli warla-pajirninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Waraa! Wangkayajurla YAAWIYI-ki. Payika yungu wirnpa-wangu-mani manu ngapa kunarda-kurlu-wangu-mani. Murrumurru-mani kanganpa. Kajili nyuntu-nyangu yapa ngampurrpa nyina Yijipi-ngirli yaninjaku, kularna-jana warla-pajirni pina.” ");
INSERT INTO wbp_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mujujurla wangkaja kingiki, “Ngurrju, kapurna wilypi-pardi nyampu-ngurlu kirri-ngirli. Kajirna yani, kapurnaju rdaka-jarra kankarlu-mani, manu kapurnangkurla wangkami YAAWIYI-ki. Ngula-jangka, kapu ngapa kunarda-kurlu warla-pajirni. Kula-nyarra yarda jangkardu yilyamirra, manu kulanpa wirnpaju purda-nyanyilki. Kujarlanya kapunpa milya-pinyi walya-watiji YAAWIYI-ki. ");
INSERT INTO wbp_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ngaju, milya-pinyi-jala karna-nyarra nyuntu manu nyuntu-nyangu warrkini-wati kula kankulurla lani-jarrimi YAAWIYI Kaatuku murnma-juku.” ");
INSERT INTO wbp_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Nyampu-puru, marna-kari-wati ngurungka Yijipirla, ngulajulpalu karrija jinjirla-wati. Manu miyi-kari, yirnmilpalu karrija yapaku pajirninjaku. Kala ngapa kunarda-kurluju kuja wantija yalkiri-ngirli, ngulangku maju-manu muku miyiji. ");
INSERT INTO wbp_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Panu-kari ngurlu, ngulajulpalu pardija-juku wanka-juku. Ngapa kunarda-kurluju wantija nyanungurrarlangurla. Kula-jana maju-manu. Pardinja-yanu-jukulpalu ngaka yungulu yapangku warru mani. ");
INSERT INTO wbp_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ngula Mujujurlu yampinja-yanu kingi, wilypi-pardinjarla yanu kirri-ngirliji. Rdaka-jarra-nyanu kankarlu-manu, manu wangkajarla YAAWIYI-ki. Ngula ngapa kunarda-kurluju lawa-jarrija, manu wirnparlangu lawa-manu. ");
INSERT INTO wbp_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kingirli nyangu kuja-kurra, kala lawa. Kula jungarni-jarrija, lawa. Yarda jurru marntarla-jarrija, manu nyanungu-nyangu warrkinirlangulu jurru marntarla-jarrija. ");
INSERT INTO wbp_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Yuwayi, kingiji jurru marntarla-jarrija, warla-pajurnu-jana Yijirali-pinki yapa Yijipi-ngirli yaninja-kujaku. Kuja-yijala YAAWIYI-ji wangkaja kamparru yangka kapu kingi jurru marntarla-jarrimi-pina-yijala nganta. ");
INSERT INTO wbp_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Yaninjarla wangkayarla Yijipi-wardingki kingiki. Ngajulurlurna-jana nyanungu manu nyanungu-nyangu warrkini-patu jurru marntarla-manu. Jurru marntarla-manurna-jana yungurna-jana ngaju-nyangu yartarnarri milki-yirrarni nyampurla ngurungka. ");
INSERT INTO wbp_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ngajulurlurna-jana jurru marntarla-manu yungunpa-jana nyuntu-nyangu kurdukurduku manu warringiyi-puraji-patuku yimi-ngarrirni ngaju yangka kujarna-jana Yijipi-wardingki-patu manyu-pungu manu nyarrparlu kujarna-jana yartarnarri ngaju-nyangu milki-yirrarnu nyampurla ngurungka. Ngula-jangka kapunkujulu milya-pinyi ngaju YAAWIYI.” ");
INSERT INTO wbp_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Junga-juku, Mujuju manu Yarunu-palarla yanu Yijipi-wardingki kingiki nyanjaku. Yukajarra-pala yuwarli wiri-kirra, manu wangkaja-palarla, “Kujanya kangku YAAWIYI yangkaju nganimpa-nyangu Kaatuju nyuntukuju wangkami, ‘Tarnngangku mayi kapunpaju ngajuju jamulu purda-nyanyi wangkanja-kurra? Ngaju-nyangu yapa yungulu yani jilja-kurra ngajuku yungujulurla pulka-pinyi yalirlaju. Kula-jana warla-pajika! ");
INSERT INTO wbp_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kajinpaju wurra-mani, manu kajinpa-jana ngaju-nyangu yapa warla-pajirni, jukurraju kapurna yilyamirra panu-jarlu-nyayirni jintilyka nyuntu-nyangu nguru-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Jintilyka-watiji kapulu yani ngurujarraranypa Yijipirlaju. Kapulu walya jutu-mani. Kulalu yapangkuju walyaju nyanyi. Yangka ngapa kunarda-kurlu kuja wantija nguru-ngurlu, ngulangkuju miyiji maju-manu pardinja-kujaku. Kala wita ngari-ka miyiji pina-pardinja-yani. Yuwayi, yinya jintilyka-wati kajili yanirni, kapulu muku maju-mani miyiji pardinja-kujakuju. Manu kapulu parrkaju muku ngarni watiya-jangkaju. ");
INSERT INTO wbp_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Panu-jarlu jintilyka kapulu yuka nyuntu-nyangu yuwarli-kirra manu warrkini-patu-kurlangu-kurrarlangu. Panu-jarlu jintilyka kapulu yukami Yijipi-wardingki yapa-kurlangu yuwarli-kirra. Nyurrurla-nyangu nyurnunyurnu kujalpalu nyinaja nyurru-wiyi, ngularrarlu kulalu-jana nyangu panu-jarlu jintilyka kuja-piya, lawa. Kula-jana nganangku Yijipi-wardingkirli nyangu jintilyka panu-jarlu kuja-piya, lawa.’” Kujanyarla Mujujuju wangkaja Yijipi-wardingki kingikiji, manu yanulku. ");
INSERT INTO wbp_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ngula-jangka, kingi-kirlangu warrkinilirla wangkaja, “Nyampurlu watingki Mujujurlu kangalpa maarr-pakarni. Maju-mani muku-ka nyiyarningkijarra nyampurla ngurungka! Nyiya-jangka kanpa warrarda wurra-mani? Yilyaya-jana wati Yijirali-pinki nyampu-ngurlu nguru-ngurlu yungulurla nyanungu-nyangu YAAWIYI-ki Kaatuku pulka-pinyi jiljangka.” ");
INSERT INTO wbp_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Junga-juku, yinyarrarlu warrkinirlili-jana manunjunu Mujuju manu Yarunu, manulu-jana kangurnu pina kingi-kirra. Wangkaja-palangu, “Yuwayi, kajinkili ngampurrpa nyina pulka-pinjaku YAAWIYI-ki nyumpala-nyangu Kaatuku, ngulajulu yanta kutu! Kularna-nyarra warla-pajirni. Nyajangu-patu-wiyi kapunkulu yani jilja-kurraju?” ");
INSERT INTO wbp_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mujujurlu yalu-manu, “Kapurnalu panu-juku yani, jalangu-warnu-patu manu purlkapurlka, karnta manu wati, jiyipi manu puluku. Kapurnalu yaninjarla kurapaka wiri ngarni, manu kapurnalurla pulka-pinyi YAAWIYI-ki.” ");
INSERT INTO wbp_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kingirla wangkaja Mujujuku, “Lawa! Ngari kanpa kulukupurda wangka kujaju yungunkulu-nganpa wuruly-yani nyampu-ngurlu ngurra-ngurlu. Kula rampal-manngu-nyangka kularna-nyarra ngurrju nyina nyurrurlaku nganta, lawa. Marda-nyarra YAAWIYI-rli warrawarra-kanyi, karija. Yungunpa-jana mayi karnta manu kurdukurdu kanyi nyuntu-kurlu? Lawa! Kapurna-jana warla-pajirni. ");
INSERT INTO wbp_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Lawa! Nyuntu manu wati-patu-mipalu yanta jilja-kurraju pulka-pinjaku YAAWIYI-ki. Kujakunyalpanpaju payurnu.” Ngulalu-jana kingi-kirlangu wati-paturlu Mujuju manu Yarunu yilyaja kingi-kirlangu yuwarli-ngirli. ");
INSERT INTO wbp_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Rdaka-nyanu kankarlu-manta, manu warru jiily-ngarrika Yijipirla. Ngula-jangka, panu-jarlu jintilyka-wati kapulu yanirni, kapulu ngurra-kari ngurra-kari yani Yijipirlaju. Yangka ngapa kunarda-kurlu kuja wantija nguru-jangka, ngulangkuju-jana muku maju-manu marna manu watiya. Kala kalu pina-pardinja-yani marnaju. Yinya jintilyka-watirli kapulu yaninjarla muku ngarni marnaju manu parrkaju watiya-jangkaju.” ");
INSERT INTO wbp_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Junga-juku, Mujujurlu manu watiya jukati nyanungu-nyangu, warru jiily-ngarrurnu Yijipi-wana warrukirdikirdi. Ngula-jangka, YAAWIYI-rli yilyajarni warlpa wiri-jarlu kakarrara-ngurlu. Warlpaju kilji-nyayirni warrarda wangkaja parra wiri manu munga wiri. Parra-karirla, kuja wanta pardijarni, warlpangku-jana kangurnu jintilyka-wati panu-jarlu. ");
INSERT INTO wbp_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Panu-jarlu-nyayirni jintilykajulpalu paarr-pardija warru manu jurljurl-pungu warru Yijipirlaju warrukirdikirdi. Nyampu-wangurla-wiyi kula-jana nganangku nyangu jintilyka panuju kuja-piyaju. Jalangurlangu kulalu-jana kuja-piya nyangu, lawa! ");
INSERT INTO wbp_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Jintilykajulpalu jurljurl-pungu warru walya-wana, walyajulu maru-manu-nyayirni. Kuja yangka ngapa kunarda-kurlu wantija nguru-jangka, ngula-jangka marna manu watiyalu muku pardija pina. Jintilykarlu muku ngarnu marna manu parla watiyarla manu miyi-wati kujalpalu watiyarla pardija. Mukulu ngarnu nyiyarningkijarra. Marna manu watiya-wangulpa karrija Yijipirlaju, lawa! ");
INSERT INTO wbp_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ngula-jangka, Yijipi-wardingki kingirli-palangu yimi yilyaja Mujujuku manu Yarunuku yungu-palarla yanirni nyanjaku. Kuja-pala yanurra, wangkaja-palangu, “Ngajulparnarla maju wangkaja YAAWIYI-kiji nyumpala-nyangu Kaatuku. Yungurnangkupala purda-nyangkarla-juku. ");
INSERT INTO wbp_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kulaju-pala kulu-jarriya, yawuru-jarriyaju-pala kunka-maninja-wangu. Wangkaya-palarla nyumpala-nyangu Kaatuku YAAWIYI-ki yungu-jana jintilyka-wati kanyi nganimpa-kujaku. Lawangkaju kajikarnalu muku palimi!” ");
INSERT INTO wbp_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Junga-juku, Mujujurlu kingiji yampinja-yanu yalirla-juku. Ngularla wangkaja YAAWIYI-ki. ");
INSERT INTO wbp_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yinyarlu warlpangku kuja-jana kangurnu jintilyka-wati, kakarrara-ngurlulpa wangkajarni. Kuja YAAWIYI-rli purda-nyangu Mujuju wangkanja-kurra, karlirr-manu, karlarra-ngurlulkulpa warlpaju wangkaja. Warlpangku-jana muku manu jintilykaju, manu-jana kujurnu muku mangkuru-kurra. Ngula-jangka, lawalpa karrija jintilyka-wangu Yijipirlaju. ");
INSERT INTO wbp_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ngula-jangkaju, YAAWIYI-rli warla-pajurnu-juku kingiji Yijirali-pinki-kijaku Yijipi-ngirli yilyanja-kujaku. Jurru marntarla-jukulpa nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Kankarlu-manta-nyanu rdaka nguru-kurra, ngulaju kapu maru-jarrimi Yijipirla. Yapa kapulu wapami pampa-piya, kapulu-nyanurla warru marnpirni nyarrpara-wana yungulu yani.” ");
INSERT INTO wbp_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Junga-juku, Mujujurlu-nyanu rdaka kankarlu-manu yalkiri-kirra, ngula maru-jarrija muku Yijipirla. Marulpa karrija marnkurrpaku parraku. ");
INSERT INTO wbp_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Yapangku kulalu-nyanu nyarrparlu nyangkarla munga-puru. Parra marnkurrpa-patuku Yijipi-wardingki kulalu wurna yantarla, lawa. Kulalu nyangkarla nyiyarlangu wita. Yijirali-pinkijilpalu nyinaja parrangka-juku. ");
INSERT INTO wbp_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ngula-jangka, Yijipi-wardingki kingirlirla yimi yilyaja Mujujuku. Kuja yanurnu, kingirla wangkaja, “Yuwayi, kajinkili nyurrurla nyina-juku ngampurrpa YAAWIYI-ki pulka-pinjaku, ngulajulu kutu yanta! Kularna-nyarra warla-pajirni. Kangkalu-jana karnta manu kurdukurdu. Kala yampiyalu-jana jiyipi, narnukutu manu puluku nyampurla-juku.” ");
INSERT INTO wbp_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mujujurla kulu-jarrija kingiki, “Lawa, kulalparnalu-jana yampiyarla nganimpa-nyangu jiyipi manu narnukutu purdangirli! Kanyi karnalu-jana yungurnalurla purranjarla yinyi YAAWIYI-ki Kaatuku. ");
INSERT INTO wbp_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kanyi karnalu-jana muku puluku-wati nganimparlu. Kularnalu jintarlangu yampinja-yani purdangirliji, lawa. Yungurnalurla purranjarla yinyi YAAWIYI-ki Kaatuku yungurnalurla pulka-pinyi. Kula karnalu milya-pinyi nyajangu mayi yungurnalurla purrami. Kajirnalu ngurra yali-kirra-jarrimi, YAAWIYI-rli kapu-nganpa yimi-ngarrirni nyajangu yungurnalurla purrami.” ");
INSERT INTO wbp_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kala YAAWIYI-rli warla-pajurnu kingiji Yijirali-pinki yilyanja-kujakuju. Jurru marntarla-jukulpa nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ngula-jangka, kingirla wangkaja Mujujuku, “Yanta nyampu-ngurlu, manu kula pinarni yanta! Kajinpaju yanirni pina, kapunpa palimi!” ");
INSERT INTO wbp_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mujujurlu yalu-manu, “Ngurrju, nyuntulunpaju wangkaja yaninjaku. Yanilki-kila karna. Kularnangku yanirni pina nyuntukuju nyanjaku.” ");
INSERT INTO wbp_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","YAAWIYI-rla wangkaja Mujujuku, “Kapurna-jana yarda murrumurru-mani jinta-kariki Yijipi-wardingki kingi manu nyanungu-nyangu yapa-patu. Ngula-jangka yungu-nyarra yilyamilki Yijipi-ngirliji. Kaji-nyarra kingirli yilyami jilja-kurra, kapu-nyarra jinyijinyi-mani yaninjaku panu-juku. ");
INSERT INTO wbp_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Yaninjarla wangkaya-jana Yijirali-pinki karntaku manu watiki yungu-jana Yijipi-wardingki-patu payirni pirli yaltirilki manu kawurluku.” Kujanyarla YAAWIYI-ji wangkaja Mujujukuju. ");
INSERT INTO wbp_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ngula-wangurla-wiyi, Yijipi-wardingki-paturlu kalalu-jana Yijirali-pinki nyurunyuru-jarrinjarla manyu-pungu. Kulalpalu-jana yulkaja. YAAWIYI-rliji-jana Yijipi-wardingki-patuju jinyijinyi-manu nyanungurrakuju pulka-pinjaku. Kingi-kirlangu wati-paturlangurlu manu Yijipi-wardingki-paturlu yapangku, manngu-nyangulu Mujujuju wiri. ");
INSERT INTO wbp_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ngula-jangka, Mujujurla wangkanjunu kulu Kingiki, “Kujanya kangku YAAWIYI-ji wangkami nyuntukuju, ‘Jalangu mungangka kapurna warru yani Yijipirla. ");
INSERT INTO wbp_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ngajurna YAAWIYI. Kajirna warru yani, kuja-puruju kapulu kamparru-warnu-wati kaja-nyanu-wati muku palimi. Kingi yangka kuja-ka wiri nyina Yijipiki, kapu nyanungu-nyangu kaja-nyanurlangu palimi. Warrkini-patu karnta-kurlangu-paturlangu kapulu palimi. Puluku-kurlangu kamparru-warnurlangu kapulu palimi muku. ");
INSERT INTO wbp_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ngula-jangka, Yijipi-wardingki-patuju kapulu muku yulami wajampa. Kulalu kuja-piya nyurru-wiyi yulaja. Manu kulalu kuja-piya yarda yulami, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nyampu-puru, Yijirali-pinki kapulu yulanja-wangu nyina ngurrju-juku. Kala malikirli kapulu-jana warlkurr-jirrirni Yijipi-wardingki-patuju yulanja-kurra manu nyanungurra-nyangu pulukurlangu. Malikirli kulalu-jana warlkurr-jirrirni Yijirali-pinkiki, lawa. Ngula-jangka kapuju kingirli milya-pinyi ngajulu YAAWIYI-rli karna-jana Yijirali-pinki yapa warrawarra-kanyi Yijipi-wardingki-piya-wangu.’ Kujanya kangku YAAWIYI-ji wangkami nyuntukuju. ");
INSERT INTO wbp_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ngula-jangka, nyuntu-nyangu warrkini-patu kapujulu yaninjarla parntarrimi ngajuku. Kapujulu wangkami, ‘Mujuju, yanta nyampu-ngurlu, manu kangka-jana nyuntu-nyangu yaparlangu, yangka kuja kangkulu nyuntu purda-nyanjarla purami.’ Kujanya kapujulu wangkami ngajuku. Kajijili kuja wangkami ngajuku, kapurna-jana yampinjarla jurnta yani.” Yuwayi, Mujujuju kulu-nyayirni! ");
INSERT INTO wbp_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Kingirli kulangku purda-nyanyi. Kuja-jangkaju kapurna-jana Yijipi-wardingki-patuku milki-yirrarni ngaju-nyangu yartarnarri yungujulu milya-pinyi ngajuju jinta-juku Kaatu.” ");
INSERT INTO wbp_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Yuwayi, junga kujaju. Mujujurlu manu Yarunurlu kala-palarla warrarda milki-yirrarnu kingiki YAAWIYI-kirlangu yartarnarri yangka kujalpa-jana murrumurru-manu Yijipi-wardingki-patu. YAAWIYI-rliji warla-pajurnu warrarda kingiji Yijirali-pinki-kujaku yilyanja-kujaku Yijipi-kijakuju. Jurru marntarla-jukulpa nyinaja. Kula-jana yilyaja. ");
INSERT INTO wbp_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","2","YAAWIYI-palangu wangkaja Mujujuku manu Yarunuku, “Kuja-ka yangka tarnnga watiya yukirilki pina-pardinja-yani, ngula-puru-ka kirntangi wita-wiyi wilypi-pardinjarni yani. Kajinkili yali nyanyi kirntangi wilypi-pardinja-kurra, ngulaju yaliji kamparru-warnu kirntangi. ");
INSERT INTO wbp_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nyuntu-jarra, wangkanjintalu-jana Yijirali-pinki yapaku, kujalu-jana wangkaya, ‘Pardakalu-nganpa karlarla-palaku parraku. Ngula-jangkaju, nyurrurlarlu wati-paturlu jarnkujarnku maninjintalu-jana jalangu-warnu jiyipi-patu nyurrurla-nyangu warlalja-patuku ngayi, yangka kuja kankulu nyina yuwarli-kari yuwarli-karirla. ");
INSERT INTO wbp_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kajilpalu marnkurrpa-mipa nyinakarla yapa wati-kirlangu warlaljarla, ngulaju marda kulalpalu kuyuju muku nganjarla. Kujaju maju. Kuja-kujakuju, yinya wati manu nyanungu-nyangu warlaljalpalu jinta-jarriyarla warlalja-patu-kari-kirli kuja kalu kutu-mirnimirni nyina yungulu kuyuju muku ngarni. ");
INSERT INTO wbp_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Nyiya-piya jiyipiji kajikankulu nyurrurlarluju wati-paturluju milarni? Yinya jiyipilpa nyinakarla jintaku yulyurrpukuju wirriya-yijala ngurrju, nyurnu-wangu. Kajilpanpa jiyipiki palka-maninja-wangu nyinakarla, ngulajungku kurdu-warnu narnukutu manta! ");
INSERT INTO wbp_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Kajinkili-jana jarnkujarnku jiyipi mani, wankarulu-jana mardaka murntu-palaku parraku. Ngula-jangka, kaji wanta yuka, yungunkulu Yijirali-pinkirli watingki pinyi jiyipi manu narnukutu junma-kurlurlu nyurrurla-nyangu warlalja-patuku. ");
INSERT INTO wbp_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ngula-jangka, yapangku yungunkulu yalyungku maparni tuwa-wana kankarlumparra manu ngurlju-wana yuwarlirla kuja kankulu yapangku purranjarla ngarni jiyipi. ");
INSERT INTO wbp_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mungangka jintangka-juku yungunkulu purrami jiyipiji warlungka. Yungunkulu kuyuju ngarni kumarlpa yangka parrka-piya-kurlurlu manu miyi lalypa-kurlurlu. ");
INSERT INTO wbp_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Kulalu kuyuju wanka nganja, kulalu ngapangka purraya, lawa. Wanapijikili purraya warlungka jurru, wanarri-jarra manu murlkurlangu. ");
INSERT INTO wbp_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Mukulu nganja. Kaji wanta kankarlu-jarri, kajili kuyuju palka-juku nguna, yampiyalu ngarninja-wangurlu. Yirrakalu warlungka yungu jankami yulypulypa-karda. ");
INSERT INTO wbp_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","12","“Kujarlukulpankulu nyurrurlarluju kuyuju nganjarla: Ngarninjakungarntijili yukaya jurnarrparla manu putungka. Watiya jukatili-nyanu mardaka wurna kula-nganta kankulu yani. Nganjalu kuyu manu miyi kapankurlu. Kapunkulu nyampuju kurapaka kuyuju yirdi-mani ‘Pajapa’. Munga jintangka-juku kapurna paarr-pardimi warru Yijipi-wana. Kapurna-jana pinyi kamparru-warnu kaja-nyanu-patu manu puluku-watirlangu Yijipirla warlalja-kari warlalja-karirla. Ngajurna YAAWIYI. Kapurna-jana yartarnarri jurnta kanyi juju-kari juju-kariki yangka kuja kalu-jana Yijipi-wardingki-paturlu pirli manu watiya-jangka ngurrju-maninjarla purami. ");
INSERT INTO wbp_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Yinya yangka yalyu tuwangka, kajirna yalyu nyanyi tuwa-watirla, kapurna paarr-pardimi kankarlumparra nyurrurlarla. Kapurna-nyarra yampimi murrumurru-maninja-wangurlu. Kala kapurna-jana Yijipi-wardingki-patu-puka murrumurru-mani. ");
INSERT INTO wbp_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Jalangu-jangka, nyurrurlarlu yapangku yungunkulu nyampu parra manngu-nyanyi. Yulyurrpu-kari yulyurrpu-kari kaji kamparru-warnu kirntangi palka-jarrimi nyurrurlarlu manu nyurrurla-nyangu kurdukurdurlu yungunkulu kurapaka Pajapa ngarni ngajuku pulka-pinjaku. Yuwayi, nyurrurla-nyangu kurdukurdurlu manu nyanungurra-nyangu kurdukurdurlu kapujulu pulka-pinyi tarnngangku-juku kuja-piyarlu-yijala. ");
INSERT INTO wbp_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Purlapaju kapu karri wirlki-pala parraku. Kuja-puruju kapunkulu miyi lalypa ngarni. Kulankulu miyi kapurduju ngarni tarltu-jarrinja-warnu, lawa. Kaji purlapa rdirri-yinyi, parra kamparru-warnurla mantalu yangka miyi-kirlangu tarltu-maninja-kurlangu kuja-ka yuwarli nyurrurla-nyangurla marda nguna, manulu kijika ngarninja-wangurlu. Kaji nganangku ngarni miyi kapurdu tarltu-jarrinja-warnu purlapa-puru, ngulajulu yapa yinyaju yilyaya tarnnga-juku. Yapa yinyaju kulaju nyina ngajukulku, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Purlapa-puru, kamparru-warnu parrangka manu purdangirli-warnu parrangka-yijala, yungunkujulurla jinta-jarrinjarla pulka-pinyi ngajuku. Nyampu parra-jarra-puru kulankulu warrki-jarrimi, lawa. Purrayalu-nyanu kuyu ngarninjaku, kujaju ngurrju. Kala warrki-wangulu-nyinaya. ");
INSERT INTO wbp_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Kuja-piyarlu yungunkulu purlapa-puru ngarni nyampu kurapaka yirdiji ‘Miyi Lalypa’. Kapunkulu ngarni yinya miyi lalypa purlapa-puru yungunkulu manngu-nyanyi kujarna-nyarra Yijipi-ngirli kangurnu turnu-kari turnu-kari 12-palarla. Jalangu-jangka yungulu kurdukurdu nyurrurla-nyangurlu manngu-nyanyi manu nyanungurra-nyangu kurdukurdurlu parra nyampu wajawaja-maninja-wangurlu. Nyampuju ngaju-nyangu kuruwarri nyurrurlaku. Purayalu tarnngangku-juku! ");
INSERT INTO wbp_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Yuwayi, yulyurrpu-kari yulyurrpu-kari kaji kamparru-warnu kirntangi palka-jarrinjarni yani, 14-palaku parra-patuku nyinayalu. Ngula-jangkaju pardakalurla kaji wanta yukami. Ngula-jangkaju, nganjalu miyi lalypa-mipa. Nganjalu yinya miyi lalypa-mipa wirlki-pala parraku purlapa-puru. ");
INSERT INTO wbp_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Wirlki-pala-puru, kijikalu muku yangka miyi-kirlangu tarltu-maninja-kurlangu yuwarli-ngirliji. Kaji nganangku-puka ngarni miyi kapurdu purlapa-puru, ngulajulu yilyaya nyurrurla-kujakuju tarnnga-juku. Nyampu kuruwarri Yijirali-pinkiki manu yapa-karirlanguku. Nyurrurlarlulu tarnngangku-juku puraya nyampu kuruwarri nyarrpararlangurla kajinkili nyina.’” ");
INSERT INTO wbp_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ngula-jangka, Mujujurlu-jana yimi yilyaja purlka-patu Yijirali-pinkiki nyanungu nyanjaku. Kujalu yanurnu, nyanungu-jana wangkaja, “Jinta-kari jinta-karirlili manta jiyipi jalangu-warnu nyurrurla-nyangu warlalja-paturla. Pungkalu-jana yungunkulu nyurrurla-nyangu warlalja-kurlurlu nyampu kurapaka ngarni. ");
INSERT INTO wbp_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kajinkili-jana pinyi jiyipi-wati, winjikalu yalyu ngami-kirra. Ngula-jangka, julyurl-yirraka parrka yalyungka. Yinya-kurlurlu parrka-kurlurlu mapakalu tuwa-wana yalyu-kurlurlu kankarlumparra manu ngurlju-wana. Ngula-jangka, nyurrurla manu nyurrurla-nyangu warlalja-patulu nyinaya kaninjarni-jiki ngaka kaji wanta kankarlu-jarri mungalyurru. Kulalu wilypi-pardiya! ");
INSERT INTO wbp_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mungangkarlu, YAAWIYI kapu warru yani marramarra-kurlu nganayi Riwarri-maninja Wita-wangu-kurlu. Mapirrirli kapulu-jana Yijipi-wardingki-patu pinyi. Kaji YAAWIYI-rli yalyu nyanyi nyurrurla-nyangu tuwa-paturla, kapu kankarlumparra-juku paarr-pardimi. Kula-nyarra pinyi. Kapu warla-pajirni yinya marramarra Riwarri-maninja Wita-wangu Yijirali-pinki pinja-kujakuju. ");
INSERT INTO wbp_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Nyurrurlarlu yungunkulu nyampu kuruwarri tarnngangku-juku purami. Nyampuju kuruwarri nyurrurlaku manu nyurrurla-nyangu kurdukurduku manu nyanungurra-nyangu kurdukurdurlanguku. ");
INSERT INTO wbp_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Purayajukulu nyampuju kuruwarri ngaka yangka kajinkili yukamirra jinta-kari ngurra-kari-kirra yangka kuja-nyarra YAAWIYI-rli jangku-pungu. ");
INSERT INTO wbp_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Nyurrurla-nyangu kurdukurdurlu kapulu-nyarra payirni kujarlu, ‘Nyiya-jangka karlipa nyampuju kurapaka kuyu ngarni? Nyiya-jangka karlipa-jana pinyi jiyipi manu narnukutu kujarluju?’ ");
INSERT INTO wbp_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Kajili-nyarra payirni kujarlu, yalu-mantalu-jana kujarlu, ‘Kuyu nyampu karlipa ngarni yungurliparla YAAWIYI-ki pulka-pinyi kuja-ngalpa kangu Yijipi-ngirli. Yuwayi, ngalipa Yijirali-pinki kalarlipa nyinaja Yijipirla. Ngula YAAWIYI yanu Yijipi-wana, pungu-jana Yijipi-wardingki-patu. Paarr-pardija ngalipa-nyangu yuwarli-wanaju kankarlumparra. Yampija-ngalpa pinja-wangurlu. Mardarnu-ngalpa palinja-kujaku.’” Kujalu Yijirali-pinkirli yimi nyampu purda-nyangu, parntarrijalpalurla walya-kurra YAAWIYI-ki pulka-pinjaku. ");
INSERT INTO wbp_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ngula-jangka, yapa-patujulu pina-yanu ngurra-kurralku. Pungulu-jana jiyipi, manu yalyungkulu maparnu tuwa-wati. YAAWIYI-jana kujakunya wangkaja. ");
INSERT INTO wbp_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kulkurru-kari, YAAWIYI-rli-jana pungu Yijipi-wardingki kamparru-warnu kaja-nyanu-patu warlalja-kari warlalja-karirla. Pungu kingi-kirlangu kaja-nyanurlangu manu pirijina-wati-kirlangurlangu kaja-nyanu-wati. Puluku-kurlangu manu jiyipi-kirlangu-jana kurdu kamparru-warnurlangu muku pungu. ");
INSERT INTO wbp_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Munga jintangkaju, kingi manu nyanungu-nyangu warrkini-patulu muku yakarra-pardija. Warlalja-kari warlalja-karirla wajawaja-manulu-jana kaja-nyanu kamparru-warnu-patu. Kuja-jangkaju, mukulu yulaja wajampa. ");
INSERT INTO wbp_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ngula-jana YAAWIYI-rli wirriyawirriya pungu manu puluku-watirlangu, munga jintangka-juku-palangu kingirli yimi yilyaja Mujujuku manu Yarunuku yungu-pala nyanja-yani nyanungu. Kuja-palarla yanurnu, wangkaja-palangu, “Nyurrurla Yijirali-pinki yantalu, yampiyalu-nganpa! Jilja-kurra yungunkulurla pulka-pinyi YAAWIYI-ki yalirla. ");
INSERT INTO wbp_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Kangkalu-jana nyurrurla-nyangu jiyipi, narnukutu, tangkiyi manu puluku-watirlangu. Yantalu-jana jirrnganja jilja-kurra. Manulu YAAWIYI payika ngajurlanguku yunguju warrawarra-kanyi.” Kujanya-palangu kingiji wangkaja Mujujukuju manu Yarunuku. ");
INSERT INTO wbp_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ngula-jangka, Yijipi-wardingki-patulu-jana wangkaja Yijirali-pinkiki, “Kajilpankulu nyinakarla-juku nyampurla Yijipirla yaninja-wangu-juku, kapurnalu muku palimi! Kuja-kujakuju yantalu yaruju!” ");
INSERT INTO wbp_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Yijirali-pinkirli yapangkulu nyurru-juku pulawa manu ngapa nyulyarnu, kulalurla yirrarnu tarltu-maninja-kurlangu wiri-maninjaku, lawa. Pulawa manu ngapalu jinta-manu ngami-paturla. Kujalu-jana Yijipi-wardingki-patu wangkaja Yijirali-pinkiki ngurraku yampinja-yaninjaku, jinta-kari jinta-karirli Yijirali-pinkirlili jarnkujarnku manu pulawa ngapa-kurlu jinta-maninja-warnu, warurnulu yakuju-kurra, manulu yirrarnu parrajarla yungulu kanja-yani jimantarla wurnangkuju. ");
INSERT INTO wbp_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ngula-jangkaju, warrulpalu-jana payurnu Yijipi-wardingki-patu yangka kujalpalu nyanungurra-wana nyinaja kutu. Payurnulu-jana jilpaku manu kawurluku manu jurnarrpaku. Mujuju-jana kujanya wangkaja Yijirali-pinkiki kamparru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Kujalu-jana Yijirali-pinkirli payurnu Yijipi-wardingki-patu yinjaku nyiyarningkijarraku, Yijipi-wardingki-patu kulalu-jana kulu-jarrija, manu kulalu-jana nyiya jurnta mardarnu, lawa. YAAWIYI-jana nyurru-juku wangkaja Yijipi-wardingki-patukuju yungulu-jana yimirirli yinyi Yijirali-pinkiki. Kujarlanyalu-jana yungu nyiyarningkijarraju. Kujarlunyalu-jana muku puntarnu Yijirali-pinkirliji Yijipi-wardingki-patukuju ngurra yinyakungarntirli yampinjakungarntirli. ");
INSERT INTO wbp_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ngula-jangka, Yijirali-pinkili yanu Ramiji-ngirli Jakaja-kurra. 600,000-pala wati, karnta manu kurdukurdurlangulpalu wapanja-yanu. ");
INSERT INTO wbp_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Panu-kari ngurrara-kari-wardingki-paturlangurlulu yampinja-yanu Yijipiji. Mapirrilpalu yanu wurnaju. Kangulu-nyanu panu-jarlu jiyipi, narnukutu manu puluku. ");
INSERT INTO wbp_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kujalu kulkurru ngunajarra, purrajalu-nyanu miyi lalypa yangka tarltu-maninja-kurlangu-wangu. Kujalpalu Yijipikingarnti yampinjakungarnti nyinaja, ngulajulpalu kapanku-jarrija wurnaku. Kulalu-nyanu nyarrparlu purrayarla miyi kapurdu, lawa. Kujarlanyalpalu miyi lalypaju ngarnu. ");
INSERT INTO wbp_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Yijipi yampinjakungarnti, Yijirali-pinkijilpalu nyinaja yalirlaju 430-pala yulyurrpuku. ");
INSERT INTO wbp_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ngula-jangka, parra jintangka-juku, YAAWIYI-kirlangu yapangkulu yampinja-yanu Yijipiji 12-pala turnu-warnu-kari turnu-warnu-karirli. ");
INSERT INTO wbp_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Munga jintangka-juku, YAAWIYI-rlilpa-jana warrawarra-kangu Yijirali-pinki yapa kuja-jana kangu Yijipi-ngirli. Kujarlanya jalangurlangu Yijirali-pinkirlilpalu manngu-nyangkarla nyampu parra wajawaja-maninja-wangurlu. Yungulpalu manngu-nyangkarla yangka kuja kala-jana YAAWIYI-rli nyanungurrakupalangu nyurnunyurnu warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ngula-jangka, YAAWIYI-palangu wangkaja Mujujuku manu Yarunuku, “Yungurna-nyarra yinyi kuruwarri Pajapaku purlapaku yungunkulu purami jungangku. Purlapa-puru yungunkulu Yijirali-pinkirli-puka kurapaka ngarni jiyipi manu narnukutuju. Nguru-kari-wardingki-paturluju kulalpalu nganjarla nyampuju kurapaka. ");
INSERT INTO wbp_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kaji Yijirali-pinkirli nganangku-puka payi-mani yapa-kari ngurrara-kari-wardingki tala-kurlurlu warrkiki yungurla nyanunguku warrki-jarri, kaji ngarrka-kijirni yinya warrkini purlapakungarntirli, ngula-jangka yinyarlu warrkinirli kajika kuyuju ngarni purlapa-puruju. ");
INSERT INTO wbp_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Kala kaji warrkini ngana-puka nyina ngarrka-kijirninja-wangu, ngulaju kulalpa nganjarla kuyuju purlapa-puruju. Manu kajilpa nyinakarla yapa-kari ngurrara-kari-wardingki nyurrurla-kurlu nyurrurla-nyangu ngurrangka, ngulaju lawa-juku kulalpa nganjarla kuyuju. ");
INSERT INTO wbp_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Kajinkili nyurrurlarlu Yijirali-pinkirli ngarni kuyu purlapa-puru, nyinakalu kaninjarni yuwarlirla. Kulalu kangka yarlu-kurra kuyuju ngarninjaku, manu kulalu yungkurnu rdilyki-pungka. ");
INSERT INTO wbp_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Nyampu-puru purlapa-puru, nyurrurlarlu Yijirali-pinkirli yungunkulu ngarni kuyu yinyaju panungku-juku. ");
INSERT INTO wbp_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kajilpa yapa-kari nguru-kari-wardingki nyinakarla ngarrka-kijirninja-wangu, manu kajilpa ngampurrpa nyinayarla kuyu kurapakaku ngarninjaku purlapa-puru, kulalpa nganjarla. Kujakungarntijili ngarrka-kijika-wiyi manu panu-kari wati-paturlangu manu wirriyawirriyarlangu yungulu-nyarra kuyuju jirrnganja ngarni. ");
INSERT INTO wbp_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Nyampu kuruwarri jinta-juku Yijirali-pinkiki manu yapa-karirlanguku yangka kuja kalu nyina nyurrurla-kurlu.” Kujanya-palangu YAAWIYI-ji wangkaja Mujujuku manu Yarunuku purlapa-kurlu Pajapa-kurlu. Ngula-jangka, Mujujurlu manu Yarunurlulu-jana yaninjarla yimi-ngarrurnu Yijirali-pinki-kariki. ");
INSERT INTO wbp_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Kujalu Yijirali-pinkirli purda-nyangu nyampu kuruwarri, kuja-palangu YAAWIYI-rli yungu Mujuju manu Yarunuku, ngulajulpalu purda-nyanjarla puraja. ");
INSERT INTO wbp_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Parra jintangka-juku-jana YAAWIYI-rli yilyaja Yijirali-pinki Yijipi-ngirli. Yilyaja-jana 12-pala turnu-warnu-kari turnu-warnu-kari. ");
INSERT INTO wbp_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","2","YAAWIYI Kaaturla wangkaja Mujujuku, “Kajili Yijirali-pinkirli karntangku kurdu wirriya mardarni kamparru-warnu, yungkajulu yinyaju wirriya yunguju ngajuku warrki-jarri. Manu kajili pulukurlu, jiyipirli marda, narnukuturlu manu tangkiyirli kurdu mardarni kamparru-warnu, ngulajujulu ngajuku yungka warntarri. Nyampurra kamparru-warnu-wati ngulajujulu ngajuluku.” ");
INSERT INTO wbp_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ngula-jangka-jana Mujujuju yapaku wangkaja, “Jalangurlipa Yijipi-jangka wilypi-pardija. Jalangu-jangka manngu-nyangka warrardalu nyampuju parra wajawaja-maninja-wangurlu. Kalankulu pirijina-piya warrki-jarrija Yijipirlaju, kala YAAWIYI-rli-nyarra yali-ngirliji kangurnu yartarnarri-kirlirli. Parra nyampu-jangka miyi lalypa-mipalu nganja. Kulalu miyi kapurdu nganja-yangka tarltu-maninja-kurlangu-kurlu. ");
INSERT INTO wbp_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Yulyurrpu-kari yulyurrpu-kari kajinkili nyanyi kamparru-warnu kirntangi wilypi-pardinja-kurra, manngu-nyangkalu yangka kuja-ngalpa YAAWIYI-rli kangurnu Yijipi-ngirli. ");
INSERT INTO wbp_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Nyurru-wiyirli YAAWIYI-rli-jana jangku-pungu nyampuju walya ngalipakupalangu-patuku nyurnunyurnuku. Kuja-jana wangkaja, ‘Ngaka kapurna-nyarra yinyi walya kuja kajana jalangu nguna Kanana-wardingkiki, Yititiki, Yamuriki, Yiipitiki manu Jipujiki.’ Kujaju junga. YAAWIYI-rliji kapu-ngalpa nguru-yirrarni kuja-ka miyi panu nguna. Kajirlipa yani yali-kirra, yulyurrpu-kari yulyurrpu-kari yungurlipa turnu-jarri parra nyampuku manngu-nyanjaku. Yungurlipa parra nyampurla jinta-jarri kaji palka-jarrimi kamparru-warnu kirntangi. ");
INSERT INTO wbp_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kajirlipa turnu-jarri, yungurlipa miyi lalypa-mipa ngarni wirlki-pala parraku. Yampimirlipa miyi jinta-kariji kapurduju ngarninja-wangurlu. Ngula-jangka parra nampa wirlkingka yungurliparla kurapaka wiri ngarni YAAWIYI-ki pulka-pinjaku. ");
INSERT INTO wbp_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Nyampuju junga. Kajirlipa nguru yali-kirra yukamirra, wirlki-pala parra-puru yapa yungurlipa mangarri kapurdu yangka tarltu-maninja-kurlangu-kurlu ngarninja-wangu nyina, yungurlipa yampimi. ");
INSERT INTO wbp_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Kajirlipa jinta-jarri yali kurapaka wiri ngarninjaku, ngalipa-nyangu kaja-nyanurlu marda kajikalu-ngalpa payirni kujarlu, ‘Wapirra, nyiyaku karlipa jinta-jarri nyampukuju kurapakakuju?’ Yalu-manirlipa-jana kujarlu, ‘Kaja, YAAWIYI-rli-ngalpa kangurnu Yijipi-ngirliji. Warrawarra-kangu-ngalpa. Kujarlanya karlipa jinta-jarrimi kurapaka ngarninjakuju yungurlipa manngu-nyanyi nyanungu.’ ");
INSERT INTO wbp_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Yuwayi, kajirlipa jinta-jarri kurapakaku, yungurlipa manngu-nyanyi YAAWIYI kuja-ngalpa warrawarra-kangu. Kapurlipa nyina yangka-piya yapangku kuja kalu yirrarni YAAWIYI-kirlangu yimi yiriwarrarla jurrungka manu rdaka-kurlangurla. Kularlipa wajawaja-mani. Kurapaka wiri-puru kapurlipa-jana pinarri-mani kuruwarri YAAWIYI-kirlangu ngalipa-nyangu kurdukurduku. Kapurlipa manngu-nyanyi kuja-ngalpa Yijipi-ngirli kangurnu yartarnarri-kirlirli. ");
INSERT INTO wbp_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Purda-nyangkajulu! Yulyurrpu-kari yulyurrpu-kari kaji kamparru-warnu kirntangi palka-jarrinjarni yani, turnu-jarriyalu warrarda kurapaka yinyaku. ");
INSERT INTO wbp_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“YAAWIYI-rli kapu-ngalpa kanyi walya yali-kirra kuja kajana karri jalanguju Kanana-wardingkiki. Nyampuju walya ngulaju yangka kuja-jana jangku-pungu nyurru-wiyi ngalipakupalangu-purnuku nyurnunyurnuku. ");
INSERT INTO wbp_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Ngaka kajirlipa walya yalirla nyina, yungurlipa kuruwarri nyampu purami: Kaji Yijirali-pinkirli karntangku kurdu wirriya mardarni, yungkarla YAAWIYI-ki yungurla warrki-jarri. Manu pulukurlu, jiyipirli, narnukuturlu manu tangkiyirli, kajili-jana kurdu kamparru-warnu mardarni, yungkalurla YAAWIYI-ki warntarri. Kamparru-warnu-wati nyiyarlangu kalurla YAAWIYI-ki nyina. ");
INSERT INTO wbp_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kaji tangkiyirli karntangku kurdu wirriya mardarni kamparru-warnu, marda kajikanpa-nyanu nyuntulurlu mardarni. Ngulaju ngula-juku. Kala mardarninjakungarntirli pungka jalangu-warnu jiyipi, manu purrayarla warntarri YAAWIYI-ki. Ngula-jangka, yungunpa-nyanu tangkiyi mardarnilki. Kala kajinpa jiyipi pinja-wangu nyina, ngulaju tangkiyi yinya kurdu pungka, kakarda rdilyki-pungka. Kajili wirriya kamparru-warnu-patu palka-jarri warlalja-kari warlalja-karirla nyurrurla-nyangurla, wirriya-patu yinya-patu kalurla nyina YAAWIYI-ki. Kala kula-jana pungka jiyipi-piya, lawa. Kuja-kujakuju talajurla yungka YAAWIYI-kiji. Ngula-jangka, wirriya yali-patuju yungulurla warrki-jarri YAAWIYI-mipaku. ");
INSERT INTO wbp_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Kajirlipa-jana pinjarla purrami jiyipi kujarlu, ngalipa-nyangu kaja-nyanu-paturlu marda kajikalu-ngalpa payirni kujarlu, ‘Wapirra, nyiya-jangka kankulu-jana kamparru-warnu puluku, jiyipi, manu narnukutuju pinyi? Nyiya-jangka kankulu-jana pinjarla purrami?’ Kujarlipa-jana yalu-mani, ‘Kaja, YAAWIYI-rli-ngalpa kangurnu Yijipi-ngirliji yartarnarri wiri-kirlirli. Warrawarra-kangu-ngalpa. Kalarnalu-jana warrki-jarrija pirijina-piya. ");
INSERT INTO wbp_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Yijipi-wardingki kingilpa jurru marntarla nyinaja, kulalpa purda-nyangu YAAWIYI-ji. Kala-ngalpa warrarda warla-pajurnu yaninja-kujakuju. Kujarlanya-jana YAAWIYI-rli muku pungu kaja-nyanu-patu kamparru-warnu-wati warlalja-kari warlalja-karirla. Manu-jana pungu jiyipi, puluku, narnukutu manu tangkiyi wirriyawirriya-juku kamparru-warnu-paturlanguju. Kujarlanya karna-jana kamparru-warnu wirriyaju muku pinyi puluku, jiyipi manu narnukuturlangu yangka kuja kalurla YAAWIYI-ki nyina. Kujarlanya karna-jana purranjarla yinyi warntarri YAAWIYI-ki. Kuja ngaju-nyangu kaja-nyanu kamparru-warnu palka-jarrija, kularna pungu, lawa. Kujarlajurna jiyipilki pungu, ngularnarla purranjarla YAAWIYI-ki yungu.’ Kujanya yungurlipa-jana wangka ngalipa-nyangu kaja-nyanukuju kajili-ngalpa payirni. ");
INSERT INTO wbp_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Yuwayi, kajirlipa jinta-jarri kurapaka wiriki, yungurlipa manngu-nyanyi YAAWIYI kuja-ngalpa warrawarra-kangu. Kapurlipa nyina yangka-piya yapangku kuja kalu yirrarni YAAWIYI-kirlangu yimi yiriwarrarla jurrungka manu rdaka-kurlangurla. Kularlipa wajawaja-mani. Kurapaka-puru kapurlipa-jana pinarri-mani kuruwarri YAAWIYI-kirlangu ngalipa-nyangu kurdukurduku. Kapurlipa manngu-nyanyi kuja-ngalpa Yijipi-ngirli kangurnu yartarnarri-kirlirli.” ");
INSERT INTO wbp_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ngula-jana kingirli Yijipi-wardingkirli Yijirali-pinki yilyaja Yijipi-ngirli, Kaaturlu kula-jana nguru-yirrarnu yirdiyi-wana kuja-ka ngula Pilijiya-kurra ngunami, lawa. Yiwarra yinyaju-ka nguna Yijipi-ngirli Pilijiya-kurra. Kaaturlulpa manngu-nyangu kuja, “Kajirna-jana Yijirali-pinki kanyi yinyarla yirdiyirla kuja-ka nguna Pilijiya-kurra, kajikalu-jana lani-jarri Pilijiya-wardingki-patuku kulu-kujaku. Ngula marda kajikalu pina-yani Yijipi-kirra.” Kujanya Kaaturlu manngu-nyangu. ");
INSERT INTO wbp_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ngula-jana kangu jinta-kari-wana, kangu-jana jilja-wana mangkuru wiri-kirra yirdi-kirra Marna Kirrirdi-kirra. Yijirali-pinkirlilpalu-jana mardarnu kurlarda manu kurdiji kulukungarntirli. ");
INSERT INTO wbp_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mujujurlu kanja-yanu Jajupu-kurlangu yungkurnu. Nyurru-wiyi kuja Jajupu palija, ngulakungarntiji wangkaja-jana nyanungukupurdangka-patuku kuja, “Kaaturlu kapu-nyarra warrawarra-kanyi-jiki nyurrurlaju. Kapu-nyarra nguru-kanyi nyurrurlaku manu nyurrurla-nyangu warlalja-patuku nyampu-ngurlu walya-ngurlu Yijipi-ngirli. Ngarrikajulu kajirna palimi yungunkulu ngaju-nyangu yungkurnu kanyi kajinkili pina-yani Kanana-kurra.” ");
INSERT INTO wbp_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kujalu Yijirali-pinkirli yampinja-yanu Yijipi, yaninjarlalu ngunaja Jakajarla. Ngulalu yampinjarla yanu Yiijama-kurra. Yiijamaju ngulaju jiljangka kutu. ");
INSERT INTO wbp_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","22","YAAWIYI-rli-jana milki-yirrarnu nyarrpara-wana yaninjaku. Nyanunguju kamparru yanu kajili nyanungurrarlu nyanyi. Parra-puru, nyanunguju kamparru yanu mangkurdu kirrirdimpayi-piya. Mungangkajulpa yanu warlu jarra-piya kirrirdimpayi-piya. Kala-jana kujarlu-juku nguru-yirrarnu parrangka manu mungangka. Kula-jana yampija. ");
INSERT INTO wbp_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Wangkaya-jana Yijirali-pinkiki yungulu pina-yani Piyarata-kurra. Wangkaya-jana yungulu ngunami kulkurru Mikitalarla manu Mangkururla Marna Kirrirdirla. Nyampuju kutu jinta-kariki ngurra-kariki Paala Jiipuyunuku. ");
INSERT INTO wbp_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Yijipi-wardingki kingirli kapu kuja manngu-nyanyi, ‘Yuwa! Yinya Yijirali-pinkirli kula kalu milya-pinyi nyarrpara-kurra mayi kuja kalu yani. Kulalpajulu wuruly-parnkayarla jurntalku. Kapurna-jana rdipimi jiljangka.’ Kujanya kapu kingirli manngu-nyanyi. ");
INSERT INTO wbp_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kapurna kingiji jurru marntarla-mani yungu-nyarra wajirli-pinyi. Kapurna-jana muku pinyi, manu nyurrurlarlu yungunkujulurla pulka-pinyi. Ngula-jangka yungujulu Yijipi-wardingki-paturlu milya-pinyi ngajuju YAAWIYI Kaatu nyiyarningkijarraku manu yapa jintawarlayiki.” Kujanyarla YAAWIYI-ji wangkaja Mujujukuju. Yijirali-pinkirlili purda-nyangu YAAWIYI kuja-jana nyarrpa wangkaja nyanungurraku. Yaninjarlalu ngunaja kutu Paala Jiipuyunurla. ");
INSERT INTO wbp_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Nganangku mayi yimi-ngarrurnu kingiji kujalu Yijirali-pinki wuruly-parnkaja. Kuja kuja purda-nyangu, nyanungu manu nyanunguku warrmarla-patulu-nyanu wangkaja, “Waraa! Nyiyakurlipa-jana nyangu jamulu Yijirali-pinkiji wuruly-parnkanjakuju? Warla-pajikarlarlipa-jana! Nganalku kapu-ngalpa warrki-jarrimi?” ");
INSERT INTO wbp_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ngula-jangkaju, kingirli manu nyanungu-nyangu nantuwu-kurlangu wirli-jarra-kurlu, yirrarnu-nyanu kurlarda manu kurdiji kulukungarntirli. ");
INSERT INTO wbp_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Wangkaja-jana nyanungu-nyanguku warrmarlaku 600-palaku yungulu-nyanu jarnkujarnku mani nantuwu-kurlangu wirli-jarra-kurlu wiri-jarlu. Yanulu kingi-kirli manu warrmarla panu-kari-kirlangu wirli-jarra-kurlurla kujalpalu Yijipirla nyinaja. Yinyarra warrmarla-wati kujalpalu nyinaja wirli-jarra-kurlurla, ngulajulpalu-jana wiriwiri nyinaja warrmarla panu-kariki. ");
INSERT INTO wbp_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Junga kujaju. YAAWIYI-rli kingiji jurru marntarla-manu. Wajirli-pungu-jana Yijirali-pinki kujalpa-jana YAAWIYI-rli warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Kingirli manu nyanungu-nyangu warrmarlarlulu-jana wajirli-pungu Yijirali-pinki. Kutu-jarrijalu-jana kujalpalu ngunaja Mangkuru-wana Marna Kirrirdi-wana. Nyampujulpa kutu karrija Piyarataku manu Paala Jiipuyunuku. ");
INSERT INTO wbp_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kujalu-jana Yijirali-pinkirli nyangu Yijipi-wardingki-patu yaninjarni-kirra, lani-jarrija-nyayirnili, wangkajalurla YAAWIYI-ki yungu-jana muurl-mardarni palinja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Wangkajalurla Mujujuku, “Waraa! Nyiyakunpa-nganpa kangurnu Yijipi-ngirliji? Kapurlipa muku palimi. Nyinayarla-jukurlipa Yijipirla, manurlipa paliyarla yalirla-juku! ");
INSERT INTO wbp_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kujalparnalu Yijipirla nyinaja, wangkajarnangkulu kuja, ‘Yampiya-nganpa! Kula karnalu ngampurrpa nyina Yijipi yampinjaku nyuntu-kurlu. Yungurnalu nyina manu warrki-jarri nyampurla-juku.’ Kujanyarnangkulu wangkaja. Kala jinyijinyi-manu-jukunpa-nganpa, kapurlipa muku palimi nyampurla-juku jiljangka!” ");
INSERT INTO wbp_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mujuju-jana wangkaja, “Ngulaju ngula-juku. Kulalu wajampa-jarriya! Pardakalurla YAAWIYI-ki nyampurla-juku, kapu-nyarra muurl-mardarni. Nyanyi kankulu-jana Yijipi-wardingki-patu kutu yaninjarni-kirra? Jalangu-jangka kulankulu-jana nyanyi pinalku. ");
INSERT INTO wbp_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yirriyirri-jarriyalu jata-nyanja-wangu! Kulajulu kulu-jarriya! YAAWIYI-rli kapu-jana pinyi Yijipi-wardingki-patuju.” ");
INSERT INTO wbp_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Nyiyaku kanpaju purlami ngajukuju? Wangkaya-jana Yijirali-pinkiki yungunkulu Mangkuru-kurra Marna Kirrirdi-kirli-kirra yani. ");
INSERT INTO wbp_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Watiya jukati kankarlu-manta, manu jiily-ngarrika ngapa! Ngapa yinyaju kapu raa-parnka, ngula-jangka kapunkulu Yijirali-pinki wapami kulkurru-jarra walya pardunarla. ");
INSERT INTO wbp_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Jurru marntarla-manurna-jana Yijipi-wardingki-patuju. Kujarlanya kapulu-nyarra ngapa-wanaju wajirli-pinyi. Ngula-kujakuju kapurna-jana yurnilyka-maninjarla muru-pinyi ngapangka. Kapurna-jana riwarr-pinyi kingi manu nyanungu-nyangu warrmarla wirli-jarra-kurlurla. Ngula-jangka Yijirali-pinkirli yungujulurla pulka-pinyi. ");
INSERT INTO wbp_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ngula-jangka Yijipi-wardingki-paturlu yungujulu milya-pinyi ngajuju YAAWIYI Kaatu nyiyarningkijarraku manu yapaku jintawarlayiki.” ");
INSERT INTO wbp_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kaatu-kurlangu marramarra kala kamparru yanu Yijirali-pinkikiji, kala-jana milki-yirrarnu nyarrpara-wana yaninjaku, manu mangkurdurlangu kala kamparru wapaja nyanungurrarla. Kala yinya marramarra manu mangkurdu purdangirlilkilpa-pala wapaja, warrawarra-kangulpalu-jana Yijipi-wardingki-kijaku. ");
INSERT INTO wbp_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Yuwayi, mangkurdujulpa kulkurru-jarra karrija Yijirali-pinkiki manu Yijipi-wardingki-patukuju. Munga-puru kala Yijirali-pinkirlijilpalu nyangu wanta-piya. Mangkurduju-jana wapirrija Yijipi-wardingki-patukuju yungulu nyanja-wangu nyina munga-piya-puru. Kuja-jangka munga-piya-puru kulalu-jana kutu-jarrija Yijirali-pinkikiji. ");
INSERT INTO wbp_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ngula-jangkaju, Mujujurlu jukati manu nyanungu-nyangu, ngula jiily-ngarrurnu ngapa. YAAWIYI-rli warlpa yilyajarni kakarrara-ngurlu, warlpa warrarda wangkaja munga wiri, ngula ngapaju raa-pungu kulkurru-jarra, ngulalpa walya pardunalku karrija. ");
INSERT INTO wbp_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ngulalu Yijirali-pinki kulkurru-jarra yaninja-yanu walyangkalku, ngapajulpa karrija pirli rdingki-piya. ");
INSERT INTO wbp_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ngulalpalu kingirli manu nyanungu-nyangu warrmarlarlu puraja walyangka-yijala kulkurru-jarra ngapa-wana. ");
INSERT INTO wbp_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Munga-puru-juku wanta-wangu-jukulpa karrija. YAAWIYI-rlilpa-jana nyangu Yijipi-wardingki-patu mangkurdu-ngurlurlu manu jarra-ngurlurlu, ngula-jana warungka-manu, manulpalu paa-karrija. Kulalu milya-pungu nyarrpa-jarrinjaku. ");
INSERT INTO wbp_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Wirlijili nantuwu-kurlangurlaju muku yukaja parljungka, kulalu wilypi-pardiyarlalku. Ngulalu-nyanu Yijipi-wardingki-patu purlaja, “Yakaa! Yanirlipa nyampu-ngurluju Yijirali-pinki-kijakuju! Nyanungurra-nyangu Kaatu YAAWIYI-rli kangalpa pinyi!” ");
INSERT INTO wbp_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ngulalu Yijirali-pinki murrarni-pirdinypa-kurra-jarrija, YAAWIYI-rla wangkaja Mujujuku, “Jukati kankarlu-manta yarda, ngula jiily-ngarrika ngapa! Kajinpa kuja-jarri, kapu-jana ngapangkuju muku yurnilyka-maninjarla muru-pinyi manu yawurlinji-manilki Yijipi-wardingki-patuju manu nyanungurra-nyangu wirli-jarra-kurluju.” ");
INSERT INTO wbp_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Junga-juku Mujujurlu jukati-kirlirli jiily-ngarrurnu ngapaju. Wantajulpa kankarlu-jarrinja-yanulku. Ngula ngapa jiily-ngarrurnu, ngapaju jinta-jarrija pina. Yijipi-wardingki-patu nganta yungulu kunamurrumurru-jarriyarla, kala lawa. YAAWIYI-rli-jana jutu-manu muku ngapa-kurlurlu. ");
INSERT INTO wbp_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Junga, ngapaju pina jinta-jarrija, ngula-jana jutu-manu muku Yijipi-wardingki warrmarla manu nyanungurra-nyangu wirli-jarra-kurlu. Kula ngana wankaruju nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Yijirali-pinkijilpalu wankaru-juku nyinaja. Karrijalpalu murrarninginti ngapa wiringkaju. ");
INSERT INTO wbp_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Kujarlunya-jana YAAWIYI-rliji muurl-mardarnu Yijirali-pinkiji Yijipi-wardingki-patu-kujakuju. Yijirali-pinkirlili-jana nyangu nyurnu-wati ngunanja-kurra ngapa-wana. ");
INSERT INTO wbp_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Milya-pungulu kuja-jana YAAWIYI-rli muurl-mardarnu yartarnarri wiri-kirlirli. Karrijalpalu wurdungu-nyayirni, manu wangkajalu-nyanu, “Junga, YAAWIYI-ji ngurrju-nyayirni! Walarliparla nyina, kapu-ngalpa warrawarra-kanyi. Manurliparla Mujujuku wala nyina kuja-ngalpa YAAWIYI-rli milarnu wiri nyinanjaku ngalipaku.”… ");
INSERT INTO wbp_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","…Mujujurlu-jana Yijirali-pinkiki yapaku nguru-yirrarnu Mangkuru-ngurlu Marna Kirrirdi-kirli-ngirli. Nguru-yirrarnu-jana Jilja-kurra yirdi-kirraju Juuru-kurra. Wapajalpalu marnkurrpaku parraku, kulalu ngapa palka-manu, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ngulalu yukajarra ngurra-kurra yirdi-kirraju Maara-kurra. Ngapalpa palka ngunaja yalirlaju. Kala lawa, kulalu nganjarla. Ngapaju kumarlpa-nyayirni. Kujarlanya ngurra yinyajulu yirdi-manu Maraa. (Jaru nyanungurra-nyangurlaju yirdi Maaraju ngulaju ‘Kumarlpa’.) ");
INSERT INTO wbp_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Yapajulurla Mujujukuju kulu-jarrija, kulalu ngapa-wiyi ngarnu, manulu payurnu, “Yuwa! Nyiyalkurlipa ngarni? Ngapa nyampuju kumarlpa!” ");
INSERT INTO wbp_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Kula nyarrpa-mantarla Mujujurluju, ngularla YAAWIYI-kilki wangkaja, “Wangkayaju nyarrpa-jarrimirna!” Ngularla YAAWIYI-rli milki-yirrarnu watiya. Mujujurlu watiya yinyaju kujurnu ngapa-kurra. Ngula ngurrju-jarrijalku ngarninjakuju. Ngula-jana YAAWIYI-rli kuruwarri jinta-karilki yungu yapa-patukuju yangka yungulu jungarni nyinami. Kuruwarri-jana yungu waalparrirninjaku marda kajilirla wala nyina-japa manu kajili ngurrjungku puramiki-japa. ");
INSERT INTO wbp_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Wangkaja-jana, “Ngajurna YAAWIYI Kaatu kuja kankujulu pura. Kajirna-nyarra nyarrpa wangkami, purda-nyangkajulu kulu-wangurlu! Kapurna-nyarra wangkami jungarni nyinanjaku. Jungarnijili nyinaka ngajuku. Purayalu ngaju-nyangu kuruwarri jungarnirli. Kajinkili kuja nyina, kularna-nyarra nyurnu-mani yangka kujarna-jana Yijipi-wardingki-patu nyurnu-manu yangka kamparru-wiyi. Yuwayi, ngajuju YAAWIYI. Ngajunya yangka kuja karna-nyarra parlpuru-mani.” ");
INSERT INTO wbp_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ngula-jangka, yapajulu yanu ngurra jinta-kari-kirra yirdi-kirraju Yilimi-kirra. Yilimirlajulpa ngunaja 12-pala mulju manu 70-pala watiya. Ngulalu yapaju ngunaja ngapa-wana. ");
INSERT INTO wbp_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nguru-jangka yirdi-jangkaju Yilimi-jangka, Yijirali-pinkijili yanu Jilja-kurra yirdi-kirraju Jini-kirra. Nyampuju ngurra kulkurru-jarra Yilimiki manu Jayinayiki. Yijipi kujalu yampinja-yanu, wapajalu murntu-palaku wiyikiki, ngulalu nyinaja Yilimirlalku. ");
INSERT INTO wbp_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mangarri-wangulpa ngurra yinyaju karrija, ngulalu yapaju kulu-jarrija, manulurla wangkaja Mujujuku, ");
INSERT INTO wbp_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Yuwa! Nyiyakunpa-nganpa kangurnu nyampu-kurra ngurra punku-kurraju? Kapurlipa yarnunjuku palimi! Yijipirlajurlipa miyi panu mardarnu ngarninjaku kuyurlangu. Kaji-ngalpa YAAWIYI-rli pungkarla yalirla, ngulaju ngurrju. Kala jalangu ngari kapurlipa muku palimi kutu nyampurlaju!” ");
INSERT INTO wbp_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ngularla YAAWIYI-lki wangkaja Mujujuku, “Kapurna-nyarra miyi patapata-kijirni nguru-jangka. Kapunkulu miyi panulku ngarni. Kapurna-nyarra warrarda patapata-kijirni parra-kari parra-karirli yungunkulu-nyanu mani warrarda. Parra-kari parra-kari kapurna-nyarra waalparrirni marda kapunkujulu purda-nyanyi-japa. ");
INSERT INTO wbp_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Purayiti-kari Purayiti-kari yungunkulu-nyanu miyi panu turnu-mani. Yungunkulu-nyanu panu-jarlu miyi mani yungunkulu purranjarla ngarni Purayitirla manu Jarrirtiyirlangurla Parra-nyayirni-wangurla.” ");
INSERT INTO wbp_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ngulalu-jana Mujuju manu Yarunu wangkaja yapaku, “Kularnalu-nyarra ngajarrarlu kangurnu Yijipi-ngirli, lawa. Jalangu mungangka kapunkulu milya-pinyi kuja-nyarra YAAWIYI-rli kangurnu Yijipi-ngirliji. ");
INSERT INTO wbp_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","Jukurrarlu kapunkulu YAAWIYI nyanyi miril-maninja-kurra, kapu yanirni nyurrurla-kurra. Kujankulu-nganpa ngajarraku kulu-jarrija, ngulajunkulurla YAAWIYI-ki kulu-jarrija. Purda-nyangu-nyarra. Nyanungunya-jarrangku wangkaja nyurrurlakuju kanjarnikiji nyampu-kurrakuju. Ngarilparlijarra nyanungu purda-nyangu. Ngajarraju ngari warrkini nyanungu-nyangu.” Ngula-jana Mujuju wangkaja, “Purda-nyangkajulu! Parra-kari parra-kari kaji wanta yukamirra, YAAWIYI-rli kapu-nyarra kuyu yinyi ngarninjaku, manu mungalyurru-kari mungalyurru-kari kapu-nyarra miyi yinyi ngarninjaku. Kapunkulu ngarni, kulankulu yarnunjuku-jarri.” ");
INSERT INTO wbp_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ngula-jangka, Mujujurla wangkaja Yarunuku, “Wangkaya-jana kuja Yijirali-pinkiki, ‘Nyurrurla YAAWIYI-rli-nyarra purda-nyangu kujalpankulu-jarrangku kurnta-ngarrurnu ngajarra. Kujarlanya, turnu-jarriyalu nyampurla maralypirla.’” ");
INSERT INTO wbp_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Junga-juku, Yarunurlu-jana turnu-manu yapa-patu, manu wangkaja-jana. Kujalpa-jana wangkaja, yapangkujulpalu jilja-kurra nyangu wurnturu. Ngula mangkurdu palka-jarrija wurnturu-nyayirni, miril-manulpa. YAAWIYI-lpa nyinaja mangkurdurla yalirlaju. ");
INSERT INTO wbp_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Ngularla YAAWIYI wangkaja Mujujuku, “Purda-nyangurna-jana Yijirali-pinki yapa kujalpalu-nyarra kurnta-ngarrurnu nyuntu manu Yarunu. Wangkaya-jana kuja, ‘Parra-kari parra-kari kaji wanta yukamirra, kapunkulu kuyu panu ngarni. Manu mungalyurru-kari mungalyurru-kari kapunkulu miyi panu ngarni. Kulankulu yarnunjuku-jarrimilki. Ngula-jangka kapunkujulu milya-pinyi ngajuju YAAWIYI Kaatu.’” ");
INSERT INTO wbp_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Parra jintangka-juku, kuja wanta yukajarra, panu-jarlu jurlpu pintarulu paarr-pardija ngurra-kurra kujalpalu Yijirali-pinki nyinaja. Nguru-ngurlulu wantiwantija, manulurla walyaku wapirrija. Mungalyurru kuja wanta kankarlu-jarrija, yinjirlpilpa ngunaja nyiyarningkijarrarla. ");
INSERT INTO wbp_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","15","Wantaju kankarlu-jarrijalku, ngula walyaju pati-manu, ngula yinjirlpi-wangu-jarrija. Yijirali-pinkirlili nyiya mayi nyangu walyangka. Kulalu kuja-piya nyangu nyurru-wiyi. Kardirri-nyayirni yapirilyi-piya. Payurnulpalu-nyanu, “Nyiya nyampuju?” Mujujurlu-jana yalu-manu, “Nyampuju miyi kuja-ngalpa YAAWIYI-rli yilyajarni ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Kujanyaju YAAWIYI-ji wangkaja, ‘Yungulu-nyanu parraja maninjarla warru turnu-mani miyi, warrardalu-nyanu panu mani parraja-kurra parra-kari parra-karirli.’” ");
INSERT INTO wbp_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Jungajukulu Yijirali-pinkirli jarnkujarnku manu parraja, manu warrulpalu miyi. Ngalya-karirlili manu panu-jarlu, ngalya-karirlili wita manu. ");
INSERT INTO wbp_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ngulalu-nyanu milki-yirrarnu kujalu nyajangu manu. Ngalya-karirlili miyi panu manu. Ngalya-karirlili wita manu, ngulaju ngula-juku. Panu-jukulpalu miyiji ngarninjaku mardarnu. ");
INSERT INTO wbp_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ngula-jangka, Mujuju-jana wangkaja, “Nyurrurla kulalu ngayarrka-jarriya! Jalangurlujukulu muku nganja miyi kuja kankulu mardarni. Kulalu mardaka jukurra-kurra.” ");
INSERT INTO wbp_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Panu-kari yapajulu ngayarrka-jarrija. Kulalu Mujuju purda-nyangu. Kulalu muku ngarnu, mardarnulpalu ngalya-kari mungalyurru-karda. Miyi yinyaju pukulyulkulpa parntija pirlpi-kirli. Mujujuju-jana kulu-jarrija-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mungalyurru-kari mungalyurru-kari yapangkuju kalalu miyiji turnu-manu walya-jangka. Kalalu-nyanu manu ngarninjaku-ngarra parra jintangkaku-mipa. Ngula kala wanta kankarlu-jarrija, manu kala warlu-nyayirni jankaja. Kala miyiji tarlurr-kampaja wantangkuju. Yarlurr-kampanjarla walya-kurra muku karlija. ");
INSERT INTO wbp_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","23","Purayitirla, yapangku kalalu kartaku-jarra manu, kalalu miyiji yirrarnu. Ngulalurla wiriwiri panu-kari yaninjarla wangkaja Mujujuku, “Yapangkulu jarnkujarnku manu kartaku-jarrarla miyi panu walya-jangka.” Mujuju-jana wangkaja, “Ngulaju ngula-juku. Nyampunya-ka YAAWIYI-ji wangka: ‘Jukurraju Jarrirtiyi ngaju-nyangu Parra-nyayirni-wangu. Ngayi kapunkulu nyinami-mipa warrki-wangu. Jalangurlu miyili ngalya-kari purraya warlungka, manulu ngalya-kariji ngapa-kurlurlu kartakurla purraya. Mardakalu miyi ngarninjaku jukurraku.’” ");
INSERT INTO wbp_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Junga-juku, yapangkulu miyiji mardarnu mungalyurru-kurra yangka kuja-jana Mujuju wangkaja. Miyiji kula pukulyu-jarrija jirri-kirli, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ngula-jangka, Mujuju-jana wangkaja yapakuju, “Jalanguju Jarrirtiyi YAAWIYI-kirlangu Parra-nyayirni-wangu. Nyinayalu warrki-wangu. Kajinkili miyiki nganta yani warrirninjaku, kulankulu palka-mani, lawa. Ngarili miyiji nganja kujankulu pirrarnirli turnu-manu. ");
INSERT INTO wbp_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Nyampuju YAAWIYI-kirlangu kuruwarri ngalipaku yungurlipa yani miyiki warrirninjaku Palya-ngurlu Purayiti-kirra jika-pala parraku. Kala Jarrirtiyirla kularliparla miyikiji warrirni walyangkaju, lawa. Parra yinyaju tarruku YAAWIYI-ki.” ");
INSERT INTO wbp_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Junga kujaju. Kala parra jintangka Jarrirtiyirla, yapa ngalya-karili yanu miyiki nganta. Kala lawa, kulalu palka-manu. ");
INSERT INTO wbp_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ngularla YAAWIYI wangkaja Mujujuku, “Yuwa! Nyarrpa-jarrimi kankulu? Nyiya-jangka kula kankujulu purda-nyanyi yangka kujarna-nyarra nyarrpa wangkaja? ");
INSERT INTO wbp_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Purda-nyangkajulu! Ngarrurnurna-nyarra nyinanjaku Jarrirtiyirla warrki-jarrinja-wangu. Ngarrurnurna-nyarra Purayiti-kari Purayiti-kari kapurna-nyarra miyi panu-nyayirni yinyi yungunkulu ngarni parra-jarra jirramaku, manu Jarrirtiyi-kari Jarrirtiyi-karirla nyinakalu ngurrangka yaninja-wangu.” ");
INSERT INTO wbp_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Junga-juku, kuja-jangka yapajulpalu nyinajalku Jarrirtiyi-kari Jarrirtiyi-karirlaju warrki-wangu. ");
INSERT INTO wbp_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Yijirali-pinkirliji kalalu miyi yinyaju yirdi-manu ‘maana’, ngulaju ‘nyiya nyampuju?’. Maana ngulaju ngurlu witawita-piya kujalpalu pajarnu ngarlu-piya. ");
INSERT INTO wbp_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ngula-jangka, Mujuju-jana wangkaja yapakuju, “YAAWIYI-ji wangkaja yungurna ngalya-kari maana yirrarni murlukurnpa wiri-jarlurla yungulu ngalipa-nyangu kurdukurdurlu nyanyi nyiya-piya. Kajili nyanyi yinya miyi, kapulu manngu-nyanyi kuja-ngalpa YAAWIYI-rli kangurnu Yijipi-ngirli manu yangka kuja kala-ngalpa miyiji yungu jiljangka.” ");
INSERT INTO wbp_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ngularla Mujuju wangkaja Yarunuku, “Manta murlukurnpa wiri-jarlu, manu yirraka maana yangka miyi. Yirraka yungurlipa-jana ngalipa-nyangu kurdukurduku milki-yirrarni.” ");
INSERT INTO wbp_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Junga-juku, Yarunurlu manu murlukurnpa wiri-jarlurla, ngula maana yirrarnu. Ngula murlukurnpa yirrarnu Tarruku Pakujurla Kujalpalu Yijirali-pinkirli Tarruku Pakuju mardarnu, manngu-nyangulu yangka kujalpa-jana YAAWIYI-rli warrawarra-kangu yangka kuja ngarrurnu Yipuruyamu nyurru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Yijirali-pinkirlijilpalu maanaju ngarnu 40-pala yulyurrpuku. Kuja-puruju kalalu wapaja warru jilja-wana. Ngula-jangka kujalu Kanana-kurra-jarrija, YAAWIYI-rli kula-jana maanaju yungulku yinyarlanya. Kananarlalkulpalu Yijirali-pinkiji nyinaja tarnnga. ");
INSERT INTO wbp_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Yijirali-pinki yapalpalu ngunaja jiljangka yirdingkaju Jiningka. Yangka kuja kala-jana YAAWIYI wangkaja yaninjaku ngurra-kari-kirra, kalalu yanu. Ngula-jangkaju, ngunajalu Ripirdimirla. Kala lawalpa ngapa-wangu karrija yapakuju ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Jata-nyanjarlalurla kulu-jarrija Mujujukuju, manu wangkajalurla, “Yungka-nganpa ngapa ngarninjaku!” Mujuju-jana wangkaja, “Nyiya-jangka kankujulu kulu-jarrimi ngajukuju? Marda kankulu YAAWIYI-ji kapuru-nyinanjarla juwa-kijirni? Marda kankulu manngu-nyanyi yampija nganta-ngalpa warrawarra-kanja-wangurlu. Kajinkili kuja warrarda manngu-nyanyi, kapu-nyarra kulu-jarri!” ");
INSERT INTO wbp_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Yapajulpalu purraku-nyayirni nyinaja ngapakuju. Kulu-jarrinjarlalurla wangkaja Mujujukuju, “Nyiyakunpa-nganpa kangurnu Yijipi-jangkaju? Nyiyakunpa-nganpa kangurnu kurdukurdu manu nganimpa-nyangu jiyipi, puluku, manu narnukutu pinjaku mayi nyampurlaku? Nyarrpararnalu ngarni ngapaju?” ");
INSERT INTO wbp_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ngula Mujujurlu YAAWIYI payurnu, “Nyarrpa-manirna-jana nyampuju yapa? Kulajulu purda-nyanyi, kapujulu pirli-kirlirli luwarni!” ");
INSERT INTO wbp_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ngularla YAAWIYI wangkaja Mujujuku, “Manta-jana purlkapurlka. Wapaya kamparru yapa-patuku nyanungurra-kurlu. Kangka watiya jukati yangka kujanpa kangurnu Yijipi-ngirli yangka kujanpa ngapa pakarnu karru Niilirla. Yanta yaruju! ");
INSERT INTO wbp_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Yanta pirli wiri-kirra Jayinayi-kirra. Yalirla kapunpa yarturlu wiri nyanyi. Kapurna yarturlu yalirlaju kamparru karrimi nyurrurlaku. Jukati-kirlirli pakaka yinyaju yarturlu. Ngula kapu ngapalku wilypi-pardimi, ngula kapulu yapangku ngapa ngarni.” Junga-juku, Mujujurlu purda-nyangu YAAWIYI, yaninjarla pakarnu yarturluju kujalpalu purlka-paturlu nyangu. Ngula-jangka, ngapa karlijalku pirli-jangka. ");
INSERT INTO wbp_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mujujurlu ngurra yinyaju yirdi-manu ‘Maaja’, yirdi ngulaju ‘Kapurunju Panu’. Junga kujaju. Yinyarra Yijirali-pinki kujalpalu ngapa-wangu nyinaja, kapuru nyinanjarlalu-nyanu payurnulu, “YAAWIYI-ji mayi palka-juku ngalipa-kurluju? Warrawarra-kanyi-jiki mayi kangalpa?” Mujujurlu yirdi-karirla yirrarnu ngurraku yinyakuju ‘Miripa’, ngulaju yirdiji ‘Yapaju Kulu-nyayirni’. ");
INSERT INTO wbp_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Kujalpalu Yijirali-pinki nyinaja-juku Ripirdimirla, Yamili-patulu-jana kulu jangkardu yanurnu. ");
INSERT INTO wbp_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mujujurla wangka Jajuwaku, “Milaka-jana wati-patu yungunkulu-jana kulu jangkardu yani Yamili-patuku. Jukurra kapurna yani pirli yali-kirra karrinjaku. Kapurna jukati kanyi yangka kujaju Kaaturlu yungu mardarninjaku. Kapurna watiya yinyaju mardarni, manu kapurna jiily-ngarrirni nyurrurla-kurra yungunkulu-jana kulungku pinyi.” ");
INSERT INTO wbp_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Junga-juku, Jajuwarluju Mujujuju purda-nyangu, milarnu-jana wati-patu kuluku Yamili-patuku. Kulukungarnti, Mujujuju warrkarnu pirlingka Yarunu-kurlu manu wati jinta-kari-kirli yirdiji Yiiru-kurlu. ");
INSERT INTO wbp_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","12","Kankarlu-manu jukati rdakangku, ngulalpa mardarnu jurrungka kankarlarra. Kujalpa watiya kujarlu mardarnu, Yijirali-pinkirlijilpalu-jana pungu Yamili-patuju. Mujujuju purlka-pardu, manu rdakajulpa mata-jarrija. Kula nyarrparlu mardakarla jukatiji kankarlarra-kariji. Kuja rdaka kanunju-jarrija jiily-ngarrirninja-wangu, Yamili-paturlulpalu-jana pungu Yijirali-pinkiji. Kuja-kujakuju, Yarunurlu manu Yiirungku-pala manu wiri-jarlu yarturlu, manu yirrarnu-pala Mujuju-wana nyanunguku nyinanjaku. Ngula-jangka, Yarunurlu manu Yiirungku-pala puuly-mardarnu Mujuju-kurlangu rdaka yungu mardarni-jiki jukatiji yangka kujalpalu-nyanu wati-paturlu pakarnu-juku. Yarunujulpa jungarni-purdanji Mujujukuju karrija, manu Yiirujulpa jampu-purdanji karrija. Kujarlu-jukulpa-pala Mujuju-kurlangu rdaka-jarraju puuly-mardarnu yangka kuja wanta yukajarra. ");
INSERT INTO wbp_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kujarlunyalu-jana Jajuwarlu manu nyanungu-nyangu warrmarlarluju muku pungu Yamili-patuju. ");
INSERT INTO wbp_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Yirraka yimi puku-kurra nyampu-kurlu kulu-kurlu yungulu yapangku ngaka manngu-nyanyi wajawaja-maninja-wangurlu. Warrardarla yimi-ngarrika Jajuwaku nyampuju yimi. Wangkayarla kapurna-jana muku pinyi Yamili yapa-patu, kula jintarlangu wankaru nyina nyampurla walyangka!” ");
INSERT INTO wbp_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ngula-jangka, Mujujurlu pirli-wati murnju-yirrarnu yurturlurla pulka-pinjaku YAAWIYI-ki. Ngurra yinyaju yirdi-manu ‘YAAWIYI NIIJI’. Yirdi nyampuju ngulaju ‘YAAWIYIJI NGARLKINPA NGAJU-KUJU’. ");
INSERT INTO wbp_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ngula-jangka, Mujuju wangkaja, “Ngajulurlulparna mardarnu ngaju-nyangu jukati, manurna jiily-ngarrurnu kankarlarra yangka-kurra kuja-ka YAAWIYI nyina. YAAWIYI-rli kapu-jana warrarda pinyi Yamili-patuju tarnngangku-juku!”… ");
INSERT INTO wbp_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Ngulalu Yijipi yampinjarla yanu yapangku Yijirali-pinkirli, yaninja-yanulpalu wurna-juku kirntangi-jarraku jirramaku, manu parra-pardu-karirlajulu yukajarra Jilja-kurra yirdi-kirraju Jayinayi-kirra. Kulkurrulu ngurrara-karirla yirdingka Ripirdimirla ngunajarra. Kujalu ngakalku yukajarra Jayinayi-kirra, ngunajalu ngayirni pirli wararrarla yirdingka Jayinayirla. ");
INSERT INTO wbp_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mujujurla warrkarnu pirlingka YAAWIYI Kaatuku. Ngularla purlajalku Mujujuku pirli yinya-ngurlu kankarlu-ngurlu, manurla wangkaja nyanunguku, “Nyampunya-jana wangkaya wungu-warnuku Jakupu-kurlangukuju yapaku Yijirali-pinkikiji, ");
INSERT INTO wbp_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Nyurrurlarluju kankujulu manngu-nyanyi-yijala kujarna-jana yapa Yijipi-wardingki-patu murrumurru-manu-nyayirni. Milya-pinyi-jala kankujulu yangka kujarna-nyarra nguru-yirrarnu Yijipi-ngirli. Muurlparlurna-nyarra kangurnu ngurrara nyampu-kurraju. Warrawarra-kangulparna-nyarra wurnaju kujalpankulu wapaja warlawurru ngati-nyanu-piyarlu-juku yangka kuja kajana witawita nyanungu-nyangu warrawarra-kanyi kuja kalu paarr-pardinjaku pinarri-jarri. Ngula-piyarlu-yijalalparna-nyarra warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Purda-nyangkalkujulu wurra-maninja-wangurlu, manulu jungangku puraya kuruwarri ngaju-nyangu! Panu yapa ngurrara-kari ngurrara-kari kajulu nyinami ngajuku, kala kajikankujulu yalyangku purda-nyanyi, kapurna-nyarra milarni, kula ngularra yapa panu-kari. ");
INSERT INTO wbp_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Yungunkujulu purda-nyanyi manu purami ngaju-mipa. Kapunkujulu panu warrki-jarrimi ngajuku maralypikingarduyu-piyalku.’ Kujanya-jana wangkaya Yijirali-pinkiki.” ");
INSERT INTO wbp_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ngula-warnuju, Mujuju pina jitinja-yanu kaninjarra-kari pirlingka, manu-jana purlkapurlka wiriwiri warru turnuturnu-manu. Muku-jana yimi-ngarrurnu yangka nyarrpa kujarla nyanunguku wangkaja YAAWIYI pirlingka yinyarla. ");
INSERT INTO wbp_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ngula-jangka, wangkajalurla Mujujuku, “Ngulaju ngula-juku. Nyiyarninykijarra kuja-nganpa wangkaja YAAWIYI, kapurnalu yalyangku purda-nyanyi. Kapurnalurla nyinami manu warrki-jarrimi nyanungu-mipaku.” Ngula-jangkaju, Mujujuju pirlingka kankarlarra pina warrkarnu, manurla wangkaja YAAWIYI-ki, “Yapa nganta kalu wangkami kapungkulu nyinami manu warrki-jarrimi nyuntu-mipaku.” ");
INSERT INTO wbp_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Mangkurdu marungka kapurnangku kutu nyuntuku yanirni, manu kapurnangku wangkami. Yapangkuju kapujulu purda-nyanyi-yijala kajirnangku wangkami. Nyampu kuja karnangku wangkami, ngulaju yangka yapa yungungkulu wala warrarda nyinami nyuntuku.” Ngula-jangka, Mujuju jitinjarla pina-yanu pirli-jangka kujalpalu yapa nyinaja. Muku-jana yimi-ngarrurnu yangka nyarrpa kujarla nyanunguku wangkaja YAAWIYI. ");
INSERT INTO wbp_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ngula-jangka, Mujuju pina-warrkarnu kankarlarra pirli wararra-kurra, manurla YAAWIYI wangkaja nyanunguku, “Yaninjarla-jana wangkaya yapaku yungulu wurdujarra-jarri jalangurlu manu jukurrarlu ngajuku nyanjaku. Wangkaya-jana yungulu nyanungurra-nyangu jurnarrpa parljirni. ");
INSERT INTO wbp_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Parra jukurra-kari-warnurla, ngaju YAAWIYI kapurna yanirni kaninjarra-kari kankarlarra-jangka nyampu-kurra pirli wararra Jayinayi-kirra. Yapa panungku kapujulu nyanyi yaninjarni-kirra. ");
INSERT INTO wbp_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pirli wararrarlajulu yarti warru jaarl-yirraka, manulu-jana kurnta-ngarrika yalumpu-ngurluju. Kaji nganangku pirli wararra marnpirni, ngulajulu pungka tarnnga-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Marnpirninja-wangurlu ngarili kutu-pungka tarnnga-kurra pirli-kirlirli marda purnarra-kurlurlu nyurrurla-nyangu-kurlurlu. Junga, kajili yapangku manu nyiyarlangurlu pirli wararra marnpirni, ngulaju kapulu palimi. Kala kajinkili purda-nyanyi kurlumpurrngu purlanja-kurra kilji-kirra, ngula-jangkaju yungulu purlkapurlka wiriwiri wararrarlaju warrkarni.” Kujanyarla YAAWIYI-ji wangkaja Mujujukuju. ");
INSERT INTO wbp_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","15","Ngula-jangka, pirli-jangka kaninjarra-kari Mujuju pina jitinja-yanu yapa-patu-kurra. Nyanungu-jana wangkaja, “Parra jukurra-kari-warnurla, Kaatu kapu kankarlarra-jangka yanirni pirli-kirra wararra nyampu-kurra. Wurdujarra-jarriyalu yungunkulu kamparru karrimi nyanungurla. Nyurrurla ngarrka, kulalu yupukarra ngunaya jalangu manu jukurra, yampiyalu-jana marnpirninja-wangurlu.” Junga-juku, ngula-warnuju yapangku jintawarlayirlili jurnarrpa nyanungurra-nyangu parljurnu. Wurdujarra-jarrijalu parra-jarraku. ");
INSERT INTO wbp_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Parra-karirla, mungalyurru karrikarri-wangulpa maarrmaarr-manu, manulparla ngapaku maarr-maninjarla wangkanjinarni kamparrukamparru. Yapangkulu nyangu maru mangkurdurla wapirrija pirli wararraku. Manu nganangku mayilpa kurlumpurrngu-kurlurlu kilji-nyayirnirli juturnu. Yapa panujulpalu lani-jarrija-nyayirni! ");
INSERT INTO wbp_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mujujurlu-jana ngurra-ngurlu nguru-yirrarnu yapaku yungulurla turnu-jarrimi Kaatuku. Yarti-wanalpalu warru karrija kanunju pirli wararrarla yukanja-wangu-juku. ");
INSERT INTO wbp_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ngula-warnuju, YAAWIYI kankarlarra-jangka yanurnu kaninjarra-kari pirli wararra-kurra warlu wiringka. Yulyurdulparla wapirrija wararrakuju. Panu-jarlu yulyurdujulpa yanu yalkiri-kirra, manu pirli wararra yinyajulpa yurnkuyurnku-jarrija-nyayirni! ");
INSERT INTO wbp_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Yinya kurlumpurrngu kujalpa juturnu, ngulajulpa kilji-jarrinja-yanu. Mujujujulparla wangkaja Kaatuku, manulpa Kaaturlu yalu-manu nyanungu. Linpa nyanungu-nyanguju ngulaju yangka kuja karla ngapaku maarr-maninjarla wangkanjinarni kamparrukamparru, ngula-piya. ");
INSERT INTO wbp_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yuwayi, kankarlarra-jangka YAAWIYI yanurnu pirli wararra-kurra yinya-kurra kankarlarni-kirra, manurla kankarlarni-ngirli purlaja Mujujuku, manu rdirri-yungu Mujuju warrkarninjaku. ");
INSERT INTO wbp_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ngula-jangka, YAAWIYI wangkajarla Mujujuku, “Pina-yanta kaninjarra-kari, manu-jana warnkiri-manta kajikalu-nyanu marda kurdarrirdarrirli putaputa yirntirninja-yani ngajukupurdarlu nyanjakupurdarlu. Kajili kuja-jarrimi, kapulu muku palimi! ");
INSERT INTO wbp_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Warnkiri-manta-jana maralypikingarduyu-paturlangu. Kamparrurluju yungulu-nyanu jungarni-mani-wiyi yungujulu kutu-jarrimi ngajuku. Kajilpajulu kutu-jarriyarlarni jungarni-maninja-wangu, ngajulurlu YAAWIYI-rli kajikarna-jana murrumurru-mani karrikarri-wangu-nyayirnirli!” ");
INSERT INTO wbp_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ngula-jangka, Mujujurla wangkaja YAAWIYI-ki, “Ngulaju ngula-juku. Junga kujaju. Yapa kulalpalu warrkakarla nyampurla pirli wararrarla Jayinayirla. Nyurrunpa-nganpa wangkaja kujaju, ‘Yartili warru yirraka kanunju pirli wararra-wana yungu karri tarrukulku.’” ");
INSERT INTO wbp_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Pina-yaninjanta kaninjarra-kari pirli wararrarla, manu pina-kangkarni Yarunu nyampu-kurra. Kala warla-pajika-jana panu-kari maralypikingarduyu-patu manu yapa ngalya-kari warrkarninja-kujaku, kajikalu-nyanu marda putaputa yirntirninja-yani yarti-wanarlu. Kajilpajulu kutu-jarriyarlarni ngajuku nyanjaku, ngaju YAAWIYI-rli kapurna-jana murrumurru-mani karrikarri-wangu-nyayirnirli.” ");
INSERT INTO wbp_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Junga-juku, Mujujuju jitinjarla pina-yanu panu yapa-kurra, manu-jana nyiyarningkijarra muku yimi-ngarrurnu kujarla YAAWIYI wangkaja nyanunguku. ");
INSERT INTO wbp_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ngula-jangka, Kaatu-jana wangkaja yapaku, kuja-jana nyanunguju wangkaja: ");
INSERT INTO wbp_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ngajurna YAAWIYI Kaatu kuja kankujulu pura. Ngajurna-nyarra yajarninjarla kangurnu ngurrara Yijipi-jangkaju ngulalpalu-nyarra ngulangkarlu Yijipi-wardingki-paturlu jinyijinyi-manu warrki-jarrinjaku pirijina-piya. ");
INSERT INTO wbp_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ngaju-mipakulpankujulu parntarriyarla, manulpankujulurla pulka-pungkarla. Kulalu nyiyarlangu juju yirdi-manta ‘Kaatu’. Ngaju-mipaju Kaatu-pajika. ");
INSERT INTO wbp_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Nyurrurlarlu kankulu nyanyi panu nyiyarningkijarra yalkirirla manu walyangka manu ngapangka. Ngulaju ngula-juku. Kala kulalu-jana ngurrju-manta nyampurra-piya jamalya-jangka marda pirli-jangkarlangu, lawa. ");
INSERT INTO wbp_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Nyurrurlarlu marda kapunkulu-nyanu nyiyarningkijarra ngurrju-mani watiya manu pirli-jangka, ngula-jangka yungunkulu-jana marda parntarrinjarla pulka-pinyi. Kujajulu yampiya! Kajinkijili yampimi, manu panu-kari nyiyarningkijarra nyampurra-piya kajinkili-jana purami, ngula-jangkaju kapurna-nyarra kulu-jarrimi-nyayirni. Kajinkili warntarla nyinami, ngula-jangkaju kapurnajurla kurdukurdu nyurrurla-nyangulku kunka-mani, nyurrurla-nyangu kurdukurdu warringiyi-patu manu kurdukurdu nyanungurra-nyangurlangu. ");
INSERT INTO wbp_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kala yapa panu-kari kajijili yulkami, yapangku panungku kuja kajulu kuruwarri marlaja mardarni, kapurna-jana warrarda yulkami tarnnga-juku. Kularna-jana yampinjarla yani. ");
INSERT INTO wbp_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ngaju-nyangu yirdiji mukunypa. Kujarlaju, kulajulu yirdi ngajulu yirdi-manta manyungkajinta! Kajinkijili yirdi ngajulu yirdi-mani jarrwararlu manyuku, ngulaju kapurna-nyarra murrumurru-mani. ");
INSERT INTO wbp_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ngaju-nyangu Parra-nyayirni-wangu ngulaju tarruku. Manngu-nyangkajulu parra nyampurlaju, kulajulu wajawaja-manta! ");
INSERT INTO wbp_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Wiyiki-kari wiyiki-kari, kajilpankulu parra jika-palaku warrki-jarriyarla, ngulaju ngula-juku. ");
INSERT INTO wbp_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Kala Parra-nyayirni-wangu ngaju-nyangu ngulaju tarruku ngajuku. Parra nyampurla, yapajulpalu warrki-wangu nyinakarla, manulpajulurla pulka-pungkarla. Kuruwarri nyampuju jintawarlayiki nyurrurlaku manu kurdukurdu nyurrurla-nyanguku, nyurrurla-nyangu warrkiniki manu yapa-karirlanguku ngurrara-kari-wardingkiki ngula kalu nyinami nyurrurlarla. Panu-jukulpankulu warrki-wangu nyinayarla Parra-nyayirni-wangurla ngaju-nyangurlaju. ");
INSERT INTO wbp_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nyiya-jangkarlu karna-nyarra kuruwarri nyampuju yimi-ngarrirni? Nyurru-wiyi, ngajulurlu YAAWIYI-rli, nyiyarningkijarrarna-jana ngurrju-manu parra-patuku jika-palaku. Yalkirirna ngurrju-manu, walya manu ngaparna ngurrju-manu warrukirdikirdi nguru-kari nguru-karirla. Ngula-jangka, parra-karirla nyinajarna warrki-wangu. Ngula-jangkanyarna parra yinyaju ngurrju-pajurnu. Manurna ngurrju-manu parra tarruku yapaku. ");
INSERT INTO wbp_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Linpangku-palangu purda-nyangka kirda-nyanu manu ngati-nyanu wilji-wangurlu! Kajinkili-jana yimirirli purda-nyanyi, ngulaju kapunkulu tarnnga nyinami ngurrararla kajirna-nyarra yinyi ngaka. Ngajujurna YAAWIYI Kaatu kuja kankujulu pura. ");
INSERT INTO wbp_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Yampiyalu-nyanu tarnnga-kurra pakarninja-wangurlu! ");
INSERT INTO wbp_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Nyuntu kajilpanpa nyinayarla palka-kurlu yupukarra, kula kalykuru-jarriya yapa jinta-kari-kirli! ");
INSERT INTO wbp_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Kularla purungku jurnta manta nyiyarlangu yapa jinta-kariki! ");
INSERT INTO wbp_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Kula warlka wangkaya yapa jinta-kari-kirli kuwurturla! ");
INSERT INTO wbp_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Nyurrurla wati-patu, kaji wati-kari kutu nyinami nyurrurlarla yuwarli nyanungu-nyangurla, kula manngu-nyangka nyarrparlu yungunparla yuwarli nyanungu-nyangu jurnta kanyi. Manu kula manngu-nyangka yangka nyarrparlu yungunparla nyiyarningkijarra jurnta kanyi nyanunguku, yangka nyanungu-parntarlangu marda warrkini nyanungu-nyangurlangu marda pulukurlangu manu tangkiyi nyanungu-nyangurlangu. Jalajala-wangulu nyinaya nyampurrakuju! Yalumpurraju wati-kariki. Nyampurra kuruwarri yungulpankulu purayarla tarnngangku-juku!” ");
INSERT INTO wbp_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Yapa Yijirali-pinkijilpalu warru karrija-juku yinyarla pirli wararrarlaju kanunjuju. Purda-nyangulu linpa kuja karla ngapaku kamparrukamparru maarr-maninjarla wangkanjinarni, manulu purda-nyangu kurlumpurrngu yangka kujalpa kiljingki jitirninjinarnu jamirrkarlu. Manulu nyangu yurrpurlu yulyurdu kujalpa yulyurdu-pardija kankarlarra-kari pirli kankarlarni-jangka. Nyampurra kujalu nyangu, lani-jarrijalu manulu wurnturu-jarrinja-yanu pirli wararra-jangkaju, manulpalu wurnturulku karrija. ");
INSERT INTO wbp_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ngula-jangka, wangkajalurla Mujujuku, “Kajinpa-nganpa wangkami, kapurnangkulu purda-nyanyi. Kala kaji-nganpa Kaatu wangkami, ngulaju kapurnalu muku palimi.” ");
INSERT INTO wbp_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mujuju-jana wangkaja, “Kulalu lani-jarriya nyurrurlaju! Kaatu yanurnu nyampu-kurra yungu-nyarra waalparrirni kajinkili nyanungu-mipa-japa purami. Nyanungu kanyarra ngampurrpa nyinami yungunkulu nyanunguju warrarda manngu-nyanyi yirriyirrirli tarnngangku nyinanja-kujaku jarrwara-kujaku.” ");
INSERT INTO wbp_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kujalu yapangku nyampu purda-nyangu, karrija-jukulpalu wurnturu-juku pirli wararra-ngurlu yinya-ngurluju. Mujuju-mipa yanu kutuju mangkurdu munga-piya-kurra kujalpa nyinaja Kaatu.… ");
INSERT INTO wbp_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","26","... ");
INSERT INTO wbp_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","…YAAWIYI-rla wangkaja Mujujuku pirli wararra-ngurlu kankarlarni-ngirli, “Yaninjarla-jana maninjinta Yarunu, Natapa, Piyu manu yangka 70-pala wiriwiri Yijirali-pinki. Warrkakarnili pirli warrara nyampurla panu-juku, kala kulajulu kutu-jarriya ngajuku. Wurnturu-karrikarrijili karriya, ngulajulu parntarrinjarla pulka-pungka ngajuku. ");
INSERT INTO wbp_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mujuju, nyuntu-mipa kajikanpa kutuju ngaju-kurraju yanirni. Warla-pajika-jana panu-kari pirlingka warrkarninja-kujaku.” ");
INSERT INTO wbp_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ngula-jangka, Mujujurlu-jana yapa-patu yimi-ngarrurnunjunu kujarla nyiyarningkijarra YAAWIYI wangkaja. Nyanungurralurla wangkaja, “Ngurrju kujaju. Nyarrpa kujangku YAAWIYI wangkaja, kapurnalu purda-nyanyi.” ");
INSERT INTO wbp_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ngula-jangka, Mujujurlu puku-kurra yirrarnu nyiyarningkijarra kujarla YAAWIYI wangkaja. Mungalyurru rangkarrkurlu turnungka-jana yarturlu-patu wiri murnju-yirrarnu yurturlarla kutu pirlikiji. Ngula-jangka-jana 12-pala pirli lalypa kirrirdi-wati manu, ngula-jana jukajuka-yirrarnu kanardirla. Nyampurra 12-pala pirli-wati ngulaju 12-palaku turnu-warnu-patuku kujalpalu Yijirali-pinki nyinaja. ");
INSERT INTO wbp_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ngula-jana Mujujurlu yilyaja wati-patu kurdu-warnu-patu pulukuku pinjaku. Nyampurra puluku-watijili-jana purraja pirlingka yurturlurla YAAWIYI-ki pulka-pinjaku. Ngarili-jana ngalya-kari-mipa pangki parrirninjarla purraja kuyuju pirlingkaju YAAWIYI-kiji. Ngula-jangka, yapa-paturlulu ngarnu muku kuyuju turnungka jintangka. Manngu-nyangulpalu kujalpalu rarralypa nyinaja jintangka turnu-warnurla. ");
INSERT INTO wbp_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Kujalu-jana puluku pungu, Mujujurlu ngalya-kari yalyu maninjarla winjurnu parraja-patu-kurra, ngalya-kari yalyuju winjurnu pirli-kirra yarturlu-patu-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ngula-jangka, Mujujurlu manu puku yangka kuja kamparrurlu-wiyi yirrarnu YAAWIYI-kirlangu kuruwarri-kirli kuja-jana yapa-patuku wangkaja. Milki-jana riiti-manu kiljingki yungulu yapangku purda-nyanyi. Ngula-jangka, yapajulurla wangkaja, “Nyiyarningkijarra kuja wangkaja YAAWIYI nyampurla pukungka, kapurnalu purda-nyanyi.” ");
INSERT INTO wbp_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ngula-jangka, Mujujurlu manu-jana parraja-patu yalyu-kurlu, ngula-jana yalyu kujurnu yapa-patu-kurra. Wangkaja-jana, “YAAWIYI-rli-ngalpa ngarrurnu kapu-ngalpa tarnngangku-juku warrawarra-kanyi. Nyurrurlankulu wangkaja kapunkulu nganta tarnngangku-juku purda-nyanyi nyarrpa kuja-nyarra nyanungu nyiyarningkijarra wangkaja nyampurla pukungka. Kujarlanyarna-nyarra yalyuju kujurnu.” ");
INSERT INTO wbp_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ngula-jangka, Mujuju, Yarunu, Natapa, Piyu manu 70-pala wiriwirili warrkarnu pirli-kirra. ");
INSERT INTO wbp_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Yinyarlalu nyangu Kaatuju yangka kujalpalu Yijirali-pinkirli puraja. Wirliyarlalu nyanungurla kanunju nyangu yirdiyi-piya yukuriyukuri-piya. ");
INSERT INTO wbp_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Junga kujaju! Jungalu nyangu wiriwirirliji Kaatuju. Kala kula-jana pungu. Ngula-jangkalu ngarnu miyi manu ngapa. ");
INSERT INTO wbp_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","YAAWIYI-rla wangkaja Mujujuku, “Warrkakarni ngaju-kurra pirli-wana. Pardakaju ngajuku, kapurnangku yinyi pirli lalypa-jarra. Nyampu-jarra pirli-jarrarlarna yirrarnu kuruwarri manu yimi ngaju-nyangu yapaku pina-jarrinjaku.” ");
INSERT INTO wbp_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Ngula-jangka, Mujuju-jana wangkaja wiriwiriki, “Nyurrurlalu nyinaya nyampurla-juku purdangirli. Yarunu manu Yuuru kapu-pala nyina nyampurla-juku nyurrurla-kurlu. Kajili-nyanu yapa kulu-jarri nyiya-ngurlu, yungulu-jana nyanungu-jarraku wangkami. Jajuwa-mipa karna kanyi kurdungurlu ngaju-kurluju.” Junga-juku, Mujujurlu-nyanu manu Jajuwa, manu-pala yanu pirli wararra tarruku-kurra Jayinayi-kirra. Kuja-pala yinya-kurra-jarrija, Mujujurlu Jajuwaju purdangirli yampinja-yanu, ngula pirlingka nyanungu-mipa warrkarnu. ");
INSERT INTO wbp_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ngula Mujuju warrkarnu pirli-kirra, mangkurdurla wapirrija pirlikiji. ");
INSERT INTO wbp_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Junga, YAAWIYI-lpa palka nyinaja mangkurdurla yartarnarri wiri-kirli. Mangkurdurla wapirrija pirliki jika-pala parraku. Parra-karirla YAAWIYI-rla wangkaja Mujujuku mangkurdu-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Yijirali-pinkirlilpalu nyangu Kaatu-kurlangu yartarnarri wurnturu-ngurlurlu. Yartarnarri yinyaju warlu wiri-piyalpa jankaja kankarlarni pirli wiringka. ");
INSERT INTO wbp_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mangkurdurla wapirrija Mujujurlanguku. Nyanunguju nyinaja kankarlu 40-pala parraku manu 40-pala mungaku.… ");
INSERT INTO wbp_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","…YAAWIYI-rla wangkaja Mujujuku, ");
INSERT INTO wbp_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Wangkaya-jana Yijirali-pinkiki, ‘Purayalu jungangku kuruwarri ngaju-nyangu Parra-nyayirni-wangu-kurlu. Jalangu-jangka, Jarrirtiyi-kari Jarrirtiyi-kari yungunkujulu yapangku manngu-nyanyi ngajulu kuja karna-nyarra warrarda warrawarra-kanyi. Ngula-jangka, yungunkujulu milya-pinyi ngajuju YAAWIYI kuja karna-nyarra yapaju jungarni-mani. ");
INSERT INTO wbp_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","‘Jarrirtiyi kula parra-kari-piya, lawa. Jarrirtiyiji ngulaju ngajuku. Kaji ngana-puka warrki-jarri Jarrirtiyirla, ngulalu pungka yinyaju yapa! Kulalpa nyinakarla nyurrurla-kurlu. ");
INSERT INTO wbp_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Warrki-jarriyalu Palya-ngurlu Purayiti-kirra-mipa. Ngurrju kujaju. Kala Jarrirtiyi-kari Jarrirtiyi-kari, nyinayalu warrki-wangu. Jarrirtiyi ngulaju kaju ngajuku karri yungunkujulu manngu-nyanjarla pulka-pinyi. Kaji ngana-puka warrki-jarri Jarrirtiyirla, ngulalu pungka! ");
INSERT INTO wbp_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Jalangu-jangka yungunkulu manngu-nyanyi nyampu yimi kuja karna-nyarra yimi-ngarrirni Jarrirtiyi-kirli. Manngu-nyangka warrardalu ngaju-nyangu yimi wajawaja-maninja-wangurlu yungurna-nyarra milya-pinyi kuja kankujulu wala nyina-juku ngajuku. ");
INSERT INTO wbp_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kajinkili warrarda manngu-nyanyi ngaju-nyangu yimi Jarrirtiyi-kirli, ngula-jangka kapurna-nyarra warrawarra-kanyi warrarda. Yangka kujarna walya, yalkiri manu nyiyarningkijarra ngurrju-manu, ngurrju-manurna jika-pala parraku. Parra-karirla nyinajarna wurdungu-nyayirni warrki-wangu. Kujarlanya nyurrurlaju Jarrirtiyi-kari Jarrirtiyi-kari nyinayalu warrki-wangu.’” ");
INSERT INTO wbp_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ngula-jangka, YAAWIYI-rla wangkanjaku lawa-jarrija Mujujuku Jayinayirla. Yungurla pirli lalypa-jarra nyanungu-nyangu kuruwarri-kirli. Kaaturlu nyanungurlu yirrarnu nyampuju kuruwarri rdaka nyanungu-nyangu-kurlurlu. ");
INSERT INTO wbp_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mujujuju Pirli Wararrarla Jayinayirla-juku nyinaja yaninjarni-wangu-juku. Ngulalurla yapa-patuju yanurnulku Yarunuku, manu wangkajalurla, “Yuwa, nyarrpa-jarrimi-ka Mujujuju? Nyiya-jangka kula pina-yanurnu? Nyanungurlunya-nganpa kangurnu Yijipi-jangkaju. Marda palijalku. Yarunu, ngurrju-manta-nganpa juju watiya-jangka marda pirli-jangka marda kawurlu-jangka marda yungu-nganpa milki-yirrarni nyarrpara-wana yaninjaku.” ");
INSERT INTO wbp_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Yarunu-jana wangkaja, “Yuwayi, yungkajulu kawurlu langa-kurlangu kuja kalu nyurrurla-parntarlu mardarni, manu kaja-nyanurlu manu yurntal-nyanurlu.” ");
INSERT INTO wbp_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Junga-juku, yapa-paturlulurla kangurnu kawurlu langa-kurlangu, manu yungulurla Yarunuku. ");
INSERT INTO wbp_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Yarunurlu kawurlu yirrarnu kartaku-kurra. Yirrarnu kartakuju warlu-kurra purranjaku winjirninjakungarntirli kawurluku. Ngula winjurnu nyiya-kurra mayi puluku-piya-kurra. Ngula yurrparninjarla ngurrju-manulku puluku kawurlu-jangka. Ngula-jangka, Yarunu-jana wangkaja yapaku, “Nyampunya! Nyangkalu! Nyampurlunya-nyarra kangurnu Yijipi-ngirli!” ");
INSERT INTO wbp_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ngula-jangka, Yarunurlu pirli-wati-jana murnju-yirrarnu yurturlurla kamparru kawurlu pulukurla, wangkaja-jana yapa-patukuju, “Jukurra kapurlipa turnu-jarri nyampurla purlapa wiriki, kapurliparla yunparninjarla wirntimi YAAWIYI-ki!” ");
INSERT INTO wbp_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Parra-karirla yapajulu yakarra-pardija mungalyurru-nyayirni, ngulalu-jana puluku-patu manu. Ngalya-kari pulukulu-jana muku purraja linji-karda ngulangka pirlingka yarturlu-paturla YAAWIYI-ki nganta pulka-pinjaku. Ngalya-kari pulukulu-jana pangki parrirninjarla purraja yungulu ngarni Kaatuku yati-wangkanjaku. Yapangkulu ngarnu kuyuju yurturlu-kari yurturlu-karirla, pamarlangulpalu ngarnu. Ngula-jangkalpalu-nyanu kalykuru-jarrijalku pama-jangkaju. ");
INSERT INTO wbp_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Kuja-puru, YAAWIYI-rla wangkaja Mujujuku, “Jitinjarla yanta pina nyampu-ngurlu pirli wararra-ngurlu yapa-patu-kurra yangka kujanpa-jana kangurnu Yijipi-ngirli. Maju-manu-nyayirnili-nyanu. ");
INSERT INTO wbp_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Lawa, kula kalu purami kuruwarri ngaju-nyangu kujarna-jana wangkaja. Ngarili witaku-mipa puraja. Ngulalu karlirr-yanu ngaju-kujaku. Ngurrju-manulu-nyanu puluku kawurlu-jangka, parntarrijalurla. Ngulalu purrajalku nganta kuyu pulukuku pulka-pinjaku. Manu Yarunu-jana wangkaja, ‘Nyurrurla Yijirali-pinki, nyangkalu nyampu juju puluku kawurlu! Nyampurluju kuja-nyarra kangurnu Yijipi-jangka!’” ");
INSERT INTO wbp_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Milya-pinyi karna-jana nyampuju yapa-patu kuja kalu jurru marntarla nyina. ");
INSERT INTO wbp_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ngajujurna kulu-nyayirni, kapurna-jana muku pinyi. Kulaju warla-pajika! Kularna-jana nyuntu-parnta manu nyuntu-nyangu kurdukurdu pinyi, lawa. Nyuntu-nyangu-jangka kapulu yapa panu-jarlu palka-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mujujurlu warlkurnu YAAWIYI-ji, “Waraa, YAAWIYI! Kula-jana kulu-jarriya yapa-patuku! Nyampurraju yangka-patu-juku yapa-patu kujanpa-jana kangurnu Yijipi-jangka nyuntu-nyangu yartarnarri-kirlirli! ");
INSERT INTO wbp_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kajinpa-jana muku pinyi, kapulu Yijipi-wardingki-patuju kuja wangkami, ‘YAAWIYI-rli-jana kangu Yijipi-jangka Yijirali-pinki jilja-kurra. Kala ngari-jana yulyurlku-yirrarnu. Kangu-jana ngari yungu-jana muku pinyi pirli wararrarla.’ Kujanya kapulu wangkami. Kula-jana kulu-jarriya, kula-jana muku pungka! ");
INSERT INTO wbp_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Manngu-nyangka-jana Yipuruyamu, Yijaki manu Jakupu. Nyurru-wiyinpa-jana wangkaja, ‘Kapunkulu panu-nyayirni kurdukurdu mardarni, manu yaparla-nyanu. Kapulu nyina panu-nyayirni yanjilypiri kuja kalu nyina yalkirirla-piya. Kapurna-jana walya nyampu yinyi, kapu-jana nyanungurrakulku karrimi tarnnga.’ Kujarlunyanpa-jana jangku-pungu.” ");
INSERT INTO wbp_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ngula YAAWIYI-rli kuja-kurra purda-nyangu Mujuju, yunjumu-kari-jarrija manu purda-nyangu. Kula-jana yapaju muku pungu. ");
INSERT INTO wbp_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ngula-jangka, Mujujuju kanunju-yanu pirli wararra-ngurluju, kangu-palangu pirli lalypa-jarra. Yinyarlaju YAAWIYI-rli yirrarnu nyanungu-nyangu kuruwarri kamparru-purdanji manu purdangirli-purdanji. ");
INSERT INTO wbp_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kula-palangu Mujujurlu pirli-jarraju ngurrju-manu, lawa. Kaaturlu-palangu ngurrju-manu, ngula kuruwarri yirrarnu pirli-jarrarla. ");
INSERT INTO wbp_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ngulalpa Mujuju yanurnu pirli wararra-jangka, ngula nyangu Jajuwa kulkurru. Jajuwarlu-jana yapa-patu purda-nyangu purlanja-kurra, ngularla wangkaja Mujujuku, “Yuwa! Marda kalu-nyanu Yijirali-pinkirli kulungku pakarni!” ");
INSERT INTO wbp_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mujujurla wangkaja, “Lawa, kula kalu purlami kulu-jangka wina, manu kula karna-jana purda-nyanyi yulanja-kurra. Purda-nyanyi karna-jana yunparninja-kurra.” ");
INSERT INTO wbp_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ngula Mujuju kutu-jarrija ngurra-kurra, nyangu yangka puluku kawurlu-jangka. Ngula-jana yapa-patuju nyangu wirntinja-kurra. Kujarlunyalu kulu-manu-nyayirni. Ngula pirli-jarraju kujurnu walya-kurra, manu rdilyki-pungu-palangu pirli wararra-wana. ");
INSERT INTO wbp_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ngula-jangka manu yangka puluku kawurlu-jangka yangka kujalu-nyanu yapangku ngurrju-manu. Warlungka yirrarnu ngapa-piya-jarrinjaku. Ngula-jangka, winjurnu walya-kurra walyka-jarrinjaku. Ngula maninjarla puyu-pinjarla yurrparnulku walya-piya-karda. Ngula kawurlu yurrparninja-warnu walyaju ngapa-kurra kujurnu, ngula-jana Yijirali-pinki jinyijinyi-manu ngapa ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ngula-jangka, Mujujurla wangkaja Yarunuku, “Nyiya-jangkanpa-jana nyampuju yapa kangu warntarlarlu YAAWIYI-kijaku nyampu-kurlurlu puluku-kurlurlu? Kujaju maju! Kulangkulu nyuntu jinyijinyi-manu. Lawa-ngarrikarlanpa-jana yampinjaku!” ");
INSERT INTO wbp_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Yarunurla wangkaja Mujujuku, “Nyuntuju ngaju-nyangu paaju. Kulaju kulu-jarriya! Milya-pinyi kanpa-jana nyampurraju warrarda kalu manngu-nyanyi maju nyiyarningkijarra. ");
INSERT INTO wbp_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wangkajajulu, ‘Mujujurlu-ngalpa kangurnu Yijipi-jangkaju, kula karnalu milya-pinyi nyarrpara mayi nyanunguju. Ngula-ngalpa ngurrju-manta juju watiya-jangka marda pirli-jangka marda kawurlu-jangka yungu-ngalpa milki-yirrarni nyarrpara-wana yaninjaku.’ ");
INSERT INTO wbp_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ngularna-jana wangkaja yapa-patuku, ‘Yuwayi, yalyi-mantalu kawurlu langa-kurlangu, waninja-kurlangu manu rdaka-kurlangu, manu yungkajulu ngajuku.’ Ngulajulu yungu muku kawurluju. Ngularna kujurnulku warlu-kurra, ngula kawurlu pulukulku palka-jarrinjarla wilypi-pardija.” ");
INSERT INTO wbp_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mujujurlujulpa-jana nyangu yapa-patuju wirntinja-kurra manu purlanja-kurra warungka-wati-piya. Yarunurlu kula-jana yapa-patuju kuja-kurraju warla-pajurnu. Mujuju-nyanu wangkaja, “Waraa! Yapa panu-kari kuja kalu-ngalpa nyurunyuru-jarri, kapulu-ngalpa nyanjarla yinka ngarlarrimi ngalipakuju!” ");
INSERT INTO wbp_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ngula-jangka, Mujujuju yaninjarla karrijalpa kiirtirla yangka kamparru ngurrangka. Purlaja-jana yapa-patuku, “Yuwa! Ngana-puka kuja-ka ngampurrpa YAAWIYI-ki puranjaku nyina, karriyalu ngaju-wana!” Ngula Liipi-kirlangu yurturlu-jangka yaninjarla karrija Mujuju-wana. ");
INSERT INTO wbp_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ngula-jangka, Mujuju-jana wangkaja wati-patuku Liipi-kirlangu-patukuju, “YAAWIYI ngulaju Kaatu yangka kuja karlipa ngaliparlu Yijirali-pinkirli pulka-pinjarla purami. Nyampunya kanyarra wangka, ‘Nyurrurlarlu wati-paturlu mantalu-nyanu junma kirrirdi-wati. Ngula-kurlu warrulu wapaya ngurra-wana, manu pungkalu-jana nyurrurlakupurdangka manu wungu-warnu kuja kankulu-jana milya-pinyi.’” ");
INSERT INTO wbp_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Yinyarra yapa-patu Liipi-kirlangu-paturlulu purda-nyangu Mujujuju. Junma maninjarlalu-jana yapaju pungu, pungulu-jana 3,000-pala wati-patu. ");
INSERT INTO wbp_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ngula-jangka, Mujuju-jana wangkaja Liipi-kirlangu-watikiji, “Jalangu, nyurrurlarlunkulu-nyanu yungu YAAWIYI-kirra yungunkulurla warrki-jarrimi Kaluku Tarrukurla maralypikingarduyu-piya. Pungunkulu-jana nyurrurlakupurdangka manu kaja-nyanurlangu. Kuja-jangka YAAWIYI-ji kanyarra wardinyi nyina, kapunkulurla maralypikingarduyu nyina nyanunguku.” ");
INSERT INTO wbp_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Parra-karirla, Mujuju-jana wangkaja yapa-patuku, “Nyurrurlajunkulu majungka-jarrija-nyayirni. Jalanguju kapurna-nyarrarla wangkami YAAWIYI-ki. Kajirnarla wangkami, marda kapu-nyarra yawuru-jarrimi. Kaji-nyarra yawuru-jarrimi, kapunkulurla nyanungukulku pina-nyinami wungu-warnulku.” ");
INSERT INTO wbp_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ngula-jangka, Mujujurla yaninjarla wangkaja YAAWIYI-ki, “Nyampurra yapa-patulu majungka-jarrija-nyayirni. Ngurrju-manulu-nyanu juju puluku kawurlu-jangka yungulurla parntarrinjarla pulka-pinyi. ");
INSERT INTO wbp_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Kula-jana pungka wiyarrpa-wati, yawuru-jarriya-jana kulu-wangu. Marda kapunpa-jana pinyi-jiki. Kula-jana pungka, ngajuju pungka yungurna-jana palinjarla kunka-pardi. Ngariji mirrika ngaju-nyangu yirdi kujanpaju puku wiringka yirrarnu yapa panu-kurlu nyuntu-nyangu-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","YAAWIYI-rla wangkaja Mujujuku, “Ngana-puka kaji majungka-jarrinjarla warntarla yani ngaju-kujaku, kapurna mirrirni puku-jangkaju yirdiji. ");
INSERT INTO wbp_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Yanta pina-jana yapa-patuku, manu nguru-yirraka-jana ngurra-kurra kujarnangku kamparru-wiyi wangkaja. Ngaju-nyangu marramarrarlu kapungku milki-yirrarni nyarrpara-wana yaninjaku. Kapurnajurla kunka-mani yapaju kujalu majungka-jarrija.” ");
INSERT INTO wbp_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","YAAWIYI-rli-jana yapaju nyurnu-manu-nyayirni yangka kujalu Yarunu jinyijinyi-manu pulukuku ngurrju-maninjaku kawurlu-jangka.… ");
INSERT INTO wbp_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","…Mujujurlu kaluku wurnturu yirrarnu kujalpalu Yijirali-pinki nyinaja. Nyanungurlu yirdi-manu ‘Kaluku Tarruku’. Kujalu yapa ngampurrpa nyinaja YAAWIYI-ki payirninjaku, ngulaju kalalu ngurra yampinjarla wurnturu-yanu Kaluku Tarruku-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kuja kala Mujuju yanu Kaluku Tarruku-kurra, yapaju kalalu karrinja-pardija muku, karrija kalalu muku tuwa-wana kaluku nyanungurra-nyangurla. Ngula kalalu warrarda tarda-nyangu kuja yukajarra Kaluku Tarruku-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ngula Mujuju kala yukajarra Kaluku Tarruku-kurra, mangkurdu kala yanurnu kirrirdimpayi, ngula kala karrija kamparru tuwa-wana Kaluku-kurlangurla. Kujalpa mangkurdu karrija, YAAWIYI kalarla wangkaja Mujujuku. ");
INSERT INTO wbp_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Yapangku kalalu nyangu mangkurdu, karrija kalalpa kutu Kaluku Tarruku-wana. Ngula kalalpalu kaluku nyanungurra-nyangu-wana karrija, ngula kalalurla YAAWIYI-ki pulka-pungu. ");
INSERT INTO wbp_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kaninjarni Kaluku Tarrukurla, YAAWIYI kalarla wangkaja Mujujuku. Kalalpa-pala-nyanu nyangu kujalpa-pala-nyanu wangkaja yangka yapa kuja kalu-nyanu jarnkujarnku wangkami. Ngula-jangka, Mujujuju kala pina-yanu ngurra-kurra. Jajuwa kalalpa nyinaja-juku Kalukurla-juku yampinja-wangu. Jajuwaju Mujuju-kurlangu rdarrkanpa kurdungurlu. ");
INSERT INTO wbp_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ngula-jangka, Mujujurla wangkaja YAAWIYI-ki, “Wita yirnangku payirni. Nyuntulunpaju wangkaja yungurna-jana nyampu yapa-patuku nguru-yirrarni Yijipi-ngirli ngurra-kari-kirra. Nganalku kapunpa yilyami ngaju-kurraju yungu warrki-jarri ngaju-kurlu? Kulanpaju kuja wangkaja. Nyuntulunpaju ngaju wangkaja yangka kamparru-wiyi milya-pinyi nganta kanpaju ngula kanpaju wardinyi nyina. ");
INSERT INTO wbp_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kujaju ngurrju-nyayirni! Kajinpaju wardinyi ngajuku nyina, wangkayaju nyarrpa-jarri kapunpa. Ngula-jangka kapurnangku milya-pinyilki. Ngula-jangka yungurnangku miyalu wardinyi-mani warrarda. Kula-jana wajawaja-manta nyampu yapa-patu. Nyuntulurlunpa-nyanu milarnu.” ");
INSERT INTO wbp_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Ngaju kapurna yani nyuntu-kurluju. Kajinkili nyuntu manu Yijirali-pinki yani yapa-kariki kuluku, ngulakungarntiji kapurna-nyarra yartarnarri yinyi yungunkulu-jana ngula-kurlurluju muku pakarni manu walku-mani. Ngula-jangkaju yungunkulu rarralypalku nyina.” ");
INSERT INTO wbp_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ngula-jangka, Mujujurla wangkaja, “Kajinpa nyampurla-juku nyina yaninja-wangu, kula-nganpa yilyaya ngurra-kari-kirra. ");
INSERT INTO wbp_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kajinpa nyampurla-juku nyina yaninja-wangu, kajirnalu ngurra nyampu yampimi nyuntu-wangurlu, kulangku nganangku milya-pinyi nyuntuju kuja kanpa-nganpa wardinyi nyina. Nganimpaju nyuntu-nyangu yapa. Kajirnalu yani nyuntu-wangu, kapurnalu yapa panu-kari-piya nyina, kapurnalu rdaka-jarra marlajarra nyina nyanungurra-piya.” ");
INSERT INTO wbp_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Yuwayi, kapurna yani nyurrurla-kurlu. Milya-pinyi-nyayirni karnangku, ngajujurna wardinyi-nyayirni nyuntukuju.” ");
INSERT INTO wbp_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ngula-jangka, Mujujurla wangkaja YAAWIYI-ki, “Yungurnangku nyanyi miril-maninja-kurra nyuntu-nyangu yartarnarri-kirli.” ");
INSERT INTO wbp_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","YAAWIYI-rla wangkaja, “Yuwayi, kapurnangku milki-yirrarni ngajuju ngurrju, manu kapurnangku yirdi tarruku ngaju-nyangu milki-wangkami. Ngajurna yirdiji YAAWIYI. Nganaku-puka kuja karnarla ngampurrpa nyina, ngulakuju karnarla mari-jarrinjarla ngurrju nyinami. Yungurnaju milki-yirrarni nyuntu-kurra. ");
INSERT INTO wbp_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kapurnangku warla-pajirni yinngirri ngaju-nyangu nyanja-kujaku. Nganangku-puka kajiji yinngirri nyanyi, kapu palimi. ");
INSERT INTO wbp_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kutu ngajulurla, yarturlu wiri-ka karri rdingki-kirli. Yanta manu karriya yinya yarturlu-wana. ");
INSERT INTO wbp_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kapurna yarturlu-wana miril-maninja-yani. Kujakungarntiji kapurnangku yarturlu rdingkingka yirrarni. Kajirna jingijingi yanimpa, kapurnangku rdakangku wapirrimi. ");
INSERT INTO wbp_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ngula-jangka, kapurnangku rdakangku yampimi, kapunpaju purturlu nyanyi. Kulanpaju yinngirri nyanyi ngajuju.” ");
INSERT INTO wbp_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","YAAWIYI-rla wangkaja Mujujuku, “Jarntika-palangu jirrama-kari pirli lalypa-jarra yangka kujarnangku kamparrurlu-wiyi yungu, yangka-jarra kujanpa-palangu kijirninjarla rdilyki-pungu. Kapurna-jana ngaju-nyangu kuruwarri-kari kuruwarri-kari yirrarni yinyarla pirli-jarrarlaju. ");
INSERT INTO wbp_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Jukurrarlu mungalyurrurlu kangkarni-palangu pirli-jarra, yantarni ngaju-kurra pirli wararra Jayinayi-kirra, manu kapurnangku wangkami. ");
INSERT INTO wbp_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kula yapa jinta-kari kangkarni nyuntu-kurlu, lawa. Warla-pajika-jana yapa kajikalu yanirni kutu nyampu-kurra pirli wararra-kurra, manu-jana warla-pajika jiyipi, puluku marna ngarninja-kujaku kuja kalu pardimi kanunju pirlingka.” ");
INSERT INTO wbp_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Junga-juku, Mujujurlu pirli-jarra-palangu manu, jarnturnu-palangu lalypa-karda. Parra-karirla warrkarnu pirli wararra Jayinayirla pirli-jarra-kurlu. Kujanyarla YAAWIYI-ji wangkaja kamparru-wiyiji. ");
INSERT INTO wbp_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ngula-jangka, YAAWIYI yanurnu pirli wararra Jayinayi-kirra mangkurdurla, yaninjarla karrija Mujuju-wana, ngula-nyanu yirdi-manu ‘YAAWIYI’. ");
INSERT INTO wbp_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Wapaja kamparru Mujujurla, manurla wangkaja, “Ngajurna YAAWIYI Kaatu. Ngaju karna-jana warrarda mari-jarri yapakuju, manu karna-jana ngurrju nyina. Kajili warntarla nyina, kula karna-jana kapanku kulu-jarrimi, lawa. Yulkami-jiki karna-jana. Kuja karna-jana jangku-pinyi nyiyarningkijarra, kula karna-jana jurinyka-yirrarni. Warrarda karna-jana junga wangka. ");
INSERT INTO wbp_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Junga kujaju. Ngaju karna-jana ngurrju nyina yapa panukuju. Kuja kalu warntarla nyina, ngula-jangka kajili ngaju-kurra pina-yanirni, kula karna-jana yilyami, lawa. Yawuru-jarrimi karna-jana kulu-wangu. Kala kajili maju-juku warrarda nyina ngaju-kurra yaninjarni-wangu, kapurnaju kunka-mani-nyayirni. Kularnaju nyanungurra-mipa kunka-mani, kala nyanungurra-nyangu kurdukurdurlangu manu nyanungurra-nyangu kurdukurdu-yijala tarnngangku-juku.” ");
INSERT INTO wbp_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ngula-jangka, Mujujuju kapanku parntarrija walya-kurra, manurlajinta YAAWIYI-ki pulka-pungu. ");
INSERT INTO wbp_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Wangkajarla, “YAAWIYI, milya-pinyi-jala karna-jana nyampuju yapa panu-jarlu. Langa-pati jurru marntarla karnalu nyina. Milya-pinyi karna kuja karnalu maju warntarla nyinami. Kajinpaju wardinyi-jiki nyina ngajukuju, yantarni ngaju-kurlu kajirna nyarrpara-wanarlangu-puka yani. Rdakurl-kijika-nganpa yungurnalu nyuntu-nyangu yapa nyina.”… ");
INSERT INTO wbp_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","…Ngula Mujuju pina-yanurnu pirli wararra Jayinayi-ngirli, kanja-yanulpa-palangu pirli lalypa-jarra rdakangku. Nyanungu-nyangu yinngirri miril-manu kujalparla YAAWIYI-ki wangkaja pirli wararrarla. Kulalpa kuja milya-pungu. ");
INSERT INTO wbp_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Yarunurlu manu Yijirali-pinkirli yapangkulu nyangu Mujuju-kurlangu yinngirri miril-maninja-kurra. Lani-jarrijalpalurla. Kujakuju kulalurla kutu-jarrija. ");
INSERT INTO wbp_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ngula-jangka, Mujuju-jana purlaja, “Kulajulu lani-jarriya, yantarnili kutu!” Junga-juku, Yarunu manu panu-kari wiriwirilirla yanurnu, manu-jana wangkaja. ");
INSERT INTO wbp_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ngula-jangka, yapalurla kutu-jarrija Mujujuku, manu-jana yimi-ngarrurnu kuruwarri-kari kuruwarri-kari kujarla YAAWIYI-rli yimi-ngarrurnu pirli wararrarla Jayinayirla. ");
INSERT INTO wbp_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ngula-jangka, Mujujuju wangkanjaku lawa-jarrija yapa-patuku. Yinngirriki-nyanurla wapirrija wawarda wita-kurlu. ");
INSERT INTO wbp_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ngula-jangka, yangka kuja kala Mujuju yukaja Tarruku Kalukurla YAAWIYI-ki wangkanjaku, kala yalyi-manu wawarda witaju yinngirri-kijakuju. Ngula-jangka, kala pina-wilypi-pardija Kaluku-jangka, ngulaju kala-jana yapakuju yimi-ngarrurnu nyiyarningkijarra yangka YAAWIYI kuja kalarla wangkaja. ");
INSERT INTO wbp_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Yapangku kalalu nyangu yinngirri miril-maninja-kurra. Ngula kala-nyanu wapirrija wawarda-kurlu, kalarla pardarnu YAAWIYI-ki ngaka kajirla wangka Kaluku-kurra yukanjaku.… ");
INSERT INTO wbp_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","…Mujujurlu yirrarnu Kaluku Tarruku, manu yirrarnu nyiyarningkijarra kaninjarni kuja YAAWIYI-rli yimi-ngarrurnu kamparru-wiyi. YAAWIYI-kirla mangkurdu marlaja yanurnu yalkiri-jangka, ngularla Kalukuku wapirrija. Nyanungu-nyangu yartarnarri ngulaju kaninjarni Kaluku Tarruku. ");
INSERT INTO wbp_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Kujarlanya kula Mujujuju yukaja kaninjarniji. ");
INSERT INTO wbp_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","37","Kujalparla mangkurdu wapirrija Kalukuku, Yijirali-pinkiji kalalu ngurrangka-juku nyinaja. Kujalpa mangkurdu kankarlu-jarrija, Yijirali-pinkiji kalalu yanu nguru jinta-kari-kirra. ");
INSERT INTO wbp_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Junga kujaju. Parrangkaju, kalarla mangkurdu wapirrija Kaluku Tarrukukuju. Mungangka kala jarra-pardija warlu-piya mangkurduju. Manu yangka kuja kalalu Yijirali-pinki nguru-kari nguru-kari-kirra yanu, kalalu mangkurdu nyangu kamparru, manu kalalu puraja. ");
INSERT INTO wbp_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","54","... ");
INSERT INTO wbp_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","…YAAWIYI-rla wangkaja Mujujuku, ");
INSERT INTO wbp_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Nyampu-jana wangkaya Yarunuku manu nyanungu-nyangu kaja-nyanu-patuku, ‘Kajinkili-janarla YAAWIYI-ki wangka yapa-patuku, kujalu-jana wangkaya, ");
INSERT INTO wbp_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Payirni karnalu-nyarrarla YAAWIYI yungu-nyarra pirrjirdi-maninjarla warrawarra-kanyi. ");
INSERT INTO wbp_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Payirni karnalu-nyarrarla YAAWIYI yungu-nyarra ngurrju nyina manu yungu-nyarra yimiri nyina. ");
INSERT INTO wbp_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Payirni karnalu-nyarrarla YAAWIYI yungu wungu-warnu nyurrurla-nyangu tarnnga nyina, manu yungunkulurla nyiya-ngurlurlangu lani-wangu marlaja nyina rarralypa nyiyarningkijarra-ngurlu.” ’” ");
INSERT INTO wbp_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Kajijili ngaju Yarunurlu manu nyanungu-nyangu kaja-nyanu-paturlu payirni yangka Yijirali-pinkiki yapaku, kapurna-jana pirrjirdi-maninjarla warrawarra-kanyi.”… ");
INSERT INTO wbp_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","YAAWIYI-rla wangkaja Mujujuku, ");
INSERT INTO wbp_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Kapurna-nyarra walya Kanana yinyi nyurrurlaku Yijirali-pinkiki jalangu-karrikarrirli. Milaka-jana 12-pala wati-patu yungulu nyanjaku yani. Milaka-jana jinta-kari jinta-kari warlalja-patu-jangka turnu-warnu-jangka 12-pala-jangka.” ");
INSERT INTO wbp_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mujujurlu purda-nyangu YAAWIYI wangkanja-kurra. Milarnu-jana 12-pala wati-patu, manu yilyaja-jana Jilja-ngurlu Parana-ngurlu Kanana-kurra. ");
INSERT INTO wbp_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Nyampurranya wati-patuju kuja-jana Mujujurlu yilyaja: Ruupunu-kurlangu-jangkaju milarnu Jamuwa Jakurru-kurlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Jimiyani-kirlangu-jangkaju milarnu Japata, Yuuri-kirlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Juurda-kurlangu-jangkaju milarnu Kalapa, Jipuna-kurlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Yijaka-kurlangu-jangkaju milarnu Yikala, Jujupu-kurlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Yipirayimi-kirlangu-jangkaju milarnu Yuujiya, Nuunu-kurlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Pinyamini-kirlangu-jangkaju milarnu Palti, Raapu-kurlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Jupulunu-kurlangu-jangkaju milarnu Katiyulu, Jaardi-kirlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Manaja-kurlangu-jangkaju milarnu Kaardudu, Juuji-kirlangu kaja-nyanu. (Manajaju Jujupu-kurlangu kaja-nyanu.) ");
INSERT INTO wbp_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Taanu-kurlangu-jangkaju milarnu Yamilu, Kimali-kirlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Yaaja-kurlangu-jangkaju milarnu Jiijuru, Mayikulu-kurlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Napatali-kirlangu-jangkaju milarnu Naapi, Papiji-kirlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kaardu-kurlangu-jangkaju milarnu Kiwulu, Maki-kirlangu kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Nyampurranya yirdi-watiji wati-patu-kurlanguju yangka kuja-jana Mujujurlu milarninjarla yilyaja Kanana-kurra warru nyanjaku. (Mujujurlurla Yuujiyaku Nuunu-kurlangu kaja-nyanuku yirdi-kari yungu Jajuwa.) ");
INSERT INTO wbp_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","(Yinya-puruju marnikiji-piyalpa yirnmi-jarrinja-yanulku ngarninjaku.) Kanana-kurra yilyanjakungarntiji, Mujuju-jana wangkaja, “Yantalu yatijarra Kanana-kurra. Kajinkili yukamirra yinya-kurra, yantalu pirli-patu-kurra-pinangu. ");
INSERT INTO wbp_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Nyangkalu warru nyiyarningkijarra kuja-ka karri yinyarla. Nyiya-piya yinyaju walya? Nyajangu kalu yapaju nyina yinyarlaju? Pirrjirdi mayi, marda rampaku? ");
INSERT INTO wbp_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Marda yinyaju walya ngurrju marda, marda ngawu marda. Nyanjakulu yanta yungurlipa milya-pinyi. Marda kalu yapa nyina ngurrangka yarlungka, marda kirri-patu wiriwirirla kalu nyina pinji kirrirdi-kirli warrukirdikirdi kirringkaju kujalu ngurrju-manu pirli-jangka. ");
INSERT INTO wbp_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kala walya? Marda ngurrju marda miyi yungurlipa wiri-manilki, marda lawa. Nyiya-piya kalu watiya-watiji yinyarla karrimi? Kajinkili miyi palka-mani watiya-watirla, kangkarnili pina nyampu-kurra.” Kujanya-jana Mujujuju wangkaja yangkakuju 12-pala wati-patuku. Ngula-puruju nguru yinyarlaju, watiya panu-nyayirnilpalu karrija marnikiji-piya-kurlu yirnmi-kirli. ");
INSERT INTO wbp_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ngaka kujalu yukajarra Kananarla, yanulu jilja-jangka yirdi-jangkaju Jiini-jangka wurnturu yatijarra ngurra-kari-kirra yirdi-kirraju Riyupu-kurra. Nyampuju kutu Liipu-Yamajaku. ");
INSERT INTO wbp_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Junga. Kujalu yukajarra Kananarla, yanulu Yipurana-kurra-wiyi. Nyampuju Kananarla kurlirra-nginti ngurra kutu. Nyampurlanya kalalu yapa marnkurrpa nyinaja yirdiji Yayinama, Jijayi manu Talimayi nyurru-wiyi. Nyanungurra-nyangu warlaljalpalu nyinaja-juku Yipuranarla. Nyanungurra-nyangu nyurnunyurnu yirdiji Yanakiti. Yapa kirrirdimpayilpalu nyinaja. (Ngaka-pardu-kari, yapa-karirlili nganturnu kirri wiri Juunu Yijipirla. Wirlki-pala-jangka yulyurrpu-jangka yapa panu-karirlili nganturnu Yipurana.) Nyampuju kirri yangka-juku kujalu 12-pala wati-patu yanu. ");
INSERT INTO wbp_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ngula-jangka, yanurnulu ngurra-kari-kirra yirdi-kirraju Yijiku-kurra. Nyampuju wirri wiri kulkurru-jarra pirli wararra-jarraku. Palka-manulu wiriwiri-nyayirni yirnmi marnikiji-piyaju. Pajirninjarla wayurnulu watiya jukati-kirra. Jirramarlulpa-pala kanja-yanu marnikiji-piya wiri-jarlu-nyayirni jukatirla ngulalpa waraly-karrinja-yanu kujalpa-pala wati-jarrarlu kanja-yanu jukati-kirlirli. Manulu yarda manu miyi panu-karirlangu ");
INSERT INTO wbp_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Yinyarlanyalu 12-pala Yijirali-pinkirliji manu wiriwiri marnikiji-piya. Kujarlaju yapangkuju kalalu ngurra yinyaju yirdi-manu Yijuku ");
INSERT INTO wbp_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Wati yinya-patu 12-palalu wapaja warru Kananarla 40-pala parraku. Nyangulu nyiyarningkijarra, ngula-jangkajulu pina-yanu Mujuju-kurralku. ");
INSERT INTO wbp_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Mujuju manu Yarunu manu panu-kari yapalpalu-jana pardarnu Katijirla. Nyampuju jiljangka Paranarla. 12-pala wati-paturlulu-jana yimi-ngarrurnu nyanungurraku kujalu nyiyarningkijarra nyangu Kananarla. Manulu-jana milki-yirrarnu miyi-wati kujalu pinarni kangu yinya-kurra. ");
INSERT INTO wbp_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ngula-jangka, 10-pala wati-patujulurla wangkaja Mujujuku, “Yanurnalu Kanana-kurra kujanpa-nganpa wangkaja nyuntulu, manurnalu nyangu nyiyarningkijarra. Ngurra yinyaju ngurrju-nyayirni miyi panu-kurlu. Nyampunya panu-kari miyijirnalu kangurnu pina. ");
INSERT INTO wbp_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Yapa-patu kuja kalu nyina Kananarla kalu pirrjirdi-nyayirni nyina! Nyinami kalu ngurra-patu wiriwirirla kujalu ngurrju-manu pinji kirrirdi pirli-jangka warrukirdikirdi. Mardarni kalu-jana panu-nyayirni kurlarda-wati manu kurdiji-watirlangu. Manurnalu-jana yapa kirrirdimpayi nyangu yangka yirdiji Yanakiti. ");
INSERT INTO wbp_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Kurlarni-nginti Kananarlaju kalu nyina Yamili-patu. Pirlingkaju kalu nyina Yititi-patu, Jipuji-patu manu Yamuri-patu. Ngapa mangkuru-wana manu karru Jurdunu-wana kalu nyina Kanana-wardingki-patu. Kulalparlipa-jana nyarrparlu pungkarla, pirrjirdi kalu nyina ngalipa-piya-wangu!” ");
INSERT INTO wbp_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kala watingki jinta-karirli yirdingkiji Kalaparlu-jana ngarrurnu wurdungu-jarrinjaku, manurla wangkaja Mujujuku, “Kula-jana purda-nyangka! Yapa yinya-patuju pirrjirdi-nyayirni. Ngulaju ngula-juku! Ngalipaju pirrjirdi nyanungurra-piya-wangu! Ngarirlipa yukamirra kutu Kanana-kurra, manurlipa-jana walya jurnta kanyi!” ");
INSERT INTO wbp_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","10-pala wati-patu-karilirla wangkaja Mujujuku, “Junga-wangu kujaju! Nyanungurraju pirrjirdi-jiki ngalipakuju. Kulalparlipa-jana nyarrparlu pungkarla!” ");
INSERT INTO wbp_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ngula-jangkaju, yinya wati-paturlulpalu-jana yimi maju warru ngarrurnu panu-kari Yijirali-pinki lani-maninjaku, wangkajalu-jana, “Kananaju punku-nyayirni! Miyi-wangu kula-ka pardimi! Yapa kujarnalu-jana nyangu yinyarla, ngulaju kirrirdimpayi-wati! ");
INSERT INTO wbp_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nyangurnalu-jana yapa wiriwiri-nyayirnirlangu kinki-piya! Nyanungurra-nyangu nyurnunyurnuju ngularraju Yanakiti-wati kujalpalu nyinaja nyurru-wiyi. Kujarnalu-jana nyangu kirrirdimpayi-wati, wangkajarnalu-nyanu, ‘Waraa! Ngalipaju witawita-nyayirni jintilyka-wati-piya! Nyarrparlu kulalparlipa-jana pungkarla!’” ");
INSERT INTO wbp_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Yalirla munga jintangka, panu-juku Yijirali-pinkijilpalu yulaja kilji-nyayirni. Lani-jarrijalpalu-jana Kanana-wardingki-patuku. ");
INSERT INTO wbp_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Kujarlajulu-jana kulu-jarrija Mujujuku manu Yarunuku, wangkajalu-jana kuja-piya, “Nyinakarlarnalu Yijipirla-juku yungurnalu yalirla-juku paliyarla. Jiljangka mardarnalu nyinakarla yungurnalu paliyarla yalirla. ");
INSERT INTO wbp_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nyiya-jangka kangalpa YAAWIYI-rliji kanyi ngurra-kari-kirra? Kajirlipa yali-kirra yani kulukungarnti, yalirrarlu yapangku ngulaju kapulu-ngalpa muku pinyi junma kirrirdi-kirlirli. Kapulu-ngalpa jurnta kanyi ngalipa-parnta manu ngalipa-nyangu kurdukurdu. Lawa! Pinarlipa yani Yijipi-kirra jalanguju!” ");
INSERT INTO wbp_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Jarnkujarnku wangkajalu-nyanu, “Yampimirlipa Mujuju! Milarnirlipa wati-karilki yungu-ngalpa wiri nyina. Pina-yanirlipa Yijipi-kirra!” ");
INSERT INTO wbp_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ngula-jangkaju, Mujujuju manu Yarunu-pala parntarrinjunu walyangka kamparru Yijirali-pinkirla yungulu-jana yawuru-maninjarla pululu-mani. ");
INSERT INTO wbp_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yalirla-jukulpa-pala yali-jarra Jajuwa manu Kalapa karrija. Kujalu-jana ngalya-kari Yijirali-pinki kulu wangkanja-kurra purda-nyangu, miyalu-pala maju-jarrija, manu-pala muku pajurnu nyanungurra-nyangu jurnarrpa. ");
INSERT INTO wbp_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Wangkajalu-jana yapakuju, “Wayinkili! Yali walya Kanana ngulaju ngurrju-nyayirni. Yanurnalu, manurnalu warru nyangu nyiyarningkijarra. ");
INSERT INTO wbp_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kajirlipa jungarni nyina YAAWIYI-ki, kapu-ngalpa wardinyi nyina ngalipaku. Kapu-ngalpa walya yali-kirra kanyi. Manu kapu-ngalpa yinyi ngalipaku. Mangarri panu-nyayirni-ka karrimi yalirlaju. ");
INSERT INTO wbp_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Kulalu karlirr-yanta YAAWIYI-kijaku. Kulalu-jana lani-jarriya yapakuju kuja kalu yalirla nyina. Kajili-ngalpa kulungku pinyi, kapurlipa-jana muku pinyi. Nganangku kapu-jana wankaru-mani ngalipa-kujaku? Kula nganangku-puka! Kala YAAWIYI-ji-ka ngalipa-kurlu nyina, manu kapu-ngalpa muurl-mardarni nyanungurra-kujaku. Lani-wangulu nyinaya nyurrurlaju!” Kujanya-pala Jajuwa manu Kalapa wangkaja. ");
INSERT INTO wbp_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Panu-kari Yijirali-pinkiji, japirdija-jukulpalu-jana Mujujuku manu Yarunuku pirli-kirli. Kala ngula-jangkaju, YAAWIYI-ji palka-jarrija kankarlarni Maralypi Kalukurla. Panungkujukulu Yijirali-pinkirliji nyangu mangkurdu miril-karrinja-kurra yalirlaju. ");
INSERT INTO wbp_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","YAAWIYI-rla wangkaja Mujujuku, “Tarnnga-juku kapujulu yapa nyampurrarlu ngajuju juwa-kijirni. Kula kajulu purda-nyanyi nyampurrarlu kuja karna-jana wangkami. Ngajulurna-jana milki-yirrarnu ngurrju nyiyarningkijarra ngaju-nyangu-kurlurlu yartarnarri-kirlirli. Kala kula kajulu wala nyina. ");
INSERT INTO wbp_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Kapurna-jana muku nyurnu-mani jalangurlu yungulu muku palimi. Kapurna-jana muku riwarri-mani. Kala nyuntu Mujuju kapurnangku wankaru mardarni. Nyuntulurlu manu nyuntu-nyangu warlaljayirrirli kapunkulu-jana kurdukurdu panu mani. Manu kapulu pirrjirdi-nyayirni nyina nyampurra-piya-wangu.” ");
INSERT INTO wbp_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ngula-jangkaju, Mujujujurla wangkaja YAAWIYI-kiji, “YAAWIYI, nyuntu-nyangu yartarnarri-kirlirlinpa-jana nyampurraju yapa nguru-yirrarnurnu Yijipi-ngirli nyampu-kurra. Kajinpa-jana muku lawa-mani nyampurra yapa-patu, kapulu Yijipi-wardingki-paturlu purda-nyanyi yimi. ");
INSERT INTO wbp_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ngula-jangkaju, kapulu-jana yimi-ngarrirni Kanana-wardingki-patukulku kuja kalu yalirla ngurrangka nyina. Nyurru-wiyili purda-nyangu nyuntu-kurluju. Milya-pinyi kalu kuja karnalu nyuntu-nyangu nyina, manu kuja kanpa nyina nganimpa-kurlu tarnnga. Milya-pinyi kalu parrangka nyuntu kanpa-nganpa yani kamparru Yijirali-pinkirla ngulaju mangkurdu-piya yungunpa-nganpa kanyi ngurra-kari ngurra-kari-kirra. Manu kalu milya-pinyi kuja kanpa mungangka yaninja-yani kamparru nganimparla warlu kirrirdi-piya. Nyanyi karnangkulu kuja-piya kuja kanpa kamparru yani nganimparla. ");
INSERT INTO wbp_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Yuwa, yapa panungkulu purda-nyangu nyuntu-nyangu-kurlu yartarnarri-kirli ngurra-kari ngurra-kari-wardingkirli. Kala kajilpanpa-nganpa muku lawa-mantarla Yijirali-pinki, kajikalu yapa-kariji kuja marda wangka, ");
INSERT INTO wbp_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘YAAWIYI-rliji-jana ngarrurnu Yijirali-pinkiji nganta kangkarla Kanana-kurra. Pirrjirdi-wangu mardalpa nyinaja kujakuju. Kujarla marda-jana muku lawa-manu jiljangka.’ Kujanya marda kajikalu wangka. ");
INSERT INTO wbp_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“YAAWIYI, milki-yirraka-nganpa nyuntu-nyangu yartarnarri jalangurlu. Pina manngu-nyanyi mayi kanpa nyuntulurlu kujanpa-nganpa wangkaja nganimpaku nyurru-wiyi? Nyuntunpa-nganpa wangkaja nyampuju, ");
INSERT INTO wbp_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ngajurna YAAWIYI. Kajili yapa warntarla nyina, kula karna-jana kapanku kulu-jarrimi, lawa. Yulkami-jiki karna-jana. Kuja karna-jana jangku-pinyi nyiyarlangu, kula karna-jana jurinyki-yirrarni. Kapujulu wala warrarda nyina. Kuja kalu warntarla nyina, ngula-jangka kajili ngaju-kurra pina-yanirni, kula karna yilyami, lawa. Yawuru-jarrimi karna-jana pinja-wangu. Kala kajili maju-juku warrarda nyina ngaju-kurra yaninjarni-wangu, kapurna-jana muku pinyi. Kularna-jana nyanungurra-mipa pinyi. Kala nyanungurra-nyangu kurdukurdurlangu manu nyanungurra-nyangu kurdukurdu-yijala kapurna-jana muku pinyi.’ Kuja-nyanpa-nganpa wangkaja nganimpakuju. ");
INSERT INTO wbp_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kujaju junga! YAAWIYI, nyuntuju kanpa-nganpa yulkami-nyayirni nganimpakuju. Kujarnalu Yijipi-ngirli yanu, yali-ngirli kalanpa-nganpa yawuru-jarrija. Jalangu yalirra Yijirali-pinki ngulaju kalu maju-nyayirni nyina. Kulangkulu purda-nyangu nyuntuju. Kulu-wangurlu-jana yampiya! Ngayi-jana yawuru-jarriya kamparru-warnu-piyaku.” ");
INSERT INTO wbp_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ngula-jangkaju, YAAWIYI-jirla wangkaja Mujujuku, “Ngurrju kapurna-jana yawuru-jarrimi jalanguju kujanpaju ngajulu japurnu. ");
INSERT INTO wbp_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Milya-pinyi kanpaju kuja karna wankaru tarnnga-juku nyina. Manu nguru-kari nguru-karirlarlu kalu yapangku nyanyi yartarnarri ngaju-nyangu. Ngula-jangkanya karnangku wangka nyampuju nyuntuku jalangu: ");
INSERT INTO wbp_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Kulalu nyampurra Yijirali-pinki yukami Kanana-kurra, lawa. Nyangulu yali mangkurdu miril-karrinja-kurra. Marlaja nyangujulu yartarnarri kujarna-jana milki-yirrarnu Yijipirla manu jiljangka. Kulajulu purda-nyangu ngajuju. Warrardajulu miyalu jumati-manu kula jintaku, kala tarnngangku. ");
INSERT INTO wbp_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Kuja-jangkanya kula jintarlangu yukami Kananarla. Yaliji ngurra kujarna-jana jangku-pungu nyurrurla-nyanguku warlaljaku nyurnunyurnuku. Yalirra kujajulu ngajulu miyalu jumati-manu, kapulu muku palimi. Kulalu yukami Kananarla. ");
INSERT INTO wbp_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Kala wati jinta kapurna kanyi Kanana-kurra ngurrara-jinta yirdiji Kalapa. Nyanungurlu kalaju jungarni-jiki purda-nyangu ngaju-kurluju. Kula yalirra-piya-wangu Yijirali-pinki-kari-nyanu-piya, lawa. Purami kaju ngajuju jungarnirli-jiki kuja karnarla ngajulu wangka. Kujarlanya kapurna ngajulurluju kanyirni nyanunguju Kanana-kurra, yali-wana kuja warru yanu kamparru-wiyi. Yali walya ngulaju kapu-jana ngunami nyanungu-nyangu kurdukurdu-kurlangulku walya. ");
INSERT INTO wbp_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Yamili-patu manu Kanana-wardingki-patu kalu nyina wirri-patu-wana Kananarlaju. Nyurrurla pina-yantalu kurlirra manangkarra-kurra-pinangu Mangkuru Wiri-kirra yirdi-kirraju Marna Kirrirdi-kirra.” Kujarla wangkaja YAAWIYI-ji Mujujukuju. ");
INSERT INTO wbp_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","YAAWIYI-ji-palangu wangkaja Mujujuku manu Yarunuku, ");
INSERT INTO wbp_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Yalumpurra Yijirali-pinkiji kalu punku-nyayirni nyina. Kapujulu warrarda kula-jarrimi mayi ngajuku? Kula kajulu purda-nyanyi ngajuju kuja karna-jana wangka. Purda-nyanyi karna-jana kuja kalu kulu wangka. ");
INSERT INTO wbp_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Wangkaya-jana nyampu, ‘Kujanya kanyarra YAAWIYI-ji wangka: “Purda-nyangurna-nyarra nyurrurla kulu kuja kankulu wangka. Jungarnilki karna-nyarra wangka jalanguju: Kapurna-nyarra muku pinyi nyurrurlaju panu-juku. ");
INSERT INTO wbp_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Nyurrurlaju panu-juku kapunkulu muku palimi nyampurla jiljangka. Kaji ngana-puka 20-pala yulyurrpu nyina, marda 30-pala, marda 40-pala, marda 50-pala, yali yapa ngulaju kapu palimi. Yuwayi, nyurrurlaju kalankujulu kulu-juku wangkaja ngajukuju. Kuja-jangka kapunkulu muku palimi. ");
INSERT INTO wbp_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kulankulu jintarlangu yukami Kanana-kurra nyinanjaku yalirla walyangka kujarna-jana jangku-pungu nyurrurla-nyangu warlalja nyurnu-patuku. Kapu-pala jirrama-mipa yukami. Kalapa Jipuna-kurlangu kaja-nyanu manu Jajuwa Nuunu-kurlangu kaja-nyanu, yali-jarra-mipa kapu-pala yukami. ");
INSERT INTO wbp_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Purda-nyangulpankulu nganta kapulu kurdu nyurrurla-nyangu palimi. Kujaju kula junga. Kapurna-jana kanyi walya yali-kirraju. Kulalpankulu ngampurrpa nyinaja yaninjaku yali-kirraku. Kala kajili nyurrurla-nyangu kurdukurdu yukami, kapulu wardinyi-nyayirni nyina. ");
INSERT INTO wbp_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Kala nyurrurla kapunkulu nyampurla-juku palimi jiljangka. ");
INSERT INTO wbp_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","34","Kulankujulu jungangku puraja ngajuju. Ngampurrpa-wangunkulu nyinaja yungunkulu yani ngaju-kujaku. Kujankulu-jana yangka wati 12-pala yilyaja Kanana-kurra yungulu warru nyanyi nyiyarningkijarra, ngurra yalirlalpalu warru wapaja 40-palaku parraku. Kujarlanya kapurna-nyarra jinyijinyi-mani yungunkulu warru wapami jiljangka 40-palaku yukuriki. Kapunkulu muku palimi jinta-kari jinta-kari. Kapunkulu-nyanu murrumurru-nyayirni purda-nyanyi. 40-pala yukuriki nyurrurla-nyangu kurdukurdu ngulaju kapulu warru wapami nyampurla jiljangka. Kapulu-jana jiyipi warrawarra-kanyi. Kapurna-jana murrumurru-mani kuja-piya ngulaju 40-palaku yukuriki yirdijalpankulu nyurrurlaju majungka-jarrija. ");
INSERT INTO wbp_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ngajulu YAAWIYI-rna wangkaja nyampu yimi. Kari-nganta kapurna-nyarra murrumurru-mani 40-pala yukuriki. Nyurrurlajunkulu turnu-jarrija yungunkujulu ngajuku kulu-jarrimi. Ngula-jangkanya kapunkulu muku palimi nyampurla jiljangka.” ’” Kujanya-palangu YAAWIYI-ji wangkaja Mujujuku manu Yarunuku. ");
INSERT INTO wbp_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Yimi nyampuju junga. Yalirra 12-pala wati, kuja-jana Mujujurlu kamparru yilyaja walya-kurra Kanana-kurra, ngulajulu pina-yanurnu. Karlarla-pala-karirli ngulajulu-jana yimi-ngarrurnu kuja ngantalpalu yapa yalirla nyinaja pirrjirdi-nyayirni manu panu-nyayirni. Ngula-jangkanya, Yijirali-pinkili lani-jarrija-nyayirni, manulu kulungku ngarrurnu Mujuju. ");
INSERT INTO wbp_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Yuwayi, yalirrarlu karlarla-pala watingkili-jana panu-kari Yijirali-pinki ngarrurda-manu. Ngula-jangkanya-jana YAAWIYI-rliji nyurnu-nyayirni-manu. Ngula-jangkaju, yalumpurlajukulu parra jintangka-juku muku palija yali-patu karlarla-pala wati-patuju. ");
INSERT INTO wbp_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Kala wati-jarra-kari, ngulaju-palangu YAAWIYI-rli wankaru-juku mardarnu. Yirdi nyanungu-jarraju Jajuwa Nuunuku kaja-nyanu, manu Kalapa Jipunaku kaja-nyanu. ");
INSERT INTO wbp_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kuja-jana Mujujurlu yimi-ngarrurnu Yijirali-pinkiki panu-kariki kuja-palangu yangka YAAWIYI wangkaja nyanunguku manu Yarunuku, ngulajulu wajampa-jarrija-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mungalyurru-nyayirni, mukulu yakarra-pardija, manulu yaninja-yanu pirli-kirra-pinangu Kanana-kurra-pinangu. Wangkajalu-nyanu jarnkujarnku, “Ngalipajurlipa majungka-jarrija. Ngulaju ngula-juku. Jalanguju, yani karlipa kutu yangka-kurra kuja-ngalpa YAAWIYI wangkaja yaninjaku.” ");
INSERT INTO wbp_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Kala Mujujuju-jana wangkaja, “Wayinkili! Warungkanyankulu? YAAWIYI-ji-nyarra wangkaja pina-yaninjaku jilja-kurra. Kajinkili-jana jangkardu yani kulu Kanana-wardingkiki, kulankulu-jana palu-pinyi manu lawa-mani. ");
INSERT INTO wbp_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Yaninja-wangulu nyinaya! Kula-ka YAAWIYI-ji nyurrurla-kurlu nyina, lawa. Kajinkili-jana yaninjarla kulu-jarri Kanana-wardingkiki, kapulu-nyarra muku pinyi yalirrarlu kuja kalu-nyarra nyurunyuru-jarrimi. ");
INSERT INTO wbp_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Kujaju junga. Kapunkulu-jana nyanyi Yamili-patu manu Kanana-wardingki-patu yalirla ngurungka. Kapulu-nyarra pinyi, kapulu-nyarra pajirni junma kirrirdimpayi-kirlirli. Nyurrurlankulurla jurnta yanu YAAWIYI-kijaku. YAAWIYI-rli kula-nyarra purami kulukuju.” ");
INSERT INTO wbp_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Yijirali-pinkiji ngantalpalu wingki-nyayirni nyinaja, manulpalu-nyanu purda-nyangu nganta pirrjirdi-nyayirni nganta. Ngula-jangkaju, yarnkajarralu pirli-patu-kurra-pinangu Kanana-kurra. Mujujuju purdangirlilpa nyinaja ngurrangka Pakuju Tarruku-kurlu Yalirla Pakujurla ngulajulpa Kaatu-kurlangu kuruwarri ngunaja kaninjarni pirli lalypa-jarrarla jirramarla. ");
INSERT INTO wbp_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ngula-jangkaju, Yamili-patu manu Kanana-wardingki-patulu kaaku-nyayirnili jitijarni pirli-ngirli. Pakarnulu-jana Yijirali-pinki, manulu-jana wajirli-pungu wurnturu-nyayirni ngurra-kari kirri yirdi-kirra Yuuma-kurra.… ");
INSERT INTO wbp_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","…YAAWIYI-rla wangkaja Mujujuku, ");
INSERT INTO wbp_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Wangkaya-jana Yijirali-pinkiki kuja kalu 12-pala warlalja-paturla turnu-warnu-paturla nyina. Wangkaya-jana 12-palaku wiriwiriki yungungkulu watiya jukati-patu nyanungurra-nyangu maninjarla yinyi nyuntuku. Yirraka-jana wiriwiri-kirlangu yirdi jukati-paturla 12-palarla. ");
INSERT INTO wbp_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Liipi-kirlangu-jangka manta Yarunu-kurlangu jukati. Nyanunguju wiri yaliki turnu-warnuku. Yarunu-kurlangu yirdi yirraka yalirla jukatirla. Manta-jana yalirra 12-pala jukati yalirra-kurlu wiri 12-pala-kurlu yirdi-kirli. ");
INSERT INTO wbp_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Kangka-jana kaninjarni Maralypi-kirra Kaluku-kurra, manu-jana ngunanja-yirraka walyaku kamparru Pakuju Tarrukurla kuja-ka ngaju-nyangu kuruwarri kaninjarni nguna yali-jarrarla pirli lalypa-jarrarla. Yalirla kuja karna nyuntulurla jinta-jarri wangkanjakungarnti. ");
INSERT INTO wbp_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kajinpa-jana yalirra jukati 12-pala yirrarni yalirla, ngula-jangkaju kapurna wati jinta milarni. Nyanungu-nyangu jukatirla kapu parrka pardimi. Yali wati karna milarni. Kajirna nyanungu milarni, ngula-jangkaju kulangkulu Yijirali-pinki kulu wangkami nyuntukuju.” ");
INSERT INTO wbp_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Junga-juku, Mujuju-jana yaninjarla wangkaja wiriwiriki yali-jangkaku 12-pala warlalja turnu-warnu-jangkaku. Jinta-kari jinta-karirlilirla jukatiji yungu Mujujuku. Yarunurlangurlurla yungu nyanungu-nyangu jukati. ");
INSERT INTO wbp_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ngula-jangkaju, Mujujurlu-jana jukati-patu yirrarnu walyangka kamparru YAAWIYI-rla kaninjarni Maralypirla Kalukurla. ");
INSERT INTO wbp_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Jukurralku, Mujujuju pina-yanu kaninjarni Maralypi Kaluku-kurra. Nyangu Yarunu-kurlangu jukati kuja parrka-pardija panu-kari-piya-wangu! Junga kujaju. Yarunu-kurlangu jukatirla ngulaju parrka-kurlu manu jinjirla-kurlu manu miyaka-piya-kurlu ");
INSERT INTO wbp_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ngula-jangkaju, Mujujurlu-jana jukati panu-juku manu kaninjarni Maralypi Kalukurla yalirla kujalpa YAAWIYI nyinaja. Manu-jana pina-kangurnu Maralypi Kaluku-ngurlu. Milki-yirrarnu-jana yalirraku 12-palaku wiriwiriki, manulu nyangu. Ngula-jangkaju, jinta-kari jinta-karirlili-nyanu manu warlalja jukati. ");
INSERT INTO wbp_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ngula-jangkaju, YAAWIYI-jirla wangkaja Mujujuku, “Pina yirraka Yarunu-kurlangu jukati kaninjarni Maralypi Tarrukurla. Ngunanja-yirraka kamparru Pakuju Tarrukurla yungulu milya-pinyi kujarna milarnu Yarunu yungu nyuntu-kurlulku warrki-jarrimi. Yangka kuja kalu-nyarra panu-karirli Yijirali-pinkirli purda-nyanja-wangurlu juwa-kijirni, kujarlunya kajulu ngajurlangu juwa-kijirni. Kala jalangu kajijili ngurrju nyina kulu wangkanja-wangu, kulalu palimilki.” ");
INSERT INTO wbp_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Junga-juku, Mujujurluju manu Yarunu-kurlangu jukati, manu pina-yirrarnu Maralypi Kalukurla kujarla YAAWIYI wangkaja kamparru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ngula-jangkaju, yapajulurla wangkaja Mujujuku, “Waraa! Lawa kapurnalu muku palimi! Nyarrpa-jarrimirnalu? Nyarrpa-jarrimirnalu? ");
INSERT INTO wbp_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Kajilpa yapa kutu-jarriyarla Maralypi Kaluku-kurra kuja-ka YAAWIYI nyina, yali yapa kajika palimi. Kapurnalu muku palimi mayi?”… ");
INSERT INTO wbp_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ngaka-pardu-karilki, Yijirali-pinkili yukajarni ngurra jilja-kurra yirdi-kirraju Jiini-kirra. Yalirlalu ngurrangka yirdingka nyinaja Katijirla. ");
INSERT INTO wbp_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Kala ngapa-wangulpa yinyaju karrija yapakuju ngarninjaku. Junga-juku, yapajulu-jana jangkardu turnu-jarrija kulu Mujujuku manu Yarunuku. ");
INSERT INTO wbp_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Wangkajalu-jana, “Nganimpakupalangu manu purlkapurlka manu muturnamuturnalurla marlaja palija YAAWIYI-kiji. Yungurnalu paliyarla-jala yinya-piya-jala. ");
INSERT INTO wbp_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nyiyakupurdarlunkulu-nganpa kangurnu jilja-kurraju? Kapurnalu panu-juku palimi manu puluku, jiyipi manu narnukuturlangu. ");
INSERT INTO wbp_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nyiya-jangkankulu-nganpa nguru-yirrarnu Yijipi-ngirli nyampu-kurra ngurra-kurra? Punku nyampurlaju! Mangarri-wangu, ngurlu-wangu, lawa! Manu ngapa-wangu ngarninjaku!” ");
INSERT INTO wbp_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ngula-jangka, Mujujurlu manu Yarunurlulu-jana yampinja-yanu yapaju purdangirli. Yanu-pala Kaluku Tarruku-kurra, manu-pala kamparru karrija tuwangka. Mirdijirrpijirrpi jurru kaninjarra-pala parntarrija walyangka. Ngula-jangkaju, YAAWIYI-kijirla mangkurdu palka-jarrinjarla marlaja miril-karrija. ");
INSERT INTO wbp_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ngula-jangkaju, YAAWIYI-jirla wangkaja Mujujuku, ");
INSERT INTO wbp_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Nyuntu manu Yarunu, yaninjarlalu-jana yapa-patu turnu-manta! Mujuju, kangka-nyanu nyuntu-nyangu watiya jukati. Yanta yali-kirra pirli yarturlu-kurra, manurla wangkaya. Kajinparla wangkami, kapu ngapa wilypi-pardinjarla karlimi yalumpu-ngurluju. Yungka-jana ngapa yapaku, pulukuku, jiyipiki manu narnukutuku.” ");
INSERT INTO wbp_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Junga-juku manu-nyanu Mujujurluju jukati kujalpa yalirla walyangka ngunaja. ");
INSERT INTO wbp_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Nyanungu manu Yarunu-pala yanu, manulu-jana turnu-manu yapa panuju kamparru yarturlu wiringka. Ngula-jangkaju, Mujuju-jana wangkaja, “Purda-nyangkajulu nyurrurlarlu panungku yapangku! Kulu-jarri kankulu-nganpa ngajarraku ngapa-wangurla. Ngampurrpa kankulu nyina yungurlijarra ngapa mani nyampu-ngurlu yarturlu wiri-ngirli?” ");
INSERT INTO wbp_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ngula-jangkaju, jirramaku pakarnu Mujujurlu yarturlu jukati-kirlirli, manu ngapa panu-nyayirnilpa karlija. Yapa-paturlulu muku ngarnu, manu pulukurlu, jiyipirli manu narnukuturlangurlu. ");
INSERT INTO wbp_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Kala YAAWIYI-ji-palangu kulu-jarrija Mujujuku manu Yarunuku, manu-palangu wangkaja, “Kulanpaju-pala ngungkurr-nyinaja ngajuku. Ngajujurna tarruku, kala nyuntunpaju manyu-pungu milkarraku yapa panungka milparniwarrarni kujanpa yali yarturlu pakarnu. Yungunparla wangkayarla-mipa pakarninja-wangu. Yalumpu-jangkaju, kulanpa-jana nguru-kanyi yapaku yali-kirra walya-kurra Kanana-kurra. Kala kapurna-jana yinyi-jiki ngajulurluju.” ");
INSERT INTO wbp_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Yinyaju ngurra yirdi Miripa. Nyampurla ngurrangka, kulu-jarrijalurla YAAWIYI-kiji ngapa-ngurlu. Yalirla-juku-nyanu YAAWIYI-rli milki-yirrarnu yapa-kurra tarruku-nyayirni.… ");
INSERT INTO wbp_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","21","... ");
INSERT INTO wbp_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","…Yijirali-pinkilpalu ngampurrpa-wangu nyinaja jingijingi yaninjaku ngurra-kari-wana yirdi-wana Yitama-wana. Kujalu yanu pirli wararra-ngurlu Yuura-ngurlu, ngulajulu warru yanu yirdiyi-kari-wana kujalpa yali yirdiyi ngunajarra mangkuru wiri-kirra yirdi-kirraju Marna Kirrirdi-kirra. Kujalpalu yaninja-yanu, yapajulu-nyanu kulu-jarrija, manulpalu-nyanu ngarrurnu jarnkujarnku. ");
INSERT INTO wbp_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Kulu-jarrijalu-jana Kaatuku manu Mujujuku. Wangkajalurla Mujujuku, “Wayinpa! Nyiya-jangkarlunpa-nganpa kangurnu Yijipi-ngirli? Kapurnalu nyampurla-juku palimi jiljangka. Mangarri-wangu nyampurlaju. Manu ngapa-wangu. Nyampu mangarri-kari kankarlarra-jangka kuja-ngalpa yungu Kaaturlu ngalipaku ngarninjaku yukuri 40-palaku, kula karnalu ngampurrpalku nyina ngarninjaku. Kula ngurrju!” ");
INSERT INTO wbp_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Kuja-jana YAAWIYI-rli purda-nyangu kuja-kurra wangkanja-kurra, nyanungurluju yilyaja-jana panu-nyayirni warna kulu-parnta mawiya-kurlu yungulu-jana yarlkirni yapa. Yarlkurnulu-jana Yijirali-pinki, manulu panu-kariji palija. ");
INSERT INTO wbp_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Panu-karili yanurnu Mujuju-kurra, manulurla wangkaja, “Kujarnalu-nyarra kulu-jarrija nyuntuku manu YAAWIYI-ki, ngulaju maju. Nyiyaku mayirnalu-nyarra wangkaja kujaku? YAAWIYI-ki-nganparla wangkaya yungu-jana nyampurra warna-wati jurnta kanyi.” Yijardu-juku, Mujuju-janarla wangkaja YAAWIYI-kiji yapakuju. ");
INSERT INTO wbp_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","YAAWIYI-jirla wangkaja Mujujuku, “Ngurrju-manta warna yayini-piya-jangka manu rdiin-pungka watiya jukatirla kirrirdirla. Ngula-jangkaju, juka-yirraka kankarlarra-kari walyangka. Kaji warnangku yarlkirni yapa, kaji yalirli yapangku nyanyi warna yayirni-piya-jangka, kapu wankaru nyina, kula palimi.” ");
INSERT INTO wbp_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Junga-juku, Mujujurlu ngurrju-manu warna yayini-piya-jangka, manu rdiin-pungu jukati kirrirdimpayi-kirra. Ngula-jangka, kujalpa-jana warnangku yarlkurnu yapa, kujalpalu yalirra yapangku yaninjarla nyangu warna-piya, kulalu palija.… ");
INSERT INTO wbp_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","35","... ");
INSERT INTO wbp_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","…YAAWIYI-jirla wangkaja Mujujuku, “Yantarni nyampu-kurra pirli-patu-kurra, warrkaka kankarlarra nyampurla pirlingka yirdingka Yapiramarla. Nyangka nguru karlarra-purda Kanana-wana. Nyampuju walya ngulaju kapurna-nyarra yinyi Yijirali-pinkiki. ");
INSERT INTO wbp_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Nguru Kanana kapunpa nyanyi, ngula-jangka kapunpa palimilki papardi-puraji-piya Yarunu-piya. ");
INSERT INTO wbp_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Wangkajarnangkupala nyarrpa-jarrinjaku jiljangka Jiinirla. Lawa, kulanpajupala purda-nyangu ngajuju. Ngajuju tarruku. Kala yangka ngurrangka yirdingka Miriparla, ngayinpajupala manyu-pungu ngajuju milparniwarra yapangka yangka kujanpa pirli yarturlu pakarnu nyuntu-nyangu-kurlurlu watiya jukati-kirlirli.” Kujanyarla wangkaja YAAWIYI-ji Mujujukuju. (Yalirla kuja Mujuju pirli yarturlu pakarnu jukati-kirlirli, yinyaju Miriparla, yalirla ngurra yirdingka Katiji jiljangka Jiinirla.) ");
INSERT INTO wbp_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mujujurla wangkaja YAAWIYI-ki, ");
INSERT INTO wbp_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“YAAWIYI, nyuntu kanpa Kaatu nyina kujanpa nyiyarningkijarra ngurrju-manu wankaru. Milaka wati ngurrju yunguju warrki marlaja kanyi, ngula-jangkanya yungu-jana wiri nyinami nyampurraku Yijirali-pinkiki. ");
INSERT INTO wbp_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Nyuntu-nyangu nyampurraju, YAAWIYI. Kajili nyampurra yani kulukungarnti yapa-karikingarnti, yalirli watingki kajika-jana nguru-kanyi kulukungarnti, manu kajika-jana pina-kanyirni kulu-jangkaju. Kajilpalu lawa nyinakarla wati wiri-wangu, ngulaju kajikalu jiyipi-piya nyinami yangka kuja kalu jiyipikingarduyu-wangu nyina yungulpa-jana warru nguru-yirrakarla. Kujaju maju.” ");
INSERT INTO wbp_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","19","Junga-juku, YAAWIYI-jirla wangkaja Mujujukuju, “Yaninjarla manta Jajuwa. Ngaju-nyangu Pirlirrpa ngulaju yalirla watingka. Wangkayarla yungu kamparru karrimi maralypikingarduyurla Yalijararla yungulu yapa panungku nyanyi. Rdaka-nyanu yirraka nyanungu-nyangurla jurrungka. Wangkaya-jana Jajuwarlu kangku marlaja kanyi yaliji warrki. Wangkaya-jana nyanungulku kajana wiriji nyina. ");
INSERT INTO wbp_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Wangkaya-jana yungulpalu purda-nyangkarla wangkanja-kurra yangka kujangkulu nyuntu-wiyi purda-nyangu. Ngula-jangkaju, panungku-juku Yijirali-pinkirli kapulu purda-nyanjarla purami. ");
INSERT INTO wbp_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Jalangu-jangka kaji Jajuwa ngampurrpa nyina nyarrpa-jarrinjaku, yaninjarla yungulpa japikarla Yalijara maralypikingarduyu. Kaji nyiyarlanguku japirni, ngulaju Yalijararlu kapu-palangu miimii-nyanyi-wiyi pamarrpa wita-jarra kuja karlipa-jana yirdi-mani Yurimi manu Tumini. Yinya pamarrpa-jarra-ngurlu YAAWIYI-ji kapurla wangkami Yalijarakuju. Ngula-jangkaju, Yalijaraju kapu-jana wangkami Jajuwaku manu Yijirali-pinkiki nyarrpa-jarrinjaku.” ");
INSERT INTO wbp_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Junga-juku, Mujujurluju purda-nyangu YAAWIYI-ji. Wangkajarla Jajuwaku yungu karrimi kamparru Yalijararla kujalpalu Yijirali-pinkirli nyangu. ");
INSERT INTO wbp_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ngula-jangka, Mujujurlu-nyanu rdaka yirrarnu Jajuwa-kurlangurla jurrungka, manu-jana yapaku wangkaja, “Kaaturlu milarnu wati nyampuju yungu-nyarra wiri nyina nyurrurlaku.” Kujanyarla wangkaja YAAWIYI-ji Mujujuku yungurla Jajuwarlu marlaja kanyi yaliji warrki.… ");
INSERT INTO wbp_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Nyampunya yimiji kuja-jana Mujujuju wangkaja Yijirali-pinkiki. Nyinaja-jukulpalu jiljangka kakarrara Jurdunu karru-wana kujalpa yatijarra-ngurlu parnkaja kurlirra-purda. Nyinajalpalu karru Jurdunu-wana kulkurru-jarra pirlingka. Kutu-juku ngurra-patu-karirla yirdi-paturla Jumpungka, Paranarla, Tupilirla, Yajiruturla manu Tiijaparla. ");
INSERT INTO wbp_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Nyampukungarnti, yampinja-yanulu yali pirli wararra Jayinayi, manulu jingijingi yaninja-yanu pirli wararra-wana Yitama-wana. Yaninja-yanu-jukulpalu parraku 11-palaku, manulu yukajarra Katiji-Parniya-kurra.) ");
INSERT INTO wbp_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Nyurru-wiyi nyampukungarnti, Yijirali-pinkirlili yampinja-yanu Yijipiji, manulpalu warru wapaja ngurra-kari ngurra-kari 40-palaku yukuriki. Ngula-jangkaju, 11-pala kirntangi-jangka Mujuju-jana wangkaja, yimi-ngarrurnu-jana nyiyarningkijarra kujarla YAAWIYI wangkaja kamparru. ");
INSERT INTO wbp_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Kujalpalu warru wapaja ngurra-kari ngurra-kari, yali-puruju kulungkulu-jana pungu wiri-jarra kingi-jarra yirdi-jarraju Jiyunu manu Yuuku. Jiyunujulpa-jana wiri nyinaja Yamuri-wardingkiki yapaku. Yuukujulpa-jana wiri nyinaja yapaku kujalpalu nyinaja Pajanarla. Yuukuju kala nyinaja ngurra-jarra-karirla yirdi-jarrarla Yajararla manu Yitirirla. Kujalu-jana Yijirali-pinkirli-jana kulungku pungu Jiyunu manu Yuuku manu nyanungurra-nyangu warrmarla, mukulu-jana lawa-manu. ");
INSERT INTO wbp_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Ngula-jangka, kujalpalu Yijirali-pinki nyinaja Muwapurla kakarrara-purda Jurdunu karrungka, Mujujurlu-jana muku yimi-ngarrurnu nyiyarningkijarra kujarla YAAWIYI wangkaja, wangkaja-jana, ");
INSERT INTO wbp_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Ngalipa Yijirali-pinkirli karlipa purami YAAWIYI Kaatu. Wangkaja-ngalpa ngalipaku pirli wararra Jayinayirla. Wangkaja-ngalpa, ‘Nyurrurlajulpankulu nyinaja nyampurla pirlingka tarnnga-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Jurnarrpalu-nyanu wurdujarra-manta yaninjakungarnti. Yantalu pirli-kirra kuja kalu Yamuri-patu nyina. Yantalu warru ngurra-kari ngurra-kari, yantalu karru Jurdunu-wana pirli-kari-wana karlarra-wana. Yaninja-yantalu nguru-wana kurlirra-wana ngapa wiri-wana karlarra-kurra. Yantalu ngurra Kanana-kurra, manulu yanta ngurra-kari-kirra Lipinani-kirra. Yantajukulu yali-kirra jinta-kari-kirra karru wiri-nyayirni-kirra yirdi Yupirayiti-kirra. ");
INSERT INTO wbp_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Purda-nyangkajulu nyurrurlarlu! Ngajurna-nyarra yungu nyampuju walya. Yantalu yali-kirra nguru-kurra, manulu-nyanu manta nyurrurlaku. Nyurru-wiyi ngajurna-jana wangkaja Yipuruyamuku, Yijakiki manu Jakupuku. Ngajurna-jana jangku-pungu walya nyampuju ngakaju kapu-jana nyanungurraku nguna manu nyanungurra-nyangu kurdukurdurlanguku.’”… ");
INSERT INTO wbp_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","46","... ");
INSERT INTO wbp_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","…Mujuju-jana wangkaja Yijirali-pinkiki, “Kapurna-nyarra wangkami kuruwarri-kari kuruwarri-kari kujaju YAAWIYI-ji ngajuku-wiyi wangkaja kamparru. Purda-nyangkalu-jana manu purayalu-jana yungunkulu yukami ngurra-kurra Kanana-kurra. Ngulaju yungunkulu tarnnga-nyayirni nyina yalirla walyangka kuja-nyarra YAAWIYI-rli jangku-pungu nyurru-wiyi ngalipa-nyangu warlaljaku. YAAWIYI-ji ngulaju Kaatu jinta-juku kujalpalu nyanungurrarlu puraja. ");
INSERT INTO wbp_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Kulalu-nyanu nyurrurlarlu ngurrju-manta kuruwarri-kari. Kulalu-jana jintarlangu wajawaja-manta kuruwarri YAAWIYI-kirlanguju yangka kuja karna-nyarra wangka. Muurlpa-nyayirnirlili-jana puraya. Nyampurra kujaju YAAWIYI-rli yimi-ngarrurnu ngajukuju kamparrurlu-wiyi yungurna-nyarra ngarrirni. ");
INSERT INTO wbp_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Milya-pinyi kankulu yangka kuja YAAWIYI nyarrpa-jarrija pirli wararrarla Piiyururla. Milya-pinyi kankulu yangka kuja-jana muku pungu yalirra yapa kujalurla parntarrija mirdijirrpijirrpi kamparru yinya jujuku yirdiki Paalaku. ");
INSERT INTO wbp_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Kala nyurrurla kulankulurla parntarrinjunu kamparru Paalaku. Tarnngangku-jukulpankulu puraja YAAWIYI-ji, ngalipa-nyangu Kaatuju. Ngula-jangkanya kankulu wankaru-juku nyina jalanguju. ");
INSERT INTO wbp_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ngajulurlurna-nyarra nyurrurlaju pinarri-manu panu-juku kuruwarriji kujaju YAAWIYI-ji wangkaja ngajukuju. Nyanunguju ngaju-nyangu Kaatu. Ngaka kajinkili yukamirra Kanana-kurra, tarnngangkujukulu-jana puraya kuruwarri-kari kuruwarri-kari nyanungu-nyangu. Kapunkulu-jana jurnta kanyi yali walya yapa-kari-kijaku. ");
INSERT INTO wbp_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Yalirra yapa yinyarlu walyangkarlu kapulu-nyarra nyanyi nyurrurlaju, manu kapulu-nyanu jarnkujarnku wangka, ‘Nyampurrarlu kalu pura YAAWIYI-kirlangu kuruwarri jungarni-nyayirnirli. Pina-nyayirni kalu nyina.’ Kujanya kapulu wangkami. ");
INSERT INTO wbp_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Kuja kalu yapa nguru-kari nguru-karirla nyina, pirrjirdi-nyayirni marda kalu nyina ngalipa-piya-wangu. Ngulaju ngula-juku. YAAWIYI Kaatuju kangalpa kutu nyina ngalipaku, kula nyanungurra-nyangu-piya juju-kari juju-kari-piya. Kuja karlipa ngaliparlu japirni nyiyarlanguku, warrarda kangalpa yalu-mani. ");
INSERT INTO wbp_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Yapa-karirli marda kalu kuruwarri ngurrju mardarni. Kala kuruwarri kuja karna-nyarra ngajulurlu yimi-ngarrirni jalangurlu, ngulaju yalirraju ngurrju-nyayirni yalirra-kurlangu-piya-wangu. ");
INSERT INTO wbp_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Nyurrurla yirriyirri-jarriyalu! Manu yirriyirrirlili mardaka langangka yangka kujankulu nyurrurla-nyangurlu milpangku nyangu kamparru-wiyi. Manulu-jana nyurrurla-nyangu kurdukurduku manu kurdukurdu-kurlangu kurdukurduku yimi-ngarrika. ");
INSERT INTO wbp_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Purda-nyangkalu warrarda yangka-kurlu nyurru-warnu-kurlu yangka kujankulu panu-juku karrija kamparru ngalipa-nyangurla Kaaturla YAAWIYI-rla pirli wararrarla Jayinayirla. Nyampunya kujaju wangkaja ngajukuju, ‘Manta-jana yapa-patu yungujulu ngajulu purda-nyanyi wangkanja-kurra. Ngula-jangkaju yungulu milya-pinyi nyarrpa yungulu nyina pulya-nyayirni ngajuku tarnnga-juku nyampurla walyangka. Pina-mani yungulu-jana kuruwarri ngaju-nyanguku kurdukurduku nyanungurra-nyanguku.’” Kujanyaju YAAWIYI-ji wangkaja ngajukuju. ");
INSERT INTO wbp_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ngula-jangkaju, Mujuju-jana wangkaja yapakuju, “Yimi-ngarrikalu-jana nyurrurla-nyangu kurdukurduku yangka nyurru-wiyi kujalpankulu karrija pirli wararra-wana Jayinayi-wana. Ngula-puruju kujalpa warlu wiri jankaja kankarlarni pirlingka manu rdiliji kankarlarra yanu. Ngula-jangkarla mangkurdurluju pirlikiji wapirrija. ");
INSERT INTO wbp_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","YAAWIYI-ji-nyarra nyurrurlaku wangkaja warlu-ngurlu. Linpankulu purda-nyangu wangkanja-kurra, kulankulu nyanunguju nyangu, lawa. ");
INSERT INTO wbp_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","YAAWIYI-rliji-nyarra nyurrurlakuju yimi-ngarrurnu Karlarla-pala Kuruwarri-kirli yalirra-kurlu kuja nyanungurlu yirrarnu pirli lalypa-jarrarla. Wangkaja-nyarra yungunkulu nyampu kuruwarri pura jungarnirli. ");
INSERT INTO wbp_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","YAAWIYI-ji wangkaja ngajukuju yungurna-nyarra nyurrurla pinarri-mani nyanungu-nyangu kuruwarri manu jukurrpa. Ngakaju kajinkili yukamirra Kanana-kurra, manu kajinkili walya yali jurnta kanyi yapa-kari-kijaku kuja kalu yalirla nyina, tarnngangkujukulu puraya YAAWIYI-kirlangu kuruwarri.” ");
INSERT INTO wbp_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","16","Ngula-jangkaju, Mujuju-jana yapa-patukulku wangkaja, “Kuja-nyarra YAAWIYI wangkaja warlu wiri-ngirli, kulankulu nyangu. Kajinkili ngampurrpa nyina wankaru nyinanjaku manu ngurrju nyinanjaku, purda-nyangkajulu ngajulu jalangurlu! Kajikankulu marda majumaju ngurrju-mani. Kulalu ngurrju-manta nyiyarlangu juju watiya-jangka manu pirli-jangka marda wati-piya marda mardukuja-piya marda. Kulalu kuja-piya ngurrju-manta yungulpankulurla nganta nyurrurla parntarrinjingkarla kamparru nganta manu pulka-pungkarla nganta. ");
INSERT INTO wbp_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Kulalu nyiyarlangu ngurrju-manta jurlpu-piya marda kuyu-kari kuyu-kari-piya marda. ");
INSERT INTO wbp_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","Kulalu nyiyarlangu ngurrju-manta yumurru-wangu marda yangka kuja kalu kiripi-kanyi, manu nyiyarlangu ngurrju-manta yawu ngapa-ngawurrpa-piya yungunkulurla parntarrinjini nganta kamparru manu yungunkulurla pulka-pinyi nganta. ");
INSERT INTO wbp_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Kajinkili kankarlarra-kari nyanyi, kapunkulu nyanyi wanta, kirntangi manu yanjilypiri. Nyampurra-jana YAAWIYI-rli ngalipa-nyangu Kaaturlu yapa-kariki yirrarnu walya-kari-wardingkiki yungulu-jana parntarrinjini kamparru manu yungulu-jana pulka-pinyi. Kala nyurrurla ngulajulu-jana yampiya, kulalu-jana parntarriya manu pulka-pungka. ");
INSERT INTO wbp_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","YAAWIYI-rli-nyarra wankaru-manu Yijipi-wardingki-patu-kujaku kuja kalalu-nyarra murrumurru-manu-nyayirni. Kangu-nyarra yali-ngirli ngurrara-ngurlu yungunkulurla nyanungukulku nyina. Junga kujaju. Jalanguju nyanungu-nyangulku kankulu nyina. ");
INSERT INTO wbp_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“Kuja-nyarra YAAWIYI-rli kangurnu Yijipi-ngirli, ngula-jangkaju kulu-jarrijankulurla ngapa-ngurlu. Nyurrurlankujulu kuluku ngurrju-manu, manu ngula-jangkaju YAAWIYI-ji kulu-jarrija ngajukulku. Wangkajaju kularna jingijingi yani karru Jurdunu-wana murrarninginti-kari-kirra. Wangkajaju kularna yukamirra yali-kirra walya ngurrju-kurra Kanana-kurra, nguru yali kuja kapu-nyarra yinyi nyurrurlaku. ");
INSERT INTO wbp_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Kujaju junga. Kapurna ngajuju nyampurla-juku palimi, kularna yukami Kanana-kurra. Kularna jingijingi yani karru Jurdunu-wana murrarninginti-kari-kirra. Kala jalangu-nyayirni nyurrurlaju kapunkulu jingijingi yani karru Jurdunu-wana, kapunkulu yukamirra walya ngurrju-nyayirni-kirra, manu kapunkulu-jana jurnta kanyi yalirraku yapaku kuja kalu yalirla nyina. ");
INSERT INTO wbp_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Purda-nyangkajulu nyurrurlarlu! Kulalu wajawaja-manta nyampurra kuruwarri manu jukurrpa kuja-nyarra YAAWIYI-rli yungu nyurru-wiyirli, kuja-nyarra ngarrurnu kapu-nyarra nyurrurlaju muurl-mardarni. Kulalu nyiyarlangu ngurrju-manta watiya-jangka manu pirli-jangka yungulpankulu nganta parntarrinjingkarla manu pulka-pungkarla. YAAWIYI ngalipa-nyangu Kaatuju-nyarra wangkaja yungunkulu yampimi yalirra juju-wati. ");
INSERT INTO wbp_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Nyurrurlaju kapunkulurla nyina YAAWIYI Kaatu-mipaku yungunkulu nyanungu-mipa pura. Kajinkili-nyanu majumaju ngurrju-mani nyiyarlangu parntarrinjaku manu pulka-pinjaku, ngulaju kapu-nyarra kulu-jarrimi-nyayirni nyurrurlakuju. Nyanunguju warlu wiri-nyayirni-piya ngula-ka nyiyarningkijarra jankami.”… ");
INSERT INTO wbp_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","49","... ");
INSERT INTO wbp_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","…Mujuju-jana wangkaja yapaku, “Kuruwarri-ka karrimi kujaju YAAWIYI ngalipa-nyangu Kaatu wangkaja yungurna-nyarra pinarri-mani. Nyurrurlaju kankulu nyina yukanjakungarntilki yungunkulu yukami nguru-kurra Kanana-kurra. Kajinkili yukami, yirriyirri-nyayirnirlili-jana purda-nyanjarla puraya nyampurra kuruwarri. ");
INSERT INTO wbp_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Kajinkili yalumpurla ngurungka nyina, nyurrurla manu nyurrurla-nyangu kurdukurdu manu nyurrurla-nyangu kurdukurdu-kurlangu kurdukurdu, yungunkulu manngu-nyanyi YAAWIYI-kirli. Manu nyurrurlarlu yungunkulu-jana purda-nyanjarla pura kuruwarri-kari kuruwarri-kari ngulaju kajirna-nyarra yinyi nyurrurlaku. Kajinkili-jana purami muurlpa-nyayirnirli, ngula-jangkaju nyurrurlaju kapunkulu yalirla walyangka nyina tarnnga-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Nyurrurla Yijirali-pinkirli, purda-nyangkalu-jana nyampurra kuruwarri, manulu-jana puraya muurlpa-nyayirnirla. Kajinkili kuja-jarrimi, kapunkulu wardinyi-nyayirni nyina, manu kapunkulu kurduju panu-nyayirni mardarni. Kapunkulu tarnnga-nyayirni nyina yalumpurla ngurrju-nyayirnirla walyangka kuja-ka mangarri ngurrju pardimi. Nyampuju jinta-juku walyaju kuja-jana YAAWIYI-rli jangku-pungu ngalipa-nyanguku warlaljayirriki. Nyanunguju jinta-juku Kaatuju kujalpalu nyanungurrarlu puraja. ");
INSERT INTO wbp_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“Nyurrurla Yijirali-pinkirli, tarnngangkujukulu manngu-nyangka nyampuju: YAAWIYI-ji kangalpa jinta-juku Kaatuju nyina! Kapurlipa nyanungu-mipa pura! ");
INSERT INTO wbp_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Yulkayalurla YAAWIYI-ki ngalipa-nyangu Kaatukuju karrikarri-wangu-nyayirni! Kulalurla jurnta karlirr-nyinaya! Manulurla warrki-jarriya nyanungu-mipaku. ");
INSERT INTO wbp_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Tarnngangkujukulu-jana manngu-nyangka nyampurraju kuruwarri kuja karna-nyarra yimi-ngarrirni jalangurlu. ");
INSERT INTO wbp_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Pinarri-mantalu-jana nyurrurla-nyangu kurdukurdu. Kajinkili wapanja-yani yirdiyi-wana, kajinkili marda ngurrangka nyina, pinarri-mantalu-jana nyampurra kuruwarri nyurrurla-nyangu kurdukurduku. Kajinkili marda warrki-jangka nyinami, kajinkili marda warrki-jarrimi, tarnngangkujukulu-jana pinarri-manta kurdukurdukuju nyampurraju kuruwarri yungulu purda-nyanyi wajawaja-maninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Yirrakalu-jana nyampurra kuruwarri pipa wita-kurra, manulu-nyanu warika pipaju wakungka manu nyurrurla-nyangurla ngalyangka yiriwarra-piyarla. Kajinkili kuja ngurrju-mani, kulankulu-jana wajawaja-mani nyampurraju kuruwarri. ");
INSERT INTO wbp_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Yirrakalu-jana nyampurra kuruwarri ngurlju-jarra-wana tuwangka nyurrurla-nyangurla. Manulu-jana yirraka kiirtirla ngurrangka kuja kankulu yalirla nyina.” ");
INSERT INTO wbp_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Mujuju-jana wangkaja Yijirali-pinkiki, “Jalangu-nyayirni, ngalipa-nyangu Kaatu YAAWIYI-rli kapu-nyarra nyurrurla kanyi yali-kirra walya-kurra nyanungurlu kuja-jana jangku-pungu ngalipa-nyangu warlaljayirriki Yipuruyamuku, Yijakiki manu Jakupuku. Kapu-nyarra yali walya wiri yinyi nyurrurlaku. Yinyarlaju ngulaju yuwarli panu-nyayirni, kulankulu-jana nyurrurlarlu nganturnu, lawa. Yapa-karirlili-jana nganturnu. ");
INSERT INTO wbp_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Nyampurraju yuwarliji ngulaju nyiyarningkijarra-kurlu. Kulankulu nyurrurlarlu yalirra nyiyarningkijarra yirrarnu, lawa. Yalirlaju ngulaju mulju panu-nyayirni. Kala kulankulu nyurrurlarlu pangurnu, lawa. Yinyarlaju ngulaju-ka mangarri nyiyarningkijarra pardimi, kulankulu-jana nyurrurlarlu wiri-manu, lawa. Ngulaju junga. YAAWIYI-rliji kapu-nyarra kanyi yali-kirra walya-kurra. Parra-kari parra-karirli kapunkulu mangarriji ngarni kajinkili parlja-jarrimi-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Purda-nyangkajulu nyurrurlarluju! Ngaka kajinkili parlja-kurlu nyina mangarri-jangka ngarninja-warnu, kulalu wajawaja-manta YAAWIYI-ji. Nyanungurlu-nyarra nyurrurlaju nguru-yirrarnu Yijipi-ngirli. Yalirla kalalu-nyarra Yijipi-wardingkirli jinyijinyi-manu warrki-jarrinjaku pirijina-piya. ");
INSERT INTO wbp_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Tarnngangkujukulu manngu-nyangka yirriyirrirli nyanungu-kurlu. Pulka-pungkalurlajinta nyanungu-mipaku. Kajinparla jangku-pinyi nyiya marda yapa jinta-kariki, ngulaju kularla kuja wangkaya, ‘Junga karnangku nyampuju jangku-pinyi kuja kangalingki jujungku palkangku nyanyi.’ Lawa, yampiya ngulaju maju! Kajinparla jangku-pinyi nyiya marda yapa ngalya-kariki, ngulaju kujarla wangkaya, ‘Junga karnangku nyampuju jangku-pinyi kuja kangalingki YAAWIYI-rli palkangku nyanyi yungu-ngalingki ngungkurr-nyinamilki.’ Ngulaju ngurrju. ");
INSERT INTO wbp_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Yapa kuja kalu ngurra-kari ngurra-kari nyina warrukirdikirdi, ngulaju kalu parntarrinjini kamparru juju-kari juju-karirla, manu kalu-janarla pulka-pinyi. Kala nyurrurlarlu kulalu-jana kujangu-piya ngurrju-manta, yampiyalu-jana! ");
INSERT INTO wbp_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Nyurrurlaju ngulaju YAAWIYI-mipa-kurlangu. Nyanunguju nyampurla nyurrurla-kurlu. Kajinkili-jana parntarrinjini manu pulka-pinyi yalirra juju-kari juju-kariki, kapu-nyarra kulu-jarrimi-nyayirni. Kapu-nyarra jangkardu yanirni warlu-piya, manu kapu-nyarra muku riwarri-mani.”… ");
INSERT INTO wbp_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","25","... ");
INSERT INTO wbp_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","…Mujuju-jana wangkaja Yijirali-pinkiki, “YAAWIYI-rli ngalipa-nyangu Kaaturlu kapu-nyarra kanyi Kanana-kurra. Kapu-nyarra nyurrurlakulku nguna. Jalanguju ngulaju yapa panu kalu nyina yalirlaju: Yititi-patu, Kirrkaji-patu, Yamuri-patu, Kanana-wardingki-patu, Piriji-patu, Yiipiti-patu manu Jipuji-patu. Nyampurra yapa ngulaju kalu pirrjirdi nyina nyurrurla-piya-wangu. Kajinkili yukamirra Kanana-kurra, kapunkulu-jana yalirraju muku yilyami manu wajirli-pinyi yapa-patu ngurra yali-ngirli, kapunkulu-jana jurnta kanyi walya yali-patu-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","YAAWIYI-rli ngalipa-nyangu Kaaturlu kapu-jana rampaku-mani yungulu-nyarra jijami nyurrurlaku. Kajinkili-jana kulu-jarrimi nyanungurraku, mukulu-jana riwarri-manta-nyayirni. Kulalu-jana ngurrju-wangkaya yungulu-nyarra wurulypa nyina kulu-wangu nganta, lawa. Kajinkili-jana kulu-jarrimi, kulalu-jana mari-jarriya, mukulu-jana riwarri-manta! ");
INSERT INTO wbp_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Nyurrurlarlu wati-paturlu, kulalu-jana puntaka karntaju nyanungurraku yupukarrakungarntirli. Kulalu-jana yungka nyurrurla-nyangu yurntalu-nyanu yupukarraku. Warla-pajikalu-jana kaja-pirdi yungulu yupukarra-wangu nyina. ");
INSERT INTO wbp_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Kajilpalu-jana nyurrurla-nyangurlu kurdukurdurlu yupukarra-mantarla nyanungurra-nyangu kurdukurdu, yalirrarlu yapangku kapili-jana nyurrurla-nyangu kurdukurdu jurnta karlirra-kanyi YAAWIYI-kijaku. Nyurrurla-nyangurlu kurdukurdurlu ngulaju kapulu-janarla parntarrinjarla pulka-pinyi yalirraku juju-watiki kujalu-jana yapa-karirli ngurrju-manu pirli-jangka manu watiya-jangka. Kajinkili nyurrurla jurnta karlirr-nyina YAAWIYI-kijaku, ngula-jangkaju kapu-nyarra kulu-jarri-nyayirni. Manu kapu-nyarra muku riwarri-mani. ");
INSERT INTO wbp_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Kajinkili yukami yali-kirra walya-kurra Kanana-kurra, walya-kurralu-jana yirntika muku yalirra pirli kirrirdimpayi kujalu yalirrarlu yapangku jukajuka-yirrarnu jujuku pulka-pinjaku. Mukulu-jana pajirninjarla witawita-manta nyiyarlangu juju Yaajaa-kurlangu, yalumpurra kujalu-jana watiya-jangka ngurrju-manu Yaajaaku pulka-pinjaku. Kangkalu-jana muku nyampurra juju-wati yalirra-kurlangu yapa-kurlangu, manulu-jana muku purraya warlungka. ");
INSERT INTO wbp_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Nyurrurlaju YAAWIYI-kirlangu. Nyanunguju ngalipa-nyangu Kaatuju. Kula-nyanu milarnu yapa-kari nyanunguku. Nyurrurla-mipa-nyarra milarnu yungunkulurla nyanunguku nyina. ");
INSERT INTO wbp_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“Nyiya-jangkalpa-nyarra nyurrurlakuju wardinyi nyinaja YAAWIYI-ji? Nyiya-jangkarlu-nyarra nyurrurlaju milarnu nyanunguku? Kula kankulu panu Yijirali-pinki nyina, lawa. Yapa-kariji ngulaju kalu panu-juku nyina nyurrurla-piya-wangu. ");
INSERT INTO wbp_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Ngulaju ngula-juku. YAAWIYI-ji kanyarra yulkami nyurrurlakuju. Nyurru-wiyi, nyanungurlu-jana ngarrurnu ngalipa-nyangu warlaljayirriki ngulaju kapu-jana ngurra Kanana yinyi. Ngulaju junga. Nyanungu-nyangu-kurlurlu yartarnarri-kirlirli pirrjirdi-kirlirli nyanungurlu-nyarra nyurrurlaju yapaju kangurnu Yijipi-ngirli. Yalirla kalalu-nyarra Yijipi-wardingkirli jinyijinyi-manu warrki-jarrinjaku pirijina-piya. Kangu-nyarra nyurrurlaju Yijipi-wardingki Kingi Wiri-kijaku kujalpa-nyarra nyurrurla murrumurru-manu. ");
INSERT INTO wbp_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Manngu-nyangkalu nyampu-kurluju: YAAWIYI-ji ngalipa-nyangu Kaatu. Kula-ka ngana-puka nyina nyurrurlakuju puranjaku manu pulka-pinjaku. Ngarrurnu-nyarra kapu-nyarra yulkami tarnnga-juku. Kajinkilirla yulkami, manu kajinkili tarnngangku-juku purami nyanungu-nyangu kuruwarri, ngula-jangkaju kapu-nyarra tarnngangku warrawarra-kanyi. Kula-nyarra yampinja-yani. ");
INSERT INTO wbp_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Kala nyampurra yapa kuja kalurla nyurunyuru-jarrimi, ngulaju kapu-nyanurla kunka-mani, kapu-jana muku riwarri-mani.”… ");
INSERT INTO wbp_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","26","... ");
INSERT INTO wbp_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","…Mujuju-jana wangkaja Yijirali-pinkiki, “Jalangurlu ngajulurlu karna-nyarra yinyi panu-nyayirni kuruwarri. Purayalu-jana muurlparlu. Kajinkili-jana jungarnirli purami, ngula-jangkaju kapunkulu wankaru nyinami, manu kapunkulu-jana kurdu panu mardarni. Kapunkulu yukami ngurra Kanana-kurra, ngulaju kapu nyurrurla-nyangulku karrimi. Nyampuju jinta-juku walya kuja-jana YAAWIYI-rli jangku-pungu ngalipa-nyanguku warlaljayirriki nyurru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Nyurrurla, manngu-nyangkalu yangka kujalpa-nyarra YAAWIYI-rli nguru-yirrarnu jilja-wana 40-palaku yukuriki. Waalparrurnulpa-nyarra nyurrurlaju kajilpankulu marda purda-nyangkarla-japa kaji-nyarra nyiyarningkijarra jinyijinyi-mantarla. ");
INSERT INTO wbp_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Nyurrurlarluju kalankulu-nyanu pulka-pungu. Kalankulu mangarri-wangu nyinaja. Nyangu-nyarra yarnunjuku ngulaju-nyarra parlja-manu mangarri-kirlirli kankarlarra-jangkarlu. Kulankulu kujangu-piya mangarri nyangu nyurru-wiyi, manu ngalipa-nyangu warlaljayirrirli kulalu nyangu. Nyiya-jangka-nyarra mangarriji yungu? Kajinkili nyurrurlarlu panu mangarri mardakarla ngarninjaku, ngulaju-ngarrankulu kuja wangkayarla, ‘Panu karlipa mardarni mangarriji. Nyiyakulparlipa purda-nyangkarla YAAWIYI-ji?’ YAAWIYI-rliji-nyarra yungu yali mangarri yungunkulu manngu-nyanyi jungarnirli kuja-piya, ‘Kajirlipa ngampurrpa nyina wankaru nyinanjaku, ngulaju yungurlipa purda-nyanyi YAAWIYI-ji kuja kangalpa nyarrpa wangka ngalipakuju.’ ");
INSERT INTO wbp_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Kujalpankulu nyurrurla wapaja jilja-wana 40-palaku yukuriki, kula nyurrurla-nyangu jurnarrpa muku larra-yanu witawita-karda. Kula nyurrurla-nyangu wirliya lirrija wapanja-warnu. ");
INSERT INTO wbp_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Ngula-jangkanya, tarnngangkujukulu manngu-nyangka jungarnirli YAAWIYI-kirli. Nyanunguju ngalipa-nyangu Kaatu. Kaji-nyarra kurnta-ngarrirni nyurrurla, ngulaju kanyarra ngurrju-juku nyina nyurrurlakuju kirda-nyanu-piya kuja-ka yangka kaja-nyanu kurnta-ngarrirni yungu purda-nyanyi. Kuja kanyarra pakarni YAAWIYI-rliji, ngulaju kanyarra putaputa jungarni-mani nyurrurlaju yungunkulu purda-nyanjarla purami.”… ");
INSERT INTO wbp_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","20","... ");
INSERT INTO wbp_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","…Mujuju-jana wangkaja nyanungurraku, “YAAWIYI-rli ngalipa-nyangu Kaaturlu kapu-nyarra yinyi nyurrurlaku yapaku panu-nyayirni jinta-kari jinta-kari ngurra yungunkulu ngulangka nyina. Kajinkili yalirla nyina, kajinkili marda nyanyi wati, karnta marda kuja-ka majumaju ngurrju-mani, yalirli yapangku kula-ka yalirli YAAWIYI-kirlangu kuruwarri purami jungarnirli. ");
INSERT INTO wbp_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","Wati yinyarlu marda, karnta yinyarlu mardalpa-pala pulka-pinjakungarnti parntarrinjunu kamparru yinya-karirla kujalu juju ngurrju-manu pirli-jangka manu watiya-jangka. Mardalpa-palarla pulka-pungu yalirraku majumajuku. Mardalpa-palarla kamparru-wiyi parntarrinjunu wantaku, kirntangiki, yanjilypiriki marda. Ngarrurnurna-nyarra nyurrurlaju ‘Kuja-wangulu nyinaka!’. ");
INSERT INTO wbp_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","Kaji yapa yanirni, manu kaji-nyarra wangkami nyurrurlaku kuja yapa ngalya-kari nganta nyangu parntarrinja-kurra, ngulaju nyurrurlarlu yaninjarla nyangka junga-japa yimiji. Kajilpa yali yapa-kari parntarrinjintarla kamparru yalirrarla kuja-piyarla, kujaju maju-nyayirni nyampurlaju Yijiralirla. ");
INSERT INTO wbp_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","Kajinkili yapa jinta-kari nyanyi parntarrinja-kurra kamparru yinyarrarla, kangkalu yali wati marda karnta marda kirri-ngirli nyurrurla-nyangu-ngurlu. Ngula-jangkaju, nyurrurlarlujulu-jana manta pirli-wati, manulu luwaka yali majumaju. Tarnnga-kurralu luwaka yalirra-kurlurlu pirli-kirlirli. ");
INSERT INTO wbp_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Kajilpa yapa jintangku-mipa nyangkarla yali wati-kari marda karnta-kari parntarrinja-kurra, ngulajulu-jana yampiya pinja-wangurlu. Kala kajilpalu jirramarlu marda marnkurrparlu marda nyangkarla kuja-kurra, ngulajulu luwaka pirli-kirlirli yali yapa maju, manulu tarnnga-kurra pungka! ");
INSERT INTO wbp_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Yalirli yapangku kuja yapa ngalya-kari nyangu parntarrinja-kurra, ngulaju nyanja-warnurlu yungu nyanungurlu-wiyi kamparrurluju luwarni pirli-kirlirli yali majumaju yapa. Ngula-jangkaju, panu-karirlilkili luwaka yali yapa. Kujarlunya kapunkulu-jana nyurrurlarlu Yijirali-pinkirli muku riwarri-mani majumaju-wati nyurrurla-nyangu-ngurlu warlalja turnu-warnu-ngurlu.” ");
INSERT INTO wbp_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Mujuju-jana wangkaja, “Ngaka-karilki, yapangku marda kapu kulungku pinyi jinta-kari. Ngalya-karirliji kapulu-nyanu kulungku ngarrirni jarnkujarnku marda. Kapu marda yapa jintangku tarnnga-kurra yapa ngalya-kari pinyi. Ngula-jangkaju, nyurrurlarlu kajikankulu manngu-nyanyi kujarlu, ‘Nyarrpa-jarrimirlipa kulu-kujaku?’ Kuja kalu-nyanu kujangu-piya kulu-jarrimi manu kulu wangkami, nyurrurlarlulpankulu-jana kangkarla kuwurtu-kurra yangka kuja-nyarra YAAWIYI Kaaturlu yirrarnu nyurru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","Kangkalu-jana yinyarra kulu-pirinji maralypikingarduyu-patu-kurra yangka Liipi-patu-kurra. Panujukulu yanta yali-kirra wati jinta-kurra kuja-ka kuwurtukungarduyu nyina. Yaninjarlalu-jana japika yalirra maralypikingarduyu-patu manu yali kuwurtukungarduyu wiri yungunkulu-jana nyarrpa-jarrimi yalirraku kulinypa-patuku. ");
INSERT INTO wbp_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Kuja kalu-nyarra pina jangku-mani yungunkulu nyarrpa-jarrimi, ngulaju yirriyirrirlili-jana purda-nyangka. Kulalu-jana pina wangkaya kulu. ");
INSERT INTO wbp_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Kapulu-nyarra marda ngarrirni warla-pajirninjaku yalirra kulu wita-wangu-patu. Kapulu-nyarra marda ngarrirni yampinjaku. Kajili-nyarra wangkami nyurrurlaku, purda-nyangkalu-jana. ");
INSERT INTO wbp_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Yalirra maralypikingarduyu-patu manu yalirra kuwurtukungarduyu wiri, ngulaju kalurla warrki-jarrimi YAAWIYI-ki ngalipa-nyangu Kaatuku. Kujarlanya nyurrurlarlujulpankulu-jana linpangku purda-nyangkarla. Kaji-jana nganarlangu pina-wangkami kulu-karra yalirraku purda-nyanja-wangu, ngulajulu tarnnga-kurrarlu pungka yaliji yapa. Kujarlunya kapunkulu-jana nyurrurlarlu Yijirali-pinkirli muku riwarri-mani majumaju-watiji nyurrurla-nyangu-ngurlu warlalja turnu-warnu-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Kajinkili nyurrurlarlu pinyi yali yapa kujangu-piyarlu, yali yapa kujalpa-jana pina-wangkaja kulu-karra maralypikingarduyu-patuku purda-nyanja-wangu, ngulaju kapulu yapa ngalya-karirlilki purda-nyanyi kuja-kurluju. Ngulaju kapulu lani-jarrimi. Kulalu-jana pina-wangkami kulu-karra yalirraku maralypikingarduyu-patukulku.” ");
INSERT INTO wbp_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Mujuju-jana wangkaja, “Ngakarrangakarra nyurrurlaju kapunkulu yukamirra yali-kirra nguru-kurra Kanana-kurra. YAAWIYI-rli ngalipa-nyangurlu Kaaturlu kanyarra yinyi yaliji walyaju nyurrurlaku. Kapunkulu-jana jurnta kanyi yalirraku yapaku kuja kalu yalirla nyina jalangu, manu kapu-nyarra nyurrurla-nyangulku nguna. Yalirlanya kapunkulu nyurrurlaju nyina. Ngakalkuju kapunkulu-nyanu jarnkujarnku wangkamilki, ‘Yapaju kuja kalu nguru-kari nguru-karirla nyina, ngulaju kalu-jana wiriwiri mardarni yungulu-jana wiri nyina nyanungurraku. Waraa! Milarnirlipa-nyanu wati yungu-ngalpa wiri-yijala nyina kingi ngalipaku.’ ");
INSERT INTO wbp_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Ngulaju ngula-juku. Kala purda-nyangkajulu ngajulu jalangurlu! Kulalu-jana kutu-manta murnmangka yungu-nyarra wiri nyina, lawa. Pardakalurla YAAWIYI-ki. Milakalu yangka kuja kanyarra YAAWIYI wangkami. Kulalu milaka yapa-kari kuja-ka ngurrara-kari-wardingki nyina, lawa. Milakalu ngurrara-jinta yapa yungu-nyarra wiri kingi nyina. ");
INSERT INTO wbp_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Kajinkili nyurrurlarlu milarni yapa yungu-nyarra wiri nyina, ngulaju kulalu milaka wati nantuwu panu-jarlu-kurlu. Kajilpa-nyarra wiri nyinakarla, kulalpa-nyarra yilyayarla pina Yijipi-kirra yungunkulurla nantuwu panu-kari mani nyanunguku. Manngu-nyangkalu kuja-ngalpa YAAWIYI-rli yimi-ngarrurnu nyurru-wiyi. Wangkaja-ngalpa, ‘Kulalu pina-yanta Yijipi-kirra!’ ");
INSERT INTO wbp_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Kajinkili-nyanu nyurrurlarlu milarni kingi wiri, ngulaju yungu-jana marnkurrpa-mipa kali-nyanuju mardarni, kula panu. Kajilpa-jana panu kali-nyanu mardakarla, ngulaju kajikalu karlirr-kanyi Kaatu-kujaku. Manu yungu wita tala mardarni, kula panu. ");
INSERT INTO wbp_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Kaji yali wati wiri kingi-jarrimi, ngulaju yungu pantirni pipangka kuruwarri ngaju-nyangu ngulaju yungu-jana warrarda manngu-nyangkarla. Yuwayi, yungu yaninjarla kuruwarri mani maralypikingarduyu-ngurlu yali-ngirli Liipi-kirlangu-ngurlu turnu-warnu-ngurlu. Yungu-nyanu pipangka pantirni nyampurraju kuruwarri nyanunguku. ");
INSERT INTO wbp_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Ngula-jangkaju, yungu warru kanja-yani yali pipaju. Ngulaju yungu warrarda nyanyi yirriyirrirli parra-kari parra-kari. Ngulaju kapu milya-pinyilki YAAWIYI-kirliji, manu kapu milya-pinyi nyarrparlu yungu purami nyanungu-nyangu kuruwarri jungarnirli. ");
INSERT INTO wbp_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Kula-jana yampimi yalirra kuruwarri puranja-wangurlu. Manu kula-nyanu kuja wangkami, ‘Ngajujurna ngurrju-nyayirni. Ngajujurna ngurrju, kula yalirra-piya yapa ngalya-kari-piya.’ Kajirla yali wiri jungarni-jiki nyina YAAWIYI-ki, ngulaju nyanungu-nyangu kurdukurdu manu nyanungurra-nyangu kurdukurdu kapulu-jana wiriwiri panu-kariki nyina nyampurla Yijiralirla tarnnga-nyayirni.”… ");
INSERT INTO wbp_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","14","... ");
INSERT INTO wbp_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","…Mujuju-jana wangkaja Yijirali-pinkiki, “Kaaturluju yilyajarni ngajuju nyampu-kurraju yungurna-nyarra yimi-ngarrirni ngajulurluju jarukungarduyurlu-yijala. Ngakaju kapu YAAWIYI Kaaturlu yilyamirni jinta-kari jarukungarduyu-yijala ngaju-piya. Ngulaju kapu nyina yapa ngurrara-jinta nyurrurlakuju. Nyarrpa-puka kaji-nyarra wangka nyanungu, ngulajulu linpangku purda-nyangka wilji-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Nyampuju jurrku-juku yangka nyurru-wiyi nyurrurlarlu kujankulu YAAWIYI ngalipa-nyangu Kaatu japurnu. Nyurrurlajulpankulu nyinaja kutu pirli wararra Jayinayirla kujalpa warlu wiri jankaja kankarlarni. Nyurrurlajunkujulu wangkaja ngajuku, ‘Nganimpaju karnalu lani-jarrimi. Kula-nganpa jinyijinyi-manta yungurnalu YAAWIYI Kaatu-kurlangu linpa purda-nyanyi. Kula-nganpa jinyijinyi-manta yungurnalu nyanyi yali warlu wiri. Kajilparnalu purda-nyangkarla marda kajilparnalu yali warlu nyangkarla, kajikarnalu muku palimi.’ Kuja-nyankujulu wangkaja ngajulukuju. ");
INSERT INTO wbp_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Ngula-jangkaju, YAAWIYI-ji wangkaja ngajulukuju, ‘Ngulaju ngula-juku. Yimi yalirra kujangkulu kuja wangkaja yapa-patu, ngulaju ngurrju. ");
INSERT INTO wbp_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Ngula-jangkanya, ngakalku kapurna-jana yinyi jinta-karilki jarukungarduyu nyuntu-piya-juku. Kapu nyanungurra-piya-yijala nyinami ngurrara-jinta. Kapurnarla ngaju wangka yungu-jana wangkami nyanungurraku. Kapu-jana nyiyarningkijarra wangka kajirnarla wangka ngajulu. ");
INSERT INTO wbp_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Nyampuju jarukungarduyu kapuju marlaja wangkami. Kaji yapa ngana-puka purda-nyanja-wangu nyina yaliki jarukungarduyuku, ngulaju ngajululku kapurnarla jangkardu yanirni nyanungukuju kululku. ");
INSERT INTO wbp_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Jinta-kari jarukungarduyurlu marda kajika-jana marda yimi-karilki yimi-ngarrirni yapakuju, yimi ngaju kularnarla wangkaja. Kula marda-ka junga wangkami. Nyanungu nganta kaju marlaja wangkami ngajuluku. Yalirli jarukungarduyurlu kajika-jana yapakuju jukurrpa-kari yimi-ngarrirni yali kuja-ka juju-kari-kirlangu nguna, kula ngaju-nyangu. Kaji kuja-jarrimi, nyurrurlarlulu tarnnga-kurra pungka!’ ");
INSERT INTO wbp_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Kuja marda kankulu manngu-nyanyi, ‘Kuja kangalpa jarukungarduyu nganta wangka ngalipaku, nyarrparlurnalu milya-pinyi nyampuju yimi marda YAAWIYI-kirlangu-japa-ka wangka, juju-kari-kirlangu marda-ka wangka?’ ");
INSERT INTO wbp_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Yapa jarukungarduyu kajika-nyarra yaninjarla wangka kuja, ‘YAAWIYI-ji wangkaja ngajuku kapu-nyarra nyiyarlangu ngurrju marda maju marda rdipimi nyurrurlakuju.’ Kujanya kajika-nyarra wangkami. Ngula-jangkaju, ngakalku kaji-nyarra yangka ngurrju manu marda maju nyiyarlangu rdipimi, ngulaju ngula-juku. Kari-ngantarla YAAWIYI junga wangkaja yaliki jarukungarduyuku. Lawangkaju, kularla YAAWIYI-ji wangkaja, lawa. Ngari-nyarra warlkangku yimirr-yungu. Ngulaju jamulu wangkamirra! Purda-nyanja-wangurlulu yampiya!”… ");
INSERT INTO wbp_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","…Mujuju-jana wangkaja, “Kapurna-nyarra nyurrurlaku yimi-ngarrirni kuja kapu-nyarra nyarrpa-jarrimi YAAWIYI-ji. Kajinkili nyanungu-nyangu kuruwarri purami, ngulaju kapu-nyarra pirrjirdi-maninjarla warrawarra-kanyi, manu kapunkulurla marlaja panu-jarrimi. Kala kajinkili jamulu purda-nyanyi ngaju-nyangu kuruwarri puranja-wangurlu, ngulaju kapu-nyarra juyurdurlu-yunparni, manu kapu-nyarra murrumurru-mani. YAAWIYI-ji ngulaju ngalipa-nyangu Kaatu. Ngakaju kapu-nyarra muku yilyami wurnturu nyinanjaku nguru-kari nguru-kari. Kajinkili nguru-kari nguru-karirla nyina, nyurrurlarluju kapunkulu manngu-nyanyi nyanungu-nyangu yimi nyampu kuja karna-nyarra wangka jalangu. ");
INSERT INTO wbp_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","Ngula-jangkaju, nyurrurla manu nyurrurla-nyangu kurdukurdu kapunkulu pina-yanirni YAAWIYI-kirra, manu kapunkulu pina-manngu-nyanyi nyiyarningkijarra kuja karna-nyarra wangkami nyurrurlaku jalanguju. Kapunkulu nyurrurlarlu nyanungu-nyangu kuruwarri pura jungarnirli. ");
INSERT INTO wbp_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","Kapu-nyarra mari-jarrimi nyurrurlakuju. Kapu-nyarra pina-kanyirni nyampu-kurra nguru-kurra nguru-kari nguru-kari-jangka. Kapu-nyarra wardinyi-mani-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Nyampuju junga! Kajika-nyarra marda YAAWIYI-rliji nyurrurlaju yilyami nguru-kari nguru-kari wurnturu-nyayirni. Ngulaju ngula-juku. YAAWIYI-ji ngalipa-nyangu Kaatu. Ngakarrangakarra kapu-nyarra muku turnu-mani, kapu-nyarra pina-kanyirni nyampu-kurra nguru-kurra. ");
INSERT INTO wbp_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Kapu-nyarra nyurrurlaju yangka-kurra-juku jurrku-kurra walya-kurra pina-kanyirni kujalpa-jana nyurrurla-nyangu nyurnunyurnuku ngunaja. Yali walya ngulaju nyurrurla-nyangulku. Ngula-jangkaju, kapu-nyarra nyurrurlaju YAAWIYI-rliji muurl-mardarni. Kuja-jangkaju kapunkulu panu-jarrimi. Panu-jarrimi-nyayirni kapunkulu, kula wita ngalipa-nyangu nyurnunyurnu-piya. Kapu-nyarra nyanungurlu yinyi nyiyarningkijarra, manu kapu-nyarra wardinyi-mani-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","YAAWIYI-ji ngalipa-nyangu Kaatu. Kapu-nyarra nyanungurlu jungarni-mani nyurrurla manu nyurrurla-nyangu kurdukurdu yungunkulurla yulkami nyanunguku. Kapunkulu nyanungu-mipa manngu-nyanyi. Kapunkulu nyina tarnnga nyampurla walyangka. ");
INSERT INTO wbp_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Yapa panu-kari kuja kalalu-nyarra nyurunyuru-jarrinjarla kulungku pungu, YAAWIYI-rli kapu-jana juyurdurlu-yunparni murrumurru-maninjaku. ");
INSERT INTO wbp_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Ngula-jangka, kapunkulu YAAWIYI purda-nyanyi. Nyiyarlangu-puka kuja-nyarra yimi-ngarrirni jalangurlu, ngulaju kapunkulu jungangku purami. ");
INSERT INTO wbp_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","YAAWIYI-ji ngalipa-nyangu Kaatu. Kapu-nyarra tarnngangku-juku warrawarra-kanyi. Kuja-jangkaju kapunkulu-jana panu-jarlu kurdu mardarni. Nyurrurla-nyangurlu pulukurlu kapulu-jana panu witawita mardarni. Mangarri panu kapu pardimi nyurrurla-nyangurla walyangka. Kapu-nyarra nyanunguju wardinyi-jarrimi-nyayirni kuja-jana ngalipa-nyanguku nyurnunyurnuku wardinyi-jarrija nyurru-wiyi. ");
INSERT INTO wbp_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Kujakungarntiji, jungangkulu YAAWIYI purda-nyangka nyarrpa kaji-nyarra wangkami. Jungarnirlili puraya nyiyarningkijarra kujarna pukungka yirrarnu. Jungarnirlili YAAWIYI puraya tarnngangku-juku. Nyanunguju ngalipa-nyangu Kaatu.” ");
INSERT INTO wbp_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","13","Ngula-jangka, Mujuju-jana wangkaja, “Nyurrurlarlu marda kankulu kuja manngu-nyanyi, ‘Panu-nyayirni nyampurraju kuruwarri-kari kuruwarri-kariji puranjaku. Nyarrparlurlipa-jana purami jungangku? Ngana kapu yani kankarlarra nguru-nyayirni-wangu-kurra nyampurraku kuruwarriki yungu-ngalpa pina-yaninjarla yimi-ngarrirni nganimpaku? Ngana kapu yani wurnturu mangkuru wiri-wana yinyaku kuruwarriki yungu-ngalpa pina-yaninjarla yimi-ngarrirni? Kajilpa ngana mayi yantarla maninjaku, ngula-jangka kajikarlipa-jana purda-nyanyi manu purami jungarnirli.’ Purda-nyangkajulu nyurrurlarlu! Kajikankulu-jana yimirlirli purda-nyanjarla purami nyampurra kuruwarriji kuja karna-nyarra yinyi jalangurlu. ");
INSERT INTO wbp_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","YAAWIYI-kirlangu yimiji ngulaju nyampurla walyangka. Nyurrurlarlu kankulu milya-pinyi, manu kajikankulu wangkami yinya-kurlu yimi-kirli. Purayalu jungarnirli jalangurlu-juku. ");
INSERT INTO wbp_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Purda-nyangkalkujulu! Nyarrpa-jarrimi kapunkulu nyurrurlaju? Kapunkulu mayi nyiyarlangu ngurrju purami, marda punku? Kajinkili ngurrju purami, ngulaju kankulu Kaatu-kurlu tarnnga nyina nyampurla walyangka. Kajinkili punku purami, ngulaju kankulu palimi Kaatu-wangu. Nyarrpa-jarrimi kapunkulu? ");
INSERT INTO wbp_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Nyurrurla kankulu yanirni nyampu-kurra walya-kurra yungunkulu-jana jurnta kanyi yapa panu-kariki. Jalangurlu karna-nyarra yimi-ngarrirni kuruwarri-kari kuruwarri-kari YAAWIYI-kirlangu. Nyanunguju ngalipa-nyangu Kaatu. Kajinkilirla tarnnga-juku yulkami, manu kajinkili tarnngangku-juku purami, manu kajinkili tarnngangku-juku nyanungu-nyangu kuruwarri purami, ngula-jangka kapu-nyarra nyiyarningkijarra yinyi, manu kapu-nyarra wardinyi-mani-nyayirni. Nyanunguku kapunkulurla marlaja mardarni kurdu panu-jarlu. Kapu-nyarra tarnngangku-juku warrawarra-kanyi nyampurla walyangka. ");
INSERT INTO wbp_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","Nyurrurla marda kapunkulurla jurnta majungka-jarri YAAWIYI-ki purda-nyanja-wangu manu puranja-wangu. Yapa panu-kari marda kapunkulu-jana waalparrirni kuja kalu-jana parntarrimi manu pulka-pinyi nyanungurra-nyangu juju tarrukuku. ");
INSERT INTO wbp_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","Kajinkili kuja-jarrimi, ngajulurlu karna-nyarra pututu-pinyi jalangurlu kapu-nyarra YAAWIYI-rli marlajarra-mani! Yani-jiki kapunkulu karru Jurdunurla murrarninginti-kirra, kala kapunkulu nyina yinyarla witaku-mipa kula tarnnga. ");
INSERT INTO wbp_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","YAAWIYI-rli kaju purda-nyanyi nyarrpa kuja karna-nyarra yimi-ngarrirni nyurrurlaku jalangurlu. Nyurrurlarlangurlu kankujulu purda-nyanyi wangkanja-kurra. Nyarrpa-jarri kankulu jalangu nyurrurla? Ngampurrpa mayi kankulurla nyina YAAWIYI-ki yungu-nyarra wankaru mardarni walya nyampurla? Kapu mardankulu jurnta yani warntawarnta yungu-nyarra murrumurru-mani? Nyarrpa-jarrimi kapunkulu nyurrurlaju? Purda-nyangkajulu jalangurlu! Yungkalu-nyanu YAAWIYI-kirra yungunkulu nyurrurla manu nyurrurla-nyangu kurdukurdu nyanungu-kurlu nyina tarnnga! ");
INSERT INTO wbp_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Yulkayalurla YAAWIYI-ki! Nyanunguju ngalipa-nyangu Kaatu. Purda-nyangkalu nyarrpa kaji-nyarra yimi-ngarrirni. Kulalu puraya jinta-karirlangu-puka tarruku, yampiyalu! Nyanungurlu jintangku kanyarra wankaru mardarni. Kapunkulurla nyampurla walyangka tarnnga marlaja nyina nyurrurla manu nyurrurla-nyangu kurdukurdu. Nyampu walya ngulaju yangka-juku walya kuja-jana nyurru-wiyi jangku-pungu ngalipa-nyangu nyurnunyurnuku Yipuruyamuku, Yijakiki manu Jakupuku.” Kujanya-jana Mujujuju wangkaja yapaku Yijirali-pinkiki. ");
INSERT INTO wbp_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Mujuju-jana yaninjarla wangkaja Yijirali-pinkiki, ");
INSERT INTO wbp_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“Ngajujurna purlkalku. Ngajujurna wankaru nyinaja 120-pala yulyurrpuku. Kulalparna-nyarra nguru-yirrakarlalku. YAAWIYI-ji nyurru-juku wangkaja yangka kularna yani murrarninginti karru Jurdunukuju. ");
INSERT INTO wbp_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","YAAWIYI-ji ngalipa-nyangu Kaatu. Nyanungurlu kapu-nyarra nguru-yirrarni murrarninginti-kirraju. Kapu-jana yapaju yinya-wardingkiji muku pinyi. Kapunkulu-jana walya yinyaju nyurrurlarluju puntarni. YAAWIYI-ji wangkaja yangka Jajuwarlu kapu-nyarra nguru-yirrarni walya yinya-kurraju. ");
INSERT INTO wbp_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Manngu-nyanyi mayi kankulu yangkaju kuja-palangu YAAWIYI-rli pungu wati-jarra Jiyunu manu Yuuku? Kala-pala paaju nyinaja Yamuri-patu yapaku. Junga kujaju. Muku pungu-jana nyanungurra-nyangu yaparlangu. ");
INSERT INTO wbp_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Kajinkili yukamirra Kanana-kurra, YAAWIYI-rli kapu-jana yapa yinya-wardingki-patu rampaku-mani. Ngarili-jana muku pungka yangka kujarna-nyarra ngajulu wangkaja. ");
INSERT INTO wbp_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Pirrjirdili nyinaya! Kulalu-jana lani-jarriya! YAAWIYI-ji ngalipa-nyangu Kaatu. Kapu nyanungurlangu yani walya yinya-kurraju nyurrurla-kurlu. Kula-nyarra yampimi, lawa. Kula-nyarra wajawaja-mani.” ");
INSERT INTO wbp_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Ngula-jangka, Mujujurla purlaja Jajuwaku, wangkajarla yinyarla-juku yapa-patu-puru, “Jajuwa, pirrjirdi nyinaya manu marriwa! Nguru-yirraka-jana yapa nyampu-patuku, manu-jana walya yangka-kurra kangka kuja-jana YAAWIYI-rli jangku-pungu ngalipakupalanguku nyurnunyurnuku. Yanta jirrnganja-jana, manulu-jana walya puntaka! ");
INSERT INTO wbp_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","YAAWIYI kapu yani kamparru nyurrurlarla, Jajuwa. Kapu nyina nyuntu-kurlu. Kulangku yampimi, kulangku wajawaja-mani. Kula lani-jarriya! Kula wajampa-jarriya nyiya-ngurlu!”… ");
INSERT INTO wbp_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","30","... ");
INSERT INTO wbp_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","…Yijirali-pinki yapa-patujulpalu nyinaja-juku kakarrarni-pirdinypa karru Jurdunukuju. Nyinajalpalu ngurra pirli-wangurla yirdingkaju Muwapurla. Yinya-jangkanya, Mujujuju warrkarnu pirli wararrarla yirdingkaju Niipurla, yanu kankarlarra pirlingka Pijika-kurra. Nyampuju kakarrara kirri wiri Jirikukuju. Pirli wararrarla kankarlu, YAAWIYI-rlirla milki-yirrarnu Mujujuku ngurrara kujalpa murrarninginti karrija karru Jurdunuku. Mujujurlulpa nyangu wurnturu yatijarra ngurra yirdiji Kiliyata, manu jingijingi-nyangu kirri jinta-kari yirdi Taanu. ");
INSERT INTO wbp_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","Nyangulpa yatijarra-purda nguru Napatali, manu-palangu ngurra jirrama-kari nyangu Yipirayimi manu Manaja. Karlarra-purdaju nyangu nguru Juurda, manu ngulangka purdangirli nyangu ngapa wiri mangkuru Mirditirinu. ");
INSERT INTO wbp_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Karlarra-purdajulpa nyangu wirri wiri yirdiji Jiriku manu kirri wita yirdiji Jura. Jirikurlanya kalalu watiya kirrirdikirrirdiji karrija. ");
INSERT INTO wbp_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Ngula-jangka, YAAWIYI-rla wangkaja Mujujuku, “Nyampurra walya kuja kanpa nyanyi, nyampuju kujarna-jana jangku-pungu Yipuruyamuku, Yijakiki manu Jakupuku. Wangkajarna-jana, ‘Ngakaju kapurna-jana walya nyampuju yinyi nyurrurla-nyangu kurdukurduku manu yaparla-puraji-patuku.’ Kujanyarna-jana wangkaja. Mujuju, jalangurlurnangku nyampu-kurra kangurnu yungunpa walya nyampu nyanyi. Kala nyuntu kulanpa yani murrarninginti karru Jurdunukuju, lawa.” ");
INSERT INTO wbp_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Ngula-jangka, Mujujuju palija ngulangka-juku Muwapurla kujarla yangka YAAWIYI wangkaja kamparru. Mujujujulparla YAAWIYI-kiji ngurrju warrki-jarrija. ");
INSERT INTO wbp_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","YAAWIYI-rliji Mujujuju milyingka yirrarnu wirringka Muwapurla kutu ngurra-kariki Piti Piiyuruku. Jalangu, kula kalu milya-pinyi nyarrpararla kuja YAAWIYI-rli nyanunguju milyingka yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Mujujuju palija purlka-pardulku. Wankaru nyinaja 120-pala yulyurrpuku. Palinjakungarnti, milpa nyanungu-nyanguju ngurrju-juku. Kala ngurrju nyangu, manulpa pirrjirdi-jiki nyinaja. ");
INSERT INTO wbp_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Kuja Mujuju palija, ngulajulurla Yijirali-pinkiji yulaja 30-pala parraku, nyinajalpalu yinyarla-juku ngurra pirli-wangurlaju Muwapurla. ");
INSERT INTO wbp_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Palinjakungarntirli, Mujujurlurla rdaka nyanungu-nyangu yirrarnu Jajuwa-kurlangu jurrungka yungu milarni. Junga-juku, YAAWIYI-rli Jajuwaju pinarri-manu-nyayirni. Yijirali-pinkirlilpalu purda-nyangu Jajuwaju kujalpa-jana wangkaja. Kujanyarla YAAWIYI-ji wangkaja Mujujuku yungulu Jajuwa purda-nyanyi. ");
INSERT INTO wbp_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Yuwayi, Mujujujulpa nyinaja Kaatu-kurlangu jarukungarduyu. Kulalpa ngana nyinaja jinta-kari jarukungarduyu Mujuju-piya, lawa. YAAWIYI-ji manu Mujuju kala-pala-nyanu jarnku-wangkaja yapa-jarra-piya yangka kuja kapala-nyanu kutu-mirnimirni wangka. ");
INSERT INTO wbp_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","YAAWIYI-rli kula wati-kari milarnu Yijipi-kirra yaninjaku, lawa. Nyanungurluju Mujuju-mipa milarnu yungurla yaninjarla YAAWIYI-kirlangu yartarnarri milki-yirrarni Yijipi-wardingki Kingiki. Junga kujaju! Mujujuju yanu YAAWIYI-kirlangu yartarnarri-kirli. Murrumurru-manu-nyayirni-jana kingiji manu nyanungu-nyangu warrkini-patu manu Yijipi-wardingki-patu, manu-jana panu-kariji tarnnga-kurra-pungu. ");
INSERT INTO wbp_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Yuwayi, Mujujurlulpa yartarnarri wiri mardarnu jarukungarduyu-kari-piya-wangurlu. Kalalu Yijirali-pinkirli nyangu nyanunguju warrki-jarrinja-kurra yartarnarri-kirli. Kalalurla lani-jarrija-nyayirni yartarnarrikiji. ");
INSERT INTO wbp_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Mujujuju kalarla warrki-jarrija YAAWIYI-ki. Wati jinta-kari yirdiji Jajuwa kala warrki-jarrija Mujuju-kurlu. Jajuwaju Nuunu-kurlangu kaja-nyanu. Kuja Mujuju palija, ngula-jangka YAAWIYI-rla wangkaja Jajuwaku, ");
INSERT INTO wbp_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Ngaju-nyangu warrkini Mujujuju palijalku. Nyuntu manu panu-kari Yijirali-pinki, yantalu karru Jurdunu-wana murrarni-pirdinypa walya Kanana-kurra. Walya yinyanya karna-nyarra yinyi nyurrurlaku. ");
INSERT INTO wbp_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Mujujukurnarla jangku-pungu nyampuju walya. Kajinkili yukamirra Kanana-kurra, kajinkili nyarrpara-wana-puka wapami, ngulaju walya yinyaju nyurrurlaku. Ngajulu karna-nyarra yinyi. ");
INSERT INTO wbp_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Kapurna-nyarra walyaju yinyi wurnturu kurlirra-purda jilja-kurra-pinangu, manu yatijarra-purda Lipinani-kirra-pinangu. Kapurna-nyarra walyaju yinyi karlarra-purda ngapa Mangkuru wiri-kirra-pinangu yirdi-kirraju Mirditirinu-kurra manu walya yangka kakarrara karru Yupirayiti-kirra-pinangu. Nyampuju walya kajana karri Yititi-patuku, kala yinyi kapurna-nyarra nyurrurlakulku. ");
INSERT INTO wbp_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Jajuwa, ngajujulparna Mujuju-kurlu nyinaja warrarda. Kuja-piya-yijala kapurna nyuntu-kurluju nyinami. Kularnangku jurnta yani, kularnangku yangarlu yampimi. Kujarlanya, kulangkulu yapangku kulungku warla-pajirni. ");
INSERT INTO wbp_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Pirrjirdi-nyinaya manu lani-wangu! Nguru-yirraka-jana nyampuku yapa-patuku Kanana-kurra yungulu-nyanu walya mani nyanungurrarlulku. Nyampuju walyarna-jana nyurrurlakupalanguku nyurnunyurnuku jangku-pungu. Wangkajarna-jana yangka kapurna-jana yinyi nyanungurraku. ");
INSERT INTO wbp_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Jajuwa, pirrjirdi nyinaya manu lani-wangu! Yirriyirrirli puraya-jana kuruwarri-kari kuruwarri-kari kujangku ngaju-nyangu warrkinirli Mujujurlu yimi-ngarrurnu. Kajinpa kuruwarri nyampu jungangku purami, ngulaju kulanpa rdaka-jarra marlajarra nyina, lawa. Kapurnangku ngajulurlu warrawarra-kanyi nyuntuju tarnngangku-juku. ");
INSERT INTO wbp_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Manngu-nyangka-jana warrarda kuruwarri-kari kuruwarri-kari kuja Mujujurlu yirrarnu nyanungu-nyangu pukungka. Nyangka-jana pukungka mungangka manu parrangka yungunpa pinangkalpalku nyina. Kajinpa pina-jarrimi junga, ngulaju kapunpa jungangku purami. Kapunpa rdirrinypa-jarrimi. Kulanpa rdaka-jarra marlajarra nyinami, lawa. Kapurnangku ngajulurlu warrawarra-kanyi tarnngangku-juku. ");
INSERT INTO wbp_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Kula wajawaja-manta yimi kuja karnangku wangkami jalangu. Wangkajarnangku yungunpa pirrjirdi nyinami lani-wangu. Kula lani-jarriya! Ngajurna YAAWIYI Kaatu yangka kuja kankujulu pura. Kajinpa nyarrpara-puka yani, ngaju kapurna palka nyuntu-kurlu nyina.” Kujanyarla YAAWIYI-ji wangkaja Jajuwakuju. ");
INSERT INTO wbp_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Jajuwa-jana wangkaja wiriwiri-patu-kariki, ");
INSERT INTO wbp_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Nyurrurla yantalu ngurra-kari ngurra-kari kuja kalu Yijirali-pinki nyinami. Kujalu-jana wangkaya, ‘Mantalu-nyanu nyiyarningkijarra, manu wurdujarra-jarriyalu wurnakungarnti. Parra marnkurrpa-jangka kapunkulu yani murrarni-pirdinypa karru Jurdunuku ngurrara Kanana-kurra. Kapunkulu-nyanu walyaju mani nyurrurlarluju. YAAWIYI-rli ngalipa-nyangu Kaaturlu kanyarra yinyi nyurrurlaku.’” ");
INSERT INTO wbp_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Ngula-jangka, Jajuwa-jana wangkaja ngalya-kari Yijirali-pinkiki, yangka-patu Ruupunu-kurlangu turnu-warnuku manu Kaardu-kurlanguku manu Manaja-kurlanguku, yangka-patu kujalpalu kakarrara-purda nyinaja karru Jurdunuku, nyanungu-jana wangkaja, ");
INSERT INTO wbp_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Manngu-nyanyi mayi kankulu kuja-nyarra Mujuju YAAWIYI-kirlangu warrkini wangkaja nyurru-wiyi? Nyanungu-nyarra kuja wangkaja, ‘YAAWIYI-ji ngalipa-nyangu Kaatu. Nyanungurlu kanyarra yinyi nyampuju walya kakarrara-purda karru Jurdunukuju yungunkulu nyina.’ Kujanya-nyarra Mujujuju wangkaja. ");
INSERT INTO wbp_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Junga kujaju. YAAWIYI-rli-nyarra walya nyampuju kakarrara-purda karru Jurdunukuju yungu. Kala jalangu nyurrurla wati-paturlu mantalu-nyanu junma, kurlarda manu kurdiji. Mantalu-nyanu yungunkulu-jana jangkardu yani yapaku kuja kalu nyina yinyarla kamparru-warnu. Yampiyarralu-jana kali-puraji-patuju manu kurdukurdu manu puluku-wati, jiyipi, narnukutu purdangirli. Yantalu-jana jangkardu nyurrurlakupurdangka-purnu-kurlu yapaku kuja kalu karru Jurdunurla nyina murrarninginti. ");
INSERT INTO wbp_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Junga kujaju yangka kuja-nyarra YAAWIYI-rli yungu walya nyampu kakarrara-purda karru Jurdunuku. Ngakalku kapu-jana yinyi nyurrurlakupurdangkaku manu nyanungurra-nyangu warlaljaku. Kala kujakungarntiji pinjaku-wiyili-jana jangkardu yani yapa yinya-patuku-wiyi. Kujarlanyalu nyurrurlaju yanta. Kajili-nyanu walya mani nyanungurrarlu, ngula-jangkaju nyurrurlajulu yantarni-pina, manulu yantarni karru Jurdunu-wana kakarrara nyurrurla-nyangu ngurra-kurra. Yinyanya walya-nyarra yungu Mujujurluju yangka YAAWIYI-kirlangu warrkinirli.” ");
INSERT INTO wbp_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ngula-jangka, yapangkulu yalu-manu Jajuwa, “Ngulaju ngula-juku. Kajinpa-nganpa nyarrpa-puka wangkami, kapurnangkulu purda-nyanyi. Nyarrpara-puka kajinpa-nganpa yilyami, kapurnalu yani. ");
INSERT INTO wbp_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Purda-nyangu warrardarnalu Mujujuju. Kuja-piya-yijala karnangkulu nyuntuju purda-nyanyi. YAAWIYI-ji kala palka nyinaja Mujuju-kurluju. Yungurnangkulurla payirni yungu YAAWIYI palka-juku nyinami nyuntu-kurluju. ");
INSERT INTO wbp_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Kajingki ngana-puka kapuru nyina wilji kajinpa-nganpa nganimpaku wangkami, ngulaju kapurnalu pinyi! Pirrjirdi-nyinaya lani-wangu!” ");
INSERT INTO wbp_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Jajuwarlu, yangka Nuunuku kaja-nyanurlu, milarnu-palangu wati-jarra, ngula-palangu wangkaja, “Yanta-pala karru Jurdunurla murrarninginti kirri wiri-kirra Jiriku-kurra. Nyangka-pala warru nyiyarningkijarra yinyarla. Kala wurulypa-pala wapaya warru, yapangku kajikalu-nyarra nyanyi.” Junga-juku, yinya-jarrarluju-pala yampinja-yanu ngurra Jitumuju, manu wurulypa yukaja-pala Jiriku-kurra mungangka. Yukaja-pala yuwarli-kirra kujalparla karnta Raapaku karrija. Nyanunguju kala wati-kirli ngunaja talakupurda. Wurulypa-palangu yirrarnu Jiriku-wardingki-patu-kujaku. ");
INSERT INTO wbp_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Munga jintangka-juku, yapa jintangkurla yimi-ngarrurnunjunu kingi Jiriku-wardingkiki, “Yijirali-pinki wati-jarra-pala yanurnu nganta nyampu Jiriku-kurra. Warru kapala nyanyi nganta nyiyarningkijarra nyampurla.” ");
INSERT INTO wbp_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Junga-jukurla kingirli yimi yilyaja Raapaku, “Kangkarni-palangu wati-jarra kuja-pala yukaja yuwarli nyuntu-nyangu-kurra. Ngari-pala yanurnu yungu-pala nyanyi nyiyarningkijarra ngalipa-nyangu walyangka.” ");
INSERT INTO wbp_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Raapa-jana wangkaja warrkini-patuku kingi-kirlangu-patukuju, “Junga, wati yinya-jarraju-pala yanurnu ngaju-nyangu yuwarli-kirra. Kala kularna milya-pungu nyarrpara-jangka kuja-pala yanurnu. ");
INSERT INTO wbp_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Kujalpa wanta kanunju-jarrinja-yanu, yuwarli ngaju-nyanguju-pala yampinja-yanu. Kula karna milya-pinyi nyarrpara-kurra kuja-pala yanu. Kala kajinpa kapanku yani nyuntu-nyangu wati-patu-kurlu, ngulaju kapunkulu-jana marda kapanku puuly-mardarni.” ");
INSERT INTO wbp_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","(Karnta yinyajulparla warlka wangkaja kingikiji. Wati yinya-jarrarlu kula-pala yampinja-yanu nyanungu-nyangu yuwarli, lawa. Kangu-palangu kankarlu yuwarli-kirra, wurulypa yirrarnu-palangu kanunjumparra marna kirrirdirla. Marna yinyaju kamparrurlu-juku manu, kuja kankarlarni yuwarlirla yirrarnu, manu yirrarnu wanta-kurra linji-jarrinjaku. Yinyarlanya-palangu wati-jarraju wurulypa yirrarnu.) ");
INSERT INTO wbp_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Ngula-jangka, kingi-kirlangu wati-paturlulpalu-jana warrurnu warru yinyaku Yijirali-pinki wati-jarraku. Kujalu wilypi-pardija kirri-ngirli, purdangirli-wanarlulu kiirtiji jatimapi-manu tuwa wiri-kirlirli. Ngula-jangkalu yanu karru Jurdunu-kurralku nyanjaku marda-pala yanu yinya-wananya ngapa jalja-wana. Kala lawa, kulalu-jana palka-manu. ");
INSERT INTO wbp_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Nyampu-puru, wati-jarrajulpa-pala jardakungarntiji nyinaja. Raapaju kankarlu yanu, manu wangkaja-palangu, ");
INSERT INTO wbp_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","“Milya-pinyi karna kuja-nyarra YAAWIYI-rli ngurra nyampu yungu nyumpalaku manu nyumpala-nyangu yapaku. Nyurrurlaju kankulu-nganpa lani-mani. Panu nyampurla yapa walyangka karnalu-nyarra lani-jarrimi. ");
INSERT INTO wbp_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Purda-nyangurnalu kuja-ka YAAWIYI nyina nyurrurla-kurlu. Yimirnalu purda-nyangu kuja-nyarra nguru-yirrarnu Yijipi-ngirli, manurnalu purda-nyangu kuja ngapa mangkuru ngapa-wangu-manu manu walya kuja parduna-jarrija kujankulu kulkurru-jarra ngapa-warnurla yanu. Purda-nyangurnalu kujankulu-jana muku pungu kingi-jarra Jiyunu manu Yuuku manu Yamuri yapa-patu yangka-patu kuja kalalu nyinaja kakarrara-purda karru Jurdunuku. ");
INSERT INTO wbp_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Kujarnalu kuja purda-nyangu, lani-jarrija mukurnalu. Jalangu kula-ka jintarlangu-puka nyampu-wardingki wati ngampurrpa nyina yungu-nyarra kulu-jarrimi, lawa. Milya-pinyi karnalu kuja kanyarra YAAWIYI Kaatu wiri nyina nyurrurlaku nguru-nyayirni-wangurla manu nyampurla walyarlangurla. ");
INSERT INTO wbp_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","YAAWIYI-rli kangalpa purda-nyanyi wangkanja-kurraju. Ngarrikajulu ngaju manu ngaju-nyangu warlalja-paturlangu yangka kapunkulu-nganpa ngampangampa nyina. Ngajujurnangkupala ngampangampa nyinaja, manurnangkupala muurl-mardarnu. Yungkaju-pala nyiya mayi yungurnangkupala milya-pinyi kajinpajupala ngurrju nyina ngajuku. ");
INSERT INTO wbp_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Kajinkili nyurrurla Yijirali-pinki pina-yanirni kuluku nyampu-kurra ngurra-kurra, ngarrikaju-pala yangka kulankulu-jana pinyi ngajuku kirdana manu ngamardi manu ngajukupurdangka-purnu. Ngarrikaju-pala yangka kulankulu-jana pinyi nyanungurra-nyangu warlaja-paturlangu.” ");
INSERT INTO wbp_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Wati-jarra-palarla wangkaja Raapaku, “Ngurrju! Nyuntulurlunpa-jarrangku muurl-mardarnu kingi-kijaku manu nyanungu-nyangu wati-patu-kujaku. Kujarlanya, kaji-nganpa YAAWIYI-rli walya nyampu yinyi Yijirali-pinkiki, kapurnalu-nyarra ngampangampa nyina nyuntuku manu nyuntu-nyangu warlaljaku. Wala-nganpa nyinaka, junga karlijarrangku wangka. Kula-jana yapa ngalya-kariki wangkaya kujarlijarra yanurnu nyampu-kurra nyanjaku nyiyarningkijarraku.” ");
INSERT INTO wbp_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Raapa-kurlangu yuwarliji karrija kankarlarra pirlingka pinji-piyarla kujalpa warrukirdikirdi yanu kirri wiriki Jirikuku. Nyanungurluju manu kirrirdi-nyayirni ngalyipi yalyuyalyu wati-jarraku juturu-yirrarninjaku wintawu-wanarlu walya-kurraju. ");
INSERT INTO wbp_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Yilyanjakungarnti wangkaja-palangu, “Yanta-pala kapanku pirli-patu-kurra, manu-pala wurulypa nyinaya parra marnkurrpaku. Kingirli manu nyanungu-nyangu wati-paturlu kalu-nyarra warrirni-jiki. Kala kulalu-nyarra palka-mani pirlingkaju. Kajili nyampu-kurra pina-yanirni, ngula-jangka-pala parnkaya nyuntu-jarra-nyangu yapa-patu-kurralku.” ");
INSERT INTO wbp_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Ngula-jangka-palarla wati-jarraju wangkaja, “Purda-nyangka-jarrangku yungurnalu-nyarra muurl-mardarni nyuntu manu nyuntu-nyangu warlalja-patu. Kajinpa purda-nyanja-wangu nyina, marda nyuntu manu nyuntu-nyangu warlalja kapulu palimi kajirnalu nyampu-kurra pina-yanirni Yijirali-pinkiji. ");
INSERT INTO wbp_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Nyuntulurlu kanpa ngalyipi nyampu kirrirdi yalyuyalyu mardarni yungunpa-jarrangku walya-kurra juturu-yirrarni yungurlijarra wurulypa parnkami. Kajirnalu pina-yanirni walya nyampu-kurra kuluku, ngalyipi nyampuju warika wintawurla yungurnalu nyanyi. Kangkarni-jana nyuntukupalangu kirdana manu ngamardi manu nyuntukupurdangka-purnu nyuntu-nyangu yuwarli-kirra. ");
INSERT INTO wbp_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Kala kaji nyuntu-nyangu warlalja jintarlangu yarlu-kurra wilypi-pardimi, manu kaji palimi pantirninja-warnu, kulalu-nganpa jiily-ngarrika. Kajinkili yuwarlirla-juku nyinami, ngulaju kapurnalu-nyarra muurl-mardarni palinja-kujaku. Kajinkili kaninjarni yuwarlirla nyinami, kajili-nyarra Yijirali-pinki jangkardu yukami yuwarli-kirra pinjaku, ngula-jangkanyalu-nganpa milpaju jiily-ngarrika. ");
INSERT INTO wbp_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Kula-jana yapa ngalya-kariki yimi-ngarrika ngajarraju. Lawangkaju, kularnangkulu muurl-mardarni-yijala.” ");
INSERT INTO wbp_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Raaparlu-palangu yalu-manu, “Yuwayi, ngurrju kujaju!” Ngula-jangka-palangu yilyaja wati-jarraju, wurulypa parnkaja-pala kingi-kijaku manu wati-patu-kujaku. Ngula-jangka, Raaparluju ngalyipi wayurnu wintawurla yungulu Yijirali-pinkirli nyanyi ngaka. ");
INSERT INTO wbp_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Wati yinya-jarraju-pala kapanku-juku yanu pirli-patu-kurraju, manu-pala nyinaja marnkurrpaku parrakuju. Kingi-kirlangu wati-paturlulpalu-jana warru nyangu yirdiyi-wana. Warrurnulpalu-jana parra-patuku. Kala lawa, kulalu-jana palka-manu. Ngula-jangkalu pina-yanu kirri-kirraju rdaka-jarra marlajarra. ");
INSERT INTO wbp_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Ngula-jangka-pala wati-jarraju yanu pina pirli-jangkaju kakarrara-purda murrarninginti karru Jurdunukuju. Yanu-palarla Jajuwaku, manu-palarla wangkaja nyiyarningkijarra. ");
INSERT INTO wbp_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Wangkaja-palarla, “Kari-nganta-ngalpa YAAWIYI-rliji yungu walya yinyaju ngalipaku. Yapa-patu yinyarlaju kuja kalu nyina, ngulaju kalu-ngalpa lani-jarrimi!” ");
INSERT INTO wbp_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Mungalyurru kujalpa wanta kankarlarni-jarrinja-yanu, Jajuwarlu manu panu-kari Yijirali-pinkirli yampinja-yanu ngurra Jitumuju, manulu wurna yanu karru Jurdunu-kurra. Kujalu yukajarra yinya-kurra, ngurrangkalu ngunaja parra-patuku. ");
INSERT INTO wbp_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Ngula-jangkalu-jana wiriwiri warru wapanjarla wangkaja yapa-patuku, ");
INSERT INTO wbp_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","“Jukurra maralypikingarduyu-paturlu manu Liipi-paturlu kapulu mani YAAWIYI Kaatu-kurlangu Pakuju Tarruku Kapunkulu-jana nyanyi kajili kamparrurlu kanja-yani nyurrurlarla. Kajinkili-jana nyanyi, karrinja-pardinjarlalu puraya purdangirli-wanarlu. ");
INSERT INTO wbp_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Kulankulu kamparru-wiyi nyampurla walyangka wapaja, lawa. Kajinkili Tarruku Pakuju purami, kapunkulu milya-pinyilki nyarrpara-wana yaninjaku. Kulalu kutu-nyayirni yanta Pakuju-kurra, wurnturu-ngurlurlu ngarili puranja-yanta.” ");
INSERT INTO wbp_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Ngula-jangka, Jajuwa-jana wangkaja yapa-patuku, “Wurdujarra-jarriyalu yungunkulu YAAWIYI jungangku purami jukurrarlu. Nyanunguju tarruku. Jukurrarlu kapu-nyarra milki-yirrarni nyiyarningkijarra ngurrju-nyayirni yartarnarri nyanungu-nyangu-kurlurlu.” ");
INSERT INTO wbp_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Ngula-jangka, Jajuwa-jana wangkaja maralypikingarduyu-patuku, “Mantalu Pakuju Tarruku, kamparrulu kanja-yanta yapa-patuku, manulu yanta karru Jurdunurla murrarninginti.” Junga-juku, maralypikingarduyu-paturlulu manu Pakuju Tarruku, ngulalu kanja-yanu kamparru yapakuju. ");
INSERT INTO wbp_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Ngula-jangka, YAAWIYI-rla wangkaja Jajuwaku, “Jalangurluju karnangku wirilki yirrarni Yijirali-pinki yapaku. Kapulu milya-pinyi kuja karna palka nyina nyuntu-kurlu yangka-piya-yijala kujalparna Mujuju-kurlu nyinaja. ");
INSERT INTO wbp_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Jukurrarlu kapulu maralypikingarduyu-paturlu kanja-yani Pakuju Tarrukuju. Wangkaya-jana kuja, ‘Yantalu pirntinyarra-kurra karru Jurdunu-kurra. Yaninjarlalu karriya Pakuju Tarruku-kurlu ngapangka.’” ");
INSERT INTO wbp_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Ngula-jangka, Jajuwa-jana wangkaja yapa-patuku, “Yantarnili nyurrurla nyampu-kurra! Purda-nyangkalu kujaju nyarrpa wangkaja YAAWIYI Kaatu. ");
INSERT INTO wbp_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Marda kankulu manngu-nyanyi kuja, ‘Nyarrparlurlipa milya-pinyi YAAWIYI Kaatuju ngalipa-kurluju? Nyanunguju JUKURRARNU junga. Yinyarra yapa Kanana-wardingki-patu, Yititi-patu, Yiipiti-patu, Piriji-patu, Kirrkaji-patu, Yamuri-patu manu Jipuji-patu kalu nyina-juku karlarra karru Jurdunuku. Nyarrparlulku karlipa milya-piyi YAAWIYI-rliji kapu-jana wajirli-pinyi ngalipa-kujakuju?’ Marda kankulu kujanya marda manngu-nyanyi. ");
INSERT INTO wbp_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ngulaju ngula-juku. Yungurna-nyarra yimi-ngarrirni yungunkulu milya-pinyi YAAWIYI. Jukurrarlu kapulu maralypikingarduyu-paturlu kanja-yani Tarruku Pakuju kamparrurlu nyurrurlakuju. Kapulu ngapa-kurra yukanjarla wapanja-yani karru Jurdunurla. ");
INSERT INTO wbp_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Nyurrurlaju kankulu nyina turnu-warnu 12-pala-jangka. Jinta watili-jana jarnkujarnku milaka nyurrurla-nyangu turnu-warnu-patu-jangka. ");
INSERT INTO wbp_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Maralypikingarduyu-paturlu kapulu laja-kanja-yani Tarruku Pakujuju. Ngulaju YAAWIYI-kirlangu yangka Warlalja-Wiri yapa panuku nyampurla walyangkaku. Kapulu kamparrurla laja-kanja-yani karru Jurdunu-kurra. Kajili ngapa-kurra yukamirra, ngawarraju kapu kanunju-jarrimi kula-ngantarla nganangku mayi jaarl-yirrarnu ngawarra wiri parnkanja-kujaku.” Kujanya-jana Jajuwaju wangkaja yapakuju. ");
INSERT INTO wbp_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Ngula-jangka, maralypikingarduyu-paturlulu Pakuju Tarruku manu, manulu laja-kanja-yanu kamparru yapa-patukuju. Yapa-paturlujulu yampinja-yanu yinyaju ngurra kujalpalu ngunaja. Ngulalu yarnkajarra karru Jurdunu-kurra. ");
INSERT INTO wbp_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Kuja-puru, karru Jurdunujulpa ngapa wiri-kirli karrija. Kuja-juku kala parnkaja ngapaju wiri yangka kuja kalalu miyi-wati yirnmi-jarrija. Junga, ngapa yinyaju rdaku kanunju-nyayirni. Yangka-patu maralypikingarduyu-patu kujalpalu Pakuju Tarruku laja-kanja-yanu, yanurnulu kutu karru-kurra. Ngula-jangkalu ngapa-kurralku yukaja. ");
INSERT INTO wbp_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Ngapaju kapanku lawa-jarrija parnkanja-kujakuju wurnturu-nyayirni ngurra-kari yatijarra Yatumurla, nyiya mayirla jaarl-karrija ngapa ngawarra parnkanjakuju. Yatumuju ngurra kutu Jarajanaku. Ngapaju kala parnkaja karru Jurdunu-ngurluju kurlirra mangkuru Yarapa-kurra. Yijirali-pinkili jingijingi yanu murrarninginti-kari-kirra karru Jurdunu-wana kirri wiri-kirra Jiriku-kurra. ");
INSERT INTO wbp_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Junga kujaju. Walya yinyarla karrungka, ngulaju parduna-jarrija. Maralypikingarduyu-patulu kulkurru ngapa-kurra yanu Pakuju Tarruku-kurlu, manulu jupu-karrija yinyarla-juku. Karrijalpalu warrarda kujalu Yijirali-pinki karlarra-purda-kurra yanu. Wapajalpalu walyangkaju ngapa-wangurlalku. ");
INSERT INTO wbp_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Kujalu Yijirali-pinki yanu murrarninginti karru Jurdunuku karlarni-pirdinypa, ngula-jangkaju YAAWIYI-rla wangkaja Jajuwaku, ");
INSERT INTO wbp_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Milaka-jana 12-pala wati-patu yapa nyampu-jangka. Milaka-jana jinta-kari jinta-kari 12-pala-jangka turnu-warnu-jangka. ");
INSERT INTO wbp_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Wangkaya-jana nyampuku 12-pala wati-patuku yungulu pina-yani karru-kurra manu yungulu-jana jinta-kari jinta-karirli yarturlu mani. Yungulu-jana mani jinta-kari jinta-kari yangka-jangka kujalpalu maralypikingarduyu-patu karrija Pakuju Tarruku-kurlu. Kajili-jana mani 12-pala yarturlu, wangkaya-jana yungulu-jana ngurra-kurra kanyi yangka kuja kapunkulu jalangu ngunami ngurrangka mungangka. Yalumpurlajukulu-jana yurturlurla yirraka.” ");
INSERT INTO wbp_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Junga-juku, Jajuwarlu-jana milarnu 12-pala wati-patu jinta-kari jinta-kari 12-pala-jangka turnu-warnu-jangka, ngula-jangka-jana wangkaja, ");
INSERT INTO wbp_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","“Nyurrurla wati-patu yantalu pina kulkurru-jarra karru-kurra kuja kalu karrimi yangka maralypikingarduyu-patu Pakuju Tarruku-kurlu YAAWIYI Kaatu-kurlangu-kurlu. Jinta-kari jinta-karirlili-jana yarturlu manta. Kapulu-nyarra jinta-kari jinta-kari karrimi nyurrurlaku yarturlu 12-pala-jangka turnu-warnu-jangkaku. Kangkarnili-jana yarturluju jimantarla yurturlurla yirrarninjakungarnti. ");
INSERT INTO wbp_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Ngaka kajinkili nyanyi nyampurra yarturlu-patu, kapunkulu manngu-nyanyi YAAWIYI kuja-ngalpa nyampu-kurra ngurra-kurra kangurnu. Ngaka kapulu-nyarra nyurrurla-nyangu kurdukurdurlu payirni kujarlu, ‘Kirdana, nyiyaku nyampuju yarturlu 12-pala? Nyiyaku kalu karri?’ ");
INSERT INTO wbp_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Kajili-nyarra kujarlu payirni, wangkayalu-jana kuja, ‘Kurdukurdu, nyurru-wiyi manurnalu-jana 12-pala yarturlu kulkurru-jangka karru Jurdunu-jangka yangkangka kuja-nganpa YAAWIYI-rli kangurnu karlarra-purda-kurra. Kujalu maralypikingarduyu-paturlu laja-kanja-yanu Pakuju Tarruku ngapa-kurra, YAAWIYI-lpa-jana palka karrija, manu ngapa warla-pajurnu parnkanja-kujakuju.’ Kujarlunyalu-jana kurdukurdu nyurrurla-nyangukuju yimi-ngarrika. Nyampuju junga. Yarturlu nyampu-paturlu kapulu-ngalpa langa-kurra-mani yimi nyampuju tarnnga.” ");
INSERT INTO wbp_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Ngula-jangka, 12-pala yinya wati-patu yukajalu karru Jurdunu-kurra, ngulalu-jana jinta-kari jinta-karirli pina-kangurnu yarturlu. Jinta-kari jinta-karilpalu-jana karrija yarturlu-wati 12-pala-jangka turnu-warnuku. Ngulalu-jana kanja-yanu yarturluju jimantarla, manulu-jana kangu ngurra-kurra kujalpalu Yijirali-pinki nyinaja karlarra-purda karru Jurdunuku. Yalumpurlajukulu-jana yurturlurla yirrarnu. Nyampuju yangka kujarla YAAWIYI wangkaja Jajuwaku nyarrpa-jarrinjaku. ");
INSERT INTO wbp_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Jajuwarlu-jana manu 12-pala-yijala yarturlu, manu-jana yirrarnu kulkurru-jarra karru Jurdunurla yangkangka-juku kujalpalu maralypikingarduyu-patu karrija kamparru-wiyi Pakuju Tarruku-kurlu. Yarturlu yinya-patuju kalu palka-juku karrimi jalangu. ");
INSERT INTO wbp_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Nyampu yimiji ngulaju junga. YAAWIYI-rla wangkaja Jajuwaku yungu-jana nyarrpa wangkami yapa-patuku. Yimi yangka-juku kujarla kamparru-wiyi Mujujuku wangkaja. Kujarlanya, yinya maralypikingarduyu-patu kujalpalu kanja-yanu Pakuju Tarruku, yanulu kulkurru-jarra karru Jurdunu-kurra. Kulkurrulpalu karrija kujalpalu jingijingi yanu Yijirali-pinki karlarra-purda karru Jurdunurla. ");
INSERT INTO wbp_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Kujalu yapa-patu jingijingi yanu, ngula-jangka maralypikingarduyu-paturlulkulu kangu Pakuju Tarruku karru Jurdunu-jangka. Pakuju yinyaju YAAWIYI-kirlangu. Yijirali-pinkirlijilpalu-jana nyangu kanjarni-kirra. ");
INSERT INTO wbp_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Wati-patu yangka Kaardu-kurlangu turnu-warnu-jangka, Ruupunu-kurlangu-jangka manu Manaja-kurlangu-jangka, palkalpalu karrija kurdiji-kirli, junma-kurlu manu kurlarda-kurlu. Yanulu murrarninginti karru Jurdunu-wana yapakuju kamparru Yijirali-pinkikiji. ");
INSERT INTO wbp_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","40,000-pala watilpalu warrmarla karrija kulukungarnti. Kujalpalu maralypikingarduyu-patu karrija karru Jurdunurla Pakuju Tarruku-kurlu, warrmarlarlujulu yanu jingijingi karlarra-purda, ngulalu yanu walya pirli-wangu-wana kirri wiri-kirra Jiriku-kurra. Kulukulu yanu. ");
INSERT INTO wbp_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Parra jintangka-juku, YAAWIYI-rliji Jajuwaju wirilki yirrarnu yapa nyampu-patukuju. Kujalpa Jajuwa wankaru-juku nyinaja, yapangkujulpalurla pulka-pungu Mujuju-piyaku-yijala yangka kuja kalalurla kamparrurlu pulka-pungu. ");
INSERT INTO wbp_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ngula-jangka, YAAWIYI-rla wangkaja Jajuwaku, ");
INSERT INTO wbp_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Jajuwa, wangkaya-jana maralypikingarduyu-patuku yungulu Pakuju Tarruku kanyirni karru Jurdunu-jangka.” ");
INSERT INTO wbp_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Junga-juku, Jajuwa-jana purlaja maralypikingarduyu-patuku, “Yuwa! Kangkarnili Pakuju Tarruku ngapa-jangka!” ");
INSERT INTO wbp_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Jungajukulu maralypikingarduyu-paturluju kangurnu Pakuju ngapa-jangkaju karlarra-purda. Kujalu pirntinyarra-kurra-jarrija, ngawarraju parnkajalku. Kankarlu-jarrija-nyayirni, ngarilpa ngapaju parnkaja kamparru-piya-juku. ");
INSERT INTO wbp_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Nyampuju yimiji junga. Yijirali-pinkijili wilypi-pardija karru Jurdunu-jangka kirntangi kamparru-warnurla ngulaju parra nampa karlarla-pala-puru. Yaninjarlalu ngunaja Kilkalarla kakarrara Jirikukuju. ");
INSERT INTO wbp_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Kanja-yanulpalu-jana yangkaju 12-pala yarturlu kujalu-jana manu karru Jurdunurla. Kujalu yukajarra Kilkala-kurra, Jajuwarlu-jana yinyaju 12-pala yarturlu yirrarnu yurturlurla. ");
INSERT INTO wbp_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Ngula-jangka-jana wangkaja Yijirali-pinkiki, “Ngaka kapulu-nyarra nyurrurla-nyangu kurdukurdurlu payirni kujarlu, ‘Kirdana, nyiyaku nyampurraju 12-pala yarturlu? Nyiyaku kalu karrimi nyampurlaju?’ ");
INSERT INTO wbp_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Kajili-nyarra kujarlu payirni, wangkayalu-jana kuja, ‘Kurdukurdu, nyurru-wiyirnalu wapaja karru Jurdunurla kula-nganta patingka. ");
INSERT INTO wbp_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","YAAWIYI-rli ngalipa-nyangu Kaaturlu ngapaju-nganpa warla-pajurnu jurnta parnkanja-kujaku. Kujalparnalu wapanja-yanu karrungka karlarra-purda, ngulajulpa karrija ngapa-wangu, lawa. Kala kujarnalu wilypi-pardija karru-jangka, ngapaju parnkajalku. Junga kujaju. YAAWIYI-rli-nganpa warla-pajurnu jurnta ngapaju parnkanja-kujaku nyurru-wiyi-piya kuja-jana nguru-yirrarnu ngalipakupalangu kirdanaku manu ngamardiki kulkurru-jarra mangkururla Marna Kirrirdi-kirlirla. ");
INSERT INTO wbp_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","YAAWIYI-rli-nganpa nguru-yirrarnu yinya-wanaju yungurnalu milya-pinyi nyanungu-nyangu yartarnarri wiri.’ Kujarlunyalu-jana yimi-ngarrika nyurrurla-nyangu kurdukurdukuju. Kajili yimi nyampu purda-nyanyi, ngula-jangka kapulurla pulka-pinyi YAAWIYI-ki ngalipa-nyangu Kaatuku.” ");
INSERT INTO wbp_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Yimi nyampuju junga. YAAWIYI-rli ngawarra warla-pajurnu yungulu Yijirali-pinki karlarra-purda yani. Kuja-puru Yamuri-patu yapalpalu nyinaja ngurra-kari ngurra-kari nguru yinyarlaju karlarra-purda karru Jurdunukuju. Yamuri kingi-paturlulu-jana purda-nyangu Yijirali-pinki kujalpalu yanurnu. Kanana-wardingki kingi-patu kujalpalu nyinaja mangkuru-wana Mirditirinu-wana, ngularlangurlulu-jana purda-nyangu nyanungurra-kurluju. Mukulu lani-jarrija. Ngula-jangka, kulalu-jana ngana jangkardu yanurnu kulu Yijirali-pinkikiji. ");
INSERT INTO wbp_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Ngula-jangka, YAAWIYI-rla wangkaja Jajuwaku, “Ngurrju-manta-nyanu kanti-patu nyuntulurlu. Turnu-manta-jana wati-patu manu wirriyawirriya, manu junma ngularra-kurlurlu-jana ngarrka-kijika yungulu-jana yapa ngalya-karirli milya-pinyi nyanungurraju yapa ngaju-nyangu.” ");
INSERT INTO wbp_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Junga-juku, Jajuwarlu-jana ngurrju-manu kantiji. Ngula-kurlurlu-jana ngarrka-kujurnu wati-patu manu wirriyawirriya ngurrangka yirdingkaju Kipiyata Yaralatarla. ");
INSERT INTO wbp_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Nyiyaku-jana Jajuwarlu ngarrka-kujurnu wati-patuju? Kujakungarnti, kujalu Yijirali-pinki yanurnu Yijipi-ngirli, yapajulu warru yanu 40-pala yulyurrpuku jilja-wana. Wati yinya-paturluju kalalu mardarnu kurlarda manu kurdiji kulukungarntirli. 40-pala yulyurrpu-puru, yulyurrpu-kari yulyurrpu-kari, wati yinya-patujulu muku palija. ");
INSERT INTO wbp_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Kala 40-pala yulyurrpu-puru, kurdukurdu wirriyawirriyalpalu palka-jarrija, manu kula-jana nganangku ngarrka-kujurnu, lawa. ");
INSERT INTO wbp_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Junga kujaju. Yijirali-wardingkijilpalu warru wapaja jilja-wana 40-pala yulyurrpuku, manulu wati-patu warrmarla-patuju muku palija, yangka-patu kujalu yanurnu Yijipi-jangka. Nyiya-jangka kujaju? Yapa yinya-paturlu kulalu purda-nyangu YAAWIYI-ji. Kujarlanya-jana wangkaja kulalu nyanungurraju yukamirra Kanana-kurraju yangka walya kuja-jana jangku-pungu nyurnunyurnuku. Nguru yinyarlajulpa nyiyarningkijarra miyilpa pardija. ");
INSERT INTO wbp_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Wati yinyarrajulu muku palija. Kala nyanungurra-nyangu kaja-nyanulpalu palka-jarrinjarla wiri-jarrijalku. Kala kula-jana nganangku ngarrka-kujurnu. Kujarlanya-jana Jajuwarluju ngarrka-kujurnu kanti-kirlirliji. ");
INSERT INTO wbp_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Kuja-jana ngarrka-kujurnu, murrumurru-nyayirnilpalu nyinaja. Ngulajulpalu nyinajalku jurrkungka-juku ngurrangkaju parra-patuku yangka kajili ngurrju-jarrimi. ");
INSERT INTO wbp_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ngula-jangka, YAAWIYI-rla wangkaja Jajuwaku, “Nyurru-wiyi Yijipirla, yangka kuja kalalu-nyarra Yijipi-wardingki-paturlu jinyijinyi-manu warrki-jarrinjaku pirijina-piyaku, nyurrurlajunkulu kurnta-jarrija. Kala jalangurlu kankulu nyina ngaju-nyangu ngarrka-kijirninja-warnu. Kujarlanya kula kankulu kurnta-jarrimilki.” Kujarlanya, Jajuwarluju ngurra yinyaju yirdi-manu ‘Kilkala’. Yapangku kalu ngurra yinyaju Kilkala-pajirni-jiki jalangurlu. ");
INSERT INTO wbp_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Yijirali-pinki yapa-patujulpalu nyinaja Kilkalarla nguru pirli-wangurla kutu Jirikukuju. Kirntangi kamparru-warnurla, parra nampa 14-puru, ngula wanta yukajarra, ngarnulu kurapaka Pajapa. ");
INSERT INTO wbp_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Parra jinta-karirla, miyili ngalya-kari ngarnu kujalpalu nguru yinyarla pardija. Ngarnulu miyi lalypa manu ngurlu kujalu warlungka purraja. ");
INSERT INTO wbp_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Nyampukungarnti kalalpalu ngarnu mangarri kankarlarra-jangka yangka kujalpa-jana YAAWIYI-rli yilyaja yalkiri-ngirli. Kala kujalpalu ngarnulku mangarri panu-kari Kananarla, YAAWIYI-rli warla-pajurnu-nyanu mangarriji yilyanja-wangurlu. Ngula-jangka, yulyurrpu jurrku-puru-juku, Yijirali-pinkirlijilpalu ngarnu miyiji kujalpalu pardija Kananarla. ");
INSERT INTO wbp_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Ngaka-pardu-karilki, Jajuwajulpa nyinaja Jiriku-wana. Kankarlarra-kari nyangu wati karrinja-kurra nyanungurla kamparru. Mardarnulpa kirrirdimpayi junma. Jajuwaju karrinja-pardinjarla yanu, manu payurnu nyanunguju, “Nyuntuju mayi ngaju-nyangu wungu-warnu, marda mayinpaju pinyi?” ");
INSERT INTO wbp_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Watingki yalu-manu Jajuwaju, “Kularna nyuntu-nyangu wungu-warnu, kala kularnangku pinyi. Ngajujurna-jana YAAWIYI-kirlangu warrmarlaku wiri.” Ngula-jangka, Jajuwaju parntarrinjunu yinngirri-purdanji, payurnu watiji, “Warlaljamarri, yungunpaju mayi nyiya yimi-ngarrirnilki?” ");
INSERT INTO wbp_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Ngula-jangka, wati yinyajurla wangkaja Jajuwakuju, “Yalyi-manta-nyanu wirliya-kurlangu. Nyampurla kuja kanpa karrimi, ngulaju mukunypa.” Junga-juku, Jajuwarlu yalyi-manu wirliya-kurlanguju. ");
INSERT INTO wbp_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Yijirali-pinki yapalpalurla kutu-jarrinja-yanu kirri wiri Jirikukuju. Kuja-kujakujulpalu Jiriku-wardingki-patu yapaju lani-jarrija. Ngulalu-jana muku jatimapi-manu kiirti-watiji kujalpalurla jaarl-karrija kirri wiriki Jirikuku. Kulalpa ngana yukayarlarra kirri yinya-kurraju, manu kulalpa ngana kiirti yinyarra-wanaju wilypi-pardiyarlarra. ");
INSERT INTO wbp_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Ngula-jangka, YAAWIYI-rla wangkaja Jajuwaku, “Purda-nyangkaju ngajulu! Ngajulurlurna-jana rampaku-manu nyampuju kirriji Jiriku, kingi manu nyanungu-nyangu warrmarla. Kapulu-nyarra jijami nyurrurlaku. ");
INSERT INTO wbp_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Turnu-manta-jana nyuntu-nyangu warrmarla, manulu warru wapaya Jiriku-wana jintaku-mipa. Kuja-piya-yijalalu wapaya jukurraju, manu ngula-jangkaju murntu-pala-karikilki parraku. ");
INSERT INTO wbp_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Wangkaya-jana wirlki-pala maralypikingarduyu-patuku yungulu-nyanu mani kurlumpurrngu yangka kuja kalu ngurrju-mani wuunu-jangka jiyipi-jangka. Wangkaya-jana yungulu wapami kamparru yangka-patu-wana kuja kalu kanja-yani Tarruku Pakuju. Jika-pala parrakulu kuja-jarriya. Parra-karirla, nyuntu manu nyuntu-nyangu warrmarlalu wapaya warru kirri wiri-wana wirlki-palaku. Kajinkili wapami warru, yinya-patu maralypikingarduyu-paturlu yungulu-jana jitirni kurlumpurrngu-patu. ");
INSERT INTO wbp_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Kajinkili wapami warru kirri-wana wirlki-palaku, ngula-jangkaju yungulu maralypikingarduyu-paturlu kurlumpurrngu jitirni kilji-nyayirnirli jintaku-mipa. Kajinkili-jana purda-nyanyi kuja-kurra, ngula-jangkaju yapa-patu yungulu kilji-yijala purlami. Ngula-jangka, yangka pinji-piya yarturlu kirrirdimpayi kuja-ka kirri-wana warru karrimi, ngulaju kapu wantimi kaninjarra. Ngula-jangka, ngarili nyurrurlaju kutu yukayarra kaninjarniiji.” ");
INSERT INTO wbp_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Ngula-jangka, Jajuwa yangka Nuunuku kaja-nyanu, turnu-manu-jana maralypikingarduyu-patuju, wangkaja-jana, “Nyurrurlarlulu maninjarla kanjanka Pakuju Tarruku YAAWIYI-kirlangu. Wangkaya-jana wirlki-pala-kariki maralypikingarduyu-patuku yungulu-jana kanja-yani kurlumpurrngu-wati kamparrurlu yapakuju.” ");
INSERT INTO wbp_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Ngula-jangka, Jajuwa-jana wangkaja yapa-patuku, “Karrinja-pardinjarlalu yantalku! Wapayalu warru kirri Jiriku-wana. Nyurrurla warrmarla-patu kurlarda-kurlu manu kurdiji-kirli, nyurrurlajulu wapaya kamparru Pakuju Tarrukukuju YAAWIYI-kirlangukuju.” ");
INSERT INTO wbp_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Junga-juku, yinya yangka wirlki-pala maralypikingarduyu-patu, wapanja-yanulpalu kamparru Pakuju Tarrukukuju. Jarnkujarnku mardarnulpalu-jana kurlumpurrngu ngulalpalu jitirninja-yanu kujalpalu wapanja-yanu. Ngalya-kari maralypikingarduyu-patujulpalu purdangirli-wana wapanja-yanu. Kanja-yanulpalu Pakuju Tarruku. ");
INSERT INTO wbp_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ngalya-kari warrmarla-patu kurlarda-kurlu manu kurdiji-kirli, ngulajulpalu wapanja-yanu kamparru maralypikingarduyu-patukuju, manu ngalya-kari warrmarla-paturlulpalu-jana puranja-yanu purdangirli-wanarlu Pakuju Tarrukukuju. Maralypikingarduyu-paturlujulpalu kurlumpurrngu jitirninja-yanu kujalpalu wapanja-yanu. ");
INSERT INTO wbp_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Wapanjakungarnti, Jajuwa-jana yapakuju wangkaja yungulu wurdungu-jarrimi pulanja-wangu. Wangkaja-jana, “Wurulypalu wapanja-yanta. Jika-pala-jangka parra-patu-jangka kapurna-nyarra wangkami yungunkulu kilji-nyayirni purlami yungurlipa-jana pinyilki yapa Jiriku-wardingki-patu.” ");
INSERT INTO wbp_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Parra kamparru-warnurla-juku, maralypikingarduyu-paturlulu kanja-yanu Pakuju Tarruku, warru kanja-yanulu kirri Jiriku-wana jintaku. Ngula-jangkalu nyanungurra manu yapa panu-kari pina-yanu ngurra-kurralku. ");
INSERT INTO wbp_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Mungalyurru-kari, kujalpa wanta kankarlu-jarrinja-yanurnu, Jajuwaju yakarra-pardija. Maralypikingarduyu-paturlujulu manu Pakuju Tarrukuju, manulu kanja-yanulku. ");
INSERT INTO wbp_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Yinya wirlki-pala maralypikingarduyu-patu, wapanja-karrarlulpalu-jana kurlumpurrngu jitirninja-yanu. Kamparrulpalu wapanja-yanu Pakuju Tarrukukuju. Ngalya-kari warrmarla-patu kurlarda-kurlu manu kurdiji-kirli, ngulajulpalu wapanja-yanu kamparru maralypikingarduyu-patukuju. Ngalya-kari warrmarla, ngulajulpalu wapanja-yanu purdangirli Pakuju Tarrukukuju. ");
INSERT INTO wbp_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Warrulpalu wapaja Jiriku-wana jintaku-mipa yukanja-wangu, ngula-jangkalu pina-yanu ngurra-kurralku. Yapajulu kuja-jarrija murntu-pala-kariki parra-patuku. ");
INSERT INTO wbp_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Parra-karirla, yakarra-pardijalu mungalyurru-nyayirni kujalpa wanta kankarlu-jarrinja-yanu. Ngulalu kirri-wana wapaja warru wirlki-palaku, kula jintaku-mipa. ");
INSERT INTO wbp_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Kujalu wapanjaku lawa-jarrija wirlki-pala-jangka, ngula-jangka maralypikingarduyu-paturlulu-jana juturnu kurlumpurrngu jintaku kilji-nyayirnirli. Ngula-jangka, Jajuwa-jana purlaja yapa-patuku, “Nyurrurla purlayalu kilji-nyayirni! YAAWIYI-rli-jana yapa nyampurraju rampaku-manu yungurlipa-jana tarnnga-kurra pinyi! ");
INSERT INTO wbp_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Yungurlipa-jana pinyi nyampurraju yapa-patu manu kirri yungurliparla YAAWIYI-kilki warntarri yinyi. Kala yinya karnta Raapa manu nyanungu-nyangu warlalja, ngulajulu-jana yampiya pinja-wangurlu! Nyanungurlunya-palangu yangkaju wati-jarraju wurulypa yirrpurnu Jiriku-kurraju yangka yungu-pala warru nyanyi. ");
INSERT INTO wbp_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Kajinkili kirri wiri yinya-kurra yukamirra, kulalu nyiyarningkijarra manta. Karrimi karla YAAWIYI-ki. Kajinkili-nyanu nyiyarlangu kanyi, manu kajinkili pina-kanyirni nyampu-kurra, ngulaju kapunkulu palimi. Marda ngaliparlangu ngalya-kari Yijirali-pinkirlangu marda kajikarlipa palimi. ");
INSERT INTO wbp_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Nyiyarningkijarra kuja-ka nguna pirli yaltiri-jangka, kawurlu-jangka, yayini-jangka, manu yayirni-piya-jangka, ngulaju karla YAAWIYI-ki nguna. Yungulparliparla mardakarla nyanungu-mipaku.” ");
INSERT INTO wbp_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Kujalu-jana yangka wirlki-palarlu maralypikingarduyu-paturlu juturnu kilji-nyayirnirli kurlumpurrngu, yapajulu kilji-yijala purlaja. Kuja-jangkanya yangkaju kirrirdimpayi pinji-piya, kujalu ngurrju-manu pirli yarturlu-jangka, kujalparla Jirikuku wapirrija, ngulaju muku wantija walya-kurra. Yijirali-pinkijili kapanku parnkaja kirri-kirraju, manulu-jana yapa-patuju muku pungu. ");
INSERT INTO wbp_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Junga kujaju. Mukulu-jana pungu nyiyarningkijarraju. Wati-patulu-jana pungu, karntakarnta, purlkapurlka, manu kurdu jalangu-warnu-patu, manu puluku-wati, manu jiyipi-wati manu tangkiyi-watirlangu. ");
INSERT INTO wbp_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Jajuwa-palangu wangkaja wati-jarraku yangka-jarraku kuja-palangu wurulypa yilyaja Jiriku-kurra, wangkaja-palangu, “Yanta-pala Raapa-kurlangu-kurra yuwarli-kirra, manu-pala muurlparlu kangkarni. Manulu-jana yapa ngalya-karirlangu kangkarni kuja kalu nyanungu-kurlu nyinami. Nyanungunyanpala ngarrurnu yangka kapunpala muurl-mardarni.” ");
INSERT INTO wbp_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Junga-juku-pala wati-jarraju yanu nyanungu-nyangu yuwarli-kirra, manu-pala maninjarla kangu muurlparlu. Kirda-nyanu manu ngamardi-nyanurlangu manu nyanungukupurdangka-patu manu ngalya-kari kujalpalu nyanungurra-kurlu nyinaja, kangu pinalu-jana Yijirali-pinki-kirlangu-kurra ngurra-kurra. Ngulalu-jana yirrarnu ngurra-karirli kutu-juku, warrawarra-kangulpalu-jana. ");
INSERT INTO wbp_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ngula-jangka, Yijirali-pinkirlili purraja kirri Jirikuju, manu nyiyarningkijarra kaninjarni. Kala kulalu purraja nyiyarningkijarra pirli yaltiri-jangka, kawurlu-jangka, yayirni-piya-jangka manu yayini-jangka. Yampijalurla YAAWIYI-ki. ");
INSERT INTO wbp_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Yimi nyampuju junga. Jajuwarlu muurl-mardarnu karnta yangkaju Raapa yangka kuja kala ngunaja wati-kari-kirli talakupurda. Nyanungurluju-jana karnta-kurlangu warlaljarlangu muurl-mardarnu. Karnta yinyarlunya-palangu muurl-mardarnu yangka-jarraju wati-jarra kuja-pala wurulypa yukaja Jiriku-kurra nyiyarningkijarraku nyanjaku. Kujarlanya Jajuwarluju nyanunguju muurl-mardarnu, manu-ka jalanguju nyinami-jiki Yijirali-pinki-kirliji. ");
INSERT INTO wbp_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Ngula-jangka, Jajuwa-jana wangkaja yapa-patuku, “YAAWIYI-rli kaju purda-nyanyi nyarrpa kuja karna wangkami. Kujarlanyajulu purda-nyangka yirriyirrirli! Kaji nganangku-puka nyampu kirri pina-ngantirni puta Jiriku, ngulaju kapu Kaaturlu juyurdurlu yunparni. Ngana-puka kajirla pinji-piya pirli-jangka rdirri-yinyi pina-ngantirninjaku, kapu kaja-nyanu nyanungu-nyangu wiri-jarlu kamparru-warnu palimi. Kaji ngana-puka rdirri-yinyi kiirti kirrirdimpayi pina-ngantirninjaku, ngulaju kapu nyanungu-nyangu kaja-nyanu purdangirli-warnu palimi.” ");
INSERT INTO wbp_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Junga kujaju. YAAWIYI-lpa palka nyinaja Jajuwa-kurlu. Manulpalu yapa panungku milya-pungu Jajuwaju kujalpa nyinaja kaji-nyayirni.… ");
INSERT INTO wbp_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","…Yulyurrpu panuku-jana YAAWIYI-rliji muurl-mardarnu Yijirali-pinkiji nguru Kananarla yapa panu-kujaku yangka ngurra-kari ngurra-kari-wardingki-kijaku. Ngurrjulpalu nyinaja kulu-wangu. Jajuwaju purlkalkulpa nyinaja. ");
INSERT INTO wbp_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Ngula-jana yimi yilyaja ngalya-kariki purlkapurlkaku yangka wiriwiriki kujalpalu-jana warlalja-kari warlalja-kariki nyinaja, manu yangka Yijirali-pinkiki yangka-patu kujalpalu kuwurtukungarduyu wiri nyinaja. Kujalurla yanurnu, nyanunguju-jana wangkaja, “Ngajujurna purlka-pardulku. ");
INSERT INTO wbp_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Milya-pinyi kankulu kuja-ngalpa YAAWIYI-rli muurl-mardarnu yapa-kujaku yangka kuja kalalu-ngalpa nyurunyuru-jarrija. YAAWIYI-rli ngalipa-nyangu Kaaturlu-jana pungu yapa panu-kariji yungurlipa wardinyi nyampurla ngurungka nyinami. ");
INSERT INTO wbp_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Warrardalu manngu-nyangka nyampuju walya kuja-ngalpa YAAWIYI-rli yungu. Jingijingi-ka nguna mangkuru-kurra Mirditirinu-kurra karlarra-purda manu kakarrara-purda karru Jurdunu-kurra. Walya yangka-juku kuja-ngalpa jangku-pungu. Kala yapa panu-karirlangu kalu nyina nyampurlaju. ");
INSERT INTO wbp_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","YAAWIYI-rli ngalipa-nyangu Kaaturlu kapu-jana yinya-patuju jinyijinyi-mani yungulu ngurra yinya-ngurlu yani yungunkulu nyurrurlalku nyinami ngurra yinyarlaju. Kujanya-nyarra wangkaja nyurrurlakuju. ");
INSERT INTO wbp_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“Pirrjirdili nyinaya nyurrurlaju! Yirriyirrirlili-jana puraya nyampurraju kuruwarri-kari kuruwarri-kari kuja-ngalpa YAAWIYI-rli yungu ngalipaku. Yangkarra kuja-ngalpa YAAWIYI-rli yirrarnu pukungka ngalipaku pinarri-maninjaku. Kulalurla yunjumu jurnta nyinaya nyampuku kuruwarriki. ");
INSERT INTO wbp_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Ngalipaju Yijirali-pinki, kala yangka yapa panu-kari kuja kalu nyinami nyampurla walyangka, kula kalu Yijirali-pinki nyina, lawa. Purami kalu nyiyarningkijarra juju tarruku nganta kuja kalu ngurrju-mani pirli-jangka manu watiya-jangka. Kulalu-jana yipilji-jarriya nyanungurraku. Manu kulalu nyanungurra-nyangu tarruku-wati puraya. Kulalu-jana parntarriya nyanungurraku. ");
INSERT INTO wbp_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Nyurrurlarlunkulu warrarda puraja YAAWIYI ngalipa-nyangu Kaatu. Kuja-piyarlu-yijalalu puraya tarnngangku nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“Kujalpankulu-jana yapa-kariki kulu-jarrija, nyanungurrajulpalu pirrjirdi nyinaja nyurrurla-piya-wangu. Kala YAAWIYI-lpa palka nyinaja nyurrurla-kurlu. Kujarlanya, kulankulu-jana jijaja. Nyanungurlu-jana jinyijinyi-manu walya nyampu-ngurlu yaninjaku yungunkulu nyurrurlalku yukami. ");
INSERT INTO wbp_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Yuwayi, YAAWIYI-jilpa palka-juku nyinaja nyurrurla-kurluju, manulpa-nyarra pirrjirdi-manu kulukungarnti. Kujarlunya-nyarra yangkaju kamparru-wiyi ngarrurnu. Kujarlanya, kajili-nyarra marda 1,000-pala warrmarla jangkardu yantarlarni kuluku, ngulaju kapu-jana jinta-miparlu nyurrurla-nyangu-jangkarlu turnu-warnu-jangkarlu pungkarla. ");
INSERT INTO wbp_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Yirriyirrili nyinaya! Warrardalurla yulkaya YAAWIYI-ki ngalipa-nyangu Kaatuku. ");
INSERT INTO wbp_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","13","“Kulalurla jurnta warntarla-jarriya YAAWIYI-ki. Kulalu-jana yipilji-jarriya Yijirali-pinki-wanguku yapa-kariki. Kulalu yupukarra-jarriya nyanungurra-nyangu kaja-nyanu-kurlu manu yurntalpa-nyanu-kurlu, lawa. Kajinkili-jana yipilji-jarrimi, YAAWIYI-rli ngalipa-nyangu Kaaturlu kula-nyarra pirrjirdi-mani kulukuju, lawa. Kula-jana jinyijinyi-mani yapa yinya-patuju ngurra nyampu yampinjaku, lawa. Kapulu-nyarra warrarda kulu-jarrimi. Kapulu-nyarra warrarda murrumurru-mani yangka-piyarlu kuja kanyarra jurdu yuka milpa-kurra. YAAWIYI-rli-nyarra walya nyampuju yungu. Junga. Kala kajinkili-jana yipilji-jarrimi yapa yinya-patuku, ngulaju kapunkulu palimi muku. Kulankulu walya nyampurlaju nyinamilki. ");
INSERT INTO wbp_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Ngajujurna palinjakungarntilki. Milya-pinyi kankulu kuja-nyarra YAAWIYI yimiri nyinaja manu-nyarra nyiyarningkijarra yungu. Nyanungurlu-nyarra nyiyarningkijarra yungu kuja-nyarra jangku-pungu nyurru-wiyi. Kula wajawaja-jarrija witarlangu yinjaku, lawa. ");
INSERT INTO wbp_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","16","YAAWIYI ngalipa-nyangu Kaatu-nyarra wangkaja ngurrju-nyayirni nyurrurlakuju. Yinyarraju junga-jarrija. Majurlangu-nyarra jangku-pungu yangka kulankulu nyangu nyurrurlarlu. Maju nyampurraju kapu-nyarra ngaka rdipimi kajinkilirla jurnta yani nyanunguku. Junga kujaju. Kajinkili wajawaja-mani nyanungu-nyangu kuruwarri, kapu-nyarra riwarri-mani walya nyampurlaju. Kajinkili rdirri-yinyi juju tarruku-wati puranjaku kuja kalu yapa-karirli purami, manu kajinkili-jana parntarrimi nyanungurraku, ngulaju YAAWIYI-rliji kapu-nyarra walya nyampuju jurnta kanyi. Kuja-kujakuju yampiyalu tarruku-kariji, kajika-nyarra YAAWIYI kulu-jarrimi-nyayirni. Kulankulu jintarlangu wankaru nyina nyampurlaju walyangka.” Kujanya-jana Jajuwaju wangkaja yapa-patukuju. ");
INSERT INTO wbp_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Ngaka-pardu-karilki, Jajuwarlu-jana yimi yilyaja yangka 12-pala turnu-kari turnu-kari-jangkaku Yijirali-pinki yungulu jinta-jarrimi Jikimirla. Kujalu yukajarra, turnu-manu-jana purlka-patu manu wiriwiri turnu-kari turnu-kari-jangka, yaninjarlalu karrija kamparru Kaaturla kutu-juku Kaluku Tarruku-wana. ");
INSERT INTO wbp_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Ngula-jangka, Jajuwa-jana wangkaja yapa-patuku, “Nyampunya kanyarra YAAWIYI Yijirali-pinki-kirlangu Kaatuju wangkami nyurrurlakuju: ‘Nyurru-wiyi kalalu nyurrurlakupalangu nyurnunyurnu nyinaja wurnturu kakarrara murrarninginti karru Yupirayitikiji. Jintalpa wati purlka-pardu nyinaja yirdiji Tiira. Nyanungujulpa nyinaja Yipuruyamukupalangu manu Nayurukupalangu. Kalalurla nyurnunyurnuju parntarrija nyiyaku mayi juju tarrukuku kujalu ngurrju-manu pirli-jangka manu watiya-jangka. Kalalu-janarla pulka-pungu. ");
INSERT INTO wbp_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Ngula-jangkajurna kangu wati yinya Yipuruyamu nyanungu-nyangu ngurra-ngurlu wurnturu-nyayirni, manurna kangurnu nyampu-kurra ngurra-kurra Kanana-kurra. Ngula-jangkarnarla nguru-kangu ngurra-kari ngurra-kari-kirra. Yungurnarla kurdu panu-jarlu. Junga kujaju. Kamparrujurnarla yungu kaja-nyanu Yijaki. ");
INSERT INTO wbp_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Ngula-jangkarnarla Yijakikiji kaja-nyanu-jarra jirrama yungu yirdi-jarraju Jakupu manu Yijuwu. Yijuwukujurnarla yungu walya kuja-ka warru karrimi pirli wararra-wana yirdiji Yitama-wana. Kala Jakupu manu nyanungu-nyangu kaja-nyanu-patu-karijili yanu ngurra-kari-kirra Yijipi-kirra. Yinyarla-jukulpalu nyinaja yulyurrpu panuku. ");
INSERT INTO wbp_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Ngula-jangkarna-palangu yilyaja Mujuju manu Yarunu Yijipi-kirra. Ngaju-nyangu yartarnarri-kirlirlirna-jana murrumurru-manu-nyayirni Yijipi-wardingki-patuju yangka yungulu-jana nyurrurlakupalangu nyurnunyurnu yilyami nguru yinya-ngurlu. Ngula-jangkarna-jana kangurnu ngurra yinya-ngurluju. ");
INSERT INTO wbp_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Kujalu nyurrurlakupalangu-purnurlu yampinja-yanu Yijipi, yanurnulu mangkuru-kurra Marna Kirrirdi-kirli-kirra, manulpalu-jana Yijipi-wardingki-paturlu wajirli-pinja-yanu nantuwu-kurlurlu. Ngalya-karirlijilpalu-jana wajirli-pinja-yanu nantuwu-kurlangu wirli-jarra-kurlurlu. Nyurrurlakupalangujulpalu-jana lani-jarrija-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Junga-jukujulu payurnu ngajulku YAAWIYI yungurna-jana muurl-mardarni nganta Yijipi-wardingki-patu-kujaku. Ngajurna-jana kulungku pungu Yijipi-wardingki-patu. Yinya-puruju nyurrurlajulpankulu nyinaja kurdukurdu-wiyi. Kala nyurrurlarlunkulu nyangu nyarrpa-manu kujarna-jana Yijipi-wardingki-patuju. Ngajulurlujurna-jana muru-pungu mangkururla wiringka. Ngula-jangkaju, nyurrurlankulu yanulku, warru wapajalpankulu jiljangka tarnnga-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“‘Ngula-jangkaju, kangurna-nyarra jinta-kari-kirra walya-kurra kujalpalu Yamuri-patu nyinaja. Walya yinyajulpa karrija kakarrara-purda karru Jurdunukuju. Kulukupurda-jarrijalpalu-nyarra jangkardu, kala ngaju-nyangu yartarnarri-kirlirlinkili-jana muku pungu. Ngajulurlurna-jana rampaku-manu-nyayirni yungulu-nyarra warla-pajirninja-wangu nyina. Kujarlunyankulu-jana walya yinyaju jurnta kangu nyanungurra-kujakuju. ");
INSERT INTO wbp_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Ngula-jangka, wati jinta-kari Kingi Palakarlu-jana nyanungu-nyangu warrmarla manu kulukungarnti nyurrurlaku jangkardu. Nyanungujulpa-jana kingi nyina yapa-patuku kujalpalu nyinaja Muwapurla. Manu nyanungukupalangu kirdanaju yirdiji Jipuru. Kulukungarnti yimirla yilyaja wati jinta-kariki yirdikiji Palamaku Piyuruku kaja-nyanuku. Yimirla yilyaja Palamaku yungu-nyarra jangkardu yanirni juyurdu-kurlu. ");
INSERT INTO wbp_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Kala kuja Palama yanurnu, ngajulurlu YAAWIYI-rli ngulajurna jawirdi purda-nyangu payirninja-kurra yangka kujaju payurnu nyurrurlaku juyurdurlu maju-maninjakuju. Junga-juku, ngula-jangkaju, nyanungurluju payurnu yungurna-nyarra ngajulurlu tarnngangku-juku warrawarra-kanyi. Nyanunguju-nyarrarla wangkaja marnkurrpaku. Junga kujaju. Kamparruju yungu nganta-nyarra juyurdurlu-wiyi nganta yunpakarla. Kala ngajulurlurna-nyarra muurl-mardarnu nyanungu-kujakuju. ");
INSERT INTO wbp_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“‘Ngula-jangkaju, nyurrurlajunkulu yanurnu nyampu-kurralku yangka karlarra-purda karru Jurdunukuju. Yanurnunkulu yangka-kurra kirri wiri-kirra Jiriku-kurra. Manu yangka yapa-patu kujalpalu nyinaja yinyarla, kulukupurda-jarrijalpalu-nyarra. Yangka Yamuri-patu, manu Piriji-patu, manu Kanana-wardingki-patu, manu Yititi-patu, manu Kirrkaji-patu, manu Yiipiti-patu, manu Jipuji-patu, ngularrarlulpalu-nyarra putaputa warla-pajurnu nyurrurlaju Kanana-kurra yukanja-kujaku. Kala kujalparna ngajulu nyurrurla-kurlu nyinaja, jijajalu-nyarra nyurrurlakuju. ");
INSERT INTO wbp_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Kujankulu nyurrurla wati-patu yanu yinya ngurra-kari ngurra-kari-kirra kurlarda-kurlu manu kurdiji-kirli, ngajulurlurna-jana yilyaja kuwinyi-piya wiriwiri nyurrurlarla kamparruju. Yinyarrarluju kuwinyi-piya wiriwirirlili-jana yaninjarla yarlkurnu muku yapaju yinyarlaju ngurra-kari ngurra-karirla, ngulalu ngurra nyanungurra-nyanguju yampinja-yanu laningkilki. Kujankulu nyurrurla yukajarra yinya-kurra ngurra-kurra, nyanungurrajulu nyurru-juku yanu! Kujarlunyankulu-jana ngurraju puntarnu kulu-wangurlu-juku. ");
INSERT INTO wbp_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Kula-nyarra nganarlangurlu-puka yungu walya yinyaju. Ngajulurlu YAAWIYI-rlirna-nyarra yungu. Yapa yinyarrarlulu ngurluju yirrarnu pardinjaku. Kala nyurrurlarlunkulu miyi-watiji turnu-manu warru kujalu pardinjarla yirnmi-jarrija. Yapa yinyarrarlulu-jana yuwarli-watiji nganturnu. Kala nyurrurlalku kankulu nyina yinyarrarlaju. Yapa yinyarrarlulu-jana watiya-kari watiya-kariji yirrarnu pardinjakuju yangka miyi-kari miyi-kari-kirliji. Kala nyurrurlarlu kankulu ngarni kuja-ka yirnmi-jarrimilki.’ Kujanya kanyarra YAAWIYI-ji wangkami nyurrurlakuju.” ");
INSERT INTO wbp_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Ngula-jangka, Jajuwa-jana yarda wangkaja yapa-patuku, “Jalangurlunkulu purda-nyangu yimi yangka kuja-nyarra nyarrpa YAAWIYI wangkaja. Jalangurlujulurla pulka-pungka, manulu jungangku puraya. Warrki-jarriyalurla nyanungu-mipaku. Kijakalu-jana yangka nyiyarningkijarra juju tarruku yangka kujalpalu-jana ngalipakupalangu nyurnunyurnu parntarrija yangka kujalpalu-jana ngurrju-manu watiya-jangka manu pirli-jangka. Yinyarra kula kalu-nyarra yimi junga wangkami, lawa. Nyurrurlakupalangu nyurnunyurnu kalalu-jana parntarrija warrarda yangka kuja kalalu nyinaja kakarrara-purda karru Yupirayitikiji. Manu ngalya-kariji kalalu-jana parntarrija yangka kuja kalalu nyinaja Yijipirla. Kala jalangu nyurrurlarlujulu jinta-mipa YAAWIYI puraya! ");
INSERT INTO wbp_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Marda kankulu nyurrurlaju ngalya-kari ngampurrpa nyina yungunkulurla jurnta yani YAAWIYI-ki, manu yungunkulu purami yangka nyiyarningkijarra juju tarruku ngurrju-wangu. Nyarrpa-jarrimilki kapunkulu nyurrurlaju? Nganaku kapunkulurla parntarrimi kamparruju? Marda yungunkulu-jana ngalya-kariji parntarrimi yangkaku juju tarrukuku kujalpalu-jana ngalipakupalangurlu nyurnunyurnurlu puraja nyurru-wiyi yangka kujalpalu nyinaja murrarninginti karru Yupirayitikiji. Marda yungunkulu-jana parntarrimi yangkaku Yamuri-patu-kurlanguku tarruku-watiki yangka-patu kuja kalalu nyinaja nyampurla ngurungka. Ngulaju ngula-juku. Kala ngaju manu ngaju-nyangu warlalja kapurnalurla nyinami YAAWIYI-mipaku. Kapurnalurla nyanungu-mipaku pulka-pinyi.” ");
INSERT INTO wbp_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Ngula-jangka, yapa-patujulurla wangkaja Jajuwakuju, “Lawa! Kularnalu yampimi YAAWIYI-ji. Kapurnalu warrarda purami nyanungu-mipa! Kularnalu-jana parntarrimi nyiyarningkijarra tarrukukuju nganta, lawa! ");
INSERT INTO wbp_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Ngalipa Yijirali-pinkirli karlipa purami YAAWIYI Kaatu. Milya-pinyi karnalu kuja-jana ngalipa-nyangu yapa kangurnu Yijipi-jangkaju. Kalarlipa-jana warrki-jarrija pirijina-piya Yijipi-wardingki-patukuju. Kala YAAWIYI-rli-ngalpa milki-yirrarnu nyanungu-nyangu yartarnarri pirrjirdiji. Kangurnu-ngalpa Yijipi-jangkaju, manu-ngalpa warrawarra-kangu warrarda kujalparlipa ngurra-kari ngurra-kari wurna wapaja. ");
INSERT INTO wbp_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Nyanungujulpa palka-juku nyinaja ngalipa-kurluju. Kujarlanya yangka yapa-patu kujalpalu nyinaja nyampurla ngurrangka, ngulajulu-ngalpa jijaja. Manu YAAWIYI-kirlangu yartarnarri-kirlirlirlipa-jana muku pungu Yamuri-paturlanguju. Yuwayi, ngalipa Yijirali-pinkirli karlipa purami YAAWIYI Kaatu. Kujarlanya, yungurnalurla nganimpaju nyanungu-mipaku tarnnga-juku nyinami.” ");
INSERT INTO wbp_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Ngula-jangka, Jajuwa-jana yarda wangkaja yapa-patukuju, “Kujanya kankulu nyurrurlaju jalanguju wangkami. Kala kulalpankulurla jungarni nyinakarla YAAWIYI-kiji. Nyanunguju tarruku. Nyanungu-ka wangkami yungunkulu nyanungu-mipa manngu-nyanyi. Kajinkilirla nyurrurla jurnta yani, manu kajinkili nyurrurla warntarla nyinami, ngulaju kula-nyarra yawuru-jarrimi. ");
INSERT INTO wbp_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Kajinkilirla jurnta yani nyanunguku, ngulaju kapu-nyarra juyurdurlu yunparni. YAAWIYI-jilpa-nyarra ngurrju nyinaja nyurrurlakuju. Kala kajinkilirla jurnta yani nyanunguku juju-kari-kirra-pinangu, ngulaju kapu-nyarra muku pinyi.” ");
INSERT INTO wbp_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Ngula-jangka, yapa-patujulurla purlaja Jajuwakuju, “Lawa! Kapurnalurla nyinami YAAWIYI-mipaku!” ");
INSERT INTO wbp_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Ngula-jangka, Jajuwa-jana wangkaja nyanungurraku, “Yuwayi, ngurrju kujaju! Nyurrurla kuja kankulu karrimi nyampurla jalangu, nyangkalu-nyanu warru. Wangkajankulu kapunkulurla YAAWIYI-mipaku nyinami. Nyanungu-mipankulu milarnu yungu-nyarra Kaatu nyinami. Ngungkurr-nyinami mayi kankulurla kujakuju?” Ngulalu yalu-manu, “Yuwayi, junga kujaju! Jintakumarrirnirnalu-nyanu purda-nyanjarla rdarr-parnkaja. Yungurnalurla YAAWIYI-mipaku nyinami.” ");
INSERT INTO wbp_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Ngula-jangka, Jajuwa-jana wangkaja nyanungurrakuju, “Yuwayi, ngurrju kujaju! Kajinkilirla kujaku ngungkurr-nyinami-nyayirni, ngula-jangka kijika mukulu-jana yangka juju tarruku nyiyarningkijarra kuja kankulu-jana mardarninja-yani nyurrurla-nyangu ngurrangka yangkarra kujankulu-jana ngurrju-manu watiya-jangka manu pirli-jangka. Kula kalu-nyarra yimi junga wangkami, lawa. Kijika mukulu-jana! Jalangu-jangka, yulkayalurla YAAWIYI-mipaku kurturdurru kanunjumpajumpa tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Ngula-jangka, yapa-patujulurla wangkaja Jajuwaku, “Kapurnalurla nyinami YAAWIYI-mipaku. Kapurnalu YAAWIYI-mipa purda-nyanyi.” ");
INSERT INTO wbp_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Parra jintangka-juku, Jajuwarla wangkaja YAAWIYI-ki nyarrpa kujalurla yapa-patu wangkaja. Nyanunguju wardinyi-jarrija-nyayirni-jana. YAAWIYI-jana yapa-patuku wangkaja yungulu nyanungu-mipa warrarda manngu-nyanyi yangka kujalu ngarrurnu nyanungu-mipaku puranjaku. Nyinajalpalu ngurrangka yirdingkaju Jikimirla. ");
INSERT INTO wbp_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Ngula-jangka, Jajuwarlu-jana yapa-patu-kurlangu yimi-patu yirrarnu puku tarrukurla yangka kujalpa Kaatu-kurlangu kuruwarri ngunaja. Ngula-jangka, yarturlu wiri-jarlu maninjarla juka-yirrarnu kirrirdimpayirla kanunju watiyarla kutu-juku Kaluku Tarrukukuju YAAWIYI-kirlangukuju. ");
INSERT INTO wbp_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Ngula-jangka, Jajuwa-jana wangkaja yapa-patuku, “Nyangkalu nyampu yarturlu kujarna juka-yirrarnu watiyarla kanunju. Kajinkili nyanyi, kapunkulu manngu-nyanyi yangka jalangurlu kujarliparla YAAWIYI-ki wangkaja yangka kapurlipa nyanungu-mipa purami. Yarturlu nyampujulpa karrija nyampurla kujalpa YAAWIYI-ngalpa wangkaja. Kajinkili yarturlu nyampu nyanyi, kujarlanya kulalurla jurnta warntarla-jarrimi YAAWIYI-ki. Manngu-nyanyi kapunkulu warrarda nyarrpa kujarliparla nyanunguku wangkaja jalangu.” ");
INSERT INTO wbp_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Kuja-jana Jajuwarlu yapa jakuru-pungu, ngula-jangka wangkaja-jana ngurra warlalja-kurraku pina-yaninjaku. Jungajukulu yapaju pina-yanu ngurra-kurraju. ");
INSERT INTO wbp_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Ngula-jangka, Jajuwaju palija. Nyanungujulpa purlka-pardu-nyayirni nyinaja, ngulaju palija 110-pala yulyurrpu-jangka. ");
INSERT INTO wbp_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ngula-jangka, yapa-paturlujulu nyanunguju milyingka yirrarnu nguru nyanungu-nyangu warlaljarla yirdingkaju Timinata Jiirarla. Nyampujulpa karrija pirli-paturla yirdingkaju Yipirayimirla yatijarra-purda yangka kirrirdimpayi pirli wararraku yirdikiji Karrjaku. ");
INSERT INTO wbp_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Ngulalpa Jajuwa wankaru-juku nyinaja, Yijirali-pinki-jilpalurla nyinaja YAAWIYI-mipaku. Parntarrijalurla nyanungu-mipaku. Kuja Jajuwa palija, warrardalurla nyinaja YAAWIYI-mipaku, manulpalu-jana warrarda purda-nyangu purlka-patu wangkanja-kurra kujalpalurla warrki-jarrija kamparru-wiyi Jajuwaku. Nyampurraju yangka-patu-juku wiriwiri kujalpalu yinyarla nyinaja kujalpa-jana YAAWIYI-rli warrawarra-kangu Yijirali-pinki. Milya-pungulu kuja-jana muurl-mardarnu yapa-kari-kijaku. ");
INSERT INTO wbp_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Kujalu Yijirali-pinkirlili yampinja-yanu Yijipi, kanja-yanulu Jujupu-kurlangu yungkurnu-wati nyanungurra-kurlu. Pirnkingkalu yirrarnu yangkangka-juku Jikimirla yangka kuja Jakupurlu payi-manu tala-kurlurlu Yamuru-kurlangu kaja-nyanu-jangka. Yamuruju Jikimikipalangu kirdana. Junga kujaju. Jakupurlurla yungu 100-pala jilpa Yamuruku kaja-nyanuku. Ngula-jangkaju, walyajulpa-jana karrija Jujupu-kurlangu kurdukurdukulku. ");
INSERT INTO wbp_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Ngula-jangka, wati yangka maralypikingarduyu Yalijaralku palija. Nyanunguju Yarunuku kaja-nyanu. Nyanungujulu pirnkingka yirrarnu Kipiyarla yangkangka-juku pirli-paturla yirdingkaju Yipirayimirla. Kirri Kipiyajulparla karrija Yalijaraku kaja-nyanuku Piniyajaku. Nganangku mayirla yungu kirriji kamparrurlu-wiyi. ");
INSERT INTO wbp_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","7","... ");
INSERT INTO wbp_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","…Jajuwa, yangka Nuunuku kaja-nyanu kala nyinaja YAAWIYI-kirlangu warrkini. YAAWIYI ngulaju yirdi Kaatu. Kujarla 110-pala yulyurrpu rdipija, ngula walku-jarrija. ");
INSERT INTO wbp_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Ngulalu Yijirali-pinkirli milyingka yirrarnu ngurrangka yirdingkaju Timinata Yirijarla nyanungu-nyangurla ngurrararla. Karrijalpa wararrarla yirdingkaju Yipirayimirla yatijarra wararra-karirla yirdingkaju Karrjarla. ");
INSERT INTO wbp_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Jajuwa manu yangka ngalya-kari purlka-patu, ngulajulu walku-jarrija muku. Nyanungurra-nyangu kurdukurdujulu muku wiri-jarrijalku. Kulalpalu milya-pungu YAAWIYI-ji, manulu wajawaja-manu kuja kala-jana warrarda warrawarra-kangu nyanungurrakupalangu manu warringiyi-nyanurlangu yangka Yijirali-pinki yapa. ");
INSERT INTO wbp_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Ngulalu rdirri-yungu nyiyarningkijarra majuku. Parntarrinjarlalpalu-jana pulka-pungu kujalu ngurrju-manu watiya manu pirli-jangka. Yirdi-manulpalu-jana yinyarraju ‘Paala-kurlangu-patu’. Nyampukungarnti, YAAWIYI-jana wangkaja Yijirali-pinkiki yungulu-jana yinyarraku parntarrinja-wangu nyina. ");
INSERT INTO wbp_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Kamparru-wiyi, YAAWIYI-rli-jana Yijipi-jangka kangu, manu nyanungurrakupalangu-paturlu manu warringiyi-nyanu-paturlu kalalurla nyanungukuju jungangku puranjarla pulka-pungu. Jalangurlujulu yampijalku YAAWIYI-ji, manulu yaninjarla parntarrijalurla yangkarrakulku juju-kariki kujalpa-jana yapa-kariki karrija. Kujarlanya, YAAWIYI-ji-jana kulu-jarrija. ");
INSERT INTO wbp_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Yuwayi, Yijirali-pinkijili jupu-karrija YAAWIYI-ki puranjaku, manulu-jana parntarrija yangka-jarraku jukurrpa juju-jarraku Paalaku manu jinta-kariki yirdi-kari-kiji Yajaraku. ");
INSERT INTO wbp_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","YAAWIYI-jilpa-jana kulu-nyayirni nyinaja Yijirali-pinkikiji. Junga kujalpalu-jana nguru-kari-wardingki-patu jangkardu yanurnu Yijirali-pinkiki walyaku manu jurnarrpaku jurnta kanjaku, YAAWIYI-rli kula-jana warla-pajurnu, lawa. Manu kujalpalu-jana yapa-kari kulu jangkardu yanurnu, YAAWIYI-rli kula-jana warla-pajurnu. Yapa yinya-patu kalalu-jana nyurunyuru-jarrija Yijirali-pinkikiji. Pinjarlalu-jana ngarnu. Yijirali-pinkijili rampaku-jarrija-nyayirni, kulalu-nyanu muurl-mardakarla yapa-kari-kijakuju, lawa. ");
INSERT INTO wbp_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Yangka kujalpalu Yijirali-pinki kulu yanu yangka-patuku kujalpalu-jana nyurunyuru-jarrija, ngulaju kalalu-jana jijaja. Junga kujaju. YAAWIYI kulalpa nyanungurra-kurlu nyinaja, lawa. Nyampukungarnti wangkaja-jana nyanungurrakupalanguku manu warringiyi-nyanuku, “Kajinkili nyurrurla manu nyurrurla-nyangu kurdukurdu warntarla-jarri ngaju-kujaku, manu kajinkili-jana juju-kariki parntarrimi, ngulaju kapulu-nyarra yapa-kari jangkardu yanirni kulu. Kularna-jana ngajulurluju warla-pajirni, kapulu-nyarra riwarri-mani muku.” Junga kujaju, nguruju-jana wuurnpa-jarrija-nyayirni Yijirali-pinkiki. ");
INSERT INTO wbp_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Nyampu-puru, YAAWIYI-rli kala-jana yapa jinta-kari jinta-kari milarnu yungulu-jana wiri-jarlu nyina Yijirali-pinkiki. Yirdi-manu kalalu-jana yinyaju ‘Ngarlkinpa-patu’. Nyampurrarlu wiriwirirli kalalu-jana muurl-mardarnu yapaju yapa-kari-kijaku, yangka kalalu-jana jangkardu yanurnu purukungarntiji. ");
INSERT INTO wbp_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Kala kulalu-jana Yijirali-pinkirli nyampurra Ngarlkinpa-patuju purda-nyangu. Kula kalalu puraja YAAWIYI jungangku, lawa. Karlirr-yanu kalalu nyanungu-kujakuju, manu kalalu puraja juju-karilki. Nyampukungarnti nyurru-wiyi, nyanungurrakupalangurlu manu warringiyi-nyanurlu kalalu yirriyirrirli purda-nyangu YAAWIYI-ji nyarrpa yangka kuja kala-jana wangkaja. Jalangu Yijirali-pinkirli kulalu purda-nyangu, lawa. ");
INSERT INTO wbp_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Japaku-kari japaku-kari kalalu-jana yapa-kari jangkardu yanurnu Yijirali-pinkiki murrumurru-maninjaku. Yangka kuja kalalu murrumurru-jarrija kuja-piya, kalalurla yulanja-karra purlaja YAAWIYI-ki yungu nganta-jana yaninjarla muurl-mardarni yapa-kari-kijaku. Yangka kuja kalalurla purlaja YAAWIYI-ki kuja, ngulaju kala-jana purda-nyanjarla mari-jarrija. Ngula-jangka kala-jana jinta-kari jinta-kari milarnu ngarlkinpa-patu marda wati, marda karnta wiri-jarlu nyinanjaku manu muurl-mardarninjaku yapa-kari-kijaku. YAAWIYI kala palka nyinaja yinyarra-kurlu ngarlkinpa-kurlu, kala-jana pirrjirdi-manu. ");
INSERT INTO wbp_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Yangka kuja kala jinta ngarlkinpa palija, kalalu Yijirali-pinkiji pina majungka-jarrija, kalalu karlirr-yanu YAAWIYI-kijakuju, manu kalalu-jana parntarrija juju-karikilki. Yinyarra juju-kari kulalu junga YAAWIYI-piya. Kuja kalalu Yijirali-pinkiji pina majungka-jarrija, kula nyanungurrakupalangu-piya kuja kalalu jinta-mipa YAAWIYI puraja. Yijirali-pinkiji kalalu langa-pati-nyayirni nyinaja, kula kalalu-nyanu warla-pajurnu maju-kujaku, lawa. ");
INSERT INTO wbp_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Junga-juku, YAAWIYI-jana kulu-jarrija-nyayirni, wangkaja-nyanu, “Ngajulurlurna-jana ngarrurnu nyanungurrakupalangu manu warringiyi-nyanu yangka kapurna-jana warrawarra-kanyi warrarda manu nyanungurra-nyangu kurdukurdurlangu. Jalanguju jupu-karrija jurnta-julu ngajuku puranjakuju, kula kajulu purda-nyanyilki, lawa. ");
INSERT INTO wbp_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","Kujalpa warrkini ngurrju ngaju-nyanu Jajuwa wankaru nyinaja-juku, nyanungurlu manu nyanungu-nyangu warrmarlarlulu-jana pungu muku yapa nguru-kari nguru-kari-wardingki Yijirali-wana. Kala kulalu-jana riwarri-manu muku, lawa. Ngalya-kariji kalu wankaru jalanguju nyina ngurrara-nyanurla. Jalangu-jangka, kajili-jana jangkardu yanirni pinjaku Yijirali-pinkiki, kularna-jana ngajulurlu warla-pajirni murrumurru-maninja-kujakuju. ");
INSERT INTO wbp_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Ngajulurlu kapurna-jana jangkardu yilyami yapa turnu-kari turnu-kari-jangka kuluku Yijirali-pinkiki. Marda kapujulu purda-nyanyilki, marda lawa. Marda kapujulu yirriyirrirli purda-nyanyi kuja kala-julu nyanungurrakupalangurlu purda-nyangu.” Kuja-kula YAAWIYI-ji wangkaja. ");
INSERT INTO wbp_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Junga kujaju. Nyurru-wiyi nyampukungarnti, YAAWIYI-rli kula-jana kapankurlu wajirli-pungu yapaju walya-ngurlu Yijirali-ngirli, lawa. Jajuwa manu nyanungu-nyangu warrmarla, warla-pajurnu-jana yapa-kari yapa-kari-kijaku riwarri-maninja-kujakuju.… ");
INSERT INTO wbp_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","…Wati jinta yirdiji Yuurdu kala ngarlkinpa nyinaja Yijirali-pinkiki ngari witaku-mipa, ngula palijalku. Ngula-jangka, Yijirali-pinkirli majuku rdirri-yungu pina. YAAWIYI-ji kula-jana wardinyi-jarrija kujakuju. ");
INSERT INTO wbp_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","3","Ngula-jangka, wati jinta-kari yirdiji Japini yanurnu nyanungu-nyangu warrmarla-kurlu kulu Yijirali-pinkiki jangkardu. Japinijilpa nyinaja kirri wiringka Yajururla ngurrara Kananarla. Nyanungujulpa kingi nyinaja yapa-patuku yinyarlaju. Wati jinta-kari yirdiji Jijara kala wiri-jarlu nyinaja Japini-kirlangu warrmarlaku. Nyanungujulpa nyinaja ngurrangka yirdingkaju Yarajata-Yakuyimirla. Nyanungurlu manu nyanungu-nyangu warrmarlarlulu-jana mardarnu 900-pala nantuwu-kurlangu wirli-jarra-kurlu yayini-jangka. Kujalu-jana jangkardu yanurnu kulu Yijirali-pinkiki, YAAWIYI-rli kula-jana warla-pajurnu, lawa. Jijajalu-jana Yijirali-pinkiji. Ngula-jangka, 20-pala yulyurrpukulu-jana Japinirli manu nyanungu-nyangu yapangku murrumurru-manu warrarda Yijirali-pinkiji. Kuja-jangka-kulalurla wangkaja YAAWIYI-ki yungu-jana yaninjarla muurl-mardarni Japini-kijaku manu nyanungurra-nyangu yapa-kujaku. ");
INSERT INTO wbp_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Ngurrara yinyarlajulpa karnta nyinaja yirdiji Tipuru. Nyanungujulpa jarukungarduyu nyinaja kuja kalarla marlaja wangkaja YAAWIYI-ki. Nyanunguju Lapita-parnta, manulpa-jana kuwurtukungarduyu-juku nyinaja Tipuruju Yijirali-pinkiki. ");
INSERT INTO wbp_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Kala yamangka wiringka warrarda nyinaja yirdingkaju Tipuru-kurlangu watiyarlaju. Nyampuju ngurra kulkurru-jarra kirri wiri-jarraku Raamaku manu Pijiliki wararra Yipirayimirla. Yangka kuja kalalu-nyanu Yijirali-pinki kulu-jarrija nyiya-ngurlurlanguju, ngula-jangka kalalurla yanu nyanunguku-juku Tipuruku payirninjakuju. Kala-jana purda-nyangu, ngula-jangka kala-jana wangkaja ngana nganta jungarniji ngana majuju. ");
INSERT INTO wbp_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Parra jintangka, yimi yilyajarla watiki yirdikiji Parrakaku yungurla nyanjaku yanirni. Nyanunguju Yapinuyama-kurlangu kaja-nyanu kuja kala nyinaja kirri wiringka yirdingkaju Kitijirla ngurrararla yangka yapa kuja kalalu nyinaja turnu-warnu Napatali-kirlangu. Kuja Parraka yukajarra Tipuru-kurlangu ngurra-kurra, Tipururla wapirdi wangkaja, “YAAWIYI-ji ngulaju-ngalpa Kaatu ngalipaku Yijirali-pinkiki. Nyampu-kula kangku nyanunguju wangkami, ‘Yaninjarla-jana turnu-manta 10,000-pala wati Napatali-kirlangu-jangka manu Jupulunu-kurlangu-jangka turnu-warnu-jarra-jangka, manu-jana nguru-kangka wararra-kurra yirdi-kirraju Tapurru-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Kapurna-jana jinyijinyi-mani Jijara manu nyanungu-nyangu warrmarla, kuja kalu kingi Japini-kirlangu nyina, yungulu yanirni nyarrpararla kuja kankulu nyina. Jijara manu nyanungu-nyangu wati-patu kapulu yanirni nantuwu-kurlangu wirli-jarra-kurlu, kapulu-nyarra wapirdi nyanyi karru Kijanarla. Ngajulu kapurna palka nyina nyuntu manu nyuntu-nyangu wati-patu-kurluju kulu-puruju. Kujarlunya kapunkulu-jana pinyi!’ Kuja-kula kangku YAAWIYI-ji wangkami nyuntukuju.” ");
INSERT INTO wbp_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Ngula-jangka, Parrakarla wangka Tipuruku, “Kajinpa nyuntu yani ngaju-kurlu, ngula-jangka kapurna-jana ngaju-nyangu wati-patu-kurlu jangkardu yani kululku Jijara-kurlangu-patuku. Kala kulanpa yani ngaju-kurlu, ngulaju kularna yani kulukuju, lawa.” ");
INSERT INTO wbp_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Tipururla wangkaja, “Kula lani-jarriya! Ngaju kapurna yani nyuntu-kurlu! Kala kajinkili-jana riwarri-mani Jijara-kurlangu-patu, kulangkurla nganangku pulka-pinyi nyuntuku, lawa. YAAWIYI-rli kapu karnta yilyami Jijara pinjakuju!” Ngula-jangka, Tipuruju pina-yanu wati Parraka-kurluju Kitiji-kirra. ");
INSERT INTO wbp_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Kuja-pala yukajarra yinya-kurra, Parrakarlu-jana yimi yilyaja yapaku Jupulunu-kurlanguku manu Napatali-kirlanguku yungulu jinta-jarri. Yinya-jangka turnu-warnu-jarra-jangka, 10,000-pala watili yanurnu yungulu nyanungu purami kuluku. Tipururlangu yanu nyanungurra-kurlu. ");
INSERT INTO wbp_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Ngurra jinta-karirlalpa yirdingkaju Jaananimirla nyinajalpa wati yirdi Yipiri, Kiniti-jala nyanunguju. (Ngana Kiniti-patuju? Nyanungurraju mukulu palka-jarrija wati-ngirli warringiyi-nyanu-ngurlu yirdi-ngirliji Yupapa-ngurlu yangka kujalpa nyurru-wiyi nyinaja Mujujuku lamparra-nyanu.) Kirri yali Jaananimiji kutu Kitijiki. Kamparru-wiyi, Yipirirliji yampija-jana Kiniti-patu yapa ngurra nyanungurra-nyangurla, manulpa jinta-pardu nyinaja kalukurla. Nyampu kalukujulpa karrija yamangka watiya wiringka yirdingkaju Jaananimirla. ");
INSERT INTO wbp_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Ngula-jangka, nganangku mayi yaninjarla yimi-ngarrurnunjunu Jijaraku yangka Parraka nganta yanu nyanungu-nyangu warrmarla-kurlu wararra-kurra yangka Tapurru-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Jijararluju-jana turnu-manu nyanungu-nyangu warrmarla-patu yangka 900-pala-kurlu nantuwu-kurlangu wirli-jarra-kurlu kujalu ngurrju-manu yayini-jangka. Yanulu muku Yarajata-Yakuyimi-ngirli karru Kijana-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Ngula-jangka, Tipururla wangka Parrakaku, “Yaruju-jarriya! Jalangu YAAWIYI kapu yani nyuntu-kurlu manu nyuntu-nyangu warrmarla-kurlu yungunkulu-jana tarnnga-kurra pinjarla walku-mani Jijara-kurlangu-patu. YAAWIYI kapu kamparru yani nyurrurlarla kulu wirikingarnti.” Junga-juku, Parrakarlu-jana nguru-yirrarnu nyanungu-nyangu 10,000-pala warrmarlaku kaninjarra-kari wararra-ngurluju. ");
INSERT INTO wbp_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","16","Jangkardulkulu-jana parnkaja Jijaraku manu nyanungu-nyangu wati warrmarlaku. Kujalu-jana jangkardu parnkaja, YAAWIYI-rli-jana Jijara manu nyanungu-nyangu warrmarla kawarr-kangu, kawarr-kanja-warnu kulalu nyarrpa-jarriyarla. Jupu-karrinjarla, pina-parnkajalu nantuwu-kurlangurla ngurra Yarajata-Yakuyimi-kirra. Parrakarlu manu nyanungu-nyangu warrmarlulu-jana wajirli-pungu Jijara-kurlangu warrmarla-patu. Pungulu-jana muku junma wiri-kirlirli. Kula ngana wuruly-parnkaja. Jijara-mipa jitinjarla parnkaja wirliyalku. ");
INSERT INTO wbp_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Nyanunguju yanurnu ngurra Jaananimi-kirra kujalpa Yipiri-kirlangu kaluku karrija. Yipiri-kirlangu warlaljalpalu-jana nyinaja kulu-wangu rarralypa Japini-kirlangu-patuku. Japinijilpa-jana kingi nyinaja yapaku Yajuru-wardingki-patuku. Kuja Jijara yukajarra kaluku-kurra Yipiri-kirlangu-kurra, Yipiri kulalpa palka nyinaja. Nyanungu-parnta yirdiji Jaalu-mipalpa palkaju nyinaja. ");
INSERT INTO wbp_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","19","Nyanunguju wilypi-pardija kaluku-jangkaju, manurla wapirdi yanu Jijaraku. Nyanungurla wangkaja, “Warlaljanpa yukayarni ngaju-nyangu kaluku-kurra! Kula lani-jarriya!” Junga-juku, Jijaraju yukaja Jaalu-kurlangu kaluku-kurra, manurla wangkaja, “Ngajujurna purraku! Yungkaju ngapa ngarninjaku.” Junga-juku, Jaalurlurla yungu lampurnu kujalpa yakujurla mardarnu pilikutu-jangkarla. Wita nganjarla ngunanjunulku. Jaalurlurla pangkarra parnta-yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Ngula-jangka, Jijararla wangkaja Jaaluku, “Yaninjarla karriya tuwangka. Kajijili yapangku yaninjarla payirni ngajuku, kula-jana yimi-ngarrika ngajuju kuja karna ngajulu palka nyampurla nyina.” Ngula-jangka, jarda-jarrijalku mata-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Ngula-jangka, Jaalurlu manu watiya yiri-nyayirni manu mutu pirrjirdi. Ngularla wurulypa-nyayirni jangkardu yanurnu kujalpa Jijara ngunaja warnpa-juku, ngula-kurra-juku jurruju walya-kurra rdilypirr-panturnu jingijingi lingirrjingirrji-wana warnpa-kurra tarnnga, ngula palijalku. ");
INSERT INTO wbp_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Ngula-jangka, Parraka yanurra Jaalu-kurlangu kaluku-kurra, ngulalparla warrurnu Jijaraku. Jaalurla wapirdi yanu, manurla wangkaja, “Yantarni kaninjarni kaluku-kurra. Kapurnangku milki-yirrarni wati kuja kanparla warrirni.” Junga-juku, Parrakaju yukajarra kaluku-kurra, yinyarla kujalpa Jijaraju ngunaja nyurnu walyangka watiya-kurlu kujalparla watiyaju pipin-karrija. ");
INSERT INTO wbp_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","24","Kuja Jaalurlu pungu Jijara, parra jintangka-juku Kaaturlu-jana warla-pajurnu Japini-kirlangu warrmarla Yijirali-pinki-kijaku. Japini kala-jana kingi nyinaja Kanana-wardingki-patuku yapaku. Yangka kulu wiri-jangka, Yijirali-pinkijili pirrjirdi-jarrinja-yanu-nyayirni, ngulalu-jana ngakalku Japini manu nyanungu-nyangu warrmarla riwarri-manu muku.… ");
INSERT INTO wbp_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","…YAAWIYI-jana wangkaja Yijirali-pinkiki yangka kamparru-wiyi yangka yungulu maju yampinjarla nyanungu-mipa purami. Jungangku witaku-mipa ngarili nyanunguju puraja. Ngulalu pina majungka-jarrija. Kujarlanya, Mirdiyanu-wardingki-paturlulu-jana Yijirali-pinkiji jangkardu yaninjarla murrumurru-manu 7-pala yulyurrpukuju. Kula-jana YAAWIYI-rli warla-pajurnu. ");
INSERT INTO wbp_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Mirdiyanu-wardingkijilpalu pirrjirdi-nyayirni nyinaja, manu kalalu-jana Yijirali-pinkiji murrumurru-manu warrarda. Laniji kalalu Yijirali-pinkiji parnkaja pirli wararra-kurra ngunanjakuju. Kalalu wuruly-nyinaja pirnkingka manu ngurra panu-karirla yangka Mirdiyanu-wardingki-kijaku. ");
INSERT INTO wbp_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Yijirali-pinkirliji kalalu ngurlu yirrarnu walya-kurra pardinjaku miyiki yangka yulyurrpu-kari yulyurrpu-kari. Kala kalalu-jana Mirdiyanu-wardingki manu Yamaliki-kirlangu-patu manu yapa panu-kari kakarrara-jangka jangkardu yanurnu kulu. ");
INSERT INTO wbp_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","Kalalu yaninjarla ngurrangka Yijirali-pinki-kirlangurla ngunaja kutu. Manu kalalu-jana miyi jurnta maju-manu kujalu-nyanu Yijirali-pinkirli miyi ngurrju-manu ngarninjaku nyanungurraku. Kuja-jarrija warrarda kalalu Yijiralirla manu Kaajarlangurla. Yuwayi, yinya yapa-patu-karirli kalalu-jana miyiji maju-manu jurnta, manu kalalu-jana jiyipi, puluku manu tangkiyi muku pungu. Kulalu nyiyalku Yijirali-pinkirliji nganjarla. ");
INSERT INTO wbp_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Junga kujaju! Mirdiyanu-wardingki-patujulu kutu yaninjarla ngunaja ngurungkaju kujalpa-jana Yijirali-pinkiki karrija. Kangurnulu-nyanu warlalja kaluku-wati, puluku, jiyipi, tangkiyi manu kawartawara manu nyiyarningkijarra nyanungurra-nyangu. Panu-nyayirni nyanungurraju, nyajangu? Karija, jintilyka-piya-wati! Yanulu yinya-kurra walya-kurra nyiyarningkijarra maju-maninjaku. ");
INSERT INTO wbp_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","7","Kujarlanya, kulalpalu Yijirali-pinkirli mardarnu nyiyarningkijarra. Ngulalu yulanjakulku rdirri-yungu, manulpalurla YAAWIYI-kilki wangkaja yungu-jana muurl-mardarni Mirdiyanu-wardingki-patu-kujaku. ");
INSERT INTO wbp_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","Ngula YAAWIYI-rli jarukungarduyu yilyaja Yijirali-pinki-kirra. Jarukungarduyu yinyaju-jana wangkaja nyanungurrakuju, “YAAWIYI-ji-nyarra Kaatu nyurrurlaku Yijirali-pinkiki. Nyampu-kula kanyarra wangkami nyurrurlakuju, ‘Ngajulurlurna-nyarra kangurnu Yijipi-jangkaju ngurra yangka kuja kalalu-nyarra Yijipi-wardingki-paturlu jinyijinyi-manu warrki-jarrinjaku pirijina-piya. ");
INSERT INTO wbp_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Ngajulurlurna-nyarra muurl-mardarnu Yijipi-wardingki-patu-kujaku manu Kanana-wardingki-patu-kujakurlangu. Kapulu-nyarra muku pungkarla. Ngajulurlurna-jana yilyaja Kanana-wardingki-patuju nyanungurra-nyangu nguru-ngurluju. Ngula-jangkarna-nyarra yungu nyurrurlakulku. ");
INSERT INTO wbp_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Ngula-jangkarna-nyarra wangkaja, “Ngajurna YAAWIYI Kaatu kuja kankujulu pura. Nyurrurlaju kankulu nyina walya yinyarla kuja kala-jana karri Yamuri-patuku. Kala kulalu-jana parntarriya yangka jujuku kuja kalu ngurrju-mani pirli manu watiya-jangka. Kulalu-janarla pulka-pungka!” Kala nyurrurlarlu kulankujulu purda-nyangu ngajuju kujarna-nyarra ngarrurnu yampinjaku, lawa. Ngarinkili-jana kutu puraja juju-kari juju-kariji.’” ");
INSERT INTO wbp_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Ngaka-pardu-karilki, YAAWIYI-rli nyanungu-nyangu marramarra yiljajarni walya-kurra. Marramarraju yaninjarla pirri-manu watiya yamangka wiringka ngurrangka yirdingkaju Yupurarla. Watiya yinyajulparla wati jintaku karrija yirdikiji Juwajaku. Nyanunguju Yapiyiju-kurlangu warlalja turnu-warnu-jangka. Juwaja-kurlangu kaja-nyanu yirdiji Kitini. Parra jintangka, Kitinirlilpa kipurnu ngurlu rdaku wiringka yangkangka kuja kalalu pama jurlkulyjurlkuly-katirninjarla ngurrju-manu. Nyanungujulpa wurulypa nyinaja Mirdiyanu-wardingki-patu-kujaku yangka ngurlu kapulurla puntakarla. ");
INSERT INTO wbp_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Ngula-jangka, marramarrarla palka-jarrija Kitinirla. Nyanungurla wangkaja, “Nyuntujunpa pirrjirdi-nyayirni, kulu-parntanpa! YAAWIYI-ka palka nyina nyuntu-kurlu!” ");
INSERT INTO wbp_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Kitinirla wangkaja nyanungukuju, “Junga marda kujaju, kala kajilpa YAAWIYI palka nyinakarla nganimpa Yijirali-pinki-kirli, nyiya-jangkalku kalu-nganpa Mirdiyanu-wardingki-patuju jangkardu yanirni warrarda nyiyarningkijarra jurnta kanjaku? Nganimpakupalangurlu kirda-nyanurlu manu warringiyi-nyanurlu kalalu-nganpa yimi-ngarrurnu nyurru-wiyi nyarrparlu kuja kala-jana YAAWIYI-rli muurl-mardarnu Yijipirla nyanungu-nyangu yartarnarri-kirlirli. Yimi-ngarrurnulu-nganpa nyarrparlu kuja-jana Yijipi-jangka kangurnu. Kala jalanguju yampijalku-nganpa. Kula kajana warla-pajirni Mirdiyanu-wardingki-patuju, lawa. Ngari kalu-nganpa yaninjarla jurnta kanyi muku nyiyarningkijarraju.” ");
INSERT INTO wbp_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Ngula-jangkarla YAAWIYI wangkaja Kitiniki, “Nyuntujunpa pirrjirdi, kapunpa-jana muurl-mardarni Yijirali-pinkikiji yangka-kujaku Mirdiyanu-wardingki-kijaku. Yanta-jana jangkardu kulu. Ngajulurlu karnangku yilyami.” ");
INSERT INTO wbp_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Kala Kitini kularla ngungkurr-nyinaja, “Wurra, YAAWIYI! Nyarrparlurna-jana muurl-mardarni Yijirali-pinkiji Mirdiyanu-wardingki-patu-kujakuju? Kularna ngajuju pirrjirdi. Ngaju-nyangu warlalja Manaja-kurlangu-jangkaju, ngulajurnalu wita-nyayirni turnu-warnu-kari-piya-wangu. Ngaju-nyangu warlaljarlangurla, ngajuju rampaku yapa ngalya-kari-piya-wangu. Kula kajulu purda-nyanyi ngajuju wangkanja-kurraju.” ");
INSERT INTO wbp_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","YAAWIYI-jirla wangkaja Kitiniki, “Ngaju kapurna nyina palka nyuntu-kurlu. Kajinpa-jana kulu jangkardu yani Mirdiyanu-wardingki-patuku, ngula-jangka kapunpa-jana muku riwarri-mani jintawarlayi.” ");
INSERT INTO wbp_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Ngula-jangka, Kitinirla wangkaja YAAWIYI-ki, “Nyarrparlu kapurnangku milya-pinyi wardinyi-japa kanpaju nyina? Nyiya kapunpaju milki-yirrarni yungurnangku milya-pinyi? Marda nyuntuju yapa-kari, kulanpa marda YAAWIYI. Milki-yirrakaju nyiyarlangu yungurnangku milya-pinyi nyuntuju YAAWIYI. ");
INSERT INTO wbp_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Pardakaju nyampurla-juku yungurnangku nyiya mayi maninjini nyuntuku. Pardakaju nyampurla yungurna maninjarla yirrarni nyuntulurla kamparru. Ngula-jangka yungunpaju yampinjarla yanilki.” YAAWIYI-rla wangkaja, “Yuwayi, kapurnangku nyampurla-juku pardarni.” ");
INSERT INTO wbp_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Ngula-jangka, Kitinirli yaninjarla pungu narnukutu wita, manu purraja kartakurla ngapa-kurlurla. Ngamingka purlawa yirrarnu, ngula purraja miyi lalypa. Kuja kuyu yirnmi-jarrija, parrajarla yirrarnu jinta-karirla, ngula kuyu-jangka jupujupu winjurnu parraja-kari-kirra. Ngula-jangka, miyi pina-kangu yangka-kurra kujalpa marramarra nyinaja. Nyinajalpa yamangka watiya wiringka. Kitinirli yaninjarla miyirla yirrarnu kamparru nyanungurla. ");
INSERT INTO wbp_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Ngula-jangka, Kaatu-kurlangu marramarrarla wangkaja Kitiniki, “Yirraka kuyu manu miyi lalypa kankarlu pirli yinyarla. Ngula-jangkarla jupujupulku winjika.” Junga-juku, Kitinirliji yirrarnu kuyu manu mangarri pirlingka, manurla jupujupu winjurnu. ");
INSERT INTO wbp_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","YAAWIYI-kirlangu marramarrajulpa karrija watiya-kurlu, marnpurnu watiya-kurlurlu miyi manu kuyuju, ngula warlu-jarrinjarla jankaja muku miyi manu kuyuju. Ngula-jangka, YAAWIYI-kirlangu marramarraju yawu-pardijalku. ");
INSERT INTO wbp_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Ngula-jangka, Kitinirliji miyiki-nyangulku kulalparla watiki wangkaja, lawa. Milya-pungu kujalparla YAAWIYI-kirlangu marramarraku wangkaja. Nyanungu wangkaja, “Waraa, YAAWIYI Kaatu! Ngajulurlulparna nyuntu-nyangu marramarra nyangu ngaju-nyangu milpa-kurlurlu.” ");
INSERT INTO wbp_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Ngula-jangka, YAAWIYI-rla wangkaja, “Pulya-jarriya! Kula lani-jarriya! Kularnangku pinyi!” ");
INSERT INTO wbp_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Ngula-jangka, Kitinirli pirli-wati turnu-manu yungu-jana yurturlurla yirrarni YAAWIYI-ki pulka-pinjaku. Kitinirli yirdi-manu yinyaju pirli-wati ‘YAAWIYI-rliji Lani-wangu-manu’. Pirli yurturlurla yinyarra, ngulaju jalanguju palka-juku yirdingka Yupurarla. Yinyarla-kula kalu nyina Yapiyiju-kurlangu-patuju. ");
INSERT INTO wbp_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Munga jintangka-juku, YAAWIYI-rla wangkaja Kitiniki, “Yaninjarla manta wirriya puluku nyuntukupalangu-kurlangu kirda-puraji-kirlangu, yangka kuja wirlki-pala yulyurrpuku nyinaja. Yanta yangka-kurra kuja kirda-purajirli pirli yurturlu-kurra yirrarnu pulka-pinjaku Paalaku. Muku-jana yirntika walya-kurra pirliji, manu rdilyki-pajika watiya jukati-piya juka-yirrarninja-warnu ngulaju juju jinta-kari yirdiji Yajura yangka kuja kirda-purajirli ngurrju-manu watiya-jangka manu ngula juka-yirrarnu Paala-kurlangu-wana pirli-wana. ");
INSERT INTO wbp_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Ngula-jangka, turnu-manta-jana pirli wiriwiri, manu yirrakaju yurturlurla ngajuku YAAWIYI-ki nyuntu-nyanguku Kaatuku. Yirraka-jana yurturlurla yirriyirrirli kankarlu nyampurla pirli wararrarla. Ngula-jangka, pulukulku pungka, manu purrayaju kankarlu pirli yurturlurla. Purrayaju watiya-jangka ngulaju juju Yajura-jangka kujanpa nyuntulurlu rdilyki-pajurnu.” ");
INSERT INTO wbp_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Ngula-jangka, Kitinirli-jana karlarla-pala warrkini-patu manu. Munga-pururlu ngurra yinya-kurraju yanu nyanja-kujaku. Kajili yantarla parrangka ngurra yinya-kurra, ngulaju kapulu-jana rdarri-mardarninjarla pakarni Kitini-kirlangu warlaljarlu manu wati panu-karirli ngurra yinya-wardingki-paturlu. Yaninjarlalu pirliji yurnturnu Paala-kurlanguju, manulu rdilyki-pajurnu yangka jukati-piya Yajura-kurlangu. Ngula-jangkalu pirli wiriwiri yirrarnu yurturlurla, ngulalurla pulukulku YAAWIYI-ki purraja. ");
INSERT INTO wbp_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Parrangkalku, wati-patu yinya-wardingki kirri wiri-wardingkili yakarra-pardija, nyangulu pirli yangka Paala-kurlangu, nganangku mayi yurnturnu, manulu jukati-piya Yajura-kurlangu nyangu rdilyki-pajirninja-warnu. Nyangulu nganangku mayi kuja pirli panu-kari yurturlurla yirrarnu, manu kuja puluku purraja kankarlarniji. ");
INSERT INTO wbp_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Ngula-jangka, wangkajalu-nyanu, “Nganangku nyampuju maju-manu?” Ngula-jangka, warrulu yanu warrirninjaku, manulpalu-jana muku payurnu yapa nganangku kuja-jana maralypi jurnta maju-manu. Yapa ngana mayi-jana wangkaja, “Kitinirli Juwaja-kurlangu kaja-nyanurlu maju-manu yinyarraju maralypi.” ");
INSERT INTO wbp_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Ngula-jangkalu yanu Juwaja-kurlangu ngurra-kurra, manulurla wangkaja, “Kangkarni kaja-nyanu nyuntu-nyangu yarlu-kurra! Nyanungurlu muku yurnturnu pirli kujalparla karrija Paalaku, manu rdilyki-pajurnu Yajura-kurlangu kujarnalu juka-yirrarnu kutu yurturlurla. Kujarlanya kapurnalu pinyi nyuntu-nyangu kaja-nyanuju!” ");
INSERT INTO wbp_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Wati yinya-patujulu kulu-nyayirni! Kala Juwaja-jana wangkaja, “Nyurrurlarluju mayi kankulu Paala purami? Nyanunguku mayi kankulurla marlaja wangkami? Nganangku kaji Paala purami, ngulaju kapu palimi jukurra. Pirli yurturlurla yinya, kula nyurrurlaku, lawa! Paala-kurlangu yinyaju! Kajilpa Paala Kaatu-piya nyinakarla, ngulajulpa-nyanu muurl-mardakarla ngaju-nyangu kaja-nyanu-kujaku!” Kuja-kula-jana Juwajaju wangkaja wati-patukuju. ");
INSERT INTO wbp_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Parra jintangka-juku, yapangkulurla Kitiniki yirdi jinta-kari yungu. Nyanungurlu-kula pirli-watiji Paala-kurlanguju yurnturnu muku. Kujarlanyalu yirdi-manu ‘Jurupu-Paala’, ngulaju yirdiji ‘Pangkala-nyanurla Paalarlu Kunka-mani’. ");
INSERT INTO wbp_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Ngaka-pardu-kari, Mirdiyanu-wardingki-patu manu Yamaliki-kirlangu-patu manu panu-kari turnu-kari-warnu-jangka, kujalpalu ngurra-kari ngurra-kari nyinaja kakarrara-kurra, yaninjarlalu jinta-jarrija. Jingijingi-yanulu kakarrara-jangka karlarra-kurra karru Jurdunurla murrarninginti, manulu ngunaja wirri wiringka yirdingkaju Jijirilirla. ");
INSERT INTO wbp_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Ngula-jangka, Kaatu-kurlangu Pirlirrparla kurru-yukaja Kitiniki. Kitinirli wuurnu kurlumpurrngu jitirninja-kurlangu juturnu yungulu Yapiyijiri-paturlu purda-nyanyi, manu yungulu purami kulu-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Kitinirli-jana wati-patu yimi-kirli yilyaja yapaku Manaja-kurlanguku yungulu purami. Yimi-jana yilyaja yapaku Yaaja-kurlanguku manu Jupulunu-kurlanguku manu Napatali-kirlanguku. Wati nyampurrajulu-jana turnu-jarrija Kitini-kirlanguku. ");
INSERT INTO wbp_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Ngula-jangka, Kitinirla wangkaja Kaatuku, “Nyuntulunpaju wangkaja kamparru-wiyi yangka kapunpa-nganpa Yijirali-pinki muurl-mardarni yapa-kari-kijaku. ");
INSERT INTO wbp_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","Yimi nyuntu-nyangu junga mayi? Jalangu mungangka kapurna jiyipi-kirlangu yumurru yirrarni yangkangka kuja karnalu ngurlu kipirni. Jukurra mungalyurru, yakiri-manta yumurruju yinjirlpirli, kala walyaju linji-jiki yampiya. Ngula-jangka kapurna milya-pinyi nyuntu-nyangu yimiji junga. Kapurna milya-pinyi kujanpaju nyuntulurlu yilyaja Yijirali-pinki muurl-mardarninjaku Mirdiyanu-wardingki-patu-kujaku.” Kuja-kularla Kitiniji wangkaja Kaatukuju. ");
INSERT INTO wbp_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Ngula-jangka, Kitinirli yirrarnu jiyipi-kirlangu yumurru walyangka yangkangka ngurrangka. Mungalyurru yakarra-pardinjarla yanu yangkaku yumurruku. Kuja manu, ngula rdaka-kurlurlu kuurn-mardarnu, ngula ngapa panu-nyayirni karlija. Kitinirli parraja-kurra-manu ngapaju. ");
INSERT INTO wbp_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Ngula-jangka, wangkajarla Kaatukulku, “Kulaju kulu-jarriya! Ngari yungurnangku jintakulku wangkami. Ngula-jangka kapurna milya-pinyilki nyuntu-nyangu yimiji junga. Kapurna yarda yirrarni nyampuju jiyipi-kirlangu yumurru walyangka jalangurlu mungangkarlu. Jukurrarlu walyaju yinjirlpi-kirlirli yakiri-manta, kala jiyipi-kirlangu yumurruju linji-jiki mardaka.” ");
INSERT INTO wbp_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Junga kujaju. Mungalyurru, Kaaturlu walyaju yinjirlpi-kirli manu, jiyipi-kirlangu yumurru-mipa linjiji yampija. ");
INSERT INTO wbp_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Mungalyurru, Kitini manu nyanungu-nyangu warrmarla-paturlulu yanu mulju-kurra yirdi-kirraju Yarata-kurra, kutujukulu ngurra ngurrju-manu. Mirdiyanu-wardingki-patujulpalu ngunaja yatijarra wirringka kutu wararrarla yirdingkaju Muurarla. ");
INSERT INTO wbp_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Ngula-jangka, YAAWIYI-rla wangkaja Kitiniki, “Nyuntulurlunpa-jana wati panu-jarlu warrmarlaju kangurnu kulukuju Mirdiyanu-wardingki-patukuju. Ngarinpa-jana ngalya-kari-mipa kangkarlarni. Wati nyampu panu-kurlurlu kajinkili-jana muku pinyi Yijirali-pinkirli Mirdiyanu-wardingki-patu, ngulaju kapunkulu-nyanurla warrarda pulka-pinyi. Ngurrju-wangu kujaju. ");
INSERT INTO wbp_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Yaninjarla wangkaya-jana nyampu-patukuju warrmarla nyuntu-nyangukuju, ‘Kaji ngana lani-jarrimi kuluku Mirdiyanu-wardingki-patu-kujaku, yapa yinyaju yungu ngurra nyampu yampinjarla yanilki ngurra-kurra.’” Ngula-jana Kitini kuja wangkaja Yijirali-pinkiki, 22,000-pala watingkili yampinjarla yanu ngurra yinyaju, manulu nyanungurra-nyangu ngurra-kurra pina-yanu. Kalalpalu 10,000-pala-mipa watiji nyinaja kulukungarntiji. ");
INSERT INTO wbp_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Ngula-jangka, YAAWIYI-rla wangkaja Kitiniki, “Wati panu-juku kanpa-jana mardarni kulukuju. Ngarilpanpa-jana ngalya-kari-mipa mardakarla. Kangka muku-jana mulju-kurra yungunpa-jana miimii-nyanjarla milya-pinyi ngana-patu yungunpa-jana mardarni kulukuju. Kajirnangku ngarrirni ngana yungunpa milarni kulukuju, ngulaju kangka. Kala kajirnangku ngarrirni ngana yilyanjaku ngurra-kurrakuju, ngulaju yilyaya kutu.” ");
INSERT INTO wbp_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Ngula-jangka, Kitinirli-jana nguru-yirrarnu mulju-kurra kujalpa ngapa wilypi-pardija walya-ngurlu. Ngula-jangka, YAAWIYI-rla wangkaja nyanungukuju, “Nyangka-jana jinta-kari jinta-kari kajili ngapa ngarni. Ngalya-karirli kapulu rdakangka yaku-maninjarla yanjirni maliki-piyarlu. Ngulaju-jana yirraka jintangka turnungka. Wati ngalya-karirli kapulu mirdi-jarra yirrarninjarla ngapaju punu-ngarni, kapulu-nyanu yinngirri julyurl-yirrarni ngapa-kurra. Ngulaju-jana turnu jinta-karirla yirraka.” ");
INSERT INTO wbp_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Ngula-jangka, wati yinya-patujulu yanurnu ngapa-kurra ngarninjaku. 300-pala watingkili ngapaju rdaka-kurlurlu yaku-maninjarla yanjurnu maliki-piyarlu. Ngalya-karirlijilpalu parntarrinjarla mirdi-jarra yirrarninjarla punu-ngarnu ngapa, manulu-nyanu yinngirriji julyurl-yirrarnu ngapa-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Ngula-jangka, YAAWIYI-rla wangkaja Kitiniki, “Wati yinya-paturlu, kujalu mirdi-jarra yirrarninjarla ngapa punu-ngarnu, yilyaya pina-jana ngurra-kurra. Kala yinya-patu-karirli, kujalu ngapa yanjurnu rdaka-kurlurlu, ngulaju karna-jana milarni. Kangka-jana nyuntu-kurlu kulu-kurra. Kapurna ngajuju yani nyuntu-kurlu manu 300-pala wati-kirli yungurna-nyarra nyurrurla Yijirali-pinki muurl-mardarni Mirdiyanu-wardingki-patu-kujaku. Kapulu-nyarra jijami nyuntuku manu nyuntu-nyangu wati-patuku.” ");
INSERT INTO wbp_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Ngula-jangka, Kitini-jana wangkaja wati nyanungu-nyangu-patuku, “Nyurrurla 300-pala wati-patu, ngulajulu nyinaya nyampurla-juku ngaju-kurlu. Kala ngalya-kari nyurrurla, ngulajulu pina-yanta ngurra nyurrurla-nyangu-kurra. Kala miyi manu kurlumpurrngu-patu jitirninja-kurlangu-patulu-nganpa yampiyarra nganimpaku.” Ngula-jangkalu wati yinya-patuju pina-yanu ngurra-kurra. Kitini manu wati nyanungu-nyangu 300-pala, ngulajulu ngunaja kankarlu pirlingka. Nyangulpalu-jana Mirdiyanu-wardingki-patu kanunju-kurra kujalpalu ngurrangka nyinaja pirli wararrarla kanunju. ");
INSERT INTO wbp_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Munga jintangka-juku, YAAWIYI-rla yaninjarla wangkaja Kitiniki, “Yakarra-pardiya! Jangkardu yantalu-jana Mirdiyanu-wardingki-patuku! Kapurna-nyarra ngajulurlu pirrjirdi-mani yungunkulu-jana muku pinyi. ");
INSERT INTO wbp_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Kala kajinpa lani-jarrimi-jiki, nyuntu manu wati warrkini nyuntu-nyangu yirdiji Puura, ngulaju-pala kiripi-kangka Mirdiyanu-wardingki-kirlangu ngurra-kurra kajili jarda ngunami-kirra. ");
INSERT INTO wbp_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","Kapunpa-jana purda-nyanyi kuja kalu-nyanu jarnkujarnku wangkami. Kajinpa-jana purda-nyanyi nyarrpa kuja kalu wangkami, ngula-jangka kulanpa lani-jarrimi, kapunkulu-jana jangkardu yani kulu lani-wangu.” Junga-juku, ngula-jangkaju, Kitini manu Puura-pala kiripi-kangu kaninjarra-kari Mirdiyanu-wardingki-patu-kurlangu ngurra-kurra, yanurnu-pala kujalpalu ngalya-kari warrmarla karrija. Yakarralpalu karrija kujalpalu ngalya-kari Mirdiyanu-wardingki-patu jarda ngunaja. ");
INSERT INTO wbp_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Panu-nyayirni Mirdiyanu-wardingki manu Yamaliki-kirlangu-patu manu yapa nguru-kari nguru-kari-jangkalpalu ngurrangkaju ngunaja kanunju pirli wararrarla. Jintilyka-piyalpalu pirlpirl-ngunaja, kulalpa-jana nganangku miimii-nyanjarla ngarrikarla nyajangu mayi nyanungurraju. Manulpalu-jana kawartawara-wati panu-nyayirni mardarnu. ");
INSERT INTO wbp_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Kitinirli-palangu purda-nyangu wati jirrama wangkanja-kurra, yangka kujalpa-pala yakarra karrija ngurraku warrawarra-kanjaku. Jinta-karirla wangkaja, “Mungangkarna jukurr-manu, ngunajalparlipa nyampurla kanunju pirlingka, ngularla yaarl-wantija mangarri kapurdu wita-wangu, ngula paaju-kurlangu kaluku katurnu!” ");
INSERT INTO wbp_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Jinta-kari watirla wangkaja kamparru-warnuku, “Mardanpa Kitini marda jukurr-manu yangka paaju Yijirali-pinkiki. Jukurrpa yinyarla, Kaaturlulpangku yimi-ngarrurnu yangka kapu-jana Kitini manu wati nyanungu-nyangu pirrjirdi-mani. Kapulu-ngalpa kulu jangkardu yanirni, manu kapulu-ngalpa ngalipa Mirdiyanu-wardingki-patu muku pinyi!” ");
INSERT INTO wbp_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Ngula-palangu Kitinirli purda-nyangu wati-jarra wangkanja-kurra, wardinyi-jarrinjarlarla parntarrinjarla pulka-pungu Kaatuku. Ngula-jangka, nyanungu manu Puura-pala pina warrkarninja-yanu kankarlu pirli-kirra, ngula-jana wangkaja nyanungu-nyangu 300-pala watiki, “Yaruju yungurlipa-jana yani! YAAWIYI-rli kapu-ngalpa pirrjirdi-mani yungurlipa-jana muku pinyi Mirdiyanu-wardingki-patu warrmarla!” ");
INSERT INTO wbp_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Ngula-jangka, Kitinirli-jana yirrarnu wati nyanungu-nyangu-patu turnu-kari turnu-kari, 100-pala-kari 100-pala-kari 100-pala-kari. Jarnkujarnku yungu-jana wati-patukuju kurlumpurrngu-patu jitirninja-kurlangu-patu manu wiriwiri murlukunpa-patu walya-jangka rdiliki wuruly-yirrarninjaku. Rdililpa jankaja kaninjarni murlukunpa-paturlaju. ");
INSERT INTO wbp_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","18","Ngula-jangka, Kitini-jana wangkaja wati nyanungu-nyangu-patuku, “Kajirlipa kaninjarra-kari jitinja-yani Mirdiyanu-wardingki-patu-kurlangu-kurra, pirri-yanta mukulu ngurrangka warrukirdikirdi. Ngula-jangka, pardakajulu wurulypa-juku kajirna ngaka ngajulurlu jitirni kurlumpurrngu. Kajinkijili purda-nyanyi jitirninja-kurra jintawarlayirlili nyurrurlarlu jitika, manulu kilji-nyayirni purlaya kuja, ‘Yarujurlu pinyirlipa-jana Mirdiyanu-wardingki-patu YAAWIYI-ki manu Kitiniki!’” ");
INSERT INTO wbp_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Ngula-jangka, Kitini manu wati nyanungu-nyangu-patulu wurdungu-juku jitinja-yanu pirlingka kaninjarra-kari kutu Mirdiyanu-wardingki-patu-kurlangu ngurra-kurra. Wantaju nyurru-juku yukajarra, ngulalpa kulkurru-karilki karrija. Kamparru-warnu-patu Mirdiyanu-wardingki-patu warrmarlalu pina-yanu nyurru-juku jarda-kurra, ngulalpalu ngalya-karilki yakarraju karrija ngurraku warrawarra-kanjaku. Ngula-jangka, Kitinirli manu wati nyanungu-nyangu-paturlulu juturnu, manulu-jana murlukunpa-patu muku puyu-pungu rdili-kirli. ");
INSERT INTO wbp_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Ngalya-kari Kitini-kirlangurlu wati-paturlulu juturnu-yijala yangka jirrama-warnu turnu-jangkarlu kujalpalu jungarni-purdanjirli mardarnu. Ngula-jangkalu-jana murlukunpa puyu-pungu rdili-kirli, ngulalpalu rdiliji mardarnu jampu-purdanjirli rdakangku. Purlajalu muku kilji, “Yarujurlurlipa-jana pinyi Mirdiyanu-wardingki-patu YAAWIYI-ki manu Kitiniki!” ");
INSERT INTO wbp_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","23","Mirdiyanu-wardingki-paturlujulu-jana purda-nyangu Kitini manu nyanungu-nyangu watiji, manulu-jana nyangu karrinja-kurra rdili-kirli ngurrangka warrukirdikirdi. Lanilkilpalu warru purlaja yungulu lani nganta wuruly-parnkayarla. Kala Kitini manu nyanungu-nyangu watijilpalu karrija-juku, manulpalu kurlumpurrngu-piya kiljingki juturnu. Ngula-jangka-jana YAAWIYI-rli kawarr-kangu muku Mirdiyanu-wardingki-patuju, ngulangkuju pungulpalu-nyanu nyanungurlulku warlaljarlu-juku junma-kurlurluju Ngalya-kari yungulu wurulywuruly-parnkayarla. Ngula-jangkaju, Kitiniji-jana purlaja warrmarlaku nyanungu-nyanguku, “Yarururlulu-jana wajirli-pinjarla muku pakaka!”, Ngulalu-jana wajirli-pinja-yanu ngurra Pijijiti-kirra yangka Jararda-kurra-pinangu. Ngulalpalu murnma-juku wurnturu parnkajarra ngurra Yapulu-Muula-kurra, ngulaju kutu Tapajaku. ");
INSERT INTO wbp_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Kitinirli-jana yimi yilyaja warrmarla-patuku kujalpalu nyinaja pirli-paturla yirdingkaju Yipirayimirla. Nyampu-kula-jana Kitiniji wangkaja, “Yantarnili yaruju yungurlipa-jana pinyi Mirdiyanu-wardingki-patu! Yarujulu yanta mulju-kari mulju-kari-kirra manu karru-kari karru-kari-kirra, manulu-jana warrmarla yirraka kajikalu Mirdiyanu-wardingki-patu yani yinya-kurra. Warla-pajikalu-jana kajikalu parnkami Piji-Para-kurra, manu warla-pajikalu-jana kajikalu yani karru Jurdunu-wana murrarninginti.” Kuja-kula-jana Kitinirliji yimiji yilyaja Yijirali-pinkikiji. Jungajukulu warrmarla-patuju kapanku yanu mulju-kari mulju-kari-kirra manu karru-kari karru-kari-kirra yungulu-jana Mirdiyanu-wardingki-patu warla-pajirni ngapa maninja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Ngalya-kari warrmarlalu yanu Kitini-kirli Yipirayimi-wardingki-patuju, ngulalpalu-jana mapirrirli wajirli-pungu Mirdiyanu-wardingki-patuju kakarrara-purda karru Jurdunuku. Ngulalu-jana puuly-mardarnu paaju-jarra yirdi-jarraju Yurupa manu Jipi. Yurupajulu puuly-mardarninjarla pungu pirli wiringka kuja kalu jalangurlu yapangkuju yirdi-mani Pirli Yurupa. Manulu jinta-kari Jipi pungu ngurrangka kutu kuja kalalu kiripi-jangka pama ngurrju-manu jurlkulyjurlkuly-katirninjarla. Yuwayi, warrmarla Yipirayimi-wardingki-paturlulu-jana jurru murul-pakarnu Yurupa manu Jipiji, manulu-palangu jurru-jarraju pina-kangurnu Kitini-kirra, manulurla yungu.… ");
INSERT INTO wbp_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","…Kulu wiri yinya-jangka, Yijirali-pinkilirla wangkaja Kitiniki, “Kitini, nyuntulurlunpa-nganpa muurl-mardarnu Mirdiyanu-wardingki-patu-kujaku! Payirni karnangkulu yungunpa-nganpa wiri-jarlu kingi nyinami. Ngaka kajinpa palimi, ngulaju nyuntu-nyangu kaja-nyanu manu warringiyi-nyanu kapulu-nganpa kingiji nyinami.” ");
INSERT INTO wbp_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Kitini-jana wurra-maninjarla wangkaja, “Lawa, kularna-nyarra kingiji nyinami, manu kula ngaju-nyangu kaja-nyanurlangu. YAAWIYI-mipa wiri-jarluju nyurrurlakuju! ");
INSERT INTO wbp_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Payirni karna-nyarra ngari wita. Yangka kawurlu langa-kurlangu kujankulu-jana warrmarla Yijimali-kirlangu-patuku jurnta kangu kulungka, yungkajulu ngajuku.” (Junga kujaju. Warrmarla yinya-paturluju Yijimali-kirlangu-paturlu kalalu langa-kurlangu kawurlu mardarnu.) ");
INSERT INTO wbp_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Ngula-jangka, Yijirali-pinki warrmarlalurla wangkaja Kitiniki, “Yuwayi, kapurnangkulu yinyi nyampurraju langa-kurlangu.” Ngulalu panja-kurra muku kujurnu langa-kurlanguju. ");
INSERT INTO wbp_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Kawurlu panu-nyayirnilpa ngunaja marda 20-pala kg. Warrmarlarlulu kujurnu muku kawurluju kujalu-jana jurnta yalyi-manu kawartawara-kurlangu waninjaku, ngulalu muku kujurnu rdaka-kurlangu, waninja-kurlangu, langa-kurlangu yangka kuja kalalu Mirdiyanu-wardingki-paturlu kingi-paturlu mardarnu. Kitinirli-jana jurnarrparlangu yali jinajina-piya kirrirdi-piya jurnta kangu Mirdiyanu-wardingki-patu-kurlangu yangka yalyuyalyu kuja kalalu Mirdiyanu-wardingkirli kingi-paturlu mardarnu. ");
INSERT INTO wbp_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Ngula-jangka, Kitiniji kawurlu maninjarla pina-yanu ngurra-kurra nyanungu-nyangu-kurra Yupura-kurra. Yinyarla-jana warrkini-patuku wangkaja yungulu yapa-piya ngurrju-mani kawurlu-jangka. Warrkini-paturlulu ngurrju-manu yapa-piya kawurlu-jangka, manulu yarlungka juka-yirrarnu. Ngula-jangka, Yijirali-pinkilpalurla parntarrija, kulalpalurla wala nyinaja Kaatuku. Kalalurla yinyaku pulka-pungu. Kitini manu nyanungu-nyangu warlaljarlangu kalalurla parntarrija. Jurntalurla nyinayarla puranja-wangu. ");
INSERT INTO wbp_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Mirdiyanu-wardingki-patujulpalu rampaku nyinaja kulu wiri yinya-jangka. Kulalu-jana kulu jangkardu yanurnu Kitini-pinkiki. Ngula-jangka, Kitiniji nyinaja 40-pala yulyurrpuku, ngulalpalu ngurrjulku nyinaja Kitini-kirlangu yapaju. Yinya-puruju kula-jana nganangku kulukukuluku-manu.… ");
INSERT INTO wbp_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","…Yijirali-pinkirlili puraja YAAWIYI-ji witaku-mipa ngari, ngula-jangkalurla karlirr-yanu jurnta lawa, purda-nyanja-wangu. Ngulakuju-jana jangkardu yilyaja Pilijiya-wardingki-patu kuluku nyanungurrakuju, manulpalu-jana wiri nyinaja Yijirali-pinkiki 40-pala yulyurrpuku. ");
INSERT INTO wbp_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Ngula-puru watilpa nyinaja yirdiji Manuwa kirri witangka yirdingkaju Juurarla. Turnu-warnu warlalja-jangka Taanu-kurlangu-jangkalpa nyinaja. Ngulaku kali-nyanulpa nyinaja karntaju kurdu-wangu-juku, lawa-juku. ");
INSERT INTO wbp_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","5","Parra jintangka, YAAWIYI-kirlangu marramarrarla yaninjarla wangkaja karntakuju, “Nyuntunpa kurdu-wangu warrarda nyinaja. Kala kapunpa juni-parnta-jarrimilki. Kapunpa wirriya wita mardarni. Kaji palka-jarrimi, kapurla wiri-jarrinjarla warrki-jarrimi Kaatu-mipaku. Kujarlanya, kula jurruju pajika, lawa! Palka-jarrinjakungarnti, kula pama nganja, manu kula miyi-kari miyi-kari nganja nyarrpa kuja yangka Kaatu wangkaja yampinjaku kuruwarri nyanungu-nyangurla. Kaji kaja-puraji wiri-jarrimi, kapu-jana wiri nyinami Yijirali-pinkikiji, manu kapu-jana rdirri-yinyi muurl-mardarninjaku Pilijiya-wardingki-patu-kujaku.” Kuja-kularla wangkaja marramarraju karntakuju. ");
INSERT INTO wbp_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Ngula-jangka, yaninjarlarla wangkaja kali-nyanu Manuwakuju, “Kaatu-kurlangu jardukungarduyu yanurnu, manuju wangkaja. Kula-ngantarna marramarra nyangu. Lani-jarrija-nyayirnirna, kularna payurnu nyarrpara-jangka kuja yanurnu. Kulaju yirdi yungu. ");
INSERT INTO wbp_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Ngariji wangkaja ngaka nganta kapurna kurdu wirriya mardarni. Kujakungarntiji kulalparna pama manu miyi nganjarla yangka nyiya-puka kuja Kaatu wangkaja yampinjaku kuruwarrirla. Kaji ngalijarra-nyangu kaja-nyanu palka-jarrimi, kaji wankaru-juku nyina, kapurla Kaatu-mipaku warrki-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Ngula-jangka, Manuwarla wangkaja Kaatuku, “YAAWIYI, wati yinya kujarla yaninjarla wangkaja ngaju-parntaku, yilyayarni pina yungu-jarrangku wangka nyarrparlu yungurlijarra ngajarra-nyangu kaja-nyanuju warrawarra-kanyi.” ");
INSERT INTO wbp_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Kaaturlu Manuwaju purda-nyangu kujalparla wangkaja, ngularla marramarraju pina-yanu Manuwa-parntakuju kujalpa nyinaja mata yamangka, ngula-kurranyarla marramarraju yanu. Jintalpa nyinaja Manuwa-wangu. ");
INSERT INTO wbp_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Ngula-jangkaju, karntaju yanurnu pina ngurra-kurra, ngularla wangkajalku Manuwakuju nyanungu-parntakuju kali-nyanukuju, “Yuwa! Wati yangka-juku yaninjarla rdipijaju, yangka kujarna kamparru-wiyi nyangu, ngula-juku yangka-juku rdipijaju.” ");
INSERT INTO wbp_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Ngula-jangkaju, wungulku-pala wati manu karnta pina-yanu yangka-kurraju yurruju-kurra, ngulangka kujarla wati rdipinjarla wangkaja yangka karntakuju. Ngula Manuwarlu wati yinyaju payurnu, “Nyuntu-kula mayinparla ngaju-parntakuju wangkaja?” Ngula yalu-manu, “Yuwayi, ngaju-kula.” ");
INSERT INTO wbp_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Ngula-jangka, Manuwarla wangkaja, “Nyuntulu-kulanparla mayi wangkaja ngaju-parntakuju kapu nganta wirriya mardarni? Kaji palka-jarrimi, kuruwarri nyiya kapu purami? Nyiya-piyarla kapu warrki-jarrimi?” ");
INSERT INTO wbp_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","YAAWIYI-kirlangurlu marramarrarlu yalu-manu Manuwaju, “Nyurrurnarla wangkaja yungu yirriyirrirli yimi ngaju-nyangu purami kaja-nyanurlu. ");
INSERT INTO wbp_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Kurdu yalikiji palka-jarrinjakungarntikiji, ngati-nyanurluju kula ngarni marnikiji-piya, manu kula pama ngarni. Manu miyi yungu yampimi nyarrpa-puka kuja Kaatu wangkaja yampinjaku kuruwarri nyanungu-nyangurla yungulu yapa ngarninja-wangu nyinami. Kuja-kularnarla wangkaja.” ");
INSERT INTO wbp_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","Ngula-jangka, Manuwarlu jangku-manu, “Ngula-juku, ngurrju kujaju. Nyinami mayinpa ngajarra-kurlu jalanguju yungurnangku narnukutu wita pinjarla yinyi ngarninjaku?” ");
INSERT INTO wbp_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","Manuwarluju kula milya-pungu kujalparla marramarraku wangkaja kujarla YAAWIYI-rli yilyaja. Kula-ngantalparla wati-nyayirniki wangkaja. Ngula-jangka, marramarrarla wangkaja, “Yuwayi, kapurnangkupala jirrnganja nyinami witaku ngari. Kala kularna miyiji ngarni. Kala ngampurrparluju kajikanpa narnukutu pinyi yungunparla pirli lalypangka purrami YAAWIYI-ki. Kajinpa kuja-jarrimi, kapungku wardinyi-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Ngula-jangka, Manuwarla wangkaja, “Ngarrikaju yirdi nyuntu-nyangu. Ngula-jangka, kaji ngajarra-nyangu kaja palka-jarrimi, yungurnangkulu pulka-pinyi.” ");
INSERT INTO wbp_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Ngula-jangka, marramarrarla wangkaja, “Lawa, nyiyakulpanpaju milya-pungkarla yirdiji? Lawa, tarruku!” ");
INSERT INTO wbp_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Ngula-jangka, Manuwaju yanu narnukutuku manu ngurlu-watiki Ngula kangurnu pirli lalypa-kurra kuja milarnu kamparru-wiyi. Ngula warlu yarrpurnu kankarlu pirlingka. Ngula narnukutu pungu, ngularla purraja ngurlu-wati-kirli YAAWIYI-ki. Ngula-jangkaju, kinyirr-ngarninjarla purlajarla nyanungu-parntakuju karntakuju, “Nyampu nyangka!” ");
INSERT INTO wbp_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","Kala warlujulpa jankaja kankarlarra-kari yalkiri-kirra. Ngula YAAWIYI-kirlangu marramarra yanu kankarlarra warlu yinyarlaju. Manuwarlu manu nyanungu-parntarlu-pala nyangu kankarlarra-kurra yaninjarra-kurra. Ngula-palarla walya-kurralku parntarrinjunu. ");
INSERT INTO wbp_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Junga, marramarra yinyaju yanu, ngula-pala Manuwarlu manu nyanungu-parntarlu miyiki-nyangulku nyanunguju YAAWIYI-kirlangu marramarraju. ");
INSERT INTO wbp_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Manuwarla wangkaja nyanungu-parntaku, “Waraa! Nyangurlu marramarra, kapurlu palimilki!” ");
INSERT INTO wbp_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Manuwa-parntarla wangkaja, “Lawa! YAAWIYI-rli kangu kuyu manu ngurlu kujarlurla purraja warlungka. Wardinyi-jarrijalku-ngalingki kujakuju. Manu kujalparlu nyangu marramarra kankarlarra yaninja-kurra warlungka, YAAWIYI-rli kula-ngalingki warla-pajurnu, lawa. Manu yangka kamparru-wiyi-ngali wangkaja ngaka kapurlu wirriya kurdu nganta mardarni.” ");
INSERT INTO wbp_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Ngaka-pardu-kari, Manuwa-parntarlu wirriya kurdu wita mardarnu, ngula yirdi-manu Jamijini. Ngulalpa wirriya yinya wiri-jarrinja-yanu, YAAWIYI-rli warrawarra-kanjarla pirrjirdi mardarnu. ");
INSERT INTO wbp_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Ngakalku kujalpa Jamijini watilki nyinaja, nyinajalpa ngurrangka yirdingkaju Maana-Taanurla. Nyampuju kulkurrurni kirri-jarrarla Juurarla manu Yijitulurla. Yinya-puru kalarla YAAWIYI-kirlangu Pirlirrpa yanurnu Jamijini-kirra, manu kalarla kurru-yukaja, ngulangkuju kala nyarrpa-jarrinjaku yimi-ngarrurnu. ");
INSERT INTO wbp_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Ngaka-pardu-kari, Jamijiniji yanu kirri-kari-kirra yirdi-kirraju Timina-kurra. Yinyarla-kula karntaju nyangu Pilijiya-wardingkiji. ");
INSERT INTO wbp_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Ngula pina-yanu ngurra-kurra, wangkaja-palangu ngati-nyanuku manu kirda-nyanuku, “Ngajulurna karnta nyangu Pilijiya-wardingki Timinarla, yungurna yupukarra-jarri. Maninjintaju-pala!” ");
INSERT INTO wbp_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Nyanungukupalangu-jarrarlu-pala yalu-manu, “Lawa! Karnta nyampurlaju panu-jarlu ngalipa-nyangu warlalja turnu-warnu-jangka, manu Yijirali-pinkirlangu. Yapa yinya Pilijiya-wardingki-paturlu, kula kalu Kaatuju purami. Nyiyakunparla yupukarra-jarrimi yalikiji karntaku yapa-kari-jangkaku?” Jamijini-palangu wangkaja, “Yuntardi-nyayirni yinyaju. Maninjintaju-pala!” ");
INSERT INTO wbp_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Jamijinikipalangu-jarrarlu, kulalpa-pala nyarrparlu manngu-nyangkarla kujalparla warrarda payurnu karnta yinyaku. Yinya-puruju, yapa Pilijiya-wardingkijilpalu-jana wiri nyinaja yapaku Yijirali-pinkiki. YAAWIYI-rli yungu-jana kulu ngurrju-mantarla yapaku Pilijiya-wardingki-patuku. Kujarlanyarla Jamijinikiji wangkaja yungurla karnta yinyaku payirni. ");
INSERT INTO wbp_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Ngula-jangka, Jamijini manu nyanungukupalangu-jarralu yanu Timina-kurra. Kujalu kutu-jarrija, yanurnulu ngurra-kurra kujalpa marnikiji-piya pardija, ngularla ngaya-piya wiri-jarlu jangkardu juurl-pungu Jamijiniki nguurr-karrinja-karra. ");
INSERT INTO wbp_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Kala YAAWIYI-kirlangu Pirlirrparla kapanku kurru-yukaja Jamijinikiji, ngula pirrjirdi-manu. Rdaka-jarrarluju larra-pungu yinyaju ngaya-piya wiri-jarlu kula-nganta narnukutu wita-juku. Jamijinikipalangu-jarrarlu kula-pala kuja-kurra nyangu, manu kula-palangu warnkiri-manu. ");
INSERT INTO wbp_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Ngula-jangkaju, Jamijiniji yukajarralku Timina-kurralku. Karnta yinyakurla wangkaja, ngula wardinyi-manulku karntangkuju. Ngula-jangka, pina-yanu ngurra-kurralku. ");
INSERT INTO wbp_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Ngaka-pardu-kari, Jamijiniji pina-yanu Timina-kurra yungu karnta-kurlu yupukarra-jarrimilki. Jingijingi-yanu yirdiyi yangka-wana kujarla ngaya-piya wiri-jarlu jangkardu juurl-pungu. Manngu-nyangulpa, “Marda-ka ngaya-piya wiri-jarlu-kurlangu palkaju ngunami-jiki.” Ngula nyangu, ngari nyangu yungkurnu-mipa. Yungkurnu yinyarla munikilpalu nyinaja, manu ngarlu panu-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Ngulajulpa turla-maninjarla ngarninja-yanu wapanja-karrarlu-juku ngarluju. Ngula nyanungukupalangu-kurlangu-kurra ngurra-kurra yukajarra, yungu-palangu ngarlu ngarninjaku. Kula-palangu yimi-ngarrurnu kuja ngarlu manu ngaya wiri-jarlu-piya-kurlangu yungkurnurla. ");
INSERT INTO wbp_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Ngula-jangka, Jamijiniki kirda-nyanu yanu Timina-kurra yungu yurdujurra-mani kaja-nyanu yupukarra-jarrinjaku. Jamijinirlangu yanu, manu kuyu manu miyi purraja kurapaka wiriki. (Nyurru-wiyi yupukarra-jarrinjarla yapangkuju kalalu kurapaka wiri ngarnu.) ");
INSERT INTO wbp_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Ngulalu Pilijiya-wardingki-paturlu nyangu Jamijini kuja-kurra, wangkajalu-jana 30-pala wati-patuku yungulu ngarni Jamijini-kirliki kurapakarla. ");
INSERT INTO wbp_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Ngarnulpalu mapirrirli. Ngula-jangka, Jamijini-jana wangkaja 30-pala wati-patu yinyaku, “Kapurlipa miyi manu kuyu nyampuju ngarni wirlki-pala parraku. Wita yirna-nyarra payirni manyungku ngari. Kajinkijili yalu-mani jungarnirli, kapurna-nyarra yinyi 30-pala jaati manu 30-pala wawarda. ");
INSERT INTO wbp_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Kala kulankujulu yalu-mani, ngulajujulu yungka 30-pala wawarda manu 30-pala jaati.” Wati yinya-patu Pilijiya-wardingki-patulurla wangkaja, “Yuwayi, payika-nganpa manyungku.” ");
INSERT INTO wbp_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Ngula-jangka, Jamijini-jana wangkaja, “Ngajulurlurna nyangu nyiya mayi yangka kala pirrjirdi-nyayirni nyinaja. Jalanguju ngakurru-nyayirnilki ngarlu-piya. Nyiyarna nyangu?” Marnkurrpaku parrakulu jata-nyangu nyarrparlu yungulu yalu-mani Jamijiniji. ");
INSERT INTO wbp_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Ngula-jangka, parra-karirla, yaninjarlalurla wangkaja karnta yangkaku kujalparla Jamijiniki nyinaja, “Yuwa! Ngari mayinpa-nganpa yajarnu kurapaka-kurraju yungunpa-nganpa jurnta kanyi nyiyarningkijarra? Yulyurlku-yungka kali-puraji yungungku ngarrirni nyiya yinyaju yimi wita. Kulanpa payirni, ngulaju kapurnangkulu nyuntu manu nyuntu-nyangu warlalja warlungka purrami!” ");
INSERT INTO wbp_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Ngula-jangka, Jamijini-parntaju yaninjarla yulaja kamparru nyanungurla, ngularla wangkaja, “Wiyarrpa ngajulu! Marda kula kanpaju yulkami! Nyuntulurlunpa-jana yinya 30-pala wati payurnu nyiya kujanpa nyangu, ngari kanpa-jana manyu-pinyi. Kajinpaju yulkami-nyayirni, yimi-ngarrikaju nyiya kujanpa nyangu!” Jamijinirla wangkaja, “Lawa! Kularna-palangu yimi-ngarrurnu ngajukupalangu-jarrarlangu! Nyiyakulparnangku nyuntu-kuju yimi-ngarrikarla?” ");
INSERT INTO wbp_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Junga kujaju. Jamijini-parntaju warrarda yulaja kurapaka-puru. Jinyijinyi-manulpa Jamijini yungurla ngarrirni nyiya kuja nyangu. Ngula kurapaka lawa-jarrijalku, ngula-jangkarlu karntangkuju mata-manu yulanjarlu-juku. Ngula yimi-ngarrurnu kuja nyangu ngaya-piya wiri-jarlu-kurlangu palka ngarlu-kurlu. Ngula-jangka yaninjarla-jana yimi-ngarrurnu 30-palaku wati-patuku. ");
INSERT INTO wbp_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Wanta yukanjakungarnti, wati-patu ngurra yinya-ngurlu yaninjarlalurla wangkaja Jamijiniki, “Milya-pinyi karnalu kujanpa nyiya nyangu. Ngaya wiri-jarlu-piyanpa nyangu! Ngana kula pirrjirdiji ngaya wiri-jarlu-piyaju! Nyiya kula ngakurruju ngarlu-piyaju!” Jamijinirli-jana yalu-manu, “Mardankulu ngaju-parnta payurnu! Kuja-wangurlunkulu yampiyarla payirninja-wangurlu!” ");
INSERT INTO wbp_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Ngula-jangka, YAAWIYI-kirlangu Pirlirrparla kapanku kurru-yukaja Jamijinikiji, ngula pirrjirdi-jarrija-nyayirni. Yanu ngurra-kari-kirra Yajakalana-kurra. Yinyarla-jana pungu 30-pala wati, manu-jana jurnarrpa larra-pungu jurnta. Kanjarla-jana yungu Pilijiya-wardingki-patuku. Ngula kulu-nyayirnirli ngurra yinyaju yampinjarla pina-yanu nyanungukupalangu-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Ngula-jangka, karnta yinyakupalangurlu-palarla yungu nyanunguju karnta wati jinta-karikilki yangka kujalpa Jamijini-kirlirli kurapaka ngarnu. ");
INSERT INTO wbp_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Ngaka-pardu-karilki, yapa yinyarla ngurrangkarlulpalu ngurlu warru manu yirnmilki. Ngula Jamijiniji pina-yanu ngurra yangka Timina-kurra karnta yangka nyanjaku. Rampal-manngu-nyangu kula-ngantarla karnta yinyaju nyanunguku-juku kali-nyanu. Payi-manu narnukutu wita yungurla yinyi karntakupalanguku kirda-nyanuku. Yaninjarla wangkajarla nyanungukuju, “Yungurna yukami kaninjarni kalukurla yungurna ngunami ngaju-parnta-kurlu.” Karntakupalangujurla wangkaja Jamijinikiji, “Lawa, kulalpanpa ngunayarla nyanungu-kurluju. ");
INSERT INTO wbp_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Nyuntujunpa kulu yanu ngurra nyampu-ngurluju. Kula-ngantalpanparla nyurunyuru-jarrija ngaju-nyangu yurntalu-nyanukuju! Ngula-jangka-kularnarla yupukarraju yungu wati jinta-kariki kuja ngarnu nyuntu-kurlurlu kurapaka wiringka. Kala wajampa-wangu nyinaya! Nyampu-kula nyanungu-nyangu ngawurru-nyanuju. Nyampuju yuntardi-jiki yangkakuju kujanpa yampinja-yanu purdangirli. Kapurnangku ngajulurlu yupukarra yinyi!” ");
INSERT INTO wbp_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Kala Jamijini wangkaja-nyanu, “Jalangurluju yapa nyampu Pilijiya-wardingki-patuku karna-jana kululku nyinami! Kajilparna-jana murrumurru-mantarla jalangurlu, kulalpaju nganangku maju-pajikarla!” ");
INSERT INTO wbp_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Ngula-jangka, Jamijinirli yaninjarla manu-jana 300-pala witawita maliki-piya. Jirrama-kari jirrama-kari-jana wipingka warurnu pijiji-kirlirli jara-jangka-kurlurlu yingkirninjakungarntirli. ");
INSERT INTO wbp_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Ngula-jangka-jana kangu maliki-watiji ngurra yangka-kurra kujalpalu ngurlu-wati yirnmi-jarrija. Ngula-jana rdurlungu pijijiji warlu-kurlurlu yangkaju maliki-patu-kurlangurla wipingka, ngula-kurluju-jana yilyajalku. Parnkajalkulpalu warru lanilki, manulpalu pijijiji warru rarra-kangu jarra-kurluju. Ngula-jangkarluju pijiji-jangkarluju warlulkulpa rdurl-ngarnu warru. Ngulangkuju ngurluju muku jankaja. Yangka watiya kujalpalu-jana Pilijiya-wardingki-paturlu mardarnu marnikiji-piya-kurlu manu miyi-kari yalipiji-kirli, ngulajulu jankaja jintawarlayi-jiki. ");
INSERT INTO wbp_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Ngula-jangka yapangku Pilijiya-wardingki-paturlulu-nyanu jarnkujarnku payurnu, “Yuwa! Nganangku-ngalpa miyiji jurnta yungkurnu muku?” Nganangku mayi-jana yimi-ngarrurnu, “Jamijinirli-waja purraja! Nyanungu-kula kapu yupukarra-jarriyarla karnta Timina-wardingki-kirli, kala kirda-nyanurlurla yungu wati-kariki.” Junga-juku, wiriwiri Pilijiya-wardingki-patulu yanu Timina-kurra, ngulalu-jana karnta manu nyanungu-nyangu kirdana warlungka purraja tarnnga-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Jamijinirli purda-nyangu yimi kujalu-jana karnta manu nyanunguku kirda-nyanu pungu, ngula-jana yaninjarla wangkaja wiriwiriki Pilijiya-wardingki-patuku, “Pungunkulu-jana ngaju-parnta manu ngajuku lamparra. Jardakungarntirliji kapurna-nyarra muku pinyi!” Ngula-jana Jamijinirliji pajurnu muku junma kirrirdi-kirlirli. ");
INSERT INTO wbp_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Ngula-jangka, yaninjarla ngunaja pirnkingka kujalpa karrija kankarlu pirli wiringka yirdingkaju Yiitamarla. ");
INSERT INTO wbp_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Wiyiki-patu-kari-jangka, panu-jarlu-nyayirni warrmarla Pilijiya-wardingki-patu yanurnulu nguru Juurda-kurra, ngulajulu ngunaja ngurrangka yirdingkaju Liiyayirla kulukungarnti. ");
INSERT INTO wbp_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Wati-patu Juurda-wardingki-paturlulu-jana yaninjarla payurnu, “Nyiyakunkulu nyurrurlaju yanurnu ngurra-kurra nganimpa-nyangu-kurra? Kulukungarnti mayinkili-nganpa jangkardu yanurnu?” Warrmarla Pilijiya-wardingki-patulu-jana wangkaja, “Lawa, ngarirnalurla yanurnu wati yangkaku Jamijiniki. Yapa-jana nganimpa-nyangu muku pungu. Jalangurluju nyanungulku karnalu pinyi!” ");
INSERT INTO wbp_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Ngula-jangka, 3,000-pala watili Juurda-wardingki yanu pirnki yangka-kurra kujalpa Jamijini nyinaja. Rdipinjarlalu palka-manu pirlingka kankarlu Yiitamarla, ngulalurla wangkaja, “Nyiya-jangkanpa-jana pungu yinyaju Pilijiya-wardingki-patu? Yinyarraju ngalipa-nyangu wiriwiri. Jalangujulu yanurnu ngalipa-nyangu ngurra-kurralku, manu kapulu-ngalpa muku pinyi!” Jamijinirli-jana yalu-manu, “Ngajuku-wiyijili jangkardu yanurnu kamparruju. Ngula-jangkarlunya yungurnajurla ngajulurluju kunka-mani pina.” ");
INSERT INTO wbp_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Ngula-jangka, wati Juurda-wardingkilirla wangkaja nyanungukuju, “Yuwayi. Jalangurluju karnangkulu warirninjarla kanyi warrmarla Pilijiya-wardingki-kirra.” Jamijini-jana wangkaja, “Ngulaju ngula-juku. Kularna-nyarra warla-pajirni kuja-kujakuju. Kala ngarrika-wiyijili yangka kulankujulu ngaju murrumurru-mani.” ");
INSERT INTO wbp_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Wangkajalurla, “Lawa, kularnangkulu pinyi. Ngari kapurnangkulu warirni-mipa yungurnangkulu pina-kanyi yinyarra-kurra.” Ngula-jangkalu-palangu manu ngalyipi-piya pirrjirdi-jarra jirrama, ngulalu Jamijini-kirlangu rdaka-jarra warurnu. Ngula-jangkalurla nguru-yirrarnu pirnki Yiitama-ngurluju. ");
INSERT INTO wbp_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Pinalu kangurnu ngurra yangka-kurra Liiyayi-kirra, ngulalu warrmarla Pilijiya-wardingki-paturlu Jamijini nyangu warirninja-warnu. Kilji-nyayirnili purlaja, ngulalurla parnkaja. Ngula-jangka, YAAWIYI-kirlangu Pirlirrparla kurru-yukaja kapanku Jamijinikiji, ngula pirrjirdi-manu. Jamijinirli-palangu ngalyipi-piya yinya-jarra turl-pungu pipa-piya. ");
INSERT INTO wbp_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Warru nyangu, ngula nyangu tangkiyi-kirlangu yungkurnu lirra-jangka walyangka ngunanja-kurra. Palka-kurlu-jukulpa ngunaja yilara-kurlu-juku. Maninjarla ngula-kurlurlujulpa-jana kapankapankurlu pakarnu warrmarla-patuju, ngulaju-jana 1,000-pala wati muku pakarnu tarnnga-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Ngula-jangka, yunparnulkulpa kujarlu, “Ngajulurlurna-jana 1,000-pala wati pakarnu tangkiyi-kirlangu yungkurnu-kurlurlu! Pakarnulparna-jana nyurnu-kurra tarnnga-kurra!” Kuja-kulalpa yunparnu. ");
INSERT INTO wbp_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Ngula-jangka, Jamijinirli yungkurnu lirra-jangka yinyaju kujurnu yinyarla-juku. Ngula ngurra yinyaju yirdi-manu ‘Raamaaja-Layu’. ");
INSERT INTO wbp_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Jamijinijilpa purraku-nyayirnilki nyinaja, ngularla YAAWIYI-ki wangkaja, “Nyuntulurlunpaju pirrjirdi-manu warrmarla nyampu Pilijiya-wardingki-patu pinjaku. Kala kajikarna jalanguju palimilki ngapa-wangu. Kajilparna paliyarla nyampurla, yapangku Pilijiya-wardingki-paturlu kajikalu yaninjarla palka ngaju-nyangu kanyi. Kula kalu nyuntu-nyangu kuruwarri purami.” ");
INSERT INTO wbp_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Yuwayi, Jamijinijilpa matalku manu purraku-nyayirni nyinaja. Ngula Kaaturluju rdilypirr-yungu pirlingkaju, ngula-ngurlu ngapa panu-nyayirni yarnkaja. Kuja Jamijinirli ngarnu, ngula pina pirrjirdi-jarrija. Ngurra yinyaju yirdi-manu ‘Yinkayuri’. Jalangu ngurra yinyaju-ka palka-juku karrimi kutu yangka ngurra-kari Liiyayiki. ");
INSERT INTO wbp_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Ngula-jangka, Jamijinilpa-jana wiri-jarlu ngarlkinpa nyinaja Yijirali-pinki yapaku 20-pala yulyurrpuku. Kala yapa Pilijiya-wardingki, wiri-jukulpalu-jana nyinaja-yijala nyanungurrakuju, manu kalalu-jana warrarda murrumurru-manu. ");
INSERT INTO wbp_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Ngaka-pardu-kari, Jamijinilpa nyinaja kirringka yirdingkaju Kaajarla. Kujalpa nyinaja yinyarla nyanungu, ngula nyangu karnta kujalpa wati panu-kurlu warru ngunaja talakupurda. Nyanunguju yanu karnta-kurlangu ngurra-kurra, ngula-pala ngunaja wungulku mungangkaju. ");
INSERT INTO wbp_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Warrukirdikirdi kirringka yinyarlaju karrijalpa pinji wiri-jarlu kirrirdimpayi ngulaju yarturlu-kurlu pirli lalypa-kurlu. Ngulangkaju karrijalpa-pala jirrama tuwa-jarra lakarn-maninja-kurlanguju. Ngula-jarrarluju tuwa-jarrarlu, jarnku-mardarnulpalu-jana ruumu-jarra, jinta jungarni-purdanji, jinta jampu-purdanji. Yapangku Kaaja-wardingki-paturlulu milya-pungu Jamijiniji kujalpa karnta yinya-kurlu ngunaja, ngulalu-nyanu wangkaja, “Pinyirlipa Jamijini kaji wanta kankarlu-jarrimirni!” Ngulalu kiirti-kirra yanu, ngulajulpalu yaninjarla ruumu-jarrarla nyinaja. Pardarnulpalurla Jamijiniki kaji kirri yinya-ngurlu wilypi-pardimi. ");
INSERT INTO wbp_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Kala Jamijini yakarra-pardija kulkurru-kari, ngula kiirti-kirra yanu. Tuwa-jarrajulpa-pala lakarn-pinja-wangu karrija, ngulangka yangka ngana kulalpa wilypi-pardiyarla. Ngula-kurraju Jamijini yanurnu, yarnkaja-palangu tuwa-jarrakuju, ngulaju-palangu rdakangku-juku lakarn-maninjarla rdungkurr-pungu. Manu ngula-jangkaju nyanungu-nyangurla jimantarla-palangu jarna-yirrarnu. Ngula-jangkaju tuwa-jarra-kurluju yanu wurnturu-nyayirni Yipurana-kurra. Yinyarla-kula yanu pirli-kirra kankarlarra, ngulangkanya-palangu tuwa-jarraju yirrarnu walya-kurralku wanapi-jiki tirnngi-yirrarninja-warnu-juku. ");
INSERT INTO wbp_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Ngaka-pardu-kari, Jamijinirla waninja nyinaja karnta jinta-kariki yirdikiji Tilayilakulku kujalpa nyinaja ngurrangka Jurikirla wararra-jarra-wana kulkurru-jarra. ");
INSERT INTO wbp_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Ngula-jangka, wiriwiri yangka Pilijiya-wardingki-patulurla yaninjarla wangkaja Tilayilaku, “Yulyurlku-yungka Jamijini ngula-jangkarluju yungungku yimi-ngarrirnilki nyiyarlu kuja-ka nyanunguju pirrjirdi-mani. Yungurnalu milya-pinyi nyiyarlu kuja-ka nyanungu rampaku-mani. Kajingki yimi-ngarrirni, kapurnangkulu yinyi 1100-pala tala. ");
INSERT INTO wbp_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Ngaka Jamijiniji pina-yanurnu Tilayila-kurlangu ngurra-kurra, ngula payurnu Jamijiniji, “Jamijini, nyiyarlu kangku pirrjirdi-mani nyuntuju? Nyiya-kurlurlu kajikangkulu yapangkuju warirni wuruly-parnkanja-kujakuju? Yimi-ngarrikaju wiyarrpaku!” ");
INSERT INTO wbp_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Jamijinirli yalu-manu nyanungu, “Kajilpa nganangku-puka wirlki-pala ngalyipi-piya ngurrju-mantarla puluku-kurlangu pulyku-jangka linji-wangu-jangka manya-juku, ngula-jangka kajilpajulu wayikarla yinya wirlki-pala ngalyipi-piya-kurlurlu, ngulaju kulalparna nyarrparlu rdilyki-pungkarla wuruly-parnkanjakungarntirli. Kajikarna rampaku-jarrimi yapa ngalya-kari-piya.” Ngula-jana Tilayilarluju yaninjarla yimi-ngarrurnu wiriwiriki. ");
INSERT INTO wbp_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","9","Ngula-jangka, yinyarlu wiriwirirli Pilijiya-wardingki-paturlulu-jana ngurrju-manu wirlki-pala ngalyipi-piya puluku-kurlangu pulyku-jangka linji-wangu-jangka, ngulalurla yungu Tilayilaku. Ngulalu-jana ngalya-kari warrmarla yilyaja Tilayila-kurlangu ngurra-kurra yungulu wuruly-nyina ruumungka kujalpa-pala Jamijini manu Tilayila nyinaja, kajika-jana Jamijinirli nyanyi. Pardarnulpalurla yungulu puuly-mardarni kaji rampaku-jarrimi. Ngula-jangka, Tilayilarlu-jana manu yinyaju wirlki-pala ngalyipi-piya, ngula Jamijiniji warurnu. Ngula-jangkaju, kilji-nyayirnirla purlaja, “Jamijini! Warrmarla Pilijiya-wardingki-patungkulu jangkardu yanurnu puuly-mardarninjaku!” Jamijinijilpa ngunaja-juku ngalyipi-piya-kurluju warirninja-warnuju. Ngula-warnurluju ngari-jana kapankurlu rdilyki-pungu ngulaju ngalyipi-piyaju kula-nganta-jana warlungku yungkurnu. Warrmarla yinya-patujulu wurulypa parnkaja, manu wiriwirirli kulalpalu milya-pungu nyiyarlu kujalpa nyanungu pirrjirdi-manu. ");
INSERT INTO wbp_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Ngula-jangka, Tilayilarla wangkaja Jamijiniki, “Warlkanpaju manyu-pinjarla wangkaja! Yimi-ngarrikaju yarujurlu! Nyiya-kurlurlurnangku warirni wuruly-parnkanja-kujakuju?” ");
INSERT INTO wbp_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","12","Jamijinirli yalu-manu Tilayilaju, “Rupu jalangu-warnu-patu-jana manta, kula nyurru-warnu. Kajilpaju nganangku warikarla ngalyipi-piya jalangu-warnu-kurlurlu, ngulaju kajikarna rampaku-jarrimi yapa ngalya-kari-piya.” Ngula-jangka, parra-karirlalku Tilayilarluju-jana yaninjarla manunjunu jalangu-warnu-patu ngalyipi-piya-patuju, ngula-jana pina-kangurnu yuwarli nyanungu-nyangu-kurra kujalparla Jamijini pardarnu. Warrmarla-patujulpalu ruumu yalumpurla-juku wuruly-karrija Tilayila-kurlangurla-juku. Kujalpa Jamijini jarda-jarrija, ngula Tilayilarlu rdaka-jarra warurnu ngalyipi-piya-kurlurlu. Kula nganangku yapangku nyiya warurnu ngalyipi-piya-patu-kurlurlu yinya-patu-kurlurlu. Warirninja-warnu, Tilayilarla kilji-nyayirni purlaja, “Jamijini! Warrmarlangkulu jangkardu yanurnu puuly-mardarninjaku!” Ngari-jana yangka-patuju ngalyipi-piya-patu Jamijinirliji turl-pungu jirrirdi-piya. ");
INSERT INTO wbp_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Ngula-jangka, Tilayilarla wangkaja, “Warlkangku-juku kanpaju ngarrirni! Yimi-ngarrikaju jungangku! Nyiya-kurlurlurnangku warirni parnkanja-kujakuju?” Jamijinirli yalu-manu, “Nyangkaju jurru. Wirlki-pala pijipiji-manurnaju. Nyanyi kanpa nyampu wirinkirri-piya wiri-jarlu, ngula-kurraju pijipiji maninja-warnu nyampu warika. Kajinpa kuja-jarrimi, ngulaju kapurna rampaku-jarrimi ngalya-kari-piya.” ");
INSERT INTO wbp_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Junga-juku, parra-karirlalku, ngulalpa Jamijini jarda-juku ngunaja, Tilayilarluju, jarda-kurra-juku nyanungu-nyangu-kurlurlu pijipiji-kirlirliji warurnu wirinkirri wiri-jarlu-piya-kurra. Ngularla purlajalku kilji, “Jamijini! Warrmarlangkulu jangkardu yanurnu nyuntuku!” Kapanku yakarra-pardija Jamijiniji, ngulangkuju-nyanu jurruju wilypi-manu ngula Tilayilarlu warurnu wirinkirri-piya-kurra. ");
INSERT INTO wbp_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Ngula-jangka, Tilayilarla wangkaja, “Nyuntu kanpaju wangkami yulkami nganta kanpaju. Kala lawa! Marnkurrpakunpaju yimirr-yungu! Kulanpaju wangkaja nyiyarlu kuja kangku pirrjirdi-mani.” ");
INSERT INTO wbp_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Ngula-jangka, parra-kari parra-kari kala Tilayilarluju warrarda payurnu Jamijiniji. Ngula-jangkaju, marlajalkurla mata-jarrijalku. Jamijiniji mata-maninjarla muntuku-manu payirninja wita-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","Ngula-jangka, Jamijinirla jungalku wangkaja, “Ngularna ngajulu palka-jarrija, Kaatu-mipakulparnarla warrki-jarrija. Kujarlaju, kulaju nganangku jurruju pajurnu, kajikarna rampaku-jarrimi ngalya-kari-piya.” ");
INSERT INTO wbp_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Tilayilarlu milya-pungu kujarla Jamijini jungalku wangkaja. Ngula yapa jinta-kari yilyaja maninjaku yapa wiriwiri Pilijiya-wardingki-patu. Wangkaja-jana, “Yantarnili ngaju-nyangu ngurra-kurra jinta-karikilki. Jamijiniji jungalku wangkajaju, manu karna milya-pinyi nyiya-jangka kapu rampaku-jarrimi.” Ngula-jangka, wiriwiri yinya-patulu yanu Tilayila-kurlangu ngurra-kurra, ngulalurla tala kangurnu kujalpalurla jangku-pungu. ");
INSERT INTO wbp_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","20","Kujalpalu yangka wiriwiri yanurnu-juku marda kulkurru, ngula-puruju Tilayilarla wangka Jamijinikiji yungu ngunami jurru-purdanji nyanungu-nyangu-kurra wanarri-kirra rdirrpa-kurra. Ngulalu wati yinya-patu yukajarra, rdakardaka-jana wangkaja yungulu karrimi-juku. Ngula Jamijini-kirlangu wakurlu pajurnu. Ngula jupu-karrija wakurlu pajirninjaku, Jamijiniji rampaku-jarrija-nyayirni. Ngula Tilayilarlu warurnu, ngularla yarda purlaja, “Jamijini! Warrmarlangkulu jangkardu yanurnu!” Jamijiniji yakarra-pardija, manu-nyanu manngu-nyangu, “Kapurnaju jurnta larra-pinyi yangka kamparru-piya.” Kala lawa! Kulalpa milya-pungu kuja YAAWIYI-rli yampija pirrjirdi-maninja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Ngula-jangka, wati-paturlulu puuly-mardarnu Jamijiniji. Ngulalu pampa-karda milpaju panturnu. Ngula-jangkaju, nguru-yirrarnulurla Jamijinikiji, ngulalu rdakungkalku yirrarnu kirri Kaajarla. Warurnulu jayini-kirlirli watiyarla pirli wiri-kirlirla yarturlu-kurlurla warru ruu-kanjaku. Ngula-jangka kalalu jinyijinyi-manu ngurlu puyu-pinjaku pirli yinya-kurlurluju. ");
INSERT INTO wbp_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Kala kulalu wakurluju yarda pajurnu. Ngulalpa pulya-juku pina-pardinja-yanu. ");
INSERT INTO wbp_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Ngaka-pardu-kari, wiriwiri Pilijiya-wardingki-patulu jinta-jarrija kurapaka wiriki. Pungulu-jana panu-nyayirni puluku manu jiyipi purranjaku yungulurla purrami nyanungurra-nyangu jukurrpakujuku yirdikiji Takanaku. Wangkajalu-nyanu, “Jamijinirli kala-ngalpa warrarda pakarnu yangka ngalipaju, kala ngalipa-nyangu jukurrparlu jujungku Takanarlu-ngalpa pirrjirdi-manu nyanungukuju puuly-mardarninjakuju.” ");
INSERT INTO wbp_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","25","Yapaju ngarilpalu manyu-karrija kurapakarla wardinyi-nyayirni. Ngula ngana mayi purlaja, “Yuwa! Jamijinili kangkarni rdaku-jangka yungurlipa manyu-pinyi mayangku!” Ngulalu-jana wiriwirirli ngalya-kari warrmarla yilyaja Jamijini maninjaku. Ngulalu kangurnu, yapangkulu muku nyangu, ngulalurla rdirri-yungu pulka-pinjaku Takanaku. Purlajalpalu kujanya, “Jamijinirli-ngalpa ngurlu manu watiya mangarri-kirlangu jurnta purraja, manu-jana yapa panu ngalipa-nyangu pungu. Kala-ngalpa kulu-jarrija warrarda. Kala Takanarlu-ngalpa pirrjirdi-manu puuly-mardarninjakuju.” Manyu-pungulpalu Jamijiniji kujarlu-juku. Ngulalurla wangkaja kulkurru-jarra karrinjaku pirli kirrirdi-jarrarlaku kujalpa-pala juka-karrija yali-jarra pirli-jarraju, yangka kujalpa-pala yuwarli ngula-jarrarluju jirri-mardarnu kankarlarni wantinja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Wirriya witangkurla nguru-yirrarnu Jamijinikiji pirli-jarra-kurra kirrirdi-jarra-kurraju, ngularla Jamijiniji wangkaja, “Ngajujurna matalku. Karrinja-yirrakaju pirli kirrirdi-jarrarla kulkurru-jarra yungurna yulu-nguna.” ");
INSERT INTO wbp_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Yapangkujulpalu ngarnu-juku miyiji kurapakaju. Panu-nyayirnilpalu yapaju nyinaja kaninjarni yuwarli maralypirlaju Takana-kurlangurla. Manu 3,000-pala yapalpalu karrija kankarlarniji yuwarlirla. Ngulangkujulpalu kaninjarra-kari nyangu Jamijiniji, manulpalu mayirriyirri-manu-juku. ");
INSERT INTO wbp_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Ngula-puruju, Jamijinirla wangkaja YAAWIYI-ki, “Kaatu, kulaju ngajuju wajawaja-manta Pilijiya-wardingki-paturlujulu milpaju panturnu. Kala pirrjirdi-manta yardaju yungurnajurla pina-kunka-mani!” ");
INSERT INTO wbp_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","Jamijinijilpa ngulangka-juku karrija kulkurru-jarra pirli kirrirdi-jarrarla kujalpa-pala kankarlarniji jirri-mardarnu yuwarli. Ngula-jarraju-palangu warru marnpurnu rdakangku jungarni-purdanjirli manu rdakangku jampu-purdanjirli. ");
INSERT INTO wbp_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","Ngula-jangka, purlajarla YAAWIYI-ki, “Yungurna palimi nyampurla-juku Pilijiya-wardingki-patu-kurlu!” Ngula kilji-nyayirnirli yurnturnu pirli-jarraju, ngula-jana yapakuju yaarl-wantija kankarlumparra Jamijini-kawarliki. Kula-jana kuja-piya panu-jarlu nyurru-wiyi yapa pungu Pilijiya-wardingki, lawa. ");
INSERT INTO wbp_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Ngula-jangka, Jamijinikipurdangka-patu manu nyanungu-nyangu warlalja yanurnulu Kaaja-kurra kujalu palka nyanungu-nyangu Jamijini-kirlangu nyurnulku maninjunurnu. Ngulajulu palkaju Jamijini-kirlangu kangu pina nyanungu-nyangu-kurra ngurrara-kurra kujalpa Jamijini nyinaja. Milyingka yirrarnulu pirnkingka yangkangka-juku kujalu nyanunguku kirda-nyanu milyingka yirrarnu kamparru-wiyi. Ngurra yinyaju kulkurru-jarra Juuraku manu Yijituluku. Yimi nyampuju walku-jarrimi-ka Jamijini-kirli. Nyanungujulpa-jana wiri-jarlu ngarlkinpa nyinaja yapaku Yijirali-pinkiki 20-pala yulyurrpuku… ");
INSERT INTO wbp_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Nyurru-wiyi, Kingi Tapitilpa wiri nyinaja Yijiralirla. Ngula-wangurla-wiyi, yalirla ngurungka, ngulajulparla miyikiji lawa karrija yulyurrpu-patuku. Wati yirdi Limilikirli yampinja-yanu kirri Pijilimi Jurdiyarla, ngula yanu ngurrara-kari-kirra Muwapu-kurra. Kangu-jana nyanungu-parnta manu kaja-nyanu-jarra. Nyanungu-parnta yirdiji Nayumi, manu kaja-nyanu-jarraju yirdi-jarraju ngulaju Malana manu Kilana. Nyampurraju yapa Yiparata-wardingki-patu yangka Pijilimi-wana. Yanulu Muwapu-kurra yinya-patuju, manulpalu nyinaja yinyarlalku-juku. ");
INSERT INTO wbp_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ngakalku Nayumi-parnta Limiliki palijalku. Ngulalpa Nayumi-mipa nyinaja kaja-nyanu-jarra-kurlu. ");
INSERT INTO wbp_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Nyampu-jarrarlu kaja-nyanu-jarra-pala yupukarra-jarrija Muwapu-wardingki karnta-jarra-kurlu. Yirdi karnta-kari-kirlangu Yurrpa, manu jinta-kariji Ruurtu. Nayumiji nyinaja kaja-nyanu-jarra-kurluju Muwapurla karlarla-palaku yulyurrpuku. ");
INSERT INTO wbp_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ngula-jangka, Malana manu Kilana-jarralku-pala palija. Nayumijilpa nyinaja kali-nyanu-wangu manu kaja-nyanu-jarra-wangulku. ");
INSERT INTO wbp_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ngulalpa Nayumi nyinaja Muwapurla, purda-nyangu kujalpa-jana YAAWIYI Kaaturlu warrawarra-kangu nyanungu-nyangu yapa ngurungka Juurdarla. Yungulpa-jana miyi. Ngulalpa Nayumi yampinjakungarntilki nyinaja Muwapukuju yungu pina-yani nyanungu-nyangu ngurra-kurra. Kanajardu-nyanu-jarrarlangulpa-pala nyinaja yampinjakungarnti nyanungu-kurlu. ");
INSERT INTO wbp_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Junga-juku, yampinja-yanulu yangkaju ngurra kujalpalu nyinaja. Ngulalu wurna rdirri-yungu Juurda-kurra-pinangu. ");
INSERT INTO wbp_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Nayumi-palangu wangkaja kanajardu-nyanu-jarraku, “Yanta-pala pina nyuntu-jarraku ngati-nyanu-jarra-kurlangu-kurra yuwarli-jarra-kurra. Ngampangampa-nyayirnilpanpaju-pala nyinaja ngajuku manu ngaju-nyangu kaja-jarraku kujarna ngati-puka-jarrija. Yungungkupala YAAWIYI nyinami ngampangampa-yijala. ");
INSERT INTO wbp_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","YAAWIYI-rli yungungkupala kali-nyanu-kari yinyi.” Ngula-jangka, Nayumirli-palangu nyunjurnu karnta-jarra, manulu kilji-nyayirni yulaja. ");
INSERT INTO wbp_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Kanajardu-nyanu-jarra-palarla wangkaja, “Lawa, yani karlijarra nyuntu-kurlu yungurnalu-nyarra jirrnganja nyina nyuntuku manu nyuntu-nyangu yapaku.” ");
INSERT INTO wbp_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nayumi-palangu wangkaja, “Ngaju-nyangu kanajardu-jarra, yanta-pala pina nyuntu-jarra-nyangu ngurra-kurra. Nyiyakulkunpala ngaju-wanaju yanirni? Nyarrparlu kulalparna kaja-nyanu-kariji mardakarla yungunpala yupukarra-jarri pina nyanungu-jarra-kurluju, lawa. ");
INSERT INTO wbp_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yanta-pala pina ngurra-kurra. Kulalparna muturnalku yupukarra-jarriyarla pina, lawa. Manu kajilparna kali-nyanu mardakarla jinta-kari jalangu mungangka, manu kajilparna yarda mardakarla kaja-nyanu-patu-kari, kala nyiyaku? Kulalparlipa yangka-piya-juku nyinakarla, lawa. ");
INSERT INTO wbp_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Kajikankulu-jana mayi pardarni kurdu-jarraku murnma kaji-pala wiri-jarrimi wati-kirralku? Kuja-piya-wangu-pala nyinaya! Kajilpanpajupala jirrnganja nyinayarla ngajuku yaninja-wangu, ngulaju kajikanpala mulurrpa-nyayirni nyinami ngaju-piya. YAAWIYI kaju jangkardu nyina ngajukuju!” ");
INSERT INTO wbp_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Karnta-patulu-nyanu yarda yulaja, ngula Yurrpangku Nayumiji nyunjurnu jakuru-pinjakungarntirli. Kala Ruurtujulpa ngampurrpa-wangu-juku nyinaja Nayumiki yampinjaku. ");
INSERT INTO wbp_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nayumi wangkajarla, “Nyangka, nyuntukupurdangka pina-ka yani nyanungu-nyangu yapa-kurra, manu nyanungu-nyangu nguru juju-kari-kirra kuja kalu mardarni. Yanta pina nyanungu-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ngula Ruurtulkurla wangkaja, “Kulaju ngajuku wangkaya yungurnangku nyuntu yampi! Kulaju ngajuku wangkaya nganta yungurnangku puranja-wangu nyina! Kajinpa nyarrpara-puka yani, ngaju kapurna yani nyuntu-wana. Ngurrangka nyarrpararla kajinpa nyina, ngaju kapurna nyina-yijala nyuntu-kurlu. Nyuntu-nyangu yapaju kapulu nyina ngaju-nyangurlangu. Nyuntu-nyangu kapu nyina Kaatuju ngaju-nyangurlangu. ");
INSERT INTO wbp_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Manu kajinpa nyarrpararla-puka palimi, ngaju kapurna palimi-yijala yalumpurla-juku. Yinyarla-yijala kapujulu milyingka yirrarni. Payirni karna YAAWIYI yungulpaju murrumurru-mantarla kajilparna jaru nyampu rdilyki-pungkarla kuja karnangku milpa ngarrirni jalangurlu. Ngaka kajirna palimi, ngula-jangka-mipanya kapurnangku yampimi.” ");
INSERT INTO wbp_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nayumirliji milya-pungu Ruurtuju ngampurrpa yaninjaku nyanungu-wanaku. Ngula Nayumiji wiljiwilji-jarrinja-wangu wurdungu-jarrija. ");
INSERT INTO wbp_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ngula-jangkaju, Nayumi manu Ruurtu-pala yanurnu Pijilimi-kirra. Kuja-pala karnta-jarra yukajarra Pijilimi-kirra, karntakarnta yali-wardingki-patulu-nyanu wangkaja, “Wiyarrpa! Nyiya-jangka Nayumiji yanurnu mularrpa?” ");
INSERT INTO wbp_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nayumi-jana yapakuju wangkaja, “Kulajulu Nayumi yirdi-manta. Marajulu yirdi-manta. Kaaturlu PIRRJIRDI-NYAYIRNI WITA-WANGU-rluju ngajuju mularrpa-manu. ");
INSERT INTO wbp_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Kujarna nyampu nguru yampija nyurru-wiyi, nyiyarningkijarralparna mardarnu. Kala jalangu YAAWIYI-rliji kangurnu pina ngurra-kurra marlajarra. Kala nyiyaku kankujulu Nayumiji yirdi-mani? YAAWIYI-ji jangkardu jikajika-jarrija ngajukuju. Kaaturlu yangka PIRRJIRDI-NYAYIRNI WITA-WANGU-rlu yartarnarri wiri-kirlirliji ngajuju maju-kurraju yirrarnu.” ");
INSERT INTO wbp_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Junga-juku, Nayumi manu nyanunguku kanajardu-nyanu Ruurtu yangka karnta Muwapu-wardingki-pala pina-yanurnu Muwapu-ngurlu. Yanurnu-pala Pijilimi-kirra kujalpalu ngurlu pajirninjarla manu-puru. ");
INSERT INTO wbp_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Watilpa nyinaja nyiyarningkijarra-kurlu Pijilimirla yirdiji Puwaja. Puwajajulpa nyinaja Nayumi-kirlangu warlalja Limiliki-kirlangu-jangka. ");
INSERT INTO wbp_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Parra jintangkarla wangkaja Ruurtu Nayumiki, “Yilyayaju yangka-kurra kuja-ka ngurlu pardimi. Marda kajikaju jintarlangurlu marda mari-jarrimi yungurna ngurlu maninja-yani purdangirli-wanarlu.” Nayumirla wangkaja, “Yanta, ngaju-nyangu kanajardu.” ");
INSERT INTO wbp_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Junga-juku, Ruurtuju yanu yangka-kurra kujalpa miyi pardija. Puraja-jana warrkini-patu kujalpalu miyi ngurlu pajurnu. Warrulpa manu ngurlu ngalya-kari kujalu yampija. Ngarilparla nguru yinyaju karrija Puwajaku. Nyanungujulparla nyinaja warlalja Limiliki-kirlangu-jangka. ");
INSERT INTO wbp_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ngula Puwaja yanurnu Pijilimi-jangka, wangkaja-jana warrkini-patuku, “YAAWIYI-ka nyina nyurrurla-kurlu!” Ngulalu warrkini-watirli yalu-manulku, “YAAWIYI-rli yungungku pirrjirdi-maninjarla warrawarra-kanyi!” ");
INSERT INTO wbp_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Ngula-jangka, Puwajarla wangkaja warrkini nyanungu-nyanguku kujalpa-jana wiri nyinaja warrkini-patu-kariki, payurnu, “Ngana-kurlangu yinyaju karnta?” ");
INSERT INTO wbp_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Warrkinirli yalu-manu, “Karnta yinyaju Muwapu-wardingki kuja yanurnu Nayumi-kirli Muwapu-jangka. ");
INSERT INTO wbp_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nyanunguju wangkaja ngajuku, ‘Waraa! Yungurna-jana warrkini-wati purami, manu yungurna-jana ngalya-kari ngurlu marlaja mani walyangka kajili yampinja-yani.’ Yaninjarlalpa nyinaja nyampurla-juku. Mungalyurru-ngurlu parra jingijingi warrki-jarrinja-yanu purdangirli-wana, kala ngari witaku nyinaja mata warrki-jarrinja-wangu.” ");
INSERT INTO wbp_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ngula-jangka, Puwajarla yaninjarla wangkaja Ruurtuku, “Purda-nyangkaju, karnta-pardu! Nyinaya nyampurla-juku, manu ngurlu-nyanu manta. Kula yanta yapa jinta-kari-kirlangu-kurra kuja-ka ngurlu pardimi-kirra. Puraya-juku-jana ngaju-nyangu warrkini-patu karntakarnta. ");
INSERT INTO wbp_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nyangka-jana kajili nyarrpara-kurra yani ngurlu turnu-maninjaku. Ngula-jangka puraya-jana. Kurnta-ngarrurnurna-jana wati-patuju nyuntu-kujakuju. Kajinpa purraku-jarrimi, ngulaju nganja kutu ngapa. Manta ngapa kuja kalu kartaku-kurra winjirni warrkini-paturlu.” ");
INSERT INTO wbp_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ngula Ruurtu parntarrija kaninjarra-kari walya-kurra, wangkajarla Puwajaku, “Ngajujurna yapa-kari ngurra-kari-wardingki. Nyiya-jangkanpaju ngurrju nyinaja?” ");
INSERT INTO wbp_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Puwajarlu yalu-manu, “Milya-pinyi karna kujanparla ngurrju nyinaja kanajardu-purajiki Nayumiki. Ngurrjunparla nyinaja kuja kali-puka-jarrija. Yampinjarlanpa-jana jurnta yanu nyuntuku kirdanaku manu ngati-nyanuku manu ngurraraku. Yanurnunpa nyampu-kurra nguru-kurra, kula kanpa-jana yapa milya-pinyi nyampurla. ");
INSERT INTO wbp_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","YAAWIYI-rli kapungkurla pulka-pinyi. Kapungku tarnngangku-juku mardarni YAAWIYI-rliji yangka Kaaturlu Yijirali-wardingkirli. Nyuntunparla yanurnu jurlpu wita-piya yungungku warrawarra-kanyi.” ");
INSERT INTO wbp_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ngula-jangka, Ruurtujurla wangkaja, “Nyuntujunpa ngurrju-nyayirni. Wangkajanpaju ngurrju. Wajampalparna kamparruju nyinaja. Kularnangku warrkini nyuntukuju. Kala nyuntulurlunpaju kutu wardinyi-manu-nyayirni.” ");
INSERT INTO wbp_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Mangarri kujalpalu karlarla ngarnu, Puwajarla wangkaja Ruurtuku, “Yantarni nyampu-kurra! Nganja nganimpa-nyangu mangarri. Mpa! Julyurl-yirraka mangarri nyampurla pamangka.” Junga-juku, Ruurtujulpa nyinaja warrkini-wati-kirli. Puwajarlurla yungu Ruurtuku ngurlu warlu-jangka yirnmi. Ruurturluju pirda-karda ngarnu, mangarrijilpa panu-juku ngunaja. ");
INSERT INTO wbp_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ruurtuju yakarra-pardinjarla yanu pina warrki-kirralku. Ngula Puwaja-jana wangkaja nyanungu-nyanguku warrkini-watiki, “Yampiyalu yungu mani kutu ngalya-kari ngurlu yurturlu-kari yurturlu-karirla. Kulalu ngarrika yaninjaku. ");
INSERT INTO wbp_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Kijikalurla ngurlu ngalya-kari walya-kurra yungu-nyanu turnu-mani, manu kulalu warla-pajika kuja-kujakuju.” ");
INSERT INTO wbp_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Junga-juku, Ruurturlujulpa ngurluju manu wuraji-kardarlu. Ngula-jana ngurluju ngalya-kari kipirninjarla manu. Mardarnulpa ngurluju yakuju wiri-jarlurla. ");
INSERT INTO wbp_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ruurturlu kangu ngurlu ngurra-kurralku. Ngula kanajardu-nyanurlu nyangu kuja ngurlu panu manu. Ruurturlurla yungu miyi ngalya-kari kujalu puta ngarnu karlarla-jangka. ");
INSERT INTO wbp_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nayumirli payurnu, “Nyarrpararlanpa nyampuju ngurlu turnu-manu muku jalangurluju? Nyarrpararlanpa warrki-jarrija? Yinya wati kujangku nyuntuku ngurrju nyinaja, ngulaku karnarlajinta Kaatuku wangka yungurla marlaja nyina wardinyi-nyayirni!” Ruurturlu yimi-ngarrurnu nyanungukuju wati yaliki kujalpa walya mardarnu miyi panu-kurlu, wangkajarla, “Wati-kirli kujarna jalangu warrki-jarrija yirdiji Puwaja.” ");
INSERT INTO wbp_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nayumirla wangkaja nyanunguku kanajardu-nyanuku, “YAAWIYI-ki yungurla marlaja nyina wardinyi-nyayirni Puwajaju! YAAWIYI kajana yapakuju ngurrju-juku nyina yimiri wankaruku manu nyurnuku!” Ngula-jangka, Nayumirla wangkaja Ruurtuku, “Puwajaju ngalipa-nyangu warlaljayirri. Kapu-ngalingki warrawarra-kanyi.” ");
INSERT INTO wbp_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ngula-jangka, Ruurturla wangkaja, “Puwajaju wangkaja yungurna nganta warrki-jarrimi-jiki, wangkaja kutu-juku nganta yungurna-jana wapami warrkini-patu karntakarntakuju kajili ngurlu maninjaku lawa-jarrimi.” ");
INSERT INTO wbp_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ngula-jangka, Nayumirla wangkaja kanajardu-nyanuku Ruurtuku, “Ngurrju yungunpa warrki-jarrimi nyampurra-kurlu warrkini-patu karntakarnta-kurlu. Kajilpanpa jinta-karirla ngurlu-kurlangurla warrki-jarriyarla, kajikangku marda wati-karirli jarrarda-kanyi.” ");
INSERT INTO wbp_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Junga-juku, Ruurtujulpa-jana kutu-juku jirrnganja warrki-jarrija karntakarnta warrkinikiji Puwaja-kurlangu-patukuju. Ngurlulpa warru manu yangka kuja ngurluju lawa-jarrijalku. Manu Ruurtuju tarnngalpa nyinaja kanajardu-nyanu-kurlu Nayumi-kirli. ");
INSERT INTO wbp_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ngula-jangka, Nayumirla wangkaja Ruurtuku kanajardu-nyanuku, “Ngajuku kanajardu, yungurnangku kali-nyanu-kari palka-mani nyuntuku. ");
INSERT INTO wbp_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Puwaja kangalingki warlalja nyina ngalijarraku. Nyuntunpa warrki-jarrija nyanungu-nyangu warrkini karntakarnta-kurlu. Jalangu mungangka kapu warrki-jarrimi yangka yarlungka kipirninja-kurlangurla. ");
INSERT INTO wbp_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Yaninjarla-nyanu parljika. Mapaka-nyanu ngurrjungku yangka kuja-ka ngurrju parntimi. Jurnarrparla yukaya, manu wuruly-yanta yarlu-kurra kipirninja-kurlangu-kurra. Wuruly-yirraka-nyanu kaji mangarriki manu pamaku Puwaja ngarninjaku lawa-jarrimi. ");
INSERT INTO wbp_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ngula-jangka kapu ngunanjinilki. Nyangka yungunpa milya-pinyi kaji nyarrpara-wana ngunami. Yanta yinya-kurra, manu wawardarla jurnta kankarlu-manta wirliyaku. Ngula-jangka ngunanjinkalku. Kapungku nyanungu wangkami nyarrpa-jarrimi yungunpa.” ");
INSERT INTO wbp_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ngula Ruurturlu yalu-manu, “Kajinpaju nyarrpa nyuntu wangkami ngajuku, kapurnangku purda-nyanyi.” ");
INSERT INTO wbp_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Junga-juku, Ruurtuju yanu yarlu-kurra yangka kuja kalalu ngurlu kipurnu. Kujarla kanajardu-nyanu wangkaja nyarrpa-jarrinjaku, ngulaju purda-nyangu kanajardu-nyanuju. ");
INSERT INTO wbp_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Miyi manu pama ngarninjarla, Puwaja warungka-jarrinjarla mangkururla-kurlu ngunaja, ngulaju-nyanu ngurrjulku purda-nyangu. Yaninjarla ngunanjunu ngurlu-wati-wana. Ngularla Ruurtuju wurulypa-juku yanu. Ngularla wawarda jurnta kankarlu-manu wirliyaku, manu ngunanjunulku. ");
INSERT INTO wbp_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Kulkurru-karilki, Puwajaju kinyirr-yakarra-pardinjarla karipurdanji-jarrija. Ngula lani-jarrija! Karnta ngunanya wirliya-wana nyanungurla! ");
INSERT INTO wbp_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Puwajarlu payurnu, “Ngananpa nyuntuju?” Nyanunguju wangkaja, “Ngajurna Ruurtu, nyuntu-nyangu warrkini. Nyuntunpa warlalja ngaju-nyangu. Yungulpanpaju warrawarra-kangkarla. Wawardaju parnta-yirraka. Kajilpanpaju parnta-yirrakarla, ngulaju kajikarna milya-pinyi kapunpa ngaka yupukarra-jarrimi ngaju-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ngula Puwajalkurla wangkaja, “YAAWIYI-rli yungungku ngurrjungku mardarni. Nyuntu kanpa ngurrju-nyayirni yimiri nyina yangka-piya-yijala kujanparla Nayumiki nyinaja kamparru-wiyi. Kulanparla yaparranjiki nyangu yupukarra-jarrinjaku marda tala panu-kurluku manu marlajarraku, lawa. ");
INSERT INTO wbp_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Kula lani-jarriya. Kapurnangku nyiyarningkijarra yinyi kajinpaju payirni. Yapa panungku nyampurlarlu kirringkarlu kangkulu milya-pinyi nyuntuju ngurrju. ");
INSERT INTO wbp_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Junga kujaju. Ngajurna nyuntu-nyangu warlalja yangka kapurnangku warrawarra-kanyi. Kala wati-kari-ka nyina nyuntuku warlalja-yijala. Mardalpangku nyanungurlu-wiyi warrawarra-kangkarla. ");
INSERT INTO wbp_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Nyinaya nyampurla jalangu mungangka. Ngakarna payirninjini ngampurrpa marda-ka nyuntuku nyinami yajarninjaku. Kajingki yajarni, ngulaju ngurrju. Kajingki wurra-mani, ngulaju kapurnangku yajarni ngajulurlu. Ngula-jangka kapurnangku payi-mani pina Limiliki-kirlangu nguru. YAAWIYI-ka nyina wankaru-nyayirni, purda-nyanyi kaju nyarrpa wangkanja-kurra. Junga karnangku wangkami kapurnangku pina payi-mani nguruju. Ngunaya nyampurla-juku mungalyurru-karda.” ");
INSERT INTO wbp_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Junga-juku, Ruurtuju ngunaja ngulangka-juku wirliya-wana mungalyurru-karda. Yakarra-pardija munga-wana-juku yapa-kujaku nyanja-kujaku. Puwajarla wangkaja, “Pina-yanta ngurra-kurra nyuntu-nyangu-kurra wurulypa, kajikangkulu yapa ngalya-karirli nyanja-warnurlu milya-pinyi kujanpa nyampu-kurra ngurlu kipirninja-kurlangu-kurra yanurnu.” ");
INSERT INTO wbp_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ngula-jangka, Puwajarla wangkaja Ruurtuku. “Kangkarni nyuntu-nyangu wawarda. Ngula-jangka, kijika walya-kurra manu raa-pungka!” Junga-juku, Ruurturlu kijirninjarla raa-pungu nyanungu-nyangu wawarda, ngularla Puwajarlu jurrupuly-winjurnu ngurluju panu-juku. Ngularla Puwajarlu purturlurlalku yirrarnu, ngula yanu pina ngurra nyanungu-nyangu-kurra. ");
INSERT INTO wbp_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ruurturla pina-yanu kanajardu-nyanu-kurra. Ngula Nayumirli payurnu, “Nyarrpa-jarrijanpa, ngajuku kanajardu?” Ruurturlu yimi-ngarrurnu nyiyarningkijarra. ");
INSERT INTO wbp_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Nyanungurla wangkaja, “Puwajarluju yungu ngurlu panu. Nyanunguju wangkaja, ‘Kulalpanpa yantarla miyi warntarri-wangu kanajardu-puraji-kirra.’” ");
INSERT INTO wbp_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nayumirli yalu-manu, “Ruurtu, ngajuku kanajardu-nyanu, wurrarla pardaka Puwajakuju kajingki nyarrpa wangka. Kulangku yampimi, lawa. Kapu-jana yaninjarla wangkami purlka-patuku nyuntu-kurlu mungalyurru marda, wuraji marda jalangu.” ");
INSERT INTO wbp_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Puwaja yanu kiirti-kirra, nyinajalpa ngulangka-juku kujalpa wati warlalja nyanungu-nyangu yanurnu yangka kujalpa yirdi-manu kamparru-wiyi. Puwajarla purlaja, “Yantarni nyampu-kurra wungu-warnu! Pirri-manta nyampurla!” Junga-juku watiji yaninjarla pirri-manu. ");
INSERT INTO wbp_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ngula-jangka, Puwajarlu-jana karlarla-pala purlka-patu warru manu kujalpalu wiri-patu nyinaja yinya kirri wiriki. Wangkaja-jana, “Nyinakalu nyampurla!” Jungajukulu pirri-manu. ");
INSERT INTO wbp_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ngularla Puwaja wangkaja nyanungu-nyanguku warlaljaku, wangkajarla, “Nayumi pina-yanurnu Muwapu-jangka. Yungu nganta jali-mani nguru kujalparla karrija ngalipa-nyangu warlaljaku Limilikiki. ");
INSERT INTO wbp_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ngajurna manngu-nyangu kuja yungurnangku wangkami. Kajinpa ngampurrpa nyina payi-maninjaku yinya nguruku, ngulaju kutu payi-manta! Payi-manta yapa panu-puru kuja kalu nyina nyampurla manu purlka-paturla kuja kalu-ngalpa yapaku wiriwiri nyina nyampurla. Kajinpa ngampurrpa-wangu nyina, ngulajuju wangkayaju ngajuluku. Ngaju jinta karna nyina nyampu nguruku pina payi-maninjaku. Kajinpa yampimi payi-maninja-wangurlu, ngulaju ngajulurlu kapurna payi-mani.” Ngularla nyanunguku warlalja wangkaja, “Ngajulurlu kapurna nguruju payi-mani.” ");
INSERT INTO wbp_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ngula-jangka, Puwajarla wangkaja nyanunguku, “Kajinpa payi-mani nguru yinya Nayumi-kirlangu, ngulakungarntiji yungulpanpa yupukarra-jarriyarla-wiyi Ruurtu-kurlu yangka Nayumi-kirlangu kanajardu-nyanu-kurlu yangka kuja kali-puka-jarrija. Nyanunguju karnta Muwapu-wardingki. Kajinpala-jana nyuntu-jarrarlu mardarni kurdukurdu, ngulaju kapulurla nyinami yinyaku watiki kuja lawa-jarrija kamparru. Manu nguruju kapu-jana yinya-kurlangu wati-kirlanguku warlaljaku karrimi.” ");
INSERT INTO wbp_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Wati warlalja nyanungu-nyangurlu yalu-manu, “Junga-jala! Kulalparna payi-mantarla nguruju. Kajilparna payi-mantarla, kajikarna marda nyiyarningkijarra ngaju-nyangu yampinyi-jangka wajawaja-mani kajirna pali. Yungurna-jana yinyi ngajuku kaja-nyanu-patukuju. Lawa, kulalparna payi-mantarla nguruju. Nyunturlungku payi-manta!” ");
INSERT INTO wbp_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Nyurru-wiyi Yijiralirla, kuja kalalu payi-manu nguru, jintangku yapangku kalarla wirliya-kurlangu jinta yalyi-maninjarla yungu yapa jinta-kariki. Kujarlunya kalalu-nyanu yungu nyanungurrarluju yapa panu-pururlu yungulu yapangku milya-pinyilki nganaku karla ngunami nguruju. ");
INSERT INTO wbp_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Warlaljarla wangkaja Puwajaku, “Payi-manta nyampuju nguru nyuntulurlu.” Yalu-manu, “Yuwayi, mani karna ngajulurlu.” Ngula-jangka yalyi-manulku wirliya-kurlangu jinta. ");
INSERT INTO wbp_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ngula-jangka, Puwaja-jana wangkaja purlka-patuku manu panu-kariki kujalpalu warru karrija, wangkaja-jana, “Nyurrurlarlu kankujulu nyanyi milpangku jalangurlu kuja karnarla nguru jurnta payi-mani Nayumiki. Payi-mani karna nyiyarningkijarra kujalpa-jana ngunaja Limilikiki, Kilanaku manu Malanaku. ");
INSERT INTO wbp_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ruurtujulpa nyinaja kali-nyanu Malana-kurlangu-wiyi. Ngulaju ngula-juku. Ngajulurlulku karnaju mani Ruurtu ngumparna-nyanu yungurnarla marlaja mardarni nyiyarningkijarra kali-nyanu kamparru-warnu-kurlanguku. Kajirlijarra kurdu palka-mani, kapu wati nyurnu-kurlangu kirda-nyanu-kurlangu nyinami. Kuja-juku kapulu yapa-paturlu nyampu-wardingki-paturlu manngu-nyanyi wajawaja-maninja-wangurlu. Nyurrurlarlu kankujulu nyanyi milpangku nyampurla jalangurlu.” ");
INSERT INTO wbp_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Junga-juku, yangka yapa-patu manu purlkapurlka kujalpalu kiirti-wana nyinaja, wangkajalurla Puwajaku, “Yuwa, nyangurnangkulu milpangku. Nyampu karnta kapu yanirni nyuntu-nyangu yuwarli-kirra.” Ngula-jangkalurla wangkaja Puwajaku, “YAAWIYI-rli yungungku warrawarra-kanyi yungu nyuntu-parnta nyinami ngurrjulku yangka Rajulu-piya manu Liiya-piya. Kurdu panu-pala-jana mardarnu. Junga, yapalu panu-jarrija Yijiralirlaju. Yungunpa pirrjirdi-jarrimi nyampuku nguruku Yiparataku! Yungunpa kaji nyina Pijilimirla!” Ngula-jangkalu-jana wangkaja Puwajaku manu Ruurtuku, ");
INSERT INTO wbp_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","“Tamururlurla mardarnu Juurdaku kaja-nyanu Piiriji. YAAWIYI-rli yungungkupala kurdu yinyi nyumpalaku. Manu yungulu nyumpala-nyangu warlalja-wati nyina ngurrju Piiriji-piya!” ");
INSERT INTO wbp_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Junga-juku, Puwaja yupukarra-jarrija Ruurtu-kurlu. YAAWIYI-rla yimiri nyinaja Ruurtuku yungu juni-parnta-jarrimi. Ngaka karrmulypa-jarrija kurdu wirriya-kurlu. ");
INSERT INTO wbp_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Karnta-patulurla Nayumiki wangkaja, “Yati-wangkayarla YAAWIYI-ki kujangku yaparla-puraji yungu. Yungu kaji nyinami Yijiralirla. ");
INSERT INTO wbp_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Kapungku pirrjirdi-mani, manu kapungku warrawarra-kanyi kajinpa muturna-jarrimi. Kujaju kangku kanajardu-puraji ngurrju yulkami-nyayirni, manu ngurrju-nyayirni kangku nyina yapa jinta-kari-piya-wangu. Palka-manungku wirriya yaparla-puraji nyuntuku.” ");
INSERT INTO wbp_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nayumirli manu yurntalu-nyanu-kurlangu wirriyaju, ngula-nyanu ngamirlji-kirra yirrarnu, ngulalpa warrawarra-kangu. ");
INSERT INTO wbp_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Karntakarntarlu Pijilimi-wardingkirlilirla yirdiji yirrarnu wirriyakuju. Nyampu-patu karntakarntalu wangkaja, “Nyampu wirriyarla palka-jarrija Nayumiki.” Ngulalurla yirdiji yirrarnu Yuputu. Yuputujulpa nyinaja Jiijikipalangu, manu Jiijijilpa nyinaja Tapitikipalangu. ");
INSERT INTO wbp_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Nyampurraju warlalja-patu wati Piiriji-jangka. Piirijijilpa nyinaja Yijirunukupalangu. ");
INSERT INTO wbp_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Yijirunujulpa nyinaja Raamakupalangu. Raamajulpa nyinaja Minatapakupalangu. ");
INSERT INTO wbp_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Minatapajulpa nyinaja Naajanakupalangu. Naajanajulpa nyinaja Jalmanakupalangu. ");
INSERT INTO wbp_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Jalmanajulpa nyinaja Puwajakupalangu. Puwajajulpa nyinaja Yuputukupalangu. ");
INSERT INTO wbp_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Yuputujulpa nyinaja Jiijikipalangu, manu Jiijijilpa nyinaja Tapitikipalangu. ");
INSERT INTO wbp_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","YAAWIYI Kaatu, yungurnangkurla pulka-pinyi nyuntu-kuju purlapa yunparninjarlu: Ngaju kanpaju warrawarra-kanyi jakumanu-piyarluju. Jakumanurlu kajana jiyipi warrawarra-kanyi ngurrjungku. Wardinyi karnangku marlaja-nyina nyiyarningkijarra-kurlu. ");
INSERT INTO wbp_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Ngajulujurna wukayi, ngulaju kanpaju kanyi yama-kurra walyka-kurra. Ngajulujurna yarnunjuku, ngulaju kanpaju kanyi miyi ngarninjaku. Ngajulujurna purraku, ngulaju kanpaju kanyi mulju-kurra ngapa ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ngajuluju kanpaju kanyi yungurna pirrjirdi-jarri. Junga-nyayirnirli kanpaju milki-yirrarni jungarniki yaninjaku. ");
INSERT INTO wbp_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","YAAWIYI, wangka karnangku, ‘Nyampuju karna lanilani-jarri wuurnpa-puru.’ YAAWIYI, wangka karnangku, ‘Nyampuju karna lanilani-jarri munga-puru.’ Kuja-puruju ngalijarraju wungu karli yani. Nyuntuku karnangku marlaja-nyina lani-wangulku. Nyuntu kanpaju palkangku warrawarra-kanyi. Jukati-kirlirli kanpaju ngajuluku ngarlkin-mani nyiyarlangu-kujaku. ");
INSERT INTO wbp_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Yapa kajulu panu-nyayirni kulu-jarrimi. Ngajuluju ngulangkuju kajulu maju-watirli putaputa-pakarni. Nyuntulurlu kanpa-jana warla-pajirni ngaju-kujaku murrumurru-maninja-kujakuju yungu-julu wiri-pajirnilki. Panu-jarlu kanpaju yinyi kurapakaju, nyanyi kajulu ngarninja-kurra. Nyuntu kanpaju jaraju yaarl-winjirni jurru-kurraju, ngula-kurlurluju kanpaju wiri-pajirni. Nyuntu kanpaju warrarda winjirni pamaju kartaku-kurra yungunpaju wiri-pajirni. Ngula-jangkaju pirrjirdilki karna nyinami pirda-kurluju. ");
INSERT INTO wbp_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","YAAWIYI, ngajuju karnangku wala-nyinami. Nyuntu kanpaju tarnnga-juku nyina yimiri ngajulu-kuju. Ngajulukuju ngurrju-juku kapunpaju warrarda nyina. Tarnnga-juku kapurna nyina yuwarlirlaju nyuntu-nyangurla. Ngula-juku karnangku pulka-pinyi nyuntulukuju. ");
INSERT INTO wbp_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Parrangka jintangka, YAAWIYI Kaatu wangkajarla yirdikiji Juunaku Yamitayi-kirlanguku kaja-nyanuku. ");
INSERT INTO wbp_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Purda-nyangkaju yirriyirrirli! Yani kanpa jalangu yali-kirra kirri wiri-kirra yirdi Ninupu-kurra. Maju karna-jana nyanyi, kajikarna-jana ngaju-nyangu-kurlurlu yartarnarri-kirlirli riwarri-mani. Ngula-kujakuju, yaninjarla-jana punpun-ngarrika yapa parliyaku.” ");
INSERT INTO wbp_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Juuna wangkaja-nyanu, “Nyarrpara-kurrarna wuruly-yani YAAWIYI-kijaku? Mardarna wuruly-yani wurnturu karlumpayi nguru-kari-kirra Payini-kirra.” Junga-juku, Juuna kula yanu Ninupu-kurra kakarrumpayi, kala lawa. Kala yanu kirri-kari-kirra yirdi-kirra Jaapa-kurra-wiyi. Kuja yukajarra, nyangu pawurtu kujalpa wurdujarra-jarrija yaninjakungarnti wurna Payini-kirra. Yanurra Juunaju, pawurtu-wardingkiki paajuku wangkajarla, “Nyampu karnangku tala yinyi yungurna yani Payini-kirra.” Ngula warrkarnu wati panungkajinta. Yarnkajarralkulu. Juunaju yungu nganta wuruly-parnkayarla YAAWIYI-kijaku. ");
INSERT INTO wbp_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","Kulkurrukulkurrulkulpa yanurra pawurtuju wurnturu kulkurrirni mangkururlaju. Ngula-puru yukaja Juunaju kanunju-kurra, kankarlu-ngurlu jitija kanunju-kurra pawurturlaju, jardalpa ngunanja-yanu. Ngula-jangka, warlpa wiri manu ngapa wiri yilyajarni-jana jangkardu YAAWIYI-rli. Ngapangkujulpa pawurtuju yurnkuyurnku-manu, puta rdilyki-pungu. Pawurtu-wardingki-patuju lani-jarrinjarla purlajalpalurla kurruwalpaku nyanungurra-nyanguku yungu nganta-jana muurl-mardarni yukanja-kujaku ngapangka-kujaku. Ngula-puru, jurnarrpajulpalu kijirninja-yanu warlingki-maninja-kujaku rampaku-karda. ");
INSERT INTO wbp_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Watiji yanu pawurtu-wardingki wiri kanunju nyanjaku, ngula parlu-pungulku Juunaju jarda ngunanja-kurra. Ngularla wangkaja Juunakuju, “Nyarrpa kanpa nyuntu-pukanya jardaju ngunami? Kala yinya-paturlu kuja kalu laningkilki jata-nyanyi. Yakarra-pardiyayi! Wangkaya-ngalparla nyuntu-nyanguku kurruwalpaku. Kapu marda-ngalpa purda-nyanyi lani purlanja-kurra. Kajika-ngalpa wankaru-mani marda ngapa-kujaku!” ");
INSERT INTO wbp_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Pawurtu-wardingki-patu, wangkajalu-nyanu, “Nyampurla-juku marda-ka yapa jinta nyina maju marda? Jalangurluju karlipa pirli yirrarni yirdi-kirli panu-kurlu ngalipa-kurlu parrungkulparlaju.” Ngula-jangkaju, parrungkulpajulu jaruny-yirrarnu walya-kurra, ngulajurla pirliji jinta marlaja wantija YAAWIYI-ki yirdi-kirli Juuna-kurlu. ");
INSERT INTO wbp_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ngulalu payurnu Juuna, “Nyuntu-nyangu yirdiji nyampu-waja pirlingka! Nyarrpa-jarrija mardanpa nyuntuju? Nyiyakunpa yanurnu nganimpa-wanaju? Nyarrpara-ngurlunpa yanurnu? Nyarrpara nguru nyuntu-nyanguju? Ngana nyuntu-nyangu warlalja?” ");
INSERT INTO wbp_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Juunarlu yalu-manu-jana, “Ngajujurna Yipuru. Ngaju karna pura yirriyirrirli Kaatu yirdiji YAAWIYI. Nyanunguju YAAWIYI kuja-ka nyina nguru-nyayirni-wangurla, kuja ngurrju-manu walya manu ngapa. ");
INSERT INTO wbp_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Ngajurnarla jurnta parnkaja.” Kujalu pawurtu-wardingkirli yimi purda-nyangu jurnta parnkanja-warnu, pirlirrpajulu ngarrurda-jarrijalku lani-nyayirni. Ngulalurla purlajalku, “Waraa! Nyiyakunparla jurnta parnkaja?” ");
INSERT INTO wbp_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Warlpa manu ngapalpa-pala yarda kilji-jarrija. Ngulalu payurnu pawurtu-wardingki-paturluju, “Nyarrpa-manirnangkulu nyuntuju yungulpa-pala nyampu mangkuru manu warlpa yatarnpirri-jarriyarla?” ");
INSERT INTO wbp_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Juuna-nyanu jangku-wangkaja, “Ngaju-panurla nyampuju warlpa yilyajarni. Ngula-kujakujulu julyurl-kijika ngapa-kurralku. Ngula-jangkarlanya yungu yatarnpirri-jarrilki.” ");
INSERT INTO wbp_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Kala lawa, kulalu julyurl-kujurnu. Ngula-jangkaju, pawurtulpalu puta kurruly-yirrarnu watiya-kurlurluju kirrirdi-kirlirli yungulu nganta pina-kurruly-yirrakarla pina pirntinyarra-pirdi-kirra walya-kurralku. Kala lawa. Ngapangkujulpa-jana warru jarrwara-manu-juku. ");
INSERT INTO wbp_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ngula-jangkaju, warlkirninjarlalkulurla purlaja YAAWIYI-ki, ngulaju kuja “Waraa! Juuna-wajangku jurnta parnkaja nyuntukuju nganimpa-wangu. Nyuntunyanpa-nganpa jangkardurnu yilyajarni warlpa wiri manu ngapa. Kajirnalu wati nyampu-wiyi julyurl-kijirni ngapa-kurra, yampiya-nganpa nganimpaju kumpuly-nyanja-wangurlu!” ");
INSERT INTO wbp_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ngula-warnuju, pawurtu-wardingki-paturluju, jarna-maninjarla julyurl-kujurnulu mangkuru-kurra. Ngula-warnuju, mangkuruju yatarnpirri-jarrija. ");
INSERT INTO wbp_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Pawurtu-wardingki-patujulpalurla lani-jarrija-nyayirni YAAWIYI-kiji. Purranjarla yungulurla mangarri yawuru-maninjaku, kajika-jana marda pinyi-jiki. Ngula-jangka, wangkajalurla, “Kapurnangkulu tarnngangku-juku purami.” ");
INSERT INTO wbp_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yangka kujalu julyurl-kujurnu Juuna ngapa-kurra, ngulakujurla jangkardu yilyajarni yawulku wiri-jarlu ngapa-ngawurrpa YAAWIYI-rli. Ngulangkuju muru-pungu wanapi-juku miyalu-kurra. Yangka Juuna, nyinajalpa yawungka kanunju miyalurla-juku parra-patuku marnkurrpaku. ");
INSERT INTO wbp_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Ngulalpa Juuna nyinaja miyalurla yawu-kurlangurla, ngulajurla wangkaja YAAWIYI-ki nyanungu-nyanguku Kaatuku: ");
INSERT INTO wbp_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Waraa, YAAWIYI! Ngajulparna kanunju-jarrinja-yanu ngapangka. Ngajurnangku purlajarra yinpaju muurl-mardarni. Yuwayi, junga-jukunpaju muurl-mardarnu! Kapurna paliyarla-jala. Kujarnangku purlajarra, ngulanpaju purda-nyangu. ");
INSERT INTO wbp_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Nyuntunpaju julyurl-kujurnu ngapa-kurra kaninjarra-nyayirni kujalpa kunyakunyaju kutulku ngunaja kanunjuju. Ngapajulpa warrukirdikirdi ngunaja ngaju-wana. Ngapangkujulpaju ngardapaly-kujurnu kuja-purda manu kujarni-purda. ");
INSERT INTO wbp_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Manngu-nyangulparnaju ngajuju, ‘Kaaturlu kaju mamparl-pinyi tarnnga-kurra-juku. Ngajulurluju kularna nyanyi pina YAAWIYI Kaatu yalirla Yuwarli Maralypirla Jurujulumurla.’ ");
INSERT INTO wbp_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Ngapa kujaju wapirrijalku, ngula-puru-jukuju karrkarda-ngarnu mulyu-wana manu waninja-kurra, kapurna paliyarla-jala. Mangkururluju muru-pungu-nyayirni. Yartura-piyarluju marna-jangkarluju muku warurnu jurru-wanaju. ");
INSERT INTO wbp_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Yukajarrarna parlju-kurralku kaninjarra, kuja-ka pamarrpa yintirdi karrimi yali kanunju-nyayirni, kuja-ka kankarlarra-kari warrkini. Ngulangkajulpaju larlarl-mardarnu ngapangkuju wuurnpa-nyayirnirla. Kularna nyarrpa wilypi-pardiyarla. Waraa, YAAWIYI Kaatu ngaju-nyangu! Nyuntulurlunpaju wankaru-manu! ");
INSERT INTO wbp_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nyurru-jala kapurna paliyarla, purlajalkurnangku nyuntuku. Nguru-nyayirni-wangu-ngurlu maralypi-ngirlinpaju purda-nyangu! ");
INSERT INTO wbp_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Yapangku ngula kalu purami pirlirrpa-kari kurruwalpa, yali yapa kulalpa-jana muurlparlu mardakarla palinja-kujaku. Kaaturlu yungulpa-jana maju-wati yali kurruwalpa-kurlangu-patu yimirirli-jiki mardakarla. Kala lawa! Nyanungurrarlu kalu mamparl-pinyi purda-nyanja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ngajulurlulku karnangku pulka-pinjarla yunparni. Ngaju kapurnangku yunparninja-karrarlu purranjarla yinyi kuyu warntarri nyuntuku. Ngaju karnangku junga wangka, kapurnangku tarnngangku-juku purami nyuntuju. Kularnangku jurinyki-yirrarni. YAAWIYI-jiki jinta-ka nyina yapaku muurlpakuju mardarninjaku!” ");
INSERT INTO wbp_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ngula purda-nyangu Juuna wangkanja-kurra, ngula-jangkarluju YAAWIYI-rli Warlalja Wiringki ngarlungarlu-manu yawuju yungu pina-yurlkuly-yirrarni Juuna walya-kurra. Junga-juku, yawungkuju walya-kurralku kujurnu. ");
INSERT INTO wbp_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ngularla yarda wangkaja japaku-karilki YAAWIYI-ji Juunakuju, ");
INSERT INTO wbp_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Yanta yali-kirra Ninupu-kurra kirri wiri-kirra. Punpun-ngarrika-jana, nyampunya yangka kujarnangku kamparru-wiyi wangkaja.” ");
INSERT INTO wbp_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yijardulkurla ngungkurr-nyinaja YAAWIYI-ki Juunaju. Nyanunguju yarnkajarra Ninupu-kurraju wurnturu-nyayirni-kirra. Yaliji kirri ngulaju wiri-jarlu-nyayirni jarla-wanawana. Kajilpa ngana-puka yapa ngampurrpa nyinayarla jingijingi yaninjaku Ninupurlaku, ngulaju kajika wapami karlarra-ngurlu kakarrara-kurra ngulaju marda ngurraku marnkurrpaku. ");
INSERT INTO wbp_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Kala kuja yukajarni Ninupu-kurralku Juuna, ngulajulpa kulkurru-wanalku yaninja-yanu parrangka jingijingi, kuja-jana wangkaja parliyakuju, “Ngaka 40-pala parra-jangka, YAAWIYI-rliji kapi-nyarra riwarri-mani nyurrurla yapa manu nyampuju kirri. Ngulangkaju kapu ngunami walya-mipa.” ");
INSERT INTO wbp_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ngulalurla yapa Ninupu-wardingki-patuju yijardu-jarrija Juunarlu kuja-jana yimi-ngarrurnu yimi Kaatu-kurlangu, ngulalu ngarrurda-jarrija purda-nyanjarla, “Waraa! Junga-waja! Nyarrpa-jarrimirlipa? Pinarlipa-nyanu yinyi Kaatu-kurra. Wurra, miyi ngarninja-wangu-wiyirlipa nyina, manu wawardarlarlipa yuka puturrputurrparla-wiyi yungurlipa yalala-yirrarni!” Junga-juku, panujukulu miyi ngarninja-wangu nyinaja wiriwiri manu panu-karirlangu yapa, manulu yukaja wawardarla puturrputurrparla. ");
INSERT INTO wbp_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Yangkangku yalirli wiringki kingirli Ninupu-wardingkirli, purda-nyangu-jana yimi yapa panu-kari kujalpalu wangkaja miyi ngarninja-wangu lawaku nyinanjaku. Nyanunguju rarringki yakarra-pardija nyinanja-kurlangu-ngurlu wiri-ngirliji, yalyi-manulku-nyanu jinajina-piya kirrirdi nyanungu-nyanguju, ngula yukaja puturrputurrparla wawardarla, ngula yaninjarla pirri-manu yurlpulyparla. ");
INSERT INTO wbp_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ngula-jangka, yirrarnulpa kuruwarri, ngulaju yilyaja-jana kurdungurlu-patu warrukirdikirdi Ninupurla kuruwarri-kirli yapa-patuku yungulu-jana yimi-ngarrirni. Nyampunya-ka kuruwarriji karrimi: Ngajulurlu kingirli nyurrurla-nyangurlu manu ngaju-nyangurlu kurdungurlu-watirli, yirrarnurnalu-nyarra nyampuju kuruwarri nyurrurlaku yapaku panuku parliyaku. Nyurrurlarlu, purda-nyangkalu-nganpa yijardurlu! Nganangku-puka kulalpa nganjarla ngapa, kuyu, miyi YAAWIYI-ki yalala-yirrarninjakungarnti. Manu warla-pajikalu-jana puluku, jiyipirlangu nyiyarlangu ngarninja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Nyurrurla panujukulu yukaya wawarda puturrputurrpa-kurra, manu puluku manu jiyipirlangulu-jana yukanja-yirraka wawarda-kurraju! Yayi-pantirninja-karralurla purlaya mularrpa-nyayirni Kaatuku! Panujukulu-nyanu ngurrju nyinaya jintangka-juku maju-wangu manu murrumurru-maninja-wangu! ");
INSERT INTO wbp_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Kajika-ngalpa marda nyanungu-jarrinjarla mari-jarri. Kajika-ngalpa marda ngurrju nyinami kulu-wangu. Manu kajika-ngalpa marda yampimi pinja-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Junga-juku, nyangu-jana Kaaturlu yapa kujalpalu nyanungu-kurra-jarrija. Jungarnilkilpalurla nyinaja, manulu muku yampija punkuju. Junga-juku, Kaatuju nyanungu-jarrinjarla mari-jarrija-jana. Kapu-jana kamparruju pungkarla-wiyi. Kala lawa, yampija-jana yapa panu-juku manu kirri manu puluku manu jiyipi. ");
INSERT INTO wbp_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ngula Juunajurla kulu-jarrija kanunjumanyumpa-nyayirni YAAWIYI-ki, kaji nganta-jana muku pungkarla-wiyi yangka yapa panu-juku. Ngula-ngurlunya kulu-jarrijarla. ");
INSERT INTO wbp_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Juunarluju ngulajulpa kuurljirri-mardarnu tarnngangku-juku YAAWIYI-ji. Ngula-jangkaju, wangkajalkurla Juunaju, “Ninupu-wardingki-paturlangukunpa-jana yawuru-jarrija pinja-wangu. Kujarlanya karnangku kulu nyina. Nyurru-wiyi kujalparna nyinaja ngurrararla ngaju-nyangurla, milya-pungulparnangku ngurrju-juku nyuntuju. Manu warrawarra-kanyi kanpa-jana yapa panu, manu mari-jarri kanpa-jana. Kajinpa ngampurrpa nyina yapaku majuku pinjaku, kuja-kujakuju kanpa-jana wurra-juku pardarni yungungkulu kurnta-jarrinjarla kulpari yani. Kajingkili nyuntuku kalkurnu-purda-jarri, ngulakuju kanpa-jana yawuru-jarrimi, pinja-wangulku. Yangka kujanpaju wangkaja yaninjaku Ninupu-kurra yapaku warnkiri-maninjaku, kulalparna ngampurrpa nyinaja. Ngula-kujakunyarna wuruly-parnkaja Payini-kirraju. ");
INSERT INTO wbp_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ngulaju ngula-juku karnangku warlkirninjarla payirni yungunpaju pinyi ngaju. Kula karnaju ngajuju ngampurrpa nyina wankarukuju nyinanjakuju.” ");
INSERT INTO wbp_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","YAAWIYI-rli jangku-manu Juuna, “Nyiya-jangkarlu kanpaju ngajuju warlurr-yirrarni? Kujaju kula ngurrju!” ");
INSERT INTO wbp_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Ngula-jangkaju, yarnkajarralku Juuna kakarrara kirri-ngirliji. Ngula-jangkarluju, yamalku-nyanu nganturnu, ngulangkaju yamangkaju ngantirninjarla pirri-manulku kaninjarni. Ngulalparla piirr-pardija Kaatuku yungu nyanyi kaji nyarrpa-mani yali kirri Ninupu. ");
INSERT INTO wbp_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ngula-jangkaju, YAAWIYI Kaatukujurla marlaja pardija ngalyipiji yaruju-nyayirni kankarlumparra yungurla parntarri yama Juunaku wanta-kujaku walyka-karda. Juunajulparla nyinaja pukurlpukurlpa-nyayirni ngalyipikiji. ");
INSERT INTO wbp_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ngula-jangka, mungalyurru-kari rangkarrkurlu parrarl-pantirninja-puru, Kaaturlu jangkardu yilyajarni wayipi yungurla jurnta ngarni yintirdi, ngula wayipirliji jurnta ngarnurla kulkurru-wana yintirdi-wana yintirdiji. Ngalyipiji palija linjilki ngarninja-warnu. ");
INSERT INTO wbp_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Kuja wantalku kankarlu-jarrija, Kaaturlurla jangkardu yilyaja warlpa wiri ngawurrngawurrpa-nyayirni kakarrara-ngurlu. Ngula-puruju, wantangkujulpa jankaja jurrulku kankarlarni. Juunaju wanta-jangka wirrirlpalku wapaja. Manu wangkaja, “Nyiyakurna nyina? Yungurna kutu palimilki.” ");
INSERT INTO wbp_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kaaturla wangkaja, “Nyiya-jangka kanparla kuurljirri-mardarni ngalyipikiji kapi yangka kujarnarla jangkardu yilyajarra wayipi? Kujaju kula ngurrju!” Juunarla wangkaja, “Yuwayi, kujaju ngurrju kuja karnarla kulu-jarri! Kapurnarla tarnnga-juku jankami-nyayirni!” ");
INSERT INTO wbp_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","YAAWIYI-rla wangkaja Juunaku, “Nyampu ngalyipi kuja pardija jintangka mungangka, manu munga-pardu-karirlaju palijalku. Kulanpa nyuntulurlu ngurrju-manu ngalyipi kuja pardija, manu kulanpa karrinja-yirrarnu. Kala kuja ngalyipi palija, nyuntunparla wajampa-jarrija yapa-piyaku. ");
INSERT INTO wbp_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Kala nyiya-jangka kula kanpa-jana wajampa-jarri nyuntuju Ninupu-wardingki-patuku yapaku? Ngulaju kalu-ngarra yirdiyi-paturla-jala parliya nyinami manu matirni yapaju 120,000-pala marda, manu marda 130,000-pala, manu pulukurlangu panu-yijala. Nyuntu kanparla wajampa-jarri ngalyipiki yalumpuku. Ngajuju karna-jana miyalu kanunjumanyumpa-nyayirni wajampa-jarrimi yapaku parliyaku Ninupu-wardingki-patuku.” Kujanyarla wangkaja Juunaku YAAWIYI-ji. ");
INSERT INTO wbp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jijajiji palka-jarrija Tapiti-kirlangu-ngurlu manu Yipuruyamu-kurlangu-ngurlu turnu-warnu-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6a","Nyampurrajulu yirdi-patu Jijaji-kirlangu nyurnunyurnu kujalpalu palka-jarrinja-yanu Yipuruyamu-ngurlu Tapiti-kirra: Yijaki, Jakupu, Juurda manu nyanungukupurdangka-patu; Juurda nyinajalpa-palangu kirda-nyanuju Piirijiki manu nyanungukupurdangkakuju kukurnu-nyanukuju Jiiraku. Tamuru nyinajalpa-palangu ngati-nyanu Piirijikiji manu Jiirakuju; Yijirunu, Raama, Yaminitapa, Naajana, Jalmana, Puwaja; Puwaja-kurlangu ngati-nyanuju nyinajalparla Raapa; Yuputu; Yuputu-kurlangu ngati-nyanuju nyinajalparla Ruurtu; manu Jiiji. Jiiji nyinajalparla kirda-nyanuju Kingi Tapitiki. ");
INSERT INTO wbp_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","11","Nyampurrajulu yirdi-patu Jijaji-kirlangu nyurnunyurnu kujalpalu palka-jarrinja-yanu Tapiti-ngirli Yuwajini-kirra yangka kujalu-jana Papiluniya-wardingkirli warrmarlarlu pirijina-piya kangu panu-jarlu-yijala Yijirali-pinki yapa nguru-ngurlu nyanungurra-nyangu-ngurlu jinta-kari-kirralku kirri-kari-kirralku wurnturu Papilunu-kurra kakarrara: Julumunu, ngulaju Kingi Tapiti-kirlangu ngalapi-nyanu; Ngati-nyanu Julumunukujulparla nyinaja Pajipa; Riyupuma, Yapija, Yayaju, Jiyupaja, Jiruyama, Yujiya, Jutama, Yayaja, Yijikaya, Manaja, Yaamana, Jujiya, Yuwajini manu nyanungukupurdangka kukurnu-nyanu-patu. ");
INSERT INTO wbp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Nyampurrajulu yirdi-patu Jijaji-kirlangu nyurnunyurnu kujalpalu palka-jarrinja-yanu Yuwajini-ngirli Jajupu-kurra: Yuwajini, Jiyaltilu, Jiripulpu, Yapiyu, Layikimi, Yaajuru, Jarduku, Yaajini, Yaliyurdu, Yaliyaja, Maatana, Jakupu manu Jajupu. Jajupu-kurlangu kali-nyanuju Miiri, ngulajurla ngati-nyanu Jijajiki. Jijaji yangka jinta kuja karlipa ngarrirni ‘Kiraji’. ");
INSERT INTO wbp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yuwayi, nyampuju 14-pala-kari turnu-warnu-kari ngulaju yangka kujalu Yipuruyamu-ngurlu palka-jarrinja-yanu Kingi Tapiti-kirra. Manu 14-pala-kari turnu-warnu-kari ngulaju yangka kujalu Kingi Tapiti-kirlangu-ngurlu palka-jarrinja-yanu yulyurrpu panu-puru Papilunu-wangurla-wiyi yangka kujalpalu Yijirali-pinki nyinaja pirijina-piya Papilunurla. Ngula-jangkaju, 14-pala-kari-jangkarlaju turnu-warnu-kari-jangkarlaju Jijaji Kirajilki palka-jarrija. ");
INSERT INTO wbp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Miiri nyinajalpa Jijaji Kirajikipalangu ngati-nyanuju. Ngulajulparla nyurru-warnu-jala jangku-pinja-warnulku nyinaja Jajupukuju ngulaju murnma-juku jinta-jarrinja-wangu-wiyi-jiki. Miirirliji-nyanu purda-nyangu-ngarrarla kurdu marlaja mardarni Pirlirrpa Kaatu-kurlanguku. ");
INSERT INTO wbp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Miiri-kirlangurlu kali-nyanurlu Jajupurlu purda-nyangu ngula Miirilpa nyinaja miyalulku. Kula nyarrpa-jarriyarla. Kula nyiyaku marrararluju kurntaku ngurrju-mantarla yapa panungka. Kujarlaju, Jajupurlu-ngarra wurulyparlu kangkarlalku Miiri kuwurtu-kurra karlirr-mardarninja-ngarntirli. ");
INSERT INTO wbp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngulalpa-nyanu manngu-nyangu Jajupurlu Miiri-warnu, Warlalja-Wiri-kirlangu marramarrarla yanurnu jukurrparla, manurla wangkaja Jajupuku, “Jajupu, nyuntujunpa Tapiti-kirlangu turnu-warnu-jangka. Kurnta-wangu nyinaya! Kutu kangka-nyanu Miiriji yungungku nyuntukulku kali-nyanuju nyina. Yali kurdu miyalurla, ngulaju kula wati-kari-kirlangu. Pirlirrpa Kaatu-kurlangurlurla yirrarnu miyalu-kurraju. ");
INSERT INTO wbp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Miirirli kapu wirriya mardarni. Nyuntulurlu kapunparla yirdiji yirrarni ‘Jijaji’. Yirdi-ka wangka kuja: ‘Kapi-jana muurl-mardarni yapa panuju maju-kujaku manu karlirr-yaninja-kujaku.’” Kujanyarla wangkaja marramarraju. ");
INSERT INTO wbp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yangka-juku jurrku-juku yimi junga kujarla yangka milki-yirrarnu jarukungarduyuku Yijayaku nyurru-wiyi, ngulaju yirrarnu Payipulurlalku: ");
INSERT INTO wbp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kamina-warnu jinta kapu nyinami miyalu wati-kirli ngunanja-wangurla-wiyi. Nyanungurlu kapu mardarni kurdu wita wirriya. Manu kapurla yirdi yirrarni ‘Yimanyulu’.” Yirdi yali-ka wangkami, ‘Kaatu, nyinami-ka ngalipa-kurlu yapa-kurlu’. ");
INSERT INTO wbp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Junga-juku, Jajupu yakarra-pardijalku jukurrpa nyanja-warnuju. Yanu, manu Miirilki wungu-kurra-manu yangka kujarla marramarraju wangkaja jungarni-juku Jajupukuju jukurrparla maninjakuju Miirikiji. ");
INSERT INTO wbp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngula-warnuju, palka-jarrinja-wangurla-wiyi Jijajikiji, kulalpa-pala ngunaja ngurrangka jintangka, lawa. Ngula-warnurlaju, karrmulypa-jarrijalku Miiriji, ngulakuju-palarla yirdilki yirrarnu Jijaji. ");
INSERT INTO wbp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Wati jinta yirdi Yarurdu nyinajalpa wiri kingi ngurungkaju yirdingka Jurdiyarla. Ngula-puru-juku Jijajiji palka-jarrija kirri witangka Pijilimirla. Nguru-karirla, pinangkalpa-patu ngulalpalu yanjilypiri yirri-puraja kankarlarra, yanurnulu nguru-kurraju Jurujulumu-kurra. Wurnturu-kari-jangka yanurnulu nguru nyanungu-nyangu-ngurlu kakarrara-ngurlu Jurujulumu-kurra. ");
INSERT INTO wbp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ngulalu yanurnu, warru payurnulu-jana yapa Jurujulumurlaju, “Nyarrpararla kurduju palka-jarrija yungu-jana wiri nyinami yapa Juwu-patuku? Nguru nganimpa-nyangurla, nyanungu-nyangu yanjilypiri ngula milirrmilirr-wangkaja, nyangurnalu kakarrara-purda yalkirirla. Nyampu-kurrarnalu yanurnu yungurnalurla parntarrimi nyanungukuju manu pulka-pinyi.” ");
INSERT INTO wbp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ngula Yarurdurlu purda-nyangu yimi kurdu palka-jarrinja-kurra, nyanunguju kulu-jarrija manu ngampa-nyangu-nyanu. Manu yapa-patu-karirlangurlu, ngampa-nyangulu-nyanu Jurujulumurlaju. Wangkajalu-nyanu, “Nyarrpa-jarrimilki karlipa?” ");
INSERT INTO wbp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yarurdurlu-jana jaru yilyaja wiriwiriki maralypikingarduyu-patuku manu kuruwarrikingarduyu-patuku yungulu jarukuju wangkanjaku yanirni. Ngulalu yanurnu, payurnu-jana, “Nyarrpa Payipulurlaju-ka wangka yimiji? Nyarrpararla ngurungka-ngarra palka-jarri kurduju wiriji ngula kalu ngarrirni nganta ‘Kiraji’?” ");
INSERT INTO wbp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jangku-manulu, “Nyurru-wiyi jarukungarduyu jinta wangkaja nganta kapu Kiraji palka-jarri kirri yirdingkaju Pijilimi, ngula-nganpa yirrarnu Payipulurla nganimpaku: ");
INSERT INTO wbp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kirri Pijilimi nguru witangka Jurdiyarla, ngulaju wita-juku. Ngulaju ngula-juku…wiri-nyayirni-jiki-jala! Ngulangkaju nyina kalu wiriwiri Juwu-patu yapa turnu-warnu Juurda-kurlangu-jangka. Yuwayi, kurdu ngarra palka-jarri nyanungurra-nyangurla warlaljarla. Wiri-jarrimi kapu, ngarra-jana wirilki nyina. Yijirali-pinkiki nyanungu-nyanguku kapu-jana Warlalja-Wiri nyina, kapu-jana warrawarra-kanyi jiyipikingarduyu-piyarlu.’ Kuja-yijala ngula yirrarnu Kaatu-kurlangurlu jarukungarduyurlu Payipulurlaju.” ");
INSERT INTO wbp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yarurdurlu ngula yimi purda-nyangu, jaru-jana yilyaja pinangkalpa-patuku, yangka ngulalu kakarrara-ngurlu yanurnu, yungu-ngarra-jana wurulypa wangka. Payurnu-jana, “Nyangurla-wiyinkili nyangu yanjilypiriji?” Jangku-manulkulu, “Yurlyurrpu-jarra-warnurlarnalu nyangu nyurru-wiyi.” ");
INSERT INTO wbp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ngula-jangka Yarurduju-jana wangkaja, “Nyurrurla wati-patu, yantalu Pijilimi-kirra, warru nyangkalurla yangka kurdu wita wirriyaku. Kajinkili parlu-pinyi, yantarnili pina yungunkujulu yirri-pura yungurna ngajurlangu yani yungurnarla kamparru parntarrinjinirra nyanunguku.” ");
INSERT INTO wbp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yali-jangka pinangkalpa-patu yanulu Jurujulumu-ngurlu Pijilimi-kirra. Yangka nyanungu yanjilypiri, nyangujukulu yalkirirla, yangka kujalu nyurru-wiyi nyangu kakarra-purda yalkirirla. Kamparru yanu-jana yanjilypiriji yalkirirlaju. Yali-jangkaju jupu-karrija yuwarlirla kankarlarni kujalpa kurdu wita ngunaja. ");
INSERT INTO wbp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ngulalu nyangu pinangkalpa-paturlu yanjilypiri, wardinyi-jarrija-nyayirnilirla. ");
INSERT INTO wbp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yukajarnili yuwarli-kirraju, manu nyangulu kurdu wirriya ngula ngati-nyanurlu Miirirlilpa mardarnu. Ngula-jangkaju, kamparrulurla parntarrinjunu kurduku, manu pulka-pungulurla. Lakarn-manulkulu yakujuju, yungulkulurla kawurlu manu marnta-piya ngurrju-nyayirni parntirrparntirrpa, manu mirtijinirlangu jara-piya Ngula-jangkaju, yarnkajarralkulu. ");
INSERT INTO wbp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngula-jangkaju, pinangkalpa-patu kujalpalu jarda ngunaja, nyangulu Kaatu jukurrparla. Wangkaja-jana, “Kulalurla pina-yanta Yarurduku. Pina-yantalu nyurrurla-nyangu nguru-kurra yirdiyi-kari-wana.” Junga-juku, yimi-ngarrirninja-wangu Yarurduku wurdungujukulu pardijarra. ");
INSERT INTO wbp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ngula-jangkaju yangka-patu pinangkalpa-patu yarnkajarralu Jurujulumu-ngurluju mungangka jurrkungka-juku. Yangka marramarra yanurnurla Jajupukuju jukurrparla, manu wangkajarla nyanungukuju, “Pardiya, kangka-palangu nyuntu-nyangu kurdu wirriya manu nyanungu-nyangu ngati-nyanu, jirrnganja-palangu yanta Yijipi-kirra. Yarurdurlu kapurla warru nyanyi kurdukuju pakarninjakungarnti. Ngula-kujakunyalu wurulypa yanta. Nyinayalu Yijipirla tarnnga-juku. Ngaka-yijala kapurnangku wangka pina-yaninjaku nyuntu-nyangu nguru-kurraju.” ");
INSERT INTO wbp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ngula-jangkaju, Jajupuju pardija jarda-jangkaju manu munga jurrkungka-juku, pardijarralpa Pijilimi-ngirli kurdu wirriya wita-kurlu manu nyanungu-nyangu ngati-nyanu-kurlu jungarni-juku Yijipi-kirra. ");
INSERT INTO wbp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jajupujulpa nyinaja Yijipirla kurdu Jijaji-kirli manu nyanungu-nyangu ngati-nyanu-kurlu. Wurra-jukulpa nyinaja Yijipirla, murnma-juku pina-yaninja-wangu. Murnma-jukulpalu nyinaja, pardarnulpalurla Kingi Yarurduku kaji palimi. Yangka-juku jurrku-juku yimi junga kujarla yangka Kaaturlu milki-yirrarnu jarukungarduyuku jintaku nyurru-wiyi, ngulaju yirrarnu Payipulurlalku: “Wapirra Kaaturlu yajarnunjunurra Kaja-nyanuju nguru-ngurluju Yijipi-ngirli.” ");
INSERT INTO wbp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Junga-juku, Yarurdujulpa wurra-jukulpa-jana nyinaja yali-patuku pinangkalpa-patuku yungulurla pina-yanirni yimi-ngarrirninjaku yimi kurdu-kurlu. Lawa, kulalurla pina-yanurnu nyanungukuju. Milya-pungulku kujalu yimirr-yungu. Milya-pungu yangkaju yanjilypiriji kuja nyurru-wiyi palka-jarrija yulyurrpu-jarra jirrama-warnurla. Ngula-jangkaju-jana kulu-jarrija-nyayirni. Ngula-warnunya-jana wangkaja nyanungu-nyangu-patuku warrmarla-patukuju yungulu-jana yani Pijilimi-kirra muku pakarninjaku kurdukurduku wirriyawirriyaku ngurungka Pijilimirlakuju. ");
INSERT INTO wbp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Nyampuju jurrku-juku yimi ngularla Kaatu wangkaja jarukungarduyuku Jirimayaku. Nyampuju Jirimayarlu yirrarnu: “Ngajulurlurna-jana purda-nyangu yapa yulanja-kurra ngula kalu yulami kirringka Raamarla. Karnta yirdiji Rajulu ngula ngamardi-puka-jarrija, kurdu panu-jana wajawaja-manu. Yulajalkulpa-jana. Kulalu nganangku yulalyi-mardakarla.” Ngulanya Jirimayarluju yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Junga-juku, ngula Yarurduju palija, kaja-nyanulkulparla marlaja nyinaja kingi yirdiji Yakilaja. Ngula-jangkaju, Kaaturlu-nyanu yilyaja nyanungu-nyangu marramarra Jajupuku, ngula nyangu yaninjarni-kirra nyanungu-kurra jukurrparla. ");
INSERT INTO wbp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Marramarrarla wangkaja Jajupukuju, “Karrinja-pardiya, kangka-palangu kurdu wirriya manu nyanungu-nyangu ngati-nyanu, pina-kangka-palangu Yijirali-kirra. Yarurduju nyurru palija. Kulalpa nganangkulku pungkarla kurduju.” ");
INSERT INTO wbp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Junga-juku, Jajupuju pardija jarda-ngurluju, ngulaju-palangu yakarra-manu kurdu wirriya manu nyanungu-nyangu ngati-nyanu. Yarnkajarralkulu Yijirali-kirra. ");
INSERT INTO wbp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kulkurru-juku Yijiralikingarntiji yukanjakungarntiji, yimili purda-nyangu Yakilaja-kurlu ngulalpa kingilki nyinaja ngurungkaju Jurdiyarla. Ngula-kujaku, Jajupujulpa lanilki nyinaja pina-yaninjaku nguru-kurra Jurdiya-kurraju. Yali jukurrpa-karirla marramarrarla wangkaja Jajupukuju kula yaninjaku Jurdiya-kurra. Junga-juku, Jajupuju yanulku nyanungu-nyangu kurdu-kurlu manu kurdu-kurlangu ngati-nyanu-kurlu yali-wana-juku Jurdiya-wanarla ngurungkaju yatijarra-juku nguru-karikiji Kaliliyiki. ");
INSERT INTO wbp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jirrnganja-yanu-palangu yali-kirra kirri-kirra yirdiji Najariti, manu yalirla-juku-palangu jirrnganja nyinaja. Yaliji yangka jurrku-juku yimi Najariti-kirli ngula-jana Kaatu wangkaja nyurru-wiyi nyanungu-nyanguku jarukungarduyu-patuku. Nyampujulu wangka Payipurlarla: “Panu yapangku kapulu ngarrirni yali kurduju ‘Najariti-wardingki’. ");
INSERT INTO wbp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yulyurrpu panu-jangka kujalparla Jijajiji rdirri-yungu warru yimi-ngarrirninjaku, wati jinta-kari yirdiji Jaanu Papitaji yanurnu yarluyarlu nguru-ngurlu Jurdiya-ngurlu. Rdirri-yungu yirri-puranjaku yapakuju nyampu, ");
INSERT INTO wbp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Jalangu kangalpa kutulku yanirni Kaatuju ngalipakuju yungu-ngalpa Warlalja-Wirilki jirrnganja nyina. Kujarlanya, pina-yaninjarlalu yalala-yirraka Kaatu maju-jangka.” ");
INSERT INTO wbp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jaanu Papitajiji ngulaju yangka jurrku-juku kuja jarukungarduyurlu Yijayarlu yirrarnu nyurru-wiyi Payipulurla. Kuja yirrarnu Yijayarlu: “Purda-nyangkajulu! Yapa-ka warru purla manangkarrarla, ngulaju kuja-ka purlami, ‘Warlalja-Wiri kuja kangalpa nyina ngalipaku, ngulaju kapu yanirni. Ngulakuju yirdiyilirla jungarni-manta yungu yanirni rarralyparla!’” Kujanya Yijayarluju yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yangka Jaanurlu, kala jinajina-piya mardarnu yumurru-kurlu kawartawara-kurlangu manu ngalyipi-piya wiri wartirli-wana puluku-kurlangu pinti kuja kala-nyanu warurnu. Manu kala ngarnu ngarlu manu jintilyka. ");
INSERT INTO wbp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yapa panulpalu yanurnu purda-nyanjaku Jaanu kujalpa wangkaja. Yanurnulpalurla wurnturu-ngurlu Jurujulumu-ngurlu manu nguru-kari nguru-kari Jurdiya-wana-ngurlu manu Jurdunu yulpayi-wana-ngurlu. ");
INSERT INTO wbp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ngulalpalurla Jaanukuju wangkaja, “Kurnta-jarri karnalu-nyanu maju panu, manu mari-jarri karnalu-nyanu yungurnalu yalala-yirrarni Kaatu.” Ngula-jangka, ngapangkalku-jana papitaji-manu karru wiringka yirdingkaju Jurdunurla. ");
INSERT INTO wbp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yali-jangka, Juwu-patu wiriwiri jirrama-jangka turnu-warnu-jarra-jangka yangka Paraji-patu manu Jatiyuji-patu, yanulu karru Jurdunu-kurra ngulalpa-jana Jaanurlu papitaji-manu yapa. Jaanurlu nyangu-jana yaninjarni-kirra, wangkaja-jana kulu-nyayirni, “Nyurrurlajunkulu panu-juku ngulaju warna-piya maju-wati yimirr-yinja-panu! Nyurrurlarluju kankulu rampal-manngu-nyanyi kuja kankulu nganta ngurrju nganta nyina yungurna-nyarra nganta papitaji-mani, lawa. Jalangu-karrikarri Kaaturluju kapu-jana juwa-kijirninjarla yilyami yapa kuja kalu warntarla nyina. Kajinkili warntarla-juku nyina, kapu-nyarra nyurrurlarlangu yilyami tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kajinkili ngampurrpa ngajuku nyina papitaji-maninjaku nyurrurlaku, ngulakungarntirlijili pina-yaninjarla yalala-yirraka Kaatu, manulurla jungarnilki nyinaya! ");
INSERT INTO wbp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kulalu-nyanu ngarrika Yipuruyamu-kurlangu kurdukurdu nganta nyurrurla. Yijardu-wangu kujaju. Ngaju yungurna-nyarra nyampu wangka: Kajinkili warntarla-juku nyina, kapu Kaaturlu pirli warru mani, warru maninjarla kapu-nyanu ngurrju-mani kurdukurdu panu-nyayirni Yipuruyamu-kurlangu nyanunguku nyampurra-jangkaju pirli wita-jangkaju. Kujaju junga. Kajinkili maju-juku warrarda nyinami, kapu-nyarra yilyami nyurrurlaju tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yuwayi, jalangunya, Kaatuju-ka jungarnijungarni-jarrimi yungu-jana yangka yilyami yapa nyanungu-ngurlu-juku tarnnga-juku, yangka kuja kalu majumaju-juku nyinami. Kula-ngantalurla jungarni nyinayarla nyanunguku, kala lawa. Yalirra yapaju ngulaju watiya-piya kuja-ka mangarri maju-kurlu karrimi. Watiya majumaju ngulaju kuja-piyaju kapulu yapangkuju pajirninjarla kijirni warlu-kurra. Kuja-kujakuju, nyinayalurla jungarni-juku Kaatukuju! ");
INSERT INTO wbp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Jinta-kari-ka yanirni nyampu-kurraju. Nyanunguju wiri-nyayirni ngaju-piya-wangu. Nyiya-jangka mayiji milarnu yungurnarla nyanunguku warrki-jarrimi? Ngaju karna-nyarra julyurl-yirrarninjarla papitaji-mani ngapangka kujankulu pina-yaninjarla yalala-yirrarnu Kaatu. Kala Mijaya kaji yanirni yangka Kaatu-kurlangu Milarninja-warnu, ngalya-karikiji kapu-nyarra kurru-pinyi Pirlirrpa Kaatu-kurlangu nyurrurlakuju. Ngalya-kariji kapu-nyarra julyurlkijinirra warlu wiri-kirra. ");
INSERT INTO wbp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kaji yanirni nyanungu, ngulaju yangka-piya yapangku kuja-ka ngurlu kipirninjarla kirlka-mani. Kuja-ka yapangku kipirni ngurlu parraja-kurlurlu, ngurlu ngurrju ngulaju-ka mardarni ngarninjakungarntirli. Kala walya manu marna, ngulaju-ka kijirni warlu-kurra. Kuja-piya yali Kaatu-kurlangu kaji yanirni, ngulangkuju kapu-jana yirrarni yapaju yurruju-jarrarla ngurrju-patu maju-patu. Ngurrju-patu kapu-jana mampungku mardarni. Kala maju-patuju kapu-jana kijirni tarnnga-juku.” Nyampunya Jaanu Papitaji kala-jana wangkaja yapa-patukuju. ");
INSERT INTO wbp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ngula-jangkaju, ngaka-karilki Jijaji yanurnulku nguru-ngurlu Kaliliyi-ngirli karru Jurdunu-kurra. Yali jurrkungka-juku ngulalpa-jana Jaanurlu papitaji-manu yapa. Jijajirli payurnu Jaanu yungu-ngarra papitaji-mani, lawa. Jaanujulpa nyinaja kurnta-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngulaju puta wurra-manu Jijaji, wangkajalkurla, “Kularna nyuntu-piya-japa ngurrju. Nyuntujunpa wiri-nyayirni ngaju-piya-wangu. Nyiyakulkunpaju yanurnu ngajuku papitaji-maninjaku nyuntuju? Nyuntulurlulpanpaju papitaji-mantarla-wiyi ngajuju.” ");
INSERT INTO wbp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jijajirli jangku-manu Jaanu, “Kaatu kaju wangka ngajuku yungurna purami nyanungu-nyangu kuruwarri jungarnirli. Kujanyarnangku yanurnu yungunpaju papitaji-mani.” Ngula-jangkaju, Jaanu ngungkurr-nyinajarla papitaji-maninjaku Jijajikiji. ");
INSERT INTO wbp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nguru-yirrarnurla Jijajikiji karru Jurdunu-kurra, manu papitaji-manu yalirla. Ngula Jijaji yanurnu ngapa-ngurlu pirntinyarra-kurra, yalkirijirla raa-parnkaja kankarlarraju. Yalkiri kuja raa-parnkaja, ngulangkaju nyangu Pirlirrpa Kaatu-kurlangu jurlpu-piya kurlukuku-piya. Ngulaju yanurnu, pirri-manurla Jijajiki. ");
INSERT INTO wbp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ngula-jangkaju, linpa purda-nyangu wangkanja-kurralku kankarlarra-jangka yalkiri-jangka, kujarla wangkaja nyanunguku Jijajiki, “Nyuntujunpa ngaju-nyangu Kaja-nyanu marulu. Nyuntulurlunya kanpaju miyaluju raa-pinyi.” ");
INSERT INTO wbp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yali-jangkaju, Kaatu-kurlangurlu Pirlirrparlu kangu Jijaji jilja-kurra. Yalirla yungu nganta Juju Ngawungku karlirr-mardakarla Kaatu-kujaku. ");
INSERT INTO wbp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jijajirli kula nyiya ngarnu 40-pala parraku manu 40-pala mungaku, manu yali-jangkaju nyanungujulpa nyinaja yarnunjuku-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngula-jangkaju, Juju Ngawurla yanurnu yungu nganta karlirr-mardakarla Kaatu-ngurlu, wangkajalkurla Jijajikiji, “Kuja kanpa nyuntuju Kaatu-kurlangu nganta Ngalapi-nyanu nyina, wangkaya-jana nyampurraku payarrpaku, ngurrju-manta-jana mangarri-kirra yungunpa ngarni.” ");
INSERT INTO wbp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jijajirla wangkaja Juju Ngawuku, “Payipulu kanganpa kuja wangka, ‘Kajilpa nganangku-puka mangarri-mipa nganjarla, kulalparla jirrnganja nyinayarla tarnnga Kaatukuju, lawa. Ngulakungarntirliji yungulpa purda-nyangkarla Kaatuju nyarrpa kajirla wangkami.’” ");
INSERT INTO wbp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yali-jangkarluju Juju Ngawungku kangu Jijajiji kirri-kirra tarruku-kurraju Jurujulumu-kurra. Ngula kangu Jijajiji kankarlarni-nyayirni Yuwarli Maralypirla Juwu-kurlangurla manu ngulangka karrinja-yirrarnu. ");
INSERT INTO wbp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ngula-warnuju, Juju Ngawujurla wangkaja Jijajikiji, “Kuja kanpa nyuntuju Kaatu-kurlangu Ngalapi-nyanu nganta nyina, jurl-pungka Yuwarli Maralypi-ngirli nyampu-ngurluju kaninjarra-kurra walya-kurra. Nyampunya-ka wangka Payipulurlaju: ‘Kaatu-jana wangkaja nyanungu-nyanguku marramarra-patuku jina-mardarninjaku nyuntuku. Kajinpa jurl-pinyi kankarlarra-ngurlu, kapungkulu rdarri-mardarni nyuntuju nyanungu-nyangu rdakangka, kalakanpa marda rdilykirdilyki-wanti jamana pirlingkaju.’ Junga-juku, nyuntuju jurl-pungka nyampu-ngurlu Yuwarli Maralypi-ngirli!” ");
INSERT INTO wbp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngula-jangkaju, Jijajijirla wangkaja nyanunguku, “Lawa, kularna jurl-pinyi kankarlarra-ngurlu! Payipuluju-ka nyampunya wangka nganimpaku: ‘Kula jiliwirrirli payika Kaatu nyiyarlanguku, kalakangku kulu-jarrimilki!’ Ngula-jangkanya kulalparna jurl-pungkarla ngajulurluju nyampu-ngurlu kankarlarra-ngurlu!” ");
INSERT INTO wbp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngula-jangkaju, yarujurlu-juku Juju Ngawungkuju kangu Jijajiji pirli wararra-kurra kankarlarra-nyayirni, manurla milki-yirrarnu nyiyarningkijarra ngurrju-nyayirni ngurrara-kari ngurrara-karirla walya nyampurla nguru-kari nguru-kari. ");
INSERT INTO wbp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ngula-jangka wangkajarla Jijajiki, “Kajinpaju parntarrinjarla pulka-pinyi ngajuku, kapurnangku milarni yungunpa wiri-nyayirni nyina nyampurraku ngurraraku, manu kapurnangku yinyi nyiyarningkijarra.” ");
INSERT INTO wbp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jijajirliji jangku-manu nyanunguju, “Juju Ngawu, yantarra ngaju-kujaku! Payipulu kanganpa nyampunya wangka nganimpakuju: ‘Yapangkujulpalurla parntarrinjarla pulka-pungkarla nyanunguku-juku Kaatu-mipaku Warlalja-Wiriki. Nganimparlulparnalurla warrki-jarriyarla jintaku nyanunguku.’” ");
INSERT INTO wbp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yali-jangkarluju Juju Ngawungku yampijalku Jijajiji, manu pardijarralku. Ngaka-karilki marramarra-patulurla yanurnu Jijajiki jina-mardarninjaku. ");
INSERT INTO wbp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngula-jangkaju, Jijajirliji yimi purda-nyangu ngulalu yurrkunyu-paturlu Jaanu Papitaji yirrarnu rdakungka. Ngula pina-yanu nguru Kaliliyi-kirra. ");
INSERT INTO wbp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kirri-kirra Najariti-kirra-wiyi yanu, kula yalirlaju jupu-karrija. Jingijingi-yanurra kirri-kari-kirra yirdi-kirraju Kapurniya-kurra kujalpa karrija kutu-juku mangkuru Kaliliyirla, ngulangkanyalpa nyinaja. Yali kirri Kapurniya ngulajulpa karrija nguru-jarrarla yirdi-jarrarla Jupulunurla manu Napatalirla. ");
INSERT INTO wbp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nyampuju jurrku-juku jaru ngula Yijayarlu nyurru-wiyi yirrarnu Payipulurla. Nyanungurluju yirrarnu nyampu jaruju nguru-jarra-kurlu: ");
INSERT INTO wbp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nguru-jarra Jupulunu manu Napatali, parntarrimi kapala karru Jurdunu-ngurlu Mirditirini-kirra ngapa wiri-kirra. Nguru Kaliliyirlanguju-ka karrimi nguru jintangka-juku. Yalirlaju kalu nyina Juwu-wangu-patu yapa-patu. ");
INSERT INTO wbp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nyampurra yapa, nyina kalu mungangka-juku, Kaatuju kula kalu manngu-nyanyi. Ngaka-pardu-karirlaju kapulu jarra wiri-jarlu nyanyi. Ngurungka yalirla kuja kalu nyina ngulaju munga-nyayirnirla, kula-nganta rdaku-piyarla. Ngakaju, mungalyurru-karirla kapu-jana jarra-jarrimilki.” Nyampuju jaru kuja Yijayarlu yirrarnu Payipurlurla. ");
INSERT INTO wbp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ngula-jangkaju, Jijajilpa warru yanu nguru yalirla-juku wangkanja-karra yapakuju, “Jalangu kanyarra kutulku yanirni Kaatuju nyurrurlakuju yungu-nyarra Warlalja-Wirilki jirrnganja nyina. Kujarlaju, pina-yaninjarlalu yalala-yirraka Kaatu maju-wangurlu!” ");
INSERT INTO wbp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ngaka-pardu-karirlalku, Jijajijilpa wapanja-yanu pirntinyarra mangkuru Kaliliyi-wana. Ngula-palangu rdipija Jimaniki manu nyanungukupurdangka kukurnu-nyanuku Yanturuku kuja kala-pala warrki-jarrija yawukungarduyu-jarra. Ngulalpa-palarla kujurnu yakuju-piya wiri-jarlu rdarri-mardarninjaku yawuku. Jimani yirdi-kari ngulaju Piita. ");
INSERT INTO wbp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jijajiji-palangu wangkaja, “Purayaju-pala! Yangka kuja kalanpala yawu manu, ngula-piya-yijala kapurnangkupala pinarri-mani yungunpala-jana yapa yajarninjarla turnu-mani Kaatukulku.” ");
INSERT INTO wbp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Junga-juku, yampinja-yanu-pala yakuju-piyaju ngulangka-juku. Yampinjarla Jijajilki-pala puraja. ");
INSERT INTO wbp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ngula-jangkaju, yaninja-yanulpalu pirntinyarra mangkuru-wana, ngulajulu-palangu rdipija wurnturu-wangu-juku Jamajiki manu kukurnu-nyanuku yirdiki Jaanuku. Ngulajulpa-palarla jirrnganja warrki-jarrija nyanungu-jarrakupalanguku kirda-nyanuku yirdiki Jipitiki. Ngulaju pawurturlalpalu yakuju-piya larra pina panturnu. Kuja-palangu parlu-pungu Jamaji manu Jaanu, ngulakuju-palangu waa-manu, “Ngajuju-pala puraya!” ");
INSERT INTO wbp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Junga-juku, yampija-pala kirda-nyanu yalumpurla-juku pawurturla-juku. Yampinjarla Jijajilki-pala puraja. ");
INSERT INTO wbp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ngula-jangkaju, Jijajilpa warru yanu nguru Kaliliyi-wana. Nyanungurlu yapalpa-jana jungarni-manu jaaji-kari jaaji-karirla Juwu-kurlangurla, manu-jana Yimi Ngurrju yimi-ngarrurnu Kaatu-kurlu kuja kangalpa Warlalja-Wiri nyina yapaku. Ngulalpa-jana yapaju murrumurru nyangu, ngulajulpa-jana parlpuru-manunjunu. ");
INSERT INTO wbp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nyiya-jangkalpalu-jana yapaju murrumurruju kangurnu? Yimiji Jijaji-kirli warru yanu nguru-wana Jiriya-wana. Yapajulpalu-jana murrumurru nyiyarningkijarra-kurlu kangurnu. Yapa-karijilpalu murrumurru maju-nyayirni-kirli nyinaja. Yapa-karirlilpalu juju ngawungawu palkangka kaninjarni mardarnu. Yapa-karilpalu wantinjarla ngunaja yurirrinja-wangu lalka. Yapa-karijilpalu rdalji-jarrija. Jijajirli-jana muku parlpuru-manu. ");
INSERT INTO wbp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yapangku panungku purdangirli purajalpalu Jijaji. Yanurnulu Kaliliyi-ngirli Kirri Karlarla-pala-ngurlu, Jurujulumu-ngurlu, nguru-kari Jurdiya-ngurlu, manu nguru-kari-ngirli kakarrara nguru-kari kujalpa ngunaja karru Jurdunurla murrarninginti. Mukulu yanurnu puranjaku Jijajiki. ");
INSERT INTO wbp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ngula-jana nyangu Jijajirli yapa panu-jarlu yaninjarni-kirra nyanungu-kurra, ngulaju-jana yampija purdangirli. Ngula-jangkaju warrkarnu pirli-kirralku, ngulangkaju nyinajalkulpa. Ngula-jangkaju, nyanungu-nyangu kurdungurlu-patu yaninjarla wungulkulpalurla jirrnganja nyinaja. ");
INSERT INTO wbp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ngulangkaju, Jijajirli yungu-jana pinarri-manu nyiyarningkijarraku Kaatu-kurlu, kuja-jana wangkaja: ");
INSERT INTO wbp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kaatu-ka Warlalja-Wiri nyina nyiyarningkijarraku. Yapa ngana-puka kuja karla wala nyina Kaatu-mipaku, ngulakuju karla marlaja nyina wardinyi-nyayirni tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yapa ngana-puka kuja-ka mari yulami, ngulaju ngula-juku. Kaatuku karla marlaja nyina wardinyi-nyayirni tarnnga-juku. Ngulaju Kaaturlu kapu yulalyi-mardarni. ");
INSERT INTO wbp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Yapa ngana-puka kuja-ka rampaku nganta nyina kurrurru-karrinja-wangu, ngulaju Kaatuku karla marlaja nyina wardinyi-nyayirni tarnnga-juku! Kajirla wala nyina Kaatu-mipaku, ngulakuju kapurla yinyi nyiyarningkijarra kuja-jana nyurru-wiyi jangku-pungu. ");
INSERT INTO wbp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yapa ngana-puka kuja-ka ngampurrpa-nyayirni nyina Kaatuku jungarni nyinanjaku, nyarrparlangu kajirla wangka, ngulaju ngurrju-nyayirni. Kaatuku karla marlaja nyina wardinyi-nyayirni tarnnga-juku! ");
INSERT INTO wbp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yapa ngana-puka kuja kajana mari-jarrinjarla ngurrju nyina yapa ngalya-kariki yangka kuja kalu nyinami murrumurru marda, marlajarra marda nyiyarningkijarra-wangu, ngulaju ngurrju-nyayirni. Kaatuju karla mari-jarrimi-yijala. Ngulaku karla marlaja nyina wardinyi-nyayirni tarnnga-juku! ");
INSERT INTO wbp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Yapa ngana-puka kuja-ka ngampurrpa-nyayirni nyina Kaatu-mipaku warrki-jarrinjaku, ngulaju ngurrju-nyayirni. Kaatuku karla marlaja nyina wardinyi-nyayirni tarnnga-juku. Kapu ngaka Kaatuju nyanyi. ");
INSERT INTO wbp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yapangku kuja kajana warla-pajirni yapa ngalya-kari kulungka yungulu ngurrjulku nyina jintangkalku, ngulaju ngurrju-nyayirni. Kaatuku karla marlaja nyina wardinyi-nyayirni tarnnga-juku, ngulaju kapu kurdu nyanungu-nyangu-pajirni. ");
INSERT INTO wbp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yapa kuja-ka nyina jungarni Kaatu-kurlangu, ngulakuju kajilpalurla yapa ngalya-kari yaninjarla nyurunyuru-jarriyarla, ngulaju ngula-juku. Kaatuju-ka Warlalja-Wiri-jiki nyina nyiyarningkijarraku. Kuja karla yapa yali wala nyina Kaatu-mipaku, ngulaju karla warlalja nyina. Kapurla marlaja nyina wardinyi-nyayirni tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Yuwayi, ngula kankulu jungarni nyinami kurdungurlu ngaju-nyangu, ngulaju yapangku panu-karirli kajikalu-nyarra marda yangka jikarr-pajirni. Kajikalu-nyarra marda pakarni. Warlkangku marda kajikalu-jana nyurrurla yimi-ngarrirni warru. Ngulaju ngula-juku. Kaatuku kapunkulurla marlaja nyina wardinyi-nyayirni tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nyinayajukulu wardinyi-nyayirni! Manngu-nyangkalu nyampu! Kaatu-kurlangu jarukungarduyu nyurru-wiyi kuja kalalurla marlaja wangkaja, ngularrakuju kalalu-jana yapaju nyurunyuru-jarrija-yijala. Ngula-piya-yijala kalu-nyarra nyurunyuru-jarrimi jalanguju. Ngulaju ngula-juku. Ngaka-kari kajinkili nyina yangka nguru-nyayirni-wangu Kaatu-kurlangurla, ngulaju kapu-nyarra warntarri-nyayirni-wangu yinyi ngurrju-nyayirni. Ngulakungarntiji, wardinyili nyinaya nyurunyuru-puruju.” ");
INSERT INTO wbp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wangkaja-jana kuja, “Yungurna-nyarra yimi wita wangka jarlti-kirli yangka kuja karliparla winjirni kuyuku. Jarltiji ngurrju-jala kuyuku pajarninjaku. Kajilpa jarltiji maju-jarriyarla manu linpa-wangu-jarriyarla, ngulaju majulku. Kulalpa nganangku linpaju pina pirrjirdi-mantarla yangkaju jarlti. Kajilpa jarltiji linpa-wangu-jarriyarla, ngula-jangka yapangku kalu kijirni yirdiyi-kirra ngulangka yungulu katirni. Nyampurla ngurungka, nyurrurla yungunkulu-jana ngurrju nyinami jarlti-piya yapa ngalya-kariki yungulu nyinami jungarni nyurrurla-piya-yijala majungka-jarrinja-wangu. ");
INSERT INTO wbp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nyurrurlarluju yapangku kankulu jarra-nyayirni-wangu Kaatu-kurlangu mardarni kaninjarni. Ngula-kurlurlu yungunkulu-jana milki-yirrarni Kaatuju yapa ngalya-kariki. Nyurrurlajunkulu yuwarli-piya yangka kuja-ka jarra-kurlu parntarrinja-yani pirlingka kankarlarni, kulalpa nganangku palu-pungkarla. Ngula-piya-yijala yungunkulu jarra-nyayirni-wangu-kurlu nyina jungarni tarnnga-juku yungulu-nyarra nyanyi panungku yapangku. ");
INSERT INTO wbp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jarra, kuja kankulu rdulinyi mungangka, kulalpa nganangku-puka wuruly-yirrakarla kanunjumparra parrajarlaju manu pangkingkaju ngunanja-kurlangurlaju, lawa. Yarlungka kankulu yirrarni yapaku yungulu nyanyi. ");
INSERT INTO wbp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ngula-piya-yijala jarra-nyayirni-wangu-kurlu nyinayalu ngurrju yungunkulu-jana Kaatu milki-yirrarni yapaku panuku. Wuruly-mardarninja-wangurlu milki-yirrakalu-jana mirilmiril-karrinja-karrarlu. Ngula-warnuju kajili-nyarra nyanyi jungarni nyinanja-kurra, ngulaju kapulu-nyarrarla pulka-pinyi Wapirrakulku ngula-ka nyinami nguru-nyayirni-wangu kankarlarra.” ");
INSERT INTO wbp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Wangkajalpa-jana kuja, “Kulalu rampal-manngu-nyangka Mujuju-kurlangu kuruwarri, jalanguju-ka karrimi yangka-juku wiri-nyayirni-juku nyurru-warnu ngularla Kaaturlu yungu Mujujuku. Manu jaru ngula-jana Kaaturlu yungu jarukungarduyu-patuku, jalanguju wiri-nyayirni-ka karrimi-juku tarnnga-juku. Kularna yanurnu kuruwarriki manu jaruku jurnta kijirninjaku, lawa. Ngarirna yanurnu kuruwarriki pinarri-maninjaku yungunkulu milya-pinyi-nyayirni jungangku. ");
INSERT INTO wbp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngajulu karna-nyarra yimi-ngarrirni junga-nyayirni Mujuju-kurlangu kuruwarri. Ngaka-kari nguru nyampu manu yalkiri kapu-pala yawu-pardi. Ngula-wangurla-wiyiji kulalpa nganangku mirrikarla witarlangu kuruwarri Mujuju-kurlangu. Kajirna warrki muku lawa-mani nyampurla walyangka, ngulaju Mujuju-kurlangu kuruwarri kapu yawu-pardimilki. ");
INSERT INTO wbp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ngulaju junga. Nganangku-puka ngula-ka jawirri purda-nyanyi witarlangu Mujuju-kurlangu kuruwarri puranja-wangurlu, jawirri purda-nyanja-warnurlu kajilpa-jana yapa-patu-kariki pinarri-mantarla nyanungu-piyaku nyinanjaku, ngulaju maju. Ngaka-kari Kaatu-kurlangurla nguru-nyayirni-wangurla, ngulaju kulalu yapa ngalya-karirli wiri-pajirni, lawa. Nganangku-puka yapangku kaji purami Mujuju-kurlangu kuruwarri ngurrjungku, puranja-warnurlu kajilpa-jana yapa-patu-kariki jungangku pinarri-mantarla nyanungu-piyaku nyinanjaku, ngulaju ngurrju. Ngaka-kari Kaatu-kurlangurla nguru-nyayirni-wangurla, yapa ngalya-karirli kapulu wiri-pajirni nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Purda-nyangkajulu! Jungarnilirla nyinaya Kaatuku! Kulalu kuruwarrikingarduyu-patu-piya manu Paraji-patu-piya nyinaya ngula kalu jungarnirli nganta kuruwarri purami Mujuju-kurlangu ngularla Kaaturlu yungu nyurru-wiyi. Kajilpankulu rampal-yantarla nyanungurra-piya, ngulaju kulankulu yukamirra Kaatu-kurlangu-kurra nguru-nyayirni-wangu-kurra kuja kajana Warlalja-Wiri-jiki nyina.” ");
INSERT INTO wbp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wangkaja-jana kuja, “Nyurrurlarlu kankulu milya-pinyi Mujuju-kurlangu kuruwarri ngula-jana pinarri-manu yapa nyurnunyurnu nyurru-wiyi. Kuja nganta-jana pinarri-manu: ‘Yampiyalu-nyanu tarnnga-kurra pakarninja-wangurlu!’ Kujarlangu nganta-jana pinarri-manu: ‘Jinta-karirli kajilpa pakakarla nyurnu-kurra yapa, ngulaju nyanungulku yungulu kanyi kuwurtu-kurra pakarninjakungarntirli.’ Kujanya-jana Mujujuju wangkaja. ");
INSERT INTO wbp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kala jalanguju, ngaju karna-nyarra pinarri-mani nyampu nyurrurla kuja kankulu Kaatu pura: Kajirla ngana-puka jinta-kariki pinja-wangu kulu-jarri puranjakungarduyu-kariyi-nyanuku, ngulaju Kaaturlu ngarra miimii-nyanyi. Kaji nganangku-puka pinja-wangurlu punku-pajirni jinta-kari puranjakungarduyu-kariyi-nyanuju, kangkalu Juwu-kurlangu-kurra kuwurtu-kurra Jurujulumu-kurra. Kaji nganangku-puka pinja-wangurlu ngurrpa-pajirni kulungku jinta-kariji, ngulaju Kaaturlu yaliji yapa ngarra kijirni warlu wiri-kirra kuja-ka jankami tarnnga-juku.” ");
INSERT INTO wbp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kujarlangu-jana wangkaja Jijajiji, “Mardanparla jintaku yapaku rdurrjurnu, ngulaju nyuntukuju marda kangku kulu-juku nyina muntuku-nyayirni. Ngula-puruju kajinpa ngampurrpa nyinami kuyu warntarriku purranjarla yinjaku Kaatuku Yuwarli Maralypirlaku, ngulakungarntirli yampiya kuyuju Yuwarli Maralypirla. ");
INSERT INTO wbp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ngula-jangkaju, pinarla yanta yungunpa yalala-yirrarni yungunparla nyinami ngurrjulku kuja-jarra kuja-jarra. Ngula-jangkaju, pina-yanta Yuwarli Maralypi-kirra kuyu warntarri yungunparla purranjarla yinyi Kaatuku.” ");
INSERT INTO wbp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kujarlangu-jana wangkaja Jijajiji, “Mardanparla kulu-jarrija jinta-kariki yapaku nyiya-jangka marda. Kalakangku kanyi marda kuwurtu-kurra, kajikangku yinyi kuwurtukungarduyuku wiriki. Ngula-jangka kalakangku kuwurtukungarduyurlu wiringki yinyi yurrkunyu-kurra, ngulangkuju kalakangku yirrarni rdaku-kurra. Ngula-kujakuju, yarujurla pina-yanta kapanku yangkaku ngulanpa kulukukuluku-manu yungunpa yalala-yirrarni yungunparla nyinami ngurrjulku kuja-jarra kuja-jarra. ");
INSERT INTO wbp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yalala-yirrarninja-wangurla, kalakangku kuwurtukungarduyurlu wiringki punku-pajirninjarla jinyijinyi-mani talaku wiriki yinjaku yangkaku ngulanpa kulukukuluku-manu. Kalakangku tala-wangurlaju rdaku-kurra kijirni. Tala-wangurlaju lawangka ngulaju marda kalakanpa tarnnga nyina rdakungka.” ");
INSERT INTO wbp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Wangkaja-jana kuja, “Nyurrurlarlu kankulu milya-pinyi Mujuju-kurlangu kuruwarri yupukarra-kurlu: ‘Nyuntu kajilpanpa nyinayarla palka-kurlu yupukarra, kula kalykuru-jarriya yapa jinta-kari-kirli!’ Ngula kuruwarriji ngurrju-juku. ");
INSERT INTO wbp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kala jalangu, ngaju karna-nyarra pinarri-mani kuruwarri-kari nyampu: Karnta-kari-kijaku waparlku nyinaya lirlki-nyanja-wangu manu manngu-nyanja-wangu! Kajilpanpa lirlki-nyangkarla manu marri-pungkarla, ngulaju kula-nganta kanpala palka nguna wungu nyumpala. ");
INSERT INTO wbp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yuwayi, ngaka kajikanpa marda karnta-kari lirlki-nyanyi milpa-jarrarlu. Kuja-kujakuju-nyanu milpa-jarra wilypi-manta jurnta, kajikangku Kaaturlu kijirni milpa-jarra-kurlu-juku warlu wiri-kirra kuja-ka jankami tarnnga-juku. ");
INSERT INTO wbp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ngaka kajikanpa marda majungka-jarrimi, kajikanpa marda nyiyarlangu purungku-mani rdaka-jarrarlu. Kuja-kujakuju-nyanu rdaka-jarra mururl-pajika jurnta, kajikangku Kaaturlu kijirni rdaka-jarra-kurlu-juku warlu wiri-kirra kuja-ka jankami tarnnga-juku. Kajilpangku Kaaturlu kijikarla nguru yali-kirra palka wanapi-jiki, ngulaju maju-nyayirni nyuntukuju. Kala kajinpa yukamirra Kaatu-kurlangu-kurra nguru-nyayirni-wangu-kurra rdaka-jarra-wangu manu marda milpa-jarra-wangu, ngulaju ngula-juku. Kapunpa nyanungu-kurlu nyina tarnnga-juku.” ");
INSERT INTO wbp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kujarlangu-jana wangkaja Jijajiji, “Nyurrurlarlu kankulu milya-pinyi kuruwarri Mujuju-kurlangu yupukarra-kurlu. Pinarri-manu nganta-jana nyampu: ‘Kaji watingki jintangku yilyamirra kali-nyanu nyanungu-nyangu, ngulakungarntirli pipa nganta yungulparla yungkarla yungu-pala-nyanu tarnnga-juku yampimilki. Pipa yinja-wangurlaju ngulaju kulalpa yilyayarla.’ Kujanya nganta-jana wangkaja Mujujuju. Ngula kuruwarriji ngurrju-juku. ");
INSERT INTO wbp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kala jalangu, ngaju karna-nyarra pinarri-mani kuruwarri-kari nyampu: Kajilpa wati-kirlangu karntaju warru kalykuru-jarriyarla wati-kari-kirli, ngula-jangka kajilpa kali-nyanurlu yampiyarla, ngulaju ngula-juku. Kala kajilpa karntaju kalykuru-wangu nyinayarla, kajilpa nyanungu-nyangurlu kali-nyanurlu yampiyarla, ngulaju kajika jinyijinyi-mani maju-kurra-pinangu yaninjaku. Ngulaju maju-nyayirni. Nganangku-puka watingki kaji kanyi karnta yali ngula jinta-karirli yilyaja, ngulaju Kaatuju kula kapalangu ngungkurr-nyina.” ");
INSERT INTO wbp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wangkaja-jana kuja, “Nyurrurlarlu kankulu milya-pinyi kuruwarri Mujuju-kurlangu kuja-jana pinarri-manu nyurnunyurnu nyurru-wiyi. Pinarri-manu nganta-jana nyampu: ‘Kajinparla wangkami Kaatuku yungunparla nganta yinyi warntarri nyiyarlangu, ngulajurla jungangku yungka yimirr-yinja-wangurlu!’ Kujanya nganta-jana wangkaja Mujujuju. Ngula kuruwarriji ngurrju-juku. ");
INSERT INTO wbp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kala jalangu, ngaju karna-nyarra pinarri-mani kuruwarri-kari nyampu: Kuja kanparla wangka yapa ngalya-kariki yungunparla nganta nyiyarlangu yinyi, jungangku yungkarla Kaatu yirdi-maninja-wangurlu. Yirdi nyanungu-nyangu ngulaju tarruku-nyayirni. Manu yinjakungarntirli, nguru-nyayirni-wangu Kaatu-kurlangu yampiya yirdi-maninja-wangurlu. Ngulangkaju-ka Kaatu nyinami. ");
INSERT INTO wbp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Manu yinjakungarntirli, nguru nyampu yampiya yirdi-maninja-wangurlu. Nguru nyampuju Kaatu-kurlangu, kula nyuntu-nyangu. Manu yinjakungarntirli, kirri Jurujulumu yampiya yirdi-maninja-wangurlu. Ngulaju kirri Jurujulumu Kaatu-kurlangu Warlalja-Wiri-kirlangu. ");
INSERT INTO wbp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Manu yinjakungarntirli, jurru nyuntu-nyangu yampiya yirdi-maninja-wangurlu. Marnilpa maru kulalpanpa kurruly-yirrakarla layilayi-kirra. Manu marnilpa layilayi kulalpanpa kurruly-yirrakarla maru-kurra, lawa. ");
INSERT INTO wbp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nyarrpa-jarriyarlalpanpa kajingki yapangku payirni nyiyarlanguku? Kajilpanparla ngampurrpa nyinakarla yinjaku, ngulaju ngula-juku. Kuturla wangkaya nyampu-mipa, ‘Yuwayi ngurrju, kapurnangku ngaka yinyi.’ Kala kajilpanparla ngampurrpa-wangu nyinakarla yinjaku, ngulaju ngula-juku. Kuturla wangkaya nyampu-mipa, ‘Lawa, kularnangku yinyi.’ Kajilpanparla yirdi-kari yirdi-kari-kirlirli yimirr-yinjarla jangku-pungkarla, ngulaju kajikanparla yimi Juju Ngawu-kurlangu wangka. Kuja-kujakujulu-nyanu junga wangkaya.” ");
INSERT INTO wbp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Wangkaja-jana kuja, “Nyurrurlarlu kankulu milya-pinyi Mujuju-kurlangu kuruwarri. Pinarri-manu nganta-jana nyampu: ‘Nganangku-puka kajingki yapangku milpa rdirr-pakarni, nyanungulku rdirr-pakaka milpa-yijala! Nganangku kajingki kartirdi puyu-pakarni, nyanungulku ngula-piya-yijala puyu-pakaka!’ Ngulaju nganta Mujuju-kurlangu kuruwarri. ");
INSERT INTO wbp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kala jalangu, ngaju karna-nyarra pinarri-mani kuruwarri-kari nyampu: Pina kunka-maninja-wangulu nyinaya! Nganangku-puka kajilpangku kujarlu rdakangku pakakarla lalypangku nyampu yangka wirlki jungarni-purdanji, ngulaju yampiya pina-pakarninja-wangurlu. Yungkarla jampu-purdanjirlanguku yungungku pakarni wirlki. ");
INSERT INTO wbp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nganangku-puka kajingki kuwurtu-kurra kanyi jaatiki puntarninjaku, ngulajurla yungka manu jurnarrparlangu. ");
INSERT INTO wbp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kajingki yurrkunyurlu jinyijinyi-mani nyanungu-nyangu jurnarrpaku kanjaku kutuku marda jirrama kilamataku, ngulajurla kangka parrparda wurnturu-nyayirni marda murntu-palaku kilamataku. ");
INSERT INTO wbp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nganangku-puka kajingki warlkirninjarla payirni nyiyaku, ngulajurla yungka wilji-wangurlu. Wurra-maninja-wangurlu kuturla yungka.” ");
INSERT INTO wbp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Wangkaja-jana kuja, “Nyurrurlarlu kankulu milya-pinyi nyurnunyurnu-kurlangu kuruwarri kuja kalu-nyarra pinarri-mani-juku jalangurlu. Wangkami kanyarra kuja: ‘Yulkayalu-jana warlalja-mipaku. Yapa ngula kalu-nyarra nyurunyuru-jarri, ngula-piya-yijalalu-jana nyurunyuru-jarriya.’ Kujanya kanyarra wangka kuruwarriji. ");
INSERT INTO wbp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kala jalangu, ngaju karna-nyarra pinarri-mani kuruwarri-kari nyampu: Ngana-puka kajingki nyurunyuru-jarri, ngarirla kutu yulkaya. Nganangku-puka kajingki yapangku pakarni, ngulakujurlajinta Kaatuku wangkaya. ");
INSERT INTO wbp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kajinkili-jana yulkami yapaku ngula-piya, ngula-jangka Wapirrarlu kapu-nyarra kurdukurdu-pajirni nyanungu-nyangu yangka ngula-ka nyina nguru-nyayirni-wangurla kankarlarra. Wanta ngula karla marlaja pardimirni, ngula-ka yilyamirni Kaaturlu, kula ngurrju-mipaku yapaku, panuku-juku majumajurlanguku. Ngapa kuja-ka yilyamirni Kaaturlu, ngulaju ngalipaku jintawarlayiki, kula ngalipa-mipaku yangka kuja karliparla jungarni nyina, panu-karirlanguku yangka kuja kalurla jurnta nyinami kuja-purda-kari. ");
INSERT INTO wbp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kajilpankulu-jana yulkayarla yapa ngalya-kari-mipaku ngula kalu-nyarra yulkami-yijala, manngu-nyanyi mayi kankulu kapu-nyarra Kaaturlu ngurrju-pajirni ngulakuju? Lawa! Yangka yimirr-yinja-panu tala puntarninjakungarduyu-patu, ngularrarlanguju kalu-jana yulkami yapa ngalya-kariki warlalja puntuku. ");
INSERT INTO wbp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kajilpankulu-jana wapirdi wangkayarla ngurrju nyurrurla-nyangu-mipaku puntuku, manngu-nyanyi mayi kankulu kapu-nyarra Kaaturlu ngurrju-pajirni ngulakuju? Lawa! Yapa ngalya-kari ngula kalu ngurrpa-juku nyina Kaatukuju milya-pinja-wangu-juku, ngularrarlangu kalu-jana wapirdi-wangkami ngurrju nyanungurra-nyangu puntuku. Panu-kari-piya-wangu yungulpankulu-jana yulkayarla yapaku jintawarlayiki-jiki. ");
INSERT INTO wbp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yuwayi, jungarnili nyinaya Wapirra Kaatu-piya ngula-ka nyinami kankarlarra nguru-nyayirni-wangurla. Kutulu-jana yulkaya panuku yapaku ngula-piya Kaatu-piya.” ");
INSERT INTO wbp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wangkaja-jana, “Ngula kankulu-jana nyiyarlangu yinyi marlajarra-watiki, ngulajulu-jana yungka wurulyparlu yapa ngalya-kari-kijaku nyanja-kujaku. Kulalu kulkurru-jarra milkarraku karriya warru yinja-karra. Kajinkili karrimi kulkurru-jarra warru yinjarla, ngulakuju Wapirrarlu kula-nyarra ngurrju-pajirni yangka kuja-ka kankarlarra nyina nguru-nyayirni-wangurla. ");
INSERT INTO wbp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kajinkili-jana yinyi tala marlajarra-watiki yapaku, yungkalu-jana wurulyparlu yapa ngalya-kari-kijaku nyanja-kujaku. Kulalu yangka milkarraku karriya panu-kari-piya. Ngula kalu-jana yinyi tala marlajarra-watiki Juwu-kurlangurla jaajirla manu yirdiyi-wana, ngulaju purlanja-karrarlu yungulu-jana yapa-patu-karirli nyanyi warru yinja-kurra jama ngurrju nganta. Pangkalalu-jana ngurrju-pajirni. Junga karna-nyarra wangka: Kaaturluju kula-jana witarlanguju yarda yinyi kuja kalu-jana milkarraku yinyi warru, lawa! ");
INSERT INTO wbp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kulalu milkarraku karriya panu-kari-piya! Kajinkili-jana yinyi nyiya-puka marlajarra-watiki yapaku, yungkalu-jana wurulyparlu, ngulaju yapa ngalya-kari-kijaku nyanja-kujaku. ");
INSERT INTO wbp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kajinkili-jana yinyi yapaku marlajarra-watiki wurulyparlu, Wapirra-miparlu kanyarra nyanyi. Ngula-warnuju kapu-nyarra ngurrju-pajirni.” ");
INSERT INTO wbp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Wangkaja-jana, “Kajinkilirla Kaatuku wangka, wangkayalurla jungarni-nyayirni milkarra-wangu yalirra-piya-wangu yangka kuja kalurla jungarni nganta wangkami Kaatukuju. Warrarda kalu karrimi kulkurrurni milkarraku Juwu-kurlangurla jaajirla Kaatuku wangkanjaku, manu kalu karrimi yirdiyi-wana milparniwarrarla yapangka panungka ngula yungulu-jana yapa-patu-karirli nyanyi ngula kalurla Kaatuku wangkami. Kujaju majumaju! Junga karna-nyarra wangka: Kaaturluju kula-jana witarlanguju yarda yinyi kajilirla kuja wangka Kaatukuju, lawa! ");
INSERT INTO wbp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Kala kajinparla wangka Wapirraku, ngulakungarntiji yuwarli-kirra-wiyi wurulypa yukaya yungunparla yangarlu wangkami panu-wangurla. Ngula-jangkaju, Wapirrakurla wangkaya yangka. Ngulaju kapungku nyanyi wuruly-wangkanja-kurra ngula kanparla wangkami, manu kapungku yinyi nyiyaku ngula kanpa payirni. ");
INSERT INTO wbp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Manu kajinkilirla wangkami Kaatuku, wangkayalurla yalirra-piya-wangu yangka ngula kalu ngurrpa-juku nyina Kaatukuju. Ngula kalurla wangkami Kaatuku, ngulaju kalurla yarda-patupatu wangkami warungka-piya. Purda-nyanyi nganta kajana Kaaturlu yangka kuja kalurla warrarda wangka tarnnga. Kujaju yijardu-wangu! ");
INSERT INTO wbp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yalirra-piya-wangulu nyinaya! Kaaturluju nyurru-juku-ka milya-pinyi nyiyarningkijarra nyurrurla-nyangu payirninja-wangurla-wiyi. ");
INSERT INTO wbp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Junga-juku, kujanyalurla wangkaya Kaatukuju: ‘Wapirra, nganimpakupalangu kuja kanpa nyuntu nyina nguru-nyayirni-wangurla kankarlarra, milki-yirraka-nyanu nganimpa-kurra yungurnangkulu milya-pinyilki nyuntuju junga-nyayirni! ");
INSERT INTO wbp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wapirra, kutu-jarriya-nganpa yungunpa-nganpa Warlalja-Wiri nyinami nganimpakuju. Nguru-nyayirni-wangurla kankarlarra, panungku kangkulu purda-nyanyi wilji-wangurlu nyarrpa kuja kanpa-jana wangka. Kujarlanya karnangkulu payirni yungungkulu yapangku jintawarlayirli nyampurla walyangkarlu purda-nyanyi wilji-wangurlu. ");
INSERT INTO wbp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wapirra, payirni karnangkulu miyiki yungurnangkulu marlaja ngarni parra-kari parra-karirli. ");
INSERT INTO wbp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wapirra, yangka kuja kalu-nganpa yapa ngalya-kari majungka-jarri jurnta, ngulakuju karnalu-jana yawuru-jarrimi kunka-maninja-wangu. Kuja-jangkaju, payirni karnangkulu nyuntu yungunpa-nganpa yawuru-jarrimi kuja karnangkulu majungka-jarrimi jurnta. ");
INSERT INTO wbp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wapirra, kajikarnalu karlirr-yani nyuntu-kujaku. Kuja-kujakuju, mardaka-nganpa muurlparlu nyiyarlangu kajika-nganpa rdipimi manu karlirr-kanyi nyuntu-kujaku.’ Kujanyalurla Kaatuku wangka. ");
INSERT INTO wbp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Junga kujaju! Kajilpankulu-jana kunka-maninja-wangu yawuru-jarriyarla yapa-ngalya-karirlanguku nyiyarlanguku maju-wanawanaku, ngulaju nguru-nyayirni-wangurla kajika-nyarra Wapirraju yawuru-jarrimi-yijala nyurrurlakuju maju-jangkakuju. ");
INSERT INTO wbp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kala kajilpankulu-jana jurnta nyinakarla yawuru-jarrinja-wangu, ngulaju kula-nyarra Kaatuju yawuru-jarrimi-yijala.” ");
INSERT INTO wbp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wangkaja-jana, “Kajinkili miyi ngarninja-wangurlu yampimi purlapakungarnti Kaatu-kurlangukungarnti, kulalu yangka milkarraku karriya panu-kari-piya. Ngula kalu nyina purlapakungarnti miyi ngarninja-wangu, ngulaju kalu nyina yinngirriji murlurrpa-nyayirni yungulu-jana yapa-patu-karirli nyanjarla ngurrju-pajirni. Pangkalalu-jana ngurrju-pajirni. Kala Wapirrarlu kula-jana ngurrju-pajirni milkarra-jangkaju. ");
INSERT INTO wbp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kulalu milkarraku karriya nyanungurra-piya! Ngula kankulu miyi ngarninja-wangu nyinami Kaatu-kurlangukungarnti purlapakungarnti, kulalu nyinami yinngirriji mularrpa-nyayirni, lawa. Parljikalu-nyanu ngapangku, ngula-warnurlu jarangkulu-nyanu mapaka marnilpa. ");
INSERT INTO wbp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kuja-kurraju kapulu-nyarra yapa-patu-karirli nyanyi purlapakungarnti. Kulalu-nyarra milya-pinyi yangka ngulankulu miyi yampija ngarninja-wangurlu. Kala Wapirrarlu, nyanungu-miparluju kapu-nyarra nyanyi miyi ngarninja-wangu. Ngula-warnuju yungu-nyarra ngurrju-pajirni.” ");
INSERT INTO wbp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jijaji-jana wangkaja, “Purlurlpa-wangulu nyinaka! Kulalu warru turnu-maninjarla rdanjarr-mardaka jurnarrpa nyampurla ngurungka. Ngula-jangkaju, mulururlu kajika ngarni, manu kajika muku larra-parnka nyiyarningkijarraju, manu marda purunjurlu kajika-nyarra jurnta kanyi jurnarrpa. ");
INSERT INTO wbp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ngula-kujakujulu-jana yungka warru yimirirli yapa ngalya-karirlanguku. Ngula-warnuju Kaaturlu yungu-nyarra rdanjarr-yinyi nyiyarningkijarra nguru-nyayirni-wangurla. Ngulangkaju kulalpalu mulururluju nyiya nganjarla. Manu kulalpa larralarra-parnkayarla jurnarrpaju. Manu kulalpa purunjurlu yapangku nyiyarlangu mantarla. ");
INSERT INTO wbp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nyarrpararlankulu rdanjarr-mardarni nyiyarningkijarraju jurnarrpa? Nyampurla ngurungka? Marda nguru-nyayirni-wangurla? Kajinkili rdanjarr-mardarni jurnarrpa Kaatu-kurlangurla, ngulaju kankulu manngu-nyanyi tarnnga yali nguru. Kala kajinkili purlurlparlu rdanjarr-mardarni nyampurla ngurungka, ngulaju kankulu manngu-nyanyi nguru nyampu-mipa. Ngulaju maju!” ");
INSERT INTO wbp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jijaji-jana wangkaja, “Nyurrurla-nyangu milpa, ngulaju jarra-piya. Kajinkili-jana yimirirli yinyi warru yapaku jurnarrpa, ngulaju kankulu nyinami jarrangka Kaatu-kurlangurla. ");
INSERT INTO wbp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kala kajinkili-jana purlurlparlu jurnta mardarni yinja-wangurlu yapa ngalya-kari-kijaku, ngulaju maju. Kula kankulu nyinami yalumpu jarrangka Kaatu-kurlangurla. Kula-nganta kajikankulu pamparda nyinami nyanja-wangu nguru-wangu. ");
INSERT INTO wbp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yapa kulalpa-palangu warrki-jarriyarla paaju jirramaku. Kajirla yulkami kamparru-warnuku paajuku, ngulaju kapurla nyurunyuru-jarrimi jinta-karikiji. Kala kajilparla yinya paajuku jinta-kariki yulkayarla, ngulaju kajikarla kamparru-warnukuju paajukuju nyurunyuru-jarrimi. Kujanya karna-nyarra nyampuju wangkami jalanguju. Kajinparla talaku yulkami, ngulaju nyuntu-nyangu paaju, manu kulanparla yulkami Kaatukuju.” Kujanya-jana Jijajiji wangkaja nyanungu-nyangu kurdungurlukuju.” ");
INSERT INTO wbp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wangkaja-jana kurdungurluku, “Kajinkilirla Kaatuku nyinami, ngulangkuju yungu-nyarra muurlparlu warrawarra-kanyi. Nyurrurla kankulurla Kaatu-mipaku warlalja nyinami nyanunguku-juku. Kula-nyarra wajawaja-maninjarla kijirni. Kapu-nyarra kutu warrawarra-kanyi. Kujarlaju, yungulpankulu jata-nyanja-wangu nyinayarla miyiki ngarninjaku manu jurnarrpaku yukanja-wangu. ");
INSERT INTO wbp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Manngu-nyangkalu-jana jurlpuju. Ngurlu kula kalu yirrarni walyangka jurlpungkuju miyi wiri-maninjaku, lawa. Kula kalu warru turnu-maninjarla kanyirni ngurra-kurra yuwarli-piya-kurra ngaka-kariki ngarninjaku, lawa. Kaaturlu ngari kajana warrawarra-kanyi kuja-kurra-juku nguru-nyayirni-wangurlarlu, kula kalu payirni miyikipurdarlu. Kala nyurrurlakuju, Kaatu kanyarra yulkami jurlpu-piya-wanguku yapakuju. Ngula-warnuju, jata-nyanja-wangulu nyinaka miyikiji. ");
INSERT INTO wbp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kajilpankulu warrarda jata-nyangkarla, kulalpankulu nyarrpa-jarriyarlalku. Kaaturlu jintangku kajika-nyarra warrawarra-kanyi tarnngangku-juku. ");
INSERT INTO wbp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Jurnarrpaku jata-nyanja-wangulu nyinaka! Nyangkalu-jana jinjirla-wati. Nganangku kajana warrawarra-kanjarla wiri-mani? Kula kalu warrki-jarri yapa-piya, lawa. Manu kula kalu-nyanu jurnarrpa ngurrju-mani. Ngulaju ngula-juku. Ngurrju-juku kalu nyina jinjirla-watiji ngurrju-nyayirni-jiki. ");
INSERT INTO wbp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngaju karna-nyarra junga wangkami: Yangka wati kingi Julumunu ngulalpa nyurru-wiyi nyinaja tala-kurlu panu-jarlu-kurlu manu jurnarrpa-kurlu ngurrju-nyayirni-kirli, nyanungu-nyangu jurnarrpaju kulalpa ngurrju-nyayirni nyinaja jinjirla-piya, lawa. ");
INSERT INTO wbp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","“Kaaturlu kajana warrawarra-kanjarla wiri-mani jinjirla-wati ngurrju-nyayirni kujaju. Manu marna kajana wiri-mani kirrirdi-nyayirni. Ngulaju kula kalu tarnnga-nyayirni pardimi, lawa. Wita-mipaku kalu pardimi. Ngula-jangkaju, linji-jarri kalu. Ngula-jangkaju, yapangku kalu-jana kijirni warlu-kurra kaji marna linji-jarri. Nyiya-jangka kankulurla Kaatuku kapuru nyina? Marda kankulu manngu-nyanyi kula-nyarra jurnarrpa yinyi yukanjaku, kapu-nyarra jurnta mardarni? Ngulaju junga-wangu! Kuja kajana warrawarra-kanyi jinjirlaju, ngula-piyarlu-yijala kapu-nyarra warrawarra-kanyi Kaaturluju. ");
INSERT INTO wbp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","33","“Nyurrurla marda kankulu miyi-wangu manu ngapa-wangu nyina manu marda jurnarrpa-wangu yukanjakuju. Ngulaju ngula-juku! Kaaturlu kanyarra warrawarra-kanyi-jiki nguru-nyayirni-wangurlarlu. Yapa-paturlu nyampurla ngurungka kalu warrarda jata-nyanyi miyi manu ngapa ngarninjaku manu jurnarrparlanguku. Yalumpurra-piya-wangulu nyinaya! Kaatu kanyarra Warlalja-Wiri nyina nyurrurla yapaku. Kuja-jangkanya, jata-nyanja-wangulu nyinaka miyiki manu ngapaku! Manngu-nyangkalu Kaatuju nyarrpa kaji-nyarra wangka yungunkulurla jungarni nyina nyanunguku. Ngula-jangka kapu-nyarra yinyi miyi manu ngapa ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yuwayi, Kaaturlu kapu-nyarra warrawarra-kanyi parra-kari parra-kari. Kulalu manngu-nyanjarla jata-nyangka kujarlu, ‘Jukurra marda kajika-ngalpa nyiyarlangu maju-nyayirni rdipimi. Nyarrpa-jarrimilkirlipa?’ Kuja-wangulu nyinaya wangkanja-wangu. Jalangu marda kajika-nyarra nyiyarlangu yangka maju-nyayirni rdipimirni nyurrurlaku. Ngulaju ngula-juku. Kaaturlu kapu-nyarra warrawarra-kanyi-jiki. Ngula-mipanyalu manngu-nyangka.” ");
INSERT INTO wbp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wangkaja-jana, “Yapa ngalya-karili-jana yampiya maju-pajirninja-wangurlu! Kajinkili-jana maju-pajirni, ngulaju kapu-nyarra Kaaturluju nyurrurlaju maju-pajirni-jala. ");
INSERT INTO wbp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kajilpankulu-jana ngurrju nyinayarla yapaku maju-pajirninja-wangu, ngula-piya-yijala kapu-nyarra Kaatuju ngurrju nyinami maju-pajirninja-wangu. Kala kajilpankulu-jana warrarda maju-pajikarla yapa ngalya-kari, ngula-piyarlu-yijala kapu-nyarra Kaaturlu maju-pajirni nyurrurlaju. ");
INSERT INTO wbp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nyiyaku kanpa-jana miimii-nyanyi yapa ngalya-kari maju-pajirninjakungarntirli? Kajikanpa marda walya wita jurdu nyanyi nyuntukupurdangka-kurlangurla milpangka. Ngula-puruju kulalpanpa nyangkarla rdalyku wiri-jarlu kuja kanpa mardarni nyuntu-nyangurla warlaljarla milpangka. ");
INSERT INTO wbp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ngula-jangkaju, nyuntu kajikanparla marda wangka nyuntukupurdangkaku, ‘Walya wita mayirnangku jurnta mani nyuntu-nyangurla milpangka?’ Nyarrpa kajikanparla nyuntuju wangka, yangka kuja kanpa mardarni rdalyku wiri-jarlu nyuntu-nyangurla milpangka? ");
INSERT INTO wbp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kuja wangkanja-wangu nyinaka! Nyuntuju kanpa milkarraku-mipa wangka! Wilypi-manta-wiyi-nyanu rdalyku wiri milpangka nyuntu-nyangurla! Ngula-jangkaju, ngurrjungkulku kanpa nyanjarla wilypi-mani jurdu wita milpangka nyanungu-nyangurlaju. ");
INSERT INTO wbp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yimi Ngurrju Kaatu-kurlangu, ngulaju ngurrju-nyayirni kawurlu-piya. Kajili-nyarra yapangku jawirri purda-nyanyi yirri-puranja-kurra, ngulajulu-jana yampiya warrarda yirri-puranja-wangurlu. Yalumpu-patu ngulajulu maju-nyayirni maliki-piya wijini panu-kurlu manu nguurrnguurrpa-piya palya, ngula-piya. Kajinkili-jana warrarda yirri-pura Yimi Ngurrju, ngulaju kulalu nginyinginyi-kirra-mani, lawa. Kapulu walya-kurra kijirni yungulu katirni nguurrnguurrpa-piyarlu, manu kapulu-nyarra marda wajirli-pinjarla pinyi maliki-piyarlu.” ");
INSERT INTO wbp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Wangkaja-jana, “Nganangku-puka kaji warrarda payirni Kaatu nyiyarningkijarraku, ngulaju kapurla marlaja mani. Manu nganangku-puka kajirla warrarda wapal-nyanyi, ngulaju kapu palka-mani. Manu nganangku-puka kajirla warrarda tarlarlkarra-pakarni, kapurla tuwaju marlaja lakarn-mani Kaatu-kurlangu-kurra yungu yukamirra. Kujarlaju, kajinkilirla Kaatuku wangkami, warrarda payikalu nyiyarningkijarraku, kapu-nyarra yinyi. Warrarda wapal-nyangkalurla, kapu-nyanu milki-yirrarni nyurrurla-kurra. Warrarda tarlarlkarra-pakakalurla, kapu-nyarra lakarn-mani tuwa yungunkulu yukamirra. ");
INSERT INTO wbp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nyarrpa-jarrinpa kajingki nyuntu-nyangurlu ngalapi-nyanurlu payirninja-yanirni miyikiji ngarninjaku? Pirli mayi yungunparla yinyi? ");
INSERT INTO wbp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nyarrpa-jarrinpa kajingki nyuntu-nyangurlu ngalapi-nyanurlu payirninja-yanirni yawukuju kuyukuju ngarninjaku? Warna kulu-parnta mayi yungunparla yinyi? Lawa! Kapunparla yawu kuyu ngurrju yinyi ngarninjaku. ");
INSERT INTO wbp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nyurrurla yapa-patu kula kankulu ngurrju nyina Kaatu-piya. Kala yinyi-jiki kankulu-jana nyurrurla-nyangu kurdukurdukuju nyiyarningkijarra ngurrju-nyayirni. Wapirra-ka nyina jama-juku nyurrurla-piya-wangu. Kajinkili payirni nyiyarningkijarra ngurrju, ngula-jangka nguru-nyayirni-wangurlarlu kapu-nyarra ngurrju-mipa yinyi. ");
INSERT INTO wbp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nyiya-wiyi jinta kuruwarri wiri Mujuju-kurlangu kuja-nyarra yirrarnu nyurrurlaku yapaku? Manu nyiya-wiyi kuruwarri wiri jurrku-juku kujalu-nyarra jarukungarduyu-paturlu Kaatu-kurlangu-paturlu yirri-puraja? Ngulaju nyampunya: ‘Kajinkili ngampurrpa nyina yungulu-nyarra yapa ngalya-kari ngurrju nyinami nyurrurlaju, ngulaju ngula-juku. Ngurrju-wiyili-jana nyinaya!’” ");
INSERT INTO wbp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Wangkaja-jana, “Wuurnpa-wana wita-wana kiirti-wanaju, jungarnijikili yaninjanta Kaatu-kurlangu-kurra. Kala kiirti wantiki manu yirdiyi wantiki-yijala kuja-ka ngunamirra kuja-purda-kari, ngulaju yampiyalu puranja-wangurlu. Yirdiyi yalumpu ngulaju wantiki-nyayirni yaninjaku. Panu kalu yanirra wiri-wana kuja kalu yangka yanirra, ngulaju tarnnga-juku palinjakungarnti. ");
INSERT INTO wbp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kuja-kujakuju, yaninjantajukulu yirdiyirla wuurnparla ngula-ka ngunamirra Kaatu-kurlangu-kurra. Ngulangka ngurungka kapunkurla marlaja nyinami wankaru-juku tarnnga-nyayirni. Tuwaju ngula-ka karrimi Kaatu-kurlanguju, ngulaju wuurnpa-nyayirni. Manu yirdiyi ngula-ka ngunamirra, ngulaju wuurnpa-nyayirni yapaku yaninjaku. Wuurnparlaju, marnkurrpa-mipa kalu yani tarnngaju nyinanjaku, kula panu.” ");
INSERT INTO wbp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Wangkaja-jana, “Muurlparlulu-nyanu warrawarra-kangka yimirr-yinja-palka-kujaku ngula kalu-nyanu ngarrirni Kaatu-kurlangu nganta jarukungarduyu nganta. Kajinkili-jana purda-nyanyi jaru wangkanja-kurra, ngulaju nganta yungunkulu-jana nganta ngurrju-pajirni ngurrju nganta pululu nganta jiyipi-piya. Lawangka! Kari-nganta kulu-parnta-nyayirni pinja-panu maliki warnapari-piya. ");
INSERT INTO wbp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nyarrparlu yungunkulu-jana miimii-nyanjarla milya-pinyi yimirr-yinja-palka kajili yaniyanirni Kaatu-kurlangu nganta? Kajili yanirni ngulaju maju-mipa yimi kapulu kanyirni, ngula-jangkaju yungunkulu-jana milya-pinyilki. Kajilpa ngana-puka Kaatu-kurlangu nyinayarla jungarni, ngulangkuju ngurrju-mipa kajika kanyirni, kula maju. Kulanpa mani marniki-piyaju jiri-parnta-ngurlu watiya-ngurlu, lawa. Kulanpa mani mukaki putunarri-ngirli, lawa. Ngula-piya-yijala, kuruwarri Kaatu-kurlangu kulalu-nyarra yimirr-yinja-palkarlu jungarnirli yirri-pura. ");
INSERT INTO wbp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","“Kajilpa pirrjirdi watiya karriyarla, ngulangkaju kapu miyi ngurrju mardarni. Kala kajilpa rampaku watiya karriyarla, ngulangku kuja-ka miyi mardarni, ngulaju ngawu ngarninjakuju. Yangka-patu yimirr-yinja-palka, ngulajulu maju-nyayirni watiya parrka-wangu-piya. ");
INSERT INTO wbp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yangka parrka-wangurla watiyarla kaji miyi maju pardimi, ngulaju karlipa watiya yawirr-pajirni, ngulaju kijirni karlipa warlu-kurra wiri-kirra. ");
INSERT INTO wbp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kajili yangka yanirni yimirr-yinja-palka, kajili maju yangka kanyirni jaru, ngula kankulu-jana milya-pinyi kula-jana Kaaturlu yilyajarni.” ");
INSERT INTO wbp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ngula-jangkaju, Jijaji-jana wangkaja yapaku, “Kaatu-ka Warlalja-Wiri nyinami nyiyarningkijarraku. Ngana kapu yukamirra nguru-nyayirni-wangu-kurra nyanungu-nyangu-kurraju? Yapa ngula kalu jalangu nyina ngurungka nyampurla manu ngula kalurla warrarda purda-nyanjarla ngungkurr-nyinami ngajukupalanguku nguru-nyayirni-wangurlaku, nyarrpa kaji-jana wangka, ngularra-mipa kapulu yukamirra. Yapa panu-karirliji kalu Kaatuju jamulu purda-nyanyi. Purda-nyanyi-yijala kalu, kala maju-juku kalu nyina. Ngularraju kulalu yukamirra Kaatu-kurlangu nguru-nyayirni-wangu-kurra, lawa. ");
INSERT INTO wbp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yuwayi, ngulangka nguru-nyayirni-wangurla, Kaaturlu yungu-jana miimii-nyanyi yapaju kuwurtukungarduyu-piyarlu nyanungu-nyangu-japa, marda lawa. Panu-karirli yapangku ngarrajulu kuja wangka, ‘Warlalja-Wiri Jijaji, yapakurnalu-jana yimi-ngarrurnu jaru nyuntu-nyangu ngula-piyarlu jarukungarduyu-piyarlu ngula kalalurla Kaatuku marlaja wangkaja nyurru-wiyi. Nganimparlurnalu-jana juju ngawungawu yapa-ngurlu jurnta yilyaja, manurnalu-jana parlpuru-manu nyurnu-jangka nyuntu-nyangurlu yirdi-kirlirli.’ Ngarrajili wangka kujanya. ");
INSERT INTO wbp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kala kapurna-jana wangkami, ‘Ngana-wiyi nyurrurlaju? Kula karna-nyarra milya-pinyi! Nyurrurla yapa-patu ngulaju punku-wati-nyayirni! Jurnta yantajulu!’ Kujanya kapurna-jana wangkami.” ");
INSERT INTO wbp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ngula-jangkaju, Jijaji-jana wangkaja yapaku, “Ngana-puka kaji ngaju-kurra yaninjarla purda-nyanyi ngaju-nyangu yimi, kajirla jungarni nyina Kaatuku, yali yapaju ngulaju ngurrju. Nyanunguju ngurrju yangka wati pinangkalpa-piya kuja yuwarli ngurrju nganturnu. Nganturnu walyangka tarlangka yungu pirrjirdi karrimi ngurrangka. ");
INSERT INTO wbp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngaka-karirlaju, ngapa wantija pirrjirdi-nyayirni, ngawarralkulpa wiri-nyayirni parnkaja, mayawunparlu putalpa yurnkuyurnku-mani yuwarliji, kula kujurnu. Pirrjirdi-jukulpa karrija pirlingkaju. ");
INSERT INTO wbp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","Yalirlarlangu watilpa jinta-kari nyinaja milya-pinja-wangu jiliwirri, ngulangku-nyanu nganturnu yuwarli walyirirla walyangka pirntipirntirla yulpayirla. Ngula ngapalku wantija pirrjirdi-nyayirni, manu ngawarralkulpa parnkaja, ngula-purujulpa mayawunpalku parnkaja. Yuwarliji wurrmurr-wantija. Kajinkijili jawirri purda-nyanyi wangkanja-kurra, ngula-warnuju kajinkijili jaru marlaja yampimi puranja-wangurlu, ngulajunkulu ngula-piya wati-piya ngula nganturnu yuwarli walyangka walyirirla.” ");
INSERT INTO wbp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kuja-jana lawa-jarrijalku yapaku nyiyarningkijarraku nyampurraku pinarri-maninjaku, ngulakujulurla marlaja paa-karrija nyanungu-nyanguku jarukuju. ");
INSERT INTO wbp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yangka kuja kala-jana Jijajirli pinarri-manu, ngulaju kala-jana pinarri-manu yimi Kaatu-kurlangu-kurlurlu kujarla yungu nyanungukuju. Kula-jana pinarri-manu panu-kari-piyarlu kuruwarrikingarduyu-patu-piyarlu yangka kuja kalalu-jana pinarri-manu nyanungu-nyangu-mipa-kurlurlu yimi-kirlirli. ");
INSERT INTO wbp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yali-jangkaju, Jijajiji yaninjarla jitija pirli-ngirliji, manu panu-jarlu yapa-paturlu purdangirli-wanarlulu puranja-yanu nyanunguju. ");
INSERT INTO wbp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngula-jangkaju, watijirla yanurnu Jijajiki pinti wijini-kirli panu-kurlu. Junga-juku, kamparru-jukurla mirdijirrpijirrpi parntarrinjunu. Jijajikijirla wangkaja, “Warlalja-Wiri, nyuntulurlu kanpa mardarni yartarnarri Kaatu-kurlangu yapaku parlpuru-maninjaku. Kajilpanpaju mari-jarriyarla ngajukuju, ngulaju kajikanpaju wijini parlpuru-mani manu karaly-mani!” ");
INSERT INTO wbp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Junga-juku, Jijajirli waku wipinjarla marnpurnu. Ngularla wangkaja Jijajiji, “Kari-nganta karnangku mari-jarri yungurnangku parlpuru-mani wijini-jangkaju! Parlpuru-jarriya wijini-jangkaju manu karalypa-jarriya pintiji!” Junga-juku, pintiji kapanku karalypa-jarrija wijini-jangkaju. ");
INSERT INTO wbp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ngula-jangkaju, Jijajilkirla wangkaja watiki, “Ngajukuju yapa-patu-kari-kirra yimi-ngarrirninja-wangu nyinaya! Juwu-kurlangu-kurra Yuwarli Maralypi-kirra-wiyi yanta. Milki-yirrarninjintangku pinti yangka wijini-jangka wati jinta-kurra maralypikingarduyu-kurra yungungku pintiji miimii-nyanyi ngurrjulku. Kajingki miimii-nyanjarla kirlka-pajirni pintiji, ngulakujurla maninjarla yungka jurlpu-jarra wita-jarra, ngulaju kuruwarri-ka ngunami Mujuju-kurlangu kujaju. Ngula-kurra kajingkili nyanyi ngalya-karirli yapangku, kapungkulu milya-pinyi kirlkalku wijini-wangulku.” ");
INSERT INTO wbp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ngaka-pardu-karilki Jijajiji pina-yanu kirri-kirra Kapurniya-kurra. Yalirla Ruumu-wardingki yurrkunyukungarduyu wiri, payurnunjunu, manurla warlkirninjarla wangkaja, ");
INSERT INTO wbp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Warlalja-Wiri, ngaju-nyangu jinta warrkini wati-ka purdangirli nyina yuwarlirla nyurnu, manu ngunami-ka pangkarrarla. Nyanungu kula-ka yurirrimi, manu maju-nyayirni kanyanu purda-nyanyi.” ");
INSERT INTO wbp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jijajijirla wangkaja nyanungukuju, “Yanirni karna nyuntu-kurlu nyuntu-nyangu yuwarli-kirra, manu yungurna parlpuru-mani.” ");
INSERT INTO wbp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yurrkunyukungarduyu wiri-pirdinypajurla wangkaja Jijajikiji, “Warlalja-Wiri, nyuntujunpa wiri-nyayirni parrparda-juku ngajukuju. Kula yantarni ngaju-nyangu-kurra ngurra-kurra. Ngari wangkaya-puka yaninjarni-wangu yungunpa warrkini ngaju-nyangu parlpuru-mani. ");
INSERT INTO wbp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Milya-pinyi karnangku kuja kanparla warrki-jarri Kaatukuju. Kuja kangku wangka warrki-jarrinjaku, ngulaju kanparla yimiri warrki-jarri. Kuja-piya karnarla warrki-jarri kujakuju Ruumu-wardingkiki kingiki. Ngaju karna nyina wiri 100-palaku warrmarlaku. Kajilparnarla ngaju wangkayarla jintaku yaninjaku yali-kirra, kajikarla kapanku yani, manu kajilparnarla ngaju wangkayarla jinta-kariki, ‘Yantarni!’, ngulaju kajika kapanku yanirni. Manu kajilparnarla ngaju wangkayarla ngaju-nyanguku warrkini warrki-jarrinjaku, ngulaju kajika kapanku warrki-jarri. Ngula-piya-yijala nyuntuju kajinpa wangka, junga-juku ngaju-nyangu warrkini kapu kujarlaju parlpuru-jarri.” ");
INSERT INTO wbp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ngula Jijajirli purda-nyangu wati kuja-kurraju, ngulakujurla marlaja paa-karrija-nyayirni. Ngula-jangkaju, Jijajiji-jana wangkaja yapa panu-kariki kujalpalu warrukirdikirdi karrija, “Ngajuluju karna-nyarra junga yimiji wangka: nyampu Juwu-wangu wati kaju ngajukuju wala nyina. Kularna nyarrpararla nyangu Juwu yapaju ngula kaju ngajukuju wala nyina ngula-piyaju. ");
INSERT INTO wbp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Purda-nyangkajulu ngaju! Ngaka-pardu-kariji panu-jarlu Juwu-wangu yapa kapulu jinta-kurra-jarri ngurujarraranypa-ngurlu warrukirdikirdi-ngirli. Ngulaju kapulu yukamirra nguru-nyayirni-wangu-kurra. Ngulangkaju kapulu nyina Yipuruyamu-kurlu, Yijaki-kirli manu Jakupu-kurlu, manu nyanungu-paturlu kapujulu jirrnganja ngarni, manu kapulu nyina wardinyi-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kaaturlu-jana nguru-nyayirni-wangu ngurrju-manu yapaku Juwu-patukuju yungu-jana ngulangka jirrnganja nyina. Kala ngalya-kariji Juwu-patuju kulalu yukamirra, lawa. Kaaturlu kapu-jana kijinirra munga-nyayirni-kirra. Yalirla kapulu yula kilji-nyayirni, manu kapulu-nyanu kartirdirli yarlkirni manu karntirirrjirni murrumurrurlu purda-nyanjarlaju.” ");
INSERT INTO wbp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ngula-jangka, Jijaji wangkajarla yurrkunyuku-ngarduykuju, “Ngula-juku, pina-yanta yuwarli nyuntu-nyangu-kurra. Kujanpaju ngajuku wala nyinaja, ngula-warnukuju nyuntu-nyangu warrkini kapu ngurrjulku nyina.” Ngulaju junga-nyayirni! Ngula Jijaji kuja yimi wangkaja, yali warrkiniji parlpuru-jarrijalku. ");
INSERT INTO wbp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ngaka-pardu-karilki, Jijaji yanu Piita-kurlangu-kurra yuwarli-kirra. Ngulangkaju nyurnulpa ngunaja Piitaku kurriji-nyanu jurrukupurda ngawurrngawurrpa-nyayirni. ");
INSERT INTO wbp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jijajiji yaninjarla marnpurnu rdaka. Nyanunguju kaaku-juku ngurrju-jarrija. Ngula-jangkaju, yakarra-pardinjarla mangarrilki-jana ngayi-purraja, purranjarla yungu-jana Jijaji-pinkiki. ");
INSERT INTO wbp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Parrangka jintangka-juku wanta yukanja-warnurla wuulywuulypalku, yapa yalumpu-wardingki kirri-wardingki-paturlu kangurnulpalu-jana murrumurru manu ngalya-kari juju-kurlu palkangka-kurlu. Ngalya-karikilpa-jana wangkanjarlu jurnta yilyaja juju panu-jarlu palka-ngurlu. Ngalya-karilpa-jana parlpuru-manu. Junga-juku-jana muku parlpuru-manu. ");
INSERT INTO wbp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nyampuju yangka-juku jaru kuja Yijayarlu Kaatu-kurlangurlu jarukungarduyurlu yirrarnu nyurru-wiyi Payipulurla, kujanya: “Yalirnawu wati ngula-ngalpa parlpuru-manu yapa murrumurruju ngurrjulku yungurlipa nyina.” ");
INSERT INTO wbp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ngaka-pardu-karilki, Jijajilpa-jana jirrnganja nyinaja nyanungu-nyangu kurdungurlu-patuku. Manu-jana nyangu panu-jarlu yapa kujalpalu nyanungu-kurra yaninja-yanu. Ngula-jana wangkaja Jijajiji nyanungu-nyangu kurdungurlu-patuku, “Yanirlipa mangkuru-wana murrarninginti-kari-kirra pawurtu-kurlu.” ");
INSERT INTO wbp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngula-jangkaju, kuruwarrikingarduyu wati yanurnurla Jijajikiji, manurla wangkaja, “Tiija, ngajulurlu yungurnangku warru pura kajinpa nyuntu nyarrpara-wana yani.” ");
INSERT INTO wbp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jijajirliji jangku-manu watiji, “Yurapitiji kalu nguna rdakungka, manu jurlpuju kalu nguna watiya-wana. Kala ngajulu yangka Kaatu-kurlangu Yapa-nyayirni-wangu, kula karna mardarni ngurraju ngunanjakuju.” ");
INSERT INTO wbp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ngula-jangkaju, wati-kari yaninjarla wangkajarla Jijajikiji, “Warlalja-Wiri, ngajurlangurlu yungurnangku pura nyuntuju. Ngajukupalangu kirdana ngulaju purlka. Ngaka kajirna yapunta-jarrinjarla milyingka yirrarni, ngula-jangkaju kapurnangku puralku nyuntuju.” ");
INSERT INTO wbp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jijajirliji jangku-manu watiji, “Lawa! Ngaju-wiyiji puraya! Ngalya-karirli kula kajulu milya-pinyi. Yapunta-jarri kajinpa, yali-paturlulu milyingka yirrarni.” ");
INSERT INTO wbp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ngula-palangu Jijajirli wurra-manu wati-jarraju, jirrnganja-jana warrkarnu pawurtu-kurraju nyanungu-nyangu-patuku kurdungurlu-patuku yungulu yani ngapa wiri-wanaju murrarninginti-kari-kirra. ");
INSERT INTO wbp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Murrarni-nginti mangkurukuju murnma-juku kulkurru-juku, ngapa wiri-jana jangkardu wangkanja-yanurnu. Pawurtuju ngarra ngapa-kurralku yukayarla. Kalanpa Jijaji jarda ngunanya pawurturla. ");
INSERT INTO wbp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngulalu yaninja