﻿USE sofia;
DROP TABLE IF EXISTS sofia.wbi_vpl;
CREATE TABLE wbi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wbi_vpl WRITE;
INSERT INTO wbi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Agha ghe matavua agha kikoko kya Yesu kilisite umhuma mu kisina kya ntwa uDavidi, ikisina kya Abulahimu. ");
INSERT INTO wbi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Uabulahamu akampaapa uIsaka, uIsaka akampaapa una uYakovo, UYakovo akampaapa uYuuda na vanine. ");
INSERT INTO wbi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","UYuuda akampaapa uPelesi nu Sela mwa Tamali, uPelesi akampaapa uHesiloni, Hesiloni akampaapa uAlamu. ");
INSERT INTO wbi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","UAlamu akampaapa UAminadabu, uAminadabu akampaapa uNasoni, uNasoni akampaapa uSalimoni. ");
INSERT INTO wbi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","USalimoni akampaapa uBohasi mwa Lahavu, UBohasi akampaapa UObedi mwa Luti, uObedi akampaapa uYese, ");
INSERT INTO wbi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ghwope UYese akampaapa Untwa UDavidi. UDavidi akampaapa uSolomoni mwa mukijuuva juno alyale n'dala ghwa Ulia. ");
INSERT INTO wbi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","USolomoi akampaapa uLehoboamu, ULehoboamu akampaapa uAbia, uAbia akampaapa uAsa. ");
INSERT INTO wbi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","uAsa akampaapa uYehoshafati, UYehoshafati akampaapa uYolamu, uYolamu akampaapa uUsia. ");
INSERT INTO wbi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","UUsia akampaapa uYotamu, uYotamu akampaapa uAhasi, UAhasi akampaapa uUhesekia. ");
INSERT INTO wbi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","uHEsekia akampaapa uMnase, uManase akampaapa uAmoni, ghwope uAmoni akampaapa uYosia. ");
INSERT INTO wbi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","uYosia akampaapa uYekonia na vanine unsiki ghuno aVaisilaeli ye vatwalilue ku vuhesia, ku Babeli. ");
INSERT INTO wbi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ye vatwalilue ku vuhesia ku Babeli, uYekonia akampaapa uSalatieli, uSalatieli akampaapal uSelubabeli. ");
INSERT INTO wbi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","uSelubabeli akampaapa uAbihudi, uAbihudi akampaapa uEliakimu, uEliakimu akampaapa uAsoli. ");
INSERT INTO wbi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","uAsoli akampaapa uSadoki, uSadoki akampaapa uAkimu, uAkimu akampaapa uEliudi. ");
INSERT INTO wbi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","uEliudi akampaapa uElieseli, uElieseli akampaapa uMatani, ghwope uMatani akampaapa uYakovo. ");
INSERT INTO wbi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","uYkovo akampaapa Yosefu umughoosi ghwa Maliya. UMaliya ghwe juno akampapile uYesu juno ghwe Kilisite. ");
INSERT INTO wbi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Lino, kuhuma kwa Abulahamu kufika kwa ntwa uDavidi kwefilyale ifisina kijigho na fine. Kange, kuhuma pa Davidi kufila unsiki ghuno aVaisilaeli vitwalua ku vuhesia ku Babeli, kwefilyale ifisina ifingi kijigho n a fine. Kange, kuhuma unsiki ghuno vitwalua ku Babeli kuhanga kufika unsiki ye iholua uKilisite, kwefilyale ifisina ifingi kijigho na fine. ");
INSERT INTO wbi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kuholua kwa Yesu Kilisite kulyale ndiiki. Unguna jonop ilitavua lyake ghwe Maliya, alyalimilue nu Yosefu. Neke ye akyale kutolua alyavoniike kuuti ali nu vukunue ku ngufu sa Mhepo uMwimike. ");
INSERT INTO wbi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ulwakuva uYosefu juno alyamulimiile uMaliya alyale mugholofu pamaso gha Nguluve, naakalondagha kuuti ankosie isoni uMaliya. Pe akalamula pikumuleka kisyefu. ");
INSERT INTO wbi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ye alamwile uluo, unyamhola ghwa mtwa uNguluve akam'bonekela mu njosi, akam'buula akati, “Ghwe Yosefu, ghwe mhuma mu kisina ikya ntwa uDavidi, uleke pikwoghopa pikuntoola uMaliya, uLwakuva uvukunue vuno ali navwo, apelilue mu ngufu sa Mhepo uMwimike. ");
INSERT INTO wbi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Neke ipaapa umwana un'diimi, ukumpeela ilitavua ili Yesu, ulwakuva ilikuvapokagha avaanhu vaake mu nyivi saave.” ");
INSERT INTO wbi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sooni isio siliyavombiike enendikio kukwilanisia ilisio lino uMutwa alyajovile kukilila um'bili ghwake kuuti, “ ");
INSERT INTO wbi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Lolagha! Umhinja juno naammanyile umughoosi, iiva nu vukunue, ipaapa umwana un'diimi! pe vikumpeela umwana ujuo ilitavua ili Manueli.” Umuluvo ghwa litavua ilio kwekuti, “UNguluve ali palikimo nusue.” ");
INSERT INTO wbi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosefu akasisimuka, akavomba ndavule unyamhola ghwa Mutwa vule am'bulile, akantoola uMaliya kuuva n'dala ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Looli naakaghelile kughona naghwo kuhanga usinki ghuno uMaliya ipaapa umwana un'diimi. Pe uYosefu akampeela umwana ujuo ilitavua ili Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","UYesu alyaholilue mu likaaja ilya Betelehemu, mu kighavo ikya yUdea, unsiki ghuno alyatemile umtwa uHelode. UYesu ye aholilue, avakaguzi va nhondue kuhuma kuvudibulo vakafika mu likaaja ilya Yelusalemu, ");
INSERT INTO wbi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","vakava viposi viiti, “Ali kuughi juno aholilue, uNtwa ghwa Vayahudi? Tujaghile inhondue jino jihufia kuholua kwa mwene jihumile kuvudibulo, fye nambe twisile kukumwimika. ");
INSERT INTO wbi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Untwa uHelode ye apuliike isio, akapumuka mu mwojo ghwake. Nava vaanhu vooni ava mu likaaja ilya Yelusalemu voope vakapumuka. ");
INSERT INTO wbi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pepano akakong'hania avavaha va vatekesi vooni palikimo na vavulanisi va ndaghilo akavaposisi akati, “Ukilisite iholua kuughi?” ");
INSERT INTO wbi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aveene vakamwamula vakati, “Iholua mu likaaja ilya Betelehemu, mu kighavo ikya Yudea. Tukagwile isio ulwakuava se sino alyalembile um'bili kuuti, ");
INSERT INTO wbi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Na juuve ghwe likaaja lya a betelehemu, ghwe juno uli mu kighavo ikya Yudea, Nuli n'debe, mu makaaja agha mu Yudea! Ulwakuva mulyuve mwe muno ihuma umulongosi, juno iiva n'diimi ghwa vaanhu vango aVaisilaeli.” ");
INSERT INTO wbi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pe uhelode akavakemeela ku vusyefu avakaguzi vala ava nhondue, kuuti vam'buule vunono unsinki ghuno vajaghile inhondue jila. ");
INSERT INTO wbi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pe akavasuug'ha ku Betelehemu, akavavuula akati, “Lutagha, muposelesie vunofu vwimila umwana ujuo. Mungamwalghe, mwisaghe ng'haning'haani mumbuule, neke na juune nilute kuskumwimika.” ");
INSERT INTO wbi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Avakagusi vala ava nhondue ye vapuliike amasio gha ntwa, vakavuuka viluta. Lolagha, inhondue jila jino vakajaghile kuvudibulo, jikavalongolela, voope vakava vikujivingilila kuhanga jikafika na kukwima pano pwealyale umwana, ");
INSERT INTO wbi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ye vajaghile kange inhondue jila, vakahovoka kyongo. ");
INSERT INTO wbi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pe vakingila mu nyumba, vakamwagha umwana palikimo nu ng'ina uMaliya, vakafughama, vakamwimika. Vakavopola inyambe saave, vakambonola umwana, vakahumia: isahabu, uvufumba ni manemane ghano ghaale mafuta amanya lunuusi ulunono. ");
INSERT INTO wbi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Unguluve akavapavila mu njosi kuuti, navangakililaghe kange kwa Helode. Pe vakakilila isila ijingi kugomoka ku likaaja lyave. ");
INSERT INTO wbi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Avakagusi va nhondue ye valutile, unyamhola ghwa Mutwa akam'bonekela uYosefu mu njosi, akam'buula akati, “Sisimuka! Untoole umwana nu ng'ina, mkimbilile ku iisi ija Misili, ulwakuva uHelode ikumulonda umwana ujuo kuuti am'bude. Mukalaghe kula kuhanga unsiki ghuno kyanikuvavuula kuuti mugomoke.” ");
INSERT INTO wbi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ikilo jila jila uYosefu akasisimuka, akantoola umwana nu ng'ina, akakimbilila ku Misili. ");
INSERT INTO wbi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Vakikala kula kuhanga kufika unsiki ghuno uHelode ifua. Uluo lulyavombiike kukwilanisia ilisio lino uMutwa alyajovile kukilila um'bili ghwake kuuti, “Nikankemelile umwanango kuhuma ku Misili.” ");
INSERT INTO wbi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","UHelode akakagula kuuti, avakagusi va nhondue vala vansyangile, akakalala fiijo. pe akavasuung'ha avaanhu ku Betelehemu na mu makaaja ghano ghalyale mulubale, kuuti vavabude avaana avadiimi vooni, kutegulila avafyele kufika avanya maaka ghavili. Akavomba uluo kuling'hana nu unsiki ghuno alyaposisie ku vakagusi va nhondue. ");
INSERT INTO wbi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Uluo lulyavombiike kukwilanisia ilisio lino uMutwa alyajovile kukilila um'bili ghwake uYelemia kuuti. ");
INSERT INTO wbi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ilisio lipulikiike mu likaaja ilya Lama, avaanhu vikoola na kulila fiijo. Lisio lya Laheli, ikuvalilila avaana vaake, ");
INSERT INTO wbi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pambele uHelode akafua. UYosefu ye ajiighe ku Misili, unyamhola ghwa Mutwa akam'bonekela kange mu njosi. ");
INSERT INTO wbi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Akam'buula akati, “Sisimuka! Untoole umwana nu ng'ina, ugomoke mu iisi ija Isilaeli, ulwakuva vano valondagha kukum'buda umwana, vafwile.” ");
INSERT INTO wbi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pepono uYosefu akasisimuka, akantoola umwana nu ng'ina, vakagomoka mu iisi ija Isilaeli. ");
INSERT INTO wbi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Neke ye apuliike kuuti uAlikelao ghwe juno ahaliile pa viise uHelode kutema ikighavo ikya Yudea, akoghopa piluta kula. Akapavilua mu njosi kuuti nangalutaghe ukuo, pe akaluta ku kighavo ikya Galilaya. ");
INSERT INTO wbi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ukuo, akikala mu mu kikaaja ikya Nasaleti. Uluo, lulyavombiike kukwilanisia ilisio lino uMutwa alyajovile kukilila avavili kuuti, Itambulwagha Munasalete.” ");
INSERT INTO wbi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Amaaka minga ghakakila. Pambele akahumila umuunhu jumonga juno akatambulwagha Yohani Mwofungi. Umuunhu ujuoalyale ku lihaka ku Yudea ipulisia, iiti, ");
INSERT INTO wbi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mulataghe inyivi siinu ulwakuva uvutwa uvwa kukyanya vuli piipi. ");
INSERT INTO wbi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohani ujuo ghwe juno um'bili uYesaya alyajovile kuuti, “Ilisio lya muunhu lipulikika kuhuma ku lihaka liiti, 'Munnosekesyaghe uMutwa uNguluve isila, na kuling'hania muno kyaikilila.\"”* ");
INSERT INTO wbi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","UYohani akafwalagha umwenda ghuno ghwatendilue nu lwaghe lwa ngamila, akipinyagha nu lukova ulwa ng'hwembe mu nsana. Kulihaka ukuo, akalisagha imhaasi nu vwuki. ");
INSERT INTO wbi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Avaanhu kuhuma mu likaaja ilya Yelusalemu na mu kighavo kyoni ikya Yudea ni mbale sooni isa kikogha ikya Yolidani, vakava viluta kwa mwene ");
INSERT INTO wbi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","na kulaata inyivi saave. Neke uYohani akavofughagha mu kikoghaikya Yolidani. ");
INSERT INTO wbi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","UYohani ye avwene aVafalisayi na Masadukayi viluta kwa mwene kuuti vofughue, akavavuula akati, “Umue mwe kisina kya njoka! Ghwe veeni jono avapaviile kuuti mkimbile ing'halaasi ja Nguluve jino jikwisa? ");
INSERT INTO wbi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lino amaghendele ghahufyaghe ululaato lwinu. ");
INSERT INTO wbi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mulekaghe kusaagha kuuti, “tukulwike ulwakuva usue tuli kisina kya Abulahamu!' Kyang'haani nikivavuula, nNguluve anoghiile kuhambusia amavue agha kuuva avaana va Abulahamu! ");
INSERT INTO wbi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","UNguluve angiike inhemo, kuuti umpiki ghuno naghukoma ifipeke ifinofu, aghudumule na kunyaanya pa mwoto. ");
INSERT INTO wbi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Une nikuvofugha na malenga, kuvonia kuuti mulatile inyivi siinu. Neke juno ikwisa mumbele mulyune ali ni ngufu kukila une. Nanino ghiile nambe kuuva m'banda ughwa kukola ifilatu fyake. ");
INSERT INTO wbi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Umwene ikuvofughagha nu Mhepo uMwimike nu mwoto. Umwene ilibaghulania avimike na vahosi, ndavule umuunhu pano ikwelusia ingano pa luvunga, ikong'hania ingano na kuviika mu kihenge, neke ilyelelo inyaanya nu mwoto ghuno naghusima.” ");
INSERT INTO wbi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Unsiki ughuo, uYesu kuhuma ku Galilaya, akafika ku kikogha ikya Yolidani kuuti ofughue nu Yolidani. ");
INSERT INTO wbi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Neke uYohani akakaana, akati, “Une nilondua kukwofughua nuuve. Iwandaani ghukwisa kulyune?' ");
INSERT INTO wbi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","UYesu akamwamula akati “Uve itika kuvomba uluo lino, ulwakuva lunoghiile kukwikanisia sooni sino uNguluve ilonda.” Pe uyohani akitika, akamwofugha. ");
INSERT INTO wbi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","UYesu ye ofughue, unsiki ghughuo akahuma mu malenga. Uvulanga vukadinduka, akamwagha uMhepo ghwa Nguluve ikwika hwene ng'hunda, jikwisa pakyanya pa mwene! ");
INSERT INTO wbi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pe ilisio kuhuma kukyanya likati, “Uju ghwe mwanango umughanike, ninkeliile.” ");
INSERT INTO wbi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pepano uYesu akalongosovua nu Mhepo uMwimike kuluta ku lihaka, kuuti aghelue nu Setano. ");
INSERT INTO wbi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ukuo uYesu akavuhiila kulia mulwa kufuunya ifighono fijigho fine pakilo n a pamwisi. Pambel, e jikam'bava injala. ");
INSERT INTO wbi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pe uSetano akamwisila kukumughela akati, “Nave uve uli Mwana ghwa Nguluve, ghavuule amavue agha ghahambuke ghaave makate.” ");
INSERT INTO wbi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","uYesu akamuka akati, “Lilembilue mu Malembe aMimike kuuti, 'Ikyakulia kyene nakikum'biika umuunhu kuuva mwumi, looli iiva mwumi vwimila amasio ghooni ghano ijova Nguluve.'” ");
INSERT INTO wbi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pe uSetano akantwala uYesu mu likaaja ilyimike ilya Yelusalemu. Akam'biika pakyanya fiijo apa nyumba inyimike ija kufunyila, ");
INSERT INTO wbi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akam'buula akati, “Nave uve uli mwana ghwa Nguluve, ghujughuje paasi, ulwakuja mu avanyamhola vaake kulyuve vakwang'e mu mavoko ghaave kuuti aleke pighua pa livue na kulemela.”” ");
INSERT INTO wbi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","uYesu akamwamula kange akati, “Mu Malembe aMwimike lilambilue kuuti, “Nungamughelaghe uMutwa, uNguluve ghwako.” ");
INSERT INTO wbi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kange uSetano akamtwala uYesu pakyanya pa kidunda ikitali, pe akansoona iisi sooni palikimo nu vuvaha vwake. ");
INSERT INTO wbi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","akam'buula akati, “Nave ghufughama na na kukunyimika une, nikukupeela ifi fyoni.” ");
INSERT INTO wbi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pepano uYesu akati, “vuuka apa, Setano! Ulwakuva mu Malembe aMimike lilembile ndiiki, 'Umwimikaghe uMutwa, uNguluve Ghwako, kange um, bombelaghe jujuo mwene.' ");
INSERT INTO wbi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pepano uSetano akamuleka uYesu. Nakalingi, avanyamhola va Nguluve vakiisa, vakantengelela. ");
INSERT INTO wbi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Unsiki ghula uYohani uMwofughi alyadindilue mu ndinde. UYesu ye apuliike imhola ijuo akalutga ku Galilaya. ");
INSERT INTO wbi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ukuo, akavuuka mu kikaaja ikya Nasaleti akaluta kukukala mu likaaja ilya Kapenaumu. Ilikaaja ilio lilyale mulubale mu lisube ilya Galilaya, imbale isa iisi ija Sabuloni ni ja Nafutali. ");
INSERT INTO wbi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Uluo lulyavombiike kukwilanisia ilisio lino uMutwa alyajovile kukilila um'bili ghwake uYesaya kuuti, ");
INSERT INTO wbi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ilise ija Sabuloni ni ja Nafutali, mu sila jino jiluta ku sumbe, imambo ja kikohka ikya Yolidani, iisi ija Galilaya, kwe kuno vikukala avaanhu vano na Vayahudi. ");
INSERT INTO wbi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Avaanhu vala vano vikukakala mu ng'hiisi, valwaghile ulumuli uluvaha; voonpe vano vikukala mu ng'hiisi ija vufue, ulumuli luvamuliike.” ");
INSERT INTO wbi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuhuma unsiki ghula, uYesu akatengula kupulisia iiti, “Mulataghe inyivi siinu ulwakuva uvutwa uvwa kukyanya vuli piipi.” ");
INSERT INTO wbi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","UYesu ye ighenda mulubale mu lisumbe ilya Galilaya, akavaagha avaanhu vavili vanamuunhu, juonga ghwe Simoni juno ilitavua ilingi akatambulwagha Peteli, nu Ndeleeya. Avaanhu ava valyale valovi, vakava nu nyaafu vilova isamaki mu lisumbe. ");
INSERT INTO wbi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","UYesu akavavuula akati, Mumbingililaghe! Une nikuvaviika kuuva valovi va vaanhu.” ");
INSERT INTO wbi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Unsiki ghughuo vakasileka inyaafu saave, vakam'bingilila. ");
INSERT INTO wbi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","UYesu akaluta pavulongolo padebe, akavaagha avanamuunhu vavili uYakovo nu Yohani avakina Sebedaayi. Avuo, valyale mu ngalava palikimo nu viise uSebedaayi, vakava viling'hania inyaafu saave, voope akavakemeela. ");
INSERT INTO wbi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pala pala avanamuunhu vala vakamuleka uviise ni ngalava, vakam'bingilila uYesu. ");
INSERT INTO wbi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","UYesu akava ighenda mu kighavo kyoni ikya Galilaya. Akava ikwingila mu masinagogi ghaave, ivulanisia na kupulisia iMhola iNofu ija vutwa vwaNguluve, kange akavasosyaghe avatamu inhamu saave sooni. ");
INSERT INTO wbi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Imhola saake sikkakwila fiijo kuhanga kufika mu kighavo kyoni ikya Silia. Avaanhu pe vakavatwalagha avatamu vooni vano valyale ni nhumu sino silyale papinga. Mu avuo, mwevalyale vano valyale na mapepo amalamafu, na vanya kivafi na vanya liteela. UYesu akavasosyagha avuo vooni. ");
INSERT INTO wbi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Amapugha agha vaanhu kuhuma ku Galilaya, ku Dekapoli, ku Yelusalemu, ku Yudea ni mwambo ija kikogha ikya Yolidani ghakava ghikum'bili. ");
INSERT INTO wbi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","UYesu ye aghavwene amapungha ghala, akatogha pa kidunda, akikala. Avavulanisua vaake vakaluta pa mwene. ");
INSERT INTO wbi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","pe akategula kukuvavulanisia, akati, ");
INSERT INTO wbi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Vafunyilue vano vikumlonda uNguluvi kukila ifingi fyoni ulwakuva vilikwupila uluvonolo lwane ku vutwa uvwa kunyanya. ");
INSERT INTO wbi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Vafunyilue vano vali nu lusukunalo, ulwakuva uNguluve ilikuvanyamasia. ");
INSERT INTO wbi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Vafunyilue avakoola, ulwakuva uNguluve ilivapeela uvuhaasi uvwa iisi. ");
INSERT INTO wbi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vafunyilue vano visyukua kuvomba sino ikeela uNGuluve, ulwakuva uNguluve ilikuvapeela fyoni. ");
INSERT INTO wbi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vafunyilue vano vali nu lusungu, ulwakuva uNguluve ilikuvasungukila. ");
INSERT INTO wbi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Vafunyilue vano vali nu mwojo um'balafu, ulwakuva vilikumwagha uNguluve. ");
INSERT INTO wbi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Vafunyilue vano vikusambania avaanhu, ulwakuava vitambulwagha vana va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vafunyilue vano vipumusivua vwimila kuvomba sino ikeela uNguluve, ulwakuva uvutwa vwa kukyanya vwane. ");
INSERT INTO wbi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mufunyilue umue, avaanhu pano vikuvaligha, vikuvapumusia na kukuvajova fivi mu nyinga vwimila une. ");
INSERT INTO wbi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muhovokaghe fiijo na kuuva nu lukeelo, ulwakuva uluvonolo lwinu kukyanya, lugome. Enendiiki nava vavili vano valyalongwile fye valyapumusivue. ");
INSERT INTO wbi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Umue muli mwinyo ku vaanhu va mu iisi. Neke umwinyo ghungasupuke lwoni, ndepoonu ghuviika kiki kugomosia ulunoneesi? Umwinyo ughuo, naghunoghiile nambe padebe, looli ghuuva ghwa kutaghua, ghukanyweghe na vaanhu. ");
INSERT INTO wbi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Umue muli lumuli ku vaanhu va mu iisi. Ilikaaja lino lijengilue pakyanya pa kidunda, nalingifise. ");
INSERT INTO wbi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kange, vaanhu navikunga itaaala na kukupikila ni liteneka, looli viviika pa kyimilo kuuti jivamulikaghe vooni vano vali mu nyumba. ");
INSERT INTO wbi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Fye enendiiki, ulumuli lwinu lumulikaghe, kuuti avaanhu valolaghe imbombo siinu inofu, mu uluo vamughiniaghe, uNhaata ghwinu juno ali kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mulekaghe kusaagha kuuti nisile kuvusia indeaghilo sa Moose, nambe imbulanisio isa vavilu, jeeje? Looli nisile kukwilanisia. ");
INSERT INTO wbi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kyang'haani nikuvavuula kuuti, uvulanga ni iisi pano fikyale kusovanika, nakwekale nambe akakelo kamo aka ndaghilo kano ndepoonu kivusivua, kuhanga fyoni fino uNguluve alyalaghile, fivombeke. ");
INSERT INTO wbi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lino umuunhu ghweni juno ideenya ululaghilo, nambe luno musaagha kuuti lulaghilo ludebe kukila sooni, kange ivulanisia avange kuvomba uluo, ujuo iiva n'debe fiijo mu nutwa vwa kukyanya. Neke umuunhu ghweni juno ivingilila indaghilo na kuvulanisia avange kuuti vasivingililaghe, ujuo iiva m'baha mu vutwa vwa kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lino, nikuvavuula kuuti, nave uvugholofu vwinu navukika uvugholofu uvwa Vafalisayi nu vwa vavulanisi va ngaghilo, namulingila lusiku mu vutwa vwa kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mupuliike vule avakuulu viinu valyavulilue kuuti, 'Nungabudaghe, umuunhu ghweni juno ibuda un'jaake, anoghiile kuhighua,' ");
INSERT INTO wbi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Neke une nikuvavuula kuuti umuunhu ghweni juno kalalila un, jaake, anoghile kuhighua. Kange, umuunhu ghweni juno iligha un, jaake kuuti n, jasu, anoghile kuhighua pa kipugha kya valongosi. Umuunhu ghweni juno iligha un'jaaake kuuti mululute, anoghiile kutaghua ku lupumuko lwa mwoto ghuno naghusima lusiku. ");
INSERT INTO wbi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“ Lino, nave uletile ilitekelo lyako pa kitekelelo kukuntavulila uNguluve, neke ghukumbuka kuuti un, jaako ali ni lisio nuuve. ");
INSERT INTO wbi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Lileke ilitekelo ilio pa kitekelelo, neke ulute asambane taasi nu n'jaako, pe ghwise utavule ilitekelo lyako ilio. ");
INSERT INTO wbi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ Kange, nave umuunhu jumonga ikukutwala kwa mhighi, unsuume ng'haning'haani kuuti musambane vul, e mujiighe. mu sila. Nave naghuvomba uluo, ikukuviika mu mavoko gha mhighi. Ghwope umhighi ikukutwala kwa masinjala kuuti akudindile mu ndinde. ");
INSERT INTO wbi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kyang'haani nikukuvuula, nungahume munkate umuo kuhanga uhombe fyoni fino ghusighilua. ");
INSERT INTO wbi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ Mupuliike vule avaanhu valyavulilue kuuti, 'Nungavwafukaghe.' ");
INSERT INTO wbi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Neke une nikuvavuula kuuti, umuunhu ghweni juno ikumulola umukijuuva mukwa kunnoghelua, iiva avwafwike naghwo mu mwojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Lino, iliiso lyako lingakwambusie, ng'omotola, utaaghe ku vutali. Yekuba kusofia ikilungo kimo m'bili, ghwoni kutaghua ku lupumuko lwa mwoto ghuno naghusima lusiku. ");
INSERT INTO wbi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kange, uluvoko lwako lungakwambusie dumula attaghe ku vutali. Ulwakuva yekuba kusofia ikilungo kimo mu m'bili, kukila um'bili ghwoni kutaghua ku lupumuko lwa mwoto ghuno naghusima lusiku. ");
INSERT INTO wbi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kange, lilyajovilue kuuti, 'Umuunhu juno ikuntavula un'dala ghwake, ampelaghe ikalata ija kuntavula.' ");
INSERT INTO wbi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Neke une nikuvavuula kuuti, umuunhu ghweni juno itavula un'dala ghwake, nave un'dala ujuo nam'bwafu, ikumpelela kuuva m'bwafu. Kange, umuunhu angatoole un'dala juno umughoosi antwavil, e, ghwope ivva ivwafuka. ");
INSERT INTO wbi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kange, mupuliike vule avakuulu viinu valyavulilue kuuti, ulekaghe kujiigha isa vudesi, 'Looli pano ujighile, uvombaghe sooni sino ujighile,' ");
INSERT INTO wbi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Neke une nikuvavuula kuuti, namungajighaghe nambe pedebe. Namungajighaghe mulwa kutambula kukyanya, ulwakuva kye kitengo ikya vutwa ikya Nguluve, ");
INSERT INTO wbi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nambe kujiisha mulwa kutambula iisi ulwakuva pepano uNguluvi iviika amaghulu ghaake; nambe kujiigha mulwa kutambula ilikaaja ilya Yelusalemu, ulwakuva lye likaaja lya Ntwa um'baha. ");
INSERT INTO wbi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kange, namungajighaghe mulwa kutambula amatu ghiinu, ulwakuva namungadule nambe ulunyele lumo kuuva luvalafu nambe kuuva lutiitu. ");
INSERT INTO wbi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lino, nave mukwitika, mutisaghe, 'Eena,' nave mukaana mutisaghe, 'Ndali', ulwakuva sooni sino ikwangelela mu isio, sihuma kwa Mhosi uSetano. ");
INSERT INTO wbi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mupulike vule lilyajovilue kuuti, 'Umuunhu angakung'omotole iliiso, na juuve ng'omotola ilyake, angakukuule iliino, na juuve kuula ilyake.' ");
INSERT INTO wbi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","neke une nikakuvuula kuuti, umuunhu juno akuvombiile uvuviivi, nungavangilaghe. Umuunhu angakusevula uvudili uvwa kundio, unsyetukisie nu vwa kung'highi. ");
INSERT INTO wbi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nave umuunhu ikukutwala pa vuhighi kuhighua mu vufumbue uvwa kutoola ighwandi jaako, mulekele atoole nali likooti. ");
INSERT INTO wbi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nave umuunhu ikukwumilisia kupinda unsigho ghwake mu lughendo ulwa kavalilo kamo, uve ulghendaghe ifivalilo fivili. ");
INSERT INTO wbi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kange, umuunhu angakusuume kimonga, mpeele. Nav e umuunhu ilinda kukopa kulyuve, nungankanaghe. ");
INSERT INTO wbi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mupuliike vule lilyajovilue kuuti, Umughanaghe unnino, na kukunkalalila umulugu ghwako.' ");
INSERT INTO wbi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Neke une nikuvavuula kuuti, muvaghanaghe avalugu viinu, kange muvasumilaghe kwa Nuluve vano ali vikuva pumusia. ");
INSERT INTO wbi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Apuo pe muuva vaana va Nhaata ghwinu juno ali kukyanya, ulwakuva umwene ikuvapeela ulujuva avaanhu avanofu na vaviivi. Kange, ilikuvapeela ifula avagholofu na vano navagholofu. ");
INSERT INTO wbi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mungavaghane va vano vikuvaghana umue, muuva nu luvumbililo luki? Ongo voope avasongesia songo vivomba vulevul, e. ");
INSERT INTO wbi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kange, nave mukuvahungila va vajiinu muvomba kiki ikinofu kukila avange? Ongo voope avapanji vihungilana vule vule. ");
INSERT INTO wbi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Lino, muvisaghe vagholofu ndavule uNhaata ghwinu juno ali kukyanya vule mugholofu. ");
INSERT INTO wbi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ Mulolaghe! Namungavombaghe inofu pamaaso gha vaanhu kuuti vavaghinie. Ulwakuva mungavombe uluo, namungupile uluvonolo kuhuma kwa Nhaata ghwinu juno ali kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Lino, pano mukuvantanga avakatofu namungakwisyaghe imhola isio ku vaanhu ndavule vivomba avake dusi mu masinagogi na mu sila, kuuti avaanhu vavaghinie. Kyang'haani nikuvavuula, viivi vamalie pikwupila uluhombo lwave. ");
INSERT INTO wbi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Neke uve pano ukuvatanga avakotofu, uvatanhaghe kisyefu kuuti nambe ummanyaani ghwako alekaghe pikagula. ");
INSERT INTO wbi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ulutango lwako luvombekaghe kisyefu, ulwakuva uNhaata gwako juno ilola sino sili ku vusyefu, ilikukuhomba ");
INSERT INTO wbi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pano mukufuunya kwa Nguluve, namungavisaghe ndavule avakedusi, ulwakuva aveene pano vikufuunya vilonda kukwima mu masinagogi na mu silamalekano kukuvonia ku vaanhu. KYang'haani nikuvavuula, avuo vamalile pikwupila uluhombo lwave. ");
INSERT INTO wbi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Looli uve pano ghukufuunya kwa Nguluve, ghwingilaghe kukate na kudinda umulyango. Pe ghufunyaghe kwa Nhaata ghwako juno naivoneka na maaso. UNhaata ghwako juno ilola sino sivombeka ku vusyefu, ilikukuhomba.” “ ");
INSERT INTO wbi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kange, pano mukufuunya kwa Nguluve, mulekaghe kukeela kujova amasio aminga amasila muluvo ndavule vivomba vano navikumwitika uNguluve. Ulwakuva aveene visaagha kuuti uNguluve ghwave ikuvapulika vwimila amasio ghaave aminga. ");
INSERT INTO wbi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lino, namungifunyaghe ndavule vivomba aveene, ulwakuva uNhaata ghwinu akaghwile sino mulonda nambe ye mukyale kukunsuuma. ");
INSERT INTO wbi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Umue pano mukufuunya kwa Nguluve, mutisaghe, 'Gwe Nhaata uve uli kukyanya, ilitavua lyako lyimikwaghe. ");
INSERT INTO wbi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Uvutwa vwako vwisaghe. Sino ukeliile sivimbekaghe pa iisi apa, ndavule sivombeka kukyanya ukuo. ");
INSERT INTO wbi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupelaghe umusyughu ifyakulia fiitu. ");
INSERT INTO wbi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utupyaninilaghe uvuuvuhosi vwitu, ndavule na jusue vule tukuvapyanila vano vatuhokile. ");
INSERT INTO wbi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nungatulekaghe kuuva mu ngelo, looli utupokaghe kwa mhosi jula. Ulwakuva uvutwa vwako, ingufu saako nu vuvaha vwako vuli fighono fyoni! Amina' ");
INSERT INTO wbi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ulwakuva nave mukuvyapyanila avange vano vavahokile, ghwope unhaata ghwinu juno ali kukyanya, ikuvapyanila uvuhosi vwinu. ");
INSERT INTO wbi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Looli, nave namukuvapyanila vano vavahokile, naju Nhaata ghwinu ughwa kukyanya naikuvapyanila uvuhosi vwinu. ");
INSERT INTO wbi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pano muvuhiila kulia mulwa kufuunya, mulekaghe kusukunala ndavule vivomba avakedusi, ulwakuva aveene visukunala kuvonia avaanhu kuuti vavuhilile kulia mulwa kufuunya. Kyang'haani nikuvavuula, avuo vamalile pikupila uluhombo lwave. ");
INSERT INTO wbi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Looli uve nave uvuhimle kulia mulwa kufuunya, ghwoghaghe ku maaso na kupakala amafuta. ");
INSERT INTO wbi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kuuti uleke kuvoneka ku vaanhu, looli kwa Nhaata ghwako mwene juno naivoneka na maaso. Ghwope uNhaata juno ikusaagha sino ku vusyefu, ilikukuhomba.” ");
INSERT INTO wbi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Namungavutaghe ifiinu mu iisi iji, muno umhehe ni ng'husa nafinangania, kange avaahiji navimatula nambe kuhiija. ");
INSERT INTO wbi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Looli muvataghe ifiinu kukyanya kuno umhehe ni ng'husa nafinangania, kange avahiija navimatula nambe kuhiija ");
INSERT INTO wbi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ulwakuva pano uvutile ifiinu fyako, pepano naghu mwojo ghwako ghuuva bahapuo. ");
INSERT INTO wbi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Amaaso ghaako taala ja m'bili ghwako ghwoni ghuuva mu mu lumuli. ");
INSERT INTO wbi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Neke nave iliiso lyako libofu, um'bili ghwako ghwoni ghuuva mu ng'hiisi. Lino, nave ikinu kino kiveele kinoghiile kuuva lumuli, nakimulika, pe ing'hiisi iijio jiiva mbaha kyongo!” ");
INSERT INTO wbi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“nakwale umuunhu juno iiva m' banda ghwa vatwa vavili. Ulwakuva pano ikumughana na kukum'bombela vunofu untwa uju, pepano ikukalalila na kukum'beda utwa ujunge. Ikyuma kingakutema nungam'bombele uNguluve! ");
INSERT INTO wbi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ Lino nikuvavuula niiti, mulekaghe kuhangaika vwimila uvwumi vwinu kuuti kyande mulia kiki, nambe mufwala kiki. Asia, uvwumi navwe vuvaha kukila ikyakulia? Naghu m'bili naghwe m'baha kukila amenda? ");
INSERT INTO wbi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mulolaghe injuni Nasivyala, nasipeta nambe kuvuta mu kihenge, neke uNhaata ghwinu ughwa kukyanya, ikusiswila. Asi, umue namunoghiile kukila injuni isio ");
INSERT INTO wbi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ghwe veeni mulyumue juno ndepoonu ihangajika, kuuti ongelesie uvwumi vwake nambe akavaliko kamo? “kiki musaagha vwimila ifya kufwala? ");
INSERT INTO wbi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Lolagha amaluva ndavule ghikula, naghivomba imbombo nambe kuhona amenda ghaake agha kufwala. ");
INSERT INTO wbi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Neke nikuvavuula kuuti, nambe uSolomoni mu vuvaha vwake vwoni, naalyaghelile kufwalilila neke anoghele ndavule ililuva limonga! ");
INSERT INTO wbi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nave uNguluve ikughafwasia enendiiki amamele agha mu lihaka ghano ghinofia unsiki n'debe vuvule neke nakalinga ghijoghotoka na kutaghua pa mwoto, lino nakyaikuvafwasia umue na kukila, umue mwe vavya lwitiko ludebe? ");
INSERT INTO wbi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Lino, mulekaghe kutungumala kuuti, “Tulia kiki, tunyua kiki, nambe tufwala kiki,' ");
INSERT INTO wbi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ulwakuva ifio fyoni vihangajikila vano navammanyile uNguluve. UNhaata ghwinu juno ali kukyanya akaghwile vunofu kuuti mulonda sooni isio. ");
INSERT INTO wbi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Looli mulondaghe taasi uvutwa vwa Nguluve na kuvomba sino ikeela umwene, neke ifio fyoni ikuvongelesia”. ");
INSERT INTO wbi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Lino, namungasaghaghe vwimila ifya pakilaavo, ulwakuva ifya pakilaavo pwefili vwimila ikighono ikio. Kila kighono kili na mahangaiko ghaake. ");
INSERT INTO wbi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Namungavahighaghe avange kuuti jumue muleke kuhighua nu Nguluve, ");
INSERT INTO wbi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ulwakuva vule mukuvahigha avange, na jumue mulihighua vule vule. Ikighelelo kino mughelela avange, kye kino uNguluve ilikuvaghelela na jumue. ");
INSERT INTO wbi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Kiki ghughimba kukola akameng'enyo aka mbavo kano kali mu liiso ilya n'jaako neke naghulola ikipiki kino kili mu liiso lyake? ");
INSERT INTO wbi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kange, lwandaani ukum'buula un'jaako kuuti “Leka nikuvusie akameng'enyo aka mbavo kano kali mu liiso lyako,' pano mu liiso lyako juuve mwekili ikipiki? ");
INSERT INTO wbi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ghwe nkedusi uve! Vusia taasi ikipiki kino kili mu liiso lyako. Apuo pe ukukaagha vunofu na kuvusia amengenyo aka mbavo kano kali mu iliiso lya n'jaako!” ");
INSERT INTO wbi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Namungasipelaghe imbua ifiinu ifyimike, ulwakuva ndepoonu sikuvagalukila na kukuvang'enya; nambe kukusijughujila ingube ifiinu ifya ndalama nyinga fino filengadika, ulwakuva ndepoonu sikufinyania mu matope.” ");
INSERT INTO wbi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Musumaghe, uNguluvi ikuvapeela; uNguluve ikuvavonekesia; MUhonesyaghe, uNguluve ikuvadindulila. ");
INSERT INTO wbi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ulwakuva umuunhu ghweni juno isuuma, ipelua; juno ilonda ikufyagha; ghwope juno idodesia, idindulilua.” ");
INSERT INTO wbi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Asia, ghwe veene mulyumue, juno umwanaake angansuume unkate, ikumpeela ilivue? ");
INSERT INTO wbi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nambbe angansuume isamaki ikumpeela injoka? ");
INSERT INTO wbi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nave umue, mwe vahosi mukaghwile kukuvapeela avaana viinu ifiinu ifinofu, lino uNhaata ghwinu ughwa kukyanya, nakaivomba vunofu, kukila, kukuvapeela ifiinu ifinofu vano vikunsuuma?” ");
INSERT INTO wbi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Lino, muvavombelaghe avange ndavule na jumue vule mukeela vavavombelaghe. Ulwakuva isio se ndaghilo sa Moose ni mbulanisio sa vavili. ");
INSERT INTO wbi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mwingilaghe kukilila umulyango umfinye, ulwakuva umulyango ughwa kwingilila kuvutipulo mweleefu, naji sila ija kulutila ukuo nyeleefu. Kange, avaaanhu vano vikilila ukuo, vinga. ");
INSERT INTO wbi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Looli umulyango ughwa kwingilila ku vwumi mfinye, naji sila jino jiluta ku vwumi finye, kange avaanhu vano vikujaagha, vadebe”. ");
INSERT INTO wbi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Muvisaghe maaso na vavili ava vudesi, ulwakuva aveene pano vikwisa kulyume, pa maaso vivonaka hwene ng'holo, neke nkate mu moojo ghaave, ng'hekeeva ng'hali. ");
INSERT INTO wbi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Avaanhu avuo, mukuvakagula vwimila imbombo saave, Avaanhu navidonola isabibu mu matunguliisa, nambe kudonola amafyulisi mu mavajula. ");
INSERT INTO wbi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kwekuti, umpiki unnono ghukoma ifipeke ifinono, umpiki um'biivi ghukoma ifipeke ifiivi. ");
INSERT INTO wbi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nakweghule umpiki unnono ghuno ghukoma ifipeke ifiviivi, nambe umpiki um'biivi ghuno ghukoma ifipeke ifinono, ");
INSERT INTO wbi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kange, umpiki ghuno naghukoma ifipeke ifinono, ghudumulua na kutaghua pa mwoto. ");
INSERT INTO wbi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lino, avavili avuo ava vudesi, mukuvakagula vwimila imbombo saave.” ");
INSERT INTO wbi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nakwekuti umuunhu ghwenu juno iiti, 'Mutwa, Mutwa,' ilikwingila mu vutwa vwa kukyanya, looli juno ivomba uvughane vwa Nhaata ghwango juno ali kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ikighono ikya vuhighi kiliiva kifikile, vingavilikumbuula viiti, 'Mutwa, Mutwa! Ongo twapulisyagha imhola kuhuma kulyuve na kudaga amapepo amalamafu na kuvomba ifidegho finga mu litavua lyako!' ");
INSERT INTO wbi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Apuo nilikuvavuula kisila kufisa, niliiti, 'Nanivamanyile umue nambe padebe! Vuuka apa, umue mwe vano muvomba uvuhosi!”” ");
INSERT INTO wbi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“LIno, umuunhu juno ipulika amasio ghango agha na kukughavingilila, iiva ndavule umuunhu unya luhala juno alyajengile inyumba jaake pa linhalavu. ");
INSERT INTO wbi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ifula jikatoonya, nasi ndenga sikamema. Imhepo imbaha jikagugula na kusukania inyumba jila. Neke inyumba jila najikaghua ulwakuva ulwalo lwake lulyajengilue pa linhalavue. ");
INSERT INTO wbi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Neke umuunhu ghweni juno ipulika amasio ghango agha, neke naikughavingilila, ujuo iiva ndavule umuunhu un'jasu juno alyajengile inyumba jaake pa lihanga. ");
INSERT INTO wbi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ifula jikatoonya, nasi ndenga sikamema. Imhepo imbaha jikagugula na kusukania inyumba jila, nakalingi jikaghua nu mughindi um'baha! ");
INSERT INTO wbi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","UYesu ye amalike kujova amasio aghuo, ilipugha lila likadegha kyongo vwimila imbulanisio saake, ");
INSERT INTO wbi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ulwakuva alyale ivulanisia hwene muunhu nya vutavulilua, naakavulanisiasyagha ndavule avavulanisi vaane ava ndaghilo. ");
INSERT INTO wbi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","UYesu akiika kuhuma ku kidunda, ilipugha lya vaanhu likam, bingilila. ");
INSERT INTO wbi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pe umuunhu jumonga unya buuba akiisa na kufughama pa Yesu, akam'buula akati, “Ghwe Mutwa, nave ukeliile kukumbalasia nisuuma umbalasie!” ");
INSERT INTO wbi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","UYesu akgholosia uluvoko, akamwabasia, akati, Nikeela, valala!” Unsiki ghughuo umuunhu jula, akavalala. ");
INSERT INTO wbi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pe UYesu akam'buula akati, “Nungam'bulaghe nambe muunhu imhola isi! Ulwene uluta ghuhufie kwa ntekesi, ukahumie ilitekelo ndavule alyalaghiile uMoose, neke vuuve vwolesi ku vaanhu vooni kuuti avalasivue.” ");
INSERT INTO wbi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","UYesu akaluta mu likaaja ilya Kapelenaumu. Ye ikwingila mu likaaja ililo, um'baha jumonga ughwa vasikali ava kilooma akiisa, ");
INSERT INTO wbi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akampelepesia akati, “Ghwe Mutwa, um'bombi ghwango ighona ku kaaja, ali ni nhamu ija liteela, ivavua kyongo,” ");
INSERT INTO wbi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","UYesu akam'buula akati, “Nikwisa, ninsosie.” ");
INSERT INTO wbi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Neke um'baha jula akamula, akati, “Ghwe Ntwa, uleke kukwingila mu nyumba jango ulwakuva une naninoghiile. Uve ujove li lisio lyene, um'bombi ghwngo isooka. ");
INSERT INTO wbi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nijova enendiiki ulwakuva, na juune nipulika ku vavaha vango, kange nili na vasikali vano vipulika kulyune. Ningam'buule jumonga niiti, 'Luta!' Iluta. Ujunge, ningati, 'Isa!' Ikwisa. Naju m'bombi ghwango ningam'buule kuuti, 'vomba ndiiki,' ivomba.” ");
INSERT INTO wbi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","UYesu ye apulike amasio aghuo, akadegha, akavavuula vano valyale vikum'binglila, akati, “Kyang'haani nikuvavuula kuuti mu Vaisilaeli vooni nanimwaghile umuunhu unya lwitiko ulukome ndavule uju! ");
INSERT INTO wbi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nikuvavuula kuuti avaanhu vinga kuhuma imbali sooni isa iisivilikwisa na kukukala pa kikulukulu nu lukeelo palikimo na vakulu viitu uAbulahamu, nu Isaka, nu Yakovo mu vutwa vwa kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Looli aVayahudi vano vakanoghiile kuuva mu vutwa uvuo vilitaghua kunji ku ng'hiisi, ukuo vilililagha na kugwegwenula amiino ulwakuva vali mu vuvafi uvukome.” ");
INSERT INTO wbi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pe uYesu akam'buula um'baha jula akati, “Vujagha! Sivombeke kulyuve ndavule lulivuo ulwitiko lwako.” Unsiki ghula ghula, um'bombi ghwa m'baha jula akasooka. ");
INSERT INTO wbi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pambele uYesu akingila mu nyumba ja Peteli, umuo akamwagha unkwive ghwa Peteli kwekuti ung'ina ghwa n'dala ali ni mhungu, aghonile pa kitala. ");
INSERT INTO wbi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pe uYesu akamwabasia uluvoko, akasooka, akiima akategula kukuvatengelela. ");
INSERT INTO wbi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ye vwimile, vakamuletela uYesu avaanhu vinga avanya mapepo. Pe akaghadaga amapepo ghala ku ngufu sa lisio lyake. Kange akavasosia avatamu vooni. ");
INSERT INTO wbi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Isio sikavombiike kukwilanisia sino silyajovilue nu m'bili uYesaya kuuti, “Akavusia inhamu siitu, akatusosia” ");
INSERT INTO wbi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ilipugha ilya vaanhu likansyungutila uYesu. UYesu ye aluvwene uluo, akavavuula avavulanisivua vaake kuuti valovoke valute imwambo jila. ");
INSERT INTO wbi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pe um'bulanisi jumonga ughwa ndaghilo sa Moose akaluta pa Yesu, akam'buula akati, “Gwe M'bulanisi, nilonda kuuva m'bingilili ghwako, nikukuvingililagha kwoni kuno ghuluta.” ");
INSERT INTO wbi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","UYesu akati, “Ing'heve sili ni mhanga, injuni sili ni fivwasu, neke ne Mwana ghwa Muunhu nili nsila nambe apa kughona!” ");
INSERT INTO wbi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pambele, jumonga mu vavulanisivua vaake akam'buula akati, Ghwe Mutwa, unhavule nulute taasi ninsyile unhaata ghwango.” ");
INSERT INTO wbi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Neke uYesu akam'buula akati, “Umbingililaghe! Valeke avafue vavasyile avafue avaave.” ");
INSERT INTO wbi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pe uYesu akingila mu ngalava, voope avavunisiavua vaake vakingila mula, vakavuuka viluta. ");
INSERT INTO wbi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ye vali mu lisumbe, nakalingi imhepo imbaha jikagugula, amavingo amavaha ghakatengula kukupikila ingalava jila. Unsiki ughuo UYesu akaghoneliile. ");
INSERT INTO wbi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Avavulanisivua vaake vakaluta pa mwene vakansisimula, vakati, Mutwa, utupoke! Tufua!” ");
INSERT INTO wbi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","UYesu akavamula akati, “kiki muli voghofi, mwe vanya lwitiko ludebe umue? Pe akiima, akajidalikila imhepo nilisumbe, kukalitamalwoni. ");
INSERT INTO wbi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Avavulanisivua vaake vakadegha kyongo vakati, “Uju ghwe veeni juno imhepo na mavingo fikumpulika?” ");
INSERT INTO wbi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pambele ye valovwike vali imwambo ija Vagelasi, uYesu akatang'hana na vaanhu vavili avanya mapepo, vahumile kuno vikukala ku mbiipa. Avaanhu avuo valyale vakali kyongo, nakwealyale umuunhu juno akaghelagha kukila isila jila. ");
INSERT INTO wbi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Avaanhu avuo vakakoola fiijo vakati, “Ghwe Mwana ghwa Nguluve, tuli vuki nuuve? Ghwisile kuno kukutupumsia pano unsiki ghwitu ghukyale?” ");
INSERT INTO wbi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pa vutali padebe pwelilyale ilipugha ilya ngube, lidimua. ");
INSERT INTO wbi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pe amapepo ghala ghakampelepesia uYesu, ghakati, “Nave ukutudaga, utwitikisie tulute, twingile mu lipugha lila ilya ngube. ");
INSERT INTO wbi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","UYesu akati, “Lutagha!” pe ghakahuma mu vaanhu vala, ghakingila mu lipugha lila ilya ngube. Nakalingi ilipugha lilalyoni likiika luvilo, likaselebukila mu lisumbe, ingube sooni sikafua. ");
INSERT INTO wbi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Avadiimi va ngube vakakimbila luvilo, vakaluta mu likaaja, vakapanga sooni sino sivombiike, palikimo na sino sihumiile ku vanya mapepo vala. ");
INSERT INTO wbi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Avaanhu vooi ava likaaja ilio vakahuma, vakuluta kwa Yesu. Ye vamwaghile, vakampelepesia avuuke mu iisi jaave. ");
INSERT INTO wbi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","UYesu akapanda ingalava, akalovoka ilisumbe ilya Galilaya, akagomoka mu likaaja lyake Kapelenaumu. ");
INSERT INTO wbi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pe avaanhu vamonga vakamuletela umuunhu unya nhamu ija liteela, aghonile pa keteefu. UYesu ye aluvwene ulwiltikko lwave kwa mwene, akati kwa ntamu, Mwanango, ghukangasie! Upyanilue inyivi saako.” ");
INSERT INTO wbi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pe aqvavulanisi va ndaghilo vamonga vakasaagha mu moojo ghaave vakati, “Umuunhu uju ikumulingha kyongo uNguluve!” ");
INSERT INTO wbi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Neke uYesu akasitang'hania sino vakva visaagha, akavaposia akati, “KIki musaagha imbiivi mu moojo ghiinu? ");
INSERT INTO wbi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Lino luhuugu luliku? Kukumbuula unya liteela kuuti, Upyanilue inyivi saako; nambe kuuti, Ima, ughendaghe?' ");
INSERT INTO wbi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lino pe mukagule kuuti une ne Mwana ghwa Muunhu nili nu vutavulilua uvwa kupyanila inyivi mu iisi muno” Pe akam'buula unya liteela akati, “Ima, veghela iliteefu lyako, vujagha.” ");
INSERT INTO wbi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Umuunhu jula akiima, akavuuka ivuja. ");
INSERT INTO wbi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Avaanhu mu lipugha ye vasivwene isio, lukavakola uludwesi, vakamughinia uNGuluve juno avapeliile avaanhu uvutavulilua ndavule uvuo. ");
INSERT INTO wbi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","UYesu akavuuka pala. Ye ighenda iluta, akamwagha umuunhu jumonga, ilitavua lyake ghwe Mataayi, ikalile pano isongekesia isongo. UYesu akam'buula akati, “Umbingililaghe.” Pe akavuuka, akamb'bingilila. ");
INSERT INTO wbi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe uYesu akaluta kulia ikyakulia kwa Mataayi. Ye vali mu nyumba jila, vakingila avasongesi songo vinga na vahosi, vakikala vuhanga ikikyakulia nu Yesu palikimo n a vavulanusivua vaake vakati. ");
INSERT INTO wbi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","AVafalisayi ye vasivwene isio, vakavaposia avavulllanisivua vaake vakati, “Kiki um'bulanisi ghwinu ihagha ikyakulia na vasongesia songo na vahosi?” ");
INSERT INTO wbi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Neke uYesu ye apuliike isio avavuula akati, “Avakafu navifumbua kuluta kwa mughanga, looli avatamu! ");
INSERT INTO wbi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lino, lutagha mkamanyile umuluvo ghwa masio agha, 'Nilonda umuunhu avisaghe nya lusungu kukila kuhumia ilitekelo; ulwakuva une nanilyakisisie kukuvakemeela vano vikuvona vagholofu, looli vano vitang'hinia kuuva vahosi.” ");
INSERT INTO wbi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pambele avavulanusivua va Yohani uMwofughi vakaluta kwa Yesu, vakamposia vakati, “Usue na Vafalisayi twatuvuhiila kulia mulwa kufuunya, ongo avavulanisivua vaako navivingilila ulwiho uluo?” ");
INSERT INTO wbi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Uyesu akavamula akati, “Vano vaghongolilue pa vutolani vali nu ntolan'dala, lwakiki vasukanalaghe? Looli filikwisa ifighono, pano untolan'dala ilivusivua. Apuo pepano vilivuhiila kulia mulwa kufuunya. ");
INSERT INTO wbi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nakwale umuunhu juno ihonela ikigamba ikipia mu mwenda unkuulu, ulwakuva ikigamba ikio kidemule umwenda unkuulu ughuo, pe uvudemule vukwongelela kyoko. ");
INSERT INTO wbi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kange, avaanhu naviviika uluhuuje uluuje ulupia mu nyambe ing'huulu, nave fye vavombe uluo, inyambe sipusuka, uluhuuje kukung'hika nasi nyambe sinangika. Looli viviika uluhuuje ulupia mu nyambe imia, pe inyambe nu luhuuje fijigha vunofu!” ");
INSERT INTO wbi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","UYesu ye ikavavuula amasio aghuo, akiisa umulongosi jumonga, akafughama pa mwene, akam'buula, akati, “Umwalivango afwile unsiki ghughuughu, sivuo tuvuuke uluvoko lwako pa mwene, neke aave mwinu.” ");
INSERT INTO wbi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pe uYesu akavvka palikimo na vavulanisivua vaake, akam'bingilila umulongosi jula. ");
INSERT INTO wbi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pwealyale umukijuuva jumonga juno alyale ni nhanu ija kuhuma idanda. Inhamu ijio jilyammwisie ammaka kijigho na ghavili. Umukijuuva ujuo akiisa kunsana kwa Yesu, akabasia uluvilo ulwa mwenda gwake. ");
INSERT INTO wbi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Akavomba uluo ulwakuva akasaghagha kuuti, “Ningabasie ghu mwenda ghwake, nisooka. ");
INSERT INTO wbi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ye abasisie, uYesu akasyetuka, akamwagha, akam'buula akati, “Mwalivango, kangala! Usokile vwimila ulwitiko lwako!” Unsiki ghula, umukijuuva jula akasooka. ");
INSERT INTO wbi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Uyesu ye afikile mu nyumba ija mulongosi jula, akavaagha avaanhu vinga vakong'hanile, vilila nu lusukunalo ulukome, vamonga vikuva ifilongilongi. ");
INSERT INTO wbi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","uYesu akavavuula akati, “Muvuuke! Ulwakuva umhija uju naafwiile, looli aghoneliile! Avaanhu vala vakanseka kyoyo. ");
INSERT INTO wbi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Umwene akavahumia kunji avaanhu vala, pe akingila kukate kwa mhinjajula, akankola uluvoko, umhinja jula akiima. ");
INSERT INTO wbi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Imhola isio sikakwila mu iisi jooni. ");
INSERT INTO wbi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","UYesu akavuuka pa kaaja ja mulongosi jula. Ye avukile pala pavabofu amaaso vavili, vakam'bingilila kumo vikemeela fiijo viiti, “Ghwe Mwana ghwa Davidi, utusungukile! ");
INSERT INTO wbi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","UYesu akingila mu nyumbba, voope avabofu vala vakingila. Pe akavaposia akati, “Asia, mukwitika kuuti une nili ni ngufu isa kuvasosia?” Aveene vakamwamula vakati, Eena, Mutwa! Tukwitika.” ");
INSERT INTO wbi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pe uYesu akavabasia amaaso ghaave, akavavuula akati, “Sivombeke kulyumue ndavule lulivuo ulwitiko lwinu. ");
INSERT INTO wbi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Amaaso ghaave ghakadinduka. Pe uYesu akavavuula akati, “Namungam'bulaghe nambe muunhu imhola isi!” ");
INSERT INTO wbi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Neke aveene vakavuuka, vakakwisia imhola saake mu iisi jila jooni. ");
INSERT INTO wbi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Avaanhu vavili avuo ye vavukile pala, avaanhu vamonga vakamuletela uYesu umuunhu juno alyale ni lipepo. Ilipepo ilio lilyampeleliile kuuva kinuunu. ");
INSERT INTO wbi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pe uYesu akalidaga ilipepo lil, unsiki ghughuo umuunhu jula akateghula kuvoja kange. Avaanhu vano pwepalyale pala vakadegha kyongo, vakat, “Isi nasighelile kuvoneka nambe padebe mu iisi jooni ija Isilaeli.” ");
INSERT INTO wbi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Neke aVafalisayi vakatisagha, “Umuunhu uju idaga amapepo mu ngufu isa livaha lya mapepo! ");
INSERT INTO wbi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pe uYesu akava iluta mu makaaja ghooni na mu fikaaj. Akava ikwingila mu masinagogi ghaave ivulania na kupulisia iMhola iNofu ija vutwa vwa Nguluve, kange akavasyagha avatamu inhamu saave sooni. ");
INSERT INTO wbi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ye ikulivona ilipugha ilya vaanhu, akavavonela ikisa, ulwakuva valyale vihangajika, navalyale nu ghwa kuvatanga, valyale hwene ng'holo isila n'diimi. ");
INSERT INTO wbi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pe akavavuula avavulanisivua vaake akati, “Mu mughunda ifiinu fimotwike, neke avanya kupeta vadebe. ");
INSERT INTO wbi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lino, munsuume unya mughunda, asuung'he avvanhu avange avanya kupeta.” ");
INSERT INTO wbi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","UYesu akavakemeela avavulanisivua vaake kijigho va vavili, akavapeela uvutavulilua uvwa kudaga ampepo amalamafu, kusosia inhamu sooni nu vuvotevote vuno vuli papinga ");
INSERT INTO wbi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amatavua gha vasung'hua avuo kijiho na vavili ghe agha: ughwa kwanda ghwe Simoni, juno itambulua Peteli, nu Ndeleeya unnuuna, avakina Sebedaayi uYakovo nu Yohani unnuuna, ");
INSERT INTO wbi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","uFilipo, uBatolomaayo, uTomasi, uMataayi unsongesia songo, uYakovo unkina Alifaayo, uTadaayo ");
INSERT INTO wbi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","uSimoni uKananayo nu Yuuda Isikalioti, juno pambele akamwohela uYesu. ");
INSERT INTO wbi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","UYesu akavasuung'ha avuo kijigho na vavili, akavalaghila akati, “Namungalutaghe ku vaanhu vano namungingilaghe mu makaaja ghooni agha Vasamalia. ");
INSERT INTO wbi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Looli mulutaghe ku Vaisilaeli vano vali ndavule ing'holo sino sisovile. ");
INSERT INTO wbi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pano muluta, mupulisyaghe mutisaghe, 'Uvutwa uvwa kukyanya vufikile.' ");
INSERT INTO wbi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Musosyaghe avatamu na vyanya buuba, musyusyaghe avafue, na kudaga amapepo. Mupelilue vuvule uvutavulilua uvuo, na vumue muvatangaghe avaanhu vuvule. ");
INSERT INTO wbi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Namangagadaghe isahabu nambe indalama, nambe kudaga isilinge, ");
INSERT INTO wbi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nambe inyambe, nambe umwenda ughwa kwandula, nambe ifilatu ifya kwandula, nambe ulukwegho, ulwakuva um'bombi anoghiile kupelua fyoni fino ilonda. ");
INSERT INTO wbi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ Mu, likaaja nambe mu kikaaja muno kyamukwingila, mulindagheumuo umuunhu unnofu ughwa kuvupila. Mukalaghe kwa mwene kuhanga unsiki ghuno muvuuka. ");
INSERT INTO wbi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pano mukwingila mu nyumba, muvahungilaghe avanya nyumba. ");
INSERT INTO wbi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lino, nave avanya nyumba vapuliile muvasumilaghe kwa Nguluve kuuti avapelaghe ulutengaano. Looli vane navavupiile ulutengaano lujigha numue. ");
INSERT INTO wbi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nave umuunhu naikuvupila nambe kukuvapulikisia, pano muhum mu nyumba nambe mu likaaaja ilio mukung'unaghe ulung'hunde luno luli mu maghulu ghiinu. ");
INSERT INTO wbi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kyang'haani nikuvaauula, pa kighono ikya vuhighi, ulupumuko lwave luliiva lukome kukila ulwa vaanhu ava likaaja ilya Sodoma ni lya Gomola! ");
INSERT INTO wbi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Lolagha, nikuvasuung'ha hwene ng'holo pakate pa ng'hekeeva. ");
INSERT INTO wbi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Muvisaghe vasufu ndavule injoka, kange muvisaghe vahuugu ndavule ing'unda. Muvisaghe maaso, ulwakuva avaanhu vilikuvatwala pa vuhighi, na kukuvatova mu masinagogi ghaave. ");
INSERT INTO wbi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kange vilikuvatwala pa vajagila na pa vatwa, ulwakuva mukumbingila une. Ughuo ghuuva ghwe nsiki ughwa kwoleka ulwitiko lwinu ku veene na ku vano na Vayahudi. ");
INSERT INTO wbi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Neke pano vikuvatala pa vuhighi, namungasaghaghe kuuti kyamujova kiki, ulwakuva uNguluve ikuvapeela unsiki ughuo isa kujova. ");
INSERT INTO wbi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Amasio ghano kyamujova naghihuma kunyumue, looli ghihuma kwa Mhepo ghwa Nguluve uNhaata ghwinu, juno kyaijova kukilila umue. ");
INSERT INTO wbi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Umuunhu ikumwohelagha unnine ku valugu kuuti abudue. Uviise iumwohelagha umwanaake, voope avaana vikuvagalukilagha avapaafi kuuti vabudue. ");
INSERT INTO wbi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Avaanhu vooni vilikuvakalalilagha ulwakuva mukumbingilila une. Looli juno ikuguda kuhanga kufika kuvusililo, ujuo ghwe alakuluka. ");
INSERT INTO wbi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Avaanhu vangavapumusie mu likaaja ili, mukimbililaghe mu likaaja ilingi. Kyang'haani nikuvavuula, namungamale kughenda amakaaja ghooni agha Isilaeli une ne Mwana gha Muunhu ye nikyale pikwisa. ");
INSERT INTO wbi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Um'bulanisivua nangankile um'bulanisi ghwake, nambe unkami nanganinkile untwa ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Looli lukwila um'bulanisivua kuuva ndavule um'bulanisi ghwake, ghope unkami kuuva ndavule untwa ghwke. Nave vikuntambula um'baha ghwa nyumba kuuti ghwe Belisebuli, asi, avaanhu ava mu nyumba jaake navangavatambule amatavua amaviivi kukila?” ");
INSERT INTO wbi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Lino, namungavoghopaghe avaanhu avuo, ulwakuva sooni sino sili ku vusyefusilaava pa vuvalafu, kange sooni sino sifisiime silakagulika. ");
INSERT INTO wbi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sino nikavavuula ku ng'hiisi, mujovaghe pa vuvalafu Kange sino nikuvapwepela, mupulisyaghe ku vaanhu vinga. ");
INSERT INTO wbi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Namungavoghopaghe vano vibuda um'bili ghwene, looli mumwoghopashe uNguluve juno itipula lwoni. ltipula nu mwoto ghuno naghusima lusiku. ");
INSERT INTO wbi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Asia, utujuni tuvili natughusivua ku ndalama indebe kyongo? Napano natughusivua ku ndalama nyinga, nakwekale nambe kamo kano kighua paasi kisila vughane vwa Nguluve, uNhaata ghwinu. ");
INSERT INTO wbi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Umue, uNguluve avalile nali linyele ilya ku matu ghiinu. ");
INSERT INTO wbi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lino, namungavopashe, ulwakuva umue lumbulilo lukome pamaaso gha Nguluve kukila utujuni utwinga. ");
INSERT INTO wbi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Umuunhu ghweni juno ikwitika pamaaso gha vaanhu kuuti ikumbilila une, na juune nilikwitika pamaaso gha Nhaata ghwango juno ali kukyanya kuuti ujuo m'bingilili ghwango ");
INSERT INTO wbi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Neke umuunhu juno ikung'haana pamaaso gha vaanhu, na juune nilikunkaana pamaaso gha Nhaata ghwango juno ali kyanya. ");
INSERT INTO wbi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mulekaghe kusaagha kuuti nisile kuleeta ulutengaano mu issi. Jeeje, nanisile kuleeta ulutengaano, looli kupela amabaatu. ");
INSERT INTO wbi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwekuti nisile kusulania uswambe nu viise, umwalive nu ng'ina, umuunhu nu nkwive. ");
INSERT INTO wbi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kange, avalugu va muunhu ve va mu nyumba jaake. ");
INSERT INTO wbi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Umuunhu juno amghanile uviise nambe ung'ina kukila kukungana une, naanoghiile kuuva m'bingilili ghwano. Kange, umuunhu ghweni juno amughanile unswambe, nambe umwalive, kukila kukungana une, ghwope naanoghiile kuuva m'bilingilili ghwango. ");
INSERT INTO wbi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Umuunhu ghweni itavulaghe kukumbilila une na kupumusivua, nambe kuuve kwe kufua. Nave naivomba uluo naanghiille kuuva m'bingilili ghwako. ");
INSERT INTO wbi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Umuunhu juno ilonda uluo kupoka uvwumi vwake, ujuo ikwambusia, neke umuunhu juno ikwambusia uvwumi vwake vwimila une, ujuo iliiva nu vwumi uvwa kuvusika kusila.” juno ");
INSERT INTO wbi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Umuunhu juno ikuvupila umue, ikunyupila une, juno ikunyupila une, ikumwupila juno asung'hile une. ");
INSERT INTO wbi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Umuunhu juno ikumwupila umuunhu ulwakuva m, bili, uNhuluve ilikumpeela uluvonolo luno vipelua avavili. Kange, umuunhu juno ikumwupila umuunhu ulwakuva mugholofu, uNguluve ilikumpeela uluvonolo luno vipelua avagolofu. ");
INSERT INTO wbi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kyang'haanio nikuvavuula kuuti, umuunhu ghweni juno ikumpeela umo mu vano navatambulika nambe utulenga utusuvusu ulwakuva m'bulanisivua ghwango, uNguluve nangaleke kukumpeela uluvonolo. ");
INSERT INTO wbi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","UYesu ye amalile kukuvavuula avavulanisvua vaake kijigho na vavili sino vanoghiile kuvomba, akavuuta pala, akaluta mu makaaja gha kighavo ikya Galilaya kupulisia na kuvulanisia avaanhu ilisio lya uNguluve. ");
INSERT INTO wbi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","UYohani alyadindilue mu ndinde. Ye ali mu ndinde, akapulika imbombo sino uKilisite akava ivomba. Pe akasuung'ha avavulanisivua vaake. ");
INSERT INTO wbi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","vamposie uYesu kuuti, Uve veeve KIlisite juno avavili valyavilile kuuti ilikwisa? Nave naveeve, tuhuvilaghe ujunge? ");
INSERT INTO wbi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","UYesu akavamula akati, “Mulute mum'buule uYohani sooni sino musivwene na kupulika. ");
INSERT INTO wbi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Avabofu vilola, avalema vighenda, avanya buuba vivalal, avanya mapula vipulika, avafue visyuka. Kange, avakotofu vipulisivua iMhola iNofu. ");
INSERT INTO wbi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Avafunyilue umuunhu juno ikunyitika une kisila nganighani” ");
INSERT INTO wbi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Avavulanisivua va Yohani ye vavukile, UYesu akatengula kukulivuula ilipugha lila imhola isa Yohani, akati, 'Mukalutile ku lihaka kulola ikiki? Mwahuvilagha kukumwagha umuunhu juno ikeela kwitika ndavule ilitete lino likeela kudepa nui mhepo? Jeeje! ");
INSERT INTO wbi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pe mukalutile kukola umuunhu juno ali ndaani? Asi, mukalutile kukola umuunhu juno afwalile amenda agha ndalama nyinga? Pulikisia, vaanhu vano vifwala amenda agha ndalama nyinga vikukala mu nyumba isa vatwa ");
INSERT INTO wbi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lino pe mukalutile kulola umuunhu juno ali ndaani? Mukalutile kukumulola um'bili? Se seene! Nikuvavuula kuuti ujuo nam'bili lwene, looli ujuo m'baha kukila um'bili. ");
INSERT INTO wbi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ujuo ghwe juno imhola saake silembilue mu Malembe aMimike kuuti, 'Lolagha, nikusuung'ha unyamhola ghwango akulongolele. Ujuo ghwe ikukuling'hanikisyagha isila jaako.' ");
INSERT INTO wbi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Kyang'haani nikuvavuula kuuti, ku vaanhu vooni naaghelile kuvoneka umuunhu um'baha kukila uYohani uMwofughi. Neke juno n'debe mu vutwa vwa kukyanya, m'baha kukila Yohani. ");
INSERT INTO wbi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuhuma ifighono fino uYohani uMwofughi ipulisia kuhanga kufika umusyughu, uvutwa vwa kukyanya vulondua ku ngufu, ve vano vighela pikwingila mu vutwa uvuo. ");
INSERT INTO wbi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Avavili vooni ni ndaghilo sa Moose filungika sino silivoneka kufika unsiki ughwa Yohani. ");
INSERT INTO wbi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Lino, nave mukwitika uvuvili vwave, uYohani ghwe Eliya jula juno alyajovilue kuuti ikwiisa. ");
INSERT INTO wbi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Unya kupulika, apulikaghe. ");
INSERT INTO wbi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Asi, nihwanikisie ni kiki avaanhu ava kisina iki? Vahwaniniine na vaana vano vineena ku lighulilo, neke vikuvavuula avajanave, viiti, ");
INSERT INTO wbi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tuvakuviile ifilongilongi ifya lukeelo, namusejile! Tuvimbiile ulwimbo ulwa lusukunalo, namulilile! ");
INSERT INTO wbi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Fye lulivuo na jumue! UYOhani alisile, naalisagha nambekunyua, avaanhu vakati, 'Ali ni lpepo.' ");
INSERT INTO wbi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Neke une ne Mwana wa Muunhu nisile, nilia na kunyua, aveene viiti, “Uju nyamwojo, mughaasi! kange mmanyaani ghwa vasongesia songo, na vahosi!' Neke uvukagusi vwa Nguluve, vuvoneka vwa kyang'haani mu mbombo saake.” ");
INSERT INTO wbi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pepano uYesu akatengula pikughadalikila amakaaja muno akavombile ifidegho finga, ulwakuva avaanhu mu makaaja aghuo navalyalatile inyivi saave. Akavavuula, akati, ");
INSERT INTO wbi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","'Iga mwe vaanhu va likaaja lya Kolasini! Iga mwe vaanhu va likaaja ilya Betisaida! Ulwakuva ifidegho fino nivombile kulyumue, fyale fivombeke ku likaaja ilya Tiilo ni lya Sidoni, avaanhu mu makaaja aghuo ngale valyalatile, Vaale vifwala amagunila na kupakala ilipembo kuhufia ululaato lwave. ");
INSERT INTO wbi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lino likuvavuula kuuti, ikighono ikya vuhighi ulupumuko lwinu luliiva lukome, kukila ulwa vaanhu ava ku Tiilo na ku Sidoni. ");
INSERT INTO wbi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na jumue mwe vaanhu mu likaaja lya Kapelenaumu, mukuvona kuuti mulifika kukyanya kwa Nguluve? Jeeje, nafye luliiva! Looli ilikuvataagha paasi kuvuue. Ulwakuva ifidegho fino fivombiike kulyumue fyale fivombeke ku Sodoma, ilikaaaja ilio ngale kwelili nambe umusyughu. ");
INSERT INTO wbi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lino nikuvavula kuuti, ikighono ikya vuhighi ulupumuko lwinu luliiva lukome kukila ulwa likaaja ilya Sodoma.” ");
INSERT INTO wbi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Unsiki ughuo uYesu akajova akati, “Ghwe Nhaata, ghwe juno utemile kukyanya na paasi, nikikuhongesia ulwakuva imhola isi uvafisile avimbi na vakagusi, neke uvahufisie avaanhu vano vikujisia hweene vaana vadebe. ");
INSERT INTO wbi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eena Nhaata, ulwakuva uluo lwe luno ukeliile.” ");
INSERT INTO wbi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“UNhaata ghwango anhavuliile fyoni. Neke na kwale juno ankagwile uMwana, looli ju Nhaata mwene. Kange, nakwale juno ankagwile uNhaata, looli uMwana, nu muunhu ghweni juno uMwana ilonda kukumhu ");
INSERT INTO wbi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mwisaghe kuklyune mweni mwe vano mupumusivua na na kulemua na masigho gha ndaghilo, une ikuvapeela kupuma. ");
INSERT INTO wbi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mukundaghe kulongosivua nuune, ndavule ing'ombe vule silongosivua ni joki. Mumanyilaghe kulyune, ulwakuva une nili nkoola kange nili nu lujisio. Apuo pe muuva nu lutengaano mu moojo ghiinu. ");
INSERT INTO wbi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ilijoki lyango nalilemasia, kange unsigho ghwango mpepe. ");
INSERT INTO wbi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ikighono kimoga ikya Sabati, Uyesu na vavalanisivua vaake vakava vikila mu maghunda gha ngano. Avavulanisivua vaake jikavava injala, pe vakatengula kudeenya amasoojo, gha ngano, visoghojola na kulia. ");
INSERT INTO wbi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","AVafalisayi ye vasivwene isio, vakam'buula uYesu vakati, “Lolagha, avavulanisivua vaako vivomba sino nasinoghiile kuvomba mu kighono ikya Sabati!” ");
INSERT INTO wbi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","UYesu akavamula akati, “Asi, namuvalile mu Malembe aMimike, ndavule alyavombile uDavidi ye jivavile injala umwene palikimo na vanine? ");
INSERT INTO wbi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Akingila mu nyumba ja Nguluve, neke akapelua amakate gha pa kitekelelo, ghano ghaale gha mbombo inyimike, akalia akavapeela na vanine. Amakate aghuo navakitikisivwagha avaanhu avange kulia, ulwene va vatekesi veene. ");
INSERT INTO wbi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kange namwimbile mu ndaghilo sa Moose, kuuti avatekesi mu nyumba inyimike ija Nguluve videenya ululaghilo ulwa kighono ikya Sabati, neke uNGuluve naikuvavalila kuuti vivomba inyivi? ");
INSERT INTO wbi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lino nikuvavuula kuuti, apa pwale um'baha kukila inyumba inyimike ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mwale mukagulaghe umuluvo ghwa Masio aMImike ghano ghiiti, 'Nilondda umuunhu avasaghe nya lusungu kukila kuhumia ilitekelo,' ngale namukuvahigha avaanhu avasila nkole. ");
INSERT INTO wbi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ulwakuva une ne Mwana ghwa Muunhu nili m'baha ku Sabati. ");
INSERT INTO wbi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","UYesu akavuuka pala, akaluta na kukwingila mu sinagogi jino jaale mu kikaaja ikio. ");
INSERT INTO wbi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mu sinagogi mula, mwealyale umuunhu jumonga unya luvoko luno lifwile. AVafalisayi vano valyale mula vakava lilonda ikiteghe ikya kumhighila uYesu, pe vakaposia vakati, “Asi, indighilo isa Moose va vilonda sikwitikisia kukunsosia umuunhu ikighono ikya Sabati?” ");
INSERT INTO wbi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Uyesu akamula akati, “Ghwe veeni mulyumue juno ing'holo jaake jingaghwilile mu liina ikighono ikya Sabati ileka kukujuhumi? ");
INSERT INTO wbi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pulikisia, uvwumi vwa muunhu vukome kukila uvwumi vwa ng'holo. Mu uluo, lunoghiile kuvomba inofu ikighono ikya Sabati.” ");
INSERT INTO wbi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pepano uYesu akam'buula umuunhu jula akati, “Gholosia uluvoko lwako.” Umuunhu jula akagholosia, uluvoko lwake lukasooka, lukava ndavule ulunge. ");
INSERT INTO wbi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Neke aVafalisayi vala vakahuma kunji, vakapuling'hana vule kyavikum'buda uYesu. ");
INSERT INTO wbi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Uyesu akakagula imhola jino aVafalisayi vakava vipuling'hana. Pepano akavuuka pala, vaanhu vinga vakam'bingilila. Apuo akavasosia avatamu vooni. ");
INSERT INTO wbi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","neke akavasimilisia kuuti navangampulisyaghe ku vaanhu. ");
INSERT INTO wbi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","UYesu alyajovile asio aghuo kukwilanisia sino alyajovile um'bili UYesaya kuuti, ");
INSERT INTO wbi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Lolagh, uju ghwe m'bombi ghwango juno ninsalwile, umughanike ghwano juno nkeliile. Nilivii mwa mwene uMhepo ghwango, apulisyaghe mu iisis sooni kuuti nilikuvaghigha avaanhu mu vwakyang'haani. ");
INSERT INTO wbi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nailikaning'hanagha na vaanhu nambe kukwova, nambe kupulikika ilisio lyake mu mapuulo. ");
INSERT INTO wbi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ilitete lino lingondile, naideenya, nambe ulumuli luno lusuuka, naisimia, kuhanga aviike uvuhighi vwango uvwa kyang'haani vuteme. ");
INSERT INTO wbi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kange, vano na Vayahudi vulukumhuviila umwene.' ");
INSERT INTO wbi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","pepeno avaanhu vamonga vakamuletele uYesu umuunhu juo ali ni lipepo. Ilipepo ilio lilyampeleliile kuuva m'bofu na kuuva kinuuni. UYesu akansosia umuunhu jula, akatengula kujova na kulola. ");
INSERT INTO wbi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Avaanhu vooni mu lipugha lila vakava videgha viiti, “Asi, uju ndeepo nu iiva ghwe mwana ghwa Davidi?” ");
INSERT INTO wbi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Neke aVafalisayi ye vapuliike isio vakati, “Umuunhu uju idaga amapepo mu ngufu is Belisebuli, ilivaha lya mapepo. ");
INSERT INTO wbi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","UYesu akakgula sino visagha, akavavuula akati, “Avaanhu va vutwa vumo vangagalung'hane, uvutwa uvuo vunangika. Lyope ilikaajkaaja nambe avaanhu va mu nyumba jimo vangagalung'hane, inyumba ijio jinangike na kupalasana. ");
INSERT INTO wbi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Lino, nave uSetano idaga, uvutwa vwake vuuva vugalung'hiine, kange vuuva vusililie. ");
INSERT INTO wbi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nave une nidaga amapepo mu ngufu sa Belisebuli, avavingilili viinu vilikuvahighakuuti muli vasovi. ");
INSERT INTO wbi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Neke nave une nidaga amapepo mu ngufu sa Mhepo ghw Nguluve vwisile kunyumue. ");
INSERT INTO wbi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Umuunhu ghweni naangingile mu nyumba mu nyumba ja muunhu unya ngufu kuhoma ifiinu fyake, looli taasi ankole unya nyumba ankunge, neke aghome ifiinu fyake fyoni. ");
INSERT INTO wbi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Umuunhu juno naali lubela lwango, ujuo mulugu gwango. Kange juno naikong'hania avaanhu avaanhu palikimo nuune. ujuo ipalasnia. ");
INSERT INTO wbi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mu uluo nikuvavuula kuuti, uNGuluvi ndepoonu ipyanila umuunhu inyivi saake sooni na maligho ghaake ghooni, neke umuughu juno ikumuligha uMhepo uMwimike, ujuo naalapyanilua. ");
INSERT INTO wbi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kange umuunhu juno ikunjova fivi une ne Mwana ghwa Muunhu, ipyanilua. Neke, juno ikun'jova fivi uMuhepo uMwimike, ujuo naalapyanilua mu iisi muno nambe ku vwumi uvwakuvusila kusila.” ");
INSERT INTO wbi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Avaanhu vikughutang'hania umpiki vwimila ifipeke fyake. Ulwakuva umpiki unnofu ghukoma ifipeke ifinofu, umpike um, biivi ghukoma ifipeke ifiviivi. ");
INSERT INTO wbi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwe kisina kya njoka umue! Ndepoonu luuva ndaani umue kujova amasio amanofu pano muli vahosi? Ulwakuva sino umuunhu ijova, se sino simemile mu mwojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Umuunhu unnofu ihumia inofu kuhuma mu mwojo ghwake ughwa vulosi. ");
INSERT INTO wbi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","LIno nikuvavuula kuuti, IKIghono ikya vuhighi, nujunge ilikwoleka mwene vwumila amasio ghooni ghano naghanoghiile, ghano ajovagha. ");
INSERT INTO wbi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ulwakuva amasio ghaako amanofu ghilikukupelela uvalililue kuuva mugholofu, kange amasio ghaako amaviivi ghilikukupelela kuhighua. ");
INSERT INTO wbi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pepano vamonga mu Vafalisayi na mu vavulanisi va ndaghilo isa Moose vakam'buula uYesu vakati, “Ghwe m'bulanisi, tulonda utuhufie ikivalilo kino kivonia kuuti asung'hilue nu Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","UYesu akavamula akati, “Avaanhu va kisina iki ikihosi, vano navikum'bikila mwojo uNGuluve vilonda ikivalilo! Looli navalapelua ikivalilo, ulwene ikivalilo kino uNguluve alyahufisie vwimila um'bili uYoona. ");
INSERT INTO wbi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ulwakuva ndavule uYoona vule alikalile ifighono fitatu mu lileme lya samaki imbaha, pakilo na pamwisi; fye lulivuo na juune ne Mwana ghwa Muunhu, nikukala ifighono fitatu mu mbiipa, pakilo nna pamwisi. ");
INSERT INTO wbi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ikighono ikya vuhighi, avaanhu ava Ninaawi, vilikwima kukuvaghigha umue mwe vaanhu va kisina iki kuuti muli vahosi. Ulwakuva uYoona ye apulisie ilisio ilya Nguluve ku veene, valyalatile inyivi saave. Lino, apa pwale um'baha kukila uYoona. ");
INSERT INTO wbi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kange ikighono ikya vuhighi, umalikia ughwa ku Seba ilikwima kukuvahigha umue, mwe vaanhu va kisina iki kuuti muli vahosi. Ulwakuva umwene alyakyulile kuhuma ku iisi ija ku vutali, akiisa kupulika amasio gha luhaha lwa Solomoni. Lino, apa pwale um'baha kukila uSolomoni.” ");
INSERT INTO wbi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","UYesu akafijivagha, “Ilipepo ililamafu pano lihuma mwa muunhu, liluta ku lukuve lilonda apa kupuuma. Nave nalikupaagha, ");
INSERT INTO wbi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","apuo pe liiti, 'Nigomoka kula kula ku nyumba jongo.' Neke lingafike, livone inyumba jila jili vuvule, jipyaghilue, na kuling'hanisivua vunofu. ");
INSERT INTO wbi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pe liluta kukoova amapepo aghange lekelalubale, amahosi kukila ilyene. Pe ilyene na ghangeaghuo ghikwingila mwa muunhu ujuo, ghikukala. Apuo umuunhu ujuo iiva nu lupumuko ulukome kukila ulutasi. Enendiiki fye luliva ku vaanhu ava kisina iki ikihosi. ");
INSERT INTO wbi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","UYesu ye ajiighe ijova ni lipugha lya vaanhu, ng'ina na vanine va Yesu vakiisa, vakiima panji, vilonda kujova naghwo. ");
INSERT INTO wbi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pe umuunhu jumonga akam'buula akati, “Umama ghwako na vanunaavo vali panji, vilonda pijova nuuve.' ");
INSERT INTO wbi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Neke uYesu akamwamula akati, “Umama ghwako ghwe veeni? Avanunavango ve vaveeni? ");
INSERT INTO wbi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pe akagholosia uluvoko ku vavulanisivua vaake akati, “Lolagha, avaanhu vooni ava ghwe mama ghwngo, na vanunavango. ");
INSERT INTO wbi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ulwakuva umuunhu ghweni juno ivomba isa vughane vwa Nhaata ghwango. ughwa kukyanya, ujuo ghwe nnunavango, ghwe lumbulyango, ghwe mama ghwango.” ");
INSERT INTO wbi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ikighono kila kila, uYesu akahuma mu nyumba jila, akaluta, akikala mulubale mu lisumbe. ");
INSERT INTO wbi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Avaanhu vinga amapugha na mapugha vakaluta, vakakong'haana pa mwene, kuhanga akalamula pikwingila mu ngalava ikikala. Avaanhu vala vakiima kunji ku lisumbe. ");
INSERT INTO wbi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pepano akavavuula si nyinga mu fihwanikisio akati, 'Unkesambeju jumonga alyalutile kukesa imbeju. ");
INSERT INTO wbi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ye ikesa, Imbeju jimonga jikaghua pa sila, injuni sikiisa, sikahola. ");
INSERT INTO wbi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ijingi jikaghua pa linhalavue, jikamela ng'haning'haani. ulwakuva ilihanga lyale lidebe. ");
INSERT INTO wbi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ye jimelile ulujuva lukanyaanya, jikuuma, ulwakuva indela sikakunua kukwika paasi. ");
INSERT INTO wbi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ijingi jikaghua pa malela gha madasia, jikamela, neke amadasia ye ghakafweta. ");
INSERT INTO wbi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ijingi jikaghua pa lihanga ilinofu, jikamele, jukakula na kukoma vunono, jimo ifipeke kilundo, ijingi fijigho ntanda, ijingi fijigho filatu. ");
INSERT INTO wbi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Unya kupulika, apulikaghe!” ");
INSERT INTO wbi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pepano avavulanusivua vaake vakaluata vakamposia vakati, 'Kiki ghujova na vaanhu mu fihwanikisio? ");
INSERT INTO wbi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","UYesu akavamula akati, 'Umue uNguluve avapeliile kukagula isa vusyefu uvwa vutwa vwa kukyanya, looli aveene navapelilue uluo. ");
INSERT INTO wbi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ulwakuva umuunhu ghweni juno ali nu vakagusi vwimila uvutwa vwa Nguluve, ujuo ikwongelesivua. Looli juno nsila vakagusi uvuo, nambe uvukagusi uvudebe vuno ali navwo, ikunyua. ");
INSERT INTO wbi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Uluo lwe luno lukumhelela kujova navo mu fihwanikisio, ulwakuva vilola neke navikusivona, vipulikisia neke navipulika nambe kukusitang'hania. ");
INSERT INTO wbi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isi sivombeka ku veene kukwilanisia sino um'bili uYesaya alyalembile kuuti,'Kupulika, mupulikagha neke namukusitang'haniagha. Kulola, mulolagha neke namukusivonagha. ");
INSERT INTO wbi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ulwakuva avaanhu ava, vasiiti kukwitika. Vadindile imbulughutu saave, vadindile amasio ghaave. Vaale valeke uluo, amasio ghaave ghaale ghilolagha, imbulughutu saave saale sipulikaghe, nagha moojo ghaave ghaale ghikulutang'haniagha. Mu uluo vaale vikusyetukila une, na juune naale nikuvapoka.' ");
INSERT INTO wbi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Looli mufunyilue umue, ulwakuva amaso ghiinu ghilola nasi mbulughutu siinu sipulika. ");
INSERT INTO wbi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kyang'haani nikuvavuula kuuti kwevalyale avavili na vagholofu vinga vano valyale vilonda kukusivona sino mukusivona umue, neke navalyasivwene. Kange valyale vilonda kupulika sino mupulika umue, neke navalyasipuliika.” ");
INSERT INTO wbi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Lino, mupulikisie umuluvo ghwa kihwanikisio ikya nkesambeju, ");
INSERT INTO wbi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pa sila pano imbeju jilyaghwile, ghwe muunhu juno ipuluka ilisio lya vutwa vwa Nguluve neke naikulitang'hania, uMhosi uSetano ikwisa na kutoola kino kivyalilue ghwe munkate mu mwojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pa linhalavue, pano imbeju jilyaghwile ghwe muunhu juno ipuluka ilisio lya Nguluve, insiki ughuo ikulyupila nu lukeelo. ");
INSERT INTO wbi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Neke ulwakuva ilisio lila lisila ndela mu mwojo ghwake, igadilila unsiki n'debe, lungavoneke ulutalamu lumonga, nambe isa kumpumusia vwimila ilisio lya Nguluve, neke nakikomaifipeke. unsiki ghughuo ye ikululekagha ulwitiko. ");
INSERT INTO wbi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pa madasia pano imbeju jilyaghwile ghwe muunhu juno ipulika ilisio lya Nguluve, neke imbombo sa mu iisi, kuyasuka vwimila uvukavi vwa kyuma fifweta ilisio, neke nalikoma ifipeke, ");
INSERT INTO wbi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Looli pa lihanga ilinofu pano imbeju jilyaghwile, ghwe muunhu juno ipulika ilisio lya Nguluve na kukulitang'hania. Ujuo ghwe juno ikoma ifipeke kilundo, ujunge fijigho ntanda, ujunge fijigho filatu” ");
INSERT INTO wbi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","UYesu akavavuula ikihwanikisio ikingi akati, “uvutwa vwa kukyanya vuhwaniine nu muunhu juno alyavyalile ingano mu mughunda ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Neke pakila avaanhu vooni ye vighoni, umulugu ghwake akiisa akavyala ilisoli mu ngano, akavuuka iluta. ");
INSERT INTO wbi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pambele fyoni fikamela. Ingano yajipongola, ilisoli likatengula pikuvonesia. ");
INSERT INTO wbi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Avavombi va muunhu jula unya mughunda vakaluta kukumposia vakati, 'Ghwe ntwa, tukaghwile kuuti ukanyalile ingano mu mughunda ghwako, lino ilisio lila lihumile kuughi?' ");
INSERT INTO wbi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Umwene akavamula akati, “Umulugu ghwe juno avombile uluo. Avavombi vaake vakamposia vakati, 'Ghulonda tulute tukakulule ilisio ilio/ ");
INSERT INTO wbi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Umwene akati, 'ndali namungakululaghe, ulwakuva pano mukulula ilisoli ndepoonu mukulula naji ngano. ");
INSERT INTO wbi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muleke fyoni fikulaghe palikimo kuhanga unsiki ghwa kubena. Unsiki ughuo, nilikuvavuula vano vibena kuuti vakong'haniaghe taasi ilisoli na kupinya ifinyagha kuuti finyanyue. Neke ingano vakong'hanie na kuvuta mu kihenge kyango. ");
INSERT INTO wbi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","UYesu akavavuuka kihwanikisio ikingi akati, 'Uvutwa uvwa kukyanya vuhwanine n mbeju indebe fiijo, jino umuunhu jumonga alyatolile na kuvyala mu mughunda ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Napano imbeju ijio ndebe kukila sooni, jingamele, ghuuva mmela nkome kukila amamela ghooni agha nyafu. Ghukula ghuuva mpiki, nasi njuni sitenga ifivwasu mu nhaafi saake.” ");
INSERT INTO wbi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","UYesu akavavuula ikihwanikisio ikingi akati, 'Uvutwa uvwa kukyanya vuhwaniine ni kilule kino umukijuuva jumonga alyatolile, akakandila ilikandua ilya mateneka ghatatu agha vutine. Ye akandile, ikilule kia kikalusia ilikandua lyoni.' ");
INSERT INTO wbi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","UYesu alyavavulile avaanhu isio sooni mu fihwanikisio. Naakajovagha kimonga ku veene kisila kihwanikisio. ");
INSERT INTO wbi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Akavombagha uluo kukwilanisia ilisio lino alyajovile um'bili kuuti, “Nijovagha na vaanhu mu fihwanikisio. nikuvavulagha sino sifisiime kuhuma Nguluve ipela iisi.” ");
INSERT INTO wbi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","pambele uYesu akahwesia ilipugha lila, akingila mu nyumba. Avavulanisivua vaake vakaluta pa mwene, vakajova vakati, 'Utuvuule umuluvo ghwa kihwanikisio kila ikya lisoli mu mughunda ghwa ngano.' ");
INSERT INTO wbi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","UYesu akavamula akati, “Unyakukesa ingano ghwe Mwana ghwa Muunhu. ");
INSERT INTO wbi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Umughunda je iisi, ingano ve vaanhu vano vali mu vutwavwa Nguluve, neke ilisoli ve vaanhu ava Mhosi jula. ");
INSERT INTO wbi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Umulugu juno akavyalile ilisoli, ghwe setano. Unsiki ughwa kubena kye kighono kya vusililo vwa iisi, vano vibena ve vanyamhola. ");
INSERT INTO wbi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Lino, ndavule ilisoli vule likong'hanisivua na kunyanyua pa mwoto, fye luliiva ikighono ikya vusililo vwa iisi. ");
INSERT INTO wbi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Une ne Mwana ghwa Muunhu nilisuung'ha avanyamhola vango. vavakong'hanie avaanhu vooni mu vutwa vwango vano vipelela avange kuvomba uvuhosi na vano vivomba uvuhosi. ");
INSERT INTO wbi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Avanyamhola vilililagha avaanhu avuo mu mwoto ghuno naghusima lusiku. Ukuo kwe vilililagha na kugwegwenula aminio ulwakuva vali mu vuvafi uvukome. ");
INSERT INTO wbi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pe avagholofu vilivalatikagha mu vutwa vwa Nhaata ghwave ndavule ilijuva. Unya kupulika, apulikaghe. ");
INSERT INTO wbi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Uvutwa uvwa kukyanya vuli ndavule ikiinu ikya ndalama nyinga kino kilyafisilue mu mughunda. Neke umuunhu jumonga akakyagha, akafisa vunono. pepano akaluta nu lukeelo kughusia ifiinu fyoni fino alyale nafyo, akaghula umughunda ghula. ");
INSERT INTO wbi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kange, uvutwa uvwa kukyanya vuli ndavule umughusia fiinu jumonga juno akalondagha ilulu jino jaale ja ndalama nyingi. ");
INSERT INTO wbi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ye ajaghile ilulu ijio, akaluta kughusia ifiinu fyoni fino alyale nafyo fino alyale nafyo, akaghula. ");
INSERT INTO wbi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kange, uvutwa uvwa kukyanya vuli ndavule ulwafu luno avalovi va samaki vakisise mu nyanja. Mu lwafu uvuo sikaghilila isamaki sino sili papinga. ");
INSERT INTO wbi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Neke ulwafu ye lumemile, avalovi vakakwesela kunji ku nyanja. Pe vakikala paasi, vakakong'hania, isamaki inofu sino vavilia, vakaviika mu fisenje, neke isamaki sino navavilia, vakataagha. ");
INSERT INTO wbi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Fye luliiva ikighono ikya vusililo vwa iisi. Avanyamhola va Nguluve vilikwisa, vilikuvabaghula, avahosi viliiva paajo na vagholofu. ");
INSERT INTO wbi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Avanyamhola avuo vilikuvataagha avahosi ku mwoto ghuno naghusima lusiku. Ukuo kwe vilililagha na kugwegwenula amiino ulwakuva vali mu vuvafi uvukome.” ");
INSERT INTO wbi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","pepano uyesu akavaposia avavulanisivua vaake akati, 'Asi, musitang'hinie sooni isio sino nivavulile? Aveeni vakamule vakati, “Enena, tusitang'hini.” ");
INSERT INTO wbi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pe akavavuula akati, “Lino, um'bulanisi ghwa ndaghilo sa moose juno m'bulanisivua mu vutwavwa kunkyanya, ali ndavule unya nyumba juno ivutula mu kihenge kyake ifiinu ifipia ni fikuulu.” ");
INSERT INTO wbi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Uyesu ye amalile kujova ifihwanikisio ifio, akavuuka pala, ");
INSERT INTO wbi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akaluta ku kikaaja kyake. Ukuo akatengula kuvulanisia avaanhu mu sinagogi jaave. Avaanhu vala vakadekha, vakaposania viiti, “Umuunhu uju avwaghile kuughi uvukagusi uvu ni ngufu isa kuvomba ifidegho ifi? ");
INSERT INTO wbi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Asi, uju naghwe mwana ghwa mpululambavo? Ung'ina naghwe juno itambulua Maliya? Nava vanuuna vaake naghwe Yakovo, u Yosefu, u Simoni nu Yuuda? ");
INSERT INTO wbi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Asi, avalumbu nave vano tukukalania pa kikaaja apa? Lino, umwene asaghile kuughi sooni isi?” ");
INSERT INTO wbi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mu uluo vakakaana kukumwitika. Pe uYesu akavavuula akati, “Um'bili mwoghopua imbale sooni, ulwene naikwoghopua na vaanhu ava mu kikaaja kyake na mu nyumba jaake.” ");
INSERT INTO wbi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ulwakuva avaanhu vala navalya mwitiike, uYesu naakavomba ifidegho finga kula. ");
INSERT INTO wbi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Unsiki ghula untwa UHelode alyapuliike imhola sa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pe akavavuula avavombi vaake akati, “Ujuo ghwe Yohani uMwofughi, asyukile kuhuma ku vafue, fye nambe ali ni ngufu isa kuvomba ifidegho.” ");
INSERT INTO wbi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","UHelode alyajovile enendiiki ulwakuva alyankolile uYohani, akankunga na kukun'dindila mu ndinde. UYohani alyadindilue mu vwimila uHelodia un'dala ghwa Filipo, unnuuna ghwa Helode. ");
INSERT INTO wbi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Alyadindilue mu ndinde ulwakuva alyam'bulile luno nalunoghiile mu ndaghilo sa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","UHelode ujuo akalondagha kukum'buda uYohani neke akoghopagha avaanhu ulwakuva valyankagwile uYohani kuuti m'bili. ");
INSERT INTO wbi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lino, pa kikulukulu ikya kukumbuka kuholua untwa uHelode, umwalive ghwa Helodia akaseeja pamaso gha vahesia. Umhinja ujuo akamhovosia fiijo UHelode, ");
INSERT INTO wbi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kuhanga akajiigha kukumpela kino ilonda kusuuma. ");
INSERT INTO wbi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Neke umhinja jula akahongua nu ng'ina ikya kusuuma, akam'buula uHelode akati, “Nilonda umheele lino lino umutu ghwa Yohani uMwafughi mu lisinia.” ");
INSERT INTO wbi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Untwa uHelode akasukunala kyongo. Neke ulwakuva akajighile pamaaso gha vahesia vala, akalaghila kuuti umhinja jula apelue. ");
INSERT INTO wbi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pe akasuung'ha umuunhu alute mu ndinde adumule umutu ghwa Yohani. ");
INSERT INTO wbi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Umutu ghwa Yohani ghukaletua mu lisinia, akapelua umhunja jula, ghwope akampeela ung'ina. ");
INSERT INTO wbi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pepano avavulanisivua va Yohani vakaluta, vakatoola um'bili ghwa Yohani, vakaghuviika mu mbiipa. Pe vakaluta kukum'buula uYesu imhola jila. ");
INSERT INTO wbi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","UYesu ye apuliike imhola ijio, akavuuka pala ni ngalava na kuluta pamonga pa vusyefu. Neke avaanhu ye vapuliike kuuti uYesu avukile pala, vakahuma mu makaaja ghaave, vakaghenda lughulu, vikum'bingilila uYesu kuno alutile. ");
INSERT INTO wbi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","UYesu ye ikwika mu ngalava, akalivona ilipugha ilivaha ilya vaanhu, akavavonela ikisa, akavasosia avatamu vaave. ");
INSERT INTO wbi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ye vwilile, avavulanisivua vaake vakaluta pa mwene vakam'buula vakati, “apa tukalile pe lunyika pasila kimonga, kange vwimile uvatavule avaanhu ava valutaghe mu fikaaja kuuti vakaghule ifyakulia.” ");
INSERT INTO wbi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","UYesu akavamula akati, “Nakwekuti umpaka aveene avavuuke, muvapeele umue ikyakulia.” ");
INSERT INTO wbi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aveene vakamula vakati, “Natuli ni kimonga apa, looli ghali gha makate ghahaano ni samaki ivili.” ");
INSERT INTO wbi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","UYesu akavavuula akati, “Muleete apa” ");
INSERT INTO wbi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pepano akavavuula avaanhu kuuti vikale pa lisoli. Pe akatoola amakate ghala ghahaano ni samaki sila ivili, akalolla kukyanya, akamhongesia uNguluve. Pe akamenyulania amakate ghala, akavapeela avavulanisivua vaake, voope vakavaghavilaavaanhu. ");
INSERT INTO wbi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Avaanhu vakalia, vakikuta. Avavulanisivua vaake vakakong'hania ifisighasi, sikamema indiilo kijigho ni vili. ");
INSERT INTO wbi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Avaanhu vano valyaliile, avakinhaata veene valyale imbilima ihaano, kisila kuvala avakijuuva na vaana. ");
INSERT INTO wbi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Unsiki ghughuo, UYesu akavavuula avavulanisivua vaake kuuti vingile mu ngalava, valongole kuluta imwambo ijingi, pano umwene itavula ilipugha lya vaanhu kuuti valutaghe. ");
INSERT INTO wbi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ye avatavwile, akaluta mwene ku kilunda kukufunya. Ing'hiisi jikatengula, ajiighe mwene ku kidunda. ");
INSERT INTO wbi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Unsiki ughuo ingalava jila jikava jifikile pakate pa lisumbe, jitovua na mavingo, ulwakuva imhepo imbaha jikasighagha kuno viluta. ");
INSERT INTO wbi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ye kutapihenga, uYesu akaluta ku vavulanisivua vaake, ighenda pakyanya pa malenga. ");
INSERT INTO wbi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Neke avavulanisivua vaake ye vikumwagha ighenda pakyanya pa malenga, vakoghopa kyongo, vakakoola vakati, “Ilisyuka”. ");
INSERT INTO wbi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Unsiki ghughuo uYesu akavavuula akati, “Kangala, neene, namungoghopaghe” ");
INSERT INTO wbi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pe uPeteli akam'buula akati, “Ghwe Mutwa, nave lweli veeve, umbuule niise palyuve nighende pakyanya pa malenga.” ");
INSERT INTO wbi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","UYesu akamwamula akati, “Isa” pe uPeteli akiikka mu ngalava jila, akatengula pighenda pakyanya pa malenga, iluta kwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Neke ye ivona imhepo imbaha jigugula, akaghopa kyongo, akatengulakundwiila. Pe akakoola akati, “Ghwe Mutwa, umhooke!' ");
INSERT INTO wbi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nakalingi, UYesu akagholosia uluvoko lwake, akankola, akam'buula akati, “Ghwe nya lwitiko ludebe uve, kiki uli ni nganighani? ");
INSERT INTO wbi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pepano uYesu nu uPeteli vakingila mu ngalava, imhepo jila jikalitima. ");
INSERT INTO wbi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","avavulanisivua vano valyale mu ngalava, vakamwimika uYesu vakati, “kyang'haani, uve uli Mwana ghwa Nguluve!' ");
INSERT INTO wbi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","UYesu na vavulanisivua vaake vakalovoka ilisumbe ilya Galilaya, vakafika mu iisi ija Genesaleti. ");
INSERT INTO wbi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Avaanhu ava pala ye vakagwila kuuti ghwe Yesu, vakatwala imhola imbale sooni. Pepano avaanhu vakavatwala avatamu vooni kwa Yesu, ");
INSERT INTO wbi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Vakansuuma avitikisie avatamu vabasie lu luvilo lwa mwenda ghwake. Avatamu vooni vano vakabasyagha, vakasokagha. ");
INSERT INTO wbi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Avafalisayi vamonga na vavulanisi va ndaghilo kuhuma ku Yelusalemu, vakaluta kw Yesu, vakamposia vakati, ");
INSERT INTO wbi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kiki avavulaunisivua vaako navivingilila inyiiho isaa vakuuli viiti? Ulwakuva vilia ikyakulia kisila kwogha amavoko ndavule lunoghiile!” ");
INSERT INTO wbi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Uyesu akavamula akati, “Kiki na jumue mudenya indaghilo sa nguluve Vwimila kuvingilila inyiiho siinu? ");
INSERT INTO wbi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","UNguluve alyatiile, 'Umwoghopaghe uvaaso nu mamaajo' Kange, alyatile, 'Umuunhu juno ikumuligha uviise nambe ung'ina, anoghiile kubudua' ");
INSERT INTO wbi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Neke umue muvulanisia kuuti, umuunhu ndepoonu ikum'buula uviise nambe ung'ina kuuti, 'Kino niveele ninoghiile kukukutanga, nihumisie, litekelo kwa Nguluve' ");
INSERT INTO wbi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mu uluo, muuva mwiti, umuunhu nangamwoghopaghe uviise nambe ung'ina. Ukuo kwe kubenapula ilisio lya Nguluve vwimila kuvingilila inyiiho siinu. Mwe vakedusi umue! UYesaya alyavilile se seene vwimila umue kuuti, ");
INSERT INTO wbi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwe vakedusi umue! UYesaya alyavilile se seene vwimila umue kuuti, ");
INSERT INTO wbi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Avaanhu ava vikunginia pa pa mulomo neke amoojo ghaave ghali kutali nuune. ");
INSERT INTO wbi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Vikunyimika neke ulwimiko lwave lusila luvumbulilo, ulwakuva vivulanisia indaghilo sa vaanhu. ");
INSERT INTO wbi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pepano uYesu akalikemeela ilipugha lya vaanhu, akavavuula akati, 'Mupulikisie vunofu, mulutang'hanie! ");
INSERT INTO wbi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ifiinu fino umuunhu itwala mu mulomo, nafye fino fikum'biika kuuva mulamafu. Looli, fino fihumu mu mulomo, fye fino fikum'biika umuunhu kuuva mulamafu. ");
INSERT INTO wbi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pambele avavulanisivua vaake vakatula pa mwene vakam'buula vakati, 'Ukagwile kuuti aVafalisayi ye vapuliike amasio ghano ujovile, vakaliile kyongo?” ");
INSERT INTO wbi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","UYesu akamula akati, 'Amamela ghooni ghano uNhaata ughwa kukyanya naalyavyalile umwene, ikulula. ");
INSERT INTO wbi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Muvaleke, avuo valongosi vibofu. Nave um'bofu un'jaake, vooni ve vaviili vighwilila mu liina! ");
INSERT INTO wbi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pe uPeteli akam'buula akati, “Utghanulile ikihwanikisio ikio” ");
INSERT INTO wbi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","UYesu akavamula akati, “Asi na jumue namukulutang'hania? ");
INSERT INTO wbi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Namukagula kuuti kino umuunhu itwala mulomo, kiluta mu lileme na kuhuma kunji? ");
INSERT INTO wbi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","looli fino fihuma pa mulomo, fihuma mu mwojo, ifio fye fino fikum'biika umuunhu kuuva malamafu. ");
INSERT INTO wbi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nijova enendiiki ulwakuva mu mwojo mwe muno ghihuma amasaagh amaviivi, uvubudi, uvuvwafu, uvughendamwalu, uvuhiiji, uvwolesi vwa vudesi na maligho. ");
INSERT INTO wbi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Isio, se sino sikum'biika umuunhu kuuva mulamafu. ");
INSERT INTO wbi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pambele uYesu akavuuka pala, akaluta imbale isa likaaja ilya Tiilo ni lya Sidoni. ");
INSERT INTO wbi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ukuo umukijuuva jumonga uMkananayo juno alyale ikukala imbale isio, akiisa kwa Yesu, akakemeela fiijo akayt, Ghwe Mutwa, Mwana ghwa Davidi, usungukile! Umwalivango ipumuka kyongo ni lipepo.' ");
INSERT INTO wbi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Neke UYesu naakamula kimonga. Avavulanisivua vaake vakaluta pa mwene vakam'buula vakati, “Um'buule alutaghe, ulwakuva ikutusingula.” ");
INSERT INTO wbi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","UYesu akamwamula umukijuuva jula akati, UNguluve asung'hile une kukuvapoka aVaisilaeli vano vali ndavule ing'holo sino sisovile.” ");
INSERT INTO wbi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Neke umukujuuva jula akaveela pa Yesu, akafughama, akansuuma akati “Ghwe Mutwa, nisuuma unhange! ");
INSERT INTO wbi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","UYesu akamwamula akati, “Nalunono kutoola ikyakulia ikya vaana na kukusitosekesia imbua.” ");
INSERT INTO wbi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Umukijuuva jula akati, “se seene Mutwa, neke nasi mbua sasilia ifimenyukila fino fisanguka paasi pa meesa s vatwa vaake.' ");
INSERT INTO wbi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","UYesu akamwamula akati, Ghwe mukijuuva uve, ulwitiko lwako luvaha! Luvombeke kulyuve ndavule ghulonda.” Unsuiki ghughuo, umhinja jula akasooka. ");
INSERT INTO wbi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Uyesu akavuuka pala, akaluta akakila mulubale mu lisumbe ilya Galilaya. Pe akatogha pa kidunda, akikala. ");
INSERT INTO wbi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Amapugha gha vaanhu vakaluta pamwene, vitwala avalema, avabofu amaaso, avakinuunu na vatamu avange vinga, vakavaviika avatamuvala pa maghulu ghaake, umwene akavasosia. ");
INSERT INTO wbi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Avaanhu mu lipugha lila vakadegha kyongo kuvona avakinuunu vijova, avalema amaghulu vighenda, avabofu amaaso vilola na valema avange visooka. Pe vakamughinia uNguluve ugha Vaisilaeli. ");
INSERT INTO wbi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","pepano uYesu akavakeela akavavulanivua vaake, akavavuula akati, 'Nikuvavonela ikisa avaanhu ava, ulwakuva vikalile nuune ifighono fitatu, lono vasila kyakulia. Nanilonda pikuvatavula valutaghe ni njala, ulwakuva kyavitenga mu sila.” ");
INSERT INTO wbi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Avavulanisivua vaake vakam'buula vakati, “Kuno tuli kwe lunyika, kusila kimonga, ndepoonu tukughaahja kuughi amakate agha kukwila avaanhu vooni ava? ");
INSERT INTO wbi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","UYesu akavaposia akati, “Muli na makate ghalingi? Vakamwamula vakati, 'Ghali lekelelubale nu tusaamaki tudebe.” ");
INSERT INTO wbi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","UYesu akavavuula avaanhu kuuti vikale paasi. ");
INSERT INTO wbi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pe akatoola amakate ghala lekelalubale nu tusamaki tula, akamhongesia uNguluve, akamenyulania, akavapeela avavulanisivua vaake, neke voope vakavaghavila avaanhu vala. ");
INSERT INTO wbi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Avaanhu vooni vakalia, vakikuta. Avavulanisivua vakakong'hania ifisighasi, fikameme indiilo lekelabale. ");
INSERT INTO wbi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Avaanhu vano valyaliile, valyale avakinhaata veene imbilima ine, kisila kuvala avakijuuva na vaana. ");
INSERT INTO wbi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pepano uYesu akavatavula avaanhu vala kuuti valutaghe, umwene akapanda ingalava, akaluta imbale isa likaaja ilya Magadani. ");
INSERT INTO wbi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","AVafalisayi na Vasadukayi vamonga vakaluka kukumughela uYesu, vakasuuma kuuti ahufie ikivalilo kino kivonia kuuti asung'hilue nu Nguluve ");
INSERT INTO wbi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","UYesu akavamula akati, “Pano jifikile ivwilile mwiti, “Pakilaavo kukia vunofu, ulwakuva kukyanya kuvalafu. ");
INSERT INTO wbi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Palwakilo mwiti, 'uMusyughu ifula imbaha jitoonya, ilwakuva kulimafunde kange kughuvile.' Mwe vakedusi umue, mukagwile kuluvulania ifivalilo ifya kukyanya ku palanga, lwandaani mukunua kukufitang'hania ifivalilo fino fivombeka lino kuuti fili nu muluvo muki! ");
INSERT INTO wbi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Avaanhu va kisina iki ikihosi, vano navikum'bikila mwojo uNguluve, vilonda ikivalilo. Looli navalapelue ikivalilo, ulwene ikivalilo kino uNguluve alyahufisie vwimila uYoona.” Pepano uYesu akavaleka, akavuuka, iluta. ");
INSERT INTO wbi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Avavulanisivua va Yesu ye vilovoka inyanja, vakasyemua kutoola amakate. ");
INSERT INTO wbi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","UYesu akavavuula akati, “Muvisaghe maaso ni kilule ikya Vafalisayi na Vasadukayi.” ");
INSERT INTO wbi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Avavulanisivua vala vakatengula piposania veene viiti, “Ijova enendiiki ulwakuva natugadile amakate! ");
INSERT INTO wbi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","UYesu akasikagula sino vaka vijova, akavavuula akati, Mwe vanya lwitiko ludebe umue! kiki mukaning'haniajumue mwitu muli vasila makate? ");
INSERT INTO wbi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mujiighe namukulutang'hania, nambe kukumbuka amakate ghala ghahaano ghano vakaliile avaanhu vala imbilima ihaano. asi, ifisighasi mukamemisie indiilo ilingi? ");
INSERT INTO wbi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nambe amakate ghala lekelalubale ku vaanhu vala imbilima ine, asi, mukakong'hanisie ifisighasi indiilo ilingi? ");
INSERT INTO wbi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Lwandaani namukulutang'hania kuuti imhola sino nijova numue nasa makate? Une nijova kuuti, muvisaghe maaso ni kilule ikya Vafalisayi na Vasadukayi.” ");
INSERT INTO wbi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Apuo avavulanisivua vaake vakalutang'hania kuuti naaveele ijova imbulanisio imbiivi isa Vafalisayi na Vasadukayi. ");
INSERT INTO wbi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pepano uYesu akaluta imbale isa ku Kaisalia-Filipi. Ye afikile akavaposia avavulanisivua vaake akati, Avaanhu viiti une ne Mwana ghwa Muunhu, neene veen? ");
INSERT INTO wbi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vakamwamula vakati, “Vamo viiti veeve Yohani Mwafughi, vamonga viiti veeve Eliya, avange viiti veeve Yelemia, nambe kuuti uve uli umo mu vavili.' ");
INSERT INTO wbi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","UYesu akavaposia kange akati, “Neke umue mwiti neene veeni? ");
INSERT INTO wbi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","uSimoni Peteli akamwamulila akati, “uve veeve Kilisite, Mwana ghwa Nguluve juno mwimi.” ");
INSERT INTO wbi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","UYesu akam'buula akati, “Simoni mwana ghwa Yoona ufunyilue, ulwakuva nakwale umuunhu juno akuhufisie isio, looli uNhaata ghwango juno alikukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Lino nikuvuula kuuti, veeve Peteli, kwekuti linhalavue. Pakyanya pa linhaalavue ili nijenga inyumba jango jino kye kipugha kya vikiti, ingufu isa kuvufie nasingajilema lusiku. ");
INSERT INTO wbi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nikukupeela ifuunguluo isa vutwa vwa kukyanya, sooni sino ukanile nu iisi iji, ghwope UNguluve iiva akanile kukyanya. Kange, sooni sino ghwitikisie mu iisi iji, naju Nguluve iiva itikisie kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pe UYesu akavakaana avavulanisivua vaake vala kuuti, navangam'bulaghe muunhu kuuti umwene ghwe Kilisite. ");
INSERT INTO wbi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kutengula unsiki ughuo, uYesu akava ikuvavuula pa vuvalafu avavulanisivua vaake kuuti, lunoghiile umwene kuluta ku Yelusalemu na kuuva ni mhumuko nyinga kuhuma ku vagojo, ku vavaha va vatekesi na ku vavulanis va ndaghilo isa Moosi, na kubudua. Neke ikighono ikya vutatu isyuka. ");
INSERT INTO wbi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pe uPeteli akaluta naghwope palubale, akatengula kukun'dalikila akati, “Luleke pivombeka uluo Mutwa! Isio nasingakwaghe! ");
INSERT INTO wbi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Neke UYesu akansyetukila uPeteli, akam'buula akati, 'Vuuka apa ghwe Setano uve! Ghulonda kukusigha une kuvomba uvughane vwa Nguluve ulwene masaagha gha vaanha. ");
INSERT INTO wbi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pe akavavuula avavulanisivua vaake akati, “Umuunhu juno ulonda kukumbilila une, avuleke uvughane vwake, itavule ambingililaghe nambe kuuve kwe kufua. ");
INSERT INTO wbi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ulwakuva umuunhu juno ilonda kupoka uvwumi vwake, ujuo alambusia, looli umuunhu juno ikwambusia uvwumi vwake, ujuo alambusia, looli umuunhu juno ikwambusia uvwumi vwake vwimila une, ujuo iliiva nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lino, umuunhu ndepoonu ivumbulila kiki kuuva nu vumofu vwoni uvwa iisi, neke ambusie uvwumi vwake? nambe umuunhu ahumie kiki apyanisia pa vwumi vwake? ");
INSERT INTO wbi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ulwakuva une ne Mwana ghwa Muunhu nilikwisa na vanyamhola vango mu vuvaha vwa Nhaata ghwango. pe nilikumhomba nujunge kuling'hana ni mbombo saake, ");
INSERT INTO wbi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","kyang'haani nikuvavuula, vamonga nkate mulyumue mwe vano muli apa, navalafua kuhanga pano vikunyaagha ne Mwana ghwa Muunhu nilaava nikwisa mu vutwa vwango. ");
INSERT INTO wbi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ifighono ntanda ye fikilile, Uyesu akavatoola UPeteli, uYakovo nu Yohani unuuna. Akaluta navoope ku kudunda ikitali, vakijekela. ");
INSERT INTO wbi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ye vali pala, UYesu akanduka pamaaso ghaave. Ku maaso akava ivalatika hwene lijuva nagha menda ghaake ghakava mavalafu fiijo hwene lijuva nagha menda ghaake ghakava mavalafu fiijo hwene lumuli. ");
INSERT INTO wbi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Unsiki ghughuo, vakasetuka avavili avalongosi uMoose nu Eliya, vijova nu Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pe uPeteli akam'buula uYesu akati, 'Ghwe Mutwa, lunono usue tukalaghe bahaapa! Nave ukeliile, nijenda ifyeve fitatu. Kimo kiive kyako, kimonga kya Moose, ikingi kiive kya Eliya.' ");
INSERT INTO wbi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","UPeteli ye ajiighe ijova, lolagha, ilifunde lino livalatika likiisa, likavapulikila. Pe likapulikika ilisio kuhuma mu lifunde liiti. 'Uju ghwe Mwanango umughanike ghwango juno inkeliile, mupulikisyaghe umwene!' ");
INSERT INTO wbi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Avakuvulanisivua vala ye vapuliike isio, vakoghopa kyongo, vakakupama. ");
INSERT INTO wbi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","UYesu akaveela pa veene, akavabasia, akavavuula akati, “Ima, muleke pikwoghopa! ");
INSERT INTO wbi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ye vikwimamka, vilola, navakwamwagha umuunhu ujunge, looli ju Yesu mwene. ");
INSERT INTO wbi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ye vali mu kidunda vikwika, uYesu akavavuula akati, “Namungampangilaghe muunhu sino musivwene, kuhanga unsiki ghuno une ne Mwana ghwa Muunhu nisyuka kuhuma ku vafue. ");
INSERT INTO wbi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","avavulanisivua vaake vakamposia vakati, “Ongo avavulanusi va ndaghilo sa Moose viiti, aliisa taasi uEliya, uKilisite ye akyale kukwisa. ");
INSERT INTO wbi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","UYesu akavamula, akati, 'se seene, aliisa taasi uEliya, kuuti anosie sooni. ");
INSERT INTO wbi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Neke nikuvavuula niiti, uEliya alisile, avaanhu navakankagwile, vakam'bombela sino vakighanile aveene. Enendiiki, na juune ne Mwana ghwa Mulunhu fye kyavikumusia.” Pepano avavulanisivua vala vakankagwile, vakam'bombela sino vakighanile aveene. Enendiiki, na juune ne Mwana ghwa Muunhu fye kyavikumhumusia.” ");
INSERT INTO wbi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","pepano avavulanisivua vala vakalutang'hania kuuti uYesu aveele ijova imhola sa Yohani uMwofughi. ");
INSERT INTO wbi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yevafikila mukipugha kya vaanhu, umuunhu jumo akamulutila, akafughama pavulongolo pa mwene, na pikumbula, ");
INSERT INTO wbi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mutwa, unsanhile umwanango, ulwakuva alinikivasi na pipumuka kyongo. Ulwakuva kakinga ighwela pamwoto nambe mumalenga. ");
INSERT INTO wbi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nimuletile kuvavulanisivua vako, looli navaghwesisie pikunsosia. ");
INSERT INTO wbi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","u Yesu akamula akati, “Umue kikolo kinonakikumwitika kange kinokinangike, nikukala palikimo numue mpaka liighi? nikugudilanila numue mpaka lighi? mumulete apa kulyune.” ");
INSERT INTO wbi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","U Yesu akadalikila, ni lipepo likamuma. usoloka akasosevua kuhuma unsiki ghula. ");
INSERT INTO wbi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pa uluo avavulanisivua vakamwisila u Yesu khu vusyefu na kukumposia,”Na kiiki tukakunilue kukudagha?” ");
INSERT INTO wbi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","U Yesu akavavuula,”Ulwakuva ulwitiko lwinu luudebe. Kyang'haani nikuvavula, ndavule muva nhu lwitiko nambe ludebe heene meeke sa mbeju isa haradali, muwesia pikukivula ikidunda iiki, vuuka kuhuma apa ulute kuula, nhi kyene kiivuka kange na piiva nhi khinu kyekyoni kiila ikya kusiting'ana kulyumue. Gadilila: Amasio agakidebe ughwa 21 ");
INSERT INTO wbi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Looli, ilipepo iili naliingahume, looli khu nyifunyo na kudinda”naghivoneka mhu nakala inofu isa kali). ");
INSERT INTO wbi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Unsiki ghunovajighe khu Galilaya, u Yesu akavavuula Avavulanisivua va mwene,”u Mwana ghwa Adamu ivikua mumavoko gha vaanu. ");
INSERT INTO wbi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kange vikumbuda, nhi kighono ikya vutatu isyuka.”Avavulanisivua vakasukunile fijo. ");
INSERT INTO wbi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na veene yevafilkile khu Kapenaumu, avaanhu vanovikong'ania ikodi ija kivalilo shekeli vakamulutila u Petro na kuuti,”Vuuli m'bulanisi ghwinu ihomba ikodi ija kivalilo shekeli?” ");
INSERT INTO wbi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Akati,“Ena”Looli u Petro ye ingile munkate mhu nyumba, u Yesu akajova nhu Petro ulwakwasia na kuuti,”Ghusagha kiiki Simon? Avatua va iisi, vikwupila ikodi nambe uvushuru kuhuma uveni? Khu vaala kuhuma kuvaghesia? ");
INSERT INTO wbi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nhu nsiki u Petro akati, “Kuhuma khu vaghesia “u Yesu akam'bula, pa uluo avatemi vavusivue mhu vuhombaji. ");
INSERT INTO wbi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ulwene kyande tulavapelela avasongesia songo vahoke amkole, luta kulisumbe, utosie indovano, isamaki jino kyande jiiva nhasi kulovua utoole. Isamaki ijio ung'amalule umulomo ghwake, ghukujaagha indalama jimo. Indalama ijio utoole uvapeele avasongesia songo uhombele isongo une nuuve. ");
INSERT INTO wbi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Unsiki ghulaghula avavulanisivua vakisa kwa Yesu na kukum'bula,”Ghwe veeni juuno m'baha mhu vutwa uvwa kukyanya?” ");
INSERT INTO wbi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","U Yesu akakemela umwana un'debe, akam'bika pakati na kati pa vanave, ");
INSERT INTO wbi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na kuti,”kyang'haani nikuvavuula, mungabuhile kulata na kuuva heene vaana vadebe namunganoghele kukwingila mhu vutua vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pa uluo umuunhu ghweni juuno ikuviika heene mwaana n'debe, umunhu ndavule ujuo ghwe mbaha mhu vutua uvwa kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kange umuunhu ghweni juuno ikumwupila umwaana u'debe mhu litavua lyango ikunyupila uune. ");
INSERT INTO wbi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Looli ghweni juno ipelepesia jumo pakati pa vadebe ava vano vikunyitika kugaluka, luuva lunono kwa muunhu ujuo ilivue ilivaha ilya kuhavulila likungua kusingo kwa mwene, kange kudwivilila mhu kyogho mhu nyanja. ");
INSERT INTO wbi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Iiga khu iisi ulwakuva unsiki ughwa kukalasia! ulwakuuva nalunofu khu masiki aghuo kukwisa, looli iiga kwa juula umuunhu juula amasiki ghala ghikwisa vwimila umwene! ");
INSERT INTO wbi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Heene uluvoko lwako nambe ulughulu lwako lukukupelepesia kukalala, udumule kange utaghe kuvutali nhu nuve. Lunofu kyongo kulyuve juuve kukwingila khuvwumi kuuva nsila luvoko nambe uvulemavu, kuliko kutaghua khu mwooto ughwa kusila na kusila ghuva na mavoko ghooni nambe amaghulu ghooni. ");
INSERT INTO wbi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Heene iliso lyako likukukalasia, kuula kange ulitaghe kuvutali nuvee. Lunofu kyongo kulyuve juuve ghwingile kuvwumi nhi liiso limo, kuliko kutaghua khu mwooto aghwa kusila na kusila ghuva nha maaso ghooni. ");
INSERT INTO wbi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Lolagha kuuti mulisa kusyojola juumo ughwa vadebe ava. Ulwakuva nikuvavuula kuuti kukyanya kulivanyamola vavanave ifighono fyoni vilola uvweni vwa Nhaata ghwango juuno alikukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Gadilila: Amasio ghanoghivoneka heene gha kidebe kya 11,”Ulwakuuva u mwaana ghwa Adamu akisile kukutupoka kiila kinokikasovile”naghakavonike mhu nakala innofu isa kali). ");
INSERT INTO wbi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Musagha kiiki? Pano umunhu alining'olo kijigho kimo, jimo musene isova, vuuli naikuvaleka ifijigho tanda ifya kufidunda na kuluta kukumulonda juumo juuno asovile? ");
INSERT INTO wbi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kange angamwaghe, kyang'haani nikuvavuula, ikunkela kuliko vaala kijigho kimo nhu tanda vanonavisova. ");
INSERT INTO wbi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pa uluo navwevwighane vwa Nhaata ghwinu ughwa kukyanya kuuti juumo mhu vadebe ava valemale. ");
INSERT INTO wbi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Heene unyalukolo ghwako angakukosele, luuta, ukansone ilidoa pakate palyuve nhu mwene pano iiva mwene jujuuo. Ndavule ikukupulikisia, ghuva ugomwisie unyalukolo ghwako. ");
INSERT INTO wbi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Looli nave naikupulikisia, ntoole unyalukolo juumo nambe vavili kyongo palikimo nuuve, Ulwakuuva mumalomo agha volesi vavili nambe vatatu kiila lisio linoghile kukagulua. ");
INSERT INTO wbi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nave ibeda kuvampulikisia, livule ilikong'ano ilisio ilio, nave ibeda vulevule kupulikisia ilikong'ano, looli avisaghe heene muunhu ughwa vapanji usonga songo. ");
INSERT INTO wbi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kyang'haani nikuvavuula kyekyoni kiila kinomuliva mudinda mhu iisi na kukyanya kidindua. kange kyekyoni kinomudindula mhu iisi na kukyanya kidindulivua. ");
INSERT INTO wbi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kange nikuvavuula kuuti nave avaanhu vavili pakati palyumue vangiting'ane vwimila vwa lisio lyelyoni pa iisi linovisuma, iilio u Nhaata ghwango ughwa kukyanya ivomba. ");
INSERT INTO wbi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ulwakuva vavili nambe vatatu vangakong'ane palikimo khu litavua lyango, une nili pakatenakate naveene. ");
INSERT INTO wbi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pepano u Petro akisa na pikum'bula u Yesu,”ghwe Mutwa, na kalingi unyalukolo ghwango ifikuhoka une nisaghile? Nifikusaghilagha kuhanga kufika lekela lubale?” ");
INSERT INTO wbi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","U Yesu akam'bula,”Naniiti kufika lekela lubale, looli usaghilaghe fijigho lekela lubale. ");
INSERT INTO wbi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ulwakuuva ulu uvutwa vwa kukyanya vuling'ine ni kihwanikisio ikya ntwa jumonga juno akalondagha kuvala fino kuhuma kuvavombi vaake. Untwa ujuo ye atengwile ");
INSERT INTO wbi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","kuvala fino ikuvasighila, um'bombi jumo alyale isighilua italanta imbilima kijigho. ");
INSERT INTO wbi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Um'bombi ujuo ulwakuva alyakunilue kuhomba, untwa ghwa mwene alyaghile aghusivue, un'dala ghwake palikimo na vaana vaake ni fiinu fyoni fino alyale nafyo, neke ahombe fyoni. ");
INSERT INTO wbi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pe um'bombi jula akaghua, akafughama pavulongolo pa mwene, akati,'Mutwa, uve nhu lugudo palikimo nune, ifinu fyako fyoni nihomba.' ");
INSERT INTO wbi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pe untwa ughwa jula um'bombi, ulwakuva akasukumivue kyongo nhu lusungu, akantavula na kukunsaghila fyoni fino isighilia ");
INSERT INTO wbi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Looli um'bombi jula ye avukile pala akatang'ana nu mbombi ujaake, juno alyale ikunsighila idinali kilundo. Akankola, akantaka kusingo, akam'bula,'Uhombe fyoni fino nikukusighila.' ");
INSERT INTO wbi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Looli um'bombi ujaake jula akafughama pa maaso ghaake, akampelepesia, akati,'Nisuma unguule padebe ifinu fyako fyoni fino nisighilua nihomba.' ");
INSERT INTO wbi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Neke um'bombi jula akakaana. pe, akaluta kukundindila ujaake mudinde, kuhanga pano ihomba ifinu fyoni fino isighilua. ");
INSERT INTO wbi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Avavombi avajaake ye vasivwene isio. Vakalemala kyongo. Vakaluta na kukum'bula untwa ghuvanave sooni sino sivombike. ");
INSERT INTO wbi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pepano untwa akankemela um'bombi jula, akam'bula akati,'Ghwe m'bombi uve uli mbivi, uve ye unisumile une nakusaghila fyoni fino nakusighilagha. ");
INSERT INTO wbi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Asi! nuveele unoghile kukunsungukila umbombi un'jaako, ndavule une niveele nikunsungukile une? ");
INSERT INTO wbi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Untwa jula akakalala kyongo pe akalaghila atwalue mu ndinde kupumusivua kuhanga pano ihomba ifinu fyoni fino isighilua. Enendiiki na ju Nhaata ");
INSERT INTO wbi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ghwango ughwa kukyanya fye ilikuvahomba, na jumue nave namunkusaghila nhu mwoojo um'balafu unyalukolo.” ");
INSERT INTO wbi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","U Yesu ye amalile amasio aghuo, akavuuka mhu Galilaya, akaluta kukighavo ikya Yudea imwambo ija kikogha ikya Jordani. ");
INSERT INTO wbi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Avaanhu viinga vakam'bingilila, ukuo akavasosia. ");
INSERT INTO wbi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Avafarisayi vamonga vakaluta kukumughela, vakamposia,”Asi lukwitisivua mu ndaghilo siitu umuunu kukuntavula un'dala ghwa mwene mhu nongua sooni?” ");
INSERT INTO wbi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","U Yesu akavamula akati,”Namwimbile mumalembe amimike kuuti kuhuma kuvutengulilo u Nguluve alyapelile umughoosi nhu n'dala? ");
INSERT INTO wbi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","U Nguluve akati,'Mhu uluo umughoosi ikumuleka uviise nhu ng'ina ghwa mwene neke ivisagha nu n'dala ghwa ke, vevavili ava viiva m'bili ghumo?' ");
INSERT INTO wbi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Apuo na viiva vavili kange, looli viiva m'bili ghumo. Lino, kino u Nguluve alungile, umuunhu nangalekanisyaghe.” ");
INSERT INTO wbi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Avafalisayi vala vakamposia kange vakati,”Nave fyelulivuo u Moose mu ndaghilo saake alyajovile kuuti umughoosi anoghile kukumpeela un'dala ghwake ikalatai ija kuntavula na kukumuleka?” ");
INSERT INTO wbi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Akavavula,”u Moose alyavitikisie kutavula avadala viinu, ulwakuva namupulika mu sino mululanisivua neke kuhuma kuvutengulilo nafye lulyale. ");
INSERT INTO wbi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lino nikuvavula, kuuti umuunhu ghweni juno itavula un'dala ghwake, nave un'dala ujuo nam'bwafu neke itoola ujunge, iiva ivwafuka. ");
INSERT INTO wbi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pe avavulanisivua vaake vakam'bula u Yesu,”Nave fye lulivuo vwimila umughoosi nu n'dala, ye kuba kubuhiila kutoola.” ");
INSERT INTO wbi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Looli u Yesu akavavula,”Nakwekuti avaanhu vooni ndepoonu vikwupila imbulanisivuo isi, looli va vano u Unguluve avapeliile uvukagusi uvwa kwupila imhola iiji. ");
INSERT INTO wbi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nikuvavula isio ulwakuva kwevale vano navitoola ulwakuva vaholilue vaghumba. Kwe vale vano vavitoola ulwakuva avaanhu avange vavavombile kuuva vaghumba. Vamonga navitoola vwimila kukum'bombela u untwa ghwa kukyanya. Umuunhu juno ikwupila imhola iiji upilaghe.” ");
INSERT INTO wbi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Avaanhu vamonga vakamuletela u Yesu avaana avadebe kuuti aviike amavoko ghaake pa veene, avavulanisivua vaake vakavadalikila avaanhu vaala. ");
INSERT INTO wbi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Neke u Yesu akavavula akati,”Muvaleke avaana avadebe, visaghe kulyune namungavasighaghe, ulwakuva uvutwa uvwa kukyanya vwa vaanhu vano valindavule avaana ava. ");
INSERT INTO wbi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","U Yesu akaviika amavoko ghaake pa veene, pe akavuka pala. ");
INSERT INTO wbi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Unsoleka jumonga akaluta kwa Yesu akaposia akati,”Ghwe M'bulanisia, nivombe kiiki ikinofu neke nikave uvwumi uvwa kusila kusila?” ");
INSERT INTO wbi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","U Yesu akamwamula akati,”kiiki ukumhosia une vwimila uvunofu? U Nguluve mwene ghwe nofu, Nave ghulonda kukwingila ku vwumi uvwa kusila kusila, uvingililaghe indaghilo sa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Unsoleka jula akaposia akati,”Indaghilo siliku?”u Yesu akamwamula akati,”Nungabudaghe, nungavwafukaghe, nungahijaghe, nungolekaghe isa vudesi, ");
INSERT INTO wbi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Umwoghopaghe uvaasoo nhu mamajo, na kukumughana unino ndavule ghukughana juuve.” ");
INSERT INTO wbi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Umuunhu jula akati,”Isio sooni nisigadilile. Kiinu kiiki ikinge kino naghilue?” ");
INSERT INTO wbi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“U Yesu akam'bula akati,”Nave ghulonda kuuva mugholofu, ulute, ukaghusie fyoni fino ulinafyo, neke uvapeele avakotofu, apuo pe ghuuva ni kyuma kukyanya. Pepano ghwisaghe umbingililaghe.” ");
INSERT INTO wbi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Unsoleka jula ye apulike isio akavuka pala asukunile, ulwakuva alyale ni kyuma kinga. ");
INSERT INTO wbi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","U Yesu akavavula avavulanisivua vaake akati,”Kyang'haani nikuvavuula, lutalaamu kyongo kwa muunhu ummofu kukwingila mu vutwa vwa kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nikuvavula kange kuuti, kihuugu fiijo ingamila pikila pa kalyoli kya sindano, kukila ummofu kukwingila mu vutwa vwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Avavulanisivua vaake ye vapulik amasio aghuo, vakadegha kyongo vakaposia vakati,”Pe veeni lino juno anoghile kupokua?” ");
INSERT INTO wbi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu akavalola akavavula akati,”Ku vaanhu uluo lutalamu, neke kwa Nguluve sooni sivombeka.” ");
INSERT INTO wbi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pe pano u Peteli akam'buula akati,”Lolagha, Usue tufilekile fyoni tukukuvingilila uve. Pe tuvumbulila kiiki? ");
INSERT INTO wbi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","U Yesu akavavula,”Kyang'haani nikuvavula kuuti, une ne mwana ghwa muunhu niliiva nikalile pa kitengo kyango ikya vuvaha mu iisi imia na jumue mwe vaano mukumbingilila lino mulikukala mu fitengo kijigho na fivili ifya Isilaeli. ");
INSERT INTO wbi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Umuunhu ghweni juno ajilekile inyumba jaake, nambe avanine, nambe avalumbu, nambe uviise, nambe ung'ina, nambe avaana vaake, nambe amaghunda ghaake vwimila une, ikwupila finga fiijo kukila fino afilekile na kukwupila uvwumi uvw kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Neke vinga vano va kwanda, valaava va vusililo, ava vusililo valaava va kwanda. ");
INSERT INTO wbi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ulwakuuva uvutwa vwa kukyanya vuli ndavule umuunhu unya mughunda, juno alyalavile fiijo kuluta kulonda avaanhu ava kuvomba imbombo mu mughunda ghwake ughwa sabibu. ");
INSERT INTO wbi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ye avavwene akiting'ana navo kukuvavomba uluhombo ulwa kighono kimo nujunge idinali, akavasuug'ha khu mughunda ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Akavalilo aka vutatu palwakilo akahuma kange akavagha avange vali pa lighililo vasila mbombo. ");
INSERT INTO wbi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akavavula akati,'Na jumue lutagha kuvomba imbombo mu mughunda ghwango ughwa sabibu, une kyanikuvahomba mweni uluhombo luno lunoghile. ");
INSERT INTO wbi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Voope vakaluta ilijuuva ye lilipamutu akavalilo aka ntanda kange akavombile vulevule. ");
INSERT INTO wbi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ye vwilile akavalilo aka kijigho na kamo akahuma kange akavagha avange vimile pa lighulilo. Akavaposia akati,'Kiiki mwimile apa ikighono kyoni kisila mbombo?' ");
INSERT INTO wbi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Aveene vakamwamula vakati, Ulwakuva nakwale umuunhu juno atupeliile imbombo. Umwene akavavula akati,'Na jumue lutagha kuvomba imbombo mu mughunda ghwango ughwa sabibu.' ");
INSERT INTO wbi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ilijuva ye litetemela, unyamughunda jula akam'bula umwimili ghwa mbombo jaake akati,'Vakemele avavombambombo vooni kuuti uvahombe uluhombo lwave, Pano ghukuvahomba utengule avavombi vano vaveele visile ulwa vusililo na kumalikisia avavombi vano vaveele va kwanda kufika.' ");
INSERT INTO wbi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pe avavombi vano vasilile pakivwilile akavalilo aka kijigho na kamo vakiisa vakahombua nujunge idinali. ");
INSERT INTO wbi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Avavombi vano vaale va kwanda, ye viluta kwa jumo ikuvahomba vakahuviila kuhombua nyinga kukila avange. Neke voope vakahombua nujunge idinali jimo jino lwale luhombo lwa kighono kimo. ");
INSERT INTO wbi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ye vupile uluhombo lwave, vakatengula pikung'hulasia kwa nyamughunda. ");
INSERT INTO wbi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Viiti,'Avaanhu avuo vavombile imbombo akavalilo kamo keene, lwandani utupeliile uluhombo luno luling'hinena veene? Ongo usue tuvombile imbombo nhu lupumuko ulukome nu lujuuva imwisi jooni.' ");
INSERT INTO wbi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Unyamughunda jula akamwamula jumonga mu vavombi vala akati,'Nyalukolo, nanikusoveleng'hinie nambe kukuhijila kimonga. Natuveele twiting'ine idinali jimo? ");
INSERT INTO wbi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Upila uluhombo lwako vuuka ulutaghe. Une nilamwile kukumhomba umuunhu uju ughwa vusililo uluhombo luno luling'iine nu luhombo lwako. ");
INSERT INTO wbi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Asi! Nalukwitikisivua kuvomba ndavule nighanile vwimila ikyuma kyango? uli ni kivini ulwakuva une nili nkoola kukuvapeela ifuinu avange? ");
INSERT INTO wbi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","U Yesu akajova kange akati, fye enendiki ava vusililo valaava va kwanda ava kwanda valavavva vusililo. ");
INSERT INTO wbi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","U Yesu ye alimusila iluta ku Yelusalemu, akavakemela palubale avavulanisivua vaake kijigho na vavili, akavavula akati, ");
INSERT INTO wbi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Lolagha tuluta ku Yelusalemu, ukuo Mwana ghwa Adamu niluta kukwohelua ku vavaha va vatekesi na vavulanisi va ndaghilo. Aveene kyavikuhigha kuuti nibudue. ");
INSERT INTO wbi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kange kyavikunhwala ku vaanhu vano nava Yahudi kuuti vanyovelele, vang'hope ni mijeledi na kukung'homelela pa kikovekano. Neke ikighono ikya vutatu nisyuka.” ");
INSERT INTO wbi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pepano un'dala ghwa Sebedaayi akaluta kwa Yesu palikimo na vanaake. Akafughama pa mwene akasuma lumonga kuhuma kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","U Yesu akam'bula,”Ghulonda nikuvombele kiiki? Umwene akamwamula akati,”Nisuma uvitikisie avanango ava vavili, kuuti mu vutwa vwako jumonga ikale ulubale lwako ulwa kundio ujunge ikale ulubale ulwa kung'highi.” ");
INSERT INTO wbi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","U Yesu akamula akati,”Namukagwile luno musuma. Asi! ndeponu mutavwile kupumuka ulupumuko luno nipumuka?“vakamwamula,”Tutavwile.” ");
INSERT INTO wbi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","U Yesu akavavula akati,”Lweli kyamupumuka ukupumuko luno niluta pipumuka. Neke imhola ija kukala ulubale lwango lwa kundio nambe ulwa kung'highi navutavulilua vwango looli u Nhaata ghwango ghwe juno alavapeela vano avaling'hanikisie ng'haani. ");
INSERT INTO wbi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Avavulanisivua avange vala kijigho ye vapulike isio, vakavakalalila avanamuunhu vala vavili. ");
INSERT INTO wbi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pepano u Yesu akavakemela vooni palikimo akavavula akati,”Mukagwile kuuti avautwa va iisi vitema avaanhu vaave ni ngufu. Kange vihufia ingufu isa vutavulilua vwave ku vavanda neke vavakundaghe mu sooni. ");
INSERT INTO wbi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Neke kulyumue nafye lungafisaghe. Looli umuunhu ghweni juno ilonda kuuva m'baha mulyumue avisaghem'bombighwinu. ");
INSERT INTO wbi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kange umuunhu juno ilonda kuuva mulongosi avisaghe m'bombi ghwinu. ");
INSERT INTO wbi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndavule vule u Mwana ghwa Adamu alisile kuvombelua, looli alisile kukuvavombela, avange na kuhumia uvwumi vwango kuuti nivavange vinga.” ");
INSERT INTO wbi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Unsiki ghuno vakaluta mu likaaja ilya Yeriko, ilipugha lya vaanhu likava likum'bingilila. ");
INSERT INTO wbi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lolagha avabofu amaaso vavili valikalile mulubale musila. Ye va pulike kuuti u Yesu ikila isila jila, vakakemeela fiijo,”Ghwe Mutwa, ghwe Mwana ghwa David utusungukile.” ");
INSERT INTO wbi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ilipugha lila likavadalikila kuuti vajiike kimihe. Neke aveene vakaghina kukemeela fiijo viiti, Ghwe Mutwa, Mwana ghwa David, utusungukile.” ");
INSERT INTO wbi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pepeno u Yesu akiima akavakemeela avabofu vala akavaposia akati,”Mulonda nivavombele kiiki?” ");
INSERT INTO wbi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aveene vakamwamula vakati,”Ghwe Mutwa tulonda amaaso ghiitu ghalolaghe.” ");
INSERT INTO wbi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","U Yesu, akavavonela ikisa akavabasia amaaso ghaave, nakalingi amaaso ghakasooka vakatengula kulola kange pevakam'bingilila u Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","U Yesu na vavulanisivua vaake ye valipipi kufika ku Yelusalemu vakafika mu likaaja ilya Betifage, pa idunda ikya Miseituni, U Yesu akavasuung'ha avavulanisivua vavili, ");
INSERT INTO wbi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akavavula akati,”Mulute mu kikaaja kino kilikuvulongolo kulyumue, mukujaagha idogovi jikungilue, jilininyaake mwavule mundetele. ");
INSERT INTO wbi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nave umuunhu ikuvaposia, mutisaghe, u Mutwa alinuvufumbue naso,'ghwope pe kyaikuvitikisiakukwisa naso” ");
INSERT INTO wbi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Isi silyavombike kukwilanisia ilisio lino lilyajovilue nu m'bilikuuti, ");
INSERT INTO wbi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","vavuule avaanhu ava mulikaaja ilya Syoni, kuuti Lolagha, UNtwa ghwinu ikwisa, Nkoola ikwisa angaliile idogovi, pakyanya pa dogovi, inyaanavija dogovi. ");
INSERT INTO wbi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Avavulanisivua vakaluta vakavomba ndavule u Yesu aveele avalaghile. ");
INSERT INTO wbi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Vakaleta idogovi jila palikimo ni nyanaake, vakatandika amenda ghaave pakyanya pa dogovi, u Yesu akangalila. ");
INSERT INTO wbi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Avaanhu vinga mu lipugha lila vakava vitandika amenda ghaave musila. ");
INSERT INTO wbi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ilipugha lya vaanhu vano valyalongwile na vano valyale mumbele mwa Yesu vakaava ni njeghelo, ija lukelo viiti,”Aghinwaghe u Mwana ghwa David! Afunyilue juno ikwisa mu litavua lya Mutwa u Nguluve. Aghinwaghe u Nguluve juno alikukyanya!” ");
INSERT INTO wbi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","U Yesu ye ikwingila mu likaaja ilya Yelusalemu, avaanhu ava mulikaaja ilio vakadegha kyongo, Vakava viposia viiti,”Uju ghwe veeni? ");
INSERT INTO wbi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Avaanhu mu lipugha lila vakavamula vakati,”Uju ghwe m'bili u Yesu, kuhuma mulikaaja ilya Galilaya.” ");
INSERT INTO wbi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","U Yesu ye alimulikaaja ilya Yelusalemu akingila mu luviika ulwa nyumba inyimike ija kufunyila akavadagha vooni vano vakaghusiagha na kughula ifiinu. Akabilivandula imeesa isa vano vananiagha indalama ni fitengo ifya vaghusia ng'hunda. ");
INSERT INTO wbi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","U Yesu akavavula akati,”Lilembilue mu malembe a Mimike kuuti,'Inyumba jango jitambuluagha nyumba ja kufunyila,'Neke umue muhambwile kuuva mhanga ja valyasi.” ");
INSERT INTO wbi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","U Yesu ye ali mu luviika lwa nyumba inyimike ija kufunyila, avabofu amaaso na valema amaghulu vakaluta pa mwene akavasosia. ");
INSERT INTO wbi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Avavaha va vatekesi na vavulanisi va ndaghilo vakafyagha ifidegho fino avobile u Yesu, na kupulika vuule avaana vikumughinia mu nyumba inyimike ija kufunyila viiti,”Aghinwaghe u Mwana ghwa David,”mu uluo vakakalala kyongo. ");
INSERT INTO wbi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Vakamposia u Yesu vakati,”Ghupulika sino avaana ava vijova? u Yesu akavamula akati,”Eena nipulika! Namwimbile mumalembe aMimike amasio ghano ghiiti,'Mu masio agha vaana avadebe na vafyele mwe muno uling'hanisie amalumbo?'” ");
INSERT INTO wbi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","U Yesu akaleka avaanhu vaala akavuka mu Yelusalemu akaluta ku kikaaja ikya Betania akava ukuo ikilo jooni. ");
INSERT INTO wbi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Palwakilo u Yesu ye igomoka ku Yelusalemu, injala jikam'bava. ");
INSERT INTO wbi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pe akaghwagha umpiki untini ghumonga piipi ni sila. Akaveela, akavona nsila fipeke nambe kimo looli ghalimatundu gheene. Pe akaghuvuula umpiki ghula akati,”Kuhuma umusyughu naghukomagha ifipeke nambe padebe.”Na kalingi umpiki ghula ghukuuma. ");
INSERT INTO wbi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Avavulanisivua va Yesu ye vasivwene isio vakadegha kyongo vakamposia vakati,”Lwandani umpiki untini ughu ye ghwumile lino lino?” ");
INSERT INTO wbi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","U Yesu akamula akati,”Kyang'hani nikuvavulamungave nu lwitiko kisila kuuva ni nganinganib, na jumue munoghile kuvomba sino nivombile ku mpiki ughu, Na kwekuuti ndepoonu muvomba sisisio seene, looli nambe mungakivuule ikidunda iki kuuti,'kumuka ghutaaghe mu nyanja,'livombeka. ");
INSERT INTO wbi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mungave nu lwitiko, fyoni fino musuuma kwa Nguluve, huvilagha kuuti mupelua.” ");
INSERT INTO wbi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","U Yesu akingila kange mu nyumba inyimike ija kufunyila, ye ivulanisia avaanhu avavaha va vatekesi na vagoyo va Vayahudi vakaluta pa mwene vakamposia vakati,”Ghuvomba isi mu vutavulilua vwani? Ghwe veeni juno akupeliile uvutavulilua uvuo? ");
INSERT INTO wbi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","U Yesu akamula akati,”Na juune nikuvaposia lumonga munganyamule pe na juune nikuvavuula nivomba isi mu vutavulilua vwani. ");
INSERT INTO wbi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Asi, uvutavulilua vwa Yohani uvwa kwofugha avaanhu vulyahumile kwani? Vulyahumile kwa Nguluve ku vaanhu? Pe vakatengula kuposania viiti, tungati vulyahumile kwa Nguluve kyaikutumposia iiti,'Ongo namulyamwitike?' ");
INSERT INTO wbi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kange tungati, vulyahumile ku vaanhu tukwoghopa ilipugha ili, ulwakuuva vooni vatang'hinie uYohani kuuti m'bili.” ");
INSERT INTO wbi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pe vakamwamula uYesu vakati,“Natukagwile.”Ghwoope u Yesu akavamula akati,”Na juune nanikuvavuula kuno vuhuma uvutavulilua vwa kuvomba isi.” ");
INSERT INTO wbi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","U Yesu akavavuula kange akati, muvona ndani imhola iji? Kwe alyale umuunhu jumonga juno alyale na vaana vavili. Akaluta kwa mwana ghwa kwanda,'akam'bulaakatiMwanango, umusyughu ulute kuvomba imbombo ku mughunda ghwa sabibu. ");
INSERT INTO wbi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","U mwana jula akamwamula akati,'Baali, nanilutaPambele akandula amasaghe ghaake akaluta kuvomba imbombo. ");
INSERT INTO wbi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Umuunhu jula akaluta kwa mwana ughwa vuvili akam'bula ndavule aveele am'bule ughwa kwanda. Akamwamula akati,'Eena niluta, Neke naakaluta. ");
INSERT INTO wbi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mu vaana vavili vala ghwe veeni juno alyavombile uvughane vwa viise? Vakamwamula vakati,”Ughwa kwanda.”u Yesu akavavula akati, Kyang'hani nikuvavuula avasongesia songo na vaghendamwalu vilikuvalongolela kukwingila ku vutwavwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ulwakuuva u Yohani alisile kulyumue kuuti avalungike isila ija vugholofu, looli avasongesia songo na vaghendamwalu valyamwitike, nambe ye musivwene sooni isio namulyalatile inyivi siinu na kukwupila imhola jaake. ");
INSERT INTO wbi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Pulikisia nivavuule ikihwanikisio ikingi. Pwealyale umuunhu jumonga alyalimile umughunda akavyala isabibu, Akajenga uluvigho kusyuta umughunda ghwoni, munkate akajenga apa kuhujila isabibu, kange akajenga pa vwimo apa kulolelelela umughunda, akaviika avavombi mu mughunda ghula neke umwene akakyula. ");
INSERT INTO wbi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Unsiki ughwa kupeta ye ghufikile, akasung'ha avakami vaake ku vavombi vaala kuuti vantolele ilighavo lyake ilya mpeto. ");
INSERT INTO wbi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Neke avavombi vala vakavakola avakami vala vano vasung'hilue, jumo vakantova, ujunge vankam'buda, jumonga vakantova na mavue. ");
INSERT INTO wbi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Unyamughunda juula akavasung'ha kange avakami avange vinga kukila vano alyavasung'hile ulwa kwanda, Avavombi vala vakavavomba avakami avuo ndavule ava kwanda. ");
INSERT INTO wbi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kuvusililo akavasung'ha umwanaake jujuo, akasagha akati,'Umwanango uju kyavikumwoghopagha.' ");
INSERT INTO wbi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Neke avavombi vala ye vamwaghile umwana ghwa nya mughunda, vakapuling'hana vakati,'Uju ghwe nya vuhaasi, ghwa mughunda ughu tum'bude neke tutoole uvuhaasi vwake. ");
INSERT INTO wbi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Vakankola, vakankwesela kunji ku mughunda ughwa sabibu vakam'buda. ");
INSERT INTO wbi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","U Yesu akavaposia akati, lino unyamughunda jula kyande ikwisa kyaikuvavova kiki avavombi vala? ");
INSERT INTO wbi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aveene vakamwamula vakati,”Ikuvam'buda kisila kukuvavonela ikisa avahosi vala kange umughunda ghwake ikuvaviika avavombi avange vano vikumpelagha ilighavo lyake ilya mpeto unsiki ghuno ghunoghile. ");
INSERT INTO wbi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","U Yesu akavavuula kange akati,”Namwimbile mumalembe aMimike kuuti,'Ilivue lino avajengi valyalikanile lye livue ilivaha ilya panguto u Mutwa u Nguluve ghwe mwene avombile ili kange lya kugegha pamaaso ghitu?' ");
INSERT INTO wbi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mu uluo nikuvavuula kuuti, u Nguluve ivusia uvutwa vwake kulyumue na kukuvapeela avaanhu va iisi isingi vano vivomba isa vughane vwake. ");
INSERT INTO wbi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Umuunhu angaghue pa livue ilio idenyeng'hana, kange umuunhu ghweni lingamughwile, likudinyania lwoni.” ");
INSERT INTO wbi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Avavaha va vatekesi na vafalisayi ye vapulike ifihwanikisio fya Yesu vakakagula kuuti ikuvajoova aveene. ");
INSERT INTO wbi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pepeno vakalondagha kukunkola neke vakoghopa ilipugha, ulwakuuva avaanhu valyantang'hinie u Yesu kuuti m'bili. ");
INSERT INTO wbi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","U Yesu akavavuula kange avavaha va vatekesi na vagoyo va Vayahudi ifihwanikisio, ifingi akati, ");
INSERT INTO wbi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Uvutwa vwa kukyanya vuhwaniine nu ntwa jumonga juno alyaling'hanisie uvutolani vwa mwanaake. ");
INSERT INTO wbi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Untwa jula akavasung'ha avavombi vaake kukuvakemeela vano alyakutile kuuti viise kuvutolani, neke aveene vakakaana kuluta. ");
INSERT INTO wbi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Untwa juula pe akasung'ha kange avavombi avange akavavuula akati,”Lutagha ku vano nikakutile uvutolani muvavuule kuuti, Lolagha, Niling'hanisie ifiinu fyoni ifya vutolani. Nibudile ing'hambako ni ndama sango sino sineniipe fiijo. Mwise kuvutolani.” ");
INSERT INTO wbi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Neke aveene navakavikila mwojo. vakaluta ku mbombo saave, jumonga akaluta kumughunga ghwake, ujunge akaluta kughusia ifiinu fyake. ");
INSERT INTO wbi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Avange vano valyakemelilue vakavakola avavombi vala vakavatova kyongo na kukuvabuda. ");
INSERT INTO wbi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Untwa jula ye apulike sino sivombike ku vavombi vaake akakalala, Akasung'ha avasikali vaake kuluta kukuvabuda avabudi vala na kunyaanya lwoni ilikaaja lyave. ");
INSERT INTO wbi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pe akavavuula avavombi vaake akati,”Uluo lwa vutolani luling'hanisivue, neke vano nikakutile uvutolani navanoghiile kange kukwisa ku vutolani. ");
INSERT INTO wbi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lino lutagha mu mapuulo, muvavuule avaanhu vooni vano mutang'hana navo kuuti viise ku vutolani.” ");
INSERT INTO wbi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Avavombi vala vakaluta mu masevo na mu mapuulo vakavakemeela na kukuvaleeta avaanhu vooni vano vakava vitan'ghana, navo avanofu na vahosi, Avaanhu vinga vakiisa vakamema mu nyumba ija vutolani. ");
INSERT INTO wbi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Neke untwa jula ye ikwingila mu nyumba jila kuuti, alole avahesia, vaake akamwagha umuunhu jumonga naafwalile umwenda ghuno ghunoghile mu vutolani! ");
INSERT INTO wbi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akamposia akati,'Nyalukolo, lwandani ghwingile muno kisila kuuva nu mwenda ghuno ghunoghiile mu vutolani? Umuunhu jula akakunua ikya kujova. ");
INSERT INTO wbi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pepeno untwa jula akavavuula avavombi vaake akati,”Nkunge umuunhu uju amaghulu na mavoko muntaaghe kunji ku ng'hiisi, ukuo ililagha na kugwegwenula amiino vwimila uvuvafi uvukome vuno alinavwo. ");
INSERT INTO wbi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","U Yesu pe akavuula akati, Vano vakemelilue, nu Nguluve kukwingila mu vutwa vwake vinga neke avasalulua vadebe.” ");
INSERT INTO wbi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pambele a Vafalisayi vakavuuka pala vakaluta kupuling'hana vwimila ikiteghe ikya kunkola u Yesu mu masio ghaake. ");
INSERT INTO wbi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pe akasung'ha kwa Yesu avavulanisivua vaave palikimobna vavingiliili va ntwa u Herode. Avavulanisivua vala vakamposia vakati,”Ghwe Mb'ulanisi, tukagwile kuuti uve ulimuunhu ghwa kyang'haani ghuvulanisia mu vwakyang'haani sino ilonda u Nguluve. Kange naghukwoghopa nambe muunhu vwimila uvuvaha vwaake. ");
INSERT INTO wbi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lino tuvuule, ghuvona ndaani indaghilo sa Moose sikwitikisia kusonga isongo kwa Kaisali?” ");
INSERT INTO wbi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Neke u Yesu akakagula amasaghe ghaave amaviivi akavamula akati,”Mwe vakedusi umue kiki mukungela? ");
INSERT INTO wbi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Muhufie ihela jino mwa musonga isongo.”Vakamuletela idinali jimo. ");
INSERT INTO wbi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Akavaposia akati,”Ikihwani nu vulembe fino fili mu hela iji fyani?” ");
INSERT INTO wbi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vakamwamula vakati,”Fya Kaisali.”Pepano u Yesu akavavuula akati,”Ifya Kaisali mumpelaghe uKaisali ifya Nguluve mumpelaghe u Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ye vapulike ulwamulo lwa Yesu vakadegha kyongo. Vakamuleka pala vakavuuka viluta. ");
INSERT INTO wbi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ikighono kilakila aVasadukayi vamonga vakaluta kwa Yesu, A Vasadukayi kye kipugha mu lwitiko lwa Kiyahudi vano viiti nakwelule ulusyukolwa vafue. Vakamposia vakati, ");
INSERT INTO wbi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ghwe M'bulanisi, u Moose alyalembile ululaghilo kuuti nave umuunhu afwile kisila mwana, unnine anoghile kuhaala umfwile jula kuuti ampapile avaana anyakusila. ");
INSERT INTO wbi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lino kwevalyale avanamuunhu lekelalubale. Ughwa kwanda akatoola un'dala akafua kisila kuleka mwana. Ughwa vuvili akamhaala umfwile jula. ");
INSERT INTO wbi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ghwope akafua kisila kuleka mwana Ghwoope ughwa vutatu lukavombeka vulevule kuhanga kufika ughwa lekela lubale. ");
INSERT INTO wbi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pambele, ghwoope un'dala umfwile jula akafua. ");
INSERT INTO wbi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lino ikighono ikya kusyuka avaanhu vooni umfwile jula iliiva n'dala ghwani mu vala lekelalubale? Ulwakuuva vooni valyantolile.” ");
INSERT INTO wbi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","U Yesu akamula akati,”Musova, ulwakuva namukagwile aMalembe aMimike nambe ingufu sa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ulwakuuva avafue valaava visyuka, nakwekulaava kutoola nambe kutolua. viliiva ndavule avanyamola ava kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Neke vwimila kusyuka avafue namwimbile mu Malembe aMimike sino u Nguluve alyavavulile avakuulu viinu kuuti, ");
INSERT INTO wbi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Une neene Nguluve ghwa Abulahamu, Nguluve ghwa Isaka, Nguluve ghwa Yakovo? u Yesu akavavuula kange kuuti u Nguluve na Nguluve ghwa vafue looli Nguluve ghwa vuumi.” ");
INSERT INTO wbi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Avaanhu mu mapugha ghala ye apulike imbulanisio saake vakadegha kyongo. ");
INSERT INTO wbi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","A Vafalisayi ye vapulike kuuti u Yesu avamwile a Vasadukayi, kuhanga vakunilue ikya kujova vakakong'haana palikimo vakaluta kwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Um'bulanisi jumonga ughwa ndaghilo sa Moose mu Vafalisayi vala akamughela u Yesu akamposia akati. ");
INSERT INTO wbi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ghwe M'bulanisi ululaghilo luliku luno luvaha kukila indaghilo sooni?” ");
INSERT INTO wbi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","U Yesu akamwamula akati,”Umughanaghe u Mutwa u Nguluve ghwako nu mwojo ghwako, ghwoni ni ngufu saako sooni nu luhala lwako lwoni. ");
INSERT INTO wbi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ulu lwe lulaghilo uluvaha kange lwe lwa kwanda. ");
INSERT INTO wbi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ululaghilo ulwa vuvili luno luling'hiine nu lwa kwanda lwe ulu, Umughanaghe unnino ndavule ghukughana juuve. ");
INSERT INTO wbi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Indaghilo sooni isa Moose ni mbulanisio isa vavili sihuma mu ndaghilo isi ivili.” ");
INSERT INTO wbi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","A Vafalisayi ye vajiighe vakong'hanile palikimo u Yesu akavaposia akati. ");
INSERT INTO wbi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Asi, mwiti kiki vwimila u Kilisite? Mwiti mwana ghwani? Vakamwamula vakati,”Mwana ghwa David.” ");
INSERT INTO wbi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","U Yesu akavaposia akati,”Nave fye lulivuo lwandani u Davidi ye alongosivue nu Mhepo ghwaNguluve ikuntambula u Kilisite Mutwa Pano iiti, ");
INSERT INTO wbi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'U Mutwa u Nguluve alyam'bulile u Mutwa ghwango,”Uuve nubvutavulilua palikimo nune kuhanga nikutange avaleme avalugu vaako uvateme.”'?” ");
INSERT INTO wbi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lino nave u Davidi ikuntambula u Kilisite iiti,“Mutwa,”lwandani uKilisite iiva mwanaake?” ");
INSERT INTO wbi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nakwealyale umuunhu juno akaghela kukwamula ilisio, kuhuma unsiki ughuo nalyangiile kukumposia kange. ");
INSERT INTO wbi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pe u Yesu akalivuula ilipugha lila palikimo na vavulanisivua vaake. Akati, ");
INSERT INTO wbi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Avavulanisi va ndaghilo sa Moose na Vafalisayi vali nu vutavulilua uvwa kuvavulanisia avaanhu indaghilo sa Moose. ");
INSERT INTO wbi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lino mugadililaghe na kuvomba sino nikuvavula, Neke namungavingililaghe amaghendele ghaave, ulwakuuva sino vivulanisia nase sino vivomba. ");
INSERT INTO wbi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aveene vipinya amasigho amasitona kukuvatwika avange neke aveene navighela nambe padebe kutanga kupinda. ");
INSERT INTO wbi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Imbombo sooni sino vivomba, vivomba mulwa kuhufia pamaaso gha vaanhu. Vipinya pa vweni na mu mavoko ififuko ifya ng'hwembe ifikome kukila ifya vange kange vikwongelesia uvutali uvwa filundo ifya salavua mu menda ghaave. ");
INSERT INTO wbi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mu fikulukulu vilonda kukukala ku fitengo ifya voghopua na mu masinagogi vilonda kukukala kuvulongolo, ");
INSERT INTO wbi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kange vilonda avaanhu vavahungilaghe nu vwoghofi mu mapuulo, Vihovoka fiijo pano avaanhu vikuvatambula viiti,”M'bulanisi.” ");
INSERT INTO wbi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Neke umue namungatambuluaghe “M'bulanisi,” Ulwakuva u M'bulanisi ghwinu alijumo mwene umue mweni mulivavingilili. ");
INSERT INTO wbi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kange namungatambulaghe umuunhu mu iisi Nhaata ulwakuuva uNhaata ghwinu, alijumo mwene, alikukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kange namungatambulwaghe 'Valongosi ulwakuuva umulongosi ghwinu alijumo mwene ghwebKilisite. ");
INSERT INTO wbi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Umuunhu ghweni juno ilonda kuuva m'baha ghwinu avisaghe m'bombi ghwinu. ");
INSERT INTO wbi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ulwakuva umuunhu ghweni juno ikughinia u Nguluve alamwisila. Neke umuunhu juno ikujisia u Nguluve alamughinia. ");
INSERT INTO wbi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Iga umue mwe vavulanisi va ndaghilo sa Moose na jumue mwe Vafalisayi, muli vakedusi! Mukuvasigha avaanhu kukagula isila ija kwingila mu vutwa uvwa kukyanya. Jumue mwe veene namukwingila kange vano vilonda kukwingila namukuvitikisia. ");
INSERT INTO wbi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Iga umue mwe vavulanisi va ndaghilo isa Moose na jumue mwe Vafalisayi muli vakedusi! Mukuvafumba avafwile ifiinu fyave neke mukufuunya inyifuunyo inhali pamaaso gha vaanhu kuuti muvoneke mulivagholofu! Ikighono ikya vuhighi mulupila ulukwegho lwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Iga umue mwe vavulanisi va ndaghilo isa Moose na jumue mwe Vafalisayi, mulivakedusi! Musyuta syuta mu iisi na kuloka inyanja neke mum'bangule nambe umuunhu jumo juno na Muyahudi kuuti aave Muyahudi. Neke kyande avangwike kuuva ghwinu mukum'biika upile kavili kukila umue ulupumuko ulwa mwooto ghuno naghusima lusiku. ");
INSERT INTO wbi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Iga umue mwe valongosi mwe vabofu amaaso, mukuvavulanisia avaanhu mwiiti. Umuunhu angajiighe vwimila inyumba inyimike ija Nguluve, nalutalamu. Looli umuunhu angajiighe vwimila isahabu jino jili mu nyumba inyimike ija Nguluve ujuo ilondua kuvomba ndavule ajighile. ");
INSERT INTO wbi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Umue mulivajasu, kange muli vabofu amaaso kiliku ikivaha kukila? Asi, isaabu au inyumba inyimike ija Nguluve jino jipelela isahabu kuuva nyimike? ");
INSERT INTO wbi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kange muvulanisia avaanhu mwiti, Umuunhu angajiighe vwimila ikitekelelo nalutalamu. Looli angajiighe vwimila ilitekelo lino vavikile pa kitekelelo ujuo ilondua kuvomba ndavule ajighile. ");
INSERT INTO wbi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Umue muli vabofu, kiluki ikivaha kukila, ilitekeo au ikitekelelo kino kipelela ilitekelo liive lyimike? ");
INSERT INTO wbi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Umuunhu juno ijigha vwimila ikitekelelo iiva ijiigha vwimila ikitekelelo ni fiinu fyoni fino fivikua pa kyene. ");
INSERT INTO wbi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kange umuunhu ghweni juno ijigha vwimila inyumba inyimike, ija Nguluve iiva ijiigha vwimila inyumba ijio na kwa Nguluve juno ikukala mu nyumba ijio. ");
INSERT INTO wbi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ghwope juno ijiigha vwimila kukyanya ijiigha vwimila ikitengo kya Nguluve na kwa Nguluve juno ikukala pa kitengo ikio. ");
INSERT INTO wbi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Iga umue, mwe vavulanisi va ndaghilo sa Moose, najumue mwe Vafalisayi, muli vakedusi! Mughina kukuntavulila u Nguluve ilitekelo ilya saka mu fiinu ifya ndalama indebe ndavule inyungu ni filungo ifingi ifya kyakulia. Neke namuvikila mwojo kuvomba imbaha sino silungikua mu ndaghilo ndavule kuuva mu vwakyang'haani, kuuva vanyalusungu na kuuva nu lwitiko. Isio se munoghile kuvomba, palikimo na madebe aghuo ghano muvomba. ");
INSERT INTO wbi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Umue mwe valongosi vabofu amaaso! Muhuuja ifiinu ifidebe mu fino munyua neke mugulubika ingamila! ");
INSERT INTO wbi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Iga umue, mwe vavulanisi na Vafalisayi, mulivakedusi! Mukuviika vagholofu pamaaso gha vaanhu neke ifiinu fino muli nafyo fya vulyasi nu vugholofu Mulindavule umuunhu juno isuka ikikombe ni sahani, kunji kwene neke ileka munkate muno munyalile uvunyali vuno vuli papinga. ");
INSERT INTO wbi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Uve ghwe Mfalisayi ghwe m'bofu amaaso, valasia taasi uvuhosi vuno mwevule munkate mulyuve neke imbombo jaako jiiva nofu. ");
INSERT INTO wbi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Iga umue, mwe va vulanisi na Vafalisayi, muli vakedusi! Muli ndavule imbiipa sino vimata ilikeeji, sivoneka nofu, kunji neke munkate simemile amafupa gha vafue nu vunyali uvunge. ");
INSERT INTO wbi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Fye lulivuo na jumue kunji muvoneka muli vagholofu neke nkate mu moojo ghinu mumemile uvukedusi nu vuhosi. ");
INSERT INTO wbi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iga umue, mwe vavulanisi na Vasalisayi, muli vakedusi! Ulwkuuva mujenga imbiipa isa vavili va Nguluve na kulava imbiipa isa vagholofu. ");
INSERT INTO wbi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pe mujova mwiiti, Pwetusavisagha amasiki gha vakuulu viitu, natwale tukuvatanga kukuvabuda avavili va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mu njovele ijiomuvonia kuuti umue mulivahosi ndavule avakuulu viinu vano valyavabudile avavili va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lino, mukwilanisie uvuhosi vuno avakuulu viinu valyatengwile. ");
INSERT INTO wbi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Umue mwe kisina ikihosi, mulindavule injoka, inyasumu ing'haali, Nde pobu mupunga ndaani uvuhighi vwa Nguluve uvwa kuvataanga ku lupumuko lwa mwoto ghunobnaghusima lusiku? ");
INSERT INTO wbi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pulikisia, lino, nikuvasung'ha kulyumue avavili, na vaanhu avanya luhala, na vavulanisi vandaghilo sa Moose neke umue mulikuvabuda ni mijeledi mu masinagogi ghiinu na kukuvadagha kuhuma ilikaaja ni likaaja. ");
INSERT INTO wbi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mu uluo u Nguluve ilikuvahigha umue vwimila kukuvabuda avaanhu vooni avagholofu, kuhuma ibudua u Abeli juno nalyahokile kiinu kuhanga ibudua uSakalia unkina Balakia, juno alyabudilue pakate pa nyumba inyimike ija Nguluve na pa kitekelelo. ");
INSERT INTO wbi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kyang'haani nikuvavuula avaanhu ava kisina iki valupila ulukwegho lwa Nguluve vwimila uvuhosi uvuo vwoni. ");
INSERT INTO wbi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Pe pano u Yesu akati, Yelusalemu, Yelusalemu! Ghubuda avavili na vaanhu vanovvisung'hua kulyuve ukuvatova na mavue! kekinga nilondile kukuvakong'hania avaanhu vaako ndavule ing'uku vule jikong'hania na kughumbatila ifyanaake neke namukunda! ");
INSERT INTO wbi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lolagha! u Nguluve ikujeleka inyumba jiinu kuuva mahaame. ");
INSERT INTO wbi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kyang'haani nikuvavuula kuuti, kutengulila lino namunganyaaghe, kange kuhanga unsiki pano muliiti,'Afunyilue juno ikwisa mulitavua lya Mutwa u Nguluve.”' ");
INSERT INTO wbi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","UYesu akahuma mu nyumba inyimike ija kufunyila. Ye iluta avavulanisivua avaake vakaluta pa mwene, vakansoona uvujenge uvwa nyumba inyimike ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Neke uYesu akavavuula akati, “Se sene, mulola uvujenge vwoni uvu vule vujengilue! Kyang'haani nikuvavuula kuuti, nalilasighala nambe livue lino lilighelama pa livue ilingi, ghooni ghilihemula? ");
INSERT INTO wbi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","UYesu akaluta pa kidunda ikya Miseituni, akikala. Avavulanisivua vaake vakaluta pa mwene, vakijekela, vakamposia vakati, “Tusuuma utuvuule, isio sino utuvulile silivombeka liighi? kange kivalilo ikya kutuhufia kuuti unsiki ughwa kwisa uve nu vusilio vwa iisi ghufikile?” ");
INSERT INTO wbi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","UYesu akavamula akati, “Muvisaghe maaso, umuumhu nangavasyangaghe! ");
INSERT INTO wbi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ulwakuva vinga vilikwisa mu litavua lyago, nujunge itisagha, Neene kilisite.' Avaanhu avuo vikikuvasyanga vinga. ");
INSERT INTO wbi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mulaava mupulika uvulugu ni mhuli isa vulugu, mulekaghe ughwa, mulekaghe pikkwoghopa. Ndavule ndaani isio silivoneka taasi, neke unsiki ughwene ughwa vusililo ghuuva ghukyale.” ");
INSERT INTO wbi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ifighino ifio iisi jilwisgha ni iisi ijingi, kange uvutwa kulua nu vutwa uvunge. Imbale ni mbale kwejilliva injalani fisenyeena. ");
INSERT INTO wbi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Isio sooni vuuva vutengulilo, ndavule uvuvafi uvwa mukijuuva, pano unsiki ughwa kupaapa umwana ghufikile. ");
INSERT INTO wbi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Unsiki ughuo, mulikolua na mpumusivua na kubudua. Avaanhu imbale sooni vilikuvakalalilagha ulwakuva mukumbingilila une. ");
INSERT INTO wbi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pepano avaanhu vinga vilivuhiila kukumbigingilila une. Vilikwohelanagha ku valugu na kukalalilagha ku valugu na kukakalilanila. ");
INSERT INTO wbi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","kange, avavili vinga ava vudesi vilihumila nakukuvasofia avaanhu vinga. ");
INSERT INTO wbi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Avaanhu vinga vliiva vahosi. Mu uluo avaanhu vinga vilivuhiila kukuvaghana avange. ");
INSERT INTO wbi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Neke juno ikuguda kuhanga kufikika kuvusililo, ujuo ghwe alakuluka. ");
INSERT INTO wbi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","IMhola iNofu ija vutwa vwa Nguluve jilipulisivua mu iisi sooni kuuti vuve vwolesi ku vaanhu vooni, pepano uvusililo vwa iisi vukwisa. ");
INSERT INTO wbi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Unsiki ughuno mulavona ' Ikiinu kino kipelela uvulamafu inyumba inyimike ija kufunyila, kyimile pavwimike, ndavule alyajovile um'bili uDanieli. juno ikwimba amasio agha alutang'aniaghe. ");
INSERT INTO wbi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Apuo pepano vano vali mu Yudea, vakimbililaghe ku fidunda, ");
INSERT INTO wbi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","juno ali pa kituvili, naagngikaghe kutoola fimonga mu nyumba. ");
INSERT INTO wbi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nambe juno ali ku mmughunda. naangagomokaghe ku kaaja kutoola ilikooti lyake. ");
INSERT INTO wbi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Iga avakijuuva vano viliiva vakunue na vano vilikwong'helesyagha ifigono ifio! ");
INSERT INTO wbi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Musumaghe kwa Nguluve kuuti unsiki ughuo ughwa kukimbila ghuleke piiva nsiki ghwa fula ni mhepo nambe ikighono ikya Sabati. ");
INSERT INTO wbi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ulwakuva ifighono ifio, kweluliiva ulupumuko ulukome luno nalughelile kuvoneka kuhuma uNguluve ipela iisi, kuhanga kufika umusyughu. Kange nalulavoneka lusiku. ");
INSERT INTO wbi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","UNguluve ale aleke kukepusia ifighono ifio, nakwale ughwa kukuluka. Neke vwimila avasulua vaake, ilikepusia ifighono ifio. ");
INSERT INTO wbi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Unsiki ughuno, umuunhu angati, 'Lola, ukilisite ali apa,' nambe Ali kula,' namungitikaghe. ");
INSERT INTO wbi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ulwakuva valiisa avaanhu vano vikutambulagha nujunge iiti ghwe 'Kilisite,' avange viila vavili vavudesi. Avuo vihufyagha ifivalilo ifivaha ni fidegho kuuti vavasofie avaanhu, nambe avasalullua va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Muvisaghe maaso ulwakuva nivavuliile ng'haani pano sikyale pikwisa. ");
INSERT INTO wbi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Lino vangavavuule kuuti, 'Lola, uMuesiya ali ku lunyika! Namungalutaghe. Nambe angati, Lola, ali kukate,' namungitikaghe. ");
INSERT INTO wbi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ulwakuva ndavule ulumili lwa fula vule lulumilika na kuvoneka imbale sooni, fye luliiva niliiva nikwisa ne Mwana ghwa Muunhu, Kulivoneka imbale sooni. ");
INSERT INTO wbi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kuno kwelili ilikanu ilifue kwe kuno amatumbusi ghikong'haana. ");
INSERT INTO wbi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ifighono ifio ifya lupunuko filiiva fisilile, 'ing'hiisi jilakupika ilijuva, naghu mwesi naghulavala, inhondue silasanguka kuhuma kukyanya, ni fiinu fyoni ifya kukyanya filasukanika.' ");
INSERT INTO wbi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Pepano avaanhu vilikufyagha ifivalilo kukanya fino fihufia kuuti ne Mwana ghwa Muunhu nikwisa. Avaanhu ava fisiha fyoni vilitengula kulila nu lundwesi. Valambona ne Mwana ghwa Muunhu nikwisa mu mafunde kuhuma kukyanya. Nikwisa ni ngufu nyinga nu vuvaha. ");
INSERT INTO wbi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pe nilikuvasuung'ha avanyamhola vango kumo lukuuta ulukelemo kuuti vavakong'hanie avasulua vooni ava Nguluve kuhuma imbale sooni isa iisi, Kutengulila ulubale lumo ulwa vusililo vwa iisi kufika ulunge ulwa vusililo vwa iisi.” ");
INSERT INTO wbi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ MUmanyilaghe ikihwanikkiso ikya mpiki untini. Pano inhaafi saake silemba na kuuva na matundu, mukagulaghe kuuti amasiki gha fula ghali piipi. ");
INSERT INTO wbi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Fye lulaava, muliiva makusivona sooni isi sino nivoliike sivombeka, mukagulaghe kuuti nili piipi kukwisa. ");
INSERT INTO wbi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kyang'haani nikuvavuula niiti, ikisina iki nakilakila kuhanga isi sooni sivombeke. ");
INSERT INTO wbi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Uvulanga ni iisi filakila, looli amasio ghango naghalakila nambe pedebe. ");
INSERT INTO wbi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Neke ikighono nu nsiki ughwa kwisa un ne Mwana ghwa Muunhu, nakwale juno akagwile nambe avanyamhola kukyanya, nambe juune ne Mwano, looli ju Nhaata mwene. ");
INSERT INTO wbi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ulwakuva niliiva nikwisa ne Mwana ghwa Muunhu luliiva ndavule lulyale ifighono ifya Nwaka. ");
INSERT INTO wbi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ifighono ifio ye lukyale kukwisa ulutalamu ulwa ghalika, avaanhu valyale vilia na kunyua, vitoola na kutolua kuhanga ikighono kila pano uNwaka ikwingila mu safina. ");
INSERT INTO wbi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Avaanhu avuo navalyakangwile kimonga kuhanga pano ighalika jikwisa, vakufua vooni. Enendikiiki fye lulaava niliiva nikwisa ne Mwana ghwa Muunhu. ");
INSERT INTO wbi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ifighono ifio avaanhu vavili viliiva pa mughunda, ujunge nikuntoola kuuva palikimo nuune, ujunge nikumuleka. ");
INSERT INTO wbi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Avakijuuva vavili viliiiva pihavula, ujunge nikuntoola kuuva palikimo nuune, ujunge nikumuleka.” ");
INSERT INTO wbi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lino, muvusaghe maaso, ulwakuva namukagwile ikighono kino uMutwa ghwinu ikwisa. ");
INSERT INTO wbi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Looli mukagulaghe kuuti, unya ale akagule unsiki ghuno umulyasi ikwisa, ale ikukala maaso, naale ileka umulyasi amemule inyumba jaake. ");
INSERT INTO wbi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lino, na jumue muvisaghe muling'hanisie, ulwakuva ne Mwana ghwa Muunhu nilikwisa ghuno namuhuviila.” ");
INSERT INTO wbi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","UYesu akavosia akati,” Ghwe veeni um'bombi unnofu, unya luhala? Um'bombi juno untwa ghwake amb'bikile kuuva mwimilili ghwa vavombi avange mu nyumba jaake, kuuti avapelaghe ikyskulia unsiki ghuno ghunoghiile. ");
INSERT INTO wbi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kuba um'bombi ujuo juno untwa ghwake iliiiva igomoka, ikumwanga ivomba sino akamulaghiile. ");
INSERT INTO wbi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kyang'haani nikuvavuula kuuti, ikum'biika um'bombi jula, imililaghe ifiinu fyake fyoni. ");
INSERT INTO wbi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Neke um'bombi um'biivi avgasaaghe mu mwojo ghwake kuuti, 'Untwa ghwango idiila kugomoka,' ");
INSERT INTO wbi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Pe atengule kutova avavombi avajaake, alisaghe na kunyua palikimo na vaghaasi, ");
INSERT INTO wbi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","utwa ghwake angagomoke ikighono nu nsiki ghno um'bombi jula nahihuviila, ");
INSERT INTO wbi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kyaikuntemania na Kukum'biikka ku lupumuko palikimo na vavudesi. Ukuo kwe vilililagha na kugwegwenula amiino vwimila uvuvafi uvukome vuno vali navwo.” ");
INSERT INTO wbi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Pe uYesu akafikuvavulagha avavulanisivua vaake akatisagha, “unsiki ughuo uvutwa uvwa kukyanya vuhwananisivua na vahinja kijigho vano valyatolila itaala saave, vakaluta kukumwupila intalan'dala. ");
INSERT INTO wbi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Avahinja vahaano mu veene valyale vajasu, vavange vahaano valyale vanya luhala. ");
INSERT INTO wbi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Avajasu vala, valyagadile itaala saave kisila kuganda amafuta agha kwongelesia' ");
INSERT INTO wbi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Looli avanya luhala vala valyagadile itaala palikimo na mafuta agha Kwongelesia mu taala. ");
INSERT INTO wbi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ulwakuva untola'ndala akadiila pikwisa, avahinja vala vooni sikavakola itulu, vakaghonenela. Mu kilo nkate, avahinja vola vooni sikavakola itulu, vakaghonelela. ");
INSERT INTO wbi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mu kilo nkate, vakapulika avaanhu vijegheela viiti, 'vaya, vaya! Untolan'dala afiike, muhume tulute kukumwambilila.' ");
INSERT INTO wbi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nakalingi avahinja vala vooni vakasisimuka, vakaling'hania itaala saave. ");
INSERT INTO wbi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Pe avahinja avajasu vala vakavasuuma avanya luhala vakati, 'Tusuuma mututange amafuta madebe, itaala siitu sisima.' ");
INSERT INTO wbi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Neke avanya luhala vala vakavamula vakati, 'Ndili! Natungavapeele, ulwakuva amafuta ghano tili nagho, naghangatukwile usue palikimo numue. Lunofu mulute kuno vighusia, mukaghule jumue. ");
INSERT INTO wbi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Avajasu vala ye viluta kughula amafuta, untolan'dala akafika. Avahinja avange vala vano valiling'hanisie, Vakingila palikimo mu vutolani, umulyago ghudindua. ");
INSERT INTO wbi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pambele avajasu vala vakafika vakavona umulyango ghudindilue pe vakati, 'ghwe ntwa! Ghwe ntwa! Tusuuma utudindulile umulyango!'” ");
INSERT INTO wbi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Neke untolan'dala akavamula akati, 'Kyang'haani nikuvavuula, nanivamanyile! ");
INSERT INTO wbi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pepano uYesu akavavuula avavulanisivua vaake akati, Lino, muvisaghe maaso, ulwakuva namukagwile ikighono nambe unsiki ghuno ne Mwana ghwa Muunhu niligomoka.” ");
INSERT INTO wbi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","UYesu akafijovagha akatisagha, “kange, uvutwa vwa kukyanya vuhwananisivua nu muunhu juno alyakyulile. Ye akyale kukyula, akavakemeela avavombi vaake, ");
INSERT INTO wbi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akavapeelaa ikyuma kyake kuuti nujunge afulusyaghe. Akavapeela ikyuma kyake nujunge afulusyaghe. Akavaoeela nujunge kuling'hana ni ngufu saake. Jumo akampeela italanta ihaano, junge italanta ivili, ujunge italanta jimo, pe umwene akakyula. ");
INSERT INTO wbi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Unsiki ghuoghuo um'bombi juno akapelilue italanta ihaano, akaluta kufulusia, akakava italanta isingi ihaano. ");
INSERT INTO wbi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Naju m'bombi juno akapelilue italanta ivili, akafulusia italanta isiingi ivili. ");
INSERT INTO wbi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Neke juno akapelilue italanta jimo, akaluta kugima umwina, akasyila italanta jila. ");
INSERT INTO wbi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ifighono finga ye fikilile, untwa ghwave akagomoka. Pe akavakemeela avavombi vaake vala kuuti nujunge ahufie kino afulwisie vwimila ikyuma kyake. ");
INSERT INTO wbi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Um'bombi juno alyupiile italanta ihaano, akiisa ni talanta isingi ihaano. Akam'buula untwa ghwake akati, 'Ghwe ntwa ghwake, ukamheliile italanta ihaano, lino nifulwise italanta isingi ihaano. ");
INSERT INTO wbi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Untwa ghwake aka'buula akati, 'Uvombile vunofu. Uve uli m'bombi nnofu, kange mhuvilua! Uvombile vunofu pa mbombo indebe, lino nikukuviika kuuva mwimilili ghwa kyma kinga. Ghwise tuhovoke palikimo.' ");
INSERT INTO wbi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“um'bombi juno alyupiile italanta ivili, ghwope akiisa ni talanta isingi ivili. Akam'buula untwa ghwake akati, “Ghwe ntwa, ukamheliile italanta ivili, lino nifulwise italanta isingi ivili. ");
INSERT INTO wbi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","untwa ghwake akam'buula akati, 'Uvombile vunofu. Uve uli m'bombi nnofu, kange mhuvilua! Uvombile vunofu pa mbombo indebe, lino nikukuviika kuuva mwimilili ghwa kyumakinga Ghwise tuhovoke palikimo.' ");
INSERT INTO wbi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Pe akiisa um'bombi juno alyupiile italanta jimo, akam'buula untwa ghwake akati, 'Ghwe ntwa, nikakagwile kuuti uve uli mwumu, ghupeta pano nunyalile, ghukong'hania pano nukesile. ");
INSERT INTO wbi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mu uluo, noghopa kusofia italanta jaako, pe nasyila mu mwima. Lino koogho italanta jaako iji. ");
INSERT INTO wbi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ntwa ghwake akamwamula akati, 'Uve uli m'bombi mbiivi, vange uli mwolo! Ukakagwile kuuti une nipeta pano nanivyalile, nikong'hania pano nanikesile, ");
INSERT INTO wbi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","lino kiki naghwaviika indalama sango ku vano vifulusia, neke nitoole palikimo nasino sifulwike? ");
INSERT INTO wbi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pepano untwa jula akalsghila akati, 'Mupoke italanta ijio, mumpeele um'bombi jula juno ali ni talanta kijigho. ");
INSERT INTO wbi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ulwakuva umuunhu ghweni juno ali nafyo ipelua ifingi, neke iiva nafyo finga. Looli juno nsila kimonga, nambe ikidebe kino ali nakyo, ikunyu. ");
INSERT INTO wbi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Um'bombi uju unsila luvumbulilo, muntaaghe kunji ku ng'hiisi, ukuo kwe ililagha na kugwegwenula amiino vwimila uvuvafi uvukome vuno iiva navwo.” ");
INSERT INTO wbi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","UYesu akafikuvavulagha avavulanisivua vaake iiti, “Une ne Mwana ghwa Muunhu niliiva nisile mu vuvaha vwango palikimo na vanyamhola vooni, nilikukala pa kitengo kyango ikya vuvaha. ");
INSERT INTO wbi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Avaanhu kuhuma iisi sooni vilikog'haana palyune. Na juune nilikuvabaghula avaanhu ndavule un'diimi vule ibaghula ing'holo kuuva paajo ni mhene. ");
INSERT INTO wbi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ikusiviika ing'holo ulubale lwake ulwa kundio, imhene ulubale lwake ulwa kun'hingi. ");
INSERT INTO wbi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pepano une ne Ntwa nilikuvavuula avanhuu vala vano vali lubela ulwa kundio, 'Mwise umue mwe vano mufyunyilue nu Nhaata ghwango, mwingile mu vutwa vuno uNguluve avaling'hanikise ng'haani kuhuma ye ipela iisi. ");
INSERT INTO wbi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ulwakuva ye nili njala, mukamheliile ikyakulia; ye nili ni kyumilua, mukamheliile amalenga; ye nili mugheesi, mukanhengeliile mu nyumba siinu. ");
INSERT INTO wbi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kange ye nighajile, mukamheliile amenda; ye nili ntamu mukisile kukumbuvusia; ye nili mu ndinde, mukisile kukundola. ");
INSERT INTO wbi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pe avaghlofu viliiti, 'Ghwe Mutwa, unsiki ghuliku ghuno tukakwaghile uli ni njala tukakupeela ikyakulia, nambe ye uli kyumilua, tukakupeela amalenga? ");
INSERT INTO wbi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kange, unsikighuliku ghuno ye uli mugheesi tukakutengeela mu nyumba siitu, nambe ye unghajile tukakupeela amenda? ");
INSERT INTO wbi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","unsiki ghiku ghuno ye uli ntamu tukakuvuvusia, nambe ye uli mu ndinde tukiisa kukukulola? ");
INSERT INTO wbi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Une ne Ntwa nilikuvamula miiti, 'Kyang'haani nikuvavuula, sooni sino mukaale mukum'bombela umuunhu juno nantambulike mu vaanhu vango ava, mukambombiille une.' ");
INSERT INTO wbi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pe nilikuvavuula vano vali lubale lwango ulwa kung'hingi nilitii,'Vuuka apa umue mwe vano uNguluve avaghunile! Lutagha ku lupumuko lwa mwoto ghuno naghusima lusiku, kuno uNguluve amuling'hanikisie na vanyamhola vaake. ");
INSERT INTO wbi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ulwakuva ye nili ni njala, namukamheleliile ikyakulia: ye nili kyumilua, namukamheliile amalenga; ye nili mugheesi, namukanhengeliile mu nyumba siinu; ye nighajile namukamheliile amenda. Kange, ");
INSERT INTO wbi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ye nili ntamu, namukisile kukumbuvusia; nili mu ndimde, namukisile kukundola.' ");
INSERT INTO wbi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pepano voope viliiti, “Ghwe Mutwa, liighi pano tukakwaghile uli ni njala, nambe ikyumilua, nambe ye uli mugheesi, nambe ye uli mughaju, nambe ye uli ntamu, nambe ye uli mugheesi, nambe ye uli mughaju, nambe ye uli ntamu, nambe ye uli mu ndinde, neke usue nakutakutengeliile? ");
INSERT INTO wbi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na juune nilikuvamula niiti, 'Kyang'haani nikuvavuula, namukambombiile une. ");
INSERT INTO wbi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pepano avahosi vililuta ku lupumuko luno nalusila lusiku. Looli avagholofu vilikwingila ku vwumi uvwa kuvusila kusila.” ");
INSERT INTO wbi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","UYesu ye amalile kujova amasio aghuo ghooni, akavavuulanisivua vaake akati, “ ");
INSERT INTO wbi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Mukagwile kuuti fikyale ifighono fivili, kuuva kyimike kyapasaka. Une ne Mwana ghwa Muunhu nitapivikua mu mavoko gha valugu kuuti nibudue pa kikovekano.” ");
INSERT INTO wbi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Unsiki ughuo, avavaha va vatekesi na vagojo valyakong'hanilemu nyumbaija ntekesi um'baha juno akatambulwagha kayafa. ");
INSERT INTO wbi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Vakapuling'hana kukunkola uYesu kisyefu kuuti vam'bude. ");
INSERT INTO wbi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pe vakapuling'hana vakati, “Tuleke pivomba uluo ikighono ikya Pasaka, avaahnu kyande vileeta ambaatu.” ");
INSERT INTO wbi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pepano uYesu akaluta mu kikaaja ikya Betania, akikala mu nyumba ja Simoni juno, neke alyale ni buuba. ");
INSERT INTO wbi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ye ikalile ali pilia, akingila umukijuuva jumonga akolile isupa ija livu inya mafuta amanofu agha Kupakala agha ndalama nyinga. Pe akaveela pa Yesu, akakung'hilila amafuta ghwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Avavulanisivua vaake ye vasivwene isio, vakakalala kyongo mu moojo ghaave vakati, “Kiki umukijuuva uju inangania amafuta enendiiki? ");
INSERT INTO wbi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Amafuta agha ghaale ghighusivua ku ndalama nyinga, neke indalama isio saale sikuvatanga avakotofu!” ");
INSERT INTO wbi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","UYesu akakagula sino vijova, akavavuula akati, “Sino vijona, akkavavuula akati, “Kiki mukun'gasia umukijuuva uju? Ambombiile imbombo inofu. ");
INSERT INTO wbi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ULwakuva avakotofu muli navo ifighono fyoni, neke une naniiva numue ifighono fyoni. ");
INSERT INTO wbi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","uju ang'hung'hiliile amafuta mulwa kunding'hania kusyilua. ");
INSERT INTO wbi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kyang'haani nikuvavuula niiti, pano iMhola iNofu jipulisivua mu iisi sooni, naji mbombo jino avombile uju jijovwagha, mu uluo vikunkumbukagha umukijuuva uju.” ");
INSERT INTO wbi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pe uYuuda Isikalioti, umo mu vasung'hua vala kijigho na vavili, akaluta Ku vavaha va vateseki, ");
INSERT INTO wbi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akavavuula akati, “Kyande mukumheela kiki nave nikumwohela iYesu kuuti aave mu mavoko ghiinu?” Pe vakampeela indalama fijigho fitatu. ");
INSERT INTO wbi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kuhuma unsiki ughuo, uYuuda akatengula kulonda isila ija kumwohela uYesu. ");
INSERT INTO wbi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ikihogono ikya kwanda ikya kyimike kya makate ghano naghavikilue ikilule, “avavulanisivua vakamposia uYesu vakati, “Ghulonda tukuling'hanikisie kuughi ukwa kuliila ikyimike ikya pasaka?” ");
INSERT INTO wbi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Umwene akavamula akati, “Mulute mu likaaja ilya Yelusalemu kwa muunhu jumonga, mum'buule kuuti, 'Um'bulanisi iiti, unsiki ghwango ghuli piipi. Une na vavulanisivua vangho kyande tulia ikyimike ikya Pasaka mu nyumba jaako.” ");
INSERT INTO wbi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Avavulanisivua vala vakaluta, vakavomba ndavule uYesu aveele alaghiile, vakavomba ndavule uYesu aveele alaghiile, vakaling'hania ikya kyimmike ikya pasaka. ");
INSERT INTO wbi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ye vwilile, uYesu akikala kulia ikyakulia palikimo na vavulanisivua vaake kijigho na vavili. ");
INSERT INTO wbi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ye vali pilia, uYesu akavavuula akati, “Kyang'haani nikuvavuula, jumnga mulyumue itapikunyohela. ");
INSERT INTO wbi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","“Avavulasivua vaake vakasukunala, kyongo, nujunge akatengula kukumposia uYesu iiti? Ghwe Mutwa, neene?”” ");
INSERT INTO wbi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","UYesu akamula akati, “Umuunhu juno isasa palikimo muune mu kivughaana, ujuo ghwe mwene kyaikunyohela. ");
INSERT INTO wbi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Une ne Mwana ghwa Muunhu nifua ndavule lilembilue mu Malembe aMimike. Neke iga, umuunhu ujo juno ikunyohela ne Mwana ghwa Muunhu! Kiba umuunhu ujuo, ngale naaholwagha.” ");
INSERT INTO wbi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pe uYuuda juno ilonda kukumwohela akaposia akati, “Ghwe M'bulanisi, veene?”UYesu akamwamula akati, “Uve ujovile.” ");
INSERT INTO wbi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ye valipilia, u Yesu akatoola unkate, akahongesia kwa Nguluve, akamenyulania. Akavapeela avavulanisivua vaake akati,”Koogho mulisaghe, ughu ghwe m'bili ghwango.” ");
INSERT INTO wbi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pe akatoola ikikombe ikya luhuuje akahingesia, kwa Nguluve akavapeela akati,”Mwunywisaghe mweni. ");
INSERT INTO wbi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ulwakuva iji je danda jango ija lufingo lwa Nguluve na vaanhu vaake jino jikung'hiika vwimila avaanhu vinga kupyaniluainyivi saave. ");
INSERT INTO wbi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Neke nikuvavuula, niiti une nalinanyua kange uluhuje, kuhanga pano niliiva ninyua palikimo numue, uluhuje ulupia ku vutwa vwa Nhaata ghwango.” ");
INSERT INTO wbi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pepeno vakimba ulwimbo, pe vakavuuka vihuma kunji viluta ku kidunda ikya Miseituni. ");
INSERT INTO wbi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pe u Yesu akavula avavulanisivua vaake akati,”Ikilo ija musyunghu umue mweni kyamukung'himbila ulwakuva lilembilue mu Malembe aMimike, Nikuntova un'dimi ikipugha ikya ng'olo kipalasana. ");
INSERT INTO wbi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Neke niliva nisyukile, nilikuvalongolela kuluta ku Galilaya.” ");
INSERT INTO wbi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","U Peteli akam'buula akati,”Nambe avange vooni vakuleke une naningakuleke nambe padebe.” ");
INSERT INTO wbi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","U Yesu akamwamula akati,”Kyang'haani nikuvavuula ikilo jijiiji ing'hongove ye jikyale kuvika, uve ghuuva ung'hanile katatu.” ");
INSERT INTO wbi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","U Peteli akamwamula akati,”Une nanikukuleka lusiku nambe kuuve kwe kufua palikimo nuuve, Nava vavulanisivua avange vooni vakajova vulevule. ");
INSERT INTO wbi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pepano u Yesu akaluta na vavulanisivua vaake pamonga pano pakatambuluagha Getisemani akavula akati,”Mukalaghe bahaapa pano une niluta pala pikufuunya.” ");
INSERT INTO wbi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pe akantoola u Peteli na vaana vavili avakina Sebedaayi akatengula kusukunala na kuhangajika mu mwojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Akavavuula akati,”Umwojo ghwango ghuli nu lusukunalo ulukome, ghunoghanogha mulwa kufua. Mukale bahaapa muvisaghe maaso palikimo nuune.” ");
INSERT INTO wbi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pe pano akaluta pavulongolo padebe akakupama paasi akifuunya akati,”Ghwe Nhaata ghwango, nave lunoghile, ikikombe iki ikya lupumuko kileke kukunyagha. Neke na kwekuuti uvombe mu vughane vwango, looli muvughane vwako.” ");
INSERT INTO wbi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pe akagomoka pa vavulanisivua vaake akavona vaghonelile, pe akam'buula u Peteli akati,”Asi, mukuniluebkuuva maaso palikimo nuune nambe kavalilo kamo? ");
INSERT INTO wbi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Muuve maaso mufunyaghe kuuti ingelo sileke kukuvalema. Umwojo ghutavwile, neke um'bili n'dwesi.” ");
INSERT INTO wbi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Akaluta kange ulwa vuvili akifuunya akati,”Ghwe Nhaata, nave ulupumuko ulu nalunoghile kuvusivua kulyune luvombeke mu vughane vwako.” ");
INSERT INTO wbi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pe akagomoka kange, akavona vaghonelile ulwakuva vaale ni tulu nyinga. ");
INSERT INTO wbi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Apuo pe akavaleka akaluta kange, kukufuunya ulwa vutatu ye ikufunya akajova amasio ghalaghala. ");
INSERT INTO wbi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pepano akagomoka ku vavulanisivua vaake akavavuula akati,”Mujiighe mufighona na kupuuma? Lolagha, unsiki ghufikile, ghuno une ne Mwana ghwa Muunhu nivikua mu mavoko gha vahosi. ");
INSERT INTO wbi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ima, tulutaghe. Lolagha unya kunyohela ali piipi.” ");
INSERT INTO wbi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","U Yesu ye ajighe ijova, navo u Yuda umo mu vavulanisivua vaake kijigho na vavili, akafika ni lipugha ilivaha vakolile ibamba ni mbuda. Avaanhu avuo valyasung'hilue na vavaha va vatekesi na vagoyo. ");
INSERT INTO wbi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","U Yuda umwolesi alyavavulile ng'hani avaanhu vala ikivalilo ikya kummanya u Yesu akati,'Juno kyanikunnonela, ujuo iiva ghwe mwene. munkolaghe. ");
INSERT INTO wbi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ye vafikile u Yuda akaluta pa Yesu akajova akati,”M'bulanisi, ughonile Pe aknonela. ");
INSERT INTO wbi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","U Yesu akam'bula akati,”Nyalukolo, vomba sino ukisisie.”Pe avaanhu vala vakamkola u Yesu na kukumpinya. ");
INSERT INTO wbi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Umuunhu jumonga mu vano valyale lumo nu Yesu, akasomola ibamba, akantova unkami ughwa ntekesi um'baha, akan'dumula imbughulutu. Neke u Yesu akam'bula ");
INSERT INTO wbi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","akati, Gomosia ibamba jaako mu nyambe jaake, ulwakuuva umuunhu ghweni juno ilwila ibamba ibudua ni bamba. ");
INSERT INTO wbi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Asi musagha kuuti une nikunilue kusuuma ulutango kwa Nhaata ghwango neke umwene asuung'he avanyamola vaake avasikali unsiki ghughuo amapugha kukila kijigho na ghavili? ");
INSERT INTO wbi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lino, nave nivombe uluo aMalembe aMimike ghano ghalembilue kuuti isi sinoghile kuvombeka mu sila iji ghaale ghikwilanisivua ndaani? ");
INSERT INTO wbi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pe akavavuula avaanhu vala vano visile kukunkola akati,”Mwisile ni bamba ni mbunda kukung'ola une hwene nili mhijim'budi? Ongo jaatu navisagha numue nivulanisia mu nyumba inyimike ija kufunyila namwang'olagha! ");
INSERT INTO wbi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Isi sooni sihumila kukwilanisia sino silyajovilue na vavili mu Malembe aMimike.”Pe avavulanisivua vaake vooni vakamuleka u Yesu vakakimbila. ");
INSERT INTO wbi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pepano ilipugha lila likankola u Yesu likantwala kwa ntekesi um'baha u Kayafa, Ukuo kwe kuno valyakong'hanile avavulanisi va ndaghilo isa Moose na vagoyo. ");
INSERT INTO wbi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","U peteli akava ikum'bingilila u Yesu pa vutali kuhanga akafika pa luviika ulwa nyumba ija ntekesi um'baha. Pe akingila munkate akikala palikimo na vasikali avaloleli kuuti alole kino kihumila kwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pepano avavaha va vatekesi ni kipugha kya valongosi va Vayahudi vakava vilonda uvwolesi uvwa vudesi vwimila u Yesu kuuti vam'bude. ");
INSERT INTO wbi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Napano avaanhu vinga, vakalutile kukwoleka isa vudesi neke navakaluvona lumonga luno lukwiting'hana. Pambele vakiisa avolesi vavili vakati. ");
INSERT INTO wbi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Umuunhu uju alyatiile,”Une niliningufu isa kumemula inyumba inyimike ija Nguluve na kujenga kange mu fighono fitatu.”' ");
INSERT INTO wbi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pepano untekesi um'baha akiima akam'buula uYesu akati,”Kiki naghukwamula nambe lisio? Avaanhu ava vikwoleka kiki vwimila uve?” ");
INSERT INTO wbi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Umwene akajika. Pe untekesi um'baha jula akam'bula kange akati,”Nikukuvuula mu litavua lya Nguluve juno mwumi utuvuule nave veeve Kilisite, uMwana ghwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","U Yesu akamwamula akati,”Uve ujovile. Nekennikuvavuula kuuti kutengulila lino mulambona ne Mwana ghwa Muunhu nitemile palikimo nhu Nguluve unya ngufu nikwisa mu mafunde kuhuma kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Untekesi um'baha ye apulike amasio aghuo akakalala akademula umwenda ghwake iiti,”Ikumuligha kyongo u Nguluve! Lino pe mulonda vwakiki uvwolesi uvunge? Mupulike vule ikumuligha u Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwiiti ndani umuunhu uju? Aveene vakati,”Anoghile kubudua.” ");
INSERT INTO wbi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pe vakatengula kukumfunyila amati ku maaso vikuntova ni mbuli. Avange vakava vitova na mapu. ");
INSERT INTO wbi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kumo viiti,”Ghwe Kilisite, vila ghwe veeni juno akutovile?” ");
INSERT INTO wbi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Unsik ughuo u Peteli alikalile kunji ku luviika, pe um'bombi jumonga umhinja akaveela pa Peteli akam'buula akati,”Na juuve uveele lumo nu Yesu ughwa ku Galilaya.” ");
INSERT INTO wbi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","U Peteli akakaana pamaaso gha vala vooni akati, Nanikagwile sino ghujova.” ");
INSERT INTO wbi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pe akavuuka pala akaluta kunji ku mulyango ughwa luviika,”Um'bombi ujunge umhinja akamwagha akavavuula avaanhu vano pwevalyale pala akati,”Umuunhu uhu aveele lumo nu Yesu ughwa ku Nasaleti.” ");
INSERT INTO wbi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","U Peteli akakaana kange akajiigha akati,”Nijiigha kuuti nanimanyile umuunhu ujuo.” ");
INSERT INTO wbi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Unsiki n'debe vuvule avaanhu vano vakimile pala vakam'belelela u Peteli vakam'buula vakati,”Kyang, hani uve uli umo nu vala ulwakuva nambe injovele jaako jivoneka kuuti uli ghwa ku Galilaya.” ");
INSERT INTO wbi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peteli akakaana akajiigha akati,”Nave nijovile uvudesi nighunwaghe,”Nanimanyile umuunhu ujuo,”Unsiki ghughuo ing'hongove jikavika. ");
INSERT INTO wbi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Apuo u Peteli akakumbuka ilisio lino u Yesu am'buula kuuti,”Ing'hongove ye jikyale kuvika ghuuva ung'hanile katatu,”Pe akahuma kunji akatengula pilila kyongo. ");
INSERT INTO wbi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Palwakilo ye kukiile avavaha vooni ava vatekesi na vagoyo vakapuling'hana vule kya vikum'buda u Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Vakankunga, vakaluta naghwope kwa Pilato, untwa ghwave uMulooma. ");
INSERT INTO wbi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","U Yuda umwolesi ye avwene uYesu ahighilue kuuti abudue akipiika vwimila sino avombile. Pe akavagomokesia avavaha va vatekesi na vagoyo indalama sila fijigho fitatu. ");
INSERT INTO wbi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akavavuula akati,”Nivombile inyivi kukumwohela umuunhu unsila nkole.”Neke aveene vakati,”Inongua ijio jaako juuve usue nakwetule.” ");
INSERT INTO wbi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pe umwene akasitagha indalama sila muluviika lwa nyumba inyimike ijakufunyila akaluta kukukunga. ");
INSERT INTO wbi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Avavaha va vatekesi vakatoola indalama sila vakati,”Nalunoghile kuviika indalama isi munyumba inyimike ija Nguluve, ulwakuuva siveele sihombilue kukuung'a idanda ja muunhu.” ");
INSERT INTO wbi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pe vakapuling'hana, vakatoola indalama sila vakaghula umughunda ughwa m'bumba fijigha kuuti mwe vanyisilaghe avahesia. ");
INSERT INTO wbi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Fye nambe umughunda ughuo nambe lino,”ghutambulua mughunda ghwa Danda.” ");
INSERT INTO wbi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mu uluo likava likwilanisivue ilisio lino um'bili uYeremia alyalembile kuuti,”Valyatolile indalama ifijigho fitatu, sino a Vaisilaeli valyiting'hiine kuuti indalama isio sikwiline kughulila umuunhu ujuo. ");
INSERT INTO wbi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Vakaghulila umughunda ghwa m'bumba fivigha ndavule alyandaghiile u Mutwa. ");
INSERT INTO wbi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pepano u Yesu akiima pa vuhighi pa ntwa u Pilato. Untwa akamposia akati,”Asi, uve veeve ntwa ghwa Vayahudi?”U Yesu akamwamula akati,”Uve ujovile.” ");
INSERT INTO wbi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pe avavaha va vatekesi na vagoyo vakatengula kujova si nyinga isa kumpelela u Yesu ahighue neke umwene naakamula kimonga. ");
INSERT INTO wbi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pepano untwa akamposia akati,”Ghwe naghupulika isi sooni sino vikwoleka kuuti uhokile?” ");
INSERT INTO wbi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","U Yesu naalyamwamwile kimonga. Apuo untwa u Pilato akadegha kyongo. ");
INSERT INTO wbi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lwale lwiho kwa ntwa pa kyimike ikya Pasaka kukun'dindulila unkungua jumo juno avaanhu vilonda kuuti ahume. ");
INSERT INTO wbi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Unsiki ughuo mu ndinde mwe alyale unkungua jumonga juno akatambuluagha Balaba. Unkungua ujuo alyakagulike fiijo vwimila uvuhosi vwake. ");
INSERT INTO wbi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lino avaanhu ye vakong'hanile, u Pilato akavamposia akati,”Asi, mu vakungua vavili ava, u Balaba nu Yesu juno viiti ghwe Kilisite mulonda nivadindulile veeni?” ");
INSERT INTO wbi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","U Pilato alyavaposisie uluo ulwakuuva alyakagwile kuutiavavaha va Vayahudi valyale ni kivini nu Yesu, fye nambe valyantwalile kwa mwene kuuti ahighue. ");
INSERT INTO wbi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","U Pilato ye ikalile pa kitengo kyake ikya vuhighi, un'dala ghwake akasung'ha imhola kwa mwene akati,”Nungam'bombelaghe uluviivi lumonga umuunhu ujuo umugholofu, ulwakuva pakilo nihangajiike kyongo mu njosi vwimila umwene.” ");
INSERT INTO wbi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Neke avavaha va vatekesi na vagoyo vakavahonga avaanhu kuuti vansuume u Pilato an'dindule u Balaba na kukumhigha u Yesu kuuti abadue. ");
INSERT INTO wbi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","U Pilato akavaposia kange akati,”Ghwe veeni juno mulonda nin'dindulile mu vakungua vavili ava?”Vakamwamula vakati,”UBalaba.” ");
INSERT INTO wbi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","U Pilato akavamposiankange akati, Pe nim'bombe kiki u Yesu juno viiti ghwe Kilisite?”Avaanhu vooni vakoova vakati,”Unkomelele pa kikivekano” ");
INSERT INTO wbi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","24","U Pilato akavamposia kange akati,”Umuunhu uju avombile luviivibluki?”Aveene vakaghina kukwova viuti,”Unkomelele pa kikovekano.” U Pilato ye akagwile kuuti naangandule uvulamusi vwa vaanhu kange vatengwile, ilyovo akatoola amalenga akoogha amavokonghaake pamaaso gha vaanhu, vooni kuvonia kuuti umwene namwale mu nkole ughuo. Akavavula akati,”Une nili nsila nkole vwimila kufua kwa umuunhu uju. Uluo lwinu jumue.” ");
INSERT INTO wbi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Avaanhu voonivakamwamula vakati,”Unkole ughwa kum'buda umuunhu ujuo ghuvisaghe ghwitu na vaana viitu.” ");
INSERT INTO wbi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pe pano u Pilato akan'dindulila uBalaba, neke akalaghila kuuti u Yesu akopue ni mijeledi na kukomelelua pa kikovekano. ");
INSERT INTO wbi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pepano avasikali va ntwa u Pilato vakatwala u Yesu mu luviika lwa nyumba ja ntwa, pe ikipugha kyoni ikya vasikali kikakong'hona, kikansyungutila u Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Vakamfuula amenda ghaake, vakafwasia isopeka indangali, ndavule ija kitwa. ");
INSERT INTO wbi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pe vakatenda ingeela ija mifua, vakafwasia ku mutu, neke vakaviika ulukwegho mu luvoko lwake ulwa ndio avonekaghe hwene ntwa. Pepano vakafughama pamaaso ghaake vikum'benapula na kukunnenela viiti,”Kamwene ghwe Ntwa ghwa Vayahudi?” ");
INSERT INTO wbi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pe vakafuunyila amati, Vakatoola ulukwegho lula mu luvoko lwake, vakantova ku mutu. ");
INSERT INTO wbi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ye vannennile, vakamfuula isopeka jila, vakafwasia amenda ghaake. Pepano vakantwala kukunkomelela pa kikovekano. ");
INSERT INTO wbi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ye vali mu sila viluta, vakatang'hana nu muunhu jumonga juno akatambuluagha Simoni, umhuma mu likaaja ilya Kileene. Avasikali vakamwumilisia kupinda ikikovekano kya Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ye vafikile pano pakatambuluagha Goligota, kwe kuuti,”Ling'ala lya Mutu,” ");
INSERT INTO wbi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Vakampeela uluhuuje uluhasing'hanie nu nkota ughwa kusilisia uvuvafi. Neke ye avonjile, akakaana kunyua. ");
INSERT INTO wbi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Vakankomelela pa kikovekano, pe vakaviika ulusodolelo kuuti amenda gha Yesu atoole veeni. Likavombeka enendiki neke likwilanisivue ilisio lino lilyajovilue nu m'bili kuuti, Vaghaviine amenda ghango, vasodolile mulwa kutoola isopeka jango.” ");
INSERT INTO wbi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe vakikala palapala kuuti vamulolelelaghe. ");
INSERT INTO wbi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pa kikovekano ku mutu ghwake vakakomelela,”UJU GHWE YESU, UNTWA GHWA VAYAHUDi.” ");
INSERT INTO wbi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Unsiki ghughuo avaanhu avange vavili vano valyale vahijivabudi vakakomelelua palikimo nu Yesu, jumonga akava ulubale lwake ulwa kundio, ujunge kung'highi. ");
INSERT INTO wbi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Avaanhu vano vakava vikila pala vakasukaniagha amatu ghaake, vikumuligha viiti, ");
INSERT INTO wbi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Uve ghwe juno ghwatisagha ghulimemula inyumba inyimike ija Nguluve neke ghujenga ifighono fitatu, nave uli Mwana ghwa Nguluve, Ghupoke, ghwke pa kikovekano!” ");
INSERT INTO wbi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Voope avavaha va vatekesi na vavulanisi va ndaghilo isa Moose palikimo na vagoyo avange vakamwovelelagha vakatisagha,” ");
INSERT INTO wbi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Avapokaghava avange, lino ikunua kukupoka jujuo! Asi, naghwe ntwa ghwa Vaisilaeli, lino iike pa kikovekano, neke na jusue tumwitike. ");
INSERT INTO wbi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U mwene ikumhuviila ubNguluve, iiti Mwana ghwa Nguluve, lino nave u Nguluve amughanile, ampoke.” ");
INSERT INTO wbi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nava vahijivabudi vanovvakomelilue palikimo nu Yesu, voope vakamuligha. ");
INSERT INTO wbi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kutenguala akavalilo aka ntanda pamwisi, ing'hisi jikakupiika iisi jooni kuhanga kufika akavalilo aka budika lubale. ");
INSERT INTO wbi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Unsiki ughwa kavalilo aka budika lubale ndiiki u Yesu akakoola fiijo akati, Eloi, Eloi, lamacsabakitani? kwe kuuti,”Nguluve ghwango, Nguluve ghwango ongo undekile?” ");
INSERT INTO wbi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Avaanhu vamonga vano valyimile pala ye vapulike u Yesu ijova amasio aghuo vakati,”Uju ikunkemeela um'bili u Eliya.” ");
INSERT INTO wbi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Unsiki ghuoghuo umuunhu jumonga mu veene akaluta luvilo akatoola ikyenda, akasuvika mu luhuje ulukali akakiviika mu lulaasi akam'besekesia u Yesubpa mulomo kuuti amiime. ");
INSERT INTO wbi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Neke avange vala vakati,”Uleke kukumpeela tulole nave u Eliya ikwisa kukumpoka,” ");
INSERT INTO wbi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pe u Yesu akakoola fiijo kange, akakunguka. ");
INSERT INTO wbi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nakalingi, umwenda ghuno ghulyaghavilue pavili inyumba inyimike ija Nguluve, ghukademuka pavili kuhuma kukyanya kiufika paasi. Iisi jikasukanika na manhalavue ghakabajuka. ");
INSERT INTO wbi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Imbiipa sikasyiluka, avimike vinga vano valyafwile vakasyuka. ");
INSERT INTO wbi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pa mbele u Yesu ye asyukile, avimike avuo vakingila mu likaaja ilyimike ilya Yelusalemu, vakavoneka ku vaanhu vinga. ");
INSERT INTO wbi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pe um'baha ghwa vasikali palikimo na vala vano valyale vikumulolellela u Yesu ye vavwene iisi jisukanika ni singi sino sikahumiile pala, vakoghopa kyongo, vakati,”Kyang'hani umuunhu uju akaale Mwana ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","“Ye sivombike isi sooni, pwevalyale avakijuuva vinga vano valyimile patali padebe vilola. Avakijuuva avuo ve vano vakam'bingilile u Yesu kuhuma ku Galilaya na kukutengelela. ");
INSERT INTO wbi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mu vakijuuva avuo, mwealyale uMaliya umhuma mu likaaja ilya Magidala, uMaliya ung'hina ghwa Yakovo nu Yosefu palikimo nu un'dala ghwa Sebedaayi. ");
INSERT INTO wbi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ye jifikile ivwilile, akiisa umuunhu jumonga ummofu, ilitavua lyake alyale ghwe Yosefu, umhuma mu likaaja ilya Alimataya. Umuunhu ujuo alyale m'bulanisivua ghwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","U Yosefu akaluta kwa Pilato kusuuma umfimba ghwa Yesu. U Pilato akavavuula avasikali vaake liiuuti vampeele umfimba ghula ");
INSERT INTO wbi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pepano u Yosefu akaluta akatoola umfimba ghwa Yesu akaghuniengelela nu mwenda ughwa kusyilila, um'balafu. ");
INSERT INTO wbi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pe akaghuviika mu mbiipa jaake imia jino alyabughwile mu linhalavue, akabilukisia ilivue ilikome pa mulyango ghwa mbiipa akavuka iluta. ");
INSERT INTO wbi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Unsiki ughuo u Maliya umhuma mu likaaja ilya Magidala nu Maliya ujunge valikalile pala valungiime ku mbiipa. ");
INSERT INTO wbi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ikighono ikya vuvili kino kyale kya sabati, avavaha va vatekesi na vafalisayi vakakong'hana kwa Pilato. ");
INSERT INTO wbi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pe vakam'bula vakati,”Ghwe ntwa, tukumbuka kuuti unsyangi jula ye mwumi, akajovile kuuti, Fingakile ifighono fitatu kuhuma nifua nisyuka.' ");
INSERT INTO wbi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lino, tusuuma avavuule avasikali vaako valolelelaghe imbiipa kuhanga ikighono ikya vutatu, tungaleke kuvomba ulu, avavulanisivua vaake ndepoonu viluta kuhiija um'bili ghwake neke vavasyange avaanhu kuuti asyukile. Nave luvembeke uluo, uvudesi uvuo vuuva vuviivi kukila uvwa kwanda. ");
INSERT INTO wbi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","U Pilato akavamula akati,”Mutoole avasikali. Mulute mulolelelaghe imbiipa ku ngufu siinu sooni.” ");
INSERT INTO wbi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pepano vakaluta ku mbiipa, vakaviika ikivalilo pa livue kuuti napwengavisaghe umunhu ughwa kuvungulusia. Pe vakavaleka pala avasikali kuuti valolelelaghe. ");
INSERT INTO wbi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ikighono ikya Sabati kikakila. Lino ye kuhenga, ikighono ikya kwasia mu mulungu, u Maliya umhuma mu likaaja ilya Magidala palikimo nu Maliya ujunge vakaluta kulola imbiipa. ");
INSERT INTO wbi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nakalingi, kikahumila ikinsenyeena ikivaha, Unyamhola ghwa Mutwa akiika kuhuma kukyanya, akaveela pa mbiipa akabilukisia ilivue lila kulubale, akikalila. ");
INSERT INTO wbi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Unyamhola ujuo alyale ivalatika hwene lumuli lwa fula, amenda ghaake ghalyale mavalafu ghivalatika fiijo. ");
INSERT INTO wbi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Avasikali vano vakalolelelagha imbiipa, vakoghopa na kutetema kyongo kuhanga vakava hwene vafwile. ");
INSERT INTO wbi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Neke unyamhola jula akavavuula avakijuuva vala akati,”Muleke pikwoghopa nikagwile kuuti mukumulonda uYesu juno vakankomelile pa kikovekeno. Napwale apa, asyukile ");
INSERT INTO wbi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ndavule alyale ikuvavuula. Mwise mulole pano vakam'bikile. ");
INSERT INTO wbi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lino mulute ng'aning'hani muvavuule avavulanisivua vaake kuuti,'Asyukile kuhuma ku vafue. Kange alongwile ku Galilaya, ukuo muluta mukum'bona.'Mukumbukaghe sino nivavulile.” ");
INSERT INTO wbi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Avakijuuva vala vakavuuka ng'aning'hani pa mbiipa pala, vajiighe nu ludwesi kumo vali nu lukeelo ulukome. Vakava viluta luvilo kukuvavuula avavulanisivua va Yesu imhola jila. ");
INSERT INTO wbi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ye viluta, nakalingi u Yesu akatang'hana navo, akati,”Mwe! Mughonile!”Pe avakijuuva vala vakaveela kwa Yesu vakafughama, vakankola amaghulu ghaake vakamwimika. ");
INSERT INTO wbi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pe u Yesu akavavuula akati,”Muleke pikwoghopa. Mulute muvavuule avavulanisivua vango valute ku Galilaya, ukuo kwe kuno vikumbona. ");
INSERT INTO wbi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Avakijuuva vala ye vali mu sila viluta, avasikali vamonga mu vano vakalolelelagha imbiipa, vakaluta kuvavaha va vatekesi mu likaaja ilya Yelusalemu, vakavavuula sooni sino sivombiike. ");
INSERT INTO wbi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pepano avavaha va vatekesi vala palikimo na vagoyo avange vakakong'hana. Vakapuling'hana na kukuvafunda avasikali vala vakavapeela indalama nyinga. ");
INSERT INTO wbi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Vakavavula vakati,”Umue mutisaghe,'Avavulanisivua vaake visile pakilo, vahiijile umfimba ghwa Yesu usue ye tughonelile.' ");
INSERT INTO wbi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","U Pilato angapulike imhola ijio usue tujova nu mwene kuhanga luvoneke kuuti namuli nu nkole.” ");
INSERT INTO wbi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pe avasikali vala vakupila indalama sila na kujova ku vaanhu ndavule vavulilue na vavahaha vala. Imhola isio sikakwila imbale sooni isa Vayahudi, kange vajiighe vipanga nambe lino. ");
INSERT INTO wbi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pambele avavulanisivua va Yesu kijigho na jumo vakaluta ku Galilaya, pa kidunda kino u Yesu alyavalaghile. ");
INSERT INTO wbi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ye vamwaghile, vakamwimika, neke avavulanisivua vamonga vakava ni nganingani kuuti ghwe Yesu. ");
INSERT INTO wbi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pepano u Yesu akaveela, akavavuula akati,”U Nguluve amheliile uvutavulilua vwoni, kukyanya na pa iisi. ");
INSERT INTO wbi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lino, mulutaghe muvalungikaghe avaanhu mu iisi sooni, vaave vavulanisivua vango, muvofughaghe mu litavua ilya Nhaata, ni lya Mwanaake ni lya Nhepo u Mwimike. ");
INSERT INTO wbi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Muvavulanisyaghe kuvingilila sooni sino nivavulile umue. Une niiva palikimo numue ifighono fyoni, kuhanga uvusililo vwa iisi.” ");
INSERT INTO wbi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Imhola inofu ija Yesu kilisite, uMwana ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ndavule lilembilue mukitabu kya m'bili u Isaya, “Lolagha nikunsuung'ha unyamhola ghwango akulongolele, ujuo ghwe ikuling'anisiagha isila.” ");
INSERT INTO wbi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ilisio lya muunhu nipilikika kuhuma ku lihaka liiti, munnosekesyaghe u Mutwa u Nguluve isila na kuling'hania muno kya ilila”. ");
INSERT INTO wbi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pepano u Yohana u mwofughi akatengula ku pilisia ku lihaka, kuuti avaanhu valataghe inyivi save nakuwofughua. ");
INSERT INTO wbi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Avaanhu kuhuma mulikaja lya Yerusalemu na mukighavo kyoni ikya Yudea, vakalutagha kwa Yohana, vakalatagha inyivi save. ");
INSERT INTO wbi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","UYohana akafwalagha umwenda ghuno ghutendilie nulwaghe lwa ngamia akipinyagha nulukova munsana, na kulia imhaasi nu vwuki. ");
INSERT INTO wbi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Akapulisyagha akatisagha, kwale jumo ikwisa mumbele mulyune unya ngufu kukila une, juno naninoghile nambe kuva m'banda ughwa kuhudula utukova twa filatu twake. ");
INSERT INTO wbi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Une nikuvofugha na malenga, neke umwene ikuvofughagha nu Mhepo u Mwimike.” ");
INSERT INTO wbi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lulya humile mufighono ifio ulwakuuti u Yesu Kilisite alisile kuhuma ku Nazaret ija ku Galilaya, akaluka kwa Yohanani na kukwofugua nu mwene mukikogha ikya Yolidani. ");
INSERT INTO wbi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ye ofughue unsiki ghughuo akahuma mumalenga, akavona uvulanga vudinduka, na ju Mhepo hwene ng'hunda akiika pa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pe ilisio likahuma kukyanya likati, “Uve veve mwanango mughanike. Nikukelile fijo uve.” ");
INSERT INTO wbi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kange nakalingi u Mhepo akamulongosia u Yesu kuluta kulihaka. ");
INSERT INTO wbi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akikalagha ifighono fijigho fine, agheluagha nu setano. Alyale nifikanhu ifnge ifya mulisoli, navanyamhola vakan'tangagha. ");
INSERT INTO wbi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","pa mbele u Yohani ye akolilue, u Yesu akalika ku galilaya ipulisia imhola inofu ija Nguluve, ");
INSERT INTO wbi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","akatisagha, “Unsiki ghwa ghufikile, kange uvu twa vwa Nguluve vulipipi. Mulataghe na kukwitika inyivi siinu mu livangili”. ");
INSERT INTO wbi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yeakilila mulubale mu lisumba lya Galilaya, akabona u Simoni nu ANdeleeya vitagha inyavu save mulisumba, ulwakuva valyale valovaji. ");
INSERT INTO wbi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","U Yesu akavavula, “Mwise, mumbingililaghe, nikuvavika kuva valovi va vaanhu.” ");
INSERT INTO wbi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Unsiki ghughuo vakasileka inyavu save vakam'bingilila. ");
INSERT INTO wbi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Unsiki u Yesu ye aghendile akasiki padabe, akam'bona u Yakobo mwawa ghwa Zebedayo nhu Yohani vanyalukolo vake; valyale mu ngalava vitenda inyavu. ");
INSERT INTO wbi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Voope akavakemela vakamuleka uvise ghwave u Sebedayi mun'akte mu ngalava palikimo navavombi vaake, vakam'bingilila. ");
INSERT INTO wbi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ye vafikile ku Kapelaumu, ikighono kya Sabati, vakingila mu sinagogi na kuvulanisia. ");
INSERT INTO wbi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vakadegha imbulanisio ja mwene, ulwakuva alyale ivulanisia hwene muunhu nya vutavulilua nakavulanisiagha ndavule avalembi. ");
INSERT INTO wbi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Unsinki ghughuo umuunhu alyale mu sinagogi jivanave alyale nilipepo ililamafu, akakoola, ");
INSERT INTO wbi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akati, “Tulini kikibikya kuvomba nuve, Yesu ghwa Nasaleti? Ghwisile kukututipula? Tukagule uliveni? Uve ulimwimike ghwemwene ghwa Nguluve!” ");
INSERT INTO wbi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","U Yesu akalihwetukila ili pepo ililamafu akati, “kimihe huma mun'kate mwamuunhu uju!” ");
INSERT INTO wbi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nili pepo ililamafu likamughwisia pasi na kuhuma mun'kate mwamwene unsiki ghuno akakolala kulisio ilivaha. ");
INSERT INTO wbi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Avaanhu vooni vakadegha, kange vakaposesania vene, “Senyiki isi? Isi se mbulanisio imia inyavutavulilua? Idagha amapepo ghope ghikunda!” ");
INSERT INTO wbi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Imhola sa Yesu sikakwila ng'hani ng'hani mukighavo kyoni ikya Galilaya. ");
INSERT INTO wbi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ng'haning'hani ye vahumile kunji mu sinagogi, vakingile mu nyumba ija Simoni nu ndeleeya Vyalyale u Yakobo nu Yohani. ");
INSERT INTO wbi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lino un'kwive ghwa Simoni alyaghonelile alyale n'tamu ghwa homa, ng'haning'ani vakam'bula u Yesu imhola sa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ye afikile, akan'kolo nuluvoko, akamwinula, ihoma jikabuka kwa mwene, akategula kukuvatengelela. ");
INSERT INTO wbi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","vwilile unsiki ilijuva ye lisemile, vakamuletela avatamu vooni vano valyale vivavua, na vanya mapepo. ");
INSERT INTO wbi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ilikaja lyoni valyakong'anile palikimo pa mulyango. ");
INSERT INTO wbi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Alya vasosisie vinga vano valyale ninamu avanyanamu sino sili papinga na pidagha amapepo minga, looli nakaghalekelagha amapepo ghajove ulwakuva ghalya manyile. ");
INSERT INTO wbi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Alyasimuike kujighe kuhenga, unsiki ghuno ghukakyale kuhenga; akaluta pamonga pasyefu pe akifunya kukuo. ");
INSERT INTO wbi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","U Simoni navanine vakatengula kuku mulonda. ");
INSERT INTO wbi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ye vamwaghile vakam'bula vakati, “Avaanhu vooni vikukulonda” ");
INSERT INTO wbi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Akavamula akati, “Tuvuke kufisina ifinge, mu fikaja fino fisyunguta, kwope nipilisie kange. Ulwakuva lwelino nisile apa.” ");
INSERT INTO wbi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Akaluta imbale sooni isa mukighavo ikya Galilaya, ipilisia mu masinagogi na kudaga amapepo. ");
INSERT INTO wbi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Unyabuba jumonga akisa kwa mwene. Akampelepesia; akafughama akati, “Nave ukelile kukumbalasia, nisuma umbalasie. ");
INSERT INTO wbi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Vwimila vwa lusungu, u Yesu akagholosia uluvoko lwamwene aka mwabasia, akati, “Nikeela, Uvalale.” ");
INSERT INTO wbi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Unsiki ghughuo ibuba jikabuka mu m'bili ghwake, pe akavalasivua. ");
INSERT INTO wbi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","U Yesu akan'kaana akaati lutagha ng'hani ng'hani, ");
INSERT INTO wbi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Akam'bula akaati, “Nungam'bulaghe nambe muunhu imola isi, ulwene ulute ghuhufie kwa n'tekesi, uhumie ilitekelo ndavule alyalaghile u Moose, vuve vwolesi kuvanave.” ");
INSERT INTO wbi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Looli akaluta na pikum'bula kila muunhu na pipulisia ilisio kukila u Yesu lukampela u Yesu kukunua kukwingila mu makaja pa vuvalafu. Akavisagha kunji ku makaja kuvusyefu kuvusila vaanhu kwope ukuo avaanhu ifipugha fyooni kuhuma imbale soni vakalutagha kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ye agomuike ku Kaperinaumu ye fikilile ifighono fidebe, lukapulikika kuuti alyale kukaja. ");
INSERT INTO wbi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Avaanhu viinga vakakong'hana pala napapakava apakukila kange, najila jino jilyale pa mulyango u Yesuvakajova ilisio kuvanave. ");
INSERT INTO wbi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kange avaanhubvamo valisile kwa mwene vano vamuletile umuunhu unya liteela; avaanhu vane vampindile. ");
INSERT INTO wbi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Unsiki yevakunilue kukuntwala vwila vwa lipugha lya vaanhu, pe vakatuvula vakantosia kukyanya ku dari ye vatuvuile, vakikisia ikitanda kino umuunhu untamu juno liteela alakighonile. ");
INSERT INTO wbi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ya aluvwene ulwitiko lwave, u Yesu akati kwa ntamu, “Mwanango, upyanilue inyivi saako.” ");
INSERT INTO wbi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Looli mu valembi vamo vano vakikalile pala vakiposiagha munumbula saave, ");
INSERT INTO wbi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Anoghile ndani kujova anala? Ipyanila! Ghwe veeni kupyanila inyivi nakwale ujunge kukila u Nguluve mwene?” ");
INSERT INTO wbi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kange u Yesu akakagula mu numbula sa mwene kino akale isagha muvamo va vanave. Akavavula, “Nakiki musagha mu numbula sinu? ");
INSERT INTO wbi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Luhugu luliku kukum'buula unya liteela, upyanilue inyivi sako' nambe kuuti, 'Ima, veghala ikitanda kyako, ulutaghe?' ");
INSERT INTO wbi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lino mukagule kuuti umwana ghwa Adamu alinuvutavulilua uvwa kupyanila inyivi mu iisi, pe alwa m'bulile unya liteela jula, ");
INSERT INTO wbi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nikukuvula juve, ima, tola ilitefu lyako, vujagha.” ");
INSERT INTO wbi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Unsiki ghughuo akima akaveghala ilitefu lyake akavuka ivuja avaanhu vano pevalyale vaka degha kyongo, kange vakamughiniagha u Nguluve, vakaati “isi se natusivwene lusiku.” ");
INSERT INTO wbi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Akaluta kange mulubale mulisumbe, ilipugha lya vaanhu likalutagha kwa mwene, pe akavavulanisiagha. ");
INSERT INTO wbi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ye ighenfa akamwagha u lawi nswambe ghwa Alfayo ikalile pano isongekesia isongo akambula akati “Um'bingililaghe.” Akima na pikum'bingilila ");
INSERT INTO wbi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pambele u Yesu ye vilavuka ikyakulia munyuma ja lawi, avasongesia songo vinga na vahosi valikalile vivanga nu Yesu palikimo navavulanisivua vake, ulwakuva valyale vinga voope vakam'bingilila. ");
INSERT INTO wbi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Unsiki avalembi, vano valyale Vafalisayo, yevamwaghile u Yesu ihanga navaaanhuvava nyanyivi nava songesia songo, vaka vavula ava vulanisivua vake vakaati, “Nakiki ihanga nava songesia songo na vaanhu ava nyanyivi?” ");
INSERT INTO wbi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","U Yesu ye apulike akavavula akati, “Avaanhu avanya vwumi mum'bili navufumbua kuluta kwa mughanga; looli avatamu vevano va mfumbilue. Nanilyakisisie kukuvakemela vano vikuvona vagholofu, looli vano vitang'hinie kuuva vahosi.” ");
INSERT INTO wbi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Avavulanisivua va Yohani nAva Farisayo valyale nu lwiho ulwa kuvuhila kulia. Pe avaanhu vamonga vakisagha kwa mwene ni pikum'buula, “Kiki avavulanisivua vaako navivingilila ulwiho ulwa kuvuhila kulia, ndavule avavulanisivua va Yohan nava Farisayo? ");
INSERT INTO wbi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","U Yesu akavamula, vano vaghongolilue pavutolani vulu vali nu n'tola n'dala navangavuhile kulia mu lwakufunya? Pa uluo nave untola n'dala alipalikimo numue namughanilue kubuhila kulia.” ");
INSERT INTO wbi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Looli filiva fikisa ifighono fino untolan'dala ilivusivua, apuo pepano vilivuhila kulia mulwa kufunya. ");
INSERT INTO wbi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nakwale umuunhu juno ihona ikigamba ikipia mu mwenda unkuulu, nave avombe uluo ikigamba kilekeng'ana nu mwenda, ikipia kibanduka mukikuulu, pe uvudemule vukwongelela kyongo. ");
INSERT INTO wbi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nakwale umuunhu juno ivika uluhuje ulupia mu nyambe ing'huulu, nave fye vavombe uluo, uluhuje lupusula inyambe kange fyoni fivili uluhuje ni nyambe visova. Looli vika uluhuje ulupia mu nyambe imia.” ");
INSERT INTO wbi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mukighonobikya sabati uyesu alyakilile mumaghunga ghamo, navavulanisivua vamo vakatolagha amasoje gha ngano. ");
INSERT INTO wbi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Avafalisayo vakam'bulagha, “Lolagha, kiki vivomba lunonalunoghile mundaghilo isa mukighono ikyabSabati?” ");
INSERT INTO wbi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Akavamula, “Namwembila ndavule u Daudi vule alyavombile ye alimuvunoghelua vwa njala__umwene palikimo na vaanhu vano alyale navope? ");
INSERT INTO wbi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ndavule alyalutile mu nyumba ija Nguluve unsiki ghuno u Abiathari alyale n'tekesi m'baha akalia unkate ghuno ghulyale pavulongolo__ ghuno naghukanoghile mundaghilo sa muunhu ghweni kuli ulwene vatekesi vene__kange akavapela vaamo vano valyale palikimo nu mwene?” ");
INSERT INTO wbi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","U Yesu akajova, “isabati jivikilue kuku n'tanga umuunhu, jeeje umuunhu kuva n'kami ghwa Sabati. ");
INSERT INTO wbi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kwekuuti, Mwana ghwa Adamu ghwe Mutwa, naku sabati.” ");
INSERT INTO wbi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kange akingila munkate mu sinagogi mula mwe alyale umuunhu juno uluvoko lulyafwile. ");
INSERT INTO wbi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mwevalyale vamo valyale vikumwuvila kuuti nave kya ikunsosia umuunhu jula mu kighino kya Sabati vantwale pa vuhighi. ");
INSERT INTO wbi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","U Yesu akam'bula unyaluvoko luno lufwile akati, “Ima pakate palipugha ili.” ");
INSERT INTO wbi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pe akavavula avaanhu, “Asi, luliku luno lunoghile mukighono ikya Sabatinambe ku vomba imbivim; kupoka u vwumi nambe ku buda?” Looli navakamula kimonga. ");
INSERT INTO wbi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Akavalola ni ng'halasi, akasukunala vwimila vwa vusiiki vwa numbula save, kange akam'buula umuunhu jula, “Gholosia uluvoko lwako” Akagholosia u Yesu akansosia uluvoko lwa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ava Farisayo vakahuma kunji pe vakava vipiling'ana nhu Herode vule kya vikum'buda. ");
INSERT INTO wbi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pe u Yesu, navavulanisivua vaake, vakaluta ku lisumbe, nililigha ilivaha ilya vaanhu vukam'bingilila kuhuma ku Yerusalemu na kuvuyahudi ");
INSERT INTO wbi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kuhuma ku Yerusalemu na kuhuma ku Idumaya na kuvulongolo ku Yorodani na kumbale isa ku Tiro ni Sidoni, ilipugja likome, pono alyapulika ifiinu fyooni fino alya ivomba, valisile kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pe akavavula avavulanisivua vaake kuuti vaveghelesie ingalava indebe vwimila vwa mwene lwakuuti ilipugha lya vaanhu, ulwakuuti navangampitaghe. ");
INSERT INTO wbi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ulwakuva alya sosisie vinga, ulwakuuti umuunhu ghweni unya mumuko alyale nuvunoghelua vwa kum'bona neke amwabasie. ");
INSERT INTO wbi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","pooni imhepo indamafu pano vakamwaghagha, vakaghwisaka pasi na pilila pamaghulu gha mwene, vakatisagha, “uve uli Mwana ghwa Nguluve”. ");
INSERT INTO wbi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Akaghadalikilagha kuuti naghangampulisiaghe akagulike. ");
INSERT INTO wbi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Akatogha pakyanya pa kidunda, akavakemela vano alighanile, vakaluta kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Akavasalula kijigho na vavili (akavatambula vasung'ua), ulwakuuti vave palikimo nu mwene alwakuti avomole kupulisia, ");
INSERT INTO wbi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kuuti uvutavulilua uvwa kudaga amapepo. ");
INSERT INTO wbi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Akavasalula kange kijigho na vavili: U Simono juno akantambulagha Petro, ");
INSERT INTO wbi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","U Yakobo nswambe ghwa Zebedayo, nu Yohani nyalukolo ghwa Yakobo, alkapeelilue ilitavua lya Bonagesi, avuo ve, vaana va lugulumo, ");
INSERT INTO wbi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nu Ndeleeya, Filipo, Bartholomayo, Mathayo, tomaso Yakobo mwana ghwa Alfayo, Thadayo, SimoniMukananayo, ");
INSERT INTO wbi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nhu Yuda Iskariote, juno alya mwohiile. ");
INSERT INTO wbi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pe akaluta ku nyumba, nilipugha lya vaanhu vakisa palikimo kange, vakakunua nakulia u nkate. ");
INSERT INTO wbi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ikikolo kya mwene yevapulike imhola ijio, vakaluta kukun'kola, vakaati, “Ahasiling'ine uluhala” ");
INSERT INTO wbi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Voope avalembi vano valisile kuhuma ku Yerusalemu vakatisagha, “U Yesu ali nili pepo lywa Beelzebuli,” ilipepo ili lyelino likumpeela ingufu isakudaga amapepo”. ");
INSERT INTO wbi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Uyesu akavakemelile kwamwene nakujova navope kuhwanikisio, “ndaponi usetano idaghw kwa setano? ");
INSERT INTO wbi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nave uvutua vughavana vwene uvutwa uvuo navu ngime. ");
INSERT INTO wbi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nave inyumba jingaghaving'hane jeene, inyumba ijio najivwesia jiime. ");
INSERT INTO wbi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nave usetano angagalung'hane mwene na kughavinga'ana, nangavwesie kukwima, iva afikile kuvusililo vwake. ");
INSERT INTO wbi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Looli nakwale nambe umuunhughweni nangingile munyumba ja muunhu unyangufu kughoma ifiini fyake looli tasi ankunge unyanyumba, neke aghome ifiinu fyake fyooni. ");
INSERT INTO wbi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kyang'haani ni kuvavula, inyivi sooni isa vaanha va vaanhu nalavasaghila, namaligho ghave ghoni, ");
INSERT INTO wbi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","looli umuunhu juno ikumuligha u Mhepo u Mwimike ujuo u Nguluve nalansaghila lusiku, ujuo iiva nu nkole ughwa kuvusila kusila”. ");
INSERT INTO wbi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","U Yesu akajova ilio ulwakuva akatile, “Alinilipepo ililamafu”. ");
INSERT INTO wbi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kange u ng'ina navanyalukolo va mwene vakisa na vakiima panji. Vakansung'haa umuunhu, kuku nkemela. ");
INSERT INTO wbi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nikipugha kya vaanhu vano vakikalile pipi naghwope vakam'buula, “umama ghwako navanunavo valipanji, vikukulonda uve”. ");
INSERT INTO wbi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Akavamula akati, “Umama navanuna vaango ve vaveeni?” ");
INSERT INTO wbi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Akavasyetukila avaanhu vooni vano valikalile vakansungutile, akaati, “Lolagha ava ghwe mama navanuna vaango! ");
INSERT INTO wbi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Umuunhu ghweni juno ivomba isa vughane vwa Nguluve, umuunhu ujuo ghwe nuna kange kwe lumbu ghwango ghwango, nu mama ghwango”. ");
INSERT INTO wbi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kange alya tengula ku vulanisia mulubale palubale pa lisumbe. Nilipugha ilivaha likakong'ana pikunsungutila umwene, akalamula pikwingila mu ngalama na akikala. ilipugha lyoni likava mulubale kunji mulisumbe. ");
INSERT INTO wbi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pe akavavulanisia sinyinga mufuhwanikisio, pe akajova kuvanave ni mbulansio sake. ");
INSERT INTO wbi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Pulikisia, unkesambeju alyalutile kukesa imbeju. ");
INSERT INTO wbi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ye ikesa imbeju jimonga jikaghua musila, injuni sikisa sikahola. Ijinge jikaghua palinalavue, pano ilihanga lilyale lidebe. ");
INSERT INTO wbi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nakalingi sikuuma, ulwakuva nasilyale palihanga ilyakukwilana. ");
INSERT INTO wbi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Looli ilijuva lika nyaanya, jikuuma, ulwakuva nasilyale ni ndela, sikuuma. Ijinge jikaghua pa malela gha madasia. ");
INSERT INTO wbi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Neke amadasia yeghalembile ghaka fweta, sikakunua kukoma ifipeke vunufu ");
INSERT INTO wbi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ijinge jikaghua pa lihanga ilinofu jikamela nakukoma vunono, jimo ifijigho fitatu, ijinge fijigho ntanda, ijinge kilundo”. ");
INSERT INTO wbi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pe akati, “Unyakupulika, apulike!” ");
INSERT INTO wbi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","U Yesu unsiki ghuno akale mwene, vala vano valyale pipi na vala kijigho na vavili vakamposia kufihwanikisio. ");
INSERT INTO wbi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akavamula muvanave, “Mupelilue isa vusyefu uvwa vutwa vwa Nguluve. Neke vano valikunji ifinu fyoni fihwanikisio, ");
INSERT INTO wbi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","neke vangalole, ena vilola, loli navangalole, kupulika vipulike neke navangasitang'anie, looli vasasyetuka nu Ngulu ngale avasaghile.” ");
INSERT INTO wbi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pe akajova muvanave, “Namukukitang'ania ikihwanikisio iki? Pe kyamukufitang'ania ndani ifihwanikiso ifinga? ");
INSERT INTO wbi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Unkesambeju akesa ilisio. ");
INSERT INTO wbi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vamonga vevano vaghwile mulubale mu sila, pano ilisio likesilue. Pano valyapulike, nakalinge usetano akisa na pivusia ilisi lino likale mu moojo ghave. ");
INSERT INTO wbi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vamonga vevala vano vakakesilue pakyanya pa linalavue, vano, vikulipulika ilisio, vikulyupila ng'aning'ani nulukelo. ");
INSERT INTO wbi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Vasila ndela sesoni mu mojo ghava, looli valyale nu lugudo ludebe. Looli inalaamu ni mumuko pano fikwisa vwimila vwa lisio, unsiki ghughuo vikuvala. ");
INSERT INTO wbi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Avange vevala vano vakakesilue mumifui. vikulipulika ilisio, ");
INSERT INTO wbi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","neke imumuko sa mu iisi, uvuyasu vwimila vwa kyuma, nuvunoghelua vwa mbombo isinge, fikuvingila pe fifweta ilisio, pelikunua ku koma imeke. ");
INSERT INTO wbi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Looli vano vavyalilue mulihanga ili nofu. vikulipuluka ilisio na kukulyupila neke vikoma ifipeke: jumo ifipeke fijigho fitatu ujunge fijigho ntanda, ujunge kilindo kimo.” ");
INSERT INTO wbi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","U Yesu akavavula, “Ulumuli luletua munkate mu nyumba na pikulubika pa ndilo, nambe pasi pa fungo? Jeeje luvikua pa kimilo. ");
INSERT INTO wbi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ulwakuva nakwekile kyekyoni kino kifisime kino nakilikagulika, sope isa vusyefu silivikua pa vwelefu. ");
INSERT INTO wbi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Unya kupulika apilike!” ");
INSERT INTO wbi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akavavula, “muve maaso kukino mukukipulika, ulwakuva ikipimo kino mipimila, kyekino milipimivua, kange kilikwongelele kulyumue. ");
INSERT INTO wbi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ulwakuva umwene juno alinakyope, ilikyupila kukila, jula juno nsila, kuhuma kwa mwene ilipokua nambe fila fini alinafyope.” ");
INSERT INTO wbi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pe akajova, “Uvutwa vwa Nguluve vulindavule ikihwaanikisio kya muunhu unkesa mbeju mumughunda. ");
INSERT INTO wbi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Umwene akaghona na kusisimuka, imbeju jika lemba nakukula, kisila kukagula muno jimelela. ");
INSERT INTO wbi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Iisi jihumia jijio; ghitala amatundu, neke amasoje, kange imeke sino selile. ");
INSERT INTO wbi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Unsiki ghuno imbeju jiva jelile itwalagha uvumego, ulwakuva unsiki ghwa kubena ghufikile.” ");
INSERT INTO wbi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pe akajova, “tu hwananie uvutwa vwa Nguluve ni kinu kinge, nambe utumile ikihwani ikinge ku kwolelela? ");
INSERT INTO wbi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Vuhwani vwa mbeju indebe kukila soni, nambe pano jilya vyalilue jilyale ndebe kyongo kukila imbeju soni mu iisi. ");
INSERT INTO wbi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nambe, unsiki ghuno jikavyalilue, jimela na kukula ghuva mela nkope kukila amamele ghoni agha mubusitani, inhaafi saake siva mbaha, nasinjuni sa kuvulanga sitendagha ifivwasu mumuo. ");
INSERT INTO wbi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Akavavulanisiagha avaanhu ilisio lyake mufihwanikisio finga na kujova mu vanave, kavavulanisiagha ndavule vanoghile kujova, ");
INSERT INTO wbi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","na akalovagha kimonga kisila kuhwanikisio. Looli unsiki ghuno lyale mwne, akavaghanulilagha sooni avavulanisivua vaake. ");
INSERT INTO wbi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mufighono ifio, ye jifikile ivwilile, akajova muvanave, “Tulovoke imwambo jila”. ");
INSERT INTO wbi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pa uluo vakalileka ilipugha, vakantola u Yesu, unsiki ughuo ye alimunkate mungalava. Ingalava isinge silyale palikimo nu mwene. ");
INSERT INTO wbi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Imhepo inyangufu jikaguguma na mavingo ghakavingilagha munkate mu ngalava ingalava wejilya memile. ");
INSERT INTO wbi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Looli u Yesu alyale mu shtri, alyaghonile pa kisaghu. Vakansisimula, vakati, “Ghwe m'bulaniisi, uve kulyuve ghuvona na kiinu usue pano tufua?” ");
INSERT INTO wbi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pe akasimuka akajidalikila imhepo na pikujivula inyanja, '“Litama, ulughano”. Imhepo jikalitama, kukava mye. ");
INSERT INTO wbi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Akaajova muveene, “Lwakiki muli voghofi?” ");
INSERT INTO wbi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Valya memile uludwesi luvaha, vakajovesania, vakati, “Uju ghwe veeni, juno imhepo namavingo fikumpulika?”. ");
INSERT INTO wbi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Vakafika umwamboijinge ija lisumbe, mulikaja lya Gerasi ");
INSERT INTO wbi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nakalingi u Yesu ye ihuma mu ngalama, akisa kwa mwene umuunhu jumonga unyalipepo lilamafu akahumile ku mbiipa. ");
INSERT INTO wbi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","U muumhu uu akikalagha ku mbiipa. Nakwalyale uwakunkola nabe kukundindila, nambe kukunkunga ni minyololo. ");
INSERT INTO wbi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","kekinga akapinywagha ni pingu na manyololo. akadumulagha amanyololo ni pingu akadenyagha. Nakwaliyale unyangufu ghwa kumulefia. ");
INSERT INTO wbi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pakilo na pamwisi akikalagha ku mbiipa na kufidunda, akakolagha na kukutemateme namavue amajodofu. ");
INSERT INTO wbi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ye am'bwene u Yesu pavutaali, akankimbilila na kufughama pa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Akakola ni lisio ilivaha, “Lunoghile nivombe kiki, Yesu, Mwana ghwa Nguluve juno alikukyanya fijo? Nikukusuma mulitavua lya Nguluve, uleke pikumumusia.” ");
INSERT INTO wbi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ulwakuva yumbulile, “Ghwe lipepo lichafu uve, huma mwa muunhu uju.” ");
INSERT INTO wbi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Gwoope akamposia akati, “Ilitavua lyako veeve veeni?” Ghwope akamwamula, “Ilitavua lyango nene Ligioni, ul. wakuva tuliviinga.” ");
INSERT INTO wbi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Akampelepesia kange leka pikughadaga mu iisi jila. ");
INSERT INTO wbi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ilipugha ilivaha ilya ngube lilyale pakyana pakidunda silyale sidimua, ");
INSERT INTO wbi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ghoope ghokampelepesia, sikati, “Utusung'e mu ngube, mwetwingile munkate mu sene.” ");
INSERT INTO wbi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Akaghatavula; amapepo amalamafu ghakahuma mwa muunhu na pikwingila mu ngube, sope sikakimbilila pasi pa kidunda na pikwingila mulisumbe, neke ilipugha lya ngube imbilima ivili sikadwivila mulisumbe ");
INSERT INTO wbi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Navadima ngube vakakimbila vakaluta mulikaja na mufikaja kuhumia imhola kusino sihumile na pivombeka mu likaja na mukisina. Pepano avaanhu vinga vakahuma kuta kulola kino kikahumile. ");
INSERT INTO wbi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pepano vakisa kwa Yesu pe vakamwagha umuunhun juno ahasiling'ine na mapepo__alyale nu nsikali__ikalile pasi, afwasivue, ali nuluhala lunofu, voope va koghopa. ");
INSERT INTO wbi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vala vano vakasivwene sino sivombike kwa muunhu juno alyahassiling'ine na mapepo vakakimbila kino kikahumile kwa mwene kange vwimila ingube. ");
INSERT INTO wbi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Voope vakampelepesia kuuti avuuke mu iisi jave. ");
INSERT INTO wbi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","U Yesu ye ikwingila mu ngalava, umuunhu juno alyahasiling'ine na mapepo akampelepesiaa kuuti alutaghe palikimo nu mwene. ");
INSERT INTO wbi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","U Yesu akankana, akati, “Lutagha kukaja na kuva nyalukolo vako, uvavule akuvombile u Mtwa, nulusungu luno akupelile.” ");
INSERT INTO wbi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pepano akavuka na kuluta kupulisia imbaha sino am'bombili u Yesu mu Dekapoli, imhola isio sikava kidegho ku vooni ");
INSERT INTO wbi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pano u Yesu alyalovwike kange imwambo ijinge, mu ngalava, ilipugha ilivaha lika kong'ana kukunsungutila, pano alyale mulubale mulisumbe. ");
INSERT INTO wbi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Umbaha jumo ughwa va sinagogi, akatambuluagha Yairo, akisa, ye amwaghile, akaghua pa maghulu gha mwene. ");
INSERT INTO wbi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akampelepesia fijo kange fijo, akati, “Mwalivango n'debe ghukova pifua. Nikusuma ghwise uvike uluvoko lwako pakyanya pa mwne ulwakuuti usoke akupele uvwumi ughendelele pikukala.” ");
INSERT INTO wbi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Apunakavuka palikimo nu mwene, nalilipugha ilivaha lika m'bingililaa vaka mpitagha kukunsungutila. ");
INSERT INTO wbi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pwe alyale umumama jumonga juno alyale ihuma idanda inaaaamu ijio jilya mpumwisia amaka kijigho na gha viili. ");
INSERT INTO wbi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Alya pumuike yongo kuva ghanga vinga alya vombiile ikyuma kyoni kino alyale nakyo. Neke nalyasokile nambe padebe, looli inamu jikava jifikwongelela. ");
INSERT INTO wbi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Akapulika imola isa Yesu. Pe akatengula kukwisa kughenda mumbele muno mwa mwene pano alyale ighenda pakate palipugha. ghwope akagusa umwenda ghwa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","wakuva akajovile, Nane ninga guse ghamenda ghake ni soka, niva mwumi.” ");
INSERT INTO wbi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ye agusile, idanda jikabuhilapihuma, akivoona mumbili ghwake asokile kuhuma munamu jila. ");
INSERT INTO wbi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Unsiki ghughuo u Yesu akivona mu m'bili ghwake sihumile ingufu. Akyasyetuka imbale soni mulipugha pe akaposia, “Ghwe veeni juno abasisie u mwenda ghwango?” ");
INSERT INTO wbi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Avavulanisivua vaake vaka mwamula, “Ulivwene ilipugha ilili likikupita lisyungutile, najuve ghuti, ghweveeni juno ikukwabasia? ");
INSERT INTO wbi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Looli u Yesu akava ifilolesia ulwakuuti ankagule juno amwabasisie. ");
INSERT INTO wbi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Umukijuuva, akakagula lunoluhumile kwa mwene, akoghopa na pihilila. Akalukagula pe akaghua pasi pamwene akolelela sooni sino sivombike. ");
INSERT INTO wbi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Akajova kwa mwene, “Mwalivango usokile vwimila ulwitiko lwako. Ulutaghe nulutangano inamu jako jisoke lwoni ");
INSERT INTO wbi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pano alyale ijova, valisile avaanhu vamo kuhuma kwa ngoyo wa Sinagogi, vakaati, “Umwalivo afuile. Kiki ghuku n'gasia um'bulanisi?” ");
INSERT INTO wbi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Looli u Yesu ye akipulike kino valyajovile, akambula um'baha ghwa sinagogi, “Uloghopagha. Itikagha.” ");
INSERT INTO wbi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Akavakana vooni kulutania naghwope, looli akantoola u Petro, Yakobo, nu Yohana navanyalukolo va Yakobo. ");
INSERT INTO wbi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Vakisilepakaja pa m'baha ghwa va sinagogi ghwope akalivona ili batu, kukola na kulila. ");
INSERT INTO wbi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ye ingile mu nyuma, akavaposia akati, “Kiki musukunile kange kiki mulila? Umwana nahwile looli ighona.” ");
INSERT INTO wbi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Vakanseka, looli umwene akavahumia vooni kunji, akavatola ava pafi nava vulanisivua vala, kingila munkaate muno mwealyale u mwana. ");
INSERT INTO wbi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akankola uluvoko lwa mwana akati, “Talitha koum,” kwekuuti, “Ggwe minja uve nikukuvula, simuka.” ");
INSERT INTO wbi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Unsiki ghughuo umwana jula akasimuka na na pighenda (ulwakuva alyale na maka kijigho na ghaviili). nakalinga vakakoluo ni nganighani na nuludegho luvaha. ");
INSERT INTO wbi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Akavakana ku ngufu kuuti nalunoghile umuunhu ghweni akagule imbombo jino jivombika apa. Akavavuula kuuti vampele uminja jula ikyakulia. ");
INSERT INTO wbi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pe akabuka apuo kuluta mulikaja lya mwene, na vavulanisivua va mwene vaka mbingilila. ");
INSERT INTO wbi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Isabati ye jifikile, akatengula kuvulanisi mu sinagogi. Avaanhu vinga vakampulikisia na pidegha. vakati, “Atolile kughi imbulnisio isi?” Vukagusi vui vuno apelilue?” kange fidegho fiki fino fivombeka mu ngufu saake?” ");
INSERT INTO wbi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Uju naghwe mpulula mbavo, mwana ghwa Mariamu nyalukolo ghuva Yakobo, Yose, Yuda nu Simoni? Nava lumbu nave vuno tukukala palilikimo nusue?” Navakakelile nu Yesu. ");
INSERT INTO wbi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","U Yesu akavavula, “Um'biili naikosa uvwoghopua, ulwene naikwoghopua mulikaja lyake na vanyaluolo vamo avamunyumba ja mwene.” ");
INSERT INTO wbi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naakavomba nambe kidegho kimonga apuo, looli akavabiikila amavoko avatamu vadebe akavasosia. ");
INSERT INTO wbi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akadegha kyongo ulwakuva navalyamwitike. kange pe akaghendela ifikaja ifya pavupipi kuvulanisia ");
INSERT INTO wbi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akavakemela avavulanisivua vala kijigjo navaviili akatengula piku vomhola vavili vavili. Akavapela uvu tavulilua vwa kudaga amapepo imilamafu, ");
INSERT INTO wbi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","akavavula ulwakuti navala tolaagha kyakwoni pano viluta ulwene lulukongoja lwene. Navangagadaghe unkate, nambe inyambe, nambe indalama; ");
INSERT INTO wbi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","looli mufwalaghe ifilato, ulwene mulafwalagha isopeka iviili. ");
INSERT INTO wbi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kange akavavula, “Inyumba jejoni jino kwande mukwingila, mukalaghemumuo kuhanga pano muvuka mulikaja ilio. ");
INSERT INTO wbi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kange ilikaja lino navikuvupilila nambe kukuvapulikisia, muhumaghe muvanave, mukung'unaghe ulung'unde mumaghulu ghinu, kive kivalilo muvanave ");
INSERT INTO wbi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","vakavuuka viluta vipulisia valate na kukusileka inyivi save. ");
INSERT INTO wbi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","vakadagha amapepo minga, kanke vakaghapakagha avatamu amafuta vakasoka. ");
INSERT INTO wbi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Utwa u Herode ye aghapulike aghuo, ulwakuva ilitavua lya Yesu lika kagulike kyongo. Vamonga vakatisagha, “U Yohano umwofughua asyukile kuhuma kuvafue vwimila vwa ilio, iji ngufu ja fidegho ivombela imbombo munkate mwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Avaange vakatisagha, “Uju ghee Eliya,” Kange avange vakatisagha, “Uju ghwe m'bili, ndavule ava viili vamo ava pakale.” ");
INSERT INTO wbi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ne uHerode ye apuluke agha akati, “U Yohana, juno nilya n'dumwile umutu asyukile.” ");
INSERT INTO wbi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ulwakuva u Herode jujuo akalaghile kuuti u Yohana akolue na kukun'dindila mu ndinde vwimila uHerode (un'dala ghwa nuna Filipo) vwimila umwene ulwakuti alya n'tolile. ");
INSERT INTO wbi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ulwakuva u Yohani alya m'bulile u Herode, “Nalunoghile mundaghilo kun'tola un'dala ghwa nunavo.” ");
INSERT INTO wbi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Peoano uHerode akan'kalalilagha na kumwuvila ulwakuti am'bude, neke akakunuagha, ");
INSERT INTO wbi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ulwakuva uHerodr akamwoghopagha uYohani; alyalutang'inie kuuti muunhu mugholofu kange mwimike, pe akamuleka pavutavike. Kange akavisagha nulukelo lwa kumpulikisia akasukunalagha fijo, looli alyan'kelile kuku mpulikisia. ");
INSERT INTO wbi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ye kifikile ikighono ikya kikuluklu ikya kukumbuka kuholua uHerode akavaling'ania avavaha va vasikari va mwene ululilo, navasikali na vatambulike avange ava Galilaya. ");
INSERT INTO wbi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pepano umwalivo ghwa Herodia akingila na seeja pavulongolo pa veene, akamhovosia uHelode navaghesi vano valikalile unsiki ughwa kyakulia kya pakivwilile. Pe pano untwa u Herode akam'bula uminja jula, “Suma kino ghulonda nikukupele.” ");
INSERT INTO wbi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akajiigha akati, kyokyoni kino ghukunisuma, nikukupela, nambe vuve vwe vutwa vwango.” ");
INSERT INTO wbi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Akahuma kunji kukumposia ung'ina, “Nisuume kiki?” akati, “Umutu ghwa Yohani u mwofughua.” ");
INSERT INTO wbi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Akingila ng'aning'ani mwa ntwa akatengula kusuuma, “Nilonda umele mulisinia, umutu ghwa Yohani u mwofughua.” ");
INSERT INTO wbi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Untwa akasukunala kyongo, looli ulwakuva akijighile na kuvahesisia, vakakunua pikun'kana kino asumile. ");
INSERT INTO wbi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pepano, untwa akansung'a avasikari vamo muvaloleli va mwene kuuti vakamuletele umutu ghwa Yohani. Unsikari akaluta kun'dumula umutu ye alimundinde. ");
INSERT INTO wbi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akaleta umutu ghwa mwene mulisinia na pikumpela uminja, uminja uakampela ung'ina. ");
INSERT INTO wbi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Navavulanisivua va mwene ye vapulike isio, vakaluta kutoola umbili vakaghuviika mu mbipa ");
INSERT INTO wbi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ava sung'hua, vakakong'ana palikimo pavulongolo pa Yesu, vakamwolele soni sino vakavombile nisino vakavulanisie. ");
INSERT INTO wbi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ghwope akavavula mwise mwevanya kyuma kuvusyefu tu puume padebe.” Avaanhu viinga vakisagha na pibuka, vakakuunua piva nunsiki ughwa kulia. ");
INSERT INTO wbi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pe vakapanda ingalava kuluta kuvusyefu veene. ");
INSERT INTO wbi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Looli ye vivuuka avaanhu vinga vakavagha, vakaluta luvilo palikimo kuhuma mumalenga, pe vakatala aveene kufika. ");
INSERT INTO wbi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yevafikile mulubale mu lisumbe, akalivona ilipugha lya vaanhu akavavonela ikisa, ulwakuva valyahwene ng'olo isila n'diimi. Pe akatengula pikuvavulanisia si nyinga. ");
INSERT INTO wbi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Unsiki ye kuseghelile fijo, avavulanisivua vakamwisila vakam'bula, “Apa pe pasyefu unsiki ghulutile. ");
INSERT INTO wbi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Utavule valutaghe mu fikaja fino fili pipi valutaghe vakaghule ifyakulia.” ");
INSERT INTO wbi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Looli aka vamula akati, “Muvapele umue ikya kulia. Vakam'bula, “Ndeponu tuluta kukava amakate aghanya lutalama lwa dinali filundo fivili na pikuvapela valie?” ");
INSERT INTO wbi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Akavavula,” Muli namakate ghalingi? Lutagha mukalolae.” ye vakavile vakam'buula, “Tuli namakate ghahano ni samaki ivili.” ");
INSERT INTO wbi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","akavatavula avaanhu vikale fighavo fighavo palisoli ilyololo. ");
INSERT INTO wbi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Vakavakasia fighavo fighavo; fimonga avaanhu kilundo, ifingi fijigho fihano. ");
INSERT INTO wbi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pe akatoola amakate ghahano ni samaki ivili, akalola ku kyanya, akahongesia pe akavapeela avavulanisivua vabike pavulongolo pa lipugha. Kange nasisamaki ivili akaghavania kuvaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Vooni vakalia vakikuta napigombolela. ");
INSERT INTO wbi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Vakakong'ania ifisighasi fya makate ni samaki, fikamema indilo kijigho na fivili, kange na fifisighasi fya samaki. ");
INSERT INTO wbi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Avaki nhaata valyale imbilima ihano vano valyalile amakate. ");
INSERT INTO wbi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kange akavalaghila vapande ingalava valute imwambo ijingi, ku Bethsaida, pono umwene ihwesia ilipugha. ");
INSERT INTO wbi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yevavukile, akaluta kukidunda kukufunya. ");
INSERT INTO wbi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ye vwilile, ni ngalava save silyale pakate pa nyanja, ghwope alyale mwene kufidunda. ");
INSERT INTO wbi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Akavagha pano vitata kughendasia ingalava ulwakuva imhepo jikavagomosiagha ku mbele. Ye kuta pihenga akavalutila, akaghenda pakyanya pa malenga, akalondagha pikuvakiling'hania. ");
INSERT INTO wbi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Looli ye vam'bwene ighenda pakyanya pa malenga, lukavingila uludwesi vakati lisyuka pe vakajeghela ni ngolo. ");
INSERT INTO wbi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ulwakuva valyamwaghile lukamema uludwesi. akavavula, “Muve kangala! nene! namungoghopaghe.” ");
INSERT INTO wbi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pe akingila mu ngalava, imhepo jika litama, vope vakandegha kyongo. ");
INSERT INTO wbi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ulwakuva navalyavutang'iniea uvufumbue uvwa makate. ulwakuva uluhala lave lulyale nuvwelefu vudebe. ");
INSERT INTO wbi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yevalovwike imwambo jingi, vakafika iisi ija Genesareti ingalava jikava pa vwimo. ");
INSERT INTO wbi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yevahumile kunji mu ngalava, pe vakan'kagula. ");
INSERT INTO wbi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Vakaluta ng'aning'ani kupulisia mu iisi jila jooni vakatangula kuvaleta avatamu mufitala, mwoni munovapulikagha kuti ikwisa ");
INSERT INTO wbi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","kwoni kuno akalutagha mufighavo, nambe mu makaja, nambe mu iisi, vakavavikagha avatamu pa lighulilo, vakampelepesiagha kuti avalekaghe avatamu vabasyaghe nambe ulu vilo lwa mwenda ghwake. Vooni vano vakabasyagha vakasoka. ");
INSERT INTO wbi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pambele, avafalisayi na vavulanisi va ndaghilo vamonga kuhuma ku Yelusalemu vakakong'haana pa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Vakavaagha avavulanisivua vamonga vilia na mavoko amalamafu, kwekuti kisila kwogha amavoko mu lwiho. ");
INSERT INTO wbi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ulwakuva aVyahudi vooni, kyongo aVafalisayi, nakalisagha kisila kwogha amavoko ndavule lwale lwiho lwa vakuulu vaave. ");
INSERT INTO wbi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kange umuunhu pano amumile ku lighulilo, naalyanoghiile kulia kisila kwogha amavoko. Nisingi nyinga sino valyupiile, ndavule isa kusuka ifikombe, ifivughaana ni fingi ");
INSERT INTO wbi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pepano aVafalisayi na vavulanisi va ndaghilo vakamposia uYesu vakati, “Kiki avavulanisivua vaako navivingilila inyiiho isa vakuulu viitu, pano vilia na mavoko amalamafu?” ");
INSERT INTO wbi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","UYesu akavamula, akati, “Umue mwe vakedusi! Unguluve kukilila um'bili uYesaya alyajovile se sene vwimila umue, ndavule lilembilue, 'Avaanhu ava vikungina'ia pa pa mulomo, neke amoojo ghaave ghali kutali nuune. ");
INSERT INTO wbi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Vikunyimika neke ulwimiko lwave lusila luvumbulilo, ulwakuva vivulanisia indaghilo isa Nguluve, neke mugadilila inyiiho isa vaanhu.” ");
INSERT INTO wbi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Sa kyang'haani, umue musilekile indaghilo isa Nguluve, neke mugadilila inyiiho isa vaanhu.” ");
INSERT INTO wbi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","UYesu akavavuula kange akati, “Umue muvona lunono kukusileka indaghilo sa Nguluve, neke muvingililaghe inyiiho siinu! ");
INSERT INTO wbi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ulwakuva uNguluve kukilila kwa Moose alyatiile, 'Umwoghopaghe uvaaso nu mamaajo, kanviise nambe un'ina kuge alyatiile, 'Umuunhu juno bikumuligha uviise nambe ung'ina anoghiile kubudua.' ");
INSERT INTO wbi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Neke ume muvulanisia kuuti, umuunhu ndepoonu ikum'buula uviise nambe ung'ina kuuti, 'Kino niveele ninoghiile kukutanga, nihumisie, litekelo kwa Nguluve. ' ");
INSERT INTO wbi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","APuo, mukum'biika umuunhu ujo aleke kukuvantanga avapaafi vaake, ulkuwakuva mwiti ahumisie kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mu uluo mubenapula ilisio lya Nguluve, pano mugadilila inyiiho siinu sino mukwuping'hana. Kange muli ni nyiiho inyinga ndavule isio sino nasihuma kwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","UYesu akakemeela kange ilipugha ilya vaanhu akavavuula, akati, “Mumhulikisyaghe mweni, kange musitang'haniaghe sino nijova. ");
INSERT INTO wbi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nakwekili ikiini kino ilia umuunhu kino kikumpelela kuuva mlamafu, looli fino fihuma munkate mwa mwene. ");
INSERT INTO wbi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Unya kupulika, apulikaghe!” ");
INSERT INTO wbi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","UYesu na vavulanisivua vaake vakalikela ilipugha, vakingila mu nyumba. Pe avavulanisia vaake vakamposia imhola ija kihwanikisio kila. ");
INSERT INTO wbi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","UYesu akavavula avavulanisivua vaake akati, “Na jumue nakumkulutang'hania? Namukagula kuuti, nakwekili ikiinu kino ilia umuunhu kino kikum'biika kuuva mulamafu? ");
INSERT INTO wbi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ulwakuva nakiluta mu mwojo, looli kiluta mu lileme, neke pambele kihuma kunji.” Enendiliki, alyavusisie umwiko mu fyakulia fyoni. ");
INSERT INTO wbi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kange uYesu akajova akati, “Ikiinu kino kihuma mu mwojo, kye kino kikumpelela umuunhu kuuva mulamafu. ");
INSERT INTO wbi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ulwakuva mu mwojo, kye kino kikumpelela umuuhnu kuuuva mulamafu. Ulwakuva mu mwojo ghwa muunhu mwe muno sihuma: inyisaghilo imbiivi, uvughendamwalu, uvuhiiji, uvubudi, ");
INSERT INTO wbi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uvuvwafu, umwojo, uvuviiji, uvusyangi, amasaka, ikivini, amaligho, amatuupa na kupunia. ");
INSERT INTO wbi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Inyivi sooni isi sihuma nkate mwa muunhu, isio se sino sikum'biika kuuva mulamafu.” ");
INSERT INTO wbi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","UYesu akavuuka pala, akaluta mu makaaja gha Tiilo. Ukuo akingila mu nyumba ja muunhu jumonga, neke naakalondagha avaanhu vakagule. ");
INSERT INTO wbi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Looli unsiki ghughuo umukijuuva, juno umwana ghwa mwene n'debe alyale ni lipepo lilamafu, akapulika imhola sake, akisa, akaghua pasi pa maghulu ghamwene. ");
INSERT INTO wbi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Unkijuuva ujuo akisile Muyunani, ghwa kikolo kya Kifoeniki akansuma juue adage ilipepo kuhuma mwa mwalive ");
INSERT INTO wbi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Neke uYesu akam'buula akati, “Uleke taasi avaana valie vikute, ulwakuve nalunono kutoola ikya vaan na kukusitosekasai imbua.” ");
INSERT INTO wbi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Neke umukijuuva jula aka akamwamula uYesu akati.” Ghwa Nhaaata, ujovile se seene, poope nasi mbua sasilia ifimenyikila fino vasangwisie avaana paasi pa meesa.” ");
INSERT INTO wbi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","UYesu akam'buula akati, “UYesu akam'buula akati, “Vwimila iliso lino ujovile, vujagha, ilipepo limulekile umwalivo.” ");
INSERT INTO wbi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Umukijuuva jula akavuukka ivuja. Ye afikile ku kaaja, akamwagha umwalive aghonile pa kitala, ilipepo limulekile' ");
INSERT INTO wbi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","UYesu akavuuka mu maakaja agha Tiilo kukilila mu likaaja ilya sidoni, pe akafika ku lisumbe ilya Galilaya na mu isi ija Dekapoli. ");
INSERT INTO wbi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ukuo vakamuletela umuunhu unya mapule, kangevkinuunu. Vakampelepesia uYesu am'biike amavoko kuuti sooke. ");
INSERT INTO wbi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","UYesu akam'busia umuunhu jula mu kipugha ikya vaanhu, akaseghuka naghwope pa vusyefu, akingisia ifyove fyaka mu mbulughutu, akafuunya amati na kukumwabasia ulumili. ");
INSERT INTO wbi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pepano uYesu akalola kukyanya, akasukunala, akam'buula, akati, “Efata,”Kwekuti, “Dinduka.” ");
INSERT INTO wbi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Palapala imbulughutu saake sikandinduka nalu lumili lukavopoka, pe akatengula kujova vunono. ");
INSERT INTO wbi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","UYesu akavakaana avaanhu vala kuuti, navangm'bulaghe nambe muunhu sino avombile. Napano akavakanagha, aveene vakafikwisyagha imhola ku vaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Avaanhu vakadegha kyongo vakati, “Imbombo sooni sino avombile nofu! Avanya mapule avapeliile kupulika na vakinuunu avapeliile kujova.” ");
INSERT INTO wbi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ikighono ikingi, ilipugha lya vaanhu likakong'haana kange. Avaanhu avuo ye vikalile nu Yesu ifighono fitatu, vakava vasila kyakulia. Pepano uYesu akavakemeela avavulanisivua vaake akati, ");
INSERT INTO wbi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nikuvavonela ikisa avaanhu ava, ulkuwakuva vikalile nuune ifighono fitatu, lino vasila kyakulia. ");
INSERT INTO wbi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ningavatavule kuuti vavujaghe kisila kulia, kyavitegha mu sila, kange vomonga vihuma kutali.” ");
INSERT INTO wbi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Avavulanisivua vaake akati, “Ghihuma kuughi amakate pa lunyika apa pavulisila kimonga, neke vakwile avaanhu vooni ava!” ");
INSERT INTO wbi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","UYesu akavaposia akati, “Muli na makate ghalingi?” Vakamwamula vakati, “Ghali lekelalubale.” ");
INSERT INTO wbi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pepano uYesu akavavuula avanuuhu kuuti vikale paasi. Akamenyulania, pe akava ikuvapeela avavulanisivua vaake, neke voope vakava vikuvaghavila avaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kange vaale ni usamaki udebe. UYesu akafifuunya, akavavuula avavulanisivua, vaake kuuti lyope vavaghavile avaanhu. ");
INSERT INTO wbi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Avaanhu vakalia, valikuta. Avavulanivua vakakon'hania ifisighasi, fikamema indiilo lekelalubale. ");
INSERT INTO wbi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Avaanhu vano valyaliile valyale imbilima inendiliki. UYesu akavahwesia, ");
INSERT INTO wbi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","akavavuuka akapanda ingalava palikimo na vavulanisivua vaake, akaluta imbale isa ku Dalumanuta. ");
INSERT INTO wbi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ye vafikile ukuo, aVafalisayi vakamulutila uYesu, vakatengula kukumposia kukumughela kuuti, avahufie ikivakilo kino kivonia kuuti asung'hile nu Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","UYesu akasukunala, pe akajova akati, “Kiki avaanhu va kisina iki vilonda ikivalilo? Kyang'ahhani nikuvauula, nakilapelua ikivalilo.” ");
INSERT INTO wbi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Akavaleka, akapanda kange ingalava, akatengula kulovoka mu lisumbe iluta imwambo ijingi. ");
INSERT INTO wbi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ye vilovoka, avavulanisivua vaake vakasyemua kutoola amakate, looli mweghulyale unkate ghumo mu ngalaav. ");
INSERT INTO wbi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","UYesu akavapavla akati, “Nikuvavuula kuuti mughelaghe ni kilule ikya Vafalisayi ni kya ntwa uHelode.” ");
INSERT INTO wbi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Avavulanisivua vaake vakatengula piposania veene piiti, uYesu ijova ndiliki ulwakuva vasila makate. ");
INSERT INTO wbi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","UYesu akasikagula sino vakava vijova akati, “Kiki mukaning'hana jumue mwiti muli vasila makate? Mujiinge namukulutang'hania kiki namuli vangufi kukwitika mu moojo ghiinu? ");
INSERT INTO wbi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muli na maaso neke namulola? Kange muli ni mbulughutu neke nampulika? Namukumbuka, ");
INSERT INTO wbi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","unsiki ghula ye nimenyulania amakate ghahaano, vakalia avaanhu imbilima inhaano, mukakong'hania ifisighasi indiiilo ilingi?” Vkati, “Indiilo kijigho ni vili.” ");
INSERT INTO wbi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Nambe ye nimenyulania amakate lekelalubale, vakalia avaanhu imbilima ine, mukakong'hania ifisighasi indiilo ilingi?” vakati, “Lekelalubale.” ");
INSERT INTO wbi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Akavaposia akati, “Mujiighe namukulutang'hania?” ");
INSERT INTO wbi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","UYesu na vavulanisuvua vaake vakafika ku Betisaida, pepano avaanhu vakumuletela umuunhu um'bofu, maaso, vakampelepesia amwabasie neke asooke. ");
INSERT INTO wbi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","UYesu akankola uluvoko um'bofu jula, akahuma naghwope mu kikaaja kila. Akamfunyila amati mu maaso, neke akaviika mavoko ghaake pa mwene, akamposia akati, “Ukukyaga kimonga?” ");
INSERT INTO wbi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Um'bofufu jula akalola, akati, “Nikuvaagha avaanhu, neke vivoneke hwene mapiki ghighenda!” ");
INSERT INTO wbi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","UYesu akagomokela kuviika amavoko ghaake pa maaso gha m'bofu. vunofu ifiinu fyoni. ");
INSERT INTO wbi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","UYesu ye ikuntavula avujaghe akati, “Ulekaghe kugomamoka ku Betisaida.” ");
INSERT INTO wbi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","UYesu na vavulanisivivua vaake, vakavuuka viluta mu fikaajo fino filyale piipi ni likaaja lya Kaisalia-Filipi. Ye vali mu sila akavaposia akati, “Avaanhu viiti une neene veeni?” ");
INSERT INTO wbi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Vakamwamula vakati, “Vamo viiti veeve Yohani uMwofughi, vamonga viiti veeve m'bili uEliya, avange viiti umo muvavili avalongosi.” ");
INSERT INTO wbi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Akavaposia akati, “Umue mwiti neene veeni?” Upeteli akamwamula akati, “Uve veeve Kilisite.” ");
INSERT INTO wbi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","UYesu akavavuula kuuti navangam'bulaghe muunhu imhola iji. ");
INSERT INTO wbi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pepano akatengula kukuvavulanisia avavulanisivua vaake kuuti, “Lunoghiile une Mwana ghwa Muunhu kuuva ni mhumuko nyinga na kukunua na vagojo na vatekesi na vavulanisi va ndaghilo na kubudua, neke ikighono ikya vutatu nisyuka.” ");
INSERT INTO wbi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Uyesu akajova amasio aghuo kisila kufisa. Pepano uPeteli akaluta nagwhope palubale, akatengula kukun'dalikila kuuti isio nasingawaghe. ");
INSERT INTO wbi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Apuo uYesu akasyetuka, akavalola avavulanisivua vaake, pe akan'dalikila uPeteli akati, “Vuuka apa ghwe setano uve, amasaaghe ghaako nagha Nguluve ulwene masaaghe gha vaanhu.” ");
INSERT INTO wbi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","UYesu akakemeela ilipugha ilya vaanhu na vavulanisivua vaake, akavavuula akati “Umeenhu juno ilonda kukumbingilila une, avuleke uvughane vwake, itavule ambingilaghe nambe kuuve kwe kufua. ");
INSERT INTO wbi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ULwakuva umuunhu juno ilonda kupoka uvwumi vwake, ujuo ikwambusia, looli juno ikwambusia uvwumi vwake vwimila une ni Mhola iNofu, ujuo ikuvupoka. ");
INSERT INTO wbi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lino, umuunhu ndepoonu ivumbulila kiki kuuva nu vumofu vwoni uvwa iisi, neke ambusie uvwumi vwake? ");
INSERT INTO wbi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nambe umuunhu ahumie kikim apyanisie pa vwumi vwake? ");
INSERT INTO wbi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Umuunhu ghweni anang'haane une ni mbulanisio sango pa vaanhu va kisina iki ikihosia kino nakikum'bikila mwojo uNguluve, na juune ne Mwana ghwa Muunhu, nilaava nikwisa mu vuvaha vwa Nhaata palikimo na vanyamhola avimike, nilankaana umuunhu ujuo.” ");
INSERT INTO wbi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","UYesu akajova akati, “Kyang'haani nikuvavuula, vamonga nkate mulyumue mwe vano muli apa, navalafua kuhanga pano vikuvwagha uvutwa vwa Nguluve vwisile ni ngufu.” ");
INSERT INTO wbi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ye fikilile ifighono ntanda, uYesu akavatoola uPeteli, uYakovo nu Yohani. Akaluta navoope ku kidunda ikitali, vakijekela, vakava veene. Ye vali pala, uYesu akanduka pamaaso ghaave, ");
INSERT INTO wbi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","nagha menda ghaake ghakava ghivalatika, mavalafu kyongo, nakwale unsukamenda pa iisi apa, juno ndepoonu ivalasia endendiiki. ");
INSERT INTO wbi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pe vakasetuka avavili avalongosi uEliya nu Moose, vijova nu Yesu. ");
INSERT INTO wbi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pepano uPeteli akam'buula u Yesu akati, “M'bulanisi, linono usue tukalaghe bahaapa. Lino, tujenge ifyeve fitatu: kimo kiive kyako, kimonga kya Moose, ikingi kiive kya Eliya” ");
INSERT INTO wbi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","UPeteli nalyalutang'hinie ajove kiki, ulwakuva umwene na vanine vaale nu ludwesi. ");
INSERT INTO wbi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pepano likiisa ilifunde likavakupikila, likapulikika ilisio kuhuma mu lifunde liiti, “Uju ghwe Mwanango umughanike, mumpulikilasyaghe umwene!” ");
INSERT INTO wbi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nakalingi vakolola kuno kuno na kuno navakamwagha umuunhu ujunge, looli ju Yesu mwene. ");
INSERT INTO wbi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ye vali mu kidunda vikwika, uYesu akavakaana avavulanisivua vaake vala kuuti, navangampangilaghe nambe muunhu sino vasivwene, kuhanga umwene uMwana ghwa Muunhu alaava asyukile kuhuma ku vafue. ");
INSERT INTO wbi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aveene vakaligada ilisio linoajovileuayaesu, kumo vakiposaniagha veene viiti, “Kusyuka ukuo kwekuti kiki?” ");
INSERT INTO wbi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pepano vakamposia uYesu vakati, “Ongo avavulanisi va ndaghilo sa Moose viiti aliisa taasi uEliya, uKilisite ye akyale kuwkisa?” ");
INSERT INTO wbi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","UYesu akavamula akati, “Se seene, aliisa taasi uEliya, kuuti aling'hanie vunono sooni. kange nalilembilue mu Malembe aMimike kuuti, une ne Mwana ghwa Muunhu nilapmusivua kyongo na kubedua? ");
INSERT INTO wbi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lino nikuvavuula niiti, uEliya alisile, neke avaanhu vakam'bombela sino vakighanile aveene, ndavule lilembilue vwimila umwene.” ");
INSERT INTO wbi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ye vifika, vakavaagha avavulanisivua avange vikaning'hana na vavulanisi va ndaghilo, vasyungutilue ni lipugha ilya vaanhu. ");
INSERT INTO wbi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Avaanhu vala ye vikum'bona uYesu vakadegha kyongo, vakaguuna kwa mwene, vakamhungila. ");
INSERT INTO wbi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Uyesu akavaposia akati, “Mukaning'hana kiki” ");
INSERT INTO wbi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jumonga nkate mu Kipugha, akamula akati, “Ghwe M'bulanisi, nimuletile umwanango kulyuve, ali lipepo lino likumpelela kuuva kinuunu. ");
INSERT INTO wbi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jaatu pano lim'bwene likumughwisa paasilikumpelela ahumyaghe ilitotofulo mu mulomo na kughwenula amiino, neke um'bili ghuswatuka. Navasuuma avavulanisivua vaako valihumie, vakunua.” ");
INSERT INTO wbi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Neke uYesu akavavuula akati, “Mwe kisina ikisina ikisila lwitiko! Nikalile numue unsiki ghwoni ughu, mukyale kukunhang'ania? Nikale ndaani numue? Muleete kulyune!” ");
INSERT INTO wbi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Vakam'besia kwa Yesu. Pe ilipepo lila likamughwisia paasi unsoleka jula, akasaghalatagha na kuhumia ilitotofulo mu mulomo. ");
INSERT INTO wbi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pepano uYesu akamposia uviise akati, “Ulu lulyamwandile lighi?” Akamwamula akati, “Kuhuma pa vwana. ");
INSERT INTO wbi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kekinga lintupiike pa mwoto, pamonga likuntaangha mu malenga, Uvufumbue vwake lim'bude. ghwe Yesu, lino nave uli ngufu kuvomba lumonga, sivuo utusungukile, ututange. ");
INSERT INTO wbi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“ UYesu akamwamula akati, “Ghwire nave nili ni ghufu kuvoma lumonga! Sooni sivobeka kwa muunhu unya lwitiko.” ");
INSERT INTO wbi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Apuo unya mwana jula akajova fiijo.” ");
INSERT INTO wbi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","UYesu ye ilola ilipugha ivona avaanhu vifikwongelela, pepano akalidalikila ilipepo iliamafu akati, “Ghwe lipepo ghw ukumpelela umwana uju kuuva kinuunu na mapule, nikukuvuula niiti, huma mwa muunhu uju nungamwingilaghe kange! ");
INSERT INTO wbi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Neke ilipepo ilio likakoola, likansukania kyongo, pe likahuma. Unsleke jula akahwana mfimba, vamona vakati, “Afwile!” ");
INSERT INTO wbi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pepano uYesu akankola uluvoko, akamwinula unsokela jula, akiima. ");
INSERT INTO wbi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","UYesu akingingila mu nyumba, avavulanisivua avaake ye vijekiile naghwope, vakamposia vakati, “Ongo usue tuveele tukunilue kukulidaga ilipepo lila?” ");
INSERT INTO wbi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","UYesuakavamula akati, “Amapepo ndavule agha naghihuma vule vule, looli lulufuunyo lwene.” ");
INSERT INTO wbi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","UYesu na vavulanisivua v, ulwakuva akavavulanisia aake, vakavuuka viluta kukilila ku Galilaya. Neke uYesu anakalagha umunhuu ujunge akagule pano pwale, ");
INSERT INTO wbi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ulwakuva akava ikuvavulanisia avavulanisivua vaake kuuti, “Une ne Mwana ghwa Muuunhu nitapivikua mu mavoko gha vaanhu vano kyavikumbuda, neke ikighono ikya vutatu nisyuka.” ");
INSERT INTO wbi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Avavulanisivua vaake navakalutang'hania luno ijova, vakoghopa kukumposia. ");
INSERT INTO wbi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","UYesu na vavulanisivua vaake ye vali mu sila, avavulanisivua vakava vikaning'hana. Vakafika mu likaaja ilya Kapelenaumu. Ye vingiile mu nyumba, Yesu akavvaposia akati, “Muveele mukaning'hana kiki ye muli mu sila? ");
INSERT INTO wbi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aveene vakajika kihihe, ulwakuva vakakaning'hanagha kuuti ghwe veeni vakajika kimihe, ulwakuva vakakaning'hanagha kuuti ghwe veeni um'baha nkkate mu veene. ");
INSERT INTO wbi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","UYesu ye ikallile, akavakemeela vala kijigho na vavili akavavuula akati “Umuunhu juno ilonda kuuva ghwa kwanda avisaghe ghwa vusililo, kange m'bombi ghwa vooni.” ");
INSERT INTO wbi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pepano akantoola umwana un'debe, akam'biika pakate, akamughumbatila, neke akavavuula akati, ");
INSERT INTO wbi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Umuunhu juno ikumwupila umwana ndavule uju mu vughane veagho, ikunyupila une. Kange juno ikunyupila une, naiiva anyupiile, looli iiva amwupiile naju Nhaata juno asung'hile.” ");
INSERT INTO wbi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","jumonga idagha amapeo mu litavua lyako, neke usue twankaana ulwakuva naghwa kipugha kiitu.” ");
INSERT INTO wbi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","UYesu akati “Namungankanaghe, ulwakuva nakwale jun ivomba ifidegho mu litavua lyango, neke kange anjove fivi une. ");
INSERT INTO wbi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Umuunhu ghweni juno namulugu ghwitu, ali lubale lwitu. ");
INSERT INTO wbi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kange Umuunhu ghweni juno kuvapeela nambe utulenga, ulwakuva muli vaanhu va Kilisite, kyang'haani nikuvuvavuula, uNguluve nangaleke kukumpeela. ");
INSERT INTO wbi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","UYesu akajova kange akati, “Umuunhu juno ikumwambusia kuvomba inyivi jumonga mu vadebe ava vano vikunyitika une, lwale luuva kuba kwa muunhu ujuo kupinyilisivua ulwa ku singo na kutaghua pa kyogho munyanja. ");
INSERT INTO wbi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Uluvoko lwako lungakwambusie, dumula. Yekuba kukwingila ku vwumi ni Lukovo lumo kukila kujigha na mavoko ghe ghaviili neke ulete ku lupumuko lwa mwoto ghuno naghusima lusiku. ");
INSERT INTO wbi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Muno amang'onyo ghaake naghifua, nambe umwoto naghusima. ");
INSERT INTO wbi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nalu lughulu lukakwambusie, dumula. Yekuba kukwingilia ku vwumi uli mulema kukila kujigha na maghulu ghe ghaviili neke utaghue ku lupumuko lwa mwoto ghuno naghusima lusiku. ");
INSERT INTO wbi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Muno amango'nyo ghaake naghifua, nambe naghumwoto naghusima. ");
INSERT INTO wbi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kange iilisio lyako lingakwambusie, ng'omotola, utaaghe. Yekuba kukwingilia ku vutwa vwa Nguluve ni liiso limo kukila kujigha na maaso ghe ghavili neke utaghue ku lupumuko lwa mwoto ghuno naghusima lusiku, ");
INSERT INTO wbi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Muno 'amang'onyo ghaake naghifua, nambe naghumwoto naghusima. ");
INSERT INTO wbi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Avaanhu vooni vilivalasivua nu mwoto, ndavule ilitekelo vule livalasivua nu mwinyo. ");
INSERT INTO wbi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Umwinyo mnofu, leelo nave ghusupuke lwoni, uviike kiki neke ghukolele? Muvisaghe nu mwinyo nkate mulyumue, mukalaghe nu lutrngaano.” ");
INSERT INTO wbi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","UYesu akavuuka iluta ku kighavo ikya Yudea, kukilila imwambo ija kikogha kya Yolidani. Amapugha gha vaanhu ghakava ghiluta kange kwa mwene, pe akavavulanisyagha ndavule lwale lwiho lwake. ");
INSERT INTO wbi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pepano aVafalisayi vamonga vakaluta kukumughela, vakamposia vakati, “Asi, lukwitikisivua mu ndaghilo siitu umughoosi kukuntavula un'dala ghwake?” ");
INSERT INTO wbi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","UYesu akavaposia akati, “UMoose alyavalaghilike kiki?” ");
INSERT INTO wbi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Vakamwamula vakati, “UMoose alyitikisie kulemba ikalata ija kutavula un'dala na kukumuleka ");
INSERT INTO wbi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","UYesu akavavuula akati, “UMoose alyavalembiile ululaghilo uluo, ulwakuva namupulika mu sino muvulanisivua. ");
INSERT INTO wbi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kuhuma uNguluve ipela iisi, “Alyapelile umughoosi nu n'dala.' ");
INSERT INTO wbi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mu uluo umuunhu ikumuleka uviise nu ng'ina, neke ivisagha nu n'dala ghwake, ");
INSERT INTO wbi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","vavili ava viiva m'bili ghumo.' Apuo naviiva vavili kange, looli viiva m'bili ghumo. ");
INSERT INTO wbi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lino, kino uNguluve alungile, umuunhu nangalekanisyaghe.” ");
INSERT INTO wbi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ye vingiile kange mu nyumba, avavulanisivua vaake vakamposia imhola ija lisio ilio. ");
INSERT INTO wbi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","UYesu akavamula akati, “'Umuunhu ghweni juno itavula un'dala na kutoola ujunge, iiva m'bwafu amhokile un'dala ghwake untasi. ");
INSERT INTO wbi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ghwope un'dala angamuleke umughoosi na kutolua kwa junge, ghwope iiva m'bwafu.” ");
INSERT INTO wbi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Avaanhu vakamuletela uYesu avaana avadebe avabasie kuuti avafuunye, neke avavulanisivua vaake vakavadalikila avaanhu vala. ");
INSERT INTO wbi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","UYesu ye aluvwene uluo, akakalala, akavavuula avavuulanisivua vaake akati, “Muvaleke avaana avadebe visaghe kulyune. namungavasighaghe' ulwakuva uvutwa vwa Nguluve vwa vaanhu vano vali ndavule avaana ava. ");
INSERT INTO wbi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kyang'haani nikuvavuula niiti, umuunhu ghweni juno naikumwitika uNguluve ndavule umwana un'debe, naalingila mu vutwa vwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pe akava ikuvaghumbatila avaana vala, akaviika amavoko ghaake pa veene kukuvafuunya. ");
INSERT INTO wbi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","UYesu ye ivuuka iluta, umuunhu jumonga akiisa luvilo, akafughama pa mwene Yesu, akamposia akati, “Ghwe M'bulanisi ghwe nnofu, nivombe kiki neke niive nu vwumi uvwa kuvusila kusila?” ");
INSERT INTO wbi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","UYesu akamwamula akati, “Kki kukunhambula kuuti nili nnofu? Nakwale unnofu, looli ju Nguluve mwene. ");
INSERT INTO wbi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Usimanyile indaghilo isa Nguluve:' Nungabudaghe, nungavwafukaghe, nungahijaghe, nungolekaghe isa vudesi, nungasyangaghe, umwoghopaghe, umwoghopaghe uvaaso nu mamaajo.” ");
INSERT INTO wbi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Umuunhu jula akamwamula akati'”M'bulanisi, isio sooni nisigadiliile kuhuma uvwana vwango.” ");
INSERT INTO wbi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","UYesu akamulola, akamughana, akam'buula akati, “Ghwaghilue ikiinu kimo. Ulute ughusie fyoni fino uli nafyo, neke indalama sino upatile uvapeele avakotofu. Apuo pe ghuuva ni kyuma kukyanya. Pepan ghwisaghe umbingililaghe.” ");
INSERT INTO wbi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Umuunhu jula ye apuliike isio, akiluka ku maaso, akavuuka asukuniile, ulwakuva akasaghagha ulwa kutavula ikyuma kyake kino kyale kinga. ");
INSERT INTO wbi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","UYesu akalola imbale sooni, akavavuula avavulanisivua vaake akati, “LUtalamu kyongo avanya kyuma kukwingila mu vutwa vwa Nguluve!” ");
INSERT INTO wbi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Avavulanisivua vakadegha amasioghaake. UYesu akavavuula kange akati, “Vanango, lutalamu kyongo kukwingilila ku vutwa vwa Nguluve! ");
INSERT INTO wbi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kihuugu ingamila pikila pa kalyoli ka honelo, Kkila ummofu kukwingila mu vutwa vwa Nguluve” ");
INSERT INTO wbi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Avavulanisivua vaake vakadegha kyogo, vakiposania vakati, “Pe veeni lino juno anoghiile kupokua? ");
INSERT INTO wbi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","UYesu akavalola akati, “Ku vaannhu lutalamu, neke kwa Nguluve sooni sivombeka.” ");
INSERT INTO wbi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Upeteli akam'buula akati, “loola, usue tufilekile fyoni, tutukuvingilila uve.” ");
INSERT INTO wbi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","UYesu akati, Kyang'haani nikuvavuula, umuunhu juno ajilekile inyumba, nambe avanine, nambe avalumbu, nambe ung'ina, nambe uviise, nambe avaana, nambe amaghunda vwimila une ni Mhola iNofu, ");
INSERT INTO wbi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ujuo mu masiki agha pelua figha kukila fino afilekile. pelua inyumba, avanine, na valumbu, nu ng'ina na vaana na maghunda. Nasi mhumuko sikumwaghagha. Kange unsiki ghuno ghukwisa alapelua uvwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Neke vinga vano va kwanda valaaava va vusililo, ava vusililo valaava vakwanda. ");
INSERT INTO wbi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","UYesu na vavulanisivua vaake valyale mu sila vifiluta ku Yelusalemu. UYesu akava ikuvalongolela. Avavulanisua vaake vakadegha, nava vaanhu vano vakavigisaniagha vakoghopa. Pepano UYesu akavatoola kange vala kjigho na vavili, akaluta navoope palubale, akatengula pikuvavuula sino kyaivombelua. ");
INSERT INTO wbi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akati, “Lolagha! Taluta ku Yelusalemu, ukuo une ne Mwa ghwa Muunhu niluta Kukwohehelua ku vavaha va vatekesi na vavulanisi va ndaghilo. Aveene kyavikuhigha kuuti nibududue. kange kyavikumbiika mu mavoko gha vano na Vayahudii, ");
INSERT INTO wbi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","voope vikunyovelegha, vikufunyilagha amati, vikung'hopagha ni mijeledi na kukumbunda. neke ikighono ikya vutatu nisyuka. ");
INSERT INTO wbi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pepano avakina Sebedaayi uYakovo nu Yohani, vakaluta kwa yesu vakati, “m'bulanisi, tusuuma utuvombele luno tulodonda.” ");
INSERT INTO wbi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","UYesu akavaposia akati, “Mulonda nivavombele kiki? ");
INSERT INTO wbi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Vakamwamula vakati, “Ghuliiva ghutema mu vuvaha vwako, tusuuma na jusue tuvisaghe nuuvu, jumo ilake ulubale lwako ilwa kundio, ujunge ulwa kung'highi.” ");
INSERT INTO wbi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","UYesu akavavuula akati, “Namukagwile luno musuuma. Ndepoonu mutavwile ulwa vufue luno nikwofughua une?” ");
INSERT INTO wbi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Vakamwamula vakati, “Eena, tunoghiliile.” UYesu akavavuula akati, “Isila ija lupumuko jino nikilila une. ");
INSERT INTO wbi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Neke kukuvapeela kuuva nuune mu vuvaha vwago, jumo kundio jughe kung'highi kulyune, navutavulilua vwango. Looli uNhaata ghwango ghwe juno alavapeela vano avaling'hanikisie ng'haani.” ");
INSERT INTO wbi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Avavulanisivua avange kijigho ye vapuliike iso, vatatengula kukunkalalila uYakovo nu Yohani. ");
INSERT INTO wbi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pepano u Yesu akavakemeela vooni, akavavuula akati, “Mukagwile kuuti avatwa va iisi vitema avaanhu vaave ni ngufu. kange vihufia ingufu isa vutavulilua vwave ku vavanda neke vavakundaghe mu sooni. ");
INSERT INTO wbi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Neke kulyumue nafye lungavisaghe. looli umuunhu juno ilonda kuuva m'baha ujuo avisaghe m'bombi ghwinu. ");
INSERT INTO wbi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Naju muunhu juno ilonda kuuva mulongosi, avisaghe nkami ghwa vooni. ");
INSERT INTO wbi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na juune ne Mwana ghwa Muunhu nanilisile kuvombelua, looli nilisile kukuvavombela avange na kuhumia uvwumi vwango kuuti nivavange vinga.” ");
INSERT INTO wbi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pepano uYesu na vavulanisivua vaake vakafika mu likaaja ilya Yeliko Pambele ye vihuma palikimo ni lipugha lya vaanhu mu likaaja ilio, vakamwagha um'bofu ujuo akasumagha ifiinu. Ikighono iko, alikalile palubale pa sila. ");
INSERT INTO wbi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ye apuliike kuuti ghwe Yesu uMunasaleti ikila mu sila jila, akatengula pikemeela fiijo akati, “Ghwe Yesu Mwana ghwa David, usungukile!” ");
INSERT INTO wbi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Avaanhu vinga vakava vikun'dalikila na kukum'buula kuuti ajike, neke umwene akaghina kukemeela fiijo akati, “Ghwe mwana ghwa Dvidi, usungukile!” ");
INSERT INTO wbi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","UYesu akiima akati, “Munkemeela um'bofu jula vakati, “Ghukangasasyaghe, ima, ikukukemeela.” ");
INSERT INTO wbi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pepano akataagha umwenda ghwake, akiimang'haning'haani iluta kwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","UYesu akamposia akati, “Ghulonda nikuvombele kiki? Um'bofu jula akati, “M'bulanisi, nililonda nilolaghe.” ");
INSERT INTO wbi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","UYesu akam'buula akati, “Lutagha, usokile vwimila ulwitiko lwako.” Unsiki ghunghuo um'bofu jula akalolagha, kama'bingilila uYesu mu sila. ");
INSERT INTO wbi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","UYesu na vavulanisivua vaake vakava piipi kufika ku likaaja ilya Yelusalemu, ulubale ulwa kikaaja ikya Betifage ni kya Betania, piipi ni kidunda ikya Miseituni. Pepano akavasuung'ha vavili nkate mu vavulanisivua vaake, ");
INSERT INTO wbi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akati, “Mulute mu Kikaaja kino kili kuvulongolo Kulyumue. Kyamukwingila mu kikaaja ikio, mukujaagha inyaana ja dogovi jikungilue. Idogovi ijio, nambe muunhu naangalile kukujangangalila. Ijio mwavule muleete. ");
INSERT INTO wbi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Umuunhu angavaposie kuutu kiki muvomba uluo, mutisaghe, uMutwa ali nu vufumbue najo, igomosia unsiki n'debe vuvule.” ");
INSERT INTO wbi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Avavulanisivua vala vakajaagha inyaana ija dogovi, jikungilue pa nyumba jino jaale mulubale mu nsevo, pe vakajavula. ");
INSERT INTO wbi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Avaanhu vamonga vano valyale piipi vakavaposia vakati,”Kiki mukujavula inyaana ja dogovi?” ");
INSERT INTO wbi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pepano avavulanisivua vakamula ndavule eveele avalaghiile uYesu. Avaanhu vala vakavaleka viluta najoope. ");
INSERT INTO wbi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Vakantwalila uYesu inyaana ja dogovi, pe vakatandika amenda ghaave pa dogovi, neke uYesu aakngalila. ");
INSERT INTO wbi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Avaanhuvinga vakava vitandika amenda ghaave mu nsevo, vamonga vakatandikagha amataafi ghano vadenyile mu mapiki ghano ghaale mu maghunda. ");
INSERT INTO wbi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Avaanhu vooni vano valyalongwile na vano valyale mumbele vakava ni njegheelo ija lukeelo viiti, “Aghinwaghe! Afunyilue juno ikwisa mu litavua lya Mutwa uNguluve! ");
INSERT INTO wbi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Vufunyilue uvutwa vuno vukwisa, ndavule vwale uvutwa vwa nhaata ghwitu uDavidi! Aghinwaghe uNguluve kukyanya! ");
INSERT INTO wbi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","uYesu akafika mu likaaja ilya Yelusalemu, akingila mu nyumba inyimike ija kufunyila. Pe akolola vunofu iffimu fyoni. Ulwakuva jilyale vwilile, akaluta ku Betania palikimo na vavulanisivua vaake kijigho na vavili. ");
INSERT INTO wbi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Palwakilo ye vahumile ku Betania viluta ku Yelusalemu, uYesu jikam'bava injala. ");
INSERT INTO wbi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akaghuvona umpiki untini pa vutali ghuli na matundu minga. Akaveela kuuti pamo alakivona ikipeke, mu mpiki ghula. Neke ye afikile, nakakyagha nambe kipeke, akavona ghali gha matundu gheene, ulwakuva naghwale nsiki ghwa kukoma ifipeke. ");
INSERT INTO wbi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","uYesu akaghuvuula almpiki ghula akati, “Kuhuma umusyughu umuuunhu ghweni naalalia lusiku ikipeke mulyuve.” Avavulanisivua vaake vakapulika sino ajovile. ");
INSERT INTO wbi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ye vafikile mu Yelusalemu, uYesu akingila mu luviika ulwa nyumba inyimike ija kufunyila, akatengula kukuvadaga vano vananiagha indalama ni fitego ifya vaghusia ng'hunda. ");
INSERT INTO wbi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nakamwitikisyagha nambe jumo lukila ni kitwalo mu nyumba inyimike ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pe akavavulanisyagha avaahu akatisagha, “Nalilembilue kuuti, 'Inyumba jango jitambulwagha nyumba ja kufunyila ifisina fyoni? Neke umue muhambwile 'Mhanga ja valyasi!'” ");
INSERT INTO wbi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Avavaha vatekesi na vavulanisi va ndaghilo, ye vapuliike imhola isio, vakatengula kulonda isila ija kum'buda, ulwakuva vakamwoghopagha pano avaanhu viga vakakelagha imbulanisio saake. ");
INSERT INTO wbi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ye vwilile, uYesu na vavulanisivua vaake vakahuma mu likaaja ilya ilya Yulusalemu' ");
INSERT INTO wbi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Palwkilo, ye kukiile, avakiile, vakakilila pa mpiki untini ghula, vakavona ghwumile ghwoni kuhuma pa kisikina. ");
INSERT INTO wbi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","UPeteli akakumbuka isa mpiki untini, pe akati, “Mbulanisi, lola umpiki ghuno ghwaghuna, ");
INSERT INTO wbi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ghwumile!” UYesu akati, “Mumwitikaghe uNguluve. ");
INSERT INTO wbi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kyang'haani nikuvuvavuula' umununhu ghweni angati ku kidunda iki, 'kumuka, ghutaaghe mu nyanja,' angave nu lwitiko ulusila nganighani mu mwojo ghwake, na kuhuviila kuuti sino ajovile sijovile sivombeka, ulufuunyo lwake lukwupilua. ");
INSERT INTO wbi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“'Mu uluo nikuvavuula kuuti, fyoni fino musuuma pano mukufuunya, muhuvilaghe kuuti mupelilue, ifio fivisagha fiinu. ");
INSERT INTO wbi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pano mukufuunya, muvusaghilaghe vano vavahokile, pe na jumue uNhaaata ghwinu ughwa kukyanya ikuvapyanilagha uvuhosi vwinu. ");
INSERT INTO wbi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nave namukuvasaghila avange vano vikuvahoka, naju Nhaata ghwinu ughwa kukyanya naikuvapyanilagha amakole ghiinu.” ");
INSERT INTO wbi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","UYesu na vavulanisivua vaake vakafika kange ku Yelusalemu, vakingila mu nyumba inyimike ija kufunyila. Uyesu ye ighendaghenda mula, avavahava vatekesi na vavulanisi va ndaghilo palikimo na vagoko vakamulutila. ");
INSERT INTO wbi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Vakamposia vakati, “Ghuvomba isi mu vutavulilua vwani?” ");
INSERT INTO wbi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","UYesu akavavuula akati, “Na juune nikuvaposia lumonga, munganyamule, pe na juune nikuvavuula kuno vuhuma uvutavulilua vuno nivombela isi. ");
INSERT INTO wbi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","uvutavulilua vwa Yohani uvwa kwofugha vulyahumile kwani? Vulyahumile kwa Nguluve, ku vaanhu? Munyamule.” ");
INSERT INTO wbi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pe vakiposaniagha veene viiti, “Tungati, 'Vulyahumile kwa Nguluve,' kyaiti, 'Ongo naamulyamwitiike?' ");
INSERT INTO wbi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kange tungati, 'vulyahumile kwa Nguluve,' avaanhu navangitike.” Vakoghopa ilipugha ilya vaanhu ulwakuva vooni valyantang'hinie u Yohani kuuti m'bili gwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pe vakamwamula uYesu vakati, “Natukagwile.” Gwhope uYesu akavamula akati, “Na juune nanikuvavuula kuno vuhuma uvutavulilua vuno nivombela isi.” ");
INSERT INTO wbi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","UYesu akatengula kujova na valangosi va Vayahudi mu fihwanikiso akati, “Umuunhu jumonga alyalimile umughuda, akavyala isabibu. Akajenga uluvigho kusyuta umughuda ghwoni. Munkate, akajenga apa kuhujila isabibu. Kange akajenga pa vwimo apa kulolelelela umughunda. Akakodesia ku vaanhu umughuda ghula, neke umwene akakyula. ");
INSERT INTO wbi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ye ghufikile unsiki ughwa kudonola isabibu, akansuung'ha um'bombi ghwake ku vano akakodisie kuuti antolele ilighavo lyake ilya mpeto. ");
INSERT INTO wbi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ye afikile um'bombi jula, avaanhu vala vakantova na kukumhumia kunji kisila kumpeela kiinu. ");
INSERT INTO wbi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akansuung'ha mu'bombi ujunge, ujuo ghwope vakantova, vakamulemasia ku mutu na kukum'bombela sino nasinoghiile. ");
INSERT INTO wbi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Unyamughunda jula akansuung'ha kange um'bombi ujunge, ujo ghwe vakam'buda. Alyavasung'ha ile na vange vinga, vamo vakatovua, avange vakabudua. ");
INSERT INTO wbi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“ Kuvusililo, unya mughuda akasighala nu mwanaake umughahanike. Pe akansuung'ha jujuo akati, 'Umwanango uju, kyavikumwoghopa.' ");
INSERT INTO wbi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Neke avaanhu vala ye vamwaghile, vakapulling'hana vakati, 'Uju ghwe unya vuhaasi ghwa mugghuda ughu, tum'bude neke avuhaasi uvu vua vwitu!' ");
INSERT INTO wbi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Vakankola, vakam'buda, pe vakankwesela kunji kuhuma mu mughunda ghula ughwa sabibu. ");
INSERT INTO wbi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Lino, ndepoonu unya mughunda jula kyaivomba kiki? Ikwisa ikuvabuda avaanhu vala, neke ikodesia ku vaanhu avange umughunda ghula. ");
INSERT INTO wbi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Namuvalile ilisio ili? Lilembilue mu Malembe aMimike kuuti, “Ilivue lino avajengi valyalikanile, lye livue ilivaha ilya pa nguto. ");
INSERT INTO wbi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","UMutwa Nguluvi ghwe mwene avombile ili, kange lya kudegha pamaaso ghiitu.” ");
INSERT INTO wbi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Avavaha va vetekesi, avavulanisi va ndaghilo na vavaha va vaanhu, valyakagwile kuuti mukihwanikiso iko akaava ikio akava ikuvajova aveene, pe vakalondagha isila ija kunkola. Neke ulwakuva vakaghopagha lya vaanhu, vakamuleka, vakavuuka viluta. ");
INSERT INTO wbi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pembele avalongosi vala, vakavasuung'ha vamonga mu kipugha ikya Vafalisayi na vavingilili va ntwa uHelode, kuuti valute vamwuvile uYesu mu masio ghano ijova. ");
INSERT INTO wbi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Vakamulutila vakati, “Ghwe M'bulanisi, tukagwile kuti uve uli muunhu ghwa kyang'hani mu vwakyang'haani sino ilonda uNguluve. Asi, indaghilo sa Moose sikwitikisia kusonga isongo kwa kaisali?” ");
INSERT INTO wbi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Neke uYesu akakagula uvukedusi vwave, akavavuula akati, “Kiki mukungela? Mundetele ihela nijilole? ");
INSERT INTO wbi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Vakampeela. Akavoposia akati”Ikihwani nu vulembe fino fili mu hela iji fyani? Vakamwamula vakati, “Fya kaisali.” ");
INSERT INTO wbi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Apuo uYesu akavauula akati, “Ifya kaisali, mumpelaghe uKaisali, ifya Nguluve, uNguluve.” Pe vakan'degha kyongo. ");
INSERT INTO wbi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pambele aVayahudi ava kipugha kya Vasadukayi,” vano vaktisagha nakwekule kusyuka avfue, vakaluta kwa Yesu vakamposia vakati, ");
INSERT INTO wbi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Gwhe M'bulanisi, uMoose alyatulembiile ululaghilo kuuti, nave umuunhu afwile neke amulekile un'dala kisila mwana, unnie anoghile kuhaala un'dala umwifile kuuti ampapile avaana unyakusila. ");
INSERT INTO wbi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Lino, kwevvalyale avavamuunhu lekelalubale. ");
INSERT INTO wbi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ughwa kwandaakatoola un'dala, akafua kisila kuleka mwana. Ghwope ughwa vatatu, akafua vule. ");
INSERT INTO wbi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kuvusililo vooni lekelalubale vakafuakisilakuleka mwana. Pambele ghwope n'dala umfwile, akafua. ");
INSERT INTO wbi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lino, ikighono ikya kusyuka avaanhu vooni, umwifile jula iliiva n'dala ghwani mu vala lekelalubale? Ulwakuva vooni valyantolile.” ");
INSERT INTO wbi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","UYesu akavamula akati, “Umue musovile, namukagwile aMalembe aMimike, nambe ingifu sa Nguluv. ");
INSERT INTO wbi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Avafue valaava visyuka, nakwekulaava kutoola nambe kutolua, viliila ndavule avanyamhola ava kukyanya. ");
INSERT INTO wbi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nguluve ghwa vafue, looli Nguluve ghwa vuumi. Umue musovile kyongo.” Muhola ija kusyuka avafue, namuvalile mu kitabu ikya Moose, pala ikihanji ye kiviika? Amaaka minga ye ghakilile kuhuma kufua kwa Abulahamu nu isaka nu Yakovo, uNguluve alyambulile uMoose akati, 'Une neene Nguluve ghwa Abulahamu, Nguluve ghwa Isaka, Nguluve kwa Yakovo.' ");
INSERT INTO wbi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Umwene naNguluve ghwa vafue, looli Nguluve ghwa vuumi. Umue musovile kyongo.” ");
INSERT INTO wbi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Um'bulanisi jumonga ughwa ndaghilo akafika, akavaagha aVasadukayi vikaning'hana nu Yesu. Ye avwene uYesu ikuvamula vunofu, ghwope akamposia akati, “Mu ndaghilo sooni, ilwe luliku ululaghilo uluvaha?” ");
INSERT INTO wbi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","UYesu akamwamula akati, “Ululaghilo uluvaha mu sooni lwe ulu, 'Pulikagha ghwe Isilaeli, uMutwa uNguluve ghwitu ghwe Mutwa jumo mwene. ");
INSERT INTO wbi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","umughanaghe uMutwa uNguluve ghwako nu mwonjo ghwako ghwoni, nu luhala lwako lwoni, ni ngifusako sooni. ");
INSERT INTO wbi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ululaghilo ulwa vuvili lwe ulu, 'Umughanaghe unnino ndavule ghukughana juuve. nakwelule ululaghilo ulunge kukila indaghilo. ");
INSERT INTO wbi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pepano um'bulanisi jula ghwa ndaghilo akati, “Lweli M'bulanisi! Ujovile se seene kuuti, uNguluve ali jumo mwene, nakwale ujunge looli ghwe jujuo. ");
INSERT INTO wbi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","lunoghiile kukumughana umwene nu mwojo ghwoni, nu luhala lwoni, ni ngufu sooni na kukumunagha unuino ndavule ghukughanga juuve. Ulio lwe luvaha kukila ilitekelo lyoni lino litavulua kwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","UYesu ye avwene um'bulanisi ughwa ndaghilo amwamwile luhala, akam'buula akati, “Nuli patali kukwingila mu vutwa vwa Nguluve,” Kuhuma unsiki ughuo, nalyandiile muunhu kukumposia mulwa kuhuma unsiki ughuo, nalyandiile muunhu kukumposia mulwa kumughela. ");
INSERT INTO wbi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Uyesu ye ivulanisia ilipugha lya vaanhu mu nyumba inyimike ija Kukufunyila, akavaposia akati, “Lwandaani avavulanisi va ndaghilo viti uIkilisite kina Dvidi? ");
INSERT INTO wbi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ongo uDavidi jujuo vwimila kulongosivua nu Mhepo uMwimike, alyatiile. 'UMutwa uNguluve alyam'bulile uMutwa ghwango, “Uuve nu vutavulilua palikimo nuune, kuhanga nikutange uvaleme avaako, uvateme.” ");
INSERT INTO wbi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Uyesu akafijovogha akatisagha, “UDavidi jujuo ikuntambula uKilisite iiti, 'Mutwa.' Lino, pe uKilisite ivisagha mwanaake ndaani?” Ilipugha ilya vaanhu kikampulikisyagha nu lukeelo. ");
INSERT INTO wbi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","UYesu mu luvulaniso lwake akati, “Mughelaghe na vavulanisi va ndaghilo vano viiva nu lukeelo kughenda vafwalile isopeka inhali, kuuti avaanhu vavahungilaghe nu vwoghofi mu mapuulo. ");
INSERT INTO wbi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pano vali mu masinagogi, vilonda kukukala ku fitengo ifya voghopua. ");
INSERT INTO wbi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vikuvafumba avafwile ifiinu fyave, neke mu vukedusi vwave vikufuunya inyifuunyo inhali kuuti vavoneke vagholofu, Avuo, uNguluve ilikuvapeela ulupumuko alukome.” ");
INSERT INTO wbi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","UYesu ye ali mu nyumba inyimike ija kufunyila, alikalile alungiime ku kyombo ikya kusopela ilitekelo. Apuo akava ilola avaanhu vinga vano vakava vitavula ilitekelo. Avamofu vinga vakatavulangha indalama nyinga. ");
INSERT INTO wbi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Unsiki ughuo akiisa umukijuuva umfwile kange nkotofu, akatavula isendi ivili. ");
INSERT INTO wbi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pepano uYesu akavakemeela avavulanisivua vaake, akavavuula akati, “KYang'haani nikuvavuula, umukijuuva umfwile uju umkotofu atavwile kukila avange vooni vanovasopile. ");
INSERT INTO wbi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ulwakuva avange vooni vatavwile fidebe mu finga fino vali nafyo. Looli umukijuuva uju mu vukotofu vwake, atavwile fyoni fino fya kuntanga mu vwumi vwake, ");
INSERT INTO wbi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ye ihuma mu nyumba inyimike ija kufunyila, um`bulanisivua ghwake jumonga akam`buula akati, “M`bulanisi, lola amavue na majumba agha vule ghalivuo!” ");
INSERT INTO wbi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","U Yesu akamwamula akati, “Nikuvavuula niiti, ndavule mukughavona amajumba amakome agha, nalilasighala nambe livue lino lilighelama pa livue ilingi, ulwakuva ghooni ghilihemulua.” ");
INSERT INTO wbi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","U yesu akaluta pa kidunda ikya Miseituni, akikala alungiime ku nyumba inyimike ija kufunyila. Apuo uPeteli, u Yakovo, u Yohani nu Ndeleeya, ye vijekiile, vakamposia u Yesu vakati, ");
INSERT INTO wbi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tusuuma utuvuule, isio sino utuvulile silivombeka liighi? kivalilo kiki ikya ktuhufia kuuti unsiki uhgwa kuvombeka isi sooni ghuli piipi?” ");
INSERT INTO wbi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pepano u Yesu akavavuula akati, “Muvisaghe maaso, umuunhu nangavasyangaghe, ");
INSERT INTO wbi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ulwakuva vinga vilikwisa mu litavua lyango, nujunge itisagha, 'Neene kilisite.' avaanhu avuo vilikuvasyannga vinga. ");
INSERT INTO wbi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Umue mulaava mupulika uvulugu ni njovo saake, mulekaghe pikwoghopa. Ndaluve ndaani isio silivoneka taasi, neke unsiki ughwene ughwa vusililo ghuuva ghukyale. ");
INSERT INTO wbi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ifighono ifio iisi iisi jilallwisagha ni iisi ijingi, kange uvutwa kulua nu vutwa kulua nu vutwa uvunge. Imbale ni mbale kwefiliiva ifisenyeena, kwejiliiva injala. Isio sooni vuuva vutengulilo, Ndavule uvuvafi uvwa mukijuuva, pano unsiki ugwa kupaapa umwana ghufikile. ");
INSERT INTO wbi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Neke umue muvisaghe maaso, ulwakuva vilikuvutwala pa vuhighi na mu masinagogi, vilikuvatova. kange vilikuvatwala pa vanjagila na pa vatwa, ulkwakuva mukumbingilila une. Ughuo ghuuva ghwe nsiki ughwa kwoleka ulwitiko lwinu ku veene. ");
INSERT INTO wbi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Imhola inofu umpaka jipulisivue mu iisi sooni, uvusilio ye vukyale kufika. ");
INSERT INTO wbi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“ Pano viliiva vavakolile na kukuvatwala pa vuhingi, namungasaghaghe kuuti kyamujova kiki, umue mujovaghe kino mupelua unsikki ughuo. Ulwakuva namwmue muuva mujova, looli iiva ghwe uMwimike. ");
INSERT INTO wbi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Umuunhu ikumwohelagha unnine ku vanya vutavulilua kuuti abudue. Uviise ikumwohegha, voope avaana vikuvagalukilagha avapaafi vaave kuuti vabudue. ");
INSERT INTO wbi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Avaanhu vooni vilikuvakalilagha ulwakuva mukumbingilila une. Neke juno ikuguda kuhanga kufika kuvusililo, ujuo ghwe alakuluka.” ");
INSERT INTO wbi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ Neke mulaava muvwene ikiinu kino kipelela uvulamafu inyumba inyimike ija kufunyila, kyimile pavwimike pano nakinakinoghile kuuva, ");
INSERT INTO wbi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","juno ikwimba amasio agha alutang`haniaghe, apuo pepano vano vali mu Yudea vakimbililaghe ku fidunda. Juno ali pa kituvili, naangikaghe kutoola kimonga mu nyumba jaake. ");
INSERT INTO wbi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ghwope juno ali ku mughunda, naangagomokaghe ku kaaja kutoola umwenda ghwake. ");
INSERT INTO wbi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Iga avakijuuva vano viliiva vakunue na vano vilikwong`helesyagha ifighono ifio! ");
INSERT INTO wbi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lino, mufunyaghe kuuti isio sileke pikwisa amasiki agha ulusiku. Lino, mufunyaghe kuuti isio sileke pikwisa amasiki agha fula ni mhepo. ");
INSERT INTO wbi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kweluliiva ulupumuko luno nalughelile kuvoneka kuhuma uNguluve ipela iisi, kuhanga kufika umusyughu. Kane nalulavoneka lusiku. ");
INSERT INTO wbi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nave uMutwa uNguluve naikepusia ifighono, ifio nakwale ughwa kukuluka. Neke vwimila avasalulua vaake, ilikepusia ifighono ifio. ");
INSERT INTO wbi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Unsiki ughuo umuunhu angati, 'Lola! Ukilisite ali apa.' nambe 'Ali kula,' namungikitaghe. ");
INSERT INTO wbi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ulwakuva vavili va vudesi. Avuo vihufyagha ifivalilo ni fidegho kuuti vavasofie avaanhu nambe avasalulua va Nguluve. Lino, ume muvisaghe maaso. ");
INSERT INTO wbi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ulwakuva nivavulile sooni, ye sikyale pikwisa.” ");
INSERT INTO wbi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Neke ifighio siliiva sikilile imhumuko isio, 'ing'hiisi jilakupikila ilijuva, naghu mwesi naghulavala. ");
INSERT INTO wbi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Inhondue silasanguka kuhuma,' ni fiinu fyoni ifya kukyanya filasukanika. ");
INSERT INTO wbi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“ Pepano valambona une ne Mwana ghwa Muunhu nikwisa mu mafunde ni ngufu nyinga nu vuvaha. ");
INSERT INTO wbi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Neke nilavasuung'gha avanyamhola vango, vavakong'hanie avasalulua vango, kuhuma imbale sooni isa iisi. ");
INSERT INTO wbi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mumanyilaghe ikihwanikisio ikya mpiki untini. Pano inhaafi saake silemba na kuuva na matundu, makagulaghe kuuti amasiki gha fula ghali piipi. ");
INSERT INTO wbi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Fye lulaava, muliiva mukusivona sino noliike sivombeka, mukagulaghe kuuti nili piipi kukwisa. ");
INSERT INTO wbi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kyang'haani nikuvavuula niiti, ikisina iki nakilakila kuhanga isi sooni sivombeke. ");
INSERT INTO wbi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Uvulanga ni iisi filakila, looli amasio ghano naghalakila. ");
INSERT INTO wbi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Neke ikighono nu nsiki ughwa kwisa une ne Mwana ghwa Muunhu, nakwale juno akagwile ambe avanyamhola kukyanya, nambe juune ne Mwana, looli ju Nhaata. ");
INSERT INTO wbi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muling'haniaghe, kange muvisaghe maaso, (ulkakuva namukagwile: unsiki ughuo ghuliva liighi). ");
INSERT INTO wbi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lulaava ndavule umuunhu juno ikyula, ikujileke ikaaja jaake mu mavoko gha vavombi vaaka na kukuvapeela nujunge imbombo jaake. kange ikum'buula juno ilolelela pa mulyango kuuti avisaghe maaso. ");
INSERT INTO wbi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lino, umue mmuvisaghe maaso, ulwakuva namughukagwile unsiki ughwa kugomoka unya nyumba, pamo aliisa vwilile nambe kilo nkate, pamo pano kuhenga nambe lwakilo. ");
INSERT INTO wbi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Muvisaghe maaso kuuti alavang'hulania mughoneliile. ");
INSERT INTO wbi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sino nikuvavuula umue, nikuvavuula vooni. Muvisaghe maaso!” ");
INSERT INTO wbi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Filyakyale ifighono fivili kuuva kyimikke kya pasaka na makete ghano naghavikilue ikilule, avanaha va vatekesi na vavulanisi va ndaghilo, vakava vifilonda isila ija kunkola uYesu kisyefu kuuti vam' bude. ");
INSERT INTO wbi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Vakijovasyagha veene vakatisagha, “Nave tuuti tunkole ikighono ikyimike, avanhuu kyande vileeta amabaatu.” ");
INSERT INTO wbi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Uyesu alyale mu likaaja ilya Betania, mu nyumba ja Simoni juno ulutasi alyale ni buuba. Ye ikalile mu nyumba ijio ali pilia, akingila umukijuuva jumonga, akolile isupa ija livue inya mafuta amanofu agha kupakala agha ndalama nyinga. Akadindula isupa, pe akakung'hilila pa mutu ghwa Yesu kukumwimika. ");
INSERT INTO wbi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Avaanhu vamo vano pwevalyale vakakalala, vakijovasyagha vakatisagha, “Lwaki kunangania amafuta amanofu agha? ");
INSERT INTO wbi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ulwakuwa ghaale ghighusivua indinali filundo fitatu na kukila, neke indalama isio saaale sikuvatanga avakotofu.” Pe vakan' dalikila umukijuuva jula. ");
INSERT INTO wbi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","UYesu akati, “'Muleke, kiki mukun'gasia umukijuuva uju? Ambombiile imbombo inofu. ");
INSERT INTO wbi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Avakotofu muli navoope jaatu, munoghiile kukuvatanga unsiki ghwoni. Neke une, nanili numue ifighono fyoni. ");
INSERT INTO wbi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Umekijuuva uju ambombiile vunofu mu fino aveele nafyo, apakile amafuta um' bili ghwano kukughuling' hania kusyilua. ");
INSERT INTO wbi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kyang'haani nikuvavuula niiti, pano iMhola iNofu jipulisivua mu iisi, naji mbombo jino avombile umukijuuva uju' jijovwagha. Mu uluo vikunkumbukagha umukijuuva uju.” ");
INSERT INTO wbi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pepano uYuuda Isikalioti, umo mu vasung' hua vala kijigho na vavili, akaluta ku vanah va vatekesi kuuti amwohele uYesu ku veene. ");
INSERT INTO wbi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Voope ye vapuliike, vakahovoka kyongo, vakamulagha kukumpeela indalama. Pepano uYuuda Isikalioti akatengula kulonda unsiki unno ughwa kumwohela uYesu. ");
INSERT INTO wbi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ikighono ikya kwanda ikya kyimike kya makate ghano naghavikilue ikilule, pano vakabudagha ing' holo ija kyimike kya pasaka, avavulanisivua va Yesu vakamposia vakati, “Ghulonda tukuling'hanikise kuughi ukwa kuliila ikyimike ikya pasaka?” ");
INSERT INTO wbi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pepano uYesu akavomola vavili nkate mu vavulanisivua vaake akati, “Mulute ku likaaja ilivaha ilya Yelusalemu, mu sila mutang'hana umukinhaata itwikile ulusaaji lwa malenga. Ujuo ghwe mum'bingililaghe. ");
INSERT INTO wbi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kuhanga inyumba jino kyaikwingila. Apuo, mum'buule unya nyumba kuuti, 'UM'bulanisi iiti, kili kughi ikyumba ikya vahesia, pano panoghiile aliile ikyimike ikya Pasaka, palikimo na vavulanisivua vaake?' ");
INSERT INTO wbi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Umweene ikuvasoona ikyumba ikya ku gholoofa, ikyeleefu kino kinosivue. Mutuliang'hanikisie umuo.” ");
INSERT INTO wbi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Avavulanisivua vala vakavuuka viluta ku likaaja ilio. Ye vafikile, vakasivonaa sooni ndaule uYesu aveele avavulile. Pe vakaling'hania ikyimike ikya pasaka. ");
INSERT INTO wbi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ye jifikile ivwilile, uYesu na vavulanisivua vaake kijigho na vavili vakafika mu nyumba jila. ");
INSERT INTO wbi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ye vali pilia, Yesu akati, “Nikuvavuula isa kyang'haaani, jumonnga mulyumue, ghwope ilia palikimo nuune, itapikunyohela.” ");
INSERT INTO wbi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Avavulanisivua vaake vakasukunala, nujunge akatengula kukumposia uYesu iiti, “Asi, neene?” ");
INSERT INTO wbi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","UYesu akati, “Umuunhu ujuo, ghwa mu kipugha kiinu umue kijigho na vavili mwe vano musaasa nuune unkate mu kivughaana. ");
INSERT INTO wbi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Une ne Mwana ghwa Muunhu nifua, ndavule lilembilue mu Malembe aMImike. Neke iga, umuunhu ujuo juno ikunyohela ne Mwana ghwa Muunhu! kiba umuunhu ujuo, ngale naaholwagha.” ");
INSERT INTO wbi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ye vali pilia, uYesu akatoola unkate akahongesia kwa Nguluve, akamenyulania, akavapeela avavulanisivua vaake akati, “Koogho, ughu ghwe m'bili ghwano. ");
INSERT INTO wbi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pe akatoola ikikombe ikya luhuuje, akahongesia kwa Nguluve, akavapeela, vakunyua vooni. ");
INSERT INTO wbi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akavavuula akati, “Iji je danda jango ija lufigo lwa Nguluve na vaanhu vaake, jino jikung'hika vwimila avaanhu vinga. ");
INSERT INTO wbi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kyang'haani nikuvavuula niiti, une nanilanyua kange uluhuujje ulu, kuhanga pano niliiva ninyua uluhuuje ulupia ku vutwa vwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","27","Pepano vakimba ulwimbo, pekavuuka viluta ku kidunda ikya Miseiyuni. Apuo uYesu akavavuula avavulanisivua vaake akati, “Ikilo ija musyughu umue mweni kyamukung'himbila, ulwakuva lilembilue mu Malembe aMimike, 'Nikuntova un'diimi, nasi ng'holo sipalasana.”. ");
INSERT INTO wbi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Akajova kange akati, “Neke niliiva nisiskyukile nilikuvalongolela kuluta ku Galilaya.” ");
INSERT INTO wbi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Upeteli akam'buula akati, “Nambe avange vooni vakuleke, une nanikukuleka!” ");
INSERT INTO wbi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","UYesu akamwamula akati, “Kyang'haani nikukuvuula, ikilo jijiiji ing'hongove ye jikya kuvika ulwa vuvili, uve ghuuva ung'hanile katatu.” ");
INSERT INTO wbi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","UPeteli akajova akakangasia akati, “une nanikukuleka lisiku, nambe kuuve kwe kufua palikimo nuve.” Voope avavulanisivua avange vooni vakajova vule vule. ");
INSERT INTO wbi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","UYesu na vavulanisivua vaake vafafika pamonga, panno pakatambulwagha Getisemani. Pe akavavuula avavulanisivua vaake akati, “Mukalaghe apa, pano une nikufuunya.” ");
INSERT INTO wbi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pe akantoola uPeteli, uYavovo nu Yohani, akaluta navoope pavulongolo padebe. Akatengula kusukunala kyongo na kutelateela. ");
INSERT INTO wbi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akavavuula akati, “Umwojo ghwano ghuli nu lusukunalo ulukome, ghunoghanogha mulwa kufua. Mukale bahaapa, muvisaghe maaso.” ");
INSERT INTO wbi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Umwene akaluta pavulongolo padebe, akapupama paasi, akifuunya kwa Nhaata kuuti, nave lunoghile, unsiki ughwa lupumuko ghuleke kukumwagha. ");
INSERT INTO wbi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akati, “Ghwe Nhaata, uve nakikutolile kimonga. NIsuuma umbusikisie ikikombe ikya lupumuko. Neke nakwekuti uvombe mu vughane vwango, looli mu vughane vwako.” ");
INSERT INTO wbi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ye ifunyile, akagomoka ku vavulanisivua vala, akavona vaghoneliile. Pe akam'buula uPeteli akati, “Simoni, ughoneliile? Ukunilue kuuva maaso nambe akavalilo kamo? ");
INSERT INTO wbi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pe akavavuula akati, “Muuve maaso, mufunyaghe kuuti ingelo sileke kukuvalema. Umwonjo ghutavwile, neke um'bili n'dwesi.” ");
INSERT INTO wbi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","UYesu akaluta kukufuunyu kange, akajova amasio ghala. ");
INSERT INTO wbi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ye ifunyile, akagomoka kange, akavona vaghonelile, ulwakuwa vaale ni tulu nyinga. Vakakunua ikya kujova. ");
INSERT INTO wbi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Akaluta ulwa vatatu kukufuunya. Ye agomwike, akavavuula akati, “Mujiighe mufighona na kupuuma? Lukwilile lino! Unsiki ghufikile ghuno une ne Mwana ghwa Muunhu nivikua mu mavoko gha vahosi. ");
INSERT INTO wbi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ima tulutaghe! Lolagha unya kunyohela ali piipi.” ");
INSERT INTO wbi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","UYesu ye ajiighe ijova navo, uYuuda jumo nkate mu vavulanisivua kijigho na vavili, akafika ni kipugha kya vaanhu vakolile ibamba ni mbunda. Avaanhu avuo valyasung'hile na vavaha va vatekesi, avavulanisi va ndaghilo na vagojo. ");
INSERT INTO wbi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","UYuuda umwohesi alyavavuliile ng'haani avaanhu vala ikivalilo ikya kummanya uYesu akati, “Juno kyanikunnonela, ujuo iiva ghwe mwene, munkolaghe, mulutaghe naghwo mu vuloleeli.” ");
INSERT INTO wbi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","UYuuda ye afikile uYesu akati, “'M'bulsnisi.” Akannonela. ");
INSERT INTO wbi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe avaanhu vala vakankola uYesu. ");
INSERT INTO wbi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Neke jumonga mu vano valyimile pala, akasomola ibamba, akankotova unkami ughwa ntekesi um'baha, akan'dumula imbulughutu. ");
INSERT INTO wbi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","UYesu akavaposia avaanhu vala akati, “Mwisile ni bamba ni mbunda kukung'hola une hwene nili mhijim'budi! ");
INSERT INTO wbi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ongo jaatu navisagha numue nivulanisia mu nyumba inyimike ija kufunyila, namwang'holagha! Lino isi sihumila kukwilanisia sooni sino silembilue mu Malembe aMimike.” ");
INSERT INTO wbi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Peano avavulanisivua vaake vooni vakamuleke, vakakimbilia. ");
INSERT INTO wbi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Neke unsoleka jumonga juno alitosisie isopeka akava ifikum'bingilila uYesu. Avalungu vala vakankola, ");
INSERT INTO wbi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","umwene akapukunyuka akaghuleka umwenda ghwake, akakimbila vufuula. ");
INSERT INTO wbi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pe vakantwala uYesu kwantkesi um'baha. Uko kwe vakakong'haana avavaha va vatekesi vooni, avagojo palikimo na vavulanisi va ndaghilo. ");
INSERT INTO wbi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","UPeteliakava ium'bingilila uYesu pa vtli. Pambel ghwopeakngila mu luviika ulwa nyumba ija ntekesi um'baha, akikala ikwota umwotolikimo na vasikali avalolelel. ");
INSERT INTO wbi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ppano avavaha va vateksi ni kipungha kya valogosi va Vayahudi vakava vilonda uvwolesi uvwa kumhingila uYesu kuuti vam'bude, neke navakaluvona lumonga. ");
INSERT INTO wbi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Avaanhu vinga vakolekagha isa vudesi vwimila umwene, neke uvwolesi vwave navukitng'hanagha. ");
INSERT INTO wbi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Vamo vakiima, vakoleka isa vudesi vakati, ");
INSERT INTO wbi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Usue tukampuliike umuunhu uji iiti, inyimike ija Nguluve jino jijengilue na vaanhu, neke mu fighono fitatu nijenga ijingi jin najijengua na vaanhu”. ");
INSERT INTO wbi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Vwope uvwolesi uvuo navukiting'hanagha. ");
INSERT INTO wbi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pepano untekesi um'baha akiima pakate pa vaanhu' akamposia uYesu akati, “Naghukwamula nambe lisio? Avaanhu ava vikwoleka kiki vwimila uve?” ");
INSERT INTO wbi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Umwene uYesu akajikala kimhihe, naakamula nambe lisio. Untekesi um'haba akamposia kange akati'”Uve veeve kili kilisite, Mwana ghwa Nguluve uMwimikua?” ");
INSERT INTO wbi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","UYesu akamula akati, “Eena, neene. kange mulambona ne Mwana ghwa Muunhunitemile palikimo nu Nguluve unya ngufu, nikwisa mu mafunde kuhuma kukyanya.” ");
INSERT INTO wbi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Untekesi um'baha ye apuliike amasio aghuo akakalala' akademula umwenda ghwake iiti, “Lino pe tulonda vwakiki uvwolesi uvunge? ");
INSERT INTO wbi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mupuliike ndavule ikuviika hwene Nguluve, ikumuligha kyongo uNguluve! Mwiti ndaani umuunhu uju?” Vooni vakamhigha kuuti anoghiile kubudua. ");
INSERT INTO wbi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Avange vakategungula kukumfunyila amati, vakan'dinda ku maaso, vakantova ni mbuli, vakamposia vakati, “Vila, veeni juno akutovile!” voope avasikali avaloleleli vakantoola, vakantova na mapi. ");
INSERT INTO wbi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","UYesu ye ali munkate, uPeteli akajiighe pa luviika. Pepano akiisa umhinja um'bombi ghwa ntekesi um'baha. ");
INSERT INTO wbi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Akamwagha uPeteli ikwota umwoto, akamulola akati, “Na juuve uveele lumo nu Yesu uMunasaleti!” ");
INSERT INTO wbi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","UPeteli akakaana akati, “Nanikagwile, kange nanisitang'hine sino ghujova!” Akahuma kunji ku luviika. Ing'hongove jikavika! ");
INSERT INTO wbi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Um'bombi jula akamwagha kange uPeteli, pe akavavuula vano pwevalyale pala akati, “Uju ghwe umo mu vala.” ");
INSERT INTO wbi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","UPeteli akakaana kange. Unsiki n'debe vuvule, avaanhu vano pwevalyale pala vakam'buula kange uPeteli vakati, “kyang'haani uve uli umo mu vala, ulwakuva uve uli N'galilaya.” ");
INSERT INTO wbi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Upeteli akaava ifikaana, akajiigha akati, “Kyang'haani umuunhu ujuo juno mujova, nanimmanyile!” ");
INSERT INTO wbi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Unsiki ghughuo ing'hongove jikavika ulwa vuvili. Apuo upeteli akakumbuka ilisio lino uYesu am'buula kuuti, “Ing'hongove ye jikyale kuvika ulwa vuvili, ghuuva ughuuva ung'hanile katatu.” Ye akumbwike uluo, akatengula pilila kyongo. ");
INSERT INTO wbi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Palwakilo ye kukiile, avavaha vateseki, avavulanisi va ndaghilo palikimo na vagojo, vakapuling'hana. Vakankunga uYesu, vakantwala kwa ntwa uPilato kuuti ahighue. ");
INSERT INTO wbi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Upilato akamposia uYesu akati, “Asi, uve veeve Ntwa ghwa Vayahundi?” UYesu akamwamula akati, “Uve ujovile.” ");
INSERT INTO wbi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Avavaha va vatekesi vakava vifikwoleka si nyinga isa kumpelela uYesu ahighue. ");
INSERT INTO wbi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","UPilato pe akamposia kange akati, “Kiki naghukwamula lumonga? Lolagha avaanhu ava vule vijova si nyinga isa kukuhigha.” ");
INSERT INTO wbi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","UYesu naalyamwile kimonga. Apuo uPilato akadegha. ");
INSERT INTO wbi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lwale lwiho kwa ntwa pa kyimike ikya Pasaka, kukun'dindululla uknkungua jumo juno avaanhu vasumile. ");
INSERT INTO wbi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kwealyale unkungua jumonga juno akatambulwagha Balaba. Umuunhu ujo alyakungilue palikimo na vaanhu avange, ulwakuva valyavombile uvugalusi na kubuda. ");
INSERT INTO wbi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Avaanhu vano valyakong'hanile vakava viluta kwa pilato kusuuma kuuti, avavombele ndavule lwale lwiho lwake pa kyimike ikya Pasaka. ");
INSERT INTO wbi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","UPilato akavaposia akati, “Mulonda nivadindulile untwa ghwa vayahudi?” ");
INSERT INTO wbi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","UPilato alyavaposisie uluo ulwakuva alyakagwile kuuti, avavaha va vatekesi valyale ni kivini nu Yesu, Fye nambe valyantwalile kwa mwene ahighue. ");
INSERT INTO wbi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Neke avavaha va vatekesi valyavafundile avaaanhu vooni kuuti, vansuume uPilato avadindulile uBalaba. ");
INSERT INTO wbi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Avaanhu vala ye vansumile, uPilato akavoposia kange akati, “Umuunhu uju juno mwiti ghwentwa ghwa Vayahudi, nim'bombe kiki? ");
INSERT INTO wbi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Avaanhu vooni vakoova vakati, “Unkomelele pa kikovekano!” ");
INSERT INTO wbi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","UPilato akavoposia kange akati, “Umuunhu uju avombile luviivi luki?” Aveene vakavaposia kukwova viiti, “Unkomelele pa kikovekano!” ");
INSERT INTO wbi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","UPilato akan'dindulila uBalaba, ulwakuva akalondagha pikulihovosia iipugha ilya vaanhu. pe akalaghaghia kuuti uYesu atovue ni mijeledi, ye atovilue, akavasikili vakankomelele pa kikovekano. ");
INSERT INTO wbi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Avasikali vakantwala uYesu mu luviika lwa nyumba ja ntwa, pe avasikali vooni vakakong'haana. ");
INSERT INTO wbi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Vakamfwasia isopeka indangaji ija kitwa, vakatenda ingeela ija mifua neke vakamfwika ku mutu. ");
INSERT INTO wbi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Vakatengula kukumhungila ni mbedo viiti, “Kamwne ghwa Vayahudi!” ");
INSERT INTO wbi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Vakava vikuntova ku mutu ni lilaasi na kukumfunyila amati. Kange vakafughamagha pa yesu na kukumwinamilia ni mbedo. ");
INSERT INTO wbi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ye vam'bedile na kukunnenela, Vakamfuula isopeka jila, vakamfwasia amenda ghaake, pe vakamhumia kunji, viluta kukunkomelala pa kikovekano. ");
INSERT INTO wbi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ye vali mu sila, vakatang'hana nu muunhu jumonga juno akatambulwagha simoni, umhuna mu likaaja ilya Kileeni, ikwingila mu Yelusalemu. Usimoni ujuo alyaye viise ghwa Alekisanda nu lufo. Avasikali vakamwumilisia kupinda ikikovekano ikya Yesu. ");
INSERT INTO wbi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pe vakantwala uYesu pano pakatambulwagha Goligota, kwekuti, “Ling'ala lya mutu.” Ye ");
INSERT INTO wbi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","vafikile, vakampeela uluhuuje uluhasing'hanie nu nkota kusilisia uvuvafi, umwene akasiita kunyua. ");
INSERT INTO wbi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Apuo vakankomelela uYesu, pa kikovekano, pe vakaghaana amenda ghaake mu sila js lusodolelo, kuuti nujunge atoole ghuliku. ");
INSERT INTO wbi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ye vikunkomelela uYesu, ghwale nsiki ghwa kavalilo kya vutatu palwakilo. ");
INSERT INTO wbi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pakyanya pa kikovekano vakakomelela ikitapa kino valyalembile amasio gha, “ghwe ntwa ghwa vayahudi,” kuvonia unkole ghuno valyam'balile. ");
INSERT INTO wbi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Palikimo nu mwene, valyavakomeliile avaanhu avange vavili vano valye vahijivabudi, jumonga akava ulubale ulwa kundio, ujunge kung'highi. ");
INSERT INTO wbi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Apuo silyavoniike sino silembilue mu malambe aMImike kuuti, “Alyavalilue palikimo na vahosi.” ");
INSERT INTO wbi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Avaanhu vano vakava vikila nakukumwagha uYesu pa kikovekano, vakasukaniagha amatu ghaave vikumuligha, viiti, “Uwe ghwe juno ghwatisagha ghulimemula inyumba inyimike ija Nguluve na kujenga mu fighino fitatu, ");
INSERT INTO wbi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ika lino pa kikovekano ghupoke! “UYesu pakikovekano! ");
INSERT INTO wbi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Voope avavaha va vetekesi na ndaghilo vakamwovelelagha vatatisagha, “avapokagha avange, neke ikunua kukupoka mwene. ");
INSERT INTO wbi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nave ghwe Kilesite, untwaghwa vaisilaeli, lino iike pa kikovekano, tulole neke twitike.” Voope vano vakakomelilue palikimo nu mwene vakava vikumuligha. ");
INSERT INTO wbi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ye ghufikile unsiki ghwa kavalilo aka ntanda pamwisi, ing'hiisi jikakupikila iisi jooni kuhanga kufika akavalilo aka budikalubale. ");
INSERT INTO wbi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Unsiki ugwa kavalilo aka budikalubale, uYesu akakoola fiijo akati, “Eloi Eloi, lama sabakitani?” Kwetuti, “Nguluve ghwango, Nguluve ghwango, ongo undekile? ");
INSERT INTO wbi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vamo nkate mu vano pwevalyale pala, ye vapuliike uluo vakati, “Pulisikia! Ikunkemeela um'bili uEliya! ");
INSERT INTO wbi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Umuunhu mumonga akaluta luvilo, akasuvika ikyenda mu luhuuje ulukali, akakiviika mu lulaasi, akam'besekesia uYesu pa mulomo kuuti amiime, akati, “Leka tulole, nave uEliya ikwisa kukumwisia pa kikivekano!” ");
INSERT INTO wbi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","UYesu akakoola fiijo, akakunguka. ");
INSERT INTO wbi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Unsiki ghughuo umwenda ghuno ghulyaghavinie pavili inyumba inyimike ija Nguluve, ghukademuka pavili kuhuma kukyana kufika paasi. ");
INSERT INTO wbi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Um'baha ughwa vasikali juno alyimile kilunge nu Yesu, ye am'bwene pano ikunguka akajova akati, “Kyang'haani umuunhu uju akaale mwana Mwana ghwa Nguluve!” ");
INSERT INTO wbi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ye sivombeka isi sooni, pwevalyale avakijuuva vano valyimile petali padebe vilola. Mu vakijuuva avuo mwealyale uMaliya umhuma mu likaaja ilya Magidala, uSalome nu Maliya ung'ina ghwa yoose nu Yakovo un'debe. ");
INSERT INTO wbi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ava vakam'bingililagha na pikum'bombela uYesu ye ali ku Galilaya. Kwevalanye na vakijuuva avange vinga vano valyalutile nu Yesu Ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Isi sooni savombiike ikighono ikya kuling'hania isabati. Ye vwilile, iSabati. jikyale pitengula, ");
INSERT INTO wbi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","akiisa uYosefu ughwa ku ALimataya, alyale mwoghopua mu kipugha ikya vahingi. Ghwope akaghululagha kukwisa uvutwa vwa Nguluve. Ujuo akikangasia, akaluta kwa pilato, akasuma um'bili ghwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","UPilato ye apuliike kuuti u Yesu afwile, akadegha kyongo. Akankemeela um'baha ughwa vasikili, akamposia kuutu uYesu ndaveele afwile kali. ");
INSERT INTO wbi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ye apuliike uluo, akantavulila u Yosefu um'bili ghwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","UYosefu akaghula umwenda ughwa kunsyilila u Yesu. Akisia um'bili pa kikovekano, akaghuniengelela nu mwenda ghula. Pe akaghuviika mu mbiipa jino jabughulilue mu linhalavue, akabilukisia ilivue ilikome pa mulyango ghwa mbiipa. ");
INSERT INTO wbi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","UMaliya umhuma mu likaaja ilya Magidala nu Maliya ung'ina ghwa Yoose, vakapaagha pano ghuvililue um'bili ghwa Yesu. Vibilusisia ilivue pa mulyango ghwa mbiipa. ");
INSERT INTO wbi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pakivwilile ye jisilile iSabahati, umhuma mu likaaja ilya Magidila, uSalome nu Maliya ung'ina ghwa Yakovo, vakaghula amafuta amanono kuuti vakaghupake um'bili ghwa yesu. ");
INSERT INTO wbi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ikighonoko ikya kwasia mu mulungu, palwakilo ilijuva ye lidibula, vakaluta ku mbiipa. ");
INSERT INTO wbi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ye vali mu sila vakijovasyagha veene viiti, “Veeni juno kyaikutuvusikisia ilivue lila pa mulyiango ghwa mbiipa? ");
INSERT INTO wbi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ilivue lyale likome kyongo. Ye afikile, vakavona ilivue libilusivue. ");
INSERT INTO wbi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Vakingila mu mbiipa, umuo vakamwagha unsoleka afwalile umwenda um'blafu, ikalile ulubale lwa kundio, pe vakakenyemuka kyongo. ");
INSERT INTO wbi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Umwene unsokela ujuo akavavuula akati, “Namungakenyemukaghe. Mukumulnda uYesu ughwa ku Nasaleti juno akomelilupa kikovekano? Asyukile, na pwale apa! Lola pano vakam'bikile. ");
INSERT INTO wbi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mulute muvavuule avavulanisivua vaaake, kyongo uPeteli kuuti, alongwile ku Galilaya. Uko muluta mukum'bona ndavule alyavavulile.” ");
INSERT INTO wbi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ye vapuliike isio, vakadegha na kutetema, vakahuma kunji, vakavuuka pa mbiipa vikimbila. Navakapanga kwa munhuunulwakuva vakava vikwoghopa. ");
INSERT INTO wbi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","UYesu ye asyukile palwakilo ikighono ikya kwasia mu mulungu, akihufia taasi kwa Maliya umhuma mu likiaaja ilya Magidala, juno alyam'busisie amapepo lekelalubale. ");
INSERT INTO wbi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","UMaliya akaluta kukuvapangila vano vakam'bingililagha uYesu, unsiki ughuno vakajiighe vasukuniile, vilila ifiua. Ye ");
INSERT INTO wbi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","vapuliike kwa Maliya kuuti uYesu mwumi, kange am'bwene, navakitika' ");
INSERT INTO wbi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pambele, uYesu akihufia ku vavulanisivua vavili mu kihwani ikingi. Avavulanisivua avuo valyahumil ku Yelusalemu, vakalutagha ku kikaaja ikya pa vupiipi. ");
INSERT INTO wbi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Voope vakaluta vakavapangila avajanave, pooope navakitika. ");
INSERT INTO wbi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kange, uYesu akihufia ku vavulanisivua kijigho na jumo, unsiki ughuno vakava vilia. Akavadalikila ulwakuva valyale kukwitika uvwolesi vwa vano valyam'bwene ye asyukile. ");
INSERT INTO wbi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pepano uYesu akavalaghila avavulanisivua vaake akati, “Mulutaghe muiisi jooni mupulisayaghe iMhola iNofu ku vaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Juno ikwitika na kukwofughua, ujuo alakuluka. Neke juno naikwitika, alahighua. ");
INSERT INTO wbi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kange vanoviitike, vivombagha ifidegho ifi: mu litavua lyano vidagagha amapepo, kange vijovagha mu njovele imhia. ");
INSERT INTO wbi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Vangakole injoka, nambe vanganyue inyambikila, navangafue. kange vivikagha amavoko ghaave pa vatamu, avatamu visokagha.” ");
INSERT INTO wbi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","UMutwa uYesu ye ajovile navo, pe akatolua kuluta kukyana, akava nuvutavulilua palikimo nu Nguluve. ");
INSERT INTO wbi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pepano avavulanisivua vaake vakalutagha kupulisia kwoni iMhola iNofu. UMutwa akavombagha imbombo palikimo na veene, akavapelagha ingifu isa kuvomba ifidegho fino fyale fivalilo kuhufia kuuti iMhola iNofu jino vipulisia ja kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","kulyuve mwoghopua Tiofilo avaanhu vinga valembile imhola isa Yesu Kilisite ndavule silyavombike kulyusue. ");
INSERT INTO wbi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","valembile imhola isi ndavule tulyapangilue na vano valyalolile na maaso ghave, navano valyasipulisie kuhuma vuvutengulilo vwake. ");
INSERT INTO wbi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ulwakuva nilondile vunono uvwakyang'haani vwa mhola sa Yesu vuhuma vuvutengulilo lino najune nivwene lunono kukulembela isi sooni muvutavike. ");
INSERT INTO wbi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","neke ulukagule ulwakyang'haani lwa mbombo sino ukavulanisivue. ");
INSERT INTO wbi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","mu fighono fya Helode untwa ghwa Yudea, pwealyale untekesi jumonga juno alyale ikemelua Sakalia ughwa lukolo lwa Abia un'dala ghwake alyahumile muvaliive va Haluni, ni litavua lyake alyale ikemelua Elisabeti. ");
INSERT INTO wbi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","voni van valyale vagholofu pa maaso gha Nguluve amaghendele ghale ghasita kukuvapika mundaghilo sooni munjovele ja Mutwa. ");
INSERT INTO wbi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","neke navalyale nu mwana ulwakuva uElisabeti alyale mughumba na kukavalilo akuo voni vale vaghogholofijo. ");
INSERT INTO wbi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","lino lulyahumile kuuti uSakalia alyale nu Mhepo umwimike kuvutavike vwa Nguluve. akalutile nuvutavike vwa vutekesi kuhumila mu vutavike vwa ludimo lwake. ");
INSERT INTO wbi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","kwevulyale uvutavike uvwa kuvomba mu nyumba ja Nguluve veni umuunhu untekesi, veni idalikila akasalulua ikipugha akingila mu nhumba ja Mutwa akanyanya uvufumba. ");
INSERT INTO wbi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ilipugha lyoni lya vaanhu vakava vikufunya kunji ye vinyanya uvusumba. ");
INSERT INTO wbi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","unyaMhola ghwa Mutwa akamwumila na kukwiima ulubale lwa luvoko lwa ndia kufitekelelo kuno vinyanyila uvusumba. ");
INSERT INTO wbi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","uSakalia akoghopa ye alwaghile ulutetemo lulyamughwila. ");
INSERT INTO wbi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","neke unyaMhola akam'bula kuuti, ulekaghe pikwoghopa Sakalia ulwakuva ulufunyo lwako lupulikike. undala ghwako uElisabeti ikukuholela umwana ilitavua lyake ghukun'kemela Yohani. ");
INSERT INTO wbi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ghuliva nu lukelo na kuhovoka, na vinga vikuhovokela kuholua kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ulwakuva iliva nu vuvaha kuhuma kwa Mutwa ujuo nanganyisaghe nambe kimonga kino kighasia. looli ingufu sa Mhepo umwimike siiva nu mwene kuhuma pano ali mulileme lwa ng'iina. ");
INSERT INTO wbi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","na vaanhu vinga ava Silaeli ilikuvagomosiagha kwa Nguluve uMutwa ghwave. ");
INSERT INTO wbi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ujuo ilikumulongolela uMutwa mu ngufu nu mwojo ndavule alyale uEliya kusambania mu ngufu sa Mhepo uMwimike neve vano navikumwoghopa vighendagha muluhala lwa vano valweli. ikuvavombela ndiki kukuvavika kwa Mutwa avaanhu vano vaghelanisivue vwimila jake. ");
INSERT INTO wbi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","uSakalia akam'bula unyaMhola, “niwesia ndani kukagula ili? ulwakuva une nili nsehe nu n'dala ghwango na maka ghake ghali minga kyongo”. ");
INSERT INTO wbi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","unyaMhola akamwamula na kumb'ula, une nene Gabilieli, nejuno nikwima pavulongolo pa Nguluve. nisung'ilue kukuvuula, kukuletela iMhola inofu iji. ");
INSERT INTO wbi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kange lolagha, nungajove kinu ghuva kimie nungawesie kujova kuhanga ikighono kila pano isi siva sihumile. ulu lwe ulwakuva ukakunilue kukwitika amasio ghango ghano mu nsiki ghiva ghavombike. ");
INSERT INTO wbi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","lino avaanhu valyale vikumughula uSakalia. valyadeghile kuuti alyale itumila unsiki mwinga ku nyumba inyimike ja kufunyila. ");
INSERT INTO wbi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","neke ye ahumile kunji, akakunilue kujova navo. pe aveene vakakagula kuuti, luvonike lumonga mu nyuma inyimike neke umwene akava ihufia lumonga na mavoko. akajigha kinunu. ");
INSERT INTO wbi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ye fisilile ifighono fyakuvomba imbombo jakilekesi ayavukile kugomoka kunyumba jake. ");
INSERT INTO wbi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","pambele uSakalia akavuja kukaja kuhuma ku mbombo sake sakitekesi un'dala ghwake akava n'kunue, akifisa amesi ghahaano akajova. ");
INSERT INTO wbi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“ulwakuva lwe luno uMutwa ambombile une ye andolile kulughano lwoni kukumbusikisia isoni pa maaso gha vaanhu” ");
INSERT INTO wbi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ye ghufikile umwesi ghwa n'tanda pavukunue vwa Elisabeti uNguluve akatuma unyaMhola uGabilieli kuluta mu iisi ja Galilaya ilitavua ilinge Nasaleti, ");
INSERT INTO wbi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa mhinja juno akatambulwagha Maliya. kwa mhinja juno alyatunilue nu mughosi ilitavua lyake ghwe Yosefu. umuholua mukikolo kya Davidi nilitavua lya mhinja akakemeluagha ghwe Maliya. ");
INSERT INTO wbi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","unyaMhola ye afikile akati, “nikukuhungila uve ghwe juno usungukilue nu Mutwa, uMutwa alinuve; ");
INSERT INTO wbi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","amasio ghanyaMhola ghaka mangajisia kyongo mu mwojo ghwake na alyaghamanyile kiki unyaMhola ihungila hungila iji kidegho. ");
INSERT INTO wbi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","unyaMhola akam'bula “nungoghopaghe Maliya ulwakuva uNguluve akusungukile. ");
INSERT INTO wbi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","lolagha ghuva nu vukunue, ghupapagha umwana neke ghukun'kemelagha ilitavua ghwe Yesu. ");
INSERT INTO wbi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","iliva m'baha ikemeluagha mwana ghwa juno alikukyanya kyongo, uMutwa uNguluve neke ikumpelagha ikitengo kya vutwa kya Davidi uvuse. ");
INSERT INTO wbi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","itemagha uvutwa mu lukolo lwa Yakovo uvusila nakusila lusiku. ");
INSERT INTO wbi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","uMaliya akam'bula unyaMhola ili, iva ndani ulwakuva une nanighelile kuvwafuka nu mughosi ghwoghwoni? ");
INSERT INTO wbi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","unyamhola akamwamula akam'bula “uMhepo uMwimike ikwisa kulyuve. ni ngufu sa juno alikukyanya kyongo sikwisa kulyuve. pe lino umwimike juno iholua ikemeluagha mwana ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","lolagha ulukololuo uElisabeti alinuukunue vwa mwana mufighono fyake fya vughogholo, ughu ghwe mwesi ghwa n'tanda juno valyatile mughumba. ");
INSERT INTO wbi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ulwakuva kwa Nguluve nakwekili kino kimuulemile” ");
INSERT INTO wbi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","uMaliya akajova akati, une nilim'baanda ghwa Mutwa neke luuleke luve luve kulyune ndavule ujovile” pe pano unyaMhola akavuka iluta. ");
INSERT INTO wbi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ye fikikile ifighono nde filingi uMaliya avuka ng'haning'habi na kuluta ku iisi jimonga jino jale nyafidunda, ija Yudea. ");
INSERT INTO wbi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ukuo akingila mu nyumba ija Sakalia na kumwungila uElisabeti, ");
INSERT INTO wbi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","lino pe lulyahumile kuuti,” uElisabeti ye apulike uluhungilo lwa Maliya. umwana mu lileme akaomoka tomoka, neke uElisabeti ingufu isa Mhepo uMwimike sikamwisila. ");
INSERT INTO wbi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","pe akatengula pijova kungufu akati, “ufunyilue uve mukighavo kya vakijuuva najumwana juno alimulileme lyako afunyilue. ");
INSERT INTO wbi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","neke lulindani kulyune ungiina ghwa Mutwa lunoghile pikwisa kulyune? ");
INSERT INTO wbi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ulwakuva lolagha ye lupulikike mu mbughulutu sango ilisio lya kuhungila kulyuve umwana mulileme lyango atomwike nu lukelo. ");
INSERT INTO wbi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","neke afunyilue umukijuva jula juno alyitike kuuti vulyahumila uvya kyang'haani vwa sino alyavulilue kuhuma kwa Mutwa”. ");
INSERT INTO wbi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","uMaliya akati, inimbula jango jikunfunya uMutwa, ");
INSERT INTO wbi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","naghumwojo ghwango ghuvovwike mwa Nguluve umpoki ghwango. ");
INSERT INTO wbi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ulwakuva avulolile uvukotofu vwa m'banda ghwake umhinja. lolagha kuhuma mu fisina fyoni vikughonelagha nilifunyua. ");
INSERT INTO wbi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ulwakuva umwene unya sooni avombile sino mbaha kylyune. ni litavua lyake ilyimike. ");
INSERT INTO wbi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","uvukola vwake kuhuma ikisina ni kisina ku vano vikumwopa umwene. ");
INSERT INTO wbi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","avonisie ingufu mu luvoko lyake avapalanisie vala vano vakighiniagha mu masaghe gha mooja ghave. ");
INSERT INTO wbi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","avisisie paasi avana va vatwa kuhuma mufitengo fyave ifya vutwa na kukuvatosia kukyanya vano vakotofu. ");
INSERT INTO wbi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","alyavapelile avanya njala ifinu ifi nono looli avamofu avadagile na mavoko gheene. ");
INSERT INTO wbi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ahumisie uvutangilisi kwa Isilaeli um'bombi ghake, neke akumuke kuvonesia uvuhugu. ");
INSERT INTO wbi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(ndavule alyajovile kuvanhaata vitu) kwa Abulahamu ni fisina fyake kuvusila na kusila” ");
INSERT INTO wbi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","uMalia alikalile nu Elisabeti hwene mesi ghatatu pepano akagomoka ku nyumba ja mwene. ");
INSERT INTO wbi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","lino unsiki ghulyafikile ughwa Elisabeti kupaapa umwana un'dimi. ");
INSERT INTO wbi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","avabading'ani vake na vanyalukolo vake valyapulike ndavule uMutwa atupelanisie mu vuhugu vwake, kange vakahovoka palikimo nu mwene. ");
INSERT INTO wbi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","lino kilyahumile ikighono kya lekela kwoni valisile kukivungo najumwana lulyanoghile vampele ilitavua lyake ghwe Sakalia kulwiho lwa vise. ");
INSERT INTO wbi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","looli ung'ina akamula akati, “ndali” ikemelua ghwe Yohani” ");
INSERT INTO wbi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","vakam'bula napwale nambe jumo mulukolo juno itambulua ku litavua ili” ");
INSERT INTO wbi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","pe vakam'bombela ikimanyilo uvise kuuti, umwene iti ilitavua akemelue veni. ");
INSERT INTO wbi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","uvise akalonda ikisegho akalemba “ilitavua ghwe Yohani” voni vakadegha ku ili ");
INSERT INTO wbi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ku kenyemukila umulomo ghake ghukadinduka nu lumili lwake lukava vuleka akajova na kukumughinia uNguluve ");
INSERT INTO wbi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","uludwesi lukavisila voni vano valikalile pipi navoimbombo isio sikakwilana mu iisi jooni ja fidunda fya Yudea, ");
INSERT INTO wbi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","na voni vano valyaghapulike vakaghagadilila mu mwoojo ghave, vakati umwana uju ghwa ndani ndani?” ulwakuva uluvoko lwa Mutwa lulyale palikimo naghwo. ");
INSERT INTO wbi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ivise ghwa Sakalia akapeluula ingufu nu Mhepo uMwimike akatengula kuhumia uvuvili akatisagha, ");
INSERT INTO wbi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","aghinwaghe uMutwa, uNguluve ghwa Isilaeli, ulwakuva atangile kange na kukuvavanga avaanhu vake. ");
INSERT INTO wbi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","atupelile uvupoki kuhuma mu nyumba ja nyambombo ghwake u Davidi, kuhuma mukikolo kya m'bombi ghwake uDavidi. ");
INSERT INTO wbi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ndavule alyajovile mumulomo ghwa vavili vake vano kwevalyale kuhuma kuvukuulu. ");
INSERT INTO wbi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","alatupoka kuhuma kuvalugu viitu na kuhuma mumavoko ghavaanhu vooni vano vikutukalalila. ");
INSERT INTO wbi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","alavomba ndiki kuvonesia ulusungu kuvanhaata vitu na kukumbuka ululaghilo lwake ulwimike. ");
INSERT INTO wbi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ulujigho luno alayjovile kwa Abulahamu unhaata ghwitu. ");
INSERT INTO wbi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","alyajighile na kunkangasia kuuti lunoghile pikum'bombela umwene kisila vwoghofi pano tupokilue pihuma mumavoko ghavalugu viitu. ");
INSERT INTO wbi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","muvwimike na muvagholofu uvwakyang'haani pa maaso ghake ni fighono fyake fyoni. ");
INSERT INTO wbi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ena, najuve mwana ghukemeluagha uli mb'ili ghw ajuno ali kukyanya fiijo ulwakuva alyaghendelelagha ku maaso ghwa Mutwa kuuti ikuvavonesia isila. neke kukunosekesia isila avaanhu pano ikwisagha umwene. ");
INSERT INTO wbi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kukuvavula avaanhu vake kuuti valapyanilwagha valavuvunagha uvupoki kusila kusila ja vupoki vwa nyfi saave. ");
INSERT INTO wbi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ili lilyahumile ulwakuva ja lusungu lwa Nguluve ghwitu ulwakuva ilijuva kuhuma kukyanya likutwisila. ");
INSERT INTO wbi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kukutumulikila ku vano vikalile mu ng'isi nu lumwighighi ghwa vafue alavomba ndiki kulongosia amaghulu ghitu kusila ja lutengano.” ");
INSERT INTO wbi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","lino umwana jula akakula na kuva nyangufu mwa Mhepo uMwimike. alikalile kulihaka kuhanga unsiki ghuno akavonekagha ku vaSilaeli. ");
INSERT INTO wbi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","lino mu fighono ifyo, jilyahumile kuuti, uKaisali Agusito akahumisie ululaghilo kuuti, vatole uluvalilo lwa vaanhu vooni vanovikukala mu iisi. ");
INSERT INTO wbi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ulu lulyale lwe luvalilo lwa kwanda luno lulyavombike unsiki ghuno uKileoli alyale m'baha gha Silia. ");
INSERT INTO wbi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","neke umuunhu ghweni akaluta kumpulo ghake kukulembekesia uluvalulo. ");
INSERT INTO wbi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ghwope uYosefu alyavukile mu mpulo ghwa Nasaleti ukuo ku Galilaya na kukyulalila ku Yudea ku mpulo ghwa Betelemu, ghuno ghukagulika hwene mpulo ghwa Davidi, ulwakuva jikahumile mu lukolo lwa Davidi. ");
INSERT INTO wbi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","akaluta kula na kujilembekesia nu Maliya, juno alyale antuunile kange alyale ihuvila umwana. ");
INSERT INTO wbi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","lino jilyahumile kuuti, ye valyale kula unsiki ughwa kuhola ghukafika. ");
INSERT INTO wbi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","akahola umwana un'dimi, umuholua ghwake ughwa kwanda, akamun'yengelela umwana namenda neke kunsigha ni mhepo. pe akam'bika mikivagha kya kulisikisia ifidimua, ulwakuva napwelukale ulubale lwa kum'bika mu numba ja vaghesi. ");
INSERT INTO wbi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ku lubale uluo kwevalyale avalongosi vano valyale vikukala mu maghunda kulolelela amapugha gha ng'olo ave pakilo. ");
INSERT INTO wbi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","kukenyemukila unyaMhola va Mutwa akavahumila nu vwimike va Mutwa vulyang'alile kuvasyungutila, pe valyale nu vwoghofi kyongo. ");
INSERT INTO wbi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","pepano unyaMhola akavavula, “namungoghopaghe, ulwakuva nikuvapela iMhola inofu isa lukelo uluvahaku vaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","umusyughu umpoki ghwinu aholilue vwimila jinu mu mpulo gha Davidi! umwene ghwe Kilisite Mutwa! ");
INSERT INTO wbi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","iki kye kivalilo kino mupelua, mukumwagha umwana vampinyile umwenda aghonile mu luvagha lwa kulisikisia ifidimua. ");
INSERT INTO wbi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","kukenyemukila kukava ni lipugha livaha lwa va sikali kuhuma kukyanya likalungine nunyaMhola ujuo kukumughinia uNguluve vakatisagha, ");
INSERT INTO wbi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“uvutwa vwa nguluve juno ali kukyanya fiijo nu lutengano luve mu iisi ku vaanhu voni vano anoghilue navo.” ");
INSERT INTO wbi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","lulyale kuuti avanyaMhola ye vavukile na luluta kukyanya, avalongosi vakajofesania vavuo ku vavuo, “tuvuke lino ku Betelemu kula tukalole kiki kino kihumile, kino uMutwa atumanyisie'. ");
INSERT INTO wbi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","vakaluta ng'hani ng'hani kula, neke vakamwagha uMaliya nu Yosefu, kange vakamwagha umwana aghonile mu luvagha lwa kulisikisia ifidimua. ");
INSERT INTO wbi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ye vavwene ndiki, vakavamanyisia avaanhu vala vano vakavulilue imhola sa mwana ghwa muunhu ");
INSERT INTO wbi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","voni vakadegha ye vapulike imhola isi ni kila kuno kikajovilue vadalikili. ");
INSERT INTO wbi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","neke uMaliya akaghendelela kusagha soni sino alyapulike, akaghavika mu mwoojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","avadalikili vakagomoka na kumwimika na kumpaala uNguluve wimila umuunhu ghweni kukino valyapulike na kukukyagha, ndavule jilyajovilue kuveene. ");
INSERT INTO wbi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","kyati kifikile ikighono kya lekela kwoni ghulyale ghwe nsiki ghwa kun'dumula umwana, vakankemela ilitavua ghwe Yesu; ilitavua lino alyapelilue nu nyaMhola jula ye na vuvukunue vukyale kutungwa mu lileme. ");
INSERT INTO wbi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","kuling'ana ni ndaghilo ja Moose, uYosefu nu Maliya akantwala kunyumba inyimike ja kufunyila ku Yelusalemu na kum'bika pavulongolo pa Mutwa. ");
INSERT INTO wbi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ndavule jilyalembilue mu ndaghilo ja Mutwa. “umukinhaata ghweni juno idindula ilileme ilikemelua juno avusikisivue uvuvaha kwa Mutwa”. ");
INSERT INTO wbi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","vope vulevule vakisile kuhumia ilitekelo kuling'hana na kila kinokijovua ku ndaghilo ja Mutwa,” vahumyaghe injiva ivili nambe inyaana ivili isa ng'unda”. ");
INSERT INTO wbi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","lola, palyaale nu muunhu ku Yelusalemu juno ilitavua lyake ikemelua ghwe Simoni. umuunhu uju alyale nya kyang'haani na kumwitika uNguluve. umwene alyale idalikila vwimila umuhuvilua ghwa Isilaeli, nu uMhepo uMwimike alyale nkyanya ja mwene. ");
INSERT INTO wbi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","jilyavonike kwa mwene kukilila uMhepo uMwimike kuuti umwene naale ifua ye akyale kumwagha uKilisite ghwa Mutwa. ");
INSERT INTO wbi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ikighono kimonga akingile mu nyumba inyimike ja H, akalongosivue nu Mhepo umwimike. pano avapafi vakamuletile umwana, uYesu ikum'bombela sino simunoghile jaatu mu ndaghilo, ");
INSERT INTO wbi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","pepano uSimoni akamwupila mu mavoko ghake na kumpaala uNguluve na kuuti, ");
INSERT INTO wbi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“lino nikum'bula untemi ghwako alute nu lutengano lwa Mutwa, kuling'hana ni lisio lyako. ");
INSERT INTO wbi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ulwakuva amaaso ghango ghavuvwene uvupoki vwako, ");
INSERT INTO wbi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","vuno vuvonike ku vaanhu voni. ");
INSERT INTO wbi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","umwene ghwe lumuli vwimila uvusyetulilo vwa iisi nu vwimike vwa vaanhu va Isilaeli. ");
INSERT INTO wbi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ubaba nu mama va mwana vakadegha ku sino sijovua kwa mwana ghwa vanave. ");
INSERT INTO wbi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","pepano uSimoni akavafunyila na akati kwa Maliya ung'ina ghwa mwene, “pulikisia vonono! umwana uju iiva vufumbue kwa kusova nambe kukwitika ku vaanhu vinga va ku Isilaeli kane ke kivalilo kino avaanhu vinga vilikujikana. ");
INSERT INTO wbi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kange lwe lubamba lunolulinyanya umwoojo ghako juve, neke kuuti amasaghe gha moojo gha vinga ghavoneke” ");
INSERT INTO wbi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","un'dala um'bili juno akemeluagha Ana kwealyale kunyumba inyimike ja kufunyila. umwene alyale mwalive gha Fanueli kuhuma kulukolo lwa Asheli. alyale na maka minga kyongo. akikala nu mughosi ghwake ku maka lekela lubale ye vatoline, ");
INSERT INTO wbi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","pepano akava mfwile ku maka fijigho lekela kwaoni na ghaane. nakaghelile kuvuka mu nyumba inyimike ija kufunyila alyale ighendelela kudinda na kunsuuma uNguluve pakilo na pamwisi. ");
INSERT INTO wbi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","nu nsiki ughuo, akisa pala panovalyale akatengula kumuhongesia uNguluve. akajova isa vaanha vooni vano vaghulagha uvupoki vwa Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ye vamalile avaanhu voni vakanoghile kuvomba kuling'ana ni ndaghilo ja Mutwa, vakagomoka ku Galilaya umpulo ghwave, Nasaleti. ");
INSERT INTO wbi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","umwana akakula, akava ni ngufu akongelela mu vukoola, nu vumosi vwa Nguluve vulyale pa kyanya jake. ");
INSERT INTO wbi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","avapafi vake amaka ghoni vakalutagha ku Yelusalemu vwimila ikikulukulu kya Pasaka. ");
INSERT INTO wbi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ya ale na maka kijigho na ghavili, kange vakisile mu nsiki ghuno ghunoghile ndavule uvutavike vwa kikulukulu. ");
INSERT INTO wbi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ye vajighe ifighono fyoni vwimila ikikulukulu vakatengula kugomoka kunyumba. neke un'dimi u Yesu akajighe kunsana ku Yelusalemu kisila avapafi vake kukagula ili. ");
INSERT INTO wbi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","vakasaghile kuuti valilumo mulipugha lya vano vakyulagha lumo, pe vakakyula ulukyusi lwa kighino pepano vakatengula kukumulonda mu vanyalukolo na vamanyani vave. ");
INSERT INTO wbi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ye vakunilue kumwagha, vakagomoka kuYelusalemu na kutengula kumulonda umuo. ");
INSERT INTO wbi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","jilyahumile kuuti mu fighono fitatu valamwagha mu nyumba inyimike ja kufunyila, akkali pakate pa vavulanisi akavapulikisia na kukuvaposia. ");
INSERT INTO wbi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","voni vano vale vikumpulikisia vakadegha ku vukagusi vwake nu lwamulo lwake. ");
INSERT INTO wbi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","vati vamwaghile, vakadegha ung'iina akam'bula, “mwanago kiki utuvombile ndiki? pulikisia une nu baba ghwako tulya tukulonda ku vwoghofi uvukome”. ");
INSERT INTO wbi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","akavaposia, “kiki mulyale mukunilonda? namukakagwile kuuti lunoghile kulyune kuva mu nyumba ja baba ghwango? ");
INSERT INTO wbi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","neke navakakagwile uluvumbulilo lwa masio aghuo. ");
INSERT INTO wbi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","pepano akaluta palikimo na veene kukaja ku Nasaleti, kange alyale mwitiki kuveene. ung'iina alyavikile sooni mu mwoojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","neke uYesu alyaghendelile kukula mu vukoola ni vugoyo nakughina kuva mughanike kwa Nguluve na vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","lino mu mwaka ghwa kijigho na ghahaano mu vutavulua vwa kaisali Tibelia, unsiki ghuno uPontio Pilato alyale ghavana ghwa vaYahudi, uHelode alyale m'baha ghwa vughavo a vwa Galilaya, nu Filipo unyalukola ghwake alyale m'baha ghwa vughavo vwa Itulea ni kya Tulakoniti, nu Lisania alyale m'baha ghwa vughavo vwa Abilene. ");
INSERT INTO wbi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","nu n'siki ghwa gha vutekesi uvukulu vwa Anasi nuKayafa, iliso lya Nguluve likamwisila uYohani umwana ghwa Sakalia ku lihaka. ");
INSERT INTO wbi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","akakyulile mu vughavo vwoni kusyuta ikikogha Yoldani, akidalikila ulwofugho lwa kulata vwimila ulusaghilo lwa vuhosi. ");
INSERT INTO wbi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ndavule jilembilue mu kilembe kya masio gha m'bili Yesaya kuuti,” ilisio lwa muunhu juno ali kulihaka” muvombaghe vunono mu sila ja Mutwa, muvombaghe vunono mu maghendele amagholofu. ");
INSERT INTO wbi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ifivonde fyoni filimemesevua, ifidunda fililimua, amasevo ghano ghabindile ghigholosivua, ni sila sino sili na manina sisyilua. ");
INSERT INTO wbi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","avaanhu voni vilukuvwagha uvuvangi vwa Nguluve” ");
INSERT INTO wbi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","pe uYohani akalivuula ilipugha ilikome lwa vaanhu vano vakisile neke vofughue nu mwene, mwe vaholua mu kisina kya njoka isinya miino makali, ghwe veni juno avasyovile kujikimbila ing'alasi jino jikwisa. ");
INSERT INTO wbi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","muholaghe imheeke inofu, kange namungajovaghe mu numbula sinu kuuti,' tulinaghwo uAbulahamu juno ghwe baba ghwitu, uNguluve iwesia kukumwimikisia uAbulahamu avaanha nambe kuhumilanila na mavue agha. ");
INSERT INTO wbi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","tayale inemo jivikilue pa lilela lya mpiki. pe amapiki ghoni ghano naghihola imheke inono, lidumulivua na kutaghua ku mwoto, ");
INSERT INTO wbi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","pe avaanhu mu lipugha vakamposia vakati, “lino lunoghile tuvombe ndani?” ");
INSERT INTO wbi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","akavamula akati, “ndeve umuunhu ali ni kanju ivili anoghile afule jimo kwa junge juno nsila namne jimo, na juno alinikyakulia ghwope avombe vule vule” ");
INSERT INTO wbi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","pepano avasongesia songo vamonga vakisile vope kukufughua, vakam'bula vakati, “m'bulanisi, lunoghile tuvombe ndani? ");
INSERT INTO wbi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","akavavula, “namugakong'aniaghe indalama fiijo kukila kino kinoghile kukong'ania. ");
INSERT INTO wbi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","avasikali vamonga vope vakamposia vakatisagha, “pe nusue? tunoghile tuvombe ndani?” akavavula akati,” namungatolaghe indalama kwa muunhu ghweni ku ngufu, namungahighaghe umuunhu ghweni ku vudesi. mukwilanaghe nu luhombo lwinu” ");
INSERT INTO wbi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","lino, ulwakuva avaanhu valyale nu lunoghelua ulwa kumughula uKilisite juno ikwisa, kila muunhu isagha mu mwojo ghwake kuva ndeve uYohani ghwe Kilisite. ");
INSERT INTO wbi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","uYohani akavamula vooni akati, “une nikuvofugha umue na malenga, neke kwale jumo juno ikwisa ali ni ngufu kukila une, kange naninoghile nambe kupinya ingoji sa filatu fyake. ikuvofugha umue ku mwoto ghwa Mhepo uMwimike. ");
INSERT INTO wbi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ilihelo lyake lili muluvoko lwake neke kupeeta vunono amasanji gha ngano na kujikong'ania vunono mu kihenge kyamwene. neke inyanya amasanji ku mwoto ghuno nambe naghusimika. ");
INSERT INTO wbi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","mu mbulanisio isingi nyinga alyadalikile imhola inofu ku vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","uYohani alyadalikile uHelode um'baha ghwa vughavo kwa kukuntoola uHelodia un'dala ghwa nyalukolo ghwake na kuvuhosi uvunge vwinga vuno uHelode alyavombile. ");
INSERT INTO wbi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","neke pambele kange uHelode alyavombile uvuhosi uvunge uvuvivi kyongo. akan'dindila uYohani mu ndinde. ");
INSERT INTO wbi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","pe lukahumile kang kuuti, unsiki avaanhu vooni valyale vikwofughua nu Yohani, ghwope uYesu kange akofughue. unsiki ghuno akale ikufunya ikyanya jikadinduka. ");
INSERT INTO wbi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","uMhepo uMwimike akika n'kyanya jaake ku kihwani kya m'bili hwene king'undya, nu n'siki ghughughuo ilisio likisa kuhuma kukyanya likatisagha, “uve veve n'swambango mughanike, uninoghiile kyongo une. ");
INSERT INTO wbi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","lino uYesu jujuo ati atengwile kuvulanisia, alyale na maka fijigho fitatu, alyale ghwe mwana{ndavule lukaghanilue ghwa Yosefu, mwana ghwa Eli, ");
INSERT INTO wbi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwana ghwa Matati, mwana ghwa Lawi, mwana ghwa Meliki, mwana ghwa Yana, mwana ghwa Yosefu, ");
INSERT INTO wbi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mwana ghwa Matatia, mwana ghwa Amosi, mwana ghwa Nahumu, mwana ghwa Esili, mwana ghwa Nagai, ");
INSERT INTO wbi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana ghwa Maati, mwana ghwa Semeni, mwana ghwa Yosefu, mwana ghwa Yuda, ");
INSERT INTO wbi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mwana ghwa Yonani, mwana ghwa Resa, mwana ghwa Selubabeli, mwana ghwa Seatieli, mwana ghwa Neli, ");
INSERT INTO wbi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana ghwa Meleki, mwana ghwa Adi mwana ghwa Kosamu, mwana ghwa Elimadamu, mwana ghwa Eli, ");
INSERT INTO wbi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana ghwa Yoshua, mwana ghwa Lieseli, mwana ghwa Yorimu, mwana ghwa Matai, mwana ghwa Lawi, ");
INSERT INTO wbi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mwana ghwa simoni, mwana ghwa Yuda, mwana ghwa Yosefu, mwana ghwa Yonamu, mwana ghwa Eliakimu, ");
INSERT INTO wbi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mwana ghwa Melela, mwana ghwa Meena, mwana ghwa matai, mwana ghwa Natani, mwana ghwa Devidi, ");
INSERT INTO wbi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana ghwa Yese, mwana ghwa Obedi, mwana ghwa Boasi, mwana ghwa Solomoni, mwana ghwa Nashoni. ");
INSERT INTO wbi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mwana ghwa Aminadabu, mwana ghwa Alamu, mwana ghwa Hesiloni, mwana ghwa Pelesi, mwana ghwa Yuda, ");
INSERT INTO wbi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana ghwa Yakovo, mwana ghwa Isaki, mwana ghwa Abulahamu, mwana ghwa Tela, mwana ghwa Nahori, ");
INSERT INTO wbi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana ghwa Selugi, mwana ghwa Ragau, mwana ghwa Pelegi, mwana ghwa Abeli, mwana ghwa Sala. ");
INSERT INTO wbi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mwana ghwa Kenani, mwana ghwa Alifakisadi, mwana ghwa Shemu, mwana ghwa Lmeki, ");
INSERT INTO wbi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana ghwa Metusela, mwana ghwa Kenani, ");
INSERT INTO wbi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana ghwa Enoki, mwana ghwa Seti, mwana ghwa Adamu, mwana ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","uYesu ye amemilue nu uMhepo uMimike, akagomwike kuhuma kukikogha ikya Jolidani, na Mhepo akamulongosia ku lihaka ");
INSERT INTO wbi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ku fighono fijigho fine, ukuo akagheluagha nu Setano. un'siki ughua nakalile kyokyoni, nu vusililo vwa n'siki ughuo injala jikatengula. ");
INSERT INTO wbi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","uSetano akam'bula akati,” ndeve uve uli mwana ghwa Nguluve, livule ilivue ili live nkate”. ");
INSERT INTO wbi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","uYesu akamwamula akati, “jilembilue; “umuunhu naiva nu vwumi kulia un'kate ghwene. ");
INSERT INTO wbi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","pe pano uSetano akamulongosia kukyanya kuvusililo vwa kidunda, na kukunsona uvutwa vwoni vwa iisi ku n'siki n'debe. ");
INSERT INTO wbi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","uSetano akambula akati.” nikupela uvutavulilwa vwa vutwa vwoni palikimo nu vunofu vwake”. niwesia kuvomba ndikio ulwakuva fyoni fitavulilwa kulyune, neke une nikumpela ghwoghwoni juno nighanile kukumpela. ");
INSERT INTO wbi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","pe lino, ndeve ungafughame na kukunyimika, ifinu ifi fyooni fiiva fyako”. ");
INSERT INTO wbi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","neke uYesu akamwamula akati, “jilembilue kuuti, umwimikaghe uMutwa uNguluve ghwako, kange um'bombelaghe umwene mwene”. ");
INSERT INTO wbi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","pambele uSetano akamulongosia uYesu kuhanga ku Yelusalemu na kukum'bika ulubale ulwa pakyanya fiijo pa nyumba inyimike ija kufunyila na kukum'bula, “ndeve uve uli mwana ghwa Nguluve, ghujitaghe paasi kuhuma apa. ");
INSERT INTO wbi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ulwakuva jilembilue, “ikuvalaghikisia avanyaMhola vaake vakusunge na kukulolela, ");
INSERT INTO wbi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kange vikukutosia ku kyanya mu mavoko ghave neke kuuti, nungalemasiaghe amaghulu ghako mu livue. ");
INSERT INTO wbi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","uYesu akamwamula akati, “jijovilue, nungamughelaghe uMutwa Nguluve ghwako”. ");
INSERT INTO wbi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","uSetano ye amalile kukumughesia uYesu, akamuleka alutaghe kuhanga un'siki ughunge. ");
INSERT INTO wbi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","pe pano uYesu akagomoka ku Galilaya ku ngufu sa Mhepo, ni mhola inofu sa mwene sikaluta na kupalasana mu fighavo iya vupipi fyoni. ");
INSERT INTO wbi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","akavulanisie mu nyumba saave isa kufunyila na vooni vakamughinia. ");
INSERT INTO wbi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ikighono kimonga akalutile ku Nasaleti, umpulo ghuno akusungilue na kukulia. ndavule vulyale uvuatavike, akingila mu nyumba ija kufunyila. ikighono kya Sabati, akimile na kukwimba amalembe amimike. ");
INSERT INTO wbi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","akapelua ikitabu kya m'bili Yesaya, pe akadindulila ikitabu na kulonda pano palembilue, ");
INSERT INTO wbi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","uMhepo ghwa Mutwa ali palikimo nune, ulwakuva akamakile amauta kudalikila iMola inou ku vakotofu anhumile kupulisia uvwavuke ku vano vali mundinde, nakukuvavomba vano naviloola vawesie kulola kange. kuvavika vwavuke vano vadidikilue, ");
INSERT INTO wbi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kukughupulisia u mwaka ghuno uMutwa ilivonesia ulusungu lwake. ");
INSERT INTO wbi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","pe baho akadinda ikitabu, akan'gomokesia umulongosi ghwa nyumba ja kukufinyila, akikala paasi. amaaso gha vaanhu vooni ghalyale pavulongolo ghikumulola umwene. ");
INSERT INTO wbi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","akatengula pijova navo akati, “umusyughu ililembe ili lifikile mu mbughulutu sinu”. ");
INSERT INTO wbi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","umuunhu ghweni pala akapulike kila kino akajovile uYesu, na vinga mu vanave vakadegha amasio gha vukoola ghano ghakahumagha mu mulomo ghwake. vakale viiti, “uju na ghwe n'swambe lwene ghwa Yosefu, na uluo?” ");
INSERT INTO wbi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","uYesu akavavula akati, “kyang'haani mulijova ulujovo ulu kulyune,” mughanga, ghusosie juve. kyokyoni kino kino ghwavombagha ku Kapelinaumu tupulike, vomba na pakikaja kyako”. ");
INSERT INTO wbi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","kange akati,” kyang'haani nikuvavula umue, nakwale um'bili juno vikumwitika ku isi jake” ");
INSERT INTO wbi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","neke nikuvavula umue ikyang'haani kuuti, kwevalyale avafwile vinga ku Silaeli mu n'siki ghwa Eliya pano kukyanya kukadindilue nakungavisaghe ni ula ku maka ghatatu na mesi ntanda, unsiki ghuno kulyane ni njala ing'ome mu isi jooni. ");
INSERT INTO wbi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","neke uEliya nakasung'ilue kwa muunhu ghweni, neke kwa mfwile jumo juno ikalagha ku Sarepapipi nu mpulo ghwa Sidoni. ");
INSERT INTO wbi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","kangekulyale na vakoma mufighono fya m'bili Elisha Isilaeli neke nakwealyale nambe jumo mu vanave juno akasosilue, looli u Naamani umuunhu ghwa ku Silia. ");
INSERT INTO wbi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","avaanhu voni vano valyale mu nyumba ija kufunyila ye vapulike aghuo vakava ni ng'alasi. ");
INSERT INTO wbi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","vakiima na kukumwumia kunji kulikaaja lyave, nakukumulongosia kuhanga kuvusililo vwa kidunda kya likaaja pano umpulo ghujengilue nkyanya jake, ");
INSERT INTO wbi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","neke vantaghe paasi. neke akakila vunono pakate pavo na kuluta. ");
INSERT INTO wbi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","pambele akikagha ku Kapenaumu, mulikaaja ilya Galilaya. Isabati jimonga jilyale jivulanisia avaanhu mu nyumba ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","vakadegha imbulanisio sake, ulwakuva akavulanisie kuvutavulua. ");
INSERT INTO wbi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","lino ikighono ikio mun'kate mu nyumba ija kufunyila, kulyale nu muunhu juno alyale ni lipepo ililamafu, akakoola kyongo, ");
INSERT INTO wbi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","tuli ni kiki nuve? ghwe Yesu mu Nasaleti? ghwisile kukututipula? nikagula uve veve veni! uve veve mwimike ghwa Nguluve” ");
INSERT INTO wbi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","uYesu akalidalikila ilipepo akati,” jigha kimie, na uhume kwa muunhu uju!” ilipepo lila lyati lin'taghile umuunhu jula pasi pakate javo, likahuma kwa muunhu jula kisila kumulemasia. ");
INSERT INTO wbi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","avaanhu vooni vakadegha na kughendelela kuku n'jovela ku ilio. vakatisagha,” ghe masio maki agha? akughadaga amapepo amalamafu ku vutavulua ni ngufu ghope ghivuka? ");
INSERT INTO wbi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","pe lino imhola inofu isa Yesu sikaghenda imbale sooni sino sisyunguta mukighavo ikio. ");
INSERT INTO wbi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","uYesu akavuka mulikaaja ilio pe akingila ku nyumba ja Simoni. lino un'kwivw gha Simoni akale ivavua imungu kyongo, vakampelepesia uYesu ansosie. ");
INSERT INTO wbi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","peeano uYesu akam'belelela akajidalikila imungu jila jikamulekesia, akima na kutengula kuvatengelela. ");
INSERT INTO wbi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ilijuva ye lisema, avaanhu voni valyale na vatamu avanga anmu sinosilipinga vakan'twalilagha uYesu. akavikagha amavoko pa kyanya pave, akavasosia voni. ");
INSERT INTO wbi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","kange amapepo ghakavahuma, vinga vakalilagha ku lisio na kuuti, “uve veve mwana ghwa Nguluve”. uYesu alyaghadalikila amapepo ghaleke pivoja. ulwakuva vakakagwile kuuti, umwene alyale ghwe Kilisite. ");
INSERT INTO wbi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","unsiki ghuno ye kukile, akaluta ulubale luno lusila vaanhu, ilipugha lya vaanhu valyale vikumulonda vakisa ku lubale luno pweakale umwene. vakaghela kukunsigha nangalutaghe kutali na vene. ");
INSERT INTO wbi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","neke akavavula akati,” lunoghile kange kudalikila imhola inofu sa vutwa vwa Nguluve mu makaaja aghange aminga. ulyakuva uluo lwe lwene nikasungilue apa. ");
INSERT INTO wbi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","pe pano akaghendelela kudalikila mun'kate mu nyumba ijakufunyila ku vaYahudi voni. ");
INSERT INTO wbi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","pe jilyahumile unsiki ghuno avaanhu vakan'kong'anikila na kun'syuta na kupulikisia ilisio lya Nguluve, pano alyale imile ulubale lwa kikogha kya Genesaleti. ");
INSERT INTO wbi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","akavona ifyombo fivili fifikile mulubale na malenga. vano visuvula vala valyahumile valyale visuka indovele save. ");
INSERT INTO wbi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","uYesu akingila mu kyobo kimonga kino kilyale kya Simoni akansuuma atwale mu malenga kutali padebe ni iisi indaghafu. pe ikala na kum'bulanisia kuhumila mu kyombo kila. ");
INSERT INTO wbi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","kujova akam'bula uSimoni akati, twala ikyombo kyako kuhanga mukilindi kya malenga na kukwisia indovelo sako neke kusuvua iswi” ");
INSERT INTO wbi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","uSimoni akamwamula akati,” Mutwa tuvombile imbombo ikilo jooni, natukolile kyokyoni, neke kulisio lyako, nikisisia indovelo. ");
INSERT INTO wbi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","vati vavombile nahele vakakong'anisie iswi nyinga na sindovelo save sikatengula kudemuka. ");
INSERT INTO wbi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","pe vakavakemhela avajanave neke viise kukuvatanga. vakisa vakamemia ifyombo fyave fyoni fyope fikatengula kusovelela. ");
INSERT INTO wbi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","neke uSimoni Peteli ati avwene ndikio, akaghua pamafundo gha Yesu akati, “Mutwa vuuka palyune, ulwakuva une nilinisambi” ");
INSERT INTO wbi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ulwakuva alyadeghisivue na voni vanovalyale palikimo nu mwene kuvusuvi vwa swi vuno vakavuvombile. ");
INSERT INTO wbi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ili likavakong'anisie uYakovo nu Yohani avaanha va Sebedayo, vano valyale vakong'aniki va Simoni. uYesu akam'bula u Simoni akati, “nungoghopaghe, ulwakuva kutengulila lino nakughendelela ghutengula kusuvula avaanhu” ");
INSERT INTO wbi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","vati vahumisie ifyombo fyave ku iisi indaghafu vakafileka na kumbingilila umwene. ");
INSERT INTO wbi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","jilyahumile kuuti ye alyafikile mu mpulo ghumonga, umuunhu juno alyale amemile uvukoma alyale ukuo. ati amwaghile uYesu, akasula misia umutu ghake paasi na kukufunya akati,” Mutwa nave ghunoghua, ghuwesia kunivalasia”. ");
INSERT INTO wbi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","pe pano uYesu akagholosia uluvoko lwake na kun'kola, akati,” nilonda kuvalasivua” nu n'siki ghula ghula uvukoma vukamuleka. ");
INSERT INTO wbi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","akamulaghisia nangam'bulaghe umuunhu ghweni, neke akam'bula kuuti, “lutagha juve ghwe mwene ukajivonesie kuvatekesi na kuhumia ilitekelo lwa kuvalasuvua, palikimo na kila kino uMoose akuvuli ku vujovi vwako. ");
INSERT INTO wbi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","neke imhola inofu sikaghenda kutali kyongo, ni lipugha likome ilya vaanhu likisa palikimo kumpulikisia ye ivulanisia na kusosia inhamu savo. ");
INSERT INTO wbi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","neke ke kinga ikukala kuvusyefu kukufunya. ");
INSERT INTO wbi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","kikahumile ikighono kimonga mu fighono fino alyale ivulanisia, pwevalyale avaFalisayi na vavulanisi vwa ndaghilo vano vakikalile apuo vano vakisile kuhumila mu fikaaja ifingi mu vughavo vwa Galilaya na ku Yudea kange kuhumila mu mpulo ghwa Yelusalemu. ingufu sa Nguluve silyale palikimo nave kunsosia. ");
INSERT INTO wbi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","avaanhu vamonga vakisile vampindile mu kitefu umuunhu juno v, pe vakalonda isila ja kumwingisia mun'kate neke kumughonia pavulogolo pa Yesu. ");
INSERT INTO wbi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","navaka jaghile isila ja kumwingisia mun'kate ulwakuva ilipugha lya vaanhu lilyale likome. pe vakatogha pakyanya pa lipaala lya nyumba na kumwisia umuunhu jula paasi kukilia mu figai pe vakavika pakate pa vaanhu pavulongolo pa Yesu. ");
INSERT INTO wbi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","lolagha ulwitiko lwako, uYesu akati, “nyalukolo usaghilue isambi sako” ");
INSERT INTO wbi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","avavulanisi na vaFarisayi vakatengula kuposia ilio. akaati uju ghwe veni juno ijova imbivi? ghwe veni juno isaghila isambi neke ghwe Nguluve mwene? ");
INSERT INTO wbi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","neke uYesu, akakagwile kiki vakale visagha, akavamula na kukuvavula,” ");
INSERT INTO wbi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","kiki mukuposesania mu mooja ghinu? kiliku kye kihugu kujova, 'isambi sako sisaghilue' au kuuti 'ghenda ulute?' ");
INSERT INTO wbi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","neke mukagule kuuti umwana ghwa muunhu ali nu vutavulua vwa kusaghila isambi mu iisi. nukukuvula uve, 'sisimuka utole ilitefu lyako ulutaghe ku nyumba jako ");
INSERT INTO wbi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","unsiki ghughuo akasisimuka pa vulongolo pa veeve, akatola ilitefu lwake ghuno akaghonile. pe akagomoka kwa mwene na kukumughinia uNguluve. ");
INSERT INTO wbi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","avaanhu voni vakadeghisivue na kumwimika uNguluve. vakamemilue nu vwoghofi vakatisagha,”tusaghile sino nasajaatu umusyughu” ");
INSERT INTO wbi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","pe lino ye ghahumile aghuo, uYesu alyahumile ukuo kuhuma ukuo na kukumwagha unsongesia songo juno akemeluagha Lawi ikalile ulubale lwa kusongekesia isongo, akavavula akati, “mbingilile” ");
INSERT INTO wbi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","pe uLawi akima na kumbingilila, akafileka ifinu fyoni kunsana. ");
INSERT INTO wbi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","pe uLawi akavika ku nyumba ja mwene ikikulukulu ikikome vwimila Yesu. pe valyale avasonesia songo vinga na vaanhu avange vinga vakikalile pamesa na pilia palikimo na veene. ");
INSERT INTO wbi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","neke avaFarisayi na valembi vaave valyale vikuvasukunalila avavulanisivua, vakati, “kiki mulia na pinyua na vasongesia songo palikimo na vaanhu avange avanya sambi?” ");
INSERT INTO wbi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","uYesu akavamula akati, “avaanhu vano va nu vwumi uvunono navanoghile kukumulonda umughanga, neke vala veene vano vatamu vevene vikumulonda umughanga. ");
INSERT INTO wbi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","nanikisile kuvakemhela avanya kyang'ani neke valate, looli kuvakemela avanya sambi vapate kulaata” ");
INSERT INTO wbi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","vakam'bula vakati, “avavulanisivua va Yohani ke kinga vitogha kukidunda na kusuma, avavulanisivua na vafarisayi vope vivomba vule vule. neke avavulanisivua vako vilia na kunyua” ");
INSERT INTO wbi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","uYesu akavavula akati, “jiwesekana umuunhu ghweni kudinda uvutolani kuvano vaghongolilue unsiki ghuno unyavutolani ajighe navo? ");
INSERT INTO wbi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","neke ifighono filikwisa unsiki ghuno unyavutolani vikum'busia ku veene, pepano mu fighono ifio ilidinda. ");
INSERT INTO wbi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","pe uYesu akajova navo kange ku kihwani akati,”nakwale umuunhu juno idemula ulubale lwa mwenda kuhuma mu mwenda umpya na kuhonela mu mwenda un'kulu. nave ivomba nahele, idemula umwenda umpya nu lubale lwa mwenda umpya nakwale kinoghela kuhonela mu mwenda un'kulu. ");
INSERT INTO wbi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","kange nakwale umuunhu juno ivika uluhuje ulupia mu supa ing'ulu, ndeve ivomba ndikio, uluhuje ulupia lwale lubajula isupa jila, nu luhuje lwale lukung'ika ni supa sale sibajuka. ");
INSERT INTO wbi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","neke uluhuje uupia lunoghile kuvika mu supa imia. ");
INSERT INTO wbi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","kange nakwale umuunhu juno alekile pinyua uluhuje ulupia neke anyue ulukulu, ulwakuva viiti ulwapakali lwe lunono kukila” ");
INSERT INTO wbi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","lino pa kighono kimonga ikya Sabati uYesu ava ikila pakate na pakate pamaghunda gha ngano neke avavulanisivua vake vakava videenya amasoojo gha ngano. ");
INSERT INTO wbi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","pepano avafalisayi vamonga vakamposia vakati “kiki muvomba ikinu kino nakinono ku ndaghilo kuvomba pakighono ikya Sabati?” ");
INSERT INTO wbi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","uY akavavula akati” namughelile pikwimba sino alyavombile uDavidi pano alyale ni njala. umwene nava kibaba vano valyale palikimo nave? ");
INSERT INTO wbi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","alyalutile kunyumba ja nguluve. akatola amakate amimike napilia ghamonga na nakuhumia kuvaanhu vano alile navoilisio nambe sale sesene kuvatekesi kulia. ");
INSERT INTO wbi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","neke uYesu akavavula kange umwana ghwa muunhu um'baha ghwe mwana ghwa Sabati. ");
INSERT INTO wbi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ikighono ikinge ikya Sabati akingila mu nyumba ija kufunyila na kukuvavulanisia avaanhu palyale umuunhu juno uluvoko lwake ulwa kundio lwale lufue. ");
INSERT INTO wbi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","avavulanisi na vafalisayi vakava vikumwuvila valole ndeponu ikum'buvusia umuunhu ikighono ikya Sabati. neke vapate ikipaghe kyakumuhigha uvusovi. ");
INSERT INTO wbi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","alyaghamanyile kuuti kinu kiki kino visagha napijova kwa muunhu juno alyafwile uluvoko. “sisimuka ghwime apa pakate na pakate pakila muunhu “akinuka na pikwima pala. ");
INSERT INTO wbi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","uYesu akajova navo “nikuvaposya umue kuvomba indamafu pakighono ikya Sabati? nambe tuuti kupoka uvwumi nambe kunangania? neke akavalola voni napikum'bula umuunhu, ");
INSERT INTO wbi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","gholosia uluvoko lwako, akavomba ndikio, nu luvoko lwake lukava luponile. ");
INSERT INTO wbi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","neke valyale ni ng'alasi neke vakapwepelanila vavuo ku vavuo kiki kino vavombe kwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","lulyahumile pa kighono alyalutile kukidunda kuufunya, akifunya pakilo na akifunya ikilo jooni kukufunya kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ye jifikile ilyakilo pe akavakemhela avavulanisivua vake kwa mwene akavasalula kijigho na vavili munkate mumuo avapeela ilitavua” vasung'ua” ");
INSERT INTO wbi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","amatavua gha vasung'ua alyale ghwe Simoni juno ilinge ghwe Peteli nu ndeleya unyalukolo ghwa Yakovo, nu Yohani, nu Filipo, nu Batulumayo. ");
INSERT INTO wbi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matai, Tomasi nu Yakovo umwana gha aluayo, uSimoni jono akatambuluagha nsaloti, ");
INSERT INTO wbi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda unkina ghwa Yakovo nu Yuda isikalioti juno alyamwahile uYesu ");
INSERT INTO wbi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","pe pano uYesu akikile navo kuhuma kukidunda na pikwima paluvindi ikipugha kya vavulanisivua vake kwevalyale ukuo palikimo imbalilo imbaha ja vaanu kuhuma kuvuYahudi na kuYelusalemu mulisumbe ilya Tilo ni Sidomi. ");
INSERT INTO wbi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","valisile kukumpulikisia na kusosivua vutamu vwake. avaanhu vakava vipumusivua na mapepo amalamafu. valasosivue voope. ");
INSERT INTO wbi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","umuunhu ghwo ghwoni kulukong'ano uluo vakamwabasia ulwakuva ingufu sa vupoki sikahumile kwa mwene alyavavusisie vooni. ");
INSERT INTO wbi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","pe pano avalola avavulanisivua vake akati, “mulivafunyua umue mwevakolofu ulwakuva uvutwa vwa Nguluve vwinu. ");
INSERT INTO wbi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","mulinulufunyo mwevano muli ni njaala lino, ulwkuva muliiseka. ");
INSERT INTO wbi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","mufunyilue umue mwevano avaanhu vikuvakalila na pikuvasula na pikuvaligha umue kuuti, mulivahosi; ulwakuva mukumwitika u mwana ghwa muunhu. ");
INSERT INTO wbi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","muhovokaghe ku kighono ikio na kukima mu lukelo. ulwakuva sakyang'haani muliiva nuluhombo ulukome kukyanya, ulwakuva avavise vavo valyavavombiile vule vule avavili. ");
INSERT INTO wbi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","neke iga mwevano mulivamofu! lino ulwakuva uluhuvilo lwinu mumalile kukwupila. ");
INSERT INTO wbi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","iga umue mwevano mukwite lino! ulwakuva mulivani njala. iga mwevano museka lino! ulwakuva mulipelepesi na kulila. ");
INSERT INTO wbi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","iga pano vikuvapala avaanhu voni! ulwakuva avavise vave valyavavombiile avavili vule vule avavili vavudesi. ");
INSERT INTO wbi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","neke nijova kulyumue mwevano mukumulikisia, muvaghanaghe avalugu viinu na pikuvavombela inono vano vikuvakalalila. ");
INSERT INTO wbi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","kange muvasumilaghe vano vikuvaghuna umue muvasumilaghe navano vikuvavonela. ");
INSERT INTO wbi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","kwa juno ikukutova uvudili ulubale ulwa kundio mulekela nu lubale ulwa kung'ighi nave umuunhu akupokile igwanda umpele najikanju. ");
INSERT INTO wbi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","umpelaghe juno ikukusuma. ndeve umuunhu angakukunye ikinu kino ukavile juve ulekaghe kuuti akugomokesie. ");
INSERT INTO wbi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ndeve mukela avaanhu vavavombele, najumue muvavombelaghe vule vule. ");
INSERT INTO wbi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ndeve mukuvaghana avaanhu vano vavaghanile umue mupelua uluvumbulilo luki kulyumue? ulwakuva na vavahosi vavaghanile vano vavaghanile. ");
INSERT INTO wbi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ndeve mukuvavombela inofu vala vano vikuvavombela umue amanofu. uluo luvumbulilo luki kulyumue? ulwakuva na vavahosi vikusivomba sisisio. ");
INSERT INTO wbi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","neke ndee mukuvakopesia ifinu kuvaanhu vano muhuviila kuuti vikuvagomokesia, uluo luli nu luvumbulilo luki kulyumue? nambe avahosi vikuvakopesia avahosi vajavo vihuvila kukwupila kila kila kange. ");
INSERT INTO wbi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","looli umue muvaghanaghe avalugu vinu kange muvavombelaghe inofu namungoghopaghe kuuti navikuvagomokesia, uluvumbulilo lwinu luuva luvaha neke muva vaanha va juno alikukyanya, ulwakuva jujuo mhuugu ku vaanhu vano vasila luhongesio kange vahosi. ");
INSERT INTO wbi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","muvisaghe nu lusungu ndavule uNhaata ghwinu vule ikuvasungukila avaavnhu vooni. ");
INSERT INTO wbi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","namungahighaghe, najumue namulihighua. mulekaghe pighuna, najumue namulighunua. muvasaghilaghe avange najumue alavasaghila. ");
INSERT INTO wbi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","muvapelaghe avange najumue muliplua ikighelelo kya vupeesi - kino kiking'iine, nakuseleleka - kikung'iika mumafundo ghinu ulwakuva ikighelelo kyokyoni kino mughelela kye kino mulagheleluagha najumue.” ");
INSERT INTO wbi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","pepano akavavula kukighwani,”kange umuunhu um'bofu amaaso ndeponu ikumulongosya um'bofu nine? nave fyesilivuo pe voni valevighwilila mu lina, ");
INSERT INTO wbi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","um'bulanisivua nangankile um'bulanisivua ghwake. neke juno amalile kuvulanisivua sooni iva ndavule um'bulanisi ghwake. ");
INSERT INTO wbi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","kiki ghulola ikibandi kino kili muliso lwa n'jako, ikipiki kino kili muliso lyako naghulola? ");
INSERT INTO wbi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","lwandani kukumb'ula un'jako, nyalukolo nisuma nikuvusie akabandi kano kalimuliso lyako; najuve naghulola ikipiki kino kili muliso lyako? ghwe n'kedusi uve! vusia tasi ikipiki kino kili muliso lwako neke pe ukukyagha vunofu ikibandi kino kili muliso lya n'jako. ");
INSERT INTO wbi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ulwakuva nakweghule um'piki unofu ghukoma imheke imbivi kange nakweghule um'piki um'bivi ghuno ghukoma imheke inofu. ");
INSERT INTO wbi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ulwakuva um'piki ghwoghwoni ghukagulika ifipeke fyake. navavanhu navidonola itini kumifua kange na vidonola isabibu kuhuma kulihanji lya mifua. ");
INSERT INTO wbi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","fye lulivuo umuunhu unofu ijova inono, kuhuma mu mwojo ghwake unono. najumuunhu um'bivi ijova imb'ivi sino sihuma mu mwojo ghwake. ulwakuva umulomo ghwake ghujova sino sili mu mwojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","kiki mukung'emela, “Mutwa, Mutwa ongo namuvomba ghanonijova? ");
INSERT INTO wbi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","umuunhu ghweni juno ikwisa kylyune nakupulika amasio ghango napikughavombela, nikuvasona vule alivuo. ");
INSERT INTO wbi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","iling'ana nu muunhu juno ajengile inyumba jake igima paasi fijo napijenga, peakala uvwalo vwa nyumba jake pavwalo uvukangafu. ifula ye jitonyile ilikavaga lya malenga ghakatonyela neke najikaghwile. ulwakuva alyajengile vunono. ");
INSERT INTO wbi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","neke umuunhu juno ipulika ilisio lyango kange naikulivingilila ikighwani kyake alindavule umuunhu juno ajengile inyumba palihanga pano pasila vwaalo ululenga lungapongole kukuhuta kwa ngufu inyumba jila jijughua jughua ooni. ");
INSERT INTO wbi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","pe baho uYesu ye amalile kila kinu kino akale ijova kuvaanhu vano vakampulikisiagha, akingilagha ku kapenaumu. ");
INSERT INTO wbi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","um'bombi jumonga ghwa Akida akale ghwa ndalama nyinga kyongo, alyale n'tamu kyongoakale pipi pifua. ");
INSERT INTO wbi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","neke ye apulike imhola sa Yesu uAkida jula akan'sunga umulongosi ghwa kiYahudi, kun'suuma ise kumpoka um'bombi ghwake aleke pifua. ");
INSERT INTO wbi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","vakati vafikile pipi nu Yesu, vakampelepesiagha vakatisagha, “anoghile kum'bombela ndiki umwene, ");
INSERT INTO wbi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ulwakuva ajighanile iisi jitu, ghwe mweene akajengile inyumba jitu ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","uYesu akaghendelelagha nu vukyusi vwake palikimo na vope. akatile alutile patali ni nyumba jila, um'bha juno akavasung'a avamanyani vake kujova nu mwene kuuti,”Ntwa uleke kujikatalila ghwemwene, ulwakuva une naninoghile uve kukwingila mu nyumba jango. ");
INSERT INTO wbi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ulwakuva nambe june nisaghile ne mwene kuuti, naninoghile kukwisa kulyuve ujove ilisio lyene um'bombi ghwango ye isokagha. ");
INSERT INTO wbi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ulwakuva na june nili muunhu juno ipulika ululaghilo lwa vavaha vango, najune nili navasikali vango. ningam'bule uju “luta” nu jjunge “ghwise” ikwisa naju m'bombi ghwango 'vomba iki ghwope ibomba” ");
INSERT INTO wbi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","uYesu ye apulike aghuo akadegha, pe akalisyetukila ilipugha lino likam'bingilile akati,” nikuvavula nambe mu va silaeli nanimwaghile umuunhu unya lwitiko lukome ndavule uju. ");
INSERT INTO wbi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","peepano vala vano vakasung'ilue vakagomoka kukaaja na kukumwagha um'bombi n'kafu. ");
INSERT INTO wbi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","pambele aghakatile ghahumile agha uYesu akava ikyulila ilikaaja lino likemhelua Naini. navavulanisivua vake vakalutagha palikimonu mwene vakahasing'anagha nilipugha lya vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ye alipipi nu mulyango ghwa mpulo un'kome lola, umuunhu juno afwile akava apindilue, umwana ujuo alyale mwene kwa mukijuuva jula, juno alyale mfwile. ilipugha ilikome kuhuma mumpulo ghula valyale palokimo numue. ");
INSERT INTO wbi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","akatile amwaghile uMutwa akam'belelela nu lusungu lukome akam'bula akati,” uleke pilila” ");
INSERT INTO wbi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","pe akalivelelela ilivokosi lino likapindile umfimba, akalyabasia, vano valyapindile vakiima akati, “ghwe nsoleka niti sisimuka” ");
INSERT INTO wbi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","umfue akasisimula na kukukala pasi nakutengula pijova. Peepano uYesu akampeela ung'iina umwanake ");
INSERT INTO wbi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","neke vooni vakamwoghopa vakaghendelela kukumughinia uNguluve viti, “Um'bili um'baha isile kulyusue” kange uNguluve avalolile avaanhu vake. ");
INSERT INTO wbi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","imhola isa inono isa Yesu sikakwiline imbale sooni isa Yudea na mu fighavo ifya pa vupipi. ");
INSERT INTO wbi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","uYohani akavulwagha na vavulanisivua ghoni agha. ");
INSERT INTO wbi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","pe uYohani akavakemhela avavulanisivua vake vavili, akavasung'a kwa Mutwa akati, “veve uve ghukwisa, neke kwale ujunge juno tumuhuvilaghe? ");
INSERT INTO wbi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ye vafikile pipi nu Yesu ava vakati,” uYohani umwofughi atusung'ile kulyuve atile,'uve veve ghukwisa, neke kwale ujunge tumuhuvilaghe? ");
INSERT INTO wbi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","unsiki ghula ghula akavasosia avaanhu vinga kuhuma mu nhaamu ni mhumhuko, kuhuma ku mapepo amalamafu, na kuvaanhu vano navilola akavapelagha kulola. ");
INSERT INTO wbi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","pe uYesu akavamula avene akati,” kumwande muva mulutile kuno muhumile mum'buulaghe uYohani sino musaghile na kupulika, avabofu vikwupilakulola, avakilemela vighenda, avanya buba vivalala, avanya mapule vipulika, avafue visyuka, na kuva vwumi. kange, avakotofuvivulua imhola inofu. ");
INSERT INTO wbi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","nu muunhu juno nabuhila kukunyitika une vwimila mumaghendele ghango afunyilue. ");
INSERT INTO wbi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","pambele ye vagomwike vala vano vakasung'ilue nu Yohani kuno vahumile, uYesu akatengula kujova isa Yohani ku lipugha akati,”muvele mulutile kunji kulola kiki, ililasi pano imhepo jisukania ililasi? ");
INSERT INTO wbi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","neke muvele kunji kulola kiki, umuunhu juno afwalile vunono? loola vala vano vifwala amhenda amanono agha vutwa na kukukala mu vwumi vwa lukelo, vali muvulugu vwa vutwa. ");
INSERT INTO wbi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","neke muluta kunji kulola kiki, m'bili? Ena, nijova numue kyongo kukila um'bili. ");
INSERT INTO wbi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","uju ghwe juno vakamulembile, 'Lola!, nukunsung'a umwomolua ghwango pavulongola pa maaso ghinu, juno itenda isila vwimila jango, ");
INSERT INTO wbi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","nijova kulyumue kuuti, “ku vala vano vaholilue nu n'dala, kusila m'baha ndavule uYohani, neke umuunhu juno asila vufumbue juno ilikukala nu Nguluve ulubale luno pwale, iliiva mb'aha kukilla uYohani” ");
INSERT INTO wbi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","avaanhu voni palikimo navasongesia songo, vakati vapulike aghuo vakapulisyagha kuuti, “uNguluve ghwe nya kyang'haani. pwevakale vano vakofughue ku lwofugho lwa Yohani. ");
INSERT INTO wbi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","neka avafalisayi na vavulanisi va ndaghilo sa kiYahudi, vano navofughue nu mwene vakasitile ulusungu lwa Nguluve vwimila javo veene. ");
INSERT INTO wbi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","kange ndeponu ihwananisia ni kiki avaanhu ava kisina kiki? vali ndavule vali ndani? ");
INSERT INTO wbi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","vahwanine na vaanha vano vinena kulighuliko, vanovikukala na kukemelana jumo nu junge vijova, 'tuvapulile ifilongilongi vwinaka namulilimila jinu, neke namusejile tusukunile neke namunenile. ");
INSERT INTO wbi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","uYohani umwofughi alisile na akalisagha unkate nambe kunyua uluhuje na mukati, “ali nilipepo. ");
INSERT INTO wbi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","umwana ghwa Muunhu alisile mulia kyongo kange mughasi mwiti,” manyani ghwa vasongesia songo kange vanya sambi. ");
INSERT INTO wbi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","neke uvukola vukagulike kuva vuli ni kyang'ani ku vaanha vake voni. ");
INSERT INTO wbi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","umufarisayi jumonga alyansumile uYesu alute kulia palikimo numwene. pe uYesu ye ungile mu nyumba ja Falisayi, akeghamila imesa jila neke alie. ");
INSERT INTO wbi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","lola kwealyale un'dala jumonga mulikaaja ilio juno alyale muhosi. akamanya kuuti ikalile kwa Falisayi, akaleta isupa ja mafuta amanono ghano ghinukilila. ");
INSERT INTO wbi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","akima nsana jake pipi na maghulu ghake kuno ilila. kange akatengula kunyopesia amaghulu ghake na masosi, na kupulusia ni linyele lwa mutu ghwake, kuno inonela amaghulu ghake na kupaka amafuta ghala ghano ghinukilila. ");
INSERT INTO wbi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","umfalisayi jula huno alyale amughongolile uYesu ati avwene ndikio, akasagha jujuo akati, “nave umuunhu uju asavisagha m'bili, ale ikagula uju ghwe veni kange ghwe n'dala ghwa ndani juno ikumwabasia, kuuti ghwe nya sambi. ");
INSERT INTO wbi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","uYesu akamwamula na kukum'bula, “simoni nili ni kinu kwa kukuvula, “akati, kijove mbulanisi' ");
INSERT INTO wbi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","uYesu akaati, “kwevalyale avaanhu vavili vano valyale visighilua ihela kwa jumonga juno alyavakopile. jumo asighiluagha idinali ifilundo fihaano nu ghwa vuvili asighiluagha idinali fijigho fihaano. ");
INSERT INTO wbi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","avaanhu ava ye va kunilue kuhomba, juno alyavakopile akavasaghila. lino mu avuo vano vano vakasaghilwagha, “aliku kya ikumughana kyongo? ");
INSERT INTO wbi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","uSimoni akamwamula akati, “nivona juno asaghilue kyongo”. uYesu akambula kuuti, “uhighile sesene”. ");
INSERT INTO wbi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","uYeu akansyetukila umukijuva na kujova kwa Simoni, “ghukumwagha umukijuva uju. ye ningile mu nyumba jako. numelile amalenga vwimila amaghulu ghango, neke uju, ku masosi ghake, ofwighe amaghulu ghango na kupulusia ni linyele lyake. ");
INSERT INTO wbi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","nukaninonile, neke umwene, kuhuma ikwingila muno nakalekile kukughanonela amaghulu ghango. ");
INSERT INTO wbi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","nukapakile amafuta mu maghulu ghango, neke apakie amaghulu ghango amafuta amanono ghano ghinukila. ");
INSERT INTO wbi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ku ulu nikukuvula kuuti alyale nu vuhosi vwinga kange asaghilue kukila, kange akanoghile kyongo. neke juno asaghilue padebe, ighana padebe lwene.” ");
INSERT INTO wbi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","pe pano uYesu akam'bula umukijuuva jula akati, “upyanilue infivi saako”. ");
INSERT INTO wbi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","neke vala vano vakikalile pa mesa palikimo nu mwnene vakatengula kukuposesania vavuo ku vavuo, “uju ghweveni kuhanga ipyanilua inyivi? ");
INSERT INTO wbi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","apuo uYesu akam'bula kange umukujuuva jula akati, “ulwitiko lwako lukupokile. ulutaghe nu lutengano”. ");
INSERT INTO wbi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","jilyahumile unsiki ndebe pambele kuuti, uYesu alyatengwile kukyula ku mapulo ni fikaaja inga, akidalikila na kupulisia imhola inofu isa vutwa vwa Ngulue na vala kijigho na vavili vakaluta palikimo naghwo, ");
INSERT INTO wbi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","vule vule na vavadala avange vano vakasosilue kuhuma mumapepo amalamafu ni namu nyinga. valyale ghwe maliya juno akemeluagha Magadalena juno vamwumisie amapepo lekela lubale. ");
INSERT INTO wbi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","uYoana un'dala ghwa Kusa nu m'baha ghwa Helode uSusana na vadala avange vinga, vano valyahmisie ikyuma javo vavuo. ");
INSERT INTO wbi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ye ilipugha lya vaanhu likong'anile palikimo, mwevalyale avaanhu vano vakisile kuhuma mumapulo minga akajova navo kwa kutumila ifihwani. ");
INSERT INTO wbi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","unyamughunda akalutile kuvyala imbeju kumughunda, pano akale ivwala imbej jimonga mu isio sikaghwila mu lubale lwa sila avaanhu vakakanya na maghulu, ni njuni sa kukyanya sikalia. ");
INSERT INTO wbi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","imbeju isinge sikaghwila mu lihanga ilyumu sati simelile nakuva mamela ghakaola ulwakuva nakulyale nu vunyefunyefu. ");
INSERT INTO wbi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","imbeju isinge sikaghila mu mapiki gha manfua, ghope amapiki gha manfua ghakakula palikimo ni mbeju sila sikamelelanila. ");
INSERT INTO wbi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","neke imbeju isinge sikaghwila mulihanga lino likanoghile kuhola imeto kijigho kukila. pe baho uYesu ye ajovile isio, akajova ilisio, “ghweni juno ali ni mbughulutu isa kupulika na apulike” ");
INSERT INTO wbi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","kange avavulanisivua vakamposia uvufumbue vwa kihwani ikio. ");
INSERT INTO wbi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","uYesu akavamula aakti, Mupelilue uughanike kukila kukagula ulufiso lwa vutwa vwa Ngulue, neke avaanhu avange vilivulanisivua kukihwani kwene, neke kuuti, 'vangalole navangalolaghe kange vangapulike navangakagulaghe'. ");
INSERT INTO wbi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","nu vu vwe vufumbue vwa kihwani iki. imbeju lwe lisio lya Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","imbeju sila sikaghwila mu lubale lwa sila ava ve vaanhu vano vipulika ilisio, neke pambele umuhosi uSetano itola kutli kuhuma mumwoojo, neke kuuti navangitikilaghe nambe kukagula. ");
INSERT INTO wbi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","kange na sila sinosikaghwila mu lihanga ilyumu ve vaanhu vala vano ikulipulika ilisio na kukulyupila ku lukelo neke vasila malela ghoghoni, vikwitika lwene ku nsiki n'debe nu n'siki ghwa ngelo vighua. ");
INSERT INTO wbi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ni mbeju sila sinosikaghwila mu manfua ve vaavhu vano vikulipulika ilisio, neke pano vighenelela kukula vikong'ana ni mbombele nu vumofu nu vunono vwa vwumi uvu neke navihola imheeke. ");
INSERT INTO wbi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","neke imbeju sila sino sikaghwila mu lihanga ilinono ve vaanhu vala vano ilutila kuvukoola na moojo ghave manono, pano vapulike ilisio vigadilila kange liva panono na kuhola imheeke sa lugudo. ");
INSERT INTO wbi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","lino nakwale nabe jumo juno ikinga itala na kukujikupikila ni bakuli nambe kukujivika paasi pa kitanda. kisila kuvika itala pakyanya neke kuuti unuubhu ghweni juno ikwingila apate kukujagha. ");
INSERT INTO wbi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ulwakuva nakwekili kino kikujifisa nakingakagulike, nambe kyokyoni kino kilimulufiso kino nakilikagulika kingave mulumuli. ");
INSERT INTO wbi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","pe lino uvisaghe maaso pano ghuva ghupulikisia. ulwakuva juno ali nakyo, kwamwene ikwongelesevua kukila, neke juno nsila nambe kidebe kila kino alinakyo kilipokua”. ");
INSERT INTO wbi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","pambele ung'iina ghwa Yesu na vanyalukolo vakisa kwa mwene navakavelelela ulwakuva ja lipugha lya vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","vakampela imhola kuuti “umama ghwako na vanyalukolo vako ali panji pala vilonda kukukwagha uve” ");
INSERT INTO wbi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","neke uYesu kavamula akati,” umama ghwango na vanyalukoo vango ve vala vano vikulipulika ilisio lya Nguluve na kukulyitika”. ");
INSERT INTO wbi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","jikahumile mu kighono kimonga mu fighono fila fino uYesu na vavulanisivua vaake akatogha u kyombo, akavavula,”tulovoke ku mwambo ja vuvili ja malenga lisiva/malenga” vakaling'anisia ikyombo kwave. ");
INSERT INTO wbi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","neke vakatengula kuvuka, uYesu akaghona tuulu, imhepo imbaha jikatengula na kuviika amavingo amavaagha mu lisumbe. amalenga ghakatengula kumema mu kyombo, vakava mu lutalamu ulwa kudwidivala kyongo. ");
INSERT INTO wbi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","pepano avavulanisivua vake vakisa kwamwene na kukunsisimula, vakatisagha, “Mutwa m'bha! Mutwa m'baha! tuli pipi pifua! akasisimuka na akajidalikila imhepo na mavingo gha malenga fikajigha kukava kimie. ");
INSERT INTO wbi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","kange akavavula, “ulwitiko lyinu lulikughi?” vakoghopa na kudegha, vakajofesania umuunhu ghweni nu junge, “uju ghwe veeni, juno idalikila na jimhepo na nagha malenga fyope fikun'kunda?” ");
INSERT INTO wbi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","vakafika kumpulo ghwa ghuno vaGelasi ulubale ulwa kunsana ghwa Galilaya. ");
INSERT INTO wbi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","uYesu ati ikile na kukanya pa lihanga, umuunhu jumonga kuhuma mu mpulo akatang'ana naghwo, nu muunhu uju alayale ni ngufu sa mapepo amalamafu. ifighono finga naakale kifyala amenda, kange akale naikukala mu nyumba, neke ikala ku mbiipa. ");
INSERT INTO wbi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ati amwaghile uYesu akalila ku lisio na kughua paasi pavulongolo jake. kulisio ilikome akati, nivombile kiki kulyuve, uYesu mwana ghwa Nguluve juno alikukyanya? nikusuuma nungamhumhusiaghe une” ");
INSERT INTO wbi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","uYesu akaaghavula amapepo amalamafu ghahume kwa muunhu jula, ulwakuva ke kinga ghakampumusiagha nambe kwe kuuti alyale ikungua ni nyololo na kubanua na kuvikua pavulolelesi, akadumulagha ifipinyua na kutwalua na mapepo amalamafu kuhanga kulihaka. ");
INSERT INTO wbi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","uYesu akamposia, “ilitavua lyako veve veeni? akamula akati, “Legioni” ulwakuva amapepo minga ghingile kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","vakaghendelela kukunsuuma nangatuvulaghe kuuti tulute kulina. ");
INSERT INTO wbi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ilipugha lya ngube lilyale lidimua kukyanya kukidunda, amapepo ghala ghakansuuma aghavule ghingine mu nguve sila, akaghavula kuvomba ndikio. pe ");
INSERT INTO wbi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","lino amapepo ghala ghakaghuma kwa muunhu jula na kukwingila mu ngube sila, ni lipugha lila likakimbila ku kidunda kino kitoghile kuhanga mulisumbe na kusovelela umuo. ");
INSERT INTO wbi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","avaanhu vala vano vadimagha ingube sila vati valolile kino kihumile, vakakimbila na kuhmia imhola sila pa mpulo na kufikaaja fya kunji fino fikuvasyuta. ");
INSERT INTO wbi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","avaanhu ye vapulike isio vakaluta kulola kino kihumile, pe vakisa kwa Yesu vakamwagha umuunhu juno amapepo amalamafu ghamuhumile. afwalile vunofu kange alinuluhala lwoni, ikalile pa maghulu gha Yesu pe vakoghopa. ");
INSERT INTO wbi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","pepano jumonga mu veene juno akalolile kino kihumile akatengula kukuvapangila avange ndave umuunhu uju juno alyale ilongosivua na mapepo amalamafu vule asosilue. ");
INSERT INTO wbi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","avaanhu voni ava mu kighavo kya vagelasi ni mbale sino sikuvasyuta vakansuuma uYesu avuke kuveene ulwakuva valyale nu vwoghofi kyongo. pe akingila mu kyombo ivuka iluta. ");
INSERT INTO wbi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","umuunhu jula juno alyahumilue na mapepo amalamafu ghala akansuuma uYesu kuluta naghwope, neke uYesu akam'bula kuuti, 'alute na kujova, “ ");
INSERT INTO wbi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","gomoka ku nyumba jaako na kuvala ghoni ghala ghano uNguluve akuvombile” umuunhu uju akavuka, na kupulisia mu mpulo ghwoni ghoni ghala ghano uYesu alyavombile vwimila jake. ");
INSERT INTO wbi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","pe uYesu akalutagha, ilipugha likamwupila, ulwakuva voni valyale vikumughulila. ");
INSERT INTO wbi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","lola akisa umuunhu jumonga ikemelua ghwe Yailo ghwe jumo mu valongosi mu nyumba inyimike ja kufunyila. uYailo akaghua paasi pa maghulu gha Yesu na kukunsuma alute ku nyumba jake, ");
INSERT INTO wbi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ulwakuva alyale nu mwana u minja jumo mwene, unya maaka kijigho na ghavili, alyale mu lwa kufua. ye iluta ilipugha likakong'anagha kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","umukijuuva juno idanda jilyahumagha ku maka kijigho na ghavili pwe alyale pala alyatumile indalama soni ku vaghanga, neke nakwale juno alyasosie nambe jumo, ");
INSERT INTO wbi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","akisile kunsana kwa Yesu akabasia uluvilo lwa mwenda ghwake, kukenyemukila idanda jikaleka kuhuma. ");
INSERT INTO wbi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","uYesu akaposia, “veni juno anayabasisie?” vati vakanile vooni, uPeteli akati, ghwe Ntwa ilipugha lwa vaanhu vinga kyongo vakusyngutile, vikukupita”. ");
INSERT INTO wbi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","neke uYesu akati, “umuunhu juma anyabasisie, lwakuva nivele nikagwile ingufu sihumile kulyune”. ");
INSERT INTO wbi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","umukijuuva ati avwene kuuti nangawesie kufisa kino avombile, akatengula kukwoghopa, akafughama paasi pa maghulu gha Yesu akapulisia pa maaso gha vaanhu voni kino kintwalile umwene kumwabasia na fino asosilue mu lwa kukenyemukila. ");
INSERT INTO wbi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","pe pano akati kwamwene, “mwalivango usokile vwimila ulwitiko lwako. ulutaghe nulutengano! ");
INSERT INTO wbi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","uYesu ye ighendelela kujova isio, umuunhu jumonga iisa kuhuma kunyumba ja mulolelesi ghwa nyumba inyimike ja kufunyila, akati, “umwalivako afwile. nunga ng'asiaghe um'bulanisi”. ");
INSERT INTO wbi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","neke uYesu ye apulike ndikio, akamwamula akati, “nungoghopaghe' lwene ghitikaghe umwalivo isooka. ");
INSERT INTO wbi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","neke ye ingile mu nyumba ijio, nakam'bulile umuunhu ghweni kukwingila palikimo nu mwene looli ju Peteli, uYohani nu Yakovo, uviise ghwa minja nu ng'iina ghwa mina. ");
INSERT INTO wbi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","lino avaanhu vooni vano pwevalyale pala vakava vilila na kuhumia amasio vwimila jaake, neke uYesu akavavula akati,? namungajovaghe ilisio, naafwile neke aghonelile lwene” ");
INSERT INTO wbi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","neke vakanseka kwa kukumbenapula vakakagwile kuuti afwile. ");
INSERT INTO wbi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","uYesu akan'ola uluvoko umija jula akankemeela fiijo akati, “ghwe mwana ima!” ");
INSERT INTO wbi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","uvwumi vwake vukan'gomokela pe akima ghu nsiki ghughughuo. akavalaghila akati vampele ikinu ikyakulia. ");
INSERT INTO wbi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","avapafi vake vakadegha, neke akavalaghila kuuti navangam'bulaghe nambe muunhu kino kilyahumile. ");
INSERT INTO wbi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","akavakemhela avavvulanisivua kijigho na vavili palikimo. akavapela uvutavulilua uvwa kudaga amapepo amalamafu mu vwakusosia inhamu. ");
INSERT INTO wbi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","akavasung'a valute kupulisia iMhola isa Vutwa vwa Nguluve napikuvasosia avatamu. ");
INSERT INTO wbi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","akavavuula akati, mulekaghe pipinda kimonga nambe ulukwegho nambe inyambe nambe unkate nambe indalama nambe umwenda ughwa kukwandula. ");
INSERT INTO wbi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","inyumba jino kyande mukwingila mukalaghe mumuo kuhanga pano muvuka mulikaha ilio. ");
INSERT INTO wbi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","neke kuvano navamwupile, pano muhuma mulikaja ilio muhumaghe napikung'uana ulung'unde mu maghulu ghinu kuva kivalilo kuvanave. ");
INSERT INTO wbi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","vakavuka nakuluta mumakaja kukilila mumakaja, napikilila iMhola inofu napisosia avatamu poni pano vakalutagha. ");
INSERT INTO wbi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","lino uHelode untemi akapulike ghoni ghano ghalyale ghihumila alyapumwike kyongo, ulwakuva jilyajovilue na vaanhu vamonga kuuti, uYohani mwofughi asyukile kuhuma kuvafue. ");
INSERT INTO wbi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","na ghamonga kuuti, uElia ahumiile nakuvange kwiti ghwejumo na vavili avakuulu kange ahumila kuvafue. ");
INSERT INTO wbi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","uHelode akati, “une nilyan'dumwile uYohani, neke ujuo ghwe veni juno nipulika imhola ja mwene? naju Helode akalonda isila ija kumwagha uYesu. ");
INSERT INTO wbi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ye vakagomwike avasung'ua, vakampangila sino valyavombile akavatola akaluta palikimo na vene. akaluta mwene mu likaaja lya Betsaida. ");
INSERT INTO wbi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","neke avaanhu vinga yevapilike imhola iji vakam'bingilila, akavupila akajova navoimhola ja Vutwa vwa Nguluve, kange avasosia vano vakalondagha kusooka. ");
INSERT INTO wbi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ye vwilileavavulanisivua vaake kijigho na vavili vakaluta kwa mwene vakati, uvatavule avaanhu valute mumakaaja ghano ghalipipi nu mpulo vakalonde ikyakulia, napa kughona ulwakuva apa tuli palunyika. ");
INSERT INTO wbi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","neke akavavula, “umue muvapelagha ikyakulia.” vakati tulivasila kinu ikyakulia pamo amakate ghahano ni swi iviili pamo lwale tulute kughula kumpulo kuhanaga nu vwinga vwa vaanhu.” ");
INSERT INTO wbi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","pwevalyale na vaghosi imbilima ihananopala. akavavula avavulanisivua vake akati, “muvakasie paasi mufipugha fipugha vave ifijigho fihaano ifipugha fyoni. ");
INSERT INTO wbi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","pe vakavomba ndikio na vaanhu vakikala paasi. ");
INSERT INTO wbi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","akatola amakate ghahaano ni swi ivili pe akalola kukyanya akaghasumila akamenyulania akavapela avavulanisivua vaake kuuti, vavike kuvulongolo kulipugha lya vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","vooni vakalia vakikuta ni fimenyulila fya makate fino fisighile nakaholania na kukufivika mu ndilo sikamema kijigho ni fivili. ");
INSERT INTO wbi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","neke lulyale kuti, uYesu alyale kuvusyefu ye ikufunya mwene. avavulanisivua vake valyale palikimo nu mwene, akavaposia akati, “avaanhu viiti une nene veni? ");
INSERT INTO wbi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","vakamwamula vakati, “Yohani umwofughi. neke avange vati Elia na vange viiti veve jumo mwene na vavili avakuulu asyukile kange”. ");
INSERT INTO wbi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","akavavula,” neke umue muti nene veni? akamula uPeteli akati, “Kilisite kuhuma kwa Nguluve”. ");
INSERT INTO wbi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","neke uYesu akavavula akati, namungam'bulaghe umuunhu ghweni ku ulu, ");
INSERT INTO wbi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","uYesu akati, umwana ghw nyamuunhu lunoghiile kupumusivua kughano minga nakukanua na vaanhu avagojo na vatekesi avavaha na vavulanisi vandaghilo nakubudua nikighono kya vutatu isyuka. ");
INSERT INTO wbi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","akavavula vooni, “akajova umuunhu” ghweni juno ilonda pikum'bingilila. avuleke uvugho no vwake neke itwike ikikovekano kyake, neke am'bingilile. ");
INSERT INTO wbi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ghweni juno ighela pikuluusia uvwumi vwake isofia. neke ghweni juno isofia uvwumi vwake vwimila une ujuo alakulusia. ");
INSERT INTO wbi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","pe ivumbulila kiki umuunhu, nave ipelua iisi jooni, neke akasofia nambe am'busie uvwumi vwake? ");
INSERT INTO wbi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ghweni juno ikum'bonela soni une na masio ghango, kwa mwene jujuo umwana ghwa muunhu alam'bonela isoni pano alava pa vwimike vwake nu vwimike vwa Nhhata na vanyaMhola avimike. ");
INSERT INTO wbi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","neke nijova isakyang'haani kwevale mukipugha kinu vano vimile apa navalalola uvufue kuhanga vavuvone uvutwa vwa Nguluve”. ");
INSERT INTO wbi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ye fifikile ifighono lekela kwooni kuhuma uYesu ijova amasio aghuo kuuti, avatoola palikimo nu mwene Peteli, uYohani nu Yakovo vakatogha kukidunda kukufunya. ");
INSERT INTO wbi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ye alikukufunya uluvonesio ku maaso ghake lukanduka, naghamhenda ghake ghakava mavalafu ghimulika. ");
INSERT INTO wbi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","pevalyale avakinhaata vavili vakajovagha naghwo valyale uMoose nu Elia, ");
INSERT INTO wbi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","valyavonike kuvwimike valyajovile isa kuvuka kwa mwene alyale pipi kughelanisia kuYelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","lino uPeteli navala vano valyale palikimo nu mwene valyale vanyatulu inyinga. neke ye vasisimwike, valyavuvwene uvwimike vwake navakibaba vavili vano valyimile nu mwene. ");
INSERT INTO wbi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","lulyahumile kuuti, ye vivuuka kwa Yesu, uPeteli akam'bula,” Mutwa, lunofu kulyusue kukukala bahapa kange lunoghile tujenge ifyeve fitatu kino kive kyako, kimo kive kya Moose, ni kingi kimo kive kya Eliya”, nalyakagwile kio ijova. ");
INSERT INTO wbi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ye ijova aghuo, likisa ilifunde likavakupikila. vakoghopa ye vavwene ilifunde livasyungutile. ");
INSERT INTO wbi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ilisio likapulikika lihuma mumafunde liiti, “uju ghwe mwanango umwimikua. mumpulikisiaghe umwene”. ");
INSERT INTO wbi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ilisio ye lijikile uYesu alyale mwene. vaki kalile kimie, na fiighono ifio navalyam'bulile nambe jumo lyolyoni mughano valyaghavwene. ");
INSERT INTO wbi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ikighono ikya vuvili, ye ahumile kukidunda ilipugha lya vaanhu viinga vakatang'ana naghwo. ");
INSERT INTO wbi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","lolagha! umukinhaata kuhuma mulipugha alyakolile fiijo, akati, “ghwe m'bulanisi nisuuma usoosie umwango. ulwakuva ghwe mwanango jujuo. ");
INSERT INTO wbi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ghulola amapepo amalamafu ghikun'kola, kange yee ikolagha kange ghikumpelela kuhasing'ana na pihumia ilitotofulo mumulomo lyope lyope lihuma kuvuvafi fiijo lyelimpeliile uvuvafi. ");
INSERT INTO wbi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","nivasuumile avavulanisivua vake vope vakunilue”. ");
INSERT INTO wbi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","uYesu akamula akati, umue mwekisikina ikisila lwitiko kange kino kili nu vuhosi, nilikukala numue un'siki ghuliku neke musikagule mulete umwanako apa. ");
INSERT INTO wbi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","unsoleka ye ikwisa amapepo amalamafu ghakamughwisia paasi napikunsukania na kugiila neke uYesu akalidalikila ilipepo ililamafu, akansoosia unsoleka. napikuntwala kwa viise. ");
INSERT INTO wbi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","vooni valyadeghile nu vuvaha vwa Nguluve. neke ye videgha ku ghano ghalyahumile ghano alyavombile, akati kuvavulanisi vake. ");
INSERT INTO wbi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","amasio agha mughakole fiijo mumbughulutu siinu, ulwakuva umwana ghwa muunhu itavuulua mumavoko gha vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","neke navalyasitaghinie ulukangasio lwa masio aghuo, kange alyaghavisile pa maaso ghave, neke valeke pikusikagula. vakooghopa pikumposia vwimila ilisio ilio. ");
INSERT INTO wbi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","bahuo vakatengula kulwaana vavuo veni juno ave m'baha. ");
INSERT INTO wbi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","neke uYesu ye akagwile sino viposesania munumbula saave. akantola umwana un'debe na kukum'bika ulubale lwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","pe akajova,”ndeve umuunhu ghwoghwoni angamwupile umwana un'debe ndavule uju mu mulitavua lyango, ujuo kange iiva anyupile une, kange ghweni anganyupile une kange iiva amwupile juno anisung'ile, ulwakuva juno ndebe kulyumue mweni ghwejuno m'baha. ");
INSERT INTO wbi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","uYohani akamwamula akati, Mutwa tukam'wene umuunhu akaleidaga amapepo kulitavua lyako neke tun'kanile, ulwakuva nan'jiitu”. ");
INSERT INTO wbi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","neke uYesu akam'bula akati, “muleka pikun'kana, juno ali ulubale lwinu ujuo ghwinu. ");
INSERT INTO wbi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","lulyahumile kuuti, kulingana ni fighono fifikile ifya kutogha kukyanya, kulukangasio alyalungime amaaso ghake kuluta kuYelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","akavasung'a avaanhu kuluta mu likaaja lya vasamalia neke vanosekesie pamonga. ");
INSERT INTO wbi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","neke avaanhu kula navakamwupila ulwakuva alyalungime amaaso ghake ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","avavulanisivua vaake uYakovo nu Yohani ye valivwene ili vakati, “Mutwa ghulonda tusukulile umwoto ghwike paasi kuhuma kukyanya ghuvamalisie? ");
INSERT INTO wbi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","neke akavasyetukila akavadalikila. ");
INSERT INTO wbi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","neke vakaluta kulikaaja ilinge. ");
INSERT INTO wbi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ye viluta vighenda musila umuunhu jumo akam'bula akati,” nikukuvingilila kwoni kuno ghuluta. ");
INSERT INTO wbi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","uYesu akam'bula akati, “ing'heve sili namiina, injuni isa kukyanya sili ni fivwasu neke umwana ghwa muunhu nsila napakuvika umutu ghwake? ");
INSERT INTO wbi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","pe pano akam'bula umuunhu ujunge akati, “um'bingililaghe” neke umwene akati “Mutwa unavule taasi nilute ninsyile ubaba ghwango.” ");
INSERT INTO wbi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","neke umwene akam'bula akati, “valeke avaue vavasyile avafue vaave, looli uve ulute kupulisia uvutwa vwa Nguluve pooni ");
INSERT INTO wbi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","kange umuunhu ujunge akati, “nikukuvingila, Mutwa lino nisuuma unavule taasi nikavalaghe muvano vali munyumba jango”. ");
INSERT INTO wbi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","neke uYesu akam'bula akati “nakwale muunhu juno itavwile amavooko ghake kulima nakulola kumbele ghwe anoghile kuvutwa vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","pambele uMutwa akatavula fijigho lekela lubale navange, navasung'ua vavili vavili vamulongolele mumakaja ghoni ghano alyahuvilile kuluta. ");
INSERT INTO wbi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","akavavula akati, “ifinu fimotwike, neke avanyambombo vadebe. lino munsume uMutwa unyamote, neke kuuti avasung'e ng'aning'ani avavombi mu mote jake. ");
INSERT INTO wbi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","mulutaghe mumakaaja. lolagha nikuvasung'ha hwene ng'hollo pakate pa ng'hekeva. ");
INSERT INTO wbi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","namungapindaghe inyambe ija ndalama, nambe isa vanyavukyusi, nambe ifilatu, nambe namungamwungilaghe umuunhu hweni musila. ");
INSERT INTO wbi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","mu nyumba jojoni jino kyande mukwingila. mutalaghe kwiti, ulutengano luve munyumba iji. ");
INSERT INTO wbi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ndeve pwale umuunhu ghwa lutengano pala, ulutengano lwinu lusighala kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","neke mujighaghe munyumba ijio, mulisaghe napinyua kino kyande vihumia, ulwakuva um'bombi anoghile uluhombo lwake. namungahumaghe mu nyumba iji nakuluta ku nyumba ijinge. ");
INSERT INTO wbi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ilikaaja lyolyoni lino kya mukwingila, na kukuvupila, lisagha kyokyoni kino kivikilue pa maaso ghinu, ");
INSERT INTO wbi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","muvasosyaghe avatamu vano vali umuo, muvavulaghe kuuti, “uvutwa vwa Nguluve vwisile pipi kulyume. ");
INSERT INTO wbi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","neke mulikaaja lyolyoni lino kyale mukwingila, na kuleka kukuvupila, mulutaghe kunji pa nsevo pe muvavule, ");
INSERT INTO wbi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","naliling'unde mulikaaja liinu lino likolile mu maghulu ghitu tukung'una pa maaso ghinu! neke mukagule kuuti, uvutwa vwa Nguluve vuli pipi. ");
INSERT INTO wbi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","nikuvavula kuuti ikighono ikya vuhighi kiliva kya lugudo kukila kwa Sodoma kuliko ilikaaja ilio. ");
INSERT INTO wbi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","iga uve Kolasini, iga uve Betisaida! nave imbombo imbaha sinosivombike mun'kate mun'kate jako, sale sivombike ku Tiro na ku Sidoni, ndevalatile katali kyongo, vavikukala mu n'kate mu mhenda agha magunila na mapembo. ");
INSERT INTO wbi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","neke kwaki kyongo ikighono kya vuhighi kwa Tiro nu Sidoni kukila umue. ");
INSERT INTO wbi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","uve Karelinaumu, ghusagha kuuti vilikukutosia kukyanya kwa Nguluve? nambe vilikukwisia paasi kuhanga kuvulungu. ");
INSERT INTO wbi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","juno kyande ikuvapulikisia umue ikumulikisia une, ghwope juno ikuvakana, ikung'hana une, na ghweni juno ikung'hana une ikun'kana juno anisung'ile. ");
INSERT INTO wbi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","vala kijigho lekela lubale vakagomoka vahovwike, vakaati, “Mutwa ghope amapepo amalamafu ghikutukunda militavua lyako. ");
INSERT INTO wbi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","uYesu akavavula akati,” numwaghile usetano pano ighua kuhuma kukyanya hwene lumuli lwa fula? ");
INSERT INTO wbi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","loola! nivapelile uvutavulua uvwa kukanya injoka ni fing'omilevuli, ni ngufu sooni sa valugu, kange kusila kyokyoni ku sila jojoni ikyakuvalemasia. ");
INSERT INTO wbi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","nambe lino namungahovokaghe lwene mu ili, kuuti inumbula sikuvitika, neke muhovokaghe kukila kuuti, amatavua ghinu ghalembilue kukyanya. ");
INSERT INTO wbi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","mu n'siki ghula ghula akahovokagha kyongo mwa Mhepo uMwimike na kuuti, “nikukughinia uve, Nhaata, Mutwa ghwa kukyanya ni iisi, ulwakuva ughaisile amasio agha kuhuma kwa nya vukoola na vanya luhala, nakukughafunula ku vala vano navavulanisivue, ndavule avaanha avadebe. Ena, Nhaata kwa kuva lukakelile pa maaso ghako. ");
INSERT INTO wbi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ifinu fyoni fitavulilue ku lyune nu Nhaata ghwango, nakwale juno ikagula umwana ghwe veeni, looli u Nhaata, kange nakwale juno ikagula uNhaata ghwe veni looli u mwana. nu muunhu ghweni juno umwana inoghelua kukujivonesia kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","akavasyetukila avavulanisivua, akati kuvusyefu, vafunyilue vala vano vikusagha sino najumue mukusagha. ");
INSERT INTO wbi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","nikuvavula umue. kuuti avavili vinga na vatwa vakanoghilue kusagha sino mukusagha, neke navakasaghile, na kupulika pulika sino mupulika neke navakapulike. ");
INSERT INTO wbi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","loola! um'bulanisi jumonga ughwa ndaghilo isa vaYahudi akimile na kkumughela akati, “m'bulanisi, nivombe kiki nikave uvwumi uvwa kusila nakusila?” ");
INSERT INTO wbi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","uYesu akamwamula akati, “kilembilue kiki mu ndaghilo? ghukujimba ndani? ");
INSERT INTO wbi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","akamwamula akati, “ghulukumughana uMutwa ghwako ku mwojo ghwako ghwoni, na kunumbula jako jooni, na kungufu sako sooni, nakuluhala lwako lwoni, nu nino ndavule ghukughana ghwe mwene. ");
INSERT INTO wbi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","uYesu akati, “ghwamwile vunono. vombagha ndiki pe ghuuva nu vwumi. ");
INSERT INTO wbi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","neke um'bulanisi ndeve inoghelua kukujivalila ikyang'hhani jujuo, akam'bulagha uYesu,” nu n'jango ghwe veni? ");
INSERT INTO wbi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","uYesu akamwamula akati, “umuunhu jumonga akale ikwika kuhuma ku Yelusalemu kuluta ku Yeliko. akaghua pakate pa vakunyi vakankunya ikyuma kyake, na kukuntova na kukumuleka pipi pifua. ");
INSERT INTO wbi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","hongelagha untekesi jumonga akale ikwika mu sila ijio, ati amwaghile akakila ulubale ulunge. ");
INSERT INTO wbi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","naju Mulawi akakila vulevule, ati afikile pala na kukumwagha akakila ulubale ulunge. ");
INSERT INTO wbi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","neke un'koola jumonga, pano akale ikyula, akakila pala pano akale umuunhu ujuo. ati amwaghile akaveela kulusungu. ");
INSERT INTO wbi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","akam'belelela na kukumpinya ifikong'o fyake, na kukumpaka amafuta mu fikong'o fyake. akantosia pa nkyanya ja kidimua kyake, na kukuntwala ku nyumba ja vaghesi na kum'buvusia. ");
INSERT INTO wbi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ikighono kinokikwisa akatola idinari ivili, na kukumpela unyanyumba jila ija vaghesi na kukum'bula, 'm'buvusie kyokyoni ikya kwongelela nikukuhomba kyande nigomwike. ");
INSERT INTO wbi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ghusagha kuuti, ghweveni mu ava vatatu, juno alyale pipi na jula juno alyaghwilile pakate pa vakunyi? ");
INSERT INTO wbi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","um”bulanisi akati, “ghwe jula juno akavonisie ulusungu kwa jula juno akaghwile”. uYesu akam'bula akati lutagha na juve ukavombaghe vule vule. ");
INSERT INTO wbi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","lino ye vati vikyula, vakingila mu likaaja limonga, nu mukijuuva jumonga ilitavual lwake ghwe Malita akankalibisia mu nyumba jaake. ");
INSERT INTO wbi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","alyale nu nuna juno akakemheluagha Maliya, juno akikalagha pamaghulu gha Mutwa na kukumpulikisia amasio ghake. ");
INSERT INTO wbi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","neke uMaliya akava ni mbombo nyinga isa kuteleka ikyakulia. akaluta kwa Yesu na kuti, “Mutwa, naghusagha kuuti u nuna vango anilekile nivombaghe ne mwene? pe lino um'bule anangaghe”. ");
INSERT INTO wbi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","neke uMutwa akamwamula na kukum'bula kuuti,” Malita Malita, ghupumhuka mu nyinga, ");
INSERT INTO wbi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","neke kye kinu kimo kyene ikyakuvomba. uMaliya atavwile kino kinono, kino nakilivuka kuhuma kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","jilyahumile ikighono kino, uYesu alyale ikufunya pamonga, um'bulanisivua ghwake jumo akam'bulagha kuuti,” Mutwa, utuvulanisie najusue kukufunya ndavule uYohani alyavulanisie avavulanisivua vake” ");
INSERT INTO wbi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","uYesu akamwamula pano mukufunya mutisaghe, “Mutwa ilitavua lyako lyimikwaghe, uvwimike vwako vwisaghe. ");
INSERT INTO wbi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","utupelaghe ifyakulia fiitu ifya jaatu. ");
INSERT INTO wbi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","utusaghilaghe inyivi siitu, ndavule najusue tukuvasaghila voni vano vatuhokile. nungalulongosiaghe munngelo” ");
INSERT INTO wbi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","uYesu akavavula akati, “ghwe veeni mu lyumue umanyani juno ikumulutila pakilo pe ikum'bula, manyani nisuuma amakate ghatatu. ");
INSERT INTO wbi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ulwakuva umanyani ghwango anyisile si sala sisisi kuhuma muvukyusi, najune nilinsila ikya kun'tengelela. nu ");
INSERT INTO wbi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ghwa mun'kate akamwamulagha akati uleke kunyangajisia, na june tughonile pa vulili. naningasisimuke nikupeele uve amakate. ");
INSERT INTO wbi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","nikuvavula nambe naisisimuka kukumpela amakate ndavule umanyani ghwake, ulwakuva ijigha idindusia kisita soni isisimuka na kukumpela amakate minga ndavule vuno ilonda. ");
INSERT INTO wbi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","najune nikuvavula musumaghe najumue mulapelua, mulondaaghe najumue mulafivona, muhodesyaghe najumue mulyadindulivua. ");
INSERT INTO wbi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ulwakuva ummunhu ghweni juno isuuma alyupila, nu muunhu ghweni juno ilonda ikufyagha. nu munhu ghweni juno ihodesia umulyango ilidindulivua. ");
INSERT INTO wbi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ghwe baba juliku mu lyumue juno umwanake angasume iswi ikumpela injoka? ");
INSERT INTO wbi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","kange nave angasuume ilikang'a ikumpela iking'omelivuli? ");
INSERT INTO wbi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","nave umue mwe vahosi mukimanyile kuvapela avaanha vinu ifinu ifinofu, lino uNhaata ghwinu ughwa kukyanya nakyaikuvapela uMhepo uMwimike ku vano vikunsuuma? ");
INSERT INTO wbi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","pambele uYesu alyale idaga ilipepo, umuunhu ynya lipepo alyale kinunu. ilipepo ye lihumile umuunhu jula akatengula kujova. ");
INSERT INTO wbi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","neke avaanhu avange vakati, “uju ivusia amapepo mwa Belisebuli, ili vaha lya mapepo. ");
INSERT INTO wbi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","avange vakamughelagha kuuti avasone ikivalilo kuhuma kukyanya. ");
INSERT INTO wbi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","neke uYesu akakagula amasaghe ghave akavavulagha, uvutwa vwovwoni vuno muligalung'ana vuliva vuvili, nu muunhu unya nyumba jino jigalungiine jilighua. ");
INSERT INTO wbi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","nave uSetan iiva agalung'iine uvutwa vwake vukwimila ndani? ulwakuva mwiti nihumia amapepo mwa Belisebuli. ");
INSERT INTO wbi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","neke une nihumia amapepo mwa Belisebuli, pe avajiinu vihumia amapepo kusila nyiki? mu uluo, avene vilikuvahigha umue. ");
INSERT INTO wbi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","nave kange nihumia amapepo ni kyove ikya Nguluve, lino uvutwa vwa Nguluve vuvisile. ");
INSERT INTO wbi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","umuunhu umunya ngufu pano alinifilwilo ilolela inyumba jake, ifinu fyake viiva pavunofu. ");
INSERT INTO wbi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","neke amwalukile umuunhu unya ngufu kyongo, umuunhu jula unya ngufu ilikunya ifilwilo fyake pe itola ifiinu fyake fyooni. ");
INSERT INTO wbi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","umwene juno na lubale lwango alikinsana nune, na juno naikong'ania palikimo nune ipalasania. ");
INSERT INTO wbi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ilipepo ililamafu likahuma kwa muunhu, iluta kulonda uvukalo uvusila malenga apuo apume. neke napakavonike, ijova iti, nigomoka kuno nikahumile. ");
INSERT INTO wbi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","angagomoke nene ivoona inyumba jifyaghililue pejikale vunofu. ");
INSERT INTO wbi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","apuo peliluta kulonda amapepo likale lubale ghano mahosi kukila ilyene neke likuvaleta vise vikale pala apuo umuunhu ujuo ilemua kyongo kukila ulutasi. ");
INSERT INTO wbi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","jilyahumile kuuti alyatile ijova amasio aghuo, un'dala jumonga akajova fiijo kukila vooni mulipugha lya vaanhu na kujova, “lifunyilue ilileme lino likuholile na mavele ghano ghwong'ile” ");
INSERT INTO wbi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","neke umwene akati, vafunyilue vala vano vipulika ilisio lya Nguluve na kukulivombela. ");
INSERT INTO wbi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","unsiki ilipugha lya vaanhu ye likong'aana na kukwongelela uYesu akatengula kujova, “ikisina iki kye kisina kya vuhosi. vilonda ikivalilo, na kusila kivalilo kino vipelua kukila ikivalilo kila ikya Yoona. ");
INSERT INTO wbi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ulwakuva ndavule u Yoona alyale kivalilo ku vaanhu va Ninaawi enendikio nu mwana ghwa Muunhu fye iliva kivalilo kya kisina iki. ");
INSERT INTO wbi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","uMalikia ughwa ku seba ilikwima ikighono kya vuhighi na vaanhu va kisina iki na kukuvahigha aveene, ulwakuva umwene alyahumile mu vusililo vwa iisi neke iise apulikisie uvukoola vwa solomoni, napa pwale juno m'baha kukila uSolomoni. ");
INSERT INTO wbi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","avaanhu va kuNinawi vilikwima ku highua palikimo na vaanhu va kisina iki ikighono kya vuhighi vili kukihigha, ulwakuva aveene valyalatile ku madalikili gha Yoona, pe lola apa pwale juno m'baha kukila uYoona. ");
INSERT INTO wbi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","nakwale umuunu ghweni juno ikunga itaala na kuvika ku lubale lwa paasi lwa ng'iisi jino najivoneka nambe paasi pa ndilo, neke kukunga na kuvika pakyanya pa kinu neke kuuti umuunhu ghweni juno ikwingila alyaghaghe ulumuli. ");
INSERT INTO wbi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","iliso lyako je taala ja m'bili. iliso lyako lingave linono pe umb'ili gwaki ghwoni ghuve mulumuli. neke iliso lyako lingave livivi pe naghubili ghwako ghwoni ghuva ghunya ng'iisi. ");
INSERT INTO wbi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","pe lino mujilolelelaghe nu lumuli luno luli n'kate jinu nalungaponekesiaghe ing'iisi ");
INSERT INTO wbi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","pe lino, ndeve um'bili ghwako ghwoni ghuli mu lumuli kange nakwelule ulubale luno luli mung'iisi, pe um'bili ghwako ghuva ndavule itaala jino jiviika na kuhumia ulumuli kulyumue”. ");
INSERT INTO wbi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ye ati amalile pijova, uFalisayi akamughongola akalie ikyakulia ku nyumba jaake, uYesu akingila mu n'kate na kuuva palikimo navope. na ");
INSERT INTO wbi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","vasalisayi vakadegha ndavule nakanawile taasi ye kikyale ikyakulia ikya pakivwilile. ");
INSERT INTO wbi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","neke UMtwa akavavula, “umue vaFarisayi musuka kunji ifikombe ni bakuli, neke nkate jinu mumemile inoghelua nu vuhosi. ");
INSERT INTO wbi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","mwe vaanhu mwe vasila vukagusi, pe umwene juno alyavumbile kunji nalyavumbile mun'kate kange? ");
INSERT INTO wbi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","muvapelaghe avakotofu fino fili mun'kate, ni mbombo sooni siiva nofu kulyumue. ");
INSERT INTO wbi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","iga umue mwe vafalisayi, ulwakuva namuvikila umwoojo kukuvavombela avange inofu na kuku mughana uNguluve. lwe lunono fiijo kuvomba isa kyang'haani na kukumughana uNguluve, kisila kuvuhila kuvomba aghuo na ghange kange. ");
INSERT INTO wbi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","iga umue Mafalisayi, ulwakuva munoghelua kukukala mu fitengo ifya kuvulongolo mu nyumba inyimike ja kufunyila na kuhungilua ni nyungililo isa vukoola kuno vighusikisia na kughulila. ");
INSERT INTO wbi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","iga umue, ulwakuva muling'ana ni mbiipa sino sisila fivalilo fino avaanhu vighenda mimbiipa isio kisila kukagula. ");
INSERT INTO wbi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","umb'ulanisi jumonga ghwa ndaghilo sa Kiyahudi akamwamula na kukumb'ula, “m'bulanisi, kino ghujova kikutukalasia kange usue”. ");
INSERT INTO wbi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","uYesu akati, “iga umue, vavulanisi va ndaghilo! kiki mukuvapela avaanhu amasigo amakome ghano naviwesia kupinda, neke umue namukola amasigho aghuo nambe ku kyove kimo mu fyove fiinu. ");
INSERT INTO wbi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","iga umue, ulwakuva mujenga na kuvika ikumbukumbu mu mbiipa sa vavili' vano vakabudilue na vaghogholo vinu. ");
INSERT INTO wbi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","neke umue mukufunyila na kukwiting'ana ni mbombo sino valyavombile avaghogholo vinu, ulwakuva kyang'ani valyavabudile avavili vano mujenga ikumbukumbu mumbiipa saave. ");
INSERT INTO wbi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","mu uluo kange, uvokoola vwa Nguluve vwiti, 'nikuvasung'ila avavili na vasung'ua vope vilikuvapumusia na kukuvabuda vamonga. ");
INSERT INTO wbi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ikisina iki kilihombela idanda ja vavili vano vabudilue kuhuma muvutengululo vwa iisi, ");
INSERT INTO wbi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kuhuma idanda ja Abeli kuhanga idanda ja Sakalia, juno alyabudilue pakate pa vwimike. Ena nikuvavula umue, ikisina iki kilhombela. ");
INSERT INTO wbi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","iga umue vavulanisi va ndaghilo sa vayahudi, ulwakuva mutolile ifungulo sa vukagusi; kange jumue namukwingila, ku vala vano vilonda kukwingila mukuvasigha. ");
INSERT INTO wbi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","pe baho uYesu akavuka pala, avalembi na vafalisayi vakampinga na kujofesania nu mwene mu nyinga. ");
INSERT INTO wbi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","vakaghela kukuntanga ku masio ghake. ");
INSERT INTO wbi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ku nsiki ughuo ilipugha likome lya vaanhu lilyakong'hanile palikimo, na pitengula pikanyana, akatengula pijova na vavulanisivua vake taasi,” mulolelelaghe ni kulule kya vasarisayi kino kye kitule” ");
INSERT INTO wbi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","na piliva nu sino sifisime sino nasilikagulika, nambe ilisio lino lifisime lino nalilikagulika. ");
INSERT INTO wbi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","lyolyoni lino mukajovile mu ng'isi lilipulikika pavwelu. soni sino mwapwepagha mu mbughulutu nkate ja fyumba finu ifya munkate fino fidindilue ghilipulisivua munkyanya mu mapala gha nyumba. ");
INSERT INTO wbi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","nikuvavula vamanyani vango, namungavoghopaghe vala vano vibuda um'bili neke vasila kimonga ikinge ikyakuvomba, ");
INSERT INTO wbi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","neke nikuvavula juno munoghile kukumwoghopa, mumwoghopaghe jula juno kyale abudile ali nuvutavulua vwa kuvatagha kulina lya mwoto. Ena nikuvavula umue, mumwoghopaghe ujuo. ");
INSERT INTO wbi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","asi! utujuni tuhaano natughusivua ku ndalama ivili? nambe ndikio nakwale nambe jumo mu veene juno ili shemulua pa vulongo pa Nguluve, ");
INSERT INTO wbi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","neke mukagule kuuti, ilinyele lya matu ghinu silivavilua, namungoghopaghe. umue muli va lutalama lukome kukila utujuni twinga. ");
INSERT INTO wbi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","nikuvavula ghweni juno ikunyupila pavulongolo pa vaanhu, umwana ghwa muunhu ikumwupila pavullongolo pa vanyaMhola vw Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","neke ghweni juno ikung'ana une pa vulongola pa vaanhu ghwope ikanwa pa vulongolo pa vanyaMhola va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ghweni juno ijovela imbivi mwa mwana ghwa muunhu, ilisaghilua, neke ghweni juno ikumuligha uMhepo uMwimike nalisaghilua. ");
INSERT INTO wbi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","kyande vikuvatwala kuvulongolo pa vavaha va nyumba inyimike ja kufunyila, avatemi na vanya vutavulua, namungoghopaghe mulakujivavila nambe ndavule kino kyalnde mujova, ");
INSERT INTO wbi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ulwakuva uMhepo uMwimike ikuvavulanisia vule kya mujova ku nsiki ughuo” ");
INSERT INTO wbi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","umuunhu jumonga mulipugha akam'bula akati, “m'bulanisi, m'bule unyalukolo ghwango anighavile ulubale lwa vuhaasi vwango. ");
INSERT INTO wbi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","uYesu akamwamula akati, “ghweveni juno am'bikile kuva mulamusi na kusambania mu lyumue?” ");
INSERT INTO wbi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","pe pano akavavula, mujilolelelaghe ni fyoni ifya vunoghelua, ulwakuva uvwumi vwa muunhu na vuli muvwinga vwa finu fino alinafyo. ");
INSERT INTO wbi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","uYesu akavavula ikihwani akati, umughunda hwa mofu jumonga ghulyaholile fiijo, ");
INSERT INTO wbi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","akiposia jujuo mu mwoojo ghwake akati, nivomba ndani ulwakuva nilinsila apakuvika imeto jango? ");
INSERT INTO wbi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","akati, nivomba ndiki. nidenya ifihenge fyango ifidebe nijenga ikikome. nivika imeto jango joni ni finu ifinge. ");
INSERT INTO wbi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","nikujivula inumbula jango, Numbula ghujivikile ifinu finga ku maka minga. puma ulie, unyue na kuhovokela” ");
INSERT INTO wbi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","neke uNguluve akavavula akati, ghwe muunhu mpumbafu, ikilo ja musyughu vilonda inumbula kuhuma kulyuve. ni finu fyoni finoghuling'anisie fiiva fyani? ");
INSERT INTO wbi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","fye luliiva kwa muunhu ghweni juno ikujivikila ikyuma kisila kukuling'ania vwimila Mutwa. ");
INSERT INTO wbi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","uYesu akavavula avavulanisivua vaake, pe lino nikuvavula namungasaghaghe mu vwumi vwinu - kuva mulisagha kiki mumavili ghinu - kuva mufwalagha kiki. ");
INSERT INTO wbi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ulwakuva uvwumi vwe kukila ikyakulia, nu m'bili ghwe kukila amenda ");
INSERT INTO wbi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","lolagha injuni isa kukyanya, nasilima nambe nasipeta. sisila nyumba nambe ifihenge ifya kuvikila. neke ubaba ghwinu ikusilisia. umue namuli kukila injuni! ");
INSERT INTO wbi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ghwe veni kulyumue juno ikujipumusia kukwongelesia idhiraa jimo mu vwumi vwake? ");
INSERT INTO wbi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","pe namuwesia kuvomba ikinu ikidbe ikio kino kuhugu, pe kiki lino kuhangajikila isinge isio? ");
INSERT INTO wbi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","lolagha amaluva - finoghikula. naghivomba imbombo nambe kuhona amenda ghake agha kufwala. neke nikuvavula, nambe uSolomoni mu vwimike vwake vwoni nakafwalile ndavule jumonga mu agha, ");
INSERT INTO wbi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","nave uNguluve ikughafwasia vunono amatundu gha mufivonde, ghano kweghale umusyungu nu lwakilavo ghitaghua ku mwoto. pe nakukila ikuvafwasia umue? umue mwe vanya lwitiko ludebe! ");
INSERT INTO wbi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","namungajihangajisiaghe kwiti mulia kiki nambe munyua kiki, nambe namungavisaghe nu vwoghofi. ");
INSERT INTO wbi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ulwakuva iisi sooni sihangajikila aghuo. nu Nhaata ghwinu ikagula sino munoghile isio. ");
INSERT INTO wbi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","neke mulondaghe uvutwa vwake taasi, na ghange aghuo mukwongelesevua, ");
INSERT INTO wbi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","namungoghopaghe, mwe lipugha lidebe, ulwakuva uNhaata ghwinu ihovokela kukuvapela umue uvutwa uvuo. ");
INSERT INTO wbi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","musghusiaghe ifyuma fiinu na kukuvapela avakotofu, mujivikile amafuko ghano naghisila - uvutile vwa kukyanya vuno navusila, ulubale luno avalyasi navangavele nambe inondo nasingawesie kunangania. ");
INSERT INTO wbi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ulwakuva pano pwevule uvutile vwako, pepene najinumbula jako pwejiliva. ");
INSERT INTO wbi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","amenda ghinu amatali ghavisaghe ghapinyilue na makanda, ni taala sinu sighendelelaghe kuuva siviika, ");
INSERT INTO wbi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","kange muvisaghe hwene vaanhu vano vikumuhuvila uMutwa ghuvanave kuhuma ku kikulukulu kya vutolani, neke kuuti angise na kuhodesia, van'dindulile umulyango ng'ani ng'ani. ");
INSERT INTO wbi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","vafunyilue avavombi vala vano uMutwa ukuvagha vali maaso. kyang'haani ilipinya umwenda ghwake untali nu nkanda, pepano ikuvakalisia paasi ku kyakulia, kange kukuvavombela inofu. ");
INSERT INTO wbi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","nave uMutwa ikwisa ku lwa vuvili vwa vulolelesi vwa pakilo, nambe uvulolelesi uvwa kilo ja vutatu, na kukuvagha viling'inie jiiva je kiiva ku vavombi avuo. ");
INSERT INTO wbi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","kukila aghuo, mukagule ili, nave untwa unya nyumba asakagula unsiki ghuno umulyasi ale ikwisa, naale ikwitika inyumba jaake jidenyue. ");
INSERT INTO wbi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","muvisaghe muling'anisie ulwakuva namukagula ghwe nsiki muuki umwana ghwa muunhu igomoka. ");
INSERT INTO wbi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","uPeteli akati, “Mutwa ghukutuvula jusue isi ku kihwanikisio au ghukum'bula umuunhu ghweni? ");
INSERT INTO wbi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","uMutwa akavavula, “ghwe nsung'ua veni umugholofu nambe unya vukoola juno untwa ghwake ikum'bika pa kyanya pa vavombombi avange, neke avaghavile ikyakulia kyave ku nsiki ghuno ghunoghiile? ");
INSERT INTO wbi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","afunyilue um'bombi jula, juno untwa ghwake angiise ikumwagha ivomba sila sino alaghisivue. ");
INSERT INTO wbi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","kyang'haani nikuvavula umue kuuti ikum'biika pakyanya pa kyuma kyake kyoni. ");
INSERT INTO wbi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","neke um'bombi jula akatisagha mu mwoojo ghwake, untwa ghwango idila kugomoka, pe akatengula kukuvatova avavombi avakinhaata vala na vakijuuva, pe baho akatengula kulia, kunyua na kughala, ");
INSERT INTO wbi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","untwa ghwa m'bombi jula ikwisa ku kighono kino naakagwile nisala jino naikujikaguala, ghwope ilikun'dumulania na kukum'bika palikimo na vano navagholofu. ");
INSERT INTO wbi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","um'bombi juno ikagula ulughano lwa ntwa ghwake, ghwope naikuling'hania nambe kuvomba sino sinoghiile mu lungano lwa ntwa ghwake ikopua ing'wegho nyinga. ");
INSERT INTO wbi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","neke um'bombi juno naasikagwile sino sinoghile ku lughano lwa ntwa ghwake, neke ivomba sino sinoghile ujuo ipelua finga, finga idajivua kuhuma kwa mwene, ghwope juno akeelilue ku finga, kwa mwene fidajivua finga kukila. ");
INSERT INTO wbi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","nisile kukunga umwoto pa iisi, kange ninoghelua kuuti ghuve ghuvikiile, ");
INSERT INTO wbi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","neke nili nu lwofugho luno nikuvofua, kange nili nulusukualo kuhanga pano luva luvombike! ");
INSERT INTO wbi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","pe musagha kuuti nisile nu lutengano mu iisi? Ndali, nikuvavula, pepano nisile kuleta uvusulani. ");
INSERT INTO wbi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","kutengula lino na kughendelela kuliiva na vaanhu vahaano vasuline mu nyumba jimo, na vatatu ");
INSERT INTO wbi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","visulanagha na vavili, vope vavili visulanagha na vatatu. visulana ubaba nu, nswambe, umwana nu viise, umama nu mwalive, umwalive nu ng'iina, unkamwana naipulig'hanagha nu nkwamwana n'jake. ");
INSERT INTO wbi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","uYesu akava ikulivula kange ilipugha, kyande muvona amafunde ghikong'ana, mwiti amasiki gha fula ghalipipi; fye luuva, ");
INSERT INTO wbi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","kange mungavone imhepo jipula kuhuma kumavemba mwiti litapiiva lifuke lweli fye luuva. ");
INSERT INTO wbi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","umue mwe vakedusi, mukagwile kuluvulania amasiki! lino! kiki mukunua kukughutang'ania umuluvo ghwa sino sivombeka ifighono ifi? ");
INSERT INTO wbi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","kiki umuunhu ghweni mu lyumue naikagula lino linono kuvomba kwa mwene unsiki ghuno ndeali ni nafasi ija kuvomba isio? ");
INSERT INTO wbi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ulwakuva mungalute nu muhigi ghwako pavulongolo pa muhighi, jitange kusambana na juno ikukuhigha nambe pano muli musila alwakutwala kwa muhighi, nu muhighi alakutwala kwa m'baha, nu m'baha alakutagha kundinde. ");
INSERT INTO wbi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","nikukuvula nulahuma ukuo kuhanga uhombile nambe i ndalama ja vusililo. ");
INSERT INTO wbi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ku nsiki ughuo, kulyale na vaanhu vamonga valyampelile imhola savaGalatia vano u Pilato alyavabudile na kuhasing'ani a ni danda sa vanave. ");
INSERT INTO wbi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","uYesu akavamula akavavula, “pe musagha kuuti avagalilaya avuo valyale ni sambi kukila avagalilaya avange voni fyenambe ghavaghile amavivi aghuo? ");
INSERT INTO wbi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nambe, nikuvavula neke nave namulata najumue mulibudua vule vule. ");
INSERT INTO wbi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","nambe avaanhu vala kijigho nu ntanda ku Siloamu vanoghukaghua na kuvabuda, musagha aveene valyale vanya sambi kukila avaanhu avange ku Yelusalemu? ");
INSERT INTO wbi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nambe, une niti, neke nave namulata najumue mweni mufua. ");
INSERT INTO wbi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","uYesu akavavula ikihwani iki,” umuunhu jumonga layale nu mpiki ghuvyalilue mu mughunda ghwa mwene, akaluta kulonda imheeke mu mpiki ghula neke nakaghaghile. ");
INSERT INTO wbi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","akam'bula juno ilolelela umughunda ghula, “lola mu maka ghatatu nisile na kughela kulonda imheeke mumpiki ughu neke nanipatile. udumule ulwakuva ghunangania ilihanga. ");
INSERT INTO wbi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","juno ilolelela umughunda akati, “ughuleke umwaka ughu neke nipile na kukuvikila imbolela. ");
INSERT INTO wbi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","nave ghihola imheeke umwaka ghuno ghukwisa ke kanono, neke nave naghuhola nikughudumula. ");
INSERT INTO wbi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","lino uYesu alyale ivulanisia mu nyumba jimonga ija kufunyila unsiki ghwa Sabati. ");
INSERT INTO wbi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","lola, pwe alyale umukimama jumonga juno ku maka kijigho nu ntanda alyale ni lipepo ililamafu lwa vuvotevote, umwene alyale mughogholo naalyale iwesia kukwima na kugholoka. ");
INSERT INTO wbi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","uYesu ati amwaghile an'kemheela akam'bula, “mama uvikilue vwavuke kuhuma mu vuvotevote vwako.” ");
INSERT INTO wbi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","akavika amavoko ghake pa kyanya jake, pe um'bili ghwake ghukagholoka ghwope akamughinia uNguluve. ");
INSERT INTO wbi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","neke um'baha ghwa nyumba jila ja kufunyila akakalala ulwakuva uYesu alya nsosisie ikighono kya Sabati. pe untavulua akamwamula akalivula ilipugha,”kuli ni fighono, fino luvaghile kuvoma imbombo. mwise kusosia himbe, nakwekuti kikighono kya sabati kyene. ");
INSERT INTO wbi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","uMutwa akamwamula akati, “vakitule! nakwale nambe juno kulyumue juno idindulila idogovi nambe ing'ombe jako kuhuma muluvagha na kukuvalongosia kuluta kunyua ikighono kya Sabati? ");
INSERT INTO wbi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","pe lino umhinja ghwa Ibulahamu, juno uSetano an'dindile ku maka kijigho nu ntanda, pe nalukamunoghile umhinja jula kusosivua ikighono kya Sabati. ");
INSERT INTO wbi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","pano alyale ijova amasio aghuo, voni vala vano valyale vikumpinga vakavona soni, pe ilipugha ilikome lya vange vakalulutila vwimila sino sinoavombile. ");
INSERT INTO wbi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","uYesu akati, “uvwimike vwa Nguluve vuhwanine ni kiki, kange niwesia kuling'anisia ni kiki? ");
INSERT INTO wbi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ji ghwene mbeju jino umuunhu atolile na kuluta kuvyala ku mughunda ghwake, jikalela na kuva mpiki n'kome, ni njuni sa kukyanya sikatenda ifivwasu fyave mu matafi ghake. ");
INSERT INTO wbi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","kange akati, “nivuling'anisie ni kiki uvwimike vwa Nguluve? ");
INSERT INTO wbi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ki kwene kilule kino un'dala itola na kuhasing'ania jujuo ifipimilo fitatu fya vutine nambe kughumuka” ");
INSERT INTO wbi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","uYesu alyaghendile mu mapulo ni fikaaja kuluta ku Yelusalemu na kuvavulanisia. ");
INSERT INTO wbi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","umuunhu jumonga akaposia akati, “Mutwa, ve vaanhu vadebe vano vilipokua”. pe lino akavavula akati,” ");
INSERT INTO wbi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","mujilolelelaghe kukilila umulyango unsekele, ulwakuva vinga vighela na kukunua kukwingila. ");
INSERT INTO wbi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","pambele unyanyumba ati imile na pidinda umulyango, pe mulikwima panji na kuhodesia na kuuti, Mutwa, Mutwa, tudindulile umwene ikuvamula na kwiti, 'nanivamanyile umue nambe kuno muhuma' ");
INSERT INTO wbi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","pe muliti, 'tukalile na pinyua pavulungolo pako nuve ukatuvulanisie mu fikaaja fitu' ");
INSERT INTO wbi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","neke umwene ikivamula, nikuvavula nanivamanye kuno muhuma, vuka palyune umue mwe vavomba vuhosi. ");
INSERT INTO wbi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","kwe kuliva na kulila kisila vusililo unsiki ghuno mulikuvagha uAbulahamu, Isaka nu Yakovo na vavili voni ku vwimike vwa Nguluve, neke umue jumue mutaghilue kunji. ");
INSERT INTO wbi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","vikwisa kuhuma imbale sooni, nakupuma pa mesa ja kyakulia kya pakivwilile mu vutwa vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","kagula ili kuuti, ughwa vusililo ghwe ghwa kwanda nu ghwawanda iiva ghwa vusililo”. ");
INSERT INTO wbi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","unsiki undebe pambele, avafalisayi vamonga valisile na kukum'bula kuuti, “luta na kuvuka apa ulwakuva uHelode ilonda kukubuda”. ");
INSERT INTO wbi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","uYesu akati, “mulute mukakivule ikikanu,  kila, lola nikughadagha amapepo na kusosia umusyughu nu lyakilavo, ni kighono kya vutatu nitekelesia uvufumbue vwango. ");
INSERT INTO wbi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ku lwolwoni lunoghile vwimila jango kughedelela umusyughu, ulwakilavo ni fighono fino fikwisa, ulwakuva najikwiting'ana kum'buda m'bili kutali ni Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yelusalemu, Yelusalemu ghwe veni juno ikivabuda avavili na kukuvatova amavue vala vano vasung'ilue kulyumue. ke kalingi ninoghilue kuvakong'ania avaanha vinu ndavule ing'uku vule jikong'ania ifayana fyake mumbavatilo sake. neke ili namukalighanile. ");
INSERT INTO wbi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","lola ujilekile inyumba jako. najune nukivavula, namungawesie kukunyagha nambe mungati, 'afunyilue ujuo juno ikwisa ku litavua lya mutwa”. ");
INSERT INTO wbi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","lulyahumile ikighono ikya Sabati. yeiluta kukaja ja jumo juno aale n'gooyo ghwa Vafalisayi kulia un'kate, vope vakale vivaanda pipi na pipi. ");
INSERT INTO wbi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","pavulongolo pa mwene pwealyale umuunhu juno alyale ni nhaamu ja kufimba. ");
INSERT INTO wbi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","uYesu akavaposia avaagula ndaghilo isa vayahudi na vafarisayi. “ndaani, lunono kusosia umuunhu pakighono kya Sabaati, asi vuli?” ");
INSERT INTO wbi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","neke avene vakava kimie, pe, uYesu akan'koola. akan'sosia na pikun'tavula alutaghe. ");
INSERT INTO wbi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ghwope akavavuula akati,” ghweveni mukipugha kiinu juno ali nu mwana nambe ing'ombe jingaghwilile muliina ku kighono kya Sabati naikujisuuvula ng'hani ng'hani?” ");
INSERT INTO wbi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","aveene valyale vasila ngufu isakwamula ghano ghano vavaposisie. ");
INSERT INTO wbi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","un'siki ghuno uYesu alyakagwile kwiti vala vano valyaghogholilue kwiti vasalwile ifitengo vwoghopua. avavula ikihwani akati, “ ");
INSERT INTO wbi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ye mughongolua nu muunhu uya vutolani, nungikalaghe mufitengo fya vavaha. ulwakuva nukagwile kuti, ");
INSERT INTO wbi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","pano aghongolilue umuunhu juno ghwe mwoghopua kyongo kukila uve. un'siki ghughuo umuunhu juno avaghongolile ");
INSERT INTO wbi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","neke uve ungaghongolue, usalulaghe uvukalo vwa kuvusililo, kuvaanga neke kyande ikwiisa juno akungongolile ghwemwene atisaghe uve manyani, kila ghukale kuvulongolo. apuo ghuuva mwoghopua ku vano valipalikimo nuuve pamesa. ");
INSERT INTO wbi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ulwakuva juno ikughinia uNguluve alyamwisia, juno ikujisia ghwe ighinisivua. ");
INSERT INTO wbi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu kange akam'bula umuunhu juno umughongolile, 'pano ghukumpela ikyakulia kya pamwisi nambe ikya pakivwilile, ulekaghe pighongola avamanyani vaako nambe avanyalukolo vaako, nambe avanyakisina vaako, nambe avabading'hani vaako avamofu neke kwiiti avene valeke pikukughongola uve uhombe. ");
INSERT INTO wbi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","neke lino pano ghuvomba ikikulukulu, vaghongolaghe avamofu, avalema, na vavoofu, ");
INSERT INTO wbi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","najuve ghufunyua, ulwakuva naviwesia kuhomba. ulwakuva ghuhombua muvusyukua vwa vanya kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","un'siki huno jumonga mu vala vano vakikalile pamesa palikimo nu Yesu ati apulike aghuo, ghwope akavavula akati,” afunyilue jula juno ilia un'kate mu vutwa vwa Nguluve”. ");
INSERT INTO wbi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","neke uYesu akavavula akati,” umuunhu jumonga akavombile ikikulukulu ikikome, akaghongola avaanhu vinga, ");
INSERT INTO wbi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","un'siki ghuno ikikulukulu kifikile, akansung'ile um'bombi ghwake kukuvavula vano avaghongolilue, 'mwise, ulwakuva ifinu fyoni fivikilue tayale ");
INSERT INTO wbi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","vooni vakatengula kukunsuuma avasungukile ughwa kwanda akati 'nighulile umughunda nilonda nilute nikaghulole. sivuo usaghile, ");
INSERT INTO wbi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ghwope ujunga akati, 'nighulile ing'ombe ihaano najune nilute kughela. sivuo usaghile. ");
INSERT INTO wbi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","na ju muunhu ujunge akati, 'nihumile pitoola un'dala pe lino naniwesia pikwisa. ");
INSERT INTO wbi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","um'bombi akagomoka na kukum'bula um'baha ghwake aghuo. unyanyumba jula akakalile akam'bula um'bombi ghwake,' luta ng'hani ng'hani mumpulo na mufisila fino filuta mufikaaja fya vaanhu ukavalete apa avakotofu, avalema. vano navilola na vabofu”. ");
INSERT INTO wbi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","um'bombi ghwake akati, ntwa aghuo ghano unilaghisie ghavombike, nambe lino ikyakulia kisighiile. ");
INSERT INTO wbi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","untwa akam'bula um'bombi akati, luta kusila ijansevo na mufisila fino filuta mumakaaja gha vaanhu ukavapelepesie avaanhu vingile neke inyumba jango jimeme. ");
INSERT INTO wbi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ulwakuva nikuvavula, mu vala vano vaghongolilue ulwa kwanda nakwale juno ilivonja ikikulukulu kyango. ");
INSERT INTO wbi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","lino ulukong'ano ulukume valyale viluta naghwo. ghwope akadyetuka akavavula kuuti, ");
INSERT INTO wbi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ndeve umuunhu ikwisa kulyune ghwope naikunkalalila ubaba ghwa ghwake, ungiina ghwake, avaanha vaake, avanyalukolo vaake avaghosi na vadala Ena, na vu vwumi vwake kange navuwesia kuva vavulanisivua vango. ");
INSERT INTO wbi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","umuunhu nave naitoola ikikovekano kyake na kukwisa kunsana jango naiwesia kuva m'bulanisivua ghwango. ");
INSERT INTO wbi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ulwakuva ghwe veni mu lyumue, juno ilonda kujenga kujenga aikela kutengula kiisatala iling'hanie taasi alole indalama neke alole kukughenia aghuo. ");
INSERT INTO wbi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","nave naiovomba aghuo neke kyande ijenga uvwalo angakunue pimalisia. vooni vano vilola vitengula piseka, ");
INSERT INTO wbi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","vitisagha, umuunhu uju akatengwile kujenga, akunilue kumalikisia. ");
INSERT INTO wbi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","neke ghwe Ntwa muki, jno ilonda kuluta kutovana nu Ntwa ujunge mu vwiite, juno naikukala paasi taasi neke asaghe nave akwiline kutovana, palikimo na vaanhu imbilima kijigho kimo kutovana nu junge juno ikwisa kwa mwene na vaanhu imbilima fijigho fivili? ");
INSERT INTO wbi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ndeve evuo ililugu lya vange pano lijighe lilikuvutali, likunsung'a untwa kusuuma ulwiho lya lutengano. ");
INSERT INTO wbi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","kwekuti lino, juno nailonda kukufleka fyooni fino alinafyo. nangawesie kuva m'bulanisivua ghwango. ");
INSERT INTO wbi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","umwinyo nnono, neke nave ghunangike ghuvombela kiki neke ghuve mwinyo kange? ");
INSERT INTO wbi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","naghuva mwinyo ghwa kulunga nambe kuva mbolela. kange kutaghua kuvutali. umwene unya mbughulutu aghakupulika na apulikaghe”. ");
INSERT INTO wbi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","lino avasongesia songo na vahosi avange vakisa kwa Yesu na kukumpulikisia uYesu. ");
INSERT INTO wbi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","avaFarisayi vooni navalembi vakajing'ulasia viiti,” umuunhu uju ikuvupila avanya sambi nambe kulia navo. ");
INSERT INTO wbi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","uYesu akajova ikighwani iki kuvanave akati, ");
INSERT INTO wbi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ghweveni kulyumue, ndeve ali ning'olo kilundo neke jimonga jisova, ikusileka isingi sila fijigho budikalubale na budika lubale na kuluta kulonda jino jisovile kuhanga ajaghe? ");
INSERT INTO wbi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ghwope kya ajaghile akujipinda pamavegha kumo ahovwike. ");
INSERT INTO wbi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","angafike pakaja, ikuvakemhela avamanyani na vabadingani vake pe ikuvavula kuuti, hovokagha palikimo nune, ulwakuva ing'olo jango jino jikasovile nijaghile. ");
INSERT INTO wbi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","vule vule nikuvavula kuuti luliiva lukelo kukyanya pano umuhosi jumo ilaata inyivi, kukila vwimila avaanhu fijigho budikalubale na budika lubale, avagholofu avasila vufumbue vwa kulaata. ");
INSERT INTO wbi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","nambe kwale umukijuuva veni juno ali ni ndalama kijigho, neke angasovelue nu lutalama lumo, kya ikunga itaala nakufyaghila inyumba na kulonda kungufu sooni kuhanga ikulwagha? ");
INSERT INTO wbi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","kyande alyaghile ikuvakemhela avamanyani na vabading'ani vake na kukuvavula hovokagha palikimo nune, ulwakuva ulutalama lwango luno lukasovile nilwaghile. ");
INSERT INTO wbi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","nambe ndikio nikuvavula,” pwelule ulukelo pa vulongolo pa vanyaMhola va Nguluve vwimila unyasambi jumo juno ilaata. ");
INSERT INTO wbi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","na ju Yesu akati,” umuunhu jumonga alyale na v vaaswambe vavili, ");
INSERT INTO wbi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","un'debe jula akam'bua uviise ghwake akati, baba umhele uvuhasi vwango neke akaghava ikyuma kyake kuveene. ");
INSERT INTO wbi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ifighono nafinga, un'debe jula akakong'ania foni fino finoghile akaluta ku iisi ija kuvutali, ukuo akalia fivi indalama sa mwene, akaghulila ni finu fino nailonda, akavombela fivi indalama samwene kunyivi. ");
INSERT INTO wbi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ghwope ye amalile fyoni ilijala likingila mu isi jila pe umwene akatengula kuva mulondi. ");
INSERT INTO wbi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","akaluta kwa muunhu jumonga ghwa mu iisi jila, ghwope akan'twala kumughunda ghwake ku suvila ingube. ");
INSERT INTO wbi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","akava inoghelua kulia amabandu ghano ingube salisagha ulwakuva nakwale umuunhu juno akampelile ikinu kyokyoni alie. ");
INSERT INTO wbi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","pe un'debe jula akasagha mu mwojo ghwake akati, ava vombi valingi ava baba ghwango vilia filingi ifyakukwilana najune pwenile apa nifua ni n'jala! ");
INSERT INTO wbi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","nivuka niluta kwa baba ghwango na kukumbula,” Baba nihokile kwa Nguluve na pa maaso ghako. ");
INSERT INTO wbi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","naninoghile kukemhelua n'swambo kange, um'bike nive mumo muvavombi vako. ");
INSERT INTO wbi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","pepano akaluta kwa viise ghwake. ye akyale kutali uviise ghwake akamwagha akam'bonela ikisa akaluta luvilo akamuyayila na kumunonela. ");
INSERT INTO wbi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","u mwana jula akam'bula akati,” Baba nihoile kukyanya kwa Nguluve na pa vulongolo pa maaso ghako, naninoghile kukemhelua n'swambo. ");
INSERT INTO wbi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","uviise jula akavavula avavombi vake; mulete ng'hani ng'ahi umwenda unono kyongo mun'fwasie. Mun'fwasie ni pele mu kyove ni filatu mumaghulu. ");
INSERT INTO wbi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","kange mulete ing'ombe jino jinonile muhinje tulie na kuhovoka. ");
INSERT INTO wbi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ulwakuva umwanango alyale afwile mwope mwumi. alyasovile ghwope avonike vakatengula kululutila. ");
INSERT INTO wbi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","pe baho umwanake um'baha jula alyale kumughunda. akatile ikwisa alipipi ni nyumba akapulika ilisio ilya nyimbo na kuseja. ");
INSERT INTO wbi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","akan'kemhela um'bombi jumonga akam'posia agha kwe kuti kiki? ");
INSERT INTO wbi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","um'bombi akam'bula akati,” ununavo isile ubaba ghako amuhijile ing'ombe jino jinonile ulwakuva agomwika n'kafu. ");
INSERT INTO wbi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","un'swambe um'baha akakalala akasita kukwingila mun'kate pe uviise akahuma kunjikumpelepesia. ");
INSERT INTO wbi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","neke akamwamula iviise ghwake akati,” lola une nikuvombile amaka minga nambe nanipunisivue indaghilo sako, neke numhelile nambe kapene kuuti, nihovoke navamanyani vango. ");
INSERT INTO wbi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","neke atile isile un'swambo uju juno alile fivi ikyuma kyako palikimo na vaghenda mwalu umuhinjile ing'ombe jino jinonile. ");
INSERT INTO wbi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","uviise akam'bula akati,” n'swambango, ulipalikimo nune ifighono fyoni, ni fyoni fino nilinafyo fye fyako. ");
INSERT INTO wbi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","lino lunoghile kulyusue kuvomba ikikulukulu na kuhovoka, unyalukolo ghwako uju hwene akafwile na lino mwumi; akasovile ghwope avonike. ");
INSERT INTO wbi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","uYesu akavavula avavulanisivua vake, “palyale nu muunhu jumonga m'mofu alyale nu m'baha mu mbombo jake, ");
INSERT INTO wbi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","pe vakampela umm imhola sa m'baha jula kuuti, um'bombi ghwako um'baha itaghania ifyuma fyako. pe ummo akan'kemela akam'bula akati, “kwe kiliku ulyuve kino nipulika? humia imhola ija vuvaha vwako, ulwakuva nungave m'baha kange mu mbombo jango. ");
INSERT INTO wbi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","um'baha jula akijovela mu mwoojo ghwake, nivombe kiki, ulwakuva untwa ghwango ikunivusia mu mbombo jango ija vuvaha? nisila ngufu sa kulima, na kusuma nivona soni. ");
INSERT INTO wbi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","nikagula lino kyale nivomba kyande vanivusisie mu mbombo jango ja kwimilila avaanhu vanyupile mu nyuma save. ");
INSERT INTO wbi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","pe pano umweimilili jula akavakemhela voni vano visighilua nu ntwa ghwake akam'bula ughwa kwanda, 'ghusighilua ilingi nu ntwa ghwango?' ");
INSERT INTO wbi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","akati, 'fighelelo kilundo fya mafuta akam'bula,' tola ilikalataasi lyako ng'ani ng'ani lemba ifijigho fihaano, ");
INSERT INTO wbi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","pe akam'bula ujunge najuve ghusighilua ilingi? akati, 'ifighelelo kilundo kimo ifya vutine vwa ngano'. tola ilikalataasi lyako, lemba ifijigho lekela kwoni'. ");
INSERT INTO wbi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","untwa jula akamughinia um'baha jula ulakuva alyavombile nu vukagusi. ulwakuva avaanha va pa iisi iji vali nuvukagusi vyinga kukila avaanha va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","lino une nikuvavula kuuti, muvatangaghe avajinu ni kyuma kino mulinakyo, neke kyande kisilile, mwupilue ku vukalo vwa kusila na kusila. ");
INSERT INTO wbi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","juno mugholofu mu lidebe kyongo iva mugholofu na mulikome. ghwope juno namugholofu mu lidebe naiva mugholofu na mulikome kange. ");
INSERT INTO wbi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","nave umue namulyale vagholofu mu kyuma kino na kyakyangani pe ghwevene juno ikuvitika ku kyuma ikya lweli? ");
INSERT INTO wbi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","kange nave namulyale vagholofu kutumila ikyuma kya muunhu junge, ghweveni juno ikuvapela sino sinu jumue? ");
INSERT INTO wbi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","nakwale um'bombi juno ikuvavombela avatwa vavili, ulwakuva ghukunkalalilagha jumo na kumughana ujunge, nambe kukolana nuju na kum'benapula uju. nungawesie kukum'bombela uNguluve ni kyuma. ");
INSERT INTO wbi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","pe avafarisayi, vano valyale vinoghua indalama ye vapulike aghuo ghoni vakam'benafula. ");
INSERT INTO wbi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","kange akavavula, “umue mwemwemu mukuvona hwene vanya kyang'ani pa maaso gha vaanhu, neke UNguluve akagwile amoojo ghinu. ulwakuva lino lyimike kwa muunhu liva ng'alasi pa maaso ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","indaghilo na vavili pwefilyale kuhanga uYohani panoa akisile. kuhuma unsiki ughuo, imhola inofu ja vutwa vwa Nguluve jikapulisivue, nu muunhu ghweni ighela kukwingila ku ngufu. ");
INSERT INTO wbi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","neke kihugu ku kyanya ni iisi fivuke kuliko ililembe limo lya ndaghilo likosekane. ");
INSERT INTO wbi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ghweni juno ikumuleka un'dala ghwake na kun'toola un'dala ujunge ivwafuka, ghwope juno ikun'toola juno alekilue numughosi ghwake ivwafuka. ");
INSERT INTO wbi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","palyale nu mmofu jumonga alyafwalile amhenda aghanya sambalau na gha ndalama akale ihovokela uvumofu vwake uvukome. ");
INSERT INTO wbi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","nu nkotofu jumonga ilitavua lyake Lasali vakam'biki pa mulyango ghwa kunji kwa mofu jula, alyale ni fikongo. ");
INSERT INTO wbi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ghwope akinoghelua kulia ikyakulia kino kikaghwisagha pasi pa mofu jula nasi mbua sikisa sikamumyanga ifikong'o fyake. ");
INSERT INTO wbi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","jikava unkotofu jula akafua, avanyaMhola vakantola kuhanga pakifuva pa Abulahamu. ummofu jula ghwope akafua akasyulua. ");
INSERT INTO wbi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ye alyale mumuko kuvulungu kula akadindula amaaso ghake akamwagha uAbulahamu kuvutali ali nu Lasali pakifuva kyake. ");
INSERT INTO wbi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","akalila akati, 'baba Abulahamu, nisaghile un'sung'e u Lasali asase ulwove lwake mumalenga, alunoghelesie ululimi lwango; ulwakuva nipumusivua mu mwoto ughu. ");
INSERT INTO wbi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","neke uAbulahamu akati, 'mwanago kumbuka kuuti mu vwumi vwako ukupile isako sino nono, nu Lasali vule vule alyapatile inyivi. neke lino alyapa uhuvilisivua, najuve ghupumusivua. ");
INSERT INTO wbi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","na kukila aghuo, kuvikilie ilina ilikome pakate jitu kuuti vano vilonda kuluta kulyumue vakunuaghe na vaanhu va kulyumue navangalovokaghe kukwisa kulyusue' ");
INSERT INTO wbi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","umofu jula akati, 'nisuuma baba Abulahamu kuuti unsung'e ku nyumba kwa baba ghwango. ");
INSERT INTO wbi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ulwakuva nili navanyalukolo vahano neke avavunge na veene ku vwoghofi piti vope vilikwisa pa mhumhuko apa. ");
INSERT INTO wbi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","neke uAbulahamu akati, 'kwale uMoose na vavili, valeke vavapulikisie vavuo. ");
INSERT INTO wbi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","umofu jula akati, 'Ndali, baba Abulamahu, neke nave angalute umuunhu juno ahumile kuvafue vilaata, ");
INSERT INTO wbi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","neke uAbulahamu akam'bula akati, 'ndeve navikuvapulikisia uMoose na vavili navangampulikisie nambe umuunhu angasyuke kuhuma kuvafue. ");
INSERT INTO wbi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","uYesu akavavula avavulanisivua vake, “imbombo sino sikuvatwalila avaanhu kuvomba uvuhosi sinoghile kuhumila, neke iga umuunhu ghweni juno itengulisia! ");
INSERT INTO wbi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","jale jiva je kiba umuunhu ujuo kumpinyila mu singo ilivue ilisito lya kuhavulila na kutaghua mu malenga, kuliko kumuleka umuunhu jumo mu vadebe ava atendaghe isambi. ");
INSERT INTO wbi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","mujilolelelaghe, nave unyalukolo ghwako akuhokole umuvungaghe, ghwope angalate unsahilaghe. ");
INSERT INTO wbi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","nave akuhokila mara lekela lubale ku kighono kimo ni kighono kikikio ikwisa nakuti, 'nilaata' nisaghile unsaghilaghe” ");
INSERT INTO wbi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","avasung'ua vake vakam'bula uMutwa kuuti, “utwongelesie ulwitiko lwitu” ");
INSERT INTO wbi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","uMutwa akati, “nave muve nu lwitiko lukome, mwale mukughuvula unkuju ughu, kuluka na kumela kumalenga, ghwope ghukuvitika. ");
INSERT INTO wbi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","neke ghweveni mu lyumue juno umbombi juno ilima umughunda nambe juno idima ing'olo, ikum'bula pano igomoka kumughunda, ghwise ng'ani ng'ani ghukale neke ulie ikyakulia? ");
INSERT INTO wbi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","pe nangam'bule unendele ikyakulia nilie, kange uminye ikihudiko unovombele kuhanga ningamale kulia na kunyua. pe pano najuve kya ghulia na pinyua? ");
INSERT INTO wbi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","nangamuhongesie um'bombi ujuo ulwakuva avombile ghanoavulilue? ");
INSERT INTO wbi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","vule vule najumue mungamale kuvomba sino vavalaghisie mutisaghe, 'usue tulivavombi twevano natunoghile. tuvombile ghene ghano vatulaghisie' ");
INSERT INTO wbi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","jikahimile kuuti pano alyale ikyula kuluta ku Yelusalemu, akakilile mu maka ja Samalia na ku Galilaya. ");
INSERT INTO wbi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ati ikwingila mu kikaaja kimonga, ukuo akatang'ana na vaanhu kijigho avanya buba. vakima patali, ");
INSERT INTO wbi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","vakajova ilisio vakati, “Yesu, Mutwa tuvonele lusungu” ");
INSERT INTO wbi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ati avaghile akavavula, “lutagha mukajivonesie ku vatekesi”. vope ye viluta vakavalasivua. ");
INSERT INTO wbi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","jumonga ati avwene asokile, akagomoka ikufunyila uNguluve. ");
INSERT INTO wbi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","akafughama pa maghulu gha Yesu kumuhongesia. umwene alyale muuhugu. ");
INSERT INTO wbi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","uYesu akamwamula akati, “pe navakavalasike voni kijigho? valikughi avange vala? budika lubale ");
INSERT INTO wbi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","napwale nambe jumo juno avonike kugomoka neke kumwika uNguluve, looli umughesi uju?” ");
INSERT INTO wbi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","akam'bula, “ghwime ulutaghe ulwitiko lwako lukusosisie” ");
INSERT INTO wbi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","avafalisayi ye vikumposia uvutwa vwa Nguluve vulikwisa lighi, uYesu akavamula akati, uvutwa vwa Nguluve na kiinu kinokivoneka. ");
INSERT INTO wbi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","nambe avaanhu navilijova, 'lola apa! nambe 'lola kula!' ulwakuva uvutwa vwa Nguluve vuli n'kate jinu” ");
INSERT INTO wbi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","uYesu akavavula avavulanisivua vake, “unsiki ghukwisa ghuno mulinoghelua kukukyagha ikighono kimo kya mwana ghwa muunhu, neke namulikukyagha. ");
INSERT INTO wbi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","vilikuvavula, 'lola kula!, lola apa! neke namungalutagha nambe kuvavingilila, ");
INSERT INTO wbi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","hwene mwoto ghwa fula ghuno ghumulika kukyanya kutengulila ulubale lumo kuhanga ulunge. lino nambe umwana ghwa muunhu iliva ndikio mu kighono kyake. ");
INSERT INTO wbi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","neke taasi lukumunoghela kupumuka mu isio nyinga na kukanua ni kisina iki. ");
INSERT INTO wbi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ndavule lulyale mufighono fya Nuhu, fye luliva mu fighono fya mwana ghwa muunhu. ");
INSERT INTO wbi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","vakalia, vakanyua, vakatoola na kutoolana kuhanga ikighono kino uNuhu akingilaa mu kyombo pe amalenga minga ghakisa na kuvabuda vooni. ");
INSERT INTO wbi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","fyelulyale mufighono fya Luti, vakalia, kunyua, vakaghula na kughusia, kulima na kujenga. ");
INSERT INTO wbi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","neke ikighono kila uLuti alyavikile kuSodoma, jikatonya ifula ja mwoto ni kibiriti kuhuma kukyanya jikavabuda vooni. ");
INSERT INTO wbi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","lino fyeluliva mu kighono kila ikya mwana ghwa muunhu pano ilisyetulivua. ");
INSERT INTO wbi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ikighono ikyo nungamwitikaghe juno alikunyumba kukyanya iike kutola fimonga munkate munyumba. nungam'bulagha juno ali kumughunda kugomoka kukaaja. ");
INSERT INTO wbi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","munkumbukaghe un'dala ghwa Loti. ");
INSERT INTO wbi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ghweni juno ighela kukulusia uvwumi vwake alambusia, neke kange ghweni juno alambusia uvwumi vwake ujuo alakulusia. ");
INSERT INTO wbi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","nikukuvula, ikighono ikio avaaanhu vavili viliiva vaghonile pa kitala kimo. jumo itolua ujunge ");
INSERT INTO wbi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ilekua. kwe kuliiva na vakijuuva vavili vihavula amayembele palikimo, jumo itolua nu june ilekua. ");
INSERT INTO wbi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","avakinhaata vavili viliva pivomba imbombo pa mughunda, neke jumo itolua, ujunge ilekua”. ");
INSERT INTO wbi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","vakamposia, “kughi, uNguluve?” akavavula, “pala pano pweghule um'bili ghwa kikanu kino kifwile, pepano amatumbusi ghiking'ana palikimo”. ");
INSERT INTO wbi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","neke akavavula ikihwanikisio ndavule lunoghile kukufunya jaatu, kisila kukatala. ");
INSERT INTO wbi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","akatisaha kwealyale umhighi mu likaaja limonga, juno naalayle ikumwoghopa uNguluve kange naavikilagha mu mwoojo kukuvatanga avaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","mwealyale umfwile jumonga mulikaaja ilio, ghwope akamulutila kekinga akati, “nange unighilile un'koleumulugu ghwango aleke kutoola ifyango. ");
INSERT INTO wbi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ku nsiki ntali naale ipinyile kuuti antange, neke ye ghukilile unsiki akasagha mu mwoojo ghwae. pope une nikumwoghopa UNguluve nambe kukuvoghopa avaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pope ulwakuva umfwile uju ikung'atasia nikuntanga akave ikighavo kyake neke aleke kukung'atasia kange”. ");
INSERT INTO wbi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","neke uMutwa akajova akati, 'pulikisia fino ajovile umhighi umhosi uju. ");
INSERT INTO wbi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","pe uNguluve ghwope naileta ikyang'haani ku vimike vake vano viku mulilila pamwisi na pakilo? pe umwene naiiva nulugudo kuveene? ");
INSERT INTO wbi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","nikuvavula kuuti, ikwisa ni kyang'haani kuveene ng'ani ng'ani. neke unsiki ghono umwana gwa muunhu ikwisa ilikulwagha ulwitiko lwa iisi?' ");
INSERT INTO wbi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","pepano akavavula ikihwani iki pwevalyale avaanhu vamonga vano vikuvoona kuuti aveene kuva vagholofu na kuvapenapula avange, ");
INSERT INTO wbi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","avaanhu vavili vakaluta kunyumba inyimike ja kufunyila: jumo aale mFalisayi nu junge n'songesia songo. ");
INSERT INTO wbi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","umFalisayi akima na akifunya ndiki mu mwoojo ghwake, 'nikukuhongesia Nguluve vule une nanili ndavule avaanhu avange vano vakunyi, avaanhu vano vahoka makole, avavwafu nambe ndavule uju unsongesia songo. ");
INSERT INTO wbi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","une ku nywabaha nibuhila kulia kavili kange nitavula ilitekelo mu meto soni sino nikava. ");
INSERT INTO wbi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","neke unsongesia songo, alyimile pavutali looli nalyaghelile nambe kukwinamula amaaso ghake kukyanya. akatovatova pakifuva kya mwene akati, 'Nguluve unsaghile une ne muhosi' ");
INSERT INTO wbi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","nikuvavula, umuunhu ndavule uju alyagomwike kukaja apyanilue inyivi saake sooni kukila ujunge jula ulwakuva gheni juno ikughinia uNguluve alyamusia, ghwope juno ikujisia uNguluve alyantosia. ");
INSERT INTO wbi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","avaanhu vakatwalila avaanha avadebe kuuti vamwabasie, neke avavulanisivua vake ye vavwene aghu, vakavasigha. ");
INSERT INTO wbi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","neke uYesu akavakemela kwa mwene akatisagha, 'valeke avaanha avadebe vise kulyine nambe namungavasighahe. ulwakuva uvutwa vwa Nguluve vwe va vaanhu ndavule avuo. ");
INSERT INTO wbi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","kyang'ani nikuvavula, umuunhu ghweni juno naikvupila uvutwa vwa Nguluve hwene mwana sesene nailikwingila'. ");
INSERT INTO wbi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","um'baha jumonga akam'posia akati, 'm'bulanisi nono, nivombe kiki neke pambele nive nu vwumi vwa kusila na kusila?' ");
INSERT INTO wbi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","uYesu akamwamul akati, 'kiki ghukung'emela nnono? nakwale umuunhu juno nnono, loli ju Nguluve mwene. ");
INSERT INTO wbi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","usikagwile indaghilo nunga vwafukaghe, nungabudaghe, nungahijaghe, nungolekaghe uvudesi, umwoghopaghe uvaaso nu mamajo. ");
INSERT INTO wbi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","um'baha jula akati, 'isio sooni nigadilile kuhuma ye nili nsoleka”. ");
INSERT INTO wbi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","uYesu ye asipulike isio akam'bula, “upeelile ikinu kimonga. lunoghile ughusie ifinu fyoni fino ulinafyo neke uvaghavile avakotofu, najuve ghuliva ni kyuma ku kyanya - kange ghwise umbingilile'. ");
INSERT INTO wbi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","neke umofu ye apulike aghuo, akasukunile kyongo ulwakuva alyale ni kyuma kinga. ");
INSERT INTO wbi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","pe pano uYesu, akam'bona vule asukunile kyongo akati, 'lutalamu kyongo avanya kyuma kukwingila ku vutwa vwa Nguluve! ");
INSERT INTO wbi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","lwakuva kihugu kyongo ingamila kukilila pa kilioli kya sindano, kuliko kwa mmofu kukwingila ku vutwa vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","vala vano valyapulike aghuo vakati, pe ghweveni lino juno ndepoonu ipokua?' ");
INSERT INTO wbi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","uYesu akamula akati, 'sino avaanhu vikunua kuvomba ku ngufu saave neke kwa Nguluve sivombeka'. ");
INSERT INTO wbi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","uPeteli akati, 'Ena, usue tufilekile ifinu fyoni tukuvingilile uve.' ");
INSERT INTO wbi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","pe pano uYesu akavavula, kyang'haani nikuvavula kuuti, nakwale umuunhu juno ajilekile inyumba, nambe un'dala nambe unyalukolo nambe avapafi nambe avaanha vwimila uvutwa vwa Nguluve, ");
INSERT INTO wbi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","juno naikwupila minga kukila mu iisi iji, na mu iisi jino jikwisa uvwumi vwa kusila na kusila. ");
INSERT INTO wbi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","pe baho ye vakong'anisie vala kijigjo na vavili, akavavula, 'lola, tutogha kuluta kuYelusalemu, na masio ghoni ghano ghalembilue na vavili kujova isa mwana ghwa Muunhu kuuti ghikwilana. ");
INSERT INTO wbi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ulwakuva iiva mumavoko gha vaanhu avaYahudi vikum'bedagha na pikumuligha na pikumfunyila amate. ");
INSERT INTO wbi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kange vikun'kopagha ni fijeledi na kukum'buda neke pakighono ikya vutatu isyuuka.' ");
INSERT INTO wbi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","navalyasikagwile sino ijova isi. nalilisio ili lifisilue kuveene, navalyasitang'inie sino sijovilue ");
INSERT INTO wbi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","pe lukava uYesu pano alipipi ku Yeliko, umuunhu jumonga um'bofu alikalile palubale lwa nsevo akaumagha vantange, ");
INSERT INTO wbi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ye apulike ilipugha lwa vaanhu likuling'ania akaposia kiki kihumila. ");
INSERT INTO wbi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","vakam'bula kuuti uYesu ghwa Nasaleti ikila. ");
INSERT INTO wbi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","pe um'bofu jula akalila fiijo akati, 'Yesu, mwana ghwa Davidi, unisaghile'. ");
INSERT INTO wbi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","vala vano valyale vighenda vakan'dalikila um'bofu jula, vakam'bula ujike. neke umwene akaghina kulila fiijo, 'mwana ghwa Davidi, usanighile. ");
INSERT INTO wbi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","uYesu akima akasuuma umuunhu jula vamulete kwa mwene. pe um'bofu jula ye amuvelelile, uYesu akamposia, ");
INSERT INTO wbi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ghulonda nikuvombele kiki? akati, 'Mutwa, nilonda kulola'. ");
INSERT INTO wbi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","uYesu akam'bula, 'lino ulolaghe. ulwitiko lwako lukusosisie'. ");
INSERT INTO wbi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ku nsiki ghughuo akavisagha ilola, akam'bingilila uYesu na kukumughiniauNguluve. vati valyaghile ili, avaanhu vooni vakamughinia uNguluve. ");
INSERT INTO wbi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","uYesu akingila na kukila pakate pa Yeliko. ");
INSERT INTO wbi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","apuo pealyale umuunhu juno atambuluagha Sakayi. juno alyale m'baha ghwa vasongesia songo kange muunhu ghwa vumofu. ");
INSERT INTO wbi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","alyale ighela kukumwagha uYesu kuuti mwana ghwa ndani, neke akakunua kukumwagha ulwakuva alyale mfupi kange pe likale ilipugha lwa vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","pepano akalongola luvilo kuvulongolo ku vaanhu, akatogha kukyanya mu n'kuju kuuti amwaghe, ulwakuva uYesu alyale pipi pikila isila ijio ");
INSERT INTO wbi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","un'siki ghuno uYesu afikile pala, akalola kukyanya akam'bula akati, “Sakayi ika ng'haani ng'haani, ulwakuva umusyughu lunoghile kulinda ku nyumba jako” ");
INSERT INTO wbi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","akavomba ng'haani ng'haani, akika na kumwambilila ku lukeelo. ");
INSERT INTO wbi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","avaanhu vooni vakatile vaghaghile aghuo vaking'ulasya vakati, 'alutile kukumughendela umuunhu unya sambi. ");
INSERT INTO wbi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","uSa'kayi akimile akam'bula uMutwa kuuti, 'loola lubale lwa kyuma kyango nikuvapela avakotofu, kange nave umuunhu ghweni nin'kunyile ikinu, nikun'gomokesia kane'. ");
INSERT INTO wbi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","uYesu akam'bula akati, 'umusyughu uvupoki vufikile mu nyumba iji, ulwakuva umwene kange ghwe mwana ghwa Abulahamu. ");
INSERT INTO wbi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","lwakuva umwana ghwa muunhu isile kulonda na kupoka avaanhu vano vasovile. ");
INSERT INTO wbi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ye apulike aghuo, akaghendelile kujova na kuhumia ikihwani, ulwakuva akale pipi na kuYelusalemu, voope vakasaghile kuuti uvutwa vwa Nguluve vulyale pipi kuvoneka ku lwakwasia. ");
INSERT INTO wbi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","pepano akavavula akati, uNtwa jumonga akalutile ku iisi ija kuvutali kuuti pile uvutwa neke agomoke. ");
INSERT INTO wbi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","akavakemhela avavombi vake kijigho, akavapela filundo kijigho akavavula akati, “muvombaghe imbombo ija kufulusia kuhanga pano niligomoka” ");
INSERT INTO wbi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","neke avaanhu vake vakan'kalalilagha pe pano vakavasung'a avomolua valute vamfuate na kukum'bula kuuti, “natulonda umuunhu uju atulongosie” ");
INSERT INTO wbi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","akatile agomwike ye apelilue uVutwa, akavakemhela avavomvi vala vano akavalekile indalama vakemhelue vake, neke akagule vafulwisie ndani. ");
INSERT INTO wbi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ughwa kwanda akisa akati, “Mutwa ikipupa kyako kino ukamhelile kifulyisie ifighavo kijigho, ");
INSERT INTO wbi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","UNtwa jula akam'bula, uvombile vunofu uve uli mb'ombi n'nofu, ulwakuva ghwa kolopalile mu fidebe, nikupela kutema amapulo kijigho. ");
INSERT INTO wbi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ughwa vuvili akisa akati, 'Ntwa, ikipupa kyako kifulwisie ifipupa fihaano. ");
INSERT INTO wbi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","'UNtwa ujuo akam'bula akati, 'najuve tola uteme amapulo ghahaano. ");
INSERT INTO wbi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","nu junga akisa akati, Ntwa iji apa indalama jako, jino nikapinyile vunono mu kyenda, ");
INSERT INTO wbi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ulwakuva nikoghwipe kuuti uve uli muunhu n'kali. ghuvusia kino nu vikile na kupeta kino nukavwalile. ");
INSERT INTO wbi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","uNtwa ujuo akam'bula, 'ku masio ghako juve nikukuhigha, uve uli m'bombi m'bivi. ulyakagwile kuuti une nili muunhu m'bivi nitola kino nanivikile na kupeta kino nanikavwalile. ");
INSERT INTO wbi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","pe, ongo nikavikile indalama jango ku vano vifulusia, nneke kyande nigomwike nitole palikimo na sino sifulwike? ");
INSERT INTO wbi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","uNtwa akam'bula avaanhu valyale vimile apuo, 'mun'kunye ikipupa ikio na kukumpela jula unya fipupa kijigho. ");
INSERT INTO wbi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","vakam'bula kuuti Ntwa, umwene ali ni filundo kijigho. ");
INSERT INTO wbi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","nikuvavula, umuunhu ghweni juno alinakyo ipelua kukila, neke juno nsila, kyope kino alinakyo kilipokua. ");
INSERT INTO wbi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","neke avalugu vango ava, vano navakanoghilue nive mutwa ghwa vanave, mu valete pavulongola apa neke muvabude. ");
INSERT INTO wbi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","akatile ajovile isio, akaghendelelagha kuluta kuvulongolo akatogha na kuluta ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","akatile avelelile pa Betigage, pipi nikidunda kya miseituni, akavasung'a avavulanisivua vake vavili. ");
INSERT INTO wbi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akajova akati, 'mulutaghe pakikaaja kya pavupipi. mungingile mukujagha inyana ja dogovi najighelile kujangalilwa taasi, mujavulile mujilete kulyune. ");
INSERT INTO wbi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","nave umuunhu ikuvaposia, 'kiki mukujavula?' mutisaghe, “uNguluve ali nuvufumbue najo. ");
INSERT INTO wbi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","vala vano akavasung'ile vakaluta vakajagha inyana ja dogovi, ndavule uYesu vuno akavavulile. ");
INSERT INTO wbi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ye vikujavula inyana ja dogovi, avanyanajo vakav aposia “kiki mukujavula inyana ja dogovi iji? ");
INSERT INTO wbi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","vakavamula vakati,” uMutwa ali nuvufumbue najo” ");
INSERT INTO wbi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","pe vakan'twalila uYesu, vakatandika amheenda ghave pakyanya pa nyana ja dogovi, neke vakan'tosia uYesu pakyanya. ");
INSERT INTO wbi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","uYesu ye iluta avaanhu valyale vitandika amheenda ghave mu nsevo. ");
INSERT INTO wbi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","akatile ikwika ikidunda kya miseituni ni kipugha kyoni ikya vavulanisivua, vakatengula kukumpaala uNguluve ni lisio ilikome vwimila ifidegho vuno valyavombilue. ");
INSERT INTO wbi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","vakajova, 'aaghinwaghe u Ntwa juno ikwisa mulitavua lya Mutwa! ulutengano kukyanya, nu vwimike kukyanya. ");
INSERT INTO wbi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","avafarisayi vamonga mu kipugha vakam'bula vakati, m'bulanisi, vajikisie avavulanisivua vako, ");
INSERT INTO wbi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","uYesu akavamula akati, 'nikuvavula ndeve ava vijigha kimie amavue ghilijova amasio. ");
INSERT INTO wbi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","UYesu ye alipipi nu mpulo akaghulilila, ");
INSERT INTO wbi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akati, nave ghwale ukagule nambe juve, mu kighono iki sino unoghile kuvoma neke uve nulutengano! neke sifisilue pa maaso ghako. ");
INSERT INTO wbi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ulwakuva ifighono fikwisa fino avalugu vako vijenga ililugu pipi nuve, na kukusyuta na kukughindilikisia kyhuma mu mbale sooni. ");
INSERT INTO wbi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","vikukughwisia paasi uve na vaanha vako. navikulekesia nambe mu livue limo pakyanya ja linge, ulwakuva nukakagwile unsiki ghuno uNguluve alyale ighela kukupoka. ");
INSERT INTO wbi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","uYesu akingila mu nyumba ija kufunyila, akatengula kuvadaga vala vano vakale vighusia, ");
INSERT INTO wbi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","akavavula,” jilembilue, inyumba jango jiliva nyumba ja kufunyila, neke umue musyetulinie kuva lipango lya vakunyi”. ");
INSERT INTO wbi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","pe lino uYesu alyale ivulanisia ifighono fyoni ku nyumba ja kufunyila. aatekesi na vavulanisi va ndaghilo na valongosi vavaanhu valyalondile kukum'buda, ");
INSERT INTO wbi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","neke navakakunua kujagha isila ja kuvomba ndikio, ulwakuva avaanhu voni valyale vikumpulikisia vunono. ");
INSERT INTO wbi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","kiliva kighono kimo, UYesu ye alyale ivulanisia avaanhu ku nyumba inyimike ja kufunyila na kudalikila ilivangili, avatekesi avavaa na vavulanisi va ndaghilo vakamulutila palikimo na vaghogholo. ");
INSERT INTO wbi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","vakajova, vakam'bula, 'tuvule kwe kuvutavulua vuliku ghuvumba agha? nambe ghwe veeni ujuo juno akupelile uvutavulua uvu?” ");
INSERT INTO wbi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ghwope akamula akati, 'najune kange nikuvaposia. munivule ");
INSERT INTO wbi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ulwofugho lwa Yonani pe lukahumile ku kyanya au kuvaaahu?' ");
INSERT INTO wbi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","neke vakajofesania vavuo ku vavuo, vakatisagha, 'tungati, 'lukahumile kukyanya akutuposia, 'ongo pe namukamwitikile? ");
INSERT INTO wbi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","kange tungati; lukahumile ku vaahu; avaanhu vooni apa kya vikutotava na mavue, lwakuva vooni vikwitika kuuti uYoani alyale m'bili. ");
INSERT INTO wbi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","pe vakamwamula lwa kuva navakakagwile kuno lulyahumile. ");
INSERT INTO wbi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","uYesu akavavula, “najune nanikuvavula umue kwe kuvutavulua vuki nivomba agha.” ");
INSERT INTO wbi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","alyavavulile avaanhu ikihwani iki, “umuunhu jumonga alyavyalile umughunda ghwa misabibu, akaluta iisi ijinge ku nsiki ntali. ");
INSERT INTO wbi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ku nsiki ghuno ghunoghile, akansung'ile um'bombi kuvalimi va misabibu, neke avalimi va misabibu vakantova, vakan'gomosia mavoko ghene. ");
INSERT INTO wbi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","pe akansung'a kange um'bombi ujunge ghwope vakantova, na kum'bombela inyivi, na kukun'gomosia mavoko ghene. ");
INSERT INTO wbi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","akansung'a kange ughwa vutatu ghwope vakamulemasia na kukuntagha kunji. ");
INSERT INTO wbi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","lino untwa ghwa mughunda akati, 'kya nivomba kiki? nikunsung'a umwanango umughanike. pamo valamwitika. ");
INSERT INTO wbi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'neke avalimi va sabibu vati vamwaghile, vakajofesania vavuo ku vavuo vakatisagha, 'uju ghwe nya kyuma. tum'bude neke ikyuma kyake kive kitu. ");
INSERT INTO wbi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","vakamwumia kunji ku mughunda ghwa misabibu na kukum'buda. pe unyamughunda kwale ikuvavomba kiki? ");
INSERT INTO wbi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ikwisa kukuvabuda avalimi va misabibu, na kukuvapela avange umughunda ughuo”. vope ye vapulike aghuo, vakati, 'uNguluve akanile'. ");
INSERT INTO wbi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","neke uYesu akavalola akavaposia, akati, “pe amalembe agha ghali nuvufumbue vuki? ilivue lino avajengi valyalikanile, lino lye livue lya npanguto? ");
INSERT INTO wbi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","umuunhu ghweni juno ighua pa kyanya pa livue ilio, idenyeng'ana kyongo. neke jula juno lingamughwile, liku'ndijania kyongo” ");
INSERT INTO wbi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","lino avalembi na vavaha va vatekesi valyalondole isila ja kukun'kola mu nsiki ghughughuo, valyakagwile kuuti alyajovile ikihwani iki kuveene. neke vakavoghwipe avaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","vakamulola vunono, vakasung'a vano viposelesia vano vikuvona kuva vaanhu va kyang'haani, neke vavwaghe uvuhosi ku malembe ghake, neke kun'twala ku vatemi na vanya vutavulua. ");
INSERT INTO wbi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","vope vakamposia, vakati, “m'bulanisi tukagula kuuti ghujova na kuvulanisia isa lweli kisila kusyangua nu muunhu ghwoghwoni, neke uve ghuvulanisia ilweli kujova isa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","pe lunoghile kulyusue kuhomba isongo kwa Kaisali au nambe?” ");
INSERT INTO wbi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","neke UYesu alyakagwile ulutegho lwavo, akavavula, ");
INSERT INTO wbi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","munisone ihela idinali. ikihwani ni litavua lyani fili kyanya jaake?” vakati, “lya Kaisali”. ");
INSERT INTO wbi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ughwope uYesu akavavula akati, 'pe mumpele uKaisali ifya kaisali, nu Nguluve ghano gha Nguluve; ");
INSERT INTO wbi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","avalembi na vavaha va vatekesi vakakunilue kukagula kila kino alyajovagha pavulongolo pa vaanhu. vakadegha ulwamulo lwake navakajova kyokyoni. ");
INSERT INTO wbi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","avasadukayi vamonga vakamulutila, vala vano vijova kuuti avafue navalasyuka, ");
INSERT INTO wbi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","vakamposia vakati, “m'bulanisi uMoose alyatulembile kuuti nave umuunhu angafwilue nu nyalukolo unya n'dala juno nsila mwana pe anoghile kukuntola un'dala ghwa nyalukolo ghwake na kuhola naghwo vwimila ulumbulie. ");
INSERT INTO wbi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","kulyale na vanyalukolo lekela lubale, ughwa kwasia akatola akafua kisila kuleka umwana, ");
INSERT INTO wbi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","nughwa vuvili ghwope. ");
INSERT INTO wbi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ughwa vutatu akantola vulevule, enendikio ughwa lekela lubale naakalekile avaanha akafua. ");
INSERT INTO wbi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","pambele un'dala jula ghwope akafua. ");
INSERT INTO wbi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","lino nave kwelule ulusyuko iiva nd'ala ghwani? ulwakuva vooni lekela lubale valyantolile'. ");
INSERT INTO wbi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","uYesu akavavula, “vaanha va iisi iji vitola na kutolua. ");
INSERT INTO wbi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","neke vala vano vanoghile kukwupila uvusyuko vwa vafue na kukwingila mu vwumi vwa kusila na kusila navitola nambe kutolua. ");
INSERT INTO wbi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","nambe navala fua kange, ulwakuva viiva palikimo na vanyaMhola ve vaanha va Nguluve, vaanha va vusyuko. ");
INSERT INTO wbi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","naju Moose alyajovile kuuti avavue vilisyuka. alyajovile uluo mu malembe mu lwa kihinja kino kilyale kivvika, alyatiile u Mutwa ndavule uNguluve, ghwe Nguluve ghwa Abulahamu, ghwe Nguluve ghwa Isaka, kange ghwe Nguluve ghwa Yakovo”. ");
INSERT INTO wbi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","lino umwene naghwe Nguluve ghwa vafue, looli avwumi ulwakuva vooni vikukala kwa mwene”. ");
INSERT INTO wbi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","pe avavulanisi vamonga ava ndaghilo vakamwamula, vakati m'bulanisi ghwamwile vunono. ");
INSERT INTO wbi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","kutengulila apuo vakava vikwoghopa kukumposia. ");
INSERT INTO wbi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","uYesu akavaposia akati, “asi lwa ndani avaanhu viitiuKilisite mwana ghwa Ntwa Davidi? ");
INSERT INTO wbi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ulwakuva uDavidi jujuo alyalembile mu kitabu kya sabuli alyatile, uMutwa alyam'bulile umutwa ghwango ghukale uluvoko lwa kundio, ");
INSERT INTO wbi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kuhanga nikutange uvaleme avalugu vaako paasi pa maghulu ghako, ");
INSERT INTO wbi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","uDavidi ikunkemela Kilisite 'Mutwa' pe iiva ndani mwana ghwa Davidi”? ");
INSERT INTO wbi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","avaanhu vooni ye valyale vikumpulikisia akavavula avavulanisivua vaake akati, ");
INSERT INTO wbi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","mujilolelelaghe na valembi, vano vilonda kughenda kuno vafwalile amenda amatali, na kunoghua kuuti avaanhu vavahungilaghe nu vwoghofi mumapuulo. pano vali mu nyumba isa kufunyila vilonda kukukala ku fitengo ifya kuvulongolo na mu fikulukulu vikukala mu fitengo fya voghopua. ");
INSERT INTO wbi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","avaanhu ava vikuunya ifinu ifya vafwile! neke muvukedusi vwake vikufunya inyifuunyo inhaali, kuuti avaaanhu vatisaghe vagholofu. mu uluo uNguluve ikuvapeela ulupumuko ulukome kukila. ");
INSERT INTO wbi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","uYesu akalila akavagha avakinhaata vamofu valyale vivika amatekelo ghave muvutile ");
INSERT INTO wbi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","akamwagha unfwile jumonga nkotofu ivika isenti sake ivili. pe ");
INSERT INTO wbi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","akati,”kyang'haani nikuvavula unfwile uju unkotofu ivikile indalama nyinga kukila avange voooni. ");
INSERT INTO wbi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ava vooni vahumisie ilitekelo ili kuhuma mufinga fino valinafyo. neke unfwile uju mu vukotofu vwake ahumisie indalamasooni sino avele naso vwimila uvwumi vwake” ");
INSERT INTO wbi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ye avange valyale vijova isa nyumba inyimike ja kufunyila, ndavule jilyavikilue na mavue amanono na matekelo, akati, ");
INSERT INTO wbi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","mu mhola isa mbombo sino mukusagha, ifighono fikwisa fino nakwekuliva nilivue limo lino lililekua nkyanya ja livue ilinge lino nalilighua. ");
INSERT INTO wbi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","pe vakamposia vakati, Mbulanisi isi sooni silihumila lighi? kwe kiliku kino kiliva kye kivalilo kuuti agha ghalipipi kuhumila? ");
INSERT INTO wbi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","uYesu akamwamula, “muvisaghe maaso kuuti namungasyanguaghe. ulwakuva vingi vikwisa ku litavua lyango viti,”une nene, nu nsiki ghulipipi. namungavavingililaghe. ");
INSERT INTO wbi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","mungapulike ivuluguvulugu namungoghwopaghe, ulwakuva isi sooni sinoghile sihumile taasi. neke uvusililo navulihimila ng'hani ng'hani” ");
INSERT INTO wbi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","pe pano akavavula,” iisi jilikwima na kutovana ni jinge, uvutwa ku vutwa uvunge. ");
INSERT INTO wbi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","kuliva ni finsenyena ifikome, injala ni nhamu isa kwambukila siliva papinga. kwe kuliva ni finu fya kwoghofia ni fivalilo fya kwoghofia kuhuma kukyanya. ");
INSERT INTO wbi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","neke isio sooni ye sikyale kuhumila, tiko avaanhu vilikuvakoola umue na kukuvapumusia. vilikuvawala kukuahigha mu nyumba isa kufunyila, na kukuvadindila mu ndinde. kange mulitwalua ku vatwa na ku vanya vutavulilua kuuti muhighue ulwakuva umue muli vavvulanisivua vango. ");
INSERT INTO wbi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","neke kulyumue aghuo ghuva ghwe nsiki ghwa kwoleka ulwitiko lwinu. ");
INSERT INTO wbi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","pe lino mwamulaghe mu moojo ghinu ku ling'ania avimilisi viinu ye lukyale. ");
INSERT INTO wbi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ulwakuva nikuvapela amasio agha vukoola vuno avalugu viinu voni vikunuagha kusigha na kukujikana. ");
INSERT INTO wbi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","neke mulikanwa na vapafi vinu, avanyalukolo vinu, avapipi vinu na vamanyani vinu, kange vilikuvabuda vamonga mu lyumue, ");
INSERT INTO wbi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","vilikunkalalila umuunu ghweni ku litavua lyango. ");
INSERT INTO wbi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","neke nakwelule nambe ulunyele lumo lwa matu ghinu luno lulisova. ");
INSERT INTO wbi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ku lugudo mukusisosia inumbula sinu. ");
INSERT INTO wbi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","kyale muvoona ilikaaja lya Yelusalemu lisyungutilue navalua lilugu pe mukagulaghe kuuti unsiki ughwa kutipulua ghuli pipi. ");
INSERT INTO wbi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","apuo vano vali ku Yudea vakimbililaghe ku fidunda, na vala vano vali pakate pa mpulo vavukaghe, kange namungavalekaghe vano vali kufikaaja kukwingila. ");
INSERT INTO wbi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ulwakuva ifi fye fighono fya kuhombekesia, neke kuuti ghooni ghano ghalembilue ghiise kuvombeka. ");
INSERT INTO wbi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","iga ku vala vano vali nuvukunue na vala vano vikwong'esia ku fighono ifio! ulwakuva kuliiva nulupumuko lukome mu iisi, ni ng'halasi ku vaaanhu ava. ");
INSERT INTO wbi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","avaanhu avange vilibudua ni bambaavange vilitwalua ku vukamiku iisi isinge, ni Yelusalemu jilikanyua na vaanhu va iisi kuhanga unsiki ghwa vaanhu va iisi pano ghuuva ghufikile. ");
INSERT INTO wbi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","fili vineka ifivalilo ku lijuva, umwesi ni nhondue, neke pa iisi apa inyanja siliva na mavingo amavaha amanya mughindi, uluo lulipelela avaanhu ava fisina fyonikuuva nulupumuko nu ludwesi. ");
INSERT INTO wbi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","isi sooni siliva sikwisa mu iisi, avaanhu ghulifua umwoojovwimila kukwoghopa kyongo. vilisaghagha kuuti lukwisa ulutalamu ulukome, ulwakuva ifinu ifya kukyanya filisukanisivua, ");
INSERT INTO wbi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","pepano vilikumwagha umwana ghwa muunhu ikwisa kuhuma mumafunde ku ngufu nu vwimike uvuvaha. ");
INSERT INTO wbi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","neke isio sooni silava sitengula kuhumila, mwimaghe, inulagha amatu ghinu, ulwakuva uvupoki vwinu vuvelelile pavupipi. ");
INSERT INTO wbi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","uYesu akavavula ku kihwanikisio akati, lolagha umpiki ghwa tini na mapiki ghoni. ");
INSERT INTO wbi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","pano muvona amapiki ghatengwile kulemba, mukujilolela jumue na kukagula kuuti amasiki gha lufuke ghalipipi. ");
INSERT INTO wbi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","vule vule pano muvona agha ghihumila umue kagulagha kuuti, uvutwa vwa Nguluve vulipipi. ");
INSERT INTO wbi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","kyang'haani nikuvavula, ikisina iki nakilikila, kuhanga isi sooni sihumile. ");
INSERT INTO wbi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","uvulanga ni iisi silikila, neke amasio ghango looli naghilikila. ");
INSERT INTO wbi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","neke mujilolelelaghe jumue, neke kuuti, amoojo ghinu naghangalemuaghe nu vuhojofu, uvughasi, nuvukaming'anilua vwa iisi iji. ulwakuva ikighono ikio kilavisila mu lwa ng'enyemukila hwene lutegho. ");
INSERT INTO wbi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ulwakuva jiiva kwa muunhu ghweni juno ikukala pa maaso gha iisi jooni. ");
INSERT INTO wbi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","lino muvisaghe maaso unsiki ghwoni, mun'sumaghe uNguluve kuuti muva lukangafu lwa kukwilana kukughaseghuka agha ghoni ghano kyale ghihumila, na kukwima pavulongolo pa mwana ghwa Muunhu”. ");
INSERT INTO wbi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","mu fighono ifio pamwisi, uYesu alyale ivulanisia avaanhu mu luviika ulwa nyumba inyimike ja kufunyila. pakilo akalutagha kughona ku kidunda ikya Miseituni. ");
INSERT INTO wbi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","neke jaatu avaanhu voni vakasisimukagha lulwakilo na kuluta mu nyumba inyimike ja kufunyila kuuti vampulikisie. ");
INSERT INTO wbi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","pe baho ikyimike ikya makate ghano naghavikilue ikilule ye kilipipi, kino kikakemeluagha pasaka. avavaha na ");
INSERT INTO wbi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","vatekesi palikimo na vavulanisi va ndaghilo, vakapuling'hana kulonda isila ija kum'buda uYesu. ulwakuva vakoghopagha avaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","uSetano akingila kwa Yuda isikalioti, juno alyale m'bulanisivua kuvala vano vaale kijigho na vavili. ");
INSERT INTO wbi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","uYuda akaluta kupuling'hana na vavaha vavatekesi ku sila ja kukotola uYesu kuveene. ");
INSERT INTO wbi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","vakahovoka, na kupuling'ana vampeele indalama. ");
INSERT INTO wbi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","umwene akitika, pe akalonda unsiki ghwa kukunkotola uYesu kuveene pano pasila lipugha lya vaanhu. ");
INSERT INTO wbi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ikighono kya makate ghano naghavikilue ikilule lulyafikile kuuti,” ing'olo ja pasaka umpaka jibudue. ");
INSERT INTO wbi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","pe uYesu avasung'ha uPeteli nu Yohani, aaula,” luta mukatuling'anikisie ikyakulia kya Pasaka neke twise tulie” ");
INSERT INTO wbi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","akavaposia,” poki pano ghulonda tukapaling'anisie? ");
INSERT INTO wbi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","akavamula, “pulikisia kyamuvweene mwingile mulikaaja lino umukibaba apindile ulusaaji lwa malenga kumwaitang'anila nu mue mumbingililaghe kuhanga kufiika kunyumba jino ikwingila. ");
INSERT INTO wbi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","apuo, mum'bule unyanyumba 'ntwa ghwa nyumba, um'bulanisi ikukuposia kilikughi ikyumba kya vahesiapano nilila ipasaka na vavulanisivua vango?” ");
INSERT INTO wbi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ikuvasona ikyumba ikya ikyapakyanya kino kiling'anisivue mweumalile ulupinyo uluo. ");
INSERT INTO wbi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","pe vakaluta, vakavaghile avaanhu voni vavombile ndavule vavulanisivue. pepano vkaling'anisia ikyakulia kya Pasaka. ");
INSERT INTO wbi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","unsiki ye ghufikile akikalile na vasung'ua. ");
INSERT INTO wbi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","pepano akavavula, “nilinuvusyukue luvaha fiijo lwa kulia ikyimike kya Pasaka. numue yenikyale piluta mulupumuko lwango. ");
INSERT INTO wbi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ulwakuva nikuvavula, nanilia kange kuhanga kyalukwisa lujovue kuvutwa vwa Nguluve” ");
INSERT INTO wbi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","pebaho uYesu akatola ikikombe, akahongesia akati, “kogho iiki, mughavane jumue na jumue. ");
INSERT INTO wbi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ulwakuva nikuvavula nanilanyua kange uluhuje lwa misabibu, kuhanga uvutwa vwa Nguluve vulava vukwisa. ");
INSERT INTO wbi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","pebaho akatola unkate ye ahongisie, akamenyulania akavapeela akati,” ughu ghwe m'bili ghwango ghuno ghukavulilue vwimila umue. fyemuvombaghe vulevule kukung'umbuka une.” ");
INSERT INTO wbi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","akatola ikikombe vulevule ye valile ikyakulia kya pakilo akti, “ikikombe iki lwe lupigho lwango ulupya mu danda jango. lino jikung'ike vwimila jinu. ");
INSERT INTO wbi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","looli mulumanyaghe umuunhu juno ikunyohela ali bahapa tuli lumo na pilia. ");
INSERT INTO wbi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ulwakuva umwana ghwa nyamuunhu sakyang'ani iluta jujuo ndavule lwa jovilue looli iga kwa muunhu jula juno kuhumila umwene umwana ghwa nyamuunu ikwohelua!” neke ");
INSERT INTO wbi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","vakatengula kuposesania vavuo ku vavuo veeni mu lipugha lya vanave juno asivombile isio. ");
INSERT INTO wbi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","neke lukahumila kukaning'hana mulipugha lya vanave kwiti ghweveni mulipugha litu juno vikunsagha kwiti ghwe m'baha kukila vooni. ");
INSERT INTO wbi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","akavavula,” avatemi va vaanhu avamuiisi valinuvutwa ku veene, na vano vali nu vulamusi vwaavevitambulua voghopua. ");
INSERT INTO wbi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","neke nalulondivua kyongo kulyumue umue pamo kange, muleke juno m'baha kulyumue, ave ndebe. na jula juno ghwe ilondua fiijo ave ndavule unyambombo kwa munhu. ");
INSERT INTO wbi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ulwakuva veeni um'baha juno ikukala pilia kange ikuvavombela? najune nikyale nighwanine nilindavule jumue ndavule juno ikuvavombela. ");
INSERT INTO wbi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","looli umue mwemue mujigha kuva nune mungelo sango. ");
INSERT INTO wbi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","nikuvapela umue uvutemi. ndavule uNhaata alyamelile une uvutemi. ");
INSERT INTO wbi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kuuti mupevue kulia nakunyua pavulilo vwango pa vutwa vango neke mukukala pa fitengo fya vwimike pano mukufihigha ifisina kijigho na fivili ifya Isilaeli. ");
INSERT INTO wbi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simoni, Simoni ulukagulaghe kwiti, uSetano asuumile neke avepeete hwene ngano. ");
INSERT INTO wbi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","neke nikufunyile, kuuti ulwitiko lwako nalungakunuaghe. pano kyale ugomwike kange, vakangasiaghe avanyalukolo vako” ");
INSERT INTO wbi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","uPeteli akam'bula, “Mutwa, linitayale kuluta nuve kundinde nambe mu vufue”. ");
INSERT INTO wbi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","uYesu akamwamula akati, nikukuvula Peteli, ing'ongove ye jikyale kuvika umusyughu, ukung'ana katatukwiti naung'agwile” ");
INSERT INTO wbi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","pebaho uYesu akavavula,” ye nivwatwalile umue vusita kifuko, nambe indiilo ija fyakulia, nambe ifilatu, pe kinu kiki kilyapelelile?” vakamwamula kuuti,”nakwale” ");
INSERT INTO wbi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","pepano akavavula,” neke lino umuunhu ghweni juno alinikifuko, atole palikimo ni ndilo ja fyakulia. na juno nsila nambe vubamba lumunoghile aghusie umwenda ghake neke aghule ghumo. ");
INSERT INTO wbi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ulwakuva nikuvavula, sooni sino silembilue vwimila uune lunoghile sivombeke, 'na kutolua ndavule umuunhu juno vikun'kola ghwene n'denya ndaghilo. ulwakuva kila kino aavavili valyajovile vwimila uunekukwisa. ");
INSERT INTO wbi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","neke vakajova kuuti, Mutwa, lola isi apa ibamba ivili” pe akavavula “lukwilile” ");
INSERT INTO wbi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ye valile ikyakulia kya pakilo. uYesu akavuuka ndavule fino akasivombagha jaaatu. akaluta kukidunda kya Miseituni. voope avavulanisivua vake vakam'bingilila. ");
INSERT INTO wbi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ye vafikile akavavula, “musuumaghe neke muleke kukwingila mungelo. ");
INSERT INTO wbi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","akaluta patali navo hwene livue vajughwije pe akafughama akifunya. ");
INSERT INTO wbi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","akati, Nhaata nave lunoghile umbusikisiee ikikombe iki. neke nakwekuti ndavule nilonda une looli sivombeke ndavule ghughanile juuve.” ");
INSERT INTO wbi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","neke pebaho avanyaMhola kuhuma kukyanya akamwisila, akampeela ingufu. ");
INSERT INTO wbi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ye alimuvuvafi, akasuuma kulukangasio fiijo, najinwing'a jikadomola paasi nyinga hwene danda. ");
INSERT INTO wbi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ye akifunyile akima kuhuma kulufunyo lwake akaluta kuva vulanisivua vaake akavona vaghonelile ulwakuva valyale nulusukunalo. ");
INSERT INTO wbi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","akavaposia,” kiki mughonelile? musisimuke mufuunye, tuleke pikwingila mungeli” ");
INSERT INTO wbi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ye akyale pijova pe ilipugha lya vaanhu vinga likisa naju Yuda juno aale m'bulanisi ghake ghwe jumo na vala kijigho na vavili akavalongola kwa Yesu neke anonele. ");
INSERT INTO wbi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","neke uYesu akambula,” Yuda ghukumwohela umwana ghwa nyamuunhu ghwa na pikunonela? ");
INSERT INTO wbi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","pe avavulanisivua va Yesu ye valipipi naghwo yevakavwene aghuo ghano ghivombeka vakati,” Mutwa ndaani tuvatove nu m'bamba? ");
INSERT INTO wbi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","neke jumo mu veene akantova nu m'bamba ukami ghwa ntekesi. um'baha akadumula imbughulutu ijakundio. ");
INSERT INTO wbi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","uyEsu akajova akati, ulu lukwilile. akatola imbughulutu akabadika. ");
INSERT INTO wbi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","uYesu akajova kwa ntekesi um'baha na kuvavaha va nyumba inyiimike na kuvagoyo vano valisile vusila kukagula”. ndaani mukwisa hwene muli nilibaatu kange hwene mhiiji. ifivuunda, nasi bamba? ");
INSERT INTO wbi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ye nili numue ifighono fyooni munyumba inyimike namwavikagha amavoko nkyanya jango. neke ughu ghwe nsiki ghwako nu vutemi vwa ng'isi” ");
INSERT INTO wbi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","vakankola vakamulongosia, vakamuleta ku nyumba ja ntekesi. um'baha neke uPeteli akava ivingilila pavutali. ");
INSERT INTO wbi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","pepano ye vavwene vapembile umwoto munyumba. munkate ye vikalile paasi palikimo, uPeteli akikala pakate paveene. ");
INSERT INTO wbi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","unkami jumonga umwanahinja akam'bona uPeteli pano ikalile palumuli luno lukahumila mu mwoto, akamulola akam'bula umuunhu uju avele palikimo naghwo.” ");
INSERT INTO wbi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","neke uPeteli akaana akati, “ghwe n'dala uve uvee une nanimanyile” ");
INSERT INTO wbi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","unsiki ndebe, umuunhu akamwagha akati, “uve najuve mulivevamo” neke uPeteli akamwamula, “nemukibaba une jeje” ");
INSERT INTO wbi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ye ghukilile unsiki ghwa kavalilo kamo ndiiki, umughosi jumonga akankangasia akati,” lweli fiijo umuunhu uju avele luumo naghwo, ulwakuva kihwani kya vaGalilaya” ");
INSERT INTO wbi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","neke upeteli akati, “ghwe mughosi, nanisikaghwile sino ghujova” pebaho unsiki ghughuo yeijova, ing'hongove jivika. ");
INSERT INTO wbi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","akasyetuka umutwa akamulola uPeteli najuPeteli akakumbuka ilisio lino alyam'bulile uMutwa ye jikyale ing'hove pivika umusyughu, ghukung'hana une katatu. ");
INSERT INTO wbi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","akaluta kunji, uPeteli akatengula pilila kulusukunalo fiijo. ");
INSERT INTO wbi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","pepano avakinhaata vano vakamulolelagha uYesu, vakambenafulagha na pikumtova. ");
INSERT INTO wbi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ye vakamughimbika kumaaso vakamposia vakati, “iviile! ghweveni juno akutovile?” ");
INSERT INTO wbi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","vakajova nyinganyinaga kukum'benapula uYesu na kukumuligha. ");
INSERT INTO wbi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ye kukile palyakilo. avaghogholo kuvoni vakakong'ana palikimo, na vavaha vavatekesi na vavulanisi va ndaghilo, vakantwala kuvuhighi, ");
INSERT INTO wbi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","vakatisagha 'ndeve uve veve mwana ghwa Kilisite, tuvuule” neke umwene akavavula “nambe ningavavule, namunganyitike, ");
INSERT INTO wbi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kange ningavaposie namunganyamule”. ");
INSERT INTO wbi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","looli kutengulila lino na kulutilila, umwana ghwa nyamuunhu ikukala ku luvoko lwa kundio lwa Nguluve. ulunya ngufu ja Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","vooni vakati, kwekuti uve ulimwana ghwa Nguluve? neke uYesu akavavula, “umue mujovile kuuti une nene mwana ghwa Mutwa! ");
INSERT INTO wbi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","vakati, “kiki tukyale kange tulonda uvwoles? ulwakuva jusue tupulike amasio kuhuma mu mulomo ghwake” ");
INSERT INTO wbi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ilipugha lyoni vakima vakantwala uYesu pavulongolo pa Pilato. ");
INSERT INTO wbi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","vakatengula kukumuligha viti, tumwaghile umuunhu uju ikujisofia iisi jitu, ikutukana kuhumia isongo kwa Kaisali, kange ijova kuuti umwene ghwe Kilisite uNtwa. ");
INSERT INTO wbi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","uPilato akamposia akati, “vuli uve veve Ntwa ghwa vayahidi? uYesu akamwamula akati, “veve ghujova ndikio?” ");
INSERT INTO wbi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","UPilato akam'bula um'baha ghwa vatekesi nilipugha, “nanikughwagha unkole ghwa muunhu uju”. ");
INSERT INTO wbi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","avele ihovelesia avaanhu avulanisie muvuyahudi mwoni, atengulile ku Galilaya lino pwale kuno”. ");
INSERT INTO wbi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","uPilato ye apulike agha, akaposia nave umuunhu uju ghwa kuGalilaya? ");
INSERT INTO wbi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ye akagwile kuuti kuuti ali mu vutwa vwa Helode, akantwala u Yesu kwa Helode, ulwakuva ifighono ifio. ");
INSERT INTO wbi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","uHelode ati amwaghile uYesu, akahovoka kyongo ulwakuva ifighono finga akalondagha kukum'bona. akapulika imola sako akahuvilagha kulola ikidegho kimo kino kivombelua nu mwene. ");
INSERT INTO wbi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","uHelode akamposia uYesu amasio minga neke uYesu nakavamula kyokyoni. ");
INSERT INTO wbi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","avavaha vavatekesi na vavulanisi va ndaghilo vakima ni ng'alasi kukumuligha. ");
INSERT INTO wbi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","uHelode palikimo na vasikali vake, vakamuligha na kumbenafula, vakamfasia amenda amanono, pepano akan'gomosia uYesu kwa Pilato. ");
INSERT INTO wbi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","uHelode nu Pilato vakavisagha vamanyani kutengulila ikighono ikio ulwakwasia valyale valugu. ");
INSERT INTO wbi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","uPilato akavakemela palikimo avatekesi na avavaha na ni lipugha lya vaanhu, ");
INSERT INTO wbi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","akavavula akati, “muniletile umuunhu uju ndavule umuunhu juno ilongosia avaanhu kuvomba imbivi, lolagha nitile nimposie pavulongolo pa maaso ghinu nanighwaghile un'kole kwa muunhu uju ku ghoni ghano umue mukumuhigha umwene. ");
INSERT INTO wbi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ndali, ghwope uHelode ulwakuva alyan'gomwisie kulyusue, loola nakwekili kimonga kino avombile, kino kikumpelela afue. ");
INSERT INTO wbi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","pe lino nikun'kopa na kukumulekesia. ");
INSERT INTO wbi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","neke vooni palikimo vakova vakati, “m'busie ujuo un'dindulile uBalaba ");
INSERT INTO wbi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","uBalaba alyale muunhu juno avikilue mu ndinde ulwakuva alyavombile uvuhosi vumonga mu lipulo na kwa kubuda. ");
INSERT INTO wbi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","uPilato akavavula kange nilonda kumulekesia uYesu. ");
INSERT INTO wbi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","neke aveene vakajeghelagha viti, unkomelele, unkomelele”. ");
INSERT INTO wbi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","akavaposia ulwa vutatu, neke umuunhu uju avombile uvuhosi vuki?” nanikughwagha unkole ghuno ghukun'twalila abudue. lino ningamale kun'tova nikumulekesia. ");
INSERT INTO wbi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","neke vakaghina kukwov, vilonda kuuti, akomelelue. neke ilyovo lyake likamwitikisia uPilato. ");
INSERT INTO wbi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","pepano uPilato akalamula kuvomba ndafu muvufumbue vwake. ");
INSERT INTO wbi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","akamulekesia juno valyaneelile juno alyadindilue mulywa kupela ilibaatu na kubuda. neke akantavula uYesu ndavule mundondele saake. ");
INSERT INTO wbi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ye vikuntwala vakankola umuunhu jumo itambulua ghwe Simoni juno akahuma mu iisi ija Kilene, vakam'beghasia ikikovekano neke ipinde kumbingilila uYesu. ");
INSERT INTO wbi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ilipugha lya vaanhu navakijuva vano valyale vilila na kusukunala vwimila vwake navambingililagha. ");
INSERT INTO wbi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","neke akansyetukila, uYesu akavavula,”avahinja va muyelusalemumulekaghe kundilila uneloli mulilaghe vwimila mu lyumue na vwimila mu vaanha vinu. ");
INSERT INTO wbi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","lola ifighono fikwisa fino viliti, “vafunyilue vano vaghumba na maleme ghano naghapapile, na mavele ghano naghong'ilisie” ");
INSERT INTO wbi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","pepano vatengula kufivula ifidunda kuuti, “tughile ni fidunda mutukupike” ulwakuva ");
INSERT INTO wbi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","nave vivomba agha ku umwighu, pe luliva ndani ku ghuno ghumile?” ");
INSERT INTO wbi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","avaghosi avange avahosi vavili vakantwalagha palikimo nu mwene neke vabudue. ");
INSERT INTO wbi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ye vafikile pano vatambuluagha Lung'ala lwa muunhu, pepano pepano vakavakomelela palikimo na vahosi vala. jumo ulubale lwa kundio nujunge ulubale ulwa kung'ighi. ");
INSERT INTO wbi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","uYesu akam'bula, “Nhaata uvasaghile ulwakuva sino vivomba navasitaghinie “. voope vakatova ulusudolekughava amenda ghake. ");
INSERT INTO wbi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","avaanhu vakima kumo vikuvalola avavaha vuno vikumuhigha, na kuti, “alyavapokile avange na lino ipoke jujuo nave umwene ghwe Kiliste ghwa Nguluve Mwimike”. ");
INSERT INTO wbi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","avasikali voope vakam'benapula, vakam'belelela na kukumpela, isiki, ");
INSERT INTO wbi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","vakatisagha,”nave uve uli Ntwa ghwa vaYahudi ipoke juve ghwemwene” ");
INSERT INTO wbi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","kwekulyale kange ni kivalilo kwa mwene kino kilembilue “UJU GHWE MUTWA GHWA VAYAHUDI”. ");
INSERT INTO wbi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","umuhosi jumo juno akakemelilue akamuligha akati,” uve na veve Kilisite? ghupoke juve neke najusue” ");
INSERT INTO wbi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","neke ujunge jula akamwamula, akan'dalikila akati, “ghwe, uve naghukumwoghopa uNguluve, najuve uli muluhighilo luliku? ");
INSERT INTO wbi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","usue pwetule bahapa musakilweli, ulwakuva usue twukupila kinokinoghile ku maghendele ghitu. neke umuunhu uju naavombile ikivivi kyokyoni. ");
INSERT INTO wbi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","pe akongelesia kuuti,”Yesu ung'umbukaghe kyale ghukwingila mu vutwa vwako”. ");
INSERT INTO wbi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","uYesu akam'bula, kyang'haani nikukuvula, umusyughu ghuva nune ku Paladis”. ");
INSERT INTO wbi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","apuo jikale pipi nu n'tanda pa mwisi ing'isi jikisa jikakupikila iisi jooni kufikila ikivalilo ikya busika lubale” ");
INSERT INTO wbi_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ulumuli lwa lijuva lukasimile, pe baho umwenda ughwa nyumba inyimike ja kufunyila ghukademuka pakate kutengulila kukyanya. ");
INSERT INTO wbi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","pe uYesu akalila fiijo akati,” ghwe Nhaata nivika umwoojo ghwango mumavoko ghako” ye ajovile aghuo akafua. ");
INSERT INTO wbi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","uAkida ye asivwene sino sivombike akamughinia uNguluve akati, “kyang'haani umuunhu uju akale mugholofu.” ");
INSERT INTO wbi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","unsiki ilipugha ilya vaanhu vano vakisile sino sivombeka vakati vasivwene, vakagomoka kuno vikutovatova pafifuva fyave. ");
INSERT INTO wbi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","neke avamanyani vake navakijuva vano valyale vikumbingilila kuhuma ku Galilaya, valyimile patali vilola sino sivombeka. ");
INSERT INTO wbi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","lola, kwealyale umuunhu juno ghwope muli balasa akatambulwagha Yosefu juno alyale ghwope muli balasa, umuunhu unono nu nya kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","akale naiting'inie na masaghe na maghendele ghave, kuhuma ku Alimataya, umpulo ghwa kiYahudi ghuno ghulyale ghughulila uvutwa vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","umuunhu uju akam'belelela uPilato akansuuma am'pele um'bili ghwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","akamwisia na kunsyungukisia umwenda um'blafu akam'ka mumbipa jini jilyabughulike muli nalavue lino nakwale juno aghele kusyulua. ");
INSERT INTO wbi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","kilyale kighono kya kuling'ania ni sabati jilyale pipi. ");
INSERT INTO wbi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","avakijuva vano vakisile navope kuhuma ku Galilaya, vakalongosinie, vakajagha imbipa ghwene um'bili ghwake vaghughonisie. ");
INSERT INTO wbi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","vakagomoka na kutengula kutengelela amafuta gano ghinikilila, neke pakighono ikya Sabati vakapuma ndavule uvutavike vwa ndaghilo. ");
INSERT INTO wbi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","palwakilo kyongo ikighono kya kwasia valisile kumbipa, kuleta ifinu fino finukilila fino valyatendile. ");
INSERT INTO wbi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","vakavona ilivue livungulwike kutali ni mbipa. ");
INSERT INTO wbi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","vakingila mu'nkate, neke navakaghwagha um'bili ghwa Mutwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","jilyahumile kuuti, unsiki ghuno vakachanganyikivue, mu ilio kukenyemukila, avanhhu vamonga vavili vakimile pakate pavanave vafwalile amheenda amavalafu. ");
INSERT INTO wbi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","avadala valyale vamemile uvwoghofi na kusulamisia amaaso ghave paasi, vakavavula avadala, “kiki mukumulonda umwumi mu vafue? ");
INSERT INTO wbi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","apa napwale, neke asyukile! mukumbukaghe fino alyajovile kulyumue ye ali ku Galilaya, alyatile ndiki, “ ");
INSERT INTO wbi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","umwana ghwa muunhu anoghile kuvuka mu mavoko gha vaanhu avanya sambi na kupumusivua ni kighono kya vutatu asyuke kange.” ");
INSERT INTO wbi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","avadala vala vakakumbuka amasio ghake, ");
INSERT INTO wbi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","vakagomoka kange kumbipa na kum'bula isio sooni vala kijigho na jumo na vange vooni. ");
INSERT INTO wbi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","pe uMaliya Magadalena, uJohana, uMaliya mama ghwa Yakovo, na vadala avange palikimo vakahumia imhola isi isa vusun'gua. ");
INSERT INTO wbi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","neke imhola isi sikavoneka hwene sa mbedo kuva sung'ua, kange nakavitikile avadala vala. ");
INSERT INTO wbi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","nambe lino uPeteli akasimuka, akakimbila na kuluta ku mbipa, akahungila na kulola mu'nkate akaghwagha umwenda um'balafu ghwene. pe aPeteli akavuka na kuluta ku nyumba jake, akale idegha kiki kino kihumile. ");
INSERT INTO wbi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","pe degha, vavili mu vanave valyale viluta ikighono kikikyo mu kikaaja kimonga kikemelua Emmau, kino klyale nu vutali vwa,  kuhuma ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","vakajofesania vavuo ku vavuo ku sooni sino sihumile. ");
INSERT INTO wbi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","jilyahumile luuti, unsiki ghuno valyale vijofesania na kuposesania, uYesu akavelelela pa vupipi akakolana nave. ");
INSERT INTO wbi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","neke amaaso ghave ghakasighilue kukun'kagula umwene. ");
INSERT INTO wbi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","uYesu akavavula, akati, “umue mwe vavili muvele mujovela kiki un'siki ghuno ye mughenda?” vakima pala neke vakavonike ghwene vaanhu avanya lusukunalo. ");
INSERT INTO wbi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","jumonga mu vanave ilitavua lyake ghwe Cleopa akamwamula akati, pe uve uli muunhu ghwemwene pa Yelusalemu apa, juno naukagwile sino sihumile ukuo ifighono ifi?” ");
INSERT INTO wbi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","uYesu akam'bula akati, “se nyiki?” vakamwamula, “sooni sino sa Yesu Munasaleti, juno alyale m'bili unya ngufu mu maghendele na masio pa maaso gha Nguluve na vaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","na fino avatekesi na valongosi vitu valyamwumisie kuhighua kufua na kupumhusivua. ");
INSERT INTO wbi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","neke tulyahuvilile kuuti umwene ghwe juno ikuvavika avaanhu huru ava Silaeli. Ena, kutali naghuo lino kighono kya vutatu kuhuma isi sihumile. ");
INSERT INTO wbi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","kange pepano avadala vamonga kuhuma mulipugha litu vakatudeghisie ye vali pa mbipa ni lyakilo joni. ");
INSERT INTO wbi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","vati navaghwaghile um'bili ghwake vakisa na kujova kuuti, vakalolile amavonelo gha vanyaMhola ghiti mwumi. ");
INSERT INTO wbi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","pe avaghosi vamonga vano valyale palikimo nusue kakaluta ku mbipa vakavona hwene vadala fino vimile. neke navakamwaghile umwene” ");
INSERT INTO wbi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","uYesu akavavula umue mwe vaanhu vajaasu mwevanya moojo ghano naghikwitika ku sooni sino avavili vijova! ");
INSERT INTO wbi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","pe na lukamunoghile uYesu kupumhuka mu agha, na kukwingila mu vwimike vwake?” ");
INSERT INTO wbi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","pe kutengulila kwa Moose na vavili vooni, uYesu akavavulanisiagha sino sikun'jova umwene mu malembe ghake ghoni. ");
INSERT INTO wbi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ye vali pipi ni likaaja lila kuno valyale viluta, UYesu akahwana ighendelela kuvulongolo. ");
INSERT INTO wbi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","neke vakan'kwesa vakatisagha, “ikale palikimo nusue, ulwakuva ivwilile ni kilo hwene fisilile” pe uYesu akingila na kukukala navo. ");
INSERT INTO wbi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","jikahumile kuuti, ikalile pilia navo, akatola un'kate na kughufunyila, akaghumenyulania na kukuvapela. ");
INSERT INTO wbi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","vakadindula amaaso ghave vakan'kagula pe akasovanika ghafula pa maaso ghave. ");
INSERT INTO wbi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","vakijofesania vavuo ku vavuo,”pe lino amoojo ghitu naghalyale mu n'kate jiitu, unsiki ghuno ijova nusue mu sila ye adindulivue amalembe. ");
INSERT INTO wbi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","akimile unsiki ghughuo, na kugomoka ku Yelusalemu. vakavagha vala kijigho nu jumo vakong'anile palikimo na vala vano valyale lumo. ");
INSERT INTO wbi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","vakatisagha,” kyang'ani uMutwa asyukile amwumile uSimoni”. ");
INSERT INTO wbi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","pe musila vakampangila sino sihumile, kange na fino avonike kuvnave ye ienyula un'kate. ");
INSERT INTO wbi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ye vijova isio uYesu jujuo akimile pakate jave na kukuvavula,”ulutengano luvisaghe numue”. ");
INSERT INTO wbi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","neke vakoghopa a kusagha kuuti vakajaghile inumbula. ");
INSERT INTO wbi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","uYesu akavavula, kiki musukulana? kiki mukuposia mu moojo ghinu? ");
INSERT INTO wbi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","lola amavoko ghango na maghulu ghango, kuuti nene june. munyabasie mulole. ulwakuva inumbula jisila nyama na mafupa, ndavule fino mukunyagha une.” ");
INSERT INTO wbi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ati amalile kujova ndiki, akavasona amavoko na maghulu ghake. ");
INSERT INTO wbi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ye vali nulukelo luno luhasing'ine na kisila vwitiki na kudegha, uYesu akavavula kuuti, “pe muli ni kinu kyokyoni kulia? ");
INSERT INTO wbi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","pe vakampela ikipande kya swi kino kinyanyilue. ");
INSERT INTO wbi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","uYesu akatoola na kulia pa maaso ghavanave. ");
INSERT INTO wbi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","akavaavula, “ye nilyale numue nikavavulagha kuuti sooni sino silembilue mu ndaghilo sa Moose na vavili ni Sabuli sinoghile kuhumila” ");
INSERT INTO wbi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","pe akavapela kukaguala amalembe. ");
INSERT INTO wbi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","akavavula, akati,” jilembilue, uKilisite anoghile kupumhuka na kusyuluka kange kuhuma ku vafue ikighono kya vutatu. ");
INSERT INTO wbi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","uvulato nu lusaghilo lwa sambi lunoghile kudalikivua ku litavua lyake ku iisi sooni kutengulila ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","umue muli vasaidi va isi sooni, ");
INSERT INTO wbi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","lolagha, nikuvatwalila ulufingo lwa baba ghwango kulyumue neke mughule mu mpulo ughu, kuhanga mufyala ingufu kuhuma kukyanya kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","pepano u yesu akavalongosia kunji kuhanga pano valyale pipi na ku Betania. akatosia amavoko ghake kukyanya, na kuvafunyila. ");
INSERT INTO wbi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","jikahumila kuuti, unsiki ye ikuvafunyila akapindilue n'kyanya kuluta na kukuvaleka. ");
INSERT INTO wbi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","pe vakamfunya nu lukelo ulukome, na kugomoka ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","vakaghendela kumughinia uNguluve mu nyumba inyimike ja kufunyila. ");
INSERT INTO wbi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kuvutengulilo kwe alyale ulisio, ulisio ujuo alyale palikimo nu Nguluve, kange ulisio alyale ghuse, Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kuhuma kuvute ngulilo, ulisio ujuo alyale palikimo nu Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","UNgulve alyapelile ifiinu fyoni kukilila umwene. Nakwekili nambe kimo kino alyapelile kisila kukilila kwa mwene ujuo. ");
INSERT INTO wbi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mwa mwene mwevulyale uvusumi, uvusumi uvuo vukava lumuli ku vaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ulumuli uluo lumulika mu nghiisi, ingiisi jikunilue kukululema. ");
INSERT INTO wbi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","UNguluve alyansung'hile umuunhu jumonga juno akatambukagha Yohani. ");
INSERT INTO wbi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","UYohani ujuo, alisile kukwoleka imhola isa lumuli uluo, kuuti avaanhu vooni vitike kukilila umwene. ");
INSERT INTO wbi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","UYohani ujuo naalyale ghwe lumuli uluo, looli alisile kukwoleka ulumuli. ");
INSERT INTO wbi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ulumuli uluo ulwa kyang'haani, luno lukava lukwisa muiisi, uluo lukavamulikila avaanhu vooni. Ulumuli uluo. ");
INSERT INTO wbi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ulisio mwe alyale mu iisi, naji iisi jooni jilyapelilue kukilila umwene, neke avaanhu navalyankagwile. ");
INSERT INTO wbi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Alisile kuvaanhu vaake, aveene navalyamwupiile. Neke avaanhu vooni vano valyamwupiile na kukumwitika, akavaviika kuuva vaana va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Neke avaanhu vooni vano valya valyamwupiile na kukumwitika, akavaviika kuuva vaana va Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nakwekuti vaana va Nguluve vwimila ifisina fyave, nambemulwa kuholua nu mughosi nu ndala, nambe muvughane vwa muunhu, looli UNguluve jujuo ghwe juno avavikile kuuva vanaake. ");
INSERT INTO wbi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ulisio ujuo akava muunhu, akikala palikimo nusue, najusue tukuvuvona uvuvaha vwake, uvuvaha vuno vuhufia kuuti ghwe mwana jumo mwene ghwa Nguluve uNhaata. Umwene ali nu lusungu fiijo nu vwakyang'haani vwoni. ");
INSERT INTO wbi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","UYohani akavoleka avaanhu imhola isa muunhu ujuo, akajova fiijo akati, “Uju ghwe juno najovagha kuuti, 'Juno ikwisa kumbele kulyune, m'baha kukila une, ulwakuva kwealyale une ye nikyale kuholua.” ");
INSERT INTO wbi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Usue tweni muvukwilanifu vwake, twupiile ulusungu lwake, kange ifikutusungukilagha jaatu. ");
INSERT INTO wbi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ulwakuva indaghilo saake alyatupeliile kukilila uMose, ulusungu nu vwakyang'haani atupeliile kukilila uYesu kilisite. ");
INSERT INTO wbi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nakwale umuunhu juno aghelile kukumwagha uNguluve, ali palikimo nu Nguluve uNhaata. Ujuo ghwe mwene atuhufisie uNguluve. ");
INSERT INTO wbi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Avalongosi va Vayahudi valyavasung'hile avatekesi na Valeevi kukumposia uYohani kuuti ghwe veeni. ");
INSERT INTO wbi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Umwene akavoleka kisila kufisa, akati, “Une naneene Kiliste.” ");
INSERT INTO wbi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Vakamposi kange vakati, “Lino uve veeni? Asi, veeve m'bili Eliya? UYohani akavamula akati, “Ndali, na neene Eliya.” Vakamposia kange vakati, Veeve m'bili?” Akavamula akati, “Ndali na neene.” ");
INSERT INTO wbi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Vakamposi kange vakati, “Lino uve veeve veeve veeve? Ghukutambula veeve veeni? Tulonda tugomosie ulwamulo ku vano vatusung'hile?” ");
INSERT INTO wbi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","UYohani akavamula akati, Une neene lisio lya muunhu juno ikemeela ku'lukuve iiti, munnosekesyaghe uMutwa isila.” Ndavule alyajovile um'bili uYesaya.” ");
INSERT INTO wbi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pepano avaanu vala vano valyasung'hilue na Vafalisayo vakampos kange vakati, ");
INSERT INTO wbi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Nave naveeve Kilisite, nambe naveeve Eliya nambe na uli m'bili, ongo ghukwofugha?” ");
INSERT INTO wbi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","UYohani akavamula akati, “Une nikwofungha na malenga, neke nkate mulyumue pwale juno umue namunkagwile. ");
INSERT INTO wbi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ujuo ghwe juno ikwisa kumbele kulyune. Une naninoghiile nambe kuhudula utukova utwa filatu tyake. ");
INSERT INTO wbi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Isio silyavombiike mu kikaaja kya ikya Betania, imwambo ja Yolidani, ukuo kwe kuno uYohani alyale ikwifugha avaanhu. ");
INSERT INTO wbi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ikigho ikivingilili, uYohani akamwagha uYesu ikwisa kwa mwene. Pe akavavuula avaaanhu akati, “Lolagha, uju ghwe kakolo ghwa nguluvve, ghwe mwene ivusia uvuhosi vwa vaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uju ghwe juno navagha kuuti, “Juno ikwisa kumbele kulyune, m'baha kukila une, ulwakuva kwe alyale une ye nikyale kuholua.' ");
INSERT INTO wbi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Najune nanikaakagwile kuuti ghwe kakolo, looli une nilisile kukwofungha avaanu na malenga, kuuti aVaisilaeli vankagule.” ");
INSERT INTO wbi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kange uYohani akavavula akati, “Nimwaghile uMhepo uMwimike ikwika kuhuma kukyanya hwene ng'unda na kukwima pa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Une nanivele nikagwile, neke UNguluve juno asung'hile kukwofugha avaanhu na malenga ambulile kuuti, 'Umuunhu juno kyaukumwagha uMhepo ikwika na kukwima pa mwene ujuo ghwe juno ikwofughagha nu Mhepo uMwimike.” ");
INSERT INTO wbi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","UYohani akafijovagha akatisagha, “Une nisivwene isio na maaso ghango, kange nijova isa kyang'haani, kuuti uju ghwe mwana ghwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ikighono ikya vuvili, ");
INSERT INTO wbi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","kange, ikighono ikivingilili, uYohani uMwofughi akava imile palikimo na vavulanisivua vaake vavili, vakamwagha UYesu ikila, pe uYohani akati, “Lolagha, ukakologhwa Nguluve!” ");
INSERT INTO wbi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Avavulanisivua vavili vala, ye vampuliike uYohani ijova amasio aghuo, vaka m'bingilila uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pe uYesu akasyetuka, akavona vikum'bingilila, akavaposia akati, mulonda kiki? “Aveene vakamwamula vakati, “Rabi, (kwe kuti m'bulanisi) ghukukala kuughi? ");
INSERT INTO wbi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","UYesu akati, “Mwise, mukupaagha.” Pe vakam'bingilila. Pakivwilile, akavalilo aka kijigho, vakafika pano ikalagha, vakava lumo ikighono kila. ");
INSERT INTO wbi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Umo mu vavulanisivua vavili vala vano vakapuliike amasio gha Yohani na kukum'bingilila uYesu, alyale ghwe Ndeleya unnuuna ghwa Simoni Peteli. ");
INSERT INTO wbi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Undeleya akamwagha unkulu ghwake uSimoni, akam'buula akati, “Tumwaghile uMesiya” (Mesiya kwe kuti Kiliste). ");
INSERT INTO wbi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pe akantwala uSimoni kwa Yesu. UYesu akamulola uSimoni, akam'buula akati, Uve veeve Simoni mwana ghwa Yohani, lino ghutambulwaga Keefa,” (Kwe kuti' Peteli). ");
INSERT INTO wbi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ikighono ikivingilili, uYesu ye ilonda pivuuka kuluta ku kighavo ikya Galilaya, akamwagha uFilipo, akambuula akati “Umbingililaghe.” ");
INSERT INTO wbi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","UFilipo alyale mhuma mu likaaja ilya Betisaida. Ghwope uNdeleya nu Peteli vakahumagha mulikaaja ilio. ");
INSERT INTO wbi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","UFilipo akamwagha uNatanaeli, akambuula akati, “Tumwaghile umuunhu juno imhola saake silyalembilue nu Moose mu kitabu ikya Ndaghilo, na mufitabu ifya vavili. Ujuo ghwe Yesu mwana ghwa Yosefu umhuma ku Nasaleti. ");
INSERT INTO wbi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","UNatanaeli akamposia uFilipo akati, “Ikiinu ikinono ndepoonu kihuma ku Nasaleti? “UFilipo akamwamula akati, “Ghwise, ulole!” ");
INSERT INTO wbi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","UYesu ye amwaghile uNatanaeli ikwisa kwa mwene, akajova akati, “Lolagha, ujuo ghwe Muisilaeli ghwa kyang'haani, nsila vukedusi nkate mwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","UNatanaeli akamposia uYesu akati, “Ghwe Mutwa, ung'hagwile ndaani?” UYesu akamwamula na kukum'bula akati, “Nambe uFilipo ye akyale pikukukemeela, une niveele nikwaghile, ghukalile paasi pa mpiki untini.” ");
INSERT INTO wbi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pe uNatanaeli akamwamula akati, “Ghwe Mbulanisi, lino nikagwile kuuti, uli mwana ghwa Nguluve! Uli Ntwa ghwa Isilaeli!” ");
INSERT INTO wbi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","UYesu akamposia akati, “Ghukwitika ulwakuva nikuvuvulile kuuti niveele nikuvwene ye ghukalile pa mpiki untini? Lino ghukusivona isingi imbaha kukila isi. ");
INSERT INTO wbi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","UYesu akavavuula akati, kyang'haani nikuvavuula, mulikuvuvona uvulanga vudinduka na vanyamola va Nguluve vitogha na kukwika palyune ne Mwana ghwa Muunhu.” ");
INSERT INTO wbi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ye fikilile ifighono fidatu, kwe vulyale uvutolani ku kikaaja ikya Kana mukighavo ikya Galilaya ghwope ung'hina ghwa Yesu pwealyale pa vutolani uvuo. ");
INSERT INTO wbi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","U Yesu na vavulanisivua vaake voope pwevalyale pa vutolani uvuo ulwakuva valyakutilue. ");
INSERT INTO wbi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Unsiki ye vamalile uluhuuje, ung'hina ghwa Yesu akambuula uYesu akati, “Vasila luhuuje”. ");
INSERT INTO wbi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","U Yesu akamwamula ung'hina akati, “Mama, kiki ukumbuula isio? Unsiki ughwa kuvomba imbombo jango ghukyale” ");
INSERT INTO wbi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pe ung'hina akavavuula avavombi akati, “Kino kyaikuvavuula, muvombaghe.” ");
INSERT INTO wbi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pa vutolani pala pwesilyale isaaji ntanda isa mavue. Isaaji isio silyale sa malenga agha kusogha, muliva kuvalasia ndavule lwale lwiho ku Vayahudi, ulusaji lumo lukamemagha amalenga amateneka ghavili nambe ghatatu. ");
INSERT INTO wbi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","UYesu akavavuula avavombi vala akati, “Mumemie amalenga mu saaji isio.” Avavombi vala vakamemia. ");
INSERT INTO wbi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pe akavavuula avavombi vala akati, “Negha amalenga ghamonga mu saaji, muntwalile um'baha ughwa kikulukulu.” Vakavomba ndavule avalaghile. ");
INSERT INTO wbi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Umbaha jula akavonja amalenga ghala ghano ghahambwike kuuva luhuuje, neke naalyakagwile kuno luumile (looli avavombi vano valyaneghile amalenga, valyakagwile kuno luhumile). Pe akankemeela untoola n'dala ");
INSERT INTO wbi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","akamb'buula akati, “Umuunhu ghweni taasi ihumia ihumi uluhuuje ulunono, neke kyande avanu vanywile vakwilile, pe ihumia uluhuuje luno nalunono. Neke uve uvele ujiighe uvikile uluhuuje ulunono kuhanga kuvusililo” ");
INSERT INTO wbi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","UYesu alyavombile ikidegho iki ku Kana kukighavo ikya Galilaya, ikidegho ikio kyale kivalilo kya kwanda kuhufia uvuvaha vwake, mu uluo avavulanisivua vaake vakaghina kukumwitika. ");
INSERT INTO wbi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ikikulukulu kya vutolani yekisilile, uYesu palikimo nu ng'hina na vanuuna na vavulani sivua vaake vakaluta ku likaaja ilya Kapelnaum ukuo vakikala ifighono fidebe. ");
INSERT INTO wbi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Unsiki ughwa kyimike ikya Pasaka ikya Vayahudi ye ghuli piipi, uYesu akaluta ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ye afikile kula, akingila mu nyumba inyimike ija kufunyila, akavaagha avaanhu vighusia ing'ombe, ing'holo ni ng'unda kange avange vakananiagha indalama. ");
INSERT INTO wbi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","UYesu akatenda un'jeledi ughwa ngoji, akatengula kukuvadaga vooni mu nyumba mula palikimo ni ng'ombe ni ng'holo saave. Akabilivandula imeesa isa vano vakananiagha indalama na kukung'ha indalama saave. ");
INSERT INTO wbi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Avaghusia ing'unda akavavuula akati, “'Vusia ing'unda apa, namungavikaghe inyumba ja Nhata ghwango kuuva lighulilo.” ");
INSERT INTO wbi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Avavulanisivua vaake vakakumbuka amasio ghano ghalembilue mu malembe amimike kuuti, “Ulughano lwango vwimila inyumba jaako lukumbuda.” ");
INSERT INTO wbi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pe avalongosi va Vayahudi vakamposia vakati, Ghuhufia ikivalilo kiki kuvonia kuuti, uli nu vutavulilua uvwa kuvomba isi?” ");
INSERT INTO wbi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","UYesu akavamula akati, memula inyumba inyimike iji ija kufunyila, une nijenga kange mu fighono fidatu.” ");
INSERT INTO wbi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pe avalongosi va Vayahudi vakati, “Inyumba inyimike ija kufunyila jilyajengilue amaaka fijigho fine ni ntanda lino lwa ndaani uve ghujenga mu fighono fidatu?” ");
INSERT INTO wbi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","UYesu naakava ijova inyumba inyimike ija kufunyila, ulwene akava ijova vwimila um'bili ghwake. ");
INSERT INTO wbi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Lino ye asyusivue kuhuma ku vafue, avavulanisivua vaake vakakumbuka amasio aghuo ghano alyajovile, vakitika amasio ghano ghalembilue mu malembe amimike na ghano alyajovile uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","UYesu ye ali ku Yelusalemu ku kyimike ikya Pasaka, avaanhu vinga valyamwitike, ulwakuva valyafyaghile ifivalilo vwimila ifidegho fino alyale ivomba. ");
INSERT INTO wbi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Neke uYesu naalyavatang'hinje avaanhu vooni vule valivuo. ");
INSERT INTO wbi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kange nakwevulyale uvufumbue muunhu kukum'buula sino avaanhu vakava visaagha ulwakuva alyasikagwile sooni isa mu moojo ghaave. ");
INSERT INTO wbi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kwe alyale um'baha jumonga ughwa Vayahudi, ughwa mukipugha kya Vafalisayi, akatambulwagha Nikodemo. ");
INSERT INTO wbi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Umuunhu ujuo alyalutile pakilo kwa Yesu akam'buula akati, “Ghwe m'balanisi, tukagwile kuuti uli m'bulanisi juno asung'hilue nu Nguluve, ulwakuva nakwale umuunhu juno ndepoonu ihufia ifivalilo ifi fino ghuvomba, nave uNguluve naali palikimo nu mwene.” ");
INSERT INTO wbi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","UYesu akamwamula akati, “Kyang'haani nikukuvuula, nakwale umuunhu juno ndepoonu ikwingila mu vutwa vwa Nguluve, naaholilue ulwa vuvili.” ");
INSERT INTO wbi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","UNikodemo akamposia uYesu akati, “Umuunhu ung'oyo iholua ndaani? Ndepoonu ikwingila mulileme lya ng'ina neke aholue ulwa vuvili?” ");
INSERT INTO wbi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","UYesu akamwamula akati, “Kyang'haani nikukuvuula, nakwale umuunhu juno ndepoonu ikwingila mu Vutwa vwa Nguluve, nave naaholilue na malenga nu mhepo ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Umuunhu iholua kim'bili na vapaafi, neke juno iholua nu mhepo ghwa Nguluve ali nu vwumi kusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nungadeghaghe ulwakuva nikuvulile kuuti, 'lulondua kuholua ulwa vuvili.' ");
INSERT INTO wbi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Imhepo jigugula kulungama kuno jilonda, ghupulika pano jigugula, neke nungakagule kuno jihuma na kuno jiluta. Fye lulivuo nakwa muunhu juno aholilue nu mhepo ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","UNikodemu akamposia akati, “Umuunhu iholua ndaani nu mhepo?” ");
INSERT INTO wbi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","UYesu akamwamula akati, “Uve uli m'bulanisi ghwa Vaisilaeli, lwa ndaani nusikagwile isi? ");
INSERT INTO wbi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kyang'haani nikuvavuula, usue tujova sino tusikagwile, kange tukwoleka sino tusivwene, neke umue namukwupila uvwolesi vwitu. ");
INSERT INTO wbi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nave namukwitika pano nikuvavuula isa mu iisi muno, pe kyande mukwitika ndaani pano nikuvavuula isa kukyanya? ");
INSERT INTO wbi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ulwakuva nakwale umuunhu juno aghelile kutogha kukyanya, looli une ne, Mwana ghwa Adamu ne juno nisile kuhuma kukyanya. ");
INSERT INTO wbi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ndavule uMose pano alyatosisie munkyanya ikihwani kya njoka, fye enendiiki umwana ghwa Adamu ilondua kutosivvua, ");
INSERT INTO wbi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kuuti avaanhu vooni vano vikumwitika vaave nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","UNguluve avaghanile fijo avanu va muiisi muno, fye nambe akantavula umwanaake juno ali jumo mwene kuuti umuunhu ghweni juno ikumwitika aleke pisova looli aave nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ulwakuva uNguluve naalyansung'hile umwanake mu iisi kukuvahigha avaanhu, ulwene alyansung'hile kukuvapoka. ");
INSERT INTO wbi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Juno ikumwitika umwene, naihighua, Juno naikumwitika ahighilue ulwakuva naikumwitika umwana ghwa Nguluve juno ali jumo mwene. ");
INSERT INTO wbi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uvuhighi uvuo vwe uvu, ulumuli lwisile mu iisi muno, neke avaanu vajighanile ing'hiisi kukila ulumuli, ulwakuva imbombo saave mbiivi. ");
INSERT INTO wbi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Umuunhu ghweni juno imbombo saake mbiivi, ikulukalalila ulumuli, naikwisa ku lumuli ulwakuva nailonda imbombo saake imbivi sivoneke pa vuvalafu. ");
INSERT INTO wbi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Looli umuunhu juno ivomba isa kyang'haani, ikwisa ku lumuli, kuuti imbombo saake sivoneke sivombilue mu ngufu sa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pambele uYesu na vavulanisiva vaake vakaluta kukighavo ikya Yudea. Ukuo akikala ifighono ndafilingi palikimo na veene, akava ikwofugha avaanhu. ");
INSERT INTO wbi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Unsiki ughuo ghwope uYohana umwofughi alyale ikwafugha kukikaaja ikya Ainea piipi ni likaaja ilya Salim ulwakuva ukuo kwe ghalyale amalenga minga, avaanhu vakalutagha kwa mwene kuuti avofughe, ");
INSERT INTO wbi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","unsiki ughuo uYohana alyakyale kudindilua mu ndiinde. ");
INSERT INTO wbi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ikighono kimonga avavulanisivua vamonga va Yohana valyale vikaning'hana nu Muyahudi jumonga vwimila ulwiho ulwa kuvalasia. ");
INSERT INTO wbi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pe vakaluta kwa Yohana vakambuula vakati, Ghwe mbulanisi, umuunhu jula juno aava nuuve imwambo ija kikogha kya Yorodani, juno ghwolekagha imhola saake, lino ghwope ikwofugha avaanhu, kange avaanhu vinga viluta kwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","UYohana akavamula akati umuunhu naangave ni kimonga nave uNguluve naampeliile. ");
INSERT INTO wbi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Umue mwemue muli volesi vango mu isio sino nikajovile kuuti, 'Une naneene Kilisite', ulwene uNguluve asunghile une kuuti nimulongelele uKilisite.' ");
INSERT INTO wbi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Umhinja juno itolua muunhu ghwa ntola n'dala. Une ne juno nili ndavule ummanyaani ghwa ntola n'dala nimile palubale pa ntola n'dala, nihovokapano nipulika ilisio lyake. Kyang'haani nihovwike fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Luoghiile umwene ave mbaha fiijo, une niive ndebe fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Umwene juno ihuma kukyanya mbaha kukila avaanhu vooni. Juno ihuma mu iisi, ghwa mu iisi ijova isa mu iisi. Neke juno ahumile kukyanya m'baha kukila avaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Sino asivwene na kupulika se sino ikwoleka, neke nakwale umuunhu juno ikwupila juno ikwupila uvwolesi vwake. ");
INSERT INTO wbi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Umuunhu juno ikwupila uvwolesi vwake, ihufia kuuti sino ijova uNguluve sa kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ulwakuva juno asung'hilue nu Nguluve ijova amasio gha Nguluve. Ulwakuva uNguluve ampeliile ingufu sooni isa mhepo umwimike. ");
INSERT INTO wbi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","UNguluve uNhaata amughanile umwanaake, kange avikile fyoni mu mavoko ghaake. ");
INSERT INTO wbi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Umuunhu juno ikumwitika umwana ghwa Nguluve, ali nu vwumi uvwa kuvusila kuvusila kusila, neke umuunhu juno naikumwitika, naali nu vwumi uvuo ulwene ali mu vuhighi vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Lino aVafalisayi vakapulika imhola sa Yesu kuuti ikwofugha na kuuva na vavulanisivua vinga kukila uYohana umwofughi, ");
INSERT INTO wbi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(neke uYesu jujuo naakava ikwofugha, looli avavulanisivua vaake ve vano valyale vikwofugha), ");
INSERT INTO wbi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","UYesu ye akagwile kuuti imhola saake sipulikiike, akavuuka mukighavo ikya Yudea akagomoka ku kighavo ikya Galilaya. ");
INSERT INTO wbi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ye vigomoka ku Samalia lukavoneka kuuti kwevule uvufumbue uvwa kukilila mu kighavo ikya Samalia, pe vakakilila isila ijio. ");
INSERT INTO wbi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pe vakafika mu likaaja ilya Sikali lino lyale mukighavo ikya Samalia, ilikaaja ilio lilyale piipi nu mughunda ghuno u Yakobo alyampeliile umwanake u Yosefu. ");
INSERT INTO wbi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Apuo pwekilyale ikitiimu kya Yakobo. UYesu akikala palubale pa kitiimu ikio kuuti apuume, ulwakuva alyakatiile nu lughendo. Unsiki ughuo ghwale ghwa kavalilo aka ntanda pamwisi. ");
INSERT INTO wbi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pe akiisa umukijuuva jumomonga uNsamalia kunegha amalenga pa kitimu kila, uYesu akam'buula akati, “Nisuuma amalenga ninyue.” ");
INSERT INTO wbi_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ulwakuva avavulanisivu vaake vakava valutile kughula ikyakulia. ");
INSERT INTO wbi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Umukijuuva jula uNsamalia akamwamula akati, “Uve uli Muyahudi, une nilinsamalia, lwandaani ghusuuma amalenga kulyune?” Alyajovile enendiki ulwakuva aVayahudi navalyale nu vuhangilanisi na Vasamalia. ");
INSERT INTO wbi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","UYesu akamwamula akati, “Ghwale ukagulaghe sino uNguluve ilonda kukukupeela na kuuti nene veeni ne juno nikukusuuma amalenga, ngale usumile une, une naale nikukupeela amalenga ghano ghikuvapeela avaanhu uvwumi.” ");
INSERT INTO wbi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Umukijuuva jula akamwamula uYesu akati, “Ghwe Ntwa uve nuli ni ndoovo ija kuneghela, kyope ikitiimu kitali. Lino ukughaagha kuughi amalenga gha vwumi? ");
INSERT INTO wbi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Unkuulu ghwitu uYakobo alyatupeliile ikitiimu iki, umwene na vanaake vanywile amalenga agha kitiimu ulim'baha kukila uYakovo?” ");
INSERT INTO wbi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","UYesu akamwamula akati, “Umuunhu ghweni juno inyua amalenga agha kitimu iki, ikwumilua kange, ");
INSERT INTO wbi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","neke umuunhu juno inyua amalenga ghano nikumpeela ghiiva nkate mwa mwene, kiiva kindwivu kya malenga ghikumpeelagha uvwumi vuno navusila lusiku.” ");
INSERT INTO wbi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Pe umukijuuva jula akansuuma uYesu akati, “Ghwe Ntwa, umeele amalenga aghuo, nileke pikwumilua, kange nileke pikwisa apa kunegha amalenga.” ");
INSERT INTO wbi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","UYesu akambuula akati, “Lutagha, unkemeele umughosi ghwako, ghwise naghwo apa.” ");
INSERT INTO wbi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Umukijuuva jula akamwamula akati, “Une nili nsila mughosi.” UYesu akambuula akati, “Ujovile seseene kuuti, 'ulinsila mughosi,' ");
INSERT INTO wbi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ulwakuva ulyatolilue na vaghosi vahano, ghwope juno ghukukala naghwo lino, naghwako. Mu ulu ujovile isa kyang'haani!” ");
INSERT INTO wbi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Umukijuuva jula akamwamula akati, “Ghwe Ntwa, nivona uve uli m'bili. ");
INSERT INTO wbi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Avakuulu viitu valyale vikumwimika uNguluve pa kidunda iki, neke umue mwiti ku Yelusalemu kwe kuno kunoghiile kukumwimika uNguluve.” ");
INSERT INTO wbi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","UYesu akam'buula akati, “Ghwe mukijuva uve, ghwitikaghe sino nijova, ghukwisa unsiki ghuno namukumwimikagha uNguluve uNaata pa kidunda iki nambe ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Umue mu kumwimika uNguluve juno namunkagwile, neke usue tukumwimika uNguluve juno tunkagwile, ulwakuva uNguluve ikuvapokea avaanhu kukilila ku Vayahudi.” ");
INSERT INTO wbi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lino unsiki ghukwisa, kange ghufikile, pano avaanhu vano vikumwitika uNguluve uNhaata mu vwakyanghaani, vikumwimikagha mutwa kulongosivua nu mhepo ghwake na vule vulungika uvwakyang'haani vwake. ");
INSERT INTO wbi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","UNguluve ghwe mhepo, avaanhu vano vikumwimika umwene, vanoghiile kukumwimika mu ngufu isa mhepo ghwake na mu vwakyang'haani.” ");
INSERT INTO wbi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Umulijuuva jula akamwamula akati, “Nikagwile kuuti uMesiya, (juno ghwe Kilisite). Ikwisa iliva isile, ujuo ilikutuvuula sooni. ");
INSERT INTO wbi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","UYesu akam'buula akati, “Une ne juno nijova nuuve, neene Mesiya.” ");
INSERT INTO wbi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Unsiki ughuo avavulanisivua vaake vakagomoka, vakadegha kyongo kuvona uYesu ijova nu mukijuuva, neke nakwealyale juno alyaghelile kukumposia kuuti, “Ghulonda kiki?” nambe kuuti “Kiki ghujova naghwo?” ");
INSERT INTO wbi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Umukijuuva jula akaluleka pala pala ulusaaji lwake ulwa malenga akaluta kukikaaja, akavavuula, avanu akati, ");
INSERT INTO wbi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mwise mulole umuunhu juno ambulile sooni sino nivombile. Asi umuunhu ujuo ndepoonu iiva ghwe Kilisite?” ");
INSERT INTO wbi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Avaanu yepulike isio vakaluta kuno kwale uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Unsiki ughwa pamwisi avavulanisivua vaake vakam'buula uYesu vakati, “Ghwe m'bulanisi ulie ikyakulia.” ");
INSERT INTO wbi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Umwene akavavuula akati, “Une nili ni kyakulia kino umue namukikagwile.” ");
INSERT INTO wbi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Avavulanisivua vaake vakatengula kuposania viiti, 'Asi, kuli muunhu isile vwa Nhaata, juno kukumuletela ikyakulia?” ");
INSERT INTO wbi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","UYesu akavamula akati, “Ikyakulia kyango une, kwe kuvomba isa vughane vwa Nhaata juno asung'hulile nimale imbombo jaake. ");
INSERT INTO wbi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Asi, namwamujova kuuti, “Gasighile ameesi ghahaano kupeta?” Neke une nikuvavuula niiti, lola amaghunda vule ghalivuo pano lukwiline kupeta! ");
INSERT INTO wbi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ghwope juno ipeta ikwupila uluhombo lwake, umpeto ve vaanhu vano vikwupila uvwumi uvwa kuvusila kusila, apuo juno ivyala na juno ipeta vooni vivisagha nu lukeelo palikimo. ");
INSERT INTO wbi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwelule ulujovo luno luuti, 'Jumonga ivyala ujunge ipeta ulujovo uluo lwa kyang'haani.' ");
INSERT INTO wbi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Une nivasunghile umue kupeta fino namuhangajikile, Avange vakavombile imbombo inalamu, umue mupeta vwimila imbombo jaave.” ");
INSERT INTO wbi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","AVasamalia vinga ava mulikaaja lila ilya sikali vakamwitika uYesu ulwakuva valyapuliike sino alyajovile umukijuuva jula kuuti, “Umuunhu ujuo ambulile sooni sino nivombile.” ");
INSERT INTO wbi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pe aVasamalia vala vakafika pano pwale uYesu vakampelepesia kuuti ikale palikimo na veene, pe akikala mu likaaja ilio ifighono fivili. ");
INSERT INTO wbi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Avaanhu vinga fiijo vakamwitika uYesu vwimila ilisio lyake. ");
INSERT INTO wbi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vakam'buula umukijuva jula vakati, “Lino nakwekuti tumwitiike umuunhu uju vwimila si sino utuvulile uve, looli tumwitike ulwakuva tupulike sino ajovile, kange tukagwile kuuti kyang'haani umuunhu uju ghwe mpoki ghwa vaanhu vooni.” ");
INSERT INTO wbi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ifighono fivili ye fikilile, akavuuka kiluta ku Galilaya. ");
INSERT INTO wbi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","UYesu alyoliike kuuti um'bili naikwoghopua na vaanhu ava mu kikaaja kyake. ");
INSERT INTO wbi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Avaanhu ava ku Galilaya valyamwupiile uYesu, ulwakuva valyasivwene sooni sino alyavombile ku kyimike ikya Pasaka ku Yelusalemu, kukyimike ukuo voope kwevalyale. ");
INSERT INTO wbi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","UYesu akaluta kange ku kikaaja ikya Kana mu kighavo ikya Galilaya. Kukikaaja ikio kwe kuno alyahambwisie amalenga kuuva luhuuje kwe alyale umulongosi jumonga ughwa selikali ku Kapelnaumu, umulongosi ujuo umwanaake alyale ntamu. ");
INSERT INTO wbi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ye apulike kuuti uYesu isile kange ku Galilaya kuhuma ku Yudea akaluta kukumpelepesia uYesu kuuti alute ku Kapelenaumu, ansosi umwanaake ulwakuva umwanaake ujuo ghulyale ghukova. ");
INSERT INTO wbi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","UYesu akamwamula akati, “Umue namunganyitike kisila kufyagha ifivalilo ni fidegho. ");
INSERT INTO wbi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Umulongosi jula akamwamula akati, “Ghwe Mutwa nikukusuuma luvuke unsosie umwanango pano akyale pifua.” ");
INSERT INTO wbi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","UYesu akam'buula akati, “Vujagha, umwanaako asokile.” Akitika amasio gha Yesu akavuuka ivuja. ");
INSERT INTO wbi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Umulongosi jula ye ali mu sila ivuja, akatang'hana na vavombi vaake vakambuula vakati umwanaako asokile nkafu. ");
INSERT INTO wbi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pe akavaposia akati. Asokile unsiki ghuliku, “Aveene vakamwamula vakati, asooka pamihe pamwisi akavalilo aka lekela lubale.” ");
INSERT INTO wbi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Uviise ghwa mwana jula akakagula kuuti asooka unsiki ghula ghuno uYesu ajova kuuti, “Umwanaako asookile.” Pe umwene palikimo na vaanhu vooni ava munyumba jaake vakamwitika uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ikidegho ikio kyale kivalilo kya vuvili kino alyavombile uYesu ku Galilaya ye ahumile ku Yudea. ");
INSERT INTO wbi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pambele uYesu akaluta kulikaaja ilya Yelusalemu ku kikulukulu ikya Vayahudi. ");
INSERT INTO wbi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mu likaaja ilio pweghulyale umulyango um'baha ghuno ghukatambuluagha, mulyango ghwa ng'holo, piipi nu mulyango ughuo pwelilyale ililamba lino munjovele ija Kiebulania likatambulwagha Bethzatha, mulubale mulilamba ilio pwefilyale ifibalasa fihano ifyeleefu. ");
INSERT INTO wbi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mu lusulua ulwa fibalasa ifio valyaghonile avatamu vinga, avabofu amaaso, avalema amaghulu, na vanya liteela. (Vingilila: Amasio agha kadebe aka 3 naghivoneka mu malembe amanofu amakuulu. “Vakaghulagha amalenga ghatimbusivue.”) ");
INSERT INTO wbi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mu uluo, juno akavisagha ghwa kwasia kukwingila pano amalenga ghatimbwike, alyale isooka inhamu jaake. ");
INSERT INTO wbi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lino palilamba pala pwealyale umuunhu jumonga juno alyale ntamu amaaka fijigho fitatu na lekelakwoni. ");
INSERT INTO wbi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","UYesu akamwagha umuunhu ujuo aghonile pala alyakagwile kuuti umuunhu ujuo inhamu jaake ja maaka minga, akamposia akati, “Asi ghulonda kusooka?” ");
INSERT INTO wbi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Untamu jula akamwamula akati, “Ghwe Ntwa, amalenga ghangatimbusivue, nkwale umuunhu ughwa kumbiika mu lilamba. Pano nilonda kukwingila mu lilamba ye nivonagha umuunhu ujunge anhaliile pikwingila.” ");
INSERT INTO wbi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pe pano uYesu akam'buula akati, “Ima veghala iliteefu lyako vujagha.” ");
INSERT INTO wbi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pala pala umuunhu jula akasooka, akaveghala iliteefu lyake, akavuuka iluta. Ikighono ikio jaale Sabato. ");
INSERT INTO wbi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pe aVayahudi vakam'buula umuunhu jula juno asokile vakati, “Umusyughu kighono kya Sabato, indaghilo na sikwitikisia kupiinda iliteefu.” ");
INSERT INTO wbi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Neke umuunhu jula akavamula akati, “Umuunhu juno asoosisie ghwe mwene ambulile kuuti, 'Veghala iliteefu lyako vujagha.” ");
INSERT INTO wbi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vakamposia kange vakati, “Ghwe veeni juno akuvulile kuuti 'Veghala iliteefu lyako vujagha?” ");
INSERT INTO wbi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Neke umuunhu jula naalyammanyile juno ansosisie ulwakuva uYesu alyavukile kisyefu. Ulwakuva avaanu valyale vinga. ");
INSERT INTO wbi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pambele uYesu akamwagha umuunhu jula munyumba inyimike ija kufunyila, akambuula akati, “Lolagha lino usokile! “Nungavombaghe inyivi kange nave ghuvomba lukukwagha ulutalamu ulukome kukila ulwa kwanda.” ");
INSERT INTO wbi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Umuunhu jula akavuuka pala akaluta kukuvavuula aVayahudi kuuti juno ansosisie ghwe Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pepano, vwimila amasio aghuo aVayahudi vakampumwisie uYesu, ulwakuva alyavombile isio mu kighono ikya Sabato. ");
INSERT INTO wbi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Neke uYesu akavavuula akati, “UNhaata ghwango ivomba imbombo ifighono fyoni, na juune nivomba imbombo ifighono fyoni.” ");
INSERT INTO wbi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Vwimila uluo aVayahudi vakava vighina kulonda isila ija kum'buda uYesu vakalonda kukum'buda ulwakuva vakatisagha adenyile ululaghilo lwa kighono ikya Sabati, kange ijova kuuti, uNguluve ghwe viise, kange ikuviika kuuti aling'hiine nu Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","UYesu akavavuula akati, “Kyang'haani nikuvavuula une ne mwanaake nanivomba lumonga vwimila amasaaghe ghango, looli nivomba si sino nikumwagha uNhaata ivomba, nijova uluo, ulwakuva sino ivomba uNhaata se sino najune ne mwanaake nivoomba. ");
INSERT INTO wbi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","UNhaata anganile une ne mwanaake, ikuhofia sooni sino ivomba umwene, kange ilikuhufia une imbombo sino ilonda nivombe, imbombo imbaha kukila isio, kuuti pe mudeghe fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ndavule uNhaata vule ikuvasyusia avafue na kukuvapeela uvwumi, fye enendiiki na juune nikuvapeela uvwumi, vano nilonda kukuvapeela. ");
INSERT INTO wbi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ulwakuva uNhaata naihigha muunhu, looli ampeliile umwanake uvutavulilua uvwa kuhigha, ");
INSERT INTO wbi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kuuti avaanhu vooni vamwoghopaghe ndavule vikumwoghopa umwene. Umuunhu juno naikumwoghopa umwanake naikumwoghopa uNhata juno ansung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kyang'haani nikuvavuula, umuunhu juno ipulika amasio ghango na kukumwitika uNguluve juno asung'hile ali nu vwumi uvwa fighono fyoni. Kange nailihighua. Looli ujuo akilile uvufue na kukwingila ku vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kyang'haani nikuvavuula, unsiki ghukwisa, kange ghufikile, avafue vilipulika, viliiva nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nijo uluo ulwakuva ndavule uNhaata vule ali ni ngufu isa kumpeela umuunhu uvwumi uvwa kuvisila kusila, najuune amheliile ingufu isa kuvapeela avaanhu uvwumi uvuo. ");
INSERT INTO wbi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kange, amheliile uvtavulilua uvwa kuhigha avaanhu, ulwakuva une nili, Mwana ghwa Muunhu. ");
INSERT INTO wbi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Namungadeghaghe amasio aghuo, ulwakuva ghukwisa unsiki ghuno avafue vooni vilipulika ing'hemeelo jaango. ");
INSERT INTO wbi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Avafue vilisyuka: vano vavombagha inofu viiva nu vwumi uvwa fighono fyoni, vano vavombagha uvuhosi vilihighua. ");
INSERT INTO wbi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","UYesu akafijovagha akati une nanivomba kimonga vwimila amasaaghe ghango, une nihigha avaanhu ndavule ikumbuula uNhata. Nihigha mu vwakyang'haani, ulwakuva nanivomba muvughane vwango, looli mu vughane vwa Nguluve juno asung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nave une nikujoleka juune, uvwolesi vwango navwale vuuva vwa kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Looli kwale ujunge juno ikwoleka imhola sango na juune nikagwile kuuti sino ikwoleka vwimila une sa kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Umue mulyasung'hile avaanhu kwa Yohani umwofughi, ghwope alyavoliike isa kyang'haani vwimila une. ");
INSERT INTO wbi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Neke une nanihuviila sino vikwoleka avaanhu, ulwene nijova isi kuuti mukave uvupoki. ");
INSERT INTO wbi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","UYohani umwofughi alyahufisie uvwakyang'haani kulyumue, ndavule itaala vule jiviika na kumulika mung'hiisi, umue mulyahovwike vwimila uluo ku nsiki ndebe. ");
INSERT INTO wbi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Neke une nili ni mhola sino sikunyoleka fiijo kukila sino alyoliike uYohani, ulwakuva imbombo sino nivomba, sino alyamheliile uNhaata kuuti nivombe, se sino sikunyoleka kuuti uNhaata juno asung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ghope uNhaata juno asunghile une, ikwoleka imhola sango. Umue namughelile nambe lusiku kupulika ilisio lyake, kukumwagha vule alivuo unsiki ghwoni. ");
INSERT INTO wbi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kange imbulanisio saake nasili nkate mulyumue ulwakuva namukumwitika juno asung'hilue kulyumue. ");
INSERT INTO wbi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mughimba kulolesia mu malembe amimike, ulwakuva musagha kuti nkate umuo mukava uvwumi uvwa kuvusila kusila, amalembe aghu ghikunyoleka une. ");
INSERT INTO wbi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Neke umue namulonda kukwisa kulyune, kuuti mu pelue uvwumi uvwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Une nanihuviila avaanhu vanginie, ");
INSERT INTO wbi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","neke nikagwile kuuti nkate mulyumue namuli nu lughano lwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Une nisile mu vutavulilua uvwa Nhaata ghwango, umue namukunyupila. Neke ujunge angiise mu vutavulilua vwake jujuo, mwale mukumwupila. ");
INSERT INTO wbi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lino ndepoonu mukunyitika ndaani umue mwe vano mulonda kughinisivua na vaanhu, namulonda kughinisivua nu Nguluve juno ali jumo mwene? ");
INSERT INTO wbi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mulekaghe piiti ue nilikuvatwala kwa Nhaata avahighe. UMoose ghwe juno ilikuvatwala muhighue ulwakuva ghwe juno mukumhuviila. ");
INSERT INTO wbi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musava mukumwitika uMoose, ngale mukunyitika na juune, ulwakuva alyalembile imhola sango. ");
INSERT INTO wbi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Neke nave namukwitika amasio ghano alyalembile uMoose, ndepoonu mukwitika ndaani amasio ghango? ");
INSERT INTO wbi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pambele uYesu akalovoka ilisumbe ilya Galilaya, ilisumbe ilio ilitavua ilingi likatambulwagha Tibelia. ");
INSERT INTO wbi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Avaanhu vinga vakam'bingilila uYesu, ulwakuva valyale vikufyagha ifivalilo kukilila ifidegho fino avombagha mulwa kusosia avatamu. ");
INSERT INTO wbi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pe uYesu na vavulanisivua vaake vakatogha ku kidunda, vakikala ukuo. ");
INSERT INTO wbi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Unsiki ughuo, ikyimike kya Pasaka kilyale piipi). ");
INSERT INTO wbi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","UYesu akalivona ilipugha lya vaanhu likwisa kwa mwene, pe akamposia uFilipo akati, “Ndepoonu tughula kuughi amakate, kuuti avaanu avavalie”? ");
INSERT INTO wbi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(UYesu akamposia enendiki kukumughela, ulwakuva umwene alyakagwile kino iluta pivomba). ");
INSERT INTO wbi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","UFilipo akamwamula akati, “Nambe twale tuuve ni ndalama nyinga idinali filundo fivili kughula amakate, amakate aghuo naghaale ghikwila kukumpeela nu junge akamenyule akadebe.” ");
INSERT INTO wbi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pe u Andleya, umo mu vavulanisivua vaake, unnuuna ghwa Simoni u petelo, akam'buula uYesu akati, ");
INSERT INTO wbi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Pwale apa umwana jumonga ali na makate ghahaano agha ngongilue ni samaki ivili. Neke ifyakulia ifi fitanga kiki ku vaanhu avinga ava?” ");
INSERT INTO wbi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","UYesu akavavuula avavulanisivua vaake akati, “Muvakasie avaanhu” (Pe avaanhu vala vakikala apoonu pala pano valikalile) palyale pe lusoli, mulipugha lila avakinhaata veene valyale imbilima ihaano. ");
INSERT INTO wbi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pe uYesu akatoola amakate ghala, akamhongesia uNguluve, akavaghavila avaanhu vooni vano pwevale pala. Akatoola isamaki akavomba vule vule, Nu junge akapelua ndavule avele ilonda. ");
INSERT INTO wbi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Avaanhu vooni yevikwite, uYesu akavavuula avavulanisivu vaake akati, “Mukong'hanie ifisighasi fyoni, kileke kusova kimonga.” ");
INSERT INTO wbi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pe vakakong'hania ifisighasi ifya makate ghala agha ngongilue, vakamemia indiilo kijigho ni vili. ");
INSERT INTO wbi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Avaanhu vala ye vakyaghile ikidegho kino avombile uYesu vakati, '“Kyang'haani umuunhu uju ghwe mbili juno twahuvilagha kuuti ikwisa mu iisi muno.” ");
INSERT INTO wbi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","UYesu akakagula kuuti vilonda kukumwumilisia aave ntwa ghwave akavuuka pala, akaluta kange kukidunda, ukuo akava mwene. ");
INSERT INTO wbi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ye vwilile, avavulanisivua vaake vakiika vakaluta ku lisumbe. ");
INSERT INTO wbi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Vakingila mu Ngalava vakatengula kulovoka ilisumbe kuluta ku Kapelenaumu. (Unsiki ughuo jilyale ng'iisi neke uYesu alyakyale kufika pa veene). ");
INSERT INTO wbi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ilisumbe likatengula kusambaluka ulwakuva imhepo imbaha jikava jigugula. ");
INSERT INTO wbi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Avavulanisivua va Yesu ye vaghendisie ingalava ikilomita ihano nambe ntanda ndiiki, vakamwagha uYesu ighenda pakyanya pa malenga alipiipi ni ngalava vakoghopa kyongo. ");
INSERT INTO wbi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","UYesu akavavuula akati, “Namungoghopaghe, neene!” ");
INSERT INTO wbi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pe aveene vakalondagha kuuti ingile mu ngalava, nakalingi ingalava jikafika imwambo jino vakava viluta. ");
INSERT INTO wbi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ikighono ikivingilili, avaanhu vinga vano valyajiighe imwambo ijingi ija lisumbe, vakajaagha pala ingalava jimo jeene. Kange vakakagwile kuuti uYesu naavuka na vavulanisivua vaake ye viluta ni ngalava ulwakuva avavulanisivua vaake vakalutile veene. ");
INSERT INTO wbi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Pe avaanhu aange vakiisa ni ngalava isingi kuhuma kulikaaja ilya Tibelia vakafika pano avaanhu vakaliile amakate uYesu ye amhongisie uNguluve). ");
INSERT INTO wbi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","25","Avaanhu vala ye vakagwile kuuti uYesu na pwale pala nambe avavulanisivua vaake, vakingila mu ngalava sila vakaluta ku Kapelenaumu kukumulonda uYesu. Avaanu vala ye vafikile imwambo ija lisumbe vakamwagha uYesu vakamposia vakati, “Ghwe m'bulanisi ghwisalighi kuno?” ");
INSERT INTO wbi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","UYesu akavamula akati, kyang'haani nikuvavuula, nakwekuti mukundonda ulwakuva mwafyagha ifivalilo kukilila ifidegho fino navomba, ulwene mukundonda ulwakuva mwalia amakate mukuta. ");
INSERT INTO wbi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Namungatungumalilaghe ikyakulia kino kinangika, looli ikyakulia kino nakinangika, kino kikukupeela uvwumi uvwa kuvusila kusila, ikyakulia ikio kyekino une ne mwana ghwa muunhu nikuvapeela, ulwakuva uNguluve uNhata ahufisie kyang'haani kuuti une neene ghwa kuvomba imbombo ijio.” ");
INSERT INTO wbi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pe aveene vakamposia vakati, “Tukite kiki neke tuvombe imbombo sino ikeela uNguluve?” ");
INSERT INTO wbi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","UYesu akavamula akati, “Imbombo jino ikela uNguluve je iji: Munnyitikaghe une ne juno nisunghilue nu mwene.” ");
INSERT INTO wbi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Vakam'buula vakati, “Ghuhufia ikivalilo kiki tukyaghe neke twitike? Lino ghuhufia ikivalilo kiki? ");
INSERT INTO wbi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Avakuulu viitu ye vali ku lukuve, valyaliile imana, ndavule lilembilue mu malembe amimike kuuti, “Alyavapeliile amakate kuhuma kukyanya.” ");
INSERT INTO wbi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","UYesu akavavuula akati, “Kyang'haani nikuvavuula, uMoose naghwe juno alyavapeliile amakate kuhuma kukyanya, looli ghwe Nhaata juno lino ikuvapeela amakate agha kyang'haani ghano ghihuma kukyanya. ");
INSERT INTO wbi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nijova uluo ulwakuva unkate ughwa kyang'haani neene ne juno uNguluve asung'hile kuhuma kukyanya kukuvapeela avaanhu uvwumi uvwa kuvusila kusila.” ");
INSERT INTO wbi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pekambuula vakati, “Ghwe Mutwa, tusuuma utulaghe jaatu unkate ughuo.” ");
INSERT INTO wbi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","UYesu akavavuula akati, “Une neene nkate ghuno ghukuvapeela avaanhu uvwumi, umuunhu juno ikwisa kulyune, injala najilam'bava lusiku juno ikunyitika, ikyumilua nakilamwagha lusiku.” ");
INSERT INTO wbi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Neke nivavuulile kuuti napano munyaghile, mujiighe namukunyitika. ");
INSERT INTO wbi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Avaanhu vooni vano uNhaata ikumeela, vikwisa kulyune na kukunyitika, juno ikwisa kulyune nanilantaagha lusiku. ");
INSERT INTO wbi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nijova uluo ulwakuva une nisilie kuhuma kukyanya kuuti nivombage isa vughane vwa Nhaata juno asung'hile, nanisile kuvomba isa vughane vwango. ");
INSERT INTO wbi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Uvughane vwa Nhaata juno asung'hile vwe uvu, nileke kusofia nambe jumo mu vano amheliile, looli nivasyusie ikighono ikya vusililo. ");
INSERT INTO wbi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","UNhaata ghwango ilonda kuuti, umuunhu juno akagwile kuuti une nili mwanaake na kukunyitika upile uvwumi uvwa kuvusila kusila: Na juune nilikunsyusia ikighono ikya vusililo. ");
INSERT INTO wbi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pe aVayahudi vakatengula kukung'hulasia ulwakuva uYesu ajovile kuuti, “Une neene nkate ghuno uNguluve aletile kuhuma kukyanya.” ");
INSERT INTO wbi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vakiposania veene viiti, “Asi umuunhu uju naghwe Yesu umwana ghwa Yosefu, avapaafi vaake tuvamanyile? Lino lwandaani iti ahumile kukyanya?” ");
INSERT INTO wbi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","UYesu akavamula, akati, “Muleke pikung'hulasia. ");
INSERT INTO wbi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nakwale umuunhu juno ndepoonu ikwisa kulyune, nave uNhata juno asung'hile une naamulongwisie, na juune nilikunsyusia umuunhu ujuo ikighono ikya vusililo. ");
INSERT INTO wbi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Um'bili jumonga alyalembile mu malembe amimike kuuti, 'Vilivulanisivua nu Nguluve.' Umuunhu juno ikumpulikisia uNhaata na kumanyila kwa mwene, ikwisa kulyune. ");
INSERT INTO wbi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nakwale umuunhu juno amwaghile uNhaata, looli une neene nimwaghile ulwakuva nihumile kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kyang'haani nikuvavuula, umuunhu juno ikunyitika une, ali nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Une neene nkate ghuno ghukuvapeela avaanhu uvwumi. ");
INSERT INTO wbi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Avakuulu viinu nambe valyaliile imana ku lukuve, valyafwile. ");
INSERT INTO wbi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Neke apa pweghule unkate ghuno ghuhumile kukyanya, umuunhu angalie, naifu. ");
INSERT INTO wbi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Une neene nkate ghuno ghuhumile kukyanya. Umuunhu juno ilia unkate ughu, iiva nu uvwa uvwa kuvusila kusila. Unkate ughuo ghwe m'bili ghwango ghuno nitavula kuuti avaanu vooni vavisaghe nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Avayahudi vakatengula kukang'hana na kuposania veene viiti, “Asi umuunhu uju ikutupeela ndaani um'bili ghwake tulie?” ");
INSERT INTO wbi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","UYesu akavavuula akati, “Kyang'haani nikuvavuula, nave namulia um'bili ghwango ne mwana ghwa muunhu, na kunyua idanda jango, namuuva nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Umuunhu juno ilia um'bili ghwango na kunyua idanda jango, ali nu vwumi uvwa kuvusila kusila, na juune nilikunsyusia ikighono ikya vusililo. ");
INSERT INTO wbi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nijova uluo ulwakuva um'bili ghwango kye kyakulia ikya kyang'haani, naji danda jango jivusia ikyumilua kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Juno ilia um'bili ghwango na kunyua idanda jango ujuo ikukala mulyune, na juune nikukala mwa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ndavule uNhaata juno asung'hile vule mwumi, na june nili mwumi mu ngufu saake, fye enendiiki kwa muunhu juno ilia um'bili ghwango, iiva mwumi mu ngufu sango. ");
INSERT INTO wbi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Une nili nkate ghuno ghuhumile ghuhumile kukyanya, naghuli ndavule unkate ghuno avakuulu viinu valyaliile, vakafua. Umuunhu juno ilia unkate ughu iiva nu vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","UYesu alyajovile amasio aghuo ye ali pivulanisia mu sinagogi, ku Kapelenaumu. ");
INSERT INTO wbi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Avaanhu vinga mu vavingilili vaake ye vapuliike isio, vakajova vakati, “Imbulanisio isi nhalamu kyongo, ghwe veeni juno ndepoonu ikwupila imbulanisio isio?” ");
INSERT INTO wbi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","UYesu ye alutang'hinie kuuti avavingilili vaake vikung'hulasia vwimila imbulanisio isio, akavaposia akati, asi ilisio ili likuvakuvasia? ");
INSERT INTO wbi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pe luliiva ndaani mliiva mukunyaagha ne mwana ghwa muunhu nitogha kuluta kukyanya kuno nilyale ulutasi? ");
INSERT INTO wbi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Umhepo ghwa Nguluve ghwe juno ikuvapeela avaanhu uvwumi uvwa fighono fyoni. Ingufu sa muunhu nasingampeele umuunhu uvwumi. Amasio ghano nivavulile ghikuvapeela umue kuuva nu mhepo ghwa Nguluve, ghwope ikuvapeela uvwumi. ");
INSERT INTO wbi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Neke pwevale vamonga pakate palumue vano navikunyitika.” Ulwakuva alyakagwile kuhuma kuvutengulilo ve va veeni vano navikumwitika, kange ghwe veeni juno ilikumwohela. ");
INSERT INTO wbi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pe akafijovagha akatisagha, fye nambe nivavulile kuuti, nakwale umuunhu juno ndepoonu ikwisa kulyune nave uNhaata naamulongwisie.” ");
INSERT INTO wbi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kuhuma unsiki ughuo vinga mu vavingilili vaake vakamuleka vakavuhiila kukum'bingilila. ");
INSERT INTO wbi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pe uYesu akavaposia avavulanisivua vala kijigho na vavili akati, “Asi najumue mulonda pikundeka?” ");
INSERT INTO wbi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","USimoni uPeteli akamwamula akati, “Ghwe mutwa, tukuleke tulute kwani uve uli na masio ghano ghikutupeela uvwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Usue tukwitika kange tukagwile kuuti uve veeve mwimike kuhuma kwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pe pano uYesu akavavuula akati, “Asi nanivasalwile umue, kange jumonga pakate palyumue ilongosivua nu Setano? ");
INSERT INTO wbi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Apuo uYesu alyale ikunjova uYuda umwana ghwa Simoni uIsikalioti, ulwakuva napano alyale umo mu vavulanisivua kijigho na vavili, ghwe juno ilikumwohela. ");
INSERT INTO wbi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pambele uYesu atakaluta mufikaaja ifya mu kighavo ikya Galilaya, naakalondagha kuluta kukighavo ikya Yudea, u'wakuva aVayahudi vakalondagha kukum'buda. ");
INSERT INTO wbi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Unsiki ughwa kikulukulu kya Vayahudi ikya fyeve, ghulyale piipi kufika. ");
INSERT INTO wbi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Avanuuna va Yesu vakam'buula uYesu vakati, “Lino uvuuke apa, ulute kukighavo ikya Yudea kuuti avavingilili vaako vafyaghe ifidegho fyako fino ghuvomba. ");
INSERT INTO wbi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Umuunhu juno ilonda kukagulika, naivomba imbombo saake kuvusyefu, lino ulwakuva ghuvomba isi sooni, ghuhufie kuvaanhu vooni.” ");
INSERT INTO wbi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Avanuuna valyajovile enendiiki, ulwakuva voope navalyamwitiike. ");
INSERT INTO wbi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pe uYesu akavavuula akati, “Unsiki ghwango ghukyale pifika, looli umue ndepoonu muluta amasiki ghooni. ");
INSERT INTO wbi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Avaanhu ava mu iisi muno navangavakalalile umue, looli vikung'halalila une, ulwakuva nikuvaavuula kuuti, sino vivoomba mbiivi. ");
INSERT INTO wbi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Umue lutaghi kukikulukulu ikio; une naniluta ulwakuvaunsiki ghwango ghukyale pifika. ");
INSERT INTO wbi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","U Yesu ye ajovile aghuo akajigha mu kighavo ikya Galilaya. ");
INSERT INTO wbi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Neke avanuuna ye valutile ku kikulukulu, ghwope u Yesu akaluta, neke akaluta kisyefu, kisila kuhufia kuvaanhu. Kukikulukulu ukuo, ");
INSERT INTO wbi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","aVayahudi vakava vikumulonda u Yesu viposia kuvaanhu vitii, “Alikuughi?” ");
INSERT INTO wbi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Avaanhu vinga mulipugha lila. Vakava vikujovasia, vamo vitii, “Umuunhu ujuo nnofu.” Avange vitii, “Ndali, umuunhu ujuo isofia avaanhu.” ");
INSERT INTO wbi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Neke nakwealyale umuunhu juno alyale ijova imhola saake pa vuvalafu, ulwakuva vakoghopagha aVayahudi. ");
INSERT INTO wbi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pakate pa fighono ifya kikulukulu u Yesu akingila mu luviika ulwa nyumba inyimike ija kufunyila, akatengula kuvulanisia avaanhu. ");
INSERT INTO wbi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Avayahudi vakava videgha vitii, “Umuunhu uju akaghwile ndaani isi, kisila kwimba? ");
INSERT INTO wbi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pe pano U Yesu akavamula akati, “Imbulanisio soni nivulanisia na sango, looli sihumile kwa juno asung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Umuunhu juno ilonda kuvomba isa vughane vusa Nguluve, ikagula kuuti imbulanisio isi sihumile Nguluve, nambe kuuti nijova muvutavulilua vwango juune. ");
INSERT INTO wbi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Umuunhu juno ijova muvutavulilya vwake jujuo, ilonda avaanhu vamug'hiniaghe. Neke umuunhu juno ilonda vamughiniaghe juno ansunghile, ujuo ijova isa kyang'haani, naijova isa vudesi. ");
INSERT INTO wbi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","U Moose naalyavapeliile umue indaghilo? Neke nakwalemambe jumo pakate palyumue juno ivingilila indaghilo isio. Lino kiki milonda pikumbuda?” ");
INSERT INTO wbi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Avaantu mu lipugha lila vakamwamula vakati, “Uli ni lipepo uve. Ghwe veeni juno ilonda pikukubuda?” ");
INSERT INTO wbi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","U Yesu akavamula akati, “Une nikavombile ikidegho kimo, umue mweni mukakenyemuka. ");
INSERT INTO wbi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","U Moose alyalaghiile kuvomba ikivungo ikya kudumula ingola ija kidiimi avaana viinu. Ululaghilo uluo nalulyahumile kwa Moose, looli lulyahumile kuvakuulu viinu. Umue muvomba uluo nambe nambe kive kighono kya Sabati. ");
INSERT INTO wbi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lino nave lukwitikisivua umwana kuvombelua ikivungo ikio mukighono ikya Sabati kuuti muleke kudeenya ululaghilo ulwa Moose, kiki mukung'halalila une. Kukunsosia umuunhu mu kighono ikya Sabati? ");
INSERT INTO wbi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mulekaghe kuhiga umuunhu mulwa kulola pamaaso, looli muhighaghe mu vwakyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Avaanhu vamonga ava mu likaaja ilya Yelusalemu vakava viposania vitii, Asi, umuunhu uju naghwe juno avalongosi va Vayahudi vilonda kukumbuda? ");
INSERT INTO wbi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lolagha ijova pa vuvalafu, neke avene naijova kimonga! Pamo aveene avolongosi vitii umuunhu uju lweli ghwe Kilisite! ");
INSERT INTO wbi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ukilisite iliiva ikwisa nakwale nambe muunhu juno ilikagula kuno ihumila! Umuunhu uju kuno ihumatukagwile. ");
INSERT INTO wbi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","U Yesu ye ajhighe ivulanisia mu luviika ulwa nyumba inyimike ija kufunyila, akajova fiijo akati, “Lweli umue mweni mung'haghwile une, kange mukaghwile kuno nihuma. Nambe mwiti mukagwile uluo, ");
INSERT INTO wbi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","une nanilisile mu vutavulilua vwango, ulwene juno asung'hile une ghwa kyang'haani, umue namunkagwile. ");
INSERT INTO wbi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Une ninkagwile ulwakuva nihumile kwa mwene, kange ghwe juno asung'hile. Pepano vakava vilonda kukunkola, neke nakwealyale umuunhu juno akaghela kukunkola, ulwakuva unsiki ghwake ughwa kukolua ghulyakyale kufika. ");
INSERT INTO wbi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Avaanhu vinga mu lipugha lila vakamwitika. Vakava vijova viiti, “Iliiva ikwisa uKiliste ilivomba ifidegho kukila fino avombile uju?” ");
INSERT INTO wbi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Avafalisayi vakapulika ilipugha lya vaanhu vipwepa vwimila imhola sa Yesu, pe avavaha va vatekesi na Vafalisayi vakasuung'ha avasikali kuuti vankole. ");
INSERT INTO wbi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pepano uYesu ajajova akati, “Niiva numue unsiki n'debe vuvule, neke pambele nigomoka kwa juno asun'ghile. ");
INSERT INTO wbi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mulikundoonda, neke namulikunyaagha, kange kuno niliiva, umue namungafike.” ");
INSERT INTO wbi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pe aVayahudi vakava viposania viiti, “Umuunhu uju iluta kuughi kuno usue natunga mwaghe? Asi, iluya ku vano Vapalasiine vano nkate mu vaYunani na kukuvavulanisia avaYunani? ");
INSERT INTO wbi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Asi, kwe kuti kiki pano iiti, 'Mulikundonda, neke namulikunyaagha, kange kuno niliiva umue namungafike?” ");
INSERT INTO wbi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ikighono ikya vusililo ikya kikulukulu kya fyeve, kino kilyale kighono kivaha, uYesu akiima akajova fiijo akati, “Umuunhu nave ali ni kyumilua, iise kulyune anyue. ");
INSERT INTO wbi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Umuunhu juno ikunyitika une, iiva ndavule ghijova amalembe amimike kuuti, isaasa isa malenga amanya vwumi sidwivuka mu mwojo ghwake. ");
INSERT INTO wbi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Alyajovile uluo mu mhola ija mhepo uMwimike, juno avaanhu vano vikumwitika vilikumwupila pambele, unsiki ughuo, uNguluve alyakyale kukunsuung'ha umhepo ghwake, ulwakuva alyakyale kuhufia kuvaanu uvuvaha vwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Avaanhu vamonga mu lipugha lila ye vapuliike amasio aghuo, vakati, “Kyang'haani, umuunhu uju m'bili.” ");
INSERT INTO wbi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Vamonga vakati, “Umuunhu uju ghwe Kilisite.” Neke avange vakati, “Ndali, uKilisite ndepoonu ihuma ku Galilaya? ");
INSERT INTO wbi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Asi amalembe amimike naghiiti uKilisite ilihuma mu kikolo ikya ntwa u Daudi ku kikaaja ikya Bethelehemu, kikaaja kino alyale ikukukala untwa uDaudi? ");
INSERT INTO wbi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pepano avaanhu vakalekeng'hana vivimila uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Avaanu vamonga mu lipugha lila vakava vilonda kuku nkola, neke nakwealyale umuunhu juno akaghela kuku nkola. ");
INSERT INTO wbi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Avasikali vala vakagomoka ku vavaha va vatekesi na kuVafalisayi, kisila kunkola uYesu. Avavaha vala vakavaposia vakati, “Kiki namunkolile na kukumuleeta?” ");
INSERT INTO wbi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Avasikali vala vakamula vakati, “Naaghelile kuhumila umuunhu juno ijova ndavule umuunhu jula. ");
INSERT INTO wbi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Avafalisayi vakavaposia vakati, “Kwekuti najumue musyangilue? ");
INSERT INTO wbi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Asi ghwe veeni mu valongosi viitu nambe mu Vafalisayi juno amwitiike? ");
INSERT INTO wbi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ulwene avanu avuo avuo navasikagwile indaghilo sa moose, avuo vaghunilue.” ");
INSERT INTO wbi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pepano uNikodemu (umo mu valongosi va Vafalisayi, juno ikighono kimonga alyalutile kwa Yesu pakilo), akavaposia akati, ");
INSERT INTO wbi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Asi indaghilo siitu sikwitikisia kukumhigha umuunhu kisila kumpulikisia na kukusitang'hania sino avombile?” ");
INSERT INTO wbi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aveene vakamwamula vakati, “Neke najuuve uhumile ku Galilaya? Londagha muMalembe amimike pekyaghukagula kuuti nakwale umbili juno ahumile ku Galilaya.” ");
INSERT INTO wbi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1"," U Yesu akaluta ku kidunda ikya Miseituni. ");
INSERT INTO wbi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Palwakilo ye kukiile akagomoka kange mu nyumba inyimike ija kufunyila. Avaanu vinga vakaluta pa mwene, pe akikala, akatengula kukuvavulanisia. ");
INSERT INTO wbi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ye ivulanisia, avavulanisi va ndaghilo na Vafalisayi, vakamuleeta kwa mwene umukijuuva jumonga juno akolilue ivwafuka, Vakambiika pakate pa lipugha lya vaanhu. ");
INSERT INTO wbi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pepano vakambuula uYesu vakati, “Ghwe M'bulanisi, umukijuuva uju akolilue ivwafuka. ");
INSERT INTO wbi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lino, uMoose mu ndaghilo saake, alyatulaghile kuuti umukijuuva ndavule uju, atovwaghe na mavue, uve ghwiti ndaani?” ");
INSERT INTO wbi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Valyajovile isio kukumughela, kuuti vaave ni kiteghe ikya kumhighila. Neke uYesu akinama, akalemba ni kovye kyake pa lihanga. ");
INSERT INTO wbi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ye vajiighe vifikumposia, akinamuka, akavamula akati, “Unsila nkole pakate palyumue, ave ghwa kwanda kukuntova ni livue umukijuuva uju.” ");
INSERT INTO wbi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pe akinama kange, akalemba pa lihanga. ");
INSERT INTO wbi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ye vapuliike uluo, vakatengula pivuuka jumo jumo, kutengulila avalugoyo kuhanga un'debe. Akajigha ju Yesu nu mukijuuva jula juno alyale pakate pa veene. ");
INSERT INTO wbi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","U Yesu ye ikwinamuka akamposia akati, “Mukijuuva, valikuughi vano vikukuhigha? Nakwale nambe jumo juno ikukuhigha? ");
INSERT INTO wbi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Umukijuuva jula akamwamula akati, “Ghwe Mutwa, nakwale nambe jumo. Pepano uYesu akam'buula akati, “Na juune nanikukuhigha. Lutagha, looli kuhuma unsiki ughu, nungavombaghe inyivi kange.” ");
INSERT INTO wbi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","U Yesu akatengula pijova kange na vaanhu vala akati, “Une nili lumuli lwa iisi, umuunhu juno ikumbingilila une naighendagha mung'hiisi looli iiva nu lumuli luno lukumulongosia ku vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Avafalisayi vakam'buula u Yesu vakati, “Uvwolesi vwako navwa kyang'haani, ulwakuva ghukwoleka juuve imhola saako.” ");
INSERT INTO wbi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","UYesu akavamula akati, “Nambe nikwoleka juune imhola sango, uvwolesi vwango vwa kyang'haani, ulwakuva nikagwile kuho nihumile, na kuno niluta. Umue namukagwile kuno nihumile nambe kuno niluta. ");
INSERT INTO wbi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Umue muhigha kulinghana na masaaghe ghiinu, neke une nanihigha muunhu. ");
INSERT INTO wbi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Poope nambe nihighe, uvuhighi vwango vwa kyang'haani, ulwakuva nanihigha ne mwene, looli nu Nhaata juno asung'hile une. ");
INSERT INTO wbi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mu ndaghilo siinu lilembilue kuuti, uvwolesi vwa vaanhu vavili, vwa kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mu uluo, une nikujoleka, naju Nhaata juno asung'hile ikwoleka kuuti une neene veeni.” ");
INSERT INTO wbi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Vakamposia vakati, uNhaata ghwako ali kuughi?” UYesu akavamula akati, “Umue namun'ghagwile, ghwope uNhaata namunkagwile. Mwale mung'hagule une, naju Nhaata mwale mukunkagula.” ");
INSERT INTO wbi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","uYesu alyajovile amasio aghuo ye ivulanisia piipi ni kyumba kino kikatambulwagha kyumba kya kuviika indalama munyumba inyimike ija kufunyila. Neke nakwealyale nambe muunhu ughwa kuhkola, ulwakuva unsiki ghwake ughwa kukolua ghulyakyale kufika. ");
INSERT INTO wbi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Akavavuula kange akati, Une niluta, umue mulikundonda, neke mulifua mu vwinu. Kange kuno niluta une, umue namungafike. ");
INSERT INTO wbi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Avayahudi vakaposania vakati, “kwe kuti ilonda pikubuda? Ongo iti kuno iluta natungafike?” ");
INSERT INTO wbi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","U Yesu akavavuula akati, “Umue muhumile mu iisi iji, une nihumile kukyanya. Umue muli va mu isi iji, une nanili ghwa mu iisi iji. ");
INSERT INTO wbi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Fye nambe nivavuulile kuuti mulifua mu vuhosi vwinu. Nave namukwitika kuuti UNE NEENE, mulifua mu vuhosi vwinu. ");
INSERT INTO wbi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pe vakamposia uYesu vakati, “Tuvuule, uve veeve veeni?” UYesu akavavuula akati, “kuhuma ulutasi nivavuulite kuuti neene veeni. ");
INSERT INTO wbi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nili ni nyinga isa kujova na kukuvahigha umue. Juno asung'hile ghwa kyang'haani, une nikuvavuula avaanhu mu iisi muno, sino nipuliike kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aveene navalyalutang'hinie kuuti ijova navo imhola isa Nhaata ghwake. ");
INSERT INTO wbi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pepano uYesu akavavuula akati, “Mungamwimike uMwana ghwa Muunhu, pepano kya mukagula kuuti UNE NEENE, kange mulikagula kuuti sooni sino nivomba, nanivomba muvughane vwango, looli nijova sino uNhaata ambulanisie. ");
INSERT INTO wbi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Juno asung'hile une alipalikimo nuune, naandekile ne mwene, ulwakuva ifighono fyoni nivomba isa vughane vwake. ");
INSERT INTO wbi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","UYesu ye ijova isio, avaanhu vinga vakamwitika. ");
INSERT INTO wbi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pe pano u Yesu akavavuula aVayahudi vala, vano vamwitike akati, “Nave mugadilila imbulanisio sango, muuva vavulanisivua vaango kyang'haani, ");
INSERT INTO wbi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","apuo mukuvukagula uvwakyang'haani, uvwakang'haani uvuo, vukuvaviika kuuva vaavuke. ");
INSERT INTO wbi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aveene vakam'buula vakati, “Usue tuli va kisina kya Abulahamu. Natughelile kuuva vakami va muunhu nambe lusiku! Lwandaani ghwiti usue tuvikua vaavuke?” ");
INSERT INTO wbi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","UYesu akavamula akati, “Kyang'haani nikuvavuula, umuunhu ghweni juno ivomba inyivi nkami ghwa nyivi. ");
INSERT INTO wbi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Unkami naikukala munyumba ja ntwa ghwake ifighono fyoni, looli umwana ghwa ntwa ikukala ifighono fyoni. ");
INSERT INTO wbi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mu uluo, uMwana angavapoke muuve vaavuke, muuva vaavuke kyang'haani.” ");
INSERT INTO wbi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nikagwile kuuti umue muli va kisina kya Abulahamu, neke mulonda pikum'buda ulwakuva namukwitika imbulanisio sango. ");
INSERT INTO wbi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Une nikuvavuula sino nisivwene nu Nhaata ghwango, neke umue muvomba sino mupuliike kwa nhaata ghwinu.” ");
INSERT INTO wbi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aveene vakamwamula uYesu vakati, “Usue tuli vaana va Abulahamu. “UYesu akavavuula akati, “Mwale muuve vaana va Abulahamu mwale muvombagha sino alyale ivomba uAbulahamu. ");
INSERT INTO wbi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Une nivavulile uvwakyang'haani vuno nipulike kuhuma kwa Nguluve, umue mulonda isila ija kumbuda! uAbulahamu naalyavombile ndavule isio. ");
INSERT INTO wbi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Umue muvomba imbomba sino unhaata ghwinu ivomba.” Avayahudi vala vakamwamula vakati, “Usue natuli vaana va mulisoli, uNhaata ghwitu ali jumo mwene, ghwe Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","UYesu akavavuula akati, “UNguluve ale ave Nhaata ghwinu, mwale mukungana une, ulwakuva nihumile kwa mwene. Une nanisile muvutavulilua vwango, looli uNguluve ghwe juno asung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kiki namukusitang'hania sino nijova? Namukusitanghania ulwakuva namulonda kukwupila imbulanisio sango. ");
INSERT INTO wbi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Umue unhaata ghwinu ghwe Setano, mulonda kuvomba sino umwene. Kuhuma m'bukuulu uSetano m'budi, nailonda uvwakyanghaani, ulwakuva mwa mwene uvwakyang'haani namwevule. Kujova uvudesi lwiho lwake, ulwakuva umwene n'desi, kange ghwe nhaata ghwa vadesi vooni. ");
INSERT INTO wbi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Lino ulwakuva une nikuvavuula isa kyang'haani, fye nambe namukunyitika. ");
INSERT INTO wbi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Asi, ghwe veeni pakate palyumue juno ndepoonu ikwoleka kyang'haani kuuti une nili mhosi? Nave sino nikuvavuulasa kyang'haani, kiki namukunyitika? ");
INSERT INTO wbi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Umuunhu ghwa Nguluve ivingilila sino ijova uNguluve. Umue namuvingilila sino ijova uNguluve ulwakuva namuli vaanhu vaake.” ");
INSERT INTO wbi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Avayahudi vakambuula uYesu vakati, “Asi, nase seene pano twiti uve uli Nsamalia, kange uli ni lipepo ililamafu?” ");
INSERT INTO wbi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","UYesu akavamula akati, “Une nanili ni lipepo ililamafu. Une nikumwoghopa uNhaata ghwango, neke umue namukunyoghopa. ");
INSERT INTO wbi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Une nanilonda avaanhu vanginie; looli kwale unyakunginia, umwene ghwe mhighi ghwa kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kyang'haani nikuvavuula, umuunu juno ivingilila, sino nivulanisia, uvufue navulamwagha lusiku.” ");
INSERT INTO wbi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pepano aVayahudi vakam'buula uYesu vakati, “Lino tukagwile kuuti uli ni lipepo ililamafu! UAbulahamu alyafwile, voope avavili valyafwile, iwandaani uveghwiti, “Umuunhu juno ivingilila sino nivulanisia uvufue navulamwagha lusiku? ");
INSERT INTO wbi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kwe kuti uve uli mbaha kukila unkuulu ghwitu uAbulahamu? UAbulahamu alyafwile, avavili voope valyafwile. Neke uve ghukuviiika veeve veeni?” ");
INSERT INTO wbi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","UYesu akavamula akati, “Ningihinie juune, ulughinio lwango luuva lusila mbombo, uNhaata ghwango juno umue mwiti ghwe Nguluve ghwinu, ghwe mwene ikunginia une. ");
INSERT INTO wbi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Umue namunkagwile uNguluve, une ninkagwile. Ningati naninkagwile uNguluve, niiva ndesi ndavule umue. Une ninkagwile uNguluve, kange sino ijova nikunda. ");
INSERT INTO wbi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Unkuulu ghwinu uAbulahamu alyahovwike fiijo ye akagwile kuuti une nilikwisa, ye anyaghile, akava nu lukeelo fiijo.” ");
INSERT INTO wbi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pepano aVayahudi vakamposia uYesu vakati, “Uve nufikisie nambe amaaka fijigho fihaano, uAbulahamu ummanyile ndaani?” ");
INSERT INTO wbi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","uYesu akavamula akati, “Kyang'haani nikuvavuula niiti, uAbulahamu ye akyale kuholua UNE KWENILI.” ");
INSERT INTO wbi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","aVayahudi ye vapuliike isio, vakahola amavue kuuti vantove vabude. Neke umwene akifisa, akahuma muluviika ulwa nyumba inyimike ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ikighono kimonga uYesu ye ighenda, ali na vavulanisivua vaake, akamwagha umuunhu jumonga umbofu amaaso kuhuma iholua. ");
INSERT INTO wbi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Avavulanisivua vala vakamposia uYesu vakati, “Ghwe m'bulanisi, umuunhu uju alyaholilue m'bofu vwimila inyivi saani? Vwimila inyivi saake nambe vwimila inyivi sa vapaafi vaake?” ");
INSERT INTO wbi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","UYesu akavamula akati, “Umuunhu uju naalyaholilue m'bofu vwimila inyivi saka, nambe vwimila inyivi sa vapaafi vaake. Ulwene alyaholilue mbofu, neke ingufu sa Nguluve sivoneke kukilila umwene. ");
INSERT INTO wbi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tulondua kuvomba imbombo ija Nguluve juno asung'hile, pano jijiighe mwisi. Ikilo jikwisa pano umuunhu nangavombe imbombo iji. ");
INSERT INTO wbi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pano nijighe mu iisi, nili lumuli ku vaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","UYesu ye ajovile isio, akafuunya amati paasi, akakanda akatope na mati ghala, akapaka amaaso gha m'bofu jula. ");
INSERT INTO wbi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akambuula akati, “Lutagha ghwoghe ku maaso mu lilamba ilya Siloamu (Ilitavua ili Siloamu kwe kuti juno asunghile). Pepano akaluta kukwogha ku maaso, akagomoka ilola. ");
INSERT INTO wbi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Avabading'hani vaake na vange vooni vano valyale vikumwagha ulutasi isuuma ifiinu, vakava vikuposania viiti, “Asi, umuunhu uju naghwe juno ikalagha pamonga isuuma ifiinu?” ");
INSERT INTO wbi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vamonga vakati, “Ghwe mwene. “Avange vakati, “Naghwe mwene looli ahwaniine fiijo nu mwene. “Neke umwene akavavuula akati, “Neene!” ");
INSERT INTO wbi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pe vakamposia vakati, “Luveele ndaani kuhanga amaaso ghaako ghilola?” ");
INSERT INTO wbi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Umwene akavamula akati, “Umuunhu juno itambulua Yesu, avele akandile akatope, amhakile amaaso, pe ambulile atiile, 'Lutagha ghwoghe mu lilamba ilya Siloamu.' Naluta, noogha, ye navonagha ilola.” ");
INSERT INTO wbi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Avaanhu vala vakamposia, vakati, “Umuunhu ujuo alikughi?' Umwene akavamula akati, “Nwisi.” ");
INSERT INTO wbi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pe avaanhu vala vakantwala ku Vafalisayi umuunhu jula juno alyale m'bofu. ");
INSERT INTO wbi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ikighono kino uYesu alyakandile akarope na kukunsosia um'bofu jula, kilyale kighono kya Sabati. ");
INSERT INTO wbi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pe aVafalisayi vakamposia umuunhu jula vakati, “Asi, usokile ndaani uvubofu vwako?” Akavamula akati, “Umuunhu jumonga amhaka akatope amaaso, neke noogha, lino nilola.” ");
INSERT INTO wbi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pepano aVafalisayi vamonga vakati, “Umuunhu juno avombile uluo, naahumile kwa Nguluve, ulwakuva ivomba mukighono ikya Sabati luno nalukwitikisivua mu ndaghilo. “Neke avange vakati, “Umuunhu umhosi ndepoonu ivomba ifidegho fino fihufia ifivalilo ndavule ifi?” Mu uluo vakalekeng'hana. ");
INSERT INTO wbi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pe aVafalisayi vakamposi kange umuunhu jula vakati, “Asi, uve ghwiti ndaani vwimila umuunhu juno akusosisie amaaso?” Umwene akavamula akati, “Une niiti umuunhu jula m'bili ghwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Avalongosi va Vayahudi vala navalyitiike kuuti umuunhu jula alyaholilue m'bofu neke lino asokile ilola, kuhanga vakavakemela avapaafi vaake. ");
INSERT INTO wbi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Vakavaposia avapaafi avakati, “Asi, umuunhu uju juno mwiti aholilue m'bofu, mwana ghwinu? Asokile ndaani uvubofu vwake?” ");
INSERT INTO wbi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Avapaafi vaake vakavamula vakati, “Usue tukagwile kuuti, uju ghwe mwana ghwitu, alyaholilue m'bofu. ");
INSERT INTO wbi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Neke natukagwile atengwile ndaani kulola. Kange naju muunhu juno ansosisie amaaso, natummanyile. Mumposie, muunhu n'goyo, ikuvavuula jujuo.” ");
INSERT INTO wbi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Avapaafi vaake valyajovile uluo, ulwakuva valyale vikwoghopa avalongosi va Vayahudi. Avalongosi avuo valyiting'hiine kuuti umuunhu juno ikwitika kuuti uYesu ghwe Kilisite, vikun'daga mumasinagogi ghaave. ");
INSERT INTO wbi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Fye nambe avapaafi vala valyatiile, “Umwene muunhu n'goyo, mumposie jujuo.” ");
INSERT INTO wbi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Avalongosi va Vayahudi vakankemeela ulwa vuvili umuunhu jula juno alyale m'bofu, vakam'buula vakati, “Jova isa kyang'haani pamaaso gha Nguluve! Usue tukagwile kuuti umuunhu ujuo juno akusosisie, mhosi.” ");
INSERT INTO wbi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Umwene akavamula akati, “kuuti umuunhu ujuo mhosi, une nanikagwile, looli nikagwile kuuti nilyale m'bofu, lino nilola. ");
INSERT INTO wbi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Vakamposia kange vakati, “Asi, umuunhu ujuo avombile kiki kukukusosia amaaso ghaako?” ");
INSERT INTO wbi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Umwene akavamula akati, “Une nivavulile, umue namulonda kukumhulika, kiki mulonda nivavuule kange? NeKe najumue mulonda kuuva vavulanisivua vaake?” ");
INSERT INTO wbi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pe vakam'bepanula vakanjova vakati, “Uve veeve m'bulanisivua ghwake! Usue tulivavulanisivua va Moose. ");
INSERT INTO wbi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tukagwile kuuti uNguluve alyajovile nu Moose, neke umuunhu ujuo, natunkagwile na kuno ahumile. ");
INSERT INTO wbi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Umwene akavamula akati, “Isi sa kudegha! Namunkagwile kuno ahumile umuunu juno asosisie amaaso ghaango! ");
INSERT INTO wbi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tukagwile kuuti uNguluve naipulika inyifunyo isa vahosi looli ikumpulika umuunhu juno ikumwoghopa nakuvomba isa vughane vwake. ");
INSERT INTO wbi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kuhuma uNguluve ipela iisi, natughelile kupulika nambe lusiku kuuti umuunhu jumonga ansosisie umuunhu juno aholilue m'bofu. ");
INSERT INTO wbi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Umuunhu ujuo aale aave naahumile kwa Nguluve, naale ivomba isi.” ");
INSERT INTO wbi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Avene vakamwamula vakati, “Uve ulyaholilue mu vuhosi, ghulonda pikutuvulanisia usue? Pe vakan'daga mu sinagogi. ");
INSERT INTO wbi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","UYesu akapulika kuuti umuunhu jula van'dagile mu sinagogi. Pe akalondagha kutang'hana naghwo. Ye amwaghile, akamposia akati, “Uve, ghukumwitika uMwana ghwa Muunhu? ");
INSERT INTO wbi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Umuunhu jula akamwamula akati, “Gwe Mutwa, ghwe veeni uMwana ghwa Muunhu, nimwitike?” ");
INSERT INTO wbi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","UYesu akamwamula akati, “Umwaghile, umuunhu ujuo ghwe juno ijova nuuve lino.” ");
INSERT INTO wbi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Umuunhu jula akati, “Nikwitika! “Pe akamwimika uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","UYesu akati, “Une nisile mu isi kuhiga avaanhu, kuuti avabofu amaaso valolaghe, vano vikuvona vilola, vave vabofu amaaso.” ");
INSERT INTO wbi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Avafalisayi vamonga vano pwevalyale pala, ye vapuliike imhola isio, vakamposia vakati, Asi, kwe kuti usue tulivabofu? ");
INSERT INTO wbi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","UYesu akavamula akati, “Mwale muuve vabofu, namwale muuva vahosi. Neke ulwakuva mwiti mulola, mujigha nu vuhosi vwinu.” ");
INSERT INTO wbi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kyang'haani nikuvavuula, umuunhu juno ikwingila muluvagha lwa ng'holo kisila kukilila pa mulyango, neke ikilila pavunge, ujuo mhiji kange mhijim'budi. ");
INSERT INTO wbi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Looli juno ikilila pa mulyango, ujuo ghwe ndiimi ghwa ng'holo. ");
INSERT INTO wbi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Umuloleleli ghwa luvagha ikun'dindulila umulyango, nasi ng'holo sipulika ilisio ilya n'diimi ujuo. Ghwope ikusikemeela ing'holo saake nijingi nilitavua lyake na kukusihumia kunji. ");
INSERT INTO wbi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kyande asihumisie ing'holo saake sooni, umwene ilongola, iseene sikum'bingilila, ulwakuva silikagwile ilisio lyake. ");
INSERT INTO wbi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ing'holo nasingam'bingilile umuunhu umhesia, ulwene sikunkimbila ulwakuva nasilimanyile ilisio lyake.” ");
INSERT INTO wbi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","UYesu alyavavulile aveene ikihwanikisio iki, neke aveene navalyasitanghinie sino ikuvavuula. ");
INSERT INTO wbi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pe u Yesu akavavuula kange akati. Kyang'haani nikuvavuula, une nene mulyango ghwa luvagha pano sikwingilila ing'holo. ");
INSERT INTO wbi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Avaanhu vooni vano valyatalile kulyune kuuva vadiimi va ng'holo, valyale vahiji kange vahiijivabudi, nasing'holo nasikavapulikagha. ");
INSERT INTO wbi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Une neene mulyango, umuunhu juno ikwingila kukilila une ipokua. Kukilila une ikwingilagha na kuhuma na kuuva ni kyakulia. ");
INSERT INTO wbi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Umhiiji ikwisa nu vufumbue vwa kuhija, kubuda na kunangania. Une nisile kuuti avaanhu vave nu vwumi, vave navwo ifighono fyoni. ");
INSERT INTO wbi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Une nili ndiimi nnofu. Undiimi unnofu, anoghile kufua vwimila ing'holo saake. ");
INSERT INTO wbi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Umuunhu juno idiima ing'holo vwimila uluhombo, ujuo na ndiimi ghwa ng'holo, kange ing'holo nasaake, angavone ing'hekeeva jikwisa, ikimbila na kukusileka ing'holo seene. Pe ing'hekeeva jikwalukila ing'holo na kupalanisia. ");
INSERT INTO wbi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Umuunhu ujuo ikimbila ulwakuva uvufumbue vwake lwe luhombo, ing'holo na kiinu kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Une nili n'diimi nnofu. Ing'holo sango nisikagwile, soope sing'hagwile. ");
INSERT INTO wbi_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","n'davule uNhaata vule ang'hagwile une, na juune vule ninkagwile umwene. Une nitavula uvwumi vwanga vwimila ing'holo. ");
INSERT INTO wbi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nili ni ng'holo isingi sino nasili muluvagha ulu. Soope isio nilonda kukusileeta, soope sikumhulikagha. Apuo kiiva kipugha kimo, nu ndiimi jumo. ");
INSERT INTO wbi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ulu, fyenambe uNhaata anganile: Nitavwile kufua, neke niiva mwumi kange. ");
INSERT INTO wbi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nakwale umuunhu juno ndepoonu ivusia uvwumi vwango, looli une nitavwile june kufua. Une nilinuvutavulilua uvwa kuvusia uvwumi vwango, kange nili nu vutavulilua uvwa kuvugomosia. Nuupile ululaghilo ulu kuhuma kwa Nhaata.” ");
INSERT INTO wbi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Amasio aghuo ghakapelela aVayahudi kulekeng'hana. ");
INSERT INTO wbi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Vinga mu veene vakati, “Uju ali ni lipepo, kange apelwike. Lwakiki kukumpulikisia?” ");
INSERT INTO wbi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Avange vakava viiti, “Amasio aghuo naghihuma mwa muunhu unya lipepo. Asi, ilipepo ndepoonu likumpelela um'bofu amaaso kulola?” ");
INSERT INTO wbi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pe ghukafika unsiki ughwa kikulukulu ikya kwimika ku Yelusalemu. ");
INSERT INTO wbi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pe pano aVayahudi vamonga Unsiki ughuo ghulyale ghwa mhepo, uYesu alyale mu nyumba inyimike ija kufunyila, ighenda ghenda mu luviika luno lukatambulwagha, “Luviika lwa Solomoni.” ");
INSERT INTO wbi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pe pano aVayahudi vamonga vakankong'hanila, vakam'buula vakati, “Ghukutuviika mu nganighani mpaka liighi? Nave veeve Kilisite tuvuule pa vuvalafu!” ");
INSERT INTO wbi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","UYesu akavamula akati, “Une nivavulile kuuti neene veeni, neke umue namukwitika. Sino nivomba mu litavua lya Nhaata, sihufia kuuti neene veeni. ");
INSERT INTO wbi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Neke umue namukwitika ulwakuva namuli ng'holo sango. ");
INSERT INTO wbi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ing'holo sango sipulika ilisio lyango, na juune nisikagwile, soope sikumbingilila. ");
INSERT INTO wbi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nisipeliile uvwumi uvwa kuvusila kusila, nasilasova lusiku. Kange nakwale umuunhu ughwa kusivusia mumavoko ghango. ");
INSERT INTO wbi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","UNhaata ghwango juno amheliile ing'holo isio, m'baha kukila vooni, kange nakwale umuunhu juno ndepoonu ikusivusia mu mavoko ghaake. ");
INSERT INTO wbi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Une nu Nhaata tuli vumo.” ");
INSERT INTO wbi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ye vapuliike isio, vakahola kange amavue kuuti vantove. ");
INSERT INTO wbi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Neke uYesu akavavuula akati, “Nivombile imbombo nyinga inofu pamaaso ghiinu. Imbombo isio nivombile ku ngufu sa Nhaata. Lino, mu sino nivombile, lukilu luno lukuvapelela kukunhova na mavue?” ");
INSERT INTO wbi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","AVayahudi vakamwamula bakati, “Natulonda kukukutova na mavue vwimila imbombo inofu sino uvombile, ulwene tukukutova ulwakuva ghukumuligha uNguluve. Ghukuviika uli Nguluve napano uli muunhu ndavule avaanhu avange!” ");
INSERT INTO wbi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","UYesu akavamula akati, “Nalilembilue mufitabu fiinu ifya ndaghilo kuuti, 'Umue muli manguluve”'?” ");
INSERT INTO wbi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nave alyavatambwile manguluve, avaanu vano valyapuliike ilisio lyake (kange aMalembe aMimike ifighono fyoni ghijova isa kyang'haani), ");
INSERT INTO wbi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","lino mujova kwa juno uNhaata alyantavwile akansung'ha mu iisi mwiti, 'nikumaligha u Nguluve,' pano niiti 'Une nili Mwana ghwa Nguluve'? ");
INSERT INTO wbi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nave nanivomba imbombo isa Nhaata, namunganyiti kange. ");
INSERT INTO wbi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Neke nave nivomba, nambe namukunyitika, mwitikaghe vwimila imbombo isio neke mukagule na kukulutanghania kuuti uNhaata ali mulyune, najuune nili mwa Nhaata.” ");
INSERT INTO wbi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Neke vakava vilonda pikunkola kange, neke uYesu akavatyegha. ");
INSERT INTO wbi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","U Yesu akaluta kange imwambo ija ikya Yolidani, pano uYohani alyale ikwofugha avaanhu, akava ukuo ifighono fidebe. ");
INSERT INTO wbi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ye ali kula, avaanhu vinga vakaluta kwa mwene viiti, “UYohani naalyavombile nambe ikivalilo kimo, neke imhola sooni sino alyajovile vwimila umuunhu uju, sa kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ukuo avaanhu vinga vakamwitika uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kwe alyale umuunhu jumonga akatambulwagha Lasali. Umwene palikimo na valumbu, uMaliya nu Malita vakikalagha mukikaaja ikya Betania. Umuunu uju alyale ntamu. ");
INSERT INTO wbi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","UMaliya ujuo ghwe juno alyampakile u UMaliya ujuo, ulumbu ghwa Lasali juno alyale ntamu, ghwe juno alyampakile amafuta uMutwa uYesu mumaghulu, na kukumpulusia ni linyele lyake. ");
INSERT INTO wbi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Avalumbu avuo vakasuung'ha imhola kwa Yesu kuuti, Mutwa umanyani ghwako uLasali ntamu.” ");
INSERT INTO wbi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","UYesu ye apuliike imola ijio akati, “Inhamu ijio najikum'buda, looli jimwaghile kuuti avaanhu vavuvone uvuvaha vwa Nguluve, neke uMwana ghwa Nguluve aghinisivu kukilila inhamu ijio.” ");
INSERT INTO wbi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","UYesu alyamughanile uLasali palikimo na valumbu uMalita nu Maliya. ");
INSERT INTO wbi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Neke ye apuliike kiuuti uLasali ntamu, umwene akajigho ifighono fivi ikalile kukuo. ");
INSERT INTO wbi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pambele akavavuula avavulanisivua vaake akati, “Tuvuuke tugomoke kukighavo ikya Yudea.” ");
INSERT INTO wbi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Avavulanisivu vakambuula vakati, “Ghwe mbulanisi, imihe pahapa aVayahudi valondagha pikukutova na mavue, uve ghulonda kange pigomoka ukuo?” ");
INSERT INTO wbi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","UYesu akavamula akati, “Asi, imwisi najili ni fivalilo kijigho na fivili? Umuunhu angaghende pamwisi, naangakuvale ulwakuva ulumuli lukumulikila, ikufyagha fyoni. ");
INSERT INTO wbi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Neke angaghende pakilo ikuvala, ulwakuva nsila lumulinkate mwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","UYesu ye amalile kujova isio, akavavuula avavulanisivua vaake akati, “Ummanyaani ghwitu uLasali aghonelile, neke niluta kuuti ninsisimule. ");
INSERT INTO wbi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pe avavulanisivua vaake vakambuula vakati, “Ghwe Mutwa, nave aghonelile, isisimuka. ");
INSERT INTO wbi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","UYesu alyale ijova imhola ija kufua kwa Lasali, neke avavulanisivua vaake valyale visaagha kuuti ijova imhola ija kughonelela itulo. ");
INSERT INTO wbi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pe uYesu akavavuula pa vuvalafu akati, “ULasali afwile.” ");
INSERT INTO wbi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Neke une nihovoka vwimila umue ulwakuva nakweniveele kula uLasali ye ifua, kuuti umue munyitikaghe. Lino tuvuuke kwa Lasali. ");
INSERT INTO wbi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pe uTomasi juno itambulua, “Mung'hungu” akavavuula avavulanisivua avajaake akati, “Najusue tuvuuke, tulute tufue palikimo nu Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Unsiki uYesu ye ifika mu kikaaja ikya Betania, akavona uLasali ali ni fighono fine mu mbiipa. ");
INSERT INTO wbi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ikikaaja ikya Betania kilyale piipi ni likaaja ilya Yelusalemu ikilomita itatu ndiiki. ");
INSERT INTO wbi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Avaanhu vinga mu Vayahudi vakiisa kukuvahungila uMalita nu Maliya, ulwakuva valyafwile nu lumbu. ");
INSERT INTO wbi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pepano uMalita akapulika kuuti uYesu afiike, akaluta kukumwupilila neke uMaliya akajigha mu nyumba. ");
INSERT INTO wbi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pe uMalita akam'buula uYesu akati, “Mutwa, pe usava, ulumbulyango ngale naafwile. ");
INSERT INTO wbi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Neke nambe lino nikagwile kuuti ungansuume uNguluve kimonga, ikukupeela.” ");
INSERT INTO wbi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","UYesu akam'buula akati, “Ulumbulio isyuka.” ");
INSERT INTO wbi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","UMalita akati, “Nikagwile kuuti ilisyuka ikighono ikya vusililo kino avaanhu vooni vilisyuka.” ");
INSERT INTO wbi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","UYesu akambuula akati, “Une nene nikuvasyusia avaanhu na kukuvapeela uvwumi. Juno ikunyitika une, nambe afue iiva mwumi; ");
INSERT INTO wbi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ghwope umwumi, juno ikunyitika une, naangafue. Ghukwitika isio?” ");
INSERT INTO wbi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","UMalita akamwamula akati, “Eene Mutwa, nikwitika kuuti uve veeve Kilisite, Mwana ghwa Nguluve, juno veeve Twahulagha kuuti ghulikwisa mu iisi.” ");
INSERT INTO wbi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","UMalita ye ajovile isio, akaluta kukunkemeela unnuuna maliamu uMaliya akam'buula kuvuseyfu akati, “Um'bulanisi isile, ikukukemeela.” Pe uMaliya. ");
INSERT INTO wbi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Umaliamu ye apulike isio, akavuuka ng'haaing'haani na kuluta kwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Unsiki ughuo uYesu alyakyale kukwingila mu kikaaja ikio, alyale pala pala pano uMalita akalutile kukumwambilila. ");
INSERT INTO wbi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pepano aVayahudi vano valyale munyumba nu Maliamu palikimo na vaanhu vano vakalutile kukuvahungilila, ye vamwaghile ivuuka ng'haning'haani ihuma kunji, vakam'bingilila ulwakuva vakava visaagha kuuti iluta kulila kumbiipa. ");
INSERT INTO wbi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pepano uMaliamu akafika pa Yesu, akafughama, akambuula akati, “Mutwa, peusava ulumbu lyango ngale naafwile.” ");
INSERT INTO wbi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","UYesu ye avwene ililia, vope vano vakaale vikum'bingilila vilila, akalemala na kupumuka mu mwojo ghwake; ");
INSERT INTO wbi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","akajova akati, “Mumughonisie kughi?” Vakamwamula vakati, “Ghwe Mutwa, ghwise ulole.” ");
INSERT INTO wbi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","UYesu akalila. ");
INSERT INTO wbi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pepano avaYahudi vakajova vakati, “Lolagha vule akamughanile uLasalI!” ");
INSERT INTO wbi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Neke vamonga vakati, “Asi, uju naghwe juno akansosisie um'bofu amaaso, lino kiki naavombile kimonga kwa Lasali kuuti aleke pifua?” ");
INSERT INTO wbi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pepano uYesu ye ajiighe ipumuka mu mwojo ghwake, akafika pa mbiipa. Imbiipa ijio, jilyabughulilue na kudindua ni livue ilikome. ");
INSERT INTO wbi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","UYesu akavavuula akati, “Vusia ilivue ilio. “UMalita ulumbu ghwa Lasali umfue, akati, “Ghwe Mutwa, umbili ghuuva ghuvolile, ulwakuva fikilile ifighono fine kuhuma ifua. ");
INSERT INTO wbi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","UYesu akambuula akati, “Naniveele nikuvulile kuuti ungitike, ghukuvuvona uvuvaha vwa Nguluve?” ");
INSERT INTO wbi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pe vakavusia ilivue lila. UYesu akalola kukyanya akati, “Ghwe Nhata, nikukuhongesia ulwakuva ghupulika inyifunyo sango. ");
INSERT INTO wbi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nikagwile kuuti ghukumulika ifighono fyoni, neke nijova isi vwimila ilipugha lya vaanhu ava, neke viyike kuuti uve veeve usung'hile.” ");
INSERT INTO wbi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","UYesu ye ajovile isio, akalila fiijo akati, “Lasali huma kunji kuno!” ");
INSERT INTO wbi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pe umfue, akuhuma kunji, amaghulu na mavoko ghaake ghaniengelilue ni sanda, kumaaso apinyilue ni kitambala. UYesu akavavuula akati, “Mumhudule, mumuleke alutaghe. ");
INSERT INTO wbi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pepano aVayahudi vinga vano vakisile kukumhungila uMaliamu, ye vasivwene sino avombile uYesu, vakamwitika; ");
INSERT INTO wbi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","neke vamo mu veene vakaluta ku Vafalisayi kukuvavuula sino avombile uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pe avavaha va vatekesi na Vafalisayi vakakong'haana, vakaposania vakati, “Tuvombe kiki? Ulwakuva umuunhu uju ivomba ifidegho finga. ");
INSERT INTO wbi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nave tukumuleka anala mwene, avaanhu vooni kyande vikumwitika, aValooma vikwisa vitoola fyoni poope palyusue na ji iisi jiitu. ");
INSERT INTO wbi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pe umo muveene, juno akatambulwagha Kayafa, alyale ghwe ntekesi um'baha umwaka ughuo, akavavuula akati, “Umue namukagwile kimonga! ");
INSERT INTO wbi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Namusaagha kuuti vwimila umue, lunoghiile umuunhu jumo afue vwimila avaanhu vooni, neke iisi jooni jileke kutipulua. ");
INSERT INTO wbi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Amasio gha ntekesi ujuo naghaale masaaghe ghaake. Ulweene ulwakuva alyale ntekesi m'baha umwaka ughuo, alyaviile kuuti uYesu ifua vwima iisi; ");
INSERT INTO wbi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","nakwekuti ifua vwimila iisi jeene, looli u Yesu palikimo na kukuvakong'hania avaana va Nguluve vano vapalasiine neke vaave palikimo. ");
INSERT INTO wbi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kuhuma ikighono ikio, avalongosi va Vayahudi, vakatengula kulonda isila ija kum'buda uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mu uluo, uYesu akaleka kughenda pa vuvalafu ku Vayahudi. Pepano akavuuka pala akaluta ku kikaaja kimonga kino kikatambuluagha. Efulahimu. Ikikaaja ikio kilyale piipi ni lihaka, akikala ukuo palikimo na vavulanisivua vaake. ");
INSERT INTO wbi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ikyimike ikya Pasaka ija Vayahudi kilyale piipi. Avaanhu vinga kuhuma mu fikaaja vakaluta ku Yelusalemu kuuti vivalasie ye kikyale pifika ikyimike ikio. ");
INSERT INTO wbi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pe vakava vikumulonda uYesu. Ye vali mu nyumba inyimike ija kufunyila, vakiima viposania viiti, “Mwiti ndaani, umuunhu uju, neke naikwesa ku kyimike?” ");
INSERT INTO wbi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Unsiki ughu, avavaha va vatekesi na Vafalisayi valyavavuulile avaanhu kuuti, umuunhu ghweni angakagule pano pwale u Yesu, alutaghe kukuvavuula neke vankole. ");
INSERT INTO wbi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ifighono ntanda ye kikyale kufika ikyimike ikya Pasaka, uYesu akaluta kange ku kikaaja ikya Betania. Ukuo kwe kuno akikalagha uLasali, juno uYesu alyansyusisie kuhuma kuvafue. ");
INSERT INTO wbi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pe vakamuling'hanikisia ikyakulia ikya pakivwilile. UMalita ghwe juno akava ikuvatengelela. ULasali alyale umo ghwa vano vakikalile nu Yesu vilia ikyakulia. ");
INSERT INTO wbi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pe uMaliamu akaloota isupa ija mafuta amanofu agha ndalama nyinga, akampaka uYesu mumaghulu nakukumpulusia ni lenyele lyake. Ulunuusi lwa mafuta aghuo, lukamema inyumba jooni. ");
INSERT INTO wbi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Neke uYuda Isikalioti, umo muvavulanisivua vaYesu unya kumwohela, akati, ");
INSERT INTO wbi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kiki amafuta amafuta aghuo naghangaghusivue, “Kiki amafuta aghuo, na ghale ghighusivua indalama idinali ifilundo fitatu, neke vapelue avakotofu? ");
INSERT INTO wbi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","UYuda ye ijova isio, nakwekuti alyale ikuvavonela ikisa avakotofu, looli ulwakuva alyale mhiji. Umwene ghwe juno alalye ikola inyambe ja ndalama, akahijagha indalama mu nyambe ijio. ");
INSERT INTO wbi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","UYesu akati, “Mumuleke, ulwakuva amhakile kuling'hania um'bili ghwango vwimila ikighono ikya kusyilua. ");
INSERT INTO wbi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Avakotofu muuva navo ifighono fyoni neke namuuva nuune ifighono fyoni.” ");
INSERT INTO wbi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Avayahudi vinga vakapulika kuuti uYesu aliku Betania, pe vakaluta ukuo. Navalyalutile kukumulola ju Yesu mwene, looli valondagha vamwaghe nu Laasi juno uYesu akansyusisie kuhuma ku vafue. ");
INSERT INTO wbi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pe avavaha va vatekesi vakapuling'hana kukum'buda ghwope uLasali, ");
INSERT INTO wbi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ulwakuva vwimila kusyuka kwa mwene, aVayahudi vinga valyavalekile avalongosi vaave, vakamwitika uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ikighono ikya vuvili. avaanhu viinga vakiisa ku kyimike ye vapuliike kuuti uYesu ali musila ikwisa ku Yelusalemu, ");
INSERT INTO wbi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","pe vakatoola amataifa agha mapiki gha matende, vakahuma kukumwambilila kumo viiti, “Hosana! Afunyilue juno ikwisa mu litavua lya Mutwa, Ntwa ghwa Vaisilaeli.” ");
INSERT INTO wbi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","UYesu akajaagha inyana ja dogovi akajangalila; ndavule, “ ");
INSERT INTO wbi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Lilembilue mu malembe aMimike kuuti, “Nungoghopaghe, mwalive Syoni, lolagha, Untwa ghwinu ikwisa, angalile inyaana ja dogovi.” ");
INSERT INTO wbi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ulutasi avavilanisivua va Yesu navalyasikagwile isio; neke uYesu ye aghinisivue, pe vakakumbuka kuuti isio silyalembilue vwimila umwene na kuuti isi vam'bombile umwene. ");
INSERT INTO wbi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Avanu vano valyaale palikimo nu Yesu ye ikunkemeela uLasali kuhuma mu mbiipa na kukunsyusia, vavakava vikuvoleka avange imhola ijio. ");
INSERT INTO wbi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mu uluo avaanhu vinga vakaluta kukumwambilila, ulwakuva valyapuliike kuuti avombile ikidegho ikio. ");
INSERT INTO wbi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Neke aVafalisayi vakavulana vakati, “Mulola? Lino natunoghile kuvomba kimonga, lolagha, avaanhu vooni vikum'bingilila umwene. ");
INSERT INTO wbi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mu vaanhu vano valyalutile kukumwimika uNguluve. ku Yelusalemu ikighono ikya kyimike ikya Pasaka, mwevalyale aVayunani vamonga. ");
INSERT INTO wbi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Avuo vakaluta kwa Filipo umhuma mu likaaja ilya Betisaida mukighavo ikya Galilaya, vakati. “Tusuuma tutang'hane nu Yesu.” ");
INSERT INTO wbi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","UFilipo akaluta kukum'buula uNdeleya imhola ijio; pe vooni ve vavili vakaluta kukum'buula uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","UYesu akavamula akati, “Unsiki ughwa kughinisivua une ne mwana ne Mwana ghwa Muunhu ghufikile. ");
INSERT INTO wbi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kyanghaani nikuvavuvuula, imbeju nave najisyililue mu lihanga na kuvola. jijigha jijio jeene. Looli jingasyilue na kuvola jimela na kukoma ifipeke fiinga. ");
INSERT INTO wbi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Umuunhu juno ilonda kupoka uvwumi vwake, ujuo ikwambusia, juno ikwambusia uvwumi vwake mu iisi iji, ikuvupoka kuhanga kufika ku vwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Umuunhu ghweni juno ilonda pikumbombela une, ambingililaghe, pano pwenili naju m'boombi ghwango pwe ivisagha. Kange umuunhu angambombele une, uNhaata ikumughinia. ");
INSERT INTO wbi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Lino umwojo ghwango ghupumuka; nisivombe kiki? Ninsume uNhaata amhoke mu lutalamu luno luta pikunyaagha? Neke, lelo nifikiile unsiki ughu vwimila kukwupila ulutalamu uluo. ");
INSERT INTO wbi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ghwe Nhaata, uhufie uvuvaha vwa litavua lyako.” Pe likapulikika ilisio kuhuma kukyanya likati, “Nihufisie uvuvaha vwa litavua lyango, kange nifihufiagha.” ");
INSERT INTO wbi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ilipugha lya vaanhu vano pwevalyale pala vakapulika ilisio ilio vamonga vakati, “Fula jigulwime! “Avange vakati, “Nyamola ajovile naghwo!” ");
INSERT INTO wbi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Neke uYesu akavavuula akati, Ilisio ilio nalipulikiike mulwa kunhanga une, looli mulwa kuvatanga umue. ");
INSERT INTO wbi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lino ghufikile unsiki ughwa Nguluve kuhigha avaanhu mu iisi iji, na kukun'daga uSetano umbaha ghwa iisi iji. ");
INSERT INTO wbi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Neke ningatosivue kukyanya kuhuma mu iisi iji, nikuvapelela vooni kukwisa kulyune. ");
INSERT INTO wbi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Alyajovile uluo kuvonia kuuti ilifua vufue vuki. ");
INSERT INTO wbi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Avaanhu vala vakamwamula vakati, “Usue tupuliike mu ndaghilo kuuti uKilisite iiva mwumi ifighono fyoni Lino lwa ndaani ghwiti uMwana ghwa Adamu ilondua kutosivua kukyanya? UMwana ghwa Muunhu ghwe veeni? ");
INSERT INTO wbi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","UYesu akavamula akati, “Ulumuli lulipalikimo numue unsiki n'debe Mughendaghe mulumili uluo vule lujiighe pwelule, nekeing'hiisi jileke kukuvalema, ulwakuva juno ighenda mung'hiisi naakagwile kuno iluta. ");
INSERT INTO wbi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Lino muli nujuo ghwe lumuli, mumwitikaghe neke muuve vaana va lumuli. “Ye amalile kujova isio, akavuuka, akifisa kuuti valeke kukumwagha. ");
INSERT INTO wbi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nambe uYesu alyavombile ifidegho finga pamaaso ghaave navalyamwitiike ");
INSERT INTO wbi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","mu uluo ghakava ghakwilanisivue amasio ghano alyajovile um'bili u Yesaya kuuti, “Mutwa ghwe veeni juno itiike imhola siitu? Kange ghwe veeni juno umhufisie ingufu saako?” ");
INSERT INTO wbi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sino silyavapeleliile valeke kukwitika, se sino alyajovile um'bili uYesaya kange kuuti, ");
INSERT INTO wbi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Avabofwile amaaso ghaave, kange aghavikile amoojo ghaave kuuva masiiti kukwitika; kuuti valalola na maaso ghaave kange vakagule mu moojo ghaave pe vavanguke najuve nivapoke.” ");
INSERT INTO wbi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","UYesaya alyajovile isio ulwakuva alyavuvwene uvuvaha vwa Yesu, akajova imhola saake. ");
INSERT INTO wbi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Neke lelo, vope avolongosi vinga valyamwitike uYesu, neke navalyale vikuhufia pa vuvalafu kuuti vikumwitika, ulwakuva valyale vikwoghopa kuuti, aVafalisayi kyande vikuvadaga, mu masinagogi. ");
INSERT INTO wbi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Valyale vilonda kughinisivua na vaanhu, kukila kughinisivua nu Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","U Yesu akati, “Juno ikunyitika une, naikuniyitika juune, looli ikumwitika na juno asung'hile une, ");
INSERT INTO wbi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ghwope juno anyaghile une, amwaghile na juno asung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Un'e nili lumihu, nisile mu iisi kuuti umuunhu ghweni juno ikunyitika une aleke mu ng'hiisi. ");
INSERT INTO wbi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Umuunhu juno ipulika amasio ghango, neke naigadilila, une nanikumhigha, ulwakuva nanilisile mu iisi kukuvahigha avaanhu, looli kukuvapoka. ");
INSERT INTO wbi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Neke juno ikung'haana une, kange naikwupila amasio ghango, amasio ghano nijova ghe ghano ghilikumigha ikighono ikya vusililo. ");
INSERT INTO wbi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ulwakuva nanijovile muvutavulilua vwango juune ne mwene. Looli uNhaata juno asung'hile une ghwe juno andaghiile isa kujova. ");
INSERT INTO wbi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kange nikagwile kuuti, ululaghilo lwake lukuvapeela avaanhu uvwumi uvwa kuvusila kusila. Mu uluo sooni sino nijova se sino uNhaata andaghiile kuuti nijove.” ");
INSERT INTO wbi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ye kikyale kufika ikyimike ikya Pasaka, uYesu alyakagwile kuuti unsiki ghwake ughwa kuvuuka mu iisi, kuluta kwa Viise ghufikile, alyavaghanile avaanhu vaake ifighono fyoni, ahufisie ulughono lwake kufika kuvusililo vwa vwumi vwake mu iisi muno. ");
INSERT INTO wbi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","USetano akava ampeliile uYuda umwana ghwa Simoni Iskalioti amsaaghe agha kumwohela uYesu. ");
INSERT INTO wbi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","UYesu alyakagwile kuuti uNhaata ampeliile uvutavulilua vwoni, na kuuti alyahumile kwa mwene kange igomoka kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ye vali mu kyakulia, akiima, akafuula isopeka jaake akatandika paasi, pe akatoola ikitambala, akidenga. ");
INSERT INTO wbi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akaviika amalenga mu likalai akatengula kukuvofugha amaghulu avavulanisivua vaake na kupulusia ni kitambala kino idingile. ");
INSERT INTO wbi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pe akafika pa Simoni uPeteli, pe uPeteli akati, “Ghwe Mutwa, ghulonda pikunyofugha une amaghulu?” ");
INSERT INTO wbi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","UYesu akamwamula akati, “Luno nivomba, uve naghukulutang'hania lino, looli kyaghukuluta ng'hania pambele.” ");
INSERT INTO wbi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","UPeteli akambuula akati, “Uve nung'anyafughe une amaghulu nambe padebe.” UYesu akamwamula akati, “Nave nanikukwofugha, naghuuva nu vuhangilanisi nuune.” ");
INSERT INTO wbi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","USimoni Peteli akati, “Ghwe Mutwa, navefyelulivua uleke pikunyafugha gha maghulu, looli unyafughe nagha mavoko naghu mutu.” ");
INSERT INTO wbi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","UYesu akamwamula akati, “Umuunhu juno oghile um'bili, anoghiile kukwogha gha maghulu gheene, ulwakuva um'bili ghwoni ghuvaliile, najumue muvaliile, neke jumonga mulyumue mulyumue naavaliile.” ");
INSERT INTO wbi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","UYesu alyankagwile juno kyande ikumwohela, fye nambe alyatiile, “Jumonga mulyumue naavaliile. ");
INSERT INTO wbi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","UYesu ye amalile kukuvofugha amaghulu avavulanisivua vaake, akafwala isopeka jaake, akagomoka pano akikalile, pe akavaposia avavulanisivua vaake akati, “Asi, Mulutang'hinie luno nivombile kulyumue? ");
INSERT INTO wbi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Umue mukunhambula mwiti, 'Mbulanisi, kange mwiti Ntwa, Mujova seseene, ulwakuva nili m'bulanisi, kange nili Ntwa. ");
INSERT INTO wbi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Lino nave une ne juno nili m'bulanisi, kange nili Ntwa nivofwighe amaghulu, enendiiki na jumue fye muvombelanilaghe. ");
INSERT INTO wbi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nivahufisie ikihwanikisio iki, kuuti najumue muvavombelaghe avajiinu ndavule nivavombiile umue. ");
INSERT INTO wbi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kyang'haani nikuvavuula, unkami nam'baha kukila untwa ghwake, nambe unsung'hua na m'baha kukila juno ansung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lino, ndave ughatang'hinie amasio agha, ufunyile nave ghuvomba isio. ");
INSERT INTO wbi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nanijova isi kulyumue mweni, ulwakuva vano nivasalwile nivakagwile, neke nijova kukwilanisia aMalembe aMimike ghano ghiiti, “Umuunhu juno tuhangile kulia, angalukiile. ");
INSERT INTO wbi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nikuvavuula isi lino pano sikyale pivoneka, neke kya sivoniike mwitike kuuti une NEENE. ");
INSERT INTO wbi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Kyang'haani nikuvavuula, juno ikumwupila umuunhu juno ninsung'hile, ikunyupila une, ghwope juno ikunyupila une ikumwupila juno asung'hile une. ");
INSERT INTO wbi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ye ajovile isio, akapumuka mu mwojo, akavavuula avavulanisivua vaake akati, “Kyang'haani nikuvavuula, jumonga mulyumue itapikunyohela.” ");
INSERT INTO wbi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Avavulanisivua vaake vakava vilolane, navakakagula kuuti ikun'jova veeni. ");
INSERT INTO wbi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Umo muvavulanisivua va Yesu juno uYesu alyamughanile fiijo, alikalile piipi nu Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","USimoni uPeteli akamposia um'bulanisivua ujuo akati, “Tuvuule ghwe veeni juno ikunjova.” ");
INSERT INTO wbi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pe um'bulanisivua jula juno eghiime pa kifuva kya Yesu akamposi akati, “Mutwa, ghwe veeni?” ");
INSERT INTO wbi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","UYesu akamula akati, “Juno nikumpeela ikinkate kino nitapisaasa, ghwe mwene. “Pe akasaasa ikinkate, akampeela uYuuda umwana ghwa Simoni Isikalioti. ");
INSERT INTO wbi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","UYuda ye upiile ikinkate kila, uSetano akamwingila. Apuo uYesu akambuula akati, “Sino ghulonda kuvomba, vomba ng'haning'hani!” ");
INSERT INTO wbi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Neke vooni vano valyale vilia pala, nakwealyale nambe jumo juno alyakagwile kuuti kiki uYesu am'bulile u Yuuda enendikio. ");
INSERT INTO wbi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Neke ulwakuva uYuda ghwe juno alyale ikola indalama, vamonga vakati uvone uYesu am'bulile kuuti akaghule ifinu fino filondua pa kikulukulu, avange vakatisagha uvone ansung'hile akaghule fimonga ifya kuvapeela avakotofu. ");
INSERT INTO wbi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","UYuda ye upiile ikinkate kila, akahuma kunji ng'haninghaani. Unsiki ughuo jilyale kilo. ");
INSERT INTO wbi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","UYuda ye ahumile kunji, uYesu akati, “Lino uNguluve ahufisie uvuvaha vwango ne Mwana ghwa Muunhu, ghwope uNguluve uvuvaha vwake vuvonike kukilila une. ");
INSERT INTO wbi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nave Unguluve uvuvaha vwake vuvonike kukilila une, ghwope uNguluve kyaihufia uvuvaha vwango kisila kudiila. ");
INSERT INTO wbi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mwe vanango, nili numue unsiki n'debe vuvule, kyamukundonda, neke lino nikuvavuula ndavule nikavavulile aVayahudi kuuti, “Une kuno niluta umue namungafike. “Lino nikuvavuula na jumue. ");
INSERT INTO wbi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lino nikuvapeela ululaghilo ulupia kuuti, 'Mughananaghe, ndavule une vule nivaghanile umue najumue mughananaghe. ");
INSERT INTO wbi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nave mughanana, avaanhu vooni vikagula kuuti umue muli vavulanisivua vango.” ");
INSERT INTO wbi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","USimoni uPeteli akamposia akati, “Ghwe Mutwa, ghuluta kuughi?” UYesu akamwamula akati, “Kuno niluta nungam'bingilile lino, looli ghulikumbingilila pambele. ");
INSERT INTO wbi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","UPeteli akati, “Ghwe Mutwa, kiki naningakuvingilile lino? Une nitavwile vwimila uve, nambe kuuve kwe kufua.” ");
INSERT INTO wbi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","UYesu akamwamula akati, “Ghutavwile vwimila une, nambe kuuve kwe kufua? Kyang'haani nikukuvuula, ing'hongove ye jikyale kuvika, ghuuva ung'hanile katatu. ");
INSERT INTO wbi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Namungapumukaghe mu moojo ghiinu, Mukumwitika uNguluve, munyitikaghe na juune. ");
INSERT INTO wbi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Uvukalo kwa Nhaata ghwango vweleefu, vwale vuleke kuuva vweleefu, nanaale nikuvavuula kuuti niluta kukuva ling'hanikisia uvukalo. ");
INSERT INTO wbi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ningalute kukuvaling'hanikisia uvukalo, nigomoka kukuvatoola, neke pano pwenili une na jumue pwemuvisaghe. ");
INSERT INTO wbi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kuno niluta, isila mujikagwile.” ");
INSERT INTO wbi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","U Tomasi akati kwa Yesu, “Ghwe Mutwa, usue natukagwile kuno ghuluta. Lino ndepoonu tukujikagula ndaani isila? ");
INSERT INTO wbi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","UYesu akamwamula akati, “Une neene sila, nene vwakyang'haani, kange nene vwumi. Nakwale juno ifika kwa Nhaata kisila kukilila kulyune. ");
INSERT INTO wbi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mwale mung'hagule une, mwale mukunkagula na juNhaata. Kuhuma lino munkagwile, kange mumwaghile.” ");
INSERT INTO wbi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","UFilipo akati, “Ghwe Mutwa, utusoone uNhaata. Ungatusoone luuva lukwiline. ");
INSERT INTO wbi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","UYesu akamwamula akati, “Filipo, nikalile numue ifighono fyoni ifi, nunghagwile? Umuunhu juno anyaghile une, amwaghile uNhaata. Lina ghwiti, 'Utusoone uNhaata'? ");
INSERT INTO wbi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Asi, namukwitika une nili nkate mwa Nhaata, ghwope uNhaata ali nkate mulyune? Amasio ghano nikuvavuula, nanijova muvutavulilua vwango, looli uNhaata juno ali nkate mulyune juno ivomba imbombo saake isi. ");
INSERT INTO wbi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Munyitike une, kuuti nili nkate mwa Nhaata, ghwope uNhaata ali nkate mulyune. Munyitike une vwimila imbombo sino nivomba. ");
INSERT INTO wbi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kyang'haani nikuvavuula, juno ikunyitika une; ivombagha imbombo sino nivomba une, kange ivombagha imbaha kukila isi, ulwakuva niluta kwa Nhaata. ");
INSERT INTO wbi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mungasuume kimonga mu litavua lyango, nivomba neke uvuvaha vwa Nhaata vuvoneke kukilila une. ");
INSERT INTO wbi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mungasuume kimonga mu litavua lyango nivomba. ");
INSERT INTO wbi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nave munganile, muvingililagha indaghilo sango. ");
INSERT INTO wbi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pe najune nikunsuuma uNhaata, ghwope ikuvapeela untangili ujunge ikalaghe numue ifighono fyoni. ");
INSERT INTO wbi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Untangili ujuo ghwe Mhepo juno ihufia uvwakyang'haani. Neke avanu vano navikumwitika uNguluve navangamwupile, ulwakuva navikumwagha kange navankagwile. Looli umue munkagwile ulwakuva ikukala numue kange ali nkate mulyumue. ");
INSERT INTO wbi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Naningaveleke mwe veene; Nikwisa kange kulyumue. ");
INSERT INTO wbi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ghusighiile unsiki ndebe avaanhu vano navikumwitika uNguluve, navanganyaaghe kange, Looli umue mulikunyaagha kange, ulwakuva une nili mwumi na jumue muuva vuumi. ");
INSERT INTO wbi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ikighono ikio mulikagula kuuti une nili nkate mwa Nhaata, najume muli nkate mulyune, najune nili nkate mulyumue. ");
INSERT INTO wbi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Umuunhu juno ikwupila indaghilo na kukusivingilila, ujuo ghwe juno anganile. Juno anganile, ghwope uNhaata ikumughana umwene, na juune nikumughana na kukuhufia kwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","U Yuuda(uju naghwe Yuuda u Isikalioti) akamposia uYesu akati, “Ghwe Mutwa, lwa ndaani ghulikuhufia kulyusue, neke naghulikuhufia ku vaanhu avange?” ");
INSERT INTO wbi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","UYesu akamwamula akati, “Umuunhu juno anganile ivomba sino nikum'buula, ghwope uNhaata ikumughana umwene sino nikum'buula, ghwope uNhaata ikumughana umwene, Une nu Nhaata tukwiisa kwa mwene, na kukukala palikimo kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Neke juno naanganile, naivomba sino nikumbuula. Kange sino nikumbuula nasango, looli sa Nhaata juno asung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nivavulile sooni isio pano nijiighe palikimo numue. ");
INSERT INTO wbi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Neke Untangili ujuo, uMhepo uMwimike juno uNhaata ikunsuung'ha mu litavua lyango, ghwe ikuvavulanisyanga na kukuvakumbusia sooni sooni sino nivavulile. ");
INSERT INTO wbi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nikuvapeela ulutengano lwango. Ulutengano uluo luno nikuvapeela, naluli ndavule luno luhuma ku vaanu ava mu iisi. Namungapumukaghe mu moojo ghiinu, nambe kukwoghopa kimonga. ");
INSERT INTO wbi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mukamhulike ye nijova kuuti, 'Niluta, neke nigomoka kange kulyumue. 'Nave munganile kyang'haani, mwale muhovoka kuuti niluta kwa Nhaata, ulwakuva. uNhaata ghwe m'baha kukila une. ");
INSERT INTO wbi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nivavulile isi lino pano sikyaale kuvoneka, neke kyande sivonike mwitike. ");
INSERT INTO wbi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naningajove numue kange amasio minga, ulwakuva uSetano umbaha ghwa iisi iji ikwisa. Neke nsila ngufu kulyune, ");
INSERT INTO wbi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nivomba ndavule andaghiile uNhaata, neke avaanhu ava mu iisi vakagule kuuti nimughanile. Lino mwimetulutaghe. ");
INSERT INTO wbi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","UYesu akati, “Une neene nsabibu ghwa kyang'haani, uNhaata ghwe nya mughunda. ");
INSERT INTO wbi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ilitaafi mulyune lino nalikoma isabubu, uNhaata ikulivusia. Looli lino likoma, ikulinosia vunofu kuuti likome fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Umue munosivue, ulwakuva mwitiike sino nivavulile. ");
INSERT INTO wbi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mukalaghe nkate mulyune, najuune nikukalagha nkate mulyumue. Ilitaafi nalingakome isabibu nave nalili mu nsabibu, fye lulivuo, na jumue namungavombe sino ilonda uNguluve, nave namuli nkate mulyune. ");
INSERT INTO wbi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Une nili nsabibu, umue muli matafi. Juno ikukala nkate mulyune, najume mwa mwene; ujuo ivombagha sino ilonda u Nguluve, ulwakuva kisila kuuva nkate mulyune, namungavombe kimonga. ");
INSERT INTO wbi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Umuunhu juno naikukala nkate mulyune itaghua, ndavule ilitaafi lino nalikoma vule litaghua na kukwuma, avaanhu vihola na kunyanya. ");
INSERT INTO wbi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nave mujigha mukukala nkate mulyume na masio ghango ghikale mulyumue, musumaghe kwa Nhaata kino mulonda, ghwope ikuvapeela. ");
INSERT INTO wbi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pano mukoma fiijo ifipeke, muuva vavulanisivua vango kyang'haani. Mu uluo uNhaata ghwango ighinisivua fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ndavule uNhata vule anganile une, enendiiki najuune nivaghanile umue. Lino mukalaghe mu lughano lwango. ");
INSERT INTO wbi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nave muvingilila sino nikuvalaghila, apuo mukukala mu lughano lwango, ndavule une vule nikusivingilila sino uNhaata andaghiile na kukukala mu lughano lwake. ");
INSERT INTO wbi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nivavulile isi kuuti muuve nu lukeelo ndavule une, kange muuve nu lukeelo uluvaha fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lino nikuvalaghila kuuti mughananghe ndavule une vule nivaghanile umue. ");
INSERT INTO wbi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nakwale umuunhu unya lughano kukila ulu, ulwa kuuti, itavule uvwumi vwake vwimila umanyaani ghwake. ");
INSERT INTO wbi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nave muvomba sino nivalaghiile, muuva vamanyani vango. ");
INSERT INTO wbi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Lino nanikutambula vakami vango, ulwakuva unkami naivomba sino ivomba untwa ghwake. Looli nikuvatambula umue kuuti muli vamanyaani vango, ulwakuva nivavulile sooni sino nipuliike kuhuma kwa Nhaata. ");
INSERT INTO wbi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Umue namulyasalwile une, looli une nilyavasalwile umue na kukuvasuung'ha kuvomba sino ilonda uNguluve, kuuti, kino mukunsuuma umwene mu litavua lyango avapelaghe. ");
INSERT INTO wbi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lino nikuvalaghila umue kuuti mughananaghe. ");
INSERT INTO wbi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Nave avaanhu ava mu iisi muno, vikuvakalalila umue mukagulaghe kuuti valyatalile kukung'halalila une. ");
INSERT INTO wbi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mwale muuve vaanhu va mu iisi muno, avaanhu avuo vaale vikuvaghana, ulwakuva muli vaanhu vaave. Neke umue nivasalwile kuhuma mu iisi muno, lino umue namuli va mu iisi. Mu uluo avaanhu ava mu iisi vikuvakalalila. ");
INSERT INTO wbi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mukumbukaghe ilisio lino nilyavavulile kuuti, Unkami nam'baha kukila untwa ghwake.' Lino, nave vakamhumwisie une, najumue vikuvapumusyagha, nave vakitiike imbulanisio sango, nasi siinu vikwitikagha. ");
INSERT INTO wbi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Vikuvavombelagha isio sooni vwimila vwa kukumbingilila une ulwakuva navammanyile juno asung'hile une. ");
INSERT INTO wbi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Naale nileke kukwisa kukuvavuula, navaale viiva vahosi, neke lino navangakaane vwimila uvuhosi vwave. ");
INSERT INTO wbi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Umuunhu juno ikung'halalila une, ikunkalalila na ju Nhaata. ");
INSERT INTO wbi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nivombile ifidegho ifivaha, fino nambe muunhu na aghelile kuvomba, vaale valeke kukufyagha, ngale vasila makole. Nambe vafyaghile fyoni nivombile, vajiighe vikung'halalila une naju Nhaata. ");
INSERT INTO wbi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Isio sivombeka mulwa kukwilanisia aMalembe aMimike ghano ghiiti, 'Vakang'halaliile vuvule.' ");
INSERT INTO wbi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nikunsuung'ha kulyumue uNtangili kuhuma kwa Nhaata. Untangili ujuo ghwe Mhepo juno ihufia uvwakyang'aani, umwene ikwolekagha imhola sango. ");
INSERT INTO wbi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Najumue mukwolekagha imhola sango, ulwakuva muli palikimo nuune kuhuma ye nitengula imbombo. ");
INSERT INTO wbi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nivavulile isio kuuti namungalulekaghe ulwitiko lwinu. ");
INSERT INTO wbi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Avaanhu vikuvadagha mu masinagogi ghaave, kange ghukwisa unsiki pano umuunhu angavabude umue itisagha ikum'bombela uNguluve. ");
INSERT INTO wbi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Vilikuvavombela isio, ulwakuva navankagwile uNhaata, kange navang'hagwile une. ");
INSERT INTO wbi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nivavulile isi kuuti unsiki ughuo ghungafike, mukumbukaghe kuuti nilyavavulile. Nanilyavavulile isi ulutasi, ulwakuva nilyale palikimo numue. Sikuwaambia kuhusu mambo haya tangu mwanzo kwa sababu nilikuwa pamoja nanyi. ");
INSERT INTO wbi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Poope nambe lino niluta kwa juno alyasung'hile une kulyumue, neke napwale nambe jumo pakate palyumue juno ikumhosia kuuti, “Ghuluta kughi?” ");
INSERT INTO wbi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Neke ulwakuva nivavulile isio, musukunile fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nikavavuula isa kyang'haani kuuti, luuva lunofu kulyumue une nivuuke, ulwakuva ningaleke pivuuka uNtangili naangise. Looli ningalute nikunsuung'ha kulyumue. ");
INSERT INTO wbi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Untangili ujuo angiise, ikuvahufyagha avaanhu ava mu iisi uvuhosi vwave, uvugholofu nu vuhighi vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ihufiagha uvuhosi vwave, ulwakuva navikunyitika une. ");
INSERT INTO wbi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ikuvahufiagha uvugholofu vwango ulwakuva niluta kwa Nhaata, namulikunyaagha kange. ");
INSERT INTO wbi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ikuvahufyagha uvuhighi vwa Nguluve ulwakuva uNguluve amalile kukumhigha uSetano umbaha ghwa iisi iji. ");
INSERT INTO wbi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Napano nijighe naso nyinga isa kuvavuula, neke nanikuvavuula, ulwakuva unsiki ughu namungasitang'hanie. ");
INSERT INTO wbi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Looli uMhepo ughwa kyang'haani ujuo angiise, ikuvalongosiagha kuvingilila uvwakyang'haani; ulwakuva naijovagha muvuta vulilua vwake jujuo, looli ijovagha sino apuliike na kukuvavuula sino sikwisa. ");
INSERT INTO wbi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Umwene ihufiagha uvuvaha vwango, ulwakuva ikuvavulagha sino upiile kulyune. ");
INSERT INTO wbi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fyoni fino alinafyo uNhaata, fyango, fye nambe nivavulile kuuti, uMhepo ujuo ikuvavulagha sino upiile kuhuma kulyune. ");
INSERT INTO wbi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ghusighiile unsiki n'debe namukunyaagha kange, neke pambele unsiki n'debe kange mukunyaagha. ");
INSERT INTO wbi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Vamo mu vavulanisivua vaake vakava viposania viiti, “Asi, kwe kuti kiki pano iiti, 'Ghusighile nsiki n'debe namukunyaagha, neke pambele unsiki n'debe mukunyaagha? Na pano iiti ulwakuva niluta kwa Nhaata?” ");
INSERT INTO wbi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Vakava viposania viiti, “Kwekuti kiki pano iiti, “Ghusighile unsiki n'debe?' Natusitang'hinie isi sino ijova.” ");
INSERT INTO wbi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","UYesu akakagula kuuti vilonda kukumposia sino ajovile, pe akati, “Muposania sino nijovile kuuti, “Ghusighile unsiki n'debe mukunyaagha, neke pambele unsiki n'debe mukunyaagha'? ");
INSERT INTO wbi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kyang'haani nikuvavuula, umue mulilila na kusukunala neke avaanhu ava mu iisi vilihovoka. Mulisukunala, neke pambele ulisukunalo lwinu luluhambuka lukeelo. ");
INSERT INTO wbi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Umukijuuva pano ipaapa, iiva nu lusukunalo ulwakuva ali nu vuvafi. Neke angapaape, maikumbuka kange uvu vafi uvuo, ulwakuva iiva nu lukeelo ulwa kuuva nu mwana. ");
INSERT INTO wbi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Najumue muli nu lusukunalo lino, neke nilikwisa kange kulyumue neke muliiva nu lukeelo. Nakwale juno anoghiile kuvusia ulukeelo uluo kulyumue. ");
INSERT INTO wbi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kange unsiki ughuo ghungafike, namulikumhosia kimonga. Kyanghaani nikuvavuula, mungansuume kimonga uNhaata mu litavua lyango, ikuvapeela. ");
INSERT INTO wbi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nambe lino namunsumile kimonga mu litavua lyango. Musumaghe mupelua, neke ulukeelo lwinu lukwilane. ");
INSERT INTO wbi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nijovile isio numue mufihwanikisio, neke ghukwisa unsiki ghuno nanijovagha numue kange mu fihwanikisio. Looli nijovagha numue pa vuvalafu imhola sa Nhaata. ");
INSERT INTO wbi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Unsiki ughuo musumagha mu litavua lyango, naniiti une nikuvasumilagha kwa Nhaata, jeeje! ");
INSERT INTO wbi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Unaata jujuo avaghanile umue ulwakuva munganile une, kange mukwitika kuuti nihumile kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nilyahumile kwa Nhaata, nikiisa mu iisi muno; kange nivuuka mu iisi muno, nigomoka kwa Nhaata. ");
INSERT INTO wbi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Avavulanisiva vaake vakati, “Ulolile, lino ghujova pavuvalafu, naghujova mu fihwanikisio. ");
INSERT INTO wbi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lino, tukagwile kuuti uve usikagwile sooni, naghulonda umuunhu ghweni akuposiaghe lumonga. Mu uluo tukwitika kuuti ulyahumile kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","UYesu akavaposia akati, “Lino mukwitika? ");
INSERT INTO wbi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lolagha, unsiki ghuli piipi, lweli kange seseene ghufikile, pano umue mupalasana nujunge iluta kwa mwene na kukundeka ne mwene. Neke une nanili ne mwene ulwakuva uNhaata ali palikimo nuune. ");
INSERT INTO wbi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nikuvavuula isi kuuti muve nu lutengaano, ulwakuva muli nkate mulyune. Pa iisi apa muli ni mhumhuko, neke namungoghopaghe ulwakuva une nijilefisie iisi.” ");
INSERT INTO wbi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","UYesu ye amalile kujova isio, akalola kukyanya akati, “Nhaata, akavalilo kafikile; umughinie umwanaako, neke - ");
INSERT INTO wbi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ghwope umwanako akughinie uve ndavule vule umpeliile uvutavulilua uvwa kuvalongosia avaanhu vooni, neke avapeele uvwumi uvwa kuvusila kusila. ");
INSERT INTO wbi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Uvwumi uvwa kuvusila kusila vwe uvu: vakukagule uve ghwe Nguluvuve ghwa kyang'haani, ghwe juno uli jumo ghwe mwene, kange vang'hagule une ne Yesu Kilisite ne juno ulyasung'hile ku veene. ");
INSERT INTO wbi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Une nikughinisie pa iisi apa mulwa kumala imbombo jila jino ulyamheliile. ");
INSERT INTO wbi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Lino ghwe Nhaata, unginie une palikimo nuuve, mu vuvaha vuno nilyale navwo palikimo nuuve iisi ye jikyale kupelua. ");
INSERT INTO wbi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Avanu vano ulyamheliile mu iisi, nivahufisie uvuvaha vwa litavua lyako. Avaanhu avuo valyale vaako ukamheela une, voope valigadilile ilisio lyako. ");
INSERT INTO wbi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lino vakagwile kuuti fyoni fino ulyamheliile fihumile kulyuve, ");
INSERT INTO wbi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ulwakuva imhola jino ulyamheliile nivapulisie, voope vupiile, vakagwile kuuti kyang'haani nihumile kulyuve, kange vikwitika kuuti uve veeve ulyasung'hile une. ");
INSERT INTO wbi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Une nikuvasumila avaanu vaako avuo, ulwakuva ve vano ulyamheliile. Nanikuvasumila avaanhu vooni mu iisi. ");
INSERT INTO wbi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Avaanhu vango vooni, vaako; avaanhu vaako, vango uvuvaha vwango vuvoniike kukilila aveene. ");
INSERT INTO wbi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Une lino vivuuka mu iisi, nikwisa kulyuve, neke aveene vajiighe mu iisi, Ghwe Nhaata ghwe Mwimike, uvalolelelaghe mu ngufu isa litavua lyako lino ulyamheliile. Uvalolelelaghe kuuti vaave nu vumo ndavule tuli vumo une nuve. ");
INSERT INTO wbi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ye nili palikimo na veene, navalolelelagha mu ngufu isa litavua lyako lino ulyamheliile. Nivadimile, nakwale nambe jumo juno asovile, looli juno akanoghiile kusova kukwilanisia sino silyalembilue mu Malembe aMimike. ");
INSERT INTO wbi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lino nikwisa kulyuve, nijova amasio agha pano nijiighe mu iisi, kuuti avavulanisivua vango vavisaghe nu lukeelo mu moojo ghaave, ndavule nilinalwo une. ");
INSERT INTO wbi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nivavulile ilisio lyako, neke avaanu mu iisi vavakalalile, ulwakuva avavulanisivua vango nava mu iisi ndavule une vule nanili ghwa mu iisi. ");
INSERT INTO wbi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Une nanikukusuuma kuuti uvavusie mu iisi. muno, looli nisuma uvapoke kwa mhosi uSetano. ");
INSERT INTO wbi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Aveene nava mu iisi, ndavule une vule nanili ghwa mu iisi. ");
INSERT INTO wbi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ilisio lyako vwe vwa kyang'haani, lino nikukusuuma uvavalasie avaanhu vaako nu vwakyang'haani uvuo, vaave vaako. ");
INSERT INTO wbi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ndavule ulyasung'hile une mu iisi, najune fye nivasung'hile mu iisi. ");
INSERT INTO wbi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nikutavula lwoni kulyuve vwimila aveene, neke voope vitavule lwoni kulyuve kukukala mu vwakyanghaani. ");
INSERT INTO wbi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nanikuvasumila va vulanisivua veene, looli nikuvasumila na vano vikunyitika, vwimila kupulisivua na veene, ");
INSERT INTO wbi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kuuti vooni avuo vavisaghe nu vumo, vavisaghe nkate mulyusue, ndavule uve uli nkate mulyusue, ndavule uve uli nkate mulyune na juune nili nkate mulyuve, Nisuuma vavisaghe vumo neke avaanhu vitike kuuti uve veve usung'hile une. ");
INSERT INTO wbi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Uvuvaha vuno ulyamheliile, najuune nivapeliile aveene, neke vavisaghe nu vumo ndavule une vule nili nu vumo nuuve. ");
INSERT INTO wbi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Une niive nkate mu veene, najuuve nkate mulyune neke vaave nu vumo uvukwilanifu. Luuve enendiiki neke avaanhu avange vakagule kuuti uve veeve ulyasung'hile une, na kuuti uvaghanile ndavule unganile une. ");
INSERT INTO wbi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ghwe Nhaata, nilonda kuuti, avaanhu umheliile vavisaghe palikimo nuune, pooni pano niiva, neke vavuvone uvuvaha vwango vuno ulyamheliile, ulwakuva ulyangani kuhuma iisi ye jikyale kupelua. ");
INSERT INTO wbi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ghwe Nhaata ghwe ghwa kyang'haani, avaanu ava mu iisi navakukagwile, neke une nikukagwile. Kange avavulanisivua vango vakagwile kuuti uve veve ulyasung'hile. ");
INSERT INTO wbi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nivavulanisie vakukagule uve, kange nifivombagha uluo kuuti vaghananaghe ndavule unganile une, na juune niive kuwa ndani yao.” ");
INSERT INTO wbi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","UYesu ye amalile pikufuunya, akavuuka palikimo na vavulanisivua vaake, vakakila uluvonde ulwa Keduloni, vakingila mumughundo ughwa miseituni. ");
INSERT INTO wbi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","UYuuda unya kumwohela uYesu, alyaghumanyile umughunda ughuo, ulwakuva kekinga uYesu na vavulanisivua vaake vakakong'hanagha apuo. ");
INSERT INTO wbi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pe akakilongosia ikipugha kya vasikali na valoleleli kuhuma ku vavaha va vatekesi na ku Vafalisayi, akaluta navo mu mughunda kumo vakolile itaala, imuli ni filwilo. ");
INSERT INTO wbi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","UYesu alyakagwile sooni sino kyasikumwagha, akaluta kuveene, akavaposia akati, “Mukumulonda veeni?” ");
INSERT INTO wbi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pe aveene vakamwamula vakati, “Tukumulonda uYesu uMunasaleti.” UYesu akavavuula akati, “Neene” UYuda umwohesi alyimimile palikimo na vaanhu avuo. ");
INSERT INTO wbi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","UYesu ye avavulile kuuti, “Neene” vakagomoka kinsana nsana vakaghua. ");
INSERT INTO wbi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kange akavaposia akati, “Mukumulonda veeni?” Vakamwamula vakati, “Tukumulonda uYesu uMunasaleti.” ");
INSERT INTO wbi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","UYesu akavamula akati, “Nivavulile kuuti neene. Lino nave mukundonda une, muvaleke avaanhu ava valutaghe.” ");
INSERT INTO wbi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","UYesu akajovile enendiiki kukwilanisia sino alyajovile kuuti, “Vano ulyamheliile nanisofisie nambe jumo. ");
INSERT INTO wbi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","USimoni uPeteli alyale ni bamba, akasomola, akadumula imbulughutu ija kundio ija m'bombi ughwa ntekesi um'baha. Um'bombi ujuo akatambuluagha Maluko. ");
INSERT INTO wbi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Neke uYesu akam'buula uPeteli akati, “Gomosia ibamba jaako mu nyambe. Une ninoghiile kukwupila ulupumuko luno uNhaata anding'hanikisie?” ");
INSERT INTO wbi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Avasikali vala nu mbaha ghwave na valoleleli va valongosi va Vayahudi vakankola uYesu, vakankunga. ");
INSERT INTO wbi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Vakantwala taasi kwa Hanasi, unkwive ghwa Kayafa. UKayafa ujuo alyale ghwe ntekesi umbaha unsiki ughuo. ");
INSERT INTO wbi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kange ghwe juno alyavavuulile aVayahudi kuuti, lunoghile umuunhu jumo afue vwimila avaanhu vooni. ");
INSERT INTO wbi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","USimoni uPeteli nu m'bulanisivua ujunge vakava vikum'bingilila uYesu mumbele. Umbulanisivua ujunge ujuo, alyakaguliike nu ntekesi um'baha, akingila palikimo nu Yesu muluviika ulwa ntekesi umbaha. ");
INSERT INTO wbi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nene uPeteli akiima akiima paanji pa mulyango, Umbulanisivua ujunge jula juno alyakaguliike nu ntekesi umbaha, akahuma panji akajova nu mhinja juno alyale ikuvadindulila avaanhu umulyango, pe akamwitikisia uPeteli kukwingila muluviika. ");
INSERT INTO wbi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Umhinja jula akamposia uPeteli akati, “Asi, uve nuli umo ghwa vavulanisivua va muunhu uju?” UPeteli akamwamula akati, “Ndali, une nanili m'bulanisivua ghwake.” ");
INSERT INTO wbi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Avavombi na valoleleli valyapembile umwoto ulwakuva jilyale mhepo, vakava vikwota. Ghwope uPeteli akava palikimo na veene ikwota umwoto. ");
INSERT INTO wbi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Untekesi um'baha akamposia uYesu vwimila avavulanisivua vaake ni mbulanisio saake. ");
INSERT INTO wbi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","UYesu akamwamula akati, “Une najovaghe na vaanhu pavuvalafu, ifighono fyoni navulanisyagha mu masinagogi na Nyumba inyimike ija kufunyila, muno vikong'hana aVayahudi vooni. Nanajovagha nambe lisio limonga ku vusyefu. ");
INSERT INTO wbi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Lino kiki ghukumhosia une? Uvaposie vano vapulikagha, aveene vakagwile sino najovagha. ");
INSERT INTO wbi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","UYesu ye ajovile isio, umo mu valoleleli juno alyale piipi nu mwene, akantova ni lipi akati, “kiki ukumwamula enendiiki untekesi um'baha?” ");
INSERT INTO wbi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","UYesu akamwamula akati, “Nave nijovile fivi, jova uvuviivi vwango. Neke nave nijovile vunofu, kiki ghukunova?” ");
INSERT INTO wbi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","UYesu ye ajiighe akungilue, uAnasi akalaghila kuuti atwalue kwa ntekesi um'baha uKayafa. ");
INSERT INTO wbi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lino uPeteli ye ikwota umwoto, vamo mu vano valyale vikwota umwoto vakamposia vakati, “Asi uve nuli umo mu vavulanisivua va muunhu uju?” Umwene akakaana akati, 'Ndali, une nanili m'bulanisivua ghwake.” ");
INSERT INTO wbi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Neke umo mu vuvombi va ntekesi um'baha, juno alyale nyalukolo ghwa muunhu jula juno uPeteli akan'dumwile imbulughutu akamposia akati, “Asi, naveeve nivele nikwaghile uli palikimo nu Yesu mu mughunda?” ");
INSERT INTO wbi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","UPeteli akakaana kange, nakalingi ing'hongove jikavika. ");
INSERT INTO wbi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Palwakilo, vakantoola uYesu kuhuma kwa Kayafa, vakantwala munyumba ija kitwa ija ntwa ghwa Valooma. Neke aveene navakingili munyumba ijio, ulwakuva vangingile viiva valamafu. Mu uluo navaale vilia ikyakulia ikyimike ikya Pasaka. ");
INSERT INTO wbi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pe untwa uPilato akahuma kunji, akavaposia akati, “Asi, umuunhu uju avombile vuhosi vuki vuno mukumhigha?” ");
INSERT INTO wbi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aveene vakamwamula vakati, “Umuunhu uju, aale ave namhosi, natwale tukumuleeta kulyuve.” ");
INSERT INTO wbi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","UPilato akavavuula akati, “Lino muntoole jumue, mukamhighe ndavule silungika indaghilo siinu.” Avayahudi vakamwamula vakati, 'Usue natuli nu vutavulilua uvwa kumhigha umuunhu kuuti abudue. ");
INSERT INTO wbi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Isio silyavombike enendiiki kukwilanisia sino alyajovile uYesu vule ilifua. ");
INSERT INTO wbi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","UPilato akagomoka munkate mu nyumba ija kitwa, akankemeela uYesu akamposia akati, “Asi, uve veeve ntwa ghwa Vayahudi?” ");
INSERT INTO wbi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","UYesu akamwamula akati, “Sino ghukumhosia, sihuma mu masaaghe ghaako juuve, pamo avaanhu avange vakwomwile kuuti umhosie?” ");
INSERT INTO wbi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","UPilato akamwamula akati, “Nili Muyahudi une? Avaanu kuhuma mukisina kyako, na vavaha va vatekesi ve vano vakuletile kulyune. Uvombile kiki? ");
INSERT INTO wbi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","UYesu akamwamula akati, “Uvutwa vwango navwa mu iisi muno, vwale vuve vwa mu iisi muno avavombi vango vaale vikunhanga kuuti nileke kukolua na Vayahudi. Neke lino uvutwa vwango navwa mu iisi muno.” ");
INSERT INTO wbi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pe uPilato akamposia akati, “Kwe kuti uve uli ntwa?” UYesu akamwamula akati, “Ujovile seseene kuuti une nili ntwa. Une nilyaholilue mu iisi, kuuti nivavulanisie avaanhu uvwakyang'haani. Umuunhu juno ivingilila uvwakyang'haani, ikumhulikisia.” ");
INSERT INTO wbi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","UPilato akamosia akati, “Uvwakyang'haani kyekiki?” UPilato ye ajovile isio, akahuma kange kunji, akavavuula aVayahudi akati, “Une nanikuvuvona uvuhosi kwa muunu uju. ");
INSERT INTO wbi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Neke umue muli nu luno lukumhelela une kukun'dindulilia unkungua jumo ikighono ikya kyimike kya Pasaka. Asi, mulonda nin'dindulile untwa ghwa Vayahudi?” ");
INSERT INTO wbi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Neke avaanhu vooni vakoova vakati, “Ndali ujuo ndali, utudindulile uBalaba.” uBalaba ujuo, alyale mhijimbudi. ");
INSERT INTO wbi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pe pano uPilato akantoola uYesu na kukunkopa ni mijeledi. ");
INSERT INTO wbi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Avasikali vala vakatenda ingeela ija mifua, vakamfwasia ku mutu, kange vakamfwasia isopeka indangali. ");
INSERT INTO wbi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Pe vakava viveela kwa mwene na kukunnenela viiti, “Uve, ghwe ntwa ghwa Vayahudi! Vakava vikuntova na mapi. ");
INSERT INTO wbi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","akahuma kange kunji, akavavuula akati, “Pulikisia, umuunhu nikumuleta kulyumue kunji kuno mukagule kuuti une nanikuvwagha uvuhosi vumonga kwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pe uYesu akahuma kunji afwalile ingeela ija mifua ni sopeka indangali. UPilato akajova akati, 'Lolagha, umunu ujuo ghwe uju.” ");
INSERT INTO wbi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Avavaha va vatekesi na valoleleli ye vamwaghile, vakoova vakati, “Unkomelele pa kikovekano!” UPilato akavavuula akati, “Muntoole jumue mukankomelele, ulwakuva une nivona nsila nkome.” ");
INSERT INTO wbi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Avayahudi vakamwamula vakati, “Usue tuli nu lulaghilo, vwimila ululaghilo uluo uju anoghile kufua ulwakuva umwene ivikile Mwana ghwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","UPilato ye apulike amasio aguo, akoghopa kyongo, ");
INSERT INTO wbi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","pe akingila kange munyumba jaake ija kitwa, akamposia uYesu akati, 'Uve ghuhuma kuughi?” Neke uYesu naalyamwamwile kimonga. ");
INSERT INTO wbi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pe uPilato akati, “Kiki naghukunyamula? Asi, nukagwile kuuti une nili nu vutavulilua uvwa kukudindulila, nu vwa kukukomelela pa kikovekano? ");
INSERT INTO wbi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","UYesu akamwamula akati, “Uve naghwale ghuuva nu vutavulilua kulyune, nave nupelilue kuhuma kukyanya. Lino umuunhu juno ambikile mu mavoko ghaako mhosi kukila uve.” ");
INSERT INTO wbi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kuhuma unsiki ughuo, uPilato akava ilonda isila ija kun'dindulila uYesu. Neke aVayahudi vakoova vakati, “Ungan'dindulile umuunhu uju, naghuuva mmanyaani ghwa ntwa um'baha uKaisali. Umuunhu juno ikuviika kuuva ntwa, ikaana uvutwa vwa ntwa umbaha uKaisali.” ");
INSERT INTO wbi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","UPilato ye apulike amasio aghuo, akahuma nu Yesu kunji, akikala pa kitengo kya vuhighi, munjovele ija Kiebulania pitambulua Gabata kwe kuti, Lwalo lwa mavue. ");
INSERT INTO wbi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ikighono ikio kilyale kighono kya kuling'hania ikyimike ikya Pasaka, kaale kavalilo ka ntanda ndiiki. UPilato akavavuula aVayahudi akati, “Lolagha, uju ghwe ntwa ghwinu!” ");
INSERT INTO wbi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aveene vakoova vakati “M'busie, m'busie, unkomelele pa kikovekano.” UPilato akavaposia akati, “Asi, ninkomelele pa kikovekano untwa ghwinu?” Avavaha va vatekesi vakati, “Usue natuli nu ntwa ujunge, looli ju Kaisali!” ");
INSERT INTO wbi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pe pano uPilato akam'biika uYesu mumavoko ghaake kuuti vankomelele ");
INSERT INTO wbi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pe vakantoola uYesu, akahuma mulikaaja apindile ikikovekano kyake kuhanga kufika pano pakatambulwagha mu Kiebulania Golgota, kwekuti ling'hala lya mutu. ");
INSERT INTO wbi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Apuo vakankomelela uYesu palikimo na vange vavili, jumo ulubale ulwa kundio ujunge ulwa kung'highi umwene akava pakate. ");
INSERT INTO wbi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pepano uPilato akalemba amasio na kuviika pakyanya pa kikovekano kya Yesu. Amasio aghuo ghalyalembilue, 'UYESU UMUNASALETI, UNTWA GHWA VAYAHUDI. ");
INSERT INTO wbi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Amasio aghuo ghalyalembilue mu njovele ija Kiebulania, ija Kilooma nija Kiyunaani. Avaanhu vinga vakava vikwimba amalemba aghuo, ulwakuva pano alyakomelilue palyale piipi ni likaaja. ");
INSERT INTO wbi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Avavaha va vatekesi ava Vayahudi vakam'buula iPilato vakati, “Nungalembaghe, 'Ntwa ghwa Vayahudi; ulembe kuuti,' Umuunhu uju alyatiile, UNE NENE NTWA GHWA VAYAHUDI.” ");
INSERT INTO wbi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","UPilato akavamula akati, “Sino nilembile, nilembile.” ");
INSERT INTO wbi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Avasikali ye vankomeliile uYesu vakatoola amenda ghaake, vakaghava fighavo fine, pe nujunge akatoola ikighavo kyake. Kange vakatoola isopeka jaake. Isopeka ijio najilyahonilue, ulwene jilyatavulue kuhuma ku mutu kuhanga kufika ku maghulu. ");
INSERT INTO wbi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Avasikali avuo vakavulana vakati, “Isopeka iji tuleke pidemula, ulwene tusodolele kuuti jiive jaani. “Isio silyavombiike kukwilanisia aMalembe aMimike ghano ghiiti, “Valyaghavinie amenda ghango na kuviika ulusodolelo isopeka jaango.” ");
INSERT INTO wbi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Enendiiki fye valyavombile avasikali. Un'ghina ghwa Yesu, unnuuna ghwa ng'ina ghwa Yesu, UMaliamu umhuma mu kikaja ikya Magidala, vakimile piipi ni kikovekano kya Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","UYesu akamwagha ung'ina nu m'bulanisivua juno alyamughanile, vimile piipi nu mwene, akam'buula ung'ina akati, “Mama, lolagha ujuo mwanaako.” ");
INSERT INTO wbi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kange akam'buula um'bulanisivua jula akati, “Lolagha, ujuo mama ghwako.” Unsiki ughuo um'bulanisivua jula akantoola umama jula, kuluta naghwo kukaaja kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","UYesu ye avwene sooni sivombike akati, “Numilue.” Alyajovile enendiiki kukwilanisia aMalembe aMimike. ");
INSERT INTO wbi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Apoonu pala pwekilyale ikikong'olo kino kimemile uluhuuje ulukali ulwa sabibu. Vakatoola ikyenda vakasuvika mu luhuuje, vakakinjenga mu lupiki ulwa mpiki umuhisopo, vakantwalila pa mulomo. ");
INSERT INTO wbi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","UYesu ye anywile uluhuuje lula akati, “Sooni sivombiike!” Akinamisia umutu, akakunguka. ");
INSERT INTO wbi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ikighono ikio kyale kighono kya kuling'hania iSabati. Avayahudi navakalondagha amavili gha vafue ghajighe pa kikovekano pa kighono ikya Sabati, ulwakuva ikighono ikio kilyale kivaha! Pe vakansuuma uPilato avitikisie kuuti amaghulu agha vanhu avuo, ghadenyue, neke vavavusie pa kiko vekano. ");
INSERT INTO wbi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pe avasikali vakaluta, vakadeenya amaghulu agha muunhu ghwa kwanda nu ghwa vuvili vano valyakomelilue palikimo nu Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Neke ye vafikile pa Yesu, vakavona afwile. Mu uluo navakadeenya amaghulu ghaake. ");
INSERT INTO wbi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Umuunhu umo mu vasikali akamhoma ni mhalala uYesu pa luvafu, jikahuma idanda na malenga. ");
INSERT INTO wbi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Imhola isi silembilue nu muunhu juno alyasivwene ye sivombeka. Sino ijova sa kyang'haani, kange ghwope akagwile kuuti sino ijova sa kyang'haani, ikwoleka neke na jumue mwitike. ");
INSERT INTO wbi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Isio silyavombiiki kukwilanisia aMalembe aMimike ghano ghiiti, “Nambe umfupa ghwake ghumo naghudenyua. ");
INSERT INTO wbi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kange aMalembe aMimike aghange ghiiti” Vikumulolagha juno vamhomile.” ");
INSERT INTO wbi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Isio ye sivombiike, akiisa uYesufu umhuma mu likaaja ilya Alimatia. Umuunhu uju alyale m'bingilili ghwa Yesu kisyefu, ulwakuva akoghopa avalongosi va Vayahudi. Akansuuma uPilato kuuti avusie um'bili ghwa Yesu pakikovekano. UPilato akamwitikisia, pe akaluta akaghuvusia. ");
INSERT INTO wbi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naju Nikodemu, juno ikighono kimonga alyalutile kwa Yesu pakilo, akiisa na mafuta amanya lunusi ulunono. Amafuta aghuo ghalyale ikiilo fijigho fitatu ndiiki. ");
INSERT INTO wbi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Vooni ve vaviili vakatoola umbili ghwa Yesu vakaghuniengelela nu mwenda umpala palikimo na mafuta ghala amanya lunusi ulunono ndavule lulyale lwiho lwa Vayahudi ulwa kusyila avaanhu. ");
INSERT INTO wbi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pano valyankomeliile uYesu pweghulyale umughunda. Mu mughunda ghula mwejilyale imbiipa imia jino navaghelile kuviika nambe muunhu. ");
INSERT INTO wbi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lino, ulwakuva ku Vayahudi ikighono kyale kighono ikya kuling'hania iSabati, vakaviika um'bili ghwa Yesu mu mbiipa jila, ulwakuva jilyale piipi. ");
INSERT INTO wbi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ye kuhenga ikighono ikya kwasia mu mulungu, uMaliamu Magadalena akaluta ku mbiipa. Ye afikile akavona ilivue lino valyadindiile pa mulyango ghwa mbiipa livusivue. ");
INSERT INTO wbi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pe akavuuka luvilo kuluta kwa Simoni uPeteli na kwa m'bulanisivua ujunge juno uYesu alyamughanile, akavavuula akati, “Vam'busisie uMutwa mu mbiipa, natukagwile kuno vam'bikile.” ");
INSERT INTO wbi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","UPeteli palikimo nu m'bulanisivua ujunge jula, vakavuuka viluta ku m'biipa. ");
INSERT INTO wbi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Vooni ve vaviili vakavuuka luvilo, ne um'bulanisivua ujunge jula, akakimbila fiijo kukila uPeteli, akatala kufika ku mbiipa. ");
INSERT INTO wbi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akinama, akahungiila mumbiipa, akaghavona gha menda, neke naalingile munkate. ");
INSERT INTO wbi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pe pano uSimoni uPeteli ghwope aakfika pala, akingila mu mbiipa akaghavona amenda ");
INSERT INTO wbi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ni kitambala kino vakampinyile uYesu ku mutu, ikitambala ikio nakilyale palikimo na menda aghange, looli ikyene kilyale palubale. ");
INSERT INTO wbi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pe umbulanisivua ujunge jula ghwope akingila mu mbiipa, akalolana kukwitika. ");
INSERT INTO wbi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ulwakuva ye lukyale kuvombeka ulu, navalyaghatang'hinie aMalembe aMimike ghano ghiiti uYesu isyuka kuhuma kuvafue. ");
INSERT INTO wbi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pe avavulanisivua vala, vakagomoka kuno vakikalagha. ");
INSERT INTO wbi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Unsi ughuo uMaliamu alyimile piipi ni mbiipa ilila. Ye ajiighe ifilila akiinama akahungiliila mu mbiipa. ");
INSERT INTO wbi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Akavaagha avanyamhola vavili vafwaliile amenda amapala, vikalile pano ghulyale um'bili ghwa Yesu. Jumo alikalile ulubale lwa ku mutu, ujunge ulwa ku maghulu. ");
INSERT INTO wbi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Avanyamhola vala vakamposia vakati, “Gwe mama, ghulilila kiki?” Akavamula akati, “Nilila ulwakuva vam'busisie uMutwa ghwango, kange nanikagwile kuno vam'bikile.” ");
INSERT INTO wbi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ye ajovile amasio aghuo, akasyetuka kunsana, akamwagha uYesu imile, neke naalyakagwile kuuti ghwe Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","UYesu akamposia akati, Mama, ghulilila kiki? Ghukumulonda veeni? Umwene akasaghagha kuuti umuunhu ujuo ghwe m'bombi mumughunda ughuo. Akam'buula akati, “Ntwa nave um'busisie uMutwa, umbuule kuno um'bikile, nintoole.” ");
INSERT INTO wbi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","UYesu akati, “Maliamu! Umalimu akasyetuka, akajova mu njovele ija kiebulania akati, “Raboni” kwe kuti M'bulanisi.” ");
INSERT INTO wbi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","UYesu akati, “Nungang'holaghe “ulwakuva nikyale kuluta kukyanya kwa Nhaata, looli lutagha ku vavulanisivu vaango, uvavuule kuuti, niluta kukyanya kwa Nhaata ghwango juno ghwe Nhaata ghwinu, kange ghwe Nguluve ghwango na jumue Nguluve ghwinu. ");
INSERT INTO wbi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","UMaliamu Magadalena akaluta kuvavulanisivua va Yesu, akavavuula akati, “Une nimwaghile uMutwa!” Pe akavavuula sooni sino uYesu amulaghiile. ");
INSERT INTO wbi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ikighono ikya kwasia mu mulungu, avavulanisivua va Yesu valyakong'hanile munyumba vidindiile, ulwakuva valyale vikwoghopa avalongosi va Vayahudi. UYesu akiisa, akiima pakate pa veene akati, “Ulutengaano luvisaghe numue!” ");
INSERT INTO wbi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ye ajovile uluo, akavahufia amavoko ni mbafu saake. Avavulanisivua vaake ye vakagwile kuuti ghwe Mutwa uYesu, vakahovoka fiijo. ");
INSERT INTO wbi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","UYesu akavavuula kange akati, “Ulutengaano luvisaghe numue. Ndavule uNguluve vule alyasung'hile une, na juune nikuvasuung'ha umue.” ");
INSERT INTO wbi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ye ajovile amasio aghuo, akavapulila umwuja ghwake, ");
INSERT INTO wbi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","akati, “Upila umhepo uMwimike. Avaanhu vooni vano mukuvasaghila inyivi saave, uNguluve ikuvasaghila. Vano namukuvasaghila inyivi saave, uNguluve naikuvasaghila.” ");
INSERT INTO wbi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Neke uTomasi juno akambulwagha “Didimasi, “umo ghwa vavulanisivua kijigho na vavili, napwealyale uYesu ye ikuhufia kuvavulanisivua avajaake. ");
INSERT INTO wbi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Avavulanisivua avajaake vala, vakam'buula uTomasi vakati, 'Usue tumwaghile uMutwa. Neke umwene akavamula akati, “Une naningitike isio, nave nanifyaghile na kukwabasia ni kyongo ifivamba ifya masumale mumavoko ghaake, na kukwabasia nu luvoko lwango ikivamba mu mbafu saake.” ");
INSERT INTO wbi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ifighono lekelalubale ye fikilile, avavulanisivua va Yesu valyakong'hanile kange mu nyumba, na ju Tomasi, mwealyale. Amalyango ghalyaale madinde, uYesu akiisa kange, akiima pakate pa veene, akati, “Ulutengano luvisaghe numue.” ");
INSERT INTO wbi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pe akam'buula uTomasi akati, “Tomasi, ghwise ghwabasie amavoko ghango ni kyove kyako, kange ghwabasie imbafu sango nu luvoko lwako. Ulekaghe kuuva ni nganighani, looli ghwitikaghe.” ");
INSERT INTO wbi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","UTomasi akamula akati, “Uve uli Mutwa ghwango! uli Nguluve ghwango.” ");
INSERT INTO wbi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","UYesu akam'buula akati, “Ghwitiike ulwakuva unyaghile! Vafunyilue vano vikwitika, kisila kunyaagha.” ");
INSERT INTO wbi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","UYesu alyavombile ifidegho ifingi finga pamaaso gha vavulanisivua vaake fino nafilembilue mu kitabu iki, ");
INSERT INTO wbi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ifidegho ifi fino filembilue, filembilue neke mwitike kuuti, uYesu ghwe Kilisite, Mwana ghwa Nguluve, neke vwimila kukumwitika umwene, mwupile uvwumi mu litavua lyake. ");
INSERT INTO wbi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pambele, u Yesu akihufia kange ku vavulanisivua vaake ku lisumbe ilya Tibelia; kukuhufia kulyale enendiiki: ");
INSERT INTO wbi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","uSimoni uPeteli, uTomasi juno akatambulwagha Didimasi, uNatanaeli umhuma mu kikaaja ikya kana mukighavo ikya Galilaya, avana Sebedayi na vavulanisivua vaake avange vavili, vooni avuo valyale palikimo. ");
INSERT INTO wbi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","USimoni uPeteli akavavuula avajaake akati, “Niluta kulova isamaki. “Voope vakamwamula vakati, “Najusue tuluta palikimo nuuve.” Pe vakavuka viluta, vakingila mu ngalava, neke ikilo jooni navakambulila kimonga. ");
INSERT INTO wbi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ye kuhenga, uYesu alyimile mulubale mulisumbe, neke avavulanisivua vaake navalyakagwile kuuti Yesu. ");
INSERT INTO wbi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","UYesu akavaposia akati, “Vanango namulovile nambe samaki jimo?” Aveene vakamwamula vakati, “Natulovile nambe jimo!” ");
INSERT INTO wbi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Akavavuula akati, “Isia uvwa fu ulubale ulwa ku ndio ulwa ngalava, ukuo mupata. “Pe uvwafu, neke vakakunua kukwesa ulwakuva vakalovile isamaki nyinga. ");
INSERT INTO wbi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pepano umbulanisivua jula, juno uYesu alyamughanile fiijo akam'buula uPeteli akati, “Uju ghwe Mutwa!” USimioni uPeteli ye apulike kuuti ghwe Mutwa akatoola umwenda ghwake akipinya (ulwakuva naakipinyile vunofu) pe akitosia mulisumbe. ");
INSERT INTO wbi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Avavulanisivua avange vala vakiisa ku ngalava (ulwakuva pano valyale napakale patali palyale imita kilundo kimo ndiiki) kufika kunji kulisumbe kuhuma pa ngalava) vakava vikwesa uvwafu vumemile isamaki. ");
INSERT INTO wbi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ye vafikile kunji ku lisumbe, vakaghwagha umwoto ugwa nkala, pa mwoto apuo pwe ghulyale unkate ni samaki. ");
INSERT INTO wbi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","UYesu akavavuula akati, “Mulete isamaki sino sino mulovile.” ");
INSERT INTO wbi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pe uPeteli akingila mungalava, akakwesela kunji ku lisumbe uvwafu vula vuno vulyamemile isamaki imbaha. Isamaki isio silyale kilundo kimo ni fijigho fihaano ni tano. Napano isamaki silyale nyinga enendiiki, uvwafu navulyademwike. ");
INSERT INTO wbi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","UYesu akavavuula akati, “Mwise mulavuke, “Neke napwealyale nambe jumo mu vavulanisivua, juno alyaghelile kuposia kuuti, “Uve veeve veeni?” Valyakagwile kuuti ghwe Mutwa. ");
INSERT INTO wbi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","UYesu akiisa, akatola unkate, akavapeela, kange akatoola isamaki akavapeela. ");
INSERT INTO wbi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uluo lulyale lwa vutatu uYesu kukuhufia ku vavulanisivua vaake, kuhuma isyuka ku vafue. ");
INSERT INTO wbi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ye vamalile kulia, uYesu akamposia uSimoni Peteli akati, “Simoni mwana ghwa Yohani, unganile une kukila avange ava? “UPeteli akamwamula akati, “Eena Mutwa, uve ukagwile kuuti nikughanile.” UYesu akambuula akati, “Udimaghe ing'holo sango? ");
INSERT INTO wbi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Akamposia ulwa vuvili akati, “Simoni mwana ghwa Yohani, unganile?” UPeteli akmwamula akati, “Eena Mutwa, uve ukagwile kuuti nikughanile.” UYesu akam'buula akati, “Ulolelelaghe vunono ing'holo sango.” ");
INSERT INTO wbi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akamposia ulwa vutatu, akati, “Simoni mwana ghwa Yohani, unganile?” UPeteli akasukunala ulwakuva amposisie ulwa vutatu kuuti, “Unganile? Akamwamula akati, “Ghwe Mutwa, uve ukagwile sooni, ukagwile kuuti nikughanile.” UYesu akambuula akati, “Udimaghe ing'holo sango. ");
INSERT INTO wbi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kyang'haani nikukuvuula, ye ulinsoleka ulyamanyiine kufwala juuve amenda na kuluta kuno ghughanile. Neke ghuliiva mughogholo ghuligholosyagha amavoko ghaako, umuunhu ujunge ikukufwasyagha na kukukutwala kunu naghughanile.” ");
INSERT INTO wbi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","UYesu alyajovile isio kuvonia vule uPeteli ilifua mulwa kumughinia uNguluve. Ye ajovile isio akambuula uPeteli akati, “Umbingililaghe.” ");
INSERT INTO wbi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","UPeteli akasyetuka, akamwagha um'bulanisivua juno uYesu alyamughanile, ikuvavingilila mumbele. Um'bulanisivua ujuo ghwe juno alyeghiime pa kifuva kya Yesu ye vali pilia ikyakulia ikya pavwilile, ghwe juno alyamposisie uYesu kuuti, “Mutwa ghwe veeni juno kya ikukwohela?” ");
INSERT INTO wbi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","UPeteli ye amwaghile um'bulanisivua jula, akamposia uYesu akati, “Gwe Mutwa, kilihumila kiki kwa m'bulanisivua uju?” ");
INSERT INTO wbi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","UYesu akamwamula akati, “Nave nilonda uju ave mwumi kuhanga niliiva nigomoka, uve kikukuvava kiki? Uve mbingililaghe. ");
INSERT INTO wbi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Amasio aghuo ghano uYesu alyajovile ghakapulikika ku vavingilili vinga, pe vakasaghagha kuuti um'bulanisivua ujuo nailifua. Neke uYesu naalyajovile kuuti umbulanisivua ujuo nailifua, ulwene alyatiile, “Nave nilonda uju ave mwumi kuhanga niliiva nigomoka kikukuvava kiki? ");
INSERT INTO wbi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Umbulanisivua ujuo ghwe juno ikwoleka isi sooni, kange ghwe juno alembile isi. Usue tukagwile kuuti uvwolesi vwake vwa kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kwesili isingi nyinga sino alyavombile uYesu. Saale silembue sooni, nisaagha kuuti iisi jooni najaale jikwila kuviika ifitabu ifio. ");
INSERT INTO wbi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ikitabu ikyapakaliikyapakali nilyakilembile, Theofilo, nikajova soni sino alyasitenguile uYesu kuvomba na kuvulanisia, ");
INSERT INTO wbi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kudughila ikighono kino umwene alyapelilue kukianya. Uulu luliale yeluhumile ululaghilo kuhumila kw Mhepo mwimike kuvavulanesivua vano alyavasaluile. ");
INSERT INTO wbi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ye sikilile imumuko sa Vene, umwene alyavonike kuvanave mwuumi kange na sising'ilisio nyinga sikoleleuagha. Mufighono fijigho fine alihufisiealihufisie kuvene, napikwolelela vumila isa vatwa va Nguluve ");
INSERT INTO wbi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Panorama akatang'anagha navope, pe akavalaghilagha kuti navangavukaghe mhu Yerusalemu, loli vaghulilaghe ulyalufingo lwa Nata, lino, alyatile, “Mulyapulike kuhuma kuliune ");
INSERT INTO wbi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","kuti uYohanauYohana aliofuighe ulyofugho lwa malenga, loli umue mkwofughuagha nhu Mhepo mwimike mofighono fififii fidebe.” ");
INSERT INTO wbi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pano ye vakong'anile palikimo valyamposisie, “Mutwa, kwekuti ku uulu ghilikuvagomokesia avanhu va Israeli uvutwa?” ");
INSERT INTO wbi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Umwene akavavula akaati, “nalunoghile kuliumue kukagula amasiki Ghana uNata afumbilue kuvatavulilua va mwene jujuo.” ");
INSERT INTO wbi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Loli mukupila ingufu, unsiki ghuno ilikwisa kuliumue uMhepo umwimike; umue muliva volesi vango kuoni muYerusalem name muYahudi mwoni ni Samaria na kuvusililokuvusililo vwa iisi.” ");
INSERT INTO wbi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","U Mutwa Yesu yamalile kujova isi, avenue yevilola kukyanya, umwene akanyanyulivua kukianya, ilifunde likakupikila valeke kumuagha name Mason ghavanave. ");
INSERT INTO wbi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pano vakalolagha kukyanya nhuvusyukue yeiluta, nakalingi, avanhu vavili valyiima pakati name Kati pavanave vafwalile amanda amavalafu. ");
INSERT INTO wbi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Vakati, “Umue me vanhu va mugalilaya, lwakiiki mwimile apa mulola kukyanya?” U Yesu uju Juno atoghile kukyanya iligomoka lulalula ndavule mumbwene iluta kukyanya. ");
INSERT INTO wbi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pepano vakagomoka kuhuma kukidunda kya mizeituni, kind kilipipi nii Yerusalem, ulughendo ulwa kighono ikya sabati. ");
INSERT INTO wbi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ye vafikilevafikile vakaluta kugholofa kuno vakikalagha. Vope veva Ptro, Yohana, Yakobo, Andrea, Filipino, Thomas, Batholomayo, Matayo, Yakobo, Mwana wa Afayo, Simon Zelote, nhu Yuda Mwana wa Yakobo. ");
INSERT INTO wbi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Voni vakakolana aka huana munhu jumbo, ningufu vakaghendelela ni nyifunyo. Palikimo na vope pevaliale avakimama, Maliamu ung'ina ghwa Yesu na valumbu va mwene. ");
INSERT INTO wbi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mufighono fila uPetro akima pakate nakate navanyalukolo avanhu kilundo kimo night fijigho fivili, akati, ");
INSERT INTO wbi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Vanyalukolo, lulyanoghile Kati amalembe ghakwilanilaghe pano pakali uMhepo mwimike akajovelagha muloomo ghwa Daudi ulwakuling'ana nhu Yuda, alyamendime kuvala vano valya n'kolile uYesu. ");
INSERT INTO wbi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ulwakuva umwene alyale njiitu alyiupile ikighelelo kya mwene mumboo jiitu iiji.” ");
INSERT INTO wbi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(lino umunhu uju alyaghulile ikivanja kind aliipile nhuvuhosi vwa mwene apuo pe akaghwisagha akalongosiagha umutu, umbili ghukadendemuka namaleme ghakakung'ika niiki ghakava pavugholofu. ");
INSERT INTO wbi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Voni vanovakakilagha muYerusalemu valyasipulike soni isi, pe ikivanja ikio pevakakipela kunjovele javanave “Akelidama”ughu ghwe “mughunda ghwa Dana.”) ");
INSERT INTO wbi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Mukitabu kya Zaburi lilembilue, 'ghuula umughunda ghuake ghuva wa kuhama kwejeje name jumonga nangikalaghe Pala;' name, 'Tavulile umunhu ujunge atole inafasi jamwene ijavulongosi.' ");
INSERT INTO wbi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Uluo lwakyang'ani, lino, jumbo umughosi vakavingilisaniagha pano uMutwa Yesu alyahumile napikwingila muliusue, ");
INSERT INTO wbi_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kutengulila kulwofugho lwa Yohana kufika ikighono Kira kinda akatolwagha kukyanya, anoghile piva mwolesi ghwa lusyiuko palikimopalikimo nusue. ");
INSERT INTO wbi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","“Vakavavika pavulongolo avaghosi vaviili, Yusufu Juno akatambulivugha Balinaba, junoghuope akatambulivagha Yusto nhu Maria. ");
INSERT INTO wbi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Avene vakifunyagha vakatisagha, “Uve, Mutwa, ghwejuno ukagwile amojo gha vanhu voni, tuvikiile pavugholofu ghwe Venice muvanhu avaviili Juno usaluile. ");
INSERT INTO wbi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Uwakuhala imbombo ija vwomolia jino akajile uYuda Juno akahokile ghwejuno ahaliile papa mwene.” ");
INSERT INTO wbi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Vakavatovela ikuura vavuo, ni kura jikamughwila Mathia wejuno akavalilua palikimo na vasung'wa kijigho najumo. ");
INSERT INTO wbi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yekifikile ikighono kya Pentekoste, vanilla valyakong'anile papamo. ");
INSERT INTO wbi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nakaliingi lukahumila ulugulumo kuhuma kukyanya here luujilo lwa mepo lukamema munyumba Joni jino valikalile. ");
INSERT INTO wbi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sikavahumila imiili, sikalekeng'ana here ndapi said mwoto Kira munhu sikale pakyanya pamutu ghwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Avenu voni vakamemesevua uMhepo mwimike pevakatengula kujova injovelo isinge, ndavele uMhepo akavatangile kujova. ");
INSERT INTO wbi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Unsiki ghulaghula pevalyiale avayahudi vano vakikalagha muYerusalemu, vakamulumbagha uNguluve, kuhuma mu iise soni sino silipasi pavulanga. ");
INSERT INTO wbi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Inguluumo is yesipulikike, ikipugha kya vanhu kikaghona palikimo vakava nhu vwoghofi ulwakuva Kira much akapulike panovijova ninjovele Ja mwene jujuo. ");
INSERT INTO wbi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Vakaghasuka napideghanapidegha Avenue vakajova, “kyang'ani, available voni vanoviju kwekuti navaGalilaya? ");
INSERT INTO wbi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Lwakuva kiiki tukuvapulika, usue tweni munjovele situ sino tukaholilue na sope? ");
INSERT INTO wbi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Waparthia na vaMedi nava Elamu, navmo vikukala khu Mesopotamia, Yahudi namu Ponto naku Asia, ");
INSERT INTO wbi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Mu Frigia, Pamilia, namu Misri, naku Libya naku Kirene, navahesia voni kuhuma ku Rumi, ");
INSERT INTO wbi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Va Yahudi, na vimiike, Wakrete na Vaarabu, tukavapulika vijova munjovele situ ulwa vutavulilua lwa mbombo saNguluve.” ");
INSERT INTO wbi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Voni valyaghaswike napikwalangana; valijofisie vavuo Kwan vavuo, ");
INSERT INTO wbi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","“Ulu lulindani?” Niiki avenge valyasyojuli vakati, “Ava vamemile uluhujo ulupya.” ");
INSERT INTO wbi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Loli uPetro akiima palikimo navala kijigho na jimo, akakolelela kiongo, akavavula, “Mwevanhu va Yudea navoni vano vikukala apa pa Yerusalemu, iili live pavuvalafu paliumue, mupulikisyiaghe vunofu amasio aghango. ");
INSERT INTO wbi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Avanhu ava navaghalile ndavule musagha, ulwakuva unsiki ughu lwakilavo kivalilo kya vutatu. ");
INSERT INTO wbi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Loli iili lilyajovilue kukilila kwa m'bili uYoheli: ");
INSERT INTO wbi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jiliva mufighono ifya vusililo, u Nguluve ijova, nilikung'ilila umhepo ghuango ku vanhu voni. Avana vinhu navalivinhu vihumiagha uvuvili, avasoleka vinhu vilisonuagha sinosivoneka, navaghogholo vinhu vilighonelagha injosi. ");
INSERT INTO wbi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Vulevule ulwa vavombi vango name vavombi vango ava hinja mufighono ifio, nikung'a uMhepo ghwango vope vilivilagha. ");
INSERT INTO wbi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nihufiagha isakudegha kukyanya kuvulanga nifidegho pasi pa iisi, idanda, umwoto, niliiosi ilighifu. ");
INSERT INTO wbi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","IlijuvaIlijuva lilahambusivua kuva ng'isi naghumwesi kuva danda, ye kikyale ikighono ikivaha nhi fidegho fya Mutwa. ");
INSERT INTO wbi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Liliva ndiki umunhu ghueni Juno ikulitambulagha iliisio lya Mutwa ilivanguka.' ");
INSERT INTO wbi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mwevanhu va Islaeli, mupulikaghe amasio agha: U Yesu ghwa Nazareti, umunhu Juno mpesie nhu Nguluve kuliumue ni mbombo savatavulilua ni sakudegha, nifidegho fino uNguluve kukila pakate paliumue, ndavulejumue mulumanyile- ");
INSERT INTO wbi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ulwakuva uvutavike vulyahuvilue kuhuma kuvutengulilo, nhuvupakasi vwa Nguluve, alyatavulivue, numue, mumavoko gha vanhu avanangi, mulya n'komelile na pikum'buda, ");
INSERT INTO wbi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Juno unguluveunguluve alya mwimike, akavusia uvuvafi vwa vufue Kwa mwene, ulwakuva nalukunoghile Kwa mwene kutemua nuluo. ");
INSERT INTO wbi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ndiki u Daddy ijova vwimila vwa mwene, nilyamwaghile u Mutwa jatu pamaso ghango, umwene alikuluvokoko lwango ulwa kundio apene lolii nani veghelesivuagha. ");
INSERT INTO wbi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ulwene umwojo ghwango ghuliale nhu lukelo nalulumilii lwango lulya hovosivue. Kange naghum'bilii ghwango ghukukalagha n'kangafu. ");
INSERT INTO wbi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nhulaluleka uluvelo lyango lulaluta kuvulugu, nambe naghulikuntavula umwimike ghwako kulola uvuvole. ");
INSERT INTO wbi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uve uhufisie kuliune iisila is vwumi; ghukumbika nimeme ulukelo pavulongolo pa maso ghako.' ");
INSERT INTO wbi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nyalukolo, nakaguile kujova kuliumue ulukangasio ulwa Nata ghwitu Daudi: umwene alyafuile nakusyilua, najimbipa ja mwene jilipalikimo nusue mpaka umusyiughu iji. ");
INSERT INTO wbi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Anala, alyale m'bili kange aliyah kaguile kuuti uNguluve alijighile ulwuigho Kwan mwene, pa kitengo ikya vutwa. ");
INSERT INTO wbi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Iili alyalyaghila ng'ani pe akajova ulwakusyiuka lwa kilisite, 'nambe nalyamulekile kuvulugu, nambe naghu m'bili ghwna mwene na ghuvolile. ");
INSERT INTO wbi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","U Yesu uju - u Nguluve alyan'syusisie, Juno usue twueni tulivolesi. ");
INSERT INTO wbi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pa uluo, ye anyanyulivue muluvoko ulwa Nguluve ulwa ndio, ye upile ulufingo lwa Mhepo Mwimike kuhuma Kwa Nhata, umwene akung'ilile ulufingo ulu, lung umue mukuluvona na kupulika. ");
INSERT INTO wbi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nakuva u Daudi nalya toghile kuluta kukyanya, loli iiti, 'U Mutwa alyajovile Kwan Mutwa ghwango, ");
INSERT INTO wbi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“ikaale kuluvoko lwango ulwa ndiio, kudugha niliva nikuvavombela avalugu vako kitengo kya maghulu ghako. ");
INSERT INTO wbi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ku luo inyumba jooni Jack Israeli jikagule said kyang'ani u Nguluve ambikili umwene kuva Mutwa kange kilisite, uYesu Juno mulyankomelile.” ");
INSERT INTO wbi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lino yevapulike Ayala, sikavanyanya munhumbula savanave, vakambula uPetro navasung'wa avenge e, “Vanyalukolo, tuvombekiki?” ");
INSERT INTO wbi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","U Petrol pe akavavula, “Mulataaghe, mwofughue, umunhu ghweni, mulitavua lya Yesu kilisite ulya kusaghilua uvohosi vwinu, Kane mukupilagha uluvonolo lwa Mhepo Mwimike. ");
INSERT INTO wbi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ulyakuva kulyiumue lwe lufingo na kuvana voni navano valikuvutali, avanhu vinga ndavule uMutwa u Nguluve ghwitu ndavulendavule kyande ikuvakemela. ");
INSERT INTO wbi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kumasio minga alyavolekile na kuvapelepesia; akati, “Mujavule muhume mukikolo iiki kivuafu.” ");
INSERT INTO wbi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pepano vakavupilagha amasio gha mwene na kukwofughuagha, apuo pe vakongelela mukighono ikio ndavule kufika imbelo imbilima itatu. ");
INSERT INTO wbi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Vakajigha vagadilile imbulanisio said vasung'wa name kutangilanila, mulwa kumenyula unkate na munyifunyo. ");
INSERT INTO wbi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uludwesi lukisa kumbelo soon, nisakudegha mufidegho siksvombeka kukilila ku va sung'wa. ");
INSERT INTO wbi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vanilla vano valyitike valyalevalyale palikimo na kuva nifinhu fivanave palikimo, ");
INSERT INTO wbi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","pevakaghusiagha ifinhu fivanave na pighavania ku vooni kuling'ana nujunge ndavule akalondagha. ");
INSERT INTO wbi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Uluo ikighono pa kighono vakaghendelelagha nuvutavike vumo munyumba imbaha inyimikeinyimike ijakufunyila, valyamenyuile un'kate munyumba, valyahangilanile kuliakulia ikyakulia nulukelo nhu vukoola vwa numbula. ");
INSERT INTO wbi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Valyamughinisie u Nguluve vakitikisivuagha na vanhu voni. U Mutwa alyavongelisie mukighono kange mukighono vano valyale vivanguka. ");
INSERT INTO wbi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lino u Petro nhu Yohana yevalungumile munyumba imbaha inyimike ija kufunyila unsiki uwa kufunya, mukivalilo kya budika lubale. ");
INSERT INTO wbi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Umunhu jumonga, kivwale kuhuma iholua, alyale ipinduaipindua ifighono fioni valyale vikumughonia pamulyango ghwa nyumba imbaha inyimike ijakufunyila ghuno ghukatambulivuagha umuliango unono, ulwakuti akagule kusuma ikitekelo kuhuma kuvanhu Vene kulyalungime kunyimba imbaha inyimike ijakufunyila. ");
INSERT INTO wbi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ya vwene uPetro nhu Yohana valipipi kukwingila munyumba imbaha ijakufunyila, alyasumile ilitekelo. ");
INSERT INTO wbi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petro, akamulunguvalila amaso, palikimo nhu Yohana, akati, “tulolaghe usue.” ");
INSERT INTO wbi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kivwale akavalola, akavahuvilagha kikava kimonga kuhuma kuvanave. ");
INSERT INTO wbi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Loli u Petro akajova, “indalama ni sahabu une nanilinafyo, loli kinonilinakyo nihumia kulyuve. Mhu litavua ilya Yes kilisite ughwa mhu Nazareth, ghendagha.” ");
INSERT INTO wbi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","U Petro akantola nhi kivoko kya mwene ikyandio, akamwinamula munkyanya: nakalingi amaghulu gha mwene nififughamilo fya mwene ni fijeghe fikapata ingufu. ");
INSERT INTO wbi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akajumba mukyanya, umunhu kivwale pe akima pe akatengula kughenda, akingila munyumba imbaha inyimike ijakufunyila palikimo nhu Petro nhu Yohana, akaghenda, akajumba, napikumongesia u NGuluve. ");
INSERT INTO wbi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Avanhu vooni vakambwene ighenda na pikumughinia uNguluve. ");
INSERT INTO wbi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Vakakagulu Kati ghwe jula juno alyale ikukala na kusuma ilitekelo pa muliango unono ughwa nyumba inyimike ijakufunyila; valyamemile kudegha name kudegha kyongo pakila kinokikahumile Kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ndavule alyavakolelile uPetro nhu Yohana, avanhuavanhu voni vakakimbiliila muvukumbi vuno vatambulagha Sulemani, vakadeghagha kyingo. ");
INSERT INTO wbi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","U Petro Jeff alivwene iili, umwene akavamula avaanhu, “umue mwevanhu va much Israeli, kicking mudegha? Nakiki mulangamile amaso ghinu kulyusie, hence twesue tubombile uju ulwakuti aghendaghe ni ngufu siitu nhu vwitiki vwitu? ");
INSERT INTO wbi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","U Nguleve ghwa Ibrahim, nhu ghwa Isaka, nhu ghwa Yakobo, Nguluve ghwa Va Nhataa viitu, amwimike um'bombi ghwa mwene u Yesu. uju ghwe mwene Juno umue mukafumbatisie na panoramic umwene alyale ilonda kumulekesia ave mwavuke. ");
INSERT INTO wbi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mulyakanile umwike kange unyavwakang'ani, niki umue mukamolonda um'budighwe alekue ave mwavuke. ");
INSERT INTO wbi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Umue mulya m'budile untua ughwa vuumi, Juno u NgeluveNgeluve aliyah syusisie kuhuma ku vafue use tulivolesi va iliio. ");
INSERT INTO wbi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Lino mulwitiko mulitavua lya mwene, umunhu uju Juno mukam'bona napikagula, alyimikiluue kuvomba ningufu. Ulwitiko luno lukililakwa Yesu uvulamuke uvupesie, pavulongolo palyumue mwevoni. ");
INSERT INTO wbi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Lino, vanyalukolo, nikaguile kuti mulyavombile mhuvujasu, pe valyavombile vulevule avalongosi vinhu. ");
INSERT INTO wbi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Loli amasio ghino uNguluve aliyah vavulile nga'aani kukilila mumalomo agha vaviilivaviili voni, Katie ujuuju kilisite ilipumuka lino akwisisie. ");
INSERT INTO wbi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lino, mulataghe, musyetuke, ulwakuti uvuhosi vwinu vuoni vuvusivie, ulwakuti ghuise unsiki ughwa kutengana vwimila nhu vutavulivua. ");
INSERT INTO wbi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mulwakuti akagule pikumwomola kilisite Juno asalulivue vwimila umue, Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ujuo ghwe mwene uvulanga vumhupilile pano filava figomoka ifinhu fioni, silo u Nguluve alyasijovile pakali kukila mumalomo gha vaviili. ");
INSERT INTO wbi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sakyang'ani u Musa alyajovile, u Mutwa unguluve ikumwimiagha um'bili ndavule uneasy kuhuma munkate muvanyalukolo vitu. Mulikumpulikisyagha ifinhu fyoni fine ikuvavula umue. ");
INSERT INTO wbi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Lulihumila kuuti umunhu ghueni Juno naipulika Kwan m'biili ujuo ghwe itipulivuagha avuke pakate pa vannhu. ");
INSERT INTO wbi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ena, navavili voni kutengulila uSamweli navano valisile pambele pa mwene valyajovile kange vakapulisia ifighono ifi. ");
INSERT INTO wbi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Umwe mhu livana vavvili kange valufingo luno uNguluve alyafingine palikimo nava nyenya, ndavule alyajovile Kwan Abrahimu, 'Mhu mbeju Jakob ing'olo sooni isa mhu iisi sifunyuagha. ");
INSERT INTO wbi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","U Nguluve ya mwimisiemwimisie umbombi ghwake, alyamwomwile kulyumue tasi, ulwakuti avafunye umue ulwakushetuka kuhuma muvuhosi vwinhu. ");
INSERT INTO wbi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Unsiki uPetro nhu Yohana vyalya vijova name Vanuatu, avatekesi nhu n'sikali wa nyumba inyimike ijakufunyila mu sadukayo valyavalutile. ");
INSERT INTO wbi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Valyakalile fijo ulwakuva uPetro nhu Yohana valyale vikuvulanisia avanhu piti uYesu name pikuvavulanisia avasyoke avamwene kuhuma kuvafue. ");
INSERT INTO wbi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Valyavakolile nakuvavika mukipatalamukipatala unsiki ghwa palwakilo pakighono kikafwatile, kikale kisiki jikava vwilile. ");
INSERT INTO wbi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ikighelelo kya vaghosi valyaghelanisivue valyale imbilima ihano ndiki. ");
INSERT INTO wbi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","yejfikile ilwakilo ijakighono kind kikafwatile, piti avagoyo vavanave name vaghogholo navalembi, palkimo vyalyakong'anike palikimo muyerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","uAnasi alyale n'tekesi ngoyo, nhu Kayafa, nhu Yohana, nhu Iskanda, vanilla valyale vanyalukolo va n'tekesi ungoyo. ");
INSERT INTO wbi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yevavikile uPetro nhu Yohana pakate pavanave, vakaaposia, “Mungufu nyiki, Kane mulitavua lyani muvomba iili?” ");
INSERT INTO wbi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Niiki uPetro yeah amemile uMhepo umwimike, akavavula, umwe me vagoyo vavanhu, na vaghogholo, ");
INSERT INTO wbi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ndavule usyue ikighono kyamusiughu tuposevua vwimila vwa mbombo inofu jino tumbombile umunhu un'tamu uuju-lwandani umunhu uuju avuuvuke? ");
INSERT INTO wbi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Leka livonekaghe iliio name kuvanhu voni name Islaeli Joni, Katie mulitavua ilya Yesu kilisite ughwa Nazarethi, Juno mkakolile, Juno uNguluve akasyusisyie kuhuma kuhuma kuvafue, vwimila vwa Silas Jack mwene kuti umunhu uuju imile pavulongolo pa maaso ghinu yeah nkafu. ");
INSERT INTO wbi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","UYesu kilisite lyelivue lino umweumwe mwe va lengaji mukalisyojule, lyelinolyelino livikilue kuva livue likome lya muulubale. ");
INSERT INTO wbi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nakulivuvangi Kwa munhu ujunge Juno avesaghe. Ulwakuva nakwelile ilinge ilitavua pasi pavulanga lino vapelilue avanhu, vwimila vwa ilio likagwile tuvanguka.” ");
INSERT INTO wbi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Niike ye vavuvwene uvukangafu uvwa Petrol nhu Yohana, people vakakagula kuuti Vanuatu va vulevule vano name vimbi, pe vakadegha, vakakagula kuti uPetro nhu Yohana vakale palikimo nhu Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ulwakuva vakabwene umunu Juno avuvusivue imiile palikimo name Vene, no valyale ni sa kujova kange. ");
INSERT INTO wbi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Loli ye vupile ululaghilo avasung'wua vavuke pavulongolo pa lukong'ano lwa kivighiili pe vakajovagha vavuo Kwan vavuo. ");
INSERT INTO wbi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Vakajovagha, tukuvavomba kiiki avanhu ava? Sakyang'ani ikidegho kya kudegha kivombike kukilila muvanave lulipavuvalafu kuvanhu voni vano vikukala mhu Yerusalemu natungakane ilio. ");
INSERT INTO wbi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Loli ulwakutiulwakuti imola iiji jileke pikwila mhu vanhu voni, isagha tuvapavile valajova Kwan jumonga mhu litavua iili. ");
INSERT INTO wbi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Vakavakemela u Petrol nhu Yohana mun'kate name pikuva laghila kuti nambe lusiku valajovagha nambe lusiku kuvulanisia mhu litavua lya Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Loli uPetro nhu Yohana vakavamula name pikuvavula, “Nave lunofu pa Maso gha Nguluve pikuvapulikisia umwe kukila uNguluve, umue mhuhighaghe jumue. ");
INSERT INTO wbi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ulwakuva usue natungabuhile kujova imola sino tusaghile name pikusipulika.” ");
INSERT INTO wbi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ye vavapavile kyiongo u Petrol nhu Yohana, pevakavalekesia valutaghe. Navakalyaghile limonga ilyakuti me vavakungile, ulwakuva avanhu voni valyale vikumughinia uNguluveuNguluve kuluno valya vombilelue. ");
INSERT INTO wbi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Umunhu Jula Juno alya vuvusivue alyale name make ifijigho fine. ");
INSERT INTO wbi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yevavalekisie uPetro nhu Yohana vakisa ku vanhu avuoavuo na kuvavula soni iisio sino avatekesi avavaha na vaghogholo ghano valya vavulile. ");
INSERT INTO wbi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ye vaghapulike, vakavela kyingo palikimo Kwa Nguluve vakati, Mutwa uve ulyapelile uvulanga night iisi night nyanja night finhu fyoni mun'kate mhusene. ");
INSERT INTO wbi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Uve wejuno, mhepo mwimike, kukila mumolomo gown Nata ghitu Daudi, um'bombi ghwako, ulyajovile, lwakiki avanhu avapanji vikutupumusia, avanhu VA ghanilwe isio sino nasinoghile? ");
INSERT INTO wbi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Avatua va muiisi valyang'alisie palikimo, na vaTemi valyakong'anile palikimo ulwa Mutwa nhu mesiia ghwamwene. ");
INSERT INTO wbi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sakyang'ani, voni u Herode nhu Pontro Pilato, palikimo name vanhu avapanji na vanhu VA isilaeli, vakakng'anavakakng'ana palikimo mulikaja iili ilya n'sung'ua uYesu kilisitekilisite Juno alyampakile imono. ");
INSERT INTO wbi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Valyakong'anile palikimo kuvomba soni sino uluvoko lwako nhu vughane vwako vulyalighile kutengulila pakale yeah nasihumile iisi. ");
INSERT INTO wbi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lino Mutwa, usilolaghe inyoghofio save, uvapele ingufu avavombi vako kukulijova ilisio liako night ngufungufu soni. ");
INSERT INTO wbi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ulwakuti pano ghugholosia uluvoko lwako kuvuvusia, ifidegho ifyakudegha fikagule kuvoneka vwimila vwa m'bombi ghwako uYesu mwimike. ");
INSERT INTO wbi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yevamalile pikufunya pano valyakong'anile palikimo pepakasenyeneka, Nike voni vakamema umhepo umwmike, vakajova iliisio lya Nguluve ningufu soni. ");
INSERT INTO wbi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ikipugha kya voni vano vakamwitike vyalyale nhe numbula jimo nhu mwojo ghomo: na kwalyiale nambe jumonga Juno akafisagha fioni finalinafyo fyamwene jujuuo, vwimila lwa uluouluo valiale ni fine fyoni palikimo. ");
INSERT INTO wbi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kungufu soni vakapulisiagha uvwolesi vwave uvwa kusiuka uMutwa uYesu, lusungu uluvaha lulyale pavene voni. ");
INSERT INTO wbi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Napaliale name jumbo Juno alyaghilue name fimonga fino akafilondagha, ulwakuva avanhu voni vano valiale nikarata sa fivanja nambe nyumba, valyaghusiagha name kuieta indalama soni kufioni fino valyaghusiagha ");
INSERT INTO wbi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","vakafibikagha pasi pamaghulu ghavusung'ua. Pevakamughavilagha umunhu ghweni Juno aliale mwitike, vakampelagha Kira munhu ndavule ilonda. ");
INSERT INTO wbi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusufu, Malawi, umunhu umuma ku Kipro, akapelua ilitavua lya Balinaba (lilyaghanulivue mwana ghwa lutengano). ");
INSERT INTO wbi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Alyale nhu mughunda, alyaghusisie pe akaleta indalama soni, akasivika pasi pamaghulu gha vusung'ua. ");
INSERT INTO wbi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Niike, umunhu jumonga akatambulivuagha Anania, nhu Safira undala ghwa mwene, valyaghusisie ikighavo kya kyiuma, ");
INSERT INTO wbi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","akafisa Simo indalama sinovalya ghusisie (undala ghwa mwene ghuope alyakaguile ilio), pe akaleta ikighavo kinokisighile na kuvika pamaghulu gha vasung'wa. ");
INSERT INTO wbi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Loli uPetro akajova, “Ananias kiiki usetano amemisie inhumbula jako kujova uvudesi Kwan Mhepo Mwimike napifisa ikighavo ikyakiuma ikya mughunda ghuako? ");
INSERT INTO wbi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pano ghukakyiale nakikale kiuma kyiako? Kange ye ghughusivue, nalikale pasi pavulamuli vuuaako? Lukale ndani kusagha iili mumwojo ghuako? Nuvasiangile avanhu, loli, unsyiangile uNguluve.” ");
INSERT INTO wbi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ulwakupulika amasio agha, Anania alyaghuile pasi nakufua baho. Uludwesi ulukome lukavisile vooni vanovalyapulike iliio. ");
INSERT INTO wbi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Avasoleka vakisa pavulongolo na vakam'bika mwenda ghwa kusilila vakamumia kunji name pikunsyiila. ");
INSERT INTO wbi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ye fikilile ifivalilo fitatu ndiiki, un'dala ghwa mwene alingile n'kate, nalyakaguile nambe kuti kihumile kiiki. ");
INSERT INTO wbi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","U Petro Adam'bula, “Mbule, nde mughusisie umughunda ikighelelo ikio, “Akati eyo, ikighelelo ikio. ");
INSERT INTO wbi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pe uPetro akam'bula, “Lulindani piti muhongine kukunsyianga uMhepo ghwa Mutwa? Lola, amaghulu gha vano vasyilile umughosi ghuako ghalipamuliango, vikukupindagha napi kutwala kunji.” ");
INSERT INTO wbi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na kalingi akaghua pa maghulu ghagha Petro, akafua, avasoleka vala vakisa vakamwagha afwile. Vakapinda vakatwala kunji, vaka syila piping nhu mughosi ghwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Uludwesi uluvaha lukisa kulukong'ano luoni, nakuvoni vano valyapulike aghast. ");
INSERT INTO wbi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ifidegho finga ni sa kudegha inyinga sikale sihumila muvanhu kukilila mumavoko gha vasung'wa. Valyiale palikimo muvukumbi vwa Sulemani. ");
INSERT INTO wbi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Loli nakwaliale umunhu ujunge Juno alyale ningufu kukolana navene; neiki anala, valyapelilue ulughinio ulukomeulukome name vanhu. ");
INSERT INTO wbi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kange, aviitiki avinga valialevaliale vikwongelelavikwongelela Kwa Mutwa, ikipugha ikikome ikya vaghosi. ");
INSERT INTO wbi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kange kiongo valiapindile avatamu ava mufikaja, napikuvaghonia mufitala na mufitengo ifya lutogo, ulwakuti u Petrol ikiling'ania, umughighi ghwa mwene ghukagule pikwika kuvanave. ");
INSERT INTO wbi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Apuo kange, ikipugha kya vanhu vinga valisile kuhuma mufikaja fioni fine fisiunguite Muyerusalemu, vakavaletagha avatamu vano vamemile imipepo imilamafu, vanilla valyasokile. ");
INSERT INTO wbi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","LoliLoli untekesi umbaha akimagha, navoni vano valyale palikimo nhumwene (vanovalyale kipuha kya Sadukayo); pevalyamemile ningera. ");
INSERT INTO wbi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Vakagholosia amavoko ghave kukuvakolo ava sung'ua napikuvavika munkate mundinde ijavoni. ");
INSERT INTO wbi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mumasiki gha pakilo unyamola ghwa Mutwa akadindula amaliango gha ndinde akavalongosia kunji name piti, ");
INSERT INTO wbi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Lutagha, munyumba imbaha inyimike ijakufunyila na pikuvavula avanhu amasio ghoni agha vuumi uuvu.” ");
INSERT INTO wbi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ye vapulike iili, vakingilagha munyumba imbaha inyimike ijakufunyila unsiki uwakuhenga na kuvavulanisia. Loli untekesi umbaha alisile navo voni vano alyale navope, nakukemela ikipugha kya vahighi voni palikimo na vaghogholo voni ava vanhu va Israeli pe akavomora kundinde piti vavalete avasung'ua. ");
INSERT INTO wbi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","LoliLoli avavombiavavombi vanovalyalutile, nava kavagha mundinde, valyagomuke na kuhumia immoral, ");
INSERT INTO wbi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tujivuene indinde jidindilue vunono kange jilivunono, navavaloleli vimile palilyango, lol panotuvele tudindula, natubwene munhu munkate.” ");
INSERT INTO wbi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nike unsikari umbaha ughwa nyumba imbaha inyimike ijakufunyila navatekesi avavaha yevapulike amasio agha, pe vakavavakava ni nganingani imbaha vwimila vwa avuo vakatisagha luvandani mu isii. ");
INSERT INTO wbi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Loli jumonga akisa napikuvavula, “Avanhu vano mukavavikile mhundinde vimile munyumba imbaha ijakufunyila vikuvavulanisia avanhu.” ");
INSERT INTO wbi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Apuo unsikari umbaha akaluta palikimo navavombi, pe akavaleta, navakavavombela ulutalamu, ulwakuva vakavoghopagha avanhu vale vikuvatova na mavue. ");
INSERT INTO wbi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ye vavaletile, vakavavika pavulongolo pavahighi. Untekesi umbaha akavaposia ");
INSERT INTO wbi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","akati, “Tukavavulile mulekaghe pivulanisia mulitavua iili, mujigha mujimemisie iYerusalemu ni m'bulanisio sinhu, munoghelua kuleta idanda ja munhu uju kulyusue.” ");
INSERT INTO wbi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Loli uPetro na vasunng'ua vakamula, “Lunoghile kukumwitika uNguluve kejeje avanhu. ");
INSERT INTO wbi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nguluve ghwa vaNata viitu alyansusisie uYesu, Juno mulyam'bundile napikunkomelela pakpiki. ");
INSERT INTO wbi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","U Nguluve alyamwimike muluvoko lwamwene ulwa ndio, alyam'biikile kuvam'baha kange mbangi, kuhumia ululuto kwa Israel, nulusaghilo lwavuhosi. ");
INSERT INTO wbi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Usue tulivolesi va isio nhu Mhepo Mwimike, juno u Nguluve akantavwile kuvano vikumwitika.” ");
INSERT INTO wbi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Avahighi va baraza ye vapulike isio, vakakolua ni ng'alasi vakalondagha kukuvabuda avasung'ua. ");
INSERT INTO wbi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Loli uFarisayo Juno akatambulivuagha Gamalieli, um'bulanesi ghwa ndaghilo, alyale ikwoghopua navanhu voni, akiima na pikuvavula avasung'wa vavahumie kunji nsinki n'debe. ");
INSERT INTO wbi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pe akavavula, “Vaghosi va Israeli mulolelelaghe kiongo nakino mulonda pikuvavombela avanhu ava. ");
INSERT INTO wbi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ulwakuva, unsiki ghunoghulyakilile, Theuda akima na pikughinia kuva munhu mbuha ni kipugha kya vaanhu, vino valyule ifilundo fine valyam'bingilile. Alyabudilue, vooni vino valya mwitike vakapalasana na kusovanika. ");
INSERT INTO wbi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ye akilile umunhu ujuo, uYudauYuda mu Galilaya, alyimile ifighono ifya kulembua, akavakwesa avaanhu viinga vakam'bingilila. Ghwope vulevule alyasovile voni vano vakamwitika valyapalasine. ");
INSERT INTO wbi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lino nikuvavula, mughelaghe name vaanhu ava muvaleke veene, ulwakuva, nave uvutavike uvu nambe imbombo iji ja vaanhu jitaghua. ");
INSERT INTO wbi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Loli nave ja Nguluve namungaghele pikuvasigha; mvaghile pikujagha mulua nhu Nguluve.” pe, vakamwitika amasio gha mwene. ");
INSERT INTO wbi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kange, akavakemela avasung'ua munkate pepe akavakopa na kukuvavula valajovelagha mulitavua lya Yes, pe vakavalekagha valutaghe kuvanave. ");
INSERT INTO wbi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Valyavukile pavulongolo pavuhighipavuhighi vahovuike ulyakuva vavalilivue kuuti vanoghile kupumuka na kubedua vwimila ilitavua ilio. ");
INSERT INTO wbi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lino, ifighono fioni, munkate munyumba imbaha inyimike ijakufunyila na kuhuma inyumba iji kange iji valyajighe vivulanisia papiikun'dalikila u Yesu kuti ghwe Messiah. ");
INSERT INTO wbi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lino mufighono ifi, unsiki ghwa kipugha kya vavulanesivua panokilyale kikwongelela, injeghelo jiiva Yahudi vaki Yunani jilyatenguile kange nava Ebrania, ulwakuva avafuile vavanave valyale vikuvashemua mulighavo lya jatu ilya kyakulia. ");
INSERT INTO wbi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Avasung'ua kijigho na vavili valyavakemelile ilipugha lioni ilya vavulanisivua vakati, “Nalunofu kulyiusue kukulileta ilisio lya Nguluve nakutengelela pa meza. ");
INSERT INTO wbi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Lino vanyalukolo, salula, avaghosi lekela lubale, kuhuma mun'kate muliumue, avanhu avahugu, vanovamemile uMhepo nhu wakyang'ani, vanotuvangile kukuvapela imbombo iji. ");
INSERT INTO wbi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Najusue, tughendelelaghe jatu pikufunya na mumbombo ijalisio. ");
INSERT INTO wbi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","I hotuba jivanave jikalunoghile ulukong'ano luoni. Pa uluo vakansalula uSitefano, umunhu Juno aliya memile ulwitiko nhu Mhepo Mwimike, nhu Filipino, Prokoro, Nikanori, Timoni, Parmena, nhu Nikolao, umugholofu kuhuma Antiokia. ");
INSERT INTO wbi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Avitiiki vakavaleta avanhu ava pa Maaso gha vasung'ua, vano valyavasumile pavulongolo vakavavika amavoko ghavanave. ");
INSERT INTO wbi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Niiki ilisiio lya Nguluve like kwlagha, ikipugha ikya vavulanisivua kikava kikwongelela kuula kuYerusalemu; nikipughanikipugha ikikome ikya vatekesi vakale kulwitiko. ");
INSERT INTO wbi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nhu Sitefano, Juno alyamemile urusungu ni ngufu, alyale ivomba isakudegha ni fidegho ifikome mukipugha kya vanhu. ");
INSERT INTO wbi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Loli apuo avanhu vamo vakima avavingiliili munyumba ijakufunyila lino likatambulivuagha nyumba ijakufunyila ija Muhuru, ni lya va Kirene nilya va Eskanderia, navange kuhuma ku Kilikia nhi Asia. Avanhu ava vajovaniagha nhu Stefano. ");
INSERT INTO wbi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Lol navalyakaguile kughelana nhuvwakyiang'ani nhu Mhepo juno Stefano Juno akavombelagha kusino ajovagha. ");
INSERT INTO wbi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kange alyavavulile avanhu vamo kisyiefu kuti, “Tumpulike u Stefano ijova amasio agha kum'beda u Musa nhu Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Vakavumilisia avanhu, avagholo, na valembi, KangeKange na pikumulutila u Stefano, vakan'kola, no pikun'twala pavulongolo pavuhighi. ");
INSERT INTO wbi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Vakavakola avolesi avavudesi, vanovakajova, “Umunhu uju naibuhila kujova amasio amavivi mukighavo iki ikiimike nhi ndaghilo. ");
INSERT INTO wbi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Loli tupulike ijova iti uYesu uju ughwa Nazareti ukupanangania apa tuliipuo na kuhambusia inyio silo tulyapulyapelilue nhu Must.” ");
INSERT INTO wbi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Umunhu ghwani juno alyale muvuhighi, akalungamika amaso gha mwene kukumulola u Stefano, avene vakavuagha uvueni uvwamwene vuno vuliale hwene vwenvwen vwa nyamola. ");
INSERT INTO wbi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Untekesi umbaha akajova, “sinomuvomba isi sakyang'ani?” U Stefano akajova, vanyalukoo numue va Nata vango, mumulikisighe uneune: ");
INSERT INTO wbi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","U NguluveNguluve uwalwimiko aliya muhumile uNata ghwitu Abrahamu unsinki ghuno alyiale ku Mesopotamia, ye naikalile ku Harani,' ");
INSERT INTO wbi_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","akambula, vukugha mu iisi Jakob navanyalukolo vako ulutaghe mu iisi jino kumwa nikukusona'. ");
INSERT INTO wbi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pe akabuka mu iisi ija Ukaldayo akikala ku Harani, kuhuma apuo ye afyuila u Nata ghwa muenhe, uNguluve akamuleta mu iisi iji, jino vikukala lino. ");
INSERT INTO wbi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nalyampelile name kimonga ikya vuhosi vwamwene, napwalia nambe jumonga apa kubiika ulughulu. Loli u Abraham alyafingilue ye akyiale nambe kuhola umuana ulwakuva ipelua iisi jive vutema vwa mwenhe na vanha va muenhe. ");
INSERT INTO wbi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","U Nguluve alyajovile naghuope ndiki, ulwakuti avanha va mwenhe valikala mu iisi ija vuhesia, ulwakuti avanya iisi jila vikuvavikagha kuva vakami vavanave na kuvavomba fivi munsiki ughwa make filundu finhe. ");
INSERT INTO wbi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Naju Nguluve akajova, nilikuvahighagha ikisina kino kivavikile vagalulua, pano sikilile isio apuo pe vilihumagha na pikufunya kuliune mu iisi iji.' ");
INSERT INTO wbi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Akam'pela u Abrahamu ulufingo ulwa kukeghetua, apuo u Abrahamu akava vise ghwa Isaka akakegheta ikighono ikya lekela kuoni; U Isaka akava vise ghwa Yakobo, nhu Yakobo akava vise ghwa visukulu vitu kijigho na vavili. ");
INSERT INTO wbi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Avisukulu vitu vakam'bonela igila uYusufu vakamughusia mu iisi ija Misiri, na ju Nguluve alyale palikimo nhumwene, ");
INSERT INTO wbi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kange akamwavula mu mumuko sa Vene, akmpela ulunyamasio nhu vufwihu pavolongolo pa Farao Ntuwa u ghwa Misiri. U Farao akombuike kuva n'temi mu Misiri na munyumba ijamuene joni. ");
INSERT INTO wbi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Lol pejiliale injala imbaha kiongo nhi mumuk inyinga mu iisi ja Misiri namu Kanani nava Nhata viitu vakapatile ifyakulia. ");
INSERT INTO wbi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Loli u Yakobo ye apulike kuti kwekile ikyakulia ku Misiri alyavomuile avaNhata. ");
INSERT INTO wbi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ye vaghendile uYusufu akihufiagha kuvanyalukolo va mwene, ulukolo ulwa Yusufu lukakagula kwa Farao. ");
INSERT INTO wbi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","U Yusufu akavomola avanyalukolo va mwene kuluta kukum'bula u Yakobo nhu vise ghuvanave ise ku Misir, palikimo navanyalukolo vamwene, palikimo na vanhu voni valyale ifijigho n'dekela lubale navahano. ");
INSERT INTO wbi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Loli uYakobo akika kuMisiri pe akafua umwene palikimo nava Nhata viitu. ");
INSERT INTO wbi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Vakatolua vakaluka ku Shekemu vakasyilula mu mbipa jino uAbrahamu valyaghulile ni ndalama kuhuma kuvanha vaHamari kuula ku Shekemu. ");
INSERT INTO wbi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Amasiki agha lufingo Lula ghano Unguluve alyafingine nhu Abrahamu ye ghulipipi, avanhu pano vakava vongelile ku Misri. ");
INSERT INTO wbi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Unsiki ughuo alyatemile ujunge uNtuwa Misri, uNtuwa Juno alyankaguile u Yusufu. ");
INSERT INTO wbi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","u Ntua ujunge ujuo akavadengania avanhu vitu name vavombi ava Nhata vitu, no kuvatagha avana vavanave avafyiele kuti valeke kukukala. ");
INSERT INTO wbi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Unsiki ghulaghula uMusa akaholuagha; alyilealyile nofu pavulongolo pa Nguluve, akalelua mesi ghatatu munyumba ija vise. ");
INSERT INTO wbi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Unsiki ghuno alyataghilue, umwalive Farao alyatolilue akamulela huene mwanake. ");
INSERT INTO wbi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","U Musa alyavulanisivue imanyilo soni isa Misri; alyale nikufu kumasio na kumbombele. ");
INSERT INTO wbi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Loli yekwaline amaka fijigho fine' lukamwisila munumbula jamwene kuvaghendela vanyalukolo vake, Alana ava Israeli. ");
INSERT INTO wbi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ye amwaghile umu Israeli ivombelua fiivi, uMusauMusa akan'tanga name kuvangulila akalumbila kwa juno alyam'bonile akantova umMisiri. ");
INSERT INTO wbi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Akisaghilagha kuti vanyalukolo va mwene vikagula kuti u Nguluve ikuvavula mu luvoko ulwa mwene, loli navalyalumanyile. ");
INSERT INTO wbi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ikighono kino kikafingile akaluta kuvamo va Israeli valyale vilua, akaghela kuvasambania; akatisagha, mwevatua, umue mulilukolo; kiiki mupungana jumuejumue kwa jumue? ");
INSERT INTO wbi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Loli juno alyamokiile um'bading'ani ghwa mwene akavadighulilagha kuvutali, na akajova, 'Ghweveni juno akuvikile piva ntemi kange piva meghi ghwitu? ");
INSERT INTO wbi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Uve ghuloda pikum'buda, ndavule WA mbuda umuMisri Pammie?” ");
INSERT INTO wbi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","U Musa akakimbila ye asipulike isio; akava mesia mu iisi ja Midiani, apuo pe akava vise ghwa vanha vavili. ");
INSERT INTO wbi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ye ghakilile amaka ifijigho fine, unyamola akamuumila mulukuve lwa kidunda ikya Sinai, mululapi ulwa mwoto munkate mukianji. ");
INSERT INTO wbi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Unsiki ghuno u Musa alyaghuvuene umuoto, alyadeghagha na pikudegha kiongo kind alyakivuene, panopano akaghelagha kuti akiveleleele ulwakuti akilole, ilisio lya Mutwa likamwisila likati, ");
INSERT INTO wbi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Une nili Nguluve wava NhataNhata vako, Nguluve ughwa Abrahamu, nhu Isaka, nhu Yakobo; uMusa alyatetime nakaghela nambe kulola. ");
INSERT INTO wbi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","U Mutwa akam'bula, full ifilato fyiako, apuo pano ghwimile pimike. ");
INSERT INTO wbi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nisaghile imumuko sa vanhu vango vino vali ku Misri, nipulike kutamua kuvanave, unenikile ulwakuti nivavule; lino isagha, nekwomola uve ku Misri.' ");
INSERT INTO wbi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","U Musa uju Juno valya n'kanile, unsiki ghono valyajovile, 'ghweveni juno akakuvombile piva n'temi kange mulamusi ghuitu?' _alyale ghwe Nguluve Juno alyamwomwile ave n'temi kange m'poki. U Nguluve alyamwomwile muluvoko lwa vanyamola Juno aliya muhumile uMusa mukihanji. ");
INSERT INTO wbi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","U Musa alyavalongwisie kuhuma ku Misri ye akiiale kuvomba ifidegho ni kidegho mu Misri name mulusumba ilya Shamu, na mulukuvi mu nsiki ughwa maka fijigho fine. ");
INSERT INTO wbi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ghwe Musa uju juno alyavavulile avanhu va mu Israeli kuva, uNguluve ilikumwimia um'bili kuhuma mu lyumue muvanyalukolo vinhu, um'bili ndavule unhe'. ");
INSERT INTO wbi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Uju ghwe munhu juno alyale mukipugha kya lukuvi nhu nyamola juno alyajovile nhu mwene mukidunda ikya Sinai. Uju ghwe munhu Juno alyale nava Nhata vitu, uju ghwe munhu alyupile ilisio linolilyale nhu vumi na kutupela usue. ");
INSERT INTO wbi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Uju ghwe munhu juno ava Nhata vitu valyankanile kukumuleva, valyantaghile kuvutali, na munumbula sivanave sino silyagevukile ku Misri. ");
INSERT INTO wbi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Munsiki ughuo valyam'bulile u Haruni.' ututendele amatekelo ghano ghikutu longosia. U Must ujuo, juno alyale ikutulongosia kuhuma mu iisi ja muMisri, natukagula kinokimwaghile.' ");
INSERT INTO wbi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ApuoApuo pevakatenda indama kufighono ifio pe vakahumiagha ilitekelo kukihwani ikio pe vakahovokagha ulwakuva vavombile imbombo sa mavoko gha vanave. ");
INSERT INTO wbi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Loli uNguluve alyavahambusie na pikuvapela vino vikufunya kunondue isakukyanya, ndavule lilyalembilue mikitabu kya vaviili, 'vuli munyumikisie une amatekelo agha fidimuafidimua finofino mulyabudile ku lukuve ku nsiiki ughwa maka fijigho fine, munyumba ja Israeli? ");
INSERT INTO wbi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwitike ihema ijakukong'ania ija Moleki ni nondue ija Nguluve u refani, nakikihuani kino mukatendile na pikufunya kuveene: pe nikavatwalagha kuvutali kukila kubabeli.' ");
INSERT INTO wbi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ava Nhata vitu valyale nihema ija kukong'anile ija vwolesi kulukuve, ndavule u Nguluve alyavalaghile pano alyajovile nhu Musa, kuuti ngale alyatendile mu kihwani kino alyakyaghile. ");
INSERT INTO wbi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Iji je hema jino avaNhata viitu, munsiki ghwave, valyatwalile mu iisi nhu Joshua. Isi silyahumile amasiki ghanovalingile kutema ikisiina kino uNguluve alyavadughile ava nhata viitu yevakyale kuviikua. uluo lulyale ndiki m'paka kufikila mufighono fya Daudi, ");
INSERT INTO wbi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","juno alitikisivue nhunhu Nguluve pa Mason ghake, pe akasuma kulonda uvukalo Kwan Nguluve ughwa Yakobo. ");
INSERT INTO wbi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Loli uSelemani alyanjengile inyumba ja Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Loli umwene juno alyale kukyanya na ikukala munyumba sino sijengilue na mavoko; ulu lulindavule up'biili alyajovile. ");
INSERT INTO wbi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Uvulanga kye kitengo kyango ikya vuTua, iisi je jakuvika amaghulu ghango. Jiva nyumba je jilindani mukunjengela?, u Mutwa ijova: nakuva kwekughi kulyune ukwakupumila? ");
INSERT INTO wbi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na lweluvoko lwango lunoluvombile ifi fioni?' ");
INSERT INTO wbi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Umwe mwe vnhu mwe vanya sing inyuumu mwe vano namudumulivue inhumbula ni nimbung'ulutu, January mukunkana uMhepo Mwimiike,' muvomba ndavule ava nhata vunhu valyavombile. ");
INSERT INTO wbi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","M'biili veni muva viili juno avanhata viinu navalyampumwisie? Valyavabudile avaviili vanovalyavahumile yeye akyale pikuisa jumo unyavwakyang'ani,' nalinolino mulivahindami kange mulivabudi vamweene, ");
INSERT INTO wbi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","umuewe vanhu mwevano mukupile indaghilo sila sino silyaghuile nhumunyamola loli namukajikola.” ");
INSERT INTO wbi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Loli avatua va pa vuhighighi ye vapulike amasio agha inhumbula sivsnave silya vavile kyiongo, vaka gwenulila amino u Stefano. ");
INSERT INTO wbi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Loli umwene, ye amalile uMhepo uMwimike, akalola vunono kukyanya akavwagha uvwimike vwa Nguluve,' napikumbona u Yesu imile kuluvoko ulwa kundio ulwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","U Stefano akajova, “Lolagha nivwaghile uvulanga vudindwike, najumwana wa Adam imile uluvoko lwa kundio ulwa Nguluve.” ");
INSERT INTO wbi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Loli avahighi va vahighi vakovela kyongo ni lisio ilikome, vakadinda imbughulutu sivanave, vakankimbiliila palikimo. ");
INSERT INTO wbi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Vakantagha kunjikunji kulikaja pe vakadijavakadija na mavue: navavolesi va kafula ameanda gha vanave aghakunji nakuvikapasi pipi na maghulu agha nsoleka juno akatambuluagha Sauli. ");
INSERT INTO wbi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pano valyale vikun'tova u Sitefano namavue, pe akaghendelela pikunkemela uMutwa akajova, “Mutwa Yesu, upila inhumbula jango,”. ");
INSERT INTO wbi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akafughama namafundo akakemela nilisiio ilivaha, “Mutwa nhungavavalililaghe uvuhosi uvu.” Ye ajovile isio akafwisagha. ");
INSERT INTO wbi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","U Sauli alyale pa lwiting'ano nhuvufue vwa mwene. Ikighono ikio pe akatengula kukuvapumusia kupungilanila mulukong'ano luno lulyale ku Yerusalemu; na viitiki vooni valyapalasine mu iisi Jack Yudea nhi Samaria, valyasighile viva sung'ua. ");
INSERT INTO wbi_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Avanhu vano vakamwitike uNguluve vakansyilagha uStefano na kuvika ifua imbaha kwamwene. ");
INSERT INTO wbi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Loli u Sauli alyananginie ulukong'ano. Akalutagha nyumba kwa nyumba napikuvakwesela kunji avamama nava ghosi, napikuvavika mundinde. ");
INSERT INTO wbi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Avwitiki vino vakapalasine vakajigha vidalikila iliisio. ");
INSERT INTO wbi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","U Filipo Akiva mulikaaja lya Samaria pepe Adam'pulisyiagha u kilisite u kuo. ");
INSERT INTO wbi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Amapuga yeghapulike nakulola ifidegho fiino alyavombile u Filipo; vakavika vunono kukila kind alyajovile. ");
INSERT INTO wbi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kuhuma apuo avanhu vino valyapulike, Mhepe indamafu sikavahuma avanhu kumonga vilila ni lisio ilivaaha, aviinga vino valyakokonyile naava fivwale vakavuvuka. ");
INSERT INTO wbi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Lulyale lukkelo lukome mulikaja. ");
INSERT INTO wbi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lol pe alyale umunhu jumonga n'kate mulikaja Lila mulitavua lya mwene Simon, juno alyale ivomba uvuhavi; vunho alyavombile Kati avanhu vadeghe mukisina ikya Samaria, pano akatisagha umwene munhu kyongo. ");
INSERT INTO wbi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ava Samaria vooni kutengulila un'debe naju ngoyo, akampulikisyiagha; vakatisagha; “Umunhu uju se iila iingufu sa Nguluve sino se mbaha.” ");
INSERT INTO wbi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vakampulikisyagha, ulwakuva avapelile kudegha unsiki n'tali ku vuhavi vwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Loli unsiki ye vitike kuva Filipo akadalike ulwa vutua vwa Nguluve nulwa litavua lya Yesu kilisite, vakofughua, avaghosi nava dala. ");
INSERT INTO wbi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na ju Simon jujuo alitike: ye ofughue akaghendelela piva nhu Filipo; ye afivuene ifidegho ni fyakudegha fino fikavombekagha akadegha. ");
INSERT INTO wbi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Amasiki avasung'ua ava Yerusalemu ye vapulike kuti iSamaria jupile ilisio lya Nguluve, vakavomola u Petrol nhu Yohana. ");
INSERT INTO wbi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Unsiki ghuno vakale vikwika vakavafunyilagha; kuti vamwupileuMhepo Mwimike. ");
INSERT INTO wbi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kufikila unsiki ughuo, uMhepo uMwimike alyakyale kuvikila nambe jumbo muvene; valyofughue vuvule mulitavua lyalya Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pe uPetro nhu Yohana vakavavikila amavoko, vote vakamwupila uMhepo uMwimike. ");
INSERT INTO wbi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Unsiki u Simoni ye alolile kuti uMhepo Mwimike ahumisivue kukulila kuvikivua amavoko na vasung'ua; akalonda kuvapela indalama, ");
INSERT INTO wbi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Akati, “mumele ingufu, ili kila juno nikum'bikila amavoko upilaghe uMhepo Mwimike.” ");
INSERT INTO wbi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lol uPetro akam'bula; indalama jako palikimo najove jisoviile kuvutali, ulwakuva uve ghwiti ikipelua kya Nguluve kiivonekele nhi ndalama. ");
INSERT INTO wbi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Usila lumonga mu isi, lwakuva umwojo ghako naghugholuike pavulongolo pa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pa uluo latagha uvuhosi vwako na pikunsuma uNguluve ndighane ghusaghilwagha amasaghe gha mwojo ghuako. ");
INSERT INTO wbi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ulwakuva nikukwagha uli musumu ija vuvafi nhuvukuungua vwa vuhosi.” ");
INSERT INTO wbi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","U Simon akamula akati, “Munsume uMutwa vwimila une, ulwakuva ghoni ghano mujovile ghakaguile kukunihimila. ");
INSERT INTO wbi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Unsiki u Petro nhu Yohana pano valyolelilevalyolelile napidalikila ilisiio lya Mutwa vakagomoka ku Yerusalemu musils jila; vakadalikila ilivangili mu fikaja finga ifya Samaria. ");
INSERT INTO wbi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pe unyamola ghwa Mutwa akajovagha nhu Filipo akatisagha, “Mulika lutagha kumavemba musila jino jighenda pasi pa Yerusalemu kulungama ku Gave.' (Isiila iji jili mulukuve). ");
INSERT INTO wbi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Akamulika nakuluta. Lolagha, kwe alyele umunhu gha mu Ethiopia, ungalule unyavutavulilua uvuvaha pasi pa kandesa; untua umama ghwa Ethiopia. Alyavikilue kulolela indalama sake soon; ghuope alyalutile ku Yerusalemu kukufunya. ");
INSERT INTO wbi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Alyale ivuja ikalile mugale jamwene ikwimba ikitabu kya M'bili Isaya. ");
INSERT INTO wbi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","U Mhepo akajova nhu Filipo, “usoghelele pa vupipi nhi gare iji uvepalikimo naliope. ");
INSERT INTO wbi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","“Apuo uFilipo u Filipo pe akaluta luvilo, Adam'pulika pano ikwimba mu kitabu kya m'bili Isaya; akati, ukaguile kino ghukwimba?” ");
INSERT INTO wbi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Umu Ethiopia akati, nikagula ndani pano umunhu na ikundongosia?” Akam'pelepesia uFilipo atoghe mhu gale na pikukala palikimo nhu mwene. ");
INSERT INTO wbi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lino ikighelo kya vulembe kind akimbaa Muethiopia kye iiki; valyamulongwisie huene no'olo kuluta kulihinjilo ku hinjua; Kane ndavule ing'olo jino jilyajikile Kimmie, najilyadindilue nambe mulomo ghwa jene: ");
INSERT INTO wbi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pa lusukunalo lwa mwene uluhighilo lwa mwene lulyavusivue: Veni Juno ikwolelela ikipelela kya mwene? uvukalo vwa mwene vuvusivue mhu iisi.” ");
INSERT INTO wbi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Pe ugalule akamposia uFilipo, akati, “nikukusuma, ghwe M'bili aliiku juno ijovua imola isamwene, jilungime Kwan mwene, nambe kwa judge”? ");
INSERT INTO wbi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","U Filipino akatengula kujova, alyatengulile muvulembe uvu vwa Isaya pidalikila imola isa Yes. ");
INSERT INTO wbi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ye valimusila, vakafika palulenga,' ugalule akati, “Pweghale amalenga apart kicking kind kisigha nileke kukwofughua?, ");
INSERT INTO wbi_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","amasio agha, “mhu uluo Muethiiopia akamula “Nikwitika kuti uYesu kilisite mwana ghwa Nguluve,” namweghale mumalembe gha katali). Pe u Muethiopia akajimiagha igale jime. ");
INSERT INTO wbi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Vakaluta munkat mumalenga, palikimo u Filipo nhu ngalule ufilipo akamwofugha. ");
INSERT INTO wbi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Unsiki ye vahumile mu malenga, uMhepo ghwa Mutwa akatwala u Filipo kuvutali; ungalule nalya mbwene kange, akalutagha musila jake akeliile. ");
INSERT INTO wbi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Loli u Filipo alyahumiile ku Azoto. Alyakilile mhu iisi jila name kudalikila ilivangili mhu makaja ghoni m'paka yeafikile ku Kaisaria. ");
INSERT INTO wbi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Loli u Sauli, alyaghendelile ujova isakwoghofia kuhulila kuluta kuva vulanisivuavulanisivua ava Mutua, alyalutile kwa ntekesi umbaha ");
INSERT INTO wbi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nakusuma ikalata vwimila vwa nyumba sa kufunyila kuula ku Dameski, ulwakuti angam'bone umunhu juno alimusila jila, ave mughosi nambe mumama, avaungaghe nakuvatwala ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pano alyale ichula, alyahumile kuuti ye alipipi ku Dameski, nakalingi ulumuli lukamumulikila imbale soni ulumuli kuhuma ku kyanya,' ");
INSERT INTO wbi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ghuope akaghua pe akapulika ilisio likum'bala, “Sauli, Sauli, kiiki ghuumumusia une?” ");
INSERT INTO wbi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","U Sauli akamula, veve Veni uve Mutwa? uMutwa akati, une nene Yesu nejuno ghuku ng'alasia; ");
INSERT INTO wbi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Loli imagha, ingila mulikaja, najuve ghuvuluagha sino siunoghile uvomba ");
INSERT INTO wbi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","avanhu vala vino valya kyulile palikimo nunu Sauli vakanyamala Kimie, vakapulika ilisio navaamwagha umunhu. ");
INSERT INTO wbi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","U Sauli akima pa iisi akati adindwile amaso gha mwene, nalyakivwene kinu, vakankola uluvoko vakantwala kufika ku Dameski. ");
INSERT INTO wbi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ifighono fitatu naalolagha, nakalisagha, nambe kunyua. ");
INSERT INTO wbi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kange palyale um'bulanisivua ku Dameski ilitavua lyamwene Anania, uMutwa alyajovile nu mwene mu mbonekelo, “Anania.” Pe akajova, “Lolagha nilibahapa, Mutwa. ");
INSERT INTO wbi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“U Mutwa akam'bula, Ghuime ulutaghe kulyuve mumpulo ghuno ghutambulivua Nyofu, na munyumba ija Yuda kange kwe ukamposie umunhu junoo ihuma Tarso juno itambulivua Saudi; ulwakuva ajighe ikufunya; ");
INSERT INTO wbi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","pe alya mbwene mu mbonekelo umunhu ilitavua lyamwene Anania ikwingila na pikumb'ikila amavoko pakyanya pa mwene ulwakuti alolaghe. ");
INSERT INTO wbi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Loli u Anania akamula, “Mutwa, nipulie imola isa munhu uju kuvanhu vinga, nasivalilika imbivi sino avombile avimike avaku Yerusalemu; ");
INSERT INTO wbi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Apa alinuvulavulilua kuhuma kwa ntekesi um'baha kukunkola umunhu ghweni juno ikulitambula ilitavua lyako. ");
INSERT INTO wbi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Loli umunhu akam'bula, “lutagha, ulwakuva umwene alikisalulua kulyune, atolaghe ilitavua ilyango kuvulongolo ku fisina na vutua na vanha va Israeli. ");
INSERT INTO wbi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ulwakuva nikuvasona ndavule silinyinga sino sinoghile kupumuka vwimila vwa litavua lyango”. ");
INSERT INTO wbi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","U Anania akaluta, akingila munyumba; Akam'bikila amavoko, Sauli nyalukolo, Mutwa Yesu, juno alyakuhumile musila pano ulyale ghukwisa, anyomuile kuuti ulolaghe kange neke umemesevue u Mhepo Mwimike. ");
INSERT INTO wbi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nakalingi fikawisagha ifinu pamaso gha mwene fihene filaghalila, pe akalolagha, akima, akofughua, akalia ikwakulia akapata ingufu. ");
INSERT INTO wbi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Akipakala palikimo na vavulanisivua ukuo ku Dameski mufighono finga. ");
INSERT INTO wbi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Unsiki ghughuo akampulisia u Yesu munyumba isaufunyila, akatisagha ndiki umwene mwana wa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","VoniVoni vano vakapulike vakadeghagha na kujova, “Naghe munhu jujujuo juno akavananginie voni vano valitambulagha ilitavua ukuo ku Yerusalemu? Na bahapa akisile afumbilue na kukuvaunga na pikuvatwala ku vatekesi.” ");
INSERT INTO wbi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Loli u Sauli alyatangilue kudalikila na kuvavomba ava Yahudi vano vakikalagha ku Dameski vahasing'ane nakusimilisia Kati uju ghwe kilisite. ");
INSERT INTO wbi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ye fikilile ifighono finga, ava Yahudi vakapinya palikimo lwakuuti vambude. ");
INSERT INTO wbi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Loli kino valyapinyile kilya pavugholofu pa Sauli. Vakamwuvila pamulyango pamwisi na pakilo ulwakuti vam'bude. ");
INSERT INTO wbi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Loli avavulanisivua vamwene vakantola pakilo kuilila muluvumba, vakamwisia pasi mu ndilo. ");
INSERT INTO wbi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","U Sauli ye afikile ku Yerusalemu, akalondagha uhasing'ana nava vulanisivua loliloli valyale vikumwoghopa, na vitikagha ghwope kuti m'bulanisivua. ");
INSERT INTO wbi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Loli u Barnaba ankantolagha na kukuntwala kuvasung'wa, kange akam'bula u Sauli vulealyambwene u Mutwa musilau Mutwa vule alyajovilealyajovile nu mwene, ndavule u Sauli vule alyadalikile nu vuangafu kulitavua ilya Yesu ukuo ku Dameski. ");
INSERT INTO wbi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Alyatang'ine navene yavikwingila nakuhuma ku Yerusalemu. Pe akajova nuvukankafu kulitavua lya Mutwa Yesu, ");
INSERT INTO wbi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","akaposaniagha Navarro Yahudi ava kiYunani loli nakinga vakaghela kukum'buda. ");
INSERT INTO wbi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Unsiki avanyalukolo ye vaagwile imbombo ijio, vakantola kukilila Kaisaria, kange vaantwala alute ku Tarso. ");
INSERT INTO wbi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kange inyumba ijakufunyila joni muYahudi, Galilaya ni Samaria, jikale nu lutengano, kange jikajengilue, na kughendela muvwoghofi vwa Mutwa nu lutengano ulwa Mhepo Mwimike, inyumba ija kufunyila jiale mbaha na kikipugha kikongelela. ");
INSERT INTO wbi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pope lulyahumile u Petro ye isyutasyuta imbale soni isakisina, akavikila avimike Venezuela vikukala mulikaja ilya Lida. ");
INSERT INTO wbi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Alyambwene ukuo umunhu jono ilitavua lyamwene Anania, umunhu ujuo kale mukitala amaa lekela kwoni; Kane akokonyile. ");
INSERT INTO wbi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","U Petro akam'bula, “Ainea, u Yesu kilisite akuvuvusie; Sisimuka kange utandike ikitala kyako,” ");
INSERT INTO wbi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kange avanhu voni vanovakale vikukala u Lida naku Sharon ye vambwene umunhu ujuo, vaansyentukila uMutwa. ");
INSERT INTO wbi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pe valyale avavulanisivua u Yafa juno itambulua Tabitha, linolikaghanulivue “Dorcas” Umama uju akamemile imbombo inofu ni mbombo ija lusungu ghano alyavombile kuvapina. ");
INSERT INTO wbi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jilyahumile mufighono ifio akatamua napifua; ye vansukile, vakantosia kukyumba ikya kukyanya na kukumughonia. ");
INSERT INTO wbi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ulwakuva i Lida jilyale pipi ni Yafa, na vavulanisivua valya pulike kuti u Petro alyale ukuo, valyavomuile avanhu vavili kwakwa mwene, vakambula, “Isagha kulyusue kange nu ladilagha”. ");
INSERT INTO wbi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","U Petro aasisimuka nakuvuka navene. Yafike, vakantwala ku kyumba kya kukyanya. Kange avafwila vooni vakima pipi nu mwene vakakolagha, valyansonile ilikoti na menda ghano u Dorcas alyavahonile unsiki ghuno alyale palikimo na vene. ");
INSERT INTO wbi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","U Petro akavahumila vooni kunji ku kyumba, akafughama akifunya, kange akaghusyetukkila umbili, akati, “Tabitha, sisimuka”. Akadindula amaso gha mwene ye amwaghile u Petro akikala pasi. ");
INSERT INTO wbi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kange akampela uluvoko lwa mwene akampinda, ye avakemelile avitiki nava fwile, akavapela kuvanave ye alimwumi. ");
INSERT INTO wbi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Imbombo iji jikakagulike mu Yafa joni, kange avanhu vinga vakamitika u Mutwa. ");
INSERT INTO wbi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jilyahumile u Petro akikala ifighono finga ku Yafa palikimo nu muunhu juno atambulivuagha Simoni, juno itenda inguvu. ");
INSERT INTO wbi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kwalyale umunhu jumonga muliaja ilya kaisaria, ilitavua lya mwene atambuluughwa Kornelio, alyale mbaha ghwa ipugha ikya va Kiitalia. ");
INSERT INTO wbi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Alyale ikufunya kange alyale ikunsuma uNguluve mu nyumba ja mwene joni, alyahumisie indalama nyinga kuva Yahudi pe akale ikufunya kwa Nguluve ifighono fioni. ");
INSERT INTO wbi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Unsiki ghwa lisala lya gubia lubale pamwisi, akasaghile inyisaghilo isa vanyamola va Nguluve vikwisa kwa mwene unya mola akambula u “Kornelio! ");
INSERT INTO wbi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","U kornelio akamulola unyamola kange alyale nu ludwesi uluvaha kyongo akati “Ulu lwa Luke mbaha?” unyamola aka m'bula “Inyifunyo sako nu luvonolo lwako kuva kotofu sitoghile kukyanya ndavule ing'humbukilo. ");
INSERT INTO wbi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Lino vomole avanhu valute mulikaja ilya Yafakuuntwala umunhu jumo juno itambulua Simon juno itambulua Petro. ");
INSERT INTO wbi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ikukala nujuno itenda inguvu juno itambulua Simoni juno inyumba jamwene jili palubade pa misumbi.” ");
INSERT INTO wbi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ye akyale unyamola juno alyale ijova nu mwene kuvuka, u Kornelio akavakemela avavomba mbombo munyumba ja mwene vavili, nu ns'sikali juno alyale ikunsuma u Nguluve pakate pava sikalisi vano valyale vikum'bombela imbombo. ");
INSERT INTO wbi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","U Kornelio alyavavulile ghoni ghanoghalyahumile kange akavomola ku Yafa. ");
INSERT INTO wbi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ikighono kino kikafwatile unsiki ughwa lekela lubale valyale musila kange vakale pipi mu likaja, u Petro akatogha kukyanya ku dari na kukufunya. ");
INSERT INTO wbi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pe akale ni njala neke alyale ilonda ikinu ikyakulia, Looli unsiki ghuno avanhu viteleka ikyakulia, akavonesevua inyisaghilo, ");
INSERT INTO wbi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","akavuvwene uvulanga vudindwike ni kyombo kikwika ni kinu kinge ndavule amenda amakome ghikwika pasi palihanga mumbale isamwene soni iine. ");
INSERT INTO wbi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Munkate mwa mwene mulyale ni fikano fyoni ifinyamaghulu ghane nafino fikwafula palihanga, ni fijuni ifyavulanga. ");
INSERT INTO wbi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pe ilisio likati wa mwene “sisimuka, PetroPetro hinja kange ulie”. Loli upero akati “Na lulianala, MUtwa ulwakuva ");
INSERT INTO wbi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","nanighelile kulia ikinu kyekyoni I'll ikivivi. Loli ilisio likisa kwa kwamwene kange ");
INSERT INTO wbi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ulwavuvili “Kino avalisie u Nguluve nungakiemelaghe vulamafu kange kivivi”. ");
INSERT INTO wbi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ulu lulyahumile katatu, ni kyombo kila ilyatolilue kuvulanga kange. ");
INSERT INTO wbi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Unsiki ghuno u Petro alyahasing'ine vwimila vwa mbonekelo isio sihufia kiki, lolagha, avanhu vano vakomolilwe nu Kornelio vakima pavulongolo palilyango, vakaposiagha isila ijakuluta kunyumba. ");
INSERT INTO wbi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Pe vakakemela nauposia ndavule u Simoni juno kange atambulwagha Petro ndavule kale ikukala Pala. ");
INSERT INTO wbi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Unsiki ughuo ghuno u Petro alyale isagha munyisaghilo isio, uMhepo akajova nu mwene “Lolagha avanhu vatatu vikukulonda. ");
INSERT INTO wbi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Sisimuka kange ghukale pasi pe ulutaghe navene. Nungoghopaghe kuluta navene, ulwakuva nivomwile.” ");
INSERT INTO wbi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","U Petro Akiva pasi kuvanave nakujova “Une nenenejuno mukunilonda. Nakii mwisile?” ");
INSERT INTO wbi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Vakati, “Akida jumo ilitavua lya mwene Kornelio, umunhu ughwa vugholofu pe ilonda kukusuma u Nguluve, kange avanhu viujova vunofu mukisina kyoni iya kiyahudi, avulilue nava nyamola avaava Nguluve kukuvomola need valute kunyumba ja mwene, neke apulike imola inofu kuhuma kuvanave.” ");
INSERT INTO wbi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","U Petro akavambilila vingile nkate napiukala palikimo nu mwene. Ilwakilavo jino jilyavingilile akasimuka akaluta palikimo nu mwene, na vanyalukolo vadebe kuhuma ku Yafa vakavingisaniagha naghwope. ");
INSERT INTO wbi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ikighono kino kikavingilile vakisile ku Kaisaria. Naju Kornelio alyale iuvaghulila; kange akavakemelile paliimo avanyalukolo vamwene nava manyani vamwene vano valipipi. ");
INSERT INTO wbi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Unsiki ghuno u Petro akingila munkate, u Kornelio akamwambilila akafughama paasi pamaghulu gha mwene akamfughamila. ");
INSERT INTO wbi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Loli u Petro akamwamula akati “Isagha; une najune nelimunhu.” ");
INSERT INTO wbi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Unsiki ghuno u Petro akajovagha naghuope, akalutagha n'kate akavagha avanhu vakong'anile palikimo. ");
INSERT INTO wbi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Akavavula, “jumue mwevano mukagwile kuti ulu nalulaghilo lwa Kiyahudi kuhasing'ana nambe kughendelanilakughendelanila nu munhu ugwa kipelela iiki. Loli u Nguluve ansonile uneasy ulwakuti naninoghile kukunemela umunhu ghweni vulamafu nambe vunyali. ");
INSERT INTO wbi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Fyenambe nisile isila kikanika, pano nikomolilue vwimila vwa uluo. Neke nivaposie nakiki mukomolivue vwimila unhealthy.” ");
INSERT INTO wbi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","U Kornelio akati, “Ifighono fine fino fikakilile, amasiki ndavule agha nilyale nikufunya unsii ghwa kivalilo kya budika lubale pamwisi munkate munyumba jango; Nikalola pavulongolo palyune umunhu imile alyale namenda amavalafu, ");
INSERT INTO wbi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akambulile “Kornelio inyifunyo sako sipulikike Kwan Nguluve, ni mbonolo sako kuva n'kontofu silikikumbukilo pavulongolo pa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pa uluo omola umunhu ku Yafa akankemele umunhu jumbo juno ikemelua Simon ise kulyuve, juno kange itambulivua Petro. Juno ikukala kwajuno inosia ingwembe jumojumo juno itambulivua Simoni juno inyumba jamwene jilimulubale munyanja. ");
INSERT INTO wbi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Gadilila: Ikidebe iki, “Ghwope iliva ikwisa ilijova numue,” namwale muvulembe vwa pakale. ");
INSERT INTO wbi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pe u Petro aadindula umulomo ghwa mwene nakujova; “kyang'ani, nitika kuti u Nguluve nalinalo ulwa kuvaghana vamo. ");
INSERT INTO wbi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pauluo kila kisina umunhu ghweni junoikufunya nakuvomba isavwakyang'ani ikwitisivua kwamwene. ");
INSERT INTO wbi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ujimanyile imola jino akajihumisie ku vanhu va Israeli, pano akapulisiagha imola inofu ija lutengano kukilila u Yesu kilisite juno ghwe Mutwa ghwa vooni- ");
INSERT INTO wbi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","jumue mwevano mukagwile kind kikahumila, lino likahumile ku Yudea joni likatengulile ku Galilaya, ye lukilile ulwofugho luno u Yohana alupulisiagha. Lino likahumile likan'donyile u Yesu kilisite ndavule uNguluve alyam'ponisie amafuta nuMhepo Mwimike na kungufu. ");
INSERT INTO wbi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Alyaghendile nakuvomba inofuinofu nakuvuvusia voni vano vakapumusivue nu Stefano, ulyakuva uNguluve alyale paliimo nu mwene. ");
INSERT INTO wbi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Usue tulivolesi ghwa ghoni agha ghano akaghavombile mu iisi sasa vuYahudivuYahudi namu Yerusalemu- uju ghwe Yesu juno valyam'budile na kukum'paghika mumpiki. ");
INSERT INTO wbi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Umunhu ujuo u Nguluve aliyah nsyusisie ikighono ikya vutatu na kukum'pala kumanyikika, ");
INSERT INTO wbi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","nakwekuti ku vanhu voni, looli kuvolesi uvano vasalulivue nu Nguluve. -usue jusue, twevano tukalile tumwene na kunyua naghwope pano ye asyukile kuhuma uvufue. ");
INSERT INTO wbi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atulaghile kudalikila na kukwolelela kuuti uju ghwejuno u Nguluve alyansaluile kuva mulamuli ghwa vumi na vafue. ");
INSERT INTO wbi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mwamwene avavili voni volelaghe lulyale Kati ghweni juno ikumwitika kyang'ani ujuo ikwupilagha ulusaghilo ulwa vahosi kuhumila litavua lyamwene.” ");
INSERT INTO wbi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Unsiki ghuno u Petrol akaghendelelagha kujova isi, u Mhepo Mwimike akavamemia voni vino vakapulikisyagha imola ija mwene. ");
INSERT INTO wbi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Avanhu vala vano valyahusike ni kipugha ikya vitiki vino valyavalya dumulivue- vala voni vano valisile nu Petro vaadeghagha vwimila vwa Mhepo Mwimike juno alyakung'ilue kuoni kuva panji. ");
INSERT INTO wbi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ulwakuva valyapulike avapanji ava vijova ninjovele isinge na pikufunya kwa Nguluve. U Petro akamula, ");
INSERT INTO wbi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kwale umunhu juno anoghile kusigha amalenga ulwakuuti avanhu value kukwofughua, Avanhu ava vamwupile uMhepo Mwimike ndavule usue?” ");
INSERT INTO wbi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pe akalamula vofughue mulitavua lya Yesu kilisite. Pambele vakansuma ikale naghuope mufighono ndii. ");
INSERT INTO wbi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Avasung'ua navanyalukolo Valarie vano valyale ukuo ku Yudea valyapulike kuuti avapanji vupili ilisio ilya Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","U Petro ye isile ukuo ku Yerusalemu, ikipugha kila ikya vanhu vanovalyahinjilue vakatengula kukum'beda, vakajova, ");
INSERT INTO wbi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ukolile na vanhu vano navahinjilue nakulia naveve!” ");
INSERT INTO wbi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Looli u Petro alyatenguile kujova ikituko kind kilimunkate; akati, ");
INSERT INTO wbi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“NIlyale nikufunya mulikaja ilya Yafa, nikasaghile inyisaghilo isakyombo kikwika pasi ndavule umwenda u n'kome ghukwika kuhuma kukyanya imbaleimbale sake sooni ine. Kikika kulyune. ");
INSERT INTO wbi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nilyakilolile nakusagha pa mwene. NikafyaghilaNikafyaghila ifidimua ifinyamaghulu ghane finofikukala mu iisi, nifidimua ifya mulisoli, nifidimua fino fikwafula nifijuni ifyakuvulanga. ");
INSERT INTO wbi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","nge nilyapulike ilisio lijova nuune, “Sisimuka, Petrol, hinja ulie!” ");
INSERT INTO wbi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nikajova, “Naluliinala, Mutwa, mumulomo ghwango nakighelile kukwingila ikinu kye kyoni kill kind na kyimike nambe kivivi” ");
INSERT INTO wbi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Loli ilisio likamula kange kuhuma kukyanya, kila kino uNguluve alyapulisie kuuti kinofu, nungakikemelaghe vulamafu, ");
INSERT INTO wbi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ulululyahumile katatu, kange Kira kiinu kikatolilue kukyanya. ");
INSERT INTO wbi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lolagha, unsiki ghughuo avanhu vatatu vimile pavulongolo pa nyumba jino tuliale; vomolivue kuhuma ku Kaisaria kukwisa kulyune. ");
INSERT INTO wbi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","U Mhepo akambulile kuluta nave, nasingahwananaghe nave. Ava ghosi ntanda vakaluta palikimo nuune tukaluta munyumba jamunhu jumo. ");
INSERT INTO wbi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Alyatuvulile ndavule alya mbwene unyamola imile munkate munyumba jamwene ijova, “Unyomole ku Yafa nikantole u Simoni juno ilitavua lya mwene ilinge ghwe Petro. ");
INSERT INTO wbi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ilijova imola mulyuve mu uluo kuuti kuvanguka uve munyumba jako Joni.” ");
INSERT INTO wbi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pe alyatenguile kujova navope, u Mhepo Mwimike akisa kuvanave ndavule ye isile pa vwasio. ");
INSERT INTO wbi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nikumbuka amasio gha Mutwa ghanoalyajovile, u Yohana alyofuighe namalenga; looli mukwofughua nu Mhepo u Mwimike.” ");
INSERT INTO wbi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ndavule u Nguluve ahumisie uluvonolo ndavule silo alyatupelile usue panoramic tulitike kwa Mutwa Yesu kilisite, une nene veni, kuuti sighwesia kukun'kana u Nguluve? ");
INSERT INTO wbi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ye vapulike amasio agha, navakagomwisie, looli vakamongisie u Nguluve na kuuti, “U Nguluve ahumisie vwumila kange muvapanji” ");
INSERT INTO wbi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kange avitiki vino valyale mu mumuko sino silyatengulile mu vufue vya Stephano valyapalasine kuhuma ku Yerusalemu -avitiki ava valyalutile kuvutali, umpaka kuvusililo ku Foinike, Kipro naku Antiokia. Valyavavulile imola kuuti u Yesu jujuo mwene kuva Yahudi nambe kwa munhu ghweni. ");
INSERT INTO wbi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Looli avanhu vamo kuhuma ku kipro na ku Krene, valisile ku Antiokia nakujova nava Yunani nakumpulisia u Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nuluvoko ulwa Mutwa tulyale palikimo nu mwene, navanhu vinga valyiitike nakusyentukila u Mutwa. ");
INSERT INTO wbi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Imola sivanave sikavafikile mu mbughulutu munyumba ija ku Yerusalemu: navakamwomwile u Barnaba alute mpaka kuvusililo uvwa Antiokia. ");
INSERT INTO wbi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ye isile nakukivona ikipelua ikya Nguluve alyahovwike; kange akavamemia ingufu munumbula save kujigha nu Mutua kumojo aghavanave. ");
INSERT INTO wbi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ulwakuva alyale munhu nofu kange amemesivue nu Mhepo Mwimike nu lwitiko ulwa vanhu vinga vakongelela mwa Mutwa. ");
INSERT INTO wbi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pa uluo u Barnaba akalutile ku Tarso kukumwagha u Sauli. ");
INSERT INTO wbi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ye amwaghile akantwala ku Antiokia. Lukale amaka ghoni valyakong'anile munyumba ja kufunyila nakuvavulanisia avanhu vinga. Navavulanesivua vakatambulivua vakilisite ulwa kwasia ukuo ku Antiokia. ");
INSERT INTO wbi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mufighono ifi avavili vakika kuhuma ku Yerusalemu umpaka ku Antiokia. ");
INSERT INTO wbi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jumonga muvanave ghwe Agabo lyelitavua lya mwene, akiima akasonua nu Mhepo kuuti injala ng'ali jihumila mu iisi joni. Ulu lulyahumile munsiki ughwa fighono ifya Klaudio. ");
INSERT INTO wbi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Lino, vavulanesivua, ndavule jumo juno apatile, valyalamwile kutwaala inangilo kuvanyalukolo vano valikuvu Yahudi. ");
INSERT INTO wbi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Valyavombile anala; Vakomola indalama muluvoko ulwa Barnaba nu Sauli. ");
INSERT INTO wbi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Unsiki ughuo untua u Herode akagholosia uluvoko lwa mwene kuvamonga vala vano vihuma kukipugha ulwakuti vavapumusie. ");
INSERT INTO wbi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akam'buda u Yakobo unyalukolo ghwa Yohana ni bamba. ");
INSERT INTO wbi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ye alolile kuuti ava Yahudi vikela isio, akankola naju Pettrokange. Ulu lulilya amasiki agha makate aghasita kilule. ");
INSERT INTO wbi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ye an'kolile, akamponia mu ndinde pe akavika ifipugha fine fya vasikari ulwakuti vamulolelaghe, alyale ihuvila kuntwala kuvanhu yekikilile ikimike kya pasaka. ");
INSERT INTO wbi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","U Petro akabukua mundinde, looli inyifunyo sikavombua ni ngufu ni kipugha vwimila vwa mwene kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ikighono yekikiale u Herode nalutile kukumumia, ikilo ijio akaghonile pakati na Kate pa vasikali vavili kumo akungilue na manyololo ghavili, navaloleli pavulongolo pa muliango vakava vilolela indinde. ");
INSERT INTO wbi_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lolagha, u nyamola ghwa Mutwa nakalingi akamumia nu lumuli lukamulika nkate. Akantova u Petro muluvafu na pikunsisimula akati, “Sisimuka ng'aning'ani.” apuo amanyororo ghoni ghano akakungilue ghakavopoka mumavoko gha mwene. ");
INSERT INTO wbi_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","U munyamola akambula, “Fwala Amanda ghako na fifilato fyako.” U Petro akavimba vulevule. U Munyamola akam'bula, “fwala umwenda ghwako pe umbingililaghe.” ");
INSERT INTO wbi_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Apuo u Petro akambingilila u Munyamola akahuma kunji. Nalyakitang'inie kind kilyavombilue nu Munyamola kuuti sa kyang'ani. Akahwanagha ighonela injosi. ");
INSERT INTO wbi_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ye akiling'inie ikilolelo ikilongosi ni kyavuvili vakafika palilyingo ilya kyuma ilya kwingilila kuluta kulikaja, likadinduka lyene vwimila vwa mwene. Vakahuma mulikaja kunji vakika mum'pulo, nakalingi u Nyamola akamuleka. ");
INSERT INTO wbi_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","U Petro ye itang'inie, akati, “Lino nitike kuuti Mutwa amwomwile u Munyamola ghwa mwene ulwakuti anyimie mumavoko gha Herode, namuhuvilo sa vanhu vooni ava muvu Yahudi.” ");
INSERT INTO wbi_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ye akagwile isi, akaluta kunyumba ja Mariamu ung'ina wawa Yohana juno ghwe Marko; Avakilisite vinga valyakong'anile vikufunya. ");
INSERT INTO wbi_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ye ahodisie kumulyango ughwa kisighililo, u-mbombi jumo uminja juno itambulivua Roda akisa kudindula. ");
INSERT INTO wbi_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ye akaguile lisio lya Petro, nu lukelo akakunua kudindula umulyango; pa uluo, akakimbilila nkate mu kyumba; nakuvavula kuuti u Petro imile kuvulongolo ku mulyingo. ");
INSERT INTO wbi_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Apuo, vakajova kwa mwene, “Uve ulinyalukwale” looli akakangasia kuuti sakyang'ani ghwe mwene. Vakati “Ujuo ghwe Munyamola ghwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Looli u Petro akajigha ifidudusia, ye vadindwile umulyango, vakamwagha vakadegha kyingo. U Petro akavanyamasia nu luvoko Kimie Kimmie pe akavavula ndavule u Mutwa amumisie kuhuma mundinde akati, ");
INSERT INTO wbi_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","“Vavule isi u YakoboYakobo na vanyalukolo va mwene.” Apuo pe akavuka kuluta ku vunge. ");
INSERT INTO wbi_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pano kukava mwisi, lukava lusukunalo mun'kate muva sikali, kuhumilanila na kino kihumile kwa Petro. ");
INSERT INTO wbi_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","U Herode ye amulondile nalyambweene akavaposia avaloleli pe akalaghila vabudue. Akaluta kuhuma kuvu Yahudi kuhuma kuvu Kaisaria pe akikala kukuo. ");
INSERT INTO wbi_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","U Herode alyale ni ng'alasi vwimila vwa vaanhu ava Tiro ni Sidonia. Vakaluta palikimo kwa mwene. Vakava nikimanyani nu Blasto untangili ghwa Ntua, kuuti avatange. Kange vakasuma ulutengano, ulwakuva iisi jave jilyaplilue ikyakulia kuhuma mu iisi ja Ntua. ");
INSERT INTO wbi_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ikighono kinokilyavikilue u Herode akafwala amenda agha kitua napikukala pakitengo ikyamwene ikya vutua, pe akavadalikila. ");
INSERT INTO wbi_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","anhuAvanhu vakajeghela, “Ili lye lisio lya Nguluve nambe nalisio lya munhu!” ");
INSERT INTO wbi_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nakalingi u Nyamola akantova, ulwakuva nalyampelile u Nguluve ulwimiko; akalivua namatekenya akafua ");
INSERT INTO wbi_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Looli ilisio lya Nguluve likakula na kukwilana. ");
INSERT INTO wbi_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","U Sauli nu Barnaba ye vakwisisie imbombo jivanave vakavuka pala vakagomoka ku Yerusalemu, vakantola nu Yohana juno ilitavua ilyakuholua ghwe Marko ");
INSERT INTO wbi_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lino mulukong'ano ulwa ku Atiokia kwevaliale Vamos avaviili na vavulanisi. Valyale u Barnabas, Simeoni (akatambulivwagha Nigeria). Lukio ughwa ku Kirene, Manaeni(unyalukolo juno alyale ghwa danda ja Herode mulongosi ghwa kighavo), nu Sauli. ");
INSERT INTO wbi_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pano valyale vikufunya kwa Mutwa na kubuhila kulia, U Mhepo Mwimike akati, “Mumbaghulile palubale u Barnaba nu Sauli, vajivombe imbombo jino nikavakemelile.” ");
INSERT INTO wbi_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pano ulukong'ano yelubuhila kulia, kukufunya, nakuvika amavoko ghave kuvanhu ava, vakavaleka valutaghe. ");
INSERT INTO wbi_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pa uluo u Barnabas nu Sauli valyamwitike uMhepo Mwimike pe vakikagha kuluta Seleukia; Kuhuma ukuo valyaghendile mu nyanja kuluta mu kiponge ikya Kipro. ");
INSERT INTO wbi_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Panovalyale mulikaja ilya Salami, vakapulisigha ilisioilisio lya Nguluve munyumba isa kufunyila isa va Yahudi. Kange valyale palikimo nu Yohana Marko hwene n'tangili ghuvanave. ");
INSERT INTO wbi_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yevalutile mukiponge kyoni mpaka ku Pafo, valyam'bene umunhu jumonga umavi, Myahudi um'bili ghwa vudesi juno ilitavua lya mwene ghwe Bar Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Umavi uju alyatangine nu Liwali Sergio Paulus, juno alyale munhu umunyaluhala. umunhu uju alyavaghongolile u Barnaba nu Sauli, ulwakuvaulwakuva alyalondagha kupulika ilisiio lya Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Looli u Elima “Umavi jula” (ndikio ilitavua lya mwenemwene fye lilya ghanulivue) alyavakanile; akghelile kukusetua u liwali jula ahume mulwitiko. ");
INSERT INTO wbi_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Looli uSauli juno atambulwagha Paulo, alyamemile uMhepo Mwimike, akamulungumalila amaso ");
INSERT INTO wbi_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","pe akajova “Uve mwana ghwaghwa setano, umemile ija vudesi sooni nu vuvotevote uve ulimulugu wa sakyang'ani. Nuladugha kusetulania isila sa Mutwa, sino sigholuike, voli ghughela? ");
INSERT INTO wbi_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lino lolagha, ulukolo ulwa Mutwa lulinuve, lino peghuliva m'bofu. Nhulyalivona ilijuva kunsiki” nakalingi ulutuka ni ng'isi filyaghwile kawa Elimasi; akatengula kusyungulika pala avanhu vamulongolele vakan'kola uluvoko. ");
INSERT INTO wbi_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ye u Liwali alolile kino kihumile akitika ulwakuva alyale idegha imbulanisio isa Mutwa ");
INSERT INTO wbi_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Lino u Paulo na vamanyani vamwene vakaghenda mumalenga kuhuma ku Pafo pevakafika ku Perge mu Pamfilia. Looli u Yohana akavaleka na kugomoka ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","U Paulo nu manyaani ghwa mwene vakaghenda kuhuma ku Perge pevakafika ku Antiokia ija ku Pisidia. Ukwo valyalutile munyumba ijakufunyila mukighono ikya sabati na pikukala pasi. ");
INSERT INTO wbi_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ye vimbile indaghilo na vaviili, avalongosi va nyumba sakufunyila akavomolela imola vakatisagha, “Vanyalukolo, nave mulinajo imola ijakuhovosia avaanhu mumwooojo avanhu apa, joovaghajoovagha”. ");
INSERT INTO wbi_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pa uluo u Paulo akiima nakuvapungila uluvoko, akatisagha, “Mwe vaghosi vamu Israeli numue mwevano muleva kwa Nguluve pulikisia. ");
INSERT INTO wbi_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","U Nguluve ughwa vaanhu ava mu Israeli alyavasalyile ava Nhata viitu na pikuvavomba avanhu vinga yevikalile mu iisi ija mu Misri, kukilila muluvoko lwa mwene kunyanyulua alyavalongwisie kunji kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Amaka ifijigho fine aligudile mulukuve. ");
INSERT INTO wbi_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ye ananginie ifisina lekela lubali mu iisi ija kanani alyavapelile avaanhu viitu muiisi jaave kuva ja vuhasi. ");
INSERT INTO wbi_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Isi sooni silyahumiile amaka ifilundo fine ni fijigho fihano. Ye fikilile ifiinu ifi fyoni, uNguluve alyavapelile avalamusi mpaka u Samweli nu M'biili. ");
INSERT INTO wbi_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ye sisilile isi, avanhu valyasumile u Ntua, pe u Nguluve akavapela u Sauli umwana wa Kishi, umunhu ughwa kabila ija Benjamini, kuuva Ntua ghwa make ifijigho fine. ");
INSERT INTO wbi_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Looli u Nguluve ye am'busisie muvutua, akantosia u Daudi kuuva Ntua ghwa vanave. lulyale lwa kumulonda u Daudi kuuti uNguluve alyajovile, “Nin'kavile u Daudi umwana ghwa Yese kuuva munhu juno mwoojo ghuango ghukunoghelua; juno ivoombagha ifiinu fyooni fino nifighanile.' ");
INSERT INTO wbi_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuhuma mu kikolo ikya munhu uju u Nguluve ajiletile i Israeli um'poki, uYesu, ndavule alyafingile kuvoomba. ");
INSERT INTO wbi_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iili lilyatenguile kuhumila ye akyale kukwisa, u Yohana taasi akapulisyagha ulwofugho ulwa lulato kuvanhu ava mu Israeli. ");
INSERT INTO wbi_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ghwope u Yohana pano alyale imalisia imbombo jake akatisagha, “Mu kunisagha une nene veeni? une nanene jula. Looli mupulikisyaghe, juno ikwisa munsana mu Lyune, na ni vaaghiile ku lendesia ifilato fya maghulu ghamwene.' ");
INSERT INTO wbi_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Vanyalukolo, mwevana vakisina kya Abrahamu, navala vano mun'kate mulyumue mukufynya kwa Nguluve, vwimila vwitu kuuti imola iiji uvuvaangi vusung'ilue. ");
INSERT INTO wbi_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kuvala vano vikukala ku Yerusalemu, navatemi vavanave, navalyan'kangwile sa kyang'ani, nakuuva navalyalutang'inie uvwolesi vwa vaviili vuno vukwimbua jaatu pa Sabati; pa uluo valyakwisisie imola ija vaviili ulwa kumigha u Yesu kufua. ");
INSERT INTO wbi_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Napato navalyaluvwene vunono ulwa kufwila n'kate mwamwene, valyan'sumile u Pilato am'bude. ");
INSERT INTO wbi_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Vatile vamalile isio sooni sino silyalembilue vwimila umwene, vakamwisia kuhuma mumpiki nakumughonia mu mbipa. ");
INSERT INTO wbi_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Looli u Nguluve alyan'syusisie kuhuma kuvafue. ");
INSERT INTO wbi_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Alyavonike mufighono finga kuvala vano vakaghendaniagha palikimo nu mwene kuhuma ku Galilaya kuluta ku Yerusalemu. Avaanhu ava lino vevolesi va vaanhu. ");
INSERT INTO wbi_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ku uluo tukuvaletela imola inofu vwimila ifiingo sino valyapelilue avisukulu viitu. ");
INSERT INTO wbi_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","U Nguluve alyavikile ifingo isi kulyumue, avana vavanave, mu uluo alyan'syusisie u Yesu nakukun'gomosia kange ku vwumi. Iili kange lilyalembilue mu Zaburi ija vuvili: 'Uve uli mwanango, umusyughu nili Nhata ghuako' ");
INSERT INTO wbi_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kange vwimila uvwa kyang'ani kwekuuti alyansyusisie kuhuma kuvafue ulwakuuti umbili ghwa mwene ghuleka pinangika, ajovileajovile ndiki: 'Nikukupelagha uvwimike ni nyifunyo sa kyang'ani sa Daudi' ");
INSERT INTO wbi_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ulu fyenambe ajovile kange mu ZaburiZaburi isinge, 'Naghukum'pelagha u vwimike vwako kukuvuvona uvuvole.' ");
INSERT INTO wbi_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ulwakuva u Daudi ye avombile uvughane vwa Nguluve mukikolo kya mwene, akaghonelela, alyaghonile palikimo na vapafi va mwene, pe alyavwaghile uvunangike, ");
INSERT INTO wbi_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Looli juno alyasyusivue nu Nguluve nalyavwaghile uvunangike. ");
INSERT INTO wbi_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Uluo fyelukagulikaghe kulyumue, vanyalukolo, kukilila umunhu uju, ulusaghilo lwa vuhosi ludalikivue. ");
INSERT INTO wbi_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kwa mwene ghweni juno ikumwitika ivalilua vwakyang'ani naghoni ghanoghano indaghilo sa Musa nasale sikuvapela uvwakyang'ani. ");
INSERT INTO wbi_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pa uluo muve vafwihu kuuti kino valyajovile avaviili kilahumilagha kulyumue: ");
INSERT INTO wbi_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Lolagha, umue mwevano musyojola, mudeghaghe kange mutipulivuaghe; ulwakuva nivoomba imbombo mufighono fiinu, imbombo jino namungajitike, nambe umunhu avoleleele ndani.” ");
INSERT INTO wbi_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Unsiki ghuno Upaulo nu Barnaba ye vavukile, avanhu vakasuma vajove amasio agha kighono kya Sabati jinojikwisa kange. ");
INSERT INTO wbi_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Unsiki ghuno ulukong'ano ulwa munyumba ija kufunyila ye yeghusilile, avaYahudi vinga na vimike avapesia vakam'bingilila uPaulo nu Barnaba, vano valyajovile navoope vakavaghimbilisia vaghendelelaghe mu lusungu lwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Isabati jino jilyavingilile, hwene ilikaja lyoni lilyakong'anile kupulika ilisio lya Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ava Yahudi ye vavwene amapugha, vakamemagha igila nakujova amasio ghano ghakakanagha sooni sino silyajovilue nu Paulo kange vakamulighagha. ");
INSERT INTO wbi_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Looli u Paulo nu Barnaba vakajovagha ni ngufu vakatisagha, “Luvele lunofu kuuti ilisio lya Nguluve lijovuaghe tasi kulyumue. Ulwakuva mukulidaghila kutali kuhumakuhuma kulyumue na pikujagha kuuti namukanoghile uvwumi uvwa kuvusile nakusila, lolagha tukuvasyetukilagha ifisina. ");
INSERT INTO wbi_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ndavule umutwa atuvulile, pano iiti, “Nivaviikile umwe hwene lumuli kuvanhu avapanji, ulwakuuti mulute uvuvaangi kumbale sooni isa iisi.” ");
INSERT INTO wbi_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Avapanji yevapulike ili, valyahovwike nakulighinia ilisio lya Mutwa. Vinga vano alyasalulivue kuvwumi uvwajatu valyitike. ");
INSERT INTO wbi_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ilisio lya Mutwa likakwila iisi jooni. ");
INSERT INTO wbi_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Looli ava Yahudi vakavapelepesia vano valihumisie nava mama avwimike, kange navalongosi valikaja. Isi silyahovelisie imumuko kwa Paulo nu Barnaba pe vakatagha kunji kumaka sa likaja. ");
INSERT INTO wbi_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Looli u Paulo nu Barnaba valyakung'unile iling'undi mumaghulu ghavane. ");
INSERT INTO wbi_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pe vakaluta mulikaja ilya Ikonia. Avavulanisivua vakamema ulukelo palikimo Mhepo u Mwimike. ");
INSERT INTO wbi_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Lulyahumile mun'kate mu Ikonio kuuti u Paulo nu Barnaba valingile palikimo Mun'kate mu nyumba inyimike ija kufunyila kuva Yahudi nakujova ndavule ikupugha ikivaha kuvanhu ava Yahudi nava Yunani valyitike. ");
INSERT INTO wbi_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Looli avaYahudi vano navalyapelilue uluhala kuvapanji napikuvavomba kuuti vave vavivi kuvanyalukolo. ");
INSERT INTO wbi_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pa uluo valikalile ukuo kunsiki untali, vakajovagha kulukangasio kungbufu sa Mutwa, ukuo alyahumisie ulusimilisio ku mola isa vumosi vwa mwene. Alyavombile anala kuhumia ifidegho na kudegha fivombue kumavoko agha Paulo nu Barnaba. ");
INSERT INTO wbi_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Looli ikisala ikya likaja lilyaghavike: vamo avanhu vano valyale palikimo nava Yahudi, navamo palikimo navasung'wa. ");
INSERT INTO wbi_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Unsiki ghuno ava panji navaYahudi ye vaghelile kukuvavula avalongosi vavanave kuvavombela uvuvivi nakavadija namavue uPaulo nu Barnaba, ");
INSERT INTO wbi_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","valyakagwile ilio nakuluta ku makaja agha Likaonia, Listra naku Derbe, na kufisala fino fisyungwite Pala, ");
INSERT INTO wbi_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","pe ukuo vakadalikilagha ilivangili. ");
INSERT INTO wbi_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ukuku Listra palyale umunhu jumo juno alikalile, nakale nini ngufu mu maghulu gha mwene, umulema kuhuma mulileme lya mama ghwa mwene, naghelile kughenda. ");
INSERT INTO wbi_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Umunhu uju alyam'pulike u Paulo ijova. U Paulo akamulunguvalila amaso pe akalolagha kuuti ulwitiko ulwa kusosivua. ");
INSERT INTO wbi_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pa uluo pe akajova kwa mwene kulisio lya kukyanya, “Imagha kumaghulu ghako.” Pe umunhu jula alyaahadwike na kutengula kughenda. ");
INSERT INTO wbi_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ikipugha ye kilolile kino alyavombile u Paulo, vakamula amasio ghavanave, vakajova ni njovele ija Kilikaonio, “Amatekelo ghatukenyemwisie kulyusue twe vanhu.” ");
INSERT INTO wbi_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Valyan'kemelile u Barnaba “Zeus,” nu Paulo, “Herme” ulwa kuuti alyale njovaji m'baha. ");
INSERT INTO wbi_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Amatekelo agha Zeu, juno inyumba imbaha inyimike ija kufunyila jamwene jilyale kunji kukisina, alyaletile ulutogo ulwa ng'ombe ulukindi lwa maluva ghano gha tavilkilue kufika palilyango lya likaja, umwene ni kipugha vakalondagha kuhumia ilitekelo. ");
INSERT INTO wbi_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Looli avasung'ua, u Paulo nu Barnaba yevapulike iili, valyademwile Amanda ghava nave kange ng'anang'ani vakaluta kunji kikipugha, vakalilagha ");
INSERT INTO wbi_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","na kujova, “Mwe vanhu umue, nakiki muvomba agha? Najusue kange tulivanhu vano uluhala lulindavule umue. Tukuvaletela imola inofu kuuti musyetuke kuhuma mufinu ifi finofilondua nakumulutila u Nguluve juno mwumi, juno alyavumbile uvulanga, iisi ni nyanja nakyekyoni kila kino mwekile. ");
INSERT INTO wbi_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Munsiki ghuno ghukakilile, alyavatavwile ava panji kughenda musila sivanave. ");
INSERT INTO wbi_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Looli ye akiale, nakabukile nambe nu mwolesi, ku ilio akavombile vunofu nakukuvapela ifula kuhuma kukyanya kange mumasiki gha kyakulia, akavamemia inumbula sivanave kufya kulia nulukelo” ");
INSERT INTO wbi_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nambe amasio agha, u Paulo nu Barnaba kulupumuko valyasighile ikipugha kuvahumikisia ilitekelo. ");
INSERT INTO wbi_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Looli vamo ava Yahudi kuhuma ku Antiokia na ku Ikonio valisile kukukivula ikipugha. Van'kadija navavue u Paulo na kukunkwesela kuunji kukisina, ye vakati afuile. ");
INSERT INTO wbi_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mu uluo avavulanisivua vakimagha pipi nu mwene, alyasimwike, vakingila kukisina. Ikighono kya vuvili akaluta mu Derbe nu Barnaba. ");
INSERT INTO wbi_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ye ikuvavulanisia ilivangili mu kisina kiila nakuvavomba avavulanisivua vinga, vakagomoka ku Listra, naku Ikoniamu, umpaka ku Antiokia. ");
INSERT INTO wbi_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Valyaghendelela kunosia uluvelouluvelo ulya vavulanisivua nakupelua inumbula kughendelela mumu lwitiko, akati, “Lunoghile twingile kuva tua va Nguluve kuhumila imumuko nyinga.” ");
INSERT INTO wbi_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ye vavasalyule Avene avaghogholo ava kipugha kya vitiki, ye vavavikufunya kisila kulia, vakampela u Mutwa, sino avene valyamwitike. ");
INSERT INTO wbi_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kange valyahumile ku Pisidia, valyafike ku Pamfilia. ");
INSERT INTO wbi_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Unsiki ghuno valyajovile amasio agha ku Purge, Valikile kuluta ku Atalia. ");
INSERT INTO wbi_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kuhuma ukuo valyapandile imeli kufika ku Antiokia kunokuno valyale vihumisie kulusungu kwa Nguluve vwimila vwa mbombo jiino lino vakajikwisisie. ");
INSERT INTO wbi_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ye vafikile ukuo ku Antiokia, na kukong'ania ikipugha palikimo, valyahumisie imola ja agha ghano u Nguluve avambile ku vanave, kange ye avafungulile umulyango kulwitiko lwa vanhu avapanji. ");
INSERT INTO wbi_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Valikalile unsiki n'tali navavulanisivua. ");
INSERT INTO wbi_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Avanhu vango vakika kuhuma ku Yahudi na kukuvavulanisia avanyalukolo, vakaati, “nambe namukeketivue ndavule ulwiho ulwa Musa, namughwesia kuvanguka.” ");
INSERT INTO wbi_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Unsiki u Paulo nu Barnaba ye vakale vatang'ine na kujova palikimo navene, avanyalukolo valyamwile kuuti Paulo, Barnaba, navange vamo valute ku Yerusalemu ku vasung'wa avaghogholo kuposia iili. ");
INSERT INTO wbi_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ku iili, kukwomola kuvanave kunyumba inyimike ijakufunyila valyahumile ku Foinike na ku Samaria yeye vipulisia kusyetula uvufumbue kuva panji. Valyaletile ulukelo ulukome kuvanyalukolo vooni, ");
INSERT INTO wbi_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ye visile ku Yerusalemu pe vakapokelilue nii nyumba inyimike ijakufunyila kange navasung'wa na vaghogholo, vakavafunyila imola inofu ku isi sooni sino u Nguluve avombile palikimo na Vene. ");
INSERT INTO wbi_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Looli avanhu vamovamo vano valitike, valyale mukipugha ikya Mafarisayo, valyimile nakujova, “lunoghile kukuvakeka na pikuvavula vakole ululaghilo ulwa Musa.” ");
INSERT INTO wbi_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pe avasung'wa navaghogholo vakima palikimo kukulisaghila iili. ");
INSERT INTO wbi_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ye sikilile imuling'ano inali, u Petro akima nakujova kuvanave, “Avanyalukolo vitang'aniaghe kuuti kitambuko kinono kiino kikilile u Nguluve akavombile uvusaluli pakate palyusue, kuuti mulomo ghwango avapanji vapulikaghe ilisio lya livangili, na pikulyitika. ");
INSERT INTO wbi_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","U Nguluve juno ikagula inumbula, ikwolela kuvanave, ikuvapela u Mhepo u Mwimike, ndavule alyavombile kulyusue; ");
INSERT INTO wbi_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","nalyavombile nambe kulyuseu na vene, ye ivomba munumbula sivanave sive nofu kulwitiko. ");
INSERT INTO wbi_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ku uluo, nakiki mukumughela u Nguluve kuuti muvike ulughoji ku singo isa vavulanisivua sino nambe u Nhata ghuitu kange natughwesia kukangala? ");
INSERT INTO wbi_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Looli tukwitika kuuti tupokua ku vumosi ulwa Mutwa Yesu ndavule valyale.” ");
INSERT INTO wbi_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ikipugha kyoni kikajika kimie ye vikupulikisia u Barnaba nu Paulo ye vakale vihumia imola isa kidegho na kudegha jino u Nguluve alyavombile palikimo navene ku vapanji. ");
INSERT INTO wbi_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ye vabuhilile kujova, u Jakobo akamula akati, “Nyalukolo nipulikisie. ");
INSERT INTO wbi_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","U Simoni alyajovile ulwakwanda kuuti u Nguluve kuvamosi alyavatangile avapanji kuuti apelilue kuhuma kuvanave ku vanhu ku litavua lya mwene. ");
INSERT INTO wbi_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Amasio agha vaviili ghi kwiting'ana niili ndavule lyalembilue. ");
INSERT INTO wbi_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Pa uluo niligomoka kange kunosia ili tembe lya Daudi, linolilyaghuile pasi, ninyanyula na kunosia uvunangifu vwamwene, ");
INSERT INTO wbi_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kange bahapuo avanhu vano vakajighe vamulonde u Mutwa, palikimo navapanji vano vitambulua kulitavua uyango.' ");
INSERT INTO wbi_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ifi fyefino ajovagha u Mutwa juno avombile agha gha kukagulika kuhuma ku vutua uvwakatali. ");
INSERT INTO wbi_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kange, amasaghe ghango, natungavapelaghe imumuko avanhu avapanji vano vikunsyetukila u Nguluve; ");
INSERT INTO wbi_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","looli tulembe kuvanave kuuti vibaghule kutali nu vunangifu uvwa sanamu, uvunoghelua uvwa vavwafu, nafino filya kngilue, ni danda. ");
INSERT INTO wbi_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kuhuma kisina ikya vaghogholo pevale avanhu mulikaja vano vidalikila na kukumulumba u Musa mumajumba aghakufunyila ku sabati.” ");
INSERT INTO wbi_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pa uluo lukavonike kuuti luvanoghile avasung'ua nava ghogholo, Palikimo ni nyumba jooni inyimike ijakufunyila, kukunsalula u Yuda juno itambulua Barsaba, nu Silas, vano valyale valongosi munyumba inyimike ijakufunyila, na kukuvomola ku Antiokia palikimo nu Paulo nu Barnaba. ");
INSERT INTO wbi_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Valyalembile anala, “Vasung'ua, vaghogholo navanyalukolo, kuva nyalukolo avapanji vano vali ku Antiokia, ku Shamus na ku Kilikia, salamu. ");
INSERT INTO wbi_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tupulike kuuti avanhu avange vano tukavapelile ilulaghilo uluo, valyahumile kulyusue pe vakavapumusia avavulanesi vano vileta imumuko muluvelo kuvanave. ");
INSERT INTO wbi_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mu uluo luvonike vunofu kulyiusue tweeni kusalula avanhu na pikuvomola kulyumue palikimo navaghani viitu u Barnaba nu Paulo, ");
INSERT INTO wbi_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","avanhu vano vakivikile mu vulalamu ulwa mikalile ghavanave vwimila vwa litavua lya Mutwa Yesu Kilisite. ");
INSERT INTO wbi_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ku uluo tumwomwile u Yuda nu Sila, vikuvavulagha sisisio. ");
INSERT INTO wbi_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ulwakuva lukavonike vunofu kwa Mhepo Mwimike na kulyusue, kuleka kuviika kulyumue unsigho un'kome kukila isio sino nasakusileka: ");
INSERT INTO wbi_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kuuti musyetuke kuhuma kufinu fino fitavula kufi hwani, i danda, ifiinu fya kunyongua, nu vu vwafu. Nave mukuvika kutali nifi, luve lunofu kulyumue. Mukaghone.” ");
INSERT INTO wbi_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Apuo lino, ndavule vakavapalasinie, valikile ku Antiokia; Ye vakong'anisie ilipugha palikimo, valyafikisie ikalata. ");
INSERT INTO wbi_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pano vakati vajimbile, valyahovwike ulwakuva jilyavisisie umwojo. ");
INSERT INTO wbi_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","U yuda nu Sila, na vaviili valyavisisie umwojo avanyalukolo namasio aminga na pikuvapela ingufu. ");
INSERT INTO wbi_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ye vikalile unsiki ghumonga ukuo, valyavapalasinie nulutengano kuhuma kuva nyalukolo vala vano valyavomwile. ");
INSERT INTO wbi_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Looli lulyavonike kuva lunofu uSila kujigha ukuo ");
INSERT INTO wbi_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Looli u Paulo navange valikalile ku Antiokia palikimo na vange vinga, pano vakavulanisiagha na kudalikila ilisio lya Mutwa. ");
INSERT INTO wbi_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ye fikilile ifighono nde filingi u Paulo akajova kwa Barnaba, “Tugomoke lino na pikuvaghendela avanyalukolo mufikaja fyooni fino tukadalikile ilisio lya Mutwa, napikuvalola valindani. ");
INSERT INTO wbi_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","U Barnaba akalondagha kange pikuntola palikimo navoope U Yohana junojuno itambulivua Marko. ");
INSERT INTO wbi_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Looli u Paulo alyasaghile nalulyale lunofu kukun'tola u Marko, akavalekile kulam ku Pamfilia nalyaghendelile navope mumbombo. ");
INSERT INTO wbi_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kange bahapuo sikahumila isakukaning'ana imbaha pa uluo vakalekeng'ana, naju Barnaba akan'tola u Marko nakughenda mu Meli kufika ku Kpro, ");
INSERT INTO wbi_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Looli u Paulo akansalula u Sila na kuvuka, ye vamalile kuvikua navanyalukolo mu lusungu lwa Mutwa. ");
INSERT INTO wbi_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pe akaluta kukilila ku Shamus na ku Kilikia, akasikangasiagha ing'ongano. ");
INSERT INTO wbi_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","U Paulo pano alisile ku Derby naku Lystra; nakalingi lolagha, pala pealyale umbulanisivua akatambuluagha Timotheo, unsoleka juno alyaholilue nhu ng'ina ghwa ki Yahudi juno alyale mwitiki uvise ghwa mwene alyale N'giliki. ");
INSERT INTO wbi_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Avanhu vaku Listra naku Ikonio valyamwolelile vunofu. ");
INSERT INTO wbi_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","U Paulo alyamulondile ulwakuuti vaghendanie na ghwope, pa ulo akan'tola na pikun'dumula vwimila vwa va Yahudi vano vyalyale ukuo ulwakuva vooni valyan'kaguile kuuti iviise ghwa mwene N'giliki. ");
INSERT INTO wbi_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pano valyale viluta valyakilile mu likaja na kulaghila indaghilo kung'ong'ano ulwa kuuti vasoghope indaghilo isio sino sikalembilue nava sung'ua na vaghogholo ava mu Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Apuo ing'ong'ano sikakangasivua mu lwitiko navano valyitike vakongelela mukipugha mufighono fyooni. ");
INSERT INTO wbi_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Upaulo nava nine vakaluta ku FiligiaFiligia naku Galatia, ulwakuva uMhepo ghwa Nguluve alyavakanile kudalikila ilisio ukuo kukighavo ikyaku Asia. ");
INSERT INTO wbi_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ye vaseghelile ku Misia, vakaghela kuluta ku Bithinia, looli uMhepo ghwa Yesu alyavakanile. ");
INSERT INTO wbi_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pa uluo vakakila ku Misia vakiisa mpaka mulikaja ilya Throa. ");
INSERT INTO wbi_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Imbonekelo sika mumila u Paulo pakilo, kwa lyale umunhu wa ku Makedonia imile, ikung'emela nakujova “Isagha mututange kuno ku Makedonia”. ");
INSERT INTO wbi_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","U Paulo ye asivuene imbonekelo, nakalingi tukiling'anie kuluta ku Makedonia, alyakaguile Kati u Nguluve atukemelile kuluta kuvadalikila ilivangili. ");
INSERT INTO wbi_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Apuo tukavuka kuhuma ku Throa, tukaluta vwimila ku Samothrake, ikighono kino kilyavingile tukafikile mulikaja ilya Neapoli. ");
INSERT INTO wbi_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuhuma apuo tukaluta ku Filipi ghuno ghwope ghumo ni likaja ilya Makedonia, ilikaja ilitambu mu wilaya nu vuutema vwa Kirumi pe tukikala ifighono nde filingi. ");
INSERT INTO wbi_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ikighono ikya sabati, tulyalutile kunji ku lilyango tukaghendela musila ja malenga, pano tukatisagha pe piva apakuvombela inyifunyo. Tukikala pasi na pijova nava kimama vanovalisile palikimo. ");
INSERT INTO wbi_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","U mwana mama jumonga juno itambulivua Lidia, juno akaghusiagha irangi ja zambarau, kuhuma mu likaja lya Tiatira, juno akifunyagha kwa Nguluve, alyatupulikisie. U Mutwa akan'dindulila umwoojo ghwa mwene nakuvikila umwoojo amasio ghano ghalyajovilue nu Paulo. ");
INSERT INTO wbi_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ye ofughue, umwene palikimo ni nyumba ja mwene jooni, akatupelepesia akati “Neve munyaghile une kuuti nuvyakyang'ani mwa Mutwa, pe nikuvasuma mwingile na pikukala kulyune”. Akatupelepesia kyongo. ");
INSERT INTO wbi_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pe lukava n'diike, tukati tuluta pano palyale pakufunyila, uminja jumo juno alyale nili pepo ilyakulaghula akatang'ana nusue. Alyamuletile umutua gha mwene ifaida nyinga nuvukedusi. ");
INSERT INTO wbi_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","U mukumama uju alya m'bingilie uPaulo palikimo nusue, akajeghelagha iti “Avaki baba ava vombi va Nguluve u m'baha, vano vipulisia kulyumue imola sa vupoki”. ");
INSERT INTO wbi_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Alyavombile vulevule mufighono finga, looli u Paulo ye an'kalisie ni mbombo ijio, akasyetuka kunsana napikulivula ilipepo, “Nikukulaghila mu litavua lya Yesu uhume mun'kate mwa mwene.” Lyoope likahuma likamuleka nakalingi ");
INSERT INTO wbi_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Avatua va mwene yevalolie kuuti uluhuvilo lwa faida jivanave luvukile, vakavakola u Paulo nu Sila na pikuvavika mu lighulilo pa vanyavutavulilua. ");
INSERT INTO wbi_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ye vavatwalile kuva highi, vakati, “Ava ghosi ava va Yahudi vipelela ingasi ing'ome mulikaja liitu. ");
INSERT INTO wbi_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Vivulanisia sino nasilimundaghilo usue kuvupila nambe kuvingilila ndavule ava Rumi.” ");
INSERT INTO wbi_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ilipugha likavagevukila u Paulo nu Sila, avahighi vakademulania Amanda ghavanave kange vakavafula vakalaghila vachapue ni fiboko ");
INSERT INTO wbi_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ye atovilwe ingoda nyinga, vakavataghila mu ndinde nakuvavula avasikari ava ndinde kukuvalolelela. ");
INSERT INTO wbi_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ye vupile ululaghilo uluo, avasikari va ndinda alyavataghile mu kyumba ikya nkate ikya ndinde nakukuvapinya amaghulu gha vanave Muno akavabikile. ");
INSERT INTO wbi_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Unsinki wa kilo nkate, uPaulo nu Silas vakava vikufunya na na kukwimba inyimbo isakumughinia uNguluve, kuno avapinyua avenge vakavapulikisyagha, ");
INSERT INTO wbi_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nakalingi kikahumila ikinsenyena ikivaha nu lwalo lwa ndinde lukasukania, amalyango gha ndinde ghakadinduka, na manyololo agha vapinywa ghakalegena. ");
INSERT INTO wbi_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Umuloleli ghwa ndinde akasimuka mu tulu pe akavona amalyango ghoni agha ndinde ghadindwike; pe akatola umaghe ghwa mwene ulwauuti akalondagha pikubuda ulwakuva alyasaghile kuuti avapinywa voni vadyighile, ");
INSERT INTO wbi_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Loli, uPaulo akajeghela nelisio ilivaha, akati “Uleke pikulemasia ulwakuva twevoni tuliapa”. ");
INSERT INTO wbi_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Unsikari wa ndinde aasuma itaala site pe akingila munkate mu ndinde ni ng'aning'ani, akatetemagha napikwoghopa, akavaghwila uPaulo nu Sila, ");
INSERT INTO wbi_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","napikuvahumia kunji mundinde na kuuti, “Vagoyo nivombekiki neke kuvangua?” ");
INSERT INTO wbi_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Vope vakam'bula, “Umwitike uMutwa Yesu najuve ghuvanguka palikimo ni nyumba jako.” ");
INSERT INTO wbi_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Valyajovile ilisio lya Mutwa kwa mwene, palikimo na vanhu voni va munyumba jamwene, ");
INSERT INTO wbi_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Umuloleli wa ndinde akalyavatolile ikilo jila na pikuvasuka munovalyalemile, nakalingi umwene palikimo na vanhu va munyumba ja mwene vakofughua. Akavaleta uPaulo nu Sila kunyumba ja mwene ");
INSERT INTO wbi_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","na pikuvabiikila ikyakulia. Ghuope akiva nulukelo luvaha palikimo na vanhu va nyumba ja mwene ulwauva valyamwitike uNguluve. ");
INSERT INTO wbi_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Panojilyale mwisi, avahighi vakamola imola kwa muloleli jula uwa ndindendinde vakati, “Vatavule Vala valutaghe”, ");
INSERT INTO wbi_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Umuloleli ghwa ndinde akam'bula uPaulo ulwa mansion agha,”Vahighi vahighi vakomola imola vatavule ava valutaghe: lino muhumaghe kunji mulutaghe mutenganiile.” ");
INSERT INTO wbi_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Looli u Paulo akavavula, “Vakatutovile pavugholofu, avanhu vano va Rumi kisila kuhigha kange vakalamula kututagha mundinde; kange lino vilonda pikutuhumia kisyefu? Nambe, nalunganoghele, vavuo vene viise vatuhumie apa”. ");
INSERT INTO wbi_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Avaloleli vakavavula avahighi isa mansion agha, avahighi vakoghopa kyongo pala pano vakakaguile kuuti u Paulo nu Sila va Rumi. ");
INSERT INTO wbi_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Avahighi vakisa na pikuvapelepesia vahume, ye vavahumisie kunji mu ndinde, ye vavasumile upaulo nuSila vahume kunji mulikaja livanave. ");
INSERT INTO wbi_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pa uluo uPalo nu Silas vakahuma kunji mundinde vakisa kunyumba kwa Lidia. uPaulo nu Silas yevavavweni avanyaluolo, vakanyamasia umwojo kange vakabuka mulikaja ilio. ");
INSERT INTO wbi_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ye vakilile ifikaja ifya mu Amfipoli ni Apolonia, vakisile mpaaka mulikaja lya Thesalonie lino lilyale nava sinagogi ava Yahudi. ");
INSERT INTO wbi_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ndavule lulyale lwiho lwa Paulo, alyalutike kuvanave, na kunsiki ughwa fighono fiitatu ifya Sabati pe akapuling'ana na voope vwimila u vulembe. ");
INSERT INTO wbi_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Aava ikuvavalulila uvulembi na piuvolelela kuuti, lulyanoghile ukiliste kupumuka kange kusyuka kange kuhuma kuvafue. Akavavula, “U Yesu uju niuvavula imola sa mwene ghwe kilisite” ");
INSERT INTO wbi_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Vamo avayahudi vaaghelilue na pilungana nu Paulo nu Sila, palikimo nava Giriki vano vikufunya Kwan Nguluve, avamama vinga avagholofu ni kipugha ikivaha ikya vanhu. ");
INSERT INTO wbi_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Looli vamo ava Yahudi vano navalyitike, vano valyamemile igila, valyalutile kulighulilo na pikuvatola avanhu vamo napikuvatola avahosi, vakakong'ania ilipugha lya vanhu palikimo, na kukwambusia ulunjughanjugha mu likaja, kange vakajigulukila inyumba ja Jason, vakalondagha vavakole u Paulo nu Sila ulwakuuti vavalete pavulongolo pa vanhu. ");
INSERT INTO wbi_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Loli yevavakunilue vakankola u Yasoni navamo avanyoloolo avenge na pikuvatwala pavulongolo avagoyo ava mulikaja pe vaajeghelagha, “Avaghosi ava vano vasyetulinie iisi vafiile mpauno kange, ");
INSERT INTO wbi_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Avaghosi ava vino vakambilivue nu Yasoni vinangania indaghilo ja Kaisari, viiti kuale uNtua ujunge juno itambulivua Yesu” ");
INSERT INTO wbi_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ilipugha lya vagoyo vakikaja ye vapulike isio, pevakava night ngananio. ");
INSERT INTO wbi_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ye vamalile kutola indalama sino siling'ine vuloleli kuhuma kwa Yasoni na vange, vakavalekesia valutaghe. ");
INSERT INTO wbi_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ikilo jila avanyalukolo vakamwomwile u Paulo nu Sila ku Beroya. Ye vafikile kula vakaluta munyumba ija kufunyila ija va Yahudi. ");
INSERT INTO wbi_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Avanhu vala valyale vumofu kukila avanhu vala ava ku Thesalonike, ulwakuva valitavuile kukulyupila ilisio muluhala luvanave, kulolela amalembe ifighono fyooni ulwa kuuti valole kuuti amasio ghano ghalyajovilue fyeghalivuo. ");
INSERT INTO wbi_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ku uluo avinga muvanave valyitike, mwevakava nava kimama avanyangelo imbaha isa ki Giriki navava ghosi vinga. ");
INSERT INTO wbi_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Looli ava Yahudi ava ku Thesalonike yevakaguile kuuti u Paulo ipulisia ilisio lya Nguluve ukuo kuku Beroya, vakaluta ukuo na kuhovalesia kange kutengula ulunjughanjugha kuvanhu. ");
INSERT INTO wbi_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ng'aning'ani, avanyalukolo vakan'twala u Paulo kusila ija lisumbe, looli u Sila nu Timotheo vakasighala pala. ");
INSERT INTO wbi_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Avanyalukolo vala vano vakan'twalile u Paulo vakaluta naghwope m'paka ku Athene, ye vamulekile u Paulo kula, valyupile indaghilo kuhuma kwa mwene kuuti, u Sila nu Timotheo visaghe kwa mwene ng'ani ng'ani kyongo. ");
INSERT INTO wbi_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Unsiki ghuno vakavaghulilagha kula ku Then, inumbula ja mwene vakajikalisie mun'kate mwa mwene ndavule alyalolile ilikaja ndavule ghulyamemile ifihwani finga. ");
INSERT INTO wbi_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pa uluo vakapuling'ana munyumba ijakufunyia nava Yahudi vano vakifunyagha kwa Nguluve na kuvooni vaala pano vakatang'ine navoope ifighono fyooni kulighulilo. ");
INSERT INTO wbi_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Looli vamo ava Falsafa ava ku va Waepikureo nava Wastoiko vakapela. Navange vakaati, “Kye kiki kino ijova unjovaji un'debe? Avenge vakaati, “Jihufia idalikila imola ja Nguluve umesia,” ulwakuuva idalikila imola ija Yesu na kusyuka. ");
INSERT INTO wbi_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Vakan'tola u Paulo na pikuntwala ku Areopago, vakaati, “Tukagula kukulumanya ululaghilo ulu ulupia luno ghujova? ");
INSERT INTO wbi_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ulwakuva ghuleta amasio amapia mumbughulutu situ. Kurt uluo tulonda kukagula kuuti amasio agha ghalindani?” ");
INSERT INTO wbi_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Na vaanhu vooni ava ku Athene palikimo navahesia vano pwevale kuvanave, vaghumanyile unsiki ghuvanave ughu kujova na kupulikisia ilisio ilipia.) ");
INSERT INTO wbi_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pa uluo u Paulo akima pakate na kate pa vaanhu ava ku Areopago na kuuti, “Umue mwe vanhu vaku Athene, nikuvagha kuuti muli vaanhu vano vikela kwitika kumanguluve, ");
INSERT INTO wbi_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ulwakuva munenihingile une na kulola ku ifiinu finu fino mukufunya, nighavwene amasio ghano ghalembilue ku fimo ifitekelelo fiinu, ghiiti, “KWA NGULUVE JUNO NAIMANYIKIKA”. Pa uluo, ujuo juno mukufunya kisila kukagula, ghwe ujuo juno nikuvavula umue. ");
INSERT INTO wbi_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","U Nguluve juno alyavumbile Lisa ni kinu kino mwekilimwekili mun'kate, ulwakuva ghwe Mutwa ghwa vulanga ni iisi, naiwesia pikukala munyumba imbaha inyimike ijakufunyila sino sitendilue namavoko. ");
INSERT INTO wbi_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kange na ivombua na mavoko ulwakuuti ilonda ikiinu kivanave umwene jujuo ikuvapela avanhu uvwimi nu mwuuja ni fiinu fyooni ifiinge. ");
INSERT INTO wbi_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kuhumila u munhu jumo, aalyavombile mukisina kyooni ikya vanhu vano vikukalapamaso agha iisi, pe akavavikila amasiki nu vusililo uvwa fisala fino fikukala. ");
INSERT INTO wbi_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mu uluo, vilondua kukun'kagula unguluve, kuuti van'fikile na kukumwagha, kyang'ani nalikutali nambe nhu jumo ghweeni. ");
INSERT INTO wbi_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kwa mwene tukukala, tughenda nakuva nu vwimi vwitu, ndavule un'tunzi ghwinu ughwa lishairi yeatileyeatile 'tulivaholua va mwene.' ");
INSERT INTO wbi_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ku uluo, ndavule tulivaholua va Nguluve, nalunoghile kusagha ilitekelo lilindavule isahabu, ni shaba, na mavue, fihwani kino kikahongolilue vunofu namasaghe gha vanhu. ");
INSERT INTO wbi_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mu uluo, u Nguluve alyjikile Kimmie amasiki agha vuyasu, looli lino ilaghila avanhu vooni valate. ");
INSERT INTO wbi_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ulwakuva avikile ikighono kind alyale ikujihigha iisi ija kyang'ani kwakwa munhu juno alya n'saluile. U Nguluve alyahumisie uvwakyang'ani kwa munhu uju kange pala umunhu juno alyansyusisie akahumile kuvafue. ");
INSERT INTO wbi_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Avanhu va ku Athene yevapulike imola ija kusyuka kuvafue, navala vamo vakan'syojuile u Paulo, avenge vakaati “Tukukupulikisia kange kumola iji” ");
INSERT INTO wbi_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Apuo, u Paulo akavaleka. ");
INSERT INTO wbi_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Looli avanhu vamo valyale ikinu kimo vakitika, pwe akale u Dionisio Mwereopago, nu mama Juno itambulua Damari na vange palikimo navene. ");
INSERT INTO wbi_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ye sikilile imbombo isio, u Pqulo alyavukile ku Athene kuluta ku Korintho. ");
INSERT INTO wbi_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ukuo akamwaghile umuYahudi juno itambulivu Akwila umunhu ghwa likabula lya Ponto, umwene nu ndala ghwamwene juno itambulivua Prisila valisile kuhuma ukuo ku Italia, u lwakuva ukilaudia alyalaghile ava Yahudi vooni vabuuke ku Roma; ");
INSERT INTO wbi_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","U Paulo alikalile nakuvomba imbombo navene ulwakuva umwene ivomba imbombo jino jiling'ana ni jivanave. Avvene valyale vinosya ifivighili. ");
INSERT INTO wbi_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","U Paulo akapuling'ana navene munyumba ijakufunyila mufighono fyooni ifya sabati. Alyavavulile ava Yahudi palikimo nava Giriki. ");
INSERT INTO wbi_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Looli usauli nu Timotheo yevisile kuhuma ku Makidonia, u Paulo alyasung'ilue nu Mhepo kukuvolela ava Yahudi kuuti u Yesu ghwe Kilisite. ");
INSERT INTO wbi_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Unsiki ghuno valyan'kanile name kukunsyojola, pe u Paulo akakung'unile umwenda ghwa mwene pavulongolo pavanave, na kukuvavula, “Idanda jinu jive vwimila vwa matue ghiinu jumuie; Une nisila makole. Kuhumalino na kughendelela, nikuvalutila avapanji”. ");
INSERT INTO wbi_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pe akavuka kuhuma pala akaluta kunyumba ja Tito Yusto, umunhu juno ikunsuma u Nguluve. Inyumba jamwene jilipipi ni nyumba ja kufunyila. ");
INSERT INTO wbi_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","U Krispo, mulongosi ghwa nyumba ja kufunyila palikimo na vanhu avamunyumba ja mwene vakamwitika u Mutwa. Avanhu vinga kuhumakuhuma ku Koritho ye vapulike u Paulo ijova valitike nana kukwofghua. ");
INSERT INTO wbi_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","U Nguluve akam'bula u Paulo pakilo kusila ijambonekelo, “Nungoghopaghe, looli jovagha nungajikaghe Kimmie. ");
INSERT INTO wbi_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ulwakuva une nilipalikimo nuve, nakuale juno kumwa ighela kukunangania, ulwakuva nili navanhu vinga mulikaja ili”. ");
INSERT INTO wbi_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","U Paulo akikalile ukuo ku Niki ugwa mwaka ghumo na Messi n'tanda ye ivulanisia ilisio ilya Nguluve muvanave. ");
INSERT INTO wbi_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Looli u Galio akavombilue kuva n'temi ughwa ku Akaya, ava Yahudi vakima palikimo nhu Paulo na pikun'twala pavulongolo pakitengo ikya vuhighi, ");
INSERT INTO wbi_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","vakaati, “Umunhu uju ikuvahonga avanhu vifunyaghe kwa Nguluve kisila vutavike vwa ndaghhilo”. ");
INSERT INTO wbi_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Unsiki ghuno u Paulo ye ilonda kujova, u Galio akavavula ava Yahudi, “Umue mwe vayahudi, ndavule ilikosa au uvunangifi, jalejiva kyang'ani kuvavombela. ");
INSERT INTO wbi_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Looli ulwakuva ye maswali, ghano ghiling'ana na mansion namatavua kange ni ndaghilo sinu, kange muhighanaghe jumue mwevene. Une naninoghuananinoghua kuuti nive muhighi ghwa aghuo.” ");
INSERT INTO wbi_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","U Galio akavavula vavubuke pavulongolo pa kitengo ikyavuhighi, ");
INSERT INTO wbi_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mu uluo, vakan'kola u Sosthene, umulongosi ughwa nyumba ija kufunyila, vakan'tova pavulongolo pa kitengo ikyavuhighi. Looli ugalio nakoghwipe kino valya vombile. ");
INSERT INTO wbi_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","U Paulo, ye ikalile pala unsiki n'tali, akavaleka avanyalukolo pe akaluta ni Melissa ku Siria palikimo nu Prisila nu Akwila. Ye vakyale kuvuka ku bandali, alyaketile ilinyele lya mwene ulwakuva alijighile kuuti m'pesie. ");
INSERT INTO wbi_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ye vafikile ku Efeso, u Paulo alyamulekale u Prisila nu Akwila Pala, looli jujuo mwene akingila munyumba ijakufunyila nakupuling'ana na va Yahudi ");
INSERT INTO wbi_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ye vam'bulile u Paulo ikale navene unsiki un'tali, umwene akakanile. ");
INSERT INTO wbi_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Looli akavuka kuvanave, akavavula, “Nigomoka kange kulyumue, ulwakuuva vwevughane vwa Nguluve”. Apuo, akabuka ni Meli kuhuma ku Efeso. ");
INSERT INTO wbi_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","U Paulo ye imile ku Kaisaria, akatogha kuluta kuhungila inyumba imbaha inyimike ija kufunyila ija ku Yerusalemu, kange akika paasi panyumba imbaha inyimike ija ku Antiokia. ");
INSERT INTO wbi_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ye ikalile munsiki Pala, u Paulo alyabukile kukila ku fisala ifya Galatia na ku Frigia nakuvakangasia inumbula ava vulanisivua vooni. ");
INSERT INTO wbi_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Umu Yahudi jumo juno itambulivua Apolo, juno alyaholilue ukuo ku Alexandria, Akisa ku Efeso. alyale mfwihu kujova ni ngufu muvulembe. ");
INSERT INTO wbi_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","U Apollo akavulilue mu ndaghilo sa Mutwa. Ndavule alyale ni ngufu nu Mhepo, alyajovile nakuvulanisia vunofu ghano ghiling'ana nu Yesu, alyakaguile kuuti lwe lwofugho lwa Yohana. ");
INSERT INTO wbi_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","U Apolo akatengula kujova kuvukangafu munyumba imbaha inyimike ijakufunyila. Looli u Prisila nu Akwila ye vam'pulike, valyavombile uvumanyani nu mwene kange vakamwolelela ku kyanya musila ija Nguluve vunofu. ");
INSERT INTO wbi_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ye anoghilue kuvuka kuluta ku Akaya, avanyalukolo vakan'kangasia inumbula na pikuvalembela ikalata avavulanisivua vano valyale ku Akaya kuuti vamwupile. Ye afikile kulusungu alyatangile kyongo vala vano valyamwitike. ");
INSERT INTO wbi_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ku ngufu sa mwene Navarro manyani, u Apolo alyavakilile ava Yahudi pavwelu ye ivonesia kuhumila amalembe agha kuuti u Yesu ghwe Kilisite. ");
INSERT INTO wbi_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Lukale kuuti u Apologize ye aliku Korintho upaulo akakila ku kyanya na kufika kulikaja lya Efeso, pe akavonaakavona avavulanisivua vamo ukuo. ");
INSERT INTO wbi_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","U Paulo akam'bula, “Nde, mukamwupile uMhepo u Mwimike yemukitike?” Vakam'bula, “nambe, natulyapulike ndavule uMhepo u Mwimike.” ");
INSERT INTO wbi_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","U Paulo akaati, “lino umue mukofwighue ndani?” Vakaati, “Mulwofugho ulwa Yohana. ");
INSERT INTO wbi_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Kange uPaulo akamula, “U Yohana alyofwighe ulwofugho ulwa lulato. Akavavula avanhu vala kuuti mulondua kukumwitika jula juno ikwisa pa mwene, ndavule, u Yesu.” ");
INSERT INTO wbi_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Avanhu ye vapulike imola iiji, peva kofughua kulitavua lya Mutwa Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Lukale u Paulo yavikile amavoko gha mwene kuvanave, uMhepo u Mwimike Akita kuvanave pe akatengula kujova injovele kuviila. ");
INSERT INTO wbi_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Palikimo Avenue valyale avaghosi kijigho nava viili. ");
INSERT INTO wbi_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","U Paulo alyalutile kunyumba ijakufunyila akajova na Kun'kangasia amasiki gha meesi ghatatu. Alyale ilongosia kupuling'ana nakuvakwesa avaanhu vano valungime vwimila u vutua uvwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Looli ava Yahudi avange valyale vakali avange vano navikwitika, valyatengwile kujova amavivi kulungama musila ija Kilisite pavulongolo pa kipugha. Kange u Paulo akalekine na veene pe akavabaghula vano vikutika navene. Umwene akatengula kujova mufighono fyooni kuvukumbi uvwa Tirano. ");
INSERT INTO wbi_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ulu lulyaghendelile amaka gha viili, looli vonivoni valyle vikukala ku Asia valyapulike ilisio lya Mutwa, vooni ava Yahudi nava Yunani. ");
INSERT INTO wbi_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","U nguluve alyale ivomba imbombo mumavoko agha Paulo, ");
INSERT INTO wbi_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","kuuti avatamu valyavuvusivue, nu Mhepo umulamafu akavahuma, unsiki ghono valyalolile ikitambala namenda ghano ghakahumile mum'bili gha Paaulo. ");
INSERT INTO wbi_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Looli pevalyale ava Yahudi vano valyale vipunga uvupepo vikyula kukilila ikisala ikio, vakavombelagha ilitavua lya Yesu vwimila vuvanave vavuo. Valyavavulile vala kuuti valyale niili pepo ililamafu; vakaati, “Nikuvavula muhume mulitavua lya Yesu juno u Paulo ikun'dalikila.” ");
INSERT INTO wbi_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Vano valyaghavombile agha valyale vaana budika lubali vwa ntekesi umbaha ughwa kiyahudi, ni Skewa. ");
INSERT INTO wbi_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Amapepo amalamafu vakavamula, “U Yesu nun'kaguile, naju Paulo ni n'kaguile; looli umwe mwemue va veeni?” Jula umhepo umulamafu akavahadukila ");
INSERT INTO wbi_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","mun'kate mwa munhu ava punga vupepo na akavasinda ingufu na kukuvatova. Pe vakakimbilila kuhuma munyumba jila vakale sila Manda kange vakalemile. ");
INSERT INTO wbi_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ilio likakagulika ku vooni, ava Yahudi nava Yunani, vano valyale vikukala kuula ku Efeso. Valyale nuludwesi luvaha fiijo, nilitavua lya Mutwa likongelela kupulikika. ");
INSERT INTO wbi_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kange, vinga avaviitiki valisile nakulata kange vakasimilisia imbombo imbivi sino vakavombile. ");
INSERT INTO wbi_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Vinga valyale vivomba uvughanga vakakong'ania ifitabu fivanave, vakanyanya pa vulongolo pa munhu ghweni. Unsiki avene ye vavalile ulutalama lwa fiinu, lilyalelilyale fighavo fijigho fihano ifya ndalama. ");
INSERT INTO wbi_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pa uluo ilisio lya Mutwa likakwilana muvukome fiijo uvwa ngufu. ");
INSERT INTO wbi_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Isa Paulo kukwilana imbombo inofu ija mwene kula ku Efeso, u Mhepo akamulongosia kuluta ku Yerusalemu kukilila ku Makedonia naku Akaya; akaati, “Yekwene ukuo, jininoghile kujagha i Rumi.” ");
INSERT INTO wbi_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","U Paulo akavomola ku Makedonia avavulanisivua va mwene vaviili, Timotheo nu Erasto, vano valyale vikutanga. Looli umwene jujuo akajighe ku Asia mu nsiki. ");
INSERT INTO wbi_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Unsiki ughuo kukahumile ulunjughanjugha ulukome ukuo ku Efeso vwimila isiila jiila. ");
INSERT INTO wbi_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","U sonora jumo ilitavua lyamwene Demetrio, juno alyatendile ifihwan ifya ndalama ifya Nguluve Diana, alyaletile ifighusivua ifivaha kuvamang'anyi. ");
INSERT INTO wbi_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Pe akavakong'ania ava mang'anyi ava mbombo jila na kuuti, “Vagojo mukagwile kuuti mufighusivua ifii tukwingisia indalama nyinga. ");
INSERT INTO wbi_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mulola na kupulika kuuti, usue tuliapa pa Efeso, looli pipi ni Asia jooni, u Paulo uju avavulile na kuvashetulania avanhu viinga. Ijova kuuti kweghasili amanumbela Ghana ghavombilue na mavoko. ");
INSERT INTO wbi_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na kwekuuti kwelile ulutalaamu kuuti ifighusivua fiitu nafilonduagha kange, looli nii nyumba ija Nguluve ijakufunyila umama um'baha u Diana lunoghile kusyojola kuuti asita luvumbulilo. Kange anoghile asovile uvuvaha vwa mwene, juno i Asia ni iisi jikufunya kwa mwene.” ");
INSERT INTO wbi_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ye vapulike agha, vakamemile ni ng'alasi kange vakajeghela, vakaati, “U Diana ughwa Efeso ghwe m'baha.” ");
INSERT INTO wbi_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ilikaja lioni likamemile ulunjughanjugha, navanhu vakakimbila mun'kate muvukumbi uvwa luneno. Vakavakolile vano vikyula avanine nhu Paulo, u Gayo nu Aristariko, vano vakahumile ku Makedonia. ");
INSERT INTO wbi_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","U Paulo alyalondile kukwingila mukipugha kya vanhu, looli avavulanisivua vakan'sigha. ");
INSERT INTO wbi_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kange, avagoyo vamo ava kisina ava ku Asia vano valyale vamanyani va mwene vakantwalila imola inofu kungufu kukunsuma alike pikwingila muvukumbi uvwaluneno. ");
INSERT INTO wbi_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Avanhu vamo valyale viiti ikiinu iiki na vange ilisio lila, ulyakuva ikipugha kya vanhu kilyahasiling'ine. Vinga vavanave navakakagwile nambe kuuti nakiki valisile palikimo. ");
INSERT INTO wbi_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ava Yahudi vakantwala u Iskanda kunji kukipugha kya vanhu na pikum'bika pavulongolo pa vanhu. U iskanda akahumia ikidegho muluvok lwa mwene kuhumia uvwolesi ku vanhu. ");
INSERT INTO wbi_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Looli yeva kagwiile kuuti umene mu Yahudi, vooni vakajeghela ku lisio limo munsiki ghwa lmasala ghavili, “U Diana ghwe m'baha ughwa va Efeso.” ");
INSERT INTO wbi_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pa uluo umulembi ughwa likaja akanyamasia ikipugha, akaati, 'Umwe mwe vaghosi ava Efeso ghweveni Juno nakagwiile kuuti ilikaja lya Efeso juno ikolelela inyumba imbaha inyimike ijakufunyila ija Diana umbaha nikila ikihwani kino kikaghwile kuhuma kukyanya? ");
INSERT INTO wbi_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kulola kuuti amasio agha naghangakagulike, tulondua kuuti tuve Kimmie kange namungavombaghe kyooni ikya ng'aning'ani. ");
INSERT INTO wbi_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ulwakuva ulwakuva muvakemelile avanhu ava pa ndinde vano navaliasi ava nyumba imbaha inyimike ijakufunyila nambe navikum'beda u Nguluve ghwiitu un'dala. ");
INSERT INTO wbi_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ku uluo, ndavule u Demetrio na mang'anyi vano valipalikimo nu mwene valinamavoko vwimila vwa munhu ghweni, indinde si dindulivue navasikari pevale. Pe valetue pavulongolo pa highi. ");
INSERT INTO wbi_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Looli ndavule uve ungalonde kyekyoni kila ghusimilisa amasio aghange, ghivombua mukikalo ikya kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Sa kyang'ani tuluvivi ulwakuhighua vwimila ulunjughanjugha vwimila ulwa kighono iki. Kusiila lumonga ulwakunangika isi, kange nakwande tuva ningufu isa kwolelela. ");
INSERT INTO wbi_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ye ajovile agha, akapalasinie ifipugha. ");
INSERT INTO wbi_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ye Sisile injughanjugha, uPaulo akavakemelile avavulanisivua na kuva kangasia inumbula. ");
INSERT INTO wbi_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kange akavalagha na kuvuka kuluta ku Makedonia. Umwene ye akilile ku kisina ikio alyale ikuvakangasia inumbula avitiki, pe akingila ku Yunani. ");
INSERT INTO wbi_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pa uluo umweene kuuti akale pala kunsiki ghwa mesi gha tatu, ikikosi kikavombilue kwakwa mwene nava Yahudi alyale pipi ku kyula kuku sila ija nyaja kuluta ku Shamu, pe akam'bula kugomoka kukila ku Makidonia. ");
INSERT INTO wbi_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Vano valyale kiinu kimono nu mwene kuluta ku Asia valyale u Sopatro, umwana ghwa Pirho kuhuma ku Berea; u Aristario nu Sekundo, vooni kuhuma kuvitiki ava ku Thesalonike; u Gayo ughwa Derby; u Timotheo; Tikiko nu trofimo kuhuma ku Asia. ");
INSERT INTO wbi_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Looli avanhu valonguile pe valiale vikutughula ku Throa. ");
INSERT INTO wbi_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Musila ija nyanja kuhuma ku Filipi mu fighono ifyaifya makate ghano naghakabikilue ikilule, mu fighono fihano tukavafikile ukuo ku Troa. Tulikalile ikuo mufighono ifya budika lubale. ");
INSERT INTO wbi_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ikighono ikya kwanda ikya nyambaha, yetukong'anile palikimo kumenyula un'kate, u Paulo akajovile navitiki. ");
INSERT INTO wbi_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Akale ijova kuvuka pakilavo, pe akaghendelela kujova mukilo imbaha. Pe kulyale italaitala nyinga kukyimba ikya kukyanya kino tukakong'anile palikimo. ");
INSERT INTO wbi_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mulidilisha akikalile un'soleka jumo juno ilitavua lya mwene Utiko, juno kale ni tuulu imbaha. Kange u Paulo alyale idalikila mu nsiki u n'tali, unsoleka uju, akaghonelile, pe akaghua pasi kuhuma ku gholofa ija vutatu vakamwagha afuile. ");
INSERT INTO wbi_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Looli u Paulo akika pasi, akagholosia jujuo mwene, akan'kola kange akaati. Kange akaati, “Namungakatalaghe, ulwakuva mwumi.” ");
INSERT INTO wbi_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kange pe akatogha ku gholofa na kumenyula un'kate, pe akalia. Ye ajovile navene kunsiki untali hadi palwakilo, pe akavuka. ");
INSERT INTO wbi_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Vakantwala un'soleka jula alyale mwumi pe vakatengaana fiijo. ");
INSERT INTO wbi_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Usue jusue tukalongwile kuvulongolo pa Paulo ni meli nakuluta ku Aso, pano usue tukamwile kuntola u Paulo ukuo. Iki kyekino umwene jujuo alyalondile kuvomba, ulwakuuva akamwile kukla iisi jino jumile. ");
INSERT INTO wbi_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ye atufikile ukuo ku Aso, tukampakilatukampakila mu meli tkaluta ku Mitilene. ");
INSERT INTO wbi_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kange usue tukabukile kuhuma ukuo ikighono ikya vuvili tukafikile ulubale ulwa vuvili ulwa kiponge ku Kio. Ikighono kino kikwisa, tukafikile ku kiponge ikya Samo, ikighono kino kikwisa tukafikile kulikaja ilya Mileto. ");
INSERT INTO wbi_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ulwakuva u Paulo alya lamuile ku kkyula kuhumila ku Efeso, ulwakuti nangatumilaghe nambe unsiki ghwene mu Asia; ulwakuva alyale ng'aning'ani ija kwangupa ku Yerusalemu vwimila uvwa kikulukulu ikya pentekoste, ndavule lukanoghiile kuvomba anala. ");
INSERT INTO wbi_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kuhuma ku Mileto akomola avanhu kuluta ku Efeso pe akavakemele avaghogholo ava mu nyumba ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ye vafikile kwa mwene, akavavula, umue mwe veene mukagula ndavule ikighono ikya kwanda ye nisile apa pa Asia, ndavule nikale kulyumue ifighono fyooni. ");
INSERT INTO wbi_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nimbombile u Mutwa mu vukalo vwooni namahosi, nimumuko sino sinyaghile une ni gila ija va Yahudi. ");
INSERT INTO wbi_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mukagula kuuti nanikisighile kupulisia kulyumue ikinu kyoni kila kino kilyale kinofu. ndavule une nilyavavulanisie pa vuelu kange kuluuta inyumba ni nyumba. ");
INSERT INTO wbi_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mukaguka kuuti une nikaghendelile kukuvavula ava Yahudi nava Yunani mululato ulwa Nguluve nu lwitiko ulwa Mutwa ghwitu Yesu. ");
INSERT INTO wbi_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Lino, lolagha, une, pano nikumwitika uMhepo u Mwmike kuuta ku Yerusalemu, nanikagula nambe agha ghano ghikunihumila une ukuo, ");
INSERT INTO wbi_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ulwakuva uMhepo u Mwimike ikunyolela une mulikaja kange ijova kuuti amanyololo ni mumuko fyefino fikunighula une. ");
INSERT INTO wbi_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Looli une nanikasaghile kuuti uvukalo vwaango kusila jooni ija lutalaama lwango, neke nimale ulughendo lwango kumbombele inofu jino nilyupile kuhuma kwa Mutwa Yesu, kukwolela ilivangili lyalusungu lwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Lino, lolagha, nikagula kuuti mweeni vooni, mun'kate muvalamuvala muno nikalutile kuvadalikila uvutua, namungavwaghe kange vweni. ");
INSERT INTO wbi_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ku uluo nikuvolela umusyughu iji, kuuti nisiila n'kole mudanda ija muunhu ghweni. ");
INSERT INTO wbi_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ulwakuva nanikasaghile kuuva pulisiia uvughane vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mu uluo muve valoleli vwimila vwiinu jumue mwevene, nakukipugha kyooni kino uMhepo Mwimike avavikile umue kuva valoleli. Muve valoleli kudima ikipugha ikya Mutwa kino alyaghulile ni danda jamwene jujuo. ");
INSERT INTO wbi_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nikagula kuuti kuvuuka kulyune, ing'eve ing'ali sikwingila kulyumue, kange navangakisaghilaghe ikipugha. ");
INSERT INTO wbi_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nikagula kuuti kange mu vamo mulyumue jumue avaanhu vaamo vikwisa nakujova ghano mavivi, Neke kukuvakwesa avavulanisivua vavafwataghe avene. ");
INSERT INTO wbi_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ku uluo muve maso. Mukumbukaghe kuuti amaka ghatatu nanikabuhilile kukuvavulanisia umuunhu ghweni mulyumue namahosi pakilo na pamwisi. ");
INSERT INTO wbi_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Lino une nikuvatola kwa Nguluve, na kulisio ilya lusungu lwa mwene, lino likuvanosia napikuvapela uluhombo palikimo aveene vooni vano vapakilue kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nanikanoghilue indalama, sahabu, nambe amenda. ");
INSERT INTO wbi_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mukagula jumue mwe veene kuutikuuti amavoko agha ghanipelile ifipelua fyango ne mwene kaange ifipelua ifyavala vano vakale palikimo nune. ");
INSERT INTO wbi_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu aghuo ghooni nikavapelile ikihwani kino ndavule kinoghile kukuvatanga vano vasila ngufu isa kuvomba imbombo, ndavule jinoghile kukumbuka amasio gha Mutwa Yesu, amasio ghano ajovile umwene jujuo: “Kiba kuhumia kukila kukwupila.” ");
INSERT INTO wbi_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ye ajovile anala, akafughama akifunya palikimo naveene. ");
INSERT INTO wbi_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Vooni vakalila fiiojo na pakumughwila u Paulo ku singo napikumunonela. ");
INSERT INTO wbi_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Vakakaalile fijo kughoni ulwakuva kila kino akajovile, kuuti navili kuvwagha kange uvweni vwa mwene. Kange vakamuhingilisie ku Merikebuni. ");
INSERT INTO wbi_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Unsiki ghuno tukalekine navene, tukyula ku nyanja, tukafikile mulikaja ilya Kosi, ikighono kinokikafikile mu likaja lya Rodo, na kuhuma ukuo tukafikile mulikaja lya Patara. ");
INSERT INTO wbi_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ye tupatile i meli jinojino jilovoka kuluta ku Foinike, tukapandile na kukyula. ");
INSERT INTO wbi_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ye tufikile pavulongolo pa kiponge ikya Kipro, tukajilekile ulubale ulwa ng'ighi, tukakyula kuluta ku Siria, tukima mulikaja ilya Tiro, ulwakuva ukuo kwekuno imeli jikale jipakilvue ishehena ja mwene. ");
INSERT INTO wbi_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ye avavuene avavulanisivua, tukikala ukuo ifighono budika lubale. Ava vulanisivua avaava vakam'bula u Paulo kukilila uMhepo kuuti umwene nangisaghe ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ye visile ifighono fila, usue tukabuka kuluta kulyusue. Vooni palikimo, nava mama vavanave palikimo navaana vavanave, vakatuhingilisie musila siitu yeye tuhumile kunji kulikaja. Kange tukafughama ku pwani, tukifunya, tukalaghine tweeni. ");
INSERT INTO wbi_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Tukapandile imeli, kuno avenge vigomoka kange kunyumba sivanave. ");
INSERT INTO wbi_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kange ye tumalile ulughendo lwitu kuhuma ku Tiro, tukafikile ku Tolemai. Pala tukahungile avanyalukolo na pikukala na vene kighono kimo. ");
INSERT INTO wbi_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ikighono kino kikwisa tukabukile tukalutile ku Kaisaria. Usue tukingile munyumba ja Filipo, undaliki ughwa livangili, juno alyale jumbo vava budika lubale, najusue tukikala palikimo nu mwene. ");
INSERT INTO wbi_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Umuunhu uju alyale navahinja vano vakavilagha. ");
INSERT INTO wbi_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ye ikalile ukuo ifighono n'diiki, akika kuhuma kuvu Yahudi um'biili jumo juno itambulivua Agabo. ");
INSERT INTO wbi_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Umwene akisile kulyusue akatola ukanda ghwa Paulo. Ku uluo akipinya amaghulu nana mavoko gha mwene jujuo akaati, “U Mhepo u Mwitike iiti ndiiki,” “Ava Yahudi ku Yerusalemu vikupinya u muunhu juno itema ukanda ughu, voope vikupela mumavoko gha vaanhu avapanji.” ");
INSERT INTO wbi_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ye tum'pulike amasio agha usue navaanhu vano vakale vikukala pala tukam'bula u Paulo aleke pitogha kuluta ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pe u Paulo akamula, “Muvomba kiki, mulila na kudenyania inumbula jango? Ulwakuva niling'anisie, nambe kukungua kweene, looli kange kufwila ukuo ku Yerusalemu vwimila vwa litavua ilya Mutwa Yesu.” ");
INSERT INTO wbi_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ulwakuva u Paulo nakale ilonda kuvulua, tukabuhilile na kujoova, “kange uvughane vwa Mutwa vuvombike.” ");
INSERT INTO wbi_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ifighono ifi, tukatolile amafuko ghitu nakuluta ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Avavulanisivua vamo kuhuma ku Kaisaria tukafwatine nusue. Vakan'twala umuunhu jumo juno itambulivua Mnasoni, muunhu ghwa ku Kipro, um'bulanisivua ghwa pakali, juno tulikalile palikimo. ");
INSERT INTO wbi_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ye tufikile ku Yerusalemu, avanyalukolo vakatuupile nulukelo. ");
INSERT INTO wbi_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ikighono kino kikwisa u Paulo akalutile palikimo nusue kwa Yakobo, nava ghogholo vooni vano pevakale. ");
INSERT INTO wbi_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ye tuhungile, akavapela imola jino ye jikyale ijinge amasio ghano uNguluve alyavombile mu vanave mu vapanji kuhumila mumbombele inofu ijaija ija mweene. ");
INSERT INTO wbi_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Unsiki ye vam'pulike agha, vakam'pala u Nguluve, pe vakam'bula, “Ghulola, nyalukolo kweghale amaelufu ghalingi vitiike muvala muva Yahuhudi. Aveene Vooni valinuvufumbue uvwakukola indaghilo. ");
INSERT INTO wbi_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Vavulilue kusimilisivua uve, kuuti ghu vulanisia ava Yahudi vino vikukala pakate pavapanji kulekana nu Musa, kuuti ghukuvavula vano navakekile avaana vavanave, kangekange navangafwataghe injio isa kali. ");
INSERT INTO wbi_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tunoghile tuvombe kiki? Vikagula kuuti vipulika uve ghwisile. ");
INSERT INTO wbi_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Lino vombagha kino usue tukukuvula: tuulinavoope vaanhu vane vano vavikile ulujigho. ");
INSERT INTO wbi_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Vatole avaanhu ava pe ghuvalasie ghwe mwene palikimo navene, pe uvahombele ighalama savanave, neke vakeete amatue ghavanave. Mu uluo umuunhu jumo akagule kuuti ghano gha vombilue vwimila uve gha vudesi. Vamanyile kuuti uve ghugadilile indaghilo. ");
INSERT INTO wbi_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Looli imola isa vapanji vaano viitiki, tulyalembile na kuhumia ululaghilo kuuti vanoghile kukujileka ni fiinu fino fihumisivue mumatekelo agha fihweni, ni danda, kuhuma ni kila kino kinyongilue, kange vavulekaghe uvuvafu.” ");
INSERT INTO wbi_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pe pano, u Paulo akavatoola avaghosi, ikighono ikyavuvili, akinosisie jujuo palikimo na veene, akingila mu nyumba imbaha inyimike ijakufunyila, kupulisia unsiki ughwa kighono ikyakuvavulanisia na lilitekelo lihumisivue vwimila umuunhu ghweni ughwa vanave. ");
INSERT INTO wbi_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ifighono fila ifya budika lubale ye flipipi kusila, ava Yahudi vamo kuhuma ku Asia vakamwaghile u Paulo mu nyumba imbaha inyimike ija kufunyila, namapugha vakakalala, kange vakamugholokesia amavoko. ");
INSERT INTO wbi_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Valyale vijeghela, “Avaanhu ava ku Israeli, mututange, uju ghwe muunhu jula juno ivulanisia avaanhu kwooni amasio ghano gha pungine na vaanhu, indaghilo pano tulipuo apa. Kange avaletile ava Yunani mu nyumba inyimike ijakufunyila na piku panyasia apa pa vwimike.” ");
INSERT INTO wbi_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ulwakuva pavwasio valyale vamwaghile u Trofimo mu Efeso alyale nu mwene palikimo kulikaja, aveene vyalale viiti u Paulo akan'twala ku nyumba imbaha inyimike ija kufunyila. ");
INSERT INTO wbi_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ilikaja lyooni lilyale nuludegho, na vaanhu vakakimbiila palikimo na ku n'kola u Paulo. Vakamumia kunji mu nyumba imbaha ijakufunyila, kaange amalyango ghakadindua. ");
INSERT INTO wbi_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ye valyale vighela kukum'buda imola sikam'fikila um'baha ghwa kipugha ikya valoleli kuuti i Yerusalemu jooni jilyale jimemile ulunjughanjugha. ");
INSERT INTO wbi_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Pa uluo akavatola avasikari nava jemedari akakimbilila ikipugha. Unsiki ghuno avaanhu ye vamwaghile um'baha ughwa valoleli navasikari, vakamuleka kun'tova u Paulo. ");
INSERT INTO wbi_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kange um'baha ghwa kipugha ye alipipi akan'kosa u Paulo, pe akalaghila akungue namanyololo mu m'biili. Akam'posia umwene kaange ghwe veeni kange ghwe veeni avombile kicking. ");
INSERT INTO wbi_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Vamo avaanhu mukipugha valyale vilalatila ikiiinu iiki navange ikinge. Ulwakuva u jemedari naghelile kukuvavula ikinu kye kyoni kila ulwakuva lwa njeghelo sila, akalaghila u Paulo ise munkate mu lilinga. ");
INSERT INTO wbi_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kange ye afikile pa ngasi, pe akatolua nu nsikari ughwa kipugha vwimila uvwa lunjughanjugha. ");
INSERT INTO wbi_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pe ikipugha kikam'bingilila na kughendelela ni njeghelo, “M'busie uju!” ");
INSERT INTO wbi_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","U Paulo ye itwalua munkate mu ngome, akam'bula um'baha ghwa kipugha, “Lunoghile kukum'bula ikinu?” Um'baha jula ughwa kipugha akaati, “Ghujova ikii Yunani? ");
INSERT INTO wbi_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Asi, uve naveve mu Misri juno pavutengulilo alongosia uvugalusi kaange atoola avalugu imbilima shine kulukuve?” ");
INSERT INTO wbi_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","U paulo akaati, “Une nili Muyahudi kuhuma mulikaja ilya Tarso ilya ku Krikia. UneUne nili muholua ghwa likaja lino litanbulike. Nikuvasuma, munitavule nijove na vaanhu.” ");
INSERT INTO wbi_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Unsiki ghuno u jemedari atavwile, u Paulo Akiva pa ngasi akahumia indaghilo ku vaanhu kuluvoko lwa mwene. Unsiki ghuno ghukalilime fiijo pe akajova navoope kuki Hebrania. Akaati, ");
INSERT INTO wbi_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Vanyalukolo kange nava Nhaata vaango, pulikisiagha uvwolesi vwango vuno kwande nivomba kulyumue un'siki ughu.” ");
INSERT INTO wbi_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ifipugha ye fifikile u Paulo ajoova navoope ku ki Ebrania, vakajika. akaati, ");
INSERT INTO wbi_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Une nili Muyahudi niholilue mulikaja lya Tarso mukighavo ikya Kilikia, kuva nilyapatile uluhara mulikaja iili, une nili m'bili ghwa Nguluve, ndavule umue mwe Vooni fino mulivuo umusyughu. ");
INSERT INTO wbi_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nikavapumwisie musila iji m'paka pano mufua; nikavakunga ava ghosi nava mama na kuvatagha mu ndinde. ");
INSERT INTO wbi_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kange untekesi um'bahaum'baha navaghogholo vooni vavaghile kuhumia uvwolelesi kuuti nilyupile ikalata kuhuma kuvanave vwimila vwa nyalukolo vano valyale ku Dameski, kulyune une kughenda kuluta ukuo. Ulwakuuti nivalete avaanhu ku Yerusalemu ava similar jiila ulwakuuti va kungue na kutovua. ");
INSERT INTO wbi_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Lulyahumile kuuti paala pano nilyale nighenda ye siseghelile ku Dameski, un'siki ughwa pamwiisi nakalingi ulumuli uluvaha lukamulika ku kyanya lukatengula ku mulika. ");
INSERT INTO wbi_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nikaghua paasi nakupulika ilisio likum'bula,'Sauli, Sauli kiki ghukung'alasia?' ");
INSERT INTO wbi_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nikamula, 'Uve veve veeni, Mutwa?' Akambuula, 'Une nene Yesu Mnazareti, juno uve ghukung'alasia.' ");
INSERT INTO wbi_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Vala vano valyale nune valyaluvwenevalyaluvwene ulumuli, looli navalyapulike ilisio lya jula juno alyajovile nune. ");
INSERT INTO wbi_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nikaati, 'Nivombe kiki, Mutwa?' u Mutwa akam'buula, “Imagha ghwingilaghe mu Dameski; ukuo ghuvuluagha kila kiinu kinokikunoghile pivomba. ");
INSERT INTO wbi_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nilyakunilue kukola vwimila lwa lumuli Lula, pe nikaruta ku Dameski nilongosivue na mavoko ghavala vano vakale nune ");
INSERT INTO wbi_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ukuo pe nikatang'ana nu muunhu juno itanbulua Anania, alyale muunhumuunhu juno alyagadilile indaghilo kange akoghopagha pavulongolo pava Yahudi voonivooni vano vakikalagha ukuo. ");
INSERT INTO wbi_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Akisa kulyuune, akiima pavulongolo palyuune na kuuti, 'Nyalukolo ghwaango Sauli, lolagha. 'Ku nsiki ghulaghala nikam'bwene. ");
INSERT INTO wbi_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Akaati, Nguluve ghwa va Nhaata viitu akusalwiile uve ukagule pikagula uvughane vwa mwene, pikumwagha jula unya vwa kyang'ani, nakupulika ilisio lino lihumile mumulomo ghwa mweene. ");
INSERT INTO wbi_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ulwakuva ghuuva mwoolesi kwa mweene ku vaanhu voonivooni ku sooni sino usivweene na kupulika. ");
INSERT INTO wbi_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lino kiki ghughulila? Sisimuka, Ghwofughue, usuke uvuhosi vwaako ghukulikemela ilitavua lya mweene.' ");
INSERT INTO wbi_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ye nigomwike ku Yerusalemu, pano nilyale nikufunya n'kante munyumba inyimike ija kufunyila, lulyahumile kuuti nipelilue iyivonelo. ");
INSERT INTO wbi_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nikam'bona akambuula, 'Angupa uhume mu Yerusalemu ng'haning'hani, ulwakuva navangitike uvwolesi vwako vwimila une.' ");
INSERT INTO wbi_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikaati, 'Mutwa, avene vavuo vikwelevua nikavakungile mu ndinde na kuvatola vano valyakwiitike mu nyumba sooni isa kufunyila. ");
INSERT INTO wbi_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na ji danda ija Stefano umwoolesi ghwako pano jilyakungilue, une najune nilyimile pipi na pikunda kulolelela amenda ghavano valyam'budile. ");
INSERT INTO wbi_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Looli akanivula, 'Lutagha, ulwakuva une nikukwomola ulute kuvutaali ku vaanhu avapanji.” ");
INSERT INTO wbi_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Avaanhu vakatavula ajove ilisio iili. Looli vakapalisia ilisio nakujova, “Mum'busie umuunhu uju mu iisi: ulwakuva nalunono ikalaghe.” ");
INSERT INTO wbi_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ye vipalisia ilisio, vakatagha Amanda ghavanave kange vakatagha mu king'unde, ");
INSERT INTO wbi_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","u jemedari um'baha akalaghila u Paulo iise ku lilanga. Akalaghila aposevue kuno ikopua ifiboko, kuuti umwene jujuo akagulr kuuti nakiki vikun'jeghelela anala. ");
INSERT INTO wbi_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kange yevan'kungile nu lughoji, u Paulo akam'bula u akida Julia juno akimile piping nu mwene, “kyang'haani kukun'tova umuunhu juno Murumi nambe nahighilue?” ");
INSERT INTO wbi_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","U akida jula ye apulike amasio agha, akaluta kwa jemedari um'baha na pikum'bula, akaati, “Ghulonda kuvomba kiki? Ulwakuva umuunhu uju Murumi.” ");
INSERT INTO wbi_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Um'baha ghwa vasikari akisa na pikum'bula, “Nivuule, uve nuli m'banda ghwa Rumi?” U Paulo akaati, “Ena.” ");
INSERT INTO wbi_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","U jemedari akamula, “Kuilila indalama im'baha pe nikupile uvu m'bada.” looli u Paulo akam'bula, “Une nili Murumi ghwa kuholua.” ");
INSERT INTO wbi_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kange nava liling'aniaghe kuluta kukum'posia pe vakabuuka na pikumuleka unsiki ghughughuo. U jemedari ghwope akoghopa, yeye akagwile kuuti u Paulo Murumi, ulwakuva an'kungile. ");
INSERT INTO wbi_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ikighono kino kikavingilile, u jemedari um'baha akalondagha kukagula uvwakyang'haani vwimila amakole aghaagha va Yahudi mwa Paulo. Pe akam'busia ifipinyilo fya mwene akalaghila ava vaha va matekelo na vahighi Vooni vatang'ane. Akatwala u Paulo paasi, na pikum'bika pakate na kati pavanave. ");
INSERT INTO wbi_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","U Paulo akavalola ghanila avaanhu avahighi na kujova, “Vanyalukolo vango, nikalile pa vulongolo pa Nguluve nu vufumbue uvunofu mpaka umusyughu iji.” ");
INSERT INTO wbi_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Un'tekesi um'bahaum'baha akavalaghila vala vano vakimile pipi nu mwene van'tove umulomo ghwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pe u Paulo akam'bula, “U Nguluve ikukutova uve, uluvumba luno luvikilue ilikeji. Ghu kalile ghukunihigha nindaghilo, ghulaghila nitovue kinyume nhi ndaghilo?” ");
INSERT INTO wbi_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Vala vano vakimile pipi nu mwene vakaati, “Anala pe ghukumuligha u n'tekesi um'baha ghwa Nguluve?” ");
INSERT INTO wbi_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","u Paulo akaati, “Vanyalukolo vango, une nanikagwiile Kati uju ghwe n'tekesi um'baha. Ulwakuva lilembilue naghujova fiivi kwa ntemi ughwa vaanhu vaako.” ");
INSERT INTO wbi_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","U Paulo ye alolile ulubale lumo ulwa vahighi veva Masadukayo navange va Mafarisayo, akapalisia ilisio na kuuti, “Vanyalukolo vango, une nilii Mufarisayo, mwana ghwa Mufarisayo. Ulwakuuva nihuvila uvukangafu uvwa kusyuuka kuva fue vano nihighana naveene.” ");
INSERT INTO wbi_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ye ajovile isi, imikuno im'baha sikahumila pakate pa avatar Mafarisayo na Masadukayo, ni kipugha kika ghaving'ine. ");
INSERT INTO wbi_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nakiki ava Masadukaya vijova kuuti uvusyuke kwevusili, avanyamola vala nakwejili inhumbula, kange avatar Farisayo viiti aghast ghooni kweghale. ");
INSERT INTO wbi_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ulunjughanjugha uluvaha lukahumila navamo avalembi vanovakale ulubale lwa Mafarisayo vakima nana kujova, “Natulolile ikinu kyekyoni kila ikivivi mwa muunhu uju. Ndani umhepo nambe unyamola ajovile nu mwne?” ");
INSERT INTO wbi_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Unsiki kukahumile ilisaghe ilivaha, um'baha ghwa kipugha akoghopa kuuti u Paulo ademulinie ifighavefighave na veene, pe akalaghila ifipugha fiike paasi na kukun'tola ni ngufu kuhuma kwakwa nyamola avavahighi, na pikutwala mu lilinga. ");
INSERT INTO wbi_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ikilo jino jikavingilile u Mutwa akimile pipi nu mwene na kuuti, “Nungoghopaghe ulwakuva nivolelilile Muyerusalemu, pe ghuhumia uvwolesi kange mu Roma.” ");
INSERT INTO wbi_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ye kukile, ava Yahudi vamo vakavombile ulufingo nakukemela ulughuno vwimila vuvanave vavuo: vakajovile kuuti navililia nambe kunyua kyekyoni kila m'paka vam'bude u Paulo. ");
INSERT INTO wbi_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kwevalyale avaanhu fijigho fine vano vakagohile isi. ");
INSERT INTO wbi_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Vakaluta kuvavaha ava matekesi nava sehe na kujova, “Tuvikile jusue mulughuno uluvaha, natungalisaghe kyekyoni kila m'paka pano tukum'buda u Paulo. ");
INSERT INTO wbi_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kange lino, um'baha ghwa n'sikari avavula avahighi vantwale kulyumue, kwekuuti mulamule un'kole ghwa vunofu. UsueUsue kulyusue tuning'anisie kukum'buda ya kyale kukwisa apa.” ");
INSERT INTO wbi_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Looli umwana ghwa nuna ghwa mwene nu Paulo akapulika kuuti kukale ni njama, akaluta akingila mun'kate mulilinga na pikum'bula u Paulo. ");
INSERT INTO wbi_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","U Paulo akan'kemela u akida jumbo akaati, “Mun'tole unsoleka uju um'baha ghwa va n'sikari; ulwakuva ali nilisio ilya kum'bula.” ");
INSERT INTO wbi_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kange u akida akantoola un'soleka jula akatwala kwa m'baha ghwa va n'sikari akambula, “U Paulo jula un'kungua akang'emelile akalondagha nin'twalile un'soleka uju kulyuve. Ali nili sio ilya kukuvula.” ");
INSERT INTO wbi_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Um'baha Julia ughwa va n'sikari akan'kola nuluvoko akibaghuile akima mwene, pe akam'posia, “kiinu kiki kino ghulonda kukum'bula?” ");
INSERT INTO wbi_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Un'soleka jula akaati, “ava Yahudi vapuling'ine kukun'suma atwale u Paulo pakilavo kuvahighi ulwakuti vilonda kukwupila imola sa mwene ku vunnofu fiijo. ");
INSERT INTO wbi_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Looli uve nungitikaghe ulwakuva avaanhu fijigho fiine vikumwuvila. Vikungile nulughuno, Navangalisaghe kange navanganywisaghe nambe kyavikum'buda. Nambe lino viling'anisie, vighulila uvutavike kuhuma kuvanave.” ");
INSERT INTO wbi_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kange um'baha ghwa va n'sikari akamuleka un'soleka alutaghe, ye amulaghisie “Nungam'bulaghe umuunhu ghweni kuuti univulile aghast.” ");
INSERT INTO wbi_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Akavakemela ava masinjala vaviili akaati valing'anie ava sikari filundu fivili valute ku Kaisaria navasikari avangulila farasi ifijigho lekela lubale nava nyamalala filundu viviili, muvuka mukipugha ikya vutatu. ");
INSERT INTO wbi_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Akavavula valing'anie ifidimua fiino u Paulo ivombela na kukuntola vunufu kwa Feliki Gavana. ");
INSERT INTO wbi_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Akalemba ikalata anala, ");
INSERT INTO wbi_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","U Klaudio Lisa kwa n'sikari Feliki, luhungilo. ");
INSERT INTO wbi_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Umuunhu uju akakolilue nava Yahudi pipi pikum'buda, pe nikaluta nikipugha ikya va sikali nikamwavula, ye nipatile imola kuuti umwene vukalo uvwa Kirumi. ");
INSERT INTO wbi_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nikalondile kukagula nakiki vamighile, pe nikantwala kuvahighi. ");
INSERT INTO wbi_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nikalolile kuuti alyale ihighua vwimila vwa maswali agha ndaghilo sivanave, nambe nakahighilue iilisio lyolyoni na kulondua kubudua nambe kukungua. ");
INSERT INTO wbi_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kange lumanyikika kulyune kuuti kwelule ulughelo kulyune pa uluo pe nikamwomuile ng'aning'ani kulyuve, kange valetaghe sino vamusitakile vano vikusitaka kange vatwale amakole gha mwene pavulongolo palyuve. Vakahwesania.” ");
INSERT INTO wbi_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Looli ava sikali vakaleva indaghilo: vakan'toola u Paulo vakan'twala kange ku Antipatri pakilo. ");
INSERT INTO wbi_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ikighono kino kikavingilile, ava sikali vinga vakavaleka vinga valavala avapanda farasi valute palikimo nu mwene, voope vakagomoka ku lilinga. ");
INSERT INTO wbi_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Navapanda farasi ye vafikile ku Kaisaria, nakum'pela un'sikari ikarata jila, vakam'biika u Paulo pavulongolo pa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ghwope untua ye imbile ikalata, Adam'posia u Paulo jihumile kukighavi kiliku; ye akagwile kuuti muunhu ghwa ku Kilikia, ");
INSERT INTO wbi_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akaati, “Nikukupulika uve pano vikwisa Valarie vano vakuhighile,” akalaghila avikue mu ikulu ja Herode. ");
INSERT INTO wbi_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mu fighono fihano, u Anania u n'tenkesi um'baha, avaghogholo vamo nu njovaji jumo juno itambulua Tertulo, vakaluta palapala. Avaanhu vala vantwalile amakole kange kwa Paulo ughwa Gavana. ");
INSERT INTO wbi_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","U Paulo ye imile pavulongolo pa gavana, u Tertulo akatengula kukumuhigha na kujova kwa gavana, “Ulwakuva tuli nulutengano uluvaha; namumbonekelo sako sileta amaghendelelo mannono mulikaja litu; ");
INSERT INTO wbi_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","kange nulusungu lwooni tukwupila ikiinu kyoni kino ghu vomba, vuhungile vwa mwoghopua Feliki. ");
INSERT INTO wbi_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Looli naningakugasie kyongo, nikukupelepesia umulike amasio amadebe nu vukola vwako. ");
INSERT INTO wbi_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ulwakuva tum'patile umuunhu uju umbivi ikuvapelea ava Yahudi vooni vagaluke mu iisi, kange mulongosi ghwa kipuugha kya Nazorayo. ");
INSERT INTO wbi_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kange ukaghele kuponia inyumba imbaha inyimike ijakufunyila uvulamafu pe tukan'kola, namweule munakala inofo isa pa kali. ");
INSERT INTO wbi_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lisiasi, um'baha akisa na pikun'tola mu ngufu sa mavoko ghiiti, namwule mu nakala innofu isa malembe agha kali. ");
INSERT INTO wbi_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ungam'posie u Paulo vwimila ghwa masio agha, kange lunoghile kufuala ikinu kiki kino tumuhighile.” ");
INSERT INTO wbi_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ava Yahudi voope vakamuhigha u Paulo, vijova kuuti amasio agha ghakale gha kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","U n'sikali ye agholwisie uluvoko kuuti u Paulo ajove, u Paulo akamula, “Nikagula kuuti amaka minga ulimulamuli ghwa kisina iki, nilinulukelo kukwolela june kulyuve. ");
INSERT INTO wbi_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Uvaghile pikulutang'ania kuuti nafikilile ifighono kukila ifighono fijigho na fivili kuhuma pano nikatoghile kuluta kukufunya ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vakaati vabwene munyumba inyimike ijakufunyila, nanikakaning'ine nu muunhu nambe jumo, nanikavombile uvugaluli mu kipugha, nambe munyumba isa kufunyila nambe mulikaja; ");
INSERT INTO wbi_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","nambe navanoghile kusimilisia kulyuve amasitaka ghano vikusitaka vwimila une. ");
INSERT INTO wbi_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kange ni kuvitika, kuuti musila jila jino vikemela muli sehebu, musila jijio nikim'bombela u Nguluve ughwa va Nhaata viitu. Une nilin'kola mughoni ghano ghali mundaghilo na mumalembe agha vaviili. ");
INSERT INTO wbi_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nili nu lukangasio lulalula kwa Nguluve juno nambe vala na vene vighulila, kukwisa kuvusyuke uvwa vafue kuvooni ava kyang'ani nambe navano navalivwakyang'ani; ");
INSERT INTO wbi_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","na kuiili, ni vomba imbombo ulwakuuti nive nuluvelo ulusita n'kole pa maaso gha Nguluve na pavulongolo pa vaanhu kukilila agha ghooni. ");
INSERT INTO wbi_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Lino mu maka minga nisile ku twala ulutangilo mu kisina kyango nu luvelo ulwa ndalama. ");
INSERT INTO wbi_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ye nivombile ndiki, ava Yahudi avange vakamwene mun'kate mu kikulukulu ikya kuvalasia mun'kate mu nyumba inyimike, nambe kipugha kya vaanhu kisila lunjughanjugha. ");
INSERT INTO wbi_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Avaanhu ava lunoghile kuuva pavulongolo palyuve linolino vajove kila kino valinakyo vwimila vwango ndavule pano valinilisio lyelyoni. ");
INSERT INTO wbi_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kange avaanhu ava vavuo vajove u n'kole ghuliku ghuno vaghwaghile kulyune ye nimile pavulongolo pa vuhighi uva Kiyahudi; ");
INSERT INTO wbi_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","nambe vwimila vwa kinu kimo kino nikajovile nhi lisio ye nimile pakate nakati pavanave, 'Ulwakuva uvusyuke vwa vafue umue mukunihigha.” ");
INSERT INTO wbi_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","U Feliki akavulilue vunofu vwimila isila, akakileka ikipugha. Akaati, “Lisia um'baha ghwa kipugha pano ikwisa kuhuma ku Yerusalemu ni humia uvulamuli mu makole ghiinu.” ");
INSERT INTO wbi_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pe pano akamulaghila u akida amulolelaghe u Paulo, kange ave nhi nafasi nambe napeangavisaghe umuunhu ughwa kuvakana avakana avamanyani vamwene nava ngatangaghe nambe kukumughendela. ");
INSERT INTO wbi_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ye ifighonpo fimo, u Feliki akagomoka nu Drusila un'dala juno alyale Muyahudi, akamwomola kukun'kemela u Paulo akapulikisia imola kuhuma kwa mwene ija lwitiko mun'kate mwa Yesu Kilisite. ");
INSERT INTO wbi_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Looli u Paulo ye ikana nu mwene vwimila uvwa kyang'haani, kuuti mughelaghe nuvuhighi vuno vulikwisa, u Feliki lukamwagha uludwesi akamula, “luta kuvutali lino, looli ningaghuvone un'siki kange, nikukukemela.” ");
INSERT INTO wbi_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Un'siki ghughughuo, akahuvilile kuuti u Paulo ikum'pela indalama pa uluo akan'kemela nakalina akajova nu mwene. ");
INSERT INTO wbi_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Looli amaka ghavili ye ghakilile, u Porkio Festo akava Ntua akahala pa Feliki akalondagha kukupyanilisia kuva Yahudi, pa uluo pe akamuleka u Paulo pasi pavuloleli. ");
INSERT INTO wbi_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pe u Festo ye ingile mukighavo ikio kange ye fifikile ifighono fitatu akaluta kuhuma ku Kaisaria hadi ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Un'tekesi um'baha nava Yahudi avamanyika vakaleta indeselo mwa Paulo kwa Festo, kange pe vakajovagha ni ngufu kwa Festo. ");
INSERT INTO wbi_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Pe vakan'sumile u Festo vukola ku molaisa Paulo apate kun'kemela ku Yerusalemu kuuti vam'bude musila. ");
INSERT INTO wbi_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Looli u Festo akamula kuut u Paulo akale n'kungua mu Kaisaria, na kuuti umwene jujuo igomoka ukuo ng'aning'ani. ");
INSERT INTO wbi_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Akaati “mu uluo, vala vano vavaghile, vavaghile kuluta ukuo nusue. Ndavule kwekile ikiinu kivivi kwa muunhu ujuo lunoghile kuku n'sitaka.” ");
INSERT INTO wbi_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ye ikalile ifighono lekela lubale nambe kijigho, vakagomoka ku Kaisaria. Ikighono kino kikwisa akava nikitengo ikya vuhighi ku laghila u Paulo ise kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ye afikile, ava Yahudi kuhuma ku Yerusalemu vakima pipi, vakahumia amasitaka aminga amagumu ghano naghanoghile ku hufia. ");
INSERT INTO wbi_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","U Paulo akitangile na kujova, 'Kange nambe mulitavua ilya va Yahudi, nambe njimba ija kufunyila, nambe ku Kaisari, nivombile amavivi.' ");
INSERT INTO wbi_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Looli u Festo alyalondile kujipendelela kuva Yahudi, kange akamwamula u Paulo na kuuti, 'asi, ndeghulonda kuluta ku Yerusalemu na kuhughua nune vwimila vwa masio agha ukuo?' ");
INSERT INTO wbi_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","U Paulo akaati, 'nikwima pavulongolo pa kitango ikya vuhighi ikya Kaisari pano ninoghile kuhighua. Nanivahokile ava Yahudi, ndavule uve ulumanyile vunnofu ");
INSERT INTO wbi_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kama nihokile ndavule nivombile kino kinoghile uvufue, nanikana kufua. Looli ndavule indeselo sivanave nakiinu, nakwale umuunhu juno anoghile kunisona kuvanave. nikun'suma u Kaisari.' ");
INSERT INTO wbi_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ye akyale u Festo kujova navahighi akamula, “Ghukun'suma ukaisari; ghuluta ku Kaisari.” ");
INSERT INTO wbi_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ye fikilile ifighono filingi, untua u Agripa nu Bernike vakafika ku Kaisari valyafumbilue pikumughendela u Festo. ");
INSERT INTO wbi_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ye ikalile apuo mu fighono finga, u Festo akatwalile un'kole kwa Paulo u ntua; akaati, 'Umuunhu jumo vakamulekile apa nhu Feliki un'kungua. ");
INSERT INTO wbi_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ye nikale ku Yerusalemu u n'tekesi um'baha na vaghogholo vava Yahudi vakatwalile amasitaka kwa muunhu ujuo kulyune, voope vakaposia vwimila vwa vuhighi vwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ku uluo une nikavamula kuuti nalwigho lwa Roma kukumuhumia umuunhu kuvupendelelo pa uluo, unyan'kole anoghile kuva mwelevu nakukuvakong'ania ava sitaka va mwene pikun'tanga mu makole aghuo. ");
INSERT INTO wbi_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Pa uluo ye visile palikimo apa, nanikanoghile kukuvaghula, looli ikighono kino kika vingilile nikikalile mu kitengo ikya vuhighi na kulaghila umuunhu uju isi mun'kate. ");
INSERT INTO wbi_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Un'sika ava sitaka ye vimile na kukusitaka, nikasaghile kuuti nakweghale amasitaka amakome ghano ghisile kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Pa uluo, vakale ni ng'aning'ano simonga palikimo nu mwene vwimila vwa vitiki va vanave kange vwimila vya Yesu juno afwile, Looli u Paulo idaja kuuti mwumi. ");
INSERT INTO wbi_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nilyale ni m'buvaghanisivue ndavule ku hungila ilisio iili, pe nikam'posia ndavule angalute ku Yerusalemu kuhighua vwimila vwa masio agha. ");
INSERT INTO wbi_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Looli u Paulo ye akemelilue avikilue pasi pa vuloleli vwimila vwa vulamusi vwa ntua, nikamulaghile avikue nambe nikutwale ku Kaisari.' ");
INSERT INTO wbi_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","U Agripa alyajovile nu Festo, “Nilonda kange kukum'pulikisia u muunhu uju.” “U Festo, akaati, “Pakilavo ghukum'pulikisia.” ");
INSERT INTO wbi_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Pa uluo pakilavo kila, u Agripa nu Bernike vakafika nifikulukulu finga; vakafika mu vukumbi nava vaha vakipugha, na vaanhu ava manyika ava mulikaja. Nu Festo ye ahumisie indaghilo, u Paulo akatwalua kuvanave. ");
INSERT INTO wbi_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","U Festo akaati, “Untua Agripa, na vaanhu vooni vano pevale apa palikimo nusue, mukum'bona umuunhu uju; mukisina kyooni kya va Yahudi ukuo ku Yerusalemu napa kange vilonda nivahighe, voope vakajeghela kulyune kuuti nangikalaghe. ");
INSERT INTO wbi_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nilolile kuuti nakavombile lyelyoni lila lino linoghile uvufue; looli ulwakuva un'kemelile untua, nikalamuile kuku ntwala kuvanave. ");
INSERT INTO wbi_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Looli nilivuvule ikiinu kyekyene ikya kulemba kwa Ntua. savuli ja ulu, nitwalile kulyuve, kange kulyuve juve, Ntua u Agripa, kwe kuuti nipate ikya kulemba vwimila vwa nkole. ");
INSERT INTO wbi_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ulwakuva nivona kisita luvumbulilo pi kutwala un'kungua ye natunsonile isa kun'kungila. ");
INSERT INTO wbi_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Anala, u Agripa akam'bula u Paulo, 'Ghuta kukutanga, pe u Paulo akagholosia uluvoko lwa mwene akitanga ndiki. ");
INSERT INTO wbi_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nikuvona nili nuluvelo, Untua Agripa, kuuti kuvomba u n'kole pavulongolo palyuve umusyughu amasitaka ghoni agha va Yahudi. ");
INSERT INTO wbi_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Lino, ulwakuva uve ulin'kagusi ghwa lwigho isa va Yahudi na maswali. Pe nisuma umulikisiaghe mulugudo. ");
INSERT INTO wbi_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kyang'haani, ava Yahudi vooni vakagwile pene nilyale nikukala kuvujelela vwango mukisina kyango kula ku Yerusalemu. ");
INSERT INTO wbi_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Vang'awile kuhuma kuvwasio luvanoghile kuuti vitike kuuti nikikale ghwene Mfarisayo, ikipugha kiino kilinuvwimo vunyangufu mu lukano lwitu. ");
INSERT INTO wbi_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Lino nimile apa nihighua ulwakuva une nilola ulufingo luno u Nguluve alyavombile nava Nhaata viitu. ");
INSERT INTO wbi_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ulu lwe lufingo luno amakabila ghitu ifijigho fivili vihuvila kukwupila ndavule vikun'suma u Nguluve ni ngufu pakilo na pamwisi. Vwa vwimila uvwa luhuvilo ulu, untua u Agripa, kuuti ava Yahudi vikunisitaki. ");
INSERT INTO wbi_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nakiki ghwe ghwoni mulyumue isagha kuuti kidegho kuuti u Nguluve isyusia avafue? ");
INSERT INTO wbi_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Un'siki ghumo nikasaghile june kuuti ngele nivombile amasio minga vwimila vwa litavua lya Yesu ghwa Nazareti. ");
INSERT INTO wbi_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nika ghavombile agha mu Yerusalemu; nikavakungile ava vitiki vinga mu ndinde, kange nilyale nu mutavulilua kuhuma mu vavaha nava tekesi kuvomba anala; unsiki ghuno vaka m'budagha, nilyatovile ikura kuvene. ");
INSERT INTO wbi_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nakalingi nikavatovile munyumba ija kufunyila jooni kange nikaghelile kuvomba navangitikaghe u lwitiko luvanave. Nilyale ni ng'alasi kyongo kuvana nikavadaghile kange mulikaja ilya kuvuhesia. ");
INSERT INTO wbi_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Unsiki ghuno nilyale nivomba agha, nikalutile ku Dameski, nilyale ni ndaghilo kange nu vatavulilua kuhuma kuvatekesi ava vaha; ");
INSERT INTO wbi_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","unsiki ghuno nikale musila pa mwisi, Untua, nilyalwaghile ulumuli kuhuma kukyanya luno lukale lumulika kukila ilijuva lukamulike kusyuta une na vaanhu vano vakale vighenda palikimo nune. ");
INSERT INTO wbi_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Usue tweni ye twingile paasi, nikapulike ilisio lijova nune liiti mu njovele ija Kiebrania: 'Sauli, Sauli! nakiki ghuku nesa? Kitalamu kulyuve kutova iteke amam'fua. ");
INSERT INTO wbi_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Pe nikati, 'Uve veve veni, Mutwa?' U Mutwa akamula, 'Une nene Yesu juno ghukunipumusia. ");
INSERT INTO wbi_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lino ghwime kumaghulu ghako, ulwakuva nu luhuvilo ulu une nihufisie kulyuve, nukusalwile kuuti uve m'bomba mbombo kange uve mwolesi ghwa masio agha ghukagula vwimila une lino na masio ghano nikukusona ye ghakilile agha; ");
INSERT INTO wbi_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nikum'poka kuhuma kuvaanhu kange vaanhu ava panji kuno nikukwomola, ");
INSERT INTO wbi_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","kudindula amaso gha vanave napikuvahumia mu ng'iisi kuluta kuvuvalafu nakuluta kungufu isa setano vasyetukile u Nguluve; neke vupile kuhuma kwa Nguluve ululaghilo ulwa vahosi nu vuhasi vuno nivapelile vala vano nivabaghwile nu lwitiko luno lilikulyune. ");
INSERT INTO wbi_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Pa uluo, Untua u Agripa, nanikanoghile ku galuka inyifunyo isa ku kyanya, ");
INSERT INTO wbi_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","looli, kuvala vano vano vali mu Dameski pavwasio, kange ku Yerusalemu na ku iisi jooni ija ku Yudea, kange na vaanhu ava kufisina ifinge, nikadalikile kuuti valete na kukunsyetukila u Nguluve, vavombe imbombo sino sinoghile ululato. ");
INSERT INTO wbi_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ulwakuva uluii ava Yahudi vakanin'kolile mu nyumba im'baha inyimike ija ku funyila, pe vakaghela kukum'buda. ");
INSERT INTO wbi_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","U Nguluve akanangile kufika lino, pe nikwima na kuvolelela avaanhu va vulevule na kuvala avavaha, vwimila vwa sila sino avaviili nu Musa valyajovile kuuti silihula na sikunua; ");
INSERT INTO wbi_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kuuti u Kilisite lasima apumuke kange iiva ghwa kwasia kusyuka kuhuma kuvafue na kupulisia ulumuli ku vayahudi na vaanhu ava panji. ");
INSERT INTO wbi_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","U Paulo ye amalile pikutanga, u Festo akajova ku lisio ilivaha, 'Paulo, uve uli nyalukwale! amasomo ghako ghakubikile uve nyalukwale. ");
INSERT INTO wbi_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Looli u Paulo akaati, une naninyalukwale, mwoghopua Festo; looli kulukangasio nijova amasio agha kya ng'haani ghooni. ");
INSERT INTO wbi_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ulwakuva untua ikagula vwimila vwa masio agha; pa oluo, nijova nu vwavuke vwa mwene, ulwakuva niili nuvwa kyang'haani kuuti nakwelile lyoni lino lifisime kwa mwene; ulwakuva iili nalivombilue palubale. ");
INSERT INTO wbi_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Vuuli, ghukwitika avaviili, u Ntua u Agripa? nikagula kuuti ghukwitika.' ");
INSERT INTO wbi_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","U Agripa akam'bula u Paulo, 'Kunsiki undebe unoghile kukunivula une kange kukumbika nive Mwitiki? ");
INSERT INTO wbi_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","U Paulo akaati, “Nikunsuma u Nguluve kuuti, kunsiki n'dbe nambe n'tali, naveve juve kange vooni vano vikunipulika umusyughu, veve ndavule une, looli kange kisila manyororo agha mu ndinde ");
INSERT INTO wbi_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pe untua akima, nhu n'sikali kange nhu Bernike, na vala vano vakikalile palikimo na vene, ");
INSERT INTO wbi_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ye vabukile kuvukumbi, vakajovile vavuo kwa vavuo na kuuti, “Umuunhu uju nanoghile uvufue kange kupinyu,' ");
INSERT INTO wbi_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","U Agripa akam'bula u Festo, “Umuunhu uju anoghile kuuti ave mwavuke ndavule nakekile i piru kuva Kaisari.” ");
INSERT INTO wbi_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ye valaghile kuuti tulondua ku ghenda mu malenga kuluta ku Italia, vakam'pelile u Paulo nava kungua avange kwa m'baha jumo ughwa kipugha kimo ikya va Roma juno itambulua Julio, ava kipugha ikya Agustani. ");
INSERT INTO wbi_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tukapandile imeli kuhuma ku Adramitamu, jino jikale jighenda mulubale mu pwani ija Asia. Pa uluo pe tukingila mu nyanja. Aristaka kuhuma Thesolanike ija ku Makedonia akaluta palikimo nusue. ");
INSERT INTO wbi_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ikighono kino kikavingilile tukima mulikaja ilya Sidoni, pano u Julio aka m'bombile u Paulo nhu vuhugu kange aka n'tavwile kuluta ku vamanyani va mwene ku kwupila uvuhugu vu vanave. ");
INSERT INTO wbi_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kuhuma pala tukaluta kunyanja tukaghendagha ku syuta ikiponge ikya Kipro kino kikale kisigha imepo, ulwakuuva imepo jikale jikutukong'ania. ");
INSERT INTO wbi_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ye tughendile mu malenga ghano ghalipipi ni Kilikia naku Pamfilia, tukisa ku Mira, mulikaja ilya Lisia. ");
INSERT INTO wbi_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Pala u m'baha ughwa kipugha ikya va Roma, akajaghile i meli kuhuma ku Alexandria jino jighenda kuluta ku italia. Akatutosia Mu n'kate. ");
INSERT INTO wbi_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ye ighenda molamola mu fighono ifinga pe tukafikile nu lupumuko pipi na ku Kinidas, imepo najikatutavwile kange kuluta mu sila ijio, pe tukaghenda mulubale mukimughighi ikya ku Krete ye tusigha imepo, m'bading'ani naku Salmone. ");
INSERT INTO wbi_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tukaghenda mulubale kuvu talamu, m'paka tukalutile pakimenyule kino kitanmbulua Fari Haveni jino jilipipi nilikaja ilya Lasi. ");
INSERT INTO wbi_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tukatolile un'siki n'kome nkyongo, nu n'siki ughwa n'kungua ughwa Kiyahudi ghukakilile kange, liino pelukale ulutalamu. Pa uluo u Paulo akatupavile, ");
INSERT INTO wbi_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","na kuuti, “Vghosi, nivona lughendo luno tulonda pitola luva nuvunangifu kange nuvu luvumbulilo lwinga, nambe ku masigho ni meli, looli kange nuvukalo vwitu.” ");
INSERT INTO wbi_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Looli um'baha ughwa kipugha kya va Roma akam'pulikisia kyongo u Mutua ghwa mwene nunya meli, kukila amasio ghala ghano ghalyajovilue nu Paulo. ");
INSERT INTO wbi_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","U lwakuva i bandari napalyale pahugu pikukala un'siki ughw ng'ala, avaghendesia meli vinga vakatuhigha tuvuke kuhuma pala, ulwakuuti fifino luvisaghe pikulifikila ilikaja lya Foinike, tukale pala un'siki ghwa ng'aala. I Foinike bandali ja ukuo ku Krete, kange jilola kunena na kuvuhumo na kumavemba kuvuhumo. ");
INSERT INTO wbi_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","I mepo ja kumavemba ye jitengwile kugugula lukeluke, ava ghendesia meli vasagha kuuti kila kino vakalondagha. Vakavusia ikimilo kya meli nakughenda mulubale mu Krete pipi na mu mwani. ");
INSERT INTO wbi_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Looli un'siki n'debe ye ghukilile imepo inyinga, jino jikatambuluagha kuvuhumo ku nena, jikatengula kutusukania kumwambo ku kiponge. ");
INSERT INTO wbi_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Un'siki ghuno imeli jilya kunilue na kukunua kukujitola imepo, tukiting'ana nu luveelo uluo, tukapindua na veene. ");
INSERT INTO wbi_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tukakimbila kukila ulubale luuo luno lukasighagha imepo ija kiponge kino kitambulua Kauda; na kupumuka kyongo tukakagula pikughupoka ikivoti. ");
INSERT INTO wbi_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Pano vakati vajikwesile, valyakungule imeli nu lughoji. Valyoghuipe kuuti tunoghile piluta kuno lilikuo ilihanga linga ilya Syiti, apuo pe vakisia inanga kange vakaghendelagha mulubale. ");
INSERT INTO wbi_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Tulya gasivue kyongo nama vingu, apuo ikighono kino kilya vingilile avaghendesia meli vakatengula kutagha amasigho kuhuma mu meli. ");
INSERT INTO wbi_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ikighono ikya vutatu, avaghendesia meli vakatengula pihumia amalenga namavoko ghavanave. ");
INSERT INTO wbi_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Un'siki ghuno ili juva ni nondue nafilya tumulikile fighono finga ghalya jighe amavingu amavaha ghikutugasia, nuluhuvilo ulwakuuti ndeponu tupokua lulwavukile ");
INSERT INTO wbi_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Vakaati vaghendile ulughendo lutali kisila kyakulia, apuo pe u Paulo akima pakate na kati pavaghendesia meli akaati, “Vaghosi, lunoghile mu mulikisie, kange natuvele tuvusisie inanga kuhuma ku Kret, neke pe tupate imumuko isita luvumbulilo. ");
INSERT INTO wbi_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lino pe nikuvanyasia, ulwakuva nakwekuva kusovia uvwumi vwinu, looli tusofisie ji meli. ");
INSERT INTO wbi_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ulwakuva ikilo jino jikilile umunyamola gha Nguluve, juno ujuo u Nguluve une nilighwa mwene, kange ghwejuno nikufunya kwa mwene - umunyamola ghwa mwene avele imile mulubale mulyune ");
INSERT INTO wbi_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na kuuti, “Nuloghopagha Paulo. Lukunoghile kukwima pavulongolo pa Kaisari, lolagha u Nguluve mu vuhugu vwa mwene akupelile ava vooni vano vighenda palikimo nuve. ");
INSERT INTO wbi_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Pa uluo, avaghosi, mugudaghe, ulwakuva mukumwitika u Nguluve, kuuti luva ndavule nivele nivulilue. ");
INSERT INTO wbi_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Looli lutunoghile kupumuka mulwa ku tovua mu fimonga ifi ponge.” ");
INSERT INTO wbi_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ye jifikile ikilo ija kijigho na fine, pano tuvele mulunjughanjugha ulwa kuno na kuno mu nyanja ija Adratik, ndavule ikilo n'kate n'diki, avaghendesia meli valyasaghile kuuti vaseghelile ku mwani. ");
INSERT INTO wbi_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Valyavombile amasio kulola uvutali uvwa malenga pasi vakasagha imita fijigho fitatu n'tanda, ye ghukilile un'siki n'debe vakapima kange vakasivona imita ifijigho fivili ni lekela lubale. ");
INSERT INTO wbi_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Valyoghwipe taasi kuuti tunogile kubumala muma nalavue, apuo pe vakisia inanga inne kuhuma pano palyavikilue pakuvika inanga pe vakifunya kuuti ilwakilavo hwene jise ng'aning'ani. ");
INSERT INTO wbi_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Avaghendesia meli vava valyale vilonda pikujilekelesia i meli jila pe vakisisie mumalenga amavoli amadebe isa kuvapoka ku vwumi vwave, vakivika kuuti hwene vitagha inanga kuvulongolo kumavoti. ");
INSERT INTO wbi_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Looli u Paulo akam'bula jula un'sikali gha kipugha ikya vasikari ava kiroma nava sikar vala, “Namungapokue looli avaanhu ava vasighale mu meli”. ");
INSERT INTO wbi_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Apuo ava sikari vala pe vakadumula ingoji sa livoti lila pe jikalekua jitolue na malenga. ");
INSERT INTO wbi_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Un'siki ghuno kulyale ku tema pa lwakilavo, u Paulo akavapelepesia vooni kuuti valie padebe. Akaati, “Umusyughu kighono kya kijigho na fine mughula kisila kulia, namulile kimonga. ");
INSERT INTO wbi_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Pe nikuvavula mutole ikyakulia ikidebe, ulwakuva vwimila uvu avwa kukala kulyumue; nakwelile nambe ilinyele limo mumatue ghiinu lino lisova. ");
INSERT INTO wbi_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ye ajoovile aghuo akatola un'kate akamuhongesia u Nguluve pavulongolo pa maso muunhu ghweeni. pe akamenyula un'kate akatengula kulia. ");
INSERT INTO wbi_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Pa uluo vooni vakakangasivua inumbula na veene vakatola ikyakulia. ");
INSERT INTO wbi_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tulyale avaanhu 276 mun'kate mu meli. ");
INSERT INTO wbi_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Yevalile fikwiline, vakajivombile imeli jive m'mepe ku tagha ingano mun'kate mu nyanja. ");
INSERT INTO wbi_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ye mwisi, navakajitambuile iisi, looli pe vakalola iisi jino jingile mu malenga jino jilyale nilihanga linga vakapuling'ana ndavule vanoghile kughendesia imeli kuluta apuo. ");
INSERT INTO wbi_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Pa uluo vakalegesia inanga vakasileka mu nyanja. Mun'siki ghughuhuo vakasilegesia ingoji isa tanga pevakinula kuvulongolo kuluta ku mepo pe vakaluta mulihanga ilinga. ");
INSERT INTO wbi_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Looli vakisa pala pano amakuja ghavili agha malenga ghitang'ana, ni meli jikaluta kulihanga. Napala pavulongolo pa meli jikima pala najikanoghile ku vuka, looli pavulongolo pa meli pakatengula kudenyeka ulwakuva amaviingu ghakale ni ngufu. ");
INSERT INTO wbi_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Uvutavike vwa va sikari ghukale kuvabuda avakungua, ulwakuuti na kwale juno ikwoghela na kudyegha. ");
INSERT INTO wbi_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Looli un'sikari jula ughwa kipugha ikya va Roma alyalondile kukumwavula u Paulo, pe akamwimia uvutavike vuvanave, kange akavalaghila vala vano vanoghile kukwoghela, vajumbe kuhuma mu meli valute mu iisi. ");
INSERT INTO wbi_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Pa uluo ava ghosi avange vivingilila, avange mufighave ifya mbavo nakange avange mufinu ifinge kuhuma mu meli. Musila iji jihumile kuuti vooni vafike vunofu ku iisi ");
INSERT INTO wbi_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Yetufiike vunofu, tulyakagwile kuuti ikiponge kitambulua Malta. ");
INSERT INTO wbi_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Avaanhu va palikaja na kwe kuti vakatuupilile uvuhugu vwa vulevule, pe valyapembile umwooto na pikutukaribisia tweeni, ulwakuva ifula ni mepo jikale jighendelela. ");
INSERT INTO wbi_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Looli u Paulo ye akang'anisie unsigho ghwasanjala na kuvika pa mwooto, ilijoka ilidebe ilinya sumu likahuma mu sanjala sila ulwakuva lwa vufukefu vuula pe likin'yengelela mu luvoko lwa mweene. ");
INSERT INTO wbi_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Avaanhu va pa likaja pala yevalolile kwiiti ilijoka liswembela kuhuma muluvoko lwa mweneenevapuling'ana vavuo,”Umuunhu uju kyang'haani m'buudi junoadyeghile mu Nyanja looli uvwakyangani navukuntavula kukukala.” ");
INSERT INTO wbi_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Looli umweene akantaghila ilijoka ilio kumwooto nakapatile uvunangifu vwooni. ");
INSERT INTO wbi_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Aveene vakumughula afimbe inamu nambe aghue na kalingi na kufua. looliye nimulolile ku nsiki untali na kulola kuuti na kwelili lino lilivulevule kwa mweene wakabadilisia amasaghe ghavanave na kuuti alyyale unguluve. ");
INSERT INTO wbi_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kange pala pipi palyale ni iisi jinojilyale kyuma kya m'baha wa kiponge, umuunhu juno itambulua pablio. Alatwupilile na pikututengelela ifighono fitatu. ");
INSERT INTO wbi_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Lulyahumile kuuti viise wa pablio jikam'bwene imungu ni namu ija kuhalisia. Na ju Paulo amulutile akifunya, akavika amavoko pa kyanya pa mwene na pikum'buvusia. ");
INSERT INTO wbi_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Yelihumile ili, avaanhu avange pa kiponge pala vano valyale vivavua voope vakaluta vakavuvusivua. ");
INSERT INTO wbi_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Avaanhu vakatwoghopa nu vwoghofi uvukome. Panotukale tukuling'ania kukyula, vakatupelile fila fino tukafivombile. ");
INSERT INTO wbi_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Yeghakilile ameesi gha tatu, tulyaghendile mu nkate mu meli Iskanda jino jilyakolilue ni ng'ala pa kiaponge pala, jino avalongosi va jene valyale vanyalukolo va vili ava lipasa. ");
INSERT INTO wbi_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Pano yetupumile mu likaja ilya sirakusa, tulikalile pala ivighono vi tatu. ");
INSERT INTO wbi_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kuhumila pala tukaghendile tukafike mulikaja ilya Regio. Ye kikilile ikighono kimo imepo ija kumavemba jilyahumile nakalingi, yefikilile ifighono fivili tukafikile mulikaja ilya Putoli. ");
INSERT INTO wbi_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ukuo kwe tukavavwene ava nyalukolo avange vakatupilile kukukala navoope ifighono lekela lubale. Kusila iji tukisile ku Rumi. ");
INSERT INTO wbi_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kuhuma ukuo avanyalukolo vala, yevapulike imola isiitu, vakisile kukutwambilila ukuo kulighulilo ilya Apias ni Hoteli itatu. U Paulo ye avavwene avanyalukolo vala valyamongisie u Nfuluve pe akavika ni ngufu. ");
INSERT INTO wbi_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Pano ye twingile ku Roma, u Paulo akatavulilue kukukala mwene palikimo nu n'sikali jula juno alyale ikumulolela. ");
INSERT INTO wbi_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Yefikilile ifighono fitatu u Paulo akavakemelile palikimo avaghosi vala vano valyale valongosi mun'kate muva Yahudi. Vano vakisile palikimo, alyajovile kuvanave, “Vanyalukolo, palikimo na kuuti nanihokile n'kole ku vaanhu ava nambe kuvomba luno nalulondua nava Nhaata viitu vanovalyatulongolile, vakanyumisie hwene n'kungua kuhuma ku Yerusalemu kufika hadi mumavoko gha va Rumi. ");
INSERT INTO wbi_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Yevamalile kukumoselesia, vakanoghilue kukundekesia mu vwavuke ulwakuva nalulyale lumonga kulyune ulwa ku hulila pi kum'buuda ");
INSERT INTO wbi_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Looli ava Yahudi vala vakaati vajovile vunge kuluno vinoghelua avene, penilyaghimbile pihumia apiru kwa Kaisari, napano nalulyale lunyakuva ndiikio nileta amasitaka mu kipelela kyango. ");
INSERT INTO wbi_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ulwakuva kiki une nilete i apiru, pa uluo nilyasumile kukuvagha na kujova navoope. Ulwakuva kiila u Israel alipisie nakyo, niikungilue muvukunge uvu. ");
INSERT INTO wbi_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Pe vakam'bula, “Natughelile twupile ikalata kuhuma ku Yudea jino jikukujova uve, nambe nakwale unyalukolo juno akisile nakuhumia imola nambe kujova ilisio limonga ilivivi vwimila uve. ");
INSERT INTO wbi_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Looli tulonda kupulika kuhuma kulyuve ghusagha kiki vwimila ilipugha lya vaanhu ava, ulwakuva sivoneka kulyumue kuuti nijova fiivi pooni pano nilipuo.” ");
INSERT INTO wbi_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Vakaati vavikile ikighono vwimila umwene, avaanhu vinga kyongo valyamwisile pano ikalagha. Alyajovile ilisio lila kuvanave napikuvolelela vwimila ulwa vutua vwa Nguluve. Akaghelile kukuvavika vunofu vwimila u Yesu, kusooni ivili kuhumila mu ngaghilo sa Musa na kuhuma mu vavili, kutengulila pa lwakilavo kufika umpaka pakivwilile. ");
INSERT INTO wbi_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Mun'kate mu vavuo vakavahongile kusimo sikajovilue, napano avange navakitike. ");
INSERT INTO wbi_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Yevakunilue pikwiting'ana vao kwa vao vakavuka u Paulo ye ajvile imola iji jimo, “U Mhepo u Mwimike vunofu kukuka u Isaya um'biili ghwa va Nhaata viitu. ");
INSERT INTO wbi_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Akaati, 'Luta kuvaanhu ava ujove, “Ku mbughulutu siinu mum'pulika, looli na mungakitang'anie; na kumaaso ghinu mulola looli namungakagule. ");
INSERT INTO wbi_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Vwimila vwa numbula sa vaanhu ava siila vuvotevote, imbughulutu save sim'pulike ni mumuko, vadindile amaso gha vanave; neke kuuti valeke kukagula ku maso gha vanave, nakum'pulika ku mbughulutu sivsnave, napikun'tang'ania mu nhumbula sivanave, na pisyetuka kange, ngele nivavuvwisie.” ");
INSERT INTO wbi_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pa uluo, mu noghile kukagula kuuti uvuvangi vwa Nguluve vutwalilue ku vaanhu ava panji, kange vipulikisyagha.” (Gadilila: Ikidebe iki ");
INSERT INTO wbi_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","“Un'siki ghuno alyajovile amasio agha, ava Yahudi vakabuka, kuno vighelana kyongo vavuo kwa vavuo, nakwesile muvutavike uvunofu uvwa kali). ");
INSERT INTO wbi_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","U Paulo akikalile mu nyumba ja mwene ijakupanga amaka ghaviili, kange alyavambilile vooni vanoon vano vakalutagha kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Alyale idalikila uvutua vya Nguluve kange alyale ivulanisia amasio vwimila vwa Mutwa Yesu Kilisite mungufu sooni. Nakwale juno kan'sighile. ");
INSERT INTO wbi_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","uPaulo unsung'ua ghwa Yesu Kilisite, juno akemhelilue kuva nsung'ua, na kubaghulua vwimila ilivangili lya Nguluve. ");
INSERT INTO wbi_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ili lwe livangili lino akalifingile pakali kukilila avavili vaake mu malembe amimike. ");
INSERT INTO wbi_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","sa nswambe, juno akaholilue kuhuma mu kikolo kya Davidi mu lwa m'bili. ");
INSERT INTO wbi_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","umwene akapulisivue kwa mwana ghwa Nguluve ku nguu ja Mhepo uMwimike ku vusyukue vwa vafue, uYesu Kilisite Mutwa ghwitu. ");
INSERT INTO wbi_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","kukilila umwene twupile uvumosi nu vusung'ua kwa kwitikila ulwitiko mu luhala lwoni, vwimila ilitavua lyake. ");
INSERT INTO wbi_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","mu luhala ulu, najumue kanga mukemhelilue kuva va Yesu Kilisite. ");
INSERT INTO wbi_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ikalata iji ja kuvoni vano vali ku Rumi, vaghanike va Nguluve, vano vakemhelilue kuva vimike. uvumosi nu lutengano fivisaghe numuekuhuma kwa Nguluve Nhaata ghwitu nu Mutwa Yesu Kilisite. ");
INSERT INTO wbi_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","muvwandilo, nikumuhongesia uNguluve ghwango mwa Yesu Kilisite vwimila jinu mweni. ulwakuva ulwitiko lwinu ludalikivue mu iisi jooni. ");
INSERT INTO wbi_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ulwakuva uNguluve nsaidi ghwango, juno nikumwuvila mu numbula jango mu livangili lya Nswambe, ndavule nikukala na kukuvakemhela. ");
INSERT INTO wbi_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","jaatu nikuvasumila mu nyifunyo sango kuuti, ku sila jojoni nikave uvusililo kuva lughinio ku lughano lwa Nguluve kukwisa kulyumue. ");
INSERT INTO wbi_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","lwa kuva nonoghelua kukuvagha, neke nikave kukuvapela ifipelua ifya munumbula, nikave kukuvakangasia. ");
INSERT INTO wbi_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ni lolelela kukuvakangasia inumbula ku sila ija lwitiko kwa muunhu ghweni. ijinu ni jango. ");
INSERT INTO wbi_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","lino vanyalukolo nanilonda muleka kukagula kuuti, ke kinga nihuvila kukwisa kulyumue neke kuhanga lino nisighilie. nilonda ndiki neke kuva ni mheke kulyumue ndavule lulivua kuvapanji. ");
INSERT INTO wbi_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","nidajivua na vaYunani navaghesi kange, averefu na vajaasu. ");
INSERT INTO wbi_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","lino ku lubale lwango, une nili tayale kupulisia ilivangili kulyumue na kuvano vali ku Rumi. ");
INSERT INTO wbi_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ulwakuva nanikulivonela soni ilivangili, ulwakuva se ngufu sa Nguluve uvuvangi ku vano vikumwitika, kwa muYahudi taasi neke kwa muYunani kange. ");
INSERT INTO wbi_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ulwakuva ikyang'hani ja Nguluve jivonike kuhuma ulwitiko nu lwitiko, ndavule jilembilue,” inya lwitiko ikukala mu lwitiko. ");
INSERT INTO wbi_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ulwakuva ing'alasi ja Nguluve jivonike kuhuma kukyanya kulutila uvuhosi vwoni vwa vaanhu, vano kusila ja vuhosi vikujifisa ikyang'haani. ");
INSERT INTO wbi_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ulu lwe lukuva, sooni sino ndepoonu sikagulika kwa Nguluve sesa vuvalafu kuveene. ulwakuva uNguluve avamamnyisie. ");
INSERT INTO wbi_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ulwakuva imbombo sake sino nasivoneka vunono sili pavuvalafu kuhuma muvutengulilo vwa iisi. sivoneka kukilila ifinu finofivumbilue. imbombo isi se vuwesia vwake vwa kusila na kusila nu vutengulilo vwa vunguluve. amahumile ghake avaanhu ava vasila vutavulilua ");
INSERT INTO wbi_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21",". ulu lwe lyakuva nave valyakagwile isa Nguluve, vakampaala umwene ndavule uNguluve nambe navamuhongisie. pe pano valyale vajaasu mu musaghe ghave na moojo ghave agha vujaasu ghakaponesivue ing'iisi. ");
INSERT INTO wbi_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","vajikemelagha vanyaluhala neke vakava vajaasu. ");
INSERT INTO wbi_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","valyavwandwile uvwimike vwa Nguluve juno nsila vunangifu vwa kihwanikisio kya muunhu juno ali nuvunangifu, nagha fijuni, nagha fidimua ifinya maghulu ghane, na fifing'onyo fino fikwafuala. ");
INSERT INTO wbi_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","pe uNguluve akavaleka vasivingilile inogheluo indamafu sa moojo ghave, ku mavili ghave kusukunalua vavuo ku vavuo. ");
INSERT INTO wbi_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","vope vano vandwile ilweli ja Nguluve kuuva vudesi, na vano vakifunyilagha na kufivombela ifidimua na kukumuleka juno afivumbile juno ighinilua ifighono ifisila na kusila. Amina. ");
INSERT INTO wbi_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","mu ulu uNguluve alyavelekile vavingilile inoghelua saave isa soni, ulwakuva avadala vaave vakandwile kutumila amavili ghave ndavule lulyamunoghile uNguluve. na ");
INSERT INTO wbi_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","vavaghosi vakaleka kutumila amavili ku vadala vaave looli vavuo ku vavuo. ava valyale ve vaghosi vano vavombagha na vaghosi vajanave sino nasinoghile, valyupile uluhombo luno lunoghile ku vusofi vwave. ");
INSERT INTO wbi_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ulwakuva navakighanile kuuva nu Nguluve mu luhala lwavo, akavaleka valuvingililaghe uluhala lu vanave luno nalunoghile, vavombe sino nasinoghile. ");
INSERT INTO wbi_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","vamemilue ni nuvuhosi, uvunoghelua nu vuvivi. vamemilue nu vwifu, ilibaatu, uvusyangi nu vufumbue vuvivi, ");
INSERT INTO wbi_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","avene kange vajova fivi, vahomeleng'ani kange vanya kun'kalalia unguluve. avanya vulugu, imbedo, na vanya lughinio. aveene vanya kusagha imbivi, navikuvitika avapafi vaave. ");
INSERT INTO wbi_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","aveene vasila vukagusi; navikwitikika, vasila lughano kange vasila ikisa. ");
INSERT INTO wbi_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","vikwelevua uvutavike vwa Nguluve, lwa kuuti avaanhu vano vivomba mu isio vanoghile kufua. neke nakwekuti vano vivomba aghuo vene, looli avene vikwiting'ana na vala vano vivomba aghuo. ");
INSERT INTO wbi_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","pe lino nutavulilue, uve ghwejuno ghuhigha ulwakuva ku ghala ghano ghuhigha ujunge ikujivika jujuo mu nkole. ulwakuva ghwenjuo ghuhigha najuve ghuvomba ghala ghala. ");
INSERT INTO wbi_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","neke tukagula kuuti, uvuhighi vwa Nguluve vwa lweli ku vano vivomba ndavule aghuo. ");
INSERT INTO wbi_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","neke uve usaghaghe ili kuuti uve ghwe juno ghuhigha vala vano vivomba aghuo nambe najuve ghuvomba ghaghaghuo. pe uve naghuli highua nu Nguluve? ");
INSERT INTO wbi_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","neke ghusagha padebe ku vwinga vwa vunono vwake, kudila kwa ng'alasi jake, nu lugudo lwake? pe naghukagula kuuti uvunono vwake vunoghiile kukuvulanisia kulaata? ");
INSERT INTO wbi_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","pe kuling'ana nu vwumu vwa mwoojo ghwako ghuno naghwa kulaata, ghukujivika juve mu ng'alasi ja kighono kila. looli mu kighono kya vusyuko vwa vuhighi vwa kyang'haani vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","umwene ihomba kuling'ana ni kighelelo kya maghenndele ghake. ");
INSERT INTO wbi_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","vala vano ku lukangasio lwa maghendele amanono valondile ulufunyo, uvukoola na kuleka kunangika, ikivapela uvwumi vwa kusila na kusila. ");
INSERT INTO wbi_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","neke ku vala vano ku numbula saave navitiki vwa kyang'haani looli vikwitika uvukunyi, ing'halasi ing'ali jikwisa. ");
INSERT INTO wbi_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","uNguluve ileta injala nu lupumuko ku numbula ja muunhu ghweni juno avombile uvuhosi, kutengulila kwa muyahudi taasi pe kwa muyunani kange. ");
INSERT INTO wbi_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","neke ulufunyo, uvukoola nu lutengano fikwisa kwa muunhu ghweni juno ivomba inono, kwa vayunani taasi pe umuyunani kange. ");
INSERT INTO wbi_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ulwakuva kusila lughano kukila kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ulwakuva nave vinga vahokile kisila ndaghilo visova kisila ndaghilo, kange nave vinga vahokile kuling'ana ni ndaghilo vihighua ku ndaaghilo. ");
INSERT INTO wbi_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ulwakuva natuli vaanhu va kupulika indaghilo, avanya kyang'haani pa maaso gha Nguluve, looli ve vala vano vivomba indaghilo vano vailivalilua ikyang'haani. ");
INSERT INTO wbi_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ulwakuva avaanhu ava pa iisi avasila ndaghilo vivomba isa mundaghilo aveene vali ndaghilo mu numbula saave, nambe aveene vasila ndaghilo. ");
INSERT INTO wbi_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ku ulu vivonesia kuuti amaghendele ghano ghanoghile ku vutavike vwa ndaghilo ghalembilue nkate ja moojo ghave. uvufumbue vwave vuvoneka na masaghe ghave ghikuvahigha nambe kukuvalolelela vavuo ");
INSERT INTO wbi_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","kange na kwa Nguluve. agha ghilihumila mu kighono kino uNguluve ilikusihigha inyivi sa vaanhu vooni kuling'haana ni livangili lya Nguluve, kusila ja Yesu Kilisite. ");
INSERT INTO wbi_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","tujove kuuti ghukujikemela muYahudi, juuno ikalile mu ndaghilo, lulutila kwa kujighinia mwa Nguluve, ");
INSERT INTO wbi_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","lukagule ulughano lwake, na kughelela sino nasilutana ye jilaghisivue ni ndaghilo. ");
INSERT INTO wbi_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","pe tujove kuuti uli nulukangasio kuva uve uli mulongosi ghwa vabofu amaaso, lumuli kuvala vano vali mu ng'iisi, ");
INSERT INTO wbi_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","m'bulanisi ghwa vajaasu, m'bulanisi ghwa vaanha, na kuuti mu ndaghilo uli ni mbuanisio sa lweli. ");
INSERT INTO wbi_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","pe uve lino ghwe juno ghukun'dalikila ujunge, pe naghukujivulanisia juve ghwe mwene? ghwe juno ghudalikila kuleka kuhija pe uve naghuhija? ");
INSERT INTO wbi_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","uve ghwejuno ghujova nungavwafukaghe, pe ghuvwafuka? uve ghwe juno ghukalala ikihwanikisio, pe ghuhija mu nyumba inyimike ja kufunyila? ");
INSERT INTO wbi_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ghwe juno ghukughinia mu ndaghilo, pe naghukunsukunalisa uNguluve kwa kudenya indaghilo? ");
INSERT INTO wbi_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ulwakuva ilitavua lwa Nguluve lisukunalisivua ku vaanhu va mu iisi kukilila umue, “ndavule jilembilue”. ");
INSERT INTO wbi_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ulwakuva kudumulivua ingola lweli kunoghile nave ghukwitikila indaghilo, neke nave uve naghuvomba isa mu ndaghilo kudumulivua kwave kuuva vuvule. ");
INSERT INTO wbi_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","pe nave umuunhu nadumulivue kange ighendelela kukola uvutavike vwa ndaghilo, pe nambe kisila kudumulivua kwa mwene nakulitolua kuuti adumulivue ingola?”. ");
INSERT INTO wbi_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ghwope juno nadumulivue kuvutengulilo vwa iisi naihighua nave angavombe isa ndaghilo? ulu lwe lwakuva uli na malembe ghano ghalembilue na kudumulua ingola neka kange naghuvomba isa mundaghilo! ");
INSERT INTO wbi_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ulwakuva umwene na Muyahudi juno ali mulwa kunji, nambe kudumulua na lwelula ulwa m'bili lwene. ");
INSERT INTO wbi_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","neke umwene ghwe Muyahudi ghwa munkate, nuludumuluo lwa mwoojo mu numbula, nambe mu malembe. ulufunyo lwa muunhu ughwa nahele naluhumila ku vaanhu looli kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","kange vwe vufumbue vuliku vuno alinavwo umuyahudi? vwe vufumbe vwa kukekua? ");
INSERT INTO wbi_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","lwe lunono kyongo ku sila sooni. muvutengulilo vwa ghoni avayahudi vkapelilue ulusyetulilo kuhuma kwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","neke pe luliva ndani nave avayahudi vamonga navalyale nu lwitiko? pe kuleka kuva vagholofu, kulivomba uvugholofu vwa Nguluve kuva vwa vudesi? ");
INSERT INTO wbi_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ndali! pe pano leka uNguluve avoneke kuva lweli, nambe kuuti umuunhu ghweni n'desi. ndavule vule jikalembilue kuuti, “ingufu kuvoneka kuuva nya kyang'ani ku masio ghako, ni ngufu kusinda pano ghukwingila ku vuhighi” ");
INSERT INTO wbi_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","neke nave uvuhosi vwitu vusoona ikyang'ani ja Nguluve, tuti ndaani? uNguluve na muhosi nambe pano ihumia ing'alasi jake, pe ali ndikio? nijova kuling'haana nu vufumbue vwa kimuunhu. ");
INSERT INTO wbi_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ndali! pe ndani uNguluve ikujighigha iisi? ");
INSERT INTO wbi_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","neke nave je lweli ja Nguluve kukilila uvudesi vwango kuhumia ulufunyo lwinga vwimila umwene, pe kiki pe nijighe nihighua ndavule unya vuhosi? ");
INSERT INTO wbi_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","kiki tujove ndavule fino valyatudesile kange ndavule avange fino vijova kuuti tujova, “tuvombe uvuhosi, neke amanono ghise?” uvuhighi vwave vwe va kyang'ani. ");
INSERT INTO wbi_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","kye kinu kiki himbe? tukujivavila jusue? Ndali kyongo. ulwakuva usue tayale tuvahighile avayahudi na vayunani vooni palikimo, kuuti vali paasi pa sambi. ");
INSERT INTO wbi_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","iji jili ndavule jilembilue: “nakwale unyakyang'haani nambe jumo. ");
INSERT INTO wbi_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","nakwale umuunhu juno ikwelevua nakwale juno ikumulonda uNguluve. ");
INSERT INTO wbi_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","vooni vasyetung'iine, vooni palikimo vasila vufumbue, nakwale juno ivomba inono nambe jumo. ");
INSERT INTO wbi_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","amakalo ghavo je mbiipa jino ndindule imili savo sidesa, isumu ja njoka jili mumalomo ghave. ");
INSERT INTO wbi_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","amalomo ghave ghamemile ulughuno nu vuvafi. ");
INSERT INTO wbi_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","amaghulu ghave ghali luvilo kukung'a idanda, ");
INSERT INTO wbi_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","uvunangifu nu lupumuko fili mu sila saave. ");
INSERT INTO wbi_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","avaanhu ava navakagwile isila ja lwitiko. ");
INSERT INTO wbi_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","kusila vwoghofi vwa Nguluve pa maaso ghave. ");
INSERT INTO wbi_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","lino tukagula kyokyoni kino indaghilo jijova, jijova na vala vano mu ndaghilo. kwe kuuti kudinda amalomo ghooni, ni iisi jooni jive nu vutavike kwa Nguluve, ");
INSERT INTO wbi_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","nu lu lwe lwakuva kusila m'bili ghuno ghuvalilua ikyang'haani ku maghendele gha ndaghilo pa maaso ghake. ulwakuva kukilila indaghilo vukwisa uvukagusi vwa sambi. ");
INSERT INTO wbi_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","neke lino kisila ndaghilo ikyang'haani ja Nguluve jino jikagulike. jilyajovilue ku ndaghilo na vavili, ");
INSERT INTO wbi_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ijio je kyang'haani ja Nguluve kukilila ulwitiko mwa Kilisite Yesu ku vitiiki vooni, lwakuva kusila tofauti. ");
INSERT INTO wbi_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ulwakuva vooni vavombile uvuhosi, na kupelelela vwimike vwa Nguluve, ");
INSERT INTO wbi_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","vavalilue ikyang'ahhani ja vuvule ku vumosi vwake ku sila ja vupoki vuno vuli mwa Kilisite Yesu. ");
INSERT INTO wbi_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ulwakuva uNguluve alyamwumisie uKilisite Yesu ava lusambanio ku sila ja lwitiko ku danda jake. alyamwumisie uKilisite hwene mulolelesi ghwa kyang'haani jake, ulwaluva kukuvulekesia uvuhosi vuno vwa kilile ");
INSERT INTO wbi_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ku lugudo lwake. aghu ghoni ghalyahumile neke kuvonesia ikyang'ani jake unsiki ughu ghwa lino. neke lulyale kuuti awesie kujivonesia jujuo kuva nyakyang'haani, na kuvonesia kuuva kumuvavalila umuunhu ghweni ku lwitiko mwa Kilisite Yesu. ");
INSERT INTO wbi_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","kulikughi kukughinia? kuvikilue lubale. ku vwalo vuliku? uvwalo vwa maghendele? Ndali! neke ku vwalo vwa lwitiko. ");
INSERT INTO wbi_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","lino tumalikisia kuuti umuunhu ivalilua ikyang'ani ku lwitiko kisila maghendele gha ndaghilo. ");
INSERT INTO wbi_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","neke uNguluve ghwe Nguluve ghwa vayahudi veene? pe umwene naghwe Nguluve ghwa vaanhu vooni? Ena!, na vange vope. ");
INSERT INTO wbi_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","nave je lweli Nguluve ghwe jumo, ikuvavalila ikyang'ani vano vadumulua ku lwitiko, na vano navadumulivue ku sila ja lwitiko. ");
INSERT INTO wbi_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","pe usue tukujikana indaghilo ja lwitiko? Ndali! ku nsana ku aghuo usue tukujitika indaghilo ");
INSERT INTO wbi_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","tutisagha kiki kange kuuti uAbulahamu unhaata ghwitu ku lwa m'bili avonike? ");
INSERT INTO wbi_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ulwakuva nave uAbulahamu alyavalilue ikyang'haani mumaghendele, aale iva nulwa kwighinia, neke napavulongolo pa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","neke amalembe ghiti ndani?” uAbulahamu alyale ikumwitika uNguluve kange vakam'balila kwa mwene kuuva kyang'haani” ");
INSERT INTO wbi_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","lino kwa muunhu juno ivomba imbombo, uluhombo lwake naluvalilua kuuva vumosi, looli luva lideni. ");
INSERT INTO wbi_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","neke kwa muunhu juno naivomba imbombo kange ikumwitika umwene juno am'balile ikyang'haani juno nsila vupoki, ulwitiko lwa muunhu ujuo lulvalilua kuuva kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","uDavidi ijova isa lufunyo kwa muunhu juno uNguluve am'balile ikyang'haani kisila maghendele. ");
INSERT INTO wbi_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","akati, “vafunyilue vala vano uvuhosi vwave vusaghilue na vano isambi saave sikupikilue. ");
INSERT INTO wbi_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","afunyilue umuunhu jula juno uMutwa naim'balila isambi”. ");
INSERT INTO wbi_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","pe ulufunyo ulu lwa vala vano vadumulivue ingola veene, neke nambe ku vala vano navadumulivue ingola saave? ulwakuva twiti, “kwa Abulahamu ulwitiko lwake luvalilue kuuva lwa kyang'haani”. ");
INSERT INTO wbi_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","pe lukavalilue ndani? unsiki uAbulahamu lyale ku ludumuluo, nambe ye akyale kudumulua? najilyale kuvudumulua looli kuvudumulua. ");
INSERT INTO wbi_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","uAbulahamu alyupile ikivalilo kya kudumulua. iki kilyale kye kivalilo kya kyang'haani ja lwitiko luno alyale nalwo ye akyale kudumulivua. amahumile gha kivalilo iki kwe kuuti alyavombike kuuva nhaata ghwa vooni vano vikwitika, nambe nave navali muvudumulua. iji jili nu vufumbue kuuti ikyang'haani jilivalilua ku veene. ");
INSERT INTO wbi_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","iji jili nuvufumbue kuuti uAbulahamu alyavombike nhaata ghwa vadumulua veene looli kange ku vala vano vikusivigilila isajo va nhaata ghwitu uAbulahamu. na ulu lwe lwitiko luno alyale nalwo ku vano navadumulivue. ");
INSERT INTO wbi_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ulwakuva najilyale ku ndaghilo kuuti ulufingo lukapelilue kwa Abulahamu nu vuholua vwake, ulufingo ulu ulwakuva viiva vahaasi va iisi, pe jilyale kukilila ikyang'haani ja lwitiko. ");
INSERT INTO wbi_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ulwakuva ndeve avandaghilo vala vevahaasi ulwitiko lulu lwa vuvule, nu lwitiko lukanilue. ");
INSERT INTO wbi_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ulwakuva idaghilo jileta ing'alaasi, neke pala pano pasila ndaghilo kange nakwele kusita kukwitikila. ");
INSERT INTO wbi_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","mu lulu jihumila ku lwitiko, neke luve ku vumosi, amahumile ghake ulufingo luvoneke ku vuholua vwoni. na vaholua ava na vevala veene vano vikagula indaghilo liilo na vala vano ve va lwitiko lwa Abulahamu. ulwakuva umwene ghe nhaata ghwitu twevoni, ");
INSERT INTO wbi_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","nave jilembilue kuuti, “nikupelile uve kuuva nhaata ghwa iisi nyinga” uAbulahamu alyale mu lwitiko lwa jula juno alyale mwitiki, kuuti, uNguluve juno ikuvapela avafue uvwumi na kukuvapela sooni sino vasila neke vavisaghe naso. ");
INSERT INTO wbi_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","nambe kuuva naso sooni, uAbulahamu ku lukangasio alyamwitikile uNguluve ku fighono fino fikwisa. pe lino akava nhaata ghwa iisi nyinga, kuling'aana na kila kino kilyajovilue”, fye luliva uluholuo lwako. ");
INSERT INTO wbi_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","umwene naalyale m'bote vote ku lwitiko. uAbulahamu alyajovile jujuo kuuti um'bili ghwake ghulyafwile - alyale ma maaka kuvelelela kijigho. kange akiting'ine ku vufue vwa lileme lya Sala. ");
INSERT INTO wbi_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","neke ulwakuva ulufingo lwa Nguluve, uAbulahamu nakabuhilile kukwitika. pe akaponekisivue ingufu ku lwitiko na kukumughinia uNguluve. ");
INSERT INTO wbi_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","alyale ikagula ikyang'haani ku kila kino uNguluve akafingile alyale ni ngufu sa kuvomba. ");
INSERT INTO wbi_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","pe lino iji jope jilyavalilue kuuva je kyang'haani. ");
INSERT INTO wbi_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","lino najilyalembilue ku vufumbue vwake lwene kuuti jilyavalilue kwa mwene. ");
INSERT INTO wbi_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","jilyalembilue vwimila jiitu kange. vano vavikilue kuvalilua ikyang'haani usue twe viitiki kwa mwene juno alyansiluile uMutwa ghwitu uYesu kuhuma kuvafue. ");
INSERT INTO wbi_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","uju ghwe juno uNguluve alyamwumisie vwimila uvuhosi vwitu na kusyukulivua neke tupate kuvalilua ikyang'haani. ");
INSERT INTO wbi_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ulwakuva tuvalilue ikyang'haani ku sila ja lwitiko, tulinulutengano lwa Nguluve ku sila ja Mutwa ghwitu Uyesu Kilisite. ");
INSERT INTO wbi_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","kukilila umwene usue tuli ninafasi ku sila ja lwitiko mu vumosi uvu vuno nkate jake tukwima. tuhovokela ulukangasio luno uNguluve ikitupela vwimila pa mbele, ulukangasio luno tutangana mu vwimike vwa Nguluve. ");
INSERT INTO wbi_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","na lye ili lyene, kange tuhovoka mu lupumuko lwitu. tukagula kuuti imhumhuko sihola ulugudo. ");
INSERT INTO wbi_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ulugudo luhola kukwitika na kukwitika kuhola ulukangasio vwimila pambele. ");
INSERT INTO wbi_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ulukangasio ulu nalukutudenya inumbula ulwakuva ulughano lwa Nguluve luli nkate mu moojo ghitu kukilila uMhepo uMwimike juno uN