﻿USE sofia;
DROP TABLE IF EXISTS sofia.wat_vpl;
CREATE TABLE wat_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wat_vpl WRITE;
INSERT INTO wat_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kafa viuḡuwai Guyau abama keta fwayafwaya i fufunisiya. ");
INSERT INTO wat_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Eatu maiunuununa keta kawakakavina keta kumanovana kunukubana ogodibu i gikafufuya. Keta Guyau Kanununa etanei i kanukanuwedadaniya. ");
INSERT INTO wat_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Keta Guyau i bwaduwa, “Mayesina, ku kikinomana,” keta mayesina i kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Guyau mayesina i kitiya dewadewana eketa mayesina i nutakiya kumanovana nenei. ");
INSERT INTO wat_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Keta mayesina i weniya kuyadayada atu kumanovana i weniya nuwabuna. Keta navinavi i kakaviya atu nuwabuni i kikinomana, na naki kuyadayada kafa viuḡu. ");
INSERT INTO wat_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Guyau i bwaduwa, “Baiyavana, ku kikinomana ukowa kasi kawasasai be ku nutakiya kabaḡa nuwesi nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Eketa na naki maise i kikinomana. Guyau baiyavana i fufuniya ebe ina nutakiya ata kana ukowa keta tanowa kana ukowa. ");
INSERT INTO wat_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Baiyavananama i weniya abama. Keta navinavi i kakaviya atu nuwabuni i kikinomana, na naki kuyadayada kana vinuwa. ");
INSERT INTO wat_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Keta Guyau i bwaduwa, “Ukowa abama kanonovanei i kavivau kabaḡa tamokaḡa nenei atu fwayafwaya kasakasanina ku kikinomana.” Eketa na naki maise i kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kasakasanina i weniya fwayafwaya atu ukowa i kaviviya i weniya gibo. Keta Guyau i kitiya naki dewadewana. ");
INSERT INTO wat_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yota i bwaduwa, “Kisisiku tuninatunina fwayafwaya nenei i kawananaimi. Kai vivisisimi, kai na kavami be na susukwami.” Eketa na naki maise i kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Kisisiku tuninatunina fwayafwaya kasakasaninei si tafwa. Kai vivisisisi, kai na kavasi be na susukwasi si viuwa maise kiayonisi. Keta Guyau i kitiya naki dewadewana. ");
INSERT INTO wat_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Keta navinavi i kakaviya atu nuwabuni i kikinomana, kuyadayada kana vitonu. ");
INSERT INTO wat_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Keta Guyau i bwaduwa, “Kimayeta, kawasasakaoḡowai kwa kikinomana be kwa nutakai kuyadayada nuwabuna nenei be kwana vikiyakiyaya tutuya, kuyadayada, keta manamana. ");
INSERT INTO wat_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kwana tafa kawasasakaoḡowai be fwayafwaya mayesina kwana veniya.” Eketa na naki maise i kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Guyau kimayeta nuwesi nakanakasisi i fufunisiya, tafana nakasina kuyadayada ina visimeiya atu tafana kabegona nuwabuna ina visimeiya. Keta yota kinavinavi i fufunisiya. ");
INSERT INTO wat_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Guyau kimayeta kawasasakaoḡowai i tenisiya be fwayafwaya sina tafiya, ");
INSERT INTO wat_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","be yota sina visimeisiya kuyadayada keta nuwabuna be yota sina nutakiya mayesina kumanovana nenei. Keta Guyau i kitiya naki dewadewana. ");
INSERT INTO wat_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Keta navinavi i kakaviya atu nuwabuni i kikinomana, kuyadayada kana vinufunina. ");
INSERT INTO wat_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Guyau i bwaduwa, “Ukowa, ku maḡa gevageva tunisitunisi na yawasisi yota maise manuwa kawasasakaoḡowai.” ");
INSERT INTO wat_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Guyau i fufunisiya gibo kana kabikeya be iba tamokatamokaḡa ukowa sinenei yawayawasisi si savisavivina tututausi kasi kikitana maise, yota manuwa tamokatamokaḡa tauna kana kikitana maise. Keta Guyau i kitiya naki dewadewana. ");
INSERT INTO wat_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","I sawanuwagabubuwisiya keta i iyavisiya i bwaduwa, “Gevageva, kwana vinatunasiwasiwaḡa keta kwana yagwana be gibo kwana vimaiya. Manuwa, kwana vinatunafuwaḡa keta kwana yagwana fwayafwaya etanei.” ");
INSERT INTO wat_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Keta navinavi i kakaviya atu nuwabuni i kikinomana, kuyadayada kana vi5. ");
INSERT INTO wat_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Guyau i bwaduwa, “Fwayafwaya, yomuyomu tamokatamokaḡa ku gikikinomaneisi nimwauwai be kidagimai, be yota tooyaḡayaḡaḡa tamokatamokaḡa, tauna kana kikitana maise.” Eketa na naki maise i kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Eketa Guyau i fufunisiya yomuyomu nimwauwai be kidagimai, be yota tooyaḡayaḡaḡa tamokatamokaḡa, tauna kana kikitana maise. Keta Guyau i kitiya naki dewadewana. ");
INSERT INTO wat_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Keta Guyau i bwaduwa, “Namoḡa tana fufuniya kata kitakita maise ebe tasike kita maise. Be tasike nimasiyai tana tenisiya gibo kana iyana keta manuwa kawasasakaoḡowai, yomuyomu fwayafwaya kana matatafu nenei, yota tooyaḡayaḡaḡa fwayafwaya nenei si savisavivina.” ");
INSERT INTO wat_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Eketa Guyau namoḡa i fufunisiya tanake kana kitakita maise, Guyau kana kitakita maise i fufunisiya namoḡa, namoḡa keta gumayogu i fufunisiya. ");
INSERT INTO wat_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Guyau i sawanuwagabubuwisiya keta i iyavisiya i bwaduwa, “Kwana vinatunasiwasiwaḡa keta kwana yagwana, be fwayafwaya kwana vimaiya keta kwana visimeisiya. Gibo kana iyana yota manuwa kawasasakaoḡowai be yomuyomu matatafuna fwayafwayai si savisavivina, kwana visimeisiya.” ");
INSERT INTO wat_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Guyau i bwaduwa, “Iba matatafuna fwayafwayai maise kai vivisisisi keta kai viviuwasi, a venimiya tasike kami kabwaga. ");
INSERT INTO wat_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Keta yomuyomu-wanawanaki yota manuwa be tooyaḡayaḡaḡa fwayafwaya etanei na yawasisi, a venisiya kisaya o kabwaga fasinei.” Eketa na naki maise i kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Guyau iba matatafuna i fufunisiya, i kitiya naki dewabauna. Keta navinavi i kakaviya atu nuwabuni i kikinomana, kuyadayada kana vi6. ");
INSERT INTO wat_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Abama, fwayafwaya keta iba matatafusi kasi kikifufuna naki i kakaviya. ");
INSERT INTO wat_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Keta Guyau yana kifufuna i nusafuya, eketa kuyadayada kana vi7 nenei i vidawana eketa i viyawasiya. ");
INSERT INTO wat_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Eketa kuyadayada kana vi7 Guyau i sawanuwagabubuwiya keta i tenesiniya, uḡuna kuyadayadanama nenei o i viyawasiya yana kikifufuna kana bunanige matatafuna nenesiyai. ");
INSERT INTO wat_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Eketa namaise Guyau abama keta fwayafwaya i fufunisiya, naki maisemoka sifusifufuna. ");
INSERT INTO wat_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Keta Yave Guyau fwayafwaya kafusisimina nenei namoḡa i gikamakamiya. Keta i kawasiveiya yawasina namoḡa niunei keta namoḡa i yawasa. ");
INSERT INTO wat_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Keta Yave Guyau baguna i baguniya Ideni nenei gagasa kuweyaina keta namoḡanama i gikamakamiya nokomai i teniya. ");
INSERT INTO wat_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","I fufunisiya kai dewabausi nokomai si tafwa keta si sakuna uwasi dewadewasi. Baguna sinefounei kai nuwesi si misiniya. Kai tamokaḡa i misiniya o yawasi kana kai eatu tamo o dewadewana keta goyona kasi kafa sanamana kana kai. ");
INSERT INTO wat_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Keta Yave Guyau namoḡa baguna Ideni sinenei i teniya be ina saviviniya keta yota ina kitavikaviniya. ");
INSERT INTO wat_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yave Guyau namoḡa i iyaviya i bwaduwa, “Ka nufota avi kai uwana kuna kaniya baguna sinenei. ");
INSERT INTO wat_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Atu namai dewadewana keta goyona kasi kafa sanamana kana kai muka nenei kuna ka. Tovanama kuna kaniya, kuna mateya.” ");
INSERT INTO wat_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yave Guyau tauna nenei i bwaduwa, “Namoḡa kana kisina i fakwafakwa atu muka dewadewana. Unana ana fufuniya be ina ovivitiya.” ");
INSERT INTO wat_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Keta fwayafwaya i viya keta yomuyomu matatafusi be manuwa matatafusi i gikamakamisiya. Keta i nemiisiya namoḡa nenei be ita kitiya namoḡa namaise kasi wava ita kavenena, keta namaise kasi wava i viweneya naki maise kasi wava. ");
INSERT INTO wat_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Namoḡa, manuwa kawasasakaoḡowai be yota yomuyomu nimwauwai eketa kidagimai matatafusi kasi wava i kavenena, eatu muka tamo nama ita nufotai Adama kana toovivita. ");
INSERT INTO wat_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Eketa Yave Guyau namoḡa i visanafuwiya keta i banumatemateya. Keta yawane i banubanuwa nenei, Guyau namoḡa ninivatavatanina i viya atu viyo nenei kawakivina i tenefotiya. ");
INSERT INTO wat_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yave Guyau gumayogu i gikamakamiya namoḡa ninivatavatanina nenei eketa i nemiiya namoḡa nenei. ");
INSERT INTO wat_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Namoḡa i bwaduwa, “Nofe tanake, seḡa o iyau seḡaku keta viyo o iyau viyoku. Nofe tanake Namoḡa sinenei i viya, na fasinei ana weniya Gumayogu.” ");
INSERT INTO wat_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Na fasinei namoḡa amana keta ayona ina teweisiya eatu kawana nukusi sina saviya tamo nenei, eketa kasi nuwa sina vitamokaḡa. ");
INSERT INTO wat_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Namoḡa keta kawana nukusi gonegonesi atu muka sita sinemumu. ");
INSERT INTO wat_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yomuyomu kidagimai Yave Guyau i fufunisiya sinesiyai mwata tanake tovikanononoonaona. Mwata gumayogu i nutonidadaniya i bwaduwa, “Venemokena Guyau i iyavimiya muka uwa kwana ka kaisima baguna sinenei?” ");
INSERT INTO wat_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Gumayogu i bwaduviyewa i bwaduwa, “Muka, kima kama nufota kaisima uwasi baguna sinenei kana kawa, ");
INSERT INTO wat_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","atu kai tamokaḡa baguna sinefounei i misimisiniya, Guyau i iyavikiya i bwaduwa, ‘Muka kainama uwana kwana kaniya keta muka kwana ginuvanuvai. Taki kwana saviviniya na naki kwana mateya.’” ");
INSERT INTO wat_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mwata i iyaviya i bwaduwa, “Muka venemokena. Muka kwana mate. ");
INSERT INTO wat_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kuyadayadanama nenei kwana kaniya, matami sina kabwasasa keta kwami vitana Guyau maise kwana sanamaniya dewadewana keta goyona. Guyau i sanamaniya keta na fasinei i sawatanimiya muka kwana kaniya.” ");
INSERT INTO wat_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Gumayogu i kitiya kai dewadewana kana nufota kabwaga keta kana fusa dewadewana. Nuwanuwana ina kaniya be ina sanamana, na nenei aviyesi uwana i visiya keta i kaniya, atu tunina kawana i veniya keta i kaniya. ");
INSERT INTO wat_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tovanama nenei matasi si kabwasasa keta si sanamaniya tasike gonegonesi na nenei nugweda dadana si yuna keta si suyakafukafuwa si dawanafota. ");
INSERT INTO wat_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tovanama navinavi kabaḡa i tunuwa, si nowaniya Yave Guyau baguna nenei i niniya. Namoḡa keta kawana si makaviuna kai nenesiyai be Yave Guyau muka ina kitaisi. ");
INSERT INTO wat_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Atu Yave Guyau namoḡa nenei i bwauwa i bwaduwa, “Kwaḡa namai?” ");
INSERT INTO wat_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Namoḡa i bwaduviyewa i bwaduwa, “A nowaniwa baguna nenei. Iyau gonegoneku na fasinei a matuta keta a makaviuna.” ");
INSERT INTO wat_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Yave Guyau i nutoninuvanuva i bwaduwa, “Aitevana i iyaveu kwaḡa gonegoneu? Kainama a iyaviwa muka kuna kaniya, naki ku kaniya?” ");
INSERT INTO wat_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Namoḡa i bwaduviyewa i bwaduwa, “Gumayogunama ku venikuwa, tanake i venikuwa kai uwana keta a kaniya.” ");
INSERT INTO wat_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yave Guyau gumayogu i nutoninuvenuviya i bwaduwa, “Ei, ava ku fufuniya?” Gumayogu i bwaduviyewa i bwaduwa, “Mwata i nonukuwa keta a kaniya.” ");
INSERT INTO wat_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yave Guyau mwata i iyaviya i bwaduwa, “Na ava ku fufuniya fasinei, ana vimatadawaniwa yomuyomu nimwauwai be kidagimai matatafusi sinesiyai. Kwaḡa kuna oyaḡaḡa manawaweu keta kafusisima o ka kabwaga yawasiu kana matatafu nenei. ");
INSERT INTO wat_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ana visanafuwiwa kwaḡa keta gumayogu kwana vikaniyabina, keta kwaḡa susukwau keta gumayogu susukwana sina vikaniyabina. Tanake debabouḡu ina nufuwaiya atu kwaḡa kaeketuketuna kuna kanavasiya.” ");
INSERT INTO wat_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Gumayogu nenei i bwaduwa, “Ana visanafuwiwa dauna kuna nisaiya tovanama kuna visifuḡa nenei, nofe tovanama keta ina niya kuvavana nakasina vinatuna nenei. Nuwanuwau be kawau nukusi, atu tanake kwaḡa ina vanetaniwa.” ");
INSERT INTO wat_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adama nenei i bwaduwa, “Kawau fonana ku nowaniya fasinei keta kainama a iyaviwa muka kwana kaniya atu kwa kaniya, keta kwaḡa neneweu fwayafwaya a ituituya. Bunanige kuvakuvavanina kuna saviviniya yo ka kabwaga kuna nisaiya yawasiu kana matatafu nenei. ");
INSERT INTO wat_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Fwayafwaya ina okikinomaniya kisisiku kikikwanekwanesi keta sakasakanunusi, keta noko bwibwiyagunama kabwagina nenei kuna kawa. ");
INSERT INTO wat_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kuna fwasimowa bunanige nenei yo ka kabwaga kuna viya kana nivaniva kuna makaviniwa fwayafwaya nenei. Kafusisima a viya fwayafwaya nenei keta a gikamakamiwa, keta kwaḡa kuna vikafusisima-savaviniwa.” ");
INSERT INTO wat_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Namoḡa i sanamaniya kawana ina viayowa namoḡa fakwafakwasi matatafusi nenesiyai, na fasinei i weniya Ive. ");
INSERT INTO wat_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yave Guyau yomuyomu kwafinisi i yuna keta nuya i fufunisiya Adama keta kawana fasisiyai keta i vikotonisiya. ");
INSERT INTO wat_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yave Guyau tauna nenei i bwaduwa, “Namoḡa i nemiya kita maise keta i sanamaniya dewadewana keta goyona. Muka nimana ina tunei kai yawasi i kakavenena, uwana ina vai ina kaniya be muka ina fakwavaḡata.” ");
INSERT INTO wat_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Keta Yave Guyau i vikikinomanisiya baguna Ideni nenei, be namai fwayafwayanama nenei i gikamakamiya Adama ina bunanigeiya. ");
INSERT INTO wat_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","I vikikinomanisiya muninei keta i iyavisiya kikifufuna kasi wava senabimu sina misiniya gagasa keweyaina baguna Ideni nenei. Yota i teniya feto nununuina keta nuganavivineinana be tasike sina viketofotiya ke'ta i niniya yawasivaḡata kana kai nenei. ");
INSERT INTO wat_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adama kawana Ive nukusi si mataveya keta Ive si visifuḡa eketa si vinatuna. Si bwaduwa, “Yave yana ovivita nenei natuki ka nisaiya.” Na uḡuna si weniya Keni. ");
INSERT INTO wat_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Muniyai yota taina namoḡa si vinatuniya keta si weniya Ebeni. Tovanama si nakata, Ebeni sifi kasi tokitavikavina atu Keni i vitobaguna. ");
INSERT INTO wat_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Tova tamokaḡa Keni yana bagubaguna kabwagina i nemiisiya keta i vibwanaoseiiya Yave nenei, ");
INSERT INTO wat_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","atu Ebeni yana sifi si mikivinatuna, tanaina dewabauna i nemiiya eketa i vibwanaoseiiya Yave nenei. Yave i katuvisiya Ebeni keta yota yana bwanaose, ");
INSERT INTO wat_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","atu Keni keta yana bwanaose muka ita katuvaisi. Keni i kayokuḡa keta kana nawenawe i dawanavinavina nuwagoyo. ");
INSERT INTO wat_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Keta Yave Keni i iyaviya i bwaduwa, “Ava uḡuna ku nuwagoyo yo tafakaiu i kanawenonoi? ");
INSERT INTO wat_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Taki fufuna dawaniniina kuta saviviniya nao ata katuviwa. Atu fufuna goyona ku saviviniya fasinei, matau ina kakanakasiya! Go'yona niniuweu i kenokenovikifafa be ina ketosesena yomuyomu-wanawanaki maise. Go'yona nuwanuwana nakasina be ina visimeiwa atu kwaḡa kuna vanetaniya.” ");
INSERT INTO wat_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Keta muninei Keni taina Ebeni i iyaviya i bwaduwa, “Ta nai wanakiyai ta nidadana.” Tovanama nokomai, Keni i misiniya keta taina Ebeni i nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tovanama ibanama i kikinomana muninei, Yave i nutoninuvenuviya i bwaduwa, “Taiu Ebeni namai?” Keni i bwaduviyewa Yave nenei i bwaduwa, “Muka ata sanamanei tanake namai. Namaise, o iyau unaku kana tokitavikavina?” ");
INSERT INTO wat_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Atu Yave i iyaviya i bwaduwa, “Ava uḡuna yo fufuna goyomokena ku savivinei? Taiu ufaufana kayona fwayafwayai i bwedibwedi-kikinomana nenekuwai. ");
INSERT INTO wat_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Keta nofe tova ana ituwa. Unau ku nuvimatiya keta ufaufana fwayafwaya ku viyumiya, na fasinei muka fwayafwayanama kuna savivinei. ");
INSERT INTO wat_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Nofe tova keta tova si nenemiya, tovanama fwayafwaya kuna saviviniya, muka kabwaga ina veneu. Muka tamo ya kafa fakwa keta kuna vitovenukaokaoḡowa fwayafwayai.” ");
INSERT INTO wat_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Keni Yave i iyaviya i bwaduwa, “Kaku vimatadawana i nakatamoka, muka kaku fata. ");
INSERT INTO wat_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kimoki kwaḡa ku kwavikwavinikuwa fwayafwaya nofe nenei keta yota neneweu. Ana vitovenukaokaoḡowa fwayafwaya etanei keta aitevana ina nisaikuwa, ina nuvimatikuwa.” ");
INSERT INTO wat_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Atu Yave i nufata i bwaduwa, “Muka. Taki tamo aitevana ina nuvimatiwa, yawasi 7 ana nuyaunisiya kwabu fasinei.” Na fasinei Yave kiyakiyaya i teniya Keni nenei be aitevana ina venusaiya, muka ina nuvimatei. ");
INSERT INTO wat_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Keta Adama kawana nukusi yota si mataveya keta namoḡa i tufuwa. Ive si bwaduwa, “Keni i nuvimatiya Ebeni fasinei, Guyau gwadimonamona yota i venikiya be Ebeni ina noseyaniya.” Na fasinei si weniya Seta. ");
INSERT INTO wat_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seta yota i vinatuna keta i weniya Inosi. Inosi yana tovai, namoḡa si vibutuwa si kodukoduwa Yave nenei. ");
INSERT INTO wat_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yave i kitiya namoḡa matatafusi yasi fufunagoyo i nakatamoka fwayafwayai, keta iba matatafuna si nuwenuwiya keta si vivinuwadadanisiya o goyona venemokena tova kana matatafu. ");
INSERT INTO wat_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yave tauna i vinuwakuvaniya namoḡa i fufunisiya keta i tenisiya fwayafwayai, na fasinei nuwatana i dauna. ");
INSERT INTO wat_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Eketa Yave i bwaduwa, “Namoḡa matatafusi ana nuyaunisiya fwayafwaya nofe etanei. A vinuwakuvanikuwa uḡuna naki a fufunisiya. Na fasinei namoḡa kasi matatafu keta yomuyomu nakanakasisi matatafusi be musumususi si ooyaḡayaḡaḡa fwayafwaya etanei, yota manuwa matatafusi kawasasakaoḡowai ana nuyaunisiya.” ");
INSERT INTO wat_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Atu Yave o Nowaḡa i sebobowiya. ");
INSERT INTO wat_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nowa keta ugunina sifusifufusi nofemaise. Nowa natunatuna nasi tonu namoḡa kasi wava Semi, Ami, keta Yafeta. Nowa o namoḡa dewadewana, tanake kana kisimokena fwayafwaya etanei eyaeyana tovasima nenesiyai. Nowa Guyau i viunaniya. ");
INSERT INTO wat_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Atu Guyau i kitiya fwayafwaya matatafuna i goyowa eketa vikamunumunuwa i kataneneḡa. ");
INSERT INTO wat_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Guyau i toneiya fwayafwaya keta i kitiya naki i goyomoka uḡuna namoḡa matatafusi ke'ta goyona nenei si fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Keta Guyau Nowa i iyaviya i bwaduwa, “A vinuwadadana be namoḡa matatafusi ana nuyaunisiya uḡuna vikamunumunuwa fwayafwaya i vimaiya. Fwayafwaya kana matatafu etanei iba matatafuna ana nuyauniya. ");
INSERT INTO wat_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Na fasinei waka kitagoyona kuna yoniya tauḡu fasiweu. Kai fakinisi nenesiyai kuna yoniya. Sisiuna kuna kitutunaonota waka sinenei. Sinena keta kwauna kuna nutamaniya kibasi nenei. ");
INSERT INTO wat_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kuna yoniya nofemaise. Kana fwafwa kana niva 140 mita, kana nafanafa kana niva 22 mita, keta yana vivivane kana niva 14 mita. ");
INSERT INTO wat_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kudukudu kuna teweiya keta kawasasa kana niva 50 senitimita kuna teniya kudukudu keta fita kasi kawasasai ina fanakwaniuḡa. Waka niniunei kawa kuna fufuniya. Baionota tonusi kuna yonisiya — etana, sinefouna, keta sifuna. ");
INSERT INTO wat_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ku vaneneḡa! Ukowasobu ana teweiya keta fwayafwaya kana matatafu ina unakafufuya be iba matatafuna na yawasina fwayafwaya etanei ina nuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Atu kaku dedeni a teneteniya neneweu. Kwaḡa, kawau, keta natunatuu nakakawasi kwana kanasuna waka sinenei. ");
INSERT INTO wat_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Yomuyomu tunisitunisi nakakawasi kuna totoisiya nukusi. Tamokaḡa namoḡa keta tamokaḡa gumayogu, manuwa tunisitunisi nenesiyai kuna nemiisiya keta yomuyomu nakanakasisi be musumususi si ooyaḡayaḡaḡa, kuna kitavikavinisiya ebe yawayawasisi sina fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Yota kabwaga tuninatunina yagwanina kuna totoiya, uguniu nukusi fasimiyai keta yota yomuyomu fasisiyai.” ");
INSERT INTO wat_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Eketa Nowa iba matatafuna i saviviniya Guyau i iyaviya maise. ");
INSERT INTO wat_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yave Nowa i iyaviya i bwaduwa, “Kwaḡa ka kisimokeu fwayafwaya nofe nenei ya fufuna dawaniniina. Na uḡuna kwaḡa keta uguniu kwa kanasuna wakai. ");
INSERT INTO wat_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nama yomuyomusima eyaeyasi, kuna visiya namoḡa 7 keta kakawasi 7. Atu yomuyomusima muka eyaeyasi, nao tamokaḡa namoḡa keta kawana. ");
INSERT INTO wat_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Keta yota manuwa kuna visiya 7 keta yota kakawasi 7. Nofe kuna saviviniya be yomuyomu keta manuwa tunisitunisi be yota sina geyana fwayafwayai. ");
INSERT INTO wat_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kuyadayada 7 muninei, bwabwau ana teweiya keta ina sigwana fwayafwayai kana nivaniva kuyadayada 40 keta nuwabuna 40, ebe kikifufuna matatafuna a fufuniya na yawasina fwayafwayai ana nuyaunisiya.” ");
INSERT INTO wat_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Keta Nowa iba matatafuna i saviviniya avana Yave i iyaviya maise. ");
INSERT INTO wat_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ukowasobu i unauna kana nivaniva kuyadayada 40 eketa waka i nufutefuteiya fwayafwaya etanei. ");
INSERT INTO wat_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Keta iba matatafuna na yawasina fwayafwaya etanei Yave i nuyaunisiya ukowasobuwai. Namoḡa matatafusi be yomuyomu nakanakasisi be musumususi si ooyaḡayaḡaḡa, yota manuwa nukusi, si mateya. Atu naki aviyaonana waka sinenei Nowa nukusi, nao si fakwa na yawasisi. ");
INSERT INTO wat_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Eketa Guyau Nowa i nusifufuwiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Kwaḡa na kawau keta yota natunatuu na kakawasi nukusi waka kwana teweiya atu kwana sobuwa menanai. ");
INSERT INTO wat_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kikifufuna matatafusi yawayawasisi kuna ovisiya maise manuwa, yomuyomu keta yota matatafusi tooyaḡayaḡaḡa fwayafwaya nenei, be sina vinatunasiwasiwaḡa keta sina yagwana be yo sina geyana fwayafwaya kana matatafu etanei.” ");
INSERT INTO wat_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Keta Nowa na kawana, keta natunatuna na kakawasi, waka si teweiya atu si kikinomana menanai. ");
INSERT INTO wat_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Matatafusi yomuyomu, manuwa keta tooyaḡayaḡaḡa wakai si kikinomana kasi sabusabuwai. ");
INSERT INTO wat_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Keta Nowa didiḡa i didiiya kafa vibwanaose Yave nenei eketa yomuyomu be manuwa eyaeyasiḡa nenesiyai, tunina i visiya keta i gumatatafusiya didiḡa etanei bwanaose fasinei. ");
INSERT INTO wat_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Tovanama bwanaose madina i sebobowiya, Yave tauna nuwasinenei i bwaduwa, “Muka yota tova munina namoḡa yasi fufuna fasinei fwayafwaya ana ituya. Naki a sanamaniyanamoḡa musumususiyai keta si nakanakata, katekatesiyai goyona si nuwinuwiisiya atu mukamokena yota ana nuyauneisi iba tamokatamokaḡa na yawasina maise kimoki a fufuniya. ");
INSERT INTO wat_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tovasima fwayafwaya ina fakwafakwa, baguna be kiyana, yaseḡana be kwadudu, gagasa be yavanata, kuyadayada be nuwabuna sina fakwafakwa, muka ina kakaveisi.” ");
INSERT INTO wat_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Keta Guyau Nowa na natunatuna i sawanuwagabubuwisiya i iyavisiya i bwaduwa, “Kwana vinatunasiwasiwaḡa keta kwana yagwana be kwana geyana fwayafwaya kana matatafu nenei. ");
INSERT INTO wat_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Yomuyomu matatafusi nakanakasisi be musumususi si ooyaḡayaḡaḡa fwayafwayai be manuwa keta iyana sina oomatumatutimiya eketa kwami kwana visimeisiya. ");
INSERT INTO wat_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Iba tamokatamokaḡa na yawasina o kami kabwaga. Naki maise manatuwaina a venimiya kai viviuwasi keta kisaya o kafa kaka. Nofe tova a venevenimiya iba matatafuna kami kabwaga. ");
INSERT INTO wat_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Atu muka viyo na ufaufana kwana kaniya uḡuna yawasi ufaufa sinenei. ");
INSERT INTO wat_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Namoḡa a fufunisiya tauku kaku kitakita maise eketa avi namoḡa o avi yomuyomu tamo namoḡa ina nuvimatiya, tanake namoḡanama o yomuyomunama ana vimatadawaniya. Taki tamo yomuyomu namoḡa ina nuvimatiya, yomuyomunama sina nuvimatiya. Maise yota taki aitevana namoḡa tamo ina nuvimatiya, namoḡanama sina nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Atu kwana vinatunasiwasiwaḡa keta kwana yagwana ebe fwayafwaya kwana vimaiya.” ");
INSERT INTO wat_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Keta Guyau Nowa na natunatuna i iyavisiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kwa vaneneḡa! Nofe tova yaku dedeni ana fufuniya kwami nenemiyai eketa yota susukwami yawane si nenemiya nenesiyai, ");
INSERT INTO wat_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","yota kikifufuna matatafusi yawayawasisi maise manuwa be yomuyomu-menana yota yomuyomu-wanawanaki wakai nukusi, matatafumi fwayafwayai nenemiyai. ");
INSERT INTO wat_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nofe bwadusima nenesiyai kaku dedeni a oovikavikaviniya kwami nenemiyai. Mukamokena yota ana visimeyei ukowasobu be kikifufuna yawayawasisi ina nuvimateisi yota fwayafwaya ina nuyaunei.” ");
INSERT INTO wat_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Guyau i iyavisiya i bwaduwa, “Dedeni kana kiyakiyaya a fufufuniya Iyau, kwami keta kikifufuna yawayawasisi nukusi kata kawasasai, yota tova i nenemiya sabusima fasisiyai. ");
INSERT INTO wat_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Yaku tanikubo ana teniya busibusi sinenei be ina vikiyakiyaya yaku dedeni Iyau keta fwayafwaya kana matatafu kata kawasasai. ");
INSERT INTO wat_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tovanama kawasasakaoḡo ana gikafufuya busibusi nenei keta tanikubo ina kikinomana, ");
INSERT INTO wat_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ana tukunakasiya yaku dedeni, Iyau keta kwami be kikifufuna matatafusi na yawasisi kata kawasasai be mukamokena yota ukowasobu yawasi matatafuna ina nuyauneisi.” ");
INSERT INTO wat_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nauna o namoḡa matatafusi fwayafwaya etanei, fona tamokaḡamoka kana kituwai si nusifufuwa. ");
INSERT INTO wat_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Noko tovanama nenei, namoḡa si toḡavenudadana gagasa kuweyaina. Fafani kana wava Sina nenei, fwayafwaya katuyaveyavenina nakasina si nisaiya keta nokomai si fakwa. ");
INSERT INTO wat_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Keta tututausi nenesiyai si nusifufuwa si bwaduwa, “Kwa nemai, taga tana viya be tana yafofwisiya keta tana nukwafusiya be sina fakina.” Si saviviniya keta taga kikiyafofosi si kiyoniiya keta kibasi nenei si gimaimaiiya. ");
INSERT INTO wat_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Eketa si nusifufuwa si bwaduwa, “Kwa nemai, be menana nakasina tana vikanasiya tututauta fasitiyai, numa tana yoniya manuwanoḡomatesi, be ina vaneya abama ina oviya. Nofemaise tana fufuniya be tututauta kata wava tana givinakasiya ebe muka tana kafiyauyauna fwayafwaya kana matatafu nenei.” ");
INSERT INTO wat_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Si kikiyona atu Yave i sobunemiya be ina kitiya menana nakasina yota numa manuwanoḡomatesi namoḡa si yonayoniya. ");
INSERT INTO wat_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Keta Yave i bwaduwa, “Nofe tova tasike naki yoko tamokaḡa, fona tamokaḡa nenei si nunusifufuwa. Nofe tova si vibutuwa keta sina savivina maise ebe tova munina aviyavana tamo si nuwenuwiya, naki kasi nufotamoka be sina saviviniya. ");
INSERT INTO wat_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kwa nemai, tana sobuwa be fonasi tana wenuya be muka tututausi sina sanamanei unaunasi yasi bwadu.” ");
INSERT INTO wat_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Eketa Yave i nuyauyaunisiya fwayafwaya kana matatafu nenei, eketa menana nakasina kana vikanata si vidawana. Nokomai Yave fwayafwaya kana matatafu namoḡa fonasi i wenuya. Na fasinei menana noko si weniya Babeni. ");
INSERT INTO wat_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yave Ebenamu i iyaviya i bwaduwa, “Ya menana keta ya sabu yota ya fasekwa kuna teweisiya, atu fwayafwayanama ana visawaveniwa nenei kuna niya. ");
INSERT INTO wat_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ka sabu nakasina ana veniwa keta tasike nenesiyai kunuma nakasina ina kikinomana. Iyau ana sawanuwagabubuwiwa. Ka wava yota ana givinakasiya be namoḡa matatafusi sina sanamaniya keta sina vifotuwiwa. Kwaḡa neneweu, namoḡa kasi sawanuwagabubu sina nisaiya. ");
INSERT INTO wat_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Tovanama namoḡa sina sawanuwagabubuwiwa, Iyau yota ana sawanuwagabubuwisiya. Atu taki namoḡa sina ituwa, Iyau yota ana itusiya. Kwaḡa neneweu, namoḡa matatafusi fwayafwaya etanei ana sawanuwagabubuwisiya.” ");
INSERT INTO wat_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Na tovanama nenei Ebenamu kana manamana 75. Keta i saviviniya avana Yave i iyaviya maise. Anani i teweiya na kawana Sanai keta auna Nota nukusi. Tovanama Anani si fakwa nenei, Ebenamu yana nogonogo keta yana yomuyomu keta yota yana tobunanige i nisaḡa. Nofe ibasima nukusi i visiya keta Kenani kuweyaina si niya. Tovanama si kikinomana Kenani kana baionota nenei, ");
INSERT INTO wat_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ebenamu yana sabu nukusi noko fwayafwayanama si venuonosiya keta si niya menana nakasina kana wava Sekemu niniunei. Nokomai kai nakasina niniunei si vikabaḡa menana Mone nenei. Tovanama nenei Kenani fiyaosi yawane si fakwafakwa noko fwayafwayanama nenei. ");
INSERT INTO wat_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nokomai Yave tauna i tenekikinomaniya Ebenamu nenei eketa i iyaviya i bwaduwa, “Nofe Kenani fwayafwayana susukwau ana venisiya.” Eketa Ebenamu, kafa vibwanaose Yave nenei kana didiḡa i didiiya. Namai Yave tauna i visawaveniya nenei, i vimisiniiya. ");
INSERT INTO wat_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na tovanama nenei, Nota keta Ebenamu yawane tamo nenei si ninidadana. Nota yota yana yomuyomu yagwanisi keta yota namoḡa yagwanisi nukusi yana vada nenesiyai si fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ebenamu keta Nota yasi yomuyomu si yagwanamataiya keta yasi kafa ka kana kabaḡa o muka kasi fata. Na fasinei nasi nuwa muka kasi fata be tamokaḡa fwayafwayanama nenei sina fakwa. ");
INSERT INTO wat_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Keta Ebenamu Nota i iyaviya i bwaduwa, “Ku vaneneḡa! Kita ugunita, na uḡuna muka tana vikawabwadubwadu keta yota yata yomuyomu kasi tokitavikavina muka tututausi nenesiyai sina vivigwaeḡa. ");
INSERT INTO wat_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Na uḡuna tana toḡasisina be tana niya kabaḡa tuninatunina nenesiyai. Fwayafwaya noko nautiyai ku kitakitiya. Ku vinuwadadanei avi kabaḡa nuwanuwau maise o ku nai be nokomai ku fakwa. Taki kuna niya kukikikataita kuweyaina, nao iyau ana niya kukikimawata. Eatu taki kuna niya kukikimawata kuweyaina, nao iyau ana niya kukikikataita.” ");
INSERT INTO wat_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Eketa Nota matana i tewetamaniya Yonidani ukowa kuweyaina keta i niya kana nivaniva Sowa menana nenei. Ukowa yagwanina yota fwayafwaya dewadewana i kitiya vitana Yave yana baguna maise yota fwayafwaya dewadewana vitana Itifita nenei maise. (Na tovanama nenei Sodoma keta Gomona o Yave yawane muka ita nuyauneisi.) ");
INSERT INTO wat_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nota i vinuwadadaniya fafani Yonidani kana matatafu tauna fasinei eketa i niya gagasa kuweyaina. Nofe ketaketanama nenei Nota keta Ebenamu si toḡasisina. ");
INSERT INTO wat_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebenamu o Kenani fwayafwaya nenei i fakwa atu Nota o Yonidani kana kawanau nenei i fakwa Sodoma menana nakasina niniunei. ");
INSERT INTO wat_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodoma namoisi yasi fufuna naki goyomataina. Fufuna goyomokesi Yave matanei si savivinisiya. ");
INSERT INTO wat_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ebenamu keta Nota yasi toḡasisina muninei, Yave Ebenamu i iyaviya i bwaduwa, “Ku kitadadana-fanakwaniuḡa-dewadewa fafani tamokatamokaḡa nenesiyai — bomatu, gagasa, nanakoya keta yavanata kuweyaisi — namai matau ina niya kana nivaniva maise. ");
INSERT INTO wat_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Fwayafwayanama matatafuna ku kitakitiya, kwaḡa keta susukwau nukusi ana venimiya. Noko yami fwayafwayavaḡata. ");
INSERT INTO wat_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ka sabu ana veniwa o muka tamo aitevana kana fata be ina ginaḡanaḡaisi. Naki maisemoka genasa fwayafwayai muka tamo aitevana kana nufota be ka sabu ina ginaḡanaḡaisi. ");
INSERT INTO wat_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Nofe fwayafwayanama matatafuna a veneveniwa, na fasinei ku nai ku vadadaniya be ku kitadewadewai.” ");
INSERT INTO wat_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Keta Ebenamu i noḡokawawa keta Mamene kana kai nakanakasisi niniusiyai i vikabaḡa Ebinoni menana nakasina nenei. Nokomai didiḡa i didiiya Yave nenei. ");
INSERT INTO wat_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Sodoma keta Gomona fiyaosi kasi kaniyabina si nemiya keta yasi nogonogo be kasi kabwaga matatafuna si yuna. Ebenamu auna Nota Sodoma i fakwafakwa, tanake tauna keta yana nogonogo matatafuna yota si visiya keta si niisiya. ");
INSERT INTO wat_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tamokaḡa namoḡa vikamunumunuwa nenei i dibwana keta i nemiya Ebenamu biga i veniya. Tovanama nenei Ebenamu tene Ibeniu i fakwafakwa tene Amonai kana wava Mamene yana kai nakanakasisi niniusiyai. Mamene na sisitaina, Esikoni keta Ane, si vinowaniya Ebenamu vitana nukusi sina vikaovivita vikamunumunuwa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ebenamu yana tonuaviya kasi yagwana 318 yana kabaḡai si tufuwa. Tovanama i nowaniya nifanifaisi auna si viya, yana namonamoḡa matatafusi i wenevakukusisiya keta nifanifaisi si kwavinisiya kana nivaniva Dani menana nakasina nenei. ");
INSERT INTO wat_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tovanama i kumanovana, Ebenamu yana tonuaviya i vitukuwisiya yoko nenesiyai keta nifanifaisi si kanasunisiya fafani tuninatunina nenesiyai keta si vatanisiya. Nifanifaisi si dibwana eketa Ebenamu yana namonamoḡa nukusi si omunitawisiya kana nivaniva Oba menana nakasina Damasiko bomatu kuweyaina. ");
INSERT INTO wat_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ibasima matatafuna nifanifaisi si gikumisiya, matatafuna i visiya. Yota Nota na yana nogonogo nukusi keta vivine be mani namoḡa matatafusi nukusi i nemiye-savavinisiya. ");
INSERT INTO wat_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Menekisedeki i nemiya keta Ebenamu i venufotefotiya. Tanake Sanema menana nakasina kana tufomu keta yota Guyau Etanemokenei yana tovibwanaose. Maneka keta waini i nemiisiya keta Ebenamu i veniya. ");
INSERT INTO wat_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Menekisedeki Ebenamu i sawanuwagabubuwiya i iyaviya i bwaduwa, “Guyau Etanemokenei abama keta fwayafwaya i fufunisiya, iba dewadewasi fasiweu ita savivinisiya. ");
INSERT INTO wat_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Guyau Etanemokenei nifanifaiu nimaweu i tenisiya, na fasinei tana daviya.” Eketa Ebenamu nogonogosima i visiya nifanifaina nenesiyai, dawana 10 i tenisiya keta dawananama nenei tamokaḡa Menekisedeki i veniya. ");
INSERT INTO wat_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Muniyai Yave Ebenamu kenokita nenei i iyaviya i bwaduwa, “Ebenamu, muka kuna matuta. Iyau ya veve, Iyau fatau nakatamokena ana veniwa.” ");
INSERT INTO wat_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ebenamu i nufata i bwaduwa, “Yaku Tuveka Yave, iyau muka tamo natuku na uḡuna ya nuwagabubunama muka ina oviviteiku. Muka tamo natuku kuta veneiku. Keta taki ana mateya, Eniyesa tanake tene Damasiko kaku toovivita, yaku kaikaiwabu matatafuna ina viya.” ");
INSERT INTO wat_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Atu Yave i bwadu-savaviniya i bwaduwa, “Muka noko namoḡanama ya kaikaiwabu ina vai. Naki kwaḡa taumokeu uyoweu, natuu ina tufuwa. Kuna mateya nenei, tanake ina vikaiuḡuniya.” ");
INSERT INTO wat_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","I oviya i kikinomaniya menanai eketa i iyaviya i bwaduwa, “Matau i vane kawasasakaoḡowai be yamasi kinavinavi ku ginaḡanaḡa-nuvanuvaisi, taki ka fata maise. Yawane susukwau maise kinavinavi. Muka tamo aitevana kana fata be ina ginaḡanaḡaisi.” ");
INSERT INTO wat_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebenamu i vitumaḡaniya Yave yana bwadunama, na fasinei Yave i sebobowiya eketa i bwaduwa tanake eyaeyana matanei. ");
INSERT INTO wat_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tova vanavana i sonusonuwa nenei, Ebenamu i kenomatemateya kana tovai, kumanovana kitagoyona be matuta i kabwanatauniya. ");
INSERT INTO wat_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Keta Yave i iyaviya i bwaduwa, “Nofe kuna sanamanadewadewiya. Susukwau sina viyauyauna mani fwayafwayai. Tonifwayafwaya susukwau sina vikaetoisiya keta yota sina vitoagoyogoyowisiya manamana 400 sinenei. ");
INSERT INTO wat_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Atu yawane tonifwayafwayasima yasi vitoagoyogoyo fasinei ana vimatadawanisiya eatu susukwau sina vikukuwauna keta fwayafwayanama sina teweiya. ");
INSERT INTO wat_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Amonai namoisi nofe tova Kenani fwayafwaya nenei si fakwifakwiiya, taki tovanama yasi dewa ina goyomataiya, ana vimatadawanisiya keta ana kwavinisiya nofe fwayafwayanama nenei be sina yauna. Na uḡuna susukwau muka sina venumakavinaisi nofe kabainama nenei atu minominou yasi tovai yoke. Atu kwaḡa tauḡu Ebenamu kuna vituvekamoka yo muniyai, biganei kuna mateya keta sina tauniwa.” ");
INSERT INTO wat_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Ebenamu nofe tova Kenani i fakwafakwa naki manamana 10 atu kawana Sanai o kakanina, na fasinei keta muka tamo natuna ita vinatunei. Atu kana tookakikakina i viya ne Itifita kana wava Ega, na fasinei Sanai Ebenamu i iyaviya i bwaduwa, “Yave i nuvikakanikuwa be muka ana vinatuna, na fasinei ku nai be kaku tookakikakina nukusi kwa matave. Taki ina vivinatuna, gwadimonamona ana weniya vitana maise iyau natuku.” Fonana i vinowaniya keta Sanai yana kaetoḡa gumayogu Ega i veniya Ebenamu vitana kawana kana vinuwa. ");
INSERT INTO wat_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Muniyai, Ega Ebenamu natuna namoḡa si vinatuniya keta i weniya Isimeni. ");
INSERT INTO wat_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tovanama Ebenamu kana manamana 99, Yave i kenokikinomana nenei keta i iyaviya i bwaduwa, “Iyau Guyau Tofiwanaonaona. Yaku ketaketai kuna niya be muka kuna go'yona, ");
INSERT INTO wat_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ebe yaku dedeni ana fufuniya neneweu ebe susukwau ana giviyagwanisiya.” ");
INSERT INTO wat_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ebenamu kaetutuna i viketogunisiya maise yota debabouna eatu Guyau i iyaviya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Iyau nenekuwai o nofemaise ku vaneneḡei. Yaku dedeni kwaḡa nukusi maise, kwaḡa kunuma yagwanisi waḡasi. Na fasinei ka wava Ebenamu eatu a weneweneviviiya o Ebenaamu. ");
INSERT INTO wat_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Iyau ana saviviniya be kunuma nakasina kuna nisaiya be sabu yagwanisi sina kikinomana keta yota kwaḡa sabuuma nenesiyai tufomu sina kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Yaku dedeni ana givifakiniya kwaḡa keta susukwau nukusi nenemiyai be ina fakwafakwavaḡata, tova be tova. Iyau ya Guyau keta yota susukwau yasi Guyau. ");
INSERT INTO wat_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nofe Kenani fwayafwayana nenei ku viviteneyauyauna, matatafuna fwayafwayanama kwaḡa keta yota susukwau ana venimiya. Naki yasi fwayafwayavaḡata keta Iyau yasi Guyau.” ");
INSERT INTO wat_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Guyau Ebenaamu i iyaviya i bwaduwa, “Kwaḡa fasiweu o yaku dedeni kuna muniiya keta yota susukwau sina muniiya. Kwaḡa sina nufifiniya kiyakiyaya neneweu maisemoka yota namoḡa tamokatamokaḡa susukwau sinenei. ");
INSERT INTO wat_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Yami nikana mutugabusi kwana nufifina be noko dedeni kana kiyakiyaya Iyau keta kwami kata kawasasai. ");
INSERT INTO wat_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Nofe tova keta ina niya, fwefweyana namoḡa tamokatamokaḡa kana kuyadayada 8 nenei kwana nufifina. Kwana saviviniya natunatumi keta yami tobunanige natunatusi matatafusi namoaḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Maisemoka yota tovanama namoḡa sina tufuwa yami sabu nenei eketa yota tovanama namoḡa vitamaneina nenei kwana viya, kwana nufifiniya nenesiyai. Ina vikiyakiyayavaḡata yaku dedeni tofwamiyai, tova be tova. ");
INSERT INTO wat_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Atu taki avi namoḡa yaku dedeni kana kiyakiyaya muka tofwanei, nai o kaku dedeni i yasiya, na naki tauna ina nutakiya yana sabu nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Guyau Ebenaamu i iyaviya i bwaduwa, “Kawau Sanai fasinei, muka kuna wenei Sanai eatu kuna weniya Sena. ");
INSERT INTO wat_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ana sawanuwagabubuwiya be tanake nenei natuu namoḡa ana veniwa. Ana sawanuwagabubuwiya ebe kunuma sina visawa-ayona nenei keta susukwana sinenei tufomu sina tufuwa.” ");
INSERT INTO wat_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ebenaamu kaetutuna i viketogunisiya maise yota debabouna keta na viniḡana tauna nuwasinenei i bwaduwa, “Kana fata namoḡa kana manamana 100 tamo natuna ina tufuwa? Atu yota Sena o kana manamana 90 kana fata ina vinatuna?” ");
INSERT INTO wat_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Eketa Ebenaamu Guyau i iyaviya i bwaduwa, “Taki kana nufota Isimeni kuta sawanuwagabubuwiya!” ");
INSERT INTO wat_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Atu Guyau i iyaviya i bwaduwa, “Muka. Kawau Sena natuu ina vinatuniya keta kana wava kuna weniya Aisake. Yaku dedeni ana fufuniya tanake keta susukwana muninei nukusi nenesiyai tova be tova ina nivaḡata. ");
INSERT INTO wat_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ya nuwanuwa Isimeni fasinei o naki a nowaniya. Na fasinei ana sawanuwagabubuwiya be natunatuna keta susukwana yagwanisi ana veniya. Tanake o kawakawa nasi 12 amasi keta yota susukwana nenei kana kunuma ana givinakasiya. ");
INSERT INTO wat_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Atu nofe yaku dedeni ana fufuniya Aisake nukusi. Naki nofe tovanama maise, Sena Aisake ina vinatuniya noko manamananama.” ");
INSERT INTO wat_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yave Ebenaamu nenei i kenokikinomana Mamene yana kai nakanakasisi nenesiyai. Nofe kana sifusifufumokena. Kuyadayada i viaudibutoyoḡa kana tovai, Ebenaamu yana vada kana ketakawanai i nuvitoḡa i fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Matana i kanakasiya nenei namoḡa kasi tonu i kitisiya kutafakaina si misimisiniya. Tovanama i kitisiya, vada i teweiya atu i dibwana i venufotifotisiya keta i koduwa fwayafwayai. ");
INSERT INTO wat_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","I iyavisiya i bwaduwa, “Aiye, taki kwa sanamaniya kaku nufota be ana ovivitimiya nao muka kwana niuniku. ");
INSERT INTO wat_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yami ukowa ana nemiiya be kaemi kwana kigona ebe yo kai sifunei kwana viyawasiya. ");
INSERT INTO wat_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yota kabwaga ana nemiiya be ina givifiwanimiya yo muniyai yami ketai kwana niya. Kwa visawanamonamoikuwa be kwa venufotikuwa, na fasinei ana savivina fasimiyai.” Si iyaviya si bwaduwa, “Dewadewana, avana nuwanuwau ku bwaduwiya maise o ku savivinei.” ");
INSERT INTO wat_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Eketa Ebenaamu i dibwanamoka vadai i kanasuna keta Sena i iyaviya i bwaduwa, “Kuna omatakayakayakaniya be nimau simo ina badobadowa kausibi dewabauna kuna viya ebe maneka kuna kaguwana.” ");
INSERT INTO wat_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Muniyai Ebenaamu i dibwana i niya bunumakau waumisi nenesiyai keta mwanavauna i vinuwadadaniya kakaninama i viya, yana tobunanige i veniya keta i venugidewadewiya. ");
INSERT INTO wat_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ebenaamu kedi keta susu i danina yota viyo muwana nukusi i visiya kabwaginama gigidewadewana i nemiiya keta nausiyai i teniya keta kai sifunei si kawa atu i toḡatanisiya. ");
INSERT INTO wat_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Si nutoninuvenuviya si bwaduwa, “Atu namai kawau Sena?” I nufata i bwaduwa, “Noko vada sinenei.” ");
INSERT INTO wat_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tamokaḡa sinesiyai i bwaduwa, “Venemokena, nofe tovanama maise noko manamananama ana makavinikuwa nenei kawau Sena natuu namoḡa ina vinatuniya.” Atu Sena o vada kana kawa muninei i vanevaneneiya. ");
INSERT INTO wat_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ebenaamu keta Sena o naki si vituvekamoka keta Sena yana tova vinatuna o naki i kakaviya. ");
INSERT INTO wat_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sena tauna i viniḡa keta i bwaduwa, “Iyau naki a vineveka keta i sinavinukuwa keta yota kawaku i vituveka. Kana fata yawane kana diḡadiḡaina ana kamukoniya?” ");
INSERT INTO wat_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yave Ebenaamu i iyaviya i bwaduwa, “Ava uḡuna yo Sena i viniḡa atu i bwaduwa, ‘Naki a vineveka, venemokena gwadimonamona ana vinatuniya?’ ");
INSERT INTO wat_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Omasi tamo aviyavana daunamokena Yave nenei, muka kana nufota be ina savivinei? Naki a bwaduwa maise, nofe tovanama maise noko manamananama tovanama ana makavinikuwa neneweu, kawau Sena natuu namoḡa ina vinatuniya.” ");
INSERT INTO wat_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sena i matuta na uḡuna keta i sawavigema i bwaduwa, “Iyau muka tamo ata viniḡa.” Atu i iyaviya i bwaduwa, “Mukamokena, ku viniḡa.” ");
INSERT INTO wat_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ebenaamu keta namoḡa kasi tonu nukusi si misiniya keta si niniya be ina vateweisiya yasi ketai. Nokomai si kitanusinowa Sodoma nenei. ");
INSERT INTO wat_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Keta Yave tauna nenei i bwaduwa, “Aviyavana kabegomokena ana saviviniya, muka Ebenaamu nenei ana teneviunei. ");
INSERT INTO wat_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Susukwana ina nakata yota fiwafiwanamokena. Keta tanake nenei kunuma matatafuna fwayafwayai ana sawanuwagabubuwisiya. ");
INSERT INTO wat_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","A gibokiya be tanake ina iyavisiya natunatuna keta yota susukwana muninei si nenemiya, ebe yaku ketaketai sina savivina dawaniniina yota kana matanatotowai. Ebe avana Ebenaamu nenei a bwadudabedabiya maise kana fata be ana saviviniya.” ");
INSERT INTO wat_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Keta Yave Ebenaamu i iyaviya i bwaduwa, “Menana Sodoma keta Gomona namoisi yasi fufunagoyo i nakatamoka keta yota fasisiyai odo nakasina a nowaniya. ");
INSERT INTO wat_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nofe naki a sobusobuwa be ana kitiya taki noko odosima tasike fasisiyai venemokena o muka, ebe ana sanamaniya.” ");
INSERT INTO wat_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Namoḡa nasi nuwa si noḡokawawa keta si niya Sodoma kuweyaina, eatu Ebenaamu i fakwa i misimisiniya Yave naunei. ");
INSERT INTO wat_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ebenaamu i vaniya niniunei eketa i iyaviya i bwaduwa, “O venemokena namoḡa goyosi keta eyaeyasi nukusi kuna nuyaunisiya? ");
INSERT INTO wat_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Taki namoḡa eyaeyasi nasi 50 menana noko sinenei o namaise, yawane kuna nuyauniya? Taki eyaeyasi fasisiyai o namaise, menananama kuna kitamokiya? ");
INSERT INTO wat_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Muka kuna fufuniya, nai o muka dawaniniina. Keta muka kana nufota be namoḡa eyaeyasi atu goyosi nukusi kuna nuvimateisi. Taki kuna saviviniya, nao goyosi kasi vimatadawanai eyaeyasi nukusi kuna nunatusiya. Muka. Kwaḡa o fwayafwaya kana matatafu kana tonuvisi, na fasinei kwaḡa kuna vinuwadadanikiya venemokena namoḡa kama matanatotowai, abe namaise.” ");
INSERT INTO wat_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yave i iyaviya i bwaduwa, “Namoḡa matatafusi Sodoma sinenei ana gifafafanisiya taki namoḡa eyaeyasi sinesiyai kasi 50 ana nisaisiya.” ");
INSERT INTO wat_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ebenaamu i bwadu-savaviniya i bwaduwa, “Yaku tuveka, iyau o ibakaokaoḡo maise gavi keta kausibi atu yota a vibutuwa a nunusifufuwa nofe fasinei. ");
INSERT INTO wat_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Taki namoḡa eyaeyasi kasi 50 eatu 5 nenei ina kesa, noko menaninama kuna nuyauniya?” Yave i iyaviya i bwaduwa, “Taki namoḡa eyaeyasi kasi 45 ana nisaisiya, nao muka ana nuyaunei.” ");
INSERT INTO wat_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ebenaamu i vikokone-savaviniya i bwaduwa, “Atu namaise taki kasi 40moka nokomai kuna nisaisiya?” Atu i iyaviya i bwaduwa, “Taki kasi 40, muka ana fufuniya.” ");
INSERT INTO wat_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ebenaamu i iyaviya i bwaduwa, “Ae yaku tuveka, muka kuna nuwagoyoweiku eatu kuta tenikuwa be ata nusifufuwa. Namaise taki nasi 30 nokomai?” Keta i iyaviya i bwaduwa, “Taki 30 ana nisaisiya, muka ana fufuniya.” ");
INSERT INTO wat_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ebenaamu i iyaviya i bwaduwa, “Eiyoi, naki a nusifufumataiya nofe fasinei atu namaise taki 20 kuta nisaisiya?” I iyaviya i bwaduwa, “Taki 20 ana nisaisiya, muka ana nuyaunei.” ");
INSERT INTO wat_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Yota Ebenaamu i bwadu-savaviniya i bwaduwa, “Ae yaku tuveka, muka kuna nuwagoyoweiku. Atu naki kawa tamokaḡamoka yota ata bwaduwa. Atu taki 10 kuta nisaisiya?” I iyaviya i bwaduwa, “Taki 10 ana nisaisiya, muka ana nuyaunei.” ");
INSERT INTO wat_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Tovanama si nusifufukooḡa, Yave Ebenaamu i venuteweiya keta i niya, eatu Ebenaamu i makaviniya yana menanai. ");
INSERT INTO wat_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Guyau kana kaetoḡa abamei kasi nuwa navinavimokeyai si kikinomana Sodoma. Nota menana kana ketakawanai i nuvitoḡa i fakwafakwa. Tovanama i kitisiya, i misiniya i venufotifotisiya eketa nausiyai i koduwa fwayafwayai. ");
INSERT INTO wat_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Keta i iyavisiya i bwaduwa, “Aiye, kwa nemai yaku numai be a oviviteimi. Eatu kaemi kwa kigona be kwa viyawasi, eatu kumana matami kwa kitakiyei yo yami ketai kwana niya.” Atu si iyaviya si bwaduwa, “Muka tamo avana. Naki nofemai kana toḡanumasana.” ");
INSERT INTO wat_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Atu i gwaeḡemokisiya keta nukusi si niya yana numai. Keta ka i fufuniya fasisiyai. Maneka muka na kana nutuva i kaguwana keta si kawa. ");
INSERT INTO wat_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Muniyai yo sina banuwa, Sodoma menana gunina be ovina kana tufunakata be vituvekasi, matatafumokesi nokomai numa si misini-fanakwaniuwiya. ");
INSERT INTO wat_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nota nenei si bwauwa si bwadubwaduwa, “Namoḡa kasi nuwa kimoki nuwabuna si nemiya neneweu, nama o fiyaomokesi? Ku kikinomana-nemiyeisi nenekiyai be ka mataveyeisi.” ");
INSERT INTO wat_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Nota i misini-kikinomana numa kawanei atu kumunina kawa i katuguduya. ");
INSERT INTO wat_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Keta i iyavisiya i bwaduwa, “Ae unaunaku, fufuna naki goyomokena muka kwana savivinei. ");
INSERT INTO wat_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kwa vaneneḡeiku! Natunatuku vivine kasi nuwa weka, muka tamo namoḡa nukusi sita matavenuvanuva. Taki nuwanuwami maise vivinesima ata kikinomana-nemiisiya nenemiyai be aviyavana yami nuwanuwa kwata saviviniya nenesiyai. Eatu namoḡa nofe a nemiisiya kanonovakuwai, muka kwana ginuvanuvaisi.” ");
INSERT INTO wat_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Atu si kawafatiya si bwaduwa, “Ku misininai! Kwaḡa tene wagawaga ku nemiya atu nuwanuwau avage kuna vikainakata. Kimoki kwaḡa kana givikuvavaniwa nakatamokena yo tasike nasi nuwa.” Eketa na yasi fiwana Nota si katutunetuniya numa kana kawa kuweyaina avage nuwanuwasi kawa sina vitutuyakweniya. ");
INSERT INTO wat_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Atu kaetoḡa kasi nuwa numa sinenei nimasi si kitunina, Nota si sinaviya keta si sinakanasuniya eketa kawa si katuguduya. ");
INSERT INTO wat_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Atu yasi fiwana nenei namoḡa matatafusi menanai matasi si weikwava be muka kasi fata kawa sina nisaḡai. ");
INSERT INTO wat_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Eketa namoḡa nasi nuwa Nota si iyaviya si bwaduwa, “Tova kabegomokena menana nofe kana nuyauniya. Yave odo nakatamataina i nowaniya menaninama fasinei keta i visimeikiya ka nemiya be kana nuyauniya. Atu tamo ya sabu nofemai? Maise natunatuu namoḡa keta vivine o nawanawau o taki aitevana tamo yota ya sabu menana nofe sinenei, ku kikinomaneisi.” ");
INSERT INTO wat_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Eketa Nota i kikinomana menanai keta natunatuna vivine kasi sawagivifoteina i matakawisiya. I iyavisiya i bwaduwa, “Yave kabegomokena menana nofe ina nuyauniya. Kwa venudibwana be menana nofe kwa teweyei.” Atu namoḡasima si bwaduwa vitana ita sawasawaviniḡa. ");
INSERT INTO wat_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Naki tova i gegegesiya kana manawasasai, kaetoḡasima Nota si nuyakayakaniya be ina venudibwana. Si iyaviya si bwaduwa, “Ku venudibwana! Kawau be natunatuu vivine nasi nuwa nukusi ku kikinomaneisi. Akata ina kakaviwa tovanama Yave menana nofe ina vimatadawaniya nenei.” ");
INSERT INTO wat_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Atu Nota i giwaewaeḡeya. Yave Nota i sineganiganiiya na fasinei keta kaetoḡa kasi nuwa nimanei si nufatuma yota kawana be natunatuna nimasiyai eketa si kikinomanisiya kawayavatai. ");
INSERT INTO wat_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tovanama si kikinomanisiya menanai, kaetoḡa tamokaḡa i iyavisiya i bwaduwa, “Kwa dibwana be kwana fakwa yawayawasimi! Muka kwana okikine kumunimi yota muka kwana niviyawasinai kawanauwai! Kwa dibwanamoka koya nenesiyai akata ina kakavimiya.” ");
INSERT INTO wat_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tovanama Nota ugunina nukusi menana Sowa nenei si kikinomana, vanavana i kusifuya. ");
INSERT INTO wat_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Yo muniyai iba nununuina muna nenei maise, Yave i visaviviniya keta abamei i sobunemiya Sodoma keta Gomona nenei. ");
INSERT INTO wat_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Eketa naki kana menana be kana namoḡa be yota kisisiku matatafumokena kawanaunama nenei i siwataunisiya. ");
INSERT INTO wat_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Atu Nota kumunina kawana si okikineya keta si vitasiya maise gabana. ");
INSERT INTO wat_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yave Sena i sawanuwagabubuwiya keta avana yana bwadudabadaba maise i fufuniya. ");
INSERT INTO wat_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tutuyanama Guyau i bwaduwiya nenei aviyavana ina kikinomana, naki i nuvifotiya. Sena i visifuḡa keta i vinatuniya natuna namoḡa tovanama Ebenaamu yana vituveka nenei. ");
INSERT INTO wat_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Gwadimonamonanama i tufuwa keta Ebenaamu i weniya kana wava Aisake. ");
INSERT INTO wat_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kuyadayada 8 muninei, Ebenaamu natuna nenei nufifina i saviviniya kiyakiyaya fasinei, namaise Guyau i visimeiya maise. ");
INSERT INTO wat_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ebenaamu kana manamana 100 nenei Aisake i tufuwa. ");
INSERT INTO wat_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Gwadimonamona i nakata keta tovanama i sokeya nenei, Ebenaamu visoke kana ka i fufuniya. ");
INSERT INTO wat_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Noko tovanama nenei Sena si kitiya Isimeni Aisake i sawasawaviniiya. Isimeni o Ebenaamu natuna kana vinuwa, ne Itifita kaetoḡa kasi wava Ega nenesiyai i tufuwa. ");
INSERT INTO wat_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Eketa Ebenaamu si iyaviya si bwaduwa, “Kaetoḡa nofe na natusi ku vikikinomaneisi. Muka simo nuwanuwaki tamo ya kaikaiwabu ina vai tovanama kuna mateya. Naki natukiḡa.” ");
INSERT INTO wat_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ebenaamu i nuwatadauna bwadunama fasinei uḡuna Isimeni o yota natuna. ");
INSERT INTO wat_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Eatu Guyau i iyaviya i bwaduwa, “Muka nuwanuwa ina munuu kaetoḡa na natusi nukusi fasisiyai. Avana Sena si bwaduwiya maise ku fufuniya. Uḡuna Aisake nenei, susukwanama ka wava sina gikikinomaniya. ");
INSERT INTO wat_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Atu kaetoḡa natusi o kwaḡa natuu, na fasinei susukwana yota ana givinakasiya be ina vikunuma.” ");
INSERT INTO wat_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Eketa tova i katakiya nuwabunimokeyai, Ebenaamu tukwava na ukowina keta kabwaga, Ega i vikavanisiya eketa na natusi i teweisiya si niya. ");
INSERT INTO wat_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Muniyai Guyau i anuvanuviya Ebenaamu yana vitumaḡana. I iyaviya i bwaduwa, “Ebenaamu!” Eketa i vinowana i bwaduwa, “O, iyau weka.” ");
INSERT INTO wat_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Keta Guyau i iyaviya i bwaduwa, “Natuu tamokaḡamoka ku nuwagabubuwiya Aisake, ku ovai be ku niyei fafani Moniya nenei. Koyanama namai ana visawaveniwa nenei, kuna vibwanaoseiya ya vikanakooḡa bwanaosena nenekuwai.” ");
INSERT INTO wat_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Na fasinei Ebenaamu nuwabunimoka i misiniya, yana doniki i gidewadewiya keta i kaiuna vibwanaose fasinei. Eyo tobunanige nasi nuwa keta natuna Aisake i ovisiya keta si noḡokawawa kabainama Guyau i bwaduwiya nenei si niya. ");
INSERT INTO wat_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Si niniya atu kuyadayada kana vitonu nenei, Ebenaamu matana i kanakasiya keta kedawanauwai kabaḡanama i kitiya. ");
INSERT INTO wat_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tobunanige i iyavisiya i bwaduwa, “Doniki nukusi nofemai kwana fakwa. Atu natuku nukusi kana niya nokomai, Guyau nenei kana kodukoduwa yo kana makavinikiya nenemiyai.” ");
INSERT INTO wat_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eketa Ebenaamu kai kitavina natuna i vikavaniya eatu tauna o kikanakanata keta giniwakuma i givikavinisiya keta si niya. ");
INSERT INTO wat_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Si niniya atu Aisake amana i iyaviya i bwaduwa, “Amaku!” Ebenaamu i iyaviya i bwaduwa, “Natuku, ku nusifufu.” Eketa Aisake i iyaviya i bwaduwa, “Kikikweu keta kikanakanata o nofe, eatu sifi mwanavauna vikanakooḡa bwanaosena fasinei o namai?” ");
INSERT INTO wat_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebenaamu i iyaviya i bwaduwa, “Natuku, Guyau tauna yawane sifi mwanavauna ina venita vibwanaose fasinei.” Eketa si nikaokaoḡowa si niya. ");
INSERT INTO wat_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tovanama si nemiya kabainama namai Guyau i bwaduwiya nenei, Ebenaamu didiḡa i didiiya keta etanei kai i tewesonasonamiya. Eyo muniyai, natuna Aisake nimana keta kaena i kiyona eketa didiḡai kai etanei i vikenofaniya. ");
INSERT INTO wat_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Yana giniwakuma i sinayaginiya be natuna ina nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Eatu tovanama nenei, abamei Yave kana kaetoḡa i bwauwiya i bwaduwa, “Ebenaamu! Ebenaamu!” Ebenaamu i vinowana i bwaduwa, “O, iyau weka.” ");
INSERT INTO wat_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Eketa Yave kana kaetoḡa i iyaviya i bwaduwa, “Muka natuu kuna givikuvakuvavanei o avana tamo goyona kuna fufuniya nenei! Nofe kimoki o a sanamanemokiwa gewa Guyau ku vifotuwiya uḡuna natukatekateu atu muka kuta nuwanononei nenekuwai.” ");
INSERT INTO wat_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ebenaamu matana i kanakasiya keta sifi namoḡa i kitiya kisisiku sinenei ketuketuna kana vinaḡanaḡana nenei i nukabwakuya. I niya yomuyomunama i viya, i nuvimatiya keta i vikanakoḡoiya yana bwanaose Guyau nenei eatu muka natuna. ");
INSERT INTO wat_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Noko nenei eketa kabainama i weniya Yave Ina Venita. Nofe tovasima nenesiyai namoḡa yasi kafa tanatutuna si bwadubwaduwa, “Yave yana koyai ina venita.” ");
INSERT INTO wat_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Eketa abamei Yave kana kaetoḡa Ebenaamu i bwauwe-savaviniya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Nofemaise Yave i bwaduwa, ‘Fonaku ku nowaniya keta natukatekateu atu muka kuta nuwanononei nenekuwai na uḡuna kaku wavai a bwadudabadaba neneweu, ");
INSERT INTO wat_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","vitana venemokena ana sawanuwagabubuwiwa be susukwau nakatamokena ana veniwa. Sina yagwana vitana kinavinavi abamai yota numagama kwadewai maise. Kasi aviya sina vatanisiya keta yasi menana sina vitoniwagina. ");
INSERT INTO wat_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Susukwau nenesiyai eketa kunuma matatafusi fwayafwaya etanei ana sawanuwagabubuwisiya uḡuna fonaku ku muniiya.’” ");
INSERT INTO wat_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ebenaamu na natuna si makavinisiya yana tobunanige nenesiyai eketa matatafusi si makavinisiya Biyasiba namai Ebenaamu i fakwafakwa nenei. ");
INSERT INTO wat_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ebenaamu natuna Aisake na natunatuna sifusifufusi nofemaise. ");
INSERT INTO wat_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tovanama Aisake kana manamana 40 nenei Nibeka i vikawaniya. Nibeka tawaḡana o Nebani keta amasi o Betuweni tene Anami fafani Fadana-anami nenei. ");
INSERT INTO wat_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nibeka tanake kakanina keta Aisake i kawanunukuwiya Yave kawana kana ovivita fasinei. Yave yana kawanunuku i nowaniya eketa Nibeka i visifuḡa. ");
INSERT INTO wat_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Atu bebeta si vivikafifiwana manawanei keta i bwaduwa, “Namaise yo savivina nofe i kikikinomana nenekuwai?” Eketa i niya Yave i kawanunukuwiya ibanama fasinei. ");
INSERT INTO wat_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Eketa Yave i iyaviya i bwaduwa, “Sineweu o kunuma nuwesi. Sina tufuwa nenei, sina vikavanevaneya. Tamo kunuma o unana ina fiwanateweiya. Kotokikinuna ina vikaetoḡa gwadiyei nenei.” ");
INSERT INTO wat_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tovanama Nibeka i vinatuna nenei, natuyuweyuwe namoḡa si tufuwa. ");
INSERT INTO wat_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kotokikinuna i tufuwa o sininina yabeyabenina atu konokonona. Na fasinei si weniya Isowa. ");
INSERT INTO wat_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Muninei gwadiyei i tufuwa, Isowa kaeketuketunei i gitotowa. Na fasinei si weniya Yakobo. Aisake kana manamana 60 nenei natuyuweyuwe si tufuwa. ");
INSERT INTO wat_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Tovanama namoisima si nakata, Isowa i vitonuiyowa eketa tova matatafuna wanakiyai i nunuiyowa. Eatu Yakobo o umaumana keta toḡakuyadayadana. ");
INSERT INTO wat_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisake o Isowa i nuwagabubuwiya uḡuna nuiyo gevagevana nuwatana i viya, eatu Nibeka o Yakobo si nuwagabubuwiya. ");
INSERT INTO wat_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Tova tamokaḡa Yakobo fenifeni i nunubudana atu wanakiyei Isowa dibuna i toyoḡa yota na vitanonina i kikinomananemiya. ");
INSERT INTO wat_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Eketa Isowa Yakobo i iyaviya i bwaduwa, “Vitanona i kanamunumokikuwa. Nofe tova nubudana yabeyabenina simo ku veneiku a kawa.” (Noko nenei keta kana wava venuwana si weniya Edomu.) ");
INSERT INTO wat_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Keta Yakobo i iyaviya i bwaduwa, “Vikinuna kana vitovisime nofe tova ku vitamanei nenekuwai ebe yo nubudana ana veniwa.” ");
INSERT INTO wat_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isowa i iyaviya i bwaduwa, “Ei, i kanamunumokikuwa! Vikinuna kana vitovisime o avana kana dewadewana!” ");
INSERT INTO wat_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Eketa Yakobo i iyaviya i bwaduwa, “Nauna ku bwadudabadaba nenekuwai yoke.” Eketa Isowa i bwadudabadaba vikinuna kana vitovisime kana dawanatamaneina fasinei. ");
INSERT INTO wat_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Noko muninei Yakobo maneka keta nubudana Isowa i veniya. I kawa, i yuwa eketa i niya. Nofe ketaketanama nenei Isowa muka ita vinuwana vikinuna kana vitovisime fasinei, eatu naki i katuteweiya. ");
INSERT INTO wat_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Noga nakasina manatuwaina Ebenaamu yana tovai maise, yota Kenani i visavavinisiya. Na fasinei Aisake i niya menana Gena nenei, Finisitiya kana tufomu kana wava Abimeneki nenei. ");
INSERT INTO wat_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yave i kenokikinomana Aisake nenei keta i iyaviya i bwaduwa, “Muka kuna nai Itifita eatu namai fwayafwayanama ana iyaviwa nenei, nokomai kuna fakwa. ");
INSERT INTO wat_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nofemai simokaḡamoka kuna fakwa. Iyau kwaḡa nukusi eketa ana sawanuwagabubuwiwa. Fwayafwayanama nofe matatafuna susukwau nukusi ana venimiya ebe avana amau Ebenaamu a bwadudabedabiya maise, bwadudabadabanama ana givifakiniya. ");
INSERT INTO wat_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Susukwau yagwanina ana veniwa maise kinavinavi kasi yagwana abamai. Keta fwayafwayanama nofe matatafuna ana venisiya. Tasike nenesiyai, kunuma matatafusi fwayafwaya etanei ana sawanuwagabubuwisiya. ");
INSERT INTO wat_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Uḡuna Ebenaamu fonaku i muniiya, yaku bwadu i nowaniya yota yaku gisawakedana be yaku visime matatafuna, i muniyekoḡoiya.” ");
INSERT INTO wat_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Na uḡuna eketa Aisake i fakwa menana Gena nenei. ");
INSERT INTO wat_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aisake i bwauwiya Yakobo keta i sawanuwagabubuwiya yo i sawakedakedaniya i bwaduwa, “Muka nofemai tamo ne Kenani kuna vikawaniya. ");
INSERT INTO wat_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Atu nofe tova kuna niya Fadana-anami nenei, ayou amasi Betuweni menaninei. Nokomai tamo kawau kuna viya auḡu Nebani natunatuna sinesiyai. ");
INSERT INTO wat_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Eatu Guyau Tofiwanaonaona ita sawanuwagabubuwiwa be natunatuu sita yagwana be susukwau sita geyana ebe kunumisi sita yagwana. ");
INSERT INTO wat_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tanake ita sawanuwagabubuwiwa keta yota susukwau, maise Ebenaamu i sawanuwagabubuwiya. Ebe fwayafwayanama ku fakwifakwiiya maise teneyauyauna kuta vitoniwagiya. Uḡuna fwayafwayanama o Guyau i veniya Ebenaamu.” ");
INSERT INTO wat_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo Biyasiba i teweiya eatu i niya Anani kuweyaina. ");
INSERT INTO wat_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I niniya atu kabaḡa tamokaḡa i nisaiya eatu naki vanavana i sinakafwanukuwiya fasinei eketa i vikabaḡa. Gabana i viya keta i kenovikifafiiya. ");
INSERT INTO wat_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Tovanama i banubanuwa nenei, i kavayuna. I kitiya abama i kawiya atu ke'ta nutanabaibainina, fwayafwayai i misiniya atu i vaneya abamai. Keta Guyau kana kaetoḡa abamei si sobusobuwa be si vanevaneya. ");
INSERT INTO wat_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Atu Yave i misiniya niniunei eketa i iyaviya i bwaduwa, “Iyau Yave, waḡau Ebenaamu keta Aisake yasi Guyau. Fwayafwayanama nenei ku matamataveya, kwaḡa keta susukwau ana venimiya. ");
INSERT INTO wat_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kimoki yo susukwau maise genasa, sina kataneneḡa yavanata, gagasa, bomatu, keta nanakoya kuweyaisi nenesiyai. Keta susukwau nukusi kami sawanuwagabubu nenei, fasekwa matatafusi fwayafwaya etanei ana sawanuwagabubuwisiya. ");
INSERT INTO wat_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kuna tukutukuya, Iyau o kwaḡa nukusi keta ana nuvinanuwa ya nidadana nenesiyai kana nivaniva ana makaviniwa fwayafwayanama nofe nenei. Muka ana venumakanoveu kana nivaniva aviyavana a bwadudabedabiwa maise ana fufuniya.” ");
INSERT INTO wat_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Yakobo i kenoviniya na yana matuta keta i bwaduwa, “Venemokena gewa Yave o nofemai i fakwafakwa eatu muka ata sanamanei. Kabaḡa nofe a vimaimatumatuta. Nofe o Guyau yana kabaḡa keta abama kana ketakawana.” ");
INSERT INTO wat_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Eketa nuwabunimokeyai Yakobo i misiniya keta gabananama i kenovikifafiiya, i vimisiniiya kiyakiyaya fasinei keta bubu nenei i vitowiya. ");
INSERT INTO wat_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Eketa kabaḡanama i weniya Beteni. Eatu menaninama nakasina si mikiweniya Nusi. ");
INSERT INTO wat_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakobo i bwadudabadaba Guyau nenei i bwaduwa, “Taki kwaḡa iyau nukusi be kuna ofafafikuwa, kabwaga kuna venikuwa, nuya kuna venikuwa, ");
INSERT INTO wat_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ebe taki ana makavinikuwa na yaku dewadewana amaku yana numai, enao kwaḡa Yave yaku Guyau. ");
INSERT INTO wat_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Atu gabana nofe a vimisiniiya, ita vikiyakiyaya Guyau ya numa. Aviyavana matatafuna kuna venevenikuwa, dawana 10 ana tenetenisiya atu sinesiyai tamokaḡa kwaḡa ana veneveniwa.” ");
INSERT INTO wat_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Tovanama Yakobo i fakwafakwa Fadana-anami atu i makaviniya Beteni nenei, Guyau i kenokikinomana-savaviniya keta i sawanuwagabubuwiya. ");
INSERT INTO wat_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","I bwaduwa, “Ka wava Yakobo atu muka yota sina weneu Yakobo. Kimoki keta i niniya ka wava Isineni.” Eketa i weniya Isineni. ");
INSERT INTO wat_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yota i bwaduwa, “Iyau Guyau Tofiwanaonaona. Kuna vinatunasiwasiwaḡa keta kuna yagwana. Susukwau ina nakatamoka. Fasekwa dawanisi yota tufomu sina kikinomana kwaḡa neneweu. ");
INSERT INTO wat_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Fwayafwayanama a bwadudabedabiya Ebenaamu be Aisake nenesiyai, kwaḡa ana veniwa. Yota susukwau nenesiyai nofe fwayafwayanama ana venisiya.” ");
INSERT INTO wat_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Guyau tovanama Yakobo nenei i nusifufukooḡa, i teweiya. ");
INSERT INTO wat_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Kabainama nenei Guyau i nusifufuwiya, gabana i vimisiniiya keta etanei waini i siwaiya yana bwanaose yota muniyai bubu i siwaiya. ");
INSERT INTO wat_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Eketa Guyau nokomai i nusifufuwiya fasinei, kabainama i weniya Beteni. ");
INSERT INTO wat_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Muniyai Yakobo yana sabu nukusi Beteni si teweiya. Keta yawane Efanati kedawanau, Neiseno i vibutusiya atu si nisaiya daunina. ");
INSERT INTO wat_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Si vibaiiya eatu kuvavana i gimunusiya nenei, kasi toosiwaḡa si sawakatevatusiya si bwaduwa, “Muka kwana matuta. Natumi namoḡa kana vinuwa i tufuwa.” ");
INSERT INTO wat_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tovanama ayona yawasisi i kakakaviya nenei, si weniya Benoni eatu amana i weniya Beniyamina. ");
INSERT INTO wat_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Tovanama Neiseno si vidawana, ketanama i niniya Efanati (nofe tova o Beteniyema), kafakainei si odewadewisiya. ");
INSERT INTO wat_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Eketa Yakobo gabana i vimisiniiya kasi manawa etanei. Gabaninama Neiseno kasi manawa nenei nofe tova i fakwafakwa. Yakobo natunatuna namoḡa kasi 12. ");
INSERT INTO wat_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Neya natunatusi namoḡa o Nubeni, Yakobo natuna kotokikinuna. Muninei o Simiyoni, Nebi, Yuda, Isaka, Sebunoni. ");
INSERT INTO wat_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Neiseno natunatusi namoḡa o Yosefa keta Beniyamina. ");
INSERT INTO wat_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Neiseno kasi kaetoḡa Binaa natunatusi namoḡa o Dani keta Nafatanai. ");
INSERT INTO wat_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Neya kasi kaetoḡa Dinufa natunatusi namoḡa o Gada keta Asa. Yakobo kakawana nofemaise natunatuna namoḡa si vinatunisiya Fadana-anami nenei. ");
INSERT INTO wat_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Eketa Yakobo i makaviniya amana Aisake nenei, Kiniyati-aba (nofe tova o Ebinoni) niniunei menana Mamene nenei. Nofe menaninama Ebenaamu i fakwiiya muninei yota Aisake i fakwiiya maise teneyauyauna. ");
INSERT INTO wat_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisake i fakwa kana manamana 180. ");
INSERT INTO wat_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","I sobuwa i vigwadimonamonamoka yo muniyai yawasina i kakaviya keta waḡawaḡana i tuyanomwanisiya. Eketa natunatuna namoḡa Isowa be Yakobo si odewadewiya. ");
INSERT INTO wat_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Kenani fwayafwayana namai Aisake i fakwiiya be nenei i viteneyauyauna yota Yakobo i fakwa. ");
INSERT INTO wat_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Eketa Yakobo na natunatuna sifusifufusi nofemaise. Tovanama Yosefa kana manamana 17, sisitawaḡana nukusi sifi keta gouti si kikitavikavinisiya. Sisitawaḡanasima o amana kakawana Binaa keta Dinufa natunatusi, eatu yasi fufunagoyo fasisiyai Yosefa i simanisiya amana nenei. ");
INSERT INTO wat_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakobo yana vituveka nenei Yosefa i tufuwa eketa i nuwagabubuwiya nakasina yo muniyai natunatuna namoḡa matatafusi. Na fasinei kana kwame nubwayouna dewabauna i veniya. ");
INSERT INTO wat_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tovanama sisitawaḡana si kitiya Yosefa kana nuwagabubu nakatamataina yo muniyai tasike, si adibutoyotoyoiya keta muka viunana kana bwaduwai sita nunusifufuwei. ");
INSERT INTO wat_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nuwabuna tamokaḡa i kavayuna keta tovanama sisitawaḡana kana kavayuna i iyavisiya nenei o naki si dibutoyoḡemokiya. ");
INSERT INTO wat_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosefa i iyavisiya i bwaduwa, “Kwa vaneneḡa tu kaku kavayuna a iyaveimi. ");
INSERT INTO wat_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Bagunai witi ta vivikitava eatu yaku kitava i venukanakasiya keta i misiniya. Tovanama nenei yami kitava si misinififiniya yaku kitava keta nenei si koduwa.” ");
INSERT INTO wat_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Eketa sisitawaḡana si iyaviya si bwaduwa, “Oa! Omasi ku vinuwadadana avage venemokena kuna vitufomuwa be kuna visimeikiya?” Noko nenei, Yosefa yana bwadu be kana kavayuna nenei si adibutoyotoyoḡemokiya. ");
INSERT INTO wat_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tova tamokaḡa Yosefa sisitawaḡana, amasi yana sifi keta yana gouti si visiya keta si niisiya menana Sekemu niniunei, keta nokomai si kitavikavinisiya. ");
INSERT INTO wat_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Eketa Yakobo Yosefa i iyaviya i bwaduwa, “Sisitawaḡau o Sekemu nenei yomuyomu si kitakitavikavina. Nuwanuwaku ana visimeiwa kuna niya nenesiyai.” Yosefa i vinowana i bwaduwa, “Dewadewana, Ana niya.” ");
INSERT INTO wat_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Eketa amana i iyaviya i bwaduwa, “Ku nai be sisitawaḡau ku kitaisi taki yomuyomu nukusi dewadewasi, nao kuna makaviniwa kuna matakawikuwa.” Ebinoni kawanauna nenei Yosefa i visimeiya i niya Sekemu. ");
INSERT INTO wat_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Tovanama i kikinomana, i kakafivinavina kawayavatai atu namoḡa tamokaḡa i nutoniiya i bwaduwa, “Ei, aviyavana ku nunuwasai?” ");
INSERT INTO wat_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosefa i nufata i bwaduwa, “Sisitawaḡaku yasi yomuyomu si kitakitavikavina, a nunuwasisiya. Ku sanamanisiya namai kasi tuḡana?” ");
INSERT INTO wat_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Eketa namoḡanama i iyaviya i bwaduwa, “Si nemiya wekamai atu naki si niya. A nowanisiya si bwaduwa si niniya Dotani.” Noko nenei Yosefa sisitawaḡana i muniisiya keta Dotani i nisaisiya. ");
INSERT INTO wat_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tovanama si kitiya kedawanauwai i nenemiya, kana munuwa fasinei si viwaifufuna. ");
INSERT INTO wat_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tututausi si vikanunusifusifufuwa keta si sawaviniiya si bwaduwa, “Ake, tokavayuna-onaonanama kwa kitai i nenemiya. ");
INSERT INTO wat_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ei, ta nuvimatei be tamo yeyenu kokonina nenei ta tewesobuwei. Kana fata amata tana iyaviya avage tamo yomuyomu-wanawanaki i kaniya, ebe tana kitiya taki kana kavayuna ina vivenemokena o muka.” ");
INSERT INTO wat_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Atu Nubeni i nowaniya yasi bwadu eatu i vinuwadadana Yosefa kana guguya fasinei keta i iyavisiya i bwaduwa, “Muka yawasina tana nuyaunei. ");
INSERT INTO wat_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Muka tana nuviufaufai atu nofemai wanakikaoḡowai tata tewesobuwiya yeyenu kokonina nenei.” Nubeni i tanafafafana taina kana guguya fasinei uḡuna nuwanuwana be ina niiya amana nenei. ");
INSERT INTO wat_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Eketa tovanama Yosefa i kikinomana, sisitawaḡana si givikaviniya keta kana kwame nubwayouna dewabauna tofwanei si kakiya. ");
INSERT INTO wat_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Si oviya keta yeyenu kokoninei si tewesobuwiya. ");
INSERT INTO wat_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tovanama si makavina keta si nuvitoḡa si kakawa atu matasi i kanakasiya keta Isimeni fasekwina si kitisiya si nenemiya na yasi kameni Gineyadiyei, si niniya Itifita. Iba mamadisi nukusi si kivitotoḡa. ");
INSERT INTO wat_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Keta Yuda unaunana i iyavisiya i bwaduwa, “Taki taita tana nuvimatiya keta ufaufana tana tenemakaviuniya, aviyavana tamo kana dewadewana tana nisaḡai? ");
INSERT INTO wat_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Isimeni namoisi nenesiyai ta vitamanei eatu muka tana munuya. Aitevana taina yoke, kita viyo ufaufa tamokaḡa.” Eketa unaunana yana bwadunama si vinowaniya. ");
INSERT INTO wat_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tovanama Midiyani tovitamaneina si kikinomana, Yosefa sisitawaḡana si niya yeyenu nenei si sinakikinomaniya keta Isimeni namoisi nenesiyai, si vitamaniya fatana siniva 20. Eketa Yosefa si niiya Itifita. ");
INSERT INTO wat_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Eyo muniyai tovanama Nubeni i makaviniya, i niya yeyenu nenei i nugenana eatu muka Yosefa ita kitai. Nuwatana i dauna keta kana nuya i kiganiniya. ");
INSERT INTO wat_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","I makaviniya sisitaina nenesiyai keta i iyavisiya i bwaduwa, “Yosefa noko muka. Ava o ata fufuniya?” ");
INSERT INTO wat_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Eketa Yosefa sisitawaḡana, gouti si nuvimatiya keta ufaufanei kwame si kutuviya. ");
INSERT INTO wat_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Eyo si niiya amasi nenei keta si iyaviya si bwaduwa, “Kwame nofe ka nisaiya, ku kitai. Kamo natuu kana kwame o muka?” ");
INSERT INTO wat_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Amasi i kitakinaniya keta i iyavisiya i bwaduwa, “Ika. Natuku kana kwame. Yomuyomu-wanawanaki i kaniya. O natuku! Yomuyomu-wanawanaki i tanabwegabwegiya.” ");
INSERT INTO wat_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Eketa yana nuwatadauna nenei kana nuya i kiganiniya, atu nuya yomuyomu utuutusiyai kikifufunisi i kotoniya keta kuyadayada yagwanina natuna i fokuwiiya. ");
INSERT INTO wat_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Natunatuna matatafusi, namoḡa be vivine, kana sawamwanumwanuva fasinei si niya eatu muka nuwanuwana. Eketa i iyavisiya i bwaduwa, “Ana bwediya kana nivaniva matematesi yasi kabaḡa kana ke'ta ana vaiya natuku nukusi.” Eyo natuna fasinei i viketotoniya be i bwediya. ");
INSERT INTO wat_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tovanama Isimeni fasekwina Yosefa si niiya Itifita, Fotifa i vitamaniya kana kaetoḡa. Fotifa tanake o tuiyo kasi toviketanuneina. Tanake Itifita tufomu yana namoḡa tamo nakasina. ");
INSERT INTO wat_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yave o Yosefa nukusi keta yana ovivita nenei, iba matatafuna i savivinisiya o dewadewana. Kana tovisime tene Itifita yana numai i fakwa. ");
INSERT INTO wat_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Fotifa i kitanisaiya Yave o Yosefa nukusi eketa iba matatafusi i savisavivinisiya o si dibwadibwana-dewadewa. ");
INSERT INTO wat_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Noko nenei nuwatana i oviya keta i viya tauna kana kaetoḡa. Eketa yana numa sinena kana kaetoḡa matatafusi sinesiyai, Yosefa i tene-viketanuniya. Yota yana nogonogo matatafuna kasi kitavikavina fasinei nimanei i teniya. ");
INSERT INTO wat_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Noko tovanama nenei keta i niya Yosefa nenei eketa Fotifa yana numa kana tofakwa kana dewadewana si nisaiya. Yana nogonogo matatafuna numa sinenei keta bagunai, Yave i sawanuwagabubuwisiya eketa dewadewasi. ");
INSERT INTO wat_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Noko nenei eketa Fotifa yana nogonogo matatafuna kana visime fasinei o Yosefa nimanei i teniya. Keta muka tamo aviyavana fasinei ita nuwanuwa eatu yana kaaḡa fasinei o i kitavikaviniya. Yosefa kana tufuwa dewadewana yota kotokiwaḡa. ");
INSERT INTO wat_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Muka ita fakwa nubwayouna eatu Fotifa kawana si kitanuvadiiya keta si sawanuyakaniya be nukusi sita banuwa. ");
INSERT INTO wat_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Eatu i dibutoyoḡa i bwaduwa, “Kaku tovisime muka ita vinuwana aviyavana tamo numa nofe sinenei fasinei uḡuna iyau nenekuwai ketake. Nogonogo matatafuna o iyau sifukuwai. ");
INSERT INTO wat_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Iyau o numa nofe kana tovisime naki maise tanake, eketa muka tamo aviyavana ita sawatanai nenekuwai, eatu kwamiḡa kawana. Na uḡuna namaise ana fufunagoyo yo naki ana go'yona Guyau matanei?” ");
INSERT INTO wat_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tova matatafuna si vivikokoniya atu i didibutoyoḡa keta muka nukusi sita banu yota muka nukusi sita fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tova tamokaḡa Yosefa i kanasuna numai mudadava fasinei eatu tovanama nenei, muka tamo kaetoḡa numai ita fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Eketa Fotifa kawana si niya Yosefa nenei keta kana kwame si gitoniya keta si sawanuyakaniya si bwaduwa, “Ku nemi ku banuweiki!” Eatu Yosefa i dibwana i kikinomana menanai atu kana kwame i venuteweiya gumayogu nimasiyai. ");
INSERT INTO wat_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Tovanama si kitiya Yosefa naki i dibwana atu kana kwameḡa si givikaviniya, ");
INSERT INTO wat_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yasi numa kana kaetoḡa si wenevakukusisiya keta si iyavisiya si bwaduwa, “Nofe kwa kitai! Namoḡa nofe tene Ibeniu kawaki i nemiiya kakaninama, i givisinemumuwita. I kanasunanemiya yama totomuwai keta nuwanuwana ita mataveikiya eatu ka fina. ");
INSERT INTO wat_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tovanama i nowaniya ka fina, i dibwana eatu kana kwame i venuteweiya niniukiyai.” ");
INSERT INTO wat_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Eketa kwame si fakwiiya kana nivaniva kawasi i makaviniya i nemiya numai. ");
INSERT INTO wat_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Yota tamoka sifufunama si iyaviya si bwaduwa, “Kaetoḡa tene Ibeniu ku nemiiya kakaninama, i kanasuna yama totomuwai nuwanuwana ita givisinemumuwikiya. ");
INSERT INTO wat_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Eatu tovanama ka fina nenei, kana kwame i venuteweiya niniukiyai atu i dibwana i kikinomana.” ");
INSERT INTO wat_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tovanama Fotifa kawana i nowanisiya si bwaduwa, “Ya kaetoḡa nofemaise i fufuna nenekiyai,” eketa sinena i nubusubusuwaniya. ");
INSERT INTO wat_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tonuaviya i iyavisiya si tabiya keta deniyai si teniya. Kabainama o tufomu yana finisina fasisiyai. Keta deninama sinenei o Yosefa i fakwa. ");
INSERT INTO wat_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Eatu Yave tanake nukusi keta i nuwagabubuwiya na nenei keta i sawanuwagabubuwiya. Noko nenei keta deni kana tokitavikavina nuwatana i oviya. ");
INSERT INTO wat_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Eketa finisina matatafusi keta mudadava matatafuna deni sinenei, Yosefa nimanei i teniya. ");
INSERT INTO wat_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Deni kana tokitavikavina muka ita nuwanuwa mudadavasima Yosefa nimanei i teniya fasinei. Uḡuna Yave o Yosefa nukusi keta i ovivitiya nenei iba matatafuna i savivinisiya o naki dewadewana. ");
INSERT INTO wat_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Tova tamokaḡa Itifita tufomu kana ukowa kana tokavenena kasi toviketanuneina keta maneka kana tokaguwana kasi toviketanuneina nukusi, si fufunagoyowa tufomu nenei. ");
INSERT INTO wat_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Tobunanigesima nasi nuwa i nuwagoyowisiya, ");
INSERT INTO wat_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","keta deniyai i tenisiya tuiyo kasi toviketanuneina yana numai, namai Yosefa i fakwafakwa nenei. ");
INSERT INTO wat_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Toviketanuneinanama Yosefa i teniya kasi kaetoḡa keta si fakwa simo matanubwayouna. ");
INSERT INTO wat_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nuwabuna tamokaḡa tufomu yana tobunanigesima, ukowa kana tokavenena keta maneka kana tokaguwana, si kavayuna. Nasi nuwa nuwabunanama nenei si kavayuna atu kasi kavayunasima kasi gigivina o tuninatunina. ");
INSERT INTO wat_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tova i katakiya nuwabuniyai tovanama Yosefa i kitisiya tafakaisi si kanawenonowa. ");
INSERT INTO wat_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Eketa i nutoniisiya i bwaduwa, “Kimoki namaise yo nuwanuwa i munumunumi?” ");
INSERT INTO wat_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Si nufata si bwaduwa, “Nuwabuna nama nuwa ka kavayuna eatu muka tamo aitevana kana fata be kama kavayunasima ina kiyau.” Eketa Yosefa i iyavisiya i bwaduwa, “Guyauḡa kana fata kavayuna ina yausiya. Eyo kami kavayuna kwa iyaveiku.” ");
INSERT INTO wat_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Eketa ukowa kana tokavenena i vibutuwa i nusifufuwa i bwaduwa, “A kavayuna a kitiya genefi unavina naukuwai, ");
INSERT INTO wat_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","eketa unavinama i vinaḡanaḡana naḡanina tonusi. Dadana si kikinomana, unavina si visisiya, si nuwatataisiya eketa uwasi si ouwa. ");
INSERT INTO wat_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Eatu tufomu kana owa o a gigivikaviniya, na fasinei uwa a kigonuwa, utosi a bibitotoiya tufomu kana owai keta nimanei a teniya.” ");
INSERT INTO wat_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Eketa Yosefa i iyaviya i bwaduwa, “Ka kavayuna kana givina nofemaise. Naḡani tonusi kana givina kuyadayada tonusi. ");
INSERT INTO wat_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kuyadayada tonusi ina kakavisiya muninei, tufomu debabouḡu ina katunakasiya eketa ina vinuwateweiwa eyo ina giyauwa keta ya mudadava manatuwaina nenei ina tenesavaviniwa. Nokomai tufomu nimanei kana owa kuna vioviya, manatuwaina ku fufufuniya maise tovanama ku vitokavenena ukowa kana tovai. ");
INSERT INTO wat_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tovanama kuta toḡadewadewa nenei, kuta tukukuwa. Ae unaku, kuta ovivitikuwa be tufomu kuta iyaviya fasikuwai ebe deni nofe sinenei kuta vikikinomanikuwa. ");
INSERT INTO wat_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tufomu kuta iyaviya aviyavana nenekuwai i kikinomana fasinei. Ibeniu fwayafwayana nenei namoḡa si givikavinikuwa si dibwanikuwa. Nofemai yota muka tamo aviyavana goyona ata fufuniya atu deniyai si tenikuwa.” ");
INSERT INTO wat_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tovanama maneka kana tokaguwana i nowaniya unana kana kavayuna Yosefa i yauya fasinei, nuwatana i oviya eketa Yosefa i iyaviya i bwaduwa, “Iyau yota a kavayuna, maneka feyawisi tonusi a afisiya. ");
INSERT INTO wat_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Feyawa etanemokenei sinenei o maneka tuninatunina kakaguwanisi tufomu fasinei. Eatu debaboukuwai feyawanama nenei o manuwa si kakawa.” ");
INSERT INTO wat_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Eketa Yosefa i iyaviya i bwaduwa, “Ka kavayuna nofemaise, feyawa tonusi kana givina kuyadayada tonusi. ");
INSERT INTO wat_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kuyadayada tonusi muninei, tufomu debabouḡu ina katunakasiya keta kayou sina nuonosiya eyo tofwau kai nenei sina sinavikukiya. Keta manuwa sina nemiya, kwafiniweu viyou sina kaniya.” ");
INSERT INTO wat_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kuyadayada tonusi i kakavisiya muninei, tufomu yana kafa tufuwa kana kuyadayada i nuvifotiya. Eketa yana kawakawa yasi ka i fufuniya. Ukowa kana tokavenena keta maneka kana tokaguwana i ketoyausiya keta si nemiisiya tufomu nenei kawakawa nausiyai. ");
INSERT INTO wat_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nokomai, ukowa tokavenena i teniya kana kiviyai eketa tufomu nimanei kana owa i viova-savaviniya. ");
INSERT INTO wat_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Eatu tonuaviya i visimeisiya keta maneka kana tokaguwana kayona si nuonosiya keta tofwana kaiyai si sinavikukiya. Naki avana Yosefa i bwaduwiya, maisemoka i kikinomana. ");
INSERT INTO wat_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Eatu ukowa kana tokavenena muka Yosefa ita tukuya, i vinuwataunuwiya. ");
INSERT INTO wat_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Manamana nuwesi i kakavisiya muninei, Itifita tufomu i kavayuna vitana Naeni ukowa kafakainei i misimisiniya. ");
INSERT INTO wat_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tovanama nenei bunumakau kasi 7 na kasi tufutufuwa yota kasi kita dewadewasi ukowei si vanenemiya keta nabenabe kafakainei, nimwau si kakawa. ");
INSERT INTO wat_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Yota bunumakau kasi 7 kasi kita goyosi keta banibaninisi munisiyai si vanenemiya eketa niniusiyai si misiniya. ");
INSERT INTO wat_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kasi kita goyosi keta banibaninisi si misiniya keta kasi 7 na kasi tufutufuwa keta kasi kita dewadewasi, si kanisiya. Nokomai tufomu i kenoviniya. ");
INSERT INTO wat_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tovanama i banu-savaviniya, yota i kavayuna. I kitiya witi uguna tamokaḡa nenei, i foka 7 wanosi nakanakasisi yota dewadewasi. ");
INSERT INTO wat_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Muniyai yota 7 si foka o wanosi kasi kita vitana fonimana inainana ita taoyayanisi eyo sita wenono. ");
INSERT INTO wat_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Wano wenonosi si misinimoka tu wano nakanakasisi keta dewadewasi, si tononisiya. Eketa tufomu i kenoviniya atu i sanamaniya o i kavayuna. ");
INSERT INTO wat_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nuwabuniyai kavayunasima fasisiyai, nuwanuwa yaona i vaniya. Na uḡuna bwadu i vininitiya Itifita kana matatafu nenei yana toibaiba keta yana tonuwatasuyasuya fasisiyai, eketa si nemiya nenei. Kana kavayuna i nusifufuwisiya atu muka tamo aitevana kana fata be ita yausi nenei. ");
INSERT INTO wat_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Atu tufomu kana ukowa kana tokavenena kasi toviketanuneina, tufomu i iyaviya i bwaduwa, “Ae aiye, kimoki yo yaku fufunagoyo a tukuya. ");
INSERT INTO wat_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","12","Manatuwaina tovanama maneka kana tokaguwana kasi toviketanuneina keta iyau, ku nuwagoyowikiya eketa tuiyo kasi toviketanuneina yana numa sinenei, deniyai ku tenikiya. Tovanama nenei tene Ibeniu tufunakasina tamokaḡa waniya nokomai. Tanake o toviketanuneinanama kana kaetoḡa. Nuwabuna tamokaḡa nama nuwa ka kavayuna. Kama kavayunasima ka iyaviya eketa kasi givina i yausiya nenekiyai o tuninatunina. ");
INSERT INTO wat_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Avana i bwaduwiya, naki maisemoka i kikinomana. Iyau ku tene-savavinikuwa yaku kafa mudadava nenei, eatu ya tonuaviya ku visimeisiya keta maneka kana tokaguwana kasi toviketanuneina kayona si nuonosiya eketa tofwana kai etanei si sinavikukiya.” ");
INSERT INTO wat_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Eketa tufomu bwadu i vininitiya Yosefa fasinei eketa muka mwanenena atu deniyai si oviya. Nauna kana mutukonokono i tanakakanuya keta kana nuya i dawanatamatamanina muniyai yo si niiya tufomu nenei. ");
INSERT INTO wat_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Eketa tufomu i bwaduwa, “Nuwabuna a kavayuna, eatu muka tamo aitevana kana fata ita yauya nenekuwai. Atu a nowaniya avage tovanama avi kavayuna kuna nowaniya, ka fata kuna yauya.” ");
INSERT INTO wat_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Atu Yosefa i bwaduwa, “Iyau muka kaku fata, eatu Guyauḡa kana kiyau dewadewana ina veniwa.” ");
INSERT INTO wat_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","32","Keta Yosefa na yana vimogumogu i bwaduwa, “Tufomu yo, ka kavayuna nuwesi kasi nuwanuwa naki tamokaḡa. Aviyavana tova kabegomokena Guyau ina saviviniya fasinei, neneweu i tene-kikinomaniya. Guyau naki i givifakiniya, iba nofe kabegomokena ina saviviniya. Nofe fasinei tamoka kavayunanama atu kawa nuwa i visawaveniwa. Bunumakau kasi 7 na kasi tufutufuwa yota kasi kita dewadewasi, maise yota witi fokasi 7 nakanakasisi keta dewadewasi, kasi nuwanuwa manamana 7 mauna. Itifita kana matatafu ina mauna. Bunumakau 7 banibaninisi yota kasi kita goyosi munisiyai si vanenemiya, yota witi fokasi 7 fisusi vitana fonimana inainana ita taoyayanisi keta sita wenono, kana nuwanuwa o manamana 7 nenesiyai noga. Manamana 7 mauna muninei, manamana 7 yota sinesiyai noga ina kikinomana. Eketa fiyao Itifita yasi mauna kana tova yawane sina vinuwataunuwiya, uḡuna fafani kana matatafu noga ina munuya. Tufomu yo, nofe avana a bwaduwisiya o naki maisemoka Guyau kabegomokena ina saviviniya. ");
INSERT INTO wat_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tufomu yo, tamo namoḡa tosanamana atu na nuwatasuyasuyana kuta gibokiya be tanake Itifita kana matatafu ita visimeiya. ");
INSERT INTO wat_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Menana tamokatamokaḡa nenesiyai kawakawa kuta vinuwadadanisiya. Ebe manamana 7 mauna yana tova nenei, tovanama kabwaga oyuna kasi tutuya nenesiyai, kawakawasima dawana 5 nenesiyai tamokaḡa sita gigivikaviniya. ");
INSERT INTO wat_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Nofe kawakawasima maisa matatafuna sita kwakwiya. Ya visime nenei, menana tamokatamokaḡa nenesiyai maisa matatafuna yasi bonuwai sita totoisiya ebe sita kitavikaviniya namoḡa fasisiyai. ");
INSERT INTO wat_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nofe dawanasima yawane namoḡa ita vibiyawasisiya manamana 7 sinesiyai, tovanama noga ina kikinomana Itifita sinenei. Ebe nofe ketaketanama nenei, namoḡa muka vitanona nenei sita domuna.” ");
INSERT INTO wat_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Tufomu yana namoḡa nakanakasisi nukusi ketaketanama nuwatasi i oviya. ");
INSERT INTO wat_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Eketa tufomu i iyavisiya i bwaduwa, “Venemokena, Guyau kanununa o namoḡa nofe nenei, yota muka tamo namoḡa tonuwatasuyasuya venemokena yo tana nisaḡai maise tanake.” ");
INSERT INTO wat_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Eyo tufomu Yosefa i iyaviya i bwaduwa, “Uḡuna Guyau o ibasima nofe i gikikinomanisiya neneweu, eketa muka tamo aitevana yana sanamana be yana nuwatasuyasuya maise kwaḡa. ");
INSERT INTO wat_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Yaku kafa visime matatafuna kwaḡa nimaweu eketa yaku namonamoḡa matatafusi, ya visimesima sina muniisiya. Eatu wavaḡa kana vifotu fasinei o kwaḡa sifukuwai.” ");
INSERT INTO wat_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Eketa Yosefa nenei i bwaduwa, “Nofe tova kwaḡa a ginakasiwa Itifita kana matatafu kana tovisime.” ");
INSERT INTO wat_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Eketa kana nimabweuna vivigionina, nimanei i yauya keta Yosefa nimanei i sifwatamaniya yota kwame dewabauna i vikotoniya keta kodokodo nukawanamanamaneinana i viya keta kayonei i nuvisanigogwiya. ");
INSERT INTO wat_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Eketa tufomu Itifita wavana Yosefa i veniya, Safeneti-faniya. Yota kawana i veniya kana wava Aseneti, Fotifena natuna. Fotifena o Oni yasi tovibwanaose. Eketa Yosefa naki i vitovisimeya Itifita nenei. ");
INSERT INTO wat_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosefa i vibutuwa bunanige Itifita tufomu fasinei kana manamana 30 nenei. Noko muninei Yosefa i misiniya keta tufomu i venuteweiya eatu Itifita kana matatafu i vadadaniya. ");
INSERT INTO wat_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Manamana 7 mauna yana tova sinesiyai fafani Itifita i maunafaga. ");
INSERT INTO wat_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Noko manamanasima sinesiyai, Yosefa namoḡa i iyavisiya ebe kabwaga si ooyuna atu tufotufo si vakukusiya keta menaninama tamokatamokaḡa kana bonuwai i totoiya. ");
INSERT INTO wat_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Dawana i kisiwaḡa si vimwanauḡuna maise numagama kwadewai, eketa kana ginaḡanaḡa Yosefa i onoviya. ");
INSERT INTO wat_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Manamana 7 sinesiyai Itifita sinenei, mauna kana tova i kakaviya. ");
INSERT INTO wat_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Eatu manamana 7 noga i vibutuwa, naki avana Yosefa i bwaduwiya maisemoka i kikinomana. Fafani matatafuna nenesiyai o noga nakasina i kikinomana, eatu Itifita yana kafa visimeḡa nenei o kabwaga i fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tovanama fiyao Itifita si vitanonamoka, si vikokona-bwedibwediya tufomu nenei kabwaga fasinei. Eatu tufomu i iyavisiya i bwaduwa, “Yosefa nenei kwa nai be avana ita iyavimiya maise, kwa savivinei.” ");
INSERT INTO wat_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Fwayafwaya kana matatafu noga nakasina atu Itifita nenei o nakatamokena. Eketa Yosefa kabwaga kasi bonu i kiyauwa eketa fiyao Itifita nenesiyai i vikimwaneina. ");
INSERT INTO wat_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Atu yota mani fafani nenesiyai noga i nakatamoka. Na fasinei namoḡa si nenemiya Itifita eketa Yosefa nenei kabwaga si vivikimwaneya. ");
INSERT INTO wat_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Eatu tovanama Yakobo i nowaniya vitana Itifita nenei kabwaga, natunatuna nenesiyai i bwaduwa, “Namaise yo kwa nigwanavaḡata. ");
INSERT INTO wat_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kwa vaneneḡa! A nowaniya vitana Itifita nenei kabwaga. Kwa sobu nokomai kwa vikimwane akata tana domuna.” ");
INSERT INTO wat_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Eketa Yosefa sisitawaḡana kasi 10 si sobuwa Itifita kabwagavikimwane fasinei. ");
INSERT INTO wat_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Atu amasi i vinuwana vitana tamo avana goyona ita kikinomana Beniyamina, Yosefa kana tufunuwa nenei. Na fasinei muka ita visimeyei ebe nukusi sita nai nenei. ");
INSERT INTO wat_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Fafani Kenani nenei noga naki i goyomoka, na fasinei Yakobo natunatuna yota namoḡa yagwanisi nukusi si sobuwa Itifita kabwagavikimwane fasinei. ");
INSERT INTO wat_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Noko tovanama nenei fafani matatafuna Itifita sinenei Yosefa i vivisimeiya, eketa namoḡa matatafusi nenesiyai kabwaga i vivikimwaneiya. Eketa tovanama sisitawaḡana si kikinomana, kaevavanei si koduwa fwayafwayai. ");
INSERT INTO wat_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosefa i kitakinanisiya eatu seba i teweiya vitana muka ita sanamaneisi eketa i kayosanakiya nenesiyai i bwaduwa, “Kwami namaniyei kwa nemai?” Eketa si bwaduwa, “Kima Kenaniyei ka nemiya kabwagavikimwane yawagiki.” ");
INSERT INTO wat_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosefa sisitawaḡana i kinanisiya atu tasike o muka sita kitakinanei. ");
INSERT INTO wat_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kana kavayuna i tukunakasiya fasisiyai eketa i bwaduwa, “Kwami tokitanaḡanaḡa kwa nemiya kwana sanamaniya kawasasa kafa kanasuna ebe yo nemaniyei kwana vibutukiya.” ");
INSERT INTO wat_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Atu si nufata si bwaduwa, “Aiye, muka. Kima ka kaetoḡa ka nemiya o kabwagavikimwane yawagiki.” ");
INSERT INTO wat_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Eketa tututausi nenesiyai si vikanusifusifufuwa si bwaduwa, “Noko tovanama nenei taita i bwedisitasita kana ovivita fasinei kana dauna ta kitiya eatu muka tata sineganiganiyei. Na fasinei nofe dauninama ta kakamukoniya o kita kata kuvana.” ");
INSERT INTO wat_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Eketa Nubeni i bwaduviyewa i bwaduwa, “Noko tovanama nenei a iyavimiya, ‘Muka gwadimonamona kwana givikuvavaniya.’ Eatu fonaku kwa teweiya. Nofe tova yana mate fasinei kita mwavinana ta ninisaiya.” ");
INSERT INTO wat_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosefa o Itifita fonasiyai i nunusifufuwisiya keta togivina i gigiviniya nenesiyai. Na nenei si bwaduwa vitana muka yasi sifufu ita nowanowaniya. ");
INSERT INTO wat_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yosefa Ibeniu fonasiyai sisitawaḡana i iyavisiya i bwaduwa, “Simokaḡa kwa nemai niniukuwai.” Eketa si nemiya niniunei, eyo i bwaduwa, “Iyau taimi Yosefa. Gwadikuma kwa vikimwaneikuwa Itifita nenesiyai. ");
INSERT INTO wat_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Noko fasinei muka nuwatami ina dauna be tututaumi kwana vikanuwanuwagoyo, kwa vikimwaneikuwa be a nemiya nofemai fasinei. Atu tanake Guyau i mikiteweikuwa a nemiya namoḡa kasi gifafafana fasinei. ");
INSERT INTO wat_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Noga i nemiita manamana nuwesi. Eatu yota manamana 5 si nenemiya nenesiyai, muka tamo aitevana kana fata ina baguna o ina nukabwaga. ");
INSERT INTO wat_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Guyau i mikiteweikuwa kunaumi ebe yawasimi ata gifafafanisiya ketaketa dewabauna nenei, ebe susukwa kiyakiyayana muka ina domuna fwayafwaya nofe nenei. ");
INSERT INTO wat_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Nofe fasinei kwami muka kwata teweyeiku be ata nemi nofemai, eatu tanake Guyau i teweikuwa. Eketa i tenikuwa togivisawakedana tufomu fasinei, yota yana namonamoḡa yasi tuveka keta yota Itifita kana tovisime. ");
INSERT INTO wat_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Nofe tova kwana dibwana amaku nenei eketa kwana iyaviya, ‘Natuu Yosefa maise i bwaduwa, “Guyau i tenikuwa Itifita kana tovisime nakasina. Eketa muka kuna nuyawayawanei nenekuwai. ");
INSERT INTO wat_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Na uguniu kwata vikukuwayauna, be yami yomuyomu be waḡawaḡau nukusi kwata nemiya fwayafwaya Goseni nenei, niniukuwai kwata vimenana. ");
INSERT INTO wat_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ebe yo manamana 5 nenesiyai yawane noga ina niniya, ana kitikitimiya. Akata ka sabu nukusi vitanona nenei kwana fakwa.”’” ");
INSERT INTO wat_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yosefa sisitawaḡana Itifita si teweiya atu si makavinisiya Kenani amasi Yakobo nenei. ");
INSERT INTO wat_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Eketa amasi si iyaviya si bwaduwa, “Yosefa noko i fakwafakwa, muka ita mate atu tanake Itifita kana tovisime.” Eatu Yakobo si visabanutuiya eketa muka ita vitumaḡaneisi. ");
INSERT INTO wat_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Atu matatafuna avana Yosefa i bwaduwiya maise si iyaviya. Keta yota Yosefa waganusoni i teweisiya kana kivitotoḡa fasinei, tovanama i kitisiya nuwatana i kanabunabuya. ");
INSERT INTO wat_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Eketa i bwaduwa, “O bwadu venemokena. Natuku Yosefa gewa i fakwafakwa. Kwa niyeiku be natuku tafakaina a kitai, fonana a nowaniya, yo muniyai kwana teneviunikuwa.” ");
INSERT INTO wat_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Eketa Yakobo, yota kana wava kana vinuwa Isineni, ugunina nukusi si vikukuwayauna Itifita fasinei. Eketa tovanama si nemiya Biyasiba, yomuyomu i vibwanaoseisiya amana Aisake yana Guyau nenei. ");
INSERT INTO wat_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na nuwabunanama nenei Guyau kenokitai i iyaviya i bwaduwa, “Yakobo! Yakobo!” Eketa i vinowaniya, “Iyau weka.” ");
INSERT INTO wat_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Eketa Guyau i bwaduwa, “Iyau Guyau, amau yana Guyau. Muka kuna matuta ku niniya Itifita fasinei, uḡuna noko menaninama nenei susukwau ana givinakasiya. ");
INSERT INTO wat_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Iyau nukusi tana sobuwa Itifita eatu yawane yota susukwau nukusi ana makavinimiya nofemai. Eatu kwaḡa o natuu Yosefa nimanei kuna vidawana.” ");
INSERT INTO wat_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Eketa waganusonisima tufomu i vininitisiya nenesiyai Yakobo natunatuna si totoiya yota kakawasi keta natunatusi, eketa menana Biyasiba si teweiya. ");
INSERT INTO wat_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Yota yasi yomuyomu be kukuwa matatafuna Kenani nenei kasi fwasimowai i kikinomana, nukusi si niisiya Itifita. Yakobo i misiniya natunatuna namoḡa be vivine keta yota waḡawaḡana nukusi. ");
INSERT INTO wat_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo Yuda i visimeiya i venuviketanuna Yosefa ina matakawiya vitana fafani Goseni nenei sina vikaninisaḡa. Tovanama si kikinomana nokomai, ");
INSERT INTO wat_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosefa yana aviya kana waganusoni si gidewadewiya keta i niya Goseni, amana i venufotefotiya. Tovanama amana i kitiya, i nusiya keta i bwediiya matanubwayouna. ");
INSERT INTO wat_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Keta Yakobo Yosefa i iyaviya i bwaduwa, “Kimoki gewa naki tauku matakuwai tafakaiu a kitiya na yawasiu, eyo muniyai kana nufota ina kakavikuwa.” ");
INSERT INTO wat_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tamoka tova Yosefa i biganowana amana i visafwavinaḡa. Eketa natunatuna kasi nuwa Manasa keta Ifeneimu i ovisiya keta si niya Yakobo kana kita fasinei. ");
INSERT INTO wat_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tovanama Yosefa i kikinomana, Yakobo si iyaviya si bwaduwa, “Natuu Yosefa i nemiya.” Eketa Yakobo matamataveyai atu naki i fiwanemokiya keta i nuvitoiya kana kiviyai. ");
INSERT INTO wat_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Keta Yakobo Yosefa i iyaviya i bwaduwa, “Fafani Kenani menana Nusi nenei Guyau Tofiwanaonaona i kenokikinomana nenekuwai keta nokomai i sawanuwagabubuwikuwa. ");
INSERT INTO wat_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","I bwaduwa, ‘Kimoki ka sabu ana givinakasiya. Susukwau ana givigeyaniya ebe kunuma yagwanina ina kikinomana. Yota fwayafwaya nofe ana venisiya susukwau yasi fwayafwayavaḡata.’” ");
INSERT INTO wat_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakobo yana bwadu i nusaviya i bwaduwa, “Eketa natunatuu kasi nuwa Ifeneimu keta Manasa Itifita si tufuwa yo muniyai a nemiya o iyau natunatuku, naki maisemoka Nubeni keta Simiyoni. ");
INSERT INTO wat_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Eatu muniyai natunatuu sina tufuwa, enao kwaḡa natunatuu. Eatu yasi fwayafwaya kana vitoniwaga fasinei o sisitawaḡasi Ifeneimu keta Manasa kasi wavai.” ");
INSERT INTO wat_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Eketa Yosefa natunatuna kasi nuwa i niisiya Yakobo niniunei. Ifeneimu i teniya Yakobo kukikimawana, atu Manasa o kukikikataina. ");
INSERT INTO wat_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Eatu Yakobo nimana i tewewenuya keta kikikataina gwadiyei Ifeneimu debabounei i teniya atu kikimawana o i teniya kotokikinuna Manasa nenei. ");
INSERT INTO wat_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Eketa Yosefa i sawanuwagabubuwiya i bwaduwa, “Guyaunama amaku Aisake keta waḡaku Ebenaamu nenei si kodukoduwa, tufunakata nofe ita sawanuwagabubuwisiya. Guyaunama yawasiku kana matatafu nenei i kitavikavinikuwa maise yomuyomu kasi tokitavikavina, ita sawanuwagabubuwisiya. ");
INSERT INTO wat_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Yota Guyau kana kaetoḡanama abamei i ofafafikuwa dauna matatafuna nenesiyai, ita sawanuwagabubuwisiya. A kawakawanunukuwiya be nofe tufunakatasima nenesiyai, namoḡa kaku wava, amaku Aisake keta yota waḡaku Ebenaamu kasi wava, sita tukutukusiya. Keta yota a kawakawanunukuwiya be kasi sabu ita nakata fwayafwaya nofe nenei.” ");
INSERT INTO wat_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Eatu tovanama Yosefa i kitiya amana kikikataina i teniya Ifeneimu debabounei muka ita sebobo. Na fasinei amana nimanei i ova be ita tenetamaniya Manasa debabounei. ");
INSERT INTO wat_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Eketa i bwaduwa, “Amaku, na muka nemaise. Manasa o kotokikinuna. Na fasinei kikikataiu debabounei ku tenei.” ");
INSERT INTO wat_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Eatu amana i vikununewanewa i bwaduwa, “Natuku, a sanamaniya avana a savisaviviniya. Kimoki Manasa kana wava ina nakata. Susukwanei yawane kunuma nakasina ina kikinomana. Atu taina o yawane nakatamataina yo tawaḡana. Eketa susukwanei yawane kunuma yagwanisi sina kikinomana.” ");
INSERT INTO wat_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Eketa na kuyadayadanama nenei i sawanuwagabubuwisiya i bwaduwa, “Avi tova fiyao Isineni yasi sawanuwagabubu kana tovai, kami wava sina kinana sina bwaduwa, ‘Guyau ka kawakawanunukuwiya be ita sawanuwagabubuwiwa vitana Ifeneimu keta Manasa i sawanuwagabubuwisiya maise.’” Noko nenei Ifeneimu kana wava i teneviketanuniya eatu Manasa i vimunifota. ");
INSERT INTO wat_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Eketa Yakobo Yosefa i iyaviya i bwaduwa, “Ku nowaniya, iyau o kabegomokena be ina kakavikuwa, eatu Guyau o kwami nukusi. Eketa yawane ina makavinimiya waḡawaḡami fwayafwayasiyai.” ");
INSERT INTO wat_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, unaunau sina daviwa keta sina koduwa neneweu. Ka aviya kuna gikayusiya keta kuna vatanisiya. ");
INSERT INTO wat_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","O Yuda, kwaḡa maise naiyoni mwanavauna, kimoki mani yomuyomu kuna fiwanateweisiya keta kuna visimeisiya. Naki naiyoni maise, tovanama ina gevagevamunuwa muninei yo ina makaviniya ina ketosebaḡa, atu aitevana simo fatafatana yo ina vikasanegwanegwai? Naki mukamokena! ");
INSERT INTO wat_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tufomu yana visime kana kiwana Yuda nimanei ina fakwa keta susukwana o tova kana matatafu sina vivitovisimeya kana nivaniva tonikiwana ina nemiya. Nokomai kunuma matatafusi sina vimogumoguwiya.” ");
INSERT INTO wat_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tovanama Yakobo natunatuna nenesiyai i nusifufukooḡa, i sioviniya keta i kenofana. Tovanama nenei yawasina i tununoviya keta i vidawana. ");
INSERT INTO wat_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yosefa sisitawaḡana si sanamaniya amasi yawasina i kakaviya eketa tututausi si vikanusifusifufuwa si bwaduwa, “Namai tu Yosefa yata fufunagoyo manatuwaina ina tukunakasiya yo ina kwabuyuna.” ");
INSERT INTO wat_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Eketa sifufu si vininitiya Yosefa nenei si bwaduwa, “Muniyai yo amata yawasina ina kakaviya, i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Yosefa nofemaise kwana iyaviya. “Sisitawaḡau yasi fufunagoyo neneweu, nuwanuwaku kuna vinuwateweiya.”’ Kima o amau yana Guyau kana kaetoḡa na fasinei ka vikokona-sineganiganiya neneweu ebe yama go'yona kuta vinuwateweisiya.” Tovanama Yosefa bwadu nofe i nowaniya, i bwedisitasita. ");
INSERT INTO wat_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Eketa sisitawaḡana si nemiya naunei si fekuwa keta si bwaduwa, “Kima ka kaetoḡa.” ");
INSERT INTO wat_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Eatu i iyavisiya i bwaduwa, “Muka kwana matuta, iyau muka Guyau. ");
INSERT INTO wat_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Manatuwaina kwata givikuvavanikuwa eatu Guyau i gikikinomaniya kana dewadewana ebe namoḡa yagwanisi muka sina domuna, maise kimoki ta kitakitiya. ");
INSERT INTO wat_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Na fasinei muka kwana matuta, na natunatumi ana kitavikavinimiya.” Nofemaise fonana biganei i sawavininiusiya. ");
INSERT INTO wat_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Tovanama Yakobo i niniya Itifita, natunatuna ugunisi nukusi si niya. Natunatuna namoḡa o nofemaise kasi wava. ");
INSERT INTO wat_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Nubeni, Simiyoni, Nebi, Yuda, ");
INSERT INTO wat_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Sebunoni, Beniyamina, ");
INSERT INTO wat_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Nafatanai, Gada, keta Asa. ");
INSERT INTO wat_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yosefa o waniya Itifita. Yakobo susukwana kasi numatatafu kasi naḡa 70. ");
INSERT INTO wat_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Muninei Yosefa keta unaunana matatafusi tufudenideni yota aviyaonana noko tufuwinama kana sewasewa si matekooḡa. ");
INSERT INTO wat_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Eatu fiyao Isineni susukwasi si vinatunaneuneuwa eketa sabu i nakatamoka. Eketa Itifita fwayafwaya si toḡafotafotiya. ");
INSERT INTO wat_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Manamana yagwanina muninei, tufomu kiouna i vitovisimeya Itifita sinenei eatu muka tamo yana sanamana avana Yosefa i saviviniya Itifita fasinei. ");
INSERT INTO wat_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Yana sabu nenesiyai i bwaduwa, “Kwa kitai, fiyao Isineni nofe tova naki si tufuteweita. ");
INSERT INTO wat_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Taki kata aviya sina vivibututa nenei, Isineni nifanifaita sina tuyanomwanisiya keta sina nuaviita atu nofe fwayafwayanama nenei sina dibwana sina niya. Na fasinei ketaketa tamo ta vinuwadadana-dewadewai ebe muka kasi sabu ina nakatamoka.” ");
INSERT INTO wat_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nofe fasinei fiyao Isineni si tenisiya mudadava daunisi nenesiyai. Yota mudadava tamokatamokaḡa kana tovisimeonaona si tenisiya be sina visimeisiya. Eketa namoisima fiyao Isineni si nuyakayakanisiya be menana nuwesi nakanakasisi Fitomi keta Namesese si vikanasiya ebe nokomai tufomu kabwaga be nogonogo ina tenisiya. ");
INSERT INTO wat_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Naki namaise dauna kasi nakanakata si venivenisiya, atu fiyao Isineni si teniya be si vinatunaneuneuwa keta si geyanamoka Itifita si gikafufuya. Nofe nenei keta Itifita namoisi fiyao Isineni si matutisiya. ");
INSERT INTO wat_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Na uḡuna keta mudadava daunamokesi nenesiyai si yoyoḡavinavina. Si nuyakayakanisiya be mota si kikivina keta taga si kikiyafofowa. Yota baguna keta mudadava matatafuna nenesiyai si visavivinisiya. Si givikuvavanisiya nakasina atu muka simo yasi sineganigani. ");
INSERT INTO wat_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Eketa Itifita tufomu yana namonamoḡa i visimeisiya i bwaduwa, “Tovanama tene Ibeniu natuna namoḡa ina tufuwa, Naeni ukowai kwana tewesobuwiya. Atu taki gumayogu ina tufuwa, nao ina fakwa.” ");
INSERT INTO wat_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Tovanama noko savivinanama i niniya, Nebi fasekwina sinenei namoḡa tamokaḡa i vikawana-toniwaga. ");
INSERT INTO wat_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Gumayogu i visifuḡa keta gwadimonamona namoḡa i vinatuniya. Ayona si kitiya gwadimonamona kotokiwaḡa, na fasinei si teneviuniya yamayamana tonusi. ");
INSERT INTO wat_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Atu tovanama muka kasi fata be yota sina teneteneviunei matanubwayouna, kautu kikiyonana waguwagudabu nenei si yoniya kautunama si viya keta kibasi nenei si maifotafotiya be muka ukowa ina kanasuna. Eyo gwadimonamona si totoiya sinenei eketa ukowa Naeni kafakainei kawaununa sinesiyai si teniya. ");
INSERT INTO wat_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Gwadimonamona tawaḡana gumayogu i misiniya matakedawanauna eatu i vivinanuya ebe ina kitiya avana ina kikinomana nenei. ");
INSERT INTO wat_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Noko tovanama nenei, Itifita tufomu natuna gumayogu i sobuwa ukowai towa yawagina, eketa yana fiyavivine o ukowa kafakainei si fanafana. Eatu tufomu natuna gumayogu kautu i kitiya kawaununa sinenei keta yana gumayogu tamokaḡa i iyaviya eketa kautu ukowai i sinaviduduniya keta i viya. ");
INSERT INTO wat_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Tovanama kautu i vitanadadiya, i kitiya gwadimonamona i bwedibwediya. Na fasinei i kitasineganiganiiya keta i bwaduwa, “Auu, nofe tanake o Ibeniu gwadimonamona.” ");
INSERT INTO wat_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Gwadimonamona tawaḡana i niya keta tufomu natuna i vikokoniya i bwaduwa, “Kana fata tamo ne Ibeniu ata iyaviya be gwadimonamona ita visusuya fasiweu?” ");
INSERT INTO wat_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Eketa yana bwadu i vinowaniya i bwaduwa, “Ika, ku nai.” Gumayogu i niya eketa gwadimonamona tauna ayomokena i ovisiya. ");
INSERT INTO wat_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Eketa tufomu natuna i iyavisiya i bwaduwa, “Gwadimonamona nofe kwa vai be kwa visusuya fasikuwai, eatu ana fatimiya.” Eketa gumayogu natusi si niiya numai keta si visusuya. ");
INSERT INTO wat_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tovanama gwadimonamona naki i nakata, si niiya tufomu natuna gumayogu nenei eketa i fayaiya. Gumayogu i bwaduwa, “Ukowai a sinanakasiya fasinei, ana weniya Mosese.” ");
INSERT INTO wat_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Manamana yagwanina muninei, Mosese naki i vikatevatuwa. Tova tamokaḡa i kikinomana yana sabu kasi venufota fasinei eatu i kitisiya Itifita namoisi yana sabu si nunuyakayakanisiya keta mudadava daudaunisi nenesiyai si viyoyoḡavinavina. Tovanama nenei i kitiya tene Itifita i munumunuya yana sabu tamokaḡa tene Ibeniu. ");
INSERT INTO wat_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mosese i kitavinavina atu muka tamo aitevana ita tonetoneyei, eketa tene Itifita i nuvimatiya keta tofwana numagamai i venusanitautauniya. ");
INSERT INTO wat_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Tova i katakiya tovanama Mosese i makavina-savaviniya, fiyao Ibeniu nasi nuwa i kitisiya si vivikamunumunuwa. Eketa tosinatamaneina i nutoninuvenuviya i bwaduwa, “Ava uḡuna yo unau ku munumunuya?” ");
INSERT INTO wat_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Atu i kawafatiya i bwaduwa, “Aitevana masi kwaḡa i teneu kama tovisime keta kama tonuvisi? Omasi kuna nuvimatikuwa maise foma tene Itifita ku nuvimatiya?” Mosese i matuta keta nuwasinenei i bwaduwa, “Namoḡa naki si sanamaniya aviyavana a saviviniya.” ");
INSERT INTO wat_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Tovanama tufomu biganama noko i nowaniya, ketaketa i nuwasa be Mosese ina nuvimatiya. Eatu Mosese i dibwana keta i niya Midiyani kana fafaniyai i fakwa. ");
INSERT INTO wat_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Yeteno tanake Midiyani yasi guyau kana tovibwanaose. Nawana Mosese o yana sifi keta gouti kasi tokitavikavina. Tova tamokaḡa yomuyomusima i niisiya kedawanauwai wanakikaoḡowai yavanata kuweyaina keta i kikinomana Sainai, Guyau yana koya nenei. ");
INSERT INTO wat_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nokomai Yave kana kaetoḡa abamei kana kitakita vitana kai noyakaina maise, i kenokikinomana kisisiku sifununa sinefounei. Mosese i kitiya kisisiku sifununa i nununuḡa atu muka ita kanakanakoḡoiya. ");
INSERT INTO wat_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mosese nuwasinenei i bwaduwa, “Aa, namaise yo kisisiku sifununa muka ita kanakanakoḡoiya? Yabe simokaḡamoka a vanai niniunei be a kitai ava venemokena i kikikinomana.” ");
INSERT INTO wat_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Tovanama Yave i kitiya Mosese i nenemiya niniunei be ina toneiya fasinei, kisisiku sifununa sinefounei i bwaduwa, “Mosese! Mosese!” Eketa Mosese i vinowana, “Ika, iyau weka.” ");
INSERT INTO wat_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Eketa Yave i iyaviya i bwaduwa, “Muka yota kuna vanemai. Na fwayafwayanama nenei ku misimisiniya o tafutafuna, na fasinei ka kaevatakutakuna ku kaki. ");
INSERT INTO wat_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Iyau amau yana Guyau, Ebenaamu yana Guyau, Aisake yana Guyau eketa Iyakobo yana Guyau.” Tovanama Mosese nofemaise i nowaniya, i matuta Guyau kana toneyeina fasinei eketa tafakaina i tenefotiya. ");
INSERT INTO wat_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Atu Yave i iyaviya i bwaduwa, “Namaise Itifita namoisi yasi givikuvakuvavaneina yaku namonamoḡa nenesiyai, naki a kitiya yota yasi bwedi a nowaniya. Nuwanuwasi ana gifafafanisiya aviyaonana kasi tovisimeonaona nenesiyai. Naki a sanamaniya yasi kuvavana. ");
INSERT INTO wat_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Na fasinei naki a sobunemiya keta ana ketoyausiya Itifita namoisi nimasiyai ebe ana kikinomanisiya, ana niisiya tamo fafani dewadewana yota nakasina keta maumaunina nenei. Eatu fwayafwayanama o fasekwasima maise fiyao Kenani, fiyao Itai, fiyao Amonai, fiyao Fenisi, fiyao Ivi keta fiyao Yebusi nokomai nofe tova si fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Bwadu venemokena, yaku namonamoḡa yasi bwedi a nowaniya yota naki a kitiya Itifita namoisi namaise si vivitoagoyogoyowisiya. ");
INSERT INTO wat_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Na uḡuna nofe tova a vivisimeiwa kuna niya Itifita tufomu nenei, ebe yaku namonamoḡa fiyao Isineni Itifitei kuna kikinomana-nemiisiya.” ");
INSERT INTO wat_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Eatu Mosese Guyau nenei i sawaviyagwana i bwaduwa, “Iyau o naki namoḡakaokaoḡo. Eketa fiyao Isineni kasi kikinomaneina fasinei, namaise o ana vaisi tufomu nenei?” ");
INSERT INTO wat_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Eatu Guyau i iyaviya i bwaduwa, “Ana vinuwiwa eketa tovanama fiyao Isineni Itifitei kuna kikinomana-nemiisiya nenei, nofe koyanama nenei nenekuwai kwana kodukoduwa. Ebe nofe nenei ina vikiyakiyaya vitana Iyau tauku a visimeiwa.” ");
INSERT INTO wat_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Atu Mosese i iyaviya i bwaduwa, “Taki ana niya fiyao Isineni nenesiyai keta ana iyavisiya ana bwaduwa, ‘Waḡawaḡata yasi Guyau i visimeikuwa a nemiya nenemiyai,’ atu sina bwaduwa, ‘Namaise kana wava?’ Nao namaise o ana iyaveisi?” ");
INSERT INTO wat_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Eketa Guyau Mosese i iyaviya i bwaduwa, “Iyau Mimituwa. Na fasinei fiyao Isineni kuna iyavisiya kuna bwaduwa, ‘Tanake kana wava Mimituwa i visimeikuwa a nemiya nenemiyai.’ ");
INSERT INTO wat_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Fiyao Isineni nenesiyai kuna bwaduwa, ‘Yave, waḡawaḡami yasi Guyau, Ebenaamu yana Guyau, Aisake yana Guyau eketa Yakobo yana Guyau i visimeikuwa a nemiya nenemiyai.’ Nofe kaku wava fakwafakwa-vaḡasina, muniyai tufuwa si nenemiya yasi inuwe sina tukutukuya.” ");
INSERT INTO wat_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yave Mosese i iyaviya i bwaduwa, “Itifita tufomu yana namonamoḡa nukusi, yota tamokaḡamoka ana vimatadawanisiya. Muniyai yo tufomu ina sawateweimiya kwana niya. Atu yami nainama nenei matatafumi ina nukwavikwavinamokimiya. ");
INSERT INTO wat_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Nofe tova kuna niya keta fiyao Isineni matatafusi kuna iyavisiya kuna bwaduwa, ‘Kwana niya Itifita namoisi aviyaonana niniumiyai nukusi kwa fakwafakwa, kwana vikokonisiya nogonogo si fufunisiya siniva keta gonudi nenesiyai fasisiyai.’” ");
INSERT INTO wat_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yave Itifita namoisi i oviyeviisiya, na nenei keta fiyao Isineni si vifotuwisiya venemokena. Mosese kana wava i nakatamoka tufomu yana tovisime keta Itifita namoisi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mosese i niya tufomu i iyaviya i bwaduwa, “Yave nofemaise i bwaduwa, ‘Nuwabuna sinefouna, Itifita ana nifanakwanikwaniuwiya, ");
INSERT INTO wat_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","eketa kayeu namoḡa matatafusi Itifita sinenei sina mateya. Tufomu natuna kayeuna vitana yana gabu ita viya, nenei atu i sobuwa kana nivaniva nekaetoḡa witi kana tokifuwaḡa natusi kayeusi nenesiyai. Yomuyomu-menana matatafusi mikitufuwisi yota sina mateya. ");
INSERT INTO wat_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Itifita kana matatafu namoḡa sina bwedi-bwaubwauwa. Bwedibwedinama muka tamo manatuwaina ita kikinomana maise keta yota muniyai muka ina kikinomana. ");
INSERT INTO wat_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Eatu Isineni nenesiyai muka tamo aviyavana goyona ina kikinomana, maise muka tamo anuketa ina tanabwau-nuvanuva tene Isineni nenei o yasi yomuyomu nenesiyai. Ebe kwami Itifita namoimi kwana sanamaniya vitana Iyau Yave fiyao Isineni nenemiyai a tenesinisiya.’ ");
INSERT INTO wat_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ya tovisime matatafusi sina nemiya naukuwai sina koduwa keta sina kamanemanikuwa be yaku namonamoḡa ana visiya keta ana niisiya. Eyo noko nenei naki ana niya.” Mosese sinena i nubusubusuwaniya eketa tufomu i sinanoviya. ");
INSERT INTO wat_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Eketa Yave Mosese i mikiiyaviya i bwaduwa, “Yawane tufomu muka fonau ina nowaniya ebe kafa nuwatabau yota tunisi ana savivinisiya Itifita sinenei.” ");
INSERT INTO wat_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosese keta Anoni kafa nuwatabau nofe matatafusi si savivinisiya tufomu matanei eatu Yave tufomu i oviyeviiya keta katekatena i gua. Na fasinei fiyao Isineni muka ita sawateweyeisi be Itifitei sina kikinomana. ");
INSERT INTO wat_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yave Mosese keta Anoni Itifita nenei i nusifufuwisiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Yamayamana nofe kwana teneviketanuniya ebe tanake manamana yana kafa viuḡu. ");
INSERT INTO wat_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isineni matatafusi kwana iyavisiya kwana bwaduwa, ‘Kuyadayada kana vi10 nofe yamayamananama nenei, namoḡa tamokatamokaḡa yana sifi o gouti mwanavauna ina gibokiya tauna kana sabu nukusi fasisiyai. ");
INSERT INTO wat_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Taki numa tamo kana sabu kabegona be gevageva muka kasi fata sina kakoḡoiya, nao unafafanisi nukusi sina kaniya. Namoḡa kana tuku gevageva kana ketowavai sina teniya be ina kaniya. ");
INSERT INTO wat_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Sifi o gouti namoḡa mwanavauna kana manamana tamokaḡa yota kana sinibu dewadewana kwana gibokiya. ");
INSERT INTO wat_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Eketa kwana kitavikavina-dewidewisiya kana nivaniva tamoka yamayamaninama atu kuyadayada kana vi14 kana navinavi nenei, eyo Isineni matatafusi yomuyomusima sina munusiya. ");
INSERT INTO wat_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Eketa ufaufasi tunina kwana yuna keta numasima nenesiyai kwana kawa, kasi kawa kuniniusi keta kuetasi kwana nuvidaodaoḡona. ");
INSERT INTO wat_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Nuwabunanama nenei gevagevamokesi kwana kaguwana keta kisaya onaonasi be maneka muka nakana nutuva nukusi kwana kawa. ");
INSERT INTO wat_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Yami kamokena o nofemaise. Kwana kanibubuna-vaḡata, kami kaevatakutakuna kwana vivaneina, eketa kiwana nimamiyai kwana givikaviniya, atu kwana venukakawa. Nofe o Venuvisinatana Kana Ka, Iyau Yave kaku vimogumogu fasinei. ");
INSERT INTO wat_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Yota nuwabunanama nenei Itifita ana nifanakwanikwaniuwiya keta namoḡa kayeusi be yomuyomu mikitufuwisi matatafusi Itifita sinenei ana nuvimatisiya. Eketa guyausima Itifita namoisi nenesiyai si kodukoduwa, matatafusi ana vimatadawanisiya. Iyau tauku Yave. ");
INSERT INTO wat_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Yami numa kasi kawa nenesiyai ufaufa ina vikiyakiyaya yami kafa fakwa. Ebe tovanama ufaufanama ana kitiya, ana venuvisinatanimiya be kwami muka nukusi tovanama Itifita sinenei ana nuvimateya. ");
INSERT INTO wat_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Manamana tamokatamokaḡa sinenei nofe kuyadayadanama nenei Venuvisinatana Kana Ka kwana fufufuniya yami kafa tuku, Iyau Yave avana a saviviniya fasinei. Nofe kami kwenava kwana kitavikaviniya tova matatafuna si nenemiya nenesiyai.’” ");
INSERT INTO wat_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yave yana sifufu i nusaviya i bwaduwa, “Tovanama Itifita kwana teweiya, Maneka Muka Nakana Nutuva Kana Ka nofemaise kwana fufuniya. Kuyadayada 7 sinesiyai maneka muka nakana nutuva kwana kaniya. Kuyadayada kafa viuḡu nenei, kafa nutuva matatafuna yami numa sinesiyai kwana teweteweina. Kuyadayada kafa viuḡu keta i niya kana vi7 nenesiyai, taki aitevana maneka nutunutuvina ina kaniya, ina kakaviya Isineni namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Kuyadayada kafa viuḡu keta yota kana vi7 nenesiyai, tamo nenei kwata yokoyokowa kodukodu fasinei. Muka tamo kwana mudadava kuyadayadasima nenesiyai eatu naki kabwaga-vitavaḡa. ");
INSERT INTO wat_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Maneka Muka Nakana Nutuva Kana Ka kana kuyadayada kwana kawiiya. Noko yami kafa tuku. Na tovanama nenei, ugunimi be fasekwimi Itifitei a kikinomana-nemiimiya. Na fasinei nofe kuyadayadanama kwana kitavikaviniya kami kwenava tova matatafuna si nenemiya nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Eketa Mosese Isineni tokawakawa matatafusi i vakukusisiya keta i iyavisiya i bwaduwa, “Kwana niya keta sifi o gouti mwanavauna kwana gibokiya eketa ugunimi fasimiyai kwana munuya Venuvisinatana Kana Ka fasinei. ");
INSERT INTO wat_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Vanekuwe dadana kwana nufwafwa keta ufaufa na bobonusi nenesiyai kwana nukutuva keta kawa kuniniusi be kuetasi kwana nuvidaodaoḡona. Muka tamo aitevana numai ina kikinomana kana nivaniva nuwabuni. ");
INSERT INTO wat_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Nuwabuna kawasasana nenei Yave Itifita ina nifanakwanikwaniuwiya keta Itifita ugunisi tamokatamokaḡa nenesiyai, namoḡa kayeusi ina nuvimatisiya. Atu tovanama ufaufa ina kitiya numa kasi kawa kuniniusi be kuetasi, yami numa ina venuvisinatanisiya. Mate kana kaetoḡa abamei muka ina sawateweyei be ina kanasuna yami numai keta natunatumi namoḡa kayeu ina nuvimateisi. ");
INSERT INTO wat_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Nofe Venuvisinatana Kana Ka kwami keta natunatumi kwana kitavikaviniya kami kwenava fakwafakwa-vaḡasina. ");
INSERT INTO wat_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Eketa tovanama kwana niya fwayafwayanama Yave i bwadudabedabiya ina venimiya nenei, kwana kitavikaviniya kami kwenava. ");
INSERT INTO wat_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tovanama natunatumi sina nutoniimiya Kanama kana givina fasinei, ");
INSERT INTO wat_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","kwana iyavisiya kwana bwaduwa, ‘Nofe o Venuvisinatana bwanaosena, Yave kana vimogumogu fasinei. Manatuwaina Itifita sinenei noko nuwabunanama nenei, Yave yata numa i venuvisinatana. Itifita fiyagenagena namoḡa kayeu i nuvimatisiya eatu natunatuta i ofafafisiya.’” Tovanama Mosese i nusifufukooḡa, namoḡa matatafusi si koduwa keta Yave nenei si kodukoduwa. ");
INSERT INTO wat_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Eketa avana Yave, Mosese keta Anoni i visimeisiya, naki maisemoka si muniiya. ");
INSERT INTO wat_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nuwabuna sinefouna nenei, Itifita fiyagenagena namoḡa kayeu matatafusi Yave i nuvimatekoḡoisiya. Tufomu natuna kayeu vitana yana gabu ita viya, nenei i vibutuwa keta i sobuwa kana nivaniva finisina natuna kayeu deni sinenei nenei. Keta yota yomuyomu-menana natunatusi mikitufuwisi i nuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Noko nuwabunanama nenei tufomu yota yana tovisime keta Itifita kana matatafu namoḡa si kenovinisiya. Eatu numa tamokatamokaḡa sinesiyai o mate, na fasinei matatafusi si bwedibwaubwauwa. ");
INSERT INTO wat_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tamoka nuwabunanama nenei tufomu Mosese keta Anoni i wenisiya eketa i iyavisiya i bwaduwa, “Yami sabu nukusi kwa kikinomana! Yaku fwayafwaya kwa teweyei be kwa nai Yave nenei kwa kodukodu avana kwa bwaduwiya maise. ");
INSERT INTO wat_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Yami sifi, yami gouti keta yami bunumakau nukusi kwa vaisi be kwa nai. Eatu yami Guyau yota nenei kwana kawakawanunukuwa be ina sawanuwagabubuwikuwa.” ");
INSERT INTO wat_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Itifita namoisi fiyao Isineni si nuyakayakanisiya be sina venuniya. Si iyavisiya si bwaduwa, “Taki muka kwana nai, nao matatafuki kana matekooḡa.” ");
INSERT INTO wat_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Fiyao Isineni kaesiyai Namesese si noḡokawawa keta si niya Sukoti. Namoaḡa o kasi yagwana 600,000 maise, eatu muka vivine keta fiyagenagena sita sawanatusi. ");
INSERT INTO wat_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Namoḡa yagwanisi tunisi yota Isineni si tuyanomwanisiya keta nukusi si niya. Yasi sifi be gouti keta bunumakau waumisi nukusi si niisiya. ");
INSERT INTO wat_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Itifita namoisi yasi nuyakayakanai be si gisoḡosoḡowa keta muka tamo kawasasa be biyawasa sita gidewadewa. Eketa kausibi yafoyafofosi si unaniina. Noko nenei maneka muka nakana nutuva si kaguwana. ");
INSERT INTO wat_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Fiyao Isineni si fakwa Itifita manamana kana yagwana 430. ");
INSERT INTO wat_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yave Mosese keta Anoni i iyavisiya i bwaduwa, “Venuvisinatana Kana Ka kana ketaketa nofemaise. Muka tamo avi tene wagawaga ina kawiyei. ");
INSERT INTO wat_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kami kaetoḡa gabanai kwa kimwanisiya, kasi nufota sina kaniya eatu nauna nufifina sina viya. ");
INSERT INTO wat_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Aviyaonana wagawaga sinemiyai keta yota yami tomudadava kwa fatifatisiya, muka sina kaniya. ");
INSERT INTO wat_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Venuvisinatana gevagevana numanama sinenei kwa gidewadewiya, kwana kaniya. Muka tamo viyona kwana kikinomanei menanai. Yota muka tamo seḡana kwana kotoviya. ");
INSERT INTO wat_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isineni kami matatafu Venuvisinatana Kana Ka kwana kawiiya.” ");
INSERT INTO wat_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yave Mosese i iyaviya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Fiyagenagena namoḡa kayeu matatafusi kwana tenesinisiya fasikuwai. Matatafusi namoḡa kayeu keta yota yomuyomu mikitufuwisi matatafusi Isineni sinenei o Iyau fasikuwai.” ");
INSERT INTO wat_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Mosese fiyao Isineni i nusifufuwisiya i bwaduwa, “Kenani namoisi fwayafwayasiyai Yave ina niimiya naki avana yana bwadudabadaba fifiwanina i teniya kwami keta waḡawaḡami nenesiyai maise. Tovanama Yave fwayafwayanama ina venimiya nenei, ");
INSERT INTO wat_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","natunatumi kayeumi keta yota yomuyomu namoḡa mikitufuwisi kwana tenesinisiya. Matatafusi yomuyomu namoḡa mikitufuwisi o Yave fasinei. ");
INSERT INTO wat_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Eatu kana fata doniki natusi namoḡa mikitufuwina fasinei, sifi mwanavauna nenei kwana nuvitamaniya. Taki doniki muka kwana nuvitamanei, nao kayona kwana kotoviya. Eatu natunatumi namoḡa kayeumi matatafusi kwana nuvitamanisiya. ");
INSERT INTO wat_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tova munina natunatumi sina nutoninuvenuveimiya sina bwaduwa, ‘Ava uḡuna nofe ta fufufuniya?’ Kwana iyavisiya kwana bwaduwa, ‘Fafani Itifita nenei ta vitovikaetoḡa, eatu Yave yana fiwana utubasinei i kikinomana-nemiita. ");
INSERT INTO wat_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Itifita tufomu katekatena i gua keta muka ita sawateweyeita tana kikinomana. Na fasinei Itifita namoisi natunatusi kayeusi keta yomuyomu natunatusi mikitufuwisi matatafusi tamo nenei, Yave i nuvimatisiya. Noko uḡuna eketa yomuyomu natunatusi mikitufuwisi matatafusi ta vivibwanaoseisiya Yave nenei eatu fiyagenagena namoḡa kayeu matatafusi tana nuvitamanisiya.’ ");
INSERT INTO wat_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Nofe ita vikiyakiyaya vitana sisikufa nimamiyai maise keta yota tafakaimiyai. Uḡuna Yave yana fiwana utubasinei Itifitei i kikinomana-nemiita.” ");
INSERT INTO wat_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Menana Sukoti si teweiya atu si niya menana Etami nenei si vikabaḡa fwayafwaya nunumonumona kafakainei. ");
INSERT INTO wat_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yave i viketanunisiya. Kuyadayada nenei busibusi vikoḡona-misimisinina i viviketanuna kunausi. Eatu nuwabuna nenei o kai noyana maise vikoḡona-misimisinina i viketanunisiya keta i vivikimayeta. Noko nenei eketa kasi fata kuyadayada be nuwabuna sina niniya. ");
INSERT INTO wat_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tovanama Itifita tufomu biga i nowaniya vitana fiyao Isineni si dibwana, yana tovisime nukusi yasi nuwanuwa i kaviniya keta si bwaduwa, “Avamasi venemokena ta fufuniya? Yo kata kaetoḡa Isineni ta gionoveisi si ninai.” ");
INSERT INTO wat_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Eketa tufomu aviya kana waganusoni i gidewadewiya keta yota yana tonuaviya i visiya. ");
INSERT INTO wat_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Waganusoni dewadewasiḡa i givikasisiya kasi yagwana 600 i visiya, yota Itifita kana waganusoni matatafusi i visiya, waganusonisima tamokatamokaḡa na kasi kaimatana nukusi. ");
INSERT INTO wat_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yave Itifita tufomu katekatena i giviguiya eketa fiyao Isineni i omunitawisiya, eatu tasike na yasi gasisi si niniya. ");
INSERT INTO wat_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Itifita namoisi si omunitawisiya. Tufomu na yana osi keta waganusoni, waganusoni kasi tovidibwana keta yota tonuaviya kaeyai matatafusi si venukwavinisiya kana nivaniva Gibo Yabeyabenina kafakainei, menana Fi-ainoti niniunei si venuovisiya eatu fafaninei o menana Baani-sefoni. Nokomai fiyao Isineni si nifakwa kana tovai, Itifita namoisi si kikinomanisiya. ");
INSERT INTO wat_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tovanama fiyao Isineni matasi i kanakasiya, si kitisiya Itifita tufomu na yana tonuaviya nukusi si vavanenemiya niniusiyai. Matuta i gifofonisiya nenei si bwedisitasita Yave nenei. ");
INSERT INTO wat_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Keta si odowa Mosese nenei si bwaduwa, “O namaise, muka tamo kididiku Itifita nenei yo ku nemiikiya wanakikaoḡowai kana vikamatemateya? Avamasi ku fufuniya nenekiyai? Ava fasinei Itifitei ku kikinomana-nemiyeiki? ");
INSERT INTO wat_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Yawane Itifita ta fakwafakwa nenei ka iyaviwa ka bwaduwa, ‘Ku teneiki be ka fakwa naki ka vivikaetoḡa Itifita namoisi nenesiyai.’ Vikaetoḡa o dewadewamataina yo vikamatemate wanakikaoḡowai.” ");
INSERT INTO wat_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Eatu Mosese i iyavisiya i bwaduwa, “Muka kwana matuta! Naki kwana misinimoka fakinina eatu kwana kitiya namaise Yave ina gifafafaneimi. Itifita namoisi kimoki kwa kitikitisiya, muka yota kwana kita-savavineisi. ");
INSERT INTO wat_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yave ina nuaviya fasimiyai na fasinei kwana nigwanamoka.” ");
INSERT INTO wat_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Eketa Yave Mosese i iyaviya i bwaduwa, “Ava fasinei yo ku bwedibwedisitasita nenekuwai? Fiyao Isineni ku iyaveisi be naki si nimoka. ");
INSERT INTO wat_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Eatu ya kiwana kuna ginakasiya keta gibo kuweyaina kuna tuniya be gibo ina kawiya atu sinefounei fwayafwaya kokoninei kwana tamana. ");
INSERT INTO wat_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Itifita namoisi katekatesi ana giviguamokiya be sina venuomunitawimiya. Atu yaku vikaiwabu ana viya tovanama tufomu na yana tonuaviya, waganusoni yota waganusoni kasi tovidibwana ana vatanisiya. ");
INSERT INTO wat_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Noko nenei Itifita namoisi sina sanamanikuwa vitana Iyau tauku Yave.” ");
INSERT INTO wat_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Eketa Guyau kana kaetoḡa abamei fiyao Isineni kunausi i niniya, eava i makaviniya kumunisi i misiniya. Yota busibusi vikoḡona-misimisinina kunausi i makaviniya kumunisi, ");
INSERT INTO wat_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","keta fiyao Isineni atu Itifita namoisi kasi kawasasai i misiniya. Tovanama i nuwabuna, busibusi kumanovana i gikikinomaniya Itifita namoisi nenesiyai eatu mayesina fiyao Isineni i tafisiya. Noko nenei fiyao Isineni keta Itifita namoisi muka kasi fata be sina vikanenemi niniusiyai nuwabuna kana matatafu. ");
INSERT INTO wat_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mosese nimana i tuniya gibo kuweyaina, eketa Yave fonimana fifiwanina gagasei i vininitiya. Nuwabuna kana matatafu i sivenumasana keta gibo i katuuya atu fwayafwaya kokonina i kikinomana. ");
INSERT INTO wat_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Gibo fafaninei fafaninei i nuvivaniya maise nabenabe eatu sinefounei fwayafwaya kokoninei si tamana. ");
INSERT INTO wat_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Eatu yota Itifita namoisi si omunitawisiya munitafwamokesiyai. Tufomu yana osi keta yana waganusoni yota waganusoni kasi tovidibwana si venukwavinisiya gibo sinefounei. ");
INSERT INTO wat_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Eatu muniyai yo tova kana fou ina vitetiya, kai noyana busibusi vikoḡona-misimisina etanei, Yave i kitanusinowa Itifita tonuaviya nenesiyai keta i venuvibaubausiya. ");
INSERT INTO wat_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yasi waganusoni kaesi i givigoyusiya eketa si dibwana-tukatuka. Eketa si bwaduwa, “Fiyao Isineni ta dibwaneisi! Yave i badiwaga Isineni fasisiyai keta i nunuaviita.” ");
INSERT INTO wat_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tovanama fiyao Isineni si tamanakooḡa, Yave Mosese i iyaviya i bwaduwa, “Nimau ku tunei gibo kuweyaina be ina makaviniya Itifita namoisi keta yasi waganusoni yota waganusoni kasi tovidibwana etasiyai.” ");
INSERT INTO wat_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tovanama vanavana i kukusifuya, Mosese nimana i tuniya gibo kuweyaina keta gibo i nutamane-savaviniya kana kiviyai. Eketa Itifita namoisi nuwanuwasi be sina dibwana eatu Yave gibowai i vigavivinisiya. ");
INSERT INTO wat_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Gibo i nutamane-savaviniya keta waganusoni be waganusoni kasi tovidibwana i kabwanisiya. Atu Itifita tonuaviya matatafumokesi Isineni si omunitawisiya gibo sinefounei, muka tamo mainigenigesi. ");
INSERT INTO wat_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Tovanama fiyao Isineni si kitiya namaise Yave yana fiwana utubasinei i saviviniya Itifita namoisi nenesiyai, Yave si omatumatutiya keta si vitumaḡaniya maisemoka yota kana kaetoḡa Mosese. ");
INSERT INTO wat_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Noko muninei Mosese keta fiyao Isineni nofemaise si osedavadava Yave nenei. “Yave ana osedavadaviya uḡuna yana kaiwabu i vanemataiya. Yasi osi be kasi tovidibwana nukusi gibowai i tewesobusobuwisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yave tanake yaku fiwana eketa i gifafafanikuwa fasinei, a oseosedavadaviya. Tanake yaku Guyau, ana daviya. Tanake amaku yana Guyau, ana ginakasiya. ");
INSERT INTO wat_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yave o aviya kana kaimatana, kana wava o Yave. ");
INSERT INTO wat_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Itifita tufomu yana aviya kasi waganusoni keta yana tonuaviya nukusi i tewesobuwisiya gibowai. Tufomu yana tonuaviya tomatakaikai, Gibo Yabeyabenina nenei i vigamomonisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Gibo i kabwanisiya eketa si kenogavivina ogodibu sifunei maise gabana. ");
INSERT INTO wat_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yave yo, kikikataiu fifiwanamataina. Yave yo, kikikataiweu nifanifaiu ku venuyauyaunisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Aviyaonana si vikaniyabiniwa ku vatanisiya uḡuna kwaḡa ku vanemataiya. Keta ya kayokuḡa busubusuwanina i nuyauyauniya keta ku vikanayaunisiya vitana nimwau sedovayana maise. ");
INSERT INTO wat_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Niuḡu kawasiveinei gibo ku nuvivaniya. Nefo nutanasagusagusi si misiniya fita maise. Ogodibu sinefounei gibo i kokoniya. ");
INSERT INTO wat_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Nifaiu i onavaneya, ‘Ana omunitawisiya, keta ana tabisiya. Yasi nogonogo matatafuna ana vitukuwiya, nuwanuwaku aviyavana maise ana viya. Yaku feto ana sinayaginiya keta nimakuwai ana nuyaunisiya.’ ");
INSERT INTO wat_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Eatu kawasiveiu nenei gibo i kabwanataunisiya. Keta yoyo nutanasagusagusi nenesiyai si gamomona gabana daunina maise. ");
INSERT INTO wat_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yave yo, mukamokena tamo avi guyau maise kwaḡa! Aitevana tamo maise kwaḡa, dewadewamokeu keta tafutafuu? Sina matutiwa keta sina daviwa uḡuna kiyakiyaya kafa nuwatabau ku gikikinomanisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kikikataiu ku tuniya keta nifanifaiu fwayafwaya i tononisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ya nuwagabubu fakwafakwa-vaḡasina nenei ya namonamoḡa ku tutuvisobusiya ku viketanunisiya, ya fiwana utubasinei ku viketanunisiya keta ku niisiya ya kafa fakwa tafutafuna nenei. ");
INSERT INTO wat_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bigau ina kewa nenei, mani kunuma namoisi sina akikinikuna na yasi matuta. Finisitiya namoisi matuta nakasina ina gifofonisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edomu kasi kaiwabu sina matutamoka. Yota Moabi kana toviketanuneina na yasi matuta sina akikinikuna. Kenani kana matatafu, matutai ina kafuwafuwaisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Matatafusi matuta nakasina ina gifofonisiya. Yave yo, kataiu yana fiwana sina kitiya nenei, sina misinivaḡata vitana gabana maise, kana nivaniva kima ya namonamoḡa kana niunisiya, kana nivaniva namoikima vikaetoḡa nenei ku ketoyaukiya kana niunisiya. ");
INSERT INTO wat_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yave yo, kuna kanasunisiya be tauḡu ya koyai kuna vitoḡamenanisiya — menananama ku gibokiya be kuna fakwiiya nenei, numanama tafutafuna tauḡu ku omanafufuniya nenei. ");
INSERT INTO wat_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Kwaḡa Yave ya namonamoḡa nenesiyai kuna visime-vaḡata.” ");
INSERT INTO wat_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","21","Anoni nouna Miniyami tomatakawa, kinage kabesona nimanei i givikaviniya keta vivine matatafusi si muniiya si kikinomana si nukinageya keta si vaḡa. Eketa Miniyami nofemaise i oseya, “Yave tana osedavadaviya uḡuna yana kaiwabu i vanemataiya. Yasi osi be kasi tovidibwana nukusi gibowai i tewesobusobuwisiya.” Tovanama Itifita tufomu yana osi keta yana aviya kasi waganusoni yota kasi tovidibwana nukusi gibo sinenei si kanasuna, Yave gibo i viyewiya keta i kabwanataunisiya. Eatu Isineni namoisi o gibo sinenei atu fwayafwaya kokoninei si niya. ");
INSERT INTO wat_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mosese fiyao Isineni i viketanunisiya keta Gibo Yabeyabenina si teweiya atu si kanasuna fwayafwaya nunumonumona kana wava Suwa nenei. Kuyadayada tonusi fafaninama nenei si niniya eatu muka tamo ukowa sita nisaḡai. ");
INSERT INTO wat_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Atu tovanama si kikinomana kabaḡa kana wava Manai nenei, ukowa si nisaiya. Eatu kayomunina o onaonana eketa muka yu kana nufota. (Na fasinei keta kabainama si weniya Manai.) ");
INSERT INTO wat_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Namoḡa si odowa Mosese nenei si bwaduwa, “Avana kata yumiya?” ");
INSERT INTO wat_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Na fasinei Mosese Yave nenei i bwedisitasita eketa Yave kai kafewina i visawaveniya. Tovanama i tewesobuwiya ukowai, ukowa i dewadewa. Nokomai namoḡa yasi fakwafakwa fasinei Yave visime i venisiya be i anuvinuvisiya taki sina muniiya o muka. ");
INSERT INTO wat_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I bwaduwa, “Taki fonaku kwana nowanautuutuya keta yaku nuwanuwa kwana muniiya be yaku visime matatafuna kwana vifotuwisiya, nao visafwavinaḡasima Itifita namoisi a venisiya muka ana nemiyeisi nenemiyai. Uḡuna Iyau Yave kami togivibwina.” ");
INSERT INTO wat_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Noko muninei si nemiya menana Enimu nenei keta fonufonu 12 yota bodaboda kaisi 70 si nisaisiya. Nokomai ukowa kafakainei si vikabaḡa. ");
INSERT INTO wat_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Fiyao Isineni matatafusi Enimu si teweiya atu si niya fwayafwaya nunumonumona kana wava Sini nenei. Sini o Enimu keta koya Sainai kasi sinefouwai. Tovanama Itifita si teweiya, yamayamana tamokaḡa i kakaviya muninei, kuyadayada kana vi15 yamayamana kana vinuwa nenei si kikinomana nokomai. ");
INSERT INTO wat_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Yota nokomai matatafusi si odowa Mosese keta Anoni nenesiyai. ");
INSERT INTO wat_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Si iyavisiya si bwaduwa, “Oiyoi. Yawane Itifita ka fakwafakwa nenei Yave ita nuvimatemokikiya nonowana. Nokomai toamatanigwanai gevageva be kabwaga tuninatunina ka kakawayosa. Eatu kwa noḡokawawa-nemiikiya fwayafwaya nofe nunumonumonei be vitanona nenei matatafuki kana domunakooḡa.” ");
INSERT INTO wat_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Keta Yave Mosese i iyaviya i bwaduwa, “Ku vaneneḡa! Kabwaga abamei ana gininisiwaiya fasimiyai. Kuyadayada tamokatamokaḡa namoḡa sina kikikinomana be kasi ketowavai kabwaga sina ooyuna na kuyadayadanama fasinei. Nofe ketaketanama nenei, ana anuvinuvisiya be ana kitiya taki yaku gisawakedana sina muniiya o muka. ");
INSERT INTO wat_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Oyuna ina niniya atu kuyadayada kana vi6 nenei sina oyuna-vaḡata kuyadayada nuwesi fasisiyai keta sina gidewadewiya.” ");
INSERT INTO wat_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Eketa Yave Mosese i iyaviya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Fiyao Isineni yasi odo a nowaniya. Ku iyaveisi, ‘Vanavana kusibanina nenei nao gevageva kwana kawa eatu nuwabuni nao kabwaga kwana kasiyuwa. Nokomai nuwatami ina kanabunabuya vitana Iyau o Yave yami Guyau.’” ");
INSERT INTO wat_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Navinavinama nenei manuwa maise bunini nakanakasisi waumisi si noḡokanasuna keta kabaḡa si gikafufuya. Atu nuwabuni nao bunuva fwayafwaya i weibutiya. ");
INSERT INTO wat_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Eketa tovanama bunuva i kokoniya, aviyavana yanayanana keta bigabigana vitana nafiya giyauyauneinana maise fwayafwayai i vidabodabowa. ");
INSERT INTO wat_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tovanama fiyao Isineni si kitiya, si bauwiya keta tututausi nenesiyai si vikanunutoniya si bwaduwa, “Nofe aviyavana?” Mosese i iyavisiya i bwaduwa, “Nofe kabwaganama Yave i venimiya kwana kaniya. ");
INSERT INTO wat_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yave nofemaise yana gisawakedana i bwaduwa, ‘Namoḡa tamokatamokaḡa tauna yana ka kana ketowavai ita oyuna. Namoḡa tamokatamokaḡa ugunina fasisiyai ina oyuna naki bobonu nuwesi kasi naḡanaḡai.’” ");
INSERT INTO wat_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Eketa fiyao Isineni Yave yana visime si muniiya. Tunisi si oyuna nakasina eatu tunisi o bobonu kunegitosiḡa. ");
INSERT INTO wat_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Eatu tovanama si ketowava nenei, matatafusi naki kasi fata. Aviyaonana si oyuna nakasina o muka tamo ita tufo, yota aviyaonana bobonu kunegitosiḡa o naki kasi fata. Namoḡa ugunina tamokatamokaḡa naki kasi naḡanaḡai. ");
INSERT INTO wat_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mosese i iyavisiya i bwaduwa, “Muka tamo aitevana ina tenetuuwei kumana fasinei.” ");
INSERT INTO wat_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Eatu fiyao Isineni muka yana bwadu sita muniyei. Tunisi si tenetuuwina i toḡanumasana kana nivaniva nuwabuni eketa mwatamwata si vimaiya keta i kuyuwa. Na fasinei Mosese namoḡa i nuwagoyowisiya. ");
INSERT INTO wat_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nuwabuni tamokatamokaḡa nenei matatafusi si ooyuna kasi ketowavai ka fasinei, atu tovanama vanavana i nunuinaina, tufotufo i kakabudaniya. ");
INSERT INTO wat_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kuyadayada kana vi6 nenei, namoḡa tamokatamokaḡa tauna fasinei yana oyuna kana naḡa i vivinuwiya i vanevaneya bobonu nufunina kana naḡa. Eketa Isineni kasi toviketanuneina matatafusi si nemiya Mosese nenei eketa yasi oyunanama fasinei si vinuwakatiya. ");
INSERT INTO wat_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mosese i iyavisiya i bwaduwa, “Yave nofemaise yana visime. Kumana o viyawasi kana kuyadayada. Kuyadayadanama o Sabati tenetenesineinana Yave kana vifotu fasinei. Eketa taki aviyavana kuna vitakuya, nao ku vitakuya eatu taki kuna vitaviya o ku vitavai. Atu tufotufo matatafuna, kuna odewadewiya kana nivaniva nuwabuni.” ");
INSERT INTO wat_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mosese yana visime nenei namoḡa yasi tufotufo si tenetuuwina kana nivaniva nuwabuni, atu muka ita kuyu o mwatamwata sita vimaḡai. ");
INSERT INTO wat_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosese i iyavisiya i bwaduwa, “Kimoki nofe kabwaganama kwana kaniya uḡuna kuyadayada nofe o Sabati tenetenesineinana Yave nenei. Kuyadayada kimoki muka tamo kabwaganama fwayafwayai kwana nisaḡai. ");
INSERT INTO wat_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Kuyadayada 6 nenesiyai kwata ooyuna. Eatu kana vi7 nenei nao Sabati eketa muka tamo kuna nisaḡai.” ");
INSERT INTO wat_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Eatu kuyadayada kana vi7 nenei namoḡa tunisi si kikinomana oyuna fasinei atu si venuokava. ");
INSERT INTO wat_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Keta Yave Mosese i iyaviya i bwaduwa, “Yaku gisawakedana be yaku visime kwa adibutoyotoyoḡakaoḡoweisi! ");
INSERT INTO wat_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kwana tukuya vitana Sabati o Iyau Yave a venimiya. Na fasinei kuyadayada kana vi6 nenei bobonu kana naḡa i vifofwiya ebe kuyadayada nuwesi ina givikavinimiya. Kuyadayada kana vi7 nenei tamokatamokaḡa yana vadai ina toamatanigwana eatu muka ina kikinomana ina oyuna.” ");
INSERT INTO wat_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Na uḡuna kuyadayada kana vi7 nenei namoḡa si viyawasiya. ");
INSERT INTO wat_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Fiyao Isineni kabwaginama si weniya mana. ");
INSERT INTO wat_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Fiyao Isineni mana si kanikaniya manamana 40 sinenei kana nivaniva Kenani kana nabaonota nenei si kikinomana, fwayafwayanama nenei sina vimenana. ");
INSERT INTO wat_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Fiyao Isineni matatafusi fwayafwaya nunumonumona kana wava Sini si teweiya keta si toḡavenudadana Yave yana visimeyai. Nefidimu nenei si vikabaḡa eatu muka tamo ukowa kafa yu. ");
INSERT INTO wat_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Na fasinei namoḡa si vikawabwadubwaduwa Mosese nenei si bwaduwa, “Ukowa kwa veneiki ka yuwa!” Eatu i kawafatisiya i bwaduwa, “Ava fasinei ta vivikawabwadubwadu? Ava fasinei Yave kwa aanuvanuvai?” ");
INSERT INTO wat_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Eatu namoḡa kayosi i nusonimoka eketa Mosese nenei si odowa si bwaduwa, “Ava fasinei Itifitei ku kikinomana-nemiyeiki? Omasi natunatuki be yama yomuyomu nukusi kayonusoniyai kuna nuvimatikiya!” ");
INSERT INTO wat_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Eketa Mosese Yave nenei i bwedisitasita i bwaduwa, “Avamasi ata savivinei namoḡasima nofe nenesiyai? Tova kabegomokena gabanai sina fonufonukuwa.” ");
INSERT INTO wat_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yave Mosese i iyaviya i bwaduwa, “Isineni tokawakawa aviyesi kuna ovisiya keta kiwananama ku kanuwiiya ukowa Naeni, kuna viya be namoḡa kunausi kwana niya. ");
INSERT INTO wat_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Koya Sainai nenei kunauḡu guwakaukuna etanei ana misimisiniya. Na guwakaukunanama kuna naviya keta ukowa ina ketosiwaḡa ebe namoḡa sina yuwa.” Eketa Isineni tokawakawa matasiyai Mosese i saviviniya. ");
INSERT INTO wat_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Fiyao Isineni Mosese nenei si vikawabwadubwaduwa yota Yave si anuvanuviya tovanama si bwaduwa, “Yave kita nukusi o muka?” Na uḡuna kabainama i weniya Masa keta Meniba. ");
INSERT INTO wat_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Fiyao Isineni yawane Nefidimu nenei si fakwafakwa, atu Ameneki namoisi si nemiya keta si vibutusiya. ");
INSERT INTO wat_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Eketa Mosese Yosuwa i iyaviya i bwaduwa, “Yata namoḡa kuna gibokisiya ebe sina niya Ameneki namoisi nukusi sina nuaviya. Kumana kiwananama Guyau i iyavikuwa ana uniya, ana givikaviniya keta nukusi koya etanei ana misiniiya.” ");
INSERT INTO wat_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Eketa namaise Mosese i iyaviya maise, Yosuwa i saviviniya eketa Ameneki tonuaviya nukusi si nuaviya. Na tovanama nenei Mosese be Anoni keta Une si vaneya koya etanei. ");
INSERT INTO wat_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tovanama Mosese nimanei kiwana i giginakasiya, Isineni tonuaviya nifanifaisi si fifiwanateweisiya. Atu tovanama kataina si seḡaseḡakamekameya be nimana si sobusobuwa, nao Ameneki tonuaviya si oomanimaniniya. ");
INSERT INTO wat_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mosese kataina si dauna keta kasi ginakata i bauwiya. Na fasinei Anoni keta Une gabana si teniya Mosese sifunei eketa i nuvitoḡa. Eatu tamo i misiniya kukikikataina yota tamo kukikimawana, eketa nimana si katunakata kana nivaniva vanavana i sonuwa. ");
INSERT INTO wat_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Noko nenei Yosuwa Ameneki tonuaviya i vatanisiya. ");
INSERT INTO wat_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mosese kawana amasi Yeteno, Midiyani kasi guyau kana tovibwanaose, i biganowana iba matatafuna avana Guyau i saviviniya Mosese keta fiyao Isineni fasisiyai yota namaise Itifitei i kikinomana-nemiyeisi. ");
INSERT INTO wat_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","6","Tovanama Mosese i vikabaḡa Guyau yana koya nenei fwayafwaya nunumonumonei, Yeteno yana kisuya i vininitiya Mosese nenei i bwaduwa, “Kawau keta natunatuu namoḡa nasi nuwa nukusi ka nenemiya kana venufotiwa.” ");
INSERT INTO wat_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Tovanama si kikinomana, Mosese nawana i venufotefotiya keta i koduwa i viyuiya. Si vikanunutoniya si bwaduwa, “Namaise, dewadewau?” Eyo si kanasuna Mosese yana vadai. ");
INSERT INTO wat_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosese nawana iba matatafuna i nusifufuwiya avana Yave i saviviniya Itifita tufomu keta yana namonamoḡa nenesiyai, fiyao Isineni kasi gifafafana fasinei. Yota i nusifufuwiya namaise namoḡa dauna si kamukonisiya ke'ta tofwanei eatu namaise Yave i gifafafaneisi. ");
INSERT INTO wat_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yeteno i sebobowa tovanama i nowaniya, iba dewadewasi matatafusi Yave i savivinisiya fiyao Isineni fasisiyai tovanama i gifafafanisiya Itifita namoisi nimasiyai. ");
INSERT INTO wat_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yeteno i bwaduwa, “Yave a daviya uḡuna i gifafafanimiya Itifita namoisi keta tufomu nenesiyai. Venemokena! Fiyao Isineni i gifafafanisiya Itifita namoisi nimasiyai. ");
INSERT INTO wat_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nofe kakimokimokima tu naki a sanamaniya venemokena, gewa Yave tanake fifiwanamokena muniyai yo guyau matatafusi namoḡa si kodukoduwa nenesiyai, uḡuna Itifita yasi vitoagoyogoyo keta yasi viibakaokaoḡo nenei yana namonamoḡa i gifafafanisiya.” ");
INSERT INTO wat_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Tovanama tova i kakatakiya, Mosese i nunuvitoḡa kafa nuesana kana kivi nenei keta namoḡa unaunasi nukusi yasi avigwavigwaeḡa i vanevaneneisiya. Si misimisiniya nuwabuni keta si fotafota kana nivaniva nuwabuna. ");
INSERT INTO wat_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Tovanama Yeteno i kitiya Mosese iba matatafuna i savisaviviniya namoḡa fasisiyai, i iyaviya i bwaduwa, “Avamasi nofe ku fufufuniya namoḡa fasisiyai? Namaise yo savivina nofe ku ookeyei, eyo namoḡa matatafusi nuwabuni si misimisini kana nivaniva nuwabuna?” ");
INSERT INTO wat_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosese i nufata nenei, “Nofemaise a savisaviviniya uḡuna namoḡa si nenemiya nenekuwai be sina sanamaniya avana sita fufuniya Guyau yana nuwanuwa maise. ");
INSERT INTO wat_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tovanama namoḡa nasi nuwa sina avigwavigwaeḡa, sina nemiya nenekuwai eketa iyau a vivinuwadadaniya nasi nuwa nenesiyai aitevana o dawaniniina, eketa Guyau yana gisawakedana keta yana visime a iyaiyavisiya.” ");
INSERT INTO wat_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yeteno i iyaviya i bwaduwa, “Nofemaise muka dewadewana. ");
INSERT INTO wat_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Savivina nofe daunamokena eketa muka kana fata kuna okeyekeyei. Ya namonamoḡa nukusi tututaumi yawasimi kwa weiweikanatuya. ");
INSERT INTO wat_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ku vaneneḡa, atu bwaduovivita ana veniwa keta Guyau kwaḡa nukusi. Kwaḡa ka nufota be namoḡa yasi nusuyai kuna misiniya be Guyau kuna nusifufuwiya namoḡa yasi avigwavigwaeḡa fasinei. ");
INSERT INTO wat_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kwaḡa kuna visawavenena namoḡa nenesiyai Guyau yana gisawakedana keta yana visime. Yota kuna givisawakedana yasi fakwafakwa yota namaise sina fufuna kana matanabobotai. ");
INSERT INTO wat_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Eatu yota namoḡa tunisi tosanamana kuta vinuwadadanisiya sabu matatafusi sinesiyai kuta gibokisiya ebe namoḡa nenesiyai sita vitovisimeya. Tunisi 1,000 namoḡa nenesiyai sita vitovisimeya, tunisi 100, tunisi 50 eketa tunisi 10. Namoisima kuta gibokisiya o tasike Guyau kana tovifotu, yota tasike yami tumaḡana nenesiyai eketa yota tasike muka tovitutusebaseba sina fonaoḡoveisi. ");
INSERT INTO wat_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Tova matatafuna tasike sita vivinuwadadana namoḡa yasi avigwavigwaeḡa fasisiyai. Keta avigwavigwaeḡa nakanakasisi sita nemiisiya neneweu eatu meyameyanisi o tututausi sita gidawaniniisiya. Dauna sina unavivitiwa be neneweu ita meyameyana. ");
INSERT INTO wat_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Taki nofemaise kuna saviviniya, Guyau ina viketanuniwa keta muka yawasiu ina kanaonosiya ebe namoḡa nofe matatafusi keiya nenei sina makavina yasi numai.” ");
INSERT INTO wat_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosese nawana yana bwadu i nowaniya eketa avana i bwaduwiya maise, matatafuna i saviviniya. ");
INSERT INTO wat_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Fiyao Isineni kasi matatafu sinesiyai tosanamana i gibokisiya be namoḡa nenesiyai sina vitovisimeya. Tunisi 1,000 namoḡa nenesiyai si vitovisimeya, tunisi 100, tunisi 50 eketa tunisi 10. ");
INSERT INTO wat_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tovisimesima tova kana matatafu si vivinuwadadana namoḡa yasi avigwavigwaeḡa fasisiyai. Avigwavigwaeḡa daudaunisi si nenemiisiya Mosese nenei eatu nama meyameyanisi o tututausi si vivinuwadadanisiya. ");
INSERT INTO wat_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Eyo Mosese nawana i vioiyoowiya eketa Yeteno i makaviniya yana fafaniyai. ");
INSERT INTO wat_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Fiyao Isineni Nefidimu nenei si noḡokawawa keta si niya fwayafwaya nunumonumona kana wava Sainai nenei. Nokomai koya Sainai uḡunei si vikabaḡa. ");
INSERT INTO wat_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Keta Mosese i vaneya koyai ebe Guyau nukusi sina vikaninisaḡa fasinei. Koya nenei Yave i bwauwa Mosese nenei keta i iyaviya be fiyao Isineni, Yakobo susukwana, ina iyavisiya ina bwaduwa. ");
INSERT INTO wat_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Kwami tututaumi naki kwa kitiya avana a saviviniya Itifita namoisi nenesiyai, eketa namaise a unimiya vitana manubutu fefesiyai natusi sita noḡovenevenei maise eketa a nemiimiya nofemai nenekuwai. ");
INSERT INTO wat_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Taki yaku bwadu kwana muniisiya be yaku dedeni muka kwana yasei, nao kwami yaku namonamoḡa. Iyau yaku fwayafwaya matatafuna, eatu namoḡa matatafusi nenesiyai kwami ana gibokimiya ebe kwami Iyau yaku nogonogofou. ");
INSERT INTO wat_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kwami kwana vitovibwanaoseya fasikuwai eketa kunumimi tenetenesineinana Iyauḡa fasikuwai. Naki maise fiyao Isineni kuna nusifufuwisiya.” ");
INSERT INTO wat_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Eketa Mosese koyei i sobuwa keta namoḡa kasi tokawakawa i katuvivisiya, eketa iba matatafuna avana Yave i visimeiya maise i nusifufuwisiya. ");
INSERT INTO wat_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Eketa namoḡa matatafusi tamo nenei si nufata si bwaduwa, “Iba matatafuna Yave i bwaduwisiya maise kana savivinisiya.” Keta namoḡa yasi nufata Mosese i bwaduwe-kikinomaniya Yave nenei. ");
INSERT INTO wat_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yave Mosese i iyaviya i bwaduwa, “Busibusi badobadonei ana nemiya neneweu keta ana nusifufuwiwa be namoḡa fonaku sina nowaniya ebe tova matatafuna sina vivitumaḡaniwa.” Tovanama Mosese i bwaduwe-kikinomaniya namoḡa yasi nufata Yave nenei, ");
INSERT INTO wat_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yave i iyaviya i bwaduwa, “Ku sobu namoḡa ku oviviteisi be kimoki keta kumana tututausi sina givieyaeisiya ebe nenekuwai sina kodukoduwa. Kasi nuya sina kigonagona, ");
INSERT INTO wat_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","keta sina gidewadewa kuyadayada kana vitonu fasinei. Kuyadayadanama nenei Iyau Yave ana sobunemiya koya Sainai etanei namai namoḡa matatafusi kana fata sina kitikuwa. ");
INSERT INTO wat_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Koya kuna gikotovafanakwaniuwiya ebe namoḡa muka sina vavisiniya. Kuna gimatakawisiya kuna bwaduwa, ‘Matami ina fekuwa! Muka kwana vane koyai o muka koya uḡuna kwana givikavina-nuvanuvai. Aitevana koya ina givikaviniya, sina nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Taki namoḡa o yomuyomu viketofota ina vavisiniya, muka kwana gisikoniya eatu gabana o iyo nenei kwana nuvimatiya.’ Eatu tovanama yuveyuve ina tuniya nubwayouna keta kayona nakasina kwana nowaniya, na naki namoḡa sina vaneya koyai.” ");
INSERT INTO wat_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Eketa Mosese koyei i sobunemiya keta namoḡa i iyavisiya be tututausi sina givieyaeisiya ebe Guyau nenei sina kodukoduwa fasinei, eketa kasi nuya si kigonagona. ");
INSERT INTO wat_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mosese i iyavisiya i bwaduwa, “Kuyadayada kana vitonu fasinei kwana gigidewadewa eatu kimoki keta ina niya noko tovanama nenei, muka kwana vimomona.” ");
INSERT INTO wat_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kuyadayada kana vitonu kana nuwabuni nenei, i nukanikanitana keta i kisinanamanamana, eketa busibusi badobadona i kenokikinomana koya etanei eketa yuveyuve kayona nakasina venemokena si nowaniya. Namoḡa matatafusi kabaḡai si fakwafakwa, na yasi matuta si akikikinikuna. ");
INSERT INTO wat_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Yasi kabaḡai Mosese i viketanunisiya eketa koya uḡunei si misiniya be Guyau nukusi sina vikaninisaḡa. ");
INSERT INTO wat_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Koya matatafuna siyou i gaubodiya uḡuna Yave i sobuwa koya etanei kikanakanata nenei. Siyou i vaneya vitana kufuna kana siyou kunukubana maise keta koya matatafuna i kayufeyufiya. ");
INSERT INTO wat_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Yuveyuve kayona i ninakanakata. Mosese i nusifufuwa keta Guyau i vinowaniya kanitana maise. ");
INSERT INTO wat_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yave i sobunemiya koya Sainai etanei keta Mosese i weniya i bwaduwa, “Ku vanenemai wekamai,” eketa Mosese i vaneya koya etanei ebe Yave nukusi sina vikaninisaḡa. ");
INSERT INTO wat_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Eketa Guyau gisawakedana nofe matatafuna namoḡa i venisiya. ");
INSERT INTO wat_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Iyau Yave yami Guyau, Itifita nenei kwa vitovikaetoḡa atu a kikinomana-nemiimiya. ");
INSERT INTO wat_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Mukamokena tamo avi guyau nenei kwana kodukodu naki kaku kisimokeku. ");
INSERT INTO wat_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Mukamokena tamo aviyavana abamai o fwayafwayai o ukowa sinenei fwayafwaya sifunei kasi fusafusa maise, kwana kifufunavikuvikukuneina fasimiyai. ");
INSERT INTO wat_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Mukamokena kaetutumi kwana viketogunisi be kwana kodukodu nenesiyai. Uḡuna Iyau Yave yami Guyau o muka ata sawateweyeimi be mani guyau nenesiyai kwana kodukodu. Tasike aviyaonana sina adibutoyotoyoikuwa, nao ana vimatadawanisiya yota maise ina niya natunatusi, waḡawaḡasi keta iteitesi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Eatu taki kwana nuwagabubuwikuwa be yaku visime kwana muniisiya, nao yaku nuwagabubu fakwafakwa-vaḡasina nenemiyai be yota susukwami nenesiyai, muka ina kakavei. ");
INSERT INTO wat_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mukamokena kaku wava kwana viibakaokaoḡowei. Taki aitevana kaku wava ina viibakaokaoḡowiya, Iyau Yave yami Guyau ana vimatadawaniya. ");
INSERT INTO wat_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Kuyadayada Sabati kwana vifotuwiya keta kwana tenesiniya fasikuwai. ");
INSERT INTO wat_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Kuyadayada 6 nenesiyai kwana mudadava, ");
INSERT INTO wat_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","eatu kuyadayada kana vi7 o Sabati kana kuyadayada, tenetenesineinana Yave yami Guyau fasikuwai. Kuyadayadanama nenei mukamokena tamo aitevana ina mudadava — maise kwami, natunatumi, kami kaetoḡa, yami yomuyomu keta yota aviyaonana yauyauna yami fafaniyai si fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Uḡuna kuyadayada 6 nenesiyai Iyau Yave abama, fwayafwaya be gibo keta yota iba matatafusi sinesiyai a fufunisiya, eatu kuyadayada kana vi7 nenei a viyawasiya. Na fasinei Iyau Yave kuyadayada Sabati a sawanuwagabubuwiya keta a tenesiniya fasikuwai. ");
INSERT INTO wat_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Amamami keta ayoayomi kwana vifotuwisiya ebe fwayafwayanama Iyau Yave yami Guyau a venivenimiya nenei, kwana fakwa yawasimi nubwayouna. ");
INSERT INTO wat_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mukamokena aitevana tamo kwana nuvimatei. ");
INSERT INTO wat_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Mukamokena aitevana tamo kawana kwana mataveyei. ");
INSERT INTO wat_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mukamokena kwana gikuma. ");
INSERT INTO wat_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Mukamokena unafafanimi fasinei kwana meyanonoweisi. ");
INSERT INTO wat_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Mukamokena unafafanimi tamo yana numa kwana kitanuvadiḡei. Mukamokena kawana kwana kitanuvadiḡei o kana kaetoḡa o yana yomuyomu-menana o taki tamo yana aviyavana.” ");
INSERT INTO wat_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Yota Yave yana sifufu i nusaviya i bwaduwa, “Taki tamo aitevana namoḡa tamo ina munuya be ina mateya, na gwadinama kwana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Atu taki ina nuvimate-bauwiya, nao yana dewadewana fasinei ina dibwana keta ina niya menananama ana vinuwadadaniya nenei. ");
INSERT INTO wat_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Eatu taki tamo namoḡa waina ina fufuniya keta ina nuvimatiya, keta taki kafa vikanakooḡa bwanaosena kana didiḡa ina odibwadibwaniya kana gifafafana fasinei, kwana sinakanikaniya keta kwana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Taki tamo aitevana amana o ayona ina munusiya, na gwadinama kwana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Taki tamo aitevana namoḡa tamo ina gikumiya keta ina vikimwaneiiya o yawane ina gigivikaviniya eatu kwana nisaiya, na gwadinama kwana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Taki tamo aitevana ina vikanatafutafuwa amana o ayona nenesiyai, na gwadinama kwana nuvimatiya.” ");
INSERT INTO wat_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Yota Yave yana sifufu i nusaviya i bwaduwa, “Taki avi namoḡa tutubonona nekaḡaba muka tamo kana sawagifoteina ina banuwiiya, nao ina nogonogoova keta ina vikawaniya. ");
INSERT INTO wat_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Eatu taki gumayogu amana namoḡanama ina dibutoyoiya, nao namoḡanama gabana nenei ina nogonogoova gumayogu amana ina veniya uḡuna gumayogu naki i banuwiiya. ");
INSERT INTO wat_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Taki avi gumayogu ina viviyafuneya, nao kwana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Taki avi namoḡa tamo yomuyomu ina vimomoniya, na gwadinama kwana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Taki tamo aitevana muka Iyauḡa Yave nenekuwai ina vibwanaose atu tamo mani guyau nenei ina vibwanaoseya, na gwadinama kwana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Mukamokena tamo teneyauyauna kwana vitoagoyogoyowei o kwana viibakaokaoḡowei, uḡuna kwana tukuya kwami yota Itifita nenei kwa viyauyauna. ");
INSERT INTO wat_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Mukamokena vivinekwafukwafuna keta natuḡaeda kwana vitoagoyogoyoweisi. ");
INSERT INTO wat_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Taki kwana vitoagoyogoyowisiya be sina bwedi-kikinomana nenekuwai ovivita fasinei, Iyau Yave o venemokena ana vinowanisiya eketa ana ovivitisiya, ");
INSERT INTO wat_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","yota taki yaku kayokuḡa ina kikinomanamoka, nao fetowai ana nuvimatimiya. Nokomai kakawami sina kwafuna yota natunatumi sina vinatuḡaeda. ");
INSERT INTO wat_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Taki yaku namonamoḡa goyogoyo nenesiyai gabana kuna tuniya, muka gabana tokavenena maise kuna fufuna be ina giviyewai na kana tunani. ");
INSERT INTO wat_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Taki unafafaniu gabana kuna veniya nao kana kwame ina veniwa. Kwamenama o yana bwadudabadaba neneweu vitana gabananama yawane ina fatasavaviniya. Eatu taki gabana muka ina venufatai nao kana kwamenama kuna viyewiya muniyai yo vanavana ina sonuwa. ");
INSERT INTO wat_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Na naki kana gananavama nonowana i vivisoḡowiiya. Aviyavana tamo ita banuwiyei nuwabuna? Taki muka kuna viyewai be ina bwedi-kikinomana nenekuwai ovivita fasinei, nao ana vinowaniya uḡuna Iyau tosineganigani.” ");
INSERT INTO wat_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Yota Yave yana sifufu i nusaviya i bwaduwa, “Mukamokena tamo sifufu vikanonono kuna yaunei mani namoḡa fasisiyai. Mukamokena tamo kuna vikanonono tonuvisi naunei be togoyona kuna ovivitei. ");
INSERT INTO wat_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tovanama namoḡa sabu goyona sina savisavivinisiya, mukamokena tamo kuna avikuvikukuneisi. Tovanama mani namoḡa sina vivikanononowa vifonayau kana tovai, mukamokena kuna vikanonono maise tasike. Mukamokena ketaketa dawaniniisi kuna nutautaunisi fufunasima nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mosese i niya keta visimesima matatafuna Yave i veniya, namoḡa i iyavisiya. Matatafusi tamo nenei si vinowana si bwaduwa, “Ika! Avana Yave i bwaduwisiya maise matatafuna kana savivinisiya.” ");
INSERT INTO wat_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Eketa Yave yana visime matatafuna Mosese i viginiwisiya. Kuyadayada kana vinuwa nenei, nuwabunimokeyai i misiniya keta didiḡa i didiiya koya uḡunei. Yota Isineni fasekwa 12 i naisiya keta gabana 12 nakanakasisi i vimisiniisiya. ");
INSERT INTO wat_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Muniyai Isineni sinesiyai tufunakata i visimeisiya si niya keta yomuyomu si nuvimatisiya keta si vibwanaoseina vikanakooḡa bwanaosena. Yota tunisi bunumakau namoḡa mwanavausi si vibwanaoseina keiya bwanaosena Yave nenei. ");
INSERT INTO wat_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosese yomuyomu ufaufasi tunina i viya keta kaboma nenesiyai i kisiwaḡatotoḡa. Eatu tunina o kafa vikanakooḡa bwanaosena kana didiḡa i nuseuseuniya. ");
INSERT INTO wat_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Eketa dedeni kana nufunufu kikikuwana i viya i ginaḡanaiya atu namoḡa si nowana keta si bwaduwa, “Iba matatafuna Yave i bwaduwisiya, kana savivinisiya keta kana muniisiya.” ");
INSERT INTO wat_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Keta Mosese ufaufa na kabomisi i visiya keta namoḡa i nuseuseunisiya. I bwaduwa, “Tovanama visime nofe Yave i venimiya, yana dedeni i fufuniya kwami nukusi keta ufaufa nofe kwa kitakitiya o naki i givifakiniya.” ");
INSERT INTO wat_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Eketa Yave Mosese i iyaviya i bwaduwa, “Ku vanenemai nenekuwai koyai be nofemai kuna fotafota. Yaku visime keta gisawakedana a viginiwisiya gabana beyabeyasi nenesiyai, ana veniwa kuna visawavenena namoḡa nenesiyai be sina muniisiya.” ");
INSERT INTO wat_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Mosese keta kana toovivita Yosuwa nukusi si gidewadewa vane fasinei eatu tokawakawa i iyavisiya i bwaduwa, “Nofemai kwana fotifotikiya kana nivaniva kana makavinikiya. Taki tamo aitevana nukusi sina avigwavigwaeḡa, Anoni keta Une nukusi kwana gidawadawaniniiya.” Mosese keta Yosuwa si misiniya keta Mosese Guyau yana koya i vaneiya. ");
INSERT INTO wat_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Tovanama Mosese i vaneya, busibusi koya i soḡotauniya. ");
INSERT INTO wat_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yave yana mayesina matakikikwanena i sobuwa koya Sainai etanei. Busibusi koya i sowiya kana nivaniva kuyadayada 6, eketa kana vi7 nenei busibusi sinenei Yave Mosese i bwauwiya. ");
INSERT INTO wat_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Tovanama fiyao Isineni matasi i vaneya, Yave yana mayesina matakikikwanena si kitiya kana kitakita vitana kai nakasina ita nununuḡa maise koya etanei. ");
INSERT INTO wat_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Eketa tovanama Mosese koya i vaneiya, busibusi sinenei i kanasuna keta nokomai i fakwa kuyadayada 40 keta nuwabuna 40. ");
INSERT INTO wat_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Yave Mosese i nusifufuwiya i bwaduwa, “Namoḡa yaku Vada Tafutafuna sina yoniya ebe kasi kawasasai ana fakwa. ");
INSERT INTO wat_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Vada Tafutafuna kwana yoniya na kana nogonogo matatafuna yaku nuwanuwai ana visawaveniwa maise.” ");
INSERT INTO wat_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Yota Yave yana sifufu i nusaviya i bwaduwa, “Namoḡa koni sina fufuniya kai kana wava akasiya nenei. Kana fwafwa kana nubwayou kana niva o 110 senitimita, kana nafanafa kana niva o 66 senitimita eketa yana vivivane kana niva o 66 senitimita. ");
INSERT INTO wat_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Gonudi-keyakeyana nenei sinena be kwauna kuna vitauniya eketa gonudi nenei kuna okanikanibubuna-fanakwaniuwiya. ");
INSERT INTO wat_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Nowanowa nufunina vigonudisi kuna fufunisiya keta koni kaenei nuwesi nowanowa fafaninei yota nuwesi fafaninei kuna vikanafwatafwataoḡonisiya. ");
INSERT INTO wat_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Akasiya kai nenei kewa kuna tasisiya keta gonudi nenei kuna vitaunisiya. ");
INSERT INTO wat_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Nowanowa koni kafakainei kewa kuna ketokwanisiya ebe nenesiyai kwana uniiya. ");
INSERT INTO wat_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Kewa o nowanowa sinesiyai sina fakwa eatu muka kwana nusoniyagina. ");
INSERT INTO wat_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Tovanama gabana nuwesi beyabeyasi nenesiyai yaku visime 10 viviginiwisi ana veniwa, koninama nenei kuna totoisiya. ");
INSERT INTO wat_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Koni kana gudu gonudi-keyakeyana nenei kuna fufuniya kana fwafwa kana nubwayou kana niva o 110 senitimita keta kana nafanafa kana niva 66 senitimita. ");
INSERT INTO wat_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Eketa kifukifufuna nuwesi na fefesi kasi wava senabimu, gonudi nenei kuna tutuvikuvikukunisiya eketa kuna givifotisiya kana gudu nenei ebe kuna nutamokisiya. Gudu bwatanei bwatanei senabimu nuwesi kuna tenisiya. ");
INSERT INTO wat_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Fefesi sina katataḡa kunausi eketa gudu sina nukovataniya. Gudu bwatasiyai sina vikasaḡasaḡa ebe sina kitasobuwa gudu kuweyaina. ");
INSERT INTO wat_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Eketa koni etanei gudunama kuna teniya eatu sinenei o gabanisima beyabeyasi nenesiyai yaku visime 10 viviginiwisi ana veniwa, kuna totoisiya. ");
INSERT INTO wat_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Dedeni kana koni kana gudu etanei eatu senabimu kasi sinefouwai, nokomai ana nisaiwa eketa yaku visime matatafuna Isineni fasisiyai ana veniwa.” ");
INSERT INTO wat_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Yave yana sifufu i nusaviya Mosese nenei i bwaduwa, “Nofe tova tawaḡau Anoni na natunatuna namoḡa kuna wenevakukusisiya — Nadabi, Abiu, Eneyesa eketa Itama. Tasike fiyao Isineni nenesiyai a vinuwadadanisiya be sina vitovibwanaoseya be sina vikaetoikuwa. ");
INSERT INTO wat_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Nuya tafutafusi kuna suyakafukafusiya tawaḡau Anoni fasinei ebe tovanama ina kotonisiya nenei, kana kita ina kikinomana eketa namoḡa sina vifotuwiya. ");
INSERT INTO wat_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Gikifukifu kana tosanamana matatafusi nuwatasuyasuya a venisiya, namoisima kuna wenisiya. Tovibwanaose kana nuya sina fufunisiya Anoni fasinei keta kuna tenesiniya ebe tanake ina vitovibwanaoseya be ina vikaetoikuwa.” ");
INSERT INTO wat_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Eketa Yave Mosese i iyaviya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ku nowaniya! Yuda fasekwina nenei, Uni natuna atu Une waḡana kana wava Besanenu a gibokiya. ");
INSERT INTO wat_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Eketa Kanunuku nenei a vimaiya keta kana kakavenena be nuwatasuyasuya yota iba matatafusi kasi gikifukifu kana sanamana a veniya. ");
INSERT INTO wat_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ebe kana fata gonudi, siniva eketa bononisi ina ginivavisiya, ");
INSERT INTO wat_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","yota kana fata gabana ina kikawavikuvikukuna keta ina kabubunisiya kafa okanikanibubuna fasisiyai, eketa yota kai ina katasi-vikuvikukuna. Kana kakavenena dewadewana nenei mudadava nofe matatafuna ina savivinisiya. ");
INSERT INTO wat_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Dani fasekwina nenei kana toovivita a gibokiya Ooniyabi Aisamaki natuna. Eketa yota matatafusi toginiginivava kasi kakavenenanama a venisiya ebe iba matatafusi a visimeiwa maise sina fufunisiya. ");
INSERT INTO wat_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Yaku Vada Tafutafuna, dedeni kana koni keta koni kana gudu koni etanei, eketa yota yaku Vada Tafutafuna kana nogonogo matatafuna ");
INSERT INTO wat_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","maise sonama na kana nogonogo, kimayeta gonudi keyakeyana yana kafa misini na kana nogonogo matatafuna, kafa guvimamadi kana didiḡa, ");
INSERT INTO wat_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kafa vikanakooḡa bwanaosena kana didiḡa na kana nogonogo matatafuna, kaboma nakasina kafa katumimi na kaena ");
INSERT INTO wat_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","keta yota nuya na kana kanibubuna — tovibwanaose kasi toviketanuneina Anoni kana nuya keta yota natunatuna namoḡa kasi nuya sina kikotonina be sina vitovibwanaoseya, ");
INSERT INTO wat_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","keta givikanatafu kana bubu eketa iba mamadisi nuwatayuyunisi Totomu Tafutafuna fasinei. Namoḡa na kasi kakavenena iba matatafuna sina fufunisiya naki a visimeiwa maise.” ");
INSERT INTO wat_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Namoḡa si kitanisaiya vitana Mosese yana sobunemi koyei i vimwanenemataiya. Na fasinei Anoni si yokokwafuya keta si iyaviya si bwaduwa, “Kuta kita, guyau tamo kuta fufuniya be ita viketanunita. Noko namoḡanama Mosese Itifitei i kikinomana-nemiita eatu muka tata sanamanei avao i kanasiya.” ");
INSERT INTO wat_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Eketa Anoni i nufata i bwaduwa, “Kakawami, natunatumi namoḡa be vivine kasi taniyanowanowa vigonudisi kwana kikakiya keta kwana nemiisiya nenekuwai.” ");
INSERT INTO wat_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Eketa matatafusi kasi taniyanowanowa taniyasiyai si kikakiya keta si nemiina Anoni nenei. ");
INSERT INTO wat_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Gonudi i visiya keta i vitava-budanisiya eketa bunumakau mwanavauna kana fusafusa maise, kaivakuku i fufuniya. Tovanama namoḡa kaivakukunama si kitiya, si bwauwa si bwaduwa, “Ake, Isineni! Nofe guyaunama o Itifitei i kikinomana-nemiita.” ");
INSERT INTO wat_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Tovanama Anoni i kitiya namoḡa yasi fufuna, didiḡa i didiiya kaivakuku naunei keta i matakawa, “Kumana Yave yana ka tana fufuniya.” ");
INSERT INTO wat_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Eketa tova i katakiya nuwabuniyai, namoḡa yasi yomuyomu si nemiina, vikanakooḡa bwanaosena keta keiya bwanaosena si savivinisiya. Si nuvitoḡa yasi ka be yasi ukowayu nenei, i nuvikwavisiya eketa si fufunakaokaoḡowa. ");
INSERT INTO wat_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Eketa Yave Mosese i iyaviya i bwaduwa, “Ku sobu, uḡuna namoḡasima Itifitei ku nemiisiya, naki si go'yona nenekuwai eketa si dibutoyoikuwa. ");
INSERT INTO wat_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ketanama a visimeisiya sina muniiya, si visaḡaketuketuwiya. Tututausi fasisiyai bunumakau mwanavauna vigonudina si fufuniya, nenei si kodukoduwa keta si vivibwanaoseya. Avage si bwaduwa, ‘Ake, Isineni! Nofe guyaunama o Itifitei i kikinomana-nemiita.’ ");
INSERT INTO wat_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Namoḡa katekatesi i guamoka a sanamaniya. ");
INSERT INTO wat_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Nofe tova ku teneiku be yaku kayokuḡa ina nuyauyauniya nenesiyai be ana nuyaunisiya. Eatu kwaḡa susukwauḡa ana givinakasiya be ina vikunuma nakasina.” ");
INSERT INTO wat_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Eatu Mosese i gwaeiya yana Guyau Yave nenei, “Ae Yave, ya fiwana utubasinei Itifitei ku kikinomana-nemiisiya, na fasinei muka ya kayokuḡa nenei kuna nuyauneisi. ");
INSERT INTO wat_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Taki kuna fufuniya, nao Itifita namoisi sina bwaduwa vitana fiyao Isineni waisi kuta fufuniya be fwayafwaya nofe etanei kuta nuyaune-koḡoisi tovanama ku kikinomana-nemiisiya keta ku nemiisiya koyai. Eketa ya kayokuḡa busubusuwanina nenei kuta onoviya ebe muka kuta nuyauneisi. ");
INSERT INTO wat_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kuta tukuya ka kaetoḡa Ebenaamu, Aisake keta Yakobo nenesiyai tauḡu ka wavai ya bwadudabadaba fifiwanina ku iyavisiya tovanama ku bwaduwa, ‘Susukwau ana givigeyanisiya maise kinavinavi kawasasakaoḡowai yota fwayafwaya nofe matatafuna a bwadudabedabiwa ana venisiya yasi fwayafwayavaḡata.’” ");
INSERT INTO wat_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Noko nenei Yave yana nuwanuwa i kaviniya fiyao Isineni kasi nuyauneina fasinei. ");
INSERT INTO wat_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Eketa Mosese i saḡaviniya gabana nuwesi beyabeyasi nimanei nukusi koyei i sobunemiya. Gabanasima nafafanisi nenesiyai Guyau yana visime i viginiwisiya. ");
INSERT INTO wat_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Guyau tauna gabanasima beyabeyasi i fufunisiya eketa tauna i viginiwisiya. ");
INSERT INTO wat_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tovanama Mosese i nemiya kabaḡa niniunei keta bunumakau mwanavauna si fufunavikuvikukuniya i kitiya yota namoḡa si vaḡavaḡa eketa kayona i nubusubusuwaniya nenei, gabana beyabeyasi i tuḡaisiya fwayafwayai eketa koya uḡunei i biyavayavanisiya. ");
INSERT INTO wat_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Namoḡa bunumakau mwanavauna kaivakukuna si fufuniya, i viya keta kaiyai i guwaniya. Eyo i usuya kausibi maise keta ukowai i viniya eyo fiyao Isineni i visimeisiya keta si yumiya. ");
INSERT INTO wat_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Eketa Mosese Anoni i nutoninuvenuviya i bwaduwa, “Avamasi namoḡa nofe si fufuniya neneweu yo go'yona kunukubana nenei ku kanasuneisi?” ");
INSERT INTO wat_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Eketa Anoni i nufata i bwaduwa, “Aiye, muka kuna kayokuḡa. Namoḡa nofe fufuna goyona kana diḡadiḡaina nenesiyai, naki ku sanamanisiya. ");
INSERT INTO wat_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Na fasinei keta si iyavikuwa si bwaduwa, ‘Guyau tamo kuta fufuniya be ita viketanunikiya. Noko namoḡanama Mosese Itifitei i kikinomana-nemiikiya, eatu muka kata sanamanei avao i kanasiya?’ ");
INSERT INTO wat_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Na fasinei a iyavisiya keta aviyaonana na kasi kanibubuna gonudi si kikakiya. Tovanama si venikuwa, naki a teweye-kaoḡowiya kaiyai eketa nofe bunumakau mwanavauna kaivakukuna i kikinomana.” ");
INSERT INTO wat_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Atu Mosese i kitiya Anoni namoḡa i gionovisiya eketa si akaokaoḡowa, keta nifanifaisi matasiyai o kafa sawaviniḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Eketa Mosese i misiniya kabaḡa kana ketakawanai keta i bwauwa, “Kwaḡa aitevana Yave nenei ku kodukoduwa, ku nemai nenekuwai!” Eketa Nebi fasekwina nenei matatafusi namoḡa si nemiya keta si yokofifiniya. ");
INSERT INTO wat_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Keta i iyavisiya i bwaduwa, “Isineni yami Guyau Yave nofemaise i visimeya, ‘Matatafumi na yami feto, kabaḡa kana matatafu bwatanei tu bwatanei, kwana kanasuniya keta yami sabu, unaunami keta unafafanimi kaivakuku nenei si kodukoduwa, kwana nuvimateya.’” ");
INSERT INTO wat_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Nebi namoisi Mosese yana visime si muniiya keta kuyadayadanama nenei namoḡa 3,000 maise si nuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Eketa Mosese i iyavisiya i bwaduwa, “Kwami Yave yana ketaketa kwa muniiya keta dawaniniina kwa fufuniya tovanama natunatumi keta unaunami kwa nuvimatisiya. Kimoki Yave naki i sawanuwagabubuwimiya keta i tenesinimiya be kwana vitovibwanaoseya fasinei.” ");
INSERT INTO wat_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kuyadayada kana vinuwa nenei Mosese namoḡa i iyavisiya i bwaduwa, “Go'yona goyomataina naki kwa fufuniya. Nofe tova ana makavinikuwa ana vaneya koyai Yave nenei ebe yami go'yona kana kioḡona fasinei, taki ita vinowaniya o muka.” ");
INSERT INTO wat_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Eketa Mosese i savaviniya Yave nenei keta i nusifufuwiya i bwaduwa, “Eiyoi, namoḡa nofe naki go'yona goyomataina si fufuniya. Tututausi gonudi nenei kaivakuku si fufuniya eketa nenei si kodukoduwa. ");
INSERT INTO wat_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Eatu naki yasi go'yona kuta vinuwateweiya. Eatu taki muka, nao nufunufunama namai ya namonamoḡa kasi wava ku viginiwisiya, nenei kaku wava ku viyaunei.” ");
INSERT INTO wat_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Eatu Yave Mosese i iyaviya i bwaduwa, “Aitevana nenekuwai i go'yona, namoinama kana wava ana viyauniya yaku nufunufu nenei. ");
INSERT INTO wat_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Nofe tova ku nai be namoḡa ku viketanuneisi kabainama a iyaviwa nenei keta kaku kaetoḡa abamei ina viketanuniwa. Eatu tovanama vimatadawana kana tova ina nemiya nenei, yasi go'yona fasinei ana vimatadawanisiya.” ");
INSERT INTO wat_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Eketa kaivakukunama Anoni i fufuniya be nenei si kodukoduwa fasinei, Yave i vimatadawanisiya visafwavinaḡa goyona nenei. ");
INSERT INTO wat_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yave Mosese i iyaviya i bwaduwa, “Gabana nuwesi beyabeyasi nauna ku biyavayavanisiya maise, kuna kawisiya eketa yaku bwadu ana viginiwa-savavinisiya nauna maise. ");
INSERT INTO wat_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kuna gidewadewa kumana nuwabuni fasinei keta nuwabuniyai tauḡu kuna vanenemiiwa nenekuwai koya Sainai etanei.” ");
INSERT INTO wat_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Eketa Mosese gabana beyabeyasi nuwesi i kawisiya nauna maise eketa nuwabunimokeyai i nufewisiya keta i vaneisiya koya Sainai etanei, Yave i visimeiya maise. ");
INSERT INTO wat_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yave busibusi sinenei i sobunemiya niniunei i misiniya eketa tauna kana wava Yave i bwauwe-kikinomaniya. ");
INSERT INTO wat_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Keta Yave Mosese kunauna i niuniya atu i bwaukikinomana i bwaduwa, “Iyau Yave Guyau! Iyau sineganigani keta omukumukutana kana Guyau. Yaku nuwagoyo muka ita vevenudibwana. Yaku nuwagabubu fakwafakwa-vaḡasina o nakatamokena namoḡa fasisiyai keta yota avana ana bwaduwiya maise tovatova ana savivinisiya. ");
INSERT INTO wat_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Namoḡa susukwasi si nenemiya nenesiyai, yaku nuwagabubu fakwafakwa-vaḡasina ana gitoniya. Yasi fufunagoyo, yasi adibutoyotoyoḡa keta yasi go'yona ana vinuwateweisiya. Eatu aviyaonana sina fufunagoyowikuwa, nao yaku vimatadawana ina niya namoisima yota natunatusi be waḡawaḡasi eketa iteitesi nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Muka mwanenena Mosese kaetutuna i kiguniya keta i bitanakafufuwiya fwayafwayai eketa i kodukoduwa Yave nenei, ");
INSERT INTO wat_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","eatu i bwaduwa, “Tuveka yo, taki ku sebobowikuwa maise, a kawanunukuwiwa be kwaḡa nukusi tata fakwa. Namoḡa naki ku sanamaniya katekatesi guasi eatu yama fufunagoyo keta yama go'yona kuna vinuwateweisiya, be kuna katuvikiya keta kuna vitoniwagikiya.” ");
INSERT INTO wat_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Eketa Yave i nufata i bwaduwa, “Ku nowaniya! Dedeni a fufufuniya fiyao Isineni nukusi. Matatafumi matamiyai kafa nuwatabau ana savivinisiya, muka tamo aitevana ita kitai maise fwayafwaya kana matatafu nenei o tamo mani kunuma nenei ita kitanuvanuvai maise. Ibasima nofe fasimiyai a savisavivinisiya fasinei, matatafusi mani namoḡa sinemiyai sina kitiya keta sina matuta.” ");
INSERT INTO wat_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosese nokomai Yave nukusi si fakwa kuyadayada 40 keta nuwabuna 40. Muka tamo maneka ita kaniya o ukowa ita yumiya. Eketa gabana beyabeyasi nenesiyai visime 10 bwadubwadusima dedeni fasinei, Yave i viginiwisiya. ");
INSERT INTO wat_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mosese koya Sainai nenei i sobunemiya, dedeni kana gabana nuwesi beyabeyasi nukusi nimanei. Koyai Yave nukusi si nusifufuwa eketa na fasinei tovanama i sobunemiya, tafakaina i nukawanamanamaniya eatu tauna o muka ita sanamanei. ");
INSERT INTO wat_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Tovanama Anoni fiyao Isineni matatafusi nukusi si kitiya Mosese tafakaina i nunukawanamanamaniya, si matuta keta muka sita nemai niniunei. ");
INSERT INTO wat_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mosese i bwauwisiya Anoni keta namoḡa kasi toviketanuneina matatafusi nukusi si makavinisiya nenei eketa i nusifufuwisiya. ");
INSERT INTO wat_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Eyo fiyao Isineni namoḡa matatafusi si nemiya Mosese niniunei eketa Yave yana visime matatafuna koya Sainai nenei i iyaviya maise, namoḡa i nusifufuwisiya. ");
INSERT INTO wat_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Tovanama i nusifufukooḡa nenesiyai, tafaki kana dawanafafana nenei tafakaina i sowiya. ");
INSERT INTO wat_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tova matatafuna tovanama Mosese ina kanakanasuna Vikaninisaḡa kana Vada nenei be Yave nukusi sina nunusifufuwa, tafaki kana dawanafafana i kakikakiya. Eketa tovanama ina kikinomana, fiyao Isineni i iyaiyavisiya Yave yana visime. ");
INSERT INTO wat_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Fiyao Isineni si kitakitiya tafakaina kana nukawanamanamana. Muniyai yo tafaki kana dawanafafana nenei, tafakaina i tenetenefota-savaviniya kana nivaniva yota tovanama ina makaviniya Yave nukusi sina nusifufuwa. ");
INSERT INTO wat_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Keta Yave Mosese i nusifufuwiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Manamana kiouna kuyadayada kana kafa viuḡu nenei, yaku Vada Tafutafuna kuna vimisiniiya. ");
INSERT INTO wat_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Dedeni kana koni namai visime 10 sinenei kuna tenekanasuniya eyo kafa dawanafafana kana nuya naunei kuna teniya. ");
INSERT INTO wat_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Sonama kuna kanasuniya keta kana nogonogo etanei kuna dawana. Yota kimayeta yana kafa misini kuna nemiiya keta kimayeta kuna tenisiya etanei. ");
INSERT INTO wat_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Eyo kafa guvimamadi kana didiḡa vigonudina, kuna teniya dedeni kana koni naunei eketa nuya kuna nuvitanuniya Vada kana kawai. ");
INSERT INTO wat_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kafa vikanakooḡa bwanaosena kana didiḡa kuna teniya Vada kana kawa naunei. ");
INSERT INTO wat_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kaboma nakasina kafa katumimi kuna teniya Vada keta kafa vikanakooḡa bwanaosena kana didiḡa kasi sinefouwai, eketa ukowa kuna vininiwatotoiya. ");
INSERT INTO wat_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Vada keta kafa vikanakooḡa bwanaosena kana didiḡa kuna sifafifiniya keta nuya kuna nukanekaneneiya wasiketa kana kawai. ");
INSERT INTO wat_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Eyo muniyai givikanatafu kana bubu kuna viya keta Vada etana be iba matatafuna sinenei kuna vitowisiya. Kuna tenesiniya fasikuwai ebe ina vitafuwa. ");
INSERT INTO wat_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Yota bubu nenei kafa vikanakooḡa bwanaosena kana didiḡa keta kana nogonogo nukusi kuna vitowisiya. Kuna tenesiniya fasikuwai ebe ina vitafuwa venemokena. ");
INSERT INTO wat_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kaboma nakasina kafa katumimi na kana kafa misini nukusi, bubu nenei kuna vitowisiya keta kuna tenesinisiya. ");
INSERT INTO wat_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Anoni na natunatuna kuna kanasunisiya Vada Tafutafuna kawanei keta ukowa nenei kuna vitowisiya. ");
INSERT INTO wat_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Nuya tafutafusi nenesiyai Anoni kuna okanikanibubuniya keta bubu nenei kuna vitowiya keta kuna tenesiniya ebe ina vitovibwanaoseya be ina vikaetoikuwa. ");
INSERT INTO wat_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Yota natunatuna kuna nemiisiya keta kasi nuya kuna vikotonisiya. ");
INSERT INTO wat_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Bubu nenei amasi ku vitowiya maise, tasike kuna vitowisiya ebe sina vitovibwanaoseya be sina vikaetoikuwa. Vitowanama nenei tasike be susukwasi si nenemiya, tova matatafuna sina vivitovibwanaoseya.” ");
INSERT INTO wat_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Iba matatafuna Mosese i fufuniya, naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Eketa yamayamana kana kafa viuḡu manamana kana vinuwa nenei keta yamayamananama kana kuyadayada kafa viuḡu nenei, Vada Tafutafuna si vimisiniiya. ");
INSERT INTO wat_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosese koḡona yasi kafa misini i didiisiya muniyai yo koḡona i vimisiniina. Eyo dawanabanebaneina keta ketoviyewa i dawana. ");
INSERT INTO wat_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Muniyai kafa dawanafafana nenei, Vada seḡaseḡanaḡa nenei i teweiya. Eyo kafa dawanafafana yomuyomu kwafinisiyai si fufunisiya nenei, etanei i teweisiya naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Eketa Mosese gabanasima nuwesi beyabeyasi i visiya keta dedeni kana koni sinenei i totoisiya. Eyo dedeni kana koni kafakainei kana nowanowa nenesiyai, kewa i duisiya. Eketa koni kana gudu nenei i vitanaguduya. ");
INSERT INTO wat_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Muninei dedeni kana koni i kanasuniya Vada Tafutafuna sinenei keta kafa dawanafafana kana nuya i nuvitanuniya eketa dedeni kana koni i tenefotiya, naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Yota sonama i una-kanasuniya Vada Tafutafuna sinenei keta bomatu kuweyaina i teniya, Totomu Tafutafumokena kana kafa dawanafafana kana nuya kwaunei. ");
INSERT INTO wat_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Eketa manekasima i gidewidewisiya kana bobotai Yave naunei sonama etanei i tenisiya, naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Kimayeta yana kafa misini i kanasuniya keta Totomu Tafutafuna nanakoya kuweyaina i vimisiniiya keta sonama i visaiya. ");
INSERT INTO wat_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Eyo Yave matanei kimayeta i guwanisiya, naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Eketa kafa guvimamadi kana didiḡa vigonudina, dawanafafana naunei i teniya Totomu Tafutafuna sinenei, ");
INSERT INTO wat_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","eyo iba mamadisi i guwanisiya, naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Eketa dawanafafana i nuvikaneneiya Vada kana kawa nenei. ");
INSERT INTO wat_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Kafa vikanakooḡa bwanaosena kana didiḡa i teniya Vada kawanei ebe etanei yawane yomuyomu be kausibi ina vibwanaoseiisiya, naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Vada keta didiḡa kasi kawasasai, kaboma nakasina i vimisiniiya eketa ukowa i vininiwiya kafa katumimi. ");
INSERT INTO wat_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Eketa nokomai Mosese keta Anoni na natunatuna namoḡa nimasi be kaesi kana kafa kikigona. ");
INSERT INTO wat_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tovasima yasi kanasuna Vada sinenei o yasi nai kafa vikanakooḡa bwanaosena kana didiḡa nenei, tututausi sina gonisiya, naki maisemoka Yave i visimeiya. ");
INSERT INTO wat_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Vada keta kafa vikanakooḡa bwanaosena kana didiḡa i sifafifiniya keta nuya ina nukanekaneneiya wasiketa kana kawai. Eketa Mosese bunanige matatafuna i nusafuya. ");
INSERT INTO wat_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Eyo muniyai busibusi Vada Tafutafuna i sowiya keta Yave yana mayesina matakikikwanena i vimaiya. ");
INSERT INTO wat_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Busibusi i nuvitoiya Vada etanei keta Yave yana mayesina matakikikwanena i vimaiya eketa Mosese muka kana fata be ina kanasuna Vada sinenei. ");
INSERT INTO wat_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tova matatafuna tovanama busibusi Vada ina teweiya atu ina kanakasiya, nao fiyao Isineni si misimisiniya keta si niniya tamo menana nenei. ");
INSERT INTO wat_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Eatu taki busibusi muka ita kakanakasiya, nao yota muka sita ninai kana nivaniva ina kanakasiya. ");
INSERT INTO wat_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tova matatafuna Isineni yasi toḡavenudadananama kana kawasasa nenei, kuyadayadai Vada etanei Yave yana busibusi si kitakitiya. Eatu nuwabuna nenei, nao kai atai i nununuḡa busibusi sinenei Isineni namoisi matatafusi si kitakitiya. ");
INSERT INTO wat_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Tova tamokaḡa Yave Yona Amitai natuna i iyaviya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Ku misini ku nai Ninive menana nakasina na kana wava nenei ebe kuna matakawisiya kuna bwaduwa, ‘Kwa go'yona nakatamokena,’ uḡuna namoḡasima yasi fufunagoyo o kana sanamana nenekuwai.” ");
INSERT INTO wat_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Atu Yona i misiniya keta Yave i dibwaniya, muka ita nai Ninive. I niya Yofa nokomai waka i nisaiya i niniya Tasisi. Waka i fatiya keta i toḡa ebe Yave ina dibwaniya ina niya Tasisi kedawanauwai. ");
INSERT INTO wat_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Eatu Yave fonimana fifiwanina i gikikinomaniya gibowai, keta wanifeto i nakatamoka waka tova kabesona be ina nuyavayavaniya. ");
INSERT INTO wat_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Toviwakasefusefu si matuta keta tamokatamokaḡa yasi guyau nenesiyai si bwedi-kawavitata kasi ovivita fasinei. Eyo waka kana nogonogo si tewesobusobuwina be waka ina kanakasiya. Atu noko tovanama nenei Yona waniya i sobuwa waka sinenei i kenofana keta i kenonuwataunuwa. ");
INSERT INTO wat_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Tonimunikuta nokomai i nisaiya keta i iyaviya i bwaduwa, “Ava uḡuna ku banubanukaokaoḡo! Ku misini be ya guyau nenei ku kawanunuku kata ovivita fasinei. Kamo ina kitasineganiganiita keta yawasita ina ofafafiya.” ");
INSERT INTO wat_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Toviwakasefusefu tututausi si vikatonitoniya si bwaduwa, “Aitevana tana vinoiya? Yamasi daisi nenei ta vikaneeneiya be ta kitai aitevana o dauna nofe nenei i teneita.” Tovanama daisi nenei si vikaneeneiya, Yona kana wava i kikinomana. ");
INSERT INTO wat_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Eketa si iyaviya si bwaduwa, “Yo ku iyaveiki. Dauna nofe fasinei aitevana tana vinoiya? Avamasi ya mudadava? Kwaḡa avi fafani? Kwaḡa avi kunuma?” ");
INSERT INTO wat_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yona i iyavisiya i bwaduwa, “Iyau tene Ibeniu. Yave nenei a kodukoduwa. Tanake abama kana Guyau, fwayafwaya keta gibo i fufunisiya.” ");
INSERT INTO wat_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yona i iyavisiya vitana tanake o Yave nenei i dibwadibwana. Toviwakasefusefu si matutamoka keta si iyaviya si bwaduwa, “Ava o nofe ku fufuniya?” ");
INSERT INTO wat_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Wanifeto i nakatadewadewa keta toviwakasefusefu si vikokoniya si bwaduwa, “Avamasi kata fufuniya neneweu be wanifeto ita katanai?” ");
INSERT INTO wat_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yona i iyavisiya i bwaduwa, “Kwa uniku be kwa tewesobuweiku gibowai ebe ina numanowa. A sanamaniya iyau yaku goyonai wanifeto nofe i givikavinita.” ");
INSERT INTO wat_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Eatu toviwakasefusefu si oimanimaniniya be waka sita sobuwiya kafakainei, atu muka kasi fata uḡuna wanifeto i nakatamataina. ");
INSERT INTO wat_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Eketa Yave nenei si bwedi-kawavitata si bwaduwa, “Yave yo, muka kuta vimatadawaneiki mate nenei namoḡa nofe yawasina kana kidaba fasinei. Muka kuta vinoiki namoḡakaoḡona kana nuvimate fasinei. Yave yo, iba matatafuna nofe o tauḡu ya nuwanuwai ku gikikinomaniya.” ");
INSERT INTO wat_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Eyo Yona si uniya keta si tewesobuwiya gibowai. Muka mwanenena gibo i numanowa. ");
INSERT INTO wat_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Nofe nenei toviwakasefusefu Yave si matutiya venemokena keta si vibwanaoseya nenei keta yota si bwadudabadaba vitana fasinei sina bunanigeya. ");
INSERT INTO wat_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yave yana visime nenei, iyana nakasina Yona i tononiya eketa iyana manawanei Yona i fakwafakwa kuyadayada tonusi keta nuwabuna tonusi. ");
INSERT INTO wat_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Iyana manawanei Yona i kawanunukuwa yana Guyau Yave nenei i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Yave yo, kaku dauna nakasina sinenei a bwauwa neneweu eketa ku vinowanikuwa. Matematesi yasi kabaḡa sinenemokenei ovivita fasinei a bwediya keta ku nowanikuwa. ");
INSERT INTO wat_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Katudomu nenei ku tewesobuwikuwa eketa a gavivina ogodibuwai. Nokomai gibo i toḡafifinikuwa keta ka yoyo kitagoyosi matatafusi si nutautaunikuwa. ");
INSERT INTO wat_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Eyo a bwaduwa, ‘Kwaḡa ku kitateweikuwa, eatu ya Numa Kodukodu tafutafuna ana kita-savaviniya.’ ");
INSERT INTO wat_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Gibo i nutautaunikuwa keta i visubanikuwa, ogodibu i tewefifinikuwa, keta debabouku dodomu nenei i sumiya. ");
INSERT INTO wat_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Koya kikwanakwanamisi venemokena nenesiyai a kenogamomona, fwayafwaya kasi kawa dawadawanafota-vaḡasisi nenesiyai. Atu kwaḡa o Yave yaku Guyau, ogodibu sinenei ku sinanakasikuwa na yawasiku. ");
INSERT INTO wat_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Tovanama a kamukonikuwa yawasiku i kakakaviya, Yave a tukuwa. A kawanunukuwa keta ya Numa Kodukodu tafutafuna nenei ku nowanikuwa. ");
INSERT INTO wat_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Aviyaonana kifukifufuna nenesiyai si kodukoduwa, kasi nuwagabubu fakwafakwa-vaḡasina neneweu si vikwauteweiya. ");
INSERT INTO wat_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Atu iyau o ana osedavadava yota ana vibwanaoseya neneweu. Eketa yaku bwadudabadaba ana fufuniya neneweu. Gifafafana o kwaḡa Yaveḡa neneweu!” ");
INSERT INTO wat_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Eketa Yave iyana i visimeiya keta Yona i kanasiwaiya numagamai. ");
INSERT INTO wat_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Yave yota Yona i iyave-savaviniya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Ku misini ku nai Ninive menana nakasina na kana wava nenei ebe yaku matakawa a veniwa ku numamanei namoḡa nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yona Yave fonana i muniiya keta i niya Ninive. Menananama o nakatamokena eketa taki tamo aitevana menaninama ina vaonosiya, nao kuyadayada tonusi muniyai yo ina nusafuya. ");
INSERT INTO wat_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yona i kanasuna menana nakasina sinenei keta na kuyadayadanama i vavaonota nenei atu i numamana i bwaduwa, “Kuyadayada 40 muninei Guyau Ninive ina nuyakweyakweniya.” ");
INSERT INTO wat_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninive namoisi Guyau fonana si vitumaḡaniya. Na fasinei si vinuwadadana keta matatafusi si vikokowana, na kasi wava keta muka na kasi wava. Keta yota nuya yomuyomu utuutusiyai kikifufunisi si kotonisiya be ina visawavenena vitana yasi fufunagoyo nenesiyai naki si ugevinisiya. ");
INSERT INTO wat_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Tovanama Ninive tufomu i biganowana, kana kwabudoga i teweiya keta tufomu kanibubuna i visaniniisiya atu nuya yomuyomu utuutusiyai kikifufunisi i kotoniya eketa kausibiyai i nuvitoiya. ");
INSERT INTO wat_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Yana visime si otamatamaniya Ninive namoḡa kana matatafu nenesiyai. I bwaduwa, “Visime nofe o iyau yami tufomu keta yaku tovisime nukusi nenekiyai. Namoḡa matatafumi eketa yami yomuyomu nakanakasisi be musumususi nukusi muka tamo aviyavana kwana kaniya o kwana yumiya. ");
INSERT INTO wat_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Atu namoḡa matatafumi nuya yomuyomu utuutusiyai kikifufunisi kwana kikotonina. Naki maise yota nuyasima yomuyomu matatafusi etasiyai kwana kitewekabwanina. Matatafumi kwana kawanunuku-manimaniniya Guyau nenei eketa kwana ugevinimiya yami fufunagoyo be yami givikuvakuvavana namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Muka tata sanamanei kamo Guyau yana nuwanuwa ina kaviniya keta yana kayokuḡa ina kakaviya be muka tana mate.” ");
INSERT INTO wat_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Tovanama Guyau i kitisiya ibasima si fufunisiya keta yasi fufunagoyo nenesiyai si ugevinisiya, yana nuwanuwa i kaviniya eketa muka nuyakweyakwena ita nemiyei nenesiyai avana i bwaduwiya ita fufuniya maise. ");
INSERT INTO wat_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Atu Yona o nuwatana i dauna nakasina yota i kayokuḡa nofe ibanama fasinei. ");
INSERT INTO wat_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Eketa i kawanunukuwa i bwaduwa, “Yave yo, tovanama a fakwafakwa yaku fafaniyai a bwaduwa vitana nofemaise ina kikinomana, na fasinei a anuvanuva be ata dibwana ata niya Tasisi. Uḡuna a sanamaniya kwaḡa o Guyau toomukumukutana keta tosineganigani, ya nuwagoyo muka ita vevenudibwana eatu ya nuwagabubu fakwafakwa-vaḡasina nenei namoḡa muka kuna vimatadawaneisi. ");
INSERT INTO wat_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Nofe yaku uḡunanama fasinei muka nuwanuwaku ana fakwa. Yave yo, naki mate dewadewamokena nenekuwai yo ana fakwa na yawasiku. Na fasinei yawasiku o ku viteweyei.” ");
INSERT INTO wat_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Atu Yave i nufata i bwaduwa, “Ava uḡuna yo nofe ibanama fasinei kuna nuwagoyo!” ");
INSERT INTO wat_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yona menana nakasinei i kikinomana keta i niya gagasa kuweyaina kweta i yoniya tauna fasinei eketa sifunei i nuvitoiya, eatu i kitakitanufota be ina kitiya avamasi ina kikinomana Ninive nenei. ");
INSERT INTO wat_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Eyo Yave Guyau kisisiku na dadana nokomai i givitafwiya. I tafwa i vaneya keta kikwakunei Yona i vikikwakuya ebe muka inaina nakasina ina nutoḡoniya. Eketa Yona i sebobowa nakasina kisisikunama fasinei. ");
INSERT INTO wat_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Atu kuyadayada venuwanei nuwabunimokeyai, Guyau mwatamwata i visimeiya keta kisisikunama tofwana i kutiya eketa i wenonuya. ");
INSERT INTO wat_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Tovanama vanavana i vaneya, Guyau fonimana inainana gagasei i gikikinomaniya keta i siveya. Vanavana Yona debabouna i guwaniya eketa kabegomokena ita sasana. I yawikosiya nuwanuwana be ita mateya eketa i bwaduwa, “Naki mate dewadewamokena nenekuwai yo ana fakwa na yawasiku.” ");
INSERT INTO wat_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Atu Guyau Yona i iyaviya i bwaduwa, “O namaise kwaḡa ka nufota kisisikunama yana wenono fasinei kuna nuwagoyo!” I nufata i bwaduwa, “Ika, a kayokuḡamataiya kaku nufota be ana mateya!” ");
INSERT INTO wat_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Atu Yave i bwaduwa, “I tafwa keta kuyadayada kana vinuwa nenei i mateya. Atu kwaḡa muka kuta kitavikaviniya o kuta givitafwai ebe yo kuna sineganiganiyei. ");
INSERT INTO wat_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Atu Ninive menana nakasina nenei namoḡa kasi yagwana 120,000 na kana tufo aviyaonana nokomai si fakwafakwa muka fufuna dewadewana keta goyona sita kitanisaḡai, maise yota yomuyomu yagwanisi. Na fasinei kaku nufota be menananama nakatamokena ana sineganiganiiya!” ");
INSERT INTO wat_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nofe biga dewadewana kana kafa viuḡu Guyau natuna fasinei, tanake Yeisu Togifafafana Gigibokeinana. ");
INSERT INTO wat_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tova manatuwaina Guyau yana tomatakawa Aiseya i viginiwiya maise, “Guyau i bwaduwa, ‘Nauna yaku tomatakawa ana visimeiya kunauḡu be ya ke'ta ina menaniya.’ ");
INSERT INTO wat_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tanake kayona i bwaubwauwa wanakikaoḡowai i bwadubwaduwa, ‘Ke'ta kwa menaniya Tuveka yana nemi fasinei, yana ke'ta kwa nudawaniniyei.’” ");
INSERT INTO wat_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eketa nofe tomatakawanama Yoni i nemiya namoḡa i givibutibutisiya wanakikaoḡowai yota Guyau sifufuna namoḡa nenesiyai i numamaniya, “Kwa ugevinaimi yami go'yona nenesiyai be Guyau ina vinuwateweimiya. Ana givibutibutimiya be ita visawavenena, kwami naki i kavinimiya yami go'yona nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eketa namoḡa matatafusi si fakwafakwa Yudiya kawakawana sinenei be Yenusanema menana nakasina sinenei, si kikinomana Yoni sina vaneneiya. Tovanama yasi go'yona si fonayauwa, Yonidani ukowai i givibutibutisiya. ");
INSERT INTO wat_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoni kana nuya kameni utuutuna i kotoniya, yota kana wakina niniwasininei kikimetanina o kikifufunina yomuyomu kwafinina nenei. Kana kabwaga o gonofa keta makawa. ");
INSERT INTO wat_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Namoḡa i iyavisiya i bwaduwa, “Munikuwai namoḡa tamokaḡa i nenemiya o fifiwanamokena yo iyau. Iyau muka kaku nufota be ana okodu kana kaevatakutakuna kasi unava ana yausi. ");
INSERT INTO wat_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A gigivibutibutimiya ukowa nenei atu tanake ina givibutibutimiya Kanunu Tafutafuna nenei.” ");
INSERT INTO wat_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Noko tovanama nenei Ganini kawakawana sinenei menana Nasaneti nenei Yeisu i misiniya eketa i nemiya Yoni nenei, eketa Yoni Yeisu i givibutabutiya Yonidani ukowai. ");
INSERT INTO wat_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tovanama Yeisu i kakanakasiya ukowa sinenei, muka mwanenena i kitiya abama i kawiya eketa Guyau Kanununa vitana bunebune maise i sobunemiya nenei. ");
INSERT INTO wat_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eketa kayokayo abamei i nusifufuwa i bwaduwa, “Kwaḡa o Iyau natukatekateku. Yaku sebobo nakatamokena neneweu.” ");
INSERT INTO wat_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Muka mwanenena Guyau Kanununa Yeisu i noḡokawawiya wanakikaoḡowai. ");
INSERT INTO wat_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Eketa kuyadayada 40 nokomai i fakwa eatu Seitani i anuvanuviya Yeisu be ita go'yona. Yomuyomu-wanawanaki nukusi si fakwa kabaḡanama nenei atu Guyau kana kaetoḡa abamei si kitavikaviniya. ");
INSERT INTO wat_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tufomu Enoda Anitifasi deniyai Yoni i tenefotiya muninei, Yeisu i niya kawakawana Ganini nenei Guyau yana biga dewadewana i yaugeyaniya namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I bwaduwa, “Nofe tova Guyau yana kawasasa vivinuwadadaneinana i nemiya! Guyau yana kafa visime i niketamwakufwa. Yami go'yona nenesiyai kwa ugevinaimi be biga dewadewana kwa vitumaḡanei.” ");
INSERT INTO wat_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Eketa kuyadayada tamokaḡa Yeisu Ganini tobu nenei kwadewai i fanafana atu tofanufa nasi nuwa i kitisiya, Saimoni keta taina Anideneya, tobu nenei kanevatu si neneneiya. ");
INSERT INTO wat_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eketa i iyavisiya i bwaduwa, “Kwa muniyeiku be ana visawavenimiya namoḡa kasi tofanufa.” ");
INSERT INTO wat_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Muka mwanenena yasi kanevatu si dawana atu si muniiya. ");
INSERT INTO wat_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Simokaḡamoka i fana i niya, Sebedi natunatuna Yemesa keta Yoni i kitisiya yasi waka sinenei yasi kanevatu si nunubwatabwatata. ");
INSERT INTO wat_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tovanama i wenisiya kana muniyeina fasinei, amasi Sebedi yana tobunanige na fatasi nukusi waka sinenei si venumakanovisiya atu si muniiya. ");
INSERT INTO wat_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeisu kana tomuniyeina nukusi si niya Kafenaumi menana nakasinei. Tovanama kuyadayada Sabati nenei i kanasuna numa kafa yokoyoko sinenei, eketa i vibutuwa Guyau fonana i visawavenena namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","I vivisawavenena naki maisemoka tamo aitevana fakinina muka maise Mosese yana visime kana tovisawavenena, na nenei keta namoḡa si mayaḡa yana visawavenena nenei. ");
INSERT INTO wat_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yeisu i vivisawavenena numa kafa yokoyoko sinenei eatu tovanama nenei namoḡa tamokaḡa kanunu goyona i nuwafiya, i fina i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Aviyavana tamo ya nuwanuwa kima fasikiyai Yeisu tene Nasaneti? Omasi ku nemiya kima kuna nuyaunikiya? Iyau a sanamaniya kwaḡa aitevana, kwaḡa o Guyau yana Namoḡa Tafutafuu!” ");
INSERT INTO wat_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeisu i kanamaifata atu i bwaduwa, “I kanoveu! Namoḡa ku gionovei.” ");
INSERT INTO wat_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eketa kanunu goyona i tatakwayana, namoḡa i sinanewanewiya keta i gionoviya. ");
INSERT INTO wat_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Namoḡa matatafusi si mayaḡa venemokena eketa si vikanunutoniya si bwaduwa, “Ava o nofe! Nofe visawavenena kiouna yota fakinina. Tumadama yo kanunu goyosi i vivisimeisiya eketa fonana si munimuniiya!” ");
INSERT INTO wat_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kakimokimokima tu Yeisu bigana i geyana eketa i venutamatamana Ganini kawakawana kana matatafu i gikafufuya. ");
INSERT INTO wat_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tovanama numa kafa yokoyoko si teweiya, Yemesa keta Yoni nukusi si niya Saimoni na taina Anideneya yasi numai. ");
INSERT INTO wat_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoni nawana gumayogu si vinafeyana keta kiviyai si matamataveya eketa fasisiyai muka mwanenena atu si iyavefotefotiya. ");
INSERT INTO wat_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Eketa i kanasuna i niya nenesiyai, nimasiyai i ova eketa i sinatowamisiniisiya. Na tovanama nenei nafeyana tofwasiyai i kaniniya eketa gumayogusima kabwaga si suniniya Yeisu kana tomuniyeina nukusi fasisiyai. ");
INSERT INTO wat_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eketa kana navinavi vanavanasonu muninei, namoḡa yasi tovisafwavinaḡa keta yota tasike aviyaonana kanunu goyosi si nuwafisiya, si nemiina Yeisu nenei. ");
INSERT INTO wat_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Menana noko kana matatafu si yokowa numanama wasiketanei. ");
INSERT INTO wat_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eketa sabu kasi visafwavinaḡa tunisitunisi nenesiyai i givibwina keta yota namoḡa yagwanisi sininisiyai kanunu goyosi i nukakisiya. Atu kanunu goyosi o sanasanamanisi tanake Guyau Natuna na fasinei muka ita sawateweyeisi be sina nusifufu. ");
INSERT INTO wat_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tovawedanai Yeisu i towamisiniya, numa i teweiya keta i niya kabaḡa nunukamumunina nenei eketa nokomai i kawakawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Atu Saimoni unaunana nukusi si niya si nunuwasiya. ");
INSERT INTO wat_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tovanama si nisaiya, si iyaviya si bwaduwa, “Namoḡa matatafusi si nunuwasiwa.” ");
INSERT INTO wat_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","I bwaduviyewa i bwaduwa, “Ta nai namai tunisi menana ketamwakufwai ebe Guyau fonana yota a yaugeyaniya nenesiyai. Nofe yaku uḡunama fasinei a nemiya.” ");
INSERT INTO wat_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nofe fasinei, Ganini kana matatafu i fanakwaniuwiya eketa Guyau fonana i yaugeyaniya yasi numa kafa yokoyoko sinesiyai yota namoḡa yagwanisi sininisiyai kanunu goyosi i nukakisiya. ");
INSERT INTO wat_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tova tamokaḡa namoḡa kwafinina gosagosawina i nemiya Yeisu nenei i fekuwa kaetutunei eketa i kamanemaniya i bwaduwa, “Ae, taki nuwanuwau maise, kuta givibwinikuwa be ata eyaeya.” ");
INSERT INTO wat_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeisu na yana sineganigani nimana i tuniya keta namoḡa tofwanei i teniya eketa i bwaduwa, “Ika, Iyau nuwanuwaku. Ku eyaeya!” ");
INSERT INTO wat_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Eketa kakimokimokima tu kwafinina kana gosawa i kakaviya eketa i eyaeya-savaviniya. ");
INSERT INTO wat_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Eketa Yeisu bwadu fifiwanina nenei i iyaviya i bwaduwa, “Nofe tova ku nai eatu muka tamo aitevana kuna iyavei nofe ibanama fasinei. Dawaniniina kuna niya eketa tauḡu kuna visawaveniwa tovibwanaose nenei. Eketa ku bwina fasinei Mosese yana visime maise, vibwanaose kana ketaketai kuna saviviniya ebe ita vikafakita sabu nenesiyai vitana naki ku eyaeya.” ");
INSERT INTO wat_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Atu Yeisu yana bwadu muka ita muniyei keta i kikinomana namoḡa nenesiyai i eyowiya aviyavana i kikinomana tauna nenei fasinei. Yeisu na yana uḡunama fasinei muka kana nufota be namoḡa matasiyai ina kanasuna menana nakasina sinenei, atu i fakwa kabaḡa nunukamumunisi nenesiyai. Eatu menana matatafuna nenesiyai namoḡa si nemiya nenei. ");
INSERT INTO wat_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kuyadayada muka yagwanina muninei Yeisu kana tomuniyeina nukusi si makavinisiya Kafenaumi. Namoḡa si biganowana vitana i nemiya tauna yana menanai, ");
INSERT INTO wat_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","eketa yagwanisi si yokowa nokomai. Na fasinei muka tamo kawasasa numa sinenei o ketakawana kafakainei. Eatu Yeisu Guyau fonana i numamaniya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Namoḡa nasi nufunina, namoḡa tanaina matematena na sitana si uniya keta si nemiya nenei. ");
INSERT INTO wat_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yoko nakasina si tenefotifotisiya eketa muka kasi fata namoḡanama sina nemiyei Yeisu nenei. Na fasinei menanai kaevaavaḡa nenei si vaneiya kudukuduwai keta si tananabuya namai Yeisu i fakwafakwa nenei. Eketa tovanama kudukudu si tananabuya muninei, na sitana si otanowiya unava nenei eketa i sobuwa Yeisu naunei. ");
INSERT INTO wat_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tovanama Yeisu i kitiya namoḡa nasi nufunina yasi vitumaḡana, namoḡa tanaina matematena i iyaviya i bwaduwa, “Natuku, ya go'yona a vinuwateweisiya.” ");
INSERT INTO wat_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tunisi Diu yasi visime kana tovisawavenena nokomai si nunuvitoḡa. Tututausi nuwasinesiyai si bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Au, naki Guyauḡa kana nufota go'yona ina vinuwateweina. Ava uḡuna nofe namoḡa nokomaise i nunusifufu eyo i bwadubwadu-tafakaikokona Guyau nenei!” ");
INSERT INTO wat_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Eatu yasi vinuwadadanasima Yeisu waniya i venusanamaniya eketa i iyavisiya i bwaduwa, “Ava fasinei nanemaise kwa vivinuwadadana nuwafoumiyai? ");
INSERT INTO wat_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Avi bwadubwadu o meyameyanina namoḡa tanaina matematena nenei, ‘Ya go'yona a vinuwateweisiya’ o ‘Ku misini ka sita ku uni be ku nidadana’? ");
INSERT INTO wat_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Eatu kwata sanamaniya vitana Iyau Namoḡa Natuna na yaku visime fakinina kana fata go'yona ana vinuwateweina fwayafwaya etanei yota namoḡa ana givibwina.” Eketa namoḡa tanaina matematena i iyaviya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Neneweu a bwadubwaduwa, ku misini! Ka sita ku uni be ku nai numai!” ");
INSERT INTO wat_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tovanama nenei namoḡa i misiniya, kana sita i uniya keta namoḡa sabu matasiyai i niya. Matatafusi si mayaḡa eketa Guyau si daviya si bwaduwa, “Mukamokena tamo tova ibanama maise tata kitai!” ");
INSERT INTO wat_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeisu kana tomuniyeina nukusi yota menana Kafenaumi si teweiya atu si niya Ganini tobu kafakainei. Sabu nakasina si nemiya nenei eketa Guyau fonana i visawavenena nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kabegona i vaniya, Anafasi natuna kana wava Nebi i kitiya i nunuvitoḡa yana kafa savivina nenei gabana i nunuvemuvemuwa Noma gabemani fasisiyai. Eketa Yeisu i iyaviya i bwaduwa, “Ku muniyeiku be ku vitomuniya.” Nebi i misiniya keta i muniiya. ");
INSERT INTO wat_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Noko muninei, Yeisu Nebi yana numai i vivianonaviya atu tonuvemuvemu keta togo'yona yagwanisi aviyaonana si munimuniye-dadaniya, yota kana tomuniyeina nukusi si kakawa. ");
INSERT INTO wat_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Eatu tunisi visime kana tovisawavenena atu yota Fanasi kunumina nenei si kitiya tonuvemuvemu be togo'yona nukusi si kakawa eketa Yeisu kana tomuniyeina si iyavisiya si bwaduwa, “Ava fasinei i kaka tonuvemuvemu keta togo'yona nukusi?” ");
INSERT INTO wat_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tovanama Yeisu i nowaniya, i iyavisiya i bwaduwa, “Aviyaonana muka vivisafwavinaisi o muka ita nufotaisi sina nai togivibwina nenei. Vivisafwavinaisiḡa kasi nufota sina niya togivibwina nenei. Iyau a nemiya o muka aviyaonana si vivinuwadadana tasike toeyaeyana fasisiyai eatu aviyaonana si sanamaniya tasike togo'yona fasisiyai.” ");
INSERT INTO wat_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tova tamokaḡa Yoni Togivibutabuta kana tomuniyeina keta tunisi Fanasi si vivikokowana atu namoḡa tunisi si nemiya Yeisu nenei eketa si bwaduwa, “Yoni kana tomuniyeina keta Fanasi si vivikokowana eatu ava fasinei yo ka tomuniyeina muka sita vivikokowana?” ");
INSERT INTO wat_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Eketa nenesiyai i nufata i bwaduwa, “Tovanama vikawana kana ka-sebobo kana tovai, muka ita nufotai be tovivikawana kana wagawaga sina vikokowana taki tovivikawana tauna noko nukusi. Muka kana nufota uḡuna tauna o nukusi si sesebobowa. ");
INSERT INTO wat_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Eatu tamoka tova kana kaniyabina sina nemiya keta unaunana nenesiyai sina oviya keta sina niiya. Noko tovanama nenei yo sina vikokowana uḡuna nuwatasi ina dauna.” ");
INSERT INTO wat_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yota i bwaduwa, “Iba kiouna a nemiiya atu muka kami sanu manatuwaina nukusi ita ovivikawaniya. Muka tamo aitevana nuya bidimina kiouna ina vai be nuya manatuwaina kana kabwasasa nenei ina suyakafukafuya. Taki ina fufuniya, kigona muninei nuya bidimina kiouna ina gogomiya nenei, nuya manatuwaina kana kaganini ina nakatadewadewa. ");
INSERT INTO wat_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Muka tamo aitevana kana fata be waini kiouna kikitanina kana nogona fasinei waini kana koni manatuwaina nenei ina vininiwiya. Taki ina fufuniya, noko waininama tovanama buḡobuḡo ina kawananakana eketa kawasiveina ina vaneya nenei, koninama manatuwaina ina nuyavayavaniya uḡuna muka kana fata koninama ina fata. Mwavinana nenei koni keta waini sina goyowa. Atu koni kiouna nenei, waini kiouna ina vininiwatotoiya.” ");
INSERT INTO wat_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabati tamokaḡa nenei Yeisu kana tomuniyeina nukusi witi bwibwiyaguna sinenei si niniya eatu tomuniyeina witi sisina si gigimumuta sina kawa fasinei. ");
INSERT INTO wat_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tunisi Fanasi tomuniyeina si kitisiya eketa Yeisu si iyaviya si bwaduwa, “Ku kitai! Ava fasinei yo Sabati kana visime si yakweyakweniya?” ");
INSERT INTO wat_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Eketa i bwaduviyewa nenesiyai i bwaduwa, “O tamo tova Guyau fonakituna sinenei viviginiweinana kwa ginaḡanaiya aviyavana Deivida i fufuniya tovanama yana namonamoḡa nukusi vitanona si kikanata! Ava fasinei yo muka kana givina kwata vinuwadadanei? ");
INSERT INTO wat_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tovanama Abiata tanake tovibwanaose kasi toviketanuneina yana tovai, Deivida i kanasuna Guyau yana Vada Tafutafuna sinenei keta i vikokoniya maneka fasinei. Eketa i veniya eatu noko manekanama o gigivitafuna eketa tovibwanaoseḡa kasi nufota sina kaniya. Eatu Deivida tunina i kaniya yota aviyaonana si kwafuya tunina maneka i venisiya.” ");
INSERT INTO wat_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yota i iyavisiya i bwaduwa, “Guyau Sabati i fufuniya be namoḡa ina ovivitiya fasinei eatu muka namoḡa ita fufuniya be Sabati kana dauna ina uniya fasinei. ");
INSERT INTO wat_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na fasinei Namoḡa Natuna o Sabatinama kana Tuveka!” ");
INSERT INTO wat_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tova tamokaḡa nenei Yeisu yota i makaviniya eketa i kanasuna numa kafa yokoyoko sinenei keta nokomai namoḡa nimana matematena i kitiya i nunuvitoḡa. ");
INSERT INTO wat_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Namoḡa tunisi nuwanuwasi be Yeisu sina vinoiya fasinei, matasi si vikanaoḡosiya si tonetoneiya taki namoḡa noko ina gidewadewiya kuyadayada Sabati nenei o muka. ");
INSERT INTO wat_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeisu namoḡa nimana matematena i iyaviya i bwaduwa, “Ku nemai be namoḡa nausiyai ku misini.” ");
INSERT INTO wat_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Eketa namoḡasima i nutoninuvenuvisiya i bwaduwa, “Avamasi yata visime i sawateweyeita tata fufuniya kuyadayada Sabati nenei? Kita dewadewana tana fufuniya o goyona tana fufuniya? O kita yawasi tana gifafafaniya o taki tana nuvimatiya?” Eatu matatafusi si numananava. ");
INSERT INTO wat_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na yana kayokuḡa i kitadadana nenesiyai. Atu katekatesi yana gua fasinei i nuwatadauna venemokena keta namoḡa nimana matematena i iyaviya i bwaduwa, “Nimau ku tunei.” Namoḡa nimana i tuniya eketa i dewadewa. ");
INSERT INTO wat_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tovanama nenei Fanasi si venukikinomana keta si niya tufomu Enoda kana tomuniyeina nenesiyai eketa tamo nenei Yeisu waina si fufuniya kana nuvimate fasinei. ");
INSERT INTO wat_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Eketa Yeisu kana tomuniyeina nukusi si niya tobu nenei eatu Ganiniyei sabuvekamoka si muniiya. ");
INSERT INTO wat_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yeisu kiyakiyaya kafa nuwatabau i savivinisiya bigana si nowaniya eketa biga si yauniya i niya Yudiya, Yenusanema, Idumiya yota menanasima Yonidani ukowa fafaninei be i fanakwaniuḡa Taya eketa Saidoni nenesiyai namoḡa si nemiya. ");
INSERT INTO wat_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Noko kuyadayadanama nenei namoḡa yagwanisi i givibwinisiya. Na fasinei tovisafwavinaḡa matatafusi kunausi si ketoketowiwiya be nuwanuwasi Yeisu sina gisikoniya. Eatu sabu nakasina fasinei kana tomuniyeina i iyavisiya be waka sina gidewadewiya fasinei be namoḡa muka sina nibwatabwatavinai. ");
INSERT INTO wat_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kanunu goyosi aviyaonana namoḡa si nuwafisiya tovanama Yeisu si kitakitiya, si fekufekuwa tafakainei eketa si bwaubwauwa, “Kwaḡa o Guyau Natuna!” ");
INSERT INTO wat_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Atu kanunu goyosi i viketofotisiya be muka wakakana sina sai tanake aitevana. ");
INSERT INTO wat_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yeisu i vaneya koya nenei keta namoḡasima yana nuwanuwa i wenisiya si nemiya nenei. ");
INSERT INTO wat_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Namoḡa nasi 12 i gibokisiya keta i wenisiya tonowana. Tasike o tanake nukusi eketa ina visimeisiya sina kikinomana be sina numamana, ");
INSERT INTO wat_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","eketa yota visime i venisiya be namoḡa nenesiyai kanunu goyosi sina nukakisiya. ");
INSERT INTO wat_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nasi 12 i gibokisiya kasi wava o nofemaise. Saimoni (i weniya Fita), ");
INSERT INTO wat_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi natunatuna, Yemesa eketa taina Yoni (i wenisiya Bowanegesi kana givina o kanitana natunatuna), ");
INSERT INTO wat_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anideneya, Finifi, Batonomiu, Madiu, Tomasi, Yemesa Anafasi natuna, Tadiusi, Saimoni Senoti yokonama nenei, ");
INSERT INTO wat_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","eketa Yudasa Isikaniyoti, tanake o Yeisu kana toviwaifufuna. ");
INSERT INTO wat_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yeisu kana tomuniyeina nukusi si kanasuna numa sinenei, atu yota sabu si yoko-savavinisiya eketa muka kasi fata be sina ka. ");
INSERT INTO wat_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tovanama ugunina kana sifufu noko si nowaniya keta si bwaduwa, “Namoḡa noko debabouna i goyowa.” Eketa si niya be sina oviya. ");
INSERT INTO wat_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tunisi visime kana tovisawavenena Yenusanemei si sobunemiya keta si bwaduwa, “Seitani tauna kanunu goyosi kasi toviketanuneina, Yeisu i vivisimeiya. Tanake yana fiwana nenei eketa kanunu goyosi i vivikikinomanisiya.” ");
INSERT INTO wat_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yeisu i wenisiya keta nenesiyai i bwadusobusobuwa i bwaduwa, “Namaise yo Seitani atu yota Seitani tauna ina kwaviniya? ");
INSERT INTO wat_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Taki kafa visime tauna ina sinatakatakiya be sina vikamunumunuwa, na kafa visimenama muka ina fakwa nubwayouna. ");
INSERT INTO wat_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Taki yota namoḡa ugunina ina sinatakatakiya be sina vikamunumunuwa, noko uguninama ina kayakweniya. ");
INSERT INTO wat_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Eketa taki Seitani yana yoko ina sinatakatakiya be sina vikamunumunuwa nao muka kana fata ina misini, yawane ina kakaviya. ");
INSERT INTO wat_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Muka tamo aitevana kana fata be namoḡa fifiwanina yana numa ina kanasunei be yana nogonogo ina gikuma. Kana nivaniva tamo namoḡa fifiwanamokena ina yoniya, yo muniyai yana numai ina gikuma. ");
INSERT INTO wat_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A iyaiyavimiya venemokena. Namoḡa yasi go'yona matatafuna be yasi bwadu-tafakaikokona Guyau nenei o ina vinuwateweisiya. ");
INSERT INTO wat_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Atu taki kwaḡa aitevana Kanunu Tafutafuna kuna bwadu-tafakaikokoniya Guyau mukamokena ina vinuwateweyeu atu ya go'yona ina fakwavaḡata.” ");
INSERT INTO wat_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeisu i bwaduwa nofemaise uḡuna visime kana tovisawavenena si bwaduwa, “Kanunu goyona i nuwafiya.” ");
INSERT INTO wat_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tovanama nenei Yeisu ayona eketa sisitaina si nemiya menanai si misimisiniya, atu kana matakawa si teweiya i niya be ina nemiya ina kitisiya. ");
INSERT INTO wat_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sabu Yeisu si toḡafifiniya eketa tasike fiyaosima o si iyaviya si bwaduwa, “Ayou keta sisitaiu menanai, nuwanuwasi kwaḡa.” ");
INSERT INTO wat_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nenesiyai i nufata i bwaduwa, “Avi ayoku o avi sisitaiku?” ");
INSERT INTO wat_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eketa namoḡasima si toḡafifiniya i kitanainaisiya eketa i bwaduwa, “Kwa kitai! Nofe o ayoku eketa unaunaku. ");
INSERT INTO wat_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aitevana Guyau yana nuwanuwa ina fufuniya, tanake unaku, nouku eketa ayoku.” ");
INSERT INTO wat_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeisu yana visawavenena i kakina-savaviniya Ganini tobu kafakainei eketa sabuvekamoka si niya yana sifufu sina vaneneiya. Eatu si yokokwafuya na uḡuna wakai i toḡa atu namoḡa o tobu kafakainei si fakwa. ");
INSERT INTO wat_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eketa iba yagwanina fasisiyai bwadusobusobuwai i visawavenena. I iyavisiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kwa nowaniya! Namoḡa tamokaḡa kana bwibwiyaguwai fwayafwaya matatafuna i fonoyauyauniya eketa nugi etanei i giyauyauniya. ");
INSERT INTO wat_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tunisi ketai si fekuwa eketa manuwa si nemiya si kawa. ");
INSERT INTO wat_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Atu tunisi gabagabaninei si fekuwa atu muka fwayafwaya badobadona na uḡuna si venuketovitakana, ");
INSERT INTO wat_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","atu kikwanakwanamisi muka sita sobu venemokena keta vanavana i vaneya nenei o i taoyayanisiya. ");
INSERT INTO wat_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nugi tunisi si fekuwa bubu kikikwanekwanena nenesiyai si tafwa atu bubusima si tunatautaunisiya keta muka sita vikabwaga. ");
INSERT INTO wat_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Eatu tunisi nugi si fekuwa fwayafwaya dewadewanei keta si tafwadewadewa. Tunisi si sakuna 30 na kana vifofo, 60 na kana vifofo, eketa 100 na kana vifofo.” ");
INSERT INTO wat_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Eketa i iyavisiya i bwaduwa, “Taki na taniyami maise avana a iyavimiya kwana nowaniya.” ");
INSERT INTO wat_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tovanama Yeisu kana kisina, yana tonowana kasi 12 yota namoḡa tunisi si nemiya Yeisu nenei keta si nutoninuvenuviya yana bwadusobusobusima fasinei. ");
INSERT INTO wat_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","I nufata i bwaduwa, “Kwami fiyaomima a gibokimiya be Guyau yana kafa visime kana nuwasisikona ana nusifufuwimiya. Atu mani namoḡa nenesiyai o muka ana givimayetadewadewai, naki bwadusobusobuḡa nenei ana nusifufuwisiya. ");
INSERT INTO wat_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nokomaise ana fufuniya ebe avana manatuwaina Guyau yana tomatakawa tamokaḡa i viginiwiya fasisiyai ina vivenemokena. Naki sina kitakitiya, atu muka sina kitakinanei. Naki sina nowanowaniya, atu muka sina nuwatasanamanei. Taki yasi fufunagoyo sina kitakinaniya keta sina nuwatasanamaniya ebe sita ugevinisiya nenekuwai nao ata vinuwateweisiya.” ");
INSERT INTO wat_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yeisu i iyavisiya i bwaduwa, “Nofe bwadusobusobunama tamo kana sanamana nenemiyai? Avi bwadusobusobu yoke kwana sanamanei? ");
INSERT INTO wat_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nugi kana toyauyauneina nao Guyau fonana kana toyauyauneina namoḡa yagwanisi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Namoḡa tunisi yasi fakina maise ke'ta bwadusima si nowanowanisiya atu muka mwanenena Seitani i nenemiya keta i viviteweisiya. ");
INSERT INTO wat_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Namoḡa tunisi o maise fwayafwaya gabagabanina, bwadu si nowanowaniya eketa muka mwanenena si katukatuviya na yasi sebobo, ");
INSERT INTO wat_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","atu muka na kikwanakwanamisi, na nenei keta yasi fakwa muka nubwayouna. Tovanama biga dewadewana fasinei dauna keta kuvavana i kikikinomanisiya, si venuvenudibutoyoḡa. ");
INSERT INTO wat_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Namoḡa tunisi o maise bubu sakasakanununa. Nofe namoisima o biga si nowanowaniya, ");
INSERT INTO wat_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","atu yasi nuwanuwa o kimoki fwayafwaya kana fakwafakwa ibasima nenesiyai, gabana keta iba tunisi kasi nisaḡa si nuwagabubuwisiya. Eketa noko ibasima biga dewadewana si tunatunatautauniya eketa muka ita viviuwa. ");
INSERT INTO wat_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Fwayafwaya dewadewana o maise namoḡa tasike biga dewadewana si nowaniya keta si katuviya. Eketa tunisi si sakuna 30 na kana vifofo, 60 na kana vifofo, eketa 100 na kana vifofo.” ");
INSERT INTO wat_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeisu yota i iyavisiya i bwaduwa, “Muka tamo aitevana kana fata kimayeta ina kanasunei keta kabomai ina kabwaniya o kivi sifunei ina tenei. Atu naki kana nufota be yana kafa misiniyai ina teniya. ");
INSERT INTO wat_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aviyavana makamakaviuneinasi o naki maise be ana tene-kikinomanisiya, eatu aviyavana kikikabwanisi o naki maise be ana vitanadadisiya. ");
INSERT INTO wat_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Taki na taniyami maise avana a iyavimiya kwana nowaniya.” ");
INSERT INTO wat_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Keta yota i kanakakina, “I kanoveimi be kwa vaneneḡa-dewadewa, yami nowanautuutunama nenei yami sanamana ina givinakasiya yota ina vifofwiya. ");
INSERT INTO wat_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tasike aviyaonana simo nenesiyai ina venevifofwisiya. Eatu tasike aviyaonana muka nenesiyai atu kabegona, naki nenesiyai ina viteweiya.” ");
INSERT INTO wat_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yeisu yota i bwaduwa, “Guyau yana kafa visime o nofemaise. Namoḡa tamokaḡa yana bagunai nugi i giyauyauniya. ");
INSERT INTO wat_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nuwabuna i banubanuwa keta kuyadayada i misimisiniya, atu nugi o si tafwatafwa eatu muka ita sanamanei namaise. ");
INSERT INTO wat_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Fwayafwaya o nugi i gigivitafwiya, nauna ina ketovitakana, ina tafwa ina vaneya, eyo ina vikabwaga. ");
INSERT INTO wat_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tovanama kabwagamokena ina gumaiya keta kiyana kana tova, namoḡanama ina vibutuwa ina totuya.” ");
INSERT INTO wat_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Eketa Yeisu yota i iyavisiya i bwaduwa, “Avi bwadusobusobu tamo ebe nenei Guyau yana kafa visime ata sawanuvenuveyei? ");
INSERT INTO wat_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Naki maise kayawana nugina musumusumokena namoḡa si bagubaguniya, ");
INSERT INTO wat_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","atu tovanama ina tunakutuva o kaiuwauwa matatafusi i tufutufuteweisiya, naḡanina o si nakanakata keta bayawinei kana nufota be manuwa kasi gigi sina kiyona.” ");
INSERT INTO wat_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nofemaise bwadusobusobusima yagwanina nenesiyai i nusifufuwisiya kana nivaniva si nowana kasi fata na yasi sanamana. ");
INSERT INTO wat_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yana kikitana namoḡa nenesiyai matatafuna o bwadusobusobu nenei, eatu kana tomuniyeinaḡa nenesiyai o matatafuna i gigivimayesiya. ");
INSERT INTO wat_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Noko kuyadayadanama kana navinavi, Yeisu kana tomuniyeina i iyavisiya i bwaduwa, “Tana tamana fafaninei.” ");
INSERT INTO wat_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tanake o wakai atu kana tomuniyeinaḡa si toḡa eketa tanake nukusi yoko si teweisiya atu waka tunisi nukusi si tamana. ");
INSERT INTO wat_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Muka mwanenena atu fonimana i towa eketa nefo waka i siwatotoiya, eketa ukowa i vibutuwa i maamaḡa wakai. ");
INSERT INTO wat_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yeisu waka kunenei i videbaboununakata keta i banubanuwa. Atu kana tomuniyeina si nuvauniya keta si bwaduwa, “Aiye, muka kuta vinuwana tana mateya fasinei!” ");
INSERT INTO wat_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I misiniya keta fonimana i dageiya i bwaduwa, “I katanai!” Yota nefo i iyaviya, “Ku nigwana!” Muka mwanenena fonimana i kataniya eketa manokutukutu i teweiya. ");
INSERT INTO wat_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eketa kana tomuniyeina i iyavisiya i bwaduwa, “Ava fasinei yo kwa matutamoka? Yawane muka yami vitumaḡana?” ");
INSERT INTO wat_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naki kawasi si yaowa eketa tututausi si vikatonitoniya, “Nofe avi namoḡa yo fonimana keta nefo fonana si nowaniya!” ");
INSERT INTO wat_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeisu keta kana tomuniyeina si nemiya Ganini tobu fafaninei fiyao Genasa yasi fafaniyai. ");
INSERT INTO wat_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tovanama Yeisu i sobuwa wakai, namoḡa tamokaḡa kanunu goyona i nuwafiya matematesi kasi vatunuma nenesiyai i kikinomana-nemiya nenei. ");
INSERT INTO wat_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","I fakwafakwa vatunumai. Muka tamo aitevana fifiwanamokena be ina vanetanai. Tova matatafuna kaena keta nimana seni nenesiyai si yonayoniya atu unavasima i kikionota eketa muka tamo aitevana kana fata be ina yona-savavinei. Kuyadayada keta nuwabuna tamokatamokaḡa vatunuma keta koya nenesiyai i ninikaokaoḡowa keta i bwaubwauwa yota tauna gabanai i nunugisagisasiya. ");
INSERT INTO wat_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tovanama Yeisu kedawanauwai i kitiya i dibwana i niya eketa naunei kaetutuna i viketogunisiya, ");
INSERT INTO wat_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","eketa kayona nakasinei i tatakwayana i bwaduwa, “Yeisu, Guyau Etanemokenei Natuna! Ava ya nuwanuwa nenekuwai? Guyau kana wavai a vivikokona-sineganiganiya muka kuna givikuvakuvavaneiku.” ");
INSERT INTO wat_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nofemaise i bwaduwiya uḡuna o Yeisu kanunu goyona nauna i miki-iyaviya, “Kanunu goyou namoḡa nofe ku gionovei!” ");
INSERT INTO wat_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeisu i nutoniiya i bwaduwa, “Namaise ka wava?” I nufata i bwaduwa, “Kaku wava Sagisagigi uḡuna kima yagwaniki namoḡa nofe sinenei.” ");
INSERT INTO wat_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eketa kanunu goyosi Yeisu si kamanemane-yeweyewiya be muka sina nai tamo fafani nenei. ");
INSERT INTO wat_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Niniusiyai o fonoyauwa si kakabubuna koya kafakainei, ");
INSERT INTO wat_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","eketa kanunu goyosi Yeisu si kamanemaniya si bwaduwa, “Ku sawateweyeiki be ku teweyeiki ka nai fono sinesiyai.” ");
INSERT INTO wat_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Eketa sawateweyeina i venisiya keta namoḡa sinenei si kikinomana atu si niya fono nenesiyai si kanasuna. Fonoyauwasima kasi yagwana 2,000 maise, tefai si sinowa eketa tobuwai si gavivina. ");
INSERT INTO wat_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Fonosima kasi tokitavikavina si dibwana si niya menana nakasinei eketa yota menana tamokatamokaḡa nenesiyai matakawa si venutamatamaniya. Namoḡa si niya eketa aviyavana i kikinomana si kitiya. ");
INSERT INTO wat_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tovanama si nemiya Yeisu nenei, namoḡanama manatuwaina kanunu goyosi si nuwafiya si kitiya na kana nuya keta yana nuwanuwa dawaniniina nenei i nuvitoḡa eketa matatafusi si matuta. ");
INSERT INTO wat_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aviyaonana si kitiya avana i kikinomana namoḡanama keta fono nenesiyai namoḡa si iyavisiya. ");
INSERT INTO wat_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eketa Yeisu si kamanemaniya be vitana yasi fafani ina teweiya. ");
INSERT INTO wat_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tovanama Yeisu wakai i toḡatoḡa, namoḡa nauna kanunu goyosi si nuwafiya i kamanemaniya be nukusi sita niya. ");
INSERT INTO wat_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Atu Yeisu i sawataniya eketa nenei i bwaduwa, “Ku makavinau ya menanai be ya sabu kuna iyavisiya avana iba nakasina Tuveka i saviviniya fasiweu, eketa namaise yota yana sineganigani neneweu.” ");
INSERT INTO wat_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Namoḡanama i makaviniya eketa Dekafonisi nenesiyai i nusifufuwa avana Yeisu i saviviniya nenei. Namoḡa matatafusi si nowaniya keta si mayaḡa. ");
INSERT INTO wat_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeisu i tamana-savaviniya tobu fafaninei. Yawane tobu kafakainei atu sabuveka si nemiya keta si yokokwafuya. ");
INSERT INTO wat_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eatu namoḡa tamokaḡa kana wava Yainusi, tanake tamo numa kafa yokoyoko kana toviketanuneina, i nemiya Yeisu nenei. Tovanama Yainusi Yeisu i kitiya i fekuwa kaeyafayafanei, ");
INSERT INTO wat_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","eketa nenei i vikokona-sineganiganiya i bwaduwa, “Natuku gumayogu kabegona, kabegomokena ina mateya. Kuta nemiya nimau tofwanei kuta teniya be kuta givibwiniya keta ita fakwa na yawasina.” ");
INSERT INTO wat_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tovanama si noḡokawawa, namoḡa sabuveka si yokokwafukwafuya keta nukusi si niya. ");
INSERT INTO wat_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Gumayogu kana katona ufaufa i toatoḡateweteweiya manamana 12 o nukusi sinesiyai. ");
INSERT INTO wat_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yana nogonogo matatafuna tokwenikweni nenesiyai i teweiya ebe vitana ita bwina eatu katonanama i nakatamoka. ");
INSERT INTO wat_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Yeisu fasinei i biganowana keta nuwasinenei i bwaduwa, “Taki kana nuyaḡa ana gisikoniya nao ana dewadewa.” Eketa namoḡa sabuveka kasi sinefouwai i niya Yeisu kumunina keta kana nuya i gisikoniya. ");
INSERT INTO wat_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Muka mwanenena ufaufana dibwadibwana i kaonosiya eketa tauna i kamukoniya vitana kana katona naki i kakaviya. ");
INSERT INTO wat_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Noko tovanama nenei Yeisu i sanamaniya yana fiwana naki i kikinomana eketa namoḡa kasi sinefouwai i saḡabwataviniya keta i bwaduwa, “Aitevana kaku nuya i gisikoniya?” ");
INSERT INTO wat_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kana tomuniyeina si iyaviya si bwaduwa, “Ku kitai! Namoḡa sabuveka si yokokwafuwa atu namaise yo ku bwadubwadu, ‘Aitevana i gisikoniku?’” ");
INSERT INTO wat_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Atu Yeisu i kitakitadadana be nuwanuwana ina kitiya aitevana i gisikoniya. ");
INSERT INTO wat_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Atu gumayogu i nuwatasanamaniya aviyavana i kikinomana nenei eketa na yana matuta yota na yana kinikuna i niya Yeisu naunei kaeyafayafanei i fekuwa, keta i iyaviya iba matatafuna kana venemokena nenei. ");
INSERT INTO wat_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Keta Yeisu i iyaviya i bwaduwa, “Natuku, ya vitumaḡanai ku dewadewa. Ka katona naki i kakaviya. Keiya nenei ku nai.” ");
INSERT INTO wat_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yawane i nunusifufuwa atu namoḡa tunisi Yainusi yana numei si nemiya keta si iyaviya si bwaduwa, “Natuu gumayogu naki i mateya. Ava fasinei tovisawavenena kuna visinatamatamane-kaoḡowei?” ");
INSERT INTO wat_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yeisu yasi bwadunama i nowanateweiya eatu i iyaviya i bwaduwa, “Muka kuna matuta, naki ku vitumaḡanamoka.” ");
INSERT INTO wat_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Muka tamo aitevana ita sawateweyei ebe yo nukusi sina nai naki Fita, Yemesa eketa kana tufunuwa Yoni nukusi sina niya. ");
INSERT INTO wat_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tovanama Yainusi yana numai si kikinomana Yeisu namoḡa yagwanisi i kitisiya si bwedibwedi-bwaubwauwa, ");
INSERT INTO wat_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","eketa i kanasuna sinenei keta i iyavisiya i bwaduwa, “Ava uḡuna yo kwa bwedibwedi-nukwae. Gwadimonamona nai muka ita mate atu i banubanuwa.” ");
INSERT INTO wat_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Namoḡa si kawanaviya fasinei matatafusi i vikikinomanisiya eatu gwadimonamona ayona keta amana yota kana tomuniyeina kasi tonu nukusi si kanasuna totomuwai namai gwadimonamona i matamataveya nenei. ");
INSERT INTO wat_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nimanei i ova keta i bwaduwa, “Tanita kumi,” kana givina, “Gumayogu kabegou a iyaiyaviwa ku misini.” ");
INSERT INTO wat_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I venuotowamisiniya keta i fanakwanikwaniuḡa. (Tanake kana manamana 12.) Eketa si mayaḡamatatafuwa. ");
INSERT INTO wat_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eketa Yeisu visime fifiwanamokena i venisiya ebe muka tamo aitevana sina iyavei. Eyo i bwaduwa, “Ava tamo kwa venei be i kawa.” ");
INSERT INTO wat_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeisu kana tomuniyeina nukusi menana noko si teweiya keta si makavinisiya Nasaneti tauna yana menana nenei. ");
INSERT INTO wat_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabati kana kuyadayada nenei i vibutuwa visawavenena numa kafa yokoyoko sinenei. Namoḡa yagwanisi si nowaniya keta si mayaḡa. Tututausi nenesiyai si vikatonitoniya si bwaduwa, “Namasimo nofe nuwanuwasima i vaisi, avi nuwatasuyasuya nenei eyo kafa nuwatabau fifiwanisi i gigikikinomaneisi? ");
INSERT INTO wat_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Namoḡa nofe o naki tokabitamomoka. Ayona o Meni eketa sisitaina o Yemesa, Yosefa, Yudasa keta Saimoni, yota nounouna nukusi nofemai ta fakwafakwa.” Eketa si dibutoyoemokiya. ");
INSERT INTO wat_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeisu i iyavisiya i bwaduwa, “Namoḡa Guyau yana tomatakawa si vivifotuwisiya, eatu tututausi yasi menana namoisi be yasi sabu eketa yasi fasekwa o muka sita vivifotuweisi.” ");
INSERT INTO wat_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Eketa Yeisu i mayaḡa uḡuna namoḡa muka sita vitumaḡana, na fasinei muka kana fata be tamo iba fifiwanina nokomai ita fufuniya eatu nimana i dawana nasi viyamoka tofwasiyai eketa si bwina. Eketa i fanakwaniuḡa menana nenesiyai i vivisawavenena. ");
INSERT INTO wat_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yeisu yana tonowana i wenevakukusisiya eketa nuwesinuwesi i visimeisiya menana nenesiyai. Eketa visime i venisiya ebe kanunu goyosi sina vatanisiya, ");
INSERT INTO wat_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","eketa i iyavisiya i bwaduwa, “Yami nainama nenei muka tamo aviyavana kwana uniya, muka kabwaga, kautu o gabana, naki kiwanaḡa tamokaḡa. ");
INSERT INTO wat_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kami kaevatakutakuna kwana kikotonina eatu muka tamo nuya kana vinuwa kwana uniya. ");
INSERT INTO wat_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Taki avi menana nenei kwana niya, tamoka numanama nenei kwana fakwa kana nivaniva na menaninama kwana teweiya. ");
INSERT INTO wat_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Taki kwana nemiya tamo menana nenei atu namoḡa muka sina katuvaimi o sina nowanimi, kaeyafayafami kasi kafusisima kwana nubutusiya eatu kwana niya. Noko ina visawavenena vitana matasi ina kanakasiya.” ");
INSERT INTO wat_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eketa si niya namoḡa si iyaiyavisiya, “Yami fufunagoyo nenesiyai kwana ugevinimiya ebe kwana makavinimiya Guyau nenei.” ");
INSERT INTO wat_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kanunu goyosi yagwanisi si vikikinomanisiya eketa onive bubunei namoḡa tovisafwavinaḡa tofwasiyai si kisiwaḡa eketa si givibwinisiya. ");
INSERT INTO wat_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Yeisu bigana i kewa eketa namoḡa matatafusi kana wava si sanamaniya. Tunisi namoḡa si bwadubwaduwa, “Kana fata be iba fifiwanisi ina saviviniya uḡuna tanake Yoni togivibutabuta matematesi nenesiyai i misini-savaviniya.” Tunisi namoḡa si bwaduwa, “Tanake o Inaitiya i makaviniya.” Tunisi namoḡa yota si bwaduwa, “Tanake maise tomatakawa manatuwaina.” Nofe ibasima fasisiyai, tufomu Enoda Anitifasi i biganowana eketa i bwaduwa, “Yoni togivibutabuta kayona a nuonotateweiya eatu mateyai i misini-savaviniya.” ");
INSERT INTO wat_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Kana sifufumokena nofemaise. Muniyai yo Yeisu i vibutuwa visawavenena, Enoda taina Finifi kawana Enodiyasi i vikawanisiya. Munifotai Yoni Enoda i iyaviya i bwaduwa, “Yata visime nenei muka tamo ka sawateweyeina be taiu kawana ku vikawanisi.” Na fasinei Enoda yana tonuaviya i visimeisiya si niya. Yoni si givikaviniya, si yoniya eketa deniyai si teniya. Enoda keta Yoni yasi vikanunusifufu nenei Enoda nuwanuwa yaona venemokena i viya, eatu naki nuwanuwana be ina vanevaneneiya. Enodiyasi o si kayokayokuḡa nuwanuwasi be Yoni sina nuvimatiya atu Enoda i sanamaniya Yoni o namoḡa dewadewana keta tafutafuna na uḡuna i matuta eketa i ofafafiya. Na nenei Enodiyasi muka kasi fata Yoni sita nuvimatei. ");
INSERT INTO wat_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Enodiyasi yasi kuyadayada dewadewana i kikinomana, Enoda yana kafa tufuwa kana tuku kana tovai. Enoda ka nakasina i fufuniya tovisime nakanakasisi be tonuaviya kasi toviketanuneina keta Ganini kasi toviketanuneina fasisiyai. ");
INSERT INTO wat_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Enodiyasi natusi gumayogu i kanasunanemiya keta yana vaḡai Enoda kana yokoyoko nukusi i givisemwanisiya. Eketa tufomu gumayogu kakaabana i iyaviya i bwaduwa, “Aviyavana ya nuwanuwa kuna bwaduwiya, ana veniwa.” ");
INSERT INTO wat_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eketa bwadudabadaba fifiwanina nenei i iyaviya i bwaduwa, “Aviyavana ya nuwanuwa kuna vikokonikuwa, maise yaku kafa visime tunina ana veniwa.” ");
INSERT INTO wat_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Gumayogu i kikinomana keta ayona i iyavisiya i bwaduwa, “Avamasi fasinei ata vikokona?” Ayona si nufata si bwaduwa, “Yoni togivibutabuta debabouna fasinei kuna vikokona.” ");
INSERT INTO wat_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dibwadibwanina nenei i venumakaviniya tufomu nenei eketa i bwaduwa, “Nuwanuwaku nofe tova Yoni togivibutabuta debabouna kuna nuonosiya keta kanusana nenei kuna totoiya keta kuna venikuwa.” ");
INSERT INTO wat_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nofe bwadunama tufomu nuwatana i gividauniya venemokena, eatu naki kana yokoyoko matasiyai i bwadudabadaba na fasinei yana vikokona muka ita dibutoyoḡei. ");
INSERT INTO wat_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eketa muka mwanenena tonuaviya i visimeiya be Yoni debabouna ina nemiiya. Namoḡanama i niya deni nenei eketa Yoni kayona i nuonosiya, ");
INSERT INTO wat_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kanusana nenei debabouna i nemiiya gumayogu i veniya eketa gumayogu i viya ayona i venisiya. ");
INSERT INTO wat_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tovanama Yoni kana tomuniyeina bigana si nowaniya, si nemiya eketa tofwana si viya keta vatunuma nenei si odewadewiya. ");
INSERT INTO wat_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tonowana si makavinisiya eketa iba matatafuna avana si fufuniya yota si visawavenena, si bwaduwe-kikinomaniya Yeisu nenei. ");
INSERT INTO wat_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na tovanama nenei, namoḡa yagwanisi Yeisu si venuvenuyeweyewiya eketa muka tamo yasi kawasasa be sina biyawasa. Na fasinei Yeisu i iyavisiya i bwaduwa, “Kwamiḡa kwa nemai. Sabu nofe ta teweyeisi be ta nai kabaḡa nunukamumunina nenei ebe ta viyawasi.” ");
INSERT INTO wat_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Eketa tasikeḡa wakai si niya kabaḡa nunukamumunina nenei. ");
INSERT INTO wat_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Atu yasi noḡokawawanama nenei, namoḡa menana kana matatafu nenesiyai si kitakinanisiya eketa si venufana noko kabaḡanama nenei muniyai yo Yeisu kana tomuniyeina nukusi si saniniya. ");
INSERT INTO wat_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tovanama Yeisu wakai i sobuwa, sabuveka i kitisiya. I kitasineganiganiisiya uḡuna tasike maise sifi muka na kasi tokitavikavina, na uḡuna i vibutuwa i visawavenena iba yagwanisi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Navinavimokeyai kana tomuniyeina si nemiya nenei eketa si bwaduwa, “Nofe wanakikavai eatu vanavana naki i sonusonuwa. ");
INSERT INTO wat_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Na fasinei namoḡa ku teweyeisi be si nai menana ketamwakufwai, tututausi kasi kabwaga simo si vikimwane ebe si kawa.” ");
INSERT INTO wat_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eatu i nufata i bwaduwa, “Kwami tututaumi tamo aviyavana kwa veneisi be si kawa.” Eketa si iyaviya si bwaduwa, “Omasi 200 siniva nenei maneka kana kimwanisiya keta kana vikanisiya?” ");
INSERT INTO wat_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eketa i nutoninuvenuvisiya i bwaduwa, “Aviyesi maneka nenemiyai? Kwa nai be kwa dadana.” Tovanama si nisaiya, si bwaduwa, “Maneka 5 eketa iyana nuwesi weka.” ");
INSERT INTO wat_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeisu sabuveka i iyavisiya i bwaduwa, “Bubuwai kwana fakwasiotoḡa yoko nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eketa yoko nenesiyai si fakwasiotoḡa. Tunisi kasi yagwana 50 atu tunisi o 100. ");
INSERT INTO wat_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tovanama Yeisu maneka 5 keta iyana nuwesi i visiya, i kitavaneya abamai ibasima fasisiyai Guyau i viagigikuwiya. Maneka i gisinesiniya eketa kana tomuniyeina i venisiya keta si vitukuwa namoḡa nenesiyai. Keta yota iyana nuwesi i gikotokotova keta i vitukuwa matatafusi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Eketa matatafusi si kasiyuwa venemokena, ");
INSERT INTO wat_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","munifotai Yeisu kana tomuniyeina maneka keta iyana tufotufo si kwakwiya keta feyawa 12 si vimaisiya. ");
INSERT INTO wat_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Namoḡa kasi yagwana 5,000 na yasi susu kabwaginama si kaniya. ");
INSERT INTO wat_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Muka mwanenena Yeisu kana tomuniyeina i iyavisiya be wakai sina venuviketanuna menana Betisaida nenei tobu fafaninei, eatu noko sabusima i teweisiya si niya. ");
INSERT INTO wat_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I vioiyoowisiya muninei i vaneya koyai kawanunuku fasinei. ");
INSERT INTO wat_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Navinavinama nenei Yeisu kana tomuniyeina yasi wakai tobu sinefounei si kikinomana, eatu tanake kana kisina si sinanoviya. ");
INSERT INTO wat_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Eketa i kitisiya kana tomuniyeina si oioiya na yasi fiwana uḡuna fonimana keta yoyo si viketosoḡaniya. Eketa tovawedanai Yeisu ukowa etanei i niya kuweyaisi be vitana ina tutuunisiya. ");
INSERT INTO wat_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Atu tovanama si kitiya si bwaduwa vitana mayamayau ukowa etanei ita nenemai eketa si tatakwayaniya. ");
INSERT INTO wat_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Matatafusi si kitiya si matuta. Eketa Yeisu i venubwadufotafota i iyavisiya, “Muka kwana matuta. Kwa katevatu. Iyau weka.” ");
INSERT INTO wat_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yeisu i toḡa wakai eketa fonimana i onoviya. Kawasi i yaowa, ");
INSERT INTO wat_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","uḡuna avana i saviviniya maneka nenesiyai si kitiya eatu muka sita nuwatasanamanei yana fiwana keta katekatesi si fakina. ");
INSERT INTO wat_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tobu si witamaniya keta Genasaneti si saniniya. Nokomai waka si nusifwiya. ");
INSERT INTO wat_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tovanama wakai si sobuwa, namoḡa Yeisu si venukitakinaniya. ");
INSERT INTO wat_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Namoḡa si venusavaneneḡa fafaninama nenei. Avi kabaḡa nenei sina nowaniya Yeisu nokomai, tovisafwavinaḡa na sitasi si nenemiisiya nenei. ");
INSERT INTO wat_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yeisu i niya menana-sifunu yota menana nakanakasisi eketa numa-sifunu nenesiyai. Noko kabaḡasima nenesiyai namoḡa tovisafwavinaḡa si nenemiisiya eketa kabaḡa kafa vivitamaneina nenesiyai si dawadawana, eatu Yeisu si vivikokoniya be kana kwame matakafafanaḡa sita gisikoniya. Eketa aviyaonana si gisikoniya si dewadewa. ");
INSERT INTO wat_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Fanasi keta Diu fiyaosi yagwanisi waḡawaḡasi nenesiyai kasi sanu i donanisiya eketa si munimuniiya. Kasi owa be tukwava eketa taga si nunutamatama kana ketaketai venemokena ebe si vitumaḡaniya noko kukuwasima eyaeyasi Guyau matanei. Tovanama kafa vivitamaneina nenei sina makavinisiya, nauna nimasi sina kigona kana ketaketai muniyai yo sina kawa. Tova tamokaḡa Fanasi keta yota tunisi Mosese yana visime kana tovisawavenena Yenusanemei si nemiya nukusi Yeisu si yokokwafuya be sina vaneneiya fasinei. Si kitisiya tunisi tomuniyeina muka nimasi nauna sita kigona eatu kasi kabwaga si kakawa. ");
INSERT INTO wat_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Eketa si iyaviya si bwaduwa, “Ka tomuniyeina nimasi gavigavisi atu si kakawa. Ava uḡuna yo waḡawaḡata kasi sanu muka sita munimuniyei?” ");
INSERT INTO wat_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I nufata i bwaduwa, “Kwami meyami vinavinasi avage vitana dewadewami! Tova manatuwaina Guyau yana tomatakawa Aiseya venemokena i viginiwiya kwami fasimiyai. Nofemaise i viginiwiya, Guyau i bwaduwa, ‘Namoḡa nofe kawagebunasiyaiḡa si vivifotuwikuwa eatu katekatesi i fakwa sasanei. ");
INSERT INTO wat_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tututausi kasi sanu si vivisawavenena yo muniyai si bwadubwaduwa vitana noko Guyau yana visime, eketa kaku kodukodu nenesiyai o i viibakaokaoḡowa.’” ");
INSERT INTO wat_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Eketa Yeisu i bwaduwa, “Guyau yana visime kwa dibudibutoyoiya atu kwami tututaumi kami sanu kwa munimuniiya. ");
INSERT INTO wat_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kwa vivinuwadadana vitana dewadewana kwata fufufuniya atu Guyau yana visime kwa visaḡaketuketuwisiya eatu waḡawaḡami kasi sanu kwa viya o kwa munimuniye-dewadewamokisiya. ");
INSERT INTO wat_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nofe yota tamo kafa kita kwa fufufuniya. Mosese i viginiwiya i bwaduwa, ‘Amau keta ayou kuna vifotuwisiya,’ keta ‘Taki tamo aitevana ina vikanatafutafuwa amana o ayona nenesiyai, na gwadinama kwana nuvimatiya.’ ");
INSERT INTO wat_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Atu nofemaise kwa vivisawavenena. ‘Taki tamo aitevana ibanama nenei, kana nufota be amana o ayona ina ovivitisiya eatu ita iyavisiya, “Iba nofe kaku nufota be nenei ata ovivitimiya eatu a tenesiniya be Guyau ana veniya, na fasinei muka kaku nufota be ana veneimi.”’ ");
INSERT INTO wat_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Taki nokomaise ina fufuniya nao kwana bwaduwa, ‘Naki dewadewana.’ Na nenei kwa viviketofotiya eketa muka ayona be amana ina oviviteisi. ");
INSERT INTO wat_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tovanama nofemaise kwana fufuniya, nao waḡawaḡami kasi sanuḡa kwa munimuniiya eatu Guyau yana visime kwa viviibakaokaoḡowiya keta yota ketaketa yagwanisi nenesiyai nofemaise kwa fufufunisiya.” ");
INSERT INTO wat_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeisu namoḡa i wene-savavinisiya si nemiya nenei eketa i iyavisiya i bwaduwa, “Matatafumi yaku sifufu kwana nowanautuutuya be kana sanamana kwana viya. ");
INSERT INTO wat_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aviyavana tamo namoḡa kawanei ina kanasuna o muka ina givigavigaviya. Eatu avana kawanei ina kikinomana, enao ina givigavigaviya Guyau matanei.” ");
INSERT INTO wat_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Namoḡa i teweisiya eatu i kanasuna numai, keta kana tomuniyeina si nutoninuvenuveiya bwadusobusobu i nusifufuwiya kana sanamana fasinei. ");
INSERT INTO wat_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","I nufata nenesiyai i bwaduwa, “O kwami yota yawane muka kwata sanamanei yaku sifufu kana givina! Muka kwana nuwatasanamanei tovanama namoḡa kabwaga ina kaniya, noko kabwaganama muka ina kanasuna nuwafounei, eatu ina niya kamokamonei eketa ina kikinomana. Muka kana fata be ina givigavigaviya.” Tovanama Yeisu noko i bwaduwiya, i visawavenena vitana kabwaga matatafuna o eyaeyana Guyau matanei. ");
INSERT INTO wat_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yota i bwaduwa, “Avana namoḡa sinenei ina kikinomana noko ibanama ina givigavigaviya. ");
INSERT INTO wat_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nofe ibasima o namoḡa nuwafounei si kikikinomana — vinuwadadana goyosi, vimomona-kaokaoḡo, gikuma, nuvimate, kudo, ");
INSERT INTO wat_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kanufafa, fufuna goyosi, bwadu-vikanonono, matayaiyaina, vikumaiḡi, sawanuketu, nuwavane, akwavakwava. ");
INSERT INTO wat_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nofe ibasima matatafuna goyosi nuwafounei si kikikinomana eketa namoḡa si gigivigavigaviya.” ");
INSERT INTO wat_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Eketa Yeisu menana noko i teweiya eatu i niya menana tamokaḡa nenei Taya keta Saidoni niniusiyai eketa i niya numa tamokaḡa nenei. Muka nuwanuwana be namoḡa sina sanamanei tanake o noko menananama nenei, eatu muka kana fata ina makaviuna. ");
INSERT INTO wat_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Gumayogu tamokaḡa si nowaniya vitana Yeisu o nokomai eketa muka mwanenena si nemiya nenei. Gumayogu nofe o muka ne Diu, tasike ne yauyauna. Si tufuwa menana Foenisiya nenei fafani Siniya sinenei. Kanunu goyona natusi gumayogu i vivisimeiya fasinei keta si nemiya Yeisu nenei. Eketa si fekuwa kaeyafayafanei eketa si kamanemaniya be natusi nenei kanunu goyona ita vikikinomaniya. ");
INSERT INTO wat_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","I sanamaniya tasike muka ne Diu eketa i iyavisiya i bwaduwa, “Fiyagenagena nauna sita mikikawa, muka kana nufota be fiyagenagena kasi kabwaga ana vai keta ana teweyei anuketa nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Eatu si nufata si bwaduwa, “Tuveka yo, ava ku bwaduwiya o venemokena, eatu anuketa sonama sifunei fiyagenagena kasi kawamusumusu i fekufekuwa, si kanikaniya.” ");
INSERT INTO wat_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Eketa i iyavisiya i bwaduwa, “Yami bwadunama dewadewana na fasinei kwa nai yami ketai, eatu kanunu goyona o natumi gumayogu naki i gionoviya.” ");
INSERT INTO wat_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tovanama si kikinomana numai, natusi si kitiya i matamataveya kana kiviyai eketa si sanamaniya vitana kanunu goyona naki natusi i gionoviya. ");
INSERT INTO wat_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeisu fafani Taya i teweiya eketa i vaonota Saidoni sinefounei. Eketa i niya Ganini tobuwai Dekafonisi yana fafani sinesiyai. ");
INSERT INTO wat_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nokomai namoḡa tamokaḡa taniyana kweuna yota meyana danuna si nemiiya. Eketa Yeisu si vikokona-sineganiganiiya be nimana ita teniya tofwanei be ita dewadewa. ");
INSERT INTO wat_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Namoḡanama i oviya eketa kasi nuwa si niya si misinikafasina eketa namoḡanama taniyanei nimatafwana i katukanasunisiya, muniyai yo i nufuniya eketa meyana i gisikoniya. ");
INSERT INTO wat_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eyo i kitavaneya abamai, yawasina i tuniya eketa namoḡanama nenei i bwaduwa, “Efata!” Kana givina o “I kagegeu!” ");
INSERT INTO wat_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tovanama nenei namoḡa taniyana i kanabuya yota meyana i savivina keta i nusifufudewadewa. ");
INSERT INTO wat_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeisu i sawasawatanisiya be muka tamo aitevana sina iyavei aviyavana i kikinomana fasinei. Eatu namoḡa yagwanisi nenesiyai si nusifufuwe-dadaniya. ");
INSERT INTO wat_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tovanama namoḡa biga noko si nowaniya, si sabanutuḡa eketa si bwaduwa, “Iba matatafuna i savivinisiya o dewadewana. Namoḡa taniyasi kweusi i gigidewidewisiya keta si nowanowana, yota meyasi danusi i gigidewidewisiya keta si nunusifufuwa.” ");
INSERT INTO wat_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Noko tovanama nenei namoḡa yagwanisi yota si yokowa. Sabu kabwaga muka, na fasinei Yeisu kana tomuniyeina i wenevakukusisiya eketa i iyavisiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Namoḡa a kitasineganiganiisiya uḡuna kasi kabwaga muka, eatu kuyadayada tonusi naki ka fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Taki na vitanonisi ana teweisiya be sina niya yasi numai ketai sina sasana. Yota tunisi kedawanauwai si nemiya.” ");
INSERT INTO wat_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kana tomuniyeina si nufata si bwaduwa, “Nofe o wanakikavai, keta namao kabwaga tana vai yo namoḡa tana vikanisi?” ");
INSERT INTO wat_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Keta Yeisu i nutoninuvenuveisiya i bwaduwa, “Aviyesi maneka nenemiyai?” Si bwaduwa, “Naki 7moka.” ");
INSERT INTO wat_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yeisu namoḡa i iyavisiya keta fwayafwayai si fakwasiotoḡa. Maneka 7 i visiya, Guyau nenei i viagigikuwa eketa maneka i gisinesiniya. Kana tomuniyeina i venisiya eketa namoḡa nenesiyai si vitukuwa. ");
INSERT INTO wat_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yota iyana tonusi musumususi tomuniyeina nenesiyai i visiya, Guyau nenei i viagigikuwa eyo i iyavisiya keta namoḡa nenesiyai sina vitukuwa. ");
INSERT INTO wat_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Namoḡa matatafusi si kasiyuwa venemokena eatu yota gisinesine yagwanina i tufowa. Munifotai tomuniyeina feyawa 7 si vimaisiya gisinesinesima nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Namoḡa kasi yagwana 4,000 maise Yeisu i vikanisiya, muniyai yo i visimeisiya si niya yasi menanai. ");
INSERT INTO wat_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Muka mwanenena Yeisu kana tomuniyeina nukusi wakai si toḡa eketa si niya Danumanuta kawakawana nenei. ");
INSERT INTO wat_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fanasi tunisi si nemiya keta si vibutuwa Yeisu nukusi si vikawabwadubwaduwa be Yeisu sina anuvanuviya, na fasinei si vikokoniya be tamo kiyakiyaya abamei ita visawavenisiya. ");
INSERT INTO wat_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeisu yawasina i tununoviya keta i iyavisiya i bwaduwa, “Ava fasinei yo kwami nofe tovasima kasi namoḡa kiyakiyaya fasinei kwa vivikokona Guyau nenei? A iyaiyavimiya venemokena, muka tamo kiyakiyaya ana visawaveneimi.” ");
INSERT INTO wat_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Eketa Yeisu Fanasi i venumakanovisiya eatu i toḡa-savaviniya wakai keta kana tomuniyeina nukusi si tamana Ganini tobu fafaninei. ");
INSERT INTO wat_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tomuniyeina nuwatasi i unuwa eketa muka tamo maneka sita niyei, eatu naki tamokaḡamoka waka sinenei. ");
INSERT INTO wat_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeisu i bwaduwa, “Matami i nakata ebe muka Fanasi eketa Enoda yasi nutuvai sina vikonaimi.” ");
INSERT INTO wat_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tomuniyeina tututausiḡa si vikanusifusifufuwa yana bwadunama fasinei keta si bwaduwa, “Muka tamo maneka tata nemiyei na uḡuna nutuva fasinei i bwadubwaduwa.” ");
INSERT INTO wat_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yasi vikanusifusifufunama Yeisu naki i sanamaniya eketa i iyavisiya i bwaduwa, “Ava fasinei kwa bwadubwadu vitana muka tamo maneka nenemiyai! O yawane muka kwata kitanisaḡai o kwata nuwatasanamanei! Kwami gewa katekatemi guasi. ");
INSERT INTO wat_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Na matami atu muka kwata kitakitadewadewa eketa na taniyami atu muka kwata nowanowanadewadewa! Kwana tukuya tovanama maneka 5 a gisinesinisiya namoḡa 5,000 fasisiyai, aviyesi tufotufo feyawa?” Si bwaduwa, “Feyawa 12 si tufowa.” ");
INSERT INTO wat_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Eatu maneka 7 a gisinesinisiya namoḡa 4,000 fasisiyai, nao aviyesi feyawa tufotufo kwa vimaḡaisi.” Si bwaduwa, “Feyawa 7.” ");
INSERT INTO wat_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eketa i bwaduwa, “O atu yawane muka kwata nuwatasanamanei?” ");
INSERT INTO wat_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tovanama si kikinomana menana Betisaida nenei, nokomai namoḡa tunisi tomatagoyo tamokaḡa si nemiiya eketa Yeisu si kamanemaniya ita givikaviniya be ita dewadewa. ");
INSERT INTO wat_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eketa tomatagoyo nimanei i givikaviniya eketa i kikinomaniya menana kukwauna. Matana i nufunatanisiya eketa nimana i dawana tofwanei eatu i iyaviya i bwaduwa, “Tamo aviyavana ku kitakitiya?” ");
INSERT INTO wat_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Matana i kabwasasiya eketa i bwaduwa, “Ika, namoḡa a kitikitisiya eatu vitana kai sita ninidadana.” ");
INSERT INTO wat_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yota Yeisu nimana i tene-savaviniya namoḡa matanei. Matana i katototuya eketa iba matatafuna i kitadewidewisiya. ");
INSERT INTO wat_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eketa Yeisu i bwaduwa, “Muka kuna makavineu menanai, naki dawaniniina kuna niya ya numai.” ");
INSERT INTO wat_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeisu kana tomuniyeina nukusi si niya menana Sisaniya Finifai niniunei keta si niniya atu ke'ta tofwanei i nutoniisiya i bwaduwa, “Namaise namoḡa si bwadubwadu fasikuwai, Iyau aitevana?” ");
INSERT INTO wat_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eketa si nufata si bwaduwa, “Tunisi namoḡa si bwadubwaduwa avage kwaḡa o Yoni Togivibutabuta, eatu tunisi o si bwadu avage Inaitiya. Eatu tunisi o si bwadubwaduwa kwaḡa tamo Guyau yana tomatakawa.” ");
INSERT INTO wat_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eketa i nutoninuvenuveisiya i bwaduwa, “Eatu kwami o namaise kwata bwadu fasikuwai?” Eketa Fita i nufata i bwaduwa, “Kwaḡa o Togifafafana Gigibokeinau.” ");
INSERT INTO wat_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eatu Yeisu tauna i viketofotisiya ebe muka wakakana sina sai tanake aitevana. ");
INSERT INTO wat_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Eketa Yeisu i vibutuwa tomuniyeina i gisawakedanisiya aviyavana yawane ina kikinomana tauna nenei. I iyavisiya i bwaduwa, “Namoḡa Natuna yawane ina kuvavana iba yagwanina nenesiyai. Tokawakawa be tovibwanaose nakanakasisi keta yota visime kana tovisawavenena sina utuvifwayafwaiya. Nifanifaina sina nuvimatiya eatu kuyadayada tonusi muninei mateyai ina misini-savaviniya.” ");
INSERT INTO wat_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tovanama nofemaise i givimayetamokiya nenesiyai, Fita Yeisu i oviya i niiya kuniniusi eketa i dageiya. ");
INSERT INTO wat_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Atu Yeisu i saḡaviniya kana tomuniyeina i toneisiya eketa Fita i dageiya i bwaduwa, “Seitani, ku nai sasanei! Ya vinuwadadana muka Guyau yana vinuwadadana maise, eatu maise namoḡa.” ");
INSERT INTO wat_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yeisu sabu i wenevakukusisiya kana tomuniyeina nukusi eketa i nusifufuwisiya i bwaduwa, “Taki kwaḡa aitevana nuwanuwau be kuna muniikuwa, ya nuwanuwa kuna tenemuniukwanisiya eatu tauḡu ka ogonaḡanaḡa kuna uniya keta kuna muniikuwa. ");
INSERT INTO wat_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Taki kwaḡa aitevana nuwanuwau yawasiu kuna gifafafaniya, nao kuna niteweiya. Eatu taki fasikuwai keta yota biga dewadewana fasinei yawasiu kuna niteweiya, nao kuna gifafafaniya. ");
INSERT INTO wat_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Taki aitevana tamo fwayafwaya kana matatafu kana kaikaiwabu ina viya eatu yawasi muka, nao ava tamo kana dewadewana? ");
INSERT INTO wat_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Na fasinei taki namoḡa yawasina venemokena ina niteweiya, muka kana fata be tamo avana nenei ina fatai be yo ina visavavinei. ");
INSERT INTO wat_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nofe tovasima kasi namoḡa o tokudo keta tofufunakaokaoḡo maise eketa taki aitevana ina sinemumuwikuwa maise yota yaku bwadu ina sinemumuwiya nofe namoisima yasi tovai, yawane Namoḡa Natuna yota ina sinemumuwisiya tovanama ina makaviniya fwayafwayai amana yana kaiwabu keta yota kana kaetoḡa tafutafusi abamei nukusi.” ");
INSERT INTO wat_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeisu i iyavisiya i bwaduwa, “A iyaiyavimiya venemokena, namoḡa tunimi nofemai kwa misimisiniya Guyau yana kafa visime ina nemiya na yana fiwana kwana mikikitiya muniyai yo kwana mateya.” ");
INSERT INTO wat_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kuyadayada 6 muninei Yeisu kasi tonuḡa, Fita, Yemesa yota Yoni i ovisiya eketa tasikeḡa si vaneya koya etanei. Nokomai tututausi matasiyai si kitiya Yeisu i dawanavinavina. ");
INSERT INTO wat_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kana nuya si kwaya eketa si nukawanamanamanina. Muka tamo aitevana fwayafwayai kana fata ina gonaisi nokomaise. ");
INSERT INTO wat_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Munifotai Inaitiya keta Mosese si kenokikinomana keta Yeisu nukusi si nusifufuwa. ");
INSERT INTO wat_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Fita i bwaduwa, “Tovisawavenena, naki dewadewamokena kima nukusi nofemai eketa vada tonusi kana yonisiya, tamokaḡa kwaḡa fasiweu, tamokaḡa Mosese eketa tamo o Inaitiya.” ");
INSERT INTO wat_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Fita bwaduna i bauwiya uḡuna kasi tonu si matutamoka, na fasinei nofemaise i bwaduwa. ");
INSERT INTO wat_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Munifotai busibusi i nemiya i kabwanisiya eketa busibusi sinenei Guyau fonana i kikinomana i bwaduwa, “Natuku nofe a nuwagabubuwiya, fonana kwana nowaniya.” ");
INSERT INTO wat_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tomuniyeina si kitadadana eatu muka tamo aitevana sita kitai naki Yeisu kana kisina si kitiya. ");
INSERT INTO wat_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tovanama koyai si sobunemiya, i viketofotisiya be muka tamo aitevana sina iyavei avana si kitiya kana nivaniva Namoḡa Natuna mateyai ina misini-savaviniya. ");
INSERT INTO wat_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yana sawatana si muniiya, atu tututausiḡa si vibutuwa si vivikanunusifusifufuwa, “Avao nofe misini-savavineina mateyai kana nuwanuwa?” ");
INSERT INTO wat_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eketa Yeisu si nutoniiya si bwaduwa, “Ava fasinei yo visime kana tovisawavenena si bwadubwadu Inaitiya ina mikinemai muniyai yo Togifafafana Gigibokeinana ina nemiya?” ");
INSERT INTO wat_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I nufata i bwaduwa, “Inaitiya ina mikinemiya ebe iba matatafuna ina omanafufuniya. Eatu Guyau fonakituna yota i bwadubwaduwa vitana Namoḡa Natuna o ina kuvavana nakasina eketa namoḡa sina utuvifwayafwaiya. ");
INSERT INTO wat_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A iyaiyavimiya venemokena, Inaitiya naki i nemiya atu namoḡa si fufunakaokaoḡowa nenei. Naki maise Guyau fonakituna i bwaduvioḡoniya.” ");
INSERT INTO wat_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tovanama si savavinisiya tomuniyeina tunisi nenesiyai, si kitisiya visime kana tovisawavenena nukusi si vivikawabwadubwaduwa namoḡa yagwanisi sinesiyai. ");
INSERT INTO wat_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tovanama sabuveka Yeisu si kitiya si sabanutuḡa eketa si venufotefotiya. ");
INSERT INTO wat_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","I nutoniisiya i bwaduwa, “Avamasi kwa oovigwavigwaeḡei?” ");
INSERT INTO wat_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Namoḡa tamokaḡa sabuveka sinesiyai i bwaduwa, “Tovisawavenena, kanunu goyona natuku i nuwafiya eketa muka ita nunusifufu, na fasinei a nemiiya neneweu be kuna givibwiniya. ");
INSERT INTO wat_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tovanama kanunu goyona i gigivikaviniya, na kawatefutefunina i tuḡatuḡaiya fwayafwayai. Niḡona i kikitanavikavikavina keta i fatofatokiya. Ka tomuniyeina a vikokonisiya be kanunu goyona sita nukakiya atu si vibaiwayosa.” ");
INSERT INTO wat_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeisu i nufata i bwaduwa, “Kwami namoḡa avi tovai masi kwana vitumaḡaneiku! Nukusi tana fakwakaoḡo? Ana kunuwanekaoḡoweimi? Gwadimonamona kwa nemiyei nenekuwai.” ");
INSERT INTO wat_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eketa gwadimonamona si nemiiya Yeisu nenei. Tovanama kanunu goyona Yeisu i kitiya, gwadimonamona i nikuniya fifiwanina eketa i fekuwa fwayafwayai. Keta i vikenobwatabwataviniya na kawatefutefunina. ");
INSERT INTO wat_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeisu gwadimonamona amana i nutoniiya i bwaduwa, “Namaise kana nubwayou nofemaise i fufufuna?” Amana i nufata i bwaduwa, “Fwefweyanei i vibutuwa. ");
INSERT INTO wat_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kanunu goyona nuwanuwana be ina nuvimatiya na fasinei tamo tova i tuḡatuḡaiya kikanakanatai yota ukowai. Taki ka fata maise, kuta sineganiganiikiya be kuta ovivitikiya.” ");
INSERT INTO wat_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeisu i iyaviya i bwaduwa, “Ava uḡuna yo ku iyaiyaveiku taki kaku fata maise? Tanake aitevana Guyau ina vitumaḡaniya, Guyau iba matatafuna ina fufunisiya fasinei.” ");
INSERT INTO wat_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Muka mwanenena eatu gwadimonamonanama amana i fina i bwaduwa, “Na yaku vitumaḡana eatu muka nakasina, ku oviviteiku be ku givinakasiya.” ");
INSERT INTO wat_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eatu Yeisu i kitisiya sabu si yokoyokwiya eketa kanunu goyona i visimeiya i bwaduwa, “Taniyakweu keta meyadanu kana kanunu goyona, a vivisimeiwa namoḡa kuna teweiya keta muka yota kuna kanasuna-savavineu.” ");
INSERT INTO wat_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kanunu goyona i tatakwayana eketa gwadimonamona i nikuniya fifiwanina keta i gionoviya. Gwadimonamonamokena kana fusa vitana namoḡa matematena, eketa namoḡa yagwanisi nokomai si bwaduwa, “Naki i mateya!” ");
INSERT INTO wat_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eatu Yeisu nimanei i ova i sinanakasiya eketa gwadimonamona i otowamisiniya. ");
INSERT INTO wat_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Muninei Yeisu i kanasuna numai eketa kana kisina nenei kana tomuniyeina si nutoninuvenuveiya si bwaduwa, “Ava uḡuna muka kama fata kanunu goyona kata nukakiya?” ");
INSERT INTO wat_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eketa i iyavisiya i bwaduwa, “Naki kawanunukuḡa nenei kana fata nofe kanunusima goyosi tana nukakisiya.” ");
INSERT INTO wat_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeisu tomuniyeina nukusi noko kabaḡanama si teweiya eketa si vaonota Ganiniyei. Yeisu muka nuwanuwana tamo aitevana ina sanamanei tanake namai, ");
INSERT INTO wat_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","be vitana nuwanuwana simo yana tova matanubwayouna ita viya be kana tomuniyeina nenesiyai ita visawavenisiya. I iyavisiya i bwaduwa, “Namoḡa Natuna sina viwaifufuniya keta nifanifaina nimasiyai sina teniya keta sina nuvimatiya, eatu kuyadayada tonusi muninei mateyai ina misini-savaviniya.” ");
INSERT INTO wat_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nofemaise i nusifufuwisiya eatu muka nuwatasi ita mayesiya, si matuta eketa yana bwadunama fasinei muka sita nutonikuyekuyei. ");
INSERT INTO wat_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Si kikinomana menana Kafenaumi nenei keta numa tamokaḡa sinenei si kanasuna eyo Yeisu i nutoninuvenuvisiya i bwaduwa, “Avamasi ketai kwa vikanusifusifufuwei?” ");
INSERT INTO wat_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Atu matatafusi si manava uḡuna ketai si vikawabwadubwaduwa aitevana sinesiyai nakatamokena. ");
INSERT INTO wat_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","I fakwasiotoḡa eyo yana tonowana kasi 12 i wenisiya si nemiya eketa i bwaduwa, “Taki aitevana nuwanuwana ina viketanuna nao tauna ina tenemuniukwaniya eketa ina vitovikaetoḡa namoḡa matatafusi fasisiyai.” ");
INSERT INTO wat_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gwadimonamona i viya kasi kawasasai i vimisiniiya eyo i nutaviya eketa i iyavisiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Taki aitevana tamo nofe gwadimonamonanama maise ina katuviya kaku wavai, nao ina katuvikuwa. Yota aitevana ina katuvikuwa nao muka Iyauḡa ita katukatuvaiku eatu yota kaku tovininita i katukatuviya.” ");
INSERT INTO wat_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoni Yeisu i iyaviya i bwaduwa, “Tovisawavenena, namoḡa ka kitiya kanunu goyosi i nunukakisiya ka wavai. Atu tanake o muka kata sabu, na fasinei ka iyaviya be ina onoviya.” ");
INSERT INTO wat_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Atu Yeisu i bwaduwa, “Muka kwana sawatanai uḡuna muka kana fata be tamo aitevana kaku wavai iba fifiwanina ina savivinei eatu kakimokimokima tu yota iba goyosi ina bwaduweisi fasikuwai. ");
INSERT INTO wat_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Taki aitevana muka ina vinifaineita nao tana kata sabu. ");
INSERT INTO wat_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A iyaiyavimiya venemokena, taki aitevana ukowa ina venimiya uḡuna kwami kaku tomuniyeina, nao naki maisemoka fatana ina nisaiya.” ");
INSERT INTO wat_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","I tenesaviya i bwaduwa, “Nofe fiyagenagenasima kaku tovitumaḡana, eatu taki aitevana go'yona nenei ina weifekusiya, nao Guyau vimatadawana nakatamokena ina veniya. Muka maise gabana nakasina kayonei sina nusifwiya yo gibowai sina vigamomoniya. ");
INSERT INTO wat_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Taki nimau go'yona nenei ina teniwa, nao ku dabateweyei. Kana nufota be nima fafaniuḡa nenei kuna kanasuna yawasivaḡata nenei muniyai yo nimau nuwesi nukusi kuna kanasuna kikanakanata muka yana kweunuvanuva kana kabaḡai. ");
INSERT INTO wat_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Taki kaeu go'yona nenei ina teniwa, nao ku dabateweyei. Kana nufota be kae fafaniuḡa nenei kuna kanasuna yawasivaḡata nenei muniyai yo kaeu nuwesi nukusi sina tewesobuwiwa kabaḡanama nenei. ");
INSERT INTO wat_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Taki matau go'yona nenei ina teniwa, nao ku mwamwateweyei. Kana nufota be mata fafana tamokaḡa nenei kuna kanasuna Guyau yana kafa visime nenei muniyai yo matau nuwesi nukusi sina tewesobuwiwa kabaḡanama nenei. ");
INSERT INTO wat_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Noko kabaḡanama nenei, ‘Mwatamwata muka simo yasi matenuvanuva namoḡa si kanikanisiya, yota kai kanakanata muka yana kafa kweu.’ ");
INSERT INTO wat_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kaku tomuniyeina matatafusi dauna sina nisaisiya kikanakanata maise, eatu mwavinana o Guyau ina givieyaeisiya. ");
INSERT INTO wat_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Gibo o iba dewadewana, atu tovanama kana onaona ina kakaviya, nao namaise tana nuvionaona-savavinei. Kwana fufuna maise kabwaga na gibona ina tava. Kwana fakwa na yami viyao.” ");
INSERT INTO wat_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yeisu kabaḡa noko i teweiya eatu i niya kawakawana Yudiya nenei eketa i tamana ukowa Yonidani fafaninei. Sabuveka si nemi-savavinisiya nenei eketa naki kana iduwa maise i vibutuwa nenesiyai i gisawakedana. ");
INSERT INTO wat_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fanasi tunisi nuwanuwasi be Yeisu sina anuvanuviya na fasinei si nemiya nenei eketa si nutoninuvenuveiya si bwaduwa, “Namaise, yata visime namoḡa i sawateweiya be kawana ina visobuwiya o muka?” ");
INSERT INTO wat_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eketa i nufata i bwaduwa, “Atu Mosese visime i venimiya o namaise i bwadu?” ");
INSERT INTO wat_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eketa si iyaviya si bwaduwa, “Mosese yana visime o namoḡa i sawateweiya ebe visobu kana nufunufu ina viginiwiya eketa kawana ina veniya, muniyai yo gumayogu ina teweiya ina niya.” ");
INSERT INTO wat_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Atu Yeisu i nufata keta i iyavisiya i bwaduwa, “Katekatemi yasi gua fasinei Mosese visime nofe i viginiwiya fasimiyai. ");
INSERT INTO wat_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Eatu kwana tukuya kafa viuḡuwai tovanama Guyau i kifufunavauvauwa, ‘Namoḡa keta gumayogu i fufunisiya.’ ");
INSERT INTO wat_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Na fasinei namoḡa amana keta ayona ina teweisiya eatu kawana nukusi sina saviya tamo nenei, ");
INSERT INTO wat_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","eketa kasi nuwa sina vitamokaḡa.’ Eketa muka nuwesi eatu naki tamokaḡa. ");
INSERT INTO wat_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na fasinei keta avana Guyau i viketosaviya muka tamo aitevana ina nutakai.” ");
INSERT INTO wat_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tovanama si makavinisiya numai, Yeisu kana tomuniyeina si nutoninuvenuve-savaviniya nofe ibanama fasinei. ");
INSERT INTO wat_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eketa i iyavisiya i bwaduwa, “Taki namoḡa kawana ina visobuwiya eatu tamo gumayogu ina vikawaniya nao naki i kudowa kawana nenei. ");
INSERT INTO wat_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Maise yota taki gumayogu kawana ina visobuwiya, eatu tamo namoḡa ina vikawaniya nao naki i kudowa.” ");
INSERT INTO wat_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tunisi namoḡa fiyagenagena si nemiisiya Yeisu nenei ebe nimana ina dawana nenesiyai. Eatu kana tomuniyeina fiyagenagena amamasi keta ayoayosi si dageisiya ebe muka Yeisu sina visinatamatamanei. ");
INSERT INTO wat_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tovanama Yeisu i kitiya avana i kikikinomana, i nuwagoyowa eketa i iyavisiya i bwaduwa, “Fiyagenagena kwana gionovisiya sina nemiya nenekuwai. Muka kwana sawatanaisi. Uḡuna Guyau yana kafa visime o tasike aviyaonana maisemoka fiyagenagena nofe. ");
INSERT INTO wat_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A iyaiyavimiya venemokena, taki aitevana Guyau yana kafa visime muka tamo ina katuvai maise gwadimonamona, muka kana fata ina kanasuna Guyau yana kafa visime nenei.” ");
INSERT INTO wat_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Fiyagenagena i nutavisiya kavaunei eketa nimana i dawana debabousiyai, eketa i sawanuwagabubuwisiya. ");
INSERT INTO wat_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yeisu i noḡokawawa keta yana ketai i niniya, eatu namoḡa tamokaḡa i dibwana i niya kaetutuna i viketogunisiya eketa i nutoninuvenuveiya i bwaduwa, “Tovisawavenena dewadewau, aviyavana ana fufuniya be yawasivaḡata ana nisaḡai?” ");
INSERT INTO wat_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eketa Yeisu i iyaviya i bwaduwa, “Ava uḡuna yo ku visawa-dewadewaiku? Naki Guyauḡa kana kisimokena dewadewana. ");
INSERT INTO wat_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kwaḡa naki ku sanamaniya Guyau yana visime. ‘Muka kuna nuvimate, muka kuna kudo, muka kuna gikuma, muka kuna meyanono tamo aitevana nenei, muka yasi nogonogomokeyai kuna nonoisi, yota amau keta ayou kuna vifotuwisiya.’” ");
INSERT INTO wat_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Eatu namoḡanama i bwaduwa, “Tovisawavenena, kabegokuwai kana nivaniva kimoki visimesima matatafuna a muniye-koḡoisiya.” ");
INSERT INTO wat_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeisu i kitanuwagabubuwiya keta i iyaviya i bwaduwa, “Iba tamokaḡamoka yawane muka kuta fufuniya. Kuna makaviniwa ya nogonogo matatafuna kuna vikimwaneisiya eyo gabanina goyogoyo kuna venisiya, eketa Guyau kaikaiwabu abamai ina veniwa. Eyo kuna nemiya kuna muniikuwa.” ");
INSERT INTO wat_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Namoḡanama o kaikaiwabuna eketa tovanama nofemaise bwadubwadunama i nowaniya, tafakaina i kanawenonowa eketa i misiniya na nuwatadaunina i niya. ");
INSERT INTO wat_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeisu i kitadadana eketa kana tomuniyeina i iyavisiya i bwaduwa, “Aviyaonana kaikaiwabusi nao yasi kanasuna Guyau yana kafa visime nenei daunamokena.” ");
INSERT INTO wat_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yana bwadunama fasinei kana tomuniyeina si mayaḡa eketa i iyave-savaviniya i bwaduwa, “Natunatuku, Guyau yana kafa visime kana kanasuna daunamokena. ");
INSERT INTO wat_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yomuyomu nakasina kameni o muka kana fata aima matana ina kanasunei. Naki maisemoka namoḡa kaikaiwabuna o muka kana fata Guyau yana kafa visime ina kanasunei.” ");
INSERT INTO wat_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kawasi i yaowa keta tututausiḡa nenesiyai si vikanunutoniya si bwaduwa, “Taki nanemaise nao aitevana gifafafana ina nisaḡai?” ");
INSERT INTO wat_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeisu i toneisiya keta i bwaduwa, “Namoḡa muka kasi fata be tututausi sina gifafafaneisi. Naki Guyauḡa kana fata, uḡuna iba matatafuna Guyau nenei meyameyanina.” ");
INSERT INTO wat_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eketa Fita i iyaviya i bwaduwa, “Ku nowaniya, atu kima namaise? Yama nogonogo matatafuna naki ka venuteweisiya munikiyai eatu ka munimuniiwa.” ");
INSERT INTO wat_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeisu i bwaduwa, “A iyaiyavimiya venemokena, taki aitevana yana numa be unaunana, nounouna, ayona, amana, natunatuna eketa yana baguna ina venuteweisiya eatu ina muniikuwa be biga dewadewana ina yauniya fasikuwai, ");
INSERT INTO wat_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nao fatana nakasina Guyau ina vifofwiya 100 na kana vifofo keta ina veniya nofe tovanama. Yana numa be unaunana keta nounouna yota ayoayona be natunatuna eketa yana baguna ina nisaisiya keta yota namoḡa sina givikuvavaniya, eatu tova i nenemiya nenei yawasivaḡata ina nisaiya. ");
INSERT INTO wat_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Atu yagwanisi aviyaonana nofe tova si viviketanuna nao sina vimunifota keta yagwanisi nofe tova si vivimunifota nao sina viketanuna.” ");
INSERT INTO wat_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yeisu ke'ta i nuniya eketa kana tomuniyeina nukusi si vanevaneya Yenusanema, kana tomuniyeina o si wagavana yota namoḡa tunisi si munimuniiya o si matuta. Yana tonowana kasi 12 i katuvisiya eketa i vibutuwa i nusifufuwisiya iba matatafuna yawane ina kikinomana nenei fasinei. ");
INSERT INTO wat_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yeisu i bwaduwa, “Kwa nowaniya, nofe naki ta niniya Yenusanema eketa nokomai tamo aitevana Namoḡa Natuna ina katuteweiya tovibwanaose nakanakasisi eketa visime kana tovisawavenena nenesiyai. Sina sawavimatiya eketa Kani Kwauna nimasiyai sina teniya. ");
INSERT INTO wat_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Sina sawaviniiya yota sina nufunataniya. Sina nafanafasiya eketa sina nuvimatiya. Atu kuyadayada tonusi muninei mateyai ina misini-savaviniya.” ");
INSERT INTO wat_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tamo tova nenei Sebedi natunatuna Yemesa keta Yoni si nemiya Yeisu nenei eketa si bwaduwa, “Tovisawavenena, aviyavana kata vikokoniwa nuwanuwaki kuta fufuniya fasikiyai.” ");
INSERT INTO wat_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eketa i nutoninuvenuveisiya i bwaduwa, “Avana nuwanuwami ata fufuniya fasimiyai?” ");
INSERT INTO wat_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eketa si bwaduwa, “Tovanama ka kwabudoga na kana kaiwabu nenei kuna nuvitoḡa kuta sawateweikiya be nukusi tata nuvitoḡa. Tamo kikikataiweu eatu tamo o kikimawaweu.” ");
INSERT INTO wat_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Atu Yeisu i iyavisiya i bwaduwa, “Muka kwata sanamanei ava fasinei kwa vivikokoneiku. Kuvavana owana ana yumiya, kami fata maise yota kwana yumiya? O kami fata givibutabuta kwana viya maise sina givibutibutikuwa?” ");
INSERT INTO wat_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Si iyaviya si bwaduwa, “Kama fata.” Eketa i iyavisiya i bwaduwa, “Owanama ana yuwiiya nenei kwana yuwa, yota sina givibutibutikuwa maisemoka yota sina givibutibutimiya. ");
INSERT INTO wat_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Eatu muka kaku sawateweyeina ebe ana gibokeisi aviyaonana kukikikataiku o kukikimawaku sina nuvitoḡa. Guyau noko kivisima i gidewidewisiya aviyaonana naki i gibokisiya fasisiyai.” ");
INSERT INTO wat_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tovanama tonowana kasi 10 si nowaniya Yemesa eketa Yoni yasi vikokona Yeisu nenei si kayokuḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yeisu yana tonowana matatafusi i wenevakukusisiya eketa i iyavisiya i bwaduwa, “Kwami naki kwa sanamaniya. Aviyaonana Kani Kwauna kasi tovisime nuwanuwasi be yasi namonamoḡa sina vivisimeisiya, keta yota yasi namoḡa nakanakasisi visime daudaunisi nenesiyai si viviketanunisiya. ");
INSERT INTO wat_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Atu kwami o muka noko ketaketanama nenei kwana fufuna. Taki aitevana tamo sinemiyai nuwanuwana ina vikainakata, nao ina vitovikaetoḡa fasimiyai. ");
INSERT INTO wat_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Taki sinemiyai aitevana tamo nuwanuwana ina viketanuna, nao tanake ina vitovikaetoḡa matatafumi fasimiyai. ");
INSERT INTO wat_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maisemoka Namoḡa Natuna muka ita nemai ebe namoḡa sina vikaetoei, eatu i nemiya be namoḡa ina vikaetoisiya eketa tauna yana nuwanuwai yawasina ina kaveneniya be namoḡa yagwanisi ina tutuvisobusiya.” ");
INSERT INTO wat_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yeisu kana tomuniyeina nukusi si kikinomana Yeniko eketa tovanama noko menaninama si teweiya, namoḡa sagisagigi si muniisiya. Namoḡa tomatagoyo kana wava Batimiyosi, Timiyosi natuna, ke'ta kafakainei i nuvitoḡa atu gabana fasinei i vivikokona. ");
INSERT INTO wat_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tovanama i nowaniya namoḡa si bwaduwa Yeisu tene Nasaneti i niniya eketa i bwauwa i bwaduwa, “Yeisu, Deivida natuna, kuta kitasineganiganiikuwa.” ");
INSERT INTO wat_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Namoḡa yagwanisi si dageiya keta si iyaviya be ina kanoviya. Eatu i tenegwaeiya kayona nakasinei i bwaubwauwa, “Yeisu, Deivida natuna, kuta kitasineganiganiikuwa.” ");
INSERT INTO wat_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeisu i nigwana eketa i bwaduwa, “Kwa iyavei be i nemai nofemai.” Eketa tomatagoyo si weniya si bwaduwa, “Katekateu i vatu be ku otowamisini! Yeisu i weneweniwa.” ");
INSERT INTO wat_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Batimiyosi kana kwame i nukasibibiiya eatu i venuotowamisiniya eketa i nemiya Yeisu nenei. ");
INSERT INTO wat_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeisu i iyaviya i bwaduwa, “Ava ya nuwanuwa ata fufuniya fasiweu?” Eketa tomatagoyo i nufata i bwaduwa, “Tovisawavenena, nuwanuwaku ana toneya.” ");
INSERT INTO wat_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeisu i iyaviya i bwaduwa, “Ku nai, ya vitumaḡana i givibwiniwa.” Muka mwanenena atu matana si kabwasasa eketa i vibutuwa Yeisu i muniiya ketai. ");
INSERT INTO wat_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tovanama Yeisu kana tomuniyeina nukusi Yenusanema si vevenukitekitiya, si nemiya menana Betifegi keta Bedani nenesiyai koya Onive nenei. Yeisu kana tomuniyeina nasi nuwa i visimeisiya keta si venuviketanuna. ");
INSERT INTO wat_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","I iyavisiya i bwaduwa, “Kwana niya menana kutafakaita. Tovanama kwana kikikinomana nokomai, kwana nisaiya doniki mwanavauna si nusikwaniya muka tamo aitevana ita toḡa-nuvanuvai. Kwana giyauya eketa kwana nemiiya. ");
INSERT INTO wat_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Taki aitevana ina bwaduwa, ‘Ava uḡuna kwa gigiyauya?’ Nao kwana iyaviya kwana bwaduwa, ‘Tuveka nuwanuwana fasinei, eyo ina venuviyewiya nofemai.’” ");
INSERT INTO wat_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tonowana kasi nuwa si kanasuna menana sinenei, eketa doniki mwanavauna si kitiya ketai i misimisiniya nunusikwanina numa kana ketakawana niniunei. Tovanama si gigiyauya, ");
INSERT INTO wat_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","namoḡa tunisi niniunei si misimisiniya si nutoninuvenuveisiya si bwaduwa, “Ava fasinei yo doniki mwanavauna kwa gigiyauya?” ");
INSERT INTO wat_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eatu namoḡa nenesiyai si nufata naki maisemoka Yeisu i iyavisiya, na uḡuna si sawateweisiya. ");
INSERT INTO wat_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tovanama doniki mwanavauna si nemiiya Yeisu nenei, kasi kwame si tewevanevaneina doniki kwaunei eketa i toḡatakutakunisiya. ");
INSERT INTO wat_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Namoḡa yagwanisi kasi kwame ketai si kiyavena eatu tunisi o kai naḡanisi na dadasi si nuonota eketa si kiyavena. ");
INSERT INTO wat_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eketa namoḡa si viketanuna kunauna yota muni si fotiya, si vibutuwa si bwaubwauwa, “Osana! Tuveka kana wavai i nenemiya tana daviya. ");
INSERT INTO wat_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tana daviya waḡata Deivida natuna tanake i nenemiya ina visimeita, Osana etanemokenei abamai!” ");
INSERT INTO wat_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeisu i kanasuna Yenusanema eketa i niya Numa Kodukodu nenei. Iba matatafuna i dadaniya eatu naki i vinavinavimoka, na fasinei yana tonowana kasi 12 nukusi si kikinomana eketa si niya Bedani. ");
INSERT INTO wat_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kuyadayada venuwanei Yeisu kana tomuniyeina nukusi tovanama Bedani si teweiya, Yeisu vitanona i kanasiya. ");
INSERT INTO wat_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kedawanauwai kai nugweda i vidada i kitiya eketa i niya vitana tamo uwana ina nisaiya, eatu kainama o muka kana tutuya ebe ina viuwa na fasinei dadanaḡa i kitiya. ");
INSERT INTO wat_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eketa Yeisu kai i iyaviya i bwaduwa, “Mukamokena tamo aitevana uwau nenei ina ka-savavinei.” Eketa bwadunama kana tomuniyeina si nowaniya. ");
INSERT INTO wat_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tovanama si nemiya Yenusanema, Yeisu i kanasuna Numa Kodukodu kumenanina kana wasiketai keta tovikimwane i nukwavikwavina si kikinomana. Gabana kana todawanatamatamaneina yasi sonama yota bunebune kasi tovikimwane yasi kafa nunuvitoḡa i nubwatabwatavina, ");
INSERT INTO wat_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","eketa i viketofotisiya be muka tamo aitevana aviyavana tamo ina kanasunei ina vaonota Numa Kodukodu kumenanina kana wasiketai. ");
INSERT INTO wat_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eketa i gisawakedanisiya i bwaduwa, “Kwa sanamaniya Guyau fonakituna i bwaduwa, ‘Yaku numa sina weniya kawanunuku kana numa kunuma matatafusi fasisiyai.’ Atu kwa fufufuniya maise ‘togikuma yasi kafa makaviuna.’” ");
INSERT INTO wat_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tovibwanaose nakanakasisi eketa visime kana tovisawavenena nofe bwadunama si nowaniya. Eketa ketaketa si nuwasa ebe sina nuvimatiya. Si matutiya uḡuna yana gisawakedana nenei sabuveka si mayaḡa. ");
INSERT INTO wat_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tovanama i vivinavinaviya, Yeisu kana tomuniyeina nukusi Yenusanema si teweiya. ");
INSERT INTO wat_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nuwabuniyai si makamakavinisiya eatu si kitiya kai nugweda kikwanakwanaminei tu i vaneya dadanei naki i teweyayaniya. ");
INSERT INTO wat_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Fita Yeisu yana bwadu i tukuya eketa i iyaviya i bwaduwa, “Tovisawavenena, ku kitai! Kaima ku ituya naki i teweyayaniya!” ");
INSERT INTO wat_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeisu i iyavisiya i bwaduwa, “Guyau kwa vitumaḡanei. ");
INSERT INTO wat_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A iyaiyavimiya venemokena, taki aitevana tamo nofe koya ina iyaviya, ‘Ku sinanakasiu be ku tewesobuweu gibowai,’ eketa muka katekatenei ina vinuwana eatu ina vitumaḡaniya avana i bwaduwiya naki maisemoka ina kikinomana, nao Guyau ina fufuniya fasinei. ");
INSERT INTO wat_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na uḡuna a iyaiyavimiya, taki aviyavana tamo fasinei kwana kawakawanunukuwa eketa kwana vitumaḡaniya vitana naki kwa nisaiya, nao ina venimiya. ");
INSERT INTO wat_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tovanama kwana kawakawanunukuwa, nauna aitevana yana fufunagoyo nenemiyai kwana vinuwateweiya eyo muniyai, amami abamai yami go'yona yota ina vinuwateweina.” ");
INSERT INTO wat_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yeisu kana tomuniyeina nukusi si makavina-savavinisiya Yenusanema eketa tovanama i wanewaneba Numa Kodukodu kumenanina kana wasiketai, tovibwanaose nakanakasisi keta visime kana tovisawavenena yota tokawakawa si nemiya nenei, ");
INSERT INTO wat_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","eketa si nutoninuvenuveiya si bwaduwa, “Aitevana ya visime i veneu yo nofemaise ku savivinei? Namai ya visime ku vai?” ");
INSERT INTO wat_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeisu i iyavisiya i bwaduwa, “Nutoninuvenuveyeina tamokaḡa ana venimiya ebe taki kwana fatiya maise, nao ana iyavimiya avi visime nenei nofe ibasima a savisavivineisi. ");
INSERT INTO wat_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kwa iyaveiku, Yoni namai yana visime i vai yo i givibutabuta, abamei o namoḡa nenesiyai?” ");
INSERT INTO wat_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tututausiḡa si vikanunutoniya si bwaduwa, “Taki tana bwaduwa, ‘Abamei,’ nao ina bwaduwa, ‘Ava fasinei yo Yoni muka kwata vitumaḡanei?’ ");
INSERT INTO wat_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yota muka kata fata be tana bwadu, ‘Namoḡa nenesiyai.’” Sabuveka si matutisiya uḡuna namoḡa si sanamaniya vitana Yoni o Guyau yana tomatakawa. ");
INSERT INTO wat_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eketa si nufata Yeisu nenei si bwaduwa, “Muka kata sanamanei.” Eketa i iyavisiya i bwaduwa, “Muka yota ana iyaveimi avi visime nenei nofe ibasima a savisavivineisi.” ");
INSERT INTO wat_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Eketa Yeisu bwadusobusobuwai i iyavisiya i bwaduwa, “Namoḡa tamokaḡa genefi i baguniya eketa i kanififiniya. Genefi kana kafa vatanitani kana doko i yaniya yota kafa vimatagewagewaya kana numa i yoniya. Genefi bwibwiyaguna i tenetaniya keta tobaguna nimasiyai i teniya, atu i niya tamo fafani nenei. ");
INSERT INTO wat_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Oyuna kana tovai kaetoḡa tamokaḡa i visimeiya i niya tobagunasima nenesiyai be kana tuku ina viya. ");
INSERT INTO wat_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eatu tobagunasima kaetoḡa si tabiya eketa si munuya eyo si viyewiya makaekaena. ");
INSERT INTO wat_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kaetoḡa kana vinuwa i teweye-savaviniya nenesiyai, eatu debabounei si munuya eketa si givisinemumuya. ");
INSERT INTO wat_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tonibaguna kaetoḡa kana vitonu i visimeiya eatu si nuvimatiya. Yota yagwanisi i teweisiya atu tamokaḡa fufuninama si fufuniya, tunisi si munusiya atu tunisi o si nuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Naki tamokaḡamoka i tufowa o tauna natukatekatena. Tovanama i visimeiya tobagunasima nenesiyai, nuwasinenei i bwaduwa, ‘Nofe o natuku eketa sina vifotuwiya.’ ");
INSERT INTO wat_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tobagunasima tututausi si vikanunutoniya si bwaduwa, ‘Ake, tonibaguna natuna i nenemiya. Kwa dibwana, ta nuvimatei ebe yana baguna tana vitoniwagiya.’ ");
INSERT INTO wat_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gwadinama si givikaviniya si nuvimatiya eyo genefi baguna nenei si tewekikinomaniya.” ");
INSERT INTO wat_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Eketa Yeisu i nutoninuvenuveisiya i bwaduwa, “Namaise yami vinuwadadana? Tonibaguna ava ina fufuniya nenesiyai? A iyaiyavimiya, ina nemiya eketa ina nuvimatisiya. Eatu bagunanama ina tenetamaniya tamo yota tobaguna nimasiyai. ");
INSERT INTO wat_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Guyau fonakituna i bwaduwa, ‘Koḡonanama tokiyona si dibutoyoiya i visabuova. ");
INSERT INTO wat_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tuveka nofemaise i saviviniya keta kana kita dewabauna matatiyai.’” ");
INSERT INTO wat_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Diu toviketanuneina si sanamanemokiya Yeisu fasisiyai i nusifufuwa na fasinei ketaketa si nuwasa be sita givikaviniya, eatu sabuveka si matutisiya eketa si kitamokiya i fakwa atu si kafiyauyauna. ");
INSERT INTO wat_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Munifotai, Diu toviketanuneina tunisi Fanasi eketa Enoda kana tomuniyeina si visimeisiya Yeisu nenei vitana sina tonisebiya be tamo aviyavana ina bwaduwe-goyowiya. ");
INSERT INTO wat_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Si nemiya nenei eketa si bwaduwa, “Tovisawavenena, ka sanamaniya kwaḡa namoḡa venemokena. Muka tamo aitevana yana nusuyai kuta ninai yota Guyau yana ketaketa venemokena nenei ku vivisawavenena. Yamasi ku iyaveiki, takesi kata nufata Sisa nenei o muka?” ");
INSERT INTO wat_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yeisu naki i sanamanemokiya vitana si aanuvanuva be sina nonuya na fasinei i iyavisiya i bwaduwa, “Ava fasinei kwa aanuvanuva be kwana vikonaiku? Yamasi tamo gabana kwa nemiyei be a kitai.” ");
INSERT INTO wat_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tovanama si nemiiya nenei i iyavisiya i bwaduwa, “Aitevana mayamayauna eketa kana wava nofe gabana nenei?” Si bwaduwa, “Sisa.” ");
INSERT INTO wat_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eketa i iyavisiya i bwaduwa, “Make nao Sisa yana nogonogo kwa venei, eatu aviyavana Guyau fasinei nao Guyau kwa venei.” Yana nusifufu nenei si mayaḡa. ");
INSERT INTO wat_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi si vitumaḡana vitana mate nenei muka tamo misini-savavineina. Eketa tunisi si nemiya Yeisu nenei eketa si nutoninuvenuveiya si bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tovisawavenena, Guyau yana visime Mosese nofemaise i viginiwiya fasikiyai. Taki namoḡa kawana ina matemakanoviya eatu muka tamo natunatuna, nao kwafunina kana tufunuwa ina vikawaniya. Eketa tovanama ina vinatuna, nao tomate natunatuna. ");
INSERT INTO wat_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tova tamokaḡa namoḡa tufudenideni kasi 7 nenesiyai, kotokikinuna i vikawana eketa muka tamo natunatuna eatu i mateya. ");
INSERT INTO wat_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Eketa gwadiyei yota nekwafunanama i vikawaniya eketa muka tamo natunatuna eatu i mateya. Yota taisi kotokinenena i vikawaniya eketa muka tamo natunatuna eatu i mateya. ");
INSERT INTO wat_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tufudenidenisi kasi 7 nekwafuna si vikawaniya. Eatu muka tamo natunatusi atu si mateya. Munifotamokeyai nekwafunanama i mateya. ");
INSERT INTO wat_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kasi 7 nekwafunanama si vikawaniya eketa misini-savavineina kana tovai, aitevana o kawana venemokena?” ");
INSERT INTO wat_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeisu i nufata i bwaduwa, “Kwa sinatamaniya uḡuna muka kwata sanamanei Guyau fonakituna keta yota muka kwata sanamanei Guyau yana fiwana. ");
INSERT INTO wat_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tovanama mateyai sina misini-savavinisiya, muka sina vikawana atu sina fakwa naki maise Guyau kana kaetoḡa abamai. ");
INSERT INTO wat_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Atu mateyai yasi misini-savavineina fasinei, muka kwata ginaḡanaḡai Mosese yana nufunufu kisisiku nununuina fasinei? Noko viginiwanama sinenei Guyau i nusifufuwiya i bwaduwa, ‘Iyau o Ebenaamu yana Guyau, Aisake yana Guyau, eketa Yakobo yana Guyau.’ ");
INSERT INTO wat_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Eketa tanake o yawayawasisi yasi Guyau atu muka matematesi. Naki kwa sinatamaniya venemokena.” ");
INSERT INTO wat_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Visime kana tovisawavenena tamokaḡa i nemiya keta i nowanisiya Yeisu keta Sadusi si vivikawabwadubwaduwa. Tovanama i nowaniya Yeisu yana nufata kana dewadewana, i nutoninuvenuveiya i bwaduwa, “Guyau yana visime nenei, avi visime o nakatamataina?” ");
INSERT INTO wat_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeisu i nufata i bwaduwa, “Visime nakatamataina o nofe, ‘Isineni kwa vaneneḡa! Tuveka o yata Guyau eketa kana kisimokena Tuveka. ");
INSERT INTO wat_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Eketa Tuveka ya Guyau kuna nuwagabubuwiya katekateu matatafunei, yawasiu matatafunei be ya nuwanuwa matatafunei yota ya fiwana matatafunei.’ ");
INSERT INTO wat_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eyota visime kana vinuwa nao, ‘Unafafaniu kuna nuwagabubuwiya maise tauḡu ka nuwagabubu.’ Nofe nuwesi o nakatamataisi yo muniyai visime yagwanina.” ");
INSERT INTO wat_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eketa visime kana tovisawavenena i bwaduwa, “Tovisawavenena, ku bwaduwa dawaniniina. Bwadu venemokena tanake kana kisimokena yata Guyau eketa muka tamo yota aitevana. ");
INSERT INTO wat_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yata Guyau tana nuwagabubuwiya katekateta matatafunei yota yata nuwanuwa matatafunei be yota yata fiwana matatafunei. Eketa unafafanita tana nuwagabubuwiya maise tututauta kata nuwagabubu. Nofe visime nuwesi kasi muniyeina o nakatamokena muniyai yo yata vibwanaose keta yomuyomu kasi gumatatafu Guyau nenei.” ");
INSERT INTO wat_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tovanama Yeisu i kitiya namoḡa i nusifufuwa na yana nuwatasanamana, i iyaviya i bwaduwa, “Kwaḡa o muka ka kedawanau Guyau yana kafa visime nenei.” Noko muninei muka tamo aitevana ita katevatu be tamo nutoninuvenuveyeina Yeisu ita venei. ");
INSERT INTO wat_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yeisu i gigisawakedana Numa Kodukodu kumenanina kana wasiketai eatu i bwaduwa, “Namaise yo visime kana tovisawavenena si bwadubwadu vitana Togifafafana Gigibokeinana o Deivida natuna? ");
INSERT INTO wat_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kanunu Tafutafuna Deivida i viketiiya keta nofemaise i bwaduwa, ‘Guyau yaku Tuveka i iyaviya i bwaduwa, “Kukikikataiku ku nuvitoḡa vifotu kabaina nenei kana nivaniva nifanifaiu ana vatanisiya keta kaeyafayafaweu ana tenisiya.”’ ");
INSERT INTO wat_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deivida tauna o Togifafafana Gigibokeinana nenei i visawatuveka eketa namaise yo nenei yota ita visawanatuna?” Yana nusifufuwai sabuveka nuwatasi i oviya. ");
INSERT INTO wat_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yeisu yana gisawakedana nenei yota i bwaduwa, “Matami ina kanakasiya visime kana tovisawavenena nenesiyai. Yasi waneba nenesiyai, nuwanuwasi nuya dewabausi sina kotokotonisiya. Nuwanuwasi sabu namoḡa vifotuwai sina venuvenuyofiyofisiya kabaḡa kafa vivitamaneina nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yota nuwanuwasi kivi dewadewasiḡa numa kafa yokoyoko sinesiyai, maise yota ka kana tovai nuwanuwasi kawakawa kasi kivi nenesiyai sina nunuvitoḡa. ");
INSERT INTO wat_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yasi kawanunuku o nubwanubwayousi ebe namoḡa sina davisiya, eatu tasike namoisima o vivinekwafukwafuna yasi numa kasi nogonogo si kakanema. Guyau ina vimatadawanisiya nakatamokena.” ");
INSERT INTO wat_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Numa Kodukodu kumenanina kana wasiketai Yeisu kavenenakaoḡo kana koni kutafakainai i fakwasiotoḡa eatu sabu i vivinanusiya yasi gabana si kikivitotoḡa. Namoḡa yagwanisi kaikaiwabusi yasi gabana nakanakasisi si dawana. ");
INSERT INTO wat_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eatu negoyogoyo nekwafuna si nemiya keta gabana nuwesi musumususi si totoisiya. ");
INSERT INTO wat_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eketa kana tomuniyeina i wenisiya si nemiya keta i iyavisiya i bwaduwa, “A iyaiyavimiya venemokena, negoyogoyo nekwafuna o yasi kavenenakaoḡo nakatamataina muniyai yo namoḡa matatafusi. ");
INSERT INTO wat_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Uḡuna namoḡa kaikaiwabusi o yasi gabana matatafumokena i fakwa atu kasiminaḡa si teniya yasi kavenenakaoḡo fasinei, eatu noko negoyogoyomoka o yasi kinofe tausi kasi ovivita fasinei, matatafumokena si nubutuya.” ");
INSERT INTO wat_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tovanama Yeisu Numa Kodukodu sinenei i kikinomana, kana tomuniyeina tamokaḡa i iyaviya i bwaduwa, “Tovisawavenena, numa nofe dewabausi ku kitaisi keta yota gabana kitagoyosi nenesiyai si kiyona.” ");
INSERT INTO wat_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eketa Yeisu i bwaduwa, “Numasima nofe kitagoyosi ku kitikitisiya o yawane matatafusi sina yakwena-koḡoisiya. Muka tamo gabana ina tufo naki matatafuna sina tewesobuwe-koḡoiya.” ");
INSERT INTO wat_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yeisu koya Onive nenei i nuvitoiya eketa i kitatamana Numa Kodukodu kuweyaina. Tovanama nenei, Fita, Yemesa, Yoni eketa Anideneya tasikeḡa si nemiya si nutoninuvenuveiya si bwaduwa, ");
INSERT INTO wat_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Yamasi kuta iyavikiya, nofe ibasima ku iyaiyavikiya o avi tovai sina kikinomana. Avi kiyakiyaya nenei kana sanamanei vitana nofe ibasima o kabegomokena sina kikinomana?” ");
INSERT INTO wat_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eketa Yeisu i iyavisiya i bwaduwa, “Matami ina fekuwa ebe muka tamo aitevana ina nonoimi. ");
INSERT INTO wat_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yawane namoḡa yagwanisi sina nemiya eketa kaku wavai sina bwaduwa, ‘Make iyau togifafafanamokeku.’ Nofe nenei yawane namoḡa yagwanisi sina nonusiya. ");
INSERT INTO wat_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Muka kwana kate-kuvavana taki aviya bigana kwana nowaniya ketamwakufwai o kedawanauwai. Nofe ibasima o sina mikikikinomana eatu nai o muka vitana tova kana kafa nusafu. ");
INSERT INTO wat_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tamo kunuma ina misiniya keta tamo kunuma ina vikaniyabiniya. Yota tamo kafa visime ina misiniya keta tamo kafa visime ina vikaniyabiniya. Yawane nikuniku ina kikinomana kabaḡa tunisitunisi nenesiyai. Yota noga ina kikinomana. Nofe ibasima nao maise vinatuna kana kuvavana kana kafa viuḡu. ");
INSERT INTO wat_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tututaumi kwana kitavikavina-dewidewimiya. Namoḡa sina givikavinimiya keta menana kasi toviketanuneina nimasiyai sina tenimiya. Yota numa kafa yokoyoko nenesiyai sina munumiya. Yawane kasi tovisime keta tufomu nausiyai sina vimisiniimiya eatu sina vinuesanimiya uḡuna kwami kaku tomuniyeina. Nokomai wakakaku kwana siya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Muniyai yo kafa nusafu, nauna biga dewadewana kaku tomuniyeina sina yauniya kunuma matatafusi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tovanama sina givikavinimiya eketa sina vinuesanimiya, muka kwana nuwanuwa aviyavana kwana nusifufuwiya fasikuwai uḡuna kwami muka tututaumi yami nuwanuwai kwana nusifufu. Eatu Kanunu Tafutafuna yami nusifufu ina gidawadawaniniiya. Na fasinei keta avana Guyau ina venimiya maise, naki kwana bwaduwe-kikinomaniya. ");
INSERT INTO wat_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Namoḡa tauna kana tufunuwa ina viwaifufuniya eketa nifanifaisi sina nuvimatiya. Ama naki maisemoka tamoka fufuninama nenei natuna ina dewiya. Natunatu sina misiniya ayoayosi be amamasi nenesiyai sina maniniya eketa sina viwaifufunisiya kasi nuvimate fasinei. ");
INSERT INTO wat_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Namoḡa matatafusi sina adibutoyotoyoimiya uḡuna Iyau kwa munimuniikuwa. Eatu taki aitevana ina kunuwaniya be ina muniikuwa kana nivaniva kafa nusafu, nao tanake Guyau ina gifafafaniya.” ");
INSERT INTO wat_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tovanama iba goyomokena kwana kitiya kabaḡa vivikanatafuna nenei namai muka kana nufota nenei ina misini atu nenei i misimisiniya, (Nufunufu nofe kana toginaḡanaḡa kwata nuwatasanamaniya avana a bwadubwaduwiya.) enao aviyaonana fafani Yudiya nenei si fakwafakwa sina dibwana koyai. ");
INSERT INTO wat_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Eatu taki aitevana yana numa kana kudukudu etanei ina fakwafakwa, nao muka ina kanasuna numa sinenei yana nogonogo ina vaisi, ");
INSERT INTO wat_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","maisemoka yota aitevana yana bagunai ina bagubaguna, muka ina makavinai numai kana kwame fasinei. ");
INSERT INTO wat_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Noko tovanama nenei vivisifuḡa keta tovisusu sina vimainuwinuwiya venemokena. ");
INSERT INTO wat_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Eatu Guyau nenei kwana kawakawanunukuwa be nofe ibasima muka tutuya goyonei sina kikinomana. ");
INSERT INTO wat_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Noko tovasima nenesiyai kuvavana nakasina ina kikinomana, muka tamo maise kuvavananama ita kikinomana tovanama Guyau fwayafwaya i fufunavauvauya kana nivaniva kimoki. Yawane nofemaise kuvavananama muka yota ina kikinomana-savavinei. ");
INSERT INTO wat_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Eatu noko tovasima o Tuveka naki i givibwatisiya. Taki muka, nao namoḡa matatafusi sita matekooḡa. Eatu i givibwatisiya ebe nuwanuwana aviyaonana i gibokisiya tauna fasinei ina gifafafanisiya. ");
INSERT INTO wat_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Yawane togifafafana gigibokeinana keta tomatakawa vikanonono sina nemiya keta kiyakiyaya kafa nuwatabau sina savivinisiya. Ebe taki kasi fata maise Guyau yana namonamoḡa gigibokeinasi nuwatasi sina kaniya. Taki tamo aitevana ina iyavimiya ina bwaduwa, ‘Ei, nofe Togifafafana Gigibokeinamokena,’ o taki ina bwaduwa, ‘Ake, noko namoḡamokena.’ Nao muka bwadunama kwana vitumaḡanei. ");
INSERT INTO wat_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Eketa matami ina fekuwa. Eatu a matamatakawe-vaḡasimiya ebe yo na yami gidewadewa tovanama ibasima sina kikinomana.” ");
INSERT INTO wat_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Noko tovasima nenesiyai tovanama kuvavana nakasina ina kakaviya. ‘Vanavana ina vikumanovana keta yota yamayamana muka ina tafa. ");
INSERT INTO wat_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Abamei kinavinavi sina kafifekufekuwa keta yota iba fifiwanisi abamai ina kayufeyufisiya.’ ");
INSERT INTO wat_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tovanama nenei Namoḡa Natuna sina kitiya busibusi nenei ina nenemiya na yana fiwana nukusi keta na yana kaiwabu. ");
INSERT INTO wat_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eyo Guyau kana kaetoḡa abamei ina visimeisiya sina niya. Bomatuwei, gagasei, nanakoyei keta yavanatei, fwayafwaya be abama bwatanei tu bwatanei yana namonamoḡa gigibokeinasi sina katuvivisiya tamokaḡa.” ");
INSERT INTO wat_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kafa kita o kai nugweda nenei kwana kitasanamaniya. Tovanama naḡanina mwanavauna sina vikiviyavena nao kwa sanamaniya nugutabo kana tova i niketamwakufwa. ");
INSERT INTO wat_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Naki maisemoka tovanama nofemaise ibasima kwana kitisiya sina savisavivina nao kwa sanamaniya Namoḡa Natuna yana nemi naki i niketamwakufwamoka. ");
INSERT INTO wat_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A iyaiyavimiya venemokena, nofe susunama yasi tovai nofe ibasima sina mikisavivina muniyai yo sina kafimatemateya. ");
INSERT INTO wat_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Abama keta fwayafwaya sina kaoḡoniya atu fonaku muka ina kaoḡoniya.” ");
INSERT INTO wat_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Muka tamo aitevana ita sanamanei kana kuyadayada o kana kawasasa avi tovai ibasima nofe sina savivina, mukamokena Guyau kana kaetoḡa abamai o taki Natuna tauna. Naki Amanaḡa i sanamaniya. ");
INSERT INTO wat_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kuna tonetoneya keta kuna gigidewadewa uḡuna muka kuta sanamanei kana tovamokena. ");
INSERT INTO wat_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Naki maisemoka tovanama namoḡa tamo yana numa ina venuteweiya eatu ina niya kedawanauwai, kana kaetoḡa tamokatamokaḡa yasi mudadava ina kavenena yota kawa kana tokitavikavina ina iyaviya be ina kitakitanufota. ");
INSERT INTO wat_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kwami yota naki maisemoka kwana kitakitanufota, uḡuna muka kwata sanamanei toninuma yana makavina. Taki ina nemiya navinaviyai o kamo nuwabuna sinefouna o kamo kamukamu yasi kwae kana tovai o taki tovakatakiyai. ");
INSERT INTO wat_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kwana gigidewadewa ebe tovanama ina nikikinomana muka ina nisaḡaimi kwana banubanu. ");
INSERT INTO wat_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Avana a iyaiyavimiya, naki maisemoka yota namoḡa matatafusi a iyaiyavisiya, ‘Kwana tonetoneya!’” ");
INSERT INTO wat_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Naki kuyadayada nuwesimoka muniyai yo Venuvisinatana keta Maneka Muka Nakana Nutuva Kana Ka ina nisaiya. Tovibwanaose nakanakasisi keta visime kana tovisawavenena ketaketa si nuwasa be Yeisu sita givikavina-samwagauwiya ebe sita nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Si bwaduwa, “Muka ka kana tovai tana givikaviniya, akata namoḡa sina nuwagoyowa keta vigwaeḡa sina vibutuya.” ");
INSERT INTO wat_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yeisu i niya Bedani namoḡa kana wava Saimoni yana numai. Namoḡanama o nauna kwafinina gosagosawina. Nokomai si kakawa atu gumayogu tamokaḡa bubu mamadina yota fatana kitagoyona kana wava nadi na konina i kanasunanemiya. Kana koni si fufuniya anabasita nenei. Kayona i gikotoviya keta bubunama Yeisu debabounei i siwaiya. ");
INSERT INTO wat_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aviyaonana namoḡa nokomai si kayokuḡa keta tututausi si vikagigigamana keta si bwaduwa, “Ava uḡuna yo bubu noko mamadina i vivinuwateweteweyei? ");
INSERT INTO wat_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kana nufota be manamana tamokaḡa tobunanige fatana 300 siniva maise nenei ita vikimwaneiiya keta gabaninama goyogoyo ita venisiya.” Eketa si dageiya. ");
INSERT INTO wat_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Atu Yeisu i iyavisiya i bwaduwa, “Kwa tenei nuwatanei be ava i fufufuniya o i fufuniya. Nofe o iba dewadewana i fufuniya nenekuwai. Atu ava fasinei yo kwa visinatamatamanei? ");
INSERT INTO wat_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kwami tova matatafuna goyogoyo nukusi kwa fakwafakwa eketa avi tovai nuwanuwami maise enao kwana ovivitisiya. Eatu Iyau o muka tova matatafuna nukusi tana fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Avana kana nufotai maise naki i fufuniya. Bubu mamadina tofwakuwai i siwaiya be tofwaku i gidewadewavaḡasiya kaku odewadewa fasinei. ");
INSERT INTO wat_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A iyaiyavimiya venemokena, tovanama biga dewadewana fasikuwai fwayafwaya kana matatafu sina yauniya, avana gumayogu nofe i fufuniya nenekuwai yota kana kafa tuku fasinei sina numamaniya.” ");
INSERT INTO wat_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Noko tovanama nenei Yudasa Isikaniyoti tanake tamokaḡa tonowana kasi 12 sinesiyai i niya tovibwanaose nakanakasisi nenesiyai Yeisu kana viwaifufuna fasinei. ");
INSERT INTO wat_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tovanama si nowaniya sebobo i tewesafusiya eketa yasi bwadudabadaba si veniya si bwaduwa, “Gabana kana veniwa” eketa Yudasa ketaketa i nuwasa be nimasiyai ina teniya. ");
INSERT INTO wat_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Maneka Muka Nakana Nutuva Kana Ka kana kuyadayada kafa viuḡu nenei, sifi mwanavausi si munumunuwa Venuvisinatana Kana Ka fasinei. Na kuyadayadanama nenei Yeisu kana tomuniyeina si nutoninuvenuveiya si bwaduwa, “Namao nuwanuwau Venuvisinatana Kana Ka kata gidewadewai fasiweu?” ");
INSERT INTO wat_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eketa kana tomuniyeina nasi nuwa i iyavisiya i bwaduwa, “Kwana kanasuna Yenusanema keta namoḡa tamokaḡa tukwava na ukowina i uniuniya ina nisaimiya. Na gwadinama kwana muniiya, ");
INSERT INTO wat_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","eketa avi numai ina kanasuna, toninuma kwana iyaviya kwana bwaduwa, ‘Tovisawavenena i bwaduwa, “Nama totomunama nenei kaku tomuniyeina nukusi Venuvisinatana Kana Ka kata kawiyei?”’ ");
INSERT INTO wat_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eketa totomu nakasina gigidewadewana kuetana ina visawavenimiya. Nokomai iba matatafuna kwana gidewadewiya fasitiyai.” ");
INSERT INTO wat_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yeisu kana tomuniyeina si noḡokawawa eketa si niya Yenusanema avana Yeisu i iyavisiya maisemoka i kikinomana keta si gidewadewa Venuvisinatana Kana Ka fasinei. ");
INSERT INTO wat_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tovanama i vimatasisinovanovana Yeisu yana tonowana kasi 12 nukusi si kikinomana. ");
INSERT INTO wat_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sonamai si kakawa atu Yeisu i bwaduwa, “A iyaiyavimiya venemokena, namoḡa tamokaḡa sinemiyai ina viwaifufunikuwa, namoḡanama nukusi ta kakawa.” ");
INSERT INTO wat_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nuwatasi i dauna eketa tamokatamokaḡa si iyaviya, “A sanamanikuwa iyau muka.” ");
INSERT INTO wat_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","I iyavisiya i bwaduwa, “Kami 12 sinemiyai aitevana kana maneka Iyau nukusi kabomai ina kutuviya, na tana namoḡanama. ");
INSERT INTO wat_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Namoḡa Natuna ina mateya naki Guyau fonakituna i bwaduwa maisemoka, eatu aitevana Namoḡa Natuna i viwaifufuniya nao daunina venemokena ina nisaiya. Kana nufotamoka be ayona muka sita vinatunei.” ");
INSERT INTO wat_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tovanama si kakawa nenei, Yeisu maneka i viya eketa i kawanunuku-viagigikuwa. Eketa i gisiniya eyo kana tomuniyeina i venisiya keta i bwaduwa, “Kwa vai, nofe o tofwaku.” ");
INSERT INTO wat_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yota owa i viya keta Guyau nenei i viagigikuwa eyo i venisiya eketa owanama nenei si yuwa. ");
INSERT INTO wat_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Eketa i iyavisiya i bwaduwa, “Nofe o ufaufaku, yawane ina ketosiwaḡa namoḡa yagwanisi fasisiyai keta Guyau yana dedeni kwami nukusi ina givifakiniya. ");
INSERT INTO wat_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A iyaiyavimiya venemokena, muka tamo nofemaise waininama ana yunuvanuvai kana nivaniva Guyau yana kafa visime nenei waini kiouna ana yumiya.” ");
INSERT INTO wat_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eyo si osedavadava muniyai yo si kikinomana keta si niya koya Onive nenei. ");
INSERT INTO wat_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yeisu i iyavisiya i bwaduwa, “Matatafumokemi kwana butuwa atu kwana sinanovikuwa uḡuna Guyau fonakituna viviginiwina i bwaduwa, ‘Tokitavikavina ana nuvimatiya keta sifi sina venusavaneneḡa.’ ");
INSERT INTO wat_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Atu tovanama mateyai ana misini-savavinikuwa, ana viketanuna Ganini.” ");
INSERT INTO wat_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Atu Fita i iyaviya i bwaduwa, “Yawane sabu matatafusi sina butuwa atu iyau o muka.” ");
INSERT INTO wat_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Eketa Yeisu Fita i iyaviya i bwaduwa, “A iyaiyaviwa venemokena, kimoki nuwabunanama nenei kuna vikeweikuwa kawa tonu muniyai yo kamukamu yana kwae ina vinuwiya.” ");
INSERT INTO wat_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Atu Fita i kawafatafata i bwaduwa, “Na namaise taki fasiweu sina nuvimatikuwa, eatu muka tamo kana fata be ana bwadu, ‘Muka ata sanamanei.’” Eketa tomuniyeina matatafusi tamoka bwadunama yota si bwaduwiya. ");
INSERT INTO wat_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yeisu kana tomuniyeina nukusi si nemiya kabaḡa kana wava Getesemani nenei keta i iyavisiya i bwaduwa, “Nofemai kwana fakwafakwa eatu ana kawanunukuwa.” ");
INSERT INTO wat_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Eketa Fita, Yemesa keta Yoni i ovisiya keta nukusi si niya. Tovanama nenei kana nutoḡona i weifanufanuya, ");
INSERT INTO wat_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","eketa i iyavisiya i bwaduwa, “Nuwatadauna nakatamokena i munumunukuwa keta katekateku i nunubudabudaniya maise mate. Nofemai kwana fakwafakwa eatu kwana tonetoneya.” ");
INSERT INTO wat_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kabegomokena i vaniya, eyo i fekuwa fwayafwayai keta i kawanunukuwa be taki kana fata maise kuvavana kana kawasasa ita niuniya. ");
INSERT INTO wat_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I bwaduwa, “Amaku, iba matatafuna ka fata, na fasinei kuvavana nofe owana ku viteweyei nenekuwai. Eatu muka yaku nuwanuwa atu avana ku nuwenuwiya maise kuna fufuniya.” ");
INSERT INTO wat_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","I makaviniya kana tomuniyeina kasi tonu nenesiyai atu i nisaisiya si banubanuwa eketa Fita i iyaviya i bwaduwa, “Saimoni, omasi ku banubanuwa. Muka kana fata be matau ina fakina kawasasa bwatanaḡa?” ");
INSERT INTO wat_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Eketa i iyavisiya i bwaduwa, “Kwana tonetoneya keta kwana kawakawanunukuwa ebe kami anuvanuva nenei muka kwana feku. Yami vinuwadadana avana dewadewasi katekatemiyai kwana savivinisiya o fifiwanisi atu tofwami i seḡakamekameya.” ");
INSERT INTO wat_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","I makaviniya i kawanunukuwa keta tamoka bwadubwadusima nenesiyai i kawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I makavina-savaviniya nenesiyai eatu i nisaisiya yota si banubanuwa, uḡuna matasi naki i goyomoka. Eketa bwadusi si bauwiya. ");
INSERT INTO wat_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tovanama kana vitonu i makavina-savaviniya nenesiyai, i iyavisiya i bwaduwa, “Omasi yawane kwa banubanuwa keta kwa viviyawasiya. Nakiyai. Tova naki i nuvifotiya. Toviwaifufuna Namoḡa Natuna kabegomokena be togo'yona nimasiyai ina teniya. ");
INSERT INTO wat_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ake, kaku toviwaifufunamokena naki i kikinomana. Kwa misini be ta nai.” ");
INSERT INTO wat_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yeisu yawane i nunusifufuwa atu Yudasa tanake tamokaḡa tonowana kasi 12 i venukikinomana. Tovibwanaose nakanakasisi keta visime kana tovisawavenena yota tokawakawa sabuveka si visimeisiya, keta na fetosi yota na funumisi Yudasa si vinuwiya keta nukusi si nemiya. ");
INSERT INTO wat_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Toviwaifufunanama kiyakiyaya tamokaḡa i mikigisawakedanisiya, “Namoḡanama ana viyuiya na tanake kwana givikaviniya eketa kwana niiya.” ");
INSERT INTO wat_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tovanama si kikinomana Yudasa i niya Yeisu nenei keta i bwaduwa, “Tovisawavenena!” Eyo navanavanei i viyuiya. ");
INSERT INTO wat_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eketa Yeisu tofwanei si ova keta si givikaviniya. ");
INSERT INTO wat_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Atu namoḡa tamokaḡa nokomai i misimisiniya yana feto i soniyaginiya keta tovibwanaose kasi toviketanuneina kana kaetoḡa taniyana i nuonosiya. ");
INSERT INTO wat_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeisu i iyavisiya i bwaduwa, “Omasi na fetomi keta na yami funuma kwa nemiya be kwana givikavinikuwa vitana tamo togikuma maise? ");
INSERT INTO wat_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Iyau tova nubwayouna Numa Kodukodu kumenanina kana wasiketai nukusi ta fakwafakwa eatu a gigisawakedana namoḡa nenesiyai eatu ava uḡuna yo muka kwata givikaviniku? Eatu nakiyai, ebe avana Guyau fonakituna i bwaduwiya, ina vivenemokena.” ");
INSERT INTO wat_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eyo kana tomuniyeina matatafusi si butuwa atu Yeisu si sinanoviya. ");
INSERT INTO wat_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tufunakata tamokaḡa o nuyaḡa tofwanei i sinawaminiya keta Yeisu i muniiya. Tanake yota si anuvanuva be sita givikaviniya, ");
INSERT INTO wat_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","eava kana nuyaḡa si sinayauya atu gonegonena i dibwana. ");
INSERT INTO wat_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Namoḡa sabu Yeisu si niiya tovibwanaose kasi toviketanuneina yana numai. Nokomai tovibwanaose nakanakasisi matatafusi keta tokawakawa yota visime kana tovisawavenena si yokowa. ");
INSERT INTO wat_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Fita i muniiya simokaḡa sasanei keta i niya tovibwanaose kasi toviketanuneina yana numa kana wasiketai. Nokomai i nuvitoiya tuiyo nukusi keta kaiyai i vivikivanavana. ");
INSERT INTO wat_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tovibwanaose nakanakasisi keta Diu Kawakawa matatafumokesi si nuwasa Yeisu kana tokanakakikakina ebe yo sina nuvimatiya. Atu muka tamo sita nisaḡai. ");
INSERT INTO wat_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tokanakakikakina-vikanonono yagwanisi o si bwaduwa Yeisu fasinei atu yasi sifufumokesi muka tamo ita nuvifotei. ");
INSERT INTO wat_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Namoḡa tunisi si misiniya eketa nofemaise Yeisu fasinei si bwadu-vikanononowa, ");
INSERT INTO wat_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ka nowaniya i bwaduwa, ‘Namai Numa Kodukodu namoḡa nimasiyai si yoniya o ana yakweniya atu kuyadayada tonusi nenei ana yona-savaviniya muka namoḡa nimasiyai.’” ");
INSERT INTO wat_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eatu muka tamo yasi sifufunama tamo ita nuvifotei. ");
INSERT INTO wat_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eketa tovibwanaose kasi toviketanuneina sabu matasiyai i otowamisiniya keta Yeisu i nutoninuvenuveiya i bwaduwa, “Yasi vinoisima fasinei tamo avana kuna bwaduwiya o muka?” ");
INSERT INTO wat_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Atu Yeisu muka tamo avana ita bwaduwei naki i manava. Tovibwanaose kasi toviketanuneina yota i nutoninuvenuveiya i bwaduwa, “O venemokena kwaḡa Togifafafana Gigibokeinana, Guyau ta sawadavadaviya kwaḡa Natuna?” ");
INSERT INTO wat_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeisu i bwaduwa, “Ika Iyau. Yawane matatafumi kwana kitiya Namoḡa Natuna ina fakwasiotoḡa Tofiwanaonaona kikikatainei keta abamei busibusi nenei ina nenemiya.” ");
INSERT INTO wat_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tovibwanaose kasi toviketanuneina kana nuya i kiganiniya keta i bwaduwa, “Muka yota tana vinuwadadana tokanakakikakina fasisiyai. ");
INSERT INTO wat_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yana bwadu-tafakaikokona Guyau nenei naki kwa nowaniya eketa namaise kwata bwadu?” Eketa matatafusi si bwaduwa, “I goyona na fasinei kana nufota be ina mateya.” ");
INSERT INTO wat_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tunisi si vibutuwa si nufunataniya. Matana si sumiya eyo si munuya atu si bwaduwa, “Taki kwaḡa Guyau yana tomatakawa, ku iyaveiki aitevana i munuu!” Eyo tuiyo si givikaviniya eketa si munuya. ");
INSERT INTO wat_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Fita yawane wasiketai i fakwafakwa atu tovibwanaose kasi toviketanuneina kana kaetoḡa gumayogu i nemiya. ");
INSERT INTO wat_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tovanama i kitiya Fita kaiyai i vivikivanavana, i toneye-dewadewiya keta i bwaduwa, “Kwaḡa o noko namoḡanama Yeisu tene Nasaneti nukusi.” ");
INSERT INTO wat_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eatu Fita i vikewa i bwaduwa, “Iyau muka ata sanamanei ava fasinei ku bwadubwadu,” keta i kikinomana kawa nenei. Tovanama nenei kamukamu i kwaeya. ");
INSERT INTO wat_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tamoka gumayogunama yota Fita i kita-savaviniya, keta aviyaonana namoḡa nokomai si misimisiniya i iyavisiya i bwaduwa, “Nofe tanake Yeisu unana tamokaḡa!” ");
INSERT INTO wat_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eatu Fita yota i vikewa-savaviniya. Muniyai aviyaonana namoḡa nokomai si misimisiniya Fita si iyaviya si bwaduwa, “Bwadu venemokena, kwaḡa o unasi tamokaḡa uḡuna kwaḡa yota tene Ganini.” ");
INSERT INTO wat_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Atu Fita i vikewatautauna i bwaduwa, “Guyau matanei a iyaiyavimiya venemokena! Namoḡanama kwa bwadubwaduwiya o muka ata sanamanei.” ");
INSERT INTO wat_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tovanama nenei kamukamu yana kwae i vinuwiya eketa Fita nuwatana i kakwaniya Yeisu yana bwadu, “Kuna vikeweikuwa kawa tonu muniyai yo kamukamu yana kwae ina vinuwiya.” Eketa i kafuwaiya keta i bwediya. ");
INSERT INTO wat_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nuwabunimokeyai tovibwanaose nakanakasisi be tokawakawa yota visime kana tovisawavenena keta Diu Kawakawa matatafusi si yokowa keta si vikanusifusifufuwa Yeisu fasinei. Eyo nimana si kiyona keta si niiya Noma tovisime Fainato nimanei si teniya. ");
INSERT INTO wat_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Eketa Fainato Yeisu i nutoninuvenuveiya i bwaduwa, “O kwaḡa fiyao Diu yasi Tufomu?” Eketa Yeisu i nufata i bwaduwa, “Ika. Na naki ku bwaduwa maise.” ");
INSERT INTO wat_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eketa tovibwanaose nakanakasisi Yeisu si vinoiya iba yagwanisi goyosi fasisiyai. ");
INSERT INTO wat_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yota Fainato Yeisu i nutoninuvenuveiya i bwaduwa, “Tamo avana kuna bwaduwiya o muka? Ku kitai goyona kana yagwana fasinei si vivinoiwa!” ");
INSERT INTO wat_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Atu Yeisu muka tamo avana ita bwaduwei eketa Fainato i mayaḡa. ");
INSERT INTO wat_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Manamana tamokatamokaḡa Venuvisinatana kana Ka kana tovai, tova matatafuna Fainato finisina tamokaḡa deniyai i vivikikinomaniya namoḡa yasi nuwanuwai maise. ");
INSERT INTO wat_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na tovanama nenei namoḡa kana wava Banabasi o deniyai i fakwafakwa. Tanake o tunisi tovigwaeḡa nukusi Noma gabemani nukusi si vigwaeḡa, keta yota tunisi namoḡakaokaoḡosi atu si nuvimatisiya. Eketa Noma tonuaviya si givikaviniya keta deniyai si teniya. ");
INSERT INTO wat_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sabuveka si yokowa keta Fainato si vikokoniya be tamo aitevana ita ketoyauya, naki manamana tamokatamokaḡa i fufufuniya maise. ");
INSERT INTO wat_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Eketa Fainato i nutoninuvenuveisiya i bwaduwa, “Omasi nuwanuwami fiyao Diu yami Tufomu ana ketoyauya fasimiyai?” ");
INSERT INTO wat_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nofemaise i iyavisiya uḡuna waniya i mikisanamaniya vitana tovibwanaose nakanakasisi o Yeisu si vikumaiḡiya, na fasinei si katuteweiya nenei. ");
INSERT INTO wat_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Eatu tovibwanaose nakanakasisi o sabuveka si ketoyakayakanisiya be Fainato sina vikokoniya be Banabasi ina ketoyauya fasisiyai atu muka Yeisu. ");
INSERT INTO wat_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Atu Fainato i iyave-savavinisiya i bwaduwa, “Atu namoḡa nofe kwa weneweniya Diu yami Tufomu o namaise ana iyavei?” ");
INSERT INTO wat_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Si vikafinafina si bwaduwa, “Ku giviogonaḡanaḡai!” ");
INSERT INTO wat_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Atu Fainato i iyave-savavinisiya i bwaduwa, “Atu avao uḡuna? Avi goyona i fufuniya yoke?” Atu si finadewadewa si bwaduwa, “Ku giviogonaḡanaḡai!” ");
INSERT INTO wat_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eketa namoḡa nuwatasi kana kata fasinei, Banabasi i ketoyauya atu tonuaviya i visimeisiya keta Yeisu si nafanafasiya eyo i katuteweiya be sina giviogonaḡanaiya. ");
INSERT INTO wat_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tonuaviya Yeisu si niiya Fainato yana numa kaikaiwabuna kana wasiketai eyo unaunasi si wenevakukusisiya. ");
INSERT INTO wat_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kwame yabeyabenina Yeisu si vikotoniya keta kisisiku naḡanina kikikwanekwanena nenei gedugedu si fufuniya keta debabounei si teniya. ");
INSERT INTO wat_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Keta si sawaviniiya si bwaduwa, “Ae mukanono. Naki Diu yasi Tufomu!” ");
INSERT INTO wat_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kiwanai si munumunuya be si nufunataniya eatu naunei vifotuwai kaetutusi si viketogunisiya vitana kana venufotafota tufomu maise. ");
INSERT INTO wat_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Si sawaviniiya muninei, kwame yabeyabenina si visaniniiya eatu Yeisu tauna kana nuya si vikotoniya eketa si oviya si kikinomaniya menanai be sina giviogonaḡanaiya. ");
INSERT INTO wat_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Si niniya atu ke'ta tofwanei namoḡa tamokaḡa Saimoni tene Sainini si venusaiya kawayavatei i nemiya. Tanake Anekisenida keta Nufusi amasi. Namoḡanama si nuyakayakaniya keta Yeisu kana ogonaḡanaḡa i uniya. ");
INSERT INTO wat_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yeisu si oviya keta si niiya kabaḡa kana wava Gonigota nenei. Gonigota kana nuwanuwa o Navakanuwa kana Kabaḡa. ");
INSERT INTO wat_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nokomai bubu kana wava meya, waini nukusi si viniya eketa Yeisu si venenuvanuviya eatu i dibutoyoiya. ");
INSERT INTO wat_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eketa si giviogonaḡanaiya atu kana nuya fasinei, nao daisi nenei si vikaneeneiya. Nofe ketaketanama nenei, kana nuya si vitukuwiya tututausi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nuwabuni 9 kana fafani nenei Yeisu si giviogonaḡanaiya. ");
INSERT INTO wat_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kana bwaduvinoi viviginiwina si tutuvifotiya kuetana i bwadubwaduwa, Tanake Diu yasi Tufomu. ");
INSERT INTO wat_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Togikuma nasi nuwa Yeisu nukusi si giviogonaḡanaisiya, tamokaḡa kukikikatainei eatu tamokaḡa o kukikimawanei. ");
INSERT INTO wat_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Namoḡa sabu ketai si niniya be si nenemiya eatu si nunuwautuutuna atu si bwadubwaduwa, “Ake, naki ku sanamaniya! Omasi Numa Kodukodu kuta yakweniya eatu kuyadayada tonusi nenei kuta yona-savaviniya, mukanono! ");
INSERT INTO wat_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Make nao ogonaḡanaḡa nenei ku sobunemai be tauḡu ku gifafafaneu!” ");
INSERT INTO wat_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tamoka ketaketanama nenei tovibwanaose nakanakasisi keta visime kana tovisawavenena tututausi nenesiyai Yeisu fasinei si sawaviniḡa si bwaduwa, “Mani namoḡa i gifafafanisiya atu tauna o muka kana fata! ");
INSERT INTO wat_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","I bwaduwa avage tana Togifafafana Gigibokeinana keta yota Isineni kana tufomu. Make nao ogonaḡanaḡai ita sobunemiya tata kitiya be tata vitumaḡaniya.” Namoḡa kasi nuwa o kuniniuna si giviogonaḡanaisiya yota si sawanuketuwiya. ");
INSERT INTO wat_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tovanama vanavana i nemiya sinefounei, noko fafaninama matatafuna kumanovana i gikafufuya keta i fakwa kana nivaniva vanavana i niya tonusi yana fafani. ");
INSERT INTO wat_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tovanama nenei Yeisu kayona nakasinei i bwauwa i bwaduwa, “Enoi, Enoi, nama sabatani?” Kana givina o, “Yaku Guyau, yaku Guyau, ava uḡuna ku sinanoveiku?” ");
INSERT INTO wat_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Namoḡa tunisi nokomai si misimisiniya si nowaniya keta si bwaduwa, “Kwa vaneneḡa, kana kita kamo Inaitiya i weneweniya.” ");
INSERT INTO wat_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Namoḡa tamokaḡa i dibwana i niya eketa banou i viketokutuviya waini yuyuna nenei. Eyo kiwana bwatanei i tunevaneiya be Yeisu ina yumiya fasinei eketa i bwaduwa, “Yabe ta kitai, kamo Inaitiya ina nemiya ogonaḡanaḡai ina kakiya.” ");
INSERT INTO wat_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Eatu Yeisu kayona nakasinei i bwauwa eketa yawasina i kakaviya. ");
INSERT INTO wat_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eketa Numa Kodukodu kusinena kafa dawanafafana kana nuya i kasaniniya etanei atu i sobuwa sifunei. ");
INSERT INTO wat_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tonuaviya kasi kaimatana ogonaḡanaḡa naunei i misimisiniya i kitiya namaise Yeisu i mateya eketa i bwaduwa, “Bwadu venemokena namoḡa nofe o Guyau Natuna.” ");
INSERT INTO wat_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tunisi vivine o matakedawanauna si misiniya atu si tonetoneiya. Sinesiyai o Meni ne Magidana eketa Sanome yota venuwana Meni o Yemesa gwadiyei keta Yosese ayosi. ");
INSERT INTO wat_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nofe vivinesima o nauna Yeisu Ganini nenei si muniiya keta yota si okakikakiniya. Vivine yota yagwanisi nukusi nokomai si misiniya atu Yeisu si tonetoneiya. Vivinesima o Yeisu kaena si kwafuya eketa si niya Yenusanema. ");
INSERT INTO wat_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Tene Animatiya kana wava Yosefa o tanake Diu Kawakawa tamo kana namoḡa nakasina. Tanake o i kitakitanufota Guyau yana kafa visime fasinei. Eketa gidewadewa kana kuyadayada atu naki i vivinavinaviya be yo Sabati ina vibutuwa fasinei, eketa Yosefa na yana katevatu i niya Fainato nenei keta i vikokona Yeisu tofwana fasinei. ");
INSERT INTO wat_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Fainato i sabanutuḡa tovanama Yeisu yana mate fasinei i biganowana keta tonuaviya kasi kaimatana i weniya keta i nutoninuvenuveiya taki Yeisu naki i mateya. ");
INSERT INTO wat_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tovanama kaimatana nenei sanamana i videwadewiya, tofwa i sawateweiya Yosefa nenei. ");
INSERT INTO wat_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosefa nuya kwayakwayana i kimwaniya eketa tofwa ogonaḡanaḡai i kakiya keta i waminiya muniyai yo vatunuma vigabanina si taniya nenei i teniya. Eyo gabana nakasina i katubwatabwataviniya keta vatunuma kawana i tenefotiya. ");
INSERT INTO wat_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meni ne Magidana keta Meni Yosese ayona o si kitiya namaniyei Yeisu tofwana i teniya. ");
INSERT INTO wat_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tovanama Sabati kana kuyadayada i kakaviya, Meni ne Magidana yota Meni Yemesa ayona keta Sanome bubu mamadisi si vikimwaneya Yeisu tofwana kana vitowa fasinei. ");
INSERT INTO wat_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wiki kana kuyadayada kafa viuḡu nenei tovanama vanavana i vaneya, si niya vatunuma nenei. ");
INSERT INTO wat_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Si niniya atu ke'ta tofwanei tututausi si vikanunutoniya si bwaduwa, “Aitevana gabana ina katuniyei vatunuma kawana nenei fasitiyai?” ");
INSERT INTO wat_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Gabananama nakatamokena atu i kabwatabwataviniya i makaviniya eketa tovanama matasi i kanakasiya si kitiya kawa kakayauna. ");
INSERT INTO wat_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eketa vatunuma sinenei si kanasuna, tamokaḡa tufunakata kana nuya kwayakwayana kukikikataisi si kitiya i fakwafakwa eketa si mayaḡa. ");
INSERT INTO wat_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eatu i iyavisiya i bwaduwa, “Muka kwana matuta. A sanamaniya Yeisu tene Nasaneti si giviogonaḡanaiya kwa nunuwasiya eatu tanake weka muka. Tanake naki i misini-savaviniya. Kwa kitai, nofemai si teniya. ");
INSERT INTO wat_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Atu kwana niya kana tomuniyeina keta Fita nukusi nofemaise kwana iyavisiya kwana bwaduwa, ‘Tanake i viviketanuna Ganini eketa nokomai yo kwana kitiya. Naki nauna i iyavimiya maise.’” ");
INSERT INTO wat_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tovanama nokomaise si nowaniya, vivinesima si mayaḡa keta na yasi akikinikuna vatunuma sinenei si kikinomana-nemiya keta si vikadibwadibwana si niya. Si matuta eketa muka tamo aitevana sita iyavei avana namoḡa tufunakasina i nusifufuwisiya. Tunisi Naumokena Viginiwa Muka Sita Katukanasunei 16:9-20.  ");
INSERT INTO wat_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wiki kana kuyadayada kafa viuḡu nenei tovanama Yeisu nuwabunimokeyai i misini-savaviniya, nauna Meni ne Magidana nenei i mikikikinomana. Nofe gumayogunama nenei Yeisu kanunu goyosi kasi 7 i nukakisiya. ");
INSERT INTO wat_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aviyaonana namoḡa Yeisu nukusi si nidadana o nuwatasi i dauna eketa Yeisu fasinei si bwedibwediya. ");
INSERT INTO wat_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Atu Meni i niya keta i iyavisiya i bwaduwa, “Ei! Yeisu naki i misini-savaviniya, iyau tauku matamokekuwai a kitiya!” Eatu yana bwadu muka sita vitumaḡanei. ");
INSERT INTO wat_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Munifotai tomuniyeina kasi nuwa Yenusanema si teweiya keta si niniya atu Yeisu i nikikinomana nenesiyai. Si kitiya vitana tamo avi namoḡa. ");
INSERT INTO wat_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Si makavinisiya keta unaunasi kasi tufo si iyavisiya atu tasike yota muka sita vitumaḡaneisi. ");
INSERT INTO wat_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Munifotai tonowana kasi 11 si kakawa eatu Yeisu i kikinomanisiya. Keta i dageisiya uḡuna katekatesi yana gua eketa muka na yasi vitumaḡana, na nenei aviyaonana yana misini-savavineina muninei si kitiya muka sita vitumaḡaneisi. ");
INSERT INTO wat_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eketa i iyavisiya i bwaduwa, “Kwana kikinomana fwayafwaya kana matatafu nenei be biga dewadewana kwana yauniya matatafusi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aitevana ina vitumaḡanikuwa keta givibutabuta ina viya nao gifafafana ina nisaiya, eatu aitevana muka ina vitumaḡaneiku nao vimatadawana ina nisaiya. ");
INSERT INTO wat_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kaku tovitumaḡana kiyakiyaya kafa nuwatabau fifiwanisi sina savivinisiya. Kaku wavai kanunu goyosi namoḡa nenesiyai sina nukakisiya yota meya kiousi tunisitunisi muka kasi sanamana nenesiyai sina nusifufuwa. ");
INSERT INTO wat_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mwata goyosi sina givikavina yota taki ukowa onaonasi sina yumiya, muka ina navisi. Nimasi sina dawana tovisafwavinaḡa tofwasiyai eketa sina bwina.” ");
INSERT INTO wat_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tovanama Tuveka Yeisu i nusifufukooḡa, Guyau i vaneiya abamai eketa kikikatainei vifotu kabaina nenei i fakwasiotoḡa. ");
INSERT INTO wat_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eketa tomuniyeina si numamananiya namoḡa nenesiyai. Eatu Tuveka i ovivitisiya eketa yana fiwanai kiyakiyaya kafa nuwatabau si savivinisiya namoḡa matasiyai. Nofe ibasima nenesiyai yasi numamana i vivenemokena. ");
INSERT INTO wat_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Iye agigiku Tiofino, nauna nufunufu a mikiviginiwiya sinenei iba matatafuna aviyavana Yeisu i vibutuwa i savivinisiya be i visawavenena ");
INSERT INTO wat_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kana nivaniva kuyadayadanama nenei i vaneya abamai. Muniyai yo ina makaviniya abamai, Kanunu Tafutafuna yana fiwanai yana tonowana nauna i mikigibokisiya, fiyaosima i gisawakedanisiya. ");
INSERT INTO wat_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yana kuvavana be yana mate muninei, tauna i vimaikitiya namoḡasima nenesiyai ketaketa yagwanina nenesiyai vitana i visawavenemokeniya naki i yawasa-savaviniya. Kuyadayada 40 kana kawasasai tauna i kikikinomana eketa i nunusifufuwisiya Guyau yana kafa visime fasinei. ");
INSERT INTO wat_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Eketa tamoka tova tanake nukusi si fakwafakwa atu i visimeisiya i bwaduwa, “Muka Yenusanema kwana teweteweyei atu nofemai kwana fotafota kana nivaniva Amaku kakavenena i bwadudabedabiya ina venimiya. Nauna a bwaduwiya kwa nowaniya. ");
INSERT INTO wat_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoni namoḡa i givibutibutisiya ukowa nenei atu kuyadayada muka yagwanina muninei Amaku Kanunu Tafutafuna nenei ina givibutibutimiya.” ");
INSERT INTO wat_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tovanama yota si vikaninisaḡa, Yeisu si nutoninuvenuviya si bwaduwa, “Tuveka yo, nofe tova kafa visime kuna vene-savaviniya Isineni ebe tauna ina visimeiya?” ");
INSERT INTO wat_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Eatu i iyavisiya i bwaduwa, “Ibasima sina kikinomana kasi tova o kasi tutuya o tanake Amakuḡa yana visime nenei eketa muka kana fata kwana sanamanei. ");
INSERT INTO wat_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Eatu maise! Tovanama Kanunu Tafutafuna ina nemiya nenemiyai, ina givifiwanimiya be sifufuku kwana yauniya nofemai Yenusanema nenei, Yudiya be Sameniya fafanisima matatafusi eketa yota fwayafwaya kana matatafu nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I nusifufukooḡa muninei, matasiyai Guyau i vaneiya abamai. Tovanama busibusi i tenefotiya, muka yota sita kitai. ");
INSERT INTO wat_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yana vanenama nenei, tonowana si kawavitatavaḡata kawasasakaoḡowai. Tovanama nenei, namoḡa nasi nuwa kasi nuya kwayakwayasi kuniniusi si misiniya ");
INSERT INTO wat_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","eketa si iyavisiya si bwaduwa, “O fiyao Ganini, avamasi yami uḡu yo kwa misimisini nofemai kawasasakaoḡona kwa tonetoneyei? Na Yeisunama kwa kitiya i vaneya abamai, naki maisemoka yota ketanama nenei ina makaviniya.” ");
INSERT INTO wat_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Koya Onive nenei tonowana si makavinisiya Yenusanema. Sabati kana waneba kana kedawanau maisemoka. ");
INSERT INTO wat_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tovanama si kikinomana menana nakasinei, numanama si fakwifakwiiya nenei si kanasuna eketa si vaneya totomu kuetana nenei. Nofemaise kasi wava. Fita, Yoni, Yemesa, Anideneya, Finifi, Tomasi, Batonomiu, Madiu, Yemesa Anafasi natuna, Saimoni tanake Senoti eketa Yudasa Yemesa natuna. ");
INSERT INTO wat_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tunisi vivine keta Meni Yeisu ayona yota sisitaina namoḡa nukusi si yokoyokowa eketa nuwanuwa tamokaḡa nenei si kawakawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tamoka tova tovanama tovitumaḡana kasi yagwana kamo 120 si yokowa nenei, Fita kasi sinefouwai i misiniya eketa i nusifufuwa i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Unaunaku, Guyau fonakituna Yudasa fasinei naki i vivenemokena. Tova manatuwaimokena, gwadinama fasinei Kanunu Tafutafuna i bwaduvioḡoniya tufomu Deivida nenei. Yudasa tanake o tonowana sinekiyai bunanige nenei i ovivita eatu muniyai, namoḡa i viketanunisiya eketa Yeisu si tabiya.” ");
INSERT INTO wat_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yana viwaifufuninama gabanina i viya eketa fwayafwaya i kimwaniya. Nokomai i kunowa keta fekunama nenei manawana i biyavaniya eketa kamokamona i tetena. ");
INSERT INTO wat_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Fiyao Yenusanema matatafusi bigana si nowaniya eketa fwayafwayanama fonasiyai si weniya Akenedama, kana givina o ufaufa fwayafwayana.) ");
INSERT INTO wat_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Eketa Fita i tenesaviya i bwaduwa, “Same nenei namoḡanama fasinei Deivida i viginiwiya, ‘Yana numa ina nukawakakava eatu muka tamo aitevana ina fakwiyei.’ Keta yota i viginiwiya, ‘Tamo aitevana kana kivi ina viya.’ ");
INSERT INTO wat_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Eketa nofe tova namoḡa tamo tana vinuwadadaniya be nukusi kana savivina ebe mani namoḡa kana iyavisiya namaise Guyau, Tuveka Yeisu mateyai i sinaviyawasiya fasinei. Atu namoḡanama tanake tova kana matatafu Tuveka Yeisu nukusi ka nidadana tovanama Yoni i givibutabutiya nenei eketa kana nivaniva nenetiyai Guyau i oviya eketa i vaneiya abamai. Eketa naki kana nufota tamo tana ginakasiya.” ");
INSERT INTO wat_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Eketa tomuniyeina namoḡa nasi nuwa si ginakasisiya. Yosefa Basabasi, (kana wava yota Yasitusi) eketa Mataiyasi. ");
INSERT INTO wat_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Munifotai nofemaise si kawanunukuwa si bwaduwa, “Tuveka yo, kwaḡa katekate matatafuna ku sanamanisiya. Ku visawaveneiki namoḡasima nasi nuwa nenesiyai, aitevana ku gibokei kivi kana toḡafota fasinei ebe nukusi kata bunanige, uḡuna Yudasa naki i teweikiya i niya tauna yana kabaḡai.” ");
INSERT INTO wat_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Daisi nenei si vikaneeneiya fiyao Diu yasi ketaketai eketa si viketokinaniya Mataiyasi kasi 11 sinesiyai i kanasuna tanake nukusi si vitonowana. ");
INSERT INTO wat_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kabwaga Matana kana kuyadayada i vikanatutuya nenei, tovitumaḡana matatafusi si yokowa kabaḡa tamokaḡa nenei. ");
INSERT INTO wat_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sabanutuḡai butu abamei si nowaniya vitana maise fonimana fifiwanina i sobunemiya eketa namai si nunuvitoḡa nenei, numanama matatafuna i gikafufuya. ");
INSERT INTO wat_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Eketa si kitiya aviyavana vitana kai noyakaina maise i sobunemiya eyo i kataneneḡa eketa tovitumaḡana tamokatamokaḡa debabounei i toḡa. ");
INSERT INTO wat_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kanunu Tafutafuna matatafusi i vimaisiya eketa tanake yana givisawakedanai, fona tuninatunina muka sita sanamanei nenesiyai si vibutuwa si nunusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Atu noko tovanama nenei, fiyao Diu tasike Guyau kana tovimogumogu fwayafwaya kana matatafu nenei si nemiya Yenusanema si fakwa Kabwaga Matana kana Ka fasinei. ");
INSERT INTO wat_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tovanama sabu butuna si nowaniya eketa si yokowa eatu nuwatasi si kafibaubauwa uḡuna tamokatamokaḡa tauna fonakitunei i nowaniya tomuniyeina si nunusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tututausi si mayaḡa eketa si bwaduwa, “Au, kwa vaneneḡeisi! Fiyaosima si nunusifufuwa o fiyao Ganinimoka! ");
INSERT INTO wat_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Atu namaise yo kita fonakitutiyai si nunusifufu ta nowanowanisi? ");
INSERT INTO wat_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Fafani tuninatunina nenesiyai ta nemiya. Tunisi fiyao Fatiya, Mediya, Enami. Tunisi Mesofotamiya, Yudiya, Kafadosiya, Fonutusi, be Eisiya, ");
INSERT INTO wat_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Finigiya be Famufiniya, Itifita, yota tunisi Sainini niniunei Nibiya kana fafani nenei. Fiyao Diu keta yota Kani Kwauna eatu nofe tova Diu kodukodu si munimuniiya nukusi, wagawaga Noma nenei. Tunisi Kiniti simuna nenei eketa yota Anabiyei. Eatu matatafuta fonakitutiyai Guyau iba nakanakatamokesi naki i savivinisiya fasisiyai o ta nowanowanisiya si nunusifufuwina!” ");
INSERT INTO wat_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Matatafusi si mayaḡa yota nuwatasi si kafibaubauwa eketa si vikanunutoniya si bwaduwa, “Avamasi nofe kana nuwanuwa?” ");
INSERT INTO wat_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Eatu tunisi si sawaviniisiya si bwaduwa, “Kamo si ukowayuwa nakasina na fasinei nofemaise si nunusifufuwa.” ");
INSERT INTO wat_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Eatu Fita i misiniya tonowana kasi 11 nukusi eketa kayona nakasinei sabu i iyavisiya i bwaduwa, “Unaunaku fiyao Diu yota aviyaonana Yenusanema kwa fakwafakwa, ata givimayeta eatu kwata nowanautuutuya avana nofe kana nuwanuwa. ");
INSERT INTO wat_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kima muka kata ukowakowayu, taki maise kwa vivinuwadadana. Nofe 9 kana fafani yawane nuwabuni, yota namoḡa nofe kawasasanama nenei, muka sita ukowakowayu. ");
INSERT INTO wat_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Eatu aviyavana nofe i kikinomana o naki avana Guyau yana tomatakawa Yoweni i bwaduwiya maise, ");
INSERT INTO wat_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Guyau nofemaise i bwaduwa. Tova kasi kafa nusafuwai namoḡa matatafusi nenesiyai Kanunuku ana bisiwaiya. Eketa natunatumi namoḡa be vivine fonaku sina bwaduvioḡoniya. Yami tufunakata katekatevatusi sina kenokita yota yami namoḡa vituvekasi sina kenokavakavayuna. ");
INSERT INTO wat_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Noko tovasima nenesiyai, kaku kaetoḡa namoḡa be vivine nenesiyai, Kanunuku ana bisiwaiya ebe fonaku sina bwaduvioḡoniya namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kafa nuwatabau atai kawasasakaoḡona nenei ana savivinisiya yota kiyakiyaya ana visawavenena tanowai fwayafwaya nenei maise ufaufa be kikanakanata keta yota siyou badobadona. ");
INSERT INTO wat_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Vanavana ina kumanovaniya yota yamayamana ina yabeniya maise ufaufa, eyo muniyai, kuyadayada nakasina keta kaikaiwabuna ina kikinomana nenei, Iyau Tuveka ana nemiya. ");
INSERT INTO wat_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eatu aviyaonana vitumaḡanai sina bwauwa Tuveka nenei, gifafafana sina nisaiya.’” ");
INSERT INTO wat_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Fita yota yana bwadu i tenesaviya, “Fiyao Isineni, Yeisu tene Nasaneti sifufuna nofe kwa vaneneḡei. Tututaumi kwa sanamaniya namaise Guyau fiwana i veniya be savivina fifiwanamokesi keta yota kiyakiyaya kafa nuwatabau i savivinisiya. Noko si visawavenena venemokena tanake gewa Guyau nenei i nemiya. ");
INSERT INTO wat_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Guyau waniya kana uḡu i vinuwadadaniya eketa visime kana toodibutoyoḡa nimamiyai si teniya, be nukusi kwa giviogonaḡanaiya eketa kwa nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Eatu Guyau i ketoyauya mate kana kuvavana kunukubana nenei eketa mateyai i sinaviyawasa-savaviniya uḡuna mate muka fifiwanina be ina sinaviyewai. ");
INSERT INTO wat_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nofe namoḡanama fasinei tufomu Deivida i viginiwiya i bwaduwa, ‘Tova nubwayouna yaku Tuveka Guyau naukuwai a tonetoneiya. Muka kaku kaniyabina ana matuteisi uḡuna tanake niniukuwai. ");
INSERT INTO wat_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Muka kuna venumakanoveiku tomate yasi kabaḡai o ka Kaetoḡa Tafutafuna kuna kitamokei be ina kaniniya kididiku sinenei. Na fasinei yaku sebobo avi nakata be semwanai a oseoseya, a sanamane-budowanemokiya tofwaku kuna kitavikaviniya fasinei. ");
INSERT INTO wat_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yawasi kana ketaketa ku visawasawavenikuwa eketa tafakaiu yana yagova nenei sebobo ina tewesafukuwa.’” ");
INSERT INTO wat_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Fita sifufu i nusaviya i bwaduwa, “Unaunaku, nofe bwadu venemokena a iyaiyavimiya, waḡata Deivida i mateya keta si tauniya atu kana kididikunama o kimoki kita nukusi yawane i fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nofe nenei ta sanamaniya gewa muka tauna fasinei ita bwadubwadu eatu tanake Guyau yana tomatakawa eketa naki i bwaduvioḡoniya vitana susukwana nenei tamo yana gabu ina viya. ");
INSERT INTO wat_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","I kitavaneya kunauna vitana Guyau yana Togifafafana Gigibokeinana, yawane mateyai ina misini-savaviniya tovanama i bwaduwa, ‘Guyau muka ina venumakanovei tomate yasi kabaḡai o tofwana ina kitamokei be ina kaniniya kididiku sinenei.’ ");
INSERT INTO wat_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Guyau nofe Yeisunama mateyai i sinaviyawasa eketa matatafuki o kana tokita. ");
INSERT INTO wat_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Guyau i vitoḡavaneiya kikikatainei vifotu kabaina nenei. Eketa Amana Kanunu Tafutafuna i bwadudabedabiya maise nenei i viya eketa i bisiwaḡa nenekiyai. Avana nofe kimoki kwa kitakitiya keta kwa nowanowaniya. ");
INSERT INTO wat_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwa sanamaniya Deivida muka ita vane abamai eatu tauna i bwaduwa, ‘Guyau yaku Tuveka i iyaviya i bwaduwa, “Kukikikataiku ku nuvitoḡa vifotu kabaina nenei ");
INSERT INTO wat_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kana nivaniva nifanifaiu ana tenisiya kaeyafayafaweu ya kafa vasafasafa.”’ ");
INSERT INTO wat_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Atu kwami fiyao Isineni matatafumi o kwata sanamaniya nofe namoḡanama Yeisu kwa nuvimatiya eatu Guyau i ginakasiya yata Tuveka keta yota kata Togifafafana Gigibokeinana.” ");
INSERT INTO wat_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Si vanevaneneḡa eatu tovanama sifufu nofe si nowaniya, katekatesi i kayavana eketa Fita be tunisi tonowana si iyavisiya si bwaduwa, “Ae, unaunaki! Namaise kata fufuna ebe Guyau ita vinuwateweyeiki?” ");
INSERT INTO wat_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Eketa Fita i iyavisiya i bwaduwa, “Tamokatamokaḡa kwa ugevinaimi be Yeisu Togifafafana Gigibokeinana kana wavai ka givibutabutaimi ebe yami go'yona kasi vinuwateweyeina fasinei yo muniyai, kami nuwagabubu Kanunu Tafutafuna, Guyau ina venimiya. ");
INSERT INTO wat_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Guyau yana bwadudabadaba ina saviviniya fasimiyai keta natunatumi be yota matatafusi aviyaonana kedawanauwai si nenemiya fasisiyai. Tasike aviyaonana Tuveka yata Guyau ina wenisiya be sina nemiya nenei, namoḡasima tauna Kanununa ina venisiya.” ");
INSERT INTO wat_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Fita yana sifufu yagwanina nenesiyai i matakawisiya i bwaduwa, “Aviyaonana kimoki muka Yeisu sita vitumaḡanei, Guyau ina vimatadawanisiya. Na uḡuna kwa kawanunukuwei be i gifafafaneimi.” ");
INSERT INTO wat_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eketa kuyadayadanama nenei namoḡasima bwadu si vitumaḡaniya be si givibutibutisiya o kasi yagwana 3,000. Keta namoḡasima o Yeisu kana tomuniyeina nukusi si vikatutamokisiya. ");
INSERT INTO wat_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tova nubwayouna tovitumaḡana, tonowana yasi visawavenena si vanevaneneisiya eketa yota unaunasi nukusi, kanunu keta kwafini nenesiyai, si vivikaovivita. Tovitumaḡana Tuveka yana Ka kana kiyakiyaya si fufufuniya keta yota si kawakawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yenusanema kana matatafu tovanama si kitisiya tonowana kiyakiyaya kafa nuwatabau yagwanisi si savisavivinisiya eketa Guyau kana vimogumogu i nakatamoka nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tovitumaḡana si yokoyokowa eketa iba matatafuna si vivitukuwa tamo nenei. ");
INSERT INTO wat_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Atu tunisi yasi fwayafwaya be nogonogo si vivikimwaneina eketa unaunasi aviyaonana na kasi dauna nukusi, noko gabaninama si venivenisiya. ");
INSERT INTO wat_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tovatova Numa Kodukodu nenei si vivikaninisaḡa. Eatu ka fasinei o yasi numai semwanai yota nuwasobuwai si kakaviyaowa. ");
INSERT INTO wat_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Guyau si davadaviya eketa namoḡa matatafusi tovitumaḡana si vifotuwisiya. Naki tovatova namoḡa gifafafana si ninisaiya keta Tuveka tovitumaḡana kasi yoko i gigivinakasiya. ");
INSERT INTO wat_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tamoka tova navinavi tonusi kana fafani nenei fiyao Diu yasi tova kawanunuku kana tutuya nenei, Fita keta Yoni si niya Numa Kodukodu nenei. ");
INSERT INTO wat_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na tovanama nenei namoḡa tamokaḡa fenafenana i tufuwiiya si nukivaiya keta Numa Kodukodu kana kani kana ketakawana si weneweniya Kiwaḡa nenei si teniya. Tova matatafuna yana sabu nokomai si teneteniya ebe aviyaonana si niniya Numa Kodukodu nenei, gabana i vivikokonisiya. ");
INSERT INTO wat_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tovanama i kitisiya Fita keta Yoni kabegomokena be Numa Kodukodu kana kani kana ketakawanai sina kanasuna, i vikokonisiya i bwaduwa, “Ae, tamo gabana kwata venikuwa.” ");
INSERT INTO wat_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tovanama si toneiya nenei Fita i iyaviya i bwaduwa, “Ku toneyeiki.” ");
INSERT INTO wat_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Eketa i kitatonitonisiya avage vitana nenesiyai gabana ita nisaiya. ");
INSERT INTO wat_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Eatu Fita i iyaviya i bwaduwa, “Muka tamo gabana nenekuwai eatu aviyavana nenekuwai o ana veniwa. Yeisu Togifafafana Gigibokeinana tene Nasaneti kana wavai, ku misini be ku nidadana!” ");
INSERT INTO wat_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Eketa Fita i ova kikikatainei keta i sinavitowamisiniiya. Naki na tovanama nenei kaeyafayafana keta kaematakisina si fiwana. ");
INSERT INTO wat_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","I venuotowamisiniya keta i vibutuwa i nidadana. Naki na kusifusifuna nukusi atu si kanasuna Numa Kodukodu sinenei Guyau i sawasawadavadaviya. ");
INSERT INTO wat_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Namoḡa matatafusi si kitiya i ninidadana keta si nowaniya Guyau i sawasawadavadaviya. ");
INSERT INTO wat_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Si kitakinaniya tanake gwadinama ketakawana Kiwaḡa nenei gabana i toḡatoḡavikokona eatu aviyavana nenei i kikinomana fasinei o si sabanutuiya. ");
INSERT INTO wat_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tovikokonanama Fita keta Yoni i nutavaḡasisiya atu namoḡa matatafusi si mayaḡa eketa si dibwana si nemiya kabaḡanama si weneweniya Sonomoni yana nukefakefa nenei. ");
INSERT INTO wat_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tovanama Fita i kitisiya sabuveka si yokoyokowa i iyavisiya i bwaduwa, “Unaunaku fiyao Isineni, namaise yo kwa sabanutuḡa iba nofe i kikinomana fasinei? Avana uḡuna yo kwa tonetonemanonoweiki vitana kima tututauki yama fiwanai o taki yama eyaeyanai kata visaviviniya yo namoḡa nofe ita nidadana? Naki Guyaumoka o yana fiwana i saviviniya. ");
INSERT INTO wat_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebenaamu, Aisake be Yakobo yota waḡawaḡata matatafusi yasi Guyau kana kaetoḡa Yeisu i gikaikaiwabuya. Eatu kwa katuteweiya yami toviketanuneina nenesiyai. Yota Noma tovisime Fainato i vivinuwadadana be ita ketoyauya eatu kwa dibutoyoiya. ");
INSERT INTO wat_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yeisunama o naki tafutafuna keta toeyaeyanamoka atu kwa vikeweiya. Tumadama yo Fainato kwa sawanuyakaniya be tonuvimate i ketoyauya. ");
INSERT INTO wat_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kwami Yawasivaḡata kana Tokavenena kwa nuvimatiya eatu Guyau i sinaviyawasiya. Eketa kima o kana tokita. ");
INSERT INTO wat_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Uḡuna kima Yeisu kana wava ka vitumaḡaniya eketa gwadinama nofe sanasanamanimi kwa kitakitiya o i dewadewa. Yeisu kana wava kana vitumaḡana nenei, namoḡa nofe matatafumi matamiyai naki i dewadewamoka. ");
INSERT INTO wat_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Unaunaku, a sanamaniya kami toviketanuneina nukusi aviyavana kwa fufuniya Yeisu nenei o muka kana sanamana nenemiyai. ");
INSERT INTO wat_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Eatu manatuwaina avana Guyau i bwaduwiya yana tomatakawa matatafusi nenesiyai eketa si bwaduvioḡoniya Guyau yana Togifafafana Gigibokeinana yana kuvavana fasinei o naki i vivenemokena. ");
INSERT INTO wat_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na uḡuna yami go'yona nenesiyai kwa ugevinaimi be kwa makavinaimi Guyau nenei ebe yo yami go'yona ina vinuwateweisiya. ");
INSERT INTO wat_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tuveka yawasimi ina givisekausiya ebe yo kami Togifafafana Gigibokeinana ina vininitiya tanake Yeisu. ");
INSERT INTO wat_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tata tukuya Yeisu abamai ina fakwafakwa kana nivaniva Guyau iba matatafuna ina givikiouya naki manatuwaina i bwaduwiya yana tomatakawa tafutafusi nenesiyai eketa si bwaduvioḡoniya maise. ");
INSERT INTO wat_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosese i bwaduwa, ‘Tuveka yami Guyau tututaumi sinemiyai tamo aitevana ina ginakasiya fasimiyai ebe ina vitomatakawa maise iyau. Eketa matatafuna avana ina nusifufuwimiya kwana nowanautuutuya. ");
INSERT INTO wat_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Taki aitevana noko tomatakawanama fonana muka ina muniyei, nao tauna i nunuvisiya eketa Guyau ina nuyauniya yana namonamoḡa nenesiyai.’ ");
INSERT INTO wat_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Eketa aviyavana nofe tovasima si kikikinomana, nao Guyau yana tomatakawa matatafusi i vibutuwa Samuwena nenei eketa i nemiya, si bwaduvioḡoniya. ");
INSERT INTO wat_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Noko tomatakawasima o kita natunatusi. Eketa Guyau dedeni i fufuniya waḡawaḡata nenesiyai o kita i nunatuta tovanama i bwaduwa Ebenaamu nenei, ‘Susukwau nenesiyai eketa namoḡa matatafusi fwayafwaya etanei ana sawanuwagabubuwisiya.’ ");
INSERT INTO wat_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tovanama Guyau kana kaetoḡa Yeisu i gibokiya, i vininitiya nauna kita fiyao Diu nenetiyai uḡuna nuwanuwana yata fufunagoyo nenesiyai ina ugevinita be ina sawanuwagabubuwita.” ");
INSERT INTO wat_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Fita keta Yoni namoḡa si nunusifufuwisiya eatu tunisi tovibwanaose be Numa Kodukodu kana tuiyo kasi toviketanuneina eketa yota tunisi Sadusi si nemiya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Fita keta Yoni namoḡa si vivisawavenena vitana Guyau namoḡa mateyai ina sinaviyawasisiya naki maisemoka Yeisu i sinaviyawasiya, na fasinei si nuwagoyowisiya. ");
INSERT INTO wat_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eketa si tabisiya eatu naki i vimatasisinovanovana fasinei, deniyai si tenefotisiya kana nivaniva nuwabuni. ");
INSERT INTO wat_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Atu yagwanisi aviyaonana Fita keta Yoni yasi sifufu si nowaniya, si vitumaḡana eketa namoḡa kasi sawasawa o i vaneya 5,000 maise. ");
INSERT INTO wat_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kuyadayada kana vinuwa nenei, fiyao Diu toviketanuneina be tokawakawa yota Mosese yana visime kana tovisawavenena si yokowa Yenusanema. ");
INSERT INTO wat_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Sinesiyai o tovibwanaose kasi toviketanuneina Anasi keta Kaiyafasi be Yoni yota Anekisenida, keta yota tovibwanaose kasi toviketanuneina yana sabu nukusi. ");
INSERT INTO wat_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tuiyo si iyavisiya eketa Fita be Yoni si ovisiya keta nausiyai si misiniya eyo si nutoninuvenuvisiya si bwaduwa, “Avi fiwana o avi wava nenei eyo namoḡa nofe kwa gidewadewai?” ");
INSERT INTO wat_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Eketa Kanunu Tafutafuna yana fiwanai namoḡa kasi toviketanuneina be kasi tokawakawa Fita i iyavisiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Nofe kimoki avage tofenafena yana dewadewana i nisaiya fasinei kwa nunutoninuvenuvikiya. ");
INSERT INTO wat_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Na fasinei nuwanuwaku kwami keta yota Isineni kana matatafu kwata sanamaniya. Yeisu Togifafafana Gigibokeinana tene Nasaneti kana wavai namoḡa nofe naumiyai i misimisiniya, i dewadewamoka. Yeisunama kwa giviogonaḡanaiya eatu Guyau mateyai i sinaviyawasiya. ");
INSERT INTO wat_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tanake fasinei Guyau Fonakituna nenei i bwaduwa, ‘Koḡonanama kwami tokiyona kwa dibutoyoiya i visabuova.’ ");
INSERT INTO wat_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Eketa muka tamo yota aitevana ina gifafafaneita. Uḡuna muka tamo yota namai avi wava fwayafwaya nofe etanei Guyau namoḡa ita venei be ina gifafafaneita, naki mukamokena!” ");
INSERT INTO wat_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tovanama si kitisiya Fita keta Yoni na yasi katevatu keta nuwatasi i niiya tasike naki kuwekuwedunisi, muka tamo Mosese yana visime kana sanamana nenesiyai eatu yasi nusifufu nenei o si sabanutuḡa. Yota si kitakinanisiya tasike Yeisu nukusi. ");
INSERT INTO wat_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yota namoḡanama i dewadewa o si kitiya nukusi si misimisiniya, eketa si tuka. ");
INSERT INTO wat_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na fasinei Diu Kawakawa yasi kafa yokoyoko nenei si vikikinomanisiya eatu tasikeḡa si vikanunusifusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Si vikanunutoniya si bwaduwa, “Avamasi tata fufuniya noko namoḡasima nenesiyai? Yenusanema kana matatafu kiyakiyaya kafa nuwatabau nofe naki si sanamaniya eketa muka kata fata tana vikewa. ");
INSERT INTO wat_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Eatu ibanama fasinei muka tana kitamokei be ina kananiyaniya namoḡa nenesiyai. Tana sawanuvimatutisiya ebe muka yota Yeisu kana wava sina visavivinei namoḡa kasi kawasasai.” ");
INSERT INTO wat_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Muniyai yota si wene-savavinisiya si kanasuna eketa si sawanuvimatutisiya be mukamokena yota Yeisu kana wava sina visavivinei o sina visawavenena. ");
INSERT INTO wat_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Atu Fita keta Yoni si iyavisiya si bwaduwa, “Taki kwami fonami kana muniiya, nao Guyau kana kusifuvisinataniya. O nofe Guyau matanei dewadewana? Tututaumi kwa vinuwadadaneimi. ");
INSERT INTO wat_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na fasinei namoḡa kasi iyaveina aviyavana ka kitiya Yeisu i savivinisiya yota ka nowaniya yana visawavenena, muka kana onovei.” ");
INSERT INTO wat_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Eketa Namoḡa matatafusi o Guyau si sawasawadavadaviya tofenafena i dewadewa fasinei. Nofe fasinei Diu Kawakawa si bauwa avi ketaketai Fita keta Yoni sita vimatadawaneisi ebe muka namoḡa sita givinuwagoyoweisi, eketa si sawanuvimatutisiya nakasina keta naki si ketoyausiya. ");
INSERT INTO wat_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gwadinama i tufufena, kiyakiyaya kafa nuwatabau i kikinomana nenei o kana manamana 40 i teweiya. ");
INSERT INTO wat_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tovanama Fita keta Yoni si ketoyausiya, si niya keta kasi sabu si nusifufuwisiya matatafuna avana tovibwanaose nakanakasisi be tokawakawa si iyavisiya maise. ");
INSERT INTO wat_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tovanama si nowaniya, tamo nenei kayosi nakasinei si kawanunukuwa Guyau nenei si bwaduwa, “Tuveka yo, ka kisimokeu Tovisime, kwaḡa abama, fwayafwaya be gibo keta yota iba matatafusi sinesiyai kasi tokifufuna. ");
INSERT INTO wat_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fonau Kanunu Tafutafuna i nusifufuwiya waḡaki Deivida ka kaetoḡa nenei eketa i bwaduvioḡoniya tovanama i bwaduwa, ‘Ava uḡuna yo Kani Kwauna si kayokuḡa yota Isineni namoisi ketaketa kasi vinuwateweteweyeina si fufunakaoḡoweisi Guyau nenei? ");
INSERT INTO wat_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tufomu yagwanisi keta tovisime fwayafwayai si gidewadewa aviya fasinei eketa si vikatutamokisiya avage sina nuaviya Tuveka nenei eketa yota yana Togifafafana Gigibokeinana nenei.’ ");
INSERT INTO wat_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Naki avana Deivida i bwaduwiya o i vivenemokena. Menana nofe nakasinei tufomu Enoda Anitifasi be Noma tovisime Fonitiyasi Fainato be yota Kani Kwauna eketa yota fiyao Isineni tututausi si vikatutamokisiya eketa ka kaetoḡa tafutafuna Yeisu gigibokeinana si vinifainiya. ");
INSERT INTO wat_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kwaḡa fifiwanamokeu eketa aviyavana nauna ku vinuwadadaniya keta ku sawateweiya be sita saviviniya, maisemoka yota si saviviniya. ");
INSERT INTO wat_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tuveka yo, yasi sawanuvimatuta nenekiyai ku nowaniya eketa kima ka kaetoḡa ku givikatevatuki ebe yo fonau ka yaunei. ");
INSERT INTO wat_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ya fiwana ku veneiki be ka kaetoḡa tafutafuna Yeisu kana wavai namoḡa kana givibwina yota kiyakiyaya kafa nuwatabau kana savivinisiya ebe yo namoḡa ya fiwana sina kitiya.” ");
INSERT INTO wat_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tovanama si kawanunukukooḡa, kabainama namai si yokowa nenei i kanikunikuniya. Kanunu Tafutafuna matatafusi i vimaisiya eketa Guyau fonana si yauniya na yasi katevatu. ");
INSERT INTO wat_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tovitumaḡana matatafusi katekatesi be yasi nuwanuwa naki tamokaḡa. Muka tamo aitevana iba tamo ita katutatanai eatu tututausi nenesiyai si vikakakavenena. ");
INSERT INTO wat_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Guyau tonowana i givifiwanisiya venemokena eketa Tuveka Yeisu yana misini-savavineina fasinei wakakana si siya namoḡa nenesiyai. Eketa Guyau yana omukumukutana o tovitumaḡana matatafusi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Tamo tova tasike aviyaonana na yasi fwayafwaya o numa si vivikimwaneina eketa gabana si nenemiiya tonowana nenesiyai. Ebe aviyaonana na kasi dauna nao si venevenisiya. Na nenei eketa tovitumaḡana sinesiyai muka aitevana tamo iba ita nuwasai. ");
INSERT INTO wat_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yosefa o kafa kita i fufuniya. Tonowana yota si weniya Banabasi kana nuwanuwa, Namoḡa Amaona. Tanake Nebi tufuwina Saifunusi simuna nenei. ");
INSERT INTO wat_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yana fwayafwaya i vikimwaneiya eketa gabanina i nemiiya eketa tonowana i venisiya. ");
INSERT INTO wat_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Atu tamoka tovitumaḡana kana wava Ananaiyasi kawana Safaina nukusi yasi fwayafwaya atu tunina si vikimwaneiiya. ");
INSERT INTO wat_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tunina gabana i givikaviniya tauna fasinei eketa kawana o sanasanamanisi. Eatu tufotufo gabana i viya eketa tonowana i venisiya. ");
INSERT INTO wat_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Eketa Fita Ananaiyasi i iyaviya i bwaduwa, “Ananaiyasi, namaise yo Seitani ya nuwanuwa i kani yo Kanunu Tafutafuna nenei ku sawavigema, eyo fwayafwaya gabanina ku viya tunina ku givikaviniya tauḡu fasiweu atu ku vikanonono vitana matatafuna kuta veneiki? ");
INSERT INTO wat_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nauna o kwaḡa ya fwayafwaya yo muniyai ku vikimwaneiya. Eatu gabanina ku viya nenei aviyavana ya nuwanuwa maise o nenesiyai kuta visaviviniya, eatu fufuna nofe avi goyo ku fufuniya? Muka vitana kimaḡa nenekiyai kuta vikanonono, eatu yota Guyau nenei!” ");
INSERT INTO wat_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tovanama Ananaiyasi nofemaise i nowaniya, i fekuwa matematena. Aviyaonana iba nofe si nowaniya matatafusi si matuta. ");
INSERT INTO wat_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tufunakata tunisi si otowamisiniya keta kwafinina si waminiya, eyo si unakikinomaniya keta si tauniya. ");
INSERT INTO wat_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Vanavana kana bai tonusi muninei Ananaiyasi kawana si kanasuna namai Fita i fakwafakwa nenei eatu aviyavana i kikinomana o muka yasi sanamana. ");
INSERT INTO wat_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fita i iyavisiya i bwaduwa, “Yamasi kwa iyaveiku o naki maise gabana kana nakata na kawami kwa nisaiya tovanama yami fwayafwaya kwa vikimwaneiya?” Eketa si bwaduviyewa, “Ika, na naki maise.” ");
INSERT INTO wat_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Eatu Fita i iyavisiya i bwaduwa, “Namaise yo na kawami nuwanuwa kwa givifakiniya eyo Tuveka kanununa kwana anuvanuvai? Kwa nowaniya! Tufunakatasima kawami si tauniya o ketakawanai kaeyasayasaisi, eketa kwami yota sina unakikinomanimiya.” ");
INSERT INTO wat_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Naki tovanama nenei Fita naunei si fekuwa matematesi. Tovanama tufunakata si kanasuna, si kitisiya matematesi eketa si unakikinomanisiya keta kawasi niniunei si taunisiya. ");
INSERT INTO wat_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ekanesiya kana matatafu Yenusanema sinenei yota matatafusi aviyaonana biga si viya si matuta nakasina. ");
INSERT INTO wat_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kiyakiyaya kafa nuwatabau yagwanina tonowana si savivinisiya namoḡa nenesiyai. Eketa tovitumaḡana matatafusi Numa Kodukodu sinenei si vivikaninisaḡa eatu kabainama si weneweniya Sonomoni yana nukefakefa nenei. ");
INSERT INTO wat_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yenusanema kana matatafu sinenei namoḡa tovitumaḡana si vifotuwisiya nakasina. Eketa kasi matutai muka kana fata sina tuyanomwanisi. ");
INSERT INTO wat_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eatu muniyai namoḡa be vivine sabuvekamoka Tuveka Yeisu si vitumaḡaniya eketa si kenokanakanasuna tovitumaḡana kasi sabu nenei. ");
INSERT INTO wat_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Noko nenei keta namoḡa tovisafwavinaḡa si nemiina ke'ta nenesiyai eketa si vikenofanina kivaya be sita nenesiyai, ebe yo tovanama Fita ina nemiya nenei ita givikavinisiya o taki kanukanununaḡa ita givikavinisiya ebe sina bwina. ");
INSERT INTO wat_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yenusanema niniuna menanisima nenesiyai sabuveka yasi tovisafwavinaḡa be yota aviyaonana kanunu goyosi si nuwafisiya si nemiisiya eketa matatafusi si dewadewa. ");
INSERT INTO wat_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Eatu tovibwanaose kasi toviketanuneina keta kana sabu matatafusi Sadusi kunuma nenei si sinegoyowa. ");
INSERT INTO wat_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Noko yasi uḡunama fasinei, tonowana si givikavinisiya keta deniyai si tenefotisiya. ");
INSERT INTO wat_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Eatu na nuwabunanama nenei Tuveka kana kaetoḡa tamokaḡa abamei deni kasi kawa i yausiya atu i kikinomanisiya keta i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kwa nai kwa misini Numa Kodukodu kana wasiketai be biga nofe yawasi kiouna fasinei namoḡa matatafusi kwa iyaveisi.” ");
INSERT INTO wat_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Guyau kana kaetoḡa abamei fonana si muniiya keta tovawedanai si kanasuna Numa Kodukodu kana wasiketai eketa si vibutuwa namoḡa nenesiyai si vivisawavenena. Eatu na tovanama nenei tovibwanaose kasi toviketanuneina kana sabu nukusi si yokowa eketa Diu Kawakawa keta Isineni kasi toviketanuneina matatafusi si wenevakukusisiya. Eyo tuiyo si teweisiya si niya deniyai tonowana kasi tuova fasinei. ");
INSERT INTO wat_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eatu tovanama tuiyo si niya deniyai tonowana si kitaokavisiya. Eketa si makavinisiya si simana si bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Deni kasi dawanafota ka kitisiya naki dewadewasi yota kana tuiyo o naki noko. Eatu tovanama kawasima ka yausiya, muka tamo aitevana sinenei!” ");
INSERT INTO wat_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tovanama Numa Kodukodu kana tuiyo kasi toviketanuneina eketa tovibwanaose nakanakasisi sifufu nofe si nowaniya, nuwatasi i bauwa keta si vinuwana avamasi yota ina kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Eatu tovanama nenei, namoḡa tamokaḡa i kanasuna eketa i bwaduwa, “Ei, kwa nowaniya! Namoisima deniyai kwa tenisiya nofe tova Numa Kodukodu kana wasiketai si misimisiniya, Yeisu bigana si vivisawavenena namoḡa nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eketa tuiyo kasi toviketanuneina yana tuiyo nukusi si niya Numa Kodukodu nenei eketa tonowana si ovisiya. Eatu muka nuyakayakanai sita savivinei uḡuna si matuta namoḡa gabanai sita kifonufonuwisiya fasinei. ");
INSERT INTO wat_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tovanama si nemiisiya Diu Kawakawa nausiyai si vimisiniisiya. Eketa tovibwanaose kasi toviketanuneina i numatamatanisiya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ka sawatanimiya muka namoḡa nenesiyai kwana visawavenena gwadinama nofe kana wavai. Eatu mukanono! Fonaki kwa teweiya eketa yami visawavenena Yenusanema i gikafufuya. Yota kwa gwaeiya be kwa vivinoikiya gwadinama yana mate fasinei.” ");
INSERT INTO wat_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Eatu Fita tonowana nukusi fasisiyai i nufata i bwaduwa, “Guyau fonana kana muniiya eatu muka namoḡa. ");
INSERT INTO wat_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kwami fiyaomima o Yeisu ogonaḡanaḡai kwa nuvikukiya keta kwa nuvimatiya atu Guyaunama waḡawaḡata si kodukoduwa nenei mateyai i sinaviyawasiya. ");
INSERT INTO wat_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Eketa Guyau Yeisu i vitoḡavaneiya kikikatainei vifotu kabaina nenei Tovisime keta Togifafafana namoḡa fasisiyai. Nofe i saviviniya be kita Isineni i ovivitita be ina ugevinita yata fufunagoyo nenesiyai ebe ina vinuwateweita. ");
INSERT INTO wat_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nofe ibasima o venemokena uḡuna kima o kasi tokita keta kasi toviwakakaki maise yota Kanunu Tafutafuna. Tanake o Guyau i vininitiya aviyaonana yana bwadu kana tomuniyeina nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tovanama Diu Kawakawa Fita yana bwadu si nowaniya, sinesi i nubusubusuwaniya eketa nuwanuwasi tonowana sina nuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Atu namoḡa tamokaḡa kana wava Gamaniyeni o Diu Kawakawa sinesiyai Fanasi yoko nenei. Tanake visime kana tovisawavenena eketa namoḡa matatafusi si vifotuwiya. Matatafusi nausiyai i misiniya eketa tuiyo i visimeisiya keta tonowana si vikikinomanisiya menanai tova bwatanaḡa. ");
INSERT INTO wat_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eketa Diu Kawakawa i iyavisiya i bwaduwa, “Yaku sabu fiyao Isineni, aviyavana kwa nuwenuwiya fiyaosima nenesiyai kwana saviviniya fasinei kwana vinuwadadanadewadewa. ");
INSERT INTO wat_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kwana tukuya manamana aviyesi naki i kakaviya nenesiyai, namoḡa kana wava Tiyodasi avage i onavaneya vitana tanake tamo toviketanuneina nakasina. Eketa namoḡa kasi yagwana 400 maise si kanasuna kana sabu. Eatu Noma gabemani i vikaniyabinisiya eketa tovanama tonuaviya si nuvimatiya nenei, kana tomuniyeina si kafiyauyauna eketa yasi savivinanama i viibakaokaoḡowa. ");
INSERT INTO wat_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Muninei yota kasi saifa kana tovai, Yudasa tene Ganini yota Noma gabemani i vikaniyabinisiya eketa namoḡa nuwatasi i kaniya be si muniiya. Eatu tonuaviya yota si nuvimatiya keta kana tomuniyeina si kafiyauyauna. ");
INSERT INTO wat_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Eatu a iyaveimi, nofe namoisima avana si savisaviviniya muka kwana sawatanaisi naki kwa teneisi. Taki yasi viweikanakanata o taki tututausi yasi vinuwadadana nenei si savisavivina nao yawane ina kakaviya. ");
INSERT INTO wat_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Eatu taki visime nofe Guyau nenei nao muka kami fata kwana sawatanaisi. Akata kwana nuwatasanamaniya vitana Guyau tauna nenei kwa nunuaviya.” Yana nusifufu fasinei Diu Kawakawa nuwatasi i kaniya. ");
INSERT INTO wat_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eketa Numa Kodukodu kana tuiyo si iyavisiya keta tonowana si kanasuna-nemiisiya eketa si nafanafasisiya. Nokomai si sawatanisiya be muka Yeisu kana wava sina nunusifufuwei eyo muniyai si ketoyausiya. ");
INSERT INTO wat_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na yasi sebobo Diu Kawakawa si teweisiya uḡuna si sanamaniya Guyau i numwasimwasinisiya be i sawateweisiya sina kuvavana Yeisu kana wava fasinei. ");
INSERT INTO wat_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tova nubwayouna Numa Kodukodu kana wasiketai yota namoḡa yasi numa nenesiyai, si viketotonisiya si vivisawavenena eketa yota biga dewadewana si yauyauniya vitana Yeisu tanake o Guyau yana Togifafafana Gigibokeinana. ");
INSERT INTO wat_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Noko tovasima nenesiyai Yeisu kana tomuniyeina kasi yoko i dibwanamoka. Keta tunisi Diu atu tobwadu-Giniki si kanaonuonuwa tobwadu-Ibeniu nenesiyai yasi vivinekwafukwafuna fasisiyai. Uḡuna tova nubwayouna aviyavana kasi nuwagabubu kana tovituku muka vivinesima sita kitakitaisi. ");
INSERT INTO wat_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Na fasinei tonowana kasi 12 tomuniyeina matatafusi si wenevakukusisiya eketa nenesiyai si bwaduwa, “Muka kana kita dewadewana be Guyau fonana kana savivina kana onovei eatu kwafini kana ovivita nenei kana saḡa. ");
INSERT INTO wat_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Na fasinei unaunaki, sinemiyai namoḡa kasi 7 aviyaonana yasi dewa dewadewasi be Kanunu Tafutafuna keta nuwatasuyasuya nenei si maḡa kwa vinuwadadaneisi ebe savivina nofe nenei sina vitoovivita. ");
INSERT INTO wat_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ebe kima naki kana viketotonikiya kawanunuku keta Guyau fonana kana yauneina nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tomuniyeina matatafusi tonowana si vinowanisiya eketa si ginakata maise. Sitiveni o tanake tovitumaḡana venemokena yota Kanunu Tafutafuna nenei i maḡa. Keta yota Finifi, Fonokonusi, Nikano, Timoni, Fanimenasi. Eketa Nikonasi tene Anitiyoki o tanake muka tene Diu eatu nuwatana i kaviniya keta Diu yasi kodukodu nenei i kanasuna. ");
INSERT INTO wat_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tomuniyeina nofe fiyaosima si nemiisiya eketa tonowana nimasi si dawana etasiyai eketa si kawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Noko nenei tomuniyeina Guyau fonana kana yauneina si tenesaviya eketa Yenusanema sinenei tomuniyeina kasi yoko naki i nakatamoka. Yota tovibwanaose yagwanisi vitumaḡaninama si vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitiveni o naki Guyau yana omukumukutana keta yana fiwana nenei i maḡa be kiyakiyaya kafa nuwatabau fifiwanisi i savivinisiya namoḡa kasi kawasasai. ");
INSERT INTO wat_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eatu tunisi fiyao Diu yasi numa kafa yokoyoko kana wava Ketoketoyausi si managibuwiya. Fiyaosima o menana nakanakasisi maise Sainini, Anekisenidiya yota fafani Sinisiya eketa Eisiya nenesiyai si nemiya. Nofe fiyaosima si vibutuwa Sitiveni nukusi si vikawabwadubwaduwa. ");
INSERT INTO wat_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eatu nuwatasuyasuyanama Kanunu Tafutafuna i veniya maise o nenei i nusifufuwa. Na uḡuna muka kasi fata be fonana sina fatai. ");
INSERT INTO wat_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Na fasinei makamakaviunai namoḡa tunisi si kanadibidibiisiya keta Sitiveni fasinei si vikanononowa si bwaduwa, “Kima ka nowaniya iba goyosi i bwaduwisiya Mosese keta Guyau fasisiyai.” ");
INSERT INTO wat_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Noko bwadunama namoḡa i visimwananakasisiya yota tokawakawa keta visime kana tovisawavenena nukusi Sitiveni si givikaviniya eketa si sinakanikaniya si niiya Diu Kawakawa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eyo muniyai namoḡa tunisi tovikanonono si kanasunisiya keta si bwaduwa, “Nofe gwadinama o tova matatafuna Numa Kodukodu tafutafuna keta Mosese yana visime i manamanagibuwisiya. ");
INSERT INTO wat_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ka nowaniya i bwaduwa avage nofe Yeisunama tene Nasaneti Numa Kodukodu ina nuyauniya yota kata sanu Mosese waḡawaḡata i visawavenisiya ina dawanatamatamanina.” ");
INSERT INTO wat_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Namoḡa matatafusi Diu Kawakawa sinenei Sitiveni si toneye-vaḡasiya atu tafakaina si kitiya o vitana Guyau kana kaetoḡa abamei maise. ");
INSERT INTO wat_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eketa tovibwanaose kasi toviketanuneina Sitiveni i nutoninuvenuviya, “O vinoisima nofe venemokena?” ");
INSERT INTO wat_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Eketa Sitiveni i bwaduwa, “Unaunaku keta amamaku, yaku sifufu kwa vaneneḡei. Waḡata Ebenaamu muniyai yo i niya Anani menana nenei eatu yawane i fakwafakwa Mesofotamiya kana tovai, Guyau Etanemokenei i kenokikinomana nenei. ");
INSERT INTO wat_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","I iyaviya i bwaduwa, ‘Ya menana keta ya sabu kuna teweisiya atu fwayafwayanama ana visawaveniwa nenei kuna niya.’ ");
INSERT INTO wat_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Eketa Ebenaamu Mesofotamiya i teweiya eatu i niya Anani i fakwa. Amana i mateya muninei, Guyau i nemiiya fwayafwayanama nofe tova ta fakwifakwiiya nenei. ");
INSERT INTO wat_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Noko tovanama nenei nofemai muka tamo Guyau fwayafwaya matatafuna ita venei o taki kasimina ebe ina vitoniwagei, atu i bwadudabedabiya vitana susukwana nukusi fwayafwayanama yawane sina vitoniwagiya. Eatu noko tovanama nenei Ebenaamu muka tamo natuna. ");
INSERT INTO wat_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yota nofemaise Guyau i iyaviya i bwaduwa, ‘Susukwau sina viyauyauna mani fwayafwayai. Tonifwayafwaya susukwau sina vikaetoisiya keta yota sina vitoagoyogoyowisiya manamana 400 sinenei. ");
INSERT INTO wat_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Atu yawane tonifwayafwayasima yasi vitoagoyogoyo fasinei ana vimatadawanisiya eatu susukwau sina kikinomana-nemiya nofemai ebe nenekuwai sina kodukoduwa.’ ");
INSERT INTO wat_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eketa Guyau Dedeni kiyakiyayana Ebenaamu i veniya o nufifina. Na fasinei tovanama Ebenaamu natuna namoḡa Aisake i tufuwa eketa kuyadayada 8 muninei i nufifiniya. Muniyai Aisake natuna Yakobo i nufifiniya yota Yakobo natunatuna kasi 12 i nufifina. Noko tasike o kita waḡawaḡata. ");
INSERT INTO wat_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Yakobo natunatuna taisi Yosefa si sinegoyowiya eketa si vikimwaneiiya tovitamaneina nenesiyai keta si viya i vitovikaetoḡa Itifita nenei. Atu Guyau o Yosefa nukusi ");
INSERT INTO wat_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","eketa i ovivitiya tovanama namoḡa dauna nenei si teneteniya. Guyau nuwatasuyasuya i veniya na uḡuna Itifita tufomu nuwatana i oviya keta Yosefa i teniya yana numa eketa yota Itifita kana matatafu kana tovisime. ");
INSERT INTO wat_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Muniyai Itifita keta Kenani kasi matatafu noga i gikafufusiya keta namoḡa si kuvavana nakasina keta yota kabwaga kana nisaḡa i dauna. ");
INSERT INTO wat_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Atu tovanama Yakobo i biganowana vitana Itifita nenei kabwaga, kawa tamokaḡa waḡawaḡata i visimeisiya si niya nokomai. ");
INSERT INTO wat_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tovanama yasi nai kana vinuwa nenei, Yosefa tauna wakakana i siiya unaunana nenesiyai. Nokomai Itifita tufomu Yosefa ugunina i sanamanisiya. ");
INSERT INTO wat_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Eketa Yosefa yana matakawa i niya amana Yakobo keta yana sabu matatafusi nenesiyai ebe sina nemiya Itifita. Noko tovanama nenei o kasi yagwana 75. ");
INSERT INTO wat_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Eketa Yakobo i sobuwa Itifita keta nokomai yo waḡawaḡata nukusi si vikamatemateya. ");
INSERT INTO wat_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Eatu kwafinisi si makavinisiya menana Sekemu nenei keta kididikunama nauna Ebenaamu siniva nenei i kimwaniya fatana matanakasina Amo fasekwina nenesiyai, nokomai si tenisiya. ");
INSERT INTO wat_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tova i niketamwakufwamoka be Guyau avana yana bwadudabadaba Ebenaamu nenei ina vivenemokena, kata sabu Itifita sinenei naki i nakatamoka. ");
INSERT INTO wat_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Muniyai tufomu kiouna i vitovisimeya Itifita sinenei eatu muka tamo yana sanamana avana Yosefa i saviviniya Itifita fasinei. ");
INSERT INTO wat_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yata sabu i nonusiya eketa i givikuvavanisiya. I nuyakayakanisiya be natunatusi fwefweyasi menanai sita tenisiya ebe sita vikamatemateya. ");
INSERT INTO wat_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Noko tovanama nenei Mosese i tufuwa. Gwadimonamonanama o kotokiwaḡa Guyau matanei. Ayona keta amana si kitavikavina-samwagauwiya yamayamana tonusi yasi numa sinenei. ");
INSERT INTO wat_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Eatu tovanama si tenekikinomaniya menanai, tufomu natuna gumayogu i fayaiya eketa i weinakasiya maise tauna natuna. ");
INSERT INTO wat_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Itifita namoisi yasi ketaketa matatafuna kana sanamana nenei i gumaḡa, maise yota yana nusifufu be yana savivina nenesiyai fifiwanisi. ");
INSERT INTO wat_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tovanama Mosese kana manamana 40 i nisaiya, i vinuwadadana be tauna yana sabu Isineni ina venufotisiya. ");
INSERT INTO wat_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Eatu i kitiya tene Itifita tene Isineni i munumunuya eketa fasinei i badiwaga tene Itifita i nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosese i nuwanuwa vitana tauna yana sabu sita sanamaniya vitana tanake nimanei Guyau ina gifafafanisiya ebe muka sina vikaetoḡa Itifita nenesiyai, eatu muka sita kitasanamanei. ");
INSERT INTO wat_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kuyadayada kana vinuwa nenei Mosese i kitisiya fiyao Isineni kasi nuwa si vivikamunumunuwa eketa i anuvanuva be ina katuvisiya. I bwaduwa, ‘Ei, na naunau atu ava fasinei yo kwa vivikamunumunuwa?’ ");
INSERT INTO wat_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Atu tomanini gwadinama Mosese i tutukatuiya keta i iyaviya i bwaduwa, ‘Aitevana masi i ginakasiu ku vitovisime yo kima kuna vinuesaniki? ");
INSERT INTO wat_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Omasi kuna nuvimatikuwa maise foma tene Itifita ku nuvimatiya?’ ");
INSERT INTO wat_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tovanama Mosese bwadunama i nowaniya, i matuta keta i dibwana i niya fafani Midiyani nenei i viteneyauyauna. Nokomai i vikawana keta natunatuna namoḡa nuwesi si tufuwa. ");
INSERT INTO wat_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nokomai i fakwa kana nivaniva manamana 40 eatu tamoka tova koya Sainai niniunei wanakikaoḡowai Guyau kana kaetoḡa abamei i kikinomaniya kai nununuinei kisisiku sinefounei. ");
INSERT INTO wat_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tovanama Mosese noko i kitiya, i mayaḡa eketa i vaniya niniunei be ina toneye-dewadewiya. Eatu Tuveka kayona i nowaniya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iyau o waḡawaḡau Ebenaamu, Aisake eketa Yakobo yasi Guyau.’ Tovanama Mosese bwadu noko i nowaniya, i akikinikuna na yana matuta yota i matuta kai kana toneyeina fasinei. ");
INSERT INTO wat_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Eketa Tuveka i iyaviya i bwaduwa, ‘Fwayafwayanama nenei ku misimisiniya o tafutafuna, na fasinei ka kaevatakutakuna ku kaki. ");
INSERT INTO wat_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naki a kitiya Itifita namoisi yaku namonamoḡa si givigivikuvakuvavanisiya. A nowaniya yasi noita na fasinei a sobunemiya be ana ketoyausiya. Eketa ku vaneneḡa, ana teweiwa kuna makaviniwa Itifita be kuna ovivitisiya.’” ");
INSERT INTO wat_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Eyo Sitiveni yana sifufumokena i nusaviya, “Eketa nofe Mosese o tamoka gwadinama fiyao Isineni si dibutoyoiya tovanama si bwaduwa, ‘Aitevana masi i ginakasiu ku vitovisime yo kima kuna vinuesaniki?’ Guyau kana kaetoḡa abamei kisisiku nununuinei i kikinomaniya, yana ovivita nenei Guyau Mosese i vininitiya tovisime keta yota toketoyau. ");
INSERT INTO wat_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Itifitei i kikinomanisiya kana tovai, kiyakiyaya kafa nuwatabau i savivinisiya. Maise yota Gibo Yabeyabenina nenei keta yota fwayafwaya nunumonumona nenei manamana kana yagwana 40 sinenei. ");
INSERT INTO wat_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tamoka Mosesenama yota fiyao Isineni i iyavisiya i bwaduwa, ‘Tututaumi sinemiyai Guyau tamo aitevana ina ginakasiya fasimiyai ebe ina vitomatakawa maise iyau.’ ");
INSERT INTO wat_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosese o fiyao Isineni nukusi tovanama si yokowa fwayafwaya nunumonumona nenei eatu Guyau kana kaetoḡa abamei koya Sainai nenei Mosese i nusifufuwiya. Guyau yana bwadu fakwafakwa-vaḡasina i nowaniya eketa i tenetamaniya nenetiyai. ");
INSERT INTO wat_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Eatu waḡawaḡata si dibutoyoiya keta si tutukatuiya eatu si nuwayewa Itifita fasinei. ");
INSERT INTO wat_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eketa Anoni si iyaviya si bwaduwa, ‘Guyau tamo kuta fufuniya be ita viketanunita. Noko namoḡanama Mosese Itifitei i kikinomana-nemiita eatu muka tata sanamanei avao i kanasiya.’ ");
INSERT INTO wat_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Eketa kaivakuku tamokaḡa si ginivaviya kana kitakita maise bunumakau mwanavauna eketa nenei si vibwanaoseya keta aviyavana nimasiyai si fufuniya avage si kawiiya. ");
INSERT INTO wat_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Na fasinei Guyau i saḡakuwakufutisiya keta i teweisiya be si kodukoduwa kinavinavi, vanavana keta yamayamana nenesiyai. Naki maise Guyau fonakituna sinenei, yana tomatakawa si bwaduvioḡoniya si bwaduwa, ‘Kwami fiyao Isineni tovanama kwa fakwafakwa fwayafwaya nunumonumonei manamana 40 sinenei, yami kavenenakaoḡo yomuyomu o muka kwata vibwanaoseyeisi nenekuwai. ");
INSERT INTO wat_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yami iduiduwa Moneki kana bonu eketa yami iduiduwa kinavinavi Nefani mayauna kwa unadadanisiya. Noko kifukifufunasima kwa fufunisiya be nenesiyai kwa kodukoduwa. Na fasinei namoḡa ana teweisiya yami menanamokeyai sina vimiya be sina niimiya Babinoni muninei sasanemokenei.’” ");
INSERT INTO wat_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Yota Sitiveni i bwaduwa, “Waḡawaḡata Vada Tafutafuna si unadadaniya tovanama si fakwafakwa fwayafwaya nunumonumonei. Namaise Guyau Mosese koya Sainai etanei i gisawakedaniya, naki maisemoka i fufuniya. ");
INSERT INTO wat_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yota si tenetamaniya waḡawaḡata nenesiyai Yosuwa yana tovai, Guyau yana ovivitai be fwayafwaya nofe si viya mani namoḡa nenesiyai. Eketa Vada Tafutafuna si nemiiya nofemai i fakwa kana nivaniva tufomu Deivida yana tovai. ");
INSERT INTO wat_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Guyau Deivida yana nusuyai i niya keta Deivida i vikokona vitana ita sawateweiya be Numa Kodukodu ita yoniya Yakobo ugunina yasi kafa kodukodu Guyau nenei fasinei. ");
INSERT INTO wat_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Eatu Sonomoni Numanama i yoniya. ");
INSERT INTO wat_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Eatu Guyau Etanemokenei o muka namoḡa yasi kikiyona ita fakwifakwiyeisi. Maisemoka Guyau yana tomatakawa manatuwaina i viginiwiya maise, ");
INSERT INTO wat_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Tuveka i bwaduwa, “Abama o kaku kwabudoga eatu fwayafwaya o kaeku kana kafa vasafasafa. Eketa avi numa simo o kwata yonai fasikuwai? Muka tamo kabaḡa dewadewana kami fata kwana gidewadewai ebe ana fakwiyei, ");
INSERT INTO wat_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","uḡuna Iyau taumokeku iba matatafuna abamai keta fwayafwayai a fufunisiya.”’” ");
INSERT INTO wat_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Eketa Sitiveni i bwaduwa, “Kwami naki katekatemi guasi. Taniyami kwa gifota eketa muka Guyau yana bwadu kwata munimuniyei. Kanunu Tafutafuna kwa adibutoyotoyoiya naki maisemoka waḡawaḡami. ");
INSERT INTO wat_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Guyau yana tomatakawa i visimeisiya, matatafusi si givikuvavanisiya. Yota tobwadukikinomana Toeyaeyanamoka yana nemi fasinei o si nuvimatisiya. Eketa tovanama tauna i nemiya, kwami kwa viwaifufuniya keta kwa nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Guyau kana kaetoḡa abamei i visimeisiya eketa yana visime si venita eatu muka kwata kitavikaviniya.” ");
INSERT INTO wat_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tovanama Diu toviketanuneina nofe bwadunama si nowaniya, sinesi si nubusubusuwanina keta niḡosi si kitanavikavikavina nenei. ");
INSERT INTO wat_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Atu Kanunu Tafutafuna Sitiveni i vimaiya. I kitakawavitata abamai eketa i kitiya Guyau kana kaiwabu keta yota Yeisu i misimisiniya Guyau kikikatainei vifotu kabaina nenei. ");
INSERT INTO wat_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eketa i bwaduwa, “Kwa kitai! A kitakitiya abama kana kawa kakayauna eketa Namoḡa Natuna i misimisiniya Guyau kikikatainei vifotu kabaina nenei.” ");
INSERT INTO wat_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tovanama nenei, taniyasi si gifota atu si vikafinafina eketa si kududuwana Sitiveni fasinei. ");
INSERT INTO wat_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Si sinakanikaniya keta si kikinomaniya menana nakasina kwaunei eyo si vibutuwa gabanai si fonufonuya. Kana tovinoisima kasi nuya si kikakiya eketa namoḡa tufunakasina kana wava Sauno naunei si dawana. ");
INSERT INTO wat_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tovanama gabanai si fonufonuya nenei, i bwaukikinomana, “Tuveka Yeisu, kanunuku ku katuvai.” ");
INSERT INTO wat_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Eketa i fekuwa kaetutunei eatu i bwauwa, “Tuveka yo, muka yasi go'yonanama nofe kuna tukuya!” Tovanama nofe i bwaduwiya muninei i vidawana. ");
INSERT INTO wat_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Eketa Sitiveni kana nuvimate fasinei Sauno i visawadewadewiya. Tunisi Guyau kana tovimogumogu Sitiveni kwafinina si odewadewiya eketa fasinei si bwediutukwasoḡa. Na kuyadayadanama nenei ekanesiya Yenusanema sinenei daunamataina si nisaiya. Na nenei keta tovitumaḡana matatafusi si kafiyauyauna Yudiya keta Sameniya fafanisima nenesiyai eatu tonowanaḡa Yenusanema si fakwa. ");
INSERT INTO wat_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Atu Sauno i anuvanuva be ekanesiya ina nuyakweyakweniya. Eketa i niya numa tamokatamokaḡa nenesiyai, namoḡa be vivine i nusoni-kikinomanina keta i sinakanikanisiya eketa deniyai i tenisiya. ");
INSERT INTO wat_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Eatu tasike aviyaonana si kafiyauyauna, nao si fanakwaniuḡa menana nenesiyai eketa biga dewadewana si yauniya. ");
INSERT INTO wat_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Eketa maise Finifi o i sobuwa menana tamoka nakasina Sameniya sinenei eketa i numamana Togifafafana Gigibokeinana fasinei. ");
INSERT INTO wat_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Matatafusi yana sifufu si nowaniya eketa si nafanafiya uḡuna kiyakiyaya kafa nuwatabau i savivinisiya si kitisiya. ");
INSERT INTO wat_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kafa kita maise kanunu goyosi namoḡa yagwanisi si nuwafisiya, i nukakisiya keta si gionovisiya na yasi kwaesinasinae nukusi. Yota yagwanisi tanaisi matematesi keta fenafenasi i gidewidewisiya. ");
INSERT INTO wat_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eketa noko menaninama nakasina namoisi si sebobowa nakatamokena. ");
INSERT INTO wat_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Eatu noko menaninama nakasina nenei namoḡa tamokaḡa kana wava Saimoni i fakwafakwa eketa tova nubwayouna i viviboḡauwa eketa fiyao Sameniya o yana savivinasima nuwatasi i viya. Tova matatafuna i onaonavaneya vitana tanake o namoḡa tamo nakasina. ");
INSERT INTO wat_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Namoḡa matatafusi, muka kasi wava be na kasi wava nenesiyai, yana sifufu kana nowana nenei si bwaduwa, “Namoḡa nofe o Guyau yana fiwana matasikauna.” ");
INSERT INTO wat_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tova nubwayoumataina nuwatasi i kaniya yana oibaibasima nenesiyai. Na nenei keta naki tanakeḡa fonana si vanevaneneiya. ");
INSERT INTO wat_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Eatu tovanama Finifi biga dewadewana i numamaniya Guyau yana kafa visime fasinei yota Yeisu Togifafafana Gigibokeinana kana wava fasinei, namoḡa si vitumaḡaniya. Noko nenei namoḡa keta vivine i givibutibutisiya. ");
INSERT INTO wat_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimoni tauna yota biga i vitumaḡaniya eketa yota givibutabuta i viya. Noko nenei i vibutuwa Finifi i munimuniye-dadaniya uḡuna tova matatafuna kiyakiyaya kafa nuwatabau Finifi i savisavivinisiya o kafa mayaḡa tanake nenei. ");
INSERT INTO wat_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yenusanema sinenei tovanama tonowana si biganowana vitana fiyao Sameniya Guyau fonana si katuviya, Fita keta Yoni si visimeisiya si niya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Tovitumaḡanasima kiousi o naki givibutabutaḡa si viya Tuveka Yeisu kana wavai eatu Kanunu Tafutafuna o yawane muka sita vai. Na uḡuna Fita keta Yoni si kikinomana nokomai eketa Guyau si kawanunukuwiya be Kanunu Tafutafuna tovitumaḡana noko ina venisiya. ");
INSERT INTO wat_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Eketa tovanama nimasi si dawana tovitumaḡanasima debabousiyai Kanunu Tafutafuna si viya. ");
INSERT INTO wat_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Eatu Saimoni i kitanisaiya vitana namoḡa Kanunu Tafutafuna si viya tovanama tonowana nimasi si dawana debabousiyai. Na nenei gabana i tuniya, ");
INSERT INTO wat_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","eketa i vikokonisiya i bwaduwa, “Fiwana nofe yota iyau kwa veneiku, ebe aitevana nimaku ana teniya nenei kana fata Kanunu Tafutafuna ita viya.” ");
INSERT INTO wat_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Eatu Fita i iyaviya i bwaduwa, “Kana nufotamoka kwaḡa keta ya gabana Guyau ita nuyaunimiya. Nofe o Guyau yana kakavenena eatu ku nuwanuwa avage gabanai kuta kimwaniya! ");
INSERT INTO wat_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Muka tamo ka tukutuku ita fakwafakwa nofe mudadavanama nenei uḡuna katekateu o muka dawaniniina Guyau matanei. ");
INSERT INTO wat_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eketa nofe nuwanuwanama goyona nenei ku ugevinau ebe Tuveka ku kawanunukuwei. Kamo kana kita ya vinuwadadanasima katekateweu ina vinuwateweisiya. ");
INSERT INTO wat_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tumadama yo ya nuwasinae nenei nuwanuwa goyona i vivisimeiwa.” ");
INSERT INTO wat_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Eatu Saimoni i bwaduwa, “Fasikuwai Tuveka kwata kawanunukuwiya ebe avana kwa bwaduwiya muka nenekuwai ita kikinomana.” ");
INSERT INTO wat_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Eketa nauna Fita keta Yoni yasi vitumaḡana fasinei tututausi si viwakakakisiya keta yota Tuveka Yeisu bigana si nusifufuwiya tovitumaḡana kiousi nenesiyai. Tovanama yasi makavina Yenusanema nenei, kunausi biga dewadewana si yauniya menana yagwanisi nenesiyai Sameniya sinenei. ");
INSERT INTO wat_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tamoka tova Tuveka kana kaetoḡa abamei Finifi i iyaviya, “Ku misini be kugagasa ketanama Yenusanemei i sobusobuwa be i niniya Gasa, nenei kuna niya.” (Ketanama noko namoḡa nofe tova muka sita vaavaḡai.) ");
INSERT INTO wat_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Keta Finifi i noḡokawawa atu ke'ta tofwanei tene Etiyofiya i venusaiya. Namoḡanama o tanake tamo namoḡa nakasina, Etiyofiya kana tufomu gumayogu kana wava Kanidesi yana gabana matatafuna kana tokitavikavina. Namoḡanama i niya Yenusanema kodukodu fasinei. ");
INSERT INTO wat_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tovanama i makamakaviniya Etiyofiya, yana waganusoni sinenei i niniya eatu Guyau yana tomatakawa Aiseya yana viginiwa i giginaḡanaiya. ");
INSERT INTO wat_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Eketa Kanunu Tafutafuna Finifi i iyaviya, “Ku nai noko waganusoninama niniunei.” ");
INSERT INTO wat_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eketa Finifi i dibwanamoka waganusoninama niniunei eketa i nowaniya namoḡa Guyau yana tomatakawa Aiseya i viginiwiya, i giginaḡanaiya. Eketa Finifi i nutoninuvenuviya, “Na viginiwanama ku giginaḡanaiya simo kana sanamana ku viviya?” ");
INSERT INTO wat_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Eketa yana bwadu i fatiya, “Muka. Namaise masi ata sanamanei taki muka tamo kana givimayeta nenekuwai?” Noko nenei i vikokoniya Finifi keta i vaneya nukusi si toḡanuwa. ");
INSERT INTO wat_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Guyau fonakitunanama i giginaḡanaiya nenei o nofemaise i bwaduwa, “Vitana maise sifi si niiya be kayona sina kanibasiya eketa vitana maise sifi mwanavauna utuutuna kana tanakakanu fasinei naki i numananavamoka. Maisemoka tanake muka tamo kayona. ");
INSERT INTO wat_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Si sawanuketuwiya eketa si sawanoviya. Muka tamo tauna yana dana keta weyo kasi sanamana uḡuna yawasina fwayafwayai si viteweiya.” ");
INSERT INTO wat_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Keta namoḡa nakasina Finifi i nutoninuvenuviya, “Yamasi kuta iyavikuwa, Guyau yana tomatakawa tauna fasinei i bwadubwaduwa o taki tamo aitevana fasinei?” ");
INSERT INTO wat_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Eketa noko viginiwanama nenei Finifi i vibutuwa eketa biga dewadewana Yeisu fasinei i givimayeta. ");
INSERT INTO wat_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eketa si niniya eatu tovanama si nemiya sawa nenei namoḡa nakasina i bwaduwa, “Ake! Ukowa nofe. Muka tamo kaku nusiwataka, kuta givibutabutikuwa.” ");
INSERT INTO wat_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Eketa namoḡa nakasina i nusawataniya waganusoni kana tovidibwana atu nasi nuwa si sobuwa ukowai, eyo Finifi i givibutabutiya. ");
INSERT INTO wat_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tovanama ukowei si vanenemiya, Tuveka Kanununa Finifi i sinasamwagauwiya eketa i niiya tamo menana nenei. Noko nenei Namoḡa nakasina Finifi muka yota ita kitai eatu na sebobona yana ketai i niya. ");
INSERT INTO wat_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Eatu Finifi i kikinomana Adiyotusi menana nakasina nenei eketa menana matatafuna nenesiyai biga dewadewana i yauna-niiya kana nivaniva i nemiya Sisaniya menana nakasina nenei. ");
INSERT INTO wat_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Eatu Sauno na nuwagoyona i bwadu-kamanamana, “Tasike aviyaonana Yeisu kana tovitumaḡana ana nuvimatisiya.” I misiniya keta i niya Yenusanema tovibwanaose kasi toviketanuneina nenei, ");
INSERT INTO wat_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","eketa i vikokoniya be nufunufu ina viginiwisiya numa kafa yokoyoko kasi toviketanuneina nenesiyai Damasiko sinenei. Noko nufunufusima nenesiyai tovibwanaose kasi toviketanuneina sawateweyeina Sauno i veniya ebe noko menanasima nenesiyai avi namoḡa o avi gumayogu ina nisaiya Yeisu yana Ke'ta nununei i niniya, ina givikaviniya be ina nemiisiya Yenusanema deniyai. ");
INSERT INTO wat_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eketa i niniya Damasiko nenei eatu tovanama menana i ninikitekitiya, abamei mayesina matakikikwanena visabanutuḡai i tafafifiniya. ");
INSERT INTO wat_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sauno i fekuwa fwayafwayai eatu kayokayo i nowaniya i bwadubwaduwa nenei, “Sauno, Sauno, ava fasinei yo ku givigivikuvakuvavaneiku?” ");
INSERT INTO wat_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauno i nutoniiya i bwaduwa, “Aiye o kwaḡa aitevana?” Eketa i nufata i bwaduwa, “Iyau Yeisu, Iyau gwadikuma ku givigivikuvakuvavanikuwa. ");
INSERT INTO wat_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nofe tova kuna misiniya keta kuna kanasuna menana nakasinei ebe nokomai tamo aitevana ina iyaviwa avana kuta fufuniya.” ");
INSERT INTO wat_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Namoḡasima Sauno nukusi si niniya, si misinivaḡata keta kawasi si kataka uḡuna kayonaḡa si nowanowaniya eatu muka sita kitakitai. ");
INSERT INTO wat_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauno fwayafwayai i otowamisiniya keta i toneya eatu muka tamo aviyavana ita kitakitai. Na fasinei unaunana nimanei si givikavina eketa si kanasuniya Damasiko. ");
INSERT INTO wat_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kuyadayada tonusi sinesiyai matana i kwava eketa yota muka ita kaka keta muka ita yuyu. ");
INSERT INTO wat_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasiko nenei tomuniyeina tamokaḡa kana wava Ananaiyasi. Tuveka kenokitai i iyaviya i bwaduwa, “Ananaiyasi yo!” Eketa i nufata i bwaduwa, “Tuveka, iyau weka.” ");
INSERT INTO wat_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Eketa Tuveka i iyaviya i bwaduwa, “Ku misini be ke'ta kana wava Dawaniniina nenei ku nai ebe Yudasa yana numai ku nutoninuvanuva namoḡa kana wava Sauno tene Tasusi fasinei. Nofe tovanama nenei i kawakawanunukuwa nenekuwai. ");
INSERT INTO wat_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kana kenokita nenei namoḡa kana wava Ananaiyasi i kitiya avage i nemiya eketa nimana i dawana tofwanei eketa i kita-savaviniya.” ");
INSERT INTO wat_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Eatu Ananaiyasi i nufata i bwaduwa, “Tuveka yo, namoinama fasinei biga yagwanina a nowaniya vitana ka tovitumaḡana tafutafusi i givigivikuvavanisiya Yenusanema sinenei. ");
INSERT INTO wat_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yota nofe o tovibwanaose nakanakasisi sawateweyeina si veniya eketa i nemiya nofemai, ebe aviyaonana neneweu si kodukoduwa matatafusi ina givikavinisiya.” ");
INSERT INTO wat_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Atu Tuveka Ananaiyasi i iyaviya i bwaduwa, “Ku nai! A vitoniwagiya ina vikaetoikuwa ebe fasikuwai Kani Kwauna yasi tufomu nukusi yota fiyao Isineni ina numamanisiya. ");
INSERT INTO wat_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iyau taumokeku ana visawaveniya namaise kuvavana kana nakata yawane ina kuvavaniya kaku wava fasinei.” ");
INSERT INTO wat_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Eketa Ananaiyasi i niya keta i kanasuna numai. Nokomai nimana i dawana Sauno debabounei eyo i kawatakana i bwaduwa, “Unaku Sauno, gwadinama ketai ku kitiya tovanama ku nenemiya nofemai o Tuveka Yeisu. Gwadinama i vininitikuwa neneweu kuna kita-savavina fasinei yota Kanunu Tafutafuna nenei kuna maḡa.” ");
INSERT INTO wat_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Muka mwanenenama atu vitana iyana gwenavisi maise Sauno matanei si fekuwa eketa i kita-savaviniya. I otowamisiniya eketa Ananaiyasi i givibutabutiya. ");
INSERT INTO wat_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nokomai Sauno kabwaga i kawa keta fiwana i viya. Eketa Sauno i fakwa tomuniyeina nukusi kuyadayada kawaviya Damasiko nenei. ");
INSERT INTO wat_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Muka mwanenena tu Sauno i vibutuwa i numamana numa kafa yokoyoko nenesiyai vitana Yeisu o Guyau natuna. ");
INSERT INTO wat_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Matatafusi aviyaonana Sauno yana numamana si nowaniya si mayaḡa. Tututausiḡa si vikanunutoniya, “Nofe namoḡanama o Yeisu kana tomuniyeina i vivitoagoyogoyowisiya Yenusanema sinenei. Kamo ava tu i nemiya tamoka nuwanuwanama fasinei, tovitumaḡana ina givikavinisiya be ina niisiya tovibwanaose nakanakasisi nenesiyai?” ");
INSERT INTO wat_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Eatu Sauno i fiwanamataiya yana numamana nenesiyai vitana Yeisu o tanake Togifafafana Gigibokeinana. Eketa fiyao Diu Damasiko kana tofakwa muka kasi fata yana bwadusima fasisiyai avana tamo sina bwaduwei. ");
INSERT INTO wat_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kuyadayada aviyesi i kakavisiya muninei, Diu fiyaosi Sauno si viwaifufuniya be sita nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kuyadayada be nuwabuna menananama kasi ketakawana si toneye-vaḡasisiya kana nuvimate fasinei. Eatu yasi viwaifufuninama o Sauno naki i sanamaniya. ");
INSERT INTO wat_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nuwabuna tamokaḡa nenei tunisi kana tomuniyeina kautu nakasinei unavai si otanotanowiya menaninama kana kani kana nugiginabu nenei. ");
INSERT INTO wat_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tovanama Sauno i kikinomana Yenusanema, i anuvanuva be tomuniyeina ita tuyanomwanisiya eatu matatafusi si matutiya. Muka sita vitumaḡanei vitana tanake o naki Yeisu kana tomuniyeina. ");
INSERT INTO wat_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Eatu Banabasi Sauno i oviya keta i niiya tonowana nenesiyai. Eketa i nusifufuwisiya namaise Damasiko ketai Sauno Tuveka i kitai, yota namaise Tuveka Sauno i nusifufuwei. Keta yota i iyavisiya namaise Sauno Damasiko sinenei na yana katevatu Yeisu kana wavai i numamana. ");
INSERT INTO wat_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eketa nokomai tonowana nukusi si fakwa keta Tuveka kana wavai i numamana-fanakwaniuḡa Yenusanema na yana katevatu. ");
INSERT INTO wat_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yana nusifufuwai fiyao Diu atu tobwadu-Giniki nukusi si vikawabwadubwaduwa atu ketaketa si nuwasa kana nuvimate fasinei. ");
INSERT INTO wat_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tovanama tomuniyeina tunisi si biganowana, si oviya keta si sobuwiya Sisaniya eketa wakai si vitoiya i niya Tasusi tauna yana menanai. ");
INSERT INTO wat_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Noko nenei eketa Yudiya, Ganini keta Sameniya fafanisima nenesiyai ekanesiya kana matatafu biganei si fakwa. Eketa Kanunu Tafutafuna tomuniyeina i givikatevatusiya keta yasi vitumaḡana i givifakiniya. Na nenei tomuniyeina kasi sabu i nakata yota Tuveka kana vifotu i nakata. ");
INSERT INTO wat_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Fita yana nidadana menana tu menana nenesiyai eatu tamoka tova, menana Nida nenei tovitumaḡana i venufotisiya. ");
INSERT INTO wat_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nokomai namoḡa kana wava Aniyasi i venusaiya. Namoḡanama tanaina matematena eketa i matamataveya manamana 8. ");
INSERT INTO wat_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fita i iyaviya i bwaduwa, “Aniyasi, Yeisu Togifafafana Gigibokeinana i gidewadewiwa! Ku misini be ka sita ku kuwai.” Eketa na tovanama nenei Aniyasi i dewadewa. ");
INSERT INTO wat_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tovanama Nida keta Sanoni menanisima namoisi si kitiya Aniyasi i dewadewa eketa Tuveka si vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yofa menana nenei gumayogu tomuniyeina kana wava Tabita. (Giniki fonasiyai o kana wava Dokasi.) Tova matatafuna i nuwagabubuwa namoḡa nenesiyai keta yota i ovivita goyogoyo nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eatu noko tovanama nenei Fita yawane Nida i fakwafakwa eatu gumayogunama i visafwavinaḡa keta yawasina i kakaviya. Kwafinina si gidewadewiya keta numa kuetana kana totomu nenei si teniya. ");
INSERT INTO wat_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Eatu Nida menana o Yofa niniunei eketa tovanama Yofa tomuniyeina si nowaniya Fita Nida i fakwafakwa, namoḡa kasi nuwa si visimeisiya si niya kana tuova fasinei si iyaviya si bwaduwa, “Ae, nofe tova tata venuniya.” ");
INSERT INTO wat_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eketa Fita nukusi si niya. Tovanama si kikinomana, si vaneiya numa kuetana kana totomu nenei. Nokomai vivinekwafukwafuna yagwanisi si misinififiniya keta si bwedibwediya atu si vivisawaveniya kasi nuyasima tuninatunina i kwanisiya na yawasinei. ");
INSERT INTO wat_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Eketa Fita matatafusi i vikikinomanisiya eatu kaetutuna i viketogunisiya eketa i kawanunukuwa. Tovanama i nusafuwa i saḡaviniya gumayogu matematena nenei eketa i bwaduwa, “Tabita, ku misini!” Eketa gumayogu matana i kanakasiya eatu tovanama Fita i kitiya, i otowamisiniya keta i nuvitoiya. ");
INSERT INTO wat_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Gumayogu nimanei i givikavina eketa i sinavitowamisiniiya. Eyo vivinekwafukwafuna keta tunisi tovitumaḡana i wenisiya keta i visawavenisiya vitana Dokasi naki i yawasa-savaviniya. ");
INSERT INTO wat_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yofa kana matatafu bigana si nowaniya keta sabu Tuveka si vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Eketa nokomai Fita i fakwa kuyadayada matayagwanina namoḡa kana wava Saimoni nukusi. Nofe namoḡanama o yomuyomu matematesi kwafinisi nenei nogonogo fakifakinisi kasi tokifufuna. ");
INSERT INTO wat_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Menana Sisaniya nenei namoḡa tamokaḡa kana wava Koniniyasi, tanake tamo tonuaviya kasi 100 kana kaimatana Itani tonuaviya kunumisi nenei. ");
INSERT INTO wat_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Namoḡanama o toeyaeyana eketa yota yana sabu matatafusi nukusi Guyau kana tovimogumogu. I nuwagabubuwa goyogoyo nenesiyai eketa yota tova nubwayouna i kawakawanunukuwa Guyau nenei. ");
INSERT INTO wat_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tamoka tova vanavana i kavigeniya kana bai tonusi nenei, kenokita nenei i kitautuutuya Guyau kana kaetoḡa abamei i nemiya eketa i bwaduwa, “Koniniyasi!” ");
INSERT INTO wat_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Eketa Koniniyasi i toneiya na yana matuta eatu i nutoniiya, “Tuveka yo, avamasi ya nuwanuwa?” Eketa i nufata, “Tova nubwayouna ya kawanunuku keta ya nuwagabubu goyogoyo nenesiyai Guyau nuwatana i oviya vitana maise bwanaose mamadina. ");
INSERT INTO wat_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nofe tova namoḡa ku visimeyeisi si nai Yofa ebe Saimoni Fita si ovai. ");
INSERT INTO wat_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wavakokona Saimoni nukusi yana numai. Tanake o yomuyomu matematesi kwafinisi nenei nogonogo fakifakinisi kasi tokifufuna, gibokwadewai i fakwafakwa.” ");
INSERT INTO wat_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tovanama kaetoḡanama i nusifufukooḡa keta i mowa, Koniniyasi kana kaetoḡa nasi nuwa keta yana tonuaviya tamokaḡa tanake Guyau kana tovimogumogu i wenisiya. ");
INSERT INTO wat_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Eketa kana kenokitanama fasinei matatafuna i nusifufuwisiya muninei yo i visimeisiya si niya Yofa. ");
INSERT INTO wat_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kuyadayada kana vinuwa vanavana etatiyai, namoḡasima Yofa si venukitekitiya. Nofe kawasasanama nenei Fita i vaneya kudukudu kayavenina etanei kawanunuku fasinei. ");
INSERT INTO wat_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Eketa i vitanona eatu vivine yawane kabwaga si gigimwanemwaneneiya nenei o i kenokita. ");
INSERT INTO wat_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I kitiya abama i kawiya eatu vitana aviyavana maise nuya nafanafana noyana nufunina nenesiyai vitana tamo aitevana ita otanotanowei. ");
INSERT INTO wat_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nuyanama sinenei o yomuyomu be tooyaḡaḡa keta yota manuwa. ");
INSERT INTO wat_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kayokayo i kikinomana i bwaduwa, “Fita, ku misini! Ku munuwa be ku kawa!” ");
INSERT INTO wat_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Eatu Fita i nufata i bwaduwa, “Muka Tuveka, nao matatafusi viviketofotasi yota gavigavisi eketa mukamokena ata giginuvanuvaisi.” ");
INSERT INTO wat_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kayokayo i kikinomana-savaviniya i bwaduwa, “Aviyavana tamo Guyau i givieyaeiya muka kuna visawagoyowei.” ");
INSERT INTO wat_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tamoka kenokitanama i kitiya kawa tonu muniyai yo nuyanama i vanesavaviniya abamai. ");
INSERT INTO wat_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kenokitanama kana sanamana fasinei Fita yawane i vivinuwadadaniya eatu namoḡa kasi tonu Koniniyasi i visimeisiya naki Saimoni yana numai si kikinomana eketa yana ketakawanai si misimisiniya. ");
INSERT INTO wat_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Eketa si nutoniya, “Na tamo wagawaga kana wava Saimoni Fita?” ");
INSERT INTO wat_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Fita o yawane kenokitanama i vivinuwadadaniya atu Kanunu Tafutafuna i iyaviya i bwaduwa, “Ei, namoḡa nasi tonu si nunuwasiwa. ");
INSERT INTO wat_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Na fasinei ku misini ku sobu be nukusi kwa nai. Muka kuna vinuwana uḡuna Iyau a visimeisiya.” ");
INSERT INTO wat_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Fita i sobuwa nenesiyai keta i bwaduwa, “Iyau weka tauku kwa nunuwasikuwa. Namaise yo kwa nemai?” ");
INSERT INTO wat_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Namoḡa si nufata si bwaduwa, “Noma tamo kaimatana Koniniyasi i visimeikiya ka nemiya. Tanake namoḡa toeyaeyana yota Guyau kana tovimogumogu eketa fiyao Diu matatafusi si vivifotuwiya. Guyau kana kaetoḡa tafutafuna abamei i nusifufuwiya fasinei eketa ka nemiya ka tuova, tana niya yana numai be ya sifufu ina vaneneiya.” ");
INSERT INTO wat_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Eketa Fita namoḡasima i katuvisiya yana numai keta nokomai si banuwa. Eketa tova i katakiya i gidewadewa keta nukusi si niya. Atu yota tunisi Yofa tovitumaḡana kaena si kwafuya. ");
INSERT INTO wat_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kuyadayada kana vinuwa nenei i kikinomana Sisaniya. Koniniyasi yana sabu keta yana yaoyao i vakukusisiya keta yana numai si fotafota. ");
INSERT INTO wat_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tovanama Fita i kanakanasuna yana numai, Koniniyasi i venufotefotiya keta kaetutuna i viketogunisiya eketa i koduwa Fita kanonovanei. ");
INSERT INTO wat_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Atu i sinavitowamisiniiya keta i iyaviya, “Ku misini, iyau o namoḡamoka.” ");
INSERT INTO wat_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Eketa nasi nuwa si nunusifufuniya si kanasuna sinenei eketa Fita i kitisiya sabu si yokowa. ");
INSERT INTO wat_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","I iyavisiya i bwaduwa, “Kwa vaneneḡa! Matatafumi kwa sanamaniya Diu kama kwenava, muka tamo Kani Kwauna kana tuyanomwanimi o yota kana venufotaimi. Eatu Guyau naki i visawavenikuwa gewa muka mani namoḡa ana visawagavigaviyeisi. ");
INSERT INTO wat_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Eketa tovanama kwa nemiya kaku tuova fasinei, muka ata kabisawa. Eyo kwa iyaveiku namaise yo a nemai?” ");
INSERT INTO wat_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Eketa Koniniyasi i vibutuwa i nusifufuwa, “Kuyadayada nufunina i kakavisiya vanavana i kavigeniya kana bai tonusi, nao yaku numai a kawakawanunukuwa. Eatu tovanama nenei, namoḡa kana nuya nukawanamanamaneinasi naukuwai i kikinomaniya. ");
INSERT INTO wat_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Eketa i nusifufuwa i bwaduwa, ‘Koniniyasi, ya kawanunuku be ya nuwagabubu goyogoyo nenesiyai Guyau nuwatana i oviya. ");
INSERT INTO wat_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Namoḡa ku visimeyeisi si nai Yofa ebe Saimoni Fita si ovai. Wavakokona Saimoni nukusi yana numai. Tanake o yomuyomu matematesi kwafinisi nenei nogonogo fakifakinisi kasi tokifufuna, gibokwadewai i fakwafakwa.’ ");
INSERT INTO wat_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eketa muka mwanenena a visimeisiya fasiweu eketa a viagigikuwa naki ku nemiya. Na fasinei nofe tova matatafuki ka yokowa ka vanevaneneiwa Guyau matanei be matatafuna avana Tuveka i visimeiwa fasikiyai ku nusifufuweiki.” ");
INSERT INTO wat_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Eketa Fita i vibutuwa i nusifufuwa i bwaduwa, “Nofe tova a nuwatasanamaniya gewa Guyau muka tamo aitevana yana nusuyai ita ninai. ");
INSERT INTO wat_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Eatu kunuma tuninatunina nenesiyai aviyaonana Guyau si vivimogumoguwiya keta si fufufuna dawaniniina nenei nao i katukatuvisiya. ");
INSERT INTO wat_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Eketa Yeisu Togifafafana Gigibokeinana o namoḡa kata matatafu yata Tuveka. Aitevana ina vitumaḡaniya, nao kana fata Guyau ina viyaowiya. Nofe biganama dewadewana fasinei o Guyau i vininitiya Isineni nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Aviyavana matatafuna Yeisu yana mudadava Yudiya kana matatafu nenei o naki kwa sanamaniya. Yoni i numamana givibutabuta fasinei muniyai yo Yeisu mudadava nofe i vibutuwa Ganini nenei. ");
INSERT INTO wat_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ka kitiya namaise Guyau Kanunu Tafutafuna nenei Yeisu tene Nasaneti i vimaiya keta yota i givifiwaniya. Yeisu i niya menana yagwanina nenesiyai iba dewadewasi i savivinisiya, yota namoisima Seitani yana fiwana sifunei matatafusi i gidewadewisiya uḡuna Guyau o tanake nukusi. ");
INSERT INTO wat_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Namaise yana mudadava Yudiya kana matatafu keta yota Yenusanema sinenei, nao kima tonowana kana tokita keta kana toviwakakaki. Si giviogonaḡanaiya keta si nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Eatu kuyadayada kana vitonu nenei Guyau i sinaviyawasiya eketa i vimaikitikiya. ");
INSERT INTO wat_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mateyai yana misini-savavineina muninei muka namoḡa matatafusi sita kitai. Naki kimaḡa o nukusi ka kawa keta ka yuwa. Namoikima o Guyau i gibokikiya sifufuna kana yaugeyaniya fasinei. ");
INSERT INTO wat_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yeisu i visimeikiya be namoḡa kana numamanisiya be kana viwakakakisiya vitana tanake o Guyau i ginakasiya yawayawasisi keta matematesi kasi tonuvisi. ");
INSERT INTO wat_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Guyau yana tomatakawa matatafusi Yeisu fasinei si viginiwa si bwaduwa, taki namoḡa sina vitumaḡaniya nao kana wavai Guyau yasi go'yona ina vinuwateweisiya.” ");
INSERT INTO wat_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fita yawane i nunusifufuwa eatu bwadu nofe kana tovaneneḡa matatafusi nenesiyai Kanunu Tafutafuna naki i sobunemiya. ");
INSERT INTO wat_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Eketa Diu tovitumaḡana nunufifinisi Yofei Fita kaena si kwafuya si mayaḡa uḡuna Kani Kwauna eatu Kanunu Tafutafuna i sobunemiya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Si nowanisiya meyasi i kaviniya keta Guyau si davadaviya. Eketa Fita i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kanunu Tafutafuna si viya naki maisemoka kita ta viya. Na fasinei muka tamo aitevana ina viketofoteita kasi givibutabuta fasinei.” ");
INSERT INTO wat_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Eketa i visimeisiya be Koniniyasi yana sabu nukusi sina givibutibutisiya Yeisu kana wavai. Noko muninei Fita si vikokoniya be kuyadayada aviyesi nukusi nokomai sita fakwa. ");
INSERT INTO wat_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tonowana keta tunisi tomuniyeina Yudiya fafani sinenei, si nowaniya vitana yota tunisi Kani Kwauna o Guyau fonana naki si katuviya. ");
INSERT INTO wat_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Eketa tovanama Fita i vaneya Yenusanema tunisi Diu tovitumaḡana nunufifinisi si managibuwiya si bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Kwaḡa o ku kanasuna tasike muka nunufifinisi yasi numai keta nukusi kwa kawa!” ");
INSERT INTO wat_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Eketa Fita i vibutuwa i givimayeta nenesiyai aviyavana i kikinomana kana matanabobotai. ");
INSERT INTO wat_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","I bwaduwa, “Yofa a fakwafakwa atu a kawakawanunukuwa nenei a kenokita. A kitiya abamei vitana aviyavana maise nuya nafanafana. Eatu noyana nufunina nenesiyai vitana aitevana tamo i otanowei nenekuwai. ");
INSERT INTO wat_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Eketa sinenei, a kitisiya yomuyomu-menana keta yomuyomu-wanawanaki yota tooyaḡaḡa keta manuwa. ");
INSERT INTO wat_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Eketa kayokayo a nowaniya i iyavikuwa, ‘Fita, ku misini! Ku munuwa be ku kawa!’ ");
INSERT INTO wat_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Atu a nufata a bwaduwa, ‘Muka Tuveka, nao matatafusi viviketofotasi yota gavigavisi eketa mukamokena ata giginuvanuvaisi.’ ");
INSERT INTO wat_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Eketa abamei kayokayo i bwadu-savaviniya i bwaduwa, ‘Aviyavana tamo Guyau i givieyaeiya muka kuna visawagoyowei.’ ");
INSERT INTO wat_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tamoka ibanama kawa tonu i kikinomana muniyai yo matatafuna i savaviniya abamai. ");
INSERT INTO wat_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Na naki kawasasanama nenei namoḡa kasi tonu Sisaniyei si visimeisiya numanama a fakwafakwa nenei si kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kanunu Tafutafuna i iyavikuwa be namoisima nukusi kana niya eatu muka na yaku vinuwana. Nofe tovitumaḡanasima nasi 6 Yofei o kaeku si kwafuya keta Koniniyasi yana numai ka kanasuna. ");
INSERT INTO wat_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Eketa i nusifufuwikiya namaise Guyau kana kaetoḡa abamei i kitiya yana numa sinenei i kikinomaniya keta i iyaviya i bwaduwa, ‘Namoḡa ku visimeyeisi si nai Yofa be Saimoni Fita si ovai. ");
INSERT INTO wat_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ebe ya sabu nukusi Guyau fonana i nusifufuweimi kami gifafafana fasinei.’ ");
INSERT INTO wat_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Eketa a vibutuwa be a nunusifufuwa eatu namaise Kanunu Tafutafuna kafa viuḡuwai i sobunemiya nenetiyai naki maisemoka yota i sobunemiya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eketa a tukuya Tuveka Yeisu yana bwadu, ‘Yoni ukowa nenei i givibutabuta, atu Guyau o Kanunu Tafutafuna nenei ina givibutibutimiya.’ ");
INSERT INTO wat_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Naki mayemayetamokena gewa tovanama Tuveka Yeisu Togifafafana Gigibokeinana ta vitumaḡaniya be kakavenenanama Guyau i venita maise tasike yota i venisiya. Keta iyau o aitevana yo Guyau ata nusawatanai?” ");
INSERT INTO wat_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tovanama nofemaise Fita nenei si nowaniya, kana managibu si onoviya atu Guyau si sawadavadaviya si bwaduwa, “Mukanono. Gewa Guyau naki Kani Kwauna kawasasa i venisiya sina ugevinisiya be yawasivaḡata sina nisaiya.” ");
INSERT INTO wat_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yeisu kana tovitumaḡana dauna nakasina si nisaiya tovanama Sitiveni yana mate muninei eketa si kafiyauyauna. Tunisi si niya Foenisiya yana fafani nenei yota simuna Saifunusi eketa Anitiyoki menana nakasina nenei, Yeisu bigana si yaugeyaniya fiyao Diuḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eatu tunisi tovitumaḡana simuna Saifunusi nenei keta Sainini menana nakasinei, si niya Anitiyoki menana nakasinei eketa Ginisi namoisi si numamanisiya biga dewadewana Tuveka Yeisu fasinei. ");
INSERT INTO wat_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Eketa Tuveka yana fiwana nenei i ovivitisiya keta namoḡa yagwanisi si vitumaḡana eketa si ugevinisiya Tuveka nenei. ");
INSERT INTO wat_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ekanesiya Yenusanema sinenei si biganowana nofe fasinei eketa Banabasi si visimeiya i niya Anitiyoki. ");
INSERT INTO wat_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Banabasi tanake o namoḡa dewadewana yota Kanunu Tafutafuna nenei i maḡa eketa yota tovitumaḡanaonaona. Tovanama i kikinomana keta Guyau yana sawanuwagabubu i kitanisaiya namoḡa noko nenesiyai, i sebobowa kitagoyona. Atu matatafusi i vatonisiya be Tuveka Yeisu kana vitumaḡana nenei sina viketotonisiya venemokena. Eketa namoḡa sabuveka Tuveka si vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nokomai Banabasi i misiniya keta i niya Tasusi, Sauno kana nuwasa fasinei. ");
INSERT INTO wat_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Eketa tovanama i nisaiya, i oviya keta i makaviniya i nemiiya Anitiyoki. Naki manamana kana matatafu nasi nuwa ekanesiya nukusi si vivikaninisaḡa eketa namoḡa sagisagigi nenesiyai si vivisawavenena. Eketa Anitiyoki nenei tomuniyeina si mikiwenisiya Yeisu kana sabu. ");
INSERT INTO wat_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Noko tovanama nenei tunisi Guyau yana tomatakawa Yenusanemei si sobunemiya Anitiyoki. ");
INSERT INTO wat_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sinesiyai o namoḡa tamokaḡa kana wava Agabusi. Kanunu Tafutafuna yana fiwanai i misiniya keta i bwaduvioḡoniya vitana tova kabegomokena, noga nakasina ina kataneneḡa Noma yana kafa visime kana matatafu nenei. Nofe ibanama i vivenemokena tovanama Konodiyasi yana vitufomu Noma nenei kana tovai. ");
INSERT INTO wat_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Na fasinei tomuniyeina Anitiyoki sinenei si vinuwadadana vitana gabana sina giviyobuwa tututausi kasi nufotai be sita vininitiya unaunasi Yudiya nenei si fakwafakwa fasisiyai. ");
INSERT INTO wat_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nuwagabubunama si viya eyo Banabasi keta Sauno nimasiyai si teniya be yo nokomai tovitumaḡana kasi tokawakawa sina venisiya. ");
INSERT INTO wat_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tovanama Banabasi keta Sauno si niya Yenusanema kana tovai, tufomu Enoda Aganifa i vibutuwa be tunisi tovitumaḡana ekanesiya sinenei i givigivikuvakuvavanisiya. ");
INSERT INTO wat_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yana tonuaviya i iyavisiya keta Yoni tawaḡana Yemesa kayona si nuonosiya fetowai. ");
INSERT INTO wat_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tovanama Enoda i kitiya vitana aviyavana i fufuniya o kafa sebobo Diu nenesiyai, yana tonuaviya yota i iyavisiya keta Fita si givikaviniya. Nofe si fufuniya o Maneka Muka Nakana Nutuva Kana Ka kana tovai. ");
INSERT INTO wat_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tovanama Fita deniyai si teniya, Enoda yoko nufunina tonuaviya i tenisiya be sina kitavikaviniya. Yoko tamokaḡa sinenei tonuaviya nasi nufunina ebe yo yasi tovatovai Fita sina vivinanuya. Enoda nuwanuwana be Venuvisinatana kana Ka muninei, namoḡa matatafusi matasiyai atu ina nutonikuekuiya. ");
INSERT INTO wat_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Na fasinei Fita deniyai si tenefotiya. Eatu ekanesiya o yawasisi matatafunei si kawakawanunukuwa Guyau nenei kana ovivita fasinei. ");
INSERT INTO wat_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Eketa kana nuwabuna be tova ina katakiya nenei vitana Enoda Fita ina nutonikuekuiya, eatu Fita tonuaviya kasi nuwa kasi sinefouwai i banubanuwa. Nimana si nudigwanisiya seni nuwesi nenesiyai eatu yota tunisi tuiyo o deni kawana si kitavikaviniya. ");
INSERT INTO wat_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sabanutuḡai Tuveka kana kaetoḡa abamei i kikinomana Fita niniunei eketa totomu i mayesiya. Kaetoḡanama Fita niniuna i ketogadiya nenei, i weikenokitiya eketa i iyaviya i bwaduwa, “Ku venumisini!” Eketa seni nimanei i kakakisiya. ");
INSERT INTO wat_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Eyo kaetoḡanama i bwaduwa, “Ku kanibubuna be ka kaevatakutakuna ku kotoneina.” Eketa Fita i fufuniya, eyo kaetoḡanama yota i bwaduwa, “Ka kwame nenei ku waminiu be ku muniyeiku.” ");
INSERT INTO wat_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Eketa Fita i muniiya keta si kikinomana. Eatu muka ita sanamanei vitana kaetoḡanama yana visanafu o venemokena, yana nuwanuwa vitana ita kenokenokita. ");
INSERT INTO wat_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tuiyo yoko tamokaḡa si niunisiya eketa si nemiya yota yoko kana vinuwa nenei, muniyai yo si nemiya ke'ta kana kawa vikainumuna nenei. Ketanama o i niniya menana nakasina kuweyaina. Deni kana kawa tauna i kayauya eatu si kikinomana keta si niya tamo ke'ta nenei si sobuwa. Eyo nokomai kaetoḡanama Fita i vateweiya keta na tovanama nenei i mowa. ");
INSERT INTO wat_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tovanama nenei Fita nuwatana i kanabunabuya eketa i bwaduwa, “Nofe o naki a sanamaniya gewa venemokena Tuveka kana kaetoḡa abamei i visimeiya keta Enoda nimanei i sinavikuwa ebe muka fiyao Diu yasi nuwanuwa maise ina fufuniya.” ");
INSERT INTO wat_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tovanama Fita naki i kitiya Guyau i guguiya, eketa i niya Meni, Yoni Maka ayona, yasi numai. Numanama nenei tovitumaḡana yagwanisi si yokowa eketa si kawakawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Eatu Fita kawa kana vinuwa kumenanina nenei i nufisifisika eketa kaetoḡa kakaabana kana wava Noda i nemiya kawa kana kiyau fasinei. ");
INSERT INTO wat_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tovanama Fita i nutoniya nenei, Noda kayona i kinaniya. Eatu sebobo i tewesafuya eketa kawa muka ita yauya atu i venukanasuna keta i iyavisiya i bwaduwa, “Aiyui! Fita nofe ketakawanai i misimisiniya.” ");
INSERT INTO wat_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Eatu si iyaviya si bwaduwa, “Kamo ku wafa!” Eatu i tenekasikasiyei muka yo si bwaduwa, “Ei, nai o Fita yana kaetoḡa abamei!” ");
INSERT INTO wat_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eatu Fita yawane i teniya be i nunufisifisika. Tovanama kawa si yauya nenei, si kitiya eketa si mayaḡa. ");
INSERT INTO wat_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Atu Fita nimanei i nusawatanisiya ebe sina manava, eatu i nusifufuwisiya namaise Tuveka deniyai i vikikinomanei. Yota i iyavisiya i bwaduwa, “Yemesa keta tovitumaḡana tunisi kwana nusifufuwisiya aviyavana i kikinomana fasinei.” Eyo Fita Yenusanema i teweiya atu i niya tamo menana nenei. ");
INSERT INTO wat_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nuwabuniyai deniyai tonuaviya nuwanuwa yaona i vanisiya Fita yana bwavi fasinei. ");
INSERT INTO wat_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tovanama Enoda i biganowana, yana tonuaviya i visimeisiya be si nuwasa eatu muka sita nisaḡai. Na fasinei tuiyosima Fita si kitavikaviniya, Enoda Aganifa i nutonikuekuisiya. Eketa tonuaviya i sawanuyakanisiya be tuiyosima sina nuvimatisiya. Noko muninei Enoda Yudiya i teweiya eatu i sobuwa Sisaniya menana nakasina nenei i toḡanovenoviya. ");
INSERT INTO wat_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Enoda i nuwagoyowa fiyao Taya keta Saidoni nenesiyai. Na fasinei si vikatutamokisiya eketa si niya kana kita fasinei. Tufomu tauna kana tookakikakina kana wava Banasitasi nuwatana si kaniya eketa Enoda i vikokoniya be sita viyaowa uḡuna kasi kabwaga kana ketama nonowana o Enoda yana fafaniyai. ");
INSERT INTO wat_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Eketa tovanama noko kuyadayadanama i vikanatutuya, tufomu kanibubuna Enoda i kotonisiya keta kana kwabudogai i nuvitoiya atu nenesiyai i numamana. ");
INSERT INTO wat_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tovanama sabu kayona si nowaniya, si vibutuwa si nukatubwaubwauwiya, “Oa! Nofe o tanake naki guyau kayona, muka namoḡa!” ");
INSERT INTO wat_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sabanutuḡai Tuveka kana kaetoḡa tamokaḡa abamei Enoda i vikawagagasiya eketa i visafwavinaḡa nakasina, uḡuna namoḡa muka ita iyaveisi be Guyauḡa sita gikaikaiwabuya. Noko fasinei mwatanaiya sinena si venuyayawaniya eketa i vidawana. ");
INSERT INTO wat_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Eatu tovitumaḡana si viketotonisiya be Guyau fonana si yaugeyaniya eketa namoḡa sabu Yeisu si vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tovanama Banabasi keta Sauno yasi bunanige Yenusanema si nusafuwa, Yoni Maka si oviya keta nukusi si makavinisiya Anitiyoki. ");
INSERT INTO wat_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ekanesiya Anitiyoki nenei sinesiyai o tunisi tomatakawa yota tunisi tovisawavenena. Kasi wava o Banabasi, Simiyoni (kana wava venuwana Bowa), Nusiyasi tene Sainini, Manaeni (tanake tufomu Enoda Anitifasi nukusi vikatufutufuwasima), eketa yota Sauno. ");
INSERT INTO wat_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tamoka tova tovitumaḡana matatafusi si yokowa eketa Tuveka nenei si kodukoduwa keta si vivikokowana, eatu Kanunu Tafutafuna nenesiyai i bwaduwa, “Banabasi keta Sauno kwana tenesinisiya. A gibokisiya yaku nuwanuwa sina saviviniya fasinei.” ");
INSERT INTO wat_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yasi vikokowana keta kawanunuku muninei, nimasi si dawana Banabasi keta Sauno debabousiyai eyo muniyai si teweisiya si kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Eketa Kanunu Tafutafuna yana visime nenei nasi nuwa si sobuwa Senusiya eketa wakai si tamana Saifunusi simunai. ");
INSERT INTO wat_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tovanama Sanamisi menana nenei si kikinomana, fiyao Diu yasi numa kafa yokoyoko sinesiyai Guyau fonana si yauniya namoḡa nenesiyai. Noko tovanama nenei o Yoni Maka nukusi, kasi toovivita. ");
INSERT INTO wat_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Simunanama si vaonosiya keta si nemiya kana nivaniva Fafosi. Nokomai tene Diu toibaiba keta tomatakawa-vikanonono kana wava Ba-Yeisu si venusaiya. ");
INSERT INTO wat_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Namoinama o tene Noma kana wava Segiusa Fonasi nenei i fakwafakwa. Segiusa tanake simuna kana tovisime yota tanake tamo tonuwatasuyasuya. Nuwanuwana be Guyau fonana ina vaneneiya, na fasinei Banabasi keta Sauno i wenisiya be sina venufotiya. ");
INSERT INTO wat_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Eatu toibaibanama Ba-Yeisu (Giniki fonasiyai o Enimasi) muka nuwanuwana be tovisimenama ina vitumaḡana eketa i sawafafafanisiya. ");
INSERT INTO wat_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Eketa Sauno, kana wava yota Fauno, Kanunu Tafutafuna nenei i maḡa eketa Ba-Yeisu i kitamanonowiya. ");
INSERT INTO wat_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Eketa i iyaviya i bwaduwa, “Kwaḡa o Seitani natuna! Matatafuna avana dewadewasi ku vivikaniyabinisiya. Kanadibidibi keta vikanonono nenei ku saiya. Tova matatafuna Tuveka yana ketaketa dawaniniisi eatu ku viviviisiya! ");
INSERT INTO wat_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eketa ku vaneneḡa, Tuveka yana fiwana ina vimatadawaniwa be matau ina kwava ebe muka kana fata vanavana yana mayesina kuna kitai tova bwatana nenei.” Kimokimokima tu sowa keta kumanovana Ba-Yeisu matana i sowiya. Muka tamo avana ita kitai, na fasinei namoḡa i gifisaḡa be nimanei sita givikavina be sita niiya. ");
INSERT INTO wat_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tovanama tovisimenama i kitiya aviyavana i kikinomana Ba-Yeisu nenei, i vitumaḡana uḡuna visawavenena noko Tuveka fasinei nenei i mayaḡa. ");
INSERT INTO wat_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Fauno unaunana nukusi Fafosi menana si teweiya eatu wakai si niya Fega menana nenei Famufiniya yana fafani nenei. Nokomai Yoni Maka i venuteweisiya eatu i makaviniya Yenusanema. ");
INSERT INTO wat_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Eketa Fega nenei si misiniya keta si vaneonota keta fafani Fisidiya kana Anitiyoki menana nakasina nenei si kikinomana. Eketa kuyadayada Sabati si kanasuna numa kafa yokoyoko nenei si nuvitoḡa. ");
INSERT INTO wat_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mosese yana visime keta yota Guyau yana tomatakawa yasi viginiwa kasi ginaḡanaḡa muninei, numa kafa yokoyoko kana toviketanuneina bwadu si vininitiya Fauno keta Banabasi nenesiyai si bwaduwa, “Unaunaki, taki tamo bwadu-vatoneina nenemiyai maise o namoḡa kwa nusifufuweisi.” ");
INSERT INTO wat_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Eketa Fauno i misiniya, nimanei namoḡa i nusawatanisiya eketa nenesiyai i bwaduwa, “Fiyao Isineni keta kwami Kani Kwauna atu Guyau kana tovimogumogu, kwa vaneneḡeiku! ");
INSERT INTO wat_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kita fiyao Isineni manatuwaina yata Guyau i gibokisiya waḡawaḡata eketa kasi sabu i givinakasiya tovanama yasi vikaetoḡa Itifita sinenei kana tovai. Eatu yana fiwana utubasinei Itifitei i kikinomanisiya. ");
INSERT INTO wat_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Eketa manamana 40 fwayafwaya nunumonumonei i kunuwanisiya. ");
INSERT INTO wat_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Eketa Guyau fiyao Kenani kunuma 7 i vatanisiya eatu yasi fwayafwayanama kita i venita eketa ta vitoniwagiya. ");
INSERT INTO wat_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tovanama waḡawaḡata si kanasunavauvauwa Itifita kana tovai atu i nemiya kana nivaniva 450 manamana i kakavisiya muninei yo Kenani si fakwa. Eketa noko muninei Guyau i venisiya tovisime be si visimeisiya kana nivaniva tomatakawa Samuwena yana tovai. ");
INSERT INTO wat_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Fiyao Isineni Samuwena si vikokoniya nuwanuwasi tamo yasi tufomu eketa Guyau Beniyamina fasekwina nenei Kisi natuna Sauno i venisiya keta namoinama i vidibwanisiya manamana 40. ");
INSERT INTO wat_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eatu muniyai Guyau Sauno i viyauniya eatu Deivida i ginakasiya yasi tufomu. Eketa namoḡanama fasinei Guyau i bwadukikinomana i bwaduwa, ‘A kitanisaiya Yese natuna Deivida o nuwataku i oviya. Yaku nuwanuwa matatafuna maise kimoki ina savivinisiya.’ ");
INSERT INTO wat_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Naki maise Guyau i bwadudabadaba Deivida nenei, eketa susukwana nenei kita fiyao Isineni kata togifafafana i nemiiya o Yeisu. ");
INSERT INTO wat_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Muniyai yo Yeisu yana mudadava i vibutuwa, Yoni Togivibutabuta i numamana Isineni matatafusi nenesiyai vitana fufuna goyosi nenesiyai sina ugevinisiya be ina givibutibutisiya. ");
INSERT INTO wat_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tovanama Yoni yana mudadava i nunusafuya, namoḡa i iyavisiya, ‘O kwami kwa nuwanuwa vitana iyau Togifafafana Gigibokeinaku? Iyau o muka eatu gwadinama munikuwai i nenemiya o muka ita nufotaiku kana kaevatakutakuna ana kakiya.’ ");
INSERT INTO wat_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Kwami unaunaku, Ebenaamu susukwana eketa yota Kani Kwauna Guyau kana tovimogumogu, kwa vaneneḡa! Guyau matakawa i vininitiya nenetiyai namaise namoḡa i gigifafafaneisi fasinei. ");
INSERT INTO wat_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Fiyao Yenusanema kasi toviketanuneina nukusi muka sita sanamanei Yeisu o tanake Togifafafana. Sabati tamokatamokaḡa numa kafa yokoyoko sinenei si vanevaneneisiya namoḡa si giginaḡanaḡa Guyau yana tomatakawa yasi viginiwa Togifafafananama fasinei, eatu muka nuwatasi ita mayesiya eketa si sawanuketuwiya be ina mateya. Noko ketaketanama nenei eketa tomatakawa yasi viginiwasima noko i vivenemokena. ");
INSERT INTO wat_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Noko fiyaosima keta kasi toviketanuneina muka tamo goyona sita kitanisaḡai Yeisu nenei ebe yo ina mate. Eatu Fainato si vikokoniya be yana tonuaviya ina nuyakanisiya be sina nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eketa avana Guyau yana tomatakawa si viginiwisiya matatafuna tanake fasinei naki maisemoka si savivine-koḡoiya. Muniyai ogonaḡanaḡai si kakiya keta kididiku nenei si teniya. ");
INSERT INTO wat_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Atu Guyau mateyai i sinaviyawasiya. ");
INSERT INTO wat_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kuyadayada yagwanina kana tomuniyeina i kikinomanisiya. Namoisima aviyaonana nukusi nauna si kamudadana Ganini nenei eatu si vaneya Yenusanema. Tasike si kitiya eketa nofe tova si viviwakakakisiya Yeisu fasinei namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nofe tova Banabasi nukusi biga dewadewana ka iyaiyavimiya. Avana Guyau yana bwadudabadabanama waḡawaḡata nenesiyai, ");
INSERT INTO wat_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","naki maisemoka i fufuniya eketa tovanama Yeisu i sinaviyawasiya mateyai i vivenemokena kita natunatusi nenetiyai. Naki maisemoka Deivida i viginiwiya Same kana vinuwa nenei i bwadubwaduwa Yeisu fasinei, ‘Kwaḡa Iyau natuku, kimoki o Iyau amau.’ ");
INSERT INTO wat_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Guyau Yeisu mateyai i sinaviyawasiya eketa mukamokena yota ina mate-savavinei. Nofe savivinanama fasinei o Guyau i bwaduwiya waḡawaḡata nenesiyai i bwaduwa, ‘Namaise Deivida a bwadudabedabiya kana sawanuwagabubu tafutafuna keta venemokena, naki maisemoka yota nununei ana sawanuwagabubuwimiya.’ ");
INSERT INTO wat_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Eketa tamo yota viginiwa Same nenei Deivida i bwadubwaduwa, ‘Muka ka Kaetoḡa Tafutafuna kuna kitamokei be ina kaniniya kididiku sinenei.’ ");
INSERT INTO wat_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kwa nowaniya, yawane Deivida na yawasinei avana Guyau i nuwenuwiya maise i saviviniya, eyo i mateya eketa namai waḡawaḡana si matamataveya nenei niniusiyai si odewadewiya eketa tofwana i kaniniya. ");
INSERT INTO wat_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Eatu namoinama Guyau i sinaviyawasiya mateyai tofwana muka ita kaniniya. ");
INSERT INTO wat_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Eketa unaunaku, biganama ka nunusifufuwimiya kwana nowanautuutuya. Yeisu nenei eketa Guyau kana fata be yami go'yona ina vinuwateweisiya. Muka kana fata be ketoyau kwana nisaḡai taki Mosese yana visime matatafuna kwana muniiya, atu Yeisu kwana vitumaḡaniya nao Guyau matanei ketoketoyaumi go'yona matatafuna nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Na fasinei kwana kitavikavinimiya be avana tomatakawa si viginiwisiya muka ina kikinomana nenemiyai. Si bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Fiyaomima kwa adibudibutoyoikuwa, kwa vaneneḡa! Kwa bau be kwa vikamatemate, uḡuna kwami tomanagibu yami tovai bunanige ana gikikinomaniya nenemiyai. Naki taki aitevana tamo ibanama fasinei ina iyavimiya, eatu kimoki muka kwana vitumaḡanei.’” ");
INSERT INTO wat_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Eketa tovanama Banabasi keta Fauno numa kafa yokoyoko si teweteweiya, namoḡa si kamanemanisiya be Sabati venuwanei Guyau yana bwadu sita nusifufuwe-savaviniya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tovanama si kafiyauyauna muninei, yagwanisi fiyao Diu yota aviyaonana Kani Kwauna eatu Diu yasi ketaketai si kodukoduwa, Fauno keta Banabasi si muniisiya. Eketa namoisima si nusifufuwisiya eketa si kamanemanisiya be vitumaḡana sina tenesaviya Guyau yana omukumukutana kanonovanei. ");
INSERT INTO wat_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabati kana vinuwa nenei menana nakasinei sabuvekamoka si yokowa numa kafa yokoyoko nenei Tuveka bigana kana vaneneḡa fasinei. ");
INSERT INTO wat_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tovanama Diu namoisi si kitiya yoko sagisagigi, si sinegoyowa eketa si vibutuwa Fauno yana sifufu si sawavigoyowiya. ");
INSERT INTO wat_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Atu Fauno keta Banabasi na yasi katevatu si nusifufuwa si bwaduwa, “Kana fatamoka be Guyau fonana kana yauneina fasinei o nauna kwami fiyao Diu nenemiyai, eatu kuniniumi kwa katuniiya. Nofe i vivisawavenena gewa tututaumi kwa nunuvisimiya keta kwa nuwanuwa avage yawasivaḡata kana nisaḡa o muka ita nufotaimi. Na fasinei nofe tova yota Kani Kwauna nenesiyai ka tonetoneya. ");
INSERT INTO wat_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nofemaise Tuveka i visimeikiya tovanama i bwaduwa, ‘A gibokiwa kuna vikimayeta Kani Kwauna fasisiyai, ebe yo kwaḡa neneweu namoḡa kana matatafu fwayafwayai ana gifafafanisiya.’” ");
INSERT INTO wat_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Eketa tovanama Kani Kwauna fiyaosi si nowaniya Fauno yana bwadu, si sebobowa nakasina eketa Tuveka si daviya biga dewadewana fasinei. Eketa tasike aviyaonana Guyau waniya i gibokisiya be yawasivaḡata sina nisaiya fiyaosima o Yeisu si vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Eketa Tuveka bigana i mutuna fafaninama kana matatafu nenei. ");
INSERT INTO wat_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Atu Diu namoisi si ketoyakayakana Kani Kwauna vivine kaikaiwabusi atu Guyau kana tokodukodu, yota tunisi namoḡa na kasi wava Anitiyoki sinenei. Eketa tasike fiyaosima o namoḡa tunisi si ketoyakayakanisiya be Fauno keta Banabasi si vitoagoyogoyowisiya eketa yasi fafaninama nenei si kwavinisiya keta si kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na fasinei Fauno keta Banabasi kaeyafayafasi kasi kafusisima si nubutusiya be i visawavenena vitana Guyau i nuwagoyowa fiyaosima nenesiyai. Eyo si niya Ikoniumu menana nenei. ");
INSERT INTO wat_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Eatu tomuniyeina Anitiyoki nenei si sebobowa nakasina eketa Kanunu Tafutafuna i kitavikavinisiya yasi fakwafakwa nenei. ");
INSERT INTO wat_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Avana Anitiyoki nenei i kikinomana, naki maise yota Ikoniumu nenei. Fauno keta Banabasi yasi fufunavaḡata maise eketa si kanasuna Diu yasi numa kafa yokoyoko sinenei eketa yasi numamana nenei fiyao Diu keta Kani Kwauna sabuveka Yeisu si vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Eatu Diu tunisi si dibutoyoḡa Yeisu kana vitumaḡana fasinei eketa Kani Kwauna fiyaosi si ketoyakayakanisiya yota yasi nuwanuwa si kaniya be muka tovitumaḡana sina muniyeisi. ");
INSERT INTO wat_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Noko nenei Fauno keta Banabasi si fakwa matanubwayouna eatu si numamana na yasi katevatu Tuveka yana omukumukutana nenetiyai fasinei. Eketa Tuveka i givimeyameyaniya nenesiyai be kiyakiyaya kafa nuwatabau yagwanina si savivinisiya eketa nofe ketaketanama nenei namoḡa i visawavenisiya vitana biga nofe o venemokena. ");
INSERT INTO wat_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Eatu namoḡa Ikoniumu menana sinenei si takisiya keta tunisi o fiyao Diu yasi badiyai si niya atu tunisi o tonowana nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kani Kwauna keta fiyao Diu na kasi toviketanuneina nukusi si viwaifufunisiya ebe tanasona nenei sita vibutusiya be gabanai sita tutuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Eatu tovanama Fauno keta Banabasi si biganowana, si dibwana si niya kawakawana Naikoniya nenei, menana nakanakasisi Nisita keta Debi keta yota menana kuniniusi nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Eketa nokomai si tenesaviya biga dewadewana Yeisu fasinei si nunumamana. ");
INSERT INTO wat_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Namoḡa tamokaḡa menana Nisita nenei i nunuvitoḡa. I tufuwiiya fenafenana eketa muka ita ninidadana. ");
INSERT INTO wat_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tamoka tova Fauno yana numamana i vanevaneneiya. Fauno dawaniniina i toneiya eketa i kitanisaiya vitana namoḡa i vitumaḡana ina dewadewa fasinei, ");
INSERT INTO wat_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","eketa Fauno kayona nakasinei i iyaviya i bwaduwa, “Unaku, kaeyafayafaweu ku misini!” Noko tovanama nenei kaena si dewadewa, i venuotowamisiniya keta i nidadana. ");
INSERT INTO wat_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tovanama namoḡa si kitiya avana Fauno i fufuniya, Naikoniya tututausi fonasiyai si bwaubwauwa, “Ei, Vivinuwa si vinamoḡamoka eketa si sobunemiya nenetiyai!” ");
INSERT INTO wat_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabasi o kawakawa na fasinei si weniya Seiyusi eatu Fauno tanake tonusifufu na fasinei si weniya Emesi. ");
INSERT INTO wat_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Seiyusi yana numa kodukodu o menana nakasina kana ketakawanai. Yana tovibwanaose keta yana namonamoḡa nukusi bunumakau keta kanibubuna bwanaosesi si nemiina uḡuna nuwanuwasi Fauno keta Banabasi nenesiyai sina vibwanaoseisiya. ");
INSERT INTO wat_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Atu tovanama Banabasi keta Fauno si nowaniya, kasi nuya si kiganiniya atu si dibwana si kanasuna sabu kasi sinefouwai si finafina, ");
INSERT INTO wat_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Eiyoi, unaunaki! Avao nofe kwa savisavivinei? Kima o naki namoḡamoka maise kwami. Biga dewadewana ka nemiiya nenemiyai ebe nofe ibakaokaoḡosima naki kwana onovisiya eatu kwana saḡavinimiya Guyau na yawasina nenei. Nofe Guyaunama o tanake abama, fwayafwaya be gibo keta yota iba matatafusi sinesiyai kasi tokifufuna. ");
INSERT INTO wat_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Manatuwaina yasi tovai namoḡa matatafusi i kitamokisiya be tututausi yasi nuwanuwai si saḡa. ");
INSERT INTO wat_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Eatu kwa kitiya, kiyakiyaya tamokatamokaḡa si visawavenena yana nuwadoḡa i vivenemokena nenemiyai gewa Guyau i fakwafakwa. Bwabwau abamei keta kabwaga kasi tutuya i venevenimiya eketa kabwaga be sebobo nenesiyai katekatemi i vivimaisiya.” ");
INSERT INTO wat_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Banabasi keta Fauno naki maise yasi kikitana eatu Nisita fiyaosi yawane si kamanamana nuwanuwasi be sina vibwanaoseya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Muniyai fiyao Diu Anitiyokiyei eketa Ikoniumuwei si nemiya keta namoḡa yasi nuwanuwa si kaniya eketa Fauno si vikaniyabiniya. Eyo si vikatutamokisiya keta Fauno gabanai si fonufonuya. Yasi nuwanuwa vitana naki ita mate eketa si soni-kikinomaniya menana nakasina kukwauna. ");
INSERT INTO wat_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Eatu tovanama tomuniyeina tunisi si yokofifiniya, i misiniya eketa i kanasuna-savaviniya menana sinenei. Kuyadayada venuwanei Fauno keta Banabasi si misiniya keta si niya Debi menana nakasinei. ");
INSERT INTO wat_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tovanama biga dewadewana nokomai si numamaniya, namoḡa yagwanisi si vitomuniya Yeisu fasinei. Eyo si makavinisiya Nisita, Ikoniumu keta Anitiyoki menana nenesiyai Fisidiya yana fafaniyai. ");
INSERT INTO wat_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Menana tamokatamokaḡa nenei tomuniyeina si vavatonisiya be yasi vitumaḡana ita fakwafakwa fifiwanina Yeisu nenei si bwadubwaduwa, “Kita kuvavana yagwanina sinenei tana kanasuna eyo muniyai Guyau yana kafa visime nenei tana kanasuna.” ");
INSERT INTO wat_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Eketa ekanesiya tamokatamokaḡa nenesiyai yasi tokawakawa si ginakasisiya. Eyo kawanunuku keta vikokowana nenei Tuvekanama si vitumaḡaniya nimanei si tenisiya. ");
INSERT INTO wat_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Noko muninei Fauno keta Banabasi fafani Fisidiya nenei si vaonota keta si niya Famufiniya. ");
INSERT INTO wat_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tuveka bigana si numamaniya Fega namoisi nenesiyai eyo si sobuwa Ataniya menana nenei. ");
INSERT INTO wat_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Eyo nokomai wakai si tamana Anitiyoki menana nenei. Nofe menaninama nenei o waniya tovitumaḡana kawanunukuwai Fauno keta Banabasi Guyau nimanei si tenisiya be sita bunanigeya. Eketa Guyau yana omukumukutana nenei bunanigenama naki si nusafuya. ");
INSERT INTO wat_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tovanama si kikinomana Anitiyoki, ekanesiya si wenevakukusisiya eketa matatafuna si simana-kikinomana namaise Guyau i savivina yasi bunanige sinenei yota namaise Kani Kwauna kawasasa i venisiya Yeisu kana vitumaḡana fasinei. ");
INSERT INTO wat_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Eketa Fauno be Banabasi tova matanubwayouna nokomai si fakwa tomuniyeina nukusi. ");
INSERT INTO wat_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nofe tovanama nenei tunisi Diu tovitumaḡana Yudiyei si sobunemiya Anitiyoki menana nakasinei eketa si vivisawavenena Kani Kwauna tovitumaḡana nenesiyai, si bwadubwaduwa, “Mosese yana visime maise sina nufifinimiya. Taki nofe kiyakiyayanama muka nenemiyai, nao Guyau muka ina gifafafaneimi.” ");
INSERT INTO wat_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Eatu Fauno keta Banabasi nukusi si ovivigwaeḡa nakasina. Na uḡuna Fauno keta Banabasi yota tunisi tovitumaḡana sinesiyai si vinuwadadanisiya sina niya Yenusanema, tonowana keta tokawakawa nenesiyai nofe nuwanuwanama fasinei. ");
INSERT INTO wat_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Eketa Anitiyoki ekanesiya si vibiyawasisiya keta si visimeisiya yasi ketai. Si vaonota Foenisiya keta Sameniya fafanisima nenesiyai ke'ta tofwanei menana nenesiyai si nunusifufuwisiya namaise Kani Kwauna si vivitumaḡana Yeisu nenei. Eketa tovitumaḡana matatafusi si sebobowa nakasina biga nofe fasinei. ");
INSERT INTO wat_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tovanama si kikinomana Yenusanema, ekanesiya keta tonowana be yota tokawakawa si venufotifotisiya. Eyo Fauno keta Banabasi yasi bunanigenama sinenei matatafuna aviyavana Guyau i savivinisiya, si bwaduwe-kikinomaniya. ");
INSERT INTO wat_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Atu tunisi Fanasi tovitumaḡana si misiniya eketa si bwaduwa, “Kani Kwauna fiyaosi tana nufifina keta yota tana visimeisiya be Mosese yana visime sina muniisiya.” ");
INSERT INTO wat_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tonowana keta tokawakawa si yokowa keta nofe nuwanuwasima fasisiyai si nusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Si vikanunusifusifufuwa matanubwayouna muniyai yo, Fita i misiniya keta i iyavisiya i bwaduwa, “Unaunaku, kwami tututaumi naki kwa sanamaniya manatuwaina Guyau i gibokikuwa sinemiyai ebe biga dewadewana ana numamaniya Kani Kwauna nenesiyai sina nowaniya be Yeisu sina vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Guyau katekate tamokatamokaḡa kana tosanamana eketa Kanunu Tafutafuna i kavenena nenesiyai naki maise kita Diu i venita, noko i visawavenena yana giboke. ");
INSERT INTO wat_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Eketa muka tamo namai kana tunina Guyau ita tenei tasike atu kita nenetiyai uḡuna yasi vitumaḡanai katekatesi i givieyaeiya. ");
INSERT INTO wat_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Eketa nofe tova avana fasinei yo Guyau kwa aanuvanuvai? Waḡawaḡata nukusi visimesima nofe muka tata munimuniyeisi atu nofe tova dauna kwa tewetewe-vaneiya tomuniyeina kavanasiyai. ");
INSERT INTO wat_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Avi goyo! Kima ka vitumaḡaniya Tuveka Yeisu yana omukumukutana nenei gifafafana ta nisaiya. Naki maisemoka yota tasike Kani Kwauna.” ");
INSERT INTO wat_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Sabu matatafusi si numananava atu si vaneneḡa Banabasi keta Fauno si nusifufuwa namaise yasi bunanige sinenei Guyau kiyakiyaya kafa nuwatabau i savivinisiya Kani Kwauna nenesiyai fasinei. ");
INSERT INTO wat_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tovanama Banabasi keta Fauno si nusifufukooḡa, Yemesa i iyavisiya i bwaduwa, “Unaunaku, kwa vaneneḡeiku! ");
INSERT INTO wat_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Fita naki i givimayeta nenetiyai namaise Guyau nauna i visawavenena yana vinuwadadana Kani Kwauna fasisiyai eketa tunisi i gibokisiya tauna yana namonamoḡa. ");
INSERT INTO wat_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Guyau yana tomatakawa si bwaduvioḡoniya naki maisemoka yota i kikinomana i bwadubwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Deivida nifanifaina yana kafa visime si givigoyuya. Eatu ana savavinikuwa keta ana yona-savaviniya be yota ana givifiwaniya. ");
INSERT INTO wat_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ebe namoḡa tufotufo kana nufota Tuveka sina nuwasiya yota Kani Kwauna aviyaonana kaku wavai sina nemiya, Tuvekanama i bwadubwaduwa maise yota ina saviviniya.’ ");
INSERT INTO wat_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Eatu kana sanamana o manatuwaina nunuvisineinana.” ");
INSERT INTO wat_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","21","Eketa yota Yemesa i nusaviya i bwaduwa, “Tova nubwayouna menana tu menana nenesiyai, Mosese yana visime Sabati tamokatamokaḡa si giginaḡanaḡa keta yota si nunumamaniya numa kafa yokoyoko sinesiyai. Nofe fasinei iyau yaku vinuwadadana o kita muka tana gividauniya Kani Kwauna fiyaosi aviyaonana naki si saḡasaḡavinisiya Guyau nenei. Eatu naki nufunufu tata vininitiya nenesiyai be ita gisawakedanisiya ebe avi viyo kifukifufuna nenesiyai si vibwanaoseiiya muka sina kaniya. Eketa yota muka sina kudokaokaoḡo. Muka yomuyomu kayona kikidubina sina kaniya. Yota muka ufaufa sina yumiya.” ");
INSERT INTO wat_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Eketa tonowana be tokawakawa keta ekanesiya matatafusi Yemesa yana givisawakedana si visawadewedewiya. Eketa toviketanuneina namoḡa nuwesi, Yudasa kana wava kana vinuwa Basabasi keta Sainasi, tututausi sinesiyai si gibokisiya. Eketa si visimeisiya Fauno keta Banabasi nukusi sina niya Anitiyoki be yasi vinuwadadanamokena maise sina matakawisiya. ");
INSERT INTO wat_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Si vininitisiya nufunufu nukusi sinenei i bwadubwaduwa maise. “Kima unaunami tonowana keta tokawakawa, yama nuwagabubu kwami Kani Kwauna tovitumaḡana kwa fakwafakwa Anitiyoki, Siniya keta Sinisiya fafanisima nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nofe biga ka nowaniya o tunisi namoḡa sinekiyai muka yama sawateweyeina nenei atu si nemiya nenemiyai keta avana si iyavimiya, yami nuwanuwa si gividaunisiya. ");
INSERT INTO wat_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Na fasinei ka nusifufuwa keta ka visawadewedewiya keta namoḡa ka gibokisiya eketa ka visimeisiya nenemiyai unaunata goyosi Banabasi keta Fauno nukusi. ");
INSERT INTO wat_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Namoisima yawasisi kafa sinae nenei eatu kunuwaneina nenei, si vitobunanigeya Tuveka Yeisu Togifafafana Gigibokeinana kana wava fasinei. ");
INSERT INTO wat_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na fasinei Yudasa keta Sainasi ka vivisimeisiya nenemiyai na nima nufunufusi ebe avana sina bwaduwiya kawasiyai sina visawavenemokeniya. ");
INSERT INTO wat_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kanunu Tafutafuna keta yota kima yama vinuwadadana o muka vitana gisawakedana yagwanina, eatu naki nofemaiseḡa o muka kwana fufunisi. ");
INSERT INTO wat_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Avi viyo kifukifufuna nenesiyai si vibwanaoseiiya, muka kwana kaniya. Muka ufaufa kwana yumiya. Muka yomuyomu kayona kikidubina kwana kaniya. Muka kwana kudokaokaoḡo. Taki visime nofe kwata kitavikaviniya, nao dewadewana. Oiyoo.” ");
INSERT INTO wat_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Eketa namoḡamokesi si visimeisiya Yenusanemei keta si sobuwa Anitiyoki. Nokomai ekanesiya si wenevakukusisiya keta nufunufunama si venisiya. ");
INSERT INTO wat_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tovanama si ginaḡanaiya, si sebobowa nakasina yana bwadu-givifiwana fasinei. ");
INSERT INTO wat_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudasa keta Sainasi tututausi o tomatakawa keta bwadubwadu nenesiyai si givikatevatusiya yota yasi vitumaḡana si givifiwaniya. ");
INSERT INTO wat_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Noko muninei Anitiyoki si fakwa kuyadayada kawaviyamoka, eyo ekanesiya si visimeisiya keta na yasi nuwatakabonu atu si makavinisiya Yenusanema ekanesiya nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Eatu Fauno keta Banabasi si fakwa Anitiyoki, tunisi namoḡa sabu nukusi si vivisawavenena yota si nunumamana Tuveka Yeisu fasinei. ");
INSERT INTO wat_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kuyadayada kawaviya muninei Fauno Banabasi i iyaviya i bwaduwa, “Unaku, tata makavinita be unaunata tata venufotisiya namai nauna Tuveka Yeisu bigana ta numamaniya menanasima matatafuna nenesiyai be ta kitaisi namaise yasi dibwadibwana.” ");
INSERT INTO wat_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasi i vinowana eketa nuwanuwana Yoni Maka ita oviya nukusi. ");
INSERT INTO wat_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Atu Fauno muka ita visawadewadewei sina ovai uḡuna nauna yasi kamudadana nenei muka nukusi sita fakwa kana nivaniva kafa nusafu, eatu Famufiniya yana fafaniyai i venumakanovisiya. ");
INSERT INTO wat_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nofe fasinei Fauno keta Banabasi si vibanasiya eketa si venusisina. Banabasi Maka i oviya keta wakai si niya Saifunusi simuna nenei. ");
INSERT INTO wat_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Eatu Fauno o Sainasi i gibokiya eketa tovitumaḡana si yokowa keta Tuveka yana omukumukutana nenei si tenisiya eyo si gionovisiya. ");
INSERT INTO wat_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Eketa Siniya be Sinisiya yasi fafani nenesiyai si kamudadana eketa ekanesiya si vavatonisiya. ");
INSERT INTO wat_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Fauno keta Sainasi si niya Debi menana nakasina nenei eyo si niya Nisita menana nenei. Tamoka tomuniyeina kana wava Timoti nokomai i fakwafakwa. Ayona o ne Diu tovitumaḡana eatu amana o tene Ginisi. ");
INSERT INTO wat_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tovitumaḡana Nisita keta Ikoniumu nenesiyai Timoti si kitavaneiya. ");
INSERT INTO wat_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Fauno nuwanuwana Timoti nukusi sina niya na fasinei i nufifiniya. Nofe i saviviniya uḡuna fiyao Diu noko menanisima nenesiyai si fakwafakwa, matatafusi si sanamaniya vitana Timoti amana o tene Ginisi. ");
INSERT INTO wat_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Fauno, Sainasi keta Timoti si niya menana tamokatamokaḡa nenesiyai Kani Kwauna tovitumaḡana si iyavisiya avana tonowana keta tokawakawa Yenusanema si vinuwadadanisiya ebe sita muniisiya. ");
INSERT INTO wat_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Eketa ekanesiya yasi vitumaḡana i fiwanamoka keta kuyadayada tamokatamokaḡa, kasi naḡa i kekeno-vanevaneya. ");
INSERT INTO wat_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Fauno unaunana nukusi Kanunu Tafutafuna i sawatanisiya Guyau yana bwadu kana yauneina Eisiya sinenei na fasinei si fanakwaniuḡa Finigiya keta Ganetiya kawakawanasima nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Tovanama si nemiya Maisiya fafani kana nabaonota nenei, si anuvanuva be Betiniya fafaninama nenei sina kanasuna eatu Yeisu Kanununa muka ita sawateweyeisi. ");
INSERT INTO wat_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Eketa si tamana Maisiya yana fafaniyai eketa si sobuwa Tonowasi menana nakasinei. ");
INSERT INTO wat_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Eketa noko nuwabunanama nenei Fauno i kenokita. Kenokitanama nenei i kitiya tene Masedoniya i misimisiniya atu i nunukeketiya i bwadubwaduwa, “Ku tamananemai Masedoniya ebe ku oviviteiki.” ");
INSERT INTO wat_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Eketa Fauno kana kenokita muninei naki na tovanama nenei ka gidewadewa kana toḡa Masedoniya fasinei. Noko nenei ka sanamaniya Guyau i vivisimeikiya be biga dewadewana kana numamaniya noko fiyaosima nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Eketa wakai Tonowasi menana nakasina ka teweiya atu dawaniniina ka niya Samotenesi simuna nenei. Eketa kuyadayada kana vinuwa nenei ka niya Neyafonisi menana nenei. ");
INSERT INTO wat_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nokomai yo kaeyai ka niya Finifai. Menana noko na kana wava kawakawana Masedoniya Noma fiyaosi si fakwifakwiiya nenei. Finifai ka fakwa kuyadayada matayagwanina. ");
INSERT INTO wat_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ka fakwafakwa atu Sabatiyai menana ka teweiya atu ka kikinomana keta ka niya ukowai yama nuwanuwa vitana nokomai tamo kawanunuku kana kabaḡa kata nisaiya. Eatu tunisi vivine si yokowa kawanunukuwa fasinei eketa ka nuvitoḡa keta ka nusifufuwisiya Yeisu fasinei. ");
INSERT INTO wat_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Gumayogu tamokaḡa si vanevaneneikiya o tasike Kani Kwauna kasi wava Nidiya ne Tayatina. Tasike nuya yabeyabena-fofonina si vivikimwaneina. Tasike Guyau nenei si kodukoduwa eketa Tuveka katekatesi i yauya nenei keta Fauno yana sifufu si nowanautuutuya. ");
INSERT INTO wat_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nidiya kasi givibutabuta na yasi sabu nukusi muninei, si katuvikiya yasi numai atu si bwaduwa, “Taki kwa sanamaniya kima Tuveka kana tovitumaḡana, kwata nemiya yama numai tata fakwa.” Nuwataki si kaniya eketa ka niya yasi numai. ");
INSERT INTO wat_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tamoka tova ka niniya kawanunuku kana kabaḡai eatu tamoka kaetoḡa kakaabana i venusaikiya. Kanunu goyona i nuwafiya keta i kanakanaveneveniya be tova munina avana sina kikinomana fasinei i nunusifufuwina. Toniwaga gabana nakasina si viviya noko ketaketanama nenei. ");
INSERT INTO wat_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Fauno nukusi i munimuniyedadanikiya atu i bwaubwauwa, “Oi, kwa kitaisi! Nofe namoisima o Guyau Etanemokenei yana tobunanige. Gifafafana kana ke'ta si nunumamanimiya.” ");
INSERT INTO wat_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kuyadayada yagwanina tamoka fufuninama i niiya kana nivaniva Fauno dibuna i toyoḡa. I saḡaviniya gumayogu nenei eketa kanunu goyona i iyaviya, “Yeisu Togifafafana Gigibokeinana kana wavai a nunuyakayakaniwa gumayogu ku gionovei!” Keta naki tovanama nenei, kanunu goyona gumayogu i teweiya. ");
INSERT INTO wat_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tovanama toniwaga si kitanisaiya vitana yasi gabana kana ke'ta naki i kaonosiya, Fauno keta Sainasi si givikavinisiya eketa si sinakanikanisiya si niisiya kafa vivitamaneina kana kabaḡai ebe tovisime matasiyai sina misiniya. ");
INSERT INTO wat_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tovanama si niisiya tovisime nenesiyai, si bwaduwa, “Nofe namoḡa o fiyao Diu, yata menana sinenei vikasanegwanegwa si gigikikinomaniya namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Sanunama kita fiyao Noma nenetiyai muka kana sawateweyeina o si vivisawavenena.” ");
INSERT INTO wat_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Sabu i kanakasisiya keta Fauno be Sainasi si vibutusiya. Tovisime yasi tonuaviya si iyavisiya si bwaduwa, “Kasi nuya kwa kiganini be kaiyai kwa kanuwa-tamatamaneina.” ");
INSERT INTO wat_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Si munusiya nakasina yo muninei deniyai si tewekanasunisiya eyo tokitavikavina si visimeiya be ina kitavikavina-dewadewisiya. ");
INSERT INTO wat_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Eketa deni sinenemokenei i tenisiya keta kai daudaunisi nugiginabusi nenesiyai kaesi i vikanakuma. ");
INSERT INTO wat_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nuwabuna sinefouna sasana Fauno keta Sainasi si kawakawanunukuwa keta si oseosedavadava Guyau nenei eatu deni sinenei finisina matatafusi si vanevaneneisiya. ");
INSERT INTO wat_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Eketa naki noko tovanama nenei nikuniku fifiwanina i dibwana keta deni kana yafani i nikuniya. Deni kana kawa matatafusi i kayausiya yota finisina kasi seni si kamwanumwanuwa. ");
INSERT INTO wat_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tovanama tokitavikavina i kenoviniya keta i kitiya deni kasi kawa kakayausi, i nuwanuwa vitana finisina sita dibwana eketa yana feto i soniyaginiya be tauna ita nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Eatu Fauno i fina, “Oi, muka tauḡu kuna givigoyou! Kima matatafuki o weka!” ");
INSERT INTO wat_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Eketa tokitavikavina i bwauwiya toovivita kimayeta fasinei eketa i mataboḡana i kanasuna deni sinenei namai Fauno keta Sainasi si fakwafakwa nenei. Na yana matuta keta i akikinikuna atu nausiyai i koduwa. ");
INSERT INTO wat_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Eketa i kikinomanisiya keta i kawanunukuwisiya, “Ae amamaku, avamasi ata fufuniya be gifafafana ata nisaḡai Guyau nenei?” ");
INSERT INTO wat_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Eketa si nufata si bwaduwa, “Ku vitumaḡana Tuveka Yeisu nenei be ina gifafafaniwa maise yota ya sabu.” ");
INSERT INTO wat_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Eketa Tuveka bigana si nusifufuwiya nenei eketa yota sabu matatafusi yana numa sinenei. ");
INSERT INTO wat_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nuwabunanama nenei deni kana tokitavikavina Fauno keta Sainasi i niisiya keta kasi gikona i kigona. Muka mwanenena tu yana sabu matatafusi nukusi si givibutibutisiya. ");
INSERT INTO wat_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Eyo deni kana tokitavikavina i kanasunisiya yana numai keta i vibiyawasisiya. Yana sabu matatafusi nukusi si sebobowa nakasina uḡuna naki Guyau nenei si vitumaḡana. ");
INSERT INTO wat_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tova i katakiya nuwabuni, menana nakasina kana tovisime yasi tonuaviya si visimeisiya deni kana tokitavikavina kana matakawa si niiya namoḡa kasi ketoyau fasinei. ");
INSERT INTO wat_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Eketa tokitavikavina Fauno i iyaviya i bwaduwa, “Tovisime bwadu si vininitiya nenekuwai be Sainasi nukusi ana gionovimiya fasinei. Nofe tova kwa noḡokawawa na yami nuwatakabonu.” ");
INSERT INTO wat_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Eatu Fauno tonuaviya nenesiyai i bwaduwa, “Muka tamo kana goyona sita kitai nenekiyai eatu sabu matasiyai si kimunuwa keta yota deniyai si tenikiya. Eatu kima o Noma tufuwina! Eketa yota nofe tova, avage nukamumunai sina vikikinomanikiya. Mukamokena! Kwana iyavisiya tovisime tututausi sina nemiya nofemai keta deniyai sina kikinomanikiya.” ");
INSERT INTO wat_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Eketa tonuaviya si makavinisiya tovisime nenesiyai keta Fauno fonana si yauya. Tovanama tovisime si nowaniya vitana Fauno keta Sainasi o fiyao Noma, si matuta. ");
INSERT INTO wat_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Na fasinei si niya Fauno keta Sainasi nenesiyai eketa si vikokonisiya kasi vinuwateweyeina fasinei. Eyo deniyai si kikinomanisiya keta si kamanemanisiya be menana sina teweiya. ");
INSERT INTO wat_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Fauno keta Sainasi deniyai si kikinomana keta si niya Nidiya yasi numai keta nokomai tovitumaḡana nukusi si vikaninisaḡa keta si vatonisiya Yeisu kana vitumaḡana fasinei, eyo menana si teweiya. ");
INSERT INTO wat_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Fauno keta Sainasi, Finifai si teweiya atu si niya Amufifonisi keta Afononiya menana nakanakasisi nenesiyai eketa si kikinomana Tesanonaika menana nakasina nenei. Noko menananama nenei, numa kafa yokoyoko i fakwafakwa fiyao Diu fasisiyai. ");
INSERT INTO wat_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Eketa Fauno manatuwaina naki kana iduwa maise eketa Sabati tonusi fiyao Diu yasi numa kafa yokoyoko sinenei i kanakanasuna, eketa Guyau fonakituna nenei namoḡa nukusi si vivikanunusifusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Guyau fonakituna kasi sanamana i gigivimayeta nenei o i tewetewetutuya nenesiyai vitana Togifafafana Gigibokeinana o kana nufotamoka be ina kuvavana keta ina mateya eatu yota ina misini-savaviniya. Eketa Fauno i iyavisiya i bwaduwa, “Yeisunama nofe a nunusifufuwiya nenemiyai o Togifafafana Gigibokeinamokena.” ");
INSERT INTO wat_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Fauno yana sifufuwai tunisi Diu nuwatasi i kaniya. Maise yota Ginisi namoisi Guyau kana tokodukodu o sabuvekamoka yota vivine nakanakasisi o muka tonusi, eketa Fauno be Sainasi si visabutamokisiya. ");
INSERT INTO wat_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Atu Diu tunisi si sinegoyowa uḡuna namoḡa yagwanisi Fauno yana bwadu si vitumaḡaniya na fasinei tonikaokaoḡo si nuviyokoyokowa kafa vitamaneina kana kabaḡai, eketa nukusi vigwaeḡa si vibutuya. Si dibwana si niya Yeiseni yana numai keta yana numa kana kawa si yakweniya. Si kanasuna sinenei Fauno keta Sainasi si nuwasisiya be sita kikinomanisiya yokoyoko nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Atu tovanama si nuwasawayosisiya, Yeiseni keta tovitumaḡana tunisi nukusi si givikavinisiya keta si sinakanikanisiya si niisiya menana nakasina kana tovisime nenesiyai, si finafina atu si bwadubwaduwa, “Nofe namoḡasima o fwayafwaya kana matatafu nenei goyona si gigikikinomanisiya eatu nofe tova yota si nemiya yata menana nenei. ");
INSERT INTO wat_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Eatu Yeiseni i katuvisiya yana numai. Matatafusi tufomu Sisa yana visime si yakweyakweniya avage si bwadubwaduwa o yota tamo tufomu kana vinuwa kana wava Yeisu.” ");
INSERT INTO wat_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tovanama menana kana tovisime keta sabuveka bwadu nofe si nowaniya, si kayokuḡa venemokena. ");
INSERT INTO wat_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Eketa tovisime si nuyakayakanisiya Yeiseni keta tunisi tovitumaḡana eketa gabana nakasina si nufata ebe yo muka goyona tamo yota ina kikinomana, eyo si gionovisiya keta si niya. ");
INSERT INTO wat_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Noko nuwabunanama nenei tovitumaḡana si visimeisiya Fauno keta Sainasi si niya Beneya. Tovanama si kikinomana nokomai, si niya Diu yasi numa kafa yokoyoko nenei. ");
INSERT INTO wat_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beneya fiyaosi yasi fufuna muka maise fiyao Tesanonaika. Beneya fiyaosi nuwanuwamokesi be biga dewadewana sina vanevaneneiya. Kuyadayada tamokatamokaḡa Guyau fonakituna nenei si kitakitavinanuwa taki avana Fauno i bwadubwaduwisiya o venemokena. ");
INSERT INTO wat_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nofe nenei fiyao Diu yagwanisi si vitumaḡana Yeisu nenei, maise yota Ginisi vivine keta namoḡa nakanakasisi. ");
INSERT INTO wat_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Atu tovanama fiyao Diu Tesanonaika sinenei naki si sanamaniya vitana Guyau fonana Fauno i nunumamaniya Beneya sinenei, tasike yota si niya nokomai keta namoḡa si visimwanakasisiya ebe Fauno sina nuwagoyowiya. ");
INSERT INTO wat_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tovitumaḡana omatakayakayakanai Fauno keta tovitumaḡana tunisi nukusi si visimeisiya si niya gibowai, atu Timoti keta Sainasi si fakwa Beneya. ");
INSERT INTO wat_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Namoḡasima Fauno kaena si kwafuya si niiya kana nivaniva Etenisi menana nenei si vanoviya. Eyo si makavinisiya Beneya, Sainasi keta Timoti kasi matakawa vitana sina venudibwana be sina niya Fauno nenei. ");
INSERT INTO wat_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Fauno yawane Etenisi nenei Sainasi keta Timoti i fotifotisiya atu kaivakuku yagwanisi nokomai i kitisiya eketa nuwanuwa i munuya. ");
INSERT INTO wat_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Na fasinei numa kafa yokoyoko sinenei i vibutuwa i gigisawakedana fiyao Diu nenesiyai keta yota Kani Kwauna aviyaonana Guyau kana tokodukodu nenesiyai. Yota kuyadayada tamokatamokaḡa i niniya kafa vitamaneina kana kabaḡai eketa aitevana tamo nokomai i ninisaiya, na naki nukusi si vivikanunusifusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sinesiyai o Efekuniyani eketa Sitoiki tovisawavenena. Fiyaosima o Fauno nukusi si vikawabwadubwaduwa. Fauno i nunumamana biga dewadewana Yeisu fasinei eketa yota tomate yasi misini-savavineina fasinei. Eketa tunisi tututausi nenesiyai si vikanunutoniya si bwaduwa, “Avamasi nofe kawana yafayafana i aanuvanuva be ina bwaduwei?” Tunisi si bwaduwa, “Kana kita kamo yana iduiduwa fasisiyai i nunusifufuwa.” ");
INSERT INTO wat_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Eketa Fauno si katuviya yasi kafa yokoyoko kana kabaḡai kana wava Aneofagusi eketa si iyaviya si bwaduwa, “Nuwanuwaki kata sanamaniya, avi visawavenena masi nofe kiouna ku bwadubwaduwei? ");
INSERT INTO wat_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Iba tunisi ku bwaduwisiya o kima muka tamo tova kata nowananuvanuvaisi na fasinei kasi sanamana kuta givimayesikiya.” ");
INSERT INTO wat_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nokomaise si bwaduwa uḡuna Etenisi namoisi keta yauyauna nokomai si fakwafakwa, tova matatafuna nuwanuwasi be sina vanevaneneḡa ketaketa kiousi be fasisiyai sina nunusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Eketa Aneofagusi kawakawa nausiyai Fauno i misiniya keta nenesiyai i bwaduwa, “A kitiya kwami Etenisi fiyaomi yami kodukodu kasi vifotu o kasi ketaketa tuninatunina nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nofe a bwaduwiya uḡuna yaku nidadana menana nakasina nenei o yami kafa kodukodu a kitisiya. Eketa yami didiḡa tamokaḡa nenei o kwa ginivaviya i bwadubwaduwa, ‘Guyau muka kata sanamanei, neneweu ka vivifotuwa.’ Kwami muka Guyaunama kwata sanamanei atu nenei kwa kodukoduwa fasinei, nofe tova ana iyavimiya. ");
INSERT INTO wat_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Guyaunama o fwayafwaya keta iba matatafuna sinenei i fufunisiya. Tanake o abama keta fwayafwaya kasi Tuveka keta muka numa kodukodu namoḡa yasi kikiyona nenesiyai ita fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Eketa tanake o mukamokena tamo namoḡa yasi ovivita fasinei ita nuwanuwa. Uḡuna tanake tauna o namoḡa yawasisi keta iba matatafuna i venivenisiya. ");
INSERT INTO wat_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kafa viuḡuwai namoḡa tamokaḡa i fufuniya keta namoḡanama nenei sabu si kikinomana keta nofe tova fwayafwaya kana matatafu nenei si fakwafakwa. Tanake yota tova i tenisiya yota kabaḡa kasi niva i dawana be kabaḡasisi nenesiyai sina fakwa. ");
INSERT INTO wat_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Iba nofe i saviviniya ebe namoḡa Guyau sina nuwasiya. Ebe kamo yasi nuwasai sina nisaiya. Atu tanake muka tamo sasanei kita tamokatamokaḡa nenetiyai. ");
INSERT INTO wat_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tamo toviginiwa i bwaduwa, ‘Tanakema nenei yo ta fakwafakwa keta ta savisavivina eketa ta mudamudadava.’ Eketa maise yota tututaumi yami toviginiwa si viginiwiya i bwadubwaduwa, ‘Kita o natunatuna.’ ");
INSERT INTO wat_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Bwadu venemokena, kita o Guyau natunatuna. Na fasinei muka tata nuwenuweisi vitana Guyau kana kikitana maise kifukifufuna namoḡa si giniginivavisiya gonudi o siniva o gabana nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tova manatuwaina namoḡa muka Guyau sita sanamanei na fasinei i kitateweisiya. Eatu nofe tova fafani matatafuna nenesiyai namoḡa i nunutunitunisiya be sina ugevinisiya yasi fufunagoyo nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Uḡuna tanake tova naki i tenesiniya keta i vinuwadadaniya avi tovai venemokena nenei namoḡa ina nuvisita. Namoinama naki i gibokiya be ina nuvisiya kana matanabobotai. Visawavenemokena kana kiyakiyaya i fufuniya tovanama namoḡanama mateyai i sinaviyawasiya.” ");
INSERT INTO wat_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tovanama namoḡa si nowaniya Fauno yana sifufu misini-savavineina fasinei, tunisi si sawaviniiya, eatu tunisi si bwaduwa, “Kima nuwanuwaki be yota nofe fasinei tamo tova kuna nusifufuwe-savaviniya.” ");
INSERT INTO wat_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Eketa Fauno yoko noko sinenei i kikinomana keta i niya. ");
INSERT INTO wat_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Eketa namoḡa tunisi si muniiya Fauno keta Yeisu si vitumaḡaniya. Yokonama sinesiyai o Aneofagusi kana tovisime tamokaḡa kana wava Dionaisiosi yota gumayogu tamokaḡa kasi wava Damanisi keta yota tunisi namoḡa. ");
INSERT INTO wat_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nofe muninei Fauno Etenisi menana nakasina i teweiya atu i niya Kononita. ");
INSERT INTO wat_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nokomai tene Diu i venusaiya kana wava Akwina. Tanake tonimenana Fonutusi nenei, kakimokimoki Itaniyei na kawana Finisika nukusi si nemiya. Uḡuna Noma kana tufomu Konodiyasi Diu matatafusi i iyavisiya be Noma sina teweiya. Na fasinei Fauno i niya be ina kitisiya. ");
INSERT INTO wat_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Tasike o vada kasi tokifufuna yomuyomu kwafinisi nenei naki maise Fauno, eketa nukusi si fakwa atu si mudadava. ");
INSERT INTO wat_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kuyadayada Sabati tamokatamokaḡa Fauno numa kafa yokoyoko nenei Diu keta Ginisi fiyaosi nukusi si vivikanunusifusifufuwa. I aanuvanuva be nuwatasi ina kaniya be Yeisu sina vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tovanama Sainasi keta Timoti Masedoniyei si sobunemiya Kononita nenei, Fauno vada kana mudadava i teniya atu tova matatafuna i nunumamana Diu nenesiyai i bwadubwaduwa, “Yeisu o tanake Guyau i gibokiya Togifafafana Gigibokeinana.” ");
INSERT INTO wat_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Atu tovanama Diu si dibutoyoḡa keta Fauno si sawavigoyowiya, i nubutuya kafusisima kana nuya nenesiyai keta i bwaduwa, “Taki Guyau ina vivimatadawanimiya, nao kwami kami kuvana. Tututaumi kwa vinoimi eatu muka iyau kwana vinoiku. Nofe tova keta i niniya, Yeisu bigana ana niiya be Kani Kwauna nenesiyai ana numamaniya.” ");
INSERT INTO wat_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Eketa Fauno numa kafa yokoyoko i teweiya keta i niya namoḡa kana wava Taitiyusi Yasitusi yana numa nenei. Gwadinama o Kani Kwauna eatu Guyau kana tokodukodu. Yana numa o i misiniya numa kafa yokoyoko niniunei. ");
INSERT INTO wat_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Numanama kafa yokoyoko kana toviketanuneina o Kinisifasi, kana sabu matatafusi nukusi yana numa nenei Tuveka si vitumaḡaniya. Yota yagwanisi namoḡa Kononita sinenei aviyaonana Fauno yana biga si vaneneiya, si vitumaḡana keta si givibutibutisiya. ");
INSERT INTO wat_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nuwabuna tamokaḡa Fauno kana kenokita nenei Tuveka i nusifufuwiya i bwaduwa, “Muka kuna matuta! Muka kuna numananava eatu nusifufu kuna tenesaviya! ");
INSERT INTO wat_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Iyau kwaḡa nukusi eketa muka tamo aitevana ina munuu o ina givigoyou. Uḡuna namoḡa yagwanisi menana nofe sinenei o Iyau yaku namonamoḡa.” ");
INSERT INTO wat_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Eketa Fauno nokomai i fakwa manamana tamokaḡa keta yamayamana 6, Guyau yana biga namoḡa nenesiyai i gigisawakedana. ");
INSERT INTO wat_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tovanama Noma toviketanuneina Ganiyo si ginakasiya eketa fafani Akaiya sinenei i vitovisimeya kana tovai, Diu tunisi si vikatutamokisiya keta Fauno si vikaniyabiniya eketa si niiya nofe tovisimenama nenei kafa vifonayau kana kabaḡai. ");
INSERT INTO wat_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Si vinoiya si bwaduwa, “Nofe namoḡanama o namoḡa nuwatasi i kanikaniya eketa Guyau kana kodukodu fasinei muka visime sita munimuniyei.” ");
INSERT INTO wat_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Atu noko tovanama nenei Fauno kawana i nakanakiya be ina nusifufuwa, ava Ganiyo i bwaduwa, “Kwami Diu fiyaomi, namoḡa nofe avi goyona o avi fufuna tamo goyomataina i savivinei, eyo iyau yami sifufu ana vaneneḡei? ");
INSERT INTO wat_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nofe o naki kwa ovivigwaeḡa avage bwadubwadu be wava keta yota tututaumi yami visime fasisiyai, eketa tututaumi kwa gidawadawaniniyei. Ibasima nofe nenesiyai naki a dibutoyoḡa.” ");
INSERT INTO wat_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Eketa kafa fonayau kana numei i vikikinomanisiya. ");
INSERT INTO wat_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Eketa sabu matatafusi Sosideni si givikaviniya, tanake o numa kafa yokoyoko kana toviketanuneina tamo, eketa kafa fonayau kana wasiketai si navinaviya. Eatu Ganiyo i kitaisi yo i toḡakaokaoḡowa. ");
INSERT INTO wat_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Fauno i fakwa Kononita tovitumaḡana nukusi kuyadayada yagwanina muniyai yo, i teweisiya eatu Finisika keta Akwina nukusi si niya menana Kenikiniya nenei. Nokomai Fauno tamokaḡa namoḡa i iyaviya keta kunukununa i totuya vitana i vikiyakiyaya gewa yana bwadudabadaba Guyau nenei naki i saviviniya. Eketa Fauno, Finisika keta Akwina wakai si toḡa keta si sinanakata fafani Siniya fasinei. ");
INSERT INTO wat_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Si tamana keta si kanasuna Efeso. Fauno nokomai Finisika keta Akwina i tenisiya atu i kanasuna numa kafa yokoyoko nenei fiyao Diu nukusi si vivikanunusifusifufuwa. ");
INSERT INTO wat_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Fiyao Diu Fauno si vikokoniya be nukusi sina fakwa matanubwayouna, atu i dibutoyoḡa. ");
INSERT INTO wat_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Atu yana nai nenei i iyavisiya i bwaduwa, “Taki Guyau ina sawateweikuwa maise, ana makavinikuwa nenemiyai.” Eketa tamo waka nenei i toḡa keta Efeso i teweiya. ");
INSERT INTO wat_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tovanama i saniniya Sisaniya, i vaneya Yenusanema eketa ekanesiya i venufotisiya eyo kavananei i sobuwa Anitiyoki. ");
INSERT INTO wat_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tova bwatana nenei tovitumaḡana nukusi si fakwa Anitiyoki, muninei i fanakwaniuḡa i niya menana tu menana Ganetiya keta Finigiya fafanisima nenesiyai tomuniyeina matatafusi i vavatonisiya. ");
INSERT INTO wat_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tene Diu tamokaḡa kana wava Afonosa, tanake o tonimenana Anekisenidiya Itifita yana fafaniyai, i niya keta i kikinomana Efeso menana nenei. Tanake tonusifufu dewadewana keta yota Guyau yana bwadu i sanamana-budowanemokiya. ");
INSERT INTO wat_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Namoḡa tunisi yasi visawavenena Tuveka yana Ke'ta fasinei nuwatana i viya eketa yana visawavenena nenesiyai i nusaitetemoka Yeisu fasinei. Atu Afonosa o sanasanamanina Yoniḡa yana givibutabuta fasinei. ");
INSERT INTO wat_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","I vibutuwa keta i nusifufuwa na yana katevatu numa kafa yokoyoko sinenei. Tovanama Finisika keta Akwina si nowaniya yana nusifufu, si katuviya yasi numai eketa nuwatana si tanakakikakiniya Guyau yana Ke'ta avana muka ita sanamaneisi fasisiyai. ");
INSERT INTO wat_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Keta noko tovanama nenei Afonosa nuwanuwana be ina niya Akaiya yana fafaniyai be ina numamana, tovitumaḡana Efeso sinenei si sawakatevatuya yana savivina fasinei eketa nufunufu tamokaḡa si viginiwiya tomuniyeina nenesiyai Akaiya sinenei be si matamatakawisiya vitana Afonosa sita venufotefotiya. Tovanama i kikinomana nokomai, aviyaonana waniya tovitumaḡana Guyau yana omukumukutana nenei i ovivitisiya nakasina. ");
INSERT INTO wat_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tamokaḡa ketaketa i saviviniya o vikawabwadubwadu fifiwanisi nenesiyai fiyao Diu i vatanisiya sabu yagwanisi kasi manawasasai. Guyau fonakituna nenei i misiniya tu i nusifufuwisiya vitana Yeisu o tanake Togifafafana Gigibokeinamokena. ");
INSERT INTO wat_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Noko tovanama nenei Afonosa o Akaiya yana fafaniyai Kononita menana nenei, Fauno o uwama kana ke'ta kuweyaina i vaonota keta i kikinomana Efeso. Nokomai tunisi tomuniyeina i venusaisiya. ");
INSERT INTO wat_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Keta i nutoninuvenuvisiya i bwaduwa, “Kwami Kanunu Tafutafuna kwa viya tovanama kwa vitumaḡana Yeisu nenei?” Eketa si nufata nenei si bwaduwa, “Muka, kima muka tamo kata nowaniya Kanunu Tafutafuna fasinei.” ");
INSERT INTO wat_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Eketa Fauno i bwaduwa, “Taki nanemaise, o avi givibutabuta kwa vai?” Eketa si nufata, “Givibutabutanama Yoni i visawavenena namoḡa nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Eketa Fauno i bwaduwa, “Yoni namoḡa i givibutibutisiya be ina vikiyakiyaya vitana yasi fufunagoyo nenesiyai naki si ugevinisiya. I iyavisiya tasike sita vitumaḡana tanake aitevana munifotai i nenemiya nenei, tanake o Yeisu.” ");
INSERT INTO wat_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Namoḡa Fauno yana bwadu si nowaniya eketa i givibutibutisiya Tuveka Yeisu kana wavai. ");
INSERT INTO wat_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tovanama nimana debabousiyai i dawana, Kanunu Tafutafuna i vimaisiya keta si vibutuwa si nunusifufuwa meya tuninatunina nenesiyai yota Guyau fonana si bwadubwaduvioḡona. ");
INSERT INTO wat_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Namoḡamokesi o kasi yagwana 12. ");
INSERT INTO wat_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Yamayamana tonusi sinesiyai tova matatafuna Fauno i niniya numa kafa yokoyoko nenei na yana katevatu i nunusifufuwa fiyao Diu nenesiyai be nuwatasi ina kaniya Guyau yana kafa visime fasinei. ");
INSERT INTO wat_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Atu tunisi debabousi si gua keta muka Guyau fonana sita vitumaḡanei, eketa iba goyosi si bwadubwaduwisiya namoḡa nenesiyai Yeisu yana Ke'ta fasinei eketa Fauno i venuteweisiya. Eatu tomuniyeina i ovisiya keta si niya Tinanusi yana kafa visawavenena kana numa nenei. Nokomai tovatova si vivikanunusifusifufuwa Guyau yana kafa visime fasinei. ");
INSERT INTO wat_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Fauno i saviviniya nokomaise kana nivaniva manamana nuwesi, eketa matatafusi fiyao Diu be Kani Kwauna si fakwafakwa Eisiya yana fafani nenei Tuveka yana bwadu si nowaniya. ");
INSERT INTO wat_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Keta Fauno yana bunanige nenesiyai Guyau kafa nuwatabau nakanakasisi i savivinisiya. ");
INSERT INTO wat_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nuya bidimisi Fauno i nunusikonisiya si niniina keta tovanama tovisafwavinaḡa nuyasima si gigisikonisiya, kasi katona si kakakaviya keta si bwinabwina yota kanunu goyosi si nuwafisiya si gionovisiya. ");
INSERT INTO wat_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Diu tunisi tasike aviyaonana si niya menana tu menana nenesiyai kanunu goyosi si nunukakisiya namoḡa sininisiyai yota si aanuvanuva be Tuveka Yeisu kana wavai sita savivina keta namoḡa kanunu goyosi nenesiyai si bwadubwaduwa, “A vivisimeiwa Yeisu kana wavai namoinama Fauno i numamaniya, ku gionovei.” ");
INSERT INTO wat_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tene Diu tamokaḡa tovibwanaose kasi toviketanuneina kana wava Sikeva natunatuna namoḡa kasi 7. Tasike yota avage si aanuvanuva kanunu goyosi namoḡa nenesiyai si nukakisiya. ");
INSERT INTO wat_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tamoka tova avage kanunu goyona si nuyakayakaniya be namoḡa tamoka nenei ina kikinomana, atu kanunu goyona i bwaduwa nenesiyai, “A sanamaniya Yeisu keta yota a sanamaniya Fauno, atu kwami o aviyaonana?” ");
INSERT INTO wat_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Eketa namoḡanama kanunu goyona i nuwafiya namoḡasima kasi 7 i nukekemanisiya keta yana fiwanai matatafusi i tafisiya venemokena keta numei si dibwana si kikinomananemiya gonegonesi keta na ufaufasi. ");
INSERT INTO wat_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Matatafusi Fiyao Diu keta Kani Kwauna Efeso si fakwafakwa si biganowana keta si matuta, eketa Tuveka Yeisu kana wava si vifotuwiya venemokena. ");
INSERT INTO wat_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tovitumaḡana yagwanisi si niya keta si fonayauwa tovitumaḡana tunisi matasiyai yasi fufunagoyo fasisiyai. ");
INSERT INTO wat_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Yagwanisi aviyaonana si ooibaiba, yasi nufunufu si visiuna sabu matasiyai keta si guwanisiya. Taki noko nufunufusima sita vikimwaneisiya, fatasi kana naḡa nakasina venemokena maise 50,000 siniva. ");
INSERT INTO wat_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Matatafuna nofe iba i kikinomana nenei keta Tuveka fonana i mutuna fifiwanamokena. ");
INSERT INTO wat_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nofe ibasima si kikinomana muninei, Fauno i vinuwadadana be ina onota Masedoniya keta Akaiya fafanisima nenesiyai muniyai yo ina niya Yenusanema. Tovitumaḡana nenesiyai i bwaduwa, “Muniyai yo ana niya Noma.” ");
INSERT INTO wat_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kana toovivita nasi nuwa Timoti keta Enasitusi i visimeisiya si mikiniya Masedoniya atu tanake tauna i fakwa Eisiya simo tova matanubwayouna. ");
INSERT INTO wat_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Naki noko tovanama nenei vikasanegwanegwa nakasina i kikinomana Efeso sinenei Yeisu yana Ke'ta fasinei. ");
INSERT INTO wat_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tamokaḡa namoḡa nokomai kana wava Demetiniyasi, tanake o siniva nenei kaivakuku be iba yagwanisi nukawanamanamaneinasi kana tokifufuna. Fiyao Ginisi yasi guyau gumayogu o kana wava Atemisi eketa Demetiniyasi numa musumususi i kikifufuna-vikuvikukuna guyaunama kana kafa kodukodu kana numa maise eketa namoḡa si vivikimwaneya. Yana tobunanige matatafusi nukusi si kikifufuna be si vivikimwaneina keta gabana nakasina si viviya. ");
INSERT INTO wat_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yana tobunanige matatafusi i wenevakukusisiya yota tasike aviyaonana yasi savivina maise eketa nenesiyai i bwaduwa, “Fiyao, kwa sanamaniya gabana nakasina kita ta viviya nofe savivinanama nenei. ");
INSERT INTO wat_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Naki tututaumi kwa kitiya keta kwa nowaniya namaise Fauno i savisavivina Efeso sinenei eketa yota fafani Eisiya kana matatafu. Tanake namoḡa yagwanisi nuwatasi i kanikaniya keta Atemisi kana kodukodu si visaḡaketuketuwiya. Tanake i bwadubwaduwa, ‘Iba kafa kodukodu namoḡa nimasiyai si kikifufuna o mukamokena guyau.’ ");
INSERT INTO wat_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Eketa kita aviyaonana kaivakuku kasi tokifufuna tana kitadewadewa be Fauno muka kata wava ina givigoyoi yota muka yata kaikaiwabu kana ke'ta ina guduya. Keta yota muka yata guyau kana kafa kodukodu kana numa ina viibakaokaoḡo. Nofe tova Eisiya sinenei be fwayafwaya kana matatafu si kodukoduwa guyau Atemisi nenei, eketa kita matata ina fakina venemokena be kana wava muka ina bwavi.” ");
INSERT INTO wat_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tovanama Demetiniyasi yana bwadu si nowaniya, kayosi i kuḡa keta si vikafinafina, “Kita fiyao Efeso yata guyau Atemisi kana wava o nakatamokena!” ");
INSERT INTO wat_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Namoḡa matatafusi menana sinenei kayosi si nowaniya eketa si vibutuwa si vikafinafina atu muka kana uḡu sita sanamanei. Keta sabu si nemiya Gaiyusi keta Anisitako si givikavinisiya, tasike fiyao Masedoniya atu Fauno nukusi si ninidadana, keta si sinakanikanisiya keta si niisiya menana yana kafa nusifusifufu kana kabaḡai. ");
INSERT INTO wat_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Fauno nuwanuwana be ina niya yoko matasiyai be ina nusifufuwa, atu tomuniyeina muka sita sawateweyei. ");
INSERT INTO wat_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Yota tunisi fafani Eisiya kana namoḡa nakanakasisi, tasike aviyaonana Fauno unaunana, kana matakawa fifiwanina si teweiya Fauno nenei be muka ina nai menananama yana kafa nusifusifufu kana kabaḡai. ");
INSERT INTO wat_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kafa nusifusifufu kana kabaḡai, sabu nuwatasi i bauwa venemokena. Tunisi namoḡa si vikafinafina iba tamo fasinei eatu tunisi o si vivikafinafina nuwanuwa tunisi fasisiyai. Namoḡa yagwanisi muka sita sanamanei avana uḡuna yo si nai nokomai. ");
INSERT INTO wat_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Fiyao Diu namoḡa tamokaḡa si katutunetuniya kana wava Anekisenida i niya yoko naunei keta namoḡa yoko sinenei si fina be ina bwaduwa. Eketa Anekisenida nimanei i nusawatana namoḡa matatafusi ina kanovisiya fasinei be yoko ita iyavisiya vitana fiyao Diu muka sita vikaiuḡunei goyona nofe. ");
INSERT INTO wat_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Atu tovanama si kitiya tanake tene Diu, matatafusi vikafinafina si tenekasikasisiyemokiya tamo nenei si bwadubwaduwa, “Kita fiyao Efeso yata guyau Atemisi kana wava nakatamokena!” Kana nivaniva vanavana kana bai nuwesi i kakavisiya. ");
INSERT INTO wat_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Keta tamokaḡa menana kana namoḡa nakasina sabu i sawatanisiya keta nenesiyai i bwaduwa, “Fiyao Efeso, fwayafwaya kana matatafu si sanamaniya Efeso menana nakasina o tokitavikavina guyau Atemisi kana kafa kodukodu fasinei keta yota kana nawenawe maise kifukifufuna tafutafuna abamei i fekuwa. ");
INSERT INTO wat_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Matatafusi si sanamaniya nofe o venemokena, na uḡuna kwami ita kanovimiya eatu muka tamo fufuna goyona kwata savivinei. ");
INSERT INTO wat_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kwami namoḡa nofe kwa nemiisiya wekamai, atu tasike muka avana sita gikumai numa kodukodu nenei o bwadu goyona sita bwaduwei yata guyau Atemisi fasinei. ");
INSERT INTO wat_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kafa fonayau kana numa kakayauna yota kana namoḡa nakanakasisi o naki noko. Taki Demetiniyasi yana tobunanige nukusi nuwanuwasi be aitevana tamo sina vinoiya, kana nufota sina niya kana kabaḡai ebe yo nokomai tututausi sina vikavivinoiya. ");
INSERT INTO wat_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Atu taki yami nuwanuwa iba tunisi fasisiyai, nao menana kana namoḡa nakanakasisi yasi yokowai kana fata kwana nusifufuwisiya ebe sina gidawadawaniniisiya. ");
INSERT INTO wat_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Avamasi kimoki i kikinomana fasinei naki a matuta. Kita matata ita kata akata Noma namoḡa nakanakasisi sina vinuesanita sina bwaduwa vitana kita tata vivikasanegwanegwa. Nofe vikasanegwanegwanama muka tamo kana nuwatamayeta. Eatu taki nokomaise sina nuwanuwa kita fasitiyai, nao muka kana fata be tana gidawaniniyei.” ");
INSERT INTO wat_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tovanama menana kana namoḡa nakasina maise i bwaduwa muninei, namoḡa i gionovisiya si kikinomana keta kafa nusifusifufu kana kabaḡa si teweiya. ");
INSERT INTO wat_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tovanama noko vikasanegwanegwanama Efeso sinenei i kataniya, Fauno tomuniyeina i wenevakukusisiya eketa i vatonisiya ebe Yeisu sina munimuniiya. Muniyai yo i vioiyoowisiya eketa i noḡokawawa Masedoniya yana fafaniyai. ");
INSERT INTO wat_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Yana kikinomana muninei i niya menana tamokatamokaḡa nenesiyai tovitumaḡana i vavatonisiya yana sifufu yagwanina nenesiyai, eyo muniyai i niya fafani Ginisi, ");
INSERT INTO wat_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","eketa nokomai i fakwa yamayamana tonusi. Kabegomokena be wakai ita niya fafani Siniya nenei eatu i biganowana vitana fiyao Diu tunisi si weifufuna kana munuwa fasinei noko kamudadananama nenei. Na fasinei yana nuwanuwa i giviniya eketa i makaviniya Masedoniyei i niya. ");
INSERT INTO wat_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Namoḡa tunisi nukusi kaena si kwafuya maise Finusi natuna Sofata tene Beneya, fiyao Tesanonaika kasi nuwa Anisitako keta Sikanidasi, Gaiyusi tene Debi, Timoti, eketa fafani Eisiya namoisi kasi nuwa Tikikusi keta Tonofimusi. ");
INSERT INTO wat_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nofe namoḡasima wakai si viketanuna eketa Tonowasi menana nenei si fotikiya, ");
INSERT INTO wat_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Maneka Muka Nakana Nutuva Kana Ka muninei, menana Finifai nenei ka toḡa. Eketa kuyadayada kana vi5 muninei menana Tonowasi nenei unaunaki ka nisaisiya eketa nokomai ka fakwa wiki tamokaḡa. ");
INSERT INTO wat_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Satadei vanavanasonuwai tovitumaḡana tunisi nukusi ka yokowa viyao kana ka yota Tuveka yana ka kana kiyakiyaya kana kawiiya fasinei, atu Fauno i numamanisiya. I nuwanuwa vitana nuwabuni Tonowasi ina teweiya, na fasinei i nusifufuwisiya kana nivaniva i vinuwabunasinefouwa. ");
INSERT INTO wat_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Totomu kuetana namai ka yokowa nenei, kimayeta i kanatadenideniya. ");
INSERT INTO wat_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Namoḡa tufunakasina kana wava Yutiko numa kana kiyonavifofofo kana vitonu nugiginabu nenei i nuvitoḡa. Fauno yana sifufu i soniya nubwayoumataina eketa Yutiko matana i goyomoka. Tovanama i kenonuwataunuwa, i kabwataviniya keta i fekuwa fwayafwayai. Tovanama si sobuwa keta si sinanakasiya, si kitiya matematena. ");
INSERT INTO wat_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Fauno yota i sobuwa keta Yutiko tofwanei i tananiya eketa i nutaviya. Namoḡa i iyavisiya i bwaduwa, “Muka kwana nuwanuwa, namoḡa yawayawasina!” ");
INSERT INTO wat_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Munifotai i vanesavaviniya numai eketa Tuveka yana Ka kana kiyakiyaya i fufuniya eketa tovitumaḡana nukusi si kawa. I nusifufuwisiya kana nivaniva tova i katakiya yo muniyai na menananama i teweiya. ");
INSERT INTO wat_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tovitumaḡana o namoḡa dewadewana yawayawasina si oviya keta na yasi sebobo si niya numai. ");
INSERT INTO wat_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kimaḡa wakai ka venuviketanuna ka niya Asosi menana nenei, eatu Fauno i iyavikiya vitana kavananei ina nemiya nokomai yo kana totoiya. ");
INSERT INTO wat_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nokomai ka vikaninisaḡa keta i toḡa eketa matatafuki ka niya Mitinini menana nenei. ");
INSERT INTO wat_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nokomai ka teweikiya eketa kuyadayada kana vinuwa nenei ka niya menana tamokaḡa nenei Kiosi simuna niniunei. Nokomai ka banuwa yo muniyai ka kanayauwa ka niya Samosi simunai eketa kuyadayada kana vinuwa nenei o ka kikinomana Minitusi. ");
INSERT INTO wat_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Fauno muka nuwanuwana tova ina teweyei Eisiya yana fafaniyai, na fasinei muka kata kanasuna Efeso eatu ka venukatuvaavaḡa. I soḡowa uḡuna nuwanuwana be taki meyameyanina maise Yenusanema ita kikinomana Kabwaga Matana kana tovai. ");
INSERT INTO wat_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Eatu tovanama ka kanasuna Minitusi, Fauno yana kisuya i niya Efeso ebe ekanesiya kana tokawakawa sita nemiya sita kitiya. ");
INSERT INTO wat_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Tovanama si nemiya, i iyavisiya i bwaduwa, “Kwami naki kwa sanamaniya namaise yaku fakwafakwa kwami nukusi tova kana matatafu fafani Eisiya nenei, tovanama kafa viuḡuwai a nemiya eketa kana nivaniva kimoki. ");
INSERT INTO wat_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tunisi fiyao Diu si weifufuna be sita weikuvavanikuwa na nenei keta anuvanuva nakanakasisi nenesiyai a nisaisiya, na nakiyai atu nuwasobuwai yota tamo tova katekateku na yana bwedi nukusi atu Tuveka fasinei a bunanigeya. ");
INSERT INTO wat_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Muka tamo kami bwadu-ovivita ata givikaviniya, tovanama Guyau fonana nenei a numamana sagisagigi nenesiyai keta a visawavenena sabu nenemiyai yota numa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Bwadu fifiwanina fiyao Diu eketa Kani Kwauna a venisiya. A iyavisiya vitana yasi go'yona nenesiyai sina ugevinisiya be Guyau nenei sina saḡa keta yata Tuveka Yeisu sina vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Eketa sifufu nofe kwa nowaniya. Guyau Kanununa i visimeikuwa eketa ana niya Yenusanema, eatu muka ata sanamanei avana ina kikinomana nenekuwai, ");
INSERT INTO wat_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","eatu menanasima nenesiyai a niniya, Kanunu Tafutafuna i gigimatakawikuwa vitana nokomai deni eketa dauna nakanakasisi nenesiyai sina tenikuwa. ");
INSERT INTO wat_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yota taki sina nuvimatikuwa na muka fasinei ata nuwanuwa nakasina, eatu iba nakatamokena nenekuwai o nuwanuwaku Tuveka Yeisu bunanige i venikuwa ana nusafuya. Bunanigenama o Guyau yana omukumukutana bigana namoḡa ana iyavisiya. ");
INSERT INTO wat_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","A numamaniya matatafumi nenemiyai Guyau yana Kafa visime fasinei. Eatu naki nofe tova a sanamaniya gewa kimoki keta i niniya, muka yota tafakaiku kwana kitai. ");
INSERT INTO wat_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Muka tamo Guyau yana vinuwadadana kana matakawa ata givikaviniya, naki matatafuna a bwaduwekoḡoiya. Na fasinei bwadu venemokena nenei nofe tova ana iyavimiya. Taki aitevana tamo bwadu nofe muka ina vitumaḡanei ebe muka yawasivaḡata ina nisaḡai, iyau muka kaku kuvana. ");
INSERT INTO wat_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kwami toviketanuneina tututaumi kwana kitavikavinimiya yota tovitumaḡanasima matatafusi Kanunu Tafutafuna kanonovamiyai i tenisiya, kwana kitavikavina-dewidewisiya maise yomuyomu kasi tokitavikavina yana yomuyomu i kitakitavikavinisiya. Tasike Guyau yana namonamoḡa, tauna ufaufanei i kimwanetamanisiya. ");
INSERT INTO wat_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A sanamaniya tovanama ana venuteweimiya tonumamana-vikanonono sina nemiya sina tuyanomwanimiya eketa namoḡa yasi vitumaḡana sina givigoyuya, naki maisemoka anuketa-wanawanaki manimaninisi sina nemiya sifi waumisi nenesiyai eketa sina nuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Yawane yota tututaumi sinemiyai tunisi namoḡa sifufuvi-kanonono nenei sina visawavenena eketa tovitumaḡana nuwatasi sina kaniya ebe yasi visawavenenasima goyosi tovitumaḡana sina muniiya. ");
INSERT INTO wat_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Na fasinei matami ina fekuwa! Kwana tukuya, manamana tonusi sinesiyai na matainuku muka ata onovei yaku vivisawavenena tamokatamokaḡa nenemiyai kuyadayada be nuwabuna. ");
INSERT INTO wat_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Tova nofe Guyau nimanei a tenitenimiya. Yana omukumukutana sifufuna, naki kwana vitumaḡanemokiya. Taki bwadunama kwana muniiya, yawasimi sina tafwa fifiwanisi eketa Guyau yana sawanuwagabubu ina venimiya naki yana bwadudabadaba tauna yana namonamoḡa tenetenesineinasi nenesiyai maise. ");
INSERT INTO wat_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nukusi ta fakwafakwa nenei muka tamo aitevana yana gabana o kana kwame ata vai. ");
INSERT INTO wat_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kwami naki kwa sanamanikuwa, iyau tauku nimakuwai kaku ovivita a ninisaiya eketa nenei yota unaunaku a oovivitisiya. ");
INSERT INTO wat_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Yaku savivinasima nenesiyai iyau tauku a vikafakita nenemiyai eketa a visawavenimiya vitana yata dibumusiḡa nenei kana fata goyogoyo tana ovivitisiya. Tana tukuya Tuveka Yeisu i bwaduwa, ‘Kavenena namoḡa nenesiyai o kana sebobo nakatamokena muniyai yo yuna.’” ");
INSERT INTO wat_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Tovanama i nusifufukooḡa matatafusi kaetutusi si viketogunina eketa i kawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Yana sifufu nenei i iyavisiya i bwaduwa, “Muka yota tafakaiku kwana kita-savavinei.” Nofe bwadunama katekatesi i nuyavayavaniya, eketa matatafusi si nusiya si viyuiya eketa si bwedisitesitiya eyo si kwafuya nukusi si niya wakai. ");
INSERT INTO wat_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Efeso tovitumaḡana kasi toviketanuneina ka vioiyoowisiya muninei, ka sinanakata keta dawaniniina ka niya Kosi simunai eketa nokomai ka banuwa. Nuwabuni ka niya Nodesi eyo ka tamana Fatana menana nenei ka saniniya eketa ka sobuwa. ");
INSERT INTO wat_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nokomai waka tamokaḡa ka nisaiya ina tamana Foenisiya, nenei ka toḡa eketa ka kanayaukiya. ");
INSERT INTO wat_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ka nemiya Saifunusi simuna niniunei eketa kukikimawaki i fakwa eatu ka venukatuvaavaḡa Siniya yana fafaniyai. Wakanama o Taya menana nakasina kana nogonogo i totoiya ebe nokomai ina nusiwasiwaiya, na fasinei ka nikanasuna. ");
INSERT INTO wat_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nokomai tomuniyeina ka nisaisiya eketa wiki tamokaḡa nukusi ka fakwa. Nokomai Kanunu Tafutafuna yana visawavenena nenei, tomuniyeina Fauno si matakawiya be muka ina nai Yenusanema. ");
INSERT INTO wat_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Eatu tovanama yama nai kana tova i nisaiya, ka misiniya eketa ka noḡokawawa. Tovitumaḡana matatafusi na kakawasi eketa na natunatusi menana si teweiya eatu si kwafukiya nukusi ka sobuwa gibowai. Nokomai matatafuki kaetutuki ka viketogunisiya eketa ka kawanunukuwa. ");
INSERT INTO wat_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nukusi ka vioiyoowa eketa kima ka toḡa-savavinikiya wakai eatu tasike si makavinisiya yasi menanai. ");
INSERT INTO wat_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Yama kamudadana Taya nenei i kakaviya eketa ka kanasuna Tonimaisi menana nenei. Nokomai tovitumaḡana ka venuyofiyofisiya eketa nenesiyai ka fakwa kuyadayada tamokaḡa. ");
INSERT INTO wat_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kuyadayada venuwanei noko menananama ka teweiya atu ka niya Sisaniya menana nakasinei eketa nokomai Finifi yana numai ka fakwa. Tanake namoḡa tamo vivinuwadadaneinana. Tovanama Yenusanema sinenei namoḡa kasi 7 si gibokisiya, tanake o nukusi si vinuwadadaniya ebe yo sina ovivita Guyau yana mudadava fasinei. Yota tanake Guyau fonana kana tonumamana namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tanake natunatuna vivine tutubonosi nasi nufunina. Tasike tamo tova Guyau fonana fasinei si bwadubwaduvioḡona. ");
INSERT INTO wat_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kuyadayada muka yagwanina muninei Guyau yana tomatakawa tamokaḡa kana wava Agabusi, fafani Yudiya nenei i sobunemiya Sisaniya. ");
INSERT INTO wat_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","I nemiya nenekiyai, Fauno kana wakina i viya eketa tauna nimana keta kaena i kiyona eketa i bwaduwa, “Naki nofemaise Kanunu Tafutafuna fonana, ‘Fiyao Diu kasi toviketanuneina, toniwakina nofemaise sina yoniya eketa Kani Kwauna nimasiyai sina teniya.’” ");
INSERT INTO wat_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Tovanama nofe bwadunama ka nowaniya, tovitumaḡana tunisi nukusi Fauno ka nuoneoniya ebe muka ina nai Yenusanema. ");
INSERT INTO wat_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Eatu i bwaduwa, “Ava uḡuna nofemaise kwa bwedibwedi eyo katekateku kwa nunubudabudaniya! Iyau o muka vitana ata gidewadewa kaku kiyonaḡa fasinei, eatu naki a gidewadewa ebe Tuveka Yeisu fasinei ana mateya.” ");
INSERT INTO wat_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tovanama ka kitiya muka kana fata be yana nuwanuwa kana givinai, naki ka onoviya eatu ka iyaviya vitana avana Tuveka yana nuwanuwa maise ita saviviniya. ");
INSERT INTO wat_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kuyadayadasima i kakavisiya muninei, ka gidewadewa eketa ka noḡokawawa Yenusanema fasinei. ");
INSERT INTO wat_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sisaniya tomuniyeina tunisi nukusi ka niya, eketa si niikiya Munasoni tene Saifunusi yana numai eketa nokomai ka fakwa. Namoḡanama nofe o tanake tamo tovitumaḡana nauna. ");
INSERT INTO wat_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Tovanama ka kikinomana Yenusanema, tovitumaḡana na yasi sebobo si venuyofiyofikiya. ");
INSERT INTO wat_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kuyadayada venuwanei Fauno nukusi ka niya Yemesa ina kitiya fasinei, eketa Yenusanema tovitumaḡana kasi toviketanuneina matatafusi si nemiya nokomai. ");
INSERT INTO wat_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","I bwaduviagigikuwisiya muninei, matatafuna gunina ovina i nusifufuwekoḡoiya nenesiyai namaise yana bunanige sinenei Guyau i savivina Kani Kwauna nenesiyai fasinei. ");
INSERT INTO wat_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Tovanama yana sifufunama si nowaniya Guyau si daviya. Eketa Fauno si iyaviya si bwaduwa, “Unaki, naki ku sanamaniya fiyao Diu nofemai sagisagigi Yeisu si vitumaḡaniya eketa matatafusi Guyau yana visime si oofekufekuwiya. ");
INSERT INTO wat_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Eatu si nowaniya avage tovanama ku niniya Kani Kwauna yasi kabaḡa nenesiyai, matatafusi fiyao Diu ku vivisawavenena vitana Mosese yana visime sina saḡakuwakufutiya. Tamo iba avage ku iyaiyavisiya ebe natunatusi namoḡa muka sina nufifina yota kata sanu muka sina muniyei. ");
INSERT INTO wat_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yawane ya nemi fasinei sina biganowana. Na fasinei avamasi tamo tana fufuniya ebe sina sanamaniya vitana bwadusima si nowanowanisiya o muka venemokena. ");
INSERT INTO wat_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Eketa avana kana iyaviwa, naki maisemoka kuna fufuniya. Nofemai namoḡa kasi nufunina Guyau fasinei si kawayaba. ");
INSERT INTO wat_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nukusi kwa nai Numa Kodukodu wasiketanei ebe givieyaeya kana fufuna kwa savivininei Guyau matanei. Eyo muniyai kuna nufata ebe debabousi sina kigosiya. Taki namoḡa sina kitiwa nofe fufuninama kuna fufuniya, matatafusi sina sanamaniya gewa kwaḡa o Mosese yana visime ku munimuniiya. Eketa sina sanamaniya gewa sifufusima fasiweu o sifufu-vikanonono. ");
INSERT INTO wat_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Eatu Kani Kwauna tovitumaḡana fasisiyai, nao yasi nufunufu ka viginiwiya yata nuwanuwanama fasinei eketa nofemaise ka iyavisiya ka bwaduwa, ‘Avi viyo kifukifufuna nenesiyai si vibwanaoseiiya, muka kwana kaniya. Yota muka ufaufa kwana yumiya. Muka yomuyomu kayona kikidubina kwana kaniya. Eketa yota muka kwana kudokaokaoḡo.’” ");
INSERT INTO wat_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Eketa kuyadayada kana vinuwa nenei Fauno noko namoḡasima kasi nufunina i ovisiya eketa nukusi si givieyaeisiya Guyau matanei. Munifotai i kanasuna Numa Kodukodu kana wasiketai i matakawisiya avi tovai kasi givieyaeya kana tova ita kakavei fasinei. Ebe noko tovanama nenei kasi givieyaeya bwanaosesi, tovibwanaose sita vibwanaoseiisiya tamokatamokaḡa fasisiyai. ");
INSERT INTO wat_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","29","Kuyadayada 7 kabegomokena be givieyaeya kana fufuna ina kakaviya, tunisi fiyao Diu fafani Eisiya nenei Fauno si kitiya Numa Kodukodu kana kani sinenei. Eatu nauna o Fauno si kitiya Tonofimusi tene Efeso nukusi Yenusanema menana nenei, eatu si nuwanuwa vitana Fauno Tonofimusi ita kanasunei Numa Kodukodu kana kani sinenei. Namoḡa si visimwanakasisiya eketa Fauno si givikaviniya eatu si vikafinafina si bwadubwaduwa, “Fiyao Isineni kwa nemai. Kwa oviviteiki be namoḡa nofe kana mata ta tenei! Namoḡanama nofe i vivisawavenenaniya yana nidadana nenesiyai, kita Isineni i sawasawavigoyowita yota Mosese yana visime keta yota Numa Kodukodunama nofe fasinei. Ginisi namoisi i nemiisiya kabaḡa nofe tafutafuna nenei eketa i weigavigaviya Guyau matanei.” ");
INSERT INTO wat_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tovanama namoḡa si nowaniya dagedage i toḡa Numa Kodukodu sinenei, Yenusanema kana matatafu nuwanuwa si viya eketa kabaḡa tuninatunina nenesiyai si dibwana nokomai. Fauno si givikaviniya eketa si sinakanikaniya si kikinomaniya Numa Kodukodu kumenanina, eatu tuiyo kawa si venukatugudusiya. ");
INSERT INTO wat_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Fauno si vivibaiiya be sina nuvimatiya eatu Noma tonuaviya kasi toviketanuneina biga i nowaniya vitana fiyao Yenusanema namoḡa matatafusi si vivikamunumunuwa Numa Kodukodu kana kani sinenei. ");
INSERT INTO wat_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Eketa yana tonuaviya kasi kaimatana nukusi i venuvakukusisiya eketa si dibwana sabu kuweyaisi. Tovanama sabuveka si kitisiya tonuaviya kasi toviketanuneina nukusi si nenemiya, vitana Fauno si munumunuya eava si onoviya. ");
INSERT INTO wat_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tonuaviya kasi toviketanuneina i nemiya eketa Fauno i givikaviniya. Yana tonuaviya i visimeisiya eketa seni nuwesi nenesiyai si yoniya, munifotai eyo sabuveka i nutoninuvenuveisiya i bwaduwa, “Nofe o aitevana? Ava o i fufuniya?” ");
INSERT INTO wat_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Sabuveka sinesiyai namoḡa tunisi iba tamo fasinei si vivikafinafina, eatu namoḡa tunisi o naki si vivikafinafina-kaokaoḡowa. Vikafinafina i vikatumataiya eketa tonuaviya kasi toviketanuneina muka kana fata vidagedage kana uḡu ina sanamanei. Na fasinei yana tonuaviya i visimeisiya ebe Fauno sina kanasuniya numa fakinina nenei. ");
INSERT INTO wat_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Eatu tovanama i nemiya numa fakinina kana kaevaavaḡa niniunei, sabuveka si vibaimoka nuwanuwasi be Fauno sina givikaviniya, na fasinei tonuaviya si ginakasiya eketa si unamokiya ebe sina ofafafiya namoḡa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Sabuveka si omunitawisiya eatu si bwaubwauwa, “Kwa nuvimatei! Kwa nuvimatei!” ");
INSERT INTO wat_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Tovanama Fauno kabegomokena be numa sinenei sina kanasuniya, Giniki fonasiyai tonuaviya kasi toviketanuneina i iyaviya i bwaduwa, “Kana fata ata nusifufuwiwa?” Noko nenei tonuaviya kasi toviketanuneina i sabanutuḡa eketa i iyaviya i bwaduwa, “Omasi kwaḡa bwadu-Giniki ku sanamaniya? ");
INSERT INTO wat_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Iyau a nuwanuwa vitana kwaḡa bwatanemoka tene Itifita maise. I anuvanuva be kama toviketanuneina nenesiyai ita nuaviya, eketa totaniyagunu kasi 4,000 na funumisi i viketanunisiya eketa si niya fwayafwaya nunumonumonei. Eketa kwaḡa namoḡauma?” ");
INSERT INTO wat_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Fauno i nufata i bwaduwa, “Muka, iyau tene Diu, a tufuwa fafani Sinisiya sinenei menana na kana wava Tasusi nenei. Kana fata kuta sawateweikuwa be namoḡa ata nusifufuwisiya?” ");
INSERT INTO wat_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Toviketanuneina i vinowana eketa Fauno kaevaavaḡa nenei i misiniya eatu nimanei namoḡa i nusawatanisiya. Tovanama i katanisiya, Ibeniu fonasiyai i nusifufuwisiya. ");
INSERT INTO wat_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Fauna i bwaduwa, “Amamaku keta unaunaku, kwa vaneneḡeiku eatu tauku ana tanafafafanikuwa iyau muka tamo goyona ata fufuniya.” ");
INSERT INTO wat_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tovanama sabuveka Fauno si nowaniya tututausi Ibeniu fonasiyai i nunusifufuwisiya, vikafinafina si onoviya eatu si numananava. ");
INSERT INTO wat_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Fauno i bwadu-savaviniya i bwaduwa, “Iyau tene Diu, a tufuwa menana Tasusi nenei fafani Sinisiya sinenei. Nokomai Yenusanema a kanakata eketa nuwatasuyasuya a viya. Kaku tovisawavenena o Gamaniyeni eketa waḡawaḡata yasi visime be kasi sanu matatafuna i visawavenikuwa fakinina venemokena. Nuwanuwaku nakasina be Guyau ana muniiye-dewadewiya, maisemoka kimoki kwami kwa munimuniiya. ");
INSERT INTO wat_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Na fasinei aviyaonana Yeisu yana Ke'ta nununei si niniya, a givikuvavanisiya eketa tunisi si mateya. Yaku visime nenei tovitumaḡana namoḡa keta vivine si givikavinisiya eketa deni nenei si tenisiya. ");
INSERT INTO wat_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Tovibwanaose kasi toviketanuneina keta tokawakawa matatafusi nukusi si sanamaniya a bwadubwaduwa venemokena. Nufunufu viviginiwisi si venikuwa ebe tunisi unaunasi fiyao Diu menana Damasiko nenei si fakwafakwa ata venisiya. Nokomai a niya Yeisu kana tomuniyeina ata nuwasisiya ebe ata kiyona eketa ata makavinisiya Yenusanema ebe nofemai sita vimatadawanisiya. ");
INSERT INTO wat_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Naki kuyadayada kana sinefou nenei, ketai a niniya eatu Damasiko niniunei abamei mayesina matakikikwanena visabanutuḡai i tafafifinikuwa. ");
INSERT INTO wat_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","A fekuwa fwayafwayai eketa kayokayo a nowaniya i bwadubwaduwa nenekuwai, ‘Sauno, Sauno, ava fasinei yo ku givigivikuvakuvavaneiku?’ ");
INSERT INTO wat_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Eketa a nufata a bwaduwa, ‘Aiye, kwaḡa aitevana?’ Eketa i nufata i bwaduwa, ‘Iyau Yeisu tene Nasaneti, Iyau gwadikuma ku givigivikuvakuvavanikuwa.’ ");
INSERT INTO wat_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Namoḡasima nukusi ka niya o mayesina yota si kitiya eatu kayokayo i nunusifufuwikuwa o muka sita nowaniya. ");
INSERT INTO wat_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Eketa a nutoninuvenuviya a bwaduwa, ‘Tuveka, avamasi ana fufuniya?’ I iyavikuwa i bwaduwa, ‘Ku misini be ku nai Damasiko. Nokomai tamo aitevana ina nusifufuwiwa ebe yaku nuwanuwa matatafuna kuna savivinisiya.’ ");
INSERT INTO wat_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mayesina matakikikwanena mataku i fwakiya eketa muka kaku fata tamo aviyavana ana kitai, na fasinei unaunaku nimakuwai si ova eketa si niikuwa Damasiko. ");
INSERT INTO wat_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nokomai namoḡa tamokaḡa kana wava Ananaiyasi i fakwafakwa o Guyau nenei i kodukoduwa yota Mosese yana visime i munimuniye-dewidewisiya. Yota fiyao Diu matatafusi nokomai si vifotuwiya. ");
INSERT INTO wat_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","I nemiya niniukuwai i misiniya keta i bwaduwa, ‘Unaku Sauno, ku kita-savavineu!’ Na naki tovanama nenei a toneya eketa Ananaiyasi a kitiya. ");
INSERT INTO wat_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Eyo Ananaiyasi i iyavikuwa i bwaduwa, ‘Waḡawaḡata yasi Guyau i gibokiwa ebe yana nuwanuwa kuna sanamaniya. Toeyaeyanamoka naki ku kitiya eketa ku nowaniya i nusifufuwiwa. ");
INSERT INTO wat_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwaḡa kuna viwakakakiya tanake fasinei ebe namoḡa matatafusi kuna iyavisiya avana ku kitiya eketa ku nowaniya. ");
INSERT INTO wat_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eketa muka yota kuna fotafota. Naki ku misini be givibutabuta ku vai. Tovanama kuna kawanunukuwa Tuveka kana wavai, ya go'yona ina gona-teweisiya.’ ");
INSERT INTO wat_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Tovanama a makavinikuwa Yenusanema, Numa Kodukodu kana kani sinenei a kawakawanunukuwa eatu a kenokita. ");
INSERT INTO wat_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","A kitiya Tuveka i nunusifufuwikuwa i bwaduwa, ‘Namoḡa nofemai ya sifufu fasikuwai muka sina katuvai na fasinei dibwadibwaninei Yenusanema nofe tova ku teweyei.’ ");
INSERT INTO wat_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Eatu a iyaviya a bwaduwa, ‘Tuveka, naki namoḡa si sanamaniya numa kafa yokoyoko tamokatamokaḡa nenesiyai ka tovitumaḡana deniyai a tenitenisiya eketa a munumunusiya. ");
INSERT INTO wat_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Eketa tovanama ka tokanakakikakina Sitiveni si nunuvimatiya, iyau nokomai a misiniya eatu yasi fufunanama a visawadewadewiya, eketa tonuvimatesima kasi nuya a toḡatanisiya.’ ");
INSERT INTO wat_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Eatu Tuveka i iyavikuwa i bwaduwa, ‘Ku nai, a vivisimeiwa kedawanauwai Kani Kwauna nenesiyai.’” ");
INSERT INTO wat_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Sabuveka Fauno si vanevaneneiya eatu tovanama nofe bwadunama si nowaniya, kayosi i kuḡa eketa si vibutuwa si vikafinafina, “Namoḡa nofe ina mateya! Muka kana nufota be ina fakwafakwa!” ");
INSERT INTO wat_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Eketa si vivikafinafina eatu kasi nuya nenesiyai si nunukwasikwasiya eketa fwayafwaya kafusisimina si teweteweina atai. ");
INSERT INTO wat_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Toviketanuneina yana tonuaviya i visimeisiya ebe Fauno sina kanasuniya yasi numa fakinina kana kani sinenei. Eketa i visimeisiya ebe sina munuya eatu sina nutoninuvenuveiya be sina sanamaniya avana uḡuna fiyao Diu si kayokuḡa yo si finafina-takatakanei. ");
INSERT INTO wat_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tovanama si vibutuwa kunava nenesiyai si yonayoniya be sina munuya, Fauno tonuaviya yasi kaimatana i misimisiniya i iyaviya i bwaduwa, “Noma yana visime nenei o muka tene Noma kwana munu-kaokaoḡowei. Nauna kwata vinuesanikuwa ebe taki ata fufunagoyowa, enao kwata munukuwa.” ");
INSERT INTO wat_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tovanama kaimatana Fauno yana bwadu i nowaniya, i niya toviketanuneina nenei eketa i bwaduwa, “Avamasi kuna fufuniya? Namoḡa nofe o tene Noma.” ");
INSERT INTO wat_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Toviketanuneina i niya Fauno nenei eketa i iyaviya i bwaduwa, “Ku iyaveiku, venemokena kwaḡa tene Noma?” I nufata i bwaduwa, “Ika. Iyau tene Noma.” ");
INSERT INTO wat_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Toviketanuneina Fauno i iyaviya i bwaduwa, “Iyau gabana nakatamokena a nufata eketa a vitene Noma.” Eatu Fauno i bwaduwa, “Iyau o Noma yasi tufuwa.” ");
INSERT INTO wat_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tonuaviyasima vitana sita nutoninuvenuviya eatu si matuta keta si venuvamunimunikwana. Eketa tovanama toviketanuneina i sanamaniya vitana Fauno tanake tene Noma eatu i visimeisiya be si yoniya, eketa naki i matuta. ");
INSERT INTO wat_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kuyadayada venuwanei tonuaviya kasi toviketanuneina nuwanuwana fiyao Diu Fauno si vinoiya fasinei kana uḡu ina sanamaniya. Na fasinei deniyai i giyauya eketa tovibwanaose nakanakasisi eketa Diu Kawakawa i visimeisiya eketa si yokowa. Eyo Fauno i nemiiya keta tafakaisiyai i misiniya. ");
INSERT INTO wat_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Fauno matana dawaniniina i niya Diu Kawakawa nenesiyai eketa i iyavisiya i bwaduwa, “Unaunaku, yawasiku matatafuna a fakwiiya dawaniniina Guyau matanei, eketa katekateku o eyaeyana kana nivaniva kimoki.” ");
INSERT INTO wat_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tovanama tovibwanaose kasi toviketanuneina Ananaiyasi nofe bwadunama i nowaniya, i nuwagoyowa eketa aviyaonana Fauno niniunei si misimisiniya, i visimeisiya ebe kawana sita nutafifuwafuwaiya. ");
INSERT INTO wat_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Eatu Fauno i kawafatiya i bwaduwa, “Guyau ina nutafiwa. Namoḡa matasiyai ka kita dewadewana eatu katekateu o gavigavina. Nanemai ku nuvitoiwa avage Mosese yana visime nenei kuna vinuesanikuwa, eatu visimemokena o kwaḡa naki ku yakweniya tovanama namoḡa ku visimeisiya ebe sita nutafikuwa.” ");
INSERT INTO wat_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Aviyaonana Fauno niniunei si misimisiniya si iyaviya si bwaduwa, “Ava uḡuna Guyau yana tovibwanaose kasi toviketanuneina ku sawasawanuketuwei?” ");
INSERT INTO wat_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Fauno i nufata i bwaduwa, “Unaunaku, muka ata sanamanei gewa tanake o tovibwanaose kasi toviketanuneina. Guyau fonakituna i bwaduwa, ‘Muka yata sabu kasi toviketanuneina kuna sawanuketuwei.’” ");
INSERT INTO wat_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Fauno i sanamaniya Diu Kawakawa sinesiyai tunisi Sadusi eatu tunisi o Fanasi, eketa kayona nakasinei i bwaduwa, “Unaunaku! Iyau tene Fanasi maise yota amaku. A vitumaḡaniya Guyau namoḡa matematesi ina sinaviyawasa-savavinisiya. Nofe fasinei kwa vivinuesanikuwa.” ");
INSERT INTO wat_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tovanama Fauno nokomaise i bwaduwa, Fanasi eketa Sadusi si vibutuwa si avigwavigwaeḡa nenei yoko si takiya eketa nuwesi i kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Yasi vigwaeḡa uḡuna o nofemaise. Sadusi si bwaduwa avage muka tamo misini-savavineina yota muka tamo Guyau kana kaetoḡa abamei eketa yota muka tamo kanunu. Eatu Fanasi o nofe ibasima si vitumaḡanisiya. ");
INSERT INTO wat_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Vikawabwadubwadu i nakata, eketa tunisi visime kana tovisawavenena Fanasi kunumisi nenei si misiniya eketa si numanimaniniya si bwaduwa, “Namoḡa nofe muka tamo goyona ita fufuniya. Kana kita kamo tamo kanunu o tamo Guyau kana kaetoḡa abamei i nusifufuwiya.” ");
INSERT INTO wat_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Avigwavigwaeḡa i nakatamoka eketa tonuaviya kasi toviketanuneina i matuta Fauno sita sinabwegabwegiya, na fasinei yana tonuaviya i visimeisiya si oviya eketa si niiya yasi numa kana kani sinenei. ");
INSERT INTO wat_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na nuwabunanama nenei Tuveka i kenokikinomana keta Fauno kuniniuna i misiniya eketa i bwaduwa, “Kuna katevatumoka ebe namaise nofemai Yenusanema fasikuwai ku nusifufuwa, maisemoka yota Noma kuna nusifufuwa.” ");
INSERT INTO wat_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Tovanama vanavana i vaneya, Fiyao Diu tunisi Fauno fasinei si weifufuna eketa matatafusi si tanaḡaiya muka sina ka o sina yu kana nivaniva Fauno sina nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Namoḡa 40 na kasi tufo nukusi ketaketanama si vinowaniya ebe sina fufuniya. ");
INSERT INTO wat_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Si niya tovibwanaose nakanakasisi yota Diu tokawakawa nenesiyai eketa si bwaduwa, “Kima ka tanaḡaiya Guyau matanei eketa muka tamo avana kana kaniya kana nivaniva Fauno kana nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Eketa ka weifufuna vitana kwami keta Diu Kawakawa, tonuaviya kasi toviketanuneina kwata vikokoniya be Fauno ita sobunemiiya nenemiyai. Seba kwana teweiya ebe sina bwaduwa vitana kwata nutoninuvenuveyei ebe yana sifufu kwata sanamanadewadewai fasinei, eatu ketai kana fotamatamataveya ebe kana nuvimatiya.” ");
INSERT INTO wat_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Eatu Fauno auna namoḡa viwaifufunanama i ninowaniya eketa i kanasuna numa fakinina nenei Fauno i iyaviya. ");
INSERT INTO wat_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Eketa Fauno tonuaviya yasi kaimatana tamokaḡa i weniya eketa i iyaviya i bwaduwa, “Nofe tufunakatanama ku niyei ya toviketanuneina nenei, ebe yana nuwanuwa ina nusifufuwiya.” ");
INSERT INTO wat_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Eketa kaimatana namoḡanama i niiya toviketanuneina nenei eketa i bwaduwa, “Yata finisina Fauno i wenikuwa eketa i vikokonikuwa namoḡa nofe tufunakasina a nemiiya ebe sifufu tamokaḡa ina iyaviwa.” ");
INSERT INTO wat_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Toviketanuneina namoḡanama nimanei i oviya keta i niiya kuniniuna eketa taniyanei i kanakununuwiya i bwaduwa, “Avi sifufu kuna iyaveiku?” ");
INSERT INTO wat_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","I nufata i bwaduwa, “Fiyao Diu yasi nuwanuwa naki si givifakiniya eatu sina vikokoniwa ebe kumana Fauno kuna nemiiya Diu Kawakawa nausiyai avage sina nutonikuekuiya yasi sanamana fasinei. ");
INSERT INTO wat_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Eatu muka yasi bwadu kuna nowaniya. Yasi namoḡa 40 na kasi tufo si fotafotamatamataveya be Fauno sina munuya. Naki si tanaḡaiya muka sina ka, muka sina yu kana nivaniva Fauno sina nuvimatiya. Nofe tova naki si gidewadewa eatu si fotafotamoka yasi vikokona kana nufata fasinei.” ");
INSERT INTO wat_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Eketa tonuaviya yasi toviketanuneina namoḡa tufunakasina i iyaviya i bwaduwa, “Nofe sifufu ku iyavikuwa kuna ogaguwiya.” Eketa i gionoviya i niya. ");
INSERT INTO wat_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Eketa toviketanuneina yana kaimatana kasi nuwa i wenisiya eketa i visimeisiya i bwaduwa, “Tonuaviya kaeyai 200 kwana visiya yota 70 osi kasi totoḡa eketa 200 iyo namoisi. Kwana gidewadewa ebe nuwabuna 9 maise kwana niya Sisaniya. ");
INSERT INTO wat_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Yota osi kwana gidewidewisiya ebe Fauno ina toḡa. Kwana ofafafiya eketa kwana niiya tovisime Finikesa nenei.” ");
INSERT INTO wat_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Munifotai tonuaviya kasi toviketanuneina nufunufu nofemaise i viginiwiya. ");
INSERT INTO wat_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Iyau Konodiyasi Nisiyasi, nufunufu a viginiwiya kwaḡa namoḡa nakasiu tovisime Finikesa neneweu. Agigiku. ");
INSERT INTO wat_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Namoḡa nofe o fiyao Diu si givikaviniya eketa kabegomokena sita nuvimatiya. Eatu a sanamaniya tanake tene Noma, na fasinei yaku tonuaviya nukusi ka niya keta ka ofafafiya. ");
INSERT INTO wat_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Eatu nuwanuwaku yasi vinoi kana uḡu ana sanamaniya fasinei eketa a niiya Diu Kawakawa yasi kafa yokoyoko nenei. ");
INSERT INTO wat_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nokomai a nisaiya gewa yasi vikavivinoi o tututausi yasi visime fasinei eatu muka tamo Noma yana visime ita yakweniya ebe ana vimatadawanei mateyai o deniyai ana tenei. ");
INSERT INTO wat_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Tovanama Fauno kana viwaifufuna fasinei kana matakawa a viya, a venuvisimeiya i nemiya neneweu yota kana tovinoi a iyavisiya ebe yana goyona fasinei neneweu sina bwaduwe-kikinomanisiya.” ");
INSERT INTO wat_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Eketa toviketanuneina i visimeya maise yana tonuaviya si saviviniya. Eketa noko nuwabunanama nenei Fauno si oviya keta si kikinomaniya Enitifetinisi menana nakasina nenei. ");
INSERT INTO wat_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tovanama tova i katakiya, tonuaviya matatafusi si makavinisiya yasi numa fakinina Yenusanema nenei, eatu osi kasi totoḡaḡa Fauno si niiya Sisaniya menana nenei. ");
INSERT INTO wat_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tovanama si kikinomana, Fauno keta nufunufu viviginiwina tovisime nimanei si tenisiya. ");
INSERT INTO wat_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nufunufunama i ginaḡanaḡakoḡoiya muninei Fauno i nutoninuvenuviya i bwaduwa, “Kwaḡa o avi fafani?” Fauno i nufata i bwaduwa, “Iyau o Sinisiya fafaninama nenei.” ");
INSERT INTO wat_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Finikesa Fauno i iyaviya i bwaduwa, “Ka tovinoisima nofemai sina nemiya munifotai yo ana vaneneimiya ebe ana vinuesaniwa.” Eketa yana tonuaviya tunisi i iyavisiya vitana Fauno sina niiya Enoda yana numa tufomu kaikaiwabuna nenei keta sina toḡataniya. ");
INSERT INTO wat_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kuyadayada 5 muninei tovibwanaose kasi toviketanuneina kana wava Ananaiyasi yota tunisi Diu kana tokawakawa nukusi si sobuwa Sisaniya. Namoḡa kana wava Tetanusi nukusi si niya. Tanake tonusifufu yota Noma yasi visime kana tosanamana. Si niya si misiniya tovisime Finikesa naunei ebe Fauno sina vinoiya. ");
INSERT INTO wat_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tovanama Fauno i kanasuna vikanunusifusifufu sinenei, Tetanusi i misiniya eketa yana bwaduvinoi i vibutuya. “Yama namoḡa nakasiu, kwaḡa toviketanuneina na ya nuwatasuyasuya yota ya vinuwadadana dewadewasi, na fasinei biganei ka fakwa kawasasa nubwayouna keta iba yagwanina dewadewasi yama namonamoḡa nenesiyai si kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kabaḡa tamokatamokaḡa nenesiyai matatafuki yama viagigiku nakatamokena neneweu tova kana matatafu. ");
INSERT INTO wat_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Muka ana visinatamatamaneu nakatamataina eatu a kawanunukuwiwa ka fata yama sifufu kabegona kuta vaneneiya. ");
INSERT INTO wat_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Namoḡa nofe ka kitanisaiya tanake togivigoyo-onaona. Namai Diu si fakwafakwaniya nenesiyai avigwavigwaeḡa i gigikikinomaniya, yota tanake Nasanini yoko kana toviketanuneina. ");
INSERT INTO wat_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","I aanuvanuva be Numa Kodukodu ita weigavigaviya, na fasinei ka givikaviniya. ");
INSERT INTO wat_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Taki tauḡu kuna nutoninuvenuveiya, nao yama bwadubwadu kana venemokena kuna kitiya.” ");
INSERT INTO wat_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Eketa fiyao Diu matatafusi Tetanusi yana nusuyai si niya eketa si bwaduwa, “Bwadubwadu nofe matatafuna o venemokena.” ");
INSERT INTO wat_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Eketa Finikesa nimanei i nusawateweiya eketa Fauno i bwaduwa, “Aiye yo Finikesa, a sanamaniya manamana kana yagwana kwaḡa ku vitonuviesana fafani nofe sinenei, eketa tauku ana tanafafafanikuwa neneweu fasinei o a sebobowa. ");
INSERT INTO wat_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Taki tauḡu namoḡa kuna nutoninuvinuvisiya, sina iyaviwa vitana yawane kuyadayada 12 muka ita kakavei a vaneya Yenusanema Guyau nenei a kodukoduwa. ");
INSERT INTO wat_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Tovinoi nofe si kitikuwa muka tamo namoḡa nukusi kata vigwaeḡa Numa Kodukodu nenei. Muka tamo numa kafa yokoyoko o tamo kabaḡa menana nofe nenei namoḡa ata visimwanakasisi ebe sita vikamunumunuwa. ");
INSERT INTO wat_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Yota muka kasi fata aviyaonana tamo sina visawaveneu ebe yasi vinoi ina vivenemokena. ");
INSERT INTO wat_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Eatu a iyaveimi, amamaki yasi Guyau nenei a kodukoduwa yota iyau Yeisu yana Ke'ta nununei a niniya. Eatu si bwaduwa avage nofe o Ke'ta-vikanonono, eatu Mosese yana visime yota Guyau yana tomatakawa yasi viviginiwa matatafuna a vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Namaise yasi tumaḡana si teniya naki maisemoka yota yaku tumaḡana Guyau nenei a teniya vitana tova i nenemiya namoḡa dewadewasi be goyosi mateyai ina vitowamisiniye-savavinisiya. ");
INSERT INTO wat_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nofe fasinei tova matatafuna Guyau matanei yota namoḡa matasiyai a anuvanuvamoka ebe yaku nuwanuwa masamasanina keta yawasiku dawaniniina nenei ana fakwa. ");
INSERT INTO wat_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Yenusanema a teweiya manamana simo matayagwanina, eatu bwatanemoka a makavinikuwa ebe yaku sabu sinesiyai goyogoyo si fakwafakwa, kasi nuwagabubu ana kavenena eatu yota Guyau nenei ana vibwanaoseya. ");
INSERT INTO wat_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Givieyaeya kana fufuna a saviviniya eketa Numa Kodukodu sinenei a kodukoduwa eatu si nisaikuwa. Na tovanama nenei muka sabu nukusi yota muka tamo vikasanegwanegwa. ");
INSERT INTO wat_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Eatu tunisi fiyao Diu fafani Eisiya nenei o matasiyai eketa namoisima o sita nemiya nauweu, ebe si kitikuwa avi goyona a fufufuniya sita bwaduwe-kikinomaniya. ");
INSERT INTO wat_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nofe namoisima o sita iyaviwa avi sinatamaneina si nisaḡai nenekuwai tovanama Diu Kawakawa nausiyai a misiniya. ");
INSERT INTO wat_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Eatu iba tamokaḡamoka o tovanama nausiyai a misimisiniya, a bwauwa a bwaduwa, ‘A vitumaḡaniya Guyau namoḡa matematesi ina sinaviyawasa-savavinisiya. Nofe fasinei kimoki kwa vivinuesanikuwa.’” ");
INSERT INTO wat_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Yeisu yana Ke'ta fasinei Finikesa naki sanasanamanina eketa Fauno i sawataniya, eketa yasi yoko i gifotiya eatu i iyavisiya i bwaduwa, “Tovanama tonuaviya kasi toviketanuneina Nisiyasi ina nemiya, yana sifufu ana vaneneiya eyo munifotai ana vinuwadadana taki Fauno i sinatamaniya o muka.” ");
INSERT INTO wat_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Eketa tonuaviya yasi kaimatana i visimeiya ebe ina toḡatana-dewadewiya eatu simokaḡa ina sawateweiya yana savivina nenesiyai yota unaunana ina sawateweisiya ebe sina ovivita yana nuwanuwa nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kuyadayada muka yagwanina muninei, Finikesa eketa kawana ne Diu kasi wava Dunusina nukusi si nemiya. Bwadu si vininitiya eketa Fauno i nemiya. Finikesa i vaneneḡa eatu Yeisu Togifafafana Gigibokeinana kana vitumaḡana fasinei Fauno i givimayeta. ");
INSERT INTO wat_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Eatu tovanama i tenesaviya i gigivimayeta namaise Guyau nuwanuwana yawasi dawaniniisi eketa kwafini yana viginini kana kunuwaneina eketa yota kafa nuesana kunauta fasinei o Finikesa naki i matuta eketa i bwaduwa, “Naki nanemai ku onovei be ku nai, tovanama ana gidewadewa eyo ana wenesavaviniwa.” ");
INSERT INTO wat_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Eketa tova matatafuna Finikesa Fauno i wenewene-yewayewiya keta nukusi si nunusifufuwa. Fauno deniyai i fakwafakwa na fasinei Finikesa yana tumaḡana i teniya i nuwanuwa vitana Fauno nenei simokaḡa gabana ita visamwagauwiya kana ketoyau fasinei. ");
INSERT INTO wat_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Manamana nuwesi muninei Fonisiusi Fesitusi o Finikesa kana kivi i viya, eatu Finikesa fiyao Diu yasi nusuyai i niya eketa Fauno deniyai i kitamokiya. ");
INSERT INTO wat_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tovisime Fesitusi i kikinomana Sisaniya eketa i fakwa kana nivaniva kuyadayada tonusi i kakaviya muninei, eyo i vaneya Yenusanema. ");
INSERT INTO wat_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Nokomai tovibwanaose nakanakasisi eketa fiyao Diu kasi toviketanuneina si yokowa naunei eketa Fauno si vinoiya. ");
INSERT INTO wat_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Si vikokoniya vitana yasi nusuyai ita niya be Fauno ita visimeiya ita vaneya Yenusanema uḡuna si viwaifufuna ketai sina nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Eatu Fesitusi i nufata i bwaduwa, “Fauno o Sisaniya deniyai eketa tova kabegomokena ana makavinikuwa nokomai. ");
INSERT INTO wat_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Eatu kami toviketanuneina tunisi nukusi kata sobuwa, ebe taki Fauno i sinatamaniya maise o nokomai yasi bwaduvinoi sita teniya.” ");
INSERT INTO wat_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Yenusanema i fakwa kuyadayada taki 8 o 10 muninei i makaviniya Sisaniya. Kuyadayada kana vinuwa nenei kafa nunuesana kana kivi nenei i fakwasiotoḡa, eketa yana tonuaviya i visimeisiya keta Fauno si nemiiya naunei. ");
INSERT INTO wat_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Tovanama Fauno i kanasuna totomuwai, Diu toviketanuneina aviyaonana Yenusanemei si sobunemiya, si misinififiniya eketa vinoivikanonono yagwanisi si bwaduwisiya eatu muka tamo namai kana venemokena. ");
INSERT INTO wat_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Eketa bwadusima fasisiyai Fauno tauna i tanafafafaniya i bwaduwa, “Kwa nowaniya, iyau muka tamo goyona ata fufuniya Diu visime nenei o Numa Kodukodu nenei o tufomu Sisa nenei.” ");
INSERT INTO wat_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Eatu Fesitusi nuwanuwana Diu toviketanuneina yasi nusuyai ina niya fasinei eketa Fauno i nutoninuvenuviya i bwaduwa, “Namaise, ka fata tana vaneya Yenusanema ebe nokomai nofe vinoisima fasisiyai ana vinuesaniwa?” ");
INSERT INTO wat_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Eatu Fauno i nufata i bwaduwa, “Muka, uḡuna iyau nofe tova Sisa yana kafa nunuesana kana kivi naunei a misimisiniya. Yota iyau tene Noma, na fasinei nofemai kuta vinuesanikuwa. Tauḡu naki ku sanamane-dewadewiya muka tamo goyona ata fufuniya fiyao Diu nenesiyai. ");
INSERT INTO wat_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Eatu taki tamo avana a sinatamaniya ebe i nufotiya ana mateya, nao muka tamo avana. Eatu taki bwaduvinoisima nofe vikanonono, nao muka tamo aitevana kana fata be ina teneiku nimasiyai. Na fasinei nuwanuwaku Sisa naunei ana misiniya ebe ina vinuesanikuwa.” ");
INSERT INTO wat_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesitusi yana togivisawakedana nukusi si vikanunusifufuwa Fauno yana bwadu fasinei eyo i nufata i bwaduwa, “Nuwanuwau Sisa fasinei o kuna niya Sisa nenei.” ");
INSERT INTO wat_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kuyadayada muka yagwanina muninei, tufomu Aganifa eketa nouna Benisi si kikinomana Sisaniya ebe Fesitusi i vitovisimeya kiouna fasinei si venufotiya. ");
INSERT INTO wat_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nokomai si fakwa kuyadayada yagwanina, eketa Fesitusi tufomu Aganifa i nusifufuwiya Fauno fasinei. I bwaduwa, “Finikesa yana tovai, namoḡa tamokaḡa deniyai i teniya eketa namoḡamokena yawane noko i fakwafakwa. ");
INSERT INTO wat_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Tovanama a niya Yenusanema, tovibwanaose nakanakasisi eketa Diu tokawakawa si vinoiya eketa si vikokonikuwa ebe ketaketa ata fufuniya be sita nuvimatiya. ");
INSERT INTO wat_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Eatu a iyavisiya vitana Noma yama visime nenei nauna namoḡa ina misiniya tovinuesana keta kana tovinoi nausiyai ebe tauna fasinei ina tanafafafana muniyai yo kana visime ina nisaiya. ");
INSERT INTO wat_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tovanama fiyao Diu kasi toviketanuneina nukusi ka nemiya nofemai muka ata fota. Nuwabuni a fakwasiotoḡa yaku kafa nunuesana kana kivi nenei eatu yaku tonuaviya a visimeisiya eketa Fauno si nemiiya naukuwai. ");
INSERT INTO wat_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Eketa tovinoi si misiniya eketa a nuwanuwa vitana tamo avi fufuna goyomokena ita fufuniya fasinei o sita iyaveiku. ");
INSERT INTO wat_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Eatu tututausi yasi kodukodu kana visime fasinei eketa yota namoḡa matematena kana wava Yeisu fasinei si ovivigwaeḡa. Eatu Fauno i bwadubwaduwa avage namoḡanama o yawayawasina. ");
INSERT INTO wat_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Yasi avigwavigwaeḡasima fasisiyai a bauwa, na fasinei a vikokoniya taki kana fata maise kata vaneya Yenusanema ebe vinoisima fasisiyai nokomai ata vinuesaniya. ");
INSERT INTO wat_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Eatu Fauno i vikokona vitana deniyai ita fakwa kana nivaniva Sisa fonana ita nowaniya. Na fasinei tonuaviya a visimeisiya eketa deniyai si tene-savaviniya. Yaku kawasasa ana kitiya maise ana visimeiya Sisa nenei.” ");
INSERT INTO wat_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Aganifa Fesitusi i iyaviya i bwaduwa, “Ake, iyau nuwanuwaku nofe namoḡanama yana sifufu tauku ana vaneneiya.” Fesitusi i nufata i bwaduwa, “Kumana yo kuna vaneneiya.” ");
INSERT INTO wat_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kuyadayada kana vinuwa nenei, tufomu Aganifa keta Benisi kasi kwame dewabausi si kotonina eketa namoḡa si venuyofiyofisiya si ovisiya keta si kanasunisiya kafa fonayau kana totomuwai. Tonuaviya kasi toviketanuneina eketa menana kana namoḡa nakanakasisi si vinuwisiya eketa nukusi si kanasuna. Munifotai Fesitusi yana tonuaviya i visimeisiya keta Fauno si nemiiya nausiyai. ");
INSERT INTO wat_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Eketa Fesitusi i bwaduwa, “Tufomu Aganifa keta matatafumi namoḡa nakanakasimi kimoki naumiyai namoḡa nofe kwa kitakitiya. Fiyao Diu matatafusi Yenusanema keta Sisaniya sinenei, tanake fasinei si odowa nenekuwai. Si vikafinafina si bwadubwaduwa avage muka nuwanuwasi yawayawasina ina fakwa. ");
INSERT INTO wat_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Eatu muka tamo avi goyona ata nisaḡai ebe ana nuvimatei. Eatu tauna nuwanuwana Sisa naunei ina misiniya. Na fasinei ana visimeiya ina niya Noma. ");
INSERT INTO wat_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Eatu yawane muka ita mayesiku aviyavanamasi ana viginiwiya Sisa nenei namoḡa nofe fasinei. Na uḡuna a nemiiya matatafumi naumiyai ebe kwaḡa tufomu Aganifa nukusi tana nutonikuekuiya ebe yo aviyavana tamo ana viginiwiya Sisa nenei. ");
INSERT INTO wat_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Muka ita nufotaiku be yana goyonanama muka kana sanamana eatu ina nai Sisa nenei. Nauna ana sanamaniya ebe kana fata Sisa ana matakawiya goyonanama fasinei.” ");
INSERT INTO wat_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Munifotai tufomu Aganifa Fauno i iyaviya i bwaduwa, “Nofe tova a sawateweiwa ebe tauḡu fasiweu kuna nusifufuwa.” Fauno nimana i tataiya eketa tauna fasinei i tanafafafaniya i bwaduwa, ");
INSERT INTO wat_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Agigiku tufomu Aganifa, a sebobowa uḡuna kimoki mataweu fiyao Diu yasi bwaduvinoi matatafuna fasinei tauku ana tanafafafanikuwa. ");
INSERT INTO wat_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kita Diu kata sanu yota yama nuwatabausima ka oovigwavigwaeisiya matatafuna sanasanamaniu. Na fasinei a vivikokoniwa be kunuwaneina nenei yaku sifufu kuta nafanafiya. ");
INSERT INTO wat_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Matatafusi fiyao Diu si sanamaniya yawasiku kabegokuwai kana nivaniva kimoki. Si sanamaniya namaise nauna a mikifakwa tauku yaku fafani nenei yota munifotai Yenusanema. ");
INSERT INTO wat_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Muka vitana matayauyoisi. Si sanamaniya iyau tene Fanasi eketa kama kwenava Guyau kana kodukodu fasinei o fakinamataina yo muniyai yoko tunisi. Yama visime matatafusi o fakinina venemokena eatu a munimuniisiya. ");
INSERT INTO wat_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kimoki avage nuwanuwasi kuna vinuesanikuwa uḡuna yaku tumaḡana a teniya vitana Guyau avana waḡawaḡata i bwadudabedabisiya ina saviviniya fasinei. ");
INSERT INTO wat_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Yata fasekwa 12 yota yasi tumaḡana si teniya vitana Guyau yana bwadudabadabanama ina vivenemokena. Eketa vimogumoguwai nuwabuna be kuyadayada si kodukoduwa nenei. Tufomu yo, nofe tumaḡananama fasinei keta Diu toviketanuneina si vivinoikuwa. ");
INSERT INTO wat_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ava uḡuna kwa nuwanuwa vitana Guyau muka kana fata be namoḡa matematesi ina sinaviyawasa? ");
INSERT INTO wat_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","A vinuwadadana ebe iba matatafusi ata fufunisiya avage Yeisu tene Nasaneti kana wava ata givigoyuya fasinei. ");
INSERT INTO wat_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Eketa nuwanuwanama o nauna Yenusanema a mikifufuniya. Tovibwanaose nakanakasisi nokomai visime si venikuwa eketa Guyau yana namonamoḡa yagwanisi deniyai a tenisiya. Yota kasi nuvimate fasinei a visawadewedewiya. ");
INSERT INTO wat_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tova matayagwanina numa kafa yokoyoko nenei a vimatadawanisiya. A fiwana namaise be yasi vitumaḡana Yeisu fasinei sita vikeweiya. Kayoku i kuḡa eketa a niya maniuna yasi menanai a venunuwasisiya be ata givikuvakuvavanisiya. ");
INSERT INTO wat_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Tova tamokaḡa Yenusanema tovibwanaose nakanakasisi visime si venikuwa eketa si visimeikuwa ebe a niniya Damasiko menana nakasina nenei. ");
INSERT INTO wat_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Tufomu yo, na tovanama nenei kuyadayada sinefounei ketai a niniya eatu mayesina matakikikwanemokena yo vanavana abamai a kitiya. Namoḡasima nukusi ka niniya i tafafifinikiya. ");
INSERT INTO wat_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Eketa matatafuki ka fekuwa fwayafwayai eatu kayokayo bwadu-Ibeniu nenei a nowaniya i bwadubwaduwa nenekuwai, ‘Sauno, Sauno, ava fasinei yo ku givigivikuvakuvavaneiku? Kwaḡa tauḡu ka debana ku yaweyawiya.’ ");
INSERT INTO wat_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Eketa a nutoniiya a bwaduwa, ‘Aiye, kwaḡa aitevana?’ Eketa Tuveka i nufata i bwaduwa, ‘Iyau Yeisu, Iyau gwadikuma ku givigivikuvakuvavanikuwa. ");
INSERT INTO wat_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Eatu ku otowamisini! A kikinomaniwa uḡuna a gibokiwa kaku kaetoḡa. Aviyavana kimoki ku kitiya yota aviyavana yawane ana visawaveniwa, kwaḡa kasi toviwakakaki. ");
INSERT INTO wat_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kwaḡa o ana ofafafiwa tauḡu ya sabu yota Kani Kwauna nenesiyai. Eketa a vivisimeiwa kuna niya nenesiyai, ");
INSERT INTO wat_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","matasi kuna gibwasasa ebe yasi fufunagoyo kana fata sina sanamaniya be kumanovana nenei sina saḡavinisiya mayesina nenei. Seitani yana fiwana nenei sina saḡavinisiya sina nemiya Guyau nenei. Munifotai sina vitumaḡanikuwa nenei, yasi go'yona ana vinuwateweisiya ebe yasi kabaḡa sita vitoniwagiya yaku namonamoḡa tafutafusi kasi kawasasai.’ ");
INSERT INTO wat_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Eketa tufomu Aganifa, nofe kenokitanama abamei i sobunemiya a muniiya. ");
INSERT INTO wat_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","A vibutuwa a numamana fiyao Diu Damasiko sinenei yota Yenusanema sinenei eketa fafani Yudiya kana matatafu a numamananiya. Munifotai Kani Kwauna nenesiyai a numamana vitana yasi fufuna goyosi sina onovisiya eatu yawasisi Guyau sina veniya. A iyavisiya vitana yasi fufuna nenesiyai, sina visawavenena venemokena gewa naki i kavinisiya. ");
INSERT INTO wat_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Biga nofe a numamaniiya fasinei, tunisi fiyao Diu Numa Kodukodu sinenei si givikavinikuwa keta si anuvanuva be sita nuvimatikuwa. ");
INSERT INTO wat_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Noko tovanama nenei kana nivaniva kimoki, Guyau yawane i oovivitikuwa. Na fasinei nofemai a misimisiniya ebe namoḡa matatafumi na kami wava atu i sobuwa muka na kami wava a iyaiyavimiya avana Guyau yana tomatakawa eketa Mosese si bwaduwisiya ina kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Si bwaduwiya vitana Togifafafana Gigibokeinana ina kuvavana keta yota mateyai ina mikimisini-savaviniya, keta ina numamana be biga dewadewana ina vikimayeta tauna yana sabu fiyao Diu eketa Kani Kwauna nenesiyai.” ");
INSERT INTO wat_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Fauno nofe ibasima fasisiyai i nunusifufuwa eatu Fesitusi i fina i bwaduwa, “Fauno, kamo ku wafa! Ya sanamana i nakatamataiya nenei debabouḡu i givigoyuya!” ");
INSERT INTO wat_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Eatu Fauno i nufata i bwaduwa, “Yama namoḡa nakasiu, iyau muka ata wafa. Avana a bwadubwaduwiya o kana venemokena keta yota na kana sanamana. ");
INSERT INTO wat_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nofe ibasima a nunusifufuwisiya o muka makamakaviunai ita savivina, na fasinei a sanamaniya tufomu Aganifa o naki na ya sanamana eketa ibasima fasisiyai a nunusifufuwa menanai.” ");
INSERT INTO wat_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Fauno i nutoninuvenuviya i bwaduwa, “Tufomu Aganifa, Guyau yana tomatakawa yasi viginiwa ku vitumaḡaniya o muka? A sanamaniya ku vitumaḡaniya.” ");
INSERT INTO wat_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Eketa Aganifa Fauno yana bwadu i fatiya i bwaduwa, “Omasi ku vinuwadadana tova bwatana nenei yaku nuwanuwa kuna kaniya be ya vitumaḡanai ata vitumaḡana?” ");
INSERT INTO wat_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Fauno i nufata i bwaduwa, “Tova taki bwatana o nubwayouna, o muka kana tunina. Eatu yaku kawanunuku Guyau nenei o vitana kwaḡa keta aviyaonana kimoki kwa vanevaneneikuwa o Tuveka Yeisu kwata vitumaḡaniya eatu muka kwata vifinisina maise iyau.” ");
INSERT INTO wat_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Munifotai tufomu Aganifa keta tovisime Fesitusi keta Benisi yota aviyaonana nukusi nokomai si misiniya keta totomu si teweiya. ");
INSERT INTO wat_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Eatu tututausi si vikanunusifusifufuwa si bwaduwa, “Namoḡa noko muka tamo avana goyona ita fufuniya ebe yo ina nai deniyai o ina mate.” ");
INSERT INTO wat_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Aganifa Fesitusi i iyaviya i bwaduwa, “Kana fata namoḡa nofe tana giyauya ebe ina niya, eatu naki tauna i bwaduwa nuwanuwana tufomu Sisa naunei ina misiniya ebe ina nuesana. Na fasinei muka kata fata tana giyauya.” ");
INSERT INTO wat_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Noko tovanama nenei Fesitusi i vinuwadadana vitana Fauno keta finisina sina toḡa Itani fasinei, deni kana tokitavikavina, Fauno keta tunisi finisina si tenisiya Yuniyasi kanonovanei. Tanake o tufomu Sisa yana tonuaviya tomatakaikai kunumisi tamo kana kaimatana. ");
INSERT INTO wat_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Menana Adanamitiyumi nenei waka tamokaḡa i nemiya eketa Anisitako tene Tesanonaika fafani Masedoniya sinenei nukusi ka toḡa. Wakanama o fafani Eisiya gibo kafakainei ina venufanafana eketa menana nakanakasisi nenesiyai ina nikanakanasunaniya. ");
INSERT INTO wat_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kuyadayada kana vinuwa nenei ka kanasuna Saidoni menana nakasina nenei. Yuniyasi Fauno i kitanuwagabubuwiya eketa i sawateweiya i niya unaunana nenesiyai kana ovivita fasinei. ");
INSERT INTO wat_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Munifotai kabaḡa noko ka teweiya. Fonimana ka viketosoḡaniya eketa muka kama fata be yama kituḡa nenei kana dibwana. Na fasinei Saifunusi simuna kukwauna ka venufanafana. ");
INSERT INTO wat_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Munifotai kawasasa ka venuonosiya eketa fafani Sinisiya eketa Famufiniya etasiyai ka venufanafana kana nivaniva ka kanasuna menana Maina nenei ka sobuwa Nisiya yana fafani sinenei. ");
INSERT INTO wat_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nokomai kaimatana waka tamokaḡa i nisaiya Anekisenidiyei i nemiya keta i niniya Itani, eketa nenei ka toḡa. ");
INSERT INTO wat_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Dauna nakasina eketa kuyadayada yagwanina makamakanuwaki ka dibwana kana nivaniva menana Nidusi niniunei ka kikinomana. Eatu fonimana ka viketosoḡaniya fasinei eketa ka venutamana Kiniti simuna i babikiya eatu ka venufanafana kana nivaniva menana Sanumone mutuna ka tutuuniya. ");
INSERT INTO wat_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kafakainei fonimana ka vituḡaiya kana nivaniva kafasiwaḡa kana wava Kafasiwaḡa Kiwaḡa nenei menana Nasiya niniunei ka kanasuna. ");
INSERT INTO wat_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Yama dibwana wakai nubwayoumataina eketa Go'yona Kana Vibwanaose kana kuyadayada nakasina naki i kakaviya. Nofe tovasima nenesiyai o gibo i sakasakanunuwa. Na fasinei Fauno i misiniya eketa yasi nona i kakiniya. ");
INSERT INTO wat_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","I bwaduwa, “Unaunaku, nuwatamiyai a teneteniya yata kamudadana kunauta o daunina. Yawane nogonogo eketa waka tauna tana teweisiya yota tunita tana mateya.” ");
INSERT INTO wat_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Eatu kaimatana Yuniyasi muka Fauno fonana ita nowaniya, eatu tonumunikuta eketa toniwaka fonasi i muniiya. ");
INSERT INTO wat_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Noko kafasiwaḡanama muka kana fakwa dewadewana yauya kana tutuya nenei. Na fasinei namoḡa matayagwanisi nuwanuwasi kata sinanakata-savavinikiya ebe kata dibwana-nuvanuva simuna Kiniti nenei ebe Fonikisi kafasiwaḡai kata toḡavikifafa. Uḡuna kafasiwaḡanama o Kiniti simuna i nutenekifafiya eketa tova matatafuna nunumanona. ");
INSERT INTO wat_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tovanama fonimana dibidibina gagasei i vibutuwa i siveginegineneya, toviwakasefusefu si vinuwadadana vitana avana si weifufuniya sina saviviniya, na fasinei tutuvidauna si sinanakasiya eketa simuna Kiniti kafakainemokenei ka venufanafana. ");
INSERT INTO wat_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Tova bwatana nenei yamududuwe fifiwanina i viyuveyuve-sobunemiya Kiniti simuna kuweyaina eketa waka i sinaviviiya. ");
INSERT INTO wat_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Toviwakasefusefu si anuvanuva be fonimana kuweyaina waka sina visaiya eatu si vibaiwayosa uḡuna fonimana i givikavinikiya eketa si teweiya fonimana i nutunemokikiya. ");
INSERT INTO wat_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Tovanama Kauda simuna kabesona kukwauna ka venufanafana, eatu waka kana kimonou ka fiwanamokikiya keta ka sinanakasiya eketa toviwakasefusefu si yonavikavikaviniya. ");
INSERT INTO wat_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Tovanama si nusafuwa, unava nenesiyai waka tauna tofwana si takwaniya. Si matuta fonimana waka ita nuyakweyakweniya nai nidebadebana kana wava Satusi gunina nenei. Na fasinei naya na kana nogonogo matatafuna si unisiya wakai eatu wakanaḡa fonimana i nutunemokiya. ");
INSERT INTO wat_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yoyo waka i tutuya nakatamataina fasinei eketa kuyadayada venuwanei waka kana nogonogo si vibutuwa si tewesobusobuwina gibowai. ");
INSERT INTO wat_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kuyadayada kana vitonu nenei naya kana nogonogo matatafuna yota tututausi nimasiyai si tewesobusobuwina. ");
INSERT INTO wat_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tova i goyomoka nenei eketa muka tamo vanavana o kinavinavi kata kitaisi kana nivaniva kuyadayada yagwanina i kakavisiya. Fonimana fifiwanina i tene-savivaḡasiya eketa nuwanuwa yaona i vanikiya kama gifafafana fasinei. ");
INSERT INTO wat_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kawasasa nakatamataina namoḡa muka tamo sita kanuvanuva. Na fasinei Fauno i misiniya kasi kawasasai keta i iyavisiya i bwaduwa, “Unaunaku, naki kwa kitiya. A iyavimiya Kiniti muka tana teweyei eatu yaku bwadu muka kwata nowaniya. Na fasinei yami waka i goyowa yota yami nogonogo kwa teweteweina. ");
INSERT INTO wat_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Eatu nofe tova a iyaiyavimiya, wakaḡa ina gamomona eatu muka tamo aitevana yawasina ina niteweyei, na fasinei katekatemi si vatu. ");
INSERT INTO wat_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Guyaunama o yaku Tuveka nenei a kodukoduwa, nuwabuna kana kaetoḡa abamei i nemiya keta i misiniya niniukuwai. ");
INSERT INTO wat_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Eketa i iyavikuwa i bwaduwa, ‘Fauno, matuta ku onovei. Sisa naunei kuna misiniya ebe ina vinuesaniwa. Nofe uḡunanama fasinei Guyau ya kawanunuku i nowaniya eketa kwaḡa neneweu matatafumi wakai ina ofafafimiya.’ ");
INSERT INTO wat_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nofe fasinei unaunaku, katekatemi si vatu. Guyau avana i iyavikuwa maisemoka a vitumaḡaniya ina kikinomana. ");
INSERT INTO wat_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Eatu fonimana o ina sivetunetunita kana nivaniva tamo simuna nenei ina nuvaneita.” ");
INSERT INTO wat_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nofe naki kuyadayada kana vi14, yoyo keta fonimana i nutafivinivinikiya Mediteneniyani gibo nenei. Tovanama i vinuwabunasinefouwa, toviwakasefusefu si kamukonisiya vitana fwayafwaya naki ka vevenukitekitiya. ");
INSERT INTO wat_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Na fasinei unava si givigaviviniya eketa gibo yana viwagudabu si fwafwiya keta si kitiya kana niva 40 mita maise. Si fakwa kabesona yota si fwafwa-savaviniya eketa kana niva i makaviniya 30 mita maise. ");
INSERT INTO wat_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Eketa toviwakasefusefu si matuta uḡuna si nuwanuwa vitana fonimana waka ina nuvaneiya nibwaga nenesiyai. Eketa tutuvidauna nufunina waka kumunina si tewesobuwisiya, eatu tova si viyokaniya be ita venukatakiya. ");
INSERT INTO wat_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Toviwakasefusefu si anuvanuva be wakai sita dibwana, na fasinei kimonou si tewesobuwiya eketa si gisebaseba vitana waka mutunei tutuvidauna kasi tewesobuweina fasinei. ");
INSERT INTO wat_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Eatu Fauno kaimatana yana tonuaviya nukusi i iyavisiya i bwaduwa, “Kwa nowaniya, taki toviwakasefusefu muka wakai sina fakwa, nao muka tamo gifafafana.” ");
INSERT INTO wat_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Eketa tonuaviya kimonou kana unava si tanaonosiya keta i kanuwiya. ");
INSERT INTO wat_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Tova i vibutuwa i gegegesiya, Fauno namoḡa matatafusi i kamanemanisiya be sita kawa. I bwaduwa, “Nofe naki kuyadayada kana vi14 yami toḡafota nenei, muka tamo aviyavana kwata kanuvanuvai. ");
INSERT INTO wat_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nuwanuwaku kwana kawa ebe kwana fiwana. Eatu muka vitana kwana mate yota mukamoka tamo kwana kuvavana-nuvanuva.” ");
INSERT INTO wat_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Tovanama i nusifufukooḡa, maneka i viya eketa matatafusi matasiyai Guyau nenei i viagigikuwa, munifotai yo i gikasimiya eketa i kaniya. ");
INSERT INTO wat_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Namoḡa matatafusi kasi nutoḡona i kanakanakasiya eketa yota si kawa. ");
INSERT INTO wat_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wakai ka toḡa o kama yagwana 276. ");
INSERT INTO wat_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Matatafusi si kawa eketa si kasiyuwa eyo munifotai, witi wakai si vikikinomanisiya eketa si tewesobusobuwisiya gibowai ebe waka ina kanakasiya fasinei. ");
INSERT INTO wat_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Tovanama tova i mayesiya, toviwakasefusefu simuna si kitiya eatu muka sita kitakinaniya. Gunina tamokaḡa si kitiya yota nafena dewadewana eketa nuwanuwasi vitana kabaḡanama nenei waka sita visesenavaneiya. ");
INSERT INTO wat_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Noko uḡuna keta tutuvidauna kasi unava si kitanaonota keta si gavigavivina eatu kafa nunumunikuta si yausiya ebe waka sina numunikutiiya. Naya kabegona naunei si sinanakasiya eketa i dibwanikiya numagama kuweyaina. ");
INSERT INTO wat_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Eatu nai nidebadebana nenei ka tuna. Waka mutuna i fwataoḡona eketa muka ita savivina eatu munina o yoyo nakanakasisi si nubwegabwegiya. ");
INSERT INTO wat_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tonuaviya muka nuwanuwasi finisina sina gayovane numagamai ebe sina dibwana, eketa si viwaifufuna sina nuvimatisiya. ");
INSERT INTO wat_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Eatu kasi kaimatana nuwanuwana Fauno ina gifafafaniya fasinei eketa yasi viwaifufuna i givigoyuya. I visimeya eketa aviyaonana kasi fata gayo sina mikitowa keta sina gayovaneya numagamai. ");
INSERT INTO wat_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Tufotufo i iyavisiya ebe waka i nubwegabwegiya bidimisi yota aviyavana nunugayogayosi nenesiyai sina givikavina. Nofe ketaketanama nenei matatafusi numagamai si vaneya dewadewasi. ");
INSERT INTO wat_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Tovanama matatafuki dewadewaki ka gayovaneya nenei, ka sanamaniya vitana simuna kana wava Manita. ");
INSERT INTO wat_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Simuna namoisi si viyaowikiya venemokena. Bwabwau i vibutuwa sigwana eketa kwadudu na fasinei kai si kasiniya eketa matatafuki si katuvikiya. ");
INSERT INTO wat_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Fauno kai i gigikwakwakwa eketa i kanakanata, etanei i tewetewevanevaneiya eatu mwata tamokaḡa goyona kai kana inainai i vanayaginiya eketa Fauno nimanei i kanaononokeya. ");
INSERT INTO wat_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Simuna namoisi mwata si kitiya eketa tututausi nenesiyai si bwaduwa, “Namoḡa nofe o venemokena tonuvimate eatu muka gibowai ita gavivina fasinei eketa fufuna dawaniniina kana guyau gumayogu si kwabukwabuyuna.” ");
INSERT INTO wat_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Fauno mwata i nukakiya eketa kai i kanasiya, eatu muka ita sinae. ");
INSERT INTO wat_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Namoḡa yasi nuwanuwa vitana tofwana ita safana o sabanutuḡai ita feku matematena. Eatu si kitanufotawayosa eketa yasi vinuwadadana si giviniya vitana Fauno tanake tamo guyau. ");
INSERT INTO wat_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Simuna kana kawakawa kana wava Fubiniusi, yana fwayafwaya keta yana numa niniunei i nuvaneikiya. Tanake i katuvikiya eketa kuyadayada tonusi yana numai i kitavikavinikiya. ");
INSERT INTO wat_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tovanama ka sanamaniya Fubiniusi amana tofwana i nunuinaina yota bwenibweni i toḡatoḡateweteweiya, Fauno i kanasuna nenei keta kawanunuku muninei nimana i dawana tofwanei eketa i givibwiniya. ");
INSERT INTO wat_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tovanama namoḡa si kitiya, tovisafwavinaḡa matatafusi si nemiya Fauno nenei eketa i givibwinisiya. ");
INSERT INTO wat_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","11","Manita namoisi nukusi ka fakwa yamayamana tonusi, si kitavikavinikiya venemokena. Tovanama yama noḡokawawa nenei, kama nuwagabubu si kavenena yota kama ke'ta fasinei si ovivitikiya eketa fiyao Anekisenidiya yasi wakai ka toḡa. Wakanama kana nagimu nenei, kifukifufuna si vigionisiya yasi guyau natuyuweyuwe, Kasita eketa Fonakisi kasi fusa maise. Nokomai i fakwa kana nivaniva yauya kana tutuya i kakaviya yo munifotai ka kanayauwa. ");
INSERT INTO wat_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ka vinaya ka niya Sainakasa menana nenei keta nokomai ka fakwa kuyadayada tonusi. ");
INSERT INTO wat_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Eyo ka niya Negiumi menana nenei. Nuwabuni gagasa i siveya eketa ka venunumasana kana nivaniva menana Futeoni nenei ka kanasuna. ");
INSERT INTO wat_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tovitumaḡana tunisi nokomai ka nisaisiya eketa si vikokonikiya fasinei, nokomai ka fakwa wiki tamokaḡa. Eketa nokomai kavananei ka niya Noma. ");
INSERT INTO wat_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Tovitumaḡana Noma sinenei fasikiyai si biganowana eketa si nemiya si venufotifotikiya. Tunisi o Afiusi kafa vivitamaneina nenei eatu tunisi o kabaḡa kana wava Numa Wagawaga Tonusi nenei si nemiya eketa si toḡatoḡafotikiya. Noko tovanama nenei, kasi kitaḡa nenei Fauno i katevatuwa eketa Guyau i davadaviya. ");
INSERT INTO wat_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tovanama ka kikinomana Noma menana nakasina nenei, Noma toviketanuneina Fauno si sawateweiya ebe kana kisina ina fakwa. Eatu tonuaviya tamokaḡa si teniya kana toḡatana. ");
INSERT INTO wat_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kuyadayada tonusi muninei Fauno Fiyao Diu toviketanuneina i wenevakukusisiya eketa si yokowa. Fauno i iyavisiya i bwaduwa, “Unaunaku, muka tamo goyona ata fufuniya yata sabu nenesiyai o taki waḡawaḡata yasi visime ata yakweniya. Eatu Yenusanema sinenei si givikavinikuwa eketa Noma namoisi nimasiyai si tenikuwa. ");
INSERT INTO wat_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Noma namoisi si nutoninuvenuvikuwa eatu muka tamo yaku goyona sita nisaḡai be yo sita nuvimateiku. Na fasinei nuwanuwasi sita gionovikuwa, ");
INSERT INTO wat_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","eatu Fiyao Diu muka nuwanuwanama sita sebobowei. Na fasinei Noma namoisi a iyavisiya vitana tufomu Sisa naunei ata misiniya ebe ita vinuesanikuwa, eatu muka vitana tauku yaku sabu ata vivinoimi fasinei. ");
INSERT INTO wat_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nofe ibasima fasisiyai a wenimiya ebe nukusi tana nusifufuwa. Kita Fiyao Diu kata Togifafafana Gigibokeinana nenei a vitumaḡana. Nofe namoinama fasinei Guyau manatuwaina i bwadudabadaba vitana ita visimeiya kita Fiyao Diu nenetiyai. Nofe uḡunanama fasinei seni nenesiyai si yonikuwa.” ");
INSERT INTO wat_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Si nufata si bwaduwa, “Muka tamo nufunufu fasiweu Yudiyei kata nisaḡai, yota aviyaonana unaunata si nenemiya nofemai tamo sifufu goyona sita bwaduwei fasiweu. ");
INSERT INTO wat_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Eatu ka sanamaniya o kabaḡa tunisitunisi nenesiyai kwami tovitumaḡana yokomima si sawasawanovimiya. Na fasinei nuwanuwaki ya nuwanuwa kata sanamaniya.” ");
INSERT INTO wat_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Eketa kuyadayada tamokaḡa si vinuwadadaniya nenei namoḡa yagwanisi si nemiya yana kabaḡai. Fauno i visawavenena Guyau yana kafa visime fasinei. Nuwabuni i vibutuwa eketa i niiya kana nivaniva i nuwabuna. Mosese yana visime eketa Guyau yana tomatakawa yasi viginiwa nenesiyai i misinivikavina. Nuwanuwana Yeisu fasinei nuwatasi ina kaniya be sina vitumaḡaniya. ");
INSERT INTO wat_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Tunisi namoḡa Fauno yana nusifufu nuwatasi i oviya eketa si vitumaḡana, eatu tunisi o muka. ");
INSERT INTO wat_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Na nenei tututausi sinesiyai amanamanagibu nakasina eatu muniyai yo sita kafiyauyauna, Fauno yana bwadu kafa nusafu i venisiya i bwaduwa, “Kanunu Tafutafuna bwadu kana venemokena nenei tomatakawa Aiseya i veniya eketa waḡawaḡami i nusifufuwisiya i bwaduwa. ");
INSERT INTO wat_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kuna niya tauḡu ya sabu Isineni nenesiyai eketa kuna iyavisiya kuna bwaduwa, “Naki kwa vanevaneneḡa eatu muka nuwatami ita mayemayesiya. Naki kwa tonetoneya eketa ibasima Guyau i fufufunisiya kwa kitikitisiya, eatu kasi nuwanuwa muka nuwatami ita mayemayesiya. ");
INSERT INTO wat_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Nofe namoisima muka nuwatasi ita mayemayesiya uḡuna katekatesi i fakina. Na taniyasi eatu avana si vanevaneneiya o muka sita nowanowaniya, matasi si kinoḡowa uḡuna muka nuwanuwasi sina kita. Taki nuwanuwasi fonaku sina muniiya, nao matasiyai sina kitikuwa eketa taniyasiyai sina vaneneikuwa, yota nuwatasi ina mayesiya ebe kamo sina ugevinisiya yasi fufunagoyo nenesiyai ebe ana givibwinisiya.”’ ");
INSERT INTO wat_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kwami Fiyao Diu o muka bwadu kana venemokena kwata vanevaneneḡei, na fasinei nuwanuwaku kwana sanamaniya vitana Guyau yana gifafafana kana matakawa, naki i vininitiya Kani Kwauna nenesiyai ebe tasike sina vaneneḡa.” ");
INSERT INTO wat_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Fauno yana numa si veniya eketa i fatafatiya, eatu nokomai manamana nuwesi i fakwiiya. Namoḡa matatafusi i katukatuvisiya tovanama si nenemiya kana venufota fasinei. ");
INSERT INTO wat_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Na yana katevatu eketa katekatena matatafunei biga dewadewana i nunumamaniya Guyau yana kafa visime, yota Tuveka Yeisu Togifafafana Gigibokeinana fasinei i vivisawavenena, eatu muka tamo kana sawatana. ");
ALTER TABLE wat_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
