﻿USE sofia;
DROP TABLE IF EXISTS sofia.wapNT_vpl;
CREATE TABLE wapNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wapNT_vpl WRITE;
INSERT INTO wapNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Diꞌoraz kuwai idaꞌa kakuwaapa-karu Jesus Christ dokozu-daunnao sakadinan ikiꞌo dauꞌanaꞌo. Jesus Christ, uruu King David takaan-daun, naꞌiki David, uruu Abraham takaan-daun. ");
INSERT INTO wapNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Diꞌi naa ĩꞌuu kida sakadinanuꞌu Abraham diꞌikiꞌo atii King David idaꞌati: Abraham dani uu Isaac; Isaac dani uu Jacob; Jacob dani uu Judah naꞌiki kainaꞌa baꞌoran uꞌinawuzunao; ");
INSERT INTO wapNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah dainao uu Perez naꞌiki Zerah (ĩdaro uu Tamar); Perez dani uu Hezron; Hezron dani uu Ram; ");
INSERT INTO wapNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram dani uu Amminadab; Amminadab dani uu Nahshon; Nahshon dani uu Salmon; ");
INSERT INTO wapNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon dani uu Boaz (Boaz daro uu Rahab); Boaz dani uu Obed (Obed daro uu Ruth); Obed dani uu Jesse; ");
INSERT INTO wapNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse dani uu King David. Aizii diꞌi Jesus Christ dokozu-daunnao dauꞌanaꞌo King David diꞌikiꞌo, atii patarubanao naꞌakan idaꞌati Israelitenao pawiizi iki Babylon iti: David dani uu Solomon (Solomon daro Uriah daiaro-daun); ");
INSERT INTO wapNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon dani uu Rehoboam; Rehoboam dani uu Abijah; Abijah dani uu Asa; ");
INSERT INTO wapNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa dani uu Jehoshaphat; Jehoshaphat dani uu Jehoram; Jehoram dani uu Uzziah; ");
INSERT INTO wapNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah dani uu Jotham; Jotham dani uu Ahaz; Ahaz dani uu Hezekiah; ");
INSERT INTO wapNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah dani uu Manasseh; Manasseh dani uu Amon; Amon dani uu Josiah; ");
INSERT INTO wapNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah dani uu Jehoiachin naꞌiki kainaꞌa baꞌoran uꞌinawuzunao. ");
INSERT INTO wapNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aizii patarubanao naꞌakan daunaꞌanaꞌo Israelitenao Babylon iti atii Jesus Christ idaꞌatiꞌi dauꞌanaꞌo: Jehoiachin dani uu Shealtiel; Shealtiel dani uu Zerubbabel; ");
INSERT INTO wapNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel dani uu Abiud; Abiud dani uu Eliakim; Eliakim dani uu Azor; ");
INSERT INTO wapNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor dani uu Zadok; Zadok dani uu Achim; Achim dani uu Eliud; ");
INSERT INTO wapNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud dani uu Eleazar; Eleazar dani uu Matthan; Matthan dani uu Jacob; ");
INSERT INTO wapNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob dani uu Joseph, uruu Mary daiaruz; Mary dani uu Jesus, Jesus uruu wuruꞌu dakota-kariwaiz Christ nii. ");
INSERT INTO wapNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ukauꞌan 14 ĩtonazinaa aitinpan Abraham diꞌikiꞌo atii David idaꞌati. Naꞌapa uaitinpan iriban koshan 14 David diꞌikiꞌo atii ĩtarubanao naꞌakan donoꞌo idaꞌatiꞌi ĩdyaun Babylon iti; naꞌiki naꞌapa uaitinpan ĩiriban koshan ĩtarubanao naꞌakan daunaꞌan ĩdyaun Babylon iti atii Christ idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kaikapaꞌo daꞌi Jesus Christ shakatauzonuꞌu. Jesus daro Mary, Joseph taapaniꞌi naa pazaamatan niꞌo paudaiaro nii. Mazan ĩzaamataakan uaꞌii, Mary kaudanin naa. Wuruꞌu okaudaninuz Kaimanaꞌo Doronaa idaꞌanaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aizii Joseph kaimanaꞌo pidan uruu, ukauꞌan aonaa ubaꞌazootin-kidaꞌazon Mary iribaꞌo pidan bii ii, udiꞌitinpan paꞌidaꞌa sodi naꞌapam nii pamarinaꞌatan pamazidaꞌazon otuma. ");
INSERT INTO wapNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Joseph daꞌawuꞌukan padiꞌitinpan puꞌu tuukii. Sariapa Tominkaru diꞌikiꞌo angel kaawan uꞌidaꞌati uzandaꞌawun ii. Naꞌiki ukian uꞌati, “Joseph, King David takaan-daun, aonaa putariaꞌanaꞌa pumazidan Mary tuma. Aonaa naꞌapaꞌoram idaꞌanaꞌo mani karikaonan wuruꞌu okaudaninuz, mazan Kaimanaꞌo Doronaa maꞌozakan idaꞌanaꞌo wuruꞌu okaudaninuz. ");
INSERT INTO wapNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Okaudanipan an, daonaioraꞌo nii odani nii. Naꞌiki Jesus kii paꞌi pudakota uꞌuu, ushaꞌapanum kauꞌan ukazannaatan nii papidanannao ĩꞌoian ai,” ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aizii wuruꞌu naꞌapaꞌoraz shaꞌapan, Tominkaru Paradan mishiinan ukianuz paprophetin idaꞌan: ");
INSERT INTO wapNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kainaꞌaꞌo nii baudaꞌapa paꞌinaꞌo zun, aonaꞌo zii okiitauzo-kao kaudanin nii daonaiora idi. Uruu Immanuel kii-karu nii udauꞌan, watumaꞌo Tominkaru kiaꞌo wuruꞌu kii-karuz.” ");
INSERT INTO wapNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph pokodaꞌakan, sariapa umishidan Tominkaru diꞌikiꞌo angel paradan paꞌati. Uruu idi umazidan Mary tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mazan aonaa naꞌapainim ukiaapauzon Mary, atii naꞌapa okaudanipan. Joseph kaꞌuutan naa wuruꞌu koraidaonaaz Jesus kii. ");
INSERT INTO wapNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aizii Jesus shakatan dono Bethlehem ii, Judea Baara iaꞌoraz, naꞌapain Herod king nii naꞌii. Uruu dono munapoꞌo waoko ikiꞌo pidannao kaawan Jerusalem ati. Wuruꞌu ĩnaouz diꞌitapauzonao wizi. ");
INSERT INTO wapNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Sariapa ĩpishaan naꞌii sannao, ĩkian, “Naꞌiam dii koraidaonaa shakatan king niꞌoraz Jewnao ati? Watukapa ukainaaribinaa wizi aidinan waoko iki. Uruu idiꞌo wawaꞌatin wakodoruꞌukaꞌanan uꞌati unaobanain idi.” ");
INSERT INTO wapNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aizii King Herod abata wuruꞌu ĩpishaanuz pidannao naꞌapa, aonaa unaudapanuz, tuukii utoꞌoraꞌakan. Aizii Jerusalem sannao naꞌapa kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ukauꞌan King Herod baokopatan faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu. Naꞌiaꞌa naa upishaan ĩdyaun, “Naꞌiam nii dii wuruꞌu naobanai niꞌoraz shakatan, Christ kii-kizaiz?” ");
INSERT INTO wapNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Bethlehem ii, Judea Baara iaꞌoraz,” ĩkian uꞌati. “Naꞌapa Tominkaru dyuudan paprophetin saadan udauꞌan. Kaikapaꞌa ukianuꞌu: ");
INSERT INTO wapNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Pugaru Bethlehem, Judah Baara iaꞌoraz, umanawunuꞌo nii, baꞌoran wiizainao naꞌan kidaꞌo ai. Ushaꞌapanum idi puꞌidiꞌikiꞌo nii naobanai niꞌo tominan. Uruu taapaꞌo nii naꞌiki naꞌakapaꞌo nii kaimanaꞌo idaꞌan õpidanannao Israelitenaouz kaznizo taapiki kawan.’” ");
INSERT INTO wapNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sariapa King Herod dapada-kidan wuruꞌu tawarainao aitapaabainaouz. Aonaa uaitapa-kao ukadakoinpan ĩtuma. Paꞌidiwaru sodi upishautan ĩdyaun, naꞌapaꞌoram naa ukotuꞌan ĩtukapan wuruꞌu wizi aidinan, naobanai shakatan kainaaribanaaz. Ukauꞌan ĩkowaada uꞌatiz. ");
INSERT INTO wapNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Udaunaꞌan udyuudan naa ĩdyaun Bethlehem iti. Ukian ĩꞌati, “Udorotankaꞌa naa wuruꞌu koraidaonaaz. Aizii uikodan donozu, ukowaada paꞌi õꞌati, õmakonaka kizi õkodoruꞌuka kizi uꞌati kapam unaobanain idi.” ");
INSERT INTO wapNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Paabatapaꞌakan daunaꞌan, naꞌapam King Herod kian paꞌati, ĩdobatan naa. Sariapa wuruꞌu ĩtukapauzoniaz wizi aidinan naa ĩꞌati koshan. Uruu idi ukauꞌan ĩkonaukian tuukii. Naꞌiki wuruꞌu wizi makon ĩꞌuaꞌati atii umashaadinan dokoꞌo koraidaonaa mashaapa-kizi kabaun paꞌinamun. ");
INSERT INTO wapNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ĩkaawan kabaun idaꞌati, naꞌiki ĩmorotaꞌakan naa. Uruꞌu naa ĩtukapan naꞌii wuruꞌu koraidaonaaz, padaro Mary tuma. Sariapa ĩkodoruꞌukan ukanaapu ati unaobanain idi. Udaunaꞌan ĩsoꞌotaꞌakan naa panaꞌakapanii kida, gold naꞌiki frankincense naꞌiki myrrh, ĩtaan kidaz mawinipinaa-daun uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Udaunaꞌan ĩkiwan panaꞌanaꞌa naa pawaꞌati-kizi ai, aonaa ĩmakouaꞌakan King Herod idaꞌan. Ĩshaꞌapainapanuz kaikapaꞌa Tominkaru kakinaowan idiꞌo pazandaꞌawun ii ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tawarainao kiwaꞌakan daunaꞌan, Tominkaru dyuudan angel kakuwaapaꞌanan Joseph ati uzandaꞌawun ii. Ukian uꞌati, “Pumako kai, punaꞌaka wuruꞌu koraidaonaaz padaro tuma, pukidoapa-kida ĩdyaun Egypt iti. Ushaꞌapanum kauꞌan Herod dorotapa-kidaꞌazon naa wuruꞌu koraidaonaaz naꞌiki uzowii-kidaꞌazoonuz. Punaꞌii paꞌi atii õdapada-kidan an zii pugaru powaa ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph pokodaꞌakan, unaꞌakan naa wuruꞌu koraidaonaaz padaro tuma Egypt iti. ");
INSERT INTO wapNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Naꞌii ĩmashaapan atii Herod mawakan. Wuruꞌu naꞌapaꞌoraz shaꞌapan Tominkaru Paradan mishiinan, ukianuz paprophetin idaꞌan: “Õdapadan õDani Egypt iki.” ");
INSERT INTO wapNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aizii Herod aitapankan naa naꞌapam tawarainao, waoko ikiinaouz mariidan paugaru, ĩmakiwakan idi powaa an paꞌidaꞌan, tuukii utoꞌoran. Uruu idi udyuudan pasoldyaannao zowian ipai daonaioranao sodi kida dyaꞌutam wunu kidainao naꞌiki awutapainao ĩwunun kida, ipai Bethlehem iainao naꞌiki maonapa kidaꞌo ĩmashaapan. Ushaꞌapainpan kaikapaꞌa, ushaꞌapanum kauꞌan aitapaabainao tawarainao waoko ikiinaouz kowaadan kawanaꞌatiꞌo naꞌapam ukotuꞌan naa ĩtukapan wuruꞌu wizi aidinanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wuru idaꞌanaꞌa Tominkaru Paradan mishiinan prophet Jeremiah kiauzonuz. ");
INSERT INTO wapNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramah ii, pidannao waꞌidan abata-kao, ĩzaadinan naꞌiki ĩmuraapan diiwaꞌo idaꞌan. Rachel zaadinan paudainao dauꞌan, aonaa omishidauan pamashaata-kao paudainao mawakan idi.” ");
INSERT INTO wapNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aizii King Herod mawakan daunaꞌan, Tominkaru diꞌikiꞌo angel aidinan Joseph ati uzandaꞌawun ii, Egypt ii. ");
INSERT INTO wapNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Angel kian uꞌati, “Mawakaꞌa naa aizii zowiaꞌazoinaouz wuruꞌu koraidaonaaz. Ukauꞌan punaꞌakaꞌa naazu padaro tuma powaa iti Israel iti.” ");
INSERT INTO wapNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joseph pokodaꞌakan, unaꞌakan naa ĩdyaun powaa iti Israel iti. ");
INSERT INTO wapNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mazan Joseph abatan idi King Herod dani Archelaus naobanai nii Judea Baara ii, ukauꞌan utarii pamakon naꞌiti. Mazan uzandaꞌawun ii Tominkaru kakinaowanuz, uruu idi ĩmakon Galilee Baara iti, ");
INSERT INTO wapNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","naꞌiaꞌa naa ukauꞌan ĩmashaapan wiizai Nazareth ii. Wuruꞌu naꞌapaꞌoraz shaꞌapan Tominkaru Paradan mishiinan ukianuz paprophetin idaꞌan: “Udakota-kao nii Nazareth san.” ");
INSERT INTO wapNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kotuaꞌiki uruu daunaꞌan John Chikaawunuupauzo sakadan pakaudinan pakakinaopan dauꞌu mapidantakaꞌo amazada ii aka, Judea Baara iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kaikapaꞌa ukakinaopauzonuꞌo: “Utanawatinaꞌa naa uꞌoian ai, ushaꞌapanum kauꞌan ataꞌazoo Tominkaru Naobanai-tinan pidannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uruu John dauꞌatiꞌo, tawaruꞌu kotuaꞌoraz Tominkaru prophetin Isaiah saadanuz. Ukianuz. “Pidan kadakoinpan diiwa mapidantakaꞌo amazada ii aka. ‘Usaabaꞌa naa naobanai mako kizi nii, utoma uaꞌii sakitapaꞌo uponaa nii.’” ");
INSERT INTO wapNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John kamichan toma-kao camel idi idiꞌo, ukazadawutinpan wuzada-kariwai madai idiꞌo, naꞌiki uwanyukunuu nii manorunao naꞌiki maaba. ");
INSERT INTO wapNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iriba pidannao waꞌatin John idaꞌati ĩabataꞌanan ukakuwaapan. Jerusalem, Judea Baaraꞌaꞌoraz donoi iki, naꞌiki ipai baꞌoran wiizai kida Judea Baaraꞌaꞌoraz diꞌiki, naꞌiki Jordan Waꞌo zaꞌanainao ĩmashaapan kida kaawan uꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ĩkowaadan paꞌoian kida, uruu idi John chikaawunuuan ĩdyaun Jordan Waꞌo ii. ");
INSERT INTO wapNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Iriba Jewnao, ĩdakota-kao Phariseenao naꞌiki Sadduceenao kaawan John chikaawunuuapa-kizi ati. John tukapan ĩdyaun naꞌii, sariapa ukian ĩꞌati, “Unao kowazaznao! Kanom kowaada uꞌati turuu ukazannaatinan Tominkaru patakaꞌutaꞌazon ai unao? ");
INSERT INTO wapNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ushaꞌapataꞌa naa kaiman kidaꞌo aimaakan, uaida kizi mishi utanawatinaꞌa uꞌoian ai. ");
INSERT INTO wapNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aonaa uzauda-kidaꞌanaꞌa unao Abraham takaan-daunnaoun idaꞌanaꞌo nii mani ukazannaatinan uꞌoian ai. Õkowaadan nii uꞌati aizii, turuu Tominkaru toman Abraham takaan-daunnao nii diꞌoraz kuba kida idiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kainaꞌa baro, minziiwapaꞌoraꞌa naa barotaꞌo nii atamun kida. Ipai atamun wuruꞌu aonaꞌoraz ukaakan kaiman naꞌiki wuruꞌu dikauda kidaꞌoraz uꞌaka kida, ipaiꞌo nii ubarota-kao, udaunaꞌan ukaboota-kao nii ipai tikazi wuꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Udaunaꞌan John kian pidannao ati, “Õchikaawunuupan unao wunu idi utanawatinan dikin ii uꞌoian ai Tominkaru idaꞌati, mazan wuru daunaꞌanaꞌa, kainiꞌikiꞌo nii chikaawunuupaꞌo nii unao tikazi idi naꞌiki Kaimanaꞌo Doronaa idi paꞌan. Uruu kainaꞌiki uruu powaꞌaꞌo zii umanawunun õꞌai, aonaa õkaꞌiitan ukaudin-kizi. Upuꞌu zii aonaa õturuan õnaꞌakan udazkidi uꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kainaꞌaꞌa naa unaꞌakapan pawidauapa-kinaa papaoriba aka kida. Ipaiꞌo nii uwidauan kaiman kidaꞌo papaoriba aka, naꞌapa zaishi widau-kao kawan pamada ai. Udaunaꞌan usaabaa-kao niꞌi naa kaiman padapunaa iti. Mazan wuruꞌu dikauda kidaꞌoraz, ipaiꞌo nii paꞌan ukaboota-kao tikazi aonaꞌo umakadauzon wuꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Uruu dono Jesus kaawan Galilee Baara iki Jordan Waꞌo ati, uchikaawunuu-kidinaꞌanan John ati. ");
INSERT INTO wapNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mazan aonaa John kaꞌiitan paabatan pashaꞌapatan naꞌapaꞌo uꞌati, ukauꞌan utiwaan papanaꞌadan Jesus nyukunuu. Ukian uꞌati, “Kanom nii puchikaawunuu-kidinaꞌazon õꞌati? Õgaru mishiꞌoraiman turuu puchikaawunuuan.” ");
INSERT INTO wapNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mazan Jesus kian uꞌati, “Naꞌapaꞌo niꞌi naa paꞌan aizii washaꞌapatinan, ushaꞌapanum kauꞌan washaꞌapatinaꞌazon ipai Tominkaru aipan kawanaꞌati.” Uruu zii John naꞌapatan panyukunuu. ");
INSERT INTO wapNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus koditaꞌakan daunaꞌan wunu diꞌiki pachikaawunuu-kao dono, sariapa aokazi daꞌata-kao uꞌati, naꞌiki utukapa Tominkaru Doronaa waꞌatin orid kawan, aokazi ikinapu. Taau, upakotan uꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mashaꞌapakiaka parada-karu aokazi ikiꞌo kian, “Diꞌi õDaniꞌi, õmarainapanii manawun, shaꞌapatinaꞌo õnyukunuu kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Uruu daunaꞌan Kaimanaꞌo Doronaa naꞌakan Jesus mapidantakaꞌo amazada diꞌiti, Satan tiwaa-kidapa kizi uruu naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aonaa kanom Jesus nikan 40 kamoo, ukauꞌan tuukii uzamazin. ");
INSERT INTO wapNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Uruꞌu naa Satan kaawan Jesus idaꞌati. Sariapa ukian uꞌati, “Tominkaru Danin an pugaru, pudyuuda diꞌoraz kuba kida tominan bread nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mazan Jesus kian uꞌati, “Tominkaru Paradan saada-kariwaiz kian, ‘Aonaa pidan mashaapan soo bread idaꞌan mani karikaonan. Mazan aiapa-karu nii Tominkaru diꞌikiꞌoraz parada-karu mashaapa-kinai nii.’” ");
INSERT INTO wapNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Udaunaꞌan Satan naꞌakan Jesus Jerusalem kaimanaꞌoraz wiizai iti. Ukadishita-kidanuz dokoaꞌo Tominkaru Dapu dokoo-dinpan paawa ii manawun, ");
INSERT INTO wapNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","naꞌiki ukian uꞌati, “Tominkaru Danin an pugaru, puzakaꞌuta diꞌikiꞌi imiꞌi baara iti. Ushaꞌapanum kauꞌan Tominkaru Paradan saadinpaꞌoraz kian, ‘Tominkaru awunuutapa-kidan nii pugaru paꞌangelinnao ati, ĩzaamatapan nii pugaru, aonaꞌo nii pukaziwan pukidiba puwaotan an kuba kida diꞌiti.’” ");
INSERT INTO wapNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus kian uꞌati, “Mazan kaikapaꞌo shaꞌatii Tominkaru Paradan saadinpaꞌo kian kapam, ‘Manaꞌa putiwaa-kidapauzoꞌonaꞌa uNaobanaa Tominkaru.’” ");
INSERT INTO wapNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Udaunaꞌan Satan naꞌakan Jesus dokoaꞌo midukuo paawa iti, naꞌiki uaida-kida Jesus ati ipai umanawun naꞌiki konaunam kidaꞌo donoi, ipai amazada tokon iti. ");
INSERT INTO wapNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ukian Jesus ati, “Ipaiꞌo nii õtaan puꞌati wuru kidaꞌa putaainan an õꞌati pukodoruꞌukan idaꞌan õkanaapu ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sariapa Jesus kian uꞌati, “Pumako õꞌai, Satan! Tominkaru Paradan saadauzo-kariwaiz kian, ‘Pukodoruꞌuka soo baudaꞌapaꞌo Naobanai puTominkarun ati. Pushaꞌapatin soo uruu aipan kawanaꞌati.’” ");
INSERT INTO wapNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Uruu daunaꞌan Satan marinaꞌataꞌakan naa Jesus. Uruꞌu naa angelnao kaawan uꞌidaꞌati ĩkaminkaꞌutan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus abatan daunaꞌan John taraa-kao, uruꞌu naa umakon powaa iti Galilee Baara itinapu, Nazareth iti. ");
INSERT INTO wapNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mazan naꞌikiꞌo umakon umashaapaꞌanan Capernaum iti, wiizai maonapaꞌo Galilee Karishiiz ati. Naꞌanaꞌoraz Zebulun naꞌiki Naphtali takaan-daunnao wiizi baara an kidaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aimaakan shaꞌapanuz naꞌapa, parada-karu mishiinan naa tawuruꞌu prophet Isaiah kianuz pakaaritan idaꞌa: ");
INSERT INTO wapNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Pidannao mashaapainao Zebulun amazadati an, naꞌiki Naphtali amazadati an, naꞌiki dobaapa-kizai karishii an, atii tarauka Jordan Waꞌo, Galilee an kidaꞌo Gentilenao mashaapan. Puabata! ");
INSERT INTO wapNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Puabata pidannao mashaapainao naꞌiiꞌaka marutaꞌo biiꞌi, ĩtukapan nii umanawunuꞌo kanadaꞌo. Mashaapainao naꞌan kichanaꞌiki-kiaꞌo marutaꞌo bii ii, kanada-karu kanadapan nii ĩdyaun.” ");
INSERT INTO wapNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Naꞌapainiꞌi naa Jesus sakadan pakakuwaapan. Ukian, “Utanawatin uꞌoian ai, ushaꞌapanum kauꞌan ataꞌazoo Tominkaru naobanai-tinan pidannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus makopan puꞌu maonapa Galilee Karishiiz danomata, utukapa dyaꞌutam kopautapauzonao, Simon, uruu Peter kiaꞌo udakotapa-kao, naꞌiki uꞌinawuzu Andrew. Ĩzaamaapan kopau karishii ii pasairon idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus kian ĩꞌati, “Uwaꞌati õtuma, õtominapa-kida kizi unao, uzaamaapan dauꞌu pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sariapa ĩwaꞌakaꞌakan pasairon kida, naꞌiki ĩdaꞌanan naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Naꞌikiꞌo udobataꞌakan, utukapa dyaꞌutam pidannao koshan kanawa idaꞌa. Wuruꞌu ĩnaouz Zebedee dainao, James naꞌiki John. Ĩdaru Zebedee naꞌiaꞌo ĩtuma kapam, ĩminziiwatin-kidan pasairon kida. Jesus dapadan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sariapa ĩmakon Jesus tuma, ĩwaꞌakaꞌakan naa padaru pakanawan diꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus makon ipai Galilee Baara an kidaꞌo wiizai kawanaꞌati. Utominapa-kidan pidannao synagogue kida kawanaꞌati. Ukowaadapan Kaimanaꞌo Kuwai Tominkaru naobanai-tinan dauꞌu, naꞌiki ukakuda pidannao karinaapainao ipai pabiꞌinaaka kidaꞌo rinai idi. ");
INSERT INTO wapNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Uunamunaa abata-kao ipai Syria Baara ii aka. Uruu idi naꞌikinpuinao pidannao naꞌakan pairibannao karinainao pabiꞌinaakaꞌo ĩrinaa kida: kaziwainao, oiaꞌo doronai morotinniinao, mawakaziitapainao, naꞌiki machiꞌika-kainao; ipai Jesus kakudan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iriba pidannao daꞌananuzu Galilee Baara ikiinao, naꞌiki Decapolis Baara ikiinao, Jerusalem ikiinao, Judea Baara ikiinao, naꞌiki Jordon-waꞌo baza ikiinao. ");
INSERT INTO wapNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aizii Jesus tukapan iriba pidannao kasabaꞌukinan paꞌidaꞌati, sariapa uzaidan naawazi daara iti. Naꞌiaꞌa naa usakanatan. Pidannao, utominapa-kidaniinaouz maonapadinan uꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Usakadaꞌakan naa patominapa-kidan ĩdyaun. Kaikapaꞌa ukian ĩꞌatiꞌi: ");
INSERT INTO wapNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Konaukiaꞌo wunaouꞌu aitapainaouz aonaꞌo paturuan paaipan ati padoronaa ii, ĩnao kaduz atiꞌo wuruꞌu Tominkaru naobanai-tinapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Konaukiaꞌo wunaouꞌu kashaꞌoratinainaouz ĩnyukunuu, Tominkaru saabaan nii ĩnyukunuu. ");
INSERT INTO wapNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Konaukiaꞌo wunaouꞌu aonaꞌoraz ĩatadinpauzon, Tominkaru taan nii ipai imiꞌi baara ĩꞌidiwau nii. ");
INSERT INTO wapNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Konaukiaꞌo wunaouꞌu tuukiaꞌoraz ĩtaan panyukunuu ati pashaꞌapataꞌazon Tominkaru aiapanii kida ushaꞌapata-kao, Tominkaru turuuda-kidan nii ĩdyaun kaimanaiman. ");
INSERT INTO wapNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Konaukiaꞌo wunaouꞌu kamunanbainaouz, Tominkaru kamunanun nii ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Konaukiaꞌo wunaouꞌu baudaꞌapatainaouz panyukunuu Tominkaru ati, ĩtukapan nii Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Konaukiaꞌo wunaouꞌu kaudinainaouz pakaimanaaka-kidan dauꞌu pidannao, Tominkaru daniitan nii ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Konaukiaꞌo wunaouꞌu patakaꞌuta-kariwainaouz kaimanaꞌo mashaapa-karu Tominkaru atiꞌo dauꞌan, ĩnao atiꞌo nii wuruꞌu Tominkaru naobanai-tinapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Konaukiaꞌo nii unao, pidannao dakoopan an unao, naꞌiki ĩpatakaꞌutan an unao, naꞌiki ĩmariidinan an unao dauꞌu, soo õpidanannaoun idiꞌo unao. ");
INSERT INTO wapNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ukonaukii tuukii manawun, ushaꞌapanum kauꞌan kainaꞌa umanawunuꞌu uwinipinaa niꞌo aokazi ii. Kotuaꞌa naa naꞌapaꞌo Tominkaru prophetinnao patakaꞌutauzo-kao kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Duwu kawanuꞌo wuruꞌu unaouz daꞌaꞌa pidannao ati. Mazan duwu manaun anaꞌa naa, aonaꞌa naa naꞌapam ukuzuban powaꞌa. Aonaꞌa naa turuu ukaiwaapa-kao, mazan ukabootaꞌaka-kao niꞌi naa amazada iti. Uruꞌu naa dobaapainao naꞌiiꞌaka dakazatanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kanadaꞌo kawanuꞌo wuruꞌu unaouz daꞌaꞌa pidannao ati. Aonaa naawazi paawaꞌaꞌo donoi toma-kao dizinpan. ");
INSERT INTO wapNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aonaa naꞌiam zii pidan suuauzon lamp, udaunaꞌan utaratanuzu boon waranuꞌu. Mishiꞌoraiman lamp muuda-kao nii kaimanaꞌo pawiizi dokoaꞌo idaꞌa. Naꞌikiꞌo nii ukanadapan ipai kabaun nazo ainao. ");
INSERT INTO wapNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Naꞌapa paꞌi unao lamp kawan, upuꞌukapan kanada pidannao kanaapu ati, ĩtukapa kizi kaimanaꞌo ushaꞌapatanii. Uruu naꞌapaꞌo idaꞌanaꞌo nii ĩkonaukii-kidan uDaru Tominkaru aokazi iaꞌo umanawunun. ");
INSERT INTO wapNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Aonaa uzauda-kidaꞌanaꞌa, õmarinaꞌata-kidaꞌanan mani kakinaorii Tominkaru taaniaz Moses idaꞌan kida, naꞌiki kotuaꞌo prophetnao saadanii kida, wuruꞌu õwaꞌatinuz daꞌatiꞌi. Õwaꞌatin aonaa õmarinaꞌata-kidaꞌanan mani ĩdyaun, mazan õmishiaꞌanan naa naꞌiki õshaꞌapataꞌanan naa naꞌapaꞌoram ĩkian kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Õkakuwaapan mishiꞌo uꞌati, atii aokazi naꞌiki diꞌoraꞌa imiꞌi baara naꞌan kawanaꞌati, aonaꞌo nii baudaꞌapa kakinaorii paradannaa sodi marinaꞌata-kao, atii kaiman-daun kakinaorii mishiinan. ");
INSERT INTO wapNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ukauꞌan kanom dikintapan an masakaudaꞌu sodiꞌo kakinaorii paradannaa, naꞌiki tominapa-kidaꞌo naꞌapa baokoinao, awutapa sodiꞌo nii umanawunun, Tominkaru naobanai-tinan diꞌii. Mazan kanom izoꞌatiꞌo, shaꞌapatatinaꞌo kakinaorii kawanaꞌati, naꞌiki tominapa-kidaꞌo naꞌapa baokoinao kapam, umanawunuꞌo kii-karu nii udauꞌan, Tominkaru naobanai-tinan diꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ukauꞌan õkian nii uꞌati, aonaꞌo nii umorotan Tominkaru naobanai-tinan diꞌiti, soo umashaapan an kaiman Tominkaru aipan kawanaꞌati powaꞌa zii wunao aiaꞌa, tiichaapauzonao Moses kakinaori dauꞌu naꞌiki Phariseenao ai.” ");
INSERT INTO wapNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesus kian koshan, “Uaitapanii shaꞌatii naꞌapam kiauzo-karu pidannao ati kotuaꞌa naa, ‘Manaꞌa puzowiaꞌanaꞌa pidan. Naꞌiaꞌoram pidan zowiaꞌo pidan, patakaꞌuta-karu niizu udikin ii.’ ");
INSERT INTO wapNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mazan aizii õkian nii uꞌati, naꞌiaꞌoram pidan toꞌoran an paꞌinawuzu ati, patakaꞌuta-karu niizu udikin ii. Naꞌiaꞌoram pidan kiaꞌo paꞌinawuzu ati ‘pugaru maturuaukaꞌo,’ naꞌaka-karu niizu kazowautapainao kanaapu ati, marii kizi upatakaꞌuta-kao naꞌii. Naꞌiki naꞌiaꞌoram dakoopaꞌo paꞌinawuzu, ‘yaakaru, maaitapin-kaꞌo!’ kii, kaboota-karu niizu Tuubaruꞌo Tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ukauꞌan putaainaꞌanan dono Tominkaru ati, punaꞌakan idaꞌan aimaakan uꞌati altar uzai kawaodapa-kizinao diꞌiti, naꞌiki punyukunuiankan an kainaꞌaꞌo daꞌi pukasharutan puꞌinawuzu nyukunuu, ");
INSERT INTO wapNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","puwaꞌakaꞌa naa zii wuruꞌu putaaꞌazooniaz altar dazabaꞌa, pumako puꞌinawuzu diꞌiti, pusaabaa-kidanaka punyukunuu utuma. Udaunaꞌan putaaꞌanan niꞌi naa wuruꞌu putaaꞌazooniaz Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Aizii pukasharutaakapan an pidan tuma. Uruu dikin ii unaꞌakan pugaru kootowapa-kizai iti. Mazan ukaawa-kidan uaꞌii pugaru naꞌiti, putiwaa pusaabaa-kidan puparadan utuma. Aonaan an pushaꞌapatinan naꞌapa, mishiꞌo nii unaꞌakan pugaru kootowapa-kizai iti, naꞌiki utaan nii pugaru kootowapa-kidauzo pidan ati. Udaunaꞌan kootowapa-kidauzo taan niꞌi naa pugaru police kaꞌu iti, uruꞌo niꞌi naa kaboota pugaru taraa-kizai diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Õkian puꞌati, punaꞌian nii, aonaꞌo nii pukodita-kida-kao atii pukawinipinaatan anaꞌo nii zii ipai daunuudaꞌu aiapa-kariwai pukodita-kinaa nii. ");
INSERT INTO wapNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Uaitapanii shaꞌatii naꞌapam Tominkaru kakinaorii kian, ‘Manaꞌa pubaꞌorantapaꞌanaꞌa.’ ");
INSERT INTO wapNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mazan aizii õkian nii uꞌati, kanom awunuutapan zun, naꞌiki unaꞌazootapanuzo, ubaꞌorantapaꞌakan naa wuruꞌu panyukunuu ii. ");
INSERT INTO wapNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ukauꞌan pudiwaꞌora antanpuꞌo puawun shaꞌapata-kidan dono puꞌati oiaꞌo, pusoꞌota naꞌiki pukaboota puꞌaiaz. Kaimanaꞌo nii zii puwaziwaan baudaꞌapa karikaonan pushaꞌapauzin punanaa diꞌikiꞌo, pukaboota-kidan ai ipai daunuudaꞌu punanaa manawun Tuubaruꞌo Tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pudiwaꞌora antanpuꞌo pukaꞌu shaꞌapata-kidan dono puꞌati oiaꞌo, pudukuta naꞌiki pukaboota puꞌaiaz. Kaimanaꞌo nii zii puwaziwaan baudaꞌapaꞌo pukaꞌu karikaonan, pukaboota-kidan ai ipai daunuudaꞌu punanaa manawun Tuubaruꞌo Tikazi wuꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesus kian koshan, “Uaitapanii shaꞌatii naꞌapam Tominkaru kakinaori kian, ‘Naꞌiaꞌoram pidan muudan an paudaiaro, marii utaan oꞌati saada-kariwai muudaaka-karu kaaritannaa.’ ");
INSERT INTO wapNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mazan aizii õkian nii uꞌati, daonaiora muudan dono paudaiaro omashaapan puꞌu kaiman padamata utuma, ukauꞌan ubaꞌorantapa-kidan naa oroo wuruꞌu baꞌoran daonaiora tuma omazidan anaꞌa naa koshan. Naꞌiki arawuꞌu daonaiora mazidaꞌoraz naa otuma, utoman naa oiaꞌo kapam ubaꞌoran-daiarotapan idi. ");
INSERT INTO wapNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Uaitapanii shaꞌatii kapam naꞌapam kiauzo-karu pidannao ati kotuaꞌa naa, ‘Manaꞌa pumarinaꞌataꞌanaꞌa putaanii puparadan pumishiaꞌazoonii, mazan pushaꞌapata puparadan Tominkaru ati wuruꞌu pushaꞌapataꞌazooniaz.’ ");
INSERT INTO wapNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mazan aizii õkian nii uꞌati, manaꞌa pudakotaꞌanaꞌa aimaakan uu puparadan mishida-kinao nii. Manaꞌa pudakotaꞌanaꞌa aokazi uu puparadan mishida-kinao nii, ushaꞌapanum kauꞌan Tominkaru naobanai-tinapa-kizi wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Manaꞌa pudakotaꞌanaꞌa imiꞌi baara uu, ushaꞌapanum kauꞌan imiꞌi baara Tominkaru kidiba wiizi wuruꞌu. Jerusalem uu naꞌapa kapam, manaꞌa pudakotaꞌanaꞌa puparadan ii, ushaꞌapanum kauꞌan uruu donoi umanawunuꞌo King wiizi wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Manaꞌa pudakotaꞌanaꞌa puzowau puaipan idi puparadan mishida-kao, ushaꞌapanum kauꞌan aonaa pukaꞌiitan putoman baudaꞌapaꞌo puzowaud baraka oo podidi. ");
INSERT INTO wapNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ukauꞌan, turuu pukian ‘Oo’, umishiin dono, naꞌiki ‘Aonaa’, uꞌaonaan dono. Pudobata-kidan an powaꞌa zii puparadan, oiaꞌo diꞌikiꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Uaitapanii shaꞌatii naꞌapam Tominkaru kakinaori kian, ‘Pidan zowitan dono pairiban awun, marii ukaunaatinan uawun ati kapam; pidan zowitan dono pairiban dako, marii ukaunaatinan udako ati kapam.’ ");
INSERT INTO wapNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mazan aizii õkian nii uꞌati, aonaa pukaunaatinaꞌanaꞌa pushaꞌapata-kao an dikaudaꞌo idaꞌan. Pidan taꞌikan an pudiwaꞌora antanpuꞌo pukaozoo, marii putaꞌika-kidan puꞌashabaron antanpuꞌo pukaozoo kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pidan kootowapa-kidaꞌanan dono pugaru naꞌiki uzaamatan pushooton, putaaꞌaka puchaakitan kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aizii umanawunuꞌo pidan dyuudan dono pudowautan padopao baudaꞌapaꞌo naawazi diꞌiti, pudobata-kida udopao baudaꞌapaꞌa naa naawazi diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pidan pishaan an aimaakan puꞌai, putaa uꞌati; ukaiwaaꞌazon an zii karikaonan puaimaakanuta, putaaꞌa naa zii uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Uaitapanii shaꞌatii naꞌapam Tominkaru kakinaori kian, ‘Pumarainapa puiriban, mazan putoꞌora-kizaitapa putarubaitapaniinao.’ ");
INSERT INTO wapNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mazan aizii õkian nii uꞌati, pumarainapa pidan toꞌorainao puꞌati, pukamunan kaiman ĩꞌati; naꞌiki putoriinapa Tominkaru ati kaimanaꞌo idaꞌan wunao dauꞌanaꞌa, patakaꞌutainaouz pugaru. ");
INSERT INTO wapNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Naꞌapaꞌo idaꞌanaꞌo nii utukapa-kao mishiꞌo uDaru Tominkaru aokazi iaꞌo dainao unao. Ushaꞌapanum kauꞌan uruu kanada-kida kamoo ipai pidannao ati, kaimanainao naꞌiki dikaudainao ati kapam. Naꞌiki ukaawa-kida wunu pidannao ati, kaimanainao ĩshaꞌapainpan naꞌiki dikaudainao ĩshaꞌapainpan ati kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Aizii kanomaꞌo nii Tominkaru taa uwinipinaa nii ukaimanan an marainpainao ati unao karikaonan? Upuꞌu zii zaamaapauzonao tax puraatannaa oiainaouz padamata, ĩmarainapa pairiban kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ukauꞌan ukaimanan dono soo marainpainao ati unao karikaonan, naꞌapa dii upanaꞌan baokoinao pidannao ai? Naꞌapa pidannao mashaapan kapam mamishida-kainaouz Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ukauꞌan aonaa ukasharutinaꞌanaꞌa ukaimanan ai, uDaru aokazi iaꞌo makasharutin-kan kawan pakaimanan ai. ");
INSERT INTO wapNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ushaꞌapatan an kaimanaꞌo aimaakan, manaꞌa ushaꞌapataꞌanaꞌazu iribaꞌo pidan bii ii, utukapa-kidaꞌazon idi ukaduz ukaimanan karikaonan. Ushaꞌapainpan an naꞌapa, aonaꞌo nii uwinipinaa nii uDaru aokazi iaꞌo diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ukauꞌan utaan dono aimaakan patakaꞌutinainao ati, aonaa ukainaabataꞌanaꞌazu diꞌiiꞌaka kidaꞌa tawunao kawanuꞌu taapinpauzonao kaimanainao nii kaikiniꞌi. Ĩnao, paaipan idi pashaꞌapataniaz patakaꞌutinainao ati atadapa-kao, ukauꞌan ĩaidautan pashaꞌapatanii ipai diꞌiiꞌaka kidaꞌa pidannao ati, choochiapa-kizai ii, naꞌiki ipai dunapota pidannao iriba-kizi an. Mishiꞌo õkian uꞌati, wuruꞌu ĩnaouz kaimanaimanaꞌoraꞌa naa ĩkawinipinaatinaꞌakan paꞌatadapa-kao idi. ");
INSERT INTO wapNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Utaan an aimaakan patakaꞌutinainao ati, manaꞌa putaapadaꞌanaꞌa aonaa naꞌiaꞌoram pidan aitapan putaanii dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Utaaꞌazon an aimaakan, aonaa kainaabaꞌo-karuꞌu mani utaanuzu, uDaru tukapan nii ushaꞌapatanii aonaꞌoraz pidan tukapan, naꞌiki ukawinipinaatan nii unao. ");
INSERT INTO wapNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Utoriinpan dono, manaꞌa paꞌi utoriinpaꞌanaꞌa tawunao kawanuꞌu taapinpauzonao kaimanainao nii kaikiniꞌi. Ĩnaudapa pakadishitaꞌanan naꞌiki patoriinpan choochiapa-kizai ii, naꞌiki dunapota pidannao iriba-kizi an, ĩaipan karikaonan pakaduz tukapa-kao. Õkian mishiꞌo uꞌati, kaimanaimanaꞌoraꞌa naa ĩkawinipinaatinaꞌakan paꞌatadapa-kao idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mazan unao paꞌan, utoriinpaꞌazon dono, umorota udapu nazo iti, utaratinaꞌaka, uruꞌu naa utoriinpan uDaru aonaꞌoraz tukapa-kao ati. UDaru tukapaꞌoraz utoriinpan aonaꞌoraz pidan tukapan, utaan nii uwinipinaa nii. ");
INSERT INTO wapNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Utoriinpan dono, aonaa ukiwaꞌanapa-kidaꞌanaꞌa mazanuiman kidaꞌo parada-karu, maaitapa-kainao Tominkaru kawan. Ĩtoriinpan dawuu, naꞌapa ĩzauda-kidan patominkarun abatan nii patoriinpan. ");
INSERT INTO wapNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aonaa paꞌi ĩnao kawan mani unao. Utoriinpan uaꞌii zii uDaru aitapaniꞌi naa kanom uaiapanii. ");
INSERT INTO wapNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ukauꞌan diꞌoraz kawan utoriinapaꞌa: ‘WaDaru aokazi iaꞌo, marii ipai pidannao taapan pugaru umanawunuꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Marii kizi punaobanai-tinan. Marii kizi shaꞌapatin-karu puaipan kawanaꞌati daꞌaꞌa imiꞌi baaraꞌa, naꞌapa aokazi iainao shaꞌapatinan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Marii putaan waꞌati aizii wawanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pumarinaꞌata ipai wuruꞌu oiaꞌo washaꞌapatanii kidaz, naꞌapa wamarinaꞌatan kawan ipai oii kidaꞌo shaꞌapata-kariwaiz waꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aonaa putaapadaꞌanaꞌa wanyukunuu tiwaa-kidapa-kao oiaꞌo diꞌiti, mazan kaiman putaapa waunao oiaꞌo ai. Karikaonanuꞌo pugaru wuruꞌu naobanaiz, maꞌozakaꞌoraz, naꞌiki konaunamaꞌoraz. Amen.’ ");
INSERT INTO wapNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Umarinaꞌatan an pidannao shaꞌapatanii oii kidaꞌo uꞌati, uDaru aokazi iaꞌo marinaꞌatan nii ipai uꞌoian kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mazan aonaan an umarinaꞌatan oii kidaꞌo pidannao shaꞌapatanii uꞌati, aonaꞌo nii uDaru marinaꞌatan uꞌoian kida. ");
INSERT INTO wapNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Usanadinpan an Tominkaru ati, aonaa utaapinpaꞌanaꞌa kashaꞌoraꞌa kawan, tawunao kawanuꞌu taapinpauzonaouz kaimanainao nii kaikiniꞌi. Ĩnao ĩpanaꞌadaꞌakan naꞌapam paaidinpan pataapinpaꞌakan idaꞌan manaunam kashaꞌoraꞌa kawan, ĩaipan karikaonan paaitapa-kao pasanadinpan. Õkowaadan nii mishiꞌo uꞌati, ĩnao naꞌapainpainaouz ĩshaꞌapainpan, kawinipinaatinaꞌa kainaouꞌu naa wuruꞌu paꞌatadapa-kao idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mazan unao, usanadinpan dono Tominkaru ati, uchikaa uawun baara kaiman, uramaudin naꞌiki umaoda uzowaud. ");
INSERT INTO wapNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Aonaa kizi baokoinao aitapan usanadinpan Tominkaru ati, soo uDaru aonaꞌoraz utukapa-kao aitapan nii paꞌan, naꞌiki uDaru tukapaꞌoraz ushaꞌapatan aimaakan aonaꞌoraz baokoinao aitapan, ukawinipinaatan nii unao. ");
INSERT INTO wapNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Manaꞌa ukashaꞌapauzi-tinaꞌanaꞌa daꞌaꞌa imiꞌi baaraꞌa, ushaꞌapauz kainin nii, naꞌiki uwuzaaritan nii, naꞌiki koidimikinao koidapan niizu. ");
INSERT INTO wapNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mazan usaabaa ushaꞌapauz nii aokazi ii, naꞌii aonaꞌo nii ukainin, aonaꞌo nii uwuzaaritauzon, naꞌiki aonaꞌo nii koidimikinao koidapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aizii naꞌiam pidan saabaan pashaꞌapauz, karikaonanuꞌo nii utaapan panyukunuu, wuru diꞌitiꞌi utaapa-kiziz pashaꞌapauz. ");
INSERT INTO wapNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Wuruꞌu awunuiz naꞌapaꞌo lamp kawan ukanadapan pidan nanaa ati. Aizii puawun kaimanan dono, ipai punanaa mashaapan kanadaꞌo-karuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mazan puawun makaimankan an, punanaa mashaapan nii marutaꞌo-karuꞌu. Ukauꞌan kanadaꞌo makadan dono uꞌidaꞌa, marutaꞌo manawun idaꞌaꞌo pugaru. ");
INSERT INTO wapNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Aonaa turuu pidan poitoruitapa-kidinan dyaꞌutamaꞌo naobanainao ati. Panaadon utoꞌora-kizaitapan nii baudaꞌapaꞌo, naꞌiki umarainpan nii baꞌoran; kaimanaꞌo nii uizoꞌatin baudaꞌapaꞌo, naꞌiki ukashadapan nii baꞌoran. Ukauꞌan aonaa turuu pidan naobanaitapan Tominkaru naꞌiki puraata. ");
INSERT INTO wapNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Uruu idi õkian uꞌati. Aonaa ukaziwadapaꞌanaꞌa unyukunuu udiꞌitinpan idaꞌan kanomaꞌo nii unika naꞌiki utuzan niꞌo dauꞌu ukakupa-kinaa nii, oo kamicha ukaiwadan nii dauꞌan. Mishiꞌoraiman kakupa-karu, powaꞌaꞌo umanawunun wanyukunui ai, naꞌiki nanai, powaꞌaꞌo umanawunun kamicha ai. ");
INSERT INTO wapNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Utukapa mooko kotuꞌuznao, aonaa ĩpaowinan. Udaunaꞌan ĩsoꞌotan mani papaoriba aka naꞌiki ĩkasabaꞌuan maniz padapunaa iti. Mazan upuꞌaꞌo uDaru aokazi iaꞌo paan ĩdyaun. Aizii mani unao, aonaa umarainapa-kao mooko powaꞌa zii kotuꞌuznao ai? ");
INSERT INTO wapNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Naꞌiaꞌoram unao turuu umashaapan powaꞌa ukotuaꞌikin ukaziwadapan idaꞌan unyukunuu udauꞌan? Aonaa naꞌiaꞌoram. ");
INSERT INTO wapNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kanom nii ukaziwadapan unyukunuu ukamichan dauꞌan? Utukapa amazada ii akaꞌo soosoi kida sodan, naꞌiki naꞌapam ĩsoosoan. Aonaa ĩkaudinan dadara ĩtomapan mani pakamichan. ");
INSERT INTO wapNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mazan õkian uꞌati, King Solomon umanawunuꞌo ushaꞌapauz konaunam kida, upuꞌu aonaa ukakamichantinan konaunam soosoi kida kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tominkaru wuruꞌu konaunamadaꞌoraz pinidi kida sodaꞌoraz amazada ii aka. Aizii kakupa utukapa-kao, udaunaꞌan umawakaꞌakan naa, uruꞌo niꞌi naa ukawaoda-kao. Aonaꞌo nii mooko Tominkaru kakamichantan unao naꞌapa? Kanom nii mooko umishidapan mapasaka sodi? ");
INSERT INTO wapNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ukauꞌan aonaa ukaziwadapaꞌanaꞌa unyukunuu udiꞌitinpan idaꞌan kanomaꞌo nii unika, oo kanomaꞌo nii utuza, oo kanomaꞌo nii ukamichan nii. ");
INSERT INTO wapNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Naꞌapa kidaꞌo dauꞌanaꞌa maaitapa-kainao Tominkaru kaziwadapauzon panyukunuu. Aokazi iaꞌoraz uDaru aitapanii uaipan aimaakan naꞌapa kidaꞌoraz umashaapa-kinaa nii. ");
INSERT INTO wapNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mishiꞌoraiman utaa unyukunuu kiwiitapa zii Tominkaru naobanai-tinan dauꞌan, naꞌiki umashaapa naꞌiki ushaꞌapatin Tominkaru aipan kawanaꞌati. Utaan nii ipai naꞌapa kidaꞌoraz unao idiwau nii. ");
INSERT INTO wapNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ukauꞌan aonaa ukaziwadapaꞌanaꞌa unyukunuu waikanaꞌanaꞌo uaiapanii dauꞌan. Ushaꞌapanum idi waikanaꞌanaꞌo aimaakan shaꞌapainpan nii waikanaꞌanaꞌo idaꞌa. Ukauꞌan aonaa ukaziwadapaꞌa naa unyukunuu waikanaꞌanaꞌo aimaakan dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Manaꞌa pudakotaꞌanaꞌa baꞌoran pidannao dikaudaꞌo nii, aonaa kizi Tominkaru dakotan pugaru dikaudaꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ushaꞌapanum kauꞌan Tominkaru dakotan nii pugaru dikaudaꞌo nii naꞌapa kapam pudakotan kawan baꞌoran pidannao, naꞌiki naꞌapaꞌoram putaapan baꞌoran pidannao, naꞌapaꞌo nii Tominkaru taapan pugaru kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kanom nii mooko pudiꞌitapan kaunuba sodiꞌo kainaꞌan puiriban awun idaꞌa, pumadiꞌitapakan puꞌu atamun idin kainaꞌan puawun idaꞌa? ");
INSERT INTO wapNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pukaꞌiita zii pukian puiriban ati, ‘Õsoꞌota kizi kaunubaꞌo puawun ai’ atamun idin kainaꞌan puꞌu puawun idaꞌa? ");
INSERT INTO wapNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pugaru taapinpauzo kaimanaꞌo nii kaikiniꞌi, pusoꞌotaꞌa naa zii kiwiitapa atamun idin puawun ai. Uruu naꞌapa kaimanaꞌo niꞌi naa putukapan pusoꞌotaꞌazoonii kaunubaꞌoraz puiriban awun ai. ");
INSERT INTO wapNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Manaꞌa utaaꞌanaꞌa kaimanaꞌo aimaakan Tominkaru diꞌikiꞌo arimarakanao ati, ĩtanawatinaꞌakan nii uꞌati karikaonan, naꞌiki ĩaroautapan nii unao. Manaꞌa ukabootaꞌanaꞌa umanawunuꞌo kawinipinaa kidaꞌo ushaꞌapauz kooshinao bii iti, ĩdakazaabiꞌian nii karikaonan kidaz.” ");
INSERT INTO wapNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesus kian koshan, “Upishaa aimaakan, taa-karu nii uꞌatiz; udorota aimaakan, uikodan nii wuruꞌu udorotapaniaz; udau-dauapa paniinom, daꞌata-karu nii paniinom uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ushaꞌapanum idi ipai pidan pishaaꞌo aimaakan, taa-karu nii uꞌatiz; naꞌiki naꞌiaꞌoram pidan dorotaꞌo aimaakan, uikodan niiz; naꞌiki dau-daupaꞌo paniinom daꞌata-karu nii paniinom uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Daruinao, udani pishaan an pawanyukunuu nii uꞌai, utaa mani kuba udani ati? ");
INSERT INTO wapNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Oo upishaan an kopau uꞌai, utaa mani kowazaz uꞌati? ");
INSERT INTO wapNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Oiaꞌo unao padamata, upuꞌu zii uaitapa utaan kaiman kidaꞌo aimaakan udainao ati, aitaniimanaꞌo nii uDaru aokazi iaꞌoraz, utaan nii kaiman kidaꞌo aimaakan pishainao ati paugaru. ");
INSERT INTO wapNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pushaꞌapata kaimanaꞌo aimaakan baꞌoran pidannao ati, naꞌapa puaipan kawan aimaakan shaꞌapata-kao puꞌati kapam. Naꞌapaꞌo dauaꞌo wuruꞌu Moses naꞌiki Tominkaru prophetinnao kakinaori kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Umorota mazowaꞌo dobaapa-kizai paniinom idaꞌan, ushaꞌapanum kauꞌan kazowaꞌo dobaapa-kizai paniinom Tuubaruꞌo Tikazi patakaꞌutin-kizai diꞌitiꞌo wuruꞌu. Naꞌiki mashaꞌapannaa mako-karu naꞌan, ukauꞌan iriba pidannao makon naꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mazan dobaapa-kizai paniinom karikaonanuꞌo kakupa-karu diꞌitiꞌo, mazowaꞌo naꞌiki kashaꞌapannaa kapam mako-karu naꞌan. Ukauꞌan aonaa iribaꞌo nii mani pidannao ikodanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Uzaudinpauzo paꞌi wunao aiaꞌa dakotinpainaouz prophetnao nii. Ĩwaꞌatin nii uꞌidaꞌati, naꞌapa mashaꞌapatanuꞌu kaznizo kawan ĩaidinpan, mazan kichanaꞌiki-kiaꞌo ĩkaduz wuruꞌu, naꞌapa baudokoru kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Uaitapan nii ĩdyaun naꞌapaꞌoram ĩshaꞌapatanii idaꞌan, naꞌapa paoribai aitapa-kao kawan paꞌaka idaꞌan. Aonaa naꞌapainim puikodan kaiwada-karu idaꞌa grape oo fig aka. ");
INSERT INTO wapNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ukauꞌan ziwuꞌo atamun kaakan dono, kaimanaꞌo nii uꞌaka kida, mazan maziwukaꞌo atamun, uꞌaka dikauda kidaꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ziwuꞌo atamun, aonaꞌo nii ukaakan dikauda kidaꞌo idi; naꞌiki maziwukaꞌo atamun, aonaꞌo nii ukaakan kaiman kidaꞌo idi. ");
INSERT INTO wapNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Naꞌiaꞌoram paoribai dikauda kidaꞌo uꞌaka barota-karu niizu, naꞌiki kaboota-karu niizu tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ukauꞌan naꞌapaꞌo idaꞌanaꞌo nii unao aitapan wunaouꞌu dakotinpainaouz prophetnao nii, ĩshaꞌapatanii kida idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Aonaa ipaiꞌo nii mani pidannao wuruꞌu ‘Naobanai, Naobanai,’ kiaꞌoraz ĩkian õꞌati kawiizin Tominkaru naobanai-tinapa-kizi ii, soo wunaouꞌu shaꞌapatinaꞌoraz õdaru aokazi iaꞌoraz aipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Naꞌapain Tominkaru widauan kamoon donoꞌo naa pidannao, iribaꞌo nii pidannao kian õꞌati, ‘Naobanai, Naobanai, puꞌuu idaꞌanaꞌo wakowaadapauzon Tominkaru paradan. Puꞌuu idaꞌanaꞌo wawaatan oiaꞌo doronai kida, naꞌiki iriba aimaakan umanawunuꞌo ukaimanan kida washaꞌapatan puꞌuu idaꞌan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mazan õkian nii ĩꞌati, ‘Aonaa õaitapauzon unao. Umako õꞌai, unao shaꞌapaapauzonao oii kidaꞌo.’ ");
INSERT INTO wapNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Naꞌiaꞌoram pidan abataꞌo diꞌoraz õparadan kida, naꞌiki shaꞌapatinaꞌoraz õparadan kawanaꞌati, naꞌapaꞌo nii uruu aitapinaꞌo pidan kawan, tomaꞌoraz padapu nii dadaraꞌo baaraꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wunu tuukiaꞌo kaawan donoꞌo naa, uwaꞌozi kida paidan naa, utuubarun paida baara ii aka, naꞌiki maꞌozakaꞌo awaru kaawaꞌakan naa kabaun idaꞌati, mazan aonaa kabaun dorautan, utoma-kao idi dadaraꞌo baaraꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Aizii naꞌiaꞌoram pidan abataꞌo diꞌoraz õparadan kida, naꞌiki aonaa ushaꞌapatinan õparadan kawanaꞌati, naꞌapaꞌo uruu tawuru kawanuꞌo maaitapin-kaꞌoraz pidan, tomaꞌoraz padapu kaatu baaraꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wunu tuukiaꞌo kaawan donoꞌo naa, waꞌozi kida tuubarun paida baara ii aka, naꞌiki maꞌozakaꞌo awaru kaawaꞌakan naa kabaun idaꞌati, sariapa kabaun dorautan, ipai daunuudaꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aizii Jesus ipaian patominapa-kidan naꞌapa kidaꞌo dauꞌan, tuukii pidannao diꞌitinpan naꞌapam utominapa-kidan dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Powaꞌa zii umanawunun utominapa-kidan pidannao wunao aiaꞌa tiichaapauzonao Moses kakinaori dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus tokan anaꞌa naa naawazi daara iki, iriba pidannao daꞌanpan udawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mashaꞌapakiaka daonaiora kaawan uꞌidaꞌati baiatinaꞌo kichanaꞌiki-kiaꞌo bishoi idi. Ukodoruꞌukan ukanaapu ati, naꞌiki ukian uꞌati, “Naobanai, punyukunuu naꞌapan dono, õaitapa pukakudan nii õgaru, kaiman kiziꞌi naa õsaabainan.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus pishatan uruu naꞌiki ukian, “Naꞌapa õnyukunuu, pukakuda, kaiman pusaabain.” Mashaꞌapakiaka ubisho manakaꞌakan naa, naꞌiki kaiman usaabainaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Udaunaꞌan Jesus kian uꞌati, “Puabata, manaꞌa paꞌi pukowaadaꞌanaꞌa naꞌiaꞌoram pidan ati, mazan pumako sariapa puawunuuta-kidanaka pumada faadaa diꞌii, naꞌiki putaaꞌa naa taauzo-kariwaiz Tominkaru ati kakuda-kariwainao taauzoniaz Moses kakinaori kawanaꞌati. Naꞌapaꞌo idaꞌanaꞌo nii pidannao mishidan kaimanaꞌoraꞌa naa pusaabainan.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus kaawan dono Capernaum iti, Roman soldyaannao zowaunaa kaawan uꞌidaꞌati padopian idi. ");
INSERT INTO wapNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ukian, “Naobanai, kainaꞌa õpoitoru karinaan õdapu ii, tuukiaꞌoraꞌa naa, aonaꞌa naa ukaꞌiitan pakiitinan.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus kian uꞌati, “Õmakon nii naꞌiti, õkakudanaka kizi uruu.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mazan ukian Jesus ati, “Aonaa Naobanai, aonaa umanawunuꞌo mani wuruꞌu õgaruz pumakoꞌozon mani õdapu iti. Turuu paꞌan puparadan karikaonan diꞌikiꞌi, kakudaꞌo nii õpoitoru. ");
INSERT INTO wapNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Õgaru naꞌapa, õkaudinan doko ainao pidannao õꞌai waranu aꞌo, õgaru naꞌapa kainaꞌa soldyaanao kaudinaꞌo õwaranuꞌu kapam. Õdyuudan dono baudaꞌapa soldyaa, ‘Pumako’ õkian an uꞌati, umakon nii. Aizii õdapadan dono baꞌoran soldyaa, ‘Puwaꞌati’ õkian an uꞌati, uwaꞌatin nii. Naꞌiki õdyuudan dono õpoitoru, ‘Pushaꞌapata wuruꞌu,’ õkian an uꞌati, ushaꞌapatan niizu.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus abatan idi wuruꞌu kaikapaꞌoraz parada-karuꞌu, tuukii udiꞌitinpaꞌakan, naꞌiki ukian wunao atiꞌi kasabaꞌukinpainaouz paꞌidaꞌati, “Õkian mishiꞌo manawun uꞌati, aonaa naꞌapainim zii õikodauzon pidan Jewnao biiꞌi kaikapaꞌa manawun umishidanuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Uruu idi õkian nii uꞌati, iribaꞌo nii Gentilnao waꞌatin diꞌikinapa kidaꞌa waoko ikinapu naꞌiki wakadapu ikinapu, naꞌiki ĩsakanataꞌanan nii Abraham, Isaac naꞌiki Jacob tuma konaukiaꞌo aroapa-karu idaꞌati, Tominkaru naobanai-tinapa-kizi ii. ");
INSERT INTO wapNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mazan unao, Tominkaru pidanannaouz naꞌiaꞌo niꞌoraz padamata Tominkaru naobanai-tinan donoꞌo naa, kaboota-karu nii unao marutaꞌo-karu iti. Naꞌiaꞌo niꞌi naa uzaadan tuukii naꞌiki ukuzowan nii uudako kida udopian idi.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Uruu daunaꞌan Jesus kian naa soldyaanao zowaunaa ati, “Pukiwaꞌa naa pudapu iti, naꞌapaꞌoram pumishidan manawun, shaꞌapata-kao nii naꞌapa puꞌati.” Naꞌapain aka manawun poitorui kakudaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aizii Jesus kaawan dono Peter dapu iti, naꞌii utukapan Peter imauzo washatinpan bed paawaꞌa, tuukiaꞌo omada wiichan pakarinaan idi. ");
INSERT INTO wapNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Uruu idi Jesus zaamatan okaꞌu, sariapa omada wiichan shabataꞌakan, naꞌiki okakudaꞌakan naa. Naꞌikiꞌo okadishitan otaan naa Jesus wanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Uruu wachuupunin kamoo tipitan daunaꞌan iriba pidannao naꞌakan Jesus idaꞌati pairibannao oiaꞌo doronainao zaamatapaniinao kida. Jesus waata oiaꞌo doronainao pidannao ai paparadan idaꞌan karikaonan. Naꞌiki ukakuda ipai karinainao. ");
INSERT INTO wapNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wuruꞌu ushaꞌapatan kaikapa kidaꞌorazuꞌu, uruu umishian naa tawuruꞌu kotuaꞌoraz prophet Isaiah kianuz, “Paꞌidaꞌa uzaamatan waꞌai wabaiatin-kinaa rinai kida, naꞌiki usoꞌota waꞌai wakarinauzo-kinaa kida.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus tukapan idiꞌi naa iriba pidannao kasabaꞌukinan paꞌidaꞌati, sariapa ukian patominapa-kidaniinao ati, “Aushaa wataraukaꞌa naa karishii baza iti.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Baudaꞌapa pidan tiichaapauzo Moses kakinaori dauꞌu waꞌatin Jesus idaꞌati. Ukian uꞌati, “Tiichaa, õdaꞌanan nii pugaru naꞌitiꞌoram pumako-kizi iti.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus dakoꞌatin naꞌiki ukian uꞌati, “Waruzonao kainaꞌa ĩꞌuun kida, kotuꞌuznao kainaꞌa ĩshimaka kida kapam, mazan Daonaiora Aokazi Ikiꞌo, aonaa uwashatinauzo-kizi nii, naꞌiki aonaa usookapauzo-kizi nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Baꞌoran daonaiora tominpaꞌo Jesus diꞌiki kian uꞌati, “Naobanai, õdidanaka kizi zii õdaru mawakan kiwiin, uruu daunaꞌan õdaꞌanan pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mazan Jesus kian uꞌati, “Pudaꞌan õgaru. Marii mawakainao didan pairiban mawakan.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus paidinan kanawa zoꞌiti, utominapa-kidaniinao makon kapam utuma karishii an. ");
INSERT INTO wapNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mashaꞌapakiaka maꞌozakaꞌo awaru kaawan karishii an, naꞌiki kanawa kichanaꞌiti-kiaꞌa naa, udaawadainan wunu paran idi. Mazan Jesus, udaꞌawun. ");
INSERT INTO wapNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sariapa utominapa-kidaniinao pokowauanuzu. Ĩkian uꞌati, “Kadiman Naobanai! Kadiman! Pukazannaata waunao! Wanaraan niꞌi naa!” ");
INSERT INTO wapNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus kian ĩꞌati, “Kanom nii dii utarian? Masakaudaꞌuꞌo shaꞌa karikaonan umishidan?” Udaunaꞌan ukadishitaꞌakan, uruꞌu naa udyuudan maꞌozakaꞌo awaru naꞌiki wunu paran mashaadinan. Sariapa mishi amazada mashaadinaꞌakan mashaa. ");
INSERT INTO wapNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tuukii udiꞌitinapa-kidaꞌakan patominapa-kidaniinao. “Kanom kaduzuꞌu naa pidan uruu?” ĩkian. “Atii awaru naꞌiki wunu paran mishida zii uparadan.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus kaawan donoꞌo naa karishii baza iti Gadara Baara itinapu, naꞌii pamakopa-kizi an, dyaꞌutam pidannao ikodapanuzu, koditaꞌakainao pamashaapa-kizi baaranai iaꞌo, kaꞌunaru kida diꞌiki. Wuruꞌu ĩnaouz oiaꞌo doronainao zaamatapaniinao, ukauꞌan toꞌorabaꞌo ĩdyaun. Unaꞌapan idi, aonaa kanom makouzon naꞌiiꞌakaꞌo dunapo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sariapa ĩkadakon uꞌati diiwaꞌo idaꞌan, “Pugaru Tominkaru Dani, kanom puaipan waꞌai? Pupatakaꞌutaꞌanan naa shaꞌa waunao wapatakaꞌuta-kao kamoon uaꞌii zii?” ");
INSERT INTO wapNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aonaa munapo manawun mani ĩnao diꞌiki, kainaꞌa iribaꞌo kooshinao aroapatinan. ");
INSERT INTO wapNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Uruu idi oiaꞌo doronainao pishaan Jesus tuukii. Ĩkian uꞌati, “Puaipan an wamakon diꞌikiꞌi, pudyuuda shoman waunao wamorotaꞌan kizi kooshinao diꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Umako,” Jesus kian ĩꞌati. Uruu idi ĩkoditaꞌakan daonaioranao diꞌiki, naꞌiki ĩmakon ĩmorotaꞌanan naa kooshinao diꞌiti. Sariapa kooshinao dimaꞌakan karishii danoma katawudapuzun diꞌiti, ĩwaotan karishii baoko iti, naꞌiki ipai ĩnaraan. ");
INSERT INTO wapNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Uruꞌu naa kooshinao taapikinao dimaꞌakan donoi iti. Naꞌiaꞌa naa ĩkakuwaapan ipai naꞌapam aimaakan shaꞌapainpan dauꞌu. Naꞌiki ĩkowaada naꞌapam oiaꞌo doronainao zaamatapaniinao shaꞌapata-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Uruu idi ipai donoi sannao makon ĩikodapaꞌanan Jesus. Ĩikodapan donoꞌo naazu, kaziwaꞌo idaꞌan ĩdyuudanuzu ĩaipan umakon pawiizi iki. ");
INSERT INTO wapNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Uruu daunaꞌan Jesus paidinan patominapa-kidaniinao tuma kanawa zoꞌiti ĩtaraukan karishii an powaa itiꞌi naa pamashaapa-kizi iti. ");
INSERT INTO wapNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naꞌiaꞌa naa pidannao naꞌakan daonaiora machiꞌikakaꞌo Jesus diꞌiti pawashatinapa-kizi baara idaꞌan. Aizii Jesus tukapan idi ĩmishidan tuukii manawun paugaru, sariapa ukian machiꞌikakaꞌo pidan ati, “Pusaabaa punyukunuu õdani, ipai õsoꞌotan puꞌoian.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pabiꞌi kida tiichaapauzonao Moses kakinaori dauꞌu kian panyukunuu ii, “Uwazootapaꞌazon Tominkaru paparadan idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus, uaitapa naꞌapam ĩdiꞌitinpan, uruu idi ukian ĩꞌati, “Kandii nii udiꞌitinpan õdauꞌu oiaꞌo idaꞌan? ");
INSERT INTO wapNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Naꞌiaꞌoram mashaꞌapannaa: ‘Ipai puꞌoian mainaabata-kao’ kii, oo ‘Pukadishita naꞌiki puchiꞌika’ kii? ");
INSERT INTO wapNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mazan õaidan nii uꞌati Daonaiora Aokazi Ikiꞌo, kainaꞌa umaꞌozakan mainaabata-kinaa nii pidannao oian daꞌaꞌa imiꞌi baaraꞌa.” Uruꞌu naa ukiaꞌakan machiꞌikakaꞌo pidan ati, “Pukadishita, punaꞌaka puwashatinapa-kizi naꞌiki pumakoꞌo naa pudapu iti.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Machiꞌikakaꞌo pidan kadishitaꞌakan naꞌiki umakon naa padapu iti. ");
INSERT INTO wapNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aizii pidannao tukapan idi kaikapaꞌo shaꞌapanuꞌu, tuukii ĩdiꞌitinpan, naꞌiki ĩkonaukii-kidan Tominkaru utaan idi umanawunuꞌo maꞌozaka-karu pidan ati. ");
INSERT INTO wapNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aizii Jesus makon naa naꞌiki, pamakopa-kizi an utukapa zaamaapauzo tax puraatannaa, Matthew kiaꞌo uꞌuu, usakanatapan kabaun pakaudin-kizi nazo ii. “Puwaꞌati õtuma,” Jesus kian uꞌati. Sariapa Matthew kadishitaꞌakan naꞌiki umakon naa utuma. ");
INSERT INTO wapNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesus aroopan patominapa-kidaniinao tuma Matthew dapu ii. Naꞌii iriba zaamaapauzonao tax puraatannaa naꞌiki baꞌoran oiainao pidannao aroopan ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Phariseenao tukapan idi uaroopan naꞌapainao pidannao tuma, sariapa ĩkian Jesus tominapa-kidaniinao ati, “Kanom nii utiichaan aroopan oiainao tuma?” ");
INSERT INTO wapNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus abata ĩnaꞌapanuz kaikapaꞌa, uruu idi ukian ĩꞌati, “Ziwuinao pidannao, aonaa ĩaipan daakataa, soo karinainao paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Umako utominapa kizi naꞌapaꞌoram Tominkaru Paradan saada-kariwaiz kian. Ukianuz, ‘Kamunan-karu õaipan uꞌai, aonaa taain-karu kawaoda-kariwai uzai idaꞌan mani.’ Ukauꞌan aonaa kaimanainao mani wuruꞌu õdapadaꞌananiinaouz, mazan oiainao.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Baudaꞌapa kamoo John Chikaawunuupauzo tominapa-kidaniinao kaawan Jesus idaꞌati. Ĩpishaan Jesus, ĩkian uꞌati, “Kanom nii waunao naꞌiki Phariseenao sanadinpauzon Tominkaru ati, mazan putominapa-kidaniinao, aonaa paꞌan ĩsanadinpauzon Tominkaru ati?” ");
INSERT INTO wapNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus dakoꞌatin ĩdyaun, ukian, “Naꞌapa dii uaitapan mazidaꞌo daonaiora dapadaniinao mashaapan kashaꞌora mazidaꞌo aroapa-kizi ii, mazidaꞌo daonaiora naꞌan puꞌu ĩtuma. Aonaa turuu unaꞌapan. Mazan daonaiora mazidaꞌo zaamata-kao dono ĩꞌai, uruu donoꞌo niꞌi naa paꞌan ĩkashaꞌoran naꞌiki ĩsanadinpan.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Udaunaꞌan Jesus kian koshan, “Aonaa pidan zimindotauzon pakamichan zaam dadotan paꞌinaꞌo kamicha idin idi, ushaꞌapanum kauꞌan shokotaꞌo nii zii wuruꞌu paꞌinaꞌoraz kamicha idin uzaamaꞌo ai, naꞌiki powaꞌaꞌo nii zii umanawutan wuruꞌu udadotanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Naꞌiki aonaa pidan kawazootauzon kaiwauzo-kariwaiꞌi naa wine kinnaa paꞌinaꞌo zii wine toma-kao idi. Paꞌinaꞌoraz zii wine poodan nii utadaꞌokan nii wuruꞌu kaiwauzo-kariwaiz naa ukinnaa, uruu wine wakudinan niꞌi naa, naꞌiki ukinnaa patakaꞌuinan niꞌi naa kapam. Uruu idi karikaonan daꞌi pidan tomauzon paꞌinaꞌo wine kinnaa papaida-kizi nii paꞌinaꞌo wine. Utoma-kao dono naꞌapa, aonaꞌo nii ukinnaa shaꞌapan.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus kadakotinan puꞌu zii, Jewnao zowaunaa kaawan uꞌidaꞌati. Ukodoruꞌukan ukanaapu ati, naꞌiki ukian, “Õdani zunaaba sodi mawakan aizii aka, upuꞌu mazan puwaꞌati pupishata kizi pukaꞌu idi oroo, okakuda kizi.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sariapa Jesus naꞌiki utominapa-kidaniinao makon naa utuma. ");
INSERT INTO wapNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aizii naꞌaꞌo zun baiatinaꞌo 12 wunu paizaipan idi. Okaawan Jesus barau ikinapu naꞌiki opishatan ukamichan danoma karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ushaꞌapanum kauꞌan panyukunuu ii okian, “Õpishatan an uchaakitan karikaonan, õkakudan nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus padantinaꞌakan, sariapa utukapanuzo, naꞌiki ukian oꞌati, “Maꞌozaka putaapa punyukunuu õdani, pumishidan idiꞌo, pukakudan.” Naꞌikiꞌi naa mishi sariapa okakudan. ");
INSERT INTO wapNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Uruu daunaꞌan Jesus kaawan Jewnao zowaunaa dapu iti. Naꞌii utukapan iriba taupauzonao naꞌiki muraapainao mawakaꞌo ati. ");
INSERT INTO wapNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Uruu idi sariapa Jesus kian ĩꞌati, “Ukodita diꞌikiꞌi, aonaa omawakan mani wuruꞌu, odaꞌawun karikaonan.” Ipai pidannao shaazootinan unaꞌapan idi. ");
INSERT INTO wapNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pidannao koditan daunaꞌan, uruꞌu naa Jesus makon zunaaba sodi diꞌiti, naꞌiki uzaamatan naa pakaꞌu kaduꞌikizo. Sariapa okakudaꞌakan naꞌiki okadishitaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pidannao kakuwaapan diꞌoraz dauꞌanaꞌa ipai naꞌan kidaꞌo wiizai kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Udaunaꞌan Jesus makopan puꞌaꞌa naa naꞌiki, dyaꞌutam daonaioranao ishaawunnao daꞌanpan uruu. Ĩkadakoinan diiwaꞌo idaꞌan uꞌati. “David Takaan-daun, pukamunan-kida waunao,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus morotan donoꞌo naa kabaun nazo iti, uruꞌu naa ishaawunnao kaawan uꞌidaꞌati naꞌiki upishaan ĩdyaun. Ukian ĩꞌati, “Umishida turuu õkakudan unao?” “Wamishida, Naobanai,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Uruꞌu naa Jesus pishatan ĩawun kida, naꞌiki ukian ĩꞌati, “Umishidan idi, naꞌapaꞌo nii ushaꞌapan.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sariapa ĩtukapaꞌakan naa. Uruꞌu naa Jesus kakinaowan ĩdyaun. Ukian, “Manaꞌa paꞌi ukowaadaꞌanaꞌa pidan ati kanom shaꞌapan uꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mazan upuꞌu ĩmakon, ĩkakuwaapaꞌanan udauꞌan, ipai naꞌan kidaꞌo wiizai kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wuruꞌu dyaꞌutamainaouz daonaioranao makoꞌokan puꞌu zii, pidannao naꞌakan Jesus idaꞌati maparadanuꞌo daonaiora, wuruꞌu umaparadanunuz oiaꞌo doronai kainaꞌan idiꞌo uꞌidaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aizii Jesus waataꞌakan daunaꞌan oiaꞌo doronai uꞌai, sariapa ukaparadanuꞌukan. Tuukii pidannao, kasabaꞌukinpainao naꞌii, diꞌitinpan, naꞌiki ĩkian, “Aonaa watukapauzon zii kaikapaꞌoraꞌa aimaakan shaꞌapata-kao Israel an.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mazan Phariseenao kian, “Oiaꞌo doronainao naobanaa taan idiꞌo uꞌati maꞌozaka-karu wuruꞌu uwaatanuz oiaꞌo doronainao.” ");
INSERT INTO wapNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus makon umorowautapan ipai donoi naꞌiki wiizai sodi kida kawanaꞌati. Utominapatin-kidan pidannao synagogue ii kida, naꞌiki ukowaadapan Kaimanaꞌo Kuwai Tominkaru naobanai-tinan dauꞌan, naꞌiki ukakuda pidannao karinainao pabiꞌinaaka kidaꞌo rinai idi. ");
INSERT INTO wapNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tuukii ukashaꞌora-kidan ipai wuruꞌu pidannaouz utukapan idi ĩdopian, naꞌiki aonaa ĩaitapan naꞌapam naa pashaꞌapatinan paꞌidaꞌa, naꞌapa kaznizonao kawan, aonaꞌoraz ĩtaapiki nii. ");
INSERT INTO wapNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ukauꞌan ukian patominapa-kidaniinao ati, “Udaru paoribai baawu, dyuuaꞌa naa uꞌaka, mazan aonaa kaudinainao iriban kasabaꞌuaꞌo niizu. ");
INSERT INTO wapNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Utoriinapa kapaoribaꞌo ati, uzaamata kizi kaudinainao nii kasabaꞌuupainao nii wuruꞌu papaoriba aka kidaz.” ");
INSERT INTO wapNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus dapadan 12 patominapa-kidaniinao baokopa paꞌidaꞌati, naꞌiki utaan maꞌozaka-karu ĩꞌati ĩwaata-kinaa nii oiaꞌo doronai kida pidannao ai, naꞌiki ĩkakuda kizi pidannao karinaapainao ipai pabiꞌinaaka kidaꞌo rinai ai. ");
INSERT INTO wapNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Diꞌi ĩꞌuu kidaꞌa 12 pidannao Jesus zaamatan apostlenao nii: kiwiin Simon, dakotapa-kariwaiz Peter kii, naꞌiki uꞌinawuzu Andrew; James naꞌiki uꞌinawuzu John, ĩnao Zebedee dainao; ");
INSERT INTO wapNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip naꞌiki Bartholomew; Thomas naꞌiki Matthew, Matthew uruu zaamaapauzoz daꞌi tax puraatannaa; James, Alphaeus dani, naꞌiki Thaddaeus; ");
INSERT INTO wapNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, uruu Patriot; naꞌiki Judas Iscariot, kaakapaꞌoraz Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aizii Jesus dyuudan naa 12 pazaamataniinao apostlenao nii. Ukakinaowaꞌakan ĩdyaun, ukian, “Aonaa umakoꞌonaꞌa Gentilenao diꞌiti, naꞌiki Samaria Baara sannao, mashaapa-kizi kida donoi diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mazan umako paꞌan õpidanannao Israelitenao diꞌiti, waziwadinainaouz kaznizo kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Umako ukakuwaapaꞌan ukowaada kizi maonapaꞌa naa Tominkaru naobanai-tinan. ");
INSERT INTO wapNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ukakuda karinainao, ukadishita-kida mawakainao powaa iti. Ukakuda baiatinainao kichanaꞌiki-kiaꞌo bishoi idi, naꞌiki uwaata oiaꞌo doronainao pidannao ai. Õtaanii maꞌozaka-kinai uꞌati mawinipinaa-daun, ukauꞌan ushaꞌapataꞌa naazu mawinipinaa-daun. ");
INSERT INTO wapNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Umakon dono, aonaa unaꞌakapaꞌanaꞌa upuraatan umashaapa-kinaa nii; ");
INSERT INTO wapNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","manaꞌa unaꞌakaꞌanaꞌa umako-kizi iti usaakon oo baꞌoran ukamichan oo baꞌoran udazkidi oo uwadookori nii. Ushaꞌapanum kauꞌan pidan kaudinaꞌo, taa-kao nii uꞌati aimaakan uwinipinii. ");
INSERT INTO wapNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ukaawan dono naꞌiaꞌoram donoi oo wiizai diꞌiti, udawata pidan naꞌii. Naꞌiaꞌoram dapaapan an unao, umashaapa ĩdapu ii atii udobatan naꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Umorowautan dono pidannao dapu iti, ukii ĩꞌati, ‘Marii kaiman-karu Tominkaru diꞌikiꞌo naꞌan utuma.’ ");
INSERT INTO wapNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ĩdapaapan dono unao kaiman, marii kaimanaꞌoraz uparadan naꞌian ĩtuma. Mazan ĩmadapaapakan an unao kaiman, ukiwa-kida powaa iti wuruꞌu kaimanaꞌoraz uparadan. ");
INSERT INTO wapNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aizii ĩmadapaapakan dono unao kaiman, oo aonaa ĩabataꞌazon ukuwaa, udobata naꞌiki uparaudaꞌaka imiꞌi ukidiba diꞌiki ĩawunuutapan puꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jesus kian, “Õkowaadaꞌazon mishiꞌo aimaakan uꞌati. Tominkaru kootowapa-kidan donoꞌo naa pidannao, Tominkaru patakaꞌutan nii naꞌiainao pidannao donoi ii, powaꞌa zii wunao aiaꞌa Sodom naꞌiki Gomorrah sannaouz.” ");
INSERT INTO wapNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesus kian koshan, “Uabata, õdyuudan unao naꞌapa kaznizonao dyuuda-kao kawan baudokorunao bii iti. Ukauꞌan uaitapin naꞌapa kowazaz kawan, mazan umashaapa kaiman pidannao tuma orid kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Uzaudinpaꞌa naa paꞌi, ushaꞌapanum kauꞌan pidannao zaamatan nii unao naꞌiki ĩnaꞌakan nii unao kootowapa-kizai iti, naꞌiki ĩbaꞌizian nii unao synagogue ii kida. ");
INSERT INTO wapNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Naꞌiki ĩnaꞌakan nii unao kazowautapainao wiizai kanaapu ati naꞌiki kingnao kanaapu ati õgaru dikin ii. Naꞌapaꞌo idaꞌanaꞌo nii ukowaadan ĩꞌati, naꞌiki baꞌoran pidannao ati, Kaimanaꞌo Kuwai õdauꞌanaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aizii uzaamata-kao dono naꞌiki utiwaa-kidapa-kao dono kootowapa-kizi ii, manaꞌa udopiaꞌanaꞌa udawatan dauꞌu naꞌapam nii ukian. Taa-karu nii uꞌati uaitapa-kinaa nii naꞌapam nii ukian. ");
INSERT INTO wapNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ukauꞌan uparadan an naꞌapain, aonaa unaouꞌo niꞌi naa mani parada, mazan uDaru Tominkaru Doronaꞌo nii parada unao idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Uruu dono pidannao zowii-kidan nii paꞌinawuzunao, naꞌiki daruinao naꞌapaꞌo nii ĩzowii-kidan paudainao. Daniinao kashadapan nii padarunao naꞌiki pudaronao, naꞌiki ĩzowii-kidan nii ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ipai pidannao toꞌora-kizaitapan nii unao õdikin ii. Mazan kanom tuudaꞌo ipai wuru kidaꞌa atii utokon iti, kazannaata-karu nii uruu. ");
INSERT INTO wapNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Upatakaꞌuta-kao dono umishidapan dauꞌan õgaru baudaꞌapaꞌo wiizai diꞌii, ukidoapa baꞌoran wiizai diꞌiti. Õkian mishiꞌo manawun uꞌati, aonaꞌo nii zii ukaudin-kizi ipain Israel an kidaꞌo wiizai an, Daonaiora Aokazi Ikiꞌo kaawan uaꞌii powaa ati. ");
INSERT INTO wapNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aonaa tominpaꞌo pidan umanawunun patiichaan ai, naꞌiki aonaa poitorui umanawunun panaobanaa ai. ");
INSERT INTO wapNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ukauꞌan turuaꞌo wuruꞌu tominpaꞌo pidan tominapanuz patiichaan kawan, naꞌiki poitorui naꞌapa panaobanaa kawan. Kadapuꞌo dakota-kao an Beelzebul kii, aitaniiman udapu ainao pidannao powaꞌaꞌo nii zii ĩdakoapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ukauꞌan aonaa utariaꞌanaꞌa pidannao ai. Ipai dizapa-kariwai, aida-kida-kao niizu, naꞌiki ipai taapa-kariwai kida mashaa, ipaiꞌo nii uaitapa-kida-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wuruꞌu aimaakan õkowaadaniaz unao ati karikaonan, ukowaadaꞌa naa paꞌiz ipai pidannao ati. Kanom aimaakan mashaudaꞌuꞌo õkowaadan uꞌati, ukowaadaꞌa naa paꞌiz diiwaꞌo idaꞌan pidannao abata kiziz. ");
INSERT INTO wapNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Manaꞌa utariaꞌanaꞌa wunao aiaꞌa zowiaꞌoraz pidan, mazan udoronaa, aonaa ĩkaꞌiitan pazowian paꞌan. Mishiꞌoraiman utarii paꞌan Tominkaru ai, kaꞌiitaꞌoraz pakabootan pidan naꞌiki udoronaa Tuubaruꞌo Tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aonaa mooko dyaꞌutamaꞌo parikowarunao toriauzo-kao masakaudaꞌu sodiꞌo puraata idaꞌan karikaonan, mazan upuꞌu aonaꞌo nii baudaꞌapa udaru Tominkaru kashaapan ĩwaotan imiꞌi baara ati. ");
INSERT INTO wapNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Naꞌiki Tominkaru aitapanii ipai naꞌapaudaꞌuꞌoran uzowaud kida uzowau idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ukauꞌan aonaa utariaꞌanaꞌa, ushaꞌapanum kauꞌan powaꞌaꞌo zii umarainapa-kao iribaꞌo parikowarunao ai. ");
INSERT INTO wapNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Naꞌiaꞌoram pidan kowaadaꞌo õpidanan paugaru ipai pidannao kanaapuꞌu, naꞌapaꞌo nii kapam õkowaadan õpidanan uruu, õdaru aokazi iaꞌo kanaapuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mazan naꞌiaꞌoram pidan kowaadaꞌo pamarinaꞌatan õgaru ipai pidannao kanaapuꞌu, naꞌapaꞌo nii kapam õmarinaꞌatan uruu õdaru aokazi iaꞌo kanaapuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Aonaa uzauda-kidaꞌanaꞌa õkaimanaaka-kidaꞌanan mani pidannao paꞌatiaaka wuruꞌu õwaꞌatinuz daꞌatiꞌi imiꞌi baara ati. Õwaꞌatin aonaa õkaimanaaka-kidaꞌanan mani pidannao, mazan õmizaataaka-kidaꞌanan ĩdyaun paꞌatiaaka. ");
INSERT INTO wapNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Õwaꞌatin õpanaꞌadaꞌanan daonaiora nyukunuu padaru ai, zun padaro ai, dinizoi paimauzo ai. ");
INSERT INTO wapNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Puiribannaouꞌo nii manawun wuruꞌu putarubanao niꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Naꞌiaꞌoram pidan marainpaꞌo padaru oo padaro powaꞌa zii pamarainpan ai õgaru, aonaa turuu naꞌapaꞌo pidan daꞌanan õgaru. Naꞌiaꞌoram pidan marainpaꞌo paudani powaꞌa zii pamarainpan ai õgaru, aonaa turuu naꞌapaꞌo pidan daꞌanan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Naꞌiaꞌoram pidan aonaꞌo unaꞌakaꞌazon pacrossannaa, aonaa turuu naꞌapaꞌo pidan daꞌanan oo ukaudinan õtuma. ");
INSERT INTO wapNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Naꞌiaꞌoram pidan aipaꞌo pakakupan paꞌidaꞌa, waziwaꞌo nii karikaonanuꞌoraz kakupa-karu paꞌai. Mazan kanom marinaꞌataꞌo pamashaapauzon kaduz pamishidan dikin ii õgaru, uikodan nii karikaonanuꞌoraz kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Naꞌiaꞌoram pidan kaimanaꞌo udapaapan unao, kaimanaꞌo udapaapan õgaru kapam wuruꞌu; naꞌiki naꞌiaꞌoram pidan kaimanaꞌo udapaapan õgaru, kaimanaꞌo udapaapan wuruꞌu dyuudaꞌoraz õgaru kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Naꞌiaꞌoram pidan dapaapaꞌo prophet, uaitapan idi Tominkaru prophetin uruu, taa-kao nii uwinipa nii naꞌapa prophet kawan. Naꞌiki naꞌiaꞌoram pidan kaimanaꞌo udapaapan kaimanaꞌo pidan, ukaimanan idi, naꞌapaꞌo nii uwinipa nii taa-kao kaimanaꞌo pidan kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Naꞌiki naꞌiaꞌoram pidan taaꞌo wunu baudaꞌapaꞌo õpidanan tuzan nii, aonaan puꞌu padamata umanawunun, mazan õpidanan uruu, mishiꞌo nii ukawinipinaata-kao naꞌapaꞌo dikin ii.” ");
INSERT INTO wapNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus ipaiaꞌakan daunaꞌan patominapa-kidan 12 patominapa-kidaniinao, uruu daunaꞌan umakon naa, utominapa-kidaꞌanan naꞌiki ukakuwaapatinaꞌanan wiizai kida kawanaꞌati, Galilee Baara an kidaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Taraa-kizai iaꞌo John Chikaawunuupauzo, uabatan dono Christ shaꞌapatanii kida dauꞌu, uruu idi udyuudan patominapa-kidaniinao pishaaꞌanan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ĩkaawan donoꞌo naa uꞌidiꞌiti ĩkian uꞌati, “Pukowaada waꞌati, pugaruꞌu naa mishi wuruꞌu waꞌatiꞌo niꞌoraz John kowaadauzoniaz, oo wazaudapa zii baꞌoran?” ");
INSERT INTO wapNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus dakoꞌatin ĩdyaun, ukian, “Umako powaa iti John diꞌiti, ukowaadaꞌan kanom uabatanii naꞌiki utukapanii õshaꞌapatan: ");
INSERT INTO wapNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ishaawunuꞌo, turuu utukapan; machiꞌikakaꞌo, chiꞌika; kabishoꞌo kichanaꞌiki-kiaꞌo bishoi idi, kaiman ubisho manakan; makinaꞌo, abata; mawakaꞌo, kakuda-kao powaa iti; patakaꞌutinaꞌo, abata Kaimanaꞌo Kuwai. ");
INSERT INTO wapNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Konaukiaꞌo nii pidan aonaꞌoraz ukashadan pamishidapan õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John tominapa-kidaniinao kiwan daunaꞌan, Jesus kakuwaapan naa John dauꞌu iribaꞌo pidannao ati. Ukian ĩꞌati, “Umakonkan donoꞌoraz John diꞌii mapidantakaꞌo baara iaꞌoraz, shaꞌapaꞌoram pidan uzauda-kida utukapan naꞌii uruu dono? Pidan, pinidi saba awaru dawuapa-kidanii kawanuꞌo? ");
INSERT INTO wapNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kanom shaꞌa utukapaꞌazon naꞌii umakonkanuz naꞌii? Daonaiora, umanawunuꞌo kamicha kida ukaiwadapanii? Pidan kaiwaadapaꞌoraz naꞌapaꞌo kamicha, mashaapaꞌo umanawunuꞌo kabaun ii. ");
INSERT INTO wapNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ukowaada õꞌati, kanom shaꞌa utukapaꞌazon naꞌii umakonkan dono naꞌii? Tominkaru prophetin shaꞌa? Prophet mishi uruu, mazan powaꞌa zii prophet ai. ");
INSERT INTO wapNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uruu John dauꞌanaꞌo saada-kariwaiz Tominkaru Paradan idaꞌa. Ukianuz. ‘Puabata, õdyuudan pidan puꞌuaꞌati kakuwaapaꞌo nii õꞌati, uruꞌo nii saabaa pumako kizi.’” ");
INSERT INTO wapNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Udaunaꞌan Jesus kian, “Mishiꞌo õkian uꞌati, aonaa naꞌiam pidan shakataꞌo daꞌaꞌa imiꞌi baaraꞌa umanawunuꞌo nii John Chikaawunuupauzo ai. Mazan pidan, aonaꞌoraz umanawunun Tominkaru naobanai-tinapa-kiziꞌi, upuꞌu umanawunuꞌo uruu John ai. ");
INSERT INTO wapNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“John Chikaawunuupauzo sakadan diꞌikiꞌo pakaudinan atii kai, Tominkaru naobanai-tinan tuubarudinan, dikaudaꞌo pidannao tiwaan puꞌu pamashaatanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kiwiitapa John kakuwaapan uaꞌii, ipai kotuaꞌoraz Tominkaru prophetinnao kakuwaapan, naꞌiki kotuaꞌoraz Moses kakinaori kowaadan naꞌapam nii aimaakan shaꞌapan. ");
INSERT INTO wapNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aizii umishidan an wuruꞌu ĩkuwaa kidaz, John, uruꞌu naa wuruꞌu Elijahaz, ĩkowaadaniaz Tominkaru dyuudan nii. ");
INSERT INTO wapNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pukakinaon an puabataꞌa naa kakinaorii! ");
INSERT INTO wapNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Naꞌapam dii mani õkainaabatan kainao pidannao? Naꞌapaꞌo ĩdyaun koraiziannao kawan sakanatapainaouz pamakinaotin-kizi ii, kadakoinpainaouz paꞌatiaaka. ");
INSERT INTO wapNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ĩkian kaikapaꞌa: ‘Watauan puꞌu mazida-karu kunnaa unao ati, mazan upuꞌu aonaa ukonaupan. Wakunuian puꞌu uꞌati baaranai iaꞌo ukunuuauzo-kao, mazan upuꞌu aonaa uzaadan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ukauꞌan naꞌapaꞌo John, sanadinpauzo uruu, naꞌiki aonaa utuzapauzon. Uruu idi pidannao kian udauꞌan, ‘Kainaꞌa oiaꞌo doronai uꞌidaꞌa.’ ");
INSERT INTO wapNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aizii Daonaiora Aokazi Ikiꞌo aroopauzon naꞌiki tuzauzo wine, uruꞌu naa pidannao kian udauꞌan, ‘Aushaa, utukapa arawuꞌu kashabakizi naꞌiki tuzapauzo uruu. Unaudapa pakaminaudaꞌu-tinpan wunao idiꞌi zaamaapauzonaouz tax puraatannaa, naꞌiki baꞌoran oiainao pidannao tuma.’ Tominkaru aitapaaban wuruꞌu tukapa-kida-kariwaiz umishiin wuru idaꞌanaꞌa shaꞌapaapa-kariwaiz.” ");
INSERT INTO wapNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Donoi kida, Jesus shaꞌapata-kiziz iriba umanawun kidaꞌo aimaakan padamata, mazan upuꞌu aonaa naꞌii sannao tanawatinan paꞌoian ai. Uruu idi Jesus aidan paparadan naꞌii sannao mamishidakan dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ukian, “Kashaꞌoraꞌo nii manawun pubaiaapan Chorazin! Pugaru Bethsaida, naꞌapaꞌo nii pubaiaapan kashaꞌoraꞌo manawun! Aizii wuruꞌu umanawun kidaꞌoraz aimaakan shaꞌapata-kariwaiz uꞌidaꞌa, ushaꞌapata-kao an mani Tyre naꞌiki Sidon ii, sariapa mani naꞌii sannao morokodan kamicha kashaꞌora-karu daara kida. Naꞌiki sariapa mani ĩkadadainan paritiꞌi idi, ĩtukapa-kida-kinaa nii mishi patanawatinan paꞌoian ai. ");
INSERT INTO wapNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mishiꞌo õkian uꞌati, awutapaꞌo nii zii Tominkaru patakaꞌutan Tyre naꞌiki Sidon sannao unao ai, wuru kamoo donoꞌo Tominkaru kootowapa-kidanuz naa pidannao. ");
INSERT INTO wapNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Aizii unao Capernaum sannao, uꞌitiiman umanawunuꞌo nii unao aokazi ii? Aonaa, mazan kiiꞌan ukaboota-kao nii Tuubaruꞌo Tikazi wuꞌiti. Wuruꞌu umanawun kidaꞌoraz aimaakan, shaꞌapata-kariwaiz uꞌidaꞌa shaꞌapata-kao an mani Sodom ii, kainaꞌa zii mani wuruꞌu donoiz kai. ");
INSERT INTO wapNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mishiꞌo, ukauꞌan Tominkaru kootowapa-kidan donoꞌo naa pidannao, powaꞌaꞌo nii zii Tominkaru patakaꞌutan unao, Sodom sannao ai.” ");
INSERT INTO wapNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naꞌapain uruu dono Jesus toriinpan, ukian, “Õdaru, aokazi iainao naꞌiki imiꞌi baara ainao naobanaa, õkonaukii-kidan pugaru, ushaꞌapanum kauꞌan putukapa-kidan idiꞌi naa paꞌinainao ĩtominpan ati, pumataapadakaniaz umanawunuꞌo aitapainao aitapan. ");
INSERT INTO wapNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mishiꞌo õdaru, naꞌapa kidaꞌo shaꞌapan puaipan kawanaꞌatiꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aizii Jesus kian ĩꞌati, “Õdaru taanii õꞌati ipai aimaakan paꞌidiꞌiki kidaꞌoraz. Aonaa kanom aitapan õgaru uDaniz, soo õDaru. Naꞌiki aonaa kanom aitapan õDaru, soo õgaru uDani. Naꞌiki pidannao õzaamataniinaouz aitapaꞌo nii uruu. ");
INSERT INTO wapNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Uwaꞌati õꞌidaꞌati ipai unao mizainainao kimishaꞌo padowautapanii idi, õtaan nii sookapa-karu uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uzaamata õdopawa, unaꞌaka kiziz naꞌiki utominapa õꞌidiꞌiki, ushaꞌapanum kauꞌan kaimanaꞌo õnyukunuu naꞌiki aonaa atadinpaꞌo mani wuruꞌu õgaruz. Uruu idi uikodan nii mishiꞌo manawun sookapa-karu. ");
INSERT INTO wapNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wuruꞌu õdopawa õtaan niꞌoraz uꞌati mashaꞌapannaꞌo naꞌiki shaakadaꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aizii Sookapa-karu Kamoon dono, Jesus dobatapan patominapa-kidaniinao tuma zakapu an paoribai wheat baawu an. Naꞌapain utominapa-kidaniinao zamazin naa, uruu idi ĩkaraowaanan wheat aka, naꞌiki ĩnikapaanan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aizii Phariseenao tukapan idi ĩshaꞌapatinanuz naꞌapa, sariapa ĩkian Jesus ati, “Putukapa, putominapa-kidaniinao aonaa ĩizoꞌatin mani wakakinaorinaa wuruꞌu ĩshaꞌapatanuz kaikapaꞌoraꞌa Sookapa-karu Kamoon dono.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus dakoꞌatin ĩdyaun, ukian, “Aonaa mooko utukapauzon kaarita idaꞌaꞌoraz usaadinpan kanom King David shaꞌapatauzonii, tawuru donoꞌo uruu naꞌiki upidanannao zamazin donoꞌoraz? ");
INSERT INTO wapNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Umorotan Tominkaru Dapu nazo iti, naꞌiki unikan papidanannao tuma bread taa-kariwaiz Tominkaru ati. Naꞌapaꞌoraz wazootapa-karu kakinaorii wuruꞌu pidan nikanuz wuruꞌu bread taa-kariwaiz Tominkaru ati. Soo faadaanao karikaonan taapada-kariwaiz ĩnikan wuruꞌu breadiz. ");
INSERT INTO wapNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naꞌiki aonaa mooko uaitapan Moses kakinaori idaꞌaꞌoraz usaadinpan, ukowaadanuz faadaanao shaꞌapata pakaudin-kiz, Tominkaru Dapu ii sookapauzo-karu kamoon dono, mazan upuꞌu aonaa ĩtaapa-kao ĩshaꞌapatan oiaꞌo, ĩmaizoꞌatikan puꞌu kakinaorii? ");
INSERT INTO wapNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Õkowaadan nii uꞌati, diꞌi utumaꞌoraz, powaꞌaꞌo zii umanawunun Tominkaru Dapu ai. ");
INSERT INTO wapNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tominkaru Paradan saada-kariwaiz kian, ‘Kamunanuaba-karu wuruꞌu õaipaniaz, aonaa uzai taa-kariwaiz mani.’ Uaitapan an mani kaimanaiman naꞌapaꞌoram wuruꞌu parada-karuz, aonaa mani udakotan pidannao oiainao nii, mashaꞌapata-kainaouz oiaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ushaꞌapanum kauꞌan Daonaiora Aokazi Ikiꞌo Sookapa-karu Kamoon naobanaa uruu.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Naꞌikiꞌo Jesus makon synagogue iti. ");
INSERT INTO wapNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naꞌii naꞌaꞌo daonaiora, aonaa ukaꞌu kiitinan, mawakaꞌo ukaꞌu. Pabiꞌi kida pidannao naꞌii aipainao pazaamatan Jesus ushaꞌapatinan idaꞌan panaꞌiti kakinaorii ai. Uruu idi ĩpishaanuzu, ĩkian, “Aonaa mani uꞌoian wakakinaorinaa ati pidan kakudan pidan Sookapa-karu Kamoon dono?” ");
INSERT INTO wapNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus dakoꞌatin, ukian ĩꞌati, “Naꞌapa dii mani unao shaꞌapatinan baudaꞌapaꞌo uꞌuza kaznizo waotan an munapoꞌo kaꞌunaru diꞌiti Sookapa-karu Kamoon dono? Aonaꞌo nii mani usoꞌotankanuz naꞌapain? ");
INSERT INTO wapNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aizii pidan mani, powaꞌaꞌo zii umanawunun kaznizo ai. Ukauꞌan aonaa uꞌoian wakakinaorinaa ati, washaꞌapatan kaimanaꞌo Sookapa-karu Kamoon dono.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Uruꞌu naa ukian daonaiora makiitakaꞌo pakaꞌu ati, “Pusawada pukaꞌu.” Sariapa usawadaꞌakanuz, naꞌiki sariapa ukaꞌu kaimanaꞌakan naꞌapa baꞌoran ukaꞌu kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Uruu idi naꞌikiꞌo Phariseenao makon ĩkadakotinaꞌanan paꞌidiwaru sodi, ĩaitapaꞌazon naꞌapam kizi pazowian Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus abatan naa naꞌapam pashaꞌapataꞌazoo-kao, sariapa umakon naꞌiki. Naꞌiki iriba pidannao daꞌananuzu. Uruu dono ipai ukakudan karinainao naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ukakinaowaꞌakan ĩdyaun, aonaa kizi ĩkakuwaapan udauꞌu baꞌorainao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Uruu umishian naa naꞌapaꞌoram Tominkaru kiauzonuz prophet Isaiah idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Diꞌi uruuꞌu õzaamataniaz õpoitoru nii, uruu wuruꞌu õmarainapanii naꞌiki õnyukunuu-atiꞌoraz. Õtaan nii õdoronaa uꞌidaꞌa, naꞌiki ukakuwaapan nii sakitapaꞌo mashaapa-karu Tominkaru tumaꞌo dauꞌu, ipai pabiꞌinaakaꞌo pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Uruu wuruꞌu õzaamataniaz õpoitoru nii, aonaꞌo nii ukadakowaakapauzon, naꞌiki aonaꞌo nii ukadokouzon diiwa. Aonaꞌo nii uparadan diiwaꞌo idaꞌan dunapo an kida. ");
INSERT INTO wapNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aonaꞌo nii umanawutan ramitapaꞌo, naꞌiki aonaꞌo nii umakadan suduupaꞌo upuꞌukapan. Ukauꞌan karikaonanuꞌo nii ukamunanban, atii udikintan nii oii kidaꞌo aimaakan mishiꞌo kaiman-karu idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Naꞌiki uruu atiꞌo nii ipai pidannao donozinaa kida nyukunuu, ĩzaudapan pakazannaata-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Uruu daunaꞌan pidannao naꞌakan Jesus idaꞌati ishaawun naꞌiki maparadanuꞌo pidan, wuruꞌu unaꞌapaitanuz oiaꞌo doronai kainaꞌan idiꞌo idaꞌa. Ukauꞌan Jesus kakuda uruu. Uruu idi kaimanaꞌa naa uparadan, naꞌiki kaimanaꞌa naa utukapan. ");
INSERT INTO wapNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tuukii pidannao diꞌitinpan Jesus shaꞌapatanii kida dauꞌan. Uruu idi ĩkian, “David Takaan-daun mani arawuꞌu?” ");
INSERT INTO wapNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aizii Phariseenao abatan idi ĩnaꞌapan, sariapa ĩkian paꞌatiaaka, “Oiaꞌo doronainao naobanaa Beelzebul taan idiꞌo umaꞌozaka-kinaa nii wuruꞌu uwaatanuz oiaꞌo doronainao.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus aitapa naꞌapaꞌoram ĩdiꞌitinpan. Uruu idi ukian ĩꞌati, “Baudaꞌapaꞌo wiizai idaꞌaꞌa pidannao mashaapan, ĩmizaataakapan an paꞌatiaaka, aonaꞌo nii wiizai naꞌan kotuaꞌiki. Naꞌiaꞌoram pidannao donoi ainao, ĩmashaapan an buutaaka pairibannao ai, naꞌiki ĩmizaataakapan an paꞌatiaaka, aonaꞌo nii donoi naꞌan kotuaꞌiki. Naꞌiaꞌoram pidannao mashaapainao baudaꞌapaꞌo kabaun idaꞌa buutaakapan an pairibannao ai, naꞌiki ĩmizaataakapan an paꞌatiaaka, aonaꞌo nii ĩmashaapan baokopa kotuaꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aizii Satan waatan an papoitorunao oiaꞌo doronainao, ĩbuutaakapan naꞌiki ĩmizaataakapan paꞌatiaaka wuruꞌu. Ukauꞌan aonaꞌo nii Satan naobanai-tinpan kotuaꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Unao, ukian õwaatan oiaꞌo doronainao, oiaꞌo doronainao naobanaa Beelzebul taan idaꞌanaꞌo õmaꞌozaka-kinaa nii. Mazan kanom taaꞌoraz mooko unao pidanannao ati ĩmaꞌozakannaa nii, ĩkaboota-kinaa nii oiaꞌo doronainao? Beelzebul? Aonaa. Ukauꞌan uruu naꞌapa kidaꞌoraz kainaabata uꞌati, naꞌapaꞌoram wuruꞌu upozawatapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mazan wuruꞌu õwaatanuz oiaꞌo doronainao paꞌan Tominkaru taanii idaꞌanaꞌo õꞌati padoronaa õmaꞌozakannaa nii, naꞌapaꞌo kainaabata kainaꞌaꞌa naa Tominkaru naobanai-tinan ubiiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kaikapaꞌo kawanuꞌo wuruꞌu: Aonaa naꞌiaꞌoram pidan kaꞌiitaꞌo nii pamorotinan maꞌozakaꞌo daonaiora dapu, unaꞌakaꞌazon an ushaꞌapauz kida uꞌai udapu iki, soo udodowan nii zii wuruꞌu maꞌozakaꞌoraz pidan kiwiin. Uruu udaunaꞌan turuaꞌo niꞌi naa unaꞌakan ushaꞌapauz kida udapu iki. ");
INSERT INTO wapNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Naꞌiaꞌoram pidan aonaa õꞌidaꞌatanpuꞌu mani, õtaruba uruu. Naꞌiaꞌoram pidan aonaꞌo ukasabaꞌuupan õtuma, pararaa-biꞌitaꞌo õkasabaꞌuunii wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Ukauꞌan õkowaadan uꞌati, shaꞌapaꞌoram pidan shaꞌapatan an oiaꞌo pairiban ati, naꞌiki udakoopan Tominkaru, marinaꞌata-karu nii wuruꞌu uꞌoianuz uꞌai. Mazan udakoopan an Kaimanaꞌo Doronaa, aonaꞌo nii uꞌoian marinaꞌata-kao uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Naꞌiaꞌoram pidan dikaudaꞌo uparadan Daonaiora Aokazi Ikiꞌo dauꞌan, marinaꞌata-karu nii uꞌoian uꞌai, mazan naꞌiaꞌoram pidan dakoopaꞌo Kaimanaꞌo Doronaa, aonaꞌo nii naꞌapainim uꞌoian marinaꞌata-kao uꞌai, kai oo diinaꞌitiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Puaipan an kaimanaꞌo paoribai aka, ziwuꞌo uaipan pupaoriba. Paoribai maziwukan dono, dikaudaꞌo nii uꞌaka. Aitapa-kariwai ziwuꞌo paoribai paꞌaka idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Unao kichanaꞌiki-kiaꞌo kowazaz, aonaa naꞌitim uparadan kaimanan. Kanom nyukunui iaꞌoraz utaapa-kao kida, uruꞌo nii kodita-kida-kariwaiz. ");
INSERT INTO wapNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaimanaꞌo pidan, ukodita-kidan nii kaiman kidaꞌo aimaakan, pataapanii panyukunuu kaimanan diꞌiki. Dikaudaꞌo pidan, ukodita-kidan nii dikauda kidaꞌo aimaakan, pataapanii panyukunuu dikaudan diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aizii õkowaadan uꞌati, Tominkaru kootowapa-kidan donoꞌo naa pidannao, ĩkootowapa-kida-kao nii ipai dikauda kidaꞌo paparadauzonii dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ushaꞌapanum kauꞌan uparadauzonii kida idaꞌanaꞌo nii ukainaabatinan, kaimanaꞌo unao oo oiaꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Udaunaꞌan pabiꞌi kida Phariseenao naꞌiki tiichaapauzonao Moses kakinaori dauꞌu kian Jesus ati, “Tiichaa, watukapaꞌazon pushaꞌapatan umanawunuꞌo aimaakan kainaabataꞌo nii Tominkaru diꞌikiꞌo pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus dakoꞌatin ĩdyaun, ukian ĩꞌati, “Soo oiaꞌo naꞌiki maizoꞌati-kainao pidannao wuruꞌu tukapaꞌazoꞌoraz aimaakan kainaabata-kao paꞌati. Aonaꞌo nii kanom idaꞌan ukainaabata-kao uꞌati, soo prophet Jonah idaꞌanaꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah naꞌian kawan udaruꞌo kopau toba nazo ii idikinaudaꞌu kamoo naꞌiki idikinaudaꞌu marutaꞌo. Naꞌapaꞌo nii Daonaiora Aokazi Ikiꞌo naꞌian kapam idikinaudaꞌu kamoo naꞌiki idikinaudaꞌu marutaꞌo imiꞌi kaꞌazo ii. ");
INSERT INTO wapNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pidannao Nineveh sannao kadishitan nii wuru kamoo donoꞌo, Tominkaru kootowapa-kidanuz ipai pidannao, naꞌiki ĩdakoopan nii kainao pidannao, ushaꞌapanum kauꞌan ĩnao ĩtanawatinanii paꞌoian ai Jonah kowaadan dono ĩꞌati Tominkaru paradan. Mazan diꞌoraꞌa pidan utumaꞌoraz, powaꞌaꞌo zii umanawunun Jonah ai. ");
INSERT INTO wapNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sheba ikiꞌo Queen naobanaiaba kadishitan nii wuru kamoo donoꞌo, Tominkaru kootowapa-kidanuz ipai pidannao, naꞌiki odakoopan nii kainao pidannao, ushaꞌapanum kauꞌan owaꞌatinii munapoꞌo amazada tokon ikinapu, oabataꞌazon idi Soloman aitapaaban dauꞌu. Mazan diꞌoraꞌa pidan utumaꞌoraz powaꞌaꞌo zii umanawunun Soloman ai. ");
INSERT INTO wapNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Naꞌapainim oiaꞌo doronai koditan pidan diꞌiki, umakon nii amazada aradaꞌo diꞌiiꞌaka, udorotapan naa pamashaapa-kizi nii. Aizii aonaan dono uikodan pamashaapa-kizi nii, ");
INSERT INTO wapNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","uruꞌu naa ukian paaipan ati, ‘Õkiwan nii powaa iti õdapu iti.’ Uruu idi ukiwan naa powaa iti, naꞌiki uikoda wuruꞌu padapuz aonaa kanom mashaapaꞌo nii naꞌii, kaiman uparaudapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Uruu idi umakon unaꞌanan 7 baꞌoran oiaꞌo doronainao powaꞌaꞌo zii manawun ĩdikaudan kida paꞌai. Uruu idi ĩmorotan naꞌiki naꞌiaꞌa naa ĩmashaapan. Uruu daunaꞌan powaꞌaꞌo nii zii pidan dikaudaꞌakan kiwiiniꞌo ai. Ukauꞌan naꞌapaꞌo wuruꞌu oiainaouz pidannao kaiꞌoraz naa ĩmashaapan.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus kadakotinan puꞌu zii pidannao ati, udaro naꞌiki uꞌinawuzunao kaawaꞌakan naꞌiti, ĩkadishitapan paniba ii ĩparadaꞌazon uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Uruu idi baudaꞌapa pidan naꞌiaꞌo kian Jesus ati, “Putukapa, pudaro naꞌiki puꞌinawuzunao paniba ii, ĩparadaꞌazon puꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus kian uꞌati, “Kanom õdaro nii, kanom õꞌinawuzunao nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Usawadan pakaꞌu patominapa-kidaniinao diꞌiti naꞌiki ukian, “Diꞌi õdaro naꞌiki õꞌinawuzunao. ");
INSERT INTO wapNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kanom shaꞌapatinaꞌo õdaru aokazi iaꞌo aipan kawanaꞌati, ĩnao wuruꞌu õdadakoo, õꞌinawuzu naꞌiki õdaro.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Naꞌapain uruu kamoo dono, Jesus makon naꞌiaꞌo kabaun diꞌiki karishii zaꞌiti, naꞌiki naꞌii usakanatan udanoma ii. ");
INSERT INTO wapNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iriba pidannao kasabaꞌukinan uꞌidaꞌati, uruu idi upaidinan kanawa zoꞌiti, naꞌiki usakanatan naꞌii pidannao naꞌian puꞌu karishii zaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Udaunaꞌan uparadan, ukaiwaa diꞌitinapa-kinai kuwai kida, patominapa-kida-kinaa nii ĩdyaun. Ukian, “Baukapaiman, pidan makon pazakapun iti upaopaꞌanan papaoriba uuda kida. ");
INSERT INTO wapNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pabiꞌi kida upaoriba uuda upararaanii kida waotan dobaapa-kizai an, kotuꞌuznao kaawan naꞌiti, sariapa ĩnikanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Baꞌoran kida upararaan kubataꞌo imiꞌi idaꞌan. Kadiman usodaꞌakan padamata, mazan kamoo wiichaꞌakan idi, sariapa uzowian wuruꞌu sodaꞌakaꞌoraz zii paoribai sodi kida. Ushaꞌapanum kauꞌan aonaa naꞌitim uꞌishatabaꞌu zaamatinan. ");
INSERT INTO wapNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pabiꞌi kida upaoriba uuda waotan kaiwada-karu bii an. Sariapa ukauꞌan kaiwada-karu bazobatanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mazan pabiꞌi upararaanii papaoriba uuda kida kaimanaꞌo imiꞌi idaꞌan. Uruu idi ukaakan powaꞌa zii ukaꞌuudan diriꞌi kida, baꞌoran kida ukaꞌuudan diriꞌi kida manawun. ");
INSERT INTO wapNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pukakinaon an puabataꞌa naa kakinaorii!” ");
INSERT INTO wapNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Uruu daunaꞌan patominapa-kidaniinao pishaan Jesus. Ĩkian uꞌati, “Kanom nii pukakuwaapan pidannao ati diꞌitinapa-kinai kuwai kida idaꞌan?” ");
INSERT INTO wapNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Udakoꞌatin ĩdyaun, ukian, “Unao atiꞌo karikaonan utaa-kao wuruꞌu aitapaaba-karuz Tominkaru naobanai-tinpan dauaꞌoraz aonaꞌoraz uaitapanata-kao, mazan wunao atiꞌi, aonaa utaa-kao wuruꞌu aitapaaba-karuz. ");
INSERT INTO wapNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ukauꞌan pidan kainaꞌaꞌo aimaakan uꞌidaꞌa, aimaakan taa-karu nii diriꞌi powaꞌa zii uꞌati. Uruu idi powaꞌaꞌo nii zii udiriꞌin uꞌidaꞌa. Powaꞌa zii manawun udiriꞌin uaiapa-kao ai. Mazan wuruꞌu pidan, aonaꞌoraz kanom uꞌidaꞌa, kanom masakaudaꞌu sodiꞌi uꞌidaꞌa, kazata-karu nii uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Uruu idiꞌo õkaiwaan wuruꞌu diꞌitinapa-kinai kuwai kidaz õkakuwaapan dono ĩꞌati. Uruu idi awunuutapa padamata ĩdyaun, mazan aonaa ĩtukapan, naꞌiki ĩabatapan padamata, mazan aonaa ĩabatan, naꞌiki aonaa ĩaitapan. ");
INSERT INTO wapNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ĩnao ukauꞌan wuruꞌu mishiaꞌoraz Tominkaru poitoru Prophet Isaiah paradan. Ukianuz kaikapaꞌa: ‘Uabatapan nii mazan aonaꞌo nii uaitapan uabatanii, uawunuutapan nii padamata, mazan aonaꞌo nii utukapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ushaꞌapanum idi wuruꞌu pidannaouz ĩdadaradan panyukunuu, aonaa ĩabataꞌazon naꞌiki aonaa ĩtukapaꞌazon. Mazan ĩtukapaꞌazon an mani, ĩabataꞌazon an mani, naꞌiki ĩaitapan an mani kaiman panyukunuu ii, uruu idi ĩtanawatin mani õꞌidaꞌati, naꞌiki õkakuda mani ĩdyaun.’ Tominkaru kian. ");
INSERT INTO wapNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kaiman zii unao ati, utukapan idi uawun idi, naꞌiki uabatan idi ukinao idi. ");
INSERT INTO wapNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mishiꞌo õkian uꞌati. Iriba Tominkaru prophetinnao naꞌiki kotuaꞌo kaimanainao pidannao, tuukiaꞌo padamata ĩtukapaꞌazon wuruꞌu utukapaniaz ushaꞌapata-kao, mazan aonaa ĩtukapanuzu. Naꞌiki ĩabataꞌazon uabatanii, mazan aonaa ĩabatauzonuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Aizii uabatapa uaitapa kizi naꞌapam õkainaabatan paopaꞌo dauaꞌoraz kuwai. ");
INSERT INTO wapNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pidannao abatainaouz kuwai, Tominkaru naobanai-tinan dauꞌan, mazan aonaa ĩaitapanuz. Ĩnao naꞌapaꞌo uudai kawan pararaa-kariwaiz dobaapa-kizai an. Satan kaawaꞌakan naꞌan, mashaꞌapannaa uzaamataꞌakan wuruꞌu paowa-kariwaiz naꞌan kida. ");
INSERT INTO wapNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uudai kida pararaa-kariwaiz kuba baawu an, kainaabata naꞌapaꞌo pidannao, ĩabatan dono sodiꞌo karikaonan, ĩkonaukii-kidaꞌakan Tominkaru dauaꞌoraz kuwai. ");
INSERT INTO wapNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mazan aonaa ĩtaapan kuwai kaimanaiman paꞌidaꞌa, uruu idi aonaa umashaapan kotuaꞌiki ĩꞌidaꞌa. Ukauꞌan naꞌapainim ĩbaiaapan dono oo ĩpatakaꞌuta-kao kuwai dikin ii, sariapa ukaakinpan. ");
INSERT INTO wapNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aizii uudai kida pararaa-kariwaiz kaiwada-karu baawu an, kainaabatan naꞌapam pidannao abatainaouz kuwai padamata. Mazan ĩdiꞌitinpan aimaakan aiapa-kao dauꞌu, naꞌiki kashaꞌapauzi-karu dauꞌu. Uruu idi ĩmanyukunuutan naa wuruꞌu kuwaiz. Naꞌiki aonaꞌa naa ĩshaꞌapainpan kaiman kuwai kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Naꞌiki wuruꞌu uudai kida paowa-kariwaiz kaimanaꞌo imiꞌi idaꞌan, uruu kainaabatan wunaouꞌu abatainaouz kuwai naꞌiki kaiman ĩaitapanuz. Uruu idi ĩmashaapan naa ukawanaꞌati, pakaꞌiitinan kawanaꞌati kida, naꞌapa paoribai kida kawan kaakaꞌoraz kaiman, baꞌoran kaakan powaꞌa zii udiriꞌin kida.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aizii Jesus kowaadan baꞌoran diꞌitinapa-kinai kuwai ĩꞌati. Ukian, “Kaikapaꞌo wuruꞌu Tominkaru naobanai-tinapanuz: pidan paowan kawan kaimanaꞌo paoribai uuda kida pazakapun ii. ");
INSERT INTO wapNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aiwakaꞌan ipai pidan daꞌawun puꞌu, utaruba kaawan uzakapun ii. Upaowankan kazamakaꞌo uuda kida upaoriba wheat bii an, udaunaꞌan umakoꞌokan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Paoribai sodan donoꞌo naa naꞌiki ukaakan donoꞌo naa, kainaꞌa kazamakaꞌo kida sodan ĩbii an kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Upoitorunao kaawan uꞌidaꞌati, naꞌiki ĩkian uꞌati, ‘Naobanai, kaimanaꞌo paoribai uuda kida shaꞌatii pupaowanii, mazan diinaꞌaꞌa naa kazamakaꞌo kida aidinanuꞌu.’ ");
INSERT INTO wapNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“‘Õtaruba wuruꞌu paowankaꞌoraz naꞌapaꞌo,’ ukian ĩꞌati. “Upoitorunao kian uꞌati, ‘Puaiapa wasoꞌotan wuruꞌu kazamakaꞌoraz?’ ");
INSERT INTO wapNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“‘Aonaa,’ ukian ĩꞌati. ‘Panaadon usoꞌotan dono kazamakaꞌo, usoꞌotan nii paoribai kida kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Marii zii paoribai naꞌiki kazamakaꞌo sawatan baokopa atii paoribai dukutapa-kao dono. Aizii udukutapa-kao uaꞌii, õdyuudan nii dukutapainao soꞌotan kazamakaꞌo naꞌiki ĩkasabaꞌuunuzu, naꞌiki udaunaꞌan marii ĩkawaodanuzu. Mazan õpaoriba aka, õdyuudan nii ĩsaabaanuz padapunaa diꞌiti.’” ");
INSERT INTO wapNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus kowaadan ĩꞌati baꞌoran diꞌitinapa-kinai kuwai. Ukian, “Kaikapaꞌo wuruꞌu Tominkaru naobanai-tinapanuz: mustard uuda paowa-kao kawan zakapu ii. ");
INSERT INTO wapNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wuruꞌu mustard uudaz, uruu duusodiꞌo manawun ipai baꞌoran paoribai uuda kida ai. Mazan usodan dono, udyaupain nii udaru baꞌoran paoribai kida ai. Udaruꞌo paoribai nii utominan, uruu idi kotuꞌuznao kaawan ĩkashimakainpan uwaoda an kida.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus kowaadan ĩꞌati powaꞌa zii baꞌoran diꞌitinapa-kinai kuwai. Ukian, “Kaikapaꞌo wuruꞌu Tominkaru naobanai-tinapanuz: pidan muudan kawanuꞌo masakaudaꞌu yeast diriꞌiꞌo poroom-biꞌiti, atii upoodadan ipai diriꞌiꞌoraz poroom.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus kaiwaan diꞌitinapa-kinai kuwai kida pakakuwaapa-kinaa nii iribaꞌo pidannao ati. Aonaa naꞌapainim ukakuwaapauzon ĩꞌati makaiwaaka-daun uruu kaduz kuwai. ");
INSERT INTO wapNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ukakuwaapauzon naꞌapa umishii-kinaa Tominkaru prophetin kianuz. “Õkaiwaan nii diꞌitinapa-kinai kuwai kida õparadinan dono ĩꞌati. Õkowaadan nii ĩꞌati aimaakan kida aonaꞌo ĩaitapauzo-kao kida, amazada tominan diꞌikiꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesus makoꞌokan daunaꞌan iribainnao pidannao diꞌiki, uruꞌu naa umorotan kabaun nazo iti. Utominapa-kidaniinao kaawan uꞌidaꞌati, naꞌiki ĩkian uꞌati, “Pukowaada waꞌati naꞌapaꞌoram wuruꞌu diꞌitinapa-kinai kuwai kainaabataniaz zakapu iaꞌo kazamakaꞌo dauaꞌoraz.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus kian ĩꞌati, “Wuruꞌu paowaꞌoraz kaimanaꞌo paoriba uuda kida, uruu Daonaiora Aokazi Ikiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wuruꞌu zakapuz, uruu imiꞌi baara. Kaimanaꞌo paoribai uuda kida, uruu pidanannao naobanaitapainao niꞌo Tominkaru. Wuruꞌu kazamakaꞌoraz, uruu Satan pidanannao. ");
INSERT INTO wapNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Naꞌiki wuruꞌu utarubaz paowankaꞌoraz kazamakaꞌo, uruu Satan. Wuruꞌu paoribai soꞌotapa-kao, uruu amazada katokon-tinan dauꞌanaꞌo. Soꞌotapainaouz paoribai, ĩnao angelnao wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aizii wuruꞌu kazamakaꞌo kasabaꞌuu-kaoaz naꞌiki ukawaoda-kaoaz, naꞌapaꞌo nii aimaakan shaꞌapan diꞌoraꞌa amazada katokon-tinan dono. ");
INSERT INTO wapNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Daonaiora Aokazi Ikiꞌo dyuudan nii papoitoru angelnao kabootaꞌanan panaobanai-tinapa-kizi ai ipai aimaakan shaꞌapata-kidaꞌoraz oiaꞌo pidannao ati, naꞌiki ipai shaꞌapatainaouz oii kidaꞌo, ");
INSERT INTO wapNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ĩkabootan nii ĩdyaun Tuubaruꞌo Tikazi wuꞌiti. Naꞌiaꞌo nii ĩzaadan tuukii naꞌiki ĩkuzowan nii paudako padopian idi. ");
INSERT INTO wapNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mazan kaimanainao, Tominkaru pidanannaouz, ĩkanadapan nii naꞌapa kamoo kawan paDaru naobanai-tinapa-kizi ii. Pukakinaon an puabataꞌa naa kakinaorii!” ");
INSERT INTO wapNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Kaikapaꞌo wuruꞌu Tominkaru naobanai-tinapanuz: kawinipinaꞌo aimaakan dizapa-kao kawan zakapu ii. Pidan ikodanuzu, sariapa udidaꞌakan powaa itiz. Tuukii ukonaukian, uruu idi usellian ipai pashaꞌapauz. Udaunaꞌan utorian wuruꞌu zakapuz paꞌidiwau nii. ");
INSERT INTO wapNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kaikapaꞌo kapam wuruꞌu Tominkaru naobanai-tinapanuz: pidan dorotapaꞌo kawan kawinipinaꞌo aimaakan, pearl kiaꞌo uꞌuu. ");
INSERT INTO wapNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aizii uikodan dono baudaꞌapa dobataꞌo uwinipinaa, uruꞌu naa uselliaꞌanan ipai pashaꞌapauz, naꞌiki utorian naa wuruꞌu pearl pashaꞌapauz winipinaa idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kaikapaꞌo kapam wuruꞌu Tominkaru naobanai-tinapanuz: naꞌapaꞌo kopautapainao sairoopan kawan karishii ii, naꞌiki ĩzaamatan pabiꞌinaaka kopau. ");
INSERT INTO wapNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aizii ĩsairon paidan donoꞌo naa, ĩmaaratan naazu unaawa iti, naꞌiki ĩwidauan naa wuruꞌu kopau kidaz. Kaiman kidaꞌo kopau, ipai ĩpaidan pakinnaa kida zoꞌiti. Mazan dikauda kidaꞌo kopau, aonaa ĩaipan, ipai ĩkabootan kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Naꞌapaꞌo nii diꞌoraꞌa amazada katokon-tinan dono. Angelnao makon nii diꞌitinapa kidaꞌa ĩwidauaꞌanan oiainao pidannao kaimanainao pidannao ai. ");
INSERT INTO wapNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Naꞌiki ĩkabootan nii ĩdyaun Tuubaruꞌo Tikazi wuꞌiti, naꞌiaꞌo nii ĩzaadan tuukii naꞌiki ĩkuzowan nii paudako padopian idi.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aizii Jesus kian ĩꞌati, “Uaitapa naꞌapaꞌoram dauꞌatiꞌo kaiwuruꞌu õkuwaa kidaz?” “Oo,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naꞌiki ukian ĩꞌati, “Ukauꞌan pidan tiichaapauzo Moses kakinaori dauꞌu, aitapaꞌoraz naa kapam Tominkaru naobanai-tinpan dauꞌu, naꞌapaꞌo uruu pidan kawan saabaaꞌo umanawun kidaꞌo aimaakan, kotuꞌu kidaꞌo naꞌiki paꞌinaa kidaꞌo aimaakan pakaiwaan nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus makoꞌokan naa paipaian daunaꞌan pakakuwaapan diꞌitinapa-kinai kuwai idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ukiwan padyaupai-kizi donoi iti. Naꞌiaꞌa naa utominapa-kidan pidannao synagogue ii. Aizii abatainaouz ukakuwaapan, tuukii ĩdiꞌitinpan, naꞌiki ĩkian, “Naꞌikiꞌoram uikodan wuruꞌu aitapa-karuz, naꞌiki wuruꞌu umanawun kidaꞌoraz shaꞌapainapa-karu? ");
INSERT INTO wapNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aonaa mooko uruu mani carpenter daniz? Aonaa mooko Mary mani udaro nii? Naꞌiki aonaa uꞌinawuzunao mani James, Joseph, Simon naꞌiki Judas? ");
INSERT INTO wapNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aonaa udadakoonao mani watumainaouz? Naꞌapa dii mooko ukaꞌiitan pashaꞌapatan ipai kaikapa kidaꞌoraꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Uruu idi pidannao toꞌora-kizaitapanuz. Jesus kian ĩꞌati, “Ipai naꞌiaꞌakan prophet taapa-kao umanawunuꞌo nii, mazan pawiiziꞌi naꞌiki pairibannao biiꞌi, aonaa utaapa-kao naꞌapa.” ");
INSERT INTO wapNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ĩmamishidakan idi, aonaa Jesus shaꞌapatan iriba umanawun kidaꞌo aimaakan naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naꞌapain uruu dono King Herod abatan kuwai Jesus dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Uruu idi ukian paminkaꞌunao ati, “Uruu John Chikaawunuupauzo wuruꞌu kakudaꞌoraz pamawaka-kizi iki. Uruu idiꞌo wuruꞌu ukaꞌiitanuz pashaꞌapatan umanawun kidaꞌo aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ushaꞌapanum idi unaꞌapanuz Herod zaamata-kidauzonii daꞌi John, udodoo-kidanuzu naꞌiki ukaboota-kidanuzu taraa-kizai diꞌiti. Ushaꞌapanum idi John paradauzonii uꞌati uꞌinawuzu Philip daiaro Herodias dauꞌan. Ukian uꞌati, “Kakinaorii kian kawanaꞌati, aonaa ukaimanan pumazidan otuma.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod zowii-kidaꞌaka mani padamata John naꞌapain, mazan utarian Jewnao ai, ĩmishidan idi Tominkaru prophetin wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mazan Herod shakatan kamoon konaukii-kida-kao donoꞌo naa, Herodias dani zunaaba konaupan ipai pidannao naꞌiainao kanaapu ati. Tuukii Herod konaukii-kidanuzo. ");
INSERT INTO wapNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ukauꞌan ukowaadan mishiꞌo nii utaan kanom opishaa nii uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Uruu idi okian Herod ati padaro dyuudan kawanaꞌati naꞌapam nii okian. “Putaa õꞌati John Chikaawunuupauzo zowau daꞌaꞌa paraapa zoꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tuukii king dopiaꞌakan, unyukunuu kashaꞌoran, mazan utaan idi paparadan oꞌati patawaraidanao abatapan puꞌu, uruu idi udyuudan naa opishaaniaz taa-kao oꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ukauꞌan udyuudan naa John kanau dukuta-kao taraa-kizai ii. ");
INSERT INTO wapNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Udaunaꞌan uzowau naꞌaka-kao paraapa zoꞌan, naꞌiki utaa-kao oꞌati. Uruꞌu naa onaꞌakanuzu padaro diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Udaunaꞌan John tominapa-kidaniinao naꞌakan naa John nanaa, naꞌiki ĩdidaꞌanan naazu. Udaunaꞌan ĩkowaadaꞌanan naa udauꞌan Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Aizii Jesus abatan daunaꞌan John zowii-kao, sariapa umakon naꞌiki kanawa zoꞌan, pidan aonaa-kizi itinapu, patominapa-kidaniinao tumaꞌo paꞌidiwaru uaipinan naꞌii. Mazan pidannao abata Jesus makon, uruu idi ĩmakon pawiizi iki kida, pakidiba idaꞌan ĩdaꞌananuzu unaawa an. ");
INSERT INTO wapNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus maaratinan kanawa diꞌiki, utukapa iriba pidannao. Tuukii ukashaꞌoran ĩdauꞌan, naꞌiki ukakuda ipai karinainao. ");
INSERT INTO wapNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Uruu wachuupunin utominapa-kidaniinao waꞌatin uꞌidaꞌati. Ĩkian uꞌati, “Wachuupun naa wuruꞌu, naꞌiki amazadaꞌaꞌo karikaonan wuruꞌu waunaouz. Ukauꞌan pudyuudaꞌa naa shoman pidannao ĩmako kizi wiizai kida diꞌiti ĩtoriiꞌan kizi pawanyukunuu nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mazan Jesus kian ĩꞌati, “Aonaa kanom nii ĩmakon diꞌikiꞌi. Utaa ĩwanyukunuu nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Kainaꞌa waꞌidaꞌa bakaꞌiaudaꞌu breadnao naꞌiki dyaꞌutam kopaunao sodi kida karikaonan,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naꞌiki Jesus kian ĩꞌati, “Ukauꞌan unaꞌaka daꞌatizuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Uruꞌu naa Jesus dyuudan pidannao sakanatan pinid paawa an. Udaunaꞌan Jesus zaamatan wuruꞌu bakaꞌiaudaꞌuꞌoraz breadnao naꞌiki dyaꞌutamaꞌoraz kopaunao, uawunuupan aokazi iti utoriinpan. Ukian, “Kaimanaꞌo pugaru Tominkaru, putaan idi wawanyukunuu nii.” Naꞌiki udushowan naa kidaz, utaanuzu patominapa-kidaniinao ati. Ĩnaouꞌu naa taa iribainao pidannao ati kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ipai pidannao aroopan abaapa kida. Udaunaꞌan Jesus tominapa-kidaniinao zawadan 12 dazowan kida wanyukunui waꞌakun. ");
INSERT INTO wapNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Naꞌapainiꞌoraz aroopainaouz ikoda mani 5,000 daonaioranao naꞌiki iribaꞌo kapam naꞌii zunnao naꞌiki koraiziannao, mazan aonaa ĩaita-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Udaunaꞌan Jesus dyuudan patominapa-kidaniinao taraukan kanawa zoꞌan powaa iti udaruꞌo karishii baza iti, udyuudan puꞌu kapam iribainnaouz pidannao. ");
INSERT INTO wapNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Udaunaꞌan umakon pabaꞌoran utoriinpaꞌanan naawaz paawa iti. Pabaꞌoran uchuapadan naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aizii kanawa idaꞌanainaouz munapoꞌo naa ĩmakoꞌokan udaruꞌo karishii an. Uruꞌu naa awaru maꞌozakaꞌo kaawan, uruu idi udaawadaan ĩkanawan. ");
INSERT INTO wapNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wakanadaꞌanan diꞌiti Jesus waꞌatipan chiꞌikapa wunu paawa an patominapa-kidaniinao idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ĩtukapankanuz, tuukii ĩtarian uꞌai uchiꞌikapan idi wunu paawa an. “Waꞌati doronai!” ĩkian. Ĩkadakoꞌokan patarian idi. ");
INSERT INTO wapNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Upuꞌaꞌa naa mazan Jesus paradaꞌakan ĩꞌati. “Õgaru wuruꞌu, aonaa utariaꞌanaꞌa õꞌai,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","“Õnaobanaa,” Peter kiaꞌakan. “Pugaru mishi manawun kaiwuruꞌu, ukauꞌan pudapada õgaru, õmako kizi wunu paawa an puꞌidiꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Puwaꞌati,” Jesus kian uꞌati. Uruꞌu naa Peter maaratinaꞌakan kanawa diꞌiki, umakoꞌokan naa chiꞌikapa wunu paawa an Jesus diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mazan Peter tukapankan naa naꞌapam maꞌozakaꞌo awaru toman udaru kida wunu paran, sariapa utariidinaꞌakan. Uruꞌu naa utipitaꞌanaꞌakan. Ukadakon Jesus ati patarian idi. “Kadiman õNaobanaa, pukaminkaꞌuta õgaru,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sariapa Jesus zaamatanuz, naꞌiki ukian uꞌati, “Oo pidan, mapasaka mooko pumishidautapan. Kanom nii mooko aonaa pumishidan kaimanaiman?” ");
INSERT INTO wapNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesus naꞌiki Peter paidinaꞌakan naa kanawa zoꞌiti. Sariapa awaru maꞌozakaꞌoraz mashaadaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Uruu idi utominapa-kidaniinao taapan uruu umanawunuꞌo nii. Ĩkian uꞌati, “Mishiꞌo mishi pugaru Tominkaru Dani.” ");
INSERT INTO wapNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ĩmaaratinan donoꞌo naa patarauka-kizi iki udaruꞌo karishii, ĩkaawan Gennesaret Baara ii. ");
INSERT INTO wapNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Naꞌiainao pidannao aitapan idi Jesus kaawan, ĩdyuudan paparadan naꞌan kidaꞌo wiizai kawanaꞌati, marii kizi pidannao naꞌakan ipai karinainao Jesus idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ĩdopian Jesus ati, ĩpishaanuzu marii kizi karinainao pishatan ukamichan danoma karikaonan. Ipai pishatainao ukamichan kakudan. ");
INSERT INTO wapNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aizii pabiꞌi kida Phariseenao naꞌiki tiichaapauzonao kakinaori dauꞌu kaawan Jerusalem iki, Jesus idaꞌati. Naꞌiki ĩpishaan uruu. Ĩkian uꞌati, ");
INSERT INTO wapNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kanom nii aonaa putominapa-kidaniinao shaꞌapatan kotuaꞌo wadokozu-daunnao tominapa-kidan kawanaꞌati waunao? Aonaa ĩchikaan pakaꞌu paaroopan uaꞌii wakaduz kawanaꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus kian ĩꞌati, “Kanom nii mooko umaizoꞌatikan Tominkaru Paradan udaꞌanaꞌazon idi udokozu-daunnao kaduz karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tominkaru Paradan kian puꞌu padamata, ‘Pumarainapa pudaru naꞌiki pudaro.’ Aizii ukian koshan, ‘Naꞌiaꞌoram pidan dakoopaꞌo padaru oo padaro, marii uzowii-kao.’ ");
INSERT INTO wapNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mazan unao, utominapa-kidan pidannao, turuu pidan kian padaru naꞌiki padaro ati, ‘Kainaꞌa aimaakan õꞌidaꞌa õkaminkaꞌuta-kinaa niꞌo unao padamata, mazan Tominkaru atiꞌo niꞌi naa õtaanuzu.’ ");
INSERT INTO wapNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Unao aonaa uizoꞌatin Tominkaru kakinaori, ‘Pumarainapa pudaru naꞌiki pudaro,’ kiaꞌoraz, soo utaapaꞌazon pakawan wuruꞌu pidan tomaniaz kida kakinaorii. ");
INSERT INTO wapNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Unao taapinpauzonao kaimanainao nii kaikiniꞌi! Naꞌapaꞌo manawun tawuruꞌu prophet Isaiah saadaniaz kotuaꞌa naa udauꞌan. Tominkaru kian, ");
INSERT INTO wapNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Diꞌoraz pidannao, ĩtaapan õgaru umanawunuꞌo nii paparadan idaꞌan karikaonan, mazan munapoꞌo ĩtaapan panyukunuu õꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mazanuꞌo karikaonan wuruꞌu ĩmanawuntapanuz õgaru, ushaꞌapanum kauꞌan ĩtominapa-kidanii kida aonaa õkakinaori kidaꞌa naa mani. Mazan pidannao tomaniꞌi naa karikaonan kakinaorii.’” ");
INSERT INTO wapNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Uruu daunaꞌan Jesus dapadan pidannao paꞌidaꞌati. Naꞌiki ukian ĩꞌati, “Uabatapa naꞌiki uaitapa paꞌi naꞌapaꞌoram õkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aonaa pidan dyokorautanii mani wuruꞌu oiidaꞌoraz uruu, mazan kanom pidan kodita-kidanaiz padako iki, uruu paꞌan oiidaꞌoraz pidan, kakinaorii kian kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Udaunaꞌan utominapa-kidaniinao kaawan uꞌidaꞌati, naꞌiki ĩkian uꞌati, “Puaitapanii pukasharutaꞌakan Phariseenao nyukunuu puparadan idaꞌanaꞌoraz naꞌapa ĩꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus kian ĩꞌati, “Ipai paoribai kida aonaa õdaru aokazi iaꞌo paowanii kida mani, soꞌota-karu nii kidaz paꞌishitabaꞌu tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Uruu idi ukauꞌan aonaa unyukunuupaꞌanaꞌa ĩdyaun. Ĩnao tominapa-kidainao, aonaa ĩtukapan kaiman patominapa-kidanii, ishaawunnao ĩdyaun. Aizii baudaꞌapaꞌo ishaawun naꞌakapan dono pamin-ishaawunun, dyaꞌutamaa kidaꞌo nii ĩwaotan kaꞌunaru iti.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mazan Peter kian Jesus ati, “Pukainaabata waꞌati naꞌapaꞌoram wuruꞌu pukuwaaz.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sariapa Jesus kian uꞌati, “Naꞌapaꞌo zii mooko umaaitapakan baꞌorainao pidannao kawan kapam? ");
INSERT INTO wapNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aonaa mooko uaitapan kanom pidan dyokorautanii, utyoodan niizu. ");
INSERT INTO wapNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mazan kanom pidan kodita-kidanii padako iki, panyukunuu diꞌikiꞌo wuruꞌu ukodita-kidaniaz, uruu paꞌan oiidaꞌoraz pidan. ");
INSERT INTO wapNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ushaꞌapanum kauꞌan pidan nyukunuu diꞌikiꞌo, ipai oii kidaꞌo shaꞌapataꞌzoo-kao: uzowiaꞌazon pidan, ubaꞌorantapaꞌazon, ukaminshuꞌuinpaꞌazon, ukoidapaꞌazon, umariidinaꞌazon pairiban dauꞌu, naꞌiki udakoomikitinaꞌazon. ");
INSERT INTO wapNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Naꞌapa kidaꞌo aimaakan wuruꞌu oiidaꞌoraz pidan, mazan pidan machikaakan pakaꞌu paaroopan uaꞌii, aonaa uꞌoiidan pidan.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naꞌikiꞌo Jesus makon munapoꞌo wiizai kida diꞌiti, munapoꞌo donoi kida Tyre naꞌiki Sidon kida diꞌitinapa. ");
INSERT INTO wapNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Canaan sanaaba, naꞌiaꞌo omashaapan kaawan Jesus idaꞌati. Padopian idi okian uꞌati, “Naobanai, King David Takaan-daun, pukamunan-kida õgaru. Oiaꞌo doronai zaamatan õdani zunaaba, tuukiaꞌoraꞌa naa kaiwuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mazan aonaa naꞌapam Jesus kian oꞌati. Uruu idi utominapa-kidaniinao kian uꞌati, “Pudyuuda omakon waꞌai, ushaꞌapanum kauꞌan kainaꞌiki okadakoinaanan wadawuꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus kian, “Õdyuuda-kao Israelitenao idaꞌatiꞌi karikaonan, waziwadinainaouz kaznizonao kawan, aonaa Gentilenao idaꞌatiꞌo mani.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Upuꞌaꞌa mazan okaawan Jesus idaꞌati, sariapa okodoruꞌukan ukanaapu ati, naꞌiki okian uꞌati, “Pukaminkaꞌuta õgaru, Naobanai.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus kian, “Aonaa kaiman koraiziannao wanyukunuu kazata-kao ĩꞌai naꞌiki ukaboota-kao arimarakanao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Sariapa okian uꞌati, “Naꞌapa mishizi, Naobanai, mazan upuꞌu zii pakaꞌuzatiki taapadan arimarakanao nikan wanyukunui unuba waotaꞌo aroapa-kizai baara iki.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Uruu idi Jesus kian oꞌati, “Oo zun, umanawunuꞌo pumishidan. Uruu idi pupishaaniaz, shaꞌapaꞌata-kao nii puꞌati.” Naꞌapain aka odani zunaaba kakudaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Naꞌikiꞌo Jesus makoꞌokan naa, umakopan Galilee Karishiiz danomata, atii uzaidan naawaz iti. Naꞌiaꞌa naa usakanatan. ");
INSERT INTO wapNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iriba pidannao kaawan uꞌidaꞌati, ĩnaꞌakan pidannao machiꞌika-kainao, ishaawunnao, uꞌachoonnao, maparadan-ziiwanao, naꞌiki iriba karinaa-ziiwanao. Ĩmuudan ĩdyaun Jesus kanaapu iti, naꞌiki ipai Jesus kakudan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tuukii pidannao diꞌitinpan ĩtukapan idi maparadanuꞌo, paradan naa; achoinao, kaimanaꞌa naa ĩnanaa; machiꞌika-kainao chiꞌikan naa, naꞌiki ishaawunnao tukapan naa. Uruu idi tuukii ĩkonaukii-kidan Israelitenao Tominkarun. ");
INSERT INTO wapNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Uruu daunaꞌan Jesus dapadan patominapa-kidaniinao paꞌidaꞌati. Naꞌiki ukian ĩꞌati, “Õkashaꞌora-kida õtukapan wuruꞌu pidannaouz, ĩnaꞌan idi idikinaudaꞌuꞌu naa kamoo õtuma. Aizii aonaa kanom ĩnikan niꞌi naa. Aonaa turuu õdyuudan ĩdyaun ĩzamazin puꞌu manawun. Panaadon ĩdorautan pakapatin idiꞌi naa pamakopa-kizi an padapu iti kida.” ");
INSERT INTO wapNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Utominapa-kidaniinao kian uꞌati, “Naꞌiam nii dii waikodan diriꞌiꞌo wanyukunui daꞌaꞌa mapidantakaꞌo amazada idaꞌa wapaa-kinaa nii wuruꞌu iribaꞌoraz pidannao?” ");
INSERT INTO wapNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus pishaan ĩdyaun. “Naꞌapaudaꞌum bread kainaꞌa uꞌidaꞌa?” ukian ĩꞌati. “7 bread naꞌiki masakaudaꞌu kopaunao sodi kida,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Uruꞌu naa Jesus dyuudan iribaꞌoraz pidannao sakanatan imiꞌi baara an kida. ");
INSERT INTO wapNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Udaunaꞌan uzaamatan 7 bread naꞌiki kopaunao sodi kida naꞌiki utoriinpan udauꞌan Tominkaru ati. “Kaiman” ukian uꞌati. Udushowan kidaz naꞌiki utaanuzu patominapa-kidaniinao ati. Naꞌiki ĩnaouꞌu naa taa iribaꞌo pidannao ati kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ipai pidannao aroopan kaimanaiman abaapa kida. Udaunaꞌan utominapa-kidaniinao saabaan wanyukunui waꞌakun. Ĩpaidada 7 dazowan kida. ");
INSERT INTO wapNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aroopainaouz naꞌapain 4,000 daonaioranao aitaa-kao, iribaꞌo kapam naꞌii zunnao naꞌiki koraiziannao mazan aonaa ĩaitaa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Uruu daunaꞌan Jesus dyuudan naa pidannao. Uruꞌu naa upaidinan kanawa zoꞌiti, naꞌiki umakoꞌokan naa wiizai Magadan itinapu. ");
INSERT INTO wapNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Uruu daunaꞌan Phariseenao naꞌiki Sadduceenao kaawan Jesus idaꞌati ĩtiwaa-kidapaꞌananuzu. Ĩaipan ushaꞌapatan umanawunuꞌo aimaakan paꞌati uaida-kida-kinaa nii ĩꞌati mishiꞌo Tominkaru diꞌikiꞌo wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus kian ĩꞌati, “Unao, ukian amazada chuupun dono wuza, kaimanaꞌo nii amazada, ukian. ");
INSERT INTO wapNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aizii amazada kanadan dono chaapiꞌiki wuza naꞌiki kashaba, uruu ukian aonaꞌo nii amazada kaimanan, tuukiaꞌo nii wunu kainaꞌiki. Uaitapa utukapan amazada shaꞌapanum idaꞌan ukainaabata-kinaa nii naꞌapam nii amazada shaꞌapan. Mazan aonaa uaitapan kaiꞌi kainaabatapanii. ");
INSERT INTO wapNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kainaouz oiainao pidannao, maizoꞌati-kainaouz Tominkaru, ĩaipan patukapan umanawunuꞌo aimaakan shaꞌapata-kao, mazan aonaꞌo nii kanom shaꞌapata-kao ĩꞌati, soo wuruꞌu umanawunuꞌoraz shaꞌapan prophet Jonah ati.” Udaunaꞌan Jesus makoꞌokan naa ĩꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Udaunaꞌan, ĩtaraukan karishii baza iti, tominapa-tinainao manyukunuutan panaꞌakan bread panikan nii. ");
INSERT INTO wapNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus kian ĩꞌati, “Uzaudinapa paꞌi Phariseenao naꞌiki Sadduceenao yeastin ai.” ");
INSERT INTO wapNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ĩparadaakan paꞌatiaaka. Ĩkian, “Wamanaꞌakakan idiꞌo bread wanikan nii wuruꞌu ukianuz naꞌapa.” ");
INSERT INTO wapNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus aitapa naꞌapaꞌoram ĩkian. Uruu idi ukian ĩꞌati, “Unao, masakaudaꞌuꞌo umishidan. Kanom nii ukadakotinan umanaꞌakakan dauꞌan bread uwanyukunuu nii? ");
INSERT INTO wapNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aonaa zii uaitapan, aonaa unyukunuitapan tawuruꞌu, bakaꞌiaudaꞌuꞌoraz breadnao õpaa-kinaaz 5,000 daonaioranao? Naꞌiki aonaa unyukunuitapan naꞌapaudaꞌum dazowan uwaꞌakun paidinan? ");
INSERT INTO wapNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Oo tawuruꞌu 7 bread õpaa-kinaaz 4,000 daonaioranao? Naꞌiki aonaa unyukunuitapan naꞌapaudaꞌum dazowan uwaꞌakun paidinan? ");
INSERT INTO wapNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Naꞌapa dii manawun aonaa uaitapan, tawuruꞌu õkadakotinanuz, aonaa bread dauaꞌo mani, mazan uzaudin Phariseenao naꞌiki Sadduceenao yeastin ai.” ");
INSERT INTO wapNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Uruu zii ĩaitapankan aonaa uaipan mani ĩzaudinpan yeast ai, mazan Phariseenao naꞌiki Sadduceenao tominapa-kida-kinaa aiaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus makon Caesarea Philippi Baara iti. Naꞌii upishaan patominapa-kidaniinao. Ukian ĩꞌati, “Naꞌapa dii pidannao kian Daonaiora Aokazi Ikiꞌo dauꞌan?” ");
INSERT INTO wapNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ĩdakoꞌatinuzu, ĩkian, “Pabiꞌi kida pidannao kian John Chikaawunuupauzo. Baꞌorainao kian prophet Elijah. Baꞌorainao kian prophet Jeremiah oo baꞌoran prophet.” ");
INSERT INTO wapNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Unao mani?” ukian ĩꞌati. “Naꞌapam ukian õdauꞌan?” ");
INSERT INTO wapNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter dakoꞌatin, ukian, “Pugaru Christ, Tominkaru Dani, uruu Tominkaru karikaonanuꞌoraz ukakupan.” ");
INSERT INTO wapNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Kaiman konaukiaꞌo pugaru, Simon, Jonah dani. Ushaꞌapanum idi wuruꞌu mishiꞌoraz puparadan aonaa naꞌiaꞌoram pidan kainaabatanii mani puꞌati, mazan õdaru aokazi iaꞌo aipan atiꞌo puaitapan. ");
INSERT INTO wapNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ukauꞌan õkowaadan nii puꞌati, puꞌuu Peter, kuba kiaꞌo wuruꞌu, naꞌiki uruu idaꞌaꞌo nii õtoman õchoochin, aonaꞌo nii mawaka-karu kaꞌiitan pashaꞌapatanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Õtaan nii puꞌati Tominkaru naobanai-tinapa-kizi daꞌata-kinao kida, kanom aonaa pukashaapan daꞌaꞌa imiꞌi baaraꞌa, aonaꞌo nii ukashaapa-kao aokazi ii. Kanom pukashaapanii daꞌaꞌa imiꞌi baaraꞌa, kashaapa-kao niizu aokazi ii.” ");
INSERT INTO wapNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Udaunaꞌan Jesus kakinaowaꞌakan patominapa-kidaniinao aonaa kizi ĩkowaadan pidan ati uruu wuruꞌu Christ. ");
INSERT INTO wapNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Uruu naꞌapain niꞌi diꞌikiꞌi naa, Jesus sakadan pakowaadan patominapa-kidaniinao ati kaimanaiman naꞌapam nii pashaꞌapata-kao. Ukowaadan ĩꞌati naꞌapam pamakon nii Jerusalem iti. Naꞌiaꞌo nii kazowautapainao Jewnao, faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu baiaapa-kidan kaziwaꞌo uꞌati, ĩpatakaꞌutan niizu, naꞌiki ĩzowii-kidan niizu. Mazan idikinaudaꞌu kamoo udaunaꞌan, ukadishita-kida-kao nii, kakupa powaa iti pamawaka-kizi iki. ");
INSERT INTO wapNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jesus kowaadan idi kaikapaꞌoraꞌa, sariapa Peter naꞌakaꞌakanuz panaꞌitinapu pairibannao ai, naꞌiki utowaudaꞌuunuz naꞌapaꞌoram ukian kida dauꞌan, “Aonaa Tominkaru taapadan naꞌapa, Naobanai, aonaa turuu naꞌapaꞌo shaꞌapan puꞌati,” ukian Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mazan utanawatinan Peter diꞌiti, naꞌiki ukian uꞌati, “Puꞌati õꞌai, Satan. Puawautapan õgaru õshaꞌapatinan ai Tominkaru aipan kawanaꞌatiꞌo. Aonaa putaan punyukunuu Tominkaru dauꞌu atiꞌi aimaakan kida dauꞌan, mazan punyukunuu pidannao shaꞌapainpan dauꞌatiꞌo karikaonan.” ");
INSERT INTO wapNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Uruu daunaꞌan Jesus kian patominapa-kidaniinao ati, “Kanom daꞌanaꞌazoꞌo õgaru, marii umarinaꞌatan panaudapanii pashaꞌapaapan, unaꞌakan pacrossannaa, naꞌiki udaꞌanan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ushaꞌapanum kauꞌan naꞌiaꞌoram pidan aipaꞌo pamashaapan paaipan kawanaꞌati karikaonan, uwaziwaan nii karikaonanuꞌoraz kakupa-karu paꞌai, mazan naꞌiaꞌoram pidan marinaꞌataꞌo paaipan kawanaꞌatiꞌo pamashaapan padaꞌanaꞌazon idi õgaru, uikodan nii karikaonanuꞌoraz mashaapa-karu. ");
INSERT INTO wapNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aonaa kanom pidan ikodan uzaamatan an ipai aimaakan imiꞌi baara an kidaꞌo, uwaziwainan puꞌu karikaonanuꞌo kakupa-karu ai. Oo kainaꞌa shaꞌa aimaakan powaꞌaꞌo uaiapa-kao karikaonanuꞌo kakupa-karu ai? ");
INSERT INTO wapNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ushaꞌapanum kauꞌan Daonaiora Aokazi Ikiꞌo waꞌatin nii udaru umanawunun idaꞌan uangelinnao tuma, naꞌiki uruu dono ukawinipinaatan nii ipai pidannao naꞌapaꞌoram ĩshaꞌapainpan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Õkowaadan uꞌati mishiꞌo, pabiꞌi kida unao kadishitapainaouz daꞌaꞌa, aonaꞌo nii umawakan utukapan uaꞌii Daonaiora Aokazi Ikiꞌo waꞌatin unaobanai-tinaꞌanan king nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aizii 6 kamoo daunaꞌan, Jesus naꞌakan patuma Peter naꞌiki James naꞌiki uꞌinawuzu John. Ukauꞌan unaꞌakan ĩdyaun dokoaꞌo midukuo paawa iti, paꞌidiwaru sodiꞌi ĩnao naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Naꞌiaꞌa naa patominapa-kidaniinao awun zaꞌa upanaꞌadinan. Uawun baara naꞌapa kamoo kawan ukanadaꞌakan, naꞌiki ukamichan barakaꞌakan naꞌapa kanadaꞌo kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mashaꞌapakiaka Moses naꞌiki Elijah aidinan ĩꞌati, ĩkadakotinan Jesus tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sariapa Peter kian Jesus ati, “Naobanai, kaimanaꞌo wuruꞌu wanaꞌanuz daꞌaꞌa. Puaipan an, õtoman nii idikinaudaꞌu kabaun sodi kida, baudaꞌapa puꞌati, baꞌoran Moses ati, naꞌiki baꞌoran Elijah ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peter kadakotinan puꞌu zii, kanadaꞌo ishaꞌiz bazobatan ipai ĩdyaun, naꞌiki parada-karu ishaꞌiz bii ikiꞌi kian, “Diꞌi õdaniꞌi, õmarainapanii manawun, shaꞌapatinaꞌo õnyukunuu kawanaꞌati. Uabata naꞌapam ukian uꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aizii Jesus tominapa-kidaniinao abatan wuruꞌu parada-karuz, tuukii ĩtarian. Uruu idi ĩkodoruꞌukan naꞌiki ĩpazakodinan, ĩawun baara imiꞌi baara iti kida. ");
INSERT INTO wapNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mazan Jesus waꞌatiꞌikan ĩꞌidaꞌati upishatan ĩdyaun, naꞌiki ukian ĩꞌati, “Ukadishita, aonaa utariaꞌanaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sariapa ĩawunuupaꞌakan, ĩtukapa Jesus pabaꞌorantinaꞌa naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Udaunaꞌan ĩtokapaanan puꞌu midukuo iki, Jesus kakinaowan ĩdyaun. Ukian ĩꞌati, “Aonaa paꞌi ukowaadaꞌanaꞌa pidan ati utukapanii dauꞌan, atii Daonaiora Aokazi Ikiꞌo kadishita-kida-kao daunaꞌan pamawaka-kizi iki.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Udaunaꞌan patominapa-kidaniinao pishaanuzu. Ĩkian uꞌati, “Kanom nii mooko tiichaapauzonao Moses kakinaori dauꞌu kowaadan Elijahꞌo nii wuruꞌu waꞌatiꞌoraz kiwiitapa Christ uaꞌii?” ");
INSERT INTO wapNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus dakoꞌatin ĩdyaun, ukian ĩꞌati, “Mishiꞌo mishi, Elijah kaawaꞌo niꞌoraz kiwiin uminziiwataꞌanan ipai aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aizii õkowaadan uꞌati, kaawankaꞌa naa wuruꞌu Elijah, mazan aonaa pidannao aitapanaatanuz. Mishiꞌoraiman ĩantamikitanuzu naꞌapam paaipan kawanaꞌati. Naꞌapaꞌo nii ĩantamikitan Daonaiora Aokazi Ikiꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Uruu daunaꞌan utominapa-kidaniinao aitapankan naa John Chikaawunuupauzo dauꞌanaꞌo wuruꞌu Jesus kadakotinanuz naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ĩkaawan donoꞌo naa midukuo iki powaa ati iribaꞌo pidannao idaꞌati. Naꞌii pidan kaawan Jesus idaꞌati, naꞌiki ukodoruꞌukan ukanaapu ati. ");
INSERT INTO wapNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ukian Jesus ati, “Naobanai, pukamunan-kida õdani ukarinaan mawakaziitapa-karu idi, dikaudaꞌoraꞌa naa manawun ubaiatan, panaadon kida daꞌi uwaotan tikazi diꞌiti oo panaadon wunu baoko iti. ");
INSERT INTO wapNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Õnaꞌakanii wuruꞌu õdaniz padamata putominapa-kidaniinao diꞌiti, mazan aonaa ĩturuan pakakudanuz.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus kian, “Unao, kainao pidannao, mamishida-kaꞌo naꞌiki panaꞌitiꞌo ushaꞌapaapan aimaakan kida. Naꞌapam naa mooko ukotuaꞌikin uaipan õnaꞌan utuma? Naꞌapam naa mooko ukotuaꞌikin uaipan õtiwainan utuma? Unaꞌaka wuruꞌu daonaioraz õꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Udaunaꞌan uruꞌu naa Jesus dyuudan oiaꞌo doronai koditan mawakaziitapaꞌo daonaiora diꞌiki. Sariapa ukoditan daonaiora diꞌiki, naꞌiki sariapa ukakudan. ");
INSERT INTO wapNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Udaunaꞌan paꞌidiwaruꞌu Jesus tominapa-kidaniinao kaawan Jesus idaꞌati, naꞌiki ĩkian uꞌati, “Kandii niꞌo mooko aonaa wakaꞌiitan wakodita-kidan wuruꞌu oiaꞌo doronaiz?” ");
INSERT INTO wapNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Uruu idi Jesus kian ĩꞌati, “Umamishidakan idiꞌo wuruꞌu. Aizii õkowaadan nii uꞌati mishiꞌo, umishidan dono mani Tominkaru masakaudaꞌu, duusodiꞌo uudai kawan, aonaa mani kanom kashaꞌapannaꞌo nii ushaꞌapatan. Turuu ukian diꞌoraꞌa midukuo ati, ‘puzikadin diꞌikiꞌi, atii diꞌitiꞌi,’ uzikadinan nii uꞌati wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mazan diꞌoraz kaduz oiaꞌo doronaiz, aonaa turuu udyuuda-kao naꞌapa, soo karikaonanuꞌo toriinapa-karu naꞌiki sanadinapa-karu idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Uruu daunaꞌan Jesus naꞌiki ipai utominapa-kidaniinao baokopatinpan puꞌu Galilee Baara ii, ukian ĩꞌati, “Daonaiora Aokazi Ikiꞌo kaakapaa-kao nii pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ĩzowian nii uruu mazan idikinaudaꞌu kamoo daunaꞌan ukadishita-kida-kao nii pamawaka-kizi iki.” Tuukii utominapa-kidaniinao kashaꞌoran unaꞌapan idi. ");
INSERT INTO wapNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus naꞌiki utominapa-kidaniinao kaawan Capernaum iti. Ĩnaꞌian puꞌu pidannao zaamaapauzonao tax puraatannaa Tominkaru Dapu atiꞌi kaawan Peter idaꞌati, naꞌiki ĩpishaan Peter, “Naꞌapa dii punaobanaa, ukawinipinaatauzonii tax Tominkaru Dapu ati?” ");
INSERT INTO wapNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Oo, utaa,” Peter kian. Peter kaawan dono kabaun ati Jesus diꞌiti, Jesus paradaꞌaka kiwiin. Upishaan Peter, ukian uꞌati, “Naꞌapam puꞌitiiman Simon, kanomnao ai diꞌi kingnao zaamaapan tax puraatannaa, papidanannao ai, oo baꞌoran pidannao ai?” ");
INSERT INTO wapNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Baꞌoran pidannao ai,” Peter kian uꞌati. “Ukauꞌan aonaa kandii nii upidanannao taapan tax puraatannaa nii,” Jesus kian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Mazan aonaa kizi wakasharutan ĩnyukunuu, ukauꞌan pukobawuupanaka karishii ii. Aizii naꞌiaꞌoram kopau puzaamatanii kiwiitapa, pudaꞌata udako naꞌiki puikodan nii wiziꞌiꞌo puraata udako idaꞌa. Puzaamata wuruꞌu puraataz naꞌiki putaa zaamaapauzonao tax puraatannaa atiz. Uruu idiꞌo nii wakawinipinaatan tax.” ");
INSERT INTO wapNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Naꞌapain uruu dono Jesus tominapa-kidaniinao kaawan uꞌidaꞌati, naꞌiki ĩpishaanuzu. Ĩkian, “Kanomaꞌo nii umanawunuꞌo nii manawun pidan Tominkaru naobanai-tinapa-kizi ii?” ");
INSERT INTO wapNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Uruu idi Jesus dapadan koraidaonaa naꞌiki ukadishita-kidanuz ĩbiiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ukian ĩꞌati, “Õkowaadan uꞌati mishiꞌo, aonaꞌo nii uturuudinan Tominkaru naobanai-tinapa-kizi iti, soo upanaꞌadinan umanawun-tinpan ai, naꞌiki aonaa utaapinpan atadinapa, naꞌapa diꞌoraz koraidaonaa kawanuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ukauꞌan naꞌiaꞌoram pidan, diꞌoraz koraidaonaa kawanuꞌo, aonaa uꞌatadinpan, uruu umanawunuꞌo Tominkaru naobanai-tinapa-kizi ii. ");
INSERT INTO wapNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Naꞌiki naꞌiaꞌoram pidan marainpaꞌo padapaapan kaikapaꞌo koraidaonaꞌa õgaru dikin ii, dapaapaꞌo õgaru wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mazan naꞌiaꞌoram pidan shaꞌapata-kidaꞌo oiaꞌo wunao sodi kida atiꞌi, mishidainaouz õgaru, kaiman mani udaruꞌo boodapa-kinai kuba sukuruuta-kao ukanau iki naꞌiki unaraada-kao paran baoko iti. ");
INSERT INTO wapNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kashaꞌoraꞌo nii manawun wunao baiaapanuꞌu pidannaouz, ĩshaꞌapata-kidan idi oiaꞌo pidannao ati. Naꞌapaꞌoraz aimaakan kida shaꞌapatinaꞌo nii, mazan kichanaꞌiki-kiaꞌo nii manawun wuruꞌu atizuꞌu pidanaz shaꞌapata-kidaꞌoraz naꞌapa kidaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ukauꞌan pukaꞌu oo pukidiba shaꞌapata-kidan dono oiaꞌo puꞌati, pudukuta puꞌai kidaz naꞌiki pukaboota puꞌai kidaz. Kaimanaꞌo nii pumakon karikaonanuꞌo kakupa-karu diꞌiti badaꞌii pukaꞌu naꞌiki badaꞌii pukidiba, pukaboota-kao ai ipai pukaꞌu naꞌiki pukidiba tuma tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Naꞌiki puawun shaꞌapata-kidan dono oiaꞌo puꞌati, pusoꞌota puꞌaiaz, naꞌiki pukaboota puꞌaiaz. Kaimanaꞌo nii pumakon karikaonanuꞌo kakupa-karu diꞌiti badaꞌii puawun, pukaboota-kao ai ipai dyaꞌutamaꞌo puawun tuma Tuubaruꞌo Tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ukauꞌan mishiiman paꞌi uzaudin, aonaa ukashadaꞌanaꞌa wunao sodi kidaꞌa mishidainaouz õgaru. Õkian uꞌati kaikapaꞌa ushaꞌapanum kauꞌan angelnao awunuutapainaouz ĩdyaun, karikaonanuꞌo daꞌi ĩtukapauzon õdaru aokazi iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Daonaiora Aokazi Ikiꞌo waꞌatin ukazannaataꞌanan pidannao waziwadinaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Naꞌapam mani puꞌitiiman pidan shaꞌapatinan kaꞌuzaꞌo 100 kaznizonao idi, baudaꞌapaꞌo uꞌuza waziwadinan dono pairibannao ai? Aonaꞌo nii mani uwaꞌakan zii wunaouꞌu naꞌainaouz naꞌiki udorotaꞌanan wuruꞌu waziwadinaꞌoraz pairibannao ai? ");
INSERT INTO wapNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Õkowaadan uꞌati mishiꞌo, uikodan donoꞌo naazu tuukiaꞌo nii ukonaukian wuru dauꞌanaꞌa baudaꞌapaꞌoraz kaznizo, iribaꞌo mawaziwadin-kainao dauꞌatiꞌo ai. ");
INSERT INTO wapNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Naꞌapaꞌo kapam ukauꞌan õDaru aokazi iaꞌo, aonaa baudaꞌapa uaipan wunao sodi kida waziwadinanuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesus kian koshan, “Pumin-mishidan shaꞌapatan dono oiaꞌo puꞌati, puparadanaaka uꞌati, mazan soo unao sodi karikaonan. Puparada kizi uꞌati ushaꞌapatan dauꞌan oiaꞌo puꞌati. Aizii uabatan dono puparadan, punaꞌakan puꞌinawuzu powaꞌa ati kaimanaꞌo idaꞌati wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mazan aonaan an uabataꞌazon puparadan, puzaamata baudaꞌapaꞌa naa oo dyaꞌutamaꞌa naa pidannao punaꞌakan nii putuma uꞌidiꞌiti. Uruu naꞌapa wuruꞌu dyaꞌutamaꞌo oo idikinaudaꞌuꞌo pidannao aidan nii pakowaadan idaꞌan mishiꞌo wuruꞌu puparadan ushaꞌapatan dauꞌan oiaꞌo puꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aizii aonaan an uabataꞌazon ĩparadan, pukowaada baokopa pumin-mishidannao ati. Mazan aizii aonaan an uabataꞌazon ĩparadan putaapa uruu naꞌapa putaapan kawan mamishida-kaꞌo Tominkaru oo zaamaapauzonao tax puraatannaa kawan.” ");
INSERT INTO wapNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Õkowaadan unao ati mishiꞌo: Kanom aonaꞌo unao kashaapan daꞌaꞌa imiꞌi baaraꞌa, aonaꞌo nii ukashaapa-kao aokazi ii. Kanom ukashaapanii daꞌaꞌa imiꞌi baaraꞌa, kashaapa-karu niizu aokazi ii. ");
INSERT INTO wapNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Õkowaadan uꞌati koshan: Naꞌapainim dyaꞌutamaꞌo unao, unaꞌapatan an unyukunuu naꞌapa kida utoriinapa kizi dauꞌan daꞌaꞌa imiꞌi baaraꞌa, õdaru Tominkaru shaꞌapatan nii uꞌatizu. ");
INSERT INTO wapNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ushaꞌapanum kauꞌan naꞌian dyaꞌutamaꞌo oo idikinaudaꞌuꞌo baokopatinpainao ĩmishidan idi õgaru, naꞌiaꞌo nii Õgaru ĩtuma.” ");
INSERT INTO wapNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Udaunaꞌan Peter waꞌatin Jesus idaꞌati, naꞌiki ukian Jesus ati, “Naobanai, naꞌapaudaꞌum nii õpowaꞌatan kida õmarinaꞌatan õꞌinawuzu shaꞌapatanii oii kidaꞌo õꞌati? Atii 7 diꞌiti?” ");
INSERT INTO wapNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus dakoꞌatinuzu, ukian uꞌati, “Aonaa 7 mani, mazan ipai dono, ushaꞌapata-kao kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ukauꞌan kaikapaꞌo wuruꞌu Tominkaru naobanai-tinapanuz: naꞌapa king pishainan kawan papoitorunao ai ĩmawinipinaatapanii kida dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Usakadaꞌakan anaꞌa naa papishainpan, baudaꞌapaꞌo upoitoru naꞌaka-kao uꞌidaꞌati dobataꞌo manawun puraata umawinipinaatapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wuruꞌu upoitoru aonaa upuraatan turuan ukawinipinaatan wuruꞌu umawinipinaatapaniaz. Uruu idi king dyuudan naa usellii-kao paudaiaro naꞌiki paudainao tuma, naꞌiki ipai ushaꞌapauz kida, umawinipinaatapanii kawinipinaata-kinao niꞌi naa. ");
INSERT INTO wapNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sariapa udopian kowas wuruꞌu upoitoruz, uruu idi ukodoruꞌukan uawun baara imiꞌi baara iti king kanaapu ati. ‘Puzaudapaꞌa naa zii shoman, õkawinipinaatan nii zii ipai õmawinipinaatapanii kidaz,’ ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Unaꞌapan idi king kashaꞌora-kidanuz, uruu idi umarinaꞌatan naa umawinipinaatapanii kida, naꞌiki kaiman utaapadan umakon naa padapu iti. ");
INSERT INTO wapNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aizii naꞌikiꞌo umakoꞌokan wuruꞌu upoitoruz, uikoda pamin-kaudinan mawinipinaatapaꞌo paugaru, aonaa dobataꞌo manawun mani. Uzaamatanuz naꞌiki udyukuruutanuzu, ‘Pukawinipinaata õꞌati pumawinipinaatapanuz õgaru,’ ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Uruu idi umin-kaudinan dopian kowas, ukodoruꞌukan ukanaapu ati. Ukian, ‘Puzaudapaꞌa naa zii shoman, õkawinipinaatan nii pugaru.’ ");
INSERT INTO wapNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aonaa mazan arawu nyukunuu naꞌapanuꞌu. Mishiꞌoraiman ukaboota-kidan naa pamin-kaudinan taraa-kizai iti, atii uipaian dono zii pakawinipinaatan pamawinipinaatapanii. ");
INSERT INTO wapNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Baꞌorainao poitoruinao tukapan idi ushaꞌapatan naꞌapaꞌo, tuukii ĩnyukunuu kashaꞌoran. Uruu idi ĩmakon King diꞌiti naꞌiki ĩkowaada king ati ipai aimaakan ushaꞌapatanii kida dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Udaunaꞌan King dapada-kidan wuruꞌu poitoruiz. King kian uꞌati, ‘Pugaru dikaudaꞌo poitorui. Õmarinaꞌata puꞌai ipai pumawinipinaatapanii õꞌai, pudopian idi puparadan õꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aonaa mooko pukashaꞌora-kidan pumin-kaudinan kapam, õkashaꞌora-kidan kawan pugaru?’ ");
INSERT INTO wapNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","King toꞌoran tuukii, uruu idi ukaboota-kidan wuruꞌu poitoruiz taraa-kizai iti, naꞌii upatakaꞌuta-kao atii ukawinipinaatan ipai pamawinipinaatapanii.” ");
INSERT INTO wapNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Udaunaꞌan Jesus kian, “Naꞌapaꞌo nii õdaru aokazi iaꞌoraz shaꞌapatan ipai unao ati, umamarinaꞌatakan dono unyukunuu ii uꞌinawuzu shaꞌapatanii dikaudaꞌo uꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aizii Jesus ipaian donoꞌo naa pakakuwaapan naꞌii, umakon naa Galilee Baara iki, Judea Baara iti, Jordan Waꞌo baza itinpuꞌu diꞌitinapa. ");
INSERT INTO wapNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Naꞌii iriba pidannao daꞌananuzu naꞌiki ukakuda karinainao naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pabiꞌi kida Phariseenao waꞌatin uꞌidaꞌati ĩtiwaa-kidapaꞌananuz. Ĩpishaanuzu kaikapaꞌa: “Wakakinaorinaa taapada daonaiora muudan paudaiaro naꞌapaꞌoram dikin ii karikaonan?” ");
INSERT INTO wapNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus dakoꞌatin ĩdyaun, ukian, “Aonaa mooko uaitauzon Tominkaru Paradan saada-kariwaiz tawuruꞌu ukianuz, usakadin-kizi iki Tominkaru toman daonaiora naꞌiki zun. ");
INSERT INTO wapNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Naꞌiki Tominkaru kian, ‘uruu idi daonaiora muudinan nii padaru naꞌiki padaro ai ubaudaꞌapatinan paudaiaro tuma. Ukauꞌan dyaꞌutamainaouz, baudaꞌapatinan nii.’ ");
INSERT INTO wapNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Uruu idi aonaa dyaꞌutamaꞌoraꞌa naa mani ĩdyaun, mazan baudaꞌapaꞌoraꞌa naa. Kanom Tominkaru baudaꞌapatanii, aonaa turuu pidan muudaaka-kidan.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Phariseenao pishaan Jesus koshan. Ĩkian, “Kanom nii Moses kakinaori, kashaapan daonaiora muudan paudaiaro pasaadan idaꞌan muudaaka-karu kaaritannaa?” ");
INSERT INTO wapNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus dakoꞌatin, ukian, “Moses kashaapan umuudan udaiaronao, ushaꞌapanum kauꞌan kashaꞌapannaa uꞌati utominapa-kida-kinao ukashadamikin idi, mazan usakadin-kizi iki, aonaa Tominkaru kashaapan naꞌapaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Õkowaadan uꞌati, naꞌiaꞌoram unao muudaꞌo paudaiaro omashaapan puꞌu kaiman utuma, udaunaꞌan ukaudaiaron baꞌoran zun idi, utoman oiaꞌo wuruꞌu ubaꞌorantapan idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesus tominapa-kidaniinao kian uꞌati, “Unaꞌapan idi kaikapaꞌa daonaiora kaudaiaron dauꞌan, kaiman zii mani aonaa kaudaiaro-karu.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus dakoꞌatin ĩdyaun, ukian, “Aonaa pidan nyukunuu naꞌapan ipai pamashaapaꞌazon dauꞌu naꞌapa, kaiwuruꞌu uparadan kian kawanaꞌati, soo wunaouꞌu Tominkaru taaniaz ĩꞌati ĩturuuda-kinaa nii, pamashaapan maudaiaro-daun. ");
INSERT INTO wapNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pabiꞌi kida daonaioranao, aonaa ĩkaudaiarouzon, ushaꞌapanum kauꞌan naꞌapaꞌo karikaonan ĩtominan makuuta-kariwai kawanuꞌo ĩdyaun pashakatan diꞌikiꞌo; baꞌorainao, ĩmakuuta-kao idiꞌo aonaa ĩkaudaiaron; baꞌorainao, ĩkaudinaꞌazon idi paꞌan karikaonan Tominkaru ati. Kanom mashaapaꞌazon naꞌapa, marii umashaapan naꞌapa.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Udaunaꞌan pidannao naꞌakan duusodi kidainao koraiziannao Jesus idaꞌati ĩaipan upishatan ĩdyaun, naꞌiki utoriinapa-kidan ĩdyaun. Mazan Jesus tominapa-kidaniinao mashaatan pidannao naꞌakainaouz ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Unaꞌapan puꞌu mazan Jesus kian, “Marii koraiziannao waꞌatin õꞌidaꞌati, aonaa umashaataꞌanaꞌa ĩdyaun, ushaꞌapanum kauꞌan ĩnao kawanuꞌo pidan wuruꞌu zaamataꞌoraz Tominkaru panyukunuu naobanaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ukauꞌan upishatan naa ĩdyaun, naꞌiki utoriinapa-kidan ĩdyaun. Udaunaꞌan umakon naa naꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baukapaiman paꞌinaꞌo daonaiora kaawan Jesus idaꞌati. Ukian, “Tiichaa, kanom kaimanaꞌo õshaꞌapatan nii õikoda-kinaa nii karikaonanuꞌo kakupa-karu?” ");
INSERT INTO wapNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus kian uꞌati, “Kanom nii pupishaan õgaru kaimanaꞌo dauꞌan? Kainaꞌa baudaꞌapa kaimanaꞌo, soo Tominkaru. Puaipan dono karikaonanuꞌo kakupa-karu, puizoꞌati Tominkaru kakinaori kida.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Naꞌiaꞌoram kakinaorii kida,” daonaiora kian. Jesus dakoꞌatin, ukian uꞌati, “Aonaa puzowiaꞌanaꞌa pidan, manaꞌa pubaꞌorantapaꞌanaꞌa, aonaa pukoidapaꞌanaꞌa, aonaa pumariidinaꞌanaꞌa, ");
INSERT INTO wapNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pumarainapa pudaru naꞌiki pudaro, naꞌiki pumarainapa baꞌoran pidan naꞌapa pumarainpinan kawan.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Õkoraidaonaan ikiꞌo ipai õizoꞌatin uruu kida kakinaorii. Kanomaꞌa naa õshaꞌapata powaꞌa?” paꞌinaꞌo daonaiora kian. ");
INSERT INTO wapNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus kian uꞌati, “Puaipan dono mishiꞌo pukaimanan, pumako puselliinaka ipai pushaꞌapauz putaa kizi upuraatannaa patakaꞌutinainao ati. Naꞌapa kashaꞌapauziꞌo nii pugaru aokazi ii. Naꞌiki pudaꞌanaꞌa naa õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aizii wuruꞌu paꞌinaꞌo daonaiora abatan Jesus kian kaikapaꞌa, tuukii ukashaꞌoran umakon naꞌiki, ushaꞌapanum kauꞌan umanawunuꞌo ukashaꞌapauzin wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Udaunaꞌan Jesus kian patominapa-kidaniinao ati, “Õkowaadan uꞌati mishiꞌo: Kashaꞌapannaꞌo nii manawun kapuraatanuꞌo pidan ati Tominkaru naobanaitapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Õkian powaꞌa koshan uꞌati: Kashaꞌapannaꞌo nii manawun kapuraatanuꞌo pidan ati Tominkaru naobanaitapa-kao, camel kaꞌiitan ai pamorotan akosa awun shaawata.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aizii Jesus tominapa-kidaniinao abatan idi Jesus kian kaikapaꞌa, tuukii manawun ĩdiꞌitinpan. Uruu idi ĩkian, “Kanomaꞌo nii mooko turuu ukazannaatinan?” ");
INSERT INTO wapNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sariapa Jesus awunuupaꞌakan ĩꞌidiꞌiti, naꞌiki ukian ĩꞌati, “Kaiwuruꞌu kashaꞌapannaꞌo pidan ati, mazan Tominkaru ati aonaa naꞌiaꞌoram aimaakan kashaꞌapannaꞌo nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Uruu daunaꞌan Peter paradan, ukian, “Putukapa, ipai wawaꞌakan waaimaakanutu kida wadaꞌanan idi pugaru. Aizii kanomaꞌo niꞌi naa waikoda waꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus kian ĩꞌati, “Õkian uꞌati mishiꞌo: Daonaiora Aokazi Ikiꞌo umanawunuꞌo nii unaobanai-tinan diinaꞌitiꞌi amazada paꞌinaada-kao donoꞌo naa. Naꞌapain uruu dono unao, 12 daꞌanpainaouz õgaru, naobanai-tinaꞌo nii kapam. Naꞌiki ukazowautapan nii 12 Israel dani-daunnao donozinaa kida. ");
INSERT INTO wapNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aizii ipai pidannao waꞌakainao padapu, waꞌakainao paꞌinawuzunao oo padadakoonao, waꞌakainao padaru oo padaro oo paudainao oo pazakapun padaꞌanan idi õgaru, taa-karu nii ĩꞌati powaꞌaꞌo zii udiriꞌin, pakashaꞌapauzin ai aka kiwiitapa. Naꞌiki karikaonanuꞌo nii ĩmashaapan Tominkaru tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mazan iriba pidannao umanawunuꞌo ĩtaapa-kao kai, diinaꞌitiꞌi aonaꞌo nii ĩtaapa-kao umanawunuꞌo nii. Naꞌiki pidannao aonaꞌo ĩtaapa-kao umanawunuꞌo nii kai, mazan diinaꞌitiꞌi umanawunuꞌo nii ĩtaapa-kao paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus kian koshan, “Kaikapaꞌo wuruꞌu Tominkaru naobanai-tinapanuz: kapaoribaꞌo naobanai kawan, makoꞌoraz chaapiꞌikiiman upidanaapaꞌanan kaudinainao niꞌo dauꞌan paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ukowaadan papoitorunao ati pakawinipinaatan nii ĩdyaun baudaꞌapa wiziꞌiꞌo puraata, baudaꞌapaꞌo kamoo kaudin-karu kawanaꞌati. Ĩnyukunuu naꞌapan idi, uruꞌu naa udyuudan ĩkaudinaꞌanan papaoriba grape baawu iti. ");
INSERT INTO wapNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Udaunaꞌan 9 oꞌclock umakon koshan, uikoda market ii baokoinao daonaioranao kadishitapan, aonaa kanom ĩshaꞌapaapan. ");
INSERT INTO wapNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Uruu idi ukian ĩꞌati, ‘Umako ukaudinaꞌan õpaoriba baawu iti. Ukaudinan kawanaꞌatiꞌo nii õkawinipinaatan unao.’ Ukauꞌan ĩkaudinaꞌanan naa uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aizii sakitapa kamoo naꞌapa koshan ushaꞌapatan. Udaunaꞌan 3 oꞌclock, naꞌapa koshan. ");
INSERT INTO wapNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Udaunaꞌan 5 oꞌclock, umakon naa koshan market iti. Kainaꞌa zii uikodan pidannao naꞌii, aonaa kanom ĩshaꞌapaapan. Sariapa upishaan ĩdyaun, ‘Kanom nii unaꞌan daꞌaꞌa baudaꞌapa kamoo? Aonaa ukaudinaꞌanan?’ ");
INSERT INTO wapNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ĩkian uꞌati, ‘Aonaa mazan kanom zaamatan waunao kaudinaꞌanaꞌo nii.’ Uruu idi ukian ĩꞌati, ‘Ukauꞌan umako ukaudinaꞌan õꞌati õpaoriba baawu ii.’ ");
INSERT INTO wapNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aizii kamoo tipitanin kapaoribaꞌo kian pafoomaanan ati, ‘Pudapadaꞌa naa kaudinainao daꞌatiꞌi wakawinipinaata kiziꞌi naa ĩdyaun. Kiwiitapaꞌo nii wakawinipinaatan dawuꞌitiiniinao ĩsakadan pakaudinan, naꞌiki waipaian nii kiwiitapainao ĩsakadan pakaudinan diꞌiti.’ ");
INSERT INTO wapNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aizii kaudinainao 5 oꞌclock diꞌiki, kiwiin ĩkawinipinaata-kao. Baudaꞌapa wiziꞌiꞌo puraata kida ĩzaamatan. ");
INSERT INTO wapNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ukauꞌan kiwiitapainao ĩsakadan pakaudinan zauda-kidan dobata-kidaꞌo nii pakawinipinaata-kao makaudin-kainao ai baudaꞌapa kamoo. Mazan naꞌapa kida kapam ĩkawinipinaata-kao, baudaꞌapa wiziꞌiꞌo puraata kida ĩzaamatan. ");
INSERT INTO wapNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Pazaamatan daunaꞌan papuraatan, ĩparada-paradaapan ĩtoꞌoradinan kapaoribaꞌo ati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ĩkian uꞌati, ‘Dawuꞌitiiniinao ĩkaudinan masakaudaꞌuꞌo ĩkaudinankan, baudaꞌapa hour sodi, mazan waunao baudaꞌapa kamoo wakaudinan wabaiaapan wiichaꞌo kamoo, mazan upuꞌu zii pukawinipinaatan ĩdyaun naꞌapa kida manawun waunao kawan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kapaoribaꞌo kian baudaꞌapaꞌo ati, ‘Õpaonaru, aonaa õkoidapan pugaru, punaꞌapatanii punyukunuu õkawinipinaataꞌazon dauꞌan pugaru baudaꞌapa wiziꞌiꞌo puraata baudaꞌapaꞌo kamoo. ");
INSERT INTO wapNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pumakoꞌo naa pudapu iti, kainaꞌaꞌa naa puzaamatan pupuraatan. Õaipan kawanaꞌatiꞌo õkawinipinaatanuz dawuꞌitiiniꞌoraz ĩkaudinan, naꞌapa õkawinipinaatan kawan pugaru. ");
INSERT INTO wapNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aonaa turuu mooko õshaꞌapatan õpuraatan naꞌapam õaipan kawanaꞌati? Oo pukishauzin õkawinipinaatan idi kaiman wunaouꞌu dawuꞌitiiniinaouz ĩkaudinan?’” ");
INSERT INTO wapNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesus katokontan pakuwaa pakian idaꞌan, “Pidannao aonaꞌo ĩtaapa-kao umanawunuꞌo nii kai, mazan diinaꞌitiꞌi umanawunuꞌo nii ĩtaapa-kao. Naꞌiki pidannao umanawunuꞌo ĩtaapa-kao kai, diinaꞌitiꞌi aonaꞌo nii ĩtaapa-kao umanawunuꞌo nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aizii Jesus makon naa Jerusalem iti. Pamakopa-kizi an udapadan wuruꞌu 12 patominapa-kidaniinaouz panaꞌitinapu baꞌorainao pidannao ai, naꞌiki ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Wamakon wuruꞌu Jerusalem iti, naꞌiaꞌo nii Daonaiora Aokazi Ikiꞌo kaakapaa-kao patarubanao ati, faadaanao zowaunaanaouz, naꞌiki tiichaapauzonaouz Moses kakinaori dauꞌu. Naꞌiki ĩtaan nii uruu zowii-karu nii, ");
INSERT INTO wapNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","naꞌiki udaunaꞌan ĩtaan nii uruu Gentilenao ati. Ĩnaouꞌo niꞌi naa dakoapa uruu, pabankiitinan idaꞌan udauꞌan naꞌiki ĩbaꞌizian nii tuukii uruu. Udaunaꞌan ĩtaukan nii uruu cross diꞌiti naꞌiki umawakan nii, mazan idikinaudaꞌutan kamoo daunaꞌan, Tominkaru kadishita-kidan nii uruu kakupa powaa iti pamawaka-kizi iki.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Uruu daunaꞌan James naꞌiki John daro, Zebedee daiaroz, kaawan paudainao daonaioranao tuma Jesus idaꞌati. Sariapa okodoruꞌukan naꞌiki odawukan ukanaapu ati. Opishaanuzu, oaipan ushaꞌapatan paaiapanii. ");
INSERT INTO wapNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus kian oꞌati, “Kanom puaipan õshaꞌapatan puꞌati?” Sariapa okian uꞌati, “Õaipan pusakanata-kidan diꞌoraz õdainaouꞌu naobanai nii punaobanai-tinan dono. Marii pusakanata-kidan baudaꞌapa pudiwaꞌora antanapu, naꞌiki baꞌoran puꞌashabaron antanapu.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus tanawatinan daonaioranao naꞌiki ĩdaro diꞌiti. Ukian ĩꞌati, “Aonaa uaitapanii dauꞌanaꞌo mani wuruꞌu upishaanuz õgaru. Ukaꞌiitan nii mooko wuruꞌu õbaiaapan niꞌoraz?” “Oo, wakaꞌiitan nii,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus kian ĩꞌati, “Mishiꞌo nii ubaiaapan õbaiaapan niꞌoraz. Mazan kanomaꞌo nii sakanata õdiwaꞌora antanapu naꞌiki õashabaron antanapu, aonaa turuu õshaꞌapatan, mazan õdaru aokazi iaꞌo minziiwata-kidanii wuruꞌu sakanata-kizaiz pazaamataniinao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aizii 10 baꞌorainao utominapa-kidaniinao abatan naꞌapaꞌoraz dauꞌu, tuukii ĩtoꞌoran dyaꞌutamainao ati, makonkainaouz padaro tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Uruu idi Jesus dapadan baokopa ĩdyaun naꞌiki ukian ĩꞌati, “Uaitapanii naꞌapam baꞌoran pidannao zowaunaanao, mamishida-kainaouz Tominkaru, waranuitapan papidanannao ĩnaobanai-tinpan idaꞌan ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mazan unao, aonaa umashaapaꞌanaꞌa naꞌapa, mishiꞌoraiman kanom aipaꞌo panaobanai-tinpan, marii ukaudinan unao ati poitorui kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Naꞌiki kanom umanawun-tinpaꞌazoꞌo pairibannao ai, marii upoitoruitapa-kidinan ipai pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Naꞌapa Daonaiora Aokazi Ikiꞌo, aonaa uwaꞌatin umanawun-tinpaꞌanan mani, mazan upoitoruitapa-kidinaꞌanan ipai pidan ati, naꞌiki ukazannaataꞌanan pidannao paꞌoian ai umawakan idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Baꞌoran dono Jesus naꞌiki utominapa-kidaniinao makon donoꞌo naa Jericho iki, iriba pidannao makon Jesus dawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aizii naꞌapain naꞌii dyaꞌutam ishaawunuꞌo daonaioranao sakanatapan dunapo daawa ii. Ĩabatan idi Jesus dobatapan kowaada-kao, uruu idi ĩkadakon. Ĩkian, “David Takaan-daun, waNaobanaa, pukamunan-kida waunao.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sariapa pidannao towaudaꞌuan ĩdyaun, ĩdyuudan ĩmashaadinan, mazan powaꞌa zii manawun ĩkadakon diiwaꞌo idaꞌan. Ĩkian, “David Takaan-daun, wanaobanaa, pukamunan-kida waunao.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus kadishitaꞌakan pamakopa-kiziꞌi, naꞌiki udapadan ĩdyaun paꞌidaꞌati. Upishaan ĩdyaun, ukian, “Kanom uaipan õshaꞌapatan uꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ĩkian uꞌati, “Wanaobanaa, waaipan pusaabaan waawun watukapa kizi.” ");
INSERT INTO wapNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus kamunan-kida ĩdyaun, uruu idi upishatan ĩawun kida. Sariapa ĩtukapaꞌakan amazada, naꞌiki ĩmakon naa Jesus tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aizii Jesus naꞌiki utominapa-kidaniinao maonapatan naa Jerusalem iti, ĩkaawan Bethphage iti, wiizai Olive Naawa iaꞌoraz. Naꞌikiꞌi naa udyuudan dyaꞌutam patominapa-kidaniinao paꞌuaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ukian ĩꞌati, “Umako wakanaapu iaꞌoraz wiizai diꞌiti. Naꞌiaꞌo nii uikodan koꞌidinpaꞌo chaakashi, kainaꞌaꞌo nii odani koꞌidinpaꞌo kapam odazabaꞌa. Ubuzuuta ĩdyaun naꞌii, udaunaꞌan unaꞌakan ĩdyaun õꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pidan pishaan an unao kanom nii unaꞌakan ĩdyaun, ‘Naobanai aipan ĩdyaun,’ ukii uꞌati. Sariaapaꞌo nii utaapadan unaꞌakan ĩdyaun.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Naꞌapaꞌoraz Tominkaru prophetin kuwaa mishiin-kinaꞌa naa. Ukianuz: ");
INSERT INTO wapNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pukowaada Zion iainao pidannao ati. ‘Utukapa king, unaobanaa, waꞌatin uꞌidaꞌati. Aonaa uꞌatadinpan, chaakashi barau an uwaꞌatin, paꞌinaꞌo chaakashi uzaidapan.’” ");
INSERT INTO wapNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Udaunaꞌan tominpainao, udyuudaniinaouz makon, naꞌiki ĩshaꞌapata ipai naꞌapa Jesus dyuudan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ĩnaꞌakan chaakashi paudani tuma, naꞌiki ĩtaan pakamichan kida utabanaa nii, uruꞌu naa Jesus zaidanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iriba pidannao, makopainao Jesus tuma, kadamaradan pakamichan kida dunapota. Baꞌorainao dukutan puꞌu atamun waoda kaanaba sodi kidaꞌa, ĩmuudan kidaz dunapota Jesus mako kizi nii. ");
INSERT INTO wapNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iribainaouz pidannao makopainao uꞌuaꞌati, naꞌiki udawuꞌati, kadakoinaanan konaukii diiwaꞌo idaꞌan. Ĩkian, “Wakonaukii-kida Tominkaru, David Takaan-daun dauꞌan. Marii Tominkaru kaimanan, diꞌoraz Naobanai atiꞌo, kaawaꞌoraz uaipan kawanaꞌati. Wakonaukii-kida Tominkaru aokazi iaꞌoraz.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesus morotan donoꞌo naa Jerusalem iti, tuukii naꞌiainao pidannao diꞌitinpan udauꞌu. Uruu idi ĩkian Jesus dauꞌan, “Kanom wuruꞌu uruuz?” ");
INSERT INTO wapNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sariapa Jesus tumainao kian ĩꞌati, “Jesus wuruꞌu, uruu Nazareth san, Galilee Baara ikiꞌo prophet.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Udaunaꞌan Jesus kaawan Tominkaru Dapu iti. Naꞌii uwaataabiꞌian selliipainao kida uzainao naꞌiki toriipainao kida uzainao taa-kariwai niꞌo Tominkaru ati. Udorau-kidan shakataaka-kidauzonao puraata miisan kida, naꞌiki selliipainao wakokoonao taba kida. ");
INSERT INTO wapNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ukian ĩꞌati, “Tominkaru Paradan saadinpaꞌo kian, ‘Õdapu dakota-kao nii toriinapa-kizai dapunaa nii, mazan unao ukaiwaapanuzu koidimikinao dizinapa-kizi nii.’” ");
INSERT INTO wapNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Naꞌii Tominkaru Dapu ii, ishaawunnao naꞌiki machiꞌika-kainao kaawan Jesus idaꞌati. Ukakuda ipai ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Faadaanao zowaunaanao naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, tuukii ĩtoꞌoran naꞌiki ĩkashanau-kidan Jesus patukapan idi Jesus shaꞌapatan konaunamaꞌo naꞌiki umanawun kidaꞌo aimaakan, naꞌiki paabatan idi koraiziannao kadakoinpan Tominkaru Dapu ii aka. “Wakonaukii-kida Tominkaru, David Takaan-daun dauꞌan,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Uruu idi ĩpishaan Jesus. Ĩkian, “Puabatanii naꞌapaꞌoram koraiziannao kadakoinpan pudauꞌan?” “Oo, õabata,” Jesus kian ĩꞌati. “Aonaa mooko uaitauzon naꞌapaꞌo dauꞌu Tominkaru Kaaritan idaꞌa? Ukianuz, ‘Putominapa-kidanii koraiziannao sodi kida aitapaꞌo nii pakonaukii-kidanuz.’” ");
INSERT INTO wapNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Uruu daunaꞌan umakon naa ĩꞌai, umakon naꞌiki patominapa-kidaniinao tuma udaꞌawuꞌanan Bethany iti. ");
INSERT INTO wapNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Baꞌoran chaapiꞌiki Jesus kiwan naa patominapa-kidaniinao tuma Jerusalem iti. Pakiwapa-kizi an uzamazin naa. ");
INSERT INTO wapNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Utukapa fig kadunaa dunapo daawa ii. Sariapa umakon naꞌiti utukapaꞌazon ukaakan, mazan aonaa baudaꞌapa uikodan uꞌaka, soo uanaba paꞌidiwaru. Uruu idi ukian fig kadunaa ati, “Aizii marii aonaa naꞌapainim pukaakauzon powaꞌa.” Unaꞌapan idi, mashaꞌapakii fig kadunaa maririꞌikan naꞌiki umawakan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kaimanaiman utominapa-kidaniinao tukapan naꞌapam atamun mawakaꞌakan kadimanaꞌo idaꞌan, naꞌiki tuukii ĩdiꞌitinpan udauꞌu. Uruu idi ĩpishaan Jesus. Ĩkian uꞌati, “Naꞌapaꞌoran naa fig kadunaa mawakaꞌakan kadimanaꞌo idaꞌan manawun?” ");
INSERT INTO wapNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus kian ĩꞌati, “Õkowaadan nii uꞌati mishiꞌo, umishidan an kaimanaiman, aonaa umamishidakan bii an mani, ukaꞌiitan nii ushaꞌapatan powaꞌa zii õshaꞌapataꞌaka nii ai. Turuꞌo nii ukian midukuo ati, ‘Midukuo, puzikadin diꞌikiꞌi paran baoko iti.’ Naꞌapaꞌo nii ushaꞌapatinan uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ukauꞌan taa-karu nii uꞌati upishaanii utoriinpan idaꞌan Tominkaru ati, umishidan an õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aizii Jesus kaawan naa powaa ati Tominkaru Dapu iti. Utominapa-kidan puꞌu pidannao naꞌii, faadaanao zowaunaanao naꞌiki kazowautapainao Jewnao kaawan naꞌiti uꞌidiꞌiti. Ĩpishaanuzu, ĩkian, “Kanom aipan atiꞌo pushaꞌapatan kaikapaꞌoraz aimaakan kidaꞌa? Kanom dyuudanii pushaꞌapatan naꞌapa kidaꞌo?” ");
INSERT INTO wapNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus kian ĩꞌati, “Ukowaada õꞌati baudaꞌapaꞌo aimaakan dauꞌu õpishaan an unao. Ukowaadan an õꞌati, õkowaadan nii uꞌati kanom aipan atiꞌi õshaꞌapatanuzu naꞌapa kidaꞌo aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Uruꞌu naa Jesus pishaan ĩdyaun. Ukian ĩꞌati, “Kanom aipan atiꞌi John chikaawunuupauzon pidannao? Tominkaru aipan atiꞌo oo pidannao aipan atiꞌo?” Sariapa ĩparadan paꞌatiaaka kida Jesus pishaanii dauꞌan. Ĩkian, “Wakian dono uꞌati Tominkaru aipan atiꞌo John chikaawunuuapanuz pidannao, sariaapaꞌo nii ukian waꞌati, ‘Kanom nii mooko aonaa umishidanuzu.’ ");
INSERT INTO wapNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aizii wakian an ‘pidannao aipan atiꞌo,’ mazan watarii panaadon pidannao shaꞌapatan nii waunao dikaudaꞌo idaꞌan, ushaꞌapanum kauꞌan ipai pidannao mishidanii John, Tominkaru prophetin uruu.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Uruu idi ĩkian Jesus ati, “Aonaa waaitapan,” ĩkian. Jesus kian ĩꞌati, “Ukauꞌan aonaꞌo nii õkowaadan uꞌati kanom aipan atiꞌo õshaꞌapaapan diꞌoraz aimaakan kidaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Naꞌapam uꞌitiiman,” Jesus kian. “Baukapaiman kainaꞌa pidan, dyaꞌutamaꞌo udainao daonaioranao. Umakon kiwiiniꞌo paudani diꞌiti, naꞌiki ukian uꞌati, ‘Õdani, pumako pukaudinaꞌan aizii õpaoriba grape baawu iti.’ ");
INSERT INTO wapNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Udani dakoꞌatin uparadan. Ukian, ‘Aonaa õkaudinaꞌazon.’ Mazan udaunaꞌan udiꞌitinpan sariapa upanaꞌadan panyukunuu, uruꞌu naa ukaudinaꞌanan padaru paoriba grape baawu iti. ");
INSERT INTO wapNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aizii udaru makon naa udawuꞌichan diꞌitiꞌi naa. Naꞌapa koshan udyuudanuzu. ‘Õmakon nii õkaudinaꞌanan,’ ukian paꞌan padaru ati. Mazan upuꞌu, aonaa umakon ukaudinaꞌanan. ");
INSERT INTO wapNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Naꞌiaꞌoram udani uꞌitiiman shaꞌapataꞌo padaru aiapanii?” “Kiwiiniꞌo udani ushaꞌapata padaru aipan kawanaꞌati,” ĩkian uꞌati. Jesus kian ĩꞌati, “Õkowaadan uꞌati mishiꞌo, zaamaapauzonao tax puraatannaa naꞌiki zunnao kaminshuꞌu-shoronao, kiwiitaꞌa naa ĩdyaun unao ai Tominkaru naobanai-tinan diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ushaꞌapanum idi John Chikaawunuupauzo kaawankan, utukapa-kidankan naꞌapam tanawatin-karu mashaapa-karu kaimanaꞌo diꞌiti Tominkaru ati, upuꞌu aonaa umishidanuzu. Mazan zaamaapauzonao tax puraatannaa naꞌiki zunnao kaminshuꞌu-shoronao, ĩmishida uruu paꞌan. Unao, utukapan puꞌu zaamaapauzonao tax puraatannaa naꞌiki zunnao kaminshuꞌu-shoronao tanawatinan paꞌoian ai, mazan upuꞌu zii aonaa utanawatinaꞌazon uꞌoian ai.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Uabata baꞌoran diꞌitinapa-kinai kuwai koshan,” Jesus kian. “Baukapaiman kainaꞌa pidan paowan paoribai grape baawu paꞌamazadati diꞌii. Ukorarata awauta wuruꞌu papaoriba baawuz. Udaunaꞌan ukichadan kaꞌunaru dadaraꞌo baaraꞌa, grape uu sararoo-kizinao nii. Udaunaꞌan utoman dokoaꞌo kabaun grape baawu watchmantapa-kizinao nii. Udaunaꞌan utaan naa grape baawu pidannao ati, ĩawunuutapa kizi zii uꞌatizu. Uruꞌu naa umakon naa baꞌoran wiizai iti. ");
INSERT INTO wapNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Grape ozokan kawanaꞌatiꞌi naa, udyuudan papoitorunao wunao diꞌitiꞌi awunuutapainaouz papaoriba grape baawu, ĩnaꞌanan naa ukaꞌidiwaun-kinaa nii papaoriba aka winipinaa idi. ");
INSERT INTO wapNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mazan uzaamataniinaouz awunuutapaꞌo nii papaoriba grape baawu zaamatan upoitorunao, ĩbaꞌiziautapa baudaꞌapaꞌo, ĩzowii baꞌoran, naꞌiki ĩbowautapa kuba idi baꞌoran. ");
INSERT INTO wapNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Udaunaꞌan udyuuda papoitorunao naꞌiti ĩꞌidiꞌiti koshan. Powaꞌa zii ĩiriban kiwiitapaꞌo padyuudaniinao ai. Naꞌapa kiwiitapaꞌo kawan koshan awunuutapainao upaoriba baawu shaꞌapatan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Dawuꞌitin, udyuudan naa paudani ĩꞌidiꞌiti. Ukian paudani dauꞌan, ‘Ĩmanawuntapan nii paꞌan õdani.’ ");
INSERT INTO wapNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Mazan awunuutapainao upaoriba baawu tukapan kapaoribaꞌo daniꞌi naa kaawan paꞌidaꞌati. Sariapa ĩkian, ‘Diꞌi naa kapaoribaꞌo dani. Uruꞌo nii wuruꞌu kaidiwauꞌoraz padaru diꞌiki upaoriba baawu idi. Baushaa, wazowii uruu, wazaamata kizi wuruꞌu uꞌidiwau niꞌoraz.’ ");
INSERT INTO wapNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Uruu idi ĩzaamataꞌakan naꞌiki ĩkozootaꞌakanuz paoribai baawu iki, naꞌiki ĩzowian naazu. ");
INSERT INTO wapNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Aizii kapaoribaꞌo kaawan donoꞌo naa powaa ati, naꞌapam nii ushaꞌapatan pazaamataniinao awunuutapaꞌo nii papaoriba baawu?” Jesus kian. ");
INSERT INTO wapNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kazowautapainao pidannao dakoꞌatin Jesus paradan. Ĩkian, “Upatakaꞌutan nii naꞌiki uzowian nii wuruꞌu oiainaouz pidannao. Udaunaꞌan utaan nii papaoriba baawu baꞌoran pidannao ati, kaimanaꞌo nii paꞌan ĩawunuutapanuzu. Ĩnaouꞌo niꞌi naa kaiman ĩtaan uꞌidiwau nii upaoriba aka diꞌiki, upaoriba kaakan dono.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus kian ĩꞌati koshan, “Aonaa mooko uaitauzon saada-kariwaiz kida Tominkaru Paradan idaꞌa kaikapaꞌorazuꞌu? ‘Wuruꞌu kuba tomapauzonao kabaun kashadaniaz, madiwautapa-kaꞌoraz ĩtukapan, uruꞌu naa mishiꞌoraiman umanawunuꞌo kuba ipai baꞌoran kubanao ai. Uruu Tominkaru kaudin-kizi wuruꞌu, umanawunuꞌoraz utukapa-kao.’ ");
INSERT INTO wapNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ukauꞌan õkowaadan uꞌati, kazata-kao nii uwiizi niꞌo Tominkaru naobanai-tinapa-kizi ii. Naꞌiki utaa-kao nii pidannao ati kaimanainaouz ĩshaꞌapainpan Tominkaru aipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pidan kaboinaꞌo diꞌoraz kuba paawa ati, baiainpaꞌo nii tuukii. Naꞌiki uruu kuba waotan dono naꞌiaꞌoram pidan paawa ati, ipaiꞌo nii uꞌidon.” ");
INSERT INTO wapNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aizii faadaanao zowaunaanao naꞌiki Phariseenao abatan Jesus kowaadan kuwai kaikapaꞌa, ĩaitapa wuruꞌu kuwai kidaz ĩnao dauꞌanaꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Uruu idi ĩtiwaan pazaamatanuzu, mazan tuukii ĩtarian pidannao ai, ushaꞌapanum kauꞌan pidannao kian Jesus dauꞌan, Tominkaru prophetin wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Udaunaꞌan Jesus paradan diꞌitinapa-kinai kuwai kida idaꞌan koshan pidannao ati. Ukian. ");
INSERT INTO wapNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kaikapaꞌo wuruꞌu Tominkaru naobanai-tinapanuz: naꞌapa king minziiwata-kidan kawan umanawunuꞌo aroapa-karu paudani mazidan ati. ");
INSERT INTO wapNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aizii aroapa-karu kamoon donoꞌo naa, udyuudan naa papoitorunao dapada-kariwainao pidannao diꞌiti ĩwaꞌati kiziꞌi naa aroapa-karu idaꞌati, mazan aonaa ĩwaꞌatiꞌizon. ");
INSERT INTO wapNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Uruu idi udyuudan baꞌoran papoitorunao dapada-kariwainao diꞌiti koshan. Ukian papoitorunao ati, ‘Ukowaadankaꞌa naa dapada-kariwainao ati, ipaiꞌi naa õminziiwa-kidan aroapa-karu daꞌaꞌa. Õzowii-kidaꞌa naa kakiwin kidaꞌo õꞌuza tapiꞌizanao, ukauꞌan marinaꞌa naa ĩwaꞌatin kadiman.’ ");
INSERT INTO wapNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ukowaada-kaoaꞌa naa dapada-kariwainao ati, mazan aonaa ĩtaan panyukunuu ati padapada-kao. Ushaꞌapanum idi kainaꞌa ĩshaꞌapataꞌazoonii kida paꞌati: baudaꞌapaꞌo makoꞌozon pazakapun iti; baꞌoran papuraataapauzon dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aizii baꞌorainao zaamatan wuruꞌu poitoruinaouz, ĩantamikitan ĩdyaun naꞌiki ĩzowii wuruꞌu king poitorunaouz. ");
INSERT INTO wapNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King toꞌoran tuukii, uruu idi udyuudan pasoldyaannao naꞌiti ĩzowii ipai zowiainaouz upoitorunao, naꞌiki ĩkawaoda zowii-mikinao mashaapa-kizi donoi. ");
INSERT INTO wapNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Uruu daunaꞌan king dapadan baꞌoran papoitorunao naꞌiki ukian ĩꞌati, ‘Aizii mazidaꞌo aroapa-kinaa niꞌo, ipaiꞌi naa uminziiwa-kida-kao, mazan õdapadaniinao, ĩtukapa-kida ĩmawaꞌatiꞌizookan idaꞌan, aonaa ĩturuan pawaꞌatin. ");
INSERT INTO wapNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ukauꞌan umako pidan iriba-kizi iti, udapada kizi ipai pidannao uikodan kawanaꞌati, ĩwaꞌati kizi mazida-karu aroapa-kida-kao idaꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Uruu idi poitoruinao makon diꞌiti kidaꞌa pidan iriba-kizi iti. Ĩdapada iriba pidannao paikodan kawanaꞌati. Shaꞌapaꞌoram karikaonan pidan, kaimanainao naꞌiki dikaudainao, mazan iriba ĩikodan pidannao, ĩpaidada kabaun nazoo wuruꞌu aroapa-kizaiz. ");
INSERT INTO wapNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Aizii King tukapaꞌanan padapada-kidaniinao. Utukapa baudaꞌapa daonaiora naꞌii, aonaꞌa ukaiwadapan mazida-karu diꞌitiꞌo daara. ");
INSERT INTO wapNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Uruu idi King kian uꞌati, ‘Õpaonaru, naꞌapaꞌoram pumorotan daꞌatiꞌi pumakaiwadapakan puꞌu mazida-karu diꞌitiꞌo daara?’ Aonaa naꞌapam daonaiora kian uꞌati. Umaparadaniitaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Udaunaꞌan king kian papoitorunao ati, ‘Udodoo uruu naꞌiki ukaboota uruu paniba iti marutaꞌo-karu iti. Naꞌii zaadin-karu nii tuukii, naꞌiki pidannao kuzowan nii paudako padopian idi.’” ");
INSERT INTO wapNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesus katokontan pakuwaa pakian idaꞌan kaikapaꞌa: “Iribaꞌo nii pidannao dapada-kao padamata, mazan masakaudaꞌuꞌo nii ĩzaamata-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Uruu daunaꞌan Phariseenao makon naa ĩparadaakaꞌanan paꞌatiaaka. Ĩdiꞌitinpaꞌanan naꞌapam nii pazaamatan Jesus uparadan idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Panaꞌapainpan idi ĩdyuudan patominapa-kidaniinao, Herod pidanannao tuma Jesus diꞌiti. Aizii dyuuda-kariwainao kian Jesus ati, “Tiichaa, waaitapa pugaru kaimanaꞌo, mishiꞌo puparadan. Putominapa-kidan pidannao kaiman Tominkaru aipan kawanaꞌati. Naꞌiki naꞌapa kida putaapan pidannao, aonaa naꞌiaꞌoram umanawunuꞌo nii baꞌoran ai. ");
INSERT INTO wapNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aizii pukowaada waꞌati, kaimanaꞌo mani wataanuzu tax puraatan naobanai Caesar ati, oo aonaa ukaimanan?” ");
INSERT INTO wapNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mazan Jesus aitapa ĩdiꞌitinpan oii, uruu idi ukian ĩꞌati, “Unao, utaapinpauzonao kaimanainao nii kaikiniꞌi! Kanom nii utiwaan uzaamatan õgaru õparadan dikin ii? ");
INSERT INTO wapNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Uaida-kida mooko õꞌati puraata ukawinipinaata-kinaaz tax.” Ĩnaꞌaka uꞌidaꞌati wuruꞌu puraataz. ");
INSERT INTO wapNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sariapa upishaan ĩdyaun. Ukian, “Kanom dikin wuruꞌu, naꞌiki kanom uu wuruꞌu saada-kariwaiz puraata idaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Naobanai Caesar” ĩkian ĩdakoꞌatinuzu. Udaunaꞌan ukian ĩꞌati, “Utaa ukauꞌan Caesar ati kanom wuruꞌu Caesar idiwau kidaz. Aizii Tominkaru ati utaa Tominkaru idiwau kida.” ");
INSERT INTO wapNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ĩabatan idi Jesus kian kaikapaꞌa, tuukii ĩdiꞌitinpan naꞌiki ĩmakon naa uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Naꞌapain uruu dono pabiꞌi kida Sadduceenao kaawan Jesus idaꞌati. Ĩnao aonaa ĩmishidan kakupa-karu nii mawaka-karu daunaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ĩpishaanuzu. Ĩkian uꞌati, “Tiichaa, Moses kian waꞌati, daonaiora mawakan dono, aonaꞌo zii udani nii, marii uꞌinawuzu zaamatan udaiaro-daun paudaiaro nii. Uruu idaꞌanaꞌo nii mawakaꞌo uꞌinawuzu kaudanin. ");
INSERT INTO wapNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aizii dii mani kainaꞌa pidan 7 udainao daonaioranao. Ĩtuuniz mazidan, mazan umawakan paudairo ai aonaa zii udani nii, uruu idi udawuꞌitiꞌo uꞌinawuzu daiaroitapan naa oroo. ");
INSERT INTO wapNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Naꞌapa koshan umawakan oꞌai. Udaunaꞌan baꞌoran uꞌinawuzu mazidan otuma, mawaka koshan oꞌai. Atii naꞌapa ipai ĩmawakan. Ukauꞌan ipai 7 ĩdyaun daiaroitapan oroo. Mazan aonaa baudaꞌapaꞌo kaudanin otuma. ");
INSERT INTO wapNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dawuꞌitin uruꞌu naa zunaaba mawakan naa kapam.” ");
INSERT INTO wapNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aizii ĩpishaan Jesus, ĩkian uꞌati, “Aizii pidannao kadishita-kida-kao dono pamawaka-kizi iki, naꞌiaꞌoram nii daiaroitapa oroo? Ushaꞌapanum kauꞌan ipai 7 daonaioranao mazidaꞌo õtuma?” ");
INSERT INTO wapNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus dakoꞌatin ĩdyaun. Ukian, “Upozawatan kaiwuruꞌu umaaitapakan idi saada-kariwaiz Tominkaru Paradan naꞌiki aonaa uaitapan Tominkaru maꞌozakan. ");
INSERT INTO wapNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mawakainao kadishitan dono, aonaꞌo niꞌi naa kaudaiaro-karu naꞌapain, mazan naꞌapaꞌo nii angelnao aokazi iainao kawan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aonaa mooko uaitapan naꞌapam Tominkaru Paradan kian kadishita-karu dauꞌan mawaka-karu diꞌiki? ");
INSERT INTO wapNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Tominkaru kian, ‘Õgaru wuruꞌu Abraham, Isaac naꞌiki Jacob Tominkarunuz.’ Ukauꞌan aonaa mawakainao pidannao Tominkarun mani uruu, mazan kakupainao pidannao Tominkarun.” ");
INSERT INTO wapNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pidannao abatan idi Jesus tominapa-kidan kaikapaꞌa, tuukii ĩdiꞌitinpan utominapa-kidanii kida dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aizii Phariseenao abatan idi aonaa Sadduceenao aitapan naꞌapam naa pakian powaꞌa Jesus ati, utominapa-kidan idi kaimanaꞌa naa manawun, sariapa ĩbaokopatinan. ");
INSERT INTO wapNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Naꞌiki baudaꞌapa ĩiriban tiichaapauzo Moses kakinaori dauꞌu pishaan Jesus, patiwaa-kidapa-kinaa niizu. ");
INSERT INTO wapNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ukian uꞌati, “Tiichaa, naꞌiaꞌoram dii manawun umanawunuꞌo kakinaorii?” ");
INSERT INTO wapNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus kian uꞌati, “‘Pumarainapa tuukii Naobanai puTominkarun ipai punyukunuu iki, ipai pudoronaa ii, naꞌiki ipai pudiꞌitinpan idaꞌan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Uruu wuruꞌu umanawunuꞌoraz manawun kakinaorii. ");
INSERT INTO wapNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Baꞌoran kakinaorii, udawuꞌatiꞌo umanawunun, kaikapaꞌoraꞌa: ‘Pumarainapa baꞌoran pidan naꞌapa pumarainpan kawan punanaa.’ ");
INSERT INTO wapNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ipai Tominkaru kakinaori kida Moses idaꞌanaꞌoraz utaa-kao, naꞌiki kakinaorii prophetnao tominapa-kidanii kida, zaamatinpan patumaaka wuruꞌu idaꞌatiꞌi dyaꞌutamaꞌoraz kakinaorii.” ");
INSERT INTO wapNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Phariseenao kasabaꞌukinpan puꞌu, Jesus pishaan ĩdyaun kaikapaꞌa: ");
INSERT INTO wapNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Naꞌapam ukian Christ dauꞌan? Kanom takaan-daun uruu?” “David takaan-daun,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus kian ĩꞌati, “Mazan kanom nii mooko Tominkaru Doronaa aipan ati David dakotan uruu paNaobanaa nii. Ukianuz daꞌi uꞌati: ");
INSERT INTO wapNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Naobanai Tominkaru kian õnaobanaa ati, pusakanata daꞌaꞌa õdiwaꞌora antanapu atii õwaranuita-kidan putarubanao ipai pukidiba waranu ati.’ ");
INSERT INTO wapNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aizii David dakotan puꞌu uruu paNaobanaa nii, naꞌapam naa mooko utakaan-daun wuruꞌu uruuz?” ");
INSERT INTO wapNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aonaa naꞌiaꞌoram aitapaꞌo nii naꞌapam naa pakian powaꞌa Jesus ati. Naꞌiki uruu daunaꞌan aonaa kanom kaꞌiitan naa papishaan powaꞌa uruu. ");
INSERT INTO wapNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Udaunaꞌan Jesus paradan pidannao ati baokopa patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ukian “Wuruꞌu tiichaapauzonao Moses kakinaori dauꞌu naꞌiki Phariseenao kakinaopan Tominkaru taanii Moses atiꞌo kakinaorii diꞌikiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ukauꞌan uizoꞌati naꞌiki ushaꞌapata ĩkowaadapanii kida kawanaꞌati, mazan aonaa utamakapaꞌanaꞌa ĩkaduz kida. Ushaꞌapanum kauꞌan aonaa ĩshaꞌapatinan pakowaadanii kakinaorii kida kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ĩdobatadan powaꞌa zii kakinaorii kida, aonaꞌa naa pidannao kaꞌiitan pashaꞌapatinan ukawanaꞌati, mazan upuꞌu aonaa ĩkaminkaꞌutan ĩdyaun, aonaa masakaudaꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ipai aimaakan ĩshaꞌapatanii kida, soo ĩaipan pidannao tukapan, naꞌiki ĩaipan paꞌatadapa-kao. Naꞌiki udaru kidaꞌa naa ĩtoman saada-kariwai Tominkaru Paradan mashaapa-kizi kida, ĩkaiwadauzonii kidaz patawuꞌu naꞌiki paanoba kida idaꞌa. Ĩkamichan ziishinaa kida, dawuu ĩtoman kida kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kaiman ĩꞌati pataapa-kao udaruꞌo pidan nii aroapa-kizai ii aka, naꞌiki ĩnaudapa pasakanatan umanawunuꞌo tabai idaꞌa synagogue kida diꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kaiman ĩꞌati pataapa-kao umanawunuꞌo nii market ii pidannao iriba-kizi ii aka. Naꞌiki ĩnaudapa padakotapa-kao Tiichaa kii. ");
INSERT INTO wapNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Aizii unao, aonaa udakota-kidinaꞌanaꞌa Tiichaa nii, ushaꞌapanum kauꞌan kainaꞌa baudaꞌapa utiichaan, ipai unao naꞌapa kidaꞌo paꞌan uiribannao tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aonaa udakotaꞌanaꞌa pidan daꞌaꞌa imiꞌi baaraꞌaꞌo ‘wadaru’ kii, ushaꞌapanum kauꞌan kainaꞌa baudaꞌapa udaru, uruu aokazi iaꞌoraz paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aonaa utaapadaꞌanaꞌa udakota-kao naobanai nii, ushaꞌapanum kauꞌan kainaꞌa baudaꞌapa unaobanaa, uruu Christ. ");
INSERT INTO wapNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kanom manawun-tinaꞌo pakazowautapan idaꞌan unao, marii ukaudinan unao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Naꞌiaꞌoram pidan umanawun-tinpaꞌo, waranuita-kao nii uruu. Naꞌiki naꞌiaꞌoram pidan waranuitapa-kidinaꞌo, Tominkaru toman nii uruu umanawunuꞌo pidan nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kashaꞌoraꞌo nii manawun ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki unao Phariseenao, taapinpainao kaimanainao nii kaikiniꞌi. Uawautapan pidannao morotaꞌazon Tominkaru naobanai-tinapa-kizi iti. Mazan unao, naꞌapa, aonaa umorotan naꞌiti, naꞌiki aonaa utaapadan pidannao morotan, tiwautinainaouz padamata pamorotan naꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kashaꞌoraꞌo nii ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki unao Phariseenao, taapinpainao karikaonan kaimanaꞌo nii. Ukashadapan zunnao mawakaꞌo ĩdaiarunao, naꞌiki ukazatan ĩdapu naꞌiki ĩshaꞌapauz kida. Mazan uaipan idi utaapa-kao kaimanainao nii, uruu idi utoriinpauzon tomunuꞌiki kida. Unaꞌapan idi powaꞌaꞌo nii zii upatakaꞌuta-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kashaꞌoraꞌo nii ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki unao Phariseenao, taapinpainao kaimanainao nii kaikiniꞌi. Umakon munapo atii utarauka paran uzaamataꞌazon idi baudaꞌapa sabaꞌo pidan mishidapaꞌo nii ukakinaori kida. Udaunaꞌan utominapa-kidan naazu, powaꞌa zii udikaudan unao ai, kaboota-karu nii tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kashaꞌoraꞌo nii manawun ubaiaapan, unao ishaawunnao, naꞌakapaꞌo pidannao. Ukian, ‘Pidan dakotaꞌo Tominkaru Dapu uu paparadan mishida-kinao nii, aonaꞌo nii ushaꞌapan umashaꞌapatakan anaz, mazan naꞌiaꞌoram pidan dakotaꞌo gold, Tominkaru Dapu iaꞌoraz, paparadan mishida-kinao nii, marii ushaꞌapatan pakowaadaniaz mishiꞌo pashaꞌapataꞌazon.’ ");
INSERT INTO wapNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Unao maaitapin-kaꞌo ishaawunnao, kanom powaꞌaꞌo zii umanawunun, wuruꞌu gold, oo Tominkaru Dapu saabaaꞌoraz gold kaimanaꞌo nii? ");
INSERT INTO wapNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Unao kian, ‘Naꞌiaꞌoram pidan dakotaꞌo altar paparadan mishida-kinao nii, aonaꞌo nii ushaꞌapan umashaꞌapatakan anaz, mazan naꞌiaꞌoram pidan dakotaꞌo taa-kariwai kawaoda-karu nii altar paawaꞌa paparadan mishida-kinao nii, marii ushaꞌapatan pakowaadaniaz mishiꞌo pashaꞌapataꞌazon.’ ");
INSERT INTO wapNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Unao ishaawunnao! Kanom powaꞌaꞌo umanawunun, taa-kariwai altar paawaꞌa oo altar, saabaaꞌoraz taa-kariwaiz kida kaimanaꞌo nii? ");
INSERT INTO wapNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ukauꞌan pidan dakotaꞌo altar paparadan mishida-kinao nii, udakotan altar naꞌiki ipai upaawaꞌaꞌo kapam wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aizii pidan dakotaꞌo Tominkaru Dapu papaparadan mishida-kinao nii, udakotan Tominkaru Dapu uu naꞌiki Tominkaru kapam wuruꞌu paparadan mishida-kinao nii, Tominkaru mashaapan idi naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pidan dakotaꞌo aokazi paparadan mishida-kinao nii, udakotan Tominkaru taba naꞌiki sakanatapaꞌoraz upaawaꞌa kapam wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kashaꞌoraꞌo nii manawun ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki unao Phariseenao! Unao taapinpainao kaimanainao nii kaikiniꞌi! Utaa 1/10 ipai wanyukunui kaduunuribanaa ziꞌinaba sodi kida diꞌiki. Mazan unao, umarinaꞌatan ushaꞌapatan kaiman-karu, kamunan-karu, naꞌiki mishida-karu. Uruu kida kaimanaꞌo manawun kakinaorii umanyukunuutaniaz. Ushaꞌapatinaꞌoraz mani padamata ipai ukakinaorinaa kida kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Unao, uꞌishaawunnao naꞌakapan kawanuꞌo papidanannao. Mishi unao uzaudinauzonii udyokorautan ai masakaudaꞌu kaniribaꞌo utuzan niꞌo diꞌiki, upuꞌu zii mazan aonaa uaitapan udyokorautan udaruꞌoraꞌa naa aimaakan kawaro kawanuꞌo uꞌudarun. ");
INSERT INTO wapNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kashaꞌoraꞌo nii manawun ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki unao Phariseenao, taapinpainao kaimanainao nii kaikiniꞌi. Uchikaan ukoopon naꞌiki uparaapin, aonaa ukaniriban uaidinpan pabarau iki kida, mazan unazoo kida paida kaniribaꞌo idi. Naꞌapaꞌo unao, upaidadinaꞌo dikaudaꞌo idi, uaipan idaꞌan uzaamatan ipai aimaakan uꞌatiꞌo nii karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Unao ishaawunnao Phariseenao, uchikaa kiwiitapa ukoopon naꞌiki uparaapin nazoo kida, uruu idi ubarau kida, aonaꞌo niꞌi naa ukaniriban kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kashaꞌoraꞌo nii manawun ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki unao Phariseenao, taapinpainao kaimanainao nii kaikiniꞌi. Naꞌapa unao mawakaꞌo kinnaa zichida-kao kawan barakaꞌo idi. Konaunam uaidinpan, mazan unazoo paida mawakaꞌo pidannao niwaꞌuz idi, naꞌiki kaniribaꞌo, dyupusha kidaꞌo idi. ");
INSERT INTO wapNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Naꞌapaꞌo kapam pidannao tukapan unao, kaimanaꞌo kawan, mazan unyukunuu ii, oiaꞌo unao, taapinpainao karikaonan kaimanaꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kashaꞌoraꞌo nii manawun ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki unao Phariseenao, taapinpaꞌazoinao kaimanainao nii kaikiniꞌi. Utoman kaiman kida Tominkaru prophetinnao baaranaa nii, naꞌiki kaimanainao pidannao baaranaa nii, kaiman ukonaunamadan kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aizii ukian, ‘Wamashaapan dono mani kotuaꞌa naa wadokozu-daunnao mashaapankan dono, aonaa mani wazowian Tominkaru prophetinnao ĩnao kawan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ukauꞌan uaipan ati ukainaabainan, unao wuruꞌu zowii-mikinao takaan-daunnaouz. ");
INSERT INTO wapNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aushaꞌa naa, uipaidaꞌa naa ushaꞌapatan udokozu-daunnao sakadaniaz naa pashaꞌapatan oii kidaꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jesus kian koshan ĩꞌati, “Unao kowazaznao oiaꞌo manawun naꞌiki unao kowazaz dainao. Naꞌapam nii ukazannaatinan ukaboota-kao ai Tuubaruꞌo Tikazi wuꞌiti? ");
INSERT INTO wapNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ukauꞌan õdyuudan nii uꞌidiꞌiti prophetnao, aitapaabaꞌo pidannao naꞌiki tominapa-kidaꞌo nii pidannao Kaimanaꞌo Kuwai dauꞌu. Mazan uzowian nii pabiꞌi kida ĩdyaun utauka-kidan idaꞌan ĩdyaun cross diꞌiti. Baꞌorainao ubaꞌizian nii synagogue kida diꞌii. Naꞌiki umakon nii uantamikitaꞌanan kidoopainao baꞌoran donoi iti kida. ");
INSERT INTO wapNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Uruu idi unaouꞌo nii kabaiaapan ipai wunao zannaꞌa Tominkaru pidanannao zowii-kariwainao kidaz. Abel kaimanaꞌoraz pidan zowii-kao diꞌiki, atii Zechariah Berechiah dani zowii-kao diꞌiti. Uruu unao zowianiaz, Tominkaru Dapu naꞌiki altar, uzai kawaodapa-kizinao sakodaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Õkowaadan uꞌati mishiꞌo, ipai wuruꞌu dikaudaꞌo shaꞌapatauzo-kariwaiz kida, unao kaiꞌoraz pidannaouꞌo niꞌi naa patakaꞌuta-kao udikin ii ĩwinipinaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesus kian, “Oo Jerusalem, Jerusalem. Puꞌidaꞌainao pidannao zowiaꞌoraz prophetnao naꞌiki zowiaꞌoraz pabooan idaꞌan kuba idi dyuuda-kariwai pidannao kakuwaapan puꞌidiꞌiti. Karikaonanuꞌu daꞌi padamata õaipan õkazannaatapan puꞌidaꞌainao pidannao, naꞌapa kuruku kazannaatapan kawan paudainao pakutuba kida waranuꞌu. Mazan aonaa putaapadan õkazannaatan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Putukapa, Tominkaru waꞌakan padapu, aonaꞌo nii kanom puzannaa nii. ");
INSERT INTO wapNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aizii õkowaadan puꞌati, aonaꞌo nii powaꞌa putukapan õgaru atii kainaꞌaꞌo nii kamoo kaawan, naꞌapainiꞌo nii pukian ‘Marii Tominkaru kaimanan diꞌoraz Naobanai atiꞌi, kaawaꞌoraz uaipan kawanaꞌati.’” ");
INSERT INTO wapNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Udaunaꞌan Jesus koditan naa Tominkaru Dapu iki, naꞌiki umakopan puꞌaꞌa naa, utominapa-kidaniinao tukapa-kidan uꞌati wuruꞌu kabaun kidaz Tominkaru Dapu iaꞌoraz, naꞌapam utoma-kao udaru naꞌiki konaunam. ");
INSERT INTO wapNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus kian, “Utukapa ipai wuruꞌu kabaun kidaz. Õkowaadan uꞌati mishiꞌo, aonaꞌo nii baudaꞌapa kuba mashaapan papaawa atiaaka kida naꞌii, ipaiꞌo nii ukaboobiꞌii-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Udaunaꞌan Jesus sakanatapan puꞌu Olive Naawa ii, utominapa-kidaniinao waꞌatin ĩnao paꞌidiwaru uꞌidaꞌati. Ĩkian uꞌati, “Pukowaada waꞌati naꞌapainim nii kaiwuru shaꞌapanuꞌu. Kanomaꞌo nii shaꞌapa kainaabataꞌo nii puwaꞌatin naꞌiki diꞌoraz amazada ikodan patokon?” ");
INSERT INTO wapNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus kian ĩꞌati, “Uzaudin paꞌi, aonaa umariidapa-kidinaꞌanaꞌa pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ushaꞌapanum kauꞌan iribaꞌo nii pidannao kaawan, ĩkian nii, ‘õgaru Christ,’ naꞌiki ĩmariidan nii iriba pidannao. ");
INSERT INTO wapNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Uabatan nii mizaataaka-karu kida dauꞌan naꞌiki kadakotin-karu nii mizaataakaꞌazoo-karu kida dauꞌan, mazan aonaa utariaꞌanaꞌa. Naꞌapa kidaꞌo aimaakan shaꞌapan nii, mazan aonaa amazada ikodan zii mani patokon wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Baudaꞌapaꞌo wiizai ikiꞌo pidannao mizaataakan nii baꞌoran wiizai ikiꞌo pidannao tuma, naꞌiki baudaꞌapaꞌo donoi ikiꞌo pidannao mizaataakan nii baꞌoran donoi ikiꞌo pidannao tuma. Zamazi kaawan nii, naꞌiki ipai amazada kawanaꞌati kainaꞌaꞌo nii kichanaꞌiki-kiaꞌo amazada nakainan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kaikapa kidaꞌorazuꞌu, kashaꞌoraꞌo baiaapa-kao sakadinan zii karikaonan wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Udaunaꞌan unao, uzaamata-kao nii, uantamikita-kao nii, naꞌiki uzowii-kao nii. Ipai pidannao toꞌora-kizaitapan nii unao, õgaru dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Uruu dono iribaꞌo nii pidannao tanawatinan pamishidapan ai õgaru, uruu idi ĩkaakapaakan nii naꞌiki ĩtoꞌora-kizaitapaakan nii. ");
INSERT INTO wapNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Naꞌiki iribaꞌo nii dakotinpainao prophetnao nii kakuwaapaꞌanan, ĩmariidan nii iriba pidannao. ");
INSERT INTO wapNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pidannao oiidinan idi tuukiaꞌa naa manawun, aonaꞌo niꞌi naa marainpaaka-karu. ");
INSERT INTO wapNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mazan kanomnao maꞌozakaꞌo ĩmishidapan atii utokon iti, ĩnaouꞌo nii kazannaata-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aizii diꞌoraz Kaimanaꞌo Kuwai Tominkaru naobanai-tinan dauaꞌoraz kowaada-kao nii ipai amazada kawanaꞌati. Marii kizi zii ipai pidannao abatan naꞌiki ĩaitapan udauꞌan. Udaunaꞌan uruꞌo niꞌi naa diꞌoraz amazada ikodan patokon.” ");
INSERT INTO wapNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesus kian koshan, “Naꞌapa prophet Daniel kowaadauzoniaz shaꞌapaꞌo nii, utukapan nii aimaakan oiaꞌo Tominkaru Dapu nazo ii, patakaꞌuaꞌo nii Tominkaru Dapu, aonaa kizi naꞌitim choochiapa-karu naꞌii. (Marii pidan tukapaꞌo kaarita idaꞌa udauꞌanaꞌo, aitapanuz.) ");
INSERT INTO wapNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Utukapan donoꞌo naazu, marii kizi Judea Baara iainao pidannao kidoopan midukuo baawu iti. ");
INSERT INTO wapNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Marii naꞌiaꞌoram pidan paniba iaꞌo padapu ai, aonaa kizi umorotan uminziiwa-kidaꞌanan zii mani paaiapanii pashaꞌapauz padapu nazo iti. ");
INSERT INTO wapNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Naꞌiki pazakapun iaꞌo pidan, aonaa turuu ukiwan padapu iti pakamichan dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Uruu dono dikaudaꞌo naꞌiki kashaꞌoraꞌo nii kaꞌazootinpainao naꞌiki dokoba-tinpainao zunnao baiaapan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Utoriinapa Tominkaru ati aonaa kizi ukidoopan amazada wadidiizon dono, oo Sookapa-karu Kamoon dono. ");
INSERT INTO wapNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ushaꞌapanum kauꞌan uruu dono tuukiaꞌo nii udikaudan, naꞌiki ukichanaꞌiki-kian pidan baiaapan. Aonaa naꞌapainim naꞌapaꞌo manawun baiaapauzo-kao amazada tominan ikiꞌo atii kai, naꞌiki aonaꞌo nii naꞌapainim pidan baiaapan naꞌapaꞌo koshan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mazan pazaamatanii pidannao dikin ii, Tominkaru awutadan nii uruu donoꞌoraz baiainapa-karu. Aizii aonaan dono uawutadanuz, aonaꞌo nii pidan waꞌakinan kakupa uruu dono. ");
INSERT INTO wapNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Uruu dono naꞌiaꞌoram pidan kian an uꞌati, ‘diꞌi wuruꞌu Christ,’ oo ‘kaidiꞌiizuꞌu,’ aonaa umishidaꞌanaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ushaꞌapanum kauꞌan kainaꞌaꞌo nii dakotinpainao Christ nii naꞌiki dakotinpainao prophetnao nii. Ĩshaꞌapatan nii umanawun kidaꞌo aimaakan, naꞌapaꞌo idaꞌan ĩtiwaan nii padamata pamariidan Tominkaru zaamataniinaouznaa papidanannao nii. ");
INSERT INTO wapNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Ukauꞌan uabata, uꞌuaꞌiaꞌo zii kaiwuruꞌu õkowaadanuz uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ukauꞌan naꞌiaꞌoram pidan kian an uꞌati, ‘kaidiꞌiizuꞌu baara ii,’ aonaa umakoꞌo naa naꞌiti. Oo ukian an uꞌati, ‘Kainaꞌa uruu, udizinpan kaidaꞌaꞌa,’ aonaa umishidaꞌanaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Toroanaru kan-kanan kawan waoko iki, turuu utukapa-kao wakadapu iti kapam. Naꞌapaꞌo nii utukapa-kao kapam wuruꞌu Daonaiora Aokazi Ikiꞌo waꞌatinuz. ");
INSERT INTO wapNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Naꞌiam aimaakan mawakan, naꞌiaꞌo nii watonao katonainpan tukapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kadiman aka dikaudaꞌoraz baiainapa-karu daunaꞌan, kamoo marutan nii, naꞌiki kauzu aonaꞌo nii ukanadapan. Wizinao waotaꞌo nii aokazi iki, naꞌiki ipaiꞌo nii aimaakan wuruꞌu doko ii kidaꞌoraz zikadinan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Uruu daunaꞌan Daonaiora Aokazi Ikiꞌo aidinan niꞌi naa doko ii. Naꞌiki ipai pabiꞌinaaka kidaꞌo pidannao imiꞌi baara an kidainao zaadan nii tuukii. Udaunaꞌan uruꞌo niꞌi naa ĩtukapan Daonaiora Aokazi Ikiꞌo waꞌatin naa ushaꞌuza kida paawa an doko iki, aokazi iki, umanawunuꞌo pamaꞌozakan naꞌiki umanawunuꞌo pakonaunaman idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naꞌiki diiwaꞌo kuwudii dapaapa-kinai poota-kao, naꞌiki udyuudan nii paꞌangelinnao dapaapaꞌanan naꞌiki ĩbaokopatan Tominkaru zaamatanii papidanannao nii, ipai diꞌikinapa kidaꞌa imiꞌi baara anaꞌo amazada kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesus kian koshan, “Aushaa udiꞌitapa fig kadunaa. Naꞌapainim upaꞌinaadinan naꞌiki uanaba paꞌishizo-dinan, uaitapa kamoo donoꞌo maonapatan naa wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ukauꞌan naꞌapaꞌo nii utukapan dono ipai kaikapa kidaꞌo shaꞌapanuꞌu, ukainaabatan maonapaꞌa naa õwaꞌatin, aonaa tomunuꞌikiꞌo niꞌi naa mani. ");
INSERT INTO wapNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Õkowaadan nii uꞌati aimaakan mishiꞌo, ipaiꞌo nii aimaakan kida shaꞌapan naꞌapa, kaiꞌo pidannao mawakan uaꞌii ipai. ");
INSERT INTO wapNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Aokazi naꞌiki imiꞌi baara mainaabatinaꞌo nii, mazan õparadan kidaz aonaꞌo nii umainaabatinan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mazan aonaꞌo nii pidan aitapan naꞌapainim nii manawun kaiwuru kida shaꞌapanuꞌu. Angelnao aokazi iainao, aonaꞌo nii ĩaitapan. Õgaru Tominkaru Dani naꞌapa, aonaꞌo nii õaitapan. Soo õdaru karikaonan aitapaꞌo nii udauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Naꞌapaꞌo nii Noah donoꞌo kawan amazada, Daonaiora Aokazi Ikiꞌo waꞌatin dono. ");
INSERT INTO wapNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Naꞌapain amazada naraan uaꞌii, pidannao aroopan, ĩtuzapan, naꞌiki ĩkaudaiaropan. Ĩmashaapan naꞌapa atii Noah morotan, upaidinan pakanowan zoꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mazan upuꞌu aonaa ĩaitapan kanom shaꞌapan atii udaruꞌo wunu kaawan naꞌiki unaraadan ipai ĩdyaun. Naꞌapaꞌo nii Daonaiora Aokazi Ikiꞌo waꞌatin dono. ");
INSERT INTO wapNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Aizii uruu dono, kainaꞌaꞌo nii dyaꞌutam daonaioranao zakapu ii, baudaꞌapaꞌo nii unaꞌaka-kao, baꞌoran waꞌaka-karu nii. ");
INSERT INTO wapNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Naꞌiki zunnao, dyaꞌutamaa kidaꞌo ĩboodapan, baudaꞌapaꞌo nii naꞌaka-kao, baꞌoran waꞌaka-kao nii. ");
INSERT INTO wapNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ukauꞌan uzaudinapa umashaapa, ushaꞌapanum kauꞌan aonaa uaitapan naꞌapainim nii uNaobanaa kaawan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Unaꞌapan idi uaitapa paꞌi wuru ĩdaꞌanazuꞌu: Kadapuꞌo aitapan an mani waꞌatiꞌo nii koidimiki, uruu aiwakaꞌan pokodapa mani umashaapan, uawunuutapan padapu. Naꞌiki aonaꞌo nii koidimiki morotinan udapu. ");
INSERT INTO wapNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ukauꞌan naꞌapa paꞌi unao, karikaonan uzaudinapa, ushaꞌapanum kauꞌan Daonaiora Aokazi Ikiꞌo waꞌatin nii naꞌapainim karikaonan umazaudinkan puꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Naꞌiaꞌoram poitorui mishiꞌo ukaudinauzon kaiman naꞌiki aitapaabaꞌo, uruꞌo nii panaobanaa zaamata naꞌiki uwaꞌaka awunuutapaꞌo nii baꞌoran poitoruinao. Naꞌiki kaimanaꞌo nii utaan ĩwanyukunuu, ipai wanyukunui taauzo-kao kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kaimanaꞌo nii manawun poitorui nyukunuu, unaobanaa kaawan an naꞌiki uikodan uruu kaiman ukaudinan, ipai ushaꞌapatan wuruꞌu panaobanaa dyuudanii kidaz ushaꞌapatan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Õkowaadan uꞌati mishiꞌo, unaobanaa dyuudan nii uawunuutapan ipai aimaakan wuruꞌu paꞌidiwau kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mazan aizii poitorui dikaudan an, sariaapaꞌo nii ukian, ‘Aonaꞌo nii õnaobanaa waꞌatin kadiman.’ ");
INSERT INTO wapNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ukauꞌan uruꞌu naa ubaꞌizitapan paawunuutapanii pamin-kaudinannao. Uaroapatinan naa naꞌiki utuzapatinan naa poꞌidipauzonao tuma. ");
INSERT INTO wapNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Baudaꞌapa kamoo kaawaꞌo nii unaobanaa wuruꞌu poitoruiz, aonaa uzauda-kidan donoꞌo nii mani ukaawan. ");
INSERT INTO wapNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Unaꞌapan idi, tuukiaꞌo nii panaobanaa patakaꞌutanuzu, naꞌiki ukabootan niizu tawunao tumaꞌa taapinpainao kaimanainao nii kaikiniꞌi. Naꞌiaꞌo nii uzaadan naꞌiki ukuzowan paudako padopian idi.” ");
INSERT INTO wapNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus kian koshan, “Uruu dono kaikapaꞌo nii wuruꞌu Tominkaru naobanai-tinapanuz: naꞌapaꞌo nii 10 paꞌinainao zunnao kawan, naꞌakapainao palampan kida ĩzaudapaꞌanan mazidaꞌo daonaiora. ");
INSERT INTO wapNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aizii bakaꞌiaudaꞌu ĩdyaun, aonaa ĩaitapinan, baꞌoran bakaꞌiaudaꞌuinaouz, aitapinaꞌo ĩdyaun paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Maaitapin-kainao zunnao naꞌakan palampan kida, mazan aonaꞌa naa ĩnaꞌakan palampan uu nii patuma. ");
INSERT INTO wapNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aitapinainao zunnao, ĩnaꞌaka paꞌan palampan uu nii powaꞌa zii. ");
INSERT INTO wapNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tomunuꞌiki zii aonaa mazidaꞌo daonaiora kaawan, uruu idi zaudapainao zunnao daꞌawununun naa naꞌiki ĩdaꞌawuꞌukan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Tomun-zikon diꞌiti uruꞌu naa pidan kian diiwaꞌo idaꞌan, ‘Waꞌatiꞌi naa mazidaꞌo daonaiora. Uwaꞌatiꞌi naa, uikodapaꞌan kiziꞌi naa uruu.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ipai paꞌinainaouz zunnao pokodaꞌakan, naꞌiki ĩkadishitan ĩpuꞌukadan naa palampan kida. ");
INSERT INTO wapNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aizii maaitapin-kainao zunnao kian aitapinainao ati, ‘Walampan kida makadaꞌanan naa, ukauꞌan utaa ulampan uu masakaudaꞌu waꞌati, wakaꞌuuta-kinaa nii walampan kida.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Aitapinainao zunnao kian, ‘Aonaa. Aonaꞌo nii walampan uu turuan wataan an uꞌatiz. Mishiꞌoraiman utoriinaka ulampan uu kida nii.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mazan ĩtoriaꞌanan puꞌu zii palampan uu kida nii, mazidaꞌo daonaiora kaawaꞌakan naa. Aitapinainao zunnao zaudapainaouz morotaꞌakan naa paꞌan mazidaꞌo daonaiora tuma aroopaꞌazoo-kizai iti, naꞌiki paniinom tarataꞌaka-kaoaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Udaunaꞌan zii maaitapin-kainaouz zunnao kaawan powaa ati. Sariapa ĩkian mazidaꞌo daonaiora ati, ‘Naobanai, Naobanai, pudaꞌatin waꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mazan ukian, ‘Õkowaadan uꞌati mishiꞌo, aonaa õaitapan unao.’” ");
INSERT INTO wapNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Udaunaꞌan Jesus kian naa patominapa-kidaniinao ati, “Ukauꞌan uzaudinapa umashaapa, ushaꞌapanum kauꞌan aonaa uaitapan naꞌapainim nii Daonaiora Aokazi Ikiꞌo kaawan.” ");
INSERT INTO wapNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kaikapaꞌo nii koshan Tominkaru naobanai-tinapanuz: naꞌapa umanawunuꞌo daonaiora makon kawan munapoꞌo wiizai diꞌiti. Pamakon uaꞌii udapadan papoitorunao, naꞌiki utaan naa ĩkaudin-kizi nii, marii kizi ĩdiriꞌidan upuraatan pamakon daida. ");
INSERT INTO wapNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Utaa ĩꞌati papuraatan ĩkaꞌiitan kawanaꞌati kida pashaꞌapatanuzu. Baudaꞌapaꞌo ati utaa bakaꞌiaudaꞌu saako puraata, gold idiꞌo utoma-kao. Baꞌoran ati utaa dyaꞌutam saako puraata, naꞌiki baꞌoran ati utaa baudaꞌapa saako. Uruu daunaꞌan umakon naa. ");
INSERT INTO wapNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Poitorui zaamataꞌoraz bakaꞌiaudaꞌu saako puraata, makon sariapa ukaudinaꞌanan ukaiwaan naa wuruꞌu puraataz. Uruu idi udiriꞌidan papuraatan ikoda bakaꞌiaudaꞌuꞌa naa saako powaꞌa zii. ");
INSERT INTO wapNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Baꞌoran poitorui zaamataꞌoraz dyaꞌutam saako puraata, naꞌapa kapam, ukaudinan ukaiwaan puraata taa-kariwaiz, naꞌiki uikoda dyaꞌutamaꞌa naa saako puraata powaꞌa zii. ");
INSERT INTO wapNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mazan poitorui zaamataꞌoraz baudaꞌapa saako puraata, umakon sariapa udidan wuruꞌu panaobanaa taaniaz puraata paꞌati, aonaa ukaiwaanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kotuaꞌiki udaunaꞌan uruꞌu naa ĩnaobanaa kaawan powaa ati, udapadan ĩdyaun koshan. Naꞌiki upishaan ĩdyaun naꞌapam naa ĩshaꞌapatan papuraatan. ");
INSERT INTO wapNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Poitorui zaamataꞌoraz bakaꞌiaudaꞌu saako puraata naꞌakan naa 10 saako puraata panaobanaa idaꞌati. Sariapa ukian panaobanaa ati, ‘Õnaobanaa, putaanii shaꞌatii õꞌati bakaꞌiaudaꞌu saako puraata. Putukapa naꞌapam õdiridanuz. Õikoda powaꞌa zii bakaꞌiaudaꞌu saako uꞌidaꞌan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sariapa unaobanaa kian uꞌati, ‘Pugaru, kaimanaꞌo pushaꞌapatinan. Kaiman pushaꞌapatan masakaudaꞌuꞌo aimaakan õtaanii puꞌati, ukauꞌan õtaan nii puꞌati powaꞌa zii aimaakan kida pushaꞌapatan nii. Puwaꞌatiꞌi naa, pukonaukii kiziꞌi naa õtuma.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Udaunaꞌan poitorui zaamataꞌoraz dyaꞌutam saako puraata kaawan panaobanaa idaꞌati. Ukian, ‘Õnaobanaa, putaanii õꞌati dyaꞌutam saako puraata, putukapa naꞌapam õdiridanuz powaꞌaꞌo zii, õikoda dyaꞌutamaꞌa naa saako uꞌidaꞌan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sariapa unaobanaa kian uꞌati, ‘Pugaru, kaimanaꞌo pushaꞌapatinan. Kaiman pushaꞌapatan masakaudaꞌuꞌo aimaakan õtaanii puꞌati, ukauꞌan õtaan nii puꞌati powaꞌa zii aimaakan kida pushaꞌapatan nii. Puwaꞌatiꞌi naa pukonaukii kiziꞌi naa õtuma.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Udaunaꞌan poitorui zaamataꞌoraz baudaꞌapa saako puraata kaawan panaobanaa idaꞌati. Ukian panaobanaa ati, ‘Õnaobanaa, õaitapa dadaraꞌo pidan pugaru, pukasabaꞌuan paoribai aka kida aonaa pupaoriba kida mani. ");
INSERT INTO wapNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Uruu idi õtarian puꞌai, ukauꞌan õdidanaka wuruꞌu pupuraatanuz imiꞌi kaꞌazo ii. Mazan putukapa, diꞌi naa pakawan wuruꞌu pupuraatanuz.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Sariapa unaobanaa kian uꞌati, ‘Pugaru maturuaukaꞌo, naꞌiki zoonzio poitorui. Puaitapanii padamata õkasabaꞌuan paoribai aka kida aonaa õpaoriba kida diꞌikiꞌo mani. ");
INSERT INTO wapNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mazan upuꞌu aonaa putaan õpuraatan puraata dapunaa iti udiriꞌidin kizi naꞌii. Diꞌi õkawanuꞌo diriꞌidinaꞌa naa mani õikodan õpuraatan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Uruu idi unaobanaa kian baꞌoran papoitorunao ati. ‘Uzaamata baudaꞌapaꞌoraz saako puraata uꞌai naꞌiki utaa arawu atizuꞌu, kainaꞌaꞌoraz 10 saako uꞌidaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ushaꞌapanum kauꞌan ipai pidan kaimanaꞌo ukaiwaan taa-kariwai paꞌati, powaꞌaꞌo nii zii utaa-kao uꞌati, dobataꞌo nii manawun. Mazan pidan aonaꞌoraz ukaiwaan kaiman taa-kariwaiz paꞌati, kanom taa-kariwaiz uꞌati, zaamata-karu nii uꞌai.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ukauꞌan ukaboota wuruꞌu maturuaukaꞌoraz poitorui paniba iti, marutaꞌo-karu iti. Naꞌiaꞌo nii uzaadan naꞌiki ukuzowan paudako padopian idi.” ");
INSERT INTO wapNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Daonaiora Aokazi Ikiꞌo kaawan dono umanawunuꞌo naobanai nii, ipai paꞌangelinnao tuma. Uruu dono usakanatan nii umanawunuꞌo pataba idaꞌa, king nii. ");
INSERT INTO wapNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ipaiꞌo nii pidannao baokopata-kao uꞌidaꞌati. Uruꞌo niꞌi naa ubuutan ĩdyaun, naꞌapa kaznizo taapiki buutan kawan kaznizonao booginao ai. ");
INSERT INTO wapNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Umuudan nii kaznizo kawanuꞌo pidannao padiwaꞌora antanapu. Boogi kawanuinao pidannao paꞌashabaron antanapu. ");
INSERT INTO wapNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Udaunaꞌan king kian niꞌi naa padiwaꞌora antanpuꞌo pidannao ati, ‘Uwaꞌati, õdaru kamunan-kidaniinao, uzaamata kiziꞌi naa kaiman kidaꞌo aimaakan õnaobanaitapa-kizi ii, minziiwa-kida-kariwaiz naa uꞌati amazada toma-kao diꞌikiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ushaꞌapanum kauꞌan unao utaauzonii daꞌi õwanyukunuu nii õzamazin dono. Utaauzonii daꞌi õtuzan nii õmaradakon dono, naꞌiki kaiman daꞌi udapaapan õgaru õtawaraitan dono uꞌidiꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Õmakamichaniitan dono, utaauzonii daꞌi õkamichan nii. Õkarinaan dono, uawunuutapanii õgaru. Naꞌiki utukapa daꞌi õgaru õtaraapa-kao dono.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Uruu idi kaimanainao kian nii uꞌati, ‘Naobanai, naꞌapainim daꞌi watukapauzon puzamazin naꞌiki wataan puwanyukunuu nii, oo pumaradakon naꞌiki wataan putuzan nii? ");
INSERT INTO wapNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naꞌapainim daꞌi watukapan putawaraitan waꞌidaꞌati naꞌiki wadapaapan kaiman pugaru, oo pumakamichaniitan naꞌiki wakakamichantan pugaru? ");
INSERT INTO wapNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naꞌapainim daꞌi waawunuutapan pukarinaan, oo watukapaꞌanan pugaru putaraapa-kao dono?’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“King kian nii ĩꞌati, ‘Õkowaadan uꞌati mishiꞌo, naꞌapainim ushaꞌapatan naꞌapaꞌo aimaakan baudaꞌapaꞌo õpidanan ati, aonaꞌoraz umanawunun padamata, õgaru atiꞌo wuruꞌu ushaꞌapatanuz aimaakan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Udaunaꞌan king kian nii paꞌashabaron antanpuꞌo pidannao ati, ‘Unao Tominkaru dakotanii papatakaꞌutan nii, umako õꞌai mamakadauzoko tikazi wuꞌiti, minziiwa-kida-kariwaiz Satan naꞌiki uangelinnao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ushaꞌapanum kauꞌan unao, aonaa daꞌi utaauzon õwanyukunuu nii õzamazin dono; aonaa daꞌi utaauzon õtuzan nii õmaradakon dono. ");
INSERT INTO wapNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Naꞌiki aonaa daꞌi udapaapan kaiman õgaru õtawaraitan dono uꞌidiꞌiti; õmakamichaniitan dono, aonaa daꞌi utaauzon õkamichan nii. Õkarinaan dono, aonaa daꞌi uawunuutapan õgaru; naꞌiki aonaa daꞌi utukapaꞌanauzon õgaru õtaraapa-kao dono.’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Udaunaꞌan ĩkian nii uꞌati, ‘Naobanai, naꞌapainim daꞌi watukapauzon puzamazin, pumaradakon oo putawaraitan oo pumakamichaniitan oo pukarinaan oo putaraa-kizai ii, naꞌiki wamanyukunuuapakan pugaru?’ ");
INSERT INTO wapNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ukian nii, ‘Õkowaadan uꞌati mishiꞌo, kanom umashaꞌapatakanii baudaꞌapaꞌo õpidanan ati, aonaꞌoraz umanawunun kowas, umashaꞌapatakan aimaakan õꞌati wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ukauꞌan ĩdyuuda-kao nii karikaonanuꞌo patakaꞌutin-kizai iti. Mazan kaimanaꞌo pidannao, karikaonanuꞌo kakupa-kizai itiꞌo nii paꞌan.’” ");
INSERT INTO wapNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aizii Jesus ipaian naa pakakuwaapan ipai aimaakan kida dauꞌan patominapa-kidaniinao ati. Uruꞌu naa ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Uaitapanii shaꞌatii dyaꞌutam kamoo daunaꞌanaꞌo niꞌi naa Passover Kamoon. Naꞌiki Daonaiora Aokazi Ikiꞌo taa-kao niꞌi naa tauka-karu nii cross diꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Uruu dono Faadaanao zowaunaanao naꞌiki kazowautapainao Jewnao baokopatinan Caiaphas, Umanawunuꞌo Faadaa dapu ii. ");
INSERT INTO wapNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ĩkadakotinan naꞌii pazowiaꞌazon dauꞌu Jesus, ĩaitapaꞌazon naꞌapam nii pazaamatan Jesus pidannao daidaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ĩkian, “Mazan aonaa washaꞌapataꞌanaꞌa uruu amazada konaukii-kida-kao dono, panaadon watoꞌorataaka-kidan nii pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aizii Jesus sookadinpan Bethany ii pidan Simon kiaꞌo uꞌuu dapu ii, kabishopankauzo kichanaꞌiki-kizai bishoi idi. ");
INSERT INTO wapNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesus naꞌian dono zunaaba kaawan uꞌidaꞌati, onaꞌakapan kawinipinaꞌo kaduunuribai pakinnaa zoꞌan, kuba idiꞌo utoma-kao. Sariapa oshootan ipai wuruꞌu kaduunuribai Jesus zowau an uaroapatinan puꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesus tominapa-kidaniinao tukapan wuruꞌu oshootanuz kaduunuribai, uruu idi tuukii ĩtoꞌoran udauꞌan. Sariapa ĩkian, “Ei! Kanom niꞌi naa owakudanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wuruꞌu kaduunuribaiz, turuaꞌo utaa-kao dobataꞌo puraata dikin ii, naꞌiki upuraatannaa taa-kao mapuraataniinao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus aitapa naꞌapaꞌoram ĩkian, uruu idi ukian ĩꞌati, “Kanom nii ukian aonaa ukaimanan oshaꞌapataniaz? Kaimanaꞌo aimaakan mishiꞌoraiman wuruꞌu oshaꞌapataniazu õꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Karikaonanuꞌo nii ĩnaꞌan utuma wuruꞌu mapuraataniinaouz, mazan õgaru, aonaa karikaonanuꞌo nii mani õnaꞌan utuma. ");
INSERT INTO wapNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wuruꞌu oshootanuz õnanaa an kaduunuribai, ominziiwatan naa õnanaa õdida-kao uaꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mishiꞌo õkowaadan uꞌati, ipai naꞌiaꞌakam amazada kawanaꞌati, diꞌoraz Kaimanaꞌo Kuwai kowaadapa-kao an, ipai wuruꞌu oshaꞌapataniaz õꞌati, ukowaada-kao nii kapam. Naꞌiki karikaonanuꞌo nii onyukunuitapa-kao wuru idaꞌanaꞌa oshaꞌapataniaz õꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Udaunaꞌan baudaꞌapa pidan 12 Jesus tominapa-kidaniinao bii ikiꞌo, Judas kiaꞌo uꞌuu, makon faadaanao zowaunaanao diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Naꞌiki upishaan ĩdyaun, ukian, “Kanomaꞌo nii utaa õꞌati õzaamata-kidan winipinaa nii Jesus uꞌati?” Sariapa ĩaitaan 30 wiziꞌi kidaꞌo puraata, naꞌiki ĩtaan naa uꞌatizu. ");
INSERT INTO wapNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Uruu naꞌikiꞌo Judas diꞌitinpan naa naꞌapam nii naꞌiki naꞌiam nii pazaamata-kidan Jesus ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kiwiitapaꞌo kamoo Mawikiꞌinaꞌo Bread Nikauzo-kao Kamoon kida dono, Jesus tominapa-kidaniinao waꞌatin uꞌidaꞌati, naꞌiki ĩkian uꞌati, “Naꞌiam nii puaipan waminziiwa-kidan Passover Kamoon wanyukunuunaa niꞌo puꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus kian ĩꞌati, “Umako donoi iti Jerusalem iti. Kainaꞌa pidan naꞌii, naꞌiki ukii uꞌati, ‘Tiichaa kian, Aizii amazada aitinpaꞌo õꞌati kaawan naa, ukauꞌan õtaapan nii Passover Kamoon õtominapa-kidaniinao tuma pudapu ii.’” ");
INSERT INTO wapNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Uruu idi ĩmakon ĩshaꞌapataꞌanan naa Jesus paradan kawanaꞌati. Ĩminiziiwa-kidan naa Passover wanyukunuunaa. ");
INSERT INTO wapNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aizii masakaudaꞌu kamoo tipitan daunaꞌan, Jesus sakanatan naa 12 patominapa-kidaniinao tuma ĩaroopaꞌazon naa. ");
INSERT INTO wapNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ĩaroopan puꞌaꞌa naa Jesus kian, “Õkowaadan nii uꞌati mishiꞌo, baudaꞌapa pidan unao bii ikiꞌo zaamata-kidan nii õgaru õtarubanao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tuukii utominapa-kidaniinao kashaꞌoran unaꞌapan idi paꞌati, uruu idi padawuꞌatiaaka kida ĩkian uꞌati, “Aonaa mazan õgaru mani, mishii õnaobanaa?” ");
INSERT INTO wapNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sariapa Jesus kian ĩꞌati, “Baudaꞌapa pidan unao bii ikiꞌo, damotaꞌoraz bread patumaaka õtuma, uruu zaamata-kidaꞌo niꞌoraz õgaru. ");
INSERT INTO wapNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mishi aimaakan shaꞌapan nii Daonaiora Aokazi Ikiꞌo ati, wuru kawanaꞌatiꞌo Tominkaru Paradan saada-kariwaiz udauꞌu. Mazan dikaudaꞌo nii manawun wuru baiaapanuꞌu pidan zaamata-kidaꞌoraz Daonaiora Aokazi Ikiꞌoraz. Kaiman zii mani aonaa ushakatauzon.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Udaunaꞌan Judas, zaamata-kidaꞌo niꞌoraz uruu kian, “Kanom mookoz, õgaru shaꞌa, Tiichaa?” Sariapa Jesus kian uꞌati, “Oo, naꞌapaꞌo pukianuz.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ĩaroopan puꞌaꞌa naa, Jesus zaamatan bread naꞌiki utoriinapa-kidanuz. Udaunaꞌan udushoonuzu, uruꞌu naa utaanuzu ipai patominapa-kidaniinao kawanaꞌati, naꞌiki ukian ĩꞌati, “Unika diꞌi, õnanaa wuruꞌu õtaaniaz uꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Udaunaꞌan uzaamatan koopo kawazoꞌo wine idi, naꞌiki utoriinapa-kidanuz. Udaunaꞌan utaanuzu ĩꞌati naꞌiki ukian ĩꞌati, “Ipai unao utuza diꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Diꞌoraz õizain kainaabataꞌo mishiꞌo nii Tominkaru shaꞌapatan pashaꞌapataꞌazooniaz pidannao ati. Uruu õizain shootan idaꞌan Tominkaru marinaꞌatan iriba pidannao oian. ");
INSERT INTO wapNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Õkowaadan uꞌati aonaꞌo nii õtuzan wine powaꞌa atii õtuzan paꞌinaꞌo wine utuma õdaru Tominkaru naobanai-tinapa-kizi ii.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aizii ĩipaian daunaꞌan paaroopan, ĩkunuiaꞌakan naa Tominkaru ati. Uruꞌu naa ĩmakon Olive Naawa iti. ");
INSERT INTO wapNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Udaunaꞌan Jesus kian ĩꞌati, “Aizii wuru wamarutan idaꞌa, ipaiꞌo nii uwaꞌakan õgaru. Naꞌapa usaadinpan kawan kotuaꞌoraz Tominkaru Paradan idaꞌa, ukianuz: ‘Õzowian nii kaznizonao taapiki, naꞌiki ipaiꞌo nii kaznizonao makoodanainan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mazan õkadishitan daunaꞌan õmawaka-kizi iki õmakon nii uꞌuaꞌati Galilee Baara iti.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sariapa Peter kian uꞌati, “Baokoinao mani waꞌakan nii pugaru, mazan õgaru, aonaꞌo nii õwaꞌakan pugaru!” ");
INSERT INTO wapNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus dakoꞌatin Peter, ukian uꞌati, “Õkowaadan puꞌati mishiꞌo, wuru marutaꞌo idaꞌa, kuruku kaꞌaranpan uaꞌii, idikinauꞌo nii pukian pidannao ati, aonaa puaitapan õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mazan Peter maꞌozakadinan powaꞌa zii. Ukian, “Aonaa naꞌapainim nii õkian aonaa õaitapan pugaru, atii õzowii-kao putuma!” Ipai baꞌoran tominapa-kida-kariwainao, naꞌapa ĩkian kida kapam. ");
INSERT INTO wapNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Udaunaꞌan Jesus naꞌiki utominapa-kidaniinao makon naa Gethsemane iti. Naꞌii ukian ĩꞌati, “Daꞌaꞌa naa zii paꞌi usakanatapaꞌa õtoriinpan puꞌu diꞌitanpuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Unaꞌaka Peter naꞌiki dyaꞌutam Zebedee dainao, James naꞌiki John patuma. Uruu naꞌiaꞌa naa Jesus kashaꞌoran tuukii, udopian panyukunuu ii. ");
INSERT INTO wapNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sariapa ukian patumainao ati, “Õkaikapanuzuꞌu tuukii kashaꞌora-karu dikintan õgaru, mawaka-karu diꞌiti manawun õabatanuz. Unaꞌa daꞌaꞌa upokodapa kizi õtuma.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesus makon masakaudaꞌu umunapodinan ĩꞌai, naꞌiaꞌa naa ukodoruꞌukan udawukan uawun imiꞌi baara iti, naꞌiki utoriinpan. Ukian, “Õdaru, turuu mani, udobata-kida-kao õꞌai wuruꞌu diꞌoraz õbaiaapaꞌazooniaz, mazan aonaa õaipan kawanaꞌati mani, soo puaipan kawanaꞌati paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Udaunaꞌan ukaawan powaa ati patominapa-kidaniinao idaꞌati, uikodan ĩdyaun daꞌawuꞌu naa. Uruu idi ukian Peter ati, “Aonaa mooko turuu upokodapan uawunuutapan masakaudaꞌu karikaonan õtuma?” ");
INSERT INTO wapNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Naꞌiki Jesus kian ĩꞌati, “Upokodapa naꞌiki utoriinapa aonaa kizi ukaakinpan oiaꞌo tiwaa-kidapan an unao. Udoronaa minziiwa padamata, mazan unanaa ii aonaa uturuuan.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Udaunaꞌan Jesus makon koshan utoriinpaꞌanan. Ukian, “Õdaru, aizii aonaa naꞌitim dono udobata-kida-kao õꞌai wuruꞌu õbaiaapan niꞌoraz, ukauꞌan marii mooko õbaiaapanuz, ushaꞌapa kizi puaipan kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ukaawan powaa ati ĩꞌidaꞌati, uikodan ĩdyaun daꞌawuꞌu naa koshan, aonaꞌa naa ĩkaꞌiitan papokodapan. ");
INSERT INTO wapNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Uruu idi umakon koshan baukapaꞌa naa. Uruu idikinautan naa utoriinpaꞌanan. Utoriinpan naꞌapa kiwiitapaꞌo patoriinpan kawan. ");
INSERT INTO wapNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Udaunaꞌan ukaawan naa powaa ati patominapa-kidaniinao idaꞌati koshan, naꞌiki ukian ĩꞌati, “Ei, pakawan zii udaꞌawupan, usookapan zii? Uabata, kaawaꞌa naa aita-kariwai amazada aizii, naꞌiki Daonaiora Aokazi Ikiꞌo kaakapaa-kaoaꞌa naa oiainao pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ukauꞌan ukadishitaꞌa naa, wamakoꞌo naa. Kaawaꞌa naa kaakapaꞌoraz õgaru!” ");
INSERT INTO wapNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus kadakotinan puꞌu zii, Judas kaawaꞌakan naa. Uruu 12 Jesus tominapa-kidaniinao bii ikiꞌo. Unaꞌaka patuma iriba pidannao kamarian zaꞌabaꞌi kidaꞌo naꞌiki kazowintinapa kidaꞌo atamun idi. Faadaanao zowaunaanao naꞌiki kazowautapainao Jewnao dyuudanii ĩnao zaamataꞌo nii Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aizii Judas kowaadaꞌakaniꞌi naa naꞌapam nii pakainaabatan Jesus ĩꞌati. Ukian ĩꞌati, “Pidan õkissitaniaz ukaozoo, uruu wuruꞌu uaipaniaz.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ukauꞌan sariapa Judas makon Jesus diꞌiti, ukian uꞌati, “Kaiman, Tiichaa,” naꞌiki ukissitaꞌakan naa ukaozoo. ");
INSERT INTO wapNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Uruu idi Jesus kian uꞌati, “Õpaonaru, pushaꞌapataꞌa naa wuruꞌu pushaꞌapataꞌazooniaz.” Uruuꞌu naa Judas naꞌakapaniinao pidannao kaawaꞌakan naꞌiki ĩzaamataꞌakan naa Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Unaꞌapan idi baudaꞌapa Jesus tominapa-kidaniinao bii ikiꞌo soꞌotaꞌakan pamarian zaꞌabaꞌi naꞌiki usaꞌukan Umanawunuꞌo Faadaa poitoru tain, uwaotaꞌaka. ");
INSERT INTO wapNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sariapa Jesus kian uꞌati, “Pupaida pumarian powaa iti, ushaꞌapanum kauꞌan kanomanao mizaataakaꞌo marii idaꞌan, ĩmawakan nii marii idi. ");
INSERT INTO wapNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aonaa mooko puaitapan turuu õdaru dyuudan iriba angelnao kaminkaꞌutaꞌo nii õgaru õpishaan an uruu? ");
INSERT INTO wapNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mazan unaꞌapan dono, aonaꞌo niꞌi naa kotuaꞌo prophetnao saadanii kidaz Tominkaru Paradan mishiinan, wuruꞌu shaꞌapaꞌo niꞌoraz uaita-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Udaunaꞌan Jesus kian zaamatainao ati paugaru, “Kandii nii uwaꞌatin õdauꞌati kaikapaꞌa, zaamataꞌanaꞌo kawan zowii-miki pidan? Wuruꞌu unaꞌakanuz marii zaꞌabaꞌi kida naꞌiki uzowin kida? Ipai kamoo õgaru Tominkaru Dapu ii õtominapatin-kidan pidannao, mazan aonaa uzaamatan õgaru naꞌapain. ");
INSERT INTO wapNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mazan diꞌoraꞌa aimaakan shaꞌapan kaikapaꞌa, Tominkaru prophetinnao saadanii kida mishiin-kinaꞌa naa,” ukian. Udaunaꞌan utominapa-kidaniinao kidoopan naa, ĩwaꞌakaꞌakan naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Udaunaꞌan pidannao zaamatainaouz Jesus naꞌakan naa uruu Caiaphas Umanawunuꞌoraz Faadaa dapu iti. Naꞌiaꞌa naa tiichaapauzonao Moses kakinaori dauꞌu naꞌiki baꞌorainao kazowautapainao Jewnao baokopatinan. ");
INSERT INTO wapNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peter naꞌiti udaꞌanan Jesus, mazan munapo uwaꞌakinpan. Umakopaanan atii ukaawan Umanawunuꞌoraz Faadaa panibazoota iti. Umorotan panibazoo ati, naꞌii usakanatan watchmannao tuma, utukapaꞌazon naꞌapam Jesus shaꞌapata-kao. ");
INSERT INTO wapNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aizii naꞌiaꞌa naa faadaanao zowaunaanao naꞌiki ipai kootowapa-kidauzonao pidannao tiwaan paikodan pidannao mariidinaꞌo nii Jesus dauꞌu, pazowii-kida-kinaa niiz, ");
INSERT INTO wapNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","mazan aonaa ĩikodan. Iriba padamata pidannao mariidinan Jesus dauꞌu, mazan upuꞌu aonaa ĩikodan naꞌapa kidaꞌo ĩmariidinan. Udaunaꞌan zii dyaꞌutam daonaioranao kadishitan naꞌii ĩkakuwaapan, naꞌapa kida ĩmariidinan Jesus dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ĩkian, “Waabatanii diꞌoraz daonaiora kian, ‘Turuu õmainaabatan Tominkaru Dapu, naꞌiki õkadishita-kidanuz powaa iti idikinaudaꞌu kamoo idaꞌa.’” ");
INSERT INTO wapNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sariapa Umanawunuꞌoraz Faadaa kadishitaꞌakan naꞌiki ukian Jesus ati, “Aonaꞌo nii karikaonan naꞌapam pukian kaiwuru dauꞌanaꞌa pukaakapaa-kaoaz?” ");
INSERT INTO wapNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mazan aonaa Jesus dakoꞌatin uparadan. Udaunaꞌan Umanawunuꞌoraz Faadaa kian uꞌati koshan, “Õpishaan pugaru kakupaꞌoraz Tominkaru awun zaꞌa, pukowaada waꞌati mishiꞌo mishi pugaru Christ, Tominkaru Dani?” ");
INSERT INTO wapNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus kian, “Oo, naꞌapaꞌo kaiwuruꞌu pukianuz. Wuru daunaꞌanaꞌa utukapan nii Daonaiora Aokazi Ikiꞌo sakanatapan Tominkaru diwaꞌora antanapu naꞌiki uwaꞌatin nii aokazi iki ishaꞌiz paawa an.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sariapa Umanawunuꞌoraz Faadaa kuzuutaꞌakan pakamichan patoꞌoran idi, naꞌiki ukian, “Uabata naꞌapam uwazootapaꞌazon Tominkaru! Ukauꞌan kanom zii wazaudapa kaakapaꞌo nii uruu, waabatan puꞌaꞌa naa naꞌapam uwazootapaꞌazon Tominkaru! ");
INSERT INTO wapNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aizii mani naꞌapam ukian udauꞌan?” Pidannao kian, “Turuu uzowii-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Udaunaꞌan ĩsopiautapanuzu paawun baara ati naꞌiki ĩtiniautapanuz, baꞌorainao taꞌianuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ĩkian Jesus ati, “Pugaru Christ, ukauꞌan pokowaada waꞌati naꞌiaꞌoram pidan tinikaꞌoraz pugaru?” ");
INSERT INTO wapNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aizii Peter unaꞌian usakanatapan panibazoo ii. Poitoruiaba waꞌatin uꞌidaꞌati naꞌiki okian uꞌati, “Pugaru kapam Jesus, Galilee Baara san, tumaꞌo daꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mazan Peter taapa-kidapa paaitapan Jesus. Ipai naꞌiainao kanaapu ati ukian, “Aonaa õaitapan kanom dauaꞌo kaiwuruꞌu pukadakotinanuz.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Udaunaꞌan umakon panibazoo paniinomizi itinapu. Naꞌii baꞌoran poitoruiaba tukapanuz naꞌiki okian naꞌiainao ati, “Diꞌoraz pidan, Jesus Nazareth san tumaꞌo uruu.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter taapa-kida koshan, ukian, “Mishiꞌo õparadan, aonaa õaitapauzon wuruꞌu pidanaz.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Masakaudaꞌu udaunaꞌan pidannao naꞌiainao ĩkadishitapan waꞌatin Peter idaꞌati naꞌiki ĩkian uꞌati, “Mishiꞌo uiriban wuruꞌu pugaruz, ushaꞌapanum kauꞌan naꞌapa pukaduz, puparadan idaꞌan pukainaabatinan.” ");
INSERT INTO wapNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Udaunaꞌan Peter kian “Mishiꞌo kaiwuruꞌu õkianuz aonaa õaitapan wuruꞌu uruuzu, aizii aonaa õparadan mishiin dono, marii Tominkaru patakaꞌutan õgaru.” Mashaꞌapakii kuruku kaꞌaranpaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sariapa Peter nyukunuuaꞌakan naꞌapam Jesus kiauzon paꞌati, “Kuruku kaꞌaranpan uaꞌii, idikinauꞌo nii putaapa-kidan puaitapan õgaru.” Uruu idi Peter koditaꞌakan naa paniba iti naꞌiki uzaadan tuukii. ");
INSERT INTO wapNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Uruu chaapiꞌiki, chaapiꞌikiiman ipai faadaanao zowaunaanao naꞌiki ipai kazowautapainao Jewnao miitiniipan naa Jesus dauꞌu, naꞌapam nii pazowii-kidanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Uruu daunaꞌan ĩdodowaꞌakan naa Jesus naꞌiki ĩnaꞌakan naazu naobanai Pilate diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas kaakapaamikitinaꞌoraz abatan naa Jesus zowiaꞌazoo-kao, udiꞌitinpan naꞌiki tuukii ukashaꞌoran pakaakapaan dauꞌan Jesus. Uruu idi sariapa umakon faadaanao zowaunaanao naꞌiki kazowautapainao Jewnao diꞌiti ukiwa-kidaꞌanan ĩpuraatan. ");
INSERT INTO wapNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ukian ĩꞌati, “Õꞌoian, õkaakapan idi kaimanaꞌo pidan, umashaꞌapatakan puꞌu oiaꞌo.” “Aonaa ushaꞌapan waꞌati, pugaru kiiꞌan, pugaru wuruꞌu shaꞌapaapaꞌoraz naꞌapaꞌo,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas kabootaꞌakan naa puraata naꞌii Tominkaru Dapu nazo ii. Udaunaꞌan umakon udyuukuruutinaꞌanan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sariapa faadaanao zowaunaanao zawadan wuruꞌu puraataz, naꞌiki ĩkian, “Diꞌoraz puraataꞌa pidan zowii-kinao winipinaa wuruꞌu, ukauꞌan kakinaorii kawanaꞌati, aonaa ukaimanan umuuda-kao Tominkaru Dapuꞌu iaꞌo puraata wiizi ii.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Uruu idi ĩkadakotinan udauꞌan atii ĩnaꞌapatan naꞌapa kida panyukunuu naꞌapam nii pakaiwaan wuruꞌu puraataz. Ĩkian, ĩkaiwaan niizu patorii-kinaa nii kaꞌuz tomiki amazadati, tawarainao baaranaa nii. ");
INSERT INTO wapNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Unaꞌapan idi udakota-kao Izai Baara kii. Atii kai pakawan udakotapa-kao naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Uruu prophet Jeremiah paradan mishiinan naa. Kaikapaꞌoraz ukian: “Ĩzaamata 30 wiziꞌi kidaꞌo puraata, Israelitenao aitan kawanaꞌatiꞌo uwinipinaa niꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Naꞌiki ĩkaiwaanuz patorii-kinaa nii kaꞌuz tomiki amazadati, Tominkaru dyuudan kawanaꞌati õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Uruu donoꞌo naa Jesus kadishita-kida-kao Pilate, Romannao naobanaa kanaapu iti, naꞌiki upishaan Jesus, ukian, “Pugaru wuruꞌu naobanaiz, King niꞌoraz Jewnao ati?” “Oo, naꞌapaꞌo kaiwuruꞌu pukianuz,” Jesus kian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mazan faadaanao zowaunaanao naꞌiki kazowautapainao Jewnao kaakapaan dono mazanuiman uruu, aonaa udakoꞌatin ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Uruu idi Pilate kian uꞌati, “Puabata naꞌapam ĩkowaadanii ipai dikauda kidaꞌo pudauꞌan? Upuꞌu zii aonaa pudakoꞌatinuz?” ");
INSERT INTO wapNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mazan aonaa Jesus dakoꞌatin naꞌapaꞌoram ĩkian padauꞌan, ukauꞌan tuukii Pilate diꞌitinpan. ");
INSERT INTO wapNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ipai wunu Passover Kamoon dono, naobanai kodita-kidauzon baudaꞌapa pidan taraa-kizai iki, pidannao aiapanii ukodita-kida-kao, uruu naobanai kaduz wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Uruu dono ĩtaraapanii pidan, Barabbas kiaꞌo uꞌuu, uruu kaimanaimanaꞌo uaitapa-kao ushaꞌapatan dikauda kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aizii pidannao kasabaꞌukinan donoꞌo naa, Pilate pishaan ĩdyaun, ukian ĩꞌati, “Naꞌiaꞌoram pidan uaipan õkodita-kidan uꞌati, Barabbas oo Jesus dakota-kariwaiz Christ kii?” ");
INSERT INTO wapNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Unaꞌapanuz paaitapan idiꞌo kazowautapainao Jewnao naꞌakanuz Jesus paꞌidaꞌati, ĩkishauzin idiꞌo karikaonan Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilate sakanatapan puꞌu pakootoopauzo-kizi taba idaꞌa, udaiaro dyuudan paradan uꞌidaꞌati, okian, “Aonaa paꞌi pushaꞌapataꞌanaꞌa wuruꞌu pidanaz mashaꞌapata-kaꞌoraz oiaꞌo, kichanaꞌiki-kii shaa õzandaꞌawun uruu dauꞌan, aonaa utaapan õnyukunuu kaiman.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mazan faadaanao zowaunaanao naꞌiki kazowautapainao Jewnao kakinaowan ipai pidannao, marii kizi ĩpishaan Pilate kodita-kidan Barabbas, naꞌiki marii uzowii-kidan paꞌan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Udaunaꞌan Pilate pishaan naa mishi pidannao. Ukian ĩꞌati, “Naꞌiaꞌoram pidan uaipan õkodita-kidan uꞌati?” “Barabbas,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Naꞌapam nii õshaꞌapatan naa Jesus dakota-kariwaiz Christ nii?” Pilate kian koshan ĩꞌati. “Marii utauka-kao cross diꞌiti,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Kandii nii, kanom mooko ushaꞌapata dikaudaꞌo nii?” Pilate kian upishaan ĩdyaun. Mazan powaꞌa zii ĩkadokon diiwaꞌo idaꞌan, ĩkian, “Marii utauka-kao cross diꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aizii Pilate tukapan idi aonaa naꞌitiꞌi naa naꞌapam pakian powaꞌa udauꞌan, mazan mishiꞌoraiman tuukiaꞌa naa manawun pidannao toꞌoradinan, uruu idiꞌi naa uchikaan pakaꞌu wunu idi iribaꞌo pidannao awunuutapan puꞌu, naꞌiki ukian ĩꞌati, “Wuru idaꞌanaꞌa õaidan uꞌati, aonaa õaipan atiꞌo mani wuru diꞌoraz kaimanaꞌoraz pidan zowiaꞌazoo-kaoaz.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Unaꞌapan idi, pidannao kadakon uꞌati, “Marii mooko uzowii-kao winipinaa waotan waꞌati naꞌiki waudainao ati,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Uruꞌu naa Pilate kodita-kidan Barabbas pidannao ati, mazan Jesus ubaꞌizii-kidan naa paꞌan, udaunaꞌan utaaꞌakan naa Jesus tauka-karu nii cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Udaunaꞌan Pilate soldyaannao zaamatan naa Jesus, ĩnaꞌakanuzu soldyaanao mashaapa-kizi iti. Uruꞌu naa ĩbaokopatan ipai soldyaanao naꞌii Jesus idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naꞌii ĩnarakadan ukamichan, naꞌiki ĩkakamichantanuz wuzaꞌo kamicha, naobanai kamichan kaduz idi. ");
INSERT INTO wapNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Udaunaꞌan ĩtoman kowamai kaiwada-karu idi, naꞌiki ĩkakowamtan naaz uꞌidi. Ĩtaan naa uꞌati kapam uwadookori nii atamun idi uzaamatapan nii padiwaꞌora antanapu, naꞌapa king zaamatapauzon kawan pawadookori. Uruꞌu naa ĩkodoruꞌukan ukanaapu ati naꞌiki ĩbanikiitan naazu. Ĩkian, “Pugaru King, umanawunuꞌo Jewnao naobanaa!” ");
INSERT INTO wapNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Udaunaꞌan ĩsopiautapanuzu naꞌiki ĩzaamatan uꞌai atamun pataaniaz uwadookori nii. Uruu idiꞌi naa ĩzowiautapan uzowau. ");
INSERT INTO wapNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ĩipaian daunaꞌan paꞌantamikitan uruu, ĩnarakadan naa uꞌai pakaiwaada-kidaniaz kamicha uꞌati, naꞌiki ĩkaiwada-kidan naa ukamichan powaa iti. Udaunaꞌan ĩnaꞌakan naazu, ĩtaukaꞌanan naazu cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aizii ĩkoditan puꞌu donoi iki, pamakopa-kizi an ĩikodapan pidan Cyrene san, Simon kiaꞌo uꞌuu. Sariapa soldyaanao dyuudan unaꞌakan Jesus crossannaa. ");
INSERT INTO wapNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ĩmakon atii ĩkaawan amazada iti dakota-kariwai Golgotha kii, naꞌapaꞌoraz amazada uu Pidan-Zowau-Niwaꞌuz-naawa, kiaꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Naꞌiaꞌa naa ĩtaan Jesus tuzan nii wine idi, kawikiꞌita-kariwai aimaakan kibiaꞌo idi, mazan patiwaan daunaꞌan masakaudaꞌuzu, aonaa uaipanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aizii soldyaanao taukan daunaꞌan Jesus cross diꞌiti, ĩbuutan naa ukamichan kida. Udaunaꞌan ĩmakinaotan makinaonii, ĩtukapaꞌazon naꞌiaꞌoram nii zaamata ukamichan buutinpan kida. ");
INSERT INTO wapNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Udaunaꞌan ĩsakanatapan naa ĩawunuutapan Jesus naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Doko antanapu uzowau paawaꞌa saada-kariwai atamun munaꞌa ĩkainaabata-kinaa kanom dikiniꞌiaꞌo uzowii-kao. Kaikapaꞌo ĩsaadaniaz: “Diꞌi wuruꞌu Jesus, uruu King Jewnao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Naꞌapain uruu dono dyaꞌutam koidimikinao tauka-kao cross diꞌiti kapam. Ĩmuudan baudaꞌapaꞌo Jesus diwaꞌora antanapu, baꞌoran uwashabaron antanapu. ");
INSERT INTO wapNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pidannao dobatapainao naꞌan maonapa Jesus idaꞌan, ĩwaꞌuan pazowau kida, uruu ĩbanikiitan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ĩkian, “Pugaru mainaabataꞌazoꞌoraz Tominkaru Dapu naꞌiki udaunaꞌan pukadishita-kidaꞌazoonuz idikinaudaꞌutan kamoo idaꞌa, ukauꞌan aizii pukazannaatinaꞌa naa. Umishiin dono pugaru Tominkaru dani, putokaꞌa naa pucrossannaa diꞌiki!” ");
INSERT INTO wapNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aizii faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki kazowautapainao Jewnao, naꞌapa kapam ĩbankiitanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ĩkian, “Ukazannaata baꞌorainao pidannao, mazan aonaa ukaꞌiitan pakazannaatinan paꞌidaꞌa. Uruu King niꞌo kaikiniꞌi Israel ati! Ukauꞌan marii utokan aizii cross diꞌiki, uruu wamishidan niizu! ");
INSERT INTO wapNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Umishidanii Tominkaru, ukauꞌan marinaꞌa naa Tominkaru aidan pakazannaatan uruu kai, ushaꞌapanum kauꞌan ukiinii ‘Õgaru Tominkaru dani!’” ");
INSERT INTO wapNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naꞌapa kapam koidimikinao tauka-kariwainaouz cross diꞌiti Jesus dazabaꞌa, naꞌapa kapam ĩbankiitanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aizii sakitapa kamoo diꞌiki aka amazada marutaꞌakan atii daawadata kamoo 3 oꞌclock diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aizii 3 oꞌclock mani, uruꞌu naa Jesus kadakon diiwa, “Eli, Eli, lama sabachthani?” ukian. “Õtominkarun, õtominkarun, kanom nii aonaa punyukunuupan õgaru?” kiaꞌo wuruꞌu ukianuz. ");
INSERT INTO wapNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pabiꞌi kida pidannao maonapaꞌo ĩkadishitapan naꞌii, ĩabata naꞌapam Jesus kian. Uruu idi ĩkian, “Udapadan prophet Elijah.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sariapa baudaꞌapa pidan dimaꞌakan sponge dauꞌati, naꞌiki udamotanuzu katamaꞌo wine diꞌiti, naꞌiki usawadan naaz atamun idaꞌan Jesus diꞌiti, Jesus tuzan nii. ");
INSERT INTO wapNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mazan baokoinao pidannao kian, “Marii unaꞌian paꞌidaꞌa, watukapa kizi Elijah waꞌatin ukaminkaꞌutaꞌananuzu.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Upuꞌaꞌa naa Jesus kadakoꞌokan diiwa koshan, uruu umanizowantaꞌakan, umawakan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naꞌapain aka kamicha mada Tominkaru Dapu nazoo buutapa-kinao kida kuzuutaꞌakan ipai pazikon an, doko iki atii apowa ati. ");
INSERT INTO wapNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Baaranai kida ipai ĩdaꞌatinaꞌakan naꞌiki iriba Tominkaru pidanannao kadishitan ĩkakudan powaa iti. ");
INSERT INTO wapNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ĩkoditan baaranai iki kida. Aizii Jesus kadishitan daunaꞌan pamawaka-kizi iki, uruꞌu naa wuruꞌu kadishitainaouz pabaaranaa iki makon Jerusalem iti, naꞌiki iriba pidannao tukapan ĩdyaun naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aizii soldyaanao zowaunaa, pasoldyaannao tuma awunuutapainaouz Jesus, ĩtukapa wuruꞌu amazada nakainanuz naꞌiki ipai amazada shaꞌapanuz. Tuukii ĩtarian! Uruu idi ĩkian Jesus dauꞌan, “Wuruꞌu pidanaz, mishiꞌo mishi Tominkaru Dani uruu.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iriba zunnao awunuutapan Jesus naꞌii, mazan munapo ĩkadishitapan. Wuruꞌu zunnaouz Galilee Baara ikiꞌo ĩwaꞌatin Jesus dawuꞌati kaminkaꞌuupainao uruu, shaꞌapataꞌo kanom uaiapanii kida. ");
INSERT INTO wapNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Naꞌiainao zunnao bii ii Mary Magdala sanaaba, naꞌiki Mary (oroo James naꞌiki Joseph daro), naꞌiki Zebedee daiaro. ");
INSERT INTO wapNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aizii kamoo tipitaꞌanan diꞌitiꞌi naa, Arimathea san kaawan, uruu kapuraatanuꞌo pidan, Joseph kiaꞌo uꞌuu naꞌiki tominpaꞌo kapam Jesus diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Sariapa umakon upishaaꞌanan Pilate Jesus nanaa dauꞌan, udidaꞌazoonuzu. Pilate dyuuda Jesus nanaa taa-kao uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Uruu idi Joseph toka-kidan naa Jesus nanaa cross diꞌiki, upapidan naazu kaimanaꞌo, paꞌinaꞌo kamicha mada idi. ");
INSERT INTO wapNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Udaunaꞌan umuudanuz diikiꞌiꞌo pakichadaꞌakanii kuba pabaaranaa niꞌo nazo iti. Udaunaꞌan ukidaꞌukan udaruꞌo kuba, udorodoraa-kidanuzu, utaratan naa baaranai paniinomizinaa uꞌidi, udaunaꞌan umakoꞌokan naa. ");
INSERT INTO wapNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdala sanaaba naꞌiki baꞌoranuaba Mary, ĩsakanatapan naꞌii maonapa ubaaranaa ii. ");
INSERT INTO wapNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Baꞌoran kamoo uruu Sookapa-karu Kamoon dono faadaanao zowaunaanao naꞌiki Phariseenao makon Pilate diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ĩkian uꞌati, “Naobanai, wanyukunuian naꞌapam tawuru kianuꞌo mariidinauzoz pakakupan dono zii. Ukian, ‘Idikinaudaꞌu kamoo õmawakan daunaꞌan, õkadishitan nii kakupa koshan.’ ");
INSERT INTO wapNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ukauꞌan pudyuuda ubaaranaa awunuutapa-kao kaimanaiman atii idikinaudaꞌu kamoo daunaꞌan. Panaadon utominapa-kidaniinao waꞌatin nii ĩkoidapaꞌananuz. Udaunaꞌan ĩkowaadaꞌanan nii pidannao ati, ĩkian nii kadishitaꞌa naazu pamawaka-kizi iki. Uruu dawuꞌitiiniꞌo mariidin-karu, powaꞌaꞌo nii zii udikaudan kiwiitapaꞌo mariidin-karu ai.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate kian ĩꞌati, “Unaꞌaka mooko soldyaanao, uawunuutapa-kidaꞌa naa wuruꞌu baaranaiz kaimanaiman.” ");
INSERT INTO wapNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Uruu idi ĩmakon naa baaranai iti. Naꞌii ĩmuudan naa pakainaariba kuba kida ukita-kao ai, naꞌiki ĩwaꞌakan naa soldyaanao awunuutapaꞌo nii wuruꞌu baaranaiz. ");
INSERT INTO wapNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aizii Sookapa-karu Kamoon daunaꞌan, naꞌiki Sunday wakanadaꞌanan diꞌiti, Mary Magadalene naꞌiki baꞌoran Mary awunuutaꞌanan naa baaranai. ");
INSERT INTO wapNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mashaꞌapakiaka imiꞌi baara nakainan maꞌozakaꞌo idaꞌan naꞌii, Tominkaru angelin kaawan idi aokazi iki naꞌiki umakon baaranai iti, udorodoraa-kida kuba baaranai ai, naꞌii usakanatan uruu kuba paawaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aizii angel aidinpan naꞌapa toroanaru kan-kanaapan kawan naꞌiki ukamichan umanawunuꞌo ubarakan. ");
INSERT INTO wapNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tuukii soldyaanao awunuutapainao naka-nakaan patarian idi uꞌai, naꞌiki ĩdorautaꞌakan naa mawakauanaka. ");
INSERT INTO wapNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aizii angel kian zunnao ati, “Aonaa utariaꞌanaꞌa, õaitapa wuruꞌu uwaꞌatinuz utukapaꞌanan Jesus, tauka-kariwaiz cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aonaꞌa naa uruu nii daꞌaꞌa, kadishitaꞌa naazu pamawaka-kizi iki, naꞌapa pakiauzon kawanaꞌati. Uwaꞌati mooko daꞌatiꞌi utukapa diꞌi wuruꞌu umuuda-kizinaoaz. ");
INSERT INTO wapNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ukauꞌan umako kadiman, ukowaadaꞌan utominapa-kidaniinao ati kadishitaꞌa naazu pamawaka-kizi iki, naꞌiki makoꞌo naa uruu Galilee Baara iti. Naꞌiaꞌo niꞌi naa utukapanuz. Uruu õkuwaa unao ati,” angel kian. ");
INSERT INTO wapNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Uruu idi zunnao makon naa dopiaudaꞌuꞌo idaꞌan, ĩtarian mazan ĩkonaukian puꞌu kapam. Aizii ĩmakon dimapa ĩkakuwaapaꞌanan naa Jesus tominapa-kidaniinao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mashaꞌapakii Jesus aidinaꞌakan ĩkanaapu ii, “Kaiman,” ukian ĩꞌati. Sariapa ĩaitapaꞌakanuzu, uruu idi ĩmakoꞌokan uꞌidiꞌiti, ĩkodoruꞌukan naꞌiki ĩzaamatinan ukidiba iki, ĩmanawuntapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Udaunaꞌan Jesus kian ĩꞌati, “Aonaa utariaꞌanaꞌa. Umako, ukowaadaꞌan õꞌinawuzunao ati marii ĩmakon Galilee Baara iti, naꞌiaꞌo nii ĩtukapan õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aizii zunnao makopan puꞌaꞌa naa, uruꞌu naa soldyaanao awunuutapainaouz baaranai makon naa Jerusalem iti, ĩkakuwaapaꞌanan naa faadaanao zowaunaanao ati ipai aimaakan shaꞌapaꞌo dauꞌan baaranai ii. ");
INSERT INTO wapNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sariapa faadaanao zowaunaanao baokopatinan kazowautapainao Jewnao tuma. Uruꞌu naa ĩmiitiniipan ĩaitapaꞌazon naa naꞌapam pashaꞌapatinan. Ĩtaa dobata puraata soldyaanao ati. ");
INSERT INTO wapNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ĩkian ĩꞌati, “Kaikapa paꞌi ukakuwaapaꞌa, ‘Upoitorunao koidapankaꞌa naa uruu aiwakaꞌan wadaꞌawun daida.’ ");
INSERT INTO wapNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aizii Pilate abatan an udauꞌan, waparadan nii uꞌati unao dikin ii, aonaa kizi ushaꞌapatan unao.” ");
INSERT INTO wapNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Uruu idi soldyaanao zaamataꞌakan naa puraata, ĩmakon ĩkakuwaapaꞌanan naa padyuuda-kao kawanaꞌati. Unaꞌapan idiꞌo kaikapaꞌoraz kuwai kowaadapa-kaoaꞌa naa ipai Jewnao kawanaꞌati atii kai. ");
INSERT INTO wapNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Udaunaꞌan 11 Jesus tominapa-kidaniinao makon naa Galilee Baara iaꞌo midukuo iti, Jesus dyuuda kizi iti ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ĩtukapan donoꞌo naa Jesus naꞌii, sariapa ĩmanawuntapanuz. Mazan pabiꞌi kida ĩdyaun aonaa ĩmishidan Jesus wuruꞌu patukapaniaz. ");
INSERT INTO wapNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Upuꞌaꞌa naa Jesus waꞌatin ĩꞌidaꞌati, ukian ĩꞌati, “Aizii ipai õmaꞌozakannaa taa-kao õꞌati, turuu õkazowautapan aokazi ii naꞌiki imiꞌi baaraꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ukauꞌan umako ipai pidannao diꞌiti utominapa-kida kizi ĩdyaun õtominapa-kidanii dauꞌu. Uchikaawunuu ĩdyaun õDaru uu idaꞌan, naꞌiki õgaru uDani uu idaꞌan naꞌiki Kaimanaꞌo Doronaa uu idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Utominapa-kida õpidanannao, ĩizoꞌati kizi kaimanaiman ipai wuruꞌu õparadanuz õdyuudaniaz uizoꞌatin. Naꞌiki mishi, karikaonanuꞌo nii õgaru utuma, atii diꞌoraz amazada ikodan diꞌiti patokon.”");
INSERT INTO wapNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Diꞌi Kaimanaꞌo Kuwai sakadinan Tominkaru Dani Jesus Christ dauaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Usaadinpan prophet Isaiah kaaritan kawanaꞌati: “Tominkaru kian, ‘Õdyuudan nii kakuwaapaꞌo nii puꞌuaꞌati, saabaaꞌo nii dunapo puꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kainaꞌaꞌo nii pidan kadakoinpan diiwa, mapidantakaꞌo amazada ii aka: ‘Putoma dunapo Naobanai ati, pusaabaa sakitapa uchiꞌika kizi nii!’” ");
INSERT INTO wapNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mishi John Chikaawunuupauzo aidinan mapidantakaꞌo amazada ii, karikaonan ukadakotinan chikaawunuin-karu dauꞌu. “Utanawatinaꞌa naa uꞌoian ai naꞌiki uchikaawunuinaꞌa naa. Uruu Tominkaru mainaabatan nii uꞌoian,” ukian pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iriba pidannao Judea Baara anainao naꞌiki donoi Jerusalem iki kidaꞌo waꞌatin ĩabatapaꞌanan John kuwaa. Ĩkowaadan paꞌoian kida, naꞌiki John chikaawunuuan ĩdyaun Jordan Waꞌo ii. ");
INSERT INTO wapNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ukamichan toma-kao camel idi idiꞌo, kainaꞌa kapam uzadawu wuzada-kariwai madai, naꞌiki uwanyukunuu nii manorunao naꞌiki maaba. ");
INSERT INTO wapNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aizii John kian pidannao ati, “Pidan waꞌatipaꞌo õdawuꞌati kainaꞌiki, uruu powaꞌaꞌo zii umanawunun õꞌai. Aonaa õturuan õbuzuutan udazkidi zunaa. ");
INSERT INTO wapNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Õchikaawunuuan unao wunu idi, mazan uruu, uchikaawunuuan nii paꞌan unao Kaimanaꞌo Doronaa idi.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aonaa utomunuꞌikin Jesus kaawan daunaꞌan Nazareth iki, Galilee Baara iaꞌoraz wiizai. Naꞌapain John chikaawunuuan uruu Jordan Waꞌo ii. ");
INSERT INTO wapNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus koditan daunaꞌan wunu diꞌiki, sariapa utukapan aokazi daꞌata-kao, naꞌiki Kaimanaꞌo Doronaa waꞌatin uꞌidaꞌati orid kawan. ");
INSERT INTO wapNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Parada-karu kian aokazi iki, “Pugaru mishi õdani õmarainapanii; kaiman manawun õnyukunuu puꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Udaunaꞌan Kaimanaꞌo Doronaa dyuudaꞌakan naa umakon mapidantakaꞌo amazada diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Naꞌii umashaapan toꞌora kidaꞌo aimaakannao bii an 40 kamoo. Naꞌii Satan tiwautan patanawatan uruu oiaꞌo diꞌiti, mazan angelnao kaawan idi uꞌidaꞌati, ĩkaminkaꞌutan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John taraa-kao daunaꞌan, Jesus makon Galilee Baara iti, ukowaadaꞌanan naa Kaimanaꞌo Kuwai Tominkaru diꞌikiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ukian pidannao ati, “Aizii kamoo mishiinan kaawaꞌazon naa, Tominkaru Naobanai-tinan maonapataꞌa naa. Utanawatinaꞌa naa uꞌoian ai kida naꞌiki umishida wuruꞌu Kaimanaꞌoraz Kuwai.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus makopaanan puꞌu maonapa Galilee Karishiiz danomata, utukapa dyaꞌutam kopautapauzonao, Simon paꞌinawuzu Andrew tuma. Ĩzaamaapan kopau pasairon idaꞌan karishii baoko iki. ");
INSERT INTO wapNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus kian ĩꞌati, “Uwaꞌati õtuma õtominapa-kida kizi unao uzaamaapan dauꞌu pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sariapa ĩwaꞌakaꞌakan pasairon kida naꞌiki ĩdaꞌanaꞌakan naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Naꞌikiꞌo udobataꞌakan, sariapa utukapan dyaꞌutam pidannao koshan, James naꞌiki John, ĩnao Zebedee dainao. Ĩminziiwatan pasairon kida pakanawan zoꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sariapa Jesus dapadan ĩdyaun paminaudaꞌunao nii. Uruꞌu naa ĩwaꞌakaꞌakan naa padaru Zebedeez kanawa zoꞌii poitoruinao tuma, ĩmakoꞌokan naa Jesus tuma. ");
INSERT INTO wapNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Uruu daunaꞌan Jesus kaawan Capernaum iti patominapa-kidaniinao tuma. Naꞌiki Sookapa-karu Kamoon donoꞌo naa, Jesus makon synagogue iti. Naꞌiaꞌa naa ukakinaopan pidannao. ");
INSERT INTO wapNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pidannao abatapainaouz uruu, tuukii ĩdiꞌitinpan uparadan dauꞌu, ushaꞌapanum kauꞌan utominapatin-kidan idi ĩdyaun paaitapan idaꞌan paꞌan, aonaa wunao kawan maniꞌi tiichaapauzonaouz Moses kakinaori dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Upuꞌu pidan, oiaꞌo doronai zaamatapanii morotan synagogue nazo iti, sariapa ukadakonaakan. ");
INSERT INTO wapNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ukian, “Jesus, Nazareth san, kanom dii pushaꞌapataꞌazon watuma? Puwaꞌatin pumainaabataꞌazon shaꞌa waunao? Õaitapanii pugaru Tominkaru diꞌikiꞌo puwaꞌatin.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sariapa Jesus mashaatan oiaꞌo doronai, ukian, “Pumashaada naꞌiki pukodita wuru aiaꞌa pidanaz.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sariapa wuruꞌu oiaꞌo doronaiz ziiautapanuzu naꞌiki ukadakoꞌokan diiwa kapam, uruu mazan usoꞌotinaꞌakan naa uꞌidiꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Uruu daunaꞌan tuukii manawun pidannao diꞌitinpan. Naꞌiki ĩpishautaakan paꞌatiaaka kida, “Shaꞌapaꞌoram kaduz kakinaoriꞌi naa wuruꞌu? Paꞌinaꞌoraꞌa naa kakinaowapa-karu aonaꞌo waabatauzon? Diꞌoraꞌa pidan paradinan pamaꞌozakan idaꞌan, atii oiaꞌo doronainao izoꞌati zii uparadan.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Uruu idi kadiman ukaunamanaata-kao ipai wiizainao kawanaꞌati Galilee Baara ii aka. ");
INSERT INTO wapNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus ipaian daunaꞌan pachoochiipan synagogue ii, naꞌiki ukoditan paminaudaꞌunao tuma. Ĩmakon sariapa Simon naꞌiki Andrew dapu iti, James naꞌiki John makoꞌo kapam ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Uruu dono Simon imauzo karinaꞌo, tuukii omada wiichan pakarinaan idi, aonaa turuu okadishitan. Aizii Jesus kaawan puꞌu naꞌiti, sariapa ĩkowaadan okarinaan uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus makon oꞌidiꞌiti, sariapa uzaamatanuzo pakaꞌu kadu iki naꞌiki ukadishita-kidanuzo. Uruꞌu naa okakudaꞌakan, udaunaꞌan otaan naa ĩwanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Uruu wachuupunin, kamoo tipitan daunaꞌan, pidannao kaawa-kidan Jesus idaꞌati, ipai karinainao naꞌiki oiaꞌo doronainao zaamatapaniinao kida kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ipai naꞌii sannao kasabaꞌukinan kida kabaun panibazoota an. ");
INSERT INTO wapNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Uruu dono Jesus kakudan iriba karinainao naꞌiki iriba ukodita-kidan oiaꞌo doronainao pidannao ai kapam. Aonaa utaapadan oiaꞌo doronainao paradan, ushaꞌapanum kauꞌan ĩaitapan idi uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Baꞌoran kamoo wakankanaanin, Jesus koditan kabaun iki. Umakon pabaꞌorantin wiizai iki mapidantakaꞌo amazada iti, naꞌiaꞌa naa utoriinpan. ");
INSERT INTO wapNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon naꞌiki uminaudaꞌunao, ĩdawatapan naa uruu, ");
INSERT INTO wapNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","atii ĩikodanuzu. Ĩkian uꞌati, “Ipai pidannao dawatapan pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus kian ĩꞌati, “Wamako baꞌoran wiizai kida diꞌiti. Naꞌii akaꞌo nii õkakinaopan, ushaꞌapanum kauꞌan naꞌapaꞌo dauꞌatiꞌo õwaꞌatin daꞌatiꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Uruu idi Jesus chiꞌikapan ipai Galilee Baara an kidaꞌo wiizai kawanaꞌati, ukakuwaapatinan ipai synagogue kida kawanaꞌati, naꞌiki ukodita-kidan ipai oiaꞌo doronainao pidannao ai kida. ");
INSERT INTO wapNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pidan kaawan Jesus idaꞌati baiatinaꞌo kichanaꞌiki-kiaꞌo bishoi idi. Ukodoruꞌukan ukanaapu itinapu, tuukiaꞌo idaꞌan upishaan, uaipan Jesus kaminkaꞌutan paugaru. Ukian, “Punyukunuu naꞌapan an, pusaabaa wuruꞌu õkabishopanuz.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus kashaꞌora-kida uruu naꞌiki upishatanuzu pakaꞌu idi, “Oo, naꞌapa mishi õnyukunuu, õkaminkaꞌutan nii pugaru.” Naꞌiki ukian, “Pusaabain powaa iti koshan!” ");
INSERT INTO wapNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sariapa mishi umada saabainaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Udaunaꞌan Jesus kakinaowaꞌakan naa uruu, udyuudaꞌakan naa kapamazu. ");
INSERT INTO wapNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Upuꞌu ukian uꞌati, “Puabata, aonaa paꞌi pukowaadaꞌanaꞌa pidan ati. Mazan pumako sariapa faadaa diꞌiti utukapa kizi pusaabaa-kao. Naꞌapain putaaꞌa naa uzainao faadaa ati, uzowii kiziꞌi naa ĩdyaun kawaodapa-kizai paawa ii, Moses kakinaori kawanaꞌati, naꞌiki pidannao tukapa kizi mishi kaimanaꞌa naa pusaabaa-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Uruꞌu naa mazan pidan makoꞌokan naa, naꞌiki ukakuwaapan ipai amazada kawanaꞌati naꞌapam pasaabaa-kao dauꞌu. Kuwai abata-kao idiꞌi naa ipai wiizai kida kawanaꞌati, aonaꞌa naa Jesus kaꞌiitan paꞌaidinan wiizai kida diꞌiti. Ushaꞌapanum kauꞌan uaitapanii iribaꞌo nii manawun pidannao zaudapan paugaru naꞌii. Unaꞌiakapan naa umashaapan mapidantakaꞌo amazada diꞌii. Naꞌitiꞌi naa pidannao makon uꞌidiꞌiti ipai Galilee Baara iki kida. ");
INSERT INTO wapNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesus kiwan powaꞌa iti Capernaum iti. Aonaa zii kamoo dobatan iriba, udaunaꞌan, uunamunaa abata-kao kainaꞌa uruu pasookapauzo-kizi kabaun diꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Uruu idi iriba pidannao baokopatinan uꞌidaꞌati, paida kabaun nazoo, atii paniba ii aka. Jesus kowaadautan puꞌu Kaimanaꞌo Kuwai ĩꞌati, ");
INSERT INTO wapNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","uruꞌu naa 4 pidannao kaawa-kidan machiꞌikakaꞌo pidan Jesus idaꞌati, ĩaipan ukakudanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mazan pidannao iriban idi aonaa ĩaitapan naꞌapam pamorota-kidan uruu Jesus diꞌiti. Uruu idi ĩbadakatan kabaun zowauꞌu, naꞌikiꞌi naa ĩmorota-kidan wuruꞌu machiꞌikakaꞌoraz pawashatinapa-kizi baara an. ");
INSERT INTO wapNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus tukapan idi mishi ĩmishidan tuukii manawun, ukian machiꞌikakaꞌo ati, “Õdani, puꞌoian mainaabataꞌaka-kaoaꞌa naa.” ");
INSERT INTO wapNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Naꞌaꞌo kapam tiichaapauzonao Moses kakinaori dauꞌu ĩbiiꞌi ĩsakanatapan. Sariapa ĩdiꞌitinpan. ");
INSERT INTO wapNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kandii nii uparadan kaikapaꞌa? Uwazootapaꞌazon Tominkaru paparadan idaꞌan! Soo baudaꞌapa Tominkaru turuaꞌo umainaabatan pidan oian.” ");
INSERT INTO wapNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus aitapa naꞌapam ĩdiꞌitinpan, uruu idi ukian ĩꞌati, “Kandii nii udiꞌitinpan õdauꞌu kaikapaꞌa? ");
INSERT INTO wapNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Naꞌiaꞌoram mashaꞌapannaa: ‘ipai puꞌoian mainaabata-kao’ kii, oo ‘pukadishita naꞌiki puchiꞌika’ kii? ");
INSERT INTO wapNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Ukauꞌan, õaidan nii uꞌati naꞌapam Daonaiora Aokazi Ikiꞌo kainaꞌa umaꞌozakan daꞌaꞌa imiꞌi baaraꞌa, turuu umainaabatan oii-karu kida.” Uruꞌu naa ukiaꞌakan machiꞌikakaꞌo pidan ati, ");
INSERT INTO wapNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Õkian puꞌati, pukadishita, puzaamata puwashatinapa-kizi, naꞌiki pukiwaꞌa naa pudapu iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ipai awunuutapainao awun zaꞌa, machiꞌikakaꞌo pidan kadishitaꞌakan, uzaamataꞌakan pawashatinapa-kizi, naꞌiki ukiwaꞌakan naa padapu iti. Tuukii ĩdiꞌitinpan naꞌiki ĩkonaukii-kidan Tominkaru. Ĩkian, “Mishiꞌo mishi Tominkaru umanawunun! Aonaa watukapauzon aimaakan shaꞌapata-kao kaikapaꞌa!” ");
INSERT INTO wapNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus makon koshan Galilee Karishiiz danoma iti. Iriba pidannao kaawan uꞌidiꞌiti, naꞌiki ukakinaopan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Udaunaꞌan udobatapan puꞌu utukapa Levi, Alphaeus dani, zaamaapauzo tax puraatannaa, sakanatapan pakaudin-kizi kabaun nazo ii. Jesus kian uꞌati, “Puwaꞌati õtuma.” Levi kadishitaꞌakan udaꞌanaꞌakan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aizii Jesus aroopan donoꞌo naa Levi dapu ii patominapa-kidaniinao tuma, iriba zaamaapauzonao tax puraatannaa naꞌiki baꞌoran oiainao pidannao daꞌanpan Jesus. Naꞌii ĩaroopan utuma kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Naꞌaꞌo kapam ĩbiiꞌi tiichaapauzonao Moses kakinaori dauꞌu, zaamatinpainaouz Phariseenao diꞌiti. Ĩtukapan idi uaroopan wunao tumaꞌa oiainaouz pidannao, naꞌiki zaamaapauzonaouz tax puraatannaa, sariapa ĩpishaan utominapa-kidaniinao, “Kandii nii Jesus aroopan kaikapainao pidannao tumaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus abata naꞌapam ĩkian, naꞌiki ukian ĩꞌati, “Ziwuꞌo pidan, aonaa uaipan daakataa, soo karinaꞌo. Õwaꞌatin aonaa õdapadaꞌanan mani kaimanainao, mazan õdapadaꞌanan oiainao paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Baukapaiman John Chikaawunuupauzo kakinaopauzoniinao naꞌiki Phariseenao sanadinpan. Pidannao pishaan Jesus, “Kandii nii wunao sanadinpanuꞌu, mazan putominapa-kidaniinao aonaa ĩsanadinpan?” ");
INSERT INTO wapNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus kian, “Turuu uaitapan dapada-kariwainao kiwan maaroopaka-daun, mazidaꞌo aroapa-kizi iki? Aonaa! Mazidaꞌo naꞌan puꞌu manawun ĩtuma aonaꞌo nii ĩmaaroapakan. ");
INSERT INTO wapNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mazan kamoo kaawan nii, uruu mazidaꞌo naꞌaka-kao niꞌi naa ĩꞌai. Naꞌapainiꞌo nii paꞌan ĩsanadinpan. ");
INSERT INTO wapNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Aonaa naꞌiaꞌoram pidan zimindotan pakamichan zaam paꞌinaꞌo kamicha idin idi, uchikaa-kao dono sariaapaꞌo nii paꞌinaꞌo kuzuutanuzu powaꞌa zii manawun. ");
INSERT INTO wapNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aonaa paꞌinaꞌo toma-kariwai riwunii paidauzo-kao kaiwapa-kariwaiꞌi naa riwunii kinnaa zoꞌiti. Upaida-kao an uzoꞌiti, riwunii kataman dono, sariaapaꞌo nii riwunii tadaꞌokanuzu naꞌiki uwakudinan nii, ukinnaa aonaꞌo niꞌi naa ukaiwaa-kao powaꞌa kapam. Uruu idi paꞌinaꞌo riwunii toma-kao an, paꞌinaꞌo nii ukinnaa toma-kao kapam.” ");
INSERT INTO wapNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesus dobatapan zakapu zoꞌan Sookapa-karu Kamoon dono. Utominapa-kidaniinao makopaanan puꞌu utuma, ĩkaraowaanan paoribai wheat aka ĩnikapaanan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Naꞌaꞌo Phariseenao ĩtuma. Sariapa ĩkian Jesus ati, “Putukapa, putominapa-kidaniinao, aonaa ĩizoꞌatin mani wakakinaorinaa wuruꞌu ĩshaꞌapatanuz kaikapaꞌoraꞌa Sookapa-karu Kamoon dono.” ");
INSERT INTO wapNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus dakoꞌatin ĩdyaun, ukian, “Aonaa mooko utukapauzon kaarita idaꞌaꞌoraz usaadinpan kanom King David shaꞌapatauzonii, tawuruꞌu uzamazin donoꞌoraz paminaudaꞌunao tuma? ");
INSERT INTO wapNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David morotan Tominkaru Dapu iti, naꞌiki unikan bread taa-kariwaiz Tominkaru ati. Faadaa Abiathar kazowautapan donoꞌo Tominkaru Dapu, wuruꞌu ĩnaꞌapainapanuz. Wakakinaorinaa kiauzon puꞌu soo faadaanaouꞌo nii nika wuruꞌu breadiz. Mazan David upuꞌu unikanuz naꞌiki utaa kapamaz paminaudaꞌunao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Udaunaꞌan powaꞌa zii ukian ĩꞌati, “Sookapa-karu Kamoon toma-kao pidan atiꞌo, aonaa pidan toma-kao Sookapa-karu Kamoon ati. ");
INSERT INTO wapNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ukauꞌan Daonaiora Aokazi Ikiꞌo, uruu Sookapa-karu Kamoon Naobanaa paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus makon naa powaa iti synagogue iti, naꞌiaꞌo pidan aonaꞌo kanom ushaꞌapatan pakaꞌu mawakan idi. ");
INSERT INTO wapNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Naꞌaꞌo pidannao Phariseenao biiꞌi, ĩaipan patukapan Jesus shaꞌapatan panaꞌitiꞌo aimaakan pakakinaorinaa ai. Uruu idi ĩaipan naa patukapan ukakudan nii mani wuruꞌu pidanaz Sookapa-karu Kamoon dono oo aonaa. ");
INSERT INTO wapNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus kian wuru atiꞌi pidanaz aonaꞌoraz ukaꞌu kaimanan, “Puwaꞌati daꞌatiꞌi pidannao kanaapu ati.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Udaunaꞌan Jesus pishaan pidannao kaikapaꞌa: “Naꞌapa dii kakinaorii aipan washaꞌapatinan Sookapa-karu Kamoon dono? Wakaminkaꞌuta oo wapatakaꞌuta wairiban? Wakakuda oo wazowii pidan?” Mazan aonaa karikaonan ĩdakoꞌatin uparadan. ");
INSERT INTO wapNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Uruu idi Jesus toꞌoran, uawunuudanaan ĩꞌati. Unaꞌapan puꞌu tuukii ukashaꞌora-kidan ĩdyaun, ĩkashadamikin puꞌu. Uruu daunaꞌan ukian pidan ati, “Putunuuta puanoba.” Utunuutaꞌakanuzu, sariapa ukaꞌu saabainaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Uruu idiꞌi naa Phariseenao makoꞌokan naa synagogue iki, ĩmiitiniipan Herod pidanannao tuma, naꞌiki ĩbaokopatan padiꞌitinpan ĩaipan pazowian Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus makon patominapa-kidaniinao tuma Galilee Karishiiz danoma iti, naꞌiki iriba pidannao daꞌanpan uruu naꞌiti. Ĩwaꞌatin Galilee Baara iki, Judea Baara iki, ");
INSERT INTO wapNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","naꞌiki Jerusalem iki kida. Naꞌiki baꞌorainao waꞌatin kida Idumea Baara iki, waoko itanpuꞌoraz Jordan Waꞌo ai baara iki, naꞌiki baꞌorainao Tyre naꞌiki Sidon Baara iki kida. Ipai wuruꞌu pidannao kaawanuz naꞌati ĩabatan idiꞌo Jesus shaꞌapatan kaiman kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pidannao iriban idi utukapan, udyuudan patominapa-kidaniinao naꞌakan kanawa paꞌidaꞌati, aonaa uaipan pidannao chakatinan paꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ushaꞌapanum kauꞌan ukakudan daunaꞌan iriba karinainao pidannao, naꞌiki baꞌorainao dikintinan ĩaipan papishatan uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Naꞌapainim karikaonan pidan kainaꞌaꞌo oiaꞌo doronai uꞌidaꞌa tukapan Jesus, sariapa udorautaꞌakan ukanaapu ati pakadakoinan tuma, ukian uꞌati, “Pugaru mishi, mishiꞌo Tominkaru Dani!” ");
INSERT INTO wapNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mazan Jesus kakinaowan oiaꞌo doronainao maꞌozakaꞌo idaꞌan. Ukian, “Manaꞌa paꞌi ukowaadaꞌanaꞌa kanom kaduz wuruꞌu õgaruz.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus makon naawazi paawa iti, naꞌikiꞌi naa udapadan paꞌidaꞌati pidannao paaiapaniinao. Uruu idi ĩmakon uꞌidiꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ĩbii ikiꞌi naa uzaamatan 12 pidannao. Udakotan ĩdyaun apostlenao nii. Jesus kian pazaamataniinao ati, “Õzaamatan unao mashaapaꞌo nii õtuma. Õdyuudan nii unao kakuwaapatinaꞌo nii kaimanaꞌo parada-karu dauꞌu, ");
INSERT INTO wapNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","naꞌiki õtaan nii umaꞌozaka-kinaa nii uwaata-kinaa nii oiaꞌo doronainao.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kaikapaꞌo ĩꞌuu kida wuruꞌu 12 uzaamataniinaouz: Simon (Jesus kaꞌuutaniazu Peter kii), ");
INSERT INTO wapNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James naꞌiki John, Zebedee dainao (Jesus kaꞌuutan ĩdyaun Boanerges kii, “Toroanaru kawanuinao” kiaꞌo wuruꞌu ĩdakota-kaoaz), ");
INSERT INTO wapNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James Alphaeus daniz, Thaddeus, Simon uruu zaamatinpauzoz pidannao diꞌiti, tiwautauzonaouz pawaatan Romannao, ");
INSERT INTO wapNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","naꞌiki Judas Iscariot, kaakapaꞌoraz Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Udaunaꞌan Jesus kiwan pasookapauzo-kizi kabaun itiꞌi naa. Naꞌii iriba pidannao kasabaꞌukinan uꞌidaꞌati koshan; uruu idi Jesus, patominapa-kidaniinao tuma, aonaꞌa naa ĩaitapan naꞌapam panikan pawanyukunuu. ");
INSERT INTO wapNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Uiribannao abatan idi uunamunaa, sariapa ĩmakon ĩnaꞌananuzu, “Madoronaitaꞌa naa uruu, padiꞌitinpan idi tuukii!” pidannao kian idi. ");
INSERT INTO wapNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tiichaapauzonao Moses kakinaori dauꞌu, waꞌatiinao Jerusalem iki, kian, “Kainaꞌa Beelzebul uꞌidaꞌa, oiaꞌo doronainao naobanaaz, uruu taaꞌoraz pamaꞌozakan uꞌati, uwaata-kinaa nii oiaꞌo doronainao.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus dapadan pidannao paꞌidaꞌati, uparadan ĩꞌati diꞌitinapa-kinai kuwai idaꞌan, “Naꞌapam nii mooko Satan kodita-kidan Satan? ");
INSERT INTO wapNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aizii wiizai buutinan an mani naꞌiki ĩmizaataakan paꞌatiaaka, aonaꞌo nii ĩmashaapan kaiman. ");
INSERT INTO wapNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pidannao mashaapainao baudaꞌapaꞌo kabaun idaꞌa buutaakapan an mani naꞌiki ĩmizaataakan paꞌatiaaka, aonaꞌo nii ĩmashaapan kaiman. ");
INSERT INTO wapNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ukauꞌan Satan tonaazinaa mizaataakapan an paꞌatiaaka, katokon-tinaꞌo nii unaobanai-tinpan. ");
INSERT INTO wapNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Aonaa turuu pidan morotinan naꞌiki ukoidapan maꞌozakaꞌo pidan dapu iki, soo udodoo-kao an kiwiin zii, udaunaꞌan turuu ushaꞌapauz kida koidapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Õkowaadan nii puꞌati turuu pidannao shaꞌapatanii oii kidaꞌoraz soꞌota-kao ĩꞌai naꞌiki ipai wuruꞌu ĩdakomikitinanuz. ");
INSERT INTO wapNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mazan naꞌiaꞌoram pidan dakoopaꞌoraz Kaimanaꞌo Doronaa, aonaꞌo nii uꞌoian soꞌota-kao uꞌai, karikaonanuꞌo nii uꞌoian naa.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus kian kaikapaꞌa, pidannao kian idi, “Kainaꞌa oiaꞌo doronai uꞌidaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Udaunaꞌan Jesus daro naꞌiki uꞌinawuzunao kaawan, ĩnaꞌian paniba ii ĩkadishitapan. Ĩdyuudan paparadan uꞌidiꞌiti, ĩaipan uwaꞌatin paꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iribaꞌo pidannao sakanatapainaouz udazaba an kian uꞌati, “Kainaꞌa pudaro, puꞌinawuzunao naꞌiki pudadakoonao paniba ii, ĩaipan pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus dakoꞌatin naꞌiki upishaan ĩdyaun, “Kanom õdaro nii? Kanom õꞌinawuzunao nii?” ");
INSERT INTO wapNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Uawunuupan padazaba ainao ati, “Dii õdaro naꞌiki õꞌinawuzunao. ");
INSERT INTO wapNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kanom shaꞌapataꞌo Tominkaru aiapanii, uruu õꞌinawuzu, õdadakoo, naꞌiki õdaro.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus kakinaopan koshan Galilee Karishiiz danoma ii. Pidannao iriban idi, Jesus paidinan kanawa zoꞌiti, naꞌiaꞌa naa usakanatapan. Kanawa mashaapan munapo zaa karishii danoma ai, naꞌiki iribainao pidannao ipai ĩkadishitapan karishii danomata kida. ");
INSERT INTO wapNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesus tominapatin-kidan pidannao diꞌitinapa-kinao kuwai kida idaꞌan. Ukian ĩꞌati, ");
INSERT INTO wapNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Aizii uabata! Kainaꞌa pidan makon upaowinpaꞌanan. ");
INSERT INTO wapNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Zakapu baara iaꞌa naa upararaan naa uudai kida. Baꞌoran uudai kida waotan dunapota karikaonan. Udaunaꞌan kotuꞌuznao kaawan naꞌiki ĩnikaꞌakan naa kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Baꞌoran kida waotan kuba baara iti, kainaꞌaꞌo kapam masakaudaꞌu imiꞌi upaawa an. Uruu idi kadiman uudai kida sodan. ");
INSERT INTO wapNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mazan udaunaꞌan kamoo wiichan tuukii, sariapa uaradadan paꞌinaꞌo paoribai kida. Kadiman paoribai mawakaꞌakan, ushaꞌapanum kauꞌan aonaa ĩishatabaꞌu kida morotan munapo imiꞌi kaꞌazo iti. ");
INSERT INTO wapNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Naꞌiki baꞌoran kida waotan kaiwada-karu bii an. Soda padamata ĩdyaun, mazan aonaꞌa naa ĩkaakan, kaiwada-karu dikinidan idi ĩdyaun kamoo ai. ");
INSERT INTO wapNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Mazan baꞌoran kida waotan kaimanaꞌo imiꞌi baara iti. Uruu idi uudai kida sodan naꞌiki ĩtuubarun atii ĩkaakan: baudaꞌapaꞌo kaakan uꞌaka 30, baꞌoran 60, naꞌiki baꞌoran aka 100.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesus kian, “Pukakinaon an puabataꞌa naa kakinaorii!” ");
INSERT INTO wapNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pidannao kiwan daunaꞌan, Jesus waꞌakinan 12 patominapa-kidaniinao tuma, naꞌaꞌo kapam baokoinao utominapa-kidaniinao. Ĩaipan ukowaadan paꞌati mashaꞌapannaꞌo idaꞌan wuruꞌu diꞌitinapa-kinai kuwai kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ukian ĩꞌati, “Õkainaabatanii uꞌati wuruꞌu aonaꞌoraz ukowaadauzo-kao, naꞌapam Tominkaru naobanaitapa-kao, mazan baꞌorainao ati õkakuwaapan nii soo diꞌitinapa-kinai kuwai kida idaꞌan paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ukauꞌan, ‘Ĩtukapan nii kanom õshaꞌapatanii, mazan aonaꞌo nii ĩaitapanuz. Ĩabatan nii õparadan kida, mazan aonaꞌo nii ĩtaapanuzu. Ĩaitapan an maniz, ĩtanawatin mani Tominkaru diꞌiti, naꞌiki usoꞌotan mani ĩꞌoian kida ĩꞌai.’” ");
INSERT INTO wapNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Udaunaꞌan Jesus kian patominapa-kidaniinao ati, “Aonaan an uaitapan wuruꞌu diꞌoraꞌa diꞌitinapa-kinai kuwai, naꞌapam nii mooko uaitapan baꞌoran diꞌitinapa-kinai kuwai kida? ");
INSERT INTO wapNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Paopauzo paowan kaimanaꞌo kuwai Tominkaru diꞌikiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pabiꞌi kida pidan naꞌapa wuru kawanuꞌu uudai kida waotaꞌoraz dunapota; ĩabatan puꞌaꞌa naa Kaimanaꞌo Kuwai, Satan kaawaꞌakan ĩꞌidaꞌati, ipai ukazataꞌakan ĩꞌai wuruꞌu kaimanaꞌoraz kuwai paowa-kariwaiz ĩꞌidaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Baokoinao pidannao, ĩnao uudai kida kawanuꞌo, waotaꞌoraz imiꞌi diꞌiti, kuba baara paawa anaꞌoraz. Ĩabatan dono Kaimanaꞌo Kuwai, konaukii ĩzaamatanuzu, ");
INSERT INTO wapNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","mazan aonaa ĩtaapan wuruꞌu kakinaorii kotuaꞌiki paꞌidaꞌa kida. Masakaudaꞌu karikaonan ĩtaapanuzu. Naꞌapainim ĩshaꞌapataꞌazoo-kao an oo ĩpatakaꞌutaꞌazoo-kao an Kaimanaꞌo Kuwai dikin ii, sariapa ĩtanawatinan powaa iti pamishidan ai wuruꞌu kaimanaꞌoraz kuwai. ");
INSERT INTO wapNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Baokoinao pidannao, ĩnao uudai kida kawanuꞌo, waotaꞌoraz kaiwada-karu kida sakodata. Ĩnao, ĩabata wuruꞌu kuwaiz, ");
INSERT INTO wapNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mazan ĩdiꞌitinpan aimaakan aiapa-kao dauꞌu, naꞌiki kashaꞌapauzi-karu dauꞌu, naꞌiki ĩaipaa-biꞌian ipai pabiꞌinaaka sodi kidaꞌo aimaakan. Uruu idi ĩmanyukunuutan naa wuruꞌu kuwaiz. Naꞌiki aonaꞌa naa ĩshaꞌapainpan kaiman kuwai kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Mazan baokoinao pidannao, ĩnao uudai kida kawanuꞌo waotaꞌoraz kaimanaꞌo imiꞌi baara iti. Ĩabata wuruꞌu kuwaiz naꞌiki ĩmishida, tuukii ĩtaan panyukunuu atiz. Ĩkaakan baudaꞌapaꞌo aka 30, baꞌoran 60, naꞌiki baꞌoran 100 manawun.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Udaunaꞌan Jesus kian ĩꞌati, “Pidan suuan an lamp kabaun nazo ii, naꞌiam umuuda-kao, boon waranuꞌu oo bed waranu ii? Aonaa dokoꞌo mani umuuda-kao, aimaakan paawaꞌa? ");
INSERT INTO wapNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kanom dizinpaꞌo utaapa-kao, naꞌaka-kao nii kanadaꞌo idaꞌati. Naꞌiki kanom taratapa-kariwai, daꞌata-kao niiz. ");
INSERT INTO wapNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pukakinaon an puabataꞌa naa kakinaorii!” ");
INSERT INTO wapNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Punyukunuuapa pakawan puabatanii; punaꞌapan an, uruu kawanaꞌatiꞌo nii puaitapan. Naꞌiki powaꞌaꞌo nii zii manawun puaitapan taa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pidan zaamataꞌo õkakinaori, powaꞌaꞌo nii zii uaitapan taa-kao. Mazan pidan aonaꞌoraz uabatan õkakinaori, aonaꞌo nii naꞌapainim uaitapan taa-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus kakinaopan koshan, ukian, “Tominkaru Naobanai-tinan kaikapaꞌoraꞌa. Wuru kawanuꞌu pidan paowanuz uudai pazakapun ii. ");
INSERT INTO wapNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Udaunaꞌan udaꞌawun aiwakaꞌan, wakanadan puꞌu upokodapan, mazan uudai sodan naa. Aonaa uaitapan naꞌapam dii usodan. ");
INSERT INTO wapNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Paaipan atiꞌo imiꞌi soda-kidan uudai, atii ukaakan. Kiwiin shomada sodiꞌo nii zii ukadunaa koditan atii udyaupain, udaunaꞌan ukaakan. ");
INSERT INTO wapNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uꞌaka dyuuan donoꞌo naa, pidan dukutan naazu pasooparan idi, ukamoon kaawan idiꞌi naa.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Kanom kawanuꞌo dii wuruꞌu Tominkaru Naobanai-tinanuz?” Jesus kian. “Kanom kaduz diꞌitinapa-kinai kuwai mani turuu wakaiwaan wakowaada-kinaa niizu? ");
INSERT INTO wapNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kaikapaꞌo wuruꞌu: Pidan paowan papaoriba mustard uuda imiꞌi diꞌiti, uruu duusodiꞌo ipai baꞌoran paoribai kida uuda ai. ");
INSERT INTO wapNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Usodan donoꞌo naa powaꞌa zii utuubarun ipai paoribai paowa-kariwaiz zakapu iaꞌo ai, naꞌiki ukawaodainan iriba. Uruu idi iriba kotuꞌuz toman pashimaka kida naꞌapain ĩdikindinan uwaranuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus tominapa-kidan pidannao soo diꞌitinapa-kinai kuwai kida idaꞌan, wuru kida kawanuꞌu. Utominapa-kidan ĩdyaun masakaudaꞌu ĩaitapan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aonaa naꞌapainim umakaiwaakan diꞌitinapa-kinai kuwai pakakinaowapa-kinaa nii, mazan pabaꞌoranin dono patominapa-kidaniinao tuma, naꞌapainiꞌo nii zii ukowaadan ĩꞌati mashaꞌapannaꞌo parada-karu idaꞌan wuruꞌu kuwai kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naꞌapain uruu wachuupunin, Jesus kian patominapa-kidaniinao ati, “Wamakoꞌo naa karishii baza iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Uruu ĩwaꞌakaꞌakan naa pidannao, ĩpaidinan naa kanawa zoꞌiti, uruu ĩmakon naa. Kainaꞌa kapam baꞌorainao kanawa zoꞌan kida makon ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mashaꞌapakiaka maꞌozakaꞌo awaru kaawan naꞌiki sariapa udaruꞌo wunu paran kida daawadaan kanawa, maonapa kida unaraadanuzu. Atii wunu paidinaꞌaka kanawa zoꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus, udaꞌawun paꞌan, kaimanaiman ukawiizi-baaratan pazowau kanawa tokon itinapu. Sariapa utominapa-kidaniinao pokowauanuzu, naꞌiki ĩkian uꞌati, “Tiichaa. Aonaa mooko pudopii-kidan waunao? Taaꞌazoꞌo naa wanaraan.” ");
INSERT INTO wapNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sariapa Jesus pokodaꞌakan naꞌiki ukian awaru naꞌiki wunu paran ati, “Pumashaadin!” Sariapa awaru mashaadinaꞌakan naꞌiki wunu paran sookaꞌakan naa kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Udaunaꞌan sariapa Jesus kian patominapa-kidaniinao ati, “Kanom nii dii utarian? Aonaa zii mooko umishidan?” ");
INSERT INTO wapNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mazan tuukii ĩtarian manawun, naꞌiki sariapa ĩkian paꞌatiaaka kida, “Kandii kaduz dii pidan uruu? Atii awaru naꞌiki wunu paran izoꞌati zii uparadan.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus naꞌiki utominapa-kidaniinao kaawan baza iaꞌo karishii danoma iti, Gerasa Baara itinapu. ");
INSERT INTO wapNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus maratinan puꞌu kanawa zoꞌiki, pidan ikodapan uruu, koditaꞌakaꞌo baaranai iki, kaꞌunaru kida diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wuruꞌu pidanaz oiaꞌo doronainao zaamatapanii. Unaꞌauzon umashaapan baaranai an. Aonaꞌa naa kanom kaꞌiitan padodotan uruu powaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Iribaꞌa naa pidannao tiwaan pawatudan uanoba naꞌiki utabaꞌu, mazan ipai ubiditaꞌakan chain, wuruꞌu pawatudapa-kinao kidaz. Umaꞌozakan idi manawun aonaꞌa naa turuu uzaamata-kao. ");
INSERT INTO wapNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Unaꞌiakapan baaranai ii aka naꞌiki midukuo ii aka, wakanadan puꞌu naꞌiki aiwakaꞌan ukadakoinpan naꞌiki ipai utazaubiꞌian pamada kuba idi. ");
INSERT INTO wapNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Munapo zii utukapan Jesus, sariapa udiman uꞌidaꞌati naꞌiki ukodoruꞌukan ukanaapu ati, ");
INSERT INTO wapNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","naꞌiki ukadakon diiwaꞌo idaꞌan, “Jesus, Tominkaru Umanawunuꞌo Dani! Kanom dii puaipan õꞌai? Tominkaru uu idaꞌan, õpishaan pugaru aonaa shoman pupatakaꞌutaꞌanaꞌa õgaru,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wuruꞌu uparadanuz kaikapaꞌa, Jesus dyuudan idiꞌo oiaꞌo doronainao soꞌotinan uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus pishaanuzu, “Naꞌapam puꞌuu?” Pidan kian, “Õꞌuu Iribainao, iribaꞌo wuruꞌu waunaouz!” ");
INSERT INTO wapNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tuukii upishaan Jesus aonaa kizi udyuudan oiaꞌo doronainao naꞌiaꞌo amazada ai. ");
INSERT INTO wapNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Naꞌiaꞌo iribaꞌo kooshinao kasabaꞌukinpan naawazi zaꞌan, ĩaroapatinan. ");
INSERT INTO wapNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Uruu idi oiaꞌo doronainao pishaan Jesus tuukii, “Turuu shoman pudyuudan wamorotan kooshinao diꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","“Turuu!” Jesus kian. Uruꞌu naa ĩkoditaꞌakan pidan diꞌiki, ĩmorotaꞌakan naa kooshinao diꞌiti. Iribaꞌo wuruꞌu kooshinaouz ikoda mani 2000 ĩdyaun. Naꞌikiꞌo ĩdimaꞌakan atii tawudapu an, atii ĩwaotan karishii baoko iti. Uruu idi ipai ĩnaraan. ");
INSERT INTO wapNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Uruꞌu naa kooshinao taapikinao dimaꞌakan naa, ĩkakuwaapaꞌanaꞌakan naa donoi iaꞌo pidannao ati, naꞌiki baokoinao ati kawiizi-tinpainaouz donoi dawun ii kida. Sariapa pidannao makon naꞌiti ĩtukapa ipai wuruꞌu shaꞌapaꞌoraz naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ĩkaawan Jesus idaꞌati, ĩtukapa wuruꞌu pidanaz iribaꞌoraz daꞌi oiaꞌo doronainao uꞌidaꞌa. Naꞌa usakanatapan kakamichantinpaꞌa naa, aitapinaꞌa naa kapam. Tuukii ĩtarian. ");
INSERT INTO wapNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pidannao tukapainaouz kanom shaꞌapan, ĩkakuwaapan naa baꞌoran pidannao ati wuru dauꞌanaꞌa oiaꞌo doronainao zaamatapauzoniaz daꞌi pidan, naꞌiki kooshinao dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Uruu idi tuukiaꞌo idaꞌan ĩpishaan Jesus, ĩaipan umakon pawiizi iki. ");
INSERT INTO wapNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus paidinaꞌazon puꞌaꞌa naa kanawa zoꞌiti, pidan soꞌota-kariwaiz oiaꞌo doronainao uꞌidiꞌiki, kian Jesus ati tuukiaꞌo idaꞌan, “Õmako kizi putuma!” ");
INSERT INTO wapNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aonaa Jesus taapadan umakon patuma. Mazan ukian uꞌati, “Pukiwaꞌa naa puiribannao diꞌiti, pukowaadaꞌan kizi kanom Naobanai shaꞌapata puꞌati, ukaimanan idi ukaminkaꞌutan pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Uruu idi pidan kiwaꞌakan naa, naꞌiki ukakuwaapaanan 10 wiizainao Decapolis Baara an kidainao pidannao ati. Ipai ukowaadan pidannao ati Jesus shaꞌapatanii kida paꞌati. Naꞌiki ipai abatainao ukuwaa, tuukii ĩdiꞌitinpan udauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus kiwan patominapa-kidaniinao tuma powaa iti karishii baza iti kanawa idaꞌan. Naꞌii iriba pidannao kasabaꞌukinan udazaba an awauta. ");
INSERT INTO wapNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Udaunaꞌan pidan Jairus kiaꞌo uꞌuu kaawan Jesus idaꞌati, uruu kazowautapauzo synagogue pawiizi ii. Utukapan Jesus, sariapa ukodoruꞌukan, udawukan Jesus kanaapu iti ukidiba idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Naꞌiki tuukiaꞌo idaꞌan manawun upishaanuzu uaipan pakaminkaꞌuta-kao. Ukian Jesus ati, “Õdani sodi zun maonapaꞌa naa omawakan. Turuu pumakon naꞌiti pupishata kizi pukaꞌu idi oroo, okakuda kizi naꞌiki oziwu kizi powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Udaunaꞌan Jesus makon naa utuma. Iriba pidannao makon kapam ĩtuma, atii chakata ĩmashaapan udazaba an kida. ");
INSERT INTO wapNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Naꞌaꞌo zun izaipaiba pidannao biiꞌi. 12 wunu obaiatinan. ");
INSERT INTO wapNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Omakoniꞌi naa kiwiin bakadun kida daakataanao diꞌiti, naꞌiki ipaiꞌi naa otaan papuraatan ĩꞌati. Oaipan pakakudan padamata, mazan kiiꞌan oizain tuukiidinan naa powaꞌa zii manawun. ");
INSERT INTO wapNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Oabatauzon idi Jesus shaꞌapatan umanawunuꞌo aimaakan, omakon naa pidannao bii an Jesus dawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Okian paꞌidaꞌa, “Õpishatan an ukamichan karikaonan, kaimanaꞌo nii õkakudan.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Opishataꞌakan naa uchaakitan zaꞌabaꞌi, sariapa oizaipan shabataꞌakan; naꞌiki kaiman oabatinaꞌakan pakaꞌazo ii, pasaabaa-kao idi pabaiatinan ai. ");
INSERT INTO wapNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sariapa Jesus aitapan pamaꞌozakan shaꞌapatan aimaakan umanawunuꞌo. Utanawatinaꞌakan powaa iti iribaꞌo pidannao zikonuꞌu, upishaan ĩdyaun, “Kanom pishataꞌoraz õkamichan?” ");
INSERT INTO wapNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Utominapa-kidaniinao dakoꞌatin uruu, “Puaitapanii iriba pidannao pudazaba an kasabaꞌukinpan. Kanom nii mooko pupishaan kanom pishataꞌoraz pugaru?” ");
INSERT INTO wapNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mazan upuꞌu Jesus awunuudanaan utukapaꞌazon kanom pishataꞌoraz paugaru. ");
INSERT INTO wapNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wuruꞌu zunaz oaitapanii kanom shaꞌapan paꞌati, sariapa owaꞌatin panaka-nakaan naꞌiki patarian biiꞌi Jesus idaꞌati. Okodoruꞌukan maonapa ukanaapuꞌu, naꞌiki okowaadan Jesus ati ipai kanom shaꞌapan paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus kian oꞌati, “Pumishidan idiꞌo pukakudan. Pumakoꞌo naa, punyukunuu kaimanan tuma, pukakuda-kaoaꞌa naa shaa pubaiatinan ai.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus kadakotinan puꞌu zii, pidannao kaawan Jairus dapu iki kuwaitaꞌanainao uꞌidaꞌati. Sariapa ĩkian, “Marinaꞌa naa Tiichaa, mawakaꞌakaꞌa naa pudani!” ");
INSERT INTO wapNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mazan Jesus aonaa utauan panyukunuu ati naꞌapaꞌoram ĩparadan, naꞌiki sariapa ukian Jairus ati, “Manaꞌa putariaꞌa naa, mazan pumishida paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Udaunaꞌan aonaa utaapadan ipai pidannao makon patuma, soo unaꞌaka Peter, James naꞌiki John James inawuzuz patuma karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ĩkaawan Jairus dapu iti, naꞌii Jesus tukapan iriba pidannao kasabaꞌukinpan naꞌiki ĩzaadinan diiwaꞌo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesus morotan kabaun nazo iti naꞌiki sariapa ukian pidannao ati, “Kandii nii mooko uzaadinan kaikapaꞌa? Manaꞌa ukashaꞌoraꞌanaꞌa! Aonaa koraidaonaa mawakan mani wuruꞌu. Soo odaꞌawupan karikaonan.” ");
INSERT INTO wapNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mazan ĩshaazootinan udauꞌu, pamamishidakan idi uparadan. Sariapa udyuudan ĩkoditan kabaun nazo iki; unaꞌakan soo koraidaonaa daronao naꞌiki paminaudaꞌunao, umorota-kidan ĩdyaun koraidaonaa washatinpan diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesus zaamatanuzo pakaꞌu kadu iki naꞌiki ukian oꞌati, “Talitha koum.” Kaikapaꞌo wuruꞌu parada-karuz: “Zuna sodi, õkian, pukadishita,” kiaꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sariapa okadishitaꞌakan naꞌiki ochiꞌikaꞌakan naa. (12 owunun wuruꞌu zun sodiz.) Okakudan idi, tuukii ĩdiꞌitinpan. ");
INSERT INTO wapNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mazan Jesus kian ĩꞌati, “Manaꞌa paꞌi ukowaadaꞌanaꞌa udauꞌan.” Naꞌiki ukian kapam ĩꞌati, “Utaaꞌa naa owanyukunuu nii.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Udaunaꞌan Jesus makon padyaupai-kizi wiizai iti patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sookapa-karu Kamoon dono utominapa-kidan pidannao synagogue ii. Iriba pidannao naꞌiainao abatan ukuwaa, tuukiaꞌo idaꞌan manawun ĩdiꞌitinpan. “Naꞌiki dii uaitapan ipai wuruꞌu?” ĩkian. “Kanom taanii uꞌati uaitapa-kinaa nii? Naꞌapa dii ushaꞌapatan umanawun kidaꞌo aimaakan, aonaꞌo watukapauzon? ");
INSERT INTO wapNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aonaa carpenter mani uruu, Mary daniz? Aonaa James, Joseph, Judas naꞌiki Simon inawuzu mani wuruꞌu uruuz? Aonaa mooko udadakoonao mashaapan daꞌaꞌa?” Aonaa ĩmishidan, naꞌiki aonaa ĩnyukunuu-atin wuruꞌu ushaꞌapaapanii kidaz. ");
INSERT INTO wapNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus kian ĩꞌati, “Tominkaru prophetinnao naubaa-kao baꞌoran wiizai ii kida, mazan pawiiziꞌi, aonaa uiribannao naꞌiki baꞌoran pidannao naubaan uruu!” ");
INSERT INTO wapNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Uruu idi aonaa Jesus shaꞌapatan umanawun kidaꞌo aimaakan naꞌii, soo masakaudaꞌu karikaonan, upishatan karinainao pakaꞌu idi naꞌapain ukakuda ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tuukii manawun udiꞌitinpan ĩdauꞌu ĩmamishidakan idi paugaru. Udaunaꞌan Jesus makon naa ipai wiizai kida kawanaꞌati; naꞌii ukakinaopan ipai pidannao. ");
INSERT INTO wapNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Udapadan 12 patominapa-kidaniinao baokopa paꞌidaꞌati. Udaunaꞌan udyuudan naa ĩmakon dyaꞌutam kida. Utaan maꞌozaka-karu ĩꞌati, ĩkodita-kida-kinaa nii oiaꞌo doronai kida. ");
INSERT INTO wapNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Udaunaꞌan ukian ĩꞌati, “Manaꞌa paꞌi unaꞌakaꞌanaꞌa aimaakan kida utuma umakon an, soo uwadookori paꞌan. Aonaa unaꞌakaꞌanaꞌa wanyukunui, oo usaakon, oo upuraatan kida. ");
INSERT INTO wapNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pukaiwada pudazkidi. Aonaa punaꞌakaꞌa naa baꞌoran pushooton.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesus kian ĩꞌati kapam, “Naꞌiam udapaapa-kao kaiman, naꞌii usookadin uruu kabaun diꞌii atii udobataꞌazon kawanaꞌati baꞌoran wiizai iti. ");
INSERT INTO wapNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ukaawan an naꞌiaꞌoram wiizai diꞌiti, ĩmadapaapakan an unao kaiman oo ĩmaabataꞌazookan an ukuwaa, udobata naꞌiki uparaudaꞌaka imiꞌi ukidiba iki kida, ĩaitapa kizi papatakaꞌuta-kao nii.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Uruu idi ĩmakoꞌokan kidaꞌa naa ĩkakinaopaanan pidannao ĩtanawatin kiziꞌi naa paꞌoian kida ai. ");
INSERT INTO wapNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ĩkodita-kidan iriba oiaꞌo doronainao kida pidannao ai, naꞌapain iriba ĩramaudan pidannao olive oil idi naꞌiki ĩkakudan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Herod abatan Jesus kaunamanaan ipai amazada kawanaꞌati. Pabiꞌi kida pidannao kian, “John Chikaawunuupauzo kakudaꞌoraz powaa iti! Uruu idiꞌo wuruꞌu kainaꞌa umaꞌozakan ushaꞌapata-kinaa nii umanawun kidaꞌo aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Baꞌorainao kian, “Uruu Elijah!” Baꞌoran kian, “Uruu prophet, kotuaꞌo Tominkaru prophetin kawanuꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod abatan idizu, ukian, “Uruu John Chikaawunuupauzo! Õdukuta-kidaniꞌi naa shaꞌatii ukanau, mazan kainaꞌa ukakudan powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kaikapaꞌo daꞌi wuruꞌu John zowiauzo-kaoaz. Herod dyuudan John zaamata-kao, udodota-kao naꞌapain utaraa-kao. Herod shaꞌapatan wuruꞌu kaikapaꞌa Herodias aipan atiꞌo, uzaamataniaz paudaiaro nii, paꞌinawuzu Philip daiaroz. ");
INSERT INTO wapNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John Chikaawunuupauzo aonaa umashaadan pakadakotinan Herod ati kaikapaꞌa: “Aonaa Tominkaru kashaapan pidan zaamatan paꞌinawuzu daiaro!” ");
INSERT INTO wapNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Uruu idiꞌi naa Herodias toꞌora-kizaitapan John, oaipan pazowii-kidanuzu. Mazan Herod kazannaatapa uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod tarian John ai, uaitapan idi kaimanaꞌo naꞌiki umanawunuꞌo pidan uruu. Unaꞌapan idi utaapan uruu kaiman. Unaudapa paabatapan John paradan paꞌati, panyukunuu kasharutinpan puꞌu padamata tuukii, ipai John paradan kawanaꞌati paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herod shakatan kamoo kaawan donoꞌo naa, Herodias kian, “Aizii turuaꞌo nii õkaunaatinan John ati.” Naꞌapain, Herod dapadan ipai umanawun-tinpainao pidannao, soldyaa zowaunaanao kida naꞌiki kazowautapainao pairibannao Galilee Baara ii. ");
INSERT INTO wapNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias dani mawuusa morotan naꞌiki okonaupan naa. Tuukii Herod naꞌiki upidanannao konaukii-kidanuzo. Uruu idiꞌi naa King Herod kian oꞌati, “Naꞌiaꞌoram aimaakan puaipan, õtaan nii puꞌati. Pupishaa õꞌai! ");
INSERT INTO wapNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mishiꞌo õparadan, õtaan nii puꞌati kanom puaiapanii, turuu õtaan puꞌati pazikon an õshaꞌapauz.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naꞌikiꞌo mawuusaba koditan opishaaꞌanan padaro kaikapaꞌa: “Kanom turuu õpishaan uꞌai?” Odaro kian, “John Chikaawunuupauzo zowau, pukii.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kadimanaꞌo idaꞌan okiwaꞌakan king diꞌiti. Okian, “Õaiapa putaan õꞌati aizii daꞌaꞌa John zowau paraapi nazoꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Uruu idi tuukii king kashaꞌoran, mazan aonaꞌa naa turuu upanaꞌadan paparadan: ipai pidannao abatan wuruꞌu upishaanuz oroo. ");
INSERT INTO wapNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sariapa udyuudaꞌakan soldyaa naꞌanan John zowau taraa-kizai iki. Soldyaa makoꞌokan udukutaꞌakan naa John kanau. ");
INSERT INTO wapNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Udaunaꞌan ukaawa-kidan naa paraapi idaꞌanaz utaan naa zun atiz. Udaunaꞌan zun taan naazu padaro ati. ");
INSERT INTO wapNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John tominapa-kidaniinao abatan idiꞌi naa uzowii-kao, ĩnankan naa John nanaa, ĩdidan naa kapamazu. ");
INSERT INTO wapNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesus dyuudaniinao kaawan uꞌidaꞌati powaa ati, naꞌapain ipai ĩkowaadan pakakinaopan dauꞌu pidannao, naꞌiki kanom pashaꞌapata. ");
INSERT INTO wapNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iriba pidannao kaawa-kaawan Jesus idaꞌati, baokoinao kiwa-kiwan puꞌu kapam, aonaa kowas naꞌapam naa ĩaroopan. Uruu idi Jesus kian ĩꞌati, “Wamako amazada iti pidannao ai, usookapa kizi masakaudaꞌu naꞌii.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Uruu ĩmakoꞌokan naa baza iti kanawa idaꞌan pidan aonaa-kizi itinapu. ");
INSERT INTO wapNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Upuꞌu iriba pidannao tukapan ĩmakon, naꞌapain ĩaitapa ĩdyaun. Uruu idi ipai pidannao makon kadimanaꞌo idaꞌan wiizai kida iki unaawa an. Ĩkaawan kiwiin Jesus makopa-kizi iti. ");
INSERT INTO wapNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus maaratinan kanawa diꞌiki, utukapa iriba pidannao, tuukii ukashaꞌoran ĩdauꞌan, utukapan idi kaznizonao kawan ĩdyaun, aonaꞌoraz ĩkataapikin. Uruu idi dobata ukakinaotan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wachuupun idiꞌi naa, utominapa-kidaniinao kian uꞌati, “Wachuupuꞌunan naa wuruꞌu, naꞌiki daꞌaꞌorazu amazadaꞌaꞌo karikaonan wuruꞌu waunaouz. ");
INSERT INTO wapNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pudyuudaꞌa naa shoman wuruꞌu pidannaouz, maonapaꞌo zakapu oo wiizai kida diꞌiti ĩtoriiꞌan kizi pawanyukunuu nii.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Unao mishiꞌoraiman taa ĩwanyukunuu nii.” Jesus kian. Ĩpishaan uruu, “Puaiapa shaꞌa watoriankan ĩwanyukunuu nii 8 kauzu kaudin-karu winipinaa idaꞌan?” ");
INSERT INTO wapNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Uruu idi Jesus pishaan ĩdyaun, “Naꞌapaudaꞌum bread kainaꞌa uꞌidaꞌa? Utukapanaka.” Ĩawunuutankan daunaꞌan, ĩkian uꞌati, “Kainaꞌa bakaꞌiaudaꞌu breadnao naꞌiki dyaꞌutam kopaunao sodi kida.” ");
INSERT INTO wapNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Udaunaꞌan Jesus dyuudan patominapa-kidaniinao sakanata-kidan pidannao, katoontinapa kida koꞌoriꞌo pinidi paawa an. ");
INSERT INTO wapNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Uruu idi pidannao sakanatan katoontinapa kida, baudaꞌapaꞌo idaꞌa 100, baꞌoran idaꞌa 50. ");
INSERT INTO wapNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus zaamatan wuruꞌu bakaꞌiaudaꞌuꞌoraz breadnao naꞌiki dyaꞌutamaꞌoraz kopaunao, uawunuupan aokazi iti patoriinpan tuma, “Kaimanaꞌo pugaru Tominkaru, putaan idi wawanyukunuu nii.” Udushowan naa wuruꞌu bread kidaz, udyuudan naa patominapa-kidaniinao taanuzu ipai pidan kawanaꞌati. Naꞌapa kapam ubuutan wuruꞌu kopau kidaz ipai ĩkawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ipai pidannao aroopan abaapa kida. ");
INSERT INTO wapNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Udaunaꞌan Jesus tominapa-kidaniinao zawadan 12 dazowan kida wanyukunui waꞌakun. ");
INSERT INTO wapNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Daonaioranao paa-kariwaiz naꞌapain, uikoda mani 5000 ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sariapa uruu daunaꞌan aka Jesus dyuudan patominapa-kidaniinao kiwiitan paꞌuaꞌati baza itinapu kanawa idaꞌan Bethsaida iti. Uruu unaꞌan zii, udyuudaꞌazon idi pidannao kiwan padapu iti kida. ");
INSERT INTO wapNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pidannao kiwan daunaꞌan, umakon naawazi paawa iti. Naꞌiaꞌa naa utoriinpan. ");
INSERT INTO wapNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kamoo tipitanin, karishii zikon iaꞌa naa kanawa, Jesus naꞌian zii paꞌan unaawa ii pabaꞌorantin. ");
INSERT INTO wapNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Utukapa aonaa patominapa-kidaniinao kaꞌiitan papooratan kanawa kadiman, awaru pootan idi ĩdyaun pakanaapu iki. Aizii wakankanaanin ukaawan ĩꞌidaꞌati, chiꞌikapa wunu paawa an. Uwazoo-wazooan puꞌu ĩdyaun, ");
INSERT INTO wapNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ĩtukapa uchiꞌikapan wunu paawa an. “Maꞌachai!” ĩkian patarian biiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ipai ĩtarian tuukii ĩtukapan idi uruu. Sariapa Jesus paradan, ukian ĩꞌati, “Manaꞌa utariaꞌanaꞌa. Õgaru wuruꞌu!” ");
INSERT INTO wapNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Udaunaꞌan upaidinaꞌakan naa ĩtuma kanawa zoꞌiti. Sariapa awaru mashaadaꞌakan, tuukii manawun ĩdiꞌitinpan udauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ushaꞌapanum kauꞌan aonaa zii ĩaitapan manawun kanom shaꞌapaꞌo 5000 pidannao paa-kao donoꞌoraz, dadara ĩzaamatan aimaakan panyukunuu iti. ");
INSERT INTO wapNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ĩtaraukan karishii wakadapu itinapu Gennesaret Baara iti. Naꞌii ĩkoꞌidan pakanawan karishii danomaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ĩmaaratinan kanawa diꞌiki, sariapa pidannao aitapaꞌakan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Uruu idi ipai pidannao makoodanaan wiizai kawanaꞌati kida, ĩnaꞌakan karinainao pawiizi baara idaꞌan kida paabata-kizi iti naꞌiam Jesus kaawan. ");
INSERT INTO wapNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus makon an naꞌitim karikaonan, wiizai, donoi, oo zakapu kida iti, pidannao naꞌakan nii karinainao uꞌidaꞌati, naꞌapain ĩpishaan uruu tuukiaꞌo idaꞌan ĩaipan upishata-kidan pakamichan danoma karikaonan karinainao ati. Ipai pishatainao ukamichan kakudan powaa iti. ");
INSERT INTO wapNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Phariseenao naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, Jerusalem ikiꞌo ĩwaꞌatin, kaawan Jesus idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ĩtukapa pabiꞌi kida Jesus tominapa-kidaniinao, aonaa ĩchikaan pakaꞌu paaroopan uaꞌii pakakinaorinaa kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Phariseenao naꞌiki ipai baꞌorainao Jewnao taapa zii pakawan kakinaorii kotuaꞌoraz ĩdokozu-daunnao taapan, aonaa ĩaroopan machikaaka-daun pakaꞌu kakinaorii kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ĩtorian dono aimaakan, aonaꞌo nii ĩnikan sariaapazu, mazan kiwiin ĩchikaan niizu. Naꞌapain iriba ĩtaapan baꞌoran kakinaorii kida, wuru kawanuꞌu ĩchikaakapauzon kaduzuz pakoopon kida, kaꞌuz kin kida, boon kida, aroapa-kizai baara kida kapam.) ");
INSERT INTO wapNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Uruu idi Phariseenao naꞌiki tiichaapauzonao Moses kakinaori dauꞌu pishaan Jesus, “Kanom niꞌo aonaa putominapa-kidaniinao taapan kakinaorii wadokozu-daunnao diꞌikiꞌoraz, mazan ĩaroopan aonaa ĩchikaan pakaꞌu wakakinaorinaa kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus dakoꞌatin ĩdyaun, “Mishiꞌo tawuruꞌu Isaiah paradan kiauzonuz unao dauꞌan kotuaꞌa naa! Mishiꞌo wuruꞌu, unao taapinpainao kaimanainao nii kaikiniꞌi, naꞌapa usaadinpan kawan: ‘Diꞌoraz pidannao, ĩtaapan õgaru umanawunuꞌo nii paparadan idaꞌan karikaonan, mazan munapoꞌo ĩtaapan panyukunuu õꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aonaa mishiꞌo mani ĩmanawuntapan õgaru, mazan ĩtaapan pidan tomanii kakinaorii karikaonan, aonaa õkakinaori kida mani!’ ");
INSERT INTO wapNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Unao, aonaa uaipan Tominkaru kakinaori, mazan umishidan pidan tomanii kakinaorii karikaonan.” ");
INSERT INTO wapNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus kian ĩꞌati powaꞌa zii, “Uaitapa mishi udiꞌitinpan aonaa uaipan Tominkaru kakinaori, mazan uaipan utaapan umishidauzonii kaduz kakinaorii paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses kakinaori kian, ‘Pumarainapa pudaru naꞌiki pudaro,’ naꞌiki ‘kanom dakoopaꞌo padaru oo padaro zowii-karu nii.’ ");
INSERT INTO wapNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mazan unao kakinaopan, turuu pidan kian padaru oo padaro ati kaikapaꞌa: ‘Kanom õtaaꞌazooniꞌi naa puꞌati padamata, aonaꞌo nii õtaan puꞌatizu, ushaꞌapanum kauꞌan õtaaniꞌi naazu “Corban” nii (taa-kariwai Tominkaru ati, kiaꞌo wuruꞌu).’ ");
INSERT INTO wapNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Naꞌapaꞌo idaꞌan aonaa utaapadan ukaminkaꞌutan padaru oo padaro. ");
INSERT INTO wapNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Unao, aonaa uizoꞌatin Tominkaru kakinaori, soo utaapaꞌazon pakawan wuruꞌu pidan tomaniaz kida kakinaorii. Naꞌapain iriba kainaꞌa baꞌoran kida naꞌapaꞌo ushaꞌapaapan.” ");
INSERT INTO wapNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Udaunaꞌan Jesus dapadan kasabaꞌukinpainaouz pidannao paꞌidaꞌati, baukapaꞌa naa ukian ĩꞌati, “Uabatapa kaimanaiman, uaitapa kizi naꞌapam õkian. ");
INSERT INTO wapNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kanom pidan nikanii, aonaa uꞌoiidan pidan. Mazan, kanom koditaꞌo pidan nyukunuu iki, uruu paꞌan oiidaꞌoraz pidan. ");
INSERT INTO wapNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pukakinaon an puabataꞌa naa kakinaorii!” ");
INSERT INTO wapNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesus makoꞌokan naa uwaꞌakaꞌakan naa pidannao kasabaꞌukinpainaouz, umorotan kabaun nazo iti. Utominapa-kidaniinao pishaan naa uruu naꞌii, ĩaipan ukowaadan wuruꞌu diꞌitinapa-kinai kidaz kuwai mashaꞌapannaꞌo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesus kian ĩꞌati, “Aonaa zii mooko uaitapan kapam? Kanom pidan nikanii, aonaa uꞌoiidan uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ushaꞌapanum kauꞌan, aonaa umorotan unyukunuu iti, soo utoba nazo iti karikaonan. Udaunaꞌan ukoditaꞌakan niꞌi naa uꞌidiꞌiki.” (Kaikapaꞌo kadakotin-karu idaꞌanaꞌo, Jesus kowaadan ipai shaꞌapaꞌoram wanyukunui turuu unika-kao.) ");
INSERT INTO wapNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Powaꞌa zii ukian, “Kanom koditaꞌo pidan diꞌiki, wuruꞌu oiidaꞌoraz pidan paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ushaꞌapanum kauꞌan kanom koditaꞌo pidan nyukunuu iki, uruu wuruꞌu oiidaꞌoraz pidan diꞌitinpan, ushaꞌapata-kinaa nii oii kidaꞌoraz aimaakan kaikapaꞌoraz kidaꞌa: pidan kaminshuꞌuinpan, pidan koidimikin, pidan zowian baꞌoran pidan, ");
INSERT INTO wapNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pidan baꞌorantapan, pidan mishaꞌorarun, naꞌiki pabiꞌinaaka kidaꞌo oiaꞌo shaꞌapata-kao; wuru kawanuꞌu umariidinauzon, aonaa ukibaꞌazoo-kidan pashaꞌapaapan oii kidaꞌo aimaakan, ukishauzi-shorin, udakoomikin, unaudapa paꞌatadinpan, naꞌiki ĩmashaapan maaitapinaka-daun karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ipai wuruꞌu oii kidaꞌoraz shaꞌapata-kao, pidan nyukunuu ikiꞌo ukoditan naꞌiki uruu kida oiidaꞌo pidan.” ");
INSERT INTO wapNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Udaunaꞌan Jesus makon munapoꞌo amazada diꞌiti, maonapaꞌoraz donoi Tyre Baara antanapu. Umorotan kabaun nazo iti, aonaa uaipan pidannao aitapan panaꞌan, mazan aonaa turuu udizinan. ");
INSERT INTO wapNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Zuna, kainaꞌaꞌo oiaꞌo doronai odani sodi zun idaꞌa, abata Jesus kainaꞌan naꞌapain okaawan Jesus idaꞌati, odazabadinan oawun imiꞌi baara iti. ");
INSERT INTO wapNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wuruꞌu zunaz, Gentile oroo, oshakatan Phoenicia Baara ii Syria iaꞌoraz. Tuukiaꞌo idaꞌan opishaan Jesus, oaipan ukodita-kidan oiaꞌo doronai paudani sodi zun ai. ");
INSERT INTO wapNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mazan Jesus dakoꞌatin oroo, “Wapaa zii kiwiin koraiziannao. Aonaa turuu koraiziannao wanyukunuu taa-kao arimarakanao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Okian, “Mishiꞌo, Naobanai, upuꞌu arimarakanao nikan koraiziannao wanyukunuu unuba miisa waranuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ukauꞌan Jesus kian oꞌati, “Pudakoꞌatin idi õparadan naꞌapa, pukiwaꞌa naa pudapu iti puikodan nii pudani sodi koditaꞌakaꞌa naa oiaꞌo doronai oꞌai!” ");
INSERT INTO wapNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Okiwan padapu iti, oikoda paudani washatinpan bed paawaꞌa, oiaꞌo doronai koditaꞌakaꞌa naa oꞌai. ");
INSERT INTO wapNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Udaunaꞌan Jesus makon Tyre Baara iki, umakon Sidon an atii Galilee Karishiiz iti. Naꞌikiꞌo udobatan maonapa Decapolis Baara an. ");
INSERT INTO wapNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pidannao kaawa-kidan Jesus idaꞌati daonaiora makinaꞌo naꞌiki aonaꞌo maparadanuꞌo kapam. Ĩpishaan Jesus tuukiaꞌo idaꞌan, ĩaipan upishatanuzu pakaꞌu idi. ");
INSERT INTO wapNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Uruꞌu naa Jesus naꞌakanuzu pabaꞌorantin munapo pidannao ai; naꞌii umuudan pakaꞌu shuwu kida ukinao kida diꞌiti, udaunaꞌan usopitan pazaadako, uruu idi upishatan uninoba. ");
INSERT INTO wapNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Udaunaꞌan Jesus awunuupan aokazi iti naꞌiki utoꞌotaꞌakan panizowan naꞌiki ukian, “Effatha.” “Pudaꞌatin,” kiaꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Uruꞌu naa mishi ukinao daꞌatinaꞌakan naꞌiki uninoba kiitinaꞌakan; uruu idi kaimanaꞌa naa uparadaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Udaunaꞌan Jesus kian ipai pidannao ati, “Manaꞌa paꞌi ukowaadaꞌa naa baꞌorainao pidannao ati wuruꞌu.” Ukakinaowan puꞌu ĩdyaun powaꞌan kida padamata, powaꞌa zii manawun ĩkowaadaabiꞌian baokoinao ati udauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ipai abatainaouz udauꞌu, tuukii manawun ĩdiꞌitinpan. Naꞌiki sariapa ĩkian, “Ipai kanom ushaꞌapatanii kida kaiman zii manawun ushaꞌapatanuzu. Ukakinaoda zii makinao-ziiwa naꞌiki ukaparadanuta zii maparadanuꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Masakaudaꞌu uruu daunaꞌan, iribaꞌo pidannao kaawan Jesus idaꞌati koshan. Naꞌapain uruu dono, aonaꞌoraꞌa naa ĩwanyukunuu nii. Uruu idi Jesus dapadan patominapa-kidaniinao paꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ukian ĩꞌati, “Õkashaꞌora-kida, õtukapan wuruꞌu pidannaouz, ĩnaꞌan idi idikinaudaꞌu kamoꞌo naa õtuma naꞌapain aonaa kanomaꞌa naa ĩnikan. ");
INSERT INTO wapNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aonaa turuu õdyuudan ĩdyaun maaroopaka-daun, panaadon ĩmadoronaitan pazamazin idi pamakopa-kizi an, ushaꞌapanum kauꞌan pabiꞌi kida munapoꞌo ĩmashaapan.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Utominapa-kidaniinao pishaan uruu, “Naꞌapam nii dii mooko pidan ikodan wanyukunui daꞌaꞌa, baaraꞌa karikaonan, papaa-kinaa nii ipai wuruꞌu iribaꞌoraz pidannao?” ");
INSERT INTO wapNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Naꞌapaudaꞌum bread kainaꞌa uꞌidaꞌa,” Jesus kian ĩꞌati. “Kainaꞌa 7 bread,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus dyuudan ipai pidannao sakanatan imiꞌi baaraꞌa. Udaunaꞌan uzaamatan bread kidaz, utoriinapa-kidanuzu. “Kaiman,” ukian Tominkaru ati udauꞌan. Udushowanuzu, udaunaꞌan utaanuzu patominapa-kidaniinao ati, ĩnao kiziꞌi naa kataanuzu ipai pidannao kawanaꞌati. Ipai ĩshaꞌapatan padyuuda-kizinao. ");
INSERT INTO wapNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Naꞌaꞌo kapam masakaudaꞌu kopaunao. Utoriinapa-kidanuzu. “Kaiman,” ukian Tominkaru ati udauꞌan. Udaunaꞌan utaan naa kidaz patominapa-kidaniinao ati, ĩnao kizi kataanuzu koshan pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ipai pidannao aroopan abaapa, ikoda mani 4000 pidannao. Jesus tominapa-kidaniinao zawadan 7 dazowan kida wanyukunui waꞌakun. Udaunaꞌan Jesus dyuudan naa pidannao kiwan padapu iti kida. ");
INSERT INTO wapNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sariapa upaidinan kanawa zoꞌiti patominapa-kidaniinao tuma, ĩmakon munapoꞌo wiizai Dalmanutha Baara iti. ");
INSERT INTO wapNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Phariseenao kaawan Jesus idaꞌati. Ĩtiwaa-kidapaꞌazon uruu, uruu idi ĩkian uꞌati, “Puaida waꞌati, naꞌapam turuu pushaꞌapatan umanawun kidaꞌo aimaakan, puaida-kida kizi waꞌati kainaꞌa mishi mishiꞌo Tominkaru maꞌozakan kainaꞌan puꞌidaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mazan Jesus nyukunuu kashaꞌoran, naꞌiki ukian, “Kanom nii mooko utukapaꞌazon umanawun kidaꞌo aimaakan shaꞌapata-kao? Õkowaadan nii uꞌati, aonaa turuu õaidan umanawun kidaꞌo aimaakan uꞌati!” ");
INSERT INTO wapNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Udaunaꞌan uwaꞌakaꞌakan naa ĩdyaun. Upaidinan koshan kanawa zoꞌiti patominapa-kidaniinao tuma, ĩmakon naa karishii baza iti. ");
INSERT INTO wapNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesus tominapa-kidaniinao manyukunuutan panaꞌakan iriba bread kida; ĩnaꞌakapanii baudaꞌapa sodi karikaonan patuma kanawa zoꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus kakinaotan ĩdyaun, “Uzaudin paꞌi Phariseenao yeastin ai naꞌiki Herod yeastin ai kapam.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Uruu idi ĩkian paꞌatiaaka, “Ukian kaikapaꞌa uaitapan idiꞌo aonaa bread nii waꞌidaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus aitapa naꞌapaꞌoram wuruꞌu ĩkianuz. Uruu idi upishaan ĩdyaun, “Kanom nii ukadakoinapa-kidan bread aonaan uꞌidaꞌa? Aonaa mooko uaitapan? Dadaraꞌo mooko manawun uzowau? ");
INSERT INTO wapNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ishaꞌo mooko uawun naꞌiki aonaa ukakinaon? Aonaa mooko uaitapan ");
INSERT INTO wapNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tawuru donoꞌo õdushowauzonuz bakaꞌiaudaꞌu breadnao õpaa-kinaaz 5000 pidannao? Naꞌapaudaꞌum dazowan kida wanyukunui waꞌakun uzawadan naꞌapain?” Utominapa-kidaniinao kian uꞌati, “Naꞌaꞌo shaꞌatii 12 dazowan kida wanyukunui waꞌakun.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Tawuru donoꞌo maniꞌi õdushowauzonuz 7 bread 4000 pidannao ati, naꞌapaudaꞌum dazowan wanyukunui waꞌakun uzawadan naꞌapain?” “7 dazowan shaꞌatii,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Upuꞌu zii, aonaa uaitapan?” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Udaunaꞌan ĩkaawan naa Bethsaida iti. Naꞌiaꞌa naa pidannao kaawa-kidan ishaawun pidan Jesus idaꞌati, tuukiaꞌo idaꞌan ĩaipan upishatanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus zaamatan wuruꞌu ishaawunuz pakaꞌu diꞌiki, unaꞌakaꞌakanuzu munapo wiizai ai. Udaunaꞌan usopitan pazaadako uawun kida diꞌiti, naꞌiki upishatan uawun kida pakaꞌu kida idi. Udaunaꞌan upishaanuzu, “Putukapaꞌa naa aimaakan?” ");
INSERT INTO wapNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Daonaiora awunuudanaan, naꞌiki ukian, “Õtukapa pidannao, mazan õtukapan ĩdyaun ikoda tawuruꞌu atamunnao chiꞌikapan kawanuꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Udaunaꞌan Jesus pishatan powaꞌa zii koshan uawun kida pakaꞌu idi. Uruu uawun kida saabainaꞌakan naa, kaimanaimanaꞌa naa utukapan koshan. ");
INSERT INTO wapNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Udaunaꞌan Jesus dyuudaꞌakan naazu sariapa padapu iti. Ukian kapam uꞌati, “Manaꞌa paꞌi pumakoꞌonaꞌa wiizai iti powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Udaunaꞌan Jesus makon patominapa-kidaniinao tuma wiizai kida diꞌiti, maonapainaouz Caesarea Philippi itinapu. Ĩmakopaanan puꞌu upishautaanan patominapa-kidaniinao, “Naꞌapa dii pidannao kian õdauꞌan?” ");
INSERT INTO wapNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ĩdakoꞌatin uparadan kaikapaꞌa: “Pidannao kian pugaru John Chikaawunuupauzoz, naꞌiki baokoinao kian pugaru prophet Elijah, naꞌiki baokoinao kian pugaru kotuaꞌoraz prophetnao bii ikiꞌo kaawan powaa ati koshan.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Udaunaꞌan upishaan ĩdyaun, “Unao mani. Naꞌapa dii ukian õdauꞌan?” Sariapa Peter dakoꞌatinuzu, “Pugaru Christ.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Udaunaꞌan Jesus kiaꞌakan ĩꞌati, “Manaꞌa paꞌi ukowaadaꞌanaꞌa kanom wuruꞌu õgaruz.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Uruu daunaꞌan Jesus kakuwaapan naa pazowiaꞌazoo-kao dauꞌu. Ukian, “Daonaiora Aokazi Ikiꞌo ubaiaapan nii kashaꞌoraꞌo manawun. Kazowautapainao Jewnao, naꞌiki faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, aonaꞌo nii ĩaipanuzu. Uzowii-kao nii kapam, mazan idikinaudaꞌu kamoo daunaꞌan ukadishitan nii powaa iti koshan.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus kakuwaapan idi kaimanaiman manawun ĩꞌati, Peter dapadanuzu panaꞌitinapu naꞌiki utoꞌorauanuz. ");
INSERT INTO wapNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sariapa Jesus tanawatinan naꞌiki uawunuupan baꞌoran patominapa-kidaniinao diꞌiti, naꞌiki sariapa utoꞌorauan Peter. Ukian uꞌati, “Pumako õꞌai, Satan. Aonaa pudiꞌitinpan Tominkaru diꞌitinpan kawan, mazan pudiꞌitinpan pidan diꞌitinpan kawanuꞌo karikaonan.” ");
INSERT INTO wapNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Udaunaꞌan Jesus dapadan iribainaouz pidannao naꞌiki patominapa-kidaniinao paꞌidaꞌati. Ukian ĩꞌati, “Kanom daꞌanaꞌazoꞌo õgaru, marii umarinaꞌatan panaudapanii pashaꞌapaapan, naꞌiki unaꞌakan pacrossannaa, naꞌiki udaꞌanan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kanom kazannaataꞌazoꞌo pananaa, uwaziwadan niizu; mazan kanom waziwadaꞌo pananaa õdikin ii, naꞌiki Kaimanaꞌo Kuwai dikin ii, mishiꞌo nii uikodan karikaonanuꞌo kakupa-karu paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aonaa kanom pidan ikodan uzaamatan an ipai aimaakan imiꞌi baara an kidaꞌo, uwaziwainan puꞌu karikaonanuꞌo kakupa-karu ai. ");
INSERT INTO wapNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Oo kainaꞌa shaꞌa aimaakan powaꞌaꞌo uaiapa-kao karikaonanuꞌo kakupa-karu ai? ");
INSERT INTO wapNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Naꞌiaꞌoram pidan kibaꞌazoo-kidaꞌo padaꞌanan õgaru, naꞌiki pakakuwaapan õkakinaori kida dauꞌu wunao atiꞌi, oiainaouz naꞌiki mamishida-kainaouz; naꞌapaꞌo nii kapam Daonaiora Aokazi Ikiꞌo kibaꞌazoo-kidan uruu, ukaawan dono udaru umanawunun tuma naꞌiki kaimanainao Angelnao tuma.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Udaunaꞌan ukian, “Õkowaadan nii mishiꞌo uꞌati, pabiꞌi kida unao kaidaꞌaꞌa, aonaꞌo nii zii umawakan utukapan uaꞌii Tominkaru Naobanai-tinan kamoon kaawan umanawunuꞌo idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aizii 7 kamoo daunaꞌan Jesus naꞌakan patuma, Peter, James naꞌiki John dokoaꞌo midukuo paawa iti. Naꞌii ĩnaꞌian naꞌapaudaꞌu sodi karikaonan. Utominapa-kidaniinao awun zaꞌa upanaꞌadinaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ukamichan tanawatinan wiziꞌi naꞌiki baraka, ubarakan powaꞌa zii ipai pidannao chikaapauzonao chikaan nii ai. ");
INSERT INTO wapNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Udaunaꞌan ĩtukapa Elijah, Moses tuma, kadakotinan Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter kian Jesus ati, “Tiichaa, kaimanaꞌo wuruꞌu wanaꞌanuz daꞌaꞌa. Turuu watoman idikinaudaꞌu kabaunnao sodi kida, baudaꞌapa puꞌati, baꞌoran Moses ati naꞌiki baudaꞌapa Elijah ati.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tuukii Peter tarian baokoinao tuma, aonaa uaitapanaatan naꞌapam pakiaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Udaunaꞌan ishaꞌiz kaawan udikindaꞌakan naa ĩdyaun, naꞌiki parada-karu kian ishaꞌiz bii iki, “Diꞌoraꞌa õdani õmarainapanii, uabata naꞌapam ukian!” ");
INSERT INTO wapNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ĩawunuudanaaꞌakan kadimanaꞌo idaꞌan, aonaꞌa naa baꞌoran pidannao nii ĩtuma, soo Jesus karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ĩtokapaanan puꞌaꞌa naa midukuo iki, Jesus kian ĩꞌati, “Manaꞌa paꞌi ukowaadaꞌanaꞌa wuruꞌu utukapaniaz, atii Daonaiora Aokazi Ikiꞌo kadishitan daunaꞌan pamawaka-kizi iki.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ĩmishida uparadan, mazan paꞌatiaaka ĩpishautaakapaanan naꞌapaꞌoram atiꞌo wuruꞌu ukianuz, “ukadishitan nii pamawaka-kizi iki,” kiaꞌoraz, ĩaipan paaitapanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Uruu daunaꞌan ĩpishaan Jesus, “Kanom niꞌo tiichaapauzonao Moses kakinaori dauꞌu kian, ‘Elijahꞌo nii waꞌati kiwiin.’”? ");
INSERT INTO wapNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ukian ĩꞌati, “Elijahꞌo nii mishi waꞌati kiwiin uminziiwataꞌanan ipai aimaakan. Naꞌapa kotuaꞌo usaadauzo-kao Tominkaru Paradan idaꞌa Daonaiora Aokazi Ikiꞌo dauꞌan, upatakaꞌuta-kao nii tuukii naꞌiki aonaꞌo nii uaiapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Õkowaadan nii uꞌati, mishi, Elijah kaawankaꞌa naa naꞌiki pidannao patakaꞌutauzonii uruu, naꞌapa usaadinpauzon kawanaꞌati Kaarita idaꞌa kotuaꞌa naa.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Uruu daunaꞌan ĩkaawan naa powaa ati baokoinao tominapa-kida-kariwainao idaꞌati, ĩtukapa iriba pidannao kasabaꞌukinpan ĩtuma. Naꞌaꞌo kapam tiichaapauzonao Moses kakinaori dauꞌu kadakotinan ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iribainao pidannao tukapan idi Jesus waꞌatin, tuukii ĩkonaukiaꞌakan, naꞌiki ĩdimaꞌakan uꞌidiꞌiti, ĩdapaapan naa uruu kaiman kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus pishaan patominapa-kidaniinao, “Kanom dauꞌanaꞌo ukadakoinpan wunao tumaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Baudaꞌapa pidan tunarunao dakoꞌatin uparadan iribaꞌo pidannao bii iki. Ukian, “Tiichaa, kainaꞌa õnaꞌakan õdani daonaiora puꞌidaꞌati. Kainaꞌa oiaꞌo doronai uꞌidaꞌa, naꞌiki aonaa ukaparadanun. ");
INSERT INTO wapNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Naꞌapainim oiaꞌo doronai tuukiidaꞌakan an uruu, ukabootaꞌakan nii uruu imiꞌi baara iti, udaunaꞌan bozowaꞌo koditan udako iki, ukuzowaꞌakan paudako kida, udaunaꞌan udadaraꞌakan, dadara, dadara. Õpishaanii padamata putominapa-kidaniinao, õaipan ĩkodita-kidan wuruꞌu oiaꞌo doronaiz uꞌai, mazan aonaa ĩturuan.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus kian, “Naꞌapa dii aonaa zii umishidan? Kotuaꞌikiꞌi naa õmashaapan utuma? Kotuaꞌikiꞌi naa õnaꞌan õbaiatinan utuma? Punaꞌaka naꞌiki wuruꞌu daonaioraz õꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Uruu idi ĩnaꞌakan naa uruu Jesus idaꞌati. Aizii oiaꞌo doronai tukapaꞌakan idi Jesus, sariapa udorauta-kidan naꞌiki uziiaꞌakan wuruꞌu daonaioraz. Uwazainan naa naꞌa imiꞌi baaraꞌa, udako bozowaꞌakan naa kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus pishaan daonaiora daru, “Naꞌapam dii ukotuaꞌikin naa pudani kaikapanuꞌu?” Daonaiora daru kian, “Kotuꞌu uduusodin iki. ");
INSERT INTO wapNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Panaadon kida, maonapa daꞌi oiaꞌo doronai zowiinuzu ukabootan idaꞌan uruu tikazi diꞌiti naꞌiki wunu baoko iti. Pukamunan-kida shoman waunao, naꞌiki pukaminkaꞌuta waunao, puturuan an pukaminkaꞌutan!” ");
INSERT INTO wapNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus kian uꞌati, “Kanom nii pukian ‘puturuan an pukaminkaꞌutan’? Ipai aimaakan shaꞌapan nii pidan ati, umishidan an.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Daonaiora daru kian diiwaꞌo idaꞌan, “Õgaru, õmishida padamata, mazan õaipan pukaminkaꞌutan õgaru, õmishida kizi kaimanaiman manawun.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus tukapan idi iribaꞌa naa pidannao kasabaꞌukinan padazaba ati, ukian oiaꞌo doronai ati, “Makinaꞌo naꞌiki maparadanuꞌo doronai, õaipan pukoditan wuru diꞌikiꞌi daonaioraz, aonaa õaipan pumorotan uꞌidiꞌiti powaꞌa!” ");
INSERT INTO wapNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Uruu oiaꞌo doronai kadakoꞌokan, uziiautapaꞌakan daonaiora, udaunaꞌan ukoditaꞌakan naa uꞌai. Mawakaꞌo kawanuꞌo daonaiora tukapa-kao, naꞌiki ipai pidan kian, “Ei, umawakan!” ");
INSERT INTO wapNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mazan Jesus zaamatan uruu pakaꞌu diꞌiki, ukadishita-kidan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Uruu daunaꞌan Jesus makon umorotan pasookapa-kizi kabaun nazo iti patominapa-kidaniinao tuma, naꞌii ĩnaꞌian naꞌapaudaꞌu sodi karikaonan. Ĩpishaan Jesus, “Kanom niꞌo aonaa waturuan wakodita-kidan oiaꞌo doronai?” ");
INSERT INTO wapNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus dakoꞌatin ĩdyaun, “Soo toriinapa-karu idaꞌan turuu naꞌapainao oiaꞌo doronainao kodita-kida-kao.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Uruu daunaꞌan Jesus makon patominapa-kidaniinao tuma, ĩmakon Galilee Baara an. Aonaa Jesus aipan pidannao aitapan naꞌiam paugaru, ");
INSERT INTO wapNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","utominapatin-kidaꞌazon idi patominapa-kidaniinao. Ukian ĩꞌati, “Daonaiora Aokazi Ikiꞌo kaakapaa-kao nii pidannao ati, ĩnaouꞌu nii zowii uruu. Mazan idikinaudaꞌu kamoo daunaꞌan, ukadishitan nii powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aonaa ĩaitapanaatan naꞌapaꞌoram atiꞌo wuruꞌu ukianuz, naꞌiki ĩtarii papishaanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Naꞌapain ĩkaawan Capernaum iti, ĩmorotan kabaun nazo iti. Naꞌiaꞌa naa Jesus pishaan ĩdyaun. Ukian ĩꞌati, “Kanom dauꞌanaꞌo ukadakotinan dunapota?” ");
INSERT INTO wapNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mazan aonaa ĩdakoꞌatin uparadan, ushaꞌapanum kauꞌan dunapota ĩkadakotinaanan idi paꞌatiaaka, kanom tuubaruꞌo nii manawun dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Udaunaꞌan Jesus sakanatan naꞌiki sariapa udapadan 12 patominapa-kidaniinao. Ukian ĩꞌati, “Kanom aipinaꞌo kiwiiniꞌo nii, marii uruu dawuꞌitintinan naꞌiki poitorui nii kapam ipai pidannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Udaunaꞌan ukadishita-kidan koraidaonaa ĩkanaapuꞌu, udokobatanuzu naꞌiki sariapa ukian ĩꞌati, ");
INSERT INTO wapNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kanom dapaapaꞌo baudaꞌapa kaikapa sodiꞌo koraidaonaa õꞌuu idaꞌan, udapaapan õgaru wuruꞌu. Naꞌiki kanom dapaapaꞌo õgaru, udapaapan wuruꞌu dyuudaꞌoraz õgaru kapam.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John kian uꞌati, “Tiichaa, watukapanii pidan kodita-kidan oiaꞌo doronainao puꞌuu idaꞌan, naꞌiki wamashaata uruu, ushaꞌapanum kauꞌan aonaa uzaamatinpan waꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Aonaa umashaataꞌanaꞌazu,” Jesus kian ĩꞌati. “Pidan shaꞌapataꞌo umanawun kidaꞌo aimaakan õꞌuu idaꞌan, aonaꞌo nii uparadan dikaudan õdauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kanom aonaa unyukunuu oian waꞌati, uruu waunao idaꞌantanpuꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Õkowaadan nii uꞌati naꞌiaꞌoram pidan taaꞌo wunu tuza-karu nii õpidanannao ati õꞌuu idaꞌan, naꞌiki uaitapan idi ĩnao zaamatinpan õꞌidiꞌiti, taa-kao nii uwinipinaa uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Aizii pidan dyuudan an wunao kawan sodi kidainao shaꞌapatan oiaꞌo, naꞌiki aonaa utaapadan ĩmishidan õgaru, kichanaꞌiki-kiaꞌo manawun wuruꞌu pidan shaꞌapataniaz, wuru aiaꞌa udaruꞌo boodapa-kinai kuba sukuruuta-kaoaz ukanau kaduꞌiki. Udaunaꞌan ukaboota-kao paran baoko iti. ");
INSERT INTO wapNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Aizii õkowaadan uꞌati, kaawaꞌa naa wuruꞌu Elijah, mazan aonaa pidannao aitapanaatanuzu. Ukauꞌan pukaꞌu oii-kidan an pugaru, pudukutazu! Kaimanaꞌo nii zii pumakon kakupa-karu diꞌiti baudaꞌapaꞌo pukaꞌu tuma, putaapan ai dyaꞌutam ĩdyaun, udaunaꞌan pukaboota-kao nii Tuubaruꞌo Tikazi wuꞌiti, aonaꞌoraz umakadauzon. ");
INSERT INTO wapNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","47","Baudaꞌapaꞌo pukidiba oii-kidan an pugaru, pudukutazu! Kaimanaꞌo nii zii pumakon kakupa-karu diꞌiti baudaꞌapaꞌo pukidiba tuma, putaapan ai dyaꞌutam ĩdyaun, udaunaꞌan pukaboota-kao nii Tuubaruꞌo Tikazi wuꞌiti. Baudaꞌapaꞌo puawun oii-kidan an pugaru, pusoꞌotazu! Kaimanaꞌo nii zii pumakon kakupa-karu diꞌiti baudaꞌapaꞌo puawun tuma, putaapan ai dyaꞌutam ĩdyaun, udaunaꞌan pukaboota-kao nii Tuubaruꞌo Tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Naꞌii tarabaro dainao nikapaꞌoraz pidan nanaa, aonaꞌo nii ĩmawakauzon. Naꞌiki wuruꞌu tikaziz aonaa naꞌapainim nii umakada-kao.’ ");
INSERT INTO wapNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Naꞌapa wanyukunui kuzubada-kao kawan duwu idi, naꞌapa pidannao maꞌozakadinan ubaiainpan an kai kaimanaꞌo dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kaimanaꞌo wuruꞌu duwuz, mazan duwu manaun anaꞌa naa, naꞌapam nii ukuzubaa-kao powaa iti? Marii duwu kuzubaꞌo kawan unao, umashaapa kizi kaiman uiribannao tuma.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Naꞌikiꞌo Jesus waꞌakan amazada Galilee Baara, umakon Judea Baara an, atii Jordan Waꞌo baza iti. Iriba kida pidannao kaawa-kaawan uꞌidaꞌati koshan, naꞌiki utominapa-kidan ĩdyaun patominapatin-kidauzon kawan daꞌi ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Phariseenao kaawan uꞌidaꞌati ĩtiwaa-kidapaꞌazon uruu. Ĩkian uꞌati, “Pukowaada waꞌati, wakakinaorinaa taapada pidan muudan paudaiaro?” ");
INSERT INTO wapNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus kian ĩꞌati, “Shaꞌapaꞌoram kakinaorii Moses taa uꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ĩkian Jesus ati, “Moses taapadanii pidan saadan muudaaka-karu kaaritannaa, udaunaꞌan turuu umuudan paudaiaro.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus kian ĩꞌati, “Moses saadan wuruꞌu kakinaorii uꞌati unyukunuu dadaran idiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mazan Tominkaru sakadan dono patoman amazada naꞌiki pidan, utoman daonaiora naꞌiki zun. ");
INSERT INTO wapNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Unaꞌapan idi, daonaiora muudinan padaru naꞌiki padaro ai naꞌiki ubaudaꞌapatinan paudaiaro tuma, ");
INSERT INTO wapNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","naꞌiki uruu idi dyaꞌutamainao pidannao baudaꞌapatinan. Ukauꞌan aonaa powaꞌa ĩpanaꞌa-kidan, soo baudaꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kanom Tominkaru baudaꞌapatanii, aonaa turuu pidan muudaaka-kidan.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Udaunaꞌan ĩmorotan kabaun nazo iti koshan, Jesus tominapa-kidaniinao pishaan uruu wuru dauꞌanaꞌa ukadakotin kiziz. ");
INSERT INTO wapNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ukian ĩꞌati, “Pidan muudan dono paudaiaro, udaunaꞌan umazidan baꞌoran zun tuma, oiaꞌo wuruꞌu ushaꞌapataniaz paudaiaro ati ubaꞌorantapan idi. ");
INSERT INTO wapNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Naꞌapa kapam zun muudan dono paudaiaru, udaunaꞌan omazidan baꞌoran daonaiora tuma, oiaꞌo wuruꞌu oshaꞌapataniaz paudaiaru ati obaꞌorantapan idi.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pidannao kaawa-kidan koraiziannao Jesus idaꞌati. Ĩaipan upishatan ĩdyaun. Mazan utominapa-kidaniinao kashadakowauan pidannao. ");
INSERT INTO wapNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus aitapan idi ĩnaꞌapan, sariapa utoꞌorauan patominapa-kidaniinao. Ukian ĩꞌati, “Marii koraiziannao waꞌatin õꞌidaꞌati. Aonaa umashaataꞌanaꞌa ĩdyaun, ushaꞌapanum kauꞌan ĩnao kawanuꞌo wuruꞌu zaamataꞌo niꞌoraz Tominkaru panaobanaa nii. ");
INSERT INTO wapNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Õkowaadanii uꞌati, kanom aonaꞌo uzaamatinan Tominkaru naobanai-tinapa-kizi iti koraidaonaa zaamatan kawanuzu, aonaꞌo nii umorotan naꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Udaunaꞌan udokobatan ipai koraiziannao baudaꞌapa kida, upishatan ĩdyaun pakaꞌu idi, naꞌiki upishaan Tominkaru kaimanan ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus makopaanan puꞌu koshan dunapota, sariapa pidan waꞌatin uꞌidaꞌati zaka-zakaapa. Sariapa ukodoruꞌukan ukanaapu ikinapu, naꞌiki ukian uꞌati, “Kaimanaꞌo Tiichaa, kanom dii õshaꞌapata õikodin-kinaa nii karikaonanuꞌo kakupa-karu?” ");
INSERT INTO wapNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus dakoꞌatinuzu, “Kandii nii pudakotan õgaru kaimanaꞌo nii? Aonaa kanom kaimanaꞌo nii, soo Tominkaru baudaꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Puaitapanii Tominkaru kakinaori kidaz. Manaꞌa puzowiaꞌanaꞌa pidan; manaꞌa pubaꞌorantapaꞌanaꞌa; naꞌiki manaꞌa pukoidapaꞌanaꞌa; manaꞌa pumariidinauzoꞌonaꞌa puiriban dauꞌu; manaꞌa pumariidapaꞌanaꞌa puiriban puzaamata-kinaa nii ushaꞌapauzi; pumarainapa pudaru naꞌiki pudaro.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Tiichaa,” pidan kian uꞌati, “Naꞌapa õmashaapan kotuaꞌikiꞌi naa, õkoraidaonaan iki õizoꞌati wuruꞌu kakinaorii kidaz.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Udaunaꞌan Jesus awunuupan uꞌidiꞌiti unaudapa patukapanuzu. Ukian uꞌati, “Kainaꞌa baudaꞌapaꞌa naa aimaakan pushaꞌapatan nii zii. Aizii pumako, pusellian ipai pushaꞌapauz kida, naꞌiki puraata puikodanii pushaꞌapauz kida idaꞌan, putaaꞌa naa patakaꞌutinainao atiz. Pushaꞌapatin an naꞌapa, pukapuraatanun nii aokazi ii. Udaunaꞌan puwaꞌati õꞌidaꞌati, pudaꞌan kizi õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mazan daonaiora abatan idi unaꞌapan paꞌati, sariapa unyukunuu kashaꞌoraꞌakan, ukiwan manaunam, ukashaꞌapauzin idi manawun. ");
INSERT INTO wapNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus awunuupan patominapa-kidaniinao kawanaꞌati, naꞌiki ukian, “Dadaraꞌo nii kapuraataniinao pidannao morotan Tominkaru naobanai-tinapa-kizi iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sariapa utominapa-kidaniinao diꞌitinpan uparadan dauꞌu. Mazan Jesus kian koshan ĩꞌati, “Õdainao, naꞌapa dii manawun dadara pidan morotan Tominkaru naobanai-tinapa-kizi iti. ");
INSERT INTO wapNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kashaꞌapannaꞌo nii manawun kapuraatanuꞌo pidan morotan Tominkaru naobanai-tinapa-kizi iti, camel podotan ai akosa awun shaawata.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Udaunaꞌan powaꞌa zii ĩdiꞌitinpan, naꞌiki ĩkian uꞌati, “Kanom mooko turuu ukazannaata-kao?” ");
INSERT INTO wapNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus awunuupan ĩꞌidiꞌiti, naꞌiki sariapa udakoꞌatin ĩdyaun. Ukian ĩꞌati, “Pidannao aonaa turuu ĩshaꞌapatan wuruꞌu, soo Tominkaru paꞌan turuu ushaꞌapatan ipai aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Udaunaꞌan Peter kian uꞌati, “Putukapa waunao, wawaꞌakaꞌa naa ipai washaꞌapauz naꞌiki aizii wadaꞌanpan naa pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sariapa Jesus kian, “Mishiꞌo wuruꞌu. Naꞌiaꞌoram pidan waꞌakaꞌo padapu, oo paꞌinawuzunao, padadakoonao, padaro, padaru, paudainao, oo pazakapun õgaru dikin ii, naꞌiki Kaimanaꞌo Kuwai dikin ii, ");
INSERT INTO wapNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","taa-karu nii uꞌati 100 powaꞌa zii kabaun kida, naꞌiki uꞌinawuzunao nii, naꞌiki udadakoonao nii, naꞌiki udaronao nii, naꞌiki udainao nii, naꞌiki uzakapun nii, naꞌiki unaꞌapan puꞌu upatakaꞌuta-kao nii kapam. Naꞌiki diinaꞌitiꞌi uikodinan nii karikaonanuꞌo kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mazan iriba pidannao kiwiiniinao kai, dawuꞌitintinaꞌo nii. Naꞌiki iriba dawuꞌitiiniinao kai, kiwiita-kida-kao nii.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Aizii udaunaꞌan Jesus tominapa-kidaniinao, tuukii ĩdiꞌitinpan udauꞌu, ukiwiitan idi paꞌuaꞌati Jerusalem iti. Naꞌiki naꞌaꞌo baokoinao pidannao, daꞌanpainao ĩdyaun, sariapa ĩtarian kapam. Udaunaꞌan Jesus dapadan koshan 12 patominapa-kidaniinao panaꞌitinapu baokoinao ai. Uruꞌu naa ukakuwaapan naꞌapam nii pashaꞌapata-kao dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ukian ĩꞌati, “Uabata. Aizii wamakon Jerusalem iti, naꞌiaꞌo nii Daonaiora Aokazi Ikiꞌo, kaakapaa-kao nii faadaanao zowaunaanao ati, naꞌiki tiichaapauzonao ati Moses kakinaori dauꞌu. Naꞌiki ĩtaan nii uruu zowii-karu nii, naꞌiki ĩtaan nii uruu Gentilenao kaꞌu iti. ");
INSERT INTO wapNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Uruu idi Gentilenao banikiitan niizu, naꞌiki ĩsopiautapan niizu, naꞌiki ĩbaꞌizian nii uruu. Udaunaꞌan ĩzowian nii uruu. Mazan idikinaudaꞌu kamootan idaꞌa, ukadishitan nii powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Uruu daunaꞌan James naꞌiki John, Zebedee dainao, kaawan Jesus idaꞌati. Ĩkian uꞌati, “Tiichaa, kainaꞌa waaipan pushaꞌapatan aimaakan waꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Kanom dii mooko?” ukian. ");
INSERT INTO wapNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ĩkian uꞌati, “Pusakanatan dono putaba diꞌii punaobanai-tinan dono, pusakanata-kida paꞌi waunao putuma. Baudaꞌapa pudiwaꞌora antanapu, baꞌoran puꞌashabaron antanapu.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus kian ĩꞌati, “Aonaa uaitapan kanom wuruꞌu upishaaniaz. Turuu mooko uaitapan utuzan õtuzaꞌazooniaz baiatin-karu kooponnaa diꞌiki, õgaru kawan? Turuu mooko uaitapan uchikaawunuu-kidinan õchikaawunuuaꞌazoo-kao kawan? ");
INSERT INTO wapNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Turuu,” James naꞌiki John kian. Jesus kian ĩꞌati, “Mishi, utuzan nii wuruꞌu õtuzaꞌazooniaz, naꞌiki uchikaawunuu-kao nii õchikaawunuuaꞌazoo-kao kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mazan aonaa turuu õsakanata-kidan unao õdazabaꞌa, õdiwaꞌora antanapu oo õashabaron antanapu. Soo Tominkaruꞌo nii paꞌan taazu, paminziiwataniinao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aizii 10 Jesus tominapa-kidaniinao abatan idi kaikapaꞌo parada-karuꞌu, sariapa ĩtoꞌoran James naꞌiki John ati. ");
INSERT INTO wapNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Uruu idi Jesus dapadan baokopa ĩdyaun paꞌidaꞌati, ukian ĩꞌati, “Uaitapanii mamishida-kainao Tominkaru, dakotinpaꞌo naobanainao nii, ĩnaudapa pawaranuitapan ipai pidan naꞌiki pamanawun-tinpan idaꞌan ĩkazowautapan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mazan aonaa õaipan unaꞌapan. Naꞌiaꞌoram unao biiꞌi aipaꞌo pamanawunun, marii upoitoruitapa-kidinan ipai baokoinao ati. ");
INSERT INTO wapNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Naꞌiki kanom umanawun-tinpaꞌazoꞌo pairibannao ai, marii upoitoruitapa-kidinan ipai pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Upuꞌu zii Daonaiora Aokazi Ikiꞌo, aonaa uwaꞌatin umanawun-tinpaꞌanan mani, mazan upoitoruitapa-kidinaꞌanan ipai pidan ati, naꞌiki ukazannaataꞌanan pidannao paꞌoian ai umawakan idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus kaawan patominapa-kidaniinao tuma Jericho ati. Udaunaꞌan ĩdobatapan puꞌaꞌa naa naꞌiki, iriba pidannao daꞌanpan ĩdyaun. Kainaꞌa pidan ishaꞌo uawun pishautauzo daꞌi puraata, naꞌa usakanatapan dunapoꞌo, Bartimaeus kiaꞌo uꞌuu. Uruu Timaeus dani. ");
INSERT INTO wapNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Uabatan idi Jesus Nazareth san dobatapan, uruu idi ukadakoꞌokan diiwaꞌo idaꞌan. Ukian, “Jesus, David Takaan-daun! Pukamunan-kida õgaru!” ");
INSERT INTO wapNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Iriba pidannao toꞌorauanuzu ĩaipan umashaadan. Mazan powaꞌa zii manawun ukadakon diiwaꞌo idaꞌan. Ukian, “David Takaan-daun! Pukamunan-kida õgaru!” ");
INSERT INTO wapNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sariapa Jesus kadishitaꞌakan pamakopa-kiziꞌi. Ukian, “Udapada uruu daꞌatiꞌi.” Sariapa ĩkian uꞌati, “Pumaꞌozakada punyukunuu! Pukadishita, udapadan naa pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Uruꞌu naa ukabootaꞌakan pachaakitan, uzakaꞌutaꞌakan, uwaꞌatiꞌikan naa Jesus idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus pishaanuzu, “Kanom puaipan õshaꞌapatan puꞌati?” Ishaawun kian Jesus ati, “Tiichaa, õaipan pusaabaan õawun.” ");
INSERT INTO wapNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus kian uꞌati, “Pukiwaꞌa naa! Pumishidan idi õgaru, puawun saabainan.” Sariapa mishi utukapaꞌakan kaiman, naꞌikiꞌo udaꞌanan naa Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ĩmaonapatapaanan puꞌaꞌa naa Jerusalem iti, wiizai kida Bethphage naꞌiki Bethany paꞌinamun, ĩkaawan Olive Naawa iti. Jesus dyuudan dyaꞌutam patominapa-kidaniinao, ");
INSERT INTO wapNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ukian ĩꞌati, “Umako wiizai upaꞌinamunuꞌo diꞌiti. Ukaawan dono naꞌiti uikodan nii chaakashi dani koꞌidinpan, aonaꞌo zii uzaida-kao. Ubuzuutazu, naꞌiki unaꞌaka uruu daꞌatiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Naꞌiki naꞌiaꞌoram pidan pishaan an unao ushaꞌapatanii dauꞌan, ukii uꞌati, ‘Naobanai aipanuzu, naꞌiki kadimanaꞌo nii udyuudan powaa atiz.’” ");
INSERT INTO wapNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Uruu ĩmakoꞌokan naa ĩikoda chaakashi dani dunapoꞌo, ukoꞌidinpan dobaapa-kizai paniinomizinaa diꞌiki. Ĩbuzuupan puꞌu uzunaa, ");
INSERT INTO wapNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","kadishitapainao maonapa naꞌa kian ĩꞌati, “Kanom nii ubuzuupan chaakashi dani zunaa?” ");
INSERT INTO wapNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ĩdakoꞌatin ĩdyaun naꞌapa Jesus dyuudan kawanaꞌati paugaru, uruu daunaꞌan zii ĩtaapadan ĩnaꞌakanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ĩkaawa-kidan naa chaakashi dani Jesus idaꞌati, ĩmuudan pachaakitan kida ubarau paawa ati, uruu Jesus zaidan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Iriba pidannao kadamaradan pakamichan kida dunapota. Baokoinao dukuan puꞌu anabai kida, pokoridi anaba kawan kidaꞌo, maonapa kidaꞌo dunapo an, ĩmuudan naa dunapota kidaz Jesus uaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pidannao kiwiitapainao Jesus ai, naꞌiki baokoinao udawuꞌitiinao ĩwaꞌatipan kadakoinaanan diiwaꞌo idaꞌan. Ĩkian, “Marii Tominkaru konaukii-kida-kao! Marii Tominkaru kaimanan diꞌoraz Naobanai atiꞌi, kaawaꞌoraz uaipan kawanaꞌati! ");
INSERT INTO wapNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Marii Tominkaru kaimanan wuru atiꞌi King-tinaꞌo niꞌoraz King David wadaun nii. Marii Tominkaru aokazi iaꞌo konaukii-kida-kao!” ");
INSERT INTO wapNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus kaawan daunaꞌan Jerusalem iti, umorotan Tominkaru Dapu iti, uawunuutan ipai aimaakan kida. Mazan wachuupun idiꞌi naa ukiwan powaa iti Bethany iti patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Baꞌoran kamoo, ĩwaꞌatipan puꞌu powaa ati Bethany iki Jerusalem ati, Jesus zamazin naa. ");
INSERT INTO wapNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Munapo zii utukapan fig kadunaa kaanabaꞌo. Uruu idi umakon naꞌiti utukapaꞌazon kaaka maniz. Mazan ukaawan dono naꞌiti, aonaa uꞌaka nii, soo uanaba paꞌidiwaru. Ushaꞌapanum kauꞌan aonaa ukaakapauzon donoꞌo zii mani wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesus kian fig kadunaa ati, “Aonaꞌo nii puꞌaka dizoowauzo-kao powaꞌa!” Utominapa-kidaniinao abatanii wuruꞌu unaꞌapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ĩkaawan donoꞌo naa Jerusalem iti, Jesus makon Tominkaru Dapu iti, naꞌiki uwaataabiꞌian ipai toriipainao kida uzainao, naꞌiki selliipainao kida uzainao taa-kariwai niꞌo Tominkaru ati. Ipai udorau-kidan shakataaka-kidauzonao puraata miisan kida, naꞌiki ipai selliipainao wakokoonao taba kida, ");
INSERT INTO wapNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","naꞌiki aonaa utaapadan pidannao dobata-kidan patoriinii kida Tominkaru Dapu baara an. ");
INSERT INTO wapNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uruu daunaꞌan ukakinaotan pidannao, “Tominkaru Paradan saadinpaꞌo kian: ‘Õdapu dakota-kao nii ipai pidannao toriinapa-kizi dapunaa nii.’ Mazan unao ukaiwaapanuzu koidimikinao dizinapa-kizi nii.” ");
INSERT INTO wapNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Faadaanao zowaunaanao naꞌiki tiichaapauzonao Moses kakinaori dauꞌu abatan idi kaikapaꞌoraꞌa, ĩtiwaan paikodan pazowii-kinaa nii Jesus. Ushaꞌapanum kauꞌan ĩtarian Jesus ai, ĩtukapan idi tuukii manawun ipai pidannao diꞌitinpan ukakinaopan dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wachuupun idiꞌi naa Jesus kiwan donoi iki patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chaapiꞌiki baꞌoran kamoo, ĩdobatapan puꞌu dunapota koshan, ĩtukapa wuruꞌu fig kadunaa mawakaꞌakaꞌa naa atii paoroda iti. ");
INSERT INTO wapNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter nyukunuuꞌaka naꞌapam Jesus kiauzon daꞌi, uruu idi ukian, “Tiichaa! Putukapa, puparada kiziz fig kadunaa mawakaꞌakaꞌa naa.” ");
INSERT INTO wapNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus kian patominapa-kidaniinao ati, “Umishida Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mishi õkowaadan nii uꞌati, shaꞌapaꞌoram pidan turuu udyuudan naawazi soꞌotinan naꞌiki ukabootinan paran baoko iti, pamishidan idaꞌan. Aonaan an umishidan, aonaꞌo nii ushaꞌapan uaipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ukauꞌan, õkian ipai unao ati, ipai kanom upishaanii utoriinpan idaꞌan, taa-kao nii uꞌati. Soo umishidan idaꞌan karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Naꞌiki naꞌapainim ukadishitan utoriinpan dono, umarinaꞌata unyukunuu oian baꞌoran pidan ati; naꞌapaꞌo nii udaru Tominkaru aokazi iaꞌoraz marinaꞌatan ipai uꞌoian kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mazan aonaan an umarinaꞌatan oii kidaꞌo pidannao shaꞌapatanii uꞌati, aonaꞌo nii unao Daru marinaꞌatan uꞌoian kida.” ");
INSERT INTO wapNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ĩkaawan koshan Jerusalem ati, Jesus chiꞌikaꞌanpan puꞌu Tominkaru Dapu ii, faadaa zowaunaanao, tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki Jewnao zowaunaanao kaawan uꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Naꞌiki ĩpishaanuzu, “Kanom dyuudanii pushaꞌapatan ipai wuruꞌu aimaakan kidaz? Oo kanom taapadanii pushaꞌapatan ipai wuru kidaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus dakoꞌatin ĩdyaun, “Õpishaan nii baudaꞌapa aimaakan karikaonan uꞌai, naꞌiki udakoꞌatin an õgaru, õkowaadan nii uꞌati kanom aipan atiꞌo õshaꞌapatan wuru kidaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ukowaada õꞌati, naꞌikiꞌoram dii John chikaawunuupan taa-kao uꞌati: aokazi ikiꞌo oo pidan diꞌikiꞌo?” ");
INSERT INTO wapNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ĩpishautaakapan paꞌatiaaka kida, “Wakian an aokazi ikiꞌo, ukian nii waꞌati, ‘Kanom niꞌo mooko aonaa umishidan uruu?’ ");
INSERT INTO wapNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mazan wakian an pidan diꞌikiꞌo, pidannao toꞌoran nii waꞌati.” (Aonaa ĩkaꞌiitan panaꞌapan, ĩtarian idi pidannao ai, ipai pidannao aitapan idi mishi John Tominkaru prophetin.) ");
INSERT INTO wapNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Uruu idi ĩkian Jesus ati, “Aonaa waaitapan.” Jesus kian ĩꞌati, “Õgaru aonaꞌo nii õkowaadan uꞌati kapam, kanom taanii õshaꞌapata-kinaa ipai aimaakan kida.” ");
INSERT INTO wapNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Udaunaꞌan Jesus paradan ĩꞌati diꞌitinapa-kinai kuwai idaꞌan, “Kainaꞌa daꞌi pidan paowaꞌo grape baawu, ukoraratanuzu, ukichadan kaꞌunaru kuba idaꞌa pasararoo-kizi nii grape uu, naꞌiki utoman dokoaꞌo kabaun watchmantapa-kizai niꞌo. Udaunaꞌan uzaamatan pidannao awunuutapainao nii grape baawu. Uruu umakon naa baꞌoran wiizai iti. ");
INSERT INTO wapNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Grape karaoda-kao donoꞌo naa, udyuudan naa baudaꞌapa papoitoru awunuutapainao grape baawu diꞌiti, paꞌidiwau grape dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mazan naꞌiaꞌa naa awunuutapainao grape baawu zaamatan wuruꞌu poitoruiz, ĩbaꞌizian naa kapamazu, udaunaꞌan ĩdyuudan powaa itizu kanaꞌapan. ");
INSERT INTO wapNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Udaunaꞌan udyuudan naa baꞌoran poitorui ĩꞌidiꞌiti koshan. Awunuutapainao grape baawu baꞌiziinuzu pazowau an kida tuukii, powaꞌa zii manawun kiwiitapaꞌo ai. ");
INSERT INTO wapNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Udaunaꞌan udyuudan naa baꞌoran papoitoru, uruu ĩzowii aka sariapa. Naꞌapa ĩshaꞌapatan baokoinao kida, ĩbaꞌiziautapan ĩdyaun naꞌiki baꞌorainao ĩzowii. ");
INSERT INTO wapNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Baudaꞌapaꞌa naa pidan kainaꞌa dyuuda-karu nii, naobanai dani umarainpaniaz manawun. Dawuꞌitiiniꞌi naa udyuudan baudaꞌapaꞌo paudani daonaiora awunuutapainao grape baawu diꞌiti. ‘Aonaꞌo nii ĩkaꞌiitan pashaꞌapatanuzu,’ ukian. ");
INSERT INTO wapNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Mazan awunuutapainao grape baawu kian, ‘Aizii diꞌi naa kapaoribaꞌo daniꞌi. Kadiman, wazowiazu, wazaamata kizi grape baawu uꞌai waꞌidiwau nii!’ ");
INSERT INTO wapNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Uruꞌu naa ĩzaamataꞌakan naaz, ĩzowian naaz, udaunaꞌan ĩkabootan naa unanaa munapo grape baawu ai.” ");
INSERT INTO wapNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Udaunaꞌan Jesus pishaan pidannao, ukian, “Naꞌapam nii uzauda-kidan kapaoribaꞌo shaꞌapatan ĩdyaun? Ipaiꞌo nii uzowiankan wuruꞌu awunuutapainaouz grape baawu, udaunaꞌan utaan nii baokoinao atiz. ");
INSERT INTO wapNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mishi, unao aitauzoniꞌi naa saada-kariwaiz kida Tominkaru Paradan idaꞌa kaikapaꞌa? ‘Wuruꞌu kuba tomapauzonao kabaun kashadaniaz, madiwautapa-kaꞌoraz ĩtukapan, uruꞌu naa mishiꞌoraiman umanawunuꞌo kuba ipai baꞌoran kubanao ai. ");
INSERT INTO wapNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uruu Tominkaru kaudin-kizi wuruꞌu, umanawunuꞌoraz utukapa-kao.’” ");
INSERT INTO wapNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jewnao naobanaanao aitapa Jesus kadakotinan padauꞌu wuruꞌu ukaiwaanuz diꞌitinapa-kinai kuwai. Uruu idi ĩaipan padamata pazaamatan uruu, mazan ĩtarian iribaꞌo pidannao ai, uruu idi ĩmakon uꞌai ĩwaꞌakaꞌakan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Uruu daunaꞌan Jewnao naobanaanao dyuudan Phariseenao naꞌiki Herod pidanannao Jesus diꞌiti, ĩtiwaa-kidapaꞌananuzu, ĩabataꞌazon uparadan panaꞌitin. ");
INSERT INTO wapNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Uruu ĩkaawan naa ĩkian Jesus ati, “Tiichaa, waaitapanii pugaru mishiꞌo puparadan, aonaa turuu pidan tanawatan pudiꞌitinpan. Umanawun-tinpainao paradan, aonaa punyukunuupan. Mazan mishiꞌo paꞌan pukakinaopan Tominkaru aipan kawanaꞌati. Naꞌapa dii mooko wakakinaorinaa kian? Utaapada wataan tax puraatannaa kida naobanai Caesar ati, oo aonaa?” ");
INSERT INTO wapNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mazan Jesus aitapa ĩzaamikipaꞌazon karikaonan, ukian ĩꞌati, “Kandii nii utiwaa-kidapaꞌazon õgaru? Punaꞌaka õꞌati wiziꞌiꞌo puraata sodi, õtukapa kiziz.” ");
INSERT INTO wapNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sariapa ĩnaꞌakan baudaꞌapa puraata uꞌidaꞌati. Upishaan naa ĩdyaun, “Kanom dikin, oo kanom uu kida diidaꞌaꞌorazuꞌu?” “Naobanai Caesar wuruꞌu,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Uruu idi Jesus kian, “Ukauꞌan utaa naobanai Caesar ati uꞌidiwau, naꞌiki utaa Tominkaru ati uꞌidiwau kapam.” Tuukii manawun ĩdiꞌitinpan Jesus dauꞌu naꞌapain. ");
INSERT INTO wapNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kainaꞌa Sadduceenao, aonaa ĩmishidan pidan kadishita-kida-kao nii pamawaka-kizi iki diinaꞌitiꞌi. Ĩnao kaawan Jesus idaꞌati, ĩpishaanuzu kaikapaꞌa: ");
INSERT INTO wapNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tiichaa, Moses saadanii diꞌoraꞌa kakinaorii waꞌati. ‘Aizii pidan mawakan an, uwaꞌakan paudaiaro maudani-daun, marii pidan mawakaꞌoraz inawuzu mazidan otuma, ĩkaudani kizi mawakaꞌo dani nii.’ ");
INSERT INTO wapNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kainaꞌa 7 inawuzuinao. Kiwiin ĩtuuniz mazidan, mazan aonaa zii puꞌu udaiaro kaudanin umawakan naa. ");
INSERT INTO wapNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Uruu idi uꞌinawuzu udawuꞌitiꞌo zaamatan naꞌiki umazidan paꞌinawuzu daiaro-daun tuma, mazan naꞌapa koshan umawakan, aonaa zii okaudanin puꞌu. Udaunaꞌan baꞌoran uꞌinawuzu mazidan otuma, mazan naꞌapa koshan umawakan, aonaa zii okaudanin puꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Baꞌoran mazidan otuma naꞌapa koshan umawakan, udaunaꞌan baꞌoran, atii ipai uꞌinawuzunao mazidan otuma. Mazan ipai daunuudaꞌu ĩmawakan, naꞌiki aonaa baudaꞌapa ĩnao waꞌakaꞌo nii paudani otuma. Atii baꞌoran dono, omawakan naa kapam wuruꞌu ĩdaiaro daunuz. ");
INSERT INTO wapNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aizii pidannao kadishita-kida-kao dono pamawaka-kizi iki. Naꞌiaꞌoram nii daiaroitapa oroo? Ushaꞌapanum kauꞌan ipai 7 daonaioranao mazidan otuma,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus dakoꞌatin ĩdyaun, ukian, “Pakawan zii mooko aonaa uaitapan! Umaaitapakan idiꞌo saadauzo-kariwaiz Tominkaru Paradan, naꞌiki wuruꞌu Tominkaru maꞌozakanuz. ");
INSERT INTO wapNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mawakainao kadishitan dono kakupa-karu diꞌiti, Angelnao kawanuꞌo nii ĩdyaun aokazi ii. Aonaꞌo nii powaꞌa mazida-karu naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Õkowaadan nii unao ati aizii, mishi mawakainao kadishita-kida-kao nii. Aonaa mooko utukapauzon usaadinpan Moses kaaritan idaꞌa, tikazi tominan donoꞌoraz koꞌoriꞌo kazamakaꞌo diꞌiki? Naꞌapa shaꞌatii usaadinpan Tominkaru paradauzon donoꞌoraz Moses ati, ukianuz, ‘Õgaru Abraham Tominkarun, Isaac Tominkarun, Jacob Tominkarun kapam.’ ");
INSERT INTO wapNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uruu kakupainao Tominkarun, aonaa mawakainao Tominkarun mani. Tuubaruꞌo idaꞌan manawun upozawatapan!” ");
INSERT INTO wapNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kainaꞌa tiichaapauzo Moses kakinaori dauꞌu, uabata wuruꞌu ĩkadakotinanuz. Utukapan idi kaiman Jesus dakoꞌatin wuruꞌu Sadduceenao, sariapa uwaꞌatin Jesus idaꞌati upishaanuzu, “Naꞌiaꞌoram dii umanawunuꞌo manawun kakinaorii ipai baꞌorainao ai?” ");
INSERT INTO wapNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus kian, “Umanawunuꞌo manawun diꞌorazuꞌu, ‘Puabata, Israelitenao! Wuruꞌu Naobanai waTominkarunuz, soo uruu baudaꞌapa, Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pumarainapa tuukii Naobanai wuruꞌu puTominkarunuz ipai punyukunuu iki, ipai pudoronaa ii, ipai pudiꞌitinpan idaꞌan, ipai pumaꞌozakan idaꞌan kapam.’ ");
INSERT INTO wapNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Baꞌoran udawuꞌatiꞌo umanawunuꞌo kakinaorii kaikapaꞌoraꞌa: ‘Pumarainapa baꞌoran pidannao naꞌapa pumarainpan kawan punanaa.’ Aonaa baꞌoran umanawunuꞌo nii manawun kakinaorii wuru kida aiaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tiichaapauzo Moses kakinaori dauꞌu kian Jesus ati, “Kaiman Tiichaa! Mishiꞌo kaiwuruꞌu pukianuz. Uruu mishi baudaꞌapaꞌo Naobanai Tominkaru, aonaa baꞌoran Tominkaru nii. ");
INSERT INTO wapNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Naꞌapaꞌo mishi kaiwuruꞌu. Pumarainapa paꞌi tuukii Tominkaru ipai punyukunuu iki, ipai pudiꞌitinpan idaꞌan, ipai pumaꞌozakan idaꞌan. Marii kizi kapam pumarainpan baꞌoran pidan naꞌapa pumarainpan kawan punanaa. Uruu dyaꞌutamaꞌoraz kakinaorii, powaꞌaꞌo zii umanawunun, pidan taan ai kawaoda-kariwai uzai naꞌiki baꞌoran kida aimaakan taa-kariwaiz Tominkaru atiꞌo ai,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus aitapa kaiman tiichaapauzo Moses kakinaori dauꞌu dakoꞌatin paugaru, uruu idi ukian, “Aonaa pumunapon Tominkaru Naobanai-tinpan ai.” Uruu daunaꞌan ipai baꞌorainao tarian papishautan ai uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus kakinaopan dono Tominkaru Dapu ii, ukian, “Kandii nii mooko tiichaapauzonao Moses kakinaori dauꞌu kian wuruꞌu Christ dyuudaꞌazoo-kariwaiz, David takaan-daunuꞌo nii wuruꞌu uruuz? ");
INSERT INTO wapNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kaimanaꞌo Doronaa idaꞌanaꞌo tawuruꞌu David kiauzonuz kaikapaꞌa: Naobanai Tominkaru kian õNaobanaa ati, ‘Pusakanata daꞌaꞌa õdiwaꞌora antanapu atii õmuudan putarubanao puwaranuꞌu.’ ");
INSERT INTO wapNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“David dakotan puꞌu uruu panaobanaa nii, naꞌapa diꞌi naa mooko udani-daun wuruꞌu uruuz?” Iriba pidannao kasabaꞌukinpainaouz, konaukii ĩabatapan Jesus kuwaa. ");
INSERT INTO wapNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ukian naa koshan ĩꞌati, “Uzaudin paꞌi wunao aiaꞌa tiichaapauzonao Moses kakinaori dauꞌu. Ĩnaudapa pakaiwadapan pachiꞌikapa-kizi kawanaꞌati dawuu zaꞌabaꞌi kidaꞌo kamicha. Naꞌiki ĩaipan pataapa-kao umanawun kidaꞌo pidannao nii kasabaꞌuinapa-kizai ii kida. ");
INSERT INTO wapNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ĩaipan pasakanatan taapa-kariwai umanawun-tinpainao pidannao taba kida idaꞌa synagoguenao ii, naꞌiki ĩsakanataꞌazon kiwiin manawun kidaꞌo tabai idaꞌa aroapa-karu dono. ");
INSERT INTO wapNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mazan upuꞌu ĩpatakaꞌutan zunnao mawakainao ĩdaiarunao, ĩzaamatan idaꞌan ĩshaꞌapauz ĩdapu iki. Uruu daunaꞌan ĩaipan patukapa-kao kaimanainao nii patoriinpan idaꞌan dawuu kida. Naꞌapainao pidannao patakaꞌuta-kao nii tuukii manawun.” ");
INSERT INTO wapNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus sakanatan Tominkaru Dapu ii maonapa puraata taapa-kizinao dazabaꞌa, uawunuutapan ipai pidannao paidan papuraatan unazo iti. Iriba kapuraataniinao taan dobata kida puraata. ");
INSERT INTO wapNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Udaunaꞌan mapuraatan-ziiwa maudaiaruiba taan dyaꞌutam sodi ishaꞌo puraata. Aonaa dobataꞌo mani wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Udapadan patominapa-kidaniinao baokopa paꞌidaꞌati, ukian ĩꞌati, “Õkowaadan nii uꞌati diꞌoraꞌa mapuraatanuꞌo zun taan puraata kinnaa zoꞌiti powaꞌa zii manawun ipai baꞌorainao ai. ");
INSERT INTO wapNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ushaꞌapanum kauꞌan baokoinao taan, aonaa paaiapaniꞌi naa mani puraata, mazan oroo pamapuraatanun puꞌu, ipai otaan pataapanii sodi puraata pamashaapa-kinaa niꞌo padamata.” ");
INSERT INTO wapNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus koditan puꞌaꞌa naa Tominkaru Dapu iki, baudaꞌapa utominapa-kidanii kian uꞌati, “Putukapa Tiichaa! Konaunam mishi kabaun naꞌiki ukorarannaa toma-kao, kaiman mishi ĩtomanuzu udaru kidaꞌo kuba idi!” ");
INSERT INTO wapNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sariapa Jesus kian uꞌati, “Putukapa wuruꞌu udaruꞌoraz kabaun naꞌiki ukorarannaa kidaz? Aonaꞌo nii baudaꞌapa kuba mashaapan pamuuda-kizinaoaꞌa, ipaiꞌo nii ĩkaboobiꞌii-kao kida.” ");
INSERT INTO wapNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uruu daunaꞌan Jesus sakanatapan Olive Naawa ii Tominkaru Dapu paꞌinamun, sariapa Peter, James, John naꞌiki Andrew pishaan uruu pairibannao daidaꞌan, ");
INSERT INTO wapNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Pukowaada waꞌati naꞌapainim nii zii diꞌoraꞌa shaꞌapanuꞌu. Kanomaꞌo nii shaꞌapa, waaitapa-kinaa nii ushaꞌapaꞌazon naa.” ");
INSERT INTO wapNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus kian ĩꞌati, “Uzaudin paꞌi, aonaa utaapadaꞌanaꞌa pidan mariidan unao. ");
INSERT INTO wapNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iriba pidannao kaiwaan nii õꞌuu, ‘Õgaru uruu!’ ĩkian nii, ĩmariidan nii kapam iriba baꞌoran pidannao kida. ");
INSERT INTO wapNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Manaꞌa utariaꞌanaꞌa uabatan dono tarubainao mizaataakapan, naꞌiki uabatan dono kadakotin-karu munapoꞌo tarubainao mizaataakatinan dauꞌu. Naꞌapa kidaꞌo aimaakan shaꞌapan nii, mazan aonaa zii amazada ikodaꞌazon patokon mani wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Wiizai kida mizaataakan nii paꞌatiaaka; donoi kida mizaataakan nii paꞌatiaaka. Kainaꞌaꞌo nii imiꞌi nakainan ipai amazada kawanaꞌati, kainaꞌaꞌo nii zamazi-karu kida kapam. Mazan baiatin-karu kida sakadinan zii karikaonan wuruꞌu. Shakataꞌazoꞌo koraidaonaa kaziwan sakadinan kawanuꞌu zii wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ukauꞌan uzaudinpaꞌa naa paꞌi. Ushaꞌapanum kauꞌan uzaamata-kao nii, naꞌiki unaꞌaka-kao nii kootowapa-kizai iti. Ubaꞌizii-kao nii synagogue ii kida; ukadishitan nii kazowautapainao wiizai kida naꞌiki kingnao kanaapu ati õgaru dikin ii; ukowaada kizi kapam Kaimanaꞌo Kuwai õdauꞌanaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mazan amazada tokon kaawan uaꞌii, marii kizi kiwiin Kaimanaꞌo Kuwai kowaada-kao ipai wiizai kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Aizii uzaamata-kao dono, naꞌiki ukootowapa-kida-kao dono, manaꞌa udiꞌitinpaꞌanaꞌa upishaa-kao uaꞌii naꞌapam nii ukian. Mazan upishaa-kao donoꞌo naa, ukowaadaꞌaka kanom dyuuda-kariwai ukowaadan. Ushaꞌapanum kauꞌan aonaa unaouꞌo nii mani parada, mazan Kaimanaꞌo Doronaa taan nii uaitapa-kinaa nii naꞌapam nii ukian. ");
INSERT INTO wapNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Uruu dono pidannao zowii-kidan nii paꞌinawuzunao. Daruinao naꞌapaꞌo nii ĩzowii-kidan paudainao. Daniinao kashadapan nii padarunao naꞌiki padaronao, naꞌiki ĩzowii-kidan nii ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ipaiꞌo nii pidannao toꞌora-kizaitapan unao õgaru dikin ii. Mazan kanom tuudaꞌo ipai wuru kidaꞌa atii utokon iti, kazannaata-karu nii uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mazan utukapan donoꞌo naa kachamaꞌidiikiaꞌo aimaakan muuda-kao aonaa uaiapa-kizinaouꞌu mani, naꞌiki umanaꞌidii-kidan amazada pidan ai.” (Marii awunuutapaꞌo kaarita diꞌitapan naꞌapaꞌoram saada-kariwaiz.) “Ukauꞌan marii mashaapainao Judea Baara ii kidoopan naa midukuo kida iti. ");
INSERT INTO wapNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pidan sookapaꞌo paniba ii, marii kizi aonaa umorotan padapu nazo iti powaa iti aimaakan panaꞌakaꞌazoonii dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pidan kaudinaꞌo pazakapun ii, marii kizi aonaa ukiwan padapu iti pachaakitan dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kashaꞌoraꞌo nii manawun aimaakan shaꞌapan kiꞌiwi-ziiwanao ati uruu dono, naꞌiki daroinao biidapainaouz zii ĩdainao ati, uruu kamoon kida kaawan dono. ");
INSERT INTO wapNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Utoriinapa Tominkaru ati aonaa kizi ushaꞌapan amazada wadidiizon dono! ");
INSERT INTO wapNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ushaꞌapanum kauꞌan wuruꞌu kichanaꞌiki-kii kidaꞌoraz aimaakan shaꞌapan dono, powaꞌaꞌo nii zii manawun ukichanaꞌiki-kian aimaakan shaꞌapaꞌo, amazada sakadin-kizi ikiꞌo ai, naꞌiki kaiꞌi aimaakan shaꞌapan ai. Naꞌiki aonaꞌo nii aimaakan shaꞌapan naꞌapa powaꞌa koshan. ");
INSERT INTO wapNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mazan Naobanai awutapadan nii wuruꞌu ushaꞌapan kamoon kidaz, aonaan an mani, aonaꞌo nii baudaꞌapa pidan kakupan. Upidanannao kainaꞌan idiꞌo wuruꞌu uawutapadanuz kamoo kida. ");
INSERT INTO wapNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Uruu dono, naꞌiaꞌoram pidan kian an puꞌati, ‘Putukapa, diꞌi Christ!’ oo ‘Putukapa, kindiꞌii zuꞌu!’ manaꞌa paꞌi pumishidaꞌanaꞌa uruu. Aonaa mishiꞌo mani wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Dakotinpainao Christ nii naꞌiki dakotinpainao prophetnao nii kaawan nii, ĩmariidapaꞌanan pidannao karikaonan. Ĩshaꞌapatan nii umanawun kidaꞌo aimaakan diꞌitinapa-kidaꞌo nii pidan ĩtanawata-kinaa nii Tominkaru pidanannao panaꞌiti, ĩturuan an mazan. ");
INSERT INTO wapNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Uzaudin kizi paꞌi! Õkowaadan uꞌati ipai wuru kidaꞌa, ushaꞌapan uaꞌiaꞌo zii wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Naꞌapain uruu dono kichanaꞌiki-kiaꞌo aimaakan shaꞌapan daunaꞌan, kamoo marutan nii naꞌiki kauzu aonaꞌo nii ukanadan powaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wizinao kida waotaꞌo nii aokazi iki, naꞌiki ipaiꞌo nii aimaakan wuruꞌu doko ii kidaꞌoraz zikadinan. ");
INSERT INTO wapNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Uruu daunaꞌan Daonaiora Aokazi Ikiꞌo aidinan niꞌi naa, uwaꞌatin nii ishaꞌiz bii an, umanawunuꞌo maꞌozaka-karu naꞌiki umanawunuꞌo konaunama-karu idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Udyuudan nii paꞌangelinnao ipai amazada shakaru ii aka, imiꞌi baara anaꞌoraz, ĩkasabaꞌuka kizi ipai Tominkaru zaamatanii papidanannao nii. ");
INSERT INTO wapNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Marii kizi fig kadunaa tominapa-kidan pugaru. Putukapan dono ukadunaa paꞌishizo-dinan naꞌiki paꞌinaꞌo uanaba sodi kida koditan, puaitapa pidan paowinpan kamoo maonapatan wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Naꞌapa kapam kichanaꞌiki-kiaꞌo aimaakan kida shaꞌapan dono, puaitapan nii õkaawaꞌazon kamoon maonapatan naa wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Õkowaadan nii uꞌati aimaakan mishiꞌo, ipaiꞌo nii aimaakan kida shaꞌapan naꞌapa, kaiꞌo pidannao mawakan uaꞌii ipai. ");
INSERT INTO wapNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Aokazi naꞌiki imiꞌi baara mainaabatinan nii, mazan õparadan kida aonaꞌo nii naꞌapainim umainaabatinan. ");
INSERT INTO wapNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Aonaꞌo nii baudaꞌapa pidan aitapan naꞌapainim nii oo naꞌiam nii kamoo wuru shaꞌapanuꞌu, aonaꞌo nii Angelnao aokazi iaꞌo oo Tominkaru Dani aitapan, soo Tominkaruꞌo nii aitapa paꞌanaz. ");
INSERT INTO wapNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Puawunuutapa, puzaudin, ushaꞌapanum kauꞌan aonaꞌo nii puaitapan naꞌapainim nii wuru shaꞌapanuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pidan makon kawanuꞌo padapu iki naꞌiki uwaꞌakan papoitorunao awunuutapaꞌo niizu, ipai ukakaudin-kizitan ĩdyaun, naꞌiki udyuudan taapaꞌo nii paniinom mashaapan zaudinapa. ");
INSERT INTO wapNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Puawunuutapa, ukauꞌan, aonaꞌo nii puaitapan naꞌapainim nii kadapuꞌo kaawan powaa ati, panaadon wachuupunin oo tomun-zikon, oo kuruku kaꞌaranpanin, oo kamoo koditanin. ");
INSERT INTO wapNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ukaawan dono mashaꞌapakiaka, aonaa kizi paꞌi uikodan pudaꞌawupan. ");
INSERT INTO wapNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Naꞌapam õkian uꞌati aizii, õparadan ipai pidan atiꞌo wuruꞌu: ‘Uzaudinapa!’ õkianuz.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Uruu dono dyaꞌutam kamoo baokopainpauzo-karu kamoo kaawan uaꞌii, naꞌapain Jewnao nyukunuitapauzon pakazannaatauzo-kao kamoon, Egypt Baara sannao ai, naꞌiki naꞌapain bread nikauzo-kao mawikiꞌinaꞌo. Faadaanao zowaunaanao naꞌiki tiichaapauzonao Moses kakinaori dauꞌu dawatan naꞌapam kizi pazaamatan Jesus pidannao daidaꞌan, ĩaipan pazowiinuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mazan ĩkian, “Aonaa kizi paꞌi washaꞌapatanuzu baokopainapa-karu dono, panaadon watoꞌorataaka-kidan pidannao paꞌatiaaka naꞌiki waꞌati kapam.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Naꞌapain Bethany iaꞌo Jesus, Simon, kabishopankauzo kichanaꞌiki-kizai bishoi idi dapu ii. Jesus aroapatinan puꞌu, zun morotan onaꞌakapanii moto sodi, kuba idiꞌo utoma-kao, paidaꞌo kaduunuribai kawinipinaꞌo idi, nard kiaꞌo udakota-kao. Odaꞌatan moto sodi, udaunaꞌan oshootan naa wuruꞌu kaduunuribai Jesus zowau diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pabiꞌi kida pidannao naꞌaꞌo toꞌoran, ĩkian paꞌatiaaka, “Kandii niꞌo kaduunuribai wakuda-kao? ");
INSERT INTO wapNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Turuaꞌo padamata usellii-kao dobata 300 wiziꞌi kidaꞌo puraata ai, udaunaꞌan uwinipinaa taa-kao patakaꞌutinainao ati!” Ĩdakoopan kapam oroo wuruꞌu ĩnaꞌapanuz. ");
INSERT INTO wapNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mazan Jesus kian ĩꞌati, “Marinaꞌa oroo! Kanom nii unyukunuitapanuzo? Kaimanaꞌo wuruꞌu oshaꞌapataniaz õꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Karikaonanuꞌo nii patakaꞌutinainao pidannao naꞌan unao tuma, turuaꞌo nii ukaminkaꞌutan ĩdyaun uaipan kawanaꞌati. Mazan õgaru aonaꞌo nii õnaꞌan utuma karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Oshaꞌapatan pashaꞌapataꞌazoonii; oshootan kaduunuribai õmada diꞌiti, ominziiwatan õnanaa õdida-kao uaꞌii. ");
INSERT INTO wapNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aizii mishiꞌo õkian uꞌati, naꞌiam dono Kaimanaꞌo Kuwai kowaada-kao ipai amazada kawanaꞌati, wuruꞌu oshaꞌapataniaz õꞌati kowaada-kao nii onyukunuitapa-kinao nii.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Udaunaꞌan Judas Iscariot, uruu 12 Jesus tominapa-kidaniinao bii ikiꞌo makon faadaanao zowaunaanao diꞌiti, ukaakapaꞌanan Jesus ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ĩabatan idi unaꞌapan, sariapa ĩkonaukian. Naꞌiki ĩkian ĩtaan nii puraata uꞌati. Uruu daunaꞌan udiꞌitinpan naa naꞌapam kizi pakaakapaan Jesus ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Aizii kiwiitapaꞌo kamoo Bread Mawikiꞌinaꞌo Nikauzo-kao Kamoon kida dono, naꞌapain kapam kaznizonao zowiauzo-kao Passover wanyukunuunaa nii. Uruu idi Jesus tominapa-kidaniinao pishaanuzu. Ĩkian uꞌati, “Naꞌiam nii puaipan waminziiwa-kidan Passover wanyukunuunaa?” ");
INSERT INTO wapNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Uruu dono udyuudan dyaꞌutam patominapa-kidaniinao, ukian ĩꞌati, “Umako donoi iti, naꞌii uikodapan nii daonaiora kapowankaꞌo wunu moto zoꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Udaꞌan uruu atii kabaun iti, umorota-kiziz. Naꞌii upishaa kadapuꞌo, naꞌiki ukii paꞌi uꞌati, ‘Watiichaan kian, naꞌiaꞌoram dii kabaun nazoo putaan nii uꞌati, unika-kizi niꞌoraz Passover wanyukunuunaa patominapa-kidaniinao tuma?’ ");
INSERT INTO wapNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Udaunaꞌan kadapuꞌo tukapa-kidan uꞌati udaruꞌo kabaun nazoo naꞌiki dokoaꞌo kapam, minziiwata-kariwaiꞌi naa unazoo aroapa-karu uaꞌii. Naꞌiaꞌa naa paꞌi uminziiwata ipai aimaakan waꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Udaunaꞌan wunaouꞌu dyaꞌutamainaouz makoꞌokan naa donoi iti. Ĩkaawan naꞌiti, naꞌapa mishi ipai aimaakan shaꞌapan Jesus paradan kawanaꞌati. Uruu idi naꞌiaꞌa naa ĩminziiwatan Passover wanyukunuunaa. ");
INSERT INTO wapNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aizii kamoo tipitan daunaꞌan, uruꞌu naa Jesus kaawan 12 patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ĩaroapatinan puꞌaꞌa naa miisa idaꞌa, Jesus kian ĩꞌati, “Mishiꞌo õkian, baudaꞌapa pidan unao bii ikiꞌo aroapatinaꞌo õtuma zaamata-kidan nii õgaru õtarubanao ati.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sariapa ĩmanaunamaꞌakan kida naꞌiki ĩpishaanuzu padawuꞌatiaaka kida. Ĩkian uꞌati, “Aonaa mazan õgaru mani, mishii?” ");
INSERT INTO wapNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sariapa Jesus kian ĩꞌati, “Baudaꞌapa pidan unao bii ikiꞌo, damotaꞌoraz bread patumaaka õtuma. ");
INSERT INTO wapNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Daonaiora Aokazi Ikiꞌo mawakaꞌo nii naꞌapa Tominkaru Paradan saada-kariwaiz kian kawanaꞌati. Mazan kashaꞌoraꞌo nii manawun wuru pidan baiaapanuꞌu zaamata-kidaꞌo niꞌoraz Daonaiora Aokazi Ikiꞌo patarubanao ati. Kaiman zii mani aonaa ushakatauzon.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ĩaroapatinan puꞌu, uzaamatan bread naꞌiki utoriinpan Tominkaru ati udauꞌan. Udaunaꞌan uduꞌuubiꞌian bread naꞌiki utaanuzu ĩkawanaꞌati, naꞌiki ukian ĩꞌati, “Unika, õnanaa wuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Udaunaꞌan uzaamatan koopo kawazoꞌo wine idi, naꞌiki utoriinapa-kidanuz Tominkaru ati. Udaunaꞌan utaanuzu koshan ĩꞌati naꞌiki ipai ĩtuzan koopo diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesus kian, “Diꞌoraꞌa õizain shootaꞌo niꞌoraz iriba pidannao ati, uruu wuruꞌu kainaabataꞌo niꞌoraz mishiꞌo nii Tominkaru shaꞌapatan pashaꞌapataꞌazooniaz pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Õkowaadan uꞌati, aonaꞌo nii powaꞌa õtuzan wine, atii diinaꞌitiꞌo nii zii õtuzan paꞌinaꞌo wine paꞌan Tominkaru Naobanai-tinapa-kizi ii!” ");
INSERT INTO wapNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Uruu daunaꞌan ĩkunuian kunui Tominkaru ati, udaunaꞌan ĩmakon Olive Naawa iti. ");
INSERT INTO wapNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus kian ĩꞌati, “Ipaiꞌo nii uwaꞌakan õgaru, naꞌapa usaadinpan kawan Tominkaru Paradan idaꞌa kaikapaꞌa: ‘Õzowian nii kaznizonao taapiki, naꞌiki ipaiꞌo nii kaznizonao makoodanainan panaꞌiti kida,’ kiaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mazan õkadishita-kida-kao daunaꞌan õmawaka-kizi iki, õmakon nii uꞌuaꞌati Galilee Baara iti.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter kian uꞌati, “Baokoinao mani waꞌakan nii pugaru, mazan õgaru, aonaꞌo nii õwaꞌakan pugaru!” ");
INSERT INTO wapNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus kian Peter ati, “Õkowaadan nii puꞌati, kuruku kaꞌaranpan uaꞌii itamau aizii aiwakaꞌan, idikinauꞌo nii pukian pidannao ati aonaa puaitapan õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Powaꞌa zii Peter maꞌozakadinan, ukian, “Aonaa naꞌapainim nii õkian aonaa õaitapan pugaru, atii õzowii-kao putuma!” Ipai baꞌoran tominapa-kida-kariwainao, naꞌapa kida ĩkian kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Udaunaꞌan ĩkaawan amazada Gethsemane kiaꞌo udakota-kao diꞌiti, naꞌii Jesus kian patominapa-kidaniinao ati, “Usakanatapa zii daꞌaꞌa õtoriinpaꞌanan puꞌu diꞌitanpuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Unaꞌaka Peter, James, naꞌiki John patuma. Udaunaꞌan tuukii ukashaꞌoran, udopian panyukunuu ii. ");
INSERT INTO wapNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ukian ĩꞌati, “Tuukii manawun õnyukunuu kashaꞌoran dikintan õgaru, mawaka-karu diꞌiti manawun õabatanuz. Unaꞌa daꞌaꞌa, upokodapa paꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Masakaudaꞌu umunapon umakoꞌokan ĩꞌai, uwashatinan paawun baara ikinapu, imiꞌi baara iti, naꞌaꞌa naa utoriinpan, aonaa padamata uaipan pabaiaapan patakaꞌutin-karu. ");
INSERT INTO wapNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Paapaa, Õdaru, ipai aimaakan mashaꞌapannaa puꞌati. Turuu pudobata-kidan wuruꞌu õbaiaapaꞌazooniaz õꞌai. Mazan aonaa õaipan kawanaꞌati mani, soo puaipan kawanaꞌati paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Udaunaꞌan ukaawan powaa ati patominapa-kidaniinao idaꞌati, uikodan ĩdyaun daꞌawuꞌu naa. Ukian Peter ati, “Simon, pudaꞌawun wuruꞌu? Aonaa pukaꞌiitan pupokodapan masakaudaꞌu karikaonan?” ");
INSERT INTO wapNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jesus kian ĩꞌati, “Upokodapa naꞌiki utoriinapa aonaa kizi oiaꞌo tiwaa-kidapan unao. Udoronaa minziiwa padamata, mazan unanaa ii aonaa uturuuan.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Udaunaꞌan ukiwan koshan patoriinapa-kizi iti, naꞌapa koshan utoriinpan kiwiitapaꞌo kawan. ");
INSERT INTO wapNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Uruu daunaꞌan ukaawan koshan patominapa-kidaniinao idaꞌati, uikodan ĩdyaun daꞌawuꞌu naa; aonaa ĩkaꞌiitan papokodapan. Naꞌiki aonaa ĩaitapan naꞌapam pakian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ukaawan dono ĩꞌidaꞌati idikinautan idaꞌa, ukian ĩꞌati, “Pakawan zii udaꞌawupan usookapan zii? Turuaꞌa naa! Aizii Daonaiora Aokazi Ikiꞌo kaakapaa-kaoaꞌa naa oiainao pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ukadishitaꞌa naa, wamakoꞌo naa. Utukapa kaawaꞌa naa kaakapaꞌoraz õgaru!” ");
INSERT INTO wapNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus kadakotinan puꞌu zii, Judas kaawaꞌakan naa. Uruu 12 utominapa-kidaniinao bii ikiꞌo. Utuma iriba pidannao kamarian-tinpainao naꞌiki kaꞌutapainao pazowiin kida kaawan. Wunao dyuudaniinaouꞌu faadaanao zowaunaanao, tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki kazowautapainao Jewnao. ");
INSERT INTO wapNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aizii wuruꞌu kaakapaamikitinaꞌoraz kakinaotaniꞌi naa wuruꞌu tarubainaouz. Ukian ĩꞌati, “Pidan õkissitaniaz, uruu wuruꞌu uaipaniaz. Uruu paꞌi uzaamata naꞌiki unaꞌakaꞌa naazu.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas makon sariapa Jesus diꞌiti, ukian uꞌati, “Tiichaa.” Naꞌiki ukissitaꞌakan naazu. ");
INSERT INTO wapNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Uruꞌu naa ĩzaamataꞌakan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mazan baudaꞌapa pidan naꞌaꞌo ukadishitapan soꞌotan pamarian usaꞌukan Umanawunuꞌo Faadaa poitoru tain. ");
INSERT INTO wapNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sariapa Jesus paradan ĩꞌati, ukian, “Kandii nii uwaꞌatin õdauꞌati, unaꞌakan umarian naꞌiki uzowiin kida, uzaamata-kinaa nii õgaru; zowii-miki nii utaapan õgaru? ");
INSERT INTO wapNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ipai kamoo õkakinaopauzon unao Tominkaru Dapu ii, naꞌiki aonaa uzaamatan õgaru. Mazan marii saada-kariwaiz kida Tominkaru Paradan idaꞌaꞌoraz mishiinan.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Udaunaꞌan ipai utominapa-kidaniinao kidoopan, ĩwaꞌakaꞌakan naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Paꞌinaꞌo zii daonaiora daꞌanapatinan Jesus dawuꞌati, aonaꞌo ukaiwadapan kamicha, soo ushibatapan pamada kamicha idin idi karikaonan. Tarubainao tiwaan pazaamatanuzu, ");
INSERT INTO wapNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mazan udimaꞌakan ĩꞌai makamichan-daun, uwaꞌakaꞌakan naa pashibirinaa kamicha idin ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naꞌikiꞌo ĩnaꞌakan Jesus Umanawunuꞌo Faadaa dapu iti. Naꞌii ipai faadaanao zowaunaanao, ipai kazowautapainao Jewnao, naꞌiki ipai tiichaapauzonao Moses kakinaori dauꞌu baokopatinan. ");
INSERT INTO wapNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter naꞌiti umakon udawuꞌati munapo uwaꞌakinpan, udaunaꞌan umorotaꞌakan naa Umanawunuꞌo Faadaa dapu panibazooti iti. Naꞌiaꞌa naa usakanatapan awunuutapainao kabaun tuma uwiichadinpan tikazi diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Uruꞌu naa faadaanao zowaunaanao naꞌiki ipai baꞌorainao kootowapa-kidauzonao pidannao tiwaan paikodan kowaada-karu nii dikaudaꞌo Jesus shaꞌapatan pazowii-kida-kinaa niizu, mazan aonaa ĩikodan. ");
INSERT INTO wapNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iriba pidannao mariidinan Jesus dauꞌu, mazan panaꞌa kida ĩparadan karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Udaunaꞌan baꞌoran pidannao kadishitan ĩmariidinan Jesus dauꞌu, ĩkian, ");
INSERT INTO wapNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Waabatanii ukian kaikapaꞌa: ‘Õkaboobiꞌian nii wuruꞌu Tominkaru Dapuz pidannao tomaniaz, idikinaudaꞌu kamoo daunaꞌan õkadishita-kidan nii baꞌoran, aonaa pidan tomanii mani.’” ");
INSERT INTO wapNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ĩnao kapam panaꞌa kida ĩparadan karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Umanawunuꞌo Faadaa kadishitan ĩkanaapu ati, upishaan Jesus kaikapaꞌa: “Aonaꞌo nii pudakoꞌatin kaiwuruꞌu ĩparadan pudauꞌoraz?” ");
INSERT INTO wapNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mazan Jesus mashaapan mashaa, aonaa uparadan. Powaꞌa koshan Umanawunuꞌo Faadaa pishaan uruu, “Pugaru mishi Christ, Kaimanaꞌo Tominkaru Daniz?” ");
INSERT INTO wapNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus kian, “Mishi õgaru wuruꞌu. Utukapan nii Daonaiora Aokazi Ikiꞌo sakanatan Tominkaru umanawunuꞌoraz diwaꞌora antanapu; utukapan nii kapam uwaꞌatin ishaꞌiz tuma aokazi iki!” ");
INSERT INTO wapNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesus naꞌapan idi, sariapa Umanawunuꞌo Faadaa kuzuutaꞌakan pakamichan patoꞌoran idi, “Aonaꞌa naa waaipan baꞌoran paradan powaꞌa! ");
INSERT INTO wapNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Uabata naꞌapam uwazootapaꞌazon Tominkaru. Ukauꞌan naꞌapam ukian?” Ipai ĩkian, ushaꞌapatan idi naꞌapaꞌoraz oiaꞌo, marii uzowii-kao. ");
INSERT INTO wapNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pabiꞌi kida pidannao naꞌainao sopitan pazaadako Jesus diꞌiti. Ĩshibatan uawun, udaunaꞌan ĩzowitanuzu. Ĩkian uꞌati, “Kanom zowitaꞌoraz pugaru?” Naꞌiki watchmantapainao naꞌakaꞌakan naaz, ĩtaꞌiautapaanan naa uruu kapam. ");
INSERT INTO wapNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter naꞌian puꞌu Umanawunuꞌo Faadaa panibazooti baara ii, baudaꞌapa poitoruiaba kaawan naꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Otukapan dono Peter tanaapatinan tikazi idaꞌa, sariapa oawunuupaꞌakan uꞌati. Okian, “Pugaru naꞌiaꞌo kapam Jesus Nazareth san tuma. Mishii?” ");
INSERT INTO wapNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sariapa umariidinaꞌakan. Ukian oꞌati, “Aonaa õaitapan kanom dauꞌanaꞌo wuruꞌu pukadakotinanuz.” Uruu idi umakon paniinom iti. Uruꞌu naa kuruku kaꞌaranpaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Poitoruiaba tukapan uruu naꞌii, sariapa okian koshan naꞌainao kadishitapan ati, “Mishiꞌo uruu ĩminaudaꞌu!” ");
INSERT INTO wapNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mazan Peter mariidan ĩdyaun koshan. Masakaudaꞌu uruu daunaꞌan kadishitapainao naꞌa pishaan naa Peter koshan. Ĩkian, “Mishiꞌo pugaru ĩminaudaꞌu, pugaru kapam Galilee Baara san.” ");
INSERT INTO wapNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Udaunaꞌan Peter kian, “Naꞌapam õkian mishiꞌo wuruꞌu! Marii Tominkaru patakaꞌutan õgaru õmariidinan an! Õkian, aonaa õaitapan kanom dauꞌanaꞌo wuruꞌu ukadakotinanuz!” ");
INSERT INTO wapNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Uruꞌu naa kuruku kaꞌaranpan naa koshan itamautannaa; sariapa Peter nyukunuuan naꞌapam Jesus kiauzon daꞌi paꞌati, “Kuruku kaꞌaranpan uaꞌii itamau, idikinauꞌo nii pukian aonaa puaitapan õgaru.” Naꞌikiꞌoraꞌa naa uzaadaꞌakan tuukii. ");
INSERT INTO wapNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Chaapiꞌikiiman, faadaanao zowaunaanao baokopatinan kazowautapainao Jewnao tuma, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki ipai kootowapa-kidauzonao pidannao tuma. Ĩnaouꞌu naa baokopatan padiꞌitinpan kadimanaꞌo idaꞌan naꞌapam kizi pashaꞌapatan uruu. Uruu daunaꞌan ĩdodotan Jesus anoba kida chain idi, naꞌikiꞌo ĩnaꞌakan naazu Pilate diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Naꞌiaꞌa naa Pilate pishaanuzu, ukian Jesus ati, “Pugaru mishi Jewnao naobanaa king?” Jesus kian uꞌati, “Naꞌapaꞌo kaiwuruꞌu pukianuz.” ");
INSERT INTO wapNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Udaunaꞌan faadaanao zowaunaanao kian Jesus dauꞌan, “Ushaꞌapatauzonii iriba oii kidaꞌo aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Udaunaꞌan Pilate pishaan koshan Jesus, ukian uꞌati, “Aonaa naꞌapam pukian pukazannaatin-kinaa nii? Puabata naꞌapam ĩparadan kida pudauꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mazan aonaa naꞌapam Jesus kian powaꞌa. Uruu idi Pilate diꞌitinpan tuukii. ");
INSERT INTO wapNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ipai wunu, wuru kaawan donoꞌo baokopainapa-karuz (ĩnyukunuitapauzonuz daꞌi pakazannaatauzo-kao kamoon), Pilate kodita-kidauzonii baudaꞌapa pidan taraa-kizai iki, pidannao aipan kawanaꞌati daꞌi. ");
INSERT INTO wapNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Uruu dono kainaꞌaꞌo pidannao mizaataakapauzonao tiwautauzo pawaatan Romannao pawiizi ai, naꞌiki ĩzowiinii pidannao; uruu idi ĩtaraa-kao. Ĩbiiꞌi kainaꞌa pidan Barabbas kiaꞌo uꞌuu. ");
INSERT INTO wapNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ipai kasabaꞌukinpainao pidannao waꞌatin Pilate kanaapu ati, ĩpishaan uruu ĩaipan ukodita-kidan baudaꞌapa taraapa-kariwai pidan, naꞌapa ushaꞌapatauzonii kawanaꞌati ipai wunu. ");
INSERT INTO wapNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate pishaan ĩnao, “Uaiapa shaꞌa õmuudan naꞌiki õkodita-kidan wuruꞌu Jewnao naobanaaz?” ");
INSERT INTO wapNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Uaitapan idiꞌo wuruꞌu faadaanao zowaunaanao kishauzin wuruꞌu ĩkaakapaanuz Jesus uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mazan faadaanao zowaunaanao dyuudan ipai pidannao pishaan Pilate, ĩaipan Barabbas kodita-kida-kao. ");
INSERT INTO wapNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate kian koshan kasabaꞌukinpainao pidannao ati, “Naꞌapam mooko uaipan õshaꞌapatan wuruꞌu Jewnao naobanaa, king ukii kiziz?” ");
INSERT INTO wapNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ipai ĩparadan diiwaꞌo idaꞌan koshan Pilate ati, ĩkian, “Marii utauka-kao Cross diꞌiti!” ");
INSERT INTO wapNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Kanom mooko oiaꞌo nii ushaꞌapatan?” Pilate kian. Powaꞌa zii manawun ĩdiwadan paparadan, ĩkian, “Marii utauka-kao Cross diꞌiti!” ");
INSERT INTO wapNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate aipan idi pakaimandan wuruꞌu iribaꞌoraz pidannao nyukunuu, uruu idi ukodita-kidan naa Barabbas ĩꞌati taraa-kizai iki. Uruu daunaꞌan udyuudan soldyaanao baꞌizian Jesus atii shashota umada, naꞌiki udyuudan naa kapam ĩtaukanuzu Cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naꞌikiꞌo soldyaanao morota-kidan Jesus Romannao dapunaa nazo iti, naꞌii ĩdapadan ipai baokopa baꞌoran soldyaanao. ");
INSERT INTO wapNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ĩkaiwada-kidan wuzaꞌo chaakita Jesus ati, udaunaꞌan ĩtoman kowamai kawanuꞌo kaiwada-karu kadunaa idi, udaunaꞌan ĩmuudan naazu uzowau paawa ati. ");
INSERT INTO wapNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ĩbanikiitan Jesus kaikapaꞌa, ĩkian, “Pugaru King, umanawunuꞌo Jewnao naobanaa!” ");
INSERT INTO wapNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ĩbaꞌiziinuzu pazowau an kida atamun idi, ĩsopiautapanuzu, ĩkodoruꞌukan naꞌiki ĩdawukan ukanaapu ati. ");
INSERT INTO wapNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ĩipaian daunaꞌan pabanikiitan Jesus, ĩsoꞌotan naa wuruꞌu wuza-zaꞌoraz chaakita uꞌai, ĩkaiwada-kidan ukamichan powaa iti uꞌati. Uruu daunaꞌan ĩnaꞌakan naa uruu, ĩtaukaꞌanan naazu cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ĩmakopa-kizi an ĩikodapan pidan Simon kiaꞌo uꞌuu, Cyrene san, uruu Alexander naꞌiki Rufus daru. Soldyaanao dyuudan unaꞌakan Jesus crossannaa. ");
INSERT INTO wapNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ĩnaꞌakan Jesus Golgotha iti, (amazada Pidan-Zowau-Niwaꞌuz-naawa, kiaꞌo wuruꞌu udakota-kao). ");
INSERT INTO wapNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Naꞌiaꞌa naa ĩtiwaan patuza-kidan uꞌati wine, kawikiꞌita-kariwai kibiaꞌo myrrh aiba idi, mazan aonaa Jesus tuzanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Udaunaꞌan ĩtaukan naa Jesus cross diꞌiti. Udaunaꞌan ĩbuutan naa ukamichan pakawanaꞌati kida, ĩmakinaotan makinaonii ĩtukapaꞌazon naꞌiaꞌoram nii kida, baudaꞌapaꞌo pidan zaamatan. ");
INSERT INTO wapNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dokoꞌo zaꞌoraꞌa naa kamoo chaapiꞌiki wuruꞌu ĩtaukanuz Jesus cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kainaꞌa saada-kariwai ĩmanamikitin-kinaa, “Dii wuruꞌu King, Jewnao ati,” kii. ");
INSERT INTO wapNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Naꞌa udazabaꞌa ĩtaukan kapam dyaꞌutam koidimikinao, baudaꞌapa udiwaꞌoran antanapu naꞌiki baꞌoran uwashabaron antanapu. ");
INSERT INTO wapNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kaikapaꞌo idaꞌanaꞌa saada-kariwai kaarita idaꞌaꞌoraz mishiinan, “Oiaꞌo pidan kawanuꞌo utukapa-kao,” kiaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pidannao dobaapainao kida udazaba an banikiitanuzu, ĩwaꞌuan pazowau, “Kashaꞌa!” ĩkian. “Pukian pukaboobiꞌian nii Tominkaru Dapu, udaunaꞌan pukadishita-kidan niizu idikinautan kamoo daunaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aizii putokaꞌa naa pucrossannaa diꞌiki pukazannaatinaꞌa naa puaipan ati!” ");
INSERT INTO wapNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Naꞌapa kapam faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu banikiitan Jesus, ĩkiitaakapan paꞌatiaaka kida, “Ukazannaata baꞌoran pidannao, mazan aonaa turuu ukazannaatinan paaipan ati. ");
INSERT INTO wapNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Watukapa kizi Christ, wuruꞌu king, Israelitenao naobanaaz tokan aizii Cross diꞌiki, uruu idaꞌan kizi wamishidan uruu!” Upuꞌu zii kapam wunao dakoopan uruuꞌu, tauka-kariwainaouz udazabaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sakitapa kamoo diꞌiki, ipai amazada marutaꞌakan, atii daawadata kamoo. ");
INSERT INTO wapNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Udaunaꞌan aka, uruꞌu naa Jesus kadakon diiwaꞌo idaꞌan. Ukian, “Eloi, Eloi, lema sabachthani?” Kaikapaꞌo wuruꞌu ukianuz: “ÕTominkarun, õTominkarun, kanom nii aonaa punyukunuupan õgaru?” ");
INSERT INTO wapNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Baꞌorainao pidannao kadishitapainao udazabaꞌa abata wuruꞌu uparadanuz. Sariapa ĩkian, “Aushaa uabata, udapadan paꞌidaꞌati prophet Elijah.” ");
INSERT INTO wapNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sariapa baudaꞌapa pidan dimaꞌakan, udamotan sponge katamaꞌo riwunii diꞌiti. Udaunaꞌan usawadan naa Jesus dako itiz atamun saba idaꞌan. Sariapa ukian, “Mashaapa zii! Watukapa kizi panaadon Elijah waꞌatin nii utoka-kidaꞌananuzu.” ");
INSERT INTO wapNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Udaunaꞌan Jesus kadakon maꞌozakaꞌo idaꞌan, uruu mawakaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naꞌapain naꞌaꞌo udaruꞌo kamicha mada kazadinpaꞌo Tominkaru Dapu nazo ii, sariapa ukuzuutaꞌakan pazikon an doko iki atii apowa iti. ");
INSERT INTO wapNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Naꞌaꞌo soldyaanao zowaunaa kadishitapan Jesus kanaapuꞌu. Utukapan idi naꞌapam Jesus mawakan, sariapa ukian, “Mishiꞌo mishi Tominkaru Danin wuruꞌu diꞌoraꞌa pidanaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Naꞌaꞌo kapam zunnao munapo zaa ĩawunuutapan. Ĩbii iainao naꞌii Mary, Magdala sanaaba; naꞌiki baꞌoran Mary, oroo James naꞌiki Joseph daro; naꞌiki Salome. ");
INSERT INTO wapNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ĩnao daꞌanapatinainaouz Jesus ukaudinankan donoꞌoraz Galilee Baara ii, naꞌiki ĩnao kaminkaꞌuupauzoz daꞌi uruu. Naꞌiki iriba kapam baokoinao zunnao naꞌii, waꞌatiinao utuma Jerusalem ati. ");
INSERT INTO wapNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wachuupun diꞌitiꞌi naa, uruu dono minziiwatin-karu kamoo kapam wuruꞌu, baꞌoran kamoo tannaa, uruu Sookapa-karu Kamoon. ");
INSERT INTO wapNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kainaꞌa Joseph Arimathea san, naꞌiki uruu umanawunuꞌo nii pidannao taapan, naꞌiki uruu zaudapaꞌo kapam Tominkaru Naobanai-tinan kamoon kaawan. Kamoo tipitan uaꞌii umaꞌozakadaꞌakan panyukunuu naꞌiki umakon, upishaaꞌanan Pilate Jesus nanaa dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sariapa Pilate diꞌitinpan, uabatan idi Jesus mawakaꞌakaꞌa naa. Sariapa udapadan soldyaanao zowaunaa naꞌiki upishaanuzu, ukian uꞌati, “Mawakaꞌakaꞌa naa mishi Jesus?” ");
INSERT INTO wapNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Oo, mawakaꞌakaꞌa naazu,” ukian uꞌati. Uruu idiꞌi naa Pilate taapada Joseph naꞌakan Jesus nanaa. ");
INSERT INTO wapNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Uruu idi Joseph torian naa kawinipinaꞌo kamicha mada, naꞌiki utoka-kidan naa Jesus nanaa. Udaunaꞌan upapidan naazu kamicha mada idi, naꞌiki umuudan naazu kichada-kariwai kuba nazo ii. Udaunaꞌan utarataꞌakan naaz udaruꞌo kuba idi. ");
INSERT INTO wapNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdala sanaaba naꞌiki Mary Joseph daro tukapanii naꞌiaꞌoram Jesus nanaa muuda-kao. ");
INSERT INTO wapNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sookapa-karu Kamoo daunaꞌan, Mary Magdala sanaaba, naꞌiki Mary James daro, naꞌiki Salome torian kaduunuribai ĩkaduunuu-kinaa nii Jesus nanaa. ");
INSERT INTO wapNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Udaunaꞌan chaapiꞌikiiman, Sunday dono kamoo koditanin, uruꞌu naa ĩmakon baaranai iti. ");
INSERT INTO wapNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ĩmakopaanan puꞌu dunapota, ĩpishautaakaanan paꞌatiaaka kida, ĩkian, “Kanomaꞌo nii kiduꞌuka kuba waꞌati paniinom iki?” ");
INSERT INTO wapNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ushaꞌapanum kauꞌan udaruꞌo wuruꞌu kubaz. Udaunaꞌan ĩmaonapatapaanan puꞌaꞌa naa naꞌiti, ĩtukapa wuruꞌu kuba tuuꞌuzuz kidaꞌukaꞌaka-kaoaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ĩmorotanaakan puꞌu kaꞌunaru nazo iti, sariapa ĩtukapan paꞌinaꞌo zii pidan sakanatapan padiwaꞌora antanapu, ukaiwadapanii barakaꞌo kamicha zaꞌabaꞌi, naꞌiki sariapa ĩtarian. ");
INSERT INTO wapNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mazan ukian ĩꞌati, “Manaꞌa utariaꞌanaꞌa. Õaitapa udorotapan Jesus Nazareth ikiꞌoraz, tauka-kariwaiz cross diꞌiti. Uruu kakudaꞌakaꞌa naa, aonaꞌa naa uruu nii daꞌaꞌa. Utukapa, daꞌaꞌa tawuruꞌu umuudauzo-kaoaz. ");
INSERT INTO wapNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Aizii ukowaadaꞌanaꞌa naa diꞌoraꞌa kuwai, Peter naꞌiki baꞌoran utominapa-kidaniinao ati. Ukowaada ĩꞌati kiwiitaꞌo niꞌi naazu Galilee Baara iti. Naꞌiaꞌo nii ĩtukapan uruu tawuru kawanaꞌatiꞌi uparadauzonuz daꞌi ĩꞌati,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Udaunaꞌan ĩkoditaꞌakan baaranai iki ĩdimaꞌakan naa powaa iti. Tuukii ĩtariidinan atii naka-nakaa ĩdyaun, aonaꞌa naa ĩkaꞌiitan pakakuwaapan patarian idi. ");
INSERT INTO wapNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus kadishitan daunaꞌan pamawaka-kizi iki Sunday chaapiꞌiki, kiwiin uaidinan Mary Magdala sanaaba ati; oroo diꞌikiꞌo ukodita-kidauzon daꞌi 7 oiaꞌo doronainao. ");
INSERT INTO wapNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Udaunaꞌan omakon okakuwaapaꞌanan uminaudaꞌuitapaniinao ati, pakawan zii ĩzaadinan pakashaꞌoran idi. ");
INSERT INTO wapNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mary kowaadan naa ĩꞌati patukapan Jesus, kakudaꞌa naa uruu, mazan upuꞌu aonaa ĩmishidan oroo. ");
INSERT INTO wapNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Uruu daunaꞌan, Jesus aidinan dyaꞌutamainao ati, ĩmakopan puꞌu baꞌoran wiizainao sodi kida diꞌiti, mazan aonaa ĩaitapanaatanuzu. ");
INSERT INTO wapNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Naꞌikiꞌo sariapa ĩkiwan powaa iti ĩkakuwaapan baokoinao ati, mazan aonaa ĩmishidan ĩkuwaa. ");
INSERT INTO wapNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Uruu daunaꞌan Jesus aidinan 11 patominapa-kidaniinao ati, ĩaroapatinan puꞌu. Utoꞌorauauzon ĩdyaun ĩmamishidakan naꞌiki ĩdadaradan idi panyukunuu tuukii manawun, aonaan idi ĩmishidan utukapikinao paradan. ");
INSERT INTO wapNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Naꞌapain ukian ĩꞌati, “Umako ipai amazada kawanaꞌati ukakuwaapaꞌan kizi Kaimanaꞌo Kuwai dauꞌu ipai pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kanom mishidaꞌo naꞌiki chikaawunuinaꞌo kazannaata-karu nii; kanom aonaꞌo umishidan patakaꞌuta-kaouꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mishidainao taa-kao nii ĩmaꞌozakan ĩshaꞌapata-kinaa nii umanawun kidaꞌo aimaakan; ĩkodita-kidan nii pidannao ai oiaꞌo doronainao kida õꞌuu idaꞌan; ĩaitapan nii paparadan bakadun parada-karu kida; ");
INSERT INTO wapNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ĩzaamatan an kowazaz oo ĩtuzan an mawaka-kinai riwunii, aonaꞌo nii ĩshaꞌapan; ĩpishatan nii karinainao pakaꞌu idi, kakudaꞌo nii ĩdyaun.” ");
INSERT INTO wapNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesus ipaian daunaꞌan pakadakotinan ĩꞌati, unaꞌaka-kaoaꞌa naa aokazi iti. Naꞌii usakanatan Tominkaru diwaꞌora antanapu. ");
INSERT INTO wapNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Uruu daunaꞌan tominapa-kida-kariwainao makon naa, ĩkakuwaapaꞌanan naa Kaimanaꞌo Kuwai dauꞌu ipai amazada kawanaꞌati. Uruu dono Naobanai kaudinan idi ĩtuma, mishiꞌi naa mishi ĩshaꞌapatan umanawun kidaꞌo aimaakan pidannao mishida-kinaa nii. Baꞌoran saada-kariwai Mark kaaritan ipain kaikapaꞌa (9-10) Sariapa zunnao makon ĩkowaadaꞌanan kuwai dyuuda-kariwaiz ĩkowaadan, mazan aonaa ĩkowaadan ipaiz. Uruu daunaꞌan Jesus dyuudan patominapa-kidaniinao ipai amazada kawanaꞌati ĩkowaadaꞌan kizi kaimanaꞌo naꞌiki karikaonanuꞌo kuwai, wuruꞌu karikaonanuꞌo kazannaatin-kinai dauaꞌoraz.");
INSERT INTO wapNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Naobanai Theophilus, Kainaꞌa iriba pidannao, saadainao ipai Jesus shaꞌapatanii kida aimaakan dauꞌu, naꞌiki ipai Jesus shaꞌapata-kao dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ĩsaada ipai aimaakan, naꞌapa pakawan waabatan kawan ukowaada-kao utukapikinao diꞌiki, ĩnao tukapainao kidaz ipai aimaakan shaꞌapan usakadin-kizi iki, naꞌiki baꞌorainao diꞌiki, kowaadainao kidaz ipai kaiman kidaꞌo ushaꞌapatanii dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ukauꞌan naobanai Theophilus, õdiꞌitapa kaiman-daun aimaakan wuruꞌu shaꞌapata-kariwai kidaz usakadin-kizi iki, naꞌiki õabata kaiman-daun ipai wuru dauꞌanaꞌa aimaakan kida shaꞌapata-kariwaiz. Uruu idi õaipan õsaadan puꞌatizu kaiman-daun ushaꞌapan kawanaꞌati manawun. Ipai usakadin-kizi iki, atii utokon iti. ");
INSERT INTO wapNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Õsaadan puꞌatizu kaimanaiman, ushaꞌapanum kauꞌan õaipan idi puaitapan kaimanaiman, ipai wuru dauꞌanaꞌa puabatanii kidaz aimaakan shaꞌapan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aizii Herod king-tinpan dono naꞌiki ukazowautapan dono, ipai amazada Judea Baara ii aka. Kainaꞌa faadaa naꞌiaꞌo umashaapan, Zechariah kiaꞌo uꞌuu. Aizii Zechariah dokozu-daunnao, naꞌapa kapam faadaa-tinpauzonao paꞌidiwaru. Kainaꞌa faadaa, Abijah kiaꞌo uꞌuu, uruu tumaꞌo Zechariah dokozu-daunnao kaudinauzon kotuaꞌa naa. Aizii Zechariah daiaro Elizabeth, faadaa-tinpauzonao kapam oiribannao. ");
INSERT INTO wapNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kaiman Zechariah naꞌiki Elizabeth mashaapan Tominkaru awun zaꞌa. Ipai ĩizoꞌatin Tominkaru dyuuza naꞌiki ukakinaori kida. ");
INSERT INTO wapNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mazan aonaa Elizabeth kaudanin, ushaꞌapanum kauꞌan maudanich oroo. Aizii naꞌapain maskonnaouꞌu naa oroo, naꞌiki uruu tunarunaouꞌu naa kapam. ");
INSERT INTO wapNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Baudaꞌapa kamoo Zechariah naꞌiki umin-kaudinannao, wuruꞌu faadaa-tinpainao kidaz zaamata-kao kaudinaꞌo nii Tominkaru Dapu nazo ii. Ushaꞌapanum kauꞌan Abijah idaꞌatanpuinao paꞌidiwaru faadaanao wuruꞌu kaudinaꞌoraz uruu dono. Uruu idi Zechariah naꞌiki umin-kaudinannao shaꞌapataꞌo nii ipai aimaakan, wuruꞌu faadaanao shaꞌapatauzonii kidaz Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aizii faadaanao, kainaꞌa ĩshaꞌapatauzonii aimaakan, patukapa-kinaa nii kanomaꞌo nii aizii kaudin, kawaodaꞌo nii kaduunuꞌo Tominkaru ati. Uruu dono Zechariah zaamata-kao. Uruu idi Zechariah morotan naa Tominkaru Dapu iti ukawaodaꞌanan kaduunuꞌo shanaribai altar paawa iti, Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aizii kaduunuribai kawaodapa-kao puꞌu, pidannao kasabaꞌukinan paniba itinapu, naꞌiki ĩtoriinpan naa kapam. ");
INSERT INTO wapNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Upuꞌaꞌa naa angel, Tominkaru diꞌikiꞌo kaawaꞌakan Zechariah diꞌii. Angel kadishitan altar wuruꞌu kaduunuꞌo kawaodapa-kizinaoaz diwaꞌora antanapu. ");
INSERT INTO wapNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tuukii Zechariah tariaꞌakan patukapan idi angel. ");
INSERT INTO wapNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mazan angel kian uꞌati, “Zechariah, manaꞌa putariaꞌanaꞌa, Tominkaru abata putoriinpan. Kaudaniꞌo nii pudaiaro, okaudanipan dono daonaioraꞌo nii odani nii. Pudakota paꞌi uꞌuu John kii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aizii ushakatan dono tuukiaꞌo nii pukonaukii-kidanuz naꞌiki ipai baꞌorainao pidannao tuukiaꞌo nii kapam ĩkonaukii-kidanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Naꞌiki umanawunuꞌo nii pidan uruu, Tominkaru awun zaꞌa. Aonaa kizi paꞌi utuzan wine naꞌiki maꞌozakaꞌo riwunii. Sariaapaꞌo nii Kaimanaꞌo Doronaa zaamatan uruu ushakatan dono. ");
INSERT INTO wapNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naꞌiki uruꞌo nii padanata-kida iriba Israelitenao powaa ati, Naobanai Tominkaru idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Naꞌiki uruꞌo nii kiwiita Naobanai uaꞌati, maꞌozakaꞌo nii uruu, naꞌapaꞌo nii manawun umaꞌozakan Elijah kawan, Tominkaru prophetiniz. Naꞌiki ukaimanadan nii daruinao nyukunuu ĩdainao tuma kida. Naꞌiki pidannao wuruꞌu dikintapainao kidaz, utanawatan nii ĩnyukunuu, kaiman kiziꞌi naa ĩaitapan padiꞌitinpan, naꞌapa izoꞌatiinao kawan Tominkaru. Naꞌiki uminziiwa-kidan niꞌi naa Tominkaru pidanannao nyukunuu, ĩizoꞌati kizi uparadan.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sariapa Zechariah kian angel ati, “Kandii idaꞌanaꞌo nii mooko õaitapan umishiin wuruꞌu pukowaadaniaz aimaakan õꞌati? Ushaꞌapanum kauꞌan õgaru tunarunaouꞌu naa naꞌiki õdaiaro naꞌapa maskonnaouꞌu naa kapam.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sariapa angel kian uꞌati, “Õgaru Gabriel, Tominkaru diꞌikiꞌo õwaꞌatiꞌikan. Udyuudanii õgaru kowaadaꞌo nii paparadan puꞌati, wuruꞌu kaimanaꞌoraz kuwai. ");
INSERT INTO wapNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mazan aonaa pumishidan õkuwaa, wuruꞌu mishiꞌoraz nii ushaꞌapan paainaa kawanaꞌati. Pumamishidakan idi õkuwaa, pumaparadanun nii aizii. Ukauꞌan aonaꞌo nii pukaparadanun, atii õkuwaa mishiinan dauꞌanaꞌo nii zii pukaparadanun koshan.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Upuꞌaꞌa naa pidannao zaudapan Zechariah koditan. Ĩaitapaꞌazon ushaꞌapanum naa wuruꞌu umakoditakanuz kadiman. ");
INSERT INTO wapNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Udaunaꞌan zii ukoditan ĩꞌidaꞌati. Mazan aonaꞌa naa uparadan nii. Ĩaitapaꞌaka sariapa, Tominkaru tukapa-kidan aimaakan uꞌati. Pamaparadanun idi Zechariah tiwaan naa pakakuwaapan ĩꞌati pakaꞌu idaꞌanaꞌa naa karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Uipaian daunaꞌan ipai pakaudinkiz, ukiwan naa padapu iti. ");
INSERT INTO wapNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aonaa ukotuaꞌikin uruu daunaꞌan Elizabeth kaudanin naa mishi. Mazan aonaa okoditan padapu iki, atii bakaꞌiaudaꞌu kauzu daunaꞌan zii okoditan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Uruu idi okian, “Aizii Tominkaru kamunan-kida mishi õgaru. Uruu idi aonaꞌo nii powaꞌa pidannao dakoopanun.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Aizii 6 kauzu Elizabeth kaudanin daunaꞌan, uruꞌu naa Tominkaru dyuudan angel, Gabriel kiaꞌoraz uꞌuu, wiizai Nazareth iti, Galilee Baara iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Udyuudanuzu naꞌakaꞌo nii parada-karu paꞌinaiba zun diꞌiti, Mary kiaꞌo oꞌuu. Joseph, King David takaan-daunuz, aiapanii oroo naꞌiki upishaaniꞌi naa oroo padaronao ati pamin-mazidan nii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aizii angel kaawan oꞌidaꞌati, sariapa ukian oꞌati, “Kaiman pugaru? Kainaꞌa Tominkaru putuma, naꞌiki tuukii ukamunanun puꞌati,” ukian oꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tuukii Mary tarian, naꞌiki tuukii odiꞌitinpan ukuwaa dauꞌu, naꞌiki tuukii oaitapaꞌazon naꞌapaꞌoram manawun wuruꞌu ukianuz paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mazan angel kian oꞌati, “Mary, manaꞌa putariaꞌanaꞌa, aizii Tominkaru kamunanuꞌuzon puꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ukauꞌan pukaudanin nii daonaiora idi. Aizii pukaudanipan dono, pudakota paꞌi uꞌuu Jesus kii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Uruu tuubaruꞌo nii, naꞌiki umanawunuꞌo nii pidan, naꞌiki udakota-kao nii Tominkaru umanawunuꞌoraz Dani nii. Naꞌiki Naobanai Tominkaru zaamatan nii uruu king nii, naꞌapa kotuaꞌo udokozu-daun King David kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Karikaonanuꞌo nii uking-tinpan Israelitenao ati, wuruꞌu Jacob takaan-daunnaouz, naꞌiki unaobanai-tinapanuz, aonaa naꞌapainim nii ukatokon-tinan.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Udaunaꞌan Mary kian angel ati, “Õgaru paꞌinaꞌo zii zun, aonaꞌo zii daonaiora kiitauzon. Naꞌapam nii mooko õkaudanin?” ");
INSERT INTO wapNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel kian oꞌati, “Kaimanaꞌo Doronaꞌo nii wuruꞌu kaawaꞌoraz puꞌidaꞌati, naꞌiki Tominkaru taan idaꞌanaꞌo nii karikaonan pamaꞌozakan puꞌidaꞌati, wuruꞌu pukaudaninuz. Ukauꞌan pudani, wuruꞌu kaimanaꞌoraz manawun koraidaonaa, aonaꞌoraz oiaꞌo nii uꞌidaꞌa, udakota-kao nii Tominkaru Dani. ");
INSERT INTO wapNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Puaitapa puiriban taoroꞌo Elizabeth. Pidannao kian aonaa naꞌapainim nii okaudaniizon. Mazan kai oroo kaudaniꞌi naa, 6 kauzuꞌu naa. Omaskonnaoun puꞌaꞌa naa padamata, mazan upuꞌu zii okaudanin. ");
INSERT INTO wapNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ushaꞌapanum kauꞌan Tominkaru ati, aonaa aimaakan kashaꞌapannan, turuu ushaꞌapatan shaꞌapaꞌoram aimaakan, aonaꞌoraz turuu puabatan ushaꞌapata-kao.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sariapa Mary kian, “Õgaru Tominkaru poitoruaba. Marii mooko aimaakan shaꞌapan õꞌati, puparadan kawanaꞌati,” okian. Udaunaꞌan angel makoꞌokan naa oꞌai. ");
INSERT INTO wapNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Kadiman aka udaunaꞌan, uruꞌu naa Mary makon munapo, midukuo-taꞌo wiizai diꞌiti, Judea Baara iaꞌoraz. Omakon atii Zechariah dapu iti. Aizii okaawan sariapa onaubaan Elizabeth. ");
INSERT INTO wapNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mary naubaan puꞌu oroo, sariapa Elizabeth abatan paudani dakazatinan patoba nazo ii. Upuꞌaꞌa naa Kaimanaꞌo Doronaa kaawan Elizabeth idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Uruu idi Kaimanaꞌo Doronaa aipan ati okian Mary ati diiwaꞌo idaꞌan. “Tuukii manawun Tominkaru kaimanan puꞌati, ipai baꞌoran zunnao ai. Naꞌiki kaiman manawun Tominkaru pudani ati, putoba nazo iaꞌoraz.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Okian koshan, “Kandii niꞌo paꞌan wuruꞌu kaimanaꞌo manawun aimaakan shaꞌapanuz õꞌati, wuruꞌu õnaobanaa daro morowautapanuz õꞌidaꞌati? ");
INSERT INTO wapNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Punaubaan puꞌu õgaru, sariapa õabatan õdani dakazatinan õtoba nazo ii, ukonaukian idi. ");
INSERT INTO wapNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Konaukiaꞌo nii manawun pugaru, ushaꞌapanum kauꞌan pumishidan idi wuruꞌu parada-karuz, naꞌiki pumishidan idi mishiꞌo nii umishii-kao wuruꞌu wanaobanaa kowaada-kidaniaz puꞌati,” okian Mary ati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Uruu idi Mary kian. “Tuukii manawun õkonaukii-kidan wanaobanaa. ");
INSERT INTO wapNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Tuukii manawun õnyukunuu konaukian, Tominkaru õkazannaatapiki nyukunuitapan idi õgaru, naꞌiki ukamunan-kidan idi kowas õgaru, papoitoruaba. Aizii ipaiꞌo nii pidannao diinaꞌitiꞌi, ĩdakotan õgaru konaukiaiba nii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ushaꞌapanum kauꞌan, Tominkaru maꞌozakaꞌoraz shaꞌapatan idi kaimanaꞌoraz manawun aimaakan õꞌati. Mishi uruu umanawunuꞌo ukaimanan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ipai pidannao taapainaouz Tominkaru umanawunuꞌo nii, ĩdokozu-daunnao diꞌiki atii ĩwadaunnao diꞌiti, utukapa-kida pakamunanun ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mishi uruu maꞌozakaꞌo manawun, pamaꞌozakan idaꞌan ipai uwaataabiꞌian pidannao, wuruꞌu tuukiaꞌoraz ĩatadinpauzon. ");
INSERT INTO wapNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tuubaru kidainao naobanainao, naꞌiki umanawun-tinpainao kidaz, ipai uwaota-kidan ĩdyaun panaobanai-tinpan ai. Aizii pidannao waranuitapa-kariwainao, uzaamata paꞌan ĩdyaun tuubaru kidainao nii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aizii zamazi-tinainao utaa ipai aimaakan ĩꞌati, abaapa utaapan ĩdyaun. Mazan kapuraataniinao, aonaa kanom utaan ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mishi pakiauzon kawan wadokozu-daunnao ati kotuaꞌa naa, aizii ukawanaꞌati mishi ukaminkaꞌutan papoitorunao Israelitenaouz. ");
INSERT INTO wapNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aonaa mishi umanyukunuutan kotuaꞌo paparadan, ukiauzonuz, karikaonanuꞌo nii ukamunan-kidan Abraham naꞌiki udainao diinaꞌitiꞌi,” kiaꞌo Mary kian. ");
INSERT INTO wapNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary naꞌian idikinaudaꞌu kauzu Elizabeth tuma. Udaunaꞌan okiwan naa padapu iti. ");
INSERT INTO wapNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aizii Elizabeth kaudanipan donoꞌo naa, uruꞌu naa okaudanipan, daonaiora mishi odani nii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aizii omin-dazabazinao, naꞌiki oiribannao abatan naꞌapam Tominkaru kamunanun naꞌiki utukapa-kidan tuukii pakaimanan oꞌati. Tuukii ĩkonaukian paabatan idi okaudanipan, uruu idi baokopa ĩkonaukian otuma. ");
INSERT INTO wapNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aizii baudaꞌapa sondii Elizabeth kaudanipan daunaꞌan, uruꞌu naa pidannao kaawan ĩtukapaꞌanan naa ĩdani choota-kao Jewnao kaduz kawanaꞌati. Aizii wuruꞌu pidannaouz aipan naa padakotan uꞌuu Zechariah kii, padaru uu kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mazan udaro kian ĩꞌati, “Aonaa, aonaa naꞌapaꞌo nii mani uꞌuu, John kiaꞌo nii paꞌan uꞌuu.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sariapa ĩkian oꞌati, “Mazan aonaa baudaꞌapa uiribannao naꞌapaꞌo nii ĩꞌuu.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Udaunaꞌan ĩpishaan udaru pakaꞌu idaꞌan, ĩaipan ukowaadan naꞌapam uaipan paudani uu dakota-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sariapa Zechariah pishaan ĩꞌati kaarita, udaunaꞌan usaadan kaarita idaꞌa kaikapaꞌa: “John kiaꞌo nii uꞌuu.” Tuukii pidannao diꞌitinpan, aonaa ĩzauda-kidan udakotan uꞌuu naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Upuꞌaꞌa naa mazan Zechariah kaparadanuꞌukan. Uruu idi tuukii ukonaukii-kidan Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ipai ĩmin-dazabazinao, tuukii ĩdiꞌitinpan. Udaunaꞌan ĩkowaadaabiꞌiaꞌakan naa baꞌorainao ati, ipai wuru dauꞌan kidaꞌa patukapanii kidaz ushaꞌapan. Uruu idi kuwai makon naꞌiki unaꞌaka-kao ipai wiizai kawanaꞌati, wuruꞌu midukuo baawu an kidaꞌoraz wiizainao, Judea Baara ii aka kidaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Uruu idi ipai pidannao wuruꞌu abatainao kidaz kuwai, tuukii manawun ĩdiꞌitinpan, naꞌiki ĩkian, “Ei, kanom kaduzuꞌo nii wuruꞌu koraidaonaaz diinaꞌitiꞌi?” Ushaꞌapanum kauꞌan ĩaitapan idi Tominkaru kainaꞌan utuma. ");
INSERT INTO wapNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Uruu dono Kaimanaꞌo Doronaa kaawan Zechariah idaꞌati. Kaimanaꞌo Doronaa aipan ati ukowaadan naa Tominkaru paradan pidannao ati. Kaikapaꞌo wuruꞌu ukianuz ĩꞌati: ");
INSERT INTO wapNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Wakonaukii-kida wanaobanaa, Israelitenao Tominkarunuz, ukaawan idi naꞌiki ukaminkaꞌutaꞌanan idi papidanannao, naꞌiki usoꞌotaꞌanan idi ĩdyaun ĩpatakaꞌuta-kao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Utaa zii mishi ipai waunao ati, maꞌozakaꞌo kazannaatin-kinai nii, papoitoru David takaan-daun idi. ");
INSERT INTO wapNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Naꞌapa pakiauzon kawanaꞌati kotuaꞌa naa, kaimanaꞌo paprophetinnao idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ĩkowaadan ukazannaatan nii waunao, naꞌiki usoꞌotan nii waunao watarubanao ai, wunao aiaꞌa tuukiaꞌoraz manawun ĩtoꞌora-kizaitapan waunao. ");
INSERT INTO wapNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mishi Tominkaru kowaadanii kotuaꞌa naa wadokozu-daunnao ati, ukamunan-kidan nii ĩdyaun. Naꞌiki aonaꞌo nii umanyukunuutan wuruꞌu ukowaadauzoniaz pashaꞌapatan nii ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kaimanaiman uwaꞌakan mishiꞌoraz paparadan wadokozu-daun Abraham ati kotuaꞌa naa, aonaꞌoraz turuu upanaꞌada-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ukowaadauzon uꞌati diinaꞌitiꞌi, ukazannaatan nii waunao watarubanao ai. Kaiman kizi wamashaapan uꞌati aonaa wataritan biiꞌi mani. ");
INSERT INTO wapNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Naꞌiki kaiman kizi manawun wamashaapan soo uruu ati baudaꞌapa naꞌiki waizoꞌati kizi uparadan karikaonan.” ");
INSERT INTO wapNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Udaunaꞌan ukian. “Pugaru õdani, pudakota-kao nii umanawunuꞌo manawun Tominkaru prophetin nii. Pukiwiitan nii Naobanai uaꞌati, pusaabaꞌanan naa dunapo umako kizi nii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Naꞌiki pukowaada kiziꞌi naa upidanannao ati, ĩaitapa kizi ukazannaatan nii ĩdyaun, umainaabatan niꞌi naa ipai ĩꞌoian. ");
INSERT INTO wapNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mishi kaimanaꞌo naꞌiki kamunanuꞌo manawun wuruꞌu waTominkarunuz. Uruu aipan atiꞌo nii wuruꞌu kazannaatin-kinai waꞌatinuz kainaꞌiki. Uwaꞌatin nii kainaꞌiki kamoo koditan kawanuꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Naꞌiki ukanadapan nii ipai waunao mashaapainaouz marutaꞌo-karuꞌu, naꞌiki kichanaꞌikitinainaouz pamawakan ai. Naꞌiki kaimanaꞌo nii unaꞌakapan waunao, utukapa-kidan nii waꞌati kaimanaꞌo mashaapa-karu,” Zechariah kian. ");
INSERT INTO wapNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uruu idi John dyaupain naa, atii utuubarun. Aizii unyukunuu maꞌozaka kapam udyaupain Tominkaru dauꞌati. Aizii umashaapan mapidantakaꞌo amazada ii aka. Atii baudaꞌapa kamoo, ukaudinan kamoon kaawan naa. Uruu dono ukakuwaapatinan naa pidannao ati, wuruꞌu Israelitenao kidaz. ");
INSERT INTO wapNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","Uruu dono kainaꞌa tuubaruꞌo king, Caesar Augustus kiaꞌo udakotapa-kao. Ukazowautapan idi ipai amazada atii amazada tokon iti, udyuuda-kidan paparadan ipai pidannao ati, ipai amazada kawanaꞌati. Uaipan ipai daunuudaꞌu pidannao saada-kidan paꞌuu padokozu-daunnao shakata-kizi ii paꞌidiwaru. Uruu ziꞌo pidannao uu saadapauzo-kao naꞌapa. Uruu dono, Quirinius kazowautapaꞌo ipai wiizainao Syria ii. Uruu dono ipai pidannao makon padokozu-daunnao shakata-kizi iti kida, king paradan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Aizii Joseph, mashaapan idi Nazareth ii, sariapa umakon Bethlehem iti, Judea Baara iaꞌoraz. Naꞌiaꞌo King David shakatauzon kotuaꞌa naa. Aizii wuruꞌu King Davidiz, uruu kotuaꞌo Joseph dokozu-daunuꞌu naa manawun. Uruu shakata-kizi itiꞌo wuruꞌu Joseph naꞌiki Mary saada-kidaꞌananuz paꞌuu, oroo upishaaniaz pamin-mazidan nii. Naꞌapain pidannao uu saadapaꞌazoo-kao dono, kaudaniꞌoraꞌa naa Mary patoba ii. ");
INSERT INTO wapNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Aizii Joseph naꞌiki Mary kaawan dono Bethlehem iti, ipai kabaun nazoo sookapa-kizai paidan. Uruu idi ĩsookapa-kida-kao tapiꞌizanao dapu nazo ii. Uruu daunaꞌan Mary kaziwapan naa, atii okaudanipan naꞌii, tapiꞌizanao dapu nazo ii. Uruu baukapan zii Mary kaudanipan, daonaiora odani nii. Okaudanipan daunaꞌan osaabaan naa paudani sodi naꞌiki obazobatanuzu kamicha idi. Udaunaꞌan opaidanuzu tapiꞌizanao wanyukunuu kinnaa zoꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kainaꞌa pidannao taapauzonao kaznizonao. Uruu dono ĩnaꞌian baara ii aiwakaꞌan, ĩawunuutapan paꞌuzanao ĩshaꞌapata-kao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ĩawunuutapan puꞌu paꞌuzanao, mashaꞌapakiaka angel Tominkaru diꞌikiꞌo kaawan ĩꞌidaꞌati. Ipai Tominkaru umanawunun kanadaꞌakan amazada ĩdazaba an kidaꞌo, kanada, kanada kamoo ai. Uruu idi tuukii ĩtarian. ");
INSERT INTO wapNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mazan angel kian ĩꞌati, “Manaꞌa utariaꞌanaꞌa. Õwaꞌatin daꞌatiꞌi, õkakuwaapaꞌanan idi uꞌati. Aizii õkowaadan nii uꞌati kaimanaꞌo kuwai, naꞌiki ipai pidannao konaukii-kinaa niꞌo. ");
INSERT INTO wapNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aizii kai, kainaꞌa koraidaonaa shakatan Bethlehem ii, kotuaꞌoraz King, David kiaꞌoraz uꞌuu shakatauzo-kizi ii. Wuruꞌu koraidaonaa shakataꞌoraz, uruꞌu naa Christ, tuubaruꞌo manawun Naobanai, Tominkaru kowaadauzoniaz padyuudaꞌazon kazannaataꞌo nii ipai pidannao. ");
INSERT INTO wapNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kaikapaꞌo nii uaitapan wuruꞌu koraidaonaaz. Aizii umakon dono naꞌiti, utukapan nii koraidaonaa bazobatapa-kao kamicha idi, naꞌiki uwashatapa-kao nii tapiꞌizanao wanyukunuu kinnaa zoꞌii. Uruu idaꞌanaꞌo nii uaitapanuzu,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Upuꞌaꞌa naa mazan ĩtukapaꞌakan baꞌoran angelnao, aonaa masakaudaꞌu mani, ĩkaawaꞌakan pairiban idaꞌati. Ĩabatan angelnao konaukii-kidan Tominkaru pakunuipan idaꞌan. Kaikapaꞌo wuruꞌu ĩabatanuz ĩkunuipan: ");
INSERT INTO wapNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Oo Tominkaru aokazi iaꞌo, umanawunuꞌo manawun. Kaimanaꞌo nii manawun mashaapa-karu daꞌaꞌa imiꞌi baaraꞌa, ipai pidannao ati, Tominkaru naudapaniinaouz.” ");
INSERT INTO wapNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Udaunaꞌan angelnao makoꞌokan naa powaa iti, aokazi iti. Aizii ĩmakon daunaꞌan, uruꞌu naa wuruꞌu uzai taapikinao kian paꞌatiaaka kida, “Aushaa wamako Bethlehem iti, watukapanaka kizi kaiwuruꞌu Tominkaru kowaada-kidaniaz waꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Uruu daunaꞌan ĩmakoꞌokan naa naꞌiti kadimanaꞌo idaꞌan. Ĩkaawan naꞌiti, ĩtukapa Mary, Joseph, naꞌiki wuruꞌu koraidaonaaz, uwashatapa-kao tapiꞌizanao wanyukunuu kinnaa zoꞌii. ");
INSERT INTO wapNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Patukapan idi koraidaonaa, uruꞌu naa ĩkakuwaapan pidannao ati, naꞌiki ipai ĩkowaadan wuruꞌu angel kowaadanii kidaz paꞌati koraidaonaa dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ipai pidannao wuruꞌu abatainaouz ĩkakuwaapan, tuukii ĩdiꞌitinpan ĩkuwaa dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aizii Mary tuukii odiꞌitapan, naꞌiki ipai otaan panyukunuu iti wuruꞌu parada-karu kidaz. ");
INSERT INTO wapNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Udaunaꞌan uzai taapikinao kiwan naa koshan pataapa-kizi iti paꞌuzanao. Mazan ĩkiwan konaukii, tuukii manawun ĩkonaukii-kidan Tominkaru, paabatan idi kaimanaꞌo manawun kuwai angel diꞌiki, naꞌiki patukapan idi wuruꞌu koraidaonaaz paawun idi manawun. Uruu idi pamakopa-kizi an ĩkunuian aonaa masakaudaꞌu mani, ĩkonaukii-kidan Tominkaru patukapan idi ipai aimaakan, naꞌapa angel kowaadan kawanaꞌati manawun paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aizii baudaꞌapa sondii Mary kaudanipan daunaꞌan, uruꞌu naa odani choota-kao Jewnao kaduz kawanaꞌati. Naꞌiki uꞌuu dakota-kaoaꞌa naa Jesus kii, naꞌapa angel kiauzon kawanaꞌati oꞌati okaudanin uaꞌiaꞌoraz zii. ");
INSERT INTO wapNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Aizii baudaꞌapa kauzu naꞌiki baudaꞌapa sondii powaꞌa Mary kaudanipan daunaꞌan, uruꞌu naa omakon Joseph tuma Jerusalem iti Moses kakinaori kawanaꞌati. Ĩnaꞌaka dyaꞌutam wakokoonao pataan nii naꞌiki zowii-karu nii Tominkaru ati, pasaabainan pakaudanipan daunaꞌan tannaa nii, naꞌapa kakinaorii kawanaꞌati. Naꞌapainiꞌi naa kapam ĩnaꞌakan Jesus naꞌiti, uruu ĩtaaꞌanan naaz Tominkaru ati, kakinaorii kawanaꞌati. Kaikapaꞌa shaꞌatii tawuruꞌu kakinaorii kiauzonuz: “Marii ipai daonaioranao, kiwiin kidainaouz ĩshakatan taa-kao Tominkaru ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Uruu dono kainaꞌa tunarunao, Simeon kiaꞌo uꞌuu, Jerusalem iaꞌo umashaapan. Uruu kaimanaꞌo pidan, izoꞌatiꞌo naꞌiki mashaapaꞌo Tominkaru ati. Naꞌiki kotuaꞌikiꞌoraꞌa naa uzaudapan naꞌiki tuukiaꞌoraꞌa naa utukapaꞌazon Tominkaru kazannaatan Israelitenao ĩpatakaꞌuta-kao ai. Karikaonan kapam Tominkaru Doronaa mashaapan utuma. ");
INSERT INTO wapNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Uruu idi Kaimanaꞌo Doronaa idaꞌan Tominkaru kowaada-kidan uꞌati, uaitapa patukapan nii zii Christ pamawakan uaꞌii, wuruꞌu Tominkaru kowaadauzoniaz padyuudaꞌazon. ");
INSERT INTO wapNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kaimanaꞌo Doronaa aipan ati Simeon morotan Tominkaru Dapu iti. Naꞌapain kapam Joseph naꞌiki Mary naꞌakan Jesus naꞌiti, uruu ĩtaaꞌanan naaz Tominkaru ati, kakinaorii dyuudan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Uruu idi naꞌiaꞌa naa Simeon dokobatan Jesus, naꞌiki tuukii ukonaukii-kidan Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ukian. “Õnaobanaa, aizii õgaru pupoitoru mawakan nii konaukii, ushaꞌapanum kauꞌan aizii puparadan mishiinan, ");
INSERT INTO wapNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","õtukapa mishi aizii õawun idi wuruꞌu kazannaatin-kinai niꞌoraz, ");
INSERT INTO wapNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","pudyuudaniaz naꞌiki puaipaniaz ipai pidannao aitapan. ");
INSERT INTO wapNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uruu idaꞌanaꞌo nii pupidanannao Israelitenao konaukii-kida-kao. Naꞌiki uruu kanadaꞌo, tukapa-kidaꞌo nii mishiꞌo parada-karu ipai baꞌoran kaduz pidannao ati, wuruꞌu Gentilenao kii-kizaiz.” ");
INSERT INTO wapNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tuukii Mary naꞌiki Joseph diꞌitinpan Simeon paradan idi naꞌapa, Jesus dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Naꞌiaꞌa naa Simeon toriinapa-kidan naa ĩdyaun, udaunaꞌan ukian Mary ati, “Diꞌoraz koraidaonaa Tominkaru diꞌikiꞌo, udyuuda-kao waota-kidaꞌo nii Israelitenao ĩmamishidakan idi, mazan baꞌoran Israelitenao ukadishita-kidan nii paꞌan paꞌidaꞌati ĩmishidan idi uruu. Uruu kainaaribai niꞌo Tominkaru dyuudan, iribaꞌo nii pidannao kashadanuz naꞌiki dakoopanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Padakoopan idaꞌanaꞌo nii uruu, ĩkainaabainan naꞌiki ĩaidan paꞌoian, wuruꞌu ĩdizapauzonii kidaz panyukunuu ii. Uruu idi tuukiaꞌo nii pubaiaapan kashaꞌoraꞌo naꞌiki kaziwaꞌo nii punyukunuu iti, naꞌapaꞌo nii punyukunuu dakata-kao kawan marii idi.” ");
INSERT INTO wapNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Uruu dono kainaꞌa maskonnao, Anna kiaꞌo oꞌuu. Aizii odaru uu Phanuel, Asher takaan-daun. Naꞌiki oroo Tominkaru prophetiniaba. 7 wunu zii ĩmazidan daunaꞌan odaiaru mawakan. ");
INSERT INTO wapNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aizii uruu dono, 84 owunun. Naꞌiki aonaa naꞌapainim oaonauzon Tominkaru Dapu ai. Ipai kamoo naꞌiki ipai marutaꞌo otoriinpauzon Tominkaru ati, naꞌiki osanadinpan patoriinpan dono Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aizii omorotan naa koshan Tominkaru Dapu iti, okaawan naꞌiti Jesus kaawa-kida-kao kawanaꞌati manawun. Uruu idi tuukii okonaukii-kidan Tominkaru. Udaunaꞌan okowaadan naa koraidaonaa dauꞌan ipai pidannao ati, wuruꞌu Jerusalem sannaouz, zaudapainaouznaa pakazannaata-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aizii Joseph naꞌiki Mary ipaian naa pashaꞌapaapan ipai wuruꞌu Tominkaru kakinaori kawanaꞌatiꞌoraz ushaꞌapata-kao. Uruu daunaꞌan ĩkiwan naa Nazareth iti, Galilee Baara iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naꞌiaꞌa naa Jesus dyaupain, utominan maꞌozaka naꞌiki aitapinaꞌo manawun pidan nii. Naꞌiki powaꞌa zii Tominkaru kaimanan uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ipai wunu Joseph naꞌiki Mary makouzon Jerusalem iti, Passover Kamoon dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aizii Jesus ikodan donoꞌo naa 12 wunu, ĩmakon naa koshan Jesus tuma Jerusalem iti, Passover Kamoon dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ĩnaꞌian atii ĩipaian wuruꞌu pashaꞌapaapaniaz. Aizii paipaian daunaꞌan pashaꞌapainpan, pidannao kiwan naa ipai daunuudaꞌu pawiizi iti kida. Aizii Joseph naꞌiki Mary ĩkiwan naa kapam. Aizii Jesus, unaꞌian naa uwaꞌakinan Jerusalem ii. Mazan aonaa Joseph naꞌiki Mary aitapan wuruꞌu uwaꞌakinanuz naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ĩꞌitiiman kainaꞌaꞌa naa uwaꞌatin pairibannao biiꞌi. Uruu idi ĩmakon naa atii wachuupun, uruu zii ĩsookapan. Aizii pasookapa-kizi ii, uruꞌu naa ĩdorotan Jesus pidannao bii an, ");
INSERT INTO wapNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","mazan aonaa ĩikodanuzu. Sariapa ĩpadantan powaa iti Jerusalem iti. Uruu idi ĩdorotinan naa udauꞌu naꞌiiꞌaka. ");
INSERT INTO wapNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Atii idikinaudaꞌu kamoo daunaꞌan zii ĩikodanuzu. Ĩikodan uruu Tominkaru Dapu nazo ii, usakanatapan Jewnao tiichaanao biiꞌi, uabatapan ĩkadakotinan Tominkaru Paradan dauꞌu naꞌiki upishautan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tuukii ĩdiꞌitinpan Jesus dauꞌu, aonaa naꞌiam zii ĩikodauzon koraidaonaa aitapaꞌo manawun uruu kawan naꞌiki aitapaꞌo padakoꞌatin parada-karu. ");
INSERT INTO wapNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aizii Joseph naꞌiki Mary tukapan idi Jesus naꞌii tuukii ĩdiꞌitinpan. Sariapa Mary kian uꞌati, “Õdani, kandii nii pushaꞌapatan aimaakan waꞌati kaikapaꞌa? Tuukii wadopian, naꞌiki tuukii pudorotin-kidan waunao ipai diꞌiiꞌakaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sariapa Jesus kian padaro ati, “Kandii nii mooko wuruꞌu udorotapanuz õgaru diꞌiiꞌakaꞌa? Aonaa mooko uaitapan daꞌa õgaruꞌu, õdaru dapuꞌu?” ");
INSERT INTO wapNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mazan aonaa ĩaitapan naꞌapaꞌoram atiꞌo wuruꞌu unaꞌapanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Udaunaꞌan Jesus makon naa ĩtuma Nazareth iti. Naꞌiaꞌa naa ipai ushaꞌapatan aimaakan padaronao dyuudan kawanaꞌati, aonaa udikintapan ĩdyaun. Mazan ipai Mary taapan panyukunuu ii wuruꞌu aimaakan kida shaꞌapanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aizii Jesus tominan maꞌozakaꞌo nii, naꞌiki aitapaabaꞌo nii. Uruu idi ipai pidannao marainapanuz naꞌiki Tominkaru tuukii kapam umarainapanuzu. ");
INSERT INTO wapNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Aizii 15 wunu, Tiberius kazowautapan ipai daunuudaꞌu amazada, atii utokon iti. Uruu dono Pontius Pilate tuubaruꞌo naobanai nii Judea Baara ii. Naꞌiki Herod kazowautapaꞌo nii amazada Galilee Baara ii aka. Aizii uꞌinawuzu Philip kazowautapaꞌo nii kapam amazada Iturea ii aka, naꞌiki Trachonitis ii aka. Naꞌiki uruu dono Lysanias kazowautapaꞌo nii amazada Abilene ii aka. ");
INSERT INTO wapNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Naꞌiki Annas naꞌiki Caiaphas Umanawunuꞌo Faadaanao uruu dono. Aizii naꞌapain wunao naobanai-tinpan dono kidaꞌa, Tominkaru dyuudan paparadan John diꞌiti, Zechariah daniz. Udyuudan paparadan umashaapa-kizi iti, wuruꞌu mapidantakaꞌoraz amazada diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Uruu idi John makon naꞌiki ukakuwaatinan naa ipai amazada kawanaꞌati, wuruꞌu Jordan Waꞌo itinapu kidaꞌoraz. Naꞌii ukakinaopan pidannao kaikapaꞌa: “Utanawatinaꞌa naa uꞌoian ai, naꞌiki uchikaawunuinaꞌa naa, Tominkaru mainaabata kizi uꞌoian.” ");
INSERT INTO wapNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kaikapa shaꞌatii tawuruꞌu kotuaꞌo Tominkaru prophetin Isaiah kiauzonuz. “Kainaꞌa pidan kadakoinpan diiwa mapidantakaꞌo amazada ii aka kaikapaꞌa: ‘Usaabaꞌa naa dunapo kaimanaiman Naobanai ati, ukaawan uaꞌii, naꞌiki usakitapadaꞌa naa dunapo uꞌati, umako kizi nii. ");
INSERT INTO wapNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Marii ipai kasakodaz-tinapa kidaꞌoraz amazada, naꞌiki baawuz kida dida-kao, naꞌiki marii ipai naawazi naꞌiki midukuonao patumaakada-kao, naꞌiki marii ipai dunapo koraudapa kidaꞌo sakitapada-kao, naꞌiki marii ipai dunapo dikauda kidaꞌo naꞌiki kichadin kidaꞌo patumaakada-kao kaimanaiman. ");
INSERT INTO wapNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ipaiꞌo nii pidannao tukapan naꞌiki ĩaitapan wuruꞌu Tominkaru kazannaatanuz pidannao.’” ");
INSERT INTO wapNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aizii John chikaawunuupan dono, iriba pidannao kaawan ĩchikaawunuu-kidinaꞌanan uꞌati. Sariapa John kian ĩꞌati, “Kowazazunao, kandii kowaadan uꞌati turuu ukazannaatinan Tominkaru patakaꞌutaꞌazon ai unao? ");
INSERT INTO wapNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ushaꞌapataꞌa naa kaiman kidaꞌo aimaakan, utukapa-kida kizi mishi utanawatinan uꞌoian ai. Naꞌiki aonaa ukiaꞌanaꞌa uꞌatiaaka kida, ‘Mazan waunao Abraham takaan-daunnao paꞌan.’ Õkowaadan nii unao ati aizii, turuu Tominkaru toman Abraham takaan-daunnao nii diꞌoraz kuba kida idiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kainaꞌa baro, minziiwapaꞌoraꞌa naa barotaꞌo nii atamun kida. Ipai atamun wuruꞌu aonaꞌoraz ukaakan kaiman naꞌiki wuruꞌu dikauda kidaꞌoraz uꞌaka kida, ipaiꞌo nii ubarota-kao, udaunaꞌan ukaboota-kao nii ipai tikazi wuꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sariapa pidannao pishaan John, ĩkian uꞌati, “Aizii mani, naꞌapam nii washaꞌapatinan?” ");
INSERT INTO wapNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ukian ĩꞌati, “Kanom kainaꞌa dyaꞌutamaꞌo ushooton oo uchaakitan, marii utaan baudaꞌapa mashootonuꞌo pidan ati. Naꞌiki kanom kawanyukunuꞌo, marii ukaꞌidiwatan mawanyukunuꞌo pidan.” ");
INSERT INTO wapNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kainaꞌa pidannao zaamaapauzonao tax puraatannaa, ĩnao kapam kaawan, ĩchikaawunuu-kidinaꞌanan John ati. Naꞌiki ĩkian uꞌati, “Tiichaa, waunao mani, naꞌapam nii washaꞌapatinan?” ");
INSERT INTO wapNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Manaꞌa naa uzaamaapaꞌanaꞌa puraata pidannao ai dobata manawun udyuuda-kao ai.” ");
INSERT INTO wapNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kainaꞌa kapam soldyaanao kaawan John idaꞌati. “Waunao mani, naꞌapam nii washaꞌapatinan?” ĩkian uꞌati. “Manaꞌa naa ukazaapaꞌanaꞌa puraata pidannao ai, naꞌiki manaꞌa naa utomaꞌanaꞌa mariidin-karu ĩdauꞌan, uaipan idi karikaonan ukazatan ĩpuraatan. Turuaꞌo wuruꞌu ukawinipinaapa-kaoaz,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tuukii pidannao diꞌitinpan John dauꞌu, naꞌiki tuukii ĩtukapaꞌazon aimaakan umanawunuꞌo shaꞌapata-kao. Ĩkian panyukunuu ii, “Uruꞌu naa õaitapan Christ, tawuruꞌu Tominkaru kowaadauzoniaz padyuudaꞌazon.” ");
INSERT INTO wapNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aizii John kian ipai ĩnao ati, “Õgaru, õchikaawunuupan unao wunu idi karikaonan. Mazan kainiꞌikiꞌo nii pidan kaawan powaꞌaꞌo zii umanawun õꞌai. Õgaru aonaa õturuan õbuzuutan udazkidi zunaa. Uruu, uchikaawunuuan nii paꞌan unao Kaimanaꞌo Doronaa idi naꞌiki tikazi idi. ");
INSERT INTO wapNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kainaꞌaꞌa naa unaꞌakapan pawidauapa-kinaa papaoriba aka kida. Ipaiꞌo nii uwidauan kaiman kidaꞌo papaoriba aka, naꞌapa zaishi widau-kao kawan pamada ai. Udaunaꞌan usaabaa-kao niꞌi naa kaiman padapunaa iti. Mazan wuruꞌu dikauda kidaꞌoraz, ipaiꞌo nii paꞌan ukaboota-kao tikazi wuꞌiti, wuruꞌu aonaꞌoraz umakadauzon.” ");
INSERT INTO wapNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Iriba sodi kida John paradan, utiwaan pakowaadan kaimanaiman pidannao ati Kaimanaꞌoraz Kuwai. Naꞌiki ukakinaowan ĩdyaun tuukii, uaipan idi ĩpanaꞌadan pakaduz kida. ");
INSERT INTO wapNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aizii Herod naobanai-tinpaꞌoraz Galilee Baara ii, tuukii John kakinaowanuz, ukazatan idi paꞌinawuzu daiaro Herodias, naꞌiki ushaꞌapatan idi baꞌoran dikauda kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Naꞌiki powaꞌa zii Herod toman aimaakan dikaudaꞌo, ukaboota-kidan idi John taraa-kizai iti. ");
INSERT INTO wapNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aizii John kaboota-kao uaꞌii taraa-kizai iti, uchikaawunuupan ipai pidannao, wuruꞌu kaawainao kidaz uꞌidaꞌati. Uruu daunaꞌan uchikaawunuuan naa kapam Jesus. Jesus toriinpan puꞌu, sariapa aokazi daꞌata-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Naꞌiki Kaimanaꞌo Doronaa kaawan uꞌidaꞌati aokazi iki, ukaawan orid nii. Naꞌiki parada-karu kian Jesus ati aokazi iki, “Pugaru õdani õmarainapanii, kaiman manawun õnyukunuu puꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aizii Jesus sakadan dono pakaudinan, 30 uwunun naꞌapain. Aizii pidannao dakotan Jesus Joseph dani nii. Joseph uruu Heli dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","aizii Heli uruu Matthat dani, aizii Matthat uruu Levi dani, aizii Levi uruu Melchi dani, aizii Melchi uruu Jannai dani, aizii Jannai uruu Joseph dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","aizii Joseph uruu Mattathias dani, aizii Mattathias uruu Amos dani, aizii Amos uruu Nahum dani, aizii Nahum uruu Esli dani, aizii Esli uruu Naggai dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","aizii Naggai uruu Maath dani, aizii Maath uruu Mattathias dani, aizii Mattathias uruu Semein dani, aizii Semein uruu Josech dani, aizii Josech uruu Joda dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","aizii Joda uruu Joanan dani, aizii Joanan uruu Rhesa dani, aizii Rhesa uruu Zerubbabel dani, aizii Zerubbabel uruu Shealtiel dani, aizii Shealtiel uruu Neri dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","aizii Neri uruu Melchi dani, aizii Melchi uruu Addi dani, aizii Addi uruu Cosam dani, aizii Cosam uruu Elmadam dani, aizii Elmadam uruu Er dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","aizii Er uruu Joshua dani, aizii Joshua uruu Eliezer dani, aizii Eliezer uruu Jorim dani, aizii Jorim uruu Matthat dani, aizii Matthat uruu Levi dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","aizii Levi uruu Simeon dani, aizii Simeon uruu Judah dani, aizii Judah uruu Joseph dani, aizii Joseph uruu Jonam dani, aizii Jonam uruu Eliakim dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","aizii Eliakim uruu Melea dani, aizii Melea uruu Menna dani, aizii Menna uruu Mattatha dani, aizii Mattatha uruu Nathan dani, aizii Nathan uruu David dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","aizii David uruu Jesse dani, aizii Jesse uruu Obed dani, aizii Obed uruu Boaz dani, aizii Boaz uruu Salmon dani, aizii Salmon uruu Nahshon dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","aizii Nahshon uruu Amminadab dani, aizii Amminadab uruu Admin dani, aizii Admin uruu Arni dani, aizii Arni uruu Hezron dani, aizii Hezron uruu Perez dani, aizii Perez uruu Judah dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","aizii Judah uruu Jacob dani, aizii Jacob uruu Isaac dani, aizii Isaac uruu Abraham dani, aizii Abraham uruu Terah dani, aizii Terah uruu Nahor dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","aizii Nahor uruu Serug dani, aizii Serug uruu Reu dani, aizii Reu uruu Peleg dani, aizii Peleg uruu Eber dani, aizii Eber uruu Shelah dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","aizii Shelah uruu Cainan dani, aizii Cainan uruu Arphaxad dani, aizii Arphaxad uruu Shem dani, aizii Shem uruu Noah dani, aizii Noah uruu Lamech dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","aizii Lamech uruu Methuselah dani, aizii Methuselah uruu Enoch dani, aizii Enoch uruu Jared dani, aizii Jared uruu Mahalaleel dani, aizii Mahalaleel uruu Kenan dani, ");
INSERT INTO wapNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","aizii Kenan uruu Enosh dani, aizii Enosh uruu Seth dani, aizii Seth uruu Adam dani, aizii Adam uruu Tominkaru dani. ");
INSERT INTO wapNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Udaunaꞌan Jesus kiwan naa Jordan Waꞌo iki, pachikaawunuu-kao daunaꞌan, maꞌozaka Kaimanaꞌo Doronaa taapan unyukunuu. Uruu dono Kaimanaꞌo Doronaa naꞌakan naa Jesus atii mapidantakaꞌo amazada diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jesus naꞌian 40 kamoo. Naꞌiaꞌa naa Satan tiwaa-kidapan Jesus nyukunuu maꞌozakan. Aizii wuruꞌu Jesus naꞌianuz aonaa kanom unikan, atii 40 kamoo. Uruu idi tuukiaꞌa naa manawun uzamazin. ");
INSERT INTO wapNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sariapa Satan kian Jesus ati, “Tominkaru danin an pugaru, pudyuuda diꞌoraz kubaꞌa tominan bread nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mazan Jesus kian uꞌati, “Tominkaru Paradan tawuruꞌu kotuaꞌoraz usaadauzo-kao kian: ‘Aonaa pidan mashaapan soo bread idaꞌan karikaonan.’” ");
INSERT INTO wapNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Udaunaꞌan Satan zaida-kidan Jesus dokoaꞌo amazada diꞌiti, naꞌiki uaida-kida Jesus ati ipai daunuudaꞌu wuruꞌu umanawun kidaꞌoraz donoinao, ipai amazada tokon iti. Mazan masakaudaꞌuꞌo karikaonan wuruꞌu utukapa-kidankanuz uꞌati amazada. ");
INSERT INTO wapNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ukian Jesus ati, “Õzaamatan nii pugaru kazowautapaꞌo nii ipai wuruꞌu amazada putukapanii kidaz, naꞌiki õtaan nii ipai wuruꞌu konaunam kidaꞌoraz naꞌiki umanawun kidaꞌoraz aimaakan utaapan. Ipai daunuꞌo utaa-kao õꞌati wuruꞌu amazadaz naꞌiki ipai wuruꞌu utaapaniinao kidaz aimaakan. Ukauꞌan turuu õtaanuzu naꞌiaꞌoram pidan ati. ");
INSERT INTO wapNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aizii pukodoruꞌukan an õꞌati, õtaan nii puꞌati ipai daunuudaꞌu wuruꞌu amazadaz, naꞌiki ipai wuruꞌu aimaakan kidaz kainaꞌaꞌoraz naꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sariapa Jesus kian uꞌati, “Tominkaru Paradan saadauzo-kariwaiz kian: ‘Pukodoruꞌuka soo baudaꞌapa Naobanai puTominkarun ati. Pushaꞌapatin soo uruu aipan kawanaꞌati.’” ");
INSERT INTO wapNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Udaunaꞌan Satan naꞌakan naa Jesus Jerusalem iti. Uruu idi ĩkaawaꞌakan naa Tominkaru Dapu zowau paawa iti, udokoodinpan diꞌiti manawun. Naꞌiaꞌa naa ukian Jesus ati, “Tominkaru danin an pugaru, puzakaꞌuta kai diꞌikiꞌi imiꞌi baara iti. ");
INSERT INTO wapNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tominkaru Paradan saadinpaꞌoraz kian: ‘Udyuudan nii paꞌangelinnao kazannaatapan pugaru, naꞌiki ĩtaapan nii pugaru kaiman. ");
INSERT INTO wapNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ĩzaamatapan nii pugaru naꞌiki aonaꞌo nii pukaziwan pukidiba puwaotan an kuba kida diꞌiti.’” ");
INSERT INTO wapNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mazan Jesus kian uꞌati, “Tominkaru Paradan saadinpauzo kian: ‘Manaꞌa putiwaa-kidapauzoꞌonaꞌa uNaobanaa Tominkaru paradan mishiin.’” ");
INSERT INTO wapNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aizii ipaiꞌi naa Satan tiwaan Jesus nyukunuu. Uipaian daunaꞌan patiwautanuz, umakoꞌokan naa, atii baꞌoran donoꞌo nii zii koshan utiwaan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Uruu daunaꞌan Jesus kiwan naa Galilee Baara iti, naꞌiki maꞌozaka Kaimanaꞌo Doronaa taapan unyukunuu. Kuwai Jesus dauꞌu kidaꞌo abata-kaoaꞌa naa ipai wiizai kawanaꞌati wuruꞌu Galilee Baara ii aka kidaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naꞌii akaꞌa naa Jesus tominapa-kidan pidannao Tominkaru Paradan dauꞌu synagogue kida kawanaꞌati. Tuukii pidannao konaukii-kidanuzu. ");
INSERT INTO wapNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Udaunaꞌan Jesus makon Nazareth iti, padyaupai-kizi iti. Aizii Sookapa-karu Kamoon dono, umakon naꞌiki umorotan naa synagogue iti. Ukaduz umorotauzonuz naꞌapa ĩsookapan kamoon dono. Umorotan idi, naꞌiaꞌa naa pidannao dyuudan uaitan Tominkaru Paradan tawuruꞌu saada-kariwai kidaz kotuaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Uruu idi ĩtaan naa uꞌati kaarita, tawuruꞌu Tominkaru prophetin, Isaiah saadanii kidaz kotuaꞌa naa. Sariapa Jesus buzuutan wuruꞌu papidapa-kariwaiz kaarita, udaꞌatanuzu atii uikodan wuruꞌu paaitaꞌazooniaz. Kaikapaꞌa usaadinapanuꞌu: ");
INSERT INTO wapNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kainaꞌa Kaimanaꞌo Doronaa Tominkaru diꞌikiꞌo mashaapan õtuma. Uzaamatanii õgaru ushaꞌapanum kauꞌan uaipan idi õkowaadapan Kaimanaꞌo Kuwai patakaꞌutinainao ati. Udyuudan õkowaadan soꞌota-kao nii ipai pidannao wuruꞌu pataruba zaamatapaniinao kidaz, naꞌiki udyuudan õgaru ishaawunnao idaꞌati, õkowaada kizi ĩꞌati kaimanaꞌo niꞌi naa ĩtukapan, ĩawun saabaa-kao idi. Naꞌiki udyuudan õgaru kaminkaꞌutaꞌo nii, ipai wuruꞌu patakaꞌuta-kariwainaouz. ");
INSERT INTO wapNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Naꞌiki kowaadaꞌo nii Naobanai kamunanun niꞌi naa paꞌan aizii, papidanannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Udaunaꞌan Jesus papidaꞌakan naa wuruꞌu kaaritaz powaa iti, naꞌiki utaaꞌakan naa powaa itiz pidan ati, wuruꞌu taaꞌoraz uꞌati kaarita. Udaunaꞌan usakanataꞌakan naa. Ipai pidannao, wuruꞌu synagogue iainao kidaz, awunuupaꞌakan soo Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Naꞌiki ukian ĩꞌati, “Aizii wuruꞌu uabataniaz Tominkaru Paradan aita-kao, uruu umishiinan naa wuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ipai pidannao, abatapainao naꞌii, tuukii ĩdiꞌitinpan uparadan dauꞌu. Kaiman ĩabatan ukakuwaapan, aitapaꞌo pidan kawan manawun. Mazan ĩkian paꞌatiaaka kida, “Kanom dii mooko uruu, aonaa Joseph dani mani karikaonan?” ");
INSERT INTO wapNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sariapa Jesus kian ĩꞌati, “Õaitapa naꞌapam ukiaꞌazon õꞌati, uparadaꞌazon õꞌati tawuru kawanuꞌu parada-karu kiauzonuz. ‘Daakataa, pukasarain puaipan ati pukakuda kizi,’ kii-karuz. Naꞌiki õaitapa ukiaꞌazon õꞌati. ‘Pushaꞌapata kapam daꞌaꞌa puwiiziꞌi, tawuruꞌu kowaada-kariwaiz waꞌati pushaꞌapatan Capernaum ii.’” ");
INSERT INTO wapNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Udaunaꞌan Jesus kian koshan ĩꞌati, “Mishi, aonaa naꞌapainim Tominkaru prophetin naubauzo-kao, ukaawan an pawiizi ati. ");
INSERT INTO wapNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aizii uabata naꞌapam õkian. Elijah, kowaadapauzoz Tominkaru Paradan, kakupan dono zii, kainaꞌa iriba zunnao mawakaꞌo ĩdaiarunao, mashaapan Israel ii. Uruu dono idikinaudaꞌu wunu pazikon an powaꞌa aonaa wunu kaawan Israel ii, uruu idi aonaa wanyukunui nii, zamazi kaawan ipai wiizai kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mazan upuꞌu zii aonaa Elijah dyuuda-kao kaminkaꞌutaꞌo nii zunnao Israelitenaouz, wuruꞌu mawakainaouznaa ĩdaiarunao. Mazan udyuuda-kao soo baudaꞌapa zun diꞌiti mawakaibaꞌa naa odaiaru, baꞌoran wiizai iaꞌoraz omashaapan, Zarephath kiaꞌoraz udakota-kao, Sidon iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Naꞌiki Elisha, Tominkaru prophetin kakupan dono zii, kainaꞌa iriba pidannao Israel ii, kabishopauzonao kichanaꞌiki-kiaꞌo bishoi idi. Mazan upuꞌu aonaa baudaꞌapa pidan Elisha kakudan Israel iaꞌo ĩmashaapan. Soo ukakuda baudaꞌapa pidan Naaman kiaꞌo uꞌuu, mashaapaꞌo baꞌoran wiizai ii, Syria kiaꞌoraz udakota-kao.” ");
INSERT INTO wapNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ipai pidannao wuruꞌu abatapainaouz Jesus paradan synagogue ii, tuukii ĩtoꞌoran uꞌati, uparadan idi naꞌapa ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Uruu idi ĩkadishiaꞌakan kidaꞌa naa, udaunaꞌan ĩzaamataꞌakan naa Jesus paanoba kaduꞌiki kida, naꞌiki ĩnaꞌakaꞌakan naaz atii pawiizi tokon iti, dokoaꞌo ukatawudapuz-tinpan diꞌiti. Naꞌikiꞌo niꞌi naa ĩaipan pakidaꞌukan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mazan upuꞌaꞌa naa Jesus makoꞌokan, upodowaanaꞌakan pidannao bii an, atii naꞌapa umakon ĩꞌai. ");
INSERT INTO wapNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Udaunaꞌan Jesus makoꞌokan naa Capernaum iti, wiizai Galilee Baara iaꞌoraz. Naꞌii utominapa-kidan pidannao Tominkaru Paradan dauꞌu, Sookapa-karu Kamoon dono synagogue ii. ");
INSERT INTO wapNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tuukii pidannao diꞌitinpan paabatan idi Jesus paradan kaimanaiman manawun, ushaꞌapanum kauꞌan ĩabatan maꞌozaka manawun ukakuwaapan paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kainaꞌa daonaiora naꞌii synagogue ii, oiaꞌo doronai zaamatapanii. Sariapa ukadakon diiwaꞌo idaꞌan Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ukian, “Ei, Jesus Nazareth san. Kandii dauꞌati puwaꞌatin waꞌidaꞌati, kanom puaipan waꞌai? Oo pumainaabataꞌanan waunao? Õaitapa pugaru, kaimanaꞌo manawun, Tominkaru diꞌikiꞌo puwaꞌatin.” ");
INSERT INTO wapNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sariapa Jesus kian uꞌati, “Pumashaadautapa, pukodita uꞌai!” Sariapa oiaꞌo doronai kabootaꞌakan wuruꞌu daonaioraz pidannao awun zaꞌa, mazan umuudaꞌakan naa naꞌiki ukoditaꞌakan naa uꞌai wuruꞌu ukabootaꞌakanuz uruu. Mazan aonaa ushaꞌapatan daonaiora kaziwaꞌo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tuukii pidannao diꞌitinpan, naꞌiki ĩkian pairibannao ati, “Ei, naꞌapa dii paꞌan uparadan maꞌozakan manawun? Ukaꞌiita, naꞌiki maꞌozaka mishi uparadan oiaꞌo doronainao ati, atii udyuuda zii mishi ĩkoditan pidan diꞌiki.” ");
INSERT INTO wapNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Uruu idi ipai kuwai makon Jesus shaꞌapatanii dauꞌu, uruu wiizai diꞌiiꞌaka. ");
INSERT INTO wapNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aizii Jesus koditan daunaꞌan synagogue iki, umakon sariapa Simon dapu iti. Naꞌapain tuukiaꞌo Simon imauzo karinaan, omada wiichan wiicha, wiicha. Sariapa ĩkowaadan Jesus ati odauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Uruu idi umakon oꞌidiꞌiti. Ukaawan, ukadishitan maonapa owashatinapa-kizi bed idaꞌa. Sariapa udyuudan orinaa, wuruꞌu omada wiichanuz koditan oꞌai. Sariapa mishi omada wiichan shabataꞌakan, naꞌiki okakudaꞌakan naa. Udaunaꞌan okadishitan naa, naꞌiki otaan naa ĩwanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aizii kamoo tipitan daunaꞌan iriba pidannao kaawa-kidan karinainao pairibannao, pabiꞌinaaka kidaꞌo ĩrinaa, ipai ĩnaꞌakan ĩdyaun Jesus idaꞌati. Uruu idi ipai Jesus pishatan ĩdyaun, naꞌiki ipai ukakudan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aizii oiaꞌo doronainao, ipai ukodita-kidan pidannao ai kapam. Diiwa ĩkadakon kida ĩkoditan dono pidannao diꞌiki. “Pugaru Tominkaru Dani manawun,” ĩkian Jesus ati. Mazan tuukii Jesus mashaatan ĩdyaun, aonaa ukashaapan ĩparadan. Ushaꞌapanum kauꞌan ĩaitapan idi uruu Christ. ");
INSERT INTO wapNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aizii baꞌoran chaapiꞌiki ushaawaka zii Jesus makon naa donoi iki, naꞌiki umakon mapidantakaꞌo amazada iti. Uruu idi pidannao dorotapanuz atii ĩikodanuzu. Aonaa padamata ĩtaapadan umakon, tuukii ĩtiwaan pamashaatanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mazan Jesus kian ĩꞌati, “Kainaꞌa zii õkowaadaꞌazon Kaimanaꞌo Kuwai Tominkaru naobanai-tinan dauꞌu, baꞌoran wiizainao kida kawanaꞌati. Ushaꞌapanum kauꞌan uruu wuruꞌu Tominkaru dyuudaniaz õkowaadaꞌanan,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Uruu idi Jesus makon, naꞌiki ukakuwaatinan naa synagogue kida kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Baudaꞌapa kamoo Jesus kadishitapan, Gennesaret Karishiiz danomaꞌa. Uruu dono iriba, iriba pidannao kaawan uꞌidaꞌati. Naꞌiaꞌa naa ĩkasabaꞌuinan naꞌiki chakataꞌa naa ĩkaawan uꞌidaꞌati, ĩabataꞌazon idi ukowaadan Tominkaru paradan. ");
INSERT INTO wapNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Upuꞌu Jesus tukapan dyaꞌutam kanawanao muudapa-kao karishii danoma ii. Kopautapauzonao muudapanii wuruꞌu pakanawan kidaz. Aizii wuruꞌu pidannaouz, ĩchikaapan naa pasaironnao naꞌii wunu danomaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sariapa Jesus makon naꞌiki upaidinan Simon kanawan zoꞌiti, naꞌiki udyuuda ukidaꞌukan wuruꞌu kanawaz masakaudaꞌu karishii danoma ai. Uruu idi Jesus sakanatan naa kanawa zoꞌii, naꞌikiꞌi naa utominapa-kidan pidannao Tominkaru paradan dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aizii uipaian daunaꞌan pakakuwaatinan, sariapa ukian Simon ati, “Ukidaꞌuka kanawa baukapaꞌa naa kaanaꞌo-karu iti, utunuuta kizi usaironnao naꞌii, uzaamata kizi kopaunao.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sariapa Simon kian Jesus ati, “Õnaobanaa, baudaꞌapa marutaꞌo watiwautan wazaamatan kopau daꞌaꞌa, mazan aonaa kanom wazaamatan. Mazan aizii pudyuudan idi õgaru, õtunuutan nii wuruꞌu wasaironnaouz, puparadan kawanaꞌati,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Uruu idi naꞌiaꞌa naa ĩtunuutan pasaironnao. Naꞌiki sariapa ĩsaironnao zaamatan diriꞌi, diriꞌi kopaunao, aonaa ukaꞌiita-kao kawanaꞌati. Atii ĩsairon kida aonaa ukaꞌiitan naa pawazoo, maonapa kida ĩsairon dadotan, pawazoo kimishan idi manawun. ");
INSERT INTO wapNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sariapa ĩawarian pairibannao, wuruꞌu baꞌoran kanawa zoꞌiainaouz kaminkaꞌutaꞌo nii paugaru. Uruu idi baokopaꞌa naa ĩtoꞌotan wuruꞌu sairo kidaz, ĩzaamata kopau diriꞌi, diriꞌi, ipai ĩpaidadan pakanawannao, maonapa kida ĩkanawan tipitan, uwazoo diriꞌin idi manawun. ");
INSERT INTO wapNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aizii Simon tukapan idi aimaakan shaꞌapan kaikapaꞌa, sariapa ukodoruꞌukan Jesus kanaapu iti, naꞌiki ukian uꞌati, “Marinaꞌa shoman õgaru, õnaobanaa, ushaꞌapanum kauꞌan oiaꞌo paꞌi manawun pidan wuruꞌu õgaruz.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tuukii Simon naꞌiki wuruꞌu baꞌorainaouz diꞌitinpan, patukapan idi pazaamatan diriꞌi manawun kopaunao. ");
INSERT INTO wapNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","James naꞌiki John wuruꞌu Zebedee dainaouz naꞌapa kapam, tuukii kapam ĩdiꞌitinpan. Sariapa Jesus kian Simon ati, “Manaꞌa putariaꞌanaꞌa, aizii puzaamaapan niꞌi naa paꞌan pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Udaunaꞌan ĩkozootan naa pakanawan kida karishii danoma ati, naꞌiki ĩwaꞌakaꞌakan naa ipai paꞌaimaakanutu kida, naꞌiki ĩmakoꞌokan naa Jesus dawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aizii Jesus kaawan wiizai iti, naꞌii kainaꞌaꞌo pidan baiatinaꞌo kichanaꞌiki-kiaꞌo bishoi idi. Utukapan idi Jesus, sariapa ukodoruꞌukan ukanaapu iti, uawun baara imiꞌi baara iti. Naꞌiki ukian Jesus ati, “Õnaobanaa, õpishaan pugaru tuukii manawun, punyukunuu naꞌapan an, pukakuda shoman õgaru, pusoꞌota wuruꞌu bishoizi õꞌai.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sariapa Jesus pishatanuz naꞌiki ukian uꞌati, “Naꞌapa mishi õnyukunuu, aizii marii pumada saabainan.” Sariapa mishi pidan mada saabainaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Udaunaꞌan Jesus kakinaowan uruu. Ukian uꞌati, “Manaꞌa zii paꞌi pukowaadaꞌanaꞌa pidan ati, wuru dauꞌanaꞌa õshaꞌapataniaz puꞌati. Mazan pumako paꞌan kai, faadaa diꞌiti, marii kizi uawunuutan pumada, utukapa kizi mishi pumada saabainan. Uruu daunaꞌan putaaꞌa naa paꞌi puꞌuza faadaa ati, utaa kiziz naꞌiki ukawaoda kiziz Tominkaru ati, Moses kakinaori kawanaꞌati. Uruu idaꞌanaꞌo nii pidannao mishidan kaimanaꞌa naa pumada saabainan powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mazan kiiꞌan kuwai Jesus dauꞌanaꞌo iribaaꞌaka-kaoaꞌa naa manawun ipai diꞌiiꞌaka kidaꞌa. Uruu idi pidannao kaawan aonaa masakaudaꞌu mani Jesus idaꞌati, ĩabataꞌazon idi ukuwaa. Baꞌorainao ĩkaawan ĩaipan idi kapam pakakuda-kao, parinaa kida ai. Uruu idi ipai ukakudan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mazan panaadon Jesus makon nii daꞌi, utoriinpaꞌanan mapidantakaꞌo amazada iti. ");
INSERT INTO wapNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aizii baudaꞌapa kamoo, Jesus tominapa-kidan dono pidannao, kainaꞌa pabiꞌi kida Phariseenao sakanatapan naꞌii, naꞌiki naꞌii kapam tiichaapauzonao Moses kakinaori dauꞌu. Baꞌoran wiizai iki kidaꞌo ĩwaꞌatin wuruꞌu ĩnaouz, tawuruꞌu Galilee Baara naꞌiki Judea Baara ii aka kidaꞌoraz wiizainao, naꞌiki Jerusalem ikiinao kida naꞌii kapam. Ĩnao kida wuruꞌu sakanatapaꞌoraz naꞌii. Mazan Tominkaru taaniꞌi naa pamaꞌozakan Jesus ati, ukakuda-kinaa nii karinainao pabiꞌinaaka kidaꞌo rinai ai. ");
INSERT INTO wapNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Naꞌapain pidannao kaawan Jesus idaꞌati, ĩnaꞌakan pairiban machiꞌikakaꞌo. Ĩnaꞌakanuzu pawashatinapa-kizi baara an. Ĩaipan pamorota-kidanuz kabaun nazo iti, Jesus kanaapu iti. ");
INSERT INTO wapNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mazan pidannao iriban idi manawun, aonaa naꞌitim ĩmorota-kidanuzu. Uruu idi sariapa ĩzaida-kidanuz kabaun zowau iti. Udaunaꞌan ĩsoꞌowan naa kabaun zowau, naꞌikiꞌi naa ĩtoka-kidanuz pawashatinapa-kizi baara an, atii pidannao sakoda iti, naꞌiki ĩmuudanuzu Jesus kanaapuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aizii Jesus tukapan idi ĩmishidan tuukii manawun, sariapa ukian machiꞌikakaꞌoraz pidan ati, “Õpaonaru, aizii ipai puꞌoian mainaabata-kao puꞌai.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sariapa tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki Phariseenao kian paꞌatiaaka kida, “Kandii mooko arawuꞌu, uwazootapaꞌazon Tominkaru paparadan idaꞌan? Soo baudaꞌapa Tominkaru turuaꞌo umainaabatan pidan oian.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mazan Jesus aitapa naꞌapam ĩdiꞌitinpan. Uruu idi ukian ĩꞌati, “Kandii nii udiꞌitinpan õdauꞌu kaikapaꞌa? ");
INSERT INTO wapNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Naꞌiaꞌoram mashaꞌapannaa: ‘ipai puꞌoian mainaabata-kao’ kii, oo ‘pukadishita naꞌiki puchiꞌika’ kii? ");
INSERT INTO wapNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mazan õaidan nii uꞌati wuruꞌu Daonaiora Aokazi Ikiꞌo, kainaꞌa umaꞌozakan umainaabata-kinaa nii pidannao oian daꞌaꞌa imiꞌi baaraꞌa.” Uruꞌu naa Jesus kiaꞌakan naa machiꞌikakaꞌo pidan ati, “Õkian puꞌati pukadishita, puzaamata wuruꞌu puwashatinapa-kiziz naꞌiki pumakoꞌo naa pudapu iti.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sariapa mishi pidan kadishitaꞌakan ipai awunuutapainao awun zaꞌa, uzaamataꞌakan naa pawashatinapa-kizi baara, naꞌiki umakoꞌokan naa padapu iti konaukii. Tuukii ukonaukii-kidan Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aizii wuruꞌu awunuutapainao kidaz, tuukii ĩdiꞌitinpan, naꞌiki tuukii kapam ĩtarian, naꞌiki tuukii ĩkonaukii-kidan Tominkaru. “Ei, watukapa zii aizii konaunam kidaꞌo naꞌiki umanawunuꞌo aimaakan shaꞌapata-kao, wuruꞌu aonaꞌoraz watukapauzon ushaꞌapata-kao kida,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Udaunaꞌan Jesus koditan naa kabaun iki naꞌiki umakoꞌokan naa. Pamakopa-kizi an utukapa pidan Levi kiaꞌo uꞌuu, uruu zaamaapauzo tax puraatannaa. Jesus ikodan usakanatapan pazaamaapa-kizi ii puraata. Sariapa ukian uꞌati, “Puwaꞌati õtuma, õtominapa-kida kizi pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sariapa Levi waꞌakan wuruꞌu pakaudinkiz naꞌiki umakoꞌokan naa Jesus dawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aizii padapu ii Levi toman naa udaruꞌo aroapa-karu Jesus ati. Kainaꞌa iriba baꞌorainao zaamaapauzonao kapam tax puraatannaa aroopaꞌazon ĩtuma, naꞌiki kainaꞌa iriba kapam baꞌoran pidannao kida aroopaꞌazon ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kainaꞌa naꞌii pabiꞌi kida Phariseenao awunuutapan, naꞌiki naꞌii kapam ĩiribannao tiichaapauzonao Moses kakinaori dauꞌu awunuutapan. Sariapa ĩkian utominapa-kidaniinao ati, “Kandii nii arawu aroopaꞌazon naꞌiki utuzaꞌazon wunao tumaꞌa oiainaouz, zaamaapauzonao kidaz tax puraatannaa, naꞌiki wuruꞌu oiainao kidaz pidannao?” Kiaꞌo wuruꞌu ĩkiainapanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sariapa Jesus kian ĩꞌati, “Pidannao ziwuinao, aonaa kanom nii ĩaipan daakataa, soo karinainao paꞌan tuukii ĩaipan daakataa. ");
INSERT INTO wapNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ukauꞌan naꞌapaꞌo kapam wuruꞌu õwaꞌatinuz daꞌatiꞌi, aonaa kaimanainao idaꞌatiꞌo mani, soo oiainao idaꞌatiꞌo paꞌan wuruꞌu õwaꞌatinuz ĩtanawatin kizi paꞌoian ai.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pabiꞌi kida pidannao, kaawainao kidaz Jesus idaꞌati, kian uꞌati, “John Chikaawunuupauzoz tominapa-kidaniinao mapuda paꞌan ĩsanadinpauzon, naꞌiki ĩtoriinpauzon Tominkaru aipan kawanaꞌati. Naꞌiki wuruꞌu tominpauzonao kidaz Phariseenao diꞌiki, naꞌapa kapam ĩsanadinpan naꞌiki ĩtoriinpan. Mazan aizii wuruꞌu putominapa-kidaniinaouz, aonaa ĩsanadinpauzon, mazan ĩaroopan nii naꞌiki ĩtuzan nii atii ĩshiitan.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sariapa Jesus kian ĩꞌati, “Turuu mani uꞌitiiman pidannao waꞌatiinao mazida-karu dauꞌati baiatan pazamazin mazidaꞌo daonaiora naꞌan puꞌu ĩtuma? Aonaa turuu ĩbaiatan pazamazin. ");
INSERT INTO wapNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mazan baudaꞌapa kamoo naꞌaka-karu nii wuruꞌu mazidaꞌoraz daonaiora ĩꞌai, uruu donoꞌo niꞌi naa paꞌan ĩsanadinpan naꞌiki ĩbaiatan pazamazin.” ");
INSERT INTO wapNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Udaunaꞌan Jesus kowaadan naa diꞌitinapa-kinai kuwai. Ukian ĩꞌati, “Aonaa naꞌiam zii pidan kuzuutauzon paꞌinaꞌo chaakita pazimindota-kinaa nii uzaamaꞌoraꞌa naa chaakita. Mazan aizii pidan kuzuuan an paꞌinaꞌo chaakita pazimindoapa-kinaa nii, upatakaꞌuan paꞌinaꞌo chaakita, naꞌiki panaꞌaꞌo nii uaidinpan uzaamaꞌo ai. ");
INSERT INTO wapNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Naꞌiki aonaa naꞌapainim pidan paidauzon, paꞌinaꞌo zii wine toma-kao, uzaamaꞌoraꞌa naa wine kinnaa zoꞌiti. Ushaꞌapanum kauꞌan paꞌinaꞌo wine paida-kao an, upoodan nii umaꞌozakan anaꞌa naa, naꞌiki utadaꞌokan nii wuruꞌu uzaamaꞌoraz naa riwunii kinnaaz. Uruu idi ipaiꞌo nii riwunii wakudinan. Aizii wuruꞌu ukinnaaz ukabootaꞌaka-kao niꞌi naa. ");
INSERT INTO wapNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mishiꞌoraiman paꞌinaꞌo wine paida-kao paꞌinaꞌo ukinnaa zoꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Naꞌiki aonaa kanom tuzaꞌazon paꞌinaꞌo zii wine toma-kao, patuzaꞌakan daunaꞌan maꞌozakaꞌoraꞌa naa wine. Aizii pidan tuzan an wuruꞌu maꞌozakaꞌoraz wine, ‘Kaiman paꞌan wuruꞌu maꞌozakaꞌoraz wine, paꞌinaꞌo utomaꞌaka-kao ai,’ ukian nii.” Uruu kiaꞌo wuruꞌu Jesus kowaadaniaz kuwai. ");
INSERT INTO wapNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Baudaꞌapa kamoo Sookapa-karu Kamoon dono, Jesus dobatapan zakapu an patominapa-kidaniinao tuma, paoribai wheat baawu an. Naꞌapain Jesus tominapa-kidaniinao karaowaanan wheat aka. Uruu idi ĩzuꞌuan naa wuruꞌu wheat aka kidaz pakaꞌu baara iti, ĩaipan idi umada soꞌoinan, udaunaꞌan ĩnikan naaz. ");
INSERT INTO wapNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pabiꞌi kida Phariseenao pishaan ĩdyaun, “Kandii niꞌo udikintapan wuruꞌu aonaꞌoraz wakakinaorinaa kashaapan ushaꞌapata-kao, Sookapa-karu Kamoon dono?” ");
INSERT INTO wapNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus kian ĩꞌati, “Aonaa mooko utukapauzon kaarita idaꞌaꞌoraz usaadinpan kanom King David naꞌiki uminaudaꞌunao shaꞌapatauzonii ĩzamazin donoꞌoraz? ");
INSERT INTO wapNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Umorotan Tominkaru Dapu nazo iti, naꞌii uzaamatan bread taa-kariwaiz Tominkaru ati. Udaunaꞌan unikan naaz naꞌiki utaan naa paminaudaꞌunao atiz. Aonaa ukashaapa-kao padamata baꞌoran pidan nikan wuruꞌu bread kidaz, soo faadaanao.” ");
INSERT INTO wapNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Powaꞌa zii Jesus kian ĩꞌati, “Daonaiora Aokazi Ikiꞌo, uruu paꞌan kazowautapaꞌoraz Sookapa-karu Kamoon.” ");
INSERT INTO wapNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Baꞌoran dono koshan, Sookapa-karu Kamoon dono, Jesus morotan synagogue iti. Naꞌii utominapa-kidan pidannao Tominkaru paradan dauꞌu. Kainaꞌa baudaꞌapa pidan naꞌii dadaraꞌo uanoba badaꞌii, udiwaꞌoran atanapa naꞌiki aonaa naꞌapam ukaiwaanuzu. ");
INSERT INTO wapNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kainaꞌa wunaouꞌu tiichaapauzonaouz Moses kakinaori dauꞌu, naꞌiki Phariseenao naꞌii kapam. Ĩnao tuukii ĩaipan patukapan Jesus shaꞌapatan aimaakan, ĩaipan panaꞌapaunuz, ushaꞌapatan an aimaakan, Sookapa-karu Kamoon dono. Uruu idi kaimanaiman ĩawunuutapan uruu, ĩtukapaꞌazon usaabaan wuruꞌu pidan anobaz. ");
INSERT INTO wapNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mazan Jesus aitapa ipai ĩdiꞌitinpan, uruu idi ukian wuru atiꞌi daonaiora dadaraꞌoraz uanoba, “Pukadishita, naꞌiki puwaꞌati daꞌatiꞌi pidannao kanaapu ati.” Sariapa ukadishitan naꞌiki umakoꞌokan naa pidannao kanaapu iti. ");
INSERT INTO wapNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Udaunaꞌan Jesus kian pidannao ati, “Õpishaan nii unao aizii, naꞌapa dii kakinaorii taa-kariwaiz waꞌati aipan washaꞌapatinan, Sookapa-karu Kamoon dono? Uaipan washaꞌapatan oiaꞌo oo kaimanaꞌo? Udyuuda wakakudan pidan oo wazowianuzu?” ");
INSERT INTO wapNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus awunuupan ipai pidannao kawanaꞌati, naꞌiki sariapa ukian pidan dadaraꞌo uanoba ati, “Pusawada puanoba.” Sariapa usawadaꞌakan paanoba, naꞌiki uanoba saabainaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mazan tuukii wunao toꞌoranuꞌu, zaudapainaouz Jesus shaꞌapatan aimaakan. Uruu daunaꞌan ĩmiitiniipan naa, ĩaitapaꞌazon naꞌapam nii pashaꞌapatan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Uruu dono Jesus makon naawazi paawa iti utoriinpaꞌanan, uruu idi unaꞌian utoriinpan baudaꞌapa marutaꞌo Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aizii baꞌoran chaapiꞌiki, uruꞌu naa udapadan patominapa-kidaniinao. Aizii ĩbii iki, uzaamata 12 daonaioranao padyuudan nii kowaadapaꞌo nii ipai kuwai wuruꞌu uaiapanii kidaz ukowaada-kao naꞌiki ushaꞌapata-kao. Udakotan wuruꞌu pazaamataniinaouz apostlenao. ");
INSERT INTO wapNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Kaikapaudaꞌuꞌo wuruꞌu uzaamataniinaouz: Simon, Peter kiaꞌoraz udakotapa-kao, naꞌiki uꞌinawuzu Andrew, naꞌiki kainaꞌa James, John, Philip, Bartholomew, Matthew, Thomas, naꞌiki James, Alphaeus daniz, naꞌiki Simon, uruu Patriot, Judas, James daniz naꞌiki Judas Iscariot zaamata-kidaꞌoraz Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Udaunaꞌan Jesus tokan naa naawazi paawa iki, apowaꞌaꞌo baara ati, wunao tumaꞌa pazaamataniinaouz daonaioranao. Naꞌiaꞌa naa iriba pidannao wuruꞌu tominpauzonao kidaz uꞌidiꞌiki kasabaꞌuinan, naꞌiki iriba kapam baꞌoran pidannao kaawan naꞌiti. Pidannao waꞌatin pabiꞌinaaka kidaꞌo wiizai iki, ipai Judea Baara ii aka kidainaouz wiizainao, Jerusalem ikiinao naꞌii kapam. Aizii kainaꞌa baꞌorainao kida kaawan waꞌatiinao Tyre naꞌiki Sidon iki, munapoꞌo paran danoma itinapu kidaꞌo wiizainao. ");
INSERT INTO wapNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ĩwaꞌatin ĩabataꞌazon idi Jesus kuwaa. Baꞌorainao, ĩkaawan ĩaipan idi kapam pakakuda-kao parinaa ai. Naꞌiki kainaꞌa baꞌorainao oiaꞌo doronai zaamatapaniinao kida. Uruu dono ipai ukakudan karinainao. ");
INSERT INTO wapNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tuukii pidannao aipan papishatan Jesus, ushaꞌapanum kauꞌan ĩtukapan idi maꞌozaka Tominkaru kaudinan uꞌidaꞌa, usoꞌota pabiꞌinaaka kidaꞌo rinai pidannao ai. Uruu idi ukakuda ipai pidannao parinaa kida ai. ");
INSERT INTO wapNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sariapa Jesus awunuupan wunao diꞌitiꞌi tominpainao kidaz uꞌidiꞌiki. Ukian ĩꞌati. “Konaukiaꞌo paꞌan unao, mapuraataniinaouz, ushaꞌapanum kauꞌan unao atiꞌo paꞌan wuruꞌu Tominkaru naobanai-tinanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Konaukiaꞌo paꞌan unao baiatainaouz pazamazin kai. Ushaꞌapanum kauꞌan, diinaꞌitiꞌi abaapaꞌo nii paꞌan unao. Konaukiaꞌo paꞌan unao, kashaꞌoratinainao kidaz kai, ushaꞌapanum kauꞌan diinaꞌitiꞌi karikaonanuꞌo nii paꞌan ukonaukiitinan. ");
INSERT INTO wapNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Konaukiaꞌo paꞌan unao, utoꞌora-kizaitapa-kao an, naꞌiki ukashanaukii-kida-kao an, naꞌiki udakowautapa-kao an, naꞌiki udakota-kao an oiainao nii Daonaiora Aokazi Ikiꞌo dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ukonaukii naꞌapa kidaꞌo aimaakan shaꞌapan dono uꞌati. Ukonaukii tuukii, ushaꞌapanum kauꞌan kainaꞌa paꞌan umanawunuꞌo uwinipinaa niꞌo taapa-kao aokazi ii. Wuruꞌu pidannao toꞌora-kizaitapaꞌoraz unao kai, naꞌapaꞌo kapam ĩdokozu-daunnao taapauzon Tominkaru prophetinnao kotuaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kashaꞌoraꞌo nii manawun ubaiaapan diinaꞌitiꞌi, unao kapuraataniinao, kai kaiman manawun uabatinpan. ");
INSERT INTO wapNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kashaꞌoraꞌo nii manawun ubaiaapan diinaꞌitiꞌi, unao kawanyukunuinao, mazan diinaꞌitiꞌi uzamazin nii. Kashaꞌoraꞌo nii manawun ubaiaapan diinaꞌitiꞌi, unao konaukiaꞌoraz umashaapan, konaukii ushaazootinan kai, mazan diinaꞌitiꞌi ukashaꞌoratinan nii tuukii, uzaadinan nii naꞌiki umuraapatinan nii. ");
INSERT INTO wapNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kashaꞌoraꞌo nii manawun ubaiaapan diinaꞌitiꞌi, kai tuukii uatadapa-kao. Naꞌapa kotuaꞌa naa ĩdokozu-daunnao atadapauzon pidannao dakotinpauzonaouz prophetnao nii. ");
INSERT INTO wapNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mazan aizii õkiaꞌazon unao abatapainao ati. Umarainapa ipai utarubanao. Kaiman utaapa naꞌiki ushaꞌapata kaiman aimaakan wunao atiꞌi toꞌora-kizaitapaꞌoraz unao. ");
INSERT INTO wapNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Upishaa Tominkaru marii kizi ukaimanan wunao atiꞌi, aipainaouz dikaudaꞌo shaꞌapan uꞌati. Naꞌiki utoriinapa Tominkaru ati kaimanaꞌo idaꞌan wunao dauꞌanaꞌa antamikiipauzonaouz unao. ");
INSERT INTO wapNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aizii pidan tinikan an pugaru pukaozoo ati, marii putinika-kidan baꞌoran pukaozoo uꞌati. Aizii pidan kazatan an puchaakitan, marii uzaamatan pushooton kapam. ");
INSERT INTO wapNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Naꞌiaꞌoram pidan pishaan an aimaakan puꞌai, putaa uꞌati. Aizii pidan kazatan an pushaꞌapauzi, manaꞌa pupishaaꞌanaꞌa powaa itiz. ");
INSERT INTO wapNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pushaꞌapata kaimanaꞌo aimaakan baꞌoran pidannao ati, naꞌapa puaipan kawan ĩshaꞌapatan aimaakan puꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Aizii pumarainpan an soo wunaouꞌu marainpainaouz karikaonan pugaru, kandii dikin ii puaitapan pukonaukii-kida-kao? Upuꞌu zii oiainao pidannao ĩmarainapa pamarainpikinao. ");
INSERT INTO wapNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aizii pushaꞌapatan an kaiman aimaakan soo wunao ati karikaonanuꞌu, shaꞌapatainao kidaz kaiman aimaakan puꞌati, kandii dikin ii puaitapan kaimanaꞌo aimaakan taa-kao puꞌati? Upuꞌu zii oiainao pidannao, ĩshaꞌapata kaiman aimaakan wunao atiꞌi shaꞌapatainaouz kaimanaꞌo aimaakan ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aizii putaan an aimaakan oo puraata pidan ati, puaitapan idi ukawadauntan niiz, kandii dikin ii puaitapan pukonaukii-kida-kao? Upuꞌu zii oiainao taan puraata baꞌoran oiainao ati, ĩaitapa kawadaunita-karu nii wuruꞌu papuraatanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ukauꞌan umarainapa utarubanao, ushaꞌapata kaiman kidaꞌo aimaakan ĩꞌati. Utaa kapam aimaakan kanaꞌapan ĩꞌati, aonaa uzaudapaꞌanaꞌa ukawadaunuta-kao powaa iti. Kainaꞌaꞌo paꞌan umanawun kida aimaakan taapa-kao unao ati, ushaꞌapatanii kida winipinaa nii. Uruu idi mishiꞌo nii Tominkaru umanawunuꞌoraz daniitan ipai unao. Tominkaru, uruu ipai ukaimanan pidannao ati. Utukapa-kida pakaimanan wunao atiꞌi, aonaꞌoraz ĩkonaukii-kidauzon uruu, utaan puꞌu aimaakan ĩꞌati, naꞌiki wunao atiꞌi oiainaouz manawun pidannao. ");
INSERT INTO wapNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ukauꞌan ukamunan kapam naꞌapa udaru Tominkaru kamunanuuzon kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Manaꞌa udakotauzoꞌonaꞌa pidan dikaudaꞌo nii, aonaa kizi Tominkaru dakotan unao dikaudaꞌo nii. Manaꞌa ukaboota-kidaꞌanaꞌa pidan patakaꞌuta-karu nii, aonaa kizi kapam uboota-kao. Naꞌiki umarinaꞌata wuruꞌu dikauda kidaꞌoraz shaꞌapatauzo-kao uꞌati, Tominkaru marinaꞌatan nii wuruꞌu oii kidaꞌoraz ushaꞌapatauzon. ");
INSERT INTO wapNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Utaa aimaakan baꞌorainao ati, Tominkaru taan nii aimaakan unao ati. Naꞌiki diriꞌiꞌo nii manawun aimaakan taa-kao uꞌati, atii aonaꞌo niꞌi naa naꞌitim upaidinan. Naꞌapam udiriꞌin putaauzon aimaakan baꞌorainao ati, naꞌapaꞌo nii udiriꞌin Tominkaru taan puꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Udaunaꞌan Jesus kakuwaapan naa, diꞌitinapa-kinai kuwai idaꞌan. Kaikapaꞌo wuruꞌu ukianuz: “Aonaa turuu pidan ushaawun naꞌakan pamin-ushaawunun, ushaꞌapanum kauꞌan ipai daunuudaꞌuꞌo nii ĩwaotan kichada-kariwai nazo iti. ");
INSERT INTO wapNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aonaa naꞌiam pidan tominpauz umanawunun patiichaan ai, mazan ipai wuruꞌu tominpauzonaouz ĩipaian daunaꞌan patominpan, naꞌapaꞌo niꞌi naa ĩaitapan patiichaan kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kandii nii mooko wuruꞌu pudiꞌitapanuz kaunubaꞌo puiriban awun idaꞌa, pumadiꞌitapakan puꞌu wuruꞌu atamun taramtinpaꞌoraz puawun idaꞌa? ");
INSERT INTO wapNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pukaꞌiita zii pukian puiriban ati. ‘Daꞌatiꞌi õsoꞌota kizi kaunubaꞌoraz puawun ai,’ pumatukapakan puꞌu kainaꞌa udaruꞌo atamun idin puawun idaꞌa? Pugaru taapinpaꞌoraz kaimanaꞌo nii kaikiniꞌi, mishiꞌoraiman pusoꞌotaꞌa naa zii kiwiin atamun idin puawun ai. Uruu daunaꞌan kaimanaꞌo niꞌi naa putukapan pusoꞌotaꞌazoonii kaunubaꞌoraz puiriban awun ai. ");
INSERT INTO wapNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Paoribai ziwuꞌo usodan, aonaa uꞌaka dikaudaꞌo nii. Mazan aizii paoribai maziwukaꞌo, ukaakan dono dikaudaꞌo nii kapam uꞌaka. ");
INSERT INTO wapNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ipai kaimanaꞌo dizoo-karu kadunaa aitapa-kao paꞌaka idaꞌan kida, naꞌiki aonaa naꞌiam zii pidan karaodauzon dizoo-karu fig oo grape kaiwada-karu kadunaa diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aizii kaimanaꞌo pidan, ukodita-kida kaiman kidaꞌo paꞌidiwaru aimaakan, utaapan idi kaiman kidaꞌo aimaakan panyukunuu ii. Mazan aizii dikaudaꞌo pidan, ukodita-kida dikauda kidaꞌo paꞌidiwaru aimaakan, utaapan idi oii kidaꞌo aimaakan panyukunuu ii. Ukauꞌan shaꞌapaꞌoram aimaakan pidan taapanii kida panyukunuu ii, uruu kida wuruꞌu ukodita-kidaniaz paparadan idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kandii nii udakotan õgaru unaobanaa nii, umashaꞌapatakan puꞌu õdyuudanii ushaꞌapatan? ");
INSERT INTO wapNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Naꞌiaꞌoram pidan waꞌatiꞌo õꞌidaꞌati, naꞌiki mishiꞌo uabataꞌazon õkuwaa, naꞌiki izoꞌatiꞌo õparadan, õkowaadan nii kanom kawanuꞌo uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Uruu naꞌapa pidan kawan, tomaꞌo padapu dadaraꞌo baaraꞌa, naꞌiki kichadaꞌo patoron uun nii munapo. Aizii naꞌapainim wunu tuubarun naꞌiki udapu naraan, aonaꞌo nii wunu paran kabootanuz, ushaꞌapanum kauꞌan dadaraꞌo baaraꞌaꞌo wuruꞌu udapuz. ");
INSERT INTO wapNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aizii naꞌiaꞌoram pidan abataꞌo õkuwaa mazan aonaa uizoꞌatinuz, naꞌapaꞌo uruu tawuru kawanuꞌu maaitapin-kaꞌoraz pidan, tomaꞌoraz padapu shomadaꞌo imiꞌi idaꞌa. Aizii naꞌapainim wunu tuubarun, baukapaꞌo nii wunu paran kidaꞌukaꞌakan wuruꞌu kabaunuz, uruu idi sariapa kabaun dorautan ipai daunuudaꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aizii Jesus ipaian daunaꞌan pakadakotinan pidannao ati, uruꞌu naa umakon Capernaum iti. ");
INSERT INTO wapNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aizii naꞌii kainaꞌa Roman soldyaannao zowaunaa. Uruu dono upoitoru umarainapanii manawun karinaan tuukii, maonapaꞌoraꞌa naa umawakan. ");
INSERT INTO wapNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Uabatan idi Jesus kaawan wuru wiizai idaꞌatiꞌi pamashaapa-kiziz, sariapa udyuudan kazowautapainao Jewnao Jesus diꞌiti. Uaipan ĩdapadankan Jesus, uwaꞌati kizi padapu ati, ukakudanaka kizi upoitoru. Aizii uruu aonaa Jew mani. ");
INSERT INTO wapNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Udaunaꞌan ĩmakon naa Jesus diꞌiti, atii ĩikodanuzu. Naꞌiaꞌa naa ĩkowaadan uꞌati parada-karu, naꞌiki tuukii ĩpishaan umakon patuma. Ĩkian uꞌati, “Tuukii manawun waaipan pukaminkaꞌutan wuruꞌu pidanaz, waaitapanii uruu kaimanaꞌo naobanai. ");
INSERT INTO wapNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ushaꞌapanum kauꞌan uruu umarainapanii tuukii wairibannao Jewnao, naꞌiki uruu tomanii waꞌati wuruꞌu synagogue. Uruu idi tuukii wapishaan pugaru pumako kizi uꞌidiꞌiti,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Uruu idi Jesus makon ĩtuma. Aizii ĩmaonapatapaanan puꞌaꞌa naa, uruꞌu naa naobanai dyuudan papaonarunao ikodapaꞌanan Jesus. Naꞌiki udyuudan ĩnaꞌakan paparadan uꞌidiꞌiti, kaikapaꞌa: “Naobanai, aonaa õaipan pumizidinan, aonaa õaipan puwaꞌatin õdapu ati. ");
INSERT INTO wapNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Naꞌiki aonaa umanawunuꞌo mani pidan õgaru, naꞌiki aonaa õturuan õparadaꞌanan naꞌiki õmakon puꞌidiꞌiti manawun. Turuu paꞌan puparadan, naꞌiki karikaonan õpoitoru kakuda kizi. ");
INSERT INTO wapNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Õgaru naꞌapa, õkaudinan doko ainao pidannao õꞌai waranu aꞌo. Õgaru naꞌapa, kainaꞌa soldyaanao kaudinaꞌo õwaranuꞌu kapam. Aizii õkian dono baudaꞌapa soldyaa ati, ‘Pumako,’ umakon nii. Aizii õdapadan dono baꞌoran soldyaa, ‘Puwaꞌati,’ õkian an uꞌati, uwaꞌatin nii. Naꞌiki õdyuudan dono õpoitoru, ‘Pushaꞌapata wuruꞌu,’ õkian an uꞌati, ushaꞌapatan niiz.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tuukii Jesus diꞌitinpan uabatan idi wuruꞌu kaikapaꞌoraz parada-karuꞌu. Sariapa utanawatinan pidannao diꞌiti, wuruꞌu waꞌatipainao kidaz udawuꞌati. Naꞌiki ukian ĩꞌati, “Aizii õkowaadan nii uꞌati: aonaa naꞌiam zii õikodauzon mishida-karu manawun wuru kawanuꞌoraꞌa Israelitenao bii an.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Udaunaꞌan wunaouꞌu naꞌakainaouz parada-karu kiwaꞌakan naa powaa iti, naobanai dapu iti. Aizii ĩkaawan ĩabatan poitorui kakudaꞌakaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kadiman aka uruu daunaꞌan Jesus makon wiizai diꞌiti, Nain kiaꞌo uꞌuu. Aizii pidannao, tominpauzonao uꞌidiꞌiki naꞌiti kapam ĩmakon utuma. Naꞌiki iriba kapam baꞌorainao pidannao makon udawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aizii Jesus kaawan puꞌu wiizai koraratapa-kinao paniinomizinaa idaꞌati, upuꞌu daonaiora mawakaꞌo naꞌaka-kao baaranai iti. Zuna mawakaibaꞌa naa odaiaru, odani wuruꞌu mawakaꞌoraz, ubaudaꞌapan odani wuruꞌu uruuz. Naꞌiki kainaꞌa iriba, iriba pidannao makon otuma. ");
INSERT INTO wapNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aizii Jesus tukapan oroo tuukii ukamunan-kidanuzo, sariapa ukian oꞌati, “Manaꞌa puzaadaꞌanaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Udaunaꞌan umakon naꞌiki upishatan naa wuruꞌu mawakaꞌo naꞌakapa-kinaoaz, sariapa wunaouꞌu naꞌakapainaouz mawakaꞌo mashaadinaꞌakan. Udaunaꞌan ukian mawakaꞌo ati, “Paꞌinaꞌo daonaiora, õkian puꞌati, pukadishita.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sariapa daonaiora sakanataꞌakan naꞌiki uparadan. Udaunaꞌan ukadishitan naꞌiki Jesus naꞌakan naaz padaro dazaba iti. ");
INSERT INTO wapNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tuukii pidannao tarian naꞌiki tuukii ĩdiꞌitinpan. Naꞌiki tuukii kapam ĩkonaukii-kidan Tominkaru. Uruu idi ĩkian, “Ei! Kaawa zii mishi wabii ati umanawunuꞌo Tominkaru prophetin. Mishi Tominkaru kaawan ukaminkaꞌutaꞌanan waunao Jewnao, upidanannaouz,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aizii kuwai, Jesus shaꞌapatanii dauaꞌo kowaadaabiꞌii-kaoaꞌa naa ipai Jewnao wiizi kida kawanaꞌati, naꞌiki ĩwiizi dawun itinapu kidaꞌo pidannao mashaapan, ipai kapam ĩabatan wuruꞌu kuwaiz. ");
INSERT INTO wapNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aizii John abatan idi patominapa-kidaniinao pidannao kakuwaapan ipai wuru dauꞌaꞌa Jesus shaꞌapatanii kidaz aimaakan, sariapa udapadan dyaꞌutam pidannao ĩbii iki. ");
INSERT INTO wapNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Udaunaꞌan udyuudan naa ĩdyaun Naobanai Jesus diꞌiti, naꞌiki udyuuda ĩpishaan Jesus kaikapaꞌa: “Pugaruꞌu naa waꞌatiꞌo niꞌoraz kowaadapa-kao? Oo marii zii wazaudapan baꞌoran waꞌatin?” ");
INSERT INTO wapNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Udaunaꞌan ĩmakon naa Jesus diꞌiti, atii ĩkaawan uꞌidiꞌiti, naꞌiaꞌa naa ĩkian uꞌati, “John Chikaawunuupauzoz dyuudan waunao puꞌidaꞌati, upishaa-kidan naꞌiki uaitapaꞌazon pugaruꞌu naa tawuruꞌu waꞌatiꞌo niꞌoraz kowaadapa-kao? Oo marii zii wazaudapan baꞌoran waꞌatin kainaꞌiki?” ");
INSERT INTO wapNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aizii wuruꞌu ĩkaawanuz naꞌiti, Jesus kaudinan puꞌu karinainao dauꞌu. Ukakudan puꞌaꞌo iriba, iriba pidannao pabiꞌinaaka kidaꞌo ĩrinaa ai, oiaꞌo doronai zaamatapaniinao, ipai ukakudan ĩdyaun, naꞌiki ishaawunnao kida, ipai udaꞌatan naꞌiki usaabaan ĩawun. ");
INSERT INTO wapNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Uruu idi Jesus dakoꞌatin wunao paradanuꞌu John dyuudaniinaouz. Ukian ĩꞌati, “Aizii ukiwa John diꞌiti, ukowaada kizi uꞌati ipai daunuudaꞌu wuruꞌu utukapanii kidaz õshaꞌapatan, naꞌiki ukowaada uꞌati ipai wuruꞌu uabatanii kidaz kuwai. Ukowaada uꞌati iribaꞌa naa ishaawunnao awun daꞌata-kao, naꞌiki saabaa-kao; aizii machiꞌika-kainao, chiꞌika-kida-kao; naꞌiki kabishopauzonao kichanaꞌiki-kiaꞌo bishoi idi, ipai ĩkakuda-kao. Aizii makinao-ziiwanao, kaimanaꞌa naa ĩabatan; naꞌiki mawakainao kida, kakuda-kao powaa iti; aizii patakaꞌutinainao, kowaada-kaoaꞌa naa ĩꞌati Kaimanaꞌo Kuwai. ");
INSERT INTO wapNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Konaukiaꞌo nii manawun wunaouꞌu sariaapaꞌoraz ĩmishidan õgaru, aonaꞌoraz ĩdiꞌitinpan panaꞌiti kida õdauꞌu,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aizii John diꞌikiinao pidannao kiwan daunaꞌan, sariapa Jesus kian wunao atiꞌi iribainaouz pidannao, kasabaꞌukinpainaouz utuma. Ukian ĩꞌati, “Kandii dauꞌatiꞌo tawuruꞌu unao makouzonuz John diꞌiti mapidantakaꞌo amazada diꞌiti? Kandii wuruꞌu utukapaꞌazooniaz naꞌii? Utukapaꞌazon pidan kakataimanaꞌo unyukunuu, awaru dawuu-kidan kawan pinidi? ");
INSERT INTO wapNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kanom dii shaꞌa wuruꞌu utukapaꞌazooniaz naꞌii? Oo utukapaꞌazon pidan konaunamaꞌo oo umanawunuꞌo ukaiwadinpan? Pidan umanawunuꞌo, naꞌiki kaiwadinpaꞌo kaimanaiman, umashaapan kabaun umanawunuꞌo diꞌii? ");
INSERT INTO wapNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Oo kanom shaꞌa wuruꞌu utukapaꞌazooniaz naꞌii? Tominkaru prophetin? Mishiꞌo wuruꞌu, pidan utukapaniaz naꞌii, powaꞌaꞌo zii umanawunun baꞌoran prophetnao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uruu John, dauꞌanaꞌo tawuruꞌu kotuaꞌo Tominkaru Paradan saadauzo-kaoaz kaikapaꞌa: ‘Õdyuudan nii õprophetin kiwiin, saabaaꞌo nii dunapo puꞌuaꞌati,’” ukianuz. ");
INSERT INTO wapNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Udaunaꞌan Jesus kian koshan ĩꞌati, “Õkowaadan nii uꞌati aizii aimaakan, John uruu uwazootapanii ipai, ipai pidannao, aonaa baudaꞌapa pidan kainaꞌa shakatainao wuru baaraꞌaꞌa, uruu kawanuꞌo nii. Mazan pidan, aonaꞌoraz umanawunun Tominkaru naobanai-tinapa-kiziꞌi, upuꞌu umanawunuꞌo uruu John ai,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ipai pidannao naꞌiki wuruꞌu zaamaapauzonao kidaz tax puraatannaa, abatan Jesus paradan, naꞌiki ĩnao tuukii paꞌan ĩmishidan, naꞌiki ĩaitapa mishiꞌo naꞌiki sakitapaꞌo wuruꞌu Tominkaru paradan kidaz. Uruu idiꞌo paꞌan ĩchikaawunuu-kidinan John ati. ");
INSERT INTO wapNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mazan kainaꞌa baꞌorainao pidannao, ĩdakotapa-kao Phariseenao naꞌiki kainaꞌa baꞌorainao tiichaapauzonao Moses kakinaori dauꞌu. Ĩnao aonaa paꞌan ĩshaꞌapatan wuruꞌu Tominkaru aiapanii kidaz ushaꞌapata-kao. Uruu idi aonaa ĩchikaawunuu-kidinan John ati. ");
INSERT INTO wapNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Powaꞌa zii koshan Jesus kian pidannao ati, “Naꞌapa dii mani õkian wunao dauꞌanaꞌa kainaouz pidannao mashaapan? Naꞌapa dii mani õkowaadan oo õdakotan ĩdyaun? Õkian nii. ");
INSERT INTO wapNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ĩnao mashaapan koraiziannao makinaotinan kawanuꞌo, aonaa ĩnyukunuu kaimanaꞌazon baꞌorainao ati. Aizii pamakinaotin kizi iki, koraiziannao kadakoinpauzon paꞌatiaaka kida kaikapaꞌa: ‘Wakunuian mazida-karu kunnaa unao ati kuwudii idaꞌan, mazan aonaa ukonaupan. Aizii Wakunuian mawaka-karu kunnaa uꞌati, aonaa uzaadan,’ ĩkiitaakapan. ");
INSERT INTO wapNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aizii John Chikaawunuupauzo kaawan dono daꞌatiꞌi, aonaa unikauzon kaimanaꞌo wanyukunui wuruꞌu baꞌoran pidannao nikauzonii kaduz kidaz, naꞌiki aonaa utuzan wine. Uruu idi unao kian udauꞌan. ‘Kainaꞌa oiaꞌo doronai uꞌidaꞌa.’ ");
INSERT INTO wapNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aizii Daonaiora Aokazi Ikiꞌo, ukaawan daꞌatiꞌi, ipai paꞌan uaroopan, naꞌiki utuzan bishoaꞌo wine. Uruu idi unao kian udauꞌan. ‘Aushaa utukapa, kashabakizi paꞌan arawuꞌu, naꞌiki tuzapa-shori kapam. Naꞌiki unaudapa kapam pakaminaudaꞌu-tinpan wunao idiꞌi zaamaapauzonaouz tax puraatannaa, naꞌiki oiainao pidannao tuma.’ ");
INSERT INTO wapNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mazan ipai pidannao wuruꞌu daꞌanainao kidaz Tominkaru paradan, ĩnao tukapa-kidan mishiꞌo wuruꞌu Tominkaru aitapanii kidaz oo wuruꞌu ushaꞌapaapanii kidaz aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Aizii kainaꞌa Pharisee, unaꞌakan Jesus, uaroapa-kidaꞌazoonuzu padapu ii. Uruu idi Jesus makon utuma udapu iti, naꞌiaꞌa naa usakanatan naꞌiki uaroopan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Uruu wiizai diꞌii kainaꞌa zunaaba madoronaa-daunuꞌo omashaapauzon. Aizii oabatan idi Jesus aroopaꞌazon Pharisee dapu ii, sariapa omakon naꞌiti, onaꞌakan kaduunuribai pakinnaa zoꞌan kuba idiꞌi utoma-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Okaawan Jesus kidiba diꞌiti ubarau itinapu. Ozaadan tuukii, uruu idi ipai ozabian Jesus kidiba paawun uu idi. Udaunaꞌan oaradan naa ukidiba padizo idi naꞌiki sariapa okissitan wuruꞌu ukidiba kidaz, udaunaꞌan oramaudan naa ukidiba kaduunuꞌoraz ramau idi. ");
INSERT INTO wapNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aizii Pharisee, wuruꞌu naꞌakaꞌoraz Jesus padapu ati, tukapan wuruꞌu zun shaꞌapatanuz aimaakan naꞌapa Jesus ati. Sariapa ukian panyukunuu ii, “Umishiin an mani diꞌoraz daonaiora Tominkaru prophetin, uaitapa mani naꞌapaꞌoram okaduz wuruꞌu zunaz pishataꞌoraz paugaru. Naꞌiki uaitapa mani ipai naꞌapam omashaapauzon naꞌiki wuruꞌu oii kidaꞌoraz aimaakan oshaꞌapaapauzon.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sariapa Jesus paradan, naꞌiki ukian uꞌati, “Simon, kainaꞌa aimaakan õkowaadaꞌazon puꞌati.” “Tiichaa, naꞌapaꞌoram aimaakan wuruꞌu pukowaadaꞌazooniaz õꞌati?” Simon kian. ");
INSERT INTO wapNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus kian uꞌati, “Kainaꞌa dyaꞌutam pidannao mawinipinaatapainao pidan. Baudaꞌapa mawinipinaatapan 500 wiziꞌi kidaꞌo puraata, baꞌoran mawinipinaatapan 50 wiziꞌi kidaꞌo puraata. ");
INSERT INTO wapNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aonaa baudaꞌapa ĩnao kaꞌiitan pakawadauntan powaa iti wuruꞌu pamawinipinaatapaniaz puraata. Uruu idi pidan wuruꞌu taaꞌoraz zii puraata ĩꞌati, umarinaꞌataꞌakan naa wuruꞌu ĩmawinipinaatapaniaz. Aonaꞌo niꞌi naa uaipan uwadaun oo unyukunuupaꞌakan powaꞌa wuruꞌu ĩmawinipinaatapaniaz. Ukauꞌan, naꞌiaꞌoram nii puaitapan marainapa tuukii wuruꞌu marinaꞌataꞌoraz pamawinipinaatapa-kao?” ");
INSERT INTO wapNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon dakoꞌatin, naꞌiki ukian, “Õzauda-kidan wuruꞌu mawinipinaatapaꞌo uruu dobata manawun, uruꞌo nii marainapa uruu tuukii.” “Naꞌapa mishizi, sakitapaꞌo kaiwuruꞌu pudiꞌitinapanuz,” Jesus kian Simon ati. ");
INSERT INTO wapNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Udaunaꞌan Jesus tanawatinan zunaaba diꞌiti, naꞌiki ukian Simon ati, “Putukapa diꞌoraz zunaabaꞌa, mishii? Õmorotan pudapu ati, aonaa putaan wunu õꞌati õchikaa-kinaa nii õkidiba. Mazan oroo, okaawan daꞌatiꞌi, ozaadan atii ochikaan õkidiba paawun uu idi. Udaunaꞌan oaradan õkidiba padizo idi. ");
INSERT INTO wapNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","Naꞌiki aonaa pukissitan õgaru, mazan oroo pakaawan diꞌikiꞌo aonaa osookadan pakissiipan õkidiba. Naꞌiki aonaa putaan õramauda-kinaa nii õzowau, mazan oroo oramauda zii õkidiba. ");
INSERT INTO wapNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aizii õkowaadan nii puꞌati aimaakan,” Jesus kian. “Wuruꞌu oshaꞌapatanuz aimaakan kaikapaꞌa, otukapa-kidan naꞌapam pamarainpan õgaru tuukii. Ushaꞌapanum kauꞌan oꞌoian wuruꞌu tuubaruꞌoraz manawun mainaabata-kao idi ipai daunuudaꞌu oꞌai. Mazan aizii pidan masakaudaꞌuꞌo uꞌoian, aizii uꞌoian mainaabata-kao an, masakaudaꞌuꞌo nii kapam umarainpan õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Udaunaꞌan Jesus kian zunaaba ati, “Aizii ipai daunuudaꞌuꞌu naa puꞌoian mainaabataꞌaka-kao, aonaꞌo nii powaꞌa unyukunuuapa-kao.” ");
INSERT INTO wapNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sariapa pidannao wuruꞌu sakanatapainao kidaz utuma kiitaakapan paꞌatiaaka kida, “Kandii mooko arawuꞌu turuu mooko uaitapan pamainaabatan pidan oian?” ");
INSERT INTO wapNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mazan Jesus kian zun ati, “Pumishidan idiꞌo wuruꞌu, pukazannaatinanuz puꞌoian ai. Aizii pukiwaꞌa naa, kaiman punyukunuu aizii, naꞌiki aonaa kanom powaꞌa kasharutapaꞌo nii pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Udaunaꞌan Jesus makon naa, uchiꞌikapan ipai donoi naꞌiki wiizai kida kawanaꞌati. Wuruꞌu uchiꞌikapanuz ukowaadapan Kaimanaꞌo Kuwai, Tominkaru naobanai-tinan dauaꞌo. Aizii 12 utominapa-kidaniinaouz, naꞌiiꞌaka kapam ĩchiꞌikapan utuma. ");
INSERT INTO wapNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Naꞌiki zunnao, tawuruꞌu ukakudaniinao kidaz parinaa ai, naꞌiki baꞌorainao ukakudaniinao oiaꞌo doronai zaamatapan ai ĩdyaun, naꞌiti kapam pabiꞌi kida ĩnao makon, ĩkaminkaꞌuupan Jesus naꞌiki wuruꞌu utominapa-kidaniinaouz. Mary, Magdala sanaaba, Jesus soꞌotaniaz 7 oiaꞌo doronainao oꞌai, oroo wuruꞌu kaminkaꞌuupaꞌoraz ĩdyaun, ");
INSERT INTO wapNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","naꞌiki Joanna oroo Chuza kiaꞌoraz odaiaru uu, kazowautapaꞌoraz pabiꞌi kida Herod poitorunao. Naꞌiki Susanna naꞌii kapam, naꞌiki iriba baꞌoran zunnao kida naꞌii ĩtuma. Ipai ĩshaꞌapatan aimaakan, ĩtaan papuraatan, naꞌiki aimaakan sodi kida paaipan ati, pakaminkaꞌuta-kinaa nii Jesus naꞌiki utominapa-kidaniinao. ");
INSERT INTO wapNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pidannao kaawan iriba, iriba Jesus idaꞌati, naꞌiki iriba kapam baꞌoran wiizai ikiinao kida kaawan. Aizii pidannao baokopatinan daunaꞌan, uruꞌu naa Jesus kakuwaapan naa ĩꞌati diꞌitinapa-kinai kuwai idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ukian, “Baudaꞌapa kamoo pidan makon pazakapun iti upaowaꞌanan poroom uuda kida. Aizii kawiizii-kariwai baara an, uruꞌu naa upararaan poroom uuda. Pabiꞌi kida poroom uuda waotan chiꞌikapa-kizai an, uruu idi ipai udakazaabiꞌii-kao. Udaunaꞌan kotuꞌuznao waꞌatin naꞌiki ipai ĩnikan wuruꞌu uudai kidaz. ");
INSERT INTO wapNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Baꞌoran uudai kida waotan kubataꞌo baawu an. Mishi kaiman padamata uudai sodaꞌakan mazan aonaa naꞌitim uꞌishatabaꞌu zaamatinan, udaunaꞌan kamoo wiichaꞌakan naa, uruu idi sariapa uaradan atii umaririn. ");
INSERT INTO wapNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Baꞌoran uudai kida waotan kaiwada-karu taꞌo baara an. Mishi kaiman padamata usodaꞌakan, mazan udaunaꞌan, kaiwada-karu watudaꞌakan naa wuruꞌu paꞌinaꞌoraz usodan kida. Uruu idi aonaa naꞌitim naa ĩdyaupain. ");
INSERT INTO wapNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Baꞌoran uudai kida, kaiman paꞌan ĩwaotan kawiizii-kariwai baara an. Uruu idi ziwu ĩsodan, udaunaꞌan ĩkaakaꞌakan naa madowaaka kida paꞌidiwaru, naꞌiki diriꞌi shinibaba kida uꞌaka. Baudaꞌapaꞌo ukadunaa diꞌiki, uikoda 100 uꞌaka diriꞌin.” Udaunaꞌan Jesus kian naa pidannao ati, “Pukakinaon an puabataꞌa naa kakinaorii!” ");
INSERT INTO wapNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Udaunaꞌan Jesus tominapa-kidaniinao pishaan naa uruu, naꞌapaꞌoram manawun wuruꞌu diꞌitinapa-kinai kuwaiz, ukowaadaniaz ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Uruu idi ukian ĩꞌati, “Soo unao atiꞌo nii ukainaabata-kao wuruꞌu diꞌitinapa-kinai kuwaiz, Tominkaru naobanai-tinan dauaꞌoraz. Mazan wunao atiꞌi baꞌorainao kidaz ukowaada-kao nii soo diꞌitinapa-kinai kuwai idaꞌan. Uruu idi ĩtukapan puꞌu padamata wuruꞌu kadakotin-kizaiz, mazan upuꞌu aonaꞌo nii ĩtukapanuzu. Ĩabatan puꞌu padamatazu, mazan upuꞌu, aonaꞌo nii ĩaitapan naꞌapaꞌoram wuruꞌu parada-karu kianuz. ");
INSERT INTO wapNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kaikapaꞌa wuruꞌu diꞌitinapa-kinai kuwaiz,” Jesus kian ĩꞌati, “Aizii wuruꞌu uudai kidaz, Tominkaru paradan kida wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aizii wuruꞌu uudai kida waotaꞌoraz chiꞌikapa-kizai an, uruu pidannao dauꞌanaꞌo, wuruꞌu abatainao kidaz Kaimanaꞌo Kuwai. Mazan udaunaꞌan Satan kaawan ĩꞌidaꞌati, uruu idi sariapa umainaabatan ipai daunuudaꞌu ĩnyukunuu iki wuruꞌu Kaimanaꞌoraz Kuwai kida. Ushaꞌapanum kauꞌan aonaa uaipan ĩmishidan, naꞌiki aonaa uaipan ĩkazannaatinan paꞌoian ai. ");
INSERT INTO wapNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Aizii uudai kida wuruꞌu waotaꞌoraz kubataꞌo baawu an, uruu pidannao dauꞌanaꞌo, wuruꞌu konaukiaꞌoraz ĩabatan naꞌiki ĩzaamatan padamata Kaimanaꞌo Kuwai. Mazan aonaa ĩzaamatan tuukii panyukunuu iti wuruꞌu parada-karu kidaz. Uruu idi masakaudaꞌu aimaakan dikaudaꞌo shaꞌapaꞌakan ĩꞌati, uruꞌu naa ĩkashadinaꞌakan, aonaꞌa naa powaꞌa ĩmishidapaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Aizii uudai kida wuruꞌu waotaꞌoraz kaiwada-karu baawu an kida, uruu pidannao dauꞌanaꞌo, wuruꞌu abatainao naꞌiki mishidainao kidaz Kaimanaꞌo Kuwai. Mazan ĩdiꞌitinpan aimaakan aiapa-kao dauꞌu, naꞌiki kashaꞌapauzi-karu dauꞌu, naꞌiki ĩaipaa-biꞌian ipai pabiꞌinaaka sodi kidaꞌo aimaakan. Uruu idi ĩmanyukunuutan naa wuruꞌu kuwaiz. Naꞌiki aonaꞌa naa ĩshaꞌapainpan kaiman kuwai kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Aizii uudai kida wuruꞌu waotaꞌoraz kaiman, kawiizii-kariwai baara an, uruu pidannao wuruꞌu abatainao naꞌiki zaamatainao kidaz parada-karu kaimanaiman manawun panyukunuu iti. Ĩizoꞌati ipai parada-karu, uruu idi aonaa ĩkashadinan. Ushaꞌapanum kauꞌan kaiman ĩnyukunuu dyaupain Tominkaru ati. Uruu idi kaiman mishi ĩmashaapan tukapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Aonaa naꞌiaꞌoram pidan suuauzon lamp, udaunaꞌan utaratanuzu boon idi, oo umuudanuz bed waranu iti. Mishiꞌoraiman lamp suu-kao dono, umuuda-kao dokoꞌo ukanadapa kizi kaiman. Aizii pidannao morotan an, kaimanaꞌo nii ukanadapan ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Naꞌiki ipai aimaakan dizapa-kariwai ushaꞌapaapa-kao, ipaiꞌo nii ukodita-kida-kao kainaabanaꞌo-karu ati. Naꞌiki ipai aimaakan dizapa-kariwai ipaiꞌo nii ukodita-kida-kao kanadaꞌo-karu ati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ukauꞌan udiꞌitapa naꞌiki uzaamata unyukunuu iti wuruꞌu uabatanii kidaz parada-karu. Ushaꞌapanum kauꞌan pidan kainaꞌaꞌo utaapan aimaakan panyukunuu ii, taa-karu nii uꞌati powaꞌa zii. Aizii wuruꞌu pidan, aonaꞌoraz utaan aimaakan panyukunuu iti, zaamata-karu nii uꞌai ipai daunuudaꞌu wuruꞌu masakaudaꞌuꞌoraz aimaakan utaapan panyukunuu idaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Udaunaꞌan Jesus daro naꞌiki uꞌinawuzunao kaawan ĩtukapaꞌazon uruu. Mazan aonaa naꞌitim ĩmaonapadinan udazaba iti, ushaꞌapanum kauꞌan iriba manawun pidannao kasabaꞌukinpan udazaba an kida. ");
INSERT INTO wapNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Uruu idi baudaꞌapa pidan kian Jesus ati, “Kainaꞌa pudaro naꞌiki puꞌinawuzunao kadishitapan paniba ii, ĩtukapaꞌazon pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sariapa Jesus kian ipai pidannao ati, “Õdaro naꞌiki õꞌinawuzunao paꞌan wuruꞌu abatainaouz naꞌiki izoꞌatiinaouz Tominkaru paradan.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Baudaꞌapa kamoo Jesus paidinan kanawa zoꞌiti patominapa-kidaniinao tuma. Naꞌiki ukian ĩꞌati, “Aushaa wamakoꞌo naa karishii baza iti.” Uruu idi ĩmakoꞌokan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aizii ĩmakopaanan puꞌu, Jesus daꞌawuꞌukan naa kanawa zoꞌii. Mashaꞌapakiaka maꞌozakaꞌo awaru kaawan. Sariapa wunu paran kida daawadaan ĩkanawan, atii wunu paidinaꞌakan naa ĩkanawan zoꞌiti. Maonapaꞌa naa kanawa tipitan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sariapa Jesus tominapa-kidaniinao makon uꞌidiꞌiti, ĩpokowauanuzu. Naꞌiki ĩkian uꞌati, “Wanaobanaa! Wanaobanaa! Kadiman! Taaꞌazoꞌo naa wanaraan,” ĩkian. Udaunaꞌan Jesus kadishitaꞌakan, naꞌiki udyuudan awaru naꞌiki wunu paran mashaadinan. Sariapa mishi awaru naꞌiki wunu paran mashaadinaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Udaunaꞌan Jesus kian patominapa-kidaniinao ati, “Naꞌapaꞌoram mooko wuruꞌu umishidanuz?” Mazan tuukii ĩtarian, naꞌiki tuukii ĩdiꞌitinpan. Ĩkian paꞌatiaaka kida, “Ei! Kanom kaduz pidan uruu? Udyuuda zii awaru naꞌiki wunu paran mashaadan, atii ĩizoꞌati zii uparadan,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesus naꞌiki utominapa-kidaniinao makopaanan karishii baoko an, atii ĩkaawan baza itinapu wiizai diꞌiti, Gerasa Baara kiaꞌo uꞌuu, Galilee Baara paꞌinamunuꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aizii Jesus maratinaꞌakan zii kanawa zoꞌiki, uruꞌu naa pidan, donoi ikiꞌo, oiaꞌo doronainao zaamatapanii kaawaꞌakan Jesus idaꞌati. Kotuaꞌikiꞌoraꞌa naa aonaa ukaiwadan kamicha, naꞌiki aonaa umashaapauzon kabaun ii. Umashaapan baaranai ii aka, kuba uun ii aka karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aizii utukapan Jesus, sariapa ukadakoꞌokan, udaunaꞌan ukodoruꞌukan naꞌiki umapotinan Jesus kanaapu iti. Naꞌiki ukian diiwaꞌo idaꞌan, “Jesus, Tominkaru umanawunuꞌo dani, kanom puaipan õꞌai, naꞌapa dii pushaꞌapataꞌazon õgaru? Aonaa shoman pupatakaꞌutaꞌanaꞌa õgaru,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wuruꞌu uparadanuz kaikapaꞌa Jesus dyuudan idiꞌo oiaꞌo doronainao koditan uꞌai. Kiwiin, mapuduꞌo daꞌi oiaꞌo doronainao tuukiidauzonuzu. Pidannao tiwaan puꞌu padamata padodowan ipai uanoba naꞌiki utabaꞌu chain idi, mazan sariaapaꞌo nii ubiditaꞌakanuzu. Uruu daunaꞌan oiaꞌo doronainao naꞌakaꞌakan niꞌi naa uruu, mapidantakaꞌo amazada baara iti. Uruu wuruꞌu paradaꞌoraz Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus pishaanuzu, “Naꞌapa dii puꞌuu?” “Õꞌuu Iribainao,” ukian. Ukowaadan paꞌuu naꞌapa ushaꞌapanum kauꞌan iriba, iriba manawun oiaꞌo doronainao morotan naa uꞌidiꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Naꞌapain tuukii oiaꞌo doronainao pishaan Jesus, aonaa kizi udyuudan ĩdyaun kaꞌunaru nazo iti, aonaꞌoraz utokon nii. ");
INSERT INTO wapNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naꞌiaꞌo iriba kooshinao aroapatinan naawazi zaꞌan. Uruu idi oiaꞌo doronainao pishaan Jesus tuukii. “Pukashaapa shoman wamorotan kooshinao diꞌiti,” ĩkian. Jesus kashaapa ĩmorotan kooshinao diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Uruu idi ĩkoditaꞌakan naa pidan diꞌiki naꞌiki ĩmorotaꞌakan naa kooshinao diꞌiti. Sariapa kooshinao dimaꞌakan naa tawudapu an, naꞌiki ipai ĩwaotan karishii baoko iti. Uruu idi ipai ĩmawakan panaraan idi. ");
INSERT INTO wapNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aizii pidannao, wuruꞌu taapainaouz kooshinao tukapan idi wuruꞌu aimaakan shaꞌapanuz kaikapaꞌa, sariapa ĩdiman ĩkakuwaapaꞌanan. Uruu idi ĩkakuwaapan pidannao ati ipai donoi ii aka, naꞌiki kazakapuntinpainao ati donoi dawun ii aka. Ipai ĩkowaadan patukapan kawanaꞌati ushaꞌapan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Uruu idi iriba pidannao makon naꞌiti ĩtukapaꞌanan wuruꞌu kowaada-kariwaiz aimaakan shaꞌapan. Aizii ĩkaawan Jesus idaꞌati, ĩtukapa pidan wuruꞌu soꞌota-kariwaiz oiaꞌo doronainao uꞌidiꞌiki, aonaꞌa naa ushaꞌapan, naꞌiki kainaꞌaꞌa naa ukaiwadapan kamicha. Kaiman usakanatapan Jesus dazabaꞌa, aitapinaꞌa naaz, naꞌiki kaimanaꞌa naa udiꞌitinpan. Uruu idi tuukii pidannao tarian. ");
INSERT INTO wapNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pidannao wuruꞌu tukapainaouz aimaakan shaꞌapan, ĩkakuwaapan naa baꞌoran pidannao ati. Ĩkowaadan ĩꞌati naꞌapaꞌoram ukakuda-kao wuruꞌu oiaꞌo doronai zaamatapaniaz pidan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Uruu idi ipai pidannao kawiizi-tinpainao kidaz donoi Gerasa Baara an kida, tuukii ĩpishaan Jesus makon pawiizi iki. Ushaꞌapanum kauꞌan tuukii manawun ĩtarian. Uruu idi Jesus paidinan naa kanawa zoꞌiti naꞌiki umakoꞌokan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wuruꞌu pidan soꞌota-kariwaiz oiaꞌo doronainao uꞌidiꞌiki, tuukii upishaan Jesus. “Õmako kizi putuma,” ukian. Mazan Jesus kian uꞌati, ");
INSERT INTO wapNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pukiwaꞌa naa shoman pudapu iti, pukowaadaꞌan kiziꞌi naa naꞌapam Tominkaru shaꞌapatan kaimanaꞌo manawun aimaakan puꞌati.” Uruu daunaꞌan pidan makoꞌokan naa. Aizii pamakopa-kizi donoi ii aka, ipai ukowaadan pidannao ati wuruꞌu Jesus shaꞌapataniaz paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aizii Jesus naꞌiki utominapa-kidaniinao kiwan karishii baza itinapu. Naꞌii iriba pidannao dapaapan uruu, ushaꞌapanum kauꞌan tomunuꞌoraꞌa naa ĩzaudapanuzu. ");
INSERT INTO wapNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Udaunaꞌan pidan Jairus kiaꞌo uꞌuu kaawan Jesus idaꞌati, uruu kazowautapauzo synagogue Jewnao ati pawiizi ii. Ukaawan, sariapa ukodoruꞌukan, naꞌiki udawukan Jesus kanaapu iti ukidiba idaꞌa. Tuukii unaꞌakan uruu padapu iti. ");
INSERT INTO wapNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ushaꞌapanum kauꞌan, udani zun baudaꞌapauzo, 7 owunun, karinaan tuukii, maonapaꞌoraꞌa naa omawakan. Aizii Jesus makopaanan puꞌaꞌa naa, iriba pidannao kasabaꞌuinan udazaba an. ");
INSERT INTO wapNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aizii pidannao biiꞌi kainaꞌa zunaaba, izaipaiba, 12 wunuꞌoraꞌa naa obaiatinan. Iribaꞌa naa omakon daakataanao diꞌiti. Mazan aonaa baudaꞌapa daakataa kakudaꞌo nii oroo. Naꞌiki ipaiꞌi naa otaan papuraatan ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uruu dono owaꞌatin pidannao bii an Jesus barau ikinapa. Sariapa opishatan uchaakitan danoma karikaonan. Sariapa oizaipan shabataꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mashaꞌapakiaka Jesus kian, “Kanom pishataꞌoraz õgaru?” Mazan ipai pidannao wuruꞌu udazaba an kidainaouz kian, “Aonaa wapishatan pugaru.” Uruu idi Peter kian, “Wanaobanaa, kainaꞌa iriba pidannao pudazaba an.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“Mazan kainaꞌa pidan pishataꞌo õgaru, õaitapa, ushaꞌapanum kauꞌan soꞌotinanaaka maꞌozaka-karu õꞌidiꞌiki,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aizii zun aitapan idiꞌi naa paaitapaꞌaka-kao, sariapa omaonapadinan panaka-nakaan biiꞌi Jesus dazaba iti, atii okodoruꞌukan naꞌiki odawukan ukanaapu iti, oawun imiꞌi baara iti. Ipai pidannao abatapan puꞌu, uruꞌu naa okowaadan kanom niꞌo wuruꞌu opishatanuz Jesus kamichan. Okowaadan papishatan idi ukamichan karikaonan sariapa oabatan izai dukutaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Udaunaꞌan Jesus kian oꞌati, “Õdadakoo, pumishidan idiꞌo pukakudan. Aizii pukiwaꞌa naa, kaiman punyukunuu aizii, naꞌiki aonaa kanom powaꞌa kasharutapaꞌo nii pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus kadakotinan puꞌu zii oꞌati, uruꞌu naa pidan kaawaꞌakan kakuwaapaꞌanaꞌo Jairus idaꞌati, udapuꞌu ikiꞌo uwaꞌatiꞌikan wuruꞌu pidanaz. Ukian uꞌati, “Marinaꞌa naa Tiichaa, mawakaꞌakaꞌa naa pudani.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mazan Jesus abata wuruꞌu pidan kakuwaapanuz Jairus ati. Uruu idi ukian uꞌati, “Manaꞌa putariaꞌanaꞌa, mazan pumishida paꞌan õgaru, kakudaꞌo nii powaa iti wuruꞌu pudaniz.” ");
INSERT INTO wapNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Udaunaꞌan ĩmakoꞌokan naa naꞌiti atii ĩkaawan kabaun iti. Naꞌii ĩikoda iriba pidannao zaadinainao, diiwa ĩkadakoinan, uruu ĩmuraapan naa wuruꞌu mawakaibazo. Uruu idi Jesus kian ĩꞌati, “Manaꞌa uzaadaꞌanaꞌa, aonaa omawakan mani wuruꞌu, soo odaꞌawun karikaonan.” Ĩshaazootinan mazan udauꞌu, pabanikian nii ĩtaapan wuruꞌu uparadanuz, ushaꞌapanum kauꞌan ĩaitapa mawakaꞌakaꞌoraꞌa naa wuruꞌu zunaabaz. Udaunaꞌan Jesus morotan naa mawakaiba diꞌiti, mazan aonaa utaapadan baꞌoran pidannao kida morotan patuma. Soo umorota-kida patuma Peter, John, James naꞌiki mawakaiba daru naꞌiki odaro. ");
INSERT INTO wapNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Aizii ĩkaawan mawakaiba diꞌiti, sariapa Jesus zaamatan okaꞌu naꞌiki uparadan oꞌati. “Pukadishita koraidaonaa,” ukian oꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sariapa okakudaꞌakan powaa iti, udaunaꞌan okadishitaꞌakan. “Utaa owanyukunuu nii,” Jesus kian odaronao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tuukii odaronao diꞌitinpan. Uruu idi Jesus kian ĩꞌati, “Manaꞌa paꞌi ukowaadaꞌanaꞌa wuru dauꞌanaꞌa õshaꞌapatanuz aimaakan kaikapaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus dapadan 12 patominapa-kidaniinao baokopa paꞌidaꞌati. Naꞌiki utaa ĩꞌati maꞌozaka-karu, ĩkaꞌiita-kinaa nii pasoꞌotan oiaꞌo doronai kida pidannao ai, naꞌiki turuu kizi ĩsoꞌotan pabiꞌinaaka kidaꞌo rinai pidannao diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Udaunaꞌan udyuudan naa ĩmakon ĩkowaadaꞌan kiziꞌi naa kuwai Tominkaru naobanai-tinan dauꞌu, naꞌiki ĩkakudaꞌan kizi ipai karinaapainao kida pidannao. ");
INSERT INTO wapNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aizii padyuudan uaꞌii ĩdyaun, ukian ĩꞌati, “Manaꞌa paꞌi unaꞌakaꞌanaꞌa aimaakan kida utuma umakon an. Manaꞌa unaꞌakaꞌanaꞌa uwadookori, oo usaakon, oo uwanyukunuu, naꞌiki aonaa unaꞌakaꞌanaꞌa upuraatan kida, naꞌiki aonaa unaꞌakaꞌanaꞌa baꞌoran ushootan. ");
INSERT INTO wapNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Naꞌiam udapaapa-kao kaiman, naꞌii usookadin uruu kabaun diꞌii, atii udobataꞌazon kawanaꞌati baꞌoran wiizai iti. ");
INSERT INTO wapNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mazan naꞌiaꞌoram pidannao aonaꞌo ĩnaubaan oo ĩaipan ukaawan pawiizi ati, manaꞌa usookadinaꞌanaꞌa naꞌii, mazan uparaudaꞌaka imiꞌi ukidiba iki kida umakon uaꞌii ĩwiizi iki. Uruu idaꞌan utukapa-kidan ĩꞌati ĩpatakaꞌuta-kao nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesus ipaian daunaꞌan pakakinaopan ĩdyaun, ĩmakon naa. Naꞌiki ĩkowaadapan naa Kaimanaꞌo Kuwai Jesus dauꞌu ipai wiizai kida kawanaꞌati, naꞌiki iriba ĩkakudan karinainao pidannao ipai amazada kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aizii naobanai Herod kazowautapaꞌoraz ipai amazada Galilee Baara ii aka, uabatan naa kadakotin-karu ipai wuru dauꞌanaꞌa Jesus shaꞌapaapanii kidaz aimaakan. Tuukii kowaadapa-kariwaiz kida kasharutapan unyukunuu. Ushaꞌapanum kauꞌan kainaꞌa pabiꞌi kida uabatan pidannao kian, “John tawuruꞌu chikaawunuupauzoz, uruu wuruꞌu kakudaꞌoraz powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aizii uabatan baꞌorainao kian, “Elijah wuruꞌu kakudaꞌoraz powaa iti.” Baꞌorainao kian, “Kotuaꞌo Tominkaru prophetin wuruꞌu kakudaꞌoraz powaa iti,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Uruu idi Herod kian, “Ei, õdukuta-kidaꞌa naa shaꞌatii John kanau. Kandiꞌi naa mooko pidannao kadakotin-kidaniaz?” Uruu idi tuukii Herod aipan patukapan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aizii wuruꞌu 12 Jeusu tominapa-kidaniinaouz, udyuudaniinaouz kaawan naa powaa ati. Uruu idi ĩkakuwaapan naa Jesus ati. Ipai ĩkowaadan uꞌati pashaꞌapatanii kida aimaakan dauꞌan, pachiꞌikapa kizi wiizai kida kawanaꞌati. Uruu daunaꞌan Jesus naꞌakan ĩdyaun, ĩmakon naa baꞌoran pidannao ai. Unaꞌakan ĩdyaun munapoꞌo wiizai diꞌiti, Bethsaida kiaꞌo udakotapa-kao wiizai dawun itinapu. ");
INSERT INTO wapNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iriba pidannao abatan wuruꞌu Jesus makonuz naꞌiti. Uruu idi iriba, iriba pidannao daꞌanan Jesus naꞌiti. Aizii ĩkaawan naꞌiti tuukii Jesus konaukii-kidan ĩdyaun. Naꞌiaꞌa naa ukakuwaatinan ĩꞌati, ukowaadapan naa ipai daunuudaꞌu Tominkaru naobanai-tinan dauꞌu. Naꞌiki ukakuda ipai daunuudaꞌu pidannao wuruꞌu aipainao kidaz pakakuda-kao parinaa ai. ");
INSERT INTO wapNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ĩnaꞌian utuma atii wachuupun. Aizii 12 Jesus tominapa-kidaniinaouz, tuukiaꞌa naa ĩdopian ĩtukapan idiꞌi naa wachuupun. Sariapa ĩwaꞌatin Jesus idaꞌati, naꞌiki ĩkian uꞌati, “Pudyuudaꞌa naa shoman wuruꞌu pidannaouz marii kiziꞌi naa ĩmakon ĩdawataꞌan kizi padaꞌawu-kizi nii naꞌiki pawanyukunuu nii wunao diꞌitiꞌi kawiizi-tinpainao kidaz kaidaꞌanaꞌa, naꞌiki baꞌorainao mako kizi maonapa zaa kidaꞌo wiizai diꞌiti. Ushaꞌapanum kauꞌan daꞌaꞌorazuꞌu amazadaꞌaꞌo karikaonan wuruꞌu waunaouz,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mazan Jesus kian ĩꞌati, “Unao mishiꞌoraiman taa ĩwanyukunuu nii.” Mazan ĩkian uꞌati, “Kainaꞌa bakaꞌiaudaꞌu sodi karikaonan bread, naꞌiki dyaꞌutam kopaunao sodi kida. Oo puaiapa shaꞌa watoriankan wanyukunui wapaa-kinaa nii ipai daunuudaꞌu wuruꞌu iribaꞌoraz pidannao?” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Uruu dono iriba, iriba pidannao kaawan, aonaa ĩaita-kao kawanaꞌati. Daonaioranao paꞌidiwaru ikoda mani 5000 ĩdyaun. Udaunaꞌan Jesus kian patominapa-kidaniinao ati, “Udyuuda ipai pidannao katontinan panaꞌa kida, marii 50 kida ĩkasabaꞌukinan. Naꞌiki marinaꞌa naa ĩsakanatan kida naꞌii.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aizii ĩipaian daunaꞌan pakatontin-kidan pidannao, ");
INSERT INTO wapNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","uruꞌu naa Jesus zaamatan wuruꞌu bakaꞌiaudaꞌuꞌoraz breadnao naꞌiki wuruꞌu dyaꞌutamaꞌoraz kopaunao sodi kida. Uzaamatan daunaꞌanazu, sariapa uawunuupan aokazi iti patoriinpan tuma, “Kaimanaꞌo pugaru Tominkaru, putaan idi wanyukunui.” Udaunaꞌan udushowan naa wuruꞌu bread naꞌiki kopaunao kidaz, naꞌiki utaan naaz patominapa-kidaniinao ati, marii kiziꞌi naa ĩtaanuzu ipai pidannao kawanaꞌati kida. ");
INSERT INTO wapNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Uruu dono ipai pidannao aroopan abaapa kida, atii 12 dazowan udiriꞌin zii Jesus tominapa-kidaniinao zawadan wanyukunui waꞌakun. ");
INSERT INTO wapNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Baudaꞌapa kamoo Jesus toriinpan puꞌu pabaꞌoran, utominapa-kidaniinao kaawan uꞌidaꞌati, sariapa upishaan ĩdyaun kaikapaꞌa: “Naꞌapa dii pidannao kian õdauꞌan, kanom ĩkowaadan õgaru?” ");
INSERT INTO wapNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aizii ĩkian uꞌati, “Pabiꞌi kida pidannao kian pugaru, John Chikaawunuupauzo. Baꞌorainao kian pugaru Elijah. Baꞌorainao kian pugaru kotuaꞌo Tominkaru prophetin wuruꞌu, kadishitaꞌoraz pamawaka-kizi iki.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Aizii unao mani, kanom uaitapan õgaru?” ukian ĩꞌati. Sariapa Peter dakoꞌatin uparadan, “Pugaru Christ, Tominkaru diꞌikiꞌo,” ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mazan Jesus kian, “Manaꞌa paꞌi ukowaadaꞌanaꞌa pidannao ati õgaru dauꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Naꞌiki ukian ĩꞌati, “Daonaiora Aokazi Ikiꞌo kashaꞌoraꞌo nii manawun ubaiaapan. Naꞌiki tuukiaꞌo nii ukashada-kao, aonaꞌo nii uaiapa-kao. Kazowautapainao Jewnao, faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, ĩnaouꞌo nii wuruꞌu kashadaꞌoraz uruu. Atii uzowii-kao nii, mazan idikinaudaꞌutan kamoo idaꞌa ukadishitan nii ubaaranaa iki,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Uruu daunaꞌan Jesus kian ipai ĩnao ati, “Kanom daꞌanaꞌazoꞌo õgaru, marii umarinaꞌatan panaudapanii pashaꞌapaapan, naꞌiki marii unaꞌakan pacrossannaa, naꞌiki marii udaꞌanan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ushaꞌapanum kauꞌan naꞌiaꞌoram pidan mamuudaꞌazoo-kaꞌo wuruꞌu pamashaapanuz panyukunuu aipan kawanaꞌati kai, mazan upuꞌaꞌo nii uwaziwadan ipai wuruꞌu pamamuudaꞌazookanii. Mazan pidan marinaꞌataꞌo wuruꞌu pamashaapanuz panyukunuu aipan kawanaꞌati kai, naꞌiki kashaapaꞌo pazowii-kao õdikin ii. Mishiꞌo nii paꞌan udoronaa kazannaata-kao, naꞌiki karikaonanuꞌo nii paꞌan umashaapan Tominkaru tuma. ");
INSERT INTO wapNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Aonaa kanom pidan ikodan uzaamatan an ipai aimaakan imiꞌi baara an kidaꞌo, uwaziwainan puꞌu karikaonanuꞌo kakupa-karu ai. ");
INSERT INTO wapNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Naꞌiaꞌoram pidan kibaꞌazoo-kidaꞌo padaꞌanan õgaru, naꞌiki kibaꞌazoo-kidaꞌo õkakinaori kida, naꞌapaꞌo nii kapam Daonaiora Aokazi Ikiꞌo kibaꞌazoo-kidan uruu, ukaawan dono pamanawunun tuma, naꞌiki udaru umanawunun tuma, naꞌiki kaimanainao angelnao tuma. ");
INSERT INTO wapNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mishi õkowaadan nii uꞌati aimaakan mishiꞌo. Kainaꞌa pabiꞌi kida pidannao kaidaꞌaꞌa, aonaꞌo nii zii ĩmawakan, atii ĩtukapan nii zii Tominkaru naobanai-tinan.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aizii baudaꞌapaꞌa naa sondii dobatan Jesus kadakotinan daunaꞌan, uruꞌu naa unaꞌakan Peter, John naꞌiki James patuma. Unaꞌakan ĩdyaun naawazi paawa iti, utoriinpaꞌanan. ");
INSERT INTO wapNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aizii utoriinpan puꞌaꞌa naa mashaꞌapakiaka uawun baara panaꞌadinaꞌakan, naꞌiki ukamichan wiziꞌi, wiziꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mashaꞌapakiaka dyaꞌutam daonaioranao kaawaꞌakan uꞌidaꞌati, udaunaꞌan ĩkadakotinan naa utuma. Moses naꞌiki Elijah wuruꞌu kaawaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ĩkaawaꞌakan aokazi iki, konaunam naꞌiki kanada ĩaidinpan. Naꞌiaꞌa naa ĩkadakotin-kidan naꞌapam nii Jesus mawakan Jerusalem ii, maonapaꞌo niꞌi naa umishian wuruꞌu Tominkaru aipaniaz ushaꞌapata-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aizii Peter naꞌiki uminaudaꞌunao ipai daunuudaꞌu ĩdaꞌawun. Aizii ĩpokodaꞌakan ĩtukapa kanada Jesus umanawunun kanadapan, naꞌiki ĩtukapa dyaꞌutam pidannao kadishitapan utuma. ");
INSERT INTO wapNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aizii ĩtukapan naa pidannao makoꞌozon. Sariapa Peter kian Jesus ati, “Wanaobanaa, kaiman zii wuruꞌu wanaꞌanuz putuma. Turuaꞌo nii watoman idikinaudaꞌu sookapa-kizai, baudaꞌapa pugaru ati, baꞌoran Moses ati, naꞌiki baꞌoran Elijah ati,” ukian. Mazan aonaa Peter aitapan naꞌapaꞌoram aimaakan wuruꞌu pakadakotin kiziz. ");
INSERT INTO wapNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ukadakotinan puꞌu zii, ishaꞌiz kaawaꞌakan, naꞌiki sariapa ushibatan Jesus, Moses naꞌiki Elijah. Tuukii Peter naꞌiki uminaudaꞌunao tarian ĩtukapan idi ishaꞌiz shibatan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Udaunaꞌan ĩabatan parada-karu kian ishaꞌiz biiꞌi, “Diꞌoraz õdani õzaamatanii, ukauꞌan uizoꞌati uparadan.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aizii parada-karu mashaadan daunaꞌan, ĩtukapa Jesus pabaꞌorantinaꞌa naa. Mazan mashaa ĩtaapan wuruꞌu patukapaniaz aimaakan, aonaa kanom ati ĩkowaadan wuruꞌu patukapaniaz naꞌapain. ");
INSERT INTO wapNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Baꞌoran kamoo Jesus, Peter, John naꞌiki James tokapaanan zii naawazi paawa iki. Naꞌiaꞌa naa ĩikodan iriba pidannao. Sariapa ĩikodapan Jesus, ");
INSERT INTO wapNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","naꞌiki mashaꞌapakiaka pidan kadakoꞌokan pidannao bii iki, “Tiichaa, tuukii manawun õaipan putukapan õdani, ubaudaꞌapan õdani daonaiora wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mashaꞌapakiikaꞌo daꞌi oiaꞌo doronai zaamataꞌakauzonuz, naꞌiki ukadakoin-kidaꞌakan niiz diiwa. Udaunaꞌan ukabootaꞌakan niiz imiꞌi baara iti, naꞌiki umawakaziitaꞌakan naa, atii ipaiꞌo nii daꞌi udako bozowan. Karikaonan ubaiata-kidauzon kaziwaꞌo uꞌati, umuudan niiz, atii ukapatin anaꞌo nii zii tuukii. ");
INSERT INTO wapNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tuukiaꞌo daꞌi õpishaan wuruꞌu putominapa-kidaniinaouz, õaipan idi ĩsoꞌotan uꞌaiaz, ĩtiwaa padamata pasoꞌotanuz mazan aonaa usoꞌotinaꞌazon uꞌai.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sariapa Jesus dakoꞌatin uparadan naꞌiki ukian ipai pidannao ati, “Maam, pakawan zii mooko umamishidakan, pakawan umashaapaꞌazon oiaꞌo ati. Naꞌapam nii zii ukotuaꞌikin õnaꞌan utuma, õbaiatan unao? Punaꞌaka wuruꞌu pudaniz daꞌatiꞌi,” ukian pidan ati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aizii udani waꞌatin puꞌaꞌa naa, uruꞌu naa koshan oiaꞌo doronai zaamataꞌakanuzu, ukabootaꞌakanuzu daam kii imiꞌi baara iti, mazan umawakaziitaꞌakan naa. Mazan upuꞌaꞌa naa Jesus dyuudan oiaꞌo doronai soꞌotinan uꞌai. Uruu idi kaiman ukakudaꞌakan wuruꞌu daonaioraz. Udaunaꞌan utaan padaru atiz kaimanaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ipai pidannao, wuruꞌu naꞌiainaouz, tuukii ĩdiꞌitinpan, Tominkaru tukapa-kidan idi ĩꞌati mishi pamaꞌozakan, ushaꞌapatan idaꞌan aimaakan kaikapaꞌa. Pidannao kadakoinapa-kidan puꞌu zii wuruꞌu Jesus shaꞌapataniaz aimaakan, uruꞌu naa Jesus kian patominapa-kidaniinao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Õaiapa uabatan õparadan kaimanaiman aizii, aonaa kizi umanyukunuutanuz. Aizii Daonaiora Aokazi Ikiꞌo, uzaamata-kida-kao nii, atii utaa-kao nii naobanainao kaꞌu iti, maꞌozaka-tinpainao kidaz.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mazan aonaa utominapa-kidaniinao aitapan naꞌapaꞌoram dauaꞌo manawun wuruꞌu ukadakotinanuz. Ushaꞌapanum kauꞌan dizapa-kariwai ĩaitapan ai wuruꞌu aimaakanuz, aonaa kizi ĩaitapan kanom dauaꞌo wuruꞌu ukadakotinanuz. Naꞌiki tuukii ĩtarian papishaan uruu naꞌapaꞌoram manawun wuruꞌu ukadakotinanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Baukapaiman Jesus tominapa-kidaniinao kashadaakapan, ĩnao paꞌidiwaru paꞌatiaaka kida. Ĩkadakoinapa-kidan naꞌiaꞌoram pidan kainaꞌa ĩbiiꞌi, umanawunuꞌo ipai baꞌorainao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mazan Jesus, uaitapa ipai ĩdiꞌitinpan. Aizii ĩbaokopatinpan puꞌaꞌa naa utuma, sariapa unaꞌakan koraidaonaa naꞌiki ukadishita-kidanuz padazabaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Udaunaꞌan ukian patominapa-kidaniinao ati, “Naꞌiaꞌoram pidan konaukiaꞌo udapaapan wuruꞌu diꞌoraz koraidaonaꞌa õꞌuu idaꞌan, konaukiaꞌo kapam udapaapan õgaru wuruꞌu. Aizii naꞌiaꞌoram pidan konaukiaꞌo udapaapan õgaru, konaukiaꞌo kapam udapaapan wuruꞌu dyuudaꞌoraz õgaru. Aizii naꞌiaꞌoram pidan unao biiꞌi waranuitapa-kariwai, mazan Tominkaru ati umanawunuꞌo paꞌan wuruꞌu uruuz.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sariapa John kian Jesus ati, “Wanaobanaa watukapanii pidan soꞌoopan oiaꞌo doronainao pidannao diꞌiki pugaru uu idaꞌan. Naꞌiki wadyuuda usookadan wuruꞌu unaꞌapainapanuz, ushaꞌapanum kauꞌan aonaa waunao bii ikiꞌo mani wuruꞌu uruuz.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Manaꞌa umashaataꞌanaꞌa uruu,” Jesus kian John naꞌiki baꞌoran patominapa-kidaniinao ati. “Naꞌiaꞌoram pidan aonaꞌa utoꞌora-kizaitapan unao, upaonaru wuruꞌu,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aizii maonapataꞌa naa kamoo wuruꞌu Jesus makon aita-kaoaz aokazi iti. Uruu idi Jesus diꞌitinpan pamakon dauꞌu Jerusalem iti. ");
INSERT INTO wapNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naꞌiki udyuuda pidannao kiwiitan paꞌuaꞌati kakuwaapaꞌanaꞌo nii pidannao diꞌiti, pawaꞌatipan dauꞌu kainaꞌiki. Uruu idi pidannao kiwiitaꞌakan naa wiizai iti, Samaria iaꞌoraz. Aizii naꞌiiꞌakaꞌa naa ĩkowaadan pidannao ati wuruꞌu Jesus waꞌatinuz kainaꞌiki, naꞌiki marii kizi ĩsaabaan usookapa kizi nii. ");
INSERT INTO wapNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mazan aonaa naꞌiainao pidannao taaꞌazon usookapa kizi nii, ushaꞌapanum kauꞌan ĩaitapa umakopan Tominkaru Dapu iti wuruꞌu Jerusalem iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aizii utominapa-kidaniinao James naꞌiki John abatan idiꞌi naa wuruꞌu pidannao mataaꞌazookanuz Jesus sookapa kizi nii. Sariapa ĩkian uꞌati, “Wanaobanaa, puaiapa watoriinpan Tominkaru ati, marii kizi uwaota-kidan tikazi aokazi iki, umainaabata kizi wuruꞌu pidannaouz?” ");
INSERT INTO wapNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mazan Jesus tanawatinan ĩꞌidiꞌiti sariapa ukashadakowauan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Udaunaꞌan Jesus naꞌiki utominapa-kidaniinao koraꞌukaꞌakan naa baꞌoran wiizai iti. ");
INSERT INTO wapNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aizii Jesus makopaanan puꞌaꞌa naa patominapa-kidaniinao tuma, baudaꞌapa pidan kian Jesus ati, “Õdaꞌanan nii pugaru naꞌitiꞌoram pumako-kizi iti,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sariapa Jesus kian uꞌati, “Waruzonao kainaꞌa ĩꞌuun kida, kotuꞌuznao kainaꞌa ĩshimaka kida kapam, mazan Daonaiora Aokazi Ikiꞌo, aonaa naꞌiam uwashatin kizi nii, naꞌiki aonaa usookapaka-kizi nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesus kian baꞌoran pidan ati, “Pumako õtuma.” Mazan pidan kian, “Naobanai, õdidanaka kizi zii õdaru mawakan kiwiin.” ");
INSERT INTO wapNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mazan Jesus kian uꞌati, “Marii mawakainao didan pairiban mawakan, mazan pugaru pumako paꞌan, pukakuwaapaꞌan kiziꞌi naa Tominkaru naobanai-tinan dauꞌu,” ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Baꞌoran kian Jesus ati, “Naobanai, õgaru õmakon nii putuma, mazan õmakon uaꞌii, õkowaadinankan nii zii kiwiin õiribannao diꞌii,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Uruu idi Jesus kian uꞌati, “Pidan sakadaꞌo pakawiiziipan, udaunaꞌan awunuupaꞌo powaa iti, madiwautapa-kaꞌo karikaonan uruu wunao bii iaꞌa naobanaitapainaouz Tominkaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aizii uruu daunaꞌan Jesus zaamatan powaꞌa zii koshan pidannao, tominapa-tinainao bii iki. 72 pidannao uzaamatan. Wuruꞌu uzaamataniinaouz pidannao, padyuudan niꞌo, kiwiitainao nii paꞌuaꞌati. Dyaꞌutam kidaꞌo nii uaipan ĩmakon ipai amazada naꞌiki wiizai kida kawanaꞌati, wuruꞌu Jesus makoꞌozoo-kizi kidaz. ");
INSERT INTO wapNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aizii Jesus kian ĩꞌati, “Kainaꞌa kai diriꞌi paoribai aka karaoda-karu nii. Mazan kainaꞌa masakaudaꞌu kaudinainao. Ukauꞌan utoriinapa, kapaoribaꞌo ati, udyuuda kizi kaudinainao nii, kasabaꞌuaꞌo niꞌi naa upaoriba aka. ");
INSERT INTO wapNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ukauꞌan umakoꞌo naa. Aizii õdyuudan unao naꞌapa kaznizo dainao dyuuda-kao kawan baudokorunao bii iti. ");
INSERT INTO wapNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mazan aonaa paꞌi unaꞌakaꞌanaꞌa upuraatan, naꞌiki usaakon, naꞌiki baꞌoran udazkidi. Naꞌiki manaꞌa paꞌi utomunuꞌikinpaꞌanaꞌa oo uzaamaakaꞌuupaꞌanaꞌa pidannao uikodapaniinao kida dunapota. ");
INSERT INTO wapNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Aizii ukaawan an kabaun iti, ukian nii. ‘Tosh, kaiman unao? Marii Tominkaru taan kaimanaꞌo mashaapa-karu unao ati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aizii kadapuꞌo nyukunuu kaimanan an, marii Tominkaru diꞌikiꞌo kaiman-karu mashaapan utuma. Mazan aizii pidan nyukunuu makaimankan an, ukiwa-kidaꞌaka powaa iti wuruꞌu uparadanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ukauꞌan usookadinan nii, pidan konaukii-kidaꞌo unao dapu ii. Naꞌiaꞌo nii unikan uwanyukunuu naꞌiki utuzan nii kanom karikaonan taa-kariwai uꞌati. Ushaꞌapanum kauꞌan pidan kaudinaꞌo, taa-kao nii uꞌati aimaakan uwinipinii. Ukauꞌan naꞌiaꞌo nii usookadinan atii uipaian ukakuwaatinan naꞌiiꞌaka. ");
INSERT INTO wapNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Aizii ukaawan an naꞌiaꞌoram wiizai diꞌiti, naꞌiki kawiiziinao konaukii-kidan an unao, naꞌiki ĩmorota-kidan an unao padapu iti, unika shaꞌapaꞌoram wanyukunui maokoda-kariwai uꞌati naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Naꞌiki ukakuda ipai karinainao naꞌii uruu wiizai diꞌii. Naꞌiki ukii naꞌiainao pidannao ati. ‘Aizii taaꞌazoꞌo naa Tominkaru naobanai-tinan kamoon kaawan unao idaꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Mazan aizii ukaawan an naꞌiaꞌoram wiizai diꞌii, aonaa uaiapa-kao naꞌiki aonaa ukuwaa abataꞌazoo-kao naꞌii. Ukiwa powaa iti dunapo iti, naꞌikiꞌi naa ukii ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Imiꞌi, wuruꞌu uwiizi ikiꞌoraz, zaamatinaꞌoraz wadazkida idaꞌati, ipaiꞌo nii wawao-kidanuz unao diꞌiti. Aizii uzaudinaꞌa naa paꞌi, maonapaꞌoraꞌa naa Tominkaru naobanai-tinan kaawan unao idaꞌati,’ ukii ĩꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jesus kian, “Õkowaadaꞌazon mishiꞌo aimaakan uꞌati. Diinaꞌitiꞌi Tominkaru kootowapa-kidan donoꞌo naa pidannao, awutapaꞌo nii zii upatakaꞌutan pidannao Sodom iainao kidaz wunao aiaꞌa, aonaꞌoraz ĩabataꞌazon unao kuwaa.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kashaꞌoraꞌo nii manawun pubaiaapan Chorazin! Kashaꞌoraꞌo nii manawun pubaiaapan Bethsaida. Aizii wuruꞌu umanawun kidaꞌoraz shaꞌapata-kariwaiz uꞌidaꞌa, ushaꞌapata-kao an mani Tyre naꞌiki Sidon ii, sariapa mani naꞌiainao pidannao morokodan kamicha kashaꞌora-karu daara kida, naꞌiki sariapa mani ĩparitiꞌian pazowau. Ĩtukapa-kida-kinaa nii mishi patanawatinan paꞌoian ai. ");
INSERT INTO wapNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mazan, awutapaꞌo nii zii Tominkaru patakaꞌutan Tyre naꞌiki Sidon sannao unao ai, ukootowapa-kidan donoꞌo naa pidannao diinaꞌitiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Naꞌiki unao Capernaum sannao, uꞌitiiman umanawunuꞌo nii unao aokazi ii? Aonaa. Mazan kiiꞌan ukaboota-kao nii Tuubaruꞌo Tikazi wuꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Udaunaꞌan Jesus kian patominapa-kidaniinao ati, “Naꞌiaꞌoram pidannao mishidaꞌo unao kuwaa, ĩmishidan kapam õgaru wuruꞌu. Aizii naꞌiaꞌoram pidannao mamishida-kaꞌo unao kuwaa, aonaa ĩmishidan mani õgaru wuruꞌu. Naꞌiki kanomanao mamishida-kaꞌo õgaru, aonaa ĩmishidan mani kapam wuruꞌu dyuudaꞌoraz õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aizii tawuruꞌu 72 pidannao Jesus dyuudaniinaouz kaawan naa powaa ati, konaukii ĩkakuwaapan. Ĩkian Jesus ati, “Wanaobanaa, oiaꞌo doronainao izoꞌati waparadan. Sariapa mishi ĩkoditan pidannao diꞌiki, wadyuudan idi ĩkoditan puꞌuu idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus kian ĩꞌati, “Õtukapanii Satan waotan doko iki, naꞌapa toroanaru pizo-pizowankan kawan doko ii. ");
INSERT INTO wapNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Uabata naꞌapam õkian unao ati aizii. Õtaaniꞌi naa õmaꞌozakan unao ati, ukaꞌiita-kinaa nii udakazatinan kowazaznao paawa an naꞌiki kankoorunnao paawa an kapam. Naꞌiki õtaan idi umaꞌozaka-kinaa nii, aonaꞌo nii Satan kaꞌiitan pashaꞌapatan unao. Naꞌiki aonaꞌo nii kanom shaꞌapatan unao kaziwaꞌo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mazan manaꞌa ukonaukii-kidaꞌanaꞌa wuruꞌu oiaꞌo doronainao izoꞌatinuz uparadan. Mishiꞌoraiman ukonaukii paꞌan Tominkaru saadan idiꞌi naa uꞌuu pakaaritan idaꞌa aokazi ii.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Uruu dono Kaimanaꞌo Doronaa taan tuukii konaukii-karu Jesus nyukunuu iti. Uruu idi tuukii ukonaukian, naꞌiki ukian, “Õdaru, Naobanai-tinpaꞌo ipai aokazi ii, naꞌiki ipai imiꞌi baara an, õkonaukii-kidan pugaru tuukii, ushaꞌapanum kauꞌan puaida-kidan idi wuruꞌu pudizapauzonii kidaz aimaakan aitapainao pidannao ai, naꞌiki wunao aiaꞌa tominpauzonao kidaz pidannao. Mazan aizii puaida-kidanuz maaitapa-kainao pidannao ati, aonaꞌoraz ĩtominpauzon. Mishi õdaru, naꞌapa puaitan kawanaꞌatiꞌo mishi wuruꞌu aimaakan shaꞌapanuz naa aizii.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Udaunaꞌan ukian patominapa-kidaniinao ati, “ÕDaru taaꞌakaniꞌi naa õꞌati kaiman-daun aimaakan, utaa õmaꞌozaka-kinaa nii, maꞌozaka kizi õkazowautapan pidannao naꞌiki utaa õaitapa-kinaa nii. Aonaa kanom aitapan õgaru, Tominkaru Danin, soo õDaru baudaꞌapa aitapa õgaru kaimanaiman. Naꞌiki aonaa kanom aitapan õDaru, soo õgaru uDani, õaitapa paꞌan uruu kaimanaiman. Naꞌiki wunaouꞌu õzaamataniinaouz, ĩnao aitapa õDaru kaimanaiman.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Udaunaꞌan Jesus tanawatinan patominapa-kidaniinao diꞌiti, naꞌiki ukian soo ĩnao ati karikaonan, “Kaiman zii unao ati, utukapan idi uawun idi ipai aimaakan kida shaꞌapan. ");
INSERT INTO wapNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Õkowaadan nii unao ati, kotuaꞌa naa iriba pidannao Tominkaru prophetinnao, naꞌiki kingnao, ĩnao tuukiaꞌo ĩaipan patukapan wuruꞌu unao tukapanii kidaz kai, mazan aonaa ĩtukapanuzu, pamawakan idiꞌi naa. Naꞌiki tuukiaꞌo kapam ĩabataꞌazon wuruꞌu unao abatanii kidaz kai aimaakan, mazan aonaa ĩabatanuz.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Baukapaiman pidan tiichaapauzo Moses kakinaori dauꞌu waꞌatin Jesus idaꞌati, uaipan patiwaa-kidapanuz. Ukian uꞌati, “Tiichaa, naꞌapa dii õshaꞌapatinan, õzaamata-kinaa nii wuruꞌu karikaonanuꞌoraz kakupa-karu diinaꞌitiꞌi?” ");
INSERT INTO wapNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sariapa Jesus kian uꞌati, “Naꞌapa dii mooko tawuruꞌu kotuaꞌoraz Tominkaru kakinaori saadauzo-kariwaiz kian Moses ati? Naꞌapaꞌoram puaitapan wuruꞌu kakinaorii kianuz?” ");
INSERT INTO wapNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aizii pidan kian Jesus ati, “Kakinaorii kian, pumarainapa tuukii Naobanai wuruꞌu puTominkarunuz manawun ipai punyukunuu iki, ipai pudoronaa ii, ipai pudiꞌitinpan idaꞌan, naꞌiki ipai pumaꞌozakan idaꞌan. Naꞌiki pumarainapa puiriban, naꞌapa pumarainpan kawan punanaa.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus kian uꞌati, “Sakitapaꞌo kaiwuruꞌu pudakoꞌatinuz parada-karu. Ukauꞌan aizii pushaꞌapatinaꞌa naa ipai ukawanaꞌati, naꞌiki pukakupa kizi karikaonan.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mazan wuruꞌu pidanaz tuukii uaipan patukapa-kao kaimanaꞌo pidan nii. Uruu idi upishaan Jesus. Ukian, “Kanom wuruꞌu õiriban õmarainpan niꞌoraz?” ");
INSERT INTO wapNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sariapa Jesus kian uꞌati, “Baudaꞌapa kamoo Jew waꞌatipaanan Jerusalem iki, umakon Jericho iti. Aizii umakopaanan puꞌu, koidimikinao ikodan uruu, sariapa ĩzaamatanuzu, naꞌiaꞌa naa ĩnarakaꞌakan naa ukamichan. Uruu daunaꞌan ĩzowiautapaꞌakan naaz tuukii, naꞌiki mawakanaka. Naꞌikiꞌo ĩwaꞌakaꞌakan naaz. ");
INSERT INTO wapNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Upuꞌu faadaa waꞌatipaanan naꞌan dunapota. Aizii utukapankan naa pidan zowiautapa-kariwaiz, sariapa ukoraꞌukaꞌakan uꞌai dunapo daawa ii aka. ");
INSERT INTO wapNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kainaꞌiki koshan baꞌoran Jew waꞌatipaanan uruu dunapota, uruu Levite, kaudinauzoz Tominkaru Dapu ii. Aizii umaonapatan naꞌati, uruꞌu naa utukapan pidan wuruꞌu zowiautapa-kariwaiz. Uruu idi umako-makowan udazaba iti, uawunuutaa-kidanuz, udaunaꞌan ukoraꞌukaꞌakan naa uꞌai dunapo daawa ii aka. ");
INSERT INTO wapNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Kainaꞌiki mazan koshan baꞌoran pidan waꞌatin, uruu Samaria san paꞌan, uruu dunapota koshan uwaꞌatin. Aizii naꞌapaꞌa naa kapam utukapankan pidan wuruꞌu zowiautapa-kariwaiz. Mazan tuukii paꞌan utukapan pakamunan-kidan wuruꞌu pidanaz. ");
INSERT INTO wapNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Uruu idi sariapa umakon uꞌidiꞌiti, udaunaꞌan uchikaan naa wine idi ipai wuruꞌu izai baꞌizi-daun kidaz. Uipaian daunaꞌan pachikaanuz, uruꞌu naa uzichian wuruꞌu baꞌizi-daun kidaz kiwinii idi. Udaunaꞌan uruu ubazobatan naa wuruꞌu baꞌizi-daun kidaz. Uipaian daunaꞌan pasaabaanuzu, uruꞌu naa uzaida-kidanuzu pakawaron chaakashi barau iti. Unaꞌakan naaz atii ĩkaawan wiizai diꞌiti. Naꞌiaꞌa naa kaiman usaabaanuz, atii ukawinipinaata sookapa-kizai kabaun nazoo uꞌati, naꞌiki ipai utorian uwanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Baꞌoran kamoo Samaria san dobatan naa, uruu idi sariapa usoꞌotan dyaꞌutam wiziꞌi kidainao papuraatan, naꞌiki utaan naazu sookapa-kizai kabaun taapiki ati. Ukian uꞌati. ‘Õaiapa putaapan uruu kaiman, daꞌanaꞌo nii koshan õkiwanuꞌu, aizii naꞌapaudaꞌum puraata pukabootan udauꞌati, õkawadauntan nii ipai daunuudaꞌu puꞌati õkaawan an powaa ati,’ ukian.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Uruu idi Jesus kian naa koshan tiichaapauzo Moses kakinaori ati, “Naꞌiaꞌoram dii pidan tukapa-kidaꞌo mishi pamarainpan wuruꞌu koidimikinao zowiautapaniaz pidan?” ");
INSERT INTO wapNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ukian Jesus ati, “Wuruꞌu kamunan-kidaꞌoraz uruu.” Uruu idi Jesus kian uꞌati, “Ukauꞌan pushaꞌapatinaꞌa naa paꞌi kapam naꞌapa.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aizii Jesus naꞌiki utominapa-kidaniinao makon atii ĩkaawan wiizai diꞌiti. Uruu wiizai diꞌii kainaꞌa zunaaba Martha kiaꞌo oꞌuu. Tuukii okonaukii-kidan Jesus kaawan padapu ati. ");
INSERT INTO wapNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naꞌiki kainaꞌa oꞌinaozo Mary kiaꞌo oꞌuu. Aizii Mary, onaꞌian naa osakanatapan Jesus dazaba ii oabatapan ukakuwaa. ");
INSERT INTO wapNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mazan Martha tuukii paꞌan odopiidinan pashaꞌapataꞌazoonii sodi kida aimaakan dauꞌati. Uruu idi owaꞌatin Jesus idaꞌati, naꞌiki okian uꞌati, “Naobanai, aonaa pukashaꞌora-kidan putukapan wuruꞌu õꞌinaozo waꞌakanuz õgaru õbaꞌoran, shaꞌapataꞌo nii ipai aimaakan wuruꞌu shaꞌapataꞌazoo-kariwai kidaz? Pudyuuda oroo, okaminkaꞌuta kiziꞌi naa õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sariapa Jesus kian oꞌati, “Martha, kandii nii pudopiidinan pushaꞌapataꞌazoonii kida dauꞌan? ");
INSERT INTO wapNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kainaꞌa soo baudaꞌapa aimaakan tuukiaꞌo uaiapa-kao. Aizii wuruꞌu Mary shaꞌapaapaniaz aimaakan, kaimanaꞌo manawun wuruꞌu, aonaꞌo nii naꞌapainim ukazata-kao oꞌai.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Baudaꞌapa kamoo Jesus toriinpan. Aizii uipaian daunaꞌan patoriinpan, baudaꞌapa pidan utominapa-kidaniinao bii iki kian uꞌati, “Wanaobanaa, putominapa-kida waunao toriinapa-karu dauꞌu, naꞌapa John tominapa-kidauzon kawan patominapa-kidaniinao.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus kian ĩꞌati, “Naꞌapainim utoriinpan an, kaikapa paꞌi ukiaꞌa. ‘Wadaru, marii ipai pidannao taapan pugaru umanawunuꞌo nii manawun. Naꞌiki marii kizi punaobanai-tinan. ");
INSERT INTO wapNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Marii kizi putaan waꞌati aizii wawanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pumarinaꞌata ipai wuruꞌu oiaꞌo washaꞌapaapanii kidaz. Naꞌapa wamarinaꞌatan kawan wuruꞌu oii kidaꞌoraz pidannao shaꞌapaapan waꞌati. Aonaa putaapadaꞌanaꞌa wanyukunuu tiwaa-kidapa-kao oiaꞌo diꞌiti.’” ");
INSERT INTO wapNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Udaunaꞌan Jesus kian koshan patominapa-kidaniinao ati, “Dii mani baudaꞌapa unao makon tomun-zikon pupaonaru dapu iti, naꞌiki pukian uꞌati. ‘Tosh õpaonaru. Õaipan zii idikinaudaꞌu bread puꞌai. ");
INSERT INTO wapNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kainaꞌa õpaonaru dobatapaꞌo kaawaꞌakan õdapu ii. Naꞌiki aonaa kanom õtaan nii uꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aizii pupaonaru kian an mani puꞌati padapu nazo iki. ‘Manaꞌa putowaudaꞌutaꞌanaꞌa õgaru. Ipaiꞌi naa paniinom dadaradinaꞌakan. Naꞌiki õgaru naꞌiki õdainao wasookapan naa wuruꞌu. Aonaꞌa naa turuu õkadishitan naꞌiki õtaan aimaakan puꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aizii naꞌapa dii mani pushaꞌapatinan? Õkowaadan nii unao ati. Aonaan puꞌu pupaonaru kadishitaꞌazon, utaaꞌanan bread puꞌati, mazan upuꞌaꞌo nii ukadishitan naꞌiki utaan ipai aimaakan puaiapanii, ushaꞌapanum kauꞌan aonaan idi pusookadan pupishautan wuruꞌu paaipaniaz aimaakan uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ukauꞌan õkian uꞌati, upishaa aimaakan dauꞌan, taa-karu nii uꞌatiz. Udorota aimaakan, uikodan nii wuruꞌu udorotapaniaz. Udau-dauapa paniinom, daꞌata-karu nii paniinom uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pidan wuruꞌu pishaaꞌoraz aimaakan, taa-karu nii uꞌatiz. Naꞌiki naꞌiaꞌoram pidan dorotaꞌo aimaakan, uikodan niiz. Naꞌiki kanom dau-daupaꞌo paniinom, daꞌata-karu nii paniinom uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Unao daruinao, utaa mani udani ati kowazaz, upishaan an kopau uꞌati? ");
INSERT INTO wapNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oo utaa mani uꞌati kankoorun upishaan an kuruku dani uꞌati? ");
INSERT INTO wapNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oiaꞌo unao padamata, mazan upuꞌu zii uaitapa utaan kaiman kidaꞌo aimaakan udainao ati. Aitaniiman uDaru aokazi iaꞌoraz, utaan nii Kaimanaꞌo Doronaa, wunao atiꞌi pishainaouz uruu udauꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Baꞌoran dono Jesus waatan oiaꞌo doronai maparadanuꞌo pidan diꞌiki. Aizii oiaꞌo doronai waata-kao daunaꞌan, sariapa ukaparadanuꞌukan. Tuukii pidannao kasabaꞌukinpainao naꞌii diꞌitinpan aimaakan shaꞌapata-kao idi naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mazan pabiꞌi kida ĩkian, “Beelzebul, oiaꞌo doronainao naobanaa idaꞌanaꞌo karikaonan wuruꞌu ukodita-kidanuz oiaꞌo doronainao. Utaan idaꞌanaꞌo pamaꞌozakan uꞌati wuruꞌu ukaudinanuz,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kainaꞌa baꞌorainao tiwaa-kidapaꞌazoinao karikaonan Jesus. Uruu idi ĩpishaan Jesus shaꞌapatan paꞌati umanawun kidaꞌo aimaakan, uruu idaꞌan kizi utukapa-kidan mishiꞌo wuruꞌu ukaudinanuz Tominkaru idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mazan Jesus aitapa naꞌapaꞌoram ĩdiꞌitinpan. Uruu idi ukian ĩꞌati, “Aizii pidannao mashaapainao udaruꞌo wiizai diꞌii, mizaataakapan an paꞌatiaaka, naꞌapam niꞌi naa mooko uaitapan ĩmaꞌozakadan pawiizi? Aizii pidannao mashaapainao baudaꞌapaꞌo kabaun idaꞌa, mizaataakapan an paꞌatiaaka, naꞌapam niꞌi naa mooko ĩmaꞌozakadinan? ");
INSERT INTO wapNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aizii Satan poitorunao wuruꞌu oiaꞌo doronainaouz mizaataakapan an paꞌatiaaka, naꞌapam niꞌi naa mooko uaitapan Satan kaudin-kizi maꞌozakadinan? Aizii unao kian õdauꞌan, õkodita-kidan oiaꞌo doronainao, Beelzebul taan idaꞌanaꞌo õmaꞌozaka-kinaa nii. ");
INSERT INTO wapNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kanom idaꞌanaꞌo mooko paꞌan upidanannao, wuruꞌu daꞌanainaouz unao kodita-kidauzon oiaꞌo doronainao? Beelzebul idaꞌanaꞌo shaꞌa? Aitapa-kariwai ĩnao naꞌapa kapam ĩkaudinan õgaru kaudinan kawan. Ukauꞌan kaimanaiman ĩtukapa-kidan naꞌapam unao pozawatan. Upozawatan wuruꞌu uparadanuz õdauꞌan kaikapaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aonaa Beelzebul maꞌozakan idaꞌanaꞌo mani wuruꞌu õkaudinanuz, õkaudinan Tominkaru maꞌozakan idaꞌanaꞌo, uruu taan idaꞌanaꞌo pamaꞌozakan õꞌati wuruꞌu õkodita-kidanuz oiaꞌo doronainao pidannao diꞌiki. Ukauꞌan wuruꞌu õshaꞌapataniaz Tominkaru maꞌozakan idaꞌan tukapa-kida unao ati kainaꞌaꞌa naa Tominkaru naobanai-tinan unao biiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Aizii naꞌapainim pidan maꞌozakaꞌo, kazannaatapan an padapu pabairi tuma oo pamarian tuma, ushaꞌapata-kao ai. Aonaꞌo nii ushaꞌapauz koidapa-kao udapu nazo ii. ");
INSERT INTO wapNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mazan aizii pidan, powaꞌaꞌo zii manawun umaꞌozakan uꞌai, kaawaꞌakan an uꞌidaꞌati, ipaiꞌo nii ukazataꞌakan uꞌai, ubairi naꞌiki umarian naꞌiki ipai baꞌoran aimaakan kida wuruꞌu umaꞌozakatinapa-kinaa kidaz. Udaunaꞌan maꞌozakaꞌoraz manawun pidan buutan niꞌi naa baꞌorainao ati ipai wuruꞌu pakoidanuu kidaz, baꞌoran pidan shaꞌapauziz. ");
INSERT INTO wapNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Naꞌiaꞌoram pidan aonaꞌo uaipan õgaru paminaudaꞌu nii, utoꞌora-kizaitapan õgaru wuruꞌu. Naꞌiki pidan wuruꞌu aonaꞌoraz ukaminkaꞌutan õkasabaꞌuupan pidannao, uruu waataabiꞌiaꞌo pidannao õꞌai wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Naꞌapainim oiaꞌo doronai koditan pidan diꞌiki, umakon nii amazada aradaꞌo diꞌiiꞌaka, udorotapan naa pamashaapa-kizi nii. Aizii aonaan dono uikodan pamashaapa-kizi nii, uruꞌu naa ukian paaipan ati. ‘Õkiwan nii powaa iti õmashaapauzo-kizi iti.’ ");
INSERT INTO wapNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Uruu idi ukiwan naa powaa iti, naꞌiki uikoda padapu nazoo kaiman usaabaa-kao, aonaa ukaniriban. ");
INSERT INTO wapNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Udaunaꞌan umakon, unaꞌanan naa 7 baꞌoran oiaꞌo doronainao, powaꞌaꞌo zii manawun ĩdikaudan kida uꞌai. Uruu idi ĩmorotan, naꞌiki naꞌiaꞌa naa ĩmashaapan. Uruu daunaꞌan powaꞌaꞌo niꞌi naa manawun pidan dikaudaꞌakan kiwiitapaꞌo ai.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Aizii Jesus kadakotinan idi naꞌapa, sariapa zun kadakon uꞌati iribaꞌo pidannao bii iki. Okian, “Konaukiaꞌo manawun pudaro, wuruꞌu shakata-kidaꞌoraz pugaru, naꞌiki biida-kidaꞌoraz pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mazan Jesus dakoꞌatin oparadan kaikapaꞌa: “Wunao paꞌan wuruꞌu konaukiaꞌoraz, abatainaouz naꞌiki izoꞌatiinaouz Tominkaru Paradan.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aizii pidannao kasabaꞌukinan puꞌaꞌa naa iriba Jesus idaꞌati, uruꞌu naa ukian koshan ĩꞌati, “Pidannao wuruꞌu mashaapainao kidaz kai, oiaꞌo manawun ĩdyaun. Atii ĩaiapa zii aimaakan tukapa-kida-kao paꞌati kiwiin, pamishida-kinaa nii. Mazan aonaꞌo nii baudaꞌapa aimaakan tukapa-kida-kao ĩꞌati. Soo wuruꞌu aimaakan, Jonah shaꞌapatauzoniaz kotuaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mishi kotuaꞌa naa Tominkaru kainaatinan Prophet Jonah idaꞌan Nineveh sannao ati, ukowaada-kidan uꞌidaꞌan naꞌapam pashaꞌapataꞌazon ĩdyaun. Ukauꞌan naꞌapaꞌo kapam wuruꞌu Tominkaru kainaatinanuz Daonaiora Aokazi Ikiꞌo idaꞌan. Naꞌapaꞌo kapam wuruꞌu ukowaadapanuz kuwai kainao pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aizii wuru kamoo donoꞌo, Tominkaru kootowapa-kidanuz ipai pidannao, uruu dono Queen, Sheba sanaaba baꞌazootin-kidan nii Tominkaru kanaapu ati wuruꞌu pidannao mashaapainaouz kai. Ushaꞌapanum kauꞌan owaꞌatin pawiizi iki munapo, munapo, amazada tokon ikinapa, oabataꞌazon idi naꞌiki otominpaꞌazon idi kaiman kidaꞌo aimaakan dauꞌu King Solomon diꞌiki. Mazan kainaꞌa pidan kaidaꞌaꞌa, powaꞌaꞌo zii umanawunun Solomon ai. ");
INSERT INTO wapNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aizii diinaꞌitiꞌi Tominkaru kootowapa-kidan donoꞌo naa ipai pidannao. Uruu dono Nineveh sannao baꞌazootin-kidan nii unao Tominkaru kanaapu ati. Ushaꞌapanum kauꞌan kotuaꞌa naa ĩabatan dono Jonah kuwaa, sariapa paꞌan ĩtanawatinan paꞌoian ai. Mazan kainaꞌa pidan kaidaꞌaꞌa, powaꞌaꞌo zii umanawunun Jonah ai. ");
INSERT INTO wapNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Aonaa naꞌiam zii pidan suuauzon lamp, udaunaꞌan utaratanuzu boon idi. Mishiꞌoraiman, lamp suu-kao daunaꞌan, umuuda-kao nii dokoꞌo lamp wiizi idaꞌa. Aizii pidannao morotan an, kaimanaꞌo nii ĩtukapan ukanadapan kabaun nazoo. ");
INSERT INTO wapNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aizii wuruꞌu puawun kidaz, naꞌapaꞌo lamp kawan, ukanadapan punanaa ati. Aizii puawun kanadapan an kaiman, ipaiꞌo nii punanaa mashaapan kanadaꞌo-karuꞌu. Mazan aizii puawun ishaan anaꞌa naa, punanaa mashaapan nii marutaꞌo kaꞌazoꞌo. ");
INSERT INTO wapNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ukauꞌan puaitapa kizi paꞌi, panaadon aonaa kanadaꞌo nii puꞌidaꞌa, soo marutaꞌo karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Aizii punanaa kanadapan an ipai daunuudaꞌu, aonaa masakaudaꞌu marutaꞌo nii naꞌii, kaimanaimanaꞌo nii manawun ukanadapan punanaa ipai daunuudaꞌu. Naꞌapaꞌo nii ukanadapan lamp kawan, tawuruꞌu kaimanaꞌoraz manawun ukanadapan puꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aizii Jesus ipaian daunaꞌan pakadakotinan, Pharisee naꞌakan uruu padapu iti, uaroapanaka kizi patuma. Uruu idi Jesus makon utuma udapu iti. Naꞌiaꞌa naa ĩsakanatan naꞌiki ĩaroopaꞌazon naa. ");
INSERT INTO wapNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mazan tuukii Pharisee diꞌitinpan Jesus dauꞌu. Ushaꞌapanum kauꞌan aonaa Jesus chikaan pakaꞌu paaroopan uaꞌii, ĩnao chikauzon kawan pakaꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mazan sariapa Jesus kian Pharisee ati, “Aizii unao Phariseenao, kaiman uchikauzon ukoopon naꞌiki uparaapin barau. Mazan unyukunuu kaꞌazo ii, tuukii utaapan mishaꞌoraru-karu, naꞌiki tuukii uaipan ushaꞌapatan oii kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mishi unao maaitapin-kainao manawun, uaitapa Tominkaru tomanii ipai wuruꞌu koopo naꞌiki paraapi barau kidaz. Kanom tomanii mooko uaitapan wuruꞌu unazoo kidaz kapam, aonaa Tominkaru mani? ");
INSERT INTO wapNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ukauꞌan utaa mishiꞌoraiman ukoopon wazoo naꞌiki uparaapin wazoo kida, mapuraataniinao ati. Ushaꞌapatan an aimaakan kida naꞌapa, mishiꞌo paꞌan wuruꞌu uchikainanuz kaiman-daun oiaꞌo ai. ");
INSERT INTO wapNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kashaꞌoraꞌo nii manawun ubaiaapan Phariseenao! Mishi minziiwa ubuutan Tominkaru ati 1/10 wanyukunui kaduunuribanaa ziꞌinaba sodi kida. Mazan upuꞌu zii umarinaꞌatan ushaꞌapatan kaimanaꞌo, naꞌiki sakitapaꞌo aimaakan baꞌoran pidannao ati. Naꞌiki aonaa kapam umarainpan Tominkaru. Ipaiꞌo nii padamata ushaꞌapatan kapam wuruꞌu kaikapa kidaꞌoraz aimaakanuꞌu. Mazan, aonaa õkian mani uꞌati kaiwuruꞌu, umarinaꞌataꞌa naa ubuutan 1/10. ");
INSERT INTO wapNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kashaꞌoraꞌo nii manawun ubaiaapan Phariseenao! Ushaꞌapanum kauꞌan synagogue ii, unaudapa usakanatauzon umanawun kidaꞌo tabai paawaꞌa, baꞌorainao ai. Naꞌiki pidannao iribainapa kizi ii aka, tuukii uaipan utaapa-kao umanawun kidaꞌo pidannao nii. ");
INSERT INTO wapNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kashaꞌoraꞌo nii manawun ubaiaapan, ushaꞌapanum kauꞌan unyukunuu ikodanii tawuruꞌu baaranai aonaꞌoraz ukainaabanan. Uruu idi pidannao chiꞌikaꞌanpan baaranai paawa an, ushaꞌapanum kauꞌan aonaa ĩaitapan ubaaranain.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Uruu idi baudaꞌapa pidan, tiichaapauzo Moses kakinaori dauꞌu bii ikiꞌo kian Jesus ati, “Tiichaa, puparadan idi kaikapaꞌa, pudakoopan kapam waunao dikaudaꞌo idaꞌan wuruꞌu, puparadanuz naꞌapa.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus kian uꞌati, “Kashaꞌoraꞌo nii manawun ubaiaapan kapam, unao tiichaapauzonao Moses kakinaori dauꞌu! Ushaꞌapanum kauꞌan, utoman kakinaorii dobataꞌa naa manawun, atii aonaꞌa naa pidannao kaꞌiitanuz. Kainaꞌa unao padamata, mazan aonaa naꞌapainim zoobaba ukaminkaꞌutan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kashaꞌoraꞌo nii manawun ubaiaapan, ushaꞌapanum kauꞌan kaiman kida utoman Tominkaru prophetinnao baaranaa kotuaꞌa naa. Ĩnao tawuruꞌu udokozu-daunnao zowiauzoniinao kidaz kotuaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Utoman idaꞌan ĩbaaranaa, ukainaabainan naꞌapa unyukunuu kapam udokozu-daunnao kawan, tuukii unaubaapan wuruꞌu ĩzowiinuz Tominkaru prophetinnao kotuaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tominkaru, paaitapaaban idaꞌan manawun, uaitapa ipai daunuudaꞌu ĩshaꞌapatan nii aimaakan kaikapaꞌa. Uruu idiꞌo tawuruꞌu ukianuz. ‘Õdyuudan nii ĩꞌidiꞌiti prophetnao, naꞌiki apostlenao. Pabiꞌi kida zowii-karu nii naꞌiki patakaꞌuta-karu nii wuruꞌu õdyuudaniinao kidaz,’ kii ukiauzon kotuaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ukauꞌan wuruꞌu kainaouz pidannao mashaapan, ĩnaouꞌo niꞌi naa kabaiaapan wunao zannaꞌa Tominkaru prophetinnaouz, zowii-kariwainao kidaz kotuaꞌa naa, amazada sakadinan diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel zowiauzo-kao diꞌiki, atii Zechariah diꞌiti. Uruu Zechariah zowii-kariwaiz Tominkaru Dapu naꞌiki altar, uzai kawaodapa-kizinao sakodaꞌa. Ipai ĩnao kida zannaꞌo nii wuruꞌu kainaouz pidannao baiaapan. Mishiꞌo kaiwuruꞌu õkianuz. ");
INSERT INTO wapNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kashaꞌoraꞌo nii manawun ubaiaapan, unao tiichaapauzonao Moses kakinaori dauꞌu. Ushaꞌapanum kauꞌan unao taapanii padamata key, wuruꞌu aitapa-kinai diꞌitiꞌoraz. Unao naꞌapa aonaꞌo nii kapam umorotan. Tuukii manawun uawautapan pidannao, wuruꞌu morotaꞌazoinaouz padamata naꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Aizii Jesus koditan daunaꞌan Pharisee dapu iki, uruꞌu naa tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki Phariseenao, dakoopan uruu tuukii, naꞌiki tuukii kapam ĩkashadan wuruꞌu ukuwaa kidaz. Uruu idi ĩpishaan naa Jesus pabiꞌinaaka kidaꞌo aimaakan dauꞌan. Wuruꞌu ĩpishautanuz uruu naꞌapa, ĩkimudinan karikaonan ĩabataꞌazon naꞌapam nii udakoꞌatin ipai wuruꞌu paparadan kidaz. Ĩaipan pazaamatan uruu naꞌiki pakaakapaan uruu, udakoꞌatin an ĩparadan panaꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aizii pidannao kaawan ĩkasabaꞌuinan Jesus idaꞌati iriba, iriba, atii ĩkidaꞌuaakapan. Pidannao kasabaꞌuinpan puꞌu, Jesus kian patominapa-kidaniinao ati, “Uzaudin paꞌi, aonaa kizi utamakapan wuruꞌu Phariseenao kaduz kidaz, kadimanaꞌoraz uiribainan naꞌiki utuubarudinan, naꞌapa yeast tuubarudaꞌakan kawan poroom-biꞌi. Ĩaipan karikaonan patukapa-kao kaimanainao pidannao kawan, mazan aonaa mishiꞌo mani wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mazan ipai dizapa-kariwai kidaz, ipaiꞌo nii uaida-kida-kao. Naꞌiki ipai wuruꞌu taapa-kariwaiz mashaa, ipaiꞌo nii uaitapa-kida-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ukauꞌan naꞌapam pukiauzon marutaꞌo-karuꞌu, ipaiꞌo nii uabata-kida-kao kanadaꞌo-karuꞌu. Naꞌiki kanom mashaudaꞌuꞌo pukowaadan kabaun nazo ii, diiwaꞌo nii ukowaada-kao pidannao baokopainapa-kizi ii. ");
INSERT INTO wapNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Aizii õkian unao ati õpaonarunao. Manaꞌa utariaꞌanaꞌa wunao aiaꞌa, zowiaꞌoraz pidan. Ĩzowian daunaꞌan pidan, uruu ukaduz ĩshaꞌapatanii. ");
INSERT INTO wapNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mazan õkian uꞌati, utarii paꞌan Tominkaru ai, uruu mishiꞌo paꞌan umaꞌozakan. Uzowian daunaꞌan pidan, ukabootan niizu Tuubaruꞌo Tikazi wuꞌiti. Ukauꞌan õkian unao ati, uruu ai paꞌan utarii. ");
INSERT INTO wapNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Aonaa mooko bakaꞌiaudaꞌu parikowarunao selliauzo-kao dono, ĩwinipinaa soo dyaꞌutam puraata sodi kida karikaonan? Mazan upuꞌu zii aonaa baudaꞌapa Tominkaru manyukunuutan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Naꞌiki atii uaitapa zii naꞌapaudaꞌum uzowauda kida uzowau idaꞌa. Ukauꞌan manaꞌa utariaꞌanaꞌa. Aitaniiman unao, powaꞌaꞌo zii manawun umarainapa-kao, iribaꞌo parikowarunao ai.” ");
INSERT INTO wapNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Õkowaadan nii uꞌati aimaakan mishiꞌo. Naꞌiaꞌoram pidan kowaadaꞌo õpidanan paugaru ipai pidannao kanaapuꞌu, naꞌapaꞌo nii kapam Daonaiora Aokazi Ikiꞌo, kowaadan upidanan uruu, ipai Tominkaru angelinnao abatapan puꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mazan naꞌiaꞌoram pidan kowaadaꞌo pidannao kanaapuꞌu pamarinaꞌatan õgaru, naꞌapaꞌo nii kapam õmarinaꞌatan uruu Tominkaru angelinnao kanaapuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Naꞌiaꞌoram pidan dakoopaꞌo Daonaiora Aokazi Ikiꞌo, upuꞌaꞌo nii mazan uDaru mainaabatan wuruꞌu dikauda kidaꞌoraz uparadan udauꞌan. Mazan aizii pidan wuruꞌu dakoopaꞌoraz Kaimanaꞌo Doronaa, aonaa naꞌapainim nii umainaabata-kao wuruꞌu uparadanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Aizii, uzaamata-kao dono, naꞌiki unaꞌaka-kao dono synagogue iti kida, naꞌii kizi upishaa-kao. Oo unaꞌaka-kao dono naobanainao kanaapu iti. Aizii ĩpishaan donoꞌo naa unao naꞌii, manaꞌa utariaꞌanaꞌa, oo udopiidinaꞌanaꞌa udawatan dauꞌu naꞌapam nii udakoꞌatin ĩparadan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ushaꞌapanum kauꞌan Kaimanaꞌo Doronaa kaminkaꞌutan nii pugaru. Uruu idaꞌanaꞌo nii puaitapan naꞌapam nii pudakoꞌatin pidannao paradan uruu dono.” ");
INSERT INTO wapNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aizii pidannao bii iki, baudaꞌapa pidan kian Jesus ati, “Tiichaa, pudyuuda õꞌinawuzu buutan kapam õidiwau nii, wuru diꞌikiꞌi aimaakan kida wadaru waꞌakaniaz pamawakan idi.” ");
INSERT INTO wapNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mazan Jesus kian pidan ati, “Kanom zaamatanii mooko õgaru buutaꞌo nii aimaakan patumaaka pugaru naꞌiki puꞌinawuzu ati?” ");
INSERT INTO wapNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Uruu idi powaꞌa zii koshan Jesus kian ipai pidannao ati, “Asakiꞌi, uzaudinapa paꞌi. Aonaa kizi uaipaabiꞌian naꞌiki unaꞌazootapan pabiꞌinaaka sodi kida aimaakan. Ushaꞌapanum kauꞌan kashaꞌapauzi-karu idaꞌan aonaa pidan ikodan konaukii-karu naꞌiki kaimanaꞌo mashaapa-karu,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Udaunaꞌan Jesus kowaadan naa ĩꞌati diꞌitinapa-kinai kuwai. Kaikapaꞌo wuruꞌu kuwai ukowaadaniaz ĩꞌati: “Kainaꞌa pidan kapuraatanuꞌo, naꞌiki kainaꞌa utaapanii udaruꞌo amazada, uzakapun wiizi kida. Uruu dono ipai upaoriba kida kaakan madowaaka kida paꞌidiwaru. ");
INSERT INTO wapNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Uruu idi udiꞌitinpan, naꞌiki ukian panyukunuu ii. ‘Naꞌapa dii paꞌi õshaꞌapatinan, aonaa naꞌiam nii õkasabaꞌuan õpaoriba aka kida.’ ");
INSERT INTO wapNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Udaunaꞌan ukian panyukunuu ii. ‘Õaitapa naꞌapam nii õshaꞌapatinan. Õsoꞌoobiꞌian nii ipai wuruꞌu õshaꞌapauz dapunaa kidaz, õtoma kizi powaꞌa zii udaru kidaꞌo manawun uwadaun nii. Uruu kaimanaꞌo niꞌi naa naꞌii õkasabaꞌuan ipai õpaoriba aka, naꞌiki ipai baꞌoran kaduz kida aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Uruu daunaꞌan õkian nii õnyukunuu ii. Aizii kainaꞌaꞌa naa diriꞌi, diriꞌi wanyukunui, naꞌiki aimaakan kida kasabaꞌuu-kao. Turuaꞌo nii õmashaapan uꞌidaꞌan kotuaꞌiki, iribaꞌo nii wunu õdobatan uꞌidaꞌan. Aizii aonaꞌo niꞌi naa kanom dauꞌati õdopian. Õnaꞌan niꞌi naa kabaunuꞌu, soo õaroapatinan naa, naꞌiki õtuzapatinan naa naꞌiki õkonaukiitinan niꞌi naa karikaonan.’ ");
INSERT INTO wapNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Mazan uruu dono Tominkaru kian uꞌati. ‘Mishi pugaru maaitapin-kaꞌo pidan. Aizii wuru wamarutan idaꞌaꞌa õsoꞌotan nii punizowan naꞌiki pumawakan nii. Aizii ipai pupaoriba aka naꞌiki ipai aimaakan wuruꞌu pukasabaꞌuunii kidaz, kanomaꞌo niꞌi naa zaamataz?’” ");
INSERT INTO wapNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Udaunaꞌan Jesus kian naa koshan pidannao ati, “Naꞌapa kapam wuruꞌu pidannao, diꞌitinpainaouz soo pakapuraatanun dauꞌu. Kainaꞌa diriꞌiꞌi naa ĩkasabaꞌuan papuraatan naꞌiki pashaꞌapauz kida diinaꞌitiꞌo tannaa niꞌi. Mazan Tominkaru tukapan ĩdyaun mapuraatan ziwunao nii, ushaꞌapanum kauꞌan aonaa ĩshaꞌapatinan Tominkaru aipan kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Udaunaꞌan Jesus kian patominapa-kidaniinao ati, “Aonaa ukaziwadapaꞌanaꞌa uzowau udiꞌitinpan idaꞌan kanomaꞌo nii unika naꞌiki utuza ukakupa-kinaa nii, oo kamicha ukaiwadan nii dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mishiꞌoraiman kakupa-karu, powaꞌaꞌo umanawunun wanyukunui ai, naꞌiki nanai, powaꞌaꞌo umanawunun kamicha ai. ");
INSERT INTO wapNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aushaa udiꞌitapa watonao. Aonaa ĩpaowinan, aonaa ĩkasabaꞌuan papaoriba aka, aonaa ĩdapu nii oo aonaa ĩtoman kabaun kida pakasabaꞌuu kizi nii papaoriba aka. Mazan Tominkaru taapanii, naꞌiki upaapanii paꞌan ipai ĩdyaun. Aitaniiman unao, powaꞌaꞌo zii umanawunun kotuꞌuznao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Turuu mani pidan ikodan pakakupa-kinaa nii kotuaꞌiki zaa, padiꞌitinpan idaꞌan tuukii wuru dauꞌaꞌa aimaakan kidaz? ");
INSERT INTO wapNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aizii pumaturuukan an puikodan masakaudaꞌu pukakupa-kinaa nii, pudiꞌitinpan idaꞌan kaziwa. Kandii nii mooko pukaziwadapaꞌazon zii puzowau baꞌoran aimaakan kida dauꞌati? ");
INSERT INTO wapNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Aushaa udiꞌitapa amazada ii akaꞌo soosoi, konaunam kida utukapa-kao. Padamata aonaa ĩkaudinan, aonaa ĩtoman pakamichan nii. Mazan õkowaadan nii unao ati, upuꞌu zii King Solomon, umanawun kidaꞌo ushaꞌapauz, umanawunuꞌo umashaapan. Mazan upuꞌu zii aonaa ukamichan konaunaman wuru kawanuꞌu konaunam kidaꞌoraz soosoi. ");
INSERT INTO wapNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tominkaru taapanii naꞌiki ukakamichantapanii konaunam pinidi kida baara ii akaꞌo. Aiziꞌo putukapaꞌakan baara ii akaꞌo pinidi, kaiman naꞌiki ziwu. Mazan waikanaꞌan ipaiꞌo nii ukawaoda-kao, tikazi sharawaa-kao nii uꞌidi. Aonaꞌo nii mooko Tominkaru saabaan naꞌiki ukakamichantan unao powaꞌa zii? Mishi unao masakaudaꞌu sodiꞌo karikaonan umishidan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ukauꞌan aonaa ukaziwadaꞌanaꞌa uzowau, udiꞌitinpan idi tuukii, uaitapaꞌazon idi kanomaꞌo nii unika, oo kanomaꞌo nii utuza. ");
INSERT INTO wapNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Soo wunaouꞌu maaitapa-kaꞌoraz mishiꞌo Tominkaru, ĩnao paꞌan kaziwadapauzonao pazowau naꞌapa. Udaru Tominkaru, ipai uaitapan wuruꞌu uaipanuz naꞌapa kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mishiꞌoraiman udiꞌitinapa tuukii Tominkaru naobanai-tinan dauꞌu, naꞌiki umashaapa kaiman uparadan kawanaꞌati. Uruu idi utaan nii uꞌati wuruꞌu naꞌapa kidaꞌoraz aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Õdainao, aonaa utariaꞌanaꞌa unaꞌapaudaꞌu sodin idi karikaonan. Konaukiaꞌo nii paꞌan udaru Tominkaru taan kaiman kidaꞌo aimaakan unao ati, wuruꞌu zaamatainaouz uruu panaobanaa nii. ");
INSERT INTO wapNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Uselliaꞌa naa ushaꞌapauz kida, utaa kizi puraata patakaꞌutinainao ati. Ukapuraatan kizi naꞌiki ukashaꞌapauz kizi aokazi ii paꞌan. Naꞌii aonaꞌo nii paꞌan uipaiuzon, naꞌiki aonaꞌo paꞌan koidimikinao koidapan wuruꞌu ushaꞌapauz kidaz. Naꞌiki aonaꞌo nii paꞌan mazinao nikan wuruꞌu ushaꞌapauziz. ");
INSERT INTO wapNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aizii naꞌiam an pidan taapan pashaꞌapauz, karikaonanuꞌo nii utaapan panyukunuu wuru diꞌitiꞌi, utaapa-kiziz pashaꞌapauz. ");
INSERT INTO wapNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Zaudinpaꞌa naa paꞌi pumashaapa, pukaiwadapaꞌa naa pukamichan, naꞌiki tuudinpaꞌa naa putaapa puzadao. Naꞌiki maodapaꞌa naa putaapa pulampan. Panaadon mashaꞌapakiikaꞌo nii aimaakan shaꞌapaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Naꞌapa puzaudapatin, poitoruinao zaudapauzon kawan panaobanaa kaawan, mazidainao aroapa-kizi iki. Aizii ĩnaobanaa kaawan, udau-dauan paniinom, kadiman ĩdaꞌataꞌakan paniinom uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kaimanaꞌo nii manawun wunao nyukunuuꞌu poitoruinaouz, ĩnaobanaa ikodan idi ĩdyaun pokodapa, naꞌiki zaudinapa. Õkowaadan nii unao ati naꞌapam nii ĩnaobanaa shaꞌapatinan. Usoꞌotan daunaꞌan pachaakitan, udyuudan nii ĩsakanatan. Udaunaꞌan umaokodan niꞌi naa poitoruinao wanyukunuu nii miisa baaraꞌa. Naꞌiki udyuudan niꞌi naa ĩaroopan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kaimanaꞌo nii manawun poitoruinao nyukunuu, panaobanaa ikodan idi ĩdyaun zaudinapa, naꞌiki pokodapa, ukaawan puꞌu tomun-zikon oo tomun-zikon daunaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Aizii pidan kadapuꞌo aitapan an mani naꞌapainim koidimiki morotinaꞌazon padapu, aonaꞌo nii uwaꞌakan padapu. Mazan unaꞌian nii uzaudapan oo uawunuutapan, naꞌiki aonaꞌo nii ukashaapan koidimiki shaazoan papaniinomiz naꞌiki aonaꞌo nii ukashaapan umorotan padapu nazo iti. ");
INSERT INTO wapNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aizii unao, naꞌapaꞌa naa paꞌi kapam umashaapa zaudinapa. Ushaꞌapanum kauꞌan aonaꞌo nii uaitapan naꞌapainim nii Daonaiora Aokazi Ikiꞌo kaawan. Ukaawan nii umazaudinapakan puꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sariapa Peter kian Jesus ati, “Wanaobanaa, kaiwuruꞌu pukakuwaatinanuz diꞌitinapa-kinai kuwai idaꞌan, soo waunao atiꞌo kaiwuruꞌu? Oo ipaiꞌo baokopa waunao naꞌiki pidannao atiꞌo kapam?” ");
INSERT INTO wapNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesus kian uꞌati, “Naꞌiaꞌoram poitorui zowaunaa kainaꞌa mishiꞌo ukaudinauzon kaiman, izoꞌatiaabaꞌo, naꞌiki aitapaabaꞌo kapam. Uruuꞌo nii naobanai zaamata kazowautapaꞌo nii ipai aimaakan, naꞌiki pidannao wuruꞌu mashaapainao kidaz udapu ii. Taapaꞌo nii kaiman baꞌoran poitoruinao naꞌiki taaꞌo nii ĩwanyukunuu nii kaiman naꞌiki patumaaka, wanyukunui maokodauzo-kao kawanaꞌati, naꞌapa panaobanaa aitan kawanaꞌati uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kaimanaꞌo nii manawun poitorui nyukunuu, unaobanaa kaawan an naꞌiki uikodan uruu kaiman ukaudinan, ipai ushaꞌapatan wuruꞌu panaobanaa dyuudanii kidaz ushaꞌapatan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Õkowaadan uꞌati mishiꞌo, unaobanaa dyuudan nii uawunuutapan ipai aimaakan wuruꞌu paꞌidiwau kidaz. ");
INSERT INTO wapNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Mazan aizii wuruꞌu poitoruiz, zaamata-kariwaiz poitoruinao naobanaa nii, kian an panyukunuu ii, ‘Ei, kotuaꞌa naa õnaobanaa makon, atii diꞌi aonaa zii ukaawan.’ Uruu daunaꞌan upatakaꞌutan naa naꞌiki ubaꞌizitapan naa wuruꞌu baꞌoran poitoruinaouz, daonaioranao naꞌiki zunnao. Aizii uruu, umashaapan uaroapatinan naa, utuzapatinan naa, naꞌiki upoꞌidipan naa karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mazan baudaꞌapa kamoo unaobanaa kaawan nii. Ukaawaꞌakan nii mashaꞌapakiaka, poitoruinao naobanaa mazaudinapakan puꞌu, aonaꞌo nii uaitapan panaobanaa kaawan. Uruu dono upatakaꞌutan nii wuruꞌu poitoruinao naobanaaz tuukiaꞌo idaꞌan manawun. Naꞌapaꞌo nii upatakaꞌuta-kao pidannao dikintapainao kawan, aonaꞌoraz ĩmishidaꞌazon. ");
INSERT INTO wapNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Aizii poitorui, wuruꞌu aitapaꞌoraz padamata ipai kanom panaobanaa aiapanii, oo dyuudanii kida ushaꞌapatan paꞌati. Mazan upuꞌu aonaa ushaꞌapatinan sakita, padyuuda-kao kawanaꞌati. Uruu dikin ii ubaꞌizii-kao nii tuukii. ");
INSERT INTO wapNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mazan aizii poitorui, aonaꞌo uaitapan kanom panaobanaa aiapanii shaꞌapata-kao paꞌati, mazan upuꞌu kowas utiwaan pashaꞌapatan aimaakan, mazan ushaꞌapatanuzu panaꞌiti karikaonan. Aizii ushaꞌapatan idi aimaakan panaꞌiti, ubaꞌizii-kao nii udikin ii masakaudaꞌu. Aizii naꞌapam udiriꞌin aimaakan taa-kao pidan shaꞌapatan nii, naꞌapaꞌo nii kapam uaiapa-kao ushaꞌapatan aimaakan, utaa-kao kawanaꞌati uꞌati. Aizii pidan wuruꞌu taa-kariwaiz uꞌati powaꞌa zii aimaakan ushaꞌapatan nii, powaꞌaꞌo nii zii kapam uaiapa-kao ushaꞌapatan aimaakan, utaa-kao kawanaꞌati uꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesus kian, “Õwaꞌatin daꞌatiꞌi, õdyuuda-kao idi õpuꞌukadaꞌanan tikazi imiꞌi baara an. Kadimanaꞌoraꞌa naa padamata õaipan õmaoda-kidanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Naꞌiki kainaꞌa zii kapam kashaꞌoraꞌo baiaapa-kidaꞌazoo-kao õꞌati. Naꞌiki õapichauta-kida-kao nii ubaoko iti, pidan apichauta-kida-kao kawan wunu baoko iti uchikaawunuu-kao dono. Kashaꞌora utaapan õnyukunuu, kadimanaꞌoraꞌa naa padamata õaipan ushaꞌapataꞌaka-kao, uipai aka kiziꞌi naa. ");
INSERT INTO wapNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kanom uzauda-kidan õshaꞌapataꞌanan wuruꞌu õkaawanuz daꞌatiꞌi? Õnaꞌakan kaimanaꞌo mashaapa-karu, pidannao mashaapa kizi kaiman baokopa wuru amazada baara anaꞌa? Õkowaadan nii unao ati kanom dauꞌatiꞌo wuruꞌu õwaꞌatinuz. Õwaꞌatin daꞌatiꞌi imiꞌi baara ati, aonaa õbaokopataꞌanan mani pidannao, mishiꞌoraiman õbuutaaka-kidaꞌanan paꞌan pidannao pairibannao kida ai. ");
INSERT INTO wapNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Uruu idi pidannao buutaakapan niꞌi naa pairibannao kida ai. Panaadon kainaꞌa bakaꞌiaudaꞌu pidannao mashaapainao baokopa paudainao tuma baudaꞌapaꞌo kabaun idaꞌa. Panaadon idikinaudaꞌuꞌo nii pidannao ĩnao bii iki zaamatan õgaru panaobanaa nii, uruu dikin ii wuruꞌu dyaꞌutamainaouz toꞌoran niꞌi naa ĩꞌati. Panaadon dyaꞌutamaꞌo nii ĩzaamatan õgaru panaobanaa nii, uruu dikin ii wuruꞌu idikinaudaꞌuinaouz toꞌoran nii ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Naꞌiki daruinao toꞌora-kizaitapan nii paudainao daonaioranao, õgaru dikin ii, panaadon ĩdainao kidaꞌo nii toꞌora-kizaitapa padarunao õgaru dikin ii. Naꞌiki daroinao toꞌora-kizaitapan nii paudainao zunnao õgaru dikin ii. Panaadon ĩdainao zunnaouꞌo nii toꞌora-kizaitapa padaronao. Naꞌiki zunnao toꞌora-kizaitapan nii padinizonao õgaru dikin ii, panaadon ĩdinizonaouꞌo nii toꞌora-kizaitapa paimauzonao, õgaru dikin ii.” ");
INSERT INTO wapNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Udaunaꞌan Jesus kian ipai pidannao abatapainao ati, “Aizii naꞌapainim utukapan ishaꞌiz marutadinan wakadapu iki, sariapa ukian. ‘Akaa waꞌati wunu.’ Atii kaawa mishi wunu. ");
INSERT INTO wapNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aizii naꞌapainim utukapan an awaru waꞌatin udaba ikinapa. Uruu idi ukian nii, ‘Akaa wiichaꞌo nii amazada aizii.’ Atii wiicha mishi amazada naꞌapain. ");
INSERT INTO wapNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Unao taapinpainao kaimanaꞌo kaikiniꞌi! Uaitapa ukowaadan aimaakan shaꞌapaꞌazon. Aizii utukapan idaꞌan ishaꞌiz marutan uaitapa wunu waꞌatin. Naꞌiki awaru idaꞌan, uaitapa amazada wiichan nii. Mazan kanom niꞌo mooko aonaa uaitapan ukowaadan, kanom niꞌo wuruꞌu õshaꞌapaapanuz aimaakan kida kai, daꞌanaꞌa imiꞌi baara an?” ");
INSERT INTO wapNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesus kian koshan, “Kandii nii mooko aonaa uaitapan uaipan ati, naꞌapam aimaakan shaꞌapata-kao kaiman naꞌiki sakitapa? ");
INSERT INTO wapNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aizii pukasharutaakapan an pidan tuma. Uruu dikin ii unaꞌakan pugaru kootowapa-kizai iti. Mazan ukaawa-kidan uaꞌii pugaru naꞌiti, putiwaa pusaabaa-kidan punyukunuu utuma. Aonaan an pushaꞌapatinan naꞌapa, mishiꞌo nii uawautan pugaru kootowapa-kidauzo pidan kanaapu iti. Udaunaꞌan kootowapa-kidauzo pidan taan niꞌi naa pugaru police kaꞌu iti, uruꞌo niꞌi naa kaboota pugaru taraa-kizai iti. ");
INSERT INTO wapNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Õkian puꞌati, punaꞌian nii, atii pukawinipinaatan ipai daunuudaꞌu aiapa-kariwai pukodita-kinaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Uruu dono pidannao kaawan Jesus idaꞌati, naꞌiki ĩkowaadan uꞌati, naꞌapam Pilate zowii-kidauzon Galilee Baara ikiinao pidannao Tominkaru Dapu ii, ĩkawaodapan puꞌu paꞌuza Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sariapa Jesus kian ĩꞌati, “Kaiwuruꞌu ukakuwaapanuz õꞌati kaikapaꞌa, utiwaan ukowaadan õꞌati ĩmawakan kaikapaꞌa, paꞌoian idiꞌo manawun tuukii, baꞌoran Galilee Baara sannao ai? ");
INSERT INTO wapNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aonaa paꞌoian idiꞌo mani tuukii baꞌorainao ai, wuruꞌu ĩmawakanuz kaikapaꞌa. Aizii unao, umatanawatinkan an uꞌoian ai, umawakan nii kapam. ");
INSERT INTO wapNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aizii mani mooko taonawuꞌu, 18 pidannao mawakainaouz, dokoaꞌo kabaun dikian idi ĩdyaun Siloam ii, Jerusalem iaꞌoraz. Ĩꞌoian idiꞌo manawun tuukii puaitapan ipai baꞌoran Jerusalem sannao ai? ");
INSERT INTO wapNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Õgaru, õkian aonaa paꞌoian idiꞌo mani tuukii baꞌorainao ai wuruꞌu kabaun zowianuz ĩdyaun. Aizii unao, umatanawatinkan an uꞌoian ai, umawakan nii kapam,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesus kowaadan diꞌitinapa-kinai kuwai. Kaikapaꞌo wuruꞌu kuwaiz: “Kainaꞌa pidan paowaꞌo dizoo-karu uuda pazakapun ii. Fig kiaꞌo udakota-kao. Atii baꞌoran dono zii kapaoribaꞌo makon naꞌiti, utukapaꞌanan naa papaoriba kaakan, mazan aonaa baudaꞌapa uikodan papaoriba aka. Baꞌoran dono umakon koshan. Atii naꞌapa umakoꞌanpan aonaa baudaꞌapa uikodan papaoriba aka. ");
INSERT INTO wapNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Uruu idi ukian papaoriba taapiki ati. ‘Aizii idikinaudaꞌuꞌu naa wunu õawunuutaꞌanpan õpaoriba kaakan, mazan aonaa baudaꞌapa zii õikodauzon uꞌaka. Ukauꞌan, aizii pubarotaꞌa naa paꞌi ukadunaa. Aonaa kanom niꞌi naa utaapa-kao, madiwautapakaꞌa naa manawun uzaamatapan zakapu baara.’ ");
INSERT INTO wapNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mazan paoribai taapiki kian. ‘Marinaꞌa zii shoman unaꞌan baudaꞌapaꞌa naa wunu. Õsaabaan niiz kaiman, naꞌiki õkichadan nii uoroda an õkaboota kizi nii tapiꞌiza diki, uziwu-kinaa nii, panaadon uruu daunaꞌan kaakaꞌo niiz. ");
INSERT INTO wapNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aizii ukaakan an baꞌoran wunu kaimanaꞌo nii unaꞌan. Mazan aizii, umakaakakan an uruu turuaꞌa naa paꞌan ubarotaꞌaka-kao,’ ukian.” ");
INSERT INTO wapNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Baudaꞌapa kamoo Jesus kakuwaapatinan Jewnao ati, synagogue ii, Sookapa-karu Kamoon dono. ");
INSERT INTO wapNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Uruu dono naꞌiaꞌo zun, oiaꞌo doronai zaamatapanii. 18 wunu odawuꞌu koraudinpan, aonaa naꞌapam kowas osakitapadinan. ");
INSERT INTO wapNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aizii Jesus tukapan oroo, sariapa ukian oꞌati, “Õdadakoo, aizii õsoꞌotan purinaa puꞌai.” ");
INSERT INTO wapNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Udaunaꞌan upishataꞌakan naa oroo, sariapa kowas odawuꞌu sakitapadinaꞌakan. Tuukii okonaukii-kidan Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Uruu idi tuukii kazowautapaꞌo synagogue toꞌoran, patukapan idi Jesus kakudan wuruꞌu zunaz Sookapa-karu Kamoon dono. Udaunaꞌan wuruꞌu kazowautapaꞌo choochiapa-karu kian ipai pidannao ati, “Kainaꞌa 6 kamoo taa-kao, pidan kaudin-kinaa nii. Ukauꞌan uwaꞌati uruu dono uaipan an ukakuda-kao urinaa ai. Mazan Sookapa-karu Kamoon dono aonaa turuu uwaꞌatin,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sariapa Jesus dakoꞌatin uparadan, naꞌiki ukian ĩꞌati, “Unao taapinpainao kaimanainao nii kaikiniꞌi! Aonaa mooko ubuzuutauzon naꞌiki uawautauzon ubooin, oo ukawaron wunu diꞌiti, ĩtuzaꞌazon an wunu Sookapa-karu Kamoon dono? ");
INSERT INTO wapNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aizii mani mooko aoroꞌo Abraham takaan-daunuzo, Satan watudapaniaz 18 wunu? Aonaa mooko kapam turuu obuzuuta-kao Sookapa-karu Kamoon dono?” ");
INSERT INTO wapNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tuukii pidannao dakoopainao Jesus baꞌazoinpan, paabatan idi uparadan naꞌapa. Aizii baꞌorainao tuukii paꞌan ĩkonaukii-kidan patukapan ipai wuruꞌu Jesus shaꞌapatanuz kaiman kidaꞌo manawun aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus kian pidannao ati, “Kanom kawan dii Tominkaru naobanai-tinan, naꞌapa dii paꞌi õkowaadanuz?” ");
INSERT INTO wapNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uruu idi ukian, “Kaikapaꞌo kawanuꞌo wuruꞌu Tominkaru naobanai-tinanuz. Aizii pidan paowan duusodiꞌo mustard uuda pazakapun ii. Udaunaꞌan usodaꞌakan naa udaru naꞌapa zakapu ii akaꞌo paoribai kida dokoꞌan kawan, atii kotuꞌuznao waꞌatin ĩtomaꞌanan naa pashimaka nii uwaoda kaduꞌan kida.” ");
INSERT INTO wapNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Udaunaꞌan ukian koshan ĩꞌati, “Kanom kawan dii õkainaabatan Tominkaru naobanai-tinan. Naꞌapa dii paꞌi õkowaadanuz?” ");
INSERT INTO wapNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Uruu idi ukian, “Kaikapaꞌo kawanuꞌo wuruꞌu Tominkaru naobanai-tinanuz. Naꞌapa zun tomauzon kawanuꞌo bread. Ozaamatan masakaudaꞌu poroom basii zoꞌati, udaunaꞌan omuudan masakaudaꞌu yeast upooda-kinaa nii, masakaudaꞌu daunaꞌan upoodaꞌakan naa udaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aizii Jesus makopaanan dono Jerusalem iti, utominapa-kidaanan pidannao wuruꞌu udaru kidaꞌo naꞌiki duusodi kidaꞌo wiizainao kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Baudaꞌapa pidan naꞌii pishaan Jesus, “Naobanai, naꞌapaudaꞌum sodiꞌo nii karikaonan pidannao kazannaatinan papatakaꞌuta-kao ai paꞌoian dikin ii?” ukian. Sariapa Jesus kian ipai abatapainao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Maꞌozakaꞌa naa paꞌi utiwain, umorota kizi wuru idaꞌanaꞌa mazowaꞌoraz paniinom. Ushaꞌapanum kauꞌan iribaꞌo nii pidannao tiwaan pamorotan naꞌan, mazan aonaꞌo nii ĩturuan ĩmorotan. ");
INSERT INTO wapNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ushaꞌapanum kauꞌan ukaawan nii naꞌiti, kadapuꞌo tarataꞌakan puꞌaꞌa naa papaniinomiz. Uruu idi unaꞌian niꞌi naa ukadishitapan paniba ii, udau-daupan naa paniinom, naꞌiki ukian nii, ‘Naobanai, pudaꞌata paniinom waꞌati.’ Mazan naobanai kian nii uꞌati. ‘Aonaa õaitapan unao, aonaa õaitapan naꞌikiꞌoram uwaꞌatin.’ ");
INSERT INTO wapNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Uruu idi unao kian nii uꞌati. ‘Waaroopauzonii naꞌiki watuzauzonii shaꞌatii putuma. Naꞌii aka shaꞌatii pukakuwaapatinauzon wawiizi ii aka.’ ");
INSERT INTO wapNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mazan ukian nii koshan unao ati. ‘Õkii shaꞌatii uꞌati, aonaa õaitapan unao, aonaa õaitapan naꞌikiꞌoram uwaꞌatin. Ukauꞌan umako õꞌai diꞌikiꞌi, ipai unao shaꞌapaapauzonao oiaꞌo.’ ");
INSERT INTO wapNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tuukiaꞌo nii udopian, uzaadan nii tuukii naꞌiki ukuzowan nii uudako, utukapan an Abraham, Isaac, Jacob, naꞌiki ipai kotuaꞌo Tominkaru prophetinnao, mashaapan kaiman Tominkaru naobanai-tinapa-kizi ii, uwaꞌaka-kao puꞌaꞌa naa paniba ii. ");
INSERT INTO wapNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Uruu dono iribaꞌo nii baꞌoran kaduz pidannao waꞌatin waoko iki, wakadapu iki, naꞌiki wadabaazi iki kanaapu kida. Naꞌiki ĩsakanatan nii konaukiaꞌo aroapa-karu idaꞌati, wuruꞌu Tominkaru naobanai-tinapa-kizi iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Uruu dono, pidannao aonaꞌo ĩtaapa-kao umanawunuꞌo nii kai, mazan diinaꞌitiꞌi umanawunuꞌo nii ĩtaapa-kao. Naꞌiki pidannao umanawunuꞌo ĩtaapa-kao kai, diinaꞌitiꞌi aonaꞌo nii ĩtaapa-kao umanawunuꞌo nii paꞌan,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naꞌapain Jesus kakuwaapatinan dono, pabiꞌi kida Phariseenao waꞌatin Jesus idaꞌati, naꞌiki ĩkian uꞌati, “Pumako paꞌi diꞌikiꞌi wawiizi iki. Pumako baꞌoran wiizai iti, ushaꞌapanum kauꞌan naobanai Herod dakotan pazowii-kidan pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mazan Jesus kian ĩꞌati, “Umako Herod diꞌiti, taapinaꞌoraz aitapaꞌo nii. Ukowaada uꞌati õkian, õsoꞌoopan nii oiaꞌo doronainao pidannao diꞌiki, naꞌiki õkakudan nii pidannao kida parinaa ai. Õkaudinan nii aizii, waikanaꞌan, naꞌiki idikinaudaꞌutan kamoo idaꞌa, uruu õkaꞌiitaꞌakan naa õkaudin-kizi. Kii paꞌi ukowaada uꞌati õparadan. ");
INSERT INTO wapNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Upuꞌaꞌo nii mazan õdobatapaanan aizii, waikanaꞌan, naꞌiki baꞌoran kamoo. Aonaa turuu Tominkaru prophetin zowii-kao naꞌiam karikaonan, mazan uzowii-kao nii soo Jerusalem ii.” ");
INSERT INTO wapNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aizii diꞌi kaikapa Jesus paradan wiizai Jerusalem atiꞌi. Ukian, “Jerusalem, Jerusalem, pugaru diꞌikiinao pidannao zowiipauzonii Tominkaru prophetinnao. Naꞌiki ĩnao zowiauzonii paboori idi pidannao dyuuda-kariwainaouz kakuwaapaꞌanan ĩꞌati. Tuukiaꞌo padamata õaipauzon õdokobatan ipai baokopa pidannao, wuruꞌu mashaapainaouz puꞌidaꞌa, naꞌapa kuruku kasabaꞌukan kawan paudainao pakutuba waranuꞌu. Mazan aonaa ĩkashaapinaꞌazon õꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Uruu idi Tominkaru muudan naa ĩdyaun naꞌiki aonaꞌo niꞌi naa powaꞌa unyukunuupan wuruꞌu kabaun ĩtoriinapa kiziz. Naꞌiki õkowaadan nii aimaakan mishiꞌo, aonaꞌo nii powaꞌa ĩtukapan õgaru, atii diinaꞌitiꞌi, ĩkian donoꞌo nii zii õdauꞌan, ‘Marii Tominkaru kaimanan, wuru atiꞌi Naobanaiz, kaawaꞌoraz uaipan kawanaꞌati.’” ");
INSERT INTO wapNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Baudaꞌapa kamoo Jesus makon uaroopaꞌanan Pharisee dapu iti, uruu kazowautapaꞌo pamin-Phariseennao. Aizii wuruꞌu uaroopaꞌananuz Sookapa-karu Kamoon donoꞌo. Uruu idi naꞌiaꞌa naa pidannao diꞌitapan Jesus kaimanaiman, ĩtukapaꞌazon ushaꞌapatan aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Upuꞌaꞌa naa pidan poodapaꞌo utabaꞌu, naꞌiki uanoba waꞌatin Jesus idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sariapa Jesus kian wunao atiꞌi, tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki Phariseenao ati. Ukian ĩꞌati, “Naꞌapa dii kakinaorii taa-kariwaiz waꞌati dyuudan shaꞌapatin-karu? Ukashaapa wakakudan karinaꞌo pidan Sookapa-karu Kamoon dono, oo aonaa?” ");
INSERT INTO wapNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mazan aonaa baudaꞌapa pidan dakoꞌatin Jesus paradan. Udaunaꞌan upishataꞌakan naa wuruꞌu pidanaz, sariapa ukakudaꞌakan. Udaunaꞌan udyuudan naa umakon. ");
INSERT INTO wapNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Uruu daunaꞌan ukian naa koshan pidannao ati, “Aizii mani diꞌi unao dani, oo utapiꞌizan waotan an munapoꞌo mowaꞌun shaawata, aonaa mani usoꞌotanuzu Sookapa-karu Kamoon dono?” ");
INSERT INTO wapNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mazan aonaa ĩaitapan naꞌapam padakoꞌatin Jesus paradan. ");
INSERT INTO wapNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesus tukapan pabiꞌi kida pidannao tuukii ĩaipan pasakanatan umanawun kidaꞌo tabai idaꞌa. Uruu idi uparadan ĩꞌati diꞌitinapa-kinai kuwai idaꞌan, kaikapaꞌo wuruꞌu ukianuz ĩꞌati: ");
INSERT INTO wapNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Naꞌapainim udapada-kao dono aroopaꞌo nii mazidainao diꞌiti, manaꞌa usakanataꞌanaꞌa umanawun kidaꞌo tabai idaꞌa. Panaadon kainaꞌa kadapuꞌo dapadan umanawun kidainao pidannao powaꞌaꞌo zii uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Udaunaꞌan kadapuꞌo, wuruꞌu dapadaꞌoraz unao waꞌatin nii uꞌidaꞌati naꞌiki ukian nii uꞌati, ‘Marii paꞌan arawu sakanatan daꞌaꞌa,’ ukian nii. Uruu idi usakanatan niꞌi naa naꞌiam karikaonan. Uruu idaꞌan ubaꞌazootin-kida-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ukauꞌan naꞌapainim udapada-kao dono, manaꞌa usakanataꞌanaꞌa umanawun kidaꞌo tabai idaꞌa, mishiꞌoraiman usakanata panaꞌitinapu. Aizii kadapuꞌo wuruꞌu dapadaꞌoraz unao, utukapan idi usakanatapan naꞌii, ukian nii uꞌati. ‘Daꞌati paꞌan puwaꞌatiꞌi õpaonaru, pusakanata kizi umanawunuꞌo tabai idaꞌa.’ Uruu idi ipaiꞌo nii pidannao tukapan putaapa-kao umanawunuꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Naꞌiaꞌoram pidan tuukiaꞌo uaipan pakazowautapan pidannao, baudaꞌapa kamoo Tominkaru waranuitapa-kidan nii uruu baꞌorainao ati. Naꞌiki naꞌiaꞌoram pidan waranuitapa-kidinaꞌo, mazan baudaꞌapa kamoo Tominkaru zaamatan nii uruu kazowautapaꞌo nii baꞌorainao.” ");
INSERT INTO wapNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Udaunaꞌan Jesus kian aroapa-kidaꞌo ati paugaru, “Naꞌapainim putoman an aroapa-karu, aonaa pudapadaꞌanaꞌa pupaonarunao, naꞌiki puꞌinawuzunao, oo puiribannao, naꞌiki kapuraatan kidainao pidannao wuruꞌu pudapu dazaba an kidainaouz. Ushaꞌapanum kauꞌan ĩnao naꞌapaꞌo nii kapam ĩaroapa-kidan pugaru, uruu naꞌapaꞌo idaꞌan ĩkawinipinaatan wuruꞌu paaroopauzonuz puꞌidaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mazan naꞌapainim putoman an aroapa-karu, pudapada mapuraataniinao, uꞌachoonnao, naꞌiki machiꞌika-kainao, naꞌiki ushaawunnao. ");
INSERT INTO wapNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Unaꞌapan dono, konaukiaꞌo nii pugaru. Ushaꞌapanum kauꞌan aonaꞌo nii kowas ĩkaꞌiitan pakawadauntan wuruꞌu paaroapa-kida-kaoaz. Mazan Tominkaru kawinipinaatan nii paꞌan pugaru diinaꞌitiꞌi, ukadishita-kidan dono mawakainao pidannao, wuruꞌu izoꞌatiinao kidaz uparadan.” ");
INSERT INTO wapNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aizii baudaꞌapa pidan Jesus min-aroapatinan, uabatan idi wuruꞌu Jesus paradanuz kaikapaꞌa, sariapa ukian Jesus ati, “Konaukiaꞌo nii zii manawun pidannao, ĩaroapa-kida-kao dono Tominkaru naobanai-tinapa-kizi ii.” ");
INSERT INTO wapNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mazan Jesus kian uꞌati, “Baukapaiman pidan toman udaruꞌo aroapa-karu, udapada iriba pidannao. ");
INSERT INTO wapNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aizii aroapa-karu kamoon donoꞌo naa, udyuudan naa papoitoru dapadankan dapada-kariwainao pidannao, marii kiziꞌi naa ipai ĩwaꞌatin, ĩaroapanaka kiziꞌi naa. ");
INSERT INTO wapNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mazan ipai dapada-kariwainao pidannao, kainaꞌa ĩparadan kida. “Kiwiiniꞌo kian poitorui ati, ‘Akarachii, aonaa õturuudinan. Kainaꞌa paꞌi õtorian zakapu, ukauꞌan õmakoꞌozon naꞌiti wuruꞌu õawunuutankaꞌazoonuz. Ukauꞌan aonaꞌo nii õmakon aroapa-karu diꞌiti. Pukowaada kizi naꞌapa punaobanaa ati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Baꞌoran kian uꞌati, ‘Akarachii, aonaa õturuudinan. Kainaꞌa paꞌi õtorian 10 boinao, kaudinainao nii zakapu ii. Ukauꞌan õmakon wuruꞌu õtiwaaꞌanan naa ĩkaudinaaban. Ukauꞌan aonaꞌo nii õmakon aroapa-karu diꞌiti. Pukowaada kizi naꞌapa punaobanaa ati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Baꞌoran kian, ‘Akarachii, aonaa õturuudinan. Diikiꞌi zii paꞌi õmazidaꞌakanuꞌu. Uruu idi aonaa õturuudinan õmakon aroapa-karu diꞌiti. Pukowaada kizi naꞌapa punaobanaa ati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Udaunaꞌan poitorui kiwaꞌakan naa, naꞌiki ukowaada ipai panaobanaa ati wuruꞌu parada-karu kidaz. Uruu idi tuukii unaobanaa toꞌoran. Udaunaꞌan ukian papoitoru ati. ‘Kadiman, aizii õaiapa pumakon ipai kazoo kidaꞌo dunapo kawanaꞌati naꞌiki mazoo kidaꞌo dunapo kawanaꞌati wuruꞌu donoi an kidaꞌoraz. Punanaka kizi daꞌati wuruꞌu mapuraataniinao kida pidannao, machiꞌika-kainao, ushaawunnao, naꞌiki tokoozaꞌuupainao kida.’ ");
INSERT INTO wapNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Uruu idi poitorui makon padyuuda-kao kawanaꞌati. Udaunaꞌan ukaawan naa, naꞌiki ukian panaobanaa ati. ‘Kainaꞌaꞌa naa õkaawa-kidan pidannao puparadan kawanaꞌati, mazan kainaꞌa zii tabai mawazoo kidaꞌo.’ ");
INSERT INTO wapNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Uruu idi naobanai kian papoitoru ati. ‘Aizii pumako naꞌiki pukoraꞌuu donoi tokon ii aka, naꞌiki donoi dawun ii aka punaꞌaka kizi pidannao daꞌatiꞌi wuruꞌu mashaapainao kidaz naꞌiiꞌaka. Marii ĩkawazootan õdapu paida.’ ");
INSERT INTO wapNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Pidannao kaawan daunaꞌan, naobanai kian. ‘Aizii õkian nii unao ati, aonaꞌo nii baudaꞌapa pidan, wuruꞌu dapada-kariwainaouz padamata mawaꞌatiꞌizoo-kainaouz, tiwaan õwanyukunuu idionaa, aonaa masakaudaꞌu,’ ukian ĩꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Baudaꞌapa kamoo, iriba pidannao makon kasabaꞌu-kasabaꞌuan Jesus dawuꞌati. Pamakopa-kizi an, Jesus mashaadinaanan, naꞌiki ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Naꞌiaꞌoram pidan tominpaꞌo naꞌiki aipinaꞌo õpoitoru nii, mazan tuukiaꞌo manawun umarainpan pairibannao, padaro, paudaiaro, paudainao, paꞌinawuzunao naꞌiki padadakoonao pamarainpan ai õgaru, naꞌiki tuukiaꞌo umarainpan pamashaapan kaiman oo tuukiaꞌo ukarodinpan, aonaa turuu udaꞌanan õgaru, naꞌiki ukaudinan õtuma. ");
INSERT INTO wapNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Naꞌiaꞌoram pidan aonaꞌo unaꞌakaꞌazon pacrossannaa, aonaa turuu udaꞌanan naꞌiki ukaudinan õtuma. Aizii naꞌiaꞌoram pidan aonaꞌo uaipan pazowii-kao õgaru dikin ii, aonaa turuu udaꞌanan õgaru, naꞌiki ukaudinan õtuma. ");
INSERT INTO wapNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Naꞌiaꞌoram baudaꞌapa pidan unao biiꞌi kaidaꞌaꞌa, tomaꞌo udaruꞌo kabaun, pamadiꞌitapakan puꞌu naꞌapaudaꞌum nii puraata pakaiwaan patoma-kinaa nii naꞌiki paipai-kinaa nii wuruꞌu padapuz? ");
INSERT INTO wapNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mazan pamadiꞌitinapakan puꞌu, upuꞌu zii utoman kabaun wiizi nii, naꞌiki usakitaꞌakan naa kabaun toronnaa kida nii. Mazan aonaꞌa naa ukaꞌiitan paipaian wuruꞌu kabaun patomaꞌazooniaz. Aizii ipai pidannao dobaapainao kida naꞌan, pakawan zii ĩtukapan utoron kida sakitinpan. Uruu idi ĩbanikiitan niizu, naꞌiki ĩshaazootinan nii wuru dauꞌaꞌa pidan tomaꞌazoꞌoraz padamata kabaun. ");
INSERT INTO wapNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Naꞌiki ĩkian nii udauꞌan. ‘Akaa, kotuaꞌa naa arawu sakitan padapu toronnaꞌa, atii diꞌi aonaa zii ushaꞌapatauanuz, aonaa naꞌapainim nii uipaianuz’ ĩkian nii udauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Aizii mani, king dakotan an pamizaataakapan, naꞌiki kainaꞌa 10,000 usoldyaannao. Umizaataakapaꞌazon baꞌoran king tuma. Aizii wuruꞌu baꞌoran king idaꞌa 20,000 soldyaanao, powaꞌaꞌo zii manawun ĩiriban usoldyaannao ai. Aonaꞌo nii mani mooko usakanatan naꞌiki udiꞌitinpan kiwiin pamizaataakapan uaꞌii, utukapa kizi paturuan naꞌiki pakaꞌiitan pamizaataakapan baꞌoran king tuma, dobataꞌo zii usoldyaannao paꞌai? ");
INSERT INTO wapNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aizii uaitapan an pamaturuukan utuma, sariaapaꞌo nii udyuuda-kidan paparadan baꞌoran king diꞌiti umunapon puꞌu zii, ukowaada-kidan uꞌati aonaꞌa naa umizaataakapaꞌazon, mazan ĩkaimanaaka kiziꞌi naa powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Udaunaꞌan Jesus kian koshan ĩꞌati, “Naꞌapa kapam pidan kaudinaꞌazon an õꞌati. Marii udiꞌitinpan kiwiin. Aizii uwaꞌakaꞌazon an mishi wuruꞌu pamarainapanii kidaz, pairibannao naꞌiki ipai aimaakan kida. Naꞌapaꞌo pidan turuu paꞌan ukaudinan õꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kaimanaꞌo wuruꞌu duwuz, mazan duwu manaun anaꞌa naa, aonaa naꞌapam ukuzubaa-kao powaa iti. ");
INSERT INTO wapNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Uruu idi aonaa powaꞌa ukaimanan, atii paoribai diꞌiti, aonaa ukaimanan. Uruu idi ukabootaꞌaka-kao niꞌi naa. Pukakinaon an puabataꞌa naa kakinaorii!” ");
INSERT INTO wapNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Baudaꞌapa kamoo, iriba pidannao zaamaapauzonao tax puraatannaa naꞌiki baꞌoran oiainao pidannao kaawan ĩabataꞌanan Jesus kuwaa. ");
INSERT INTO wapNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Uruu idi Phariseenao, naꞌiki kainaꞌa baꞌorainao tiichaapauzonao Moses kakinaori dauꞌu, ĩnao kadakoinpan paꞌatiaaka kida Jesus dauꞌu. Kaikapaꞌo wuruꞌu ĩkianuz: “Arawu naubaa zii pidannao kaawan paꞌidaꞌatiꞌi, wuruꞌu aitapa-kariwainao kidaz ĩshaꞌapaapan dikauda kidaꞌo aimaakan, atii uaroapa zii ĩtuma,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sariapa Jesus paradan diꞌitinapa-kinai kuwai idaꞌan ĩꞌati. Kaikapaꞌo wuruꞌu ukianuz. ");
INSERT INTO wapNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Dii mani unao aroapatin-kidan an 100 uꞌuza kaznizonao baara ii aka, aizii mani baudaꞌapa kaznizo waziwadinan pairibannao ai. Naꞌapa dii mani pushaꞌapatinan? Aonaa mani puwaꞌakaꞌakan naꞌii ipai daunuudaꞌu wuruꞌu iribainaouz kaznizonao, pudawataꞌanan idi wuruꞌu baudaꞌapaꞌoraz kaznizo waziwadinan? Mishi pudawatinan nii udauꞌu diꞌiiꞌakaꞌa atii puikodanuzu. ");
INSERT INTO wapNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aizii puikodan idi wuruꞌu waziwadinaꞌoraz kaznizo, tuukii pukonaukii-kidanuz naꞌiki sariapa pudokobatanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Udaunaꞌan pudokobatan naaz atii pudapu iti. Aizii pukaawan sariapa pudapada-kidan pupaonarunao, naꞌiki pudapu dazaba an kidainao pidannao, naꞌiki pukian ĩꞌati. ‘Tuukii manawun õkonaukian aizii, ushaꞌapanum kauꞌan õikodan idi õꞌuza waziwadinaꞌo pairibannao ai. Ukauꞌan õaipan aizii wakonaukian baokopa.’ ");
INSERT INTO wapNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Aizii õkowaadaꞌazon aimaakan unao ati. Tuukiaꞌo nii manawun konaukii-karu aokazi ii, baudaꞌapaꞌo pidan tanawatinan an paꞌoian ai. Wunao konaukii-kida-kao aiaꞌa, iribainaouz pidannao, aonaꞌoraz naa ĩꞌitiiman kanom ai patanawatinan powaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesus kian koshan, “Aizii mani zun tiwaꞌo padiriꞌidan papuraatan sodi kida. Kainaꞌaꞌa naa okasabaꞌukan 10 wiziꞌi kidaꞌo puraata. Baudaꞌapa kamoo odobaa-kidan naꞌiki owaziwadan baudaꞌapa papuraatan. Naꞌapam nii puaitapan oshaꞌapatinan? Sariaapaꞌo nii osuuan palampan odorotan wuruꞌu puraataz, udaunaꞌan oparauan nii ipai padapu nazoo, odorotan papuraatan kaimanaiman ipai kabaun nazo an, atii oikodanuzu. ");
INSERT INTO wapNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aizii oikodan daunaꞌanazu, sariapa odapadan baokopa papaonarunao, naꞌiki pidannao wuruꞌu padapu dazaba an kidaꞌoraz ĩmashaapan. Uruu idi okian ĩꞌati. ‘Tuukii manawun õkonaukian aizii, õikodan idi õwaziwada nii õpuraatan. Õaiapa baokopa ukonaukian õtuma aizii.’” ");
INSERT INTO wapNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Udaunaꞌan Jesus kian ĩꞌati, “Aizii õkowaadan nii uꞌati aimaakan. Naꞌapaꞌo nii kapam Tominkaru angelinnao konaukian tuukii aokazi ii, baudaꞌapaꞌo pidan tanawatinan an paꞌoian ai.” ");
INSERT INTO wapNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Udaunaꞌan powaꞌa zii koshan Jesus kian ĩꞌati, “Kainaꞌa pidan dyaꞌutamaꞌo udainao daonaioranao. ");
INSERT INTO wapNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aizii dawuꞌichan kian padaru ati. ‘Paapaa, kaiꞌi naa õaipan putaan õꞌati aimaakan kida, naꞌiki pushaꞌapauz kida, wuruꞌu õzaamatan niꞌoraz kida pumawakan daunaꞌan.’ Uruu idi ĩdaru buutan naa ĩkawanaꞌati ipai wuruꞌu pazaamatapanii kidaz amazada, naꞌiki uzainao, naꞌiki ipai baꞌoran aimaakan kida, ubuutan naaz ĩkawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aonaa zii naꞌapaudaꞌum kamoo dobatan, uruꞌu naa udani wuruꞌu udawuꞌichanuz selliaꞌakan naa ipai amazada, naꞌiki baꞌoran aimaakan kida, wuruꞌu buuta-kariwaiz paꞌati. Uruu daunaꞌan, umakon naa munapo, munapo baꞌoran wiizai iti. Unaꞌaka ipai daunuudaꞌu papuraatan wuruꞌu taa-kariwai kidaz ushaꞌapauz winipinaa nii. Naꞌii akaꞌa naa umashaapan, ukaiwaan naa naꞌiki ukabootan naa papuraatan madoronaa-daun. ");
INSERT INTO wapNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aizii uipaian daunaꞌan kaiman-daun papuraatan, uruꞌu naa zamazi kaawan tuukii, uruu wiizai diꞌiiꞌaka. Aizii uruu udopian naa, aonaꞌa naa uikodan pawanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Uruu idi umakon pidan naꞌii san diꞌiti, naꞌiki upishaan naa pakaudin-kizi nii uꞌati. Uruu idi pidan zaamatan naa uruu taapaꞌo nii paꞌuza kooshinao. ");
INSERT INTO wapNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naꞌiaꞌa naa ukaudinan, naꞌiki unaꞌazootapan naa kooshinao wanyukunuu idionaa kida. Kiaꞌazoo uaipan panikan abaapa wuruꞌu kooshinao wanyukunuu idionaa kidaz. Mazan aonaa kanom taan uwanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Baudaꞌapa kamoo udiꞌitinpan, uruu idi ukian paaipan ati, ‘Naꞌapaudaꞌum kainaꞌa õdaru poitorunao? Ĩnao karikaonan paꞌan ĩwanyukunuu taa-kao, naꞌiki ĩaroopan nii abaapa, atii kainaꞌaꞌo nii zii ĩwanyukunuu waꞌakun kida. Aizii kainaꞌa õgaru daꞌanaꞌa õpatakaꞌutinan atii naꞌapaꞌo nii õmawakan õzamazin idi. ");
INSERT INTO wapNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Õkiwan niꞌi naa mooko powaa iti õdaru diꞌiti, naꞌiki õkian nii uꞌati, “Paapaa, õshaꞌapata zii mishi oiaꞌo aimaakan Tominkaru ati, naꞌiki pugaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aonaa turuu powaꞌa aizii pudakotan õgaru pudani nii, mazan aizii putaapaꞌa naa õgaru, naꞌapa putaapauzon kawan pupoitorunao.” Õkian nii õdaru ati,’ ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Uruu idi ukadishitan, mazan umakoꞌokan naa. Naꞌikiꞌi naa umakon atii umaonapatan. Munapo zii udaru tukapan uwaꞌatin dunapota. Tuukii ukamunan-kidanuzu. Uruu idi sariapa umakon uꞌidiꞌiti, kadimanaꞌo idaꞌan. Ukaawan paudani diꞌiti, sariapa udokobatanuzu naꞌiki ukissitanuzu pakaozoo ati. ");
INSERT INTO wapNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aizii udani kian uꞌati. ‘Paapaa, õshaꞌapata zii mishi oiaꞌo aimaakan Tominkaru ati, naꞌiki pugaru ati. Aonaa turuu powaꞌa aizii pudakotan õgaru pudani nii.’ ");
INSERT INTO wapNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mazan sariapa udaru dapadan papoitorunao naꞌiki ukian ĩꞌati. ‘Kadiman, unaꞌaka umanawunuꞌo kamicha ukaiwadan nii, naꞌiki unaꞌaka kaꞌusabai uꞌati, naꞌiki unaꞌaka kapam dazkidii ukaiwadan nii. ");
INSERT INTO wapNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Udaunaꞌan umako paꞌi uzowiinaka kizi kakiwiniꞌo tapiꞌiza, waaroapa kizi aizii, naꞌiki wakonaukii kizi baokopa. ");
INSERT INTO wapNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ushaꞌapanum kauꞌan, diꞌoraz õdani mainaabatinaꞌoraꞌa naa, mazan diꞌi uaidinan aizii kakupa, naꞌiki uruu pozawataꞌo waꞌai, mazan mashaꞌapakiaka ukaawan naꞌiki uikodin waunao powaa ati.’ Aizii poitoruinao shaꞌapatan daunaꞌan ipai aimaakan, uruꞌu naa ĩaroopan. ");
INSERT INTO wapNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Aizii baꞌoran udani, wuruꞌu tunarunaouz, makoꞌo zakapu iti uruu naꞌapain. Udaunaꞌan upadantan naa, aizii umaonapatan puꞌaꞌa naa padapu ati, uabata shamoro aran, naꞌiki pidannao konaupan. ");
INSERT INTO wapNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Uruu idi udapadan baudaꞌapa poitorui naꞌiki upishaan uruu. ‘Kanom kaiwuruꞌu kainao shaꞌapaapaniazuꞌu?’ ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Poitorui kian uꞌati. ‘Kainaꞌa puꞌinawuzu kaawan powaa ati. Uruu idi pudaru zowii-kidan tapiꞌiza ukakiwinidapaniaz aroapa-kinai nii. Ushaꞌapanum kauꞌan ukonaukii-kidan idi ukaawan kaiman powaa ati, aonaa kanom shaꞌapan uꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mazan tuukii utoꞌoran, uruu idi aonaa umorotan kabaun nazo iti. Sariapa udaru makon uꞌidiꞌiti, naꞌiki tuukii uaipan pamorota-kidanuz kabaun nazo iti. ");
INSERT INTO wapNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mazan sariapa udani dakoꞌatiautapaꞌakan uparadan. Ukian padaru ati. ‘Kotuaꞌikiꞌi naa õkaudinan puꞌati, naꞌapa poitorui kawan, naꞌiki aonaa naꞌapainim zii õdikintapauzon puparadan, oo õmashaꞌapatakan pudyuudanii õshaꞌapatan. Mazan upuꞌu zii aonaa zoobaba puzowiauzon boogi õꞌati, õkonaunamadin-kinaa nii õpaonarunao tuma. ");
INSERT INTO wapNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mazan aizii dii pudani kaawan, mainaabataꞌo kaiman-daun aimaakan wuruꞌu putaanii kidaz uꞌati. Ukabootan puraata soo madoronaa-ziiwanao zunnao dauꞌati. Mazan aizii diꞌi ukaawan idi, puzowii-kidan kakiwiniꞌo tapiꞌiza.’ ");
INSERT INTO wapNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“ ‘Õdani,’ udaru kian uꞌati. ‘Mishi pugaru karikaonan punaꞌan õtuma, ukauꞌan ipai daunuudaꞌu wuruꞌu aimaakan õtaapanii kidaz, puꞌidiwau paꞌidiwaru wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mazan aonaa turuu wamakonaukii-kidakan wuruꞌu puꞌinawuzu kaawanuz. Ushaꞌapanum kauꞌan mainaabatinaꞌo uruu, mazan diꞌi uaidinan aizii kakupa, naꞌiki uruu pozawataꞌo, mazan mashaꞌapakiaka ukaawan powaa ati waꞌidaꞌati.’” ");
INSERT INTO wapNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus kian patominapa-kidaniinao ati, “Kainaꞌa baudaꞌapa pidan kapuraatanuꞌo, naꞌiki kainaꞌa upoitoru awunuutapaꞌo ipai utaapanii kida aimaakan, naꞌiki uruu atiꞌo nii aimaakan kida kawinipinaata-kao. Baudaꞌapa kamoo, naobanai abatan papoitoru kaiwaapan, puraata mainaaba-daun. ");
INSERT INTO wapNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Uruu idi udapada-kidanuzu naꞌiki ukian uꞌati. ‘Mishii, naꞌapaꞌoram kuwai kaiwuruꞌu õabataniaz pudauꞌan. Naꞌapa dii pushaꞌapaapan õpuraatan? Aizii õaiapa õtukapan kaiman-daun pusaadanii kida aimaakan pukaaritan idaꞌa. Naꞌiki ipai õaipan pusaadan naꞌapaudaꞌum kainaꞌa aimaakan kida, naꞌiki õpuraatan. Õaiapa õtukapan ipai aimaakan patumaaka. Ushaꞌapanum kauꞌan uruu daunaꞌan, aonaa powaꞌa õaipan pukaudinan õꞌati oo aonaꞌo niꞌi naa powaꞌa pukazowautapan aimaakan wuruꞌu õtaapanii kidaz.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Uruu idi poitorui diꞌitinpan, naꞌiki ukian paaipan ati. ‘Akarachii, aizii õnaobanaa muuda-kidaꞌazon õgaru õkaudin-kizi ai. Naꞌapa dii paꞌi õshaꞌapatinan? Asakiꞌi. Aonaa paꞌi õturuan õkaudinan dadaraꞌo kaudin-kizai dauꞌu, aonaa õkaꞌiitan õkichadan imiꞌi. Naꞌiki õgaru naobanai-tinpauzo, aonaa õkaꞌiitan õpishautan aimaakan pidannao ai, kakibaꞌazonnaꞌo niꞌi naa õnaꞌapainpan an.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Uruu idi udiꞌitinpan tuukii. Udaunaꞌan ukian, ‘Aizii õaitapa naꞌapam nii õshaꞌapatinan. Õkapaonarutinan nii kai, aizii paꞌi õnaobanaa kabootan donoꞌo naa õgaru õkaudin-kizi ai, kainaꞌaꞌo nii õpaonarunao, kamunanuꞌo nii õꞌati, naꞌiki morota-kidaꞌo nii õgaru padapu iti,’ ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Udaunaꞌan udapadan naa baudaꞌapa kida pidannao wuruꞌu mawinipinaatapainao kidaz unaobanaa, naꞌiki upishaan naa ĩdyaun. Kiwiiniꞌo pidan ati ukian. ‘Naꞌapaudaꞌum dii pumawinipinaatapan õnaobanaa?’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘100 moto kiwinii õmawinipinaatapan uꞌai,’ ukian uꞌati. Uruu idi usoꞌotan uadowanchin kaaritannaa. Naꞌiki ukian uꞌati. ‘Dii kaarita idaꞌa usaadinpan wuruꞌu pumawinipinaatapaniaz. Mazan aizii õapowaadan nii puadowanchin puꞌati, ukauꞌan pukawinipinaatan nii soo 50 karikaonan. Ukauꞌan naꞌapaꞌa naa aizii pusaada kai daꞌaꞌa, naobanai tukapan nii.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Udaunaꞌan upishaan naa baꞌoran. ‘Pugaru mani, naꞌapaudaꞌum pumawinipinaatapan õnaobanaa?’ Ukian, ‘Õgaru, 100 saako poroom, õmawinipinaatapan uꞌai.’ Uruu idi usoꞌotan koshan uadowanchin kaaritannaa naꞌiki ukian. ‘Dii kaarita idaꞌa usaadinpan wuruꞌu pumawinipinaatapaniaz, mazan aizii õapowaadan nii puadowanchin puꞌati, ukauꞌan pukawinipinaatan nii soo 80 saako karikaonan. Ukauꞌan naꞌapaꞌa naa aizii pusaada kai daꞌaꞌa kaarita idaꞌa, naobanai tukapan nii.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Uruu idi naobanai kian dikaudaꞌo papoitoru dauꞌan. ‘Uaitapa mishi naꞌapam padiꞌitinpan naꞌiki uaitapa naꞌapam pakaiwainan diinaꞌitiꞌo tannaa nii.’” Jesus kian koshan, “Pidannao diꞌitinpauzonao soo pakapuraatanun dauꞌu, ĩaitapa paꞌan naꞌapam pakaiwainan, ĩaitapa naꞌapam pashaꞌapatan aimaakan pairibannao ati pakaimandin-kinaa nii. Ĩaitapa paꞌan naꞌapam pashaꞌapatan aimaakan, wunao aiaꞌa pidannao mashaapainaouz Tominkaru ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Powaꞌa zii koshan Jesus kian ĩꞌati, “Marii kiziꞌi naa unao aitapan aizii naꞌapam ukaiwaan wuruꞌu uikodanii kidaz aimaakan. Uaitapa kizi naꞌapam ukaimandinan, naꞌiki ukapaonarutin utaapanii kida aimaakan idaꞌan. Naꞌiki diinaꞌitiꞌi aonaan donoꞌo naa aimaakan kida naꞌiki puraata kaiwaa-kao, mazan kainaꞌaꞌo nii paꞌan kamunanuꞌo nii puꞌati naꞌiki morota-kidaꞌo nii pugaru karikaonanuꞌo mashaapa-kizai iti. ");
INSERT INTO wapNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Naꞌiaꞌoram pidan kaimanaꞌo utaapan masakaudaꞌuꞌo aimaakan taapa-kida-kao paꞌati, naꞌapaꞌo nii kapam kaimanaꞌo nii utaapan diriꞌiꞌo aimaakan taapa-kida-kao an paꞌati. Mazan aizii pidan aonaꞌoraz utaapan kaiman aimaakan wuruꞌu masakaudaꞌuꞌoraz taapa-kida-kao paꞌati, naꞌapaꞌo nii kapam aonaꞌo nii utaapan kaiman udaruꞌo aimaakan, wuruꞌu taapa-kida-kao an paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aizii unao, umaaitapakan an ukaiwaan oo utaapan kaiman shaꞌapauzii kai, ukauꞌan aonaꞌo nii uturuan utaapan wuruꞌu kaimanaꞌo, oo umanawun kidaꞌo aimaakan taapa-kida-kariwai niꞌoraz uꞌati, diinaꞌitiꞌi aokazi ii. ");
INSERT INTO wapNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aizii umataapakan idi kaiman baꞌoran pidan shaꞌapauz kai, aonaa turuu kaimanaꞌo oo umanawunuꞌo aimaakan taa-kao uꞌati diinaꞌitiꞌi, wuruꞌu uꞌidiwau niꞌoraz padamata aokazi ii. ");
INSERT INTO wapNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Aonaa turuu poitorui kaudinan dyaꞌutamaꞌo naobanainao ati. Panaadon utoꞌora-kizaitapan nii baudaꞌapa, naꞌiki umarainpan nii baꞌoran. Kaimanaꞌo nii uizoꞌatin baudaꞌapa, naꞌiki ukashadapan nii baꞌoran. Ukauꞌan naꞌapa kapam kai, aonaa turuu pidan naobanaitapan Tominkaru naꞌiki puraata.” ");
INSERT INTO wapNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aizii Phariseenao abatan idi wuruꞌu Jesus kakuwaapatinanuz kaikapaꞌa, tuukii ĩbanikiitan wuruꞌu ukuwaa kidaz. Ushaꞌapanum kauꞌan, ĩnao tuukii ĩmarainpan kapuraatan-karu. ");
INSERT INTO wapNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Uruu idi Jesus kian ĩꞌati, “Unao manawun, kaimanainao pidannao kawanuꞌo uaipan utukapa-kao. Mazan Tominkaru aitapanii kaiman-daun unyukunuu. Aizii ipai aimaakan kida wuruꞌu umanawunuꞌoraz pidannao tukapan kai, mazan Tominkaru tukapan uruu kida aimaakan, madiwautapa-kaꞌo karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Aizii kakinaorii, wuruꞌu Moses saadauzonii kidaz kotuaꞌa naa, naꞌiki wuruꞌu kotuaꞌo Tominkaru prophetinnao saadauzonii kidaz, kaimanaꞌo mashaapa-karu dauaꞌo Tominkaru tuma. Uruu kida kuwai maꞌozaka ukowaadapauzo-kao, atii John Chikaawunuupauzo kaudinan diꞌiti. Uruu daunaꞌan Kaimanaꞌo Kuwai Tominkaru naobanai-tinan dauaꞌo kowaadapa-kaoaꞌa naa ipai pidannao ati. Uruu idi tuukii padamata pidannao tiwaan pamorotan Tominkaru naobanai-tinapa-kizi iti. ");
INSERT INTO wapNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mashaꞌapannaꞌo nii paꞌan aokazi naꞌiki imiꞌi baara mainaabatinan, mazan wuruꞌu kakinaorii paradannaa sodi kidaz, aonaꞌo nii baudaꞌapa umainaabata-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Naꞌiaꞌoram pidan muudan dono paudaiaro, udaunaꞌan umazidan baꞌoran zun tuma, utoman oiaꞌo wuruꞌu ubaꞌorantapan idi. Naꞌiki naꞌiaꞌoram daonaiora zaamatan paudaiaro nii wuruꞌu muuda-kariwaiz zun, utoman kapam oiaꞌo pabaꞌorantapan idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Udaunaꞌan Jesus kian naa koshan, “Baukapaiman kainaꞌa pidan kapuraatanuꞌo, naꞌiki umanawunuꞌo umashaapan. Ukamichan umanawun kida naꞌiki kawinipinaa kidaꞌo paꞌidiwaru. Naꞌiki uwanyukunuu nii toma-kao umanawun kidaꞌo kapam. ");
INSERT INTO wapNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","“Aizii udapu korarannaa paniinomizinaa ii, kainaꞌa patakaꞌutinaꞌo pidan sakanatapauzo naꞌii. Aizii wuruꞌu pidanaz ipaiꞌo umada kabishon, Lazarus kiaꞌo uꞌuu. Ipai kamoo daꞌi unaꞌakauzo-kao naꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Unaꞌazootinaꞌanan kowas kapuraatanuꞌo wanyukunuu unuba kida dauꞌan. Atii unaꞌian nii usakanatapan, arimarakanao pizoodapan naa ubisho kida umada idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Baudaꞌapa kamoo Lazarus mawakan naa kowas. Mazan sariapa angelnao naꞌakan uruu aokazi iti. Uruu idi naꞌiaꞌa naa kaiman usakanatapan Abraham dazabaꞌa. Kadiman aka uruu daunaꞌan, kapuraatanuꞌo pidan mawakan naa kapam, naꞌiki udida-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Uruu idi sariapa paꞌan unaꞌaka-kao oiainao pidannao mashaapa-kizi iti. Naꞌiaꞌa naa kapuraatanuꞌo pidan baiatan tuukii kaziwaꞌo. “Aizii uawunuupan aokazi iti. Sariapa utukapan Abraham munapo, naꞌiki utukapa Lazarus sakanatapan udazabaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Uruu idi ukadakon. ‘Õdaru Abraham, pukamunan-kida õgaru, pudyuuda Lazarus damotan pakaꞌu shuwu wunu diꞌiti, naꞌiki marii uwaꞌatin õꞌidaꞌati, uwadidii kizi õninoba. Ushaꞌapanum kauꞌan tuukii manawun õbaiatan wiichaꞌo, õmashaapan idi tikazi wuꞌu.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mazan Abraham kian uꞌati. ‘Õdani, pukakupan dono puaitapa naꞌapam pumashaapan kaiman konaukii, naꞌiki ipai aimaakan puꞌidaꞌa. Mazan Lazarus uruu dono upatakaꞌutinan, aonaa kanom nii uꞌidaꞌa. Mazan aizii kaimanaꞌa naa naꞌiki konaukii paꞌan umashaapan daꞌaꞌa, pupatakaꞌutinan puꞌu, naꞌiki pubaiatan puꞌu kaziwaꞌo naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Naꞌiki aonaa naꞌapam wakaminkaꞌutan pugaru, diinaꞌa kazowaꞌo, naꞌiki munapoꞌo manawun kaꞌunaru awautapaꞌo pugaru waꞌai. Aonaa naꞌapam pidan makon diꞌikiꞌi, pugaru diꞌiti. Naꞌiki aonaa naꞌapam kapam pidan waꞌatin daꞌatiꞌi pugaru diꞌiki,’ ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Uruu idi kapuraatanuꞌo kian, ‘Õdaru Abraham, pudyuuda mooko paꞌi Lazarus õdaru dapu iti, õiribannao diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kainaꞌii kai bakaꞌiaudaꞌu õꞌinawuzunao. Marii kizi ukakinaowankan ĩdyaun ĩtanawatin kizi paꞌoian ai, aonaa kizi ĩwaꞌatin pamawakan daunaꞌan daꞌatiꞌi, patakaꞌutin-kizai idaꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mazan Abraham kian uꞌati. ‘Kainaꞌa Moses saadanii naꞌiki kotuaꞌo Tominkaru prophetinnao saadanii kakinaorii kida kaarita idaꞌa. Marii ĩabatan naꞌiki ĩizoꞌatin wuruꞌu parada-karu kidaz.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mazan kapuraatanuꞌo pidan kian. ‘Õdaru Abraham, upuꞌu aonaꞌo nii ĩabataꞌazon wuruꞌu parada-karu kidaz. Mazan aizii pidan mawakaꞌo naꞌiki tukapaꞌo wuruꞌu patakaꞌutin-kizaiz kadishita-kida-kao an, kakuwaapaꞌanaꞌo nii ĩꞌidiꞌiti, sariaapaꞌo nii paꞌan ĩmishidan ukuwaa, naꞌiki ĩtanawatinan nii paꞌoian ai.’ ");
INSERT INTO wapNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Mazan Abraham kian uꞌati. ‘Aizii ĩmaabataꞌazookan an kakinaorii wuruꞌu Moses, naꞌiki kotuaꞌo Tominkaru prophetinnao saadanii kidaz, ukauꞌan naꞌapaꞌo nii kapam, aonaꞌo nii ĩabataꞌazon pidan kadishitaꞌo pamawaka-kizi iki kuwaa.’” ");
INSERT INTO wapNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Jesus kian patominapa-kidaniinao ati. “Kainaꞌaꞌo nii oiaꞌo aimaakan kida shaꞌapata-kida-kao pidannao ati. Mazan kashaꞌoraꞌo nii manawun pidan baiaapan, ushaꞌapata-kidan dikin ii oiaꞌo aimaakan baꞌoran pidan ati. Kaiman zii mani padamata udaruꞌo boodapa-kinai kuba sukuruuta-kao an ukanau kadu iki, udaunaꞌan ukaboota-kao paran baoko iti, ushaꞌapata-kidan ai oiaꞌo aimaakan baꞌorainao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ukauꞌan uaitapa kizi paꞌi naꞌapam ushaꞌapatinan. “Aizii naꞌapainim puꞌinawuzu shaꞌapatan oiaꞌo, pukakinao uruu maꞌozakaꞌo idaꞌan. Aizii ukian an puꞌati, ‘Aka, mishiꞌo mishi wuruꞌu õshaꞌapatanuz oiaꞌo aimaakan.’ Uruu daunaꞌan pumarinaꞌataꞌa naa wuruꞌu ushaꞌapataniaz oiaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aizii ushaꞌapatan an 7 oiaꞌo aimaakan puꞌati, baudaꞌapaꞌo kamoo idaꞌa. Mazan karikaonan pashaꞌapatan kawanaꞌati oiaꞌo puꞌati, uwaꞌatin naꞌiki ukian puꞌati. ‘Kashaꞌora õꞌati õshaꞌapatan oiaꞌo aimaakan puꞌati.’ Pumishida uparadan, naꞌiki aonaa putoꞌora-kizaitapaꞌanaꞌa uruu, naꞌiki pumarinaꞌata wuruꞌu ushaꞌapataniaz oiaꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aizii 12 Jesus tominapa-kidaniinaouz kian uꞌati, “Putaa shoman wamishida-kinaa nii powaꞌa zii.” ");
INSERT INTO wapNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesus kian ĩꞌati, “Umishidan an masakaudaꞌu, naꞌapa mani mustard uuda sodi kawan, turuu ukian udaruꞌo atamun kadunaa ati, ‘Pusoꞌotin diꞌiki, naꞌiki pusakitin paran baoko ii.’ Turuu umishidan puparadan. ");
INSERT INTO wapNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Aizii mani kainaꞌa pupoitoru kaudinaꞌo puꞌati zakapu ii, naꞌiki awunuutapauzo puꞌuza kaznizonao, naꞌiki warakinpauzo puꞌati, naꞌiki maokodauzo kapam puwanyukunuu nii. Aizii mani uruu kaawan zakapu iki, pudyuuda mani sariapa unikan pawanyukunuu? ");
INSERT INTO wapNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aonaa, mishii? Mishiꞌoraiman pudyuudan nii zii uwarakinan puꞌati, udaunaꞌan pudyuudan nii zii umaokodan puwanyukunuu nii. Uruu daunaꞌan puaroopan nii naꞌiki putuzan nii puriwun. Uruu daunaꞌanaꞌo nii zii pudyuudan uaroopan. ");
INSERT INTO wapNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aonaa turuu poitorui zaudapan panaobanaa naubaan paugaru, pashaꞌapatan dikin ii ipai aimaakan panaobanaa paradan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ukauꞌan naꞌapa paꞌi unao kapam, ushaꞌapatan daunaꞌan ipai aimaakan udyuuda-kao kawanaꞌati. Turuu ukian, ‘Waunao poitoruinao karikaonan. Washaꞌapata ipai aimaakan kida wadyuuda-kao kawanaꞌati, ushaꞌapanum kauꞌan wakaudin-kizi niꞌo karikaonan utaa-kao wuruꞌu.’” ");
INSERT INTO wapNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aizii Jesus makopaanan dono Jerusalem iti, udobatapaanan Samaria Baara naꞌiki Galilee Baara sakodata, wuruꞌu uwiizai-tinpan kida diꞌiiꞌaka. ");
INSERT INTO wapNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Umaonapatapaanan puꞌu wiizai diꞌiti, sariapa 10 daonaioranao, kabishopauzonao kichanaꞌiki-kiaꞌo bishoi idi ikodapan uruu. Mazan munapo ĩkadishitapan uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Uruu idi ĩkadakon uꞌati kaikapaꞌa: “Jesus, Naobanai, pukamunan-kida waunao.” ");
INSERT INTO wapNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus awunuupan, sariapa utukapan ĩdyaun. Uruu idi ukian ĩꞌati, “Umako faadaa diꞌiti, marii kizi uawunuutan umada, utukapa kizi mishi umada saabainan kaiman.” Udaunaꞌan ĩmakoꞌokan naa, aizii ĩmakopaanan puꞌu mashaꞌapakiaka ĩtukapan pamada saabainaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Uruu idi baudaꞌapa daonaiora padantan Jesus diꞌiti. “Kaiman manawun pugaru Tominkaru,” ukian diiwaꞌo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ukaawan Jesus diꞌiti, sariapa ukodoruꞌukan maonapa ukidiba idaꞌa, ukanaapu iti, udaunaꞌan udawukan, uawun imiꞌi baara iti. “Kaiman manawun õꞌati, pukakudan õgaru,” ukian Jesus ati. Aizii wuruꞌu pidanaz, aonaa Jew mani uruu, mazan Samaria san paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sariapa Jesus kian, “10 shaꞌatii pidannao õkakudan. Naꞌiam naa wuruꞌu baꞌorainaouz? ");
INSERT INTO wapNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Soo baudaꞌapa karikaonan pidan waꞌatin powaa ati ukonaukii-kidaꞌanan Tominkaru, naꞌiki uruu baꞌoran kaduz pidan padamata.” ");
INSERT INTO wapNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Udaunaꞌan ukian pidan ati, “Pukadishita, pumako kiziꞌi naa, pumishidan idiꞌo õgaru wuruꞌu pukakudanuz,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Phariseenao pishaan Jesus, “Naꞌapainim nii wuruꞌu Tominkaru naobanai-tinanuz?” Jesus kian ĩꞌati, “Tominkaru naobanai-tinan dono, aonaꞌo nii utukapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aonaꞌo nii pidan kian, putukapa diꞌi naa ukaawanuꞌu, oo kindiꞌiaꞌa naa ukaawanuꞌu. Ushaꞌapanum kauꞌan unao bii aꞌo wuruꞌu Tominkaru naobanai-tinapanuz.” ");
INSERT INTO wapNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Udaunaꞌan ukian patominapa-kidaniinao ati, “Kainaꞌaꞌo nii baudaꞌapa kamoo, tuukiaꞌo nii utukapaꞌazon Daonaiora Aokazi Ikiꞌo kaawan. Mazan aonaꞌo nii zii ukaawan naꞌapain. ");
INSERT INTO wapNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Uruu dono kainaꞌaꞌo nii pidannao kian unao ati, ‘Putukapa. Kindiꞌiaꞌa naa uruꞌu,’ oo ‘diꞌi naa uruꞌu.’ Mazan aonaa paꞌi pudimaꞌanaꞌa, oo aonaa paꞌi pumakoꞌonaꞌa ĩdawuꞌati, ĩdapada kizi iti pugaru. ");
INSERT INTO wapNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ushaꞌapanum kauꞌan õkaawan dono, ipaiꞌo nii pidannao tukapan õgaru. Naꞌapa toroanaru pizo-pizowankan kawan diꞌitanapu kidaꞌa, ipai utukapa-kao. Ukauꞌan naꞌapaꞌo nii kapam wuruꞌu õkaawanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mazan kai, õpatakaꞌuta-kao nii zii naꞌiki õbaiaapan nii zii tuukii kaziwaꞌo. Naꞌiki tuukiaꞌo nii pidannao, wuruꞌu mashaapainao kidaz kai, kashadan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aizii diinaꞌitiꞌi Noah donoꞌo kawanuꞌo nii amazada, Daonaiora Aokazi Ikiꞌo kaawan dono. ");
INSERT INTO wapNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Naꞌapa kotuaꞌa naa, Noah dono kaiman pidannao abatinpan, ĩtoman aroapa-karu, ĩtuzapan, zunnao naꞌiki daonaioranao kida mazidapan. Atii naꞌapa Noah paidinan pakanawan zoꞌiti, pakawan pidannao mashaapan naꞌapa. Aizii naꞌapain umorotan dono kanawa zoꞌiti, wunu kaawan tuukii, tuukii. Uruu idi ipai, ipai pidannao mawakan panaraan idi. ");
INSERT INTO wapNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Naꞌiki Lot donoꞌo kawanuꞌo nii kapam amazada, wuruꞌu õkaawanuz diinaꞌitiꞌi. Lot kakupan dono, kaiman pidannao abatinpan, ĩtoman aroapa-karu, ĩtuzapan, baꞌorainao torian diriꞌi kida aimaakan, baꞌorainao selliipan. Baꞌorainao kaudinan ĩpaopan pazakapun kida. Baꞌorainao kida toman kabaun. ");
INSERT INTO wapNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Atii naꞌapa Lot kodita-kida-kao Sodom iki, pakawan pidannao mashaapan naꞌapa. Aizii Lot koditan dono manawun, Tominkaru wao-kidan tikazi-tinapa kidaꞌo kuba shorauz aokazi iki, naꞌapa wunu kaawan kawan. Uruu idi kaiman-daun pidannao mawakan. ");
INSERT INTO wapNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ukauꞌan Daonaiora Aokazi Ikiꞌo, naꞌapaꞌo nii kapam amazada ukaawan dono diinaꞌitiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Aizii naꞌapain, õkaawan kamoon dono, kanom sakanatapan an paniba ii, aonaa turuu umorotankan zii padapu nazo iti pashaꞌapauz dauꞌati. Naꞌiki pidan pazakapun iaꞌo ukaudinan, naꞌapain õkaawan kamoon dono, aonaa turuu upadantankan zii padapu ati. ");
INSERT INTO wapNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Puaitapa naꞌapam Lot daiaro shaꞌapatauzo-kao opadantinan idi. ");
INSERT INTO wapNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Aizii naꞌiaꞌoram pidan mamuudaꞌazoo-kaꞌo wuruꞌu pamashaapanuz panyukunuu aipan kawanaꞌati kai, upuꞌaꞌo nii uwaziwaan ipai wuruꞌu pamarainapanii kidaz. Mazan aizii naꞌiaꞌoram pidan marinaꞌataꞌo pamashaapanuz panyukunuu aipan kawanaꞌati kai, naꞌiki kashaapaꞌo nii pazowii-kao õdikin ii. Mishiꞌo nii paꞌan udoronaa kazannaata-kao, naꞌiki karikaonanuꞌo nii paꞌan umashaapan Tominkaru tuma. ");
INSERT INTO wapNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Õkowaadan nii uꞌati mishiꞌo aimaakan. Naꞌapain õkaawan dono kainaꞌaꞌo nii dyaꞌutam pidannao daꞌawupan pashimaka wuꞌu. Baudaꞌapaꞌo nii pidan naꞌaka-kao, baꞌoran unaꞌan nii uwaꞌaka-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Naꞌiki kainaꞌaꞌo nii naꞌapain dyaꞌutam zunnao boodapan maziki. Uruu dono baudaꞌapaꞌo nii zun naꞌaka-kao, baꞌoran onaꞌan nii owaꞌaka-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Naꞌiki kainaꞌaꞌo nii dyaꞌutam daonaioranao kaudinan pazakapun ii. Uruu dono baudaꞌapaꞌo nii naꞌaka-kao, baꞌoran unaꞌan nii uwaꞌaka-kao.” ");
INSERT INTO wapNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sariapa Jesus tominapa-kidaniinao kian uꞌati, “Naobanai. Naꞌiam nii wuruꞌu aimaakan shaꞌapanuz kaikapaꞌa?” Jesus kian ĩꞌati, “Uaitapan nii, aonaꞌo nii umainaabanan. Naꞌiam utukapan an watonao kasabaꞌuinpan, sariapa uaitapan kainaꞌa aimaakan mawakan. Ukauꞌan uaitapan nii kapam amazada kaawan an, aonaꞌo nii umainaabanan.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Uruu daunaꞌan Jesus kowaadan naa diꞌitinapa-kinai kuwai patominapa-kidaniinao ati. Aizii wuruꞌu ukowaadanuz kuwai, ĩtominapa-kinaa niꞌo toriinapa-karu dauꞌu. Aonaa kizi ĩsookadan patoriinpan Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kaikapaꞌa wuruꞌu Jesus kuwaaz: “Baudaꞌapa wiizai diꞌii, kainaꞌa pidan kootowapa-kidauzo pidannao. Wuruꞌu pidanaz aonaa ukichanaꞌikin Tominkaru ai, naꞌiki aonaa ukarodapan pidan. ");
INSERT INTO wapNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aizii uruu wiizai diꞌii, kainaꞌa zun mawakaibaꞌa naa odaiaru. Madukutaka owaꞌatiꞌanpan uꞌidaꞌati, oaipan idi ukaminkaꞌutan paugaru. Kaikapaꞌo wuruꞌu okianuz uꞌati: ‘Kainaꞌa pidan kashadapautan õgaru aimaakan dauꞌan. Turuu mani pukaminkaꞌutan õgaru, pusakitapadan idaꞌan wuruꞌu aimaakanuz?’ ");
INSERT INTO wapNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Aonaa mazan unyukunuupan oo ukaminkaꞌutan oroo sariapa. Uruu idi owaꞌatiꞌanpan atii ukashadinan oꞌai. Uruu idi ukian paaipan ati, ‘Õgaru aonaa õkichanaꞌikin Tominkaru ai, naꞌiki aonaa õniinawiitan pidan. ");
INSERT INTO wapNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mazan upuꞌaꞌo nii õkaminkaꞌutan wuruꞌu zunaabaz, õshaꞌapatan nii wuruꞌu oaipaniaz õshaꞌapatan. Õmashaꞌapatakan an oꞌatiz, aonaꞌo nii osookapan owaꞌatiꞌanpan. Panaadon okarinaadan õgaru pawaꞌatiꞌanpan idi.’” ");
INSERT INTO wapNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Uruu idi Jesus kian koshan, “Aizii uabata naꞌapam dikaudaꞌo padamata kootowapa-kidauzo pidannao kian. ");
INSERT INTO wapNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aizii Tominkaru mani, aonaa mani turuu ukaminkaꞌutan papidanannao, ĩpishautan an uruu ipai kamoo naꞌiki ipai marutaꞌo, ĩaipan idi pakaminkaꞌuta-kao? Uabatapa mani kotuaꞌiki, aimaakan pishauta-kao an paꞌati? ");
INSERT INTO wapNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Õgaru kian, mishi kadimanaꞌo nii ukaminkaꞌutan oo ushaꞌapatan aimaakan upishaa-kao kawanaꞌati. Mazan Daonaiora Aokazi Ikiꞌo kaawan dono koshan uikodan nii mani mishidaꞌo manawun pidannao wuru imiꞌi baaraꞌaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Udaunaꞌan Jesus kowaadan naa diꞌitinapa-kinai kuwai, wunao atiꞌi dakotinpainaouz kaikin kaimanainao nii, naꞌiki dakotinpainaouz kaikin mishidainao nii Tominkaru, ipai baꞌoran pidannao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kaikapaꞌo wuruꞌu ukuwaaz: “Baukapaiman, dyaꞌutam pidannao makon Tominkaru Dapu iti, ĩtoriinpaꞌanan Tominkaru ati. Baudaꞌapa pidan, uruu Pharisee. Baꞌoran, uruu zaamaapauzo tax puraatannaa. ");
INSERT INTO wapNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee toriinpan ukadishitapan diꞌitanpuꞌu. Kaikapaꞌa wuruꞌu utoriinapanuz mashaudaꞌu panyukunuu ii: ‘Kaiman manawun pugaru õꞌati Tominkaru. Ushaꞌapanum kauꞌan õgaru, aonaa baꞌorainao kawanuꞌo mani, aonaa mishaꞌoraru mani õgaru, aonaa naꞌapainim õdikintapauzon kakinaorii oo õshaꞌapatan dikauda kidaꞌo aimaakan. Naꞌiki aonaa baꞌorainao kawan mani õbaꞌorantapauzon. Kaiman zii õꞌati, aonaa arawu kawanuꞌo mani õgaruꞌu, zaamaapauzoz tax puraatannaa. ");
INSERT INTO wapNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Õgaru, baudaꞌapa sondii idaꞌa, dyaꞌutam kamoꞌo nii õmanikakan õwanyukunuu õsanadinpan idi puꞌati. Naꞌiki karikaonan daꞌi õbuutauzon 1/10 õpuraatan naꞌiki õpaoriba aka puꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mazan aizii wuruꞌu zaamaapauzoz tax puraatannaa, munapo ukadishitapan, utoriinpan diꞌitanpuꞌu. Aonaa baupapa uawunuupankan aokazi iti. Mazan utoriinpan, uzowian padokoriꞌi naꞌiki ukian, ‘Tominkaru, õgaru oiaꞌo pidan, pukamunan-kida shoman õgaru.’” ");
INSERT INTO wapNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Uruu idi Jesus kian ĩꞌati, “Õkowaadan nii uꞌati mishiꞌo aimaakan, soo zaamaapauzo tax puraatannaa paꞌan, Tominkaru mainaabata uꞌoian. Naꞌiaꞌoram pidan tuukiaꞌo uaipan pakazowautapan pidannao, baudaꞌapa kamoo Tominkaru waranuitapa-kidan nii uruu baꞌorainao ati. Naꞌiki naꞌiaꞌoram pidan waranuitapa-kidinaꞌo, mazan baudaꞌapa kamoo Tominkaru zaamatan nii uruu kazowautapaꞌo nii baꞌorainao.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Baudaꞌapa kamoo pidannao kaawan Jesus idaꞌati ĩnaꞌakan paudainao sodi kida. Ĩaipan upishatan naꞌiki utoriinapa-kidan paudainao. Aizii Jesus tominapa-kidaniinao tukapan wuruꞌu ĩnaꞌakanuz paudainao uꞌidaꞌati, sariapa ĩtoꞌorauan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mazan sariapa Jesus dapadan koraiziannao paꞌidaꞌati. Naꞌiki ukian patominapa-kidaniinao ati, “Marii koraiziannao waꞌatin, aonaa umashaataꞌanaꞌa ĩwaꞌatin õꞌidaꞌati. Ushaꞌapanum kauꞌan, koraiziannao kawanuꞌo pidan wuruꞌu zaamataꞌoraz Tominkaru panaobanaa nii. ");
INSERT INTO wapNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mishi, õkian nii uꞌati: Naꞌiaꞌoram pidan aonaꞌo uzaamatan Tominkaru panaobanaa nii diꞌoraz koraidaonaa kawan, aonaꞌo nii utukapan wuruꞌu kaiman kidaꞌoraz aimaakan Tominkaru shaꞌapatanii wunao atiꞌi, zaamatainaouz uruu panaobanaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kainaꞌa pidan, kazowautapaꞌo pamin-Jewnao pawiizi ii. Uruu kian Jesus ati, “Kaimanaꞌo tiichaa, naꞌapa dii õshaꞌapatinan, Tominkaru taa-kinaa nii õꞌati wuruꞌu karikaonanuꞌoraz kakupa-karu?” ");
INSERT INTO wapNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Kandii nii pudakotan õgaru kaimanaꞌo nii?” Jesus kian uꞌati, “Mazan mishi aonaa kanom baꞌoran kaimanaꞌo nii, soo baudaꞌapa Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Puaitapa naꞌapam kakinaorii kian, tawuruꞌu Tominkaru taauzonii kidaz Moses ati? Ukian. ‘Manaꞌa pubaꞌorantapaꞌanaꞌa, manaꞌa puzowiaꞌanaꞌa pidan, manaꞌa pukoidapaꞌanaꞌa, manaꞌa pumariidinaꞌanaꞌa puiriban dauꞌu, naꞌiki pumarainapa pudaru naꞌiki pudaro.’” ");
INSERT INTO wapNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aizii pidan kian Jesus ati, “Õkoraidaonaan diꞌiki õizoꞌatin ipai daunuudaꞌu wuruꞌu kakinaorii kidaz.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Uruu idi Jesus kian uꞌati, “Kainaꞌa baudaꞌapaꞌa naa aimaakan pushaꞌapatan nii. Pusellii ipai pushaꞌapauzi, putaa kizi wuruꞌu puraataz patakaꞌutinainao ati. Pushaꞌapatan an aimaakan naꞌapa, kainaꞌaꞌo nii umanawun kidaꞌo aimaakan taapa-kao puꞌati aokazi ii. Uruu daunaꞌan turuaꞌa naa puwaꞌatin õdawuꞌati, putominapa kizi õꞌidiꞌiki.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aizii pidan abatan idi wuruꞌu Jesus naꞌapanuz, aonaa unaudapan paabatanuz, tuukii unyukunuu kashaꞌoran. Ushaꞌapanum kauꞌan kapuraatanuꞌo wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus tukapan idi wuruꞌu unyukunuu kashaꞌoranuz, sariapa ukian, “Kashaꞌapannaa naꞌiki dadara manawun kapuraataniinao ati Tominkaru naobanaita-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mashaꞌapannaꞌo nii paꞌan camel podotan akosa awun shaawata, kapuraatanuꞌo zaamataꞌazon ai Tominkaru panaobanaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sariapa abatapainao pidannao kian Jesus ati, “Ukauꞌan aonaꞌo nii baudaꞌapa pidan kazannaatinan?” ");
INSERT INTO wapNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus kian, “Naꞌiaꞌoram aimaakan kashaꞌapannaꞌo oo aonaꞌo turuu pidan kaꞌiitan pashaꞌapatan, mazan Tominkaru mashaꞌapannaa ushaꞌapataꞌakan paꞌan aimaakan, wuruꞌu aonaꞌoraz turuu pidan kaꞌiitan pashaꞌapatan,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Sariapa Peter kian Jesus ati, “Putukapa naꞌapam waunao, ipai daunuudaꞌu wawaꞌakan aimaakan, naꞌiki wadapu, wadaꞌanpan idi pugaru, oo watominpaꞌazon idi puꞌidiꞌiki.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Uruu idi Jesus kian uꞌati, “Õkowaadan nii aimaakan mishiꞌo unao ati. Naꞌiaꞌoram pidan waꞌakaꞌo padapu, paudaiaro, paꞌinawuzunao, padaru, padaro, oo paudainao, pakaudinaꞌazon idi manawun Tominkaru ati, ");
INSERT INTO wapNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dobataꞌo nii zii manawun Tominkaru taan uꞌati kaiman kidaꞌo aimaakan kai, naꞌiki utaan nii uꞌati karikaonanuꞌo kakupa-kinai diinaꞌitiꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus dapadan paꞌidaꞌati soo wunao karikaonanuꞌu patominapa-kidaniinaouz. Ukian ĩꞌati, “Uabata õparadan aizii. Aizii wuruꞌu wamakonuz Jerusalem iti. Naꞌiaꞌo niꞌi naa ipai aimaakan shaꞌapata-kao naꞌapa tawuru kawanaꞌatiꞌi kotuaꞌo Tominkaru prophetinnao saadauzonii kidaz Daonaiora Aokazi Ikiꞌo dauꞌanaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Uzaamata-kao nii, udaunaꞌan utaa-kao nii Gentilenao ati. Ĩbanikiitan nii naꞌiki ĩdakoopan nii uruu, naꞌiki ĩdakoopan nii kapam wuruꞌu ukuwaa kidaz. Naꞌiki ĩsopiautapan nii uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Naꞌiki ĩbaꞌizian nii uruu, udaunaꞌan ĩzowian nii uruu. Mazan idikinaudaꞌu kamoo daunaꞌan, ukadishitan nii pabaaranaa iki.” ");
INSERT INTO wapNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mazan aonaa utominapa-kidaniinao aitapan naꞌapaꞌoram dauaꞌo wuruꞌu ukadakotinanuz. Ushaꞌapanum kauꞌan dizapa-kariwai ĩaitapan ai wuruꞌu ukuwaaz, uzowii-kao dauaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus maonapatapaanan puꞌu Jericho iti, kainaꞌa pidan ishaawun sakanatapan maonapa dunapo daawaꞌa, upishautan puraata pidannao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aizii uabatan idi iriba manawun pidannao dobaapan kida padazaba an, sariapa upishaan ĩdyaun. “Kanom kaiwuruꞌu pidannao shaꞌapaapaniaz?” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Jesus, Nazareth san dobatapan diidaꞌanaꞌa,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sariapa ishaawun kadakon Jesus ati. “Jesus, David Takaan-daun, pukamunan-kida õgaru,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sariapa pidannao kiwiitapainao kida makopaanan toꞌorauanuzu, ĩaipan umashaadan. Mazan powaꞌa zii manawun ukadakon diiwaꞌo idaꞌan. Ukian, “David Takaan-daun, pukamunan-kida õgaru,” kiaꞌo wuruꞌu ukadakoinanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sariapa Jesus kadishitaꞌakan pamakopa-kizi an, naꞌiki udyuudan pidannao naꞌakan paꞌidaꞌati wuruꞌu ishaawunuz. Aizii ukaawa-kida-kao daunaꞌan Jesus dazaba ati, sariapa upishaan uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kanom puaipan õshaꞌapatan puꞌati?” “Õnaobanaa, õtukapaꞌazon amazada,” ukian Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Uruu idi Jesus kian uꞌati, “Marii mooko putukapan. Pumishidan idiꞌo õgaru, wuruꞌu putukapanuz naa,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sariapa mishi utukapaꞌakan kaiman. Naꞌikiꞌo udaꞌanan naa Jesus, naꞌiki tuukii ukonaukii-kidan Tominkaru. Aizii ipai pidannao tukapainao wuruꞌu ishaawun awun saabaa-kaoaz, tuukii kapam ĩkonaukii-kidan Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Aizii Jesus dobatapaanan puꞌu Jericho an, ");
INSERT INTO wapNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","kainaꞌa pidan naꞌii kapuraatanuꞌo, Zacchaeus kiaꞌo uꞌuu. Uruu kazowautapauzo zaamaapauzonao tax puraatannaa. ");
INSERT INTO wapNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Uruu dono tuukii Zacchaeus aipan patukapan Jesus. Mazan uruu madiwauꞌo pidan, aonaa kowas naꞌapam utukapan Jesus, ushaꞌapanum kauꞌan iriba manawun pidannao kasabaꞌuinan Jesus daawata. ");
INSERT INTO wapNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Uruu idi udiman Jesus naꞌiki pidannao uaꞌati, naꞌiki uzaidan dokoaꞌo atamun kadu iti, Sycamore kiaꞌo uꞌuu. Ushaꞌapanum kauꞌan naꞌanaꞌo nii wuruꞌu Jesus dobatanuz, naꞌikiꞌi naa uawunuutapan. ");
INSERT INTO wapNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aizii Jesus kaawan uzaidapa kizi paꞌinamun, sariapa uawunuupan naꞌiki ukian uꞌati, “Zacchaeus, putoka kadiman, ushaꞌapanum kauꞌan õsookadinan nii pudapu ii aizii.” ");
INSERT INTO wapNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Uruu idi kadiman Zacchaeus tokaꞌakan, naꞌiki unaꞌakan naa Jesus padapu iti. Kaiman uꞌati, naꞌiki tuukii unaubaan Jesus sookadinan padapu ii. Uruu idi tuukii manawun ukonaukian. ");
INSERT INTO wapNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mazan pidannao, tuukii ĩdakoopan wuruꞌu Jesus sookadinanuz naꞌii. Kaikapaꞌo wuruꞌu ĩkianuz udauꞌan: “Aushaa utukapa, usookadinan oiaꞌo pidan dapu ii.” ");
INSERT INTO wapNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aizii padapu iaꞌa naa, Zacchaeus kadishitan pidannao kanaapuꞌu, naꞌiki ukian Jesus ati, “Naobanai, puabata naꞌapam õkian aizii: Õbuutan nii pazikon an õpuraatan, naꞌiki pazikon an õshaꞌapauz õtaan nii mapuraataniinao pidannao ati. Aizii naꞌiaꞌoram pidan ai õzaamatauzonii dobataꞌa naa manawun puraata õdyuuda-kao ai, mazan aizii õtaan nii ĩꞌati powaa iti wuruꞌu õzaamatauzonii kidaz ĩꞌai. Mazan õtaan nii ĩꞌati dobata õzaamatauzon ai. Õzaamatan an 10, õtaan nii uꞌati 40,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sariapa Jesus kian uꞌati, “Aizii Tominkaru kazannaatan pidannao paꞌoian ai, wuruꞌu mashaapainao kidaz wuru kabaun idaꞌaꞌa. Ukauꞌan wuruꞌu pidan kadapuꞌoraz, Abraham takaan-daun, naꞌapa ipai waunao kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Aizii Daonaiora Aokazi Ikiꞌo naꞌapaꞌo dauꞌatiꞌo udyuuda-kao, dorotaꞌo nii, naꞌiki kazannaataꞌo nii pozawatainao pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ipai pidannao abatapan wuruꞌu Jesus kakuwaapatinanuz. Naꞌiki uruu dono maonapa zaꞌoraꞌa naa Jesus Jerusalem iti. Aizii pidannao zauda-kidan Jesus kaawan dono Jerusalem iti, uruꞌo niꞌi naa ĩzauda-kidan patukapan Tominkaru naobanai-tinan kamoon kaawan. Mazan Jesus aitapa ĩdiꞌitinpan. Uruu idi ukakuwaapan naa koshan ĩꞌati, naꞌiki ukowaadan naa ĩꞌati diꞌitinapa-kinai kuwai. ");
INSERT INTO wapNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaikapaꞌo wuruꞌu kuwai ukowaadaniaz ĩꞌati: “Kainaꞌa umanawunuꞌo pidan, umakoꞌozon munapo, baꞌoran wiizai iti, ushaꞌapanum kauꞌan uzaamataꞌazoo-kao idi tuubaruꞌo naobanai nii, kazowautapaꞌo nii pawiizi sannao. Aizii panaobanaita-kao daunaꞌan, uaipan papadantan powaa ati pawiizi ati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pamakon uaꞌii udapadan 10 papoitorunao paꞌidaꞌati. Naꞌiki utaa ĩkawanaꞌati baudaꞌapa kida ĩpuraatan nii, gold idiꞌo utoma-kao. Udaunaꞌan ukian naa ĩꞌati. ‘Utiwaa paꞌi ushaꞌapatan aimaakan wuru idaꞌanaꞌa upuraatan kidaz, atii õkaawan powaa ati,’ ukian. Uruu daunaꞌan umakon naa. ");
INSERT INTO wapNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Mazan tuukii uwiizi sannao toꞌoran uꞌati. Uruu idi ĩdyuuda-kidan paparadan udawuꞌati, tuubaru kidainao pidannao diꞌiti wuruꞌu naobanaitaꞌo niꞌoraz uruu naꞌii. Kaikapaꞌa wuruꞌu ĩdyuudanuz paparadan: ‘Aonaa waaipan ukazowautapan waunao,’ ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mazan upuꞌu uzaamata-kao kazowautapaꞌo nii pawiizi sannao. “Panaobanaita-kao daunaꞌan ukiwan naa pawiizi iti. Aizii ukaawan daunaꞌan, udapada-kidan naa papoitorunao, uabataꞌazon naa kanom ĩshaꞌapata, naꞌiki naꞌapaudaꞌum naa ĩikodan papuraatan kida idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kiwiiniꞌo upoitoru kaawan, ukian uꞌati. ‘Naobanai, õikoda 10 goldtinapa kidaꞌo puraata, tawuru idaꞌanaꞌa baudaꞌapaꞌoraz putaan õꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Kaiman, puaitapa mishi pukaiwaan puraata. Kaimanaꞌo manawun poitorui pugaru. Puaitapan idi pushaꞌapatinan kaiman naꞌiki puikodan idi dobata aimaakan masakaudaꞌuꞌo aimaakan taa-kao idaꞌan, ukauꞌan aizii õzaamatan nii pugaru kazowautapaꞌo nii 10 wiizainao,’ ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Udaunaꞌan baꞌoran poitorui waꞌatin naobanai idaꞌati. ‘Naobanai, õgaru õikoda bakaꞌiaudaꞌu goldtinapa kidaꞌo puraata wuru idaꞌanaꞌa baudaꞌapaꞌoraz putaan õꞌati,’ ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Uruu idi naobanai kian uꞌati. ‘Kaiman, õzaamatan nii pugaru kazowautapaꞌo nii bakaꞌiaudaꞌu wiizainao,’ ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Udaunaꞌan baꞌoran poitorui waꞌatin naobanai idaꞌati. Naꞌiki ukian. ‘Naobanai, dii õkiwa-kidan puꞌati pakawan pupuraatan tawuruꞌu putaaniaz õꞌati. Unaꞌan õsaabatapanuz, naꞌiki kaimanaꞌo õbazobatapanuzu õlinson idi. ");
INSERT INTO wapNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Õtarian idiꞌo puꞌai wuruꞌu õtaapanuz pupuraatan. Ushaꞌapanum kauꞌan pugaru aonaa pukarodapauzon pidan. Punaudapa puzaamatauzon pidan ai aimaakan aonaa pumizidin kizi mani. Naꞌiki puikodauzon paoribai aka, aonaa pupaowanii diꞌikiꞌo mani,’ ukian naobanai ati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Uruu idi naobanai kian uꞌati. ‘Pugaru, aonaa pushaꞌapatinan pudyuuda-kao kawanaꞌati. Ukauꞌan õpatakaꞌutan nii pugaru puparadan kawanaꞌati. Puaitapan puꞌu õmakarodapakan pidan, naꞌiki õzaamatan aimaakan aonaa õidiwau mani, naꞌiki õikodan paoribai aka, aonaa õpaonii diꞌikiꞌo mani. ");
INSERT INTO wapNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mazan kandii nii mooko wuruꞌu, aonaa zoobaba pumuudan õpuraatan puraata taapa-kizinao ii? Aizii dii mani wuruꞌu õkaawanuz, dobata zaꞌa naa mani padamata õikodan õpuraatan.’ ");
INSERT INTO wapNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Udaunaꞌan naobanai kian wunao atiꞌi kadishitapainao kidaz udazabaꞌa. ‘Uzaamata uꞌai wuruꞌu puraataz, utaa kiziz arawu atiꞌi ikodaꞌoraz 10 goldtinapa kidaꞌo puraata.’ ");
INSERT INTO wapNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Mazan ĩkian uꞌati. ‘Naobanai, kainaꞌaꞌa naa 10 goldtinapa kidaꞌo puraata uꞌidaꞌa.’ ");
INSERT INTO wapNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Uruu idi naobanai kian ĩꞌati, ‘Õkowaadan nii aimaakan uꞌati: naꞌiaꞌoram pidan kainaꞌaꞌo aimaakan uꞌidaꞌa, taa-karu nii powaꞌa zii aimaakan uꞌati. Mazan aizii pidan wuruꞌu aonaꞌoraz aimaakan nii uꞌidaꞌa, zaamata-karu nii uꞌai ipai wuruꞌu masakaudaꞌuꞌoraz aimaakan uꞌidaꞌaꞌoraz.’ ");
INSERT INTO wapNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Udaunaꞌan ukian. ‘Aizii pidannao wuruꞌu aonaꞌoraz ĩaipan õgaru panaobanaa nii, unaꞌaka ĩdyaun daꞌatiꞌi, uzowii kizi ĩdyaun õkanaapuꞌu.’” ");
INSERT INTO wapNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aizii Jesus ipaian daunaꞌan pakadakotinan ĩꞌati, uruꞌu naa ĩmakon Jerusalem iti. Jesus kiwiitapaꞌo nii pidannao uaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Naꞌikiꞌi naa ĩmakon, ĩmakon atii ĩmaonapatan naawazi diꞌiti, dakotapa-kariwaiz Olive Naawa kii. Upaꞌinamun, kainaꞌa dyaꞌutam wiizainao, Bethphage kiaꞌo udakotapa-kao, baꞌoran Bethany kiaꞌo udakotapa-kao. Sariapa Jesus dyuudan dyaꞌutam patominapa-kidaniinao wiizai diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ukian ĩꞌati, “Umako wiizai diꞌiti. Aizii ukaawan dono naꞌiti, uikodan nii naꞌii chaakashi dani, koꞌidinpan, aonaꞌo zii uzaidauzo-kao. Ubuzuutanaka uruu, naꞌiki unaꞌaka uruu daꞌatiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aizii pidan kian an uꞌati, ‘Kanom niꞌo wuruꞌu ubuzuutanuz õꞌuza?’ Ukii uꞌati. ‘Wanaobanaa wuruꞌu aipaꞌoraz zii uruu.’” ");
INSERT INTO wapNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Uruu idi ĩmakon naa, atii ĩkaawan naꞌiti. Ĩikoda ipai aimaakan naꞌapa ukowaada-kao kawanaꞌati ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Udaunaꞌan ĩbuzuutan naa chaakashi dani. Sariapa ukaꞌuzatiki kian ĩꞌati, “Kandii niꞌo wuruꞌu ubuzuutanuz õꞌuza?” ");
INSERT INTO wapNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Wanaobanaa wuruꞌu aipaꞌoraz zii uruu,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Udaunaꞌan ĩnaꞌakan naaz atii ĩkaawa-kidanuzu Jesus diꞌiti. Uruu daunaꞌan ĩkadaaradan naa pachaakitan kida ubarau iti, Jesus sakanata kizi nii, naꞌiki ĩzaida-kidan naa Jesus ubarau iti. ");
INSERT INTO wapNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aizii umakopaanan puꞌaꞌa naa ubarau an, uruꞌu naa pidannao kadaaradan naa pakamichan kida dunapota Jesus uaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aizii ĩmaonapatan naa Jerusalem iti, ĩdaporotapaanan puꞌaꞌa naa dunapota, wuruꞌu Olive Naawa ikiꞌoraz. Uruꞌu naa iriba pidannao, wuruꞌu tominapatinauzonao kidaz Jesus diꞌiki, tuukii ĩkonaukian. Naꞌiki tuukii ĩkonaukii-kidan Tominkaru diiwaꞌo idaꞌan, patukapan idi ipai wuruꞌu pabiꞌinaaka kidaꞌoraz naꞌiki umanawun kidaꞌoraz aimaakan Jesus shaꞌapatauzon pachiꞌikapa kizi kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Naꞌiki ĩkian, “Marii Tominkaru kaimanan manawun diꞌoraz King atiꞌi, kaawaꞌoraz uaipan kawanaꞌati. Uruu idaꞌanaꞌo nii wakaimanaakan Tominkaru tuma, marii Tominkaru aokazi iaꞌoraz konaukii-kida-kao tuukii manawun, umanawunun idi,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kainaꞌa pabiꞌi kida Phariseenao pidannao biiꞌi, ĩnao kian Jesus ati, “Tiichaa, pudyuuda shoman putominapa-kidaniinao mashaadan kaiwuruꞌu pakadakoinapanuz.” ");
INSERT INTO wapNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus kian ĩꞌati, “Õkowaadan nii uꞌati mishiꞌo aimaakan, pidannao mashaata-kao an pakadakoinpan ai, kubanaouꞌo niꞌi naa kadakoin.” ");
INSERT INTO wapNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aizii padaporotapaanan puꞌu naawazi iki, Jesus awunuupan Jerusalem iti. Utukapa kaimanaiman wuruꞌu donoiz. Sariapa uzaadan, ukamunan-kidan idi naꞌiainao pidannao. ");
INSERT INTO wapNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Naꞌiki ukian, “Kaiman zii mani padamata uaitapan an, kai wuruꞌu pidan kaimanaaka-kinaaz Tominkaru tuma. Mazan aonaa utukapanuz, naꞌiki dizapa-kariwai uꞌaiaz. ");
INSERT INTO wapNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mazan kainaꞌaꞌo nii baudaꞌapa kamoo, utarubanao kaawan ĩmizaataakapaꞌanan utuma. Ipaiꞌo nii ĩkoraratan uwiizi naꞌiki aonaꞌo nii naꞌitim ukazannaatinan. ");
INSERT INTO wapNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ĩmainaabatan nii kaiman-daun uwiizi, aonaꞌo nii kanom waꞌaka-kao uꞌidaꞌa. Naꞌiki ipai unao mashaapainao naꞌa, umainaabata-kao nii kapam. Ushaꞌapanum kauꞌan aonaa uaitapaꞌazon naꞌiki uzaamataꞌazon wuruꞌu Tominkaru dyuudaniaz uꞌidaꞌati, ukazannaatin-kinaa niꞌoraz padamata.” ");
INSERT INTO wapNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aizii Jesus kaawan dono Jerusalem iti, umorotan naa Tominkaru Dapu nazo iti. Naꞌii uikoda iriba pidannao selliipainao kida uzainao, taa-karu niꞌo Tominkaru ati. Uruu idi uwaataabiꞌian naa pidannao paselliapa-kizi kida diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ukian ĩꞌati, “Kaikapa shaꞌatii Tominkaru paradan saadinpaꞌo kian: ‘Õdapu dakota-kao nii toriinapa-kizai dapunaa nii.’ Mazan unao ukaiwaapanuzu koidimikinao dizinapa-kizi nii,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ipai kamoo Jesus tominapa-kidan pidannao Tominkaru Dapu ii. Aizii faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki wuruꞌu kazowautapainao kidaz pidannao. Ipai ĩnao, tuukii ĩaipan pazowian Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mazan aonaa ĩaitapan naꞌapam pazowian uruu. Ushaꞌapanum kauꞌan iriba manawun pidannao abatapan ukakuwaatinan, naꞌiki wuruꞌu pidannao kidaz karikaonan ĩnaꞌian Jesus tuma, ushaꞌapanum kauꞌan aonaa ĩaipan padobaa-kidan ukuwaa, ĩaipan paabatan ukuwaa ipai daunuudaꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Baudaꞌapa kamoo Jesus tominapa-kidan dono pidannao naꞌiki ukowaadapan dono ĩꞌati Kaimanaꞌo Kuwai Tominkaru Dapu ii. Naꞌiaꞌo faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki kazowautapainao Jewnao naꞌiaꞌo kapam. Baokopa ĩnao waꞌatin Jesus idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Naꞌiki ĩkian uꞌati, “Pukowaada waꞌati kanom dyuudanii naꞌiki kanom aipan atiꞌo wuruꞌu pukowaadapanuz kuwai naꞌiki wuruꞌu pushaꞌapatanuz aimaakan kaikapaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sariapa Jesus kian ĩꞌati, “Õpishaan nii unao baudaꞌapa aimaakan dauꞌan, õaiapa udakoꞌatin õparadan. ");
INSERT INTO wapNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kanom dyuudanii John naꞌiki kanom aipan atiꞌo wuruꞌu uchikaawunuupanuz pidannao? Tominkaru aipan atiꞌo oo pidan aipan atiꞌo?” ");
INSERT INTO wapNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hãĩ, aonaa ĩaitapan padakoꞌatin uparadan. Sariapa ĩpishaan pairibannao kida. “Naꞌapam nii wadakoꞌatin kaiwuruꞌu uparadanuz?” ĩkiitaakapan. “Aizii wakian an Tominkaru aipan atiꞌo wuruꞌu uchikaawunuupanuz, ukian nii waꞌati upuꞌu zii mooko aonaa umishidan John? ");
INSERT INTO wapNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mazan aizii wakian an uꞌati, pidan aipan atiꞌo karikaonan wuruꞌu uchikaawunuupanuz. Tuukiaꞌo nii pidannao wuruꞌu diinaouzuꞌu, toꞌoran waꞌati, naꞌiki ĩzowian nii waunao paboori idi. Ushaꞌapanum kauꞌan ipai ĩnao, tuukii ĩmishidan Tominkaru prophetin wuruꞌu Johnaz.” ");
INSERT INTO wapNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Uruu idi ĩkian Jesus ati, “Aonaa waaitapan kanom dyuudanii uruu.” ");
INSERT INTO wapNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus kian ĩꞌati, “Õgaru naꞌapa, aonaꞌo nii kapam õkowaadan unao ati kanom aipan atiꞌo wuruꞌu õshaꞌapaapanuz aimaakan kaikapaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Udaunaꞌan Jesus kowaadan naa pidannao ati diꞌitinapa-kinai kuwai. Kaikapaꞌo wuruꞌu ukowaadaniaz: “Baukapaiman pidan paowan dizoo-karu kadunaa paꞌidiwaru pazakapun ii, grape kiaꞌoraz udakota-kao. Aizii wuruꞌu pidan upaopan naa pazakapun ii, atii uipaian. Uruu daunaꞌan uzaamatan naa pidannao awunuutapainao niꞌi naa pazakapun paꞌaonaan daida. Uruu daunaꞌan umakon naa. Kotuaꞌikiꞌo wuruꞌu umakoꞌonanuz baꞌoran wiizai iti. ");
INSERT INTO wapNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Aizii unaꞌian puꞌu zii baꞌoran wiizai ii, upaoriba aka kida dyuuan naa. Uruu idi udyuudan naa papoitoru naꞌiti, unanaka kiziꞌi naa wuruꞌu upaoriba aka buuta-kariwaiz naa uꞌidiwau nii. Mazan poitorui kaawan naꞌiti, sariapa taapainao paoribai baꞌiziautapan uruu, naꞌiki ĩdyuudan ukiwan powaa iti kanaꞌapan. ");
INSERT INTO wapNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Udaunaꞌan naobanai dyuudan baꞌoran papoitoru ĩꞌidiꞌiti. Mazan naꞌapa koshan ĩbaꞌiziinuzu, naꞌiki ĩantamikitanuzu kakibaꞌazonnaꞌo idaꞌan, naꞌiki ĩdyuudan uruu kanaꞌapan koshan. ");
INSERT INTO wapNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Udyuuda koshan baꞌoran papoitoru ĩꞌidiꞌiti. Mazan ĩbaꞌizian uruu, aonaa masakaudaꞌu mani, izai umada ĩbaꞌizin-daun kida. Pabaꞌizian daunaꞌan uruu, ĩkabootankan naazu zakapu dawun ii. ");
INSERT INTO wapNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Udaunaꞌan kapaoribaꞌo kian. ‘Naꞌapam nii õshaꞌapatinan aizii? Õdyuudan nii aizii ĩꞌidiꞌiti õdani, wuruꞌu õmarainpaniaz manawun. Õaitapa aonaꞌo nii paꞌan ĩkashadapan uruu.’ Uruu idi udyuudan paudani. ");
INSERT INTO wapNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aizii ĩtukapan naa kapaoribaꞌo dani waꞌatin sariapa ĩkian paꞌatiaaka kida. ‘Aizii waꞌatiꞌi naa kapaoribaꞌo dani diinaꞌikiꞌi. Aushaa, wazowii paꞌi uruu wazaamata kizi wuruꞌu uꞌidiwau nii kidaꞌoraz aimaakan.’ ");
INSERT INTO wapNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Uruu idi sariapa ĩzaamatan uruu, naꞌiki ĩnaꞌakan naaz zakapu dawun iti. Naꞌiaꞌa naa ĩzowianuzu. “Aizii mani,” Jesus kian pidannao ati. “Naꞌapam niꞌi naa uaitapan kapaoribaꞌo shaꞌapatan wuruꞌu taapainaouz upaoriba? ");
INSERT INTO wapNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Uwaꞌatin nii ĩꞌidaꞌati, naꞌiki uzowian nii ĩdyaun kaiman-daun. Udaunaꞌan uzaamatan nii baꞌorainao taapaꞌo niꞌi naa zakapu naꞌiki upaoriba kida.” Aizii pidannao abatan idi wuruꞌu unaꞌapanuz sariapa ĩkian, “Kandii nii? Aonaa turuu aimaakan shaꞌapata-kao naꞌapa.” ");
INSERT INTO wapNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Uruu idi Jesus awunuupan ĩꞌati, naꞌiki ukian, “Kaikapa shaꞌatii tawuruꞌu Tominkaru paradan saadinpaꞌo kianuz. ‘Wuruꞌu kuba tomapauzonao kabaun kashadaniaz, madiwautapa-kaꞌoraz ĩtukapan, uruꞌu naa mishiꞌoraiman umanawunuꞌo kuba ipai baꞌoran kubanao ai.’ Kanom dauꞌanaꞌo uzauda-kidan wuruꞌu Tominkaru paradanuz naꞌapa? ");
INSERT INTO wapNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pidan kaboinaꞌo diꞌoraz kuba paawa ati, baiainpaꞌo nii tuukii. Naꞌiki uruu kuba waotan dono naꞌiaꞌoram pidan paawa ati, ipaiꞌo nii uꞌidoꞌokan.” ");
INSERT INTO wapNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tuukii tiichaapauzonao Moses kakinaori dauꞌu, naꞌiki faadaanao zowaunaanao, toꞌoran Jesus ati. Tuukiaꞌo padamata ĩaipan pazaamata-kidan uruu naꞌii pakakuwaatin kizi ii. Ushaꞌapanum kauꞌan ĩaitapa padauaꞌo wuruꞌu ukadakotinanuz diꞌitinapa-kinai kuwai idaꞌan. Mazan tuukii ĩtarian pidannao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mazan upuꞌu ĩdorotan pazaamata-kida-kinaa nii Jesus. Ĩaipan pazaamatan uruu, udaunaꞌan ĩaipan papatakaꞌuta-kidanuz tuubaruꞌo naobanai ati, wuruꞌu Rome ikiꞌoraz uwaꞌatin. Uruu idi ĩkawinipinaatan naa pidannao makoinao nii Jesus kakuwaatin kizi iti, naꞌapa abataꞌazoinao kawan ukuwaa. Uruu idi masakaudaꞌuꞌo nii ĩabatan uparadan dikauda shaꞌapaꞌoram aimaakan dauꞌan, uruꞌo niꞌi naa ĩkowaadankanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aizii wuruꞌu pidannao dyuuda-kariwainaouz, kian naa Jesus ati, “Tiichaa, waaitapa mishiꞌo kaiwuruꞌu puparadan kidaz naꞌiki pukuwaa kidaz, naꞌiki sakitapaꞌo wuruꞌu putominapa-kidanuz pidannao. Aonaa pudiꞌitapan shaꞌapaꞌoram pidan, kaimanan, oo umanawunun. Mazan mishi paꞌan putominapa-kidan pidannao naꞌapa Tominkaru aipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Naꞌapa dii pukian waunao Jewnao taan dauꞌan tax puraatannaa tuubaruꞌo naobanai Rome iaꞌo ati? Wadikintapan Tominkaru diꞌikiꞌo kakinaorii wuruꞌu, oo aonaa?” ");
INSERT INTO wapNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mazan Jesus aitapa ĩtiwaꞌazon karikaonan pazaamatan uruu naꞌapa kidaꞌo idaꞌan. Uruu idi ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Aushaa unanaꞌiki mooko wiziꞌiꞌo puraata.” Ĩtaan daunaꞌan puraata ukian naa koshan ĩꞌati, “Kanom awun baara, naꞌiki kanom uu utukapan saadinpan puraata baaraꞌa?” “Rome iaꞌo naobanai,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Uruu idi Jesus kian ĩꞌati, “Ukauꞌan utaa Rome iaꞌo naobanai ati wuruꞌu uꞌidiwau kidaz. Naꞌiki utaa Tominkaru ati wuruꞌu Tominkaru idiwau kidaz,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aizii wuruꞌu Jesus dakoꞌatinuz parada-karu, iribaꞌo pidannao kanaapuaꞌo. Mazan wuruꞌu pidannao kaakapaꞌazoinaowuz Jesus, aonaa baudaꞌapa ĩikodan pazaamata-kinaa nii uruu. Mazan mashaa ĩabatapan, naꞌiki tuukii ĩdiꞌitinpan wuru dauꞌaꞌa udakoꞌatinuz paparadan naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kainaꞌa pabiꞌi kida Sadduceenao, aonaꞌoraz ĩmishidan kadishita-kida-kao nii pidannao pamawaka-kizi iki diinaꞌitiꞌi. Ĩnao waꞌatin Jesus idaꞌati, naꞌiki ĩpishaanuzu kaikapaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tiichaa, kaikapa shaꞌatii tawuruꞌu kakinaorii Moses saadauzonii kianuz waꞌati. ‘Naꞌapainim daonaiora mawakan dono, uwaꞌakan paudaiaro aonaa zii puꞌu okaudanin, marii uꞌinawuzu mazidan otuma. Aizii kiwiiniꞌo ĩdani daonaiora, taa-karu nii mawakaꞌo dani nii,’ kii tawuruꞌu parada-karu kiauzonuz. ");
INSERT INTO wapNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kainaꞌa 7 inawuzuinao. Kiwiin ĩtuuniz mazidan, mazan aonaa zii puꞌu udaiaro kaudanin umawakan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Uruu idi uꞌinawuzu udawuꞌitiꞌo zaamatan naꞌiki umazidan paꞌinawuzu daiaro-daun tuma, mazan naꞌapa koshan umawakan. ");
INSERT INTO wapNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Udaunaꞌan baꞌoran uꞌinawuzu mazidan otuma, mazan naꞌapa koshan umawakan aonaa zii okaudanin puꞌu, baꞌoran mazidan otuma naꞌapa koshan umawakan, udaunaꞌan baꞌoran, atii ipai uꞌinawuzunao mazidan otuma, mazan ipai daunuudaꞌu ĩmawakan, naꞌiki aonaa baudaꞌapa ĩnao waꞌakaꞌo nii paudani otuma. ");
INSERT INTO wapNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Atii baꞌoran dono, omawakan naa kapam wuruꞌu ĩdaiaro daunuz. ");
INSERT INTO wapNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aizii pidannao kadishita-kida-kao dono pamawaka-kizi iki. Naꞌiaꞌoram nii daiaroitapa oroo? Ushaꞌapanum kauꞌan ipai 7 daonaioranao mazidan otuma,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus dakoꞌatin ĩdyaun, ukian, “Daonaioranao naꞌiki zunnao wuruꞌu mashaapainao kidaz imiꞌi baara an, mazidaꞌo nii paꞌan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mazan aizii wuruꞌu daonaioranao naꞌiki zunnao Tominkaru widauniinaouz, naꞌiki ukadishita-kidan niꞌoraz pamawaka-kizi iki, aonaꞌo nii paꞌan ĩkaudaiarun oo ĩmazidan. ");
INSERT INTO wapNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ushaꞌapanum kauꞌan naꞌapaꞌo niꞌi naa ĩdyaun angelnao kawan. Aonaꞌo niꞌi naa powaꞌa ĩmawakauzon. Ipai ĩdyaun Tominkaru dainaouꞌu naa paꞌidiwaru. Ushaꞌapanum kauꞌan ukadishita-kidan idi ĩdyaun pamawaka-kizi iki. ");
INSERT INTO wapNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses kuwaa tukapa-kida kaimanaiman mishiꞌo wuruꞌu mawakainao kadishita-kida-kaoaz pamawaka-kizi iki. Naꞌapa watukapan usaadinpan Moses dauꞌan, ukowaadanuz udaruꞌo tikazi puꞌukapan kaiwada-karu kadunaa idaꞌa, mazan aonaa baudaꞌapa uanaba kaꞌawan. Uruu idaꞌa watukapan naꞌapam Moses dakotan Tominkaru, Abraham, Isaac naꞌiki Jacob Tominkarun nii. ");
INSERT INTO wapNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wuruꞌu Tominkaruz kakupainao Tominkarun, aonaa mawakainao Tominkarun mani, uruu idi Tominkaru tukapan pidannao kakupainao paꞌidiwaru,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Uruu idi pabiꞌi kida tiichaapauzonao Moses kakinaori dauꞌu kian Jesus ati. “Kaimanaꞌo naꞌiki sakitapaꞌo kaiwuruꞌu pudakoꞌatinuz ĩparadan Tiichaa,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Uruu daunaꞌan aonaꞌa naa powaꞌa Sadduceenao pishaan uruu, ushaꞌapanum kauꞌan ĩtariaꞌakan naa udakoꞌatin ai paparadan koshan. ");
INSERT INTO wapNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus kian wunao atiꞌi tiichaapauzonaouz Moses kakinaori dauꞌu, “Naꞌapa dii mooko wuruꞌu Christ, dakota-kaoaz David Takaan-daun nii? ");
INSERT INTO wapNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","David kian puꞌu pasaadanii kaarita Psalms idaꞌa, ‘Naobanai Tominkaru kian õNaobanaa ati, pusakanata õdiwaꞌora antanapu, atii õwaranuitapa-kidan putarubanao puꞌati.’” ");
INSERT INTO wapNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Udaunaꞌan Jesus kian koshan ĩꞌati, “David dakotan puꞌu uruu panaobanaa nii, naꞌapa diꞌi naa mooko wuruꞌu udaniitanuz uruu?” ");
INSERT INTO wapNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ipai pidannao abatapan puꞌu, Jesus kian patominapa-kidaniinao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Uzaudinapa paꞌi wunao aiaꞌa tiichaapauzonao Moses kakinaori dauꞌu. Ĩnaudapa pachiꞌikaꞌanpan dawuu zaꞌabaꞌi kidaꞌo kamicha daara an. Naꞌiki tuukiaꞌoraz ĩaipan pataapa-kao umanawun kidaꞌo pidannao nii, pidannao iribainapa kizi ii aka. Aonaa udaꞌanaꞌanaꞌa wuruꞌu ĩkaduz kidaz. Naꞌiki naudapainaouz pasakanatan umanawun kidaꞌo tabai idaꞌa, synagogue kida ii. Naꞌiki ĩnaudapa kapam pasakanatan, umanawunuinao taba idaꞌa aroapa-kizai ii. ");
INSERT INTO wapNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Naꞌiki ĩnaudapa payaakaratapan zunnao, mawakainao ĩdaiarunao, pazaamatan idaꞌan ĩshaꞌapauz kida. Naꞌiki ĩnaudapa paabata-kidan patoriinpan tomunuꞌiki. Ĩnao Tominkaru patakaꞌutan nii tuukii manawun.” ");
INSERT INTO wapNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Aizii Tominkaru Dapu nazo ii, Jesus awunuutapan, kapuraatan kidainao pidannao taan puraata taa-karu nii Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naꞌiki utukapa kapam zun mapuraatanuꞌo, naꞌiki mawakaibaꞌa naa odaiaru, taan naꞌiki opaidan dyaꞌutam wiziꞌi sodi kidainao puraata. ");
INSERT INTO wapNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sariapa Jesus kian pidannao ati, “Õkowaadan nii unao ati, diꞌoraz zunaꞌa, dobata otaan puraata baꞌorainao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ushaꞌapanum kauꞌan baꞌorainao taaniaz papuraatan, kainaꞌa diriꞌiꞌo zii ukawaꞌakun. Mazan aizii oroo kowas, pamapuraatanun puꞌu, otaan kaiman-daun papuraatan pamashaapa-kinaa sodiꞌi naa.” ");
INSERT INTO wapNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pabiꞌi kida Jesus tominapa-kidaniinao, kadakotin-kidan konaunam patukapan Tominkaru Dapu toma-kao. Utoma-kao umanawun kidaꞌo naꞌiki konaunam kidaꞌo kuba idi. Naꞌiki kainaꞌa kapam konaunam kidaꞌo aimaakan pidannao taanii kida Tominkaru ati, udapu konaunamada-kinao nii. Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ipai wuruꞌu konaunam kidaꞌoraz aimaakan utukapan daꞌaꞌa. Mazan kainaꞌaꞌo nii baudaꞌapa kamoo, kaiman-daunuꞌo nii ukaboobiꞌii-kao, ipai wuruꞌu kuba kidaz kadishitapa kidaꞌoraz kabaun.” ");
INSERT INTO wapNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sariapa Jesus tominapa-kidaniinao kian, “Tiichaa, naꞌapainim nii wuruꞌu aimaakan shaꞌapanuz kaikapaꞌa? Kanom idaꞌanaꞌo nii waaitapan wuruꞌu amazada shaꞌapanuz naa naꞌapa?” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus kian ĩꞌati, “Uzaudinapa paꞌi aonaa kizi umariida-kao. Kainaꞌa iriba pidannao dakotinpan õgaru nii. Ĩwaꞌatin nii unao idaꞌati naꞌiki ĩkian nii, ‘Õgaru Christ, tawuruꞌu Tominkaru kowaadauzoniaz padyuudaꞌazon kazannaataꞌo nii papidanannao.’ Baꞌorainao kian nii unao ati. ‘Aizii amazada ikodan naa patokon.’ Mazan aonaa paꞌi umakoꞌonaꞌa ĩdawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Naꞌiki aonaa paꞌi utariidinaꞌanaꞌa uabatan dono wiizainao mizaataakapan baꞌoran wiizai kida tuma, naꞌiki uabatan dono pidannao kashadaakapan, ĩtoꞌorataakapan atii ĩzowiaakapan paꞌatiaaka kida. Ushaꞌapanum kauꞌan ipaiꞌo nii zii naꞌapa kidaꞌo shaꞌapan kiwiin. Mazan aonaa kadimanaꞌo nii mani wuruꞌu amazada ikodanuzu patokon uruu daunaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Udaunaꞌan ukian ĩꞌati, “Kainaꞌaꞌo nii zii pidannao mizaataakapan baꞌoran wiizai ii kidaꞌo pidannao tuma. ");
INSERT INTO wapNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Naꞌiki kainaꞌaꞌo nii zii kichanaꞌiki-kiaꞌo imiꞌi baara nakainan, naꞌiki imiꞌi baara tadaꞌokan nii. Naꞌiki kainaꞌaꞌo nii zii zamazi kaawan, naꞌiki kainaꞌaꞌo nii zii pabiꞌinaaka kidaꞌo, kichanaꞌiki-kiaꞌo naꞌiki zaamainbaꞌo rinai kaawan. Naꞌiki kainaꞌaꞌo nii zii utukapan aimaakan kichanaꞌiki-kiaꞌo aidinan aokazi iki. ");
INSERT INTO wapNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mazan ipai wuruꞌu aimaakan kida shaꞌapan uaꞌii kaikapaꞌa, uzaamata-kao nii naꞌiki uantamikita-kao nii unaobanaitapan dikin ii õgaru. Panaadon pabiꞌi kida unao naꞌaka-kao nii synagogue iti kida, utiwaa-kidapa-kao nii, naꞌiki ukaboota-kao nii taraa-kizai iti. Naꞌiki pabiꞌi kida unao kadishita-kida-kao nii oo utiwaa-kidapa-kao nii tuubaru kidainao naobanainao kanaapuꞌu. Ipaiꞌo nii ubaiaapan dikauda kidaꞌo aimaakan naꞌapa õgaru dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Uruu dono turuaꞌo nii ukowaadan Kaimanaꞌo Kuwai õdauꞌanaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ukauꞌan uaitapa kiziꞌi naa paꞌi, diinaꞌitiꞌi upishaa-kao an, aonaa kizi udopiidinan uaitapaꞌazon idi naꞌapam nii udakoꞌatin pidannao paradan. ");
INSERT INTO wapNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ushaꞌapanum kauꞌan õtaan nii uaitapa-kinaa nii uparadan, uaitapa kizi naꞌapam nii udakoꞌatin ĩparadan ĩpishaan dono unao. Uruu idaꞌanaꞌo nii ĩkaakinpan, aonaꞌo nii ĩaitapan naꞌapam nii powaꞌa pakian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Uruu dono udarunao naꞌiki udaronao, naꞌiki uꞌinawuzunao naꞌiki baꞌoran uiribannao, naꞌiki upaonarunao zaamata-kidan nii unao, atii pabiꞌi kida unao ĩzowii-kidan nii. ");
INSERT INTO wapNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Naꞌiki ipaiꞌo nii pidannao toꞌora-kizaitapan unao õgaru dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mazan aonaꞌo nii baudaꞌapa uwaziwaan uzowaud. ");
INSERT INTO wapNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ukauꞌan maꞌozaka utaapa unyukunuu. Aonaa utariaꞌanaꞌa ushaꞌapata-kao ai. Uruu idaꞌan mishiꞌo nii paꞌan ukakupan diinaꞌitiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aizii naꞌapainim paꞌi utukapan anaꞌa naa soldyaanao koraratan Jerusalem. Uruu idaꞌan sariaapaꞌo nii uaitapan Jerusalem kaboobiꞌii-kao kamoon kaawan naa wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Marii kizi paꞌi pidannao kawiizi-tinpainao Judea Baara ii aka kidoopan midukuo iti. Aizii pidannao wuruꞌu mashaapainaouz donoi ii, marii paꞌi ĩkidoopan. Aizii wunaouꞌu mashaapainaouz donoi dawun itinapu kida, aonaa paꞌi ĩwaꞌatiꞌinaꞌa donoi ati. ");
INSERT INTO wapNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ushaꞌapanum kauꞌan Jerusalem sannao patakaꞌuta-kao kamoon naa wuruꞌu kaawaꞌoraz. Uruu idi Tominkaru paradan tawuruꞌu saada-kariwaiz kotuaꞌa naa mishiinan naa wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Uruu dono kashaꞌoraꞌo nii manawun aimaakan shaꞌapan zunnao ati wuruꞌu kaudaniinaouz patoba ii. Naꞌiki wunao atiꞌi biidapainaouz zii ĩdainao. Naꞌiki uruu kamoo dono kashaꞌoraꞌo nii aimaakan baiaapa-kao diꞌoraꞌa amazada baaraꞌaꞌa. Uruu donoꞌo niꞌi naa Tominkaru patakaꞌutan wuruꞌu pidannaouz. ");
INSERT INTO wapNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pabiꞌi kida pidannao zowii-kao nii mizaataaka-kinai marii idi. Baꞌorainao zaamata-kao nii, naꞌiki ĩnaꞌaka-kao nii poitoruinao nii baꞌoran wiizai kida kawanaꞌati, naꞌiki ĩkaudinan nii dadara, mawinipinaa-daun. Uruu dono Gentilenaouꞌo niꞌi naa kazowautapa naꞌiki waranuitapa Jerusalem sannao. Ĩkazowautapan nii ĩdyaun atii Tominkaru aipan kawanaꞌati naꞌapam ukotuaꞌikin ĩkazowautapan naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kainaꞌaꞌo nii zii panaꞌaꞌo naꞌiki kichanaꞌiki-kiaꞌo aimaakan tukapa-kao, aonaꞌo utukapauzo-kao ushaꞌapauzon kamoo ati, kauzu ati naꞌiki wizinao ati. Ipai pidannao mashaapainaouz imiꞌi baara an, tuukiaꞌo nii ĩtarian ĩabatan dono kichanaꞌiki-kiaꞌo wunu paran tururuinan, naꞌiki ĩtukapan nii udaru kidaꞌo wunu paran tominan. ");
INSERT INTO wapNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tuukiaꞌo nii ĩtarian, pidannao dorautaꞌo nii patarian idi, ushaꞌapanum kauꞌan ĩaitapa kainaꞌaꞌo nii zii kichanaꞌiki-kii kidaꞌo manawun aimaakan shaꞌapan daꞌanaꞌa imiꞌi baara an. Naꞌiki ipaiꞌo nii amazada nakainan doko ii, uruu idi ipaiꞌo nii aimaakan wuruꞌu doko ii kidaꞌoraz zikadinan. ");
INSERT INTO wapNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Uruu daunaꞌan Daonaiora Aokazi Ikiꞌo aidinaꞌakan niꞌi naa, uwaꞌatin aokazi iki ishaꞌiz bii an, umanawunuꞌo pamaꞌozakan naꞌiki umanawunuꞌo pakonaunaman tuma. ");
INSERT INTO wapNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aizii utukapan anaꞌa naa naꞌapa kidaꞌo aimaakan shaꞌapan, aonaa utariaꞌanaꞌa, mishiꞌoraiman ukadishitapa maꞌozaka, naꞌiki doko iti uawunuutapa. Ushaꞌapanum kauꞌan ukazannaata-kao kamoon maonapatan naa wuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Udaunaꞌan Jesus kowaadan naa ĩꞌati diꞌitinapa-kinai kuwai. Kaikapaꞌo wuruꞌu ukianuz ĩꞌati: “Aushaa udiꞌitapa fig kadunaa kida naꞌiki baꞌoran atamun kadunaa kida. ");
INSERT INTO wapNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Naꞌapainim utukapan an ukaanaban oo uanaba kida paꞌinaadinan, sariapa uaitapan uruu idaꞌan wawunu donon maonapatan naa wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ukauꞌan naꞌapaꞌo nii kapam uaitapan wuruꞌu Tominkaru Naobanai-tinan kamoon maonapatanuz, utukapan anaꞌa naa wuruꞌu aimaakan kida shaꞌapanuz kaikapaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Õkowaadan nii uꞌati aimaakan mishiꞌo, ipaiꞌo nii aimaakan kida shaꞌapan naꞌapa, kaiꞌo pidannao mawakan uaꞌii ipai. ");
INSERT INTO wapNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mishi mainaabatinaꞌo nii ipai daunuudaꞌu aokazi naꞌiki imiꞌi baara, mazan wuruꞌu õparadan kidaz aonaꞌo nii naꞌapainim umainaabatinan. ");
INSERT INTO wapNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Uruu idi zaudinpaꞌa naa umashaapa. Aonaa umashaapaꞌanaꞌa utomapan dauꞌu karikaonan aroapa-karu naꞌiki tuzapa-karu. Naꞌiki aonaa udiꞌitinpaꞌanaꞌa soo ushaꞌapaapaꞌazon dauꞌati karikaonan aimaakan uꞌati. Panaadon upadaidaꞌanata-kao, naꞌapa basakara zaamatan kawan kotuꞌuz. ");
INSERT INTO wapNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ushaꞌapanum kauꞌan wuruꞌu aimaakan shaꞌapaꞌo niꞌoraz shaꞌapan nii ipai amazada kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Uruu idi uzaudinpaꞌa naa umashaapa. Naꞌiki karikaonan paꞌi utoriinapa Tominkaru ati, maꞌozaka kizi utaapan unyukunuu, utukapan donoꞌo naa aimaakan kida wuruꞌu shaꞌapaꞌo niꞌoraz ubii an, naꞌiki maꞌozaka kizi kapam unyukunuu ukadishita-kida-kao dono diinaꞌitiꞌi, Daonaiora Aokazi Ikiꞌo kanaapuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Uruu kiaꞌo wuruꞌu Jesus tominapa-kidauzonuz pidannao ipai kamoo, Tominkaru Dapu ii. Naꞌiki ipai chaapiꞌiki pidannao makouzon daꞌi Tominkaru Dapu iti, uruu ĩabataꞌanan naa Jesus kakuwaapatinan. Aizii Jesus, ipai wachuupun daꞌi umakouzon Olive Naawa iti, naꞌiki unaꞌian nii baudaꞌapa marutaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aizii maonapaꞌa naa Bread Mawikiꞌinaꞌo Nikauzo-kao Kamoon kaawan. Uruu Passover Kamoon kiaꞌoraz udakota-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Faadaanao zowaunaanao naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, tuukii ĩtarian pashaꞌapatan Jesus pidannao awun zaꞌa. Uruu idi ĩkadakotin-kidan naꞌapam nii pazaamata-kidan Jesus, ĩaipan pazowii-kidanuzu pidannao daidaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sariapa Satan morotinan Judas, Iscariot kiaꞌoraz udakotapa-kao. Uruu tawuruꞌu 12 Jesus tominapa-kidaniinao bii ikiꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sariapa Judas makon faadaanao zowaunaanao diꞌiti, naꞌiki kazannaatapauzonao Tominkaru Dapu zowaunaanao diꞌiti. Naꞌiaꞌa naa Judas kadakotinan ĩtuma, naꞌiki ukowaadan naa ĩꞌati naꞌapam nii pazaamata-kidan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tuukii ĩkonaukian, uruu idi ĩkian Judas ati, “Wakawinipinaatan nii pugaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kaiman Judas ati puraata taaꞌazoo-kao paꞌati. Uruu daunaꞌan uabatapan naa naꞌitim nii Jesus makon. Uruu naꞌiaꞌo niꞌi naa uaipan pazaamata-kidan Jesus, iribainao pidannao daidaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aizii kaawaꞌa naa Bread Mawikiꞌinaꞌo Nikauzo-kao Kamoon, naꞌapain kapam kaznizonao zowiauzo-kao Passover wanyukunuunaa nii. ");
INSERT INTO wapNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Uruu idi Jesus dyuudan Peter naꞌiki John. Ukian ĩꞌati, “Unao paꞌi minziiwa-kida Passover wanyukunuunaa wanikan nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Naꞌiam nii puaipan waminziiwa-kidanuzu?” ĩkian Jesus ati. ");
INSERT INTO wapNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus kian ĩꞌati, “Umako donoi iti. Aizii ukaawan an naꞌiti, daonaiora kapowankaꞌo wunu moto zoꞌan ikodapan nii unao. Udaꞌan uruu padawuꞌati, naꞌiki umorota udawuꞌati kabaun nazo iti. ");
INSERT INTO wapNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Naꞌiki ukii kadapuꞌo ati naꞌii. ‘Tiichaa pishaa-kidan naꞌiam dii kabaun nazoo wuruꞌu aroapa-kizaiz unika kizi niꞌoraz Passover wanyukunuunaa baokopa patominapa-kidaniinao tuma?’ ");
INSERT INTO wapNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sariaapaꞌo nii kadapuꞌo tukapa-kidan uꞌati udaruꞌo kabaun nazoo doko iaꞌo kapam, naꞌiki ipaiꞌoraꞌa naa uminziiwa-kida-kao aroapa-kizai nii. Ukauꞌan naꞌii usaabaa ipai wanyukunui,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Udaunaꞌan ĩmakoꞌokan naa donoi iti. Ĩkaawan naꞌiti naꞌapa mishi ipai aimaakan shaꞌapan Jesus paradan kawanaꞌati. Uruu idi naꞌiaꞌa naa ĩminziiwa-kidan Passover wanyukunuunaa. ");
INSERT INTO wapNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aizii kamoo tipitan daunaꞌan, Jesus naꞌiki 12 utominapa-kidaniinao sakanatan naa baokopa miisa idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Naꞌiaꞌa naa Jesus kian ĩꞌati, “Tuukiaꞌo õnikaꞌazon unao tuma wuruꞌu diꞌoraz Passover wanyukunuunaa õzowii-kao uaꞌii. ");
INSERT INTO wapNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ushaꞌapanum kauꞌan aonaꞌo nii powaꞌa õnikauzon unao tumazu, atii diinaꞌiti ziiꞌi, Tominkaru tukapa-kidan donoꞌo naa panaobanai-tinan ipai pidannao ati, naꞌiki uipaian anaꞌa naa pashaꞌapatan ipai wuruꞌu pashaꞌapataꞌazoonii kidaz.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Udaunaꞌan uzaamatan koopo kawazoꞌo wine idi, naꞌiki utoriinapa-kidanuz Tominkaru ati. Udaunaꞌan utaan, naꞌiki udobata-kidan naa wine wuruꞌu koopo zoꞌaꞌoraz ipai wunao kawanaꞌatiꞌi 12 utominapa-kidaniinaouz. Naꞌiki ukian ĩꞌati, “Marii ipai unao tuzan diꞌoraz wine. ");
INSERT INTO wapNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aizii õgaru, aonaꞌo niꞌi naa powaꞌa õtuzan wuruꞌu diꞌoraz wine, toma-kariwaiz Passover riwunnaa nii, atii diinaꞌitiꞌo nii zii koshan õtuzan wine, Tominkaru tukapa-kidan donoꞌo naa panaobanai-tinan ipai pidannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Udaunaꞌan uzaamatan naa bread, naꞌiki utoriinapa-kidanuz Tominkaru ati. Udaunaꞌan udushowan naa bread naꞌiki utaan naazu patominapa-kidaniinao kawanaꞌati kida. Naꞌiki ukian ĩꞌati, “Aizii diꞌi õnanaa wuruꞌu, õtaaniaz unao dikin ii. Marii kizi paꞌi karikaonan unikan bread kaikapaꞌa, unyukunuitapa-kinaa nii õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Paaroopan daunaꞌan uzaamatan koshan wuruꞌu koopoz, paidaꞌo wine idi, naꞌiki udobata-kidan naa ĩkawanaꞌatiz. Ukian ĩꞌati, “Diꞌoraz wine koopo idaꞌaꞌoraz kainaabataꞌo mishiꞌo nii Tominkaru shaꞌapatan paꞌinaꞌo pashaꞌapataꞌazooniaz unao ati õizain idaꞌan, umishiinan nii õizain shootan idaꞌan unao ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jesus kian, “Mazan wuruꞌu pidan zaamata-kidaꞌo niꞌoraz õgaru õmin-aroopan, kainaꞌa uruu kaidaꞌaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mazan mishi, Daonaiora Aokazi Ikiꞌo mawakan nii kaikapaꞌa, naꞌapa Tominkaru aipan kawanaꞌati. Mazan kashaꞌoraꞌo nii manawun pidan baiaapan uzaamata-kidan dikin ii uruu.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sariapa Jesus tominapa-kidaniinao paradan paꞌatiaaka kida. Ĩaitapaꞌazon naꞌiaꞌoram pidan pabiꞌi wuruꞌu zaamata-kidaꞌo niꞌoraz uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Uruu daunaꞌan, Jesus tominapa-kidaniinao kashadaakapan naa paꞌatiaaka kida. Ushaꞌapanum kauꞌan ipai ĩdyaun ĩaipinan tuubaruꞌo pidan nii pamin-kaudinannao ai. ");
INSERT INTO wapNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Uruu idi Jesus kian ĩꞌati, “Aizii kingnao wuruꞌu kazowautapainaouz ipai pidannao, ipai amazada kawanaꞌati, maꞌozaka ĩkazowautapan wuruꞌu pidannaouz. Naꞌiki wuruꞌu naobanai-tinpainao kidaz pidannao, tuukii ĩaipan pidannao dakotan paugaru kamarainpanuꞌo naobanai nii. ");
INSERT INTO wapNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mazan unao, aonaa unaꞌapaꞌanaꞌa ĩnao kawan. Mishiꞌoraiman, naꞌiaꞌoram pidan unao biiꞌi, tuubaruꞌo utaapinpan, marii utaapinan pidan waranuitapa-kidinaꞌo kawan. Naꞌiaꞌoram pidan naobanai-tinpaꞌo, marii utaapinan poitorui kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kanom kainaꞌa tuubaruꞌo nii pidan? Wuruꞌu sakanatapaꞌoraz, zaudapaꞌoraz aimaakan shaꞌapata-kao paꞌati? Oo wuruꞌu kaudinaꞌoraz uꞌati? Mishi tuubaruꞌo pidan wuruꞌu sakanatapauzoz. Mazan õgaru kian aonaa unaꞌapan. Ushaꞌapanum kauꞌan õgaru naꞌapa poitorui kawan õmashaapan, õkaudinan unao biiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Atii diꞌi aonaa uwaꞌakan õgaru õbaiatan puꞌu kashaꞌora kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mazan õzaamatan unao kazowautapaꞌo nii pidannao diinaꞌitiꞌi. Naꞌapa õdaru zaamatan kawan õgaru kazowautapaꞌo nii ipai papidanannao. ");
INSERT INTO wapNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Uaroopan nii naꞌiki utuzan nii õtuma õnaobanai-tinapa-kizi ii. Naꞌiki usakanatan nii umanawunuꞌo tabai kida idaꞌa. Naꞌiki naꞌiaꞌo niꞌi naa unao kazowautapan ipai daunuudaꞌu Israel takaan-daunnao, wuruꞌu 12 udainao diꞌikiꞌoraz naa ĩiribainan.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesus kian koshan, “Simon, puabata õparadan. Satan pishaaniꞌi naa Tominkaru unao dauꞌan, ukauꞌan utiwaa-kidapan nii unao, naꞌapa pidan manaruan kawan zaishi padyukuo ai. ");
INSERT INTO wapNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mazan õtoriinapaniꞌi naa pugaru ati Simon, punyukunuu maꞌozaka kizi, aonaa kizi pumuudan pumishidapan õgaru. Naꞌiki pumaꞌozakadaꞌa naa paꞌi baꞌoran mishidainao nyukunuu, pupadantan dono õꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Sariapa Peter kian uꞌati, “Naobanai, õgaru, turuu õtaraa-kidinan naꞌiki õmawakan putuma.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus kian uꞌati, “Peter, aizii wuru wamarutan idaꞌa, kuruku kaꞌaranpan uaꞌii, pumariidinan nii idikinau õdauꞌan. ‘Aonaa õaitapan uruu,’ pukian nii õdauꞌan pidannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus kian 12 patominapa-kidaniinao ati, “Tawuru donoꞌo, õdyuudauzonuz umakon mapuraatan-daun, masaakon-daun, naꞌiki aonaa unaꞌakan baꞌoran udazkidi kida. Kanom baꞌoran tuukiaꞌo uaipan uruu dono?” “Aonaa kanom,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Uruu idi Jesus kian ĩꞌati, “Mazan aizii kanom kainaꞌaꞌo upuraatan, naꞌiki usaakon, marii unaꞌakanuzu. Aizii kanom aonaꞌo mizaataaka-kinai marii nii uꞌidaꞌa, marii usellian pachaakitan patorii-kinaa nii pamarian nii. ");
INSERT INTO wapNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ushaꞌapanum kauꞌan, saada-kariwaiz Tominkaru paradan wuruꞌu õdauaꞌoraz mishiinan niꞌi naa wuruꞌu,” ukian ĩꞌati. “‘Uzowii-kao nii naꞌapa pidannao shaꞌapaapainao kawan oiaꞌo.’ Aiziꞌo niꞌi naa paꞌan wuruꞌu saada-kariwaiz Tominkaru paradan, õdauaꞌoraz mishii-kao,” Jesus kian. ");
INSERT INTO wapNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sariapa Jesus poitorunao kian, “Wanaobanaa, putukapa diꞌi kainaꞌa dyaꞌutam mizaataaka-kinai marii waꞌidaꞌa.” “Turuaꞌo nii wuruꞌu,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus makon naa Olive Naawa iti patominapa-kidaniinao tuma. Ukaduz umakoꞌanpauzon naꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aizii ĩkaawan naꞌiti, Jesus kian ĩꞌati, “Utoriinapa paꞌi aonaa kizi ukaakinpan unyukunuu tiwaa-kidapa-kao an.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Udaunaꞌan umakoꞌokan naa ĩꞌai, naꞌapa mani umunapon pidan kaꞌiitan kawanaꞌati kabootan kuba. Naꞌiaꞌa naa Jesus kodoruꞌukan naꞌiki utoriinpan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ukian kaikapaꞌa: “Õdaru, punyukunuu naꞌapan an, puzikada shoman õꞌai wuruꞌu kaziwaꞌoraz aimaakan baiaapa-kidaꞌazoo-kao õꞌati. Mazan aonaa õaipan kawanaꞌati mani, soo puaipan kawanaꞌati paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sariapa angel aokazi ikiꞌo kaawan Jesus idaꞌati, umaꞌozakadaꞌanan unyukunuu. ");
INSERT INTO wapNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tuukii Jesus dopian panyukunuu ii, naꞌiki kaziwa utaapan unyukunuu. Uruu idi tuukii utoriinpan padaru ati. Atii umashikan sabian naꞌapa izai kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Uipaian daunaꞌan patoriinpan, uruꞌu naa umakon patominapa-kidaniinao diꞌiti. Uikoda ĩdyaun ipai ĩdaꞌawun, panyukunuu kashaꞌoran idi. ");
INSERT INTO wapNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ukian ĩꞌati, “Kandii nii udaꞌawupan? Upokoda, naꞌiki utoriinapa mishiꞌoraiman, aonaa kizi ukaakinpan utiwaa-kidapa-kao an,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus kadakotinan puꞌu zii patominapa-kidaniinao ati, uruꞌu naa pidannao waꞌatin kasabaꞌu, kasabaꞌuan Judas dawuꞌati. Uruu 12, Jesus tominapa-kidaniinao bii ikiꞌo. Aizii ĩkaawan, sariapa Judas kissitan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mazan Jesus kian uꞌati, “Judas, pukissitan idaꞌan pukaakapaan Daonaiora Aokazi Ikiꞌo?” ");
INSERT INTO wapNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aizii Jesus tominapa-kidaniinao tukapan idi wuruꞌu aimaakan shaꞌapanuz naꞌapa, sariapa ĩkian, “Wanaobanaa, turuaꞌa naa wakaiwaan wamarian aizii?” ");
INSERT INTO wapNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Upuꞌaꞌa naa mazan baudaꞌapa pidan Jesus tominapa-kidaniinao bii ikiꞌo, soꞌotaꞌakan naa marii zaꞌabaꞌi, naꞌiki usaꞌukan Umanawunuꞌo Faadaa poitoru tain. ");
INSERT INTO wapNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mazan Jesus kian ĩꞌati, “Turuaꞌa naa!” Udaunaꞌan upishataꞌakan naa pidan tain naꞌiki kaiman usaabaꞌakan powaa itiz. ");
INSERT INTO wapNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Udaunaꞌan Jesus kian naa faadaanao zowaunaanao ati, naꞌiki kazannaatapauzonao Tominkaru Dapu zowaunaanao ati, naꞌiki kazowautapauzonao Jewnao ati, “Kaikapa uwaꞌatin õꞌidaꞌatiꞌi, unaꞌakan marii naꞌiki chipirari zaꞌabaꞌi kida, zaamataꞌanaꞌo kawan zowii-miki pidan? ");
INSERT INTO wapNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ipai kamoo shaꞌatii õtominapa-kidan pidannao Tominkaru Dapu ii, upuꞌu aonaa uzaamatan õgaru naꞌii. Mazan mishi aizii wuru wamarutan idaꞌa õkashaapa-kao naꞌiki õtaa-kao unao kaꞌu iti. Ushaꞌapanum kauꞌan aiziꞌi naa Satan maꞌozakatinpan kamoon kaawan.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Udaunaꞌan ĩzaamataꞌakan naa Jesus, naꞌiki ĩnaꞌakan naaz umanawunuꞌo faadaa dapu iti. Peter naꞌiti kapam umakon ĩdawuꞌati, mazan munapo uwaꞌakinpaanan ĩꞌai. ");
INSERT INTO wapNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Uruu idi naꞌiaꞌa naa tikazi puꞌukada-kao panibazoo ii. Naꞌiki naꞌiaꞌa naa pidannao sakanatapan awauta tikazi dazaba an. Peter naꞌii kapam usakanatapan ĩbii ii. ");
INSERT INTO wapNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Udaunaꞌan poitoruiaba tukapankan naa uruu, tikazi maodapan puꞌu. Uruu idi sariapa oawunuupan uawun baara iti, naꞌiki okian, “Diꞌoraz daonaioraꞌa, uminaudaꞌuitapauzonii kapam Jesus.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mazan sariapa Peter mariidinan, naꞌiki ukian oꞌati, “Aonaa õaitapauzon uruu.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Masakaudaꞌu uruu daunaꞌan, daonaiora tukapankan naa kapam Peter. “Pugaru uminaudaꞌu kaduz kapam,” ukian. Mazan Peter kian uꞌati, “Aonaa õgaru mani.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Atii tomunuꞌiki zaa uruu daunaꞌan, baꞌoran daonaiora paradan maꞌozaka Peter dauꞌan. “Mishiꞌo wuruꞌu Jesus minaudaꞌu kaduz arawuꞌu, naꞌiki uruu Galilee Baara san kapam, aonaa umainaabanan,” ukian pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mazan Peter kian koshan uꞌati, “Aonaa õaitapan kanom dauaꞌo kaiwuruꞌu pukadakotinanuz.” Aonaa zii Peter ipaian pakadakotinan, uruꞌu naa kuruku kaꞌaranpan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Upuꞌaꞌa naa Jesus tanawatinan, naꞌiki sariapa uawunuupan Peter diꞌiti. Uruu idi sariapa Peter nyukunuuaꞌakan uparadan, tawuruꞌu ukianuz, “Aizii wuru marutan idaꞌa pumariidinan nii idikinau õdauꞌan kuruku kaꞌaranpan uaꞌii. ‘Aonaa õaitapan uruu,’ pukian nii õdauꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Uruu idi sariapa Peter koditan pidannao bii iki, naꞌiki umakon paniba itinapu. Naꞌiaꞌa naa uzaadan tuukii, tuukii. ");
INSERT INTO wapNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aizii pidannao wuruꞌu watchmantapainao kidaz Jesus, ĩbanikiitan naa uruu. Udaunaꞌan ĩtiniautapan naꞌiki ĩtaꞌiautapan naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Udaunaꞌan ĩshibatan naꞌiki ĩdoꞌotan naa uawun baara kamicha idi, naꞌiki ĩkian uꞌati, “Aushaa, pukowaada waꞌati naꞌiaꞌoram pidan wuruꞌu tinikaꞌoraz pugaru?” ");
INSERT INTO wapNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Naꞌiki dikauda kida manawun ĩmanamiki uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Atii wakanadan. Aizii uruu chaapiꞌiki, chaapiꞌikiiman uruꞌu naa kazowautapainao Jewnao, naꞌiki faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, ipai ĩnao baokopatinan. Udaunaꞌan ĩdapada-kidan naa Jesus pakootowapa-kizi iti. ");
INSERT INTO wapNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Naꞌiaꞌa naa ĩkian uꞌati, “Aizii pukowaadaꞌa naa waꞌati mishiꞌo wuruꞌu pugaru Christ?” Mazan Jesus kian ĩꞌati, “Õkowaadan an uꞌati, aonaꞌo nii umishidan õparadan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Naꞌiki õpishaan an unao, aonaꞌo nii udakoꞌatin õparadan. ");
INSERT INTO wapNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mazan kadimanaꞌo niꞌi naa paꞌan Daonaiora Aokazi Ikiꞌo sakanatan Tominkaru maꞌozakaꞌo diwaꞌora antanapu.” ");
INSERT INTO wapNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Uruu idi ipai ĩnao kian uꞌati, “Ukauꞌan mishiꞌo wuruꞌu pugaru Tominkaru Dani?” “Unaꞌapan shaꞌatii kaiwuruꞌu upishaanuz õgaru naꞌapa,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Udakoꞌatin idi ĩparadan naꞌapa, sariapa ĩkian, “Kandii nii waaipan zii dikaudaꞌo aimaakan kowaada-kao udauꞌu, waabatan puꞌu kaimanaiman udako iki naꞌapam ukian padauꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Uruu idi ipai pidannao, wuruꞌu abatapainao kidaz naꞌii kadishiaꞌakan. Udaunaꞌan ĩnaꞌakan naa Jesus Pilate diꞌiti. Atii ĩkaawa-kidan naꞌitizu. ");
INSERT INTO wapNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Naꞌiaꞌa naa ĩkaakapaan Jesus Pilate ati. “Aushaa puabata wakuwaa diꞌoraz pidan dauꞌanaꞌa, waabatan ukakinaopan pidannao panaꞌiti karikaonan. Naꞌiki aonaa uaipan ĩkawinipinaatan tax Rome iaꞌo naobanai ati. Naꞌiki tuukii udakotinpan Christ nii. Naꞌiki udakotinpan king nii Jewnao ati,” ĩkian Pilate ati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Udaunaꞌan Pilate pishaan naa Jesus, “Mishi pugaru wuruꞌu king niꞌoraz Jewnao ati?” “Unaꞌapan shaꞌatii kaiwuruꞌu punaꞌapanuz,” Jesus kian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Udaunaꞌan Pilate kian naa faadaanao zowaunaanao ati, naꞌiki ipai kasabaꞌukinpainao pidannao ati, “Aonaa kanom õikodan dikaudaꞌo nii aimaakan ushaꞌapatan. Uruu idi aonaa kanom dikin ii ushaꞌapata-kao.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mazan maꞌozaka pidannao dakoꞌatin uparadan, naꞌiki ĩkian uꞌati, “Aizii ipaiꞌi naa ukakinaowan pidannao, wuruꞌu kawiizi-tinpainao kidaz wawiizi Judea Baara an. Uruu idi tuukiaꞌa naa pidannao kashadaakapan, naꞌiki aonaꞌa naa powaꞌa ĩmishidan oo ĩshaꞌapatinaꞌazon wuru kawanaꞌatiꞌo Rome ikiꞌo naobanai kakinaori kidaz. Galilee Baara ikiꞌo wuruꞌu usakadanuz pakakinaopan pidannao, atii diꞌi, aizii kaawaꞌa naa uruu daꞌatiꞌi,” ĩkian Pilate ati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate abatan idi ĩnaꞌapan, sariapa ukian ĩꞌati, “Kanom san uruu, Galilee Baara san?” ");
INSERT INTO wapNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aizii uaitapan idi Jesus waꞌatin Herod kazowautapanii wiizai diꞌiki, sariapa udyuudan unaꞌaka-kao Herod diꞌiti. Ushaꞌapanum kauꞌan uruu dono, naꞌiaꞌo Herod Jerusalem ii. Uruu daunaꞌan ĩnaꞌakan naa Jesus Herod diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tuukii Herod konaukii-kidan patukapan Jesus, ushaꞌapanum kauꞌan kotuaꞌikiꞌoraꞌa naa uabatautan Jesus dauꞌan. Naꞌiki tuukiaꞌo utukapaꞌazon aimaakan wuruꞌu pabiꞌinaaka kidaꞌoraz Jesus shaꞌapaapauzon. ");
INSERT INTO wapNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Uruu idi, iriba sodi kida upishaan Jesus, mazan aonaa baudaꞌapa udakoꞌatin uparadan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mazan upuꞌaꞌa naa faadaanao zowaunaanao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu maonapadinan Herod dazaba ati, naꞌiki ĩkowaada iriba dikauda kidaꞌo aimaakan uꞌati, Jesus dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Udaunaꞌan Herod naꞌiki baokopa pasoldyaannao tuma, ĩmakinaotan naꞌiki ĩbanikiitan naa Jesus kakibaꞌazonnaa kidaꞌo idaꞌan. Udaunaꞌan ĩkaiwada-kidan naa uꞌati naobanainao kamichan kaduz. Uruu daunaꞌan Herod dyuudan naa koshan uruu powaa iti Pilate diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Uruu kamoo dono Herod naꞌiki Pilate kaimanaakan. Uruu uaꞌii aonaa ĩkaimanaakauzon. ");
INSERT INTO wapNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Udaunaꞌan Pilate dapadan naa faadaanao zowaunaanao, naꞌiki naobanai-tinpainao kida pidannao, naꞌiki baꞌoran pidannao kida. ");
INSERT INTO wapNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aizii ĩbaokopatinan daunaꞌan, uruꞌu naa ukian ĩꞌati, “Unao zaamatanii, naꞌiki ukaawa-kidanii wuruꞌu diꞌoraz daonaioraꞌa. Naꞌiki ipai unao ukowaadan õꞌati, ukakinaopan pidannao panaꞌiti. Naꞌiki ipaiꞌi naa amazada kawanaꞌati pidannao toꞌoran naobanai Rome ikiꞌo ati. Aizii diꞌi utukapa naꞌapam õkootowapa-kidanuz, unao abatapan puꞌu. Mazan aonaa õikodan dikaudaꞌo nii aimaakan ushaꞌapatan, unao kowaadan kawan õꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aizii Herod naꞌapa kapam, aonaa kanom uikodan dikaudaꞌo nii ushaꞌapatan. Uruu idiꞌo wuruꞌu udyuudanuz uruu powaa ati daꞌatiꞌi. Aonaa kanom dikaudaꞌo nii wuru daonaiora shaꞌapatanuꞌu. Ukauꞌan aonaa kanom dikin ii uzowii-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Uruu idi õbaꞌizii-kidan nii karikaonan uruu, udaunaꞌan marinaꞌa naa umuuda-kao.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Passover Kamoon dono, karikaonan daꞌi Pilate kodita-kidauzon ĩꞌati baudaꞌapa pidan, taraa-kizai iki. ");
INSERT INTO wapNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mazan pidannao kadakoinan uꞌati aonaa masakaudaꞌu mani. “Marii uzowii-kao, pukodita-kida paꞌan Barabbas waꞌati,” ĩkiainan uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aizii Barabbas, wuruꞌu utaratapa-kaoaz, uzauda-kao idiꞌo utoman toꞌorataaka-karu pidannao ati, ĩtoꞌora-kinaa nii Rome ikiꞌo naobanainao ati, wuruꞌu Jerusalem iainao kidaz. Uruu dono baudaꞌapa pidan zowii-kao. Uruu idi Barabbas zauda-kao udikin ii. ");
INSERT INTO wapNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tuukii padamata Pilate tiwaan pakodita-kidan Jesus, uruu idi naꞌapa koshan ukian ĩꞌati kiwiiniꞌo kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mazan maꞌozaka ĩkadakoinan uꞌati. “Marii utauka-kao cross diꞌiti! Marii utauka-kao cross diꞌiti!” ĩkiainan uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Upuꞌu Pilate tiwaan paparadan ĩꞌati. Uruu idikinautan naa uparadan naꞌapa ĩꞌati. “Kanom mooko dikaudaꞌo nii ushaꞌapata? Aonaa kanom õikodan dikaudaꞌo nii ushaꞌapatan. Ukauꞌan aonaa kanom dikin ii uzowii-kao. Uruu idi õbaꞌizii-kidan nii karikaonan uruu naꞌiki udaunaꞌan marinaꞌa naa umuuda-kao,” ukian pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mazan powaꞌa zii ĩkadakoinan uꞌati diiwaꞌo idaꞌan. “Marii utauka-kao cross diꞌiti,” ĩkiainan uꞌati. Ĩkadakoinan uꞌati, atii ĩdikintan uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Uruu idi naꞌapaꞌa naa Pilate dyuudan Jesus shaꞌapata-kao, pidannao aipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Naꞌiki ukodita-kidan naa ĩꞌati pidan wuruꞌu zauda-kariwaiz umizaataakapa-kidan pidannao, naꞌiki uzowian pidan. Udaunaꞌan utaaꞌakan naa Jesus pidannao kaꞌu iti, marii kiziꞌi naa ĩshaꞌapatan uruu Jewnao aipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Udaunaꞌan soldyaanao naꞌakaꞌakan naa Jesus. Aizii ĩmakopa-kizi an ĩikodan pidan kaawaꞌakaꞌo zii Jerusalem ati. Simon kiaꞌo uꞌuu, Cyrene san wuruꞌu pidanaz. Sariapa soldyaanao zaamatan Simon naꞌiki ĩdyuudan naa uwaodatan Jesus dawuꞌati wuruꞌu cross niꞌoraz atamun tuꞌuz. ");
INSERT INTO wapNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Naꞌiki iriba, iriba pidannao makon tazatappan Jesus dawuꞌati. Aizii zunnao naꞌii kapam ĩbii ii, tuukii ĩmuraan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mazan Jesus kian ĩꞌati, “Zunnao, Jerusalem sanaabanao, aonaa uzaadaꞌanaꞌa õdauꞌan. Mishiꞌoraiman uzaada paꞌan unao dauꞌan, naꞌiki udainao dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ushaꞌapanum kauꞌan kainaꞌaꞌo nii kamoo kaawan, uruu dono pidannao kian nii. ‘Konaukiaꞌo nii paꞌan zunnao aonaꞌoraz naꞌapainim ĩkaudaniizon, aonaꞌoraz ĩbiida-kidauzon koraidaonaa.’ ");
INSERT INTO wapNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Uruu dono tuukiaꞌo nii pidannao aipan midukuonao dikitan paugaru, naꞌiki tuukiaꞌo nii ĩaipan naawazi dizan paugaru. ");
INSERT INTO wapNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aizii diꞌi wuruꞌu utukapaniaz dikaudaꞌo aimaakan shaꞌapata-kao õꞌati kaikapaꞌa, aonaa kanom dikin iaꞌo mani, aitaniimanaꞌo nii manawun dikaudaꞌo aimaakan baiaapa-kida-kao Jerusalem sannao ati, ĩshaꞌapaapan dikin ii oii kidaꞌo aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kainaꞌa kapam soldyaanao naꞌakan dyaꞌutam daonaioranao zowii-karu nii, ĩnao zaamata-kao ĩshaꞌapatan idi dikauda kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Udaunaꞌan ĩkaawan naa wuru diꞌitiꞌi amazada dakotapa-kariwaiz Pidan-Zowau-Niwaꞌuz-naawa kii. Naꞌiaꞌa naa ĩtaukan Jesus cross diꞌiti. Naꞌiki dyaꞌutam daonaioranao tauka-kao udazabaꞌa. Baudaꞌapa udiwaꞌora antanapu, baꞌoran uwashabaron antanapu. ");
INSERT INTO wapNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pataukinapa kizi iki Jesus kian padaru ati, “Õdaru, pumainaabata wuruꞌu dikaudaꞌo aimaakan ĩshaꞌapataniaz õꞌati kaikapaꞌa, ushaꞌapanum kauꞌan aonaa ĩaitapan kanom niꞌo wuruꞌu pashaꞌapaapanuz aimaakan kaikapaꞌa.” Udaunaꞌan soldyaanao makinaotinan naa, patukapa-kinaa nii naꞌiaꞌoram nii pidan zaamata Jesus kamichan paꞌidiwau nii. ");
INSERT INTO wapNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Uruu dono iriba pidannao awunuutapan Jesus tauka-kao. Aizii Jewnao naobanaanao, tuukii paꞌan ĩbanikiitan uruu. Kaikapaꞌa wuruꞌu ĩkianuz. “Uruu kazannaapaꞌo baꞌoran pidannao. Aizii watukapa kiziꞌi naa mooko, umishiin an uruu Christ, Tominkaru zaamataniaz, naꞌiki udyuudaniaz kazannaataꞌo nii papidanannao, marii aizii ukazannaatinan paaipan ati,” ĩkian udauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aizii soldyaanao naꞌapa kapam ĩbanikiitan uruu. Udaunaꞌan ĩtaan naa uriwun nii mawinipinaꞌo wine idi. ");
INSERT INTO wapNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Naꞌiki ĩkian uꞌati, “Umishiin an mishi pugaru wuruꞌu king niꞌoraz Jewnao ati, pukazannaatinan nii puaipan ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aizii atamun idaꞌa, uzowau paawaꞌa ĩtaukan pasaadanii. Kaikapaꞌa wuruꞌu ĩsaadaniaz: “Dii wuruꞌu King, Jewnao ati.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aizii baudaꞌapa wuruꞌu tauka-kariwainaouz Jesus dazabaꞌa, uparadan dikaudaꞌo idaꞌan Jesus ati. “Umishiin an pugaru Christ, pukazannaatinaꞌa naa aizii puaipan ati, naꞌiki pukazannaata waunao kapam,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mazan sariapa uiriban toꞌorauanuzu. Naꞌiki ukian uꞌati, “Aonaa mooko pukichanaꞌikin puparadan Tominkaru dauꞌan kaikapaꞌa? Aonaa mooko pudiꞌitapan naꞌapam pupatakaꞌuta-kao naꞌiki pumawakan nii naꞌapa uruu kawan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mazan aonaa kanom dikin iaꞌo mani upatakaꞌuta-kao, aonaa kanom oiaꞌo nii ushaꞌapatan. Mazan waunao, wapatakaꞌuta-kaoaz kaikapaꞌa, washaꞌapatan idiꞌo oiaꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Udaunaꞌan ukian Jesus ati, “Jesus, punyukunuuapa paꞌi õgaru punaobanaita-kao anaꞌa naa.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus kian uꞌati, “Õkowaadan nii puꞌati mishiꞌo: aizii naꞌiaꞌo nii kapam pugaru õtuma konaukii-kizai aokazi ii.” ");
INSERT INTO wapNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Aizii sakitapa kamoo, ipai amazada marutaꞌakan uruu wiizai diꞌii, atii daawadata kamoo. Uruu daunaꞌan zii koshan amazada kanadan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aizii Tominkaru Dapu nazo ii mashaꞌapakiaka kamicha mada wuruꞌu awautapaꞌoraz unazoo kida, kuzuutaꞌakan pazikon an, doko iki atii uwaranu iti. ");
INSERT INTO wapNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Upuꞌaꞌa naa Jesus kadakoꞌokan naa diiwaꞌo idaꞌan. “Õdaru, pukaꞌu iti õtaan õdoronaa,” ukian. Mazan umawakaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Naꞌiaꞌo soldyaanao zowaunaa awunuutapan, uruu idi ipai uabatan, naꞌiki utukapan naꞌapam aimaakan shaꞌapan. Uruu idi tuukii ukonaukii-kidan Tominkaru naꞌiki ukian, “Mishiꞌo mishi kaimanaꞌo pidan arawuꞌu,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Naꞌiki ipai pidannao wuruꞌu awunuutapainao kidaz naꞌii, ipai kapam ĩtukapan wuruꞌu aimaakan kida shaꞌapanuz. Tuukii ĩdiꞌitinpan naꞌiki ĩkashaꞌoran aimaakan shaꞌapata-kao idi naꞌapa. Udaunaꞌan ĩkiwan naa. ");
INSERT INTO wapNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aizii pidannao wuruꞌu aitapainao kidaz Jesus, naꞌiki wuruꞌu tominpauzonao kidaz uꞌidiꞌiki, naꞌii kapam ĩawunuutapan. Naꞌiki zunnao wuruꞌu waꞌatiinaouz utuma Galilee Baara iki, naꞌii kapam baokopa ĩtuma, munapo ĩkadishitapan naꞌiki ĩawunuutapan. ");
INSERT INTO wapNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Uruu dono naꞌiaꞌo pidan, Joseph kiaꞌo uꞌuu. Arimathea ikiꞌo, Judea Baara iaꞌoraz wiizai. Kaimanaꞌo pidan uruu, naꞌiki shaꞌapataꞌo ipai aimaakan Tominkaru aipan kawanaꞌati. Naꞌiki tuukiaꞌo uzaudapan Tominkaru naobanai-tinan kamoon kaawan. Padamata Jewnao, kazowautapaniinao pidannao tumaꞌo uzaamatinpan, mazan upuꞌu aonaa unyukunuu naꞌapan ĩparadan kawanaꞌati, naꞌiki aonaa unyukunuu naꞌapan wuru dauꞌanaꞌa ĩshaꞌapatanuz Jesus kaikapaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sariapa umakon upishaaꞌanan Pilate Jesus nanaa dauꞌan. Naꞌapa Pilate nyukunuu. ");
INSERT INTO wapNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Uruu idi umakon naa Jesus tauka-kizinao iti, naꞌiki naꞌaꞌa naa utoka-kidan unanaa. Naꞌiki upapidan naazu barakaꞌo kamicha mada idi. Kainaꞌa ukichadanii kuba, mawakainao uun nii, naꞌiki aonaꞌo zii kapam ukaiwauzo-kao. Naꞌitiꞌi naa unaꞌakan Jesus nanaa naꞌiki naꞌiaꞌa naa umuudanuz. ");
INSERT INTO wapNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Friday wachuupunin wuruꞌu udida-kaoaz, Jewnao sookapauzon kamoon maonapatan puꞌaꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aizii zunnao waꞌatiinaouz Jesus tuma Galilee Baara iki, naꞌiti ĩmakon baaranai iti. Uruu idi ĩtukapa naꞌiam naa unanaa muuda-kao. ");
INSERT INTO wapNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Uruu daunaꞌan ĩkiwan naa pamashaadinapa kizi iti, ĩtomaꞌanan naa kaduunuribai pakaduunuu-kinaa nii Jesus nanaa. Baꞌoran kamoo uruu Sookapa-karu Kamoon wuruꞌu, uruu idi aonaa kanom ĩshaꞌapatan uruu kamoo dono, Moses kakinaori kian kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aizii chaapiꞌikiiman Sunday dono, zunnao makon baaranai iti. Ĩnaꞌakan kaduunuribai, ĩtomanii pakaduunuu-kinaa nii Jesus nanaa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Aizii ĩkaawan baaranai paniinomizinaa diꞌiti, aonaꞌa naa utaratinpan, zikadaꞌaka-kaoaꞌa naa udaruꞌo kuba, baaranai taratapa-kinaoaz. ");
INSERT INTO wapNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Uruu idi sariapa zunnao morotaꞌakan baaranai paniinomizinaa shaawata. Mazan aonaꞌakaꞌa naa Naobanai Jesus nanaa nii. ");
INSERT INTO wapNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tuukii ĩdiꞌitinpan, uruu idi ĩkadishitapan naa naꞌii, aonaa ĩaitapan naꞌapam pashaꞌapatinan. Upuꞌaꞌa naa ĩtukapan dyaꞌutam daonaioranao, wiziꞌi kidaꞌo ĩkamichan kadishitapan naꞌa padazabaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tuukii ĩtarian, upuꞌu mazan ĩmapotinan ĩꞌati patarian biiꞌi. Naꞌiki daonaioranao kian ĩꞌati, “Kandii nii udorotan kakupaꞌo pidan mawakainao pidannao bii an? ");
INSERT INTO wapNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aonaꞌa naa uruu nii daꞌaꞌa, kadishitaꞌakaꞌa naazu. Kaikapa shaꞌatii tawuruꞌu ukiauzonuz unao ati, tawuruꞌu Galilee Baara iaꞌoraz zii. ");
INSERT INTO wapNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Daonaiora Aokazi Ikiꞌo zaamata-kao nii, udaunaꞌan utaa-kao nii oiainao pidannao kaꞌu iti, udaunaꞌan utauka-kao nii cross diꞌiti, atii umawakan. Mazan idikinaudaꞌu kamoo daunaꞌan ukadishitan nii pamawaka-kizi iki,’ kii shaꞌatii tawuruꞌu ukiauzonuz,” ĩkian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sariapa mishi zunnao nyukunuuaꞌakan Jesus paradan. ");
INSERT INTO wapNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Udaunaꞌan ĩkiwaꞌakan naa atii ĩkaawan 11 Jesus tominapa-kidaniinao diꞌiti. Ipai daunuudaꞌu ĩkowaadan ĩꞌati naꞌiki baꞌorainao ati naꞌapa patukapan kawanaꞌati aimaakan shaꞌapan. ");
INSERT INTO wapNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kaikapaudaꞌuꞌo wuruꞌu zunnaouz, Mary Magdala sanaaba, Joanna, Mary, James daroz, naꞌiki kainaꞌa baꞌoran zunnao ĩtuma. Ipai baokopa ĩnao wuruꞌu kakuwaapainaouz Jesus tominapa-kidaniinao ati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mazan aonaa ĩmishidan zunnao paradan, ushaꞌapanum kauꞌan ĩabatanuz mariidin-karu kawan karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mazan Peter sariapa paꞌan udimaꞌakan baaranai iti. Ukaawan naꞌiti sariapa uawunuupan baaranai paniinomizinaa shaawata, mazan utukapa soo kamicha mada karikaonan, wuruꞌu Jesus nanaa shibata-kinaoaz. Udaunaꞌan ukiwan naa, tuukii udiꞌitinpan patukapan idi aimaakan naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Uruu kamoo dono dyaꞌutam daonaioranao tominpauzonao Jesus diꞌiki makopaanan wiizai Emmaus iti. Munapo zaꞌo wuruꞌu wiizaiz Jerusalem iki. ");
INSERT INTO wapNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aizii wuruꞌu daonaioranaouz ĩkadakotinaanan pamakopa-kizi an, ipai wuru dauꞌaꞌa aimaakan shaꞌapata-kariwaiz naꞌiki kowaada-kariwai kidaz Jesus dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aizii ĩkadakotinaanan puꞌu, mashaꞌapakiaka Jesus kaawaꞌakan naꞌiki uchiꞌikapaanan naa ĩdaawata. ");
INSERT INTO wapNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ĩtukapa padamata Jesus, mazan aonaa ĩaitapan uruun. Ushaꞌapanum kauꞌan dizapa-kariwai ĩaitapan ai uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sariapa upishaan ĩdyaun. Ukian, “Kanom dauaꞌo kaiwuruꞌu ukadakotinaananuz umakopan puꞌu?” Sariapa ĩmashaadaꞌakan, naꞌiki utukapa ĩawun baara kashaꞌora paꞌidiwaru. ");
INSERT INTO wapNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Baudaꞌapa dakoꞌatin uparadan, Cleopas kiaꞌo uꞌuu, ukian uꞌati, “Soo baudaꞌapa pugaru Jerusalem idaꞌa maaitapa-kaꞌo wuru dauꞌanaꞌa aimaakan shaꞌapata-kariwai kidaz diikiꞌiꞌi?” ");
INSERT INTO wapNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Naꞌapaꞌoram wuruꞌu aimaakan kida shaꞌapata-kariwaiz?” ukian ĩꞌati. “Tawuruꞌu kashaꞌora kidaꞌoraz aimaakan shaꞌapata-kao Jesus ati, Nazareth sanaz. Tominkaru prophetin uruu. Mishi Tominkaru tukapa-kidan uruu kaimanaꞌo, naꞌiki umanawunuꞌo pidan, ipai wuru idaꞌanaꞌa ushaꞌapatanii kidaz aimaakan naꞌiki ukakuwaatinan idaꞌan maꞌozaka. Ipai pidannao naꞌapa kapam ĩtukapan uruu, kaimanaꞌo, naꞌiki umanawunuꞌo mishi pidan. ");
INSERT INTO wapNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wafaadaannao zowaunaanao, naꞌiki kazowautapainao Jewnao wuruꞌu zaamata-kidaꞌoraz uruu. Udaunaꞌan ĩtaan naa uruu Rome ikiꞌo naobanai kaꞌu iti, ĩzowii-kidan naaz cross paawaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Waꞌitiiman shaa uruꞌo nii wuruꞌu kazannaataꞌoraz Israelitenao patarubanao ai. Aizii diꞌi uikodaꞌakaꞌa naa idikinaudaꞌu kamoo umawakan daunaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Naꞌiki powaꞌa zii kainaꞌa aimaakan diꞌitinapa-kidan waunao tuukii. Aizii chaapiꞌiki, waunao bii ikiinao zunnao makonkan ubaaranaa ii. ");
INSERT INTO wapNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Aonaꞌa naa ĩikodan unanaa naꞌii. Mazan ĩkaawan powaa ati ĩkowaadan waꞌati, patukapan dyaꞌutam angelnao. Naꞌiki angelnao kowaadan ĩꞌati kadishitaꞌakaꞌa naa Jesus powaa iti. ");
INSERT INTO wapNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Zunnao kaawan daunaꞌan, sariapa waunao bii ikiꞌo daonaioranao makon kapam baaranai iti. Naꞌiki ipai ĩtukapan aimaakan naꞌapa zunnao kowaadan kawan. Mazan aonaa ĩikodan Jesus naꞌii.” ");
INSERT INTO wapNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Udaunaꞌan Jesus dakoꞌatin ĩparadan naꞌiki ukian ĩꞌati, “Maam, naꞌapa dii manawun umaaitapakan aimaakan, naꞌiki kashaꞌapannaa umishidan tawuruꞌu kotuaꞌo Tominkaru prophetinnao saadauzonii kidaz? ");
INSERT INTO wapNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aonaa mooko uaitapan wuruꞌu Christ, Tominkaru dyuudaniaz kazannaataꞌo nii papidanannao, baiaapan nii ipai wuruꞌu naꞌapa kidaꞌoraz aimaakan? Uruu daunaꞌan umakon nii aokazi iti, naꞌiki karikaonanuꞌo niꞌi naa ukonaukiitin-kida-kao naꞌii,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Udaunaꞌan ukowaadan naꞌiki unyukunuu-kidan ĩꞌati ipai naꞌapaꞌoram manawun tawuruꞌu Moses naꞌiki prophetnao saadanii kidaz padauꞌan, Tominkaru Paradan idaꞌaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ukadakotinaanan ĩꞌati, atii naꞌapa ĩmaonapatan wuru diꞌitiꞌi pamakopa-kiziz wiizai. Mazan ĩtukapan Jesus sariapa paꞌan udobatan. ");
INSERT INTO wapNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Uruu idi tuukii ĩmashaatan uruu. “Punaꞌaꞌa naa zii shoman pudaꞌawu aka watuma, wachuupun naa paꞌi wuruꞌu, naꞌiki taaꞌazoꞌo naa wamarutan,” ĩkian uꞌati. Uruu idi umakon ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aizii kabaunuꞌiaꞌa naa, uruu ĩaroopaꞌazon naa. Uruu idi Jesus sakanatan ĩtuma. Naꞌiki sariapa uzaamatan bread, udaunaꞌan utoriinapa-kidan naaz. Uruu daunaꞌan udushowan naa bread ĩkawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Uruu idaꞌa zii ĩawun daꞌata-kao ĩaitapa-kinaa nii Jesus. Ĩawunuupan uꞌidiꞌiti sariapa ĩaitapaꞌakan uruu. Mazan upuꞌaꞌa naa umainaabatinaꞌakan ĩawun zaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sariapa ĩkian paꞌatiaaka kida, “Ei, uruu idiꞌo tawuruꞌu kaimanaiman uparadan pishatan wanyukunuu, ukadakotinaananuz waꞌati dunapota. Naꞌiki unyukunuu-kidanuzu waꞌati ipai daunuudaꞌu naꞌapam saadauzo-kariwaiz Tominkaru paradan kian.” ");
INSERT INTO wapNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Udaunaꞌan ĩminziiwaꞌakan naa, naꞌiki ĩpadantaꞌakan naa koshan Jerusalem iti. Aizii ĩkaawan naꞌiti ĩikoda wuruꞌu 11 Jesus tominapa-kidaniinao, kasabaꞌukinpan baokopa, baꞌorainao kida tuma. ");
INSERT INTO wapNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Naꞌiki ĩabatan ĩkadakotinan. “Mishiꞌo wuruꞌu wanaobanaa kadishitan, naꞌiki ukakudanuz naa powaa iti. Simon Peter tukapaꞌakaꞌa naa kapam uruu,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Udaunaꞌan ĩnao kowaadan naa kapam ipai daunuudaꞌu naꞌapam Jesus chiꞌikapaanan patuma dunapota. Ĩkowaadan ĩꞌati aonaa ĩaitapanuz, atii udushowan idaꞌan zii bread ĩꞌati, ĩaitapan uruu. ");
INSERT INTO wapNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aizii wuruꞌu dyaꞌutamainaouz daonaioranao kakuwaapatinan puꞌu zii pairibannao ati, upuꞌaꞌa naa Jesus kaawaꞌakan ĩꞌidaꞌati mashaꞌapakiaka. Naꞌiki ukian ĩꞌati, “Marii kaiman-karu mashaapan unao tuma.” ");
INSERT INTO wapNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mazan tuukii ĩtarian, ĩꞌitiiman shaa udoronaa nii karikaonan wuruꞌu patukapaniaz. ");
INSERT INTO wapNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mazan Jesus kian ĩꞌati, “Kandii nii utarian? Naꞌiki kandii nii aonaa umishidan utukapan õgaru? ");
INSERT INTO wapNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aushaa utukapa mooko õkaꞌu diꞌi, utukapa õkidiba, mishi õgaru wuruꞌu. Uwaꞌati daꞌatiꞌi upishata kizi õgaru, upishata õmada, utukapa kizi mishi õgaru wuruꞌu. Aizii doronai aonaa udunaa nii oo uniwaꞌuz nii, wuru kawanuꞌu upishatanuz õgaru,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Uruu idi utukapa-kidan naa ĩꞌati pakaꞌu naꞌiki pakidiba. ");
INSERT INTO wapNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tuukii ĩkonaukian naꞌiki tuukii ĩdiꞌitinpan, aonaa ĩmishidan wuruꞌu patukapanuz Jesus. Uruu idi ukian ĩꞌati, “Kainaꞌa aimaakan daꞌaꞌa nika-karu nii?” ");
INSERT INTO wapNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sariapa ĩtaan uꞌati kopau waraka-kariwaiꞌi naa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Uruu idi uzaamatanuz naꞌiki uaroopan naa ĩawun zaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Udaunaꞌan Jesus kian naa ĩꞌati, “Aizii diꞌi wuruꞌu utukapaniaz ipai aimaakan kida shaꞌapan kaikapaꞌa. Uruꞌu naa tawuruꞌu õkowaadauzoniaz unao ati, wachiꞌikapauzon donoꞌoraz baokopa. Kaikapa shaꞌatii tawuruꞌu õkiauzonuz unao ati. ‘Ipai wuruꞌu Moses saadanii kidaz õdauꞌan, naꞌiki wuruꞌu Tominkaru prophetinnao saadanii kidaz, naꞌiki wuruꞌu saada-kariwai kidaz õdauꞌan Psalms idaꞌa, ipaiꞌo nii zii uruu kida mishii-kao,’ kii shaꞌatii tawuruꞌu õkiauzonuz uꞌati,” Jesus kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naꞌiki utaan naa ĩaitapa-kinaa nii naꞌapaꞌoram manawun wuruꞌu saada-kariwaiz Tominkaru paradan idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Udaunaꞌan ukian naa ĩꞌati, “Kaikapa shaꞌatii tawuruꞌu Tominkaru paradan saada-kariwai kida kianuz. ‘Zowii-karu nii wuruꞌu Tominkaru dyuudaniaz kazannaataꞌo nii papidanannao, mazan idikinaudaꞌu kamoo umawakan daunaꞌan ukakudan nii powaa iti, naꞌiki ukadishita-kida-kao nii pabaaranaa iki. ");
INSERT INTO wapNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Marii paꞌi kuwai kowaadapa-kao uꞌuu idaꞌan ipai pidannao ati, ipai imiꞌi baara an, marii ukowaada-kao Jerusalem sannao ati kiwiin. Kaikapaꞌo wuruꞌu kuwaiz: pidan tanawatinan an paꞌoian ai, Tominkaru mainaabatan nii ĩꞌoian.’ ");
INSERT INTO wapNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ukauꞌan õdyuudan ukakuwaapan ipai wuru dauꞌaꞌa utukapanii kidaz shaꞌapan õꞌati. ");
INSERT INTO wapNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naꞌiki õdyuudan nii unao idaꞌati tawuruꞌu õdaru kowaadauzoniaz pataaꞌazon unao ati. Mazan unaꞌaꞌa naa zii paꞌi uzaudapa daꞌaꞌa Jerusalem idaꞌa, atii õdyuudan aokazi iki wuruꞌu õdaru dyuudaꞌazooniaz unyukunuu maꞌozaka-kinaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Udaunaꞌan Jesus naꞌakan naa ĩdyaun Jerusalem iki atii Bethany iti. Naꞌiaꞌa naa usawadan pakaꞌu ĩꞌidiꞌiti, naꞌiki utoriinpan Tominkaru ati, marii kizi utaan kaimanaꞌo mashaapa-karu ĩnyukunuu iti. ");
INSERT INTO wapNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Utoriinapa-kidan puꞌu ĩdyaun, uruꞌu naa usawatinaꞌakan, naꞌiki unaꞌakaꞌaka-kaoaꞌa naa aokazi iti. ");
INSERT INTO wapNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Sariapa ĩkodoruꞌukan uꞌati, ĩawun doko iti. Uruu idi tuukii ĩkonaukian, udaunaꞌan ĩkiwaꞌakan naa konaukii Jerusalem iti. ");
INSERT INTO wapNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aizii Jerusalem iaꞌa naa, ipai kamoo ĩmakoꞌanpan Tominkaru Dapu iti, ĩtoriinpan naꞌiki ĩkonaukii-kidan Tominkaru.");
INSERT INTO wapNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Amazada toma-kao uaꞌii naꞌaꞌoraꞌa naa Parada-karu, uruu Tominkaru tumaꞌo, naꞌiki uruu Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Uruu naꞌaꞌoraꞌa naa Tominkaru tuma amazada toma-kao uaꞌii. ");
INSERT INTO wapNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Uruu idaꞌanaꞌo Tominkaru toman ipai aimaakan. Aonaa aimaakan tominan shaꞌapaꞌoram idaꞌan karikaonan, soo Uruu idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uruu idaꞌa kakupa-kinai, naꞌiki wuruꞌu kakupa-kinaiz uruu kanadapaꞌoraz pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kanadaꞌo kanadapan marutaꞌo-karuꞌu, aonaa turuu marutaꞌo makadanuzu. ");
INSERT INTO wapNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kainaꞌaꞌo daꞌi pidan, John kiaꞌo uꞌuu, Tominkaru dyuudanii. ");
INSERT INTO wapNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ukaawan ukakuwaapaꞌanan pidannao ati kanadaꞌo dauꞌu, ukuwaa idaꞌan kizi ipai ĩabatan naꞌiki ĩmishidan kanadaꞌo dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aonaa John mani wuruꞌu kanadaꞌoraz, mazan ukaawan, ukakuwaapaꞌanan kanadaꞌo dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wuruꞌu kanadaꞌoraz, kainaꞌiki uwaꞌatipan imiꞌi baara ati, uruu paꞌan kanadapaꞌoraz ipai pidannao. ");
INSERT INTO wapNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kaawankaꞌo Parada-karu imiꞌi baara ati. Uruu idaꞌanaꞌo Tominkaru toman imiꞌi baara naꞌiki pidannao, mazan upuꞌu aonaa ĩaitapan kanom wuru uruuz. ");
INSERT INTO wapNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ukaawan pawiizi idaꞌatiꞌo padamata, mazan uiribannao, aonaa ĩnaubaan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mazan naꞌiaꞌoram pidan naubaꞌo naꞌiki mishidaꞌo uruu, utaapada ĩtominan Tominkaru dainao nii. ");
INSERT INTO wapNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aonaa ĩtominan Tominkaru dainao nii koraidaonaa shakatan kawan, oo pidan aipan kawanaꞌati mani, soo Tominkaru aipan kawanaꞌati paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aizii wuruꞌu Parada-karuz, utominan pidan nii naꞌiki umashaapankan wabii an. Watukapa naꞌapam uruu mishiꞌo umanawunun. Ushaꞌapanum kauꞌan baudaꞌapauzon Tominkaru dani wuruꞌu uruuz. Uruu idaꞌanaꞌo Tominkaru kainaabatan kaimanaiman pakamunanban naꞌiki uruu idaꞌanaꞌo mishiꞌo kuwai kainaabata-kao waꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John kakuwaapan udauꞌan pidannao ati, ukian diiwaꞌo idaꞌan ĩꞌati: “Diꞌi naa tawuruꞌu õkaunamunaataniaz: Kainiꞌikiꞌo nii uwaꞌatin õdawuꞌati, mazan uruu powaꞌaꞌo zii umanawunun õꞌai, ushaꞌapanum kauꞌan uruu naꞌaꞌoraꞌa naa õshakatan uaꞌii, õkii-kiziz.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ukamunanun idi manawun, powaꞌan kida ushaꞌapatan kaiman kidaꞌo aimaakan waꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tominkaru taa-kidan Moses idaꞌan pakakinaori; mazan utaan mishiꞌo kuwai naꞌiki utukapa-kidan pakamunanun Jesus Christ idaꞌan paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aonaa pidan tukapauzon Tominkaru. Soo Udani baudaꞌapauzoz, karikaonanuꞌoraz unaꞌan Tominkaru tuma, uruu kaimanaiman ukainaabatan Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Jewnao zowaunaanao Jerusalem iainaouz dyuudan faadaanao naꞌiki ĩminkaꞌu Levitenao pishaaꞌanan John kanom kaduz manawun wuruꞌu uruuz. Ukowaada ĩꞌati kaimanaiman, ipai kizi pidannao aitapan, “Õgaru, aonaa Christ mani,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aizii ĩkian uꞌati, “Ukauꞌan kanom mooko pugaru? Elijah shaꞌa pugaru?” “Aonaa!” John kian ĩꞌati. “Pugaru shaꞌa Prophet, tawuruꞌu kaawaꞌo niꞌoraz?” ĩkian uꞌati. “Aonaa,” ukian koshan ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Uruu idi ĩkian uꞌati, “Ukauꞌan kanom kaduz mooko manawun wuruꞌu pugaruz? Waaipan wakuwaa nii, wunao atiꞌo niꞌi dyuudainaouz waunao. Pukowaadaꞌakaꞌa naa kanom kaduz wuruꞌu pugaruz!” ");
INSERT INTO wapNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John kian ĩꞌati, “Õgaru dauꞌanaꞌo tawuruꞌu prophet Isaiah saadauzonuz kaikapaꞌa: ‘Kainaꞌaꞌo pidan kadakoinpan diiwa mapidantakaꞌo amazada ii aka: Usaabaꞌa naa dunapo Naobanai mako kizi nii.’” ");
INSERT INTO wapNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Phariseenao kapam wuruꞌu dyuuda-kariwai ĩpishaaꞌanan John. ");
INSERT INTO wapNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Uruꞌu naa ĩkian John ati, “Pukian puꞌu aonaa Christ mani pugaru, aonaa Elijah mani, naꞌiki aonaa Tominkaru Prophetin mani, tawuruꞌu wazaudapaniaz, mazan kandii nii mooko puchikaawunuupan?” ");
INSERT INTO wapNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aizii John kian ĩꞌati, “Õgaru, õchikaawunuupan wunu idi. Mazan kainaꞌa ubiiꞌi baꞌoran pidan, aonaꞌo uaitapan kanom kaduz uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Uruuꞌo niꞌi naa tukapa-kao umanawunuꞌo nii õnaꞌan puꞌu zii. Õgaru aonaa õturuan õbuzuutan udazkidi zunaa.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","John kakuwaapatinanuz kaikapaꞌa, Bethany iaꞌo, waoko iaꞌoraz Jordan Waꞌo ai, uchikaawunuupauzo-kiziz. ");
INSERT INTO wapNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Baꞌoran kamoo John tukapan Jesus waꞌatin paꞌidaꞌati, naꞌiki ukian pidannao ati: “Diꞌi naa wuruꞌu Tominkaru taaniaz Kaznizo-dani kawanuꞌo niꞌoraz, soꞌotaꞌoraz pidannao oian! ");
INSERT INTO wapNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uruu dauꞌatiꞌo tawuruꞌu õkianuz, ‘Utukapa-kao niꞌi naa umanawunuꞌo nii õnaꞌan puꞌu zii, mazan uruu powaꞌaꞌo umanawunun õꞌai, ushaꞌapanum kauꞌan uruu kiwiitapaꞌo õꞌai.’ ");
INSERT INTO wapNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Õgaru, aonaa õaitapan kanom kaduz uruu, mazan õchikaawunuupan wunu idi, Israelitenao aitapa-kinaa niꞌo kanom kaduz uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","John kowaadan kaimanaiman patukapanii dauꞌu: “Õtukapanii Kaimanaꞌo Doronaa waꞌatin aokazi iki orid kawan, naꞌiki upakotan uruu idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kiwiin zii, aonaa õaitapan kanom kaduz uruu. Mazan dyuudaꞌoraz õchikaawunuupan wunu idi kian õꞌati, ‘Putukapan an Kaimanaꞌo Doronaa waꞌatin doko iki naꞌiki umashaadinan dono pidan idaꞌa, uruꞌu naa wuruꞌu chikaawunuupaꞌo niꞌoraz Kaimanaꞌo Doronaa idi.’ ");
INSERT INTO wapNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Õtukapan idi ushaꞌapan naꞌapa, ukauꞌan, õkian uꞌati, Tominkaru Dani wuruꞌu diꞌorazuꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Baꞌoran kamoo naꞌiaꞌo koshan John naꞌiki naꞌiaꞌo utuma, dyaꞌutam utominapa-kidaniinao. ");
INSERT INTO wapNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Utukapan Jesus dobatapan naꞌiki, ukian udauꞌan, “Diꞌi naa wuruꞌu Tominkaru taaniaz Kaznizo-dani kawanuꞌo niꞌoraz!” ");
INSERT INTO wapNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aizii dyaꞌutamainaouz John tominapa-kidaniinao, ĩabatanii uparadan naꞌapa, uruꞌu naa ĩdaꞌanpaꞌakan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus awunuuankan powaa iti, utukapa ĩwaꞌatin padawuꞌati. Uruꞌu naa upishaan ĩdyaun, “Kanom udawatapan?” Ĩkian uꞌati, “Tiichaa. Naꞌiaꞌo dii pumashaadinpan?” ");
INSERT INTO wapNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Uwaꞌati, utukapa kizi,” ukian ĩꞌati. Uruꞌu naa ĩmakon utuma naꞌiki ĩtukapa naꞌiam umashaadinpan, (4 oꞌclock wachuupunin wuruꞌu) uruu naꞌiaꞌa naa ĩchuupudinan utuma. ");
INSERT INTO wapNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Aizii wuruꞌu daꞌanpaꞌakainaouz Jesus, paabatan daunaꞌan John paradan, baudaꞌapaꞌo uu Andrew, uruu Simon Peter inawuzu. ");
INSERT INTO wapNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kiwiin zii chaapiꞌiki, Andrew tukapan paꞌinawuzu Simon naꞌiki ukakuwaapan uꞌati, “Waikodaꞌa naa Messiah!” ukian. (Messiah, kii-karu Christ kiaꞌo kapam wuruꞌu.) ");
INSERT INTO wapNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Uruꞌu naa unaꞌakan Simon, Jesus diꞌiti. Jesus awunuupan uꞌidiꞌiti, ukian uꞌati, “Pugaru Simon, John dani. Aizii puꞌuu Cephas kiaꞌo nii.” (Peter kiaꞌo kapam wuruꞌu, naꞌiki kuba kiaꞌo wuruꞌu.) ");
INSERT INTO wapNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Baꞌoran chaapiꞌiki Jesus diꞌitinpan umakoꞌozon Galilee Baara iti. Uikodapan Philip naꞌiki ukian uꞌati, “Puwaꞌati õtuma, putominapa kizi.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Philip, uruu Bethsaida san, naꞌiaꞌo Andrew naꞌiki Peter mashaapan kapam.) ");
INSERT INTO wapNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Uruu daunaꞌan Philip ikodan Nathanael naꞌiki ukian uꞌati, “Waikodaꞌa naa tawuruꞌu Moses naꞌiki prophetnao saadauzoniaz Kakinaorii Kaaritannaa idaꞌa udauꞌan. Uruu Jesus, Joseph dani, Nazareth sanaz.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Nazareth san!” Nathanael kian, “Naꞌapa diꞌi naa aimaakan kaimanaꞌo shaꞌapan uruu wiizai diꞌiki paꞌan?” “Puwaꞌati putukapa kizi,” Philip kian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aizii Jesus tukapan Nathanael waꞌatin paꞌidaꞌati, sariapa ukian udauꞌan, “Arawuꞌu mishiꞌo Israelite, aonaa naꞌitim umariidinan.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael pishaan uruu, “Naꞌapa dii puaitapan õdauꞌan?” Jesus kian uꞌati, “Philip dapadan uaꞌii pugaru, õtukapanii pugaru paoribai fig waranu ii.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Tiichaa,” Nathanael kian uꞌati, “Pugaru Tominkaru Dani! Pugaru King Israelitenao ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus kian uꞌati, “Õkowaadan idiꞌo puꞌati, ‘Õtukapan pugaru paoribai fig waranu ii,’ uruu idiꞌo pumishidaꞌakan? Putukapan nii zii umanawun kidaꞌo aimaakan shaꞌapan wuru aiaꞌa!” ");
INSERT INTO wapNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Naꞌiki ukian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Utukapan nii aokazi daꞌatinan, naꞌiki Tominkaru angelinnao makoꞌanpan doko iti, naꞌiki ĩwaꞌatiꞌanpan apowa ati Daonaiora Aokazi Ikiꞌo idaꞌan!” ");
INSERT INTO wapNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dyaꞌutam kamoo daunaꞌan kainaꞌa mazidainao aroopaꞌazon Cana ii, Galilee Baara iaꞌoraz donoi. Jesus daro naꞌiaꞌo oroo. ");
INSERT INTO wapNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus naꞌiki utominapa-kidaniinao, naꞌitiꞌo ĩdapada-kao kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aizii riwunii wine ipain idiꞌi naa, sariapa Jesus daro kian uꞌati, “Ipaiꞌi naa ĩriwun.” ");
INSERT INTO wapNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Kanom nii punyukunuupaꞌazon õgaru?” Jesus kian oꞌati. “Aonaa zii amazada kaawan õshaꞌapata-kinaa nii aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sariapa udaro kian naꞌiaꞌo poitoruinao ati, “Ushaꞌapata paꞌi naꞌapam dono ukian uꞌati!” ");
INSERT INTO wapNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Naꞌii kainaꞌa 6 dowada kida, kuba idiꞌo ĩtoma-kao. Uruu kaduz dowada kida Jewnao kaiwauzonii wunu kinnaa nii pachikain-kinaa nii, ĩchoochin kakinaorinaa kawanaꞌati. Uwazoo kida tuubarun 20 oo 30 gallon kida. ");
INSERT INTO wapNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus kian naa poitoruinao ati, “Upaidada wuruꞌu dowada kidaz wunu idi.” Uruꞌu naa ĩkapowan wunu naꞌiki ĩkawazootan naa dowada kida atii ĩpaidan. ");
INSERT INTO wapNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Udaunaꞌan Jesus kian ĩꞌati, “Aizii ukapotaꞌa naa dowada wazoo, utaa kizi kazowautapaꞌo aroapa-karu atiz.” Uruꞌu naa ĩnaꞌakan uꞌidiꞌiti wuruꞌu wunuz, ");
INSERT INTO wapNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","panaꞌadinaꞌakaꞌoraz naa wine nii, naꞌiki uruꞌu naa utiwaanuz. Mazan aonaa uaitapan naꞌikiꞌoram ukaawa-kida-kao. (Soo poitoruinao kapotainaouz wunu, ĩaitapa paꞌan.) Sariapa udapadan wuruꞌu mazidaꞌoraz ");
INSERT INTO wapNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","naꞌiki ukian uꞌati, “Kiwiiniꞌo padamata kaimanaꞌoraz wine maokodauzo-kao. Aizii morowautapainao tuzan donoꞌo naa kaimanaiman, udaunaꞌan zii turuu shaꞌapaꞌoram karikaonan wine maokoda-kao. Mazan pugaru pakawan zii putaapan wuruꞌu kaimanaꞌoraz wine, atii kai!” ");
INSERT INTO wapNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cana iaꞌo wuruꞌu kiwiiniꞌoraz Jesus shaꞌapatan umanawunuꞌo aimaakan. Naꞌii uaida-kidan naꞌapam paugaru umanawunun. Uruu idi kaimanaimanaꞌa naa utominapa-kidaniinao mishidapan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Uruu daunaꞌan umakon naa donoi Capernaum iti padaro naꞌiki paꞌinawuzunao tuma, naꞌiki patominapa-kidaniinao tuma kapam. Mazan aonaa ĩnaꞌian kotuaꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aizii maonapaꞌa naa Passover Kamoon sakadinan, uruꞌu naa Jesus makon Jerusalem iti. ");
INSERT INTO wapNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Uikoda Tominkaru Dapu ii, selliipainao tapiꞌiza, kaznizo, naꞌiki wakokoonao. Uikoda kapam naꞌii pidannao shakataaka-kidauzo puraata. ");
INSERT INTO wapNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Uzaamataꞌakan doꞌooribai pabaꞌizin nii, uruꞌu naa uwaatan Tominkaru Dapu iki ipai ĩꞌuzanao, kaznizonao naꞌiki tapiꞌizanao. Aizii shakataaka-kidauzonao puraatan miisan kida, udorau-kidaꞌakan, ĩpuraatan zokotaꞌakan kidaꞌa naa ubaaraꞌa kidaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesus kian selliipainao ati wakokoonao, “Ukodita-kida wuru kidaꞌa diꞌikiꞌi! Aonaa turuu utaapan õdaru dapu puraataapa-kizai nii.” ");
INSERT INTO wapNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Sariapa utominapa-kidaniinao nyukunuuan Tominkaru Paradan saada-kariwaiz kian, “Tuukii manawun õkaziwadapan õnyukunuu, õmarainpan idi pudapu.” ");
INSERT INTO wapNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jewnao zowaunaanao kian uꞌati, “Turuu mooko pushaꞌapatan waawun zaꞌa umanawunuꞌo aimaakan, wamishida-kinaa nii Tominkaru aipan atiꞌo wuruꞌu pushaꞌapatanuz aimaakan kaikapaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus kian ĩꞌati, “Umainaabata wuruꞌu Tominkaru Dapuz, naꞌiki idikinaudaꞌu kamoo idaꞌa õkadishita-kidan nii powaa itiz.” ");
INSERT INTO wapNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aizii ĩkian uꞌati, “Diꞌoraꞌa Tominkaru Dapu 46 wunu utomapa-kao. Aizii turuu mooko puzauda-kidan pukadishita-kidaꞌakanuzu idikinaudaꞌu kamoo idaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mazan Tominkaru Dapu Jesus kianuz, pananaa dauꞌatiꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tominkaru kadishita-kidan daunaꞌan Jesus mawaka-karu diꞌiki, utominapa-kidaniinao nyukunuitapan wuruꞌu uparadanuz. Ĩmishida wuruꞌu saada-kariwaiz kida Tominkaru Paradan, naꞌiki ĩmishida Jesus paradan kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Unaꞌian puꞌu Jerusalem ii Passover Kamoon dono, iriba pidannao mishidan uruu ĩtukapan idi ushaꞌapaapan umanawun kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mazan Jesus aitapan idi ipai pidan kaduz, aonaa ukainaabatinan kaimanaiman ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aonaa kanom nii uaipan pidan kakuwaapan paꞌati pamin-pidanan dauꞌu, ushaꞌapanum kauꞌan uaitapanii ipai pidan nyukunuu. ");
INSERT INTO wapNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kainaꞌa pidan, Nicodemus kiaꞌo daꞌi uꞌuu, kazowautapaꞌo Jewnao, naꞌiki Phariseenao tonaazinaa diꞌitiꞌo uzaamatinpan. ");
INSERT INTO wapNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ukaawan aiwakaꞌan Jesus idaꞌati naꞌiki ukian uꞌati, “Tiichaa, waaitapa Tominkaru diꞌikiꞌo pukaawan putominapa-kidaꞌanan waunao. Ushaꞌapanum kauꞌan aonaa kanom kaꞌiitan pashaꞌapatan umanawun kidaꞌo aimaakan wuruꞌu pushaꞌapaapaniaz, soo Tominkaru kainaꞌan dono utuma.” ");
INSERT INTO wapNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus kian uꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Aonaa turuu pidan tukapan Tominkaru Naobanai-tinapa-kizi, soo ushakatan an koshan.” ");
INSERT INTO wapNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus kian uꞌati, “Naꞌapa dii mooko pidan tunarunao shakatan koshan? Aonaa turuu umorotan padaro toba nazo iti ushakata kizi itamau!” ");
INSERT INTO wapNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus kian uꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Aonaa turuu pidan morotan Tominkaru Naobanai-tinapa-kizi iti, soo ushakatan an wunu idaꞌan naꞌiki Doronai idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Padaronao diꞌikiꞌo pidan shakatan pananaa zoꞌo, mazan Doronai idaꞌanaꞌo pidan shakatan padoronaa iaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Aonaa pumaaitapakaꞌanaꞌa kaiwuruꞌu, ‘Unao shakata paꞌi powaꞌa koshan,’ õkianuz puꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Awaru makon pamakoꞌozoo-kizi iti. Puabata mishi uwaꞌidan, mazan aonaa puaitapan naꞌikiꞌoram uwaꞌatin oo naꞌitiꞌoram umakon. Naꞌapaꞌo kapam wuruꞌu pidan Kaimanaꞌo Doronaa diꞌikiꞌoraz ushakatan.” ");
INSERT INTO wapNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus pishaan Jesus, ukian, “Naꞌapa dii mooko turuu naꞌapa kidaꞌo aimaakan shaꞌapan?” ");
INSERT INTO wapNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus kian uꞌati, “Pugaru aitapa-kariwai putiichaa-tinpan Israelitenao ati, mazan naꞌapa dii pumaaitapakan naꞌapa kidaꞌo aimaakan? ");
INSERT INTO wapNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mishiꞌo kaiwuruꞌu õkianuz: Waparadan waaitapanii dauaꞌo, naꞌiki wakowaadan watukapanii dauaꞌo, mazan upuꞌu aonaa pumishidaꞌazon wakuwaa. ");
INSERT INTO wapNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Õkowaadan puꞌati imiꞌi baaraꞌaꞌo aimaakan kida shaꞌapan dauꞌu, mazan aonaa pumishidan. Naꞌapam nii mooko pumishidan õgaru, õkowaadan an puꞌati aokazi ii kidaꞌo aimaakan dauꞌu? ");
INSERT INTO wapNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aonaa kanom makouzon aokazi iti, soo Daonaiora Aokazi Ikiꞌo, uruu waꞌatiꞌoraz aokazi iki. ");
INSERT INTO wapNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kotuaꞌa naa mapidantakaꞌo amazada diꞌii, Moses sawatauzon tooro munaꞌa kowazaz toma-kariwai chipirari idi. Naꞌapaꞌo nii manawun Daonaiora Aokazi Ikiꞌo sawata-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ukauꞌan, naꞌiaꞌoram pidan mishidan dono uruu, mishiꞌo nii uikodan karikaonanuꞌo kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tominkaru marainpan idi manawun pidannao, utaa paudani baudaꞌapauzon. Ukauꞌan naꞌiaꞌoram pidan mishidan dono uruu, aonaꞌo nii umawakauzon, mazan uikodan nii karikaonanuꞌo kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tominkaru dyuudan pauDani imiꞌi baara ati, aonaa patakaꞌutaꞌo niꞌo mani pidannao paꞌoian dikin ii, mazan ĩkazannaatin-kinaa niꞌo paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Aonaꞌo nii Tominkaru patakaꞌutan mishidainaouz uDani. Soo upatakaꞌutan nii wunao paꞌanaꞌa, aonaꞌoraz ĩmishidan ubaudaꞌapauzon udani. ");
INSERT INTO wapNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kaikapaꞌo wuruꞌu, Tominkaru dakota-kinaaz pidannao oiaꞌo nii: Kaawaꞌoraꞌa naa kanadaꞌo imiꞌi baara ati, mazan pidannao tuukii ĩmarainpan marutaꞌo wuru aiaꞌa kanadaꞌoraz, Tominkaru diꞌikiꞌoraz ukaawan. Ĩshaꞌapaapan idi soo oiaꞌo paꞌidiwaru. ");
INSERT INTO wapNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pidan shaꞌapaapaꞌo oiaꞌo aimaakan kida, aonaa unaudapan kanadaꞌo naꞌiki aonaꞌo nii uwaꞌatin kanadaꞌo idaꞌati. Ushaꞌapanum kauꞌan naꞌapaꞌo pidan aonaa uaipan paꞌoian kida kainaabata-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mazan pidan mishiꞌo umashaapan Tominkaru ati, utaapada paꞌan kanadaꞌo kanadapan paugaru, kanadaꞌo kainaabata kizi wuruꞌu ushaꞌapaapanuz aimaakan kida uizoꞌatin idiꞌo paꞌan Tominkaru.” ");
INSERT INTO wapNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Uruu daunaꞌan, Jesus makon Judea Baara iti patominapa-kidaniinao tuma. Tomunuꞌiki unaꞌian ĩtuma, naꞌiki naꞌii uchikaawunuu-kidaꞌakan pidannao. ");
INSERT INTO wapNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John chikaawunuupaꞌo kapam pidannao Aenon ii maonapa Salim iti, wunu baoko tuubarun idi kida naꞌii. Pidannao kaawa-kaawan kida ĩchikaawunuinaꞌanan naꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Uruu shaꞌapan John taraa-kao uaꞌiaꞌo zii.) ");
INSERT INTO wapNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John tominapa-kidanii bii ikiinao kashadaakapan baꞌoran Jew tuma chikain-karu dauꞌan choochi kakinaopan kawanaꞌatiꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aizii ĩkaawan naa John diꞌiti, ĩkian uꞌati, “Tiichaa, puaitapa tawuruꞌu pidan putumaꞌoraz Jordan baza ii, tawuruꞌu pukowaadapaniaz pidannao ati? Mazan aizii kainaꞌaꞌa naa uchikaawunuuapa-kidan pidannao, naꞌiki iriba, iriba pidannao makon uꞌidiꞌiti!” ");
INSERT INTO wapNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John kian ĩꞌati, “Aonaa kanom kaꞌiitan pashaꞌapatan aimaakan paaipan ati, soo Tominkaru dyuudan an uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Unao abata shaꞌatii tawuruꞌu õkianuz, ‘Õgaru aonaa Christ mani, õgaru dyuuda-kariwai karikaonan uruu uaꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mazida-kizai ii, mazidaꞌakaiba paꞌan makoꞌoraz pamin-mazidan tuma. Mazan upuꞌu zii mazidaꞌakaꞌo paonaru konaukian uabatan idi mazidaꞌo imodapan, ukonaukian idi paudaiaro dauꞌan. Naꞌapaꞌo manawun wuruꞌu õkonaukianuz, naꞌiki aizii õturuuda õkonaukian. ");
INSERT INTO wapNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Uruu mishiꞌo niꞌi naa umanawun-dinan, mazan õgaru, õawutapaanan naa wuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kaawaꞌoraz doko iki uruu umanawunuꞌo ipai pidan ai. Aizii wuruꞌu imiꞌi baaraꞌaꞌoraz, uruu imiꞌi baara san, naꞌiki ukakuwaapan imiꞌi baaraꞌaꞌo dauꞌu. Wuruꞌu kaawaꞌoraz aokazi iki, ");
INSERT INTO wapNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ukakuwaapan patukapanii naꞌiki paabatapanii dauꞌu aokazi ii, mazan aonaa pidan mishidan zoobaba ukuwaa. ");
INSERT INTO wapNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kanom mishidan an ukuwaa, naꞌapaꞌo idaꞌan ukainaabatan Tominkaru kuwaa mishiin. ");
INSERT INTO wapNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wuruꞌu Tominkaru dyuudaniaz, ukowaada Tominkaru paradan, ushaꞌapanum kauꞌan kaimanaimanaꞌo Tominkaru taan uꞌati Kaimanaꞌo Doronaa. ");
INSERT INTO wapNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","WaDaru Tominkaru marainapanii pauDani, naꞌiki utaa ipai daunuudaꞌu aimaakan ukaꞌu iti. ");
INSERT INTO wapNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pidan mishidaꞌo uDani, kainaꞌaꞌo karikaonanuꞌo kakupa-karu uꞌidaꞌa. Aizii pidan aonaꞌoraz umishidan uDani, aonaa naꞌapainim nii uikodan karikaonanuꞌo kakupa-karu, mazan karikaonanuꞌo nii ubaiatan Tominkaru toꞌoran. ");
INSERT INTO wapNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Phariseenao abataꞌa naa kuwai Jesus zaamatin-kidan dauaꞌo pidannao paꞌidaꞌati, naꞌiki uchikaawunuuan iriba pidannao, powaꞌa zii ĩiriban John diꞌitiꞌo zaamatinan ai. ");
INSERT INTO wapNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jesus mishi aonaa uchikaawunuupan padamata, soo utominapa-kidaniinao.) ");
INSERT INTO wapNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aizii Jesus abatan idi naꞌapam pidannao kakuwaapan padauꞌu, uruꞌu naa ukiwan Judea Baara iki, Galilee Baara iti. ");
INSERT INTO wapNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Umakopan puꞌu naꞌiti, Samaria Baara anaꞌo nii udobatan. ");
INSERT INTO wapNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aizii udobatapan puꞌu Samaria Baara an, ukaawan donoi iti, Sychar kiaꞌo uꞌuu. Maonapaꞌo naꞌii Jacob taauzonii zakapu paudani Joseph ati. ");
INSERT INTO wapNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Naꞌiaꞌo Jacob kichada-kidauzon pakapoo-kizi nii. Sakitapa kamoo, Jesus mizainan naa kowas pachiꞌikapa-kinaa. Usakanatan maonapa kapoo-kizai ii. ");
INSERT INTO wapNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Utominapa-kidaniinao mako aka donoi iti ĩtoriaꞌanaꞌakan wanyukunui. Upuꞌaꞌa naa Samaria sanaaba waꞌatin okapowaꞌanan naꞌati kapoo-kizai idaꞌati. “Õtuzaꞌazoo wunu,” Jesus kian oꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Pugaru Jew, aizii õgaru Samaria sanaaba, mazan kandii nii pupishaan wunu õꞌai?” okian uꞌati. (Onaꞌapan uꞌati, ushaꞌapanum kauꞌan aonaꞌo turuu Jewnao kaiwaan aimaakan Samaria Baara sannao kaiwaanii.) ");
INSERT INTO wapNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus kian oꞌati, “Puaitapan an mani kanom Tominkaru taaꞌazoonii, naꞌiki kanom wuruꞌu pishaaꞌoraz pugaru wunu dauꞌati, pupishaa mani uruu padamata naꞌiki utaa mani puꞌati wunu kakupa-kinai, aonaꞌo umaarauzon paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Okian uꞌati, “Aonaa kanom idaꞌan mazan pukapotan wunu, ushaꞌapanum kauꞌan kapoo-kizai idaꞌa munapo wunu. Naꞌikim nii puꞌitiiman puikodan wunu aonaꞌo umaarauzon? ");
INSERT INTO wapNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wadokozu-daun Jacob kichadanii wuruꞌu wakapoo-kizi niꞌoraz. Uruu, udainao naꞌiki ĩꞌuzanao, naꞌikiꞌo ĩtuzan wunu kapam. Powaꞌaꞌo zii mooko pugaru umanawunun Jacob ai?” ");
INSERT INTO wapNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus kian, “Pidan tuzaꞌo wunu diꞌoraꞌa kapoo-kizai diꞌikiꞌi, maaradakoꞌo nii uruu koshan; ");
INSERT INTO wapNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","mazan pidan tuzaꞌo paꞌan õtaan niꞌoraz wunu, aonaa naꞌapainim nii umaaradakouzon. Õtaan niꞌoraz wunu, unaꞌan niꞌi naa uꞌidaꞌa, ikodaꞌo nii wunu maꞌozakaꞌoraz ununudapan, taaꞌo niꞌoraz karikaonanuꞌo kakupa-karu.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aizii okian uꞌati, “Aushaa putaa mooko uruu wunu õꞌati, aonaa kizi õmaaradakouzon, naꞌiki aonaa kizi õkapowaꞌanan powaꞌa daꞌatiꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus kian oꞌati, “Pudapadanaka pudaiaru naꞌiki puwaꞌati utuma daꞌatiꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Aonaꞌo mazan õkaudaiarun,” okian uꞌati. Jesus kian oꞌati, “Mishiꞌo kaiwuruꞌu, ‘aonaꞌo õkaudaiarun,’ pukianuz. ");
INSERT INTO wapNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pugaru, bakaꞌiauꞌoraꞌa naa pumazidan. Aizii kaiꞌoraz pumin-mashaapan, aonaa mishi pudaiaru mani uruu, ukauꞌan mishiꞌo kaiwuruꞌu puparadanuz.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Okian uꞌati, “Aizii õaitapa! Pugaru Tominkaru prophetin! ");
INSERT INTO wapNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Waunao Samaria Baara sannao dokozu-daunnao, diꞌoraꞌa midukuo idaꞌaꞌo ĩaida-kidauzon pataapan Tominkaru umanawunuꞌo nii. Mazan unao Jewnao kian, Jerusalem ii paꞌan Tominkaru aipan pidannao aida-kidan ĩtaapan uruu umanawunuꞌo nii.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aizii Jesus kian oꞌati, “Pumishida õparadan, kainaꞌiki kamoo waꞌatin, uruu dono aonaꞌo nii pidannao nyukunuitapan diꞌoraꞌa midukuo oo Jerusalem, ĩaida-kidaꞌazon an pataapan Tominkaru umanawunuꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Unao Samaria Baara sannao, aonaa uaitapan kaimanaiman kanom wuruꞌu utaapaniaz umanawunuꞌo nii; waunao Jewnao, waaitapa paꞌan kanom wuruꞌu wataapaniaz umanawunuꞌo nii. Ushaꞌapanum kauꞌan Jewnao atiꞌo wuruꞌu pidan kazannaatin-kinaa kainaabata-kaoaz. ");
INSERT INTO wapNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mazan kainaꞌiki paꞌinaꞌo kamoo waꞌatin, aizii uruu kamoꞌo naa wuruꞌu kaawaꞌoraz! Uruu dono, pidannao mishiꞌoraz manawun ĩtaapan Tominkaru umanawunuꞌo nii, ĩtaainan nii uꞌati padoronaa ii, naꞌiki mishiꞌo idaꞌanaꞌo nii. Naꞌapainao wuruꞌu Tominkaru aipaniaz papidanannao nii. ");
INSERT INTO wapNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tominkaru uruu Doronai. Pidan taapaꞌoraz uruu umanawunuꞌo nii, marii utukapa-kidanuz Tominkaru ati, pataainan idaꞌan padoronaa ii naꞌiki mishiꞌo idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aizii Samaria sanaaba kian Jesus ati, “Õaitapanii kainaꞌiki Messiah waꞌatin. (Christ kiaꞌo kapam wuruꞌu.) Ukaawan dono, ukainaabatan nii ipai aimaakan waꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Udaunaꞌan Jesus kian, “Õgaru uruu. Uruu paradinaꞌoraz puꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Upuꞌaꞌa naa Jesus tominapa-kidaniinao kaawaꞌakan donoi iki; tuukii ĩdiꞌitinpan ĩtukapan idi ukadakotinan zunaaba tuma. Mazan aonaa naꞌiaꞌoram kian oꞌati, “Kanom puaipan uꞌai?” oo “Kandii niꞌo pukadakotinan otuma?” aonaa ukian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Uruꞌu naa owaꞌakaꞌakan pawunun kinnaa, okiwaꞌakan naa donoi iti. Naꞌiaꞌa naa okakuwaapan pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aushaa uwaꞌati, utukapanaka pidan kaidiꞌiaꞌa, ukowaadaꞌaka õꞌati ipai õshaꞌapatauzonii kida. Uruꞌu naa shaꞌa Christ?” okian. ");
INSERT INTO wapNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Uruꞌu naa pidannao makon donoi iki, ĩtukapaꞌanan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Upuꞌu Jesus tominapa-kidaniinao dapadautan uruu, “Tiichaa, puaroopaꞌa naa zii!” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mazan Jesus kian ĩꞌati, “Õgaru kainaꞌa wanyukunui õnikan niꞌo, aonaꞌoraz unao aitapan udauꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Uruu idi utominapa-kidaniinao pishautaakan, “Pidan naꞌakaniꞌi naa shaꞌa uwanyukunuu nii?” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus kian ĩꞌati, “Õwanyukunuu paꞌan wuruꞌu õshaꞌapatanuz dyuudaꞌo õgaru aiapanii õshaꞌapatan, atii õipaianuzu. ");
INSERT INTO wapNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Karikaonan daꞌi puabatan pidan kian: ‘Kainaꞌiki 4 kauzu, udaunaꞌan paoribai aka karaoda-kao.’ Mazan õkian uꞌati, uawunuapa kaimanaiman zakapu kawanaꞌati kida. Dyuuaꞌa naa paoribai aka, turuaꞌa naa ukaraoda-kao! ");
INSERT INTO wapNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aizii wuruꞌu karaodapainaouz kawinipinaata-kaoaꞌa naa ĩdyaun. Ĩkaraodapaniinao baokopata-kao karikaonanuꞌo kakupa-karu diꞌiti. Paowaꞌoraz paoribai uuda, naꞌiki karaodaꞌoraz paoribai aka baokopaꞌo nii ĩkonaukian. ");
INSERT INTO wapNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Mishiꞌo wuruꞌu kiauzo-karuz kaikapaꞌa: ‘Baudaꞌapaꞌo pidan paowan, baꞌoran pidan karaodan.’ ");
INSERT INTO wapNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Õdyuudan ukaraodapaꞌanan paoribai aka zakapu kawanaꞌati, aonaa ukaudinauzon naꞌii padamata; baꞌorainao kowas baiaapanii unao uaꞌii dadaraꞌo kaudin-kizai, aizii unaouꞌu naa naubaapa ĩkaudin-kizi.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Iriba Samaria Baara sannao, mashaapainaouz donoi ii mishidan Jesus, zunaaba kian idi, “Ukowaada õꞌati ipai aimaakan õshaꞌapatauzonii.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aizii Samaria Baara sannao kaawainaouz uꞌidaꞌati, ĩpishaan uruu tuukii, “Waaipan punaꞌaꞌakan watuma,” ĩkian uꞌati. Uruu idi dyaꞌutam kamoo Jesus naꞌiaꞌakan ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iriba baokoinao mishidan ĩabatan idi Jesus kuwaa, ");
INSERT INTO wapNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","naꞌiki ĩkian zunaaba ati, “Aizii wamishida, aonaa pukowaadan idi mani waꞌati, mazan waabatan idi sariapa uruu diꞌiki. Aizii waaitapa uruu mishi wuruꞌu kazannaataꞌo niꞌoraz ipai pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Unaꞌiaꞌakan daunaꞌan dyaꞌutam kamoo, uruꞌu naa Jesus dobatan Galilee Baara iti. ");
INSERT INTO wapNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus kian: “Tominkaru prophetin, aonaa utaapauzo-kao umanawunuꞌo nii pawiizi ii.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilee Baara ikiꞌo pidannao, makonkaꞌo Passover Kamoon dauꞌati Jerusalem ii, ipai ĩtukapan Jesus shaꞌapatanii kida baokopainapa-karu dono naꞌii. Ukauꞌan, Jesus kaawan dono Galilee Baara iti, konaukii pidannao dapaapan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesus kaawan naa koshan donoi Cana ati, Galilee Baara iaꞌoraz, (naꞌiaꞌo tawuruꞌu upanaꞌadan wunu wine nii, kiwiiniꞌo dono.) Aizii uruu dono Capernaum ii, kainaꞌaꞌo wiizai zowaunaa karinaꞌo udani daonaiora. ");
INSERT INTO wapNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Uabatan idi kainaꞌa Jesus kaawan Judea Baara iki Galilee ati, uruꞌu naa umakon Jesus diꞌiti. Tuukiaꞌo idaꞌan upishaan Jesus, “Pumako õtuma Capernaum iti pukakuda kizi õdani; maonapaꞌoraꞌa naa umawakan kowas kaiwuruꞌu!” ");
INSERT INTO wapNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus kian uꞌati, “Aonaan an unao tukapan umanawun kidaꞌo aimaakan shaꞌapata-kao, aonaꞌo nii umishidan.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aizii pidan karinaꞌoraz udani kian Jesus ati, “Puwaꞌati kadiman õtuma Naobanai, mawakaꞌo niꞌi naa õdani.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus kian uꞌati, “Pukiwaꞌa naa powaa iti, kakudaꞌa naa pudani!” Umishida Jesus paradan, uruu idi ukiwaꞌakan naa powaa iti. ");
INSERT INTO wapNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dunapo ii zii upoitorunao ikodapan uruu. Ĩkian uꞌati, “Kakudaꞌakaꞌa naa pudani.” ");
INSERT INTO wapNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Uruꞌu naa upishaan ĩdyaun, “Naꞌiam dii kamoo ukakudan?” “Munumun, masakaudaꞌu kamoo daawadatan, uruu umada wadidin,” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Udaru aitapa naꞌaꞌo kamoo wuruꞌu, “Kakudaꞌa naa pudani!” Jesus kianuz uꞌati. Ukauꞌan tuukii umishidan Jesus, naꞌiki baokopa udapu ainao pidannao mishidan kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uruu itamautannaa Jesus shaꞌapatan umanawunuꞌo aimaakan, pakaawan dono Galilee Baara ati koshan, Judea Baara iki. ");
INSERT INTO wapNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Udaunaꞌan Jesus makon Jerusalem iti Jewnao baokopainpauzon kamoo dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem awauribanaa idaꞌa, kainaꞌa paniinom, Kaznizo Paniinomizinaa kiaꞌo udakota-kao. Maonapa udazabaꞌa kainaꞌa wunu baoko, Bethzatha kiaꞌo udakota-kao Jewnao paradan idaꞌan. Maonapa wunu baoko danoma an, kainaꞌa bakaꞌiaudaꞌu kabaun dikin-dinapa-kizai kida. ");
INSERT INTO wapNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aizii dikin-dinapa-kizai kida nazo ii, kainaꞌa iriba karinainao washatinpan kida, ishaawunnao naꞌiki pabiꞌinaaka machiꞌika-kainao kaduz kida. Ipai ĩdyaun ĩzaudapan wunu koboinan. ");
INSERT INTO wapNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Panaadon kidaꞌo daꞌi angel kaawauzon, naꞌiki ukoboan nii wuruꞌu wunuz. Karinaa-ziiwa kiwiiniꞌo udamotinan ubaoko iti, ukoboo-kao daunaꞌan aka, uruu kakudaꞌo nii shaꞌapaꞌoram karikaonan parinaa ai. ");
INSERT INTO wapNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kainaꞌa karinaapaꞌo pidan naꞌii kapatiꞌoraꞌa naa, ubaiatinan 38 wunu. ");
INSERT INTO wapNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus tukapan uruu, uaitapa kotuaꞌoraꞌa naa ukarinaapan. Jesus kian uꞌati, “Puaiapa pukakudan?” ");
INSERT INTO wapNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Karinaapaꞌo kian uꞌati, “Aonaa pidan kaminkaꞌutaꞌo nii õgaru, õkaawa kizi wunu baoko iti ukoboo-kao dono. Õtiwainaꞌakan donoꞌo naa õmakon naꞌiti, baꞌoran pidan kaawaꞌakaꞌa naa kiwiin õꞌai.” ");
INSERT INTO wapNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sariapa Jesus kian uꞌati, “Aushaa, pukadishita! Pumakoꞌo naa, punaꞌakaꞌa naa puwashatinapa-kizi.” ");
INSERT INTO wapNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sariapa umaꞌozakaꞌakan. Ukadishitaꞌakan, uzaamataꞌakan pawashatinapa-kizi, naꞌiki uchiꞌikaꞌakan naa. Aizii uruu dono, Sookapa-karu Kamoon wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Uruu idi Jewnao zowaunaanao kian pidan kakuda-kariwai ati, “Aizii Sookapa-karu Kamoon. Pudikintapan wakakinaorinaa wuruꞌu punaꞌakanuz puwashatinapa-kizi.” ");
INSERT INTO wapNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mazan ukian ĩꞌati, “Pidan kakudaꞌoraz õgaru, ukian õꞌati, ‘Pumako, punaꞌakaꞌa naa puwashatinapa-kizi.’” ");
INSERT INTO wapNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naꞌiki ĩpishaan uruu, “Kanom mooko wuruꞌu dyuudaꞌoraz pumakon naꞌiki punaꞌakan puwashatinapa-kizi?” ");
INSERT INTO wapNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mazan aonaa uaitapan kanom wuruꞌu kakudaꞌoraz paugaru, ushaꞌapanum kauꞌan iribaꞌo pidannao uruu dono naꞌii, naꞌiki kadiman kapam Jesus makoꞌokan ĩbii an. ");
INSERT INTO wapNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Uruu daunaꞌan, Jesus ikodan naa uruu Tominkaru Dapu ii. Ukian uꞌati, “Puabata, aizii maꞌozakaꞌa naa pugaru; ukauꞌan marinaꞌa naa oiaꞌo, panaadon kashaꞌoraꞌo aimaakan shaꞌapan powaꞌa zii puꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Uruꞌu naa umakoꞌokan, ukakuwaapaꞌanaꞌakan naa Jewnao zowaunaanao ati. Ukian ĩꞌati, “Jesus karikaonan tawuruꞌu kakudaꞌoraz õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesus shaꞌapatan idi naꞌapaꞌo aimaakan Sookapa-karu Kamoon dono, uruu dikin ii Jewnao dadaradan naa amazada uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Uruu idi Jesus kian ĩꞌati, “Õdaru, ipai kamoo ukaminkaꞌuupan pidannao. Õgaru naꞌapaꞌo kapam uruu kawan.” ");
INSERT INTO wapNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesus kian dikin ii naꞌapa, powaꞌa zii Jewnao zowaunaanao dawatan naꞌapam pazowii-kida-kinaa nii uruu. Aonaa soo uwazootapan idi mani ĩsookapauzon kamoon kakinaorinaa, mazan udakotan idi kapam Tominkaru paDaru nii, uruu idaꞌan upatumaakadinan Tominkaru tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Uruu idi Jesus kian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz, aonaa Tominkaru Dani shaꞌapatan aimaakan paaipan ati, soo ushaꞌapata patukapanii paDaru shaꞌapatan. Kanom uDaru shaꞌapatanii, naꞌapa kapam uDani shaꞌapatan. ");
INSERT INTO wapNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ÕDaru marainapanii pauDani naꞌiki utukapa-kida uꞌati ipai pashaꞌapaapanii. Naꞌiki utukapa-kidan nii uꞌati aimaakan powaꞌaꞌo zii umanawunun kida, unao diꞌitinapa-kinaa nii. ");
INSERT INTO wapNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Naꞌapa õDaru kadishita-kidan kawan mawakainao naꞌiki utaan kakupa-karu ĩꞌati, naꞌapaꞌo manawun uDani taan kakupa-karu naꞌiaꞌoram ati utaaꞌazon. ");
INSERT INTO wapNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ÕDaru, aonaa ukabootan pidan oiaꞌo diꞌiti oo kaimanaꞌo diꞌiti. PauDani ati paꞌan utaan ipai wuruꞌu naꞌapaꞌoraz shaꞌapatin-karu, ");
INSERT INTO wapNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ipai kizi pidannao taapan uDani umanawunuꞌo nii, naꞌapa ĩtaapan kawan uDaru. Mazan pidannao aonaꞌoraz ĩtaapan Tominkaru Dani umanawunuꞌo nii, naꞌapa kapam aonaa ĩtaapan mani uDaru umanawunuꞌo nii wuruꞌu, dyuudaꞌoraz uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mishiꞌo kaiwuruꞌu õkianuz uꞌati: Pidan abataꞌo naꞌiki izoꞌatiꞌo õkuwaa, naꞌiki mishidaꞌo dyuudaꞌoraz õgaru, kainaꞌaꞌoraꞌa naa karikaonanuꞌo kakupa-karu uꞌidaꞌa wuruꞌu. Aonaꞌo nii upatakaꞌuta-kao paꞌoian dikin ii. Aonaa powaꞌa mawakapa-karu diꞌitanpuꞌoraꞌa naa mani uruu, mazan kainaꞌaꞌoraꞌa naa uruu idaꞌa karikaonanuꞌo kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mishiꞌo kaiwuruꞌu õkianuz uꞌati: Kainaꞌiki kamoo waꞌatin, aizii uruꞌu naa wuruꞌu kaawaꞌoraz. Uruu donoꞌo niꞌi naa mawakainao abatan Tominkaru Dani paradan. Pidan abataꞌo naꞌiki izoꞌatiꞌo Ukuwaa uruu kakupaꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","WaDaru diꞌikiꞌo kakupa-karu ikoda-kao. Naꞌapaꞌo manawun waDaru toman pauDani, uruu diꞌiki kapam kakupa-karu ikoda-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","“WaDaru kiiniꞌi naa pauDani ati, ‘Turuaꞌa naa aizii pubuutan pidannao,’ ushaꞌapanum kauꞌan uruu paꞌan wuruꞌu Daonaiora Aokazi Ikiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Aonaa umaaitapakaꞌanaꞌa õkuwaa! Mishiꞌo, kainaꞌaꞌo nii kamoo kaawan, naꞌiki uruu dono ipaiꞌo nii pabaaranaa iki kida mawakainao abatan Uparadan. ");
INSERT INTO wapNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pidannao shaꞌapataꞌo kaimanaꞌo, ĩkadishitan nii naꞌiki karikaonanuꞌo nii ĩkakupan; mazan pidannao shaꞌapataꞌo oiaꞌo, ĩkadishitan nii naꞌiki patakaꞌuta-kao nii ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Aonaa turuu õshaꞌapatan aimaakan õaipan ati karikaonan. Õbuutan pidannao soo Tominkaru aipan kawanaꞌati manawun. Ukauꞌan sakitapaꞌo paꞌan wuruꞌu õbuutanuz pidannao ĩshaꞌapainpan kawanaꞌati. Ushaꞌapanum kauꞌan, aonaa õtiwaan õshaꞌapatan aimaakan õaipan ati karikaonan, soo dyuudaꞌoraz õgaru aipan kawanaꞌati õshaꞌapatinan. ");
INSERT INTO wapNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Õkakuwaapan an mani õdauꞌu, õꞌidaꞌa karikaonan, aonaa turuu õparadan mishida-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mazan kainaꞌa baꞌoran kakuwaapaꞌo õdauꞌu, õaitapa mishiꞌo wuruꞌu uparadanuz õdauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Unao, udyuudan pidannao John Chikaawunuupauzo diꞌiti. Uruu dono ukowaada mishiꞌo õdauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aonaa õaipan manawun mani pidan kakuwaapan õdauꞌan kaiwuruꞌu; mazan õkowaadan unao ati kaikapa kidaꞌoraꞌa, turuu kizi ukazannaatinan. ");
INSERT INTO wapNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John uruu lamp kawanuꞌo, maꞌozakaꞌoraz ukanadapan; aizii unao masakaudaꞌu karikaonan ukonaukii-kidan ukanadapanuzu. ");
INSERT INTO wapNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Powaꞌa zii John kuwaa ai umanawunun wuruꞌu kakuwaapaꞌoraz õdauꞌu: wuruꞌu õshaꞌapatanii kidaz õdaru aipan kawanaꞌati, naꞌiki wuruꞌu Uaipaniaz zii õshaꞌapatan, ĩnao wuruꞌu kakuwaapaꞌoraz õdauꞌu. Naꞌiki õshaꞌapatanii kida ukainaabata õdaru wuruꞌu dyuudaꞌoraz õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naꞌiki õdaru kapam kakuwaapaꞌo õdauꞌu. Unao, aonaa uabatauzon uparadan oo utukapauzon uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aonaa uzaamatan Ukuwaa, ushaꞌapanum kauꞌan aonaa unao mishidan õgaru wuruꞌu Udyuudaniaz. ");
INSERT INTO wapNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Utominpan padamata kaimanaiman saada-kariwaiz kida Tominkaru Paradan dauꞌu, uzauda-kidan uruu idaꞌaꞌo nii unao ikodan karikaonanuꞌo kakupa-karu, mazan uruu kida kakuwaapaꞌoraz õdauꞌu! ");
INSERT INTO wapNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mazan upuꞌu aonaa uzaamatinaꞌazon õꞌidaꞌati, turuu kizi uzaamatan karikaonanuꞌo kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Õshaꞌapatan aimaakan aonaa õaipan idiꞌo mani pidannao dakotan õgaru umanawunuꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mazan õaitapa unao, aonaa naꞌiaꞌoram marainpan Tominkaru kaimanaiman. ");
INSERT INTO wapNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Õgaru, õkaawan õdaru uu idaꞌanaꞌo, mazan unao, aonaa unaubaan õgaru. Mazan baꞌorainao kaawan an paaipan ati karikaonan, ĩnaouꞌo nii paꞌan unaubaapa. ");
INSERT INTO wapNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Upaonarunao naubaan an unao, tuukii ukonaukian, mazan aonaa zoobaba ushaꞌapatan aimaakan Tominkaru baudaꞌapauzon naubaa-kinaa nii unao. Ukauꞌan, naꞌapam nii mooko umishidan uruu? ");
INSERT INTO wapNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Aonaa õgaruꞌo nii mani wuruꞌu kiaꞌo niꞌoraz õdaru ati, ‘oiaꞌo ĩnao,’ unao dauꞌan. Kainaꞌa Moses saadauzonii, uruꞌo nii paꞌan wuruꞌu ‘oiaꞌo ĩnao,’ kiaꞌo niꞌoraz, unyukunuu Moses saadanii dauꞌatin puꞌu padamata. ");
INSERT INTO wapNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Umishidan an mani mishi manawun Moses saadanii, umishida mani padamata õgaru. Ushaꞌapanum kauꞌan, õgaru dauaꞌo wuruꞌu usaadaniaz. ");
INSERT INTO wapNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mazan umamishidakan puꞌu Moses saadauzonii kakinaorii, naꞌapam nii dii umishidan õparadan?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aizii udaunaꞌan Jesus taraukan Galilee Karishiiz baza iti, (Tiberias Karishiiz, kiaꞌo udakota-kao kapam.) ");
INSERT INTO wapNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Iriba pidannao daꞌanpan uruu ĩtukapan idi ushaꞌapatan umanawun kidaꞌo aimaakan, ukakudanuz karinainao. ");
INSERT INTO wapNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus makon patominapa-kidaniinao tuma naawazi paawa iti, naꞌii usakanatan ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aizii udono, maonapataꞌo Jewnao Passover Kamoon. ");
INSERT INTO wapNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus awunuudanaan, utukapa iriba pidannao waꞌatin paꞌidaꞌati. Sariapa ukian Philip ati, “Naꞌikim nii watorian wanyukunui wapaa-kinaa nii ipai wunaouꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesus pishaanuz Philip, utiwaa-kidapan karikaonan uruu, mazan Jesus, uaitapaniꞌi naa naꞌapam nii pashaꞌapainpan. ");
INSERT INTO wapNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip kian uꞌati, “8 kauzu pidan kaudinan winipinaa, aonaa turuu utorian wunao aroapa-kinaa niꞌi, utaa-kao puꞌu mani masakaudaꞌu sodi kida.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrew, Simon Peter inawuzuz, uruu kapam Jesus tominapa-kidanii. Ukian Jesus ati, ");
INSERT INTO wapNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kainaꞌa koraidaonaa diidaꞌaꞌa, kainaꞌa uꞌidaꞌa bakaꞌiaudaꞌu barley-baꞌi naꞌiki dyaꞌutam kopaunao sodi kida. Mazan naꞌapam nii mooko masakaudaꞌu sodiꞌo wanyukunui turuan iribaꞌo manawun pidannao ati?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus kian patominapa-kidaniinao ati, “Marii pidannao sakanatan.” Uruꞌu naa ĩdyuudan pidannao sakanatan naa. Pinidi baawu wuruꞌu naꞌiaꞌoraz amazada. Aizii daonaioranao uikoda mani 5000 ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Uruꞌu naa Jesus zaamatan bread naꞌiki utoriinapa-kidan naaz Tominkaru ati, “Kaimanaꞌo pugaru Tominkaru, putaan idi wanyukunui.” Uruu daunaꞌan udyuudan naa utaabiꞌii-kao sakanatapainao ati, aizii kopau naꞌapa kapam unaꞌapatan. Ipai pidan aroopan abaapa kida. ");
INSERT INTO wapNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aizii ĩturuudan daunaꞌan paaroopan, Jesus kian patominapa-kidaniinao ati, “Aizii uzawada wanyukunui waꞌakun, aonaa uwakudaꞌanaꞌaz.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Uruu idi bakaꞌiaudaꞌuꞌoraz barley-baꞌi waꞌakun diꞌiki, ĩpaidada 12 dazowan kida. ");
INSERT INTO wapNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aizii pidannao tukapan idi Jesus shaꞌapatan umanawunuꞌo aimaakan, sariapa ĩkian, “Diꞌi naa wuruꞌu Prophet, saada-kariwai Tominkaru paradan kaunamunaataniaz uwaꞌatin nii.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus aitapan idi pidannao zaamataꞌazon naa paugaru King nii aonaan puꞌu unyukunuu naꞌapan, uruu idi umakoꞌokan ĩꞌai pabaꞌorantin koshan midukuo iti. ");
INSERT INTO wapNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Uruu wachuupunin, Jesus tominapa-kidaniinao makon naa Galilee Karishiiz iti. ");
INSERT INTO wapNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ĩzaamatan kanawa naꞌiki uruꞌu naa ĩtaraukan Capernaum iti. Marutaꞌakaꞌa naa amazada, aonaa zii Jesus kaawan ĩꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aizii uruu wamarutan idaꞌa, maꞌozakaꞌo awaru kaawan naꞌiki kichanaꞌiki-kii utoman wunu paran. ");
INSERT INTO wapNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jesus tominapa-kidaniinao pooratan pakanawan naꞌapaꞌo bii an, 3 oo 4 mile umunapon. Uruꞌu naa ĩtukapan Jesus waꞌatin, wunu paawa an uchiꞌikapan. Uwaꞌatin, atii umaonapatan ĩkanawan idaꞌati. Tuukii ĩtarian uꞌai. ");
INSERT INTO wapNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mazan upuꞌaꞌa naa uparadan ĩꞌati, “Manaꞌa utariaꞌanaꞌa! Õgaru wuruꞌu!” ");
INSERT INTO wapNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Uparadan daunaꞌan, ĩaipan naa upaidinan patuma kanawa zoꞌiti, mazan mashaꞌapakiaka ĩkaawaꞌakan naa pamako-kizi iti. ");
INSERT INTO wapNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Baꞌoran chaapiꞌiki, pidannao karishii danoma iaꞌoraz ĩwaꞌakinan, ĩaitapanii naꞌaꞌo soo baudaꞌapa kanawa karikaonan. Naꞌiki ĩaitapa kapam aonaa Jesus makon patominapa-kidaniinao tuma uruu kanawa zoꞌan, soo ĩnao karikaonan mako. ");
INSERT INTO wapNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mazan kainaꞌa baꞌoran kanawa kida kaawan Tiberias iki, maonapa Naobanai paa-kizi ii pidannao, utoriinapa-kidan daunaꞌan wanyukunui. ");
INSERT INTO wapNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aizii pidannao tukapan idi aonaa Jesus nii, naꞌiki aonaa utominapa-kidaniinao nii kapam, uruꞌu naa ĩpaidinan kanawa kida zoꞌiti, naꞌiki ĩmakon naa Capernaum iti, ĩdawatinaꞌanan naa Jesus dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ĩikoda Jesus karishii baza iaꞌa naa. Uruꞌu naa ĩkian uꞌati, “Tiichaa, naꞌapainim diꞌi naa pukaawan daꞌatiꞌi?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus kian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Udawatinan õdauꞌu soo uaroopan idiꞌo abaapa karikaonan, aonaa utukapan idiꞌo mani õshaꞌapatan umanawun kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aonaa ukaudinaꞌanaꞌa patakaꞌuinauzo wanyukunui dauꞌati. Ukaudin paꞌan wanyukunui dauꞌati karikaonanuꞌoraz kakupa-karu uꞌidaꞌan. Uruu wuruꞌu Daonaiora Aokazi Ikiꞌo taan niꞌoraz unao ati, ushaꞌapanum kauꞌan Tominkaru tukapa-kida mishi panyukunuu kaimanan uꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aizii ĩkian uꞌati, “Kanom mooko manawun Tominkaru aiapanii washaꞌapatan?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus kian ĩꞌati, “Tominkaru aipan soo umishidan õgaru, padyuudaniaz.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Naꞌiki ĩkian uꞌati, “Kandii mooko umanawunuꞌo aimaakan puaida-kidan nii waꞌati, wamishida-kinaa nii wuruꞌu puparadanuz? ");
INSERT INTO wapNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wadokozu-daunnao, ĩnikauzonii wanyukunui, ‘manna’ kiaꞌoraz udakota-kao, mapidantakaꞌo amazada ii. Naꞌapa usaadinpan Tominkaru Paradan idaꞌa, ‘Utaanii ĩꞌati ĩnikan nii aokazi ikiꞌo wanyukunui.’” ");
INSERT INTO wapNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus kian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Aonaa Moses mani wuruꞌu taaꞌoraz aokazi ikiꞌo wanyukunui uꞌati. Õdaru paꞌan wuruꞌu taaꞌoraz aokazi ikiꞌo wanyukunui, mishiꞌoraz kakupa-kinai. ");
INSERT INTO wapNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wanyukunui, Tominkaru dyuudaniaz aokazi iki, uruu paꞌan taaꞌoraz kakupa-kinai manawun, pidannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sariapa pidannao kian uꞌati, “Naobanai! Putaa mooko waꞌati uruu wanyukunui, naꞌiki ipai kamoo paꞌi putaa waꞌatiz!” ");
INSERT INTO wapNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus kian ĩꞌati, “Õgaru wuruꞌu wanyukunui kakupa-kinaiz. Naꞌiaꞌoram pidan zaamatinaꞌo õꞌidaꞌati naꞌiki mishidaꞌo õgaru, aonaꞌo nii uzamaziizon naꞌiki aonaꞌo nii umaaradakouzon. ");
INSERT INTO wapNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Mazan õkii shaꞌatii uꞌati, utukapaꞌa naa padamata õgaru, mazan upuꞌu aonaa umishidan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ipai pidan õdaru taaniaz õꞌati, zaamatinaꞌo nii õꞌidaꞌati. Naꞌiki pidan wuruꞌu zaamatinaꞌoraz õꞌidaꞌati aonaa naꞌapainim nii õkashanauan. ");
INSERT INTO wapNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ushaꞌapanum kauꞌan õwaꞌatin daꞌatiꞌi aokazi iki, õshaꞌapataꞌanan dyuudaꞌoraz õgaru aipan kawanaꞌati õshaꞌapatan. Aonaa õwaꞌatin õshaꞌapataꞌanan aimaakan õnyukunuu aipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Naꞌiki dyuudaꞌoraz õgaru, aonaa baudaꞌapa uaipan õwaziwaan pidan pataaniinaouz õꞌati. Mazan uaipan paꞌan õkadishita-kidan ĩdyaun naꞌiki õtaan ĩkakupa-kinaa nii, Tominkaru Ainaa dono. ");
INSERT INTO wapNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ÕDaru aipan ipai pidan tukapaꞌoraz naꞌiki mishidaꞌoraz uDani, zaamatan karikaonanuꞌo kakupa-karu; naꞌiki õkadishita-kidan nii ĩdyaun karikaonanuꞌo kakupa-karu diꞌiti Tominkaru Ainaa dono.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Uruꞌu naa Jewnao kadakotin-kidan uruu naꞌiki ĩtoꞌoran naa uꞌati, ukian idi, “Õgaru wuruꞌu wanyukunui aokazi ikiꞌoraz kaawan.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ukauꞌan ĩkian paꞌatiaaka, “Aonaa mooko Jesus mani uruu, Joseph daniz? Waaitapanii naꞌapain udaronao! Naꞌapa diꞌi naa mooko kaiwuruꞌu ukianuz, ‘Õgaru aokazi ikiꞌo õwaꞌatin?’” ");
INSERT INTO wapNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus kian ĩꞌati, “Aonaꞌa naa ukadakoinpaꞌanaꞌa naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Õdaru wuruꞌu dyuudaꞌoraz õgaru; naꞌiki aonaa turuu pidan zaamatinan õꞌidaꞌati, soo õdaru minziiwatan dono uruu uzaamatin-kinaa nii õꞌidaꞌati. Naꞌiki õkadishita-kidan nii uruu Tominkaru Ainaa dono. ");
INSERT INTO wapNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Naꞌapa kotuaꞌo prophet saadauzonii kian, ‘Ipaiꞌo nii Tominkaru tominapa-kidan pidannao.’ Ukauꞌan kanom dyautaꞌo unyukunuu õdaru paradan dauꞌati, naꞌiki tominpaꞌo uruu diꞌiki, zaamatinaꞌo nii õꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Mazan aonaa naꞌiaꞌoram pidan tukapauzon õdaru, soo wuruꞌu waꞌatiꞌoraz Tominkaru diꞌiki, uruu paꞌan tukapaꞌoraz õdaru. ");
INSERT INTO wapNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mishiꞌo kaiwuruꞌu õkianuz: Naꞌiaꞌoram pidan mishidaꞌo, zaamataꞌoraꞌa naa karikaonanuꞌo kakupa-karu wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Õgaru wuruꞌu wanyukunui kakupa-kinaiz. ");
INSERT INTO wapNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Udokozu-daunnao nikauzon puꞌu ‘manna’ mapidantakaꞌo amazada diꞌii, upuꞌu ĩmawakan. ");
INSERT INTO wapNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mazan diꞌi naa paꞌan wuruꞌu wanyukunuiz, kaawaꞌoraz aokazi iki, pidan nikaꞌoraz uruu, karikaonanuꞌo nii ukakupan. ");
INSERT INTO wapNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Õgaru paꞌan wuruꞌu wanyukunui, kaawaꞌoraz aokazi iki, taaꞌoraz kakupa-kinai. Pidan nikan an wuruꞌu wanyukunuiz, uruu karikaonanuꞌo nii ukakupan. Wanyukunui õtaan niꞌoraz uꞌati, uruu õdunaa. Uruu õtaaniaz pidannao kakupa-kinaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Uruꞌu naa Jewnao shokorodinan uꞌati naꞌiki ĩkian paꞌatiaaka, “Naꞌapam nii mooko arawu itiiman pataan waꞌati padunaa, wanyukunui nii?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus kian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Umanikakan an Daonaiora Aokazi Ikiꞌo dunaa naꞌiki umatuzakan an uizain, aonaꞌo kakupa-karu nii uꞌidaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mazan kanom aroopaꞌo õdunaa dauꞌu naꞌiki tuzaꞌo õizain, uruu karikaonanuꞌo nii paꞌan ukakupan naꞌiki õkadishita-kidan nii uruu Tominkaru Ainaa dono. ");
INSERT INTO wapNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Õdunaa, uruu mishiꞌo wanyukunui naꞌiki õizain mishiꞌo riwunii. ");
INSERT INTO wapNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Naꞌiaꞌoram pidan aroopaꞌo õdunaa dauꞌu naꞌiki tuzaꞌo õizain, uruu zaamatinpaꞌo õꞌidaꞌati, naꞌiki õgaru zaamatinpaꞌo uruu idaꞌati kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Õdaru Tominkaru taapaꞌoraz kakupa-karu, uruu wuruꞌu dyuudaꞌoraz õgaru. Uruu diꞌikiꞌo õikodan kakupa-karu. Ukauꞌan pidan aroopaꞌoraz õdauꞌu, uikodan nii kakupa-karu õgaru diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ukauꞌan diꞌoraꞌa wuruꞌu wanyukunui kaawaꞌoraz paꞌan aokazi iki, aonaa udokozu-daunnao nikauzonii manna kawanuꞌo mani. Ĩnikauzon puꞌu padamata manna, mazan upuꞌu zii ĩmawakan. Mazan pidan aroopaꞌo diꞌoraꞌa wanyukunui dauꞌu, karikaonanuꞌo nii paꞌan ukakupan.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus kakuwaatinanuz kaikapaꞌa, utominapatin-kidan donoꞌo pidannao synagogue ii. ");
INSERT INTO wapNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aizii ĩabatan idi naꞌapaꞌo kuwai, iriba daꞌanapatinainaouz uruu, kian, “Dadaraꞌo manawun ukuwaa. Kanom turuu uabatapan kaiwuruꞌu ukuwaaz?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mazan Jesus, uaitapa naꞌapam patominapa-kidaniinao kadakotin-kidan pakuwaa. Sariapa ukian ĩꞌati, “Ukaziwaa-kida zii õparadan? ");
INSERT INTO wapNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Naꞌapam dii mani ukian utukapan an Daonaiora Aokazi Ikiꞌo sawatinan powaa iti pawaꞌati-kizi iti? ");
INSERT INTO wapNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pudiꞌitapan an soo nanai dauaꞌo karikaonan, uruu mazanuꞌo karikaonan wuruꞌu. Kaimanaꞌo Doronaa paꞌan wuruꞌu kaawa-kidaꞌoraz kakupa-karu. Wuruꞌu õparadan kidaz, unao atiꞌoraz, aonaa nanai dauaꞌo mani, mazan doronai dauaꞌo, naꞌiki ukakupa-kinaa niꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mazan upuꞌu zii kainaꞌa pabiꞌi kida unao aonaa umishidan.” (Jesus aitapanii sariapa patominapa-kidan diꞌikiꞌo ĩdyaun, naꞌiaꞌoram aonaꞌo nii ĩmishidan. Naꞌiki uaitapa naꞌiaꞌoram nii kaakapaa paugaru tarubainao ati.) ");
INSERT INTO wapNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Naꞌiki Jesus kian koshan, “Kaikapaꞌo atiꞌo tawuruꞌu õkianuz uꞌati, aonaa turuu pidan zaamatinan õꞌidaꞌati, soo õdaru Tominkaru naꞌakan dono õꞌidaꞌati ĩdyaun.” ");
INSERT INTO wapNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Naꞌikiꞌoraꞌa naa iriba utominapa-kidaniinao muudinan naa uꞌai, aonaa powaꞌa ĩmakon utuma. ");
INSERT INTO wapNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Uruu idi Jesus kian wunao atiꞌi 12 patominapa-kidaniinaouz, “Unao mani, umuudinan niꞌi naa kapam õꞌai?” ");
INSERT INTO wapNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter kian uꞌati, “Naobanai, kanom diꞌitiꞌo nii mooko wamakon? Pugaru idaꞌa paꞌan parada-karu kida taaꞌoraz karikaonanuꞌo kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Naꞌiki, aizii wamishida naꞌiki waaitapa pugaru umanawunuꞌo, Tominkaru diꞌikiꞌo puwaꞌatin!” ");
INSERT INTO wapNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus kian ĩꞌati, “Õgaru zaamataꞌoraz 12 unao. Mazan baudaꞌapa unao, Satan!” ");
INSERT INTO wapNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Unaꞌapanuz Judas Iscariot dauaꞌo wuruꞌu (Simon Iscariot daniz); uruu 12 tumaꞌo uaitinpan, uruꞌo nii zaamata-kida Jesus. ");
INSERT INTO wapNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Uruu daunaꞌan, Jesus morowautapan naꞌiiꞌaka wiizai kawanaꞌati, Galilee Baara ii kidaꞌoraz. Aonaa uaipan pachiꞌikinan Judea Baara ii aka, ushaꞌapanum kauꞌan Jewnao zowaunaanao zaudapanii uruu naꞌii, ĩaipan pazowiinuzu. ");
INSERT INTO wapNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Naꞌiki uruu dono maonapataꞌo Jewnao baokopainpauzon kamoon, ĩkawiizibatinauzon. ");
INSERT INTO wapNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Uruu idi Jesus inawuzunao kian uꞌati, “Pugaru mani? Kanom nii aonaꞌa naa pumakon Judea Baara iti, abatauzonao pukuwaa tukapa kizi wuruꞌu pushaꞌapaapanii kidaz? ");
INSERT INTO wapNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aonaa naꞌiaꞌoram pidan dizapaꞌo pashaꞌapaapan aimaakan, uaipan an pidannao aitapan kaimanaiman kanom kaduz paugaru. Pushaꞌapaapan an aimaakan, marinaꞌa naa ipai pidannao aitapan!” ");
INSERT INTO wapNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Aizii wuruꞌu uꞌinawuzunaouz, aonaa ĩmishidan uruu.) ");
INSERT INTO wapNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus kian ĩꞌati, “Aonaa zii mazan amazada kaawan õꞌati õmako-kinaa nii naꞌiti. Mazan unao, turuu umakon naꞌapainim karikaonan, uaipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Aonaa kanom dikin ii pidannao toꞌora-kizaitapan unao. Mazan õgaru ĩtoꞌora-kizaitapanii, õkakuwaapan idi ĩꞌoian dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Umakoꞌo naa baokopainapa-kizai iti. Mazan õgaru, aonaꞌo nii zii õmakon, ushaꞌapanum kauꞌan aonaa zii amazada kaawan õꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesus paradan daunaꞌan naꞌapa, unaꞌian zii Galilee Baara ii. ");
INSERT INTO wapNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mazan uꞌinawuzunao makon daunaꞌan baokopainapa-kizai iti, uruꞌu naa Jesus makon kapam. Umakon naꞌiti dizinapa, aonaa kizi pidannao aitapan naꞌiam uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Naꞌii, baokopainapa-kizai ii, Jewnao zowaunaanao dawatinan udauꞌu pidannao bii an, “Aonaa utukapan tawuruꞌu pidanaz?” ĩkian pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Aizii uruu dono, iriba pidannao paradinan mashaudaꞌu kida Jesus dauꞌu. Baꞌorainao kian, “Kaimanaꞌo pidan uruu.” Mazan baꞌorainao kian, “Aonaa kaimanaꞌo pidan mani uruu, soo umariidapan karikaonan pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mazan aonaa naꞌiaꞌoram pidan diwadan paparadan, ĩtarian idi Jewnao zowaunaanao ai. ");
INSERT INTO wapNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aizii 4 kamoꞌo naa baokopainapa-karu, uruu zii Jesus makon Tominkaru Dapu iti. Naꞌiaꞌa naa utominapa-kidan pidannao. ");
INSERT INTO wapNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aizii Jewnao zowaunaanao abatan idi utominapa-kidan pidannao kaimanaiman manawun, tuukii ĩdiꞌitinpan uaitapan dauꞌan. Sariapa ĩkian udauꞌati, “Naꞌapam dii mooko arawu aitapan kaikapaꞌa naa manawunuꞌu? Aonaa naꞌapainim padamata tiichaanao tominapa-kidauzon uruu!” ");
INSERT INTO wapNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus kian ĩꞌati, “Wuruꞌu õkuwaa kidaz aonaa õtomanii mani. Tominkaru, dyuudaꞌoraz õgaru, uruu diꞌikiꞌo wuruꞌu õkuwaa kidaz. ");
INSERT INTO wapNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pidan minziiwataꞌo panyukunuu Tominkaru kaudin-kizi dauꞌati, uruꞌo nii paꞌan aitapa õkuwaa, Tominkaru diꞌikiꞌo, oo õtomanii karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pidan kakuwaapan an paaipan ati karikaonan, utiwaan pamanawun-tinan wuruꞌu. Mazan pidan kakuwaapaꞌo pamanawunutapaꞌazon idi dyuudaꞌo paugaru; uruu kaimanaꞌo pidan, naꞌiki mishiꞌo uparadan. ");
INSERT INTO wapNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mishi, Moses taanii unao ati ukakinaorinaa. Mazan aonaa naꞌiaꞌoram unao mishiꞌo utaapan wuruꞌu kakinaoriiz. Mazan kandii nii uzowiaꞌazon õgaru?” ");
INSERT INTO wapNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aizii pidannao kian uꞌati, “Kainaꞌa oiaꞌo doronai puꞌidaꞌa! Kanom mooko puꞌitiiman zowiaꞌazoo pugaru?” ");
INSERT INTO wapNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus kian ĩꞌati, “Kainaꞌa baudaꞌapa õshaꞌapatanii umanawunuꞌo aimaakan Sookapa-karu Kamoon dono, naꞌiki tuukii unao diꞌitinpan udauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mazan upuꞌu zii, utaapadan udani daonaioranao choota-kao sookapauzo-karu kamoo dono, ĩkainaabatin-kinaa Jewnao nii, Moses taan idi naꞌapaꞌo kakinaorii. (Mazan aonaa Moses diꞌikiꞌo mani wuruꞌu naꞌapaꞌo sakadinanuz, uruu dokozu-daunnao paꞌan wuruꞌu sakadaꞌoraz naꞌapaꞌo.) ");
INSERT INTO wapNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Aizii utaapadan puꞌu udani choota-kao Sookapa-karu Kamoon dono, uruu aonaa kizi unao dikintapan Moses taaniaz kakinaorii. Kandii nii mooko utoꞌoran õꞌati õsaabaan idi paꞌan kaimanaiman pidan nanaa Sookapa-karu Kamoon dono? ");
INSERT INTO wapNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aonaꞌa udiꞌitapaꞌanaꞌa õshaꞌapataniaz aimaakan oiaꞌo nii. Mazan udiꞌitapa wuruꞌu õshaꞌapataniaz aimaakan kaimanaꞌo nii paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kainaꞌa Jerusalem sannao bii ikiinao pidannao, ĩkian Jesus dauꞌati paꞌatiaaka, “Aonaa mooko arawuꞌu mani tawuruꞌu ĩtiwautaniaz pazowii-kidan? ");
INSERT INTO wapNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aizii diꞌi naa uparadinan iribaꞌo pidan ati. Naꞌiki aonaa kanom waꞌatin ĩtowaudaꞌuaꞌanan uruu! Jewnao zowaunaanao aitapaniꞌi naa shaꞌa uruu Christ kii-kizaiz? ");
INSERT INTO wapNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mazan Christ kaawan dono, aonaꞌo nii pidan aitapan naꞌikiꞌoram uwaꞌatin. Mazan arawuꞌu, waaitapa naꞌikiꞌoram uwaꞌatin.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aizii Jesus tominapatin-kidan puꞌu pidannao Tominkaru Dapu ii, ukian diiwaꞌo idaꞌan, “Uaitapanii mooko õgaru naꞌiki naꞌikiꞌoram õwaꞌatin? Aonaa õꞌidaꞌaꞌo mani õwaꞌatin! Dyuudaꞌoraz õgaru, uruu mishiꞌo, naꞌiki uruu diꞌikiꞌo õwaꞌatin. Unao aonaa uaitapauzon uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mazan õgaru õaitapanii uruu, ushaꞌapanum kauꞌan uruu diꞌikiꞌo õwaꞌatin, naꞌiki uruu paꞌan wuruꞌu dyuudaꞌoraz õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Uruꞌu naa ĩaipan pazaamataꞌakan Jesus sariapa naꞌii, mazan aonaa kanom zaamatan uruu, ushaꞌapanum kauꞌan aonaa zii amazada kaawan uzaamata-kinao nii. ");
INSERT INTO wapNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mazan iriba naꞌiainao pidannao mishidan uruu, naꞌiki ĩkian, “Baꞌoran kaawan an, dakotinaꞌo Christ nii, turuu mani mooko ushaꞌapatan powaꞌa zii umanawun kidaꞌo aimaakan arawuꞌu shaꞌapatanii kida aiaꞌa?” ");
INSERT INTO wapNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aizii Phariseenao abatankan naa naꞌapam pidannao kian paꞌatiaaka, mashaudaꞌu padamata Jesus dauꞌan. Uruꞌu naa ĩbaokopatinan faadaanao zowaunaanao tuma, udaunaꞌan ĩdyuudan naa watchmantapainao Tominkaru Dapu ĩzaamatanaka kizi Jesus. ");
INSERT INTO wapNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus kian, “Õnaꞌan nii zii utuma baukapaꞌa naa, udaunaꞌan õkiwan niꞌi naa dyuudaꞌoraz õgaru diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Udawatinan nii õdauꞌu mazan aonaꞌo nii uikodan õgaru. Aonaa turuu unao makon õmakoꞌozoo-kizi iti.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Uruꞌu naa Jewnao zowaunaanao kian paꞌatiaaka, “Naꞌitiꞌoram mani umakoꞌozon, aonaa kizi turuu waikodan uruu? Umakoꞌozon shaꞌa Jewnao diꞌiti, mashaapainaouz Greeknao wiizi ii aka, utominapa-kidaꞌanan Greeknao? ");
INSERT INTO wapNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Naꞌapaꞌoram dauꞌatiꞌo dii wuruꞌu, ‘Udawatinan nii õdauꞌu, mazan aonaꞌo nii uikodan õgaru,’ naꞌiki ‘Aonaa turuu umakon õmakoꞌozoo-kizi iti,’ ukianuz?” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dawuꞌitiiniꞌo kamoo baokopainapa-karuz, uruu umanawunuꞌo manawun kamoo. Uruu kamoo idaꞌa Jesus kadishitan naꞌiki uparadan diiwaꞌo idaꞌan, “Kanom maaradakoꞌo marii uwaꞌatin õꞌidaꞌati, õtaa kizi uꞌati utuzan nii. ");
INSERT INTO wapNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Saada-kariwaiz Tominkaru Paradan kian kawanaꞌati, ‘Kanom mishidaꞌo õgaru, uruu diꞌikiꞌo nii wunu taaꞌoraz kakupa-kinaa shootapan.’” ");
INSERT INTO wapNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus kadakotinanuz, Kaimanaꞌo Doronaa dauaꞌo wuruꞌu. Uruu wuruꞌu taa-karu niꞌoraz mishidainao ati. Uruu dono aonaa zii Kaimanaꞌo Doronaa taa-kao mishidainao ati, ushaꞌapanum kauꞌan aonaa zii Jesus sawata-kao umanawunuꞌo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesus paradan daunaꞌan, iriba abatainaouz uparadan, ĩkian udauꞌan, “Diꞌoraꞌa pidan uruꞌu naa Prophet, uruꞌu naa wazaudapaniaz!” ");
INSERT INTO wapNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Baꞌorainao kian, “Uruꞌu naa Christ!” Mazan baꞌorainao kian, “Aonaa uruu mani wuruꞌu! Galilee Baara ikiꞌo nii mooko Christ waꞌatin? ");
INSERT INTO wapNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Aonaa mooko saada-kariwaiz kida Tominkaru Paradan kian, David Takaan-daunuꞌo nii Christ, naꞌiki ushakatan nii Bethlehem ii, David mashaapauzo-kizi ii?” ");
INSERT INTO wapNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Uruu panaꞌa kida pidannao paradan Jesus dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aizii baꞌorainao, ĩaipan naa padamata pazaamataꞌakan Jesus, marii kizi utaraa-kao, mazan aonaa kanom zaamatan zii uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Uruu daunaꞌan watchmantapainao Tominkaru Dapu (tawuruꞌu dyuuda-kariwainaouz ĩzaamataꞌanan Jesus) ĩkaawan naa powaa ati faadaanao zowaunaanao naꞌiki Phariseenao idaꞌati. Uruꞌu naa ĩkian, “Kandii nii aonaa unaꞌakan uruu waꞌidaꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aizii watchmantapainao kian ĩꞌati, “Aonaa naꞌiaꞌoram pidan paradauzon naꞌapa uruu kawan!” ");
INSERT INTO wapNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Uruꞌu naa Phariseenao kian ĩꞌati, “Upozawata-kidan naa mooko kapam unao kaiwuruꞌu? ");
INSERT INTO wapNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Uabatauzo mooko faadaanao zowaunaanao bii ikiꞌo, oo baudaꞌapa Pharisee mishidaꞌo uruu? ");
INSERT INTO wapNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mazan wuruꞌu daꞌanpainaouz uruu, aonaa ĩaitapan Moses taauzonii kakinaorii dauꞌu. Ukauꞌan Tominkaru patakaꞌutan nii ĩdyaun!” ");
INSERT INTO wapNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Naꞌaꞌo ĩtuma Nicodemus, uruu Pharisee kapam; uruu makonkaꞌoraz Jesus diꞌii kiwiiniꞌo dono zii. Ukian patumainao ati, ");
INSERT INTO wapNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wakakinaorinaa kian kawanaꞌati, aonaa turuu wakabootan pidan oiaꞌo diꞌiti, wamaabatakan uaꞌii zii naꞌapam ukian naꞌiki wamaaitapakan uaꞌii zii kanom manawun wuruꞌu ushaꞌapaapanuz.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aizii ĩkian uꞌati, “Pugaru kapam Galilee Baara san, mishii? Putominpan an Tominkaru Paradan saada-kariwai dauꞌu, putukapan nii, aonaa naꞌapainim nii prophet waꞌatin Galilee Baara iki.” ");
INSERT INTO wapNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Uruu daunaꞌan ipai pidannao kiwaꞌakan kidaꞌa naa padapu iti. ");
INSERT INTO wapNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aizii Jesus, umakon naa Olive Naawa iti. ");
INSERT INTO wapNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Baꞌoran kamoo, wakanadaꞌakan zii ukaawaꞌakan naa powaa ati Tominkaru Dapu ati. Pidannao kaawa-kaawan kidaꞌa naa uꞌidaꞌati. Jesus sakanatan naꞌiki uruꞌu naa utominapa-kidan koshan pidannao. ");
INSERT INTO wapNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Upuꞌu tiichaapauzonao Moses kakinaori dauꞌu naꞌiki Phariseenao kaawa-kidaꞌakan zun, zaamata-kariwai obaꞌorantapan idi. Orooꞌo naa ĩkadishita-kidan pidannao kanaapu ii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Udaunaꞌan ĩkian Jesus ati, “Tiichaa. Diꞌoraꞌa zun ikoda-kariwai odaꞌawupan baꞌoran daiaru tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses taanii kakinaorii kian, zun naꞌapaꞌo, marii ozowii-kao, oboo-kao idaꞌan kuba idi. Aizii pugaru mani, naꞌapam dii pukian naꞌapaꞌo dauꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ĩnaꞌapanuz uꞌati, ĩabataꞌazon karikaonan naꞌiam uparadan panaꞌitin kakinaorii ai, ĩdakoapa-kinaa nii uruu naobanainao kanaapu ii. Mazan Jesus dawukaꞌakan pasakanatapa-kiziꞌi, usaadapaꞌakan pakaꞌu shuwu idi kaatu idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ĩpishautan puꞌu zii uruu, Jesus saabainaꞌakan koshan pasakanatapa-kiziꞌi. Uruꞌu naa ukian ĩꞌati, “Naꞌiaꞌoram pidan unao bii aꞌo aonaa naꞌapainiꞌoram ushaꞌapatan oiaꞌo. Marii uruu kiwiiniꞌo nii boowan oroo.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Udaunaꞌan udawukaꞌakan koshan. Naꞌapa koshan usaadapan pakaꞌu shuwu idi. ");
INSERT INTO wapNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ĩabatan idi naꞌapam Jesus kian paꞌati, baudaꞌapa kida ĩmakon Jesus ai, atii ipai ĩmakon. Tunarunaonao kiwiin ĩmakoꞌokan, udaunaꞌan paꞌinainao, ĩwaꞌakaꞌakan naa Jesus. Aizii wuruꞌu zunaabaz, pakawan zii okadishitapan naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus saabainan pasakanatapa-kiziꞌi koshan. Uruꞌu naa ukian oꞌati, “Naꞌiam naa ĩdyaun? Aonaa kanom waꞌakinan, kabootaꞌo nii pugaru oiaꞌo diꞌiti?” ");
INSERT INTO wapNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Aonaa,” okian uꞌati. Naꞌiki Jesus kian oꞌati, “Õgaru, aonaꞌo nii kapam õkabootan oiaꞌo diꞌiti pugaru. Pumakoꞌo naa, mazan aonaꞌa naa pushaꞌapataꞌanaꞌa oiaꞌo koshan.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Baudaꞌapa kamoo, Jesus kakinaopan koshan pidannao, ukian ĩꞌati, “Õgaru wuruꞌu kanadapaꞌoraz imiꞌi baara sannao ati. Pidan zaamatinan an õꞌidaꞌati, kanadaꞌo-karuaꞌo nii umashaapan, naꞌiki aonaa naꞌapainim nii ubaiaapan marutaꞌo. Wuruꞌu kanadaꞌoraz, uruu kakupa-kinai manawun.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Phariseenao kian uꞌati, “Pugaru, puꞌidaꞌaꞌoraꞌa naa karikaonan pukakuwaapan, aonaa turuu puparadan mishida-kao.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus kian ĩꞌati, “Mishi õꞌidaꞌaꞌo õkakuwaapan, mazan upuꞌu turuu õkuwaa mishida-kao! Ushaꞌapanum kauꞌan õaitapa naꞌikiꞌoram õwaꞌatin naꞌiki naꞌitiꞌoram õmakopan. Unao, aonaa uaitapan naꞌikiꞌoram õwaꞌatin oo naꞌitiꞌoram õmakopan. ");
INSERT INTO wapNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Unao, udakotan pidan oiaꞌo nii, soo uzauda-kidan karikaonan. Õgaru, aonaa naꞌapa mani õdakotan pidan oiaꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mazan ‘oiaꞌo uruu,’ oo, ‘kaimanaꞌo uruu,’ õkian an pidan dauꞌati, uruu mishiꞌo paꞌan wuruꞌu õnaꞌapanuz, ushaꞌapanum kauꞌan, aonaa õbaꞌorantinaꞌo mani wuruꞌu õnaꞌapanuz. Õdaru dyuudaꞌoraz õgaru, tumaꞌo wuruꞌu õgaruz. ");
INSERT INTO wapNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ukakinaorinaa kian, ‘Dyaꞌutamaꞌo pidannao kakuwaapan an naꞌapa kida manawun baudaꞌapaꞌo aimaakan dauꞌu, uruu aitapa-kao mishiꞌo wuruꞌu ĩkuwaaz.’ ");
INSERT INTO wapNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Õkakuwaapan õdauꞌu, naꞌapa manawun õdaru, dyuudaꞌoraz õgaru kakuwaapan kawan õdauꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ĩkian uꞌati, “Naꞌiam dii mooko puDaru?” Jesus kian ĩꞌati, “Unao, aonaa uaitapan kanom õgaru, ukauꞌan aonaa uaitapan õDaru! Uaitapan an mani õgaru, uaitapa mani õDaru kapam.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus paradan naꞌapa utominapa-kidan donoꞌo pidannao Tominkaru Dapu ii, maonapa puraata tauzo-kizinao ii, (Tominkaru Dapu tannaa niꞌoraz). Mazan aonaa naꞌiaꞌoram pidan zaamatan uruu, ushaꞌapanum kauꞌan aonaa zii amazada kaawan uzaamata-kinao nii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aizii Jesus kian ĩꞌati koshan, “Õmakon niꞌi naa diꞌikiꞌi. Udawatan nii õgaru, mazan umawakan nii uꞌoian biiꞌi. Õmakoꞌozoo-kizi iti, aonaa unao kaꞌiitan umakon.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ukauꞌan, Jewnao zowaunaanao kian paꞌatiaaka. “Pazowiinaꞌazon dauꞌatiꞌo õaitapan wuruꞌu ukianuz, ‘Õmakoꞌozoo-kizi iti, aonaa unao kaꞌiitan umakon,’ ukianuz?” ");
INSERT INTO wapNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus kian, “Unao, daꞌa sannao karikaonanuꞌu; õgaru, doko ikiꞌo paꞌan õwaꞌatin. Unao imiꞌi baara sannao! Õgaru, aonaa imiꞌi baara san mani. ");
INSERT INTO wapNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Uruu idiꞌo tawuruꞌu õkianuz uꞌati, umawakan nii uꞌoian biiꞌi. Mishiꞌo nii umawakan uꞌoian biiꞌi, umamishidakan idi õgaruꞌu naa wuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Kanom mooko pugaru?” ĩkian uꞌati. Jesus kian, “Õgaru wuruꞌu, õkowaadaniaz uꞌati kiwiin zii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","‘Oiaꞌo,’ turuaꞌo õkian unao dauꞌati, mazan aonaꞌo nii õnaꞌapan, ushaꞌapanum kauꞌan, õparadan soo dyuudaꞌoraz õgaru dyuudan kawanaꞌati, naꞌiki õaitapa uruu sakitapaꞌo uparadan. Kanom õabatanii uruu diꞌiki, uruu õkowaada pidannao ati daꞌaꞌa imiꞌi baaraꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aonaa ĩaitapan uparadinan paDaru aokazi iaꞌo dauaꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Uruu idi Jesus kian ĩꞌati, “Usawatan donoꞌo naa Daonaiora Aokazi Ikiꞌo, uaitapan niꞌi naa mishi õgaruꞌu naa wuruꞌu. Uruu dono uaitapan nii, õshaꞌapatan aimaakan aonaa õaipan atiꞌo mani, mazan õparadan naꞌapa manawun õdaru tominapa-kidan kawanaꞌati õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aizii dyuudaꞌoraz õgaru, karikaonanuꞌo unaꞌauzon õtuma, aonaꞌo nii uwaꞌakauzon õgaru õbaꞌorantin, ushaꞌapanum kauꞌan ukonaukii-kidanii ipai aimaakan õshaꞌapatanii.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iriba pidannao mishidan Jesus, ĩabatan idi naꞌapam ukian. ");
INSERT INTO wapNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ukauꞌan Jesus kian Jewnao ati mishidainaouz uruu, “Karikaonanun an uizoꞌatipan õkakinaori, uruu mishiꞌo õpidanannao unao. ");
INSERT INTO wapNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Uaitapan nii mishiꞌo kuwai Tominkaru diꞌikiꞌo. Naꞌiki mishiꞌo kuwai muudin-kidan nii unao upoitoruitapa-kao ai.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ĩkian Jesus ati, “Abraham takaan-daunnao mazan waunao, naꞌiki aonaa naꞌapainiꞌoram baꞌoran naobanai poitoruitapauzon waunao. Naꞌapaꞌoram atiꞌo dii kaiwuruꞌu, ‘mishiꞌo kuwai muudin-kidan nii unao upoitoruitapa-kao ai,’ pukianuz?” ");
INSERT INTO wapNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus kian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz uꞌati: Pidan shaꞌapataꞌo oiaꞌo, uruu oiaꞌo poitoru wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aonaa karikaonanuꞌo nii mani naobanai taapan papoitoru padapuꞌu. Mazan udani, karikaonanuꞌo nii paꞌan utaapa-kao naobanai dani nii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ukauꞌan Tominkaru Dani muudin-kidan an unao upoitoruitapa-kao ai, mishiꞌo nii manawun aonaa poitoruiꞌi naa mani unao. ");
INSERT INTO wapNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Õaitapa Abraham takaan-daunnao unao. Mazan upuꞌu zii uzowiaꞌazon õgaru, ushaꞌapanum kauꞌan, aonaa utaapan kaimanaiman õkuwaa unyukunuu ii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Õgaru, õkakuwaapan õDaru tukapa-kidanii dauaꞌo õꞌati. Unao, ushaꞌapatan aimaakan udaru kian kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aizii ĩkian uꞌati, “Abraham mazan wadaru nii.” Jesus kian ĩꞌati, “Umishiin an mani Abraham dainao unao, naꞌapa mani umashaapan uruu mashaapauzon kawan. ");
INSERT INTO wapNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Õabatan kawanaꞌati mishiꞌo kuwai Tominkaru diꞌiki, uruu õkowaada unao ati. Mazan upuꞌu zii uzowiaꞌazon õgaru. Abraham, aonaa naꞌapaꞌo mani ukaduz! ");
INSERT INTO wapNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Unao shaꞌapaapanii kidaz, udaru kaudin-kizi paꞌan wuruꞌu.” Naꞌiki ĩkian uꞌati, “Tominkaru, uruu mazan baudaꞌapa wadaru. Aonaa baꞌoran wadaru nii.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus kian ĩꞌati, “Umishiin an mani udaru Tominkaru, umarainapa mani õgaru, ushaꞌapanum kauꞌan uruu diꞌikiꞌo õwaꞌatin. Uruu dyuudanii õgaru, aonaa õaipanaꞌatiꞌo mani wuruꞌu õwaꞌatinuz. ");
INSERT INTO wapNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kandii nii aonaa uaitapan zoobaba kaiwuruꞌu õparadanuz? Ushaꞌapanum kauꞌan aonaa uzaamataꞌazon õkuwaa. ");
INSERT INTO wapNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Unao Satan dainao, uruu idiꞌo ushaꞌapataꞌazon aimaakan udaru aipan kawanaꞌati. Uruu, sakadin-kizai ikiꞌo uzowian pidan, naꞌiki aonaa naꞌapainim ukonaukii-kidan mishiꞌo kuwai, ushaꞌapanum kauꞌan aonaa naꞌapainim uparadan mishiin. Uruu mariidinauzo naꞌiki ipai mariidinauzonao tomin-kizi! ");
INSERT INTO wapNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Õgaru, mishiꞌo paꞌan õkuwaa, mazan uruu idiꞌo aonaa unao mishidan õparadan. ");
INSERT INTO wapNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Naꞌiaꞌoram dii pidan kaidaꞌaꞌa, turuaꞌo ukainaabatan õꞌoian? Õkowaadan puꞌu mishiꞌo, mazan kandii nii aonaa umishidan õparadan? ");
INSERT INTO wapNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tominkaru pidanan, uruu abata Tominkaru paradan. Unao, aonaa uzaamatan Tominkaru paradan kida, ushaꞌapanum kauꞌan aonaa upidanannao mani unao.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aizii Jewnao kian Jesus ati, “Waaitapa shaꞌatii, wakianuz pudauꞌati, Samaria san pugaru, naꞌiki oiaꞌo doronai zaamatapanii.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus kian ĩꞌati, “Aonaa oiaꞌo doronai zaamatapan õgaru, aonaa masakaudaꞌu. Õgaru, umanawunuꞌo nii õtaapan õDaru, mazan unao, aonaa utaapan õgaru umanawunuꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Õgaru, aonaa õaipinan umanawunuꞌo nii. Mazan kainaꞌa baudaꞌapa paꞌan, aipaꞌo õtaapa-kao umanawunuꞌo nii, naꞌiki uruꞌo nii aitapa naꞌapam pashaꞌapatan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mishiꞌo kaiwuruꞌu õkianuz: Pidan izoꞌatipan an õkakinaori, aonaa naꞌapainim nii umawakauzon.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Uruꞌu naa Jewnao kian uꞌati, “Aizii waaitapa, kainaꞌa mishi oiaꞌo doronai puꞌidaꞌa! Abraham mawaka uruu, prophetnao mawaka ĩnao kapam. Mazan upuꞌu zii pukian, ‘Pidan izoꞌatipan an õkakinaori, aonaa naꞌapainim nii umawakauzon.’ ");
INSERT INTO wapNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oo puwazootapanii shaꞌa wadaru Abraham umanawunun? Uruu mawakaꞌa naa, prophetnao naꞌapa kapam. Kanom kaduz mooko puꞌitiiman pugaru?” ");
INSERT INTO wapNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aizii Jesus kian ĩꞌati, “Õdakotinan an õꞌidaꞌa umanawunuꞌo nii, madiwautapa-kaꞌo wuruꞌu. ÕDaru paꞌan wuruꞌu umanawunutapaꞌoraz õgaru. Uruu unao dakotaniaz uTominkarun nii. ");
INSERT INTO wapNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Unao, aonaa uaitapauzon uruu, mazan õgaru, õaitapa paꞌan uruu. Aizii ‘Aonaa õaitapauzon uruu,’ õkian an, mariidinauzo õgaru, naꞌapa unao kawan. Mazan õgaru, õaitapanii paꞌan uruu, ukauꞌan õizoꞌati uparadan. ");
INSERT INTO wapNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Udaru Abraham, tuukii ukonaukian uaitapan idi patukapan nii zii õkaawan. Naꞌiki utukapa mishi õkaawan, uruu idi tuukii ukonaukian.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jewnao kian uꞌati, “Aonaa zii putunarunaoun, mazan naꞌapa dii mooko putukapan Abraham?” ");
INSERT INTO wapNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus kian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Õgaru naꞌaꞌoraꞌa naa Abraham tominan uaꞌii.” ");
INSERT INTO wapNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Uruꞌu naa ĩzaamataꞌakan kuba kida paboori nii, ĩzowiaꞌakaꞌazon naa uruu. Mazan Jesus dizinaꞌakan ĩꞌai, umakoꞌokan pidannao bii an aka, naꞌiki umakoꞌokan naa Tominkaru Dapu iki. ");
INSERT INTO wapNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pamakopan puꞌu, Jesus tukapan pidan pashakatan ikiꞌo uꞌishaawunun. ");
INSERT INTO wapNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sariapa utominapa-kidaniinao pishaanuzu, “Tiichaa, kanom oian idiꞌo arawu shakatan ishaawun nii, paꞌoian idiꞌo oo udaronao oian idiꞌo?” ");
INSERT INTO wapNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus kian ĩꞌati, “Ushakatan ishaawun nii, aonaa paꞌoian, oo udaronao oian idiꞌo mani, mazan uꞌishaawunun idaꞌanaꞌo nii Tominkaru maꞌozakan kainaabata-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wakanadan puꞌu zii, marii washaꞌapaapa dyuudaꞌoraz õgaru aiapanii washaꞌapatan; kainaꞌiki marutaꞌo waꞌatin, uruu dono aonaa naꞌitim niꞌi naa kaudin-karu. ");
INSERT INTO wapNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Õnaꞌan kawanaꞌati daꞌaꞌa imiꞌi baaraꞌa, õgaru wuruꞌu kanadaꞌoraz imiꞌi baara idaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesus kian daunaꞌan naꞌapa, usopitan pazaadako imiꞌi baara ati. Udaunaꞌan urauaꞌakanuz imiꞌi tuma, naꞌiki uruu idi uzichian naa ishaawun awun. ");
INSERT INTO wapNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ukian uꞌati, “Aizii puchikaanaka daari puawun ai Siloam Baoko ii.” (Siloam, kii-karu dyuuda-kariwai kiaꞌo Jewnao paradan idaꞌan.) Uruꞌu naa umakon uchikaankan naa paawun. Ukiwan powaa ati kaimanaꞌa naa utukapaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aizii umin-dazabazinao, naꞌiki baꞌoran pidannao naudinaꞌoraz naa ĩtukapauzon upishautan aimaakan pidannao ai, ĩkian paꞌatiaaka, “Aonaa mooko arawu mani tawuruꞌu sakanatapauzoz naꞌiki pishautauzoz pidannao aimaakan kida dauꞌati?” ");
INSERT INTO wapNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Baꞌorainao kian, “Uruu wuruꞌu,” mazan baꞌorainao kian, “Aonaa uruu mani, soo uaidinpan karikaonan naꞌapa uruu kawan.” Mazan uruu kian ĩꞌati, “Õgaru daꞌi tawuruꞌu pishautauzoz pidannao aimaakan dauꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ĩkian uꞌati, “Mazan naꞌapa diꞌi naa puawun saabainaꞌakan, putukapa-kinaa nii?” ");
INSERT INTO wapNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ukian ĩꞌati, “Pidan Jesus kiaꞌo uꞌuu, utomaꞌakan daari naꞌiki udaunaꞌan uzichian õawun uꞌidi, udaunaꞌan udyuudan õchikaankan õawun Siloam Baoko ii. Õchikaan daunaꞌan daari õawun ai, kaimanaꞌa naa õtukapaꞌakan.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ĩpishaan uruu, “Naꞌiam dii uruu?” ĩkian. “Aonaa õaitapan,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Udaunaꞌan ĩꞌuaꞌatiitan naa uruu Phariseenao diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesus tomanuz daari naꞌiki usaabaanuz pidan awun, Sookapa-karu Kamoon donoꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Uruꞌu naa Phariseenao pishaan koshan uruu, naꞌapaꞌoram naa uikodan patukapa-kinaa nii. Ukian ĩꞌati, “Uzichiaꞌakan daari õawun idaꞌan, udaunaꞌan õchikaan õawun baara, naꞌikiꞌo kaimanaꞌa naa õtukapaꞌakan.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Baokoinao Phariseenao kian, “Pidan shaꞌapataꞌoraz aimaakan kaikapaꞌa, aonaa Tominkaru diꞌikiꞌo mani uwaꞌatin wuruꞌu, ushaꞌapanum kauꞌan, kaudin uruu Sookapa-karu Kamoon dono.” Baokoinao kian, “Mazan naꞌapa dii mooko oiaꞌo pidan turuan pashaꞌapatan umanawunuꞌo aimaakan kida kaikapaꞌa?” Uruu panaꞌa sodi kida ĩdiꞌitinpan. ");
INSERT INTO wapNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Uruꞌu naa Phariseenao pishaan uruu koshan, “Pukian usaabaanii puawun, ukauꞌan naꞌapam dii pukian udauꞌan?” Ukian ĩꞌati, “Tominkaru prophetin uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jewnao zowaunaanao, aonaa ĩmishidaꞌazon ishaawunuꞌo daꞌi uruu, uruu idi ĩdapada-kidan naa udaronao. ");
INSERT INTO wapNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Uruꞌu naa ĩpishaan ĩdyaun, “Udani mishi arawuꞌu? Ishaawunuꞌo daꞌi mishi uruu pashakatan diꞌiki? Mazan naꞌapa diꞌi naa wuruꞌu utukapanuz aizii?” ");
INSERT INTO wapNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aizii udaronao kian ĩꞌati, “Waudani mishi uruu, naꞌiki ishaawunuꞌo ushakatan. ");
INSERT INTO wapNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mazan wuruꞌu utukapanuz naa, aonaa waaitapan naꞌapaꞌoram, naꞌiki aonaa waaitapan kanom aipan atiꞌo. Upishaaꞌa naa uruu, aonaa duusodiꞌo zii mani uruu, turuaꞌo nii ukowaadan paaipan ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aizii udaronao kianuz naꞌapa, ĩtarian idiꞌo Jewnao zowaunaanao ai. Ushaꞌapanum kauꞌan, Jewnao baokopatanii panyukunuu, kanom kian an, “Jesus, uruu Christ,” aonaꞌo niꞌi naa powaꞌa utaapada-kao ubaokopatinan synagogue ii, choochiipauzonao tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Uruu idiꞌo udaronao kian, “Aonaa duusodiꞌo zii mani uruu, upishaaꞌa naa uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Powaꞌa koshan, itamautannaa aizii ĩdapada-kidan wuruꞌu ishaawunuz daꞌi. Ĩkian uꞌati, “Pukowaada Tominkaru awun zaꞌa mishiꞌo wuruꞌu puparadanuz! Ushaꞌapanum kauꞌan waaitapa Jesus kakudaꞌoraz pugaru, oiaꞌo pidan uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ukian ĩꞌati, “Aonaa õaitapan, oiaꞌo mani uruu oo aonaa. Mazan baudaꞌapa aimaakan õaitapanii paꞌan: kiwiin ishaawunuꞌo daꞌi õgaru, mazan aizii kaimanaꞌa naa õtukapan.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Naꞌapa dii mooko ushaꞌapatan pugaru putukapa-kinaa nii?” ĩkian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Õkowaadaꞌa naa shaꞌatii uꞌati, mazan aonaa umishidan õkuwaa,” ukian ĩꞌati. “Kandii niꞌi naa uabataꞌazon powaꞌa zii koshan daꞌi? Oo uaipan shaꞌa unao kapam utominapa-kidaniinao nii?” ");
INSERT INTO wapNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Uruꞌu naa ĩdakoopaꞌakan uruu, ĩkian uꞌati, “Pugaru paꞌan wuruꞌu pumin-naꞌapaimanan tominapa-kidanii, mazan waunao Moses tominapa-kidaniinao paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Waaitapa Tominkaru paradanii Moses ati paꞌan, mazan arawuꞌu Jesus kii-kizaiz, aonaa waaitapan naꞌikiꞌoram uwaꞌatin!” ");
INSERT INTO wapNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ukian ĩꞌati, “Mazan naꞌapam dii mooko? Aonaa mishi uaitapan naꞌikiꞌoram uwaꞌatin, mazan usaabaa õawun! ");
INSERT INTO wapNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Waaitapa aonaa Tominkaru nyukunuupan pidan oiaꞌo paradan an paꞌati. Mazan pidan marainpaꞌo uruu naꞌiki shaꞌapatinaꞌo uaipan kawanaꞌati, uruu mishiꞌo nii paꞌan Tominkaru nyukunuupan uparadan. ");
INSERT INTO wapNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Naꞌiki aonaa naꞌapainim zii uabatauzo-kao, pidan pashakatan diꞌikiꞌo uawun ishaan, ikodan patukapa-kinaa nii baꞌoran pidan diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Soo mishi uruu pidan waꞌatin an Tominkaru diꞌiki, turuu paꞌan ushaꞌapatan naꞌapaꞌo aimaakan.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ĩkian uꞌati, “Pugaru oiaꞌo manawun pushakatan, mazan upuꞌu zii kaikin putominapa-kidaꞌazon waunao?” Naꞌikiꞌoraꞌa naa aonaꞌa naa ĩkashaapan ubaokopatinan powaꞌa pidannao tuma synagogue ii. ");
INSERT INTO wapNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Aizii Jesus abatan donoꞌo naa, aonaa ĩkashaapan umorotan synagogue iti powaꞌa, uruꞌu naa umakon uꞌidiꞌiti. Ukian uꞌati, “Pumishida wuruꞌu Daonaiora Aokazi Ikiꞌoraz?” ");
INSERT INTO wapNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ukian uꞌati, “Pukowaadan dono naꞌiaꞌoram uruu, õmishidan nii uruu!” ");
INSERT INTO wapNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Naꞌiki Jesus kian uꞌati, “Putukapaniꞌi naa uruu, naꞌiki kaiꞌoraz uruu wuruꞌu paradinaꞌoraz putuma.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sariapa pidan kian uꞌati, “Õmishida, õNaobanaa!” Ukodoruꞌukan uꞌati naꞌiki utaan ipai padiꞌitinpan uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus kian, “Õkaawan daꞌatiꞌi õtukapa-kidaꞌanan naꞌapam pidannao oian. Ukauꞌan ishaawun kawanuinaouz, ĩtukapan nii. Naꞌiki dakotinpainaouz aitapainao nii, ishaawunnao kawanuꞌo nii.” ");
INSERT INTO wapNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kainaꞌa Phariseenao udazabaꞌa, ĩabata wuruꞌu uparadanuz naꞌapa, uruꞌu naa ĩpishaan uruu, “Waunao mani, ishaawunnao mooko kapam?” ");
INSERT INTO wapNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus kian ĩꞌati, “Uꞌishaawunun dono mani, aonaa mani naꞌapam kii-karu uꞌoian dikin ii padamata. Mazan ukian idi aonaa uꞌishaawunun, ukauꞌan uꞌoian naꞌauzon nii karikaonan uꞌidaꞌa wuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus kian, “Mishiꞌo kaiwuruꞌu õkianuz: Soo koidimikinao naꞌiki antamikinao wuruꞌu zaidaꞌoraz kaznizo korarannaa paawa an aka. Aonaa ĩmorotan paniinom idaꞌan korara nazo iti. ");
INSERT INTO wapNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mazan pidan morotaꞌoraz paniinom idaꞌan, uruu paꞌan kaznizonao kaꞌuzatiki. ");
INSERT INTO wapNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Uruu atiꞌo paꞌan korara paniinomizinaa taapiki daꞌatan paniinom. Kaznizonao aitapaniꞌi naa uparadan. Udapadan ĩdyaun udakotan idaꞌan ĩꞌuu baudaꞌapa kida, naꞌiki ukiwiitan naa ĩꞌuaꞌati ukodita-kidan dono ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","“Aizii ukodita-kidan donoꞌo naa ĩdyaun, uruꞌu naa umakon ĩꞌuaꞌati. Kaznizonao daꞌanan naa uruu ĩaitapan idiꞌi naa uparadan. ");
INSERT INTO wapNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mazan tawarai aonaꞌo nii ĩdaꞌanan, ĩkidoopaꞌakan nii paꞌan uꞌai, ushaꞌapanum kauꞌan aonaa ĩaitapan uparadan.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus kowaadan wuruꞌu kuwaiz, mazan aonaa Phariseenao aitapan naꞌapaꞌoram manawun wuruꞌu ukuwaaz. ");
INSERT INTO wapNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ukauꞌan Jesus kian ĩꞌati koshan, “Mishiꞌo kaiwuruꞌu õkianuz: Õgaru wuruꞌu paniinom, kaznizonao dobaapa-kiziz. ");
INSERT INTO wapNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ipai baokoinao kaawainaouz kiwiitapa õꞌai, ĩnao koidimikinao naꞌiki antamikinao. Mazan aonaa kaznizonao nyukunuu-atin ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Õgaru wuruꞌu paniinomizi. Kanom morotan an õgaru idaꞌan, uruu kazannaatapa-karu nii. Õgaru idaꞌanaꞌo nii umorotan naꞌiki ukoditan, naꞌiki uikodan nii paaroapa-kizi nii. ");
INSERT INTO wapNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Koidimiki kaawan soo ukoidapaꞌanan, uzowiibiꞌiaꞌanan naꞌiki umainaabataꞌanan kaznizonao. Õgaru, õkaawan paꞌan turuu kizi ĩkakupan, naꞌiki kaimanaiman kizi manawun ĩkakupan. ");
INSERT INTO wapNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Õgaru wuruꞌu kamarainpanuꞌoraz kaznizonao kaꞌuzatiki. Aizii wuruꞌu kamarainpanuꞌoraz kaznizonao kaꞌuzatiki, turuu paꞌan umawakan pakaznizonnao dikin ii ukazannaata kizi ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pidan kawinipinaapa-kariwaiz utaapan baꞌoran pidan uzanao, aonaa kaznizonao kaꞌuzatiki kawanuꞌo mani wuruꞌu, ushaꞌapanum kauꞌan aonaa uꞌuzanao mani wuruꞌu utaapaniaz. Utukapan an baudokoru waꞌatin, ukidoopaꞌakan nii, uwaꞌakaꞌakan naa wuruꞌu kaznizonaouz. Uruꞌu naa mishi baudokoru zaamataꞌakan naa kaznizo, aizii baꞌorainao dimaadanaaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kawinipinaapa-kariwaiz kidoopaꞌakan, ukaudinan idiꞌo soo puraata dikin ii karikaonan, aonaꞌo umarainpan kaznizonao. ");
INSERT INTO wapNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Õgaru kamarainpanuꞌo kaznizonao kaꞌuzatiki. Õdaru aitapanii õgaru naꞌiki õaitapanii õdaru, naꞌapaꞌo manawun wuruꞌu õaitapanuz õkaznizonnao naꞌiki ĩaitapanuz õgaru kapam; naꞌiki turuu õmawakan ĩꞌati õkazannaata kizi ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kainaꞌa baꞌoran õkaznizonnao, aonaa diꞌoraꞌa tonaazinaa diꞌikiꞌo mani. Ĩnao, õnaꞌakan nii naꞌiki ĩmishidan nii õparadan kapam, naꞌiki uruu dono soo baudaꞌapaꞌo nii kaznizonao tonaazinaa, naꞌiki baudaꞌapaꞌo nii ĩkaꞌuzatiki. ");
INSERT INTO wapNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Õdaru marainpan õgaru, ushaꞌapanum kauꞌan õkashaapinan idi mawaka-karu ati, turuu kizi õkakupan powaꞌa iti koshan ");
INSERT INTO wapNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aonaa kanom turuaꞌo uzowian õgaru paaipan kawanaꞌati. Soo õꞌidaꞌaꞌo karikaonan wuruꞌu õkashaapinanuz! Õkaꞌiita õtaainan naꞌiki turuu õkakudan powaa iti õdaru aipan kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ĩabatan idi naꞌapaꞌo Jesus kuwaaz, sariapa koshan Jewnao diꞌitinpan panaꞌa kida pairiban ai. ");
INSERT INTO wapNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iriba ĩkian udauꞌan, “Kainaꞌaꞌo oiaꞌo doronai uꞌidaꞌa, uruu idiꞌo umadoronaa-ziiwan! Kandii nii uabataꞌazon ukuwaa.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mazan baꞌorainao kian, “Turuu mooko pidan kainaꞌaꞌo oiaꞌo doronai uꞌidaꞌa kakuwaapan kaikapaꞌa? Aonaa turuu naꞌapaꞌo tukapa-kidan ishaawunuꞌo pidan.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Amazada wadidiizon dono, Jesus naꞌiaꞌo Jerusalem ii, Tominkaru Dapu Saabauzo-kao Kamoon konaukii-kida-kao dauꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus chiꞌikaꞌanpan waoko itinapu, Solomonꞌs Porch kiaꞌoraz udakotapa-kao diꞌiiꞌaka, Tominkaru Dapu iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pidannao waꞌatin ĩkasabaꞌukinan naa udazaba ati. Naꞌiki ĩkian uꞌati, “Naꞌapam nii dii ukotuaꞌikin wazaudapan pukowaadan waꞌati kanom wuruꞌu pugaruz? Pugarun dono Christ, pukowaadaꞌakaꞌa naa waꞌati kai.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus kian ĩꞌati, “Õkowaadaniꞌi naa shaꞌatii uꞌatizu, mazan aonaa umishidan. Õshaꞌapataniaz umanawun kidaꞌo aimaakan, õdaru dyuudan kawanaꞌatiꞌo wuruꞌu, kainaabataꞌo nii kanom õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mazan unao aonaa umishidan, ushaꞌapanum kauꞌan aonaa õkaznizonnao mani unao. ");
INSERT INTO wapNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mazan õkaznizonnao, ĩaitapa paꞌan õparadan naꞌiki õaitapa ĩdyaun kapam, naꞌiki uruu idi ĩdaꞌanan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aizii daꞌanpainaouz õgaru, õtaa ĩꞌati karikaonanuꞌo kakupa-karu aonaa kizi ĩmawakauzon. Aonaa turuu ĩkazata-kao õkaꞌu iki. ");
INSERT INTO wapNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ÕDaru taanii ĩdyaun õꞌati, naꞌiki uruu umanawunuꞌo ipai baꞌorainao ai. Aonaa turuu ĩkazata-kao õdaru kaꞌu iki. ");
INSERT INTO wapNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ÕDaru naꞌiki õgaruz baudaꞌapaꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Uruꞌu naa koshan Jewnao zaamataꞌakan kuba paboori kida nii, ĩzowiaꞌakaꞌazon naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus kian ĩꞌati, “Õshaꞌapata iriba kaiman kidaꞌo aimaakan unao awun zaꞌa, õDaru dyuudan kawanaꞌati. Naꞌiaꞌoram dikin iaꞌo wuruꞌu uzowiaꞌazoonuz õgaru kuba idi?” ");
INSERT INTO wapNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ĩkian uꞌati, “Aonaa pushaꞌapatan idiꞌo mani kaiman kidaꞌo aimaakan waboowaꞌazon pugaru, mazan puwazootapaꞌazon idiꞌo Tominkaru. Pugaru pidan karikaonan, mazan upuꞌu zii pudakotinpan Tominkaru nii!” ");
INSERT INTO wapNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus kian ĩꞌati, “Aonaa mooko Tominkaru kian unao kakinaorinaa saada-kariwai idaꞌa, ‘Unao tominkarunao’ kii? ");
INSERT INTO wapNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tominkaru dakotan wuruꞌu pakuwaa kaawa-kizinaouz pidannao, ‘tominkarunao’ kii, naꞌiki waaitapa, saada-kariwaiz kida Tominkaru paradan karikaonanuꞌo nii umishiin. ");
INSERT INTO wapNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mazan kandii nii ukian, ‘puwazootapaꞌazon Tominkaru pudakotinpan idaꞌan Tominkaru dani nii’? Õgaru, Tominkaru saabaaniꞌi naa naꞌiki udyuudanii imiꞌi baara ati. Ukauꞌan turuu paꞌan õdakota-kao Tominkaru Dani nii. ");
INSERT INTO wapNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Õmashaꞌapatakan an mani õdaru dyuudanii õshaꞌapatan, aonaa kanom nii umishidan õgaru; ");
INSERT INTO wapNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","mazan õshaꞌapatan dono õdaru kaudin-kizi, umamishidakan puꞌu padamata õgaru, turuaꞌo padamata umishidan wuru idaꞌanaꞌa õshaꞌapatanii kidaz. Uruu idaꞌanaꞌo nii uaitapan kaimanaiman õgaru naꞌiki õdaru baudaꞌapaꞌo, naꞌiki naꞌapa kidaꞌo waunao.” ");
INSERT INTO wapNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ĩaipan naa koshan pazaamataꞌakan uruu, mazan sariapa Jesus kidoopaꞌakan ĩꞌai. ");
INSERT INTO wapNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Udaunaꞌan Jesus makon powaa iti Jordan baza iti, John Chikaawunuupauzo-kizi iti. Unaꞌiaꞌakan puꞌu, ");
INSERT INTO wapNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","iriba pidannao kaawan uꞌidaꞌati, naꞌiki ĩkian paꞌatiaaka, “Aonaa mishi John shaꞌapatan umanawun kidaꞌo aimaakan, mazan ipai ukuwaa mishiin diꞌoraꞌa pidan dauꞌaꞌa!” ");
INSERT INTO wapNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Naꞌiki iriba naꞌiainao pidannao mishidan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kainaꞌaꞌo daꞌi pidan Lazarus kiaꞌo uꞌuu, ukarinauzon. Bethany iaꞌo umashaapan. Dyaꞌutam udadakoonao Mary naꞌiki Martha kiaꞌo ĩꞌuu, naꞌiaꞌo ĩmashaapan kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mary ramaudaꞌoraz daꞌi Naobanai Jesus kidiba kaduunuꞌo ramau idi, naꞌiki oꞌinoonuzu padizo idi. Oroo azu Lazarus wuruꞌu karinaꞌoraz.) ");
INSERT INTO wapNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Uruu idi udadakoonao dyuudan paparadan Jesus diꞌiti. Ĩkian, “Naobanai, pumarainpaniaz pupaonaru, tuukii ukarinaan kai.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mazan Jesus abatan dono wuruꞌu kuwaiz, ukian, “Lazarus karinaanuz, aonaa umawaka-kinaa niꞌo mani wuruꞌu; mazan Tominkaru maꞌozakan umanawunuꞌo, kainaabata-kinao niꞌo, naꞌiki naꞌapaꞌo idaꞌanaꞌo nii pidannao aitapan Tominkaru Dani umanawunun.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Aizii Jesus, umarainapanii Martha, Mary, naꞌiki Lazarus. ");
INSERT INTO wapNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mazan uabatan puꞌaꞌa naa kuwai Lazarus karinaan dauꞌu, unaꞌian zii dyaꞌutam kamoo. ");
INSERT INTO wapNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Uruu daunaꞌan Jesus kian patominapa-kidaniinao ati, “Aizii, wamako powaa iti Judea Baara iti.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Tiichaa,” ĩkian uꞌati, “Diikiꞌi shaꞌatii Jewnao zowiaꞌazon pugaru naꞌii kuba idi, mazan upuꞌu zii pumakoꞌozon powaa iti?” ");
INSERT INTO wapNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus kian ĩꞌati, “Kainaꞌa 12 hours wakandan baudaꞌapaꞌo kamoo idaꞌa. Mishii naꞌapa? Pidan chiꞌikapan an wakandan puꞌu aonaꞌo nii ukaboinan, ushaꞌapanum kauꞌan kainaꞌa zii kanadapaꞌo imiꞌi baara. ");
INSERT INTO wapNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mazan pidan chiꞌikapan an wamarutan puꞌu, ukaboinan nii, ushaꞌapanum kauꞌan aonaa kanadaꞌo nii uꞌidaꞌa.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ukakuwaapan daunaꞌan, ukian ĩꞌati, “Daꞌawuꞌukaꞌa naa wapaonaru Lazarus, mazan õmakon nii naꞌiti õpokowauaꞌanan uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Utominapa-kidaniinao kian uꞌati, “Naobanai, kaimanaꞌo wuruꞌu udaꞌawunuz, ukakudan nii wuruꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus paradanuz Lazarus mawakan dauaꞌo, mazan ĩꞌitiiman mishiꞌo nii manawun Lazarus daꞌawun. ");
INSERT INTO wapNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Uruꞌu naa Jesus kowaadan ĩꞌati kaimanaiman, “Mawakaꞌa naa Lazarus. ");
INSERT INTO wapNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mazan kaiman zii, aonaa õgaru nii naꞌii, ushaꞌapanum kauꞌan naꞌapaꞌo idaꞌanaꞌo nii unao mishidan kanom wuruꞌu õgaruz. Aizii wamakoꞌo naa uꞌidiꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas (Shamaan kiaꞌoraz udakotapa-kao) kian pamin-tominpannao ati, “Aushaa, wamako wanaobanaa tuma, marii wazowii-kao utuma.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Aizii, Jesus kaawan donoꞌo naa Bethany iti, ukowaada-kao uꞌati 4 kamoo dobatan naa Lazarus nanaa naꞌian baaranai ii. ");
INSERT INTO wapNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany maonapaꞌo Jerusalem iti, aonaa uikodan dyaꞌutam mile. ");
INSERT INTO wapNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aizii Lazarus mawakan daunaꞌan, iriba pidannao kaawan Judea Baara ikiꞌo, ĩmorowautaꞌanan Martha naꞌiki Mary idaꞌati, ĩkonaukiidaꞌanan ĩnyukunuu kowas, ĩꞌazu mawakan idi. ");
INSERT INTO wapNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martha abatan donoꞌo naa pidannao kian, “Waꞌatiꞌi naa Jesus!” Uruꞌu naa oikodapaꞌanaꞌakan uruu, mazan Mary onaꞌian kabaun ii. ");
INSERT INTO wapNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha kian Jesus ati, “Naobanai, punaꞌan dono mani daꞌaꞌa, aonaa mani õꞌazu mawakan padamata! ");
INSERT INTO wapNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mazan õaitapa, pupishaan an Tominkaru kai kanom dauꞌati karikaonan, ukawanaꞌatiꞌo nii ushaꞌapan.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus kian oꞌati, “Puꞌazu kadishitan nii powaa iti.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha kian uꞌati, “Õaitapa, ukadishitan nii koshan, kadishita-karu kamoo dono.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus kian oꞌati, “Õgaru wuruꞌu kadishita-kinaiz, naꞌiki õgaru wuruꞌu kakupa-kinaiz. Pidan mishidaꞌoraz õgaru, kakudaꞌo nii umawakan puꞌu padamata. ");
INSERT INTO wapNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aizii kanom mishiꞌo ukakupan, naꞌiki mishidaꞌo õgaru, aonaa naꞌapainim nii umawakauzon. Pumishida?” ");
INSERT INTO wapNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Oo, Naobanai!” okian uꞌati. “Õmishida kaimanaiman, pugaru wuruꞌu Christ, Tominkaru Dani, kaawaꞌo niꞌoraz imiꞌi baara ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha paradan daunaꞌan Jesus ati, okiwaꞌakan naa powaa iti. Uruꞌu naa oparadan paꞌinaozo Mary ati karikaonan. “Kainaꞌaꞌoraꞌa naa mishi watiichaan, utukapaꞌazon pugaru,” okian oꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary abatan idi kaikapaꞌoraꞌa, uruꞌu naa omakoꞌokan, oikodapaꞌanan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Aizii Jesus, aonaa zii ukaawan wiizai ati, pakawan zii naꞌii Martha ikodapanaka-kizi ii uruu.) ");
INSERT INTO wapNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aizii kabaun nazo iainaouz pidannao, konaukiidaꞌanainaouz onyukunuu, ĩtukapan idi Mary koditaꞌakan dopiaudaꞌu kabaun nazo iki, ĩꞌitiiman omuraapaꞌanan nii baaranai iti kowas, uruu idi ĩmakon odawuꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Aizii Mary ikodapan donoꞌo naa Jesus, sariapa okodoruꞌukan uꞌati ukanaapuꞌu naꞌiki okian uꞌati, “Naobanai, punaꞌan dono mani daꞌaꞌa, aonaa zii mani õꞌazu mawakan padamata!” ");
INSERT INTO wapNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesus tukapan idi Mary naꞌiki pidannao otumainaouz zaadinan, sariapa utoꞌoran panyukunuu ii mazan tuukii ukashaꞌoran kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ukian ĩꞌati, “Naꞌiam dii ubaaranaa?” Ĩkian uꞌati, “Puwaꞌati daꞌatiꞌi, Naobanai, putukapa kizi.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus zaadaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pidannao kian paꞌatiaaka, “Aushaa utukapa, tuukiaꞌo umarainpan Lazarus!” ");
INSERT INTO wapNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mazan baokoinao kian, “Utukapa-kidanii shaꞌatii ishaawun, mishii? Ukauꞌan, ukaawan dono mani Lazarus karinaapan puꞌu zii, ukakuda mani uruu padamata.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Powaꞌa zii koshan Jesus nyukunuu kashaꞌoran tuukiaꞌo idaꞌan, uruꞌu naa umakon naꞌiki ukaawan naa baaranai idaꞌati. Kuba uun idaꞌaꞌo wuruꞌu ubaaranaaz, naꞌiki taratapa-kariwai udaruꞌo kuba idi. ");
INSERT INTO wapNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Uruꞌu naa Jesus dyuudan pidannao zikadan wuruꞌu kuba, baaranai taratapa-kinaoaz. Martha kian uꞌati, “Naobanai, dyupushaꞌoraꞌa naa wuruꞌu, puaitapanii 4 kamoꞌo naa udida-kao daunaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Naꞌiki Jesus kian oꞌati, “Aonaa mooko õkian, pumishidan an, putukapan nii naꞌapam Tominkaru umanawunun kainaabatinan?” ");
INSERT INTO wapNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Uruꞌu naa pidannao kiduꞌukan naa wuruꞌu kubaz. Udaunaꞌan Jesus awunuupan doko iti naꞌiki ukian, “Õdaru, kaiman mishi manawun pugaru õꞌati, puabata daꞌi õparadauzon an puꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Õaitapa karikaonan daꞌi puabatauzon õparadan. Mazan õparadan puꞌati kaikapaꞌa, diꞌoraz pidannao naꞌan idiꞌo, marii kizi ĩmishidan pudyuudanii õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Utoriinpan daunaꞌan, ukian diiwaꞌo idaꞌan, “Lazarus, pukodita daꞌatiꞌi!” ");
INSERT INTO wapNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mawakaꞌoraz pidan koditaꞌakan naa. Ukaꞌu naꞌiki ukidiba watudinapa kida kamicha idi, naꞌiki uawun baara kamicha idi ubazobatinpan. Jesus kian pidannao ati, “Ubuzuuta kamicha uꞌai, marii kiziꞌi naa umakon.” ");
INSERT INTO wapNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iriba morowautankainaouz Mary idaꞌati, tukapainaouz Jesus shaꞌapatan aimaakan, mishidan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mazan baokoinao kiwan naꞌiki ĩkakuwaapan naa Phariseenao ati, Jesus shaꞌapatanii dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Uruu idiꞌi naa Phariseenao naꞌiki faadaanao zowaunaanao miitiniipan baokoinao Jewnao zowaunaanao tuma. “Naꞌapa dii washaꞌapatan uruu?” ĩkian. “Aushaa udiꞌitapa, wuruꞌu pidanaz, iribaꞌa naa ushaꞌapatan umanawun kidaꞌo aimaakan! ");
INSERT INTO wapNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wataapadan dono ushaꞌapaapan naꞌapa kidaꞌo aimaakan, ipaiꞌo niꞌi naa pidannao zaamatinan uꞌidiꞌiti, naꞌiki udaunaꞌan Romannao waꞌatin nii ĩkaboobiꞌian nii Tominkaru Dapu naꞌiki ĩzowiaꞌanan wawiizi sannao!” ");
INSERT INTO wapNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Baudaꞌapa ĩbii iaꞌo, Caiaphas kiaꞌo uꞌuu. Uruu Umanawunuꞌo Faadaa uruu wunu idaꞌa. Ukian, “Unao pidannao, maaitapin-kainao karikaonan! ");
INSERT INTO wapNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aonaꞌa mooko uaitapan, powaꞌaꞌo nii ukaimanan baudaꞌapaꞌo pidan mawakan an pidannao dikin ii, wawiizi sannao mainaabata-kao ai manawun?” ");
INSERT INTO wapNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caiaphas naꞌapanuz aonaa paaipan kawanaꞌatiꞌo mani. Uruu wuruꞌu Umanawunuꞌo Faadaa uruu wunu idaꞌa. Ukauꞌan uparadaꞌakanuz naꞌapa ukowaadaꞌakan naa Jesus wuruꞌu mawakaꞌo niꞌoraz Jewnao donozinaa ati. ");
INSERT INTO wapNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mazan aonaa soo ĩnao atiꞌo nii mani karikaonan. Umawakan nii Tominkaru pidanannao baokopatin-kinaa nii, mashaapainaouz baꞌoran wiizai ii aka kida kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ĩbaokopatinankan diꞌikiꞌoraꞌa naa, Jewnao zowaunaanao sakadan pakadakotinan pazowiaꞌazon dauꞌu Jesus. ");
INSERT INTO wapNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Uruu idi aonaꞌa naa Jesus chiꞌikaꞌanpan kainaabatinapa Jewnao bii an powaꞌa. Naꞌikiꞌoraꞌa naa umakon Ephraim iti, amazada mapidantakaꞌo diꞌitanpuꞌoraz, naꞌiaꞌa naa uruu patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Maonapaꞌa naa Passover Kamoo kaawan, naꞌiki iriba pidannao munapo kidaꞌo ĩmashaapan makon Jerusalem iti, ĩchikainaꞌanan naa Jewnao kakinaorinaa kawanaꞌati, turuu kizi ĩbaokopainpan pidannao tuma Passover Kamoon dono. ");
INSERT INTO wapNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ĩzaudapan Jesus naꞌiki ĩkian paꞌatiaaka udauꞌan pabaokopatinpan puꞌu Tominkaru Dapu ii, “Waꞌatiꞌo nii puzauda-kidan uruu daꞌatiꞌi baokopainapa-kizai ati?” ");
INSERT INTO wapNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aizii faadaanao zowaunaanao naꞌiki Phariseenao kii akaniꞌi naa pidannao ati, “Kanom aitapan dono naꞌiam Jesus, marii paꞌi ukowaadan sariapa waꞌati, wazaamata kizi naꞌiki wakootowapa-kida kizi uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aizii 6 kamoo Passover Kamoon uaꞌii Jesus makon Bethany iti, Lazarus mashaapa-kiziz, tawuruꞌu ukakudaniaz pidan. ");
INSERT INTO wapNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesus paonarunao konaukii-kidan naꞌiki ĩaroapa-kidan wuruꞌu ukaawanuz. Martha maokodaꞌo nii wanyukunui udono, Lazarus naꞌiki Jesus sakanatapan puꞌu miisa diꞌii baokoinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mary zaamatankan pootozu zoꞌaꞌo kawinipinaꞌo ramau, paoribai nard kiwin idiꞌo paꞌidiwaru utoma-kao, uruꞌu naa oshootanuz Jesus kidiba iti, udaunaꞌan oꞌinoan ukidiba padizo idi. Ipai ukaduunuaꞌakan kabaun nazoo. ");
INSERT INTO wapNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sariapa Judas Iscariot, Jesus tominapa-kidaniinao bii ikiꞌo, kaakapaꞌo niꞌoraz Jesus, uruu kian, ");
INSERT INTO wapNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kandii nii ramau wakuda-kao? Turuaꞌo usellii-kao padamata 300 wiziꞌi kidaꞌo puraata dikin ii. Udaunaꞌan uwinipinaa taa-kao patakaꞌutinainao ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ukianuz kaikapaꞌa pakoidimikin idiꞌo, aonaa umarainpan idiꞌo mani patakaꞌutinainao. Uruu wuruꞌu taapaꞌoraz puraata, ĩꞌatiꞌoraz taauzo-kao kida, naꞌikiꞌo daꞌi ukaiwaꞌakauzon patorii-kinaa nii aimaakan paꞌidiwau nii. ");
INSERT INTO wapNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus kian, “Manaꞌa putowaudaꞌuaꞌanaꞌa oroo! Kaiman zii otaapan ramau, ominziiwata-kinaa nii õnanaa õdida-kao uaꞌii. ");
INSERT INTO wapNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Patakaꞌutinainaouz karikaonanuꞌo nii ĩnaꞌan unao tuma, mazan õgaru aonaa karikaonanuꞌo nii mani õnaꞌan utuma.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iriba Jewnao abatan kainaꞌa Jesus Bethany ii; uruu idi ĩmakon naꞌiti. Ĩmakonuz naꞌiti Jesus naꞌian idiꞌo, naꞌiki ĩtukapaꞌazon idiꞌo kapam Lazarus, wuruꞌu Jesus kakudaniaz pamawaka-kizi iki. ");
INSERT INTO wapNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Uruu idiꞌi naa faadaanao zowaunaanao diꞌitinpan naꞌiki ĩtoman panyukunuu ĩzowii kizi Lazarus kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ushaꞌapanum kauꞌan iribaꞌa naa Jewnao muudinan ĩꞌai naꞌiki ĩmishidan naa Jesus, ukakudan idi Lazarus. ");
INSERT INTO wapNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Aizii baꞌoran kamoo donoꞌo naa, wuruꞌu iribaꞌoraz pidannao, kaawainaouz Passover Kamoon dauꞌati, ĩabata kainaꞌiki Jesus waꞌatin Jerusalem ati. ");
INSERT INTO wapNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Uruu idi ĩdukuan pokoridi anaba kaduz kida naꞌiki ĩnaꞌakan kidaꞌa naazu, ĩikodapaꞌanan naa Jesus. Ĩkian paimori bii an, “Kaiman manawun wakazannaatiki! Marii Tominkaru kaimanan Naobanai ati, kaawaꞌoraz uaipan kawanaꞌati, King niꞌoraz Israelitenao ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus zaidan chaakashi paꞌinaꞌo zii, naꞌiki uruu barau anaꞌa naa umakon. Ushaꞌapan naꞌapa Tominkaru Paradan saadauzo-kariwaiz kawanaꞌati: ");
INSERT INTO wapNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Manaꞌa utariaꞌanaꞌa, Jerusalem sannao! Diinaꞌiki unaobanaa King waꞌatiniꞌi, uzaidapa paꞌinaꞌo chaakashi.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Uruu dono aonaa utominapa-kidaniinao aitapan naꞌapaꞌoram wuruꞌu kaikapaꞌoraz aimaakan shaꞌapan kidaꞌa. Mazan Jesus kadishitan daunaꞌan pamawaka-kizi iki, uruu zii ĩnyukunuuan wuruꞌu saadauzo-kariwai udauꞌan, naꞌiki ĩnyukunuuan wuruꞌu pashaꞌapatanuz kaikapaꞌo aimaakan uꞌatiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesus tumainaouz pidannao ukadishita-kidan donoꞌoraz Lazarus pabaaranaa iki, ĩnao kakuwaapan naa baokoinao ati aimaakan shaꞌapaꞌo dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ĩabatan idi Jesus shaꞌapatan umanawunuꞌo aimaakan, uruu idi iriba pidannao ikodapaꞌanan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Uruu idi Phariseenao kian naa paꞌatiaaka, “Aonaa naꞌitim washaꞌapatinan! Aushaa utukapa, ipaiꞌi naa pidannao daꞌanpan uruu!” ");
INSERT INTO wapNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Aizii naꞌiaꞌo Greeknao wunao bii iaꞌa makoinaouz Jerusalem iti konaukii-kidaꞌanan Tominkaru baokopainapa-karu dono. ");
INSERT INTO wapNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ĩwaꞌatin Philip idaꞌati (Philip Bethsaida san uruu, Galilee Baara iaꞌoraz). Ĩkian uꞌati, “Kainaꞌaꞌo watukapaꞌazon Jesus, waparadaꞌazon utuma.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip kowaadanuz Andrew ati, uruꞌu naa ĩmakoꞌokan naꞌiki ĩkowaadan naa Jesus ati Greeknao paradaꞌazon utuma. ");
INSERT INTO wapNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus kian ĩꞌati, “Aizii kaawaꞌa naa amazada, Daonaiora Aokazi Ikiꞌo tukapa-kinao niꞌi naa umanawunuꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mishiꞌo kaiwuruꞌu õkianuz: Aonaa naꞌapainim nii baudaꞌapaꞌo maziki dako waotaꞌoraz imiꞌi baara ati iribainan, soo umawakan an. Mazan umawakan idi, uruꞌo nii zii ukaakan madowaaka. ");
INSERT INTO wapNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pidan marainpaꞌoraz pakakupan, uwaziwaan niiz; mazan pidan aonaꞌoraz umarainpan pakakupan diꞌoraꞌa amazada idaꞌaꞌa, uruu ati taa-kao nii karikaonanuꞌo kakupa-karu. ");
INSERT INTO wapNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Naꞌiaꞌoram pidan aipan an õgaru panaobanaa nii, marii udaꞌanan õgaru; naꞌiam dono õgaru, õpoitorunao õtumaꞌo nii ĩnao kapam. Wuruꞌu pidan naobanaitapaꞌoraz õgaru, õdaru aida-kidan nii naꞌapam pamarainpan uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesus kian, “Aizii kiiꞌan! Naꞌapa dii õkian? Turuu mani õkian, ‘Õdaru, aonaa putaapadaꞌanaꞌa dadaraꞌo manawun kamoo kaawan õꞌati?’ Mazan aonaa turuu õnaꞌapan. Naꞌapaꞌo niꞌo wuruꞌu õkaawanuz imiꞌi baara ati, baiaapaꞌo niꞌo kashaꞌoraꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Õdaru, putukapa-kida pumanawunun pidannao ati!” Udaunaꞌan Parada-karu aokazi ikiꞌo kian, “Õtukapa-kidaniꞌi naa õmanawunun, naꞌiki õtukapa-kidan nii õmanawunun powaꞌa koshan.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pidannao, naꞌaꞌoraz ĩkadishitapan abata wuruꞌu parada-karuz. “Toroanaru!” ĩkian udauꞌati. Baokoinao kian, “Angel paradan uꞌati!” ");
INSERT INTO wapNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mazan Jesus kian ĩꞌati, “Aonaa õmishida-kinaa niꞌo mani wuruꞌu parada-karu abata-kaoaz, mazan unao mishida-kinaa niꞌo paꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aizii kaawaꞌa naa kamoo Tominkaru tiwaa-kinaa niꞌi naa imiꞌi baara sannao. Aiziꞌo niꞌi naa diꞌoraꞌa amazada baaraꞌaꞌo naobanai kaboota-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Õsawata-kao donoꞌo naa, naꞌapaꞌo idaꞌanaꞌo nii õdapadan ipai pidannao õꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesus kianuz kaikapaꞌa, ukowaadan naꞌapam nii pamawakan wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pidannao kian uꞌati, “Wakakinaorinaa saada-kariwai kowaadan waꞌati, Christ karikaonanuꞌo nii ukakupan. Mazan naꞌapaꞌo dii kaiwuruꞌu, sawata-karu nii Daonaiora Aokazi Ikiꞌo pukianuz? Kanom mooko wuruꞌu Daonaiora Aokazi Ikiꞌoraz?” ");
INSERT INTO wapNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus kian ĩꞌati, “Kanadaꞌo nii zii amazada masakaudaꞌuꞌu naa. Umakoꞌo naa zii sariapa, amazada kanadan puꞌu, aonaa kizi ubaiaapan marutaꞌo. Ushaꞌapanum kauꞌan, pidan chiꞌikapaꞌo amazada marutan puꞌu, aonaa uaitapan naꞌitiꞌoram naa pamakon. ");
INSERT INTO wapNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ukaiwaa wuruꞌu kanadaꞌoraz, ukainaꞌan puꞌu zii, unao kizi kanadaꞌo sannao nii.” Aizii Jesus paradan daunaꞌan ĩꞌati kaikapaꞌa umakoꞌokan naa ĩꞌai, aonaa kizi ĩaitapan naꞌiam uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus shaꞌapatan puꞌu padamata iriba umanawun kidaꞌo aimaakan ĩawun zaꞌa, mazan upuꞌu zii aonaa ĩmishidan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ipai ushaꞌapan kaikapaꞌa, Prophet Isaiah kuwaa mishiinan naa wuruꞌu: “Naobanai, kanom mishida paabatanii wakuwaa? Kanom ati dii Naobanai aida-kidan pamaꞌozakan?” ");
INSERT INTO wapNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mazan aonaa ĩmishidaꞌazon, ushaꞌapanum kauꞌan, kaikapaꞌo koshan daꞌi Isaiah kiauzon ĩdauꞌanaꞌa: ");
INSERT INTO wapNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tominkaru ishadaꞌakan ĩawun kida, aonaa kizi ĩtukapan. Naꞌiki udadaradan ĩnyukunuu kida, aonaa kizi ĩaitapan. Aonaa zoobaba ĩwaꞌatin Tominkaru idaꞌati, usaabaa kizi ĩdyaun.” ");
INSERT INTO wapNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah kian kaikapaꞌa, ushaꞌapanum kauꞌan aida-kida-kariwai uꞌati naꞌapam nii Jesus umanawunun diinaꞌitiꞌo, naꞌiki uruꞌu naa ukakuwaapan udauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mazan upuꞌu iriba kainaꞌa Jewnao zowaunaanao mishidaꞌo Jesus. Mazan ĩtarian idi Phariseenao ai, aonaa kanom nii ĩkowaadan baokoinao ati pamishidan dauꞌu, aonaa kizi ĩkashanau-kao pabaokopainpan ai synagogue ii. ");
INSERT INTO wapNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tuukii manawun ĩnaudapan pidannao naubaan paugaru, Tominkaru naubaan ai paugaru. ");
INSERT INTO wapNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Diiwaꞌo idaꞌan Jesus kian, “Ipai pidan mishidaꞌoraz õgaru, aonaa õgaru karikaonan mani wuruꞌu umishidaniaz, dyuudaꞌoraz õgaru kapam wuruꞌu umishidaniaz. ");
INSERT INTO wapNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Naꞌiki ipai pidan tukapaꞌoraz õgaru, uruu tukapaꞌo kapam dyuudaꞌoraz õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Õgaru, õkaawan kanadapaꞌo nii imiꞌi baara sannao idaꞌati. Pidan mishidan an õgaru, aonaꞌo nii unaꞌian marutaꞌo diꞌii. ");
INSERT INTO wapNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Naꞌiaꞌoram pidan abatan an õkuwaa, mazan aonaa uizoꞌatin, aonaa õgaruꞌo nii mani kabootaꞌoraz uruu oiaꞌo diꞌiti. Õkaawan daꞌatiꞌi aonaa õkabootaꞌanan mani pidannao oiaꞌo diꞌiti mazan õkazannaataꞌanan paꞌan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pidan kashadaꞌo õgaru naꞌiki dikintapaꞌo õparadan, kainaꞌaꞌoraꞌa naa kaboota-kidaꞌo nii uruu oiaꞌo diꞌiti. Õparadanuꞌo nii wuruꞌu kabootaꞌoraz uruu patakaꞌutin-karu diꞌiti, amazada tokon donoꞌo naa! ");
INSERT INTO wapNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ushaꞌapanum kauꞌan, aonaa õaipan atiꞌo mani wuruꞌu õparadanuz, soo õdaru dyuudaꞌoraz õgaru, dyuudan kawanaꞌatiꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Naꞌiki õaitapa, wuruꞌu ukakinaori kidaz uruu karikaonanuꞌo kakupa-kinai. Õkakuwaapan uꞌati, kaikapaꞌa õdaru dyuudan kawanaꞌatiꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aizii baokopainpauzo-karu Passover Kamoon uaꞌii zii. Jesus aitapa kamoo kaawaꞌakan naa aizii wuruꞌu, umako-kinaa niꞌi naa padaru diꞌiti, diꞌoraꞌa amazada diꞌikiꞌi. Karikaonan umarainpan papidanannao, umarainapa ĩdyaun tuukii, atii naꞌapa umawakan. ");
INSERT INTO wapNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wachuupun dono Jesus aroopan patominapa-kidaniinao tuma. Satan diꞌitinapa-kidaniꞌi naa Judas, Simon Iscariot daniz, marii kizi ukaakapan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus aitapanii kaimanaiman Tominkaru taanii paꞌati panyukunuu maꞌozaka-kinaa nii, pakaꞌiita-kinaa nii pashaꞌapatan ipai daunuudaꞌu aimaakan. Uaitapa pawaꞌatin Tominkaru diꞌikiꞌo naꞌiki ukiwan nii powaa iti Tominkaru diꞌiti koshan. ");
INSERT INTO wapNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Uruu idi Jesus kadishitaꞌakan paaroapa-kizi miisa diꞌiki, udaunaꞌan unarakadan pachaakitan. Udaunaꞌan uzaamatan towel naꞌiki upapidanuz pakonoon an. ");
INSERT INTO wapNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Uruu daunaꞌan ukapotan wunu basii zoꞌati, naꞌiki uchikaan naa patominapa-kidaniinao kidiba. Udaunaꞌan uinoan ĩkidiba kida towel idi, upapidapaniaz pakonoon an. ");
INSERT INTO wapNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mazan ukaawan Simon Peter idaꞌati, sariapa Peter kian uꞌati, “õNaobanaa, puchikaan nii õkidiba?” ");
INSERT INTO wapNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus kian uꞌati, “Pugaru, aonaa puaitapan kai kanom wuruꞌu õshaꞌapaapaniaz, mazan puaitapan nii zii diinaꞌitiꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter kian uꞌati, “Õgaru, aonaa naꞌapainim nii puchikaan õkidiba!” Mazan Jesus kian uꞌati, “Aonaan an õchikaan pukidiba, aonaꞌo nii puzaamatinpan powaꞌa õꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter kian uꞌati, “Naobanai, ukauꞌan aonaa puchikaꞌanaꞌa õkidiba karikaonan! Mazan puchikaa mooko õkaꞌu, naꞌiki õzowau kapam!” ");
INSERT INTO wapNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus kian, “Pidan kaokopaꞌoraꞌa naa, aonaꞌoraꞌa naa ukaniriban wuruꞌu. Ukauꞌan aonaa kanom nii uchikainan powaꞌa zii, soo uchikaan nii pakidibaꞌa naa karikaonan. Ipai unao, aonaꞌoraꞌa naa ukaniriban. Soo kainaꞌa baudaꞌapa unao biiꞌi kaniribaꞌo.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jesus aitapaniꞌi naa kanomaꞌo nii kaakapaa paugaru. Uruu idiꞌo ukianuz, “Ipai unao, soo kainaꞌa baudaꞌapa unao biiꞌi kaniribaꞌo.”) ");
INSERT INTO wapNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Uipaian daunaꞌan pachikaan ĩkidiba kida, Jesus morokodan naa pakamichan, naꞌiki usakanatan powaa iti miisa diꞌiti. Uruꞌu naa upishaan ĩdyaun, “Uaitapa kanom wuruꞌu õshaꞌapataꞌakaniaz uꞌati?” ukian. ");
INSERT INTO wapNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Unao dakotan õgaru, ‘Tiichaa’ oo ‘Naobanai’ kii. Naꞌapaꞌo mishi manawun wuruꞌu õgaruz. ");
INSERT INTO wapNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Õgaru uNaobanaa naꞌiki uTiichaan. Mazan upuꞌu õchikaan ukidiba kida. Ukauꞌan, naꞌapaꞌa naa paꞌi uchikaa uiriban kidiba kida kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Õshaꞌapatan aimaakan, unao tamakapan niꞌo. Naꞌapaꞌa naa ushaꞌapata õshaꞌapatan kawan unao ati. ");
INSERT INTO wapNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mishiꞌo kaiwuruꞌu õkianuz: Aonaa naꞌiaꞌoram poitorui umanawunun panaobanaa ai. Aonaa naꞌiaꞌoram pidan dyuuda-kariwaiz ukakuwaapaꞌanan, umanawunun dyuudaꞌo ai paugaru. ");
INSERT INTO wapNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Aizii uaitapan an kaikapa kidaꞌoraꞌa, konaukiaꞌo nii manawun unao, ushaꞌapatinan an ukawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mazan õkadakotinanuz aonaa ipai unao dauaꞌo mani. Õaitapanii shaꞌapaꞌoram kaduz kida pidannao õzaamatanii. Mazan kainaꞌa saada-kariwaiz kida Tominkaru Paradan idaꞌa kaikapaꞌa: ‘Õmin-aroopan tominan õtaruba nii.’ Uruu mishiin-kinaa niꞌo wuruꞌu ushaꞌapanuz naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Õkowaadan uꞌati kanomaꞌo nii shaꞌapa, ushaꞌapan uaꞌii zii. Aizii ushaꞌapaꞌakan donoꞌo naa, umishidan nii ‘Õgaru wuruꞌu.’ ");
INSERT INTO wapNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mishiꞌo kaiwuruꞌu õkianuz: Naꞌiaꞌoram pidan konaukiaꞌo udapaapan õdyuudanii, õgaru kapam wuruꞌu udapaapaniaz; naꞌiki naꞌiaꞌoram pidan konaukiaꞌo udapaapan õgaru, dyuudaꞌoraz õgaru kapam wuruꞌu udapaapaniaz.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus kian daunaꞌan naꞌapa, tuukii udopian panyukunuu ii, uruu idi aonaꞌa naa udizapaꞌakan paparadan, ukian ĩꞌati, “Mishiꞌo kaiwuruꞌu õkianuz: Baudaꞌapa pidan unao bii ikiꞌo zaamata-kidan nii õgaru õtarubanao ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Utominapa-kidaniinao awunuuaakan paꞌatiaaka, aonaa ĩaitapan kanom dauꞌatiꞌo wuruꞌu unaꞌapanuz. ");
INSERT INTO wapNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Baudaꞌapa Jesus tominapa-kidanii, tawuruꞌu umarainpaniaz, Jesus dazaba aꞌo usakanatapan udono. ");
INSERT INTO wapNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ukauꞌan Simon Peter sawaan pakaꞌu uꞌati. “Pupishaa uruu kanom wuruꞌu shaꞌapataꞌo niꞌoraz dikaudaꞌo aimaakan kaikapaꞌa,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Uruꞌu naa umaonapadan pazowau Jesus idaꞌati, naꞌiki ukian, “Naobanai, kanom dauaꞌo manawun wuruꞌu puparadanuz?” ");
INSERT INTO wapNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus kian, “Õdamotan nii bread kaꞌuz uu diꞌiti, udaunaꞌan kanom ati õtaanuzu, uruu wuruꞌu zaamata-kidaꞌo niꞌoraz õgaru.” Uruꞌu naa Jesus zaamatan bread naꞌiki udamotanuzu kaꞌuz uu diꞌiti, utaanuzu Judas ati, Simon Iscariot daniz. ");
INSERT INTO wapNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sariapa Judas zaamatan dono wuruꞌu bread, Satan morotinaꞌakan naa uruu. Uruꞌu naa Jesus kian Judas ati, “Kadiman zoobaba pushaꞌapata wuruꞌu pushaꞌapataꞌazooniaz!” ");
INSERT INTO wapNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Aizii aroopainaouz utuma, aonaa ĩaitapan kanom niꞌo Jesus naꞌapanuz uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas taapan idi ĩpuraatan, baꞌorainao zauda-kidan Jesus dyuudanii utorian aimaakan ĩkaiwaan nii Baokopainapa-kizai ii. Baꞌorainao itiiman, Jesus dyuudanii utaan aimaakan patakaꞌutinainao ati. ");
INSERT INTO wapNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas zaamatan daunaꞌan bread, ukoditaꞌakan naa ĩꞌai paniba iti. Uruu dono amazada marutaꞌakaꞌoraꞌa naa. ");
INSERT INTO wapNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas makoꞌokan daunaꞌan, Jesus kian, “Aizii Daonaiora Aokazi Ikiꞌo umanawunun aida-kaoaꞌa naa wuruꞌu, naꞌiki uruu idaꞌanaꞌo nii Tominkaru umanawunun aidinan. ");
INSERT INTO wapNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aizii Tominkaru umanawunun aidinan an Uruu idaꞌan, ukauꞌan Tominkaru aidan nii pidannao ati naꞌapam Daonaiora Aokazi Ikiꞌo umanawunun. Naꞌiki kaiꞌo niꞌi naa uaidanuz. ");
INSERT INTO wapNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Õdainao, aonaꞌo niꞌi naa õnaꞌan tomunuꞌiki unao tuma. Õkiauzon kawan Jewnao ati, naꞌapa õkian uꞌati aizii: udawatan nii õgaru, mazan aonaa turuu umakon õmakopa-kizi iti. ");
INSERT INTO wapNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ukauꞌan õtaan unao ati paꞌinaꞌo kakinaorii: umarainpaaka. Naꞌapa õmarainpauzon kawan unao, naꞌapa paꞌi manawun umarainpaaka. ");
INSERT INTO wapNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Umarainpaakan an, ipaiꞌo nii pidannao aitapan unao mishiꞌo õpidanannao.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter pishaan uruu, “Naobanai, naꞌitiꞌoram pumakoꞌozon?” Jesus kian uꞌati, “Naꞌitiꞌoram õmakon, aonaa turuu pudaꞌanpan õgaru aizii, mazan pudaꞌanpan nii zii diinaꞌitiꞌi.” ");
INSERT INTO wapNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter kian uꞌati, “Naobanai, kandii nii mazan aonaa turuu õdaꞌanpan pugaru kai? Õgaru turuu õmawakan pugaru dikin ii!” ");
INSERT INTO wapNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus kian uꞌati, “Pukaꞌiita mooko puꞌitiiman pumawakan õgaru dikin ii? Mishiꞌo kaiwuruꞌu õkianuz puꞌati: Kuruku kaꞌaranpan uaꞌii, idikinauꞌo nii pukian pidannao ati aonaa puaitapan õgaru.” ");
INSERT INTO wapNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus kian patominapa-kidaniinao ati, “Aonaa paꞌi unyukunuu ukashaꞌoraꞌanaꞌa! Umishidapa Tominkaru; umishida õgaru kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kainaꞌa iriba kabaun nazoo kida õdaru dapu ii. Ukauꞌan õmakon naa wuruꞌu õsaabaꞌanan naa uwiizi nii. Aonaan an mani unaꞌapan, aonaa mani õkowaadan uꞌati naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aizii õsaabaan daunaꞌan uwiizi nii, õwaꞌatin nii koshan unao dauꞌati, turuu kizi unaꞌian õtuma kapam õnaꞌii-kizi ii. ");
INSERT INTO wapNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Unao, uaitapanii dunapo õmako-kizi itiꞌoraz.” ");
INSERT INTO wapNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aizii Thomas kian uꞌati, “Wanaobanaa, aonaa waaitapan naꞌitiꞌoram pumakoꞌozon. Naꞌapam nii mooko waaitapan dunapo naꞌitiꞌo?” ");
INSERT INTO wapNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus kian, “Õgaru wuruꞌu dunapoz, õgaru wuruꞌu mishiꞌoraz, naꞌiki õgaru wuruꞌu kakupa-kinaiz. Soo õgaru idaꞌan turuu kaawa-karu õdaru diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Aizii unao, uaitapan an õgaru, uaitapan nii õdaru kapam. Aizii wuru diꞌikiꞌi uaitapaꞌa naa naꞌiki utukapaꞌa naa uruu.” ");
INSERT INTO wapNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip kian uꞌati, “Wanaobanaa, putukapa-kida waꞌati puDaru, uruu turuaꞌo nii waꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus kian, “Kotuaꞌiki õmashaapan unao tuma, mazan upuꞌu zii mooko aonaa puaitapan õgaru, mishii Philip? Ipai pidan tukapaꞌoraz õgaru, uruu tukapaꞌo kapam õdaru wuruꞌu. Mazan naꞌapa diꞌi naa kaiwuruꞌu, ‘Putukapa-kida waꞌati puDaru,’ pukianuz? ");
INSERT INTO wapNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aonaa mooko pumishidan, õgaru naꞌiki õDaru, baudaꞌapaꞌo waunao? Kuwai kida õkowaadaniaz unao ati, aonaa õꞌidaꞌaꞌo mani õtoman. ÕDaru, mashaapaꞌoraz õꞌidaꞌa, uruu paꞌan wuruꞌu shaꞌapaapaꞌoraz pakaudin-kizi kida õgaru idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Umishida õgaru naꞌiki õDaru, baudaꞌapaꞌo waunao õkianuz. Oo, umishida paꞌi õDaru shaꞌapataniaz umanawun kidaꞌo aimaakan õgaru idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mishiꞌo kaiwuruꞌu õkianuz: Ipai pidan mishidaꞌo õgaru, ushaꞌapatan nii õshaꞌapaapanii kaduz kida kapam. Naꞌiki ushaꞌapatan nii powaꞌaꞌo zii umanawunun kida, ushaꞌapanum kauꞌan õmakon naa õDaru diꞌiti wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Upishaan an õgaru kanom dauꞌati karikaonan, õpidanannaoun idi unao, õshaꞌapatan nii uꞌati. Naꞌapaꞌo idaꞌanaꞌo nii uDani aida-kidan pidannao ati paDaru umanawunun. ");
INSERT INTO wapNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Upishaan an õgaru kanom dauꞌati karikaonan, õpidanannaoun idi unao; õshaꞌapatan nii uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Umarainpan an õgaru, uizoꞌatipan nii õkakinaori kida. ");
INSERT INTO wapNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Õpishaan nii õDaru naꞌiki utaan nii unao ati baꞌoran Minkaꞌui kakinaotaꞌo nii unao, naꞌiki karikaonanuꞌo nii unaꞌauzon unao tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Uruu Kaimanaꞌo Doronaa tominapa-kidaꞌo nii unao mishiꞌo Tominkaru dauaꞌo. Mazan mamishida-kainao pidannao, aonaa turuu ĩzaamatan uruu paminkaꞌu nii, ushaꞌapanum kauꞌan aonaa ĩtukapan naꞌiki aonaa ĩaitapan uruu. Mazan unao, uaitapa paꞌan uruu, ushaꞌapanum kauꞌan, kainaꞌaꞌo uruu unao tuma, naꞌiki karikaonanuꞌo nii unaꞌauzon unao idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Aonaꞌo nii õwaꞌakan unao, maudaniiwai waꞌaka-kao kawan; õkaawan nii powaa ati uꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kadimanaꞌo niꞌi naa pidannao matukapakan õgaru. Mazan unao utukapan nii paꞌan, ushaꞌapanum kauꞌan õkakupan nii powaa iti koshan, ukauꞌan unao ukakupan nii kapam õkakupan idi. ");
INSERT INTO wapNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aizii uruu dono, uaitapan nii õgaru naꞌiki õdaru baudaꞌapaꞌo waunao. Aizii unao naꞌiki õgaru, naꞌapaꞌo manawun baudaꞌapaꞌo pidan kawan. ");
INSERT INTO wapNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Naꞌiaꞌoram pidan abataꞌo naꞌiki izoꞌatipaꞌo õkakinaori kida, uruu wuruꞌu marainpaꞌoraz õgaru. Õdaru marainpan nii pidan marainpaꞌoraz õgaru; aizii õgaru, õmarainpan nii uruu kapam naꞌiki õaitapa-kidinan nii uꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas kian uꞌati (aonaa Judas Iscariot mani), “Naobanai, naꞌapam nii puaidan pumanawunun waunao ati karikaonan, baꞌorainao ati aonaꞌo nii mooko puaida-kidan?” ");
INSERT INTO wapNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus kian uꞌati, “Pidan marainpaꞌo õgaru, uizoꞌatipan nii õparadan, naꞌiki õDaru marainpan nii uruu. Wawaꞌatin nii uruu idaꞌati naꞌiki wamashaapan nii utuma. ");
INSERT INTO wapNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mazan naꞌiaꞌoram pidan aonaꞌo umarainpan õgaru, aonaa uizoꞌatin õparadan kida. Wuruꞌu kuwai kidaz, unao abataniaz, aonaa õtomanii mani karikaonan, õDaru paꞌan wuruꞌu dyuudaꞌoraz õkakuwaapan naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Õkowaadan uꞌati kaikapa kidaꞌoraꞌa õnaꞌan puꞌu zii utuma. ");
INSERT INTO wapNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Wuruꞌu Minkaꞌui, Kaimanaꞌo Doronaaz, õDaru dyuudan niꞌoraz uꞌidaꞌati õgaru aipan ati; uruꞌo nii paꞌan tominapa-kida unao ipai õkuwaa kida dauꞌu, naꞌiki unyukunuu-kidan nii unao ati ipai daunuudaꞌu wuruꞌu õkuwaa kidaz. ");
INSERT INTO wapNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Õwaꞌakan unao tuma kaimanaꞌo nyukunui; soo õgaru turuu õtaan naꞌapaꞌo. Aonaa daꞌi sannao taan kawanuꞌo mani õtaan nyukunui kaimanan. Aonaa paꞌi unyukunuu kashaꞌoraꞌanaꞌa oo utariidinaꞌanaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Õkowaadanii shaꞌatii uꞌati, ‘Õmakon niꞌi naa õdaru diꞌiti, mazan õkaawan nii koshan powaa ati.’ Umishiin an mani umarainpan õgaru, ukonaukii mani õmakon idiꞌi naa õDaru diꞌiti, ushaꞌapanum kauꞌan umanawunuꞌo õgaru ai wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Õkowaadan naa uꞌati kai kanomaꞌo nii shaꞌapa, ushaꞌapan uaꞌii zii; aizii ushaꞌapan donoꞌo naa uaitapan nii õkuwaa mishiin. ");
INSERT INTO wapNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aonaꞌo niꞌi naa õparadinan tomunuꞌiki utuma, ushaꞌapanum kauꞌan waꞌatiꞌi naa wuruꞌu diꞌoraꞌa amazada baaraꞌaꞌoraz naobanai. Mazan aonaa ukaꞌiitan pamashaatan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Mazan õshaꞌapata paꞌan ipai aimaakan õdaru dyuudan kawanaꞌati õgaru, pidannao aitapa-kinaa nii mishiꞌo õmarainpan uruu. “Aizii, wamakoꞌo naa.” ");
INSERT INTO wapNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Õgaru wuruꞌu mishiꞌoraz paoribai kadunaa, naꞌiki õDaru saabaapauzo paoribai baawu. ");
INSERT INTO wapNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ipaiꞌo nii udukutan paoribai waoda kida aonaꞌoraz ĩkaakan. Mazan kaakaꞌoraz kida usaabaan nii paꞌan, aonaa kizi kazamakaꞌo nii ukaduꞌu, naꞌiki madowaaka kizi koshan ukaakan. ");
INSERT INTO wapNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Unao, saabaaꞌaka-kariwaiꞌi naa õkuwaa idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pakawan paꞌi uzaamatinapa õꞌidaꞌati, õzaamatinpan nii uꞌidiꞌiti kapam. Aonaa paoribai waoda kaakan paaipan ati karikaonan, soo uzaamatinpan an pakadunaa idaꞌati. Unao naꞌapaꞌo kapam, aonaa ukaꞌiitan ushaꞌapatan kaimanaꞌo aimaakan uaipan ati karikaonan. Soo uzaamatinpan an õꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Õgaru wuruꞌu paoribai kadunaaz. Aizii unao, uwaoda kida kawanuꞌo. Pidannao, karikaonanuꞌoraz ĩnaꞌan õꞌidaꞌa, õgaru naꞌapa õnaꞌan nii ĩꞌidaꞌa, ĩnao shaꞌapatan niꞌi naa dobata kaiman kidaꞌo aimaakan. Unao, aonaa ukaꞌiitan ushaꞌapatan aimaakan uꞌidaꞌa karikaonan, soo õkaminkaꞌutan an unao. ");
INSERT INTO wapNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mazan pidan aonaꞌoraz unaꞌan õꞌidaꞌa, uawuꞌuta-kao niꞌi naa, naꞌiki umaririn niꞌi naa amazada ii, naꞌapa paoribai waoda awuꞌuta-kariwai maririn kawan. Udaunaꞌan ukasabaꞌuka-kao naꞌiki ukaboota-kaoaꞌa naa tikazi wuꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mazan unao, unaꞌan an pakawan õꞌidaꞌa, naꞌiki umishidapan an õparadan kida, turuu utoriinpan kanom dauꞌati karikaonan, naꞌiki utaa-kao nii uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kaikapaꞌo idaꞌanaꞌo wuruꞌu õDaru umanawunun aida-kida-kaoaz: Unao shaꞌapaapan idaꞌan dobata kaiman kidaꞌo aimaakan, naꞌiki naꞌapaꞌo idaꞌan utukapa-kidinan õpidanannao unao. ");
INSERT INTO wapNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Naꞌapa õDaru marainpan kawan õgaru, naꞌapa õmarainpan kapam unao. Uzaamatinapa pakawan õꞌidaꞌati, õmarainapa kizi unao. ");
INSERT INTO wapNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Uizoꞌatipan an õkakinaori kida, pakawanuꞌo nii õmarainpan unao, naꞌapa õizoꞌatipan kawan õDaru kakinaori kida, naꞌiki pakawan umarainpan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Õkowaadan uꞌati ipai kaikapa kidaꞌoraꞌa, unao konaukii kizi naꞌapa manawun õgaru konaukian kawan, naꞌiki aonaa kizi kanom towaudaꞌuan ukonaukian. ");
INSERT INTO wapNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Aizii kaikapa õkakinaoriꞌi, umarainpaaka, naꞌapa manawun õmarainpan kawan unao. ");
INSERT INTO wapNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aonaa naꞌiaꞌoram pidan kamarainpanuꞌo powaꞌa zii wuru aiaꞌa, pidan kashaapaꞌoraz pazowii-kao papaonarunao kazannaatin-kinaa nii. ");
INSERT INTO wapNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Õpaonarunao unao, uizoꞌatipan an õkakinaori kida. ");
INSERT INTO wapNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aonaꞌa naa õdakotan unao õpoitorunao nii, ushaꞌapanum kauꞌan poitorui, aonaa uaitapan naꞌapaꞌoram panaobanaa shaꞌapainpan. Mazan õdakotan unao õpaonarunao nii, ushaꞌapanum kauꞌan ipai õkowaadan uꞌati õabatanii kida õDaru diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aonaa uaipan atiꞌo mani uzaamatinan õꞌidaꞌati; õgaru aipan atiꞌo paꞌan unao zaamatinan. Ukauꞌan õgaru aipan atiꞌo unao makon ushaꞌapataꞌanan dobata kaiman kidaꞌo aimaakan. Naꞌiki karikaonan kizi ushaꞌapaapan naꞌapaꞌo aimaakan. Uzaamatinpan idi õꞌidaꞌati, õDaru taan nii unao ati kanom karikaonan upishaan an uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ukauꞌan kaikapa õkakinaori unao atiꞌi: ‘Umarainpaaka.’ ");
INSERT INTO wapNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pidannao toꞌora-kizaitapan an unao, unyukunuitapa naꞌapaꞌo ĩtoꞌora-kizaitapauzon õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Umashaapan an mani naꞌapa imiꞌi baara sannao mashaapan kawan, ĩmarainapa mani unao pairibannao nii. Mazan õaipanaꞌatiꞌo uzaamatinan õꞌidaꞌati. Ukauꞌan, aonaa imiꞌi baara sannaouꞌu naa mani unao; uruu idiꞌo pidannao toꞌora-kizaitapan unao. ");
INSERT INTO wapNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Udiꞌitapa õkianuz uꞌati kaikapaꞌa: ‘Aonaa naꞌiaꞌoram poitorui umanawunun panaobanaa ai.’ Kainaꞌa antamikitainao õgaru, naꞌapaꞌo nii ĩantamikitan unao kapam; mazan kainaꞌa baꞌorainao izoꞌatiꞌo õparadan, ukauꞌan naꞌapaꞌo nii ĩizoꞌatin uparadan kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Pidannao shaꞌapatan nii unao naꞌapa, ushaꞌapanum kauꞌan uzaamatinpan idiꞌo õꞌidaꞌati. Mazan ĩnao, aonaa ĩaitapauzon wuruꞌu dyuudaꞌoraz õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aonaan an mani õkaawan daꞌatiꞌi naꞌiki aonaan an mani õkakuwaapan ĩꞌati, aonaa mani ĩꞌoian kainaabatinan padamata. Mazan aizii, ‘aonaa waaitapan oiaꞌo wuruꞌu naꞌapaꞌoraz,’ aonaa turuu ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pidan toꞌora-kizaitapaꞌo õgaru, ĩtoꞌora-kizaitapan õDaru kapam wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Aonaan an mani õshaꞌapatan ĩawun zaꞌa ĩmatukapauzokanii pidan shaꞌapatan kida, aonaa mani padamata ĩꞌoian kainaabatinan. Mazan aizii, ĩtukapaniꞌi naa õshaꞌapatan naꞌapaꞌo, mazan upuꞌu zii ĩtoꞌora-kizaitapan baokopa waunao, õgaru naꞌiki õDaru. ");
INSERT INTO wapNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mazan naꞌapaꞌo idaꞌan, ĩkakinaorinaa mishiinan: ‘Ĩtoꞌora-kizaitapan õgaru madiwautapaka karikaonan,’ kiaꞌoraz usaadinpan. ");
INSERT INTO wapNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Kaawaꞌo nii Minkaꞌui, uruu Kaimanaꞌo Doronaa, uruu kainaabataꞌo mishiꞌo kuwai Tominkaru dauaꞌo. Õdyuudan nii uwaꞌatin õDaru diꞌiki unao idaꞌati, naꞌiki uruꞌo nii kakuwaapa õdauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aizii unao, ukakuwaapan nii õdauꞌu kapam, ushaꞌapanum kauꞌan unao naꞌaꞌo õtuma õsakadinan diꞌiki õtominapatin-kidan pidannao. ");
INSERT INTO wapNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Õkowaadaniꞌi naa uꞌati kaikapa kidaꞌoraꞌa, uruu aonaa kizi umuudinaꞌakan umishidapan ai. ");
INSERT INTO wapNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Uiribannao kashanauan nii unao synagogue kida iki, uchoochiipan ai ĩtuma. Naꞌiki kainaꞌaꞌo niꞌi naa kamoo kaawan, uruu dono pidannao zowian an unao, ĩꞌitiiman kaimanaꞌo nii aimaakan wuruꞌu pashaꞌapataniaz Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pidannao shaꞌapatan nii unao naꞌapa, ushaꞌapanum kauꞌan aonaa ĩaitapauzon õDaru, oo õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mazan õkowaadaniꞌi naa uꞌati kaikapa kidaꞌoraꞌa. Ukauꞌan uruu kamoo kaawan donoꞌo naa, unyukunuitapan nii õkuwaa naꞌapa kidaꞌo dauaꞌoraz. Õsakadinan diꞌiki õtominapa-kidan unao, aonaa õkowaadauzon uꞌati naꞌapa kidaꞌo, ushaꞌapanum kauꞌan õnaꞌan idi zii utuma. ");
INSERT INTO wapNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Mazan aizii õkiwan niꞌi naa powaa iti dyuudaꞌoraz õgaru diꞌiti. Mazan aonaa naꞌiaꞌoram zoobaba unao pishaan õgaru naꞌitiꞌoram wuruꞌu õmakoꞌozoonuz. ");
INSERT INTO wapNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Õkowaadan idi zii uꞌati kaikapaꞌoraꞌa, uruu idi unyukunuu kashaꞌoran naa. ");
INSERT INTO wapNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mazan mishiꞌo kaiwuruꞌu õkianuz: Aonaꞌo nii Minkaꞌui kaawan uꞌidaꞌati, soo õmakon an. Ukauꞌan kaimanaꞌo nii manawun unao ati wuruꞌu õmakonuz. Mazan õmakon an, õdyuudan niꞌi naa uruu unao idaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aizii ukaawan dono, ukainaabatan nii pidannao ati naꞌapaꞌoram manawun oiaꞌo; naꞌiki, naꞌapaꞌoram manawun ĩdiꞌitapan kaimanaꞌo; naꞌiki naꞌapaꞌoram manawun ĩdiꞌitapan Tominkaru kowaadan oiaꞌo patakaꞌuta-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Panaꞌiti karikaonan ĩdiꞌitapan oiaꞌo, ushaꞌapanum kauꞌan aonaa ĩmishidaꞌazon õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Panaꞌiti karikaonan ĩdiꞌitapan kaimanaꞌo, ushaꞌapanum kauꞌan õmakon nii powaa iti õDaru diꞌiti, naꞌiki aonaꞌo nii powaꞌa utukapan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Naꞌiki panaꞌiti karikaonan ĩdiꞌitapan patakaꞌutin-karu, ushaꞌapanum kauꞌan Tominkaru patakaꞌutaniꞌi naa naobanai diꞌoraꞌa amazada baaraꞌaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kainaꞌa dobata zii õkowaadaꞌazoonii uꞌati padamata, mazan dobataꞌo niꞌi naa manawun wuruꞌu õkuwaaz, aonaꞌo nii ukaꞌiitanuz. ");
INSERT INTO wapNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mazan Kaimanaꞌo Doronaa kaawan nii, uruu mishiꞌo ukuwaa Tominkaru dauaꞌo. Uruu aipan atiꞌo niꞌi naa uaitapan mishiꞌo kuwai Tominkaru diꞌikiꞌo. Aonaꞌo nii ukakuwaapan paꞌidaꞌa karikaonan, mazan ukakuwaapan nii paabatanii dauꞌu, naꞌiki ukowaadan nii unao ati kanom kidaꞌo nii shaꞌapa diinaꞌitiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Uruꞌo nii kainaabata õmanawunun, ukowaadan idaꞌan kanom dii õgaru, naꞌiki naꞌapaꞌoram wuruꞌu õkuwaaz. ");
INSERT INTO wapNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Õkowaadauzon ipai aimaakan õDaru dauꞌu, aizii naꞌapaꞌo nii kapam Kaimanaꞌo Doronaa kowaadan uꞌati ipai õgaru dauꞌan, naꞌiki naꞌapam õkiauzon.” ");
INSERT INTO wapNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesus kian, “Masakaudaꞌu daunaꞌan aonaꞌo niꞌi naa utukapan õgaru powaꞌa, mazan masakaudaꞌu uruu daunaꞌan utukapan nii õgaru koshan.” ");
INSERT INTO wapNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aizii kainaꞌa utominapa-kidaniinao bii ikiꞌo, ĩkian pairiban ati kida, “Naꞌapaꞌoram dauꞌatiꞌo ukianuz, ‘Masakaudaꞌu daunaꞌan aonaꞌo niꞌi naa utukapan õgaru powaꞌa, mazan masakaudaꞌu uruu daunaꞌan utukapan nii õgaru koshan;’ naꞌiki naꞌapaꞌoram dauꞌatiꞌo dii, ‘ushaꞌapanum kauꞌan õmakon naa powaa iti wuruꞌu õDaru diꞌiti,’ ukianuz?” ");
INSERT INTO wapNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aonaa ĩmashaadan ĩpishautaakan, “Naꞌapaꞌoram dauꞌatiꞌo dii wuruꞌu, ‘Masakaudaꞌu daunaꞌan,’ ukianuz? Aonaa waaitapan kanom dauaꞌo ukadakotinan,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus aitapa ĩpishaaꞌazon paugaru, uruu idi ukian ĩꞌati, “Õkian kaikapaꞌa: ‘Masakaudaꞌu daunaꞌan aonaꞌo niꞌi naa utukapan õgaru, mazan masakaudaꞌu uruu daunaꞌan utukapan nii õgaru koshan.’ Mishii, uruu dauꞌatiꞌo upishautaakan? ");
INSERT INTO wapNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mishiꞌo kaiwuruꞌu õkianuz uꞌati: Uzaadan nii naꞌiki diiwaꞌo nii umuraapan, baꞌorainao konaukian puꞌu. Kiwiin zii ukashaꞌoran nii, mazan uruu daunaꞌan ukonaukian nii. ");
INSERT INTO wapNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Zuna kaudanipaꞌazon dono, kashaꞌora kowas onyukunuu okaziwapan kamoo kaawan idiꞌi naa, mazan okaudanipan daunaꞌan, aonaꞌa naa onyukunuitapan pakaziwapauzon. Soo okonaukian naa paꞌan, ushaꞌapanum kauꞌan koraidaonaa sodi shakatan idi. ");
INSERT INTO wapNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Naꞌapaꞌo kawanuꞌo wuruꞌu unao baiaapaniaz: kai unyukunuu kashaꞌora-kida, mazan õtukapan nii koshan daꞌi unao, naꞌiki uruu dono ukonaukian nii, naꞌiki aonaꞌo nii kanom mashaatan ukonaukiitinan. ");
INSERT INTO wapNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Aizii uruu dono, aonaꞌo niꞌi naa kanom nii upishaan zii õgaru aimaakan dauꞌati. Mishiꞌo kaiwuruꞌu õkianuz uꞌati: Upishaan an õDaru kanom karikaonan dauꞌati, utaan nii uꞌati õpidanannaoun idi unao. ");
INSERT INTO wapNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Aonaa zoobaba upishaan uruu kanom karikaonan dauꞌati, õpidanannaoun idi unao. Upishaa, Tominkaru taan nii uꞌati upishaanii. Uruu kaimanaiman kizi ukonaukiitinan. ");
INSERT INTO wapNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Õkakuwaapauzon uꞌati diꞌitinapa-kinai kuwai idaꞌan diꞌoraꞌa aimaakan kida dauꞌaꞌa. Mazan kainaꞌaꞌo niꞌi naa kamoo kaawan, aizii uruu dono aonaꞌo niꞌi naa õkakuwaapan powaꞌa diꞌitinapa-kinai kuwai idaꞌan, mazan õparadan nii sariapa kizi pidannao uaitapan õkuwaa õdaru dauaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Uruu dono, turuaꞌo niꞌi naa upishaan uruu aimaakan dauꞌati, õꞌuu idaꞌan, õpidanannaoun idi unao; aonaa kanom nii õpishaan zii õDaru unao ati, ");
INSERT INTO wapNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ushaꞌapanum kauꞌan, õDaru marainapanii unao. Umarainpan unao, ushaꞌapanum kauꞌan unao marainpan idiꞌo õgaru, naꞌiki unao mishidan idi uruu diꞌikiꞌo õwaꞌatin. ");
INSERT INTO wapNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mishi, õwaꞌatin õDaru diꞌikiꞌo, imiꞌi baara ati. Aizii õmakon niꞌi naa imiꞌi baara iki, õkiwan naa õDaru diꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Uruꞌu naa utominapa-kidaniinao kian uꞌati, “Aizii, uruu zii puparadan kainaabatinan, aonaa pukaiwaan diꞌitinapa-kinai kuwai. ");
INSERT INTO wapNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aizii watukapa, puaitapa mishi ipai aimaakan; turuu pudakoꞌatin pupishaa-kao uaꞌii zii aimaakan dauꞌati. Ukauꞌan aizii wamishida puwaꞌatin Tominkaru diꞌiki.” ");
INSERT INTO wapNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus kian ĩꞌati, “Uruu zii umishidan? ");
INSERT INTO wapNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kainaꞌiki kamoo waꞌatin, aizii uruu kamoꞌo naa wuruꞌu kaawaꞌoraz, uruu dono panaꞌitinapu kidaꞌo nii umakoodanainan, ukidoopan nii õꞌai udapu iti kida, uwaꞌakan nii õgaru õbaꞌorantin. Mazan aonaa õbaꞌorantinaꞌo manawun mani õgaru, ushaꞌapanum kauꞌan õDaru karikaonanuꞌo unaꞌauzon õtuma. ");
INSERT INTO wapNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Õkowaadan unao ati aimaakan kaikapa kidaꞌoraꞌa, unyukunuu konaukii-kinaa nii, uzaamatinpan idi õꞌidaꞌati. Diꞌoraꞌa amazada baaraꞌaꞌa, ubaiaapan nii kashaꞌoraꞌo. Mazan umaꞌozakadapa unyukunuu! Õgaru, õwazootaniꞌi naa diꞌoraꞌa amazada baaraꞌaꞌo kashaꞌora kidaꞌo aimaakan!” ");
INSERT INTO wapNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus kakuwaapan daunaꞌan patominapa-kidaniinao ati, uawunuupan doko iti naꞌiki uruꞌu naa utoriinpan. “ÕDaru, aizii kaawaꞌa naa kamoo. Putukapa-kida pidannao ati puDani umanawunun, utukapa-kida kizi ĩꞌati pumanawunun kapam. ");
INSERT INTO wapNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pugaru aipan atiꞌo ukazowautapan ipai pidannao, utaa kizi karikaonanuꞌo kakupa-karu ipai wunao atiꞌi, puzaamatin-kidaniinaouz uꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kaikapaꞌo wuruꞌu karikaonanuꞌoraz kakupa-karu ikoda-kao: pidannao aitapan idaꞌan soo baudaꞌapa pugaru mishiꞌo Tominkaru, naꞌiki ĩaitapan idaꞌan õgaru, Jesus Christ, pudyuudaniaz imiꞌi baara ati. ");
INSERT INTO wapNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Õtukapa-kidaꞌa naa imiꞌi baaraꞌaꞌo pidannao ati pugaru umanawunun, õshaꞌapatan idaꞌan ipai pudyuudanii õshaꞌapatan. ");
INSERT INTO wapNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Õdaru, marii õtukapa-kao umanawunuꞌo nii aizii, naꞌapa õtukapauzo-kao kawan pugaru tuma amazada tominan uaꞌii zii. ");
INSERT INTO wapNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Õaitapa-kidaniꞌi naa pukaduz wunao atiꞌi, putaaniinaouz õꞌati diꞌoraꞌa amazada baara ainao bii iki. Pupidanannao ĩdyaun naꞌiki putaaniinao õꞌati ĩdyaun, naꞌiki ĩizoꞌatipa pukakinaori. ");
INSERT INTO wapNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aizii ĩaitapaꞌa naa, ipai aimaakan putaanii õꞌati, pugaru diꞌikiꞌo wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Õkowaadaꞌa naa pukuwaa ĩꞌati, naꞌiki ĩzaamata kaimanaiman panyukunuu itiz. Ĩaitapa õwaꞌatin pugaru diꞌikiꞌo naꞌiki ĩmishida pudyuudanii õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Aonaa õtoriinpan ipai pidannao ati, mazan õtoriinpan wunao atiꞌi putaaniinaouz õꞌati, ushaꞌapanum kauꞌan pupidanannao paꞌan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ipai õpidanannao, pupidanannao kapam ĩdyaun. Ukauꞌan ipai pupidanannao õpidanannao kapam ĩdyaun. Ĩnao idaꞌanaꞌo nii õmanawunun aitapa-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aizii, aonaꞌo niꞌi naa õnaꞌan imiꞌi baaraꞌa, kadimanaꞌo niꞌi naa õmakon puꞌidiꞌiti. Mazan õpidanannao, ĩnaꞌan nii zii imiꞌi baaraꞌa. ÕDaru, kaimanaꞌo manawun, pukazannaatapa paꞌi wunaouꞌu putaapa-kidaniinaouz õꞌati. Ĩnyukunuu patumaaka kizi paꞌatiaaka, pugaru naꞌiki õgaru nyukunuu patumaakan kawan. ");
INSERT INTO wapNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Õnaꞌan dono zii ĩtuma imiꞌi baaraꞌa, õkazannaatapa ĩdyaun, pakawan kizi ĩmashaapan pupidanannao nii. Õkazannaatapa ĩdyaun, aonaa naꞌiaꞌoram waziwadinan, soo baudaꞌapa pidan waziwadinaꞌo niꞌoraz aita-kao, naꞌapaꞌo idaꞌan kizi saada-kariwaiz kida puparadan mishiinan. ");
INSERT INTO wapNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Aizii kadimanaꞌo niꞌi naa õmakon puꞌidiꞌiti. Õtoriinpan ĩꞌati kaikapaꞌa õnaꞌan puꞌu zii ĩtuma imiꞌi baaraꞌa, ĩnyukunuu konaukii kizi kaimanaiman naꞌapa õnyukunuu konaukian kawan manawun. ");
INSERT INTO wapNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Õkowaadaꞌa naa pukuwaa ĩꞌati, naꞌiki uruu idi baꞌoran pidannao kashanau-kidan ĩdyaun. Ĩkashanau-kida-kao, ushaꞌapanum kauꞌan õgaru kawanuꞌo ĩdyaun, aonaa ĩdiꞌitinpan baꞌorainao diꞌitinpan kawan. ");
INSERT INTO wapNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Õtoriinpan, aonaa õaipan mani pusoꞌotan ĩdyaun diꞌoraz amazada baara ikiꞌi, mazan õpishaan paꞌan pukazannaatapan ĩdyaun Satan ai. ");
INSERT INTO wapNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Õgaru, aonaa õdiꞌitinpan imiꞌi baara sannao diꞌitinpan kawan. Ĩnao naꞌapa kapam ĩdiꞌitinpan õgaru kawan, aonaa imiꞌi baara sannao kawan mani. ");
INSERT INTO wapNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pusaabaa ĩdyaun puꞌidiwaunao nii, puaitapa-kidan idaꞌan ĩꞌati mishiꞌo manawun puparadan. Puparadan, uruu mishiꞌo manawun. ");
INSERT INTO wapNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pudyuudan kawan õgaru imiꞌi baara ati, naꞌapa õdyuudan ĩnao kapam amazada kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kaimanaiman õtaainan puꞌati ĩnao dikin ii, turuu kizi ĩnao kapam taainan kaimanaiman puꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Aonaa ĩnao ati mani karikaonan õtoriinpan, mazan õtoriinpan baꞌorainao ati kapam, mishidainao niꞌoraz õgaru, paabatan idaꞌan õdauaꞌo kuwai õpidanannao idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Õtoriinpan ĩꞌati, marii kizi ĩbaudaꞌapatan panyukunuu, naꞌapa pugaru naꞌiki õgaru baudaꞌapatapan kawan wanyukunuu. ÕDaru, naꞌapa pugaru baudaꞌapatinpan õgaru idaꞌati, naꞌiki õgaru baudaꞌapatinpan pugaru idaꞌati, naꞌapa kizi ĩnao baudaꞌapatinpan waunao idaꞌati, pidannao mishida kizi pugaru wuruꞌu dyuudaꞌoraz õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Õtaanii umanawun-karu ĩꞌati naꞌapa putaan kawan õꞌatiz, marii kizi ĩbaudaꞌapatapan panyukunuu, naꞌapa pugaru naꞌiki õgaru baudaꞌapatapan kawan wanyukunuu. ");
INSERT INTO wapNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kainaꞌa ĩnyukunuu ii õgaru; naꞌiki kainaꞌa õnyukunuu ii pugaru. Marii kizi kaimanaiman ĩbaudaꞌapatapan panyukunuu, baꞌoran pidannao aitapa-kinaa nii, pugaru wuruꞌu dyuudaꞌoraz õgaru. Naꞌiki pumarainapanii mishidainaouz õgaru naꞌapa pumarainpan kawan õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ÕDaru, naꞌiam õgaru, naꞌii õaipan õtuma wuruꞌu putaaniinaouz õꞌati, ĩtukapa kizi õmanawunun, wuruꞌu putauzoniaz õꞌati pumarainpan idi õgaru amazada tominan uaꞌii. ");
INSERT INTO wapNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kaimanaꞌo manawun õdaru, aonaa pidannao aitapauzon pugaru. Mazan õgaru, õaitapanii pugaru, naꞌiki õtominapa-kidaniinao ĩaitapa pudyuudanii õgaru. ");
INSERT INTO wapNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Õkainaabataniꞌi naa ĩꞌati kanom kaduz pugaru, naꞌiki karikaonanuꞌo nii õkainaabaapan ĩꞌati kanom kaduz pugaru. Ĩmarainpaaka kizi naꞌapa pumarainpan kawan õgaru, turuu kizi õzaamatinpan ĩnao diꞌiti kapam.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus toriinpan daunaꞌan paDaru ati, umakon naa patominapa-kidaniinao tuma Kidron Waꞌo baza itinapu. Kainaꞌaꞌo daꞌi paoribai baawu naꞌii, naꞌitiꞌi naa Jesus morotan patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, kaakapaꞌo niꞌoraz uruu tarubainao ati, uaitapanii kapam uruu amazada, ushaꞌapanum kauꞌan, naꞌitiꞌo Jesus makouzon patominapa-kidaniinao tuma. ");
INSERT INTO wapNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ukauꞌan naꞌitiꞌi naa Judas makon, unaꞌakan baudaꞌapa utonazinaa soldyaanao. Naꞌiki watchmantapainao Tominkaru Dapu bii ikiinao kapam, ĩnao faadaanao zowaunaanao naꞌiki Phariseenao dyuudaniinao. Ĩnaꞌakapanii mizaataaka-kinai kida. Aizii baꞌorainao ĩnaꞌakapanii palampan kida. ");
INSERT INTO wapNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus aitapaniꞌi naa naꞌapam nii ĩshaꞌapaapan paugaru. Uruu idi uwaꞌatiꞌikan ĩꞌidaꞌati, naꞌiki ukian ĩꞌati, “Kanom uaipan?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Jesus, Nazareth san,” ĩkian uꞌati. “Õgaru uruu,” Jesus kian ĩꞌati. (Judas, kaakapaꞌoraz uruu, naꞌiaꞌa naa ĩtuma.) ");
INSERT INTO wapNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Õgaru uruu,” Jesus kian idi ĩꞌati, sariapa ĩdandanaaꞌakan, naꞌiki ĩdorautan imiꞌi baara iti. ");
INSERT INTO wapNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Powaꞌa koshan Jesus pishaan ĩdyaun, “Kanom uaipan?” “Jesus, Nazareth san,” ĩkian uꞌati koshan. ");
INSERT INTO wapNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus kian ĩꞌati, “Õkii shaꞌatii uꞌati, ‘Õgaru uruu.’ Umishiin an õgaru udawatapan, ukauꞌan marinaꞌa wunaouꞌu õtumainaouz.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ukian ĩꞌati naꞌapa, uparadan mishiin-kinaa niꞌo utoriinpan donoꞌoraz. “Õdaru, aonaa baudaꞌapa õwaziwaan wuruꞌu putaaniinaouz õꞌati,” ukianuz.) ");
INSERT INTO wapNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aizii Simon Peter, unaꞌakapanii marii. Usoꞌotaꞌakan pakinnaa aiazu, naꞌiki saꞌukan Umanawunuꞌo Faadaa poitoru tain diwaꞌora antanpuꞌo, waotaꞌaka. Malchus kiaꞌo uꞌuu wuruꞌu poitoruiz. ");
INSERT INTO wapNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus kian Peter ati, “Pushakada pumarian powaa iti pakinnaa zoꞌiti! Puꞌitiiman aonaꞌo nii õbaiaapaꞌazon kashaꞌoraꞌo, õdaru taaniaz õbaiaapan nii?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aizii, soldyaanaouz naꞌiki ĩzowaunaa, naꞌiki watchmantapainao Tominkaru Dapu, ĩzaamataꞌakan naa Jesus naꞌiki ĩdoꞌotaꞌakan naa ukaꞌu kida. ");
INSERT INTO wapNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ĩnaꞌakan uruu Annas diꞌiti kiwiin zii. Annas, uruu Caiaphas imadokozu. Aizii Caiaphas, uruu Umanawunuꞌo Faadaa uruu dono, ");
INSERT INTO wapNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","naꞌiki uruu kiaꞌoraz kiwiin zii Jewnao zowaunaanao ati kaikapaꞌa: “Kaimanaꞌo nii manawun baudaꞌapaꞌo pidan mawakan an ipai pidannao dikin ii.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter, naꞌiki baꞌoran Jesus tominapa-kidanii, ĩdaꞌanpan Jesus. Aizii baꞌoraniz, uruu kaimanaimanaꞌo Umanawunuꞌo Faadaa aitapan. Ukauꞌan morota kootowapa-kizai iti uruu Jesus tuma, Umanawunuꞌo Faadaa dapu iti. ");
INSERT INTO wapNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mazan Peter, unaꞌian paniinom ii, aonaa umorotan. Aizii, baꞌoraniz Jesus tominapa-kidanii, kaimanaimanaꞌoraz Umanawunuꞌo Faadaa aitapan, umakoꞌokan powaa iti naꞌiki uparadaꞌakan zunaaba ati, awunuutapaibaz paniinom, naꞌiki uruꞌu naa umorota-kidan Peter. ");
INSERT INTO wapNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aizii zunaaba, awunuutapaibaz paniinom, okian Peter ati, “Pugaru õaitapan diidiꞌiaꞌoraꞌa pidan tominapa-kidanii kapam?” “Aonaa,” Peter kian oꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aizii poitoruinao naꞌiki watchmantapainao, ĩpuꞌukada niꞌi naa tikazi naꞌii, amazada wadidin idi, uruu naꞌiaꞌa naa ĩkadishitapan ĩtanaapan kida. Peter naꞌii kapam ukadishitapan utanaapan ĩtuma. ");
INSERT INTO wapNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Uruꞌu naa Umanawunuꞌo Faadaa pishaan Jesus, “Kanomnao putominapa-kida nii? Kanom dauaꞌo putominapa-kidan ĩdyaun?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus kian uꞌati, “Karikaonan õkakuwaapan, turuu kizi ipai pidannao abatan õkuwaa. Karikaonan õtominapa-kidan pidannao synagogue ii, naꞌiki Tominkaru Dapu ii. Aonaa naꞌapainim õdizapan õkuwaa pidannao ai. ");
INSERT INTO wapNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kanom nii pupishaan õgaru? Pupishaa pidannao abatainao naꞌapam õkian. Ĩnao, ĩaitapa naꞌapaꞌoram õkiauzon.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus paradan idi naꞌapa, baudaꞌapa watchman udazaba aꞌo kadishitapan, utaꞌikaꞌakan naa Jesus paawun baara ati. Ukian Jesus ati, “Kanom dyuudan pudakoꞌatin Umanawunuꞌo Faadaa paradan naꞌapa.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus kian uꞌati, “Puaitapan an õparadan pozawatan, pukowaada ipai daꞌainao pidannao atiꞌi. Mazan puaitapan an õparadan sakitapan, kanom niꞌi naa putaꞌikaꞌakan õgaru?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Udaunaꞌan Annas dyuudan unaꞌaka-kao Caiaphas diꞌiti, Umanawunuꞌo Faadaa, pakawan ukaꞌu kida doꞌotinpan. ");
INSERT INTO wapNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Aizii Peter, pakawan zii ukadishitapan naꞌii utanaapan, uruꞌu naa upishaa-kao koshan, “Aonaa pugaru mani kapam utominapa-kidaniinao tumaꞌoraz, mishii?” “Aonaa,” Peter kian. ");
INSERT INTO wapNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Naꞌaꞌo pidan, uruu kapam Umanawunuꞌo Faadaa poitoru, naꞌiki uruu iriban tawuruꞌu Peter saꞌukaniaz utain; ukian Peter ati, “Aonaa mooko pugaru mani tawuruꞌu õtukapaniaz utuma paoribai baawu ii, mishii?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","“Aonaa,” Peter kian koshan. Unaꞌapan daunaꞌan, uruꞌu naa kuruku kaꞌaranpaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wakankanaanin Jesus naꞌaka-kaoaꞌa naa Caiaphas diꞌiki, Romannao dapunaa itiꞌi naa. Aizii Jewnao, aonaa ĩmorotan Romannao dapunaa iti, ushaꞌapanum kauꞌan aonaa ĩkaniribainaꞌazon pakakinaorinaa kian kawanaꞌati, turuu kizi ĩaroopan Passover Kamoon dono. ");
INSERT INTO wapNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Uruu idi, Pilate koditan ĩꞌidaꞌati naꞌiki upishaan ĩdyaun, “Kanom mooko oiaꞌo nii diꞌoraꞌa pidan shaꞌapatan, ukootowapa-kida-kinaa niizu?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aizii ĩkian uꞌati, “Uruu dikintapauzo kakinaorii, unaꞌapan idiꞌo wanaꞌakan uruu puꞌidaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate kian ĩꞌati, “Ushaꞌapataꞌa naa uruu uaipan kawanaꞌati, ukakinaorinaa kawanaꞌati.” Jewnao kian uꞌati, “Waunao, aonaa Rome ikiꞌo kakinaorii taapadan wazowian pidan.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ushaꞌapan naꞌapa, Jesus paradan mishiin-kinaa niꞌo, tawuruꞌu ukowaadanuz naꞌapam nii pamawakan. ");
INSERT INTO wapNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate morotan powaa iti Romannao dapunaa iti. Uruꞌu naa udapada-kidan Jesus naꞌiki upishaanuzu, “Pugaru mishi Jewnao naobanaa king?” ukian. ");
INSERT INTO wapNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus kian uꞌati, “Puaipan atiꞌo kaiwuruꞌu pupishaanuz õgaru naꞌapa? Oo baꞌoran pidannao kakuwaapan idiꞌo puꞌati õdauꞌan?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate kian uꞌati, “Õgaru, aonaa Jew mani. Pumin-Jewnnao naꞌiki faadaanao zowaunaanao paꞌan wuruꞌu naꞌakaꞌoraz pugaru õꞌidaꞌati. Kanom mooko wuruꞌu pushaꞌapataniaz, putoꞌorada-kinaa nii ĩdyaun?” ");
INSERT INTO wapNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus, kian, “Õnaobanai-tinapanuz, aonaa imiꞌi baaraꞌaꞌo kingnao naobanai-tinpan kaduz mani. Daꞌainao naobanai-tinpan kawanun an mani wuruꞌu õnaobanai-tinapanuz, mizaataaka mani õpidanannao, aonaa kizi Jewnao zowaunaanao zaamatan õgaru. Mazan aonaa daꞌaꞌo nii mani wuruꞌu õnaobanai-tinapanuz!” ");
INSERT INTO wapNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate kian uꞌati, “Ukauꞌan, king wuruꞌu pugaruz?” Jesus kian, “Pugaru, pudakotan õgaru king nii. Naꞌapaꞌo niꞌo õshakatan, naꞌiki õkaawan imiꞌi baara ati, õkakuwaapaꞌanan mishiꞌo dauꞌu. Naꞌiaꞌoram pidan mishiꞌo idaꞌantanpuꞌo, uruꞌo nii zaamata õparadan.” ");
INSERT INTO wapNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate kian uꞌati, “Kanom mooko mishiꞌo nii?” Udaunaꞌan Pilate koditan koshan Jewnao idaꞌati, naꞌiki ukian ĩꞌati, “Aonaa kanom dikaudaꞌo nii arawu shaꞌapatanuꞌu, õkaboota-kinaa nii uruu oiaꞌo diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mazan ipai wunu Passover Kamoon dono õkodita-kidauzo nii unao aipan kawanaꞌati baudaꞌapa taraapa-kariwai pidan. Ukauꞌan, turuu õmuudan unao aipan ati, Jewnao naobanaa king kii-kizaiz?” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Uruꞌu naa ĩkadakoꞌokan diiwaꞌo idaꞌan, naꞌiki ĩkian uꞌati, “Aonaa arawu maniꞌi! Mazan waaiapan Barabbas paꞌan!” Aizii Barabbas uruu antamiki. ");
INSERT INTO wapNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Uruꞌu naa Pilate dyuudan soldyaanao baꞌizian tuukii Jesus. ");
INSERT INTO wapNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldyaanao tinokan kaiwada-karu, uruu idiꞌi naa ĩkakowamtan uruu. Udaunaꞌan ĩkakamichantan uruu, wuzaꞌo kamicha idi, ");
INSERT INTO wapNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","naꞌiki uruꞌu naa ĩwaꞌatiꞌanpan uꞌidaꞌati, ĩtaꞌiiꞌanpan uruu paawun baara ati, naꞌiki ĩkian uꞌati, “Pugaru King, umanawunuꞌo Jewnao naobanaa!” ");
INSERT INTO wapNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate koditan koshan, Jewnao kasabaꞌukinapa-kizi iti naꞌiki ukian ĩꞌati, “Aushaa uabata! Aizii õkodita-kidan niꞌi naa uruu unao idaꞌati, mazan õaipan uaitapan kaimanaiman, aonaa kanom õikodan oiaꞌo nii ushaꞌapatan.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Uruꞌu naa Jesus kodita-kida-kao, umorokodapa wuruꞌu kowamaiz kaiwada-karu idiꞌoraz utoma-kao, naꞌiki wuzaꞌoraz kamicha. Uruꞌu naa Pilate kian ĩꞌati, “Aizii, diꞌi naa wuruꞌu pidanaz!” ");
INSERT INTO wapNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aizii, faadaanao zowaunaanao, naꞌiki watchmantapainao tukapaꞌakan naa uruu, sariapa ĩkadakon diiwaꞌo idaꞌan, “Marii utauka-kao cross diꞌiti! Marii utauka-kao cross diꞌiti!” Naꞌiki Pilate kian ĩꞌati, “Unaꞌakaꞌa naa uruu, utauka kiziꞌi naazu cross diꞌiti. Õgaru, aonaa kanom õikodan oiaꞌo nii ushaꞌapatan.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jewnao kian uꞌati, “Waunao, kainaꞌa wakakinaorinaa, pidan naꞌapaꞌo marii uzowii-kao, udakotinpan idi Tominkaru Dani nii.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aizii Pilate abatan idi naꞌapam Jewnao kian, tuukii utarian. ");
INSERT INTO wapNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Udaunaꞌan umorota-kidan koshan Jesus Romannao dapunaa iti. Naꞌiaꞌa naa upishaan uruu, “Naꞌikim san mooko pugaru?” ukian uꞌati. Mazan aonaa Jesus dakoꞌatin uparadan. ");
INSERT INTO wapNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aizii Pilate kian uꞌati, “Kanom nii aonaa pudakoꞌatin õparadan? Õgaru, turuu õkazannaatan pugaru puzowii-kao ai, naꞌiki turuu õtauka-kidan pugaru cross diꞌiti.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus kian uꞌati, “Aonaa turuu pushaꞌapata-kidan õgaru, soo Tominkaru taapadan an. Ukauꞌan, wuruꞌu pidan naꞌaka-kidaꞌoraz õgaru puꞌidaꞌati, powaꞌaꞌo zii manawun ushaꞌapatan oiaꞌo puꞌai.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilate abatan idi naꞌapam ukian, utiwaan padamata naꞌapam pakazannaatan uruu. Mazan Jewnao kadakon uꞌati, “Pukazannaatan an uruu, aonaa Caesar paonaru mani wuruꞌu pugaruz! Pidan dakotinpaꞌo king nii, Caesar taruba wuruꞌu uruuz!” ");
INSERT INTO wapNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilate abatan idi naꞌapam Jewnao kian, uruꞌu naa ukodita-kidan koshan Jesus ĩꞌidaꞌati, naꞌiki uruu daunaꞌan usakanatan pakootoopauzo-kizi tabai idaꞌa, panibazoo diꞌii, Kuba Baara kiaꞌoraz udakota-kao. (Gabbatha, kiaꞌo udakota-kao Hebrew idaꞌan.) ");
INSERT INTO wapNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aizii uruu dono maonapaꞌa naa sakitapa kamoo, naꞌiki uruu dono minziiwatin-karu kamoo wuruꞌu Passover dauꞌati. Uruꞌu naa Pilate kian Jewnao ati, “Diꞌi naa unaobanaa king!” ");
INSERT INTO wapNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Uruꞌu naa ĩkadakoꞌokan, “Marii uzowii-kao! Marii uzowii-kao! Marii utauka-kao cross diꞌiti!” ĩkian. Naꞌiki Pilate kian ĩꞌati, “Uaiapa mooko õtauka-kidan unaobanaa king cross diꞌiti?” Aizii faadaanao zowaunaanao kian uꞌati, “Soo Caesar, uruu baudaꞌapa wanaobanaa king!” ");
INSERT INTO wapNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Uruꞌu naa Pilate taan Jesus ĩꞌati, marii kiziꞌi naa soldyaanao taukan uruu cross diꞌiti. Uruꞌu naa soldyaanao naꞌakaꞌakan naa Jesus, ");
INSERT INTO wapNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ukodita-kida-kao donoi iki uwaodatapaꞌa naa pacrossannaa, naꞌiki unaꞌaka-kao Pidan-Zowau-Niwaꞌuz-naawa kiaꞌo amazada dakota-kao diꞌiti. (Golgotha, kiaꞌo udakota-kao Hebrew idaꞌan.) ");
INSERT INTO wapNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Naꞌiaꞌa naa ĩtaukan Jesus cross diꞌiti. Naꞌiki dyaꞌutam pidannao tauka-kao udazabaꞌa, baꞌoran cross kida diꞌiti. Baudaꞌapa tauka-kao udiwaꞌora antanapu, baꞌoran tauka-kao uwashabaron antanapu. ");
INSERT INTO wapNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate saada-kidanii Jesus dauaꞌo paranka daaraꞌa, naꞌiki utauka-kidanuzu cross paawaꞌa, doko atanapa Jesus zowau ai. “Jesus, Nazareth San, uruu King, Jewnao ati,” kiaꞌo wuruꞌu saada-kariwaiz. ");
INSERT INTO wapNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iriba pidannao aitaan wuruꞌu saada-kariwaiz, umaonapan idi donoi ati. Wuruꞌu usaada-kaoaz idikinaudaꞌuꞌo parada-karu idaꞌanaꞌo, Hebrew idaꞌan, Latin idaꞌan, naꞌiki Greek idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jewnao faadaannao zowaunaanao kian Pilate ati, “Aonaa pusaadaꞌanaꞌa, ‘uruu King, Jewnao ati’ kii; mazan pusaada kaikapaꞌa: ‘Diꞌoraꞌa pidan kian, Õgaru King, Jewnao ati’ kii paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mazan Pilate kian ĩꞌati, “Kanom õsaadanii, aonaa turuu upanaꞌadan.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aizii soldyaanao taukan daunaꞌan Jesus cross diꞌiti, ĩzaamataꞌakan naa ukamichan naꞌiki ĩbuutanuzu paminaꞌutamkida, soldyaanao zaamata kizi pakawanaꞌati kida. Ĩzaamata kapam ushooton zaꞌabaꞌi; aizii uruu toma-kao aonaa naꞌiam ukanotinpan. ");
INSERT INTO wapNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aizii ĩkian paꞌatiaaka, “Diꞌoraꞌa shooto, aonaa washushuudaꞌanaꞌa. Wamakinaotin aka, watukapa kizi kanomaꞌo nii zaamata paꞌanazu.” Ĩshaꞌapatanuz aimaakan naꞌapa, saada-kariwaiz Tominkaru Paradan mishiin-kinaa niꞌo wuruꞌu: “Ĩbuutan õkamichan kida pakawanaꞌati naꞌiki ĩmakinaotinaꞌakan õshooton dikin ii.” Naꞌapa soldyaanao shaꞌapatan aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Naꞌiaꞌo Jesus crossannaa dazaba ii, udaro kadishitapan paꞌinaozo tuma. Naꞌiaꞌo kapam ĩtuma Clopas daiaro Mary, naꞌiki Mary Magdala sanaabaz. ");
INSERT INTO wapNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus tukapan padaro, naꞌiki umarainpaniaz patominapa-kidanii kadishitapan odazabaꞌa. Ukian padaro ati, “Pudani niꞌi naa uruu!” ");
INSERT INTO wapNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Udaunaꞌan ukian patominapa-kidani ati, “Pudaro niꞌi naa oroo!” Naꞌikiꞌoraꞌa naa utaapan oroo. ");
INSERT INTO wapNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus aitapan idi ipaiꞌi naa pashaꞌapatan wuruꞌu Tominkaru aipaniaz pashaꞌapatan; saada-kariwaiz Tominkaru Paradan mishiin-kinaa nii, ukian, “Õmaradako.” ");
INSERT INTO wapNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aizii uruu dono naꞌaꞌo boon zoꞌo pasaata-kariwai kibiaꞌo riwunii. Uruu baoko iti ĩdamotan sponge, naꞌiki ĩsawadanuz Jesus dako iti, hyssop kadunaa saba idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Usoosokanuzu naꞌiki ukian, “Aizii ipaiꞌi naa õshaꞌapatinan!” Aizii unaꞌapaꞌakan daunaꞌan, uruꞌu naa usawiki-kidaꞌakan pazowau, naꞌiki umanizowantaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aizii Jewnao zowaunaanao, aonaa ĩaipan tauka-kariwainao naꞌian cross paawa ii atii kamoo tipitan diꞌiti, ushaꞌapanum kauꞌan uruu diꞌiki Sookapa-karu Kamoo sakadinan. Naꞌiki umanawunuꞌo Sookapa-karu Kamoo, Passover Kamoon wuruꞌu udonoꞌoraz. Uruu idi ĩpishaan Pilate marii kizi udyuudan cross paawa iainao tabaꞌu kida ramita-kao ĩmawaka kizi kadiman, uruu daunaꞌan turuu kizi ĩnanaa kida toka-kida-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Uruꞌu naa soldyaanao makon, naꞌiki ĩramitaꞌakan naa Jesus dazaba ainao ĩtauka-kao tabaꞌu kida. ");
INSERT INTO wapNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mazan ĩkaawan Jesus idaꞌati ĩtukapan uruu mawakaꞌa naa, uruu idi aonaa ĩramitan utabaꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mazan baudaꞌapa soldyaa dakataꞌakan uruu paaraduꞌu ati dimanaꞌo pachipararin idi, sariapa izai naꞌiki wunu shootaꞌakan udakata-kizinao iki. ");
INSERT INTO wapNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Pidan tukapaꞌoraz kaikapaꞌo shaꞌapan, uruu wuruꞌu kakuwaapaꞌoraz. Ukauꞌan turuu ukuwaa mishida-kao. Ukowaadan wuruꞌu mishiꞌoraz kuwai turuu kizi unao mishidan kapam.) ");
INSERT INTO wapNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Diꞌoraꞌa aimaakan kida shaꞌapan, saada-kariwaiz Tominkaru Paradan mishiin-kinaa niꞌo wuruꞌu: “Aonaꞌo nii baudaꞌapa uniwaꞌuz ramita-kao,” kiaꞌoraz usaadinpan. ");
INSERT INTO wapNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Naꞌiki kainaꞌa koshan saada-kariwai Tominkaru Paradan idaꞌa kaikapaꞌoraꞌa: “Pidannao awunuupan nii padakatanii diꞌiti,” kii. ");
INSERT INTO wapNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aizii naꞌapa kidaꞌo shaꞌapan daunaꞌan, Joseph, Arimathea san pishaan naa Pilate Jesus nanaa dauꞌati, turuu kizi unaꞌakanuzu naꞌiki udida-kiziꞌi naazu. (Wuruꞌu Joseph, uruu mishidaꞌo Jesus, mazan aonaa ukowaadan baꞌoran pidan ati, utarian idi Jewnao zowaunaanao ai.) “Turuu punaꞌakanuzu,” Pilate kian daunaꞌan uꞌati; uruꞌu naa umakon naꞌiki unaꞌakan naa Jesus nanaa. ");
INSERT INTO wapNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Aizii, Nicodemus, tawuruꞌu makonkauzoz aiwakaꞌan Jesus diꞌii, uruu kapam mako Joseph tuma. Unaꞌaka 30 kilogram kasarai, myrrh naꞌiki aloes idiꞌo ukawikiꞌita-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ĩnaouꞌu naa naꞌaka Jesus nanaa naꞌiki ĩpapidan naaz barakaꞌo kamicha mada kasarai-tinpaꞌo idi. Naꞌapaꞌo Jewnao saabauzon mawakaꞌo, unaꞌaka-kao uaꞌii baaranai iti. ");
INSERT INTO wapNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Aizii, Jesus zowii-kizinao ii kainaꞌaꞌo daꞌi paoribai baawu. Naꞌiki kainaꞌaꞌo naꞌa paꞌinaꞌo kichada-kariwai baaranai, aonaꞌo zii ukaiwauzo-kao. ");
INSERT INTO wapNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jewnao minziiwauzon idi Passover Kamoon dauꞌati uruu dono, naꞌiki baaranai kainaꞌan idi naꞌii, naꞌiaꞌa naa ĩpaidaꞌakan Jesus nanaa. ");
INSERT INTO wapNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ishawaka zii amazada Sunday chaapiꞌiki, Mary Magdala sanaabaz kaawaꞌakan naa Jesus baaranaa ati. Otukapa zikadaꞌaka-kaoaꞌa naa kuba baaranai tarataꞌaka-kinaoaz. ");
INSERT INTO wapNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Uruꞌu naa odimaꞌakan, okowaadaꞌanan Simon Peter naꞌiki Jesus marainpaniaz patominapa-kidanii ati. Okian ĩꞌati, “Naꞌaka-kaoaꞌa naa wanaobanaa nanaa pabaaranaa iki, aizii aonaa waaitapan naꞌiam naa ĩshaꞌapatanuzu!” ");
INSERT INTO wapNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Uruꞌu naa Peter naꞌiki baꞌoran Jesus tominapa-kidaniaz makon, ĩtukapaꞌanan Jesus baaranaa. ");
INSERT INTO wapNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Baokopa dyaꞌutam ĩdyaun dimapa ĩmakon naꞌiti. Mazan wuruꞌu baꞌoraniz, ukadimandinaꞌakan naa naꞌiki ukiwiitaꞌakan Peter ai, ukauꞌan kiwiin ukaawan Peter ai baaranai iti. ");
INSERT INTO wapNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Udawukan, uawunuutaa-kidan kaꞌunaru nazo iti, utukapa mawakaꞌo watuu-kinao kamicha mada unazo ii; mazan aonaa umorotan naꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mazan Simon Peter kaawaꞌakan udawuꞌati, sariapa umorotanaakan unazo iti. Utukapa wuruꞌu nanai watuu-kinaoaz kida kamicha mada naꞌii, ");
INSERT INTO wapNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","naꞌiki utukapa kapam wuruꞌu kamichaz Jesus zowau watuu-kinaoaz. Pakawan uwatudinpan naꞌiki panaꞌitinapu wuru aiaꞌa baꞌoran kamicha mada kidaz. ");
INSERT INTO wapNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Udaunaꞌan, tominapa-kida-kariwai, kiwiiniꞌoraz ukaawan baaranai ati, umorotan naa kapam kaꞌunaru nazo iti. Ukauꞌan utukapa naꞌiki umishida. ");
INSERT INTO wapNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Uruu dono aonaa zii ĩaitapan naꞌapaꞌoram saada-kariwaiz Tominkaru Paradan idaꞌaꞌoraz, kadishitaꞌo nii uruu pamawaka-kizi iki, kiaꞌoraz.) ");
INSERT INTO wapNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Uruu daunaꞌan ĩkiwan naa powaa iti pamashaapa-kizi iti, wuruꞌu tominapa-kida-kariwainaouz. ");
INSERT INTO wapNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mazan Mary, onaꞌian zii okadishitapan, ozaadinan Jesus baaranaa ii. Pazaadan puꞌu, odawukan naꞌiki omorota-kidan pazowau kaꞌunaru iti, oawunuutaa-kidan unazoo. ");
INSERT INTO wapNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Otukapa dyaꞌutam angelnao naꞌii, baraka kidaꞌo ĩkamichan. Ĩsakanatapan Jesus nanaa-daunuz idaꞌa. Baudaꞌapaꞌo sakanatapan uzowau antanapu, naꞌiki baꞌoran sakanatapan ukidiba antanapu. ");
INSERT INTO wapNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ĩkian Mary ati, “Kandii nii puzaadinan?” Okian ĩꞌati, “Ĩnaꞌakan idi õNaobanaa diꞌikiꞌi, aizii aonaa õaitapan naꞌiam naa ĩshaꞌapatanuzu!” ");
INSERT INTO wapNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Oparadaꞌakan daunaꞌan, okiwa-kiwaaꞌakan padikin iti, otukapa pidan padazabaꞌa. Jesus padamata wuruꞌu kadishitapaꞌoraz, mazan aonaa oaitapanuzu. ");
INSERT INTO wapNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus kian oꞌati, “Kandii nii puzaadinan? Kanom pudawatapan?” Ozauda-kidan saabaapauzo paoribai baawu wuruꞌu uruuz. Okian uꞌati, “Pugarun an wuruꞌu zikadaꞌoraz uruu diꞌikiꞌi, pukowaada õꞌati naꞌiam pushaꞌapatanuzu, õnanaka kizi uruu powaa ati.” ");
INSERT INTO wapNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Upuꞌaꞌa naa Jesus dakotan oꞌuu, “Mary!” ukian oꞌati. Uruꞌu naa otanawatinaꞌakan uꞌidaꞌati, naꞌiki okian uꞌati, “Rabboni!” (Hebrew idaꞌan, “Tiichaa,” kiaꞌo wuruꞌu.) ");
INSERT INTO wapNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus kian oꞌati, “Manaꞌa puzaamatinaꞌanaꞌa õꞌidaꞌati, ushaꞌapanum kauꞌan aonaa zii õkiwan õdaru diꞌiti. Mazan pumako õꞌinawuzunao diꞌiti, pukowaadaꞌan õparadan ĩꞌati. Pukii ĩꞌati, ‘Õkiwan naa õDaru naꞌiki õTominkarun diꞌiti wuruꞌu. Uruu ĩDaru naꞌiki ĩTominkarun kapam.’” ");
INSERT INTO wapNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Uruꞌu naa Mary Magdala sanaaba makon Jesus tominapa-kidaniinao diꞌiti naꞌiki okowaadan naa ĩꞌati patukapan Naobanai, naꞌiki okowaadan naa ĩꞌati naꞌapam ukian. ");
INSERT INTO wapNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Uruu Sunday wachuupunin, Jesus tominapa-kidaniinao baokopatinan kabaun nazo ii. Ĩtarian idi Jewnao zowaunaanao ai ipai ĩdadaradapan paniinom kida. Mashaꞌapakiaka Jesus aidinan ĩbii ii, naꞌiki ukian ĩꞌati, “Kaiman utaapa unyukunuu.” ");
INSERT INTO wapNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Uparadan daunaꞌan naꞌapa, utukapa-kidan ĩꞌati potopotori daunizi pakaꞌu kida idaꞌaꞌo, naꞌiki paaraduꞌu dakata-kizinao. Ĩtukapan idi wuruꞌu Naobanaiz, tuukii, tuukii utominapa-kidaniinao konaukian. ");
INSERT INTO wapNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Udaunaꞌan Jesus kian ĩꞌati koshan, “Kaiman utaapa unyukunuu. Õdaru dyuudan kawan õgaru imiꞌi baara ati, ukauꞌan naꞌapa õdyuudan kapam unao amazada kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Uipaian daunaꞌan paparadan, upootan panizowan ĩꞌidaꞌati naꞌiki ukian ĩꞌati, “Õtaan Kaimanaꞌo Doronaa uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ukauꞌan turuu ukian pidan ati, ‘Marinaꞌata-kaoaꞌa naa uꞌoian,’ Tominkaru marinaꞌataꞌakaniꞌi naa kapam wuruꞌu pidan oianuz. Aonaan an umarinaꞌatan pidan oian, aonaꞌo nii Tominkaru marinaꞌatan kapamazu.” ");
INSERT INTO wapNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomas (Shamaan kiaꞌo baꞌoran uꞌuu), uruu kapam 12, Jesus tominapa-kidanii bii ikiꞌo, aonaꞌo uruu nii ĩtuma Jesus aidinan dono ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ĩkian uꞌati, “Watukapanii Naobanai!” Thomas kian ĩꞌati, “Aonaꞌo nii õmishidan utukapan Naobanai, soo õtukapan an zii potopotori daunizi ukaꞌu kida idaꞌa, naꞌiki õshakadan an zii õkaꞌu shuwu naꞌiti, naꞌiki õshakadan an zii õkaꞌu uaraduꞌu dakata-kizinao shaawa iti.” ");
INSERT INTO wapNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Baudaꞌapa soondii daunaꞌan, baokopaꞌo koshan Jesus tominapa-kidaniinao kabaun nazo ii. Uruu dono, naꞌaꞌa Thomas ĩtuma. Paniinom kida dadaradinpan puꞌu padamata, Jesus naꞌiaꞌa naa uaidinan ĩbii ii. Ukian ĩꞌati, “Kaiman utaapa unyukunuu.” ");
INSERT INTO wapNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Udaunaꞌan ukian Thomas ati, “Putukapa potopotori daunizi õkaꞌu kida idaꞌa, putaa pukaꞌu shuwu naꞌati; pushakada pukaꞌu õaraduꞌu dakata-kizinao shaawa iti. Aonaꞌa naa pumamishidakaꞌanaꞌa, mazan pumishidapaꞌa naa paꞌan!” ");
INSERT INTO wapNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas kian uꞌati, “Pugaru õNaobanaa naꞌiki õTominkarun!” ");
INSERT INTO wapNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus kian uꞌati, “Thomas, pumishida aizii, putukapan idi õgaru? Konaukiaꞌo manawun pidan mishidaꞌoraz pamatukapakan puꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus shaꞌapatanii iriba umanawun kidaꞌo aimaakan patominapa-kidaniinao awun zaꞌa, aonaa usaadinpan diꞌoraꞌa kaarita idaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mazan diꞌoraꞌa saada-kao, turuu kizi unao mishidan Jesus, uruu wuruꞌu Christ, Tominkaru Dani; naꞌiki uruu maꞌozakan idaꞌanaꞌo nii unao kakupan, umishidan idaꞌan uruu. ");
INSERT INTO wapNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aizii uruu daunaꞌan, Jesus aidinan koshan patominapa-kidaniinao ati Tiberius Karishiiz danoma ii. Kaikapa aizii uaidinan ĩꞌatiꞌi. ");
INSERT INTO wapNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Aizii 7 utominapa-kidaniinao baokopaꞌo udono: Simon Peter, Thomas (Shamaan kiaꞌoraz baꞌoran uꞌuu), Nathanael (Galilee Baara iaꞌo Cana sanaz), Zebedee dainao, naꞌiki dyaꞌutam baꞌorainao Jesus tominapa-kidaniinao. ");
INSERT INTO wapNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter kian ĩꞌati, “Õmakoꞌozon wuruꞌu, õsairoopaꞌanan.” Ĩkian uꞌati, “Wamakon nii putuma.” Uruꞌu naa ĩmakon utuma kanawa zoꞌan; mazan uruu aiwakaꞌan aonaa kanom ĩsairotan. ");
INSERT INTO wapNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Chaapiꞌiki, kamoo koditan uaꞌii, naꞌiaꞌa naa Jesus kadishitapan unaawa ii, wunu danomaꞌa. Mazan utominapa-kidaniinao aonaa ĩaitapan Jesus wuruꞌu kadishitapaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus kian ĩꞌati, “Õpaonarunao, usairota kopau?” Ĩkian uꞌati, “Aonaa kanom wasairotan.” ");
INSERT INTO wapNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mazan Jesus kian ĩꞌati, “Ukaboota usairon ukanawan diwaꞌora antanapu, usairotan nii kopau.” Uruꞌu naa ĩkabootan pasairon, ĩsairota iriba, iriba kopau. Naꞌiki aonaꞌa naa ĩkaꞌiitan pasawatan pasairon kanawa zoꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aizii Jesus tominapa-kidaniaz, tawuruꞌu umarainpaniaz, ukian Peter ati, “Naobanai uruu!” Simon Peter abatan idi Naobanai uruu kii-karu, sariapa umorokadaꞌakan pakamichan (unarakadaꞌakanii pakamichan pasairoopan idi), naꞌiki uzakaꞌutaꞌakan naa wunu baoko iti, umakoꞌozon idi kadiman Jesus diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Baꞌorainao utumainao kanawa idaꞌan zii ĩwaꞌatin, ĩkozootapaanan pasairon paidaꞌoraz kopau idi. Aonaa munapoꞌoraꞌa naa mani ĩdyaun wuruꞌu wunu danoma ai, 100 meters mani umunapon. ");
INSERT INTO wapNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ĩmaaratinan donoꞌo naa, ĩtukapa wiziꞌiꞌo tikazi tiriizi naꞌii naꞌiki kainaꞌa upaawaꞌa kopau kazimata-kariwai, naꞌiki kainaꞌa bread udazabaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus kian ĩꞌati, “Unaꞌaka daꞌatiꞌi naꞌapaudaꞌum karikaonan kopau, aiziꞌoraz uzaamataꞌakan.” ");
INSERT INTO wapNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter kiwaꞌakan powaa iti, naꞌiki upaidinan kanawa zoꞌiti. Uruꞌu naa ukaminkaꞌutan pairibannao kozootan sairo unaawa ati. Paida wuruꞌu sairoz kopau tuꞌuz kida idi, 153 ipaiꞌikaꞌo sairota-kariwai kopau: mazan sairo aonaa udadoobiꞌiinan, kopau iriban puꞌu padamata. ");
INSERT INTO wapNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus kian ĩꞌati, “Waaroopaꞌa naa.” Aonaa naꞌiaꞌoram utominapa-kidaniinao papishaanuzu kanom uruu. Ushaꞌapanum kauꞌan ĩaitapa kaimanaiman Naobanai Jesus wuruꞌu. ");
INSERT INTO wapNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus zaamatan bread naꞌiki uruꞌu naa utaabiꞌian ĩkawanaꞌatiz; kopau naꞌapa kapam utaan ĩkawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ukauꞌan, idikinautan naa aizii wuruꞌu Jesus aidinanuz patominapa-kidaniinao ati, pakadishitan daunaꞌan mawaka-karu diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aizii ĩaroopan daunaꞌan, Jesus kian Simon Peter ati, “Simon, John dani, mishiꞌo pumarainpan õgaru powaꞌa zii wunao aiꞌi?” Peter kian uꞌati, “Oo, Naobanai; puaitapanii õmarainpan pugaru.” Jesus kian uꞌati, “Puawunuutapa õpidanannao, naꞌapa kaznizo dainao awunuutapa-kao kawan.” ");
INSERT INTO wapNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Powaꞌa koshan Jesus kian uꞌati, “Simon, John dani, mishiꞌo pumarainpan õgaru?” Peter kian uꞌati, “Oo, Naobanai; puaitapanii õmarainpan pugaru.” Jesus kian uꞌati, “Putaapa õpidanannao, naꞌapa kaznizonao taapa-kao kawan.” ");
INSERT INTO wapNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Aizii idikinautan naa Jesus pishaan Peter, “Simon, John dani, mishiꞌo pumarainpan õgaru?” Sariapa Peter nyukunuu kashaꞌoran, Jesus pishaan idi paugaru idikinauꞌu naa manawun, “Mishiꞌo pumarainpan õgaru?” kii. Ukauꞌan Peter kian uꞌati, “Naobanai, pugaru puaitapanii ipai aimaakan; puaitapanii õmarainpan pugaru!” Jesus kian uꞌati, “Puawunuutapa õpidanannao, naꞌapa kaznizonao awunuutapa-kao kawan. ");
INSERT INTO wapNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mishiꞌo kaiwuruꞌu õkianuz: Pupaꞌinan dono zii puaipan ati puminziiwauzon, naꞌiki pumakon pumakoꞌozoo-kizi iti; mazan putunarunaoun donoꞌo naa, pusawadan nii pukaꞌu naꞌiki baꞌoran pidannaouꞌo nii minziiwa-kida pugaru naꞌiki punaꞌaka-kao nii, aonaa pumakoꞌozoo-kizi iti mani.” ");
INSERT INTO wapNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jesus paradanuz naꞌapa, ukainaabatan naꞌapam nii Peter mawakan. Naꞌiki naꞌapaꞌo idaꞌanaꞌo nii uaida-kidan Tominkaru umanawunun.) Udaunaꞌan Jesus kian uꞌati, “Pudaꞌan õgaru!” ");
INSERT INTO wapNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter awunuuankan powaꞌa iti, utukapa Jesus tominapa-kidanii umarainpaniaz waꞌatin ĩdawuꞌati. (Uruu tawuruꞌu sakanatapaꞌoraz Jesus dazabaꞌa aroapa-karu dono, Passover Kamoon donoꞌoraz, pishaaꞌoraz Jesus kaikapaꞌa: “Naobanai, kanomaꞌo nii mooko manawun wuruꞌu kaakapaꞌo niꞌoraz pugaru putarubanao ati?”) ");
INSERT INTO wapNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter tukapan idi uwaꞌatin, uruꞌu naa upishaan Jesus, “Naobanai, arawu maniꞌi, naꞌapam nii ushaꞌapata-kao?” ");
INSERT INTO wapNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus kian uꞌati, “Naꞌapa dii puꞌati õaipan an ukakupan zii atii õkaawan powaa ati? Pugaru, pudaꞌan õgaru!” ");
INSERT INTO wapNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Naꞌikiꞌi naa parada-karu iribainan mishidainao kawanaꞌati, naꞌiki ĩabatan ukowaada-kao aonaꞌo nii umawakauzon, wuruꞌu utominapa-kidaniaz. Mazan, “aonaꞌo nii umawakauzon,” aonaa Jesus kian udauꞌati. Mazan, “Naꞌapa dii puꞌati õaipan an ukakupan zii atii õkaawan powaa ati?” kiaꞌo ukian. ");
INSERT INTO wapNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wuruꞌu Jesus tominapa-kidaniaz, uruꞌu naa kakuwaapaꞌoraz diꞌoraꞌa aimaakan kida dauꞌaꞌa, naꞌiki uruu kapam saadaꞌoraz diꞌoraꞌa kaarita. Naꞌiki waaitapa mishiꞌo wuruꞌu ukuwaa kidaz. ");
INSERT INTO wapNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kainaꞌa iriba baꞌoran kida aimaakan Jesus shaꞌapatanii, aonaa usaada-kao. Usaada-kao an mani ipai daunuudaꞌu, aonaa mani udauaꞌo saada-kariwai kida kaarita wiizi nii diꞌoraꞌa amazada idaꞌaꞌa.");
INSERT INTO wapNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Õpaonaru Theophilus: Kiwiiniꞌo õkaaritan idaꞌa, õkowaadaniꞌi naa shaꞌatii puꞌati ipai Jesus kaudin-kizi kida dauꞌu, naꞌiki õkowaada ukuwaa, utominapatin-kida-kinaaz pidannao. ");
INSERT INTO wapNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ipai õkowaadanuz usakadin-kizi iki atii Tominkaru naꞌakauzon diꞌiti uruu aokazi iti. Mazan Jesus naꞌaka-kao uaꞌii aokazi iti, ukakinaowan apostlenao Kaimanaꞌo Doronaa idaꞌan, ĩnao uzaamataniinaouz kakuwaapatinainao nii. ");
INSERT INTO wapNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Aizii 40 kamoo pazowii-kao daunaꞌan, Jesus aidinan mapuda apostlenao ati, ukauꞌan ĩtukapa uruu, naꞌiki ushaꞌapata pabiꞌinaaka aimaakan, utukapa-kida-kinaa nii ĩꞌati mishiꞌo pakakupan, naꞌiki ipai ukowaadan ĩꞌati naꞌapam Tominkaru naobanai-tinan. ");
INSERT INTO wapNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Baudaꞌapa kamoo apostlenao baokopatinpan dono, Jesus kakinaowan ĩdyaun, kaikapaꞌa: “Manaꞌa zii paꞌi umakoꞌonaꞌa Jerusalem iki, uzaudapa kizi Kaimanaꞌo Doronaa, tawuruꞌu õDaru kowaadauzoniaz pataaꞌazon unao ati, naꞌapa shaꞌatii tawuruꞌu õkiauzonuz uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John Chikaawunuupauzon soo wunu idi karikaonan, mazan aonaꞌo nii zii kamoo dobatan iriba, Tominkaru chikaawunuuan nii unao Kaimanaꞌo Doronaa idi paꞌan,” ukian apostlenao ati. ");
INSERT INTO wapNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aizii apostlenao baokopatinan dono Jesus tuma Olive Naawa ii, sariapa ĩkian uꞌati, “Naobanai, aiziꞌo niꞌi naa puzaamatan powaa iti pidan king nii Israelitenao bii iki, kazowautapaꞌo niꞌi naa waunao Israelitenao?” ");
INSERT INTO wapNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mazan Jesus kian ĩꞌati, “Soo õDaruꞌo nii karikaonan aitapa naꞌapainim nii pashaꞌapatan ipai aimaakan paaipan kawanaꞌati. Unao aonaa turuu uaitapan. ");
INSERT INTO wapNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mazan Kaimanaꞌo Doronaa morotinan dono unao, maꞌozakaꞌo nii utaapan unyukunuu. Ukauꞌan maꞌozakaꞌo nii ukakuwaapan õdauꞌu Jerusalem ii aka, naꞌiki ipai Judea Baara ii aka, naꞌiki Samaria Baara ii aka, atii ipai amazada kawanaꞌati.” ");
INSERT INTO wapNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesus ipaian daunaꞌan paparadinan ĩꞌati naꞌapa, uruꞌu naa Tominkaru naꞌakaꞌakan naazu aokazi iti. Apostlenao awunuutapan udawuꞌati, atii ishaꞌiz dikinidaꞌakan naazu. ");
INSERT INTO wapNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ĩawunuutapan puꞌu zii udawuꞌati, mashaꞌapakiaka dyaꞌutam daonaioranao, barakaꞌo ĩkamichan kida, aidinaꞌakan naꞌiki ĩkadishitan ĩdazabaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Sariapa ĩparadan apostlenao ati kaikapaꞌa: “Galilee Baara sannao. Kandii nii uawunuutapan aokazi iti? Wuruꞌu Jesus, Tominkaru naꞌakaniaz aokazi iti, naꞌapaꞌo nii uwaꞌatin koshan, utukapan kawan umakon aokazi iti,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Udaunaꞌan apostlenao padantan naa Olive Naawa iki, Jerusalem itiꞌi naa. Munapo zaꞌo wuruꞌu naawazi ĩmakonaka kiziz. ");
INSERT INTO wapNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aizii ĩkaawan naa donoi iti, sariapa ĩmakon pasookadinpauzo-kizi iti, kabaun dokoaꞌo uparanka baara-tinpan. Kaikapaudaꞌu ĩdyaunuꞌu: Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, James (Alphaeus daniz), naꞌiki Simon (uruu Patriot), naꞌiki Judas (James daniz). ");
INSERT INTO wapNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Naꞌiaꞌa naa apostlenao baokopainpan, naꞌiki mapuda daꞌi ĩtoriinpan Tominkaru ati. Mary, Jesus daroz, naꞌiaꞌo kapam ĩtuma, naꞌiki baꞌoran zunnao, naꞌiki Jesus inawuzunao. ");
INSERT INTO wapNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Baudaꞌapa kamoo uruu dono, mishidainao baokopatinan, 120 wuruꞌu baokopatinpainaouz. Naꞌiki Peter kadishitan ĩnao kanaapu iti, naꞌiki ukian ĩꞌati, ");
INSERT INTO wapNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Õiribannao, õkiaꞌazon ipai unao ati, marii aizii saada-kariwaiz Tominkaru paradan mishii-kao, tawuruꞌu Kaimanaꞌo Doronaa kowaada-kidauzoniaz kotuaꞌa naa David idaꞌan. Judas dauꞌanaꞌo wuruꞌu unaꞌapanuz, uruu naꞌakaꞌoraz pidannao, zaamataꞌo nii Jesus. ");
INSERT INTO wapNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas wabii ikiꞌo uruu, Jesus zaamatauzonii, kaudinaꞌo nii baokopa watuma.” ");
INSERT INTO wapNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Taa-kariwai puraata Judas ati, uzaamata-kidan winipinaa Jesus patarubanao ati. Uruu puraata idaꞌan zakapu torii-kao. Naꞌiki uruu zakapu baara iaꞌo Judas waotauzon mawaka aka, naꞌiki tadaꞌoka aka utoba, naꞌiki ipai uokori kodiaꞌakan. ");
INSERT INTO wapNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ipai pidannao mashaapainao Jerusalem ii aka, abatan wuruꞌu aimaakan shaꞌapanuz uꞌati naꞌapa. Uruu idi ĩdakotan paparadan idaꞌan wuruꞌu zakapu uu, Akeldama kii, “Izaitaꞌo Zakapu,” kiaꞌo wuruꞌu.) ");
INSERT INTO wapNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Kaikapa shaꞌatii tawuruꞌu David saadauzoniaz udauꞌu Psalms idaꞌa. ‘Marii udapu waꞌakinan mawazoo-daun; Aonaa kizi pidan mashaapan udapu ii.’ Baꞌoran koshan David saadanii Psalms idaꞌa, ukian, ‘Marii kizi baꞌoran pidan zaamatan wuruꞌu ukaudin-kiziz.’ ");
INSERT INTO wapNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ukauꞌan marii wazaamatan baudaꞌapa pidan wabii iki, chiꞌikapauzo daꞌi baokopa watuma wakaudinan dono Naobanai Jesus tuma, ");
INSERT INTO wapNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","John chikaawunuuan diꞌikiꞌo uruu, atii unaꞌaka-kao diꞌiti waꞌai aokazi iti. Ukauꞌan naꞌiaꞌoram pidan zaamata-kao, uruꞌo niꞌi naa kakuwaapatin waunao tuma Jesus kadishita-kida-kao dauꞌu pamawaka-kizi iki.” ");
INSERT INTO wapNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Uruu idi dyaꞌutam pidannao zaamata-kao, Joseph Barsabbas (Justus kiaꞌoraz kapam udakotapauzo-kao), naꞌiki Matthias. ");
INSERT INTO wapNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Aizii ĩtukapaꞌazon naꞌiaꞌoram nii zaamata-kao. Uruu idi ĩtoriinpan Tominkaru ati kaikapaꞌa: “Naobanai, ipai puaitapan pidannao nyukunuu, putukapa-kida waꞌati naꞌiaꞌoram nii baudaꞌapa pidan zaamata-kao kaudinaꞌo nii puꞌati Judas wadaun nii, makoꞌoraz naa pamashaapa-kizi itiꞌi naa,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Uruu daunaꞌan ĩmakinaotan makinaonii, ĩtukapaꞌazon kanom diꞌiti uwaotan. Matthias diꞌiti uwaotan. Uruꞌu naa ĩzaamata apostle nii, kaudinaꞌo nii Jesus ati, baꞌoran 11 apostlenao tuma. ");
INSERT INTO wapNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aizii Pentecost kamoon kaawan donoꞌo naa, ipai mishidainao kasabaꞌukinan baokopa, baudaꞌapaꞌo kabaun nazo ii. ");
INSERT INTO wapNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mashaꞌapakiaka ĩabata aimaakan waꞌatin diiwa aokazi iki, maꞌozakaꞌo awaru waꞌatin kawanuꞌo. Ipai pidannao, sakanatapainao kabaun nazo ii abatanuz. ");
INSERT INTO wapNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Upuꞌaꞌa naa ĩtukapaꞌakan iriba tikazi puꞌukapan kawan sodi kidaꞌo aimaakan, naꞌiki ĩtukapan naa ĩbuutinan ipai pidannao kawanaꞌati kida. ");
INSERT INTO wapNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Uruꞌu dono Kaimanaꞌo Doronaa morotinan naꞌiki umaꞌozakadan naa ipai ĩdyaun. Sariapa ĩparadan pabiꞌinaakaꞌo parada-karu kida idaꞌan, Kaimanaꞌo Doronaa aipan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Uruu dono iribaꞌo Jewnao, Tominkaru-tapainao, kasabaꞌuinpan Jerusalem ii. Ĩnao waꞌatin munapo kidaꞌo wiizai diꞌiki. ");
INSERT INTO wapNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ipai ĩnao, mashaꞌapakiaka ĩabatan diiwaꞌo aimaakan wuru diꞌiaꞌa mishidainao kasabaꞌukinapa-kizi ii. Uruu idi iriba ĩdiman naꞌiti, ĩtukapaꞌananuzu. Uruꞌu naa mazan ĩabatan mishidainao paradan paparadan kaduz kida idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tuukii ĩdiꞌitinpan ĩdauꞌu. Sariapa ĩkian paꞌatiaaka kida, “Ei, ipai shaꞌatii wunaouꞌu pidannaouz Galilee Baara sannao paꞌidiwaru, ");
INSERT INTO wapNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","9","mazan naꞌapa diꞌi naa mooko waabatan ĩparadan kaiman, waparadan kaduz idaꞌan kida? Ipai waunao diꞌi panaꞌa kidaꞌo waparadan, naꞌiki baꞌoran wiizai iki kidaꞌo paꞌidiwaru wawaꞌatin. Kainaꞌa waꞌatiinao Parthia Baara iki, baꞌorainao Media Baara iki, naꞌiki Elam Baara iki, baꞌorainao Mesopotamia Baara iki, Judea Baara iki, Cappadocia Baara iki, baꞌorainao kida Pontus Baara naꞌiki Asia Baara iki. ");
INSERT INTO wapNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kainaꞌa baꞌorainao kida waꞌatiinao Phrygia Baara iki naꞌiki Pamphylia Baara iki, baꞌorainao kida Egypt Baara iki, pabiꞌi kida pidannao waꞌatin Libya Baara iki, maonapaꞌoraz donoi Cyrene itinapu. Kainaꞌa kapam Rome ikiinao, ");
INSERT INTO wapNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jewnao kaawan naꞌiki baꞌoran kaduz pidannao, zaamatinainaouznaa Jewnao kaduz diꞌiti. Naꞌiki kainaꞌa kapam Crete Baara naꞌiki Arabia Baara ikiinao. Ipai waunao wawaꞌatin baꞌoran amazada iki kidaꞌo, mazan upuꞌu zii waabatan kaimanaiman ĩkowaadan Tominkaru shaꞌapatanii, umanawun kidaꞌo aimaakan, waparadan kida idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tuukii, tuukii ĩdiꞌitinpan, aonaa ĩsookadan papishaan pairibannao kida. “Kandii niꞌo wuruꞌu aimaakan shaꞌapanuz naꞌapa?” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mazan baꞌorainao, ĩbankiitan mishidainao, kaikapaꞌa: “Ashu, ĩpoꞌidin karikaonan wuruꞌu,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Udaunaꞌan Peter kadishitan naa baokopa wunao tumaꞌa, 11 apostlenaouz. Naꞌiki ukian naa ĩꞌati, maꞌozakaꞌo idaꞌan, “Õiribannao Jewnao, tawarainao, naꞌiki Jerusalem sannao. Uabata õparadan. Õkowaadaꞌazon uꞌati wuru dauꞌanaꞌa aimaakan uabataniaz aizii. ");
INSERT INTO wapNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Unao kian, ‘Wunao poꞌidin wuruꞌu.’ Aonaa wapoꞌidin, aizii zii wakanadaꞌakan, naꞌiki waoko ii zii kamoo. ");
INSERT INTO wapNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Õaipan uaitapan wuru dauꞌanaꞌa utukapaniaz shaꞌapan aizii, tawuruꞌu naa wuruꞌu mishiinaꞌoraz, prophet Joel saadauzoniaz kotuaꞌa naa. Kaikapa shaꞌatii tawuruꞌu ukiauzonuz. ");
INSERT INTO wapNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tominkaru kian pidannao ati: ‘Kaikapaꞌo nii õshaꞌapatan aimaakan diinaꞌitiꞌi, amazada tokon uaꞌii, õtaan nii õDoronaa ipai pidannao ati. Naꞌiki udainao daonaioranao naꞌiki zunnao, kowaadapan nii õparadan; naꞌiki tominnarunao ati, õtukapa-kidan nii mishiꞌo aimaakan zandaꞌawunii iaꞌo kawanuꞌo nii. Aizii tunarunaonao ati, õtukapa-kidan nii mishiꞌo aimaakan ĩzandaꞌawun ii. ");
INSERT INTO wapNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Uruu dono õtaan nii õdoronaa õpoitorunao nyukunuu iti, daonaioranao naꞌiki zunnaouz. Naꞌiki ĩkowaadan nii õparadan kida. ");
INSERT INTO wapNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Uruu dono õaidan nii umanawun kidaꞌo aimaakan diꞌitinapa-kinai niꞌo, doko ii naꞌiki imiꞌi baaraꞌa. Uruu dono pidannao tukapan nii izai, tikazi, naꞌiki podidiꞌo tikazi shan. ");
INSERT INTO wapNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Uruu dono marutaꞌo nii kamoo, naꞌiki kauzu wuzaꞌo nii izai kawan. Wuruꞌu aimaakan kida shaꞌapan nii kaikapaꞌa, umanawunuꞌo kamoo, õgaru Naobanai Kamoon kaawan uaꞌiaꞌo nii. ");
INSERT INTO wapNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Naꞌiaꞌoram pidan pishaaꞌo Naobanai kazannaatan paugaru, kazannaata-karu niiz.’ Kiaꞌo wuruꞌu Joel saadauzoniaz. ");
INSERT INTO wapNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Õiribannao Israelitenao, uabata õparadan. Kaimanaiman Tominkaru kainaabatan unao ati mishiꞌo udyuudanii wuruꞌu Jesus Nazareth sanaz, ushaꞌapata-kidan idaꞌan uꞌati umanawun kidaꞌo aimaakan. Unao, uaitapa mishiꞌo kaiwuruꞌu õparadanuz, ushaꞌapanum kauꞌan utukapaniꞌi naa ushaꞌapatan naꞌapa kidaꞌo aimaakan, daꞌanaꞌa uwiizi an. ");
INSERT INTO wapNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Paaipan kawanaꞌatiꞌo wuruꞌu Tominkaru zaamata-kidanuz Jesus unao ati. Uaitapanii kotuaꞌa naa, unao zaamatan niizu naꞌiki uzowii-kidan niizu, udyuudan idaꞌan oiaꞌo pidannao taukanuzu cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mazan Tominkaru kadishita-kida uruu mawaka-kizai iki. Ukakuda uruu powaa iti, aonaa mawaka-karu kaꞌiitan pataratapan uruu mawakainao bii ii. ");
INSERT INTO wapNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kaikapa shaꞌatii tawuruꞌu David saadauzoniaz Christ paradan. ‘Õaitapa karikaonan kainaꞌa Naobanai Tominkaru õtuma, maonapa umashaapan õdazabaꞌa. Uruu idi aonaꞌo nii kanom ai õtarian. ");
INSERT INTO wapNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ukauꞌan tuukii manawun õkonaukian, naꞌiki karikaonanuꞌo nii õkonaukii-kidan Naobanai. Õaitapa naꞌiki õmishida pukadishita-kidan nii õnanaa powaa iti. ");
INSERT INTO wapNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Aonaꞌo nii pukashaapan õnaꞌian karikaonan mawaka-kizai ii. Naꞌiki aonaꞌo nii putaapadan kaimanaꞌo manawun pupoitoru nanaa dyupushan baaranai ii. ");
INSERT INTO wapNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pukowaadauzonii õꞌati, pukadishita-kidan nii õgaru powaa iti õmawakan daunaꞌan. Õkonaukian nii manawun putaapan idi õgaru pudazabaꞌa,’ kiaꞌo David saadauzon. ");
INSERT INTO wapNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Õꞌinawuzunao, õkowaadaꞌazon uꞌati kaimanaiman, wadokozu-daun King David dauꞌan. Uruu kotuaꞌa naa umawakan, kainaꞌa watukapan ubaaranaa kaidaꞌaꞌa, atii kai. ");
INSERT INTO wapNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mazan prophet uruu. Uruu idi uaitapa naꞌiki umishida wuruꞌu Tominkaru kowaadauzoniaz pashaꞌapataꞌazon uꞌati. Ukiauzonuz, uzaamatan nii baudaꞌapa David takaan-daun king nii, naꞌapaꞌo nii uruu kawan. ");
INSERT INTO wapNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tominkaru aipan ati, David aitapa naꞌapam nii aimaakan shaꞌapan diinaꞌitiꞌi. Uruu idiꞌo ukowaadanuz Tominkaru kakudan nii Christ powaa iti pamawaka-kizi iki. Aonaꞌo nii ukashaapan unaꞌian mawakainao bii ii, naꞌiki aonaꞌo nii ukashaapan udyupushan baaranai ii. ");
INSERT INTO wapNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ukauꞌan uruꞌu naa wuruꞌu Jesus, Tominkaru kadishita-kidaniaz pamawaka-kizi iki. Mishiꞌo wuruꞌu ukakudanuz powaa iti, ipai waunao apostlenao tukapanuz. ");
INSERT INTO wapNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tuukii Tominkaru naubaan Jesus, uruu idi usakanata-kidanuz padiwaꞌora antanapu Naobanai nii. Naꞌiki Tominkaru taaꞌa naa Kaimanaꞌo Doronaa Jesus ati, ukowaadauzoniaz pataaꞌazon uꞌati. Uruu Kaimanaꞌo Doronaꞌa naa wuruꞌu Jesus taaniaz waunao mishidainao ati aizii, wuruꞌu unao tukapanii kidaz, naꞌiki unao abataniaz kapam. ");
INSERT INTO wapNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aonaa David sawatauzo-kao aokazi iti. Mazan upuꞌu zii ukian. ‘Naobanai Tominkaru kian õNaobanaa ati. Pusakanata õdiwaꞌora antanapu, ");
INSERT INTO wapNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","atii õwaranuita-kidan putarubanao puꞌati.’ ");
INSERT INTO wapNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ukauꞌan, marii ipai unao naꞌiki ipai baꞌoran Israelitenao aitapan kaimanaiman, tawuruꞌu Jesus, unao tauka-kidaniaz cross diꞌiti, uruꞌu naa Christ, Tominkaru zaamataniaz Naobanai nii, kazannaataꞌo nii papidanannao.” ");
INSERT INTO wapNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pidannao abatan daunaꞌan ipai wuruꞌu Peter paradanuz paꞌati kaikapaꞌa, tuukii ĩnyukunuu kashaꞌoran. Sariapa ĩpishaan Peter, naꞌiki baꞌoran apostlenao kapam. “Wairibannao, naꞌapam nii dii washaꞌapatinan aizii?” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter kian ĩꞌati, “Õiribannao, ipai unao, utanawatin uꞌoian ai naꞌiki uchikaawunuu-kidinaꞌa naa umishidan idiꞌi naa Jesus Christ, Tominkaru mainaabata kizi ipai uꞌoian. Naꞌiki Tominkaru taa kiziꞌi naa uꞌati Kaimanaꞌo Doronaa. ");
INSERT INTO wapNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Uruu wuruꞌu Tominkaru kowaadauzoniaz pataaꞌazon unao ati, naꞌiki utakaannao ati, naꞌiki Gentilenao ati. Mazan soo padapadaniinao pidannao atiꞌo nii wuruꞌu Naobanai waTominkarun taanuz Kaimanaꞌo Doronaa.” ");
INSERT INTO wapNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter kakinaowan ĩdyaun kaimanaiman, naꞌiki powaꞌa zii koshan uparadan ĩꞌati, kaikapaꞌa: “Umuudaꞌa naa oiaꞌo kai, aonaa kizi upatakaꞌuta-kao diinaꞌitiꞌi oiainao pidannao patakaꞌuta-kao donoꞌo naa.” ");
INSERT INTO wapNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Uruu idi iriba, iriba pidannao mishidan ukuwaa, naꞌiki ĩchikaawunuinan naa kapam. Uruu dono 3,000 pidannao mishidan Jesus, naꞌiki ĩbaokopatinan naa wunao bii itiꞌi mishidapainaouznaa. ");
INSERT INTO wapNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Uruu daunaꞌan karikaonan daꞌi ĩbaokopainpauzon. Minziiwa ĩtominpan apostlenao diꞌiki, naꞌiki ipai ĩbaudaꞌapatan panyukunuu Tominkaru dauꞌati. Ĩnikan bread baokopa, ĩnyukunuitapa-kinaa nii Jesus mawakan, naꞌiki ĩtoriinpan baokopa kapam Tominkaru ati. ");
INSERT INTO wapNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uruu dono, Tominkaru aipan ati apostlenao shaꞌapatan umanawun kidaꞌo aimaakan, aonaꞌoraz turuu ushaꞌapatauzo-kao. Tuukii pidannao diꞌitinpan wuru dauꞌaꞌa ĩshaꞌapatanii kidaz. ");
INSERT INTO wapNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Naꞌiki mapuda ĩbaokopainpan baꞌoran mishidainao kida tuma. Naꞌiki karikaonan daꞌi ĩkaꞌidiwaakapan paꞌatiaaka kida. ");
INSERT INTO wapNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Naꞌiaꞌoram pidan sellian dono pashaꞌapauz, utaan nii wuruꞌu pashaꞌapauz winipinaaz ipai mishidainao kawanaꞌati, ĩtorii-kinaa nii paaiapanii manawun aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ipai kamoo mishidainao baokopatinauzon Tominkaru Dapu ii. Panaadon ĩbaokopatinan nii mishidainao dapu ii kapam, konaukii ĩaroopan baokopa, naꞌiki ĩnikan nii kapam bread panyukunuitapa-kinaa nii Jesus mawakan. ");
INSERT INTO wapNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Karikaonan ĩkonaukiitin-kidan Tominkaru. Uruu idi tuukii pidannao naudapan wuruꞌu mishidainaouz. Ipai kamoo Jesus kazannaatan pidannao ĩꞌoian ai. Uruu idi powaꞌa zii manawun mishidainao iribainan. ");
INSERT INTO wapNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Baudaꞌapa kamoo wachuupun uaꞌii, Peter naꞌiki John makon koshan Tominkaru Dapu iti, ĩtoriinpaꞌanan Tominkaru ati, Jewnao toriinpauzon kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Aizii kainaꞌa daonaiora kaawa-kida-kariwai Tominkaru Dapu paniinomizinaa diꞌii, dakota-kariwaiz Konaunamaꞌo Paniinom kii. Wuruꞌu daonaioraz aonaꞌo uchiꞌikauzon pashakatan ikiꞌo. Ipai kamoo pairibannao naꞌakauzonuzu Tominkaru Dapu paniinomizinaa diꞌiti, upishaa kizi puraata pidannao ai, ĩmorotaꞌanan puꞌu Tominkaru Dapu iti. ");
INSERT INTO wapNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aizii wuruꞌu daonaioraz, utukapa Peter naꞌiki John morotaꞌanan Tominkaru Dapu iti. Sariapa ukian ĩꞌati, “Utaa shoman õpuraatan sodi nii.” ");
INSERT INTO wapNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sariapa ĩawunuupaꞌakan uꞌidiꞌiti, naꞌiki Peter kian, “Puabata.” ");
INSERT INTO wapNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Sariapa daonaiora awunuupaꞌakan ĩꞌidiꞌiti, aonaa upanadankan paawun ĩꞌai, uzauda-kidan ĩtaaꞌazon puraata paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mazan Peter kian uꞌati, “Aonaa õpuraatan nii, mazan õtaan nii aimaakan kainaꞌaꞌo õꞌidaꞌa. Õkian puꞌati, puchiꞌika Jesus Christ, Nazareth san uu idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Uzaamatanuzu pakaꞌu kadu iki ukadishita-kidanuz. Mashaꞌapakiaka daonaiora kidiba naꞌiki utabaꞌu kida maꞌozakaꞌakan, ");
INSERT INTO wapNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","uruꞌu naa ukadishitan, naꞌiki uchiꞌikaꞌakan naa kapam. Sariapa umorotan Peter naꞌiki John tuma Tominkaru Dapu iti. Naꞌii uchiꞌikaadanaan naꞌiki uzakaꞌuudanaan, ukonaukii-kidan Tominkaru. ");
INSERT INTO wapNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aizii pidannao tukapan idi naꞌiki ĩabatan idi wuruꞌu ukonaukii-kidanuz Tominkaru kaimanan paꞌati, ");
INSERT INTO wapNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sariapa ĩaitapaꞌakan uruꞌu naa tawuruꞌu sakanatapauzoz Tominkaru Dapu paniinomizinaa ii, pishautauzoz puraata pidannao ai. Tuukii pidannao diꞌitinpan patukapan idi aimaakan shaꞌapan uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aizii wuruꞌu daonaioraz, naꞌa uzaamatinpan Peter naꞌiki John kadu iki, Solomonꞌs Porch diꞌii. Iriba pidannao diman ĩꞌidaꞌati, ĩtukapaꞌanan ĩdyaun. Tuukii ĩdiꞌitinpan udauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter tukapan idi iriba pidannao, sariapa uparadan ĩꞌati, kaikapaꞌa: “Õiribannao, Israelitenao, kanom niꞌo uawunuutapan naꞌiki udiꞌitinpan wadauꞌu? Uꞌitiiman wakaimanan idaꞌanaꞌo manawun oo wamaꞌozakan idaꞌanaꞌo karikaonan wuruꞌu wachiꞌika-kidanuz diꞌoraꞌa daonaiora? Aonaa turuu washaꞌapatan aimaakan kaikapaꞌa waꞌidaꞌa! ");
INSERT INTO wapNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mishi wadokozu-daunnao Abraham, Isaac, naꞌiki Jacob, naꞌiki ipai wairiban-daunnao Tominkarun. Uruu tuukii paꞌan ukonaukii-kidan naꞌiki unaubaan papoitoru Jesus. Mazan unao, tuukii uaipan uzowii-kao, naꞌiki tuukii ukashadan, naꞌiki udakoopan uruu Pilate kanaapuꞌu, umuudaꞌazon puꞌu padamatazu. ");
INSERT INTO wapNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mazan aonaa unao nyukunuu naꞌapan, aonaa uaipan wuruꞌu kaimanaꞌoraz pidan aonaꞌoraz ushaꞌapatan oiaꞌo muuda-kao. Soo uaipan paꞌan Pilate muuda-kidan zowii-miki pidan. ");
INSERT INTO wapNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Uruu idi uzowii-kidan wuruꞌu taaꞌoraz kakupa-kinai. Mazan Tominkaru kakuda naꞌiki ukadishita-kida uruu pamawaka-kizi iki. Ipai waunao watukapa uruu, ukadishitan daunaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Uruu Jesus uu idaꞌanaꞌo wuruꞌu wachiꞌika-kidanuz machiꞌikakaꞌo, wamishidan idi Jesus tuukii manawun, naꞌiki machiꞌikakaꞌo mishidan idi kapam uruu tuukii. Ipai unao utukapa aizii diꞌi ukadishitapanuꞌu. ");
INSERT INTO wapNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Uabata õiribannao! Õaitapa unao naꞌiki uzowaunaanao shaꞌapatan Jesus kaikapaꞌa, ushaꞌapanum kauꞌan umaaitapakan idi Tominkaru dyuudanii wuruꞌu uruuz. ");
INSERT INTO wapNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tominkaru kowaada-kidaniꞌi naa shaꞌatii kotuaꞌa naa prophetnao idaꞌan, wuruꞌu padyuudan nii Christ, mazan pidannao patakaꞌutan niizu naꞌiki ĩzowian niizu. Aizii watukapa naꞌapaꞌa naa mishi Tominkaru mishii-kidan paparadan. ");
INSERT INTO wapNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","“Ukauꞌan umuudaꞌa naa naꞌiki utanawatinaꞌa naa ushaꞌapaapan ai oiaꞌo, umashaapa kiziꞌi naa paꞌan Tominkaru aipan kawanaꞌati, umainaabata kizi ipai uꞌoian uꞌai. Naꞌiki Tominkaru tiwaa-kida kizi unao ati kaimanaꞌo naꞌiki konaunamaꞌo mashaapa-karu unyukunuu ii. Naꞌiki udyuudan nii koshan Christ daꞌatiꞌi unao naꞌiki waunao idaꞌati. Ushaꞌapanum kauꞌan uruu Jesus, Tominkaru zaamataniaz kazannaataꞌo nii naꞌiki kazowautapaꞌo nii ipai daunuudaꞌu waunao. ");
INSERT INTO wapNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Jesus naꞌian nii zii aokazi ii, atii Tominkaru paꞌinaadan ipai wuruꞌu patomanii kidaz aimaakan. Naꞌapa shaꞌatii ukowaada-kidauzon kotuaꞌa naa kaimanainao prophetnao idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kaikapa shaꞌatii tawuruꞌu Moses kiauzonuz Christ dauꞌan, ‘Naobanai waTominkarun zaamatan nii pidan unao bii iki prophet nii, ukowaadapan nii Tominkaru paradan naꞌapa õgaru kawan. Uabata kizi paꞌi ipai aimaakan ukowaadanii uꞌati, uizoꞌati kizi naꞌiki ushaꞌapatin kizi uparadan kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Naꞌiaꞌoram pidan aonaꞌo uabataꞌazon naꞌiki aonaꞌo uizoꞌatin uparadan, Tominkaru mainaabatan niizu papidanannao bii iki.’ ");
INSERT INTO wapNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Naꞌapa shaꞌatii Prophet Samuel kowaadauzon, naꞌiki ipai baꞌoran udawuꞌati kidainao prophetnao, ĩkowaadapauzonii kapam ipai wuru kida dauꞌanaꞌa, watukapanii kidaz naa ushaꞌapaapa-kao daꞌanaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Uruꞌu naa tawuruꞌu prophetnao idaꞌanaꞌoraz Tominkaru kowaada-kidan pashaꞌapataꞌazon naꞌiki pataaꞌazon wadarunnao ati. Ipai waunao Jewnao atiꞌo kapam wuruꞌu utaa-kaoaz, ushaꞌapanum kauꞌan ĩdani-daunnao wuruꞌu waunaouz. Ukiauzon Abraham ati, ‘Õkamunan-kidan nii ipai pidannao imiꞌi baara anainao, baudaꞌapaꞌo putakaan-daun idaꞌan.’ ");
INSERT INTO wapNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Aizii Tominkaru dyuudan donoꞌo naa papoitoru, udyuudan uruu kiwiin waunao Jewnao idaꞌati kaminkaꞌutaꞌo nii waunao, utanawatin-kidan idaꞌan waunao, washaꞌapaapan ai oii kidaꞌo aimaakan,” Peter kian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter naꞌiki John kadakotinan puꞌu zii pidannao ati, upuꞌaꞌa naa faadaanao, naꞌiki kazowautapaꞌo watchmantapainao Tominkaru Dapu, naꞌiki Sadduceenao kaawaꞌakan ĩbii ati. Naꞌiki ĩabata ĩkowaadapan ");
INSERT INTO wapNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","mishiꞌo wuruꞌu Jesus kadishitanuz pamawaka-kizi iki. Ukauꞌan mishiꞌo nii kapam pidannao, mawakainao kidaz kadishitan pamawaka-kizi iki. Uruu dikin ii ĩtoꞌoran tuukii apostlenao ati. ");
INSERT INTO wapNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Sariapa ĩzaamata-kidan ĩdyaun. Mazan wachuupun idiꞌi naa ĩnaꞌakaꞌakan naa ĩdyaun taraa-kizai iti, naꞌiaꞌa naa ĩtaraa-kidan ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mazan iriba, iriba pidannao mishidan, wuruꞌu abatainaouz apostlenao kuwaa. Uruu idi powaꞌa zii mishidainao iribadinan, 5000, soo daonaioranao karikaonan aita-kao. ");
INSERT INTO wapNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Aizii baꞌoran kamoo ipai kootowapa-kidauzonao pidannao baokopatinan Jerusalem ii: faadaanao zowaunaanaouz, kazowautapainaouz Jewnao, naꞌiki tiichaapauzonaouz Moses kakinaori dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas, Umanawunuꞌoraz Faadaa, naꞌiaꞌo kapam uruu baokopa Caiphas, John, naꞌiki Alexander tuma. Naꞌiki naꞌiaꞌo kapam baꞌoran faadaanao ĩtuma, Annas iribannao kida. ");
INSERT INTO wapNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ipai ĩnao baokopatinan, udaunaꞌan ĩdyuudan naa apostlenao kadishitan pakanaapuꞌu. Ĩpishaan naa ĩdyaun kaikapaꞌa: “Kanom aipan atiꞌo, oo kanom taanii umaꞌozaka-kinaa nii, wuruꞌu uchiꞌika-kidanuz diꞌoraz daonaioraꞌa?” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Sariapa Kaimanaꞌo Doronaa maꞌozakadan Peter nyukunuu, naꞌiki ukian ĩꞌati, “Õiribannao, wanaobanaanao, naꞌiki kazowautapainao waunao Israelitenao. ");
INSERT INTO wapNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ukadishita-kidan waunao aizii ukanaapuꞌu, soo wakamunanun idi naꞌiki wakaminkaꞌutan idi machiꞌikakaꞌo pidan. Naꞌiki unao, uaitapaꞌazon naꞌapaꞌoram wuruꞌu wachiꞌika-kidanuz uruu. ");
INSERT INTO wapNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aizii õaiapa ipai unao, naꞌiki ipai Israelitenao aitapan. Jesus Christ, tawuruꞌu Nazareth sanaz, uruu maꞌozakan idaꞌanaꞌo wuruꞌu wachiꞌika-kidanuz diꞌoraz daonaioraꞌa. Uruu idi utukapan kaimanaꞌa naa aizii ukadishitapan diꞌi. Uruu Jesus Christ, unao zowii-kidaniaz, utauka-kidaniaz cross diꞌiti. Mazan Tominkaru kakuda naꞌiki ukadishita-kida uruu pamawaka-kizi iki. ");
INSERT INTO wapNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Uruu Jesus dauꞌanaꞌo tawuruꞌu kotuaꞌoraz usaadauzo-kao, Tominkaru Paradan kianuz kaikapaꞌa: ‘Wuruꞌu kuba unao tomapauzonao kabaun kashadaniaz. Kaimanaꞌo, naꞌiki umanawunuꞌo kabaun toma-kinao wuruꞌu, ipai baꞌoran kubanao ai.’ ");
INSERT INTO wapNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Aonaa baꞌoran pidan nii, kazannaataꞌo nii waunao, diꞌoraz imiꞌi baara an, soo baudaꞌapa Jesus. Uruu Tominkaru dyuudanii, pidannao kazannaatin-kinaa nii, aonaa baꞌoran uruu kawanuꞌo nii.” ");
INSERT INTO wapNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tuukii kootowapa-kidauzonao pidannao diꞌitinpan Peter naꞌiki John dauꞌu, ushaꞌapanum kauꞌan ĩtukapa maꞌozaka ĩkakuwaapan, aonaa ĩtarian. Naꞌiki ĩaitapa aonaa aitapainao pidannao manawun mani ĩnao. Udaunaꞌan ĩaitapankan naa, Jesus minaudaꞌuitapauzonii ĩnao. ");
INSERT INTO wapNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mazan ĩtukapan idi kainaꞌa wuruꞌu daonaiora chiꞌika-kida-kariwaiz kadishitapan naꞌa Peter naꞌiki John tuma, aonaa ĩaitapan naꞌapam naa pakian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Uruu idi ĩdyuudan zii ĩkodita-kida-kao miitiniapa-kizai nazo iki. Udaunaꞌan kootowapa-kidauzonao pidannao kadakotinan naa paꞌatiaaka. ");
INSERT INTO wapNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ĩkian, “Naꞌapam nii dii washaꞌapatan ĩdyaun? Ipai pidannao mashaapainao Jerusalem an aitapan wuruꞌu ĩshaꞌapatanuz umanawunuꞌo aimaakan, naꞌiki aonaa naꞌitim wamariidin udauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mazan turuu paꞌan wamashaatan ĩkakuwaapatinan, ĩkuwaa iribainan ai baꞌoran pidannao diꞌiti. Wakakinao shoman ĩdyaun, aonaa kiziꞌi naa ĩkakuwaapatinan powaꞌa Jesus dauꞌu pidannao ati.” ");
INSERT INTO wapNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Uruu idi ĩdapadan ĩdyaun powaꞌa ati. Naꞌiki ĩkian ĩꞌati, “Wakakinaowan nii unao, aonaa waabataꞌazon powaꞌa ukakuwaapatinan pidannao ati Jesus dauꞌu. Aonaa masakaudaꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sariapa Peter naꞌiki John kian ĩꞌati, “Õiribannao, kanom paradan uaitapan Tominkaru aiapa izoꞌati-kao? Unao paradan, oo uruu paradan? ");
INSERT INTO wapNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aonaa turuu wasookadan wakowaadapan wuruꞌu watukapanii, naꞌiki waabatanii kida aimaakan dauaꞌoraz.” ");
INSERT INTO wapNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Powaꞌa zii koshan kootowapa-kidauzonao pidannao kakinaowan ĩdyaun maꞌozakaꞌo idaꞌan. Udaunaꞌan ĩmuudaꞌakan naa ĩdyaun. Aonaa ĩaitapan naꞌapam pashaꞌapatan ĩdyaun. Ushaꞌapanum kauꞌan ipai pidannao, tuukii ĩkonaukii-kidan Tominkaru, ĩtukapan idi wuruꞌu umanawunuꞌo aimaakan shaꞌapata-kaoaz machiꞌikakaꞌo ati. ");
INSERT INTO wapNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wuruꞌu pidan chiꞌika-kida-kariwaiz, uwazootaniꞌi naa 40 uwunun. ");
INSERT INTO wapNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kootowapa-kidauzonao pidannao muudan daunaꞌan Peter naꞌiki John, sariapa ĩkiwan pamin-mishidannao diꞌiti. Naꞌiki ipai ĩkowaadan ĩꞌati naꞌapam faadaanao zowaunaanao naꞌiki kazowautapainao Jewnao kian paꞌati. Naꞌiki ĩkowaadan ĩkakinaowan paugaru maꞌozakaꞌo idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mishidainao abatan idi naꞌapaꞌo parada-karu, sariapa ĩtoriinpan Tominkaru ati, kaikapaꞌa: “Oo Naobanai umanawunuꞌo, tomaꞌo aokazi, imiꞌi baara, paran naꞌiki ipai wuruꞌu mashaapainaouz aokazi ii, imiꞌi baaraꞌa, naꞌiki paran baoko ii. ");
INSERT INTO wapNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kotuaꞌa naa mishi pukaiwaan wadarun, King David, kowaadaꞌo nii puparadan Kaimanaꞌo Doronaa idaꞌan. Kaikapa shaꞌatii tawuruꞌu King David kiauzonuz, ‘Kanom dikin iaꞌo wuruꞌu Gentilenao toꞌoranuz? Naꞌiki kandii nii pidannao dakotautan pashaꞌapatan õgaru madiwautapaka? ");
INSERT INTO wapNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kingnao minziiwan, ĩmizaataakapaꞌazon, naꞌiki baꞌoran naobanai-tinpainao kida baokopatinan ĩtuma, ĩaipan pamashaatan Naobanai Tominkaru naꞌiki Christ, wuruꞌu puzaamataniaz kazannaataꞌo nii papidanannao.’ ");
INSERT INTO wapNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Aizii, naꞌapaꞌa naa mishi, ukawanaꞌati watukapan aimaakan kida shaꞌapaapa-kao. Pontius Pilate naꞌiki King Herod baokopatinan Gentilenao naꞌiki Israelitenao tuma, Jerusalem idaꞌa, ĩtoꞌoran donoꞌoraz Jesus ati. Uruu kaimanaꞌo pupoitoru Christ, uruu puzaamataniaz kazannaataꞌo nii pupidanannao. ");
INSERT INTO wapNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mishi pugaru, puwazoota pidan maꞌozakan, mazan soo puaipan kawanaꞌatiꞌo, naꞌiki pukashaapan idiꞌo karikaonan wuruꞌu pidannao shaꞌapatanuz Jesus kaikapaꞌa. Naꞌiki kotuaꞌoraꞌa naa pudiꞌitapan wuruꞌu pushaꞌapata-kidaꞌazoonuz uruu kaikapaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Oo, waNaobanaa, puabata naꞌapam pidannao dakotan pashaꞌapatan waunao. Mazan waunao pupoitorunao naꞌiki pupidanannao, pukaminkaꞌuta waunao, maꞌozaka kizi wakowaadapan puparadan pidannao ati. ");
INSERT INTO wapNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pukashaapa wakakudan karinainao, kaimanaꞌo pupoitoru, Jesus idaꞌan. Naꞌiki marii kapam washaꞌapatan Jesus idaꞌan, umanawun kidaꞌo aimaakan, aonaꞌoraz turuu pidan shaꞌapatan,” ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ĩipaian daunaꞌan patoriinpan Tominkaru ati, sariapa amazada nakainan ĩbaokopatinapa kizi ii, naꞌiki ipai Kaimanaꞌo Doronaa maꞌozakadan ĩnyukunuu. Uruu idi maꞌozakaꞌa naa ĩkowaadapan Tominkaru paradan. ");
INSERT INTO wapNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ipai wuruꞌu mishidainaouz, ĩmashaapan patumaaka ĩtaapan panyukunuu, naꞌiki naꞌapa kida ĩdiꞌitinpan. Aizii pashaꞌapauz kida, aonaa ĩtaapan soo paꞌatiꞌo nii mani karikaonan. Mazan ĩkaꞌidiwatan nii ipai pamin-mishidannao kida uꞌidi. ");
INSERT INTO wapNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kaimanaꞌo Doronaa maꞌozakadapan idi apostlenao, maꞌozaka ĩkakuwaapan Naobanai Jesus kadishitan dauꞌu pamawaka-kizi iki. Naꞌiki kaimanaiman Tominkaru kaminkaꞌutan ipai wuruꞌu mishidainaouz. ");
INSERT INTO wapNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Aonaa kanom aimaakan awutaꞌo nii ĩꞌai. Ushaꞌapanum kauꞌan pabiꞌi kida mishidainao, kainaꞌa ĩzakapun wiizi kida, naꞌiki ĩdapu kida. Aizii ĩsellian an baꞌoran pazakapun oo padapu, ĩnaꞌakan nii wuruꞌu uwinipinaa kidaz apostlenao diꞌiti. Apostlenaouꞌo niꞌi naa buuta wuruꞌu puraataz mishidainao kawanaꞌati, wuruꞌu patakaꞌutinainaouz. Uruu idi aonaa ĩbaiaapan pazamazin. ");
INSERT INTO wapNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aizii mishidainao biiꞌi kainaꞌa daonaiora Cyprus san, Joseph kiaꞌo uꞌuu, mazan apostlenao dakotan naazu Barnabas kii, (maꞌozakadapaꞌo pidannao nyukunuu, kiaꞌo wuruꞌu uꞌuuaz). ");
INSERT INTO wapNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Baudaꞌapa kamoo, Barnabas sellian pazakapun baꞌoran pidan ati. Uzakapun kawinipinaata-kao daunaꞌan, unaꞌakan naa wuruꞌu puraataz apostlenao diꞌiti. Naꞌapa kiziꞌi naa koshan ĩbuutan puraata, mishidainao kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kainaꞌa daonaiora Ananias kiaꞌo uꞌuu. Udaiaro uu Sapphira kiaꞌo. Ĩaipan kapam pataan puraata mishidainao atiꞌo nii. Uruu idi ĩbuutan paꞌamazadati, naꞌiki ĩselliinuz. ");
INSERT INTO wapNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Mazan Ananias naꞌiki udaiaro baudaꞌapatan panyukunuu aonaa kizi ĩtaan ipai daunuudaꞌu wuruꞌu puraataz. Udaunaꞌan Ananias makon naa apostlenao diꞌiti, utaan naa wuruꞌu puraataz ipaiꞌo kawan mishi. ");
INSERT INTO wapNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sariapa Peter kian uꞌati, “Ananias, kandii nii pukashaapan Satan kaiwaan pugaru? Satan aipan ati pubuutan puraata puꞌidiwau nii, wuru diꞌikiꞌi puraata taa-kariwaiz puꞌati puamazadati winipinaa nii. Kandii nii putiwaan pumariidan Kaimanaꞌo Doronaa? ");
INSERT INTO wapNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pusellian uaꞌii wuruꞌu amazadaz, puꞌidiwau wuruꞌu, naꞌiki pusellian daunaꞌanazu, puꞌidiwau padamata wuruꞌu puraataz. Mazan kandii niꞌi naa mooko wuruꞌu pushaꞌapatanuz aimaakan kaikapaꞌa naa manawunuꞌu? Aonaa waunao mani wuruꞌu pumariidaniaz, mazan putiwaan pumariidautan Tominkaru paꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias abatan idi Peter paradan naꞌapa, sariapa udorautaꞌakan, naꞌiki umawakaꞌakan naa. Aizii pidannao, tukapainao naꞌiki abatainao kida kuwai Ananias mawakan dauꞌu, tuukii, tuukii ĩtarian. ");
INSERT INTO wapNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sariapa daonaioranao waꞌatin, naꞌiki ĩbazoobatan naa unanaa kamicha mada idi. Udaunaꞌan ĩnaꞌakan naazu naꞌiki ĩdidaꞌanaꞌakan naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tomunuꞌiki zaa uruu daunaꞌan, Ananias daiaro kaawaꞌakan naa apostlenao idaꞌati, aonaa oaitapan wuruꞌu paudaiaru mawakanuz. ");
INSERT INTO wapNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Sariapa Peter kian oꞌati, “Pukowaada õꞌati, patumaakaꞌo wuruꞌu diꞌoraz puraataꞌa? Kaikapaudaꞌuꞌo wuruꞌu uamazadati kawinipinaata-kaoaz?” “Oo, naꞌapaꞌo wuruꞌu,” okian uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Uruu idi Peter kian oꞌati, “Kandii nii pugaru naꞌiki pudaiaru tiwaa-kidapan Tominkaru Doronaa? Uꞌitiiman aonaꞌo nii Tominkaru aitapan? Puabata! Kaikin ikiꞌi naa daonaioranao didankainao pudaiaru waꞌatiniꞌi. Aizii pugaruꞌo niꞌi naa kapam ĩdidaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sariapa odorautaꞌakan naꞌiki omawakaꞌakan naa kapam. Aizii daonaioranao kaawan padidanaka-kizi iki Ananias, ĩtukapan udaiaro mawakaꞌakaꞌa naa kapam. Uruu idi ĩnaꞌakan naa onanaa naꞌiki ĩdidan naazo paudaiaru dazabaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Uruu idi tuukii mishidainao, Jerusalem iainaouz tarian. Naꞌiki tuukii kapam baꞌorainao pidannao kida tarian, ĩabatan idi wuruꞌu ĩmawakanuz naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tominkaru maꞌozakan idaꞌan, apostlenao shaꞌapata umanawun kidaꞌo aimaakan pidannao awun zaꞌa, aonaꞌoraz turuu pidan shaꞌapatan. Mapuda daꞌi mishidainao baokopainpauzon Solomonꞌs Porch diꞌii, Tominkaru Dapu iaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mazan mamishida-kainao pidannao, tuukii ĩtarian pakaawan mishidainao idaꞌati, mazan upuꞌu ĩnaudapan wuruꞌu ĩshaꞌapaapanii kidaz aimaakan, naꞌiki ipai ĩparadan kaiman ĩdauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mazan unaꞌapan puꞌu iriba daonaioranao naꞌiki zunnao mishidan naa Naobanai Jesus. Uruu idi baokopaꞌa naa ĩbaokopatinan kiwiiniꞌo mishidainao tuma. ");
INSERT INTO wapNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Apostlenao shaꞌapaapan idi umanawun kidaꞌo aimaakan, sariapa pidannao naꞌakan karinainao pairibannao, naꞌiki ĩmuudan ĩdyaun dunapo daawa an, padaꞌawupa-kizi baaraꞌa kida. Aizii Peter dobatan an naꞌan ĩdazaba an, ĩaipan udikin dobatan ĩpaawa an, ĩkakuda kizi. ");
INSERT INTO wapNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Iriba pidannao kasabaꞌukinan apostlenao idaꞌati, waꞌatiinaouz donoi sodi kida diꞌiki, wuruꞌu Jerusalem dazaba an kidaꞌoraz wiizainao. Ĩnaꞌakan karinainao, naꞌiki oiaꞌo doronai zaamatapaniinao kida, naꞌiki ipai ĩrinaa kida soꞌota-kao ĩꞌai. ");
INSERT INTO wapNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aizii Umanawunuꞌo Faadaa naꞌiki uminkaꞌunao, wuruꞌu Sadduceenaouz, tuukii ĩkashauzin apostlenao ati. ");
INSERT INTO wapNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Uruu idi ĩzaamatan ĩdyaun, naꞌiki ĩtaraa-kidan naa ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mazan uruu aiwakaꞌan, angel, Tominkaru diꞌikiꞌo daꞌatan taraa-kizai paniinomizinaa kida ĩꞌati, naꞌiki ukodita-kidaꞌakan naa ĩdyaun. Ukian ĩꞌati, ");
INSERT INTO wapNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Umako Tominkaru Dapu iti, ukowaada kizi pidannao ati wuru dauꞌaꞌa paꞌinaꞌoraz naa mashaapa-karu.” ");
INSERT INTO wapNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Apostlenao izoꞌati Angel paradan. Ishawaka zii amazada, ĩnao makoꞌokaꞌa naa Tominkaru Dapu iti. Naꞌiaꞌa naa koshan ĩtominapatin-kidan pidannao. Aizii Umanawunuꞌo Faadaa baokopatinan naa paminkaꞌunao tuma, naꞌiki ĩdapadan naa ipai kootowapa-kidauzonao pidannao miitiniapa-kizai iti. Udaunaꞌan ĩdyuudan naa pidannao taraa-kizai iti, ĩnanaka kiziꞌi naa apostlenao paꞌidaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mazan dyuuda-kariwainao kaawan taraa-kizai iti, aonaa ĩikodan apostlenao naꞌii, uruu idi ĩkiwaꞌakan naa powaa iti. Ĩkaawan, sariapa ĩkian kootowapa-kidauzonao pidannao ati, ");
INSERT INTO wapNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Wakaawan taraa-kizai iti waikoda ipai paniinom kida dadaradinapa paꞌidiwaru, naꞌiki watchmantapainao taraa-kizai, ipai ĩkadishitapan paniinom kawanaꞌati kida. Mazan wamorotan taraa-kizai nazo iti, aonaa waikodan pidannao naꞌii.” ");
INSERT INTO wapNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Faadaanao zowaunaanao, naꞌiki kazowautapaꞌo watchmantapainao Tominkaru Dapu abatan idi wuruꞌu ĩkowaaz, tuukii ĩdiꞌitinpan. ");
INSERT INTO wapNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Upuꞌaꞌa naa pidan kaawaꞌakan, kakuwaapaꞌanaꞌo ĩꞌidaꞌati. Ukian ĩꞌati, “Uabata õkuwaa! Tawuruꞌu daonaioranao utaraa-kidaniinaouz, kainiꞌiaꞌa naa ĩdyaun Tominkaru Dapu ii, ĩtominapatin-kidan naa pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sariapa watchmantapainnao zowaunaa makon paminkaꞌunao tuma, ĩnaꞌanan wuruꞌu apostlenaouz, ĩkootowapa-kidaꞌazon ĩdyaun. Mazan kaiman ĩzaamatan ĩdyaun, ushaꞌapanum kauꞌan tuukii ĩtarian wunao aiaꞌa abatapainao kidaz ĩkowaa. Ĩzauda-kidan pazowii-kao paboo-kao idaꞌan kuba idi, apostlenao dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Apostlenao kaawa-kida-kao daunaꞌan, ĩkadishita-kida-kaoaꞌa naa kootowapa-kidauzonao pidannao kanaapu ati. Naꞌiki Umanawunuꞌo Faadaa kian naa ĩꞌati kaikapaꞌa: ");
INSERT INTO wapNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tuukii shaꞌatii wakakinaowan unao, wakii shaꞌatii ‘aonaꞌa naa waaipan powaꞌa utominapa-kidan pidannao Jesus dauꞌu.’ Mazan upuꞌu zii utominapatin-kidan pidannao. Aizii ipaiꞌi naa Jerusalem ii aka ukuwaa iribainan. Naꞌiki ipai ukowaadan pidannao ati, waunao wuruꞌu zowii-kidaꞌoraz Jesus.” ");
INSERT INTO wapNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sariapa Peter naꞌiki baꞌoran apostlenao kian, kaikapaꞌa: “Waizoꞌatin nii soo Tominkaru paradan, mazan pidan paradan, aonaꞌo nii waizoꞌatin. ");
INSERT INTO wapNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tominkaru, wadokozu-daunnao mishidauzoniaz, uruu kadishita-kidanii Jesus pamawaka-kizi iki, unao zowii-kidaniaz naꞌiki utauka-kidaniaz cross diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mazan Tominkaru zaamatan naꞌiki umuudan uruu padiwaꞌora antanapu, umanawunuꞌo Naobanai nii, kazannaataꞌo nii ipai pidannao. Naꞌiki uruu idaꞌan kizi waunao Israelitenao tanawatinan waꞌoian ai, naꞌiki uruu idaꞌan kizi waꞌoian mainaabata-kao waꞌai. ");
INSERT INTO wapNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mishiꞌo wuruꞌu kuwaiz, waunao waaitapa naꞌiki watukapa uruu kakupa. Uruu idiꞌo wakakuwaatinan udauꞌu. Naꞌiki Kaimanaꞌo Doronaa, Tominkaru taaniaz ipai mishidainao kawanaꞌati, uruu kapam kainaabataꞌo pidannao ati mishiꞌo wuruꞌu kuwai Jesus dauꞌu kidaꞌoraz.” ");
INSERT INTO wapNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kootowapa-kidauzonao pidannao abatan idi wuruꞌu ĩparadanuz kaikapaꞌa, tuukii ĩtoꞌoraꞌakan. Ĩaipan naa apostlenao zowiaka-kao ");
INSERT INTO wapNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mazan kainaꞌa pidan Phariseenao bii ikiꞌo, Gamaliel kiaꞌo uꞌuu, naꞌiki uruu tiichaapauzo Moses kakinaorii dauꞌu. Ipai pidannao naudapan uruu. Sariapa ukadishitan naꞌiki udyuudan apostlenao kodita-kida-kao zii miitiniapa-kizai iki. ");
INSERT INTO wapNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Udaunaꞌan ukian naa ipai kootowapa-kidauzonao pidannao ati, “Õiribannao Israelitenao, uabata õparadan. Udiꞌitinapa zii shoman kiwiin ushaꞌapatan uaꞌii diꞌoraz daonaioranaouꞌu. ");
INSERT INTO wapNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kotuaꞌa naa naꞌapa shaꞌatii tawuruꞌu Theudas kaawauzonuz. Uruu dono udakotinpan umanawunuꞌo pidan nii, naꞌiki iriba shaꞌatii uzaamatan papidanannao nii. Uikoda 400 pidannao zaamatinan uꞌidiꞌiti. Mazan baudaꞌapa kamoo uzowii-kao, uruu idi ipai upidanannao makoobiꞌiinan, atii naꞌapa karikaonan ĩmainaabatinan. ");
INSERT INTO wapNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Uruu daunaꞌan Judas, Galilee Baara san, uaipan pamizaataakapan Rome sannao tuma, ĩsaadapan dono ipai pidannao uu. Iriba shaꞌatii uzaamatauzon papidanannao nii. Mazan naꞌapa koshan uzowii-kao. Aizii upidanannao, ipai ĩmakoobiꞌiinan kapam. ");
INSERT INTO wapNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Ukauꞌan õkiaꞌazon uꞌati, wunao dauꞌanaꞌa diꞌoraz pidannaouꞌu, aonaa umashaataꞌanaꞌa ĩdyaun pakaudin-kizi ai. Umuuda mishiꞌoraiman ĩdyaun, marii ĩmakon. Aizii ĩshaꞌapaapan an wuruꞌu aimaakan kidaz paaipan kawanaꞌati karikaonan, naꞌapaꞌo nii kapam ĩmainaabatinan. ");
INSERT INTO wapNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mazan aizii umishiin an mishi ĩshaꞌapaapan wuruꞌu aimaakan kidaz Tominkaru aipan kawanaꞌati, aonaꞌo nii ukaꞌiitan umashaatan ĩdyaun. Naꞌiki utarubai-tinpan niꞌi naa Tominkaru ati,” ukian ĩꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sariapa mishi uparadan naꞌapatan ĩnyukunuu. Udaunaꞌan ĩdapadan naa apostlenao powaꞌa ati koshan, naꞌiki ĩbaꞌizii-kidan naa ĩdyaun. Ĩbaꞌizii-kao daunaꞌan kootowapa-kidauzonao pidannao kakinaowan naa ĩdyaun tuukii. “Aonaa waaipan ukakuwaatinan powaꞌa Jesus dauꞌu,” ĩkian apostlenao ati, mazan ĩmuudaꞌakan naa ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Uruu idi apostlenao koditaꞌakan naa kootowapa-kidauzonao pidannao bii iki, tuukii ĩkonaukian. Ushaꞌapanum kauꞌan ĩaitapa Tominkaru wuruꞌu kashaapaꞌoraz ĩantamikita-kao Jesus dikin ii. ");
INSERT INTO wapNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ipai kamoo apostlenao tominapa-kidan pidannao, naꞌiki ĩkowaadapan Kaimanaꞌo Kuwai Tominkaru Dapu ii, naꞌiki ĩdapu kawanaꞌati kida. Ĩkowaadapan ĩꞌati, mishiꞌo wuruꞌu Jesus, uruu Christ. ");
INSERT INTO wapNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Uruu daunaꞌan iribaꞌa naa Jewnao, Israel anainaouz, mishidan. Iriba kapam baokoinao Jewnao mishidan, waꞌatiinao kidaz baꞌoran amazada iki, ĩparadaniitaniꞌi naa Greek paradan. Ĩnao toꞌorainpan, naꞌiki ĩkaakapautan pamin-Jewnao, wuruꞌu Israel an kidaꞌoraz ĩmashaapan. Ushaꞌapanum kauꞌan ipai kamoo wanyukunui oo puraata buutauzo-kao zunnao ati, wuruꞌu mawakainao kidaz naa ĩdaiarunao. Mazan ĩkian aonaa ĩtaan patumaaka wanyukunui oo puraata wunao atiꞌi Jewabanao paradaniitaꞌoraz naa Greek paradan. ");
INSERT INTO wapNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Uruu idi 12 apostlenaouz, baokopatin-kidan ipai mishidainao, naꞌiki ĩkian ĩꞌati, “Aonaa turuu wasookadan wakowaadapan Tominkaru paradan, soo wabuutan dikin ii karikaonan puraata oo wanyukunui. ");
INSERT INTO wapNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Uabata õiribannao, uikoda mishiꞌoraiman 7 daonaioranao unao bii iki, Kaimanaꞌo Doronaa maꞌozakadapaniinao ĩnyukunuu, naꞌiki aitapaabainao. Marii kizi ĩnao buutaꞌo nii puraata naꞌiki wanyukunui. Uruꞌo niꞌi naa ĩkaudin-kizi nii. ");
INSERT INTO wapNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aizii waunao pakawanuꞌo nii paꞌan wakaudinan, watoriinpan nii Tominkaru ati, naꞌiki watominapa-kidan nii pidannao uparadan dauꞌu.” ");
INSERT INTO wapNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ipai pidannao nyukunuu naꞌapan apostlenao paradan kawanaꞌati. Uruu idi ĩzaamatan Stephen, mishidaꞌo manawun Tominkaru uruu, naꞌiki Kaimanaꞌo Doronaa maꞌozakadapanii unyukunuu. Ĩzaamata kapam Philip, Prochorus, Nicanor, Timon, Parmenas naꞌiki Nicolas Antioch san, uruu Gentile, mishidaꞌo Tominkaru naꞌapa Jewnao kawan, naꞌiki uruu mishidaꞌoraꞌa naa kapam Jesus. ");
INSERT INTO wapNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Udaunaꞌan mishidainao naꞌakan naa wuruꞌu pidannao pazaamataniinaouz, apostlenao diꞌiti. Uruu idi apostlenao muudan pakaꞌu ĩꞌidaꞌa, naꞌiki ĩtoriinpan Tominkaru ati, ukaminkaꞌuta kizi ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Udaunaꞌan powaꞌa zii Tominkaru Paradan abata-kao naꞌiki uiribainan naa. Uruu idi Jerusalem iaꞌo mishidainao iribainan powaꞌa zii manawun, naꞌiki iriba kapam naꞌiainao faadaanao izoꞌatin Tominkaru paradan, pamishidan idaꞌan Jesus. ");
INSERT INTO wapNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tuukii Tominkaru kaminkaꞌutan Stephen, utaa umaꞌozaka-kinaa nii. Uruu idaꞌan ushaꞌapata pabiꞌinaaka umanawun kidaꞌo aimaakan, iribaꞌo pidannao awun zaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mazan kainaꞌa pabiꞌi kida Jewnao kashadaakapan Stephen tuma, ukuwaa kida dauꞌan. Ĩnao wuruꞌu zaamatinpainaouz wuru diꞌitiꞌi, dakota-kariwaiz, Poitorui-daunnao Synagoguegan kii. Ĩnao waꞌatinaouz Cyrene iki, baꞌorainao Alexandria iki. Pabiꞌi kida baꞌoran pidannao waꞌatin wiizai kida diꞌiki Cilicia naꞌiki Asia Baara iki kidaꞌo. ");
INSERT INTO wapNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mazan Stephen aitapa powaꞌa zii manawun ĩꞌai, ushaꞌapanum kauꞌan Kaimanaꞌo Doronaa kainaꞌan idi utuma. Uruu idi aonaꞌa naa ĩaitapan naꞌapam naa padakoꞌatin uparadan. ");
INSERT INTO wapNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Uruu idi ĩzaamatan daonaioranao mariidinaꞌo nii Stephen dauꞌu. Kaikapaꞌa wuruꞌu ĩdyuudanuz ĩmariidinan: “Waabatanii Stephen dakoopan Moses naꞌiki Tominkaru dikaudaꞌo idaꞌan.” ");
INSERT INTO wapNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sariapa mishi pidannao toꞌoraꞌakan, naꞌiki kazowautapainao Jewnao, naꞌiki tiichaapauzonao Moses kakinaori dauꞌu, tuukii ĩtoꞌoran Stephen ati. Udaunaꞌan ĩzaamataꞌakan naazu naꞌiki ĩnaꞌakaꞌakan naazu ipai Jewnao zowaunaanao kanaapu iti. ");
INSERT INTO wapNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Naꞌiki naꞌiaꞌa naa koshan ĩdyuudan pidannao mariidinan Stephen dauꞌu kootowapa-kidauzonao kanaapuꞌu. Kaikapaꞌa wuruꞌu pidannao mariidinanuz: “Diꞌoraz pidanaꞌa, karikaonan daꞌi udakoopan Tominkaru Dapu, naꞌiki wakakinaorinaa Moses taanii kidaz waꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Waabatanii ukian, Jesus Nazareth san kaboobiꞌian nii Tominkaru Dapu, naꞌiki upanaꞌadan nii ipai waunao kaduz, Moses taanii kidaz waꞌati wamashaapa-kinaa nii.” ");
INSERT INTO wapNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Sariapa pidannao, abatapainao, awunuupaꞌakan Stephen awun baara iti, naꞌiki ĩtukapan uawun baara kanada, ikodanii angel awun baara. ");
INSERT INTO wapNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sariapa Umanawunuꞌo Faadaa kian Stephen ati, “Mishiꞌo kaiwuruꞌu ĩparadan pudauꞌu kidaꞌoraz?” ");
INSERT INTO wapNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen dakoꞌatin ĩparadan kaikapaꞌa: “Õꞌinawuzunao, uabatan nii õparadan õdako iki aizii. Kotuaꞌa naa, Tominkaru umanawunuꞌoraz manawun aidinauzon wadarun Abraham ati, umashaapan donoꞌoraz zii Mesopotamia ii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uruu dono shaꞌatii ukian Abraham ati, ‘Pumako diꞌoraz puwiizi diꞌikiꞌi, naꞌiki puwaꞌaka puiribannao. Õnaꞌakan nii pugaru baꞌoran amazada iti.’ ");
INSERT INTO wapNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Uruu idi Abraham makon, naꞌiki uwaꞌakan pamashaapa-kizi tawuruꞌu Chaldiannao wiizaitapaniaz. Utuzutinan naa Haran iti, naꞌii zii ukawiizitinan, naꞌiaꞌa naa udaru mawakauzon. Uruu daunaꞌan shaꞌatii Tominkaru dyuudan naa koshan utuzutinan wuru idaꞌatiꞌi diꞌoraz amazadaꞌa unao mashaapa-kiziz naa. ");
INSERT INTO wapNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mazan uruu dono aonaꞌo zii shaꞌatii Tominkaru taan amazada Abraham idiwau nii. Mazan ukowaadan Abraham ati, pataan nii uꞌati naꞌiki ipai udainao ati, wuruꞌu diꞌoraz amazadaꞌa. Uruu dono aonaꞌo zii Abraham dani nii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Baꞌoran dono Tominkaru kian uꞌati, ‘Pudainao kawiizi-tinpan nii zii baꞌoran kaduz pidannao wiizi ii aka. Naꞌiaꞌo niꞌi naa ĩpoitoruitapa-kao, naꞌiki tuukiaꞌo nii ĩpatakaꞌuta-kao atii 400 wunu. ");
INSERT INTO wapNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mazan õpatakaꞌutan nii pidannao wuruꞌu poitoruitapainaouz ĩdyaun. Uruu daunaꞌan õkodita-kidan nii ipai pudani-daunnao Egypt iki, naꞌiki ĩwaꞌatin nii daꞌatiꞌi diꞌoraz amazada idaꞌati. Naꞌaꞌo niꞌi naa paꞌan ĩmanawuntapan õgaru,’ kiaꞌo wuruꞌu Tominkaru kiauzon uꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Naꞌiki kaikapaꞌo koshan Tominkaru kiauzon Abraham atiꞌi: ‘Õaipan nii pugaru naꞌiki ipai pudainao daonaioranao choota-kidinan, naꞌiki ipai ĩdainao diinaꞌitiꞌi, naꞌapaꞌo nii paꞌidiwaru ĩnaꞌapata-kao. Uruu idaꞌanaꞌo nii utukapa-kidan õpidanannao unao, naꞌiki mishi uizoꞌatin õparadan.’ Naꞌapaꞌa naa mishi Abraham shaꞌapatan aimaakan. 8 kamoo udani Isaac shakatan daunaꞌan, uruꞌu naa uchoota-kidanuzu Tominkaru dyuudan kawanaꞌati. Aizii Isaac dani Jacob, naꞌapa kapam uchoota-kidanuzu. Aizii Jacob dainao 12 shaꞌatii daonaioranao, ipai ĩnao naꞌapa kapam ĩchoota-kao. Ĩnao diꞌikiꞌo shaꞌatii wadarunnao tominan. ");
INSERT INTO wapNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Uruu Jacob dainao shaꞌatii tawuruꞌu selliauzoz padawuꞌichan Joseph Egypt iti poitorui nii ĩkishauzin idi uꞌati. Mazan karikaonan daꞌi Tominkaru kaminkaꞌutauzon uruu, ");
INSERT INTO wapNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","dikaudaꞌo aimaakan shaꞌapan an uꞌati. Aizii tawuruꞌu king, Egypt san dapada-kidauzon donoꞌoraz Joseph paꞌidaꞌati, Tominkaru tukapa-kida king ati wuruꞌu Joseph, kaimanaꞌo naꞌiki aitapaabaꞌo pidan. Sariapa king zaamatan Joseph udaruꞌo naobanai nii, kazowautapaꞌo nii ipai Egypt Baara sannao, naꞌiki awunuutapaꞌo nii ipai ushaꞌapauz kida. ");
INSERT INTO wapNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Udaunaꞌan shaꞌatii zamazi kaawan ipai Egypt ii aka, naꞌiki ipai Canaan ii aka. Tuukii shaꞌatii pidannao dopian. Naꞌiki wadarunnao, tuukii ĩdopian kapam, aonaꞌa naa ĩikodan pawanyukunuu nii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mazan Jacob abata kainaꞌa paꞌan wanyukunui, zaishi kaduz kida selliapa-kao Egypt ii. Uruu idi Jacob dyuudan paudainao, Joseph tuunizinao toriaꞌanan wanyukunui Egypt iti. ");
INSERT INTO wapNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Baꞌoran dono ĩmakon koshan, uruu uꞌitamautannaa ĩtoriinaꞌanan naꞌiti. Uruu donoꞌo naa shaꞌatii Joseph kowaadan paꞌinawuzunao ati kanom wuruꞌu paugaruz. Naꞌiki naꞌapainiꞌi naa king abatan Joseph iribannao dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Uruu donoꞌo tawuruꞌu Joseph dapada-kidauzonuz padaru naꞌiki ipai pairibannao. 75 uiribannao baokopatinan, ipai ĩmakon Jacob tuma Egypt iti. Naꞌiaꞌa naa shaꞌatii Jacob mawakauzon, naꞌiki udainao ipai kapam ĩmawakan naꞌii. Ĩnao wuruꞌu wadarunnaouz. ");
INSERT INTO wapNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mazan ipai shaꞌatii ĩdani-daunnao naꞌakan ĩnanaa kida, daꞌatiꞌi wawiizi Shechem ati. Wuru idaꞌatiꞌi baaranaiz, Abraham toriauzoniaz Shechem ii, Hamor dainao ai, puraata idiꞌoraz ukawinipinaatauzon. ");
INSERT INTO wapNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Aizii wuruꞌu kamoo maonapatan donoꞌo naa, Tominkaru mishiaꞌazoonuz naa paparadan utauzoniaz Abraham ati, uruu dono iribaꞌoraꞌa naa utakaan-daunnao Egypt ii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naꞌiki naꞌapain baꞌoraniꞌi naa King-tinan Egypt ii, aonaꞌa naa uaitapan Joseph dauꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Uruu idi udorotan naa paꞌantamikita-kinaa nii wadarunnao. Uruu donoꞌo naa upatakaꞌutan naa ĩdyaun tuukiaꞌo idaꞌan, udyuudauzonuz ĩkabootan paudainao amazada iti shakatainaouz zii, ĩmawaka kizi. ");
INSERT INTO wapNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Uruu donoꞌo Moses shakatauzonuz, konaunam sodiꞌo koraidaonaa. Idikinaudaꞌu kauzu shaꞌatii padaronao taapan naꞌiki ĩdizapan uruu padapu ii, udaunaꞌan aonaa naꞌitim naa udiza-kao. ");
INSERT INTO wapNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Uruu idi ĩkodita-kidan naazu padapu iki, mazan king dani zunaaba ikoda shaꞌatii wuruꞌu koraidaonaaz. Uruu idi ozaamatanuzu naꞌiki odyaupaitanuzu kaiman, naꞌapa paudani kawan manawun. ");
INSERT INTO wapNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kaimanaiman shaꞌatii tiichaanao tominapa-kidan Moses, ukauꞌan kaiman-daun uaitapan wuruꞌu Egypt Baara sannao aitapanii kidaz. Naꞌiki uruu paraabaꞌo manawun, naꞌiki uaitapa pashaꞌapatan pabiꞌinaaka kida aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Baudaꞌapa kamoo, Moses makon uawunuutaꞌanan pairibannao Israelitenaouz. Uruu dono uikodaniꞌi naa 40 uwunun. ");
INSERT INTO wapNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ukaawan ĩkaudin-kizi iti, utukapa Egypt san baꞌiziautapan Israelite. Sariapa Moses kaunaatan wuruꞌu pairiban baꞌizii-kaoaz, uruu idi ubaꞌiziaꞌakan naa Egypt san atii umawakan. ");
INSERT INTO wapNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses itiiman shaa pairibannao aitapan nii Tominkaru wuruꞌu dyuudaꞌoraz paugaru kazannaataꞌo nii ĩdyaun, mazan aonaa ĩdiꞌitinpan naꞌapa. ");
INSERT INTO wapNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Baꞌoran kamoo, Moses tukapan dyaꞌutam Israelitenao mizaataakapan. Sariapa umakon ĩꞌidiꞌiti utiwaan pakaimanaaka-kidan ĩdyaun. Ukian ĩꞌati, ‘Uabata õiribannao, aonaa umizaataakapaꞌanaꞌa, oo umashaapaꞌanaꞌa uiriban atiaaka kaikapaꞌa.’ ");
INSERT INTO wapNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Mazan wuruꞌu baꞌiziautapaꞌoraz pairiban, sariapa ukidaꞌukaꞌakan Moses naꞌiki ukian uꞌati, ‘Aonaa puzaamata-kao kazowautapaꞌo nii waunao oo dyuudaꞌo nii naꞌapam washaꞌapatinan. ");
INSERT INTO wapNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Puzowiaꞌazon shaꞌa õgaru, puzowian kawan Egypt san munumun?’ ");
INSERT INTO wapNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses abatan idi unaꞌapan, sariapa utariaꞌakan. Uaitapa baꞌoran pidannao aitapaꞌakaniꞌi naa wuruꞌu uzowiinuz pidan. Sariapa Moses kidoopan Egypt iki, umakon atii Midian iti. Naꞌiaꞌa naa umashaapan, tawarai nii, atii umazidan naa naꞌii sanaaba tuma. Dyaꞌutam shaꞌatii ĩdainao daonaioranao. ");
INSERT INTO wapNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“40 wunu daunaꞌan shaꞌatii, angel aidinauzon Moses ati, tikazi maodapan kazamakaꞌo koꞌoriꞌo diꞌiki, mapidantakaꞌo amazada baara ii, maonapaꞌoraz midukuo Sinai ii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tuukii shaꞌatii Moses diꞌitinpan, utukapan idi kazamakaꞌo maodapan udaru. Sariapa umaonapadinan naꞌiti, utukapaꞌazoonuzu kaimanaiman. Upuꞌu uabatan Naobanai Tominkaru paradan paꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Õgaru pudarunnao Abraham, Isaac, naꞌiki Jacob Tominkarun,’ ukian. Tuukii Moses naka-nakaan patarian idi, naꞌiki aonaꞌa naa ukaꞌiitan paawunuupaꞌakan tikazi diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Udaunaꞌan Naobanai kian naa Moses ati, ‘Pusoꞌota pudazkida, umanawunuꞌo baaraꞌaꞌo wuruꞌu pukadishitapanuz, õkainaꞌan idi daꞌaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mishi õtukapa naꞌapam Egypt Baara sannao patakaꞌutan õpidanannao udawunuꞌiti manawun. Õabata ĩdopian tuukii õꞌati, uruu idiꞌo õaidinan puꞌati, õkazannaataꞌazon idi ĩdyaun. Aizii õdyuudan nii pumakon Egypt iti,’ kiaꞌo wuruꞌu Tominkaru kiauzon Moses ati.” ");
INSERT INTO wapNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stephen kian koshan ĩꞌati, “Uruu Moses tawuruꞌu kaminkaꞌutaꞌazoꞌoraz pairibannao Israelitenao. Mazan ĩkian shaꞌatii uꞌati, ‘Aonaa puzaamata-kao kazowautapaꞌo nii waunao oo dyuudaꞌo nii naꞌapam washaꞌapatinan.’ Mazan paaipan ati Tominkaru dyuudan Moses kazowautapaꞌo nii, naꞌiki kazannaataꞌo nii ĩdyaun ĩpatakaꞌuta-kao ai. Tominkaru zaamatan uruu, angel aidinan idaꞌan uꞌati tikazi maodapaꞌo diꞌii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ukauꞌan uruu Moses tawuruꞌu kodita-kidaꞌoraz wadarunnao Egypt iki. Tominkaru idaꞌan maꞌozaka shaꞌatii, Moses shaꞌapatan pabiꞌinaaka umanawun kidaꞌo aimaakan pakodita-kida-kinaa nii ĩdyaun Egypt iki, atii utarauka-kidan paran ĩꞌati, dakota-kariwaiz Red Sea kii. Naꞌikiꞌi naa shaꞌatii unaꞌakapan ĩdyaun mapidantakaꞌo amazada baara an. Ushaꞌapata umanawun kidaꞌo aimaakan naꞌiiꞌaka, atii 40 wunu. ");
INSERT INTO wapNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Uruu Moses tawuruꞌu kiauzoz ipai Israelitenao ati kaikapaꞌa: ‘Tominkaru zaamatan nii pidan unao bii iki prophet nii, naꞌapa õgaru kawan.’ ");
INSERT INTO wapNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Naꞌiki uruu Moses tumaꞌo shaꞌatii tawuruꞌu wairibannao Israelite kasabaꞌukinauzonuz mapidantakaꞌo amazada baara ii. Uruu donoꞌo shaꞌatii angel Tominkaru diꞌikiꞌo paradauzonuz Moses ati midukuo Sinai paawa ii. Utaan donoꞌoraz Moses ati kakinaorii, kaimanaꞌo mashaapa-kinai niꞌo, udobata-kidan niꞌo wadarunnao ati, naꞌiki waunao atiꞌo kapam. ");
INSERT INTO wapNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mazan upuꞌu aonaꞌa naa ĩaipan Moses pazowaunaa nii, uruu idi aonaꞌa naa ĩizoꞌatiꞌizon uparadan. Mazan ĩnyukunuu Egypt iti paꞌidiwaru, tuukii ĩkiwaꞌazon powaa iti. ");
INSERT INTO wapNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Moses naꞌian puꞌu zii midukuo Sinai ii Tominkaru tuma, uruꞌu naa pidannao kian Aaron ati, ‘Putomaꞌa naa watominkarunnao nii, kazowautapaꞌo niꞌi naa waunao. Ushaꞌapanum kauꞌan aonaa waaitapan naꞌiam naa Moses kodita-kidaꞌoraz waunao Egypt iki,’ ĩkian. ");
INSERT INTO wapNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Uruu donoꞌoraꞌa naa tawuruꞌu ĩtomauzonuz patominkarun nii, ĩtomanuzu naꞌapa tapiꞌiza kawan. Udaunaꞌan ĩkawaodan naa kaznizo, pataan niꞌi naa patominkarun ati. Udaunaꞌan ĩkasabaꞌukinan naa udazaba an, uruu ĩkonaukiitin-kidan naa wuruꞌu patomaniaz patominkarun nii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Tuukii Tominkaru toꞌoran ĩꞌati. Uruu idi umarinaꞌataꞌakan naa ĩdyaun. Marii kiziꞌi naa ĩtoriinpan patominkarunnao ati kidaꞌa naa karikaonan, wuruꞌu doko ii kidaꞌoraz, kamoo, kauzu, naꞌiki wizinao kidaz. Uruu kawanaꞌatiꞌo tawuruꞌu Tominkaru prophetinnao saadauzoniaz. Kaikapa shaꞌatii tawuruꞌu usaadauzonii kianuz: ‘Unao Israelitenao, karikaonan daꞌi utaan naꞌiki ukawaodauzon uzainao, uchiꞌikapauzon donoꞌoraz 40 wunu, mapidantakaꞌo amazada ii aka. Mazan aonaa õgaru atiꞌo mani daꞌi tawuruꞌu ukawaodauzonuz uzainao, ");
INSERT INTO wapNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","soo utominkarun Molech atiꞌo karikaonan. Uruu unao naꞌakapauzonii padapunaa tuma. Naꞌiki unaꞌakapauzonii kapam baꞌoran utominkarun Rephan, wizi kawanuꞌoraz utoman. Ĩnao utomanii kidaz utominkarunnao nii, ĩnao atiꞌo karikaonan, tawuruꞌu utoriinpauzonuz. Uruu idi õkashaapan nii utarubanao zaamatan unao, marii kizi ĩnaꞌakan unao munapo, munapo baꞌoran amazada iti, Babylon dawun itinapu.’” ");
INSERT INTO wapNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stephen kian koshan, “Kotuaꞌa naa, wadokozu-daunnao chiꞌikapauzon donoꞌoraz mapidantakaꞌo amazada diꞌiiꞌaka, ĩnaꞌakapauzonii patuma Tominkaru kakinaori pakarannaa, padapunaa tuma. Uruu ĩnyukunuitapa-kinaa Tominkaru kainaꞌan patuma. Utoma-kao naꞌapa Tominkaru kowaadauzon kawanaꞌatiꞌo, naꞌiki uaida-kidan kawanaꞌatiꞌo Moses ati wuruꞌu ukakinaori pakarannaa dapunaa toma-kaoaz. ");
INSERT INTO wapNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kotuaꞌiki uruu daunaꞌan, Joshua naꞌakan naꞌiki ukazowautapan donoꞌo naa wadokozu-daunnao, taa-kariwaiꞌi naa shaꞌatii ĩꞌati Tominkaru kakinaori pakarannaa padapunaa tuma, ĩdarunnao dobata-kidaniꞌi naa ĩꞌati. Naꞌiki uruu donoꞌoraꞌa naa shaꞌatii tawuruꞌu Tominkaru waatauzonuz pawiizi ai Gentilenao. Uruu amazadaꞌa naa shaꞌatii wadarunnao zaamata pawiizi nii. Naꞌiki naꞌitiꞌi naa ĩnaꞌakauzon Tominkaru kakinaori pakarannaa, padapunaa tuma. Naꞌiaꞌa naa shaꞌatii utaapa-kao atii David king-tinan diꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kaiman shaꞌatii Tominkaru nyukunuu David ati, naꞌiki uruu pishauzoz Tominkaru, uaipan patoman kabaun uꞌati, Israelitenao Tominkarunuz. ");
INSERT INTO wapNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mazan David dani, Solomon atiꞌi naa paꞌan Tominkaru toma-kidauzon padapu nii. ");
INSERT INTO wapNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Mazan waaitapa, aonaa Tominkaru umanawunuꞌoraz mashaapan kabaun pidan tomanii nazoꞌo. Kaikapa shaꞌatii tawuruꞌu prophet saadanii kian: ");
INSERT INTO wapNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Aokazi, uruu õnaobanai-tinapa-kizi tabanaa. Aizii imiꞌi baara, uruu õsaabatapa-kizi karikaonan õkidiba. Shaꞌapaꞌoram nii mooko kabaun putoma õꞌati?’ Naobanai kian. ‘Turuu mooko puaitapan putoman kabaun õsookapa-kizi nii? ");
INSERT INTO wapNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Aonaa mooko õtomanii mani õkaꞌu idi ipai wuruꞌu aimaakan kidaz?’” ");
INSERT INTO wapNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Udaunaꞌan Stephen kian koshan kootowapa-kidauzonao pidannao ati, “Mishi unao dadara unyukunuu. Aonaa umishidaꞌazon Tominkaru, naꞌiki aonaa uabataꞌazon uparadan. Naꞌiki tuukii udikintapan Kaimanaꞌo Doronaa, naꞌapa manawun unao, udarunnao kawan. ");
INSERT INTO wapNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ĩnao ipai ĩantamikitan Tominkaru prophetinnao. Atii ĩzowiauzo nii wunaouꞌu kowaadapauzonaouz Tominkaru dyuudaꞌazon dauꞌan Kaimanaꞌo Papoitoru. Udyuudaꞌa naa mishi wuruꞌu papoitoruz, uruꞌu naa tawuruꞌu unao zaamata-kidaniaz naꞌiki uzowii-kidaniaz. ");
INSERT INTO wapNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Unao atiꞌo padamata ipai kakinaorii taa-kao, tawuruꞌu Tominkaru dyuudauzoniaz angelnao kowaada-kidan udokozu-daunnao ati. Mazan upuꞌu aonaa uizoꞌatiꞌizon wuruꞌu kakinaorii kidaz,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ĩabatan idi Stephen paradan naꞌapa, tuukii ĩtoꞌoraꞌakan uꞌati naꞌiki ĩkuzowan paudako. ");
INSERT INTO wapNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mazan maꞌozaka Stephen nyukunuu Kaimanaꞌo Doronaa aipan ati. Uawunuupan doko iti aokazi iti, utukapa kanada Tominkaru umanawunun kanadapan naꞌii, naꞌiki utukapa Jesus kadishitapan Tominkaru diwaꞌora antanapu. ");
INSERT INTO wapNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Uruꞌu naa ukian kootowapa-kidauzonao pidannao ati, “Utukapa! Aokazi daꞌatinan, naꞌiki õtukapa Daonaiora Aokazi Ikiꞌo kadishitapan Tominkaru diwaꞌora antanapu.” ");
INSERT INTO wapNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sariapa kootowapa-kidauzonao pidannao kadakoinaꞌakan, ĩtaratan pakinao kida uparadan ai. Naꞌiki ĩzaamataꞌakan naa uruu. ");
INSERT INTO wapNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Udaunaꞌan ĩkozootaꞌakan naa uruu wiizai dawun iti. Naꞌiaꞌa naa ĩnarakaꞌakan naa pashooton kida. Kainaꞌa pidan, Saul kiaꞌo uꞌuu. Uruu atiꞌi naa ĩawunuutapa-kidan pashooton kida. Naꞌiaꞌa naa ĩboowautapan Stephen kuba idi, aonaa masakaudaꞌu mani. ");
INSERT INTO wapNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mazan upuꞌu Stephen toriinpan. Ukian, “Õnaobanaa Jesus, puzaamata õdoronaa.” ");
INSERT INTO wapNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Udaunaꞌan ukodoruꞌukan naꞌiki uparadan diiwaꞌo idaꞌan. “Õnaobanaa, manaꞌa pupatakaꞌutaꞌanaꞌa ĩdyaun paꞌoian dikin ii,” ukian. Uruꞌu naa mazan umawakaꞌakan naa. ");
INSERT INTO wapNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kaiman Saul ati Stephen zowii-kao. Stephen zowii-kao daunaꞌan, powaꞌa zii manawun mishidainao patakaꞌuta-kao Jerusalem ii. Uruu idi mishidainao kidoopaabiꞌiinan Judea Baara iti kida, naꞌiki Samaria Baara iti kida. Mazan apostlenao aonaa ĩkidoopan paꞌan. Ĩnaꞌian zii Jerusalem ii. ");
INSERT INTO wapNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kainaꞌa pidannao naꞌii mishidainao Tominkaru. Tuukii ĩnyukunuu kashaꞌoran Stephen zowii-kao idi. Udaunaꞌan ĩdidan naazu, naꞌiki ĩmuraan uruu tuukii. ");
INSERT INTO wapNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mazan Saul, tuukii uaipan pamainaabatan mishidainao. Uruu idi umakon ĩdapu kawanaꞌati kida. Uikodan dono mishidainao, daonaioranao naꞌiki zunnao, ukozootan nii ĩdyaun padapu iki, naꞌiki utaraa-kidan niꞌi naa ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Aizii mishidainao wuruꞌu kidoopainaouz Jerusalem iki, ĩkowaadapan naa Kaimanaꞌo Kuwai Jesus dauꞌu pidannao ati pamakopa-kizi kawanaꞌati. ");
INSERT INTO wapNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Aizii Philip, umakon donoi Samaria iti, naꞌiiꞌakaꞌa naa ukowaadapan Kaimanaꞌo Kuwai pidannao ati Christ dauꞌu. ");
INSERT INTO wapNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iriba daꞌi pidannao kasabaꞌukinan, naꞌiki tuukii ĩabataꞌazon Philip kuwaa kaimanaiman. Ushaꞌapanum kauꞌan ĩtukapan idi Philip shaꞌapatan iriba umanawun kidaꞌo aimaakan, aonaꞌoraz turuu pidan shaꞌapatauzon. ");
INSERT INTO wapNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Iriba ukodita-kidan oiaꞌo doronainao pidannao diꞌiki. Naꞌiki diiwa ĩkadakoinan wuruꞌu ĩkoditanuz pidannao diꞌiki. Naꞌiki iriba uchiꞌika-kidan pidannao machiꞌika-kainao naꞌiki tokoozaꞌuupainao. ");
INSERT INTO wapNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Uruu dono tuukii pidannao konaukian naꞌii. ");
INSERT INTO wapNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aizii Samaria ii kainaꞌa marunao, Simon kiaꞌo uꞌuu. Kotuaꞌikiꞌoraꞌa naa udiꞌitinapa-kidan pidannao pamarunaowiinpan idaꞌan. Naꞌiki uruu tuukiaꞌo uꞌatadinpan naꞌiki udakotinpan aitapaꞌo pidan nii. ");
INSERT INTO wapNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ipai pidannao Samaria ii, waranuitapa-kariwainao, naꞌiki umanawun-tinpainao, tuukii ĩmishidan Simon. Uruu idi ĩkian udauꞌan, “Tominkaru diꞌikiꞌo uikodan wuruꞌu umanawunuꞌoraz maꞌozaka-kinai.” ");
INSERT INTO wapNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tuukii ĩmishidan marunao, ushaꞌapanum kauꞌan kotuaꞌikiꞌoraꞌa naa udiꞌitinapa-kidan pidannao pashaꞌapaapanii kida aimaakan dauꞌu pamarunaowiinpan idaꞌan. ");
INSERT INTO wapNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aizii Philip, ukowaadapan idiꞌi naa ĩꞌati Kaimanaꞌo Kuwai Tominkaru naobanai-tinan dauꞌu, naꞌiki Jesus uruu mishiꞌo Christ. Uruu idi zunnao naꞌiki daonaioranao mishidan Philip kuwaa, naꞌiki ĩchikaawunuinan naa. ");
INSERT INTO wapNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Aizii Simon, umishida Philip kuwaa, uruu idi uchikaawunuinan naa kapam. Uruu daunaꞌan karikaonan umakon naꞌiki uchiꞌikapan Philip dawuꞌati. Naꞌiki tuukii udiꞌitinpan, utukapan idi naꞌapam Philip shaꞌapatan umanawun kidaꞌo aimaakan. ");
INSERT INTO wapNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aizii apostlenao Jerusalem iainao abataꞌa naa wuruꞌu Samaria Baara sannao mishidanuz Tominkaru Paradan, uruu idi ĩdyuudan Peter naꞌiki John ĩꞌidiꞌiti. ");
INSERT INTO wapNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ĩkaawan daunaꞌan, uruꞌu naa Peter naꞌiki John toriinapa-kidan mishidainao Tominkaru ati, Kaimanaꞌo Doronaa morotin kizi ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ushaꞌapanum kauꞌan Philip chikaawunuuniꞌi naa ĩdyaun, ĩmishidan idi Naobanai Jesus, mazan aonaa zii Kaimanaꞌo Doronaa nii ĩꞌidaꞌa. ");
INSERT INTO wapNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Uruꞌu naa Peter naꞌiki John muudan pakaꞌu ipai wunao idaꞌatiꞌi mishidainaouz, sariapa Kaimanaꞌo Doronaa morotinan ipai ĩdyaun. ");
INSERT INTO wapNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aizii Simon, wuruꞌu marunao-tinpauzoz, udiꞌitapan wuruꞌu Kaimanaꞌo Doronaa morotinanuz mishidainao, apostlenao muudan idaꞌan pakaꞌu ĩꞌidaꞌa. Sariapa utaaꞌazon puraata apostlenao ati. ");
INSERT INTO wapNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ukian ĩꞌati, “Utaa kapam õꞌati wuruꞌu maꞌozaka-kinaiz, naꞌapa kizi kapam Kaimanaꞌo Doronaa morotinan ipai õpishatanii pidannao.” ");
INSERT INTO wapNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mazan Peter kian uꞌati, “Marii Tominkaru mainaabatan pupuraatan putuma. Puꞌitiiman toriauzo-kariwai puraata idaꞌan wuruꞌu maꞌozaka-kinai, mawinipinaa-daunuꞌoraz Tominkaru taan? ");
INSERT INTO wapNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aonaa turuu pukaudinan watuma Tominkaru paradan dauꞌu. Ushaꞌapanum kauꞌan Tominkaru aitapa punyukunuu, uaitapa pudiꞌitinpan panaꞌiti karikaonan. ");
INSERT INTO wapNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ukauꞌan pumarinaꞌataꞌa naa wuruꞌu pudiꞌitinapanuz oiaꞌo dauꞌu, putoriinapa naꞌiki pupishaa Tominkaru, panaadon usoꞌotan nii wuruꞌu oiaꞌoraz naꞌiki dikaudaꞌoraz aimaakan pudiꞌitapan. ");
INSERT INTO wapNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ushaꞌapanum kauꞌan õtukapa tuukii manawun pukishauzin waunao ati, naꞌiki tuukii manawun pushaꞌapataꞌazon oiaꞌo, oiaꞌo zaamatapan idi pugaru kaimanaiman,” ukian. ");
INSERT INTO wapNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sariapa Simon kian ĩꞌati, “Õaiapa utoriinpan Naobanai ati õdauꞌan, aonaa kizi dikaudaꞌo aimaakan shaꞌapan õꞌati, pukian kawan.” ");
INSERT INTO wapNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aizii Peter naꞌiki John ipaian daunaꞌan pakowaadapan ipai paabatanii, naꞌiki patukapanii kida Naobanai Jesus shaꞌapaapauzon, naꞌiki ĩkowaadapan daunaꞌan uparadan kida, ĩkiwan naa Jerusalem iti. Mazan pakiwapa-kizi an ĩkowaadapaanan naa Kaimanaꞌo Kuwai pidannao ati, iriba wiizainao kawanaꞌati, Samaria ii aka kidaꞌoraz. ");
INSERT INTO wapNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Baudaꞌapa kamoo, angel, Tominkaru diꞌikiꞌo, kian Philip ati, “Pumako Jerusalem ikiꞌo dunapo diꞌiti, Gaza itiꞌoraz makoꞌoraz mapidantakaꞌo amazada an.” ");
INSERT INTO wapNT_vpl VALUES ("AC8_27","074_8_27"