﻿USE sofia;
DROP TABLE IF EXISTS sofia.wal_vpl;
CREATE TABLE wal_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES wal_vpl WRITE;
INSERT INTO wal_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Xoossai salotanne sa7aa koiro medhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","He wode sa7ai giigiichchibeennanne aibinne bainna mela; ciimmaa bollan xumai de7ees; Xoossaa Ayyaanai haattaappe bollaara maayi uttiis. ");
INSERT INTO wal_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Xoossai hegaappe guyyiyan hagaadan yaagidi haasayiis; “Poo7oi hano” yaagiis; yaagin poo7oi haniis. ");
INSERT INTO wal_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Poo7oi lo77o gididoogaa Xoossai be7iis; be7idi poo7uwaa xumaappe shaakkiis. ");
INSERT INTO wal_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Xoossai poo7uwaa “Gallassa” giidi sunttiis; xumaa “Qamma” giidi sunttiis. Sa7ai qammiisinne wonttiis; hegeenne koiro gallassa. ");
INSERT INTO wal_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Xoossai hegaappe guyyiyan hagaadan yaagidi haasayiis; “Bollaara de7iya haattaa garssaara de7iya haattaappe shaakkiya salo gufanttoi hano” yaagiis; yaagin haniis. Xoossai salo gufanttuwaa giigissidi, salo gufanttuwaappe bollaara de7iya haattaa garssaara de7iya haattaappe shaakkiis. ");
INSERT INTO wal_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Xoossai he gufanttuwaa “Saluwaa” giidi sunttiis. Sa7ai qammiisinne wonttiis; hegeenne naa77antto gallassa. ");
INSERT INTO wal_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Xoossai hegaappe guyyiyan hagaadan yaagidi haasayiis; “Saluwaappe garssaara de7iya haattai issisan eello; eellin mela sohoi qoncco” yaagiis; yaagin haniis. ");
INSERT INTO wal_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Xoossai he mela sohuwaa “Biittaa” giidi sunttiis; qassi issisan eellida haattaa “Abbaa” giidi sunttiis. Yaatidi Xoossai hegee lo77o gididoogaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hegaappe simmin Xoossai, “Biittai mittaa maataa mokko; zeretta aifeera de7iya kattaanne zeretta aifeera de7iya teeriya mittaa mokko” yaagiis; yaagin haniis. ");
INSERT INTO wal_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Biittai mittaa maataa a qommuwan qommuwan mokkiis. Mokkin Xoossai hegee lo77o gididoogaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Sa7ai qammiisinne wonttiis; hegeenne heezzantto gallassa. ");
INSERT INTO wal_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Xoossai hegaappe guyyiyan hagaadan yaagidi haasayiis; “Gallassaa qammaappe shaakkanau poo7oti salo gufantton hanona; eti gallassaa, wodiyaanne laittaa erissanau malaata gidona; ");
INSERT INTO wal_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","sa7aa bollan poo7issana mala eti salo gufantton poo7ona” yaagiis; yaagin haniis. ");
INSERT INTO wal_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Xoossai naa77u gita poo7ota, gitatiyaagee gallassaa haaranaadaaninne guuxxiyaagee qammaa haaranaadan medhdhiis; xoolinttetakka i medhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Xoossai eti ha sa7aa bollan poo7issana mala, gallassaanne qammaa haarana malanne poo7uwaa xumaappe shaakkana mala, salo gufantton eta wottiis. Yaatidi Xoossai hegee lo77o gididoogaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Sa7ai qammiisinne wonttiis; hegeenne oiddantto gallassa. ");
INSERT INTO wal_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Xoossai hegaappe guyyiyan hagaadan yaagidi haasayiis; “Paxa de7iya dumma dumma meretati haattan darona; kafoikka sa7aappe bollaaranne salo gufanttuwaappe garssaara paallo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yaatidi Xoossai abban de7iya gita do7ata, haatta giddon woxxi qaaxxiya meretata ubbaanne qefiyaara de7iya kafuwaa ubbaa a qommuwan qommuwan medhdhiis. Medhdhidi Xoossai hegee lo77o gididoogaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Xoossai eta, “Yelettite; corattite; abbaa haattaa kumite; kafoikka biittaa bollan coratto” yaagidi anjjiis. ");
INSERT INTO wal_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Sa7ai qammiisinne wonttiis; hegeenne ichchashantto gallassa. ");
INSERT INTO wal_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Xoossai hegaappe guyyiyan hagaadan yaagidi haasayiis; “Paxa de7iya meretati bantta qommuwan qommuwan: meheti, biittaara gooshettiya meretatinne do7ati bantta qommuwan qommuwan biittaa bollan kiyona” yaagiis; yaagin haniis. ");
INSERT INTO wal_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Xoossai do7ata eta qommuwan qommuwan, mehetakka eta qommuwan qommuwaaninne, biittaara gooshettiya meretatakka ubbaa eta qommuwan qommuwan medhdhiis. Medhdhidi Xoossai hegee lo77o gididoogaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hegaappe simmin Xoossai, “Asa nu leemisuwan nuna milatissidi ane medhdhoos; medhdhin eti abbaa moliyaa, saluwaa kafuwaa, biittaa bolli woxxi qaaxxiya mereta ubbaa haarona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hagaadan Xoossai asaa ba leemisuwan medhdhiis; i a Xoossaa leemisuwan medhdhiis; i eta attumaasanne maccaasa medhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Xoossai eta hagaadan yaagidi anjjiis; “Yelettite; corattite; ha sa7aa kumitenne haarite; abbaa moliyaa, saluwaa kafuwaanne biittaa bolli woxxi qaaxxiya, paxa de7iya mereta ubbaa haarite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hegaappe simmin Xoossai, “Be7ite! Taani ha biitta ubbaa bollan zeretta aifeera de7iya katta ubbaanne zeretta aifeera de7iya teeriya mitta ubbaa intteyyo immaas; etinne intteyyo quma gidana. ");
INSERT INTO wal_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Qassikka ha sa7an de7iya mehenne do7a ubbaayyo, saluwaa kafo ubbaayyo, biittaara gooshettiya mereta ubbaayyoonne shemppoora paxa de7iya mereta ubbaayyo miyoobaa gidanaadan, irxxa mittaanne maataa immaas” yaagiis; yaagin haniis. ");
INSERT INTO wal_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Xoossai ba medhdhido ubbabaakka xeelliis; xeellidi daro lo77o gididoogaa be7iis. Sa7ai qammiisinne wonttiis; hegeenne usuppuntto gallassa. ");
INSERT INTO wal_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Salotinne sa7ai etan de7iyaabai ubbabai hagaadan oosetti polettiis. ");
INSERT INTO wal_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Xoossai ba oottido oosuwaa usuppuntta gallassi polidi, ba oottido ooso ubbaappe laappuntta gallassi shemppiis. ");
INSERT INTO wal_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Qassi Xoossai laappuntta gallassaa anjjiisinne geeshsha oottiis; aissi giikko, Xoossai ba oottiyo oosuwaa wurssidi shemppidoi he gallassaana. ");
INSERT INTO wal_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Salotinne sa7ai merettidoogee hagaadaana. GODAI Xoossai sa7aanne salota medhdhido wode, ");
INSERT INTO wal_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","sa7aa bollan mittinne maati mokkibeenna; carshshinne caaribeenna; aissi giikko, GODAI Xoossai ira bukissiichchibeenna; qassi biittaa oottiya asinne baawa. ");
INSERT INTO wal_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Gidikkonne sa7aappe haattai pude kiyidi, biittaa ubbaa irxxissees. ");
INSERT INTO wal_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hegaappe guyyiyan, GODAI Xoossai biittaa baanaappe issi asa medhdhiis; medhdhidi a siiriyan de7o shemppuwaa shemppi gelissiis; yaatin bitanee paxa de7iya asa gidiis. ");
INSERT INTO wal_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","GODAI Xoossai awai mokkiyoosaa baggaara Edene giyoosan gannatiyaa kase tokkiis; yan ba medhdhido bitaniyaa wottiis. ");
INSERT INTO wal_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","GODAI Xoossai xeellanau lo77iya, maanaukka mal77iya ubba qommo mittaa biittaappe mokissiis. Gannatiyaa gidduwan de7o mittaanne lo77uwaanne iitaa erissiya mittaa wottiis. ");
INSERT INTO wal_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gannatiyaa ushshiya shaafaa haattai Edeneppe goggees. Edeneppe kiyidoogaappe guyyiyan, oiddu shaafa kiyi shaahettees. ");
INSERT INTO wal_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Koiro shaafaa sunttai Pishoona; Pishooni worqqai de7iyo Hawiila giyo biitta ubbaa bollan goggees. ");
INSERT INTO wal_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","He biittaa worqqai geeshsha worqqa; qassi al77o shittoinne keehi lo77iya shuchchai yan de7ees. ");
INSERT INTO wal_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Naa77antto shaafaa sunttai Giyoona; Giyooni Toophphiyaa biitta ubbaa bollan goggees. ");
INSERT INTO wal_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Heezzantto shaafaa sunttai Xegiroosa; Xegiroosi Asooreppe arshsho baggaara goggees. Qassi oiddantto shaafai Efiraaxiisa. ");
INSERT INTO wal_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Bitanee Edene Gannatiyaa oottana malanne naagana mala, GODAI Xoossai a efiidi wottiis. ");
INSERT INTO wal_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Wottidi GODAI Xoossai bitaniyaa, “Gannatiyaa mittaa teeraa ubbaappe neeni maana giikko ma; ");
INSERT INTO wal_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","shin lo77uwaanne iitaa erissiya mittaa teeraappe mooppa; aissi giikko, neeni appe miido gallassi tumu haiqqana” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hegaappe guyyiyan GODAI Xoossai, “Bitanee barkka de7iyoogee lo77o gidenna; taani ayyo injjetiyaabaanne a maaddiyaabaa kessana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","GODAI Xoossai kase meheta ubbaa, do7ata ubbaanne saluwaa kafota ubbaa biittaappe medhdhiis; qassi bitanee eta woigi sunttiyaakkonne siyanau akko ehiis; ehin bitanee paxa de7iya meretata ubbaa sunttido sunttai eta suntta gididi attiis. ");
INSERT INTO wal_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hegaadan bitanee meheta ubbaa, saluwaa kafotanne bazzo do7ata ubbaa sunttiis; shin Addaamessi injjetiyaabinne a maaddiyaabi beettibeenna. ");
INSERT INTO wal_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hegaa gishshau GODAI Xoossai bitaniyaa xiskkuwaa kairissiis; i xiskkuwaa kairidaashin, a miyyiyaa meqettaappe issuwaa ekkidi, he sohuwaa ashuwaa kunttiis. ");
INSERT INTO wal_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Kunttidi GODAI Xoossai bitaniyaappe ekkido meqettaa macca asa kessiis; yaatidi o bitaniyaakko ehiis. ");
INSERT INTO wal_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ehin bitanee; “Hayyashsho! Ha meqettiyaa ta meqettaappe, ha ashiyaakka ta ashuwaappe ekettidaaro; akka attuma asaappe ekettido gishshau, macca asa geetettu” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hegaa gishshau asi ba aawaanne ba aayyiyo aggi bayidi, ba machcheera issippe de7ees; eti naa77ai issi asho gidoosona. ");
INSERT INTO wal_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Bitaneenne a keettaayyiyaanne naa77aikka kallo xiire de7oosona; shin issoi issuwau yeellatokkona. ");
INSERT INTO wal_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","SHooshshai GODAI Xoossai medhdhido do7a ubbaappe aadhdhida genanchcha. Issi gallassi shooshshai he maccaasiyo, “Xoossai tumu inttena, ‘Gannatiyan de7iya mitta teeraa ubbaappekka mooppite’ giidee?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Oichchin maccaasiyaa shooshshaayyo zaarada, “CHii, Xoossai hagaadan gibeenna; nuuni gannatiyan de7iya mittatu teeraa maanau danddayoos; shin Xoossai nuna, ‘Gannatiyaassi gidduwan de7iya mitta teeraa mooppite; bochchoppite; hinkkoode intte haiqqana’ giis” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","SHooshshai maccaasiyo, “CHii, intte ainnekka haiqqekketa; ");
INSERT INTO wal_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Xoossai hegaa giidoogee, he mittaa teeraa intte miikko, intte aifee dooyettin, lo77uwaanne iitaa Xoossaadan intte eranaagaa i eriyo gishshaassa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Maccaasiyaa he mittaa teerai maanau mal77iyaagaa, xeellanau lo77iyaagaa, qassi asi aadhdhida eratettaa demmanau amoyiyaagaa gidiyoogaa be7aasu; be7ada he mittaa teeraappe ekkada maasu; qassi banaara de7iya ba azinaayyookka hegaappe immin, ikka miis. ");
INSERT INTO wal_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Miyoorin eta naa77aa aifeekka dooyetti aggiis; dooyettin eti banttau kallo xiire de7iyoogaa eridosona; eridi ettaa giyo mittaa haittaa sikkidi, banttayyo menttuwan gixxidosona. ");
INSERT INTO wal_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sa7ai omarido wode, gannatiyaa gidduwan GODAI Xoossai hemettishin, a giirettaa bitaneenne a keettaayyiyaa siyidosona; siyidi eti gannatiyaa mittaa giddon GODAA Xoossaappe qosettidosona. ");
INSERT INTO wal_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","SHin GODAI Xoossai bitaniyaa xeesidi, “Addaamee, awan de7ai?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Yaagin bitanee, “Gannatiyaa giddon ne giirettaa siyada, taani kallo de7iyo gishshau, yayyada qosettaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","GODAI Xoossai a, “‘Neeni kallo de7aasa’ giidi neeyyo odidai oonee? Taani nena, ‘Mooppa’ gaada azazido mittaa teeraappe maadiiyye?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Oichchin i, “Tanaara de7anaadan neeni immido maccaasiyaa he mittaa teeraappe tau immin maas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","GODAI Xoossai hegaappe guyyiyan maccaasiyo, “Neeni hegaa aissi oottadii?” yaagidi oichchiis. Yaagin maccaasiyaa, “Tana shooshshai cimmin maas” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","GODAI Xoossai hegaappe guyyiyan shooshshaa, “Neeni hagaa oottido gishshau, mehe ubbaanne do7a ubbaa garssan ne xalaalai qanggettidaagaa! Neeni ne uluwan biittaara gooshettana; ne de7o laitta ubbankka baanaa laaccana. ");
INSERT INTO wal_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Taani nenanne maccaasiyo, ne zerettaanne i zerettaa morkke kessana; i ne huuphiyaa qoxxana; neenikka a qirbbiyaa dukkana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Maccaasiyookka GODAI Xoossai, “Ne abbe ixetaa aginan neeni daro tuggatana; qassi neeni wolqqaama leessuwan naata yelana. Gidikkonne neeni ne azinaara de7anau amottana; i nena haarana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Bitaniyaakka GODAI Xoossai hagaadan yaagiis; “Neeni ne keettaayee oduwaa siyido gishshaunne taani nena, ‘He mittaa teeraa mooppa’ gaada azazido mittaa aifiyaappe neeni miido gishshau, biittai ne gaasuwan qanggettidaagaa gido! Neeni ne de7o laitta ubban gita daafuran biittaa oottada maana. ");
INSERT INTO wal_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Biittai neeyyo agunttanne kinddiichchuwaa mokkana; neeni bazzon mokkidabaa maana. ");
INSERT INTO wal_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Neeni biittau simmana gakkanaassi, daafuran ne som77oi cawattin oottido ne qumaa maana; aissi giikko, neeni biittaappe ekettadasa; neeni baana; neeni baanau simmana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Addaamee ba keettaayyiyo Hewaano giidi sunttiis; aissi giikko, a paxa de7iya asa ubbau aayo. ");
INSERT INTO wal_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","GODAI Xoossai Addaameyyoonne a keettaayeeyyo itiyaa giigissidi eta maizziis. ");
INSERT INTO wal_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hegaappe guyyiyan GODAI Xoossai, “Simmi asi nuuppe issuwaadan lo77uwaanne iitaa eriyaabaa gidiis. I ba kushiyaa yeddidi, de7o mittaappe ekkidi, qassi meenna malanne merinau paxa de7enna mala teqettanau koshshees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hegaa gishshau, i ba ekettido biittaa oottana mala, GODAI Xoossai Edene Gannatiyaappe a kessiis. ");
INSERT INTO wal_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A kessirggidi, de7o mittaakko efiya ogiyaa naagana mala, kiruubeta giyo kiitanchchatanne aadhdhi aadhdhi wodhdhiya tama laco bisuwaa Edene Gannatiyaappe arshsho baggaara wottiis. ");
INSERT INTO wal_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Addaamee ba keettaayee Hewaaniira aqiis; a abbe ixettada attuma na7a yelaasu; “GODAI tana maaddin, attuma na7a demmaas” gaada a Qaayeela sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Qassi a ishaa Aabeelakka yelaasu. Aabeeli dorssa heemmees; qassi Qaayeeli biittaa oottees. ");
INSERT INTO wal_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Unddenna wodiyaappe guyyiyan, Qaayeeli ba gaden mokkida kattaappe GODAAYYO yarshshuwaa yarshshiis; ");
INSERT INTO wal_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","shin Aabeeli ba dorssa wudiyaa giddon baira yelettida maratuppe ekkidi shukkidi, eta ashuwaappe modhdhiyaasaa yarshshiis. GODAI Aabeelanne a yarshshuwaa ekkiis; ");
INSERT INTO wal_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","shin Qaayeelanne a yarshshuwaa ekkibeenna. Hegaa gishshau, Qaayeeli keehi yiillotiis; ba som77uwaakka xumissiis. ");
INSERT INTO wal_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yaatin GODAI Qaayeela, “Aissi yiillotai? Ne som77oikka aissi xumidee? ");
INSERT INTO wal_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Neeni lo77obaa oottiyaabaa gidiyaakko, ne som77oi pashkkennee? SHin neeni lo77obaa oottana xayikko, nagarai do7adan ne penggen zuggees; i nena haarana koyees; shin neeni a xoonana bessees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hegaappe guyyiyan, Qaayeeli ba ishaa Aabeela, “Ane dembbaa boos” yaagiis. Biidi eti dembban de7ishin, Qaayeeli ba ishaa Aabeela bolli denddinne wori aggiis. ");
INSERT INTO wal_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Worin GODAI Qaayeela, “Ne ishai Aabeeli awaanee?” yaagidi oichchiis. Oichchin Qaayeeli zaaridi, “Taani erikke; ta ishaa naagiyaagee taneeyye?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yaagin GODAI Qaayeela, “Hagaa aissi oottadii? Be7a; ne ishaa suuttai biittaappe taakko waassees. ");
INSERT INTO wal_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ne kushiyaappe ne ishaa suuttaa ekkidi, mittanau hanggida biittaappe ha77i neeni qanggettidaagaa. ");
INSERT INTO wal_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Neeni oottinkka biittai neeyyo aifenna; betedan neeni sa7aa bollan toilattana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qaayeeli GODAA, “Poora! Neeni tana qaxxayiyo qixaatee taani mulekka danddayennaagaa. ");
INSERT INTO wal_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Hekko neeni tana hachchi ha biittaappe yedettaasa; taani ne sinttappe qosettana; betedan taani sa7aa bollan toilattana; tana demmai ooninne worana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yaagin GODAI a, “Nena ooninne worenna; worikko, ne haluwaa taani laappun kushiyaa kessana” yaagiis. Hegaa gishshau, demmai ooninne a worennaadan GODAI a bolli malaataa wottiis. ");
INSERT INTO wal_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Wottin Qaayeeli GODAA sinttappe kiyidi, Edene baggaappe arshshoora de7iya Nooda giyo biittan de7iis. ");
INSERT INTO wal_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qaayeeli ba keettaayeera aqiis; a abbe ixettada, Heenooka yelaasu. Qaayeeli katamaa he wode keexxidi, he katamaa ba na7aa sunttan “Heenooka” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Heenooki Iraada yeliis; Iraadi Mahuyaa7eela yeliis; Mahuyaa7eeli Matushaa7eela yeliis; Matushaa7eeli Laameeka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laameeki Aadonne Xiilo giyo naa77u maccaasata dautta ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aada Yaabaala yelaasu; Yaabaali mehiyaa haariya, dunkkaaniyan de7iya asatu aawaa. ");
INSERT INTO wal_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","A ishaa sunttai Yuubaala; Yuubaali qassi diittaa diixxiyaanne pulaale punniya asatu ubbaa aawaa; ");
INSERT INTO wal_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Xiila qassi Tubaaliqaina giyo na7aa yelaasu; Tubaaliqaini nahaasiyaappenne birataappe dumma dumma miishshata qoxxiyaagaa. Tubaaliqaina michchiyaa Naa7imo. ");
INSERT INTO wal_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Issi gallassi Laameeki ba keettaayeta, “Aadee, Xiilee, siyite; ta keettaayetoo, ane taani yootiyoogaa ezggite. Issi bitanee tana dechchido gishshau, taani a woraas; ee, taani he tana mazunxxissida wodallaa woraas. ");
INSERT INTO wal_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Qaayeela haluwaa kessanau laappun kushe koshshikko, Laameeka haluwaa kessanau laappun tammanne laappun kushe koshshees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Addaamee ba keettaayeera haranttuwaa aqin, hara na7aa yelaasu. Yelada, “Qaayeeli worido Aabeela gishshaa Xoossai tau hara na7aa immiis” gaada, a Seeta gaada sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seetikka attuma na7aa yeliis; yelidi a “Heenoosa” giidi sunttiis. Asai GODAA sunttaa xeesidi goinniyoogaa he wode doommiis. ");
INSERT INTO wal_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Addaame yeletai hagaappe kaallidi xaafettiis. Xoossai asa medhdhido gallassi bana milatissidi medhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I attumaasanne maccaasa ootti medhdhidi, eta anjjiis. Eta medhdhidi Asa giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Addaamee 130 laittaa de7idi, bana milatiya attuma na7aa yeliis; yelidi a “Seeta” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Addaamee Seeta yelidoogaappe guyyiyan, 800 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Addaamee muleera 930 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seeti 105 laittaa de7idi, Heenoosa yeliis; ");
INSERT INTO wal_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seeti Heenoosa yelidoogaappe guyyiyan, 807 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seeti muleera 912 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Heenoosi 90 laittaa de7idi, Qainaana yeliis; ");
INSERT INTO wal_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Heenoosi Qainaana yelidoogaappe guyyiyan, 815 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Heenoosi muleera 905 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qainaani 70 laittaa de7idi, Malaali7eela yeliis; ");
INSERT INTO wal_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Qainaani Malaali7eela yelidoogaappe guyyiyan, 840 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Qainaani muleera 910 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malaali7eeli 65 laittaa de7idi, Yaareeda yeliis; ");
INSERT INTO wal_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Malaali7eeli Yaareeda yelidoogaappe guyyiyan, 830 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Malaali7eeli muleera 895 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaareedi 162 laittaa de7idi, Heenooka yeliis; ");
INSERT INTO wal_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaareedi Heenooka yelidoogaappe guyyiyan, 800 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaareedi muleera 962 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Heenooki 65 laittaa de7idi, Maatusaala yeliis; ");
INSERT INTO wal_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Maatusaala yelidoogaappe guyyiyan, Heenooki 300 laittaa Xoossaara hemettiiddi de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Heenooki muleera 365 laittaa de7iis; ");
INSERT INTO wal_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","i Xoossaara hemettiiddi xayi bayiis; aissi giikko, Xoossai a ekki efiis. ");
INSERT INTO wal_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Maatusaali 187 laittaa de7idi, Laameeka yeliis; ");
INSERT INTO wal_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Maatusaali Laameeka yelidoogaappe guyyiyan, 782 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Maatusaali muleera 969 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Laameeki 182 laittaa de7idi, attuma na7a yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Yelidi, “Ha na7ai GODAI qanggido biittaa bollan nuna nu kushiyaa oosuwaa daafuraappe shemppissana” giidi Noha sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Laameeki Noha yelidoogaappe guyyiyan, 595 laittaa de7iis; hara attuma naatanne macca naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Laameeki muleera 777 laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nohee 500 laittaa de7idi, Seema, Kaamanne Yaafeeta yeliis. ");
INSERT INTO wal_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Asai sa7aa bollan darido wode, etau macca naati yelettidosona; ");
INSERT INTO wal_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","“Xoossaa naata” geetettiya meretati ha asaa macca naati puulanchcha gidiyoogaa be7idosona; be7idi etappe bantta dooridoogeeta machchidosona. ");
INSERT INTO wal_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","GODAI, “Ta Ayyaanai asan merinau de7enna; aissi giikko, asi haiqqiyaagaa; a laittaikka issi xeetanne laatama gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","He wodenne hegaappe guyyiyan Xoossaa naati asaa macca naata ekkin, naati yelettido wode, wogga adussa asati sa7aa bollan de7idosona. Etinne beni wode olau minonne erettida asa. ");
INSERT INTO wal_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","GODAI he wode sa7aa bollan de7iya asaa iitatettai daridoogaanne eti wozanan qoppiyoobai ubbai ubba wodekka iita xalaala gididoogaa be7iis; ");
INSERT INTO wal_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","be7idi GODAI asaa ha sa7aa bollan medhdhidoogau azzaniis; ba wozanan keehippe seelettiis. ");
INSERT INTO wal_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Hegaa gishshau GODAI, “Taani medhdhido asaa ha sa7aa bollappe muleera quccana; asaa, mehiyaa, do7aa, biittaara gooshettiya meretatanne saluwaa kafota xaissana; aissi giikko, taani eta medhdhidoogau azzanaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","SHin Nohee GODAA sinttan nashettiis. ");
INSERT INTO wal_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nohee hanidobai hagaappe kaallidi xaafettiis. Nohee xillo asa; i ba wodiyan de7ida asaa giddon suure asa; Nohee Xoossaara hemettiis. ");
INSERT INTO wal_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nohee Seema, Kaamanne Yaafeeta giyo heezzu attuma naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","He wode biittai sa7ai Xoossaa sinttan tuniis; sa7ai ubbai makkalan kumiis. ");
INSERT INTO wal_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Xoossai ha sa7aa xeelliis; xeellidi sa7ai tunidoogaa be7iis; aissi giikko, sa7an de7iya asai ubbai ba ogiyaa tunissi wottiis. ");
INSERT INTO wal_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hegaa gishshau, Xoossai Noha hagaadan yaagidi azaziis; “Taani asa ubbaa xaissana hanais; eta gaasuwan sa7ai makkalan kumido gishshau, taani tumuppe asaakka sa7aakka xaissana. ");
INSERT INTO wal_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hegaa gishshau, mino mittaappe neeyyo markkabiyaa keexxa; he markkabiyaa giddon cora qol77ota kessa; yaatada sooranne kareera shidan meesha. ");
INSERT INTO wal_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Markkabiyaa hagaadan yaatada keexxa; zananaa heezzu xeetu wara, gomppaa ishatamu wara, geesaa hasttamu wara ootta; ");
INSERT INTO wal_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","markkabiyaassi kaaraa medhdha; kaaraappenne godaappe gidduwan issi wara gidiyaasaa kallo agga baya; penggiyaa markkabiyaassi miyyessaara kessa; markkabiyaa heezzu pooqe kessada keexxa. ");
INSERT INTO wal_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Taani saloppe garssan de7o shemppoora de7iya mereta ubbaa xaissanau, ha sa7aa bollan bashshaa haattaa yeddana; yeddin ha sa7an de7iyaabai ubbai xayana. ");
INSERT INTO wal_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","SHin taani ta maachchaa nenaara maacettana. Neeni ne keettaayyiyo, ne attuma naatanne ne attuma naatu maccaasata nenaara ekkada markkabiyaa giddo gelana. ");
INSERT INTO wal_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Eti nenaara paxa attana mala, paxa de7iya mereta ubbaappe qommuwan qommuwan attumaagaanne maccaagaa naa77aa naa77aa oottada, markkabiyaa giddo gelissaasa. ");
INSERT INTO wal_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Dumma dumma qommo kafuwaappe, dumma dumma qommo mehiyaappenne biittaara gooshettiya dumma dumma qommo meretatuppe ubbaappe naa77aa naa77aa gididi, paxa attana mala neekko yaana. ");
INSERT INTO wal_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Qassi neeninne nenaara de7iyaageeti maanau, dumma dumma qommo miyo kattaa efaada, markkabiyaa giddon qola” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Yaagin Nohee ubbabaakka Xoossai azazidoogaadan oottiis. ");
INSERT INTO wal_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","GODAI hegaappe guyyiyan Noha hagaadan yaagiis; “Neeni ne so asaa ubbaara markkabiyaa giddo gela; aissi giikko, taani ha wodiyaa yeletaa giddon neeni xillo gididoogaa be7aas. ");
INSERT INTO wal_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Neeni geeshsha gidida mehenne do7a ubbaappe a qommuwaappe qommuwaappe attumaagaanne maccaagaa laappunaa laappunaa, geeshsha gidenna mehenne do7a ubbaappe a qommuwaappe qommuwaappe issi attumaagaanne issi maccaagaa, qassi saluwaa kafuwaappe a qommuwaappe qommuwaappe attumaagaanne maccaagaa laappunaa laappunaa oottada, sa7aa ubbaa bollan dumma dumma zerettai paxa attana mala nenaara ekkada gela. ");
INSERT INTO wal_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Aissi giikko, laappun gallassaappe guyyiyan, taani oitamu gallassaanne oitamu qammaa ha sa7aa bollan iraa bukissana; yaatada taani medhdhido mereta ubbaa sa7aa bollappe quccana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yaagin Nohee GODAI a azazido ubbabaa oottiis. ");
INSERT INTO wal_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Bashshaa haattai ha sa7aa bolli yiido wode, Nohe laittai usuppun xeeta. ");
INSERT INTO wal_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nohee, a attuma naati, a keettaayyiyaanne a naatu maccaasati bashshaa haattaappe attanau markkabiyaa giddo gelidosona. ");
INSERT INTO wal_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Geeshsha mehiyaappenne do7aappe, geeshsha gidenna mehiyaappenne do7aappe, kafuwaappenne biittaara gooshettiyaageetu ubbaappe ");
INSERT INTO wal_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Xoossai Noha azazidoogaadankka attumaageenne maccaagee naa77aa naa77aa gididi, Nohekko markkabiyaa giddo gelidosona. ");
INSERT INTO wal_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Gelin laappun gallassaappe guyyiyan, bashshaa haattai ha sa7aa bollan yiis. ");
INSERT INTO wal_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nohee usuppun xeetu laittaa de7in, naa77antta aginan, tammanne laappuntta gallassan, he gallassankka biittaa giddon de7iya gita ciimmaa pultto ubbai xuuqqi bayiis; saluwan de7iya haattaa maskkootetikka dooyetti wodhdhidosona; ");
INSERT INTO wal_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","dooyettin irai ha sa7aa bollan oitamu gallassaanne oitamu qammaa bukkiis. ");
INSERT INTO wal_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","He gallassankka Noheenne a attuma naati, Seemi, Kaaminne Yaafeeti, Nohe keettaayyiyaanne a naatu heezzaa maccaasati issippe markkabiyaa giddo gelidosona. ");
INSERT INTO wal_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Etinne do7a ubbaappe ba qommuwan qommuwan, mehe ubbaappekka ba qommuwan qommuwan, biittaara gooshettiyaageetu ubbaappe ba qommuwan qommuwan, kafo ubbaappe ba qommuwan qommuwan, etaara issippe gelidosona; ");
INSERT INTO wal_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","de7o shemppoora de7iyaageeti ubbai naa77aa naa77aa gididi, Nohekko markkabiyan gelidosona; ");
INSERT INTO wal_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Xoossai Noha azazidoogaadan, mereta ubbaappe attumanne macca gididi, markkabiyaa giddo gelidosona; gelin Nohee giddon de7ishin, GODAI markkabiyaa penggiyaa gorddiis. ");
INSERT INTO wal_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Bashshaa haattai oitamu gallassaa sa7aa bollan bukkiiddi gam77iis; haattai daridi, markkabiyaa biittaappe pude denttiis. ");
INSERT INTO wal_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Haattai biittaa bollan keehippe darin, markkabee haattaa bollan toohettiis. ");
INSERT INTO wal_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Saloppe garssaara de7iya xoqqa dereti ubbai mitettana gakkanaashin, haattai ha sa7aa bollan keehi wolqqaappe dariis. ");
INSERT INTO wal_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Haattai deretu xeeraappe aadhdhidi, tammanne ichchashu wara gakkanaashin tookkiis. ");
INSERT INTO wal_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yaatin sa7aa bollan paxa qaaxxiya meretati ubbai: kafoi, mehee, do7ai, sa7aa bollan sham77i giya mereta ubbainne asai ubbai haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ee, mela biittaa bollan de7iya, ba siireera de7o shemppuwaa shemppiya ubbaikka haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ha sa7an paxa de7iyaabai ubbai: asai, meheenne do7ai, biittaara gooshettiya meretatinne saluwaa kafoti ubbaikka sa7aappe qucettidosona. Qucettin Nohe xalaalainne aara markkabe giddon de7iyaageeti attidosona. ");
INSERT INTO wal_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","He haattai xeetanne ishatamu gallassa gakkanaassi sa7aa bollan gam77iis. ");
INSERT INTO wal_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","SHin Xoossai Noha, aara markkabiyaa giddon de7iya do7a ubbaanne mehe ubbaa qoppiis; qoppidi sa7aa bollan carkkuwaa carkkissiis; carkkissin he haattai wodhdhi wodhdhi biis. ");
INSERT INTO wal_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Qassi biittaa giddon de7iya ciimmaa pulttoinne saluwan de7iya haattaa maskkooteti gorddettidosona; iraikka saluwan teqettiis. ");
INSERT INTO wal_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Yaanin haattai wodhdhi wodhdhi biis. He xeetanne ishatamantta gallassaappe guyyiyan, haattai wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Haattai wodhdhin markkabee laappuntta aginan, tammanne laappuntta gallassan Araaraate giyo deretu bolli shemppiis. ");
INSERT INTO wal_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Haattai tammantta aginai gakkanaassikka wodhdhi wodhdhi biis; tammantta aginaayyo koiro gallassi deretuyyo xeerai beettiis. ");
INSERT INTO wal_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Oitamu gallassaappe guyyiyan, Nohee ba keexxido markkabiyaa maskkootiyaa dooyiis; ");
INSERT INTO wal_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","dooyidi issi quuruwaa kare yeddiis; yeddin quuroi haattai biittaa bollappe melana gakkanaassi, yaanne haanne paalliiddi gam77iis. ");
INSERT INTO wal_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Qassi Nohee haattai biittaa bollappe wodhdhi wuridaakkonne be7anau issi haraphphiyo kare yeddiis; ");
INSERT INTO wal_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","shin he haraphphiyaa haattai biittaa ubbaa bollan ha77ikka de7iyo gishshau, shemppiyoosaa demmabeikku. Hegaa gishshau simmada, markkabiyaa giddon de7iya Nohekko yaasu; yin i ba kushiyaa yeddidi, baakko markkabiyaa giddo ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Hegaappe guyyiyan, hara laappun gallassaa takkidi, haraphphiyo zaarettidikka markkabiyaa giddoppe kessidi yeddiis. ");
INSERT INTO wal_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","He haraphphiyaa sa7ai omariyo wode akko simmada yaasu; yaidda wogaraa aacaappe duuttido irxxa haittaa ba doonan saxxa ekkada yaasu. Hegaa gishshau, haattai biittaa bollappe wodhdhidoogaa Nohee eriis. ");
INSERT INTO wal_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Qassi Nohee hara laappun gallassaa takkidi, he haraphphiyo zaarettidi yeddiis; shin he haraphphiyaa akko simmada yabeikku. ");
INSERT INTO wal_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nohee usuppun xeetanne isiini laittaa de7in, koiro aginan koiro gallassi, haattai biittaa bollappe xi77iis; Nohee markkabiyaa qum77uwaa qaari xeellidi, biittai xi77idoogaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Naa77antto aginan laatamanne laappuntta gallassan, biittai muleera meliis. ");
INSERT INTO wal_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Xoossai he wode Noha hagaadan yaagidi azaziis; ");
INSERT INTO wal_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Neeni ne keettaayyiyo, ne attuma naatanne ne naatu maccaasata ekkada markkabiyaa giddoppe kiya. ");
INSERT INTO wal_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Eti yelettidi, daridi corattana mala, paxa de7iya mereta ubbaappe nenaara de7iyaageeta: kafota, meheta, do7atanne biittaara gooshettiya ubbaa nenaara kessa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Yaagin Nohee ba attuma naatuura, ba keettaayeeranne ba naatu maccaasatuura markkabiyaa giddoppe kiyiis. ");
INSERT INTO wal_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kiyin mehenne do7a ubbai, biittaara gooshettiya mereta ubbai, kafo ubbainne sa7aa bollan woxxi qaaxxiyaabai ubbai ba qommuwan qommuwan markkabiyaa giddoppe kiyidosona. ");
INSERT INTO wal_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kiyidoogaappe guyyiyan, Nohee GODAAYYO yarshshiyoosaa gimbbiis; gimbbidi geeshsha mehiyaanne do7aa ubbaappenne geeshsha kafo ubbaappe ekkidi, yarshshiyoosan xuuggidi yarshshiis. ");
INSERT INTO wal_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yaatin GODAI yarshshuwaa peenuwaa sawiyaagaa singgidi, ba wozanan hagaadan yaagiis; “Naatettaasappe doommin, asi wozanan qoppiyoobai ubbai iita gidikkokka, taani asa gishshau gaada naa77antto mulekka ha sa7aa qanggikke. Qassi taani ha77i oottidoogaadan paxa de7iya mereta ubbaa naa77antto mulekka xaissikke. ");
INSERT INTO wal_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ha sa7ai de7ido peesha ubban, zeriyo wodeenne cakkiyo wodee, meegoinne hombbee, boneenne balggoi, gallassainne qammai ubbatookka de7ana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Xoossai Nohanne a attuma naata hagaadan yaagidi anjjiis; “Yelettite; corattite; sa7a ubbaa kumite. ");
INSERT INTO wal_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Sa7aa do7ati ubbai, saluwaa kafoti ubbai, biittan woxxi qaaxxiyaabai ubbainne abban de7iya moleti ubbai intteyyo yayyonanne dagammona. Eti intteyyo aadhdhidi imettidosona; ");
INSERT INTO wal_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","taani mokkiya dumma dumma kattata intteyyo immidoogaadankka, paxa de7iya woxxi qaaxxiya mereta ubbai intteyyo quma gidana. ");
INSERT INTO wal_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","SHin biron shemppoora de7iya suuttai a giddon de7iyo ashuwaa mooppite. ");
INSERT INTO wal_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Taani intte shemppuwaara de7iya intte suuttaa do7a ubbaappe tumu achchana; qassi asa ubbaappekka, a mala asaa suuttaa achchana. ");
INSERT INTO wal_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Xoossai asaa bana Xoossaa milatissidi medhdhido gishshau, asa suutta gussiya oona gidikkonne, a suuttaikka asa kushen gukkana. ");
INSERT INTO wal_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Intte yelettite; corattite; sa7an darite; an corattite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hegaappe guyyiyan, Xoossai Nohanne aara de7iya a attuma naata hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","“Simmi ha77i, taani ta maachchaa inttenaara, intteppe guyyiyan intte zerettaaranne paxa nenaara de7iya mereta ubbaara maacettais; ee, taani ta maachchaa kafuwaara, mehiyaara, sa7aa do7a ubbaaranne, markkabiyaappe inttenaara kiyida, paxa de7iya mereta ubbaara maacettais. ");
INSERT INTO wal_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Taani inttenaara ta maachchaa maacettais; hagaappe sinttan paxa de7iyaabai ubbai bashshaa haattan mulekka xayenna; ha sa7aa bashshiya haatti hagaappe sinttan mulekka de7enna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Qassikka Xoossai, “Taani taappenne intteppe, inttenaara de7iya paxa meretatu ubbaappe gidduwan yaana yeleta ubbaara maacettiyo maachchaa malaatai hagaa; ");
INSERT INTO wal_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","taani ta zuullaa shaaran essaas; i taappenne ha sa7aappe gidduwan de7iya maachchau malaata gidana. ");
INSERT INTO wal_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Taani sa7aappe bollan shaaraa ehiido wodenne shaaran zuullai beettido wode, ");
INSERT INTO wal_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","taappenne intteppe paxa de7iya dumma dumma qommo mereta ubbaappe gidduwan maacettido ta maachchaa hassayana; paxa de7iyaabaa ubbaa xaissanau hagaappe sinttan mulekka bashshaa haatti yeenna. ");
INSERT INTO wal_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Zuullai shaaran beettido wode audenne, taani a be7ana; be7ada taappe Xoossaappenne ha sa7aa bollan paxa de7iya dumma dumma qommo mereta ubbaappe gidduwan maacettido merinaa maachchaa taani hassayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Yaagidi Xoossai Noha, “Taani taappenne ha sa7aa bollan paxa de7iyaabaa ubbaappe gidduwan maacettido maachchaa malaatai hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Markkabiyaappe kiyida Nohe attuma naati Seema, Kaamanne Yaafeeta; Kaami Kanaane aawaa. ");
INSERT INTO wal_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Hageeti heezzaikka Nohe naata; sa7an ubban de7iya asai etappe yelettiis. ");
INSERT INTO wal_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nohee goshshanchcha; i woiniyaa turaa tokettaa doommiis. ");
INSERT INTO wal_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Issi gallassi i he woiniyaa eessaa uyidi mattottiis; mattottidi ba dunkkaaniyaa giddon kallo xiire zin77iis. ");
INSERT INTO wal_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaane aawaa Kaami ba aawaa kalluwaa be7iis; be7idi, kare kiyidi, ba naa77u ishanttuyyo yootiis. ");
INSERT INTO wal_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","SHin Seeminne Yaafeeti afala issuwaa ekkidi, naa77aikka bantta hashiyaara hashiyaara gatti oiqqidi, guyyegutti hemetti gelidi, bantta aawaa kalluwaa kammidosona; eti bantta aawaa kalluwaa be7enna mala bantta som77uwaa wora zaaridosona. ");
INSERT INTO wal_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nohee mattoi aadhdhin beegottidi, a na7ai ubbaappe kaaloi a oottidobaa eriis. ");
INSERT INTO wal_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Eridi a, “Kanaani qanggettidaagaa gido! I ba ishanttuyyo wurssetta aille gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Qassikka Nohee, “GODAI, Seema Xoossai galatetto! Kanaani Seema aille gido; ");
INSERT INTO wal_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Xoossai Yaafeeta biittaa aasso. Yaafeeta zareti Seema zaretu giddon de7ona; Kanaani Yaafeeta aille gido” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bashshaa haattaappe guyyiyan, Nohee heezzu xeetanne ishatamu laittaa de7iis. ");
INSERT INTO wal_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nohee muleera uddufun xeetanne ishatamu laittaa de7idi haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nohe naatu, Seema, Kaamanne Yaafeeta yeletai hagaappe kaallidi xaafettidaagaa; bashshaa haattaappe guyyiyan, etau attuma naati yelettidosona. ");
INSERT INTO wal_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yaafeeta attuma naati: Goomera, Maagooga, Maadaaya, Yaawaana, Tubaala, Meshekanne Tiiraasa. ");
INSERT INTO wal_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goomera attuma naati: Ashkkanaaza, Riifaatanne Togarmma. ");
INSERT INTO wal_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yaawaana attuma naati: Eliisha, Tarsseesa, Kitiimanne Rooda. ");
INSERT INTO wal_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Hageetuppe abbaa doonan de7iya asai ubbai ba biittan biittan, ba qaalan qaalan, ba yaran yaraaninne, ba kawotettan kawotettan shaahettidosona. ");
INSERT INTO wal_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kaama attuma naati: Kuusha, Mixiraima, Puuxanne Kanaana. ");
INSERT INTO wal_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuusha attuma naati: Saaba, Hawiila, Saabita, Raa7imanne Sabttaka. Raa7ima attuma naati: Saabanne Dadaana. ");
INSERT INTO wal_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushi Naamiruuda yeliis; Naamiruudi ha sa7an koiro wolqqaama olanchcha gidiis; ");
INSERT INTO wal_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","GODAA sinttankka i wolqqaama shankkanchcha gidiis; “Naamiruudadan GODAA sinttan wolqqaama shankkanchcha gida” giyoogee hegaa gishshassa. ");
INSERT INTO wal_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","A kawotettaayyo koiro katamati Sanaa7oore biittan de7iya Baabiloone, Ereeka, Akkaadanne Kalnna. ");
INSERT INTO wal_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","I he biittaappe Asoore biidi, Nanawe, Rahobootanne Kaalaha keexxiis; qassi Nanaweppenne Kaalahappe gidduwan de7iya Reseena giyo gita katamaakka keexxiis. ");
INSERT INTO wal_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Mixiraimi Ludeta, Anaameta, Lahaabeta, Nafttuuheta, Patiroosata, Kaasiluuhetanne Pilisxxeema zareta yelida Kafttooreta yeliis. ");
INSERT INTO wal_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","18","Kanaanee ba baira na7aa Sidoonanne Heeta yeliis; qassi Kanaanee Yaabuusata, Amooreta, Gerggeeseta, Hiiweta, Arqqeta, Siinata, Ariwaadeta, Xamaaretanne Hamaatata yeliis. Hegaappe guyyiyan, Kanaane zareti laalettin, ");
INSERT INTO wal_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaane biittaa zawai Sidoonappe doommidi, Garaaraaranne Gaazaara kanttidi, Sadoomanne Gamoora, Adaamanne Xaboima biidi, Lashaa7an zawatees. ");
INSERT INTO wal_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kaama attuma naati bantta yaran yaran, bantta qaalan qaalan, bantta biittan biittaaninne bantta kawotettan kawotettan xaafettidaageeti hageeta. ");
INSERT INTO wal_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemau naati yelettidosona; i Yaafeetayyo baira ishaanne Eboora naatu ubbaayyo maizza aawaa. ");
INSERT INTO wal_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seema attuma naati: Elaama, Asoora, Arifaakisaada, Luudanne Araama. ");
INSERT INTO wal_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Araama attuma naati: Uuxa, Huula, Geteeranne Mesheka. ");
INSERT INTO wal_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arifaakisaadi SHelaaha yeliis. SHelaahi Eboora yeliis. ");
INSERT INTO wal_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eboorau naa77u attuma naati yelettidosona. Issuwaa sunttai Peeleega; aissi giikko, sa7an de7iya asai a wodiyan shaahettiis; a ishaa sunttai Yoqixaana. ");
INSERT INTO wal_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqixaani naata yeliis. Etinne: Almmodaada, SHeleefa, Haxarmmaaweta, Yeraaha, ");
INSERT INTO wal_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoraama, Uzaala, Diiqila, ");
INSERT INTO wal_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oobaala, Abimaa7eela, Saaba, ");
INSERT INTO wal_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiira, Hawiilanne Yobaaba. Hageeti ubbaikka Yoqixaana attuma naata. ");
INSERT INTO wal_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Eti de7ido heerai Meeshappe biidi arshsho baggaara de7iya deree dariyo biittan Safaara gakkees. ");
INSERT INTO wal_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Seema attuma naati bantta yaran yaran, bantta qaalan qaalan, bantta biittan biittaaninne bantta kawotettan kawotettan xaafettidaageeti hageeta. ");
INSERT INTO wal_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hageeti bantta yaran yaraaninne bantta kawotettan kawotettan xaafettida Nohe attuma naatu zareta. Bashshaa haattaappe simmin, kawotettati hageetuppe sa7a ubbau laalettidosona. ");
INSERT INTO wal_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sa7aa bollan de7iya asi ubbi koiro issi doonaanne issi qaalaa haasayees. ");
INSERT INTO wal_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Asati arshsho baggi simmidi biido wode, Sanaa7oore giyo biittan dembba issuwaa demmidi yan, uttidosona. ");
INSERT INTO wal_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Eti issoi issuwaa, “Haayite; xuubiyaa medhdhidi, taman xuuggoos” yaagidosona. Yaagidi eti shuchchaa gishshaa xuubiyaa, urqqaa gishshaa shidaa ekkidosona; ");
INSERT INTO wal_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ekkidi, “Haayite; nu sunttaa xeesissanaunne qassi nuuni ha sa7aa ubbaa bollan laalettennan attanau issi gita katamaanne xeerai saluwaa gakkiyo issi pooqiyaa nuuyyo keexxoos” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","SHin GODAI asati keexxido gita katamaanne pooqiyaa be7anau duge wodhdhiis; ");
INSERT INTO wal_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","wodhdhidi GODAI hagaadan yaagiis; “Hekko eti issi asa; qassi eti ubbaikka issi qaalan haasayoosona; eti ha77i hagaa oottanau doommiichchaappe guyyiyan, eti banttayyo oottanau qoppiyooban etau danddayettennabi aibinne baawa. ");
INSERT INTO wal_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Haayite; duge wodhdhidi eti issoi haasayiyo qaalaa issoi erenna mala, eta qaalaa dummayoos” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yaagidi GODAI eta hegaappe sa7a ubbaa bollan laalin, eti he gita katamaa keexxiyoogaa aggi bayidosona. ");
INSERT INTO wal_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","GODAI sa7aa asaa qaalaa yan dummayido gishshau, he katamai Baabiloona geetettiis. GODAI eta hegaappe sa7a ubbaa bollan laaliis. ");
INSERT INTO wal_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seema yeletai hagaappe kaallidi xaafettidaagaa. Bashshaa haattaappe guyyiyan, naa77u laitta gidin, Seema laittai xeetaa gidido wode, Seemi Arifaakisaada yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Seemi Arifaakisaada yelidoogaappe guyyiyan, ichchashu xeetu laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arifaakisaadi 35 laittaa de7idi, SHelaaha yeliis; ");
INSERT INTO wal_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arifaakisaadi SHelaaha yelidoogaappe guyyiyan, 403 laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","SHelaahi 30 laittaa de7idi, Eboora yeliis; ");
INSERT INTO wal_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","SHelaahi Eboora yelidoogaappe guyyiyan, 403 laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eboori 34 laittaa de7idi, Peeleega yeliis; ");
INSERT INTO wal_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eboori Peeleega yelidoogaappe guyyiyan, 430 laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peeleegi 30 laittaa de7idi, Raa7a yeliis; ");
INSERT INTO wal_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peeleegi Raa7a yelidoogaappe guyyiyan, 209 laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Raa7u 32 laitta de7idi, Saruuga yeliis; ");
INSERT INTO wal_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Raa7u Saruuga yelidoogaappe guyyiyan, 207 laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Saruugi 30 laittaa de7idi, Naakoora yeliis; ");
INSERT INTO wal_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Saruugi Naakoora yelidoogaappe guyyiyan, 200 laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naakoori 29 laittaa de7idi, Taara yeliis; ");
INSERT INTO wal_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naakoori Taara yelidoogaappe guyyiyan, 119 laittaa de7iis; hara attuma naatakka macca naatakka yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taari 70 laittaa de7idi, Abraama, Naakooranne Haaraana yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Taara yeletai hagaappe kaallidi xaafettidaagaa. Taari Abraama, Naakooranne Haaraana yeliis; yelin Haaraani Looxa yeliis. ");
INSERT INTO wal_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haaraani ba aawai Taari paxa de7ishin, ba yelettido Kaladaawetu biittan, Uura giyo gita kataman haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abraaminne Naakoorinne naa77aikka machchidosona; Abraama keettaayee sunttai Saarayo; qassi Naakoora keettaayee sunttai Milkko; Milkka Haaraana na7iyo; Haaraani Milkkissinne Yiskkaanisi aawaa. ");
INSERT INTO wal_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saaraya maine; iyyo na7i baawa. ");
INSERT INTO wal_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taari ba na7aa Abraama, ba na7aa Haaraana na7aa Looxanne, ba na7aa Abraama keettaayyiyo Saarayo ekkidi kiyin, eti issippe Kanaane biitti baanau Uuri giyo Kaladaawetu katamaappe denddidosona; shin eti Kaaraane giyo katamaa gakkanaashin biidi, yan utti bayidosona. ");
INSERT INTO wal_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taari naa77u xeetanne ichchashu laittaa de7idi, Kaaraanen haiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","GODAI Abraama yaagiis; “Neeni ne biittaappe, ne dabbotuppenne ne aawaa keettaa asaappe shaahettada, taani nena bessiyo biitti ba. ");
INSERT INTO wal_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Taani nena gita kawotetta oottana; qassi taani nena anjjana; taani ne sunttaa gitayana; yaatin neeni anjjo gidana; ");
INSERT INTO wal_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","taani nena anjjiyaageeta anjjana; qassi nena qanggiyaageeta taani qanggana; ha sa7aa bollan de7iya asai ubbai ne baggaara anjjettana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yaagin Abraami GODAI ayyo odidoogaadan denddidi biis; Looxeekka aara biis; Abraami Kaaraaneppe biido wode, ayyo laittai laappun tammanne ichchasha. ");
INSERT INTO wal_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraami ba keettaayyiyo Saarayo, ba ishaa na7aa Looxa, yan shiishshido bantta aquwaa ubbaanne, Kaaraanen eti demmido ashkkarata ekkidi, Kanaane biitti baanau denddiis; biidi eti Kanaane biitti gakkidosona. ");
INSERT INTO wal_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Gakkin Abraami he biittan Sekeemi giyoosan de7iya Moore giyo gita wolaa gakkanaassi hemettidi biis. He wode Kanaane asati he biittan de7oosona. ");
INSERT INTO wal_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","SHin GODAI Abraamayyo qonccidi a, “Ha biittaa taani ne zerettaayyo immana” yaagiis. Yaagin i baayyo qonccida GODAAYYO he sohuwan yarshshiyoosaa keexxidi goinniis. ");
INSERT INTO wal_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hegaappe denddidi, Beeteeleppe arshsho baggaara de7iya deretiyaasaa biidi, hegan Beeteele arggo baggi aggidi, qassi Aaye arshsho baggi aggidi, gidduwan ba dunkkaaniyaa toliis; hegan GODAAYYO yarshshiyoosaa keexxidi, GODAA sunttaa xeesiis. ");
INSERT INTO wal_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hegaappe guyyiyan, Abraami yaappe denddidi biidi Neegeeba bazzuwaa gakkiis. ");
INSERT INTO wal_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","He wode he biittai koshatiis; koshai suullido gishshau, Abraami amarida wodiyaa de7anau duge Gibxxe wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Gibxxe gelana hanishin, Abraami ba keettaayyiyo Saarayo hagaadan yaagiis; “Siya; neeni keehippe meraa lo77o maccaasa gidiyoogaa taani erais. ");
INSERT INTO wal_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Gibxxe asati nena be7iyo wode eti, ‘Hanna a keettaayyiyo’ yaagana; yaagidi eti tana worana; shin nena paxa aggi bayana. ");
INSERT INTO wal_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Simmi eti taayyo ne gaasuwan kehana malanne, qassi taani haiqqennan ne gaasuwan attana mala neeni, ‘Taani a michchiyo’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abraami Gibxxe biittaa gelido wode, Gibxxe asati he maccaasiyaa daro meraa lo77o maccaasa gidiyoogaa be7idosona. ");
INSERT INTO wal_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Qassi Gibxxe kawuwaassi oottiya halaqatikka o be7ido wode, kawuwaa sinttan o nashshidosona; yaatidi o kawuwaa keettaa efiidosona. ");
INSERT INTO wal_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Yaatin i gaasuwan kawoi Abraama lo77o aifiyan xeelliis; xeellidi Abraamayyo dorssatanne boorata, attuma haretanne macca hareta, attuma ashkkaratanne macca ashkkarata, gaameelatakka immiis. ");
INSERT INTO wal_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","SHin GODAI Abraama keettaayee Saarayi gaasuwan Gibxxe kawuwaa bollinne a so asaa bolli hanttaara harggiyaa yeddiis. ");
INSERT INTO wal_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yaatin kawoi Abraama xeesidi, “Neeni hagaa aissi ta bolli oottadii? A ne keettaayyiyo gididoogaa aissi taayyo odabeikkii? ");
INSERT INTO wal_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Neeni o, ‘A ta michchiyo’ gaada taayyo aissi yootadii? Taani o ta machcho oottanau ekkidoi hegaa gishshassa. Simmi ha77i ne keettaayyiyo hanno be7a; o ekkada ba” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Yaagidi ba asata azazin, eti Abraama a keettaayeeranne ayyo de7iya ubbabaara kessidi yeddidosona. ");
INSERT INTO wal_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hegaa gishshau Abraami ba keettaayeeranne, baayyo de7iyaabaa ubbaara Gibxxeppe Neegeeba bazzuwaa biis; Looxeekka aara biis. ");
INSERT INTO wal_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abraami he wode mehiyan, biraaninne worqqan daro duretiis. ");
INSERT INTO wal_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","I Neegeebappe denddidi Beeteele gakkanaassi biis; he sohoinne Beeteeleppenne Aayippe gidduwan i koiro ba dunkkaaniyaa tolido sohuwaanne ");
INSERT INTO wal_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","yarshshiyoosaa i koiro keexxido sohuwaa. Yan Abraami GODAA sunttaa xeesiis. ");
INSERT INTO wal_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abraamaara yuuyiya Looxeyyookka miizzai, dorssaa wudeenne dunkkaanee de7ees. ");
INSERT INTO wal_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","SHin eti issippe de7anau etau biittai gidibeenna; etau daro mehee de7iyo gishshau, eti issippe de7anau danddayibookkona. ");
INSERT INTO wal_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hegaa gaasuwan Abraama wudiyaa heemmiyaageetu giddooninne Looxe wudiyaa heemmiyaageetu giddon ooshshai kiyiis. He wode Kanaanetinne Parzzeti he biittan de7oosona. ");
INSERT INTO wal_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yaanin Abraami Looxa, “Nuuni ishantta gidiyo gishshau, ta giddooninne ne giddon, ta wudiyaa heemmiyaageetu giddooninne ne wudiyaa heemmiyaageetu giddon ooshsha kessoppa. ");
INSERT INTO wal_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Biitta ubbai ne sinttan de7ennee? Ane nuuni shaahettoos; neeni haddirssa baggi biikko, taani ushachcha baggi baana; neeni ushachcha baggi biikko, taani haddirssa baggi baana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Yaagin Looxee yuuyi aadhdhi xeellidi, Yorddaanoosa SHaafaa wombbai ubbai biidi Zoo7aara gakkanaassi, GODAA gannatiyaa woikko Gibxxe biittaa mala daro haattai de7iyoogaa gidiyoogaa be7iis. (Hegeenne GODAI Sadoomanne Gamoora geetettiya katamata xaissanaappe kase). ");
INSERT INTO wal_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hegaa gishshau Looxee baayyo Yorddaanoosa wombbaa ubbaa dooridi, arshsho baggi biis; yaatin eti issoi issuwaappe shaahettidosona. ");
INSERT INTO wal_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraami Kanaane biittan de7i bayiis; shin Looxee wombban de7iya gita katamatu gidduwan uttidi, Sadooma katamaa matan ba dunkkaaniyaa toliis. ");
INSERT INTO wal_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","He wode Sadooma asati iitanne GODAA bolli pala nagaraa oottiyaageeta. ");
INSERT INTO wal_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Looxee Abraamappe shaahettidoogaappe guyyiyan, GODAI Abraama hagaadan yaagiis; “Xoqqu gaada neeni de7iyoosaappe arshsho bagginne arggo baggi, qassi huuphessa bagginne tohossa baggi xeella. ");
INSERT INTO wal_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ha neeni xeelliyo biitta ubbaa taani neeyyoonne ne zariyaayyo merinau immana; ");
INSERT INTO wal_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","taani ne zariyaa sa7aa shafiyaadan darissana; ooninne sa7aa shafiyaa qoodana danddayikko, ne zareekka qoodettana. ");
INSERT INTO wal_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Dendda; denddada biittaa gomppan pudenne dugenne hininne haanne hemettada be7a; aissi giikko, taani ha biittaa neeyyo immana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yaagin Abraami ba dunkkaaniyaa shoddidi, Kebroona kataman de7iya Mamire wolatu gitatu matan de7anau biis. Hegan GODAAYYO yarshshiyo sohuwaa keexxiis. ");
INSERT INTO wal_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","He wode Sanaa7oore Kawoi Amiraafeeli, Ellaasaara Kawoi Ariyooki, Elaama Kawoi Kadorllaa7oomerinne Goima Kawoi Tidi7aali oiddai, ");
INSERT INTO wal_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sadooma Kawuwaa Beera7aara, Gamoora Kawuwaa Birshshaara, Adaama Kawuwaa SHin77aabaara, Xaboima Kawuwaa SHemebeeraaranne (Xoo7aaro geetettiya) Belaa7a Kawuwaara olau salppidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Hageeti ichchashu kawoti gaittidi issi wolqqa gididi, (Maxine Abbaa giyo) Siiddima Wombban shiiqidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Eti kase tammanne naa77u laittaa Kadorllaa7oomerayyo haarettidosona; shin tammanne heezzantta laittan ayyo makkalidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tammanne oiddantta laittan Kadorllaa7oomerinne aara zuppetida kawoti bantta olanchchata ekkidi biidi, Asttaarooti Qarnnaiman de7iya Raafaayeta, Haaman de7iya Zuuzetanne SHaawe-Qiriyaataiman de7iya Eemeta olidi xoonidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Xoonidi Hoora biittaa asatakka Se7iira Deriyan olidi, bazzuwaa matan de7iya Elpparaana giyoosaa gakkanaassi yedettidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hegaappe guyye simmidi, Ain-Mishppaaxa yiidosona. (Ha77i he sohoi Qaadeesa geetettees.) Eti Amaaleeqatu biittaa ubbaanne qassi Haxaaxooni-Taamaara giyoosan de7iya Amooreta olidi xoonidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hegaappe simmin, Sadooma kawoi, Gamoora kawoi, Addaama kawoi, Xaboima kawoinne (Xoo7aaro geetettiya) Belaa7a kawoi denddidosona; denddidi Siiddima Wombban salppidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Hageeti ubbai Elaama kawuwaara, Goima kawuwaara, Sanaa7oore kawuwaaranne Ellaasaara kawuwaara (ha ichchashu kawoti oiddu kawotuura) olettidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siiddima Wombban he wode, shidaadan oiqqiyaabai kumido ollai bessiis; Sadooma kawoinne Gamoora kawoi bantta olanchchatuura olaappe baqatishin, etappe amaridaageeti he ollatun kunddidosona; shin attidaageeti deriyau baqatidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Oiddu kawoti Sadoomanne Gamoora katamatu aquwaa ubbaanne eta quma ubbaa bonqqidi ekki biidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abraama ishaa na7ai Looxee Sadooman de7iyo gishshau, akka a aquwaakka ekki biidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hegaappe guyyiyan, issi bitanee baqati kessi ekkidi yiis; yiidi Ibraawiyaa Abraamassi hagaa yootiis. Abraami he wode, Eshkkolanne Aneera ishaa Amooriyaa Mamire wolaa matan de7ees. Eti ubbaikka olaa zaaranau Abraamaara maachchaa maacetti uttidosona. ");
INSERT INTO wal_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abraami ba dabboi omoodettidoogaa siyido wode, olaa eriya ba son yelettida heezzu xeetanne tammanne hosppun asaa denttiis; he oiddu kawota kaalliiddi Daani giyo katamaa gakkanaassi biis. ");
INSERT INTO wal_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Biidi gakkidi, qamman ba asaa citan citan shaakkidi, ba morkketuura olettidi eta xooniis. Xoonidi Damasqqoppe huuphessa baggaara de7iya Hooba giyoosaa gakkanaassi yedettiis. ");
INSERT INTO wal_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Aquwaa ubbaa, qassi ba dabbuwaa Looxanne a aquwaa, maccaasaanne hara asaa wotti ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abraami Kadorllaa7oomeranne aara zuppetida kawota xoonidi simmidoogaappe guyyiyan, Sadooma kawoi, (Kawotu Wombbaa giyo) SHaaweeha Wombban a mokkanau kiyiis. ");
INSERT INTO wal_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","He wode, Saleema Kawoi Malkki-Xedeqi oittaanne woine eessaa ekkidi yiis; i Ubbaappe Xoqqiya Xoossaa qeesiyaa. ");
INSERT INTO wal_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I Abraama hagaadan yaagidi anjjiis; “Ubbaappe Xoqqiya Xoossai, saluwaanne sa7aa medhdhidaagee Abraama anjjo; ");
INSERT INTO wal_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","qassi Ubbaappe Xoqqiya Xoossai, ne morkketa ne kushiyan aatti immidaagee galatetto” yaagiis. Yaagin Abraami ubbabaappe asirataa kessidi, Malkki-Xedeqayyo immiis. ");
INSERT INTO wal_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sadooma kawoi Abraama, “Asaa tau immada, aquwaa neeyyo ekka” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","SHin Abraami Sadooma kawuwaa, “Taani GODAASSI, Ubbaappe Xoqqiya Xoossaassi, saluwaanne sa7aa medhdhidaagaassi, ta kushiyaa denttada caaqqaichchaas. ");
INSERT INTO wal_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","24","Ta asai miidobaappenne tanaara biida Aneera, Eshkkolanne Mamire gakkiyaabaappe attin, neeni, ‘Abraama taani dureyaas’ mulekka geennaadan, taani nebaappe harai atto qunccuute woikko caamma qachchiyoobaanne ekkikke. Eti banttana gakkiyaabaa ekkona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hegaappe guyyiyan, GODAA qaalai ajjuutan Abraamakko yiidi, “Abraamaa, yayyoppa! Taani neeyyo gonddalle; ne woitoi keehi gita” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yaagin Abraami, “Abeet Ubbaa Haariya GODAU, taayyo mulekka na7i bainna gishshau, neeni immiyo woitoi taayyo aissee? Damasqqoi El77eezari tana laattana shin” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Qassikka Abraami, “Neeni taayyo ainne na7a immabaakka; hegaa gishshau ta son de7iya ashkkarai tana laattiyaagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yaagin GODAA qaalai akko yiidi, “Ha ashkkarai nena laattenna; shin ne gulbbataappe kiyiyaagee nena laattana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yaagi simmidi kare a kessidi, “Saluwaa pude xeella; neeni xoolintteta qoodanau danddayikko qooda; ne zerettaikka hagaa keena gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraami GODAA ammaniis; GODAI hegaa ayyo xillotettadan qoodiis. ");
INSERT INTO wal_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","GODAI qassikka a, “Taani neeni ha biittaa laattana mala neeyyo immanau Uri giyo Kaladaawetu katamaappe nena kessa ehiida GODAATTENNEE” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","SHin Abraami a, “Abeet Ubbaa Haariya GODAU, taani ha biittaa laattanaagaa aibin eroo?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yaagin GODAI a, “Heezzu laitta ussa, heezzu laitta deeshsha, heezzu laitta dorssanne naa77u qommo haraphpheta taassi ekkada ya” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Yaagin i hageeta ubbaa ayyo ekki efiis; efiidi eta phalqqidi naa77u kessiis; naa77aa kessidoogaa issuwaa issuwaa ginan wottiis; shin kafota naa77u kessi phalqqibeenna. ");
INSERT INTO wal_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","He wode ankkoti he ashuwaa bolli wodhdhidosona; shin Abraami eta yedettiis. ");
INSERT INTO wal_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Awai wulliyo wode Abraama wolqqaama xiskkoi oiqqiis; oiqqin daganttiya sakkana xumai a bolli wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yaatin GODAI a, “Ne zerettai hara biittan bete gididi de7anaagaa neeni tumuppe era; eti ailletidi oiddu xeetu laittaa naaqettana. ");
INSERT INTO wal_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","SHin ailleyidi eta haariya kawotettaa taani qaxxayana; hegaappe guyyiyan, eti daro aquwaara he biittaappe kiyana. ");
INSERT INTO wal_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nena gidikko, neeni ne maizza aawatukko sarotettan baana; neeni keehi cimada haiqqananne moogettana. ");
INSERT INTO wal_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","SHin oiddantto yeletan ne zerettai ha biitti simmana; aissi giikko, Amooretu nagarai biron likkiyaa gakkiichchibeenna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Awai wullin sa7ai xumiis; xumin coociyaa cuwainne tamaa lacoi akeekennan kiyi beettidi, he naa77u kessi phalqqidoogeetuppe gidduwaara kanttiis. ");
INSERT INTO wal_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","He gallassi GODAI Abraamaara hagaadan yaagidi maachchaa maacettiis; “Gibxxe SHaafaappe doommidi Efiraaxiisa giyo gita shaafaa gakkanaassi, ha biittaa taani ne zerettaassi immaas; ");
INSERT INTO wal_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","ha biittai Qeenatu, Qeniizetu, Qadimoonetu, Hiitetu, Parzzetu, Raafaayetu, Amooretu, Kanaanetu, Gerggeesetunne Yaabuusatu biittaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abraama keettaayyiyaa Saaraya ayyo ha77inne na7a yelabeikku; shin iyyo Gibxxeppe yiida Aggaaro giyo issi ailliyaa de7ausu. ");
INSERT INTO wal_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Hegaa gishshau Saaraya Abraama xeesada, “Be7a, GODAI tau yelo diggiis. Neeni baada, ta ailleera zin77a; ooni erii, taani i baggaara na7aayo gidanaakkonne” yaagaasu. Yaagin Abraami Saarayi qaalaa siyidi maayiis. ");
INSERT INTO wal_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abraami Kanaane biittan tammu laitta uttidoogaappe guyyiyan, Abraama keettaayyiyaa Saaraya Gibxxeppe ehiido ba ailliyo Aggaaro, ba keettaawaa Abraamassi machcho immaasu. ");
INSERT INTO wal_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Immin Aggaaro ekkiis; ekkin a shahaaraasu. A baayyo shahaarai attidoogaa erido wode, ba godiyo karuwaa doomma bayaasu. ");
INSERT INTO wal_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","He wode Saaraya Abraama, “Tana ha naaquwaa naaqissiyaagee nena; taani ta ailliyo neeyyo immin, a ha77i baayyo shahaarai attidoogaa erada, tana karausu. Nebaanne tabaa GODAI pirddo” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Yaagin Abraami Saarayo, “Hanno be7a; ne ailliyaa ne kushiyaana; neeni o ne lo77aa ootta” yaagiis. Hegaappe guyyiyan, Saaraya Aggaaro naaqqin, a kiyada ippe baqataasu. ");
INSERT INTO wal_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Baqatin GODAA kiitanchchai pulttuwaa matan bazzon Aggaaro demmiis; he pulttoi SHura giyo biitti efiya ogiyaa mataana. ");
INSERT INTO wal_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","I Aggaaro, “Bii Saarayi aillee Aggaaree, auppe yaadii? Qassi au bai?” yaagidi oichchiis. Oichchin a, “Taani ta godee Saarayippe baqatais” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yaagin GODAA kiitanchchai iyyo, “Neeni ne godeekko guyye simmada ba; baada iyyo haaretta” yaagidi yootiis. ");
INSERT INTO wal_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Qassikka GODAA kiitanchchai o, “Ne zariyaa qoodanau danddayettennaagaa keesaa taani corayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Qassikka GODAA kiitanchchai o, “Ha77i neeni shahaara; neeni attuma na7a yelana; yelada a Isimaa7eela gaada sunttana; aissi giikko, GODAI ne waasuwaa siyiis. ");
INSERT INTO wal_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","I bazzon yeda de7iya hare mala asa gidana; asa ubbaara i eqettana; qassi asai ubbaikka aara eqettana; i ba ishanttu ubbaara ixo gididi de7ana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yaagin Aggaara, “Taani tana be7iyaagaa be7ada paxa attanee?” yaagaasu; yaagada a baayyo haasayida GODAA, “Neeni tana be7iya Xoossaa” yaagada sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hegaa gishshau he pulttuwaa ollai, “Tana Be7iya De7o Xoossaa Pulttuwaa” geetettiis; he ollai hanno gakkanaassi Qaadeesappenne Baareedappe gidduwan de7ees. ");
INSERT INTO wal_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aggaara Abraamayyo attuma na7a yelaasu; Abraami Aggaara yelido na7aa Isimaa7eela giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aggaara Isimaa7eela Abraamayyo yelido wode, Abraama laittai hosppun tammanne usuppuna. ");
INSERT INTO wal_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abraama laittai uddufun tammanne uddufunaa gidiyo wode, GODAI ayyo qonccidi a, “Taani Ubbaa Danddayiya Xoossaa; neeni ta sinttan hemetta; suure gida. ");
INSERT INTO wal_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Taani taappenne neeppe gidduwan ta maachchaa wottais; taani nena keehi corayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yaagin Abraami ba som77uwan duge gufanniis; gufannin Xoossai ayyo hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Simmi, taani nenaara maacettiyo maachchai hagaa; neeni daro kawotettaayyo aawa gidana. ");
INSERT INTO wal_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Hagaappe doommidi ne sunttai Abraama geetettenna; shin ne sunttai Abrahaama gidana. Aissi giikko, taani nena daro kawotettaayyo aawa oottaas. ");
INSERT INTO wal_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Taani nena keehi yeletissana; taani neeppe kawotettata medhdhana; kawotikka neeppe kiyana. ");
INSERT INTO wal_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Taani taappenne neeppe, neeppe guyyiyan ne zerettaappenne gidduwan, yeletaappe yeletaa gakkanaassi ta maachchaa maacettais; ha maachchai taani neeyyoonne neeppe guyyiyan ne zerettaayyo Xoossaa gidana mala merinaa maachcha. ");
INSERT INTO wal_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ha77i neeni bete gidada de7iyo Kanaane biittai ubbai neeyyoonne neeppe guyyiyan ne zerettaayyo merinaassi laata gidana mala taani immana; qassi taani eta Xoossaa gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Qassikka Xoossai Abrahaama, “Nena gidikko, neeni ta maachchaa naaga; neenikka neeppe guyyiyan ne zerettaikka, yeletaappe yeletaa gakkanaassi naagite. ");
INSERT INTO wal_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Taappenne neeppenne, neeppe guyyiyan ne zerettaappe gidduwan intte naagana ta maachchai hagaa; intte gidduwan de7iya attuma ubbai qaxxaretto. ");
INSERT INTO wal_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Intte attumatettaa shoohuwaa qaxxaretteeta; hegee taappenne intteppe gidduwan de7iya maachchaayyo malaata gidana. ");
INSERT INTO wal_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Intte giddon sinttappe yelettana attuma naati ubbai yelettido hosppuntta gallassan qaxxarettana koshshees. Ne son yelettidaageeta gidin, woikko allagaappe miishshan shamettida ailleta gidin, ne zeretta gidennaageetakka attumaageeta qaxxaranau koshshees. ");
INSERT INTO wal_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ne son yelettidaageetikka ne miishshan shamettidaageetikka qaxxarettona. Hagee intte ashuwan de7iya ta maachchai merinaa maachcha gidana. ");
INSERT INTO wal_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Qaxxarettiichchibeenna, ba shoohuwaara de7iya attuma asai ubbai ba asaappe duuxxana; aissi giikko, i ta maachchaa kanttiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Qassikka Xoossai Abrahaama, “Simmi, ne keettaayee Saarayi sunttaa Saarayo gooppa; hagaappe sinttau i sunttai Saaro. ");
INSERT INTO wal_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Taani o anjjana; taani ippe neeyyo attuma na7a tumu immana. O taani anjjana; a kawotettatuyyo aayo gidana; asaa kawoti ippe yaana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Yaagin Abrahaami ba som77uwan gufanniis; i miiccidi ba wozanan, “Xeetu laitta asi tumu na7a yelanee? Qassi uddufun tammu gidido Saara na7a yelanee?” yaagidi qoppiis. ");
INSERT INTO wal_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Yaagi qoppidi Abrahaami Xoossaa, “Isimaa7eeli tana laattiyaagaa gidanau danddayennee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","SHin Xoossai, “CHii, ne keettaayyiyaa Saara neeyyo attuma na7a tumuppe yelana; yelettin neeni Yisaaqa gaada a sunttana. Appe guyyiyan, a zerettaassi merinaa maachcha gidana mala, taani aara ta maachchaa maacettana. ");
INSERT INTO wal_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Qassi Isimaa7eelabaa gidikkonne, neeni oichchidoogaa taani siyaas; taani akka anjjana; taani a yeletissananne a zerettaa keehi corayana; i tammanne naa77u daannata yelana; taani a zerettaa gita kawotetta oottana. ");
INSERT INTO wal_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","SHin taani ta maachchaa laitti hannoode Saara neeyyo yeliyo Yisaaqaara maacettana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Xoossai Abrahaamaara haasayidi wurssidoogaappe guyyiyan, Abrahaamappe shaahettidi pude biis. ");
INSERT INTO wal_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","He gallassankka Abrahaami ba na7aa Isimaa7eela, ba son yelettida ubbaa, ba miishshan shammidoogeeta ubbaa, ba son de7iya attuma asa ubbaa, Xoossai ayyo odidoogaadan eta attumatettaa shoohuwaa qaxxariis. ");
INSERT INTO wal_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahaami ba attumatettaa shoohuwaa qaxxarettiyo wode, uddufun tammanne uddufun laitta asa; ");
INSERT INTO wal_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","a na7ai Isimaa7eeli ba attumatettaa shoohuwaa qaxxarettiyo wode, tammanne heezzu laitta na7a. ");
INSERT INTO wal_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahaaminne a na7ai Isimaa7eeli naa77aikka he gallassi qaxxarettidosona. ");
INSERT INTO wal_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abrahaama son de7iya attuma asai ubbai, a son yelettidaageetinne miishshan shammidoogeeti ubbai aara qaxxarettidosona. ");
INSERT INTO wal_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahaami Mamire wolatu gitatu garssan ba dunkkaaniyaa penggen seeta gallassan uttidaashin, GODAI ayyo qoncciis. ");
INSERT INTO wal_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahaami xoqqu giidi xeellidi heezzu asati a matan eqqidaageeta be7iis; be7idi etaara gaittanau ba dunkkaaniyaa penggeppe denddidi woxxiis; woxxi gakkidi, biittan hokkidi, eta sinttan ziggiis. ");
INSERT INTO wal_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ziggi simmidi i, “Abeet ta godau, taani ne sinttan nashettidabaa gidikko, tana ne ashkkaraa aggada aadhdhoppa. ");
INSERT INTO wal_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Hai guutta haatti yo; yin intte tohoi meecettin, ha mittaa kuwan shemppi ekkite. ");
INSERT INTO wal_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Intte ha77i taakko intte ashkkaraakko yiido gishshau, gazddidi intte biyoosaa baana mala, taani intteyyo miyoobaa ehais” yaagiis. Yaagin eti, “Daro lo77o; neeni giyoogaadan ootta” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Yaagin Abrahaami dunkkaaniyaa giddo Saarikko eesoti biidi, “Eesotada liiqo xiilliyaappe heezzu kere gidiyaagaa ekka munaqqada oittaa uukka” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Qassi, Abrahaami ba wudiyaakko woxxi biidi, lo77o anqqara maraa dooridi, issi ashkkarau immin, i eesuwan shukkidi giigissiis. ");
INSERT INTO wal_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yaatin Abrahaami meqqida maattaanne giigissido maraa ashuwaa imattatu sintti aattiis; eti miishin, i he mittaa garssan eta matan eqqiis. ");
INSERT INTO wal_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Eti a, “Ne keettaayyiyaa Saara awaanee?” yaagidi oichchidosona. Oichchin i, “Hinin dunkkaane giddon de7ausu” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yaagin GODAI a, “Taani laitti hannoode tumu neekko simmana; he wode ne keettaayyiyaa Saara attuma na7a yelana” yaagiis. Saara he wode appe guyye baggaara de7iya dunkkaaniyaa penggen de7iyaara hegaa siyausu. ");
INSERT INTO wal_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahaaminne Saara bantta laittaa keehi sugidi ceggiichchidosona. Saariyyo kushe qitai yiyoogaa aggirggiis. ");
INSERT INTO wal_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hegaa gishshau Saara ba wozanan, “Taani ha77i cima wuraichchidoogaappe guyyiyaaninne ta godai ceeggidoogaappe guyyiyan, ha77i taayyo attuma asaara gaittiyoogee waani hananee?” yaagada miiccaasu. ");
INSERT INTO wal_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","GODAI Abrahaama he wode, “‘Taani cimaichchidoogaappe guyyiyan, tumu na7a yelaneeyye?’ gaada, Saara aissi miiccadee? ");
INSERT INTO wal_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","GODAU danddayettennabi tumu de7iiyye? Laitti hannoode taani neekko simmana; he wode Saara attuma na7a yelana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Yaagin Saara keehi yayyido gishshau, “Taani miiccabeikke” yaagada lahottaasu. SHin i, “Ee, neeni tumu miiccadasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hegaappe guyyiyan asati denddidi biidi, Sadooma katamaa duge zaari xeellidosona; Abrahaaminne eta moissiiddi etaara biis. ");
INSERT INTO wal_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","GODAI he wode, “Taani ta oottana haniyoobaa Abrahaamappe qosikke. ");
INSERT INTO wal_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahaami tumuppe gitanne wolqqaama kawotetta gidana; ha sa7aa kawotettati ubbai a baggaara anjjettana. ");
INSERT INTO wal_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Aissi giikko, xillotettaanne pirddaa oottidi, GODAA ogiyaa naaganaadan ba naatanne baappe guyyiyan, ba so asaa i zorana mala, taani a dooraas; hegeenne GODAI Abrahaamayyo immana giidoogaa ubbaa polanaassa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","21","Yaagidi GODAI Abrahaama, “Sadoomappenne Gamoorappe waassiyo waasoi keehi darido gishshaunne eta nagarai keehi deexxido gishshau, eti oottidobi taakko gakkida waasuwaa keesa iitakkonne be7anau ane taani duge wodhdhais; hegaa mala iita gidana xayikkonne erana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hegaappe guyyiyan, naa77u asati Sadoomakko simmidi biidosona; shin Abrahaami GODAA sinttan eqqidosankka de7ees. ");
INSERT INTO wal_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","He wode Abrahaami akko shiiqidi yaagiis; “Tumu neeni xillota iitatuura xaissuutee? ");
INSERT INTO wal_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","He gita kataman ishatamu xilloti de7iyaakkokka, neeni xaissuutee? Neeni an de7iya ishatamu xillotu gishshau he katamaa ashshikkii? ");
INSERT INTO wal_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hegee neeppe haakko; xillota iitatuura woriyoogeenne xillotanne iitata issi aifiyan xeelliyoogee neeppe haakko. Ha sa7aa ubbaa pirddiyaagee xillo pirddenneeyye?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yaagin GODAI, “He Sadooma kataman ishatamu xilloti de7ikko, he sohuwaa ubbaa eta gishshau taani ashshana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Hegaappe guyyiyan Abrahaami, “Taani biittanne bidintta gidaidda ta Godaara xalan haasayanau simmi doommaichchaas; ");
INSERT INTO wal_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ishatamu xillotuppe ichchashai paccikko, neeni he ichchashatu gishshau he katamaa ubbaa xaissuutee?” yaagiis. Yaagin GODAI, “Taani yan oitamanne ichchashu xillota demmikko, he katamaa xaissikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahaami zaarettidikka, “Yan oitamaa xalaalai beettikko shin?” yaagiis. Yaagin i, “Taani he oitamatu gishshau, he katamaa xaissikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hegaappe guyyiyan i, “Hai Godai taayyo hanqqettoppo; taani gujjadakka haasayais. Yan hasttamaa xalaalai beettikko shin?” yaagiis. Yaagin GODAI, “Taani yan hasttamaa demmikko, he katamaa xaissikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahaami qassikka, “Taani Godaara xalan haasayanau doommaichchaas; yan laatamaa xalaalai beettikko shin?” yaagiis. Yaagin GODAI, “He laatamatu gishshau taani a xaissikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hegaappe guyyiyan Abrahaami, “Hai Godai taayyo hanqqettoppo; taani mexi issitoo haasayais; yan tammaa xalaalai beettikko shin?” yaagiis. Yaagin GODAI, “He tammatu gishshau taani he katamaa xaissikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","GODAI Abrahaamaara haasayaa wurssidoogaappe guyyiyan biis; Abrahaamikka ba soo simmiis. ");
INSERT INTO wal_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","He naa77u kiitanchchati omarssi Sadooma katamaa gakkidosona; he wode Looxee he katamaa penggen uttiis. Looxee eta be7innee etaara gaittanau eqqidi biis; biidi, ba som77uwaa sa7aa gattidi ziggiis; ");
INSERT INTO wal_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ziggidi, “Ta godaatoo, intte ashkkaraa soo simmerkketii; intte gediyaa meecettidi qammaa aqite; guuran denddidi intte biyoosaa beeta” yaagiis. Yaagin eti, “CHii; nuuni ha katamaa gutaran aqana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","SHin i eta keehi shoobbido gishshau, aara biidi a soo gelidosona; gelin i etau qumaa kattidi, caalenna oittaa uukkidi aattin, eti miidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Eti zin77ennan de7ishin, Sadooma katamaa attuma asai ubbai, naatuppe cimaa gakkanaashin, issoinne attennan yiidi, keettaa yuuyi aadhdhi dooddidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Dooddidi Looxa xeesidi yaagidosona; “Hachchi qammi ne soo yiida attuma asati awan de7iyoonaa? Nuuni etaara shaaramuxana mala eta nuukko kare kessa” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Yaagin Looxee etaara gaittanau kare kiyiiddi, kariyaa guyye gorddiis; ");
INSERT INTO wal_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","gorddidi eta hagaadan yaagiis; “Ta ishatoo, ha iita oosuwaa oottoppite. ");
INSERT INTO wal_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Simmi taayyo naa77u macca naati, attuma asi xaallibeenna geela7oti de7oosona; taani eta intteyyo kare kessais; intte eta inttena lo77aadan oottana danddayeeta. SHin ha asatu bolli ainne oottoppite; aissi giikko, eti ta keettaa gelidi ta kaaraa garssan de7oosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yaagin asati a, “Nu sinttappe kichcha!” yaagidosona; qassikka eti, “Ha bitanee ha biittan bete gididi yiidi, ha77i nu bolli pirddanau kajjeelees! Ha77i nuuni nena etau qoppidoogaappe iitaa oottana baawee!” yaagidosona. Yaagidi eti Looxa guyye sugi yeggidi penggiyaa menttanau shiiqidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","SHin he naa77u asati bantta kushiyaa kare yeddidi, Looxa soo goochchi gelissidi penggiyaa gorddi bayidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hegaappe guyyiyan, eti keettaa penggen de7iya asaa, guuttaappe gitaa gakkanaassi qooqissi aggidosona. Yaatin eti penggiyaa demmanau koyiiddi daafuridosona. ");
INSERT INTO wal_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","He naa77u asati Looxa, “Neeyyo hagan ne macca naata giigissidaageeti, ne attuma naati woikko ne macca naati woikko nebaa gidiya asi oona gidikkonne ha kataman de7ii? De7ikko, eta hagaappe kessargga. ");
INSERT INTO wal_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Aissi giikko, nuuni ha sohuwaa xaissana haneettees. Etappe waassiyo waasoi GODAA sinttan keehi darido gishshau, GODAI nuna ha katamaa xaissanau kiittiis” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hegaa gishshau Looxee kiyidi, ba macca naata giigissidaageetukko biidi eta, “Eesuwan denddidi hagaappe kiyiichchite; aissi giikko, GODAI ha katamaa xaissana hanees” yaagiis. SHin a macca naata giigissidaageeti i naacees giidi qoppidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sa7ai wonttanau bazzoi zo77iyo wode, he kiitanchchati Looxa, “Dendda! Ne keettaayyiyoonne hagan de7iya ne naa77u macca naata ekkada eesuwan kiya! Kiyana xayikko, ha katamai pirddettiyo wode neenikka xayaasa” yaagidi dirbbanttidosona. ");
INSERT INTO wal_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","SHin Looxee yooqu gin, he asati a kushiyaa, a keettaayee kushiyaanne a macca naatu naa77aa kushiyaa oiqqidi, he katamaappe eta kessidosona; aissi giikko, GODAI etayyo qarettiis. ");
INSERT INTO wal_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kiitanchchati eta katamaappe kessidosaarakka, he kiitanchchatuppe issoi yaagiis; “Intte shemppuwaa ekkidi baqatite! Guyye xeelloppite! Qassi ha wombban awankka eqqoppite! Deriyaakko baqatite! Hankkoode intte xayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","SHin Looxee etayyo yaagiis; “CHii! Hai ta godaatoo, yaagoppite. ");
INSERT INTO wal_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Taani intte ashkkarai intte sinttan nashettido gishshau, tana ashshanau taayyo daroppe kehideta. SHin taani deriyaakko baqatanau danddayikke; hagee bashshai gakkidi tana muukkananne taanikka haiqqana. ");
INSERT INTO wal_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Xeellite; hagan issi katamai de7ees; i woxxanau matanne guutta katama. Taani yaa baqatoo? I qii guutta katama gidennee? Ta shemppoi yan attana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Yaagin kiitanchchai, “Ee, taani ne oishaa siyana; taani neeni giyo katamaa xaissikke. ");
INSERT INTO wal_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","SHin yaa eesuwan baqata; aissi giikko, neeni yaa gakkanaashin, taani ainne oottanau danddayikke” yaagiis. Hegaa gishshau he katamaa sunttai Xoo7aaro geetettiis. ");
INSERT INTO wal_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Looxee Xoo7aaro gakkido wode, biron xalqqee dolees. ");
INSERT INTO wal_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","GODAI he wode tamaanne eexxiya dinniyaa Sadoomanne Gamoora bollan GODAA matappe saluwaappe bukissi bayiis. ");
INSERT INTO wal_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hegaadan oottidi GODAI he katamata, he wombbaa ubbaa, he katamatu giddon de7iya ubbaanne he biittan de7iya mittaa maataa xaissiis. ");
INSERT INTO wal_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","SHin Looxe keettaayyiyaa guyye xeellada maxine tuussa gidaasu. ");
INSERT INTO wal_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wonttetta gallassi maallado guuran Abrahaami denddidi, GODAA sinttan kase i eqqido sohuwaa simmidi biis. ");
INSERT INTO wal_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","I Sadoomanne Gamoora he wombban de7iya biitta ubbaa duge xeelliis; xeelliyo wode cuwai coociyaa tamaa cuwaadan he biittaappe denddiyaagaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Xoossai he wombbaa katamata xaissido wode, Abrahaama hassayiis; hassayidi Looxee de7ido katamata xaissiiddi Looxa bashshaappe kessiis. ");
INSERT INTO wal_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Looxee Xoo7aaron uttanau yayyido gishshau, ba macca naatu naa77aara deriyaa kiyiis; kiyidi gonggolo giddon ba naa77u macca naatuura uttiis. ");
INSERT INTO wal_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Issi gallassi baira na7iyaa kaaliyo, “Nu aawai cimiis; sa7a ubban de7iya wogaadan nunaara zin77anau ha biittan mulekka attuma asi baawa. ");
INSERT INTO wal_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Haaya; woiniyaa eessaa nu aawaa ushshidi, aara zin77idi, nu aawaappe nu zariyaa turaa ashshoos” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","He gallassa qammikka bantta aawaa woiniyaa eessaa ushshidosona; uyin bairiyaa gelada aara zin77aasu; a aara zin77iyo wodekka denddiyo wodekka i eribeenna. ");
INSERT INTO wal_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wonttetta gallassi bairiyaa kaaliyo, “Siya; zino taani ta aawaara zin77aas; hachchi qammi qassi woiniyaa eessaa ushshin, neenikka gelada aara zin77a; yaatidi nuuni nu aawaappe nu zariyaa turaa ashshoos” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Yaagin he gallassi qammi qassikka woiniyaa eessaa ushshidosona; uyin kaaliyaakka gelada aara zin77aasu; a aara zin77iyo wodekka denddiyo wodekka i eribeenna. ");
INSERT INTO wal_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Yaatidi Looxe macca naati naa77aikka bantta aawaayyo shahaaridosona. ");
INSERT INTO wal_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bairiyaa attuma na7aa yelaasu; a sunttaa Moo7aaba gaada sunttaasu; inne hachchi gakkanau Moo7aabatu aawaa. ");
INSERT INTO wal_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Qassi kaaliyaakka attuma na7aa yelaasu; a sunttaa Ben77aama gaada sunttaasu; inne hachchi gakkanau Amoonatu aawaa. ");
INSERT INTO wal_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahaami Mamireppe denddidi, Neegeeba giyo biitti biis; biidi Qaadeesanne SHura giyo katamatuppe gidduwan de7iis; Garaarankka amarida wodiyaa takkiis. ");
INSERT INTO wal_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Yan Abrahaami ba keettaayyiyo Saaro, “A ta michchiyo” yaagiis. Yaagin Garaara Kawoi Abimeleki kiittidi Saaro efiis. ");
INSERT INTO wal_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","SHin Xoossai issi qammi aimuwan Abimelekakko yiidi, a hagaadan yaagiis; “Neeni ehiido maccaasee gaasuwan haiqqaasa; aissi giikko, a azina machcho” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","SHin Abimeleki ikko shiiqibeenna. Yaanidaagee, “Godau, neeni xillo kawotettaa xaissuutee? ");
INSERT INTO wal_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","I, ‘A ta michchiyo’ gibeenneeyye? Qassi a, ‘I ta ishaa’ gabeikkee? Taani ta wozanaa suuretettaaninne ta kushiyaa geeshshatettan hagaa oottaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Hegaappe guyyiyan, Xoossai aimuwan a yaagiis; “Ee, neeni ne wozanaa geeshshatettan oottidoogaa taani eraas; hegaa gishshau, neeni o bochchenna malanne ta sinttan nagara oottenna mala nena taani teqqaas. ");
INSERT INTO wal_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ha77i ha bitaniyaa keettaayyiyo zaara; aissi giikko, i hananabaa yootiyaagaa; i neeyyo Xoossaa woossana; woossin neeni paxa attana. SHin o zaarana xayikko, neeninne neeyyo de7iyaabai ubbai haiqqiyoogaa tumuppe era” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yaagin Abimeleki wonttetta gallassi maallado ba kawotettaa halaqata ubbaa xeesiis; xeesidi ha yoho ubbaa etayyo yootin, eti keehi daro yayyidosona. ");
INSERT INTO wal_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Yaatin Abimeleki Abrahaama xeesidi, “Neeni aibabaa nu bolli oottadii? Neeni ta bollinne ta kawotettaa bolli gita nagaraa ehaanau taani neeyyo aiba iitabaa oottidanaa? Neeni ta bolli oosettanau bessennabaa oottadasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Qassikka Abimeleki Abrahaama, “Nena hagaa ootissidabi aibee?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Oichchin Abrahaami yaagiis; “‘Xoossau yayyiya issi asinne ha sohuwan baawa’ gaada qoppido gishshaassanne, ‘Ta keettaayee gaasuwan eti tana worana’ gaada qoppido gishshassa. ");
INSERT INTO wal_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Hegaa bolli a tumukka ta michchiyo; ta aayee na7iyo gidennaagaappe attin, ta aawaa na7iyo; qassi a ta keettaayo gidaasu. ");
INSERT INTO wal_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Xoossai tana ta aawaa keettaappe kessido wode taani iyyo, ‘Nuuni biido biittan ubban neeni taayyo oottana kehatettai hagaa; “I ta ishaa” gaada tabaa haasaya’ yaagaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Hegaappe guyyiyan Abimeleki dorssaa, mehiyaa, macca ailletanne attuma ailleta ehiidi, Abrahaamayyo immiis; qassi a keettaayyiyo Saaro ayyo zaariis. ");
INSERT INTO wal_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki, “Simmi ta biittai ne sinttaana; nena lo77asan de7a” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saarokka, “Taani ne ishaayyo issi sha7u xaqara biraa immais; hagee simmi nenaara de7iya ubbaa sinttan neeni xillo gidiyoogaanne neeni shatimmidoogaa erissiyaagaa gido” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","GODAI Abrahaama keettaayee Saari gaasuwan Abimeleka keettaa asa ubbaa qanttaa mainissi wottido gishshau, Abrahaami Xoossaa woossin, Abimeleki, a keettaayyiyaanne a macca ashkkarati na7a yelana mala Xoossai eta pattiis. ");
INSERT INTO wal_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Xoossai ba yootidoogaadan Saarikko yiis; yiidi Xoossai Saariyyo ba giidoogaadan oottiis. ");
INSERT INTO wal_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saara shahaarada, ceeggida Abrahaamayyo Xoossai giido wodee gakkin, attuma na7aa yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Saara ayyo yelido ba na7aa sunttaa Abrahaami “Yisaaqa” yaagidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abrahaami ba na7aa Yisaaqa Xoossai azazidoogaadan hosppuntta gallassan qaxxariis. ");
INSERT INTO wal_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","A na7aa Yisaaqi ayyo yelettido wode, Abrahaama laittai xeeta. ");
INSERT INTO wal_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saara, “Xoossai taayyo miichchaa immiis; qassi hagaa siyiya ubbai tanaara miiccana” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Qassikka Saara, “Abrahaamayyo Saara na7a xanttana giidabi oonee? Gidikkonne taani ha77i ayyo i ceeggido wodiyan na7a yelaas” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Guutta na7ai diccidi, xanttaa duuxxiis; Abrahaami Yisaaqi xanttaa duuxxido gallassi wolqqaama gibiraa kessiis. ");
INSERT INTO wal_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","SHin Gibxxeppe yiida Aggaara Abrahaamayyo yelido na7ai qoosiyoogaa Saara be7aasu. ");
INSERT INTO wal_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Be7ada Abrahaama, “Ha aillee na7ai ta na7aa Yisaaqaara mulekka laattenna gishshau, ailliyoonne i na7aa kessa yedda” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Yaagin ha yohoi ba na7aa bochchiyo gishshau, Abrahaami keehippe metootiis. ");
INSERT INTO wal_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","SHin Xoossai Abrahaama, “Na7aayyoonne ne ailleeyyo keehi metootoppa; Saara neeyyo yootiyoobaa ubbaa siya; aissi giikko, ne zerettai Yisaaqa baggaara xeesettana. ");
INSERT INTO wal_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Qassi aillee na7aa taani kawotetta kessana; aissi giikko, ikka ne zare” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Maallado guuran Abrahaami denddiis; denddidi qumaanne lukkaamon haattaa ekkidi, Aggaaro hashiyan toossidi, i na7aakka iyyo immidi kessi yeddiis. A baada, Berssaabehi giyo bazzuwan toilattaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Haattaikka lukkaamuwan wurido wode a, “Na7ai haiqqishin, uttada be7ikke” yaagada, na7aa issi buuraa garssan wottada, naa77u xeetu wara gidiyaagaa keenaa baada utta bayaasu. Matan uttada, ba qaalaa xoqqissada yeekkaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Xoossai na7aa waasuwaa siyiis; Xoossaa kiitanchchai Aggaaro saluwaappe xeesidi, “Aggaaree, waanadii? Xoossai na7ai zin77idosan waassiyoogaa siyido gishshau yayyoppa; ");
INSERT INTO wal_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","dendda eqqa; na7aanne ne kushiyan dentta; aissi giikko, taani a gita kawotetta oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Xoossai i aifiyaa dooyin, haatta ollaa be7aasu; baada lukkaamuwan haattaa kunttaasu; na7aakka ushshaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Na7ai dicciyo wode, Xoossai aara gidiis; i bazzuwan de7idi, wonddafiyaa dukkiya asa gidiis. ");
INSERT INTO wal_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","I Paaraana giyo bazzuwan de7ishin, a aayyiyaa Gibxxeppe ayyo machcho demmaasu. ");
INSERT INTO wal_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","He wode, Abimeleki ba wotaaddaratu halaqaa Pikoolaara Abrahaamakko biidi, “Neeni oottiyo ubbaban Xoossai nenaara de7ees. ");
INSERT INTO wal_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Neeni ta bolli woikko ta naatu bolli woikko ta zerettaa bolli genebaa oottenna mala, ha77i hagan, Xoossaa sinttan taayyo caaqqa; taani neeyyo kehidoogaadan, neenikka taayyoonne neeni imattatettan de7iyo ha biittaayyo keha” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Yaagin Abrahaami, “Taani caaqqais” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","He wode, Abrahaami Abimeleka ashkkarati ekkido haattaa ollaabaa Abimelekayyo maganniis. ");
INSERT INTO wal_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","SHin Abimeleki, “Hegaa ooni oottidaakko taani erikke; neenikka qassi taayyo yootabaakka; taani hachchi gakkanau hegaa siyabeikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hegaappe guyyiyan Abrahaami dorssaanne miizzata ehiidi, Abimelekayyo immin, eti naa77ai maachchaa maacettidosona. ");
INSERT INTO wal_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahaami laappun macca dorssa marata wudiyaappe shaakkiis; ");
INSERT INTO wal_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","shaakkin Abimeleki Abrahaama, “Ha neeni dumma shaakka wottido laappun macca dorssa marata aissi shaakkadii?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Oichchin Abrahaami, “Taani ha haattaa ollaa bookkidoogau markka gidana mala, ha laappun macca dorssa marata ta kushiyaappe ekka” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hegan he naa77u asati maacettido gishshau, he sohoi Berssaabehi geetettiis. ");
INSERT INTO wal_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Berssaabehan maachchaa maacettidoogaappe guyyiyan, Abimelekinne a wotaaddaratu halaqaa Pikooli denddidi, Pilisxxeema biittaa simmidosona. ");
INSERT INTO wal_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahaami Berssaabehan taamaariskki giyo mittaa tokkiis. Hegan GODAA, Merinaa Xoossaa, sunttaa xeesiis. ");
INSERT INTO wal_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahaami Pilisxxeema biittan daro wodiyaa de7iis. ");
INSERT INTO wal_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hegaappe simmin, Xoossai Abrahaama paacciis; i a, “Abrahaamaa” yaagidi xeesiis. Xeesin i, “Yee” yaagidi koyiis. ");
INSERT INTO wal_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Koyin Xoossai, “Neeni siiqiyo ne mexi issi na7aa Yisaaqa ekkada, Mooriyaa giyo biitti ba; baada yan taani neeyyo yootiyo issi deriyaa bollan a xuuggiyo yarshsho oottada taayyo yarshsha” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Yaagin wonttetta gallassi Abrahaami guuran denddidi, ba hariyaa caaniis; ba ashkkaratuppe naa77aanne ba na7aa Yisaaqa banaara ekkidi, xuuggiyo yarshshuwaayyo gidiya mittaa qeri ekkidi, Xoossai ayyo yootidosaa baanau denddiis. ");
INSERT INTO wal_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Biiddi heezzantta gallassi Abrahaami xoqqu giidi, he sohuwaa haahuwan be7iis. ");
INSERT INTO wal_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abrahaami ba ashkkarata, “Ha hariyaara hagan de7ishshite; taaninne ta na7ai yaa biidi Xoossaassi goinnidi, inttekko simmana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahaami yarshshuwaa mittaa denttidi, ba na7aa Yisaaqa toossiis; toossidi tamaanne billamaa i baayyo oiqqiis. Eti naa77ai issippe biishin, ");
INSERT INTO wal_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisaaqi ba aawaa Abrahaama, “Ta aawau” yaagiis. Yaagin Abrahaami, “Yee, ta na7au” yaagiis. Yaagin i, “Tamainne mittai hageeho; shin xuuggidi yarshshiyo dorssa mari awaanee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Yaagin Abrahaami, “Ta na7au, xuuggidi yarshshiyo dorssa maraa Xoossai baayyo immana” yaagiis. Yaanin eti naa77ai issippe biidosona. ");
INSERT INTO wal_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Eti Xoossai ayyo yootido sohuwaa gakkido wode, Abrahaami yarshshuwaa yarshshiyoosaa yan gimbbidi, mittaa dacaa yeggiis; ba na7aa Yisaaqa qachchidi, he mittaa bollan zin77issiis. ");
INSERT INTO wal_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Zin77issidi Abrahaami ba na7aa shukkanau ba kushiyaa yeddidi billamaa ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","SHin GODAA kiitanchchai saluwaappe a, “Abrahaamaa, Abrahaamaa” yaagidi xeesiis. Xeesin i, “Yee” giidi koyiis. ");
INSERT INTO wal_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Koyin a, “Na7aa bollan ne kushiyaa wottoppa; a ainne oottoppa; neeni ne mexi issi na7aakka tana diggabeenna gishshau, neeni Xoossau yayyiyaagaa gidiyoogaa taani ha77i erais” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Yaagin Abrahaami xoqqu gi xeellidi, hegan dorssa issoi kacee buuran geli qaxetti uttidoogaa be7iis. Abrahaami biidi he dorssaa ekkidi, ba na7aa gishshaa xuuggiyo yarshsho oottidi yarshshi bayiis. ");
INSERT INTO wal_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Hegaa gishshau Abrahaami, “GODAI immana” yaagidi he sohuwaa sunttiis; hachchi gakkanaashinkka haisee, “GODAA deriyan imettana” geetettees. ");
INSERT INTO wal_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","GODAA kiitanchchai saluwaappe naa77anttidi Abrahaama xeesidi yaagiis; ");
INSERT INTO wal_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“GODAI, ‘Hagaadan yaagada neeyyo taani ta huuphiyan caaqqais; neeni hagaa oottido gishshaunne ne mexi issi na7aakka tana diggabeenna gishshau, ");
INSERT INTO wal_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","taani nena tumu anjjana; ne zerettaakka taani saluwaa xoolinttiyaa keenanne abbaa doona shafiyaa keeni oottada corayana. Ne zerettati bantta morkketu katamata laattana. ");
INSERT INTO wal_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Neeni taayyo azazettido gishshau, ha sa7aa kawotettati ubbai ne zerettaa baggaara anjjettana’ yaagees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hegaappe guyyiyan, Abrahaami ba ashkkaratukko simmin, eti ubbai issippe Berssaabeha denddidi biidosona. Abrahaami Berssaabehan de7iis. ");
INSERT INTO wal_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hegaappe simmin Abrahaamassi, “Milkka ne ishaa Naakoorayyo naata yelaasu; ");
INSERT INTO wal_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","etinne bairai Uuxa; Uuxa ishati Buuza, ");
INSERT INTO wal_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Araama aawaa Qamu7eela, Keesada, Haazo, Pilddaasha, Yidilaafanne Baatu7eela. ");
INSERT INTO wal_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Hageeta ha hosppun naatakka Milkka Abrahaama ishaa Naakoorayyo yelaasu; Baatu7eeli Ribiqo yeliis. ");
INSERT INTO wal_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Raa7uma giyo a kaadumatiyaa qassi Xebaaha, Gahaama, Tahaashanne Maa7ika yelaasu” yaagidi yootidosona. ");
INSERT INTO wal_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saara xeetanne laatamanne laappun laitta de7aasu. ");
INSERT INTO wal_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Hegaappe guyyiyan a Kanaane biittan de7iya (Kebroona giyo) Qiriyaati-Arbba7a kataman haiqqaasu. Haiqqin Abrahaami Saariyyo yeekkanaunne kayyottanau biis. ");
INSERT INTO wal_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Yeekki simmidi, Abrahaami ba keettaayee ahaa matappe denddidi biidi, Hiiteta hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Taani intte giddon betenne imatta; ta keettaayee ahaa mooganau taayyo intte gadiyaappe makkaanaa baizzerkketii!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Yaagin Hiiteti ayyo, “Godoo, nuuni yootiyoogaa siya; neeni nu giddon wolqqaama halaqa; neeni ne keettaayee ahaa nu duufuwaappe nena lo77idaagan mooga; neeni ne keettaayee ahaa mooganau ba duufuwaa ooninne nena diggenna” yaagi zaaridosona. ");
INSERT INTO wal_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yaagin Abrahaami denddi eqqidi, Hiitetu sinttan ziggiis. ");
INSERT INTO wal_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","I etayyo, “Intte tana, ‘Ne keettaayee ahaa mooga’ giikko siyite; Xoohaara na7aa Efiroonayyo a gadiyaa gaxan de7iya Maakipheela giyo gonggoluwaa taayyo makkaana kessanau baizzana mala kumetta waagan nuna zal77isserkketii” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hiitiyaa Efirooni he wode katamaa penggen shiiqida ba asaa giddon uttiis; uttidaagee Hiiteti ubbai siyishin, Abrahaamayyo yaagiis; ");
INSERT INTO wal_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hegaadan gidenna; ta godau, ta yootiyoogaa siya; taani gadiyaakka a giddon de7iya gonggoluwaakka neeyyo immais; taani neeyyo a ta asaa sinttan immais; neeni ne keettaayee ahaa mooga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yaagin Abrahaami he biittaa asaa sinttan zaaretti ziggidi, ");
INSERT INTO wal_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","asai siyishin Efiroona, “Ta yootiyoogaa siyarkkii! Taani he gadiyaa waagaa qanxxana; neeni taappe ekkarkkii! Hegan taani ta keettaayee ahaa moogana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Yaagin Efirooni Abrahaamayyo zaaridi, “Ta godau, taani odiyoogaa siya; gadee oiddu xeetu xaqara biraa kessiyaagaa; shin hegee ne giddooninne ta giddon ainne gidenna; ne keettaayee ahaa mooga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Yaagin Abrahaami Hiiteti siyishin, Efirooni giido waagaa maayiis; maayidi, he wode miishshan oiddu xeetu xaqara biraa Efiroonayyo immiis. ");
INSERT INTO wal_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Immin Mamire katamaa matan Maakipheelan de7iya Efiroona gadee, hegan de7iya gonggoloinne he gadiyan de7iya mitta ubbai, ");
INSERT INTO wal_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","katamaa penggen shiiqida Hiitetu ubbaa sinttan higgiyan Abrahaama gade gidiis. ");
INSERT INTO wal_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Hegaappe guyyiyan, Abrahaami ba keettaayyiyo Saaro Kanaane biittan (Kebroona giyo) Mamire katamaa matan de7iya Maakipheela giyo gade gonggoluwan moogiis. ");
INSERT INTO wal_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hegaa gishshau he gadeenne hegan de7iya gonggoloi Hiitetu sinttan higgiyan Abrahaamassi makkaana gidiis. ");
INSERT INTO wal_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahaami keehippe sa7aa sugidi cimiis; GODAI a ubbabankka anjjiis. ");
INSERT INTO wal_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahaami ba ashkkaraa, ba so asa ubbau halaqatiya, ba aqo ubbau godattiyaagaa hagaadan yaagiis; “Ne kushiyan ta gulbbataa oiqqa; ");
INSERT INTO wal_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","taani eta giddon de7iyo Kanaanetu macca naatuppe ta na7aayyo machcho oichchenna mala, GODAN, saluwaa Xoossaaninne sa7aa Xoossan taani nena caaqettais; ");
INSERT INTO wal_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","shin neeni ta yelettido biittaa, ta dabbotukko baada, ta na7aa Yisaaqayyo machcho oichcha” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yaagin a ashkkarai, “Maccaasiyaa tanaara yaanau dosennabaa gidikko, ne na7aa neeni yiido biitti guyye efoo?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Oichchin Abrahaami, “Ta na7aa yaa efeennaadan nena era! ");
INSERT INTO wal_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","GODAI, saluwaa Xoossai, tana ta aawaa sooppenne ta yelettido biittaappe kessidaagee taayyo, ‘Ne zariyaayyo taani ha biittaa immana’ yaagidi caaqqidaagee, neeni ta na7aayyo yaappe machcho demmana mala, i ba kiitanchchaa neeppe sinttau kiittana. ");
INSERT INTO wal_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Maccaasiyaa nenaara guyye yaanau dosennabaa gidikko, ha taani nena caaqettido caaqoi neeyyo gometenna; shin ta na7aa yaa guyye mulekka efooppa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Yaagin ashkkarai ba godaa Abrahaama gulbbataa oiqqiis; oiqqidi ha yohuwaassi caaqqiis. ");
INSERT INTO wal_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hegaappe guyyiyan, ashkkarai ba godaa gaameelatuppe tammaa ekkidi, ba godaa miishshaappekka murutaa murutaa ekkidi biis; biidi Masphphexoomiyaa giyo biittan Naakoora katamaa gakkiis. ");
INSERT INTO wal_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Gakkidi omarssi, maccaasai haattaa tikkanau yiyo wodiyan, katamaappe gaxan haatta ollaa matan ba gaameelata gulbbatissiis. ");
INSERT INTO wal_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Yaatidi i hagaadan yaagidi woossiis; “GODAU, ta godaa Abrahaama Xoossau, hachchi taani qoppada yiidobaa tau injjeya; qassi ta godaa Abrahaamayyo kehabaa ootta. ");
INSERT INTO wal_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Be7a! Taani ha haattaa pulttuwaa matan eqqais; ha katamaa asaa macca naatinne haattaa tikkanau haa yoosona. ");
INSERT INTO wal_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Taani, ‘Ane otuwaa ziqqi oottada tana haattaa ushsha’ giyo wode, akka, ‘Hekko uya; qassi ne gaameelatakka taani ushshana’ yaagiyaara, hinna ne ashkkaraa Yisaaqayyo neeni dooridooro gidu; neeni ta godaayyo kehabaa oottidoogaa taani hegan erana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Biron i woosaa zaarennan de7ishin, Ribiqa haatta otuwaa tookkada puttu gaasu. O Baatu7eeli yeliis; Baatu7eeli Milkki na7aa; Milkka Abrahaama ishaa Naakoora keettaayyiyo. ");
INSERT INTO wal_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ribiqa keehi puulanchchanne attuma asi xalibeenna geela7o. Pulttuwaa duge wodhdhada, ba otuwaa kunttada kiyaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kiyin he ashkkarai ikko woxxi biidi o, “Ne otuwaappe tana guutta haattaa ushsharkkii!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Yaagin a, “Eeno ta godau, uyikkii” yaagaasu. Eesotada otuwaa ba hashiyaappe wottada, geddi ootta oiqqada a ushshaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","A ushshidoogaappe guyyiyan, “Ne gaameelatikka alana gakkanaassi taani etayyo haattaa duuqqana” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Attida haattaa eesuwan wonggiriyan tigada, hara haattaa duuqqanau ollaa woxxaasu; gaameelati ubbai alana gakkanaashin, haattaa ollaappe duuqqa duuqqada ehaada wonggiriyan tigada ushshaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","I qoppidi yiido qofaa GODAI injjeyiiddi de7iyaakkonne eranau bitanee co77u giidi o xeellees. ");
INSERT INTO wal_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Gaameelati haattaa uyi simmin, bitanee ichchashu giraame bagga gidiya worqqa qalabatiyaanne, xeetanne tammu giraame gidiya naa77u worqqa sagaayota kessiis; ");
INSERT INTO wal_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","kessidi o, “Neeni o na7ee? Ane tau yoota; ne aawaa son nuuyyo aqiyoosi de7anee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Yaagin a, “Taani Baatu7eela na7iyo; Baatu7eeli Milkka Naakoorayyo yelido na7aa. ");
INSERT INTO wal_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nuugan gidiya galabainne bassoi de7ees; qassi intte aqanaukka sohoi de7ees” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Bitanee gulbbati GODAAYYO goinnidi, ");
INSERT INTO wal_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","hagaadan yaagiis; “Ta godaayyo kehiyoogaanne ammanettiyoogaa aggibeenna GODAI, ta godaa Abrahaama Xoossai galatetto! Taani yiishin, GODAI tana ta godaa dabbotu soo kaalettiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Na7iyaa woxxa baada, ba aayee son de7iya asaassi hanidabaa odaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribiqeeyyo Laabaana giyo ishai de7ees; Laabaani kare kiyidi, haattaa pulttuwaa matan de7iya bitaniyaakko woxxiis. ");
INSERT INTO wal_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Qalabatiyaanne ba michchee kushiyan de7iya sagaayota be7osaaranne Ribiqa bitanee bana giidobaa yootin siyosaara, kiyidi bitaniyaakko bi be7iis; bitanee gaameelatuura pulttuwaa matan eqqidaagaa demmiis. ");
INSERT INTO wal_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Demmidi a, “GODAI nena anjjidoogoo, haaya! Neeni hagan karen aissi eqqai? Taani neeyyo keettaanne gaameelatuyyookka sohuwaa giigissaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Yaagin bitanee soo geliis; Laabaani gaameelatu caanaa birshshiis; galabaanne bassuwaa gaameelatuyyo yeggiis. Tohuwaa meeccanau ayyoonne aara de7iya asatuyyo haattaa ehiis; ");
INSERT INTO wal_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","qumaikka a sintti aadhdhiis. SHin i, “Taani tana ehidabaa intteyyo yootennan de7aidda katta miikke” yaagiis. Yaagin Laabaani, “Yaakko yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hegaa gishshau i, “Taani Abrahaama ashkkaraa. ");
INSERT INTO wal_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","GODAI ta godaa keehi anjjin, i duretiis; dorssaa, miizzaa, biraa, worqqaa, attuma ashkkarata, macca ashkkarata, gaameelatanne hareta ayyo immiis. ");
INSERT INTO wal_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ta godaa keettaayyiyaa Saara ba ceegatettaa laittan ayyo attuma na7a yelaasu; yelin i baayyo de7iyaabaa ubbaa ayyo immiis. ");
INSERT INTO wal_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ta godai tana hagaadan caaqettiis; ‘Taani de7iyo Kanaane biittaa macca naatuppe ta na7aayyo machcho oichchoppa; ");
INSERT INTO wal_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","shin ta aawaa asaakko, ta zaretukko baada, ta na7aayyo machcho oichcha’ yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Yaagin taani ta godaa, ‘Na7iyaa tanaara yaanau dosennan aggikko shin?’ yaagaas. ");
INSERT INTO wal_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Yaagin i, ‘GODAI, taani a sinttan hemettidoogee nenaara ba kiitanchchaa kiittana; neeni ta na7aayyo ta aawaa asaappe, ta zaretuppe machcho demmana mala, ne biyoobaakka injjeyana. ");
INSERT INTO wal_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Neeni ta zaretukko bin, eti neeyyo o immennan ixxikko, he wode neeyyo caaqoi gometenna’ yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Taani hachchi ha pulttuwaakko yiido wode yaagaas; ‘GODAU, ta godaa Abrahaama Xoossau, ne shene gidikko, taani biyo yohuwaa injjeya. ");
INSERT INTO wal_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Be7a; taani ha pulttuwaa matan eqqais; geela7o issinniyaa haattaa tikkanau yiikko, taani o, “Tana ne otuwaappe guutta haattaa ushsharkkii!” yaagana. ");
INSERT INTO wal_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Yaagin a tana, “Eeno uya; qassi ne gaameelatuyyookka taani haattaa duuqqana” yaagiyaara, GODAI ta godaa na7aayyo dooridooro gidu’ yaagaas. ");
INSERT INTO wal_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Taani ta wozanan woossiyoogaa zaarennan de7ishin, Ribiqa ba otuwaa tookka ekkada, puttu gaasu; pulttuwaa duge wodhdhada haattaa duuqqaasu; taani o, ‘Tana haattaa ushsharkkii’ yaagaas. ");
INSERT INTO wal_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Yaagin a eesuwan ba hashiyaappe otuwaa wottada, ‘Hekko uya; qassi taani ne gaameelata ushshana’ yaagaasu. Yaagin taani uyaas; qassi ta gaameelata a ushshaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Taani o, ‘Neeni o na7ii?’ yaagaas. “Yaagin a, ‘Taani Baatu7eela na7iyo; Baatu7eeli, Milkka Naakoorayyo yelido na7aa’ yaagaasu. “Yaagin taani iyyo qalabatiyaa aattaas; i kushiyankka sagaayota wottaas. ");
INSERT INTO wal_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hegaappe guyyiyan taani gulbbatada, GODAAYYO goinnaas; taani GODAA, ta godaa Abrahaama Xoossaa, ta godaa ishaa na7aa na7iyo a na7aassi ekkanau tana likke ogiyaa kaalettidaagaa galatais. ");
INSERT INTO wal_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ha77ikka intte ta godaayyo kehanabaanne ammanettanabaa gidikko, taayyo yootite; gidana xayikkonne yootite; hegaappe sinttan taani hananabaa erana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laabaaninne Baatu7eeli zaaridi yaagidosona; “Ha yohoi GODAAPPE yiis; nuuni neeyyo yaa haa gaanau danddayokko. ");
INSERT INTO wal_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribiqo hanno be7a; ekkada efa; efin GODAI giidoogaadan ne godaa na7aassi machcho gidu bayin” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abrahaama ashkkarai eti giyoobaa siyido wode, sa7an gulbbatidi GODAAYYO goinniis. ");
INSERT INTO wal_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ashkkarai biraa alleequwaanne worqqaa alleequwaa, maayuwaakka kessidi, Ribiqiyyo immiis; qassi al77o miishshata i ishaayyoonne i aayeeyyo immiis. ");
INSERT INTO wal_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hegaappe guyyiyan, inne aara de7iyaageeti miidosonanne uyidosona; yaatidi yan aqidosona; eti guuran denddin, “Tana ta godaakko yeddite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yaagin i ishainne i aayyiyaa, “Na7iyaa issi tammu gallassa keenaa nunaara takku; hegaappe guyyiyan a baana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","SHin i, “GODAI taani yiidobaa injjeyirggin, intte tana gam77issoppite; taani ta godaakko baana mala tana moissite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yaagin eti, “Na7iyo xeesidi ane o oichchoos” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Yaagidi Ribiqo xeesidi, “Ha bitaniyaara buutee?” yaagidi oichchidosona. Oichchin a, “Ee; taani baana” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Yaanin eti bantta michchiyo Ribiqo, o dichchiyaariira, Abrahaama ashkkaraaranne a asatuura moissidosona. ");
INSERT INTO wal_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Eti Ribiqo, “Nu michchee Ribiqee, sha7aappe sha7aa gakkanau coratta. Ne zareti bantta morkketu katamata laattona” yaagidi anjjidosona. ");
INSERT INTO wal_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hegaappe guyyiyan, Ribiqanne i danggiriixeti denddidi, gaameelata toggidi, bitaniyaara biidosona. Yaatin ashkkarai Ribiqo ekkidi biis. ");
INSERT INTO wal_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","He wode Yisaaqi, “Tana Be7iya De7o Xoossaa Pulttuwaa” giyo pulttuwaa mati biidi, Neegeeba bazzuwan de7ees. ");
INSERT INTO wal_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Issi gallassi omarssi Yisaaqi ba wozanan qoppiiddi dembbaa kiyidi yuuyees; yuuyiiddi i xoqqu giidi xeelliyo wode, gaameelati yiyaageeta be7iis. ");
INSERT INTO wal_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribiqakka xoqqu gaada xeelliyo wode, Yisaaqa be7aasu; be7ada gaameelaappe wodhdhaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Wodhdhada ashkkaraa, “Ha nunaara gaittanau dembbaara yiya bitanee oonee?” yaagaasu. Yaagin ashkkarai, “I ta godaattennee” yaagiis. Yaagin a ba shaashiyaa ekkada gullettaasu. ");
INSERT INTO wal_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Qassi ashkkarai ba oottidobaa ubbaa Yisaaqassi yootiis. ");
INSERT INTO wal_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yisaaqi Ribiqo ba aayee Saari dunkkaaniyaa efiis. Efiidi o machchiis; akka ayyo machcho gidaasu. Yaatin i o siiqiisinne ba aayee haiquwan kayyottiyoogaappe minettiis. ");
INSERT INTO wal_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Qassi Abrahaami Qaxuro geetettiya hara machchiyo ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","A Ziimiraana, Yoqishaana, Madaana, Midiyaama, Yishibaaqanne SHuha ayyo yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoqishaani Saabanne Dadaana yeliis. Dadaani Ashooreta, Lexuushetanne Le7aamata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyaama naati Eefa, Efeera, Hanooka, Abiidaa7anne Elddaa7a. Hageeti ubbaikka Qaxuri naata. ");
INSERT INTO wal_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahaami babaa ubbaa Yisaaqa laatissiis. ");
INSERT INTO wal_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","SHin i biron paxa de7iiddi, ba kaadumatatuppe yelido naatussi bau de7iyaabaappe woitiis. Woitidi ba na7aa Yisaaqappe eta shaakkidi, arshsho bagga biittau yeddiis. ");
INSERT INTO wal_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahaami muleera issi xeetanne laappun tammanne ichchashu laittaa de7iis. ");
INSERT INTO wal_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahaami daro wodiyaa de7idi, lo77o ceeggidi haiqqiis; haiqqidi ba maizzan gaittiis. ");
INSERT INTO wal_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A naati Yisaaqinne Isimaa7eeli a Maakipheela giyo gonggolo duufuwan moogidosona; he gonggoloi Mamire matan, Hiitiyaa Xoohaara na7aa Efiroona gadiyan de7ees. ");
INSERT INTO wal_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Hegeenne Abrahaami Hiitetuppe shammido gadiyaa. Abrahaami ba keettaayyiyaa Saara moogettidosan moogettiis. ");
INSERT INTO wal_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahaami haiqqidoogaappe guyyiyan, Xoossai a na7aa Yisaaqa anjjiis. He wode Yisaaqi, “Tana Be7iya De7o Xoossaa Pulttuwaa” giyo pulttuwaa matan de7ees. ");
INSERT INTO wal_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saari ailliyaa, Gibxxeppe yiida Aggaara, Abrahaamayyo yelido na7aa Isimaa7eela yeletai hagaappe kaallidi xaafettidaagaa. ");
INSERT INTO wal_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isimaa7eela naati bantta sunttaaninne bantta yeletaa maaran hageeta; hegeetinne: Nabaayoota, Qeedaara, Adibi7eela, Mibssaama, ");
INSERT INTO wal_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishimaa7a, Duuma, Maasa, ");
INSERT INTO wal_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaada, Teema, Yixura, Naafiishanne Qeedima. ");
INSERT INTO wal_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isimaa7eela naati hageeta; eta sunttai eta moottaaninne de7iyo man77iyan hagaa. Eti bantta yarankka tammanne naa77u halaqata. ");
INSERT INTO wal_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimaa7eeli muleera xeetanne hasttamanne laappun laittaa de7idi, haiqqiis; haiqqidi ba maizzan gaittiis. ");
INSERT INTO wal_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isimaa7eela zareti Gibxxeppe awai mokkiyo baggan de7iya Hawiilappenne SHurappe gidduwan, Asoora efiya ogiyaa matan de7idosona. Eti bantta ishanttu ubbaara morkkiyan de7idosona. ");
INSERT INTO wal_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abrahaama na7aa Yisaaqa yeletai hagaappe kaallidi xaafettidaagaa. Abrahaami Yisaaqa yeliis. ");
INSERT INTO wal_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yisaaqau laittai oitamaa gidido wode, Ribiqo ekkiis; a Masphphexoomiyan de7iya Sooriyaa Baatu7eela na7iyoonne Sooriyaa Laabaana michchiyo. ");
INSERT INTO wal_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Yisaaqi ba keettaayyiyaa maine gidido gishshau, iyyo GODAA woossiis; woossin GODAI a woosaa siyiis. Yaatin a keettaayyiyaa Ribiqa shahaaraasu. ");
INSERT INTO wal_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","SHin i ulo giddon de7iya naati mentte gidi uttidi, issoi issuwaara sugettidosona; yaatin a, “Hagee tau aissi hanii?” yaagaasu. Hegaa gishshau GODAA oichchanau baasu. ");
INSERT INTO wal_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Bin GODAI iyyo, “Ne uluwan naa77u kawotettai de7ees; qassi ne giddon de7iya naa77u dere asati issoi issuwaappe shaahettana; issi dere asati hinkkootuppe minnana; qassi bairai kaaluwaayyo azazettana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","A yeliyo wodee gakkin, i uluwan mentte attuma naati de7oosona. ");
INSERT INTO wal_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Koiro yelettidaagee arssa; a bollaa ubbaa ikisee maayiis; hegaa gishshau eti a Eesawa giidi sunttidosona. ");
INSERT INTO wal_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hegaappe guyyiyan, a ishai yelettiis; yelettiiddi i ba kushiyan Eesawa ginddiyaa oiqqi uttiis; hegaa gishshau a Yaaqooba giidi sunttidosona. Ribiqa eta yelido wode, Yisaaqau usuppun tammu laitta gidiis. ");
INSERT INTO wal_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Naati diccidosona; Eesawi shankkaa hiillaa eriya bazzo asa gidiis; shin Yaaqoobi dunkkaaniyan de7iya woppa asa gidiis. ");
INSERT INTO wal_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisaaqi Eesawa siiqiis; aissi giikko, i shankkatidobaappe maanau dosiis; shin Ribiqa Yaaqooba siiqaasu. ");
INSERT INTO wal_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Issitoo Yaaqoobi woxiyaa kattishin, Eesawi namisai woridoogee, bazzoppe yiis. ");
INSERT INTO wal_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Eesawi Yaaqooba, “Tana ha zo7o woxiyaappe miza; tana namisai worees” yaagiis. (Hegaa gishshau qassi a sunttai Eedooma geetettiis.) ");
INSERT INTO wal_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaaqoobi a, “Koiro taayyo ne bairatettaa baizza” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yaagin Eesawi, “Be7a! Taani haiqqana hanais; ha bairatettan tau ai go77i de7ii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaagin Yaaqoobi zaaridi, “Ane taayyo koiro neeni caaqqa” yaagiis. Yaagin i caaqqiis; ba bairatettaanne Yaaqoobau baizziis. ");
INSERT INTO wal_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Baizzin Yaaqoobi Eesawassi buddeenaanne misiraa woxiyaa immiis; immin i miisinne uyiis; hegaappe guyyiyan denddidi biis. Eesawi ba bairatettaa hagaadan kariis. ");
INSERT INTO wal_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","He biittan kase Abrahaama wodiyan de7iya koshaa bolli hara koshai denddiis; yaatin Yisaaqi Pilisxxeema kawuwaa Abimelekakko Garaari biis. ");
INSERT INTO wal_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","GODAI Yisaaqayyo qonccidi hagaadan yaagiis; “Gibxxe biitti duge booppa; taani neeyyo yootido biittan de7a. ");
INSERT INTO wal_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ha biittan amaridaagaa takkashsha; taani nenaara gidana; nena anjjana; aissi giikko, ha biittaa ubbaa taani neeyyoonne ne zerettaayyo immana; taani ne aawaa Abrahaamayyo caaqqido caaquwaa minttana. ");
INSERT INTO wal_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ne zerettaa saluwaa xoolinttiyaadan darissana; ha biittaa ubbaa taani etayyo immana; sa7aa kawotetta ubbai ne zerettaa baggaara anjjettana. ");
INSERT INTO wal_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Aissi giikko, Abrahaami ta qaalaa siyiis; ta pirddatanne ta azazota, ta awaajotanne ta higgeta naagiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hegaa gishshau Yisaaqi Garaaran uttiis. ");
INSERT INTO wal_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","He biittaa asai Ribiqibaa denttidi Yisaaqa, “Hanna neeyyo aibee?” yaagidi oichchiis. Oichchin i, “Hanna taayyo michchiyo” yaagiis. Aissi giikko, i Ribiqa daro meranchcha gidiyo gishshau, “Taani, ‘A ta keettaayyiyo’ giikko, ha sohuwaa asai i gaasuwan tana woranaakkonne” yaagi qoppidi yayyiis. ");
INSERT INTO wal_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yisaaqi hegan daro wodiyaa de7idoogaappe guyyiyan, Pilisxxeema Kawoi Abimeleki maskkootiyaara duge xeellidi, Yisaaqi ba keettaayee Ribiqiira gaittishin be7iis. ");
INSERT INTO wal_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hegaa gishshau Abimeleki Yisaaqa xeesidi, “Hekko a tumu ne machchiyo! Neeni aissi, ‘A ta michchiyo’ gaadii?” yaagidi oichchiis. Oichchin Yisaaqi, “‘A ta keettaayyiyo’ giikko, i gaasuwan asai tana worana gaada gaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Yaagin Abimeleki, “Hagee neeni nu bollan oottidobi aibee? Ta asaappe issi asi ne keettaayeera aqi haliis shin; neeni nu bollan gomiyaa eha haladasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hegaa gishshau Abimeleki ba asaa ubbaa, “Ha bitaniyaa woikko a keettaayyiyo bochchiya ooninne tumu haiqqana” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yisaaqi he biittan kattaa zeridi, he laittankka xeetu kushiyaa cakkiis; aissi giikko, GODAI a anjjiis. ");
INSERT INTO wal_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I duretiis; i duriyaa mannana gakkanaassi ayyo aqoi dari dari biis. ");
INSERT INTO wal_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yisaaqassi dorssaa wudee, miizzaa wudeenne ashkkarati keehippe darido gishshau, Pilisxxeema asati a qanaatidosona. ");
INSERT INTO wal_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Hegaa gishshau, a aawaa Abrahaama wodiyan, a aawaa ashkkarati bookkido haatta olla ubbaa Pilisxxeema asati biittaa zaaridi baridosona. ");
INSERT INTO wal_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","He wode Abimeleki Yisaaqa, “Nuuppe shaahettada ba; neeni nuuppe aadhdhada minnadasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Yaagin Yisaaqi hegaappe denddidi, Garaara Wombbaa biidi yan uttiis. ");
INSERT INTO wal_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yisaaqi ba aawaa Abrahaama wodiyan bookettida haatta ollata, Abrahaami haiqqidoogaappe guyyiyan, Pilisxxeema asati baridoogeeta zaari bookki kessidi, a aawai sunttido sunttankka eta xeesiis. ");
INSERT INTO wal_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Yisaaqa ashkkarati wombban bookkidi, pulttiya haatta ollaa yan demmidosona. ");
INSERT INTO wal_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","SHin Garaara henttanchchati Yisaaqa henttanchchatuura, “Haattai nuugaa” yaagidi ooyettidosona. Eti aara palamettido gishshau, Yisaaqi he haatta ollaa, “Palamaa” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hegaappe guyyiyan, eti hara haatta ollaakka bookkidosona; shin eti he haattaa ollaa geedonkka ooyettidosona; hegaa gishshau i he haattaa ollaa “Morkketettaa” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hegaappe guuttaa zardda7idi, hara haatta ollaa bookissiis; a gaasuwan ooninne ooyettibeenna; “Xoossai ha77i nuuyyo aassiis; nuuni ha biittan corattana” giidi a, “Aaho sohuwaa” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Hegaappe denddidi, pude Berssaabehi biis. ");
INSERT INTO wal_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","He biido gallassi qammikka GODAI ayyo qonccidi a, “Taani ne aawaa Abrahaama Xoossaa; taani nenaara de7iyo gishshau, neeni yayyoppa; taani nena anjjana; ta ashkkaraa Abrahaama gishshau ne zerettaa taani corayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yaagin Yisaaqi hegan yarshshiyoosaa keexxidi, GODAA sunttaa xeesiis. Yan i ba dunkkaaniyaa toliis; qassi yan a ashkkarati haatta ollaa bookkidosona. ");
INSERT INTO wal_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hegaappe guyyiyan, Abimeleki bana zoriya Ahuuzatanne ba wotaaddaratu halaqaa Pikoola ekkidi, Garaarappe Yisaaqakko yiis. ");
INSERT INTO wal_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yisaaqi eta, “Intte kase tana ixxidi, intte biittaappe kessi yeddooho; ha77i qassi taakko ai ekkana yiidetii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Yaagin eti a, “GODAI nenaara de7iyoogaa nuuni qoncciyan be7ida. Hegaa gishshau caaqo maachchai nu giddooninne ne giddon de7ana koshshees yaagoos. Nuuni nena bochchibookko; shin nuuni neeyyo kehatetta xalaalaa oottidi, nena sarotettan moissi yeddida. Hegaadankka neeni nu bolli iitabaa oottenna mala, ane nenaara maachchaa maacettoos. Ha77i neeni GODAI anjjidoogaa” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","He wode Yisaaqi etau gibiraa giigissin, miidosonanne uyidosona. ");
INSERT INTO wal_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wonttetta gallassi maallado guuran denddidi, eti issoi issuwaara caaqettidosona. Yisaaqi eta moissin, eti appe saro shaahettidi biidosona. ");
INSERT INTO wal_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","He gallassi Yisaaqa ashkkarati yiidi, bantta bookkido haatta ollaabaa ayyo odidosona; “Nuuni haattaa demmida” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I he haatta ollaa Saabehi giidi sunttiis; hegaa gishshau he katamaa sunttai hachchi gakkanaassi Berssaabehi geetettees. ");
INSERT INTO wal_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Eesawa laittai oitamaa gidiyo wode, Hiitiyaa Bi7eera na7iyo Yooditonne Hiitiyaa Eloona na7iyo Baasemaato machchiis. ");
INSERT INTO wal_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Eti Yisaaqanne Ribiqo azzanissiiddi de7idosona. ");
INSERT INTO wal_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yisaaqi cimin, a aifee xeelaa ixxido wode, ba bairatiya na7aa Eesawa xeesidi a, “Ta na7au” yaagiis. Yaagin i, “Yee” giidi koyiis. ");
INSERT INTO wal_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Koyin i, “Be7a, ha77i taani ceeggaas; taani haiqqana gallassaa erikke. ");
INSERT INTO wal_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yaaniyo gishshau, ha77i ne shankkatiyo wonddafiyaanne zubbiyaa ekkada, bazzo ba; baada do7aa taayyo shankkatada, asho ekkada ya. ");
INSERT INTO wal_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mal77o qumaa, taani dosiyoogaa kattada aatta; hegeenne taani haiqqanaappe kase nena anjjanaassa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ribiqa Yisaaqi ba na7aa Eesawayyo yootiyo wode siyausu. Eesawi do7aa shankkatidi ehaanau bazzo biidoogaappe guyyiyan, ");
INSERT INTO wal_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribiqa ba na7aa Yaaqooba, “Ne aawai ne ishaa Eesawa, ");
INSERT INTO wal_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Do7aa shankkata ehaada, taayyo mal77o qumaa taani maanau katta; hegeenne taani haiqqanaappe kasetada, GODAA sinttan nena anjjanaassa’ yaagishin taani siyaas. ");
INSERT INTO wal_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ta na7au, ha77i taani nena azaziyoobaa loittada siya. ");
INSERT INTO wal_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Wudiyaa garssi baada, naa77u anqqara deeshsha marata tau ekkada ya; ehin taani ne aawaayyo mal77o qumaa i dosiyoogaadan kattana. ");
INSERT INTO wal_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ne aawai miidi haiqqennan kasetidi nena anjjana mala, assi aattaasa” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","SHin Yaaqoobi ba aayyiyo Ribiqo, “Ta ishaa Eesawa bollan ikisee de7ees; shin ta bollai liiqo. ");
INSERT INTO wal_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ta aawai tana oiqqi be7ikko shin? Taani a cimmiyoobaa ayyo milatikko, taani anjjuwaa gishshaa qanggettaa ta bolli ehaanaakkonne” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yaagin a aayyiyaa a, “Ta na7au, he qanggettai tana gakko. Taani neeyyo yootiyoogaa ootta; baada deeshsha marata tau ekkada ya” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Biidi ehiidi ba aayeeyyo immiis; immin a aayyiyaa mal77o qumaa a aawai dosiyoogaadan kattaasu. ");
INSERT INTO wal_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hegaappe guyyiyan, Ribiqa son ba matan de7iya ba baira na7aa Eesawa maayuwaa lo77uwaa ehaada, ba kaalo na7aa Yaaqooba maizzaasu. ");
INSERT INTO wal_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Qassi he deeshshatu calaa a kushiyaanne a liiqo qooriyaa maizzaasu. ");
INSERT INTO wal_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Maizzada ba kattido mal77o qumaanne oittaa ba na7aa Yaaqooba kushiyan wottaasu. ");
INSERT INTO wal_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaatin i ba aawaakko biidi gelidi, “Ta aawau” yaagiis. Yaagin i, “Yee! Ta na7au, neeni oonee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaagin Yaaqoobi ba aawaa, “Taani ne baira na7aa Eesawa; neeni tana azazidoogaadan taani oottaas; suura; suura uttada, taani shankkaappe ehiidobaa ma; yaatada tana anjja” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yaagin Yisaaqi ba na7aa, “Ta na7au, waata eesuwan demmadii?” yaagidi oichchiis. Oichchin i, “GODAI ne Xoossai tana maaddiina” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yisaaqi Yaaqooba, “Ta na7au, neeni tumu ta na7aa Eesawakkonne taani oiqqa be7anau ane taakko shiiqa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaaqoobi ba aawaa Yisaaqakko shiiqin oiqqi be7idi, “Ha qaalai Yaaqooba qaalaa; shin kushee Eesawa kushiyaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","A kushee a ishaa Eesawa kushiyaadan ikisiyaara de7iyo gishshau, eribeenna; i erennan a anjjiis. ");
INSERT INTO wal_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","A, “Tumu neeni ta na7aa Eesawee?” yaagidi oichchiis. Yaagin i, “Ee, tanattennee” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yaagin i, “Ta na7au, taani neeni shankkatidobaa maanau haa aatta; maada taani nena anjjana” yaagiis. Yaaqoobi aattin, i miis; qassi i ayyo woine eessaa ehin uyiis. ");
INSERT INTO wal_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hegaappe guyyiyan a aawaa Yisaaqi, “Ta na7au, haaya; shiiqada tana yera” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yaaqoobi shiiqidi a yeriis; Yisaaqi a maayuwaa singgi siyiiddi, hagaadan yaagidi anjjiis; “Ta na7aa peenoi GODAI anjjido goshshaadan sawees. ");
INSERT INTO wal_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Xoossai saluwaa akkaanne sa7aa shicaa, kattaanne ooratta woine eessaa koridi neeyyo immo. ");
INSERT INTO wal_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kawotettati neeyyo haarettona; asati neeyyo gulbbatona. Neeni ne ishanttuyyo goda gida; ne aayee zareti neeyyo gulbbatona. Nena qanggiyaagee qanggettidaagaa gido; nena anjjiyaagee anjjettidaagaa gido” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisaaqi Yaaqooba anjji wurssidoogaappe guyyiyan, Yaaqoobi ba aawaa Yisaaqa sinttappe kiyaanne Eesawi shankkaappe puttu giis. ");
INSERT INTO wal_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ikka qassi mal77o qumaa kattidi, ba aawaayyo aattiis. Aattidi a, “Ta aawau, suura; suura uttada, taani shankkatidobaappe ma; yaatada tana anjja” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yaagin a aawaa Yisaaqi a, “Neeni oonee?” yaagidi oichchiis. Oichchin i, “Taani ne na7aa, ne baira na7aa Eesawa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yisaaqi dagammidi kokkoriiddi; “Yaatin do7aa shankkatidoogaa ekkidi taayyo aattidaagee oonee? Taani ha77i neeni yaana sinttan maada, a anjjaichchaas; tumukka i anjjettidaagaa gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Eesawi ba aawaa qaalaa siyido wode, ba qaalaa xoqqu oottidi, daro yibbaata yeehuwaa yeekkiiddi ba aawaa, “Tana anjja; ta aawau, tanakka anjja!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","SHin i, “Ne ishai yiidi cimmidi, ne anjjuwaa ekkirggiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Eesawi, “A eridi Yaaqooba sunttida; i tana cimmishin, hagee naa77antto; i ta bairatettaa ekkiis; qassi ha77i ta anjjuwaa ekkiis” yaagiis. Qassi i, “Neeni taayyo anjjuwaappe aibanne ashshabeikkii?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Oichchin Yisaaqi Eesawa, “Taani a neeyyo goda oottaas; a ishantta ubbaakka a ashkkarata oottaas; qassi taani kattaaninne ooratta woine eessan a minttaas. Yaatin, ta na7au, neeyyo taani ai oottoo?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eesawi ba aawaa, “Ta aawau, neeyyo issi anjjo xalaalai de7ii? Ta aawau, tanakka qassi anjja” yaagiis. Hegaappe guyyiyan, Eesawi ba qaalaa xoqqu oottidi yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A aawaa Yisaaqi zaaridi, “Ne de7iyoosai ha sa7aa duretettaappe haakkana; saluwaa akkaikka neeyyo wodhdhenna; ");
INSERT INTO wal_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","neeni ne bisuwan aqana; neeni ne ishaayyo haarettana. SHin neeni aara eqettiyo wode, a qambbaraa ne morggiyaappe olana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yaaqooba a aawai anjjido gishshau, Eesawi ba uluwan a morkkiis; i ba wozanan, “Ta aawai haiqqana matiis; taani ayyo kayyotta simmada, ta ishaa Yaaqooba worana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","SHin Ribiqa ha ba baira na7aa Eesawa qaalaa siyido gishshau, ba kaalo na7aa Yaaqooba xeesissa ehaada hagaadan yaagaasu; “Ne ishai Eesawi nena woridi haluwaa kessanau halchchees. ");
INSERT INTO wal_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Hayyanaa ta na7au, taani neeyyo odiyoogaa ootta. Dendda! Denddada Kaaraanen de7iya ta ishaa Laabaanakko baqata! ");
INSERT INTO wal_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Yaatada ne ishaa hanqqoi dochchana gakkanaassi, amarida wodiyaa aara de7ashsha. ");
INSERT INTO wal_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ne ishai neeyyo hanqqettiyoogaa aggiyo wodenne, neeni a bolli oottidobaa i baliyo wode, taani kiittada nena yaappe ehiissana. Taani issi gallassi intte naa77aappe mela kiyana koyikke” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hegaappe guyyiyan Ribiqa Yisaaqa, “Eesawi ekkido Hiitetu macca naatu gaasuwan taani ta de7uwaa shenetaas; qassi Yaaqoobikka hageetu mala Hiitetu macca naatuppe machcho ekkikko, taani simmi haiqqanau koyais” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hegaa gishshau, Yisaaqi Yaaqooba xeesidi hagaadan anjjiisinne azaziis; “Kanaane biittaa macca naatuppe neeyyo machcho ekkoppa. ");
INSERT INTO wal_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Dendda! Denddada ne aayee aawaa Baatu7eelakko, Masphphexoomiyaa biitti ba; baada yaappe ne aayee ishaa Laabaana macca naatuppe issinno neeyyo machcho ekka. ");
INSERT INTO wal_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ubbaa Danddayiya Xoossai nena anjjo; i nena yeletisso; neeni issi dere asa keena gakkanaassi nena corisso. ");
INSERT INTO wal_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Neeni ha77i betetettan uttido ha biittaa nebaa oottana mala neeyyoonne ne zerettaayyo Xoossai Abrahaama anjjuwaa immo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yaagidi Yisaaqi Yaaqooba yeddiis; yeddin Yaaqoobi Masphphexoomiyaa biitti Laabaanakko biis. Laabaani Yaaqoobanne Eesawa yeliya aayee Ribiqi ishaanne Sooriyaa Baatu7eela na7aa. ");
INSERT INTO wal_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yisaaqi Yaaqooba anjjidoogaa, yaappe machcho ekkanau Masphphexoomiyaa biitti a yeddidoogaa, qassi i Yaaqooba anjjido wode, “Kanaane maccaasa ekkoppa” yaagidi azazidoogaanne, ");
INSERT INTO wal_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaaqoobi ba aawaayyoonne ba aayeeyyo azazettidi, Masphphexoomiyaa biitti biidoogaa Eesawi eriis. ");
INSERT INTO wal_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Eesawi hegan Kanaane biittaa maccaasi ba aawaa Yisaaqa ai keenaa iitiyaakko akeekiis. ");
INSERT INTO wal_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hegaa gishshau Eesawi Abrahaama na7aa Isimaa7eelakko biidi, a na7iyo Mahilaato ba keettaayetu bolli gujjidi ekkiis. A Nabaayoota michchiyo. ");
INSERT INTO wal_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaaqoobi Berssaabehappe Kaaraane baanau denddiis. ");
INSERT INTO wal_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I issi sohuwaa gakkishin awai wullin, yan qammaa aqiis. He sohuwan de7iya shuchchatuppe issuwaa ekkidi, ba huuphiyan borkkotidi he sohuwan xiskkiis. ");
INSERT INTO wal_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I aimo aimottiis; he aimuwan gayye issoi biittan eqqin, ayyo xeerai saluwaa gakkiyoogan, Xoossaa kiitanchchati gi77ishiininne wodhdhishin be7iis; ");
INSERT INTO wal_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","gayyiyaassi bolla xeeran GODAI eqqidi a, “Taani GODAA, ne aawaa Abrahaama Xoossaa, Yisaaqa Xoossaa. Ha neeni zin77ido biittaa neeyyoonne ne zerettaayyo immana; ");
INSERT INTO wal_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ne zerettai sa7aa shafiyaadan darana; neeni arggoora, arshshoora, huuphessaaranne tohossaara de7iya sohota gakkanau aakkana; sa7aa bollan de7iya asai ubbai ne baggaaranne ne zerettaa baggaara anjjettana. ");
INSERT INTO wal_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Taani nenaara de7ais; neeni biyoosa ubban taani nena naagana; qassi taani nena ha biitti guyye zaarada ehaana; taani neeyyo oottana giidoogaa oottana gakkanaassi nena yeggikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaaqoobi xiskkuwaappe beegottido wode, “GODAI tuma ha sohuwan de7ees; taani erabeikkeppe attin” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I yayyidi, “Ha sohoi aiba yashshii! Ha sohoi Xoossaa keettappe attin, ainne harasaa gidenna; hagee saluwaa pengge” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Wonttetta gallassi maallado guuran Yaaqoobi denddidi, ba borkkotido shuchchaa ekkidi, tuussadan essidi, Xoossaayyo dummayanau a bolli zaitiyaa tigiis. ");
INSERT INTO wal_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yaaqoobi he sohuwaa Beeteele giidi xeesiis. SHin he katamai hegaappe kase Looza geetettees. ");
INSERT INTO wal_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Yaaqoobi hagaadan yaagidi shiiqettiis; “Ta aawaa soo taani saro simmana mala Xoossai tanaara gidikko, taani biyo ha buussan tana naagikkonne tau miyo qumanne maayiyo maayo immikko, GODAI ta Xoossaa gidana; ");
INSERT INTO wal_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","taani tuussadan essido ha shuchchai Xoossaa keetta gidana. Neeni tau immiyoobaa ubbaappe tammaappe issuwaa taani neeyyo immana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hegaappe guyyiyan, Yaaqoobi denddidi biidi, arshsho bagga asatu biitti gakkiis. ");
INSERT INTO wal_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Gakkidi issi haattaa ollai dembban de7iyaagaa be7iis; heezzu dorssaa wudeti qassi he ollaa matan zin77idosona. Aissi giikko, wude ubbai haattaa uyiyoi he ollaappe. He haattaa ollaa doonan de7iya shuchchai gita. ");
INSERT INTO wal_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dorssaa wude ubbai hegan dagattido wode, he wudiyaa heemmiyaageeti haattaa ollaa doonaappe he shuchchaa gonddorssidi dorssaa ushshoosona. Ushshidi he shuchchaa ollaa doonan zaaridi wottoosona. ");
INSERT INTO wal_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaaqoobi eta, “Ta ishatoo, intte auppe yiidetii?” yaagidi oichchiis. Oichchin, “Nuuni Kaaraaneppe yiida” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yaagin i, “Naakoora na7aa na7aa Laabaana intte ereetiiyye?” yaagiis. Yaagin, “Ee, a eroos” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaaqoobi eta, “I lo77o de7ii?” yaagidi oichchiis. Oichchin, “Ee, lo77o; a na7iyo Raaheelo dorssaa ekkada yiyaaro hanno be7a” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaagin Yaaqoobi eta, “Be7ite; awai ha77i xoqqan de7ees; wudiyaa mehee soo shiiqiyo wodee biron gakkiichchibeenna; dorssaa ha77i ushshi efiidi, heemmite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","SHin eti, “Wude ubbai shiiqana gakkanaassinne, shuchchaa haatta ollaa doonaappe gonddorssana gakkanaassi, nuuni ushshanau danddayokko. Hegaappe guyyiyan, nuuni dorssaa ushshana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","I biron haasayishin, Laabaana na7iyaa Raaheela ba aawaa dorssata laagga ekkada gakkaasu; aissi giikko, a dorssa henttanchchiyo. ");
INSERT INTO wal_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaaqoobi ba aayee ishaa Laabaana na7iyo Raaheelo be7ido wodenne, ba aayee ishaa Laabaana dorssaa be7ido wode, biidi ollaa doonaappe shuchchaa gonddorssiis; gonddorssidi ba aayee ishaa dorssata haattaa ushshiis. ");
INSERT INTO wal_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yaaqoobi Raaheelo yeridi, ufaissau ba qaalaa xoqqissidi yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yaaqoobi iyyo aawaa dabbonne Ribiqee na7aa gidiyoogaa Raaheeliyyo yootiis. Hegaa gishshau a woxxa baada ba aawaayyo yootaasu. ");
INSERT INTO wal_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laabaani ba michchee na7aa Yaaqooba woriyaa siyidosaarakka, aara gaittanau woxxiis. A idimmi yeridi, ba soo efiis. Yan Yaaqoobi hanidabaa ubbaa Laabaanayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Yootin Laabaani a, “Neeni tumu ta ashonne ta suutta” yaagiis. Yaaqoobi aara issi agina kumettaa uttiis. ");
INSERT INTO wal_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Hegaappe guyyiyan Laabaani a, “Neeni taayyo dabbo gidido gishshau, tau coo mela oottuuteeyye? Ane neeyyo ai qanxxanau bessiyaakko taayyo yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laabaanayyo naa77u macca naati de7oosona; bairee sunttai Liyo, kaaleegee Raaheelo. ");
INSERT INTO wal_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liya aifiyaara cuca; shin Raaheela yallisanne puulanchcha. ");
INSERT INTO wal_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaaqoobi Raaheelo siiqidi a, “Taani ne kaalo na7ee Raaheeli gishshau neeyyo laappun laittaa oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Yaagin Laabaani, “O hara asau immanaappe neeyyo immiyoogee lo77o; neeni tanaara hagan de7a” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hegaa gishshau Yaaqoobi Raaheelo ekkanau laappun laittaa oottiis; shin i o siiqiyo gishshau, ayyo amarida gallassa milatiis. ");
INSERT INTO wal_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hegaappe guyyiyan Yaaqoobi Laabaana, “Ta machchiyo tau imma; ta wodeenne polettiis; taani o ekkanau koyais” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hegaa gishshau Laabaani hegan de7iya asaa ubbaa xeesidi, bullachchaa kessiis. ");
INSERT INTO wal_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","SHin sa7ai qammin, i ba na7iyo Liyo efiidi Yaaqoobau immiis. Immin Yaaqoobi o ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Qassi Laabaani ba ashkkariyo Zilppo ba na7ee Liyissi danggiriixe gidanaadan immiis. ");
INSERT INTO wal_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sa7ai wonttin xeelliyo wode, hekko Liyo! Yaanin Yaaqoobi Laabaana, “Hagee neeni ta bolli oottidoogee aibee? Taani neeyyo oottidoi Raaheeli gishshassa gidenneeyye? Tana aissi cimmadii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Yaagin Laabaani a, “Nu biittan bairiyaa de7ishin, kaaliyo azinau immiyoogee woga gidenna. ");
INSERT INTO wal_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","He mishiratettaa saaminttaa wurssa; qassi kaalotiyaarokka nuuni neeyyo immana; hegaappe guyyiyan, hara laappun laittaa taayyo oottaasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaaqoobi hegaadan hanidi he saaminttaa wurssiis; hegaappe guyyiyan, Laabaani ba na7iyo Raaheelo ayyo immiis. ");
INSERT INTO wal_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Qassi Laabaani ba ashkkariyo Baalo ba na7ee Raaheelissi danggiriixe gidanaadan immiis. ");
INSERT INTO wal_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaaqoobi Raaheelokka ekkiis. Raaheelo Liyippe aattidi siiqiis. Hara laappun laittaa Laabaanayyo oottiis. ");
INSERT INTO wal_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","GODAI Liya siiqettabeennaagaa be7idi, iyyo yeliyo uluwaa dooyiis; shin Raaheela maine. ");
INSERT INTO wal_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liya shahaarada attuma na7aa yelaasu. A sunttaanne Roobeela sunttaasu; aissi giikko a, “GODAI ta metuwaa be7iis; ha77i tumu tana ta azinai siiqana” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A haranttuwaakka shahaarada attuma na7aa yelaasu. Yelada a, “GODAI taani siiqettabeennaagaa siyido gishshau, taayyo hagaakka gujjiis” yaagada, a Simoona sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A haranttuwaakka shahaarada attuma na7aa yelaasu. Yelada a, “Taani ayyo heezzu attuma naata yelido gishshau, ta azinai ha77i tanaara waaxettana” yaagada, a Leewa sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A haranttuwaakka shahaarada attuma na7aa yelaasu. Yelada a, “Hachchiigan taani GODAA galatana” yaagaasu. Hegaa gishshau a Yihudaa sunttaasu. Hegaappe guyyiyan yeluwaa essaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raaheela Yaaqoobau naata yelabeennaagaa be7ido wode, ba michchiyo qanaataasu; hegaa gishshau Yaaqooba, “Tau naata imma; hegee xayikko, taani haiqqana” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaagin Yaaqoobi Raaheelo hanqqettidi, “Tana neeyyo yelo diggida Xoossaa gaadiiyye?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Yaagin a, “Ta danggiriixiyo Baalo hinno be7a; a ta gishshaa yelana mala neeni o ekka; yaatobare i baggaara taanikka na7aayo gidana” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ba danggiriixiyo Baalo machcho ootti ekkana mala, ayyo immaasu; immin Yaaqoobi o ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Baala shahaarada attuma na7aa Yaaqoobau yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Yaatin Raaheela, “Xoossai taassi daannatiis; ta woosaakka siyidi, tau attuma na7a immiis” yaagaasu. Hegaa gishshau a Daana sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Raaheeli danggiriixiyaa Baala haranttuwaa shahaarada, Yaaqoobayyo naa77antto attuma na7aa yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Yelin Raaheela, “Taani ta michcheera wolqqaama baaxiyaa baaxetada xoonaas” yaagaasu. Hegaa gishshau a Nifttaaleema sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liya baayyo yeloi eqqidoogaa be7ada, ba danggiriixiyo Zilppo efaada Yaaqoobi o machchana mala immaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Liyi danggiriixiyaa Zilppa attuma na7aa Yaaqoobau yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liya, “Laa hagee aiba lo77o qaadee!” yaagaasu. Hegaa gishshau Gaada sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Liyi danggiriixiyaa Zilppa Yaaqoobau naa77antto attuma na7aa yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Yelin Liya, “Taani ai keenaa ufaittiyaanaashsha! Maccaasai tana ufaittiyaaro gaana” yaagaasu. Hegaa gishshau a Aseera sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Gisttiyaa cakkiyo aginan Roobeeli gade biidi, inkkoyiyaa giyo timaatime milatiya teeraa demmidi, ba aayee Liyissi ehiis. Raaheela Liyo, “Ne na7aa inkkoyiyaappe taayyo imma” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","SHin Liya, “Ta azinaa neeni wotta ekkidoogee gidennan ixxin, qassi ta na7aa inkkoyiyaa ekkuutee?” yaagaasu. Yaagin Raaheela, “Yaanikko, ne na7aa inkkoyiyaa gishshau Yaaqoobi hachchi qammaa nenaara aqo” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","He gallassa omarssi Yaaqoobi bazzoppe yiido wode, Liya a mokkanau kiyada a, “Neeni tanaara aqana koshshees; aissi giikko, taani ta na7aa inkkoyiyan nena kerau ekkaichchaas” yaagaasu. Hegaa gishshau i he gallassa qammi iira aqiis. ");
INSERT INTO wal_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Xoossai Liyi woosaa siyiis; siyin a shahaarada, ichchashantta attuma na7aa Yaaqoobau yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Yelin Liya, “Taani ta danggiriixiyo ta azinaassi immido gishshau, Xoossai hegaa keraa taayyo qanxxiis” yaagaasu. Hegaa gishshau a Yisaakoora sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liya haranttuwaakka shahaarada, usuppuntta attuma na7aa Yaaqoobau yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Liya, “Xoossai tau al77o imotaa immiis; taani ta azinaayyo usuppun naata yelido gishshau, ha77i i tana bonchchana” yaagaasu. Hegaa gishshau a Zaabiloona sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hegaappe guyyiyan issi macca na7iyo yelaasu; yelada o Diino sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Xoossai Raaheelo hassayiis; i woosaa siyidi i yeliyo uluwaa dooyiis. ");
INSERT INTO wal_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","A shahaarada attuma na7aa yelaasu; yelada, “Xoossai ta yeellaa qucciis. ");
INSERT INTO wal_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","GODAI tau hara attuma na7akka gujjeerenneeshsha” yaagaasu. Hegaa gishshau a Yooseefa sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raaheela Yooseefa yelidoogaappe guyyiyan, Yaaqoobi Laabaana, “Taani ta aawaa biitti simmana mala, tana moissa. ");
INSERT INTO wal_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Taani eta gishshau neeyyo oottido ta maccaasatanne ta naata hamma; taani baana; aissi giikko, taani neeyyo ai keena ooso oottidaakko neeni eraasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","SHin Laabaani a, “Taani neeyyo issibaa odais; GODAI ne gaasuwan tana anjjidoogaa taani be7aas. ");
INSERT INTO wal_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ne damoozaa tau oda; taani neeyyo a qanxxana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaagin Yaaqoobi, “Taani neeyyo waata oottidaakko, ne meheekka waani yelettidaakko neeni eraasa. ");
INSERT INTO wal_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Taani yaanaappe kase neeyyo de7iya guuttai ha77i keehi dariis; GODAI nena taani aadhdhidosan ubban anjjiis. SHin ha77i, taani ta so asau oottanai audee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Yaagin Laabaani, “Taani neeyyo ai immoo?” yaagidi a oichchiis. Oichchin Yaaqoobi, “Tau ainne immoppa; shin neeni taayyo issibaa oottikko, taani ne wudiyaa qassikka heemmananne naagana. ");
INSERT INTO wal_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Taani hachchi ne wudiyaa ubbaa giddoora aadhdhana; hegan ne dorssaappe punccariyaa woikko gazzaa ubbaa, karetta dorssa mara ubbaanne deeshshaappe gazzaanne punccariyaa ubbaa taani shaakkana; eti ta damooza gidana. ");
INSERT INTO wal_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hegaa gishshau ta xillotettai neeni taayyo qanxxido damoozaa qoodanau sinttappe yiyo wode, taayyo markkattana; ta deeshshaappe gazza woikko punccare gidennabi woikko karetta gidenna ai dorssa marinne ta matan beettikko, wuuqettidabaadan qoodettana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Yaagin Laabaani, “Maayaas; neeni giidoogaadan gidobai” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","SHin he gallassan Laabaani kalaade woikko gazza gidida attuma deeshshaa ubbaa, punccare woikko gazza gidida macca deeshshaa ubbaa, bootta gidida ubbaanne karetta dorssa mara ubbaa kessidi, ba attuma naata henttiis. ");
INSERT INTO wal_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yaatidi he wudiyaara heezzu gallassa ogiyaa Yaaqoobappe haakkidi biis. SHin Yaaqoobi attida Laabaana wudiyaa heemmiis. ");
INSERT INTO wal_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaaqoobi deeshsha loomiyaappe, gumariyaappenne xanqqarssaappe qayye gatimaa kessidi, poquwaa poqqi poqqidi, giddo bootta zawaa qaaridi gazzayiis. ");
INSERT INTO wal_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Wudee haattaa uyanau yiyo soho ubban, wonggiriyan, wudiyaa sinttan poqqido gatimata wottiis. Orggiyau eqqidaageeti haattaa uyanau yiidi, ");
INSERT INTO wal_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","he gatimatu sinttan birasettidosona; birasettidi eti kalaade, punccarenne gazza marata yelidosona. ");
INSERT INTO wal_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yelin Yaaqoobi marata wudiyaappe shaakkidi dumma wottiis; attida wudiyaa kalaadenne karetta gidiya Laabaana mehiyaa sintti zaariis. Yaatidi baayyo wudiyaa dummayiis; Laabaana mehetuura eta gattibeenna. ");
INSERT INTO wal_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Gooba maccaageeti orggiyau eqqiyo wode audenne, eti he gatimatu matan birasettana mala, Yaaqoobi he gatimata haattaa wonggiriyan, mehetu sinttan wottees. ");
INSERT INTO wal_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","SHin meheti laafa gidikko, eta sinttan gatimata wottenna. Hegaa gishshau laafiya meheti Laabaanabaa gidin, goobiyaageeti Yaaqoobabaa gididosona. ");
INSERT INTO wal_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hagaadan hanidi, Yaaqoobi keehi daro duretidi, daro wudiyaa, macca ashkkaratanne attuma ashkkarata, daro gaameelatanne hareta haariis. ");
INSERT INTO wal_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaaqoobi Laabaana naati bana, “Yaaqoobi nu aawaabaa ubbaa ekkiichchiis; ha aquwaa ubbaa nu aawaabaappe demmiis” giyoogaa siyiis. ");
INSERT INTO wal_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaaqoobi Laabaana som77oi baayyo kaseegaa mala gidennaagaa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","He wode GODAI Yaaqooba, “Neeni ne aawatu biitti, ne dabbotukko guyye simma; taani nenaara gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaagin Yaaqoobi Raaheelonne Liyo ba wudee de7iyoosaa dembbaa yaana mala kiittidi xeesissiis. ");
INSERT INTO wal_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","I eta, “Intte aawaa som77oi taayyo kaseegaa mala gidennaagaa taani be7ais; shin ta aawaa Xoossai tanaara de7ees. ");
INSERT INTO wal_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Taani ta wolqqa ubban intte aawaayyo oottidoogaa intte ereeta; ");
INSERT INTO wal_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","shin intte aawai tana cimmidi, ta damoozaa tammutoo laammiis. Gidikkonne Xoossai tana i qohennaadan diggiis. ");
INSERT INTO wal_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","I, ‘Punccareti ne damooza gidana’ gin, wude ubbai punccariyaa yeliis; qassi i, ‘Kalaadeti ne damooza gidana’ gin, wude ubbai kalaadiyaa yeliis. ");
INSERT INTO wal_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Xoossai hagaadan intte aawaa mehiyaa wotti ekkidi tau immiis. ");
INSERT INTO wal_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Meheti orggiyau eqqiyo aginan, taani issi aimo aimottaas; he aimuwan taani xeelliyo wode, wudiyaa birassiya deeshsha orggeti kalaade, punccarenne gazza. ");
INSERT INTO wal_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Xoossaa kiitanchchai aimuwan tana, ‘Yaaqoobaa’ yaagiis; yaagin taani, ‘Yee’ yaagada koyaas. ");
INSERT INTO wal_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Koyin tana i, ‘Xoqqu gaada wudiyaa birassiya deeshsha orgge ubbaa kalaadiyaa, punccariyaanne gazzaa be7a; aissi giikko, Laabaani ne bolli oottiyoobaa ubbaa taani be7aas. ");
INSERT INTO wal_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Neeni essido shuchchaa tiyada, taayyo shiiqettido Beeteele Xoossai tana. Ha77i dendda! Denddada ha biittaappe kiya; kiyada guyye ne yeleta biitti simma’ yaagiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Hegaappe guyyiyan, Raaheelanne Liya hagaadan yaagidi zaaridosona; “Nu aawaabaappe nuna gakkanabi aibee? ");
INSERT INTO wal_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","I nuna allagadan xeellees gidennee? I nuna baizzi ekkiis; baizzidi ekkidobaakka mi xaissiis. ");
INSERT INTO wal_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Xoossai nu aawaappe wotti ekkido aqo ubbai tumukka nubaanne nu naatuba. Hegaa gishshau Xoossai neeyyo odidobaa ubbaa ootta” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Yaagin Yaaqoobi Kanaane biittan de7iya ba aawaa Yisaaqakko baanau denddiis; i ba naatanne ba keettaayeta gaameelaa togissiis; wude ubbaa baappe sinttaara laaggidi, Masphphexoomiyan de7iiddi i shiishshido aqo ubbaa ekkidi biis. ");
INSERT INTO wal_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laabaani ba dorssatu ikisiyaa qanxxanau biichchidaashin, Raaheela ba aawaa so misileta wuuqqaasu. ");
INSERT INTO wal_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Qassi Yaaqoobi Sooriyaa Laabaanayyo ba baqatiyoogaa odennan cimmiis. ");
INSERT INTO wal_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I baayyo de7iyaabaa ubbaa ekkidi baqatiis; baqatidi Efiraaxiisa SHaafaa pinnidi, Gala7aade giyo gezziyaakko simmidi biis. ");
INSERT INTO wal_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Heezzantta gallassan, Laabaani Yaaqoobi baqati biichchidoogaa siyiis. ");
INSERT INTO wal_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ba dabbota banaara ekkidi, laappun gallassa ogiyaa Yaaqooba geeduwaa kaalliiddi, Gala7aade gezziyan a gakkiis. ");
INSERT INTO wal_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","He wode Xoossai qammi Sooriyaa Laabaanakko aimuwan yiidi a, “Neeni Yaaqooba bolli iita gidin, keha gidin, ainne haasayennaadan nena era!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laabaani gakkiyo wode, Yaaqoobi Gala7aade gezziyan dunkkaanidi uttiis; qassi Laabaaninne a dabboti yan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Hegaappe guyyiyan Laabaani Yaaqooba, “Neeni hagaadan aissi oottadii? Neeni tana cimmada, ta macca naata olan omoodettidabaadan laaggada kessadasa. ");
INSERT INTO wal_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Neeni aissi qosan taappe kessa ekkada, tana cimmadii? Taani nena ufaissaaninne yettan, karaabiyaaninne diittan moissana mala taayyo aissi odabeikkii? ");
INSERT INTO wal_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Neeni harai atto, ta naatu naatanne ta macca naata taani yera ekkenna mala diggadasa. Neeni eeyyabaa oottadasa. ");
INSERT INTO wal_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Taani nena genanau tau wolqqai de7ees; shin ne aawaa Xoossai zino qammi tana, ‘Yaaqooba bolli iita gidin, keha gidin, ainne haasayennaadan nena era!’ yaagidi taayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ha77i gidikkonne, neeni ne aawaa soo baanau keehi laamotido gishshau kiyadasa. SHin ta so misileta neeni aissi wuuqqadii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaaqoobi Laabaana, “Neeni ne naata taappe wolqqan wotta ekkanaakkonne gaada qoppido gishshaunne yayyido gishshau, hagaadan oottaas. ");
INSERT INTO wal_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","SHin ne so misileta oiqqida asa oonanne neeni demmikko, he urai siifetto! Nebaa gididabi ta matan beettikko, nu dabbotu sinttan koya; koyada, nebaa gidikko ekka” yaagiis; aissi giikko, Yaaqoobi Raaheela he so misileta wuuqqidoogaa eribeenna. ");
INSERT INTO wal_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Hegaa gishshau Laabaani Yaaqooba dunkkaane giddo, Liyi dunkkaane giddonne naa77u kaadumatatu dunkkaane giddo geliis; shin ainne demmibeenna. Liyi dunkkaaniyaappe kiyidi, Raaheeli dunkkaaniyaa geliis. ");
INSERT INTO wal_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raaheela so misileta ekkada, gaameelaa kooraa garssan qosada, a bolli uttaasu. Laabaani dunkkaaniyan de7iyaabaa ubbaa patipannidi koyiis; shin ainne demmibeenna. ");
INSERT INTO wal_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raaheela ba aawaa, “Ta godau, tana hanqqettoppa; taani neeyyo eqqana danddayikke; taayyo kushe qitai yi uttiis” yaagaasu. I koyiis; shin so misileta demmibeenna. ");
INSERT INTO wal_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaaqoobi Laabaana hanqqettidi woqqasiis; Yaaqoobi Laabaana, “Taani ai mooridanaa? Hagaa neeni tana kaallanau, taani oottido nagari aibee? ");
INSERT INTO wal_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ha77i neeni ta miishsha ubbaa patipannada koyadasa; ne so miishshappe ai demmadii? Eti nu naa77aa gidduwan pirddana mala, ta dabbotu sinttaaninne ne dabbotu sinttan hagan wotta. ");
INSERT INTO wal_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Taani nenaara laatamu laittaa kumettaa de7aas; ne dorssaikka ne deeshshaikka aucayibeenna; woikko ne wudiyaappe galssaa mabeikke. ");
INSERT INTO wal_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Do7ai menttidoogaanne neeyyo ehabeikke; shin hegaa tanan qoodaas. Gallassi wuuqettidabaa woikko qammi wuuqettidabaa tana qanxxissadasa. ");
INSERT INTO wal_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Gallassa suuloi, qamma kinchchoi tana qohiis; xiskkoi taappe xayiis. ");
INSERT INTO wal_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Taani hagaadan ne son laatamu laittaa de7aas; tammanne oiddu laittaa ne naa77u macca naatu gishshaunne usuppun laittaa ne wudiyaa gishshau neeyyo oottaidda de7aas; shin neeni ta damoozaa tammutoo laammadasa. ");
INSERT INTO wal_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ta aawaa Xoossai, Abrahaama Xoossai, Yisaaqi Yayyidoogee tanaara gidibeennabaa gidiyaakko, siree bainnan neeni tana mela kushe kessa yeddadasa; shin Xoossai ta tuggaanne ta kushiyaa oosuwaa be7idi, zino qammi nena seeriis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yaagin Laabaani Yaaqooba, “Maccaasati ta macca naata; naatikka ta naata; wudeekka ta wudiyaa; neeni be7iyo ubbai taagaa. Hachchi ha macca naatu taageetu bollinne eti yelido naatu bolli ai oottanau danddayiyaanaa? ");
INSERT INTO wal_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ha77i haaya; neeninne taani maachchaa maacettoos; hegee neeppenne taappe gidduwan markka gido” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hegaa gishshau Yaaqoobi issi shuchchaa ekkidi tuussadan essiis. ");
INSERT INTO wal_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Essidi i ba dabbota, “SHuchchaa shiishshite” yaagiis; yaagin eti shuchchaa shiishshidi keelidosona; he keelaa lanqqen miidosona. ");
INSERT INTO wal_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laabaani he keelaa, Yigaari-Sahaaduta giidi sunttiis; qassi Yaaqoobi a Gal77eeda giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laabaani, “Ha keelai neeppenne taappe gidduwan hachchi markka” yaagiis. Hegaa gishshau a sunttai Gal77eeda geetettiis. ");
INSERT INTO wal_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Qassi i he shuchchaa tuussaa Mixiphpha giidi sunttiis; aissi giikko, Laabaani, “Nuuni issoi issuwaappe haakkidi de7iyo wode, GODAI ne gidduwaaninne ta gidduwan gididi naago. ");
INSERT INTO wal_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Neeni ta macca naata naaqqikko, woikko neeni ta macca naatu bolli hara maccaasata ekkikko, nunaara ha77i ooninne bainnabaa gidikkonne ne gidduwaaninne ta gidduwan Xoossai markka gidiyoogaa hassaya” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laabaani qassikka Yaaqooba, “Keelettida shuchchai hageeho; qassi taani ne gidduwaaninne ta gidduwan essido shuchchaa tuussai hageeho. ");
INSERT INTO wal_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Taani ha keelaappe nena genanau neekko kanttennaadan, neenikka tana genanau ha keelaappenne ha shuchchaa tuussaappe kanttennaadan, ha keelainne ha shuchchaa tuussai markka. ");
INSERT INTO wal_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahaama Xoossai, Naakoora Xoossai, eta aawaa Xoossai, nu gidduwan i pirddo” yaagiis. Yaagin Yaaqoobi ba aawaa Yisaaqi Yayyidoogaa sunttan caaqqiis. ");
INSERT INTO wal_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaaqoobi deriyaa bollan yarshshuwaa yarshshiis; ba dabbotakka qumaa maanau xeesiis. Eti miidi deriyaa bollan aqidosona. ");
INSERT INTO wal_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Wonttetta gallassi guuran Laabaani denddidi, ba naatu naatanne ba macca naata yeriis; qassi eta anjjiis. Anjjidi, ba soo simmiis. ");
INSERT INTO wal_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaaqoobi denddidi ba ogiyaa biishin, Xoossaa kiitanchchati aara gaittidosona. ");
INSERT INTO wal_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yaaqoobi eta be7ido wode, “Hagee Xoossai aqiyoosaa” yaagidi, he sohuwaa Maahinaima giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaaqoobi Se7iira giyoosan, Eedooma biittan de7iya ba ishaa Eesawakko kiitaa baappe sinttau kiittiis. ");
INSERT INTO wal_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I eta hagaadan yaagidi azaziis; “Intte ta godaa Eesawayyo gaanabai hagaa; ‘Ne ashkkarai Yaaqoobi, “Taani Laabaana matan de7aidda hanno gakkanaassi gam77aas. ");
INSERT INTO wal_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Taayyo miizzainne haree, dorssainne deeshshai, attuma ashkkaratinne macca ashkkarati de7oosona; ha77i taani ha kiitaa ta godaa sinttan nashettana mala kiittaas” yaagiis’ yaagite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kiitettidaageeti Yaaqoobakko simmidi a, “Nuuni ne ishaa Eesawakko biida; ha77i i qassi nenaara gaittanau yees; aaranne oiddu xeetu asai de7ees” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaagin Yaaqoobi yayyidi batibatiis; banaara de7iya asaa naa77u citan shaakkiis; qassi ba dorssaa, deeshshaa, miizzaanne gaameelaa naa77u citan shaakkiis. ");
INSERT INTO wal_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I, “Eesawi yiidi issi citaa oliyaabaa gidikko, attida citai kessi ekkikkonne” yaagidi qoppiis. ");
INSERT INTO wal_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","He wode Yaaqoobi hagaadan yaagidi woossiis; “Abeet GODAU, ta aawaa Abrahaama Xoossau, ta aawaa Yisaaqa Xoossau, tana, ‘Ne biitti, ne dabbotukko simma; taani neeyyo lo77obaa oottana’ giidaagoo, ");
INSERT INTO wal_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","neeni ne ashkkaraayyo oottido kehatettaunne tumatettau ubbau taani bessennaagaa. Taani ha Yorddaanoosa SHaafaa pinnido wode, taayyo issi xam77a xalaalai de7ees; shin ha77i taani naa77u cita gidaas. ");
INSERT INTO wal_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Taani nena woossais; ta ishaa Eesawa kushiyaappe tana ashsha; aissi giikko, i yiidi, tananne aayeta eta naatuura xaissanaakkonne gaada yayyaas. ");
INSERT INTO wal_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","SHin neeni tana, ‘Taani neeyyo tumu lo77obaa oottana; taani ne zerettaanne qoodanau danddayettenna abbaa shafiyaa keena oottana’ giidoogaa qoppa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","He gallassa qammi i yan aqiis; bau de7iyaabaa ubbaappe ba ishaa Eesawayyo immiyoobaa qoridi kessiis; ");
INSERT INTO wal_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","i kessidoogeeti naa77u xeetu macca deeshshatanne laatamu deeshsha orggeta, naa77u xeetu macca dorssatanne laatamu dorssa orggeta, hasttamu xanttiya gaameelata eta maratuura, oitamu macca miizzata, tammu korima boorata, laatamu macca haretanne tammu attuma hareta. ");
INSERT INTO wal_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hageeta wudiyan wudiyan shaakkidi, ba ashkkaratu kushiyan wottidi, ba ashkkarata, “Taappe sinttau biidi, wudiyaa wudiyaappe haahuwan haahuwan laaggite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Sinttan kaalettiyaagaa, “Ta ishai Eesawi nenaara gaittidi nena, ‘Neeni oossee? Neeni awa bai? Ne sinttan de7iya mehe ubbai oossee?’ yaagidi oichchiyaabaa gidikko, ");
INSERT INTO wal_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","neeni ayyo, ‘Hageeti ne ashkkaraa Yaaqoobassa; eti ta godaa Eesawayyo immanau yeddidoogeeta; qassi ikka nuuppe guyyeera yees’ yaaga” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Qassi i naa77antta heezzanttanne wudiyaa kaalliya harata ubbata hagaadan azaziis; “Intte Eesawaara gaittiyo wode, hannidenkka geeta; ");
INSERT INTO wal_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Ne ashkkaraa Yaaqoobi nuuppe guyyeera yees’ geennan aggoppite” yaagiis. Aissi giikko i, “Taani taappe sinttau immanau kiittidoban a doshissana; ooni erii, hegaappe guyyiyan taani aara gaittiyo wode, i tana mokki ekkanaakkonne” yaagidi qoppiis. ");
INSERT INTO wal_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hegaa gishshau ba immiyoobaa baappe sinttau yeddiis. SHin i ba huuphen he gallassi qammi yan aqiis. ");
INSERT INTO wal_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","He gallassi qammi Yaaqoobi denddidi, ba naa77u keettaayeta, ba naa77u kaadumatatanne ba naata tammanne isiineta ekkidi, Yaabooqa giyo pinuwaa gakkiis; i eta shaafaa pinttiis; bau de7iyaabaa ubbaakka pinttidi yeddiis; ");
INSERT INTO wal_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","shin Yaaqoobi barkka attiis. He wode issi asi sa7ai wonttana gakkanaassi aara baaxetiis. ");
INSERT INTO wal_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","He asi a xoonanau danddayibeennaagaa be7ido wode, Yaaqoobayyo bulxxiyaa meqettaa bochchiis; bochchin a bulxxiyaa meqettai kiyi wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yaatin bitanee a, “Sa7ai wonttido gishshau, tana yedda” yaagiis. SHin Yaaqoobi a, “Neeni tana anjjennan taani nena yeddikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yaagin bitanee a, “Ne sunttai oonee?” yaagidi oichchiis. Oichchin i, “Yaaqooba” yaagidi zaariis. ");
INSERT INTO wal_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yaagin bitanee a, “Hagaappe sinttau ne sunttai Israa7eela geetettoppe attin, Yaaqooba geetettoppo; aissi giikko, neeni Xoossaaranne asaara baaxetada xoonadasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaaqoobi a, “Ne sunttai oonee?” yaagidi oichchiis. SHin bitanee, “Neeni ta sunttaa aissi oichchai?” yaagiis; yaagidi a anjjiis. ");
INSERT INTO wal_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Hegaa gishshau Yaaqoobi he sohuwaa PHinii7eela giidi sunttiis; aissi giikko i, “Taani Xoossaa baazzan xeellaas; gidikkonne taani paxa attaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I PHinii7eelappe denddiyo wode, a bolli xalqqee doliis. I ba bulxxiyaa meqettaa gishshau wobbees. ");
INSERT INTO wal_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yaaqooba bulxxee ashuwaa matan boshettido gishshau, Israa7eela asai mehiyaa bulxxiyaa ashuwaa hachchi gakkanaassikka meenna. ");
INSERT INTO wal_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaaqoobi xoqqu gi xeellidi, Eesawi ba oiddu xeetu asaara yiyaagaa be7iis. Hegaa gishshau naata Liyissi, Raaheelissinne naa77u kaadumatatussi shaakkiis. ");
INSERT INTO wal_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kaadumatatanne eta naata sinttan, Liyonne i naata eta geeduwan, Raaheelonne Yooseefa wurssettan wottiis. ");
INSERT INTO wal_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","SHin i ba huuphen sinttau aadhdhidi, ba ishaakko matiiddi, sa7aa gakki gakkidi laapputon ziggiis. ");
INSERT INTO wal_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","SHin Eesawi aara gaittanau woxxidi, a qooriyaa qoommidi yeriis. Eti yeekkidosona. ");
INSERT INTO wal_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Yaatin Eesawi xoqqu gi xeellidi, maccaasatanne naata be7iis; be7idi i, “Ha nenaara de7iyaageeti oonee?” yaagidi oichchiis. Oichchin Yaaqoobi, “Eti Xoossai ne ashkkaraayyo kehatettan immido naata” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Yaagin kaadumatati bantta naatuura shiiqidi ziggidosona. ");
INSERT INTO wal_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Hegaappe guyyiyan, Liyanne i naati yiidi ziggidosona; wurssettan Yooseefinne Raaheela yiidi ziggidosona. ");
INSERT INTO wal_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eesawi, “Ha sinttan tanaara gaittida wudee ubbai qassi aibee?” yaagidi oichchiis. Oichchin i, “Ta godau, hegee taani ne sinttan nashettanaassa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","SHin Eesawi, “Ta ishau, taayyo daroi de7ees; nebai neessa gido” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaagin Yaaqoobi, “CHii, ha77i taani ne sinttan nashettidabaa gidikko, ha taani immiyoogaa taappe ekka. Neeni tana mokka ekkido gishshau, taani ne som77uwaa be7iyoogee Xoossaa som77uwaa be7iyoogaa mala. ");
INSERT INTO wal_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Taani neeyyo ehiido ha imuwaa ekka; aissi giikko, Xoossai kehidi immin, taayyo bessiis” yaagiis. Yaaqoobi shoobiyaa tolido gishshau, Eesawi hegaa ekkiis. ");
INSERT INTO wal_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hegaappe guyyiyan Eesawi, “Ane hindda; nu ogiyaa boos; taani nenaara issippe baana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","SHin Yaaqoobi a, “Ta godau, naati shugo gidiyoogaa eraasa; qassi taani bantta galo marata xanttiya dorssatanne miizzaa naagana koshshees; asai eta issi gallassaa tolidi laaggikko, mehe ubbai haiqqana. ");
INSERT INTO wal_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hegaa gishshau, ta godau, ne ashkkaraappe sinttatada ba; taani Se7iiran ta godaa gakkanaassi, ta sinttan de7iya mehiyaa hemetaa keesaanne naatu hemetaa keesaa loddan kaallana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Yaagin Eesawi a, “Yaanikko taani ta asaappe amaridaagaa neeyyo ashshais” yaagiis. SHin Yaaqoobi a, “Hegee aissee? Taani ta godaa sinttan nashettiyoogee tau gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hegaa gishshau Eesawi he gallassi ogiyan gelidi, Se7iira simmiis. ");
INSERT INTO wal_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","SHin Yaaqoobi Sukkota biis; yan baayyo keettaa keexxiis; ba mehetuyyoonne daaseta daasiis. Hegaa gishshau he sohuwaa Sukkota giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaaqoobi Masphphexoomiyaappe simmido wode, Kanaane biittan de7iya Sekeema giyo katamaa sarotettan gakkiis; i he katamaayyo baazzan uttiis. ");
INSERT INTO wal_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ba dunkkaaniyaa tolido gadiyaa SHekeema aawaa Hamoora naatuppe xeetu xaqara biran shammiis. ");
INSERT INTO wal_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yan yarshshiyoosaa keexxidi a, “Xoossaa, Israa7eela Xoossaa” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Liya Yaaqoobayyo yelido na7iyaa Diina, he wode he biittaa maccaasata be7anau kiyaasu. ");
INSERT INTO wal_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","He biittaa haariya Hiiwiyaa Hamoora na7aa SHekeemi o be7idi, o dafi efiidi mooriis. ");
INSERT INTO wal_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","A wozanai Yaaqooba na7iyo Diino amottiis; i o siiqiis; siiqidi o lo77iyaabaa iyyo haasayiis. ");
INSERT INTO wal_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","SHekeemi ba aawaa Hamoora, “Taayyo ha na7iyo machcho oichcharkkii” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaaqoobi ba na7iyaa Diina moorettidoogaa siyiyo wode, a attuma naati bazzon mehiyaara de7oosona; hegaa gishshau eti gakkanaashin co77u giis. ");
INSERT INTO wal_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hegaappe guyyiyan, SHekeema aawaa Hamoori Yaaqoobaara haasayanau yiis. ");
INSERT INTO wal_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yaaqooba attuma naati hegaa siyidosaara bazzoppe yiidosona; eti azzanidosonanne yiillotidosona; aissi giikko, SHekeemi Yaaqooba na7iyo dafi efiidi mooriyoogan, Israa7eela bolli pokkobaa, oottanau bessennabaa oottiis. ");
INSERT INTO wal_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","SHin Hamoori eta, “Ta na7ai SHekeemi intte na7eessi daro dagammiis; hayyanintta o assi machcho immerkketii! ");
INSERT INTO wal_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nunaara ekettitenne gelettite; intte macca naata nuuyyo immite; nu macca naatanne intteyyo ekkite. ");
INSERT INTO wal_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Intte nu giddon uttana danddayeeta; biittai keehi aaho; an de7ite; zal77ite; an aquwaa demmite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","He wode SHekeemi Diini aawaanne i ishantta, “Taani intte sinttan nashettikko, intte caddiyoobaa aiba gidikkonne immana. ");
INSERT INTO wal_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Intte mishira na7eessi immiyoobaanne koitaa intte koyido keenaa darissidi tana caddite; taani intte tana caddidobaa aibanne immana; shin taani machchanau na7iyo taayyo immerkketii!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Bantta michchiyo Diino SHekeemi tunissido gishshau, Yaaqooba attuma naati SHekeemayyoonne a aawaa Hamoorayyo worddobaa yootidosona; ");
INSERT INTO wal_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","eta hagaadan yaagidosona; “Nuuni hegaa malabaa oottana danddayokko; nuuni nu michchiyo qaxxarettibeenna asau immokko; hegee nuna kaushshiyaabaa. ");
INSERT INTO wal_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nuuni intte issibaa oottikko intteyyo, ‘Eeno’ gaana; hegee aibee giikko, intte biittaa attumaasai ubbai qaxxarettidi nunadan hanikko, ");
INSERT INTO wal_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","yaanikko nuuni nu macca naata intteyyo immanau ‘Eeno’ gaana; intte macca naatakka nuuyyo ekkana. Nuuni intte giddon uttidi, inttenaara issi asa gidana. ");
INSERT INTO wal_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","SHin intte qaxxarettanau maayennabaa gidikko, nuuni nu michchiyo ekkidi baana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yaagin eti giidobai Hamooraunne a na7aa SHekeemau lo77o milatiis. ");
INSERT INTO wal_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","He wodallai, ba aawaa keettan de7iya ubbaappe aadhdhi bonchchettidaagee, Yaaqooba na7en ufaittido gishshau, eti giidobaa oottanau takkibeenna. ");
INSERT INTO wal_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","He wode Hamoorinne a na7ai SHekeemi bantta katamaa gutaraa biidi, bantta katamaa asau hagaadan yaagidi yootidosona; ");
INSERT INTO wal_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ha asati nunaara siga; eti nu biittan de7onanne zal77ona; biittai keehi aaho. Eta macca naatanne nuuni ekkana; etinne nu macca naata ekkana. ");
INSERT INTO wal_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","SHin nunaara eti issi asadan de7anau nuuni issibaa maayettanau koshshees; hegeenne, eti qaxxarettidoogaadan nu attumaasai ubbai qaxxarettanaagaa. ");
INSERT INTO wal_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nuuni hegaadan oottikko, eta miizzai, eta aqoinne eta hara mehe ubbai nubaa gidennee? Hegaa gishshau ane nuuni eti giyoogaa maayoos; etinne nu giddon de7ana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Katamaa gutaraa shiiqida asati ubbai Hamoorayyoonne a na7aa SHekeemayyo, “Eeno” giidosona. Yaatin he katamaa attumaasati ubbai qaxxarettidosona. ");
INSERT INTO wal_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Heezzantto gallassi, eti ubbai bantta qaxxaraa masunttaa sahettishin, Yaaqooba attuma naatuppe naa77ai, Simooninne Leewi, Diini ishantti, bantta bisuwaa ekkidi, ooninne erennan katamaa gelidi, attumaasata ubbaa woridosona. ");
INSERT INTO wal_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamooranne a na7aa SHekeema bisuwan woridi, bantta michchiyo Diino SHekeema keettaappe ekkidi efiidosona. ");
INSERT INTO wal_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaaqooba attuma naati he ahatu bolli gelidi, bantta michchiyo Diino tunissida katamaa bonqqidosona. ");
INSERT INTO wal_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Eta dorssaa wudiyaa, miizzaa wudiyaa, hariyaa, katama giddon de7iyaabaanne gaxan de7iyaabaa ubbaa ekkidosona. ");
INSERT INTO wal_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Eta aquwaa ubbaa, eta naata ubbaanne maccaasata ubbaa omooddidosona; keettan de7idabaa ubbaa bonqqidosona. ");
INSERT INTO wal_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaaqoobi Simoonanne Leewa, “Intte ta bolli metuwaa ehiichchideta; ha biittan de7iya Kanaanetinne Parzzeti tana ixxana; nuuni qoodan guutta; eti issippe gididi ta bolli woraajjikko, taaninne ta so asai xayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","SHin eti, “Yaatin i nu michchiyo shaaramuxadan oottana bessii?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Xoossai hegaappe guyyiyan Yaaqooba, “Dendda! Denddada pude Beeteele ba; baada yan de7a. Neeni ne ishaa Eesawappe baqatiyo wode neeyyo qonccida Xoossaayyo yan yarshshiyoosaa keexxa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaagin Yaaqoobi ba so asaanne banaara de7iyaageeta ubbaa, “Intte gidduwan de7iya allaga xoossatu misileta diggite; intte bollaa geeshshite; intte maayuwaanne laammite. ");
INSERT INTO wal_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ane denddidi, pude Beeteele boos; ta metuwaa gallassi taayyo siyida, taani biidosan ubban tanaara gidida Xoossau, taani yan yarshshiyoosaa keexxana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Hegaa gishshau eti banttayyo de7iya allaga xoossatu misileta ubbaanne bantta haittan de7iya gutuchchaa ubbaa Yaaqoobau immidosona; immin Yaaqoobi hegeeta Sekeeman de7iya wolaa garssan moogiis. ");
INSERT INTO wal_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Hegaappe guyyiyan, Yaaqoobinne a attuma naati denddidi biishin, issi urainne eta oiqqanau kaallibeenna; aissi giikko, eti biishin, eta yuushuwan de7iya katamaa asaa ubbaa bolli Xoossaa dagamai wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaaqoobinne aara de7iya asai ubbai Kanaane biittan de7iya (Beeteele giyo) Looza gakkidosona. ");
INSERT INTO wal_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Gakkin yan i yarshshiyoosaa keexxiis; i he sohuwaa El-Beeteele giidi sunttiis; aissi giikko, i ba ishaappe baqatidi biyo wode, Xoossai ayyo qonccido sohoi hegaa. ");
INSERT INTO wal_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ribiqo dichchiya Deboora yan haiqqaasu; Beeteeleppe hirkkiira de7iya wolaa garssan a moogettaasu; hegaa gishshau he mittaa sunttai Yeehuwaa Wolaa geetettiis. ");
INSERT INTO wal_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yaaqoobi Masphphexoomiyaappe simmidoogaappe guyyiyan, Xoossai ayyo zaaretti qonccidi, a anjjiis; ");
INSERT INTO wal_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Xoossai a, “Ne sunttai Yaaqooba; shin hagaappe sinttanau neeni mulekka Yaaqooba geetettakka; ne sunttai Israa7eela gidana” yaagidi i a Israa7eela sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Qassi Xoossai Yaaqooba, “Taani Ubbaa Danddayiya Xoossaa; neeni yeletta; coratta; kawotettatinne kawotettaa asai neeppe kiyana; kawotikka ne gulbbataappe kiyana. ");
INSERT INTO wal_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Taani Abrahaamaunne Yisaaqau immido biittaa, qassi neeyyo immais; neeppe guyyiyankka taani ha biittaa ne zerettaayyo immana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hegaappe guyyiyan, Xoossai aara haasayido sohuwaappe pude kiyiis. ");
INSERT INTO wal_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaaqoobi Xoossai banaara haasayido sohuwan shuchchaa essidi, a bolli ushshaa yarshshuwaa tigiis; zaitiyaakka a bolli tigiis. ");
INSERT INTO wal_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaaqoobi Xoossai banaara haasayido sohuwaa “Beeteele” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Eti hegaappe guyyiyan, Beeteeleppe denddidosona. Eti Efiraataa gakkanau guuttaa ashshidaashin, Raaheelo maaretai oiqqiis; maaretan a keehi waayettaasu. ");
INSERT INTO wal_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Maaretai o waayissido wode o yelissiyaara, “Yayyoppa; hageekka attuma na7aa” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","SHin a haiqqaidda, shemppoi kiyishin, ba na7aa Ben77ona sunttaasu; shin a aawai a Biniyaama sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hegaappe guyyiyan, Raaheela haiqqa bayaasu; haiqqada Beetaliheeme giyo Efiraata efiya ogiyaa doonan moogettaasu. ");
INSERT INTO wal_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaaqoobi i duufuwan hawulttiyaa shuchchaa essiis; he hawulttee hachchi gakkanaassikka Raaheeli duufuwaa erissees. ");
INSERT INTO wal_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israa7eeli hegaappe denddidi, Edera gimbbiyaappe hefinttan ba dunkkaaniyaa tokkiis. ");
INSERT INTO wal_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israa7eeli he biittan de7ishin, Roobeeli biidi, ba aawaassi yelida kaadumatee Baaliira zin77iis. Israa7eelinne ha yohuwaa siyiis. Yaaqooba attuma naati tammanne naa77a. ");
INSERT INTO wal_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liyi naati Yaaqooba baira na7aa Roobeela, Simoona, Leewa, Yihudaa, Yisaakooranne Zaabiloona. ");
INSERT INTO wal_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raaheeli attuma naati Yooseefanne Biniyaama. ");
INSERT INTO wal_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raaheeli danggiriixee Baali attuma naati Daananne Nifttaaleema. ");
INSERT INTO wal_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liyi danggiriixee Zilppi attuma naati Gaadanne Aseera. Hageeti Masphphexoomiyan Yaaqoobayyo yelettida a attuma naata. ");
INSERT INTO wal_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaaqoobi (Kebroona giyo) Qiriyaati-Arbba7a matan Mamiren de7iya, ba aawaa Yisaaqa soo yiis; he sohoi kase Abrahaaminne Yisaaqi de7ido soho. ");
INSERT INTO wal_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yisaaqi xeetanne hosppun tammu laittaa de7iis; ");
INSERT INTO wal_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","i daro wodiyaa de7idi, lo77o ceeggidi haiqqiis; haiqqidi ba maizzan gaittiis. A naati Eesawinne Yaaqoobi a moogidosona. ");
INSERT INTO wal_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Eedooma giyo Eesawa yeletai hagaappe kaallidi xaafettidaagaa. ");
INSERT INTO wal_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Eesawi Kanaane biittaa macca naatuppe bau machchota ekkiis; etinne Hiitiyaa Eloona na7iyo Aado, Hiiwiyaa Xibaa7oona na7ai Aani yelido Oholiibaamonne ");
INSERT INTO wal_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Isimaa7eela na7iyo, Nabaayoota michchiyo Baasemaato. ");
INSERT INTO wal_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aada Eesawayyo Elifaaza yelaasu; Baasemaatakka Ra7u7eela yelaasu; ");
INSERT INTO wal_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholiibaama Ya7uusha, Yaa7ilaamanne Qoraaha yelaasu; Kanaane biittan Eesawayyo yelettida attuma naati hageeta. ");
INSERT INTO wal_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Eesawi ba keettaayeta, ba attuma naatanne macca naata, ba so asa ubbaa, ba miizzatanne ba mehe ubbaa Kanaane biittan i haaridobaa ubbaa ekkidi, ba ishaa Yaaqoobappe haakkiya biitti biis. ");
INSERT INTO wal_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Eta aqoi darido gishshau, eti issippe de7anau danddayibookkona; eta mehee darido gishshau, eti de7iyo biittai eta naa77aayyo gidanau danddayibeenna. ");
INSERT INTO wal_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yaanin Eedooma giyo Eesawi Se7iira giyo gezziyan uttiis. ");
INSERT INTO wal_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Se7iira gezziyan de7ida Eedoomatu aawaa Eesawa yeletai hagaappe kaallidi xaafettidaagaa. ");
INSERT INTO wal_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Hagee Eesawa attuma naatu sunttaa; hegeetinne Eesawa keettaayee Aadi na7aa Elifaazanne Eesawa keettaayee Baasemaati na7aa Ra7u7eela. ");
INSERT INTO wal_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaaza naati Temaana, Omaara, Xafa, Ga7itaamanne Qanaaza. ");
INSERT INTO wal_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Qassi Timinaa7a Eesawa na7aa Elifaazayyo kaadumata; a Elifaazayyo Amaaleeqa yelaasu. Hageeti Eesawa keettaayee Aadi na7aa naata. ");
INSERT INTO wal_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ra7u7eela attuma naati Nahaata, Zaraaha, SHammanne Miiza; hageeti Eesawa keettaayee Baasemaati na7aa naata. ");
INSERT INTO wal_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Xibaa7oona na7ai Aani yelido Oholiibaama attuma naati hageeta; a Eesawayyo Ya7uusha, Yaa7ilaamanne Qoraaha yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Eesawa yeletaa halaqati hagaappe kaallidi xaafettidaageeta. Eesawayyo baira na7aa Elifaaza attuma naati, halaqa gididaageeti Temaana, Omaara, Xafa, Qanaaza, ");
INSERT INTO wal_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Qoraaha, Ga7itaamanne Amaaleeqa; Eedooma biittan Elifaazi yelido halaqati hageeta; hageeti ubbai Aadi na7aa naata. ");
INSERT INTO wal_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Eesawa na7aa Ra7u7eela attuma naati, halaqa gididaageeti Nahaata, Zaraaha, SHammanne Miiza; Eedooma biittan Ra7u7eeli yelido halaqati hageeta; eti Eesawa keettaayee Baasemaati na7aa naata. ");
INSERT INTO wal_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Eesawa keettaayee Oholiibaami attuma naati, halaqa gididaageeti Ya7uusha, Yaa7ilaamanne Qoraaha; eti Aana na7ee, Eesawa keettaayee Oholiibaamippe yelettida halaqata. ");
INSERT INTO wal_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Eedooma giyo Eesawa attuma naati hageeta; eta halaqatikka hageeta. ");
INSERT INTO wal_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Eedooma biittan de7iya Hooriyaa Se7iira attuma naati hagaappe kaallidi xaafettidaageeta; hegeetikka Loxaana, SHobaala, Xibaa7oona, Aana, ");
INSERT INTO wal_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoona, Exeeranne Dishaana; hegeeti, Eedooma biittan de7iya Se7iira attuma naati, Hooretu halaqata. ");
INSERT INTO wal_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Loxaana attuma naati Hooranne Heemaama; Loxaana michchiyaa Timinaa7o. ");
INSERT INTO wal_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","SHobaala attuma naati Aaliwaana, Manahaata, Eebaala, SHefanne Oonaama. ");
INSERT INTO wal_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Xibaa7oona attuma naati Aayanne Aana; hagee Aani bazzon ba aawaa Xibaa7oona hareta heemmiiddi haattaa bilbbuwaa demmidaagaa. ");
INSERT INTO wal_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aana na7ai Dishoona; na7iyaa qassi Oholiibaamo. ");
INSERT INTO wal_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishoona attuma naati Hemddaana, Eshibaana, Yitiraananne Karaana. ");
INSERT INTO wal_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Exeera attuma naati Bilihaana, Za7iwaananne Aqaana. ");
INSERT INTO wal_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishaana attuma naati Uuxanne Araana. ");
INSERT INTO wal_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hooretu halaqati hageeta; Loxaana, SHobaala, Xibaa7oona, Aana, ");
INSERT INTO wal_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoona, Exeeranne Dishaana. Hageeti Se7iira biittan bantta yaran yaran shaahettida Hooretu halaqata. ");
INSERT INTO wal_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israa7eelan kawoi kawotanaappe kase Eedooma biittan kawotida kawoti hagaappe kaallidi xaafettidaageeta. ");
INSERT INTO wal_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ba7oora na7ai Belaa7i Eedooman kawotiis; a katamaa sunttai Dinaaba geetettees. ");
INSERT INTO wal_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Belaa7i haiqqin, Booxirappe yiida Zaraaha na7ai Yobaabi kawotiis. ");
INSERT INTO wal_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaabi haiqqin, Temaana biittaappe yiida Hushaami kawotiis. ");
INSERT INTO wal_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushaami haiqqin, Badaada na7ai Hadaadi, Midiyaama asata Moo7aaba biittan xoonidaagee kawotiis; a katamaa sunttai Awiita geetettiis. ");
INSERT INTO wal_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaadi haiqqin, Maasireeqappe yiida Saamili kawotiis. ");
INSERT INTO wal_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Saamili haiqqin, shaafaa matan de7iya Rahobootappe yiida SHaa7uli kawotiis. ");
INSERT INTO wal_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","SHaa7uli haiqqin, Akiboora na7ai Ba7aalihanaani kawotiis. ");
INSERT INTO wal_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akiboora na7aa Ba7aalihanaani haiqqin, Hadaari kawotiis; a katamaa sunttai Paa7u geetettees; a keettaayyiyaa Mezaahaaba na7iyaa Maaxireeda yelido Mahexaabi7eelo geetettausu. ");
INSERT INTO wal_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Eesawa yeletaa halaqati bantta yaran yaran, bantta sohuwan sohuwaaninne bantta sunttan sunttan hageeta; Timinaa7a, Aliwa, Yeteeta, ");
INSERT INTO wal_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholiibaama, Eela, Piinoona, ");
INSERT INTO wal_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Qanaaza, Temaana, Mibxxaara, ");
INSERT INTO wal_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Maagidi7eelanne Iraama. Hageeti bantta haariyo biittan, bantta de7iyoosan de7iyoosan Eedooma halaqata. Hagee Eesawi, Eedoomatu aawaa. ");
INSERT INTO wal_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaaqoobi ba aawai de7ido Kanaane biittan uttiis. ");
INSERT INTO wal_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yaaqooba naati hanidobai hagaappe kaallidi xaafettidaagaa. Yooseefi tammanne laappun laitta na7a gidido wode, ba aawaa kaadumatatuppe, Baalippenne Zilppippe yelettida ba ishanttuura wudiyaa heemmees. He wode i ba aawaayyo eti oottido iitabaa yootees. ");
INSERT INTO wal_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israa7eeli Yooseefa cimidi yelido gishshau, ba hara attuma naatu ubbaappe aattidi siiqees. I ayyo alleeqettida maayuwaa giigissiis. ");
INSERT INTO wal_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","A ishantti bantta aawai a etappe aattidi siiqiyoogaa be7ido wode, eti a ixxidi, keha qaala ayyo haasayanau danddayibookkona. ");
INSERT INTO wal_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yooseefi aimo aimottidi, ba ishanttuyyo yootiis; yootin eti a yaa darissidi ixxidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","I eta, “Taani aimottido aimuwaa siyite. ");
INSERT INTO wal_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nuuni gaden mirqqiyaa qachchishin, ta mirqqee issi kuttan denddidi sitti giidi eqqi bayin, intte mirqqeti yuuyi aadhdhidi ta mirqqiyaassi ziggidosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yaagin a ishantti a, “Neeni nu bollan kawotana hanaiyye? Woikko nuna tumu haarana hanaiyye?” yaagidosona. Eti a aimuwaa gishshaunne a oduwaa gishshau, yaa darissidi ixxidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Qassi Yooseefi hara aimuwaa aimottidi, ba ishanttuyyo yootiis; “Siyite; taani hara aimuwaakka aimottaas. He aimuwan awai, aginainne tammanne isiini xoolintteti taayyo ziggoosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ba aawaayyoonne ba ishanttuyyo he aimuwaa yootido wode, a aawai a, “Hagee neeni aimottidoogee aiba aimoo? Tumu taani, ne aayyiyaanne ne ishantti yiidi, ne sinttan sa7an gufannidi neeyyo zigganeeyye?” yaagidi seeriis. ");
INSERT INTO wal_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A ishantti a qanaatidosona; shin a aawai ha yohuwaa ba wozanan wottiis. ");
INSERT INTO wal_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Issi gallassi a ishantti Sekeema matan bantta aawaa dorssaa heemmanau biidosona; ");
INSERT INTO wal_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","bin Israa7eeli Yooseefa, “Ne ishantti Sekeeman wudiyaa heemmiyoogaa eraasa. Haaya; taani nena etakko kiittana” yaagiis. Yaagin Yooseefi, “Eeno” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yaagin i a, “Ba; baada ne ishanttinne wudee saro gidiyoogaa be7a; be7ada etabaa taayyo yootaasa” yaagiis. Yaagidi a Kebroona dilbbaappe kiittiis. Kiitettidi i Sekeema biis. ");
INSERT INTO wal_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Yan dembbaa giddon i yaa haa simerettishin, issi asi a demmidi, “Na7au, ai koyai?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Oichchin i, “Ta ishantta koyais; eti wudiyaa heemmiyoosai awaanakkonne hailaa taayyo odarkkii!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yaagin bitanee, “Hagaappe denddiichchidosona; eti, ‘Nuuni Dootaana boos’ giishin siyaas” yaagiis. Hegaa gishshau, Yooseefi ba ishanttu geeduwaa biidi, eta Dootaanan demmiis. ");
INSERT INTO wal_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","SHin i haahuwan de7ishin, eti a be7idosona; i etakko gakkennan de7ishin, eti a woranau a bolli maqettidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Issoi issuwaa, “Be7ite! Aimuwaawai yees. ");
INSERT INTO wal_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Haayite; a woridi, ha ollatuppe issuwaa giddo yeggoos. Hegaappe guyyiyan, ‘Iita do7i a miis’ yaagana; yaatidi a aimoi ehiyoobaa be7ana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Roobeeli hegaa siyido wode, eta kushiyaappe a ashshanau koyidi, “A worennan aggoos. ");
INSERT INTO wal_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Suutta gussoppite; a intte bazzuwan de7iya ha ollaa giddo olite; a bolli kushe wottoppite” yaagiis. Roobeeli hagaa a etappe ashshidi guyye a aawaakko yeddanau giis. ");
INSERT INTO wal_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yooseefi ba ishanttukko gakkido wode, i maayido alleeqettida maayuwaa appe qaari ekkidosona; ");
INSERT INTO wal_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","a efiidi haatti bainna mela ollan yeggidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Eti bantta qumaa maanau uttidaashin, Isimaa7eela asati Gibxxe baanau Gala7aadeppe yiyaageeta xoqqu giidi be7idosona; eti bantta gaameelan sawuwaa, balasaane giyo xaliyaanne karbbiyaa caani wottidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yihudai ba ishantta, “Nuuni nu ishaa woridi a suuttaa qosiyaabaa gidikko nuna ai go77ii? ");
INSERT INTO wal_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Haayite; a Isimaa7eelatuyyo baizzoos; a bolli nu kushiyaa wottokko; aissi giikko, i nu ishaa, nu ashuwaa” yaagiis. Yaagin a ishantti maayidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hegaa gishshau Midiyaama biittaa zal77anchchati hegaara aadhdhishin, a ishantti Yooseefa ollaappe kessidi, Isimaa7eela asatuyyo laatamu xaqara biran baizzidosona. Baizzin eti Yooseefa Gibxxe biittaa efiidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Roobeeli ollaakko simmidi, Yooseefi yan bainnaagaa be7ido wode, azzanidi ba maayuwaa pooshshiis. ");
INSERT INTO wal_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","I guyye ba ishanttukko biidi, “Na7ai yan baawa; ha77i taani au booshsha!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hegaappe guyyiyan eti Yooseefa maayuwaa ekkidi, deeshsha orggiyaa shukkidi, he suuttan naaqqidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Alleeqettida a maayuwaa bantta aawaakko efiidi a, “Nuuni hagaa demmida; hagee ne na7aa maayuwaakkonne ane xeella” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yaagin maayuwaa i eridi, “Hagee ta na7aa maayuwaa! Iita do7i a mirggiis. Yooseefi tumakka zaazettiichchiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaagidi Yaaqoobi azzanidi, ba maayuwaa peeriis; ba xeessan waaruwaa gixxidi, ba na7aayyo daro gallassaa yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A attuma naatinne macca naati ubbai a minttettanau yiidosona; shin i minnennan ixxiis; ixxidi, “CHii, taani yeekkaidda ta na7aakko baada, duufuwan gelana” yaagidi, a aawai ayyo yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","He wode Midiyaama biittaa asati Yooseefa Gibxxe kawuwaa oosanchchaa PHoxiifaarayyo Gibxxen baizzidosona; i naagiyaageetu halaqa. ");
INSERT INTO wal_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","He wode Yihudai ba ishanttuppe shaahettidi, Adulaama giyo kataman de7iya Hiira giyo bitaniyaara de7anau biis. ");
INSERT INTO wal_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yan Yihudai SHuu7a giyo Kanaaniyaa na7eera gaittiis; i o ekkidi machchiis. ");
INSERT INTO wal_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","A ayyo abbe ixettada attuma na7aa yelaasu; yelada a Eera sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Qassikka abbe ixettada attuma na7aa yelaasu; yelada a Oonaana sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Qassi gujjadakka attuma na7aa yelaasu; yelada a SHeela sunttaasu. A yelidoi Akiziiba giyo biittaana. ");
INSERT INTO wal_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yihudai ba baira na7aa Eerayyo Ti7imaaro giyo machchiyo immiis. ");
INSERT INTO wal_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yihudaa baira na7ai, Eeri, GODAA sinttan iita asa gidiyo gishshau, GODAI a woriis. ");
INSERT INTO wal_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yihudai Oonaana, “Ne ishaa machcheekko gelada, o aissa; ne ishaayyo na7a yelada a xeesissa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","SHin Oonaani yelettiya naati baageeta gidennaagaa eriis; hegaa gishshau ba ishaa machcheera zin77iyo wode audenne, ba ishaayyo na7i yelettenna mala, ba zerettaa biittan gussees. ");
INSERT INTO wal_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","I oottidobai GODAA sinttan iitabaa gidido gishshau, GODAI akka woriis. ");
INSERT INTO wal_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Hegaappe guyyiyan, Yihudai ba na7aa machchiyo Ti7imaaro, “Ta na7ai SHeeli diccana gakkanaassi ne aawaa soo baada, am77etettan de7ashsha” yaagiis. Hegaa i aibissi giidee giikko, ikka ba ishanttudan haiqqanaakkonne giidi hirggido gishshaassa. Hegaa gishshau Ti7imaara baada ba aawaa son de7aasu. ");
INSERT INTO wal_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Daro wodiyaappe guyyiyan Yihudaa keettaayyiyaa, SHuu7a na7iyaa haiqqaasu. Yihudai ba kayyuwaappe minettido wode, ba dorssaa ikisiyaa meediya asatukko Timina kiyiis; qassi a laggee, Adulaamiyaa Hiiri aara biis. ");
INSERT INTO wal_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Asai Ti7imaaro, “Be7a; ne bolloi Yihudai, ba dorssatu ikisiyaa meedanau Timina kiyees” yaagidi yootiis. ");
INSERT INTO wal_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","A ba am77etettaa maayuwaa qaaraasu; bana balettanau shaashiyaa ekkada gullettaasu. Gullettada Timina efiya ogiyaa doonan de7iya Enaima katamaa penggen uttaasu. Hegaa a oottidoogee, SHeeli dicci gakkinkka a ayyo machcho gidanau imettabeennaagaa erido gishshaassa. ");
INSERT INTO wal_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yihudai o be7ido wode, shaaramuxa giidi qoppiis; aissi giikko, a ba som77uwaa gulletta uttaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ba na7aa machchiyo gidiyoogaa erennan de7iiddi, ogiyaa gaxaa ikko shiiqidi o, “Tanaara zin77arkki!” yaagiis. Yaagin a, “Taani nenaara zin77ikko, neeni taayyo ai immuutee?” yaagada oichchaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Oichchin i, “Taani ta wudiyaappe issi deeshsha maraa neeyyo yeddana” yaagiis. Yaagin a, “Neeni hegaa taayyo yeddana gakkanaassi ai oittuutee?” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yaagin i, “Ai oittoo?” yaagiis. Yaagin a, “Ne maatafa wottiyo migiduwaa, a aattiyo baqettaanne ne kushiyan de7iya gatimaa oitta” yaagaasu. Yaagin i hegeeta immidi, iira zin77in, a ayyo shahaaraasu. ");
INSERT INTO wal_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","A hegaappe denddada biidoogaappe guyyiyan, ba gullettaa shaashiyaa qaarada, ba am77etettaa maayuwaa maayaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yihudai ba oittidobaa he mishireeppe zaari ekkanau deeshsha maraa ba laggiyaa Adulaama bolli iyyo kiittiis; shin i o demmibeenna. ");
INSERT INTO wal_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","I he biittaa asaa, “Enaima kataman, ogiyaa doonan uttida shaaramuxa maccaasiyaa awaanee?” yaagidi oichchiis. Oichchin asai, “SHaaramuxa maccaasi hagan mulekka baawa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Yaagin i Yihudaakko simmidi a, “Taani o demmabeikke; hegaa bollikka he biittaa asai, ‘SHaaramuxa maccaasi hagan mulekka baawa’ yaagiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yaagin Yihudai, “Ba oiqqidoogaa bau ekku; hegee xayikko, asi nuna miiccana. Simmi taani iyyo deeshsha maraa yeddaas; shin neeni o demmabaakka” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Heezzu agina keenaappe guyyiyan asai, “Ne na7aa maccaasiyaa Ti7imaara shaaramuxada shahaaraasu” yaagidi Yihudaayyo yootiis. Yootin Yihudai, “O kare kessidi taman xuuggite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","O kare kessiyo wode, “Taani shahaaridoogee ha miishshatu godaassa; be7a; ha maatafaa wottiyo migidoi, a aattiyo baqettainne gatimai obaakko erana danddayikko era” yaagada ba bolluwaassi kiitaa kiittaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yihudai he miishshata eridi, “Taappe a xillo; aissi giikko, taani o ta na7aa SHeelayyo immabeikke” yaagiis. Hegaappe guyyiyan, i iira haranttuwaa zin77ibeenna. ");
INSERT INTO wal_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","A yelana haniyo wode, i uluwan mentte attuma naati de7oosona. ");
INSERT INTO wal_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A maarettishin, etappe issoi ba kushiyaa kessiis; kessin maaretissiyaara, “Be7ite; hagee koiro kiyees” gaanau zo7o qunccuutiyaa ekkada a kushiyan qachchaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","SHin i ba kushiyaa guyye ekkido wode, a ishai kiyiis; kiyin a, “Neeni waana porxxu gaada kiyadii!” yaagaasu. Hegaa gishshau, Paareesa gaada a sunttaasu. ");
INSERT INTO wal_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hegaappe guyyiyan, a kushiyan zo7o qunccuutee de7iyo a ishai kiyiis; a sunttai Zaraaha geetettiis. ");
INSERT INTO wal_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isimaa7eela asati Yooseefa Gibxxe efi wottidosona. Efin Gibxxiyaa PHoxiifaari, kawuwaa oosanchchatuppe issoi, naagiyaageetu halaqai Yooseefa Isimaa7eelatuppe shammiis. ");
INSERT INTO wal_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","GODAI Yooseefaara de7ees; hegaa gishshau, i oottiyoobaa ubbaa ayyo injjeyiis; yaatin ba godaa, Gibxxiyaa son de7iis. ");
INSERT INTO wal_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","GODAI aara de7iyoogaanne GODAI i oottidobaa ubbaa ayyo injjeyiyoogaa PHoxiifaari be7ido wode, ");
INSERT INTO wal_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yooseefi a sinttan nashettiis; i ayyo kiitettiis. PHoxiifaari a ba keettaa asaa bolli sunttiis; bau de7iyaabaa ubbaa a kushiyan wottiis. ");
INSERT INTO wal_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","PHoxiifaari ba keettan de7iyaabaa ubbaa bollinne ba aquwaa ubbaa bolli sunttido wodiyaappe doommidi, GODAI Gibxxe bitaniyaa keettaa Yooseefa gishshau anjjiis. GODAA anjjoi PHoxiifaarayyo sooninne gaden de7ida ubbabaa bolli wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hegaa gishshau baayyo de7iya ubbabaa Yooseefau sheedhdhiis; i ba miyo qumaappe attin, ainne qoppenna. Yooseefi yallisanne puulanchcha asa. ");
INSERT INTO wal_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Amarida wodiyaappe guyyiyan, a godaa keettaayyiyaa Yooseefa xeella be7ada, “Haaya; tanaara zin77a” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","SHin i ixxiis. Ba godaa keettaayyiyo, “Be7a; ta godai tau sheedhdhidi ba son de7iyaabau aibaunne hirggenna; baayyo de7iyaabaa ubbaa ta kushiyan wottiis. ");
INSERT INTO wal_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ha son taappe gitatiyai ooninne baawa. Neeni a keettaayyiyo gidiyo gishshau ne xalaalappe attin, ta godai taayyo immibeennabi baawa. Yaatin taani waatada hagaa mala daro iitabaa hanada Xoossaa bolli nagaraa oottoo?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","A ha yohuwaa hachchi hachchi Yooseefau yootikkonne, i iira zin77ennan woikko i matan uttennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Issi gallassi i ba oosuwaa oottanau soo geliis; geliyo wode, so ashkkaratuppe ooninne son baawa. ");
INSERT INTO wal_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","A Yooseefa afalaa oiqqada, “Tanaara zin77a” yaagaasu. SHin i ba afalaa i kushiyan yeggidi, sooppe kare woxxidi kiyiis. ");
INSERT INTO wal_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yooseefi ba afalaa i kushiyan yeggidi, sooppe kare woxxiichchidoogaa a be7ido wode, ");
INSERT INTO wal_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ba so ashkkarata xeesada eta, “Be7ite; ta keettaawai ehiido ha Ibraawe bitanee tana kaushshirggidi ashshiis; i tanaara zin77anau hagaa geliis; shin taani ta qaalaa xoqqissada waassaas. ");
INSERT INTO wal_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Taani waassin siyido wode, i ba afalaa ta matan yeggidi, sooppe kare woxxidi kiyiis” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A godai soo yaana gakkanaassi a Yooseefa afalaa ba matan wottaasu. ");
INSERT INTO wal_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hegaappe guyyiyan, a ayyo hagaadan yaagada odaasu; “Hegee neeni nuuyyo ehiido Ibraawe aillee tanaara zin77anau taakko geliis; ");
INSERT INTO wal_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","shin taani ta qaalaa xoqqissada waassidoogee, ba afalaa ta matan yeggidi, sooppe kare woxxiis” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","A godai ba keettaayyiyaa, “Ne aillee tana hagaadan oottiis” yaagada yootido qaalaa siyidi, hanqquwaa suulliis. ");
INSERT INTO wal_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Yooseefa godai a efiidi, kawuwaa qashuwaasai de7iyo qasho keettan yeggiis. ");
INSERT INTO wal_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","SHin Yooseefi yan qasho keettan de7iyo wode, GODAI aara de7ees. I ayyo qarettiis; qasho keettaa halaqaa sinttan ayyo nashuwaa immiis. ");
INSERT INTO wal_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yaanin qasho keettaa halaqai qashuwaasaa ubbaa Yooseefa kushiyan wottiis; hegan oosettiyaabaa ubbaa oottiyaagee a. ");
INSERT INTO wal_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Qasho keettaa halaqai Yooseefa kushiyan de7iyaabau aibaunne hirggenna; aissi giikko, GODAI aara de7ees; i oottiyoobaakka ubbaa ayyo injjeyiis. ");
INSERT INTO wal_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Amarida wodiyaappe guyyiyan, Gibxxe kawuwaa eessaa tigiyaageenne oittaa uukkiyaagee bantta godaa Gibxxe kawuwaa naaqqidosona. ");
INSERT INTO wal_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kawoi eessaa tigiyaageetu halaqaayyoonne oittaa uukkiyaageetu halaqaayyo naa77aayyookka keehi hanqqettiis. ");
INSERT INTO wal_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Hanqqettidi Yooseefi qashettido qasho keettan, naagiyaageetu halaqaa son eta wottiis. ");
INSERT INTO wal_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Naagiyaageetu halaqai eta Yooseefau sheedhdhiis; i etau oottees. Eti qasho keettan amarida wodiyaa uttidosona. ");
INSERT INTO wal_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gibxxe kawuwaayyo eessaa tigiyaageenne oittaa uukkiyaagee, qasho keettan de7iya naa77aikka, issi qammi dumma dumma aimuwaa aimottidosona. Qassi aimotuyyo huuphiyan huuphiyan eta birshshettai de7ees. ");
INSERT INTO wal_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yooseefi maallado etakko gelido wode, azzani uttidaageeta be7iis. ");
INSERT INTO wal_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Hegaa gishshau ba godaa son banaara qasho keettan de7iya kawuwaa oosanchchata, “Hachchi intte som77oi aibissi xumidee?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Oichchin eti a, “Nuuni naa77ai aimo aimottida; shin nuuyyo birshshiyaabi xayiis” yaagidosona. Yaagin Yooseefi eta, “Aimo birshshettai Xoossaabaa gidenneeyye? Intte aimuwaa taayyo yootite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Yaagin eessaa tigiyaageetu halaqai ba aimuwaa Yooseefayyo hagaadan yaagidi yootiis; “Taani ta aimuwan issi woiniyaa turaa ta sinttan be7aas. ");
INSERT INTO wal_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Qassi he woiniyaa turaayyo heezzu tashee de7ees. I maraa yelidi, ciishshaa ciyyidi, wurccuwaa wurcciis; wurccoinne teeriis. ");
INSERT INTO wal_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kawuwaa wanccai ta kushiyan de7ees; taani woiniyaa teeraa ekkada, kawuwaa wanccan gum77ada, he wanccaa a kushiyan wottaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yaagin Yooseefi, “Hegaa birshshettai hagaa; heezzu tasheti heezzu gallassata. ");
INSERT INTO wal_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Heezzu gallassatu giddon kawoi nena denttana; denttidi i nena kase ne sunttatettau zaarana; kase neeni eessaa tigiyo wode oottidoogaadan, neeni kawuwaa wanccaa a kushiyan wottana. ");
INSERT INTO wal_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","SHin neeyyo sa7ai kehido wode tana dogoppa; taayyo keha; tabaa kawuwaayyo yootada, ha qasho keettaappe tana kesissa; ");
INSERT INTO wal_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","aissi giikko, tana Ibraawetu biittaappe gubaayidi ehiidosona; harai atto hagankka tana qashissiyaabaa ainne oottabeikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Oittaa uukkiyaageetu halaqai Yooseefi aimuwaa loitti birshshidoogaa be7ido wode Yooseefa, “Taanikka aimo aimottaas; ta huuphiyan heezzu samppa oittai de7ees; ");
INSERT INTO wal_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","bolla bagga samppan Gibxxe kawuwaayyo uukettida ubba qommo oittai de7ees. SHin kafoi hegaa ta huuphiyan de7iya samppaappe mees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yaagin Yooseefi, “Hegaa birshshettai hagaa; heezzu samppati heezzu gallassata. ");
INSERT INTO wal_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Heezzu gallassatu giddon kawoi nena denttana; denttidi ne qooriyaa muucissidi mittan kaqissana; ne ashuwaanne kafoi maana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Heezzantta gallassan Gibxxe kawoi ba yelettido gallassi ba oosanchchatu ubbaayyo gibiraa giigissiis. Eessaa tigiyaageetu halaqaanne oittaa uukkiyaageetu halaqaa denttidi, ba oosanchchatu gidduwan essiis. ");
INSERT INTO wal_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Eessaa tigiyaageetu halaqaa a sunttatettau zaarin, i kawuwaa kushiyan wanccaa wottiis. ");
INSERT INTO wal_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","SHin kawoi oittaa uukkiyaageetu halaqaa eta aimuwaa birshshettaa Yooseefi yootidoogaadankka kaqissiis. ");
INSERT INTO wal_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","SHin eessaa tigiyaageetu halaqai Yooseefa hassayibeenna; dogi aggiis. ");
INSERT INTO wal_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Naa77u laitta kumettai aadhdhido wode, Gibxxe kawoi aimo aimottiis; aimuwan i Naile SHaafaa doonan eqqiis; ");
INSERT INTO wal_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","eqqidaashin laappun orddenne modhdho miizzati Naile SHaafaappe kiyi wodhdhidi, shombboquwaa giddon miishin be7iis. ");
INSERT INTO wal_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Etappe simmin, hara laappun meraa iitanne gilqqa miizzati Naile SHaafaappe kiyidosona; kiyidi shaafaa doonan de7iya hara miizzatu matan eqqidosona. ");
INSERT INTO wal_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","He meraa iitanne gilqqa miizzati laappun orddenne modhdho miizzata miidosona. Hegaappe guyyiyan kawoi beegottiis. ");
INSERT INTO wal_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","I zaaretti xiskkidi, naa77antto aimuwaakka aimottiis; laappun lo77onne muruta tiyati issi anuwan diccidosona. ");
INSERT INTO wal_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Etappe simmin, shoggettidanne arshsho bagga carkkuwan shullida hara laappun tiyati kiyidosona. ");
INSERT INTO wal_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","He shoggettida tiyati lo77onne muruta tiyata mittidosona. Hegaappe guyyiyan kawoi beegottidi, aimo gidiyoogaa eriis. ");
INSERT INTO wal_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sa7ai wonttin, a wozanai shabbirettiis; hegaa gishshau Gibxxen de7iya bitanchchatu ubbaunne aadhdhida eranchchatu ubbau kiittidi xeesissiis; kawoi etayyo ba aimuwaa yootiis; shin ayyo he aimuwaa birshshiyaabi xayiis. ");
INSERT INTO wal_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Eessaa tigiyaageetu halaqai he wode Gibxxe kawuwaa hagaadan yaagiis; “Taani ta mooruwaa hachchi hassayais. ");
INSERT INTO wal_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Issitoo kawoi ba ashkkaratuyyo hanqqettidi, tananne oittaa uukkiyaageetu halaqaa qasho keettan yeggiis. ");
INSERT INTO wal_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yan de7iiddi nuuni huuphiyan huuphiyan aimo aimottida; aimuwaayyo dumma dumma birshshettai de7ees. ");
INSERT INTO wal_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","He wode naagiyaageetu halaqaa ashkkarai, Ibraawe wodallai nunaara qasho keettan de7ees. Nuuni nu aimuwaa ayyo yootida; yootin i nuuyyo huuphiyan huuphiyan aimuwaa birshshiis. ");
INSERT INTO wal_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yaanin he yohoti i nuuyyo birshshidoogaadankka hanidosona. Hegee aibee giikko, taani ta sunttatettau simmaas; hinkko bitanee kaqettiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yaagin Gibxxe kawoi Yooseefayyo kiittidi xeesissiis. Eti a qasho keettaappe eesuwan ehiidosona. I meedettidi ba maayuwaa laammidi, kawuwaakko geliis. ");
INSERT INTO wal_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Gelin kawoi Yooseefa, “Taani aimo aimottaas; shin a issoinne birshshanau danddayibeenna. SHin taani, ‘Yooseefi aimo siyikko, birshshanau danddayees’ giyoogaa siyaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yaagin Yooseefi, “Taani hegaa danddayikke; shin Xoossai kawuwaayyo likke birshshettaa immana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Yaagin kawoi, “Taani ta aimuwan Naile SHaafaa doonan eqqidaashin, ");
INSERT INTO wal_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","laappun orddenne modhdho miizzati Naile SHaafaappe kiyidi, shombboquwaa giddon moosona. ");
INSERT INTO wal_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Etappe simmin, hara laappun meraa iita, gilqqanne laafa miizzati kiyidosona; taani hegaa mala meraa iita miizza Gibxxe biittan mulekka be7a erikke. ");
INSERT INTO wal_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Meraa iitanne laafa miizzati koiroogeeta, laappun modhdho miizzata miidosona. ");
INSERT INTO wal_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","SHin eta miidoogaappe guyyiyankka, eti miidobaa ooninne eranau danddayibeenna; aissi giikko, eta merai kaseegaadankka iiti uttiis. Hegaappe guyyiyan taani beegottaas. ");
INSERT INTO wal_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Taani ta aimuwan qassi laappun lo77onne muruta tiyata issi anuwan diccidaageeta be7aas. ");
INSERT INTO wal_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Etappe simmin, shoggettidanne arshsho bagga carkkuwan shullida hara laappun tiyati kiyidosona. ");
INSERT INTO wal_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","He shoggettida tiyati laappun lo77o tiyata mittidosona. Taani ha aimuwaa bitanchchatuyyo yootaas; shin taayyo aimuwaa birshshiyaabi beettibeenna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Hegaappe guyyiyan Yooseefi Gibxxe kawuwaa, “Kawuwaa aimoti issuwaa. Xoossai ba oottana haniyoobaa kawuwaayyo qonccissiis. ");
INSERT INTO wal_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","He laappun lo77o miizzati laappun laittata; qassi laappun lo77o tiyati laappun laittata; ha aimoi issuwaa. ");
INSERT INTO wal_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","He laappun meraa iitanne laafa miizzati laappun laittata; qassi arshsho bagga carkkuwan shullida, pattenna laappun tiyati laappun kosha laittata. ");
INSERT INTO wal_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Taani kawuwaayyo yootidoogaadankka, Xoossai ba oottana haniyoobaa kawuwaa bessiis. ");
INSERT INTO wal_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Laappun daro kalo laittati Gibxxe biittau ubbau yaana; ");
INSERT INTO wal_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","shin laappun kosha laittai hegaa kaallana. He wode Gibxxe kaloi ubbai dogettana; koshai biittaa xiixxana. ");
INSERT INTO wal_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","He biittaa kaloi hassayettennan attana; aissi giikko, hegaa kaallida koshai keehi suullana. ");
INSERT INTO wal_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Naa77u ogiyan kawuwaayyo he aimoi beettidoi aibissee giikko, ha yohuwaa Xoossai minttidi kuuyido gishshassa; Xoossai hegaa eesuwan oottana. ");
INSERT INTO wal_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ha77i simmi, kawoi aadhdhida eranne cincca asa koyidi, Gibxxe biittan suntto. ");
INSERT INTO wal_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kawoi biittan sunttata laappun kalo laittan qoxxiyo kattaappe ichchashu kushiyaappe issuwaa shiishshanau suntto. ");
INSERT INTO wal_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Eti yiya kalo laittatun kattaa shiishshidi, kawuwaa aawatettan minjjona; he kattaa katamatun naagona. ");
INSERT INTO wal_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Biittai koshan xayenna mala, ha kattai Gibxxe biittan laappun laittan denddana koshaayyo minjjettidi de7o” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yaagin ha yohoi Gibxxe kawuwaayyoonne a oosanchchatuyyo lo77o gididi beettiis. ");
INSERT INTO wal_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hegaa gishshau kawoi eta, “Nuuni Xoossaa Ayyaanaara de7iya hagaa mala hara asa demmaneeyye?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hegaappe guyyiyan kawoi Yooseefa, “Xoossai hagaa ubbaa nena erissido gishshau, ne mala aadhdhida erinne cincci ooninne baawa. ");
INSERT INTO wal_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Taani nena ta keettan sunttais; ta asai ubbai neeyyo azazettana; taani neeppe aadhdhanai ta kawotaa araataa xalaalaana gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Hegaa gishshau kawoi Yooseefa, “Be7a; taani nena Gibxxe biittaa ubbaa bollan sunttaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Hegaappe guyyiyan, kawoi ba paramiyo migiduwaa ba biradhdhiyaappe kessidi, Yooseefa biradhdhiyan wottiis. Liinuwaappe dadettida maayuwaa i a maizzidi, a qooriyankka worqqa sanssalataa aattiis. ");
INSERT INTO wal_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kawoi ba naa77antto paraa gaariyaa Yooseefa togissiis; ashkkarati, “Ziggite! Ziggite!” yaagiiddi appe sinttaara hemettidosona. Hagaadan oottidi, kawoi a Gibxxe biittaa ubbaa bollan sunttiis. ");
INSERT INTO wal_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hegaappe guyyiyan kawoi Yooseefa, “Taani kawuwaa; shin neeni dentto geennan Gibxxe biitta ubban ooninne kushe woi toho denttenna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kawoi Yooseefa, “Xaafinaati-Pa7inaaha” giidi sunttiis; i ayyo Ooni giyo katamaa qeesiyaa PHoxiifeera na7iyo Asinaato machcho immiis. Yaanin Yooseefi Gibxxe biittaa ubbasaara kanttiis. ");
INSERT INTO wal_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yooseefi Gibxxe kawuwaayyo oottanau doommiyo wode, ayyo laittai hasttama. Qassi Yooseefi kawuwaa sinttappe kiyidi, Gibxxe biittaa ubbaa gidduwaa hemettiis. ");
INSERT INTO wal_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","He laappun kalo laittatun biittai daro kattaa mokkiis. ");
INSERT INTO wal_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yooseefi Gibxxe biittan he laappun kalo laitta kattaa ubbaa shiishshidi, katamatun minjjiis. Issi issi katamaa yuushuwan de7iya goshshaa kattaa ubbaa he katamatun minjjiis. ");
INSERT INTO wal_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yooseefi abbaa shafiyaa keena daro kattaa minjjiis; kattai darin, makkanau danddayibeenna gishshau, makki makki qoliyoogaa aggi bayiis. ");
INSERT INTO wal_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kosha laittai yaanaappe kase, Oona katamaa qeesiyaa PHoxiifeera na7ee Asinaatippe Yooseefi naa77u attuma naata yeliis. ");
INSERT INTO wal_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yooseefi ba baira na7aa Minaasa sunttiis; aissi giikko i, “Xoossai tana ta metuwaa ubbaanne ta aawaa so asaa ubbaa dogissiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Naa77antto na7aa Efireema sunttiis; aissi giikko, i, “Xoossai taayyo ta tuggatido biittan tana aifissiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Gibxxe biittan de7iya he laappun kalo laittati wuridosona. ");
INSERT INTO wal_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Qassi Yooseefi yootidoogaadan laappun kosha laittati doommidosona. Hara biittan ubban koshai denddiis; shin Gibxxe biitta ubban kattai de7ees. ");
INSERT INTO wal_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gibxxe biittai ubbai koshatido wode, asai kattau kawuwaayyo waassiis. Waassin kawoi Gibxxe asaa ubbaa, “Yooseefakko biite; biidi i yootiyoobaa oottite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Koshai Gibxxe biittaa ubbaa gakkido wode, Yooseefi kattaa minjjido keettata ubbaa dooyidi, kattaa Gibxxe asau baizziis; aissi giikko, Gibxxen koshai suulliis. ");
INSERT INTO wal_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sa7a ubban koshai suullido gishshau, sa7an de7iya asai ubbai kattaa Yooseefappe woommanau Gibxxe yiis. ");
INSERT INTO wal_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaaqoobi Gibxxen kattai de7iyoogaa siyido wode, ba attuma naata, “Intte issoi issuwaa aissi xeelleetii? ");
INSERT INTO wal_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Be7ite! Gibxxen kattai de7iyoogaa taani siyaas; yaa duge biidi, nuuni haiqqennan paxa de7ana mala, yaappe amaridabaa nuuyyo woommite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yaagin Yooseefa ishantti tammati kattaa woommanau duge Gibxxe biidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","SHin Yaaqoobi Yooseefa ishaa Biniyaama a ishanttuura yeddibeenna; aissi giikko, i qohettanaakkonne giidi qoppiis. ");
INSERT INTO wal_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaane biittan wolqqaama koshai de7iyo gishshau, kattaa woommanau yiidaageetuura Israa7eela attuma naati Gibxxe gelidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","He wode Yooseefi he biittaa aissiyaagaanne biittan de7iya asau ubbau kattaa baizziyaagaa; hegaa gishshau Yooseefa ishantti gakkido wode, bantta som77uwaa sa7aa gattidi ayyo ziggidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yooseefi ba ishantta be7osaara eri bayiis; shin i eta erennabaadan harshshuushiis; i eta, “Intte awappe yiidetii?” yaagidi oichchiis. Oichchin eti, “Katta woommanau, Kanaane biittaappe yiida” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yooseefi ba ishantta eriis; shin eti a eribookkona. ");
INSERT INTO wal_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Hegaappe guyyiyan, Yooseefi etabaa aimottido ba aimuwaa hassayidi eta, “Intte wochchi xeelliya asa; intte nu biittan naagoi leppiyo baggai augaakko be7anau yiideta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yaagin eti, “CHii, nu godau, nuuni wochchi xeelliya asa gidokko; nuuni ne ashkkarati kattaa woommanau yiida. ");
INSERT INTO wal_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nuuni ubbaikka issi aawaa naata. Nuuni ne ashkkarati ammanettiya asa” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yaagin Yooseefi eta, “CHii; intte nu biittan naagoi leppiyo baggai augaakko be7anau yiideta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","SHin eti, “Nuuni ne ashkkarati tammanne naa77u ishanttanne Kanaane biittan de7iya issi bitaniyaa naata. Wurssetta kaaloi ha77i nu aawaara de7ees; issoi xayiis” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yooseefi eta, “Taani intteyyo yootidoogaadankka intte biittaa wochchiyaageeta. ");
INSERT INTO wal_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Qassi intte paacettanaagee hagaana; tumuppe kawoi haiqqo; intte wurssetta kaalo ishai hagaa yaana xayikko, intte ha sohuwaappe beekketa. ");
INSERT INTO wal_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Intte yootiyoogee tuma gidiyoogaa paaccanau, intteppe issuwaa kiittite; i intte ishaa ekkidi yo; attidaageeti qasho keettan qashettishsheeta. Hegaa gidana xayikko, kawoi haiqqo; intte biittaa wochchiyaageeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yaagidi eta heezzu gallassau qasho keettan yeggiis. ");
INSERT INTO wal_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Heezzantta gallassan Yooseefi eta, “Taani Xoossau yayyiya asa; intte issibaa oottikko, paxa de7ana. ");
INSERT INTO wal_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Intte tumukka ammanettiya asa gidikko, intte ishanttuppe issoi hagan qasho keettan de7o; attidaageeti namisettiya intte so asau kattaa ekkidi efiite; ");
INSERT INTO wal_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","shin intte qaalaa tumayana malanne intte haiqqenna mala intte intte wurssetta kaalo ishaa taakko ehaana koshshees” yaagiis. Etinne ha yohuwaa maayidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Eti issoi issuwaa, “Tumu nuuni nu ishau oottidobai nuna kaa7ees. I ba shemppuwaayyo haniyoobai ixxin, nuussi watiwatiyo wode, nuuni siyiiddi ixxida; ha waayee nuna gakkidoogee hegaa gishshassa” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Roobeeli, “Taani inttena, ‘Na7aa bolli nagara oottoppite’ gaada yootabeikkinaa? SHin intte siyennan ixxideta. Simmi ha77i, a suuttai nuna achchees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Eti giyoobaa Yooseefi eridoogaa eti akeekibookkona; aissi giikko, i etaara wokkaaliyan haasayees. ");
INSERT INTO wal_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","I etappe wora simmidi yeekkiis; shin qassi etakko simmidi, etayyo gujjidi haasayiis. I Simoona etappe duutti ashshidi eti be7ishin qachchiis. ");
INSERT INTO wal_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yooseefi ba ashkkarata, “Kattaa eta ogoruwaa kunttite; eta biraakka zaaridi, eta ogoruwan ogoruwan wottite; qassi etau ogiyaassi shinqqiyaa immite” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Azazin i giidoogaadan oottidoogaappe guyyiyan, Yooseefa ishantti kattaa bantta haretun caanidi, denddidi biidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Eti qammaa aqanau simmidosan etappe issoi ba hariyaayyo kattaappe yegganau ba ogoruwaa birshshidi, he ogoruwaayyo doonan de7iya ba biraa be7iis. ");
INSERT INTO wal_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Be7idi i ba ishantta, “Ta birai taayyo simmiis; tumu hagaa be7ite! Ta ogoruwan de7ees” yaagiis. Eta wozanai taahin, kokkoriiddi issoi issuwaakko simmidi, “Xoossai nu bolli oottidobi hagee aibee?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Eti Kanaane biittan de7iya bantta aawaa Yaaqoobakko yiido wode, banttana gakkidabaa ubbaa ayyo odidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Eti ayyo, “He biittaayyo goda gidiya bitanee nuna harshshuushiis. Hegaappe guyyiyan, i nuna he biittaa wochchiyaabaadan godatiis. ");
INSERT INTO wal_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","SHin nuuni a, ‘Nuuni ammanettiya asa; biittaa wochchiyaageeta gidokko. ");
INSERT INTO wal_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nuuni tammanne naa77u ishantti issi aawaa naata; issoi xayiis; wurssetta kaaloi Kanaane biittan ha77i nu aawaara de7ees’ yaagida. ");
INSERT INTO wal_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Yaagin he biittaayyo goda gidiya bitanee nuna, ‘Intte ammanettiya asa gidiyoogaa taani hagan erana; intte ishanttuppe issuwaa hagan ta matan yeggidi, namisettiya intte so asaayyo kattaa ekkidi biite. ");
INSERT INTO wal_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Intte biittaa wochchiyaageeta gidennan, ammanettiya asa gidiyoogaa taani erana mala, intte wurssetta kaalo ishaa taakko ekki yiite. Yaatikko taani han attida intte ishaa intteyyo zaarada immana; inttenne ha biittan zal77eeta’ giis” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Eti bantta ogoruwaappe kattaa qoliiddi, bantta ogoruwan ogoruwan bantta biraa qashuwaara uttidaagaa demmidosona. Etinne eta aawai he qashuwaara de7iya biraa be7idi yayyidosona. ");
INSERT INTO wal_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Eta aawaa Yaaqoobi eta, “Intte tana ta naatuppe mela kessideta; Yooseefi baawa, Simooni baawa; qassi intte Biniyaama efaana koyeeta. Ubbabai taayyo tiraara sitti giis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hegaappe guyyiyan Roobeeli ba aawaa, “Taani Biniyaama neeyyo zaarada ehaana xayikko, ta attuma naata naa77aakka wora; tana ammanettada a ta kushiyan wotta; qassi taani a zaarada ehaana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","SHin Yaaqoobi eta, “Ta na7ai inttenaara yaa duge beenna; a ishai haiqqiichchin, attidaagee a xalaala; intte efishin, ogiyan iitabi a gakkiyaabaa gidikko, intte ta puuluntta huuphiyaa azzanuwaara duufuwan yeggana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ha77inne koshai Kanaane biittan wolqqaamiis. ");
INSERT INTO wal_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yaanin eti Gibxxeppe ehiido kattaa ubbaa mi wurssirggin, eta aawai, “Qassikka guyye biidi nuuyyo amarida katta woommite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","SHin Yihudai a, “He bitanee nuna, ‘Intte ishai inttenaara yaana xayikko, ta som77uwaa zaari be7ekketa’ yaagidi mintti yootiis. ");
INSERT INTO wal_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Neeni nu ishaa nunaara yeddikko, nuuni duge biidi neeyyo kattaa shammana. ");
INSERT INTO wal_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","SHin neeni a yeddennabaa gidikko, nuuni duge bookko; aissi giikko, he bitanee nuna, ‘Intte ishai inttenaara xayikko, intte ta som77uwaa zaari be7ekketa’ giis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yaagin Israa7eeli, “Intte, ‘Nuuyyo hara ishai de7ees’ giidi odidi ha metuwaa ta bolli aissi ehiidetii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yaagin eti a, “He bitanee nubaanne nu so asaabaa mintti oichchiis. I nuna, ‘Intte aawai ha77inne paxa de7ii? Intteyyo hara ishi de7ii?’ yaagidi oichchiis. Oichchin nuuni i oichchidoogaa ayyo zaarida. I nuna, ‘Intte ishaa duge haa ehiite’ gaanabaa nuuni aibin eranee?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yihudai ba aawaa Israa7eela, “Nuunikka neenikka nu naatikka paxa de7ana malanne haiqqennan attana mala, na7aa tanaara yedda; nuuni sohuwaara baana. ");
INSERT INTO wal_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Na7aa ta waasetettan imma; aban tana oichcha; taani a neeyyo saro zaarada ehaana xayikko, ta de7o ubban ne qanggettai tana gakko! ");
INSERT INTO wal_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nuuni gam77ibeennabaa gidiyaakko, hannoode naa77anttuwaa yaa gakkidi simmana shin” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Hegaappe guyyiyan eta aawai Israa7eeli eta, “Hegaa gidikko, yaatite; he bitaniyaassi kushe genttiyoobaa ha biittan mokkidabaa ubbaappe lo77iyaabaa doorite; hegeenne balasaane giyo xaliyaa, eessaa, sawuwaa, karbbiyaanne temire lauze giyo mittatu teeraa intte ogoruwan yeggidi ekki biite. ");
INSERT INTO wal_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Intte ogoruwaa doonan simmida birai balettidabaa gidanau danddayiyo gishshau, biraakka naa77u kushe oottidi ekki biite. ");
INSERT INTO wal_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Qassi intte ishaanne ekkidi, he bitaniyaakko eesuwan guyye biite. ");
INSERT INTO wal_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","I hinkko intte ishaa yeddana mala, Biniyaaminne inttenaara yaana mala, Ubbaa Danddayiya Xoossai he bitanee intteyyo qarettanaadan ootto. Tana gidikko, ta naatuppe mela attikkonne attaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hegaa gishshau he asati immiyoobatanne naa77u kushe biraanne qassi Biniyaamanne ekkidosona. Eti duge Gibxxe biidi, Yooseefa sintti shiiqidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yooseefi Biniyaama etaara be7ido wode, ba keettaa halaqaa, “He asata ta soo ekkada ba; issi mehe shukkada giigissa; eti seeta gallassan laaxaa tanaara moosona” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yaatin i Yooseefi ayyo yootidoogaadan he asata Yooseefa soo efiis. ");
INSERT INTO wal_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Asati Yooseefa soo biido gishshau, yayyidosona; eti, “Nuuni hagaa yiidoi koiro nu ogoruwaara simmidi biida biraa gishshaassa; i nuna wadhdhanau, ailletettan haaranaunne nu hareta ekkanau hanees” yaagidi qoppidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hegaa gishshau eti Yooseefa keettaa pengge gakkidi, keettaa halaqaa haasayissidosona; ");
INSERT INTO wal_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ta godau, nuuni koiro kattaa woommanau hagaa yiida; ");
INSERT INTO wal_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","simmiiddi nuuni qammaa aqiyoosan ogoruwaa birshshidi, huuphiyan huuphiyan nu birai paccennan nu ogoruwaa doonan de7iyaagaa demmida; hegaa gishshau ha77i nuuni a guyye ekkidi yiida. ");
INSERT INTO wal_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Qassi nuuni kattaa woommanau hara biraakka ehiida. Nu biraa nu ogoruwaa ogoruwaa doonan ooni wottidaakkonne erokko” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yaagin i eta, “Hegee aikkobaa; yayyoppite! Intte Xoossai, intte aawaa Xoossai, intte ogoruwaa giddon intteyyo biraa immiis; taani intte biraa ekkaas” yaagiis. Hegaappe guyyiyan, i Simoona etakko kessiis. ");
INSERT INTO wal_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","He bitanee he asata Yooseefa soo efiidi, eta tohuwaayyo haattaa ehin, bantta tohuwaa meecettidosona. Eta haretuyyo harqquwaa yeggiis. ");
INSERT INTO wal_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Yooseefi seeta gallassi yin immanau, eti bantta immiyoobaa ayyo giigissidosona; aissi giikko, eti yan maanaagaa siyi uttidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yooseefi ba soo gelido wode, eti soo ehiido bantta immiyoobaa son ayyo immidosona; eti a sinttan sa7aa gakkidi ziggidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I eta sarotettaa oichchi simmidi, “Intte taayyo yootido intte aawai ceegai lo77oo? Ha77inne i paxa de7ii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yaagin eti, “Ee, ne ashkkarai, nu aawai ha77ikka paxa de7ees; i lo77o” yaagidi hokkidi ayyo ziggidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","I ba aayee na7aa Biniyaama be7ido wode eta, “Intte yootido wurssetta kaalo intte ishai hagee?” yaagiis. Qassi i Biniyaama, “Ta na7au, nena Xoossai anjjo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yooseefi a ishai ayyo gomppan michchido gishshau, yeekkanau issisaa lauhu giis. I ba dumma qol77uwaa gelidi yan yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","I ba som77uwaa meecettiichchidoogaappe guyyiyan kiyidi, bana minttettidi, “Qumaa aattite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Eti ayyo dumma, he ishanttayyo dumma, hegan aara miya Gibxxe asatuyyo dumma aattidosona; aissi giikko, Gibxxe asati Ibraawe asatuura issippe mookkona. Hegee Gibxxe biittaa asata sheneyiyaabaa. ");
INSERT INTO wal_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Eti Yooseefa sinttan bairai ba bairatettaadan, kaaloi ba kaalotettaadan maaran uttidosona. Eti issoi issuwaa xeellidi, eta waati utissidaakko be7idi garamettidosona. ");
INSERT INTO wal_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yooseefa maaddaappe etau qumaa gishiyo wode, Biniyaamayyo gakkidaagee haratuugaappe ichchashu kushe darees; yaatin eti ufaittiiddi aara miidosonanne uyidosona. ");
INSERT INTO wal_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yooseefi ba keettaa halaqaa, “Neeni ha asatu ogoroi ekkiyoogaa keena kattaa etayyo kuntta; eta ubbaa biraanne eta ogoruwaa ogoruwaa doonan wotta; ");
INSERT INTO wal_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","yaatada wurssetta kaaluwaa ogoruwaa doonan ta bira wanccaanne a kattaa biraa wotta” yaagidi azaziis; azazin i Yooseefi giidoogaadan oottiis. ");
INSERT INTO wal_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sa7ai wonttin he asati bantta hareta ekkidi baanau moisettidosona. ");
INSERT INTO wal_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Eti he katamaappe kiyidi haakki biichchennan de7ishin, Yooseefi ba keettaa halaqaa, “Dendda! Ha asatu geeduwaa kaalla; neeni eta gakkido wode eta, ‘Intte aissi kehaa iitan zaaridetii? ");
INSERT INTO wal_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hagee ta godai uyiyoonne qassi xuurabaa demmiyo wanccaa gidennee? Hagee intte oottidobai hanttaaraba’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yaagin i eta geeduwaa gakkidi, ha giidoogaadankka etayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","SHin eti, “Ta godai hagaa mala qaala aissi haasayii? Hegaa malabaa oottiyoogee nuuppe ne ashkkaratuppe haakko! ");
INSERT INTO wal_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nuuni harai atto nu ogoruwaa doonaappe demmido biraa addaa Kanaane biittaappe guyye neeyyo zaari ehiida. ");
INSERT INTO wal_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ne godaa keettaappe nuuni worqqa woi bira waati wuuqqiyoonii? Ne ashkkaratu giddon he wanccai beettido uri haiqqo; qassi attida nuuni nu godaayyo aille gidana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","I eta, “Hegaa gidikko lo77o; intte giidoogaadan gido bayin; wanccaa ekkida ooninne ta aille gidana; hinkko attida intte boriyaappe saro attana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hegaappe guyyiyan, eti eesuwan bantta ogoruwaa ogoruwaa sa7an wottidi birshshidosona. ");
INSERT INTO wal_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Birshshin he halaqai ubbaappe bairatiyaagaa ogoruwaappe doommidi wurssetta kaaluwaagaa gakkanaassi koyiis; he wanccaanne Biniyaama ogoro giddoppe demmiis. ");
INSERT INTO wal_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Hegan eti azzanidi, bantta maayuwaa pooshshidosona; bantta ogoruwaa bantta haretun caanidi, guyye katamaa simmidosona. ");
INSERT INTO wal_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yihudai ba ishanttuura Yooseefakko geliyo wode, Yooseefi son de7ees; eti a sinttan sa7an gufannidosona. ");
INSERT INTO wal_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yooseefi eta, “Intte aiba palabaa oottidetii? Ta mala asi xuurabaa demmiyoogaa erekketiiyye?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yaagin Yihudai, “Ta godaayyo nuuni ai gaanee? Nuuni ai haasayanee? Woikko nuuni xillo gidiyoogaa waati bessanee? Xoossai ne ailletu mooruwaa qonccissirggiis. Simmi nuunikka he wanccai appe beettidoogeekka ta godaayyo aille gidida” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","SHin Yooseefi, “Hagaa malabaa oottiyoogee taappe haakko; ta wanccai appe beettido bitaniyaa xalaalai ta aille gidana. Hinkko intte intte aawaakko guyye saro simmite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yaagin Yihudai akko shiiqidi a, “Ta godau, taani issi qaala haasayana mala nena woossais; tana ne ailliyaa hanqqettoppa; aissi giikko, neeni kawuwaa mala. ");
INSERT INTO wal_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Neeni ta godai nuna ne ailleta, ‘Intteyyo aawi de7iiyye woikko ishi de7ii?’ yaagada oichchadasa. ");
INSERT INTO wal_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nuuninne, ‘Nuuyyo ceeggida aawai de7ees; i ceeggiichchidi yelido kaalo na7aikka de7ees; he na7aa ishai haiqqiis; ba aayeeyyo issi a xalaalai attiis; a aawai a siiqees’ yaagida. ");
INSERT INTO wal_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Neeni ne ailleta, ‘Taani a be7ana mala taayyo ehiite’ yaagadasa. ");
INSERT INTO wal_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Yaagin nuuni ta godaa, ‘He na7ai ba aawaappe shaahettanau danddayenna; shaahettikko a aawai haiqqana’ yaagida. ");
INSERT INTO wal_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","SHin neeni ne ailleta, ‘Intte kaalo ishai inttenaara duge yaana xayikko, naa77antto ta som77uwaa be7ekketa’ yaagadasa. ");
INSERT INTO wal_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nuuni ne ailliyaa nu aawaakko simmidi biido wode, ta godai giidoogaa ayyo yootida. ");
INSERT INTO wal_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Yootin nu aawai, ‘Guyye biidi amarida katta woommite’ yaagin, ");
INSERT INTO wal_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","nuuni a, ‘Nuuni nu kaalo ishai nunaara biikkoppe attin, duge baanau danddayokko; aissi giikko, nu ishai kaaloi nunaara beennabaa gidikko, nuuni he bitaniyaa som77uwaa be7anau danddayokko’ yaagida. ");
INSERT INTO wal_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Yaagin nu aawai ne aillee nuna, ‘Ta keettaayyiyaa Raaheela taayyo naa77u attuma naata yelidoogaa intte ereeta; ");
INSERT INTO wal_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","etappe issoi taappe shaahettidi bin, “Tumu a do7i zaazzidi miis” yaagaas; hachchi gakkanaassikka taani a be7abeikke. ");
INSERT INTO wal_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Hagaa qassi intte taappe shaakki efin, iitabi a gakkikko, intte ta puuluntta huuphiyaa azzanuwaara duufuwan yeggana’ yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Hegaa gishshau, ha77i taani guyye ne ailliyaa ta aawaakko biyo wode, ta aawai, na7aa ba shemppuwaadan siiqiyaagee, na7ai nunaara bainnaagaa be7ikko haiqqi aggana. Nuuni ne ailleti nu aawaa puuluntta huuphiyaa azzanuwaara duufuwan yeggoos. ");
INSERT INTO wal_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Taani ne aillee na7aa ta waasetettan ekkaas; taani a, ‘Ta aawau, taani a neeyyo saro zaarada ehaana xayikko, ta de7uwaa ubban ne qanggettai tana gakko!’ yaaga wottaas. ");
INSERT INTO wal_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Yaanido gishshau, taani ne aillee ta godaayyo na7aa gishshaa ailletada, hagan attin, na7ai ba ishanttuura guyye simmo. ");
INSERT INTO wal_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na7ai bainnan taani waanada guyye ta aawaakko simmanee? CHii, tana ta aawai seelettana seelaa bessoppa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","He wode Yooseefi he asaa ubbaa sinttan genccana danddayibeenna; “Asa ubbaa ta sinttappe kessite” yaagidi waassiis. Hegaa gishshau Yooseefi bana ba ishanttuyyo erissido wode, aara ooninne baawa. ");
INSERT INTO wal_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I ba qaalaa xoqqissidi, Gibxxeti a siyana gakkanaassi keehi yeekkiis. Kawuwaa so asai he woriyaa siyiis. ");
INSERT INTO wal_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yooseefi ba ishantta, “Taani Yooseefattennee! Ta aawai hanno gakkanaassi paxa de7iiyye?” yaagidi oichchiis. SHin a ishantti keehi dagammido gishshau, ayyo zaarana danddayibookkona. ");
INSERT INTO wal_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yaanin Yooseefi ba ishantta, “Taakko haa shiiqite” yaagiis. Yaagin eti akko shiiqidosona; shiiqin i eta, “Taani intte ishaa Yooseefa, intte Gibxxe biittau baizzidoogaa. ");
INSERT INTO wal_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Qassi intte tana hagau baizzido gishshau, zil77ettoppitenne yiillotoppite; aissi giikko, Xoossai tana intteppe sinttau kiittidoogee asaa shemppuwaa ashshanaassa. ");
INSERT INTO wal_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ha biittaa koshai geloosappe naa77antto laitta; qassi yiya ichchashu laittatun asi goyenna woikko cakkenna. ");
INSERT INTO wal_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","SHin taani sa7an intteyyo zeretta ashshana malanne intte de7uwaa gita ashettaa ashshana mala, Xoossai tana intteppe sinttau kiittiis. ");
INSERT INTO wal_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Simmi tana ha sohuwaa kiittidaagee Xoossaa gidiyoogaappe attin, inttena gidekketa. I tana Gibxxe kawuwaassi aawa, a aqota ubbaassi godanne Gibxxe biittaa haariyaagaa oottiis. ");
INSERT INTO wal_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ha77i eesuwan guyye ta aawaakko biidi a, ‘Ne na7ai Yooseefi hagaadan yaagees; “Xoossai tana Gibxxe biitta ubbaa bollan goda kessiis; neeni taakko duge haaya; gam77oppa. ");
INSERT INTO wal_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Neeni Geseema biittan uttaasa; qassi neeni, ne naati, ne naatu naati, ne dorssaa wudee, ne miizzaa wudeenne neeyyo de7iyaabai ubbai ta matan de7eeta. ");
INSERT INTO wal_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Biron ichchashu kosha laittati attidosona; nena, ne so asaanne ne mehiyaa koshai oiqqenna mala, taani nena mizana” yaagiis’ yaagite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Qassikka Yooseefi eta, “Inttekka ta ishaa Biniyaamikka, ha inttenaara haasayiyaagee tumu tana Yooseefa gidiyoogaa intte aifiyan be7eeta. ");
INSERT INTO wal_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Taayyo Gibxxe biittan de7iya bonchchuwaa ubbaanne intte be7idobaa ubbaa ta aawaayyo yootite; ta aawaanne eesuwan haa duge ekki yiite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yaagidi ba ishaa Biniyaama qooriyaa qoommidi yeekkiis; Biniyaamikka ba ishaa qoommidi yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yooseefi ba ishantta ubbaa yeridi, eta bollankka yeekkiis. Hegaappe guyyiyan, a ishantti aara haasayidosona. ");
INSERT INTO wal_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yooseefa ishantti yiidoogaa woree kawuwaa keettaa gakkido wode, kawoinne a oosanchchati ufaittidosona. ");
INSERT INTO wal_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kawoi Yooseefa, “Neeni ne ishantta yaatite ga; ‘Intte mehiyaa caanidi, Kanaane biitti simmite; ");
INSERT INTO wal_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","simmidi intte aawaanne intte so asaa ekkidi, guyye taakko haa ehiite. Taani intteyyo Gibxxe biittan ubbasaappe lo77iyaasaa immin, intte ha biittaa modhdhuwaa kaashana’ yaaga. ");
INSERT INTO wal_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Qassikka neeni ne ishantta, ‘Paraa gaariyaa intte naatuyyoonne intte maccaasatuyyo Gibxxeppe ekkidi biite; biidi intte aawaanne ekkidi yiite. ");
INSERT INTO wal_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Gibxxe biittan de7iya ubbaappe aadhdhi lo77iyaabai inttessa gidiyo gishshau, intte aquwau qoppoppite’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yaagin Israa7eela attuma naati giidoogaadan oottidosona. Yooseefi kawoi azazidoogaadan para gaaretanne ogiyaassi shinqqiyaa etau immiis. ");
INSERT INTO wal_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Etayyo ubbaukka huuphiyan huuphiyan ooratta maayuwaa immiis; shin Biniyaamayyo heezzu xeetu xaqara biraanne ichchashu kumetta maayuwaa immiis. ");
INSERT INTO wal_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","I ba aawaayyo yeddidobai hagaa; Gibxxen de7iya ubbabaappe lo77iyaabaa tammu hariyan caanidi, qassi ogiyaassi kattaa, oittaanne hara shinqqiyaa tammu macca haretun caanidi yeddiis. ");
INSERT INTO wal_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yooseefi ba ishantta moissiis. Eti biishin i eta, “Ogiyan biiddi ooyettoppite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Eti Gibxxeppe kiyidi biidosona; Kanaane biittaa biidi, bantta aawaa Yaaqoobakko gakkidosona. ");
INSERT INTO wal_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Eti ayyo hagaadan yaagidi yootidosona; “Yooseefi paxa de7ees! I hegaappenne Gibxxe biitta ubbaa haariyaagaa” yaagidosona; yaagin Yaaqooba dagamai wozanaa bashshido gishshau, eta ammanibeenna. ");
INSERT INTO wal_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","SHin eti Yooseefi banttayyo yootidobaa ubbaa ayyo yootiininne a ekki ehaana mala Yooseefi kiittido para gaareta i be7in, eta aawaa Yaaqooba shemppoi simmiis. ");
INSERT INTO wal_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israa7eeli, “Hegee taayyo gidees; ta na7aa Yooseefi hanno gakkanaassi paxa de7ees! Taani haiqqanaappe kase baada, a be7ana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israa7eeli baayyo de7iyaabaa ubbaa ekki denddidi, Berssaabeha gakkiis; gakkidi i ba aawaa Yisaaqa Xoossaayyo yarshshuwaa yarshshiis. ");
INSERT INTO wal_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Yarshshin Xoossai qammi aimuwan a, “Yaaqoobaa, Yaaqoobaa” yaagiis. Yaagin i, “Yee” giidi koyiis. ");
INSERT INTO wal_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Koyin a, “Taani Xoossaa, ne aawaa Xoossaa; neeni duge Gibxxe baanau yayyoppa; aissi giikko, taani nena yan gita kawotetta kessana. ");
INSERT INTO wal_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Taani nenaara issippe Gibxxe baana; qassi taani ne zerettaa yaappe kessana. Yooseefi ba kushiyan ne aifiyaa shiishshana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hegaappe guyyiyan, Yaaqoobi Berssaabehappe denddiis; Israa7eela attuma naati bantta aawaa Yaaqooba, bantta naatanne bantta maccaasata Gibxxe kawoi etau kiittido paraa gaariyan wottidi efiidosona. ");
INSERT INTO wal_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Eti Kanaane biittan haarido aquwaanne mehe ubbaa efiidosona. Yaaqoobinne a zeretta ubbai aara Gibxxe biidosona. ");
INSERT INTO wal_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","I ba attuma naatanne ba naatu attuma naata, ba macca naatanne ba naatu macca naata, hegeenne ba zerettaa ubbaa banaara Gibxxe efiis. ");
INSERT INTO wal_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israa7eelaara Gibxxe biitti biida Israa7eela naatu sunttai hagaappe kaallidi xaafettidaagaa. Yaaqooba baira na7ai Roobeela; ");
INSERT INTO wal_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Roobeela attuma naati Hanooka, Paalu, Hexiroonanne Karmma. ");
INSERT INTO wal_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simoona attuma naati Yimu7eela, Yaamiina, Ohaada, Yaakiina, Xoohaaranne Kanaane mishiree na7aa SHaa7ula. ");
INSERT INTO wal_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leewi attuma naati Gershshoona, Qahaatanne Maraara. ");
INSERT INTO wal_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yihudaa attuma naati Eera, Oonaana, SHeela, Paareesanne Zaraaha; shin Eerinne Oonaani Kanaane biittan haiqqidosona. Paareesa attuma naati Hexiroonanne Hamuula. ");
INSERT INTO wal_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yisaakoora attuma naati Tolaa7a, Puuwa, Yaashuubanne SHimiroona. ");
INSERT INTO wal_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zaabiloona attuma naati Sereeda, Eloonanne Yaahila7eela. ");
INSERT INTO wal_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hageeti Liya Masphphexoomiyan Yaaqoobau yelido attuma naata; i macca na7iyaa Diino. Hageeti a naatinne naatu naati muleera hasttamanne heezza. ");
INSERT INTO wal_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaada attuma naati Xafoona, Hagga, SHuuna, Exiboona, Eri, Aroodanne Ar77eela. ");
INSERT INTO wal_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseera attuma naati Yimina, Yishiwa, Yishiwaahanne Barii7a; eta michchiyaa Seraaho. Barii7a attuma naati Hebeeranne Malkki7eela. ");
INSERT INTO wal_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Laabaani ba na7ee Liyiyyo immido Zilppa Yaaqoobau yelido naati hageeta; eti muleera tammanne usuppuna. ");
INSERT INTO wal_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yaaqooba keettaayee Raaheeli attuma naati Yooseefanne Biniyaama. ");
INSERT INTO wal_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Oona katamaa qeesiyaa PHoxiifeera na7iyaa Asinaata Yooseefayyo Gibxxen Minaasanne Efireema yelaasu. ");
INSERT INTO wal_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Biniyaama naati Belaa7a, Bekeera, Ashibeela, Geera, Naa7imaana, Eeha, Roosha, Muppiima, Huppiimanne Arada. ");
INSERT INTO wal_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yaaqoobau yelettida Raaheeli attuma naati hageeta; eti muleera tammanne oidda. ");
INSERT INTO wal_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daana attuma na7ai Hushiima. ");
INSERT INTO wal_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nifttaaleema attuma naati Yaahixi7eela, Guuna, Yexeeranne SHiileema. ");
INSERT INTO wal_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Laabaani ba na7ee Raaheeliyyo immido Baala Yaaqoobau yelido naati hageeta; eti muleera laappuna. ");
INSERT INTO wal_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yaaqoobaara Gibxxe biida, a gulbbataappe yelettidaageeti, a naatu keettaayeta gujjennan, muleera usuppun tammanne usuppuna. ");
INSERT INTO wal_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Gibxxen Yooseefayyo yelettida naa77u naata gujjin, Gibxxe biida Yaaqooba so asai muleera laappun tamma. ");
INSERT INTO wal_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Geseema biittan mokkana mala, Yaaqoobi Yihudaa baappe sinttau Yooseefakko kiittiis; eti Geseema gakkido wode, ");
INSERT INTO wal_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yooseefi ba para gaariyaa giigissidi, ba aawaa Israa7eelaara gaittanau Geseema biis. Yooseefi ba aawaa demmidosaarakka a qooriyan xaaxetti qoommidi, daro wodiyaa yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israa7eeli Yooseefa, “Neeni paxa de7ishin, taani ne aifiyaa be7ido gishshau, ha77i taani haiqqikkonne aikkobaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hegaappe guyyiyan, Yooseefi ba ishanttanne ba aawaa so asata, “Taani Gibxxe kawuwaakko baana; baada ayyo, ‘Kanaane biittan de7iya ta ishanttinne ta aawaa so asai taakko yiidosona. ");
INSERT INTO wal_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Eti dorssa henttanchcha; eti mehe heemmoosona; eti banttanaara bantta dorssata, bantta miizzatanne banttayyo de7iyaabaa ubbaa ekkidi yiidosona’ yaagana. ");
INSERT INTO wal_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kawoi inttena xeesissidi, ‘Intte oosoi aibee?’ yaagidi oichchikko, ");
INSERT INTO wal_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","intte ayyo, ‘Nuuni ne ashkkarati naatettaasappe doommidi, nu aawatudankka mehiyaa heemmeettees’ yaagite. Yaagikko i inttena Geseema biittan wottana; aissi giikko, dorssa henttanchcha ubbi Gibxxe asan karettidabaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yooseefi gelidi Gibxxe kawuwaayyo hagaadan yaagidi yootiis; “Ta aawainne ta ishantti, bantta dorssaa wudiyaara, bantta miizzaa wudiyaaranne banttayyo de7iyaabaa ubbaara Kanaane biittaappe yiidi, ha77i Geseema biittan de7oosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","I ba ishanttuppe ichchashata dooridi kawuwaa sintti aattiis. ");
INSERT INTO wal_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kawoi he ishantta, “Intte oosoi aibee?” yaagidi oichchiis. Oichchin eti kawuwaayyo, “Nuuni ne ashkkarati nu aawatuugaadankka dorssa wude heemmoos” yaagidi zaaridosona. ");
INSERT INTO wal_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Qassi eti ayyo, “Kanaane biittan koshai suullido gishshaunne ne ashkkaratu mehiyau miyoobi aibinne bainna gishshau, nuuni hagan amarida wodiyaa daanau yiida; hayyanaa nuna ne ashkkarata Geseeman wottarkkii!” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Yaagin kawoi Yooseefa, “Ne aawainne ne ishantti neekko yiidosona. ");
INSERT INTO wal_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Simmi Gibxxe biittai ne kushiyan de7ees; ha biittan ubbasaappe aadhdhidi lo77iyaasan ne aawaanne ne ishantta wotta; eti Geseema biittan de7ona. Neeni erin, eta giddoppe dumma eratettai de7iyoogeeti de7ikko, hegeeta ta mehiyaa bolli suntta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hegaappe guyyiyan, Yooseefi ba aawaa Yaaqooba gelissidi, kawuwaa sintti aattiis. Yaaqoobi Gibxxe kawuwaa anjjidoogaappe guyyiyan, ");
INSERT INTO wal_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","kawoi Yaaqooba, “Neeyyo woisu laittee?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Oichchin Yaaqoobi kawuwaa, “Taani yuuyaidda de7ido laittai xeetanne hasttama; ta laittai beni ta aawati yuuyiiddi de7ido laittatuppe guuttanne metoi daridoogaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hegaappe guyyiyan, Yaaqoobi kawuwaa anjjidi, a sinttappe kare kiyiis. ");
INSERT INTO wal_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yooseefi ba aawaanne ba ishantta Gibxxe biittan wottiis; kawoi azazidoogaadan Gibxxe biittan Raamisa giyo katamaa matan de7iya, ubbasaappe aadhdhidi lo77iya gadiyaa etau immiis. ");
INSERT INTO wal_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yooseefi qassi ba aawaayyo, ba ishanttuyyoonne ba aawaa so asa ubbau eta naatu qoodaadan kattaa immiis. ");
INSERT INTO wal_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Gidikkonne koshai suullido gishshau, he biitta ubban katti baawa. He koshan Gibxxenne Kanaane biittai naa77aikka qohettidosona. ");
INSERT INTO wal_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yooseefi Gibxxe kattaa baizzidi, Gibxxenne Kanaane biittatun de7iya miishshaa ubbaa shiishshiis; shiishshidi Gibxxe kawuwaa keettaa gelissiis. ");
INSERT INTO wal_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Gibxxenne Kanaane miishshai wurido wode, Gibxxe asai ubbai Yooseefakko yiidi a, “Nuuyyo kattaa imma; nu miishshai wurido gishshau, nuuni ne sinttan aissi haiqqiyoonii?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yaagin Yooseefi eta, “Yaanikko intte mehiyaa ekki yiite; intte miishshai wuriichchidabaa gidikko, taani kattaa intte mehiyaara laammana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hegaa gishshau eti bantta mehiyaa Yooseefayyo ehiidosona. Ehin Yooseefi eta paraa, dorssaa, deeshshaa, miizzaanne hariyaa kattaara laammiis; i he laittaa eta mehiyaa ubbaara kattaa laammiiddi eta mizi shaachchiis. ");
INSERT INTO wal_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","He laittai wurin, eti naa77antta laittan akko yiidi a, “Nuuni nu godaappe qosiyoobi baawa; nu miishsha ubbai wuriichchiis; nu mehiyaakka neessi sheedhdhiichchida; nu bollaappenne nu gadiyaappe attin, nu godaayyo attidabi harabi baawa. ");
INSERT INTO wal_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nuuni ne sinttan aissi haiqqiyoonii? Nu gadeekka aissi xayii? Nunakka nu gadiyaakka kattan shamma; nuuni kawuwaayyo ailletana; nu gadeekka abaa gido; nuuni paxa attana mala, haiqqenna malanne nu gadeekka oxxenna mala, zerettaa nuuyyo imma” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yooseefi Gibxxe biitta ubbaa kawuwaayyo shammiis. Gibxxeti ubbai koshai suullido gishshau, bantta gadiyaa baizzidosona; baizzin gadee kawuwaabaa gidiis. ");
INSERT INTO wal_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yooseefi asa ubbaa Gibxxeyyo ha gaxaappe doommidi hini gaxaa gakkanaassi kawuwaayyo aille kessiis. ");
INSERT INTO wal_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Gidikkonne i qeesetu gadiyaa shammibeenna; aissi giikko, kawoi qeesetuyyo kattaa immees. Hegaa gishshau bantta gadiyaa baizzibookkona. ");
INSERT INTO wal_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yooseefi asaa, “Simmi hachchi taani inttenanne intte gadiyaa kawuwaayyo shammaas. Zerettaa efiidi, gaden zerite. ");
INSERT INTO wal_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","SHin kattaa cakki gelissiyo wode, aifidabaappe ichchashu kushiyaappe issi kushiyaa kawuwaayyo immite. Ichchashu kushiyaappe attida oiddu kushee intte gadiyaa zerettanne intteyyo, intte so asaayyoonne intte naatuyyo quma gido” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yaagin eti, “Neeni nuna ashshadasa! Nu godaa sinttan nuuni sabettorkkoniishsha; nuuni kawuwaayyo ailletana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hegaa gishshau, Yooseefi Gibxxen biittappe aifidabaappe ichchashu kushiyaappe issuwaa kawuwaayyo immiyoogaa higge kessiis. He higgeenne hachchi gakkanaassi eqqidi de7ees. Kawuwaabaa gidibeenna gadee qeesetu gadiyaa xalaala. ");
INSERT INTO wal_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israa7eelati Gibxxe biittan Geseema giyoosan uttidosona; eti yan aqo demmidosona; eti yelettidosonanne daro corattidosona. ");
INSERT INTO wal_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaaqoobi Gibxxe biittan tammanne laappun laitta de7iis. Yaaqoobi de7ido laittai xeetanne oitamanne laappuna. ");
INSERT INTO wal_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israa7eelayyo haiqqiyo wodee matattin, ba na7aa Yooseefa xeesissidi hagaadan yaagiis; “Taani ne sinttan sabettidabaa gidikko, ne kushiyaa ta gulbbatan wottada, neeni taayyo kehanaunne ammanettanau ane geppa. Tana Gibxxen moogoppa; ");
INSERT INTO wal_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","shin taani ta maizzan gaittiyo wode, tana Gibxxeppe efaada, eti moogettidosan mooga” yaagiis. Yaagin Yooseefi, “Taani nena neeni giidoogaadan oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaaqoobi a, “Ane taayyo caaqqa” yaagiis. Yaagin Yooseefi ayyo caaqqiis; hegaappe guyyiyan, Israa7eeli ba hiixan gufannidi, Xoossaassi goinniis. ");
INSERT INTO wal_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hegaappe guyyiyan asai Yooseefassi, “Ne aawai sakettees” yaagidi yootiis. Yootin i ba naa77u attuma naata Minaasanne Efireema ekkidi biis. ");
INSERT INTO wal_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Bin asai Yaaqooba, “Be7a; ne na7ai Yooseefi neekko yiis” yaagiis; yaagin Israa7eeli minettidi ba hiixan uttiis. ");
INSERT INTO wal_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaaqoobi Yooseefa, “Ubbaa Danddayiya Xoossai Kanaane biittan Looza giyoosan taayyo qonccidi, yan tana anjjiis. ");
INSERT INTO wal_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","I tana, ‘Taani nena yeletissananne corayana; taani nena daro dere oottana. Ha biittaa taani neeppe guyyiyan, ne zerettaayyo merinaa laata oottada immana’ yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Simmi ha77i, ne naa77u attuma naati, taani neekko hagaa yaanaappe kase Gibxxen neeyyo yelettidaageeti tabaa; Efireeminne Minaasee taayyo Roobeelanne Simoona mala. ");
INSERT INTO wal_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Etappe guyyiyan neeyyo yelettidaageeti nebaa; eti laattana biittai Efireemanne Minaasa sunttan gido. ");
INSERT INTO wal_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Taani Masphphexoomiyaappe simmishin, Efiraata gakkanau guuttaa ashshidaashin, Raaheela Kanaane biittan haiqqaasu. Haiqqin, taani o Beetaliheeme giyo Efiraataa efiya ogiyaa doonan moogaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israa7eeli Yooseefa attuma naata naa77ata be7ido wode, “Hageeti oonee?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Oichchin Yooseefi ba aawaa, “Hageeti Xoossai taayyo hagan immido ta naata” yaagiis. Yaagin Israa7eeli, “Taani eta anjjana mala, eta taakko haa shiishsha” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israa7eeli cimin a aifee daafurido gishshau, xeellanau danddayenna. Hegaa gishshau Yooseefi ba attuma naata akko shiishshin, a aawai eta idimmidi yeriis. ");
INSERT INTO wal_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israa7eeli Yooseefa, “Taani ne som77uwaa be7ana gaada qoppabeikke; shin Xoossai hekko ne naatakka tana bessiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yooseefi eta a gulbbataappe denttidi, ba som77uwaa sa7aa gattidi ziggiis. ");
INSERT INTO wal_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yooseefi ba naa77u attuma naata, Efireema ba ushachcha baggan Israa7eelau haddirssa baggaara, Minaasa ba haddirssa baggan Israa7eelau ushachcha baggaara ekkidi, akko shiishshiis. ");
INSERT INTO wal_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Efireemi kaalo gidikkokka, Israa7eeli ba ushachcha kushiyaa yeddidi a huuphiyan wottiis; qassi Minaasee baira gidikkokka, Israa7eeli ba kushiyaa qaxiballidi, ba haddirssa kushiyaa Minaase huuphiyan wottiis. ");
INSERT INTO wal_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hegaappe guyyiyan, Yaaqoobi Yooseefa hagaadan yaagidi anjjiis; “Ta aawati Abrahaaminne Yisaaqi a sinttan hemettido Xoossai, ta de7o ubban hachchi gakkanaassi tana heemmida Xoossai, ");
INSERT INTO wal_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","iitabaa ubbaappe tana ashshida kiitanchchai, ha naata anjjo. Ta sunttainne ta aawatu Abrahaamanne Yisaaqa sunttai etan xeesetto. Eti sa7aa bollan corattona” yaagidi anjjiis. ");
INSERT INTO wal_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yooseefi ba aawai ba ushachcha kushiyaa Efireema huuphiyan wottidoogaa be7ido wode dosibeenna. Hegaa gishshau, Efireema huuphiyaappe denttidi, Minaase huuphiyan wottanau ba aawaa kushiyaa oiqqiis. ");
INSERT INTO wal_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Oiqqidi Yooseefi ba aawaa, “Ta aawau, hegaa gidenna; bairai hagaattennee; ne ushachcha kushiyaa hagaa bolli wotta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","SHin a aawai ixxidi a, “Taani erais; ta na7au, taani erais; ikka gita dere gidana. Gidikkonne a kaalo ishai appe aadhdhi gitatana; a zerettaikka daro gita kawotetta gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","I he gallassi eta anjjidi, “Israa7eelati anjjiyo wode, ‘Xoossai inttena Efireemadaaninne Minaasedan ootto’ yaagidi intte sunttan anjjana” yaagiis. Yaatidi Efireema Minaaseppe sinttayiis. ");
INSERT INTO wal_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hegaappe guyyiyan Israa7eeli Yooseefa, “Taani haiqqana hanais; shin Xoossai inttenaara gidana; qassi i intte aawatu biitti inttena guyye zaarana. ");
INSERT INTO wal_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Qassi nena ne ishanttuura gakkiya biittaappe issi saamaa darissada neeyyo immais; hegeenne taani Amooretuppe ta bisuwaaninne ta wonddafiyan ekkido biittaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hegaappe guyyiyan, Yaaqoobi ba attuma naata xeesissidi hagaadan yaagiis; “Sinttappe intteyyo hananabaa taani intteyyo yootana mala shiiqite. ");
INSERT INTO wal_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Inttenoo Yaaqooba naatoo, issippe shiiqidi siyite; intte aawai Israa7eeli intteyyo yootiyoobaa ezggite. ");
INSERT INTO wal_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Roobeelaa, ta baira na7au, neeni ta wolqqaa; ta minotettaayyo koiruwaa. Neeni bonchchuwankka wolqqankka ubbaappe aadhdhiyaagaa. ");
INSERT INTO wal_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Neeni di7o mala; eqqosan de7akka; neeni ubbaappe aadhdhiyaagaa gidakka. Aissi giikko, neeni ne aawaa hiixaa kiyadasa; ne awaa arssaa tunissadasa. ");
INSERT INTO wal_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simooninne Leewi ishantta; eta bisoi makkalatettau ola miishsha. ");
INSERT INTO wal_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Taani eta zoretan gelikke; taani eta shiiquwankka uttikke. Aissi giikko, eti bantta hanqquwan asa woridosonanne banttana ekka ekka gin, boorata gilddayidosona. ");
INSERT INTO wal_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Eta suulo hanqqoinne eta meqettaa iitatettai qanggettidaagaa gido! Taani eta Yaaqooba asaa giddon laalana; Israa7eela biittan piskki oottana. ");
INSERT INTO wal_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yihudau, ne ishantti nena galatana. Ne kushee ne morkketu piillanttiyaa oiqqana. Ne aawaa naati neeyyo hokkidi ziggana. ");
INSERT INTO wal_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yihudau, neeni wodala gaammo. Ta na7au, neeni shankkaappe woridi simmidi, cogochchidi zin77ida gaammo mala. Neeni asi bosherettanau koyenna macca gaammee mala. ");
INSERT INTO wal_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Haariyaagee yaana gakkanaashin, kawotaa xam77ai Yihudaappe, deriyaa haariyaageetu gatimai a toho giddoppe shaahettenna. Qassi dere asai ayyo azazettana. ");
INSERT INTO wal_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","I ba hariyaa woiniyaa anuwan, ba hare maraa muruta woiniyaa turan qachchana. I ba afalaa woiniyaa eessan, ba maayuwaa suutta milatiya woiniyaa eessan meeccana. ");
INSERT INTO wal_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A aifee woine eessaappe aadhdhi dulkkana; a achchaikka maattaappe aadhdhi booxxana. ");
INSERT INTO wal_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zaabiloonee abbaa doonan de7ana; i abbaa doonan markkabeti eqqiyo soho gidana; a zawai Sidoona gakkana. ");
INSERT INTO wal_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Yisaakoori mino hare; caaniyo naa77u joinetuppe gidduwan zin77i bayees. ");
INSERT INTO wal_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","I ba shemppiyoosai lo77o gidiyoogaanne ba biittai ufaissiyaagaa gidiyoogaa be7iyo wode, caanaa tookkanau ba hashiyaa ziqqi oottidi, ailletettaa ooso oottana. ");
INSERT INTO wal_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Daani Israa7eela zaretuppe issuwaa gidiya ba asaa bolli daannatana. ");
INSERT INTO wal_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daani oge doonan de7iya shooshsha; paraa toggidaagee guyye kunddana mala paraa ginddiyaa dukkiya, ogiyan de7iya haso. ");
INSERT INTO wal_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Abeet GODAU, taani neeni ashshanau naagais. ");
INSERT INTO wal_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaadi bonqqiyaageetun deshettana; shin ikka eta paanaa kaallidi eta bonqqana. ");
INSERT INTO wal_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aseera oittai ordde; kawotuyyo i lo77o qumaa immana. ");
INSERT INTO wal_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nifttaaleemi qashettennan yeda de7iya, lo77o marata yeliya genessa. ");
INSERT INTO wal_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yooseefi aifiyaara herxxexxida woine tura. I pulttuwaa matan herxxexxa aifiyaara de7iya, daashshaikka godaappe bollaara zaa7iyo woine tura. ");
INSERT INTO wal_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wonddafiyaa dukkiyaageeti a bolli woraajjidosona; woraajjidi bantta zubbiyan dukkidosonanne muddidosona. ");
INSERT INTO wal_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","A wonddafee minni uttiis; a qeseekka minnidi gam77iis. Hegeenne Yaaqooba Wolqqaamaa kushiyaa gaasuwaana, ne henttanchchaa, Israa7eela Zaallaa gaasuwaana, ");
INSERT INTO wal_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","nena maaddiya ne aawatu Xoossaa gaasuwaananne, nena bolla saluwaa anjjuwan, garssa ciimmaa anjjuwan, xanttaa anjjuwaaninne yeliya uluwaa anjjuwan anjjiya, Ubbaa Danddayiya Xoossaa gaasuwaana. ");
INSERT INTO wal_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ne aawaa anjjoi beni deretu anjjuwaappekka merinaasappe de7iya keratu anjjuwaappekka aadhdhees. Hagee ubbai Yooseefa huuphiyan, ba ishanttu giddon halaqa gidiyaagaa liiphiyan shemppo. ");
INSERT INTO wal_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Biniyaami bonqqiya wanggireello. Ba shankkatidobaa maallado mees; ba omooddidobaa omarssi shaakkees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hageeti tammanne naa77u Israa7eela zareta; qassi eta aawai eta huuphiyan huuphiyan etau bessiya anjjuwaa anjjiiddi etayyo giidobai hagaa. ");
INSERT INTO wal_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Hegaappe guyyiyan, i eta hagaadan yaagidi azaziis; “Taani ta maizza asatun gaittana hanais; tana Hiitiyaa Efiroona gaden de7iya gonggoluwan, ta aawatuura moogite. ");
INSERT INTO wal_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Hegeenne Kanaane biittan, Mamire matan de7iya, Maakipheela giyo gonggoluwaa; hegee Abrahaami moogossi Hiitiyaa Efiroonappe a gadiyaara shammido gonggoluwaa. ");
INSERT INTO wal_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abrahaaminne a keettaayyiyaa Saara yan moogettidosona; Yisaaqinne a keettaayyiyaa Ribiqa yan moogettidosona; taani qassi Liyo yan moogaas. ");
INSERT INTO wal_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","He gadeenne an de7iya gonggoloi Hiitetuppe shamettidaagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaaqoobi ba naatuyyo azazuwaa wurssido wode, ba tohuwaa pude ba hiixau shiishshi ekkidi, haiqqi aggiis; haiqqidi ba maizzan gaittiis. ");
INSERT INTO wal_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yooseefi ba aawaa ahaa bolli kunddidi, yeekkiisinne a yeriis. ");
INSERT INTO wal_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hegaappe guyyiyan, Yooseefi xaliyaa shiishshiya ba oosanchchata ba aawaa Israa7eela ahaa sawiya shittuwaa tiyidi melissana mala azaziis; azazin eti tiyidi melissidosona. ");
INSERT INTO wal_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","SHittuwaa tiyiyoogee oitamu gallassa kumettaa wurssiis; aissi giikko, hegee tiyoi wonikka oitamu gallassaa ekkees. Gibxxe asati ayyo laappun tammu gallassaa yeekkidosona. ");
INSERT INTO wal_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yeeho gallassati aadhdhido wode, Yooseefi Gibxxe kawuwaa keettaa asata, “Taani intte sinttan nashettidobaa gidikko, intte tau kawuwaayyo hagaadan yaagidi odite; ");
INSERT INTO wal_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ta aawai tana issi caaqo caaqissiis; i tana, “Taani haiqqana hanais; taani ta huuphessi Kanaane biittan bookkido gonggolo duufuwan tana mooga” yaagiis. Hegaa gishshau ha77i taani pude baada ta aawaa moogana mala yeddarkkii! Hegaappe guyyiyan taani simmana’ yaagite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yaagin kawoi, “I nena caaqissidoogaadan pude baada ne aawaa mooga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yaagin Yooseefi ba aawaa mooganau pude biis. Kawuwaa oosanchchati ubbai, a kawo keettan de7iya gita asai ubbainne Gibxxe biittan de7iya gita asai ubbai Yooseefa kaallidi biidosona. ");
INSERT INTO wal_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Qassi Yooseefa so asai ubbai, a ishanttinne a aawaa so asai biidosona; eta naati, eta miizzainne eta dorssaa wude xalaalai Geseeman attiis. ");
INSERT INTO wal_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Para gaaretikka paraasatikka aara pude biidosona; a kaallidi biida asai keehi daro. ");
INSERT INTO wal_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Eti Yorddaanoosa SHaafaa matan de7iya Axaadi giyo audiyaa gakkiiddi, bantta qaalaa xoqqu oottidi, ayyo zilaalidosonanne yeekkidosona; yan Yooseefi ba aawaa yeehuwan laappun gallassaa uttiis. ");
INSERT INTO wal_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","He biittan de7iya Kanaane asati Axaadi giyo audiyan he yeehuwaa be7ido wode, “Gibxxeti aiba yibbaata yeeho yeekkiyoonaa!” yaagidosona. Hegaa gishshau Yorddaanoosa matan de7iya he sohoi, Gibxxetu Yeehuwaa geetettiis. ");
INSERT INTO wal_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaaqooba naati bantta aawai eta azazidoogaadan oottidosona; ");
INSERT INTO wal_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","eti a ahaa Kanaane biitti efiidi, Mamire matan de7iya Maakipheela giyo gonggoluwan, Abrahaami Hiitiyaa Efiroonappe mooguwau shammido gadiyan a moogidosona. ");
INSERT INTO wal_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yooseefi ba aawaa moogidoogaappe guyyiyan, ba ishanttuuranne a aawaa mooganau aara biida hara asatu ubbatuura Gibxxe simmiis. ");
INSERT INTO wal_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Eta aawai haiqqiichchidoogaa be7idi, Yooseefa ishantti bantta giddon, “Ooni erii Yooseefi nuna ba uluwan morkkikkonne nuuni ayyo oottido iitabaa ubbaassi halo kessana koyikko, nuuni waananee?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hegaa gishshau Yooseefakko hagaa mala kiitaa kiittidosona; “Ne aawai haiqqanaappe kase; ");
INSERT INTO wal_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Intte Yooseefa, “Neeni ne ishanttu nagaraanne eti nena naaqqido iita naaquwaa hayyanaa atto yaaga” yaagiis giidi odite’ yaagiis. Hegaa gishshau ha77i hayyanaa, nu nagaraa, ne aawaa Xoossaa ashkkaratu nagaraa atto yaaga” yaagidosona. Kiitai baakko gakkido wode, Yooseefi yeekkiis. ");
INSERT INTO wal_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hegaappe guyyiyan a ishantti bantta huuphen akko yiidi, a sinttan gufannidi, “Nuuni ne ailleta” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","SHin Yooseefi eta, “Yayyoppite; tana intteyyo Xoossaa giidetiiyye? ");
INSERT INTO wal_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Intte taayyo iitanau oottideta; shin hachchiigaadan daro asai haiqqennan attana mala, Xoossai lo77otettau hagaa oottiis. ");
INSERT INTO wal_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hegaa gishshau simmi intte yayyoppite; taani inttenanne intte naata mizana” yaagidi, i eta minttettidi keha qaalaa haasayiis. ");
INSERT INTO wal_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yooseefi ba aawaa so asa ubbaara Gibxxen gam77iis; i xeetanne tammu laittaa de7iis; ");
INSERT INTO wal_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Efireema naata, heezzantta yeletaa be7iis; qassi Minaase na7aa Maakiira naatanne i ba naata oottiis. ");
INSERT INTO wal_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hegaappe guyyiyan Yooseefi ba ishantta, “Taani haiqqana hanais; shin Xoossai inttena maaddanau tumu xomoosana; i inttena ha biittaappe kessidi, Abrahaamayyo, Yisaaqayyoonne Yaaqoobayyo immana giidi caaqqido biittaa efaana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yooseefi Israa7eela naata, “Xoossai inttena maaddanau tumu xomoosiyo wode, intte ta meqettaa ha biittaappe pude ekkidi biite” yaagidi caaqissiis. ");
INSERT INTO wal_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yooseefi xeetanne tammu laittaa de7idi haiqqiis; haiqqin, eti shittuwan a ahaa tiyidi melissidoogaappe guyyiyan, Gibxxe biittan saaxiniyan yeggidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yaaqoobaara Gibxxe gelida Israa7eela attuma naatu sunttai hagaappe kaallidi xaafettiis; eti ubbaikka bantta so asaa ekki gelidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Hegeetinne: Roobeela, Simoona, Leewa, Yihudaa, ");
INSERT INTO wal_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yisaakoora, Zaabiloona, Biniyaama, ");
INSERT INTO wal_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daana, Nifttaaleema, Gaadanne Aseera. ");
INSERT INTO wal_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yaaqooba zerettati muleera laappun tamma; Yooseefi kasekka Gibxxe bi uttiis. ");
INSERT INTO wal_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yooseefi, a ishanttinne he yeleta ubbai haiqqiis; ");
INSERT INTO wal_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","shin Israa7eela zerettai aifidosonanne keehi daridosona; he biittaa kumana gakkanaassi eti keehi corattidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hegaappe guyyiyan, Yooseefa erenna ooratta kawoi Gibxxe biittan denddiis. ");
INSERT INTO wal_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","I ba asaa, “Be7ite; ha Israa7eelati nuuppe keehi corattidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Haayite, ane nuuni eta hiillan oiqqoos; hinna xayikko eti kaseegaappe yaa darana. Geelladan oli denddikko, eti nu morkketuura gaittidi, nuna olananne biittaa yeggidi baana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hegaa gishshau, deexo oosuwan eta tuggayana mala, eta bolli meqetti bainna kaabbota sunttidosona. Eti kawuwaayyo Piitoomanne Raamisa giyo aibakko minjjiyo katamata keexxidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","SHin Gibxxeti eta un77uwaa dariyo wode, eti darii yelettidosonanne biittaa gakkidosona. Hegaa gishshau, Gibxxeti Israa7eelatau yayyidosona; ");
INSERT INTO wal_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","yayyidi etau biittaa goggidi ootissidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wolqqaama oosuwan, siminttuwaaninne xuubiyaa meruwan, qassi shooqan oottiyo ubba qommo oosuwan, eta de7uwaa camettidosona; bantta daafurssiya ooso ubbaa qareti bainnan eta ootissidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Gibxxe kawoi Ibraawe maccaasata maaretissiya Xippaaronne Puuho giyo naa77u maccaasata hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ibraawe maccaasati yeliyo wode intte maaretissiiddi, yelettidabi attuma na7a gidikko, worite; shin macca na7a gidikko paxa aggite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","SHin maaretissiyaageeti Xoossau yayyidi, Gibxxe kawoi eta azazidoogaadan oottibookkona. Eti attuma naata paxa ashshidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Hegaappe guyyiyan Gibxxe kawoi he maaretissiyaageeta xeesidi, “Intte aissi hagaadan oottidetii? Attuma naata aissi paxa aggi bayidetii?” yaagidi eta oichchiis. ");
INSERT INTO wal_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Oichchin maaretissiyaageeti zaaridi, “Ibraawe maccaasati Gibxxe maccaasatu mala gidokkona; eti mino gidiyo gishshau, maaretissiyaageeti gakkanaappe kasetidi yeliichchoosona” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Hegaa gishshau, Xoossai maaretissiyaageetussi kehiis. Asaa qoodaikka gujji gujjidi biidi, kaseegaappe yaa corattiis. ");
INSERT INTO wal_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Qassi maaretissiyaageeti Xoossau yayyido gishshau, Xoossai etau eta huuphessi so asaa immiis. ");
INSERT INTO wal_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Hegaappe guyyiyan kawoi ba asaa ubbaa, “Ibraawetuppe yelettiya attuma na7a ubbaa Naile SHaafaa haattan olite; shin macca na7i yelettikko, paxa aggi bayite” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","He wode issi Leewa qommo gidiya bitanee Leewa maccaasa issinniyo ekkiis; ");
INSERT INTO wal_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ekkin a abbe ixettada attuma na7aa yelaasu. Na7ai meraa lo77o na7a gidiyoogaa a be7ada, heezzu agina qosaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","SHin a hegaappe daruwaa qosanau danddayennaagaa erada, ceeccaappe keeshiyaa ayyo daddaasu; daddada renjjiyaaninne shidan meeshada, na7aa a giddon wottaasu; wottada Naile SHaafaa giyo haattaa doonan maqqaa giddon wottaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A michchiyaa i haniyoobaa be7anau haahuwan eqqaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Gibxxe kawuwaa na7iyaa bollaa meecettanau Naile SHaafaa giyo shaafaa wodhdhaasu; i macca ashkkaratinne haattaa doonan yaa haa hemettoosona; a keeshiyaa maqqaa giddon be7ada, baada ekkada yaana mala ba ashkkariyo kiittaasu; ");
INSERT INTO wal_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","keeshiyaa pogada, he guutta na7aa be7aasu. Be7iyo wode i yeekkees; yeekkin a ayyo qarettaasu; a, “Hagee Ibraawetu guutta naatuppe issuwaa” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","He wode a michchiyaa kawuwaa na7iyo, “Neeyyo ha na7aa xanttanau Ibraawe maccaasa issinno ehaanau boo?” yaagada oichchaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Yaagin a, “Ee, ba” yaagaasu. Yaagin na7iyaa baada, he na7aa aayyiyo ehaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kawuwaa na7iyaa he maccaasiyo, “Ha na7aa efaada, taayyo xanttashsha; taani neeyyo damoozaa qanxxana” yaagaasu. Yaagin maccaasiyaa na7aa efaada, xanttaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Na7ai diccin, kawuwaa na7eekko a ehaasu; i iyyo na7a gidiis; “Taani haattaappe a kessaas” gaidda, a Muusa sunttaasu. ");
INSERT INTO wal_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Muusee diccidi gitaa gididi, issi gallassi ba asai de7iyoosaa biis; biidi eti deexo ooso oottishin eta xeelliis. Gibxxe biittaa asa issoi a asatuppe, Ibraawetuppe issuwaa wadhdhishin be7iis. ");
INSERT INTO wal_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I yaa haa xeellin, ooninne bainnaagaa be7idi, he Gibxxe bitaniyaa woriis; woridi shaaheeta giddon qottiis. ");
INSERT INTO wal_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Wonttetta gallassi kiyidi, naa77u Ibraaweti warettiyaageeta be7iis. Naaqqidaagaa i, “Neeni ne lagge gidiya Ibraawiyaa aissi dechchai?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Oichchin he bitanee, “Nena nu bolli haariyaagaanne daanna ootti sunttidai oonee? Neeni he Gibxxe bitaniyaa woridoogaadan, tanakka worana qoppaiyye?” yaagiis. Muusee he wode, “Taani oottidobai erettiichchiis” yaagi qoppidi yayyiis. ");
INSERT INTO wal_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kawoi hagaa siyido wode, Muusa woranau koyiis; shin Muusee kawuwaappe baqatidi, Midiyaama biittan de7anau biis; biidi haatta ollaa doonan uttiis. ");
INSERT INTO wal_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","He wode Midiyaama qeese issuwaayyo laappun macca naati de7oosona; eti bantta aawaa dorssata haattaa ushshanau wonggiriyan haattaa duuqqi kunttanau yiidosona. ");
INSERT INTO wal_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Henttanchchati yiidi macca naata yedettidosona; shin Muusee denddi eqqidi, eta ashshiisinne eta dorssata haattaa ushshiis. ");
INSERT INTO wal_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Eti bantta aawaa Yatirokko yiido wode, “Hachchi waani eesuwan yiidetii?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Oichchin eti zaaridi, “Gibxxe biittaa asa issoi nuna henttanchchatuppe ashshiis; i nuuyyo haattaakka duuqqidi dorssaa wudiyaa ushshiis” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yaagin i ba macca naata, “Yaatin i awan de7ii? Intte he bitaniyaa aissi aggi bayidetii? Ane a xeesidi, miyoobaa shoobbite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Muusee he bitaniyaara yan de7anau maayiis; bitaneekka ba na7iyo Xippaaro Muuseyyo machcho oottidi immiis. ");
INSERT INTO wal_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Xippaara attuma na7aa yelin, Muusee a, “Taani asa biittan bete gidaas” yaagiiddi, Gershshooma sunttiis. ");
INSERT INTO wal_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Daro laittaappe guyyiyan, Gibxxe kawoi haiqqiis. Israa7eelati bantta ailletettaappe oolidosonanne waassidosona; bantta ailletettaappe eti waassido waasoi pude Xoossaakko gakkiis. ");
INSERT INTO wal_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Xoossai eta ooliyaa siyidi, i Abrahaamaara, Yisaaqaaranne Yaaqoobaara maacetto maachchaa hassayiis. ");
INSERT INTO wal_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Hegaa gishshau, Xoossai Israa7eelata xeellidi etau qoppiis. ");
INSERT INTO wal_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Issi wode Muusee Midiyaama biittaa qeesiyaa, ba bolluwaa Yatiro dorssata heemmees; i he wudiyaa laaggi ekkidi bazzuwau gaxaa gakkanaashin efiis; efiidi Xoossaa deriyaa, Siinaa Deriyaa gakkiis. ");
INSERT INTO wal_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","He sohuwan GODAA kiitanchchai buuran, eexxiya tama lacuwaa giddon ayyo beettiis; buurai taman xuugettikkokka, tamai buuraa meennaagaa Muusee be7iis. ");
INSERT INTO wal_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Hegaa gishshau, Muusee, “Taani yaa baada, buurai aissi taman meetettennaakkonne ha oorattabaa ane be7ana” yaagidi qoppiis. ");
INSERT INTO wal_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","I be7anau yaa biidoogaa GODAI be7iis; be7idi Xoossai buuraa giddoppe a, “Muusee! Muusee!” yaagidi xeesiis. Xeesin Muusee, “Yee!” giidi koyiis. ");
INSERT INTO wal_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Koyin Xoossai a, “Haa shiiqoppa. Neeni eqqido biittai geeshsha gidiyo gishshau, ne tohuwan de7iya caammaa kessa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Qassikka GODAI a, “Taani ne aawaa Xoossaa, Abrahaama Xoossaa, Yisaaqa Xoossaa, Yaaqooba Xoossaa” yaagiis. Yaagin Muusee Xoossaa xeellanau yayyido gishshau, ba som77uwaa genttiis. ");
INSERT INTO wal_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","GODAI qassikka hagaadan yaagiis; “Taani Gibxxe biittan ta asai tuggatiyo tuggaa geeshsha be7ada, eti bantta kaabbotuppe waassiyo waasuwaa siyada, taani eta waayiyaa qoppaas. ");
INSERT INTO wal_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hegaa gishshau, taani eta Gibxxe biittaa asatu kushiyaappe ashshanaunne he biittaappe eta kessada, aahonne lo77o biitti ehaanau wodhdhaas. He biittai maattainne eessai goggiyo biitta; he biittan Kanaaneti, Hiiteti, Amooreti, Parzzeti, Hiiwetinne Yaabuusati ha77i de7oosona. ");
INSERT INTO wal_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ha77i Israa7eelatu waasoi tana gakkiis; Gibxxe biittaa asati eta naaqqiyo naaquwaanne taani be7aas; ");
INSERT INTO wal_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","hegaa gishshau, ha77i ba; ta asata, Israa7eelata Gibxxeppe kessana mala, Gibxxe kawuwaakko taani nena kiittais” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","SHin Muusee Xoossaa, “Kawuwaakko baanaunne Israa7eelata Gibxxeppe kessanau taani oonee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Yaagin Xoossai a, “Taani nenaara gidana; qassi taani nena kiittidoogau malaatai hagaa: neeni he asaa Gibxxeppe kessido wode, ha deriyaa bollan intte Xoossau goinnana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Muusee Xoossaa, “Gido shin, taani Israa7eelatukko baada, eta, ‘Intte aawatu Xoossai tana inttekko kiittiis’ yaagin, eti tana, ‘A sunttai oonee?’ yaagidi oichchikko, he wode taani etayyo woiga yootanee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Xoossai Muusa, “Taani tanattennee; neeni Israa7eelatuyyo, ‘Tanattennee inttekko tana kiittiis’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Xoossai Muusa qassi, “Neeni Israa7eelata, ‘GODAI intte aawatu Xoossai, Abrahaama Xoossai, Yisaaqa Xoossai, Yaaqooba Xoossai, i tana inttekko kiittiis’ yaaga; hagee yeletaappe yeletaa gakkanau taani hassayettanau merinau ta suntta. ");
INSERT INTO wal_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Ba; baada Israa7eela cimata shiishshada, ‘GODAI intte aawatu Xoossai, Abrahaama, Yisaaqanne Yaaqooba Xoossai taayyo qoncciis; qonccidi tana, “Taani inttena xomoosaas; Gibxxen intte bolli aibi oosettidaakko taani be7aas. ");
INSERT INTO wal_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Taani inttena Gibxxe biittaa tuggaappe kessada, pude maattainne eessai goggiyo Kanaanetu, Hiitetu, Amooretu, Parzzetu, Hiiwetunne Yaabuusatu biitti efaana ga uttaas” yaagiis’ yaaga. ");
INSERT INTO wal_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Israa7eela cimati ne qaalaa siyana; hegaappe guyyiyan neeninne he cimati Gibxxe kawuwaakko biidi a, ‘GODAI, Ibraawetu Xoossai, nunaara gaittiis. Ha77i nuuni heezzu gallassa ogiyaa bazzo hemetti biidi, GODAASSI, nu Xoossaassi, yarshshuwaa yarshshana mala nuna yedda’ yaagite. ");
INSERT INTO wal_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","SHin Wolqqaama kushee a wolqqan yedissana xayikko, Gibxxe kawoi inttena yeddennaagaa taani erais. ");
INSERT INTO wal_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Hegaa gishshau, taani ta kushiyaa yeddada, eta giddon taani oottiyo ta malaatatu ubban Gibxxeta shocana. Hegaappe guyyiyan i inttena yeddana. ");
INSERT INTO wal_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Qassi taani Gibxxetun ha asaa sabissana; yaatobare intte kiyiyo wode kushe mela kiyekketa. ");
INSERT INTO wal_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ibraawe maccaasi ubbai ba Gibxxe shooreekkonne ba son de7iya Gibxxe maccaasai oona gidinkka ikko biidi, bira miishshata, worqqa miishshatanne attuma naatinne macca naati maayana maayota ‘Immite’ giidi oichchana. Hegaadan oottidi intte Gibxxetu aquwaa bonqqana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Muusee, “Eti tana ammanennan ixxikko, woikko taani odiyoogaa siyennan ixxidi, ‘GODAI neeyyo qonccibeenna’ giikko waanoo?” yaagidi zaariis. ");
INSERT INTO wal_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yaagin GODAI a, “He ne kushiyan de7iyaagee aibee?” yaagidi oichchiis. Oichchin, “Xam77aa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yaagin GODAI a, “Ane a sa7an ola” yaagiis. Yaagin Muusee he gatimaa sa7an oliis; olin shooshsha kiyiis; yaatin, Muusee appe woxxiis. ");
INSERT INTO wal_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Hegaappe guyyiyan GODAI a, “Ne kushiyaa yeddada, a goinaa oiqqa” yaagiis. Muusee yeddidi shooshshaa oiqqin, shooshshai a kushiyan simmidi, gatimau laamettiis. ");
INSERT INTO wal_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","GODAI, “Hagee hanidoogee, ne aawatu Xoossai, Abrahaama Xoossai, Yisaaqa Xoossainne Yaaqooba Xoossai neeyyo qonccidoogaa eti ammananaassa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Hegaappe guyyiyan GODAI a, “Ne kushiyaa ne shophphan naaqqa” yaagin, Muusee ba kushiyaa shophphan naaqqiis; i kessiyo wode a kushee barottidi shachchaadan booxxiis. ");
INSERT INTO wal_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","GODAI a, “Ne kushiyaa ne shophphan zaarada naaqqa” yaagiis. Yaagin Muusee ba kushiyaa ba shophphau zaari naaqqidi kessiyo wode, a kushee simmidi hinkko bollaa mala gidiis. ");
INSERT INTO wal_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Qassikka GODAI a, “Eti nena ammanennan ixxikkonne koiro malaataa ammanennan ixxikko, naa77anttuwaa eti ammanana. ");
INSERT INTO wal_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","SHin eti Xoossi oottiyo ha naa77u malaatata ammanana xayikko, woikko neeni odiyoogaa siyennan ixxikko, Naile SHaafaappe haattaa ekkada, mela biittan gussa; neeni shaafaappe ekkido haattai biittan suutta gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Yaagin Muusee GODAA, “Abeet Godau, taani hagaappe kasekka, woikko neeni ne ashkkaraayyo haasayidoosappe simminkka taani biddaa danddayikke; taani leddani haasayais; qassi ta inxxarssaikka lufa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","GODAI a, “Asaassi doonaa medhdhidaagee oonee? A duude, woikko tulle oottiyaagee oonee? Xeelliyaagaanne qooqe oottiyai oonee? Tana GODAA gidikkinaayye? ");
INSERT INTO wal_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Neeni ha77i ba; taani nena haasayanau maaddana; neeni gaanabaanne taani nena tamaarissana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","SHin Muusee GODAA, “Godau, hayyanaa, hagaa oottanau hara asa kiittarkkii!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Hegaappe guyyiyan GODAI Muuseyyo keehi hanqqettidi a, “Leewa gidiya ne ishaa Aaroonihoo? I lo77o haasayana danddayiyoogaa taani erais; ha77i i nenaara gaittanau yiiddi ogiyaa bollan de7ees; i nena be7iyo wode a wozanai ufaittana. ");
INSERT INTO wal_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Neeni, ‘Yaaga; yaaga’ gaada ayyo odana; taani inttena naa77aakka haasayana maaddananne intte oottanabaa tamaarissana. ");
INSERT INTO wal_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","I asaayyo ne gishshaa haasayana; hegeenne, i neeyyo doona mala gidin, neeni ayyo Xoossa mala gidana giyoogaa. ");
INSERT INTO wal_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","SHin ooratta malaatata an oottanau, neeni ha gatimaa ekkada ba” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Hegaappe guyyiyan Muusee ba bolluwaa Yatirokko simmi biidi, “Hanno gakkanaassi paxa de7iya asi de7ikko be7anau, taani guyye ta asaakko Gibxxe boo?” yaagiis. Yaagin Yatiroi Muusa, “Ee ba; saro gakka” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Muusee Midiyaama biittan de7ishin GODAI a, “Nena woranau koyida asati ubbai haiqqiichchido gishshau, guyye Gibxxe biitti simmada ba” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Yaagin Muusee ba keettaayyiyoonne ba attuma naata hariyaa togissi ekkidi, guyye Gibxxe simettaa doommiis; Muusee Xoossaa gatimaa ba kushiyan oiqqidi biis. ");
INSERT INTO wal_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","GODAI Muusa, “Neeni Gibxxe simmada biyo wode, taani neeyyo immido wolqqan neeni oottana malaatata ubbaa Gibxxe kawuwaa sinttan neeni oottanaagaa baloppa. Yaaninkka asaa i yeddenna mala, taani a wozanaa dammissana. ");
INSERT INTO wal_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","He wode taani GODAI giyoobaa kawuwaassi hagaadan yaagada oda; ‘“Israa7eeli ta baira na7aa. ");
INSERT INTO wal_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I taayyo goinnana mala, ta na7aa neeni yeddana mala, taani neeyyo yootaas; shin neeni a yeddennan ixxadasa; hegaa gishshau, taani ne baira attuma na7aa worana” yaagees’ yaagada oda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ogiyan shemppiyoosan GODAI Muuseera gaittiis; gaittidi a worana haniis. ");
INSERT INTO wal_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","A keettaayyiyaa Xippaara saluwaa ekkada, ba na7aa qaxxaraasu. Qaxxarada he shoohuwan Muuse tohuwaa bochchaasu. A Muusa, “Neeni taayyo tumu suutta bullachchaawaa” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","GODAI hegaa gishshau a worennan aggiis. He wode qaxxaraa malaatanau a, “Neeni taayyo suutta bullachchaawaa” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","GODAI Aaroona, “Neeni Muuseera gaittanau bazzo ba” yaagiis. Yaagin i biidi, Muuseera Xoossaa deriyan gaittidi a yeriis. ");
INSERT INTO wal_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Hegaappe guyyiyan Muusee GODAI ba bolli kiittido qaala ubbaanne oottana mala, bana azazido ooratta malaatatubaa ubbaa Aaroonayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Muuseenne Aarooni biidi, Israa7eelatu cimata ubbaa shiishshidosona. ");
INSERT INTO wal_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","SHiishshin Aarooni GODAI Muuseyyo yootido qaala ubbaa etayyo odiis. Qassi Muusee malaatata he asaa sinttan oottiis. ");
INSERT INTO wal_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Etikka ammanidosona. GODAI etau qoppidoogaanne eta tuggaa be7idoogaa siyido wode, eti gufannidi goinnidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hegaappe guyyiyan Muuseenne Aarooni Gibxxe kawuwaakko yiidi a, “GODAI, Israa7eela Xoossai hagaadan yaagees; ‘Ta asai taayyo bazzon baalaa bonchchana mala, eta yedda’ yaagees” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Yaagin kawoi, “Taani ayyo azazettada Israa7eela yeddanau he GODAI oonee? Taani GODAA erikke; Israa7eelakka yeddikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Hegaappe guyyiyan eti, “Ibraawetu Xoossai nunaara gaittiis. Ha77i nuuni GODAAYYO, nu Xoossaayyo, yarshshuwaa yarshshanau heezzu gallassa ogiyaa bazzo giddo baanau nuna yeddarkkii; hinna xayikko, i nuna boshan woikko olan worana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","SHin Gibxxe kawoi yaagiis; “Muusee! Aaroonaa! Asaa aissi oosuwaa diggeetii? Intte oosuwau simmidi biite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kawoi he wode, “Be7ite, ha biittan asai corattiis; qassi intte eta oosuwaa diggeeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kawoi he gallassi Gibxxetu kaabbotanne Israa7eelatu daguwaa sunttata azaziiddi, ");
INSERT INTO wal_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Haroodeegaadan xuubiyaa oottiyo utulaa asaayyo ehi immoppite; eti utulaa banttau bi biidi shiishshona; ");
INSERT INTO wal_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","shin eti qoodan kaseegaa keena xuubiyaa medhdhidi, sheedhdhanaadan azazite; he qoodaappe pacissoppite; aissi giikko, eti azalla; eti, ‘Nuuni nu Xoossaayyo yarshshuwaa yarshshana mala, nuna yedda’ yaagidi waassiyoogee hegaassa. ");
INSERT INTO wal_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Eti oosuwan sheekkana malanne worddo haasayaa siyennan aggana mala, etayyo oosuwaa deexettite” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Hegaappe guyyiyan, he kaabbotinne he sunttati kiyidi asaa, “Kawoi hagaadan yaagees; ‘Simmi taani intteyyo mulekka utulaa immikke; ");
INSERT INTO wal_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","intte utulaa demmana danddayiyoosaappe intte huuphen shiishshite; shin intte sheedhdhiyo xuubiyaa qoodai mulekka paccenna’ yaagiis” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Yaagin asai utulaassi haniyaabaa shiishshanau Gibxxe biitta ubban laalettiis. ");
INSERT INTO wal_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Gibxxetu kaabboti eta, “Intteyyo utulaa immiyo wode intte hachchi hachchi oottiyoogaa keenaa oottite” yaagidi eta godatidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Gibxxetu kaabboti Israa7eelatu daguwaa sunttata wadhdhidi, “Intte kase oottiyoogaa keena xuubiyaa zino woikko hachchi aissi ootti wurssibeekketii?” yaagidi oichchidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Hegaappe guyyiyan Israa7eela sunttati biidi kawuwaayyo magannidosona; eti a, “Neeni ne ashkkarata hagaadan aissi oottai? ");
INSERT INTO wal_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ne ashkkaratuyyo utulaa immokkona; shin, ‘Xuubiyaa medhdhite’ yaagoosona; yaagidi nuna ne ashkkarata wadhdhoosona; shin balai ne asaa bollaana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","SHin kawoi eta, “Ha azallati! Intte azalla! Hegaa gishshau, intte zaari zaaridi, ‘Nuuni GODAAYYO yarshshana baanau nuna yedda’ yaageeta. ");
INSERT INTO wal_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ha77i biite; biidi oottite; eti intteyyo aiba utulakka immokkona; shin intte kaseegaa keena xuubiyaakka medhdheeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israa7eelatu sunttati, “Intte hachchi hachchi medhdhiyo xuubiyaa qoodaa kaseegaappe pacissoppite” giido wode, eti metuwan gelidoogaa akeekidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Eti kawuwaa matappe kiyiiddi, Muuseenne Aarooni etaara gaittanau naagiyaageeta demmidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Eti, “Inttena GODAI xeello! Intte bolli i pirddo! Intte nuna kawuwaaninne a oosanchchatun ixissideta; qassi eti nuna worana mala, bisuwaa eta kushiyan wottideta” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Muusee GODAAKKO simmidi, “Godau, neeni ha asaa bolli metuwaa aissi ehaadii? Neeni tana kiittidoi hagaassee? ");
INSERT INTO wal_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Taani ne sunttan kawuwaayyo haasayanau biido wodeesappe doommin, i ha asaa bolli metuwaa ehiis. Qassi neenikka ne asaa mule ashshabaakka” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hegaappe guyyiyan GODAI Muusa, “Taani Gibxxe kawuwaa oottanabaa neeni ha77i be7ana; ta wolqqaama kushiyaa gaasuwan i eta yeddana; ta wolqqaama kushiyaa gaasuwan i eta ba biittaappe laaggidi kessana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Xoossai qassikka Muusa, “Taani GODAA; ");
INSERT INTO wal_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","taani Abrahaamayyo, Yisaaqayyoonne Yaaqoobayyo Ubbaa Danddayiya Xoossaa gidada qonccaas; shin taani, ‘GODAA’ giyo ta sunttan, tanatettaa eta erissabeikke. ");
INSERT INTO wal_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Qassi taani etayyo eti bete gididi de7ido Kanaane biittaa immanau ta maachchaa etaara maacettaas. ");
INSERT INTO wal_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Qassikka Gibxxe asati ailleyiyo Israa7eelatu ooliyaa taani siyada, ta maachchaa hassayaas. ");
INSERT INTO wal_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Hegaa gishshau, neeni Israa7eelata, ‘Taani GODAA; taani inttena Gibxxetu naaquwaappe kessana; taani inttena eta ailletettaappekka goqa kessana; qassi taani inttena ta gita wolqqaaninne hanttaara pirddan wozana. ");
INSERT INTO wal_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Taani inttena ta huuphe asadan ekkananne taani intte Xoossaa gidana. He wode intte taani GODAA intte Xoossaa inttena Gibxxetu ailletettaappe kessidaagaa gidiyoogaa erana. ");
INSERT INTO wal_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Qassi taani inttena Abrahaamayyo, Yisaaqayyoonne Yaaqoobayyo immanau ta kushiyaa denttada caaqqido biittau ehaana; he biittaa taani intteyyo intte gade oottada immana; taani GODAA’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Muusee hagaa Israa7eelatuyyo yootiis; shin eta heennai meqqido gaasuwaaninne meqetti bainna ailletettaa gaasuwan a qaalaa siyibookkona. ");
INSERT INTO wal_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hegaappe guyyiyan GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ba; baada Gibxxe kawuwaa, ‘Israa7eelata ne biittaappe kessada yedda’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","SHin Muusee GODAA, “Israa7eelati tabaa siyennan ixxaappe attin, taani deddotiya inxxarssan haasayiyoogaa kawoi aissi siyii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","GODAI Muusanne Aaroona, “Biite; biidi, intte Israa7eela asaa Gibxxeppe kessana mala, taani inttena yeddidoogaa Israa7eela asaassinne Gibxxe kawuwaassi yootite” yaagidi azaziis. ");
INSERT INTO wal_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Eta so asatu halaqati hageeta. Israa7eelayyo baira na7aa Roobeela attuma naati, Heenooka, Paalu, Hexiroonanne Karmma; hageeti Roobeela yarata. ");
INSERT INTO wal_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simoona attuma naati, Yimu7eela, Yaamiina, Ohaada, Yaakiina, Xoohaaranne Kanaane biittaa maccaaseeppe yelettida SHaa7ula; hageeti usuppunati Simoona yarata. ");
INSERT INTO wal_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leewa attuma naati bantta yeletaa maaraadan Gershshoona, Qahaatanne Maraara. Leewi xeetanne hasttamanne laappun laittaa de7iis. ");
INSERT INTO wal_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershshoona attuma naati bantta yaran yaran Liibinanne SHim77a geetettoosona. ");
INSERT INTO wal_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Qahaata attuma naati Amiraama, Yixihaara, Kebroonanne Uzzi7eela. Qahaati xeetanne hasttamanne heezzu laitta de7iis. ");
INSERT INTO wal_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Maraara attuma naati Maahilanne Musha giyoogeeta. Bantta Yeletaa maaran Leewa yarati hageeta. ");
INSERT INTO wal_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amiraami ba aawaa michchiyo Yokebeedo machchiis. A Aaroonanne Muusa ayyo yelaasu. Amiraami xeetanne hasttamanne laappun laittaa de7iis. ");
INSERT INTO wal_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yixihaara attuma naati, Qoraaha, Nefeganne Ziikira. ");
INSERT INTO wal_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzzi7eela attuma naati, Mishaa7eela, Elxxaafaananne Siitira. ");
INSERT INTO wal_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarooni Aminadaaba na7iyo, Na7asoona michchiyo Elisheebo machchiis. Yaatin a ayyo Nadaaba, Abiiha, El77aazaranne Itaamaara yelaasu. ");
INSERT INTO wal_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Qore attuma naati, Asiira, Elqqaananne Abiyaasaafa; hageeti Qore yaratu maizza aawata. ");
INSERT INTO wal_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaroona na7ai El77aazari Puti7eela naatuppe issinno machchiis; a ayyo Piinihaasa yelaasu. Hageeti bantta yaran yaran Leewatu keettaa asaa halaqata. ");
INSERT INTO wal_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","GODAI, “Gibxxe biittaappe Israa7eelata eta citan citan kessite” yaagidoi ha Muusanne ha Aaroona. ");
INSERT INTO wal_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Israa7eelata Gibxxe biittaappe kessiyoogaa Gibxxe kawuwaassi haasayidaageeti eta. Hageeti he Muusanne he Aaroona. ");
INSERT INTO wal_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","GODAI Gibxxen Muuseyyo haasayido wode a, ");
INSERT INTO wal_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Taani GODAA; taani neeyyo yootiyoobaa ubbaa neeni Gibxxe kawuwaayyo yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","SHin Muusee GODAA, “Taani deddotiya inxxarssan haasayiyaagaa gidishin, kawoi taani yootiyoobaa waati siyanee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Hegaappe guyyiyan GODAI Muusa, “Be7a; taani nena Gibxxe kawuwaayyo Xoossa mala oottaas; ne ishai Aarooni ne hananabaa yootiyaagaa gidana; ");
INSERT INTO wal_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","taani nena azazido ubbaa neeni ayyo yootaasa; ne ishaa Aarooni Israa7eelata ba biittaappe kessi yeddana mala, kawuwaayyo yootees. ");
INSERT INTO wal_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","SHin taani kawuwaa wozanaa dammissana; taani Gibxxe biittan ta ooratta malaataanne maalaalissiyaabaa darissada oottikkokka, ");
INSERT INTO wal_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","i intte yootiyoobaa siyenna. He wode taani ta kushiyaa Gibxxetu bolli denttana; taani ta citaa, ta asaa Israa7eela wolqqaama pirddan Gibxxeppe kessana. ");
INSERT INTO wal_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Qassi Gibxxeti, taani ta kushiyaa Gibxxe bolli denttada, Israa7eelata eta giddoppe kessido wode, taani GODAA gidiyoogaa eti erana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Muuseenne Aarooni likke GODAI eta azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Eti kawuwaayyo yootiyo wode, Muusee hosppun tammu laitta asa; Aarooni qassi hosppun tammanne heezzu laitta asa. ");
INSERT INTO wal_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kawoi inttena, ‘Xoossai oottiyo malaataa tana bessite’ giyo wode, neeni Aaroona, ‘Ne gatimaa ekkada, kawuwaa sinttan ola’ yaaga; yaatobare i shooshsha kiyana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Yaagin Muuseenne Aarooni kawuwaakko gelidosona; gelidi likke GODAI eta azazidoogaadan oottidosona; Aarooni ba gatimaa kawuwaa sinttaaninne a oosanchchatu sinttan oliis; olin shooshsha kiyiis. ");
INSERT INTO wal_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Hegaappe guyyiyan kawoi aadhdhida eranchchatanne bitanchchata xeesissiis; xeesissin etikka, ha Gibxxetu shareechchoti bantta eeqan hegaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Eti ubbaikka bantta gatimaa gatimaa olin, gatimati shooshsha kiyidosona; shin Aaroona gatimai eta gatimata mitti bayiis. ");
INSERT INTO wal_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Gidikkonne GODAI yootidoogaadankka kawuwaa wozanai dammiis; i eta oduwaa siyennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","GODAI Muusa, “Kawuwaa wozanai dammiis; asaa i yeddennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kawoi haattau biyo wode, guurada neeni akko ba; baada aara gaittanau neeni Naile SHaafaa doonan eqqa; shooshshau laamettida gatimaa oiqqa ekkada ba. ");
INSERT INTO wal_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Neeni a, ‘GODAI, Ibraawetu Xoossai nena, “Bazzuwan taayyo goinnana mala, ta asaa yedda” yaagidi, tana neekko kiittiis; shin hanno gakkanaashin neeni siyabaakka. ");
INSERT INTO wal_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","GODAI, “Taani GODAA gidiyoogaa neeni hagan erana” yaagees. Taani Naile SHaafaa haattaa ta kushiyan de7iya gatiman shocana; shocin haattai suuttau laamettana. ");
INSERT INTO wal_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Naile SHaafaa moleekka haiqqana; shaafaikka xinqqana; Gibxxeti he shaafaa haattaa uyanau danddayokkona’ yaagada oda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","GODAI Muusa hagaadan yaagiis; “Neeni Aaroona, ‘Ne gatimaa oiqqada Gibxxe haattatu bolli, shaafatu bolli, zara haattatu bolli, dalbbanttatu bollinne haattaa dagayiyoobatu ubbaa bolli ne kushiyaa micca’ yaaga; i miccin eti suuttau laamettana; Gibxxe biitta ubban, harai attin, mittaappenne shuchchaappe woocidi kessido haattaa tigiyo miishshatu ubban suutti kumana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Muuseenne Aarooni GODAI azazidoogaadan oottidosona. Kawuwaa sinttaaninne a sunttatu sinttan i ba gatimaa denttidi, abbaa haattaa shociis; shocin haatta ubbai suuttau laamettiis. ");
INSERT INTO wal_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","He abbaa haattaa giddon de7iya moleti haiqqidosona; shaafaa haattai keehi zeeqqido gishshau, Gibxxe asai uyanau danddayibeenna. Gibxxen mule ubbasan suuttai kumiis. ");
INSERT INTO wal_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","SHin Gibxxe shareechchoti bantta eeqan hegaadan oottidosona; GODAI yootidoogaadankka kawuwaa wozanai dammin, Muuseenne Aarooni odidoogaa siyennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Hegaappe guyyiyan kawoi hagau ainne hirggennan ba soo simmidi biis. ");
INSERT INTO wal_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Gibxxe asai ubbai Naile SHaafaa haattaa uyanau danddayibeenna gishshau, uyiyo haatta demmanau Naile SHaafaa lanqqiyan ollaa bookkidosona. ");
INSERT INTO wal_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","GODAI haattaa shocoosappe laappun gallassa gidiis. ");
INSERT INTO wal_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Hegaappe guyyiyan GODAI Muusa, “Ba; Gibxxe kawuwaakko baada, ‘GODAI hagaadan yaagees; “Taayyo goinnana mala, ta asaa yedda. ");
INSERT INTO wal_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Neeni eta yeddennan ixxikko, taani ne biitta ubban shodhdhiyaa boshaa yeddana. ");
INSERT INTO wal_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Naile SHaafan shodhdhee shohattana. Eti shohatti kiyidi ne soo, ne siirixaa, ne arssaa giddo, ne sunttatu keettaa giddo gelana; ne asaa bolli kiyana; ne coociyaanne ne munaqa keretun gelana. ");
INSERT INTO wal_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","SHodhdheti ne bolli, ne asaa bollinne ne sunttatu ubbaa bolli kiyana” yaagees’ yaagada oda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Hegaappe guyyiyan GODAI Muusa, “Neeni Aaroona, ‘Ne gatimaa oiqqada, shaafatu bolli, zara haattatu bollinne dalbbanttatu bolli ne kushiyaa micca; miccada shodhdheti Gibxxe biittaa bollan kiyanaadan ootta’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Yaagin Aarooni Gibxxe haattatu bolli ba kushiyaa micciis; miccin shodhdheti kiyidi, Gibxxe biittaa maayidosona. ");
INSERT INTO wal_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","SHin shareechchotikka bantta eeqan hegaadan oottidosona; etikka Gibxxe biittan shodhdhee kiyanaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kawoi Muusanne Aaroona xeesissidi, “Ha shodhdheta taappenne ta asaappe diggana mala, GODAA intte woossite; yaanikko GODAASSI yarshshuwaa yarshshana mala, taani asaa yeddana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Yaagin Muusee kawuwaa, “SHodhdheti neeppenne ne sooppe xayana malanne Naile SHaafaa xalaalan attana mala, taani neeyyo, ne sunttatuyyoonne ne asaayyo woossana wodiyaa neeni keera” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Yaagin kawoi, “Wontto” yaagiis. Yaagin Muusee, “Nu GODAA Xoossaa malai ooninne bainnaagaa neeni erana mala, neeni giidoogaadan hanana. ");
INSERT INTO wal_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","He shodhdheti neeppe, ne keettaappe, ne sunttatuppenne ne asaappe xayana; eti Naile SHaafaa xalaalan attana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Muuseenne Aarooni kawuwaa matappe kiyidosona; kawuwaa bolli Muusee ehiido shodhdhetubaa Muusee GODAA woossiis. ");
INSERT INTO wal_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Woossin GODAI Muusee oichchidoogaadan oottiis; shodhdheti son kareeninne dembban haiqqidosona. ");
INSERT INTO wal_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gibxxe asai eta shiishshi shiishshidi dooridosona; biittainne hegaa xinqquwan zeeqqiis. ");
INSERT INTO wal_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","SHin kawoi peeqaa demmido wode a wozanai dammiis; GODAI yootidoogaadankka, i Muuseenne Aarooni odido oduwaa siyennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","GODAI hegaappe guyyiyan, Muusa hagaadan yaagiis; “Neeni Aaroona, ‘Ne gatimaa miccada, biittaa buhiyaa shoca’ yaaga; shocin Gibxxe biitta ubban buhee cuuchcha kiyana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Yaagin eti hegaadan oottidosona; Aarooni gatimaa oiqqidi ba kushiyaa micciis; ba gatiman biittaa buhiyaa shociis; shocin asaa, mehiyaanne do7aa bolli cuuchchai yi bayiis. Gibxxe biittan ha gaxaappe ya gaxaa gakkanaashin, buhe ubbai cuuchcha kiyiis. ");
INSERT INTO wal_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","SHareechchotikka bantta eeqan hegaadan oottanau mali be7idosona; shin danddayibookkona. Cuuchchai asaa bollan, mehiyaa bollaaninne do7aa bollan kumiis. ");
INSERT INTO wal_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","SHareechchoti kawuwaa, “Hagee Xoossaa ooso” yaagidosona. SHin kawuwaa wozanai dammiis; GODAI giidoogaadankka, i eti odiyoobaa siyennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","GODAI Muusa, “Guurada denddada, kawoi shaafaa biishin aara gaitta; gaittada neeni a, ‘GODAI yaagees; “Taayyo oottana mala, ta asaa yedda; ");
INSERT INTO wal_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","neeni ta asaa yeddennan ixxikko, taani ne bolli, ne sunttatu bolli, ne asaa bollinne ne keettatu giddo gawwiina udunxxiyaa yeddana; Gibxxetu keettaaninne eti de7iyo biitta ubban udunxxee kumana. ");
INSERT INTO wal_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","SHin he gallassi ta asai de7iyo Goshena biittan udunxxee gawwattennaadan taani teqqada, eta biittaa zaggana; taani GODAI, ha biittan de7iyoogaa neeni hegan erana. ");
INSERT INTO wal_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Taani ta asaanne ne asaa zaggana; ha gita malaatai wontto hanana” yaagees’ yaagada oda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","GODAI hegaappe guyyiyan, giidoogaadan oottiis; kawuwaa sooninne a sunttatu son daro gawwiina udunxxee yiis; yiidi Gibxxe biittaa ubbaa bashshiis. ");
INSERT INTO wal_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","He wode kawoi Muusanne Aaroona xeesissidi, “Biite; ha biittan intte Xoossaassi yarshshite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","SHin Muuse, “Hegee likke gidenna; nuuni GODAA nu Xoossaassi shiishshiyo yarshshoti Gibxxeta sheneyiyaabaa gidana; nuuni eta sheneyiya yarshshota eti xeellishin yarshshikko, eti nuna shuchchan caddokkonaa? ");
INSERT INTO wal_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nuuni GODAASSI, nu Xoossaassi, yarshshota shiishshanau i nuna azaziyoogaadan, heezzu gallassa ogiyaa bazzuwaa baana koshshees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Yaagin kawoi, “GODAASSI, intte Xoossaassi, intte bazzuwaa biidi yarshshana mala, taani inttena yeddana; shin intte haakkidi booppite; taayyo ha77i woossite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Muusee, “Taani ne matappe kiyosaarakka GODAA woossana; ha gawwiina udunxxee wontto kawuwaappe, a sunttatuppenne a asaappe kichchana. SHin GODAAYYO yarshshanau asaa yeddennan ixxanau kawoi nuna zaari cimmenna mala akeeko” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hegaappe guyyiyan Muusee kawuwaa matappe kiyidi, GODAA woossiis. ");
INSERT INTO wal_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Woossin GODAI Muusee oichchidoogaadan oottiis; udunxxee kawuwaappe, a sunttatuppenne a asaappe issoinne attennan kichchiis. ");
INSERT INTO wal_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","SHin ha77ikka qassi kawuwaa wozanai dammin, asaa yeddennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","GODAI Muusa hagaadan yaagiis; “Ba; Gibxxe kawuwaakko baada, ‘GODAI, Ibraawetu Xoossai nena, “Eti taayyo goinnana mala ta asaa yedda” yaagees. ");
INSERT INTO wal_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Neeni yeddennan ixxada, eta oiqqa uttiyaabaa gidikko, ");
INSERT INTO wal_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","taani deriyan de7iya ne mehiyaa bolli, paratu bolli, haretu bolli, gaameelatu bolli, miizzatu bolli, dorssatu bollinne deeshshatu bolli hanttaara boshaa yeggana. ");
INSERT INTO wal_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","SHin taani GODAI Israa7eela mehetu gidduwaaninne Gibxxetu mehetu gidduwan zagaa medhdhana. Israa7eelatu mehiyaappe issoinne haiqqenna’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","GODAI wodiyaa keeridi, “Taani wontto hagaa ha biittaa bollan oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yaagidi wonttetta gallassi GODAI hegaa oottiis. Gibxxe asaa mehe ubbai haiqqiis; shin Israa7eela asaa mehiyaappe issoinne haiqqibeenna. ");
INSERT INTO wal_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kawoi ha yohuwaa paaccanau asa kiittidi, Israa7eelatu mehiyaappe, harai atto, issoinne haiqqibeennaagaa eriis. Gidikkonne kawuwaa wozanai dammidosaappe simmennan ixxin, asaa yeddennan diggiis. ");
INSERT INTO wal_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","GODAI hegaappe guyyiyan, Muusanne Aaroona, “Intte kushiyaa kunttidi coociyaappe bidinttaa kuuccite; kuuccidi Muusee kawoi xeellishin, hegaa pude carkkuwau laalo; ");
INSERT INTO wal_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","hegee Gibxxe biitta ubbaa bolli liiqo buhe gidana; Gibxxe biitta ubban asaa bollinne mehiyaa bolli giiyyiya merkkoi wodhdhana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Yaagin eti coociyaappe bidinttaa ekkidi, kawuwaa sinttan eqqidosona; Muusee hegaa pude carkkuwan laalin, asaa bollinne mehiyaa bolli giiyiya merkkoi wodhdhi bayiis. ");
INSERT INTO wal_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","SHareechchotikka eta bollinne Gibxxe asaa ubbaa bolli wodhdhida merkkoi eesuwaa diggin, Muuse sinttan eqqanau danddayibookkona. ");
INSERT INTO wal_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","SHin GODAI Muusessi giidoogaadankka, kawuwaa wozanaa dammissido gishshau, Muuseenne Aarooni yootiyoogaa kawoi siyennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Hegaappe guyyiyan GODAI Muusa, “Guuran denddada baada, kawuwaara gaitta; gaittada a, ‘GODAI, Ibraawetu Xoossai nena, “Taayyo goinnana mala ta asaa yedda. ");
INSERT INTO wal_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Hinna xayikko, ne bolli, ne sunttatu bollinne ne asaa bolli ta boshaayyo de7iya kumetta wolqqaa taani kiittana; biittan sa7an ta mali bainnaagaa neeni hegan erana. ");
INSERT INTO wal_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Taani hannoode ta kushiyaa yeddada, nenanne ne asaa boshan ha sa7aa bollappe mulluccu oottargganashin. ");
INSERT INTO wal_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Taani nena ta wolqqaa bessanaunne ta sunttai sa7a ubbaa bollan odettanau, hegau taani nena paxa wottaas. ");
INSERT INTO wal_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Neeni ha77ikka otorettada, ta asaa yeddennan ixxadasa. ");
INSERT INTO wal_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Hegaa gishshau, taani wontto hannoode Gibxxee Gibxxe gidoosappe hachchi gakkanaassi mulekka wodhdhi erenna, keehippe gita shachchaa yeggana. ");
INSERT INTO wal_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ha77i neeni ne mehiyaanne gaden neeyyo de7iyaabaa ubbaa eesuwan soo gelissanaadan azaza; aissi giikko, soo geliichchennan biron gaden de7iya asa ubbaa bollinne mehe ubbaa bolli shachchai wodhdhana; wodhdhin eti haiqqana” yaagees’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kawuwaa sunttatuppe GODAA qaalaayyo yayyidaageeti bantta ailletanne bantta mehiyaa eesotidi soo gelissidosona. ");
INSERT INTO wal_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","SHin GODAA qaalaa karidaageeti bantta ailletanne bantta mehiyaa gaden aggi bayidosona. ");
INSERT INTO wal_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hegaappe guyyiyan GODAI Muusa, “Gibxxe biitta ubbaa bollan: asa bolli, mehiyaa bollinne Gibxxe goshshatun dicciyaabaa ubbaa bolli shachchai wodhdhanaadan, ne kushiyaa saluwaa dentta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Muusee ba gatimaa saluwaa zaaridi denttido wode, GODAI dadaanne shachchaa yeddiis; wolqqanttainne duge sa7au wolqqammiis. GODAI Gibxxe biittan shachchaa yaati bukissiis. ");
INSERT INTO wal_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","SHachchai wodhdhiis; wolqqanttai yaanne haanne wolqqammiis; Gibxxe biittan kawoi kawotoosappe doommin, Gibxxe biitta ubban wodhdhida shachcha ubbaappe hegee aadhdhiya iita shachcha. ");
INSERT INTO wal_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","He shachchai Gibxxe biitta ubban gaden de7iya ubbabaa, asaakka mehiyaakka shociis; gaden mokkidabaa ubbaa duge zaaridi diippiis; mitta ubbaa mentterettiis. ");
INSERT INTO wal_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","SHachchi wodhdhibeenna biitti Israa7eelati uttido Goshena biittaa xalaala. ");
INSERT INTO wal_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kawoi kiittidi Muusanne Aaroona xeesissiis; xeesissidi, “Ha77i simmi, taani nagaraa oottaas; GODAI tumanchcha; taaninne ta asai mooranchcha. ");
INSERT INTO wal_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nuuyyo dadainne shachchai darido gishshau, GODAA woossite. Taani inttena yeddana; simmi hagaappe sinttan intte hagan takkekketa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Muusee a, “Taani ha katamaappe kiyido wode, taani woossanau ta kushiyaa GODAAKKO miccana; yaatobare dadai aggana; qassi shachchaa worettainne attana; sa7ai GODAABAA gidiyoogaa neeni hegan erana. ");
INSERT INTO wal_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","SHin neeninne ne sunttati GODAU Xoossau ha77inne yayyennaagaa taani erais” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Talbbai ciyyido gishshaunne banggai tiyattido gishshau, talbbainne banggai shachchan bayidosona. ");
INSERT INTO wal_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","SHin gistteenne qambbarai ka77iyo wodee biroona gidido gishshau, eti shachchan bayibookkona. ");
INSERT INTO wal_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Hegaappe guyyiyan Muusee kawuwaa achchappe denddidi, katamaappe gaxaa kiyiis. Kiyidi ba kushiyaa GODAAKKO micciis; yaatin dadainne shachchai caggiis; iraikka biittaa bollan duge tigettiyoogee eqqiis. ");
INSERT INTO wal_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","SHin kawoi irai, shachchainne dadai aggidoogaa be7ido wode zaaridikka nagaraa oottiis; ikka a sunttatikka bantta wozanaa dammissidosona. ");
INSERT INTO wal_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","GODAI Muuse doonan haasayidoogaadankka kawuwaa wozanai dammin, Israa7eelata i yeddennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","Hegaappe guyyiyan Muusa GODAI hagaadan yaagiis; “Gibxxe kawuwaakko ba; aissi giikko, taani Gibxxeta waata qaxxayidaakkonne ta gita malaataa eta giddon waata oottidaakko intte intte naatussinne intte naatu naatussi yootana mala, qassi inttekka taani GODAA gidiyoogaa erana mala, ta gita malaataa eta giddon oottanau a wozanaanne a sunttatu wozanaa taani dammissa wottaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Yaagin Muuseenne Aarooni kawuwaakko gelidi a, “GODAI, Ibraawetu Xoossai nena hagaadan yaagees; ‘Neeni taayyo azazettennan aude gakkanaassi ixxuutee? Taayyo oottana mala ta asaa yedda. ");
INSERT INTO wal_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Neeni eta yeddennan ixxikko, ne biittaa bolli taani wontto booliyaa ehaana; ");
INSERT INTO wal_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","boolee ooninne biittaa demmanau danddayennaadan biittaa kammana. Intteyyo shachchaappe attida guuttabaa, gaden dicciya mittaikka attennan ubbaa maana. ");
INSERT INTO wal_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ne keettan ne sunttatu keettaaninne Gibxxe asaa ubbaa keettan eti kumana; hegee ne aawati, woikko ne maizza aawati ha biittan uttoosappe hanno gakkanaassi mule be7ibeennaba’ yaagees” yaagidosona. Hegaappe guyyiyan Muusee kawuwaa sinttappe kiyidi biis. ");
INSERT INTO wal_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Bin kawuwaa sunttati kawuwaa, “Ha bitanee nuuyyo aude gakkanaassi pire gidanee? Eti GODAU, bantta Xoossau, goinnana mala, neeni asaa yedda; Gibxxe biittai bayidoogaa neeni ha77inne akeekikkii?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Hegaa gishshau, kawoi Muusanne Aaroona guyye zaarissidi, “Biite; GODAU, intte Xoossau goinnite; shin biyaageeti oonee oonee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Yaagin Muusee, “Nuuni nu guutta naatuuranne cimatuura, nu attuma naatuuranne macca naatuura, nu dorssaa wudetuuranne miizzaa wudetuura issippe baana; aissi giikko, nuuni biyoosan GODAA baalaa bonchchanau koshshees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kawoi, “Taani inttena intte naatuuranne intte maccaasaara yeddiyaabaa gidikko, GODAI inttena naaganau koshshees. SHin be7ite; intte intte wozanan iitabaa halchchidoogee qoncciyan erettees. ");
INSERT INTO wal_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","CHii, intte, ‘Yedda’ giiddi gam77idoogee attumaasaa gidiyo gishshau, attumaasa xalaalai biite; biidi GODAAYYO goinnite” yaagiis. Hegaappe guyyiyan Muusanne Aaroona kawuwaa sinttappe yedettidi kessidosona. ");
INSERT INTO wal_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","GODAI Muusa, “Boolee Gibxxe biittan gau7anaadan, shachchaappe attidi gaden dicciyaabaa ubbaa lim77i oottana mala, ne kushiyaa Gibxxe biittaa bollan micca” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Yaagin Muusee ba gatimaa Gibxxe biittaa bollan miccin, GODAI arshsho bagga carkkuwaa he gallassa ubbaanne he qamma ubbaa he biittaa bollan carkkissiis; wonttin he carkkoi booliyaa ehiis. ");
INSERT INTO wal_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Boolee Gibxxe biitta ubbaa bolli woraajjidi, biitta ubbasan gau7idi uttiis. Hagaa keena boole boshi he biittan hagaappe kasenne hanibeenna; woikko hagaappe sinttaunne zaarettidi hanenna. ");
INSERT INTO wal_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Biittai karexxana gakkanau boolee biitta ubbaa kammiis. He boolee shachchaappe attidi gaden dicciyaabaa ubbaanne mitta bollan de7iya aife ubbaa lim77i oottiis. Yaatin mittaa bollan irxxa haitti, woikko gaden ataakilttee Gibxxe biitta ubban aibinne attibeenna. ");
INSERT INTO wal_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kawoi Muusanne Aaroona eesuwan xeesissidi, “GODAA intte Xoossaanne inttena taani naaqqaas; ");
INSERT INTO wal_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","simmi intte taayyo ta nagaraa ha issitoo xalaalaayyo atto giite; ha woriya boshaa taappe diggana mala, GODAA intte Xoossaa woossite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Muusee kawuwaa matappe kiyidi, GODAA woossiis. ");
INSERT INTO wal_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Woossin GODAI he carkkuwaa arggo bagga wolqqaama carkkuwau laammiis; laammin booliyaa tookki ekki efiidi, Zo7o Abban yeggiis. Gibxxe biitta ubban issi booleenne attibeenna. ");
INSERT INTO wal_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Gidikkonne, GODAI kawuwaa wozanaa dammissido gishshau, Israa7eelata yeddennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","GODAI Muusa, “Gibxxe biittan asi bochchi be7anau danddayiyo keena xumai xumana mala, ne kushiyaa saluwaa dentta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Yaagin Muusee ba kushiyaa saluwaa denttiis; Gibxxe biitta ubban heezzu gallassa kumettaa sakkana xumai xumiis. ");
INSERT INTO wal_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","He heezzu gallassatun asi ooninne issoi issuwaa be7ennan, woikko ba sohuwaappe denddidi beennan takkiis. SHin Israa7eelati de7iyoosan ubban etau poo7oi de7ees. ");
INSERT INTO wal_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kawoi Muusa xeesissidi, “Biite; biidi GODAAYYO goinnite; intte maccaasaikka intte naatikka inttenaara baanau danddayoosona. Intte dorssaa wudiyaanne intte miizzaa wudiyaa xalaalaa yeggidi biite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","SHin Muusee a, “Nuuni yarshshuwaanne xuuggidi yarshshiyo yarshshuwaa GODAASSI, nu Xoossaassi, shiishshanau, mehiyaa nuuyyo immada yeddanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nu mehee ubbaikka nunaara baanau koshshees; qinccafile issoinne guyye attenna. GODAASSI, nu Xoossaassi, goinniyo goinuwaassi he mehiyaappe dooridi ekkanau koshshees; nuuni yaa gakkennan de7iiddi, mehiyaappe augaa augaa yarshshanaakko eranau danddayokko” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","SHin GODAI kawuwaa wozanaa dammissiis; dammissin i eta yeddanau koyibeenna. ");
INSERT INTO wal_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Hegaappe guyyiyan kawoi Muusa, “Kichcha ta achchappe! Naa77antto ta sinttan lem77i gaada nena era! Neeni ta aifiyaa, ta som77uwaa be7ido gallassaikka neeyyo haiqo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Yaagin Muusee a, “Tumakka; neeni giidoogaadan taani nena naa77antto mulekka be7ikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Muusessi GODAI, “Taani Gibxxe kawuwaa bollinne a asaa bolli issi hara bosha yeddana; hegaappe guyyiyan i inttena ha biittaappe kessi yeddana; kessiiddi i inttena issoinne attennan ubbaakka yedettana. ");
INSERT INTO wal_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Israa7eela asai, maccai attumai ba shoorotuppe biraappenne worqqaappe oosettida miishshata oichchana mala, etau oda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","GODAI Israa7eela asati Gibxxetu sinttan nashettanaadan oottiis. Qassi Muusee ba huuphenkka Gibxxe biittan kawuwaa sunttatuuninne asan keehi daro bonchchettida asadan xeelettiis. ");
INSERT INTO wal_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Muusee kawuwaa hagaadan yaagiis; “GODAI hagaadan yaagees; ‘Qammau gina shaahuwan taani Gibxxe gidduwaara kanttana; ");
INSERT INTO wal_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Gibxxe biittan de7iya baira attuma na7i ubbai, kawotaa araatan uttiya kawuwaa baira na7aappe doommidi, woxan gaacciya ashkkaree baira na7aa gakkanaassinne baira yelettida meheekka attennan ubbai haiqqana. ");
INSERT INTO wal_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Gibxxe biitta ubban hagaappe kase baggan hanibeennanne sinttappekka hanenna gita yeehoi yeehettana. ");
INSERT INTO wal_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","SHin Israa7eelatu gidduwan asa bolli woikko mehe bolli kaninne boccenna’ yaagees. He wode GODAI Gibxxe gidduwaaninne Israa7eela gidduwan zagaa medhdhiyoogaa neeni erana. ");
INSERT INTO wal_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ha ne sunttati ubbai duge taakko yiidi, ta sinttan gufannidi ziggana; ziggidi, ‘Kiyada barkkii! Nena kaalliya asai ubbaikka bo!’ yaagana. Hegaappe guyyiyan taani baana” yaagiis. Hegaappe guyyiyan Muusee hanqquwaa suulliiddi, kawuwaa sinttappe kiyidi biis. ");
INSERT INTO wal_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Muusessi GODAI kase, “Ta maalaalissiyaabai Gibxxe biittan darana mala, kawoi intte yootiyoogaa siyennan ixxana” yaagi wottiis. ");
INSERT INTO wal_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Muuseenne Aarooni ha maalaalissiyaabata ubbaa kawuwaa sinttan oottidosona; oottinkka GODAI kawuwaa wozanaa dammissiis; yaanin i Israa7eelata ba biittaappe yeddennan ixxiis. ");
INSERT INTO wal_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","GODAI Gibxxe biittan Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ha aginai intteyyo laittau koiro agina gido; ");
INSERT INTO wal_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Israa7eela asau ubbau ha wogaa odite; ha aginai gelido tammantta gallassan, issi asi ba so asau issi orgge dorssaa woikko issi orgge deeshshaa ekko. ");
INSERT INTO wal_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","He keettaa asaa qoodai he dorssaa wurssi maanau guuxxikko, inne ayyo ubbaappe matattiya shooroi bantta so asaa qoodona; qoodidi issi issi asi maanau danddayiyo keenaa akeekidi, he mehiyaa shukkidi issippe moona. ");
INSERT INTO wal_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Intte doori ekkiyo mehee yelettoosappe issi laitta gididoogaa, a bollan aiba pacinne bainna attumaagaa gido bayin. Intte he meheta dorssappe woikko deeshshappe ekkanau danddayeeta. ");
INSERT INTO wal_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ha aginaayyo tammanne oiddantta gallassaa gakkanaassi eta heemmite; he gallassi omarssi lankkilankkiyaagan Israa7eela maabaraa asai ubbai eta shukkana koshshees. ");
INSERT INTO wal_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","SHukkidi suuttaappe amaridaagaa ekkidi, eti miyo keettau naa77u qosilettaanne qoriyaa tiyona; ");
INSERT INTO wal_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ashuwaa he gallassi qammikka taman xiixxi xiixxidi, cammiya bonccuwaaranne uukkido oittaara mona. ");
INSERT INTO wal_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ashuwaa qayye woikko doissidi mooppite; huuphiyaakka gedetakka qantta giddo ashuwaakka ubbaa xiixxidi miite; ");
INSERT INTO wal_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","he ashuwaappe sa7ai wonttana gakkanaassi ainne ashshoppite; wonttana gakkanaassi amaridaagee attikko, hegaa xuugganau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Muussaa miiddi, ogiyaassi giigiya maayuwaa maayidi, intte caammaa intte tohuwan wottidi, intte gatimaa intte kushiyan oiqqidi meeta. Eesuwan eesuwan miite; hagee GODAA Paasikaa. ");
INSERT INTO wal_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Taani he gallassi qammi Gibxxeera kanttana; kanttaidda baira yelettida ubbaa, asaakka mehiyaakka worana; Gibxxe eeqatu ubbaa bollikka taani pirddana; taani GODAATTENNE. ");
INSERT INTO wal_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","He suuttai intte de7iyo keettata erissiya malaata gidana. Taani he suuttaa be7iyo wode, inttena aggada aadhdhana; taani Gibxxe biittaa boshan shociyo wode, inttena aiba boshikka bochchenna. ");
INSERT INTO wal_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ha gallassai intteyyo hassayi hassayi bonchchiyo gallassa gido; intte yeletai ubbai GODAA baalaa bonchchite; hagaa woga oottidi merinau bonchchite. ");
INSERT INTO wal_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Laappun gallassai gakkanau irshshuwaa yeggibeenna oittaa miite; shin koiro gallassi irshshuwaa intte sooppe diggite. He koiro gallassaappe doommidi laappuntta gallassi gakkanaassi, irshshuwaara de7iya oitta miya asi Israa7eela asaa giddoppe duuxxidi xayo. ");
INSERT INTO wal_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Koiro gallassi geeshsha yaa7aa shiiqite; hara geeshsha yaa7aa qassi laappuntta gallassan shiiqite; asai ubbai maanau quma kattanaappe attin, ha gallassatu ubban ainne oottoppite; intte oottanabi hegaa xalaala. ");
INSERT INTO wal_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Oittaa Baalaa bonchchite; aissi giikko, taani intte citaa Gibxxe biittaappe kessidoi he gallassa. He gallassaa, yeletaappe yeletaa gakkanaashin kantti kiyiya woga oottidi bonchchite. ");
INSERT INTO wal_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Koiro aginan, he aginaayyo tammanne oiddantta gallassa omarssaappe doommidi, laatamanne isiinintta omarssa gakkanaassi irshshoi gelibeenna oittaa miite. ");
INSERT INTO wal_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Laappun gallassa gakkanau irshshoi intte son beettoppo; irshshoi gelidobaa miya asi bete gidin woikko he biitta asa gidin, he aawu Israa7eela maabaraa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Irshshoi gelidobaa aibanne mooppite; intte de7iyoosan awankka irshshoi gelibeenna oittaa maanau koshshees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Hegaappe guyyiyan Muusee Israa7eela cimata ubbaa xeesissidi eta hagaadan yaagiis; “Intte sohuwaarakka biidi, intte so asaassi Paasikau orgge dorssaa woikko orgge deeshshaa shukkite. ");
INSERT INTO wal_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hiisoophphiyaa giyo mittaa haittaappe dankki ekkidi, keriyan de7iya suuttan naaqqi kessidi, he suuttaa naa77u qosilettatanne qoriyaa tiyite; intteppe issi asinne sa7ai wonttana gakkanaassi ba keettaa penggeppe kare kiyoppo. ");
INSERT INTO wal_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","GODAI Gibxxeta shoci woranau he biittaara kanttiyo wode, suuttaa qoriyaaninne naa77u qosilettatun be7ana; be7idi kareera aadhdhi bayana; xaissiyaagee intte soo gelidi, inttena worennaadan a intte soo gelissenna. ");
INSERT INTO wal_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Intte ha azazuwaa intteyyoonne intte zerettaayyo merinau woga oottidi azazettite. ");
INSERT INTO wal_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","GODAI kase immana giidoogaadan i immiyo biittaa intte geliyo wode, ha wogaa naagite. ");
INSERT INTO wal_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Intte naati inttena, ‘Ha bonchcho baalaa birshshettai aibee?’ yaagidi oichchiyo wode, ");
INSERT INTO wal_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","intte eta, ‘Hagee GODAA bonchchanau yarshshiyo Paasikaa yarshshuwaa; aissi giikko, GODAI Gibxxe biittan Israa7eela asaa keettaa aggi aadhdhidi biidi, Gibxxeta woriiddi, nuna ashshido gishshataassa’ yaagite” yaagiis. Hegaappe guyyiyan asai gulbbatidi goinniis. ");
INSERT INTO wal_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Israa7eelati GODAI Muusanne Aaroona azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Qammau gina shaahuwan GODAI Gibxxen baira yelettida ubbaa, kawotaa araatan uttida kawuwaa baira na7aappe doommidi, qasho keettan de7iya omoodettidaageetu baira na7aa gakkanaassi, qassi baira yelettida mehiyaa ubbaa dippi oottiis. ");
INSERT INTO wal_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kawoi, a sunttati ubbainne Gibxxe biittaa asai ubbai qammi denddidosona. Gibxxe biittan asi haiqqibeenna keetti mulekka bainna gishshau, asai qaalaa xoqqu oottidi gita yeehuwaa yeekkiis. ");
INSERT INTO wal_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","He gallassa qammikka kawoi Muusanne Aaroona xeesidi, “Denddite! Inttekka Israa7eela asaikka ta asaa gidduwaappe kiyite! Biidi intte oichchidoogaadankka GODAAYYO goinnite! ");
INSERT INTO wal_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Intte giidoogaadankka intte dorssaa wudiyaanne intte mehiyaa wudiyaa ekkidi biite! Qassi tanakka anjjite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Gibxxe asai Israa7eelati biittaappe eesuwan kiyana mala dirbbissidosona. Aissi giikko, eti, “Hinna xayikko, nuuni ubbaikka wuroos” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hegaa gishshau, Israa7eela asati bantta irshshoi gelibeenna munaqaa munaqa keriyan kunttidi, bantta maayuwan xaaxidi, bantta hashiyan tookkidosona. ");
INSERT INTO wal_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israa7eelati Muusee eta azazidoogaadan, Gibxxeta bira miishshata, worqqa miishshatanne maayuwaa, “Immite” giidi oichchidosona. ");
INSERT INTO wal_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","GODAI Gibxxetu sinttan he asai sabettanaadan oottin, Gibxxeti eti oichchidobaa immidosona. Hegaadan yaatidi eti Gibxxe asatu aquwaa bonqqi ekkidi biidosona. ");
INSERT INTO wal_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israa7eelati Raamisa giyo katamaappe denddidi Sukkota giyo sohuwaa tohuwan hemettidi biidosona. Asai naatanne maccaasaa gujjennan qoodin, usuppun xeetu sha7a. ");
INSERT INTO wal_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Qassi etaara hara daro asai, daro meheenne dorssaa deeshshaa wudee laagettidi biis. ");
INSERT INTO wal_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Gibxxeppe eti ekkidi kiyido munaqaa irshshoi gelibeennaagaa oittaa uukkidosona; aissi giikko, eti Gibxxeppe dirbban kiyidosona; banttau shinqqe kattanaukka, munaqi denddin uukkanaukka eta gattibeenna. ");
INSERT INTO wal_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israa7eelati Gibxxe biittan de7ido laittai oiddu xeetanne hasttama. ");
INSERT INTO wal_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","He oiddu xeetanne hasttamu laittai wuriyo he wurssetta gallassan, GODAA asai ubbai Gibxxe biittaappe kiyiis. ");
INSERT INTO wal_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","GODAI ba asaa naagidi, Gibxxe biittaappe kessiyo wode sa7ai qamma; he qammai yeletaappe yeletaa gakkanaassi, Israa7eela asai beegottidi naagiiddi aqiyo, GODAAYYO dummatida qamma. ");
INSERT INTO wal_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","GODAI Muusanne Aaroona, “Paasikaa gallassaa bonchchiyo wogai hageeho; bete asi appe mulekka mooppo. ");
INSERT INTO wal_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Intte miishshan shammido aillee intte a qaxxaridoogaappe guyyiyan appe mo. ");
INSERT INTO wal_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","SHin ha77issau inttenaara takkiya imattinne kera oottiya imatti appe mooppo. ");
INSERT INTO wal_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Ha Paasikaa intte issi keettan miite; intte he ashuwaappe aibanne kare kessoppite. Meqettatuppe issuwaanne menttoppite. ");
INSERT INTO wal_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israa7eela maabarai ubbai Paasikaa bonchchanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Beti yiidi intte giddon de7iya asi GODAA Paasikaa bonchchanau koyikko, ba so attuma asa ubbaara qaxxaretto. Hegaappe guyyiyan i he biittan yelettida asadan shiiqidi, Paasikaa bonchchanau danddayees. SHin qaxxarettibeenna asi mulekka appe mooppo. ");
INSERT INTO wal_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Intte biittan yelettidaagaukka intte giddon bete gididi de7iyaagaukka he wogai issuwaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Yaagin Israa7eelati ubbai GODAI Muusanne Aaroona azazidoogaadankka oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","He gallassikka GODAI Israa7eelata eta citan citan Gibxxe biittaappe kessiis. ");
INSERT INTO wal_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Baira yelettida attuma ubbaa taayyo dummaya. Israa7eela asaa giddon uloppe yelettida bairi ubbi, mehiyaa gidin asaa gidin, ubbaikka tabaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Hegaappe guyyiyan Muusee asaa, “Gibxxeppe, ailletettaa biittaappe intte kiyido gallassaa, ha gallassaa hassayite; aissi giikko, GODAI ba wolqqaama kushiyan inttena kessiis; hegaa gishshau, irshshoi gelidobaa aibanne mooppite. ");
INSERT INTO wal_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Intte hachchi Abiiba aginan kiyeeta. ");
INSERT INTO wal_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","GODAI Kanaanetu, Hiitetu, Amooretu, Hiiwetunne Yaabuusatu biittaa inttena gattiyo wode, intte ha bonchcho gallassaa ha aginaa bonchcheeta. He biittai GODAI inttessi immana mala, kase intte aawatussi caaqqi wottido biittaa. He biittai maattainne eessai goggiyo biittaa. ");
INSERT INTO wal_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Intte laappun gallassi irshshoi yegettibeenna oittaa maana; laappuntta gallassai GODAA baalaa gidana. ");
INSERT INTO wal_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","He laappun gallassatun irshshoi yegettibeenna oittaa intte maana; intte giddon irshshoora de7iyaabi aibinne beettoppo; ne biittaa zawan awaaninne irshshoi beettoppo. ");
INSERT INTO wal_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“He gallassi neeni ne na7aayyo, ‘Taani hagaa oottiyoogee, taani Gibxxeppe kiyiyo wode, GODAI taayyo oottidoogaa hassayanaassa’ yaagada yoota. ");
INSERT INTO wal_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","GODAI inttena ba wolqqaama kushiyan Gibxxeppe kessido gishshau, GODAA higgee intte doonaappe wodhdhennaadan, ha bonchchettiya ayyaana gallassai ne kushiyan qachchidonne ne merchchiyan wottido hassayissiyaabaa mala gidana. ");
INSERT INTO wal_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Hegaa gishshau, intte ha wogaa laittan laittan keerido wodiyan bonchchite. ");
INSERT INTO wal_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“GODAI intteyyoonne intte maizza aawatuyyo immanau caaqqidoogaadan, i inttena Kanaanetu biittaa gelissidi, he biittaa intteyyo immiyo wode, ");
INSERT INTO wal_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","uloppe baira yelettida ubbaa GODAAYYO dummaya; ne mehiyan baira yelettiya attuma ubbai GODAASSA. ");
INSERT INTO wal_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Baira yelettiya hare ubbaa dorssa maran woza ekka; wozennabaa gidikko, a morggiyaa mentta; ne attuma naatu giddon baira yelettidaageeta ubbaa woza. ");
INSERT INTO wal_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Sinttaara yaana wodiyan ne na7ai nena, ‘Hagee aibee?’ yaagidi oichchikko, neeni a, ‘GODAI nuna wolqqaama kushiyan Gibxxeppe, ailletettaa biittaappe kessiis; ");
INSERT INTO wal_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Gibxxe kawoi dammidi nuna yeddennan ixxin, GODAI Gibxxe biittan de7iya baira ubbaa, asaappe doommidi mehiyaa bairaa gakkanaassi woriis. Taani aayi uloppe koiro yelettida attumaa ubbaa GODAASSI yarshshiyoogeenne ta baira attuma naata taani woziyoogee hegaassa’ yaaga. ");
INSERT INTO wal_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","GODAI nuna ba wolqqaama kushiyan Gibxxeppe kessidoogau, hagee intteyyo kushen qachchidonne merchchen wottido malaata mala gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kawoi asaa yeddido wode, Xoossai eta Pilisxxeema biittaara kanttissiya ogee mata gidikkonne he ogiyaara kaalettibeenna; aissi giikko, Xoossai, “Asai olaa be7ikko, ba qofaa laammidi, guyye Gibxxe simmanaakkonne” yaagidi qoppiis. ");
INSERT INTO wal_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hegaa gishshau, Xoossai asaa bazzo ogiyaara yuushshidi, Zo7o Abbaakko kaalettiis. Israa7eelati Gibxxe biittaappe olau giigidi pude kiyidosona. ");
INSERT INTO wal_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Yooseefi Israa7eela asaa caaqetti wottido gishshau, Muusee a meqettaa banaara ekkidi biis; Yooseefi eta, “Xoossai tumuppe inttena maaddanau yaana; he wode intte ta meqettaa ha sohuwaappe pude inttenaara ekkidi biite” yaagidi odi wottiis. ");
INSERT INTO wal_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Eti Sukkotappe denddidi bazzuwaa doonan de7iya Etaaman uttidosona. ");
INSERT INTO wal_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","GODAI eti gallassikka qammikka hemettana mala, gallassan eta ogiyaa bessanau shaaraa tuussan, qammi etau poo7issanau tamaa tuussan eta kaalettiis. ");
INSERT INTO wal_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gallassi shaaraa tuussai woikko qammi tamaa tuussai asaa sinttappe kichchibeenna. ");
INSERT INTO wal_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Hegaappe guyyiyan Muusa GODAI hagaadan yaagiis; “Eti guyye simmidi Migidoolappenne abbaappe gidduwan, Pihaahiroota matan uttanaadan oda; eti abbaa lanqqen Ba7aali-Xafoonau sintta baazzan uttona. ");
INSERT INTO wal_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Kawoi, ‘Israa7eelati bazzoi gorddin, haniyoobaa xayidi biittan coo toilattoosona’ yaagidi qoppana. ");
INSERT INTO wal_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Taani kawuwaa wozanaa dammissana; i eta yedettana; taani kawuwaa baggaaranne a olanchchatu ubbaa baggaara bonchchettana; Gibxxetinne taani GODAA gidiyoogaa erana” yaagiis. Yaagin Israa7eelati i yootidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Asai baqatiichchidoogaa Gibxxe kawuwaayyo yootin, inne a sunttati Israa7eelatuyyo qoppido bantta qofaa laammidi, “Nuuni hagaa waatiyoonii? Nuuni Israa7eelata yeddidi, eti nuuyyo oottiyo wolqqaappe mela attida” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Hegaa gishshau, i ba para gaariyaa kooridi, ba olanchchata banaara ekkidi denddiis. ");
INSERT INTO wal_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","I usuppun xeetu ubbaappe aadhdhiya para gaareta, Gibxxe biittan de7iya hara gaaretu ubbaara, eta ubbau halaqaa halaqaa sunttidi ekkidi biis. ");
INSERT INTO wal_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","GODAI Gibxxe biittaa kawuwaa, kawuwaa wozanaa dammissin, kessaa bolli de7iya Israa7eela asaa yedettiis. ");
INSERT INTO wal_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Hegaappe guyyiyan Gibxxe asati, kawuwaa parati ubbainne paraa gaareti, paraasatinne olanchchati Israa7eelata kaallidi yedettidosona. Abbaa doonan Ba7aali-Xafoona sintta baazzan de7iya Pihaahiroota matan eti uttidaashin demmidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kawoi matiichchin, Israa7eelati xoqqu gi xeelliyo wode, Gibxxeti eta geeduwaa kaallidi yiidoogaa be7idosona; be7idi daroppe yayyidi, GODAAYYO waassidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Eti Muusa, “Neeni nuna Gibxxen duufoi xayin bazzon haiqqanaadan kessadiiyye? Nuna Gibxxeppe aibau ehaadii? ");
INSERT INTO wal_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Gibxxen de7iiddi nuuni, ‘Nuna aggaaga; nuuni Gibxxetuyyo haarettana’ yaagidi neeyyo odibookkonii? Bazzon haiqqanaappe etayyo haarettiyoogee nuuyyo lo77o shin” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","SHin Muusee asaa, “Yayyoppite; minni eqqite; GODAI hachchi inttena ashshiyo ashettaa intte be7ana. Hachchi intte be7iyo Gibxxeta naa77antto mulekka be7ekketa. ");
INSERT INTO wal_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Intte gishshaa GODAI olettana; intteppe koyettiyai co77u geetta xalaala” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","GODAI Muusa, “Neeni taakko aissi waassai? Israa7eelati sinttau hemettana mala yoota. ");
INSERT INTO wal_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ne gatimaa dentta; denttada abbaa bolli micca; haattai naa77u kiyidi shaahettana; Israa7eelatikka mela biittaara abbaa pinnidi baana. ");
INSERT INTO wal_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Taani Gibxxetu wozanaa dammissin, eti intte geeduwaa kaallidi abban gelana. Taani kawuwaanne a olanchchatu ubbaa baggaara, a para gaaretunne a paraasatu baggaara bonchchuwaa taayyo demmana. ");
INSERT INTO wal_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Taani kawuwaa baggaara, a para gaaretu baggaaranne a paraasatu baggaara taayyo bonchchuwaa demmido wode, taani GODAA gidiyoogaa Gibxxeti erana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hegaappe guyyiyan Xoossaa kiitanchchai, Israa7eela olanchchatuppe sinttaara hemettiyaagee, guyye aadhdhidi etappe guyyeera hemettiis. SHaaraa tuussaikka eta sinttan de7iyoosaappe guyye baggi yuuyidi, ");
INSERT INTO wal_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Gibxxetu olanchchatuppenne Israa7eelatu olanchchatuppe gidduwan eqqiis. He shaarai qamma ubban issi baggaara xumissidi, hinkko baggaara poo7issiis; yaatin qamma ubbaa issoi issuwaakko shiiqibookkona. ");
INSERT INTO wal_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Hegaappe guyyiyan Muusee abbaa bollan ba kushiyaa micciis; GODAI he gallassi qamma ubban arshsho wolqqaama carkkuwaa yeddidi, abbaa guyye zaariis; zaaridi mela biitta kessiis. Haattai shaahettiis. ");
INSERT INTO wal_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israa7eelati abbaa gidduwan mela biittaara hemettidi, haattai etayyo ushachchaaranne haddirssaara godadan eqqidaashin biidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Gibxxeti eta yedettidosona; kawuwaa para ubbati, a para gaaretinne a paraasati eta kaallidi, abbaa giddo gelidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Biron bakkaalee dolanaappe kasetidi, GODAI tamaanne shaaraa tuussaappe duge zaaridi, Gibxxetu olanchchata xeelliis; xeellidi eta wozanaa bashshiis. ");
INSERT INTO wal_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Laagoi eta waissana mala, GODAI eta para gaaretu irzzuwaa binqqirssaa diggiis; diggin Gibxxeti, “GODAI eta maaddidi Gibxxe oliyo gishshau, ane nuuni Israa7eela asaappe baqatoos” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","GODAI Muusa, “Haattai Gibxxetu bolli, eta para gaaretu bollinne eta paraasatu bolli guyye goggana mala, ne kushiyaa abbaa bollan micca” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Yaagin Muusee ba kushiyaa abbaa bollan micciis; sa7ai wonttishin, abbai ba kase sohuwaa guyye simmiis; Gibxxeti yaa a giddo baqatishin, GODAI Gibxxeta abbaa gidduwan aatti yeggiis. ");
INSERT INTO wal_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Haattai guyye simmidi, para gaareta paraasatanne Israa7eelata kaallidi abbaa gelida kawuwaa olanchchata muliyaa mitti bayiis; etappe issoinne attibeenna. ");
INSERT INTO wal_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","SHin Israa7eelati abbaa gidduwaara mela biittan hemettidi, haattai etau ushachchaaranne haddirssaara godadan eqqidaashin biidosona. ");
INSERT INTO wal_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","GODAI he gallassi Israa7eela asaa Gibxxetu kushiyaappe hagaadan ashshiis. Qassi Israa7eelati Gibxxeti haiqqidi zin77idaageeta abbaa doonan be7idosona. ");
INSERT INTO wal_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israa7eelatikka GODAI Gibxxetu bolli bessido gita wolqqaa be7ido wode, asai GODAAYYO yayyiis; yayyidi akka a ashkkaraa Muusakka ammaniis. ");
INSERT INTO wal_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","He wode Muuseenne Israa7eela asai ha mazamuriyaa GODAAYYO yexxidosona; “Bonchchuwan i keehi xoqqu xoqqu giido gishshau, taani GODAAYYO mazamuriyaa yexxana. Paraanne paraa toggidaagaa abban oliis. ");
INSERT INTO wal_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","GODAI ta wolqqaanne ta mazamuriyaa; i tana ashshiyaagaa gidiis. I ta Xoossaa; taani a sabbana. I ta aawaa Xoossaa; taani a xoqqu xoqqu oottana. ");
INSERT INTO wal_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","GODAI olanchcha; a sunttaikka GODAA. ");
INSERT INTO wal_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Gibxxe kawuwaa para gaaretanne a olanchchata abban oliis. Gibxxe kawuwaa halaqati, ubbaappe aadhdhi lo77iyaageeti Zo7o Abban muukettidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ciimma haattai eta kammiis; eti shuchchadan ciimman mitettidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Abeet GODAU, ne ushachcha kushee wolqqan goobidaagaa; GODAU, ne ushachcha kushee morkkiyaa mentterettiis. ");
INSERT INTO wal_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ne bonchchuwaa gitatettan nenaara gaaddetidaageeta oladasa. Ne eexxiya hanqquwaa neeni yeddin, i eta daladan miis. ");
INSERT INTO wal_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ne siiriyaara kiyiya shemppuwan haattai doorettiis. Goggiya haattainne godadan minni eqqiis; ciimma haattati abbaa gomppan irkkidi minnidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Morkkee ceeqettiiddi, ‘Taani eta yedettada oiqqana. Taani eta aquwaa shaakkada, ta koyidobaa ubbaa ekkana. Taani ta bisuwaa shoddada, eta xaissana’ yaagidi ceeqettiis. ");
INSERT INTO wal_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","SHin neeni eta ne shemppuwan punnin, abbai eta kammiis. Eti wolqqaama haattan irssaasiyaa giyo biratai mitettiyoogaadan mitettidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Abeet GODAU, Xoossatu giddon ne malai oonee? Geeshshatettan bonchchettiyaabi, bonchchuwan yayettiyaabi, garamiyaabaa oottiyaabi ne malai oonee? ");
INSERT INTO wal_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Neeni ne ushachcha kushiyaa miccin, biittai eta mittiis. ");
INSERT INTO wal_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Neeni wozido asaa aggenna ne siiquwan kaalettana. Neeni ne wolqqan eta neeni de7iyo geeshsha sohuwaa gelissadasa. ");
INSERT INTO wal_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kawotettati hegaa siyidi kokkoridosona. Pilisxxeema biittaa asatikka maareti oiqqidobaadan un77ettidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","He wode Eedooma biittaa halaqati dagammidosona. Moo7aaba biittaa haariyaageeta yashshai kokkorssiis. Kanaane asati maashidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Dagamainne yashshai eta oiqqiis. Abeet GODAU, eti ne wolqqaa gitatettaa be7idi, ne asai aadhdhana gakkanaassi, neeni wozido asai aadhdhana gakkanaassi, shuchchadan tolettidi eqqidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Neeni eta ehaada, ne buzo gaden de7iya deriyaa huuphiyan tokkana. Abeet Godau, he sohoi neeni neeyyo de7anau oottido soho. Abeet Godau, he geeshsha sohoi neeni ne kushiyan minttada essido soho. ");
INSERT INTO wal_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","GODAI merinaappe merinau kawotana” yaagidi yexxidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Gibxxe kawuwaa parati, a para gaaretinne a paraasati abban gelido wode, GODAI abbaa haattaa guyye zaaridi eta bolli ehiis; shin Israa7eelati abbaa gidduwaara mela biittaara hemettidi biidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aaroona michchiyaa, hananabaa yootiya Miiriyaama karaabiyaa ekkaasu; maccaasai ubbai karaabiyaa baqqiiddinne yexxiiddi o kaallidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miiriyaama etayyo mazamuriyaa yexxaidda, “GODAI keehi xoqqu xoqqu giido gishshau, ayyo yexxite. Paraanne paraa toggidaagaa i abban oliis” yaagada yexxaasu. ");
INSERT INTO wal_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hegaappe guyyiyan Muusee Israa7eela Zo7o Abbaappe kaalettin, eti Suura giyo bazzuwaa biidosona. He bazzuwan eti haatta demmennan heezzu gallassaa hemettidosona. ");
INSERT INTO wal_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Eti Maara giyoosaa gakkido wode, Maara haattai camo gidido gishshau, uyana danddayibookkona; hegaa gishshau, he sohoi Maara geetettiis. ");
INSERT INTO wal_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Hegaa gishshau, asai, “Nuuni ai uyanee?” yaagidi Muuse bolli zuuzummiis. ");
INSERT INTO wal_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Zuuzummin Muusee GODAAYYO waassiis; waassin GODAI a issi mitta bessiis; Muusee he mittaa haatta giddo olin, haattai mal77iis. Yan GODAI etau awaajuwaanne higgiyaa kessiis; yan GODAI eta paacciis. ");
INSERT INTO wal_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I eta hagaadan yaagiis; “GODAI intte Xoossai odiyoobaa minttidi siyikkonne a aifiyaa sinttan likkebaa oottikko, intte a azazuwaa ezggikkonne a awaajuwaa ubbaa naagikko, taani Gibxxetu bolli ehiido harggiyaappe issuwaanne intte bolli ehiikke; aissi giikko, taani inttena pattiya GODAATTENNE” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Hegaappe eti Elaama biitti yiidosona; yan tammanne naa77u haatta pulttotinne laappun tammu zambba mittati de7oosona. Eti yan haattaa doonan uttidosona. ");
INSERT INTO wal_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Gibxxeppe kiyido naa77antto aginan, tammanne ichchashantto gallassan Israa7eela asaa maabarai kumettai Eliimappe denddidi, Eliimappenne Siinaappe gidduwan de7iya Siinaa giyo bazzuwaa yiis. ");
INSERT INTO wal_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Israa7eela asaa maabarai ubbai bazzuwan Muuse bollinne Aaroona bolli zuuzummidosona. ");
INSERT INTO wal_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israa7eelati eta, “Nuuni Gibxxe biittan GODAA kushiyan haiqqidaa gidorkkoniishsha! Yan nuuni nuugaa ashuwaa keriyaa yuuyi aadhdhi uttidi, nuuni koyido qumaa ubbaa miida; shin intte nuna kessidi, ha geeshsha yaa7aa ubbaa namisan woranau bazzo ehiideta” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yaagin GODAI Muusa, “Taani intteyyo saluwaappe oittaa bukissana; asai ubba gallassikka kiyidi, hachchi hachchissi gidiyaagaa xalaalaa maxanau koshshees. Asai ta azazuwaa kaalliyaakko kaallennaakko taani eta hegan paaccana. ");
INSERT INTO wal_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Usuppuntta gallassi eti haroode maxiyoogau naa77u kushiyaa maxidi, kattona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Hegaa gishshau, Muuseenne Aarooni Israa7eela asa ubbaayyo, “Inttena Gibxxe biittaappe kessidaagee GODAA gidiyoogaa omarssi intte erana; ");
INSERT INTO wal_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","qassi GODAA bonchchuwaa maallado intte be7ana; aissi giikko, a bolli intte zuuzummidoogaa i siyiis; intte nu bolli zuuzummanau nuuni oonee?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Hegaappe guyyiyan Muusee, “I intteyyo maanau omarssi ashuwaa immiininne intte koyiyo oittaa ubbaa intteyyo maallado immin, i GODAA gidiyoogaa intte hegan erana. Aissi giikko, intte a bolli zuuzummidoogaa i siyiis. Nuuni oonee? Intte nu bolli zuuzummekketa; intte GODAA bolli zuuzummeeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Muusee Aaroona, “Neeni Israa7eela asaa maabara ubbaa, ‘GODAI intte zuuzunttaa siyido gishshau, GODAA sintti haa shiiqite’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aarooni Israa7eela asaa maabara ubbau haasayissishin, eti bazzuwaakko simmidi xeellidosona; hegan GODAA bonchchoi shaara giddon qoncciyaagaa be7idosona. ");
INSERT INTO wal_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","GODAI Muusa, “Taani Israa7eelatu zuuzunttaa siyaas; neeni etayyo, ‘Omarssan ashuwaa intte maana; maallado oittaa intte kallana; he wode intte taani GODAA intte Xoossaa gidiyoogaa erana’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","He gallassi omarssan kuraachchoti yiidi, Israa7eela asai de7iyoosaa maayidosona; qassi maallado eta dunkkaanetu yuushuwan xaazai xaazaa bolli yekekki uttiis. ");
INSERT INTO wal_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Xaazai xaskkido wode, sa7an wodhdhida shachcha misatiya burcce poqoi bazzo biittaa bollan beettiis. ");
INSERT INTO wal_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israa7eelati hegaa be7ido wode, eti issoi issuwaa, “Hagee aibee?” yaagidosona. Aissi giikko, eti i aibakko eribookkona. Yaatin Muusee eta, “Intteyyo maanau GODAI immido oittai hagaa. ");
INSERT INTO wal_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","GODAI hagaadan yaagidi azaziis; ‘Asai issoi issoi baayyo maanau koshshiyaagaa keenaa shiishsho; intte dunkkaane giddon de7iya asai huuphiyan huuphiyan naa77u litiro gidiyaagaa ekkite’ yaagiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israa7eelati Muusee etau yootidoogaadan oottidosona; issoi darissidi, issoi guuttidi shiishshidosona. ");
INSERT INTO wal_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","SHiishshidi eti litiruwan makkido wode, darissidi shiishshidaagau palahibeenna; guuttaa shiishshidaagau paccibeenna; ubbaikka huuphiyan huuphiyan bau miyoogaa keenaa shiishshiis. ");
INSERT INTO wal_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Hegaappe guyyiyan Muusee eta, “Ooninne appe wonttossi ashshoppo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Gidikkonne etappe issooti issooti Muusee yootiyoogaa ekkennan aggidi, attaa maallado gakkanau wottidosona; wottidoogee guxunidi xinqqiis. Hegaa gishshau, Muusee eta hanqqettiis. ");
INSERT INTO wal_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Maallado maallado asai ubbai baayyo koshshiyaagaa shiishshiis; awai michchiyo wode sa7an attidaagee seeri aggiis. ");
INSERT INTO wal_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Usuppuntta gallassan eti kaseegau naa77u kushiyaa shiishshoosona; issi issi asau oiddu litiro keenaa giyoogaa. Yaatin maabaraa halaqati yiidi hegaa Muuseyyo yootidosona. ");
INSERT INTO wal_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Yootin i eta, “GODAI azazidoogee hagaa; wonttoi shemppo gallassa, GODAASSI geeshsha Sambbata. Hegaa gishshau, intte uukkiyoobaa uukkite; intte doissiyoobaanne doissite; palahidaagaa wonttossi ashshite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Hegaa gishshau, eti Muusee azazidoogaadan wonttossi wottidosona; wottin xinqqibeenna woikko guxunibeenna. ");
INSERT INTO wal_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","“Hachchi miite; aissi giikko, hachchi GODAA Sambbata; intte a hachchi dembban demmekketa. ");
INSERT INTO wal_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Intte usuppun gallassan a shiishshanau danddayeeta; shin laappuntta gallassai Sambbata. Sambbatan aibinne de7enna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Yaaginkka laappuntta gallassan issi issi asai shiishshanau kiyiis; shin eti ainne demmibookkona. ");
INSERT INTO wal_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","GODAI Muusa, “Ta azazotanne ta higgeta naagiyoogaa aude gakkanaassi ixxuuteetii? ");
INSERT INTO wal_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","GODAI intteyyo Sambbataa immidoogaa akeekite; usuppuntta gallassan i intteyyo naa77u gallassa oittaa immiyoogee hegaa gishshaassa. Laappuntta gallassi ubbai ba de7iyoosan de7iyoosan takko; ooninne kare kiyoppo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hegaa gishshau, asai laappuntta gallassan shemppiis. ");
INSERT INTO wal_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israa7eela asai he oittaa mannaa giidi sunttiis. Mannai deebbo aifedan bootta; eessaara uukkido lichchakkodan mal77ees. ");
INSERT INTO wal_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Muusee Israa7eela asaa, “GODAI azazidobai hagaa; ‘Taani inttena Gibxxe biittaappe kessido wode, bazzon mizido oittaa eti be7ana mala, mannaappe naa77u xaasa gidiyaagaa intte yaana yeletaassi ashshi wottite’ yaagidi azaziis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Yaagin Muusee Aaroona, “Issi xaaro ekkada naa77u litiro kumetta mannaa an qola; yaatada yaana yeletaassi minjjettana mala, GODAA sinttan wotta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","GODAI Muusa azazidoogaadan minjjettana mala, Aarooni mannaa GODAA sinttan wottiis. ");
INSERT INTO wal_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israa7eelati bantta de7iyo biittaa yaana gakkanaassi oitamu laittaa mannaa miidosona; eti Kanaane biittaa zawaa gakkana gakkanaassi mannaa miiddi de7idosona. ");
INSERT INTO wal_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","He wode asai makkiyo erettida miishshai laatamanne naa77u litiro oiqqees. ");
INSERT INTO wal_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israa7eelatu maabara ubbai GODAI azazidoogaadan, issi sohuwaappe hara sohuwaa yuuyiiddi, Siinaa Bazzuwaappe denddidi biidi, Rafiidima giyo sohuwan uttidosona. SHin asai uyanau haatti he sohuwan xayiis. ");
INSERT INTO wal_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Xayin eti Muuseera ooyettidi a, “Nuuyyo uyanau haatta imma” yaagidosona. Yaagin Muusee zaaridi, “Intte tanaara aissi ooyetteetii? GODAA intte aissi paacceetii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","SHin asai yan haattaa saamettidi, Muuse bolli zuuzummidosona. Eti a, “Neeni nuna, nu naatanne nu mehiyaa saamuwan woranau Gibxxeppe kessada pude aissi ehaadii?” yaagidi Muuse bollan zuuzummidosona. ");
INSERT INTO wal_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Yaanin Muusee, “Taani ha asaa waatoo? Eti tana shuchchan caddana hanoosona” yaagidi GODAAKKO waassiis. ");
INSERT INTO wal_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","GODAI Muusa, “Neeni asaappe sinttau hemetta; Israa7eela asaa cimatuppe nenaara efa; ini neeni Naile SHaafaa haattaa shocido gatimaa ne kushiyan oiqqada ba. ");
INSERT INTO wal_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Taani Siinaa Deriyaa zaallaa bolli ne sinttan eqqana; neeni he zaallaa shoca; asai uyanau appe haattai kiyana” yaagiis. Muusee Israa7eela cimatu sinttan hegaadan oottiis. ");
INSERT INTO wal_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Israa7eelati, “GODAI nu giddon de7iiyye de7ennee?” yaagidi ooyettido gishshaunne GODAA paaccido gishshau, he sohuwaa Masaahanne Mariiba giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaaleeqati yiidi, Rafiidiman Israa7eelatuura olaa gaittidosona. ");
INSERT INTO wal_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Muusee Yaasa, “Neeni nuuyyo asaa doorada, kiyada Amaaleeqatuura oletta; taani wontto Xoossaa gatimaa oiqqada, keraa huuphiyan eqqana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yaagin Yaasu Muusee giidoogaadan, Amaaleeqatuura olettiis. Muusee, Aarooninne Huuri keraayyo huuphiyaa kiyidosona. ");
INSERT INTO wal_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Muusee ba kushiyaa dentti gam77ido keenan ubban Israa7eelati xoonoosona; shin i ba kushiyaa ziqqissido wode Amaaleeqati xoonoosona. ");
INSERT INTO wal_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Muuse kushee arggaacido wode, eti shuchchaa ekki ehiidi, Muusa a bolli utissidosona. Aarooninne Huuri issoi issi baggaara issoi hinkko baggaara gididi, a kushiyaa sitti oottidi oiqqidosona. Yaatin awai wullana gakkanaassi a kushee sitti giidi takkiis. ");
INSERT INTO wal_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Hegaa gishshau, Yaasu Amaaleeqatu olanchchata bisuwan xooniis. ");
INSERT INTO wal_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Hegaappe simmin, Muusa GODAI hagaadan yaagiis; “Hagee ubbaton hassayettana mala hagaa xaafa. Yaatada Yaasa sissennan aggoppa; aissi giikko, saloppe garssan taani Amaaleeqa asata ciraara xaissana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Muusee yarshshuwaa yarshshiyoosaa keexxidi, “GODAI ta Banddiraa” giidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","I hagaadan yaagiis; “Kusheti pude GODAA kawotaa araataakko denddidosona; yeletaappe yeletaa gakkanaashinkka GODAI Amaaleeqatuura olettana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Midiyaama biittaa qeesee, Muuse bolloi Yatiroi, GODAI Muuseyyoonne a asaa Israa7eelayyo oottidobaa ubbaanne GODAI Israa7eela Gibxxeppe kessidobaa siyiis. ");
INSERT INTO wal_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","He wode Muuse bolloi, Yatiroi, Muusee yeggidi biido a keettaayyiyo Xippaaronne i naa77u naata ehiis. ");
INSERT INTO wal_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Etappe issuwaa sunttai Gershshooma; aissi giikko, Muusee, “Taani asa biittan bete gidaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Naa77anttuwaa sunttai El77aazara; aissi giikko, i, “Ta aawaa Xoossai tana maaddidaagaa; i tana Gibxxe kawuwaa bisuwaappe ashshiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Muuse bolloi Yatiroi a attuma naatuuranne a keettaayeera Xoossaa deriyaa matan de7iya Muusekko yiis. ");
INSERT INTO wal_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","I Muusa, “Taani, ne bolloi Yatiroi, ne keettaayeeranne i naa77u naatuura neekko yais” yaagidi akko kiitti wottiis. ");
INSERT INTO wal_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Hegaa gishshau, Muusee ba bolluwaara gaittanau kiyidi, ayyo ziggidi a yeriis. Eti issoi issuwaa sarotidi, dunkkaane giddo gelidosona. ");
INSERT INTO wal_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","GODAI Israa7eela asaa gishshau, kawuwaa bollinne Gibxxetu bolli oottido ubbaa, ogiyan eta gakkida daafuraabaa ubbaanne GODAI eta ashshidobaa Muusee ba bolluwaayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Israa7eela asaa Gibxxetu kushiyaappe ashshanau GODAI oottido lo77o oosotubaa siyidi, Yatiroi ufaittiis. ");
INSERT INTO wal_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ufaittidi, “Inttena Gibxxetu kushiyaappenne kawuwaa kushiyaappe ashshida GODAI, Gibxxetu kushiyaappe asaa kessi ekkidaagee, i galatetto. ");
INSERT INTO wal_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","GODAI hara Xoossatuppe ubbaappe gooba gidiyoogaa taani ha77i erais; aissi giikko, i hagaa Israa7eela asaassi iitidaageetussi oottiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Hegaappe guyyiyan Yatiroi, Muuse bolloi, xuuggiyo yarshshuwaanne hara yarshshota Xoossaayyo ehiis; Aarooninne Israa7eela cimati ubbai Xoossaa sinttan Muuse bolluwaara oittaa maanau yiidosona. ");
INSERT INTO wal_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Wonttetta gallassi Muusee asaayyo pirddanau uttiis; asai Muuse yuushuwan maalladoppe omarssi gakkanaassi eqqiis. ");
INSERT INTO wal_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Muuse bolloi Muusee asaayyo oottiyoobaa ubbaa be7idi, “Neeni ha asaayyo oottiyoogee hagee aibee? Asai ubbai maalladoppe doommidi omarssi gakkanaassi ne yuushuwan eqqidaashin, neeni nerkka daannadan aissi utta bayadii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Yaagin Muusee ba bolluwaa, “Asai Xoossaa sheniyaa oichchanau taakko yiyo gishshaassa. ");
INSERT INTO wal_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Etayyo yohoi de7ikkokka taakko yoosona; taani issi uraa gidduwaaninne a shooruwaa gidduwan pirddais; Xoossaa awaajuwaanne higgiyaa eta erissais” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Muuse bolloi, “Hagee neeni oottiyoobai lo77o gidenna. ");
INSERT INTO wal_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Neeninne nenaara de7iya asai daafura xalaalaa daafureeta; ha oosoi neeyyo keehi deexo; neeni hagaa nerkka oottanau danddayakka. ");
INSERT INTO wal_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ane ha77i taani yootiyoogaa siya; taani nena zorana; Xoossai nenaara gido. Neeni ha asaa gishshaa Xoossaa sintti aadhdha; neeni eta yohuwaa Xoossaakko eha. ");
INSERT INTO wal_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Awaajuwaanne higgiyaa eta neeni tamaarissa; eti de7ana maaraanne oottana oosuwaa ubbaa eta bessa. ");
INSERT INTO wal_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Qassi asaa ubbaa giddon danddayiya asata, Xoossaayyo yayyiyaageeta, ammanettidaageetanne mattaayiyaa miyoogaa ixxiyaageeta doora. Doorada etappe asaayyo shaalaqata, mato halaqata, hamssaalaqatanne assiraalaqata oottada suntta. ");
INSERT INTO wal_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Eti ubba wode asaayyo pirddona; shin waayissiya yoho ubbaa neekko ehona; waayissenna yoho ubbaa eti wurssona. Eti nenaara shaakkiyo gishshau, toohoi neeyyo kauyyana. ");
INSERT INTO wal_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Neeni hegaadan oottikkonne hagee Xoossaa shene gidikko, neeni danddayana. Qassi ha asai ubbaikka ba allaallee polettin, ba soo ba soo baana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Muusee ba bolluwaa qaalaa siyiis; i giidobaa ubbaakka oottiis. ");
INSERT INTO wal_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Muusee Israa7eela ubbaa giddoppe danddayiya asata dooriis; dooridi asaa kaalettiya shaalaqata, mato halaqata, hamssaalaqatanne assiraalaqata oottidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Sunttin eti asaayyo ubba wode pirddidosona; eti banttana deexxida yohuwaa Muusekko ehiidosona; shin deexxenna yoho ubbaa eti wurssidosona. ");
INSERT INTO wal_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hegaappe guyyiyan Muusee ba bolluwaa moissiis; moissin Yatiroi ba biitti simmiis. ");
INSERT INTO wal_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israa7eela asai Gibxxeppe kiyido heezzantta aginan koiro gallassan Siinaa bazzuwaa gakkidosona. ");
INSERT INTO wal_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Eti Rafiidimappe denddidi Siinaa bazzuwaa biiddi, bazzon de7iya deriyau sintta baazzan uttidosona. ");
INSERT INTO wal_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Muusee Xoossaakko pude deriyaa huuphiyaa kiyin, GODAI deriyaa huuphiyan a xeesidi, “Neeni Yaaqooba keettaa hagaadan yaaga; Israa7eelau hagaadan yaagada yoota; ");
INSERT INTO wal_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Taani Gibxxetu bolli ai oottidaakkonne qassi argganttaa qefiyan taani inttena waata tookkada taakko ehiidaakkonne intte intte huuphen be7ideta. ");
INSERT INTO wal_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Simmi ha77i intte taayyo kumetta azazettikkonne ta maachchaa naagikko, kawotetta ubbaa giddon intte taayyo buzo gidana. Kumetta sa7ai tabaa gidikkonne ");
INSERT INTO wal_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","intte taayyo qeesetu kawotettanne geeshsha kawotetta gidana’ yaaga; neeni Israa7eelatuyyo yootana qaalai hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Yaagin Muusee guyye simmi biidi, dere cimata xeesi shiishshidi, GODAI yoota giido ha qaalata ubbaa etau yootiis. ");
INSERT INTO wal_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Asai ubbai issi doona gididi, “GODAI giidobaa ubbaa nuuni oottana” yaagidosona. Yaagin Muuseekka eti giidoogaa GODAAKKO ekkidi efiis. ");
INSERT INTO wal_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","GODAI Muusa, “Taani nenaara haasayishin asai siyanaadaaninne eti nenan ubba wodekka ammanettanaadan, taani neekko sikkida shaara giddoora yaana” yaagiis. Hegaappe guyyiyan Muusee asai giidoogaa GODAAYYO yootiis. ");
INSERT INTO wal_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","GODAI Muusa, “Neeni asaakko ba; baada hachchinne wontto neeni eta geeshsha. Eti bantta maayuwaa meeccona; ");
INSERT INTO wal_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","meeccidi heezzantto gallassau giigona. Aissi giikko, heezzantto gallassan asai ubbai be7ishin, GODAI Siinaa Deriyaa bollan wodhdhana. ");
INSERT INTO wal_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Neeni ha deriyaa yuushuwan asaayyo zawaa wottada etayyo, ‘Deriyaa pude kiyennaadan woikko deriyaa xaphuwaa bochchennaadan inttena erite. Deriyaa bochchida ooninne tumuppe haiqqana. ");
INSERT INTO wal_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","He urai shuchchan cadettidi woikko wonddafiyaa zubbiyan dukettidi haiqqana; i kushen boshettenna. Mehe, woikko do7a, woikko asa gidikkonne i paxa attenna’ yaaga. Malkkatai tolidi waassiyo wode, he wode eti deriyaa pude kiyana giikko kiyona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Muusee deriyaappe asaakko duge wodhdhidoogaappe guyyiyan eta geeshshin, eti bantta maayuwaa meeccidosona. ");
INSERT INTO wal_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Hegaappe guyyiyan asaa i, “Heezzantta gallassaayyo giigettite; maccaasaara aqoppite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Heezzantta gallassi maallado dadaa gunttai siyettiis. Wolqqanttainne sikkida shaarai deriyaa maayidi beettiis; malkkataikka punettiyo wolqqaama cenggurssai siyettiis. Hegaa gishshau, ba de7iyoosan asai ubbai kokkoriis. ");
INSERT INTO wal_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Hegaappe guyyiyan Muusee asaa Xoossaara gattanau eti de7iyo dunkkaaniyaappe kessiis; eti deriyau garssa shoobban eqqidosona. ");
INSERT INTO wal_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","GODAI Siinaa Deriyaa bollan tamaara wodhdhido gishshau, Siinaa Dere ubbai cuwan kamettiis. Gita coociyaappe cuwai kiyiyoogaadan, appe cuwai zuliyaa essidi pude kiyiis. Mule deree keehippe gajigajiis. ");
INSERT INTO wal_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Malkkataa punettainne keehippe dari dari biido wode, Muusee haasayin, Xoossaa cenggurssai ayyo zaaridi haasayiis. ");
INSERT INTO wal_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","GODAI Siinaa Deriyaa kiikiyan wodhdhidi, Muusa pude deriyaayyo kiikiyau xeesiis; xeesin Muusee pude kiyiis. ");
INSERT INTO wal_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kiyin GODAI a, “Neeni duge ba; baada asai GODAA be7ana giidi, zawaa kanttennaadaaninne etappe daroi haiqqennaadan asaa seera. ");
INSERT INTO wal_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Harai atto GODAA mati shiiqiya qeesetikka banttana geeshshanau koshshees; hegee xayikko, GODAI eta qaxxayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Muusee GODAA, “Asai deriyaa kiikiyaa pude yaanau danddayenna; aissi giikko, neeni ne huuphen, ‘Ha sohuwaa geeshshadan dummayidi, ha deriyaa yuushuwan zawaa wottite’ gaada nuuyyo oda wottadasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yaagin GODAI a, “Neeni duge ba; baada Aaroona nenaara pude ekkada ya. Qeesetanne asaa GODAI xaissennaadan, eti zawaa kanttidi pude GODAAKKO yooppona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Hegaa gishshau, Muusee duge asaakko wodhdhidi, GODAI giidoogaa etayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Xoossai ha qaalata ubbaa hagaadan yaagidi haasayiis; ");
INSERT INTO wal_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nena Gibxxeppe ailletettaa biittaappe kessida GODAI ne Xoossai tanattennee. ");
INSERT INTO wal_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Taappe attin, hara xoossassi goinnoppa. ");
INSERT INTO wal_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Bolla saluwan de7iyaabaa, woikko garssa sa7an de7iyaabaa, woikko sa7aappe garssan haatta giddon de7iyaabaa aibanne malatissada neeyyo goinniyo misileta kessoppa. ");
INSERT INTO wal_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Etayyo hokkoppa woikko etayyo goinnoppa. Aissi giikko, taani, GODAI ne Xoossai qanaatiya Xoossaa; tana ixxiyaageeta aawatu nagaraa gishshau, naata heezzantto yeletaanne oiddantto yeletaa gakkanaassi qaxxayiyaagaa. ");
INSERT INTO wal_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Qassi tana siiqiyaanne ta azazuwaa naagiya sha7atussi siiquwaa bessiya Xoossaa. ");
INSERT INTO wal_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Xoossaa ne GODAA sunttaa hadan denttoppa; aissi giikko, GODAI ba sunttaa hadan denttiyaagaa qaxxayana. ");
INSERT INTO wal_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Geeshsha oottada, Sambbata gallassaa naaga. ");
INSERT INTO wal_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Neeni oottiyo ooso ubbaa usuppun gallassatun ootta. ");
INSERT INTO wal_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","SHin laappuntta gallassai GODAAYYO, ne Xoossaayyo Sambbata. He gallassi aiba oosonne oottoppa; neeni, woikko ne attuma na7ai, woikko ne macca na7iyaa, woikko ne ashkkarai, woikko ne ashkkariyaa, woikko ne miizzai, woikko ne karen de7iya betee he gallassan aiba oosokka oottoppite. ");
INSERT INTO wal_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Aissi giikko, usuppun gallassaa giddon GODAI salota, sa7aa, abbaanne eta giddon de7iya ubbaa medhdhiis; shin laappuntta gallassan shemppiis. Hegaa gishshau, GODAI Sambbata gallassaa anjjiisinne geeshshiis. ");
INSERT INTO wal_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“GODAI ne Xoossai neeyyo immiyo biittan ne baree aduqqana mala, ne aawaanne ne aayyiyo bonchcha. ");
INSERT INTO wal_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Asa woroppa. ");
INSERT INTO wal_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“SHaaramuxoppa. ");
INSERT INTO wal_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Wuuqqoppa. ");
INSERT INTO wal_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Ne shooruwaa bollan wordduwaa markkattoppa. ");
INSERT INTO wal_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Ne shooruwaa keettaa amottoppa; ne shooruwaa keettaayyiyo, woikko a ashkkaraa, woikko a ashkkariyo, woikko a booraa, woikko a hariyaa, woikko ayyo de7iyaabaa aibanne amottoppa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Asai ubbai dadai xuuqqiyoogaanne wolqqanttai wolqqammiyoogaa be7iis; malkkataa waasuwaa siyiis; qassi deree cuwattiyoogaakka be7iis; be7idi asai yashshaa kokkoriiddi, haahuwan eqqiis. ");
INSERT INTO wal_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Eti Muusa, “Neeni nuuyyo haasaya; nuuni siyana; shin nuuni haiqqennaadan, Xoossai nuuyyo haasayoppo” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Muusee asaa, “Xoossai inttena paaccanau, nagaraa intte oottenna mala, a yashshai intte wozanan de7anaadan, i yiido gishshau yayyoppite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Asai haakkidi eqqidaashin, Xoossai de7iyoosaa sikkida xumaakko Muusee shiiqiis. ");
INSERT INTO wal_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Hegaappe guyyiyan, GODAI Muusa, “Israa7eela asaayyo hagaadan yaagada yoota; ‘Taani saluwaappe intteyyo haasayidoogaa intte intte huuphen be7ideta. ");
INSERT INTO wal_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ta matan ai eeqanne oottoppite; bira eeqa woikko worqqa eeqa intteyyo oottoppite. ");
INSERT INTO wal_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Neeni taayyo yarshshuwaa yarshshiyoosaa urqqaappe medhdha; medhdhada ne xuuggiyo yarshshuwaa, ne atotettaa yarshshuwaa, ne dorssatanne ne boorata a bolli yarshsha. Ta sunttai hassayettana mala, taani oottiyo soho ubban neekko yaada, nena anjjana. ");
INSERT INTO wal_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Neeni taayyo yarshshuwaa yarshshiyoosaa shuchchaappe keexxikko, masettida shuchchaappe keexxoppa; aissi giikko, neeni massiyo miishshan a bochchikko, ne a tunissaasa. ");
INSERT INTO wal_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ta yarshsho sohuwaa pude gayyiyan kiyiyoogaa keena xoqqan gimbboppa; aissi giikko, neeni kiyiyo wode, ne kalloi beettana’ yaagada yoota. ");
INSERT INTO wal_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Neeni etayyo immana higgee hagaa. ");
INSERT INTO wal_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Neeni Ibraawe ailliyaa shammikko, i neeyyo usuppun laittaa ootto; shin laappuntta laitti i ainne qanxxennan, ailletettaappe coo kiyidi bo. ");
INSERT INTO wal_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","I barkka yiidabaa gidikko barkka bo; ba keettaayeera yiidabaa gidikko, a keettaayyiyaakka aara bu. ");
INSERT INTO wal_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","A godai ayyo machcho immidabaa gidikkonne machchiyaa ayyo attuma naata woikko macca naata yelidabaa gidikko, he maccaasiyaanne i naati a godaabaa; i barkka kiyidi bo. ");
INSERT INTO wal_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","SHin he aillee, ‘Taani ta godaa, ta keettaayyiyoonne ta naata siiqais; taani ailletettaappe kiyikke’ yaagikko, ");
INSERT INTO wal_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","a godai a pirddiyaageetu sintti aatto; hegaappe guyyiyan pengge woikko pengge qosilettaakko a efiidi, a haittaa goottan lukko. Simmi i ba de7o laitta ubban ayyo aille gidana. ");
INSERT INTO wal_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Asi ba macca na7iyo ailletettau baizzikko, attuma ailleti ailletettaappe kiyiyoogaadan a kiyuppu. ");
INSERT INTO wal_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","A bana dooridi efiida godaa lo77ana xayikko, godai o wozissanau koshshees. I iyyo ammanettibeenna gishshau, o allagau baizzanau ayyo maati baawa. ");
INSERT INTO wal_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","I o ba na7aayyo immanau doorikko, macca na7assi bessiyaabaa iyyo ootto. ");
INSERT INTO wal_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","I baayyo hara maccaasa ekkikko, koiro maccaaseessi i qumau, i maayuwau woikko i inddau bessiyaabaa iyyo pacissoppo. ");
INSERT INTO wal_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","I ha heezzubata iyyo immana xayikko, ainne miishsha qanxxennan ailletettaappe kiyada bu. ");
INSERT INTO wal_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Asa shocidi woriya asa tumuppe woranau bessees. ");
INSERT INTO wal_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","SHin eriiddi gidennan i woriyo wode, taani, Xoossai co77u giidobaa gidikko, i baqatanasaa intteyyo taani giigissana. ");
INSERT INTO wal_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","SHin asi halchchidi eriiddi hara asa worikko, he aawa ta yarshsho sohuwaappe diggada, hara sohuwan wora. ");
INSERT INTO wal_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ba aawaa woikko ba aayyiyo dechchiya uri ooninne tumuppe haiqqo. ");
INSERT INTO wal_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Asa wolqqan oiqqidi baizziya uri woi wolqqan oiqqido asi a kushiyan beettido asi haiqqanau bessees. ");
INSERT INTO wal_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ba aawaa woikko ba aayyiyo cayiyaagee haiqqo. ");
INSERT INTO wal_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Naa77u asati ooyettikko, issoi hinkkuwaa shuchchan caddikko woikko bubbuxikko, he deshettidaagee haiqqennan attidabaa gidikkonne harggidi hiixan pe7ikko, ");
INSERT INTO wal_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","denddidi guufiyaara kare heeran hemettikko, he dechchidaagee qaxxayettennan attees; gidikkonne i a oosuwaa teqqido gishshau, miishshaa qanxxanaunne a pattanau xallanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Asi ba attuma ailliyaa woikko macca ailliyo gatiman shocikkonne hegaa gaasuwan i a kushiyan haiqqikko, shocidaagee qaxxayettanau bessees. ");
INSERT INTO wal_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","SHin he deshettidaagee issi woikko naa77u gallassaara denddikko, he aillee a miishsha gidiyo gishshau, i qaxxayettenna. ");
INSERT INTO wal_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Naa77u asati issoi issuwaara warettiiddi abbe ixeta maccaasiyo dechchikkonne a boshettikko, hegaappe hara iita deshetti xayikko, he maccaasee azinai oichchidobaanne daannati pirddidobaa aibanne qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","SHin iyyo deshettai darikko, shemppoi haiqqikko shemppo, ");
INSERT INTO wal_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","aife gishshaa aife, achcha gishshaa achcha, kushe gishshaa kushe, toho gishshaa toho, ");
INSERT INTO wal_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","xuussa gishshaa xuussa, masuntta gishshaa masuntta, qoo7o gishshaa qoo7o ekkanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Issi asi ba attuma ailliyaayyo woikko macca ailleeyyo aifiyaa baqqidi toissikko, he aifiyaa gishshau ailletettaappe kessi yeddo. ");
INSERT INTO wal_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hegaadankka, ba ailliyaa achchaa woikko ba aillee achchaa menttikko, he achchaa gishshau ailletettaappe kessi yeddo. ");
INSERT INTO wal_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Boori maccaasa woikko attumaasa qaicidi worikko, he boorai shuchchan cadettidi haiqqo; a ashoi meetettoppo. SHin booraa godai qaxxayettoppo. ");
INSERT INTO wal_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","SHin boorai kasekka qaiciyo meezee de7iyoogaa gidin, asai a godau yooti wottidaashin, a godai qachchennan ixxin, boorai attuma asa woikko macca asa worikko, he boorai shuchchan cadettidi haiqqo; qassi a godaikka haiqqo. ");
INSERT INTO wal_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","SHin i gumiyaa qanxxanaadan oishettikko, eti oichchidobaa aibanne qanxxidi, ba shemppuwaa wozo. ");
INSERT INTO wal_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Boorai attuma na7a woikko macca na7a qaicidi worikkokka, pirddai issi mala gido. ");
INSERT INTO wal_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Boorai attuma ailliyaa woikko macca ailliyo qaicidi worikko, booraa godai ailliyaa godaassi hasttamu xaqara biraa gumiyaa qanxxo. Boorai shuchchan cadettidi haiqqo. ");
INSERT INTO wal_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Issi asi olla qum77uwaa pogirggikko, woikko olla bookkidi qum77ennan aggikko, boori woikko haree he ollan wullikko, ");
INSERT INTO wal_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","he ollaa godai mehiyaa waagaa qanxxo. I a godaassi waagaa qanxxidi, haiqqida mehiyaa bau ekko. ");
INSERT INTO wal_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Issi asa boori haraa booraa qaicidi worikko, paxa booraa baizzidi, a waagaanne haiqqida booraa likkiyan shaakki ekkona. ");
INSERT INTO wal_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","SHin he boorai qaiciyaagaa gidiyoogee kaseti erettishin, a godai a qachchennan aggidabaa gidikko, a godai boora qanxxo. Qanxxidi he haiqqidaagaa bau ekko. ");
INSERT INTO wal_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Issi asi boora woikko dorssa wuuqqidi shukkikko, woikko baizzikko, booraa gishshaa ichchashu boorata, dorssaa gishshaa oiddu dorssata qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Kaisoi keetta bookkiiddi ohettikkonne shocettidi haiqqikko, shocidaagee suuttaa gussidoogau oishettenna. ");
INSERT INTO wal_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","SHin hegee xalqqee doliichchin hanikko, i he gukkida suuttaa acuwan oishettees. Kaisoi ba wuuqqidobaa zaaro; shin ayyo aibakko xayikko, ba wuuqqidobaa zaaranau i baizetto. ");
INSERT INTO wal_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","I wuuqqido mehee paxa de7iiddi a kushen beettikko, boora, woikko hare, woikko dorssa gidikkokka, i ba wuuqqidoogaa naa77u kushe aattidi qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Issi asi ba mehiyaa dembban woikko woiniyaa turaa giddon heemmishin, mehee shunchchidi hara asa shooqaappe miikko, i ba shooqaappe woikko ba woiniyaa turaappe ubbaappe lo77iyaabaa afilaamaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Xaragi denddidi agunttaa buuraara laa7idi, dooriyan de7iya kattaa, woikko equwan de7iya kattaa, woikko goshshaa muleera miyaabaa gidikko, koiro xaragaa oittida bitanee afilaamaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Issi asi biraa woikko hara miishshaa naagissanau ba shooruwaassi hadara immidaashin, shooruwaa sooppe he miishshai wuuqettikkonne kaisoi ohettikko, kaisoi he miishshaayyo naa77u kushe aattidi qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","SHin kaisoi beettennan xayikko, keettaa godai pirddiyaageetukko shiiqo; shiiqidi ba shooruwaa miishshaa bolli ba kushiyaa wottibeennaagau caaqqo. ");
INSERT INTO wal_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Asi ai mootuwankka, boora gaasuwan, woikko hare gaasuwan, woikko dorssa gaasuwan, woikko maayo gaasuwan, woikko hara bayidabaa gaasuwan, ‘Hagee tabaa’ giidi mootettikko, naa77u baggaikka bantta mootuwaa pirddiyaageetu sintti aattona; pirddiyaageeti mooranchcha giido uri ba shooruwaayyo naa77u kushe aattidi qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Asi ba shoorossi hare, woikko boora, woikko dorssa, woikko hara mehe naagissanau hadara immin haiqqikko, woikko deshettikko, woikko ooninne be7ennan ambbaanoi efiikko, ");
INSERT INTO wal_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","hadaraawai ba shooruwaa mehiyaa bolli ba kushiyaa wottibeennaagau GODAA sinttan caaqqin, eta giddon de7iya yohoi mahettees. He mehiyaa godai caaquwaa ekko; qanxxo immanau koshshenna. ");
INSERT INTO wal_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","SHin mehee shooruwaappe wuuqettidabaa gidikko, keettaawaayyo qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","He mehiyaa do7i mentterettidi miidobaa gidikko, markka gidanaadan do7ai miishin attidabaappe ekki eho; yaatidi meqerettida mehiyaa gishshaa qanxxoppo. ");
INSERT INTO wal_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Asi ba shooroppe mehe garxxikkonne a godai bainnasan he mehee deshettikko woikko haiqqikko, he mehiyaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","SHin a godai aara de7ikko, garxxidaagee qanxxoppo; kerau ekkidobaa gidikko, kerau qanxxiyo miishshai acuwaa qanxxiis. ");
INSERT INTO wal_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Issi asi azinau giigabeenna geela7iyo cimmidi, iira zin77iyaabaa gidikko, o cilooshidi baayyo machcho ootto. ");
INSERT INTO wal_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","I aawai o ayyo immanau kebidi ixxikko, geela7iyo ekkiya urai cilooshiyoogaa keena biraa i aawaayyo immo. ");
INSERT INTO wal_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Bitiya mishiriyo paxa wottoppa. ");
INSERT INTO wal_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Meheera zin77iya ooninne haiqqo. ");
INSERT INTO wal_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“GODAA xalaalaayyoppe attin, hara xoossaassi yarshshiya ooninne muleera xayo. ");
INSERT INTO wal_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Betidi yiida asa qohoppite woikko un77oppite; aissi giikko, inttekka Gibxxe biittan bete gididi de7ideta. ");
INSERT INTO wal_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Azinai haiqqido am77iyoonne aawai haiqqido hiyyeesaa un77oppite. ");
INSERT INTO wal_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Intte eta un77in, eti taakko waassikko, ");
INSERT INTO wal_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","taani eta waasuwaa tumuppe siyana; he wode ta hanqqoi intte bolli denddana; taani inttena bisuwan wurssana; intte keettaayeti am77e intte naatikka aawu bainnaageeta gidana. ");
INSERT INTO wal_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Intte giddon de7iya ta asaappe issi hiyyeesau miishsha tal77ikko, miishsha dichchau immiya asadan hanoppite; neeni dichchaa a oichchoppa. ");
INSERT INTO wal_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Neeni issibaa gishshau ne laggiyaa maayuwaa oiqqikko, awai wullennan de7ishin ayyo zaara; ");
INSERT INTO wal_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","aissi giikko, i ba bollaa kammiyoogee hinni xalaalaana; harabaa ai maayidi aqanau danddayii? I taayyo waassikko, taani qarettiyaagaa gidiyo gishshau, siyana. ");
INSERT INTO wal_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Xoossaa bolli cashsha qaalaa haasayoppa, woikko ne deriyaa haariyaagaa qanggoppa. ");
INSERT INTO wal_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ne kattaa xeeraappenne ne woiniyaa gum77ettaa kumettaappe taayyo yarshshuwaa shiishsha. “Neeni ne attuma naatu giddon bairatiya na7aa taayyo immanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Miizzaappekka dorssaappekka hegaadan ootta. Eti laappun gallassai gakkanaashin, bantta aayetuura aayetuura takkona; hosppuntta gallassi eta taayyo imma. ");
INSERT INTO wal_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Intte taayyo geeshsha asa gidanau koshshees; hegaa gishshau, bazzo do7ai mentterettidi worido mehiyaa ashuwaa mooppite; hegaa kanau olite. ");
INSERT INTO wal_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Worddo odo puukkoppa; worddo markka gidada, iita asa maaddoppa. ");
INSERT INTO wal_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Iitabaa oottanau daro asaa kaalloppa; pirddaa geellayanau daro asaara maayada markkattoppa. ");
INSERT INTO wal_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hiyyeesai pirddau shiiqikko, mootuwan a metuwaa xeellada maaddoppa. ");
INSERT INTO wal_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ne morkkiyaa boori woikko haree bayidaagaa demmikko, zaarada ayyo efa. ");
INSERT INTO wal_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nena ixxiya bitaniyaa haree caanaara wullidaashin be7ikko, hegan aggaagoppa; maaddada aara dentta. ");
INSERT INTO wal_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Pirddaa dabaaban maaddada, ne hiyyeesa asaa pirddaa geellayoppa. ");
INSERT INTO wal_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Oonanne malttiyan mootoppa; geeshshaa woikko xilluwaa woroppa; aissi giikko, dabaa oottidaagaa taani saro yeddikke. ");
INSERT INTO wal_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Mattaayiyaa ekkoppa; aissi giikko, mattaayee xeelliyaageetu aifiyaa qooqisseesinne xillotu qaalaa mirqqees. ");
INSERT INTO wal_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Betiyaa naaqqoppite; bete gidiyoogee aiba azzanttiyaabaakko ereeta; aissi giikko, intte intte huuphen bete gididi Gibxxe biittan de7ideta. ");
INSERT INTO wal_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Neeni ne gadiyaa usuppun laittau goyada, zerada kattaa cakka ekka. ");
INSERT INTO wal_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Laappuntta laitti gadiyaa goyennan shaachcha; yaatikko, ne asaa giddon de7iya hiyyeesati hegaappe miyoobaa demmana; qassi etappe attiyaagaa do7ati maana. Neeni ne woiniyaa turaakka ne wogaraakka hegaadan ootta. ");
INSERT INTO wal_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Usuppun gallassaa ne oosuwaa ootta; ne boorainne ne haree shemppana malanne ne son yelettida ailleenne betee, gazddana mala, laappuntta gallassi ooso oottoppa. ");
INSERT INTO wal_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Taani inttena giidobaa ubbaa minttidi oottite; hara xoossatu sunttaa xeesoppite; intte inxxarssaappe hegee siyettoppo. ");
INSERT INTO wal_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Laittan heezzutoo intte taayyo baalaa bonchchite. ");
INSERT INTO wal_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Oittaa Baalaa bonchchite; taani inttena azazidoogaadan, laappun gallassaa irshshuwaa yeggibeenna oittaa miite; intte Abiiba giyo aginan keerido gallassan ha baalaa bonchchite; aissi giikko, intte Gibxxeppe kiyidoi he aginaana. “Intteppe issi asinne ta sinttan mela kushe beettoppo. ");
INSERT INTO wal_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Qassi intte intte gaden zerin, koiro gakkida kattaa cakkiyo wode, Kattaa Cakkiyo Baalaa bonchchite. “Qassikka laittaa wurssettan, kattaa aifiyaa gadeppe shiishshiyo wode, SHiishuwaa Baalaa bonchchite. ");
INSERT INTO wal_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Attumaasai ubbai Ubbaa Haariya GODAA sinttan laittan heezzutoo beetto. ");
INSERT INTO wal_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Neeni yarshshuwaa suuttaa taayyo shiishshaidda, irshshuwaa yeggidi uukkido oittaara shiishshoppa. Ta baalaa bonchchiyo gallassi yarshshettida modhdhuwaappe maalladossi aibinne attoppo. ");
INSERT INTO wal_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ne gaden baira kaxxida kattaappe ubbaappe lo77iyaagaa GODAA soo, ne Xoossaa soo eha. Deeshsha maraa a aayee maattan doissoppa. ");
INSERT INTO wal_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Ne ogiyan nena naagana malanne taani neeyyo giigissido sohuwaa nena efaana mala, taani kiitanchchaa ne sinttau kiittana. ");
INSERT INTO wal_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","I yootiyoobaa ezggada ayyo azazetta; a bolli makkaloppa; ta sunttai a bolli de7iyo gishshau, intte nagara oottiyaabaa gidikko, intteyyo i atto geenna. ");
INSERT INTO wal_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","I yootiyoobaa intte minttidi ezggikkonne taani yootiyoobaa ubbaa oottikko, intte morkketa ubbaa taani morkkana; inttenaara eqettiyaageetuura taanikka eqettana. ");
INSERT INTO wal_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ta kiitanchchai intteppe sinttau biidi, inttena Amooretu biittaa, Hiitetu biittaa, Parzzetu biittaa, Kanaanetu biittaa, Hiiwetu biittaanne Yaabuusatu biittaa ehaana. Taani eta muleera xaissana. ");
INSERT INTO wal_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Eta xoossatu sinttan hokkoppite, woikko goinnoppite, woikko eta hanuwaa qulloppite. Intte eta xaissanaunne eta eeqa shuchchata mentterettanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","GODAASSI, intte Xoossaassi, goinnite; yaatikko, i intte kattaanne intte haattaa anjjana; taani harggiyaa intte giddoppe diggana. ");
INSERT INTO wal_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Intte biittan ai maccaasinne boshettenna; mainenna. Taani intte de7ana laittaa qoodaa kunttana. ");
INSERT INTO wal_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Taani ta yashshaa intte sinttau yeddana; inttenaara gaittiya kawotetta ubbaa daganttana; intte morkketi ubbai intteyyo zokkuwaa zaaridi, baqatanaadan taani oottana. ");
INSERT INTO wal_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Taani intteppe sinttau kashiyaa yeddana; yeddada Hiiweta, Kanaanetanne Hiiteta intte sinttaappe laaggada kessana. ");
INSERT INTO wal_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","SHin biittai mela attennaadaaninne bazzo do7ai inttena waissennaadan, issi laittan eta gooddikke. ");
INSERT INTO wal_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","SHin intte qoodan daridi, he biittaa laattana gakkanaassi, taani eta guuttaa guuttaa laaggada kessana. ");
INSERT INTO wal_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Taani intte zawaa Zo7o Abbaappe Pilisxxeema Abbaa, bazzuwaappe Efiraaxiisa SHaafaa gattana. He biittan de7iya ubbaa taani intte kushiyan aattada immana; inttekka eta intte sinttappe laaggidi kessana. ");
INSERT INTO wal_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Etaara woikko eta xoossatuura maachcha wottoppite. ");
INSERT INTO wal_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Eta intte biittan wottoppite; hinkkoode eti inttena ta bolli nagaraa ootissana; aissi giikko, eta xoossatussi goinniyoogee tumuppe intteyyo pire gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Hegaappe guyyiyan GODAI Muusa, “Neeni, Aarooni, Nadaabi Abiihunne Israa7eelappe laappun tammu asaa halaqati GODAAKKO deriyaa huuphiyaa pude kiyite; kiyidi haahuwan goinnite. ");
INSERT INTO wal_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","SHin Muusee, neeni nerkka taakko shiiqa; harati ta mati yooppona. Qassi asaikka nenaara pude kiyoppo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Yaagin Muusee yiidi, GODAA qaala ubbaanne a wogaa ubbaa asaayyo yootiis; yootin asai ubbai issi qaalan, “GODAI yootidobaa ubbaa nuuni oottana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Muusee GODAI yootidobaa ubbaa xaafiis. Wonttetta gallassi maallado guuran denddidi, deriyaa xaphuwan yarshshiyoosaa gimbbiis. Gimbbidi Israa7eela asaa yaraa tammanne naa77aa sunttan, tammanne naa77u shuchchaa tuussaa essiis. ");
INSERT INTO wal_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","I Israa7eelatuppe yelaga attumaasaa kiittin, eti biidi xuuggiyo yarshshuwaa shiishshidosona; qassi issippetettaa yarshshuwaassi mirggota GODAASSI yarshshidosona. ");
INSERT INTO wal_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Muusee suuttaappe baggaa ekkidi keriyan tigiis; attida bagga suuttaa i yarshshiyoosan caccafiis. ");
INSERT INTO wal_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Hegaappe guyyiyan Maachchaa Maxaafaa ekkidi, asaassi nabbabiis; nabbabin eti, “GODAI yootidobaa ubbaa nuuni oottana; nuuni azazettana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Hegaappe guyyiyan, Muusee he suuttaa ekkidi, asaa bolli caccafidi eta, “Be7ite, GODAI ha qaala ubban inttenaara wottido maachchaa suuttai hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Muusee, Aarooni, Nadaabi, Abiihunne Israa7eela cimatuppe laappun tammai pude kiyidosona. ");
INSERT INTO wal_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Kiyidi Israa7eela Xoossaa be7idosona; a tohuwaappe garssaara saluwaadan geeyida sampperiyaa giyo phooliya shuchchaappe oosettidabaa milatiya wuige malabai de7ees. ");
INSERT INTO wal_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","SHin Xoossai Israa7eela asaa halaqata woribeenna. Eti Xoossaa be7idosona; a sinttan miidosonanne uyidosona. ");
INSERT INTO wal_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","GODAI Muusa, “Neeni taakko deriyaa pude haaya; haa taakko kiyada, hagan takka; yaatobare neeni eta tamaarissana mala, taani higgiyaanne azazuwaa xaafido masettida shuchchaa neeyyo immana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Hegaappe guyyiyan, Muusee ba ashkkaraa Yaasuura baanau denddiis; Muusee Xoossaa deriyaa pude kiyiis. ");
INSERT INTO wal_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Israa7eela asaa halaqata i, “Nuuni inttekko simmanaashin hagan de7ishshite; Aarooninne Huuri hagan inttenaara de7oosona; yohoi de7iyo ooninne etakko bo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Muusee deriyaa pude kiyido wode, shaarai deriyaa kammiis. ");
INSERT INTO wal_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Qassi GODAA bonchchoi Siinaa Deriyaa bollan uttiis; he shaarai usuppun gallassaa maayiis; laappuntta gallassan he shaaraa giddoppe GODAI Muusa xeesiis. ");
INSERT INTO wal_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Israa7eelatuyyo GODAA bonchchoi deriyaa huuphiyan xuuggiya tama malatidi beettiis. ");
INSERT INTO wal_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Hegaappe guyyiyan Muusee he shaaraa giddo gelidi, deriyaa pude kiyiis; kiyidi deriyaa huuphiyan oitamu gallassaanne oitamu qammaa takkiis. ");
INSERT INTO wal_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","GODAI Muuseyyo hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Taayyo immiyoobaa ehaanaadan neeni Israa7eelatuyyo yoota; taayyo immanau a wozanai a imma imma giyo asa ubbaa imotaa neeni taayyo ekka. ");
INSERT INTO wal_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Intte etappe ekkana imotai hagaa: worqqaa, biraa, nahaasiyaa birataa, ");
INSERT INTO wal_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","salo milatiya qacinaa, ochchaa teeraa milatiya qacinaa, shololla zo7o qacinaanne liiqo liinuwaa, deeshshaa agoziyaa, ");
INSERT INTO wal_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","dorssa orggiyaa calaa zo7o qalamiyan yeggi kessidoogaa, irppaniyaa, guuganttaa, ");
INSERT INTO wal_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","xomppiyaassi wogaraa zaitiyaa, tiyettiyo zaitiyaanne ixaanaa sawettiya qimamiyaa; ");
INSERT INTO wal_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","eefuudiyaaninne tiran wottiyoogan yeggiyo maragidiyaa geetettiya shuchchatanne hara phooliya al77o shuchchata eho. ");
INSERT INTO wal_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Yaatidi taani eta giddon aqanaadan, eti taayyo goinniyo sohuwaa giigissona. ");
INSERT INTO wal_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Likke taani nena bessana leemisuwaadan Xoossaa Dunkkaaniyaanne a giddon de7iya miishshata oottite. ");
INSERT INTO wal_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Eti guuganttaa mittaappe zananai naa77u waranne baggaa, gomppai issi waranne baggaa, geesai qassi issi waranne baggaa gidiya Taabootaa medhdhona. ");
INSERT INTO wal_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Suwaanne kariyaa walahi bainna worqqan sheeshsha; a yuushuwaakka worqqa tigettan yuushsha aatta. ");
INSERT INTO wal_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","He Taabootaayyo oiddu worqqa sagaayota tiga; tigada oiddu gedetun issi baggaara naa77u sagaayota, qassi hankko baggaara naa77u sagaayota aatta. ");
INSERT INTO wal_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Hegaappe guyyiyan, guuganttaappe kasota kessa; kessada worqqan sheeshsha. ");
INSERT INTO wal_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Taabootaa tookkanau, Taabootaa miyyiyan de7iya sagaayotun kasota aatta. ");
INSERT INTO wal_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tookkiyo kasoti Taabootaa sagaayotu giddon de7ona; eti hegaappe mulekka kiyoppona. ");
INSERT INTO wal_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Taabootaa giddon taani neeyyo immiyo, tammu azazoti xaafetti uttido naa77u masettida shuchchata wotta. ");
INSERT INTO wal_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Walahi bainna worqqaappe naa77u waranne baggaa aduqqiya, issi waranne baggaa aakkiya atto giyo sohuwaa qum77uwaa medhdha. ");
INSERT INTO wal_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Qum77uwaayyo wurssetta naa77u bagga gaxan naa77u kiruubeta, qoxettida worqqaappe medhdha. ");
INSERT INTO wal_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Issi kiruubiyaa issi bagga gaxan, naa77antto kiruubiyaa hankko bagga gaxan naa77aakka qum77uwaara gatta oittada medhdha. ");
INSERT INTO wal_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kiruubeti bantta qefiyaa denttidi, atto giyo sohuwaa qum77uwaa bantta qefiyan kuwayi wottona; qassi issoi issuwaakko simmi uttidi, qum77uwaa xeellona. ");
INSERT INTO wal_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Qum77uwaa Taabootaayyo bolla baggan wotta; qassi taani neeyyo immiyo azazoti xaafettido masettida shuchchata Taabootaa giddon wotta. ");
INSERT INTO wal_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Maachchaa Taabootaa bolla qum77uwaa bolli de7iya naa77u kiruubetuppe gidduwan taani nenaara gaittana; gaittada Israa7eela asaayyo taani immiyo azazo ubbaa yan neeyyo immana. ");
INSERT INTO wal_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Guuganttaa mittaappe zananai naa77u wara, gomppai issi wara, geesai qassi issi waranne bagga gidiyo issi xaraphpheezaa medhdha. ");
INSERT INTO wal_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Yaatada walahi bainna worqqan sheeshsha; qassi a yuushuwan worqqaa tigettaa yuushsha aatta. ");
INSERT INTO wal_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hegaadankka, qassi gomppai takkaaro gidiyo shaashiyaa a bolli yuushsha aatta. Yaatada a bolli worqqa tigettaa yuushsha. ");
INSERT INTO wal_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","He xaraphpheezaayyo oiddu worqqa sagaayota medhdhada, xaraphpheezaa tohoti de7iyo oiddu zoozetun oitta. ");
INSERT INTO wal_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Xaraphpheezaa tookkanau kasota aattiyo sagaayoti xaraphpheezau shaashiyaa lanqqiyan shiiqidi de7ona. ");
INSERT INTO wal_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","He tookkiyo kasota guuganttaappe kessada, worqqan eta sheeshsha. ");
INSERT INTO wal_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Hegaadankka, qassi sainetanne cilppata, yarshshuwaa yarshshiyo wode go7ettiyo duuqqiyoobatanne xuu7ata walahi bainna worqqaappe ootta. ");
INSERT INTO wal_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ta sintti aattiyo geeshsha oittai ubba wodekka xaraphpheezaa bolli xayoppo. ");
INSERT INTO wal_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Xomppiyaa wottiyo ballaa qoxettida walahi bainna worqqaappe ootta; he ballai eqqiyo gedeekka, qassi giddo toomaikka ubbai qoxettida worqqaappe oosettanau koshshees. A qururuusoti, a kukkumotinne a ciishshati ubbai aara issippe oiqetti merettanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Miyyiyaara usuppun marati ayyo kiyona; maratuppe heezzati issi baggaara, qassi heezzati hankko baggaara de7ona. ");
INSERT INTO wal_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Usuppun maratussikka huuphiyan huuphiyan issi issi kukkumoinne ciishshai de7iyo lauziyaa ciishshaa milatiya wanccai de7o. ");
INSERT INTO wal_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Xomppiyaa wottiyo ballaassi giddo toomai, kukkumotinne ciishshati de7iyo lauziyaa ciishshaa milatiya oiddu wanccan alleeqetto. ");
INSERT INTO wal_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Naa77ai naa77ai issippe waattan de7iyo heezzu maratuppe garssaara issi issi kukkumoi de7o. ");
INSERT INTO wal_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Kukkumotinne marati ubbai xomppiyaa wottiyo ballaara issippe, oiqetti issuwaa gididi, walahi bainna worqqaappe qoxettidi oosettona. ");
INSERT INTO wal_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Hegaappe guyyiyan, xomppiyaa wottiyo ballau laappun xomppeta giigissada, eti sinttaa poo7ana mala xoqqu oottada wotta. ");
INSERT INTO wal_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Xomppiyaa toissiyo qaphetanne eta wottiyoobata walahi bainna worqqaappe ootta. ");
INSERT INTO wal_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Xomppiyaa wottiyo ballainne an go7ettiyo miishsha ubbai hasttamanne ichchashu kilo giraame gidiya walahi bainna worqqaappe oosettona. ");
INSERT INTO wal_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Akeeka; taani nena deriyaa huuphiyan bessido leemisuwaa kaallada ootta. ");
INSERT INTO wal_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Qassi liiqo liinuwaappenne salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappe dadettida tammu magalashotuppe Xoossaa Dunkkaaniyaa giigissa. He magalashotu bolli bollaara issi hiillan kiruubetu misiliyaa sikissa. ");
INSERT INTO wal_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Magalashoti ubbai issi likke gidona; geesai laatamanne hosppun wara; gomppai oiddu wara gido. ");
INSERT INTO wal_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ichchashu magalashota issippe gattada sikka; hankko attida ichchashu magalashotakka etadan ootta. ");
INSERT INTO wal_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Issippe gaittidi sikettida magalashotuppe issi magalashuwaassi wurssetta gaxan salo milatiya carqqiyaappe siireta medhdha; qassi issippe gaitetti sikettida hankko magalashuwankka hegaadan ootta. ");
INSERT INTO wal_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Issippe gaittida issi magalashuwaa bolli ishatamu siireta, qassi issippe gaittida hankko magalashuwaa bollikka ishatamu siireta medhdha; he siireti ubbaikka issoi issuwaassi baazzan de7ona. ");
INSERT INTO wal_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Hegaappe guyyiyan, worqqaappe ishatamu qapheta medhdha; medhdhada Xoossaa Dunkkaanee issuwaa gidana mala, he magalashotu gaxaa gaxaa he qaphetun oitta. ");
INSERT INTO wal_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Xoossaa Dunkkaaniyaa bollaara kammana mala, tammanne isiini magalashota deeshshaa agoziyaappe daddada, issi dunkkaaniyaa medhdha. ");
INSERT INTO wal_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tammanne isiini magalashotikka issi likke gidona; issi issi magalashuwaa geesai hasttamu wara, gomppai oiddu wara gido. ");
INSERT INTO wal_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ichchashu magalashota issi baggaara, usuppun magalashota qassi hankko baggaara gattada sikka. Usuppuntta magalashoi dakkotidi, dunkkaaniyaassi sintta baggaara daabuletto. ");
INSERT INTO wal_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Gatti sikkido magalashotuppe issi magalashuwaa gaxan ishatamu siireta medhdha; qassi gatti sikkido hankko magalashotuppe wurssetta magalashuwaa gaxan ishatamu siireta medhdha. ");
INSERT INTO wal_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ishatamu nahaasiyaa qapheta medhdhada, siiretu giddo gelissa; yaatada dunkkaaniyaa issippe gatta oitta. Yaatobare ha naa77u oiqettida kamoti issuwaa gidana. ");
INSERT INTO wal_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ha dunkkaaniyaa magalashotuppe palahida bagga magalashoi Xoossaa Dunkkaaniyaassi guyyessaara woxaletto. ");
INSERT INTO wal_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Dunkkaaniyaa magalashoti naa77u baggaarakka issi issi wara keenaa palahona; he palahidaageeti Xoossaa Dunkkaaniyaa kammana mala, naa77u bagga miyyiyaara woxalettona. ");
INSERT INTO wal_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Dunkkaaniyaa bollaara kammanau dorssa orggiyaa calaa zo7o qalamiyan yeggi kessidoogaa giigissa; qassi a bollaara kammanau irppaniyaa giigissa. ");
INSERT INTO wal_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Xoossaa Dunkkaaniyaa xagaagiyoobata sitti giida guuganttaappe kessa. ");
INSERT INTO wal_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Issi issi xagaagiyau geesai tammu wara, gomppai issi waranne bagga gido. ");
INSERT INTO wal_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Issi issi xagaagiyaassi issuwaa issuwaara gatti oittiya naa77u marata medhdha. Xoossaa Dunkkaaniyaa xagaageta ubbaakka hegaadan ootta; ");
INSERT INTO wal_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Xoossaa Dunkkaaniyaayyo tohossa baggaara laatamu xagaageta medhdha. ");
INSERT INTO wal_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Medhdhada issi issi xagaagiyaayyo naa77u gedeta, muleera oitamu gedeta biraappe giigissa. ");
INSERT INTO wal_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Xoossaa Dunkkaaniyaayyo huuphessa baggaara, laatamu xagaageta medhdha. ");
INSERT INTO wal_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Medhdhada issi issi xagaagiyau naa77u gedeti, muleera oitamu gedeti, biraappe giigona. ");
INSERT INTO wal_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Qassi Xoossaa Dunkkaaniyaayyo guyye gaxan arggo baggaara usuppun xagaageta medhdha. ");
INSERT INTO wal_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Medhdhada guyye gaxan de7iya zoozetuyyo naa77u xagaageta giigissa. ");
INSERT INTO wal_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ha naa77u zoozetun de7iya xagaageti, xaphuwaappe xeeraa gakkanaashin daabula gididi biidi, xeeran issi migiduwan geli oiqettona; yaatidi naa77ai issuwaa gidona. ");
INSERT INTO wal_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Hegaa gishshau, issi issi xagaagiyaayyo garssaara naa77u naa77u gedeti de7ona; muleera hosppun xagaagetinne biraappe oosettida tammanne usuppun gedeti de7ona. ");
INSERT INTO wal_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Qassi guuganttaappe hiraqota kessa. Xoossaa Dunkkaaniyaayyo issi bagga miyyiyan de7iya xagaagetussi ichchashu hiraqota, ");
INSERT INTO wal_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","qassi hankko bagga miyyiyan de7iya xagaagetussi ichchashu hiraqota giigissa. Hegaadankka, Xoossaa Dunkkaaniyaayyo guyye arggo baggaara wurssetta gaxan de7iya xagaagetuyyo ichchashu hiraqota medhdha. ");
INSERT INTO wal_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Giddo hiraqoi xagaagetussi giddo ginaara ha gaxaappe ya gaxaa gakkanaashin kantti kiyanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Xagaageta worqqan sheeshshada, hiraqoti aadhdhiyo sagaayota worqqaappe medhdha; qassi hiraqotakka worqqan sheeshsha. ");
INSERT INTO wal_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Xoossaa Dunkkaaniyaa taani nena deriyaa bollan bessido leemisuwaadan oottada tokka. ");
INSERT INTO wal_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Salo milatiya, ochchaa teera milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe issi magalashuwaa ootta; he magalashuwaa bolli issi hiillan kiruubetu misiliyaa sikissa. ");
INSERT INTO wal_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Yaatada worqqan sheeshshido oiddu, mino guuganttaa tuussatun de7iya worqqaappe oosettida kaqqiyoogan kaqqa. He oiddu tuussati biraappe medhdhido tohotun gelona. ");
INSERT INTO wal_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","He magalashuwaa Xoossaa Dunkkaaniyaa kaaran de7iya qaphetuppe garssaara kaqqada, Maachchaa Taabootaa magalashuwaappe guyye baggan wotta; yaatobare he magalashoi Geeshsha Sohuwaa Ubbaappe Aadhdhida Geeshsha Sohuwaappe shaakkana. ");
INSERT INTO wal_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Atto giyo sohuwaa qum77uwaa Ubbaappe Aadhdhida Geeshsha Sohuwan de7iya Maachchaa Taabootaa bolli wotta. ");
INSERT INTO wal_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Xaraphpheezaa magalashuwaappe kareera, Xoossaa Dunkkaaniyaappe huuphessa baggan wotta; xomppiyaa wottiyo ballaa qassi a ginan tohossa baggaara wotta. ");
INSERT INTO wal_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Dunkkaaniyaa geliyo penggiyaassi salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe xilppiyan alleeqissiyaagan oosettida magalashuwaa medhdha. ");
INSERT INTO wal_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Magalashuwaayyo ichchashu tuussata guuganttaappe kessada, worqqan sheeshsha; kaqqiyoogeetikka worqqaappe oosettidaageeta gidona; tuussatuyyo nahaasiyaa birataappe tigada ichchashu gedeta medhdha. ");
INSERT INTO wal_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Guuganttaappe yarshshiyoosaa keexxa. He yarshshiyoosaayyo geesai heezzu wara gido; gomppainne zananai issi likke, ichchashu ichchashu wara gididi, oiddu zooziyaara de7o. ");
INSERT INTO wal_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Oiddu zoozetu wurssetta gaxan gaxan issi issi kaciyaa medhdha; kaceti yarshshiyoosaara issippe oiqettidi oosettona. Yaatada yarshshiyoosaa nahaasiyaa biratan sheeshsha. ");
INSERT INTO wal_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","An go7ettiyo miishshata, bidinttaa kessiyo balddeta, akaafata, araciyo kuixaarota, ashuwaa qaphiyo qaphetanne tamaa cooceta ubbaa nahaasiyaa birataappe medhdha. ");
INSERT INTO wal_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Yaatada nahaasiyaa birataappe zazzare malabaa medhdha; qassi a oiddu zooziyan oiddu sagaayota medhdha. ");
INSERT INTO wal_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Yaatada yarshshiyoosaayyo duge giddo ginan de7iya dacaa bolli wotta. ");
INSERT INTO wal_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Guuganttaappe yarshshiyoosaayyo kasota kessada, nahaasiyaa biratan sheeshsha. ");
INSERT INTO wal_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yarshshiyoosaa tookkiyo wode maaddana mala, he kasota naa77u miyyiyaara de7iya sagaayotun aatta. ");
INSERT INTO wal_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Taani nena deriyaa bollan bessidoogaadan, yarshshiyoosaa xaulaappe medhdhidi, gomppaa kofa kessona. ");
INSERT INTO wal_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Xoossaa Dunkkaaniyaayyo asai shiiqiyo dabaabaa giigissa. Dabaabaayyo tohossa bagga zananai xeetu wara aduqqo; he dabaabaayyo liiqo liinuwaappe dadettida magalashota giigissa. ");
INSERT INTO wal_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ayyo nahaasiyaa birataappe laatamu tuussatanne tuussati eqqiyo laatamu gedeta ootta; eta huuphiyan qassi biraappe kaqqiyoogeetanne tuussata huuphiyan qachchiyoogeeta ootta. ");
INSERT INTO wal_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hegaadankka, dabaabaayyo huuphessa bagga zananai xeetu waraa aduqqo; qassi laatamu tuussatuuranne he tuussatuyyo laatamu nahaasiyaa gedetuura de7iya magalashoi de7o. Yaatidi biraappe oosettida kaqqiyoogeetinne tuussatu huuphiyan qachchiyoogeeti Xoossaa Dunkkaaniyaayyo de7ona. ");
INSERT INTO wal_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Dabaabaayyo arggo bagga gomppai ishatamu waraa aakko; tammu tuussatinne, tuussatuyyo tammu gedeti de7iyo magalashoti ayyo de7ona. ");
INSERT INTO wal_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Qassi arshsho bagga dabaabaa gomppaikka ishatamu wara gido. ");
INSERT INTO wal_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Dabaabaa geliyoosaappe issi baggaara tammanne ichchashu wara aduqqiya magalashoti de7ona; etayyo heezzu tuussatinne heezzu gedeti de7ona. ");
INSERT INTO wal_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Hegaadankka, hinkko baggaara magalashoti tammanne ichchashu wara aduqqiya magalashoti de7ona; etayyo heezzu tuussatinne tuussatuyyo heezzu gedeti de7ona. ");
INSERT INTO wal_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Dabaabaa geliyoosaayyo laatamu wara aduqqiya magalashuwaa giigissa; hegeekka salo milatiya, ochchaa teeraa milatiyaanne, shololla zo7o qacinaappenne liiqo liinuwaappe dadettidaagaa, xilppiyan alleeqissiyaagan giigissa. Eti an zemppiyo oiddu tuussatanne tuussatuyyo oiddu gedeta giigissa. ");
INSERT INTO wal_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Dabaabaa yuushuwan de7iya tuussatussi ubbaassi biraappe oosettida qachchiyoogeetinne kaqqiyoogeeti, nahaasiyaappe oosettida gedeti de7ona. ");
INSERT INTO wal_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Dabaabai zananaa laatamu wara, gomppaa laatamu wara gido; pudiyaa ichchashu wara xoqqiya liiquwan dadettida liinuwaappe oosettida magalashoti de7ona; yaatidi nahaasiyaappe oosettida gedeti gidona. ");
INSERT INTO wal_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“Xoossaa Dunkkaaniyan oottiyo oosuwaassi go7ettiyo miishsha ubbai, eta go77ai aiba gidikkokka, Xoossaa Dunkkaaniyaa xishetu ubbaaranne dabaabaa xishetu ubbaarakka gujjin, nahaasiyaa birataappe oosettona. ");
INSERT INTO wal_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Xomppee to7ennan eexxiiddi de7ana mala, assi koshshiya zaitiyaa wogaraa teeraa caddidi gum77in kiyidaagaa neeyyo ehaana mala, Israa7eelata azaza. ");
INSERT INTO wal_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aarooninne a naati, xomppee GODAA sinttan qammida sa7ai wonttana gakkanaashin poo7ana mala, Xoossaa Dunkkaaniyaa giddon, Markkaa Taabootaa sinttan de7iya magalashuwaappe kareera eettona. Hagee Israa7eela asaayyo merinau wotto woga gididi de7o. ");
INSERT INTO wal_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ne ishaa Aaroonanne a naata Nadaaba, Abiiha, El77aazaranne Itaamaara neekko ehiissa; eti qeese gididi taayyo oottana mala, Israa7eela asaa giddoppe eta dummaya. ");
INSERT INTO wal_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ayyo bonchchuwaanne puulaa immana mala, ne ishaa Aaroonayyo qeesetettaa maayota giigissa. ");
INSERT INTO wal_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Taani aadhdhida eratettaa immido kushiyaa hiillaa eriya asa ubbaa xeesada, Aaroonayyo maayota giigissana mala yoota; i qeese gididi, taayyo oottanau dummatana. ");
INSERT INTO wal_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Eti giigissana maayotikka hageeta: tiran wottiyoogaa, eefuudiyaa, adussa maayuwaa, alleeqettidi dadettida qoliyaa, shaashiyaanne danccuwaa. Ne ishai Aarooninne a naati qeese gididi taayyo oottiiddi geeshsha maayota maayana mala, sikkiyaageeti giigissoosona. ");
INSERT INTO wal_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kushiyaa hiillaa eriyaageetikka ha maayota giigissanau, worqqa qacinaa, salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaanne liiqo liinuwaa go7ettona. ");
INSERT INTO wal_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Eefuudiyaa giyo maayuwaa worqqa qacinaappe, salo milatiya qacinaappe, ochchaa teeraa milatiya qacinaappe, shololla zo7o qacinaappenne liiqo liinuwaa qacinaappe kushe hiillanchchati alleeqissidi giigissona. ");
INSERT INTO wal_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Naa77u baggai gaittidi issuwaa gidana mala, naa77u hashiyaa bolli gattidi oittiya carqqee de7o. ");
INSERT INTO wal_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Hiillai alleeqissidi daddido danccoikka eefuudiyaa mala gididi, worqqaappe, salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqissi baqqido liinuwaappe oosetto. ");
INSERT INTO wal_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Maragidiyaa giyo naa77u shuchchata ekkada, Yaaqooba naatu sunttaa eta bolli woocada xaafa. ");
INSERT INTO wal_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Eta yeletaa maaraadan issi shuchchaa bolli usuppun sunttaa, hinkko shuchchaa bolli qassi attida usuppunatu sunttaa woocada xaafa. ");
INSERT INTO wal_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Maatafaa bolli sunttaa woocidi xaafiyoogaadan, he naa77u shuchchatu bolli Yaaqooba naatu sunttaa woocada xaafa; xaafada he shuchchata worqqaappe medhdhido shuchchaa oiqqiyaagaa bolli wotta. ");
INSERT INTO wal_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Yaatada tammanne naa77u Israa7eela zareta hassayiyoobaa gidana mala, ha naa77u shuchchata eefuudiyaara oittido hashiyaa carqqiyan wotta; yaatobare GODAA sinttan ubbatoo hassayettana mala, ha sunttata Aarooni ba hashiyan tookko. ");
INSERT INTO wal_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","He shuchchata oiqqiyaagaa worqqaappe medhdha. ");
INSERT INTO wal_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Qassi walahi bainna worqqaappe wodoruwaadan dooqqido qooriyan wottiyo naa77u sanssalatata giigissada, he naa77u shuchchaa oiqqiyaageetuura gatta oitta. ");
INSERT INTO wal_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“GODAA shenee aibakko oichchidi eriyo tiran wottiyoogaa kushe hiillanchchan ootissa. He tiran wottiyoogaa eefuudiyaa daddidoogaadan, worqqaappe, salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe dadda. ");
INSERT INTO wal_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ayyo oiddu zoozee de7ees; geesainne gomppai issi issi takkaaro gididi dakkoto. ");
INSERT INTO wal_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Hegaappe guyyiyan, a bolli oiddu maaran al77o shuchchata wotta; koiro maaran wottido shuchchai, sarddiyooniyaa, tophaaziyooniyaanne phooliya inqquwaa. ");
INSERT INTO wal_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Naa77antto maaran baluura, sampperiyaanne almmaaziyaa giyo al77o shuchchata; ");
INSERT INTO wal_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","heezzantto maaran yaakinttiyaa, kelqqedooniyaanne ametesxxinoosiyaa; ");
INSERT INTO wal_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","oiddantto maaran biralle, maragidiyaa, yasphphiidiyaa. Hageeti ubbai worqqaappe oosettida shuchchaa oiqqiyaagaa bolli uttona. ");
INSERT INTO wal_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Israa7eela naatu sunttaa qoodaadan, shuchchatu qoodaikka tammanne naa77a gidona; issoi issoi maatafadan woocettidi, tammanne naa77u zaretu sunttai he shuchchatun xaafetto. ");
INSERT INTO wal_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Tiran wottiyoogaayyo wodorodan dooqettida sanssalataa walahi bainna worqqaappe medhdha. ");
INSERT INTO wal_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Naa77u worqqa migidota medhdhada, tiran wottiyoogaayyo qommo gaxa zoozetuura gattada oitta wotta. ");
INSERT INTO wal_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","He naa77u worqqa sanssalatata tiran wottiyoogaayyo zoozetun de7iya migidotuura gattada oitta. ");
INSERT INTO wal_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","He sanssalatatuyyo hankko bagga xeeraa qassi eefuudiyaayyo sintta baggaara, hashiyaa carqqiyan de7iya shuchchaa oiqqiyaageetuura gatta qachcha. ");
INSERT INTO wal_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Qassikka naa77u worqqa migidota medhdhada, eefuudiyaappe kaallidi de7iya tiran wottiyoogaayyo soo baggaara de7iya naa77u zoozetu xeeran aatta. ");
INSERT INTO wal_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hegaadankka, worqqaappe hara naa77u migidota medhdhada; eefuudiyaayyo sintta baggaara, hashiyaa carqqiyaappe garssa baggaara, eefuudiyaa xeessan qachchiyoogaappe qommoora, sihoi gaittosaa matan eta oitta. ");
INSERT INTO wal_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tiran wottiyoogan de7iya migidota eefuudiyan de7iya migidotuura gattidi, salo milatiya baqettan qachcha; yaatikko, tiran wottiyoogee xeessaappe qommoora de7iyo gishshau, qashoi dol77enna. ");
INSERT INTO wal_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Aarooni Geeshsha Sohuwaa geliyo wode, ha tiran wottiyoogan de7iya Israa7eela zaretu sunttata tookko. Yaatobare taani GODAI ubbatoo ta asaa hassayana. ");
INSERT INTO wal_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Qassi Uriimiyaanne Tumiima giyoobata tiran wottiyoogan yegga. Aarooni GODAA sintti aadhdhiiddi, ba tiran wotti ekkidi gelo. Ta shenee aibakko Israa7eela asaa erissana mala, i ta sinttan oottanau geliyo wode ubban tiraa kiisiyaappe xaissenna. ");
INSERT INTO wal_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Eefuudiyaappe bollaara maayiyo adussa maayuwaa muleera salo milatiya carqqiyaappe giigissa. ");
INSERT INTO wal_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","He adussa maayuwaayyo qooriyaa aattiyoosaa medhdha. He sohoi peerettennaadan, soo qalam77ada, yuushsha aattada sikka. ");
INSERT INTO wal_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Adussa maayuwaa duge bagga macaraa yuushuwan salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappe, roomaaniyaa teeraa misileta medhdha. Yaatada eta gidduwan worqqaappe oosettida daalata walahan ootta. ");
INSERT INTO wal_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Worqqaa daalatinne roomaaniyaa teera misileti he adussa maayuwaa duge bagga xeeraayyo yuushuwan walahan aadhdhona. ");
INSERT INTO wal_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aarooni qeesetettan oottiyo wode, ha adussa maayuwaa maayo; GODAA sintti Geeshsha Sohuwaa geliyo wodenne kiyiyo wode, daalai waassana. I hegaa maayikko haiqqenna. ");
INSERT INTO wal_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Walahi bainna worqqaappe issi alleequwaa medhdhada maatafaa bolli woociyoogaadan, a bolli woocada, ‘GODAASSI GEESHSHA GIDIDI DUMMATIIS’ yaagada xaafa. ");
INSERT INTO wal_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Xaafada huuphiyan xaaxiyo shaashiyaa bolli qachchana mala, salo milatiya baqettaa an aatta. ");
INSERT INTO wal_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aattobare Aarooni a ba som77uwan wotto; hegan Israa7eela asai GODAASSI imotaa immiiddi mooridobi de7ikkokka, he mooruwaa Aarooni tookkees. Asai ehiyoobaa GODAI ekkana mala, i he xifatiyaa ubbatonkka ba som77uwan wottanau koshshees. ");
INSERT INTO wal_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Aaroona qoliyaa liiqo liinuwaappe dadda; huuphiyan xaaxiyo shaashiyaakka liinuwaappe giigissa. Qassi danccuwaa xilppiyan alleeqissiyaagan sikissa. ");
INSERT INTO wal_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaroona naatuyyo bonchchonne alleeqo gidana mala, qoleta, danccotanne huuphiyan xaaxiyo shaasheta giigissa. ");
INSERT INTO wal_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Neeni ha maayota ne ishaa Aaroonanne a naata maizzidoogaappe guyyiyan, eti qeesetettan taayyo oottana mala eta tiya; tiyada eti qeese gididi taayyo oottana mala eta dummaya. ");
INSERT INTO wal_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Eta kalloi kamettana mala garssaara maayiyo maayuwaa, xeessaappe biidi wodiraa gakkanau kammiyaagaa, liiqo liinuwaa qacinaappe giigissa. ");
INSERT INTO wal_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aarooninne a naati Xoossaa Dunkkaaniyaa geliyo wode, woikko Geeshsha Sohuwan qeesetettan oottanau yarshshuwaa yarshshiyoosaa shiiqiyo wode, ha maayota maayona. Hegaadan hanikko, eti bantta bolli mooronne haiqo ehookkona. Hagee Aaroonayyoonne a zaretuyyo merinau woga gido. ");
INSERT INTO wal_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Aarooninne a naati qeese gididi taayyo oottana mala, neeni eta dummayanau hagaadan ootta; tilla bollaara de7iya issi mirgguwaanne naa77u dorssa orggeta ekka; ");
INSERT INTO wal_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","muruta gisttiyaa xiilliyaa ekkada, irshshuwaa yeggennan oittaa uukka; qassi irshshuwaa yeggennan zaitiyan komppuwaa komppa; hegaadankka, irshshuwaa yeggennan lee7e lichchakkuwaa uukkada, zaitiyaa tiya. ");
INSERT INTO wal_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Neeni eta masoofiyan wottada, mirgguwaaranne naa77u dorssa orggetuura issippe taayyo shiishsha. ");
INSERT INTO wal_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Yaatada Aaroonanne a naata Xoossaa Dunkkaaniyaa pengge ehaada, haattan eta meecca. ");
INSERT INTO wal_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Hegaappe guyyiyan, maayota ekkada, qoliyaa, eefuudiyaa bolli maayiyo adussa maayuwaa, eefuudiyaanne tiran wottiyoogaa Aaroona maizza; maizzada eefuudiyaa hiillan dadettida danccuwan gixissa. ");
INSERT INTO wal_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","SHaashiyaakka a huuphiyan xaaxada, ‘GODAASSI geeshsha gididi dummatiis’ yaagiyaabi xaafettido alleequwaa huuphiyaa xaattaa bolli aatta. ");
INSERT INTO wal_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tiyiyo zaitiyaakka ekkada, a huuphiyan tigada tiya. ");
INSERT INTO wal_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","A naatakka ehaada qoleta maizza. ");
INSERT INTO wal_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Maizzada shaashiyaakka eta huuphiyan xaaxa. Hegaappe guyyiyan, Aaroonanne a naata danccuwaa danccissa. Qeesetettai etayyo merinau wotto woga gido. Simmi Aaroonanne a naata yaatada qeese oottaasa. ");
INSERT INTO wal_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Mirgguwaa taayyo Xoossaa Dunkkaaniyaa sintti neeni ehin, Aarooninne a naati a huuphiyan bantta kushiyaa wottana. ");
INSERT INTO wal_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mirgguwaa Xoossaa Dunkkaaniyaa geliyo penggen GODAA achchan shukka. ");
INSERT INTO wal_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Mirgguwaa suuttaappe amaridaagaa ne biradhdhiyan ekkada, yarshshiyoosaa bolli de7iya kaceta tiya; tiyishin attidaagaa yarshshiyoosaappe garssa baggaara gussa. ");
INSERT INTO wal_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Hegaappe guyyiyan qantta ashuwaa kammida handda ubbaa, tiriyaa kammida handdaa, naa77u kilahotanne eta kamida handdaa ekkada, yarshshiyoosaa bolli wottada xuugga. ");
INSERT INTO wal_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","SHin mirgguwaa ashuwaa, a galbbaanne a maracciyaa dirssaappe kareera xuugga; hegee nagaraa gishshau yarshshiyo yarshshuwaa. ");
INSERT INTO wal_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Naa77u dorssa orggetuppe issuwaa neeni ekkin, Aarooninne a naati bantta kushiyaa a huuphiyan wottona. ");
INSERT INTO wal_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Yaatobare dorssa orggiyaa shukkada, suuttaa yarshshiyoosaa miyyiyan ubbasaara caccafa. ");
INSERT INTO wal_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Dorssa orggiyaayyo ashuwaa qanxxerettada, qantta ashuwaanne gedaa meecca; meeccada huuphiyaa bollinne hara qommo ashotu bolli eta wotta; ");
INSERT INTO wal_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","hegaappe guyyiyan, dorssa orggiyaa muleera yarshshiyoosan xuugga; hegee GODAAYYO xuugettiya yarshsho, sawuwaa tonggu giya yarshshonne GODAAYYO taman yarshshiyo yarshsho. ");
INSERT INTO wal_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Qassi hankko dorssa orggiyaa neeni ekka; ekkin Aarooninne a naati bantta kushiyaa a huuphiyan wottana. ");
INSERT INTO wal_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","He dorssa orggiyaa shukkada, a suuttaappe amaridaagaa ekkada, Aaroonayyoonne a naatuyyo ushachcha haittatu xeeraa, eta ushachcha kushetuyyo wogga biradhdhetanne eta ushachcha tohotuyyo wogga biradhdheta tiya; hegaappe guyyiyan, attida suuttaa yarshshiyoosaa miyyiyan ubbasaara caccafa. ");
INSERT INTO wal_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Yarshshiyoosan de7iya suuttaappe amaridaagaanne tiyettiyo zaitiyaappekka amaridaagaa ekkada, Aaroona bollinne a maayuwaa bolli, a naatu bollinne eta maayuwaa bolli caccafa; caccafin inne a naati, eta maayoi GODAA oosuwaayyo dummatana. ");
INSERT INTO wal_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ha dorssa orggiyaappe modhdhuwaanne nasiyaa, qantta ashuwaa bolli de7iya handdaa, tiriyaa kammida handdaa, naa77u kilahota, eta kammida handdaaranne ushachcha gedaara neeni ekka; hagee qeesetettaa sunttaa immiyo wode shukkiyo dorssaa. ");
INSERT INTO wal_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","GODAA sinttan wottido irshshoi gelibeenna oittaa, masoofiyaappe zaitee walahettibeenna oittaa, zaitiyaara uukkido issi komppuwaanne issi lee7e lichchakkuwaa ekka. ");
INSERT INTO wal_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Neeni ha katta ubbaa Aaroona kushiyaaninne a naatu kushiyan wotta; wottobare eti wuxaawuxiyo yarshsho oottidi GODAA sinttan pudenne dugenne wuxaawuxona. ");
INSERT INTO wal_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Hegaappe guyyiyan, eta kushiyaappe hageeta ekkada, yarshshiyoosaa bolli wottada, xuuggiyo yarshshuwaara gattada, GODAA sawuwaa tonggu gaanaadan, yarshshiyoosaa bolli taman xuugga. ");
INSERT INTO wal_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Aarooni qeese gididi sunttettiyo wode shukkido dorssa orggiyaa anggaasuwaa ekkada, GODAA sinttan wuxaawuxiyo yarshshodan wuxaawuxa; hegee inttena gakkiya shaaho gidana. ");
INSERT INTO wal_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“He shukkido dorssaa ashuwaa qommotikka: yarshsho oottidi wuxaawuxido anggaasuwaanne GODAA sinttan tookkido gedaa dummaya; hegeeti Aaroonayyoonne a naatuyyo shaaho gidana. ");
INSERT INTO wal_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Israa7eelati GODAAYYO immiyo issippetettaa yarshshoi, ubbatonkka Israa7eela asaappe Aaroonanne a naata gakkiya shaaho gido. ");
INSERT INTO wal_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Aaroona qeesetettaa maayoi appe guyyiyan a zaretussi de7o; tiyettidi qeese gidiyo wode, ha maayuwaa maayona. ");
INSERT INTO wal_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","A naatuppe a sohuwan qeese gididi, Geeshsha Sohuwan oottanau Xoossaa Dunkkaaniyaa yiya na7ai, he maayuwaa laappun gallassau maayo. ");
INSERT INTO wal_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Aarooninne a naati qeese gididi sunttettiyo wode shukettida dorssaa orggiyaa ashuwaa ekkada, geeshsha sohuwan doissa. ");
INSERT INTO wal_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aarooninne a naati dorssa orggiyaa ashuwaanne masoofiyan de7iya oittaa Xoossaa Dunkkaaniyaa geliyo penggen moona. ");
INSERT INTO wal_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Eti qeese gididi sunttettiyo wodenne dummatiyo wode, nagarai atto geetettanaadan yarshshettida ha yarshshota moona. SHin he yarshshoti geeshsha gidido gishshau, hara asi oonne mooppo. ");
INSERT INTO wal_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Qeese gididi sunttettiyo wode shukkido dorssa orggiyaa ashuwaappe woikko oittaappe maallado gakkanaassi palahidi aqikko, taman xuugetto; geeshsha gidido gishshau meetettoppo. ");
INSERT INTO wal_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Aarooninne a naati qeese gididi sunttettiyo wode wottiyo wogaa likke taani nena azazidoogaadan oottada, laappun gallassaa garssan pola. ");
INSERT INTO wal_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Nagarai atto geetettanaadan hachchi hachchi nagara yarshshodan issi mirgguwaa yarshsha. Hegan yarshshiyoosaa geeshsha; yaatada yarshshiyoosaa dummayanau tiya. ");
INSERT INTO wal_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Yarshshiyoosaa nagaraa atto giyo wogaa laappun gallassan polada, a dummaya. Yaatobare yarshshiyoosai aadhdhida geeshsha soho gidana. A bochchiya ubbaikka geeyana. ");
INSERT INTO wal_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Yarshshiyoosan neeni hachchi hachchi shiishshana yarshshoi hagaa. Yelettoosappe issi laitta gakkido naa77u dorssa orggeta yarshsha. ");
INSERT INTO wal_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Dorssa orggetuppe issuwaa maallado, qassi naa77anttuwaa omarssi yarshsha. ");
INSERT INTO wal_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Koiro dorssa maraara issi kilo giraame gidiya muruta gisttiyaa xiilliyaa issi litiro zaitiyan munaqqada yarshsha; issi litiro woiniyaa eessaakka ushshaa yarshsho oottada yarshsha. ");
INSERT INTO wal_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Naa77antto dorssa orggiyaa omarssi yarshshaidda maalladoogaa keena, xiilliyaa, zaitiyaanne woine eessaa shiishsha. Hegee GODAAYYO taman yarshshettiya, sawuwaa tonggu giya yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Ha xuuggiyo yarshshoi yiya yeleta ubban Xoossaa Dunkkaaniyaa geliyo penggiyan GODAA sinttan paci bainnan yarshshettanau koshshees. Taani yan gaittada, nenaara haasayana. ");
INSERT INTO wal_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Qassi yan taani Israa7eelatuura gaittana; ta bonchchoikka he sohuwaa dumma soho kessana. ");
INSERT INTO wal_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Hegaa gishshau, taani Xoossaa Dunkkaaniyaanne yarshshiyoosaa dummayana; eti taayyo qeese gididi taayyo oottana mala, Aaroonanne a naata taani dummayana. ");
INSERT INTO wal_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Yaatada taani Israa7eelatu giddon de7ana; qassi taani eta Xoossaa gidana. ");
INSERT INTO wal_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Taani eta giddon de7ana mala, Gibxxeppe eta kessida GODAA eta Xoossaa gidiyoogaa eti erana. Ee, taani GODAA eta Xoossaa. ");
INSERT INTO wal_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ixaanaa cuwayiyo saaxiniyaa guuganttaappe medhdha; ");
INSERT INTO wal_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ayyo oiddu zoozee de7o; zananai issi wara, gomppai issi wara, geesai qassi naa77u wara gido; kacetikka aara issuwaa gididi oiqetti merettona. ");
INSERT INTO wal_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ayyo bolla doonaa, oiddu miyye ubbaanne a kaceta walahi bainna worqqan sheeshsha; a yuushuwankka worqqa tigettaa yuushsha aatta. ");
INSERT INTO wal_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","He worqqa tigettaappe garssaara ixaanaa cuwayiyo saaxiniyaayyo worqqaappe naa77u sagaayota medhdha; yaatada ya baggaaranne ha baggaara naa77aa naa77aa oitta. Hegeeti tokkiyo wode kasota aattanaassi maaddanaassa. ");
INSERT INTO wal_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kasota guuganttaappe kessada, eta worqqan sheeshsha. ");
INSERT INTO wal_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ha yarshshiyoosaa Maachchaa Taabootaa sinttan kaqettida magalashuwaappe kare baggaara, hegaakka taani nenaara gaittiyo Maachchaa Taabootaa bolli de7iya atto giyo sohuwaa qum77uwaa sinttan wotta. ");
INSERT INTO wal_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aarooni maallado maallado xomppeta giigissanau yiyo wode, sawiya ixaanaa yarshshiyoosan cuwayo. ");
INSERT INTO wal_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aarooni omarssi xomppeta poo7issiyo wode, zaarettidikka ixaanaa cuwayo; yaatikko, ixaanai GODAA sinttan yiya yeletau ubbatoo cuwattana. ");
INSERT INTO wal_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ha yarshshiyoosan hara ai ixaananne, woikko xuugiyo yarshsho, woikko katta yarshsho yarshshoppa; ushshaa yarshshuwaakka a bolli tigoppo. ");
INSERT INTO wal_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aarooni laittaappe issiton nagaraappe maarettanau shukkiyo mehiyaa suuttaa ekkidi, he yarshshiyoosaa bolli de7iya kacetu bolli wotto. Yaatidi geeshshiyo wogaa polo. Ha wogai sinttaara yaana wodetu ubban laittan laittan poletto. Yaatobare ha yarshshiyoosai GODAAYYO dummati geeyidaagaa gido” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Neeni Israa7eela asaa qoodan ekkanau eta paidiyo wode, issi issi urai qoodettidi, ba shemppuwaa wozanau GODAAYYO miishshaa qanxxo; qanxxikko neeni eta qoodiyo wode, eta bolli boshi yeenna. ");
INSERT INTO wal_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Qoodan geliya asai huuphiyan huuphiyan Dunkkaaniyan eriyo meezaanaa likkiyan issi issi xaqara biraa qanxxo. Issi issi urai hagaa taayyo imo oottidi immo. ");
INSERT INTO wal_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Qoodan geliya asai laittai laatamaa kumidoogeenne hegaappe bolla ubbai, GODAAYYO immiyoobaa eho. ");
INSERT INTO wal_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Intte intte shemppuwaa wozanau GODAAYYO imuwaa immishin, dureekka manqqoikka issi likke immanaappe attin, duree darissidi woikko manqqoi guuttidi immoppo. ");
INSERT INTO wal_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Nagaraappe maarettanau qanxxiyo miishshaa Israa7eela asaappe ekkada, Xoossaa Dunkkaaniyaa giddo oosuwaassi peeshsha. Ha miishshai intte shemppuwaa wozanau, GODAA sinttan Israa7eela asaabaa hassayiyoobaa gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Meechcha keriyaanne a wottiyoogaa nahaasiyaappe medhdha; medhdhada Xoossaa Dunkkaaniyaappenne yarshshiyoosaappe gidduwan wotta; wottada an haattaa tiga. ");
INSERT INTO wal_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Tigin Aarooninne a naati bantta kushiyaanne bantta tohuwaa meecettana. ");
INSERT INTO wal_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Eti haiqqenna mala, Xoossaa Dunkkaaniyaa geliyo wode, audenne he haattan meecettona. Qassi GODAAYYO taman yarshshuwaa yarshshanaayyo yarshshiyoosaa mati shiiqido wode, ");
INSERT INTO wal_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","eti haiqqenna mala, bantta kushiyaanne bantta tohuwaa meecettona. Hagee Aaroonassinne a zaretussi, yiya yeleta ubbaassi merinau woga gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Muruta qimameta, hegeetikka, usuppun kilo giraame gukkiya karbbiyaa, heezzu kilo giraame sawiya qarafaa, heezzu kilo giraame sawiya gucachchaanne ");
INSERT INTO wal_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","usuppun kilo giraame zimbbaanuwaa ekka. Ha ubbaikka Dunkkaaniyan eriyo meezaanaa likkiyan gido. Hegaa bollikka oiddu litiro zaitiyaa gujja. ");
INSERT INTO wal_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Hageeta shittuwaa oottiyo eran wolakkada, sawiya geeshsha tiyettiyo zaite kessa. ");
INSERT INTO wal_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Yaatada Xoossaa Dunkkaaniyaa, Maachchaa Taabootaa, ");
INSERT INTO wal_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","xaraphpheezaanne a bolli wottiyo miishsha ubbaa, xomppiyaa wottiyo ballaanne a miishshata, ixaanaa cuwayiyo saaxiniyaa, ");
INSERT INTO wal_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","xuuggiyo yarshshuwaa yarshshiyoosaanne an de7iya ubba miishshata, meechcha keriyaanne a wottiyoogaa tiya. ");
INSERT INTO wal_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Eti aadhdhida keehi geeshsha gidana mala, neeni eta dummaya; eta bochchiyaabai ubbaikka geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Hegaappe guyyiyan, Aarooninne a naati qeese gididi taayyo oottana mala, eta tiya; tiyada dummaya; ");
INSERT INTO wal_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israa7eela asaayyo hagaadan yaagada yoota; ‘Hagee yiya yeletaassikka tiyettiyo ta geeshsha zaite gido; ");
INSERT INTO wal_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ha zaitiyaa asa bollan gussoppa; qassi ai zaitekka hegaa oottido likkiyan oottoppa. I geeshsha gidido gishshau, inttekka a geeshshabaadan qoppite. ");
INSERT INTO wal_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Hagaa mala shittuwaa giigissiya urinne qeese gidenna hara asa tiyiya uri ooninne ba asaa giddoppe bohetto’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; “Sawiya qimameta: mittaa cooshshaa, xaadhdhiyaa keettan de7iya shittuwaa, sawiya shidaanne sawiya ixaanaa ekka; eta ubbaa yesoikka issi likke gido. ");
INSERT INTO wal_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","SHittuwaadan walahettida ixaanaa oottada, etan go7etta; walahi bainnabaanne geeshsha gidanaadan, an maxiniyaa yegga. ");
INSERT INTO wal_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Appe amaridaagaa ekkada liiqissada cadda; yaatada taani nenaara gaittiyo Xoossaa Dunkkaaniyaa giddon Maachchaa Taabootaa sinttan wotta. Yaatobare i neeyyo ubbaappe aadhdhida geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Hagaa medhdhidoogaa likkiyan hara ixaanaa medhdhoppite. Hegee taayyo dumma geeshshabaa gidiyoogaa erite. ");
INSERT INTO wal_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Hagaa milatiyaabaa medhdhidi, a sawuwaa singgidi ufaittanau koyiya uri de7ikko, i ba asaa giddoppe bohetto” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Be7a; taani Yihudaa zare gidiya Huura na7aa na7aa, Uura na7aa, Baxaali7eela dooraas. ");
INSERT INTO wal_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","A taani Xoossaa Ayyaanan, hiillan, akeekaaninne ooso ubbaa oottiyo eran kunttaas; ");
INSERT INTO wal_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","hegeekka hiillan oosuwaa halchchuwaa kessiiddi, worqqaappe, biraappenne nahaasiyaappe dumma dummabaa i oottanaassa. ");
INSERT INTO wal_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Hegaadankka, al77o shuchchaa massidi giigissanaassa, mittaa massanaassanne hara ooso ubbaa i oottanaassa. ");
INSERT INTO wal_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","“Hegaa bollikka qassi a maaddana mala, Daana zare gidiya Ahisamaaka na7aa Oholi7aaba sunttaas. Taani nena azazidobaa ubbaa eti oottana mala, kushe hiilla eriyaageetussi ubbatussi eratettaa immaas. ");
INSERT INTO wal_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Eti oottanabati: Xoossaa Dunkkaaniyaa, Maachchaa Taabootaa, a bolli wottiyo atto giyo sohuwaa qum77uwaa, Xoossaa Dunkkaaniyaa giddon go7ettiyo miishsha ubbaa, ");
INSERT INTO wal_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","xaraphpheezaanne a miishshata, xomppiyaa wottiyo ballaa walahi bainna worqqaappe oosettidaagaanne a miishsha ubbaara, ixaanaa cuwayiyo saaxiniyaa, ");
INSERT INTO wal_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","xuuggiyo yarshshuwaa yarshshiyoosaanne a miishsha ubbaara, meecettiyo keriyaanne a wottiyoogaara, ");
INSERT INTO wal_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","dadettida maayuwaa, qeese ubbatu halaqai Aarooni maayana qeesetettaa maayotanne a attuma naati qeesetettaa oottiiddi maayana maayuwaa, ");
INSERT INTO wal_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","qassi tiyettiyo zaitiyaanne Geeshsha Sohuwaayyo sawuwaa tonggu giya ixaanaa. Eti hagaa ubbaa taani nena azazidoogaadan oottona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagidi azaziis; ");
INSERT INTO wal_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Israa7eela asaa neeni, ‘Ta Sambbataa naagite. Hegee taani GODAI inttena taassi geeshsha oottada dooridoogaa bessiyaagaa gididi, yaana yeleta ubbau taappenne intteppe gidduwan malaata gidana. ");
INSERT INTO wal_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Intteyyo i geeshsha gidiyo gishshau, Sambbataa bonchchite. A tunissiya asai ubbai mule haiqqo; he gallassan ooso oottiya ooninne ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Usuppun gallassatun neeni oosuwaa ootta; shin laappuntta gallassai GODAAYYO dummatida shemppo Sambbata; Sambbata gallassan ai oosonne oottiya ooninne haiqqo. ");
INSERT INTO wal_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israa7eelati ha Sambbata gallassaa yeletaappe yeletau merinaa malaata oottidi bonchchona. ");
INSERT INTO wal_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Taani usuppun gallassatun saluwaanne sa7aa medhdhido gishshaunne qassi laappuntta gallassan taani oosuwaa aggada shemppido gishshau, ta gidduwaaninne Israa7eelatu gidduwan hagee merinau malaata gidana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","GODAI Muuseyyo Siinaa Deriyaa bollan haasayiyoogaa wurssido wode, i ba biradhdhiyan xaafido tammu azazota oiqqida naa77u masettida shuchchata Muuseyyo immiis. ");
INSERT INTO wal_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Asai Muusee deriyaappe wodhdhennan keehi gam77idoogaa be7ido wode, Aaroona yuushuwan shiiqidi, “Haaya; neeni nuna kaalettiya xoossata nuuyyo medhdha. Aissi giikko, ha nuna Gibxxeppe ehiida Muusee waanidaakkonne nuuni erokko!” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Yaagin Aarooni eta, “Intte keettaayetu haittaaninne intte attuma naatunne macca naatu haittan de7iya worqqaa kessidi, taayyo ekki ehiite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Hegaappe guyyiyan, asai ubbai ba haittaa worqqaa kessidi, Aaroonayyo ehiidosona. ");
INSERT INTO wal_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ehin i hegaa eta kushiyaappe ekkidi, seerissiis; seerissidoogaappe guyyiyan, qoxxiyooban qoxxidi, mara milatiya eeqa oottidi medhdhiis. Medhdhin asai, “Israa7eelatoo, inttena Gibxxe biittaappe kessida intte xoossati hageeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aarooni hagaa be7ido wode, he maraa sinttan yarshshiyoosaa gimbbidi, “Wontto GODAA baalaa gallassa gidana” yaagidi erissiis. ");
INSERT INTO wal_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Hegaa gishshau, wonttetta gallassi asai guuran denddidi, xuuggiyo yarshshuwaa shiishshiis; issippetettaa yarshshuwaakka yarshshiis. Yaatidi asai maanaunne uyanau uttiis. Mi uyi simmidi, qassi duranau denddiis. ");
INSERT INTO wal_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yaanin GODAI Muusa, “Neeni eesuwan duge wodhdha; aissi giikko, ne asai, neeni Gibxxeppe kessada ehiidoogee nagaraa oottidi, bantta huuphiyaa tunissiichchidosona. ");
INSERT INTO wal_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Taani eta azazido ogiyaappe eti eesuwan sher77i giichchidosona. Worqqaa seerissidoogaa mara malatissidi, banttau eeqaa medhdhidosona. Medhdhidi ayyo goinnidosona; ayyo yarshshidosona. Eti, ‘Israa7eelatoo, inttena Gibxxe biittaappe kessida intte xoossati hageeta’ yaagidosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","GODAI Muusa, “Taani ha asaa be7aas; eti morgge zozzida asa. ");
INSERT INTO wal_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ha77i ta hanqqoi eta bolli eexxi kiyin, taani eta xaissanaagaa neeni tana diggoppa. Yaatada taani nena gita kawotetta oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","SHin Muusee GODAA ba Xoossaa hagaadan yaagidi woossiis; “Abeet GODAU, neeni ne gita wolqqaaninne ne mino kushiyan Gibxxeppe kessada ehiido ne asaa bolli ne hanqqoi aissi eexxi kiyii? ");
INSERT INTO wal_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Gibxxeti, ‘GODAI eta deretu bollan woranaunne biittaappe pitti xaissanau, iita halchchuwan kessiis’ aibissi giyoonaa? Ne yashshiya hanqquwaappe simma; ne asaa xaissanau qoppoogaa aggaaga. ");
INSERT INTO wal_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ne ailleta Abrahaama, Yisaaqanne Yaaqooba hassaya; neeni etassi, ‘Taani intte zariyaa saluwaa xoolinttetudan darissana; ha taani intteyyo immana giido biittaa ubbaakka intte zariyaayyo immana; eti he biittaa merinau laattana’ gaada ne huuphiyan neeni caaqqido qaalaa hassaya” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hegaa gishshau, GODAI ba asaa bolli iitabaa ehaanau qoppidoogaa aggidi, eta maariis. ");
INSERT INTO wal_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Hegaappe guyyiyan, Muusee tammu azazoti etan xaafetti uttido naa77u masettida shuchchata ba kushiyan oiqqidi, deriyaappe duge wodhdhiis. He shuchchati naa77u baggaarakka xaafettidosona. ");
INSERT INTO wal_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","He masettida shuchchata giigissidaagee Xoossaa; shuchchaa bolli woocidi xaafidaageekka Xoossaa. ");
INSERT INTO wal_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yaasu asaa wocamaa siyido wode, Muusa hagaadan yaagiis; “Dunkkaanidosan ola waasoi siyettees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Yaagin Muusee zaaridi, “Taani siyiyoogee hagee yettappe attin, xoonidaageetu cenggurssa woikko xoonettidaageetu cenggurssa gidenna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Muusee dunkkaanidosaa matido wode, maraanne durssaa be7idi keehi hanqqettiis; hanqqettidi ba kushiyan oiqqido masettida shuchchata deriyaa xaphuwan olidi mentterettiis. ");
INSERT INTO wal_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Eti medhdhido maraakka ekkidi, taman xuuggiis; hegaappe guyyiyan, liiqana gakkanaashin gaacciis; gaaccidi haattaa bolli laalidi, Israa7eela asai uyanaadan oottiis. ");
INSERT INTO wal_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Hegaappe guyyiyan, Muusee Aaroona, “Ha asai nena waatiinee neeni eta hagaa mala gita nagarau kaalettidoi?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaroonikka zaaridi, “Ta godau, hanqqettoppa; ha asai iitaa oottanau ai keena koyiyaakko neeni eraasa. ");
INSERT INTO wal_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Eti tana, ‘Nuna kaalettiya xoossata nuussi medhdha. Aissi giikko, ha nuna Gibxxeppe ehiida Muusee i waanidaakkonne nuuni erokko!’ yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Yaagin taani eta, ‘Intte bolli de7iya worqqaa kessidi, hammite’ yaagaas. Hegaappe guyyiyan, eti taayyo immido worqqaa taani taman yeggin, ha marai kiyiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Aarooni asaa gede coo yeddi aggin, asai ba morkketu sinttan kauyyidi karettidoogaa Muusee be7iis. ");
INSERT INTO wal_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Hegaa gishshau, Muusee dunkkaanidosaa geliyo penggiyan eqqidi hagaadan yaagiis; “GODAA bagga gidiya asi ooninne taakko yo!” yaagiis. Yaagin Leewati ubbai akko shiiqidosona. ");
INSERT INTO wal_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Hegaappe guyyiyan i eta, “GODAI Israa7eela Xoossai hagaadan yaagees; ‘Asai ubbai bisuwaa ba xeessan xeessan gixxo; gixxidi dunkkaanidosan gaxaappe gaxaa gakkanaashin, guyyenne sinttaunne simeretto; issoi issoi ba ishaa, ba laggiyaanne ba shooruwaa woro’ yaagees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leewati Muusee azazidoogaadan oottidosona; he gallassi asaappe heezzu sha7aa keenai haiqqiis. ");
INSERT INTO wal_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Hegaappe guyyiyan Muusee Leewata, “Hachchi intte GODAAYYO dummatideta; aissi giikko, intte intte naatanne intte ishata woranaukka azazettideta; hachchi GODAI inttena anjjiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Wonttetta gallassi Muusee asaa, “Intte gita nagaraa oottideta; shin ha77i taani GODAAKKO pude deriyaa kiyana; geelladan intte nagaraa taani atto giissanaakkonne” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Yaatin Muusee GODAAKKO simmidi biidi hagaadan yaagiis; “Ha asai gita nagaraa oottiis; eti banttayyo worqqaappe xoossata medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","SHin hayyanaa, ha77i eta nagaraa atto yaaga; hegee xayikko, neeni xaafido mazggabaappe tana qucca” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yaagin GODAI zaaridi Muusa, “Taani ta mazggabaappe quccanaagee ta bolli nagaraa oottida asatu sunttaa. ");
INSERT INTO wal_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ha77i baada, ha asaa taani neeyyo yootido sohuwaa kaaletta; ta kiitanchchaikka nena kaalettana; shin taani qaxxayanau wodee gakkin, eta eta nagaraa gishshau qaxxayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aarooni worqqaappe maraa misiliyaa medhdhanaadan asai giddido gishshau, GODAI asaa bolli gita boshaa yeddiis. ");
INSERT INTO wal_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; “Neeninne neeni Gibxxeppe kessido asai ha sohuwaappe denddite; denddidi, ‘Taani intte yaratussi immana’ yaagada wottido biittaa biite. He biittai taani Abrahaamayyo, Yisaaqayyoonne Yaaqoobayyo immana yaagada caaqqa wottido biittaa. ");
INSERT INTO wal_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Taani intte sinttan kiitanchchaa kiittada, Kanaaneta, Amooreta, Hiiteta, Parzzeta, Hiiwetanne Yaabuusata yedettana. ");
INSERT INTO wal_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Maattainne eessai goggiyo he biittaa biite. SHin intte morggee zozzido asa gidido gishshau, taani inttena ogiyan xaissargganau, inttenaara biikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Asai he yashshiya oduwaa siyidi keehippe yeekkiis. He wodeppe doommidi, ubbaikka bar alleequwaa aattiyoogaa aggi bayiis. ");
INSERT INTO wal_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Aissi giikko, GODAI Muusa hagaadan yaagi wottiis; “Israa7eela hagaadan yaaga; ‘Intte morggee zozzido asa. Taani inttenaara harai atto guutta wodiyaa biyaakkokka, taani inttena xaissarggana. Ha77i simmi intte alleequwaa kessirggite; yaatobare taani inttena oottanabaa qachchana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Yaagin Israa7eelati Siinaa Deriyaappe doommidi bantta alleeqota kessi wottidosona. ");
INSERT INTO wal_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Muusee dunkkaaniyaa ekki ekkidi efiidi, asai dunkkaanosaappe kareera haassidi toliis. Tolin he dunkkaanee, “Gaittiyo Dunkkaaniyaa” geetettidi xeesettiis. GODAA oichchanau koyiya ubbai dunkkaanosaappe kareera de7iya Gaittiyo Dunkkaaniyaa bees. ");
INSERT INTO wal_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Muusee he dunkkaaniyaa biido wode, audenne asai ubbai denddidi, ba dunkkaaniyaa penggen penggen eqqees; eqqidi Muusee he dunkkaaniyaa gelana gakkanaashin a xeellees. ");
INSERT INTO wal_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Muusee Gaittiyo Dunkkaaniyaa giddo gelido wode, shaaraa tuussai duge wodhdhees; wodhdhidi GODAI Muuseera haasayishin, he dunkkaaniyaa penggen takkees. ");
INSERT INTO wal_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","SHaaraa tuussaa he dunkkaaniyaa geliyo penggiyan be7ido wode ubban, asai ubbai ba penggen penggen denddi eqqidi, GODAAYYO goinnees. ");
INSERT INTO wal_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Asi ba laggiyaara haasayiyoogaadan GODAI Muuseera sinttan eqqidi, haasayees. Hegaappe guyyiyan, Muusee asai dunkkaanidosaa guyye simmees; shin a maaddiya yelagai, Nawe na7aa Yaasu, Gaittiyo Dunkkaaniyaappe shaahettenna. ");
INSERT INTO wal_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Muusee GODAA hagaadan yaagiis; “Neeni tana, ‘Ha asaa kaaletta’ yaagadasa; shin tanaara neeni oona kiittiyaakko, tana erissabaakka. Neeni, ‘Taani nena sunttan erais; neeni tanan nashettadasa’ yaagadasa. ");
INSERT INTO wal_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Neeni tana nashshidabaa gidikko, taani nena erana malanne sinttanaukka nenan nashettada daana mala, ne ogiyaa tana tamaarissa. Ha asai ne asaa gidiyoogaa hassaya” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yaagin GODAI zaaridi, “Taani nenaara baana; taani nena shemppissana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Yaatin Muusee a, “Neeni nunaara beennabaa gidikko, hagaappe nuna yeddoppa. ");
INSERT INTO wal_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Neeni nunaara beennan xayikko, tanaaninne ne asaani neeni ufaittidoogaa asai ubbai waani eranee? Biitta ubban de7iya hara asa ubbaappe tananne ne asaa dummayiyaabi harabi aibee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yaagin GODAI Muusa, “Taani nenan ufaittido gishshaunne nena ne sunttan eriyo gishshau, neeni tana oichchidoogaa ubbaa taani oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Yaatin Muusee, “Yaanikko phooliya ne qonccettaa bonchchuwaa tana bessarkkii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yaagin GODAI, “Taani ta phooliya bonchchuwaa qonccetta ubbaa ne sinttaara kanttissana; ta geeshsha sunttaakka ne achchan awaajjana. Taani GODAA; taani maaranau koyiyoogeeta maarana; qassi qarettanau koyiyoogeetuyyookka qarettana. ");
INSERT INTO wal_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","SHin neeni ta som77uwaa be7akka; aissi giikko, ooninne tana be7idi paxa de7enna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Hegaappe guyyiyan GODAI, “Neeni zaallaa bolli eqqanau hagan ta matan sohoi de7ees. ");
INSERT INTO wal_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ta bonchchoi kanttiyo wode, taani nena phalqqettida zaallaa giddon wottana; wottada taani kanttana gakkanaashin, ta kushiyan nena kammana. ");
INSERT INTO wal_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Hegaappe guyyiyan, taani ta kushiyaa diggin, neeni ta zokkuwaa be7ana; shin ta som77oi beettanau bessenna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","GODAI Muusa hagaadan yaagiis; “Koiroogeeta milatiya naa77u shuchchata massada giigissa; yaatobare taani he masettida shuchchatu bolli kase neeni menttido shuchchatu bollan de7iya qaalata xaafana. ");
INSERT INTO wal_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Wontto maallado pude Siinaa Deriyaa kiyanau giiga; yaatada tanaara yan deriyaa huuphiyan gaitta. ");
INSERT INTO wal_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nenaara ooninne kiyoppo; woikko deriyaa bolli awankka beettoppo; harai atto dorssaa wudee woikko mehiyaa wudeekka deriyaa sinttan heemettoppo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Hegaa gishshau, Muusee koiro shuchchata milatiya naa77u shuchchata massiis; massidi GODAI azazidoogaadan, shuchchata ba kushiyan oiqqidi, maallado guuraara pude Siinaa Deriyaa kiyiis. ");
INSERT INTO wal_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kiyin GODAI shaaran duge wodhdhidi, aara yan eqqiis; eqqidi, “GODAA” yaagidi ba sunttaa awaajjiis. ");
INSERT INTO wal_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","GODAI Muuse sinttaara hagaadan yaagidi awaajjiiddi kanttiis; “Taani GODAA; taani GODAA; qaretainne maarotai kumido Xoossaa, danddayanchchaa, aggenna siiqoi daridoogaanne daro ammanettiyaagaa. ");
INSERT INTO wal_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Taani ta aggenna siiquwaa sha7atussi naagiyaagaa; iitatettaa, makkalaanne nagaraa atto yaagiyaagaa. Gidikkokka, mooranchchaa qaxxayennan aggennaagaa; aawatu nagaraa gishshau naatanne naatu naata, heezzantto yeletaanne oiddantto yeletaa gakkanaashin qaxxayiyaagaa” yaagidi awaajjiis. ");
INSERT INTO wal_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Yaagin Muusee sohuwaara biittan gufannidi goinniis; ");
INSERT INTO wal_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","goinnidi, “Abeet Godau, neeni tanan ufaittidabaa gidikko, nunaara issippe hindda. Hagee asai morgge zozzidabaa gidikkokka, nu iitatettaanne nu nagaraa atto yaagada, nuna ne asa ootta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yaatin GODAI hagaadan yaagiis; “Taani inttenaara maachchaa maacettais; hagaappe kase sa7a ubban de7iya kawotetta ubban hani erenna maalaalissiyaabaa ne asa ubbaa sinttan oottana; taani GODAI, intteyyo oottiyo oosoi ai keena maalaalissiyaabaakko neeni eta giddon de7iyo asai be7ana. ");
INSERT INTO wal_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hachchi taani inttena azaziyo azazuwaa naagite; intte sinttappe Amooreta, Kanaaneta, Hiiteta, Parzzeta, Hiiwetanne Yaabuusata taani yedettana. ");
INSERT INTO wal_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Eti intteyyo pire gidenna mala, intte biyo biittan de7iya asaara maachchaa maacettoppite. ");
INSERT INTO wal_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Eti yarshshiyo sohota qolite; eti goinniyo shuchchatakka mentterettite; qassi Asheero giyo eta macca xoossee misiletakka qanxxeretti olite. ");
INSERT INTO wal_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Taani GODAI qanaatiya Xoossaa gidiyo gishshau, taappe hara xoossatuyyo goinnoppite. ");
INSERT INTO wal_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“He biittan de7iya asatuura aiba maachchakka maacettoppite; aissi giikko, eti tanan ammanettennan ixxidi bantta xoossata kaalliyo wodenne etayyo yarshshiyo wode, eti inttenakka shoobbana; shoobbin intte eta yarshshota maana. ");
INSERT INTO wal_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Qassi intte eta macca naatuppe dooridi, intte attuma naatussi immana; he wode he macca naati tanan ammanettennan ixxidi, bantta xoossata kaalliiddi, intte attuma naatakka banttaagaadan ootissana. ");
INSERT INTO wal_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Intteyyo goinniyo xoossata aibippekka seerissidi medhdhoppite. ");
INSERT INTO wal_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Oittaa Baalaa bonchchite; taani inttena azazidoogaadan, laappun gallassau irshshoi gelennan uukettida oittaa miite; hegaakka intte Gibxxeppe kiyido Abiiba aginan oottite. ");
INSERT INTO wal_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Aayee uluwaappe baira yelettiya attuma na7a ubbai tabaa; intte mehe ubbaappekka boora gidin, woikko dorssa gidin, bairai tabaa; ");
INSERT INTO wal_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","koiro yelettida hare maraa dorssa maraara laammada woza; wozana xayikko, a qooriyaa menttada wora. Ne naatuppe baira yelettida attuma na7a ubbaa woza. “Ooninne immiyoobaa oiqqennan, mela kusheera ta sinttan beettoppo. ");
INSERT INTO wal_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Usuppun gallassaa oottite; shin laappuntta gallassan shemppite; goyiyo wodiyankka qassi kattaa cakkiyo wodiyankka laappuntta gallassan shemppite. ");
INSERT INTO wal_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Baira zerettida gisttiyaa intte cakkiyo wode, Saaminttatu Baalaa bonchchite; laittaa wurssetta kattaa shiishshiyo wodekka, SHiishuwaa Baalaa bonchchite. ");
INSERT INTO wal_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Laittan heezzutoo Israa7eela attuma asai ubbai Ubbaa Haariya GODAA, Israa7eela Xoossaa sinttan beettona. ");
INSERT INTO wal_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Kawotettata taani intte sinttappe yedettada kessana; yaatada intte zawaa taani aassana. GODAA intte Xoossaa sinttan intte laittan heezzutoo beettanau pude kiyiyo wode, ooninne intte biittaa amottenna. ");
INSERT INTO wal_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Intte taayyo suuttaa yarshshuwaa yarshshiyo wode, irshshuwaa yeggidi uukkido oittaara yarshshoppite. Paasikaa bonchchiyo gallassaayyo yarshshido yarshshuwaappe maalladossi aibinne attoppo. ");
INSERT INTO wal_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Intte gaden baira kaxxida kattaappe koiro murutaa GODAA intte Xoossaa keettaa ehiite. “Deeshsha maraa a aayee maattan doissoppite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","GODAI Muusa, “Taani nenaaranne Israa7eela asaara maachchaa maacettiyoi ha qaalati giyo maaraana gidiyo gishshau, ha qaalata xaafa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Muusee katta meennaaninne haatta uyennan, oitamu gallassaanne oitamu qammaa GODAARA yan gam77iis; gam77idi maachchaa qaalata, tammu azazota masettida shuchchan xaafiis. ");
INSERT INTO wal_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Muusee GODAARA haasayiiddi gam77ido gishshau, he naa77u masettida shuchchata i ba kushiyan oiqqidi Siinaa Deriyaappe duge wodhdhido wode, a som77oi phooliis; shin i hegaa eribeenna. ");
INSERT INTO wal_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aarooninne Israa7eela asai ubbai Muusa xeellidi, a som77oi phooliyoogaa be7idosona; be7idi eti akko shiiqanau yayyidosona. ");
INSERT INTO wal_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","SHin Muusee eta xeesiis; xeesin Aarooninne yaa7aa kaalettiya halaqati ubbai akko simmidosona; simmin i eta haasayissiis. ");
INSERT INTO wal_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Hegaappe guyyiyan Israa7eela asai ubbai akko shiiqiis; shiiqin GODAI ayyo Siinaa Deriyan immido azazo ubbaa i etau immiis. ");
INSERT INTO wal_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Muusee etau yootiyoogaa wurssido wode, ba som77uwaa naxalan kammiis. ");
INSERT INTO wal_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","SHin Muusee GODAA sintti aara haasayanau geliyo wode audenne kiyana gakkanaashin, naxalaa ba som77uwaappe qaarirggees. Hegaappe kiyidi, GODAI azazidobaa Israa7eela asau yootees. ");
INSERT INTO wal_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Yootiyo wode, eti a som77oi phooliyaagaa be7idosona. Hegaa gishshau, Muusee GODAARA haasayanau baana gakkanaashin, ba som77uwaa zaarettidikka naxalan kammees. ");
INSERT INTO wal_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Muusee Israa7eela asaa yaa7aa muliyaa shiishshidi hagaadan yaagiis; “Intte oottana mala, GODAI azazidobai hagaa: ");
INSERT INTO wal_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Saaminttaa giddon usuppun gallassa xalaalan oosuwaa oottite; shin laappuntta gallassai intteyyo geeshsha gallassa; GODAAYYOOKKA shemppo Sambbata. He gallassi ai oosonne oottiya uri ooninne haiqqanau bessees. ");
INSERT INTO wal_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Sambbata gallassan intte son son tama eettoppite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Muusee Israa7eela maabarau muliyau hagaadan yaagiis; “GODAI hagaadan yaagidi azaziis: ");
INSERT INTO wal_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Intteyyo de7iyaabaappe GODAAYYO immiyoobaa ehiite; GODAAYYO immiyoobaa ehaanau koyiya ooninne worqqaa, biraa, nahaasiyaa, ");
INSERT INTO wal_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","salo milatiya qacinaa, ochchaa teeraa milatiya qacinaa, shololla zo7o qacinaanne liiqo liinuwaa, deeshshaa agoziyaa, ");
INSERT INTO wal_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","dorssa orggiyaa calaa zo7o qalamiyan yeggi kessidoogaa, irppaniyaa, guuganttaa, ");
INSERT INTO wal_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","xomppiyaassi wogaraa zaitiyaa, tiyettiyo zaitiyaanne ixaanaa sawettiya qimamiyaa; ");
INSERT INTO wal_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","eefuudiyaaninne tiran wottiyoogan yeggiyo maragidiyaa geetettiya shuchchatanne hara phooliya al77o shuchchata eho. ");
INSERT INTO wal_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Intte giddon de7iya kushe hiilla eranchcha ubbati yiidi, GODAI azazido ubbaa oottona: ");
INSERT INTO wal_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Xoossaa Dunkkaaniyaa, a kammiyo dunkkaaniyaanne a kammiyoogaa, qapheta, xagaageta, hiraqota, tuussatanne eti eqqiyo gedeta, ");
INSERT INTO wal_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Taabootaanne a tookkiyo kasota, atto giyo sohuwaa qum77uwaanne Taabootaa genttiyo magalashuwaa; ");
INSERT INTO wal_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","xaraphpheezaanne a tookkiyo kasota, a miishshata ubbaanne GODAA sinttan wottiyo geeshsha oittaa; ");
INSERT INTO wal_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","xomppiyaa wottiyo ballaanne an maaraara de7iya xomppeta, miishshata, xomppiyaa zaitiyaa, ");
INSERT INTO wal_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ixaanaa cuwayiyo saaxiniyaanne a tookkiyo kasota, tiyettiyo zaitiyaanne sawiya ixaanaa, Xoossaa Dunkkaaniyaa penggiyaa magalashuwaa; ");
INSERT INTO wal_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","xuuggiyo yarshshuwaa yarshshiyoosaanne a nahaasiyaa zazzariyaa, a tookkiyo kasotanne a miishshata ubbaa, nahaasiyaappe oosettida meechcha keriyaanne a wottiyoogaa; ");
INSERT INTO wal_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","so dabaabaa godaa magalashota, tuussatanne eta gedeta, dabaabaa soo giddo geliyo penggiyaa magalashuwaa; ");
INSERT INTO wal_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Xoossaa Dunkkaaniyaa toliyo xisheta, dabaabaa giddo xishetanne eta wodorota; ");
INSERT INTO wal_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","qeeseti Geeshsha Sohuwan oottiiddi maayanau dadettida maayota, qeesee Aarooninne a naati qeesetettaa oosuwaa oottiiddi maayiyo maayota oottona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hegaappe guyyiyan Israa7eela maabarai ubbai Muuse sinttappe kiyiis. ");
INSERT INTO wal_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Kiyidi immanau koyidaageetinne eta wozanai eta imma imma giidoogeeti ubbai yiidosona; yiidi Xoossaa Dunkkaaniyaassi, a giddon oottiyo ooso ubbaunne geeshsha maayuwau koshshiyaabaa ubbaa ehiidosona. ");
INSERT INTO wal_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Immana koyida attuma ubbainne macca ubbai yiidi, worqqaappe medhdhido alleeqota, haittaa gutuchchata, migidota, qooriyan aattiyo gujjumatanne worqqaa alleeqota ehiidosona; ehiidi GODAASSI imo oottidi immidosona. ");
INSERT INTO wal_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Salo milatiya qacinai, ochcha teera milatiya qacinai, shololla zo7o qacinai, woikko liinuwaa giyo liiqo qacinai, woikko deeshshaa agozee, dorssa orggiyaa calaa zo7o qalamiyan yeggi kessidoogee, woikko irppanee de7iyo asai ubbai ekkidi ehiis. ");
INSERT INTO wal_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Biraa woikko nahaasiyaa immanau danddayiya ubbai bantta imuwaa GODAAYYO immidosona; qassi guuganttai de7iyo asai ubbai dumma dumma oosuwau guuganttaa ehiis. ");
INSERT INTO wal_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kushe hiillaa eriya maccaasai ubbai bantta kushiyan suqqido salo milatiya qacinaa, ochchaa teeraa milatiya qacinaa, shololla zo7o qacinaanne liiqo liinuwaa ehiidosona. ");
INSERT INTO wal_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Qassikka imuwaa immanau koyida maccaasai ubbai deeshshaa agoziyaa daddidosona. ");
INSERT INTO wal_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Halaqati eefuudiyaaninne tiran wottiyoogan wottiyo maragidiyaanne hara bonchchettida shuchchata ehiidosona. ");
INSERT INTO wal_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Eti qassikka xomppiyaayyo, sawiya ixaanaayyoonne tishshaassi haniya wogaraa zaitiyaanne qimamiyaa ehiidosona. ");
INSERT INTO wal_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Israa7eelati asai ubbai, attumainne maccai, eti oottanaadan GODAI Muuse baggaara azazido oosuwau haniya imuwaa ubbaa bantta dosan GODAYYO ehiidosona. ");
INSERT INTO wal_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Muusee Israa7eela asaa hagaadan yaagiis; “Be7ite; GODAI Yihudaa zariyaappe Huura na7aa na7aa, Uura na7aa, Baxaali7eela dooriis. ");
INSERT INTO wal_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Dooridi GODAI a Xoossaa Ayyaanan, hiillan, akeekaaninne ooso ubbaa oottiyo eran kunttiis. ");
INSERT INTO wal_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Hegeekka hiillan oosuwaa halchchuwaa kessidi, worqqaappe, biraappenne nahaasiyaappe dumma dummabaa i oottanaassa. ");
INSERT INTO wal_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Hegaadankka, al77o shuchchaa massidi giigissanaassa; mittaa massanaassanne ubba qommo oosuwaa hiillan oottanaassa. ");
INSERT INTO wal_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hegaa bollikka qassi ayyoonne Daana zariyaa Ahisamaaka na7aa Oholi7aabayyo, hara asaa tamaarissiyo eratettaa immiis. ");
INSERT INTO wal_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Eti ubba qommo ooso oottanaadan, hiillan oottiyaageeta, oosuwaa halchchuwaa kessiyaageeta, salo milatiya qacinan, ochchaa teeraa milatiya qacinan, shololla zo7o qacinaaninne liinuwaa qacinan alleequwaa daddiyaageetanne shimainneta gidanaadan, GODAI eta eratettan kunttiis. Eti ubbaikka ubba qommo oosuwaa luxidi eriya eranchcha gididosona. ");
INSERT INTO wal_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Hegaa gishshau, Baxaali7eeli, Oholi7aabinne Xoossaa Dunkkaaniyaa keexxana mala GODAI eraa immin, luxida asai ubbai GODAI azazidoogaadan ubbabaa oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Hegaappe guyyiyan, Muusee Baxaali7eela, Oholi7aabanne GODAI dumma eratettaa immidoogeeta oosuwaa oottanau yaana koyiya ubbaa xeesidi shiishshiis. ");
INSERT INTO wal_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","SHiiqidaageeti Israa7eela asai Xoossaa Dunkkaaniyaa oottanau ehiido imo ubbaa Muuseppe ekkidosona. Qassi asai ba dosan coo immiyo imotaa maallado maallado gujji gujjidi ehiyoogaa aggibeenna. ");
INSERT INTO wal_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Yaatin Xoossaa Dunkkaaniyaa oottiya erai kumido asai ubbai bantta oosuwaa wottiishshidi, ");
INSERT INTO wal_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Muusa hagaadan yaagidosona; “Asai GODAI azazido oosuwaayyo koshshiyaagaappe keehi dariyaagaa ehiiddi de7ees” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Yaagin Muusee dunkkaanidosan de7iya asaassi hagaadan yaagidi azaziis; “Naa77antto ai attumaasikka ai maccaasikka Xoossaa Dunkkaaniyaa oosuwaassi immiyoobaa immanau ehooppo” yaagin, asai ehiyoogaa aggi bayiis. ");
INSERT INTO wal_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Aissi giikko, eti ehiido imotai ooso ubbaa oottanau gididi palahees. ");
INSERT INTO wal_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Oosuwaa oottiyaageetu giddoppe hiillaa dariyaageeti ubbati liiqo liinuwaappenne salo milatiya, ochcha teeraa milatiyaanne shololla zo7o qacinaappe dadettida tammu magalashotuppe Xoossaa Dunkkaaniyaa giigissidosona. He magalashotu bolli bollaara issi hiillai kiruubetu misiliyaa sikkiis. ");
INSERT INTO wal_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Magalashoti ubbai issi likke gididi, geesai laatamanne hosppun wara; gomppai 4 wara. ");
INSERT INTO wal_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ichchashu magalashota issippe gattidi sikkidosona; qassi hankko attida ichchashu magalashotakka etadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Issippe gattidi sikkido magalashotuppe issi magalashuwaassi wurssetta gaxan salo milatiya carqqiyaappe siireta medhdhidosona. Qassi issippe gaitetti sikettida hankko magalashuwankka hegaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Eti issippe gaittida issi magalashuwaa bolli ishatamu siireta, qassi issippe gaittida hankko magalashuwaa bollikka ishatamu siireta medhdhidosona. He siireti ubbaikka issoi issuwaassi baazzan de7oosona. ");
INSERT INTO wal_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hegaappe guyyiyan, worqqaappe ishatamu qapheta medhdhidosona. Medhdhidi Dunkkaanee issuwaa gidana mala, he magalashotu gaxaa gaxaa he qaphetun oittidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Xoossaa Dunkkaaniyaa bollaara kammiyo dunkkaaniyaassi tammanne isiini magalashota deeshshaa agoziyaappe daddidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tammanne isiini magalashotikka issi likke; issi issi magalashuwaa geesai hasttamu wara, gomppai oiddu wara. ");
INSERT INTO wal_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ichchashu magalashota issi baggaara, usuppun magalashota qassi hankko baggaara gattidi sikkidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Hegaappe guyyiyan, gatti sikkido magalashotuppe issi magalashuwaa gaxan ishatamu siireta medhdhidosona. Qassikka gatti sikkido hankko magalashotuppe wurssetta magalashuwaa gaxan ishatamu siireta medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Naa77u baggaara de7iya magalashota gattidi issi Dunkkaane oottanau nahaasiyaappe ishatamu qapheta medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Hegaappe guyyiyan, dunkkaaniyaa kammanau dorssa orggiyaa calaa zo7o qalamiyan yeggi kessidoogaa giigissidosona; qassi a bollaara kammanau irppaniyaa giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Xoossaa Dunkkaaniyaa xagaagiyoobata sitti giida guuganttaappe kessidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Issi issi xagaagiyau geesai tammu wara; gomppai issi waranne bagga. ");
INSERT INTO wal_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Issi issi xagaagiyaassi issuwaa issuwaara gatti oittiya naa77u marata medhdhidosona. Xoossaa Dunkkaaniyaa xagaageta ubbaakka hegaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Xoossaa Dunkkaaniyaayyo tohossa baggaara laatamu xagaageta medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Medhdhidi issi issi xagaagiyaayyo naa77u gedeta, muleera oitamu gedeta biraappe giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Xoossaa Dunkkaaniyaayyo huuphessa baggaara laatamu xagaageta medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Medhdhidi issi issi xagaagiyaayyo naa77u gedeta, muleera oitamu gedeta biraappe giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Xoossaa Dunkkaaniyaayyo guyye gaxan arggo baggaara usuppun xagaageta medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Xoossaa Dunkkaaniyaa guyye gaxan de7iya zoozetuyyo naa77u xagaageta giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ha naa77u zoozetun de7iya xagaageti xaphuwaappe xeeraa gakkanaashin daabula gididi biidi, xeeran issi sagaayuwan geli oiqettidosona. Eti naa77aikka hegaadan hanidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Hegaa gishshau, issi issi xagaagiyaayyo garssaara naa77u naa77u gedeti de7oosona; muleera hosppun xagaagetinne biraappe oosettida tammanne usuppun gedeti de7oosona. ");
INSERT INTO wal_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Qassi eti guuganttaappe hiraqota kessidosona; Xoossaa Dunkkaaniyaayyo issi bagga miyyiyan de7iya xagaagetuyyo ichchashu hiraqota, ");
INSERT INTO wal_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","qassi hankko bagga miyyiyan de7iya xagaagetussi ichchashu hiraqota giigissidosona. Hegaadankka, Xoossaa Dunkkaaniyaayyo guyye arggo baggaara wurssetta gaxan de7iya xagaagetuyyo ichchashu hiraqota medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Giddo hiraqoi xagaagetussi giddo ginaara, ha gaxaappe ya gaxaa gakkanau kantti kiyanaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Xagaageta worqqan sheeshshidi, hiraqoti aadhdhiyo sagaayota worqqaappe medhdhidosona; qassi hiraqotakka worqqan sheeshshidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Salo milatiya, ochcha teera milatiyaanne, shololla zo7o qacinaappenne liiqo liinuwaappe issi magalashuwaa oottidosona. He magalashuwaa bolli issi hiillai kiruubetu misiliyaa sikkiis. ");
INSERT INTO wal_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Magalashuwaayyo oiddu tuussata guuganttaappe giigissidi, worqqan sheeshshidosona. Yaatidi worqqa kaqqiyoogeeta etayyo giigissidosona. Qassi tuussata essiyo oiddu gedeta biraappe medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Xoossaa Dunkkaaniyaa geliyo penggiyaassi salo milatiya, ochcha teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe dadettidaagaa, xilppiyaa alleeqissiyaagan magalashuwaa giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Qassi eta kaqqiyo ichchashu tuussata, kaqqiyo ballaara de7iyaageeta medhdhidosona. Tuussatu gumbbotanne qachchiyoogeeta worqqan sheeshshidosona. Qassi eta gedeta ichchashatakka nahaasiyaappe medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Baxaali7eeli guuganttaa mittaappe Taabootaa giigissiis. He Taabootai zananaa naa77u waranne baggaa aduqqees; gomppai issi waranne baggaa aakkees; geesaikka issi waranne baggaa xoqqees. ");
INSERT INTO wal_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He Taabootaa giigissidi, suwaanne kariyaa walahi bainna worqqan sheeshshiis; yuushuwaakka worqqa tigettan yuushshi aattiis. ");
INSERT INTO wal_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Qassi oiddu worqqa sagaayota tigidi, Taabootaayyo oiddu gedetun, issi baggaara naa77u sagaayota, qassi hankko baggaara naa77u sagaayota aattiis. ");
INSERT INTO wal_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Yaatidi guuganttaappe kasota kessiis. Kessidi etakka worqqan sheeshshiis. ");
INSERT INTO wal_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Taabootaa tookkanau, Taabootaa miyyiyan de7iya sagaayotun kasota aattiis. ");
INSERT INTO wal_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Walahi bainna worqqaappe naa77u waranne baggaa aduqqiya, issi waranne baggaa aakkiya atto giyo sohuwaa qum77uwaa medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Qum77uwaayyo wurssetta naa77u bagga gaxan naa77u kiruubeta qoxettida worqqaappe medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Issi kiruubiyaa issi bagga gaxan, naa77antto kiruubiyaa hankko bagga gaxan, naa77aakka qum77uwaara gatti oittidi medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kiruubeti bantta qefiyaa denttidi, atto giyo sohuwaa kammiyo qum77uwaa bantta qefiyan kuwayi wottidosona; qassi issoi issuwaakko simmi uttidi, qum77uwaa xeelloosona. ");
INSERT INTO wal_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Qassi zananai naa77u wara, gomppai issi wara, geesaikka issi waranne bagga gidido xaraphpheezaa guuganttaappe medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Medhdhidi walahi bainna worqqan sheeshshiis. Yuushuwaakka worqqa tigettaa yuushshi aattiis. ");
INSERT INTO wal_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hegaadankka, gomppai takkaaro gidiya shaashiyaa a bolli yuushshi aattiis. Yaatidi a bolli worqqaa tigettaa yuushshiis. ");
INSERT INTO wal_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Yaatidi Taabootaa tookkanau giigiya oiddu worqqa sagaayota medhdhiis; medhdhidi oiddu gedeti merettido oiddu zoozetuura oittiis. ");
INSERT INTO wal_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Xaraphpheezaa tookkanau kasota aattiyo sagaayoti xaraphpheezau shaashiyaa lanqqiyan shiiqidi merettidosona. ");
INSERT INTO wal_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Xaraphpheezaa tookkiyo kasotakka guuganttaappe kessidi, worqqan sheeshshiis. ");
INSERT INTO wal_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hegaadankka, xaraphpheezaa bolli wottiyo dumma dumma miishshata walahi bainna worqqaappe medhdhiis; hegeetikka sainetanne cilppata, qassi ushshaa yarshshuwaa tigiyo keretanne xuu7ata. ");
INSERT INTO wal_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hegaappe guyyiyan Baxaali7eeli xomppiyaa wottiyo ballaa qoxettida walahi bainna worqqaappe medhdhiis; he ballaa essiyo gediyaakka, giddo toomaakka qoxxido worqqaappe medhdhiis. A qururuusota, a kukkumotanne a ciishshata ubbaa aara issippe oittidi medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Miyyiyaara usuppun marata medhdhiis; marata heezzaa issi baggaara, qassi heezzaa hankko baggaara kessiis. ");
INSERT INTO wal_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Usuppun maratussikka huuphiyan huuphiyan issi issi kukkumoinne ciishshati de7iyo lauziyaa ciishshaa milatiya wanccaa medhdhiis; ");
INSERT INTO wal_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","xomppiyaa wottiyo ballaassi giddo toomai, kukkumotinne ciishshati de7iyo lauziyaa ciishshaa milatiya oiddu wanccan alleeqetti uttiis. ");
INSERT INTO wal_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Naa77ai naa77ai issippe waattan de7iyo heezzu maratuppe garssaara issi issi kukkumoi meretti uttiis. ");
INSERT INTO wal_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Kukkumotinne marati ubbai xomppiyaa wottiyo ballaara issippe oiqetti issuwaa gididi, walahi bainna worqqaappe qoxettidi merettidosona. ");
INSERT INTO wal_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","I qassi xomppiyaa wottiyo ballau laappun xomppeta, xomppiyaa toissiyo qaphetanne eta wottiyoobata walahi bainna worqqaappe medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Xomppiyaa wottiyo ballaanne an go7ettiyo miishshaa ubbaa medhdhanau hasttamanne ichchashu kilo giraame gidiya walahi bainna worqqaa wurssiis. ");
INSERT INTO wal_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hegaadankka, qassi ixaanaa cuwayiyo saaxiniyaa guuganttaappe medhdhiis. Ayyo oiddu zoozee de7ees; zananai issi wara; gomppai issi wara, geesai naa77u wara. A kacetikka aara issuwaa gididi oiqetti merettidaageeta. ");
INSERT INTO wal_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ayyo bolla doonaa, oiddu miyye ubbaanne a kaceta walahi bainna worqqan sheeshshidi, a yuushuwaakka worqqaa tigettaa yuushshi aattiis. ");
INSERT INTO wal_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He worqqaa tigettaappe garssaara ixaanaa cuwayiyo saaxiniyaayyo worqqaappe naa77u sagaayota medhdhiis; yaatidi ya baggaaranne ha baggaara naa77aa naa77aa oittiis. Hegeeti tookkiyo wode kasota aattanau maaddanaassa. ");
INSERT INTO wal_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Kasota guuganttaappe kessidi, eta worqqan sheeshshiis. ");
INSERT INTO wal_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Qassi geeshsha tiyettiyo zaitiyaanne sawuwaa tonggu giya lo77o ixaanaa shittuwaa oottiyo eran giigissiis. ");
INSERT INTO wal_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Guuganttaappe xuuggiyo yarshshuwaa yarshshiyoosaa keexxiis. He yarshshiyoosaayyo geesai heezzu wara, gomppainne zananai issi likke, ichchashu ichchashu wara gididi, oiddu zooziyaara de7iyaagaa oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Oiddu zoozetu wurssetta gaxan gaxan issi issi kaciyaa medhdhiis. He kaceti yarshshiyoosaara issippe oiqettidi oosettidosona. Yaatin yarshshiyoosaa nahaasiyaa biratan sheeshshiis. ");
INSERT INTO wal_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","An go7ettiyo miishshata, balddeta, akaafata, araciyo kuixaarota, ashuwaa qaphiyo qaphetanne tama cooceta ubbaa nahaasiyaa birataappe medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Yaatidi nahaasiyaa birataappe zazzariyaa yarshshiyoosaassi giigissiis; giigissidi yarshshiyoosaayyo duge giddo ginan de7iya dacaa bolli wottiis. ");
INSERT INTO wal_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Nahaasiyaa birataappe medhdhido zazzariyaayyo oiddu zooziyan kasota aattanau oiddu sagaayota medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Guuganttaappe yarshshiyoosaayyo kasota kessidi, nahaasiyaa biratan sheeshshiis. ");
INSERT INTO wal_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Yarshshiyoosaa tookkiyo wode maaddana mala, ha kasota naa77u miyyiyaara de7iya sagaayotun aattiis. Yarshshiyoosaa gidduwaa kofa kessidi, xaulaappe medhdhiis. ");
INSERT INTO wal_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Nahaasiyaa birataappe meechcha keriyaanne a wottiyoogaa medhdhiis; he biratai Xoossaa Dunkkaaniyaa penggen oottiya maccaasati ehiido heregaappe ekettiis. ");
INSERT INTO wal_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hegaappe guyyiyan, dabaabaa giigissiis. Dabaabaassi tohossa bagga zananaa xeetu wara oottidi, liiqo liinuwaappe dadettida magalashuwaa giigissiis. ");
INSERT INTO wal_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ayyo nahaasiyaa birataappe laatamu tuussatanne tuussati eqqiyo nahaase gedeta oottiis; eta huuphiyan qassi biraappe merettida kaqqiyoogeetanne tuussata huuphiyan qachchiyoogeeta oottiis. ");
INSERT INTO wal_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Dabaabau huuphessa bagga zananai xeetu wara adussa; qassi laatamu tuussatinne he tuussatuyyo laatamu nahaasiyaa gedeti de7oosona. Yaatidi biraappe oosettida kaqqiyoogeetinne tuussatu huuphiyan qachchiyoogeeti de7oosona. ");
INSERT INTO wal_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Arggo bagga dabaabaa gomppai ishatamu wara aaho gididi, tammu tuussatinne tuussatuyyo tammu gedeti de7iyo magalashota giigissiis; he tuussatu huuphiyan biraappe merettida kaqqiyoogeetanne tuussatu huuphiyan qachchiyoogeeta oottiis. ");
INSERT INTO wal_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Qassi arshsho bagga dabaabaa gomppai ishatamu wara aaho. ");
INSERT INTO wal_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Dabaabaa geliyoosaappe issi baggaara tammanne ichchashu wara aduqqiya magalashoti, etayyo heezzu tuussatinne tuussatuyyo heezzu gedeti de7oosona. ");
INSERT INTO wal_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Hegaadankka, dabaabaa geliyoosaappe hinkko baggaara, tammanne ichchashu wara aduqqiya magalashoti, etayyo heezzu tuussatinne tuussatuyyo heezzu gedeti de7oosona. ");
INSERT INTO wal_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Dabaabaa yuushuwan de7iya magalashoti ubbai liiqo liinuwaappe dadettidaageeta. ");
INSERT INTO wal_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","He tuussatu gedeti nahaasiyaappe, kaqqiyoogeetinne tuussatu huuphiyan qachchiyoogeeti biraappe oosettidosona; eta huuphee biran sheeshettiis. Hegaa gishshau, dabaabaa yuushuwan de7iya tuussatu ubbaa huuphiyan biraappe oosettida qachchiyoogeeti de7oosona. ");
INSERT INTO wal_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Dabaabaa geliyoosan kaqqiyo magalashoi salo milatiya ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe daddiyoogaa xilppiyan alleeqissiyaagan giigissidoogaa. Ayyo zananai laatamu wara; geesai dabaabaa magalashotu likke, ichchashu wara. ");
INSERT INTO wal_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Nahaasiyaa birataappe oosettida oiddu tuussatinne tuussatussi oiddu gedeti de7oosona. Eta kaqqiyoogeetinne tuussatu huuphiyan qachchiyoogeeti biraappe oosettidosona; eta huuphetikka biran sheeshettidosona. ");
INSERT INTO wal_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Xoossaa Dunkkaaniyaa xisheti ubbainne a yuushuwan de7iya dabaabaa xisheti ubbai nahaasiyaa birataappe oosettidaageeta. ");
INSERT INTO wal_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Xoossaa Dunkkaaniyau, Maachchaa Dunkkaaniyau, go7ettido miishshata Leewati mazggaban xaafidosona. He miishshata qeesiyaa Aaroona na7aa Itaamaara halaqatettaa garssan de7iya Leewati mazggaban xaafanaadan Muusee azaziis. ");
INSERT INTO wal_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Biniyaama zare gidiya Hoora na7aa na7aa, Uura na7aa, Baxaali7eeli GODAI Muusa azazido ubbaa oottiis. ");
INSERT INTO wal_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Daana zare gidida Ahisamaaka na7aa Oholi7aabi aara de7ees; i kushe hiillanchchanne oottiyoobaassi koiro halchchuwaa kessiyaagaa; qassi salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaaninne liiqo liinuwan daddidi, xilppiyan alleeqissiya asa. ");
INSERT INTO wal_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Xoossaa Dunkkaaniyaa oosuwaayyo GODAASSI imettida worqqai Xoossaa Dunkkaaniyan eriyo meezaanan wottin, issi sha7u kilo giraame deexxiis. ");
INSERT INTO wal_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Qoodan de7iya maabaraa asaappe beettida birai Xoossaa Dunkkaaniyan eriyo meezaanan wottin, 3,430 kilo giraame deexxiis. ");
INSERT INTO wal_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Asaa qoodiyo wode qoodettida attuma asai ubbai huuphiyan huuphiyan Xoossaa Dunkkaaniyan eriyo meezaanan wottin, usuppun giraame keenaa immiis. Qoodettida asai laatamu laitta kumidoogeenne laatamaappe bollaara de7iyaagee muleera 603,550. ");
INSERT INTO wal_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Xoossaa Dunkkaaniyaa magalashota essido xeetu gedeti 3,400 kilo giraame tigiyo biran oosettidosona. Hegeekka issi issi gediyaassi hasttamanne oiddu kilo giraame tigiyo bira. ");
INSERT INTO wal_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Attida hasttamu kilo giraame tigiyo biraa tuussatun kaqqiyoogeeta medhdhanau, tuussatu huuphiyan sheeshshanaunne eta huuphiyan qachchiyoogeeta medhdhanau go7ettidosona. ");
INSERT INTO wal_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Hegaadankka, asai GODAASSI ehiido nahaase biratai 2,425 kilo giraame. ");
INSERT INTO wal_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","He nahaasiyaa birataappe Xoossaa Dunkkaaniyaa geliyoosan eqqiya tuussatu gedeti, nahaasiyaa yarshshiyoosaa giyo yarshshiyoosai, a giddon hiixxido nahaase zazzareenne a giddon go7ettiyo dumma dumma miishsha ubbai merettiis. ");
INSERT INTO wal_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Hegaadankka, qassi dabaabaa yuushuwan de7iya dirssaanne geliyoosaa penggee eqqido gedeti, qassi Xoossaa Dunkkaaneenne a yuushuwan de7iya dabaabaa dirssai tolettido xisheti ubbai he nahaase birataappe merettidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Qeeseti Xoossaa Dunkkaaniyan oottiyo wode maayana maayuwaa, salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappe daddidosona. Aarooni maayiyo qeesetettaa maayuwaakka GODAI Muusa azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Qassi eti eefuudiyaa, worqqaappe, salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe daddidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Eti worqqaa qoxxidi, lee7iyan yeechchayidi, appe qaraari qaraaridi, qacina kessidosona. Yaatidi salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaanne liiqo liinuwaa gattidi, kushe hiillanchchati daddidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Naa77u baggai gaittidi issuwaa gidana mala, naa77u hashiyaa bolli gattidi oittiya carqqiyaa giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","GODAI Muusa azazidoogaadan, hiillai alleeqissidi daddido danccoikka eefuudiyaa mala gididi, worqqaappe salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe dadettiis. ");
INSERT INTO wal_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Eti maragidiyaa giyo naa77u shuchchata giigissidi, worqqaappe medhdhido shuchchaa oiqqiyaagaa bolli maaraara wottidosona. Maatafaa bolli sunttaa woocidi xaafiyoogaadan, he shuchchatu bolli Israa7eeliyaa naatu sunttaa woocidi xaafidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","GODAI Muusa azazidoogaadan, tammanne naa77u Israa7eela zareta hassayiyoobaa gidana mala, ha tammanne naa77u shuchchata eefuudiyaara oittido hashiyaa carqqiyan wottidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Eti tiran wottiyoogaa kushe hiillanchchan oottidosona. He tiran wottiyoogaa eefuudiyaa worqqaappe, daddidoogaadan, salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe daddidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ayyo oiddu zoozee de7ees; geesainne gomppai issi issi takkaaro; yaanidaagaa dakkoyidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Hegaappe guyyiyan a bolli oiddu maaran al77o shuchchata wottidosona; koiro maaran wottido shuchchai, sarddiyooniyaa, tophaaziyooniyaanne phooliya inqquwaa; ");
INSERT INTO wal_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","naa77antto maaran baluura, sampperiyaanne almmaaziyaa giyo al77o shuchchata; ");
INSERT INTO wal_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","heezzantto maaran yaakinttiyaa, kelqqedooniyaanne ametesxxinoosiyaa; ");
INSERT INTO wal_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","oiddantta maaran biralle, maragidiyaanne yasphphiidiyaa. Hegeeta ubbaa worqqaappe oosettida shuchchaa oiqqiyoogaa bolli wottidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Israa7eela naatu sunttaa qoodaadan, shuchchatu qoodaikka tammanne naa77a; issoi issoi maatafaadan woocettidi, tammanne naa77u zaretu sunttai he shuchchatun xaafettiis. ");
INSERT INTO wal_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Tiran wottiyoogaayyo wodorodan dooqettida sanssalataa walahi bainna worqqaappe medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Naa77u worqqaappe medhdhido shuchchaa oiqqiyaageeta oottidosona; yaatidi naa77u worqqa migidota medhdhidoogeeta, tiran wottiyoogaayyo qommo gaxa zoozetuura gattidi oisettidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","He naa77u worqqa sanssalatata tiran wottiyoogaayyo zoozetun de7iya migidotuura gatti oittidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","He sanssalatatuyyo hankko bagga xeeraa qassi eefuudiyaayyo sintta baggaara, hashiyaa carqqiyan de7iya shuchchaa oiqqiyoogeetuura gatti qachchidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Qassikka naa77u worqqa migidota medhdhidi, eefuudiyaappe kaallidi de7iya tiran wottiyoogaayyo so baggaara de7iya naa77u zoozetu xeeran aattidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hegaadankka, worqqaappe hara naa77u migidota medhdhidi, eefuudiyaayyo sintta baggaara, hashiyaa carqqiyaappe garssa baggaara eefuudiyaa xeessan qachchiyoogaappe qommoora, sihoi gaittosaa matan eta oittidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","GODAI Muusa azazidoogaadan, tiran wottiyoogan de7iya migidota eefuudiyan de7iya migidotuura gattidi, salo milatiya baqettan qachchidosona; qachchin tiran wottiyoogee xeessaappe qommoora de7iyo gishshau, qashoi dol77enna. ");
INSERT INTO wal_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Eefuudiyaappe bollaara maayiyo adussa maayuwaa eti muleera salo milatiya carqqiyaappe giigissidosona; hegee shimainne ooso. ");
INSERT INTO wal_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","He adussa maayuwaayyo qooriyaa aattiyoosaa medhdhidosona; he sohoi peerettennaadan, soo qalam77idi, yuushshi aattidi sikkidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Eti adussa maayuwaa duge bagga macaraa yuushuwan salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe roomaaniyaa teeraa misileta medhdhidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Eti qassi worqqaappe daalata medhdhidi, adussa maayuwau duge bagga gaxaa yuushshi aattidi, roomaane misiletu gidduwan, walahan aattidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Eti he maayuwaayyo duge bagga macaraa yuushshi aattidi, daalaanne roomaaniyaa teeraa misiliyaa walakkidi aattidosona. Hegee GODAI Muusa azazidoogaadan, eti Xoossaa Dunkkaaniyaa oosuwaa oottiiddi maayanaassa. ");
INSERT INTO wal_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","GODAI Muusa azazidoogaadan, eti Aaroonayyoonne a naatuyyo shimainnee daddido liiqo liinuwaappe qoleta giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Qassi huuphiyan xaaxiyo shaasheta, qophetanne garssaara maayiyo maayota liiqo liinuwaappe daddidi giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Hegaadankka, qassi eti salo milatiya, ochchaa teeraa milatiyaanne shololla zo7o qacinaappenne liiqo liinuwaappe daddidi, kushe hiillan alleeqissidi, danccuwaa giigissidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Eti akiliiliyaa misiliyaa walahi bainna worqqaappe medhdhidi, maatafaa bolli woociyoogaadan, a bolli, ‘GODAASSI GEESHSHA GIDIDI DUMMATIIS’ yaagiyaagaa woocidi xaafidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Hegaappe guyyiyan, huuphiyan shaashiyaa bolli kaqqanaadan, GODAI Muusa azazidoogaadan salo milatiya baqettaa an aattidi qachchidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Xoossaa Dunkkaaniyaa oosoi ubbai muleera polettiis. Israa7eelati ubbabaakka GODAI Muusa azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Hegaappe guyyiyan, eti Xoossaa Dunkkaaniyaa muleera ekkidi Muusekko ehiidosona; hegeekka: dunkkaaniyaanne a miishsha ubbaa, qapheta, xagaageta, hiraqota, tuussatanne eti eqqiyo gedeta, ");
INSERT INTO wal_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","bolla kamaassi dorssa orggiyaa calaa zo7o qalamiyan yeggi kessidoogaa, irppaniyaa, genttiyo magalashuwaa, ");
INSERT INTO wal_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Maachchaa Taabootaa, a tookkiyo kasotanne atto giyo sohuwaa qum77uwaa, ");
INSERT INTO wal_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","xaraphpheezaanne a miishshaa ubbaa GODAA sinttan wottiyo geeshsha oittaa, ");
INSERT INTO wal_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","walahi bainna worqqaappe oosettida xomppiyaa wottiyo ballaanne an maaran de7iya xomppeta, eta miishshata ubbaanne xomppiyaa zaitiyaa, ");
INSERT INTO wal_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ixaanaa cuwayiyo worqqa saaxiniyaa, tiyettiyo zaitiyaa, sawiya ixaanaa, Xoossaa Dunkkaaniyaa penggiyaa magalashuwaa, ");
INSERT INTO wal_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","nahaasiyaappe oottido yarshshiyoosaa, a nahaasiyaa zazzariyaara, a tookkiyo kasota, a miishshata ubbaa, meechcha keriyaanne a wottiyoogaa, ");
INSERT INTO wal_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","dabaabaa godaa gennttiyo magalashota, a tuussata, eti eqqiyo gedeta, dabaabaa geliyo penggetu magalashota, dabaabaa wodorotanne xisheta, Xoossaa Dunkkaaniyaayyo koshshiya miishshata ubbaa; ");
INSERT INTO wal_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","qeeseti Geeshsha sohuwan oottiiddi maayanau dadettida maayota, Aarooninne a naati qeesetettaa oottiiddi maayiyo maayota. ");
INSERT INTO wal_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Israa7eelati ooso ubbaakka GODAI Muusa azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Oottin Muusee oosuwaa xomoosi xeellidi, eti GODAI azazidoogaadan oottidoogaa be7iis. Hegaa gishshau, Muusee eta anjjiis. ");
INSERT INTO wal_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Hegaappe guyyiyan, GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Koiro aginaayyo koiro gallassi, neeni Xoossaa Dunkkaaniyaa tola. ");
INSERT INTO wal_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Maachchaa Taabootaa a giddon wotta; wottada he Taabootaa magalashuwan kamma. ");
INSERT INTO wal_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Xaraphpheezaa gelissada, a bolli wodhdhanau koshshiya miishshata ubbaa a bolli wotta. Yaatada xomppeta wottiyo ballaa soo gelissada, a bolli xomppeta wotta. ");
INSERT INTO wal_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ixaanaa cuwayiyo worqqa saaxiniyaa Maachchaa Taabootaa sinttaara wottada, Xoossaa Dunkkaaniyaa geliyo magalashuwaa kaqqa. ");
INSERT INTO wal_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Xuuggiyo yarshshuwaa yarshshiyoosaa Xoossaa Dunkkaaniyaa sinttaara wotta. ");
INSERT INTO wal_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Meechcha keriyaa Xoossaa Dunkkaaniyaappenne yarshshiyoosaappe gidduwan wottada, an haattaa tiga. ");
INSERT INTO wal_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Xoossaa Dunkkaaniyaappe kareera yuushsha aattada dabaabaa giigissa; giigissada dabaabaa geliyoosan magalashuwaa kaqqa. ");
INSERT INTO wal_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Tiyiyo zaitiyaa ekkada, Xoossaa Dunkkaaniyaanne a giddon de7iya ubbabaa tiya; anne a giddon go7ettiyo miishsha ubbaa dummaya; yaatobare i geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Hegaappe guyyiyan, xuuggiyo yarshshuwaa yarshshiyoosaanne au go7ettiyo miishsha ubbaa tiya; yarshshiyoosaa dummaya; yaatobare i ubbaappe aadhdhiya geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Meechcha keriyaanne a utissiyo miishshaa tiya; tiyada eta dummaya. ");
INSERT INTO wal_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Neeni Aaroonanne a naata Xoossaa Dunkkaaniyaa geliyo pengge ehaada, haattan eta meecca. ");
INSERT INTO wal_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Hegaappe guyyiyan, qeesetettaa maayuwaa Aaroona maizzada, i taayyo qeesetettan oottanaadan, a tiyada dummaya. ");
INSERT INTO wal_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","A attuma naatakka ehaada qoliyaa maizza. ");
INSERT INTO wal_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Eti taayyo qeesetettan oottanaadan, eta aawaa tiyidoogaadan, etakka tiya. Eta tiyettai etakka eta sintta yeletaa ubbaa qeese oottiyaagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Yaagin Muusee ubbabaakka GODAI bana azazidoogaadan oottiis. ");
INSERT INTO wal_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Hegaa gishshau, Gibxxeppe eti kiyido naa77antta laittan, koiro aginaayyo koiro gallassan Xoossaa Dunkkaanee tolettiis. ");
INSERT INTO wal_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Muusee Xoossaa Dunkkaaniyaa essiyo wode, gedeta eta sohuwan sohuwan wottiis; xagaagetanne tuussaa aattiis; hiraqotakka gelissiis. ");
INSERT INTO wal_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Hegaappe guyyiyan, Muusee GODAI azazidoogaadan, ha essidoogaa bollan dunkkaaniyaa toliis; he toliyaa bollan kamuwaa kammiis. ");
INSERT INTO wal_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Yaatidi tammu azazoti xaafettido masettida shuchchatu qaalaa efiidi, Taabootaa giddon wottiis; tookkiyo kasota Taabootan aattiis; atto giyo sohuwaa qum77uwaa Taabootaa bolli wottiis. ");
INSERT INTO wal_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Hegaappe guyyiyan, Taabootaa Xoossaa Dunkkaaniyaa gelissiis; genttiyo magalashuwaa kaqqidi, GODAI azazidoogaadan Maachchaa Taabootaa kammiis. ");
INSERT INTO wal_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","GODAI Muusa azazidoogaadan, Muusee xaraphpheezaa Xoossaa Dunkkaaniyaa gelissidi, magalashuwaappe kareera huuphessa baggaara wottiis. ");
INSERT INTO wal_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Wottidi a bolli GODAA sinttan wottiyo geeshsha oittaa giigissiis. ");
INSERT INTO wal_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","GODAI Muusa azazidoogaadan, xomppiyaa wottiyo ballaa Xoossaa Dunkkaaniyaa giddo gelissidi, xaraphpheezaa hefinttaara, Xoossaa Dunkkaaniyau tohossa baggaara wottiis; ");
INSERT INTO wal_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","qassi xomppeta GODAA sinttan oittiis. ");
INSERT INTO wal_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","GODAI azazidoogaadan, ixaanaa cuwayiyo worqqa saaxiniyaa Xoossaa Dunkkaaniyaa giddon magalashuwaa sintta baggaara wottiis; ");
INSERT INTO wal_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","wottidi a bolli sawiya ixaanaa cuwayiis. ");
INSERT INTO wal_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Hegaappe guyyiyan, Xoossaa Dunkkaaniyaa penggiyan magalashuwaa woxaliis. ");
INSERT INTO wal_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Xuuggiyo yarshshuwaa yarshshiyoosaa Xoossaa Dunkkaaniyaa geliyo penggiyaa lanqqen wottiis; a bolli xuuggiyo yarshshuwaanne katta yarshshuwaa GODAI azazidoogaadan yarshshiis. ");
INSERT INTO wal_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","GODAI Muusa azazidoogaadan, meechcha keriyaa Xoossaa Dunkkaaniyaappenne yarshshiyoosaappe gidduwan wottiis. Yaatidi meecettanau haattaa an tigiis. ");
INSERT INTO wal_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Tigin Muusee, Aarooninne a naati bantta kushiyaanne tohuwaa an meecettoosona. ");
INSERT INTO wal_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","GODAI Muusa azazidoogaadan, eti Xoossaa Dunkkaaniyaa gelido wode woikko yarshshiyoosaakko shiiqido wode audenne meecettoosona. ");
INSERT INTO wal_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Xoossaa Dunkkaaniyaanne yarshshiyoosaa yuushshi aattidi dabaabaa kessiis; he dabaabaa penggiyan magalashuwaa woxaliis. Hegaadan oottidi, Muusee oosuwaa poliis. ");
INSERT INTO wal_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Hegaappe guyyiyan, shaarai Xoossaa Dunkkaaniyaa kammiis; GODAA bonchchoikka a kumiis. ");
INSERT INTO wal_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","SHaarai Xoossaa Dunkkaaniyaa bolli uttido gishshaunne GODAA bonchchoi a giddon kumido gishshau, Muusee a giddo gelanau danddayibeenna. ");
INSERT INTO wal_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israa7eelati bantta oge ubban, he shaarai Xoossaa Dunkkaaniyaappe denddiyo wode audenne a kaallidi hemetaa doommoosona. ");
INSERT INTO wal_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","SHin he shaarai denddana xayikko, i denddiyo gallassai gakkanaassi etikka qaaxxokkona. ");
INSERT INTO wal_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Eta oge ubban GODAA shaarai Israa7eela asai ubbai be7ishin, gallassi gallassi Xoossaa Dunkkaaniyaa kammeesinne qammi qammi qassi tamai he shaaraa bolli eexxees. ");
INSERT INTO wal_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","GODAI Xoossai Xoossaa Dunkkaaniyaa giddoppe Muusa xeesidi, hagaadan yaagidi haasayiis; ");
INSERT INTO wal_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Israa7eela asaayyo hagaadan yaagada yoota; ‘Intteppe ooninne GODAAYYO yarshshuwaa shiishshiyo wode, he ba shiishshiyo yarshshuwaa ba mehiyaappenne ba dorssaa woikko deeshshaa wudiyaappe eho. ");
INSERT INTO wal_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","He yarshshoi mehiyaa wudiyaappe xuuggiyo yarshsho gidikko, attumaagaa gididi, tilla bollaara de7iyaagaa gido. GODAI ekkana mala, i he yarshshuwaa Xoossaa Dunkkaaniyaa geliyo penggen yarshsho. ");
INSERT INTO wal_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Yarshshuwaa shiishshiya bitanee xuuggidi yarshshanau ehiido ba mehiyaa huuphiyan ba kushiyaa wotto. Hegee a nagaraa atto gaanau GODAI ekkido yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","I korima mirgguwaa GODAA sinttan shukko; shukkin Aaroona naati qeeseti he suuttaa ekki ehiidi, Xoossaa Dunkkaaniyaa geliyo penggen de7iya yarshshiyoosaa miyyetu ubban caccafona. ");
INSERT INTO wal_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hegaappe guyyiyan, i xuuggiyo yarshshuwaassi mehiyaa galbbaa qaaro; qaaridi ashuwaa a qommuwan qommuwan kesso. ");
INSERT INTO wal_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Qeesiyaa Aaroona naati yarshshiyoosaa bollan tamaa eettidi, mittaa wottona. ");
INSERT INTO wal_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Hegaappe guyyiyan, Aaroona naati qeeseti he kessido ashuwaa bolli huuphiyaanne modhdhuwaa gujjidi, yarshshiyoosaa bollan taman de7iya mittaa bollan maaridi wottona. ");
INSERT INTO wal_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","SHin he bitanee qantta ashuwaanne guyye gedata haattan meecco. Yaatobare qeesee hegaa ubbaakka ehiidi, yarshshiyoosaa bolli xuuggo; hegee GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘Xuuggiyo yarshshuwaassi i immiyo imoi dorssaa wudiyaappe woikko deeshshaa wudiyaappe ekettiyaabaa gidikko, attumaagaa gididi, tilla bollaara de7iyaagaa gido. ");
INSERT INTO wal_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","He mehiyaa yarshshiyoosaappe huuphessa baggaara GODAA sinttan shukko. Aaroona naati qeeseti a suuttaa ekkidi, yarshshiyoosaa miyyetu ubbaa bollan caccafona. ");
INSERT INTO wal_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Hegaappe guyyiyan, he bitanee a qommuwan qommuwan kessido ashuwaa ubbaa qeesee ekkidi, huuphiyaanne modhdhuwaa an gujjidi, yarshshiyoosaa bollan taman de7iya mittaa bollan wotto. ");
INSERT INTO wal_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","SHin qanttaa ashuwaanne gedata haattan meecco; yaatobare qeesee hegaa ubbaa ehiidi yarshshiyoosaa bollan xuuggo; hegee GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘GODAASSI yarshshiyo xuuggiyo yarshshoi kafo gidikko, haraphphiyaa buuba, woikko mara haraphphiyaa eho. ");
INSERT INTO wal_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ehobare qeesee hegaa ekkidi, qooriyaa mucuraakko; yaatidi yarshshiyoosaa bollan de7iya taman xuuggo. A suuttai yarshshiyoosaa bollappe miyyiyaara duge goggo; ");
INSERT INTO wal_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ulo gidduwaa baalletuura kessidi, yarshshiyoosaappe arshsho baggaara, bidinttaa qoliyo sohuwan olo. ");
INSERT INTO wal_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","I he kafuwaa qefeta oiqqidi phalqqo, shin muleera daakkoppo. Hegaappe guyyiyan, qeesee yarshshiyoosaa bollan de7iya taman wottidi xuuggo; hegee GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“‘Ooninne kattaa yarshshuwaa GODAAYYO shiishshiyo wode, he yarshshoi liiqo xiille gido; a bolli wogaraa zaitiyaanne ixaanaa gujjo. ");
INSERT INTO wal_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Hegaa i Aaroona naatukko qeesetukko eho; ehin qeeseti he liiqo xiilliiyaappe issi kushiyaa kuntti ekkidi, zaitiyaanne ixaanaa wurssi ekkidi, hassayissiyaabaa oottidi, yarshshiyoosaa bolli taman xuuggo. Hegee GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kattaa yarshshuwaappe attidaagee Aaroonassanne a naatussa. Hegee GODAASSI taman xuuggido yarshsho ubbaappe aadhdhida geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“‘Yarshshuwaassi shiishshiyo oittai coociyan ka77idaagaa gidikko, zaitiyan munaqqido liiqo xiilliyaappe uukettida, irshshoi yegettibeenna komppo, woikko zaitiyan tiyido, irshshoi yegettibeenna lee7e lichchakko gido. ");
INSERT INTO wal_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“‘Yarshshuwaassi shiishshiyo oittai bashiyan uukettidaagaa gidikko, zaitiyan munaqqido, irshshoi bainna, liiqo xiilliyaappe giigidaagaa gido. ");
INSERT INTO wal_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","A menttidi a bolli zaitiyaa tigo; hegaa kattaa yarshsho oottidi shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“‘Ne yarshshuwaassi shiishshiyo oittai xiixxiyo disttiyan uuhettidaagaa gidikko, zaitiyan munaqqido liiqo xiilliyaappe uuhettidaagaa gido. ");
INSERT INTO wal_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Hagaadan giigissido kattaa yarshshuwaa GODAAYYO eha; ehaada qeesiyaayyo imma. Qeesee hegaa ekkidi yarshshiyoosaa shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Qeesee he kattaa yarshshuwaappe ekkidi, hassayissiyaabaa oottidi, yarshshiyoosaa bollan xuuggiyo yarshshodan taman xuuggo; hegee GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kattaa yarshshuwaappe attidaagee Aaroonassanne a naatussa. Hegee GODAASSI taman xuuggido, yarshsho ubbaappe aadhdhida geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“‘GODAAYYO intte ehiyo ai kattaa yarshshoinne irshshoora de7iyaabaa gidoppo; aissi giikko neeni irshsho woikko eessaa ililo GODAASSI taman xuuggada yarshshanau koshshenna. ");
INSERT INTO wal_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Intte laittan laittan cakettiya kattaappe xeera kessidi, GODAAYYO ehaanau danddayeeta; shin hegaa sawuwaa tonggu giya yarshsho oottidi, GODAAYYO yarshshiyoosaa bollan xuuggekketa. ");
INSERT INTO wal_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Neeni shiishshiyo kattaa yarshsho ubban maxiniyaa yegga; aissi giikko, maxinee neeni ne Xoossaara maacettido maachchaayyo malaata. Hegaa gishshau ne kattaa yarshshuwaa ubbaa maxiniyan mal77etta. ");
INSERT INTO wal_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Neeni koiro kattaappe xeeraa kessada GODAAYYO ehiyo wode, he kattai xiixxido tiya katta gidanau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","A bolli zaitiyaa tiga; ixaanaakka an wotta; hegee kattaa yarshshuwaa. ");
INSERT INTO wal_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Qeesee he zaitee tigettido kattaappe baggaa ekkidi, ixaana ubbaarakka hassayissiyaabaa oottidi taman GODAASSI xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“‘Issi asi issippetettaa yarshshuwaassi ba wudiyaappe macca gidin attuma gidin issi mehe shiishshiyo wode, he mehee tilla bollaara de7iyaagaa gido. ");
INSERT INTO wal_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yarshshanau ehiido mehiyaa huuphiyan ba kushiyaa wottidi, Xoossaa Dunkkaaniyaa penggen shukko. Hegaappe guyyiyan, qeeseti Aaroona naati suuttaa yarshshiyoosaa miyyetu ubbaa bollan caccafona. ");
INSERT INTO wal_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Issippetettaa yarshshuwaappe taman xuuggiyo yarshsho oottidi GODAAYYO shiishsho. Hegeekka qantta ashuwaa maayida handda ubbaa, ");
INSERT INTO wal_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","naa77u kilahota, eta bolli de7iya handdaanne tiriyaa bolli maayida handdaa kilahotaara gattidi ekkees. ");
INSERT INTO wal_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aaroona naati hegaa hara xuuggiyo yarshshuwaara yarshshiyoosaa bolli de7iya mittaa bolli wottidi xuuggona; hegee GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“‘GODAAYYO issippetettaa yarshshuwaa shiishshiya uri dorssa gidin deeshsha gidin, macca gidin attuma gidinkka tilla bollaara de7iyaagaa shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Dorssa maraa yarshshiya uri, GODAA sinttan shiishsho; ");
INSERT INTO wal_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","shiishshidi ba kushiyaa a huuphiyan wottidi, Dunkkaaniyaa sinttan shukko. Hegaappe guyyiyan, Aaroona naati suuttaa oiqqidi, yarshshiyoosaa miyyetu ubbaa bollan caccafona. ");
INSERT INTO wal_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Issippetettaa yarshshuwaappe taman xuuggiyo yarshsho oottidi, GODAAYYO shiishsho; hegeekka modhdhuwaa, giicciiriyaappe qanxxido nasiyaa, ulo giddo ashuwaa maayida handda ubbaa, ");
INSERT INTO wal_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","naa77u kilahota, eta bolli de7iya handdaanne tiriyaa bolli maayida handdaa kilahotaara gattidi ekkees. ");
INSERT INTO wal_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Qeesee hegaa GODAAYYO taman xuuggiyo yarshshiyoosaa bolli wottidi xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“‘A yarshshoi deeshsha gidikko, i hegaa GODAA sinttan shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Yaatidi a huuphiyan ba kushiyaa wottidi, Xoossaa Dunkkaaniyaa sinttan shukko. Hegaappe guyyiyan, Aaroona naati suuttaa oiqqidi, yarshshiyoosaa yuushuwan ubban caccafona. ");
INSERT INTO wal_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","I he yarshshiyoogaappe ekkidi, taman xuuggiyo yarshsho oottidi GODAAYYO shiishsho; hegeekka qantta ashuwaa maayida handda ubbaa, ");
INSERT INTO wal_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","naa77u kilahota, eta bolli de7iya handdaanne tiriyaa bolli maayida handdaa kilahotaara gattidi ekkees. ");
INSERT INTO wal_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Qeesee hegaa taman xuuggiyo, sawuwaa tonggu giya yarshsho oottidi yarshshiyoosaa bolli xuuggo. Handda ubbai GODAAGAA. ");
INSERT INTO wal_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“‘Handdaanne suuttaa intte de7iyoosan awaaninne mooppite. Hagee intteyyoonne intte yeletau merinau naagettiya woga’ yaagada oda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Neeni Israa7eela asaayyo hagaadan yaagada oda; ‘Ooninne halchchennan nagara oottikkonne, GODAA azazotuppe issuwaa augaanne kanttikko, hagaappe kaallidi de7iya wogaa naago. ");
INSERT INTO wal_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“‘Qeese halaqai nagaraa oottikkonne he nagarai asaa mooranchcha kessiyaagaa gidikko, i ba oottido nagaraa gishshau, tilla bollaara de7iya mirgguwaa GODAAYYO nagaraa yarshsho oottidi eho. ");
INSERT INTO wal_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ehiidi he mirgguwaa Xoossaa Dunkkaaniyaa pengge aattidi, mirgguwaa huuphiyan ba kushiyaa wottidi, GODAA sinttan shukko. ");
INSERT INTO wal_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","SHukkin qeese halaqai mirgguwaa suuttaappe amaridaagaa ekkidi, Xoossaa Dunkkaaniyaa efo. ");
INSERT INTO wal_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Efiidi ba kushiyaa biradhdhiyaa suuttan naaqqi naaqqi kessidi, Xoossaa Dunkkaaniyaa magalashuwaa sinttan GODAA sinttan laapputoo dukko. ");
INSERT INTO wal_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Hegaappe guyyiyan, qeese halaqai amarida suuttaa ekkidi, Xoossaa Dunkkaaniyaa giddon GODAA sinttan sawiya ixaanaa cuwayiyo saaxiniyaa bolli de7iya kacetu bolli xokisso. Attida suuttaa qassi Xoossaa Dunkkaaniyaa geliyoosaa baggaara de7iya xuuggiyo yarshshuwaa yarshshiyoosaappe garssa baggaara de7iya sohuwan gusso. ");
INSERT INTO wal_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Nagaraa yarshshuwaassi shukettida ha mirgguwaa modhdhuwaa ubbaa, qantta ashuwaa maayida handdaa, ");
INSERT INTO wal_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","naa77u kilahota, eta maayida handdaanne tiriyaa maayida handdaa kilahotuura issippe kessidi ekko. ");
INSERT INTO wal_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Issippetettaa yarshshuwau shuhettida mirgguwaappe ekkido modhdhuwaadan ekko. Ekkidi qeese halaqai xuuggiyo yarshshuwaa yarshshiyoosaa bollan xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","SHin mirgguwaa galbbaa, a ashuwaa ubbaa, a huuphiyaanne, a tohota, qantta ashuwaa, tociyaa, ");
INSERT INTO wal_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","mirgguwaa ashuwaappe attidaagaa ubbaa dunkkaanidosaappe kare kesso. Kessidi bidinttaa qoliyo wogaadan geeshsha gidida sohuwaa efo; efiidi yan mitta taman xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“‘Israa7eela maabarai ubbai halchchennan nagaraa oottikkonne, GODAA azazotuppe issuwaa augaanne kanttikko, eti mooranchcha gididi qoodettana. ");
INSERT INTO wal_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Eti oottido nagarai erettiyo wode, nagaraa yarshshuwaayyo haniya mirgguwaa Xoossaa Dunkkaaniyaa sintti ehoona. ");
INSERT INTO wal_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","He maabaraa cimati GODAA sinttan bantta kushiyaa mirgguwaa huuphiyan wottidi, he mirgguwaa shukkona. ");
INSERT INTO wal_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Hegaappe guyyiyan, qeese halaqai mirgguwaa suuttaappe guuttaa ekkidi, Xoossaa Dunkkaaniyaa giddo gelo; ");
INSERT INTO wal_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","i ba kushiyaa biradhdhiyaa suuttan naaqqi naaqqi kessidi, magalashuwaa sintta baggaara GODAA sinttan laapputoo dukko. ");
INSERT INTO wal_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Qassi amarida suuttaa ekkidi, Xoossaa Dunkkaaniyaa giddon GODAA sinttan ixaanaa cuwayiyo saaxiniyaa bolli de7iya kacetu bolli xokisso. Attida suuttaa qassi Xoossaa Dunkkaaniyaa geliyoosaa baggaara de7iya xuuggiyo yarshshuwaa yarshshiyoosaappe garssa baggaara de7iya sohuwan gusso. ");
INSERT INTO wal_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Modhdho ubbaa ekkidi, yarshshiyoosaa bollan xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Nagaraa yarshshossi shukettida mirgguwaa oottidoogaadan ha mirgguwaakka ootto. Hegaadan oottidi, qeesee nagaraa atto giissiyo wogaa polana; asaikka nagaraappe maarettana. ");
INSERT INTO wal_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hegaappe guyyiyan, mirgguwaa dunkkaanidosaappe kare kessidi, kase mirgguwaa xuuggidoogaadan akka xuuggo; hagee maabaraa nagaraassi yarshshiyo yarshsho. ");
INSERT INTO wal_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“‘Asaa kaalettiya sunttatuppe issoi halchchennan nagara oottikkonne GODAI Xoossai a azazido azazuwaappe issuwaa augaanne kanttikko, he uri mooranchcha. ");
INSERT INTO wal_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","I ba oottido nagaraa eridoogaappe guyyiyan, tilla bollaara de7iya issi deeshsha orggiyaa ekkidi eho. ");
INSERT INTO wal_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He deeshsha orggiyaa huuphiyan ba kushiyaa wotto; wottidi xuuggiyo yarshshoi GODAA sinttan shukettiyo sohuwan shukko; hegee nagaraa yarshshuwaa. ");
INSERT INTO wal_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Qeese halaqai nagaraa yarshshuwaa suuttaa giddo ba kushiyaa biradhdhiyaa naaqqi naaqqi kessidi, xuuggiyo yarshshuwaa yarshshiyoosaa bolli de7iya kacetu bolli xokisso; attida suuttaa qassi xuuggiyo yarshsho yarshshiyoosaappe garssa baggaara de7iya sohuwan gusso. ");
INSERT INTO wal_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Modhdho ubbaa issippetettaa yarshshuwaa modhdhuwaa yarshshiyoogaadan yarshshiyoosaa bollan yarshsho. Hagaadan oottidi, qeesee bitaniyaa nagaraa atto giissees; bitaneekka ba nagaraappe maarettana. ");
INSERT INTO wal_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“‘He maabaraa asaappe issoi halchchennan nagara oottikkonne GODAA azazuwaappe issuwaa augaanne kanttikko, he urai mooranchcha gididi qoodettees. ");
INSERT INTO wal_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","I ba oottido nagarai ayyo erettidoogaappe guyyiyan, tilla bollaara de7iya macca deeshshiyo ba nagaraassi eho. ");
INSERT INTO wal_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ehiidi ba kushiyaa nagaraa yarshsho oottidi shukkiyo deeshshee huuphiyan wotto; yaatidi xuuggiyo yarshshuwaa yarshshiyo sohuwan nagaraa yarshsho oottidi shukko. ");
INSERT INTO wal_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Hegaappe guyyiyan, qeese halaqai he deeshshee suuttaappe ba kushiyaa biradhdhiyan ekkidi, xuuggiyo yarshshuwaa yarshshiyoosaa bolli de7iya kacetu bolli xokisso; attida suuttaa ubbaa yarshshiyoosaappe garssa baggaara de7iya sohuwan gusso. ");
INSERT INTO wal_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Modhdho ubbaa issippetettaa yarshshuwaassi shukkido mehiyaappe kessiyoogaadan, he deeshshee modhdhuwaakka qoridi kesso; kessi ekkidi, yarshshiyoosaa bolli wottidi, GODAASSI sawuwaa tonggu giya yarshsho gidana mala xuuggo. Hegaadan oottidi, qeesee he bitaniyaa nagaraa atto giissees; bitaneekka ba nagaraappe maarettees. ");
INSERT INTO wal_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“‘He bitanee ba nagaraa yarshshuwaassi dorssa anqqaraa shiishshanau koyikko, tilla bollaara de7iya maccaaro eho. ");
INSERT INTO wal_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","I ba kushiyaa he dorssee huuphiyan wotto; wottidi xuuggiyo yarshshuwaassi shukkiyo mehee shukettiyo sohuwan o shukko. ");
INSERT INTO wal_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Hegaappe guyyiyan, qeesee nagaraa yarshsho gidida he dorssee suuttan ba biradhdhiyaa naaqqi naaqqi kessidi, xuuggiyo yarshshuwaa yarshshiyoosaa bolli de7iya kacetu bolli xokisso; attida suuttaa qassi yarshshiyoosaappe garssa baggaara de7iya sohuwan gusso. ");
INSERT INTO wal_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Issippetettaa yarshshuwaassi shukettida anqqaraa modhdhuwaa qaaridi kessiyoogaadan, he dorssee modhdhuwaakka qaaridi kesso. Kessi ekkidi, yarshshiyoosaa bolli GODAASSI taman xuuggiyo yarshshuwaa bolli wottidi xuuggo. Hagaadan oottidi, qeesee he bitaniyaa nagaraa atto giissees. Bitaneekka ba nagaraappe maarettana. ");
INSERT INTO wal_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“‘Ai asinne markkau xeesettidi ba be7idoogaa woikko ba eridoogaa gutaran markkattennan ixxikko, hegee ayyo nagara; hegaa gishshau i qaxxayetto. ");
INSERT INTO wal_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“‘Qassi ai asinne erennan de7iiddi tunabaa, do7aa bautaa woikko mehiyaa bautaa woikko sa7aara gooshettiya do7atu bautaa bochchikko, tuna gidiyoogaa i erido wodiyaappe doommidi mooranchcha gidiis. ");
INSERT INTO wal_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“‘Qassikka ai asinne erennan de7iiddi, asa bollappe goggiya tunissiyaabaa aiba gidinkka bochchikko, hegee tuna gidiyoogaa i erido wodiyaappe doommidi mooranchcha gidiis. ");
INSERT INTO wal_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“‘Woi qassi ai asinne iitabaa gidin lo77obaa oottanau eesuwan caaqqikkonne ba caaqqidoogaakka i akeekennan xayikko, i akeekido wodiyaappe doommidi mooranchcha gidiis. ");
INSERT INTO wal_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“‘Ai asinne ha odettida moorotuppe issuwaa oottidabaa gidikko, ba oottido nagaraa paaxo. ");
INSERT INTO wal_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","I ba oottido nagaraa gishshau GODAAYYO ba wudiyaa giddoppe macca dorssaa woikko macca deeshshaa nagaraa yarshsho oottidi shiishsho. SHiishshin qeesee ekkidi, he bitaniyaa nagaraa atto giissana. ");
INSERT INTO wal_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“‘Asi ba oottido nagaraayyo yarshshanau, dorssaa woikko deeshshaa anqqaraa shammanau ayyo miishshi gidana xayikko, naa77u haraphpheta buubata, woikko naa77u mara haraphpheta, issuwaa nagaraa yarshsho oottidi, qassi issuwaa xuuggiyo yarshsho oottidi GODAASSI eho. ");
INSERT INTO wal_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ehiidi i eta qeesiyaassi immo. Qeesee naa77u haraphphetuppe issinniyo qooriyaa muucennan coo mirqqidi, nagaraa yarshsho oottidi yarshsho. ");
INSERT INTO wal_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Yaatidi he nagaraa yarshshuwaa suuttaappe amaridaagaa ekkidi, yarshshiyoosaa miyyiyaa caccafo; attida suuttaa yarshshiyoosaappe garssa baggaara gusso; hegee nagaraa yarshshuwaa. ");
INSERT INTO wal_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hankko haraphphiyo qassi higgee azaziyoogaadan, xuuggiyo yarshsho oottidi xuuggo. Qeesee hegaadan oottidi, bitanee oottido nagaraa atto giissanau yarshshuwaa yarshshees; bitaneekka ba nagaraappe maarettana. ");
INSERT INTO wal_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“‘SHin issi urau naa77u wogga haraphpheta woikko naa77u mara haraphpheta ehaanau miishshi gidana xayikko, issi kilo giraame liiqo xiilliyaa ba nagaraassi shiishshiyo yarshsho oottidi eho. He xiillee nagaraa yarshsho gidiyo gishshau, wogaraa zaitee woikko ixaanai an gujettoppo. ");
INSERT INTO wal_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","I hegaa ehiidi qeesiyaassi immo; qeesee he xiilliyaappe issi kushiyaa kuntti ekkidi, GODAASSI shiishshiyo kattaa yarshshuwaara gattidi, hassayissiyaabaa oottidi yarshshiyoosan de7iya taman xuuggo; hegee nagaraa yarshshuwaa. ");
INSERT INTO wal_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ha geetettidaageetuppe augaaninne gido bitanee oottido nagaraassi qeesee hagaadan oottidi, bitanee oottido nagaraa atto giissees; bitaneekka ba nagaraappe maarettana. Kattaa yarshshuwaadankka attidaagaa qeesee ekko’ yaagada oda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","GODAI Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ooninne GODAAYYO geeshshi wottido miishshatu bolli ammanettennan xayikkonne qassi erennan nagaraa oottikko, ba naaquwaassi ba wudiyaa giddoppe tilla bollaara de7iya issi dorssa orggiyaa GODAASSI eho. A waagaikka Xoossaa Dunkkaaniyan eriyo meezaanan wottin eretto; hegee naaquwaa yarshshuwaa. ");
INSERT INTO wal_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","GODAASSI dummayi wottido miishshatu bolli i nagaraa oottido gishshau, i he miishshatu waagaa qanxxo; qanxxiiddi kase waagaa bolli xeetaappe laatamu kushiyaa gujjidi qeesiyaassi immo. Qeesee he naaquwaa yarshshuwaassi ehiido dorssaa yarshshidi, bitaniyaa nagaraa atto giissees; bitaneekka ba naaquwaappe maarettana. ");
INSERT INTO wal_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ai asinne erennan de7iiddi, GODAI, ‘Oottoppa’ giidi azazidobaappe issuwaa oottidi nagaran gelikko, i erana xayikkonne mooranchcha gidiyo gishshau, ba nagaran qaxxayetto. ");
INSERT INTO wal_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","I ba wudiyaappe tilla bollaara de7iya issi dorssa orggiyaa naaquwaa yarshshuwaassi qeesiyaakko eho. He dorssai naaquwau qanxxiyo waagaa kessiyaagaa gido; yaatobare qeesee he dorssaa yarshshidi, bitaniyaa naaquwaa atto giissees; bitaneekka ba naaquwaappe maarettees. ");
INSERT INTO wal_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hegee naaquwaa yarshshuwaa. I tumukka GODAA naaqqiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","GODAI Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ai asinne ba shooroi hadara wottidobaa woikko tal77idobaa kaadiyoogan, woikko asabaa bonqqiyoogan, woikko ba shooruwaa bollan sugettaa oottiyoogan GODAA naaqqikko, ");
INSERT INTO wal_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","woikko bayidabaa demmidi ta be7abeikke giidi wordduwan caaqqikkonne hageeta milatiya asi oottiyoobatuppe issuwaa, ");
INSERT INTO wal_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","i augaanne gido, oottidi, hegan nagaranchcha gidikko, ba bonqqi ekkidobaa, woikko wolqqan ekkidobaa, woikko hadara immidobaa woikko, bayin demmidobaa, ");
INSERT INTO wal_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","woikko wordduwan caaqqi ekkidobaa muliyaakka a godaassi zaaro. Qassi ba naaquwaa yarshshuwaa yarshshiyo gallassi ba ekkidoogaa bolli ichchashantto kushiyaa gujjidi a godaassi immo. ");
INSERT INTO wal_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Qassikka ba naaquwaa gishshau GODAASSI yarshshiyo yarshshuwau ba wudiyaa giddoppe tilla bollaara de7iya issi dorssa orggiyaa qeesiyaakko eho. He dorssai naaquwau qanxxiyo waagaa kessiyaagaa gido; yaatobare. ");
INSERT INTO wal_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Qeesee he dorssaa yarshshidi, bitaniyaa naaquwaa atto giissees; bitaneekka ba naaquwaa ubbaappe maarettana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","GODAI Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Aaroonanne a attuma naata hagaadan yaagada azaza; ‘Xuuggiyo yarshshuwaassi de7iya wogai hagaa: Xuuggiyo yarshshoi qammai wonttana gakkanaashin yarshshiyo sohuwan de7o. Tamaikka yarshshiyo sohuwan mule wode eexxiiddi de7o. ");
INSERT INTO wal_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Qeesee liinuwaappe dadettida qamisiyaanne suriyaa maayidi, xuuggiyo yarshshuwaa tamai mi simmin attida bidinttaa denttidi, yarshshiyo sohuwaa miyyiyan laalo. ");
INSERT INTO wal_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hegaappe guyyiyan, he maayuwaa qaari wotti hara maayuwaa maayidi, he bidinttaa dunkkaanidosaappe gaxi efiidi, higgiyaadan geeyida sohuwan qolo. ");
INSERT INTO wal_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yarshshiyoosaa bolli de7iya tamai to7ennan ubba wode eexxiiddi de7o. Qeesee maallado maallado mittaa an gujji gujjidi wotto. Xuuggiyo yarshshuwaakka he mittaa bolli maaran wottidi, issippetettaa yarshshuwaa handdaa a bolli xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Tamai yarshshiyoosaa bolli ubba wode eexxiiddi de7o; to7anau koshshenna. ");
INSERT INTO wal_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“‘Kattaa yarshshuwaassi imettida wogai hagaa: Aaroona zare gidiya qeeseti yarshshiyo sohuwaappe sintta baggaara GODAA sinttan yarshshona. ");
INSERT INTO wal_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Qeesee lo77o xiilliyaappe kophphiyaagaanne zaitiyaa ekkidi, kattaa yarshshuwaa bolli de7iya ixaana ubbaakka denttidi, GODAASSI sawuwaa tonggu giya yarshsho oottidi, hassayissiyaabaa gidanaadan yarshshiyoosaa bolli xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Hegaappe attidaagaa Aarooninne a attuma naati moona; hegaa eti irshshoi yegettibeenna oitta ootti uukkidi, Dunkkaaniyaa dabaabaa giddon de7iya geeshsha sohuwan moona. ");
INSERT INTO wal_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","He oittai irshshuwaa yeggennan uuketto. Hegaa taayyo taman xuuggiyo yarshshuwaappe eta gakkiyaagaa taani etayyo immaas. Nagaraa yarshshuwaadaaninne naaquwaa yarshshuwaadan ikka ubbaappe aadhdhida geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","GODAASSI taman xuuggiyo yarshshuwaappe eta gakkiyaagaa gidiyo gishshau, yiya laittatunkka Aaroona zare gidiya attumaageeti ubbai hegaa moona. He yarshshuwaa bochchiya ai asinne geeshsha gidana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","GODAI qassikka Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Aarooninne a attuma naati qeesetettaassi tiyettiyo gallassi issi kilo giraame gidiya lo77o xiilliyaa kattaa yarshsho oottidi GODAASSI ehoona. Hegaappe baggaa maallado baggaa omarssi yarshshona. ");
INSERT INTO wal_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","He xiillee zaitiyan munaqetti, lo77o walakettidi, bashiyan uuketto; uukkidoogaa bunchchada, sawuwaa tonggu giya kattaa yarshsho oottada GODAAYYO yarshsha. ");
INSERT INTO wal_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Qassi Aaroona attuma naatuppe a qeesetettaa laattanaadan tiyettiya ubbaikka he wogaa oottona. Hegee GODAASSI ubbatoo yarshshiyo yarshsho gididi muleera xuugetto. ");
INSERT INTO wal_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Qeesee shiishshiyo kattaa yarshshuwaappe guyye attennan wuri xuugetto; appe aibinne meetettoppo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","GODAI Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Aaroonassinne a attuma naatussi, hagaadan yaaga; ‘Nagaraa yarshshuwaa wogai hagaa: GODAAYYO xuuggiyo yarshshuwaassi shiishshiyo mehee shukettiyo sohuwan nagaraa yarshshuwaassi shiishshiyo meheekka hegan GODAA sinttan shuketto; ikka ubbaappe aadhdhida geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","He yarshshuwaa yarshshiya qeesee Dunkkaaniyaa dabaabaa giddon de7iya geeshsha sohuwan mo. ");
INSERT INTO wal_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","He ashuwaa bochchiya aibinne geeshsha gidana; qassi shukkishin ai maayuwaa bollinne suuttai xacettikko, he maayoi geeshsha sohuwan meecetto. ");
INSERT INTO wal_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ashoi doisettido urqqa miishshai meqqo; birata disttiyan doissidobaa gidikko, he disttiyaa qaacidi haattan shokkirgganau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Qeesetu zariyaappe attuma asa gidida ooninne he ashuwaa mo; he ashoi keehi geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Gido shin Geeshsha Sohuwan nagaraa atto giissanau a suuttaa ekkidi, Dunkkaaniyaa giddo gelissido ai mehiyaa ashuwaanne maanau koshshenna; i taman xuugettanau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“‘Naaquwaa yarshshuwaa wogai hagaa: ikka ubbaappe aadhdhida geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Xuuggiyo yarshshuwaassi shiishshiyo mehiyaa shukkiyo sohuwan naaquwaa yarshshuwaa mehiyaakka shukkona; a suuttaakka yarshshiyoosaa miyyetun caccafona. ");
INSERT INTO wal_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Qassi a handdaa ubbaa, hegeekka nasiyaa handdaa, qantta ashuwaa maayida handdaa, ");
INSERT INTO wal_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","naa77u kilahota, shinccaa matan de7iya eta maayida handdaanne tiriyaa maayida handdaa kilahotuura issippe yarshsho oottidi shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Taman xuuggidi GODAAYYO yarshshiyo yarshshuwaadan, he shiiqida handdaa qeesee yarshshiyoosaa bollan wottidi xuuggo; hegee naaquwaa yarshshuwaa. ");
INSERT INTO wal_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Qeese zare gidida attuma asi ubbi he yarshshuwaa ashuwaa mo. He yarshshoi ubbaappe aadhdhida geeshsha gidiyo gishshau, geeshsha sohuwan mo. ");
INSERT INTO wal_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“‘Naaquwaa yarshshoi nagaraa yarshshuwaakka mala; eta naa77aa wogai issuwaa. Hegeenne yarshshettida mehiyaa ashoi nagaraa atto giissanau yarshshuwaa yarshshida qeesiyaassi imettees. ");
INSERT INTO wal_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ooninne xuuggiyo yarshshuwaa ehin ekkidi yarshshiya qeesee he mehiyaa galbbaa baayyo ekko. ");
INSERT INTO wal_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Coociyan komppettida kattaa yarshsho ubbainne oton doisettida woikko bashen uukettida ubbaikka he yarshshuwaa yarshshida qeesiyaassi imettees. ");
INSERT INTO wal_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Qassi zaitiyan munaqettida woikko munaqettibeenna kattaa yarshsho ubbai Aaroona naatu ubbaassi imettees; eti hegaa hircciyan shaakki ekkona. ");
INSERT INTO wal_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“‘Asi issippetettaa yarshshuwaa GODAASSI yarshshiyo wode ayyo de7iya wogai hagaa: ");
INSERT INTO wal_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","I shiishshiyo issippetettaa yarshshoi galata yarshsho gidikko, he yarshshuwaara issippe zaitiyan munaqqido, irshsho yeggennan uukkido oittaa, zaitiyan tiyido, irshshoi gelibeenna lee7e lichchakkuwaanne zaitiyan loitti munaqqido, liiqo xiilliyaappe uukettida komppuwaa shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","He galataayyo shiishshiyo issippetettaa yarshshuwaara issippe irshshuwaa yeggido munaqaappe uukettida oittaakka imota oottidi shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Qassi he ubba qommo oittatuppekka i issuwaa issuwaa denttidi, GODAASSI yarshsho oottidi eho. Hegee issippetettaa yarshshuwaa suuttaa caccafida qeesiyaassi imetto. ");
INSERT INTO wal_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","He mehiyaa ashoi he yarshshettido gallassi meetetto; maalladossi aibinne attoppo. ");
INSERT INTO wal_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“‘SHin a yarshshoi shiiquwaa gattiyoogaa woikko ba dosan coo immiyo issippetettaa yarshsho gidikko, he yarshshuwaa ashoi he yarshshido gallassi meetetto; appe attiyaagee qassi wonttetta gallassikka meetetto. ");
INSERT INTO wal_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","He yarshshuwaa ashuwaappe palahidi heezzantto gallassa gakkanaashin gam77iyaagee de7ikko, hegee taman xuugetto. ");
INSERT INTO wal_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Issi asi shiishshido issippetettaa yarshshuwaa ashuwaappe augeenne heezzantto gallassi meetettikko, a yarshshoi ekettenna; i yarshshidobaadankka qoodettenna. He yarshshoi tuna; appe miida ooninne ba nagaran oishettees. ");
INSERT INTO wal_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“‘Tunabaa aibanne bochchida ashoi meetettoppo; i taman xuugettanau koshshees. Hara ashuwaa gidikko, wogan geeshsha gidiya asi ooninne maana giikko mo. ");
INSERT INTO wal_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","SHin issi asi tuna gidi uttidi, GODAAYYO shiishshido issippetettaa yarshshuwaa ashuwaappe miyaabaa gidikko, he asi ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Qassi issi asi tunabaa aibanne bochchikko asaa tunatettaa gidin woikko tuna mehe gidin, woikko hara sheneyiya tunabaa bochchikkonne simmidi GODAAYYO yarshshido issippetettaa yarshshuwaa ashuwaappe miikko, he urai ba asaa giddoppe bohetto’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","GODAI Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Israa7eela asaassi hagaadan yaaga; ‘Korima woikko dorssa woikko deeshsha ashuwan modhdho zawaa mulekka mooppite. ");
INSERT INTO wal_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Haiqqida mehiyaa woikko do7i worido mehiyaa modhdhuwaakka harabau go7ettiteppe attin, appe aibanne mooppite. ");
INSERT INTO wal_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Aissi giikko, GODAAYYO taman xuuggiyo yarshshuwaassi shiishshiyo mehiyaa modhdhuwaa miya ooninne ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Intte de7iyo sohuwan awan gidikkokka, kafo suuttaa, mehe suuttaa woikko harabaa aiba suuttaanne mooppite. ");
INSERT INTO wal_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Suutta miya ai asinne, ba asaa giddoppe bohetto’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","GODAI Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Israa7eela asaassi hagaadan yaaga; ‘GODAAYYO issippetettaa yarshshuwaa shiishshiya ai asinne he issippetettaa yarshshuwaappe shaakkidi, ba huuphe imotaa dummayidi GODAAYYO shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Hegaa i GODAAYYO taman xuuggiyo yarshsho oottidi, ba kushiyan ekkidi eho; qassi modhdhuwaakka anggaasuwaara eho; ehiidi, anggaasuwaa wuxaawuxiyo yarshsho oottidi, GODAA sinttan wuxaawuxo. ");
INSERT INTO wal_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Qeesee yarshshiyoosaa bollan modhdhuwaa xuuggo; shin anggaasoi Aaroonassinne a attuma naatussi imetto. ");
INSERT INTO wal_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Intte issippetettaa yarshshuwaappe ushachcha gedaa imota oottidi qeesiyaassi immite. ");
INSERT INTO wal_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Hegee ushachcha gedai Aaroona attuma naatuppe issippetettaa yarshshuwaa suuttaanne modhdhuwaa yarshshiyaagaassi a gakkiya a qommuwaa. ");
INSERT INTO wal_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Taani Israa7eela asaa issippetettaa yarshshuwaappe wuxaawuxido anggaasuwaanne yarshshuwau shiishshido gedaa ekkada, qeesiyaa Aaroonassinne a attuma naatussi immaas; hegee eta gakkiya eta qommo gidiyo gishshau, Israa7eela asai merinau hegaa etau immiiddi daana’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aarooninne a attuma naati qeese gididi, GODAAYYO oottanau sunttettido gallassi GODAASSI shiishshido taman xuuggiyo yarshshuwaappe hegee etayyo qommo gididi imettiis. ");
INSERT INTO wal_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","GODAI eta qeesetettaassi tiyido gallassi, hegaa etayyo immana mala, Israa7eela asaa ubbaa azaziis; sintta yeletan ubbankka hagee woga gididi oosettees. ");
INSERT INTO wal_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Simmi hageeti, xuuggiyo yarshshuwaassi, kattaa yarshshuwaassi, nagaraa yarshshuwaassi, naaquwaa yarshshuwaassi, qeesetettaassi tiyettiyo wode yarshshiyo yarshshuwaassinne issippetettaa yarshshuwaassi imettida wogata. ");
INSERT INTO wal_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ha wogati Israa7eela asai Siinaa bazzuwan bantta yarshshuwaa GODAASSI yarshshana mala GODAI azazido gallassi, Siinaa Deriyaa bollan GODAI Muusa azazido wogata. ");
INSERT INTO wal_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","GODAI Muusessi hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Aaroonanne a attuma naata qassi etaara issippe, qeesetettaa maayuwaa, tiyiyo zaitiyaa, nagaraa yarshshuwaassi shukkiyo korimaa, naa77u dorssa orggetanne, irshshuwaa yeggennan uukkido, oittaa masooben ekkada ya. ");
INSERT INTO wal_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Qassi Israa7eela asa ubbaakka xeegada, Dunkkaaniyaa kare shiishsha” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Yaagin Muusee GODAI azazidoogaadan oottiis; asaikka ubbai Dunkkaaniyaa karen shiiqiis. ");
INSERT INTO wal_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","SHiiqin Muusee asaassi, “Oottana mala GODAI azazidoogee hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Muusee Aaroonanne a attuma naata ehiidi, haattan meecciis. ");
INSERT INTO wal_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Meeccidi Aaroona qoliyaa maizziis; danccuwaakka danccissiis. Qassi adussa qoliyaa maizzidi, a bollan eefuudiyaa maizziis. Eefuudiyaa hiillatidi daddido qabattuwan Aaroonaara gattidi qachchiis. ");
INSERT INTO wal_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Qassi tiran wottiyoogaa Aaroona bollan aattidi, a giddon Uriimiyaanne Tumiimiyaa wottiis. ");
INSERT INTO wal_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Qassikka Aaroona huuphiyan shaashiyaa enccurssaa wottiis. GODAI Muusa azazidoogaadan he enccurssaa bollan sintta baggaara worqqa madaaliyaa, worqqaappe medhdhido akiliiliyaa misiliyaa wottiis. ");
INSERT INTO wal_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Yaatoogaappe guyyiyan Muusee tiyiyo zaitiyaa ekkidi, Dunkkaaniyaanne Dunkkaaniyaa giddon de7iya miishsha ubbaa tiyiis; tiyidi eta dummayiis. ");
INSERT INTO wal_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Qassi he zaitiyaappe ekkidi, yarshshiyoosaa bolli laapputoo caccafiis; yarshshiyoosaa, a miishshata, meechcha keriyaanne a wottiyoogaa, dummayanau he zaitiyan tiyiis. ");
INSERT INTO wal_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Qassi he tiyiyo zaitiyaappe amaraa Aaroona huuphiyan tigidi, a dummayiis. ");
INSERT INTO wal_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","GODAI Muusa azazidoogaadan, Muusee Aaroona attuma naata sinttau aattidi, qoliyaa maizziis; maizzidi danccuwan danccissiis. Eta huuphiyankka shaashiyaa enccurssaa wottiis. ");
INSERT INTO wal_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Hegaappe guyyiyan, nagaraa yarshshuwaassi korimaa Muusee aattiis; aattin Aarooninne a attuma naati he korimaa huuphiyan bantta kushiyaa wottidosona. ");
INSERT INTO wal_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Muusee he korimaa shukkiis; shukkidi a suuttaappe ba biradhdhiyan ekkidi, yarshshiyoosaa kaceta tiyidi, yarshshiyoosaa geeshshiis; qassi yarshshiyoosaa nagaraa atto giissanau attida suuttaa appe garssaara gussidi, Xoossaassi dummayiis. ");
INSERT INTO wal_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Qantta ashuwaa kammida handdaa ubbaa, tiriyaa maayida handdaa, naa77u kilahotanne eta kammida handdaa ekkidi, Muusee yarshshiyoosaa bollan wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","SHin GODAI Muusa azazidoogaadan, galbbaa, korimaappe attidaagaanne tociyaa dunkkaanidosaappe gaxi kessidi, taman xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Yaatidi simmidi Muusee xuuggiyo yarshshuwaassi haniya dorssa orggiyaa ehiis; ehin Aarooninne a attuma naati he dorssaa orggiyaa huuphiyan bantta kushiyaa wottidosona. ");
INSERT INTO wal_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Muusee he dorssa orggiyaa shukkiis; shukkidi a suuttaa yarshshiyoosaa miyyetu ubban caccafiis. ");
INSERT INTO wal_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Qassi dorssa orggiyaa ashuwaakka a qommuwan qommuwan pariis; paridi parettaa, huuphiyaanne handdaa yarshshiyoosaa bolli wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Qantta ashuwaanne guyye gedata haattan meeccoogaappe guyyiyan, dorssaa muleera GODAASSI taman xuuggiyo, sawuwaa tonggu giya yarshsho oottidi, GODAI Muusa azazidoogaadan yarshshiyoosaa bollan wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Hegaappe guyyiyan, qeesetettaassi tiyettiyo wode shiishshiyo naa77antto dorssaa Muusee ehiis; ehin Aarooninne a attuma naati he dorssaa huuphiyan bantta kushiyaa wottidosona. ");
INSERT INTO wal_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Muusee he dorssaa shukkiis; shukkidi a suuttaappe ekkidi, Aaroonassi ushachcha haittaa xeeraa, ushachcha kushiyaa wogga biradhdhiyaanne, ushachcha tohuwaa wogga biradhdhiyaa tiyiis. ");
INSERT INTO wal_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Qassi Muusee Aaroona attuma naatakka sinttau ehiidi, he suuttaappe ekkidi, eta ushachcha haittaa xeeraa, eta ushachcha kushiyaa wogga biradhdhiyaanne eta ushachcha tohuwaa wogga biradhdhiyaa tiyiis. Hegaappe guyyiyan, Muusee attida suuttaa yarshshiyoosaa miyyetu ubban caccafiis. ");
INSERT INTO wal_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Yaatidi modhdhuwaa, nasiyaa, qantta ashuwaa maayida handdaa, tiriyaa maayida handdaa, naa77u kilahotanne eta maayida handdaanne ushachcha gedaa ekkiis. ");
INSERT INTO wal_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Qassi irshshuwaa yeggennan uukkido oittaa wottiyo GODAA sinttan de7iya masoofiyaappe issi komppuwaa, zaitiyaara uukkido issi oittaanne issi lee7e lichchakkuwaa ekkidi, hageeta modhdhuwaa bollaaninne ushachcha gedaa bollan wottiis. ");
INSERT INTO wal_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","I ha qumaa ubbaa Aaroona kushiyaaninne a attuma naatu kushiyan wottiis; wottin eti GODAA sinttan wuxaawuxiyo yarshsho oottidi wuxaawuxidosona. ");
INSERT INTO wal_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Hegaappe guyyiyan, Muusee he qumaa eta kushiyaappe ekki, xuuggiyo yarshshuwaara gattidi, qeesetettaassi tiyettiyo wode GODAASSI taman xuuggidi shiishshiyo, sawuwaa tonggu giya yarshshuwaadan, yarshshiyoosaa bollan wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Qassi Muusee anggaasuwaa ekkidi, wuxaawuxiyo yarshsho oottidi GODAA sinttan wuxaawuxiis; GODAI Muusa azazidoogaadan, qeesetettaassi tiyettiyo wode yarshshiyo dorssa orggiyaa ashuwaappe hegee Muusa gakkiya a qommuwaa. ");
INSERT INTO wal_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Muusee tiyiyo zaitiyaappenne yarshshiyoosaa bollan de7iya suuttaappe ekkidi, Aaroona bollinne a maayuwaa bolli, qassi a attuma naatu bollinne, eta maayuwaa bollikka caccafiis; yaatidi Aaroonanne a maayuwaa qassi a naatanne a naatu maayuwaakka dummayiis. ");
INSERT INTO wal_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Muusee Aaroonanne a attuma naata hagaadan yaagiis; “Ashuwaa Dunkkaaniyaa karen doissite; doissidi, ‘Aarooninne a naati hegaa moona’ yaagada taani azazidoogaadan, qeesetettaassi tiyettiyo wode shiishshiyo yarshshuwaa wottiyo masoofiyaa giddon de7iya yarshsho oittaara hegan miite. ");
INSERT INTO wal_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","He ashuwaappenne oittaappe palahidaagee de7ikko taman xuuggite. ");
INSERT INTO wal_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Qeesetettaassi tiyiyo wogai laappun gallassaa ekkiyo gishshau, he intte qeesetettaassi tiyettiyo laappun gallassai wuranaashin, Dunkkaaniyaa penggeppe kare kiyoppite. ");
INSERT INTO wal_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ha hachchi oosettidaagee GODAI azazin, intte nagaraa atto giissanau oosettiis. ");
INSERT INTO wal_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dunkkaaniyaa penggen laappun gallassa kumettaa gallassinne qamminne takkite; GODAA wogaakka naagite; ixxikko intte haiqqana. Tana GODAI azazidoogee hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Yaagin Aarooninne a naati GODAI Muuse baggaara azazidobaa ubbaa oottidosona. ");
INSERT INTO wal_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Hosppuntta gallassan Muusee Aaroonanne a naata, qassi Israa7eela cimatakka xeesiis. ");
INSERT INTO wal_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Xeesidi Aaroona hagaadan yaagiis; “Nagaraa yarshshuwaassi issi korimaa, qassi xuuggiyo yarshshuwaassi issi dorssa orggiyaa GODAA sintti shiishsha. Meheti naa77aikka tilla bollaara de7iyaageeta gidona. ");
INSERT INTO wal_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","4","Qassi Israa7eela asaa hagaadan yaaga; ‘GODAI hachchi intteyyo qoncciyo gishshau, a sinttan yarshshanau, nagaraa yarshshuwaassi issi deeshsha orggiyaa, xuuggiyo yarshshuwaassi tilla bollaara de7iya issi laitta maraanne issi laitta dorssaa, issippetettaa yarshshuwaassi issi korima mirgguwaa, issi dorssa orggiyaanne zaitiyan munaqettida kattaa yarshshuwaa ehiite’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Eti Muusee azazidobaa ubbaa Xoossaa Dunkkaaniyaa sintti ehiidosona; yaatidi maabara ubbai shiiqidi, GODAA sinttan eqqidosona. ");
INSERT INTO wal_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Muusee eta, “GODAA bonchchoi intteyyo qonccana mala, intte oottanaadan GODAI inttena azazidoogee hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Qassi Muusee Aaroonakka hagaadan yaagiis; “Yarshshiyoosaakko haa shiiqa; shiiqada ne nagaraa yarshshuwaanne ne xuuggiyo yarshshuwaa yarshsha; yaatada ne huuphe nagaraanne ne asaa nagaraakka atto giissa. Qassi GODAI azazidoogaadan, asai shiishshiyo yarshshuwaa yarshshada, eta nagaraakka atto giissa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Yaagin Aarooni yarshshiyoosaakko yiidi, ba huuphe nagaraassi yarshsho ootti shiishshido korimaa shukkiis. ");
INSERT INTO wal_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","SHukkin Aaroona naati suuttaa ekkidi ayyo ehiidosona; i ba kushiyaa biradhdhiyaa he suuttan yeddi kessidi, yarshshiyoosaa kaceta bochchiis; attida suuttaakka yarshshiyoosaappe garssa baggaara gussiis. ");
INSERT INTO wal_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","GODAI Muusa azazidoogaadan, qassi he nagaraa yarshshuwaa ashuwaappe modhdhuwaa kilahotanne tiriyaa maayida handdaa yarshshiyoosaa bollan wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","SHin attida ashuwaanne galbbaa dunkkaanidosaappe kare kessidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Hegaappe guyyiyan, Aarooni xuuggiyo yarshshuwaa shukkiis; shukkin a naati suuttaa ekkidi ayyo ehiidosona; ehin i yarshshiyoosaa miyyetu ubbaa caccafiis. ");
INSERT INTO wal_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Qassi eti xuuggiyo yarshshuwaa qommuwan qommuwan kessidi, huuphiyaarakka ayyo ehiidosona; ehin i yarshshiyoosaa bollan wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Qantta ashuwaanne tohotakka haattan meeccidi, yarshshiyoosaa bollan de7iya xuuggiyo yarshshuwaa bollan wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hegaappe guyyiyan, Aarooni asai ehiido yarshshuwaa shiishshiis; i asaa nagaraa yarshshuwaassi gidiya deeshsha orggiyaa ekkidi shukkiis; shukkidi kase baagaadankka eta nagaraassi yarshshiis. ");
INSERT INTO wal_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Qassi i xuuggiyo yarshshuwaa mehiyaa ehiidi, wogai azaziyoogaadan oottidi yarshshiis. ");
INSERT INTO wal_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Kattaa yarshshuwaakka shiishshiis; appe issi zolle gidiyaagaa ekkidi, maallado maallado xuuggiyo yarshshuwaappe haraa yarshshiyoosaa bollan wottidi xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aarooni qassikka asaa issippetettaa yarshshuwaassi korimaanne dorssa orggiyaa shukkiis; shukkin a attuma naati suuttaa ayyo ehiidosona; ehin i he suuttaa ekkidi, yarshshiyoosaa miyyetu ubbaa caccafiis. ");
INSERT INTO wal_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Qassi korimaanne dorssa orggiyaa ashuwaappe modhdhuwaa, nasiyaa, qantta ashuwaa maayida handdaa, kilahotanne tiriyaa maayida handdaa Aaroona naati ayyo ehiidosona. ");
INSERT INTO wal_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Eti he handdaa anggaasuwaa bolli bollaara wottin, Aarooni yarshshiyoosaa bollan hegaa xuuggiis. ");
INSERT INTO wal_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","SHin GODAI Muusa azazidoogaadan, Aarooni anggaasotanne ushachcha gedaa wuxaawuxiyo yarshsho oottidi, GODAA sinttan wuxaawuxiis. ");
INSERT INTO wal_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Hegaappe guyyiyan, Aarooni ba kushiyaa asaakko zaari denttidi eta anjjiis. I nagaraa yarshshuwaa, xuuggiyo yarshshuwaanne issippetettaa yarshshuwaa yarshshoogaappe guyyiyan, yarshshiyoosaappe duge wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Wodhdhin Muuseenne Aarooni Xoossaa Dunkkaaniyaa giddo gelidosona; eti hegaappe kiyido wode, asaa anjjidosona. Yaatin GODAA bonchchoi asa ubbaassi beettiis. ");
INSERT INTO wal_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","GODAA sinttappe tamai wodhdhidi, yarshshiyoosaa bollan de7iya xuuggiyo yarshshuwaanne modhdhuwaa miis. Asai ubbai hegaa be7ido wode ililiis; qassi eti bantta som77uwan sa7aa bochchidi gufannidosona. ");
INSERT INTO wal_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaroona attuma naati, Naadaabinne Abiihu, bantta ixaanaa cuwayiyo miishshaa miishshaa ekkidi, a bollan tamaa wottidosona; wottidi tamaa bolli qassi ixaanaa qolidosona; yaatidi, GODAI eta azazibeenna, geeshsha gidenna tamaa GODAA sinttan shiishshidosona. ");
INSERT INTO wal_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Hegaa gaasuwan GODAA matappe tamai yiidi, eta mi aggiis; etikka GODAA sinttan haiqqi aggidosona. ");
INSERT INTO wal_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Hegaappe guyyiyan, Muusee Aaroona, “GODAI, ‘Taani ta mati shiiqiyaageeta ta geeshshatettaa bessana. Qassi asa ubbaa sinttan taani bonchchettana’ giidi haasayidoogee be7a hagaa” yaagiis. Yaagin Aarooni co77u giis. ");
INSERT INTO wal_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Muusee Aaroona aawaa ishaa Uzzi7eela attuma naata, Mishaa7eelanne Elxxaafaana xeegidi, “Haa yiite; yiidi intte aawaa ishaa naatu ahaa Xoossaa Dunkkaaniyaa sinttappe denttidi, dunkkaanidosaappe gaxi kessite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Hegaa gishshau eti yiidi, Muusee azazidoogaadan, eta qeesetettaa maayuwaara eta ahaa tookkidi, dunkkaanidosaappe gaxi kessidosona. ");
INSERT INTO wal_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Hegaappe guyyiyan, Muusee Aaroonanne a attuma naata, El77aazaranne Itaamaara hagaadan yaagiis; “Intte haiqqenna malanne, GODAI maabara ubbaa bollan hanqqettenna mala, intte huuphiyaa meedissoppite; intte maayuwaakka pooshshoppite. SHin intte ishati, Israa7eela asati, GODAI ba eettido taman xuuggidoogeetussi yeekkana giikko eti yeekkona. ");
INSERT INTO wal_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Qassikka intte Dunkkaaniyaa penggeppe kare kiyoppite; kiyikko intte haiqqana; aissi giikko GODAI tiyiyo zaitee intte bollan de7ees” yaagiis. Yaagin etikka Muusee giidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","GODAI Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Intte haiqqenna mala, Dunkkaaniyaa giddo geliyo wode, neenikka ne naatikka woine eessaa woikko hara mattoyiya ushsha uyoppite; hegee sinttappe yaana yeletaassikka merinau higge gididi de7ana. ");
INSERT INTO wal_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Intte geeshshabaanne geeshsha gidennabaa qassi tunabaanne tuna gidennabaa shaakkidi erite. ");
INSERT INTO wal_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","GODAI Muuse baggaara yootido woga ubbaakka Israa7eela asaa tamaarissite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Muusee Aaroonanne attida a attuma naata El77aazaranne Itaamaara hagaadan yaagiis; “GODAASSI taman xuuggiyo yarshshuwaappe attida kattaa yarshshuwaa ekkite; ekkidi irshsho yeggennan uukkite; yaatidi i keehippe geeshsha gidiyo gishshau, yarshshiyoosaa matan a miite. ");
INSERT INTO wal_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","GODAASSI taman xuuggiyo yarshshuwaappe hegee nenanne ne attuma naata gakkiya intte qommuwaa gidiyo gishshau, hegaa intte geeshsha sohuwan miite; aissi giikko, GODAI tana hegaadan oottana mala azaziis. ");
INSERT INTO wal_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","SHin wuxaawuxettida anggaasuwaanne shiiqida gedaa neeni, ne attuma naatinne ne macca naati geeshsha sohuwan miite. Aissi giikko, hegee Israa7eela asai shiishshiyo issippetettaa yarshshuwaappe nenanne ne attuma naata gakkiya intte qommuwaa. ");
INSERT INTO wal_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","GODAASSI yarshshido gedaanne wuxaawuxido anggaasuwaa asai taman xuuggiyo modhdhuwaara issippe gattidi, GODAA sinttan wuxaawuxiyo yarshshodan wuxaawuxanau ehaana. GODAI azazidoogaadan, hegee neessinne nenaara de7iya ne attuma naatussi merinau inttena gakkiya intte qommo gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Muusee nagaraa yarshuwaa deeshshai waanidaakko eranau koyidi oichchiis; oichchidi i xuugettiichchidoogaa erido wode, attida Aaroona attuma naata, El77aazaranne Itaamaara hanqqettiis; hanqqettidi eta, ");
INSERT INTO wal_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Nagaraa yarshshoi keehippe geeshsha; qassi hegeekka asaa nagaraa GODAA sinttan atto giissana mala intteyyo imettiis; yaatin intte a geeshsha sohuwan aissi mibeekketii? ");
INSERT INTO wal_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","He mehiyaa suuttai Xoossaa Dunkkaaniyaa giddo gelibeennaagaa gidishin, taani inttena azazidoogaadan, intte a he geeshsha sohuwan maanau bessees; shin aggideta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Yaagin Aarooni Muusa, “Be7a; asati hachchi bantta nagaraa yarshshuwaanne xuuggiyo yarshshuwaa GODAA sintti ehiidosona; gidikkonne qassi hagaa malabai ta bolli gakkiis. Yaatin woni taani nagaraa yarshshuwaa hachchi miidabaa gidiyaakko, GODAI ufaittanaagaa shin attideeshsha?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Muusee hegaa siyido wode, he zaaroi a aliis. ");
INSERT INTO wal_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Israa7eela asau hagaadan yaagidi yootite; ‘Biittaa bollan de7iya mehetu ubbaappe intte maana mehetinne do7ati hageeta. ");
INSERT INTO wal_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Qinccafilee wuri phalqqettidoogeetanne waammotiya meheta ubbaa miite. ");
INSERT INTO wal_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","SHin waammo xalaalaa waammotiyaageeta woikko qassi qinccafile xalaalai phalqqettidoogeeta mooppite. Hegeetikka gaameelaa, guppalliyaanne harbbainnuwaa mooppite; aissi giikko, eti waammootiyaageeta gidikkonne, etau qinccafilee phalqqetta gidenna gishshau, eti intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Gudunttaakka mooppite; aissi giikko, ayyo qinccafilee phalqqetta gidikkonne, waammotenna gishshau, i intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Intte hageetu ashuwaa mooppite; eta bautaakka bochchoppite; eti intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“‘Haattaa giddon de7iya meretatu ubbaappe intte maanaageeti hageeta. Abbaa giddon gidin woi qassi goggiya haattaa giddon gidin de7iya ubbaappe moliyaagaa mala qefeenne poqoi de7iyo ubbaa miite. ");
INSERT INTO wal_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","SHin abbaa giddon woikko shaafan sham77i sham77iya meretatuppenne shemppoi de7iyo, qaaxxiya meretatuppe moliyaagaa mala qefeenne poqoi bainna ubbai intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Hageeti intteyyo tuna; eta ashuwaa mooppite; eta bautaakka bochchoppite. ");
INSERT INTO wal_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Qefeenne poqoi bainna haatta giddon de7iya meretati ubbai intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“‘Kafotuppe tuna gidiyo gishshau intte meennaageeti hageeta: argganttaa, bazzo ankkuwaa, karetta ankkuwaa, ");
INSERT INTO wal_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","xinggilliyaa, qoolliyaa zare ubbaa, ");
INSERT INTO wal_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","qooraase zare ubbaa ");
INSERT INTO wal_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","yanchchaa, cancciya guttuwaa, haatta kafuwaa, gace zare ubbaa, ");
INSERT INTO wal_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","qeeri guttuwaa, adussa qooree de7iyo haatta kafuwaa, wogga guttuwaa, ");
INSERT INTO wal_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","haatta kuttuwaa, mole kafuwaa, bauta ankkuwaa, ");
INSERT INTO wal_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","shimalaanne saabissaa giyo haatta kafotu zare ubbaa, jinjjilaatiyaanne wurkkaawurkkuwaa. ");
INSERT INTO wal_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“‘Qefeera de7iya oiddu tohuwan hemettiya qeeri meretati ubbai intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Gidikkonne, qefee de7iyo oiddu tohuwan hemettiyaageetuppe eta tohuwaappe bollaara guppanau maaddiya gedai de7iyoogeeta miite. ");
INSERT INTO wal_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hegeetikka, boole zare ubbaa, ukkubbo zare ubbaanne gumbburo zare ubbaa. ");
INSERT INTO wal_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","SHin hara qefeera de7iya oiddu tohoi de7iyo meretati ubbai intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“‘Hageeti inttena tunissana; eta bautaa bochchiya ubbai omarssi gakkanaashin tuna gidana. ");
INSERT INTO wal_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Hageetu bautaa denttiya ooninne ba maayuwaa meecco; shin gidikkonne omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Qinccafilee de7iiddi phalqqetta gidennaageeti woi qassi, waammotennaageeti ubbai intteyyo tuna; eta bochchiya oonikka qassi tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Oiddu tohotun hemettiya mehe ubbaappe garawatu ginddiyaa mala ginddiyan hemettiyaageeti intteyyo tuna; qassi eta bautaa bochchiya oonikka omarssi gakkanaashin tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Hegeetu bautaa denttiya ooninne ba maayuwaa meecco; shin gidikkonne omarssi gakkanaashin i tuna. Etikka intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“‘Sa7aara hemettiyaageetuppe hageeti intteyyo tuna: occoi, eceree, dumma dumma qommo zaree, ");
INSERT INTO wal_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geeggee, haulaashoi, korchchee, wakkallainne shaaqanchchai. ");
INSERT INTO wal_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Sa7aara hemettiya ubbatuppe intteyyo tuna gidiyaageeti hegeeta; etappe haiqqidabaa bochchiya ubbi omarssi gakkanaashin tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Etappe haiqqidabi aiba bolli kunddikkokka, he eti a bolli kunddido miishshai tuna; mitta miishsha woikko maayo woikko galbba woikko qarcciita gidinkka, go7ettiyo miishsha ubbaa haatta giddon wottite; hegee omarssi gakkanaashin tuna; Hegaappe guyyiyan, geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ha sa7aara hemettiyaageetuppe issuwaa bautai ai urqqa miishshaa giddon kunddikkokka, a giddon de7iyaabi ubbi tuna; he miishshaa menttite. ");
INSERT INTO wal_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","He miishshaa giddon de7iya haattaappe miyo ai quma bolli xokkikkokka, he qumai tuna; qassi uyiyoobi aibanne gido, he miishshaa giddon de7ikko, ikka tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Hageetu ahi a bolli kunddiyoobi aiba gidikkokka tuna. Coociyaa woi kattiyo urqqa miishshaa gidikkokka menttite; eti intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Hageetu bautai bochchiyoobai ubbai tuna gidikkonne, pulttoinne haatta ollai geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Eta bautaappe issoi zeranau wottido zeretta kattaa bolli kunddikko, hegee tunenna. ");
INSERT INTO wal_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","SHin he zerettaa bolli haatti gukki simmin, eta bautaappe issoinne a bolli kunddikko, he zerettai intteyyo tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“‘Qassi intte miyo mehetuppe issoi haiqqin, a bautaa bochchiya ooninne omarssi gakkanaashin tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ooninne he mehiyaa bautaappe miikko, ba maayuwaa meecco; omarssi gakkanaashin i tuna; qassi ooninne a bautaa tookkidi denttikko, ba maayuwaa meecco; omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“‘Sa7aara gooshettiya mereta ubbai intteyyo tuna; a mooppite. ");
INSERT INTO wal_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Uluwan gooshettiyaabaa gidin, woi oiddu gediyan hemettiyaabaa gidin, woi qassi daro gedee de7iyoobaa gidinkka, sa7aara gooshettiya mereta ubbai tuna gidiyo gishshau a mooppite. ");
INSERT INTO wal_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Sa7aara gooshettiya mereta ubban intte huuphiyau tunoppite; qassi etan intte asatettaa tunissoppite. ");
INSERT INTO wal_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Taani, GODAI, intte Xoossaattennee. Taani geeshsha gidiyo gishshau, inttekka inttena dummayidi, geeshsha gidite. Sa7aara gooshettiyaabatun intte asatettaa tunissoppite. ");
INSERT INTO wal_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Aissi giikko, taani intte Xoossaa gidanau, inttena Gibxxe biittaappe kessida GODAATTENNEE. Hegaa gishshau, taani geeshsha gidiyo gishshau, inttekka geeshsha gidite’ yaagite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Mehetu, kafotu, haatta giddon paxa qaaxxiya meretatu ubbatunne sa7aara hemettiya meretatu ubbatu wogai hagaa. ");
INSERT INTO wal_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Hegeenne intte tunaanne geeshshaa, qassi shemppoi de7iyo meretatuppe miyoogeetanne meennaageeta shaakkidi eranaassa. ");
INSERT INTO wal_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Israa7eela asaassi hagaadan yaagada yoota; ‘Issi maccaasiyaa shahaarada attuma na7a yelikko, ba kushe qitai yiido wode a tuna gidiyoogaadankka, hegaadan a laappun gallassai gakkanaashin tuna gidana. ");
INSERT INTO wal_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Hosppuntta gallassi na7ai qaxxarettanau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hegaappe guyyiyan, maccaasiyaa ba yeluwaa suuttai xi77ana gakkanaashin, hasttamanne heezzu gallassaa takku; qassi ba geeyiyo gallassati wurana gakkanaashin, geeshshabaa aibanne bochchuppu; Xoossaa Dunkkaaniyaakka geluppu. ");
INSERT INTO wal_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“‘SHin issi maccaasiyaa macca na7a yelikko, ba kushe qitai yiido wode a tuna gidiyoogaadankka, hagaadan naa77u saamintta gakkanaashin, a tuna gidana; Hegaappe guyyiyan, ba yelo suuttai xi77ana gakkanaashin usuppun tammanne usuppun gallassaa takku. ");
INSERT INTO wal_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“‘Maccaasiyaa attuma na7a gidin macca na7a gidin yelada, ba geeyiyo wodiyaa wurssoogaappe guyyiyan, xuuggiyo yarshshuwaassi issi laitta dorssaanne nagaraa yarshshuwaassi qassi issi haraphphiyaa buuba woikko issi mara haraphphiyaa Xoossaa Dunkkaaniyaa penggen de7iya qeesiyaakko ehu. ");
INSERT INTO wal_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Qeesee hegaa GODAA sinttan yarshshidi, i nagaraa atto giissees; yaatobare a ba yelo suuttaa gogettaappe geeyausu. Attuma na7a woikko macca na7a yeliya maccaasee wogai hegaa. ");
INSERT INTO wal_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“‘SHin issi laitta dorssa orggiyaa ehaanau iyyo miishshi gidana xayikko, naa77u buuba haraphpheta woikko naa77u mara haraphpheta ehu. Etappe issoi xuuggiyo yarshshuwaassa; issoi qassi nagaraa yarshshuwaassa. Yaatobare qeesee hegeeta yarshshidi, i nagaraa atto giissees; akka geeshsha gidausu’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ai asa bollinne kixi wodhdhikko, woikko xuussa masuntti woikko ilahi kiyikkonne qassi hegeekka a galbban hanttaara goga harggiyau laamettikko, he bitaniyaa qeesiyaa Aaroonakko woikko qeese gidiya a attuma naatuppe issuwaakko ehoona. ");
INSERT INTO wal_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ehin qeesee a gogaa bollan de7iya masunttaa be7o. He masunxxida sohuwan de7iya ikisee booxxikkonne, masunttaikka ollatikko, hegee hanttaara goga hargge. Qeesee hegaa be7idi, he bitanee tuna gidiyoogaa erisso. ");
INSERT INTO wal_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","SHin a gogaa bollan de7iya masunttai booxxikkokka, gogaappe kanttidi ollatibeennabaa gidikkonne he masunttaa bollan de7iya ikisee booxxibeennabaa gidikko, qeesee he bitaniyaa dumma kifiliyan laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Laappuntta gallassan qeesee a zaarettidikka be7o; i be7iyo wode masunttai bitaniyaa gogaa bollan aakkennan kaseegaadankka de7ikko, qeesee he bitaniyaa naa77anttuwaakka dumma kifiliyan laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Qassikka laappuntta gallassan qeesee a be7o; be7iyo wode masunttai aakkiyoogaa aggidi xayi xayi biikko, qeesee i geeshsha gidiyoogaa erisso. Hegee xuussappe attin harabaa gidenna; hegaa gishshau, i ba maayuwaa meeccidi geeshsha gidees. ");
INSERT INTO wal_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","SHin i geeyanau bana qeesiyaa bessidoogaappe guyyiyan, he xuussai a gogaa bollan yaa aakki aakki biikko, i naa77anttuwaa bana bessanau qeesiyaakko bo. ");
INSERT INTO wal_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Qeeseekka a be7o; he xuussai bitaniyaa gogaa bollan yaa aakki aakki biikko, qeesee i tuna gidiyoogaa erisso. Aissi giikko, hegee hanttaara goga hargge. ");
INSERT INTO wal_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Oonanne hanttaara goga harggee oiqqikko, qeesiyaakko a ehoona. ");
INSERT INTO wal_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ehin qeesee a be7o; be7iyo wode a gogaa bollan bootta kixai de7ikko, he kixai ikisiyaakka boottau laammikkonne he kixaa giddon ashoi munni uttidabaa gidikko, ");
INSERT INTO wal_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","hegee a gogaa bollan gam77ida hanttaara goga hargge gidiyo gishshau, qeesee i tuna gidiyoogaa erisso. I tuna gidiyoogee erettiichchido gishshau, a dumma kifiliyan gorddanau koshshenna. ");
INSERT INTO wal_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Qassi hanttaara goga harggee bitaniyaa gogaa bollan aakkidi, huupheppe toho gakkanaashin ubban maayidabaa gidikko, qeesee be7o. ");
INSERT INTO wal_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Be7in he hanttaara goga harggee a bollaa ubbaa maayikko, qeesee i geeshsha gidiyoogaa erisso; a bollai muleerakka laamettidi bootta gidido gishshau, i geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","SHin he masunttaa giddoora munnida ashoi beettikko i tuna. ");
INSERT INTO wal_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Qeesee he munnida ashuwaa be7o; be7idi he bitanee tuna gidiyoogaa erisso. He munnida ashoi hanttaara goga hargge gidiyo gishshau, i tuna. ");
INSERT INTO wal_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","SHin he munnida ashoi qassikka laamettidi booxxikko, he bitanee qeesiyaakko yo. ");
INSERT INTO wal_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Qeesee a be7o; be7in a masunttai booxxidabaa gidikko, he bitanee geeshsha gidiyoogaa qeesee erisso. Yaatobare i geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Issi asa bolli merkkoi wodhdhidi paxin, ");
INSERT INTO wal_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","a sohuwan bootta kixai wodhdhikko woikko zo77ida ilahai kiyikko, he urai bana qeesiyaa besso. ");
INSERT INTO wal_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Qeesee a be7o; be7in he masunttai ollatikkonne masunttaa bollan de7iya ikiseekka laamettidi booxxikko, he bitanee tuna gidiyoogaa qeesee erisso. Hegee merkkuwaara doommida hanttaara goga harggiyaa. ");
INSERT INTO wal_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","SHin qeesee be7iyo wode, ikisee booxxibeennabaa gidikkonne masunttaikka gogaa kanttidi ollatibeennabaa gidikko, qassi xayi xayi biikko, qeesee a dumma kifiliyan laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Hegee a gogaa bollan aakki aakkidi biikko, he bitanee tuna gidiyoogaa qeesee erisso. Aissi giikko, hegee goga hargge. ");
INSERT INTO wal_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","SHin he ilahai aakki aakki beennan issi soho xallan de7ikko, hegee merkkoi paxido malaataa gidiyo gishshau, he bitanee geeshsha gidiyoogaa qeesee erisso. ");
INSERT INTO wal_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Issi asa gogaa tami miikkonne he miido sohuwan booxxida woikko zo77ida ilahai kiyikko, ");
INSERT INTO wal_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","qeesee he sohuwaa be7o; be7in a sohuwan de7iya ikisee booxxikkonne merkkoikka kanttidi ollatikko, hegee hanttaara goga hargge. I tamai miidosaara kiyiis; hegaa gishshau qeesee i tuna gidiyoogaa erisso. ");
INSERT INTO wal_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","SHin qeesee be7iyo wode, he ilahaa bollan de7iya ikisee booxxibeennabaa gidikkonne masunttaikka gogaa kanttidi ollatibeennabaa gidikko, qassi xayi xayi biidabaa gidikko, qeesee a dumma kifiliyan laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Laappuntta gallassan qeesee a be7o; be7iyo wode he sohoi aakki aakki biikko, i tuna gidiyoogaa qeesee erisso. Hegee hanttaara goga hargge. ");
INSERT INTO wal_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","SHin he ilahai gogaa bollan aakkennan aggidi, issi sohuwan uttikkonne ubba qassi xayi xayi biikko, hegee tamai miidosan attida malaataa gidiyo gishshau, i geeshsha gidiyoogaa qeesee erisso. ");
INSERT INTO wal_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Issi attuma asassi woikko macca asassi huuphiyaa woikko gacuwaa bollan masuntti kiyikko, ");
INSERT INTO wal_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","qeesee he masunttaa be7o. I be7iyo wode masunttai gogaa kanttidi ollatikkonne a bollan de7iya ikiseekka adille ciishsha milatiya lee7e gidikko, he bitanee tuna gidiyoogaa qeesee erisso. Hegee huuphiyaa woikko gacuwaa bollan kiyiya qaachchanne hanttaara goga hargge. ");
INSERT INTO wal_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Qassi qeesee he harggiyaa be7iyo wode, i gogaa kanttidi ollatibeennabaa gidikkonne karetta ikiseekka a bolli xayikko, he qaachchiya harggiyaara de7iya bitaniyaa qeesee dumma kifiliyan laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Laappuntta gallassan qeesee he harggiyaa be7o; be7iyo wode qaachchiya harggee aakkennabaa gidikko, a bollan adille ciishsha milatiya ikisee bainnabaa gidikkonne, ikka gogaa kanttidi ollatibeennabaa gidikko, ");
INSERT INTO wal_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","he bitanee he masunttaa yuushuwan de7iya ikisiyaa meedo; qaachchiya sohuwan de7iya ikisiyaa mati meedoppo. Qeesee he bitaniyaa dumma kifiliyan hara laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Laappuntta gallassan qeesee he qaachchiyaasaa be7o; be7iyo wode hegee bitaniyaa gogaa bollan aakkana xayikkonne gogaa kanttidi ollatana xayikko, he bitanee geeshsha gidiyoogaa qeesee erisso. Bitaneekka ba maayuwaa meeccidi, geeshsha gidees. ");
INSERT INTO wal_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","SHin i geeyidoogaappe guyyiyan, qaachchiyaagee he bitaniyaa gogaa bollan aakki aakki biikko, ");
INSERT INTO wal_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","qeesee a be7o; be7iyo wode he qaachchiyaagee aakkidabaa gidikko, qeesee adille ciishsha milatiya ikisiyaa koyoppo. Aissi giikko, he bitanee tuniichchiis. ");
INSERT INTO wal_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","SHin qeesee be7iyo wode, he qaachchiyaasai aakkibeennabaa gidikkonne karetta ikiseekka a bolli mokkidabaa gidikko, he qaachchiyaasai paxiichchiis. He bitaneekka geeshsha gidiyo gishshau, i geeshsha gidiyoogaa qeesee erisso. ");
INSERT INTO wal_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Issi attuma asa woikko macca asa gogaa bolli bootta ilahai kiyikko, ");
INSERT INTO wal_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","qeesee a be7o. Be7iyo wode he eta gogaa bollan de7iya ilahai shololla bootta gidikko, hegee goga bollan coo kiyidabaa; he bitaneekka geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Issi asau huuphiyaa binnaanai qoqqofettikko, i bo77a; gidoppe attin i geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Qassi issi asau huuphiyaa binnaani sinttaara bo77atikko, a tiishshi miis; gidoppe attin i geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","SHin a bo77aa woikko a tiishshai miidosaa bollan zo7o woikko bootta masuntti kiyikko, hegee a bo77an woikko tiishshai miidosan kiyida hanttaara goga hargge. ");
INSERT INTO wal_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","A qeesee be7o. Be7iyo wode a bo77aa woikko tiishshai miidosaa bollan de7iya masunttai gogaa bollan kiyiya hanttaara goga harggiyaadan zo7o gidikko, ");
INSERT INTO wal_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","he bitanee tumukka hanttaara goga hargge sakkiyo hargganchcha. I tuna gidiyo gishshau i tuna gidiyoogaa qeesee erisso. Aissi giikko, harggee a huuphiyan de7ees. ");
INSERT INTO wal_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Hanttaara goga harggee oiqqido asi pooshettida maayuwaa maayo; ba huuphiyaa pixoppo; ba menttershshaakka kammo; yaatidi, ba qaalaa xoqqu oottidi, ‘Taani tuna, taani tuna!’ yaago. ");
INSERT INTO wal_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","He harggee a bolli de7ido keesan ubban i tuna. I tuna gidiyo gishshau, asappe shaahettidi dunkkaanidosaappe kareera barkka de7o. ");
INSERT INTO wal_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Ai maayuwaa bollinne boroqida sohoi beettikko, he maayoi suufe gidin woi liino gidin, ");
INSERT INTO wal_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","dadettida woikko sikettida liino woi suufe gidin, galbba woikko galbbappe oosettida maayo gidin, ");
INSERT INTO wal_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","he maayuwaa bolli kiyida boroqoi maata milatiya woikko zo7o meraa bessikko, i qacinaappe woi shaluwaappe dadettidabaa gidin, galbba woi galbbaappe oosettida maayo gidinkka, hegee boroqoi kiyido gishshau, hegaa qeesiyaa bessanau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Qeesee he boroquwaa be7idi, he boroquwaara de7iya maayuwaa dumma kifiliyan laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Laappuntta gallassan qeesee he maayuwaa be7o; be7iyo wode he maayuwaa bollan aakki aakki biikko, i qacina woi shalo maayo gidin, galbba woi galbbaappe oosettida maayo gidinkka, hegee issuwaappe issuwaa oiqqiya boroqo gidiyo gishshau, he maayoi tuna. ");
INSERT INTO wal_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Qassi he maayoi qacina woi shalo maayo gidin, liino woi suufe gidin, galbbaappe oosettidabaa aiba gidinkka, qeesee a xuuggo. Hegee issuwaappe issuwaa oiqqiya boroqo gidiyo gishshau, i xuugettanau bessees. ");
INSERT INTO wal_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Qassikka qeesee be7iyo wode, he boroqoi maayuwaa bolli aakkibeennabaa gidikko, i qacina woi shalo maayo woikko galbbaappe oosettidabaa aiba gidinkka, ");
INSERT INTO wal_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","he boroqoi de7iyo maayuwaa meeccanaadan qeesee azazo. Hegaappe guyyiyan, he maayuwaa dumma kifiliyan hara laappun gallassaa gorddidi wotto. ");
INSERT INTO wal_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","He boroqo sohoi de7iyo maayuwaa meeccoogaappe guyyiyan, qassikka qeesee be7o; be7iyo wode he boroqoi ba meraa laammibeennabaa gidikko, i aakki aakki baana xayikkokka tuna. He boroqo sohoi maayuwaassi guyye baggaara woi sintta baggaara de7inkka, he maayoi taman xuugettanau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","SHin he maayuwaa meecci simmin qeesee be7iyo wode boroqoi xayi xayi biikko, i galbba gidin, qacina woi shalo maayo gidinkka, he boroqoi de7iyo sohuwaa qeesee daakkidi kessirggo. ");
INSERT INTO wal_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Hegaappe guyyiyan, maayuwaa bolli simmidikka kiyikko, he maayoi qacina woi shalo maayo gidin, galbbaappe oosettidabaa aiba gidinkka, hegee aakki aakki biya boroqo soho gidiyo gishshau, he boroqoi de7iyo maayoi taman xuugettanau bessees. ");
INSERT INTO wal_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","SHin meecettida maayoi qacina woi shalo maayo gidin, woi galbbaappe oosettida aiba maayo gidinkka, boroqo sohoi a bollappe xayikko, he maayoi naa77anttuwaa meecetto; Hegaappe guyyiyan, i geeshsha gidees. ");
INSERT INTO wal_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Issi maayoi suufe woi liino gidin, qacina woi shalo maayo gidin, woi qassi galbbaappe oosettidabaa gidinkka, he maayuwaa geeshsha woi tuna giissanau danddayiya boroqo sohuwaa wogai hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","GODAI Muuseyyo hagaadan yaagidi yootiis; ");
INSERT INTO wal_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Hanttaara goga harggee oiqqido bitanee geeyiyo gallassi oottanau koshshiya wogai hagaa. He bitaniyaa qeesiyaakko efaanau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Qeesee asai dunkkaanidosaappe gaxaa kiyidi, a harggiyaa be7o. Be7iyo wode hanttaara goga harggee bitaniyaa bollaappe xayidabaa gidikko, ");
INSERT INTO wal_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","qeesee paxa de7iya naa77u geeshsha kafota, xiidda mittaa, zo7o qacinaanne hiisoophphiyaa bonccuwaa he hanttaara goga harggiyaappe geeyiya bitaniyaa gishshau ehaanaadan eta azazo. ");
INSERT INTO wal_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Hegaappe guyyiyan, qassi qeesee naa77u kafotappe issuwaa keriyan de7iya pultto haattaa bolli shukkanaadan azazo. ");
INSERT INTO wal_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Paxa de7iya kafuwaa, qassi zigaara, zo7o qacinaaranne hiisoophphiyaa bonccuwaara ekki efiidi, keriyan de7iya pultto haattaa bolli shukkido kafuwaa suuttaa giddo naaqqo. ");
INSERT INTO wal_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Naaqqi kessido suuttaa he hanttaara goga harggiyaappe paxiya bitaniyaa bolli laapputoo caccafo; yaatidi he bitanee geeshsha gidiyoogaa erisso; paxa de7iya kafuwaa gede dembbau yeddo. ");
INSERT INTO wal_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“He harggiyaappe geeyida bitanee ba maayuwaa meecco; ba bollan de7iya ikise ubbaa meedetto; ba bollaakka meecetto; yaatikko i geeshsha gidana. Hegaappe guyyiyan, i dunkkaanidosaa yo; shin gidikkonne ba dunkkaaniyaa gelennan laappun gallassaa kareera gam77o. ");
INSERT INTO wal_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Laappuntta gallassan ba huuphiyaa, buuchchaa, deemuwaanne ba bollan de7iya hara ikise ubbaa meedetto; qassi ba maayuwaa meecco; ba bollaakka meecetto; Hegaappe guyyiyan, i geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Hosppuntta gallassan tilla bollaara de7iya naa77u dorssa maratanne issi laitta gidido issi dorssiyo eho; qassi kattaa yarshshuwaassi zaitiyan munaqettida heezzu kilo giraame xiilliyaanne issi litiro wogaraa zaitiyau heezzantto kushiyaa eho. ");
INSERT INTO wal_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","A geeshshiya qeesee bitaniyaa i ehiidobatuurakka issippe Xoossaa Dunkkaaniyaa pengge GODAA sintti shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Qeeseekka naa77u dorssa maratuppe issuwaa ekkidi, litiruwaassi heezzantto kushe zaitiyaara issippe naaquwaa yarshsho oottidi shiishsho; he shiishshidoogaa qassi wuxaawuxiyo yarshsho oottidi, GODAA sinttan wuxaawuxo. ");
INSERT INTO wal_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Yaatidi i he dorssa maraa nagaraa yarshshuwaanne xuuggiyo yarshshuwaa shukkiyo geeshsha sohuwan shukko. Nagaraa yarshshuwaadan naaquwaa yarshshoikka qeesiyaassi imettees; ikka keehippe geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Qeesee naaquwaa yarshshuwaa suuttaappe guuttaa ekkidi, he geeyiya bitaniyau ushachcha bagga haittaa xeeraa, ushachcha kushiyau wogga biradhdhiyaanne ushachcha tohuwau wogga biradhdhiyaa tiyo. ");
INSERT INTO wal_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Hegaappe guyyiyan, qeesee wogaraa zaitiyaappe guuttaa ekkidi, ba haddirssa kushiyaa gomppan tigo. ");
INSERT INTO wal_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","“Tigidi he haddirssa kushiyaa gomppan de7iya wogaraa zaitiyan ba ushachcha kushiyaa biradhdhiyaa naaqqidi, GODAA sinttan laapputoo caccafo. ");
INSERT INTO wal_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Yaati simmidi ba kushiyaa gomppan attida zaitiyaappe ekkidi, geeyiya bitaniyau ushachcha haittaa xeeraa, ushachcha kushiyau wogga biradhdhiyaanne ushachcha tohuwau wogga biradhdhiyaa kase naaquwaa yarshshuwaa suuttaa tiyido sohuwan tiyo. ");
INSERT INTO wal_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Qassi ba kushiyaa gomppan attida zaitiyaa qeesee geeyiya bitaniyaa huuphiyan gusso; yaatidi GODAA sinttan he bitaniyaa nagaraa atto giisso. ");
INSERT INTO wal_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Hegaappe guyyiyan qeesee ba tunatettaappe geeyiya bitaniyaa nagaraa atto giissanau nagaraa yarshshuwaassi shiishshido mehiyaa shukkees; hegaappe simmidi qassi xuuggiyo yarshshuwau shiishshido mehiyaa yarshshees. ");
INSERT INTO wal_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Qassi qeesee he xuuggiyo yarshshuwaa kattaa yarshshuwaara issippe yarshshiyoosaa bollan wottidi xuuggees; yaatidi bitaniyaa nagaraa atto giissees; bitaneekka geeshsha gidees. ");
INSERT INTO wal_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“SHin bitanee hegaa ubbaa ehaanau danddayenna manqqo gidikko, GODAA sinttan wuxaawuxidi a nagaraa atto giissanau, ba naaquwaa yarshshuwaassi issi dorssa maraa eho. Qassi kattaa yarshshuwaassikka wogaraa zaitiyan munaqettida issi kilo giraame lo77o xiilliyaanne issi litiruwaassi heezzantto kushe zaitiyaa issippe eho. ");
INSERT INTO wal_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Qassikka bau danddayidoogaadan naa77u buuba haraphpheta woikko naa77u mara haraphpheta, issuwaa nagaraa yarshshuwaassi, issuwaa qassi xuuggiyo yarshshuwaassi eho. ");
INSERT INTO wal_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Hosppuntta gallassan ba nagaraappe geeyanau bitanee hageeta qeesiyaakko Xoossaa Dunkkaaniyaa pengge GODAA sintti eho. ");
INSERT INTO wal_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ehin qeesee naaquwaa yarshshuwau ehiido dorssa maraanne zaitiyaa ekkidi, wuxaawuxiyo yarshsho oottidi GODAA sinttan wuxaawuxo. ");
INSERT INTO wal_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Yaatidi naaquwaa yarshshuwau ehiido dorssa maraa shukko; shukkidi he naaquwaa yarshshuwaa suuttaappe guuttaa ekkidi, ha geeyiya bitaniyau ushachcha haittaa xeeraa, ushachcha kushiyau wogga biradhdhiyaanne ushachcha tohuwau wogga biradhdhiyaa tiyo. ");
INSERT INTO wal_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Qassi qeesee zaitiyaappe guuttaa ba haddirssa kushiyaa gomppan tigo. ");
INSERT INTO wal_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Tigidi he haddirssa kushiyaa gomppan de7iya zaitiyaappe ushachcha kushiyaa xeeran guuttaa ekkidi, GODAA sinttan laapputoo caccafo. ");
INSERT INTO wal_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Qassikka qeesee ba kushiyaa gomppan de7iya zaitiyaappe guuttaa ekkidi, geeyiya bitaniyaassi ushachcha haittaa xeeraa, ushachcha kushiyau wogga biradhdhiyaanne ushachcha tohuwau wogga biradhdhiyaa kase naaquwaa yarshshuwaa suuttaa tiyido sohuwan tiyo. ");
INSERT INTO wal_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Qassi GODAA sinttan bitaniyaa nagaraa atto giissanau, qeesee ba kushiyan attida zaitiyaa geeyiya bitaniyaa huuphiyan tiyo. ");
INSERT INTO wal_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hegaappe guyyiyan, he aawu bau danddayidoogaadan haraphphe buuba gidin woikko mara haraphphe gidin, ");
INSERT INTO wal_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","issuwaa nagaraa yarshshuwaassi naa77anttuwaa qassi xuuggiyo yarshshuwaassi kattaa yarshshuwaara issippe yarshsho. Qassi qeeseekka he geeyiya bitaniyaassi GODAA sinttan a nagaraa atto giisso. ");
INSERT INTO wal_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ba bollan de7iya hanttaara goga harggiyaappe geeyanau koshshiya wogaa polanau manqqotai diggido urau de7iya wogai simmi hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","GODAI Muusanne Aaroona hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Taani intteyyo aqo oottada immiyo Kanaane biittaa intte geliyo wode, qassi he biittan de7iya intte keettaappe issuwan taani boroquwaa yeddiyo wode, ");
INSERT INTO wal_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","he keettaawai qeesiyaakko biidi, ‘Ta son aiba boroqokko de7ees’ yaagidi yooto. ");
INSERT INTO wal_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Son de7iyaabai ubbai tuna geetettennaadan, qeesee boroquwaa be7anau gelanaappe kasetidi, son de7iyaabaa ubbaa kare kessanaadan azazo; yaati simmin qeesee be7anau soo gelo. ");
INSERT INTO wal_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Gelidi be7iyo wode, boroqo sohoi godaa bollan maata milatiya, woikko zo7o meraa bessikkonne qassi godaappe ollatidi giddo gelikko, ");
INSERT INTO wal_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","qeesee sooppe kare kiyidi, keettaa laappun gallassa gakkanaashin gorddo. ");
INSERT INTO wal_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Laappuntta gallassan qeesee he keettaa zaarettidi xeello; xeelliyo wode he boroqoi keettaa godaa bollan aakkikko, ");
INSERT INTO wal_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","boroqoi de7iyo shuchchata ubbaa godaappe shoddidi, katamaappe gaxi yaa tunida sohuwau olanaadan azazo. ");
INSERT INTO wal_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Qassi godaa meeshido urqqaa so baggaara bookkishin, yuushshi aattidi qoqqofanaadan ootto; yaatidi he qoqqofido urqqaa katamaappe gaxan de7iya tuna sohuwan olona. ");
INSERT INTO wal_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Hegaappe guyyiyan, he shoddido shuchchatu sohuwan hara shuchchata wottona; qassi hara urqqankka keettaa caddona. ");
INSERT INTO wal_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“SHuchchata shoddirggin, qassi urqqaakka qoqqofidi hara urqqaa caddi simmin, naa77anttuwaa simmidi boroqoi keetta giddon aakkikko, ");
INSERT INTO wal_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","qeesee hegaa be7o; be7iyo wode boroqoi he keettaa giddon aakkikko, hegee issuwaappe issuwaa oiqqiya boroqo gidiyo gishshau, he keettai tuna. ");
INSERT INTO wal_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Hegaa gishshau i he keettaa, a shuchchaa, a mittaanne i cadettido urqqaa ubbaa kolo; kolidi hegeeta katamaappe gaxi efiidi, tuna sohuwan olo. ");
INSERT INTO wal_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Qassi he keettai gorddiyan takkiyo wodiyan a giddo geliya ooninne sa7ai qammana gakkanaashin tuna. ");
INSERT INTO wal_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","He keettan zin77iya uri woikko katta miya uri ba maayuwaa meecco. ");
INSERT INTO wal_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“SHin qeesee yiidi xeelliyo wode, keettai cadetti simmin naa77anttuwaa simmidi aakkana xayikko, boroqoi xayiichchido gishshau, he keettai geeshsha gidiyoogaa qeesee erisso. ");
INSERT INTO wal_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Keettaa geeshshanau naa77u kafota, xiiddaa mittaa, zo7o qacinaanne hiisoophphiyaa bonccuwaa eho. ");
INSERT INTO wal_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kafotuppe issuwaa keriyan de7iya pultto haattaa bollan shukko. ");
INSERT INTO wal_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Hegaappe guyyiyan xiiddaa, hiisoophphiyaa bonccuwaa, zo7o qacinaanne paxa de7iya kafuwaa issippe ekkidi, keriyan de7iya shukkido kafuwaa suuttaaninne pulttuwaa haattan yeggi kessidi, laapputoo he keettaa caccafo. ");
INSERT INTO wal_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Yaatidi he keettaa qeesee kafuwaa suuttan, pulttuwaa haattan, paxa de7iya kafuwan, xiiddan, hiisoophphiyaa bonccuwaaninne zo7o qacinan geeshsho. ");
INSERT INTO wal_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Qassi paxa de7iya kafuwaa katamaappe gaxi hini dembbau yeddo. Hegaadan oottidi, keettaa geeshshiyo wogaa polees; keettaikka geeshsha gidees. ");
INSERT INTO wal_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Ai hanttaara goga hargge gidikkokka hagee woga; qaachchiyaabaa gidin, ");
INSERT INTO wal_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","maayuwaa bollan woi keettaa bollan kiyiya boroqo gidin, ");
INSERT INTO wal_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kixa gidin, xuussa masunttaa gidin woi ilaha gidinkka, ");
INSERT INTO wal_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","issibai tuna gidiyoogaanne geeshsha gidiyoogaa erissanau hanttaara goga harggiyaanne boroquwaa wogai hagaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Israa7eela asaayyo hagaadan yaagidi yootite; ‘Ai asa bollaappekka issi aibakko goggikko, he goggiyaabai tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","He goggiyaabaappe denddidaagan he aawu tuna gidiyo wogai hagaa: He goggiyaabai aggennan gogginkka woi qassi goggiyoogaa aggikkokka he a giddon de7iyaabai a tunissees. ");
INSERT INTO wal_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“‘A bollaappe aibakko goggiyo asi zin77iyo ai hiixikka tuna; qassi i uttiyoobi aiba gidikkokka tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","A hiixaa bochchiya ooninne ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Goggiyaabaara de7iya asi uttidobaa bolli uttiya ooninne ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“‘Goggiyaabai de7iyo asa bollaa bochchiya ooninne ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“‘Goggiyaabai de7iyo asi geeshsha asa bolli cuchchikko, he asi ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“‘Qassi goggiyaabai de7iyo asi uttiyo ai kooraikka tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Baappe garssaara de7iyaabaa aibin gidikkokka bochchiya ooninne omarssi gakkanaashin tuna; qassi hegeeta milatiyaabata tookkiya ooninne ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“‘Goggiyaabaara de7iya asi ba kushiyaa meecettennan de7iiddi bochchiyo asi ooninne ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“‘Qassi goggiyaabai de7iyo asi bochchiyo urqqa miishshaa ubbaa menttite; mittaappe oosettida miishsha ubbai qassi haattan meecetto. ");
INSERT INTO wal_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“‘Goggiyaabai de7iyo asi he goggiyaabaappe geeyiyo wode, bau laappun gallassaa qoodo. Ba maayuwaa meecco; ba bollaaka pultto haattan meecetto; yaatidi i geeshsha gidees. ");
INSERT INTO wal_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Hosppuntta gallassi naa77u buuba haraphpheta woikko naa77u mara haraphpheta ekkidi, Xoossaa Dunkkaaniyaa pengge GODAA sintti yiidi, qeesiyaayyo eta immo. ");
INSERT INTO wal_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Immin qeesee haraphphetappe issuwaa nagaraa yarshshuwaassi, naa77anttuwaa qassi xuuggiyo yarshshuwaassi yarshshees; yaatidi qeesee bitaniyaa bollaappe goggiyaabaa gishshau GODAA sinttan a nagaraa atto giissees. ");
INSERT INTO wal_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“‘Ai attuma asinne ba attumatettaappe zeretti gukkikko, ba kumetta bollaa haattan meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Attumatettaappe gukkida zerettai bochchido maayo ubbai woikko galbba ubbai haattan meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Qassi issi attumaasi macca asaara zin77in, a attumatettaappe zeretti gukkikko, naa77aikka haattan meecettona; qassi omarssi gakkanaashin eti tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“‘Maccaasassi aginan aginan yiya kushe qitai yiikko, laappun gallassa gakkanaashin a tuna; qassi o bochchiya ooninne omarssi gakkanaashin tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“‘He kushe qitaa wode a zin77iyoobai ubbai tuna; qassi a uttiyoobai ubbaikka tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","A zin77iyo hiixaa bochchiya ubbai ba maayuwaa meecco; haattankka meecetto; omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","A uttiyoobaa bochchiya ubbai ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","A zin77iyo hiixa gidinkka woikko a uttiyoobaa bochchiya ooninne omarssi gakkanaashin tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“‘Ai attuma asinne he kushe qitaa wode iira zin77ikko, he kushe qitai qassi a bochchikko, laappun gallassa gakkanaashin i tuna; i zin77iyo hiixai ubbaikka tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“‘Issi macca asassi i kushe qitaa wodiyaa gidennan hara wodiyan suuttai goggikko, woi qassi i kushe qitaikka ba wodiyaappe aattidi eqqennan ixxidi goggikko, i eqqana gakkanaashin a tuna. Ba kushe qitaa wodiyan tuna gidiyoogaadan, he wodekka a tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","He suuttai ippe goggiyo wodiyan a zin77ido hiixai ubbai, ba kushe qitaa wode a zin77ido hiixaakka mala tuna; qassi a uttiyoobai ubbaikka ba kushe qitaa wode a uttiyoobai tuna gidiyoogaadan tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Qassi he tunidabata bochchiya ooninne tuna; i ba maayuwaa meecco; ba bollaakka meecetto; qassi omarssi gakkanaashin i tuna. ");
INSERT INTO wal_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“‘Ippe goggiyaabai eqqikko, a he wodiyaappe doommada laappun gallassaa qoodu; Hegaappe guyyiyan, a geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Hosppuntta gallassan a naa77u buuba haraphpheta woikko naa77u mara haraphpheta ekkada, Xoossaa Dunkkaaniyaa pengge qeesiyaakko ehu. ");
INSERT INTO wal_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ehin qeesee haraphphetuppe issuwaa nagaraa yarshshuwaassi issuwaa qassi xuuggiyo yarshshuwaassi yarshsho. Yaatidi qeesee ippe goggiyaabaa tunatettaa gishshau GODAA sinttan i nagaraa atto giissees. ");
INSERT INTO wal_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“‘Bantta giddon de7iya Xoossaa Dunkkaaniyaa tunissidi Israa7eela asai haiqqennaadan, neeni hagaadan oottada eti banttana tunissiyaabaappe shaahettidi de7anaadan naaga. ");
INSERT INTO wal_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“‘A bollaappe aibakko goggiyo asassinne a attumatettaappe gukkida zerettan tuniya asassi, ");
INSERT INTO wal_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","qassi ba kushe qitaa gaasuwan tuniya maccaasassi, attuma gidin macca gidin goggiyaabai de7iyo asassinne tunida macca asaara zin77iya attuma asassi imettida wogai hagaa’ yaagite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aaroona attuma naati naa77ai GODAA sintti shiiqidi haiqqidoogaappe guyyiyan, GODAI Muusa hagaadan yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Ne ishai Aarooni Taabootaa bollan de7iya atto giyo sohuwaa qum77uwaa sinttan magalashuwaappe guyye baggaara de7iya Ubbaappe Aadhdhida Geeshsha Sohuwaa ubba wode coo gelennaadan ayyo oda. Coo gelikko i haiqqana; aissi giikko, taani shaaraa giddoora atto giyo sohuwaa qum77uwaa bollan qonccais. ");
INSERT INTO wal_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aarooni nagaraa yarshshuwaassi issi mirgguwaanne qassi xuuggiyo yarshshuwaassi issi dorssa orggiyaa ekkidi, he Ubbaappe Aadhdhida Geeshsha Sohuwaa gelo. ");
INSERT INTO wal_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Aarooni liinuwaappe oosettida geeshsha qoliyaanne liinuwaappe oosettida garssaara maayiyo maayuwaa maayo. Qassi liinuwaappe oosettida danccuwaa dancco; hegaadankka qassi ba huuphiyan liinuwaappe oosettida shaashiyaa enccurssaa wotto. Hageeti geeshsha maayota gidiyo gishshau, i ba bollaa haattan meecettiichchidi maayo. ");
INSERT INTO wal_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Israa7eela asaa maabarai nagaraa yarshshuwaassi naa77u deeshsha orggeta, xuuggiyo yarshshuwaassikka issi dorssaa orggiyaa Aaroonassi ehoona. ");
INSERT INTO wal_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aarooni ba nagaraanne ba so asaa nagaraa atto giissanau mirgguwaa yarshsho. ");
INSERT INTO wal_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hegaappe guyyiyan, naa77u deeshsha orggeta efiidi, Xoossaa Dunkkaaniyaa penggen GODAA sinttan esso. ");
INSERT INTO wal_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Yaatidi he naa77u deeshshatun saamaa yeggo; yeggin issoi GODAASSA; issoi qassi bazzo yeddiyoogaa gidees. ");
INSERT INTO wal_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aarooni GODAASSI saamai kiyido deeshshaa ehiidi, nagaraa yarshsho oottidi yarshsho. ");
INSERT INTO wal_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","SHin bazzo yeddiyo saamai kiyido deeshshaa paxa de7ishin GODAASSI shiishsho; bazzo a yedettiyo wode, asaa nagaraa atto giissees. ");
INSERT INTO wal_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aarooni ba nagaraanne ba so asaa nagaraa atto giissanau, issi mirgguwaa nagaraa yarshsho oottidi shiishsho. Yaatidi ba nagaraa yarshshuwaassi he korimaa shukko. ");
INSERT INTO wal_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Qassi GODAA sinttan de7iya yarshshiyoosaappe ixaanaa cuwayiyo miishshaa kumettaa bonqquwaanne, liiqi gaacettida naa77u zolle sawiya ixaanaa ekkidi, magalashuwaa giddo eho. ");
INSERT INTO wal_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ehiidi i haiqqennaadan, ixaanaa cuwai Taabootaa bollan de7iya atto giyo sohuwaa qum77uwaa kammana mala, ixaanaa GODAA sinttan de7iya taman wotto. ");
INSERT INTO wal_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Qassi he mirgguwaa suuttaappe guuttaa ekkidi, ba giddo biradhdhiyaa an naaqqidi, atto giyo sohuwaa qum77uwau sintta baggaa caccafo; qassi atto giyo sohuwaa qum77uwaappe sintta baggaara de7iya sohuwaakka laapputoo caccafo. ");
INSERT INTO wal_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Hegaappe guyyiyan asaa nagaraa yarshshuwaassi gidiya deeshshaa shukkidi, a suuttaa magalashuwaa giddo eho; ehiidi mirgguwaa suuttaa caccafidoogaadan, atto giyo sohuwaa qum77uwaa sinttaanne atto giyo sohuwaa qum77uwaappe sintta baggaara de7iya sohuwaa caccafo. ");
INSERT INTO wal_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Yaatidi Ubbaappe Aadhdhida Geeshsha Sohuwaa Israa7eela asaa tunatettaappenne nagaraappe geeshshees. Qassi eti tunabaa oottishin, eta giddon de7iya Xoossaa Dunkkaaniyaakka hegaadan oottidi geeshsho. ");
INSERT INTO wal_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","I Ubbaappe Aadhdhida Geeshsha Sohuwaa gelidi, ba nagaraa, ba so asaa nagaraanne kumetta Israa7eela asaa nagaraa atto giissidi kiyana gakkanaashin, ooninne Xoossaa Dunkkaaniyaa giddon de7oppo. ");
INSERT INTO wal_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Hegaappe guyyiyan i GODAA sinttan de7iya yarshshiyoosaa kiyidi a geeshsho. Korimaa suuttaappenne deeshshaa suuttaappe guuttaa guuttaa ekkidi, yarshshiyoosaa yuushuwan de7iya kaceta tiyo. ");
INSERT INTO wal_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Qassi he suuttaappe guuttaa ba biradhdhiyan ekkidi, laapputoo caccafidi, Israa7eela asaa tunatettaappe he yarshshosaa geeshsho. ");
INSERT INTO wal_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Aarooni Ubbaappe Aadhdhida Geeshsha Sohuwaa, Xoossaa Dunkkaaniyaanne yarshshiyoosaa geeshshiyo wogaa polidoogaappe guyyiyan, paxa de7iya deeshshaa shiishsho. ");
INSERT INTO wal_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","SHiishshidi Aarooni ba naa77u kusheta paxa de7iya deeshshaa huuphiyan wottidi, Israa7eela asaa naaquwaa ubbaa, eta makkala ubbaa, eta nagara ubbaa paaxo; yaatidi he deeshshaa huuphiyan hegaa toosso; toossidi he deeshshaa efaanaadan giigissido asa bollan bazzo yeddo. ");
INSERT INTO wal_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","I deeshshaa bazzo yeddin, deeshshai eta nagara ubbaa tookkidi, asi bainna sohuwaa bazzo bo. ");
INSERT INTO wal_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Hegaappe guyyiyan, Aarooni Xoossaa Dunkkaaniyaa bo; biidi Ubbaappe Aadhdhida Geeshsha Sohuwaa gelido wode, kase ba maayido liinuwaappe oosettida maayuwaa qaaridi hegan wotto. ");
INSERT INTO wal_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Geeshsha sohuwan i ba bollaa haattan meecettidi, hara maayuwaa maayidi kiyo; yaatidi xuuggiyo yarshshuwaa baagaanne asaagaa yarshshidi, ba nagaraanne asaa nagaraa atto giissees. ");
INSERT INTO wal_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Qassi hegaadankka nagaraa yarshshuwaa handdaa yarshshiyoosaa bollan wottidi xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Bazzo yeddiyo deeshshaa efiida bitaneekka ba maayuwaa meecco; ba bollaakka haattan meecetto. Yaati simmidi dunkkaanidosaa yo. ");
INSERT INTO wal_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Nagaraa atto giissanau Aarooni Ubbaappe Aadhdhiya Geeshsha Sohuwaa gelido wode, nagaraa yarshshuwaa mirgguwaa suuttaanne deeshshaa suuttaa ekkidi geliis; ha77i intte he mirgguwaanne he deeshshaanne dunkkaanidosaappe gaxi kessite. Kessidi eta galbbaa, eta ashuwaanne eta tociyaa taman xuuggite. ");
INSERT INTO wal_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hegaa taman xuuggida bitanee ba maayuwaa meecco; ba bollaakka haattan meecetto; Hegaappe guyyiyan, dunkkaanidosaa yo. ");
INSERT INTO wal_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Hagee intteyyo merinaukka woga gido: laappuntta aginai gelido tammantta gallassan intte huuphiyaa kaushshite; Israa7eela asaa gidin woi qassi intte giddon de7iya hara biitta asa gidinkka, ai oosonne oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Aissi giikko, inttena geeshshanau, intte nagaraa atto giissiyo gallassai he gallassa. Inttekka GODAA sinttan intte nagara ubbaappe geeyana. ");
INSERT INTO wal_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hegee intte waanna shemppuwaa shemppiyo sambbata gallassa. He gallassan intte huuphiyaa kaushshite; hegee intteyyo merinaukka woga gido. ");
INSERT INTO wal_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Qassi ba aawaa sohuwan qeese gidanaadan tiyettiyaanne dummatiya asi geeshsha gidida liinuwaappe dadettida maayuwaa maayidi, nagaraa atto giissiyo wogaa polo. ");
INSERT INTO wal_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","I Ubbaappe Aadhdhiya Geeshsha Sohuwaa, Xoossaa Dunkkaaniyaa, yarshshiyoosaa, qeesetanne Israa7eela asaa ubbaa geeshsho. ");
INSERT INTO wal_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Israa7eela asaa nagaraa ubbaa atto giissiyo wogaa intte laittan laittan issitoo oottanaadan, hagee intteyyo merinaukka woga gido” yaagiis. Yaagin Muusee GODAI azazidoogaadan oottiis. ");
INSERT INTO wal_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Aaroonassi a attuma naatussinne Israa7eela asa ubbaassi hagaadan yaagada oda; ‘GODAI azazidoogee hagaa: ");
INSERT INTO wal_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Israa7eela asaappe ooninne boora woi dorssa woi deeshsha Godaassi imota oottidi immanau Xoossaa Dunkkaaniyaa pengge, Godaa sintti eheennan, ba dunkkaanidosan woikko dunkkaanidosaappe gaxan shukkikko, he suuttan i oishettees; he asi suuttaa gussiis. Hegaa gishshau i ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Hegaa gishshau Israa7eela asai bantta yarshshuwaa mehiyaa coo dembban shukkiyoogaa aggidi, haa GODAAKKO, Xoossaa Dunkkaaniyaa penggen de7iya qeesiyaakko ehoona. Ehin qeesee hegaa ekkidi, GODAASSI issippetettaa yarshsho oottidi shukko. ");
INSERT INTO wal_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Qassi qeesee Xoossaa Dunkkaaniyaa penggen de7iya GODAAYYO yarshshiyoosaa bollan he suuttaa caccafo; handdaakka GODAAYYO sawuwaa tonggu giya yarshsho oottidi xuuggo. ");
INSERT INTO wal_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Israa7eela asai GODAA kaalliyoogaa aggidi kaallido daidanttatuyyo naa77antto bantta yarshshuwaa yarshshoppona. Hagee etayyoonne yiya yeleta ubbaayyo merinau woga gido’ yaaga. ");
INSERT INTO wal_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Eta hagaadan yaaga; ‘Israa7eela asaappe gidin woi eta giddon de7iya hara biitta asappe gidinkka, ooninne xuuggiyo yarshshuwaa woi hara yarshshuwaa shiishshiyo wode, ");
INSERT INTO wal_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","GODAASSI yarshshanau Xoossaa Dunkkaaniyaa pengge ehaana xayikko, he asi ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘Israa7eela asaappe woikko eta giddon de7iya hara biitta asaappe ooninne suutta miikko, he suuttaa miya asa bollan taani ta sinttaa tukkana; taani he bitaniyaa asaa giddon bohana. ");
INSERT INTO wal_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Aissi giikko asho maayida ubbaa de7oi a suuttaa giddon de7ees; suuttaikka qassi de7oi a giddon de7iyoogaappe denddidaagan nagaraa atto giissiyaagaa gidiyo gishshau, intte nagaraa atto giissanaadan, taani intteyyo yarshshiyoosaa bollan yarshshanaadan immaas. ");
INSERT INTO wal_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Hegaa gishshau taani Israa7eela asaa, “Intteppe woikko intte giddon de7iya hara biittaa asaappe ooninne suutta mooppo” yaagaas. ");
INSERT INTO wal_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“‘Israa7eela asaappe woikko eta giddon de7iya hara biittaa asaappe ooninne miyo do7a woi kafo shankkatidi worikko, a suuttaa sa7an gussidi, biittaa kammo. ");
INSERT INTO wal_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Aissi giikko asho maayida ubbaa de7oi a suuttaa giddoona. Hegaa gishshau taani Israa7eela asaa, “Asho maayida meretaa ubbaa de7oikka a suuttaa giddon de7iyo gishshau, suuttaa mooppite; qassi miya ooninne ba asaa giddoppe bohetto” yaagaas. ");
INSERT INTO wal_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“‘Israa7eela asa gidin woikko eta giddon de7iya hara biitta asa gidin, ooninne bauta woi do7i oiqqidi woridobaa ashuwaa miikko, ba maayuwaa meecco; ba bollaakka meecetto; yaatidi omarssi gakkanaashin i tuna. Hegaappe guyyiyan, i geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ba maayuwaa meeccana xayikko, ba bollaakka meecettana xayikko, ba nagaraa i bau tookkees’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Israa7eela asaa hagaadan yaaga; ‘Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Intte kase de7ido Gibxxe biittaa asai oottiyoogaadan oottoppite; woikko ha77i taani inttena efiyo Kanaane biittaa asai oottiyoogaadankka oottoppite; eta wogaakka kaalloppite. ");
INSERT INTO wal_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Intte ta azazuwaa oottite; ta wogaakka naagite; qassi an biite. Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Hegaa gishshau ta azazuwaanne ta wogaa naagikko, intte paxa de7ana. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“‘Intteppe ooninne ashuwaa amuwaa polanau ba mata dabboora zin77oppo. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ne ashuwaa amuwaa polanau ne aayeera zin77oppa; zin77ada ne aawaa kaushshoppa. A ne aayyiyo; iira zin77oppa. ");
INSERT INTO wal_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ne ashuwaa amuwaa polanau ne aawaa machcheera zin77oppa; zin77ada ne aawaa kaushshoppa. ");
INSERT INTO wal_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“‘Ne ashuwaa amuwaa polanau ne michcheera zin77oppa; woi qassi son yelettida woi karen yelettida ne aawaa woi ne aayee na7eerakka zin77oppa. ");
INSERT INTO wal_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“‘Ne ashuwaa amuwaa polanau ne na7aa na7eera woikko ne na7ee na7eera zin77oppa. Zin77ikko ne huuphen nena kaushshaasa. ");
INSERT INTO wal_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ne ashuwaa amuwaa polanau ne aawaa keettaayee na7eera zin77oppa; a ne michchiyo gidiyo gishshau iira zin77oppa. ");
INSERT INTO wal_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ne ashuwaa amuwaa polanau ne aawaa michcheera zin77oppa. A ne aawau mata dabbo. ");
INSERT INTO wal_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ashuwaa amuwaa polanau ne aayee michcheera zin77oppa; a ne aayeessi mata dabbo. ");
INSERT INTO wal_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ne aawaa ishaa kalluwaa qaarada ne ashuwaa amuwaa polanau a machcheera zin77oppa; a ne aawaa ishaa machchiyo. ");
INSERT INTO wal_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ne ashuwaa amuwaa polanau ne na7aa keettaayeera zin77oppa; a ne na7aa keettaayyiyo gidiyo gishshau, iira zin77oppa. ");
INSERT INTO wal_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ne ashuwaa amuwaa polanau ne ishaa keettaayeera zin77oppa; zin77ikko ne ishaa kaushshaasa. ");
INSERT INTO wal_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“‘Ne ashuwaa amuwaa polanau maccaaseeranne i na7eeranne naa77aara zin77oppa. I na7ee na7eera woi qassi i na7aa na7eerakka zin77oppa; eti iyyo mata dabbo gidiyo gishshau, hegee shaaramuxa. ");
INSERT INTO wal_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“‘Ne keettaayyiyaa paxa de7ishin, ne keettaayee michchiyo dawuttada ne ashuwaa amuwaa polanau iira zin77oppa. ");
INSERT INTO wal_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“‘Ne ashuwaa amuwaa polanau kushe qitai yin tuna uttida maccaaseera zin77oppa. ");
INSERT INTO wal_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“‘Neeni tunennaadan ne shooruwaa keettaayeera zin77oppa. ");
INSERT INTO wal_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“‘Ne Xoossaa sunttaa tunissanau ne naatuppe issuwaanne taman xuuggidi, Molooka giyo eeqaassi yarshshanaadan immoppa. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“‘Maccaasaara zin77iyoogaadan attuma asaara zin77oppa; hegee sheneyiyaabaa. ");
INSERT INTO wal_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“‘Neeni tunennaadan ai meheeranne zin77oppa, qassi maccaasikka meheera zin77anau mehe sintti aadhdhoppo. Hegee wogi bainnabaa. ");
INSERT INTO wal_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“‘Taani intte sinttappe yedettiyo kawotettati ha oosotun tunido gishshau, intte hageeta milatiyaabatun tunoppite. ");
INSERT INTO wal_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Harai atto eta biittaikka tunido gishshau, a nagaraassi taani a qaxxayaas; qaxxayin biittaikka banan de7iyaageeta cuchchiis. ");
INSERT INTO wal_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","SHin intte ta higgiyaanne ta azazuwaa naagiteppe attin, Israa7eela asaa gidin woi intte giddon de7iya hara biitta asappe ooninne hagaa mala tuna oosuwaa oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","“‘Intteppe kase ha biittan de7ida asati hagaa mala tunabaa oottido gishshau, biittai tuniis. ");
INSERT INTO wal_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Intte ha biittaa tunissikko, intteppe kase de7ida kawotettata ha biittai cuchchidoogaadan, inttenakka cuchchennaadan naagettite. ");
INSERT INTO wal_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Hageeta milatiya tuna oosotuppe issuwaanne oottiya asi de7ikko, he asi ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“‘Hegaa gishshau intteppe kase de7ida asati oottido tuna oosota ubbaa oottidi intte tunennaadan, intte ta azazuwaa naagite; taani, GODAI, intte Xoossaa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Israa7eela asau ubbau hagaadan yaagada yoota; ‘Taani, GODAI, intte Xoossai geeshsha gidiyo gishshau, inttekka geeshsha gidite. ");
INSERT INTO wal_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“‘Intteppe issoinne attennan ba aawaanne ba aayyiyo bonchcho; ta Sambbatatakka bonchchite. Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“‘Tana aggidi eeqatuyyo goinnoppite; woi qassi birataappe seerissidi, xoossata intteyyo medhdhoppite. Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“‘Intte issippetettaa yarshshuwaa GODAAYYO yarshshiyo wode, he yarshshoi intte gishshaa ekettanaadan, bessiyaagaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","He yarshshoi intte yarshshido gallassan woikko wonttetta gallassan meetetto; heezzantto gallassai gakkanaashin attidaagee de7ikko hegee xuugetto. ");
INSERT INTO wal_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Heezzantto gallassan a miikko, hegee sheneyiyaabaa; taani hegaa ekkikke. ");
INSERT INTO wal_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Hegaa miya ooninne ba nagaran i bau oishettana; aissi giikko, i GODAAYYO geeshsha gididabaa tunissiis. He asi ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘Intte biittan mokkida kattaa intte cakkiyo wode, gadiyaa gaxaa gakkanaashin cakkoppite; qassi cahaappe simmin de7iya poshiluwaakka poshiloppite. ");
INSERT INTO wal_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ne woiniyaa aifiyaa mule maxada mittaa polloyoppa; sa7an wodhdhida woiniyaa aifiyaakka maxoppa; hegaa hiyyeesatussinne betetussi aggaaga. Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘Intte wuuqqoppite. “‘Worddotoppite. “‘Issoi issuwaa cimmoppite. ");
INSERT INTO wal_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“‘Ta sunttan wordduwan caaqqoppite; yaatidi intte Xoossaa sunttaa tunissoppite. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“‘Ne shooruwaa sugoppa; woikko bonqqoppa. “‘Keraa oottiya bitaniyaa damoozaa diggada, issi qammaanne ne matan aissoppa. ");
INSERT INTO wal_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“‘Tulliyaa qanggoppa; woi qassi qooqiyaa sinttan xubbiyaabaa wottoppa; shin neeni Xoossaassi yayya. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘Pirddaa pirddaidda geellayoppa; hiyyeesaa a hiyyeesatettaa gishshau maaddada pirddoppa; duriyaakka a duretettaa gishshau yayyada aggoppa. SHin ne shooruwaayyo tumatettan pirdda. ");
INSERT INTO wal_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“‘Ne asaa giddon iita zigirssaa ekkada yuuyoppa. “‘Ne shooruwaa woriyoobaa aibanne oottoppa. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘Ne ishaa ne wozanan ixxoppa. “‘Ne shooruwaa gaasuwan neeni nagara oottenna mala, a seera. ");
INSERT INTO wal_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“‘Haluwaa kiyoppa; qassi ne asaappe issuwaayyoonne uluwan lancce oiqqoppa. SHin ne shooruwaa ne huuphedan siiqa. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“‘Ta azazota naaga. “‘Ne mehiyaappe issi qommo mehiyaa hara qommo dumma mehiyan birasissoppa. “‘Issi shooqan naa77u qommo zerettaa zeroppa. “‘Qassi naa77u qommobaappe dadettida maayo maayoppa. ");
INSERT INTO wal_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘Issi asi hara asa gelanau giiga uttida danggiriixeera zin77ikko, qassi he danggiriixiyaakka ba danggiriixetettaappe wozettabeennaaro gidikko, eti qaxxayettanau bessees; shin a ba danggiriixetettaappe wozettabeenna gishshau, eta woranau koshshenna. ");
INSERT INTO wal_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Gidikkonne he bitanee ba naaquwaa yarshshuwaassi gidiya dorssaa Xoossaa Dunkkaaniyaakko GODAA sintti eho. ");
INSERT INTO wal_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Ehobare qeesee he naaquwaa yarshshuwaa dorssaa ekkidi, bitanee oottido nagaraa GODAA sinttan atto giissees; i oottido nagaraikka atto geetettana. ");
INSERT INTO wal_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘Intte Kanaane biittaa geliyo wode, aifiyaa miyo ai qommo mitta tokkikkokka, he mittaa aifiyaa meetettennabaadan qoodite; heezzu laittai wuranaashin he mittaa aifee meetettenna; a mooppite. ");
INSERT INTO wal_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Oiddantta laittan he mittaa aifee ubbai GODAASSI galatau shiishshiyo geeshsha yarshsho gidana. ");
INSERT INTO wal_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","SHin he mittaa aifee intteyyo keehi darana mala, ichchashantta laittaa aifiyaa miite. Intte hagaadan oottikko, intte mittaa aifee darana. Taani GODAI intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘Suuttai a giddon de7iyo ai ashokka mooppite. “‘Kaayoppite woi shareechchoppite. ");
INSERT INTO wal_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“‘Intte huuphiyaa binnaanaa garssaara yuushshi aattidi qanxxoppite; qassi intte buuchchaakka yuushshi aattidi qanxxoppite. ");
INSERT INTO wal_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“‘Haiqqida asa gishshau intte bollaa qanxxerettoppite; woikko cachchaa malaataa intte bollan kessoppite. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“‘Biittai shaaramuxaa tunatettan kumidaagaa gidenna mala, ne na7iyo shaaramuxaa oosuwaassi aatta immada tunissoppa. ");
INSERT INTO wal_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“‘Ta Sambbatata bonchchite; taayyo goinniyo sohuwaakka bonchchite. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“‘Moitilliyaa haasayissiyaageetukkonne shareechchotukko booppite; intte tunenna mala eta koyyoppite. Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘Puulummida asanne cimida asa be7iyo wode uttidosaappe dendda eqqa; eta bonchcha; ne Xoossaassi yayya. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“‘Intte biittan inttenaara de7iya betetu bollan sugettabaa oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Intte biittan inttenaara de7iya bete asa intte biittaa asadan xeellite; a intte huuphedan siiqite. Aissi giikko, inttekka kase Gibxxe biittan bete gididi de7ideta. Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“‘Intte pirddan likkiyooban, meezaanan wottidi kiliyoobaaninne makkiyooban worddotoppite. ");
INSERT INTO wal_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Intte kiliyo meezaanai, intte makkiyoobainne likkiyo miishshati ubbai likke gidona. Taani inttena Gibxxe biittaappe kessada ehiida GODAA intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Intte ta higgiyaanne ta azazuwaa ubbaa naagitenne oottite. Taani GODAA’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Israa7eela asau hagaadan yaagada yoota, ‘Israa7eela asaappe gidin, woi betidi yiidi Israa7eela giddon de7iya hara biitta asaappe gidinkka, ooninne ba naatuppe issuwaa Molooka giyo eeqaayyo aattidi immikko, he asi haiqqo; he biittaa asai a shuchchan caddidi woro. ");
INSERT INTO wal_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Taani he bitaniyaa morkkana; a asaa giddoppe shoddada a xaissana. Aissi giikko, i ba naatuppe issuwaa Molooka giyo eeqaayyo immiyoogan, ta Dunkkaaniyaa tunissiis; ta geeshsha sunttaakka kaushshiis. ");
INSERT INTO wal_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","He bitanee ba naatuppe issuwaa Molookassi immiyo wode, he biittaa asai be7iiddi, shenehoo giikko, qassi bitaniyaakka worennan aggikko, ");
INSERT INTO wal_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","taani ta huuphen he bitaniyaanne asaa morkkana; anne Molookaara shaaramuxanau a kaalliya ubbata eta asaa giddoppe bohite. ");
INSERT INTO wal_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘Ai asinne tanan ammanettennan ixxidi, moitilliyaa haasayissiyaageetanne shareechchota oichchanau biikko, taani a morkkana; a asaa giddoppekka a xaissana. ");
INSERT INTO wal_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“‘Taani, GODAI, intte Xoossaa gidiyo gishshau, simmi intte inttena dummayite; qassi geeshsha gidite. ");
INSERT INTO wal_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ta higgiyaa naagitenne oottite. Taani inttena geeshshiya GODAATTENNEE. ");
INSERT INTO wal_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“‘Ai asinne ba aawaa woikko ba aayyiyo cayikko haiqqo. I ba aawaa woikko ba aayyiyo cayido gishshau, a suuttaa acoi a bollaana. ");
INSERT INTO wal_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“‘Issi asi ba shooruwaa keettaayeera zin77ikko, he zin77ida bitaneenne mishiriyaa naa77aikka haiqqona. ");
INSERT INTO wal_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ba aawaa keettaayeera zin77ida asi ba aawaa kaushshiis; eti naa77aikka haiqqona. Eta suuttaa acoi eta bollaana. ");
INSERT INTO wal_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Issi asi ba na7aa keettaayeera zin77ikko, eti naa77aikka haiqqona. Eti tunabaa oottidosona. Eta suuttaa acoi eta bollaana. ");
INSERT INTO wal_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“‘Issi attuma asi maccaasaara zin77iyoogaadan attuma asaara zin77ikko, eti naa77aikka tunabaa oottido gishshau haiqqona. Eta suuttaa acoi eta bollaana. ");
INSERT INTO wal_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Issi asi na7iyoonne aayyiyoonne issippe machchiyaabaa gidikko, hegee tunabaa; intte giddon tunatetti de7enna mala, inne etinne taman xuugettona. ");
INSERT INTO wal_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“‘Issi asi meheera zin77ikko, i haiqqo; he macca mehiyookka worite. ");
INSERT INTO wal_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Issi maccaasi meheera zin77ikko he maccaasiyoonne he mehiyaa naa77aakka worite; eti haiqqona. Eta suuttaa acoi eta bollaana. ");
INSERT INTO wal_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“‘Issi asi ba michchiyo ba aawaa na7iyo woikko ba aayee na7iyo machchidi, iira zin77ikko, hegee pokkoba. Eti bantta asaa sinttan haiqqona. I ba michchiyo kaushshido gishshau, ba nagaran bau oishettana. ");
INSERT INTO wal_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Issi asi kushe qitai yiido maccaasee kalluwaa qaaridi iira zin77ikko, eti naa77aikka bantta asaa giddoppe bohettona. Aissi giikko i i suuttai goggiyo pulttuwaa kalloyiis; akka ba suuttai goggiyo pulttuwaa kalloyaasu. ");
INSERT INTO wal_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“‘Ne aayee michcheera woikko ne aawaa michcheera zin77oppa; aissi giikko, hegaa oottiyoogee ba mata dabbuwaa kaushshiyoogaa. Intte naa77aikka intte nagaran oishettana. ");
INSERT INTO wal_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Issi asi ba aawaa ishaa keettaayeera zin77ikko, i ba aawaa ishaa kaushshiis. Eti bantta nagaran banttau oishettana; eti naa77aikka na7a yelennan haiqqana. ");
INSERT INTO wal_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Issi asi ba ishaa keettaayyiyo machchikko, hegee tunatetta. I ba ishaa kaushshiis; eti naa77aikka na7a yelokkona. ");
INSERT INTO wal_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“‘Simmi intte de7anaadan, taani inttena gelissiyo biittai inttena cuchchenna mala, intte ta higgiyaanne ta azazuwaa naagitenne oottite. ");
INSERT INTO wal_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Taani intte sinttappe xaissiyo asatu de7uwaa wogaa kaalloppite. Eti hagaa ubbaa oottido gishshau, taani eta shenetaas. ");
INSERT INTO wal_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","SHin taani inttena, “Eta biittaa intte laattana; intte he biittaa inttebaa oottanaadan, he maattainne eessai goggiyo biittaa taani intteyyo immana” yaagaas. Taani inttena hara asatuppe dummaya kessida GODAA intte Xoossaattennee. ");
INSERT INTO wal_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“‘Hegaa gishshau intte geeshsha gidida mehetanne kafota geeshsha gidennaageetuppe shaakkidi erite. Taani hageeti intteyyo tuna ga wottido mehetun, kafotuuninne biittan qaaxerettiyaabatun ubban intte huuphiyaa tunissoppite. ");
INSERT INTO wal_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Taani GODAI geeshsha gidiyo gishshaunne intte tabaa gidana mala inttena hara asaappe dummayido gishshau, inttekka taayyo geeshsha gidite. ");
INSERT INTO wal_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“‘Issi attuma asi woikko macca asi moitilliyaara haasayiyaagaa woikko shareechcho gidikko, eti haiqqanau bessees. Eti shuchchan cadettona. Eta suuttaa acoi eta bollaana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","GODAI Muusa hagaadan yaagiis, “Qeese gidiya Aaroona attuma naatussi hagaadan yaagada oda; ‘Intteppe ooninne ");
INSERT INTO wal_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ba mata dabbo, ba aayee, ba aawaa, ba attuma na7aa, ba macca na7ee, ba ishaa, ");
INSERT INTO wal_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","woikko azina gelennan, a son de7iya ba michchee ahaa gidana xayikko, haiqqida asa ahaa oogaanne bochchidi, bana tunissoppo. ");
INSERT INTO wal_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Qassi ekuwaaninne geluwan dabbotida asa ahaa bochchidikka bana tunissoppo. ");
INSERT INTO wal_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“‘Qeeseti haiqqidabau kayyottanau bantta huuphiyaa meedettoppona; bantta buuchchaakka qanttan qanxxoppona; woi qassi bantta bollaakka qanxxerettoppona. ");
INSERT INTO wal_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Eti bantta Xoossaayyo geeshsha gidona; qassi bantta Xoossaa sunttaakka tunissoppona. Aissi giikko eti GODAAYYO taman xuuggidi yarshshiyo, qumaa yarshshuwaa shiishshiyaageeta; hegaa gishshau, eti geeshsha gidanau bessees. ");
INSERT INTO wal_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“‘Qassikka qeeseti shaaramuxa maccaasa, geela7otettai ekettiichchido maccaasa, woikko azinai yeddido maccaasa ekkoppona. Aissi giikko, qeeseti bantta Xoossaayyo geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Qeesee intte Xoossaassi qumaa yarshshuwaa shiishshiyaagaa gidiyo gishshau, i hara asaappe dummato. Taani inttena geeshshiya intte GODAI geeshsha gidiyo gishshau, ikka geeshsha gido. ");
INSERT INTO wal_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ai qeesiyaa na7iyo gidikkokka shaaramuxada bana tunissikko, hinna ba aawaa kaushshaasu. A taman xuugettada haiqqu. ");
INSERT INTO wal_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘Qeese ubbatu halaqai, a huuphiyan tiyettiyo zaitee gukkido gishshaunne i qeesetettaa maayuwaa maayanau dummatida asa gidiyo gishshau, ba huuphiyaa binnaanaa kallo wottoppo; woikko ba maayuwaakka pooshshoppo. ");
INSERT INTO wal_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ai ahaa gidikkokka, de7iyoosaa i geloppo; harai atto ba aawaa woikko ba aayee ahaa gidikkokka, bana hegan tunissoppo. ");
INSERT INTO wal_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","A geeshshanau tiyiyo Xoossaa zaitee a bollan de7iyo gishshau, qeesee Xoossaa Dunkkaaniyaappe kiyoppo; Xoossaa Dunkkaaniyaakka tunissoppo. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“‘Qeesee geela7o macca na7a ekko. ");
INSERT INTO wal_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Azinai haiqqido maccaasiyo, woi azinai yeddido maccaasiyo, woi shaaramuxa maccaasiyo machchoppo. SHin ba asaa giddoppe geela7o macca na7a dooridi machcho. ");
INSERT INTO wal_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Yaanana xayikko, i ba asaa giddon ba zeretta gidiya ba naata tunissana. Taani a geeshshiyaagee, GODAATTENNEE’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","GODAI Muusa, hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Neeni Aaroonassi hagaadan yaagada oda; ‘Sinttaara yiya ne zerettaappe bollai tilla gidenna asi ooninne qumaa yarshshuwaa taayyo immanau shiiqoppo. ");
INSERT INTO wal_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Aissi giikko bollai tilla gidenna asi ooninne shiiqanau bessenna. Qooqe, woikko wobbe, woi som77oi narphphettido, woi palaha bollai de7iyo asi, ");
INSERT INTO wal_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","woi toho woi kushe silai, ");
INSERT INTO wal_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","woi quunai, woi dinkkee, woi aifee sakkiyo asi, woi puusoi oiqqido asi, woi ilahai oiqqido asi, woi mureessa gidinkka bollai tilla gidenna asi, ooninne shiiqoppo. ");
INSERT INTO wal_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Qeesiyaa Aaroona zariyaappe bollai tilla gidenna asi ooninne GODAAYYO taman xuuggiyo yarshshuwaa shiishshanau shiiqoppo. Ayyo bollai tilla gidennaagaa gidaappe hini baggan, ba Xoossaassi qumaa yarshshuwaa shiishshanau i bessenna. ");
INSERT INTO wal_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","I geeshsha qumaanne qassi ubbappe aadhdhiya geeshsha gidiya ba Xoossaa qumaa maanau danddayees. ");
INSERT INTO wal_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","SHin ayyo bollai tilla gidenna gishshau, i ta Dunkkaaniyaa tunissennaadan, magalashuwaakko woi yarshshiyoosaakko shiiqoppo. Aissi giikko, eta geeshshiyaagee taani GODAATTENNEE’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Yaagin Muusee Aaroonassi, a attuma naatussinne Israa7eela asaassi ubbaassi hagaa yootiis. ");
INSERT INTO wal_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Ta geeshsha sunttaa eti tunissenna mala, Israa7eela asai taayyo dummayido imota Aarooninne a attuma naati bonchchuwan ekkidi, geeshshatettan naagana mala, etau yoota. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Etau hagaadan yaaga; ‘Sinttaara yiya yeleta ubban intte zariyaappe ooninne tuni uttidi, Israa7eela asai GODAAYYO dummayido geeshsha yarshshuwaakko shiiqikko, he asi ta sinttaappe xayo. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“‘Aaroona zariyaappe hanttaara goga harggee de7iyo, woikko bollaappe aibakko goggiyo ooninne geeyana gakkanaashin, geeshsha yarshshuwaappe mooppo. Ahaa bochchidi tunidabaa woikko a attumatettaappe zeretti gukkido ura bochchiya ooninne tuna. ");
INSERT INTO wal_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Woi qassi sa7aara gooshettiya, tunissiyaabata, woi ai mala tunatetta gidikkonne tunissiya asa bochchiya uri, ");
INSERT INTO wal_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","woi hegaa malabaa aibanne bochchiya asi, omarssi gakkanaashin i tuna; ba bollaa haattan meecettennan de7iiddi, he geeshsha yarshshuwaappe i maanau koshshenna. ");
INSERT INTO wal_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Awai wulliyo wode i geeshsha gidees; Hegaappe guyyiyan, he geeshsha yarshshuwaappe bana gakkiyaagaa mo. ");
INSERT INTO wal_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Bau haiqqidabaa woikko do7i worido mehe asho mooppo; hegee tunissiyaabaa. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“‘Qeeseti ta wogaa naagona; naagennan ixxikko, eti a tunissidi a nagaran haiqqana. Eta geeshshiyaagee taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“‘He geeshsha yarshshuwaa qeesiyaa so asaappe attin, hara asi mooppo; qeesiyaa so yiida imattaa gidin, woi qaxarettidi oottiya ashkkara gidinkka mooppo. ");
INSERT INTO wal_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","SHin qeesee ba biran shammido aillee woikko a son yelettida aillee he qumaappe mo. ");
INSERT INTO wal_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Qeese gidenna hara asa gelida qeesiyaa na7iyaa he geeshsha yarshshuwaappe muuppu. ");
INSERT INTO wal_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","SHin qeesiyaa na7iyaa azini haiqqin, woikko azini yeddin, na7a yelennan kase ba geela7otettan de7iyoogaadan simmada ba aawaa soo yiikko, a ba aawaa gakkiya qumaappe mu. SHin hara asi ooninne hegaappe mooppo. ");
INSERT INTO wal_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“‘Issi asi erennan de7iiddi geeshsha yarshshuwaappe miikko, he i miido qumaa waagaa bolli xeetaappe laatamu kushiyaa gujjidi qeesiyaassi immo. ");
INSERT INTO wal_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Israa7eela asai GODAASSI yarshshiyo geeshsha yarshshuwaa qeeseti tunissoppona. ");
INSERT INTO wal_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Eti bantta ehiido geeshsha yarshshuwaa banttau miidi, bantta nagaran oishettanaadan, qeeseti oottanau koshshenna. Aissi giikko, eta geeshshiyaagee, taani GODAA!’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","GODAI Muusa hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Aaroonassi, a naatussinne Israa7eela asa ubbaassi hagaadan yaagada yoota; ‘Israa7eela asaappe gidin woikko eta giddon de7iya betiyaappe ooninne GODAAYYO xuuggiyo yarshshuwaa ba dosan coo immiyo woi ba shiiquwaa gattanau yarshshiyo wode, ");
INSERT INTO wal_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","he yarshshoi ekettana mala, mirgguwaappe woi dorssaappe woikko deeshshappe tilla bollaara de7iya attumaagaa gido. ");
INSERT INTO wal_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Bollai tilla gidennaagee aiba gidikkonne ekettenna gishshau, hegaa shiishshoppa. ");
INSERT INTO wal_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“‘Qassi oona gidikkonne ba shiiquwaa gattanau issippetettaa yarshshuwaa GODAASSI yarshshiyo wode, woi qassi ba mehiyaappe ba dosan coo immiyo imotaa GODAASSI shiishshiyo wode, hegee ekettana mala i tilla bollaara de7iyaagaa gido. ");
INSERT INTO wal_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Intte mehiyaappe qooqiyaa, woi mequwaa, woikko gunddaa, woikko giiyiya masunttai, woikko puusoi, woikko ilahai de7iyoogaa GODAASSI yarshshoppite; qassi taman xuuggiyo yarshsho oottidikka yarshshiyoosaa bollan GODAAYYO shiishshoppite. ");
INSERT INTO wal_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","A bollan palaha meretai woi pacabai de7iyo korimaa woi dorssaa issi asi ba dosan coo immiyo yarshshuwaassi shiishshanau danddayees; shin shiiqo gato gidikko, hegee ekettenna. ");
INSERT INTO wal_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Sanggisettidaagaa woikko qoxettidaagaa woikko kaattai masunxxidoogaa woikko qanxxettidaagaa GODAAYYO yarshshoppite. Intte biittan hegaa malabaa oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Intte giddon de7iya allaga asatuppe ekkido hegaa mala mehiyaakka intte Xoossaassi quma oottidi shiishshoppite. Eta bollai tilla gidennaagaa gaasuwan etan wotoi de7iyo gishshau, eti intte gishshaa ekettokkona’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Qassikka GODAI Muusa hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Miizza mari woi dorssa mari woikko deeshsha mari yelettiyo wode, laappun gallassaa ba aayeera takko. Hosppuntta gallassaappe doommidi, GODAAYYO taman xuuggidi shiishshiyo yarshsho oottidi shiishshanau danddayettees. ");
INSERT INTO wal_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Miizziyo, dorssiyo, woi deeshshiyo i maraara issi gallassi shukkoppite. ");
INSERT INTO wal_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Intte galataa yarshshuwaa GODAAYYO shiishshiyo wode, intte yarshshoi ekettanaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","He yarshshoi he gallassikka meetetti agganau koshshees; appe aibanne wonttossi ashshoppite. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ta azazuwaa naagitenne oottite. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Qassi ta geeshsha sunttaa intte tunissoppite; Israa7eela asaa giddon taani geeshsha gidiyoogee erettanau bessees. Inttena geeshshiyaagee, taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Intteyyo Xoossaa gidanau, inttena Gibxxe biittaappe kessidaagee tana. Taani GODAA” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Israa7eela asaayyo hagaadan yaagada yoota; ‘Geeshsha yaa7a gi awaajjidi, intte bonchchanau bessiya keerettida GODAA baalati hageeta. ");
INSERT INTO wal_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘Intte usuppun gallassaa oosuwaa ootteeta; shin laappuntta gallassi intte shemppiyo Sambbata gallassa; he gallassan geeshsha yaa7aa shiiqite; aiba oosonne oottoppite; intte de7iyo sohuwan ubban hegee GODAASSI Sambbata. ");
INSERT INTO wal_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘Eta wodiyan wodiyan geeshsha yaa7a ootti awaajjidi intte bonchchanau bessiya GODAA baalati hageeta. ");
INSERT INTO wal_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Koiro aginan tammanne oiddantto gallassi sa7ai omariyo wode, GODAA Paasikai doommees. ");
INSERT INTO wal_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“‘Qassi he aginankka tammanne ichchashantto gallassai GODAA Oittaa Baalaa gallassa; hegaa gishshau laappun gallassatun irshshoi gelibeenna oittaa miite. ");
INSERT INTO wal_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","He gallassatuppe koiro gallassan geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Laappun gallassa ubbaa GODAAYYO taman xuuggiyo yarshshuwaa shiishshite; laappuntta gallassan qassi geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Israa7eela asaayyo hagaadan yaagada yoota; ‘Taani intteyyo immiyo biittaa gelidi, intte kattaa cakkiyo wode, he kattau koiro aifiyaa mirqqiyaa qeesiyaakko ekki yiite. ");
INSERT INTO wal_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","GODAI inttebaa ekkana mala, Sambbata wonttetta gallassi qeesee he mirqqiyaa GODAA sinttan pudenne duge wuxaawuxo. ");
INSERT INTO wal_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","He intte mirqqiyaa wuxaawuxido gallassi tilla bollaara de7iya issi laitta dorssa orggiyaa xuuggiyo yarshsho oottidi GODAAYYO shiishshite. ");
INSERT INTO wal_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","He yarshshuwaara issippe wogaraa zaitiyan munaqettida naa77u kilo giraame lo77o xiilliyaa kattaa yarshsho oottidi shiishshite; hegee GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho gidana; hegaarakka qassi issippe issi litiro gidiya woiniyaa eessaa shiishshite. ");
INSERT INTO wal_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ha yarshshuwaa intte intte Xoossaassi shiishshiyo gallassai gakkanaashin, ooratta gakkida kattaappe oittaa, woi xiixaa gidin, qayyiyaa gidinkka mooppite. Hagee intte de7iyoosan ubban sinttaara yiya yeletau ubbau merinau woga. ");
INSERT INTO wal_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘Intte wuxaawuxiyo yarshshuwaa mirqqiyaa ehiido Sambbata wonttettappe doommidi, laappun saamintta kumettaa qoodite. ");
INSERT INTO wal_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Laappuntta Sambbataa wonttetta gallassai gakkanaashin, ishatamu gallassaa qoodidi, ooratta gakkida kattaa yarshshuwaa GODAASSI shiishshite. ");
INSERT INTO wal_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Intte aqiyo sohuwaappe naa77u kilo giraame gidiya lo77o xiilliyaappe irshshuwaa yeggidi uukkido naa77u oittaa wuxaawuxanau ekki yiite. Hegee koiro gakkida kattaa aifiyaappe GODAASSI yarshsho gidees. ");
INSERT INTO wal_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","He oittaara issippe tilla bollaara de7iya issi laitta gidido laappun dorssa marata, issi mirgguwaanne naa77u dorssa orggeta shiishshite. Kattaa yarshshuwaaranne ushshaa yarshshuwaara issippe GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshsho oottidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Qassi issi deeshsha orggiyaa nagaraa yarshshuwaassi, issi laitta gidido naa77u dorssa orggetakka issippetettaa yarshshuwaassi shiishshite. ");
INSERT INTO wal_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“‘Qeesee he koiro gakkida kattaa aifiyaa oittaanne he naa77u dorssata wuxaawuxiyo yarshsho oottidi, GODAA sinttan wuxaawuxees; hegeeti GODAASSI geeshsha; qassi qeesiyaassikka qommo. ");
INSERT INTO wal_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","He gallassikka awaajjidi geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. Hagee intte de7iyoosan ubban sinttaara yiya yeletau ubbau merinau woga. ");
INSERT INTO wal_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“‘Intte biittan mokkida kattaa intte cakkiyo wode, intte shooqaa gaxaa gakkanau cakkoppite; cakkishin attiya poshiluwaakka qoroppite; hegaa hiyyeesatuyyoonne betetuyyo aggiigite. Taani, GODAI, intte Xoossaa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","GODAI Muusa hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Israa7eela asaayyo hagaadan yaagada yoota; ‘Laappuntta aginan koiro gallassaa shemppo gallassaa oottidi bonchchite; hassayissuwaa malkkataikka punettiyo wode, geeshsha yaa7aa shiiqite. ");
INSERT INTO wal_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","He gallassan GODAAYYO taman xuuggiyo yarshshuwaa shiishshiteppe attin, daafurssiya ooso aibanne oottoppite’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","GODAI Muusa hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ha laappuntta aginaayyo tammantta gallassai nagaraa atto giissiyo gallassa; he gallassi geeshsha yaa7aa shiiqite; qassi intte huuphiyaa kaushshite; yaatidi GODAAYYO taman xuuggiyo yarshshuwaa shiishshite. ");
INSERT INTO wal_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","He gallassai GODAA intte Xoossaa sinttan intte nagarai atto geetettana mala, intte nagaraa atto giissiyo gallassa gidiyo gishshau, he gallassi aiba oosonne oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","He gallassi banatettaa kaushshenna asi ooninne ba asaa giddoppe bohetto. ");
INSERT INTO wal_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","He gallassi aiba ooso gidikkonne oottiya asa taani a asaa giddoppe xaissana. ");
INSERT INTO wal_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","He gallassi aiba oosonne oottoppite. Hagee intte de7iyoosan ubban sinttaara yiya yeletau ubbau merinau woga. ");
INSERT INTO wal_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hegee intte waanna shemppuwaa shemppiyo Sambbata gallassa. He gallassan intte huuphiyaa kaushshite. He aginan uddufuntta gallassan omarssaappe doommidi, tammantta gallassaa omarssai gakkanaashin, intte Sambbataa bonchchite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","GODAI Muusa hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Israa7eela asaayyo hagaadan yaagada yoota; ‘Ha laappuntta aginan tammanne ichchashantta gallassaappe doommidi, laappun gallassai GODAAYYO Daase Baala. ");
INSERT INTO wal_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","He gallassatuppe koiro gallassan geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Laappun gallassan ubban GODAAYYO taman xuuggiyo yarshshuwaa shiishshite; hosppuntta gallassan qassi geeshsha yaa7aa shiiqite; GODAAYYO taman yarshshiyo yarshshuwaakka shiishshite. He gallassai intte shiiquwaa poliyo gallassa gidiyo gishshau, daafurssiya ooso aibanne oottoppite. ");
INSERT INTO wal_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“‘Taman xuuggiyo yarshshuwaanne kattaa yarshshuwaa, qassi hara yarshshota ubbaanne ushshaa yarshshuwaa, koshshiyaagaa keenaa keerido gallassan GODAASSI shiishshanau, intte geeshsha yaa7a oottidi awaajjana GODAA baalati hageeta. ");
INSERT INTO wal_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ha baalati GODAA Sambbatatuppe, intte imota oottidi GODAAYYO immiyoobatuppe, shiiquwaa gattiyoobatuppenne intte intte dosan coo immiyoobatuppe dumma. ");
INSERT INTO wal_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“‘Laappuntta aginan tammanne ichchashantta gallassan intte biittan mokkidabaa cakkidi shiishshidoogaappe guyyiyan, GODAA baalaa laappun gallassaa bonchchite; koiro gallassainne hosppuntta gallassai intteyyo waanna shemppo gallassa. ");
INSERT INTO wal_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Koiro gallassan lo77o mittaa aifiyaappe, zambbaa tashiyaappe, irxxa haittaara de7iya mittaa tashiyaappenne shaafa lanqqen dicciya lee7e mittaappe ekkidi, GODAA intte Xoossaa sinttan ufaittiiddi, laappun gallassaa baalaa bonchchite. ");
INSERT INTO wal_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","He baalaa laittan laittan laappun gallassaa GODAASSI bonchchite. Hegee sinttaara yiya yeletau ubbau merinau woga. Intte hegaa laappuntta aginan bonchchite. ");
INSERT INTO wal_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","He laappun gallassaa intte daasiyan de7ite; Israa7eela biitta asa gidiya ubbai daasiyan de7ite. ");
INSERT INTO wal_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Hegee sinttaara yiya yeletai ubbai Israa7eela asaa taani Gibxxeppe kessido wode, eti daasiyan de7anaadan oottidoogaa eranaassa. Taani GODAA intte Xoossaa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Hegaadan oottidi, Muusee GODAA Baalata bonchchiyo wogaa Israa7eela asaayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","2","GODAI Muusa hagaadan yaagiis, “Xomppee to7ennan eexxiiddi de7ana mala, assi koshshiya zaitiyaa wogaraa teeraa caddidi gum77in kiyiya geeshshaa neeyyo ehaana mala, Israa7eelata azaza. ");
INSERT INTO wal_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Xoossaa Dunkkaaniyaa giddon de7iya markkatettaa magalashuwaappe kare baggaara, omarssappe maallado gakkanaashin, Aarooni GODAA sinttan he xomppiyaa ubba wode eetto. Sinttaara yiya yeletau ubbau hegee merinau woga. ");
INSERT INTO wal_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Xomppiyaa wottiyo, walahi bainna worqqa ballaa bolli de7iya xomppeti GODAA sinttan ubba wode eexxanaadan Aarooni naago. ");
INSERT INTO wal_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Tammanne naa77u kilo giraame gidiya liiqo xiilliyaa ekkada 12 oittaa uukka. ");
INSERT INTO wal_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","He oittata usuppunaa usuppunaa naa77u maaran GODAA sinttan de7iya walahi bainna worqqa xaraphpheezaa bollan wotta. ");
INSERT INTO wal_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","GODAASSI taman xuugganau shiishshido qumaa yarshshuwaa gidiyoogaa erissanau, naa77u maaratu lanqqiyan lanqqiyan geeshsha ixaanaa wotta. ");
INSERT INTO wal_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ha oittaa Sambbatan Sambbatan ubba wode Aarooni GODAA sinttan Israa7eela asaa gishshaa wotto. Hegee Israa7eela asai ubba wode oottanau koshshiya qaalaa maachchaa. ");
INSERT INTO wal_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Hegee Aaroonassinne a attuma naatussi imetto; i GODAASSI taman xuuggiyo yarshshuwaappe wogaadan Aaroonanne a naata gakkiya ubbaappe aadhdhiya geeshsha shaaho gidiyo gishshau, eti hegaa geeshsha sohuwan moona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Aayen Israa7eela asa, aawan qassi Gibxxe asa gidiya issi bitanee de7ees. Issi gallassi i hara Israa7eela asa gidiya issuwaara heeran warettiis. ");
INSERT INTO wal_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ha ayyo aayyiyaa Israa7eela asa gidido bitanee waretaa giddon GODAA sunttaa cayiis. Yaatin a Muusekko ehiidosona. He bitaniyaa aayyiyaa Daana yaraa gidiya Xiibira na7iyo. I sunttaikka SHalomiito. ");
INSERT INTO wal_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ha bitaniyaa waatanaakko GODAA shenee etayyo qonccana gakkanaashin, eti a qasho keettan wottidosona. ");
INSERT INTO wal_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","GODAI Muusa hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“He cayida bitaniyaa dunkkaanidosaappe gaxi kessa; i cayishin siyida asai ubbai bantta kushiyaa a huuphiyaa bollan wottona; yaatobare Israa7eela asaa maabarai ubbai a shuchchan caddidi woro. ");
INSERT INTO wal_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Israa7eela asaayyo hagaadan yaagada yoota; ‘Ai asinne ba Xoossaa cayikko, i ba nagaran oishettana. ");
INSERT INTO wal_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","GODAA sunttaa cayiya asi haiqqo; Israa7eela asaa maabarai ubbai a shuchchan caddo. Betidi yiidaagaa gidin woi biitta asa gidinkka GODAA sunttaa cayikko haiqqo. ");
INSERT INTO wal_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘Asa woriya asi haiqqo. ");
INSERT INTO wal_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Asa mehe woriya asi ooninne ba worido mehiyaa gishshaa paxa mehiyaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Issi asi ba shooruwaa qohikko, i oottidooridan a bollankka oosetto. ");
INSERT INTO wal_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Menttikko meqqo; aife gishshaa aife; achcha gishshaa achcha. Asa bollan qohuwaa gattida oonikka i gattido qohuwaa malai a bollankka gakko. ");
INSERT INTO wal_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mehe worida asi mehiyaa qanxxo; shin asa worida asi haiqqo. ");
INSERT INTO wal_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Betiyaukka Israa7eela asau higgee issi mala gido; aissi giikko taani GODAA intte Xoossaa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Hegaa ubbaa Muusee Israa7eela asau ubbau yootiis; yootin eti he cayida bitaniyaa dunkkaanidosaappe gaxi kessidi, shuchchan caddidi woridosona. Yaatidi Israa7eela asai GODAI Muusa azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Siinaa Deriyaa bollan GODAI hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Neeni Israa7eela asaassi hagaadan yaagada yoota; ‘Taani intteyyo immiyo biittaa intte geliyo wode, biittaikka GODAA Sambbataa bonchcho. ");
INSERT INTO wal_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Usuppun laittaa kumettaa intte shooqan zerite; qassi usuppun laittaa kumettaakka intte woiniyaa turaa xeeraa xunqqite; a aifiyaakka maxidi ekkite. ");
INSERT INTO wal_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","SHin laappuntta laittai biittaayyo shemppo Sambbata; hegee GODAAYYOOKKA Sambbata. He laappuntta laittan intte shooqan zeroppite; intte woiniyaa xeeraakka xunqqoppite. ");
INSERT INTO wal_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Intte biittan azabba gididi mokkiyaabakka cakkoppite; qassi xunqqennan de7ishin coo aifida woiniyaakka shiishshoppite. He laittai biittaassi muleera shemppo laittaa gido. ");
INSERT INTO wal_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","7","He Sambbata laittan biittai oosettana xayikkonne intteyyo, intte maccanne attuma ashkkaratuyyo, intteyyo keraa oottiyaageetuyyo, betidi yiidi inttenaara de7iyaageetuyyo, intte mehiyaayyoonne intte biittan de7iya do7atuyyo gidiya qumaa immana; biittai mokkiyoobai ubbai meetetto. ");
INSERT INTO wal_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“‘Laittatu giddon de7iya laappun Sambbatata qooda; laappun Sambbatatu laittaa qoodai laapputoo laappuna; hegeekka oitamanne uddufun laitta. ");
INSERT INTO wal_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Hegaappe guyyiyan, laappuntta aginan, tammantta gallassan bonchchettiya nagaraa atto giissiyo gallassan malkkataa punniya asa intte biittan ubban kiittite. ");
INSERT INTO wal_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ishatamantto laittaa dummayidi, he biittan de7iya ubbaassi birshshettaa awaajjite. Hegee intteyyo Ishatamantto Laittaa Baalaa. He wodiyan intte ubbaikka intte gadiyaunne intte yarau yarau simmite. ");
INSERT INTO wal_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","He laittai intteyyo Ishatamantto Laittaa Baala. He laittan zeroppite; azabba gididi mokkidabaakka cakkoppite; qassi intte a xeeraa xunqqennan aifida woiniyaa aifiyaakka shiishshoppite. ");
INSERT INTO wal_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Hegee Ishatamantto Laittaa Baala gidiyo gishshau, i intteyyo geeshsha; goyennan coo dembban mokkidabaa miite. ");
INSERT INTO wal_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“‘Ha Ishatamantto Laittaa Baalaa wode asi ubbi ba gadiyau simmo. ");
INSERT INTO wal_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“‘Intte intte shooruwaappe gadiyaa shammikko, woi qassi ayyo baizzikko, issoi issuwaa cimmoppite. ");
INSERT INTO wal_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Intte Ishatamantto Laittaa Baalaappe guyyiyan de7iya laittatu qoodaadan intte shooruwaappe shammite; intte shooroikka qassi gadee kattaa mokkanau de7iyo laittatu qoodaadan baizzo. ");
INSERT INTO wal_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Laittatu qoodai daro gidikko, waagai darees; laittatu qoodai guuxxikko, waagaikka guuxxees. Aissi giikko, intte cakkana kattaa cahaa qoodaadan intte shooroi intteyyo baizzees. ");
INSERT INTO wal_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Intte issoi issuwaa cimmoppite; shin intte intte Xoossaassi yayyite. Taani GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“‘Ta azazuwaa oottite; ta higgiyaakka naagitenne oottite; yaatikko intte ha biittan sarotettan de7ana. ");
INSERT INTO wal_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Biittai ba aifiyaa intteyyo immana; immin intte kallana gakkanaashin maana; qassi he biittankka intte sarotettan de7ana. ");
INSERT INTO wal_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Intte, “Nuuni zerana xayikko, qassi kattaakka cakkidi shiishshana xayikko, laappuntta laittan ai maanee?” giikko, ");
INSERT INTO wal_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","taani usuppuntta laittan ta anjjuwaa intte bollan kiittana; yaatobare biittai heezzu laittau gidiya aifiyaa aifana. ");
INSERT INTO wal_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Hosppuntta laittan intte intte biittan zeriyo wodekka, kase shaachcha kattaa maana; qassi intte zeriyo kattaa aifiyaa uddufuntta laittan shiishshana gakkanaashinkka, shaachcha kattaa maana. ");
INSERT INTO wal_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“‘Biittai tabaa gidiyo gishshaunne inttekka ha biittan imattanne bete gididi de7iyo gishshau, biittaa naa77antto simmennaadan baizzoppite. ");
INSERT INTO wal_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Intte oiqqido biittan ubban de7iya gadiyaa gadiyaawati wozana mala, eta maataa naaganau koshshees. ");
INSERT INTO wal_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“‘Ne ishai hiyyeesidi ba gadiyaappe baizzikko, ayyo matattiya dabboi yiidi, he gadiyaa ayyo wozo. ");
INSERT INTO wal_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ayyo he gadiyaa woziya dabboi xayikko, qassi ikka simmi duretidi woziyo miishshaa demmikko, ");
INSERT INTO wal_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ba baizzido wodiyaappe doommidi de7iya laittaa qoodidi, attida laittaa miishshaa shammidaagaayyo zaaro; yaatidi i ba gadiyau simmo. ");
INSERT INTO wal_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","SHin ayyo he gadiyaa wozanau gidiya miishshi xayikko, Ishatamantto Laittaa Baalai gakkanaashin gadee shammida bitaniyaa kushiyan gam77o; Ishatamantto Laittaa Baalaa wode, a gadee ayyo simmo; ikka ba gadiyau simmo. ");
INSERT INTO wal_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“‘Gimbbetti uttida katamaa giddon issi asi de7iyo keettaa hara urau baizzikko, i baizzoosappe biidi issi laittaa gakkanaashin de7iya wodiyan zaaridi wozanau au maatai de7ees. ");
INSERT INTO wal_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Issi laitta kumettaa giddon wozana xayikko, he gimbbettida katamaa giddon de7iya keettai shammidaagaayyo na7aa na7au merinau abaa gidees. Ishatamantto Laittaa Baalaa wodekka simmenna. ");
INSERT INTO wal_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","SHin gimbbettibeenna heeratun de7iya keettati shooqa mala. Eti wozettoosona; Ishatamantto Laittaa Baalaa wodekka baizzidaagau simmoosona. ");
INSERT INTO wal_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“‘Gidikkonne Leewatu katamatun de7iya bantta keettaa Leewati bantta koyido wodiyan wozi ekkanau danddayoosona. ");
INSERT INTO wal_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Leewatuppe issi asi eta katamaa giddon de7iya keettaa baizzidi wozana xayikko, he eta katamaa giddon de7iya keettai Ishatamantto Laittaa Baalaa wode simmees. Aissi giikko, Leewatu katamaa giddon de7iya keettati Israa7eela asaa giddon Leewatussi aqo. ");
INSERT INTO wal_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","SHin eta katamaa yuushuwan eta ubbaassi issippe de7iya biittai etau merinau aqo gidiyo gishshau baizettenna. ");
INSERT INTO wal_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“‘Qassi ne ishai hiyyeesidi bana danddayana xayikko, imattadaaninne betedan i nenaara de7ana mala, neeni a maadda. ");
INSERT INTO wal_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ne ishaa nenaara wottanau appe dichchaa ekkoppa; woikko wore mooppa. SHin neeni ne Xoossaassi yayya. ");
INSERT INTO wal_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ne biraa ayyo dichchau tal77oppa; ne qumaakka ayyo woriyan baizzoppa. ");
INSERT INTO wal_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Intteyyo Kanaane biittaa immanaunne intte Xoossaa gidanau, inttena Gibxxe biittaappe kessidaagee, taani GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“‘Neeyyo dabbo gidiya Israa7eela asi hiyyeesidi, bana neeyyo ailletettau baizzikko, neeni a ailledan ootissoppa. ");
INSERT INTO wal_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","I keraa oottiya asadaaninne betedan nenaara de7o; Ishatamantto Laittaa Baalai gakkanaashin i neeyyo ootto. ");
INSERT INTO wal_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","He wode i ba naatuurakka issippe ne sooppe kiyidi ba keettaa asaakko bo; ba aawaa gadiyaakkokka simmo. ");
INSERT INTO wal_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Israa7eelati taani Gibxxe biittaappe kessido ta ailleta gidiyo gishshau, eti ailletettau baizettoppona. ");
INSERT INTO wal_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Neeni eta meqettaa iitada haaroppa; shin neeni ne Xoossau yayya. ");
INSERT INTO wal_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“‘Neeyyo attumanne macca ailleti de7ana mala koyikko, ne yuushuwan de7iya kawotettatuppe shamma. ");
INSERT INTO wal_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Qassi ne biittan de7iya betetuppenne ne biittan de7ishin yelettida eta so asaappe shammanau danddayaasa; eti neeyyo aqo gidona. ");
INSERT INTO wal_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Neeppe guyyiyan ne naati eta merinau laattana mala, ne naatuyyo imma. Neeni etappe ubba wodekka aille shammanau danddayaasa; shin ne isha gidiya Israa7eela asa meqettaa iitada haaroppa. ");
INSERT INTO wal_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","48","“‘Ne matan de7iya imatta woikko bete asi duretin, qassi a matan de7iya ne ishai hiyyeesidi, he ne matan de7iya imattaassi woikko betiyaassi woi imatta bitaniyaa zariyaappe issuwaassi bana baizzikko, i baizetti simmin a wozanau danddayettees; a ishanttuppe issoi a wozo. ");
INSERT INTO wal_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Woi a aawaa ishai, woi a aawaa ishaa na7ai a wozo; woi a yaraappe ayyo mata dabbo gidiya asi a wozo; woi qassi i ba huuphiyau duretikko i bana wozo. ");
INSERT INTO wal_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","I bana shammida bitaniyaara issippe gididi, i bana baizzido laittaappe doommidi Ishatamantto Laittaa Baalai gakkanaashin de7iya laittaa qoodo; a birshshissiya waagai he laittaa qoodaa keena gido. I bana shammidaagaara gam77ido wodiyaa waagai issi asi keraa oottidi demmiyo miishsha lagge gido. ");
INSERT INTO wal_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ishatamantto Laittaa Baalai gakkanau biron daro laittai attidabaa gidikko, ba baizettido waagaappe he laittaa qoodan bana woziyo waagaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Qassi Ishatamantto Laittaa Baalai gakkanau attida laittai guutta gidikko, bana shammidaagaara issippe qoodidi, he laittaa qoodan bana woziyo waagaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","I laittan laittan kera oottiya asadan bana shammidaagaara de7oppe attin, intte xeelliiddi Israa7eela asa gidiya bitaniyaa meqettaa iitidi haaroppite. ");
INSERT INTO wal_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“‘SHin i hegaa mala ogiyan wozettana xayikko, Ishatamantto Laittaa Baalai gakkiyo wode inne a naati ailletettaappe kiyona. ");
INSERT INTO wal_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Aissi giikko, Israa7eela asai ta ailletattennee! Taani Gibxxe biittaappe kessido ta ailleta. Taani, GODAI, intte Xoossaa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","GODAI hagaadan yaagees; “Intte etayyo goinnanau eeqata medhdhoppite; qassi hawulttiyaa, masettida misiliyaa woikko masettida shuchchaa essoppite. Taani, GODAI, intte Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ta Sambbatata naagite; ta Dunkkaaniyaa bonchchite. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Intte ta higgiyan biikko, ta azazotakka naagikkonne oottikko, ");
INSERT INTO wal_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","taani intteyyo iraa wodiyan bukissana; biittaikka kattaa darissidi mokkana; dembbaa mittatikka aifiyaa aifana. ");
INSERT INTO wal_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Intte kattaa qoxxiyo wodiyaappe biidi woiniyaa aifiyaa maxiyo wodee gakkanaashin kattaa qoxxana; qassi woiniyaa aifiyaa maxoikka biidi kattaa zeriyo wodee gakkanaashin wurenna. Intte kallana gakkanaashin qumaa maana; qassi intte intte biittankka saruwan de7ana. ");
INSERT INTO wal_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Taani biittau sarotettaa immana; ooninne yashissennan intte xiskkana. Iita do7ata taani biittaappe xaissana; intte biittan naa77antto olai denddenna. ");
INSERT INTO wal_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Intte morkketa intte yedettana; yedettin intte sinttan eti bisuwan haiqqana. ");
INSERT INTO wal_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Intteppe ichchashai xeetaa yedettana; qassi xeetai tammu sha7aa yedettana. Intte morkketi intte sinttan bisuwan haiqqana. ");
INSERT INTO wal_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Taani ta sinttaa inttekko zaarana; zaarada inttena aifissana; inttena darissana. Qassi taani ta maachchaa inttenaara minttana. ");
INSERT INTO wal_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Intte shaachcha kattaa maana; qassi ha laitta kattaa wottanau, shaachcha kattaa diggidi sohuwaa kessana. ");
INSERT INTO wal_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Taani ta de7iyo sohuwaa intte giddon oottana; taani inttena shenetikke. ");
INSERT INTO wal_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Taani intte gidduwan hemettana; qassi intte Xoossaa gidana; inttekka ta asa gidana. ");
INSERT INTO wal_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Intte Gibxxetuyyo aille gidennaadan, Gibxxe biittaappe inttena kessidaagee taani GODAI intte Xoossaa. Taani intte ailletettaa qambbaraa menttaas; qassi inttekka xoqqu giidi hemettanaadan oottaas. ");
INSERT INTO wal_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“SHin intte taani giyoobaa siyennan ixxikkonne, ha azazota ubbaakka oottennan ixxikko, ");
INSERT INTO wal_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ta wogaa intte karikko, qassi ta azazota ubbaa oottennan ixxidi, ta maachchaa kanttanau intte ta higgiyaa shenetikko, ");
INSERT INTO wal_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","he wode taani intte bolli hagaa oottana: Intte akeekennan de7ishin yashshaa, gilqqatettaa, intte aifiyaa jallettiyaanne inttena keehippe harggissiya mishuwaa intte bolli ehaana. Intte zerettaa zerana; shin i hada; aissi giikko, hegaa intte morkketi maana. ");
INSERT INTO wal_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Taani ta som77uwaa intte bolli tukkana; intte morkketu sinttan intte kunddana; inttena ixxiyaageeti inttena haarana; qassi ooninne yedettennan intte baqatana. ");
INSERT INTO wal_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Hagaa ubbaa oottinkka intte tana siyennan ixxikko, taani intte nagaraa gishshau intte qixaatiyaa laappun dakko gujjana. ");
INSERT INTO wal_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Intte wolqqaa otoruwaa taani menttana; saluwaa birata mala oottana; intte biittaakka nahaasiyaa giyo birataa mala oottana. ");
INSERT INTO wal_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Intte wolqqai hadasan wurana; aissi giikko, intte biittai kattaa mokkenna; biittan de7iya mittatikka aifiyaa aifokkona. ");
INSERT INTO wal_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Intte taayyo ixxis giikkonne taani giyoobaakka siyennan ixxikko, intte nagaraa keena laappun dakko boshaa taani intte bollan ehaana. ");
INSERT INTO wal_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Taani intte bolli bazzo do7ata yeddana; eti intte naata bonqqana; intte meheta xaissana; intte qoodaakka guuttana; hegaa gaasuwan intte hemettiyo ogee bazzo gidana. ");
INSERT INTO wal_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Ha ubba qixaatiyankka intte taakko simmennan ixxis giidi biikko, ");
INSERT INTO wal_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","he wode tankka intteyyo ixxis gaana; qassi intte nagaraa gishshau taani ta huuphen inttena laappun dakkuwaa qaxxayana. ");
INSERT INTO wal_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ta maachchaa menttido haluwaa kiyiya bisuwaa taani intte bolli ehaana; intte intte katamatun shiiqikkokka, taani intte bollan boshaa yeddana. Qassi inttekka intte morkketu kushiyan aadhdhidi imettana. ");
INSERT INTO wal_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Intte kattaa taani xaissiyo wode, tammu maccaasati issi bashiyan oittaa uukkana; hegaakka meezaanan likkidi shaakkana; intte hegaa maana, shin kallekketa. ");
INSERT INTO wal_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Ha ubbankka intte taani giyoobaa siyennan ixxis giidi biikko, ");
INSERT INTO wal_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","he wode tankka intte bolli hanqquwan denddana; intte nagaraa gishshau taani ta huuphen inttena laappun dakkuwaa qaxxayana. ");
INSERT INTO wal_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Intte intte attuma naatunne intte macca naatu ashuwaa maana. ");
INSERT INTO wal_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Intte goinniyo xoqqa sohota taani kolana; intte ixaanaa yarshshiyo sohuwaakka xaissana. Taani intte ahaa intte eeqatu ahaa bollan olana; taani inttena mule shenetana. ");
INSERT INTO wal_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Taani intte katamata baisa oottana; intte goinniyo sohotakka kolerettana; intte sawiya yarshshuwaakka singgikke. ");
INSERT INTO wal_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","“Taani intte biittaa xaissana; yaatobare he intte biittan yiidi uttiya morkketikka hegan garamettana. ");
INSERT INTO wal_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Taani inttena kawotettatu giddon laalana; intte bollankka ta bisuwaa shoddana. Intte biittai bayana; intte katamatikka baisa gidana. ");
INSERT INTO wal_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","He intte intte morkketu biittan de7iyo wode, baisa gididi coo de7iya intte biittai ba Sambbatata bonchchiiddi ufaittana. He wode intte biittai shemppananne ba Sambbatata bonchchiiddi ufaittana. ");
INSERT INTO wal_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Intte he biittan de7ido wodiyan ubban intte Sambbatatun demmibeenna shemppuwaa ha77i bayidi coo de7iyo wodiyan demmana. ");
INSERT INTO wal_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Intte intte morkketu biittan de7iyo wode, intteppe shaahettidi, guyye attidi de7iyaageetu wozanan taani yashshaa yeddana; carkkoi qaattiyo bonccuwaa cenggurssai eta shabbirana; eti bisuwaappe baqatiyaabaadan baqatana; qassi eta ooninne yedettennan eti kunddana. ");
INSERT INTO wal_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Inttena yedettiyaabi bainnan de7ishin, intte olaappe baqatiyaabaadan issoi issuwaara xubettana; qassi intte intte morkketu sinttan eqqanaukka intteyyo aiba wolqqinne de7enna. ");
INSERT INTO wal_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Intte kawotettatu giddon bayana; intte morkketu biittaikka inttena mitti aggana. ");
INSERT INTO wal_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Intteppe shaahettidi intte morkketu biittan attidaageeti bantta nagaraa gaasuwaaninne bantta aawatu nagaraa gaasuwan gilqqana. ");
INSERT INTO wal_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","42","“SHin eti taani etau ixxis gaanaadaaninne eta morkketu biittau eta yeddanaadan oottida bantta nagaraa, bantta maizza aawatu nagaraa, eti tana cimmido cimuwaanne eti taayyo ixxis giidoogaa paaxikko, hegan qassi eta azazettenna wozanaikka ziqqi giikkonne eti bantta nagaraa qixaatiyaa ekkikko, he wode taani Yaaqoobaara maacettido ta maachchaa hassayana; qassi Yisaaqaaranne Abrahaamaara maacettido ta maachchaa hassayana; biittaakka hassayana. ");
INSERT INTO wal_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Eti xayiichchin, eta biittai baisa attana; he eti xayin baisa gididi coo de7iyo wodiyan biittai ba Sambbatata bonchchiiddi ufaittana. Eti ta azazuwaa karido gishshaunne eta shemppoikka ta wogaa shenetido gishshau, eti bantta nagaraa qixaatiyaa ekkana. ");
INSERT INTO wal_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Gidikkonne eti bantta morkketu biittan de7iyo wode, eti muleera xayana gakkanaashiininne etaara de7iya ta maachchaakka kanttana gakkanaashin, taani eta olikke; qassi shenetikke. Taani, GODAI, eta Xoossaa. ");
INSERT INTO wal_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Taani eta Xoossaa gidanau, kawotettati xeellishin, Gibxxe biittaappe kessido eta maizza aawatuura taani maacettido maachchaa eta gishshau hassayana. Taani GODAA. ");
INSERT INTO wal_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","“GODAI Siinaa Deriyaa bollan Muuse baggaara baappenne Israa7eela asaappe gidduwan wottido wogati, azazotinne higgeti hageeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","2","GODAI Muusa hagaadan yaagiis; “Israa7eela asaassi hagaadan yaagada yoota; ‘Issi asi GODAAYYO asa immanau shiiqikko, neeni gammatiyoogaadan he asa gishshaa miishshaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Hegeenne laatamu laittappe biidi usuppun tammu laitta gakkanau de7iya attumaagau usuppun xeetu giraame deexxiya xaqara biraa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Macca asa gidikko qassi hasttamu xaqara biraa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Qassi ichchashu laittappe biidi laatamu laitta gakkanau de7iya attumaagau laatamu xaqara biraanne maccaarissi tammu xaqara biraa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Qassikka issi aginaappe biidi ichchashu laitta gakkanau de7iya attumaagau ichchashu xaqara biraanne maccaarissi heezzu xaqara biraa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Hegaadankka qassi usuppun tammu laittanne hegaappe bollaara de7iya attumaagau tammanne ichchashu xaqara biraanne maccaarissi tammu xaqara biraa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Qassi shiiqettida bitanee neeni gammatidoogaa qanxxanau danddayenna daro manqqo gidikko, i ba shiiquwaa gattanau immido asa ehiidi qeesiyaa sinttan esso; essobare shiiqettida bitanee qanxxanau danddayiyoogaa keenaa qoppidi qeesee gammato. ");
INSERT INTO wal_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“‘I shiiqettidoo mehee GODAASSI yarshshanau haniya mehe gidikko, hegaa mala mehee ubbai GODAASSI geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","I he mehiyaa gishshaa hara mehiyaa immoppo; woi a hara mehiyaara laammoppo. Lo77uwaa iitaara woi qassi iitaakka lo77uwaara laammoppo. SHin i laammikko, koiro meheenne laamiyaa immido meheenne naa77aikka geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","I shiiqettido mehee GODAASSI yarshsho oottidi shiishshanau geeshsha gidenna mehe gidikko, he bitanee he mehiyaa qeesiyaa sintti eho. ");
INSERT INTO wal_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Lo77o gidin iita gidin, qeesee he mehiyaa gammato; yaatobare qeesee gammatidoogee a waaga gido. ");
INSERT INTO wal_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","SHin he mehiyaa godai a zaaridi wozanau koyikko, he mehiyaa waagaa bolli xeetaappe laatamu kushiyaa gujjo. ");
INSERT INTO wal_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“‘Issi asi ba keettaa geeshsha gidanaadan GODAASSI dummayikko, lo77o gidin iita gidin, qeesee he keettaa gammato. Yaatobare qeesee gammatidoogaadan a waagai hegaadankka gido. ");
INSERT INTO wal_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Qassi ba keettaa GODAASSI geeshsha ootti dummayida asi zaarettidi wozanau koyikko, he keettaa waagaa bollan xeetaappe laatamu kushiyaa gujjo; yaatobare keettai assa gidees. ");
INSERT INTO wal_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“‘Issi asi ba laata gadiyaappe shaakkidi geeshsha ootti GODAASSI dummayikko, he gadiyaa waagai an zeriyo zerettan gammatetto. Hegeenne laatamu kilo giraame banggaa zeriyo keena shooqa gidikko, tammu xaqara biraa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","I ba gadiyaa Ishatamantto Laittaa Baalaappe doommidi geeshsha ootti GODAASSI dummayikko, he gadiyau kumetta waagaa qanxxo. ");
INSERT INTO wal_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","SHin i ba gadiyaa Ishatamantto Laittaa Baalai aadhdhi simmin geeshsha ootti GODAASSI dummayikko, kaallidi de7iya Ishatamantto Laittaa Baalai gakkanaashin de7iya wodiyaa qeesee qoodo; yaatobare a kumetta waagaappe wodhdhees. ");
INSERT INTO wal_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","He gadiyaa geeshsha ootti GODAASSI dummayida asi zaaretti wozanau koyikko, i gammatettido miishshaa bolli xeetaappe laatamu kushiyaa gujjo; yaatobare gadee simmidi abaa gidees. ");
INSERT INTO wal_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","SHin i gadiyaa zaarettidi, wozanaappe kasetidi hara asau baizzikko, he gadiyaa wozanau danddayenna. ");
INSERT INTO wal_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ishatamantto Laittaa Baalai gakkin gadee yedettiyo wode, he gadee naa77antto guyye ekkennabaadan GODAASSI geeshsha gidees. He gadee qeesetu gade gidees. ");
INSERT INTO wal_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“‘Issi asi hara asappe shammido gadiyaa geeshsha ootti GODAASSI dummayanau koyikko, ");
INSERT INTO wal_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kaalliya Ishatamantto Laittaa Baalai gakkanaashin de7iya waagaa qeesee gammato; gammatobare bitanee he gallassikka he gimmitiyaa qanxxo; qanxxobare he miishshai GODAASSI dummatida miishsha gidana. ");
INSERT INTO wal_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ishatamantto Laittaa Baalai gakkiyo wode, he gadee koiro laatan ekkidi baizzida bitaniyaassi simmees. ");
INSERT INTO wal_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“‘A waagai Xoossaa Dunkkaaniyan eriyo meezaanan gammatettees. ");
INSERT INTO wal_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“‘SHin ooninne baira yelettida mehe GODAASSI dummayidi shiishshanau danddayenna; aissi giikko, i kasekka GODAABAA. Miizza mara gidin woi dorssa mara gidinkka i GODAABAA. ");
INSERT INTO wal_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","He marai geeshsha gidana xayikko, ne gammatido waagaa bolli xeetaappe laatamu kushiyaa gujjidi a godai zaarettidi wozo. I wozana xayikko, ne gammatido waagan hara asau baizetto. ");
INSERT INTO wal_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“‘Issi asi babaappe GODAASSI dummayidi immidobai aiba gidikkokka, asa gidin mehe gidin, woi a laatan gakkida gade gidinkka, baizettennanne wozettenna. Dummayidobai ubbabi GODAASSI ubbaappe aadhdhida geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Asaa giddoppe shaahettidi xayanaadan imettida asi wozettoppo; he asi haiqqo. ");
INSERT INTO wal_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“‘Biittaa asiratai ubbai biittaappe mokkida katta gidin woi mitta aife gidinkka GODAASSA. Hegee GODAASSI geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Issi asi ba asirataa wozanau koyikko, a waagaa bollan xeetaappe laatamu kushiyaa gujjo. ");
INSERT INTO wal_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Miizzaa gidin, dorssaa gidin, woi deeshshaa gidinkka, tammaappe issoi GODAASSA; meheta qoodi qoodidi aattiyo wode tammantti GODAASSI geeshsha. ");
INSERT INTO wal_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tammantta mehiyaa iita gidin lo77o gidinkka dooroppo; woi a haraara laammoppo. Laammikkonne koiroogeenne laamiyaa immidoogeenne naa77aikka GODAASSI geeshsha gidoosonappe attin, zaaridi wozanau danddayenna’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Siinaa Deriyaa bollan GODAI Muuse baggaara Israa7eela asaa azazido azazoti hageeta. ");
INSERT INTO wal_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Siinaa Bazzuwan, Xoossaa Dunkkaaniyaa giddon, Israa7eela asai Gibxxe biittaappe kiyido naa77antto laittan, naa77antto aginan, he aginau koiro gallassan, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Israa7eela asaa ubbaa eta yaran yaraaninne keettan keettan qoodada, attuma asaa eta sunttan sunttan xaafa. ");
INSERT INTO wal_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Neeninne Aarooni yelettoosappe laatamu laittanne hegaappe bollaara de7iya Israa7eelata, olaa baanau danddayiyaageeta ubbata, eta citan citan qoodite. ");
INSERT INTO wal_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Zariyaappe zariyaappe issi issi asi ba keettaa asau halaqa gididi, inttena maaddo. ");
INSERT INTO wal_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Inttena maaddana asatu sunttai hagaappe kaallidi de7iyaagaa: Zariyaa Keettaa Asaa Halaqaa Roobeela SHade7uura na7aa Eliixuura ");
INSERT INTO wal_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simoona Xuriishadaaya na7aa SHalumi7eela ");
INSERT INTO wal_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yihudaa Aminadaaba na7aa Na7asoona ");
INSERT INTO wal_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Yisaakoora Xu7aara na7aa Nataani7eela ");
INSERT INTO wal_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zaabiloona Heloona na7aa Eli7aaba ");
INSERT INTO wal_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Efireema Amihuuda na7aa Elishamaa7a Minaase Padaaxuura na7aa Gamaali7eela ");
INSERT INTO wal_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Biniyaama Giidi7oona na7aa Abidaana ");
INSERT INTO wal_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Daana Amishadaaya na7aa Ahi7eezera ");
INSERT INTO wal_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aseera Okiraana na7aa Paagi7eela ");
INSERT INTO wal_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gaada Da7u7eela na7aa Eliyasaafa ");
INSERT INTO wal_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nifttaaleema Enaana na7aa Ahiraa7a ");
INSERT INTO wal_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ha asati bantta aawatu keettaa asatuppe kaalettanau doorettidaageeta; eti Israa7eela yaratuyyo halaqata” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Yaagin Muuseenne Aarooni sunttai xeesettido ha asata efiidosona. ");
INSERT INTO wal_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Naa77antta aginan koiro gallassi kumetta maabaraa xeesidi, issippe shiishshidosona. SHiishshin asai ba yaran yaraaninne ba keettan keettan odidi, yelettoosappe laatamu laittanne hegaappe bollaara de7iya attumaasatu ubbaa sunttai muleera xaafettiis. ");
INSERT INTO wal_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","GODAI a azazidoogaadan, Muusee eta Siinaa Bazzuwan qoodiis. ");
INSERT INTO wal_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","Olau baanau danddayiya attumaasati ubbai, laatamu laittanne hegaappe bollaara de7iyaageeti qoodettidi, huuphiyan huuphiyan xaafettidosona. Eti bantta yaran yaraaninne bantta keettan keettan shaahettidi, hagaappe kaallidi de7iya qoodan mazggafettidosona. Zariyaa Olanchchatu Qoodaa Roobeela (Yaaqooba na7aa bairaa) 46,500 ");
INSERT INTO wal_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Simoona 59,300 ");
INSERT INTO wal_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Gaada 45,650 ");
INSERT INTO wal_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Yihudaa 74,600 ");
INSERT INTO wal_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Yisaakoora 54,400 ");
INSERT INTO wal_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zaabiloona 57,400 ");
INSERT INTO wal_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Yooseefa na7aa Efireema 40,500 ");
INSERT INTO wal_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Yooseefa na7aa Minaasa 32,200 ");
INSERT INTO wal_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Biniyaama 35,400 ");
INSERT INTO wal_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Daana 62,700 ");
INSERT INTO wal_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Aseera 41,500 ");
INSERT INTO wal_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Nifttaaleema 53,400 ");
INSERT INTO wal_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Muusee, Aarooninne tammanne naa77u Israa7eela zaretu halaqati qoodido asai hagaa. ");
INSERT INTO wal_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Olau baanau danddayiya attumaasati ubbai laatamu laittanne hegaappe bollaara de7iyaageeti bantta aawaa keettan keettan qoodettidosona. ");
INSERT INTO wal_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Hegeeti muleera 603,550. ");
INSERT INTO wal_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","SHin Leewa zareti ha qoodettida asaara qoodettibookkona. ");
INSERT INTO wal_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Aissi giikko, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Leewa zareta qoodoppa; eta attida Israa7eelatu qoodan yeggoppa. ");
INSERT INTO wal_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Leewata Xoossaa Dunkkaaniyaa bollaaninne a giddon de7iya miishshatu ubbaa bollan halaqa oottada suntta. Eti he Dunkkaaniyaanne a giddon de7iya miishshata tookkona; eti a giddon oottonanne a yuushuwan dunkkaanona. ");
INSERT INTO wal_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Xoossaa Dunkkaanee shodettiyo wode Leewati shoddona; Xoossaa Dunkkaanee eqqiyo wodekka Leewati essona. Etappe harai ooninne akko shiiqikko, haiqqo. ");
INSERT INTO wal_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israa7eela asati ubbai bantta armman armmaaninne bantta citan citan shaahettidi, bantta dunkkaaniyaa dunkkaanona. ");
INSERT INTO wal_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","SHin GODAA hanqqoi Israa7eela maabaraa bolli wodhdhenna mala, Leewati Xoossaa Dunkkaaniyaa yuushuwan bantta dunkkaaniyaa dunkkaanona; Leewati Xoossaa Dunkkaaniyan aawatona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israa7eelati hagaa ubbaa GODAI Muusa azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Israa7eela asai bantta baggaa baggaa erissiya armmaanne bantta yaraa yaraa erissiya banddiraa kaallidi, Xoossaa Dunkkaaniyaappe guuttaa haakkidi, a yuushuwan dunkkaanona. ");
INSERT INTO wal_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","4","“Arshsho baggaara Yihudaa baggai bantta armmaa kaallidi dunkkaanona. Eta zaretu sunttai, zaretu halaqatu sunttainne olanchchatu qoodai hagaappe kaallees: Zariyaa Zaretu Halaqaa Olanchchatu Qoodaa Yihudaa Aminadaaba na7aa Na7asoona 74,600 ");
INSERT INTO wal_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","6","Yisaakoora Xu7aara na7aa Nataani7eela 54,400 ");
INSERT INTO wal_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","8","Zaabiloona Heloona na7aa Eli7aaba 57,400 ");
INSERT INTO wal_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Yihudaa baggaappe qoodettida olanchchati muleera 186,400. Hara sohuwaa biyo wode eti koiro kiyiyaageeta. ");
INSERT INTO wal_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","11","“Qassi tohossa baggaara Roobeela baggai bantta armmaa kaallidi dunkkaanona. Eta zaretu sunttai, zaretu halaqatu sunttainne olanchchatu qoodai hagaappe kaallees: Zariyaa Zaretu Halaqaa Olanchchatu Qoodaa Roobeela SHade7uura na7aa Eliixuura 46,500 ");
INSERT INTO wal_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","13","Simoona Xuriishadaaya na7aa SHalumi7eela 59,300 ");
INSERT INTO wal_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","15","Gaada Da7u7eela na7aa Eliyasaafa 45,650 ");
INSERT INTO wal_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Roobeela baggaappe qoodettida olanchchati muleera 151,450. Hara sohuwaa biyo wode eti naa77antto kiyiyaageeta. ");
INSERT INTO wal_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Hegaappe guyyiyan, Xoossaa Dunkkaaneenne Leewa zareti koiro kiyida naa77u baggaappenne guyyeppe kiyiya naa77u baggaappe gidduwan kiyona; yaatidi bantta dunkkaanido maaran maaraaninne bantta banddiraa banddiraa kaallidi kiyona. ");
INSERT INTO wal_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","19","“Qassi arggo baggaara Efireema baggai bantta armmaa kaallidi dunkkaanona. Eta zaretu sunttai, zaretu halaqatu sunttainne olanchchatu qoodai hagaappe kaallees: Zariyaa Zaretu Halaqaa Olanchchatu Qoodaa Efireema Amihuuda na7aa Elishamaa7a 40,500 ");
INSERT INTO wal_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","21","Minaasa Padaaxuura na7aa Gamaali7eela 32,200 ");
INSERT INTO wal_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","23","Biniyaama Giidi7oona na7aa Abidaana 35,400 ");
INSERT INTO wal_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Efireema baggaappe qoodettida olanchchati muleera 108,100. Hara sohuwaa biyo wode, eti heezzantto kiyiyaageeta. ");
INSERT INTO wal_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","26","“Qassikka huuphessa baggaara Daana baggai bantta armmaa kaallidi dunkkaanona. Eta zaretu sunttai, zaretu halaqatu sunttainne olanchchatu qoodai hagaappe kaallees: Zariyaa Zaretu Halaqaa Olanchchatu Qoodaa Daana Amishadaaya na7aa Ahi7eezera 62,700 ");
INSERT INTO wal_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","28","Aseera Okiraana na7aa Paagi7eela 41,500 ");
INSERT INTO wal_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","30","Nifttaaleema Enaana na7aa Ahiraa7a 53,400 ");
INSERT INTO wal_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Daana baggaappe qoodettida olanchchati muleera 157,600. Hara sohuwaa biyo wode eti wurssettan kiyiyaageeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Bantta yaran yaran shaahettidi qoodettida Israa7eela olanchchati muleera 603,550. ");
INSERT INTO wal_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","SHin GODAI Muusa azazidoogaadan, Leewati hara Israa7eelatuura qoodettibookkona. ");
INSERT INTO wal_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israa7eelati GODAI Muusa azazidobaa ubbabaa oottidosona. Simmi eti bantta banddiraa kaallidi, hegaadan dunkkaanidosona; qassi bantta yaraa yaraanne bantta so asaa asaa kaallidi, hegaadan kiyidosona. ");
INSERT INTO wal_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","GODAI Siinaa Deriyaa bollan Muuseera haasayido wode de7iya Aaroonanne Muuse keettaa asai hagaappe kaallidi xaafettidaagaa. ");
INSERT INTO wal_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaroona attuma naatu sunttai bairai Nadaaba, Abiiha, El77aazaranne Itaamaara. ");
INSERT INTO wal_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","He Aaroona attuma naati ubbai qeese gididi oottanau tiyettidi sunttettidosona. ");
INSERT INTO wal_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","SHin eta giddoppe Nadaabinne Abiihu Siinaa Bazzuwan GODAI azazibeenna tamaa yarshshidi, GODAA sinttan haiqqidosona; etau na7i baawa. Hegaa gishshau, eta aawai Aarooni paxa de7ido laitta ubban El77aazaranne Itaamaara xalaalai qeese gididi oottidosona. ");
INSERT INTO wal_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Leewata haa ekkada ya; ehaada qeesiyaa Aaroona maaddana mala, eta a sintti shiishsha. ");
INSERT INTO wal_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Eti Aaroonaunne Israa7eela maabarau ubbau Xoossaa Dunkkaaniyaa sinttan dumma dumma oosuwaa oottona. ");
INSERT INTO wal_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Eti Xoossaa Dunkkaaniyan de7iya miishsha ubbaa aawatettaa ekkona; ekkidi Israa7eela asaa gishshaa Xoossaa Dunkkaaniyan ooso ubbaa eti oottona. ");
INSERT INTO wal_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Neeni Leewata Aaroonanne a attuma naata maaddanaadan suntta; eti Israa7eela giddoppe muleera Aaroonayyo imettidosona. ");
INSERT INTO wal_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaroonanne a attuma naata qeese oottada suntta. Etappe hara asi ooninne Xoossaa Dunkkaaniyaakko shiiqikko, haiqqo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Qassi GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Taani Israa7eelatu maccaasai baira yeliyo attuma naatu ubbaa gishshaa Israa7eelatu giddoppe Leewata ekkaas. Leewati tabaa; ");
INSERT INTO wal_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","aissi giikko, baira yelettida ubbai tabaa. Taani Gibxxe biittan baira yelettidabaa ubbaa worido gallassan, Israa7eelatun baira yelettidabaa ubbaa, asa gidin, mehe gidin, taayyo dummayaas; eti tabaa gidana. Taani GODAATTENNEE” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Qassikka GODAI Muusa Siinaa Bazzuwan, ");
INSERT INTO wal_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Neeni Leewata eta so asan asaaninne eta yaran yaran qooda; yelettoosappe issi aginanne hegaappe bollaara de7iya attumaageeta ubbaa qooda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Yaagin GODAI azazidoogaadan, Muusee eta qoodiis. ");
INSERT INTO wal_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Leewa attuma naati Gershshoona, Qahaatanne Maraara. ");
INSERT INTO wal_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershshoona attuma naati Liibinanne SHim77a. ");
INSERT INTO wal_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Qahaata attuma naati Amiraama, Yixihaara, Kebroonanne Uzzi7eela. ");
INSERT INTO wal_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Maraara attuma naati qassi Maahilanne Musha. Leewatu maizza aawati hageeta. ");
INSERT INTO wal_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Liibina yaratinne SHim77a yarati Gershshoona zareta. ");
INSERT INTO wal_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Etappe qoodin, yelettoosappe issi aginanne hegaappe bollaara de7iya attumaageeti muleera 7,500. ");
INSERT INTO wal_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershshoona yarati Xoossaa Dunkkaaniyaappe guyye arggo baggaara dunkkaanoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gershshoona yaratu so asaa halaqai Laa7eela na7aa Eliyasaafa. ");
INSERT INTO wal_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gershshoona yarati Xoossaa Dunkkaaniyaa, Dunkkaaniyaa kammiyoobata, geliyoosa magalashuwaa, ");
INSERT INTO wal_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","dabaabaa magalashota, Xoossaa Dunkkaaniyaanne yarshshiyoosaa yuushuwan de7iya dabaabaa geliyoosan magalashuwaa, wodorotanne eta go77aara gaittiyaabata ubbabaa aawatettaa ekkoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amiraama yarati, Yixihaara yarati, Kebroona yaratinne Uzzi7eela yarati Qahaata zareta. ");
INSERT INTO wal_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Yelettoosappe issi aginanne hegaappe bollaara de7iya attumaageeti muleera 8,600. Qahaata yarati Xoossaa Dunkkaaniyaa aawatettaa ekkoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Qahaata yarati Xoossaa Dunkkaaniyaappe tohossa baggaara dunkkaanoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Qahaata yaratu so asaa halaqai Uzzi7eela na7aa Elxxaafaana. ");
INSERT INTO wal_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Eti Taabootaa, xaraphpheezaa, xomppiyaa wottiyo ballaa, yarshshiyoosaa, ixaanaa cuwayiyo saaxiniyaa, oottiyo wode go7ettiyo Xoossaa Dunkkaaniyaa miishshata, magalashuwaanne eta go77aara gaittiyaabata ubbabaa aawatettaa ekkoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Leewatu halaqatu halaqai qeesiyaa Aaroona na7aa El77aazara; Geeshsha Sohuwau aawatiyaageetu bolli i sunttettiis. ");
INSERT INTO wal_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Maahila yaratinne Musha yarati Maraara zareta. ");
INSERT INTO wal_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Etappe qoodin, yelettoosappe issi aginanne hegaappe bollaara de7iya attumaageeti muleera 6,200. ");
INSERT INTO wal_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Maraara yaratu so asaa halaqai Abihaila na7aa Xurii7eela. Maraara yarati Xoossaa Dunkkaaniyaappe huuphessa baggaara dunkkaanoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Maraara yarati Dunkkaaniyaa xagaageta, hiraqota, tuussata, gedeta, he oosuwaassi koshshiya miishshata ubbaanne eta go77aara gaittiyaabata ubbaa aawatettaa ekkoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Hegaa bollikka gujjidi, yuushuwan de7iya dabaabaa tuussatanne eta gedeta, xishetanne wodorota aawatettaa ekkoosona. ");
INSERT INTO wal_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Qassi Xoossaa Dunkkaaniyaappe sintta arshsho baggaara Muusee, Aarooninne a attuma naati dunkkaanoosona. Eti Israa7eelatu gishshaa Xoossaa Dunkkaane giddon oottiyo oosuwaa aawatettaa ekkoosona. Hara asi Xoossaa Dunkkaaniyaakko shiiqikko, haiqqo. ");
INSERT INTO wal_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","GODAI azazin, Muuseenne Aarooni qoodido attuma Leewati, yelettoosappe issi aginanne hegaappe bollaara de7iya attumaageeti muleera 22,000. ");
INSERT INTO wal_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","GODAI Muusa, “Israa7eelatu baira attuma naata, yelettoosappe issi aginanne hegaappe bollaara de7iyaageeta ubbaa qooda; qoodada eta sunttaa xaafa. ");
INSERT INTO wal_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Israa7eelatun baira yelettida ubbaa gishshaa Leewata taayyo ekka; qassi Israa7eelatu mehiyan baira yelettida ubbaa gishshaa Leewatu mehiyaa taayyo ekka. Taani GODAATTENNEE” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Yaagin Muusee GODAI a azazidoogaadan, Israa7eelatun baira yelettida ubbaa qoodiis. ");
INSERT INTO wal_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Yelettoosappe issi aginanne hegaappe bollaara de7iya baira yelettida attumaageeti, sunttaikka xaafettidoogeeti muleera 22,273. ");
INSERT INTO wal_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","GODAI Muusa qassikka hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Leewata Israa7eela attumaageetu ubbaa gishshaa ekka; Leewatu meheta Israa7eelatu mehetu gishshaa ekka; Leewati tabaa gidana. Taani GODAATTENNEE. ");
INSERT INTO wal_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Leewatu qoodaappe dariya 273 baira gididi yelettida Israa7eela attuma naata wozanau, ");
INSERT INTO wal_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","issuwaassi issuwaassi ichchashu xaqara biraa Xoossaa Dunkkaaniyan eriyo meezaanaa likkiyan ekka. ");
INSERT INTO wal_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Palahida Israa7eelata woziyo he miishshaa Aaroonayyoonne a attuma naatuyyo imma” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Yaagin Muusee, Leewatun wozettidaageetuppe palahidaageeta woziyo miishshaa shiishshiis. ");
INSERT INTO wal_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Baira yelettida Israa7eelatuppe 1,365 xaqara biraa Xoossaa Dunkkaaniyan eriyo meezaanaa likkiyan i shiishshiis; ");
INSERT INTO wal_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","shiishshidi GODAI azazido azazuwaadan, Muusee woziyo miishshaa Aaroonayyoonne a attuma naatuyyo immiis. ");
INSERT INTO wal_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Leewa zaretun Qahaata yarata eta dabbuwan dabbuwaaninne eta so asan asan shaakkada qooda; ");
INSERT INTO wal_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","yelettoosappe laittai hasttamaappe biidi ishatamaa gakkido attumaasa ubbaa, Xoossaa Dunkkaaniyaa giddon oottanau yiyaageeta qooda. ");
INSERT INTO wal_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Qahaata yarati Xoossaa Dunkkaaniyaa giddon oottana oosoi hagaa: eti ubbaappe aadhdhida geeshsha miishshatun aawatoosona. ");
INSERT INTO wal_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“Asai dunkkaanidosaappe baanau haniyo wode, Aarooninne a attuma naati Xoossaa Dunkkaaniyaa giddo gelidi, Taabootaa sintta magalashuwaa kaquwaappe wottona; wottidi he Maachchaa Taabootaa an kammona. ");
INSERT INTO wal_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","He kammidoogaa bollikka qassi irppaniyaa kammona; hegaa bollikka qassi gujjidi, salo milatiya carqqiyaa kammona; kammidi tookkiyo kasota eta sagaayotun aattona. ");
INSERT INTO wal_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Aattidi GODAA sintti shiishshiyo oittaa wottiyo xaraphpheezaa bollan salo milatiya carqqiyaa hiixxona; hiixxidi a bolli saineta, cilppata, xuu7atanne ushshaa yarshshuwau go7ettiyo otota wottona; qassi oittai ubba wodekka a bollappe xayoppo. ");
INSERT INTO wal_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hegaa bollan zo7o carqqiyaa hiixxidi, irppaniyaa qassi a bolli kammona; kammidi tookkiyo kasota sagaayotun aattona. ");
INSERT INTO wal_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Aattidi eti salo milatiya carqqiyaa ekkidi, xomppiyaa wottiyo ballata xomppetuura, toissiyo qaphetuura, eta wottiyoobatuuranne zaitiyaa tigiyo xaarotuurakka ubbaa kammona. ");
INSERT INTO wal_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Yaatidi akka miishshata ubbaakka irppaniyan kammidi, tookkiyo halaa bollan wottona. ");
INSERT INTO wal_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Wottidi ixaanaa cuwayiyo worqqa saaxiniyaa bollan salo milatiya carqqiyaa hiixxona; hiixxidoogaa qassi irppaniyan kammona; kammidi tookkiyo kasota eta sagaayotun aattona. ");
INSERT INTO wal_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Hegaadankka, qassi Xoossaa Dunkkaaniyaa giddon go7ettiyo miishshata ubbaa ekkidi, salo milatiya carqqiyaa xaaxona; xaaxidoogaa irppaniyan kammidi, tookkiyo halaa bollan wottona. ");
INSERT INTO wal_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Yaatidi nahaasiyaappe oottido yarshshiyoosaa bolli de7iya bidinttaa diggona; diggidi a bolli ochchaa teera milatiya carqqiyaa hiixxona. ");
INSERT INTO wal_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Hiixxidi a bolli yarshshiyoosan go7ettiyo miishshata ubbaa, tama cooceta, ashuwaa qaphiyo qapheta, akaafatanne araciyo kuixaarota wottona. Wottidi irppaniyan kammona; kammidi tookkiyo kasota eta sagaayotun aattona. ");
INSERT INTO wal_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Aarooninne a attuma naati, geeshshabatanne geeshsha miishshata ubbaa kammidi makkobarenne dunkkaanidosaappe denddiyo wodee gakkobare, hegaa ubbaa tookkanau Qahaata yarati yoona. SHin geeshsha miishshata eti bochchoppona; bochchikko haiqqona. Xoossaa Dunkkaaniyaa giddon de7iya he miishshaa Qahaata yarati tookkona. ");
INSERT INTO wal_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Qeesiyaa Aaroona na7ai El77aazari xomppiyaa zaitiyaassi, sawiya ixaanaassi, hachchi hachchi yarshshiyo kattaa yarshshuwaassinne tiyiyo zaitiyaassi, qassi Xoossaa Dunkkaaniyaa muliyaanne a giddon de7iya dumma geeshsha miishshata ubbaa bolli aawato” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Qassi GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Qahaata yarati Leewa zaretuppe haiqqidi xayenna mala xeellite. ");
INSERT INTO wal_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ubbaappe aadhdhida geeshsha miishshaa mati shiiqiyo wode, eti haiqqennan paxa attidi de7ana mala, etayyo hagaadan oottite: Aarooninne a attuma naati Xoossaa Dunkkaaniyaa giddo gelona; gelidi Qahaata yarati ubbai huuphiyan huuphiyan oottana oosuwaanne tookkana toohuwaa shaakki shaakkidi gishona. ");
INSERT INTO wal_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Qahaata yarati haiqqennaadan, ubbaappe aadhdhiya geeshshabata qeeseti xaaxishin be7anau giddo geloppona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gershshoona yaratakka eta dabbuwan dabbuwaaninne eta so asan asan shaakkada qooda; ");
INSERT INTO wal_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","yelettoosappe laittai hasttamaappe biidi ishatamaa gakkido attumaasa ubbaa, Xoossaa Dunkkaaniyaa giddon oottanau yiyaageeta qooda. ");
INSERT INTO wal_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Gershshoona yarati oottiyo oosoinne tookkiyo toohoi hagaa: ");
INSERT INTO wal_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","eti Xoossaa Dunkkaaniyaa magalashota, Xoossaa Dunkkaaniyaa, a kammiyoobatanne bollaara kammiyo irppaniyaa, Xoossaa Dunkkaaniyaa geliyoosan kaqqiyo magalashuwaa tookkona; ");
INSERT INTO wal_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","qassi Xoossaa Dunkkaaniyaanne yarshshiyoosaa yuuyi aadhdhida dabaabaa magalashota, dabaabaa geliyoosaa magalashuwaa, wodorotanne etayyo go77iya miishshata ubbaa tookkona. Gershshoona yarati ha miishshatun oottanau bessiya ooso ubbaa oottona. ");
INSERT INTO wal_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tookkiyoobaa gidin, hara ooso gidinkka eti oottiyo ooso ubbai Aarooninne a attuma naati eta azazin oosettona. Neeni eti tookkanau bessiyaabata ubbaa eta aawatettaa aawatettaadan etau gisha. ");
INSERT INTO wal_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Xoossaa Dunkkaaniyaa giddon Gershshoona yarati oottana oosoi muleera hagaa. Eti oottana ooso ubbai qeesiyaa Aaroona na7aa Itaamaara aawatettaa garssaana gidana. ");
INSERT INTO wal_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Maraara yarata eta dabbuwan dabbuwaaninne eta so asan asan shaakkada qooda; ");
INSERT INTO wal_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","yelettoosappe laittai hasttamaappe biidi ishatamaa gakkido attumaasa ubbaa, Xoossaa Dunkkaaniyaa giddon oottanau yiyaageeta qooda. ");
INSERT INTO wal_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","“Eti Xoossaa Dunkkaaniyaa giddon oottana oosoti hageeta: eti Dunkkaaniyaa xagaageta, hiraqota, tuussatanne gedeta, ");
INSERT INTO wal_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","qassikka dabaabaa yuushuwan eqqiya tuussata, he tuussatu gedeta, toliyo xisheta, wodorota, hegeetussi koshshiya miishshata ubbaanne he miishshatuura gaittiyaabata ubbaa tookkona. Issi issi uraassi i tookkanabaa shaakkada gisha. ");
INSERT INTO wal_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Xoossaa Dunkkaaniyaa giddon Maraara yarati oottana oosoi muleera hagaa. Eti oottana ooso ubbai qeesiyaa Aaroona na7aa Itaamaara aawatettaa garssaana gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Muusee Aarooninne maabaraa halaqati Qahaata yaratu attumaasaa eta dabbuwan dabbuwaaninne eta so asan asan shaakkidi qoodidosona. ");
INSERT INTO wal_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Yelettoosappe laittai hasttamaappe biidi ishatamaa gakkido attumaasati ubbati, Xoossaa Dunkkaaniyaa giddon oottanau yiyaageeti, ");
INSERT INTO wal_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","eta so asan asan qoodin muleera 2,750. ");
INSERT INTO wal_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Qahaata yaratun Xoossaa Dunkkaaniyaa giddon oottida asaa qoodai hagaa. GODAI Muuse baggaara azazidoogaadan, Muuseenne Aarooni eta qoodidosona. ");
INSERT INTO wal_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gershshoona yaratikka bantta dabbuwan dabbuwaaninne bantta so asan asan shaahettidi qoodettidosona. ");
INSERT INTO wal_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Yelettoosappe laittai hasttamaappe biidi ishatamaa gakkido attumaasati ubbati, Xoossaa Dunkkaaniyaa giddon oottanau yiyaageeti, ");
INSERT INTO wal_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","eta so asan asan qoodin muleera 2,630. ");
INSERT INTO wal_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gershshoona yaratun Xoossaa Dunkkaaniyaa giddon oottida asaa qoodin hagaa. GODAI Muuse baggaara azazidoogaadan, Muuseenne Aarooni eta qoodidosona. ");
INSERT INTO wal_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Maraara yaratikka qassi dabbuwan dabbuwaaninne bantta so asan asan shaahettidi qoodettidosona. ");
INSERT INTO wal_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Yelettoosappe laittai hasttamaappe biidi ishatamaa gakkido attumaasati ubbati, Xoossaa Dunkkaaniyaa giddon oottanau yiyaageeti, ");
INSERT INTO wal_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","eta so asan asan qoodin muleera 3,200. ");
INSERT INTO wal_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Maraara yaratu qoodai hagaa. GODAI Muuse baggaara azazidoogaadan, Muuseenne Aarooni eta qoodidosona. ");
INSERT INTO wal_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Hegaa oottidi Muusee, Aarooninne Israa7eela halaqati Leewata ubbaa, eta yaran yaraaninne eta so asan asan shaakkidi qoodidosona. ");
INSERT INTO wal_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Yelettoosappe laittai hasttamaappe biidi ishatamaa gakkido attumaasati ubbati, Xoossaa Dunkkaaniyaa giddon oosuwaa oottanaunne ayyo go77iya miishshata ubbaa tookkanau yiidaageeti ");
INSERT INTO wal_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","muleera 8,580. ");
INSERT INTO wal_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","GODAI Muuse baggaara azazidoogaadan, eti huuphiyan huuphiyan oottana oosoi woikko tookkana toohoikka etau odettiis. GODAI Muusa azazidoogaadan, eti ubbaikka qoodettidosona. ");
INSERT INTO wal_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Neeni Israa7eelata, ‘Intte giddon hanttaara goga harggee oiqqido uraa, woikko bollaappe aibakko uzuuziyo uraa, woikko ahaa oiqqidi tunida uraa oonakka intte dunkkaanidosaappe kessirggite’ yaagada azaza. ");
INSERT INTO wal_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Hegee maccaa attumaa gidinkka kessona. Taani eta gidduwan de7iyo eti dunkkaanidosaa hegeeti tunissenna mala, eta dunkkaanidosaappe kessa yedda” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Yaagin GODAI Muusa azazidoogaadan, Israa7eelati eta ubbaa dunkkaanidosaappe kessidi yeddidosona. ");
INSERT INTO wal_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Neeni Israa7eelata hagaadan yaaga; ‘Issi attumaasi woikko issi maccaasi ai ogiyaaninne hara asa naaqqikkonne hegan GODAASSI ammanettennan ixxikko, he urai mooranchcha. ");
INSERT INTO wal_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Hegaa gishshau, i ba oottido nagaraa paaxo; paaxidi ba mooridobaa kumettaa zaaridi qanxxo; hegaa bollikka ichchashantta kushiyaa gujjidi, ba naaqqido uraassi edato. ");
INSERT INTO wal_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","SHin he naaqettida uri haiqqidabaa gidikkonne, edaa ekkanau au mata dabboi xayikko, he edai GODAASSA. He edatiyo edai naaqqida urai maarettanau yarshshuwaassi immiyo dorssa orggiyaara issippe qeesiyaayyo imetto. ");
INSERT INTO wal_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Qassi Israa7eelati qeesiyaassi immiyo geeshsha imo ubbai he qeesiyaassa. ");
INSERT INTO wal_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Issi issi asi immiyo imotai he immida uraabaa; shin qeesiyaassi i immiyo imotai he qeesiyaassa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Hegaappe guyyiyan GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Neeni Israa7eelatussi hagaadan yaagada yoota; ‘Issi uraa keettaayyiyaa kare hemettada, ayyo ammanettennan ixxada, ");
INSERT INTO wal_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","hara attuma asaara zin77ikko, qassi hegaa a ba keettaawaappe qosikko, markkai bainnabaa gidikkonne, a shaaramuxaidda ohettennan attikko, ");
INSERT INTO wal_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","a tunido gishshau, i keettaawai o siriyaagaa gidanau danddayees; woikko a tunennan de7ishin, i ba keettaayyiyo siriyaagaa gidanau danddayees. ");
INSERT INTO wal_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Yaatikko, he bitanee ba keettaayyiyo qeesiyaakko efo; qassi i gishshau yarshshanau issi kilo giraame banggaa xiilliyaa efo. SHin xiilliyaa bolli zaitiyaa tigoppo, woikko ixaanaa a bolli wottoppo; aissi giikko, he xiillee i ba keettaayyiyo sirido gishshau yarshshiyo kattaa yarshsho; qassi i mooruwaa qonccissiya yarshsho. ");
INSERT INTO wal_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“‘Hegaappe guyyiyan, qeesee he mishiriyo shiishshidi, GODAA sinttan esso. ");
INSERT INTO wal_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Essidi anjjettida haattaa kuixaaruwan ekko. Hegaappe guyyiyan, Xoossaa Dunkkaaniyaa wuigen de7iya buhiyaa ekkidi, he haattan gujjo. ");
INSERT INTO wal_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Gujjidi he mishiriyo GODAA sinttan esso; hegaappe guyyiyan, he mishiree huuphiyaa birshsho; birshshidi sirido gishshau yarshshiyo i mooruwaa qonccissiya kattaa yarshshuwaa i kushiyan wotto; qassi he qeesee ba kushiyan qanggettaa ehiya camo haattaa kuixaaruwaara oiqqo. ");
INSERT INTO wal_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Oiqqidi mishiriyo hagaadan yaagidi caaqetto; “Neeni hara attumaasaara zin77abeennabaa gidikkonne, ne keettaawaa aggada kare hemettada tunabeennabaa gidikko, qanggettaa ehiya ha camo haattai neeyyo gometoppo. ");
INSERT INTO wal_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","SHin neeni ne keettaawaa aggada kare hemettada tunidobaa gidikkonne, hara attuma asaara zin77idabaa gidikko, ");
INSERT INTO wal_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","GODAI ne yelo keettaa gunddissiyoogaaninne ne uluwaakka puurissiyoogan, ne asan nena qanggisso. ");
INSERT INTO wal_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ha qanggettaa ehiya haattai ne ulo giddo gelo; gelidi ne uluwaa puurisso; ne yelo keettaakka gunddisso” yaagidi caaqetto. “‘Mishiriyaakka, “Amin77i; amin77i” yaagu. ");
INSERT INTO wal_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“‘Hegaappe guyyiyan, qeesee ha qanggettata xaaxettida maxaafan xaafo; xaafido qanggettata camo haattaa giddo meecco. ");
INSERT INTO wal_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Yaatidi qanggettaa ehiya he camo haattaa mishiriyo ushsho; qanggettaa ehiya haattai mishiree uluwan gelidi, o camo sahuwaa sakkana. ");
INSERT INTO wal_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Qeesee mishiree kushiyaappe sirido gishshau yarshshiyo kattaa yarshshuwaa ekkidi, he yarshshuwaa GODAA sinttan wuxaawuxidi, yarshshiyoosaa eho. ");
INSERT INTO wal_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ehiidi qeesee kattaa yarshshuwaappe zolliyaagaa ekko; ekkidoogaa mooruwaa qonccissiya yarshsho oottidi, yarshshiyoosan xuuggo. Hegaappe guyyiyan, mishiriyo he haattaa ushsho. ");
INSERT INTO wal_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Haattaa o ushshidoogaappe guyyiyan, hagaadan hanana: a ba keettaawaassi ammanettana xayada tunidabaa gidikko, qanggettaa ehiya haattai i uluwan gelidi, o camo sahuwaa sakkana; i uloikka puurana; i yelo keettaikka gunddana. A ba asan qanggettidaaro gidana. ");
INSERT INTO wal_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","SHin a tunabeenna xillo maccaasa gidikko, a saro attada naata yelana. ");
INSERT INTO wal_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","“‘Issi asi ba keettaayyiyo siriyo wode oottana wogai hagaa. A kare hemettada tunikko, woikko issi asi ba keettaayyiyo sirikko, GODAA sinttan o esso; essidi qeesee ha wogaa ubbaa i bolli polo. ");
INSERT INTO wal_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Polobare keettaawai mooro ubbaappe saro attana; shin maccaasiyaa ba nagaraa gaasuwan yiyaabaa tookkana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","GODAI Muusa hagaadan yaagiis, ");
INSERT INTO wal_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Neeni Israa7eela asaassi hagaadan yaagada yoota; ‘Attuma asi woikko macca asi Naaziraawe gididi, bana GODAAYYO dummayanau geppikko, ");
INSERT INTO wal_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","woiniyaa eessaanne hara mattoyiya ushshaa uyoppo; woiniyaa aifiyaappe agettiya caalabaanne mattoyiyaabaa uyoppo; woiniyaa teeraa gum77idoogaa uyoppo. Woikko woiniyaa teeraa shuguwaa gidin, melaa gidinkka mooppo; ");
INSERT INTO wal_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","i bana dummayido wodiyan ubban, woine turaappe beettiyaabaa ubbaa, woiniyaa zerettaa gidin, woikko woiniyaa poquwaa gidinkka mooppo. ");
INSERT INTO wal_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘I bana GODAAYYO dummayanau geppido wodiyan ubban, a huuphee meedettoppo woikko qanxxettoppo. I ba huuphiyaa binnaanaakka adussidi dichcho. I bana GODAAYYO dummayido wodee polettana gakkanaassi, geeshsha gidanau koshshees. ");
INSERT INTO wal_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘I bana GODAAYYO dummayido wodiyan ubban ahaakko shiiqoppo. ");
INSERT INTO wal_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Harai attin a aawai, woikko a aayyiyaa, woikko a ishai, woikko a michchiyaa haiqqikkokka, i bana tunissoppo. Aissi giikko, i bana Xoossaassi dummayidoogaa erissiyoi ba huuphiyaana. ");
INSERT INTO wal_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","I bana GODAAYYO dummayido wodiyan ubban i GODAASSI geeshsha. ");
INSERT INTO wal_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘Asi a matan akeekennan haiqqin, GODAAYYO dummayido a huuphee tunikko, laappun gallassaa gam77idi, ba geeyiyo he laappuntta gallassi ba huuphiyaa meedetto. ");
INSERT INTO wal_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Hosppuntta gallassan naa77u haraphpheta woikko naa77u mara haraphpheta Xoossaa Dunkkaaniyaa pengge qeesiyaayyo eho. ");
INSERT INTO wal_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ehin qeesee haraphphetuppe issuwaa nagaraa yarshshuwau, issuwaa qassi xuuggiyo yarshshuwau yarshsho. Aissi giikko, ahai a mati shiiqido mooruwaa gishshau, ayyo atto giissanaassa. He gallassi i ba huuphiyaa wogaadan geeshsho; ");
INSERT INTO wal_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","i bana kase geppido wodiyaa keenaa bana GODAAYYO dummayanau koshshees. Yaatidi yelettoosappe issi laitta gidiyo attuma dorssaa naaquwaassi immiyo yarshsho oottidi yarshsho. SHin hegaappe kase i bana GODAAYYO dummayido gallassati qoodettokkona; aissi giikko, i bana dummayido he wodetu giddon bana tunissirggiis. ");
INSERT INTO wal_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘Ba gefaa wodiyaa wurssido wode bana GODAAYYO dummayida Naaziraawiyaa wogai hagaa: Xoossaa Dunkkaaniyaa pengge i shiiqo; ");
INSERT INTO wal_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","shiiqiiddi GODAAYYO tilla bollaara de7iya issi laitta attuma dorssaa xuuggiyo yarshshuwau, tilla bollaara de7iya issi laitta dorssiyo nagaraa yarshshuwaunne tilla bollaara de7iya dorssa orggiyaa issippetettaa yarshshuwau he sohuwaa eho. ");
INSERT INTO wal_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Qassi kattaa yarshshuwaanne ushshaa yarshshuwaa etaara issippe yarshshanau eho; he kattaa yarshshoi irshshoi gelibeennaagaa gido; qassi zaitiyan munaqqido liiqo xiilliyaa komppotanne zaitiyaa tiyido lee7e lichchakkota masoofiyan eho. ");
INSERT INTO wal_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“‘Ehin qeesee hegaa ubbaa shiishshidi, nagaraa yarshshonne xuuggiyo yarshsho oottidi, GODAAYYO a gishshaa yarshsho. ");
INSERT INTO wal_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Qeesee dorssa orggiyaa, irshshoi gelibeenna komppotanne lichchakkota issippetettaa yarshsho oottidi, GODAASSI yarshsho. Qassi hegaara issippe kattaa yarshshuwaanne ushshaa yarshshuwaa yarshsho. ");
INSERT INTO wal_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Hegaappe guyyiyan, Naaziraawee GODAAYYO dummayido ba huuphiyaa Xoossaa Dunkkaaniyaa penggen meedetto; meedettido binnaanaa efiidi, issippetettaa yarshshuwaappe garssa baggaara de7iya taman yeggo. ");
INSERT INTO wal_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“‘Bana GODAAYYO dummayida Naaziraawee ba huuphiyaa meedettidoogaappe guyyiyan, qeesee doisettida dorssa orggiyaa missaa, irshshoi gelibeenna issi komppuwaanne issi lee7e lichchakkuwaa ekkidi, ha Naaziraawiyaa kushiyan wotto. ");
INSERT INTO wal_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Wottidi qeesee eta wuxaawuxo yarshsho oottidi, GODAA sinttan wuxaawuxo. Yaatobare hegeeti wuxaawuxido anggaasuwaaranne yarshshido gedaara geeshshanne qeesiyaassa. Hegaappe guyyiyan, GODAAYYO bana dummayida Naaziraawee woiniyaa eessaa uyana giikko uyo. ");
INSERT INTO wal_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘Simmi GODAASSI bana dummayanau geppida Naaziraawiyaassi wotto wogai hagaa: bana GODAASSI yarshshanau koshshiya yarshshotuppe aadhdhiyaabaa immanau geppidabaa gidikko, i ba geppido gefaa keenaa gattanau koshshees’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aaroonassinne a attuma naatussi hagaa yoota; ‘Israa7eela asaa intte hagaadan yaagidi anjjite; ");
INSERT INTO wal_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“GODAI inttena anjjonne inttena naago; ");
INSERT INTO wal_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","GODAI intteyyo ba som77uwaa poo7issonne intteyyo qaretto; ");
INSERT INTO wal_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","GODAI inttena ba keha aifiyan xeellonne intteyyo sarotettaa immo” yaagidi anjjite’ yaaga. ");
INSERT INTO wal_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Eti Israa7eela asaa ta sunttan anjjiyo wode, taani eta anjjana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Muusee Xoossaa Dunkkaaniyaa tolidi makkido wode, he Dunkkaaniyaanne a miishshaa ubbaa tiyidi geeshshiis; qassi yarshshiyoosaanne a miishshaa ubbaakka tiyidi geeshshiis. ");
INSERT INTO wal_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hegaappe guyyiyan, Israa7eela asaa kaalettidaageeti, hegeetinne zareta qoodida so asaa halaqati ");
INSERT INTO wal_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","GODAAYYO imota shiishshidosona; hegeetikka kamettida usuppun gaareta, tammanne naa77u boorata, halaqan halaqan issi issi booraanne naa77u naa77u halaqati issi issi gaariyaa Xoossaa Dunkkaaniyaa ehiidosona. ");
INSERT INTO wal_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Xoossaa Dunkkaaniyaa oosuwaassi go77ana mala, neeni hegeeta etappe ekkada, Leewatuyyo eta oosuwaassi oosuwaassi koshshiyaadan shaakkada imma” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Yaagin Muusee gaaretanne boorata ekkidi, Leewatuyyo immiis. ");
INSERT INTO wal_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gershshoona yaratuyyo eta oosuwaassi koshshiyoogaadan shaakkidi, naa77u gaaretanne oiddu boorata immiis. ");
INSERT INTO wal_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Qassi Maraara yaratuyyo eta oosuwaassi koshshiyoogaadan shaakkidi, oiddu gaaretanne hosppun boorata immiis. Eti ubbaikka qeesiyaa Aaroona na7aa Itaamaara aawatettaa garssaana. ");
INSERT INTO wal_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","SHin Muusee Qahaata yaratussi hegaappe aibanne immibeenna; aissi giikko, eta aawatettan de7iya geeshsha miishshati bantta hashiyan tookkanau koshshiyaageeta gidiyo gishshaassa. ");
INSERT INTO wal_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Yarshshiyoosaa Muusee tiyidi geeshshido gallassan, halaqati yarshshiyoosaa anjjissanau bantta imuwaa ekkidi, he yarshshuwaa saaxiniyaa sintti ehiidosona. ");
INSERT INTO wal_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","GODAI Muusa kase, “Issi issi gallassi issi halaqai yarshshiyoosaa anjjanau ba imuwaa GODAAYYO immo” yaagi wottiis. ");
INSERT INTO wal_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Koiro gallassi ba imuwaa ehiidaagee Yihudaa zariyaappe Aminadaaba na7aa Na7asoona. ");
INSERT INTO wal_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Na7asooni ehiido imoi erettida meezaanan wottin, issi kilo giraamenne bagga deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaa yarshshanau liiqo xiillee zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido, ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","xuuggiyo yarshshuwaassi, issi mirgguwaa, issi dorssa orggiyaanne issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Aminadaaba na7ai Na7asooni ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Naa77antta gallassi Yisaakoora zaretu halaqai, Xu7aara na7ai Nataani7eeli ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Nataani7eeli ehiido imoi erettida meezaanan wottin, issi kilo giraamenne bagga deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaa yarshshanau liiqo xiillee zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido, ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Xu7aara na7ai Nataani7eeli ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Heezzantta gallassi Zaabiloona zaretu halaqai, Heloona na7ai Eli7aabi ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Eli7aabi ehiido imoi erettida meezaanan wottin, issi kilo giraamenne bagga deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaa yarshshanau liiqo xiillee zaitiyan munaqettidaagee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido, ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","nagaraa yarshshuwaassi issi deeshsha orggiyaa, ");
INSERT INTO wal_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Heloona na7ai Eli7aabi ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Oiddantta gallassi Roobeela zaretu halaqai SHade7uura na7ai Eliixuuri ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Eliixuuri ehiido imoi erettida meezaanan wottin, issi kilo giraamenne bagga deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaa yarshshanau liiqo xiillee zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido, ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. SHade7uura na7ai Eliixuuri ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ichchashantta gallassi Simoona zaretu halaqai, Xuriishadaaya na7ai SHalumi7eeli ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","SHalumi7eeli ehiido imoi erettida meezaanan wottin, issi kilo giraamenne baggaa deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaa yarshshanau liiqo xiillee zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne, issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Xuriishadaaya na7ai SHalumi7eeli ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Usuppuntta gallassi Gaada zaretu halaqai, Da7u7eela na7ai Eliyasaafi ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Eliyasaafi ehiido imoi erettida meezaanan wottin, issi kilo giraamenne bagga deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaassi yarshshanau liiqo xiillee zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Da7u7eela na7ai Eliyasaafi ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Laappuntta gallassi Efireema zareta halaqai Amihuuda na7ai Elishamaa7i ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Elishamaa7i ehiido imoi erettida meezaanan wottin, issi kilo giraamenne baggaa deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaassi yarshshanau liiqo xiillee zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne, issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Amihuuda na7aa Elishamaa7a imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Hosppuntta gallassi Minaase zaretu halaqai Padaaxuura na7ai Gamaali7eeli ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Gamaali7eeli ehiido imoi erettida meezaanan wottin, issi kilo giraamenne baggaa deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaassi yarshshanau liiqo xiillee zaitiyaan munaqqidoogee kumidoogeeta ");
INSERT INTO wal_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne, issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","nagaraa yarshshuwaassi issi deeshsha orggiyaa, ");
INSERT INTO wal_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Padaaxuura na7ai Gamaali7eeli ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Uddufuntta gallassi Biniyaama zaretu halaqai Giidi7oona na7ai Abidaani ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Abidaani ehiido imoi erettida meezaanan wottin, issi kilo giraamenne baggaa deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaassi yarshshanau liiqo xiillee, zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido, ixaanai kumido shaatiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","xuuggiyo yarshshuwaassi issi mirgguwaa issi dorssa orggiyaanne, issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne, issi laitta kumido ichchashu attuma dorssata. Giidi7oona na7ai Abidaani ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Tammantta gallassi Daana zaretu halaqai Amishadaaya na7ai Ahi7eezeri ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ahi7eezeri ehiido imoi erettida meezaanan wottin, issi kilo giraamenne baggaa deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaassi yarshshanau liiqo xiillee, zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido, ixaanai kumido shaatiyaa. ");
INSERT INTO wal_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne, issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Amishadaaya na7ai Ahi7eezeri ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Tammanne isiinintta gallassi Aseera zaretu halaqai Okiraana na7ai Paagi7eeli ba yarshshuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Paagi7eeli ehiido imoi erettida meezaanan wottin, issi kilo giraamenne baggaa deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaassi yarshshanau liiqo xiillee, zaitiyan munaqqidoogee kumidoogeeta; ");
INSERT INTO wal_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido shaatiyaa, ixaanai kumidoogaa; ");
INSERT INTO wal_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nagaraa yarshshuwaassi issi deeshsha orggiyaa; ");
INSERT INTO wal_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Okiraana na7ai Paagi7eeli ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Tammanne naa77antta gallassi Nifttaaleema zaretu halaqai Enaana na7ai Ahiraa7i ba imuwaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ahiraa7i ehiido imoi erettida meezaanan wottin, issi kilo giraamenne baggaa deexxiya biraappe medhdhido issi keriyaanne hosppun xeetu giraame deexxiya biraappe medhdhido issi kuixaaruwaa, naa77aikka kattaa yarshshuwaassi yarshshanau liiqo xiillee, zaitiyan munaqqidoogee kumidoogeeta, ");
INSERT INTO wal_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","qassi issi xeetanne tammu giraame deexxiya worqqaappe medhdhido issi shaatiyaa, ixaanai kumidoogaa; ");
INSERT INTO wal_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","xuuggiyo yarshshuwaassi issi mirgguwaa, issi dorssa orggiyaanne issi laitta kumido attuma dorssaa; ");
INSERT INTO wal_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nagaraa yarshshuwaassi issi deeshsha orggiyaa, ");
INSERT INTO wal_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","issippetettaa yarshshuwaassi naa77u korimata, ichchashu dorssa orggeta, ichchashu gakkida deeshsha orggetanne issi laitta kumido ichchashu attuma dorssata. Enaana na7ai Ahiraa7i ehiido imoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Yarshshiyoosai tiyettido wode, Israa7eelatu halaqati yarshshiyoosaa anjjanau ehiido imoti muleera hageeta: Biraappe medhdhido tammanne naa77u kereta, biraappe medhdhido tammanne naa77u kuixaarotanne worqqaappe medhdhido tammanne naa77u shaateta; ");
INSERT INTO wal_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","biraappe medhdhido issi issi keree issi kilo giraamenne baggaa deexxees; biraappe medhdhido issi issi kuixaaroi hosppun xeetu giraame deexxees; biraappe merettida kereenne kuixaaroi erettida meezaanan wottin, muleera laatamanne hosppun kilo giraame keenaa deexxoosona. ");
INSERT INTO wal_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tammanne naa77u worqqa shaateti erettida meezaanan wottin issoi issoi issi xeetanne tammu giraame, muleera issi kilonne heezzu xeetu giraame deexxoosona. Etan ixaanai kumi uttiis. ");
INSERT INTO wal_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Kattaa yarshshuwaara issippe xuuggiyo yarshshuwaassi ehiido mehee muleera tammanne naa77u mirggota, tammanne naa77u dorssa orggetanne issi laitta kumido tammanne naa77u attuma dorssata. Eti nagaraa yarshshuwaassi ehiido deeshsha orggeti muleera tammanne naa77a. ");
INSERT INTO wal_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Eti issippetettaa yarshshuwaassi ehiido mehee muleera laatamanne oiddu korimata, usuppun tammu dorssa orggeta, usuppun tammu gakkida deeshsha orggetanne issi laitta kumido usuppun tammu attuma dorssata. Yarshshiyoosai tiyettidoogaappe guyyiyan, anjjuwaassi ehiido imoti hageeta. ");
INSERT INTO wal_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Muusee GODAARA haasayanau Xoossaa Dunkkaaniyaa geliyo wode, Maachchaa Taabootaa bollan de7iya atto giyo sohuwaa qum77uwaa bollan, naa77u kiruubetuppe gidduwaara GODAI haasayiyo cenggurssaa siyiis; siyidi ikka aara haasayiis. ");
INSERT INTO wal_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Neeni Aaroonassi hagaadan yaagada oda; ‘Neeni laappun xomppeta wottiyo wode xomppeti xomppiyaa wottiyo ballatuppe sintta baggaara de7iya heerata poo7issona’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Yaagin i giidoogaadan Aarooni oottiis. GODAI Muusa azazidoogaadan, Aarooni xomppeta wottiyo ballatuppe sintta baggaara de7iya heerata poo7issanaadan oottidi, ballatun wottiis. ");
INSERT INTO wal_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Xomppiyaa wottiyoogee garssa tohuwaappe bolla ciishshaara alleeqettida ballata xeeraa gakkanaassi qoxettida worqqaappe merettiis. Xomppiyaa wottiyo ballai GODAI Muusa bessido leemisuwaadan oosettiis. ");
INSERT INTO wal_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Qassi GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Hara Israa7eela asaa gidduwaappe Leewata ekkada, eta wogaadan geeshsha. ");
INSERT INTO wal_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Neeni eta geeshshanau hagaadan ootta: geeshshiya haattaa ekkada eta araca; aracin eti bantta bollaa ubbaa meedettona; bantta maayuwaakka meeccona; yaatidi eti wogaadan geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Hegaappe guyyiyan, eti mirgguwaa issuwaanne liiqo xiilliyaa zaitiyan munaqqidoogaa kattaa yarshshuwaassi ekkona; ekkin neeni qassi naa77antto mirgguwaa nagaraa yarshshuwaassi ekka. ");
INSERT INTO wal_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Yaatada Leewata Xoossaa Dunkkaaniyaa sintti eha; ehaada Israa7eela asaa maabaraa ubbaa shiishsha. ");
INSERT INTO wal_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Neeni Leewata GODAA sinttau ehin, Israa7eela asai eta bolli bantta kushiyaa wottona. ");
INSERT INTO wal_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Leewati GODAA oosuwaa oottanau giigana mala, Aarooni Israa7eela asaappe Leewata wuxaawuxiyo yarshsho oottidi, GODAA sintti shiishsho. ");
INSERT INTO wal_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Leewati bantta kushiyaa mirggotu huuphiyan wottona; issuwaa nagaraa yarshsho oottada, issuwaa qassi Leewati atto geetettana mala, xuuggiyo yarshsho oottada GODAASSI yarshsha. ");
INSERT INTO wal_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Leewata Aaroonanne a attuma naatu aawatettaa garssan wotta; yaatada eta wuxaawuxiyo yarshsho oottada, GODAA sintti shiishsha. ");
INSERT INTO wal_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Hegaadan oottada Leewata hara Israa7eela asaappe dummaya; dummayobare Leewati tabaa gidana. ");
INSERT INTO wal_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Neeni Leewata geeshshidoogaappenne wuxaawuxiyo yarshsho oottada shiishshidoogaappe guyyiyan, Xoossaa Dunkkaaniyan bantta oosuwaa oottanau yoona. ");
INSERT INTO wal_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israa7eela asaa gidduwaappe eti taayyo muleera imettidosona; Israa7eela maccaasaappe yelettida baira attumaageetu ubbaa gishshaa taani Leewata taayyo ekkaas. ");
INSERT INTO wal_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israa7eela asaa gidduwan baira yelettidabi asa gidin, mehe gidinkka ubbai tabaa. Taani Gibxxe biittan baira ubbaa worido gallassan, eta taayyo dummayaas. ");
INSERT INTO wal_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Israa7eela baira attumaageetu ubbaa gishshaa taani Leewata ekkaas. ");
INSERT INTO wal_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Israa7eela asaa ubbaa gidduwaappe taani Leewata Aaroonayyoonne Aaroona attuma naatuyyo imo oottada immaas. Israa7eela asai Xoossaa Dunkkaaniyaa shiiqiyo wode, boshai eta bochchenna mala, Leewati Israa7eela asaa gishsha Xoossaa Dunkkaaniyan bantta oosuwaa oottonanne eta gishshaa atto geetettona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","GODAI Muusa Leewata dummayanau azazidoogaadan Muusee, Aarooninne Israa7eela asaa maabarai ubbai oottidosona. ");
INSERT INTO wal_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leewati nagaraappe banttana geeshshidosona; bantta maayuwaakka meeccidosona. Meeccin Aarooni eta wuxaawuxiyo yarshsho oottidi, GODAA sintti shiishshiis; eta geeshshanau eta nagaraa atto giissiis. ");
INSERT INTO wal_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Hegaappe guyyiyan, Leewati Aaroonanne Aaroona attuma naatu aawatettaa garssan, Xoossaa Dunkkaaniyaa giddon bantta oosuwaa oottanau yiidosona. GODAI Muusa Leewata dummayanau azazidoogaadan eti oottidosona. ");
INSERT INTO wal_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Qassikka GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Hagee Leewata xeelliya wogaa: laittai laatamanne ichchashaanne hegaappe bollaara de7iya attumaageeti oosuwaa oottanau Xoossaa Dunkkaaniyaa yoona. ");
INSERT INTO wal_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","SHin eta laittai ishatamaa gidiyo wode eti bantta oosuwaappe xurataa kiyona; kiyi simmidi naa77antto oottoppona. ");
INSERT INTO wal_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Eti Xoossaa Dunkkaaniyan oottiya bantta ishantta ootti maaddana giikko maaddonappe attin, eti banttarkka ai oosonne oottoppona. Simmi neeni Leewata oosuwaa hagaadan ootissaasa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israa7eela asai Gibxxeppe kiyido naa77antta laittan koiro aginan Siinaa Bazzuwan GODAI Muuseyyo hagaadan yaagidi haasayiis; ");
INSERT INTO wal_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Israa7eela asai Paasikaa Baalaa keerido gallassan bonchcho. ");
INSERT INTO wal_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ha aginan tammanne oiddantta gallassan, a keerido wode, awai wullana haniyo wode, a wogaa ubbaadaaninne a azazo ubbaadan bonchcho” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Yaagin Muusee Israa7eela asai Paasikaa Baalaa bonchchana mala, etayyo yootiis. ");
INSERT INTO wal_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Koiro aginaayyo tammanne oiddantta gallassi, awai wullana haniyo wode Siinaa Bazzuwan eti Paasikaa Baalaa bonchchidosona. Israa7eela asai GODAI Muusa azazidoogaadan ubbabaa oottiis. ");
INSERT INTO wal_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","SHin etappe amaridaageeti haiqqida asa ahaa bochchidi tunido gishshau, he gallassi Paasikaa Baalaa bonchchanau danddayibookkona. Hegaa gishshau, eti Muusekkonne Aaroonakko he gallassi yiidi, ");
INSERT INTO wal_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Muusa, “Nuuni haiqqida asa ahaa bochchido gishshau tunida; shin keerido wodiyan hara Israa7eela asaara GODAAYYO yarshshuwaa shiishshiyoogaa nuuni aissi digettiyoonii?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Yaagin Muusee eta, “GODAI inttebaa taassi azaziyoobaa taani siyana gakkanaassi intte takkishshite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Hegaappe guyyiyan GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Neeni Israa7eela asaa hagaadan yaaga; ‘Intteppe woikko intte zaretuppe ooninne ahaa bochchidi tunikko, woikko manddaridabaa gidikko, i GODAAYYO Paasikaa Baalaa bonchcho; ");
INSERT INTO wal_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","naa77antto aginan tammanne oiddantta gallassi awai wullana haniyo wode Paasikaa Baalaa bonchcho. Bonchchiiddi Paasikaa dorssaa irshshoi gelibeenna oittaaranne camo bonccuwaara mo. ");
INSERT INTO wal_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sa7ai wonttanaashin he dorssaappe aibanne ashshoppo; qassi a meqettaappekka issuwaanne menttoppo. Paasikaa Baalau a woga ubbaa ootto. ");
INSERT INTO wal_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","SHin manddaribeenna geeshsha asi Paasikaa bonchchennan ixxikko, hegaappe sinttau i ta asaa giddoppe bohetto. Aissi giikko, GODAA yarshshuwaa keerido wodiyan i shiishshibeenna. He asi ba nagarai ehiido metuwaa ekkanau bessees. ");
INSERT INTO wal_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“‘Intte gidduwan de7iya bete asi Paasikaa Baalaa GODAAYYO bonchchana koyikko, Paasikaa wogaadan bonchcho. Betiyaukka dere asaukka issi mala wogai de7o’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Xoossaa Dunkkaanee tolettido gallassi shaarai Xoossaa Dunkkaaniyaa maayiis; omarssaappe doommidi, wonttana gakkanaassi Xoossaa Dunkkaaniyaappe bollaara de7iya shaarai tama milatees. ");
INSERT INTO wal_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hegaadan ubba wode gallassi gallassi shaarai maayees; qammi qammi he shaarai tamadan poo7ees. ");
INSERT INTO wal_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","He shaarai Xoossaa Dunkkaaniyaa bollaappe denddiyo wode audenne Israa7eelati bantta dunkkaanidosaappe denddoosona; qassi he shaarai wodhdhiyo ai sohuwaaninne Israa7eelati dunkkaanoosona. ");
INSERT INTO wal_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israa7eelati GODAA azazuwan denddoosona; hegaadankka, GODAA azazuwan dunkkaanoosona. SHaarai Xoossaa Dunkkaaniyaa bollan gam77iyo wode ubban bantta dunkkaanidosan gam77oosona. ");
INSERT INTO wal_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","SHaarai Xoossaa Dunkkaaniyaa bollan daro gallassaa gam77ikko, Israa7eelati GODAA azazuwaa naagoosonappe attin, awanne bookkona. ");
INSERT INTO wal_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Issitoo issitoo shaarai Xoossaa Dunkkaaniyaa bollan amarida gallassaa gam77ees. GODAA azazuwan eti dunkkaanoosona; qassi hegaadankka, GODAA azazuwan eti denddoosona. ");
INSERT INTO wal_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Issitoo issitoo shaarai omarssappe wonttana gakkanaashin xalaalaa gam77ees; wonttin shaarai denddiyo wode etikka denddoosona. Gallassa gidin, qamma gidin, shaarai denddiyo wode etikka denddoosona. ");
INSERT INTO wal_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","SHaarai Xoossaa Dunkkaaniyaa bollan naa77u gallassaa gam77in, woikko issi aginaa, woikko issi laittaa gam77in, Israa7eelati bantta dunkkaanidosan gam77oosonappe attin bookkona. SHin shaarai denddiyo wode etikka denddoosona. ");
INSERT INTO wal_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Eti GODAA azazuwan dunkkaanoosonanne qassi GODAA azazuwan denddoosona; GODAI Muuse baggaara azazidoogaadan, eti GODAA azazuwaa naagidosona. ");
INSERT INTO wal_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Naa77u xurumbbata biraappe qoxxada ootta; yaatada asaa shiiquwau xeeganaunne qassi dunkkaanidosaappe denddanau denttettanaadan punna. ");
INSERT INTO wal_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ha naa77u xurumbbati punettiyo wode, asai ubbai Xoossaa Dunkkaaniyaa penggee neekko shiiqo. ");
INSERT INTO wal_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","SHin issi xurumbba xalaalai punettikko, Israa7eela zareta halaqati ne sintti shiiqona. ");
INSERT INTO wal_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Neeni xurumbbaa xoqqu oottada punniyo wode Xoossaa Dunkkaaniyaappe arshsho baggaara dunkkaanida zareti denddona. ");
INSERT INTO wal_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Xurumbbaa naa77antto xoqqu oottada punniyo wode, tohossa baggaara dunkkaanida zareti denddona. Xurumbbai xoqqu gi punettiyoogee denddanau malaata gido. ");
INSERT INTO wal_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Yaa7au asaa shiishshanau xurumbbaa punna; shin cenggurssaa xoqqu oottada punnoppa. ");
INSERT INTO wal_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aaroona naati qeeseti xurumbbaa punnona. Hagee neeyyoonne yiya yeleta ubbau merina woga gido. ");
INSERT INTO wal_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Intte biittan woraajjiya intte morkkiyaara intte olettanau kiyiyo wode, he xurumbbata xoqqu oottidi punnite. Hegan GODAI intte Xoossai inttena he wode hassayidi, intte morkkiyaappe inttena ashshana. ");
INSERT INTO wal_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Hegaadankka, qassi intte ufaittiyo gallassi, baalaa bonchchanau intte keerido gallassinne aginai xeeriyo baalan, intte xuuggiyo yarshshiyo wodenne intte issippetettaa yarshshuwaa yarshshiyo wode he xurumbbata punnite; hegee Xoossaa sinttan inttena hassayissiyaagaa gidana. Taani GODAA, intte Xoossaa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Naa77antta laittan naa77antta aginan laatamantta gallassi, shaarai Xoossaa Dunkkaaniyaa bollappe denddiis. ");
INSERT INTO wal_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Hegaappe guyyiyan, Israa7eela asai Siinaa Bazzuwaappe denddiis; shaarai Paaraana giyo bazzuwaa gakkidi wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Eti ha koiro buussau GODAI Muuse baggaara azazidoogaadan denddidosona. ");
INSERT INTO wal_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yihudaa zaretuura dunkkaanida baggai bantta armmaa oiqqidi denddiis. Yihudaa zaretu halaqai Aminadaaba na7aa Na7asoona; ");
INSERT INTO wal_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Yisaakoora zaretu halaqai Xu7aara na7aa Nataani7eela; ");
INSERT INTO wal_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zaabiloona zaretu halaqai Heloona na7aa Eli7aaba. ");
INSERT INTO wal_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hegaappe guyyiyan, Xoossaa Dunkkaaniyaa shoddin, Gershshoona yaratinne Maraara yarati tookkidi denddidosona. ");
INSERT INTO wal_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kaallidi Roobeela zaretuura dunkkaanida baggai bantta armmaa oiqqidi denddiis. Roobeela zaretu halaqai SHade7uura na7aa Eliixuura; ");
INSERT INTO wal_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simoona zaretu halaqai Xuriishadaaya na7aa SHalumi7eela; ");
INSERT INTO wal_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gaada zaretu halaqai Da7u7eela na7aa Eliyasaafa. ");
INSERT INTO wal_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Hegaappe guyyiyan, Qahaata yarati geeshsha miishshata tookkidi denddidosona. Eti gakkanaappe kasetidi, Xoossaa Dunkkaanee toletti uttiis. ");
INSERT INTO wal_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kaallidi Efireema zaretuura dunkkaanida baggai ba armmaa oiqqidi denddiis. Efireema zaretu halaqai Amihuuda na7aa Elishamaa7a; ");
INSERT INTO wal_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Minaase zaretu halaqai Padaaxuura na7aa Gamaali7eela; ");
INSERT INTO wal_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Biniyaama zaretu halaqai Giidi7oona na7aa Abidaana. ");
INSERT INTO wal_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Wurssettan, ha cita ubbaayyo guyye baggan naagiya Daana zaretuura dunkkaanida baggai ba armmaa oiqqidi denddiis. Daana zaretu halaqai Amishadaaya na7aa Ahi7eezera; ");
INSERT INTO wal_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aseera zaretu halaqai Okiraana na7aa Paagi7eela; ");
INSERT INTO wal_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Nifttaaleema zaretu halaqai Enaana na7aa Ahiraa7a. ");
INSERT INTO wal_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Israa7eela asai ba baggan baggan denddidi biyo maarai hagaadaana. ");
INSERT INTO wal_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Muusee Midiyaama asa gidiya ba bolluwaa Yatiro na7aa Hobaaba, “Nuuni GODAI, ‘Taani intteyyo immana’ giido sohuwaa boos; GODAI Israa7eelayyo lo77obaa oottana giido gishshau, neeni nunaara hindda. Nuuni neeyyo lo77obaa oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Yaagin Hobaabi, “CHii, taani biikke; taani ta biitti ta asaakko baana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Yaagin Muusee a, “Hayyanaa, nuna yeggada boopparkkii! Bazzuwan nuuni dunkkaananau bessiyaasaa neeni eraasa; neeni nu biyo ogiyaa nuna kaalettanaukka danddayaasa. ");
INSERT INTO wal_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Neeni nunaara biikko, GODAI nuuyyo immiyo anjjuwaa ubbaa nuuni nenaara shaakkana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Yaatin eti GODAA deriyaappe denddidi, heezzu gallassa keena ogiyaa biidosona. GODAA Maachchaa Taabootai eti shemppiyo sohuwaa demmanau he heezzu gallassan etappe sinttau biis. ");
INSERT INTO wal_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Eti dunkkaanidosaappe denddiyo wode ubban, GODAA shaarai gallassi gallassi etappe bollaara de7ees. ");
INSERT INTO wal_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Taabootai denddiyo wode ubban Muusee, “Abeet GODAU, dendda! Ne morkketi laalettona; Nena ixxiyaageetakka ne sinttappe baqatona” yaagees. ");
INSERT INTO wal_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Taabootai shemppiyo wode ubban Muusee, “Abeet GODAU, ha daro sha7an qoodettiya Israa7eela asaakko neeni simma” yaagees. ");
INSERT INTO wal_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Asai ba metuwaayyo GODAA bolli zuuzummiis; eti zuuzummishin GODAI siyidi, hanqquwaa eexxi kiyiis. Yaatin GODAA tamai eta gidduwan eexxidi, eti dunkkaanidosaayyo issi issi gaxaa baggaa miis. ");
INSERT INTO wal_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Yaatin asai Muuseyyo waassin, Muusee GODAA woossiis. Woossin tamai to7iis. ");
INSERT INTO wal_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","GODAA tamai eta gidduwan eexxido gishshau, he sohoi Tabi7eera geetetti xeesettiis. ");
INSERT INTO wal_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Israa7eelatuura de7iya dumma dumma dere asai hara qumaa keehi amottiis. Israa7eela asaikka qassi hagaadan yaagidi yeehuwaa doommiis; “Laa nuuni asho auppe demmanee? ");
INSERT INTO wal_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nuuni Gibxxe biittan miishsha qanxxennan coo miyo moliyaa hassayeettees; qassi qayye miyo paranjja leehiyaa, zolddo leehe milatiya mal77iya haattai kumido meelooniyaa, adussa paranjja sunkkuruutuwaanne tuummuwaa hassayeettees. ");
INSERT INTO wal_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","SHin ha77i nu qooree gorddettiis; nu aifeekka ha mannaappe attin, harabaa ainne be7enna” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannai deebbuwaa aifiyaa milatees; a merai booxxiya adil77e ciishshaa milatees. ");
INSERT INTO wal_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Asai yuuyi yuuyi a qorees; qoridi woxan gaaccees, woikko udulan caddees; eti a otuwan penttissidi, bashiyan komppoosona. I zaitiyan munaqqidi uukkido oittaadan mal77ees. ");
INSERT INTO wal_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Qammi dunkkaanidosan xaazai wodhdhiyo wode, mannai aara wodhdhees. ");
INSERT INTO wal_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Asai ba dunkkaaniyaa penggen penggen yeekkishin, Muusee siyiis. GODAA hanqqoi eexxi kiyido gishshau, Muusee un77ettiis. ");
INSERT INTO wal_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Hegaa gishshau, Muusee GODAA hagaadan yaagidi oichchiis; “Neeni ta bolli ne ashkkaraa bolli aissi ha metuwaa ehaadii? Neeni tanan aissi ufaittabeikkii? Neeni ha asaa ubbaa toohuwaa ta bolli aissi wottadii? ");
INSERT INTO wal_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ha asaa ubbaa taani shahaaridanaayye? Woikko eta taani yelidanaa? ‘Neeni eta maizza aawatuyyo, “Taani intteyyo immana” gaada caaqqido biittaa gattanaassi, naata dichchiyaara xanttiyo na7aa ba qesiyan idimmiyoogaadan, neeni eta ne qesiyan idimma’ yaagada taayyo aissi yootai? ");
INSERT INTO wal_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ha asau ubbau taani asho auppe demmanee? Eti tana, ‘Miyo asho nuuyyo imma’ yaagidi yeekkoosona. ");
INSERT INTO wal_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Taani ha asaa ubbaa tarkka tookkana danddayikke; toohoi tau keehi deexxees. ");
INSERT INTO wal_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Simmi neeni tana hagaadan metootanaadan oottanaagaappe taayyo qarettada tana ha77i wora baya; yaatikko, taani metuwaappe shemppana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","GODAI Muusa, “Israa7eela cimatuppe kaalettiyaageetanne halaqata gidiya, neeni eriyo laappun tammu cimata taayyo shiishsha; eti nenaara yan eqqana mala, Xoossaa Dunkkaaniyaakko, eta neeni eha. ");
INSERT INTO wal_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Taani duge wodhdhada nenaara yan haasayana; taani nenan de7iya Ayyaanaappe ekkada, he Ayyaanaa eta bolli wottana. Neeni nerkka tookkenna mala, eti asaa toohuwaa tookkidi, nena maaddana. ");
INSERT INTO wal_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Neeni asaassi hagaadan gaada yoota, ‘Wonttoyyo inttena geeshshite; yaatidi intte ashuwaa maana. Intte, “Laa nuuni asho auppe demmanee? Nuuyyo Gibxxe biittan sa7ai lo77o shin!” yaagidi yeekkidoogaa GODAI siyiis. GODAI ashuwaa ha77i intteyyo immana; immin intte maana. ");
INSERT INTO wal_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","20","Intte gidduwan de7iya GODAA intte karido gishshaunne intte, “Nuuni Gibxxe biittaappe aissi kiyidonii?” yaagidi a sinttan yeekkido gishshau, intte issi gallassa, woikko naa77u gallassa, woikko ichchashu gallassa, woikko tammu gallassa, woikko laatamu gallassa xalaalaa asho meekketa; shin intteyyo siiriyaara kiyana gakkanaassi, inttena salettana gakkanaassi, issi agina kumettaa intte asho maana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","SHin Muusee GODAA, “Be7a, taani usuppun xeetu sha7u tohuwaasaa gidduwan de7ais; neeni, ‘Issi agina kumettaa eti maanau etayyo taani asho immana’ gaasa. ");
INSERT INTO wal_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Miizzaa wudiyaanne dorssaa wudiyaa etau shukkin kalissanee? Abban de7iya mole ubbaa shiishshiyaabaa gidiyaakko, etayyo gidanee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yaagin GODAI Muusa, “GODAA kushee qantteeyye? Taani neeyyo giyoobai tumakkonne worddokko neeni ha77i be7ana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Yaagin Muusee kare kiyidi, GODAI giidobaa asaayyo yootiis. I Israa7eela cimatuppe laappun tammu asaa shiishshidi, Xoossaa Dunkkaaniyaa yuushuwan essiis. ");
INSERT INTO wal_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Essin GODAI shaaran duge wodhdhidi, aara haasayiis; yaatidi a bollan de7iya Ayyaanaappe ekkidi, he laappun tammu cimatu bolli wottiis. Ayyaanai eta bollan shemppido wode, eti hananabaa yootidosona. SHin hegaappe guyyiyan, zaarettidi hananabaa yootibookkona. ");
INSERT INTO wal_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","He laappun tammu cimatuura mazggafan xaafettida asati Elddaadanne Medaada giyo naa77ati dunkkaanidosan attidosona; attidi Xoossaa Dunkkaaniyaakko yibookkona; shin eta bollikka Ayyaanai wodhdhin, dunkkaanidosan hananabaa yootidosona. ");
INSERT INTO wal_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Issi wodallai woxxi yiidi, Muusa, “Elddaadinne Medaadi dunkkaanidosan hananabaa yootoosona” yaagidi yootiis. ");
INSERT INTO wal_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yootin ba yelagatettaappe doommidi, Muusa maaddiya Nawe na7ai Yaasu Muusa, “Ta godau Muusee, neeni eta teqqa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","SHin Muusee a, “Ta gishshataa ne mishettai? GODAA asai ubbai hananabaa yootiyaabaanne GODAI ba Ayyaanaa eta bolli wottiyaabaa gideerenneeshsha!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hegaappe guyyiyan, Muuseenne Israa7eela cimati dunkkaanidosaa simmidosona. ");
INSERT INTO wal_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Hegaappe guyyiyan, GODAI carkkuwaa denttin, abbaa baggappe kuraachchuwaa asai dunkkaanidosaa ubbaa yuushuwaakko carkkoi ehiis; ehin he kafoti sa7aa doonaara biittaappe pude naa77u wara keenan paallidosona. Paalli yiidi eti dunkkaanidosaa ubbaappe gaxaara, issi gallassa oge keenaa sa7an uttidosona. ");
INSERT INTO wal_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","He gallassa ubban, he qamma ubbaaninne wonttetta gallassa ubban asai kare kiyidi, ha kuraachchota oiqqidi shiishshiis; etappe ooninne issi sha7u kilo giraameppe guuttaa shiishshibeenna. Eti hegaappe guyyiyan, dunkkaanidosaa yuusho ubban melissanau miccidosona. ");
INSERT INTO wal_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","SHin ashoi biron eta achchan de7ishin, eti coommidi mittennan de7ishin, GODAA hanqqoi asaa bolli eexxi kiyiis; yaatin GODAI asaa wolqqaama boshan shociis. ");
INSERT INTO wal_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Yaatin he sohoi Amuwaa Duufuwaa geetetti sunttettiis; aissi giikko, ashuwaa amottida asaa eti he sohuwan moogidosona. ");
INSERT INTO wal_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Asai hegaappe denddidi Haxeroota giyoosaa biidi, yan dunkkaaniis. ");
INSERT INTO wal_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Muusee Toophphiyaa biittaa maccaasiyo ekkiis. I ekkido Toophphiyaa maccaasee gishshau, Miiriyaamanne Aarooni Muusa boridosona. ");
INSERT INTO wal_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Eti, “GODAI Muuse bagga xalaalaara haasayideeyye? Qassi i nu baggaara haasayibeenneeyye?” yaagidosona. Yaagin GODAI hegaa siyiis. ");
INSERT INTO wal_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Muusee biittan sa7an ubban de7iya asaa ubbaappe aadhdhiya ashkke asa. ");
INSERT INTO wal_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","GODAI sohuwaara Muusessi, Aaroonassinne Miiriyaamissi, “Intte heezzaikka Xoossaa Dunkkaaniyaakko kiyite” yaagiis; yaagin eti heezzaikka kiyidosona. ");
INSERT INTO wal_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Kiyin GODAI shaaraa tuussan duge wodhdhiis; wodhdhidi Xoossaa Dunkkaaniyaa penggen eqqidi, Aaroonanne Miiriyaamo xeesiis. Eti naa77aikka a sintti shiiqin, ");
INSERT INTO wal_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","i eta, “Ta yootiyoogaa siyite: Intte gidduwan hananabaa yootiyaagee de7ikko, taani GODAI tana ayyo ajjuutan qonccissais; taani ayyo aimuwan yootais. ");
INSERT INTO wal_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","SHin ta ashkkaraa Muuseera hegaadan gidenna; i ta keetta ubban ammanettidaagaa. ");
INSERT INTO wal_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Taani Muuseera sintta baazzan haasayaisippe attin, leemisuwan haasayikke. I ta meraa be7ees. Yaatin ta ashkkaraa Muusa boranau intte aissi yayyibeekketii?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","GODAA hanqqoi eta bolli eexxi kiyiis; kiyin GODAI biis. ");
INSERT INTO wal_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","SHaarai Xoossaa Dunkkaaniyaa bollaappe denddido wode, Miiriyaama hanttaara gogaa harggiyan mulxxu gaada booxxaasu. Aarooni ikko simmidi xeelliyo wode, hanttaara gogaa harggiyan ohettidaaro be7iis. ");
INSERT INTO wal_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Yaatin i Muusa, “Hai ta godau, nuuni eeyyatettan oottido nagaraayyo nuna qaxxayoppa. ");
INSERT INTO wal_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ba aayee uluwaappe kiyiyo wode, a ashuwaappe baggai meetettiichchin, haiqqiichchidi yelettida gacino na7a mala gidopparkkee” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Yaagin Muusee, “Hai Xoossau, o pattarkkii!” yaagidi GODAAYYO waassiis. ");
INSERT INTO wal_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Waassin GODAI Muusa, “I aawai i som77uwan cuuchchaa cuchchidabaa gidiyaakko, laappun gallassaa a yeellaa maayada uttana gidekkeeyye? Hegaa gishshau, neeni o laappun gallassaa dunkkaanidosaappe gaxa baggaara dumma sohuwan utissa; hegaappe guyyiyan, simmada yu” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Yaatin Miiriyaama asai dunkkaanidosaappe gaxi kiyada laappun gallassaa uttaasu. A simmana gakkanaassi asai baanau denddibeenna. ");
INSERT INTO wal_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hegaappe guyyiyan, asai Haxeroota giyoosaappe denddidi, Paaraana Bazzuwan dunkkaaniis. ");
INSERT INTO wal_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","GODAI, Muusa, ");
INSERT INTO wal_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Taani Israa7eelatuyyo immiyo Kanaane biittaa wochchana mala, amarida asa kiitta; eta zare ubbaappe issi issi halaqaa kiitta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Yaagin Muusee GODAA azazuwan Paaraana Bazzuwaappe eta kiittiis. Eti ubbaikka Israa7eela asaa halaqata. ");
INSERT INTO wal_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Eta sunttai hagaappe kaallidi xaafettidaagaa: Zariyaa Halaqaa Roobeela Zakkuura na7aa SHaamu7a ");
INSERT INTO wal_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simoona Hoora na7aa SHafaaxa ");
INSERT INTO wal_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yihudaa Yifune na7aa Kaaleeba ");
INSERT INTO wal_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Yisaakoora Yooseefa na7aa Yigi7aala ");
INSERT INTO wal_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efireema Nawe na7aa Hoshee7a ");
INSERT INTO wal_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Biniyaama Raafu na7aa Palxxa ");
INSERT INTO wal_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zaabiloona Sooda na7aa Gaddi7eela ");
INSERT INTO wal_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yooseefa na7aa Minaasa Suusa na7aa Gadda ");
INSERT INTO wal_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Daana Gamaalla na7aa Ami7eela ");
INSERT INTO wal_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aseera Mikaa7eela na7aa Satuura ");
INSERT INTO wal_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nifttaaleema Waafisa na7aa Naahiba ");
INSERT INTO wal_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gaada Maaka na7aa Ge7u7eela ");
INSERT INTO wal_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","He biittaa wochchana mala, Muusee kiittido asatu sunttai hagaappe qommoora de7iyaagaa. Muusee Nawe na7aa Hoshee7a sunttaa Yaasa yaagidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Eti Kanaane biittaa wochchana mala, Muusee eta kiittiyo wode hagaadan yaagiis; “Hagaappe Neegeeba Bazzuwaa pude kiyidi, yaappe huuphessa baggan de7iya gezze biittaa biite. ");
INSERT INTO wal_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Biidi biittai ai mala biittakkonne be7ite; he biittan de7iya asai minokkonne laafakko, guuttakkonne darokko, ");
INSERT INTO wal_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","eti de7iyo biittai lo77okko iitakko, eti de7iyo katamainne ai mala katamakko, gimbbiyan diretti uttidaakko direttibeennaakko, ");
INSERT INTO wal_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","biittai ai mala araddakko ladakko, he biittan mitti de7iyaakko bainnaakko be7ite. Minnite! He biittan mokkidabaa aifiyaappe ekkennan yooppite” yaagiis. He wodee woine turai koiro aifiyaa aifiyo wode. ");
INSERT INTO wal_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Yaagin eti pude kiyidi, Xiina giyo bazzuwaappe doommidi, biidi Hamaata Pinuwaa matan de7iya Rahooba gakkanaassi he biittaa wochchidosona. ");
INSERT INTO wal_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Neegeeba Bazzuwaa pude kiyidi, Kebroona gakkidosona; hegan Ahimaana, SHeshaayanne Talmmaaya geetettiya Anaaqe zareti de7oosona. Kebrooni Gibxxen de7iya Xo7aane katamaappe laappun laittaa kaseti keexettiis. ");
INSERT INTO wal_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Hegaara kanttidi, eti Eshkkoola giyo zanggaaraa biidi gakkido wode, woine tura issuwaappe issi wurccuwaara de7iya issi tashiyaa qanxxidosona; qanxxidi etappe naa77ai kasuwaa gidduwan gelissi tookkidosona. Hegaara roomaaniyaanne balasiyaa giyo mittatu aifiyaa ehiidosona. ");
INSERT INTO wal_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israa7eela asati hegaappe qanxxido woine turaa wurccuwaa gishshau, he sohuwaa Eshkkoola Zanggaaraa giidi xeesidosona. ");
INSERT INTO wal_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Eti he biittaa wochchiiddi, oitamu gallassaappe guyyiyan simmidosona; ");
INSERT INTO wal_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","simmidi Paaraana Bazzuwan Qaadeesa giyoosan de7iya Muusekko, Aaroonakkonne Israa7eela asaa maabaraa ubbaakko yiidosona. Yiidi bantta be7idobaa etaunne asa ubbau yootidosona; he biittan aifiya aifiyaakka eta bessidosona. ");
INSERT INTO wal_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Eti Muuseyyo hagaadan yaagidi yootidosona; “Neeni nuna kiittido biittaa nuuni biida; he biittan maattainne eessai goggees. An aifiya aifiyaakka hagaa be7a. ");
INSERT INTO wal_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","SHin he biittan de7iya asai wolqqaama; eta katamaikka gimbbe dirssan diretti uttidaagaanne gita. Nuuni qassi Anaaqe zareta yan be7ida. ");
INSERT INTO wal_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Neegeeba Bazzuwan Amaaleeqa asati de7oosona; gezziyan Hiiteti, Yaabuusatinne Amooreti de7oosona; qassi Kanaaneti Meediteraane Abbaa doonaaninne Yorddaanoosa SHaafaa xanxxan de7oosona” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Yaagin Kaaleebi asaa Muuse sinttan co77u giissidi, “Nuuni tumu xoonanau danddayiyo gishshau, pude ha77i kiyidi, he biittaa olidi ane oiqqoos” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","SHin Kaaleebaara pude biida asati, “He biittaa asai nuuppe minniyo gishshau, nuuni eta xoonanau danddayokko” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Eti yuuyi wochchido biittaabaa Israa7eela asaayyo hagaadan giidi, iita oduwaa odidosona, “Nuuni wochchido biittai banan de7iya asaakka miyaagaa; asai ubbaikka keehi adussa. ");
INSERT INTO wal_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nuuni wogga adussa asatu yara gidiya Anaaqe zareta yan be7ida; nuuni nu aifiyan nuna xeelliyo wode gumbburo milatida; qassi nuuni eta aifiyan hegaakka mala” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","He gallassa qammi maabarai ubbai bantta qaalaa xoqqissidi yeekkidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israa7eela asai ubbai Muuse bollinne Aaroona bolli zuuzummidosona. Maabarai kumettai eta, “Nuuni Gibxxe biittan de7iiddi haiqqidabaa gidorkkonii! Woikko nuuni ha bazzuwan haiqqidabaa gidorkkonii! ");
INSERT INTO wal_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Bisuwan nuna wori wurssanau GODAI ha biitti nuna aissi ehii? Nu maccaasatinne nu naati omoodettana. Hegaappe guyye Gibxxe biitti simmiyoogee nuuyyo kehenneeyye?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Qassi eti issoi issuwaa, “Nuuni kaalettiyaabaa dooridi, guyye Gibxxe simmoos” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Yaagin Muuseenne Aarooni hegan shiiqida Israa7eela asaa maabaraa ubbaa sinttan som77uwaa sa7an gattidi gufannidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","He biittaa wochchida asatu giddoppe Nawe na7ai Yaasunne Yifune na7ai Kaaleebi bantta maayuwaa pooshshidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Pooshshidi Israa7eela asaa maabaraa ubbaayyo, “Nuuni kantti kiyidi wochchido biittai keehi daro lo77o. ");
INSERT INTO wal_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","GODAI nunan ufaittiyaabaa gidikko, maattainne eessai goggiyo he biittau nuna i gelissana; he biittaa nuuyyo i immana. ");
INSERT INTO wal_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Hegaa gishshau, GODAA bolli makkala makkaloppite. He biittaa asau yayyoppite; eti nuuyyo haatta ushshakka gakkokkona. Etau ambboomiyaabi baawa; shin GODAI nunaara de7ees. Intte etayyo yayyoppite!” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Yaagin maabarai ubbai eta shuchchan caddanau denddiis. He wode GODAA bonchchoi Xoossaa Dunkkaaniyan Israa7eela asa ubbau qoncciis. ");
INSERT INTO wal_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","GODAI Muusa, “Ha asai aude gakkanaassi tana karanee? Taani eta gidduwan oottido malaata ubbaa be7iiddi, aude gakkanaassi eti tanan ammanennan ixxanee? ");
INSERT INTO wal_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Taani eta boshan shocada xaissana; yaatada taani nena etappe dariyaanne minniya kawotettaayyo aawa oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Yaagin Muusee GODAA hagaadan yaagidi woossiis; “Neeni ne wolqqan ha asaa Gibxxeppe pude kessidoogaa eriya Gibxxeti hagaa siyikko, eti woiganee? ");
INSERT INTO wal_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Eti ha biittan de7iyaageetuyyookka hegaa odana. Abeet GODAU, neeni ha asaa gidduwan de7iyoogaa eti siyidosona. Abeet GODAU, nuuni nena be7idoogaa eti eridosona; ne shaarai etappe bollaara takkiyoogaanne gallassi shaaraa tuussan, qammi tamaa tuussan neeni eta sinttan biyoogaa be7idosona. ");
INSERT INTO wal_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ha77i neeni ha asaa ubbaa issi kuttan woriyaabaa gidikko, ne kase oottidoogaa siyida kawotettati, ");
INSERT INTO wal_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘GODAI ha asaa, “Intteyyo immana” giidi caaqqido biittaa eta efaanau danddayibeenna gishshau, bazzuwan eta woriis’ yaagidi haasayana. ");
INSERT INTO wal_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","18","“Hegaa gishshau, Godau, neeni ne wolqqaa nuna bessa; neeni gaidda, ‘GODAI danddayanchchanne aggenna siiquwan kumidaagaa; nagaraanne makkalaa atto giyaagaa; gidikkonne, mooranchchaa qaxxayennan aggennaagaa; aawatu nagaraa gishshau naata heezzanttanne oiddantta yeletaa gakkanaassi qaxxayiyaagaa’ gaada yoota wottidoogaa pola. ");
INSERT INTO wal_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ha asai Gibxxeppe kiyoosappe doommada hachchi gakkanaassi neeni atto giidoogaadan, ne aggenna siiquwaa daruwan ha asaa nagaraa atto garkkii!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yaagin GODAI Muusa, “Neeni oichchidoogaadan taani etayyo atto gaas. ");
INSERT INTO wal_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","SHin ta de7uwan caaqqais; ta bonchchoi sa7a ubbaa kumiyoogaadan, ");
INSERT INTO wal_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","ha asaappe issoinne he biittaa be7enna. Ta bonchchuwaanne Gibxxe biittaaninne bazzuwan taani oottido malaataa ha asati be7idosona; shin eti zaaretti zaarettidi tana paaccidosonanne ta qaalaa siyennan ixxidosona. Hegaa gishshau, taani eta maizza aawatuyyo immana gaada caaqqido biittaa tana karidaageetuppe issoinne mulekka be7enna. ");
INSERT INTO wal_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","SHin ta ashkkarai Kaaleebi etappe dummatiyo gishshaunne i tana polo wozanaappe kaallido gishshau, taani i kase biido biittaa a gattana; a zerettai he biittaa laattana. ");
INSERT INTO wal_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","SHin ha77i Amaaleeqatinne Kanaaneti wombban de7iyo gishshau, wontto guyye simmidi, Zo7o Abbaakko efiya ogiyaa oiqqidi bazzo biite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Qassi GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ha iita asai ta bolli aude gakkanaassi zuuzummanee? Taani Israa7eela asaa zuuzunttaa ubbaa siyaas. ");
INSERT INTO wal_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Hegaa gishshau, neeni etau hagaadan yaagada oda; ‘Ta de7uwan caaqqais; taani intte haasayishin ta haittan siyidoogaa intteyyo oottana. Taani GODAI hegaa odais. ");
INSERT INTO wal_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Intte ahai ha bazzuwan kunddana; aissi giikko, asaa qoodiyo wode qoodettida laatamu laittanne hegaappe bollaara de7iya asai ubbai ta bolli zuuzummideta. ");
INSERT INTO wal_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Yifune na7aa Kaaleebappenne Nawe na7aa Yaasuppe attin, intteppe ooninne taani inttena wottanau caaqqido he biittaa gelenna. ");
INSERT INTO wal_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Intte, “Nu naati omoodettana” giido intte guutta naata he intte karido biittaa gelissana; biittaikka etassa gidana. ");
INSERT INTO wal_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","SHin inttena gidikko, intte ahai ha bazzuwan kunddana. ");
INSERT INTO wal_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Intte ammanettibeenna gishshau, intte wurssetta ahai ha bazzuwan wullana gakkanaassi, intte naati waayettiiddi, ha bazzuwan oitamu laittaa henttanchcha gididi yuuyana. ");
INSERT INTO wal_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Intte he biittaa wochchido he oitamu gallassaa qoodan, issi gallassaayyo issi laittaa, hegeenne, oitamu laittau intte nagaraa gishshau intte waayettana; taani intte bolli denddiyoogaa intte erana’ yaaga yoota. ");
INSERT INTO wal_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Taani GODAI hagaa odais. Ta bolli shiiqi uttida ha iita maabaraa bolli hagaadan tumu oottana: eti ha bazzuwan wurana; hagan eti haiqqana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","He biittaa wochchana mala, Muusee eta kiittin biidi simmida asati, he biittaabaa iita oduwaa odidi, Muuse bolli asai ubbai zuuzummana mala oottidaageeti, ");
INSERT INTO wal_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","he iita oduwaa odida asati, GODAA sinttan boshan haiqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","He biittaa wochchanau biida asatuppe Yifune na7ai Kaaleebinne Nawe na7ai Yaasu xalaalai paxa attidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Muusee hagaa Israa7eela asau ubbau yootido wode, asai keehi yeekkiis. ");
INSERT INTO wal_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wonttetta gallassi maallado guuran eti denddidi, pude gezze biittaa kiyidi, “Nuuni nagaraa oottida; shin ha77i GODAI nuuyyo immana giido sohuwaa pude kiyana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","SHin Muusee eta, “GODAA azazuwaa intte aibissi mentteetii? Intteyyo hanenna. ");
INSERT INTO wal_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","GODAI inttenaara de7enna gishshau, pude kiyoppite; intte morkketi inttena xoonana. ");
INSERT INTO wal_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amaaleeqa asatuuranne Kanaane asatuura intte olettana; olettidi intte bisuwan haiqqana. GODAAPPE intte wora simmido gishshau, GODAI inttenaara de7enna” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","SHin eti GODAA Maachchaa Taabootainne Muuseenne dunkkaanidosaappe denddana xayikkokka, gezze biittaa kiyanau xalidi denddidosona. ");
INSERT INTO wal_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Denddin gezze biittan de7iya Amaaleeqa asatinne Kanaane asati wodhdhidi eta oli xoonidi, Horima gakkanaassi eta yedettidosona. ");
INSERT INTO wal_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Israa7eela asaayyo hagaadan yaaga; ‘Intte de7ana mala, taani intteyyo immiyo biitti geliyo wode, ");
INSERT INTO wal_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mehiyaappe woikko dorssaappe, xuuggiyo yarshsho gidin, woikko shiiqo gattanau yarshshiyo yarshsho gidin, woikko taani keerido baala gallassatun intte dosan coo immiyo yarshsho gidin, GODAAYYO taman xuuggiyo, sawuwaa tonggu giya yarshshota yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Yarshshuwaa shiishshiya urai kattaa yarshshuwaassi issi kilo giraame xiilliyaa issi litiro wogaraa zaitiyan munaqqidoogaakka eho. ");
INSERT INTO wal_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Qassi xuuggiyo yarshshuwaassi, woikko hara yarshshuwaassi ehiyo issi issi dorssaara issi litiro woiniyaa eessaa ushshaa yarshsho oottidi giigissite. ");
INSERT INTO wal_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“‘Dorssa orggiyaa yarshshanau shiishshiyo wode, kattaa yarshshuwaassi naa77u kilo giraame xiilliyaa issi litironne bagga wogaraa zaitiyan munaqqidoogaanne ");
INSERT INTO wal_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","issi litironne bagga woine eessaa ushshaa yarshshuwaassi ehiite. Ehiidi GODAAYYO sawuwaa tonggu giya yarshshuwaa yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“‘Issi mirgguwaa xuuggiyo yarshsho, woikko shiiquwaa gattiyo yarshsho, woikko issippetettaa yarshsho oottidi yarshshanau GODAAYYO ehiyo wode, ");
INSERT INTO wal_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","mirgguwaara issippe kattaa yarshshuwaassi heezzu kilo giraame xiilliyaa naa77u litiro wogaraa zaitiyan munaqqidoogaanne ");
INSERT INTO wal_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ushshaa yarshshuwaassi naa77u litiro woiniyaa eessaakka ehiite. Ehiidi GODAAYYO sawuwaa tonggu giya yarshshuwaa taman yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“‘Issi issi korima booraa, woikko issi issi dorssa orggiyaa, woikko yelaga deeshsha orggiyaa, woikko attuma dorssa maraa yarshshanau shiishshiyo wode, kattaa yarshshoinne ushshaa yarshshoi hagaadan issippe shiiqees. ");
INSERT INTO wal_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Issi meheppe daroi shiiqiyo wode, kattaa yarshshoinne ushshaa yarshshoi hegaadan daridi shiiqees. ");
INSERT INTO wal_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Israa7eela asa gidiya ooninne taman xuuggiyo, sawuwaa tonggu giya yarshshuwaa GODAAYYO shiishshiyo wode ubban, hagaadan oottanau koshshees. ");
INSERT INTO wal_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Sinttappe yaana yeletan intte giddon de7iya betee woikko hara asi ooninne xuuggiyo, sawuwaa tonggu giya yarshshuwaa GODAAYYO shiishshanau koyikko, ikka intte oottiyoogaadan oottanau koshshees. ");
INSERT INTO wal_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Inttessikka intte giddon de7iya betetussikka ha wogai issuwaa; hagee sinttappe yaana yeletaassikka eqqidi de7iya woga. Inttekka betetikka GODAA sinttan issuwaa. ");
INSERT INTO wal_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Inttessikka intte giddon de7iya bete asatussikka higgeenne wogai issuwaa gidana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Israa7eela asaayyo hagaadan yaagada oda; ‘Taani inttena efiyo biitti intte gelidi, ");
INSERT INTO wal_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","he biittan mokkiya kattaa miyo wode, he kattaappe xeeraa kessidi, intte GODAAYYO yarshsho oottidi shiishshite. ");
INSERT INTO wal_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Hegeekka, baira ka77ida kattaappe uukkido koiro komppuwaa, kattaa qoxxiyo audiyaappe immiyo yarshsho oottidi shiishshite. ");
INSERT INTO wal_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Yaana yeleta ubban intte intte biittan mokkida kattaappe xeeraa kessido komppuwaa, GODAAYYO yarshsho oottidi shiishshite. ");
INSERT INTO wal_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“‘GODAI Muusessi odido ha azazota ubbaa intte erana xayidi, naagennan aggikko, ");
INSERT INTO wal_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","GODAI a baggaara inttena azazido azazota ubbaa, GODAI immido gallassaappe doommidi, yaana yeletaa gakkanaashin, paccennan naagennan aggikko, ");
INSERT INTO wal_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","qassi hegaa maabarai erennan oottidobaa gidikko, maabarai ubbai GODAAYYO issi mirgguwaa xuuggiyo, sawuwaa tonggu giya yarshsho oottidi, ayyo wogai azaziyoogaadan, kattaa yarshshuwaaranne ushshaa yarshshuwaara shiishsho; qassi nagaraa yarshsho oottidi, issi deeshsha orggiyaa shiishsho. ");
INSERT INTO wal_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Yaatobare qeesee kumetta Israa7eela maabaraa nagaraa atto giissiyo wogaa polo; polin eta nagarai atto geetettana. Aissi giikko, eti eriiddi oottibookkona; qassi eti bantta mooruwaa gishshau, GODAAYYO taman xuuggiyo yarshshuwaanne bantta nagaraa yarshshuwaa shiishshidosona. ");
INSERT INTO wal_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Asai ubbai erennan he mooruwan hambbalaashettido gishshau, kumetta Israa7eela maabaraukka eta giddon de7iya bete asaukka atto geetettana. ");
INSERT INTO wal_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“‘Issi asi barkka erana xayidi nagaraa oottikko, yelettoosappe issi laitta gidiyo issi deeshshiyo nagaraa yarshsho oottidi shiishsho; ");
INSERT INTO wal_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","shiishshin erennan de7iiddi nagaraa oottida uraayyo qeesee GODAA sinttan nagaraa atto giissiyo wogaa polo; polin a nagarai atto geetettana. ");
INSERT INTO wal_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Erennan de7iiddi nagaraa oottiya asa ubbau, yeletan Israa7eela asa gidinkka bete asa gidinkka ha higgee issuwaa. ");
INSERT INTO wal_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“‘SHin yeletan Israa7eela asa gidinkka bete asa gidinkka eriiddi otoruwan nagara oottiya uri GODAA cayees. He aawu haiqqidi, ba asaa giddoppe xayo. ");
INSERT INTO wal_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","He aawu GODAA qaalaa karido gishshaunne a azazuwaa kanttido gishshau, i tumuppe haiqqanau bessees; a mooroi aana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Issi gallassi Israa7eela asai bazzon de7ishin, issi bitanee Sambbatan mittaa mixiiddi beettiis. ");
INSERT INTO wal_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Mittaa i mixishin demmida asati Muusekko, Aaroonakkonne kumetta yaa7aakko a ehiidosona. ");
INSERT INTO wal_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ehin eti a oottanabaa eribeenna gishshau, qashuwan takissidosona. ");
INSERT INTO wal_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Hegaappe guyyiyan GODAI Muusa, “Ha bitanee haiqqanau bessees; kumetta yaa7ai bantta dunkkaanidosaappe gaxi kessidi, shuchchan caddidi a woro” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Yaagin kumetta yaa7ai GODAI Muusa azazidoogaadan, dunkkaanidosaappe gaxi kessidi, shuchchan caddidi a woriis. ");
INSERT INTO wal_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Israa7eela asaayyo hagaadan yaagada oda; ‘Inttekka sinttappe yaana yeletaikka intte maayuwaa gaxa xeeran xeeran macaraa kessite; kessidi he macaraa bolli salo milatiya qacinaa sikkite. ");
INSERT INTO wal_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","He macaraa intte be7iyo wode ubban ta azazota hassayidi polite; yaatikko, intte intte aifiyaanne intte wozanaa amuwaa kaallidi, taappe wora simmekketa. ");
INSERT INTO wal_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","He macaraa be7iyoogan intte ta azazota ubbaa hassayidi polananne intte intte Xoossaayyo geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Taani GODAA, intte Xoossaattennee; taani intte Xoossaa gidanau, inttena Gibxxeppe kessaas. Taani GODAA, intte Xoossaa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Leewa zariyaappe Qahaata yara gidiya Yixihaara na7ai Qoraahi, Roobeela zariyaappe Eli7aaba naati Daataaninne Abiiraaminne qassi Peleeta na7ai Ooni ");
INSERT INTO wal_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Muuse bolli denddidosona. Etaara naa77u xeetanne ishatamu Israa7eela asati de7oosona; eti erettida asanne maabaran doorettida kaalettiyaageeta. ");
INSERT INTO wal_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Eti Muusenne Aaroona sintti shiiqidi, hagaadan yaagidosona; “Intte darissideta! Maabarai ubbai huuphiyan huuphiyan geeshsha; GODAIKKA eta gidduwan de7ees; yaatin GODAA maabaraa bolli inttena aissi xoqqu xoqqu ootteetii?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Muusee hagaa siyido wode GODAA sinttan sa7an gufanniis; ");
INSERT INTO wal_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","gufannidi Qoraahanne a citaa ubbaa, “Wontto maallado GODAI ooni aagaakkonne ooni geeshshakkonne bessana; i he dooriyo asa baakko shiishshana. ");
INSERT INTO wal_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Qoraahaa, neeninne ne citai ubbai hagaa oottite: wontto ixaanaa cuwayiyoogeeta ekkidi, ");
INSERT INTO wal_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","bonqquwaa an wottidi, GODAA sinttan ixaanaa cuwayite. GODAI dooriyo asi, i geeshsha gidana. Leewa zaretoo, intte darissideta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Muusee qassikka Qoraaha, “Inttenoo Leewa zaretoo, siyite! ");
INSERT INTO wal_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israa7eela Xoossai inttena Israa7eela maabaraappe dummayidi, Xoossaa Dunkkaaniyaa oosuwaa oottana malanne asaa sinttan he oosuwaa oottanau intte eqqana mala, baakko shiishshidoogee intteyyo guuxxidee? ");
INSERT INTO wal_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","I inttenanne intte ishantta Leewata ubbaa baakko shiishshiis; qassi ha77i intte qeesetettaakka kajjeeleeta. ");
INSERT INTO wal_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Neeninne ne citai ubbai Aaroona bolli zuuzummiyoogaa GODAA bolli makkaleeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Hegaappe guyyiyan, Muusee kiittidi Eli7aaba naata, Daataananne Abiiraama xeesissiis; shin eti a, “Nuuni bookko! ");
INSERT INTO wal_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Neeni bazzuwan nuna woranau maattainne eessai goggiyo biittaappe kessidoogee guuxxidee? Qassi ha77i neeni nu bolli halaqa gidanau koyai? ");
INSERT INTO wal_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Hegaa bollikka qassi maattainne eessai goggiyo biittaa neeni nuna gelissabaakka, woikko neeni nuuyyo laata oottada gadiyaanne woine turaa immabaakka; neeni ha asaa cimmaasa. Nuuni bookko!” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Yaagin Muusee keehi hanqqettidi GODAA, “Neeni eti yarshshiyo yarshshuwaa ekkoppa; taani etappe hare issuwaanne ekkabeikke, woikko taani etappe issi asanne naaqqabeikke” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Qassi Muusee Qoraaha, “Wontto neeni, ne citai ubbainne Aarooni GODAA sintti shiiqite. ");
INSERT INTO wal_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Issi issi asai ba ixaanaa cuwayiyoogaa muleera naa77u xeetanne ishatamaa ekkidi, ixaanaa an wottidi, GODAA sintti shiishsho. Qassi neeninne Aarooni intte ixaanaa cuwayiyoogeeta ehiite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Yaagin asai ubbaikka ba ixaanaa cuwayiyoogaa ekkidi, bonqquwaanne ixaanaa an wottiis; wottidi Xoossaa Dunkkaaniyaa penggen Muuseeranne Aaroonaara eqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Eqqidaashin Qoraahi kumetta maabaraa Xoossaa Dunkkaaniyaa penggen shiishshiis. He wode GODAA bonchchoi kumetta maabarau qoncciis. ");
INSERT INTO wal_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","GODAI Muusanne Aaroona, ");
INSERT INTO wal_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Taani issi kuttan ha maabaraa xaissana haniyo gishshau, etappe shaahettite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","SHin Muuseenne Aarooni sa7an gufannidi, “Abeet Xoossau, asho maayida asaa ubbaa medhdhida Xoossau, issi uri nagara oottikko, neeni kumetta maabaraa hanqqettai?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yaatin GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Neeni maabaraa, ‘Qoraaha, Daataananne Abiiraama dunkkaanetuppe kichchite’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Muusee denddidi, Daataanakkonne Abiiraamakko bin, Israa7eela cimati a kaallidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Maabaraa i, “Ha iita asatu dunkkaanetuppe kichchite; etabaa gididabaa aibaanne bochchoppite. Hinkkoode eta nagaraa ubbaa gaasuwan inttekka pitetti xayana” yaagidi minttidi yootiis. ");
INSERT INTO wal_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Yootin eti Qoraaha, Daataananne Abiiraama dunkkaanetuppe kichchidosona. Daataaninne Abiiraami kare kiyidi, bantta maccaasatuura, bantta naatuuranne bantta guutta naatuura bantta dunkkaanetu penggen eqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Muusee asaa, “Taani ha ooso ubbaa oottana mala, GODAI tana kiittidoogaanne taani ta sheniyan oottennaagaa intte hagan erana. ");
INSERT INTO wal_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ha asati asi haiqqiyoogaadan haiqqikko, woikko asa bolli gakkiyaabaa xalaalai eta bolli gakkikko, yaatikko GODAI tana kiittibeenna. ");
INSERT INTO wal_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","SHin GODAI muleera oorattabaa oottin, biittai dooyettidi etanne etau de7iyaabaa ubbaa mitti aggikko, eti paxa de7iiddi Si7ooliyaa duge wodhdhikko, he wode ha asati GODAA karidoogaa intte erana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","I yaagidi wurssido sohuwaarakka, eti eqqido biittai phalqqetti wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Biittai dooyettidi, etanne eta so asaa, Qoraaha citaa ubbaa etassi de7iyaabaa ubbaara mitti bayiis. ");
INSERT INTO wal_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Yaatin eti banttau de7iyaabaa ubbaara paxa de7iiddi, Si7ooliyaa duge wodhdhidosona. Biittaikka eta bolli gorddetti bayiis; eti maabaraa giddoppe tippi giidi xayi bayidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Eta waasuwan eta matan de7iya Israa7eelati ubbai, “Biittai nunakka qassi mittana hanees!” yaagiiddi baqatidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Qassi tamaikka GODAA matappe yiidi, ixaanaa cuwayiya naa77u xeetanne ishatamu asaa mi bayiis. ");
INSERT INTO wal_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Hegaappe guyyiyan GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Neeni qeesiyaa Aaroona na7aa El77aazarassi yaagada yoota, ‘Ixaanaa cuwayiyoobata taman xuugettida asaa giddoppe ekka; bonqquwaa cuwayiyoobatuppe haassada laala. He ixaanaa cuwayiyoobati geeshsha. ");
INSERT INTO wal_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Bantta nagaraa gishshau haiqqida ha asatu ixaanaa cuwayiyoobata lee7issada qoxxada, yarshshuwaa saaxiniyaa kamma. Eti hegeeta GODAA sinttan shiishshido gishshau, hegeeti geeshsha; hegeeti Israa7eelata hassayissiya malaata gidana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Yaagin qeesee El77aazari xuugettida asati shiishshido nahaase birataappe oosettida ixaanaa cuwayiyoobata ekkidi, yarshshuwaa saaxiniyaa kammanau lee7issidi qoxxiis. ");
INSERT INTO wal_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Aaroona zare gidenna ooninne GODAA sinttan ixaanaa cuwayanau shiiqenna mala, Qoraahanne a citaa gakkidaagee a gakkenna mala, Israa7eelata hassayissanau hageeta oottiis. GODAI Muuse baggaara El77aazara azazidoogaadan hagee haniis. ");
INSERT INTO wal_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Wonttetta gallassi Israa7eela maabarai ubbai, “GODAA asaa intte worideta” yaagidi, Muuse bollinne Aaroona bolli zuuzummidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Maabarai Muusenne Aaroona bolli denddanau shiiqidi, Xoossaa Dunkkaaniyaakko simmi xeelliyo wode, shaarai Xoossaa Dunkkaaniyaa kammin, GODAA bonchchoi qoncciis. ");
INSERT INTO wal_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Hegaappe guyyiyan, Muuseenne Aarooni Xoossaa Dunkkaaniyaa sinttau yiidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yin GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Ha asaa gidduwaappe kichchite; taani eta issi kuttan xaissa bayana” yaagiis. Yaagin eti sa7an gufannidosona. ");
INSERT INTO wal_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Muusee Aaroona, “Ne ixaanaa cuwayiyoogaa ekkada, bonqquwaa yarshshiyoosaappe ekkada, ixaanaa an wotta; wottada etayyo atto giissanau eesuwan maabaraakko efa. Aissi giikko, GODAA hanqqoi a matappe kiyiichchiis; boshaikka doommiichchiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Yaagin Muusee giidoogaadan Aarooni ba ixaanaa cuwayiyoogaa ekkidi, maabaraa giddo woxxiis. Boshai asaa gidduwan doommidaashin, Aarooni ixaanaa cuwayidi, asaayyo atto giissiis. ");
INSERT INTO wal_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Yaatidi i haiqqidaageetuppenne paxa de7iyaageetuppe gidduwan eqqin, boshai aggi bayiis. ");
INSERT INTO wal_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Qoraaha gaasuwan haiqqida asai qoodettennan, ha boshan haiqqidaageeti 14,700. ");
INSERT INTO wal_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Boshai eqqidoogaappe guyyiyan, Aarooni Xoossaa Dunkkaaniyaa penggen de7iya Muusekko simmiis. ");
INSERT INTO wal_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Neeni, ‘Intte zariyan zariyan intte halaqatuppe huuphiyan huuphiyan issi issi xam77aa muleera tammanne naa77u xam77aa tau immite’ yaagada Israa7eelatuppe ekka. Issi issi asaa sunttaa xam77aa bollan xaafa. ");
INSERT INTO wal_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Issi issi zariyaa halaqaassi issi xam77a gidiyo gishshau, Leewa xam77an Aaroona sunttaa xaafa. ");
INSERT INTO wal_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Xaafada Xoossaa Dunkkaaniyaa giddon taani nenaara gaittiyo Taabootaa sinttan wotta. ");
INSERT INTO wal_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Taani dooriyo asa xam77ai aacana; hagaadan oottada intte bollan Israa7eelati zuuzummiyo zuuzunttaa taani mule xaissana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Yaagin Muusee Israa7eela asau yootin, eta halaqati tammanne naa77u xam77ata, issi issi zariyaa halaqati issi issi xam77aa ayyo immidosona. He xam77atu gidduwan Aaroona xam77aikka de7ees. ");
INSERT INTO wal_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Muusee he xam77aa ubbaa Xoossaa Dunkkaaniyaa giddon GODAA sinttan wottiis. ");
INSERT INTO wal_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Wonttetta gallassi Xoossaa Dunkkaaniyaa giddo Muusee gelido wode, Leewa zare gidiya Aaroona xam77ai aacidaagaa, gumbbidaagaa, ciyyidaagaanne ciyidi lauziyaa giyo mitta aifiyaa aifidaagaa be7iis. ");
INSERT INTO wal_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Hegaappe guyyiyan, Muusee xam77a ubbaa GODAA sinttappe Israa7eela asaa ubbaakko ehiis. Ehin asai eta be7idoogaappe guyyiyan, halaqati bantta xam77aa xam77aa ekkidosona. ");
INSERT INTO wal_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","GODAI Muusa, “Aaroona xam77aa Taabootaa sinttan zaara wotta. Hegaa makkalidaageeti ta bolli naa77antto zuuzummidi haiqqennaadan, etau malaata oottada naaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Yaagin GODAI azazidoogaadan Muusee oottiis. ");
INSERT INTO wal_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israa7eela asai Muusa, “Nuuni haiqqana; xayana; nuuni ubbaikka xayana! ");
INSERT INTO wal_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Xoossaa Dunkkaaniyaakko, harai atto mataa shiiqiya uri ooninne haiqqana. Simmi nuuni ubbaikka haiqqiyoo?” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","GODAI Aaroona, “Neeni, ne attuma naatinne Leewati geeshsha sohuwaa oosuwan polettiya nagaraa tookkana; neeninne ne attuma naatu xalaalai intte qeesetettaa oosuwan polettiya nagaraa tookkana. ");
INSERT INTO wal_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Neeninne ne attuma naati Xoossaa Dunkkaaniyaa sinttan oottiyo wode, nenaara oottidi maaddana mala, Leewa zare gidiya ne dabbota eha. ");
INSERT INTO wal_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Eti intteppe garssaara Xoossaa Dunkkaaniyaa ooso ubbaa oottona; shin etikka inttekka issippe haiqqennaadan, eti geeshsha sohuwaa miishshaakkonne yarshshiyoosaakko shiiqoppona. ");
INSERT INTO wal_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Eti inttenaara issippe gidona; Xoossaa Dunkkaaniyan de7iya ooso ubbaa oottona. Leewatuppe attin, hara uri ooninne inttekko shiiqoppo. ");
INSERT INTO wal_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Naa77anttuwaa Israa7eelatu bolli hanqqoi wodhdhenna mala, geeshsha sohuwaanne yarshshiyoosaa oosuwaa oottite. ");
INSERT INTO wal_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Leewata intte dabbota Israa7eelatu giddoppe taani ta huuphen dooraas. Eti Xoossaa Dunkkaaniyaa oosuwaa oottanau intteyyo imodan immada, GODAU dummayaas. ");
INSERT INTO wal_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","SHin neeninne ne attuma naatu xalaalai yarshshiyoosaa oosuwaa ubbaanne magalashuwaa giddon de7iya qeesetetta ooso ubbaa oottite. Qeesetettaa oosuwaa taani intteyyo imodan oottada immais; hara uri ooninne geeshsha sohuwaakko shiiqiyaabi haiqqo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Hegaappe guyyiyan GODAI Aaroona, “Israa7eelati taayyo immiyo geeshsha imota ubbaa taani neeyyo immaas. Taani neeyyo ne gishshaanne ne attuma naatuyyo eta gishshaa merinau gishsha oottada immaas. ");
INSERT INTO wal_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Taayyo immiyo aadhdhida geeshsha imuwaappe taman xuugettenna baggai inttessa gidana: eti taassi immiyo geeshsha imuwaa ubbaappe kattaa yarshshoi, woikko nagaraa gishshau yarshshiyo yarshshoi, woikko naaquwaa gishshau yarshshiyo yarshshoi neessanne ne attuma naatussa gidana. ");
INSERT INTO wal_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Intte hegaa geeshsha sohuwan miite; attumaagee ubbai hegaa mo; hegee inttessi geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Hagee qassi neessa. Israa7eelatu wuxaawuxo yarshsho ubbaa neeyyo, ne attuma naatuyyoonne ne macca naatuyyo merinau gishsha oottada immais; intte keettaa asaa giddon wogaadan geeshsha gidiya ubbai hegaa mo. ");
INSERT INTO wal_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Eti taayyo immiyo koiro aifiyaappe lo77o wogaraa zaitiyaa ubbaa, yelaga woine eessaa ubbaanne muruta kattaa ubbaa neeyyo immais. ");
INSERT INTO wal_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Eti GODAAYYO ehiyo eta biittan de7iya koiro gakkida aifee inttessa; intte keettaa asaa giddon wogaadan geeshsha gidiya ubbai hegaa mo. ");
INSERT INTO wal_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Israa7eelan GODAAYYO dummatidabai ubbai inttessa. ");
INSERT INTO wal_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Baira yelettida asi woikko mehee, Israa7eelati GODAAYYO immidobi inttessa. SHin baira yelettida asanne baira yelettida geeshsha gidenna mehe intte wozanau bessees. ");
INSERT INTO wal_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Issi agina naata wozanau Xoossaa Dunkkaaniyan eriyo meezaanaa likkiyan ichchashu xaqara biraa wozo waagaa qanxxite. ");
INSERT INTO wal_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","SHin miizzaa bairaa, woikko dorssaa bairaa, woikko deeshshaa bairaa intte wozanau koshshenna; eti geeshsha. Neeni eta suuttaa yarshshiyoosaa bollan caccafa; GODAA tonggu giidi sawana mala, eta modhdhuwaa taman xuugga. ");
INSERT INTO wal_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Etappe beettiya ashoi wuxaawuxido anggaasuwaadaaninne ushachcha gedaadan inttessa. ");
INSERT INTO wal_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Israa7eelati GODAAYYO immiyo geeshsha yarshsho ubbaa neessi, ne attuma naatussinne ne macca naatussi merinau gishsha oottada immais. Hageekka taani nenaaranne ne zerettatuura maacettiyo merinaa maachcha” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Qassikka GODAI Aaroona, “Eta biittan neeni ainne laattakka; eta giddon nena gakkiya shaahoi aibikka baawa; Israa7eelatu giddon ne laatainne nena gakkiya shaahoi tana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","GODAI, “Leewati Xoossaa Dunkkaaniyan oottiyo oosuwaa gishshau, Israa7eelatu asirata ubbaa etayyo immaas. ");
INSERT INTO wal_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Hachchippe doommidi, Israa7eela asati bantta nagaran haiqqenna mala, Xoossaa Dunkkaaniyaakko shiiqoppona. ");
INSERT INTO wal_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Xoossaa Dunkkaaniyaa oosuwaa oottiyaageetinne hegan polettiya nagaraa tookkiyaageeti Leewata. Hagee yeleta ubbau merinaa wogaa. Leewati Israa7eela asaa gidduwan ainne laattokkona. ");
INSERT INTO wal_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Hegaa gishshaa, Israa7eelati GODAAYYO imodan immiyo asirataa, taani Leewatuyyo eta laatadan immaas. Taani etabaa, ‘Eti Israa7eela asaa gidduwan ainne laattokkona’ yaagidoogee hegaassa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Qassi GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Neeni Leewata hagaadan yaaga; ‘Taani intteyyo laatadan immido asirataa intte Israa7eela asaappe ekkiyo wode, intte he asirataappe asirataa GODAAYYO immite. ");
INSERT INTO wal_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Intte imoi intteyyo kattaa qoxxiyo audiyaa kattaadaaninne gum77iyo woine aifiyaadan qoodettees. ");
INSERT INTO wal_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Qassi hagaadan Israa7eela asaappe intte ekkiyo asirata ubbaappe imuwaa GODAAYYO immite; ha asirataappe GODAA gishshaa qeesiyaa Aaroonayyo intte immanau bessees. ");
INSERT INTO wal_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Intte ekkiyo imota ubbaappe, lo77iyaagaanne geeshshaa GODAASSI gishsha oottidi, intte immanau bessees’ yaaga. ");
INSERT INTO wal_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Qassi neeni Leewata, ‘Ubbaappe lo77o imuwaa intte immidoogaappe guyyiyan, attidaagee intteyyo kattaa qoxxiyo audiyaa kattaadaaninne gum77iyo woiniyaa aifiyaadan qoodettana. ");
INSERT INTO wal_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Inttenne intte keettaa asai hegaappe attidaagaa awaaninne miite; aissi giikko, hegee Xoossaa Dunkkaaniyan intte oottiyo oosuwaayyo intte damoozaa. ");
INSERT INTO wal_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Lo77o baggaa GODAASSI immirggidoogaappe guyyiyan intte miyo wode, mooranchcha gidekketa. SHin lo77o baggaa he imotaappe kessennan de7iiddi, he imotaappe miidi, intte Israa7eela asaa imotaa tunissennaadan naagettite. Hegaadan oottana xayikko, intte haiqqana’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","GODAI Muusanne Aaroona hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“GODAI higgiyan azazido wogai hagaa: Tilla bollaara de7iya woikko borssoi bainna, i morggiyan qambbari wodhdhibeenna zo7o ussiyo neeyyo ehaana mala, Israa7eela asaayyo yootite. ");
INSERT INTO wal_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Qeesiyaa El77aazarayyo o immite; i o dunkkaanidosaappe gaxi efin, issi asi o a sinttan shukko. ");
INSERT INTO wal_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Qeesiyaa El77aazari i suuttaappe amaridaagaa ba biradhdhiyan ekkidi, Xoossaa Dunkkaaniyaayyo sintta baggaara laapputto caccafo. ");
INSERT INTO wal_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","I xeellishin ussiyaa xuugettu; i galbbai, ashoi, suuttainne tocee xuugetto. ");
INSERT INTO wal_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Qeesee zigaa, hiisoophphiyaa tashiyaanne zo7o qunccuutiyaa ekkidi, ussiyo xuuggiyo taman olo. ");
INSERT INTO wal_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Hegaappe guyyiyan, qeesee ba maayuwaa meecco; ba bollaakka haattan meecetto; meecettidi dunkkaanidosaa gelo; shin omarssa gakkanaassi i wogaadan tuna gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","He ussiyo xuuggidaagee qassi ba maayuwaa meecco; ba bollaakka haattan meecetto; ikka qassi omarssa gakkanaassi wogaadan tuna gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Hegaappe guyyiyan, geeshsha asi ussiyaa xuugettido bidinttaa shiishshidi, dunkkaanidosaappe gaxaara geeshsha sohuwan wotto. Israa7eela asai tunatettaappe geeyiyo haattan go7ettanau hegaa naagi wottana; hegee nagaraappe geeshshanaassa. ");
INSERT INTO wal_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Qassi ussee bidinttaa shiishshida asi ba maayuwaa meecco; omarssi gakkanaassi i wogaadan tuna gidana. Ha wogai Israa7eela asaunne eta gidduwan de7iya hara dere asau naa77aukka merinaa woga gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Haiqqida asa ahaa bochchiya ooninne laappun gallassaa wogaadan tunana. ");
INSERT INTO wal_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","He tunatettaappe geeyiyo haattan heezzantta gallassinne laappuntta gallassi, i bana geeshsho; hegaappe guyyiyan, i wogaadan geeshsha gidana; shin heezzantta gallassaaninne laappuntta gallassan bana geeshshana xayikko, i geeshsha gidenna. ");
INSERT INTO wal_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Haiqqida uraa ahaa bochchiya ooninne bana geeshshennan aggikko, GODAA Dunkkaaniyaa i tunissees; he urai Israa7eela asaa giddoppe bohetto. Tunatettaappe geeyiyo haattai a bollan caccafettibeenna gishshau, i tuna; a tunatettai a bollan gam77ees. ");
INSERT INTO wal_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Issi uri dunkkaaniyaa giddon haiqqikko de7iya wogai hagaa: dunkkaaniyaa giddo geliya ooninne, qassi dunkkaaniyaa giddon de7iya ubbaikka laappun gallassaa tuna gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Hegaadankka, qum77ettennan dooya de7iya miishsha ubbai tuna gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Qassi dembban bisuwan haiqqida asa, woikko coo haiqqida ahaa, woikko asa meqetta, woikko duufuwaa bochchiya ooninne laappun gallassaa tuna gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Tunatettaappe geeshshanau xuuggido ussee bidinttaappe amaridaagaa ekkada, otuwan wottada, pultto haattaa an tiga; ");
INSERT INTO wal_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","tigin geeshsha asi hiisoophphiyaa bonccuwaa ekkidi, haattan naaqqi kessidi, dunkkaaniyaa, dunkkaaniyan de7iya miishshaa ubbaaninne hegan de7iya asaa ubbaa bollan caccafo. Qassi asa meqettaa, woikko duufuwaa, woikko worido uraa, woikko haiqqida uraa bochchida asa o bollinne i caccafo. ");
INSERT INTO wal_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Geeshsha asi heezzanttanne laappuntta gallassan tunida uraa bollan caccafo. I laappuntta gallassan he uraa tunatettaappe geeshsho; he geeyida bitanee ba maayuwaa meecco; ba bollaakka haattan meecetto; he gallassa omarssi i geeshsha gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“SHin tuna uri bana geeshshennabaa gidikko, he uri GODAA geeshsha sohuwaa tunissido gishshau, Israa7eela asaa giddoppe bohetto; tunatettaappe geeyiyo haattai a bollan caccafettibeenna gishshau, i tuna. ");
INSERT INTO wal_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hagee intteyyo merinaa woga gidana. Qassi tunatettaappe geeyiyo haattaa caccafiya asi ba maayuwaa meecco; tunatettaappe geeyiyo haattaa bochchiya ooninnekka omarssi gakkanaassi tuna gidana. ");
INSERT INTO wal_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Tuna uri bochchiyo aibinne tunees. Qassi hegaa bochchiya ooninne omarssa gakkanaassi tuna gidees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Koiro aginan Israa7eelati ubbai Xiina giyo bazzuwaa gakkidi, Qaadeesa giyoosan dunkkaanidosona. Hegan Miiriyaama haiqqada moogettaasu. ");
INSERT INTO wal_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Hegan asaayyo haatti xayin, asai shiiqidi, Muuse bollinne Aaroona bolli denddiis. ");
INSERT INTO wal_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Eti, “Nu ishantti GODAA sinttan haiqqido wode, nuunikka haiqqidabaa gidorkkoniishsha! ");
INSERT INTO wal_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nuuninne nu mehee ha bazzuwan haiqqanaadan, GODAA asaa hagau intte aissi ehiidetii? ");
INSERT INTO wal_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ha hanttaara sohuwaa nuna Gibxxeppe pude aissi ehiidetii? Hagan katta aifee, woikko balasee, woikko woine aifee, woikko roomaanee baawa; qassi uyiyo haattikka hagan baawa” yaagidi Muuseera ooyettidosona. ");
INSERT INTO wal_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Yaatin Muuseenne Aarooni asaa matappe Xoossaa Dunkkaaniyaa pengge biidi gufannidosona; gufannin GODAA bonchchoi etayyo qoncciis. ");
INSERT INTO wal_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ne gatimaa ekka; neeninne ne ishaa Aarooni yaa7aa shiishshite; shiiqin eta sinttan zaallai haattaa goggana mala yoota. Zaallaappe haattaa intte kessidi, yaa7aanne eta mehiyaa ushshana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","GODAI azazidoogaadan, Muusee GODAA sinttappe gatimaa ekkiis. ");
INSERT INTO wal_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Inne Aarooni yaa7aa zaallaa sinttan shiishshidosona; shiishshin Muusee eta, “Inttenoo makkalanchchatoo, siyite; ha zaallaappe haattaa intteyyo nuuni tumu kessanee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Yaagidi Muusee ba kushiyaa xoqqu oottidi, ba gatiman naa77utoo zaallaa shocin, haattai xuuqqidi kiyiis; kiyin yaa7ainne eta mehee uyiis. ");
INSERT INTO wal_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","SHin GODAI Muusanne Aaroona, “Israa7eela asaa sinttan intte ta geeshshatettaa bessanau ammanettibeenna gishshau, taani etayyo immiyo biittaa ha asaa intte gelissekketa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Israa7eela asai GODAARA ooyettidonne i ba geeshshatettaa eta giddon qonccissidosai ha Mariiba haattaana. ");
INSERT INTO wal_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Muusee Qaadeesappe Eedooma biittaa kawuwaakko, ba kiitettiyaageeta hagaadan yaagidi kiittiis; “Ne dabbo gidiya Israa7eela asai hagaadan yaagees; ‘Nuna gakkida meto ubbaa neeni eraasa. ");
INSERT INTO wal_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nu maizza aawati duge Gibxxe wodhdhidosona; yan nuuni daro laittaa de7ida. Gibxxeti nunanne nu aawata huqqunnidosona. ");
INSERT INTO wal_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Huqqunnin nuuni GODAASSI waassin, nu waasuwaa siyidi, kiitanchchaa kiittidi, nuna Gibxxeppe kessiis. Ha77i nuuni ne biittaa gaxan de7iya Qaadeesa kataman de7oos. ");
INSERT INTO wal_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Hayyanaa, nuna ne biittaara kanttissarkkii! Nuuni ai gade giddoorakka woikko woine turaa giddoorakka kanttokko! Qassi nuuni ai haatta ollappenne haattaa uyokko. Nuuni Kawo Ogiyaa oiqqidi baana; nuuni ne biittaara kanttana gakkanaassi, haddirssi woikko ushachchi gookko’ yaagees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","SHin Eedooma kawoi, “Nu biittaara kanttissikke; intte hagaara kanttana kajjeelikko, nuuni denddidi inttena bisuwan olana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Yaagin Israa7eelati a, “Nuuni Kawo Ogiyaara baana; nuuni woikko nu mehee intte haattaa uyikko, nuuni hegaayyo waagaa qanxxana. Nuuni tohuwan aaretta xalaalaa koyoos; harabaa aibanne koyokko” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Eedooma kawoi zaarettidi, “Inttena kanttissikke” yaagiis. Hegaappe guyyiyan, daronne wolqqaama olanchchata ekkidi, Israa7eela asaara olaa gaittanau kiyiis. ");
INSERT INTO wal_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Eedoomati bantta biittaara Israa7eela asai kanttanau diggido gishshau, Israa7eela asai simmidi hara ogiyaa biis. ");
INSERT INTO wal_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Israa7eela asai ubbai Qaadeesappe denddidi, Hoora giyo deriyaa biidosona. ");
INSERT INTO wal_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Eedooma zawaa matan de7iya Hoora Deriyan, GODAI Muusanne Aaroona, ");
INSERT INTO wal_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aarooni haiqqidi ba maizzan gaittiyo wodee gakkiis. Mariiba haattaa matan intte naa77aikka ta azazuwaa bolli makkalido gishshau, Israa7eela asaayyo taani immiyo biittaa i gelenna. ");
INSERT INTO wal_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaroonanne a na7aa El77aazara ekkada, Hoora Deriyaa eha. ");
INSERT INTO wal_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aaroona maayuwaa qaarada, a na7aa El77aazara maizza. Aarooni ba maizzan gaittana; i yan haiqqana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","GODAI azazidoogaadan Muusee oottiis; asai ubbai xeellishin, eti Hoora Deriyaa kiyidosona. ");
INSERT INTO wal_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Kiyin Muusee Aaroona maayuwaa qaaridi, a na7aa El77aazara maizziis. Aarooni he deriyaa huuphiyan haiqqiis. Hegaappe guyyiyan, Muuseenne El77aazari deriyaappe wodhdhidosona. ");
INSERT INTO wal_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aarooni haiqqidoogaa asai ubbai erido wode, Israa7eela asai ubbai Aaroonayyo hasttamu gallassaa yeekkiis. ");
INSERT INTO wal_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Neegeeba Bazzuwan, Kanaane biittan de7iya Araada kawoi Israa7eela asai Ataarima efiya ogiyaa baggaara yiyoogaa siyido wode, i Israa7eelatuura olaa gaittidi, etappe amaridaageeta omooddiis. ");
INSERT INTO wal_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","He wode Israa7eela asai, “Neeni ha asaa nu kushiyan aattada immikko, nuuni eta katamata muleera xaissana” yaagidi GODAA shiiqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","GODAI Israa7eela qaalaa siyidi, he Kanaaneta etayyo aatti immiis; immin eti he Kanaanetanne eta katamata muleera xaissidosona. Hegaa gishshau, he sohoi Horima geetetti sunttettiis. ");
INSERT INTO wal_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Israa7eela asai Hoora Deriyaappe denddidi, Eedooma biittaa yuushuwaa baanau Zo7o Abbaa efiya ogiyaara biidosona; shin ogiyaa bollan asau danddayai wuriis. ");
INSERT INTO wal_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Asai, “Nuuni bazzuwan haiqqanau Gibxxeppe pude nuna aissi ehiidetii? Qumi baawa; haatti baawa; ha iita qumai nuna sheneyiis” yaagidi Xoossaa bollinne Muuse bolli zuuzummiis. ");
INSERT INTO wal_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Zuuzummin GODAI asaa gidduwan marzziyaara de7iya shooshshata yeddiis; eti dukkin, daro Israa7eelati haiqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Eti Muusekko yiidi a, “Nuuni GODAA bollinne ne bolli zuuzummidi, nagaraa oottida. Nuuppe ha shooshshaa haassana mala, neeni GODAA woossa” yaagidosona. Yaagin Muusee asaa gishshau woossiis. ");
INSERT INTO wal_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Hegaappe guyyiyan GODAI Muusa, “Neeni nahaase shooshshaa medhdhada, eta sinttan mittaa bollan kaqqa; dukettida ooninne a xeellikko paxana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Yaagin Muusee nahaase birataappe shooshshaa medhdhidi, mittaa bollan kaqqiis. Hegaappe guyyiyan, shooshshai dukkido asai ubbai nahaase shooshshaa xeellidi paxiis. ");
INSERT INTO wal_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israa7eela asai denddidi, Oboota giyoosan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Obootappe denddidi, Moo7aabappe sintta baazzan de7iya bazzuwan, arshsho baggaara, laalettida Abaarima kataman dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Hegaappe denddidi, Zareeda Zanggaaran dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Hegaappe denddidi, Amooretu biittaa gaxaa gakkanau biya bazzuwaa giddon Arnnoona SHaafaappe hefinttan dunkkaanidosona. Arnnoona SHaafai Moo7aaba biittaappenne Amooretu biittaappe gidduwan de7iya zawaa. ");
INSERT INTO wal_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Hegaa gishshau, GODAA Olaa Maxaafan, “Suufa heeran de7iya Waaheeba katamaanne Arnnoona SHaafaa zanggaaraa, ");
INSERT INTO wal_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Eera katamaa gakkanaassinne Moo7aaba zawaa gakkanaassi de7iya zanggaara dugettaa” yaagetti xaafettiis. ");
INSERT INTO wal_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Eti hegaappe denddidi, Beera giyoosaa biidosona; hegee GODAI Muusa, “Asaa shiishsha; taani etau haattaa immana” yaagidi yootido haatta ollaa. ");
INSERT INTO wal_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","18","Hegan Israa7eela asai ha mazamuriyaa yexxiis. “Haattaa ollau, pultta! Halaqati bookkido haattaa ollaayyo, asaa kaalettiyaageetu ollaayyo, kawotaa xam77aaninne eta kazaran bookkido haatta ollaayyo ane yexxoos” yaagiis. Eti he bazzuwaappe Mataana giyoosaa biidosona; ");
INSERT INTO wal_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mataanappe Naahili7eela, Naahili7eelappe Baamoota giyoosaa, ");
INSERT INTO wal_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Baamootappe denddidi, Moo7aaban de7iya zanggaaraa biidosona; ha zanggaarai Pisgga Deriyaappe garssan bazzuwaa giigan de7ees. ");
INSERT INTO wal_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Hegaappe guyyiyan, Israa7eela asai Amoore biittaa Kawuwaa Sihoonakko kiitettiyaageeta hagaadan yaagidi kiittiis; ");
INSERT INTO wal_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Nuna ne biittaara kanttissarkkii! Nuuni ne gadiyaa giddo woikko woine turaa giddo gelokko; qassi haatta ollaa augaappenne uyokko. Nuuni ne biittaara kanttana gakkanaassi, Kawo Ogiyaara baana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","SHin Sihooni ba biittaara Israa7eela asaa kanttissennan diggiis; i ba olanchchata ubbaa shiishshidi, Israa7eela asaa olanau bazzo biis; Yahaaxa giyoosaa bi gakkidi, Israa7eela asaara olettiis. ");
INSERT INTO wal_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","SHin Israa7eela asai olan Amooretuppe daruwaa woridi, eta biittaa Arnnoona SHaafaappe doommidi, Amoonatu zawan de7iya Yaabooqa SHaafaa gakkanaassi oiqqiis. Amoona asatu biittaa zawai gimbbetti uttido gishshau, eti yaa gelibookkona. ");
INSERT INTO wal_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Yaatin Israa7eelati Amooretu katamata ubbaa xoonidi ekkidosona. Qassi Haseboonanne a yuushuwan de7iya qeeri katamatakka ubbaa oiqqidi, yan uttidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Haseboona katamai Amooretu Kawuwaa Sihoona katamaa. Sihooni Moo7aaba biittaa kawuwaa kaseegaa olidi, Arnnoona SHaafaa gakkanaassi a biittaa ubbaa appe ekkidaagaa. ");
INSERT INTO wal_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Hegaa gishshau, leemisuwan hagaadan yaagidosona; “Hasebooni haayite; he katamai zaaretti keexetto; Sihoona gita katamai wodhdhi eqqidi keexetto! ");
INSERT INTO wal_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Aissi giikko, tamai Haseboonappe, lacoi Sihoona katamaappe kiyiis; kiyidi Moo7aaban de7iya Eeranne Arnnoona SHaafaa heeran gezziyan de7iya halaqata miis. ");
INSERT INTO wal_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moo7aabaa, neeyyo aayye7ana! Kamooshau goinniyaageetoo, intte xayideta. Intte xoossai, Kamooshi, intte attuma naata baqatau, intte macca naata omooduwau, Amooretu Kawuwaa Sihoonayyo immiis. ");
INSERT INTO wal_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Intte zerettati Haseboonappe doommidi, Diboona gakkanaassi muleera xayidosona. Medaaba matan de7iya Nofaaha gakkanaassi wurssidi bashshidosona” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Hegaadan hanidi, Israa7eelati Amooretu biittan uttidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Qassi Muusee wochchiyaageeta Yaa7izeera giyo katamaa yeddin, Israa7eelati he katamaanne a heeran de7iya qeeri katamata oiqqidi, hegan de7iya Amooreta kessidi yedettidosona. ");
INSERT INTO wal_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Hegaappe guyyiyan, Israa7eelati simmidi, Baasaane efiya ogiyaara kiyidosona. Kiyin Baasaane Kawoi Oogi ba olanchchatu ubbaara Ediraa7a giyo katamaa etaara olettanau kiyiis. ");
INSERT INTO wal_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","SHin GODAI Muusa, “Ayyo yayyoppa! Aissi giikko, taani Kawuwaa Ooga a asaa ubbaaranne a biittaara ne kushiyan aattada immaas. Haseboonan uttidi haarida Amooretu Kawuwaa Sihoona bolli oottidoogaadan, neeni a bollikka oottana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Yaagin Israa7eelati Ooga, a attuma naatanne a asaa ubbaa issuwaanne paxa ashshennan woridosona. Woridi eti a biittaa laattidosona. ");
INSERT INTO wal_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Hegaappe guyyiyan Israa7eela asai denddidi, Yarkko ginan Yorddaanoosa hefinttan de7iya Moo7aaba dembban dunkkaaniis. ");
INSERT INTO wal_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Israa7eela asai Amooretu bolli oottidoogaa ubbaa Xippoora na7ai Baalaaqi siyiis. ");
INSERT INTO wal_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Siyin Israa7eela asai keehi daro gidido gishshau, Moo7aabati keehi dagammidi yayyidosona. ");
INSERT INTO wal_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moo7aabati Midiyaama cimata, “Boorai maataa mi xaissiyoogaadan ha wude asai nu yuushuwan de7iya ubbaa mi xaissana” yaagidosona. Yaagin he wode Moo7aaba Kawoi, Xippoora na7ai Baalaaqi ");
INSERT INTO wal_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Amaawa biittan Efiraaxiisa SHaafaa matan Patoora kataman de7iya Bi7oora na7aa Balaamakko asa kiittiis. Kiittiiddi Baalaaqi, “Be7a, Gibxxeppe daro asai kiyiis; eti biitta ubbaa maayidi, taappe ya baggan de7oosona. ");
INSERT INTO wal_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Eti taayyo keehi wolqqaamiyo gishshau, hayyanaa ha77i yaada, eta taayyo qanggarkkii! Ooni erii, taani eta xoonanaunne biittaappe kessanau danddayanaakkonne. Aissi giikko, neeni anjjidoogee anjjettidaagaanne neeni qanggidoogee qanggettidaagaa gidiyoogaa taani erais” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Yaagin Moo7aaba cimatinne Midiyaama cimati qanggissiyo waagaa ekkidi, Balaamakko biidosona. Biidi Baalaaqi giidoogaa ayyo yootidosona. ");
INSERT INTO wal_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Yootin Balaami eta, “Hachchi qammi hagan aqite; GODAI taayyo yootiyoogaa taani intteyyo yootana” yaagiis. Yaagin Moo7aaba halaqati Balaamaagan takkidosona. ");
INSERT INTO wal_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Xoossai Balaamakko yiidi, “Hageeti nenaara de7iya asati oonee?” yaagidi oichchiis. ");
INSERT INTO wal_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Oichchin Balaami Xoossaa, “Moo7aaba Kawoi, Xippoora na7ai Baalaaqi, ");
INSERT INTO wal_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Gibxxeppe daro asai kiyiis; eti biitta ubbaa maayidosona. Ha77i neeni yaada, eta taayyo qanggarkkii! Ooni erii, taani eta xoonanaunne biittaappe kessanau danddayanaakkonne’ yaagidi eta taakko kiittiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Yaagin Xoossai Balaama, “Neeni etaara booppa. Israa7eelati anjjettidaageeta gidiyo gishshau, neeni he asaa qanggoppa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Wonttetta gallassi maallado Balaami denddidi, Baalaaqa halaqata, “Taani inttenaara beennaadan GODAI diggido gishshau, intte biitti simmite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Yaagin Moo7aaba halaqati yaappe denddidi, Baalaaqakko simmidi a, “Balaami nunaara yeennan ixxiis” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Zaaridikka Baalaaqi kaseegeetuppe aadhdhi bonchchettidanne qoodankka corattida hara halaqata akko kiittiis. ");
INSERT INTO wal_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Eti Balaamakko yiidi, “Xippoora na7ai Baalaaqi nena, ‘Neeni taakko yaanaagaa nena aibinne teqqoppo. ");
INSERT INTO wal_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Aissi giikko, taani neeyyo daro woituwaa immana; neeni giyoobaa ubbaa aibanne taani oottana. Yaada ha asaa taayyo qanggarkkii!’ yaagiis” yaagidi yootidosona. ");
INSERT INTO wal_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","SHin Balaami etayyo, “Baalaaqi harai atto birainne worqqai kumido ba kawo keettaa tau immidabaa gidiyaakkonne, GODAA ta Xoossaa azazuwaappe kanttada, taani aibanne pacissanau woikko gujjanau danddayikke. ");
INSERT INTO wal_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","GODAI taayyo yootiyo harabi de7ikko taani eranaadan, inttekka hachchi qamma hagan aqite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","He gallassa qammi Xoossai Balaamakko yiidi, “Ha asai nena xeesanau yiido gishshau, neeni etaara ba. SHin taani neeyyo yootiyoobaa xalaalaa ootta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Yaagin wonttetta gallassi Balaami ba hariyo kooridi, Moo7aaba halaqatuura biis. ");
INSERT INTO wal_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","SHin i biyo wode Xoossaa hanqqoi eexxi kiyiis; yaatin GODAA kiitanchchai a teqqanau ogiyan eqqiis. He wode Balaami ba hariyo toggidaashin, a naa77u ashkkarati aara de7oosona. ");
INSERT INTO wal_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","GODAA kiitanchchai bisuwaa zaaretti oiqqidi, ogiyan eqqidaagaa hariyaa be7annee, ogiyaa aggada, goshshaa giddo gelaasu. Gelin Balaami ogiyaa zaaranau hariyo bukkiis. ");
INSERT INTO wal_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Yaatin GODAA kiitanchchai naa77u woine turaa sohotuppe gidduwan, ya baggaaranne ha baggaara gimbbiyan diretti uttida un77o ogiyan eqqiis. ");
INSERT INTO wal_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Hariyaa GODAA kiitanchchaa be7ido wode, gimbbe dirssaakko shiiqada, Balaama tohuwaa gimbbe dirssaara daraxaasu; daraxin i hariyo naa77anttokka bukkiis. ");
INSERT INTO wal_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Hegaappe guyyiyan, GODAA kiitanchchai sinttaukko aadhdhidi, haddirssa baggaarakka ushachcha baggaara kanttiyoosi bainna un77o sohuwan eqqiis. ");
INSERT INTO wal_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Hariyaa GODAA kiitanchchaa be7ada, Balaami toggidaashin zin77aasu. Balaami keehi hanqqettidi, ba xam77an hariyo bukkiis. ");
INSERT INTO wal_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Hegaappe guyyiyan, GODAI haree doonaa dooyin, hariyaa Balaama, “Taani neeyyo ai oottiinee neeni tana ha heezzutoo bukkidoogee?” yaagaasu. ");
INSERT INTO wal_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Yaagin Balaami hariyo, “Neeni tana eeyettido gishshataassa. Ta kushiyan bisoi de7idabaa gidiyaakko, taani nena ha77i worana shin!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Yaagin hariyaa Balaama, “Taani ne de7o ubban hachchi gakkanaassi toggiyo ne hariyo gidikkinaa? Taani neeyyo hagaadan hana eriyaanaa?” yaagaasu. Yaagin Balaami, “Hana erakka” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Hegaappe guyyiyan, GODAI Balaama aifiyaa dooyin, GODAA kiitanchchai shoohuwaappe shoddido bisuwaa oiqqidi, ogiyan eqqidaagaa be7iis. Be7idi i lichchi giidi, som77uwaa sa7aa gattidi gufanniis. ");
INSERT INTO wal_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","GODAA kiitanchchai a, “Ne hariyo ha heezzutoo aissi bukkadii? Ne ogee ta sinttan geella gidiyo gishshau, taani nena teqqanau hagaa yaas. ");
INSERT INTO wal_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Hariyaa tana be7ada, ta sinttappe heezzutoo wora simmaasu. Hariyaa wora simmabeennabaa gidiyaakko, taani nena hannoode tumu worarggada, hariyo ashshana shin” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Yaagin Balaami GODAA kiitanchchaa zaaridi, “Taani nagaraa oottaas. Neeni tana teqqanau ogiyaa bollan eqqidoogaa taani erabeikke. Neeni dosabeennabaa gidikko, taani ha77i guyye simmana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Yaagin GODAA kiitanchchai Balaama, “Neeni ha asatuura ba; shin taani neeyyo yootiyoogaa xalaalaa haasaya” yaagiis. Yaagin Balaami Baalaaqa biittaa halaqatuura biis. ");
INSERT INTO wal_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaami yiyoogaa Baalaaqi siyido wode, Arnnoona SHaafaa zawan ba biittaa gaxan de7iya Moo7aabatu kataman aara gaittanau biis. ");
INSERT INTO wal_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Baalaaqi Balaama, “Neeni eesuwan yaanaadan taani kiittabeikkinaa? Neeni aibissi taakko sohuwaara yabeikkii? Taani neeyyo woitanau tumu danddayikkinaa?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Yaagin Balaami Baalaaqa, “Be7a, ha77i taani neekko yaas; shin taani aibanne gaanau tumu danddayikke. Xoossai tana haasayissiyoogaa xalaalaa taani haasayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Hegaappe guyyiyan, Balaami Baalaaqaara Qiriyaati-Huxoota giyo katamaa biis. ");
INSERT INTO wal_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Bin Baalaaqi miizzaanne dorssaa yarshshidi, ashuwaappe amaridaagaa Balaamayyoonne aara de7iya halaqatuyyo immiis. ");
INSERT INTO wal_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Wonttetta gallassi maallado Baalaaqi Balaama ekkidi, Baamooti-Ba7aali giyoosaa pude kessiis; kessin hegan eqqidi, Balaami Israa7eela asaappe baggaa be7iis. ");
INSERT INTO wal_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaami Baalaaqa, “Hagan neeni tau laappun yarshshiyo sohota gimbba; qassi laappun korima booraanne laappun dorssa orggeta neeni taayyo giigissa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaami giidoogaadan Baalaaqi oottiis; eti naa77aikka issi issi yarshshiyo sohuwan issi korima booraanne issi dorssa orggiyaa yarshshidosona. ");
INSERT INTO wal_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Hegaappe guyyiyan, Balaami Baalaaqa, “Neeni ne xuuggiyo yarshshuwaa matan hagan eqqashsha; taani gedekko bais. GODAI tanaara gaittanau geelladan yeennan aggenna. I taayyo qonccissiyoobaa aibanne taani neeyyo yootana” yaagiis. Yaagidi xoqqa booddila sohuwaa kiyiis. ");
INSERT INTO wal_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Hegan Xoossai Balaamaara gaittin Balaami, “Taani laappun yarshshiyo sohota giigissaas; issi issi yarshshiyo sohuwan issi korima booraanne issi dorssa orggiyaa yarshshaas” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yaagin Balaami gaanabaa GODAI ayyo yootidi, “Neeni Baalaaqakko simmada, ayyo ha hiraagaa yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Yaagin i Baalaaqakko simmiyo wode, Baalaaqi Moo7aaba halaqatu ubbaara ba xuuggiyo yarshshuwaa matan eqqiis. ");
INSERT INTO wal_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Hegaappe guyyiyan, Balaami ba hiraagaa hagaadan yaagidi yootiis; “Moo7aaba kawoi arshsho bagga deretuppe, Sooriyaa biittaappe tana hagaadan yaagidi ehiis; ‘Haa ya; Yaaqooba taayyo qangga! Israa7eela asaa, “Wurite!” yaaga’ yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Xoossai qanggibeennaageeta taani waata qanggoo? GODAI, ‘Wurite!’ yaagibeennaageeta taani waatada, ‘Wurite!’ yaagoo? ");
INSERT INTO wal_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Taani xoqqa zaallaa huuphiyan eqqada eta xeellais; keran eqqada taani eta be7ais. Eti banttarkka de7iya asa; eti banttana kawotettatuppe issuwaadan qoodokkona. ");
INSERT INTO wal_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Baanaadan corattida Yaaqooba zerettaa ooni qoodanau danddayii? Harai atto Israa7eela asau oiddantta kushiyaa ooni qoodanau danddayii? Ta haiqoi xillotu haiquwaa mala gido; ta de7uwaa wurssettaikka etaagaadan hano!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Yaagin Baalaaqi Balaama, “Neeni ta bolli oottiyoobi aibee? Taani nena ta morkketa qangganaadan ehaas; shin neeni eta anjjadasappe attin, haraba ainne oottabaakka!” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Yaagin Balaami zaaridi, “Taani GODAI tana haasayissiyoogaappe haraa haasayooyye?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Hegaappe guyyiyan, Baalaaqi a, “Eta neeni be7anau danddayiyo harasaa tanaara hindda. Neeni etappe amaridaagaa be7anaappe attin, eta ubbaa be7akka. Neeni hegan taayyo eta qanggarkkii” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Yaagidi Pisgga giyo deriyaa huuphiyan de7iya Xofiima dembbaa ekkidi efiis. Hegan laappun yarshshiyo sohota gimbbiis; gimbbidi issi issi yarshshiyo sohuwan issi korima booraanne issi dorssa orggiyaa yarshshiis. ");
INSERT INTO wal_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaami Baalaaqa, “Taani hinin GODAARA gaittiyo wode, neeni hagan ne xuuggiyo yarshshuwaa matan eqqashsha” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","GODAI Balaamaara gaittidi kiittiiddi, “Neeni Baalaaqakko simmada, ayyo ha hiraagaa yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Yaagin i akko simmidi, ba xuuggiyo yarshshuwaa matan Moo7aaba biittaa halaqatuura eqqidaagaa demmiis. Baalaaqi a, “GODAI yootidobai aibee?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Yaagin Balaami ba hiraagaa hagaadan yaagidi yootiis; “Xippoora na7aa Baalaaqaa denddada ezgga; taani yootiyoogaa siya! ");
INSERT INTO wal_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Xoossai worddotanau asa gidenna; ba qofaa laammanau i asa na7a gidenna. I yootidi, ba yootidoogaa oottennee? Woikko i ba giidobaa polennee? ");
INSERT INTO wal_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Taani anjjanau azazuwaa ekkaas. I anjjiichchiis; taani hegaa laammanau danddayikke. ");
INSERT INTO wal_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yaaqooba zariyau iitabi yaanabi, Israa7eela asau metoi gakkanabi taayyo beettibeenna. GODAI eta Xoossai etaara de7ees; i etau kawo gidiyoogaa awaajjoosona. ");
INSERT INTO wal_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Xoossai eta Gibxxeppe kessiis; i mino menttaadan etau de7ees. ");
INSERT INTO wal_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yaaqooba zariyaa gakkana biti baawa; Israa7eela asaa qohana murunnoikka baawa. Asai ha77i, ‘Yaaqoobassinne Israa7eelassi Xoossai oottidobaa be7ite’ yaagana. ");
INSERT INTO wal_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ha asai macca gaammeedan denddiis. Ba oiqqidobaa maana gakkanaashiininne ba woridoogaa suuttaa uyana gakkanaashin, shemppenna gaammuwaadan eti eqqi denddoosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Hegaappe guyyiyan, Baalaaqi Balaama, “Neeni eta mulekka qanggoppanne mulekka anjjoppa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Yaagin Balaami zaaridi, “‘GODAI giyoobaa ubbaa oottana’ gaada taani neeyyo yootabeikkinaa?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Hegaappe guyyiyan, Baalaaqi Balaama, “Haa ya; taani nena harasaa efaana. Ooni erii, nena yaa efin Xoossai ufaittidi, nena eta taayyo qanggissanaakko” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Baalaaqi Balaama bazzuwaa bollaara duge xeelliyo Pa7oora Deriyaa huuphiyaa efiis. ");
INSERT INTO wal_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Efin Balaami, “Neeni hagan tau laappun yarshshiyo sohota gimbba; qassi laappun korima booratanne laappun dorssa orggeta taayyo giigissa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaami giidoogaadan Baalaaqi oottiis; issi issi yarshshiyo sohuwan issi korima booraanne issi dorssaa orggiyaa yarshshiis. ");
INSERT INTO wal_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Israa7eela anjjiyoogee GODAA ufaissidoogaa Balaami be7ido wode, kase i oottidoogaadan murunnanau koyibeenna; shin ba som77uwaa bazzuwaakko zaariis. ");
INSERT INTO wal_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Zaaridi xoqqu giidi xeellidi, Israa7eela asai ba zariyan zariyan dunkkaani uttidaagaa be7iis; be7in Xoossaa Ayyaanai a bolli wodhdhiis. ");
INSERT INTO wal_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Wodhdhin i ba hiraagaa hagaadan yaagidi yootiis; “Bi7oora na7aa Balaama hiraagai, a aifee tishshi ootti xeelliyoogaa hiraagai, ");
INSERT INTO wal_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Xoossai giyoobaa siyiyaagaa hiraagai, lichchi giidi gufannin, a aifee dooyettidoogaanne Ubbaa Danddayiya Xoossaa ajjuutaa be7iyaagaa hiraagai hagaa. ");
INSERT INTO wal_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yaaqooba zaretoo, intte dunkkaaneti, Israa7eela asau, intte de7iyoosatikka aiba lo77oo! ");
INSERT INTO wal_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Eti micettida wombbaadan, shaafaa doonan de7iya ataakilttiyaa sohuwaadan, GODAI tokkido godare uuttaadaaninne haattaa doonan de7iya zigaadan hanoosona. ");
INSERT INTO wal_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Etau daro haattai pulttana; eta zerettau gidiya haattai de7ana. Eta kawoi Kawuwaa Agaagappe gitatana; eta kawotettaikka bonchchettana. ");
INSERT INTO wal_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Xoossai eta Gibxxeppe kessiis; i mino menttaadan etau de7ees. Eti morkke kawotettaa mittana; eta meqettaakka liiqissana; eti bantta wonddafiyaa zubbiyan eta caddana. ");
INSERT INTO wal_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Israa7eela asai gaammuwaadan zin77ees. Macca gaammeedan eta denttanau ooni xalanee? Inttena anjjiya ubbai anjjettidaagaa gidana; inttena qanggiya ubbai qanggettidaagaa gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Hegaappe guyyiyan, Baalaaqi Balaama bolli hanqquwaa eexxi kiyiis. Baalaaqi ba kushiyaa dukkidi Balaama, “Ta morkketa qangganaadan taani nena xeesaas; shin neeni ha heezzutookka eta anjjadasa. ");
INSERT INTO wal_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Simmi ha77i neeni ne soo baqata; ‘Taani neeyyo darobaa woitana’ gaas; shin neeni woituwaa ekkennaadan GODAI nena diggiis” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Yaagin Balaami Baalaaqa zaaridi, “Neeni taakko kiittidoogeetun, ");
INSERT INTO wal_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Baalaaqi harai atto ba birainne worqqai kumido ba kawo keettaa tau immidabaa gidiyaakkonne, GODAI yootidoogaa kanttada, lo77uwaa woikko iitaa ta sheniyan oottanau danddayikke. Taani GODAI giyoobaa xalaalaa gaana’ yaagada neeyyo yootabeikkinaayye?” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Yaagidi, “Taani ha77i ta asaakko bais; shin neeni haa ya; ha asai wurssetta wodiyan ne asaa oottanabaa taani neeyyo yootana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Yaagidi i ba hiraagaa hagaadan yaagidi yootiis; “Bi7oora na7aa Balaama hiraagai, a aifee tishshi oottidi xeelliyoogaa hiraagai, ");
INSERT INTO wal_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Xoossai giyoobaa siyiyaagaanne Ubbaappe Xoqqiya Xoossaappe gidida eratettai de7iyoogaa hiraagai, lichchi giidi gufannin, a aifee dooyettidoogaanne Ubbaa Danddayiya Xoossaa ajjuutaa be7iyaagaa hiraagai hagaa. ");
INSERT INTO wal_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Taani a be7ais; shin wodee ha77a gidenna; taani a xeellais; shin matan gidenna. Yaaqooba zariyaappe xoolinttee kiyana. Israa7eelappe kawotaa xam77ai kiyana. Moo7aaba asaa som77uwaa i gaacci qolana. Seeta asaa ubbaa huuphiyaa i kinchchana. ");
INSERT INTO wal_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Eedoomi xoonettana; a morkkee Se7iirikka xoonettana; shin Israa7eeli minni minnidi baana. ");
INSERT INTO wal_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yaaqoobappe haariyaagee kiyana; kiyidi eta kataman paxa attidaageeta xaissana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Hegaappe guyyiyan, Balaami Amaaleeqa asata be7idi, ba hiraagaa hagaadan yaagidi yootiis; “Kawotettatu giddon Amaaleeqi koiro; shin eta wurssettai xayo” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Qassi Balaami Qeena asata be7idi, ba hiraagaa hagaadan yaagidi yootiis; “Intte de7iyo sohoi saro soho gidees; intte keettai zaallaa bollan keexettiis. ");
INSERT INTO wal_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","SHin Asooreti inttena omooddiyo wode, intte Qeena asati xayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Hegaappe guyyiyan, Balaami ba hiraagaa hagaadan yaagidi yootiis; “Aayye7ana! Xoossai hagaa oottiyo wode ooni de7ana danddayii? ");
INSERT INTO wal_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Markkabeti Kitiima haruuruwaappe yaana; eti Asooretanne Ebeerata huqqunnana; shin qassi etikka xayana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Hegaappe guyyiyan, Balaami denddidi, ba soo simmiis; Baalaaqikka ba ogiyaa biis. ");
INSERT INTO wal_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israa7eelati SHiixima giyoosan dunkkaanido wode, asai Moo7aaba biittaa maccaasatuura shaaramuxettaa doommiis. ");
INSERT INTO wal_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","He maccaasati bantta xoossatu yarshshuwaa maanau eta shoobbidosona; shoobbin eti miidi, eta xoossatuyyo goinnidosona. ");
INSERT INTO wal_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israa7eelati Pa7oora Ba7aala giyo eeqaa kaallido gishshau, GODAA hanqqoi eta bollan eexxi kiyiis. ");
INSERT INTO wal_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yaatin GODAI Muusa, “GODAA hanqqoi Israa7eelappe wora simmana mala, ha asaa kaalettiyaageeta ubbaa efaada, seeta gallassi GODAA sinttan kaqqa” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Yaagin Muusee Israa7eela daannata, “Pa7oora Ba7aala giyo eeqaayyo goinnida intte asaa ubbaa intte huuphiyan huuphiyan worite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Muuseenne Israa7eela maabarai ubbai Xoossaa Dunkkaaniyaa penggen yeekkishin, Israa7eelatuppe issoi Midiyaama biittaa maccaasiyo eta sinttaara aattidi, ba keettaa asaakko ehiis. ");
INSERT INTO wal_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Qeesiyaa Aaroona na7aa El77aazara na7ai Piinihaasi hegaa be7ido wode, maabaraa giddoppe denddidi, tooraa ba kushiyan oiqqidi, ");
INSERT INTO wal_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","he Israa7eela bitaniyaa kaallidi, dunkkaaniyaa giddo geliis. Gelidi Israa7eela bitaniyaanne mishiriyoonne naa77aakka tooran caddidi, kantti kessiis. Hegaadan hanin, boshai Israa7eelatuppe qaarettiis; ");
INSERT INTO wal_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","shin he boshan haiqqida asai laatamanne oiddu sha7a. ");
INSERT INTO wal_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Qeesiyaa Aaroona na7aa El77aazara na7ai Piinihaasi Israa7eela asaa giddon taani ta bonchchuwau mishettiyoogaadan mishettido gishshau, eta bolli taani hanqqettido hanqqoi dochchiis; taanikka eta ta hanqquwan xaissabeikke. ");
INSERT INTO wal_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Hegaa gishshau, taani ta sarotettaa maachchaa aara maacettiyoogaa Piinihaasayyo neeni oda. ");
INSERT INTO wal_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","I ba Xoossaa bonchchuwau mishettido gishshaunne Israa7eela asaayyo atto giissido gishshau, inne a zerettati merinau qeese gidana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Midiyaama biittaa mishireera worido Israa7eela bitaniyaa sunttai Saalu na7aa Zimira; Saalu Simoona zaretun issi yaraa halaqaa. ");
INSERT INTO wal_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Haiqqida Midiyaama biittaa mishiree sunttai Kozibo; i aawai Xuuri Midiyaamatu yaraa halaqaa. ");
INSERT INTO wal_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Midiyaama biittaa asata morkkite; morkkidi eta worite. ");
INSERT INTO wal_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Aissi giikko, eti inttena Pa7ooran cimmidi, inttessi morkke gididosona; qassi boshaa gallassi Pa7ooran worido mishiree, Midiyaamatu yaraa halaqaa na7ee Kozibi gaasuwan eti inttena morkkidosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Boshaappe guyyiyan, GODAI Muusanne qeesiyaa Aaroona na7aa El77aazara, ");
INSERT INTO wal_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Yelettoosappe laatamu laittanne hegaappe bollaara de7iya Israa7eelata, olau baanau danddayiyaageeta ubbata, eta keettan keettan qoodite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Yaagin Muuseenne qeesee El77aazari Yorddaanoosa SHaafaappe hefintta baggaara, Yarkko matan, Moo7aaba Dembban etaara haasayiiddi, ");
INSERT INTO wal_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“GODAI Muusa azazidoogaadan, yelettoosappe laatamu laittanne hegaappe bollaara de7iya asaa qoodite” yaagidosona. Gibxxeppe kiyida Israa7eelati hageeta: ");
INSERT INTO wal_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Israa7eela baira na7aa Roobeela zareti: Hanooka yarata, Paalu yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hexiroona yaratanne Karmma yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Hageeti Roobeela zareta; eti muleera 43,730. ");
INSERT INTO wal_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Paalu na7ai Eli7aaba; ");
INSERT INTO wal_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eli7aaba attuma naati Nemu7eela, Daataananne Abiiraama; ha Daataaninne Abiiraami maabarai dooridoogeeta. Eti Qoraahaaranne a kaalliyaageetuura zuppetidi, Muuse bolli, Aaroona bollinne GODAA bolli makkalidosona. ");
INSERT INTO wal_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Biittai dooyettidi, eta Qoraahaara issippe mittiis; eta kaalliya naa77u xeetanne ishatamu asaa tamai min haiqqidosona. Yaatin eti asi be7idi duuxxiyo malaata gididosona. ");
INSERT INTO wal_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","SHin Qoraaha attuma naati he gallassi haiqqibookkona. ");
INSERT INTO wal_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simoona zareti bantta yaran yaran: Nemu7eela yarata, Yaamiina yarata, Yaakiina yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zaraaha yaratanne SHaa7ula yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Hageeti Simoona zareta; eti muleera 22,200. ");
INSERT INTO wal_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gaada zareti bantta yaran yaran: Xafoona yarata, Hagga yarata, SHuuna yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Oozina yarata, Eera yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arooda yaratanne Ar77eela yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Hageeti Gaada zareta; eti muleera 40,500. ");
INSERT INTO wal_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yihudaa attuma naati Eeranne Oonaana; shin eti Kanaane biittan haiqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yihudaa zareti bantta yaran yaran: SHeela yarata, Paareesa yaratanne Zaraaha yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Paareesa zareti Hexiroona yaratanne Hamuula yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Hageeti Yihudaa zareta; eti muleera 76,500. ");
INSERT INTO wal_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Yisaakoora zareti bantta yaran yaran: Tolaa7a yarata, Puuwa yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaashuuba yaratanne SHimiroona yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Hageeti Yisaakoora zareta; eti muleera 64,300. ");
INSERT INTO wal_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zaabiloona zareti bantta yaran yaran: Sereeda yarata, Eloona yaratanne Yaahila7eela yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Hageeti Zaabiloona zareta; eti muleera 60,500. ");
INSERT INTO wal_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Minaasenne Efireema aawaa Yooseefa zareti hagaappe kaallidi xaafettidosona. ");
INSERT INTO wal_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Minaase zareti Minaase na7aa Maakiira yarata, Maakiira na7aa Gala7aade yaratanne Gala7aade naatu yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gala7aade zareti I7eezera yarata, Heleeqa yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asiri7eela yarata, SHekeema yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","SHamidaa7a yaratanne Hefeera yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefeera na7ai Xalofihaadi macca naatu xalaalaa yeliis; ayyo attuma na7i baawa. Xalofihaada macca naatu sunttai Maahilo, No7o, Hoogilo, Milkkonne Tirxxo. ");
INSERT INTO wal_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hageeti Minaase zareta; eti muleera 52,700. ");
INSERT INTO wal_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efireema zareti bantta yaran yaran: SHutelaaha yarata, Bekeera yarata, Tahaana yaratanne ");
INSERT INTO wal_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","SHutelaaha na7aa Eraana yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Hageeti Efireema zareta; eti muleera 32,500. Yooseefa zareti bantta yaran yaran hegeeta. ");
INSERT INTO wal_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Biniyaama zareti bantta yaran yaran: Belaa7a yarata, Ashibeela yarata, Ahiraama yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","SHafufaama yarata, Hufaama yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belaa7a na7aa Arada yaratanne Belaa7a na7aa Naa7imaana yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Hageeti Biniyaama zareta; eti muleera 45,600. ");
INSERT INTO wal_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Daana zareti SHuhaama yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","SHuhaama yarati muleera 64,400. ");
INSERT INTO wal_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aseera zareti bantta yaran yaran: Yimina yarata, Yishiwaaha yarata, Barii7a yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Barii7a na7aa Hebeera yaratanne Barii7a na7aa Malkki7eela yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aseerau Seraaho giyo macca na7iyaa de7ausu. ");
INSERT INTO wal_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Hageeti Aseera zareta; eti muleera 53,400. ");
INSERT INTO wal_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nifttaaleema zareti bantta yaran yaran: Yaa7izi7eela yarata, Guuna yarata, ");
INSERT INTO wal_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yexeera yaratanne SHilleema yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Hageeti Nifttaaleema zareta; eti muleera 45,400. ");
INSERT INTO wal_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Qoodettida Israa7eela attuma asai muleera 601,730. ");
INSERT INTO wal_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Qassikka GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ha zaretuyyo eta sunttaa sunttaa qoodaadan biittai shaahettidi, laata gididi etau imetto. ");
INSERT INTO wal_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Qoodan coratuyyo eta coratettaa keenaa, qoodan guuttatuyyo eta guuttatettaa keenaa shaakkada imma. Ubbaikka xaafettida bantta qoodaa keenaa keenaa ekkona. ");
INSERT INTO wal_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","SHin biittai saaman shaahetto; issi issi zaree laattiyo biittai eta aawaa zariyaa sunttaadan gido. ");
INSERT INTO wal_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Laata ubbai qoodan coratuppenne qoodan guuttatuppe gidduwan saaman shaahetto” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Bantta yaran yaran qoodettida Leewati hageeta: Gershshoona yarata, Qahaata yaratanne Maraara yarata. ");
INSERT INTO wal_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Hageetikka qassi Leewatu yarata: Liibina yarata, Kebroona yarata, Maahila yarata, Musha yaratanne Qoraaha yarata. Qahaati Amiraama yeliis. ");
INSERT INTO wal_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amiraama keettaayee sunttai Yokebeedo; a Gibxxen Leewayyo yelettida na7iyo. A Amiraamayyo Aaroona, Muusanne eta michchiyo Miiriyaamo yelaasu. ");
INSERT INTO wal_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aarooni Nadaaba, Abiiha, El77aazaranne Itaamaara yeliis. ");
INSERT INTO wal_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","SHin GODAI azazibeenna tamaa a sinttan yarshshido wode, Nadaabinne Abiihu haiqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Yelettoosappe issi aginanne hegaappe bollaara de7iya qoodettida attuma Leewati muleera laatamanne heezzu sha7a. Israa7eelatu gidduwan etau laattiyo biittai imettibeenna gishshau, eti Israa7eelatuura qoodettibookkona. ");
INSERT INTO wal_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Yorddaanoosa SHaafaappe hefintta baggaara, Yarkko matan, Moo7aaba Dembban Muuseenne qeesee El77aazari Israa7eelata qoodido wode, qoodettida asai hagaa. ");
INSERT INTO wal_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Muuseenne qeesee Aarooni kase Siinaa Bazzuwan Israa7eelata qoodido wode, qoodettida asaappe harai atto mexi issi asinne attibeenna. ");
INSERT INTO wal_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Aissi giikko, GODAI he Israa7eelatubaa odiiddi, “Eti bazzuwan tumu haiqqana” yaagi wottiis. Yifune na7aa Kaaleebappenne Nawe na7aa Yaasuppe attin, harai issi asinne attibeenna. ");
INSERT INTO wal_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Xalofihaada macca naati Maahilo, No7o, Hoogilo, Milkkonne Tirxxo. Xalofihaadi Hefeera na7aa; Hefeeri Gala7aade na7aa; Gala7aadee Maakira na7aa; Maakiri Minaase na7aa; Minaasee Yooseefa na7aa. ");
INSERT INTO wal_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ha macca naati Xoossaa Dunkkaaniyaa penggen Muuse sinttan, qeesiyaa El77aazara sinttan, halaqatu sinttaaninne maabaraa ubbaa sinttan eqqidi, hagaadan yaagidosona; ");
INSERT INTO wal_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nu aawai bazzuwan haiqqiis; i ba nagaran haiqqiisippe attin, GODAA bolli denddida Qoraaha kaalliyaageetu giddon de7enna. Ayyo attuma na7i baawa. ");
INSERT INTO wal_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Attuma na7i ayyo bainnabaa gidikkonne, nu aawaa sunttai a dabbotu gidduwaappe aissi xayii? Nu aawaa ishanttu giddon nuuyyo laattiyo biittaa imma” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Yaagin Muusee eta oishaa GODAA sintti shiishshiis. ");
INSERT INTO wal_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","SHiishshin GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Xalofihaada macca naati oichchidoogee likke; eta aawaa ishanttu giddon neeni etayyo laattiyo biittaa imma; a laatai eta gakko. ");
INSERT INTO wal_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Qassi neeni Israa7eelata hagaadan yaaga; ‘Issi asi attuma na7i bainnan haiqqiyaabaa gidikko, a biittaa a macca na7i laatto; ");
INSERT INTO wal_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","macca na7ikka ayyo bainnabaa gidikko, a biittaa a ishantti laattona; ");
INSERT INTO wal_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ayyo ishantti bainnabaa gidikko, a aawaa ishantti laattona; ");
INSERT INTO wal_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","a aawaa ishanttikka bainnabaa gidikko, a zariyaappe ubbaappe matattiya dabbuwaa laatissa. Taani GODAI nena Muusa azazidoogaadan, hagee Israa7eelatuyyo higge gido’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Hegaappe guyyiyan, GODAI Muusa, “Pude Abaarima Dereta kiyada, taani Israa7eela asaayyo immido biittaa be7a. ");
INSERT INTO wal_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Be7idoogaappe guyyiyan, ne ishaa Aaroonadan neenikka haiqqada, ne maizzan gaittana. ");
INSERT INTO wal_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Aissi giikko, Xiina Bazzuwan de7iya haattan asai ubbai makkalido wode, intte naa77aikka eta sinttan tana geeshshadan bonchchanau taayyo azazettibeekketa” yaagiis. Hegee haattai Xiina Bazzuwan, Qaadeesan de7iya Mariiba haattaa. ");
INSERT INTO wal_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Muusee GODAA hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","“Abeet GODAU, asa ubbau de7uwaa immiya Xoossau, ne asai, GODAA asai henttanchchi bainna wude mala gidennaadan, ha asaa sinttan kiyiyaanne geliya, etakka kaalettidi kessiyaanne gelissiya, issi asa ha maabaraa bolli sunttarkkii” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yaagin GODAI Muusa, “Ayyaanai an de7iyo Nawe na7aa Yaasa ekkada, ne kushiyaa a bolli wotta; ");
INSERT INTO wal_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","yaatada qeesiyaa El77aazara sinttaaninne maabara ubbaa sinttan essada, eti be7ishin suntta. ");
INSERT INTO wal_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Israa7eelatu maabara ubbai ayyo azazettanaadan, ne maataappe ayyo shaakkada imma. ");
INSERT INTO wal_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Immin qeesiyaa El77aazara sinttan i eqqo; eqqin El77aazari Uriimiyan ayyo GODAA sheniyaa oichcho. Yaasunne Israa7eela maabarai ubbai El77aazara azazuwan kiyonanne a azazuwan gelona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","GODAI azazidoogaadan Muusee oottiis; Yaasa efiidi, qeesiyaa El77aazara sinttaaninne maabaraa ubbaa sinttan essiis. ");
INSERT INTO wal_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","GODAI azazidoogaadan, Muusee ba kushiyaa a bolli wottidi, a sunttiis. ");
INSERT INTO wal_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Israa7eelata hagaadan yaagada azaza; ‘Ta qumaa, tana tonggu giidi sawana mala, taman yarshshiyo ta yarshshuwaa keerido wodiyan wodiyan taayyo naagidi immite’ yaaga. ");
INSERT INTO wal_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Qassi neeni eta, ‘GODAAYYO taman yarshshiyo yarshshoi hagaa: tilla bollaara de7iya, issi laitta gidido naa77u dorssa orggeta hachchi hachchi xuuggiyo yarshshuwaayyo yarshshite; ");
INSERT INTO wal_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","dorssa orggetuppe issuwaa maallado, naa77anttuwaa omarssi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Qassi hegaara issi litiro gidiya zaitiyan munaqettida issi kilo giraame muruta gisttiyaa xiilliyaa kattaa yarshshuwaassi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Hagee GODAA tonggu giidi sawana mala, Siinaa Deriyaa bollan azazettida, hachchi hachchi taman xuuggiyo yarshsho. ");
INSERT INTO wal_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Hegaara yarshshiyo ushshaa yarshshoi issi dorssa orggiyaayyo issi litiro gidiya woine eessa. Ushshaa yarshshuwaa Geeshsha Sohuwan GODAAYYO gussite. ");
INSERT INTO wal_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Omarssi naa77antto dorssa orggiyaa, maalladoogaa oottidoogaadan oottidi, kattaa yarshshuwaaranne ushshaa yarshshuwaara GODAA tonggu giidi sawana mala, taman yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘Sambbata gallassan, tilla bollaara de7iya issi laitta gidido naa77u dorssaanne zaitiyan munaqettida naa77u kilo giraame gidiya muruta xiilliyaa kattaa yarshshonne ushshaa yarshsho oottidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Hachchi hachchi xuuggiyo yarshshuwaanne a ushshaa yarshshuwaa bolli, Sambbata gallassa ubban intte yarshshiyo xuuggiyo yarshshoi hagaa. ");
INSERT INTO wal_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘Aginai xeeriyo gallassa ubban, naa77u mirggota, issi dorssa orggiyaanne issi laitta gidido laappun dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, xuuggiyo yarshsho oottidi, GODAAYYO yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Issi issi mirgguwaara zaitiyan munaqettida heezzu kilo giraame gidiya muruta gisttiyaa xiilliyaa, issi dorssa orggiyaara zaitiyan munaqettida naa77u kilo giraame gidiya muruta gisttiyaa xiilliyaanne ");
INSERT INTO wal_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","laappun dorssa maratuppe issi issi dorssa maraara zaitiyan munaqettida issi kilo giraame gidiya muruta gisttiyaa xiilliyaa kattaa yarshsho oottidi, GODAA tonggu giidi sawana mala, taman yarshshiyo yarshshuwaa yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Qassi ushshaa yarshshuwaayyo issi issi mirgguwaara naa77u litiro gidiya woine eessaa, issi dorssa orggiyaara issi litironne bagga woine eessaanne issi issi dorssa maraara issi litiro gidiya woine eessaa shiishshite. Hagee laittaa giddon aginai xeeriyo gallassa ubban yarshshiyo xuuggiyo yarshsho. ");
INSERT INTO wal_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Hachchi hachchi xuuggiyo yarshshuwaanne a ushshaa yarshshuwaa bolli, issi deeshsha orggiyaa nagaraa yarshsho oottidi, GODAAYYO yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘Koiro aginan tammanne oiddantta gallassai GODAA Paasikaa bonchchiyo gallassa gido. ");
INSERT INTO wal_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Qassi he aginankka tammanne ichchashantta gallassan doommidi, Oittaa Baalai bonchchettees; hegaa gishshau, laappun gallassatun irshshoi gelibeenna oittaa miite. ");
INSERT INTO wal_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","He gallassatuppe koiro gallassan geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. ");
INSERT INTO wal_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Naa77u mirggota, issi dorssa orggiyaanne issi laitta gidido laappun dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, taman yarshshiyo yarshsho oottidi, GODAAYYO yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Kattaa yarshshuwaayyo issi mirgguwaara zaitiyan munaqettida heezzu kilo giraame gidiya muruta gisttiyaa xiilliyaa, issi dorssa orggiyaara naa77u kilo giraame gidiya xiilliyaanne ");
INSERT INTO wal_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","laappun dorssa maratuppe issi issi maraara issi kilo giraame xiilliyaa yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Qassi issi deeshsha orggiyaa nagaraa yarshshuwaassi, intte nagaraa atto giissanau yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","24","Hachchi hachchi maallado xuuggiyo yarshshuwaanne a kattaa yarshshuwaa bolli, sawuwaa tonggu giya qumaa taman yarshshiyo yarshshuwaa gujjidi, GODAAYYO yarshshite. Laappun gallassaayyo hegaadan oottite. ");
INSERT INTO wal_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Laappuntta gallassan qassi geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. ");
INSERT INTO wal_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘Saaminttatu Baalaa gallassan intte GODAAYYO ooratta kattaa shiishshiyo wode, geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. ");
INSERT INTO wal_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Naa77u mirggota, issi dorssa orggiyaanne issi laitta gidido laappun dorssa orggeta sawuwaa tonggu giya xuuggiyo yarshsho oottidi, GODAAYYO yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Issi issi mirgguwaara zaitiyan munaqettida heezzu kilo giraame gidiya muruta gisttiyaa xiilliyaa, issi dorssa orggiyaara naa77u kilo giraame xiilliyaanne ");
INSERT INTO wal_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","laappun dorssa maratuppe issi issi maraara issi kilo giraame xiilliyaa kattaa yarshshuwaayyo yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Qassi issi deeshsha orggiyaa nagaraa atto giissiyo yarshsho oottidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Hachchi hachchi xuuggiyo yarshshuwaanne a ushshaa yarshshuwaa bolli, hageeta eta kattaa yarshshuwaara yarshshite. Meheti tilla bollaara de7iyaageeta gidiyoogaa geeshshidi erite. ");
INSERT INTO wal_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘Laappuntta aginaayyo koiro gallassan, geeshsha yaa7aa shiiqite. Daafurssiya ooso aibanne oottoppite. He gallassai xurumbbai punettiyo gallassa. ");
INSERT INTO wal_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","GODAA sawuwaa tonggu gaana mala, xuuggiyo yarshshuwaayyo, issi mirgguwaa, issi dorssa orggiyaanne issi laitta gidido laappun dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Kattaa yarshshuwaayyo issi mirgguwaara zaitiyan munaqettida heezzu kilo giraame gidiya muruta gisttiyaa xiilliyaa, issi dorssa orggiyaara naa77u kilo giraame xiilliyaanne ");
INSERT INTO wal_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","laappun dorssa maratuppe issi issi maraara issi kilo giraame xiilliyaa yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Qassi issi deeshsha orggiyaa nagaraa yarshshuwaassi, intte nagaraa atto giissanau yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Hageeta aginai xeeriyo gallassan xuuggiyo yarshshuwaa bollinne a kattaa yarshshuwaa bolli, hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi, wogaadan yarshshite; hageeti GODAA sawuwaa tonggu giya, taman yarshshiyo yarshshota. ");
INSERT INTO wal_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘Ha laappuntta aginaayyo tammantta gallassan geeshsha yaa7aa shiiqite; intte huuphiyaa kaushshite; aiba oosokka oottoppite. ");
INSERT INTO wal_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Yaatidi GODAA tonggu giidi sawana mala, xuuggiyo yarshshuwaayyo issi mirgguwaa, issi dorssa orggiyaanne issi laitta gidido laappun dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Kattaa yarshshuwaayyo issi mirgguwaara zaitiyan munaqettida heezzu kilo giraame gidiya muruta gisttiyaa xiilliyaa, issi dorssa orggiyaara naa77u kilo giraame xiilliyaanne ");
INSERT INTO wal_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","laappun dorssa maratuppe issi issi maraara issi kilo giraame xiilliyaa yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hageeta nagaraa atto giissiyo yarshshuwaa bolli, hachchi hachchi xuuggiyo yarshshuwaa bolli, eta kattaa yarshshuwaa bollinne eta ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘Laappuntta aginan tammanne ichchashantta gallassan, geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. GODAAYYO Daase Baalaa laappun gallassaa bonchchite. ");
INSERT INTO wal_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","GODAA tonggu giidi sawana mala, taman yarshshiyo tammanne heezzu mirggota, naa77u dorssa orggetanne issi laitta gidido tammanne oiddu dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Kattaa yarshshuwaayyo tammanne heezzu mirggotuppe issi issi mirgguwaara zaitiyan munaqettida heezzu kilo giraame gidiya muruta gisttiyaa xiilliyaa, naa77u dorssa orggetuppe issi issi orggiyaara naa77u kilo giraame xiilliyaanne ");
INSERT INTO wal_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","tammanne oiddu dorssa maratuppe issi issi maraara issi kilo giraame xiilliyaa yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hageeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘Naa77antta gallassan tammanne naa77u mirggota, naa77u dorssa orggetanne issi laitta gidido tammanne oiddu dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Mirggotuura, dorssa orggetuuranne dorssa maratuura, eta kattaa yarshshuwaanne eta ushshaa yarshshuwaa wogai azaziyo qoodaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hageeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘Heezzantta gallassan, tammanne isiini mirggota, naa77u dorssa orggetanne issi laitta gidido tammanne oiddu dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Mirggotuura, dorssa orggetuuranne dorssa maratuura, eta kattaa yarshshuwaanne eta ushshaa yarshshuwaa wogai azaziyo qoodaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hageeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘Oiddantta gallassan, tammu mirggota, naa77u dorssa orggetanne issi laitta gidido tammanne oiddu dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Mirggotuura, dorssa orggetuuranne dorssa maratuura, eta kattaa yarshshuwaanne eta ushshaa yarshshuwaa wogai azaziyo qoodaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hegeeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘Ichchashantta gallassan, uddufun mirggota, naa77u dorssa orggetanne, issi laitta gidido tammanne oiddu dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Mirggotuura, dorssa orggetuuranne dorssa maratuura eta kattaa yarshshuwaanne eta ushshaa yarshshuwaa wogai azaziyo qoodaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hageeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘Usuppuntta gallassan, hosppun mirggota, naa77u dorssa orggetanne issi laitta gidido tammanne oiddu dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Mirggotuura, dorssa orggetuuranne dorssa maratuura eta kattaa yarshshuwaanne eta ushshaa yarshshuwaa wogai azaziyo qoodaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hegeeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘Laappuntta gallassan, laappun mirggota, naa77u dorssa orggetanne issi laitta gidido tammanne oiddu dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Mirggotuura, dorssa orggetuuranne dorssa maratuura eta kattaa yarshshuwaanne eta ushshaa yarshshuwaa wogai azaziyo qoodaadan yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hegeeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘Hosppuntta gallassan geeshsha yaa7aa shiiqite; daafurssiya ooso aibanne oottoppite. ");
INSERT INTO wal_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Taman yarshshiyo yarshshoi GODAA tonggu giidi sawana mala, issi mirgguwaa, issi dorssa orggiyaanne issi laitta gidido laappun dorssa orggeta, ubbaikka tilla bollaara de7iyaageeta, yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Mirgguwaara, dorssa orggiyaaranne dorssa maratuura eta kattaa yarshshuwaanne eta ushshaa yarshshuwaa wogai azaziyo qoodaadan shiishshite. ");
INSERT INTO wal_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Qassi nagaraa yarshshuwaayyo issi deeshsha orggiyaa yarshshite. Hegeeta hachchi hachchi xuuggiyo yarshshuwaa bolli, a kattaa yarshshuwaa bollinne a ushshaa yarshshuwaa bolli gujjidi yarshshite. ");
INSERT INTO wal_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘Intte shiiquwaa gattanau yarshshiyo yarshshotu bollinne intte intte dosan coo immiyo yarshshotu bolli, xuuggiyo yarshshuwaa, kattaa yarshshuwaa, ushshaa yarshshuwaanne issippetettaa yarshshuwaa, hageeta GODAA baalaa intte bonchchanau keerido wodiyan wodiyan yarshshite’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Yaagin Muusee bana GODAI azazidobaa ubbaa Israa7eelatuyyo yootiis. ");
INSERT INTO wal_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Muusee Israa7eela zaretu halaqata hagaadan yaagiis; “GODAI azaziyoogee hagaa. ");
INSERT INTO wal_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Issi asi GODAAYYO issibaa oottanau geppikko, woikko issibaa agganau caaqqikko, ba doonaappe kessidobaa ubbaa poloppe attin, ba qaalaa birshshoppo. ");
INSERT INTO wal_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Ba aawaa son de7iya geela7o na7iyaa, GODAAYYO issibaa oottanau geppikko, woikko issibaa agganau caaqqikko, ");
INSERT INTO wal_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","i aawai i gefaabaa woikko i caaquwaabaa siyidi, o ainne geennan aggikko, a oottanau geppidobaa ubbaanne agganau caaqqidobaa ubbaa polu. ");
INSERT INTO wal_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","SHin i aawai hegaa siyidi phalqqikko, a geppido gefainne agganau caaqqido caaqoi polettennan attees. I aawai o diggido gishshau, GODAI iyyo atto gaana. ");
INSERT INTO wal_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Gelabeenna maccaara geppa uttada, woikko issibaa agganau eesuwan ba doonaappe caaqqa uttada azina gelikko, ");
INSERT INTO wal_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","i azinai hegaa siyidi, o ainne geennan aggikko, a oottanau geppido gefaanne issibaa agganau caaqqido caaquwaa polu. ");
INSERT INTO wal_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","SHin i azinai hegaa siyidi phalqqikko, a geppido gefai woikko issibaa agganau eesuwan caaqqido caaqoi polettennan attees. Hegaa gishshau, GODAI iyyo atto gaana. ");
INSERT INTO wal_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“SHin am77iyaa woikko azinai yeddido maccaasiyaa oottanau geppidobaa woikko issibaa agganau caaqqidobaa polu. ");
INSERT INTO wal_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Maccaasiyaa ba azinaa son de7aidda geppikko, woikko issibaa agganau caaquwaa caaqqikko, ");
INSERT INTO wal_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","i azinai hegaa siyidi o ainne geennan aggikko, a geppido gefaanne issibaa agganau caaqqido caaquwaa ubbaa polu. ");
INSERT INTO wal_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","SHin i azinai hegaa siyidi phalqqikko, i gefai woikko a agganau caaqqido caaqoi aibinne polettoppo. I azinai diggido gishshau, GODAI iyyo atto gaana. ");
INSERT INTO wal_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","I azinai a geppiyo gefaa ubbaa woikko a bana ziqqi oottanau caaqqidobaa ubbaa phalqqanau woikko maayanau danddayees. ");
INSERT INTO wal_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","SHin i azinai he gallassi woikko wonttetta gallassi hegaabaa ainne geennan aggikko, i i gefaa ubbaa woikko i caaquwaa ubbaa maayees. I hegaa siyido gallassi co77u giidoogaadan i gefa ubbaa woikko i caaquwaa ubbaa maayi uttiis. ");
INSERT INTO wal_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","SHin i hegaa siyido amarida wodiyaappe guyyiyan phalqqikko, i gomee a gakkees” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Azina gelabeenna, ba aawaa son de7iya geela7o na7eenne i aawaa gidduwan woikko keettaayeenne keettaawaa gidduwan de7ana mala, GODAI Muusa azazido gefaa wogai hagaa. ");
INSERT INTO wal_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","GODAI Muusa, ");
INSERT INTO wal_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Israa7eela asaa gishshau, neeni Midiyaama asaa bolli GODAA haluwaa kiya; hegaappe guyyiyan, neeni haiqqana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Hegaa gishshau, Muusee asaa, “Midiyaama asaa bolli GODAA haluwaa kessana mala olaa baanau, intte asaa ola miishshaa gixissite. ");
INSERT INTO wal_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Issi issi Israa7eela zaretuppe issi sha7u attuma asaa olau yeddite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Yaagin Israa7eelappe tammanne naa77u sha7u attuma asai, issi issi zariyaappe issi sha7u asai, olau giigidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Issi issi zariyaappe issi sha7u asaa Muusee qeesiyaa El77aazara na7aa Piinihaasaara olau yeddiis; yeddin Piinihaasi geeshsha miishshatanne malaatau punniyo xurumbbaa banaara ekkidi biis. ");
INSERT INTO wal_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","GODAI Muusa azazidoogaadan, eti Midiyaama asaara olettiiddi, attuma asaa ubbaa woridosona. ");
INSERT INTO wal_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Qassi Midiyaama kawota ichchashata, Eewa, Reqeema, Xuura, Huuranne Rebaa7a giyoogeeta woridosona. Eti qassi Bi7oora na7aa Balaamakka bisuwan siifidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Israa7eelati Midiyaama maccaasatanne naata omooddidi, eta miizzaa, eta dorssaa wudiyaanne eta miishsha ubbaa bonqqidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Midiyaama asati de7ido katamata ubbaanne eta moottata ubbaa taman xuuggidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Eti asaa, mehiyaanne omooddidobaa ubbaa ekki efiidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Eti omooddido asatanne bonqqidobata Muusekko, qeesiyaa El77aazarakkonne Israa7eela maabaraakko, Yarkkoppe hefinttan, Yorddaanoosa SHaafaa matan de7iya Moo7aaba Dembban eti dunkkaanidosaa ehiidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Muusee, qeesee El77aazarinne maabaraa halaqati ubbai dunkkaanidosaappe gaxi etaara gaittanau kiyidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Olaappe simmida gadaawatu bolli, shaalaqatu bollinne mato halaqatu bolli Muusee hanqqettiis. ");
INSERT INTO wal_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Muusee eta hagaadan yaagiis; “Maccaasa ubbaa intte aissi ashshidetii? ");
INSERT INTO wal_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Eti Balaama zoriyan, Pa7oora giyoosan Israa7eela asai GODAA naaqqidi, eeqau goinnanaadan oottidaageeta; GODAA asaa bolli boshai yiidoogee hegaassa. ");
INSERT INTO wal_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Hegaa gishshau, ha77i attuma naata ubbaa worite; qassi attuma asaara zin77ida maccaasa ubbaa worite. ");
INSERT INTO wal_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","SHin attuma asaara zin77ibeenna macca naata ubbaa intteyyo ashshite. ");
INSERT INTO wal_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Intte giddoppe asa worida uri woikko ahaa bochchida uri ooninne dunkkaanidosaappe gaxan laappun gallassaa utto; heezzantta gallassinne laappuntta gallassi inttenanne intte omooddidoogeeta geeshshite. ");
INSERT INTO wal_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Qassi maayo ubbaanne galbbappe, deeshsha ikiseppenne mittappe oosettidabata ubbaa geeshshite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Yaagin qeesee El77aazari olaappe simmida olanchchata hagaadan yaagiis; “GODAI Muuseyyo immido higgiyaa maarai hagaa: ");
INSERT INTO wal_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Worqqaa, biraa, nahaasiyaa, birataa, qorqqoruwaanne irssaasiyaa giyo birataa ");
INSERT INTO wal_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","taman meetettennabata ubbaa tama giddoora aattin, hegee geeyana. SHin hegee qassi tunatettaappe geeyiyo haattan geeyanau koshshees. Qassi taman meetettiyaabata ubbaa tunatettaappe geeyiyo haattan geeshshanau koshshees. ");
INSERT INTO wal_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Laappuntta gallassi intte maayuwaa meeccite; meeccidi inttekka geeyite. Hegaappe guyyiyan, dunkkaanidosaa gelite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Neeni, qeesee El77aazarinne maabaraa halaqati omoodettida asaanne mehiyaa ubbaa qoodite. ");
INSERT INTO wal_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Qoodidi olan olettida olanchchatuyyoonne attida maabaraayyo naa77u kessidi shaakkite. ");
INSERT INTO wal_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Olettida olanchchata gakkida shaahuwaappe, asa gidin, miizza gidin, hareta, dorssata woikko deeshshata gidin, ichchashu xeetaappe issuwaa GODAAYYO giiraa giirite. ");
INSERT INTO wal_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Eta gakkida baggaappe ekkido giiraa GODAA gishshaadan qeesiyaa El77aazarayyo immite. ");
INSERT INTO wal_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Hinkko Israa7eelata gakkida shaahuwaappe, asa gidin, miizza gidin, hareta, dorssata, woikko deeshshata gidin, mehetu ubbaappe ishatamaappe issuwaa ekkite; ekkidi hegaa GODAA Dunkkaaniyau aawatiya Leewatuyyo immite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Yaagin Muuseenne qeesee El77aazari GODAI azazidoogaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","Olanchchati banttayyo ekkin, attida omoodoi 675,000 dorssata, 72,000 miizzata, 61,000 haretanne attuma asaara zin77ibeenna 32,000 macca naata. ");
INSERT INTO wal_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Olan olettidaageeta gakkida shaahoi 337,500 dorssata; ");
INSERT INTO wal_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","etappe GODAASSI giirau kessidoogeeti 675. ");
INSERT INTO wal_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Miizzati 36,000; etappe GODAASSI giirau kessidoogeeti 72. ");
INSERT INTO wal_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Hareti 30,500; etappe GODAASSI giirau kessidoogeeti 61. ");
INSERT INTO wal_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Maccaasati 16,000; etappe GODAASSI giirau kessidoogeeti 32. ");
INSERT INTO wal_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","GODAI Muusa azazidoogaadan, GODAA gakkiya giiraa Muusee qeesiyaa El77aazarayyo immiis. ");
INSERT INTO wal_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","Olanchchati ehiido omooduwaa Muusee naa77u kessidi shaakkin, Israa7eela maabaraa gakkida shaahoi 337,500 dorssata, 36,000 miizzata, 30,500 haretanne 16,000 maccaasata. ");
INSERT INTO wal_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Israa7eela maabaraa gakkida shaahuwaappe ishatamu ishatamu asaappe issuwaanne ishatamu ishatamu mehiyaappe issuwaa Muusee ekkidi, GODAI bana azazidoogaadan, Xoossaa Dunkkaaniyau aawatiya Leewatuyyo immiis. ");
INSERT INTO wal_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Hegaappe guyyiyan, ola gadaawati, shaalaqatinne mato halaqati Muusekko yiidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Yiidi eti Muusa, “Nuuni ne ashkkarati nu azazuwaa garssan de7iya olanchchata qoodin, issoinne paccibeenna. ");
INSERT INTO wal_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","GODAI nu shemppuwaa ashshido gishshau, nuuni huuphiyan huuphiyan ekkido worqqa alleeqota, kushe sagaayota, toho albbota, migidota, haitta gutichchatanne qooriyan aattiyo gujjumata GODAAYYO imuwaa ehiida” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Muuseenne qeesee El77aazari worqqa alleeqota ubbaa etappe ekkidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","SHaalaqatinne mato halaqati ehiidi GODAAYYO immido worqqai ubbai naa77u xeetu kilo giraame gidiyaagaa. ");
INSERT INTO wal_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","SHin hara olanchchati ubbai bantta omooduwaa omooduwaa banttau ekkidosona. ");
INSERT INTO wal_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Muuseenne qeesee El77aazari shaalaqatuppenne mato halaqatuppe ekkido worqqaa GODAA sinttan Israa7eela asaa hassayissana mala, Xoossaa Dunkkaaniyaa giddo gelissidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Roobeela zaretuyyoonne Gaada zaretuyyo keehi daro mehee de7ees. Eti Yaa7izeera biittainne Gala7aade biittai meheyyo injje gidiyoogaa be7idosona. ");
INSERT INTO wal_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Be7idi eti Muusekko, qeesiyaa El77aazarakkonne maabaraa halaqatukko yiidi, eta hagaadan yaagidosona; ");
INSERT INTO wal_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“GODAI Israa7eela asan xoonissido biittati, Axaarooti, Dibooni, Yaa7izeeri, Niimiri, Hasebooni, Eli7aali, Seebimi, Naboinne Ba7ooni mehiyaayyo injje biitta; nuuyyo intte ashkkaratuyyo mehee de7ees. ");
INSERT INTO wal_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Nuuni inttena ufaissidabaa gidikko, ha biittati nuussi intte ashkkaratussi laata gade gididi imettona. Nuna Yorddaanoosa SHaafaa hefintti pinttoppite” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Yaagin Muusee Gaada zaretanne Roobeela zareta hagaadan yaagiis; “Hara Israa7eela asai olaa biyo wode, intte hagan uttuuteetii? ");
INSERT INTO wal_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","GODAI etayyo immido biittaa Israa7eelati pinnennaadan, intte aibissi eta wozanaa shugisseetii? ");
INSERT INTO wal_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Qaadeesa Barnneppe he biittaa wochchi xeellanau intte aawata taani yeddido wode, etikka hagaadan oottidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Waanidi giikko, eti Eshkkoola Zanggaaraa kiyidi, he biittaa xeellido wode, Israa7eelati GODAI etayyo immido biittaa gelenna mala, eti Israa7eelatu wozanaa shugissidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","GODAI he gallassi hanqquwaa eexxi kiyidi, hagaadan yaagidi caaqqiis; ");
INSERT INTO wal_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","12","‘GODAA bantta kumetta wozanaappe kaallida Qeniiziyaa Yifune na7aa Kaaleebappenne Nawe na7aa Yaasuppe attin, yelettoosappe laatamu laittanne hegaappe bollaara de7iya attuma asan Gibxxe biittaappe kiyidaageetuppe issoinne, taani Abrahaamayyo, Yisaaqayyoonne Yaaqoobayyo immanau caaqqido biittaa be7enna. Aissi giikko, eti tana bantta kumetta wozanaappe kaallibookkona’ yaagidi caaqqiis. ");
INSERT INTO wal_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","GODAA hanqqoi Israa7eela bolli eexxi kiyiis; yaatin GODAA sinttan iitaa oottida he yeleta ubbai wuri xayana gakkanaassi, bazzuwan oitamu laittaa i eta toilayiis. ");
INSERT INTO wal_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Inttenoo, nagaranchcha yeletatoo, GODAI Israa7eela bolli gujji hanqquwaa eexxi kiyanaadan, intte intte aawatu sohuwan ha77i eqqideta. ");
INSERT INTO wal_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Intte GODAA kaalliyoogaa aggidi wora simmikko, i qassikka ba asaa bazzuwan aggi bayana. Yaatidi intte ha asaa ubbaa xaissana” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Yaagin eti Muuse mati yiidi, a hagaadan yaagidosona; “Nuuni hagan nu mehetuyyo dirssaa, nu naatuyyo katamata keexxana. ");
INSERT INTO wal_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","SHin nuuni ola miishshaa gixxidi, Israa7eela asaa eta sohuwaa gattana gakkanaashin olettanau baana. Hegaa keenan, ha biittan de7iya asatuppe naagettanau, nu naati gimbbettidi uttida katamatun de7ona. ");
INSERT INTO wal_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Israa7eelati ubbai bantta laataa laataa ekkana gakkanaassi, nuuni nu soo simmokko. ");
INSERT INTO wal_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Nuuni nu laataa Yorddaanoosa SHaafaappe hafintta arshsho baggaara laattido gishshau, nuuni Yorddaanoosappe hefintta baggaara, yan etaara laataa laattokko” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Yaagin Muusee eta, “Intte hagaa oottikko, intte GODAA sinttan olaa baanau giigikkonne ");
INSERT INTO wal_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","intte olanchchati ubbai ola miishshaa gixxidi, GODAI ba morkketa ba sinttaappe yedettana gakkanaassi, Yorddaanoosa SHaafaa GODAA sinttan pinnikko, ");
INSERT INTO wal_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","GODAI he biittaa xoonidoogaappe guyyiyan, intte simmanau danddayeeta. Yaatikko, intte olettanau bessiya olaa GODAAYYOONNE Israa7eela asaayyo olettidi polideta giyoogaa. Qassi he biittai GODAA sinttan intteyyo laata biittaa gidana. ");
INSERT INTO wal_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“SHin intte hegaadan oottennan ixxikko, GODAA bolli nagaraa ootteeta; simmi inttena intte nagarai gakkiyoogaa tumu erite. ");
INSERT INTO wal_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Intte intte naatuyyo katamata keexxite; intte dorssaa wudiyaayyookka birddeta giigissite; shin intte giidobaa aggennan oottite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Yaagin Gaada zaretinne Roobeela zareti Muusa, “Nuuni ne ashkkarati neeni nu godai azazidoogaadan oottana. ");
INSERT INTO wal_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nu naatinne nu maccaasati, nu dorssatinne nu miizzati hagan Gala7aade katamatun de7ishshona. ");
INSERT INTO wal_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","SHin nuuni ne ashkkarati, olau gixxida olanchchati ubbai, neeni nu godai giyoogaadan, olettanau GODAA sinttan Yorddaanoosa SHaafaa pinnana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Hegaa gishshau, Muusee qeesiyaa El77aazara, Nawe na7aa Yaasanne Israa7eela zaretu halaqata etabaa azaziis. ");
INSERT INTO wal_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Muusee eta hagaadan yaagiis; “Gaada zaretinne Roobeela zareti ubbai ola miishshaa gixxidi, GODAA sinttan inttenaara Yorddaanoosa SHaafaa pinnikkonne intte he biittaa xoonikko, hegaappe guyyiyan, Gala7aade biittaa intte eta laatissite. ");
INSERT INTO wal_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","SHin eti olaa miishshaa gixxidi, inttenaara pinnennan ixxikko, eti Kanaane biittaa inttenaara laattona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Yaagin Gaada zaretinne Roobeela zareti zaaridi, “Nuuni ne ashkkarati GODAI giidoogaa oottana. ");
INSERT INTO wal_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ola miishshaa gixxidi, GODAA sinttan nuuni Kanaane biittaa gelanau pinnana; shin nuuni laattiyo laatai Yorddaanoosappe hafintta baggaara gidana” yaagidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Hegaa gishshau, Muusee Gaada zaretuyyo, Roobeela zaretuyyoonne Yooseefa na7aa Minaase zaretuppe baggaayyo Amooretu Kawuwaa Sihoona kawotettaanne Baasaane Kawuwaa Ooga kawotettaa, eta giddon de7iya katamatuura immiis. ");
INSERT INTO wal_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gaada zareti Diboona, Axaaroota, Aaro7era ");
INSERT INTO wal_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Axirooti-SHofaana, Yaa7izeera, Yogibaaha, ");
INSERT INTO wal_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beeti-Niimiranne Beeti-Haaraana geetettiya gimbbiyan direttida katamata zaarettidi keexxidosona. Bantta dorssatuyyookka eti birddeta giigissidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Roobeela zaretikka Haseboona, Eli7aala, Qiriyaataimanne, ");
INSERT INTO wal_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Naba, Ba7aali-Ma7oonanne Siibima geetettiya katamata zaaretti keexxidosona. Keexxidi he katamatuppe issootu issootu sunttaa laammidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Minaase na7aa Maakira yarati Gala7aade biidi, oli oiqqidi, yan de7iya Amooreta yedettidosona. ");
INSERT INTO wal_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Hegaa gishshau, Minaase na7aa Maakira yaratuyyo Muusee Gala7aade biittaa immin, eti yan de7idosona. ");
INSERT INTO wal_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Minaase zare gidiya Yaa7iiri biidi, eta oli oiqqidi, Yaa7iira katamata yaagidi sunttiis. ");
INSERT INTO wal_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobaahi biidi, Qanaata katamaanne a yuushuwan de7iya moottata oli oiqqidi, ba sunttan Nobaaha giidi xeesiis. ");
INSERT INTO wal_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Israa7eelati Muuseenne Aarooni kaalettin, bantta citan citan Gibxxeppe kiyido wode, yaanidi hemettidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","GODAI azazin, eti baana beettaa doommido sohota Muusee xaafiis; eta beettaa maarai hagaa. ");
INSERT INTO wal_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Koiro aginaayyo tammanne ichchashantta gallassi, Paasikaa bonchchiyo gallassaappe kaalliya gallassi denddidi, Gibxxe asai ubbai xeellishin, yayyennan Raamisappe kiyidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","He wode Gibxxe asai GODAI worido bantta baira naata moogoosona. Hagaadan oottidi, GODAI eta xoossatu bolli pirddaa ehiis. ");
INSERT INTO wal_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Israa7eelati Raamisappe denddidi, Sukkota giyo sohuwan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukkotappe denddidi, bazzuwaa xeeran de7iya Etaaman dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etaamappe denddidi, Ba7aali-Xafoonappe arshsho baggaara de7iya Pihaahiroota simmidi, Migidoola matan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Pihaahirootappe denddidi, Zo7o Abbaa pinnidi, bazzuwaa biidosona. Etaama Bazzuwan heezzu gallassa ogiyaa hemettidi, Maaran dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Maarappe denddidi, tammanne naa77u pulttotinne laappun tammu zambbati de7iyo Eliima biidi, yan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Eliimappe denddidi, Zo7o Abbaa lanqqen dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Zo7o Abbaa lanqqeppe denddidi, Siinaa Bazzuwan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Siinaa Bazzuwaappe denddidi, Doofiqan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Doofiqappe denddidi, Aluushan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Aluushappe denddidi, Rafiidiman dunkkaanidosona. Yan asaayyo uyanau haatti baawa. ");
INSERT INTO wal_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Rafiidimappe denddidi, Siinaa Bazzuwan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Siinaa Bazzuwaappe denddidi, Amuwaa Duufuwaa giyoosan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Amuwaa Duufuwaa giyoosaappe denddidi, Haxerootan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Haxerootappe denddidi, Riitiman dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Riitimappe denddidi, Rimmooni-Pereezan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rimmooni-Pereezappe denddidi, Liibinan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Liibinappe denddidi, Riissan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Riissappe denddidi, Qahelaatan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Qahelaatappe denddidi, SHefaara Deriyan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","SHefaara Deriyaappe denddidi, Haraadan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Haraadappe denddidi, Maaqihelootan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Maaqihelootappe denddidi, Tahaatan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tahaatappe denddidi, Taaran dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Taarappe denddidi, Miitiqan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Miitiqappe denddidi, Hashimoonan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Hashimoonappe denddidi, Moserootan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserootappe denddidi, Bene-Yaa7iqaanan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Bene-Yaa7iqaanappe denddidi, Hoori-Hagidigaadan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Hoori-Hagidigaadappe denddidi, Yoxibaatan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yoxibaatappe denddidi, Abroonan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Abroonappe denddidi, Eexiyooni-Gaabiran dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Eexiyooni-Gaabirappe denddidi, Xiina Bazzuwan de7iya Qaadeesan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Qaadeesappe denddidi, Eedooma biittaa zawan de7iya Hoora Deriyan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Qeesee Aarooni GODAI azazin, Hoora Deriyaa huuphiyaa kiyiis; kiyidi Israa7eelati Gibxxe biittaappe kiyido oitamantta laittan, ichchashantta aginan, aginaayyo koiro gallassan yan haiqqiis. ");
INSERT INTO wal_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aarooni Hoora Deriyaa huuphiyan haiqqiyo wode, a laittai xeetanne laatammanne heezza. ");
INSERT INTO wal_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Neegeeba Bazzuwan, Kanaanen de7iya Araada giyoosaa kawoi Israa7eela asaa yuussaa siyiis. ");
INSERT INTO wal_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Israa7eelati Hoora Deriyaappe denddidi, Xalmmoonan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Xalmmoonappe denddidi, Punoonan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punoonappe denddidi, Obootan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Obootappe denddidi, Moo7aaba biittaa zawan de7iya Abaariman dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Abaarimappe denddidi, Diboona-Gaadan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Diboona-Gaadappe denddidi, Almmoona-Dibilaataiman dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almmoona-Dibilaataimappe denddidi, Nabo Deriyaa matan Abaarima deretun dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Abaarima deretuppe denddidi, Yarkkoppe hefinttaara, Yorddaanoosa SHaafaa matan de7iya Moo7aaba Dembban dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Yorddaanoosa SHaafaa matan de7iya Moo7aaba Dembban, Beeti-Yashimootappenne SHiixima Zanggaaraappe gidduwan dunkkaanidosona. ");
INSERT INTO wal_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Yarkko hefinttaara, Yorddaanoosa SHaafaa matan de7iya Moo7aaba Dembban GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Israa7eelata neeni yaaga; ‘Yorddaanoosa SHaafaa pinnidi, Kanaane biitti intte geliyo wode, ");
INSERT INTO wal_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","he biittan de7iya asaa ubbaa intte sinttappe yedettite; yedettidi shuchchaappe masettida eta misileta ubbaanne seerissidi medhdhido eeqata ubbaa xaissite. Eti goinniyo xoqqa sohota ubbaakka laalite. ");
INSERT INTO wal_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Taani intteyyo he biittaa laatau immido gishshau, he biittaa laattidi, an de7ite. ");
INSERT INTO wal_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Intte zariyan zariyan saamaa kessidi, biittaa shaakkite. Qoodan corattiya zaretuyyo daro laataa immite; qoodan guuxxiya zaretuyyo guutta laataa immite. Saaman eta gakkida augeenne etaagaa gidana. Biittaa intte maizza aawatu zariyan zariyan shaakki ekkite. ");
INSERT INTO wal_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“‘SHin he biittan de7iya asaa intte yedettennan aggikko, intte ashshidoogeeti intteyyo intte aifiyaayyo pincco, intte miyyiyaayyo aguntta gidana; intte de7ana biittan eti inttena waayissana. ");
INSERT INTO wal_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Intte eta yedettennan aggikko, eta bolli taani oottanau halchchidobaa intte bolli oottana’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Neeni Israa7eelata hagaadan yaagada azaza; ‘Laatadan inttena gakkiya Kanaane biittaa zawai hagaa. ");
INSERT INTO wal_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Tohossa baggaara intte zawai Xiina Bazzuwaanne Eedooma zawaa gidana. Intte tohossa zawai Maxine Abbaa tohossaappe doommees; ");
INSERT INTO wal_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","doommidi Akirabiima pudettaara tohossa baggaara simmidi, Xiina Bazzuwaa kanttidi, Qaadeesa-Barnne tohossi gakkees; hegaappe Hadaari-Adaara kanttidi, Aximoona gakkees. ");
INSERT INTO wal_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Aximoonappe Gibxxe SHaafaakko simmidi, Meediteraane Abbaa gakkees. ");
INSERT INTO wal_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“‘Arggo baggaara intte zawai Meediteraane Abbaa gaxaa gidana. ");
INSERT INTO wal_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“‘Huuphessa baggaara intte zawai Meediteraane Abbaappe Hoora Deriyaa sitti ootti malaatidi, ");
INSERT INTO wal_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Hoora Deriyaappe Hamaata Pinuwaa gakkanaassa; hegaappe Xadaadan zawatees. ");
INSERT INTO wal_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Qassi Zifiroona biidi, Haxaari-Enaana gakkees. Huuphessa baggaara intte zawai hagaa gidana. ");
INSERT INTO wal_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“‘Arshsho baggaara intte zawai Haxaari-Enaanappe SHafaama gakkanaassi sitti ootti malaatidi, ");
INSERT INTO wal_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","SHafaamappe biidi, Ainappe arshsho baggaara de7iya Ribila wodhdhidi, Galiila Abbaappe arshsho baggaara de7iya keraa gakkees. ");
INSERT INTO wal_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Hegaappe duge Yorddaanoosa SHaafaa wodhdhi zawatidi, Maxine Abbaa gakkees. Intte biittaa zawai ubba baggaarakka hagaa’ yaaga” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Yaagin Muusee Israa7eelata hagaadan yaagidi azaziis; “Saamaa yeggidi, intte laattana mala, uddufun zaretuyyoonne bagga zaretuyyo he biittai imettanaadan GODAI azaziis. ");
INSERT INTO wal_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","15","Aissi giikko, Roobeela zareti Gaada zaretinne, Minaase zaretuppe baggai bantta laataa Yarkko hefinttan Yorddaanoosa SHaafaappe arshsho baggaara ekkidosona” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“He biittaa intteyyo laata oottidi, shaakki immana asatu sunttai hagaa; qeesiyaa El77aazaranne Nawe na7aa Yaasa. ");
INSERT INTO wal_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Qassi biittaa shaakkanau maaddana mala, zare ubbaappe issi issi halaqaa sunttite. ");
INSERT INTO wal_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Eta sunttai hagaappe kaallidi de7iyaagaa. Zariyaa Halaqaa Yihudaa Yifune na7aa Kaaleeba ");
INSERT INTO wal_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simoona Amihuuda na7aa SHalumi7eela ");
INSERT INTO wal_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Biniyaama Kisiloona na7aa Elddaada ");
INSERT INTO wal_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Daana Yoogila na7aa Buuqa ");
INSERT INTO wal_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yooseefa na7aa Minaase Efooda na7aa Hani7eela ");
INSERT INTO wal_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Yooseefa na7aa Efireema SHifxxaana na7aa Qamu7eela ");
INSERT INTO wal_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zaabiloona Parnnaaka na7aa Elxxaafaana ");
INSERT INTO wal_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Yisaakoora Azzaana na7aa Palxxi7eela ");
INSERT INTO wal_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aseera SHalooma na7aa Ahihuuda ");
INSERT INTO wal_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Nifttaaleema Amihuuda na7aa Padaahi7eela ");
INSERT INTO wal_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Kanaane biittan Israa7eelatuyyo laataa shaakki immana mala, GODAI azazido asati hageeta” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Yarkko hefinttaara, Yorddaanoosa SHaafaa matan de7iya Moo7aaba Dembban, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Israa7eelati bantta laataappe Leewati de7ana katamatanne eta yuushuwan de7iya hentta gadeta immana mala, neeni eta azaza. ");
INSERT INTO wal_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","He katamatun eti de7ona; hentta gadeti eta miizzaassa, eta dorssaassanne eta hara mehe ubbaassa gidona. ");
INSERT INTO wal_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Intte Leewatuyyo immana katamaa yuushuwan de7iya hentta gadeti katamaa gimbbe dirssaappe karekko issi sha7u wara gidona. ");
INSERT INTO wal_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Katamaappe kareera, arshsho baggaara naa77u sha7u waraa, tohossa baggaara naa77u sha7u waraa, arggo baggaara naa77u sha7u waraanne huuphessa baggaara naa77u sha7u waraa likkite; yaatobare katamai giddo ginan de7ana. Leewati he heeraa bantta katamaayyo hentta gade oottona. ");
INSERT INTO wal_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Leewatuyyo intte immana katamati, asa worida uri baqatidi attiyo usuppun katamata; hegeetu bolli gujjidi, oitamanne naa77u hara katamata etayyo immite. ");
INSERT INTO wal_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Leewatuyyo intte muleera oitamanne hosppun katamata eta hentta gadetuura issippe immite. ");
INSERT INTO wal_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Israa7eelatu laataappe Leewatuyyo intte immana katamati issi issi zaree laattidoogaa keena gidanau koshshees; cora asai de7iyo zariyaappe cora katamata ekkite; shin qoodan guutta asai de7iyo zariyaappe guutta katamata ekkite” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Hegaappe guyyiyan, GODAI Muusa hagaadan yaagiis; ");
INSERT INTO wal_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Neeni Israa7eela asaa hagaadan yaaga; ‘Yorddaanoosa SHaafaa pinnidi, Kanaane biittaa intte geliyo wode, ");
INSERT INTO wal_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","erennan asa worida uri baqati biidi attana mala, katamata intteyyo doorite. ");
INSERT INTO wal_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Erennan asa woridaagee yaa7aa sintti pirddau eqqana gakkanaassi, suuttaa achchiyaagee a worenna mala, he katamati baqati attiyo soho gidona. ");
INSERT INTO wal_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Ha intte immiyo usuppun katamati intteyyo baqati attiyo katamata gidona. ");
INSERT INTO wal_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Yorddaanoosa SHaafaappe hafintta baggaara heezzu katamaanne Kanaane biittan heezzu katamata intte baqati attanau immite. ");
INSERT INTO wal_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ha usuppun katamati erennan asa worida Israa7eelati, hara dere asatinne eta giddon de7iya beteti baqatidi attiyo soho gidona. ");
INSERT INTO wal_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘Issi asi issi asa birata miishshan shocin, he uri haiqqikko, hegee shemppuwaa woridaagaa; shemppo woridaagee haiqqo. ");
INSERT INTO wal_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Qassi worana danddayiya shuchchaa ba kushiyan oiqqida asi issi asa he shuchchan caddin, he uri haiqqikko, hegee shemppuwaa woridaagaa; shemppo woridaagee haiqqo. ");
INSERT INTO wal_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Qassikka worana danddayiya mitta ba kushiyan oiqqida asi issi asa he mittan shocin, he uri haiqqikko, hegee shemppuwaa woridaagaa; shemppo woridaagee haiqqo. ");
INSERT INTO wal_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Suuttaa achchiyaagee he shemppuwaa woridaagaa demmikko woro. ");
INSERT INTO wal_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“‘Issi asi issi asa morkkidi caddin, woikko zuggidi issibaa a bolli olin, he urai haiqqikko, ");
INSERT INTO wal_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","woikko morkkidi ba kushiyan bubbuxin, he urai haiqqikko, i shemppuwaa woridaagaa; shemppo woridaagee haiqqo. Suuttaa achchiyaagee shemppuwaa woridaagaa demmikko woro. ");
INSERT INTO wal_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘SHin morkketetti bainnan, issi asi issi asa akeekennan sugikko, woikko zuggidi naagennan issibaa a bolli olikko, ");
INSERT INTO wal_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","woikko a worana danddayiya shuchcha i be7ennan a bolli yeggikkonne he urai haiqqikko, hegee a morkke gidenna gishshaunne a qohanau halchchibeenna gishshau, ");
INSERT INTO wal_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","yaa7ai erennan woridaagaappenne suuttaa achchiyaagaappe gidduwan ha wogatudan pirddo. ");
INSERT INTO wal_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Erennan woridaagaa suuttaa achchiyaagaa kushiyaappe yaa7ai ashshidi, i baqatidi attiyo katamaa zaaro. Zaarin geeshsha zaitiyan tiyettida, qeese ubbatu halaqai haiqqana gakkanaassi, i yan de7o. ");
INSERT INTO wal_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“‘SHin erennan woridaagee baqatidi attiyo katamaa zawaappe kare kiyiyaabaa gidikkonne, ");
INSERT INTO wal_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","baqati attiyo katamaappe kareera suuttaa achchiyaagee a demmidi worikko, i woridoogau oishettenna. ");
INSERT INTO wal_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Aissi giikko, qeese ubbatu halaqai haiqqana gakkanaassi, he erennan woridaagee ba baqatido kataman uttanaagaashin aggiis. SHin qeese ubbatu halaqai haiqqidoogaappe guyyiyan, erennan woridaagee ba laata gade simmanau danddayees. ");
INSERT INTO wal_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“‘Intteyyoonne biron yelettana yeletaayyo, intte de7iyoosa ubban hagee higge gido. ");
INSERT INTO wal_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“‘Asa worida ooninne shemppo i woridoogaadan markkati markkattin haiqqo; shin issi asa xalaalai markkattin, ai asinne haiqqoppo. ");
INSERT INTO wal_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","SHemppuwaa worido gishshau haiqqanau bessiya asa paxa ashshanau gumiyaa ekkoppite; i haiqqo. ");
INSERT INTO wal_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Attiyo katamaa baqatida ooppenne qeese ubbatu halaqai haiqqanaappe kase, i guyye simmidi, ba biittan de7anaadan oottanau gumiyaa ekkoppite. ");
INSERT INTO wal_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“‘Hegaadan oottidi, intte de7iyo biittaa tunissoppite. Aissi giikko, suuttaa gussiyoogee biittaa tunissees; suuttaa gussidaagaa suuttaanappe attin, suuttai gukkido biitti hara ogeera tunatettaappe geeyenna. ");
INSERT INTO wal_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Taani, GODAI, Israa7eela asaa gidduwan de7iyo gishshau, intte de7iyo biittaa, taanikka de7iyo biittaa tunissoppite’ yaagada yoota” yaagiis. ");
INSERT INTO wal_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Yooseefa zaretuppe, Minaase na7aa Maakiira na7aa Gala7aade yaratu halaqati Muusekkonne Israa7eelatu yaratu halaqatukko yiidosona. ");
INSERT INTO wal_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Eti yiidi, “Nu godau, Israa7eela asaayyo biittaa saaman shaakkada immana mala, GODAI nena azaziis; qassi GODAI nu ishaa Xalofihaada laataa a macca naatuyyo neeni immana mala, nena azaziis. 