﻿USE sofia;
DROP TABLE IF EXISTS sofia.waj_vpl;
CREATE TABLE waj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES waj_vpl WRITE;
INSERT INTO waj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aanna Yisuu Kirisiinna oyaiya kuavai. Aaparahaamooya Davuitiiya oyaivakidiri Yisuuva diiteeravai. ");
INSERT INTO waj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aaparahaamo ari mmaapuuvaa Isaakaa mmata kiooduu Isaako Yakoopaa mmata kiooduu Yakoopo Yutaanna mmata kioo ari kata vayaidaatama mmata kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yutaava ari mmaapuuvaitana Pereseeya Seraaya mmata kiooduu ngiari kaanaa nnutuuvo Tamaarovee. Pereseeva Eseroonaa mmata kiooduu Eseroono Araamaa mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araamo Aminataapaa mmata kiooduu Aminataapo Nasoonaa mmata kiooduu Nasoono Saramoonaa mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saramoono Buaasaa mmata kiooduu inna kaanaa nnutuuvo Rahaapovee. Buaaso Yoveteenna mmata kiooduu inna kaanaa nnutuuvo Ruutovee. Yoveteeva Isainna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaivaano kieeta vaidiivaa Davuitiinna mmata kieeravai. Davuitiiva vaidiivaa nnutuuvo Uriaanna muaadaivaa vara kioo mmaapuuvaa Soromoonaa mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromoono Rekaviaamaa mmata kiooduu Rekaviaamo Aviaanna mmata kiooduu Aviaava Asaanna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaava Yosapataa mmata kiooduu Yosapato Yoraamaa mmata kiooduu Yoraamo Usiaanna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiaava Yotaamaa mmata kiooduu Yotaamo Akasaanna mmata kiooduu Akasaava Isikiaanna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Isikiaava Manaseenna mmata kiooduu Manaseeva Amoosoonna mmata kiooduu Amoosoova Yosiaanna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiaava Yekoniaanna mmata kioo ari kata vayaidaatama mmata kiooduu iya varuu suaivaki vaidi Bapuroonaaya numa gioonna kiaapuuya vitada ngiari yoosinnaivaki yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yekoniaava Seratiereenna mmata kiooduu Seratiereeva Seruvavereenna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Seruvavereeva Avituunna mmata kiooduu Avituuva Eriakiimaa mmata kiooduu Eriakiimo Asoroonna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoroova Satokoonna mmata kiooduu Satokoova Akiimaa mmata kiooduu Akiimo Erutuunna mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Erutuuva Eriasaaraa mmata kiooduu Eriasaaro Mataanaa mmata kiooduu Mataano Yakoopaa mmata kiooduu ");
INSERT INTO waj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoopo Yoosiipaa mmata kieeravai. Yoosiipo inna Mariaanna vaativai. Mariaava ari mmaapuuvaa Yisuunna mmata kiooduu vaidiiyaano innara tunoo: Aanna Misiaa vaidi Anutuuqo mmataama kioo vaidiivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aaparahaamo varuu suaivakidiri inna sidinnaidiiya yaakuuvaitana yukukidiri taarama taarama varia rada nnidada iyakidiri Davuitiiva diiteeravai. Davuitiiva diitoo suaivakidiri mmuaikaraama inna sidinnaidiiya yaakuuvaitana yukukidiri taarama taarama varia rada nnidada iya varuu suaivaki vaidi Bapuroonaaya numa iyaata rapidada yaatara kiada vitada ngiari yoosinnaivaki yapa kieeravai. Iya Isarairaiya yapa kiooduu varuu suaivakidiri mmuaikaraama Yekoniaanna sidinnaidiiya yaakuuvaitana yukukidiri taarama taarama varia rada nnidada tooduu Anutuuqo mmataama kioo vaidiivo diiteeravai. ");
INSERT INTO waj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yisuu Kirisiinna mmatoovo ataama vairavai. Yisuuva hama varuu suaivaki inna kaanaa Mariaanna Yoosiipo varaanara kuaivaa kiaa teerama kioo hama inna varooduu Mariaava rikiooduu Mmannasa Yoketaivoono vaa nnaakaraivaa inna mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mmuduu Mariaanna vaatiivo Yoosiipo vaidi yoketaavoonora tioo hama mmamma maisaivaa Mariaanna mmirainno kati haumaki inna titaanaraivaara yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Homo ivaara yaata utuoo varioo vainno ruvuaataivaa tooduu Udaanga Anutuuqaa aangeraa voovoono tuma inna kiaa mmioo tunoo: Yoosiipo, Davuitiinna oyaivakinnaa vaidikuavee. Ai nnaata Mariaanna varaanaraivaara sa aatuunna taara yaata utuanee. Varaanee. Mmannasa Yoketaivoono nnaakaraivaa inna aakiaivaki yapaivaivee. ");
INSERT INTO waj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Fai iva mmaapuvai mmatanai a inna nnutuuvaa Yisuuvavee tinaravai. Fai ivoono ari seena gioonna kiaapuuya mminnamminnaa maisaiyauvaa ruga kioo iya vitoo yoketaivau yapaanaraivaara a inna nnutuuvaa Yisuuvavee tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Nnaaruaa vaidi Udaanga Anutuuqaa kuaivaa kooyaa tira forofetaa voovoono Anutuuqo inna kiaa mmuu kuaivaa fafaarainno ataa kua tunoo: Fai kiaatanna yoketaa hama vaidi voovoono inna tasipaivoono nnaakara sunnainno mmaapuvai mmatanai iya inna nnutuuvaa Imanueero kiaaravee, tiravai. Ii nnutu ivaa oyaivo tinoo: Anutuuqo ti tasipainoo, tiivai. Nnaaruaa vaidi forofetaivo fafaara roo kuaivo ngioo ngioo Yisuunna mmatoo suaivaki innara kua tuu kua mmuakiaayauvai kaanaivo vairavai. ");
INSERT INTO waj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Itaama vauduu Yoosiipo diitoo Udaanga Anutuuqaa aangeraivo inna kiaa mmuu kuaivaa rikioo iinno ari nnaataivaa vareeravai. ");
INSERT INTO waj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Varooduu homo Mariaava nnaakara sunnaivaata varuu suaivaki Yoosiipo hama inna tasipama nuairavai. Yapooma Mariaava mmaapuuvaa mmata kiooduu Yoosiipo inna nnutuuvaa Yisuu-o tiravai. ");
INSERT INTO waj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yoosinna pinaivaa nnutuuvo Yutayaa ivaki vau yoosinna kiisaivaa nnutuuvo Pitiriheema ivaki Mariaava Yisuunna mmateeravai. Inna mmatoo suaivaki Herooto Yutayaiya kieetavai variravai. Varuduu vaidi tinni ruaa vooya aakiapuaiyauvo tooyauvaara mmoori uuya suai raari roopinnaidiri nnidada numa Yerusareema gioonna kiaapuuya yaparaida tunoo: ");
INSERT INTO waj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nnaakara meediivo Yutayaiya kieetavai varinoo kiaivo deevakiinno variinnee? Ari aakiapuaivo suai raari raipinnai ngioo varikiai ta ivaa taa rada numa ti ausa mmuduuyaiyauvaa inna mmiaara ngiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","tuduu rikioo kieeta vaidi Herooto iya tuu kuaivaa rikioo pinaama nnikiarauduu mmuakiaa gioonna kiaapu Yerusareema varuuyaatama rikiada nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nnikiarauduu Herooto mmuakiaa Anutuuqaara kati puara hudeera kieetaiyaata vaidi kua mmaanna kiaa mmiraiyaatama tuduu innasi nuunauduu iya yaparainno tunoo: Fai deevakidiri Anutuuqo mmataama kioo vaidiivaa kaano mmataanarannee? ");
INSERT INTO waj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","tuduu rikiada iya inna kuaivaa sai tunoo: Yutayaivaki vai yoosinna kiisa Pitiriheemadiri fai mmataanaravaivee. Nnaaruaa vaidi forofetaa voovoono ivaara Anutuuqaa avaivaa fafaara roo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yutayaivaki vai yoosinna Pitiriheemaivo kiisavai vaikiai yoosinna pinaa Yutayaa kieetaiya ivaara kiaanoo: Fai yapooma ii yoosinna ivaa nnutuuvo pinaavai vainaravaivee, kiaavai. Fai ivakidiri vaidi kieeta voovai diitoo ni gioonna kiaapu Isarairaiyara dinaravaivee. Forofetaivoono itaa kua tiravaivee. ");
INSERT INTO waj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Iya itaa kua tuduu rikioo Herooto iya tuu kuaivaara yaata utuoo vaidi tinni ruaa suai raari roopinnaidiri nnuuya tuduu haumakinaa nnida innasi nuunauduu iya yaparainno tunoo: Dee suaivau aakiapuaivo nnuunnee? ");
INSERT INTO waj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","kiaa kioo iya sai tuu kuaivaa rikioo Pitiriheema iya titoo tunoo: Oo nnaakaraivaara tuqinnama buaidada teekio ngii too vainai numa ni giaa ni mikiai fai neetaata oro ni ausa mmuduuyaivaa inna mminaravee, ");
INSERT INTO waj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","tuduu iya inna kuaivaa rikiada ivaki pikiada diitada aataruuvau vida tooduu aakiapuaivo vaa suai raari roopinnai iya toovoono iya too vainno iya tauraa vitoo vioo vioo nnaakaraivo varuu nnauvo vauvau diravai. ");
INSERT INTO waj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Duduu iya aakiapuaivaa teeda kaayauma sirigauduu iya ausaiyauvo yoketairavai. ");
INSERT INTO waj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yoketauduu iya nnauvaki oro nnaakaraivaata kaanaa Mariaannaatama teeda toorivu yau harada ngiari ausa mmuduuyaiyauvaa nnaakaraivaa mmiravai. Mmida ngiari utuaiyauvakidiri mminnaa yoketaiyauvaa kati inna mmida voovoono sikau mmannaammannauvaa nnutuuvo gooraivaa inna mmuduu voovoono yatari ranaivaa hudooduu suuda yoketaa vuuvaa inna mmuduu voovoono kupuuvaa roosuuvaa nnutuuvo miiraivaa inna mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mmi taika kiada oro vuru vaida ruvuaataivaa tooduu Anutuuqo yaagueeqama iya kiaa mmioo tunoo: Sa keenaa Herootaasi kuatee, tuduu rikiada ari vo aataru voovaugiataa ngiari yoosinna viravai. ");
INSERT INTO waj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iya vida kiooduu Yoosiipo vainno ruvuaataivaa tooduu Udaangaivaa aangeraa voovoono tuma inna kiaa mmioo tunoo: Diitee nnaakaraivaata ari kaanaatama vitee yoosinna Iyiipa Herootaa yaatu kuanee. Herooto tinai ari ngiaammuauya nnaakaraivaa ruputikio putuaiveeraivaara fai innara buaama rada nookiaaravai. Ivo itaama iinaraivaara Iyiipa viee ivaki varinanai neenoo kava i tinai rikiee pikiee aapi ngianee, ");
INSERT INTO waj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","tuduu rikioo Yoosiipo heenaki diitoo nnaakaraivaata kaanaatama vitoo Iyiipa vioo vioo ");
INSERT INTO waj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","oro ivaki varududuu Herooto putiravai. Nnaaru vaidi forofetaa voovoono Udaangaivo inna kiaa mmuu kuaivaa fafaarainno tunoo: Na ni Maapuuvaa Iyiipadiri kiaaduu nniravaivee, tiravai. Iya Iyiipa vuduu ii kua ivaa kaanaivo vairavai. ");
INSERT INTO waj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Vaidi suai raari roopinnaiya Herootaa yokekiaa kiada vuuvaara rikiooduu inna ausaivo pinaama nnannatooduu Herooto vaidi vooya titooduu Pitiriheema ivaki vida mmuakiaa vainima vau yoosinnaiyauvaki vida ngiaammuau taara nuanu varooyaata iya nnaagiai mmatooyaatama ruputuduu putiravai. Tauraa vaidi suai raari roopinnaiya tooduu aakiapuaivo iya too vau suaivakidiri mmatoo nnaakaraiyaata nnaagia nnaagiai mmatooyaatama ruputuduu putiravai. ");
INSERT INTO waj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nnaaru vaidi forofetaa voovai nnutuuvo Yirimiaava ivaara fafaara roo tuuvaa kaanaivo vairavai. ");
INSERT INTO waj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yirimiaava tunoo: Yoosinna Ramaivaki gioonna kiaapuuya kaayau rateera akuaivaata yaagueeqa aayannaivaatama rikiaavai. Raheeraa nneeditunnaiya ngiari nnaakaraiyara ratadada iya vaa putu taikaivaara mmannammanna rataavai. Iya seenaiya iya ausaiyauvaa tuqinnaaree kiaa iidada taavo hama yoketaivaivee. Forofetaa Yirimiaavaano itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herooto vaa putuduu Yoosiipo Iyiipa hara kioo varioo vainno ruvuaataivaa tooduu Udaangaivaa aangeraa voovoono tuma inna kiaa mmioo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Diitee nnaakaraivaata ari kaanaatama vitee yoosinna Isarairaivaki kuanee. Vaa vaidiiya nnaakaraivaa ruputuaara uuya putiravaivee, ");
INSERT INTO waj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","tuduu rikioo diitoo nnaakaraivaata kaanaatama vitoo yoosinna Isarairaa viravai. ");
INSERT INTO waj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Vioo vioo Yoosiipo Yutayaa ivaki varinaree kiaa rikiooduu Akiraaso ari koonna Herootaa mmaataivaa varoo Yutayaiya kieetavai varuduu rikioo ivaki kuanaraivaara aatuuravai. Aatuunno vainno ruvuaataivaa tooduu Anutuuqo inna kiaa mmuu kuaivaa rikioo iinno yoosinna pinaa Karirayaara vioo vioo ");
INSERT INTO waj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","oro yoosinna kiisa voovai nnutuuvo Nasareeta hara kioo variravai. Nnaaru vaidi forofetaiya fafaaraida tunoo: Fai vaidiiya Anutuuqo mmataama kioo vaidiivaara kiaara: Nasareetaa vaidivaivee, kiaaravaivee, tiravai. Yoosiipo oro Nasareeta hara kioo varuduu forofetaiya itaa kua tuuvaa kaanaivo vairavai. ");
INSERT INTO waj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Vo suai suai voovaki Yuvuaano nnoori apira vaidiivo numa Yutayaa ivaki vau mmata voovai koo mmuyai gaangaivau nuainno varioo Anutuuqaa mmayaayaivaa gioonna kiaapuuya kiaa mmioo iya tunoo: ");
INSERT INTO waj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ngiingii mminnamminnaa maisaiyauvaa pikiada ausa hanigiaatee. Anutuuqo gioonna kiaapuuyara dira suaivo aa vainima nninoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nnaaruaa vaidi forofetaa Yisayaava Yuvuaanaara aa kua aavaa fafaara roo tunoo: Vaidi voovoono koo mmuyai gaanga voovau dioo vainno aayanna roo tinara: Ngia ngii kieetaivaara aataruuvaa teerairaivaa roosiima ngii Udaangaivaara teerama kiaatee. Udaangaivo ngiiisi nninaraivaara teeraida safuuma kiaatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yuvuaano puara kamera yaasiivaadiri yaapaivaa roosiima iima uyu kioo nnabaivaadiri vausaivaa iima kioo ari tammaivaki rau kioo kaisaivaa nnoo ngengengoongaivaa suuyaivaa nneeravai. ");
INSERT INTO waj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mmuakiaa gioonna kiaapu Yerusareemaiyaatama vo yoosinna vo yoosinna Yutayaa ivaki vau yoosinnaiyaatama nnoori Yorotaana vainima varuuyaatama Yuvuaanaasi vida ");
INSERT INTO waj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ngiari mminnamminnaa maisaiyauvaa Anutuuqaa kiaa kookieema kiooduu nnoori Yorotaanaivakidiri Yuvuaano iya apiravai. ");
INSERT INTO waj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Apuoo varioo tooduu vaidi Farisai vooyaata vaidi Satuukai vooyaatama nnoori varaaraivaara innasi nnuduu too iva iya tunoo: Ngia vaidi maisaso, gioono ngii giaa ngii mikiai ngia Anutuuqo irisai maisaivaa ngii minaraivaara rikiadaida aatuuda niisi ngiaannee? ");
INSERT INTO waj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ngia kutaa tuanaa ngiingii mmoori maisaiyauvaa pikiada ngiingii ausaiyauvaa hanigia kiada mmoori yoketaivaa iikio kaanainai na teenai niisi ngiatee. ");
INSERT INTO waj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sa ngiengienaidiri yaata utida kiatee: Inna Aaparahaamo ti rubuungovee. Ta aikiooma variaunnanoo, kiatee. Na ngii giaa ngii miaunoo. Aa sikau aayauvaadiri Anutuuqo iinaree tioo iinai vida hanigiada fai Aaparahaamaa uru nnaakaraya variaaravai. ");
INSERT INTO waj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aanna makee Anutuuqo irisai maisaivaa mminaraivo vaidiivo haivaa yatariiyauvaa oyaiyauvaki teerama kioo tu kioo vaivaa roosiivai. Yatari hama iira yoketaa vaivaa fai hanaa rakau ikiana kagaari kiaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngiingii ausaiyauvaa hanigiada yoketaama variaivaara na mmanna nnooriivaadiri ngii apuaunoo. Vaidi ni nnaagiai nninaraivo nnoonna vaidivai. Na kiisa vaidivai. Hama na yopeema mmoori vareera ngiaammuauvai roosiima variee inna yuku nnabaivaitana varee kuanaravai. Fai ivoono Anutuuqaa Mmannasa Yoketaivaa tino too ngia vaa ausa hanigiaiya ngii aakiaiyauvaki varinaravai. Ngia hama ausa hanigiaiya fai irisai maisa ikia roosiivaa ngii mminaravai. ");
INSERT INTO waj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Vaidiiya yeenna vuiitaivaa savooraivaadiri uyu kagaari kiada kaanaivaa vareerayaama ivoono ari savooraivaadiri varoo vuiita iiraiyauvaa rummua rusuku kioo supiya uyu ngiau kiaikio iiraiyauvo mmatayaa tuoo kuaikio varoo ari yeenna yapeera nnauvaki yapa kioo nnabaiyauvaa varoo ikiaivo hama tasuuvaki kagaari kiaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ii suai ivaki Yisuuva yoosinna Karirayaa pikioo Yuvuaano inna nnoori apuaiveera nnoori Yorotaana ivaki nniravai. ");
INSERT INTO waj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Numa duduu Yuvuaano inna ooqoo tinara iinno tunoo: A aaniira niisi ngiannannee? Eenoo ni apinaraivo inna yoketaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","tuduu rikioo Yisuuva inna sai tunoo: Inna aikioovai. Aanna makee eenoo ni apuanee. Ta itaama iida Anutuuqo mmuakiaa mmoori aataru yoketaivaa ti kiaa ti mmiivaa iikiaaravee, tuduu rikioo Yuvuaano ee-oo tiravai. ");
INSERT INTO waj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kiaa kioo Yisuunna nnoori apu kioo saivaata Yisuuva nnooriivakidiri numa dioo vainno reeri tooduu ngiauvo rusiti varoo vioo sai ngioo sauduu Anutuuqaa Mmannasaivo ngiaamma mirunnaivaa roosuuvoono tuoo tuoo tuma innayaa variravai. ");
INSERT INTO waj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Varuduu rikiooduu ngiau aapuuvakidiri Anutuuqaa kuaivo tuoo tunoo: Inna ni Maapu tuanaivovee. Na innara mmuduuya ruee na inna tauko pinaama ni yoketainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sataango Yisuunna iinno teeno ivo muaraagakiainaaree kiaa uuduu Mmannasa Yoketaivoono Yisuunna vitoo koo mmuyai gaanga voovaura viravai. ");
INSERT INTO waj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oro kiooduu hara kioo varuduu ikianna heenaiyauvo taara vaidivaitana yuku yaaku taika kiooduu Yisuuva yeennaivaa hama nneerama kioo kati varududuu nnaagiai pinaama inna yeenna rairavai. ");
INSERT INTO waj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Inna yeenna rauduu Sataango numa inna tunoo: A Anutuuqaa Mmaapukuavee tiee aa sikau aayauvaa tino too hanigioo yeenna bereetayauvai vakiaivee, ");
INSERT INTO waj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","tuduu rikioo Yisuuva inna sai tunoo: Anutuuqaa kua fafaaraivo vainno tinoo: Gioonna kiaapu voovoono yeennaiyauvaa nnaasu nnaivoono hama yaagueeqaivaa inna mmiivai. Anutuuqaasidiri tii kua mmuakiaavai rikiaivoono yaagueeqaivaa inna mmiivai. Kua fafaaraivoono itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","tuduu rikioo Sataango Yisuunna vitoo yoketaa yoosinna Yerusareema vioo nuunaira nnau pinaivaa pupukiaivau yapa kioo inna tunoo: ");
INSERT INTO waj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A Anutuuqaa Mmaapukuavee tiee suairoommu kiee kuanee. Anutuuqaa kua fafaaraivo vainno tinoo: Fai Anutuuqo ari aangeraiya titanai aiyara haitatuukiaaravee. Ai yukuuvaa sikauyaadiri rusimmaurivoora kiaa iya ngiari yaakuuyauvaadiri suoodaa i sootu utuaaravaivee. Inna kuaivo itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","tuduu rikioo Yisuuva inna sai tunoo: Anutuuqaa kua fafaara voovai vainno tinoo: Sa i Udaanga Anutuuqaa iinna taanee, tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","tuduu rikioo Sataango kava Yisuunna vitoo oora taapi hokobaivau yapa kioo mmuakiaa vo mmata vo mmataiyauvaata mmuakiaa mminnaa yoketaiyauvo ivaki vauyauvaatama inna vitairavai. ");
INSERT INTO waj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Vitaama kioo tunoo: Fai a niiyara toorivu yau haree ai ausa mmuduuyaivaa ni minai fai na aa mmuakiaa aayauvaa i mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","tuduu rikioo Yisuuva inna sai tunoo: Sataango, ngieera kuanee. Anutuuqaa kua fafaaraivo vainno tinoo: A Udaanga Anutuuqaa ai ausa mmuduuyaivaa mmiee inna mmooriivaa nnaasu iikianee, tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","tuduu rikioo Sataango inna pikioo vuduu aangeraiya tuma inna haitatuuravai. ");
INSERT INTO waj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yisuuva vaidiiya Yuvuaanaa oovi nnauvaki yapa kioo kuaivaa rikioo mmata Karirayaa ivaura viravai. ");
INSERT INTO waj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Vioo yoosinna kiisa Nasareeta pikioo vioo nnoori haruunga Karirayaa vainima vau yoosinnaivaa nnutuuvo Kapanauma oro ivaki hara kioo variravai. Ii mmata ivo nnaaruaa vaidiivaitana Seporoonaya Nafataraiya mmatavai. ");
INSERT INTO waj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nnaaruaa vaidi forofetaa voovai nnutuuvo Yisayaava fafaara roo kuaivaa Yisuuva uuvaa kaanaivo vairavai. Yisayaava fafaara roo kuaivo vainno tinoo: ");
INSERT INTO waj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nnoori Yorotaana sainai nnoori haruunga vainiivau Seporoonaya Nafataraiya mmataivo vauduu ii mmata ivaa nnutuuvo Karirayaa ivaki vaidi hama Anutuuqaa kua rikiooya variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vaidiiya heenaivaki variaaneema iya varida fai mmeekia pinaivaa taaravai. Iya putira yoosinnaivaa heenaki roosiima variaiya teekio fai mmeekiaivo taanaravaivee. Yisayaava fafaara roovo itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ii suai ivakidiri Yisuuva Anutuuqaa mmayaayaivaa gioonna kiaapuuya kiaa mmioo tunoo: Ngiingii mminnamminnaa maisaiyauvaa pikiada ngiingii ausaiyauvaa hanigiaatee. Anutuuqo gioonna kiaapuuyara dira suaivo aa vainima nninoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yisuuva nnoori haruunga Karirayaa siriivau nuainnonno tooduu tavau vareera vaidi kato vayoovaitana Simoono vuai nnutuuvo Petorooso ari kataivo Adiriaasooya ngiari utua vaaheevaa tavaura nnooriivaki kagaari kiada tu kiada vauduu ");
INSERT INTO waj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yisuuva ivaitana tunoo: Ngia ni nnaagiai nnikiai na ni kuaivaa ngii giaa ngii minai ngia tavau vareerayaama gioonna kiaapuuya vitada niisi ngiatee, ");
INSERT INTO waj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","tuduu rikiada makee tuduu ivaitana ngiari utua vaaheeyauvaa pikiada inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ivakidiri vidada Yisuuva tooduu vo vaidi kato vayoovaitana Yakoopooya Yuvuaanaya Sevetainna mmaapuuvaitana ngiari gioonna tasipama kanuuvaki varida ngiari utua vaaheeyauvaa sapiraida variravai. Sapiraida varida tooduu Yisuuva ni nnaagiai ngiateera ivaitanaara aayanna rooduu ");
INSERT INTO waj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kanuuvaki ngiari gioonna pikiada makee tuduu Yisuunna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisuuva nuainnonno mmuakiaa yoosinnaiyauvo Karirayaa vauyauvaki vioo ngiari nuunaira nnauyauvaki vioo Anutuuqo gioonna kiaapuuyara dira mmayaaya yoketaivaa iya kiaa mmioo mmuakiaa nniitaroo ari vookara ari vookarauyauvaa tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tuqinnooduu iva uu mmayaayaivaa mmuakiaa yoosinna Suriaa varuu gioonna kiaapuuya rikiada mmuakiaa ari vo nniitaroo vo nniitarooyaata mmagia maisaiya iya aakiaiyauvaki varuuyaatama makemakee putida vaida kava diitooyaata yuku yaaku putuuyaatama vitada Yisuunnasi nnuduu iva iya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tuqinnooduu kaayau gioonna kiaapuuya Yisuunna nnaagiai viravai. Gioonna kiaapu Karirayaivakidiriaatama vuduu yaakuuvaitana vau yoosinnaiyauvaa nnutuuvo Dikaporiisaivakidiriaata vuduu Yerusareemaivakidiriaatama vuduu Yutayaivakidiriaata vuduu nnoori Yorotaana sainai varuuvakidiriaatama Yisuunna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yisuuva kaayau gioonna kiaapu innasi nnuuya too taapi kiisaivau vioo ivau hara kioo varuduu ari ngiaammuauya innasi vuduu too ");
INSERT INTO waj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ari kuaivaa iya kiaa mmioo varioo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Gioonna kiaapuuya ngiariiyara kiaanoo: Hama ta yopeema Anutuuqaa roosiikiaunnayavee, kiaiyara Anutuuqo iyara yoketainoo. Anutuuqo gioonna kiaapuuyara diraivo vaa iyasi vainoo. ");
INSERT INTO waj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Gioonna kiaapuuya ausa mmuaararaivaa varada ratada variaiyara Anutuuqo iyara yoketainoo. Anutuuqo iya ausaiyauvaa tuqinnaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Gioonna kiaapuuya tirooma adida variaiyara Anutuuqo iyara yoketainoo. Anutuuqo kua kutaivaa tioo iya mminaraivaa fai iya varaaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Gioonna kiaapuuya Anutuuqaa aataru yoketaivaara mmuduuya rida safuuma iya iikiataiyara Anutuuqo iyara yoketainoo. Fai Anutuuqo ari aataru yoketaa mmuakiaavai iya vitaino iya yoketainaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Gioonna kiaapuuya ngiari seenaiyara boo kiaiyara Anutuuqo iyara yoketainoo. Anutuuqo fai iyara boo tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Gioonna kiaapuuya iya aakiaiyauvo yamaama vaiyara Anutuuqo iyara yoketainoo. Fai iya Anutuuqaa taaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Gioonna kiaapuuya rapiraivaara ooqoo tiraiyara Anutuuqo iyara yoketainoo. Fai Anutuuqo iyara tinara: Iya ni naunna maapu tuanaayavee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Gioonna kiaapuuya safuuma varira aataruuvaa iikiaani vooyaano kuminayaa mmuaararaivaa iya mmiaiyara Anutuuqo iyara yoketainoo. Anutuuqo gioonna kiaapuuyara diraivo vaa iyasi vainoo. ");
INSERT INTO waj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ngia ni nnaagiai ngiaivaara gioonna kiaapuuya ngiiiyara maisa kua tida mmuaararaivaa ngii mida ngiiiyara unnakua unnakua tikiai sa yaata utuatee. Anutuuqo ngiiiyara yoketainoo. ");
INSERT INTO waj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Irisai yoketaivo ngiiini ngiau aapu vaivaara yaata utida sirigaida variatee. Maisa mmooriivaa ngiiiyara iikiaaneema gioonna kiaapu vooya nnaaru varuu forofetaiyara iiravai. ");
INSERT INTO waj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Gioonna kiaapu mmatayaa variaiya ngiari yeennaiyauvunu yorokuuvaa haata kiada nneeda taavo iya yoketaineema ngia yorokuuvaa roosiima variaani gioonna kiaapuuya ngii taavo iya yoketainoo. Yorokuuvo vainnonno maisainai fai ngia aaniivaadiri iikio kava yoketainarannee? Hama yopeemavee. Vaa maisaikiai kati kagaari kiaani gioonna kiaapuuya ivau yuku raavai. ");
INSERT INTO waj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Gioonna kiaapu mmatayaa diaiya ngia iya mmeekiaivaa roosiikiaaya variaanoo. Yoosinna pinaivo taapiivau vaivo hama yopeema fai haumaki vainaraivaa roosiima ngia variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hama gioonna kiaapu voovoono toobaivaa subi kioo varoo oro yapa kioo yavaivaa varoo toobaivau tuarapuatikama rummua apu kiaikio vaivai. Ivo toobaivaa varoo kiikoo koovau hirivai. Hiri kiaikio mmuakiaa gioonna kiaapu nnauvaki variaiyaki mmeekiaivo taivai. ");
INSERT INTO waj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Itaama vainai ngia mmoori yoketaivaa iikiaivaa gioonna kiaapuuya teeda Anutuuqo ngiau aapu variivaara kua yoketaivaa kiateeraivaara ngia toobaivaa roosiima variatee. ");
INSERT INTO waj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sa ataa kua yaata utida kiatee: Ivo Anutuuqaa mmaanna tuu aataruuyauvaatama forofetaiya kua kiaa mmira aataruuyauvaatama hatokaanara tiiravaivee, kiatee. Hama na iyauvaa hatokaanara tiiravai. Ii kua mmaanna iyauvaa kaanaiyauvo vakiaiveeraivaara na tiiravai. ");
INSERT INTO waj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na kua kutaavai ngii giaa ngii miaunoo. Anutuuqaa mmaanna tuu kuaivaki kiisa fafaaraivo vaivakidiri fai hama gioonna kiaapu voovoono yopeema fafaara kiisa voovai rugaanaravai. Ngiau mmata taikeera suaivaki fai homo iyauvo vaino Anutuuqo mmuakiaa kuayauvai ivaki vaiyauvaa iima taika kiaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Gioonna kiaapu voovoono Anutuuqaa mmaanna tuu kuaivakidiri kua kiisa voovai hatokoo koonnama iinno gioonna kiaapu vooya ari koonnama ii aataruuvaa iya vitainai teeda iikio fai Anutuuqo gioonna kiaapuuyara diraivaki inna tinara: Aduoo tuanaivau varianee, tinaravai. Gioonna kiaapu voovoono Anutuuqaa mmaanna tuu kua mmuakiaayauvai rikioo iinno gioonna kiaapuuya ivo kuai aataruuvau kuateeraivaara iya kiaa mmiivo fai Anutuuqo gioonna kiaapuuyara diraivaki inna tinara: Aruoo varianee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na ngii giaa ngii miaunoo. Ngia safuuma varira aataruuvo vaidi Farisaiya varira aataruuyauvaatama vaidi kua mmaanna kiaa mmiraiya varira aataruuyauvaatama hama yaataranai fai yapooma hama ngia Anutuuqo gioonna kiaapuuyara diraivaki kuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Musiiva vaidi nnaaru varuuyaata kiaa mmuu kua voovai vaa ngia rikiaavai. Ii kua ivo vainno tinoo: Sa gioonna kiaapu voovai ruputino putuaivee. Fai putino kua pinaivo inna ruputuannaivaa aiki vainaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","tiivaara makee neenoo ngii giaa ngii miaunoo. Fai gioonna kiaapu voovoono ari seenaivaara pinaama ausa nniitareeno kua pinaivo innaki vainaravai. Gioonna kiaapu voovoono ari seenaivaara maisavaivee tinai fai vaidiiya inna vitada vaidi kua yeena rairaiyasi vikio innaki kua pinaivo vainaravai. Gioonna kiaapu voovoono ari seenaivaara kumimaka yaata duunakuavee tiivaa fai Anutuuqo tino too ikia aakiaivaki kuanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ngiiikidiri a vaidi voovoono puara sipisiipa voovai Anutuuqaara kati yeena tapiivaki hudaanee kiaa kiee rikino i seenaivo homo vo kua voovaara aiyara nnannateenai ");
INSERT INTO waj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","i puara sipisiipaivaa tapi oyaivaki yapa kiee akiairaama oo i seenaivaata kua tino too inna ausaivo nuufainai kava vara ranee numa puara sipisiipaivaa Anutuuqaara kati hudaanee. ");
INSERT INTO waj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Vaidi voovoono kua pinaivaa iiki yapaanaree kiaa i vitoo kua pinaivaara dira vaidiivaasi vivoora aataru tammaivaudiri vida kua safuuma kiada kati oro ausa nuufa tasipama variatee. A hama itaino fai i vitoo vaidi kua pinaivaara diraivaasi vino fai ivoono oovi nnauvaara haitatuura vaidiivaa i mmino too fai ivoono i vitoo oovi nnauvaki yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na kua kutaavai i kiaa i mmiaunoo. Fai a ivaki variee mmuakiaa irisaiyauvaa inna mmiee mmiee kiisa vookiata hama mmirama kiee fai mmannammanna oovi nnauvaki variee mmi taika kiee mmaanai tiee kuanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Musiiva nnaaru tuu kuaivaa vaa ngia rikiaavai. Ii kua ivo vainno tinoo: A vaa nnaata vaati varaannaikua sa mmuara heera aataruuvaa iikianee, ");
INSERT INTO waj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","tiivaara makee neenoo ngii giaa ngii miaunoo. Vaidi voovoono gioonnaivaa taikio inna varaataikio vaa ari ausaivonnaadee inna mmuara varaivai. ");
INSERT INTO waj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","I avu yaadudaivaadiri mminnamminnaa maisaivaa tee varaanarainnoo kiaa mmuaanaa i avuuvaa ranigaama kiee kagaari kiaanee. I avu mmuaavai nnaasu vaino fai hama i mmamma mmuakiaavai ikiaivaki kuanaraivo inna yoketaa aataruvai. ");
INSERT INTO waj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","I yaaku yaadudaivaadiri a reeti utuee reeri utinarainnoo kiaa mmuaanaa hatoka kiee kagaari kiaanee. I yaaku voovai hatoka kiee mmuaa yaakuvaata variee fai hama i mmamma mmuakiaavai ikiaivaki kuanaraivo inna yoketaa aataruvai. ");
INSERT INTO waj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Musiiva tuu kua voovai vainno tinoo: Vaidi voovoono ari nnaataivaara ooqoo kiaa kioo yanaivaa fafaarama kioo inna mmiaivee, ");
INSERT INTO waj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","tiivaara makee neenoo ngii giaa ngii miaunoo. Gioonnaivo hama sabi aataruuvau nuaikio ari vaatiivoono inna ooqoo kiaa kino vaati voovai varano mmuara vareera aataruuvo innaki vainaravai. Ari vaatiivoono inna titaivaara mmuara vareera aataruuvo innaki vainaravai. Fai vaidi voovoono itaama ii gioonnaivaa varano mmuara vareera aataruuvo innakiaatama vainaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Vo kuavai Musiiva vaidi nnaaru varuuyaata kiaa mmuuvaa vaa ngia rikiaavai. Ivo tunoo: A kua kutaama kiee tira kuaivaa sa hatokaanee. A yaagueeqama Udaanga Anutuuqaa avuuvau kianna kuaivaa iikianee, ");
INSERT INTO waj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","tuu kuaivaara neenoo ngii giaa ngii miaunoo. Sa vo mminnaavai nnutuuvaa tasipama ai yeena raira kuaivaa kianee. Ngiauvo inna Anutuuqo varira yoosinnaivaara sa ai kuaivaa yeena rainna ngiauvaa nnutuuvaa tasipama kiee kianee. ");
INSERT INTO waj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mmataivo Anutuuqo yuku yapeera yoosinnaivaara sa ai kuaivaa yeena rainna mmataivaa nnutuuvaa tasipama kiee kianee. Yerusareema inna ti kieeta pinaa ngiau aapu variivaa yoosinnaivaara sa ai kuaivaa yeena rainna Yerusareema nnutuuvaa tasipama kiee kianee. ");
INSERT INTO waj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hama a yopeema mmuaa kieeta yausiivai iino voovai eekaravai vaino voovai upisivai vainaraivaara sa ai kuaivaa yeena rainna ai kieetaivaa nnutuuvaa tasipama kiee kianee. ");
INSERT INTO waj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ai kuaivaa yeena rainna sa mminnaa voovai nnutuuvaa tasipama kiee kianee. Ee kianna kuaivaa kati ee-oo tiee hameetavee kianee. Ai kuaivaa yeena rau kiee vo kuavai tasipama kiannano mmannasa maisaivoono i tikiai itaa kua kiannanoo. ");
INSERT INTO waj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Musiiva nnaaru tuu kua voovai vaa ngia rikiaavai. Ii kua ivo vainno tinoo: Gioonna kiaapu voovoono gioonna kiaapu voovai avuuvaa rukuuma kino sai inna avuuvaa rukuuma kiaivee. Gioonna kiaapu voovoono gioonna kiaapu voovai avaivaa rutuuma kino sai inna avaivaa rutuuma kiaivee. ");
INSERT INTO waj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kuaivo itaa kua tiivaara neenoo ngii giaa ngii miaunoo. Gioonna kiaapu voovoono mmoori maisaivaa ngii iinai sa sai iikiatee. Gioonna kiaapu voovoono i kueenna yaadudaivaa rudaunai rikiee hanigia saivaata mmianee. ");
INSERT INTO waj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gioonna kiaapu voovoono i yaapa mmammayaa apuannaivaa varaanaraivaara kua pinaana i yapaanara tinai ai yaapa varaivaata mmianee. ");
INSERT INTO waj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Fai vaidi voovoono yaagueeqama i tinara: Vainima ni vitee kuanee, tinai sa vainima inna vitee kuanee. Ngieerama inna vitee kuanee. ");
INSERT INTO waj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gioonna kiaapu voovoono mminnaivaara i yapara rinai inna mmianee. Gioonna kiaapu voovoono i mminnaivaa varoo kava yapooma i mminaravee tinai sa ooqoo tirainna mmianee. ");
INSERT INTO waj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Musiiva nnaaru tuu kua voovai vaa ngia rikiaavai. Ii kua ivo vainno tinoo: I seenaiyara mmuduuya ruee i nnammutuaiyara sa mmuduuya ruanee, ");
INSERT INTO waj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","tiivaara neenoo ngii giaa ngii miaunoo. Ngii nnammutuaiyara mmuduuya ruatee. Gioonna kiaapuuya mmoori maisaivaa ngii mikiai iyara yaaku varaatee. ");
INSERT INTO waj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Fai ngia itaida ngii Gioova ngiau aapu variivaa raunna mmaapuya variaaravai. Fai Anutuuqo tino too suaivo gioonna kiaapu yoketaiyaata maisaiyaatama mmuaakaraama taanaravai. Anutuuqo tino too vatiivo gioonna kiaapu safuuma variraiyaata koonnama variraiyaatama mmuaakaraama ruanaravai. ");
INSERT INTO waj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gioonna kiaapuuya ngiiiyara mmuduuya ruaiyara nnaasu ngia sai iyara mmuduuya rida aanii irisai yoketaivaa Anutuuqaasidiri varaaraivaara ngia yaata utuaannee? Fai ngia hama varaaravee. Maisa vaidi sikau takiisa vareera vaidiiyaano ii aataru ivaa iikiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngia ngiingii seenaiyaata nnaasu kua tida hama ari vooyaata kua tiraida ngia itaama iikiaivaara hama ngia ari vo gioonna kiaapuuya iikiaa aataruuvaa yaataraanoo. Mmuaakaraama iikiaanoo. Vaidi hama Anutuuqaa kuaivaa rikieeraiya ii aataru ivaa iikiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ngia ngii Gioova ngiau aapu variivo yoketaa safu tuanaavai varineema ngieeta yoketaa safu tuanaaya variatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yisuuva itaa kua kiaa kioo tunoo: Tuqinnama taatee. Sa gioonna kiaapuuya ngii mannaka kiateeraivaara Anutuuqaa mmoori yoketaivaa iya avuuyauvunu iikiatee. Fai ngia iya avuuyauvunu itaama iikio too ngii Gioova ngiau aapu variivo hama irisai yoketaa voovai ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ivaara ngia mmanna haipu gioonna kiaapuuya mminnaiyauvaa mmiaaree kiaa sa puaisakama aayanna tida gioonna kiaapuuya avuuyauvunu mmiatee. Vaidi huoobavainna unnakua nnaamuru tuanaiya gioonna kiaapuuya tiiyara mannaka kiateeraivaara itaama nuunaira nnauvaki iida yoosinna vuutaivau iikiaavai. Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapuuya iya teeda iyara mannaka kiaa irisaivaa vaa iya varaavai. ");
INSERT INTO waj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngia mmanna haipu gioonna kiaapu voovai mminnaiyauvaa mmiaaree kiaa tadadama hataumakinaa mmiatee. Itaama mmikio hama ngii seena voovoono ngii taanaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Itaama vainai ngia tadadama hataumakinaa iikiaivaa ngii Gioova too irisai yoketaivaa ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ngia yaaku varaaree kiaa sa vaidi huoobavainna unnakua nnaamuru tuanaiya roosiima yaaku varaatee. Iya gioonna kiaapuuya tiiyara mannaka kiateeraivaara nuunaira nnauyauvakiaata yoosinna vuutaiyauvunuaatama dida vaida yaaku varaavai. Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapuuya iya teeda iyara mannaka kiaa irisaivaa vaa iya varaavai. ");
INSERT INTO waj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngia yaaku varaaree kiaa ngiingii nnauki vida sipuuvaa rau kiada ngii Gioova hama kooyaa variivaata kua tida yaaku varaatee. Ivoono ngia itaama hataumaki iikiaivaa taivoono fai irisai yoketaivaa ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ngia yaaku varada sa kaayau kua tasipama yaaku varaatee. Gioonna kiaapu hama Anutuuqaa kua rikieeraiya kaayau kua tasipama yaaku varada yaata utida kiaanoo: Ta hokobama yaaku varakio fai Anutuuqo ti kuaivaa rikiaanaravaivee, kiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sa iya roosiima yaaku varaatee. Yoketaama variraivo hama ngiiisi vaivaara ngia hama inna yaparairama kiada kati yaata utuaivaa ngii Gioova Anutuuqo vaa too rikiaivaara sa iya roosiima yaaku varaatee. ");
INSERT INTO waj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ataama yaaku varada kiatee: Ti Napoova a ngiau aapu variannaikua i nnutuuvo mmannammanna yaagueeqa yoketaa tuanaavai nnaasu vakiaivee. ");
INSERT INTO waj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A gioonna kiaapuuyara diraivaa kino too ngiaivee. I yaatayaa vai kuaivaa ngiau aapu variaiya iikiaaneema kinai ta mmatayaa variaunnaiya iikiaaravee. ");
INSERT INTO waj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aanna makee suai ta nnaara yeennaiyauvaa ti mmianee. ");
INSERT INTO waj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ta ti seenaiya mmoori maisaivaa ti mmiaani ta hama ivaara yaata utiraida ti ausa mmuduuyaiyauvaa iya mmiaunnaneema eenoo ti mminnamminnaa maisaiyauvaara sa yaata utirainna rugaanee. ");
INSERT INTO waj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sa ti vitee ti iinno taanara tiivaki ti yapaanee. Maisa aataruuvaudiri ti vitee yoketaivau ti yapaanee. (A gioonna kiaapuuyara diraivootama i yaagueeqaivoota i oyai ari vookaraivootama tupatupaa vakiaivee. Kua kutaa.) ");
INSERT INTO waj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ii kua ivo itaama vainai ngia gioonna kiaapuuya mmoori maisaivaa ngii iikiaiyara hama yaata utiraida ngii ausa mmuduuyaiyauvaa iya mmikio rikioo ngii Gioova ngiau aapu variivo ngii mminnamminnaa maisaiyauvaara hama yaata utirainno fai rugaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Fai ngia iya mmoori maisaivaa ngii miaivaara homo yaata utida hama ngii ausa mmuduuyaiyauvaa iya mmikio ngii Gioova hama ngii mminnamminnaa maisaiyauvaa rugaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ngia Anutuuqaara yaata utida yeennaivaa pikiada kati varira suaivaki sa vaidi huoobavainna unnakua nnaamuru tuanaiya roosiima ausa mmuaararai tasipama kua seemuaa variatee. Iya gioonna kiaapuuya ta Anutuuqaara yaata utida yeennaivaa pikiada kati variraivaa taateeraivaara kua seemuaa varida ngiari oori nnikiiyauvunudiri kainaamaiyauvaa hama finiraida kaupa kusiyaanna ngiari oori nnikiiyauvaki siikama kiada nookiaavai. Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapuuya iyara mannaka kiaa irisaivaa vaa iya varaavai. ");
INSERT INTO waj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngia Anutuuqaara yaata utida yeennaivaa pikiada kati varira suaivaki ngiengie iikiaivaungiaama iida ngiingii oori nnikiiyauvaa fini kiada ngiingii kieetaiyauvaa ugaka rummua kiada variatee. ");
INSERT INTO waj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Itaama iikiai teeda gioonna kiaapuuya ngia yeennaivaa pikiada kati variraivaa hama teeda rikiaaravai. Ngii Gioova hama kooyaa variivoono nnaasu too rikiaanaravai. Ngii Gioova ngia tadadama haumaki iikiaivaa too irisai yoketaivaa ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mmatayaa diaa mminnaa yoketaiyauvaa sa ngiingiiiyara yaata utida nuunama yapaatee. Fai ngia yapa kikio vooyauvai kaaka nneeno vooyauvai kegenaiyauvo hatokano vooyauvai mmuara vareera vaidiiya numa sipuuvaa rukaitu kiada ivakidiri mminnaiyauvaa ngiariyara mmuara varaaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sa iyauvaara nnaasu yaata utida pinaama mmoori vareerama kiada ngiau aapu vai mminnaa hama taikeeraiyauvaa fai yapooma varaaraivaara yaata utida mmoori pinaama iikiatee. Ngiau aapuuvaki vai mminnaiyauvo fai hama kaaka nneeno hama kegenaiyauvo hatoka nneeno hama vaidiiya numa sipuuvaa rukaitu kiada ivakidiri mminnaiyauvaa ngiariyara mmuara varaaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gioonna kiaapu voovoono mmatayaa mminnaiyauvaara mmuduuya ruoo fai ivaara nnaasu yaata utinaravai. Gioonna kiaapu voovoono ngiau aapu vai mminnaiyauvaara mmuduuya ruoo fai ivaara nnaasu yaata utinaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","A gioonna kiaapu voovoono i avuuvoono i mmammaivaara mmeekia roosiivai. I avuuvoono yoketaama taikiai mmeekiaivau nuairaivaa roosiima a yoketaama nookiannavai. ");
INSERT INTO waj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","I avuuvo upisiikiai a upisiivaki nuairaivaa roosiima hama a yoketaama nookiannavai. Fai ii mmeekia ivo iiki vaivo upisivai vainno fai kaayauma upisiinaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hama gioonna kiaapu voovoono yopeema taara vaidivaitanaani mmooriivaa varaivai. Fai itainnonno vuai vaidiivaara nnannatoo vuai vaidiivaara mmuduuya rinaravai. Fai itainnonno vuaivaasi vioo yaagueeqama mmooriivaa iinno vuaivaara nniki rakainno kiisama mmooriivaa iinaravai. Ivaa roosiima hama ngia yopeema Anutuuqaa mmooriivaata sikau varaara yaata utira aataruuvaatama mmuaavaugiataama iikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Itaama vaikiai na ngii giaa ngii miaunoo. Sa pinaama ngiengie mmatayaa variraivaara yaata utuatee. Sa ngiengie yeenna nnoori nnaaraivaara kaayauma yaata utida sa ngia ngiingii mmammayaa uyira rairaiyauvaara kaayauma yaata utuatee. Hama ngia yeenna nnaaraivaara nnaasu variaavai. Hama ngia ngiingii mmammaiyauvunu funnukakiaaraivaara nnaasu ngii mmammaiyauvo vaivai. ");
INSERT INTO waj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngiaasukuaa ngiau nuairaiyauvaa tuqinnama taatee. Hama iya vuayeennaiyauvaa hau utida tau ruaa rada ngiari yeenna yapa kieera nnauyauvaki yapa kiaavai. Ngii Gioova ngiau aapu variivoono yeennaiyauvaa iya mmiivai. Anutuuqo ngiiiyara tuqinneeraivoono ngiaasukuaiyara tuqinneeraivaa yaatara kiaivai. ");
INSERT INTO waj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ngiiikidiri deevoono ari varinaraivaara pinaama yaata utuoo oro hayu yapaanarannee? Hama yopeemavee. ");
INSERT INTO waj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mo aaniira ngia ngiingii uyira rairaiyauvaara kaayauma yaata utuaannee? Ngia tuqinnama mauraiyauvo mmatayaa uriiyauvaara yaata utida rikiaatee. Hama iyauvo vaidiiya ti roosiima ngiari uyira rairaiyauvaa iima kiada variaavai. Iyauvo kati ari mmaara urikiai taavo yoketaivai. ");
INSERT INTO waj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na ivaara ngii giaa ngii miaunoo. Itaama mauraiyauvo urikiai taavo yoketaiyauvoono nnaaruaa vaidi kieetaivaa nnutuuvo Soromoono ari mmammayaa uyira raira ari vookarauyauvaa uyuuyauvaa yaatara kiaivai. ");
INSERT INTO waj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ngia kiisama Anutuuqaara kutaavaivee kiaiyaso, maura ikiauyauvo makee uriiyauvaa turau vaidiiya hamuku kiada ikia mmuturuaaraiyauvaa Anutuuqo iyauvaa tuqinnaivai. Ivo mauraiyauvaa itaama tuqinnaineema ngiiiyaraatama tuqinnaanaravai. Ngii mmammayaa uyira rairaiyauvaa ngii minaraivaara ngia aaniira kaayauma yaata utuaannee? Fai ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ivaaraida sa ngia pinaama yaata utida kiatee: Dee yeennayauvai ta nnaarannee? Ta dee nnoorivai nnaarannee? Ta dee mminnaayauvai ti mmammayaa uyida raida kiaarannee? kiatee. ");
INSERT INTO waj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vaidi hama Anutuuqaa kua rikieeraiya ii mminnaa iyauvaa varaaraivaara yaata utuaavai. Ii mminnaa iyauvaa ngia varaaraiyauvo hameetaiyauvaa vaa ngii Gioova ngiau aapu variivo taivai. ");
INSERT INTO waj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sa iyauvaara yaata utuatee. Anutuuqo gioonna kiaapuuyara diraivaa varaaraivaara tauraa yaata utida Anutuuqaa aataru safuuvaa iikio fai Anutuuqo iyauvaa mmuakiaayauvai ngii minaravee. ");
INSERT INTO waj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ivaaraida sa turaura kaayauma yaata utida ausa mmuaararakiatee. Turau suaivaki ari mmaraama ivakira yaata utira aataruuvo vainaravai. Mmuaa suai mmuaa suaiyauvaki mmuaararai aataruuyauvo ii suai iyauvaki ari mmaraama vaivaivee. ");
INSERT INTO waj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yisuuva itaa kua kiaa kioo tunoo: Anutuuqo ngii mmoori aataruuyauvaa too sa maisavee kiaiveeraivaara gioonna kiaapu vooya mmoori aataruuyauvaa sa teeda maisavee kiatee. ");
INSERT INTO waj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngia gioonna kiaapuuya mmoori aataruuyauvaa teeda maisavee kiaivaa irisaivo mmuaakaraama vainaraivaara sa itaa kua kiatee. ");
INSERT INTO waj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mmummuuvo i seenaivaa avuuvaki vaivaa aaniira a tee ivaara kiannannee? Iri pinaivo i avuuvaki vaikiainnaata hama a ivaa taannanoo. ");
INSERT INTO waj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Iri pinaivo i avuuvau vaivaa hama teerama kieenna dataama i seenaivaa kiannanoo: Nninai na i avuuvaudiri mmummu kiisaivaa feenaanaravee, kiannannee? ");
INSERT INTO waj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A huoobava unnakua nnaamuru tuanaakuavee. Tauraa iri pinaivo i avuuvau vaivaa utu rada kiee eennaadee ai avuuvaa tuqinnama tee nnaagiai i seenaivaa avuuvaudiri mmummuuvaa feenaanee. ");
INSERT INTO waj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Gioonna kiaapuuya homo ngiari ausaiyauvo puara mmararaivaa roosiikiaiya sa Anutuuqaa mmayaaya yoketaa tuanaivaa iya kiaa mmiatee. Fai kiaa mmikiai rikiada iya faiya roosiima hanigiada ngii gutuaara iirayaama fai ngii kuaivaara maisavee kiaaravai. Gioonna kiaapuuya Anutuuqaa kuaivaara ooqoo tiraiya sa inna kuaivaa iya kiaa mmiatee. Fai kiaa mmikiai rikiada iya puaraiya sikau seeta poosa kuaivaa yoonna reerayaama ngii kuaivaara ooqoo kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ngia Anutuuqaa yaparaikio fai ngia yaparakiaivaa ngii minaravai. Mminnaa voovaara buaida teekio fai ngii too vainaravai. Sipuuvau rikiokio fai Anutuuqo sipuuvaa ngiiini hatuaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gioonna kiaapu Anutuuqaa yaparaivoono fai ari yaparaivaa varaanaravai. Gioonna kiaapu voovoono fai mminnaivaara buainnonno teeno fai inna too vainaravai. Gioonna kiaapu voovoono sipuuvau rinono fai Anutuuqo innani sipuuvaa hatuaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Vaidi voovoono ngiiikidiri ari mmaapuuvo yeennara inna yaparaino hama fai sikauvaa inna mminaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ari mmaapuuvo tavaura numa inna yaparaino fai hama yapaivaa inna mminaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ivaara ngia mmatayaa maisama variaiya mminnaa yoketaiyauvaa ngiingii nnaakaraiya mmiaa aataruuvaa vaa ngia taavai. Ngii Gioova ngiau aapu variivo ngia ngiingii nnaakaraiya mminnaa yoketaiyauvaa mmira aataruuvaa yaataraivoono gioonna kiaapu inna yaparakiaiya mminnaa yoketaiyauvaa iya mminaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Gioonna kiaapuuya mmoori mmuakiaavai ngiiiyara iikiaavo ngii yoketaivaara ngieeta mmuaikaraama iyara iikiatee. Anutuuqo mmaanna tuu kuaiyauvaata forofetaiya kiaa mmuu kuaiyauvaatama oyaivo itaama vaivai. ");
INSERT INTO waj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ngia kiisa keegiaidaa kuatee. Keegia pinaivaki kuai aataru hoonuruuvo ikia aakiaivakira kuai aataruvai. Kaayau gioonna kiaapuuya ivaki kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Keegia tupatupaa variraivaki kuaivo kiisa keegiavai vaivai. Kiisa gioonna kiaapuuya nnaasu ivaki kuaavo aataruuvo kaayauma iya mmuaararaivai. ");
INSERT INTO waj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Vaidi forofetaa unnakua nnaamuruuyara tuqinnama haitatuukiatee. Ngia iya mmamma mmaanaiyauvaa teeda kiaanoo: Puara sipisiipa roosiima yoketaakiaayavee, kiaavo iya aakiaiyauvo fai mmararaa avaikaraivaa roosiivai. ");
INSERT INTO waj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ngia yatari iiraivaa nneeda taavo yatari voovai yoketaavai vaikio yatari voovai maisavai vaivai. Ivaa roosiima fai ngia forofetaiya iira aataruuyauvaa teeda iya aakiaiyauvakiaatama tuqinnama taaravai. Hama ngia ooviivaudiri vuaina iiraivaa rasuku varaavai. Hama ngia ooviivaudiri nnaammuaya iiraivaa rasuku varaavai. ");
INSERT INTO waj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yatari yoketaivau iira yoketaivo vaikio yatari maisaivau iira maisaivo vaivai. ");
INSERT INTO waj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yatari yoketaivau hama iira maisaivo yopeema ivau vaikio yatari maisaivau hama iira yoketaivo yopeema ivau vaivai. ");
INSERT INTO waj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yatari hama iira yoketaa vaiyauvaa vaidiiya hanaa rakau ikiana kagaari kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ivaa roosiima fai ngia vaidi forofetaa unnakua nnaamuruuya iira aataruuyauvaa teeda iya aakiaiyauvakiaatama tuqinnama taaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mmuakiaa gioonna kiaapuuya niiyara Udaanga-o kiaiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki fai hama kuaaravee. Gioonna kiaapuuya ni Napoova ngiau aapu variivaa kuaivaa tuqinnama rikiada iikiaiya nnaasu fai ivaki kuaaravee. ");
INSERT INTO waj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anutuuqo gioonna kiaapuuya mmooriiyauvaara iya yaparainara suaivaki fai kaayau gioonna kiaapuuya numa ni kiaara: Udaanga-o, ta vaa aiyara yaata utida Anutuuqaa mmayaayaivaa gioonna kiaapuuya kiaa mmida i nnutuuvaa tida kaayau mmagia maisaiya vaidi aakiaiyauvakidiri titaunnani kuaani ari vookara ari vookarai mmooriiyauvaa i nnutuuvaa tasipama iikiaunnavaivee, ");
INSERT INTO waj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","tikiai na iya tinara: Ngia maisa mmoori iira nnaamuruyavee. Hama na ngii tauyavee. Ngieera kuatee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ivaarainno gioonna kiaapu voovoono ii na kiau kua ivaara tuqinnama rikioo iivoono vaidi tinni yoketaivoono mmata yakeevau ari nnauvaa heekaivaa roosiivai. ");
INSERT INTO waj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ivo mmata yakeevau ari nnauvaa heeka kiaikio vatiivo pinaama ruaikio nnooriivo pinaama haikio yuunna yaamurukaivo kaayauma utikio too ari nnauvo vaa mmata yakeevau heeka kiaivoonora tioo hama havarataivai. ");
INSERT INTO waj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Gioonna kiaapu voovoono ii na kiau kua ivaa vaa rikioo hama iivoono vaidi kumimakaivo mmata muaraagaivau ari nnauvaa heekaivaa roosiivai. ");
INSERT INTO waj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ivo mmata muaraagaivau ari nnauvaa heeka kiaikio vatiivo pinaama ruaikio nnooriivo pinaama haikio yuunna yaamurukaivo kaayauma utuoo nnauvaa ruoo ruoo ravagiau yautu ruaikio kurummutu kioo mmatayaa vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yisuuva ii kua ivaa kiaa taika kiooduu gioonna kiaapuuya iva tuu kuaivaara nnikiarauduu ");
INSERT INTO waj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ivo hama kua mmaanna kiaa mmira vaidiiya roosiima tirainno ari vookarau yaagueeqaivo inna tasipooduu kuaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisuuva kiaa taika kioo taapi kiisaivaudiri pikioo hoonuruuvau tuuduu teeda kaayau gioonna kiaapuuya inna vata rada viravai. ");
INSERT INTO waj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Vuduu too vaidi buunna hooya mmamma roosuuvoono numa Yisuunna yuku oyaivaki toorivu yau haroo inna tunoo: Udaanga-o, mo fai a ni mmammaivaa tuqinnaanaree tiee fai a aikiooma tuqinnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","tuduu rikioo Yisuuva ari yaakuuvaa reeti innayaa utuoo tunoo: Fai na i tuqinnaanaravaivee. Na tino i mmammaivo yoketaakiaivee. Ivo itaa kua tuu saivaata inna mmamma buunna hooya mmamma roosuuvo taikeeravai. ");
INSERT INTO waj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Taikooduu too Yisuuva tunoo: Na i iikiauvaara sa gioonna kiaapu voovai kiaa mmianee. Akiairaama viee Anutuuqaara kati puara hudeera vaidiivaa i mmammaivaa vitainna nnaaruaa vaidi Musiiva tuuvaugiataama puara sipisiipaivaa kati ruputu kiee Anutuuqaara hudaanee. Hudanai rikiada gioonna kiaapuuya i mmammaivo yoketaivaara arinaima teeda rikiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yisuuva itaa kua kiaa kioo ivau pikioo yoosinna Kapanauma vuduu too Roomaaya rapira ngiaammuauya kieeta voovoono numa Yisuunna yaagueeqama yaparainno tunoo: ");
INSERT INTO waj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Udaanga-o, ni mmoori vareera ngiaammuau voovai kaayauma nniitaraikio yuku yaakuuvo putikio vainoo, ");
INSERT INTO waj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","tuduu rikioo ivo inna sai tunoo: Fai na innasi viee inna tuqinnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","tuduu rikioo vaidi rapiraiya kieetaivo inna tunoo: Udaanga-o, sa niiyara yaata utuanee. Na vaidi kiisavaivee. A vaidi nnoonnakuavee. Hama na yopeema tinai a ni nnauki nninaravee. Kati tino too ni mmoori vareera ngiaammuauvaa mmammaivo yoketaakiaivee. ");
INSERT INTO waj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na ari vo vaidi kieetaya mmoori varau vaidivai variauvai. Na iya mmooriivaa varee variee rapira ngiaammuauyara diauvai. Ivaara na voovai kiaunoo: Kuanee, kiauko kuaivai. Na voovai ngianee kiauko ivo nniivai. Na sikaunnaadiri yookaama kiee viteera ngiaammuau voovai kiaunoo: Aa mmoori aavaa iikianee, kiauko iivaivee. Vaa na itaama variee tauvaara kati tino too ni mmoori vareera ngiaammuauvaa mmammaivo yoketaakiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tuduu rikioo Yisuuva iva tuu kuaivaara nnikiarainno hanigia gioonna kiaapuuya inna vata rada nnuuya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Hama na tauko vaidi Isarairaa voovoono aa vaidi aavaa roosiima yaagueeqainno niiyara kutaavaivee tiivai. ");
INSERT INTO waj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na ngii giaa ngii miaunoo. Kaayau gioonna kiaapu suai raari raipidiri suai haatapaipidiri ngiaiya numa Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki nnaaru varuu vaidi Aaparahaamo Isaako Yakoopainna tasipama fai yeenna nnaaravai. ");
INSERT INTO waj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gioonna kiaapu Yutayaiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki variataama kiadaata rikiakio Anutuuqo iya ooqoo tinai mmaanai upisiivaki varida teekio iya nnannateenai fai ngiari avaiyauvaa hakutikio iya ausaiyauvo mmuaarareenai rataaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","kiaa kioo Yisuuva rapira kieetaivaa tunoo: Ai nnauki kuanee. Viee a ni yaparakianna kuaivaara fai kutaa iinaravee tinai fai na aini iinaravaivee, tuduu rikioo vioo rikiooduu Yisuuva itaa kua tuu saivaata inna mmoori varoo ngiaammuauvaa mmammaivo yoketairavai. ");
INSERT INTO waj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yisuuva Petoroosaa nnauvaki vioo tooduu Petoroosaa nnummuayaanna mmammaivo ikiayanaa tooduu mmaatayaa nnaasu vauduu ");
INSERT INTO waj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yisuuva innasi vioo inna yaakuuvau utuduu ikiayanaivo taikooduu diitoo Yisuunna yeennaivaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mmuduu hannauduu teeda gioonna kiaapu vooyaano ngiari seena gioonna kiaapuuya aakiaiyauvaki mmagia maisaiyauvo varuuya vitada Yisuunnasi nnuduu Yisuuva mmagia maisaiyauvaa tuduu iya aakiaiyauvakidiri pikiooduu mmuakiaa nniitarooya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nnaaruaa vaidi forofetaa Yisayaava tuu kuaivo vaududuu Yisuuva varuu suaivaki kaanaivo vairavai. Yisayaava tuu kuaivo vainno tinoo: Ivo ariinoo ti nniitarai mmuakiaayauvai rugaivaivee, tiivai. ");
INSERT INTO waj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yisuuva gioonna kiaapuuya inna suvuauya too ari ngiaammuauya tunoo: Nnikiai ta nnoori haruungaivaa sainai kuaaravee, ");
INSERT INTO waj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","tuduu too kua mmaanna kiaa mmira vaidi voovoono innasi ngioo tunoo: Vitaira-o, a kuanara yoosinnaiyauvaki fai neeta i tasipama kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","tuduu rikioo Yisuuva inna kua sai tunoo: Fayaiya ngiari nnaamuruuyauvaki vakiaavai. Ngiaammaiya ngiari ngiisaiyauvaki vakiaavai. Na Vaidiivaa Mmaapuuvoono hama na vuru vaira nnauvootainoo, ");
INSERT INTO waj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","tuduu rikioo vaidi voovai inna nnaagiai nuauvo inna yaparainno tunoo: Udaanga-o, kii na varinono ni napoova putinai hau kiee i nnaagiai kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","tuduu rikioo Yisuuva inna sai tunoo: Pikiee ni nnaagiai ngianee. Vaidi koonnama variaiya putuaiya roosiikiaiyaano ngiari seena vaidi putuaiya hakuatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisuuva ari ngiaammuauyaatama kanuuvaki karada vida varuduu ");
INSERT INTO waj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","akiairauduu yuunna yaamurukaivo nnooriivaudiri nnuduu nnooriivo korokoroonno ketekaateenno kanuuvaki ngioo vioo mmuugiainara uuduu too Yisuuva vuru vauduu ");
INSERT INTO waj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ari ngiaammuauya innasi vida yuruuma kiada tunoo: Udaanga-o, ti vita yoketaivau yapaanee. Nnooriivo kiisa suai ti raputinara iinoo, ");
INSERT INTO waj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","tuduu rikioo Yisuuva iya sai tunoo: Ngia aaniira aatuuda variaannee? Hama ngia kiisama niiyara kutaavaivee kiaanoo, kiaa kioo diitoo yuunnaivaata nnooriivaatama yaagueeqama ooqoo tuduu pikiooduu tirooma variravai. ");
INSERT INTO waj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Varuduu ari ngiaammuau mmuakiaaya innara nnikiaraida tunoo: Aa vaidi aavo datai vaidivainnee? Ivo yuunnaivaata nnooriivaatama tikiai rikiada akiairaama taikaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yisuuva nnoori haruungaivaa sainai vau mmataivaa nnutuuvo Keraseenga vioo kanuuvaa pikioo reemi roo vioo tooduu vaidi putuuya hau oonauyauvakidiri vaidi taaravaitana inna saidi tiiravai. Ii taara vaidi ivaitana aakiaivaitanaki mmagia maisaiya topauduu rikiada avaikarauduu teeda gioonna kiaapuuya ivaitana varuupinnai kuaara aatuuda hama viravai. ");
INSERT INTO waj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yisuuva nnuu saivaata mmagia maisa topau vaidiivaitana puaisakama aayanna reeda tunoo: A Anutuuqaa Mmaapukuavee. A aaniivai ti iinarainna ngiannannee? Homo ti varira suaivo vainoo. Anutuuqo ti yaparaira suaivo hama nnikiai a numa ti ruputinarainna ngiannannee? ");
INSERT INTO waj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","tuduu rikiada ukuapinnaigiataa kaayau puaraiya yeenna nneeda varuduu ");
INSERT INTO waj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","mmagia maisaiya vaidiivaitanaki varuuya yaagueeqama Yisuunna yaparaida tunoo: A ti titaanaree tiee ti titanai ukuai puara aaya aakiaiyauvaki ta kuaaravee, ");
INSERT INTO waj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","tuduu Yisuuva rikioo iya tunoo: Kuatee, tuduu rikiada mmagia maisaiya vaidiivaitana aakiaivaitanakidiri pikiada puaraiya aakiaiyauvaki viravai. Vuduu mmuakiaa puaraiya rereevau mmeepi seenada vida nnoori haruungaivaki vida putu taika kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Putu taika kiooduu vaidi puaraiyara haitatuuraiya seenada yoosinnaivaki vida Yisuuva uu mmayaaya mmuakiaavai gioonna kiaapuuya kiaa mmida iya Yisuuva vaidiivaitana uu mmayaayaivaata puaraiya uu mmayaayaivaatama gioonna kiaapuuya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kiaa mmuduu rikiada mmuakiaa gioonna kiaapu ivaki varuuya Yisuunnasi nnida inna teeda ivo iya mmataivakidiri pikioo kuaiveera yaagueeqama inna titeeravai. ");
INSERT INTO waj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Titooduu Yisuuva kanuuvaki karoo kava vara ranoo nnoori sainai ari yoosinnaivaki oro hara kioo varuduu ");
INSERT INTO waj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","vaidi vooyaano vaidi voovai yuku yaaku putuuvaa ari kegeennaivau vuru vauvaa taina rau varada Yisuunnasi nnuduu rikioo iya ngiari yaata tinniiyauvaki vau kuaivaa Yisuunnara tunoo: Ivo aikiooma tuqinnaanaravaivee, tuu kuaivaa Yisuuva rikioo vaidi yuku yaaku putuuvaa tunoo: Boo, ni vaidivai. Sa yaata utirainna yaagueeqama varianee. Vaa na kiauko i mminnamminnaa maisaiyauvo taikainoo, ");
INSERT INTO waj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","tuduu rikiada vaidi kua mmaanna kiaa mmira vooyaano ngiari yaata tinniyaa vau kuaivaa yaata utida tunoo: Aqaa vaidi aavoono ariiyara yaata utuoo Anutuuqaa roosiima kua tinoo, ");
INSERT INTO waj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","tuduu rikioo Yisuuva iya yaata tinniyaa vau kuaivaa rikioo iya tunoo: Ngia aaniira ngii yaata tinniyaa vai kua maisaivaa yaata utida itaa kua kiaannee? ");
INSERT INTO waj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na tinara kuaivo dee kuavainno yoketainnee? Vara dee kuavainno ari vookarainnee? Fai na tinara: Vaa na kiauko i mminnamminnaa maisaiyauvo taikainoo, tinarannee? Vara na tinara: Diitee kuanee, tinarannee? ");
INSERT INTO waj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aa mmata aavau na Vaidiivaa Mmaapuuvoono vaidiiya mminnamminnaa maisaiyauvaa rugeeraivaa nakaaraivovee. Fai na iinai ngia ivaa taaravaivee, kiaa kioo vaidi yuku yaaku putuuvaa tunoo: Diitee ai kegeennaivaata varee ai nnauki kuanee, ");
INSERT INTO waj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","tuduu rikioo diitoo ari nnauvakira viravai. ");
INSERT INTO waj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vuduu rikiada gioonna kiaapuuya ivaa teeda aatuuda Anutuuqo ari yaagueeqaivaa vaidiiya mmuuvaara kua yoketaivaa innara tiravai. ");
INSERT INTO waj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisuuva ii yoosinna ivakidiri pikioo nuainnonno tooduu sikau takiisa vareera vaidi Mataiva ari sikau takiisa vareera nnauvaki hara kioo varuduu inna tunoo: Ni nnaagiai ngianee, tuduu rikioo Mataiva diitoo inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yapooma Yisuuva Matainna nnauvaki yeenna nnoo varuduu kaayau sikau takiisa vareera vaidi maisa vooyaata mmaanna tuu kuaivaa hatokeera gioonna kiaapu maisa vooyaatama numa Yisuunnaata ari ngiaammuauyaatama tasipama yeenna nneeravai. ");
INSERT INTO waj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yeenna nneeda varuduu Farisai vaidi vooya numa iya teeda Yisuunna ngiaammuauya yaparaida tunoo: Mo aaniira ngii vitairaivo sikau takiisa vareera vaidi maisaiyaata mmaanna tuu kuaivaa hatokeera gioonna kiaapu maisaiyaatama yeenna nnainnee, ");
INSERT INTO waj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","tuduu rikioo Yisuuva iya kuaivaa sai tunoo: Gioonna kiaapu homoraiya hama kuminayaa nniitareeraiya tuqinneera vaidiivaasi kuaavai. Gioonna kiaapu nniitareeraiya nnaasu innasi kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Anutuuqaa kua fafaara roo kuaivo vainno tinoo: Vaidiiya puara sipisiipaiyauvaa kati niiyara hudaivaara hama ni yoketainoo. Vaidiiya ngiari seenaiyara mmuduuya ruaiyara ni yoketainoo. Kua fafaara roo kuaivo itaa kua tiivaa ngia oro yaarida oyaivaara tuqinnama rikiaatee. Gioonna kiaapuuya ngiariiyara yaata utida yoketaayavee kiaiyara hama na iyara maavee tinaraivaara tiiravai. Gioonna kiaapuuya mminnamminnaa maisa suvuaiyara na maavee tinaraivaara tiiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tuduu Yuvuaano nnoori apira vaidiivaa nnaagiai nuairaiya numa Yisuunna yaparaida tunoo: Mo dataikiaida ta Yuvuaanaa nnaagiai nuairaiyaata Farisaiya nnaagiai nuairaiyaatama Anutuuqaara yaata utida yeenna nneeraivaara makemakee ooqoo kiaa kiada kati variaunnani i nnaagiai nuairaiyaida mmuakiaa suai hama itaa kiaannee? ");
INSERT INTO waj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","tuduu Yisuuva mmataira kuaivaa iya sai tunoo: Yaapeeri nneera suaivaki kieevatiivo gioonna kiaapuuya tasipama varikiai ivaki variaiya hama ausa mmuaararaikiai iya sirigaida variaavai. Fai suai voovai nninai rikiada vaidiiya kieevatiivaa vitada ruputikiai iqii suai iyauvaki iya yeenna nneeraivaara ooqoo kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hama gioonna kiaapu voovoono nnisi buruqa tapasiivaki karaasa buruqa kiisaivaa hatoka funnivai. Fai funnu kioo nnooriivakidiri fini kino rikioo karaasa buruqaivo yaagueeqainno nnisi buruqaivaa utu rapasi kino rikioo pinaama tapasinaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hama gioonna kiaapuuya vuaina suuya karaasaivaa puara nnaba funnu kiaa nnisiivaki tusaa uyuaavai. Fai tusaa uyu kikio vuaina suuyaivo vainno yootano puara nnaba nnisiivo rusitinaravai. Rusitino rikioo vuaina suuya karaasaivo tuoo vino puara nnabaivo maisainaravai. Iya vuaina suuyaivaa puara nnaba karaasaivaki tusaa uyuaavai. Tusaa uyu kiaavo suuyaivoota nnabaivootama yoketaama vaivaivee. Yisuuva nnisi aataruuvoota karaasa aataruuvootama hama yoketaama mmuaavau vauvaara itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yisuuva itaa kua tuu saivaata Yutayaiya kieeta vaidi voovoono numa Yisuunna too ngioo varoo inna yuku oyaivaki toorivu yau haroo tunoo: Ni naunnaivo aa ikiataa putinoo. Fai a numa innayaa ai yaakuuvaitana utino too ivo diitoo kati hara kioo varinaravee, ");
INSERT INTO waj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","tuduu rikioo Yisuuva diitoo inna tasipama vuduu ari ngiaammuauyaatama viravai. ");
INSERT INTO waj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Vida varuduu gioonna voovoono kabaa vira aataruuvo tupatupaa innaki vaududuu nuanu yaakuuvaitana yukukidiri taara nuanu taika kioo varuu gioonnaivo ariiyara yaata utuoo tunoo: Fai na inna buruqaivau utino too na kabaa kuau aataruuvo taikanai na kava kati hara kiee varinaravaivee, kiaa kioo numa Yisuunna mmookainnidiri dioo vainno inna buruqa araivau utuduu rikioo ");
INSERT INTO waj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yisuuva hanigia inna too tunoo: Ni nunnakuavee. Sa yaata utuanee. A niiyara kiannanoo: Aikiooma ni tuqinnaanaravaivee, kiannaivaarainna vaa a yoketaama hara kiee variannanoo, tuduu tuu saivaata gioonnaivo kabaa vuu aataruuvo taikeeravai. ");
INSERT INTO waj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Taikooduu Yisuuva vaidi kieetaivaa nnauvaki vioo tooduu kiaatannaivaa hakuaaraivaara vaidiiya noomaiyauvaa ruduu gioonna kiaapuuya nuunaida kaayauma ratada varuduu ");
INSERT INTO waj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yisuuva oro iya tunoo: Mmuakiaaya mmaanai kuatee. Hama kiaatannaivo putivai. Kati vuru vainoo, tuduu rikiada iya vaa kiaatannaivo putuuvaa teeda Yisuunnara pinaama rairavai. ");
INSERT INTO waj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Raida varuduu iya titooduu mmaanai vuduu rikioo kiaatannaivo vauvaki Yisuuva oro inna yaakuuvau utuduu diiteeravai. ");
INSERT INTO waj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ivo itaama diitoo mmayaayaivaa mmuakiaa gioonna kiaapuuya kiaatannaivo varuu yoosinnaivaa vaini varuuyaatama rikieeravai. ");
INSERT INTO waj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yisuuva ii yoosinna ivaki pikioo nuainnonno vaidi avu huruuta taaravaitana varuuvaki nnuduu rikiada ivaitana inna vata rada vida aayanna reeda tunoo: Davuitiinna oyaivakidiri diiteeraikuavee. Tiiyara boo kianee, ");
INSERT INTO waj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","tuduu Yisuuva nnauvaki vuduu rikiada ivaitana innasi nnuduu iva ivaitana yaparainno tunoo: Ngia dataamaida yaata utuaannee? Avuuyauvaa tuqinnaanara yaagueeqaivo niiki vainnee? Vara hama niiki vainnee? tuduu rikiada ivaitana inna sai tunoo: Yo, Udaanga-o, fai a ti avuuvaitana tuqinnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","tuduu rikioo Yisuuva ivaitana avuuvaitanau utuoo tunoo: Ngia kutaa itaama tuqinnaanaravee kiaivaugiataama vakiaivee, ");
INSERT INTO waj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","tuduu rikioo ivaitana avuuvaitana yoketauduu Yisuuva yaagueeqama ivaitana tunoo: Sa ivaara gioonna kiaapuuya kiaa mmiatee, ");
INSERT INTO waj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","tuduu rikiada hama iva tuu kuaivaa rikieerama kiada ivau inna pikiada ivo ivaitana avuuvaitana tuqinnoo mmayaayaivaa mmuakiaa vaini varuu yoosinnaiya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Vaidiivaitana ivau inna pikiada vuu saivaata vaidi voovai ari aakiaivaki mmagia maisaivo topaama kioo varuduu inna avaivo ramuunnaama kioovaa vaidi vooya vitada Yisuunnasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nnuduu too Yisuuva mmagia maisaivaa titooduu vioo kiooduu vaidiivo kua tiravai. Kua tuduu rikiada mmuakiaa gioonna kiaapuuya nnikiaraida tunoo: Hama nnaaru Isarairaiyakidiri atau mmoori voovai vauduu teeravaivee, ");
INSERT INTO waj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","tuduu rikiada Farisai vaidi vooya tunoo: Mmagia maisaiya kieetaivoono inna tasipama varioo yaagueeqaivaa inna mmikioonno mmagia maisaiya vaidi aakiaaki variaiya titaikiai kuaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisuuva mmuakiaa yoosinna kiisa kiisaiyauvakiaata yoosinna pinaiyauvakiaatama vioo ngiari nuunaira nnauyauvaki vioo Anutuuqaa mmoori aataruuyauvaa gioonna kiaapuuya vitairavai. Vitainno Anutuuqo gioonna kiaapuuyara dira mmayaaya yoketaivaa iya kiaa mmioo mmuakiaa nniitaroo ari vookara ari vookarauyauvaa tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iya tuqinnoo suaiyauvaki kaayau gioonna kiaapu nuunauya too iyara boo tiravai. Iya puara sipisiipa hama haitatuura vaidiaatauvaa roosiima varida airi airi yaata utida ngiari vo vuayaata utida varuuvaara Yisuuva iyara boo tiravai. ");
INSERT INTO waj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Boo tioo ari ngiaammuauya tunoo: Mmooriivaki yeennaiyauvaa kaanaiyauvo suvuaikio vaa nneeravaata vaikiai iyauvaa vareeraiya mmuaa taaraya variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Itaama vaikio mmoori nakaaraivo yeenna vareera gioonna kiaapu vooya titanai ari mmooriivakidiri kaanaiyauvaa varada inna nnauvaki yapaateeraivaara yaaku varaatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisuuva ari ngiaammuau yaakuuvaitana yukukidiri taarama innasi ngiateera tiravai. Tuduu rikiada innasi nnuduu gioonna kiaapuuyakidiri mmagia maisaiya titakiai kuateera yaagueeqaivaa iya mmiravai. Mmioo gioonna kiaapuuya nniitaroo mmuakiaa ari vookara ari vookarauyauvaa tuqinnaateera yaagueeqaivaatama iya mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ii vaidi yaakuuvaitana yukukidiri taarama kua varada nookiaara idaa nnutuudo ataama vainoo. Tauraivaa nnutuuvo Simoono inna nnutu vuaivo Petorooso inna kataivaa nnutuuvo Adiriaaso Sevetainna mmaapuuvaitana voovai nnutuuvo Yakoopo vuaivaa nnutuuvo Yuvuaano ");
INSERT INTO waj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","voovai nnutuuvo Piriipo voovai nnutuuvo Batoromaiva voovai nnutuuvo Tumaaso sikau takiisa vareera vaidiivaa nnutuuvo Mataiva Arapainna mmaapuuvaa nnutuuvo Yakoopo voovai nnutuuvo Tariaaso ");
INSERT INTO waj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","vaidi vooya inna mmataivaa varoovaara kaayau rapira vaidiivaa nnutuuvo Simoono nnaagiaivaa nnutuuvo Yutaaso Isariootovee. Ivoono nnaagiai Yisuunna nnammutuaiya kooyaa inna vitainaraivaara kua yeena rau kieera vaidivai. ");
INSERT INTO waj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisuuva ari ngiaammuau yaakuuvaitana yukukidiri taarama titoo aa kua aavaa iya kiaa mmioo tunoo: Sa vaidi voopinnaiya yoosinnaiyauvaki kuatee. Sa vaidi Samariaaya yoosinnaiyauvaki kuatee. ");
INSERT INTO waj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gioonna kiaapu Isarairaiya puara sipisiipa roosiima raubiriikiaiyasi kuatee. ");
INSERT INTO waj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Vo yoosinna vo yoosinnaiyauvaki vida varia rada Anutuuqaa mmayaayaivaa kiaa mmiaa rada kiatee: Anutuuqo gioonna kiaapuuyara dira suaivo aa vainima nninoo, kiatee. ");
INSERT INTO waj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gioonna kiaapu nniitaraiya tuqinnaatee. Vaa putuaiya tikiai kava diitaatee. Iya mmammaiyauvo buunna haiya mmamma roosiikiaiya tuqinnaatee. Mmagia maisaiya iyakidiri titakiai kuatee. Hama ngia sikauvaa kagaari kiada ni yaagueeqaivaa niisidiri varaivaara sa sikauvaara yaata utuatee. Kati ni mmooriivaa iikiatee. ");
INSERT INTO waj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sa ngii sikauyauvaa ngiingii utuaiyauvaki rummua varada kuatee. ");
INSERT INTO waj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sa aataruuvaura mminnaiyauvaa vara rira utuaiyauvaa varada kuatee. Sa ngii yaapaiyauvaa taara tida varada kuatee. Mmuaa tida mmuaa tida nnaasu varada kuatee. Sa ngii yuku nnaba vooyauvaatama varada sa yau kurida nuairaiyauvaatama varada kuatee. Ngiengie mmoori varaivaudiri irisaiyauvo vaiyauvaa ngii mikiai nnaaraivaara nnaasu yaata utida kuatee. ");
INSERT INTO waj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ngia pinaa yoosinna voovakinnee vara kiisa yoosinna voovaki vida teekio vaidi yoketaa voovoono ngii too ngii maavee tinai rikiada inna nnauvaki vida inna tasipama varida ngia vira suaivau inna pikiada kuatee. ");
INSERT INTO waj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Inna nnauvaki vira suaivau iyara yoketaa kuaivaa kiaa kiada kuatee. ");
INSERT INTO waj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Vikiai rikiada fai ausa mmuduuyaiyauvaa ngii mikio ausa nuufaivo iyaki vakiaivee. Fai iya yakeema varikio ausa nuufaivo ngiingiiiki vakiaivee. ");
INSERT INTO waj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Fai ngia yoosinna voovakinnee vara nnau voovaki vida teekiai hama iya ngiiiyara tuqinnada hama ngii kuaiyauvaa rikikiai teeda ngiingii yukuuyauvunudiri kufukuufaiyauvaa rututuooma kiada ivaki pikiada vida kiaatee. ");
INSERT INTO waj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na kua kutaavai ngii giaa ngii miaunoo. Anutuuqo gioonna kiaapuuya yaparaira suaivaki gioonna kiaapu yoosinnaivaitana Sutuuma Kumuara maisama varuuya ngiari mmoori irisaivaara Anutuuqo iyara boo tioo hama irisai pinaa maisaivaa iya mminaravai. Gioonna kiaapuuya hama ngiiiyara yoketaakiaiya fai ngiari irisai maisaivo Sutuuma Kumuara varuuya irisai maisaivaa yaataraanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Rikiaatee. Ngia puara sipisiipaiya roosiima tirooma variaiya fai na ngii titanai fai mmararaa roosiikiaiyasi kuaaravai. Yapaiya tadadama nuairayaama ngii nuairaivaara tuqinnama yaata utu kiada nookiatee. Ngiaamma mirunnaiya tirooma variraivaa roosiima koonnakaannama nuairaivaa pikiada tirooma variatee. ");
INSERT INTO waj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Vaidiiyara aatuuma rada nookiatee. Fai vaidi vooya ngii vitada ngiari kieetaiyasi kua pinaana ngii yapa kiaaravai. Iya ngii vitada ngiari nuunaira nnauyauvaki kiada ngii ripiikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ngia niiyara kutaavaivee kiaivaara fai iya ngii vitada vaidi kieetaiyasi vida kua pinaana ngii yapa kikiai ngia ni mmayaaya yoketaivaa vaidi kieetaiyaata vaidi ngiari voopinnaiyaatama kiaa mmiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Iya ngii vitada kua pinaana ngii yapa kikiai sa ngia iya sai kiaara kuaivaara kaayauma yaata utuatee. Kua pinaana ngii yapai suaivaki fai Anutuuqoono ngia sai kiaara kuaivaa ngii yaatana yapanai kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ngia sai kiaara kuaivaa hama ngiengieenoo kiaaravai. Fai ngii Gioova ngiau aapu variivaa Mmannasaivoono ngii giaa ngii minai kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Fai vaidi vooya ngiari kata vayaiya vitada vaidi vooya mmikiai ruputikiai putuaaravai. Fai vaidiiya ngiari uru nnaakaraiya vitada vooya mmikiai ruputikiai putuaaravai. Fai nnaakaraiya ngiari kaano kooya mmooka hanigia mmida iya ruputuateeraivaara vitada vaidi vooya mmiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ngia niiyara kutaavaivee kiaivaara fai gioonna kiaapu kaayauya ngii teeda hama ngiiiyara mmuduuya ruaaravai. Fai gioonna kiaapu voovoono niiyara kutaavaivee tioo yaagueeqainono ari putira suaivaki Anutuuqo inna vitoo yoosinna yoketaivaki yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Vo yoosinnaiya mmoori maisaivaa ngii mikiai rikiada ngiingii yaatu seenada vo yoosinnavakira kuatee. Na kua kutaavai ngii giaa ngii miaunoo. Hama ngia Isarairaa yoosinna mmuakiaayauvaki nuaida ni mmayaaya aavaa gioonna kiaapuuya kiaa mmi taikeeraida kikiai Na Vaidiivaa Mmaapuuvoono kava vara ranee tiinaravee. ");
INSERT INTO waj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Hama vo ngiaammuau voovoono ari vitairaivaa yaataraivai. Sikaunnaadiri yookaama kioo viteera ngiaammuauvo hama ari haitatuuraivaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Fai ngiaammuauvo ari vitairaivaanikaraama varinaraivo inna aikioovai. Sikaunnaadiri yookaama kioo viteera ngiaammuauvo ari haitatuuraivaanikaraama varinaraivo inna aikioovai. Fai gioonna kiaapuuya vaidi haitatuuraivaa kiaara: Beresebuuro, kiaa kiada ivo haitatuuraiyaraatama ari vookarai maisa nnutuuyauvaa iyaraatama kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Itaama vainai rikiada sa gioonna kiaapuuyara aatuuda variatee. Mmuakiaa mminnaiyauvaa rummua apu kiaiyauvaa fai rabara kino kooyaa vainaravai. Mmuakiaa mminnaiyauvo hataumaki vaiyauvo fai kooyaa vainaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na upisiivaki hauma kuaivaa ngii giaa ngii miauvaa kooyaa ikiannaivau gioonna kiaapuuya kiaa mmiatee. Na ngiingii yaataki nnaasu ngii giaa ngii miau kuaivaa rikiada yoosinna vuutaivaki kooyaa gioonna kiaapuuya kiaa mmiatee. ");
INSERT INTO waj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gioonna kiaapu vooya ngii mmammaiyauvunu ruputikiai putuaaraivaara sa aatuukiatee. Iya hama yopeema ngii vaidi kaanaiyauvaatama ruputu taika kiaaravai. Anutuuqaara nnaasu aatuukiatee. Ivoono fai ngii mmammaiyauvaata ngii vaidi kaanaiyauvaatama ikia aakiaivaki yapa kino fai maisainaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ngia ngiaamma sigannaivaa roosii taaravaitanaara mmuaa kookee sikau kiisaivaadiri yookaama kiada varaavai. Hama Anutuuqo itai ngiaammaiyauvaara vueennainno pikiano fai voovai putuoo mmataki tuoo kuanaravai. Ivo tino fai putuoo tuoo kuanaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ngii kieeta yausiiyauvaa Anutuuqo yaaruoo mmuaavai mmuaavai taivai. ");
INSERT INTO waj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ivaara yaata utida sa aatuukiatee. Anutuuqo ngiiiyara yaata utiraivoono ivo kaayau ngiaamma siganna roosiikiaiyauvaara yaata utiraivaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Gioonna kiaapu voovoono ari seena gioonna kiaapuuya avuuyauvunu kooyaa tinara: Na aanna Yisuunna nnaagiai nuairaivovee, tinai fai na ni Napoova ngiau aapu variivaa avuuvau innara sai tinara: Inna kutaa ni nnaagiai nuairaivovee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gioonna kiaapu voovoono ari seena gioonna kiaapuuya avuuyauvunu niiyara tinara: Hama na inna tauvaivee, tinai fai yapooma na ni Napoova ngiau aapu variivaa avuuvau innara irisai tinara: Hama na inna tauvaivee, tinaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sa yaata utida niiyara kiatee: Ivo gioonna kiaapuuya ausa nuufaivaa mminaraivaara tiiravaivee, kiatee. Hama na ivaara tiiravai. Rapira avai karaivo vainaraivaara na tiiravai. ");
INSERT INTO waj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Fai mmaapuuya ngiari kookiaiyara nnannateeda varikiai raunnaapuuya ngiari kaanokiaiyara nnannateeda varikiai nnaaputuuya ngiari nnaaputuuyara nnannateeda variaaravai. Iya itaama iikiaaraivaara na tiiravai. ");
INSERT INTO waj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Gioonna kiaapu voovoono ni mmooriivaara yaagueeqama iinai rikiada fai ari seena tuanaiya innara nnannateeda kiaara: Ti nnammutuaavaivee, kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Gioonna kiaapu voovoono ari kaano kooyara kaayauma mmuduuya ruoo niiyara kiisama mmuduuya ruaivoono inna hama ni nnaagiai nuairanavai. Gioonna kiaapu voovoono ari raunna mmaapuuyara kaayauma mmuduuya ruoo niiyara kiisama mmuduuya ruaivoono inna hama ni nnaagiai nuairanavai. ");
INSERT INTO waj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Gioonna kiaapu voovoono ni nnaagiai nuaivaara gioonna kiaapuuya inna ruputikio na putuauneema ivo putinaraivaara ooqoo tiivo inna hama ni nnaagiai nuairanavai. ");
INSERT INTO waj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gioonna kiaapu voovoono ari mmatayaa variraivaara kaayauma mmuduuya ruoo ruoo fai yapooma hama ivo tupatupaa variraivootainaravai. Gioonna kiaapu voovoono hama ari mmatayaa variraivaara yaata utirainno niiyara putinaraivaara ee-oo tiivo fai tupatupaa variraivaa varaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Gioonna kiaapu voovoono ngiiiyara yoketaivoono niiyaraatama yoketainoo. Niiyara yoketaivoono ni titoovaaraatama yoketainoo. ");
INSERT INTO waj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Vaidi voovoono Anutuuqaa forofetaavai variivaara gioonna kiaapuuya innara yoketaida inna tuqinnaiya fai ivo irisai yoketaivaa varaineema iyaatama varaaravai. Vaidi voovoono safuuma variivaara gioonna kiaapuuya innara yoketaida inna tuqinnaiya fai ivo irisai yoketaivaa varaineema iyaatama varaaravai. ");
INSERT INTO waj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu voovoono kuminayaa variivo ni nnaagiai nuairaivaara gioonna kiaapu voovoono innara boo tioo mmanna nnoori adaivaa vita inna mmioo fai irisai yoketaivaa varaanaravai. Fai hama fanniinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yisuuva ari ngiaammuau yaakuuvaitana yukukidiri taaramaata ii kua ivaa kiaa mmi taika kioo ii yoosinna ivaa pikioo vo yoosinna vo yoosinnaiyauvaki nuainno varioo mmayaaya yoketaivaa iya kiaa mmioo aataru yoketaivaa iya vitairavai. ");
INSERT INTO waj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Vitainno varuduu Yuvuaano nnoori apira vaidiivo oovi nnauvaki hara kioo varioo Yisuu Kirisiiva uu mmooriivaara rikioo ivaara ari ngiaammuau vooya tuduu innasi nnuduu ");
INSERT INTO waj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","iya tunoo: Oro Yisuunna yaparaida kiatee: Vara a aanna vaidi nninaravee tuukuannee? Vara ta ari voovaara faannaida haitatuukiaarannee? ");
INSERT INTO waj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","tuduu rikiada vida Yisuunna kiaa mmuduu rikioo iya sai tunoo: Ni kuaivaa rikiada na iikiau mmooriivaa teeda ivaara vida Yuvuaanaa kiaa mmiatee. ");
INSERT INTO waj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gioonna kiaapu avu huruutaiya vaa avu taanoo. Yuku maisaiya vaa diitada nookiaanoo. Iya mmammaiyauvunu buunna haiya roosiikiaiya vaa yoketaama variaanoo. Yaata duunaiya vaa kuaivaa rikiaanoo. Putuaiya vaa diitada variaanoo. Mmanna haipuuya vaa ni mmayaaya yoketaivaa rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Gioonna kiaapu voovoono hama niiyara taara yaata utiraivaara Anutuuqo innara yoketainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tuduu rikiada Yuvuaanaa ngiaammuauya kava vara ranada innasi vida varuduu Yisuuva gioonna kiaapuuya innasi nuunauya Yuvuaanaara tunoo: Ngia koo mmuyai gaanga yoosinnaivau Yuvuaanaasi vida ngia aaniivai taara viravainnee? Yuunnaivo utuduu yanaa apuuvo kuapekuapoovaa taara viravainnee? Hamavee. ");
INSERT INTO waj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ngia aaniivai taara viravainnee? Ngia vaidi voovoono yaapa ari vookarauvaa apuuvaa taara viravainnee? Hamavee. Mo gioonna kiaapuuya yaapa ari vookaraiyauvaa apu kiada variaiya iya vaidi kieetaiya nnauyauvaki variaavai. ");
INSERT INTO waj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngia ni giaa ni miatee. Ngia aaniivaara viravainnee? Ngia vaidi forofetaivaa taara viravainnee? Na ngii giaa ngii miaunoo. Kutaa ngia vaidi forofetaa ari vookarauvo seena vaidi forofetaiya yaataroovaa ngia taara viravaivee. ");
INSERT INTO waj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Anutuuqaa kua fafaara roovo Yuvuaanaara vainno ataa kua tinoo: Anutuuqo tinoo: Na titauko nnii vaidiivo aa nninoo. Na i tauraivaannaadee titano vioo aataruuvaa aini teerama kiaanaravaivee, tiivaivee. Fafaaraivo itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na kua kutaavai ngii giaa ngii miaunoo. Yuvuaano nnoori apira vaidiivo mmuakiaa gioonna kiaapuuya mmata aavau varia rada nnidada aanna variaiya yaataraivai. Anutuuqo gioonna kiaapuuyara diraivaki gioonna kiaapu voovoono aduoo variivoono Yuvuaanaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yuvuaano ari mmayaayaivaa kiaa mmuu suaivo ngioo ngioo aanna makee ta variaunna suaivaki Anutuuqo gioonna kiaapuuyara dira yoosinnaivaara vooya mmoori maisaivaa iikiaavai. Yaagueeqa avaikarai vaidiiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivakira kuaaree kiaa kiada ivaara yaagueeqararama kiada iikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Anutuuqo gioonna kiaapuuyara dira yoosinnaivaara mmuakiaa forofetaa vaidiiya tuduu Anutuuqaa mmaanna tuu kuaivaki vau kuaivootama ivaara tiravai. Kiaa rada nnududuu Yuvuaano varuu suaivaki ivo ivaaraatama tiravai. ");
INSERT INTO waj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iya tuu kuaivaa ngii rikiaatainai rikiaatee. Iya Irayaava kava tiinaraivaara tiravai. Iya Irayaavavee tuuvo vaa Yuvuaano tioo Irayaanna roosiima varivai. ");
INSERT INTO waj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Gioonna kiaapu voovoono arinaima kua rikiaivoono ii kua ivaa arinaima rikiaivee. ");
INSERT INTO waj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Gioonna kiaapu aanna makee variaiya deeya roosiimaida variaannee? Iya nnaakara roosiikiaiya yoosinna vuutaivaki isareeda varida ngiariiyara ngiariiyara aayanna reeda kiaanoo: ");
INSERT INTO waj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ta tooriivaa varada fee fee kiaunnani hama ngia ivaara kuaru raavai. Ta kuaru nnauvaa haraunnani hama ngia ivaara rataavaivee, kiaa kiada itaa kua kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iya iikiaivaa roosiima gioonna kiaapuuya iikiaanoo. Yuvuaano numa iya tasipama varioo yeennaivaaraata vuaina suuyaivaaraatama ooqoo kiaa kiooduu rikiada gioonna kiaapuuya innara tunoo: Ai, mmagia maisaivo inna aakiaivaki topai vaidivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na Vaidiivaa Mmaapuuvoono ngiee yeennaivaata nnooriivaatama nnaukai gioonna kiaapuuya kiaanoo: Aa vaidi aavaa taatee. Ivo ariiyara yaata utuoo tarikama kioo yeenna nnai vaidivai. Ivo kaayauma vuaina suuyaivaa nnoo kumimakai vaidivai. Ivo sikau takiisa vareera vaidi maisaiyaata mmaanna tuu kuaivaa hatokeera gioonna kiaapu maisaiyaatama iya seenavaivee, kiaavai. Iya itaa kua kiaaniaata ti mmooriivaudiri Anutuuqaa tinniivo kutaa vaivo kooyaa vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yisuuva ari mmoori ari vookara ari vookarauyauvaa vo yoosinna vo yoosinnaiyauvaki uuyauvaa teedaata gioonna kiaapuuya hama hanigiada ngiari mminnamminnaa maisaiyauvaa pikioovaara Yisuuva yaagueeqama iya tioo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Boo, ngia gioonna kiaapu yoosinna Korasima variaiyaata yoosinna Beresaitaa variaiyaatama fai yapooma ngii mmooriivaa irisai maisaivo vainaravai. Nnaaru gioonna kiaapuuya yoosinnaivaitana Turu Sitoona maisamaisama variravai. Na ari vookara ari vookarau mmooriiyauvaa ngii yoosinnaivaitanaki iikiaivaa Turu Sitoona yoosinnaivaitanaki iikiaatiri. Iya teeda vaa nnaaru hanigiada yoketaama varutiri. Gioonna kiaapuuya iya hanigiada yoketaama variaivaa taateeraivaara iya ausa mmuaararoovaa varada buruqa sisiiyauvaa raida kaupaivaa habara ngiari kieetaiyauvunu apu kiada varutirivee. ");
INSERT INTO waj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ivaara na ngii giaa ngii miaunoo. Fai yapooma Anutuuqo gioonna kiaapuuya yaparaira suaivaki gioonna kiaapu Turu Sitoonaiya irisai maisaivaa pinaama varaaravai. Ngia gioonna kiaapu Korasimaiyaata Betesaitaiyaatama ngii irisai maisaivo iya irisai maisaivaa yaataraanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ngia gioonna kiaapu Kapanauma variaiyaso, ngia ngiau aapu variaaree kiaiya fai Anutuuqo tinai ngia mmeepi ikia aakiaana vida kiaaravaivee. Nnaaru gioonna kiaapu Sutuuma varuuya maisamaisama variravai. Na ari vookara ari vookarau mmooriiyauvaa ngii iikiaivaa Sutuuma yoosinnaivaki iikiaatiri. Iya yoosinnaivo homo aanna makee vaitirivee. ");
INSERT INTO waj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ivaara na ngii giaa ngii miaunoo. Fai yapooma Anutuuqo gioonna kiaapuuya yaparaira suaivaki gioonna kiaapu Sutuumaiya pinaama irisai maisaivaa varaaravai. Ngia Kapanauma variaiya fai ngii irisai maisaivo iya irisai maisaivaa yaataraanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yisuuva itaa kua tuu suaivaki vo kuavai tunoo: Ni Napoo-o, a ngiau mmataivaara diraikuavee. A ai kua oyaivaa gioonna kiaapu tinni ruaiyara hatauma kiee gioonna kiaapu nnaakara meedi roosiima hama tinniaata kiaiyara a kiaa kookieema kiaannaivaara na aiyara yoketaakiaunoo. ");
INSERT INTO waj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo, ni Napoo-o, a kati iya i kiaa i mmiataikiai a iya kiaa mmiannavaivee. ");
INSERT INTO waj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ni Napoova a mmuakiaa mminnaiyauvaara diraivaa vaa ni miannavaivee. Hama gioonna kiaapu voovoono na i Mmaapuuvaa arinaima ni taivai. Eenoo ni Napoovaano nnaasu arinaima ni taannavai. Hama gioonna kiaapu voovoono ni Napoonna i taivai. Na i Mmaapuuvoono nnaasu arinaima i tauvai. Ni Napoo-o, na gioonna kiaapu voovai kooyaa inna i vitainaraivo ivootama fai i taanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ngia gioonna kiaapu kaayau mmoori varaiya mmuaararaivaa tasipama niisi ngiatee. Niisi nnikiai na ngii tasipanai rikiada eeyaara kati hara kiada variaaravai. ");
INSERT INTO waj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na tirooma variee hama na avaikara kiau vaidivai variauvaara ni mmooriivaa ngia varada na ngii vitaakiau aataruuvaa tuqinnama teeda fai ngia eeyaara kati hara kiada variaaravai. ");
INSERT INTO waj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na ngii tasipama variee ngii minara mmooriivo papakaanaivai. Na mmooriivaa ngii yaakuyaa yapaanaraivo hama mmuaararaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yisuuva itaa kua tuduu rikioo kiisa suaivo taika kiooduu ivo ari ngiaammuauyaatama Yutayaiya kati varira suai voovaki yeenna vuiita mmooriivaki nuairavai. Nuaida varida ari ngiaammuauya vuiita iiraiyauvaa utu rasukua rada nneeravai. ");
INSERT INTO waj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nneeda varuduu Farisai vaidi vooya numa iya teeda Yisuunna tunoo: Taanee. Ta kati varira suaivaki ti mmaanna tira kua aataruuvaa i ngiaammuauya hatokaanoo, ");
INSERT INTO waj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","tuduu rikioo Yisuuva iya sai tunoo: Ngia Davuitiinna mmayaayaivo yanaivau vaivaa yaarida hama tuqinnama rikiaavai. Nnaaruaa vaidi Davuitiivaata ari tasipama nuauyaatama kaayauma iya yeenna rauduu rikioo ");
INSERT INTO waj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davuitiivaano Anutuuqaara nuunaira nnauvaki vioo yeenna bereeta kati Anutuuqaaree kiaa yapoo yeennaiyauvaa varoo nnoo ari tasipama nuauyaatama mmuduu nneeravai. Ti mmaanna tuu kua aataruuvo vainno tunoo: Anutuuqaara kati puara hudeeraiyaano nnaasu Anutuuqaaniee kiaa yapoo yeenna bereetaiyauvaa nnaatee, tuduaata Davuitiiva ari tasipama nuauyaatama ii kua ivaa hatokada nnooduu hama Anutuuqo ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ngia Anutuuqo mmaanna tuuvaa yaarida hama tuqinnama rikiaavai. Kati varira suai mmuakiaayauvaki Anutuuqaara kati puara hudeera vaidiiya nuunaira nnauvaki mmooriivaa varada kua mmaanna tuu kuaivaa hatokaavo hama Anutuuqo kua tiivai. ");
INSERT INTO waj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na ngii giaa ngii miaunoo. Na aavaki variauvoono ngii nuunaira nnau pinaivaa yaataraunoo. ");
INSERT INTO waj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anutuuqaa kua fafaara roo kuaivo vainno tinoo: Vaidiiya puara sipisiipaiyauvaa kati niiyara hudaivaara hama ni yoketainoo. Vaidiiya ngiari seenaiyara mmuduuya ruaiyara ni yoketainoo. Kua fafaara roo kuaivo itaa kua tiivaa ngia yaarida oyaivaa arinaima rikiaatiri. Gioonna kiaapuuya hama maisa mmooriivaa iikiaiyaki hama ngia kua pinaivaa iyaki yapaatirivee. ");
INSERT INTO waj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na Vaidiivaa Mmaapuuvoono kati varira suaivaa nakaaraivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisuuva itaa kua kiaa taika kioo ivau iya pikioo ngiari nuunaira nnauvaki viravai. ");
INSERT INTO waj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Vioo tooduu vaidi voovai yaaku saivai sorogainno taminnumaunnuunno vuuvo ivaki varuduu vaidi vooyaano Yisuunnaki kua pinaivaa yapaara uuya ivaki varida inna yaparaida tunoo: Ti mmaanna tuu kua aataruuvo dataa kuainno tiinnee? Fai ta kati varira suaivaki vaidi nniitaraivaa tuqinnaarannee? Vara hama tuqinnaarannee? ");
INSERT INTO waj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","tuduu rikioo Yisuuva iya sai tunoo: Fai ngiiikidiri vaidi voovoono ari puara sipisiipa mmuaavai haitatuuno kati varira suaivaki soopa hokobaivaki tuoo vino aikiooma fai ivo raammi roo oto inna sootu kati naatauvau yapaanarannee? Vara too pikiaanarannee? Fai ivo raammi roo oto soopaivakidiri inna vita kati naatauvau yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ngia puara sipisiipaivaara yoketaama yaata utuaavai. Mo vaidiivo puaraivaa yaataraivai. Itaama vainai kati varira suaivaki vaidiivaa tuqinnaanara aataruuvo yoketaavai vaivaivee, ");
INSERT INTO waj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","kiaa kioo vaidi yaaku sorogauvaa tunoo: Ai yaaku sorogainno taminnumaunnuuvaa raduda utuanee, tuduu rikioo ari yaakuuvaa raduda utuduu yaaku saivai safuuma vauvaa roosiima vairavai. ");
INSERT INTO waj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Vauduu teeda Farisai vaidiiya vida nuunaida Yisuunna utida ruputikio putuaiveera kuaivaa kiaa teerama kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Teerama kiooduu Yisuuva rikiooduu inna mmaarau kua tuduu rikioo ii yoosinna ivakidiri pikioo vo yoosinnavakira vuduu rikiada kaayau gioonna kiaapuuya inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Vuduu too iva mmuakiaa nniitarooya tuqinnoo ariiyara vo gioonna kiaapu vooya kiaa mmivoo kiaa iya ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nnaaruaa forofetaa vaidi Yisayaava tuu kuaivaa kaanaivo iva uuvaugiataama vairavai. Yisayaava Anutuuqo tuu kuaivaa fafaara roo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Inna ni mmoori vareera vaidivai. Neenoo inna mmataama kiauvai. Na innara mmuduuya ruauko kaayauma innara ni yoketainoo. Na ni Mmannasaivaa inna mmino ivoono mmuakiaa voopinnaa gioonna kiaapuuya safuuma yaparainaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ivo hama buaaru tioo hama kai tioo hama yoosinna vuutaivaki diitoo yaagueeqama kua tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iya yaammaivo tapugioo vaivaa hama utu ratokaaneema fai ivo hama gioonna kiaapu muaraagama variivaa ruputinaravai. Iya tooba manumanuuvaa hama utu rasuukiaaneema fai ivo hama gioonna kiaapu muaraagama variivaa ruputinaravai. Fai ivo mmannammanna mmooriivaa varanono yapooma safu aataruuvoono maisa aataruuvaa yaataraanara suaivaki pikiaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ivo itaama varinai mmuakiaa voopinnaa gioonna kiaapuuya yaata utida innara faannakiaaravee. Yisayaava fafaara roo kuaivo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yisuuva gioonna kiaapuuya tuqinnooduu rikiada vooyaano vaidi avu huruutauvaa aakiaivaki mmagia maisaivo topaama kioo varuduu inna avaivo ramuunnaama kioovaa Yisuunnasi vitada nniravai. Vitada nnuduu Yisuuva vaidiivaa tuqinnooduu rikioo keenaa avu too kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kua tuduu rikiada gioonna kiaapuuya kaayauma nnikiaraida ngiari yapara ngiari yaparaida tunoo: Mo aa vaidi aavo Davuitiinna oyaivakidiri diitaivainnee? Vara ari vo vaidivainnee? ");
INSERT INTO waj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","tuduu rikiada Farisai vaidi vooyaano ii kua ivaa rikiada tunoo: Mmagia maisaiya kieetaivo Beresebuuro inna tasipama varikioonno inna yaagueeqaivaadiri mmagia maisaiya vaidi aakiaaki variaiya titaikiai kuaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","tuduu rikioo Yisuuva iya tinniyaa vau kuaivaa rikioo iya tunoo: Fai gioonna kiaapuuya mmuaa mmatavau variaiya rapidada ivaudiri raubiriida mmarammaraama varida hama yopeema mmuaavau yaagueeqama varirama kiada fai taikaaravai. Gioonna kiaapu mmuaa nnauvaki variaiyannee vara mmuaa yoosinnavaki variaiya ngiariita ngiariita rapidada fai vida raubiriida mmarammaraama varida fai hama mmuaavau yaagueeqama varirama kiada muaraagakiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Itaama vaino mo fai Sataango ari seena mmagia maisaiyaatama rapuoonnonno titaa kinai vida raubiriida mmarammaraama varida hama mmuaavau yaagueeqama varirama kiada fai Sataangoota iyaatama muaraagakiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ngia kiaanoo: Beresebuuro ari yaagueeqaivaa ni mikiai na mmagia maisaiya titaukai kuaanoo, kiaani mo ngii nnaagiai nuairaiya giaa yaagueeqavaura mmagia maisaiya titaani kuaavainnee? Hama Beresebuuraa yaagueeqaivo ngii seenaiya tasipaivai. Ivaara ngia koonnama niiyara yaata utuaa kuaivo kooyaa vainoo. ");
INSERT INTO waj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Anutuuqaa Mmannasaivoono yaagueeqaivaa ni mikiai rikiee na mmagia maisaiya vaidiiya aakiaiyauvakidiri titaukai kuaavai. Na itaama iikiauvaara Anutuuqo gioonna kiaapuuyara dira suaivo vaa ngiiisi vaivo kooyaa vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yisuuva itaa kua kiaa kioo kava vo kua voovai tioo vaidi yaagueeqaivaudiri mmataama kioo Sataangaara tunoo: Fai vaidi voovoono yaagueeqa vaidiivaa nnauvaki vioo inna hoonaiyauvaa ariyara varaanaree kiaa kioo hama sabi kuanaravai. Fai tauraa vaidi yaagueeqaivaa yuku yaakuuvaa yeenaadiri ranaa rau kioo vioo inna nnauvakidiri inna hoonahaanaiyauvaa varaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yisuuva itaa kua kiaa kioo tunoo: Gioonna kiaapu voovoono hama niiyara mmuduuya ruaivoono inna ni nnammutuaavai. Gioonna kiaapu voovoono hama ni tasipama mmoori varaivoono ni mmooriivaa tuayanna ruaivai. ");
INSERT INTO waj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ivaara na ngii giaa ngii miaunoo. Vaidiiya mminnamminnaa maisa mmuakiaayauvaatama mmuakiaa maisa kua kiaiyauvaatama fai Anutuuqoono rugaanaravai. Gioonna kiaapu voovoono Mmannasa Yoketaivaara maisavaivee tiivaa hama Anutuuqo ivaa rugaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Gioonna kiaapu voovoono Na Vaidiivaa Mmaapuuvaara maisavaivee tiivaa fai Anutuuqo rugaanaravai. Gioonna kiaapu voovoono Mmannasa Yoketaivaara maisavaivee tiivaa fai Anutuuqo hama ivaa rugaanaravaivee. Makee ta variaunna suaivakiaata yapooma ta variaara suaivakiaatama fai itaavai homo vainaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yatari yoketaivau iira yoketaivo vaikio yatari maisaivau iira maisaivo vaivai. Ngia yatari iiraiyauvaa teeda arinaima yatari oyaivaara rikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ngia vaidi maisaso, ngii aakiaiyauvakidiri kaayau mminnamminnaa maisaiyauvo suvuaivakidiri hama kua yoketaivaa kiaavai. Vaidiivo ari aakiaivaki suvuaineema ari avaivakidiri kooyaa tiivai. ");
INSERT INTO waj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vaidi yoketaa voovoono ari aakiaivaki yoketaivo vaineema ari avaivakidiri safuuma kua yoketaivaa tiivai. Vaidi maisa voovoono ari aakiaivaki maisaivo vaineema ari avaivakidiri kua maisaivaa tiivai. ");
INSERT INTO waj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na ngii giaa ngii miaunoo. Anutuuqo gioonna kiaapuuya yaparaira suaivaki mmuakiaa suai iya sabi kua sabi kua kiaivaara Anutuuqo iya yaparainaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anutuuqo ngiingii kuaivaara ngii yaparainno ngia yoketaama kiaivaara ngiiiyara tinara: Hama ngiiiki kua vainoo, tinaravee. Ngia maisama kiaivaara tinara: Kutaa ngiiiki kua vainoo, tinaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tuduu rikiada kua mmaanna kiaa mmira vaidi vooyaata Farisai vaidi vooyaatama Yisuunna tunoo: Vitaira-o, a Anutuuqaa mmoori ari vookaraivaa iinai ta taaravee, ");
INSERT INTO waj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","tuduu rikioo Yisuuva iya sai tunoo: Ngia gioonna kiaapu aanna makee variaiya koonnama varida hama Anutuuqaara yaagueeqakiaiyaano ngia ari vookarai mmooriivaa taara iikiaanoo. Anutuuqaa mmoori ari vookarauvaa nnaaruaa vaidi forofetaa Yonaava uuvaa roosiivaa ngia ivaa nnaasu taaravai. ");
INSERT INTO waj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonaava piisa pinaivaa rasookaivaki taaravooma suai taaravooma heena vauvaa roosiima Na Vaidiivaa Mmaapuuvoono vaidi putuaiya vaira mmataivaki taaravooma suai taaravooma heena vainaravee. ");
INSERT INTO waj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninivee varuu gioonna kiaapuuya Yonaanna kuaivaa rikiada ausa hanigiada yoketaama variravai. Na ngii giaa ngii miaunoo. Na aavaki variauvo Yonaanna yaatarauvoono ngii tasipama variaunoo. Ninivee varuuya ausa hanigiada yoketaama varuuvaara yapooma Anutuuqo gioonna kiaapuuya yaparaira suaivaki fai iya kua pinaivaa aanna ngia variaiya ngiiiki yapa kikio Anutuuqo irisai maisaivaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nnaaru kieeta varuu gioonna voovoono tooya sainai ngieera ari voopidiri ngioo ngioo vaidi Soromoono tinni ruaivaasidiri kua rikiaanara nniravai. Na ngii giaa ngii miaunoo. Na aavaki variauvo Soromoonaa yaatarauvoono ngii tasipama variaunoo. Gioonnaivo ngieeradiri numa Soromoonaa kuaivaa rikioovaara fai yapooma Anutuuqo gioonna kiaapuuya yaparainara suaivaki ivoono kua pinaivaa aanna ngia variaiya fai ngiiiki yapa kino Anutuuqo irisai maisaivaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Mmagia maisaivo vaidiivaa aakiaivakidiri pikioo vioo koo mmuyai gaanga yoosinnaiyauvaki ari varinara mmaataivaara buaama roo nuainnonno taikio kuminaikio ");
INSERT INTO waj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ariita kua tioo tinoo: Fai na kava vara ranee nini nnau pikiauvaki oro varinaravee, kiaa kioo kava vara ranoo numa taikio ari nnauvo rupi yamaama kioo funnukama kiaikio mmanna nnauvai vaikio too ");
INSERT INTO waj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ivaki varioo oro seena mmagia maisaiyauvo inna maisaivaa yaatareera yaaku saivai karasaidiri taaramada vitoo nnikiai iya numa inna tasipama variaavai. Aa vaidi aavaa aakiaivaki tauraa mmagia maisa mmuaavai varikio kiisama maisama varikiai nnaagiai kaayau mmagia maisaiya innaki variaavo kaayau maisama varivaivee. Gioonna kiaapu maisama aanna makee variaiya fai mmuaikaraama itaama variaaravee. ");
INSERT INTO waj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yisuuva homo gioonna kiaapuuyaata kua tuoo varuduu ari kaanoota ari kataunnaiyaatama innaata kua kiaaree kiaa numa mmaanai dida vairavai. ");
INSERT INTO waj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dida vauduu gioonna kiaapuuyakidiri voovoono Yisuunna tunoo: Aa mmiaa i kaanoota i kataunnaiyaatama aita kua kiaaree kiaa numa diaanoo, ");
INSERT INTO waj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","tuduu rikioo Yisuuva inna sai tunoo: Ni noonna tuanaivaata ni gata tuanaiyaatama vaa ngia taavaivee. Na ni noonna tuanaivaaraatama ni gata tuanaiyaraatama mmuduuya ruauneema dee gioonna kiaapuvaara na mmuduuya ruaunnee? ");
INSERT INTO waj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","kiaa kioo ari nnaagiai nuaira gioonna kiaapuuya oopu haroo tunoo: Aqaayaano ni noova ni gataunnaiya variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gioonna kiaapu voovoono ni Napoova ngiau aapu variivaa tinniivau vai kuaivaa tuqinnama rikioo iinnonno inna ni gata vayaa ni nunna nayaa ni noova varinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yisuuva itaa kua kiaa kioo nnauvaki pikioo mmuai suaivaki oro nnoori haruunga mmaagaivau dioo vauduu ");
INSERT INTO waj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","gioonna kiaapu kaayauya inna suvuauvaara ivo kanuuvaki karoo varioo feena roo oro nnoori tooyaivaki kioo ivaki varuduu gioonna kiaapuuya homo mmaagaivau diravai. ");
INSERT INTO waj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Duduu Yisuuva mmatayaa diaa mminnaiyauvunudiri mmataama kioo kaayau kua iya kiaa mmioo tunoo: Rikiaatee. Vaidi voovoono yeenna uruuyauvaa varoo ");
INSERT INTO waj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","oro ari mmooriivaki rututuooma roo nuaikio vooyauvai aataruuvo vaivau tuoo kuaikiai ngiaammaiyauvo tuma porooma nnaavai. ");
INSERT INTO waj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Uru vooyauvai tuoo sikau tasipama vai mmataivau kuaiyauvo uruoo hama kaayau mmataivo vaivaara kiisa suai urikio too ");
INSERT INTO waj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","suaivo ngioo taikio maisaikio hama tuukaivo hokobama kuaivaara akiairaama aasannaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Uru vooyauvai tuoo ooviiyauvaki kuaikio ooviiyauvo ivaa tasipama uruoo raputu kiaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Uru vooyauvai mmata yoketaivau tuoo kuaiyauvo yoketaama urikio kaayau iiraiyauvo vaivai. Vooyauvakidiri iiraiyauvo yaaku sai vaidiiya yuku yaaku taika kioo (100) vaikio vooyauvakidiri iiraiyauvo taaravooma vaidiiya yuku yaaku taika kioo (60) vaikio vooyauvakidiri iiraiyauvo mmuaa vaidivai yuku yaaku taika kioo vo vaidivai yaakuuvaitana (30) vaivaivee, ");
INSERT INTO waj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","kiaa kioo tunoo: Gioonna kiaapu voovoono arinaima rikiaivoono ii kua ivaa arinaima rikiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tuduu rikiada Yisuunna ngiaammuauya innasi nnida inna yaparaida tunoo: Aaniira a gioonna kiaapuuya kiaa mmira suaivaki mmatayaa diaa mminnaiyauvunudiri mmataama kiee kiannannee? ");
INSERT INTO waj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","tuduu rikioo Yisuuva iya sai tunoo: Anutuuqo gioonna kiaapuuyara dira kua oyai haumaki vaiyauvaa fai na ngii giaa ngii minai ngiengieenoo arinaima rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gioonna kiaapu voovoono ni kuaivaa arinaima rikiaivoono fai Anutuuqo ari vo kua ari vo kuaivaa inna kiaa mminono innaki kaayauma suvuainaravai. Gioonna kiaapu voovoono kiisa kuaivo inna yaatana vaivaa fai yapooma taunnu kino hama innaki kuaivootainaravai. ");
INSERT INTO waj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gioonna kiaapu vooya teedada mmanna avuuyauvaadiri teeda hama tuqinnama taavai. Iya rikiadada mmanna yaataiyauvaadiri rikiada hama arinaima rikiaavai. Hama iya tuqinnama teeda arinaima rikiaivaara na mmatayaa diaa mminnaa vooyauvunudiri mmataama kiee iya kiaa mmiauvai. ");
INSERT INTO waj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nnaaruaa vaidi forofetaa Yisayaava fafaara roo kuaivo vainnonno aanna makee variaa gioonna kiaapuuyaki kaanaivo vainoo. Yisayaava fafaara roo tunoo: Anutuuqo tinoo: Ngia rikiadada hama arinaima rikiaaravai. Ngia teedada hama tuqinnama taaravai. ");
INSERT INTO waj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iya ngiari avuuyauvaa teeda iya yaata tinniiyauvaa rikiada ausa tinniiyauvaa hanigiakiai na iya tuqinneevoora kiaa iya tinniiyauvo yaagueeqaikiai ngiari yaataiyauvaa ramuunnaama kiada ngiari avuuyauvaa tasuuma kiada variaavaivee, tiivaivee. Yisayaava itaa kua kiaa kioo fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ngiengieenoo ngiingii avuuyauvaadiri tuqinnama teeda ngiingii yaataiyauvaadiri tuqinnama rikiaavai. Ngia tuqinnama teeda rikiaivaara Anutuuqo ngiiiyara yoketainoo. ");
INSERT INTO waj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na kua kutaavai ngii giaa ngii miaunoo. Nnaaruaa vaidi forofetaa kaayauyaatama kaayau gioonna kiaapu Anutuuqaara yaata utida safuuma varuuyaatama aanna makee ngia taivaa iya taatauduu iya faannaidada putida hama teeravai. Aanna makee ngia rikiaa kuaivaa iya rikiaatauduu iya faannaidada putida hama rikieeravaivee. ");
INSERT INTO waj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Vaidiivo uruuyauvaa rututuooma kioovaudiri na mmataama kiau kua oyaivaa rikiaatee. ");
INSERT INTO waj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Anutuuqo gioonna kiaapuuyara dira kua mmayaayaivaa gioonna kiaapu voovoono mmanna yaata nnaasu rikioo hama arinaima rikiaivo uruuyauvo aataruuvau tuoo kuaiyauvaa roosiivai. Hama ivo arinaima rikiaivaara Sataango numa inna aakiaivakidiri kuaivaa ravisi varaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uruuyauvo sikau tasipama vai mmataivau tuoo kuaiyauvo gioonna kiaapu voovai roosiivai. Ivo Anutuuqaa kuaivaa rikiai saivaata kaayau siriga tasipama varaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Uruuyauvo uruoo hama tuukaiyauvo mmeepi kuaiyauvaa roosiima ivo hama kuaivaa ari aakiaana yapeerama kioo kiisa suai nnaasu Anutuuqaara yaagueeqaivai. Ivo Anutuuqaa mmooriivaa iivaara seena gioonna kiaapuuya maisa mmoori mmuaararaivaa inna mmiaavo rikioo ivo makee tikio Anutuuqaa aataruuvaa pikiaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Uruuyauvo ooviiyauvaki tuoo kuaiyauvo gioonna kiaapu voovai roosiivai. Ivo kuaivaa rikioonnaata mmatayaa diaa mminnaiyauvaa varaanaraivaara kaayauma yaata utuoo sikau varaanaraivaara yaata utuoo mmuduuya rikio iyauvoono inna suvuainno Anutuuqaa kuaivaa rugaikio rikioo hama iiraivo vaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Uruuyauvo mmata yoketaivau tuoo kuaiyauvo inna gioonna kiaapu voovai roosiivai. Ivo Anutuuqaa kuaivaa arinaima rikiaikio tinniivo rusitikio kuaivo inna aakiaana urikio iiraiyauvo suvuainno ataama vaivai. Vooyaki kaayau iiraiyauvo (100) vaikio vooyaki voota nnoonnama (60) vaikio vooyaki kiisakiangii (30) vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisuuva itaa kua kiaa kioo kava mmatayaa diaa mminnaa voovaudiri mmataama kioo iya tunoo: Anutuuqo gioonna kiaapuuyara diraivo vaidiivo uru yoketaiyauvaa ari mmooriivaki rututuooraivaa roosiivai. ");
INSERT INTO waj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ivo yeenna vuiita uruuyauvaa rututuooma kiaikiai vo heena voovaki mmuakiaa gioonna kiaapuuya vuru vakiaavo rikioo mmoori nakaaraivaa nnammutuaa voovoono numa yeenna vuiita mmooriivaki ari ikiau uru maisaiyauvaa rututuooma kioo kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kuaikio yapooma yeenna vuiitaiyauvo uruoo iiraiyauvo vainara iikio ikiauyauvootama uruoo kooyaa vaivai. ");
INSERT INTO waj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vaikiai teeda mmoori vareera ngiaammuauya oro nakaaraivaa kiaanoo: A uru yoketaiyauvaa nnaasu ai mmooriivaki rututuookiannanoo. Mo dataama kioo ikiauyauvootama uriinnee? ");
INSERT INTO waj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","kiaavo rikioo tinoo: Mo ti nnammutuaivoono rututuoovaivee, tikiai rikiada iya inna yaparaida kiaanoo: Fai ta oo ikiauyauvaa hamukuaarannee? ");
INSERT INTO waj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","kiaavo rikioo ivo iya sai tinoo: Hamavee. Ngia ikiauyauvaa hamukida sabi vuiitaiyauvaatama hamukuaarainnoo. Pikiaatee. ");
INSERT INTO waj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kii nuunama urikiai yapooma iira rutakeera suaivaki na iira rutakeera ngiaammuauya tinara: Tauraa ikiauyauvaa hamuku kiada uru rau ikiaivaki kagaariaaraivaara teerama kiaatee. Nnaagiai vuiitaiyauvaa rutaka rada iyauvaa yeenna yapeera nnauvaki yapaatee, tinaravaivee. Nakaaraivoono itaa kua tiivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Yisuuva itaa kua kiaa kioo kava mmatayaa diaa mminnaa voovaudiri mmataama kioo iya kiaa mmioo tunoo: Anutuuqo gioonna kiaapuuyara diraivo uru kiisakiata nnaammuaya uruuvaa roosiivaa nnutuuvo masateeraivaa roosiivai. Uru kiisaikiato vaikio mmuakiaa mminnaiyauvaa uruuyauvoono ii uru ivaa yaataraivai. Vaidi voovoono ii uru ivaa varoo ari mmooriivaki rututuooma kiaikio uruoo ngioo vioo pinaa kioo mmuakiaa annaanna mmaguyaiyauvaa yaataroo dikiai ngiaammaiya numa inna hammaraiyauvaki ngiisaiyauvaa heeka kiada vakiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisuuva itaa kua kiaa kioo kava mmatayaa diaa mminnaa voovaudiri mmataama kioo iya kiaa mmioo tunoo: Anutuuqo gioonna kiaapuuyara diraivo puuqaira yeennaivaa roosiivai. Gioonna voovoono ii yeenna ivaa varoo paravuaa saaba taaravoomaivaki hanigiaanigieema kioo yapa kiaikio vainno eyommaavai puuqaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iqii kua mmuakiaa iyauvaa Yisuuva gioonna kiaapuuya kiaa mmuu suaivaki mmatayaa diaa mminnaiyauvunudiri mmataama kioo iya kiaa mmiravai. Hama vo kua voovai kooyaa tiravai. Mmuakiaa kuavai mmatayaa diaa mminnaiyauvunudiri mmataama kioo tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Vaidi forofetaa nnaaru varuuvo fafaara roo kuaivo ngioo ngioo Yisuuva gioonna kiaapuuya kiaa mmuu suaivaki kaanaivo vauvaara ivo mmatayaa diaa mminnaiyauvunudiri mmataama kioo kuaivaa nnaasu tiravai. Forofetaivoono fafaarainno tunoo: Fai na gioonna kiaapuuya kua kiaa mmiee mmatayaa diaa mminnaiyauvunudiri mmataama kiee iya kiaa mminaravai. Anutuuqo ngiau mmata uu suaivaki haumaki vau kuaiyauvaa iya kiaa mminaravaivee. Forofetaivoono fafaara roo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yisuuva gioonna kiaapuuya pikioo nnau voovaki oro varuduu ari ngiaammuauya innasi nnida inna tunoo: A ikiauyauvo mmooriivakidiri uruuyauvunudiri mmataama kiee tunna kua oyaivaa ti kiaa ti mmianee, ");
INSERT INTO waj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","tuduu rikioo ivo iya sai tunoo: Na Vaidiivaa Mmaapuuvoono uru yoketaivaa rututuoora vaidivai. ");
INSERT INTO waj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mmooriivaki uruuyauvaa rututuooma kiaivo mmuakiaa mmatayaa variaa yoosinnaiyauvaa roosiivai. Anutuuqo gioonna kiaapuuyara dira yoosinnaivakira teerakiaa gioonna kiaapuuya uru yoketaiyauvaa roosiikiaavai. Gioonna kiaapuuya vaidi maisaivaa kuaivaa rikiada iikiaiya ikiauyauvaa roosiikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nnammutuaivo ikiau maisaiyauvaa rututuoovo inna Sataangovee. Iiraiyauvaa rutakeera suaivo inna ngiau mmataivo taikaanara suaivai. Iira rutakeera ngiaammuauya inna aangeraiyavee. ");
INSERT INTO waj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngiaammuauya ikiauyauvaa hamuku kiada ikiana kagaari kiaaneema ngiau mmataivo taikeera suaivaki aangeraiya gioonna kiaapuuya mmuaikaraama iikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na Vaidiivaa Mmaapuuvoono ni aangeraiya titanai ni yoosinnaivakidiri nuaida varida gioonna kiaapuuya ngiari seenaiya mmoori maisaivaa iikiateera vuavikiaiyaatama gioonna kiaapu mmuakiaa maisama variaiyaatama vitada ");
INSERT INTO waj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ikiana kagaari kikiai ivaki varida teekio iya nnannateenai fai ngiari avaiyauvaa hakutikio iya ausaiyauvo mmuaarareenai rataaravai. ");
INSERT INTO waj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iya itaama varikiai safuuma varira gioonna kiaapuuya ngiari Gioonna yoosinnaivaki varida suaivo yoketaama taineema yoketaama ari vookaraama variaaravaivee. Gioonna kiaapu voovoono arinaima kua rikiaivoono ii kua ivaa arinaima rikiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yisuuva itaa kua kiaa kioo kava mmatayaa diaa mminnaa voovaudiri mmataama kioo iya kiaa mmioo tunoo: Anutuuqo gioonna kiaapuuyara diraivo kaayau sikau yoketaiyauvaa vaidi voovoono vaa mmatana hauma kiaiyauvaa roosiivai. Vaidi voovoono mmataivaki hanukua roo taikio sikau yoketaiyauvo inna too vaikio too keenaa rummua apu kioo kaayauma sirigainno vioo ari mmaraa mminnamminnaa mmuakiaayauvai varoo oro vooya mmikio irisai sikauyauvaa varoo numa mmataivaa nakaaraivaa mmioo mmataivaa varaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kiaa kioo vo kua voovai tunoo: Anutuuqo gioonna kiaapuuyara diraivo ataivai vainoo. ");
INSERT INTO waj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Vaidi voovoono sikau seeta yoketaivaa roosiivaara buainnonno taikio voovai kaayau yoketaivo inna too vaikio too oro ari mminnamminnaa mmuakiaayauvai varoo oro vooya mmikio irisai sikauyauvaa varoo numa seetaivaa nakaaraivaa mmioo ivaa varaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kiaa kioo vo kuavai iya kiaa mmioo tunoo: Anutuuqo gioonna kiaapuuyara diraivo utua vaaheevaa roosiivai. Vaidiiya utua vaaheevaa varada nnoori haruungaivaki kagaari kiada kaayau tavauyauvaa ari vookara ari vookaraiyauvaa varaavai. ");
INSERT INTO waj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Varaavovo mmuugiaikiai teeda utu raririima mmaagaivau yapa kiada hara kiada varida tavauyauvaa ari vookara ari vookaraiyauvaa haitatuuda yoketaiyauvaa ngiari utuaiyauvaki vara rummua kiada maisaiyauvaa kagaari kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Fai yapooma ngiau mmata taikeera suaivaki fai itaama vainaravai. Fai aangeraiya nuaida varida gioonna kiaapu yoketaama variaiya pikiada maisama variaiya vitada ");
INSERT INTO waj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ikiana kagaari kikiai ikia aakiaivaki varida teekio iya nnannateenai fai iya avaiyauvaa hakutikio iya ausaiyauvo mmuaarareenai rataaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yisuuva itaa kua kiaa kioo ari ngiaammuauya yaparainno tunoo: Vaa ii kua iyauvaa na ngii giaa ngii miauyauvaa ngia arinaimaida rikiaannee? tuduu rikiada iya inna sai tunoo: Yo, vaa ta rikiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","tuduu rikioo Yisuuva tunoo: Ivaara na nnau nakaaraa vaidiivaa mmataama kiee ngii giaa ngii miaunoo. Nnau nakaaraa vaidiivo nnisi mminnaiyauvaata karaasa mminnaiyauvaatama ari nnauvaki yapa kiaikio vaiyauvaa inna ivo varaivai. Vaidiivo tauraa Anutuuqaa kua mmaanna kuaivaa arinaima rikioo nnaagiai Anutuuqo gioonna kiaapuuyara diraivaaraatama arinaima rikiaivoono ii nnau nakaaraa vaidi ivaa roosiivai. Ivo nnisi kuaivakidiriaata karaasa kuaivakidiriaatama gioonna kiaapuuya kiaa mmiivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yisuuva mmatayaa diaa mminnaiyauvunudiri mmataama kioo kuaivaa kiaa taika kioo ivaki pikioo ");
INSERT INTO waj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ari yoosinna tuanaivakira vioo ngiari nuunaira nnauvaki oro varioo ari kuaivaa iya kiaa mmiravai. Kiaa mmuduu rikiada nnikiaraida tunoo: Aa vaidi aavo deevakidiri tinni yoketaivaa varaivainnee? Mo dataama ivo yaagueeqa ari vookara ari vookarai mmooriiyauvaa iinnee? ");
INSERT INTO waj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ivo nnau heekeera vaidiivaa mmaapuvai. Mariaava inna kaanovee. Ari kataido Yakoopo Yoosiipo Simoono Yutaasainna variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mo ari nnunnaapuuya aavaki variaanoo. Mo deevakidiri ivo ii kua ivaa varaivainnee? ");
INSERT INTO waj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","kiaa kiada hama innara iya yoketauduu innara ooqoo tiravai. Innara ooqoo tuduu rikioo Yisuuva iya tunoo: Kua kutaa tira vaidi forofetaivaara mmuakiaa yoosinnaiya innara yoketaakiaani ari yoosinna tuanaiyaata ari seenaiyaatama hama innara yoketaakiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iya hama innara kutaavaivee tuuvaara ivo hama Anutuuqaa mmoori ari vookara ari vookarauyauvaa ivaki kaayauma iiravai. Kiisama iiravai. ");
INSERT INTO waj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ii suai ivaki Yuvuaano putuduu rikioo Yutayaiya kieetaivo Herooto Yisuuva yoketaa mmooriivaa iima kioo mmayaayaivaa rikioo ari seena vaidi kieetaiya tunoo: ");
INSERT INTO waj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aa vaidi aavo Yuvuaano nnoori apira vaidivai. Vaa putuoo keenaa diitoovaarainno yaagueeqaivo inna tasipaikio mmoori ari vookaraivaa iinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nnaaru Yuvuaano homo varuu suaivaki Herooto ari vayaanna Piriipaa nnaataivaa Herootiaanna mmuara varooduu Yuvuaano inna tunoo: Anutuuqaa aataruuvo hama itaivai. Sa varaanee, tuduu rikioo Herootiaava Yuvuaanaara nnannatoovaara Herooto ari ngiaammuauya tuduu Yuvuaanaa yuku yaakuuvaa yeena rau kiada oovi nnauvaki yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yapa kiooduu Herooto Yuvuaanaa ruputuatauduu gioonna kiaapuuya Yuvuaanaara forofetaavaivee tuuvaara Herooto iyara aatuunno hama ruputiravai. ");
INSERT INTO waj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hama ruputuduu yapooma Herootaa mmatoo suaivo nnuduu gioonna kiaapuuya nuunaida buusaivaa nnaara varuduu Herootiaanna raunnaivo numa kuaru rooduu teeda Herootoota ari seenaiyaatama teeda varuduu Herooto innara kaayauma yoketairavai. ");
INSERT INTO waj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Innara yoketauvaara ivo kua kiaa teerama yeena rau kioo kuaivaa tunoo: A ni yaparakianna mminnaivaa fai na kutaa i mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","tuduu rikioo kiaatannaivo oro ari kaanaa yaparauduu rikioo kaano kiaa mmuu kuaivaa numa Herootaa kiaa mmioo tunoo: Aanna makee i ngiaammuauya Yuvuaano nnoori apira vaidiivaa nnuunaivaa rutaka kiada inna kieetaivaa yanaivau yapa kiada varada numa i mmikiai ni mianee, ");
INSERT INTO waj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","tuduu rikioo Herootaa ausaivo kaayauma mmuaararooduu ari seenaiya avuuyauvunu vaa kua kiaa teerama yeena rau kioo kuaivaa tuuvaara yaata utuoo ee-oo tioo ");
INSERT INTO waj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ari ngiaammuauya titooduu oovi nnauvaki vida Yuvuaanaa nnuunaivaa rutaka kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Rutaka kiada kieetaivaa yanaivau yapa kiada varada numa kiaatannaivaa mmuduu varoo ari kaanaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mmi kiooduu Yuvuaanaa ngiaammuauya numa inna mmamma kaanaivaa varada oro mmata nnauvaki hau kiada vidada Yisuunna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yisuuva Herooto uu kuaivaa rikioo ivakidiri pikioo kanuu voovai varoo vioo nnooriivaa pikioo mmanna gaanga yoosinnaivakira viravai. Vuduu rikiada gioonna kiaapuuya ivo vuu kuaivaa rikiada ngiari yoosinnaiyauvaa pikiada mmatayaa ivo vuupi viravai. ");
INSERT INTO waj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Vuduu too Yisuuva nnoori mmaagaivau vioo varioo rootu tooduu gioonna kiaapuuya suvuau kiooduu iyara boo tioo iya tasipama varuu nniitarooya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tuqinnooduu suaivo hannauduu Yisuunnasi ari ngiaammuauya nnida tunoo: Vaa suaivo hannainoo. Aa yoosinna aavo mmanna gaanga yoosinnavaki ta variaunnanoo. Gioonna kiaapuuya titanai kuatee. Aa yoosinna aayauvakinnaayasi vida yeennaiyauvaa sikauyauvaadiri yookaama kiada varada nnikiai nnaateeraivaara titanai kuatee, ");
INSERT INTO waj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","tuduu rikioo Yisuuva iya tunoo: Sa iya titakiai kuatee. Mo ngieenoo yeennaiyauvaa iya mmiatee, ");
INSERT INTO waj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","tuduu rikiada iya inna sai tunoo: Bereeta yaaku saivai tavau taarama nnaasu aa tiisi vainoo, ");
INSERT INTO waj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","tuduu rikioo Yisuuva iya sai tunoo: Iyauvaa vara ni miatee, ");
INSERT INTO waj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","kiaa kioo hanigia gioonna kiaapuuya tunoo: Ferefuruunnaivau variatee, tuduu ivau varuduu bereeta yaaku saivai tavau taaravaitanaatama tu kioo vainno avuuvaa reeri ngiau aapu too vainno Anutuuqaata kua yoketaivaa tioo bereetaiyauvaata tavauvaitanaatama kusiinnonno kioo ari ngiaammuauya mmuduu varada gioonna kiaapuuya mmuduu ");
INSERT INTO waj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","mmuakiaaya nnooduduu iya ausaiyauvo rasituduu ari ngiaammuauya utua yaakuuvaitana yukukidiri taaravaitanaki yeenna nneeda kioo arai yatiiyauvaa rupi nuunama rummua yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Vaidi ivaki varida yeenna nnooya kaayau (5000) variravai. Iya hama gioonna nnaakaraiyaatama yaariravai. ");
INSERT INTO waj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iya nnaa taika kiooduu Yisuuva ari ngiaammuauya yaagueeqama titoo tunoo: Na gioonna kiaapuuya titee varinai ngieenanaa tauraa kanuuvaki karada nnoori sainai kuatee, tuduu rikiada vida varuduu ");
INSERT INTO waj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","gioonna kiaapuuya ngiari yoosinnaipira titooduu vuduu too Yisuuva arivai yaaku varaanara taapi kiisaivaura viravai. Vioo vioo oro varioo yaaku varooduduu heenauduu rikioo arivai ivau varuduu ");
INSERT INTO waj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ari ngiaammuauya varuu kanuuvo nnoori haruunga pinaivaa vuutaivaki vioo varuduu yatari sagaiyauvaa utida nnooriivaa ruvuatidada tooduu yuunna yaamurukaivo yaagueeqama iyasi ngioo iya kanuuvaa hanigiaanigiooduu ");
INSERT INTO waj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","patainara uuduu Yisuuva nnoori verenoovau raa roo iyasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iyasi nnuduu teeda kaayauma aatuuda tunoo: Mmagia maisavainno nninoo, ");
INSERT INTO waj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","kiaa kiada kai kiririingaida varuduu Yisuuva akiairaama iya tunoo: Tirooma variatee. Sa aatuukiatee. Na ngiaunoo, ");
INSERT INTO waj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","tuduu rikiada Petorooso tunoo: Udaanga-o, a kutaa Yisuuvavee tiee ni tinai na nnoori verenoovau aisi kuanaravee, ");
INSERT INTO waj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","tuduu rikioo tunoo: Ngianee, tuduu rikioo Petorooso kanuuvaa pikioo nnoori verenoovau Yisuunnasi ari yuku raa roo viravai. ");
INSERT INTO waj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Vioo varioo tooduu yuunnaivo utuduu too aatuunno nnoori aakiaivaki mmeepi vioo rikioo aayanna roo tunoo: Udaanga-o, ni utuanee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ivo itaa kua tuu saivaata Yisuuva yaakuuvaadiri reeti inna sootu utuoo tunoo: Aaniira a niiyara taara yaata utuannavainnee? A kati kiisama niiyara kutaavaivee kiannavaivee, ");
INSERT INTO waj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","kiaa kioo innaata vitoo kanuuvaki karada oro varuduu yuunna yaamurukaivo taikeeravai. ");
INSERT INTO waj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Taikooduu ari ngiaammuau kanuuvaki varuuya Yisuunna ngiari ausa mmuduuyaiyauvaa mmida tunoo: A kutaa Anutuuqaa Mmaapu tuanaakuavee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tuduu iya nnoori sainai yoosinna Genesareeta oro varuduu ");
INSERT INTO waj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","gioonna kiaapuuya Yisuunna arinaima teeda ngiari seenaiya titooduu vo yoosinna vo yoosinnaiyauvaki nuaida varida mmuakiaa gioonna kiaapu nniitarooya vitada Yisuunnasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nnida Yisuunna yaparaida tunoo: Pikinai nniitaraiya i buruqa araivau utuatee. Tuduu mmuakiaaya inna buruqa araivau utuuya nniitarooyauvo taikeeravai. ");
INSERT INTO waj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iya nniitarooyauvo taikooduu teeda Farisai vaidi vooyaata kua mmaanna kiaa mmira vaidi vooyaatama vaa Yerusareemadiri nnuuya numa Yisuunna yaparaida tunoo: ");
INSERT INTO waj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Aaniira i ngiaammuauya ti taato nnaakukiaiyasidiri nnuu aataruuvaa hatokaannee? Iya yeenna nneera suaivaki hama ngiari yaakuuyauvaa tuqinnama finirama kiada iya yeenna nnaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tuduu rikioo Yisuuva iya sai tunoo: Mo ngiingii yaata tinniyaa vai aataruuyauvaa iikiaaraivaara ngia Anutuuqo tuu kuaivaa hatokaavai. ");
INSERT INTO waj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutuuqaa kua fafaaraivo vainno tinoo: Ngii kaano koovaitanaara mmuduuya rida tuqinnaatee, tikio vo kua voovai vainno tinoo: Gioonna kiaapu voovoono ari kaano koovaitana maisa kua tiivaa ruputikio putuaivee. Anutuuqaa kua fafaaraivo vainno itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mo ngiengieenoo kiaanoo: Fai gioonna kiaapu voovoono ari kaano koovaitana tuqinnaanara mmatayaa diaa mminnaivaa iyani yapa kioo ivaara tinara: Inna Anutuuqaa mminnaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kiaa kioo aikiooma hama ari kaano koovaitanaara tuqinnaanaravee. Ngia itaa kua kiaavai. Ngia itaida ngiingii yaata tinniyaa vai kuaivaa iikiaaraivaara Anutuuqo tuu kuaivaa hatokaavai. ");
INSERT INTO waj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ngia huoobavainna unnakua nnaamuru tuanaayavee. Nnaaruaa vaidi forofetaa voovai Yisayaava kua kutaavai ngiiiyara fafaara roo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Anutuuqo tinoo: Aa gioonna kiaapu aaya mmanna kuasiiyauvoono koroonno niiyara yoketaavaivee kiaavo hama iya aakiaiyauvo niiyara yoketainoo. ");
INSERT INTO waj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iya vaidiiya yaata tinniyaa vai kuaivaa kiaa mmi kiada kiaanoo: Anutuuqaa aataruvaivee, kiaivaara kuminayaa niiyara kua yoketaivaa kiaanoo, tiivaivee. Yisayaava fafaara roo itaa kua tuuvaa Yisuuva tiravai. ");
INSERT INTO waj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yisuuva itaa kua kiaa kioo gioonna kiaapuuya innasi ngiateera tuduu innasi nnuduu iya tunoo: Ngia rikiada arinaima rikiaatee. ");
INSERT INTO waj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Hama vaidi voovoono mminnaa voovai inna avaidaadiri rasookaivaki tuoo kuaivaara mminnamminnaa maisaivaa varaivai. Aakiaivakidiri ari avaidaagiataa ngioo mmaanai tuoo kuai ivaara mminnamminnaa maisaivaa varaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tuduu rikiada ari ngiaammuauya innasi nnida tunoo: Vaa a rikiaannannee? Farisaiya i kuaivaara nniki rakaida aiyara nnannataavaivee, ");
INSERT INTO waj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","tuduu rikioo iya sai tunoo: Mmuakiaa yeenna hauyauvaa ni Napoova ngiau aapu variivoono hama utiraiyauvaa fai hamuku kagaari kiaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sa iyara kaayauma yaata utira pikiaatee. Iya vaidi avu huruutai voovoono ari seena vaidi avu huruutai voovai yaakuuvau utuoo nuairaivaa roosiikiaayavee. Vaidi avu huruutaivoono vuai vaidi avu huruutaivaata vitoo aataruuvau kuanaree kiaa vidada fai aiqeeravaitana soopaivaki tiida kuaaravee, ");
INSERT INTO waj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","tuduu rikioo Petorooso tunoo: A mmatayaa diaa mminnaivaudiri mmataama kiee kianna kua oyaivaa ti kiaa ti mmianee, ");
INSERT INTO waj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","tuduu rikioo Yisuuva iya tunoo: Ngia gioonna kiaapu kumimakaiya roosiima hama ngii tinniiyauvo rusitivai. ");
INSERT INTO waj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Hama ngia arinaima rikiaanoo. Mminnaa voovai vaidi avaidaadiri tuoo rasookaivaki vainno tuoo rukioo mmaanai kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Vaidi voovoono inna aakiaivaki vaivaa ari avaivakidiri tiivaara mminnamminnaa maisaivaa varaivai. ");
INSERT INTO waj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vaidi aakiaivakidiri maisa kuaivo ngioo yaataivaki kuaikio yaata utuoo vaidiivaa ruputikio putikio nnaata vaati varaivo mmuara heera aataruuvaa iinno mminnaivaa mmuara varoo unnakua kiaa ari seenaiya kua pinaana yapa kioo ari seenaiyara maisa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ii aataru iyauvaara vaidiivo mminnamminnaa maisaiyauvaa varaivai. Ivo yaaku kainaama kuaivaa tasipama yeenna nnaivaara hama mminnamminnaa maisaivaa varaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yisuuva itaa kua kiaa kioo ii yoosinna ivaa pikioo vioo yoosinna taaravaitana nnutuuvaitana Turu Sitoona vainima vau yoosinnaivaki viravai. ");
INSERT INTO waj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Vuduu rikioo ari voopinnaa yoosinnaivaa nnutuuvo Kanaanaa ivakinnaa gioonnaivo Yisuunnasi ngioo aayanna roo tunoo: Udaanga-o, Davuitiinna oyaivakidiri diiteeraikuavee. Niiyara boo kianee. Mmagia maisaivo ni naunnaivaa aakiaivaki varikio kaayauma kumimakainoo, ");
INSERT INTO waj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","tuduu rikioo hama ivo inna sai tuduu ari ngiaammuaudoono numa inna vuavi tida tunoo: Gioonnaivo ti nnaagiaidiri numa tarikama tii ivaa titano kuaivee, ");
INSERT INTO waj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","tuduu rikioo Yisuuva iya sai tunoo: Isarairaa gioonna kiaapu puara sipisiipaiya raubiriikiaiya roosiikiaiyara nnaasu Anutuuqo ni titooduu na tiiravaivee, ");
INSERT INTO waj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","tuduu rikioo gioonnaivo inna yuku oyaivaki numa rauguru varioo inna tunoo: Udaanga-o, ni naunnaivaa tuqinnaanee, ");
INSERT INTO waj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","tuduu rikioo Isarairaiya tauraa rikiooyara Yisuuva aa kua aavaa mmataama kioo inna sai tunoo: Ta kuminayaa nnaakaraiya yeennaiyauvaa varada faiya mmiaarainnoo, ");
INSERT INTO waj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","tuduu rikioo ivo faivaa roosiima ariiyara yaata utuoo inna sai tunoo: Udaanga-o, a kutaa kuavai kiannanoo. Mo faiya numa ngiari haitatuukiaiya yeenna nneeda kiaa araiyauvo terenaivau tuoo kuaiyauvaa porooma nnaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","tuduu rikioo Yisuuva inna sai tunoo: Gioonna-o, a niiyara kutaavaivee kiannanoo. A ni yaparakiannaivaa na iinaravaivee, tiravai. Ivo itaa kua tuu saivaata gioonnaivaa raunnaivo yoketaama kati hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisuuva ivaki pikioo nnoori haruunga Karirayaa mmaagaivau nuainnonno taapiivau karoo oro ivau varioo tooduu ");
INSERT INTO waj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","gioonna kiaapu kaayauya nnida yuku yaaku rauyaata avu huruutauyaatama hama kua tuuyaata ari vookarau nniitarooyaatama vitada inna avuuvau nuunama yapa kiooduu ivo mmuakiaaya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tuqinnooduu teeda hama kua tuuya kua tuduu yuku yaaku rauya yoketauduu avu huruutauya yoketaama avu tooduu gioonna kiaapuuya iva uuvaa teeda nnikiaraida Isarairaaya Anutuuqaa tuanaivaara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tuduu Yisuuva ari ngiaammuauya innasi ngiateera iya tuduu innasi nnuduu tunoo: Gioonna kiaapuuya taaravooma suaivaa ni tasipama nookiaavovo vaa yeennaiyauvo taika kiaivaara na iyara boo kiaunoo. Hama na kati iya ngiari yoosinnaiyauvakira titanai kuaaravee. Fai iya hama yeenna nneeraida vikio aataru tammaivaki iya avuuyauvo ngioo vi ngioo vinai sabi yuku raarainnoo, ");
INSERT INTO waj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","tuduu rikiada ari ngiaammuauya inna yaparaida tunoo: Aa yoosinna aavo koo mmuyai gaanga yoosinnavaivee. Deevakidiri ta kaayau yeennaiyauvaa varada aa kaayau gioonna kiaapu aayaa mmiaarannee? ");
INSERT INTO waj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","tuduu rikioo Yisuuva iya sai tunoo: Naana bereetayauvai ngiiisi vainnee? tuduu rikiada iya inna sai tunoo: Bereeta yaaku saivai karasaidiri taaravaitana vaikio tavau kiisa vookiangii vainoo, ");
INSERT INTO waj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","tuduu rikioo gioonna kiaapuuya mmatayaa variateera tuduu mmatayaa varuduu ");
INSERT INTO waj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","tavau kiisaikiangiaata bereeta yaaku saivai karasaidiri taaramaatama tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo iyauvaa kusiinnonno kioo ari ngiaammuauya mmuduu gioonna kiaapuuya mmuduu nneeravai. ");
INSERT INTO waj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mmuakiaaya nnooduduu iya ausaiyauvo rasituduu ari ngiaammuauya iya yeenna nneeda kioo arai yatiiyauvaa utua yaaku saivai karasaidiri taara utuavaitanaki rupi nuunama rummua yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Vaidi yeenna nnooya kaayau (4000) variravai. Hama iya gioonna nnaakaraiya yaariravai. ");
INSERT INTO waj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hama yaaruduu Yisuuva gioonna kiaapuuya titooduu vuduu kanuuvaki karoo varioo yoosinna pinaivaa nnutuuvo Makataraa viravai. ");
INSERT INTO waj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Vaidi Farisai vooyaata vaidi Satuukai vooyaatama Yisuunnasi nnida inna iida taaraivaara inna yaparaida tunoo: A Anutuuqaa mmoori ari vookaraivaa iinai ta teeda kiaara: Anutuuqaa yaagueeqaivo inna tasipaikioonno iinoo, kiaaravee, ");
INSERT INTO waj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","tuduu rikioo Yisuuva tunoo: Pataikio heenanaanna suaivo reera kioo kaakanooka visikiai ngia teeda kiaanoo: Inna fai makee suai pinaa taanaraikioonno itainoo, kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pataikiai ngia diitada ngiauvau taavo nama upisiivo raikiai ngia kiaanoo: Fai makee inna vatiivo ruanaraikioonno itainoo, kiaavai. Ngia ngiauvaa teeda suaivo taanaraivaara arinaima teeda vatiivo ruanaraivaara arinaima taavai. Mo ngia aanna makee ta variaunna suai aavaa hama tuqinnama teeda hama ni oyaivaara arinaima rikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ngieeta gioonna kiaapu makee variaiyaatama koonnama varida hama Anutuuqaara yaagueeqakiaanoo. Ngia Anutuuqaa mmoori ari vookarai voovaara fai ni yaparaikiai fai hama na iinaravai. Anutuuqaa mmoori ari vookaraivaa nnaaruaa vaidi Yonaava uuvaa roosiivaa ngia ivaa nnaasu taaravaivee, kiaa kioo iya pikioo viravai. ");
INSERT INTO waj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yisuuva ari ngiaammuauyaatama kanuuvaa varada nnoori haruunga sainai oro varuduu ari ngiaammuauya bereetaiyauvaa tasipama varada ngiaaree tuuvaata taunnu kiada nniravai. ");
INSERT INTO waj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nnuduu too Yisuuva vaidi Farisaiyaata vaidi Satuukaiyaatama iira aataruuvaara mmataama kioo iya tunoo: Vaidi Farisaiyaata vaidi Satuukaiyaatama puuqaira yeennaivo bereeta aakiaivaki too yootaivaa roosiivaara tuqinnama haitatuukiatee, ");
INSERT INTO waj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","tuduu rikiada ngiari kiaa mmi ngiari kiaa mmiida tunoo: Hama ta bereetaivaa varada ngiaunnaivaara ivo itaa kua tinoo, ");
INSERT INTO waj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","tuduu rikioo Yisuuva ngiari kiaa mmi ngiari kiaa mmuu kuaivaa arinaima rikioo iya yaparainno tunoo: Ngia aaniiraida ngiingii kiaa mmi ngiingii kiaa mmiida kiaanoo: Ta hama bereetaiyauvaa varada ngiaunnanoo, kiaannee? Ngia kati kiisama niiyara kutaavaivee kiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ngia homooda hama niiyara arinaima rikiaannee? Na yaaku sai bereetavai kusii kiee kaayau vaidiiya (5000) mmuuvaara vaa ngia taunnu kiaannee? Yeenna nneeda kioo arai yatiiyauvaa ngia rupi nuunama utuaiyauvaki ruuyauvo naana utuayauvai vairavainnee? ");
INSERT INTO waj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nnaagiai na bereeta yaaku saivai sainaidiri taarama kusii kiee kaayau vaidiiya (4000) mmuuvaara vaa ngia taunnu kiaannee? Yeenna nneeda kioo arai yatiiyauvaa ngia rupi nuunama utuaiyauvaki ruuyauvo naana utuayauvai vairavainnee? ");
INSERT INTO waj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na aanna hama bereeta tuanaiyauvaara ngii giaa ngii miauvaa ngia aaniira hama arinaima rikiaannee? Vaidi Farisaiyaata vaidi Satuukaiyaatama puuqaira yeennaivo bereeta aakiaivaki too yootaivaa roosiivaara tuqinnama haitatuukiatee, ");
INSERT INTO waj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","tuduu rikiada ari ngiaammuauya tinniiyauvo rusituduu arinaima rikieeravai. Gioonnaivo puuqaira yeennaivaa bereetaivaki yapaivaara hama Yisuuva tiravai. Vaidi Farisaiya kua kiaa mmira aataruuyauvaaraata vaidi Satuukaiya kua kiaa mmira aataruuyauvaaraatama tuqinnama haitatuukiateeraivaara Yisuuva tiravai. ");
INSERT INTO waj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yisuuva yoosinnaivaa nnutuuvo Kaisariaa Piripii vainima vauyauvaki oro varioo ari ngiaammuauya yaparainno tunoo: Na Vaidiivaa Mmaapuuvaara gioonna kiaapuuya niiyara dee vaidivainnee kiaa kiada dataa kuaida kiaannee? ");
INSERT INTO waj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","tuduu rikiada iya inna sai tunoo: Vooyaano kiaanoo: Yuvuaano nnoori apira vaidivaivee, kiaani vooyaano kiaanoo: Irayaavavee, kiaani vooya kiaanoo: Yirimiaavavee, kiaani vooya kiaanoo: Ari vo forofetaa vaidivaivee, kiaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","tuduu rikioo Yisuuva iya yaparainno tunoo: Mo ngieeta niiyara dataa kuaida kiaannee? ");
INSERT INTO waj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tuduu rikioo Simoono Petorooso inna sai tunoo: A vaidi Anutuuqo i mmataama kioo vaidiikuavee. E Anutuuqo tupatupaa variraivaa Mmaapukuavee, ");
INSERT INTO waj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","tuduu rikioo Yisuuva inna sai tunoo: Simoono, Yuvuaanaa mmaapukuavee. Anutuuqo aiyara pinaama yoketainoo. Hama mmatayaa diaa gioonna kiaapuuyaano ii a kianna kua kutaa ivaa i kiaa i mmiaanoo. Ni Napoova ngiau aapu variivoono safuuma i kiaa i mmikiai a kiannanoo. ");
INSERT INTO waj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na i kiaa i mmiaunoo. I nnutu Petoroosaa oyaivo oora sikauvai. A niiyara kianna kuaivo sikau roosiivai. Gioonna kiaapuuya ii kua ivaa rikiada ausa hanigiaiya na vitee aataru yoketaivau yapa kinai yaagueeqama variaaravai. Fai hama putiraivaa yaagueeqaivoono ii aataru ivaa yaataraanaravai. Fai vooya putikiai vooya homo variaiya fai yaagueeqama variaaravai. ");
INSERT INTO waj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anutuuqo ngiau aapu gioonna kiaapuuyara diraivaa yaagueeqaivaa na i mminaravai. A mmatayaa varianna suaivaki mminnaivaara ooqoo kiannaivaa fai Anutuuqo ngiau aapu variivoota ooqoo tinaravai. A mmatayaa varianna suaivaki mminnaa voovaara ee-oo kiannaivaa fai Anutuuqo ngiau aapu variivoota ee-oo tinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","kiaa kioo ari ngiaammuauya yaagueeqama tunoo: Na vaidi Anutuuqo ni mmataama kioovaara sa gioonna kiaapuuya kiaa mmiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ii suai ivakidiri Yisuuva ari ngiaammuauya kua kooyaa kiaa mmioo tunoo: Na Yerusareema vinai vaidi yokovaiyaatama vaidi Anutuuqaara kati puara hudeera kieetaiyaata kua mmaanna kiaa mmira vaidiiyaatama kaayau mmamma nniitareeraivaa ni mikiai vaidiiya ni ruputikiai na putino taara suaivaitana taikano voomaivaki Anutuuqo tinai na keenaa diitaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","tuduu rikioo Petorooso inna vitoo mmaraa voovau oro kioo yaagueeqama inna tunoo: Udaanga-o, kii Anutuuqo iya tinniiyauvaa hanigianai iya sa aiyara itaa kua kiatee, ");
INSERT INTO waj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","tuduu rikioo Yisuuva hanigioo Sataango Petoroosaa tasipoovaara inna tunoo: Sataango, ngieera kuanee. A ni aataruuvaa uudarainaree kiainna iikiannanoo. I yaataivo vaidiiya yaataivaa roosiinoo. Hama Anutuuqaa yaataivo itaama vainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yisuuva itaa kua kiaa kioo ari ngiaammuauya tunoo: Fai gioonna kiaapu voovoono ni nnaagiai nninaree tioo fai ari yaata utira aataruuvaara ooqoo tioo gioonna kiaapuuya niiyara inna ruputikio na putuauneema ivo putinaraivaara ee-oo tioo ni nnaagiai ngiaivee. ");
INSERT INTO waj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Fai gioonna kiaapu voovoono ari mmatayaa variraivaara yaagueeqama yaata utuoonnonno fai yapooma hama ivo tupatupaa varinaraivootainaravaivee. Fai gioonna kiaapu voovoono hama ari mmatayaa variraivaara yaata utirainno niiyara putinaraivaara ee-oo tiivo fai tupatupaa variraivaa varaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Fai gioonna kiaapu voovoono mmuakiaa mmatayaa diaa mminnamminnaiyauvaa ariyara varoo hama tupatupaa variraivaara yaata utirainno putuoo dee irisai yoketaivaa fai Anutuuqaasidiri varaanarannee? Fai hama varaanaravaivee. Gioonna kiaapu voovoono hama yopeema irisai mminnaivaadiri Anutuuqaa mmioo tupatupaa variraivaa varaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Fai yapooma Na Vaidiivaa Mmaapuuvoono ni Napoonna mmeekia ari vookaraivoota inna aangeraiyaatama keenaa tiinaree tiee fai na tiee mmuakiaa gioonna kiaapuuya ngiari mmooriivaa iikiaivaugiataama irisaiyauvaa iya mminaravai. ");
INSERT INTO waj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na kua kutaavai ngii giaa ngii miaunoo. Fai gioonna kiaapu vooya aavaki diaiya hama putirama kiada varida teekiai Na Vaidiivaa Mmaapuuvo kieetavai varinai teeda taaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yapooma yaaku saivai karasaidiri mmuaa suaivai taika kiooduu Yisuuva Petoroosaa vitoo Yakoopaa vitoo Yakoopaa kataivaa Yuvuaanaa vitoo taapi hokobaivaura ngiarivana nnaasu viravai. ");
INSERT INTO waj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Vidada oro ivau dida vaida tooduu Yisuunna mmammaivo hanigioo ari vookarairavai vauduu inna oori nnikiivo suaivaa roosiima tooduu inna uyira raraiyauvo mmeekia roosiima poosairavai. ");
INSERT INTO waj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Poosauduu teeda Yisuunna ngiaammuau taaravoomaivaitana tooduu nnaaruaa vaidi putuuvaitana Musiiya Irayaaya Yisuunnaata kua tida varuduu ");
INSERT INTO waj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petorooso Yisuunna tunoo: Udaanga-o, ta aavaki variaunnano ti yoketainoo. A rikino i variatainai tinai na aavau unnakua nnau taaravooma heekaanaravee. Aini voovai heekee Musiinnani voovai heekee Irayaannani voovai heekaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","tuduu tuu saivaata nama mmannaammannauvo tuoo iya rummua apu kioo vauduu Anutuuqaa kuaivo nama aakiaidaadiri tuoo tunoo: Inna ni Maapu tuanaivovee. Na innara mmuduuya ruee na inna tauko pinaama ni yoketainoo. Inna kuaivaa rikiaatee, ");
INSERT INTO waj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","tuduu rikiada Yisuunna ngiaammuauya mmatayaa vida varada vaida ngiari avuuyauvaa hatauma kiada vaida kaayauma aatuuda varuduu ");
INSERT INTO waj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yisuuva numa iyayaa utuoo tunoo: Diitaatee. Sa aatuukiatee, ");
INSERT INTO waj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","tuduu rikiada mmataivaudiri vaida reeri tooduu hama vaidiivaitanaatairavai. Yisuuva ari nnaasu dioo vairavai. ");
INSERT INTO waj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dioo vauduu teeda diitada ivaatama taapiivau pikiada tiida varida Yisuuva yaagueeqama iya kiaa mmioo tunoo: Makee ngia taa ari vookarai aataruuvaara sa gioonna kiaapuuya kiaa mmiatee. Na Vaidiivaa Mmaapuuvoono yapooma na putuee kava diitanai teeda ngia makee taivaa gioonna kiaapuuya kiaa mmiatee, ");
INSERT INTO waj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tuduu rikiada iya inna yaparaida tunoo: Anutuuqaa kua mmaanna kiaa mmira vaidiiya kiaanoo: Irayaavannaadee tauraa tiinaravai. Tiino Anutuuqo mmataama kioo vaidiivo nnaagiai tiinaravaivee, kiaa kuaivo aaniira ngiari itaa kua kiaannee? ");
INSERT INTO waj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","tuduu rikioo Yisuuva iya kua sai tunoo: Kutaavai. Vaidi voovoono Irayaanna roosiivoono tauraa ngioo mmuakiaa mminnaivaa safuunaraivo nninoo. ");
INSERT INTO waj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na ivaara ngii giaa ngii miaunoo. Vaa Irayaanna roosuuvo nniravai. Nnuduu hama gioonna kiaapuuya tuqinnama inna teerama kiada iya ngiari iikiatau mmoori maisaivaa innara iiravai. Na Vaidiivaa Mmaapuuvaa fai yapooma iya mmuaikarai mmoori maisaivaa fai ni miaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","tuduu rikiada Yuvuaano nnoori apira vaidiivaara tuuvaa iya arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yisuuva ari ngiaammuau taaravoomaidootama tiida gioonna kiaapuuya nuunama duuvau iyaatama dida vauduu vaidi voovoono numa Yisuunna vunnigiataa toorivu yau haroo ");
INSERT INTO waj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","tunoo: Boo, Udaanga-o, ni maapuuvaara boo kianee. Ivo kaayauma kararuoo kumimakaikio inna ruputiraivo ruputikio vo suai vioo varoo ikiana vaivai. Vo suai ruputikio vioo varoo nnoorina vaivai. ");
INSERT INTO waj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na inna vitee i ngiaammuauyasi kuaukai hama iya inna yopeema tuqinnaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","tuduu rikioo Yisuuva inna kuaivaa sai tunoo: Ngia gioonna kiaapu makee variaiya hama ngia niiyara kutaavaivee tiraidaida koonnamaida variaanoo. Na hokoba suai ngii tasipama hara kiee variaukai hama ngia niiyara kutaavaivee kiaavai. Fai na naana suai ngii tasipama hara kiee varinanai ngia niiyara kutaavaivee kiaarannee? Na ngii tasipama hara kiee varinai ngia ni kuaivaa rikiaaraivaara na faannaina variaunoo. Ngiaammuauvaa vitada aapi niisi ngiatee, ");
INSERT INTO waj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","tuduu innasi vitada nnuduu mmagia maisaivo ngiaammuauvaa aakiaivaki hara kioo varuuvaa yaagueeqama tuduu tuoo vuduu ngiaammuauvo makee tuduu kati hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Varuduu nnaagiai Yisuuva voovaki hara kioo varuduu ari ngiaammuauya innasi nnida inna yaparaida tunoo: Mo dataama vaikio mmagia maisaivaa ta titaunnano hama kuainnee? ");
INSERT INTO waj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","tuduu rikioo ivo iya sai tunoo: Ngia hama yaagueeqama yaata utida kiaanoo: Anutuuqoono fai iinaravaivee, kiaivaara hama kuaivai. Na kua kutaavai ngii giaa ngii miaunoo. Uruuvaa nnutuuvo masateeraivo kiisa uruvai. Fai ngia masateeraivaa uruuvaa roosiima kiisama Anutuuqo kutaa iinaravaivee kiaa kiada aa taapi aavaa kiaara: Aavaudiri hayee ukuapi kuanee, tikio fai ngii kuaivaara hayoo ukuapi kuanaravai. Fai ngia kiisama Anutuuqo kutaa iinaravaivee kiaa kiada fai ngia mmuakiaa mmoorivai iikiaaree tida fai ngia iikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Vaidi voovoono hama yeenna nneeraivaara yaata utirainno yaaku vareeraivaara yaagueeqairaivoono fai itaama ii mmagia maisa ivaa titano kuanaravai. Kumina vaidi voovoono fai hama yopeema titano kuanaravaivee, tiravai.) ");
INSERT INTO waj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yisuunna ngiaammuauya nuunaida yoosinna Karirayaa varuduu Yisuuva iya tunoo: Fai vaidi vooyaano Na Vaidiivaa Mmaapuuvaa ni vitada vaidi vooya mmikiai ");
INSERT INTO waj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iya ni ruputikiai fai na putino taara suaivaitana taikano vooma suaivaki Anutuuqo tinai na keenaa diitaanaravaivee, tuduu rikiada ari ngiaammuauya ivaara kaayauma ausa mmuaarareeravai. ");
INSERT INTO waj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yisuuva ari ngiaammuauyaatama numa yoosinna Kapanauma varuduu nuunaira nnauvaara sikau takiisa vareera vaidiiya numa Petoroosaa yaparaida tunoo: Mo i vitairaivo nuunaira nnauvaara takiisa sikauvaa yapoonnonnee? Vara hama yapainnee? ");
INSERT INTO waj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","tuduu rikioo Petorooso iya sai tunoo: Yo, yapaivaivee, kiaa kioo ari nnauvaki vuduu rikioo Yisuuvananaa tauraa innaata kua tioo tunoo: Simoono, a dataa kuainna kiannannee? Mmatayaa diaa vaidi kieetaiya takiisa sikaura ngiari seenaiyasidiriida iya yaparaida varaannee? Vara saina sainaayasidiriida yaparaida varaannee? ");
INSERT INTO waj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","tuduu rikioo Petorooso inna sai tunoo: Mo saina sainaayasidiri yaparaida varaanoo, tuduu rikioo Yisuuva inna tunoo: Fai saina sainaayaano yapa kikiai fai hama ta mmaayootaiya yapaaravee. ");
INSERT INTO waj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Itaama vainainnaata hama ta sikau takiisa vareera vaidiiya sikauvaa mmikiai iya tiiyara momonakiaarainnoo kiaa nnoori haruungaivaki viee tavaura ooviivaa ivaki yapa kino ivau tauraa hai tavauvaa utu raririima kiee inna avaivaki taanee. Teeno sikau voovai ivaki vainai tee varee takiisa vareeraiyasi viee niiyara saivai yapee aiyara saivai yapaanee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ii suai ivaki Yisuunna ngiaammuauya innasi nnida tunoo: Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki deevoono ari seenaiya yaataroo kieetavai varinarannee? ");
INSERT INTO waj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","tuduu rikioo Yisuuva nnaakaraivaa ngianeera tuduu nnuduu rikioo ngiari tammaivaki yapa kioo ");
INSERT INTO waj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Fai ngia hama hanigiada nnaakara kiisaiya roosiima varida fai hama Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuaaravee. ");
INSERT INTO waj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gioonna kiaapu voovoono aa nnaakara aavaa roosiima tirooma varioo hama ari nnutuuvaa aruoo yapaivoono fai Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki ari seenaiya yaataroo kieetavai varinaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Gioonna kiaapu voovoono niiyara mmuduuya ruaivaara aa nnaakara aavaa roosii voovaara tuqinnaivoono inna niiyaraatama tuqinnainoo. ");
INSERT INTO waj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Aa nnaakara kiisa aaya niiyara kutaavaivee kiaa aaya roosii gioonna kiaapu voovai vaidi voovoono iva ii aataru yoketaivaa pikiaiveeraivaara inna yaparaivo inna aataru maisavai. Fai tauraa vaidi vooya inna vitada sikau pinaivaa varada dutuyu kiada inna nnuunaivaki haru kiada nnoori haruunga pinaivaki kagaari kikio vioo taika kino hama ivo inna yaparainaraivootainaravai. Fai hama ivo inna yaparainaraivo inna yoketaavai. ");
INSERT INTO waj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Boo, ta gioonna kiaapu mmatayaa variaunnaiya ti haruriraivo vaikiainnaata variaunnanoo. Harurira aataruuvo fai tupatupaa tiisi vainaravai. Vainai fai vaidi voovoono ari seena vaidi voovai hanigiaanigieevo fai pinaa irisai maisaivaa varaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A i yaakuuvaadiri a reeti utu reeri utinarainnoo kiaa ivaa mmuaanaa hatoka kiee kagaari kiaanee. I yukuuvoono i vitoo aataru maisaivau nuainarainnoo kiaa mmuaanaa ivaa hatoka kiee kagaari kiaanee. Fai a vakiaa yuku yaakuvaitanaatama variee tupatupaa variraivaa varaanaraivo inna yoketaavai. Fai i yuku yaaku eyommaavaitana vaida ikiaivo tupatupaa too variivaki i kagaari kiaaraivo inna maisavai. ");
INSERT INTO waj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Fai ai avuuvaadiri mminnamminnaa maisaivaa tee varaanarainnoo kiaa i avuuvaa mmuaanaa ranigaama kagaari kino mmuaa avuvai vainai fai a tupatupaa variraivaa varaanaraivo inna yoketaavai. Fai i avuuvaitana vaida ivaitanaano ikiana i kagaari kiaaraivo inna maisavai. ");
INSERT INTO waj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Aa nnaakara aaya roosiikiaa gioonna kiaapuuya sa iyara nniki rakammuatee. Sa iyara maisayavee kiatee. Na ngii giaa ngii miaunoo. Ngiari aangeraiya ngiau aapu ni Napoonna tasipama variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Na Vaidiivaa Mmaapuuvoono gioonna kiaapu raubiriikiaiya vitaanaraivaara na tiiravai.) ");
INSERT INTO waj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ngia yaata utuaivo datainnee? Vaidi voovoono yaaku sai vaidivai yuku yaaku taika kioo puara sipisiipaiyauvaa virikio voovai iyakidiri raubiriino fai ivo datainaravainnee? Ivo ari sipisiipa saiyauvaa (99) taapiivau pikioo mmuaavai raubiriivaara fai ivo buainara kuanaravai. ");
INSERT INTO waj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na kua kutaavai ngii giaa ngii miaunoo. Ivo buainnonno teeno raubiriivo inna too vaino innara kaayauma mmuduuya ruoo sirigainno seena hama raubiriikiaiyara kiisama mmuduuya rinaravai. ");
INSERT INTO waj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sipisiipa nakaaraivo raubiriivaara inna ausaivo mmuaararaineema ngii Gioova ngiau aapu variivo aa nnaakara aaya roosiikiaa gioonna kiaapuuya raubiriikiaivaara inna ausaivo mmuaararainoo. ");
INSERT INTO waj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Fai i seena vaa ausa hanigiai voovoono mminnamminnaa maisaivaa i iinai tee a innasi viee ngia taarama nnaasu varida inna mminnamminnaa maisaivaara kua kiatee. Fai ivo i kuaivaa rikinai ngia taaravaitana mmuaavau yoketaama variaaravai. ");
INSERT INTO waj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Fai ivo hama i kuaivaa rikinai a vaidi voovainnee vara voovaitanaata vitee oro innaata kava kua kiatee. Anutuuqaa kua fafaaraivo vainno tinoo: A kua pinaana vaidiivaa yapaanaree tiee taaramannee taaravooma vaidiidaatama vitee yaparakianee, tiivai. ");
INSERT INTO waj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Vaa a vitee innasi kuannaiya kuaivaa hama ivo rikinai rikiee gioonna kiaapu vaa ausa hanigieeraiya ivo i ii kuaiyauvaa iya kiaa mmianee. Kiaa mmino inna fai ivo hama iya kuaivaa rikinai teeda ngia innara yaata utida kiatee: Inna aikioo, ari voopinnaa vaidivai roosiima variee sikau takiisa vareeraivaa roosiima varianee, kiatee. ");
INSERT INTO waj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na kua kutaavai ngii giaa ngii miaunoo. Ngia variaa mmataivau mminnaivaara ooqoo tikio rikioo fai Anutuuqo ngiau aapuuvaki variivoota fai ooqoo tinaravai. Ngia variaa mmataivau mminnaa voovaara ee-oo tikio rikioo Anutuuqo ngiau aapuuvaki variivoota fai ee-oo tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Na vo kuavai ngii giaa ngii miaunoo. Ngia variaa mmataivau fai ngiiikidiri taara vaidivaitana mmuaa mmoorivaara yaaku varada kua yeena raikio too ni Napoova ngiau aapu variivo ivaitana kuaivaa rikioo ivaitanaani iinaravai. ");
INSERT INTO waj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gioonna kiaapu taaramannee taaravoomaano niiyara yaata utida nuunama variaani na iya tasipama variaunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yisuuva itaa kua tuduu Petorooso numa inna tunoo: Udaanga-o, na naananeetu ni seenaivo mmoori maisaiyauvaa ni iinai na hama iyauvaara yaata utirama kiee ni ausa mmuduuyaivaa inna mminarannee? Na yaaku saivai karasaidi taaraneetu iinarannee? ");
INSERT INTO waj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","tuduu rikioo inna sai tunoo: Sa yaaku saivai karasaidiri taaraneetu nnaasu iikianee. Sa yaarummua kiee iikianee. ");
INSERT INTO waj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anutuuqo gioonna kiaapuuyara diraivo aa na tinara kua aavaa roosiima vaivaara ataama iikianee. Vaidi kieeta voovoono ari mmoori vareera vaidiiya sikau iya mmiiyauvaa irisaiyauvaara iya yaparaivai. ");
INSERT INTO waj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yaparainno varikiai vaidiiyaano vaidi voovai vitada ngiaavo inna sikau irisai mmiiyauvo kaayau ari vookarai sikau (10,000,000) vaikio ");
INSERT INTO waj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","hama sikaunnaataikio ari kieetaivo innara tinoo: Aa vaidi aavaata ari nnaata nnaakaraiyaatama vitada ari hoonaiyauvaatama varada vaidi voovai mmida irisai sikauyauvaa varada numa ni miatee, ");
INSERT INTO waj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","tikio rikioo mmoori varoo vaidiivo ari kieetaivaa yuku oyaivaki toorivu yau haroo yaagueeqama inna tinoo: Tirooma variee sa i ausaivo niiyara i nnannataivee. A varinai fai yapooma na mmuakiaa irisaiyauvaa i mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","tikio rikioo vaidi kieetaivo innara kaayauma boo tioo tinoo: Inna aikioo, sa irisai sikauyauvaa ni mirainna kati kuanee, kiaa kioo titaa kiaikio kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Vioo ari seena mmoori vareera vaidiivaa vaa ivo tauraa kiisa sikaukiata (100) nnaasu inna mmikio rikioo irisaivaa hama sai inna mmiivoono inna saidi nnikio too oro inna nnuunaivaki hadauma tu kioo vainno tinoo: Ni sikau irisaiyauvaa ni mianee, ");
INSERT INTO waj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","tikio rikioo inna yuku oyaivaki toorivu yau haroo yaagueeqama inna tinoo: Tirooma variee sa i ausaivo niiyara i nnannataivee. A varinai fai yapooma na irisaiyauvaa i mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","tikio hama rikieerama kioo vitoo oovi nnauvaki yapa kiaikio sikau irisaiyauvo vaino too mmioo oovi nnauvakidiri tuoo kuanaraivaara ivaki hara kioo varivai. ");
INSERT INTO waj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Varikiai ari seena mmoori vareera vaidiiya ivo innara itaama ii mmooriivaa taavo iya nnannataikiai oro ngiari kieetaivaa mmuakiaa iva iivaara kiaa mmiaavai. ");
INSERT INTO waj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kiaa mmiaavo rikioo vaidi kieetaivo ari mmoori vareera vaidiivaa aayanna raikio nnikio too tinoo: A ni mmoori varaanna vaidi maisakuavee. A ni yaparakiannaivaara ai irisai sikau kaayaudaa na vakiaa varaaneera i kiauvai. ");
INSERT INTO waj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na aiyara boo kiauneema a ai seenaivaara boo kiataama vaikiainnaatainna hama a innara boo kiannanoo, ");
INSERT INTO waj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","tikio kaayauma inna ausaivo nnannataikio oovi nnau nakaaraiya mmikiai iya avaikarai mmooriivaa inna mmikio mmuakiaa sikau irisaiyauvo vaino too mmioo oovi nnauvakidiri tuoo kuanaraivaara ivaki hara kioo varivaivee. ");
INSERT INTO waj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yisuuva ii kua ivaa kiaa taika kioo ari ngiaammuauya tunoo: Ngia mmuaavai mmuaavai ngii seenaiya maisa mmooriivaa ngii iikiai rikiada ngia homo ivaara yaata utida hama ngii ausa mmuduuyaiyauvaa iya mmikio rikioo ni Napoova ngiau aapu variivootama fai sikau nakaaraivo iineema mmuaikaraama ngii iinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yisuuva ii kua ivaa kiaa taika kioo Karirayaa mmataivaa pikioo Yutayaa mmataivo nnoori Yorotaana sainai vaupi viravai. ");
INSERT INTO waj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Vioo vioo oro ivaki nuainno varuduu kaayau gioonna kiaapuuya inna nnaagiaivau vuduu ivaki iva iya too iya nniitarooyauvaa tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tuqinnooduu Farisai vaidi vooya innasi nnida ivo kuaivaa koonnama kiainaaree kiaa inna yaparaida tunoo: Fai vaidi voovoono vo kua vo kua voovaara ari nnaataivaara ooqoo tinara aataruuvo vainnee? Vara hama vainnee? ");
INSERT INTO waj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","tuduu rikioo Yisuuva iya sai tunoo: Vaa ngia aa Anutuuqaa kua aavaa yaarida rikiaavaivee. Anutuuqaa kua fafaara voovai vainno tinoo: Nnaaru Anutuuqo ngiau mmata uu suaivaki ivo vaidiivaa iinno gioonnaivaa iinno tunoo: ");
INSERT INTO waj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ivaara fai vaidiivo ari kaano koovaitana pikioo nnaataivaa varoo inna tasipama mmuaakaraivaitana variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kua fafaaraivoono itaa kua tiivaara nnaata vaatiivaitana hama taaravaitana varirama kiada ivaitana mmuaavaitana variaavai. Anutuuqoono vaa taaravaitana nuunama kiaikiai mmuaavaitana variaivaitana sa vuaivo vuaivaa pikiano sa vuaivo vuaivaa pikiaivee. Sa vaidi voovoono ivaitana vara mmarammaraama yapaivee, ");
INSERT INTO waj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","tuduu rikiada Farisaiya Yisuunna yaparaida tunoo: Nnaaru vaa Musiiva kua mmaanna voovai ti kiaa ti mmioo tunoo: Vaidi voovoono ari nnaataivaa pikiaanaree tioo ooqoo tira yanaivaa fafaarama kioo inna mmioo titano kuaivee. Mo aaniira Musiiva itaa kua tuunnee? ");
INSERT INTO waj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","tuduu rikioo Yisuuva iya sai tunoo: Ngia vaidi Yutayaiya ngii ausa vuatinniiyauvo yaagueeqauvaara Musiiva ee-oo tuduu ngia ngii nnaataiya ngii pikiaatauduu pikieeravai. Nnaaru Anutuuqo ngiau mmata uu suaivaki hama ii aataru ivootairavai. ");
INSERT INTO waj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na ngii giaa ngii miaunoo. Gioonnaivo hama sabi aataruuvau nuaikio rikioo ari vaatiivo inna ooqoo tino inna pikioo vino ari vaatiivo karaasa nnaata voovai varano mmuara vareera aataruuvo innaki vainaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tuduu rikiada inna ngiaammuauya inna tunoo: Nnaata vaati vareera aataruuvo itainai rikiada vaidi hama nnaata vareeraiya kati variraivo inna yoketaa aataruvaivee, ");
INSERT INTO waj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tuduu rikioo Yisuuva sai tunoo: Aa kua ngia kiaa kua aavo hama mmuakiaa vaidiiyara tii kuavai. Anutuuqo ari mmataama kiai vaidiiyara nnaasu tii kuavai. ");
INSERT INTO waj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vo aataru vo aataru vooyauvai vaiyauvaaraida hama vaidiiya nnaata varaanoo. Vooya ngiari kaanokiaiya ausaiyauvakidiri mmaakuya variaanoo. Vaidiiya vooya mmammaiyauvaa hatokaani iya mmaakuya variaanoo. Vooya ngiarinaidiri Anutuuqo gioonna kiaapuuyara diraivaara yaata utida hama nnaata varaanoo. Vaidi voovoono aa kua aavaa arinaima rikiaivoono ariinoo rikioo iikiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Gioonna kiaapu vooyaano ngiari nnaakaraiya vitada Yisuunnasi nniravai. Yisuuva iyayaa ari yaakuuvaitana utu kioo vainno yaaku varaiveera vitada innasi nniravai. Vitada nnuduu teeda Yisuunna ngiaammuauya iya ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ooqoo tuduu Yisuuva tunoo: Pikikiai nnaakaraiya niisi ngiatee. Sa iya ooqoo kiatee. Nnaakaraivo kuaivaa rikioo ivaa iivaa roosiikiai gioonna kiaapuuya fai Anutuuqo diraivaki kuaaravai. Ivaara sa aa nnaakara aaya ooqoo kiatee, ");
INSERT INTO waj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","kiaa kioo iyayaa ari yaakuuvaitana utu kioo vainno yaaku vara kioo iya pikioo viravai. ");
INSERT INTO waj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Vo suai voovaki vaidi voovoono Yisuunnasi ngioo tunoo: Vitaira-o, dee mmoori yoketaavai na iina tupatupaa variraivaa varaanarannee? ");
INSERT INTO waj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","tuduu rikioo Yisuuva inna sai tunoo: Mo a aaniira yoketaivaara ni yaparakiannannee? Mmuaavoono nnaasu yoketaavai varinoo. Fai a tupatupaa variraivaa varaanaree tiee kua mmaanna tuu kuaiyauvaa iikianee, ");
INSERT INTO waj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tuduu rikioo tunoo: Mo dee kua mmaannavai tuuvaa na iikiaunnee? tuduu rikioo Yisuuva inna sai tunoo: Sa gioonna kiaapu voovai ruputino putuaivee. A vaa nnaata vaati varaannaikua sa mmuara heera aataruuvaa iikianee. Sa voovai mminnaivaa mmuara varaanee. Sa unnakua kianee. ");
INSERT INTO waj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ai kaano koovaitanaara tuqinnaanee. E aiyara tuqinnaannaneema ai seenaiyaraatama tuqinnee iyara mmuduuya ruanee, ");
INSERT INTO waj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","tuduu rikioo vaidi karaasaivo tunoo: Ii mmuakiaa kua mmaanna iyauvaa na iikiauvaivee. Dee mmoori voovaatama na iinarannee? ");
INSERT INTO waj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","tuduu rikioo Yisuuva tunoo: Fai a vaidi tuanaakua varinaree tiee ai mminnamminnaa mmuakiaayauvai varee vaidi vooya mmiee irisai sikauyauvaa varee mmanna haipu gioonna kiaapuuya mmianee. Mmino i irisai yoketaiyauvo ngiau aapu vainaravaivee. Iya mmi taika kiee ngiee ni nnaagiai nookianee, ");
INSERT INTO waj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","tuduu rikioo vaidi karaasaivo ari hoonahaanaiyauvo kaayau vauyauvaara yaata utuduu inna ausaivo mmuaararooduu viravai. ");
INSERT INTO waj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Vuduu Yisuuva ari ngiaammuauya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Vaidi kaayau hoonahaana suvuaivo Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuanaree kiaa iikio kaayauma inna mmuaararainoo. ");
INSERT INTO waj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na kava ngii giaa ngii miaunoo. Puara pinaivaa nnutuuvo kameraivo kuatiri aataruuvaki kuanaree kiaa iikio inna mmuaararainoo. Vaidi kaayau hoonahaana suvuaivo Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuanaree kiaa iikio kaayauma inna mmuaararainoo, ");
INSERT INTO waj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","tuduu rikiada ari ngiaammuauya ii kua ivaa rikiada pinaama nnikiaraida inna tunoo: Mo dee gioonna kiaapuvoono Anutuuqaa yoosinnaivaki aikiooma kuanarannee? ");
INSERT INTO waj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","tuduu rikioo Yisuuva iya too vainno tunoo: Mmatayaa diaiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki hama yopeema ngiarinaidiri kuaaravai. Anutuuqoono tinai fai iya kuaaravai. Anutuuqo fai mmuakiaa mmoorivai aikiooma iinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tuduu rikioo Petorooso tunoo: Mo ta ti gioonna nnaakaraiyaata ti mminnaa mmuakiaayauvaatama pikiada i nnaagiai nookiaunnanoo. Dee irisaivai ta varaarannee? ");
INSERT INTO waj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","tuduu rikioo Yisuuva iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Anutuuqaa yoosinna karaasaivaki Na Vaidiivaa Mmaapuuvo fai na kieeta varira mmaata ari vookaraivau varinai ngia ni ngiaammuauya fai ngia ngiingii kieeta varira mmaata yaakuuvaitana yukukidiri taaravaitanau varida Isarairaa oyaiya yaakuuvaitana yukukidiri taaramaara dida vaida yaparakiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Gioonna kiaapu voovoono niiyara kutaavaivee tiivaara ari nnauyauvaa pikioo ari kata vayaiya pikioo ari nnunna nnayaiya pikioo ari kaano koovaitana pikioo ari nnaakaraiya pikioo ari mmataiyauvaa pikioo vioo fai irisai iyauvaanikaraama kava kaayauneetu (100) varoo tupatupaa variraivaatama varaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Itaama vainai aanna makee kaayau gioonna kiaapu tauraa variaiya fai nnaagiai variaaravai. Kaayau gioonna kiaapu nnaagiai variaiya fai tauraa variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yisuuva tunoo: Anutuuqo gioonna kiaapuuyara diraivo aa na kua tinara aavaa roosiima vainoo. Heenanaanna tuanaa vaidi vuaina mmoori nakaaraivo mmoori vareera vaidiiya oro vitaanara kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Oro iya tasipama mmuaa suai mmuaa sikauvai mminaraivaara kuaivaa kiaa yeena rau kiada ari mmooriivakira titaikiai kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kuaavo ngioo ikiannaikio oro yoosinna vuutaivaki vaidiiya dida vaida hama mmoori varaiya too ");
INSERT INTO waj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","iya tinoo: Ngieetama ni vuaina mmooriivaki vikiai fai na irisaivaa aikiooma ngii minaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","tikiai rikiada kuaavai. Kuaavo mmoori nakaaraivo kava vara ranoo ikianna tammaa vioo hannaikio vioo tauraa iineema mmuaikaraama vaidiiya titaikiai mmooriivaki kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Iya vida mmooriivaa varaavo suaivo haatapaanara iikio too mmoori nakaaraivo kava yoosinna sainai vioo vooya ivaki kati dida vakiaiya too tinoo: Ngia aaniira ikiannagisanna kati aavau dida vaida hama mmoori varaannee? ");
INSERT INTO waj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","tikiai rikiada iya inna sai kiaanoo: Hama vaidi voovoono mmooriivaa ti mmivaivee, kiaavo rikioo ivo iya sai tinoo: Ngieeta ni vuaina mmooriivaki kuatee, tikiai kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Yapooma hannaikio rikioo vuaina mmoori nakaaraivo ari mmooriivaara dira vaidiivaa tinoo: Vaidi mmoori vareeraiyara aayanna reenai nnikiai irisai sikauyauvaa mmianee. Nnaagiai numa mmoori varaiya tauraa mmiee tauraa mmoori varaiya nnaagiai mmianee, ");
INSERT INTO waj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","tikio rikioo aayanna raikiai nnaagiai mmoori varaiya ngiaavo mmuaavai mmuaavai mmuaavaugiataama sikauyauvaa iya mmiivai. ");
INSERT INTO waj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mmikiai tauraa mmoori varaiya nnida kaayauma varaaraivaara yaata utida mmuaavai mmuaavai mmuaavaugiataama ngiari sikauyauvaa varaavai. ");
INSERT INTO waj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Varada mmoori nakaaraivaara kaayauma momonaida kiaanoo: ");
INSERT INTO waj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Aa nnaagiai aaya kiisa suai mmooriivaa varaani ta tauraiya paati mmoorivai mmannammanna varaunnano suaivo paati kieema ti taivaara a irisai mmuaakaraamainna ti mmiannanoo, ");
INSERT INTO waj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","kiaavo rikioo mmoori nakaaraivo hanigia vaidi voovai tinoo: Ni seena-o, a tauraa mmuaa suaivaki mmoori vareera irisai mmuaa sikauvai vareera kuaivaa ni tasipama yeena rau kiaannavai. Hama na i sikauvaa mmuara varaunoo. ");
INSERT INTO waj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ai sikauvaa ee varee kuanee. Na irisai mmuaakaraivaa ngii miauvaugiataama na vaidi nnaagiai mmoori varaiyaatama na nini miataivaugiataama mmiaunoo. ");
INSERT INTO waj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na neneenoo ni sikauvaa mminee tiee fai mminaravee. Ni sikauvaa mminaree tiee fai na mminaraivo neenoo nakaaraivovee. Na vaidiiya kiisa mmoori varaiya pinaa sikau mmiauvaara i nnannatainnee? tiivaivee. ");
INSERT INTO waj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yisuuva ii kua ivaa kiaa taika kioo tunoo: Itaama vainai gioonna kiaapu nnaagiai variaiya fai tauraa variaaravai. Gioonna kiaapu tauraa variaiya fai nnaagiai variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yisuuva Yerusareemaivakira vioo varioo ari ngiaammuau yaakuuvaitana yukukidiri taaramaatama vida varida iya nnaasu kuaivaa kiaa mmiaa roo vioo ");
INSERT INTO waj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","tunoo: Rikiaatee. Ta Yerusareema kuaara iikiaunnanoo. Fai ta ivaki vikio vaidi voovoono Na Vaidiivaa Mmaapuuvaa vaidi Anutuuqaara kati puara hudeera kieetaiyaata kua mmaanna kiaa mmiraiyaatama kooyaa ni vitainaravai. Vitainai iya na putinaraivaara kua yeena rau kiada ");
INSERT INTO waj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ngiari voopinnaiya mmikiai iya niiyara raida ni ripiida yatari sagaivau ni haara kiaaravai. Haara kikiai na putino taara suaivaitana taikanai vooma suaivaki keenaa na diitaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tuduu Sevetainna nnaataivo ari mmaapuuvaitana vitoo Yisuunnasi ngioo varoo inna yuku oyaivaki toorivu yau haroo tunoo: Na i yaparakiauvaa iikianee, ");
INSERT INTO waj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","tuduu rikioo Yisuuva inna tunoo: E aaniivaara ni yaparakiannannee? tuduu rikioo inna sai tunoo: A gioonna kiaapuuyara dinara suaivaki aa ni maapu aavaitana kieetavaitana varida vuaivo i yaaku yaadudainningiaa varino vuaivo i yaaku geedainningiaa varinaraivaara makee ee-oo kianee, ");
INSERT INTO waj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","tuduu rikioo Yisuuva ngiaammuauvaitana tunoo: Ngia ni yaparakiaa kua oyaivaa hama ngia arinaima rikiaanoo. Na nnoori toori kapikaraivaa nnaanara iikiauvakidiri ngieevaitanaata nnaarannee? tuduu rikiada ngiaammuauvaitana sai tunoo: Fai ta nnaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","tuduu rikioo Yisuuva iya sai tunoo: Aikioovai. Ni nnoori toori kapikaraivakidiri fai ngieevaitanaata nnaaravee. Vaidiivaitana vuaivo ni yaaku yaadudainningiaa varino vuaivo ni yaaku geedainningiaa varinaraivaa hama na nakaaraivaa roosiima ee-oo tinai ivaitana variaaravai. Ii mmaata ivaitana ni Napoova vaidiivaitanaani teerama kiaivaitana fai mminai varada variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nnaagiai Yisuunna ngiaammuau saido yaakuuvaitana taara kato vayoovaitana kuaivaa rikiooduu kaayauma ivaitanaara iya nnannateeravai. ");
INSERT INTO waj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nnannatooduu Yisuuva ari ngiaammuau mmuakiaaya aayanna tuduu innasi nnida nuunauduu iya tunoo: Vaa ngia taavai. Ngiari voopinnaiya kieeta vaidiiya ngiari seenaiyara yaagueeqama diaani ngiari nnoonnaiya iyara diaavai. ");
INSERT INTO waj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Iya itaama iikiaa aataruuvo sa ngiiisi vakiaivee. Ngiiikidiri vaidi voovoono ngii kieetavai varinaree tioo mmuakiaaya ngii mmoori vareera ngiaammuauvai varinaravai. ");
INSERT INTO waj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ngiiikidiri vaidi voovoono ngii tauraavai varinaree tioo sikaunnaadiri yookaama kioo mmoori varaaneera viteera ngiaammuauvai varinaravai. ");
INSERT INTO waj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ivo ni roosiima kioo variaivee. Hama gioonna kiaapuuya ni mmoori varaateeraivaara Na Vaidiivaa Mmaapuuvo tiiravai. Na mmuakiaa gioonna kiaapuuya mmoori varee iya mminnamminnaa maisa irisaivaara putuee iya vitee yoketaivau yapaanaraivaara tiiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama yoosinna Yerikoo pikiada vuduu rikiada kaayau gioonna kiaapuuya iya vata rada viravai. ");
INSERT INTO waj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Vuduu vaidi avu huruutauvaitana aataru siriivau varida Yisuuva vuuvaa rikiada aayanna reeda tunoo: Udaanga-o, Davuitiinna oyaivakidiri diiteeraikuavee. Tiiyara boo kianee, ");
INSERT INTO waj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","tuduu rikiada gioonna kiaapuuya ivaitana yaagueeqama kua pikiaateera tuduu rikiadaata iya puaisakama aayanna reeda tunoo: Udaanga-o, Davuitiinna oyaivakidiri diiteeraikuavee. Tiiyara boo kianee, ");
INSERT INTO waj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","tuduu rikioo Yisuuva aataruuvau dioo vainno ivaitana tunoo: Ngia aaniivai na ngii iikiaiveeraida kiaannee, ");
INSERT INTO waj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","tuduu rikiada inna sai tunoo: Udaanga-o, a tinai teeda ta ti avuuvaitana kava taaravee, ");
INSERT INTO waj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","tuduu rikioo Yisuuva ivaitanaara boo tioo iya avuuvaitanau utuduu makee tuduu ivaitana tuqinnama ngiari avuuvaitana teeda inna nnaagiaivau viravai. ");
INSERT INTO waj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Vuduu Yisuuva ari ngiaammuauyaatama Yerusareema vainima nnida yoosinnaivaa nnutuuvo Betepakee taapiivaa nnutuuvo Oriveetaivau dida vauduu Yisuuva ari ngiaammuauvaitana titoo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ukuaa yoosinna ivaki kuatee. Vida akiairaa teekio puara togii kaanaivaa nnuunaivaki yeena haru kiaivo ngii too vainai yeenaivaa rakuasaa kiada nnaakaraivo inna tasipama diivaata vitada niisi ngiatee. ");
INSERT INTO waj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Fai vaidi voovoono ivaara vo kua tinaida kiatee: Udaangaivoono aavaitana vitaateera ti titaikiai ta ngiaunnanoo, kiatee. Fai ngia itaa kua tikio rikioo akiairaama togiivaitana ngii minaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yisuuva itaa kua tuuvaara nnaaruaa vaidi forofetaivo kua fafaara roovo ivo tuuvaki kaanairavai. ");
INSERT INTO waj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Forofetaivo fafaara roo tunoo: Yoosinna Sioonaa gioonna kiaapuuya kiaa mmiee kianee: Taatee. Ngii kieetaivo tirooma yoketaama puara togii karaasaivaa mmookaivau varikio vitoo ngiiisi nninoo. Puara togii nnaakaraivaa mmookaivau varikio inna vitoo nninoo, kianee. Forofetaivoono fafaara roo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ari ngiaammuauvaitana oro Yisuuva iya kiaa mmuuvaa iima kiada ");
INSERT INTO waj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","puara togii kaanaivaata nnaakaraivaatama vitada nnida ngiari yaapaiyauvaa togiivaitana mmookaivaitanau yapa kiooduu Yisuuva nnaakaraivaa mmookaivau karoo variravai. ");
INSERT INTO waj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Karoo ivau varioo vioo varuduu kaayau gioonna kiaapuuya sirigaida varida vooya ngiari yaapaiyauvaa aataruuvau hooti kiooduu vooya yatari apuuyauvaa rakau kiada aataruuvau hootiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hooti kiooduu kaayau gioonna kiaapuuya Yisuunna tauraa vuuyaata inna nnaagiai vuuyaatama aayanna kiaa rada tunoo: Davuitiinna oyaivakidiri diitoovoono inna yoketaivovee. Udaanga Anutuuqo inna titooduu tuuvo nninaraivaara ivo innara yoketaakiaivee. Anutuuqo ngiau aapu variivoono yoketaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tuduu Yisuuva Yerusareema nnuduu rikiada mmuakiaa gioonna kiaapuuya kaayauma innara sirigaida vooya tunoo: Aanna gioononnee? ");
INSERT INTO waj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","tuduu rikiada vooyaano tunoo: Aanna forofetaa Yisuuvavee. Ivo mmata Karirayaa vai yoosinna Nasareetaivakidiri nniivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tuduu Yisuuva Anutuuqaara nuunaira nnau pinaivaki vioo gioonna kiaapuuya ngiaammaiyauvaata puara sipisiipaiyauvaatama vooya mmida irisai sikauyauvaa varooyaatama gioonna kiaapuuya sikau yookaama kiada irisai varooyaatama yaagueeqama titooduu mmaanai viravai. Vuduu ivo vaidi vooya sikau yanaiyauvaa kiooduu irisai sikau mmuyaiyauvaa mmuuya parapaaraiyauvaatama vaidi vooya ngiaamma mirunnaiyauvaa varau yapa kiada vooya mmida irisai sikauyauvaa varooya mmaataiyauvaatama rauru sereguatiima kioo ");
INSERT INTO waj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","iya tunoo: Anutuuqaa kua fafaaraivo vainno tinoo: Ni nnauvo yaaku vareera nnauvaivee. Fafaaraivo itaa kua tikiainnaata ngia mmuara furaiya iirayaamaida aavaki iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kiaa kioo ivo ivaki varuduu gioonna kiaapu avu huruutauyaata yuku maisauyaatama innasi nnuduu iya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tuqinnooduu Anutuuqaara kati puara hudeera kieetaiyaata kua mmaanna kiaa mmiraiyaatama tooduu Yisuuva Anutuuqaa mmoori ari vookara ari vookarauyauvaa uuvaaraata nnaakaraiya nuunaira nnau pinaivaki aayanna reeda varida tunoo: Davuitiinna oyaivakidiri diiteeraivo yoketaivovee, tuuvaaraatama iya Yisuunnara nnannateeravai. ");
INSERT INTO waj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iya innara nnannateeda inna tunoo: Nnaakaraiya kiaa kuaivaa vaa a rikiaannannee? tuduu rikioo Yisuuva iya sai tunoo: Na rikiaunoo. Anutuuqaa kua fafaaraivo vainno tinoo: A kiannani nnaakara yokeeraiyaata nnaakara meediiyaatama Udaangaivaara kua yoketaivaa kiaavaivee. Kua fafaaraivo itaa kua tiivaa na yaata utuee rikiaukai hama ngia yaarida rikiaavaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","kiaa kioo ii yoosinna ivaki iya pikioo yoosinna Betaniaa vioo ivaki vuru vairavai. ");
INSERT INTO waj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Vauvo patauduu Yisuuva ari ngiaammuauyaatama Yerusareema kava vara ranada nnida varuduu Yisuunna yeenna rauduu ");
INSERT INTO waj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","tooduu aataru siriivau yatari nnaammuayaivaa roosuuvo duoo vauduu too Yisuuva oro ivaki buainnonno tooduu hama iiraatauduu mmanna apuvai nnaasu vairavai. Mmanna apuvai nnaasu vauduu too Yisuuva yatariivaa tunoo: Fai hama a kava iira vainarakuavee, tuduu too akiairaama nnaammuayaivo aasannairavai. ");
INSERT INTO waj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aasannauduu ari ngiaammuauya teeda nnikiaraida tunoo: Ai, mo dataama kioonno aa yatari aavo akiairaama aasannainnee? ");
INSERT INTO waj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","tuduu rikioo Yisuuva iya sai tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Ngia niiyara kutaavaivee kiaa kiada hama kava taara yaata utiraida na nnaammuayaivaa kiauko aasannaineema ngieeta mmuaakaraama iikiaaravai. Ngia niiyara kutaavaivee kiaa kiada fai ngia atai aataruuvaa iida ari vookarai aataruuyauvaatama iikiaaravai. Fai ngia aa taapi aavaa kiaara: Tavagiauruee nnoori haruungaivaki kuanee, tikio fai kuanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Fai ngia niiyara kutaavaivee kiaa kiada mmuakiaa kuavaara Anutuuqaata kua tida yaaku varaivaa fai ngia varaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yisuuva kava nuunaira nnau pinaivaki vioo gioonna kiaapuuya mmayaaya yoketaivaa kiaa mmioo varuduu vaidiiya Anutuuqaara kati puara hudeera kieetaiyaata vaidi yokovaiyaatama innasi nnida inna yaparaida tunoo: Gioono i tikiainna aa mmoori aayauvaa a iikiannannee? Dee vaidi kieetavoono i tikiai a iikiannannee? ");
INSERT INTO waj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","tuduu rikioo Yisuuva iya sai tunoo: Kii neeta vo kuavaara ngii yaparainai fai ngia ni sai tikiai fai na ivo ni tikiai na iikiauvaara kooyaa ngii giaa ngii minai rikiaatee. ");
INSERT INTO waj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Gioono tuduu Yuvuaano nnoori apira vaidiivo gioonna kiaapuuya nnoori apuunnee? Vo Anutuuqoono tuduunno uunnee? Vo vaidi mmatayaiyaano tuduunno uunnee? tuduu rikiada iya ngiariiki ngiariiki yaparaida tunoo: Ta dee kuavai sai kiaarannee? Fai ta inna sai kiaara: Anutuuqoono tuduu Yuvuaano iiravaivee, tikio rikioo mo fai ivo ti sai tinara: Mo aaniira ngia hama inna kuaivaara kutaavaivee tiravainnee? tinaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Fai ta kiaara: Vaidiiyaano tuduu Yuvuaano iiravaivee, kiaa kiada mo fai ta gioonna kiaapuuyara aatuukiaaravai. Mmuakiaa gioonna kiaapuuya Yuvuaanaara tunoo: Vaidi forofetaivovee, tuuvaara ta iyara aatuukiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iya itaa kua kiaa kiada Yisuunna kuaivaa sai tunoo: Hama teeta taunnavaivee, tuduu rikioo Yisuuva iya sai tunoo: Hama ngia ni kuaivaa sai kiaivaara fai na hama ngii kuaivaa sai tinaravai. Ivo ni tikiai na ni mmooriivaa iikiau oyaivaa fai hama na ngii giaa ngii minaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yisuuva itaa kua kiaa kioo tunoo: Ngia rikiaavo datainnee? Vaidi voovoono ari mmaapu taaravaitana tasipama varioo oro mmaapu ngarunna tinoo: Ni maapu-o, makee oro ni vuaina mmooriivaki varaanee, ");
INSERT INTO waj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","tikio rikioo ivo inna sai tinoo: Hama ni kuatainoo, kiaa kioo yapooma nnaagiai varioo rikiaikio inna ausaivo hanigiaikio rikioo kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kuaikio koova oro ari mmaapu ngaminna mmuaa kuavai tikio rikioo inna sai tinoo: Napoo-o, fai na kuanaravaivee, kiaa kioo hama kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mo dee ngiaammuauvoonoonno ari koonna kuaivaa rikioo iinnee? tuduu rikiada iya inna sai tunoo: Ari mmaapu ngaruuvovee, tuduu rikioo Yisuuva iya sai tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Vaidiiya unnakua kiaa kiada sikau takiisa vareeraiyaata gioonna sabi nuairaiyaatama Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki ngii tauraa kuaaravai. ");
INSERT INTO waj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yuvuaano nnoori apira vaidiivo numa aataru yoketaivaa ngii vitauduu ngia hama inna kuaivaara kutaavaivee tiravai. Mo vaidiiya unnakua kiaa kiada sikau takiisa vareeraiyaata gioonna sabi nuairaiyaatama inna kuaivaara kutaavaivee tida ausa mmuduuya hanigieeravai. Ngia iya hanigiada safuuma variraivaa teeda hama ngia ngiingii mminnamminnaa maisaiyauvaara yaata utida hanigiada inna kuaivaara kutaavaivee tiravai. Ivaara iyannaadee ngii tauraa Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na kava mmatayaa diaa mminnaa voovaudiri mmataama kiee tinai rikiaatee. Vaidi voovoono ari vuaina mmooriivaa vara kioo hanikiaivaa rau kioo hauyauvaa utu kioo vuaina iiraiyauvaa kagigainara soopaivaa hanuu teerama kioo ari mmoorira haitatuunara saasaaya nnau hokobaivaa heeka kiaivai. Heeka kioo vaidiiya inna mmooriivaara haitatuuda iira vooyauvai ngiari mmoori varaa irisaiyauvaa ngiariyara varaateeraivaara iya kiaa mmi kioo ngieera vo yoosinnaipi varinara kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Vioo vioo oro ngieera yoosinnaivaki hara kioo varikio yapooma vuaina iiraiyauvaa rasukuaara suaivo vainima nnikio mmoori nakaaraivo ari mmoori vareera ngiaammuauya vaidi vuaina mmooriivaara haitatuura vaidiiyasi titaikiai ariini vuaina iira vooyauvai varaara kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kuaani teeda vuaina mmooriivaara haitatuukiaiyaano iya puaisa utida voovai ripiida voovai ruputuaavo putikiai voovaayaa sikauyauvaa kagaari kiaavo putivai. ");
INSERT INTO waj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tauraa mmoori nakaaraivo pata ngiaammuaudaa titaa kioo nnaagiai kaayau ngiaammuauya titaa kiaikiai vuaina mmooriivaara haitatuukiaiyaano mmuaikaraama iya iikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Iikiaavovo nnaagiai tuanaa mmoori nakaaraivo ari mmaapu tuanaivaa iyasi titaa kioo tinoo: Fai iya ni maapu tuanaivaa teeda inna kuaivaa arinaima rikiada hama inna ruputuaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kiaa kioo inna titaa kiaikio kuaikiai teeda mmooriivaara haitatuukiaiyaano inna mmaapuuvaa teeda ngiari kiaa mmi ngiari kiaa mmiida kiaanoo: Ari koonna mminnaa mmuakiaayauvai varaanaraivo aa nninoo. Nnikiai ta inna ruputu kikio putinai teeda ta inna mminnaa mmuakiaayauvai varaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","kiaa kiada inna utu raririima rada hanikia mmaanai inna kagaari kiada ruputuaavo putivaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yisuuva itaa kua kiaa taika kioo vaidi kieetaiya yaparainno tunoo: Fai mmoori nakaaraivo iyasi ngioo dee mmoorivai iya iikiaivaa irisai iya mminarannee? ");
INSERT INTO waj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","tuduu rikiada iya sai tunoo: Ivo vaidi maisaiya maisama ruputinai putikio ari mmooriivaa ari vo vaidi haitatuukiaiya mminai iya vuaina iiraiyauvo kaanaira suaivau safuuma fai iira saiyauvai ari mmiaaravee, ");
INSERT INTO waj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","kiaa kioo Yisuuva iya tunoo: Vaa ngia Anutuuqaa kuaivaa yaarida rikiaavaivee. Anutuuqaa kua fafaaraivo vainno tinoo: Sikau nnau heekeeraiyaano sikau voovai teeda maisaivaivee kiaa kiada pikiaavai. Yaagueeqa yatariivaa pupukiaivaa mmaara hara kiaa kuabaivaa roosiima ii sikau ivo nnau ipunnaivaki vaivo inna yoketaavai. Udaanga Anutuuqoono iira mmoorivai. Ta taunnano inna mmooriivo yoketainno ari vookarainoo. Fafaaraivo vainno itaa kua tiivaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yisuuva itaa kua kiaa kioo tunoo: Na ngii giaa ngii miaunoo. Fai Anutuuqo gioonna kiaapuuyara diraivaa ngiiisidiri ruga kioo vaa iyauvaa varaiyaki iiraiyauvo iyaki vainaraiya fai mminaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Gioonna kiaapu voovoono ii sikau ivaudiri raa rabarisooma varoo ivau harurummua kioo vainno fai kaayau ari mmamma mmuyaivaa ruaimeemiinaravaivee. Fai ii sikau ivo taikiapa roo gioonna kiaapu voovai ruputino inna mmamma mmuyai sagia mmuakiaavai ruaimeemiima taika kiaanaravaivee, tiravai.) ");
INSERT INTO waj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tuduu vaidiiya Anutuuqaara kati puara hudeera kieetaiyaata Farisaiyaatama Yisuuva mmatayaa diaa mminnaivaudiri mmataama kioo tuu kuaiyauvaa rikiada iva iyara tuuvaa arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rikiada ivaara iya inna utuaaree kiaa uuduu gioonna kiaapuuya Yisuunnara forofetaivovee tuuvaara iya aatuuda inna pikieeravai. ");
INSERT INTO waj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisuuva keenaa mmatayaa diaa mminnaa vooyauvunudiri mmataama kioo tiravai. Ivo iya tunoo: ");
INSERT INTO waj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Anutuuqo gioonna kiaapuuyara diraivo aa na mmataama kiee tinara kua aavaa roosiivai. Yoosinna voovakinnaa kieeta voovoono ari mmaapuuvo nnaata vareera suaivaki pinaa buusavai iivai. ");
INSERT INTO waj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Iima kioo ari mmoori vareera ngiaammuauya titaikiai vaa mmuaanaa buusa nnaara kuaivaa kiaa mmii vaidiiyara aayanna raani hama iya ngiataikiai ");
INSERT INTO waj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","kava ari ngiaammuau vooya iyasi titoo tinoo: Tauraa kiaa mmiaiya kiaa mmida kiatee: Rikiaatee. Vaa na ni buusaivaa teerama kiaunoo. Vaa na ni puara burimakau ooraiyauvaata nnammari rai nnaakaraiyauvaatama ruputu kiee mmuakiaa yeennaiyauvaa teerama kiaunoo. Numa buusaivaa nnaatee, kiatee. ");
INSERT INTO waj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ivo itaa kua tikiai rikiada oro kiaa mmiaani iya rikiadaata hama nniraida ngiari mmooriiyauvaara yaata utida voovai ari mmoorira vioo kiaikio voovai ari sikau vareera mmooriivaki vioo kiaivai. ");
INSERT INTO waj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iya mmoorira vida variaani homoraa vooya inna ngiaammuauya utu kiada vaida kaayau maisa mmooriivaa iya mmida iya ruputuaani putuaavai. ");
INSERT INTO waj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Putuaavo vaidi kieetaivo rikiaikio inna ausaivo pinaama nniitaraikio ari rapira ngiaammuauya titaikiai vida iya ruputuaa vaidiiya irisai ruputu taika kiada iya yoosinna pinaivaa ikia mmuturu kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mmuturu kiaavo rikioo vaidi kieetaivo ari mmoori varoo ngiaammuau vooya tinoo: Vaa na buusaivaa teerama kiaunoo. Vaidi na yaparakiauya ngiari variaivaa irisaivaa fai deevaudiri vara nnaarannee? ");
INSERT INTO waj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aanna ivaara oto aataru pinaiyauvunu buaama rada nuaida teekiai gioonna kiaapuuya ngii teeda vaikiai teeda aa buusa aavaa numa nnaateera kiatee, ");
INSERT INTO waj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","tikiai rikiada ari ngiaammuauya aataruuyauvunu nuaida varida mmuakiaa gioonna kiaapu yoketaiyaata maisaiyaatama buaida taani iya teeda vakiaani vitada numa buusa nneera nnauvaki kiaani suvuai kiada variaavai. ");
INSERT INTO waj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Variaavo rikioo vaidi kieetaivo numa gioonna kiaapuuya haitatuuma taikio mmuaa vaidivoono hama yaapeeri nneera buruqa yoketaivaa raira kiaivo iya tasipama varikio too inna tinoo: ");
INSERT INTO waj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ni seena-o, i dataikiai e aavaki hama yaapeeri nnaara raira buruqa yoketaivaa rau varee numa variannannee? tikio rikioo hama inna kua sai tira kua seemuaa hara kioo varivai. ");
INSERT INTO waj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Varikio too kieetaivo ari mmoori vareera ngiaammuauya tinoo: Inna yuku yaakuuvau yeenaadiri ranaa rau kiada utu raririima mmaanai kagaari kikio upisiivaki variaivee. Ii yoosinna upisi ivaki gioonna kiaapuuya varida teekio iya nnannateenai fai ngiari avaiyauvaa hakutikio iya ausaiyauvo mmuaarareenai rataaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yisuuva itaa kua kiaa kioo tunoo: Anutuuqo kaayau gioonna kiaapuuya maavee tioo kiisakiangii nnaasu mmatainno vitaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tuduu vaidi Farisaiya Yisuuva kuaivaa koonnama tioo haruruaiveera kuaivaa kiaa teerama yeena rau kiada ");
INSERT INTO waj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","iya nnaagiai nuaira vooyaata Herootaa nnaagiai nuaira vooyaatama titooduu oro inna yaparaida tunoo: Vitaira-o, vaa ta i taunnavai. A kua kutaa tira vaidikuavee. A Anutuuqaa mmoori aataruuvaa safuuma mmuakiaa gioonna kiaapuuya kiaa mmiee iya aiyara yaata utuaivaara hama a pinaama yaata utuannavai. Vaidi kieetaiyaraata vaidi kuminaiyaraatama a mmuaavaugiataama yaata utuannaivaara iya aiyara yaata utuaivaara hama a yaata utuannavai. ");
INSERT INTO waj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aa kua ta i yaparakiaunna kua aavaa yaata utuee sai ti kiaa ti mmianee. Roomaaya kieetaivaasi ta sikau takiisa yapaara aataruuvo yoketaa aataruvainnee? Vara hama yoketaa aataruvainnee? ");
INSERT INTO waj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","tuduu Yisuuva iya innara nnannatooduu inna iida taaree kiaa uuvaa too iya tunoo: Ngia vaidi huoobavainna unnakua nnaamuruyavee. Ngia aaniira ni iida taaree kiaa numa ni iikiaannee? ");
INSERT INTO waj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takiisa yapaa sikau voovai ni vitaakiatee, tuduu rikiada sikau mmuyai voovai varada inna mmuduu too ");
INSERT INTO waj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","tunoo: Aanna giaa kieetavai mmannammannaavainno vainnee? Aanna giaa nnutuvainno vainnee? ");
INSERT INTO waj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tuduu rikiada iya inna sai tunoo: Mo Roomaaya kieetaivaa mmannammannaivoota inna nnutuuvootama ivau vainoo, tuduu rikioo Yisuuva iya sai tunoo: Mo Roomaaya kieetaivaa mminnaiyauvaa safuuma ari mmiatee. Mo Anutuuqaa mminnaiyauvaa safuuma Anutuuqaa ari mmiatee, ");
INSERT INTO waj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","tuduu rikiada iya nnikiaraida inna pikiada viravai. ");
INSERT INTO waj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Vuduu mmuai suaivaki vaidi Satuukaiya vaidi putuuyara tunoo: Fai hama kava diitaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","tuuyakidiri vooya numa Yisuunna yaparaida tunoo: Vitaira-o, nnaaru Musiiva tunoo: Vaidi voovoono nnaataivaa vara kioo hama nnaakaraivaa mmateerainno putino fai ari kataivoono inna muaadaivaa vara kioo ari vayaannara tuoo nnaakaraiyauvaa mmataanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aavaki kata vayaa yaaku saivai sainaidiri taaravaitana ti tasipama hara kiada varuuvakidiri ngaruuvoono nnaataivaa vara kioo hama nnaakara mmateerama kioo kati putiravai. Putuduu ngamiisaivo inna muaadaivaa vara kioo ");
INSERT INTO waj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","hama nnaakara mmateerama kioo kati putuduu yaguaavaano kava muaadaivaa vara kioo hama nnaakara mmateerama kioo putuduu mmuakiaa kataunna nnaagiainnaidoota mmuai gioonnaivaa vara kiada hama nnaakara mmateerama kiada kati putiravai. ");
INSERT INTO waj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Putuduu nnaagiaivau iya gioonnaivootama putiravai. ");
INSERT INTO waj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Itaama vaikiai yapooma gioonna kiaapu putuaiya kava diitaara suaivaki fai gioonnaivo giaa nnaatavai varinarannee? Mo vaa yaaku saivai sainaidiri taarama ii vaidi idoono inna vara kiada putiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tuduu rikioo Yisuuva iya sai tunoo: Ngia koonnama yaata utida itaa kua kiaanoo. Ngia hama Anutuuqaa fafaara roo kuaivaa arinaima rikiada hama inna yaagueeqaivo vaivaa taivaaraida ngia koonnama yaata utida itaa kua kiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Fai gioonna kiaapu vaa putuaiya diiteera suaivaki diitada hama nnaata vaati varaaravee. Fai iya aangeraiya ngiau aapu variaiya roosiima variaaravee. ");
INSERT INTO waj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Gioonna kiaapu vaa putuaiya kava diitaaraivaara Anutuuqo ngii giaa ngii miivaa vaa ngia yaarida rikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Anutuuqo Musiinnaata kua tuu kua fafaaraivo vainno tinoo: Na i nnaakukiaiya Aaparahaamo Isaako Yakoopainna Anutuuqovee, tiivai. Vaidi taaravooma nnaaru putuuya inna avuuvau homo variaivaara Anutuuqo itaa kua tiravai. Anutuuqo gioonna kiaapu vaa eeyaara putuaiya hama iya Anutuuqovee. Ivo gioonna kiaapu variaiya Anutuuqovee, ");
INSERT INTO waj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","tuduu mmuakiaa gioonna kiaapuuya Yisuuva tuu kuaivaa rikiada ivaara nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nnikiarauduu Yisuuva ari kuaivaadiri vaidi Satuukaiya avaiyauvaa ramuunnauvaara vaidi Farisaiya rikieeravai. Rikiada nuunaida varuduu ");
INSERT INTO waj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","iyakidiri kua mmoori aataru radudeera vaidi voovoono Yisuunna iinno taanaree kiaa vo kuavai inna yapara ruoo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Vitaira-o, Anutuuqo mmaanna tuu kuaivakidiri dee kua mmaannavoono mmuakiaa kua mmaanna tiraivaa yaatarainnee? ");
INSERT INTO waj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","tuduu rikioo Yisuuva inna sai tunoo: I Udaanga Anutuuqaara mmuduuya ruee ai ausa mmuduuya mmuakiaavai inna mmianee. Ai vaidi kaanaivaata ai yaata vuatinniivaatama mmuakiaavai inna mmianee. ");
INSERT INTO waj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ii kua mmaanna tuu ivo tauraa vainno mmuakiaa kua mmaannavai yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Inna inanoo kua mmaanna tuuvo tinoo: E aiyara tuqinnaannaneema ai seenaiyaraatama tuqinnee iyara mmuduuya ruanee. Aa taara kua aavaitana eeyaa kua mmaanna tira kuaivaa yaataraivaitanavee. ");
INSERT INTO waj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aa kua mmaanna tuu aavaitanaakidiri Anutuuqaa mmaanna tuu kua mmuakiaayauvoota forofetaiya kua mmuakiaayauvootama diiteeravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kiaa kioo Farisaiya ivaki nuunaida varuuya Yisuuva iya yaparainno tunoo: ");
INSERT INTO waj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ngia Anutuuqo mmataama kioo vaidiivaara dataa kuaida kiaannee? Ivo dee oyaivainnee? tuduu rikiada iya inna sai tunoo: Ivo Davuitiinna oyaivakidiri diitai vaidivaivee, ");
INSERT INTO waj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","tuduu rikioo Yisuuva kava iya yaparainno tunoo: Mo dataama kioo Mmannasa Yoketaivo Davuitiinna tasipama varuduunno Davuitiiva Anutuuqo mmataama kioo vaidiivaara Udaangaivovee tuunnee? Davuitiiva tunoo: ");
INSERT INTO waj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Udaanga Anutuuqoono ni Udaangaivaa tunoo: A ni yaaku yaadudainningiaa vaidi nnoonnavai varianee. Varia ree vinanai fai na tinai a ai nnammutuaiya yaatara kiaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davuitiiva fafaara roo itaa kua Anutuuqo mmataama kioo vaidiivaara tunoo: Ni Udaangaivovee, tuuvaara hama ivo Davuitiinna oyaivakidiri nnaasu diiteeravaivee, ");
INSERT INTO waj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","tuduu rikioo vaidi voovoono hama yopeema inna kua sai tiravai. Ii suai ivakidiri hama kava vaidi voovoono yopeema vo kua vooyauvaara inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yisuuva Farisaiyaata kua kiaa taika kioo gioonna kiaapu ivaki nuunauyaata ari ngiaammuauyaatama tunoo: ");
INSERT INTO waj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Vaidi kua mmaanna kiaa mmiraiyaata vaidi Farisaiyaatama Musiiva kua mmaanna tuuvaugiataida ngii giaa ngii miaanoo. ");
INSERT INTO waj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ivaara ngii giaa ngii miaivaugiataama nnaasu iikiatee. Sa iya iikiaivaugiataama iikiatee. Iya mmanna avaiyauvakidiri ngii giaa ngii mida hama iya iyauvaa iikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vaidiiya kaayau mmuaararai mminnaiyauvaa vaidi vooya mmiaani kumaata apuaivaa roosiima iya mmuaararai mmooriiyauvaa gioonna kiaapuuya mmi kiada hama ngiariita kiisama iya tasipama mmuaararai mmooriivaa varaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Gioonna kiaapuuya iya taateeraivaara nnaasu iya ngiari mmoori mmuakiaayauvai iikiaavai. Iya Anutuuqaa kuaivaa yanaiyauvunu fafaara raa kiada kiisa nnaamuruuyauvaki yapa kiada ngiari yaakuuyauvunu raida ngiari tinniiyauvunu rau kiada nuaida varida ngiari buruqa mmitiiyauvaa hokobayauvai rapasi kiada iyauvaara sirigama rada nookiaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iya buusaiyauvaa nneera suaiyauvaki kieetaiya varira mmaataiyauvunura nnaasu mmuduuya rida variaavai. Iya nuunaira nnauyauvaki vida mmaata yoketaiyauvunura nnaasu mmuduuya rida variaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iya yoosinna aakiaiyauvaki nookiaani gioonna kiaapuuya iya teeda kua yoketaivaa iyara kiaiyauvaara mmuduuya ruaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sa ngiiikidiri voovaara nnoonna-o kiatee. Ngia mmuaakaraama variaanoo. Ngii vitairaivo mmuaavai varinoo. ");
INSERT INTO waj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ngia vaidi mmatayaiya sa ngii seena voovaara ti nnoonnavaivee kiaa innara ti napoovavee kiatee. Ngii Gioova mmuaavai ngiau aapu varinoo. ");
INSERT INTO waj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sa vaidi voovaara ti kieetavaivee kiatee. Ngii kieeta mmuaavai Anutuuqo mmataama kioo vaidivai varinoo. ");
INSERT INTO waj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ngiiikidiri vaidi voovoono ngii kieetavai varinaree tioo mmuakiaaya ngii mmoori vareera ngiaammuauvai varinaravai. ");
INSERT INTO waj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Gioonna kiaapu voovoono ariiyara mannaka tiivaa fai Anutuuqo inna vitoo aduoo yapaanaravai. Fai gioonna kiaapu voovoono tirooma varioo hama ari nnutuuvaa aruoo yapaivaa fai Anutuuqo vitoo aruoo yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ngia vaidi kua mmaanna kiaa mmiraiyaata Farisaiyaatama ngia huoobavainna unnakua nnaamuru tuanaayavee. Ngii irisai maisaivo vainoo. Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki iya kuaaree kiaa iikiaani ngia uuda rammuaavai. Ngiengieenoo ivaki hama ngii kuataikiai hama kuaivaara ivaki kuaaree kiaiya uuda rammuaavai. Ivaara ngii irisai maisaivo vainoo. ");
INSERT INTO waj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ngia vaidi kua mmaanna kiaa mmiraiyaata Farisaiyaatama huoobavainna unnakua nnaamuru tuanaayavee. Ngii irisai maisaivo vainoo. Ngia gioonna muaadaiya nnauyauvaata iya mminnamminnaiyauvaatama yokekiaa kiada mmuara raida varidaata ngia ti mannakakiateera hokobama yaaku varaavai. Ivaara ngii irisai maisaivo pinaavai vainaravai.) ");
INSERT INTO waj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ngia vaidi kua mmaanna kiaa mmiraiyaata Farisaiyaatama huoobavainna unnakua nnaamuru tuanaayavee. Ngii irisai maisaivo vainoo. Ngia vaidi mmuaa voovai ngii mmemmaana kuaiveera sorovuaraivaa vida karada ngieera yoosinnaiyauvaki nuaida varida mmoori iikiaavai. Mmoori iida varikio ivo hanigioo ngii ngiaammuauvai ngii mmemmaana varioo vaa ngia inna iikiaivaara ivo pinaama hanigioo maisavai varioo ngii mmoori maisaivaa yaataroo itaama ngii roosiima ikia aakiaivaki kuanara iinoo. Ivaara ngii irisai maisaivo vainoo. ");
INSERT INTO waj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ngia avu maisaso, hama ngia tuqinnama teeda gioonna kiaapuuya kiaa mmiraiyaso, ngii irisai maisaivo vainoo. Ngia kiaanoo: Vaidi voovoono ari kua kutaivaa gioonna kiaapuuya kiaa mmioo nuunaira nnau pinaivaa nnutuuvaa tasipama kiaa mmiivo inna hama kua yeena raira kuavai. Fai ivo ari kua kutaivaa sikau goora mmannaammannaivo nuunaira nnau pinaivaki vaivaa nnutuuvaa tasipama kiaa mmiivo inna yeena raira kuavai. Ivaudiri fai ivo ari kua kutaivaa iinaravaivee. Ngia itaa kua kiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ngia avu maisa tuanaa kumimakaso, dee mminnaavoono ari vo mminnaavai yaatarainnee? Vara sikau goora mmannaammannaivonnee? Vara nuunaira nnau pinaivonnee? Hama Anutuuqaa nuunaira nnau pinaivaki sikau goora mmannaammannaivo vaitiri. Hama ngia ivaara kiaatiri: Anutuuqaani vai mminnaa yoketaavaivee, kiaatirivee. Anutuuqaa nnau pinaivoono sikau gooraivo mmannaammannaivaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ngia vo kuavai kiaanoo: Vaidi voovoono ari kua kutaivaa tioo Anutuuqaara puara hudeera yeena tapiivaa nnutuuvaa tasipama tiivo inna hama yeena raira kuavai. Ivo ari kua kutaivaa tioo yeena tapiivau kati mmira puaraivo vaivaa nnutuuvaa tasipama tiivo inna yeena raira kuavai. Ivaudiri fai ivo ari kua kutaivaa iinaravaivee. Ngia itaa kua kiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ngia vaidi avu maisaso, dee mminnaavoono ari vo mminnaavai yaatarainnee? Kati mmira puaraivonnee? Vara yeena tapiivonnee? Hama puaraivoono yeena tapiivau vaitiri. Hama ngia ivaara kiaatiri: Anutuuqaani vai mminnaa yoketaavaivee, kiaatirivee. Anutuuqaani yapa kiaa mminnaivaa yeena tapiivoono yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ivaarainno vaidi voovoono ari kua kutaivaa yeena tapiivaa nnutuuvaata tioo yeena tapiivaaraata puara ivau vaivaaraatama tiivai. ");
INSERT INTO waj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Vaidi voovoono ari kua kutaivaa tioo nuunaira nnau pinaivaa nnutuuvaata tioo ivo nuunaira nnauvaaraata Anutuuqo ivaki variivaaraatama tiivai. ");
INSERT INTO waj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Vaidi voovoono ari kua kutaivaa ngiau aapuuvaa nnutuuvaata tioo ivo Anutuuqaa mmaataivaaraata ivo ivaki variivaaraatama tiivai. ");
INSERT INTO waj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ngia kua mmaanna kiaa mmiraiyaata Farisaiyaatama ngia huoobavainna unnakua nnaamuru tuanaayavee. Ngii irisai maisaivo vainoo. Ngia kiisa mminnaa kapikarai takua roosiiyauvaa yaakuuvaitana utu kiada vakiaivakidiri mmuaavai Anutuuqaani kiadaataida pinaa kuaiyauvo Anutuuqaa kua mmaannaivaki vaiyauvaa ngia pikiada hama iikiaanoo. Ngia hama safuuma ngiingii seenaiyara tuqinnada hama iyara boo kiaanoo. Ngia hama Anutuuqaara kutaavaivee tida yaagueeqakiaanoo. Ngia iyauvaa iikiataama vaikiainnaata hama iikiaanoo. Ngia iyauvaa iidada vo aataruuyauvaa vaa iikiaiyauvaatama iikiatee. ");
INSERT INTO waj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ngia avu maisaso, hama ngia tuqinnama teeda gioonna kiaapuuya kiaa mmiraiyaso, fingifaangaivo ngii nnoori tooriivaki vaivaa ngia feena kagaari kiada puara pinaa kameraivo ivaki vaivaa ngia nnooriivaa tasipama vara romenama kiaavai. Kiisa aataruuvo fingifaangaivaa roosiima vaivaa ngia arinaima teeda iikiaavai. Pinaa aataruuvo puara kameraivaa roosiima vaivaa ngia teeda hama iikiaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ngia kua mmaanna kiaa mmiraiyaata Farisaiyaatama ngia huoobavainna unnakua nnaamuru tuanaayavee. Ngii irisai maisaivo vainoo. Ngia ngii pereeta kaapa mmaanaiyauvaa fini kiaavo yoketaivaa roosiima ngii mmammaiyauvo vaikio ngii aakiaiyauvaki ngii mminnamminnaa maisaiyauvo suvuainoo. Ngia gioonna kiaapuuya unnakua kiaa kiada iya hoonahaanaiyauvaa ngiingiiiyara ravisi varada ngiingiiiyara nnaasu yaata utida koonnakaannama variaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","E avu maisa vaidi Farisai tuanaakuavee. A pereeta kaapa aakiaivaki tauraa fini kiee mmaanaivaata fini kiaannaivaa roosiima i aakiaivaa fini kino too mmamma mmaanaivoota yoketaavai vakiaivee. ");
INSERT INTO waj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ngia kua mmaanna kiaa mmiraiyaata Farisaiyaatama huoobavainna unnakua nnaamuru tuanaayavee. Ngii irisai maisaivo vainoo. Ngia putuaiya mmata nnauvaa mmaanaivau funnukakiaiyauvaa roosiima variaayavee. Mmata nnau mmaanaiyauvo inna aikiooma vaikio aakiaiyauvaki vaidi putuaiya mmamma mmuyai uudaiyauvo vaivai. ");
INSERT INTO waj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Itaama vaineema gioonna kiaapuuya ngii mmamma mmaanaiyauvaa teeda ngiiiyara kiaanoo: Yoketaayavee, kiaavai. Ngii aakiaiyauvaki unnakuaiyauvoota mminnamminnaa maisaiyauvootama suvuainoo. ");
INSERT INTO waj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ngia kua mmaanna kiaa mmiraiyaata Farisaiyaatama huoobavainna unnakua nnaamuru tuanaayavee. Ngii irisai maisaivo vainoo. Ngia forofetaa putuuyara sikauyauvaadiri iya mmata nnauyauvo yoketaakiaiveera funnukama yoketaama kiaavai. Ngia gioonna kiaapu safuuma varuuya putuuyara sikauyauvaadiri iya mmata nnauyauvaa hatata kieeraiyauvunu funnukama kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ngia iyauvaa funnukama kiada kiaanoo: Ta ti rubu tabeeya varuu suaivaki teeta variaannatiri. Ta hama iyaata iida forofetaiya ruputuaannaduu pututirivee. ");
INSERT INTO waj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ngia itaa kua tuuvaugiataama ta kooyaa rikiaunnani aanna ngia forofetaiya ruputuduu putuuya uru nnaakara tuanaiyaida variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inna aikioovai. Ngii rubu tabeeya tauraa iya uuneema ngieeta iidada taika kiaatee. ");
INSERT INTO waj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ngia gioonna kiaapu maisaso, ngia dataama kiada kua pinaivakidiri ikia aakiaivaki vida fanniima kuaarannee? Ngia maisa mmooriivaa uuvaara fai inna aikioo ivaki kuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ivaara na vaidi forofetaiyaatama vaidi tinni yoketaiyaata vaidi vitairaiyaatama ngiiisi titanai vikiai fai ngia vooya ruputikiai putikiai vooya yatari sagaiyauvunu haara kiada vooya ngiingii nuunaira nnauyauvaki ripiida ruputua rada vata rada vo yoosinna vo yoosinnaiyauvaki kuaaravai. ");
INSERT INTO waj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngia itaikio mmuakiaa vaidi yoketaiya kuminayaa ruputuuya irisaivo fai ngiiiki vainaravai. Nnaaruaa vaidi yoketaa voovai Aveeraa Kaingo kuminayaa ruputu kiooduu putuduu ivakidiri iima rada nnidada vaidi voovai Barakiaanna mmaapuuvaa Sakariaasaa ngia Yutayaiya ruputu kioovaa irisaivo fai ngiiiki vainaravai. Ngia nuunaira nnau pinaivaki vuduu yeena tapi Anutuuqaara hudeeraivo sainai vauduu vo atau yoketaa tuanaa nnau voovai sainai vauduu ngia vuutaivaki Sakariaasaa ruputu kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na kua kutaavai ngii giaa ngii miaunoo. Mmuakiaa vaidiiya kuminayaa ruputuuya irisaivo aa ngia variaa aaya ngiiiki vainaravai. ");
INSERT INTO waj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Boo, gioonna kiaapu Yerusareemaiyaso, ngia vaidi forofetaiya ruputuaani putuaani gioonna kiaapuuya Anutuuqo ngiiisi titeeraiya ngia sikauyauvaadiri habati kiada ruputuaani iya putuaavai. Kakaraa kaanaivo ari nnaakaraiyauvaa rupi nuunama ari haayaivaadiri rummua apineema na airineetu ngii rupi niniisi nuunainee kiaukai ngia niiyara ooqoo kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Rikiaatee. Vaa ngii nuunaira nnau pinaivaa Anutuuqo pikiaikio mmanna nnauvai vainoo. Vaa Anutuuqo vioo kiaivai. ");
INSERT INTO waj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na ngii giaa ngii miaunoo. Fai ngia hama kava ni taaravai. Fai yapooma ngia niiyara kiaara: Udaanga Anutuuqo titooduu tuuvo nninaraivaara Anutuuqo innara yoketaakiaivee, kiaa kiada fai kava ni taaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ivo itaa kua kiaa kioo diitoo nuunaira nnau pinaivakidiri pikioo kuanara uuduu ari ngiaammuauya nuunaira nnau pinaivaki vo nnau vo nnauvaa inna vitaakiaaraivaara innasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Numa vitauduu Yisuuva iya tunoo: Inna aikioovai. Makee aa ngia nnau aayauvaa taanoo. Na kua kutaavai ngii giaa ngii miaunoo. Fai vaidiiya mmuakiaa aa nnau aayauvaa havarata taika kikio rikioo fai hama seena sikau voovai ari seena sikau voovai mmaataivau tasipama vainaravai. Fai mmuakiaavai havarata taikaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nnaagiai Yisuuva taapi Oriveeta ivau hara kioo varuduu ari ngiaammuauya ngiarivana innasi nnida inna yaparaida tunoo: Ti kiaa ti mmianee. A kiannaivo daira suai vainarannee? Dee ari vookarai mmoorivai vainai fai ta teeda rikiakio a tiinara suaivoota ngiau mmata taikaanara suaivootama vainima nninarannee? ");
INSERT INTO waj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","tuduu rikioo Yisuuva iya sai tunoo: Vaidi voovoono ngii unnakua kiaa kioo aataru maisaivau ngii vita yapeevoora tuqinnama haitatuukiatee. ");
INSERT INTO waj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Fai kaayau vaidiiya mmuaavai mmuaavai nnida ni nnutuuvaa ngiariiyara kiaaravai. Voovoono ngioo tinara: Aanna na Anutuuqo mmataama kioo vaidiivoona ngiaunoo, tinai fai kaayau gioonna kiaapuuya iya unnakua kiaivaa rikiada kiaara: Kutaa kuavaivee, kiaaravee. ");
INSERT INTO waj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Fai ngia gioonna kiaapuuya vainiivau rapiraivaa rikiada ngieera rapira mmayaayaivaa rikiada sa ivaara nnikiaraida aatuukiatee. Rapiraivonanaa tauraa vaino too ngiau mmata taikeera suaivo fai nnaagiai nninaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Fai gioonna kiaapu voovaki variaiya diitada gioonna kiaapu voovaki variaiyaatama rapuaaravai. Fai vo kieeta voovoono diitoo vo kieetavaata rapinara iinai rikiada fai ngiari gioonna kiaapuuya rapuaaravai. Fai ii suai ivaki vo yoosinna vo yoosinnaiyauvaki aarareeraivo vainai rikiada gioonna kiaapuuya kaayauma yeennara kiaaravai. Fai vo mmata vo mmataiyauvaki mmataa kuaruuvo utinaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gioonnaivo nnaakaraivaa mmataanara suaivaki ivo tauraa kiisama nniitareeraivaa varoo nnaagiai pinaama nniitareeraivaa varaivai. Ivaa roosiima iqii aataru iyauvo nninara suaivaki tauraa kiisavai vainno nnaagiai fai pinaavai vainaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Iqii suai ivaki fai vaidiiya ngii vitada vaidi kieetaiya mmikiai teeda iya kua pinaivaa ngiiiki yapaaravai. Ngiiiki yapa kiada ngii ripiida ngii ruputikiai putuaaravai. Ngia niiyara kutaavaivee kiaivaara kaayau gioonna kiaapu ngiari voopinnaiya ngii teeda hama ngiiiyara mmuduuya ruaaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Iqii suai ivaki kaayau gioonna kiaapuuya tauraa niiyara yaagueeqakiaiya ni pikiada iya seenaiya ngiari nnammutuaiya kooyaa vitaikiai ngiariiyara ngiariiyara nnannataaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nnannateekiai fai kaayau unnakua forofetaiya diitada kaayauma gioonna kiaapuuya unnakua kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Itaikio kaayau aataru maisaiyauvo vakia roo vioo vioo pinaavai vainaraivaara kaayau gioonna kiaapuuya mmuduuya rira aataruuvaa fai pikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Fai gioonna kiaapu voovoono innasi mmuaararaivo vainoonnaata yaagueeqama kioo iima roo vioo vioo ari putira suaivo innasi nnino Anutuuqo inna vitoo yoosinna yoketaivaki yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anutuuqo gioonna kiaapuuyara dira mmayaaya yoketaivaa fai gioonna kiaapuuya varada mmuakiaa mmatavau vida ivaki variaiya kiaa mmikiai mmuakiaaya rikiakio nnaagiai fai ngiau mmataivo taikaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Fai ngia teekio mminnaa maisai ari vookaraivaara nnaaruaa vaidi forofetaa Danieero ivaara fafaara roovo Anutuuqaa nnau yoketaa tuanaivaki dioo vainaravai. Gioonna kiaapuuya aa kua na kiau aavaa yaarida arinaima rikiaatee. Fai ivo dioo vainai teeda ");
INSERT INTO waj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ngia Yutayaa variaiya ngiingii yaatu aatuuda taapiivaura seenada kuatee. ");
INSERT INTO waj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Fai gioonna kiaapu voovoono ari nnauvaa vainiivau iikiaivo sa ari mminnamminnaivaa varaanara ari nnauvaki kuaivee. ");
INSERT INTO waj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gioonna kiaapu voovoono ari mmooriivaki iikiaivo ari yaapaivaa mmoori tooyaivau yapa kiaivaa sa kava vara ranoo vioo ivaa varaivee. ");
INSERT INTO waj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Boo, iqii suai ivaki gioonna nnaakara sunnaakiaiyaata gioonna nnaakara meedi ruaiyaatama kuaaraivo iya mmuaararainaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Vati pinaa rira suaivakiaata vaidiiya kati varira suaivakiaatama vivoora kiaa yaaku varaatee. ");
INSERT INTO waj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iqii suai ivaki kaayau maisa mmuaararaivo ari vookaraivai vainno mmuakiaa mmuaararaivo gioonna kiaapuuyaki vaivaa yaataraanaravai. Nnaaru Anutuuqo ngiau mmata uu suaivaki varuuya varia rada nnidada makee aa suai ta variaunnaivaki variaiya hama kaayau maisa mmuaararaivo itaama vaivaa taavaivee. Fai yapooma variaaraiya hama itaama vai mmuaararaivaa taaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iqii suai ivaara Anutuuqo paanna suaivai mmataama kioo tiravai. Fai hama paanna suaivaa yapa kinai gioonna kiaapuuya putu taikaaravai. Anutuuqo ariiniee kiaa mmataama kiooyara yaata utuoo suaivaa paannavai yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Fai iqii suai ivaki gioonna kiaapu voovoono ngii tinara: Taatee. Anutuuqo mmataama kioo vaidiivo aavaki varinoo, tinai sa inna kuaivaa rikiaatee. Fai voovoono tinara: Iqiivaki varinoo, tinai sa inna kuaivaa rikiaatee. ");
INSERT INTO waj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Fai unnakua vaidi vooya nnida voovoono ariiyara tinara: Na Anutuuqo mmataama kioo vaidiivoona ngiaunoo, tinaravai. Fai itaa kua kiaaraiya ari vookara ari vookarai mmooriiyauvaa iikiaaravai. Anutuuqo gioonna kiaapuuya ariiniee kiaa mmataama kiaiya unnakua kiaa kiada iya iida aataru maisaivau iya vita yapaaraivaara iya ari vookara ari vookarai mmooriiyauvaa iikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Rikiaatee. Na aanna iya iikiaaraivaara mmuaanaa ngii giaa ngii miaunoo. ");
INSERT INTO waj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Fai iya ngii kiaara: Taatee. Anutuuqo mmataama kioo vaidiivo koo mmuyai gaanga mmataivau varinoo, tikiai sa oro taatee. Fai iya kiaara: Nnau aakiaa voovaki varinoo, tikiai sa iya kuaivaa rikiaatee. ");
INSERT INTO waj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Suai raari raivakidiri saneetuuvo ngioo suai haatapeeranni vioo akiairaama tipannuuma kiaivaa roosiima Na Vaidiivaa Mmaapuuvo itaama mmuaakaraama tiinaravee. ");
INSERT INTO waj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vaidi putiivaa nnabaivo vaivaki hemoonnaiya nuunaida hatoka nnaara puru variaavaivee, tiravai. Ivaa roosiima mmuakiaa yoosinnaiyauvaki gioonna kiaapuuya nuunakiaivaki ari tiinaraivaara Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yisuuva itaa kua kiaa kioo tunoo: Iqii suai ivaki maisa mmuaararaiyauvo taika kino too akiairaino fai suaivo ngioo upisiima tu kioo vaino too kuraagaivo nnino hama mmeekiaivo teeno too aakiapuaiyauvo ngiauvaudiri tasukua roo tuoo vino yaagueeqa mminnamminnaa ngiau aapu vaiyauvo ngiari aataru nuairaiyauvaa pikiada sabi kuaaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ii suai ivaki Na Vaidiivaa Mmaapuuvo tiinara atauvo ngiauvau vainaravai. Vainai teeda mmuakiaa gioonna kiaapu mmatayaa vo kua vo kua kiaiya ratada varida teekiai Na Vaidiivaa Mmaapuuvoono ngiau aapu nama aakiaidaadiri ni yaagueeqaivoota kaayau ari vookarai mmeekiaivootama ni tasipanai tiinaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na tiino noomaivo pinaama akua tinai na aangeraiya titanai teeda iya mmuakiaa yoosinna nuaida suai raari raipinnai vida suai haatapaipinnai vida tooya sainai vida tooya sainai vida gioonna kiaapu na niniiniee kiaa mmataama kiauya rupi nuunama vitada niisi ngiaaravee. ");
INSERT INTO waj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Na yatari nnaammuayaivaudiri mmataama kiee tinai ngia tuqinnama rikiaatee. Nnaammuayaivo mmunni raikiai ngia teeda kiaanoo: Nuanuuvo vainima nnikioonno mmunni rainoo, kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mmuaikaraama ii na ngii giaa ngii miau kua iyauvaa kaanaiyauvaa ngia teeda rikikio na tiinara suaivo inna vaa vainima vainoo. ");
INSERT INTO waj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu aanna makee variaa aaya hama putiraida homo varikio suaivo nnino ii aataru iyauvo fai vainaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngiau mmataivo fai taikaanaravaivee. Ni kuaivo fai hama taikaanaravai. Fai tupatupaa vainaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Hama gioonna kiaapu voovoono na tiinara suaivaa too rikiaivai. Aangeraa ngiau aapu variaiyaatama hama teeda rikiaavai. Na inna Mmaapuuvo neetama hama tee rikiauvai. Ari ni Napoovaano nnaasu too rikiaivai. ");
INSERT INTO waj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na Vaidiivaa Mmaapuuvo kava tiinara suaivo Nuvuaava varuu suaivaa roosiima vainaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nnaaru hama nnooriivo mmata mmuakiaavai rapodaa taika kioo suaivaki gioonna kiaapuuya yeennaiyauvaa nneeda nnooriivaa nneeda nnaata vaatiivaa vareeraivaara yaata utu kiada vaidada Nuvuaava nnooriyaa nuaira nnauvaki vuu suaivaki iya homo itaidada ");
INSERT INTO waj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","iya hama nnooriivo iya raputu taikaanara kuaivaa arinaima rikiooduu nnooriivo ngioo iya raputu taika kieeravai. Iya itaama varuneema Na Vaidiivaa Mmaapuuvo kava tiinara suaivaki fai gioonna kiaapuuya mmuaikaraama kumimakaida variaaravee. ");
INSERT INTO waj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ii suai ivaki taara vaidivaitana mmooriivaki mmooriivaa varakio Anutuuqo fai vuaivaa vitoo vioo vuaivaa pikioo kuanaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Fai gioonna taaravaitana mmuaavau varida mmoori varakio fai Anutuuqo vuainningiaa vitoo vioo vuainningiaa pikioo kuanaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ivaaraida haitatuukiatee. Ngia hama ngii Udaangaivo tiinara suaivaa teeda rikiaaraivaara haitatuukiatee. ");
INSERT INTO waj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aa kua aavaa rikiaatee. Mmuara vareera vaidiivo nnauvaki nninara suaivaa vaa nnau nakaaraivo rikioo avuuvaa too vaitiri. Mmuara vareera vaidiivo heenaki ivaki ngioo hama yopeema sipuuvaa rukaitu kioo ngioo vioo mminnamminnaiyauvaa mmuara varaitirivee. ");
INSERT INTO waj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ivaaraida mmuaanaa teerakiatee. Hama ngia teeda rikieera suaivaki Na Vaidiivaa Mmaapuuvo fai kava tiinaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Dee mmoori vareera ngiaammuauvoono tinni yoketaivaa varoo ari mmooriivaa hama pikieerainno yaagueeqama nnaasu iinnee? Itai ngiaammuauvaa vaidi nnoonnaivo kieetavai inna yapa kiaikio inna nnauvaara haitatuunno seena ngiaammuauya yeenna nneera suaivaki yeennaiyauvaa duuyama iya mmiivai. ");
INSERT INTO waj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ivo itaama varikio nnoonna vaidiivo ngieeradiri vara ranoo numa ari nnauvaki taikio homo yoketaama mmoori varoo varikio too ngiaammuauvaara inna yoketaivai. ");
INSERT INTO waj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na kua kutaavai ngii giaa ngii miaunoo. Ii ngiaammuau ivaa vaidi nnoonnaivoono ari hoonahaana mmuakiaayauvaara haitatuura ngiaammuauvai inna yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Fai ivo maisama varioo ariiyara tinara: Nnoonna vaidiivo hama akiairaama nninaravee, ");
INSERT INTO waj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kiaa kioo ari seena ngiaammuauya ripiinno yeennaiyauvaa nnoo nnoori kapikaraivaata nnoo ari seena vaidiiya nnoori kapikaraivaa nneeda kumimakakiaiya tasipama varino ");
INSERT INTO waj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","fai yapooma hama ivo rikioo teeraira suaivaki nnoonna vaidiivo nninaravai. ");
INSERT INTO waj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ngioo ivo fai inna ruputu rutaka kagaari kino ivo huooba kua tira unnakua nnaamuruuya variraivaki kuanaravai. Ii yoosinna ivaki gioonna kiaapuuya varida teekio iya nnannateenai fai ngiari avaiyauvaa hakutikio iya ausaiyauvo mmuaarareenai rataaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na tiinara suaivaki Anutuuqo gioonna kiaapuuyara diraivo aa na kua tinara aavaa roosiima vainaravai. Kiaatanna yaakuuvaitana ngiari raamaiyauvaa varada kieevatiivaa yaapeeri buusa nneera suaivaki oto inna sunaara kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Iyakidiri kiaatanna yaaku saivai yaata duunaya kuaani kiaatanna yaaku saivai tinni yoketaaya kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kiaatanna yaata duunaiya ngiari raamaiyauvaa nnaasu varada hama karasiinaiyauvaatama varada kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kiaatanna tinni yoketaiya ngiari raamaiyauvaata varada ngiari karasiinaiyauvaatama varada kuaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iya oro varida kieevatiivaara haitatuuda taavo ivo homo faikaa ngioo varikiai iya vuru raikiai vakiaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Vakiaavo rikioo heena tammaikio aayannaivoono iya yuruunno tinoo: Vaa kieevatiivo nninoo. Diitada oro inna sunada ngiatee, ");
INSERT INTO waj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","tikiai rikiada diitada ngiari raamaiyauvaa subi teerama kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Subi teerama kiaani hama teerakiaiyaano vaa teerama kiaiya kiaanoo: Ti raamaiyauvo tasuunara iinoo. Ngiengieeraira karasiinaiyauvaa ti mmikiai ta ti raamaiyauvaki tusi kuaaravee, ");
INSERT INTO waj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","kiaani rikiada iya sai kiaanoo: Hameetavee. Fai ngia tikiai ta ngii mi kiada ngieeta teetama hama karasiinaatainaravai. Ngia oro karasiinaiyauvaa yookaama kiada ngiingiiyara varada ngiatee, ");
INSERT INTO waj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","kiaani rikiada karasiina varaara vida variaavo kieevatiivo nnikiai vaa teerama kiaiya inna sunada buusaivaa nnaara vida kiaavo ivo sipuuvaa rau kiaivai. ");
INSERT INTO waj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Rau kiaikiai nnaagiai kiaatanna saiya kava vara ranada numa kiaanoo: Udaanga-o, sipuuvaa tiini hatuaanee, ");
INSERT INTO waj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","kiaavo rikioo ivo iya sai tinoo: Na kua kutaavai ngii giaa ngii miaunoo. Hama na ngii tauyavee, tiivaivee. Yisuuva ii kua ivaa kiaa taika kioo ari ngiaammuauya tunoo: ");
INSERT INTO waj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Itaama vainai tuqinnama haitatuukiatee. Hama ngia na tiinara suaivaa teeda rikiaavaivee. ");
INSERT INTO waj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Anutuuqo gioonna kiaapuuyara diraivo aa na kua tinara aavaa roosiima vainaravai. Vaidi voovoono ngieera vo yoosinnavakira kuanara iinno varioo ari mmoori vareera ngiaammuauya tikiai innasi ngiaavo rikioo ari nnau mminnamminnaiyauvaa haitatuukiateera kiaa kioo ari sikauyauvaa iya mmiivai. ");
INSERT INTO waj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ivo iya mmoori varaiyauvaa mmuaavai mmuaavai too rikiaa kioo ivaara sikauyauvaa yaarummua kioo iya mmiivai. Voovai kaayau sikauyauvaa (5000) mmi kioo voovai nnoonnama sikauyauvaa (2000) mmi kioo voovai kiisa sikauyauvaa (1000) mmiivai. Ivo iya itaama mmi taika kioo iya pikioo kuaivai. ");
INSERT INTO waj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kuaikio rikioo ngiaammuauvo kaayau sikauyauvaa (5000) utiivoono kammannaikio varoo oro vaidi vooya mmikiai varada ngiari mmoori pinaivaki irisaiyauvaa varada saiyauvaata inna mmikio too ari sikauyauvunudiri yaatarai sikauyauvaatama vara nuunama utuoo taikio kaayakaayauma sikauyauvo (10,000) vaivai. ");
INSERT INTO waj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nnoonnama sikauyauvaa (2000) utii ngiaammuauvoono mmuaikaraama iinnonno kava nnoonnama sikauyauvaa (2000) vara nuunaikio vioo kaayau sikauyauvo (4000) vaivai. ");
INSERT INTO waj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kiisa sikauyauvaa (1000) utiivoono vioo mmataivaki hanuu kioo nnoonna vaidiivaa sikauyauvaa hauma kiaivai. ");
INSERT INTO waj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Iya itaama iima kiada variaavo nnaagiai hokoba suaivo taikaikio nnoonna vaidiivo ngieeraipidiri numa iyasidiri ari sikauyauvaa varaanara nniivai. ");
INSERT INTO waj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ngioo taikio ngiaammuau kaayau sikauyauvaa (5000) mmuuvoono kava kaayau sikau (5000) vooyauvaatama tasipama inna mmioo tinoo: Nnoonna-o, taanee. A kaayau sikauyauvaa (5000) ni munnaiyauvaa na ivaadiri mmoori iikiauko kaayau sikauyauvo (5000) vaiyauvaatama na vara nuunama utuee i mmiaunoo, ");
INSERT INTO waj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","tikio rikioo nnoonna vaidiivo inna tinoo: A ngiaammuau yoketaakuavee. A mmooriivaa yoketaama iikiannavai. A sikauyauvaa varee iyauvunudiri yoketaama iikiannani irisaivaa fai na pinaa mmooriivaara dianeera i yapa kiaanaravai. Numa ni tasipama variee sirigakianee, ");
INSERT INTO waj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","tikio vo ngiaammuau voovai nnoonnama sikauyauvaa (2000) utiivoono numa nnoonna vaidiivaa tinoo: Nnoonna-o, taanee. A nnoonnama sikauyauvaa (2000) ni munnaiyauvaa na ivaadiri mmoori iikiauko nnoonnama sikauyauvo (2000) vaiyauvaatama na vara nuunama utuee i mmiaunoo, ");
INSERT INTO waj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","tikio rikioo nnoonna vaidiivo inna tinoo: A ngiaammuau yoketaakuavee. A mmooriivaa yoketaama iikiannavai. A sikauyauvaa varee iyauvunudiri yoketaama iikiannani irisaivaa fai na pinaa mmooriivaara dianeera i yapa kiaanaravai. Numa ni tasipama variee sirigakianee, ");
INSERT INTO waj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","tikio ari vo ngiaammuau voovai kiisa sikauyauvaa (1000) utiivoono numa yokeera vaidiivaa tinoo: Nnoonna-o, na i taukai a tinni yaagueeqaira nnaamurukuavee. Hama a yeenna hauvaa utuanna mmooriivakidiri yeenna kaanaivaa varaannavai. A hama mmoori varaannaivakidiri yeennaiyauvaa tau varee ngiannavai. ");
INSERT INTO waj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ivaara na aatuuna oro i sikauyauvaa mmataivaki hau kiauvai. Taanee. Aanna ai sikauyauvoonno vainoo. Ee varaanee, ");
INSERT INTO waj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tikio rikioo nnoonna vaidiivo inna sai tinoo: A ngiaammuau maisa kati varira nnaamurukuavee. Vaa a kutaa taannani na hama yeenna hau utuau mmooriivakidiri yeenna kaanaivaa varaunnee? Vaa a taannani na hama mmoori varauvakidiri yeennaiyauvaa tau varee ngiaunnee? ");
INSERT INTO waj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mo inna aikioovai. A itaama yaata utueennainna a ni sikauyauvaa varee sikau nnaamuruuvaki yapaataama vaikiainnaata mmataivaki hau kiaannavai. Vaa a sikau nnaamuruuvaki yapa kiaannatiri. Na kava vara ranee ngiee sikau nnaamuru nakaaraivaasidiri sikau kiisaivaatama varautirivee, ");
INSERT INTO waj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","kiaa kioo vooya tinoo: Aa vaidi aavaasidiri sikau aayauvaa ravisi varada pinaa sikauyauvaa (10,000) utii vaidiivaa mmiatee. ");
INSERT INTO waj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gioonna kiaapu voovoono pinaa mmooriivaa varaivaa fai na kava vo mmoori vooyauvaatama inna mmino rikioo fai kaayauma inna suvuainaravai. Gioonna kiaapu voovoono hama kaayau mmooriaataivaa fai kiisa mmoori innasi vaivaa na numa innasidiri ravisi varaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aa ngiaammuau kumina varii aavaa varada oto mmaanai upisiivaki kagaari kiaatee. Ii yoosinna upisi ivaki gioonna kiaapuuya varida teekio iya nnannateenai fai ngiari avaiyauvaa hakutikio iya ausaiyauvo mmuaarareenai rataaravaivee. Nnoonna vaidiivoono itaa kua tiivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yisuuva itaa kua kiaa kioo tunoo: Na Vaidiivaa Mmaapuuvo fai na kava mmatayaa tiinara suaivaki mmuakiaa aangeraiyaatama ni tasipama tiikiai fai na ari vookaraama yoketaama variee fai gioonna kiaapuuyara dinaravai. ");
INSERT INTO waj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Fai na iyara diee vainai mmuakiaa gioonna kiaapu sainaidi sainaidiri niisi nnida nuunakiaaravai. Nuunaikiai puara sipisiipa memeeyauvaa haitatuura vaidiivo ari puaraiyauvaa sainai sainai yapaineema ");
INSERT INTO waj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","fai na iya mmuaavai mmuaavai sainai vara yapee sainai vara yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na yapa kiee kieetavai diee vaina gioonna kiaapu ni yaaku yaadudainningiaa diaiya tinara: Ni Napoova ngiiiyara yoketaa kua tiiya nnaaru ngiau mmata uu suaivaki ivo yoosinnaivaa ngiiini teerama kioovaki numa variatee. ");
INSERT INTO waj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Na ni yeenna raikiai variaukai ngia yeennaiyauvaa ni miaavai. Na ni nnoori raikiai variaukai ngia nnooriivaa ni miaavai. Na voopinnaivo ngiaukai ngia niiyara tuqinnaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na taguaada variaukai ngia uyira rairaiyauvaa ni miaavai. Na ni niitaraikiai variaukai ngia numa ni tuqinnaavai. Na oovi nnauvaki variaukai ngia numa ni taavai. Ivaara ngiiini teerama kioovaki numa variatee, ");
INSERT INTO waj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tinai rikiada fai safuuma variaiya ni sai kiaara: Udaanga-o, daira suai ta i taunnano i yeenna raikiai ta yeennaiyauvaa i mmiaunnavainnee? Daira suai i nnoori raikiai ta nnooriivaa i mmiaunnavainnee? ");
INSERT INTO waj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Daira suai a voopinnaavai ngiannani ta aiyara tuqinnaunnavainnee? Daira suai a taguaada variannani ta uyira rairaiyauvaa i mmiaunnavainnee? ");
INSERT INTO waj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Daira suai ta taunnano i nniitaraikiai variannani ta i tuqinnaunnavainnee? Daira suai a oovi nnauvaki variannani ta oro i taunnavainnee? ");
INSERT INTO waj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","tikiai rikiee na kieetaivo sai iya tinara: Na kua kutaavai ngii giaa ngii miaunoo. Aa ni gata vayaa aayakidiri kuminaa voovaara itaama iikiaivo inna niiyaraatama iikiaavaivee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Fai na itaa kua kiaa kiee gioonna kiaapu yaaku geedainningiaa variaiya tinara: Anutuuqo hama ngiiiyara yoketaayavee tiiya ni pikiada kuatee. Ikiaivo tupatupaa too variraivaki Anutuuqo Sataangaata inna aangeraiyaatama iyani teerama kiaivaki kuatee. ");
INSERT INTO waj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Na ni yeenna raikiai variaukai hama ngia yeennaiyauvaa ni miaavai. Na ni nnoori raikiai variaukai hama ngia nnooriivaa ni miaavai. ");
INSERT INTO waj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na voopinnaivo ngiaukai hama ngia niiyara tuqinnaavai. Na taguaada variaukai hama ngia uyira rairaiyauvaa ni miaavai. Na ni niitaraikiai variaukai hama ngia numa ni tuqinnaavai. Na oovi nnauvaki variaukai hama ngia numa ni taavaivee, ");
INSERT INTO waj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","tinai rikiada fai ni sai kiaara: Udaanga-o, daira suai ta taunnano i yeenna raikio i nnoori raikiai hama yeennaiyauvaa i mmida nnooriiyauvaa i mmiaunnavainnee? Daira suai a voopinnaavai ngiannani hama ta iiyara tuqinnaunnavainnee? Daira suai a taguaada variannani hama ta uyira rairaiyauvaa i mmiaunnavainnee? Daira suai i nniitaraikiai variannani hama ta oro i tuqinnaunnavainnee? Daira suai a oovi nnauvaki variannani hama ta oro i taunnavainnee? ");
INSERT INTO waj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","tikiai rikiee fai na sai tinara: Na kua kutaavai ngii giaa ngii miaunoo. Ngia hama aa kumina aayakidiri voovaara iikiaaneema hama ngia niiyaraatama iikiaavaivee, ");
INSERT INTO waj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","tinai rikiada iya irisai maisaivo tupatupaa vairaivaki vikiai vaidi safuuma variaiya tupatupaa variraivaki kuaaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Vaa Yisuuva ii kua mmuakiaa iyauvaa kiaa taika kioo ari ngiaammuauya tunoo: ");
INSERT INTO waj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Vaa ngia rikiaavai. Fai taara suaivaitana taika kinai buusaivaa nnutuuvo Varaigiataivaa nnaara suaivo nninaravai. Nnino fai vaidi voovoono Na Vaidiivaa Mmaapuuvaa kooyaa vaidi kieetaiya ni vitainai yatari sagaivau fai ni haara kiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Vaidiiya Anutuuqaara kati puara hudeera kieetaiyaata vaidi Yutayaa yokovaiyaatama nuunaida ngiari kieeta tuanaivaa nnutuuvo Kayapaanna nnauvaki hara kiada varida ");
INSERT INTO waj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","haumakinaa Yisuunna vitada ruputikio putuaiveeraivaara kua yeena rairavai. ");
INSERT INTO waj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kua yeena raida tunoo: Buusa nneera suaivaki gioonna kiaapuuya nuunaida iya kumimakaida rapivoora kiaa hama ta Yisuunna utida ruputuaaravee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yisuuva yoosinna Betaniaa vioo vaidi voovai nnutuuvo Simoonaa nnauvaki hara kioo variravai. Simoonaa mmammaivo buunna hooya mmamma roosuuvo vaa yoketairavai. ");
INSERT INTO waj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Inna nnauvaki Yisuuva yeenna nnoo varuduu gioonna voovoono heenna suuya suuda yoketaa vuu sikau tooriivaara pinaa sikauyauvaadiri yookaama kioo varoo numa inna kieetaivau tusaa apiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tusaa apuduu ari ngiaammuauya iva uuvaa tooduu iya nnannatooduu tunoo: Aaniirainno heenna suuya suuda yoketaa kuai aavaa kuminayaa tusaa kagaari kiainnee? ");
INSERT INTO waj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ivo ivaa varoo vaidiiya mmiitiri. Irisai sikau pinaiyauvaa varoo gioonna kiaapu mmanna haipuuya mmiitirivee, ");
INSERT INTO waj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","tuduu rikioo Yisuuva iya itaa kua tuu kuaivaa rikioo tunoo: Ngia aaniiraida aa gioonna aavaara itai kuaivaa kiaannee? Iva yamaa aataruvainno ni iinoo. ");
INSERT INTO waj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mmanna haipu gioonna kiaapuuya tupatupaa ngii tasipama hara kiada variaaravaivee. Hama na tupatupaa ngii tasipama varinaravai. ");
INSERT INTO waj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na putinai ni hakuaaraivaara gioonnaivo mmuaanaa heenna suuyaivaa ni mmammaivau tusaa apinoo. ");
INSERT INTO waj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na kua kutaavai ngii giaa ngii miaunoo. Mmuakiaa yoosinnaiyauvaki gioonna kiaapuuya ni mmayaaya yoketaivaa kiaa mmiaa yoosinnaiyauvaki aa gioonna aavo ii mmayaayaivaatama iya gioonna kiaapuuya kiaa mmikiai rikiada innara yoketaama yaata utuaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yisuunna ngiaammuau yaakuuvaitana yukukidiri taaramaakidiri voovai nnutuuvo Yutaaso vuai nnutuuvo Isariooto Anutuuqaara kati puara hudeera kieetaiyasi vioo ");
INSERT INTO waj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","iya tunoo: Fai ngia aaniivai ni mikiai na Yisuunna kooyaa ngii vitainarannee? tuduu iya sikau mmuaa vaidivai yuku yaaku taika kiada vo vaidivai yaakuuvaitana yaarummua kiada inna mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mmi kiooduu too ii suai ivakidiri iva faannama roo varia roo vioo varioo dee suai tuanaavai nnino rikioo iva Yisuunna kooyaa iya vitainaraivaara haitatuuravai. ");
INSERT INTO waj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gioonna kiaapu Yutayaiya buusaivaa nneeda hama puuqaira yeennaivaata bereetaivaa tasipama huda nneera tauraa suaivaki Yisuunna ngiaammuauya innasi nnida tunoo: Ta dee nnauvaki vida Varaigiataa buusa a nnaanaraivaa aini teerakiaunnannee? ");
INSERT INTO waj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","tuduu rikioo tunoo: Ngia vidada oro yoosinna pinaivaki vaidi voovaasi vida inna kiatee: Ti Vitairaivo tinoo: Ni suaivo vaa vainima nninoo. Na ni ngiaammuauyaatama i nnauvaki buusa Varaigiataivaa nnaaravee, kiatee, ");
INSERT INTO waj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","tuduu rikiada inna ngiaammuauya iva tuuvaa rikiada oro buusaivaa teerama kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Teerama kiooduu heenauduu rikiada Yisuuva ari ngiaammuau yaakuuvaitana yukukidiri taaramaatama yeenna nnaara oro varida ");
INSERT INTO waj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","yeenna nneeda varuduu Yisuuva iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Fai ngiiikidiri vaidi voovoono kooyaa ni nnammutuaiya ni vitainaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","tuduu rikiada ari ngiaammuauya ausaiyauvo kaayauma mmuaararooduu mmuaavai mmuaavai inna yaparaida voovoono tunoo: Udaanga-o, vo neenoonnee? ");
INSERT INTO waj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","tuduu rikioo Yisuuva sai tunoo: Vaa vaidi voovoono ni tasipama yeennaivaa yavaivakidiri mmuaavaugiataa rabuuma kioo nnaivoono kooyaa ni nnammutuaiya ni vitainaravai. ");
INSERT INTO waj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na Vaidiivaa Mmaapuuvoono fai putinaravai. Anutuuqaa yanaivau fafaaraivo vainno ivaara tiivo aanna makee vainoo. Na Vaidiivaa Mmaapuuvaa vaidi voovoono kooyaa ni nnammutuaiya ni vitainaraivoono fai irisai maisaivaa varaanaravaivee. Ii vaidi ivaa hama ari kaano mmataitiri. Hama mmoori maisaivaa iinno irisai maisaivaa varaitirivee, ");
INSERT INTO waj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","tuduu rikioo Yutaaso inna nnammutuaiya kooyaa inna vitainaraivoono tunoo: Mo vitaira-o, neenoonnee? tuduu rikioo Yisuuva inna sai tunoo: Eenoo kiannavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yisuuva ari ngiaammuauyaatama yeenna nneeda varuduu Yisuuva bereetaivaa vara tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo kusii kioo ari ngiaammuauya mmioo tunoo: Aavaa varada nnaatee. Aanna ni mmatiivaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tuduu nnooduu iva kava vuaina suuya tooriivaa vara tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo iya mmioo tunoo: Ngia ivakidiri mmuakiaaya nnaatee. ");
INSERT INTO waj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aanna ni kiauvai. Na kaayau gioonna kiaapuuyara yaata utuee ni kiauvaa tusaa kino rikioo Anutuuqo kua yeena rau kiai karaasa aataruuvo kooyaa vaino ivo iya mminnamminnaa maisaiyauvaa rugaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na ngii giaa ngii miaunoo. Hama na aavau kava vuaina suuyaivaa ngii tasipama nnaanaravai. Vo suai voovaki yapooma ni Napoonna yoosinnaivaki fai na vuaina suuya ari vookaraivaa ngii tasipama ari vookaraama nnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","tuduu nnaa kiooduu iya Anutuuqaara kuaru voovai kiaa taika kiada diitada taapi Oriveeta ivaura viravai. ");
INSERT INTO waj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oro ivau varuduu Yisuuva iya tunoo: Aa heena aavaki fai ngia mmuakiaaya ni pikiada vida raubiriima kiaaravai. Anutuuqaa kua fafaaraivo vainno tinoo: Anutuuqo tinoo: Na puara sipisiipara haitatuura vaidiivaa ruputu kinai fai sipisiipaiya raubiriikiaaravaivee, tiivaivee. Kua fafaaraivoono itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Fai itaama vainai na putino Anutuuqo ni tinai na kava diitee neennaadee Karirayaa vinai fai ngia ni nnaagiai kuaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","tuduu rikioo Petorooso inna sai tunoo: Ai, hama na i pikiaanaravai. Fai mmuakiaa ni seena ngiaammuauya i pikikiai fai neenoo hama i pikiaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","tuduu rikioo Yisuuva inna sai tunoo: Na kua kutaavai i kiaa i mmiaunoo. Turau hama kakaraivo akua tinai fai a taaravoomaneetu niiyara tinara: Hama na inna tauvaivee, tinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","tuduu rikioo Petorooso inna sai tunoo: Fai a putinai neeta putinaravai. Fai hama na aiyara tinara: Hama na inna tauvaivee, tinaravee, tuduu ari ngiaammuau mmuakiaaya mmuai kuaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tuduu Yisuuva ari ngiaammuauyaatama yoosinna Kisamanii vioo iya tunoo: Ngia aavau varikiai na oro hayu vo kammuvaudiri yaaku varaanaravee, ");
INSERT INTO waj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","kiaa kioo Petoroosaa vitoo Sevetainna mmaapuuvaitana vitoo vioo varuduu inna ausaivo kaayauma mmuaararooduu iva yaata utuuvo ari vookarauduu ");
INSERT INTO waj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","iva iya tunoo: Mmuaararaivo niiki vaikio ni ausaivo pinaama mmuaararoo ari vookarainoo. Niiyara aavau varida haitatuukiatee, ");
INSERT INTO waj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","kiaa kioo oro kiisama vo kammunni voovau vioo varoo mmataivaki vainno yaaku varoo tunoo: Ni Napoo-o, vo aataru voovai vainai mmuaararaivo aa nnoori toori kapikarai aavaa roosiivo niisi nninaraivaara ooqoo tino pikiaivee. Inna aikioovai. Ni iikiataivaa sa iikianee. Ai iikiataivaa iikianee, ");
INSERT INTO waj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","kiaa kioo kava vara ranoo numa tooduu ari ngiaammuaudo vuru vaida varuduu ivo iya yuruuma kioo Petoroosaa tunoo: Mo dataikiai ngia hama mmuaa suai voovau niiyara tida avu teeda vakiaannee? ");
INSERT INTO waj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ngii iinno taanaraivo ngiiisi nninarainnoo tida avu teeda vaida yaaku varaatee. Vaidiivaa mmannasaivo inna iikiataikio nnabaivo muaraagainoo, ");
INSERT INTO waj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","kiaa kioo Yisuuva kava oro yaaku varoo tunoo: Ni Napoo-o, aa nnoori toori kapikarai aavaa fai hama na nneeno mmuaararaivo homo vainaraivaara inna aikioo eenoo ai iikiataivaa iikianee, ");
INSERT INTO waj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","kiaa kioo kava vara ranoo numa tooduu ari ngiaammuaudo vurura rusi rusiima rikiada vaa vuru vairavai. ");
INSERT INTO waj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Vauduu too Yisuuva kava iya pikioo oro vooneetu yaaku varoo mmuai kuaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kiaa kioo kava vara ranoo numa ari ngiaammuaudaa tunoo: Ngia homooda vuru vaida variaannee? Na Vaidiivaa Mmaapuuvaa vaidi voovoono vaidi maisa vooya kooyaa ni vitainara suaivo aavaa nninoo. ");
INSERT INTO waj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Taatee. Vaidiivo kooyaa ni vitainaraivoono aavaa nninoo. Diitakiai ta innasi kuaaravee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisuuva homo kua tioo varuduu ari ngiaammuaudo yaakuuvaitana yukukidiri taaramaakidiri voovai nnutuuvo Yutaaso nniravai. Anutuuqaara kati puara hudeera kieetaiyaata vaidi Yutayaa yokovaiyaatama kaayau vaidiiya titooduu iya paipa avaikarauyauvaata tipaiyauvaatama utida Yutaasaa tasipama Yisuunnasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yutaaso kooyaa inna vitainaraivoono vaa mmuaanaa vaidiiya kiaa mmioo tunoo: Ngia teekiai vaidi na mmootaanara vaidiivo inna ngia vitaara vaidiivovee. Inna puaisa utuatee. ");
INSERT INTO waj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ivo itaa kua tuuvoono ngioo ngioo numa makee tuduu Yisuunna tunoo: Vitaira-o, a yoketaama variannannee? kiaa kioo inna mmooteeravai. ");
INSERT INTO waj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mmootooduu Yisuuva inna sai tunoo: Ni vuaigo, e aapi iinara ngiannaivaa iikianee, tuduu rikiada vaidi vooyaano numa Yisuunna puaisa utu kiada vauduu ");
INSERT INTO waj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yisuunna ngiaammuauyakidiri voovoono ari paipa avaikarauvaa nnaamuruuvakidiri utu rada kioo Anutuuqaara kati puara hudeera vaidi kieetaivaa ngiaammuau voovai yaataivaa rutaka kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Rutaka kiooduu Yisuuva ari ngiaammuauvaa tunoo: Ai paipaivaa vara ari nnaamuruuvaki kava uyuanee. Mmuakiaa gioonna kiaapuuya paipa avai karaivaadiri utida gioonna kiaapu vooya ruputuaaraiya fai iyaata irisai paipa avai karaivaadiri utida iya ruputikiai putuaaravai. ");
INSERT INTO waj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hama ngia rikiaavai. Ni iikiatainai na ni Napoonnara aayanna tino fai ivo akiairaama aangeraa hama ngia yopeema yaaruaiya titanai ni utida yoketaivau ni yapaaravee. ");
INSERT INTO waj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mo itaama vainai dataama kioo Anutuuqaa kua fafaaraivo tuuvaugiataama iya itaama iikiaivaa kaanaivo aanna vainarannee? Hama fai vainaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kiaa kioo ivaki nuunauya Yisuuva tunoo: Ngia yaata utida kiaanoo: Mmuara vareera vaidi roosiivaivee, kiaa kiada paipa avaikaraiyauvaata tipaiyauvaatama utida ni mmaara ngiaannee? Mmuakiaa suai na ngii tasipama nuunaira nnau pinaivaki variee ni kua mmayaayaivaa ngii giaa ngii miaaduu hama ngia ni utiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nnaaruaa vaidi forofetaiya ngia iikiaivaara fafaara roovaa kaanaivo vakiaiveeraivaara aanna makee ngia itaama iikiaanoo, tiravai. Tuduu rikiada ari ngiaammuau mmuakiaaya inna pikiada ngiari toovau viravai. ");
INSERT INTO waj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Vuduu vaidi Yisuunna utuuya inna vitada Anutuuqaara kati puara hudeera kieeta tuanaivaa nnutuuvo Kayapaanna nnauvaki yapa kiada varuduu vaidi kua mmaanna kiaa mmiraiyaata vaidi yokovaiyaatama ivaki nuunaida variravai. ");
INSERT INTO waj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Varuduu Petorooso ngieeradiri Yisuunna nnaagiai vioo vioo vaidi kieeta tuanaivaa vagiaamunna aakiaivaki vioo vaidi rapiraiyaatama tasipama hara kioo varioo Yisuunna iikiaaraivaa taanaraivaara ivaki variravai. ");
INSERT INTO waj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Varuduu Anutuuqaara kati puara hudeera vaidi kieetaiyaata vaidi kua yeena raira mmuakiaayaatama Yisuunna ruputikio putuaiveera unnakuaivaadiri kua pinaana inna yapaara uuduu ");
INSERT INTO waj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kaayau gioonna kiaapuuya numa innara unnakua tuduu hama kua oyaivootauduu pikiooduu nnaagiai taara vaidivaitanaano diitada numa tunoo: ");
INSERT INTO waj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Aa vaidi aavoono ataa kua tunoo: Na aikiooma Anutuuqaa nnau pinaivaa havarata kiee taaravooma suaivo taikanai na kava heeka kiaanaravaivee, tiravaivee. ");
INSERT INTO waj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ivaitana itaa kua tuduu rikioo Anutuuqaara kati puara hudeera vaidi kieeta tuanaivoono diitoo Yisuunna tunoo: Mo iya i kiaani a hama iya kua saivaa kiannannee? Aa vaidi aavaitana mo dee kuavai aiki yapaavainnee? ");
INSERT INTO waj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","tuduu rikioo Yisuuva kua seemuaa varuduu kava kieeta tuanaivoono inna tunoo: Anutuuqo ngiau aapu variivaa nnutuuvaa tasipama kua kutaavai ti kiaa ti mmianee. E Anutuuqo mmataama kioo vaidi Misiaivovee tiee Anutuuqaa Mmaapu tuanaivovee tiee ti kiaa ti mmianee, ");
INSERT INTO waj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","tuduu rikioo Yisuuva inna sai tunoo: Inna a kutaa kuavai kiannanoo. Na ngii giaa ngii miaunoo. Aanna na variau suai aavakidiri varia ree viee viee nnaagiai na varinara suaivakiaatama fai ngia teekiai Na Vaidiivaa Mmaapuuvo Anutuuqo mmuakiaa yaagueeqaivaa yaataraivaa yaaku yaadudainningiaa hara kiee variee fai nama aakiaidaadiri tiinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tuduu rikioo kieeta tuanaivo inna kuaivaara inna ausaivo pirisauduu ari uyu rauyauvaa utu rapasi kioo tunoo: Ivoono Anutuuqaara koonnama kua tiivai. Sa vaidi vooya kava numa innaki kua pinaa yapaaraivaara yaata utuatee. Ivo ari avaivakidiri koonnama tinoo: Na Anutuuqaa mmaapuvaivee, tiivaa vaa ngia rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngia innara dataamaida yaata utuaannee? tuduu rikiada iya inna sai tunoo: Ta rikiaunnano ivo koonnama kua tiivaara fai inna aikiooma ivo putinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Iya itaa kua kiaa kiada Yisuunna viri nnikiivaki kuaanuuvaa visida yaaku rurauma utida inna ruduu vooyaano yaaku yapa nneerannidiri inna rida varida ");
INSERT INTO waj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tunoo: Anutuuqo i mmataama kioo vaidi Misiaakuavee tiee kooyaa ti kiaa ti mmianee. Gioonoonno i ruputiinnee? tiravai. ");
INSERT INTO waj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Iya itaama iida varuduu Petorooso mmaanai vagiaamunna aakiaivaki hara kioo varuduu mmoori vareera kiaatanna voovoono numa inna tunoo: Eetama Karirayaa vaidi Yisuunna tasipama nookiannakuavee, ");
INSERT INTO waj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","tuduu rikioo mmuakiaa ivaki varuuya rikiada vauduu Petorooso yaagueeqama ooqoo tuoo tunoo: A kianna kua oyaivaa hama na arinaima rikiaunoo, ");
INSERT INTO waj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","kiaa kioo oro nnau haayaivaki dioo vauduu vo mmoori vareera kiaatanna voovai inna too vainno vaidi ivaki duuya tunoo: Aa vaidi aavo Nasareetaa vaidi Yisuunna tasipama nuairaivovee, ");
INSERT INTO waj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","tuduu rikioo Petorooso kava yaagueeqama ooqoo tuoo tunoo: Kutaa tuanaavai. Hama iqii vaidi ivaa na tauvaivee, ");
INSERT INTO waj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","tuduu kiisa suai taika kiooduu vaidiiya ivaki duuya numa inna tunoo: Kutaa tuanaa a inna tasipama nookiannavai. A kua kiannaivo inna nnuuna roosiinoo, ");
INSERT INTO waj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","tuduu rikioo Petorooso yaagueeqa kuavai iya kiaa mmioo tunoo: Na hama kua kutaavai kiautiri. Anutuuqo ni ruputitirivee. Na kua kutaavai kiaunoo. Hama na tau vaidivaivee, tiravai. Iva tinee tuu saivaata kakaraivo akua tuduu ");
INSERT INTO waj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yisuuva tauraa inna kiaa mmuu kuaivaa kava vaa taunnu kioovaa yaata utuoo rikieeravai. Tauraa Yisuuva inna kiaa mmioo tunoo: Hama kakaraivo akua tirainno kinai rikiee a taaravoomaneetu niiyara tinara: Hama na inna tauvaivee, tinaravaivee, tuu kuaivaa ivo kava yaata utuoo rikioo mmaanai vioo pinaama rateeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Heenanaanna suaivo nnuduu rikioo mmuakiaa vaidi Anutuuqaara kati puara hudeera kieetaiyaata Yutayaa yokovaiyaatama nuunaida Yisuunna ruputuaara kuaivaa kiaa safuuma kiada ");
INSERT INTO waj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","inna yaakuuvaitanau yeenaadiri ranaa rau kiada vitada oro Roomaaya kieetaivaa Piratuusaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mmuduu too Yisuunna nnammutuaiya kooyaa inna vitau vaidiivo Yutaaso iya Yisuunna vitada ruputuaara uuvaa too inna ausaivo hanigiooduu ivo sikauyauvaa vo vaidivai yuku yaakuuvaa taika kioo vo vaidivai yaakuuvaitana varoo vioo Anutuuqaara kati puara hudeera vaidi kieetaiyaata vaidi yokovaiyaatama kava mminaree kiaa vioo tunoo: ");
INSERT INTO waj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Vaa na mminnamminnaa maisaivaa varaunoo. Vaidiivo hama mminnamminnaa maisaataivaa na ngii vitaakiaukai ngia ruputuaara iikiaanoo, tuduu rikiada tunoo: Mo datainnee? Hama ii mmoori ivo tiiki vainoo. Aiki vainoo. Eenoo ivaara tuqinnama yaata utuanee, ");
INSERT INTO waj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","tuduu rikioo Yutaaso nuunaira nnau pinaivaki sikaudaa kagaari sereguatiima kioo vioo yeenaivaa varoo mmaana haara kioo vainno putiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ivo vuu saivaata vaidi Anutuuqaara kati puara hudeera kieetaiya sikauyauvaa poropaarooma varada tunoo: Aa sikau aayauvo vaidiivaa ruputuaavo irisai putiivaara vai sikauyauvaivee. Ta aayauvaa nuunaira nnau pinaivaa sikau nnaamuruuvaki yapaaraivaara ti mmaanna tuu kuaivo ooqoo tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","kiaa kiada ivaara kuakuaakuaiyauvaa tida yeena rau kiada kookaraa sikauyauvaa varada mmataivaa hanuu kioo kuu yavaa iira vaidiivaa mmida inna mmata voovai varada ngiari vo yoosinnaiya numa varida putikiai ivaki hakuaaraivaara vareeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ivaara aanna makee gioonna kiaapu Isarairaiya kiaanoo: Kiauvo vau sikauvaadiri yookaama kieera mmatavaivee, kiaavai. ");
INSERT INTO waj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iya ivaa uuvaara nnaaruaa vaidi forofetaa Yirimiaava tuu kuaivo kaanairavai. Yirimiaava tunoo: Gioonna kiaapu Isarairaiya vaidiivaara mmataama kiada kagaari kioo sikauyauvo vo vaidivai yuku yaakuuvaa taika kioo vo vaidivai yaakuuvaitana vooya varada ");
INSERT INTO waj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","yavaa iira vaidiivaa mmida inna mmataivaa varaavai. Udaanga Anutuuqoono ivaara ni giaa ni mivaivee. Yirimiaava itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisuuva Roomaaya kieetaivaa avuuvau duoo vauduu ivo inna yaparainno tunoo: A Yutayaiya kieetakuannee? tuduu rikioo Yisuuva inna sai tunoo: Yo, inna kutaa kiannanoo, ");
INSERT INTO waj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","tuduu rikioo vaidi Anutuuqaara kati puara hudeera kieetaiyaata vaidi yokovaiyaatama kua pinaivaa innaki yapa kiooduu rikioo hama iya kua sai tirama kioo kua seemuaa variravai. ");
INSERT INTO waj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kua seemuaa varuduu Piratuuso inna tunoo: Aa kua mmuakiaa aayauvaa aiki yapaiyauvaa vaa a rikiaannannee? ");
INSERT INTO waj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","tuduu rikioo Yisuuva hama inna kua voovai sai tuduu rikioo Piratuuso ivaara pinaama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vo nuanu vo nuanu buusaivaa nnutuuvo Varaigiataivaa nneera suaivaki oovi nnauvaki varuu vaidi voovaara gioonna kiaapuuya inna yapara ruuvaa Roomaaya kieetaivo mmaanai titooduu tuoo viravai. ");
INSERT INTO waj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ii suai ivaki vaidi voovai nnutuuvo Paravaaso pinaa mmoori maisaivaa uuvaara oovi nnauvaki hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hara kioo varuduu kaayau gioonna kiaapuuya nuunaida varuduu Piratuuso iya yaparainno tunoo: Dee vaidivaara na sipuuvaa hatuaa kino tuoo ngiiisi kuanarannee? Vo Paravaasaannee? Vo Yusuunna Anutuuqo mmataama kioo vaidiivaannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kieeta vaidiiya Yisuunnanikaraama variaaree kiaa iya nnannatooduu kuminayaa Piratuusaasi inna vitada vida kua pinaana inna yapa kioovaa vaa Piratuuso rikieeravai. Vaa ivo ivaa rikioovaara itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ivo nnau pinaivaki gioonna kiaapuuya yaparaira mmaataivau homo hara kioo varuduu ari nnaataivo ngiaammuau voovai kuaivaa kiaa mmioo titaa kiooduu Piratuusaasi ngioo tunoo: I nnaataivo tinoo: Na heenaki vuru vaina ii vaidi ivaayaa ruvuaataivaa tauko ni maisainoo. Ivaara ii vaidi yoketaa ivaa sa vo aataru voovai inna iikianee, tiivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ivo itaa kua tuoo varuduu vaidi Anutuuqaara kati puara hudeera kieetaiyaata vaidi yokovaiyaatama gioonna kiaapu nuunauya yaagueeqama tunoo: Piratuuso ngii yaparainai inna kiaa mmida kiatee: Paravaasaa mmaanai titano tuoo kuaivee. Tuoo vinai Yisuunna ruputuanee. Itaa kua kiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Roomaaya kieetaivo kava iya yaparainno tunoo: Taara vaidivaitana oovi nnauvaki variaivaitana fai dee vaidivaara na sipuuvaa hatuano tuoo ngiiisi kuanarannee? tuduu rikiada iya inna sai tunoo: Paravaasaani sipuuvaa hatuaanee, ");
INSERT INTO waj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","tuduu rikioo ivo iya sai tunoo: Yisuunna Anutuuqo mmataama kioo vaidivaivee ngia kiaivaara na aaniivai inna iikiaunnee? tuduu rikiada mmuakiaaya sai tunoo: A tinai iya yatari sagaivau inna haara kiaatee, ");
INSERT INTO waj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","tuduu rikioo Piratuuso iya avaiyauvaa sai tunoo: Mo datainnee? Aanii tomedavai ivo iivainnee? tuduu rikiada iya puaisakama aayanna tida tunoo: A tinai iya yatari sagaivau inna haara kiaatee, ");
INSERT INTO waj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","tuduu rikioo Piratuuso hama yopeema iya avaiyauvaa hatokoo iya kiisa suai rapuaara uuvaa too iya avuuyauvunu nnooriivaadiri ari yaakuuvaa fini kioo tunoo: Fai ivo putino hama inna kiauvaa irisaivo niiki vainaravai. Fai ngiingiiiki vainaravai. Ngiengieenoo iikiatee, ");
INSERT INTO waj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","tuduu rikiada mmuakiaaya inna sai tunoo: Kii ivo putino inna kiauvo mmaanai tiinaraivaa irisaivo tiikiaata ti nnaakaraiyakiaatama vakiaivee, ");
INSERT INTO waj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","tuduu rikioo Piratuuso tuduu Paravaasaa mmaanai titooduu tuoo iyasi vuduu Piratuuso ari ngiaammuauya Yisuunna mmuduu rikiada iya inna ripiima kiooduu rapira vaidiiya Yisuunna yatari sagaivau haara vitada viravai. ");
INSERT INTO waj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Piratuusaa rapira vaidiiya Yisuunna vitada ngiari kieetaivaa nnau pinaivaki vida ngiari seena rapira vaidi mmuakiaayaata tuduu nnida nuunaida inna avuuvau diravai. ");
INSERT INTO waj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dida vaida inna uyira rairaiyauvaa utu ranna kuasasaama kiada buruqa kookeevaa varada innayaa apu kiada ");
INSERT INTO waj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","yeena ooviiyauvaa varada hovekama kiada inna kieetaivau ruvuyu kiada kuasaa yauvaa varada inna yaaku yaadudaivau yapa kiooduu tu kioo vauduu inna yuku oyaivaki toorivu yau hara kiada innara rairavai. Innara raida tunoo: Gioonna kiaapu Yutayaiya kieetakuavee. Tupatupaa varianee, ");
INSERT INTO waj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","kiaa kiada innayaa kuaanuuvaa visida yauvaa ivo utuuvaa ravisi kiada ivaadiri utida inna kieetaivau rida variravai. ");
INSERT INTO waj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Rida varida innara raidada kiada buruqa kookeevaa utu rabara kiada ari uyira rairaiyauvaa kava inna uyu kiada vitada yatari sagaivau haara viravai. ");
INSERT INTO waj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Vida varuduu yoosinna Kureenaivakinnaa vaidi voovai nnutuuvo Simoono iya saidi nniravai. Nnuduu rikiada rapira vaidiiya inna yaakuuvaudiri utu raririima rada Yisuunna yatari sagaivaa apuoo kuaiveera inna tuduu varoo viravai. ");
INSERT INTO waj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Iya vuu yoosinnaivaa nnutuuvo Korokataa viravai. Korokataa nnutuuvaa oyaivo kieeta mmuyaivo ivaki vau yoosinnaivovee. ");
INSERT INTO waj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iya ivaki dida vaida vuaina suuyaivaata kapikarai nnooriivaatama Yisuunna mmuduu nnaa too pikieeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pikiooduu inna vitada inna uyira rairaiyauvaa rada yapa kiada yatari sagaivau haara kiada inna uyira rairaiyauvaa varaaree kiaa isareeda yaatareera mminnaiyauvaa rootu rootuuda varida yaatarooyaano mmuaavai mmuaavai inna uyira rairaiyauvaa vareeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Vara kiada ivaki Yisuunna puru variravai. ");
INSERT INTO waj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iya kua pinaivaa innaki yapa kioo kuaivaa yatari sagaivau fafaara reeda inna kieetainningiaa yapa kieeravai. Ii kua ivo vainno tunoo: Aanna Yisuuva Yutayaiya kieetaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Iya mmuara furai vaidiivaitana yatari sagaivaitanau haara kiada vuaivaa vitada Yisuunna yaaku yaadudainningiaa haara kiada vuaivaa vitada inna yaaku geedainningiaa haara kieeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Haara kiooduu gioonna kiaapu yatari saga oyaivau vida nnidaida varuuya Yisuunna reeri teeda vaida innara nniki rakaida rakanoo raaranoo tida ");
INSERT INTO waj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","inna tunoo: A nuunaira nnau pinaivaa havarata kiee kava taaravooma suaivaki heekaanaravee tunnaikuavee. Mo eenoo ai vitee yoketaivau yapaanee. A kutaa Anutuuqaa mmaapukuavee tiee yatari sagaivaudiri reemi ree tummuanee, ");
INSERT INTO waj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","tuduu rikiada vaidi Anutuuqaara kati puara hudeera kieetaiyaata kua mmaanna kiaa mmira vaidiiyaata vaidi yokovaiyaatama mmuaikaraama innara raida ");
INSERT INTO waj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","tunoo: Ivo ari vo gioonna kiaapuuya vitoo yoketaivau yapa kioo hama yopeema ari vitoo yoketaivau yapainoo. Ivo kutaa Isarairaiya kieetavaivee, kiaa kioo yatari sagaivaudiri reemi roo tiinai ta teeda innara kutaavaivee kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ivo Anutuuqaara yaagueeqainnonno ariiyara tinoo: Na Anutuuqaa Mmaapuvaivee, tiivai. Kii ta teekio fai Anutuuqo innara mmuduuya ruoo makee inna tino fai kati yoketaama varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","tuduu mmuara furai vaidiivaitana inna tasipama haara kioovaitanaatama mmuaikaraama Yisuunna rakanoo raaranoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Itaa kua tuduu suaivo ikianna tammauduu mmuakiaa mmatavai heenama kioo vaududuu suaivo hanigiooduu taikeeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Taika kiooduu Yisuuva puaisakama aayanna roo ari kuaivakidiri tunoo: Irai Irai rama savatanii, tiravai. Ii kua ivaa oyaivo ataa kua tunoo: Ni Anutuuqo, ni Anutuuqo, dataama vaikiai ni pikiaannannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yisuuva aayanna tuduu rikiada gioonna kiaapu vooya ivau duuya ivo aayanna tuuvaa rikiada tunoo: Ivo Irayaannara aayanna tinoo, ");
INSERT INTO waj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","tuduu rikioo vo vaidi voovoono akiairauduu seenoo vioo kapuka roosuu mminnaa voovai varoo kapikaroo nnoori ari vookarauvaa nnutuuvo vinikaivakidiri rabuuma kioo kuasaa hokobaivau kuru kioo varoo numa yatari saga oyaivaki dioo vainno reeri Yisuuva ivaa nnaiveera inna mminee kiaa rikiooduu ");
INSERT INTO waj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ari seenaiya tunoo: A ivau iinai ta teekio Irayaava tuma inna vitoo yoketaivau yapaanarannee? Vara hama inna vitoo yoketaivau yapaanarannee? ");
INSERT INTO waj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iya itaa kua tuduu Yisuuva kava puaisakama aayanna roo putiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Putuduu buruqa pinaivo nuunaira nnau pinaivaki hiruuvo mmutunnidiri kereetu varoo oyaivaki tuoo saivai sainai vuduu saivai sainai viravai. Vuduu mmataa kuaruuvo utuduu oorasauyauvo ruannasituuduu ");
INSERT INTO waj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Anutuuqo tuduu mmata nnauyauvo feesainno kooyaa vauduu Anutuuqaa gioonna kiaapu vaa putuu vooya kava diiteeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Diitooduu Yisuuva nnaagiai ari putuuvakidiri diitoo suaivaki iya mmata nnauyauvaa pikiada yoosinna Yerusareemaivaki vuduu kaayau gioonna kiaapuuya iya teeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yisuuva putuu suaivaki rapira vaidiiya kieetaivootama ari rapira ngiaammuau inna tasipooyaatama homo Yisuunnara puru varida mmataa kuaru pinaivo utuuvaa teeda ari vookara ari vookarau aataruuyauvo ivaki vauyauvaatama teeda kaayauma aatuuda tunoo: Aanna kutaa tuanaa Anutuuqaa Mmaapu tuanaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tuduu kaayau gioonnaiya Karirayaadiri Yisuunna nnaagiai nnida innara tuqinnooya ngieeradiri dida vaida rooru inna teeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Makataraa gioonna Mariaavaata Yakoopaya Yoosiipaya kaano Mariaavaatama Sevetainna nnaataivootama iya tasipama dida vaida ivaki rooru Yisuunna teeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Upisipisiinno varuduu rikioo yoosinnaivaa nnutuuvo Arimateyaa vaidi kaayau hoona suvuauvaa nnutuuvo Yoosiipo nniravai. Iva Yisuunna nnaagiai nuaira vaidivai variravai. ");
INSERT INTO waj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Varuuvo ivoono oro Piratuusaa Yisuunna nnabaivaara yaparairavai. Yaparauduu rikioo Piratuuso ari ngiaammuauya tuduu iya Yisuunna nnabaivaa varada Yoosiipaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mmuduu too varoo yoketaa buruqa poosaivaadiri rurauma kioo ");
INSERT INTO waj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","varoo oro ari sikau mmata nnau karaasaivaki yapa kieeravai. Ivo vaa ari mmaara mmata nnauvaa oora sikau oyaivaki hatata teerama kioovaki yapa kieeravai. Yapa kioo sikau pinaivaa feena roo keegiaivaki ramuunnaama kioo viravai. ");
INSERT INTO waj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Vuduu rikiada Makataraa gioonnaivo Mariaavaata ari ferengaivootama mmata nnauvaara hara kiada varida rootu teeravai. ");
INSERT INTO waj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Rootu teedada pikiada vida vauya patauduu Yutayaiya buusaivaa teerama kioo suaivo taika kiooduu vaidi Anutuuqaara kati puara hudeera kieetaiyaata vaidi Farisaiyaatama Piratuusaasi vida ");
INSERT INTO waj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tunoo: Yokeera-o, ta rikiaunnano Yisuuva unnakua nnaamuruuvo hama putira homo varuu suaivaki tunoo: Na putino taaravooma suaivo taikanai fai na keenaa diitaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","tuuvaara ai rapira ngiaammuauya tinai oro mmata nnauvaara taaravooma suai haitatuukiatee. Fai Yisuunna ngiaammuauya numa inna nnabaivaa hitu varada vida gioonna kiaapuuya kiaara: Vaa Anutuuqo tikio Yisuuva vaivakidiri diitoo kuaivaivee, kiaarainnoo. Fai iya itaama iikio nnaagiai iya gioonna kiaapuuya unnakua kiaaraivo tauraa unnakua kiaivaa yaataraanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","tuduu rikioo Piratuuso iya tunoo: Ngiengieenoo ngiaammuau rapira vooya vitada oro kiada sipuuvaa tuqinnama rau kikio yaagueeqama vakiaivee, ");
INSERT INTO waj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","tuduu rikiada vida ivaa keegiaivaki rummua apira sikauvau uuda raira fafaaraivaa raa kiada ngiari rapira ngiaammuauya tuduu iya ivaara haitatuuravai. ");
INSERT INTO waj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Vaidi Yutayaiya kati varira pinaa suaivo taika kiooduu rikiada Sudaaqaki suaivo reera kiooduu Makataraa gioonna Mariaavaata ari ferengaivootama Yisuunna mmata nnauvaa taara viravai. ");
INSERT INTO waj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vidada oro taaree tuduu makee tuduu rikioo mmataa kuaru pinaivo utuduu rikioo Udaanga Anutuuqaa aangeraa voovoono ngiau aapuuvakidiri tioo oro sikauvaa keegiaivaki rau kioovaa feena kioo ivau karoo hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Varuduu inna oori nnikiivo hanigioo saneetu roosiima ruvuaahooduu inna buruqaivo poosa kuainno nama toroomunnaivaa roosiiravai. ");
INSERT INTO waj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Itauduu rikiada vaidi mmata nnauvaara haitatuuraiya innara aatuuda biribiriida mmatayaa vida varada vaidi putuuya roosiima vairavai. ");
INSERT INTO waj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vauduu rikioo aangeraivoono gioonnaivaitanaata kua tioo tunoo: Sa aatuukiatee. Vaa na rikiaunoo. Ngia Yisuunna vaidiiya yatari sagaivau haara kiooduu putuuvaaraida buaama rada nookiaanoo. ");
INSERT INTO waj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hama aavaki vainoo. Vaa diitaivai. Vaa ivo ivaara ngii giaa ngii miravai. Ivo vaivaki numa taatee. ");
INSERT INTO waj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Teeda akiairaama oro ari ngiaammuauya kiaa mmida kiatee: Vaa ivo putiivakidiri diitoo ngii tauraa Karirayaa kuanara vioo varinoo. Ngia oro ivaki inna taaravaivee, kiatee. Inna aikioovai, vaa na ni kuaivaa ngii giaa ngii miaunoo, ");
INSERT INTO waj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","tuduu rikiada akiairauduu mmata nnauvakidiri pikiada aatuuda kaayauma sirigama rada seenada Yisuunna ngiaammuauya kiaa mmiaara nniravai. ");
INSERT INTO waj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nnida varuduu Yisuuva innidanaa saidi numa tunoo: Ngia deepi kuaaraida kuaannee? tuduu rikiada numa inna yukuuvaitanau utu kiada vaida ngiari ausa mmuduuyaivaitana inna mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mmuduu rikioo Yisuuva innidanaa tunoo: Sa aatuukiatee. Ni ngiaammuauya Karirayaa kuateera oro kiaa mmiatee. Fai iya ivaki vida ni taaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tuduu rikiada gioonnaivaitana ngiari rikioo aataruuvau nnida varuduu Yisuunna mmata nnauvaa haitatuura rapira ngiaammuau vooyaano ngiari toovaara nnida yoosinnaivaki vaidi Anutuuqaara kati puara hudeera kieetaiya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kiaa mmuduu rikiada iyaata vaidi yokovaiyaatama nuunaida kuakuaakuaiyauvaa tida kuaivaa yeena rau kiada kaayau sikauyauvaa rapira ngiaammuauya mmida ");
INSERT INTO waj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tunoo: Gioonna kiaapuuya ataa kua kiaa mmiatee: Heenaikiai ta vuru vaida variaunnani Yisuunna ngiaammuauya inna nnabaivaa numa varada kuaavaivee, kiaa mmiatee. ");
INSERT INTO waj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Fai ngia itaa kua tikio ngii kieetaivo ngii kuaivaa rikianai fai ta ngiiiyara innaata kua tikio rikioo hama ivo ngiiiyara nnannataanaravee, ");
INSERT INTO waj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","tuduu rikiada rapira ngiaammuauya ngiari sikauyauvaa varada iya tuu kuaivaa mmuakiaa gioonna kiaapuuya kiaa mmiravai. Aa ta variaunna suai aavaki homo gioonna kiaapu Yutayaiya ii kua ivaa tida variaanoo. ");
INSERT INTO waj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yisuunna ngiaammuau yaakuuvaitana yukukidiri mmuaavai yoosinna Karirayaa vidada oro taapi tauraa Yisuuva iya kiaa mmuuvau diravai. ");
INSERT INTO waj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dida vaida tooduu Yisuuva iya too vauduu teeda ngiari ausa mmuduuyaiyauvaa inna mmiravai. Mmuduu teeda vooyaano taara yaata utida tunoo: Vo kutaa Yisuuvannee? Vo hama Yisuuvannee? Iya itaama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yisuuva numa mmuakiaaya iya tunoo: Anutuuqo mmuakiaa ngiau mmata mmooriivaara dira yaagueeqaivaa vaa ni mivaivee. ");
INSERT INTO waj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ivaaraida ngia mmuakiaa yoosinna variaa gioonna kiaapuuya tuqinnama ni kuaivaa kiaa mmikiai rikiada iya ni nnaagiai ngiaaravaivee. Fai ni nnaagiai nnikiai ngia iya nnoori apida ni Napoonna nnutuuvaata ni nnutuuvaatama Mmannasa Yoketaivaa nnutuuvaatama tida iya apuatee. ");
INSERT INTO waj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na kuaivaa ngii giaa ngii miauvaa iya iikiateeraivaara tuqinnama iya kiaa mmiatee. Neenoo ngii tasipama tupatupaa varieenana ngiau mmata taikeera suaivaki homo fai na ngii tasipama varinaravaivee. Ivaara yaata utuatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aa Mmayaaya Yoketaa aavo Anutuuqaa Mmaapu Yisuu Kirisiinnara toosa hara tira mmayaayavai. ");
INSERT INTO waj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ii mmayaaya ivaa nnaaruaa vaidi forofetaa Yisayaava fafaara reeravai. Yisayaava Anutuuqo ari Mmaapuuvaara tuu kuaivaa fafaara roo tunoo: Na titauko nnii vaidiivo aa nninoo. Fai na i tauraivaannaadee titano vioo aataruuvaa aini teerama kiaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Fai ivoono koo mmuyai gaanga voovau dioo vainno aayanna roo tinara: Ngia ngii kieetaivaara aataruuvaa teerairaivaa roosiima ngii Udaangaivaara teerama kiaatee. Udaangaivo ngiiisi nninaraivaara teeraida safuuma kiaatee. Yisayaavaano fafaara roo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yisayaava fafaara roo kuaivo Yuvuaano nnoori apira vaidiivo uuvaudiri kaanaivo vairavai. Ivo numa koo mmuyai gaanga voovau dioo vainno Anutuuqaa mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmioo tunoo: Ngia ngiingii mminnamminnaa maisaiyauvaa mmooka hanigia mmida pikikiai na nnooriivaadiri ngii apino Anutuuqo ngii mminnamminnaa maisaiyauvaa rugaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","tuduu mmuakiaa gioonna kiaapuuya Yerusareemaiyaata vo yoosinna vo yoosinna Yutayaivaki vau yoosinnaiyaatama Yuvuaanaasi vida ngiari mminnamminnaa maisaiyauvaa Anutuuqaa kiaa kookieema kiooduu nnoori Yorotaanaivakidiri Yuvuaano iya nnoori apiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yuvuaano puara kamera yaasiivaadiri yaapaivaa roosi iima kioo uyu kioo nnabaivaadiri vausa roosi iima kioo ari tammaivaki rau kioo kaisaivaa nnoo ngengengoongaivaa suuyaivaa nneeravai. ");
INSERT INTO waj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ivoono gioonna kiaapuuya kiaa mmioo tunoo: Vaidi ni nnaagiai nninaraivo nnoonna vaidivai. Na kiisa vaidivai. Hama na yopeema mmoori vareera ngiaammuauvai roosiima variee inna yuku nnabaivaitana yeenaivaitana rakuasaa kiee utu radaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na kati mmanna nnooriivaadiri ngii apuaunoo. Ivoono ni yaataraivoono Anutuuqaa Mmannasa Yoketaivaa tino too ngii aakiaana varinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ii suai ivaki Yisuuva Karirayaa vau yoosinna kiisa Nasareetadiri pikioo Yuvuaanaasi ngioo nnoori Yorotaana ivaki oro duduu Yuvuaano inna apiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Inna apu kiooduu Yisuuva nnooriivakidiri numa siriivau duu saivaata reeri tooduu ngiauvo rusiti varoo vioo sai ngioo sauduu Mmannasa Yoketaivo ngiaamma mirunnaivaa roosuuvoono tuoo tuoo innayaa variravai. ");
INSERT INTO waj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Innayaa varuduu rikiooduu ngiau aapuuvakidiri Anutuuqaa kuaivo tuoo tunoo: Na aiyara mmuduuya ruee na i tauko pinaama ni yoketainoo. A ni Maapu tuanaakuavee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tuduu tuu saivaata Mmannasa Yoketaivo yaagueeqama Yisuunna titooduu koo mmuyai gaanga voovaura viravai. ");
INSERT INTO waj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Oro hara kioo varuduu taara vaidivaitana yuku yaaku taika kioo suaiyauvaa ivaki varuduu ivo muaraagakiaiveera Sataango numa inna iinno teeravai. Ii yoosinna ivaki fayai mmararaa avaikarauya suvuauduu aangeraiya tuma Yisuunna tuqinnada haitatuuravai. ");
INSERT INTO waj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Vaidiiya Yuvuaanaa oovi nnauvaki yapa kiooduu ivaki varuduu Yisuuva Karirayaa vioo Anutuuqaa mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmioo ");
INSERT INTO waj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","tunoo: Anutuuqo mmataama kioo suaivo aa vainima nninoo. Anutuuqo gioonna kiaapuuyara dira suaivo kiisa suai nninaravai. Ngiingii mminnamminnaa maisaiyauvaa pikiada hanigiada mmayaaya yoketaivaara kua kutaavaivee kiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yisuuva nnaagiai nnoori haruunga Karirayaa siriivau vioo tooduu tavau vareera vaidiivaitana Simoono ari kataivo Adiriaasooyarii inna teeda vaida tavaura nnooriivaki ngiari utua vaaheeyauvaa kagaari kiada tu kiada vauduu ");
INSERT INTO waj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yisuuva ivaitana tunoo: Ngia ni nnaagiai nnikiai na ni kuaivaa ngii giaa ngii minai ngia tavau vareerayaama gioonna kiaapuuya vitada niisi ngiatee, ");
INSERT INTO waj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","tuduu rikiada makee tuduu ivaitana ngiari utua vaaheeyauvaa pikiada inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Vida Yisuuva vioo tooduu Sevetainna mmaapuuvaitana Yakoopaya Yuvuaanaya ngiari kanuuvaki varida ngiari utua vaaheeyauvaa sapiraida variravai. ");
INSERT INTO waj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sapiraida varuduu Yisuuva ivaitana too suaivaki ni nnaagiai ngiateera ivaitanaara tuduu ngiari gioonnaata ngiari mmoori varoo vaidiiyaatama kanuuvaki pikiada inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iya vidada yoosinna Kapanauma oro varuduu Yutayaiya kati varira suaivo nnuduu Yisuuva nuunaira nnauvaki vioo gioonna kiaapuuya Anutuuqaa mmayaayaivaa kiaa mmuduu rikiada ");
INSERT INTO waj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","inna kuaivaa rikiooya iva tuu kuaivaara kaayauma nnikiarairavai. Hama iva Anutuuqaa kua mmaanna kiaa mmiraiya roosiima tirainno ari vookarau yaagueeqaivo inna tasipooduu kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ii suai ivaki vaidiivaa aakiaivaki mmagia maisaivo topauvo nuunaira nnauvaki ngioo kai tuoo ");
INSERT INTO waj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","mmagia maisaivo inna kiaa mmuu kuaivaa tunoo: Yisuu-o, Nasareetaa vaidikuavee. E aaniivai ti iinarainna ngiannannee? A ti ruputu taikaanara ngiannannee? Vaa na i tauvai. A Anutuuqaa vaidi yoketaa tuanaakuavee, ");
INSERT INTO waj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","tuduu rikioo Yisuuva yaagueeqama mmagia maisaivaa tunoo: Sa kua tirainna vaidiivaa aakiaivakidiri tiee kuanee, ");
INSERT INTO waj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","tuduu rikioo mmagia maisaivo vaidiivaa aakiaivakidiri tuoo kuanara uuduu ivo pinaama yuku yaaku hannatotauduu mmagia maisaivo inna aakiaivakidiri kaayauma kai kai tuoo mmaanai tuoo viravai. ");
INSERT INTO waj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tuoo vuduu rikiada mmuakiaa gioonna kiaapuuya nnikiaraida ngiari yapara ngiari yaparaida tunoo: Inna aaniivainnee? Inna karaasa kuavainno tiinnee? Aa vaidi aavo yaagueeqa vaidivai kieeta vaidiaano tirayaama mmagia maisaiyauvaa yaagueeqama tikiai kuaanoo, ");
INSERT INTO waj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","tuduu rikiada Yisuuva uu mmooriiyauvaa gioonna kiaapuuya teeda vida mmuakiaa Karirayaa vau yoosinnaiyauvaki varuuya kiaa mmuduu rikieeravaivee. ");
INSERT INTO waj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yisuuvaata ari ngiaammuaudootama Yakoopaya Yuvuaanaya tasipama nuunaira nnauvaki pikiada Simoonaya Adiriaasaya nnauvaki safuuma viravai. ");
INSERT INTO waj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Vida tooduu Simoonaa nnummuayaanna nniitarooduu ikiayanaa tooduu mmaatayaa nnaasu vauduu innara Yisuunna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Inna kiaa mmuduu rikioo innasi vioo inna yaakuuvaudiri vararu utuduu diitooduu ikiayanaivo taika kiooduu yeennaivaa iya mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hannauduu suaivo haatapooduu rikiada gioonna kiaapu vooyaano ngiari seena gioonna kiaapu nniitarooyaatama vooya aakiaiyauvaki mmagia maisaiyauvo varuuyaatama vitada Yisuunnasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mmuakiaa gioonna kiaapu yoosinna varuuya nnidada nuunaida nnau keegiaivaki dida vauduu ");
INSERT INTO waj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yisuuva kaayau nniitaroo ari vookara ari vookarauya tuqinnoo kaayau mmagia maisaiya vooya aakiaiyauvaki varuuya tuduu pikiada viravai. Mmagia maisaiya Yisuunna arinaima toovaara iya kua tivoora Yisuuva iya ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Heenanaanna upisi saivaata Yisuuva diitoo nnauvaa pikioo yoosinnaivaata pikioo oro kumina mmata voovau varioo yaaku vareeravai. ");
INSERT INTO waj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Yaaku varoo varuduu Simoono ari saiyaatama diitada vida innara buaama rada nuaida tooduu ");
INSERT INTO waj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","iva iya too vauduu teeda inna tunoo: Mmuakiaaya aiyara buaama rada nookiaanoo, ");
INSERT INTO waj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","tuduu rikioo Yisuuva iya sai tunoo: Pikiada nnikiai ta aa yoosinna vaini vai aayauvaki kuaaravee. Anutuuqaa mmayaaya yoketaivaa iyaatama fai na kiaa mminaraivaara kuaaravee. Na iyaatama kiaa mminaraivaara tiiravaivee, ");
INSERT INTO waj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","kiaa kioo ivaki pikioo mmuakiaa yoosinnaiyauvo Karirayaa vauyauvaki vioo ngiari nuunaira nnauyauvaki Anutuuqaa mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmioo mmagia maisaiyauvaa tuduu iyakidiri tiida viravai. ");
INSERT INTO waj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Vaidi voovai mmammaivo buunna hooya mmamma roosuuvoono Yisuunnasi numa toorivu yau haroo yaagueeqama inna yaparainno tunoo: A ni mmammaivaa tuqinnaanaree tiee aikiooma tuqinnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","tuduu rikioo Yisuuva pinaama innara boo tioo ari yaakuuvaa reeti innayaa utuoo tunoo: Fai na i tuqinnaanaravai. Na tino i mmammaivo yoketaakiaivee, ");
INSERT INTO waj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","tuduu tuu saivaata buunna hooya mmamma roosuuvo taikooduu kati hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kati hara kioo varuduu Yisuuva kua yaagueeqama innaata tuoo akiairauduu inna titoo ");
INSERT INTO waj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","tunoo: Sa viee aavaara gioonna kiaapu voovai kiaa mmianee. Akiairaama Anutuuqaara kati puara hudeera vaidiivaa ai mmammaivaa inna vitaakianee. I mmammaivo yoketaivaara nnaaruaa vaidi Musiiva tuuvaugiataama puara sipisiipaivaa kati ruputu kiee Anutuuqaara hudaanee. Hudanai rikiada gioonna kiaapuuya i mmammaivo yoketaivaara arinaima teeda rikiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","tuduu rikioo hama inna kuaivaa rikioo pikioo vioo gioonna kiaapuuya mmannammanna kiaa mmiravai. Kiaa mmuuvaara iya inna suvuaivoora kiaa Yisuuva hama yoosinnaivaki kooyaa nuairavai. Ivo oro koo mmuyai gaanga yoosinnaiyauvaki hara kioo varuduu gioonna kiaapuuya vo yoosinna vo yoosinnaiyauvakidiri innasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Vo suai voovaki Yisuuva kava vara ranoo yoosinna Kapanauma vuduu ari nnauvaki varuu kuaivaa kaayau gioonna kiaapuuya rikiada ");
INSERT INTO waj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","innasi nnida nuunaida nnauvaa suvuai kiada sipu oyaivakiaata nnau oyaivakiaatama suvuai kiooduu Yisuuva mmayaaya yoketaivaa iya kiaa mmiravai. Iya kiaa mmioo varuduu ");
INSERT INTO waj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","vaidi vooyaano vaidi voovai yuku yaaku putuuvaa taarama taaramadoono taina rau varada Yisuunnasi nniravai. Nnida tooduu gioonna kiaapuuya suvuai kiada varuduu hama inna varada Yisuunnasi ngiaara aataruuvootairavai. ");
INSERT INTO waj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hama aataruuvootauduu iya Yisuuva duupinnainningiaa ngiau aapu karada tausiivaa rabara kiada hiriraiyauvaa ravarata kiada idaadiri yuku yaaku putuu vaidiivo ari kegeennaivau vauvaa Yisuunnasi reemma kiooduu tiiravai. ");
INSERT INTO waj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tuuduu rikioo iya ngiari yaata tinniiyauvaki vau kuaivaa Yisuunnara tunoo: Ivo aikiooma tuqinnaanaravaivee, tuu kuaivaa Yisuuva rikioo vaidi yuku yaaku putuuvaa tunoo: Boo, ni vaidivai, vaa na kiauko i mminnamminnaa maisaiyauvo taikainoo, ");
INSERT INTO waj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","tuduu rikiada kua mmaanna kiaa mmira vaidi ivaki varuuya ngiari yaata tinniyaa vau kuaivaa yaata utida tunoo: ");
INSERT INTO waj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Mo dataama kioonno aa vaidi aavoono ariiyara yaata utuoo Anutuuqaa roosiima kua tiinnee? Hama vaidi voovoono yopeema vaidiiya mminnamminnaa maisaiyauvaa rugaivaivee. Anutuuqo mmuaavoono vaidiiya mminnamminnaa maisaiyauvaa rugeeraivovee, ");
INSERT INTO waj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","tuduu rikioo Yisuuva akiairauduu iya yaata tinniyaa vau kuaivaa arinaima rikioo iya tunoo: Ngia aaniiraida ngii yaata tinniyaa vai kuaivaa yaata utida itaa kua kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na tinara kuaivo dee kuavainno yoketainnee? Vara dee kuavainno ari vookarainnee? Fai na tinara: Vaa na kiauko i mminnamminnaa maisaiyauvo taikainoo, tinarannee? Vara na tinara: Diitee ai kegeennaivaa varee kuanee, tinarannee? ");
INSERT INTO waj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aa mmata aavau Na Vaidiivaa Mmaapuuvoono vaidiiya mminnamminnaa maisaiyauvaa rugeeraivaa nakaaraivovee. Fai na iinai ngia ivaa taaravaivee, kiaa kioo vaidi yuku yaaku putuuvaa tunoo: ");
INSERT INTO waj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Na i kiaa i mmiaunoo. Diitee ai kegeennaivaata varee ai nnauki kuanee, ");
INSERT INTO waj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","tuduu rikiada gioonna kiaapuuya teeda vauduu ivo diitoo akiairauduu ari kegeennaivaata varoo viravai. Vuduu iya pinaama nnikiaraida Anutuuqaara kua yoketaivaa tida tunoo: Hama ta aqaa mmoori aavaa tauraa taunnavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yisuuva kava nnoori haruunga Karirayaa siriivau tioo tioo tuma tooduu gioonna kiaapu kaayauya innasi nnida nuunauduu iva kua yoketaivaa iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kua kiaa mmi taika kioo kava vara ranoo Kapanauma vioo tooduu Arapainna mmaapuuvo Riviiva ari sikau takiisa vareera nnauvaki hara kioo varuduu Yisuuva inna too tunoo: Ni nnaagiai ngianee, tuduu rikioo diitoo inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Oro varioo Yisuuva Riviinna nnauvaki yeenna nnoo varuduu kaayau mmaanna tuu kuaivaa hatokeera gioonna kiaapu maisa vooyaatama kaayau sikau takiisa vareera vaidi maisa vooyaatama numa innaata ari ngiaammuauyaatama tasipama yeenna nneeravai. Kaayau gioonna kiaapu mmuaakaraakiaiya Yisuunna nnaagiai nuairaivaara ii gioonna kiaapu iya Yisuunnaata ari ngiaammuauyaatama tasipama yeenna nneeravai. ");
INSERT INTO waj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farisai vaidiiyakidiri Anutuuqaa kua mmaanna kiaa mmira vaidi vooyaano Yisuuva mmaanna tuu kuaivaa hatokeera gioonna kiaapu maisaiyaata sikau takiisa vareera vaidi maisaiyaatama yeenna nneeda varuuvaa teeda Yisuunna ngiaammuauya yaparaida tunoo: Mo aaniira ivo sikau takiisa vareera vaidi maisaiyaata gioonna kiaapu mminnamminnaa maisa suvuaiyaatama iya tasipama yeenna nnooriivaa nnainnee? ");
INSERT INTO waj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","tuduu rikioo Yisuuva iya kuaivaa rikioo iya sai tunoo: Gioonna kiaapu homoraiya hama kuminayaa nniitareeraiya tuqinneera vaidiivaasi kuaavai. Gioonna kiaapu nniitareeraiya nnaasu innasi kuaavai. Na hama gioonna kiaapu yoketaama variaiya maavee tinaraivaara tiiravai. Gioonna kiaapuuya mminnamminnaa maisa suvuaiya na maavee tinaraivaara tiiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Vo suai voovaki Yuvuaanaa nnaagiai nuairaiyaata vaidi Farisaiyaatama Anutuuqaara yaata utida ngiari yeenna nneeraivaara ooqoo kiaa kiada kati varuduu gioonna kiaapuuya numa Yisuunna yaparaida tunoo: Mo dataikiaida vaidi Yuvuaanaa nnaagiai nuairaiyaata vaidi Farisaiya nnaagiai nuairaiyaatama Anutuuqaara yaata utida ngiari yeenna nneeraivaara ooqoo kiaa kiada kati variaani i nnaagiai nuairaiya hama itaa kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","tuduu rikioo Yisuuva mmataira kuaivaa iya sai tunoo: Yaapeeri nneera suaivaki kieevatiivo gioonna kiaapuuya tasipama varikiai rikiada hama iya yeenna nneeraivaara ooqoo kiaaravai. Fai nnaaravai. Kieevatiivo iya tasipama varii suaivaki hama iya yopeema yeenna nneeraivaara ooqoo kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Fai suai voovai nninai rikiada vaidiiya kieevatiivaa vitada ruputikiai ii suai iyauvaki iya yeenna nneeraivaara ooqoo kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hama gioonna kiaapu voovoono nnisi buruqa tapasiivaki karaasa buruqa kiisaivaa hatoka funnivai. Fai funnu kioo nnooriivakidiri fini kino karaasa buruqaivo yaagueeqainno fai buruqa nnisiivaa utu rapasi kino rikioo pinaama tapasinaravai. ");
INSERT INTO waj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hama vaidi voovoono vuaina suuya karaasaivaa puara nnaba funnu kiaa nnisiivaki tusaa uyivai. Fai tusaa uyu kino yapooma vuaina suuyaivo vainno yootano puara nnaba nnisiivo rusitinaravai. Rusitino rikioo vuaina suuyaivo tuoo vino puara nnabaivo maisainaravai. Iya karaasa vuaina suuyaivaa puara nnaba karaasaivaki tusaa uyuaavaivee, tiravai. Yisuuva nnisi aataruuvoota karaasa aataruuvootama hama yoketaama mmuaavau vauvaara itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yutayaiya kati varira suai voovaki Yisuuva ari ngiaammuauyaatama yeennaivaa nnutuuvo vuiita mmooriivaki nuairavai. Iya nuaida varida inna ngiaammuauya vuiita iiraiyauvaa utu rasukua rada nuairavai. ");
INSERT INTO waj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nuauduu Farisaiyaano iya teeda Yisuunna tunoo: Taanee. Ta kati varira suaivaki ti mmaanna tira kuaivo ooqoo tiraivaa aanii kieemaida i ngiaammuauya hatokaannee? ");
INSERT INTO waj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","tuduu rikioo ivo iya sai tunoo: Ngia Davuitiinna mmayaayaivo yanaivau vaivaa yaarida hama tuqinnama rikiaavai. Nnaaruaa vaidi Davuitiivaata ari tasipama nuauyaatama kaayauma iya yeenna rauduu rikioo hama yeennaatauduu ");
INSERT INTO waj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ivo Anutuuqaara nuunaira nnauvaki vioo yeenna bereeta Anutuuqaaniee kiaa yapoo yeennaiyauvaa varoo nneeravai. Ti mmaanna tuu kua aataruuvo vainno tunoo: Anutuuqaara kati puara hudeeraiyaano nnaasu Anutuuqaaniee kiaa yapoo yeenna bereetaiyauvaa nnaatee, tuduaata ii suai ivaki Anutuuqaara kati puara hudeera kieeta tuanaivaa nnutuuvo Apiaitaava varuu suaivaki Davuitiiva ii kua ivaa hatoka kioo numa yeennaiyauvaa varoo nnoo ari tasipama nuauyaatama mmioo nnooduu hama Anutuuqo ooqoo tiravai, ");
INSERT INTO waj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","kiaa kioo tunoo: Hama Anutuuqo Yutayaiya kati varira suaivaa aataruuvaa iikiateera nnaasu gioonna kiaapuuya yapa kieeravai. Ivo gioonna kiaapuuya iima kioo iyara yaata utuoo kati varira suaivaa iyani yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na Vaidiivaa Mmaapuuvoono kati varira suaivaa nakaaraivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yisuuva kava vara ranoo nuunaira nnauvakira vioo tooduu vaidi voovai yaaku saivai sorogainno taminnumaunnuunno vuuvo ivaki variravai. ");
INSERT INTO waj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Varuduu gioonna kiaapu vooya ivaki varuuya yaata utida tunoo: Yisuuva kati varira suaivaki inna tuqinnaanarannee? kiaa inna puaisakama teeda vairavai. Ivo koonnama iinai rikiada kua pinaivaa innaki yapaaraivaara inna puaisakama teeda vairavai. ");
INSERT INTO waj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iya inna teeda vauduu Yisuuva vaidi yaaku sorogauvaa tunoo: Diitee numa aavau dianee, ");
INSERT INTO waj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","kiaa kioo gioonna kiaapuuya yaparainno tunoo: Ta kati varira suaivaki dee mmoorivai iikiaarannee? Ti mmaanna tira kuaivo dataa kuainno tiinnee? Vara ta yoketaa mmooriivaa iikiaarannee? Vara maisa mmooriivaa iikiaarannee? Vara vaidi nniitaraivaa tuqinnaarannee? Vara vaidiivaa ruputu kikio putinarannee? tuduu rikiada kua seemuaa variravai. ");
INSERT INTO waj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kua seemuaa varuduu Yisuuva iyara inna nnannatooduu iya haitatuuma too iyara inna nnannatooduaata iyara boo tiravai. Ngiari tinni nnikiiyauvo yaagueeqauvaara ivo iyara boo tiravai. Yisuuva vaidi yaaku sorogauvaa tunoo: Ai yaaku sorogainno taminnumaunnuuvaa raduda utuanee, tuduu rikioo ari yaakuuvaa raduda utuduu yoketairavai. ");
INSERT INTO waj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yoketauduu Farisaiya ivaa teeda akiairauduu nuunaira nnauvaki pikiada kieeta vaidi Herootaa nnaagiai nuairaiyaatama nuunaida Yisuunna ruputuaara inna mmaara kuaivaa kiaa teerama kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yisuuva ari ngiaammuauyaatama ivaki pikiada nnoori haruunga Karirayaa vida kiooduu kaayau gioonna kiaapuuya iya nnaagiai viravai. Gioonna kiaapuuya Karirayaivakidiriaata Yutayaivakidiriaatama ");
INSERT INTO waj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusareemaivakidiriaata Irumaivakidiriaatama nnoori Yorotaana sainai varuuvakidiriaata yoosinnaivaitana Turu Sitoona vainima varuuvakidiriaatama viravai. Yisuuva mmooriivaa uu kuaivaa rikioovaara iya inna nnaagiai innasi viravai. ");
INSERT INTO waj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Vida varuduu Yisuuva ari ngiaammuauya tunoo: Gioonna kiaapuuya ni suvuakuaarainnoo. Kanuuvaa varada niini teerakiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yisuuva kaayau nniitarooya tuqinnoovaara gioonna kiaapu nniitareeraiya innayaa utuaara inna suvuairavai. ");
INSERT INTO waj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mmuakiaa suai gioonna kiaapu mmagia maisaiya iya aakiaana varuuya inna teeda vida varada inna yuku oyaivaki toorivu yau harada mmagia maisaiya iya kiaa mmuu kuaivaa aayanna tida tunoo: E Anutuuqaa Mmaapu tuanaakuavee, ");
INSERT INTO waj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","tuduu Yisuuva yaagueeqama iya kiaa mmioo tunoo: Sa niiyara kiaa kookieekiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yisuuva taapiivaura vioo ari vitaanaree tuu ngiaammuauya innasi ngiateera tuduu innasi nnuduu ");
INSERT INTO waj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","yaakuuvaitana yukukidiri taarama mmataama kioo iya tunoo: Ni tasipama nookiaaraivaara na ngii mmataama kiaunoo. Ngia Anutuuqaa kua yoketaivaa gioonna kiaapuuya kiaa mmiaaraivaara na ngii titanai kuatee. ");
INSERT INTO waj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Fai ngia vikiai gioonna kiaapuuyakidiri mmagia maisaiya titakiai kuateera yaagueeqaivaa na ngii minai kuaaravee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yaakuuvaitana yukukidiri taarama ngiaammuauya ivo mmataama kiooya nnutuuyauvo ataama vainoo. Voovai nnutuuvo Simoono Yisuuvaano innara nnutu karaasaivaa Petorooso tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Voovaitana Sevetainna mmaapu kato vayoovaitana Yakoopaya Yuvuaanayara Yisuuva karaasa nnutuuvaa Buainakiiso ivaitanaara tiravai. Nnutu Buainakiisa oyaivo ngiaarunna akuavai. Ngiaarunno akua karara tuneema taaravaitana kuaivaa karara tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Voovai nnutuuvo Adiriaaso voovai nnutuuvo Piriipo voovai nnutuuvo Batoromaiva voovai nnutuuvo Mataiva voovai nnutuuvo Tumaaso voovai Arapainna mmaapuuvaa nnutuuvo Yakoopo voovai nnutuuvo Tariaaso vaidi vooya inna mmataivaa varoovaara kaayauma rapira vaidiivaa nnutuuvo Simoono ");
INSERT INTO waj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","voovai nnutuuvo Yutaaso Isariootovee. Ivoono nnaagiai Yisuunna nnammutuaiya fai kooyaa inna vitainaraivaara kua yeena rau kieera vaidivai. ");
INSERT INTO waj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yisuuva ari varuu nnauvaki oro ivaki varioo tooduu innaata ari ngiaammuauyaatama gioonna kiaapuuya keenaa suvuai kiooduu hama ngiari yeenna nnaara suaivootairavai. ");
INSERT INTO waj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hama ngiari yeenna nnaara suaivootauduu Yisuunna seenaiya gioonna kiaapuuya itaama inna uuvaa rikiada inna vitaara nniravai. Vooyaano innara tunoo: Vaa ivo yaata duunaivaivee, tuuvaara inna vitaara nniravai. ");
INSERT INTO waj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vaidi vooya Anutuuqaa kua mmaanna kiaa mmiraiya Yerusareemadiri nnuuyaano innara tunoo: Mmagia maisaiya kieetaivaa Sataangaa nnutu voovai Beresebuuro inna aakiaivaki varinoo. Variivoono ari yaagueeqaivaadiri mmagia maisaiya vaidiiya aakiaiyauvaki variaiya titaikiai kuaavaivee, ");
INSERT INTO waj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","tuduu rikioo Yisuuva gioonna kiaapuuya tuduu innasi nnuduu mmatayaa diaa mminnaiyauvunudiri mmataama kioo kua voovai iya kiaa mmioo tunoo: Mo dataama Sataango ari seena mmagia maisaiya titanai kuaarannee? Hama yopeemavee. ");
INSERT INTO waj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Fai gioonna kiaapuuya mmuaa mmatavau variaiya rapidada ivaudiri raubiriida mmarammaraama varida hama yopeema mmuaavau yaagueeqama varirama kiada fai taikaaravai. ");
INSERT INTO waj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Fai gioonna kiaapu mmuaa nnauvaki variaiya rapidada vida raubiriida mmarammaraa varida hama mmuaavau yaagueeqama varirama kiada fai muaraagakiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Itaama vainai fai Sataangoota ari seena mmagia maisaiyaatama rapuoonnonno kinai fai mmarammaraa varida hama mmuaavau yaagueeqama varirama kiada fai taikaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ivo itaa kua kiaa kioo Sataangaara kava vo kuavai mmataama kioo tunoo: Fai vaidi voovoono yaagueeqa vaidiivaa nnauvaki vioo inna hoonaiyauvaa ariiyara varaanaree kiaa kioo hama sabi kuanaravai. Fai tauraa vaidi yaagueeqaivaa yuku yaakuuvaa yeenaadiri ranaa rau kioo vioo inna nnauvakidiri inna hoonahaanaiyauvaa varaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Na kua kutaavai ngii giaa ngii miaunoo. Fai vaidiiya mminnamminnaa maisa mmuakiaayauvaatama mmuakiaa maisa kua kiaiyauvaatama fai Anutuuqoono rugaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Fai gioonna kiaapu voovoono Mmannasa Yoketaivaara maisavaivee tiivaa fai hama Anutuuqo ivaa rugaanaravaivee. Fai tupatupaa vainaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Vaidi Anutuuqaa kua mmaanna kiaa mmiraiya Yisuunnara tunoo: Mmannasa maisaivo inna aakiaana varinoo, kiaa kiada Mmannasa Yoketaivaara maisavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yisuunna kaanoota ari kataunnaiyaatama numa mmaanai dida vaida tiisi tummuaneera innara tiravai. ");
INSERT INTO waj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iya innara tuduu gioonna kiaapuuya inna suvuau kiada varuuya inna tunoo: Aa mmiaa i kaanoota i kataunnaiyaatama aiyara kiaanoo, ");
INSERT INTO waj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","tuduu rikioo Yisuuva iya sai tunoo: Ni noonna tuanaivaata ni gata tuanaiyaatama vaa ngia taavaivee. Na ni noonna tuanaivaaraata ni gata tuanaiyaraatama mmuduuya ruauneema dee gioonna kiaapuvaara na mmuduuya ruaunnee? ");
INSERT INTO waj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","kiaa kioo gioonna kiaapu ivaki varuuya haitatuuma too iya tunoo: Aqaayaano ni noova ni gataunnaiya variaanoo. ");
INSERT INTO waj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gioonna kiaapu voovoono Anutuuqaa tinniivau vai kuaivaa tuqinnama rikioo iinnonno inna ni gata vayaa ni nunna nayaa ni noova varinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yisuuva keenaa nnoori haruunga mmaagaivau dioo vainno mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiravai. Kiaa mmioo varuduu gioonna kiaapu kaayauya inna suvuauvaara kanuuvaki karoo varioo feena roo oro nnoori tooyaivaki kioo ivaki varioo kuaivaa iya kiaa mmiravai. Kuaivaa iya kiaa mmuduu rikiada gioonna kiaapuuya nnoori mmaaga ivau varuduu ");
INSERT INTO waj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","iva mmatayaa diaa mminnaiyauvunudiri mmataama kioo kaayau kuaiyauvaa tioo vo kuavai iya kiaa mmioo tunoo: ");
INSERT INTO waj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Rikiaatee. Vaidi voovoono yeenna uruuyauvaa varoo ");
INSERT INTO waj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","oro ari mmooriivaki rututuooma roo nuaikio vooyauvai ari mmoori tammaivau aataruuvo vaivau tuoo kuaikiai ngiaammaiya tuma porooma nnaavai. ");
INSERT INTO waj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Uru vooyauvai tuoo sikau tasipama vai mmataivau tuoo vioo uruoo hama kaayau mmataivo vaivaara kiisa suai urikio too ");
INSERT INTO waj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","suaivo ngioo taikio maisaikio hama tuukaivo hokobama kuaivaara akiairaama aasannaivai. ");
INSERT INTO waj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Uru vooyauvai tuoo ooviiyauvaki kuaikio ooviiyauvo iyauvaa tasipama uruoo raputu kiaikio hama iiraataivai. ");
INSERT INTO waj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Uru vooyauvai mmata yoketaivau tuoo vioo yoketaama urikio kaayau iiraiyauvo vaivai. Vooyauvakidiri iiraiyauvo vo vaidivai taika kioo vo vaidivai yaakuuvaitana (30) vaikio vooyauvakidiri iiraiyauvo taaravooma vaidiiya yuku yaaku taika kioo (60) vaikio vooyauvakidiri iiraiyauvo yaaku sai vaidiiya yuku yaaku taika kioo (100) vaivaivee, ");
INSERT INTO waj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","kiaa kioo tunoo: Gioonna kiaapu voovoono arinaima kua rikiaivoono ii kua ivaa arinaima rikiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nnaagiai Yisuuva hara kioo varuduu rikiada ari ngiaammuauyaatama gioonna kiaapu vooya inna kuaivaa rikiooyaatama mmatayaa diaa mminnaiyauvunudiri mmataama kioo tuu kuaiyauvaara inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yaparauduu Yisuuva iya sai tunoo: Anutuuqo gioonna kiaapuuyara dira kua oyai haumaki vaivaa fai na ngii giaa ngii minai ngiengieenoo arinaima rikiaaravai. Gioonna kiaapu homoraiya mmuakiaa kuaiyauvaa rikiada kati mmanna mminnaiyauvunudiri mmataama kioo tii kuaiyauvaa rikiada hama tuqinnama rikiaavai. ");
INSERT INTO waj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ivaara fafaaraivo vainno tinoo: Iya teedada mmanna avuuyauvaadiri taavai. Iya rikiadada mmanna yaataiyauvaadiri rikiaavai. Hama iya tuqinnama teeda hama arinaima rikiaavai. Iya arinaima rikiada hanigiaatiri. Anutuuqo iya mminnamminnaa maisaiyauvaa rugaitirivee. Fafaaraivoono itaa kua tiivai. Iya sa tuqinnama teeda arinaima rikiaateeraivaara na mmatayaa diaa mminnaa vooyauvunudiri mmataama kiee iya kiaa mmiauvaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yisuuva itaa kua kiaa kioo iya yapara ruoo tunoo: Na uruyaadiri mmataama kiau kuaivaa ngia hama arinaima rikiada dataama vo kua vo kuaivaa na ngii giaa ngii minai ngia rikiaarannee? ");
INSERT INTO waj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Vaidi yeenna uruuyauvaa rututuoovo Anutuuqaa mmayaaya tira vaidiivaa roosiivai. ");
INSERT INTO waj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Uruuyauvo aataruuvau tuoo kuaiyauvo gioonna kiaapuuya Anutuuqaa mmayaayaivaa rikieeraiya roosiivai. Iya rikiaavo Sataango iya rikiaa saivaata numa mmayaayaivo iya aakiaana vaivaa varoo kuaivai. ");
INSERT INTO waj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Uruuyauvo sikau tasipama vai mmataivau tuoo kuaiyauvo gioonna kiaapu vooya roosiivai. Iya Anutuuqaa kuaivaa rikiada iya rikiaa saivaata kaayau siriga tasipama varaavai. ");
INSERT INTO waj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Uruuyauvo uruoo hama tuukaiyauvo mmeepi kuaiyauvaa roosiima iya hama kuaivaa ngiari aakiaana yapeerama kiada kiisa suai nnaasu Anutuuqaara yaagueeqakiaavai. Iya Anutuuqaa kuaivaa iikiaivaara gioonna kiaapuuya maisa mmoori mmuaararaivaa iya mmiaani rikiada iya makee tikiai Anutuuqaa aataruuvaa pikiaavai. ");
INSERT INTO waj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Uruuyauvo ooviiyauvaki tuoo kuaiyauvo gioonna kiaapu vooya roosiivai. Iya Anutuuqaa kuaivaa rikiadaata ");
INSERT INTO waj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mmatayaa diaa mminnaiyauvaa varaaraivaara kaayauma yaata utida sikau varaaraivaara yaata utida mmuduuya rida mminnaa ari vookara ari vookaraiyauvaa iya varaataivaara kaayauma yaata utuaavo iyauvoono iya suvuainno Anutuuqaa kuaivaa rugaikio rikioo hama iiraataivai. ");
INSERT INTO waj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Uruuyauvo mmata yoketaivau tuoo kuaiyauvo gioonna kiaapu vooya roosiivai. Iya Anutuuqaa kuaivaa rikiada varakio kuaivo iya aakiaana urikio iiraiyauvo ataama vaivai. Vooyaki kiisakiangii iiraiyauvo (30) vaikio vooyaki voota nnoonnama (60) vaikio vooyaki kaayau (100) vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yisuuva itaa kua kiaa kioo tunoo: Hama gioonna kiaapu voovoono toobaivaa subi kioo varoo oro yapa kioo kuu yavaivaa varoo toobaivau tuarapuatikama rummua apu kiaikio vaivai. Hama ivo toobaivaa varoo oro terenaivaa mmemmaivaki yapa kiaivai. Hameetavee. Ivo toobaivaa varoo kiikoo koovau hirivai. ");
INSERT INTO waj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ivaa roosiima makee mmuakiaa mminnaiyauvo rummua apu kiaiyauvo fai kooyaa vainai mmuakiaaya taaravai. Kuaivaa na makee gioonna kiaapuuya kiaa mmiaukai hama tuqinnama rikiaivaa fai vo suai mmuakiaa gioonna kiaapuuya rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gioonna kiaapu voovoono arinaima kua rikiaivoono ii kua ivaa arinaima rikiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ivo itaa kua kiaa kioo iya tunoo: Ngia rikiaa kuaivaara arinaima yaata utida rikiaatee. Fai ngia koonnama rikikio kiisakiata ngiiiki vainaravai. Fai ngia yoketaama rikikio mmayaayaivo ngii tinniiyauvaki pinaavai vainaravai. Fai gioonna kiaapuuya yoketaama rikiaiya Anutuuqo yaagueeqaivaa iya mminai vo kua vo kuaivaata rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ivaara gioonna kiaapu voovoono ni kuaivaa arinaima rikiaivoono fai Anutuuqo ari vo kua vo kuaivaa inna kiaa mmino rikiaanaravai. Gioonna kiaapu voovoono kiisa kuaivo inna yaatana vaivaa fai yapooma taunnu kino hama innaki kuaivootainaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yisuuva itaa kua kiaa kioo iya tunoo: Vaidiivo uruuyauvaa rututuooma kiaikio urineema Anutuuqo tiiyara diraivo vainnonno pinaavai vainoo. Vaidi voovoono mmooriivaki yeenna uruuyauvaa rututuooma kioo ");
INSERT INTO waj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","numa vuru vaivo pataikio oro mmooriivaa varaivai. Ivo vaikia ditakie mmannammanna itaikiokio yeenna uruuyauvo uruoo pinaa kiaiyauvai diivai. Uruuyauvo urii aataruuvaa hama ivo too rikiaivai. ");
INSERT INTO waj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mmataivo ariinoo uruuyauvaa virikiokio pinaa kioo apuuyauvonnaadee vaikio nnaagiai apaiyauvo vaikio aikiooma iiraiyauvo vaivai. ");
INSERT INTO waj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iiraiyauvo yootoo apuunno nneeravaata vaivaara vaidiivo avaikarai paipa hovekauvaadiri varoo numa rutakaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yisuuva itaa kua kiaa kioo tunoo: Anutuuqo gioonna kiaapuuyara diraivo inna aaniivai roosiivainnee? Na dee mmatayaa diaa mminnaivaudiri mmataama kiee ngii giaa ngii minarannee? ");
INSERT INTO waj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anutuuqo gioonna kiaapuuyara dira mmayaayaivo uru kiisakiata nnaammuaya uruuvaa roosiivaa nnutuuvo masateeraivaa roosiivai. Uruuvo kiisakiata vaikio mmuakiaa mminnaiyauvaa uruuyauvoono ii uru ivaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Vaidi voovoono ii uru ivaa varoo mmataki rututuooma kiaikio uruoo ngioo vioo pinaa kioo mmuakiaa annaanna mmaguyaiyauvaa yaataroo dioo vainno hammara pinaiyauvaa haraikiai ngiaammaiya numa ngiisaiyauvaa iyauvaki heeka kiada vakiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yisuuva itaa kua kiaa kioo ii mminnaa ivaudiri mmataama kioo tuu kua iyauvaa roosuuvaa ivo kaayau mminnamminnaiyauvunudiri mmataama kioo tuu kuaiyauvunudiri ari mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiravai. Iya arinaima rikioo kuaivaa nnaasu iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mmuakiaa kuavai mmatayaa diaa mminnaiyauvunudiri mmataama kioo tiravai. Vo suai ari ngiaammuaudaa nnaasu sudu vitoo mmataira kua oyaidaa kooyaa iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ii suai ivaki hannauduu upisipisuuduu Yisuuva ari ngiaammuauya tunoo: Nnikiai ta nnoori haruungaivaa sainai kuaaravee, ");
INSERT INTO waj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","tuduu gioonna kiaapu nuunauya ivau uuduu ari ngiaammuauya iya pikiada Yisuuva varuu kanuuvaki karada inna tasipama viravai. Vuduu ari vo kanuuyauvootama iya tasipama viravai. ");
INSERT INTO waj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Vududuu yuunna yaamurukaivo nnooriivaudiri nnuduu nnooriivo korokoroonno ketekaateenno kanuuvaki ngioo vioo mmuugiaina uuduu ");
INSERT INTO waj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yisuuva kanuuvaa rakanainningiaa kunnaivau vuru vauduu iya inna yuruuma kiada inna tunoo: Vitaira-o, nnooriivo kiisa suai ti raputinara iinoo. Hama a tiiyara boo kiannanoo, ");
INSERT INTO waj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","tuduu rikioo diitoo yuunnaivaa yaagueeqama ooqoo tioo nnooriivaa tunoo: Pikiee tirooma varianee, tuduu yuunnaivo pikiooduu nnooriivo tirooma variravai. ");
INSERT INTO waj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tirooma varuduu Yisuuva iya tunoo: Ngia aaniira aatuuda variaannee? Aaniira ngia hama niiyara kutaavaivee kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","tuduu rikiada kaayauma aatuuda ngiari kiaa mmi ngiari kiaa mmiida tunoo: Aanna dee vaidivainnee? Ivo yuunnaivaata nnooriivaatama tikiai rikiada akiairaama taikaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yisuuva ari ngiaammuauyaatama nnoori haruungaivaa sainai vau mmataivaa nnutuuvo Keraseenga vida ");
INSERT INTO waj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yisuuva kanuuvaa pikioo reemi roo saivaata tooduu vaidi putuuya hau oonauyauvakidiri vaidi voovoono Yisuunna saidi tiiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ii vaidi ivaa aakiaivaki mmagia maisaivo topauvoono vaidi putuuya hau oonauyauvaki nnaasu hara kioo variravai. Hara kioo varuduu hama yopeema vaidi voovoono inna yuku yaakuuyauvunu yeena rairavai. ");
INSERT INTO waj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Vaa kaayauneetu vaidiiya inna vitada yuku yaakuuyauvunu yeena yaagueeqaivaadiri ranaa rau kiooduu mmuakiaa suai ivo ari yaakuuvaitanaudiri yeena yaagueeqaivaa rannakekaama kioo ari yukuuvaitanaudiri yeena yaagueeqaivaa rutatooma kioo rakeeravai. Ivo yaagueeqauvaara hama vaidiiya yopeema inna ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ikiannagisanna heenagieena ivo vaidi haira oonauyauvaki nuainno varioo taapiiyauvunuaatama nuainno varioo kai kai tioo sikauyauvaadiri ari mmammaivaa hatokeeravai. ");
INSERT INTO waj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ivoono ngieeradiri Yisuunna too seenoo tuoo inna yuku oyaivaki toorivu yau haroo ");
INSERT INTO waj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","innara puaisakama aayanna roo mmagia maisaivo inna kiaa mmuu kuaivaa tunoo: Yisuu-o, Anutuuqo mmuakiaa mminnamminnaayauvai yaataraivaa Mmaapukuavee. A aaniivai ni iinarainna ngiannannee? Na Anutuuqaa nnutu tasipama yaagueeqama i kiaunoo: Sa ni ruputuanee, kiaunoo. ");
INSERT INTO waj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yisuuva innaata kua tioo varioo inna tunoo: Mmannasa maisa-o, aa vaidi aavaakidiri tiee kuanee, tuuvaara ivo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yisuuva inna yaparainno tunoo: Ai nnutuuvaa kianee, tuduu rikioo kaayau mmagia maisaiyauvo inna aakiaivaki varuuyauvaara ivo inna sai tunoo: Ni nnutuuvo Kaayauvavee, ");
INSERT INTO waj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","kiaa kioo Yisuunna makee tuduu yaagueeqama tunoo: Sa mmagia maisaiya titanai voopira kuatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tuduu kaayau puaraiyauvo taapiivau yeenna nneeda varuduu ");
INSERT INTO waj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","mmagia maisaiya vaidiivaa aakiaivaki topauya yaagueeqama Yisuunna tunoo: A ti titanai ta puaraiya aakiaiyauvaki kuaaravee, ");
INSERT INTO waj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","tuduu rikioo Yisuuva ee-oo tuduu mmagia maisaiya vaidiivaa aakiaivakidiri pikiada puaraiya aakiaiyauvaki vuduu mmuakiaa puara kaayau (2000) rereevau mmeepi seenada vida nnoori haruungaivaki putu taika kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Putu taika kiooduu vaidi puaraiyara haitatuuraiya seenada vida mmayaayaivaa gioonna kiaapu yoosinnaivaki varuuyaatama annaanna nnauyauvaki voopi voopi varuuyaatama kiaa mmiravai. Kiaa mmuduu rikiada gioonna kiaapuuya yoosinnaivaki pikiada Yisuuva ivaki uu mmooriivaa taara nniravai. ");
INSERT INTO waj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iya Yisuunnasi nnida tooduu vaidiivaa aakiaivakidiri kaayau mmagia maisaiya pikiada vuuvoono vaa ari uyira rairaiyauvaa uyu rau kioo kati hara kioo varuduu ari yaataivo yoketauduu gioonna kiaapuuya innara aatuuravai. ");
INSERT INTO waj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vaa tauraa Yisuuva uu mmooriivaa tooyaano vaidi vaa mmagia maisaiya inna aakiaivakidiri pikioovaaraata puaraiyaraatama iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kiaa mmuduu rikiada iyaata mmaayootaiyaatama Yisuuva iya yoosinnaivakidiri pikioo kuaiveera inna yaagueeqama tiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tuduu Yisuuva kanuuvaki karoo varuduu vaidi vaa mmagia maisaiya inna aakiaivakidiri pikioovo inna yaagueeqama yapara ruoo tunoo: Kii neeta kuanaravee, ");
INSERT INTO waj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","tuduu rikioo ooqoo tioo inna tunoo: Kava vara ranee ai seenaiyasi viee Udaangaivo aiyara boo tioo i iima kiai kuaivaa iya kiaa mmianee, ");
INSERT INTO waj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","tuduu rikioo vaidiivo vioo yoosinna pinaivaa aakiaivaki vau yoosinna yaakuuvaitana nnutuuvo Dikaporiisa ivaki nuainno varioo gioonna kiaapuuya Yisuuva inna iima kioo kuaivaa kiaa mmuduu rikiada mmuakiaaya inna kuaivaa rikiooya nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yisuuva ari ngiaammuauyaatama kanuuvaa varoo kava vara ranoo nnoori haruunga sainai ngioo oro siriivau varuduu kaayau gioonna kiaapuuya innasi nuunaida variravai. ");
INSERT INTO waj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Innasi nuunaida varuduu vaidiivaa nnutuuvo Yairiiva nuunaira nnauvaa kieetavai varuuvoono numa Yisuunna too ngioo varoo inna yuku oyaivaki toorivu yau haroo ");
INSERT INTO waj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yaagueeqama inna yaparainno tunoo: Ni naunnainningiaa nniitaraikio putinara iinoo. Ha ngiannannee? Inna nniitaraivo pikino ivo diitoo hara kioo variaiveera numa innayaa ai yaakuuvaitana utuanee, ");
INSERT INTO waj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","tuduu rikioo Yisuuva inna tasipama vioo varuduu gioonna kiaapu kaayauya inna vata rada vida inna suvuau kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Gioonna voovoono kabaa vira aataruuvo tupatupaa innaki vaududuu nuanu yaakuuvaitana yukukidiri taara nuanu taika kioo varuu gioonnaivo varioo ");
INSERT INTO waj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","tutaaqaiyasi makemakee aataru roo varuduu kaayau nniitarooduu ari sikau pinaivaa kagaari taika kiooduu homo kabaa vira aataruuvo innaki nnaasu vairavai. ");
INSERT INTO waj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Iva Yisuuva yoketaa mmoori uu kuaivaa rikioo ariiyara yaata utuoo tunoo: Fai na kati inna buruqaivau utino too ni kabaa vira aataruuvo taikanai na kava kati hara kiee varinaravaivee, kiaa kioo gioonna kiaapuuya nuunau aakiaidaadiri ngioo oro Yisuunna mmookai dioo vainno ");
INSERT INTO waj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","inna buruqaivau kiisama utuduu akiairauduu inna kabaa vira aataruuvo taikooduu rikioo ari nniitaroovo taikoovaara arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Rikiooduu akiairaama Yisuuva vaidi tuqinneera yaagueeqaivo innakidiri vuuvaa rikioo gioonna kiaapuuya nuuna aakiaivaki hanigioo iya yapara ruoo tunoo: Gioono ni buruqaivau utiinnee? ");
INSERT INTO waj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","tuduu rikiada ari ngiaammuauya inna sai tunoo: Gioonna kiaapuuya i suvuakuaivaa vaa a taannanoo. Mo aaniira a kiannanoo: Gioono ni buruqaivau utiinnee? kiannannee? ");
INSERT INTO waj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","tuduu rikioo Yisuuva inna utuuvaara homo buainnonno tooduu ");
INSERT INTO waj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","gioonnaivo Yisuuva inna tuqinnoovaa rikioovaara aatuunno biribiriinno ngioo varoo inna yuku oyaivaki toorivu yau haroo ari nniitaroo kuakuaakua eeyaayauvai kooyaa inna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Inna kiaa mmuduu rikioo inna tunoo: Ni nunnakuavee. A yaagueeqama niiyara kiannanoo: Aikiooma ni tuqinnaanaravaivee, kiannaivaarainna vaa a yoketaama hara kiee variannanoo. Diitee ausa nuufa tasipama eeyaara i nniitaraivo taika kinai kuanee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yisuuva itaa kua tuu saivaata Yairiinna nnauvakidiri vaidi vooya numa Yairiinna kiaa mmida tunoo: Vaa i raunnaivo putivaivee. Mo aaniira Vitairaivaa vitee kuanara iikiannannee? Pikiaanee, ");
INSERT INTO waj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","tuduu rikioo Yisuuva iya tuu kuaivaa rikioonnaata nuunaira nnauvaara dira vaidiivaa tunoo: Sa ausa mmuaararee pinaama yaata utuanee. Niiyara nnaasu yaata utuee kutaavaivee kianee, ");
INSERT INTO waj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","kiaa kioo mmuakiaa gioonna kiaapu inna nnaagiai nuauyara ooqoo kiaa kioo Petoroosaa vitoo Yakoopaa vitoo inna kataivaa Yuvuaanaata vitoo viravai. ");
INSERT INTO waj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Vidada oro tooduu nuunaira nnauvaara dira kieetaivaa nnauvaki gioonna kiaapuuya nuunaida vuu vuu kai kai tida pinaama ratada kua tuuvaa Yisuuva rikioo ");
INSERT INTO waj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","nnauvaki vioo iya tunoo: Ngia aaniira pinaama kua tida rataannee? Hama kiaatannaivo putivai. Kati vuru vainoo, ");
INSERT INTO waj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","tuduu rikiada iya vaa nnaakaraivo putuuvaa teeda Yisuunnara raida varuduu iva numa iya titooduu mmaanai vuduu rikioo nnaakaraivaa kaano koovaitanaata ari ngiaammuau taaravoomaidaatama vitoo nnaakaraivo vauvaki viravai. ");
INSERT INTO waj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Vioo inna yaakuuvau utuoo ari kuaivakidiri inna tunoo: Tarita kuuma, tiravai. Ii kua ivaa oyaivo tunoo: Kuabuaa-o, na i kiaunoo: Diitaanee, kiaunoo. ");
INSERT INTO waj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ivo itaa kua tuduu makee tuduu kiaatannaivo diitoo nuairavai. Aa kiaatanna aavaa nuanuuvo yaakuuvaitana yukukidiri taarama vaivai. Iva diitoo nuauvaa iya teeda kaayauma nnikiaraida yaata utuduu ");
INSERT INTO waj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yisuuva yaagueeqama iya kiaa mmioo tunoo: Aavaa taiya sa vooya kiaa mmiatee, kiaa kioo kiaatannaivaara tunoo: Yeennaivaa inna mmiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisuuva ii yoosinna ivaa pikioo ari yoosinna tuanaivakira ari ngiaammuauya inna tasipama viravai. ");
INSERT INTO waj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iya oro varuduu kati varira suaivaki Yisuuva nuunaira nnauvaki oro gioonna kiaapuuya Anutuuqaa kuaivaa iya kiaa mmioo varuduu rikiada nnikiaraida tunoo: Aa vaidi aavo deevakidiri aa kua aavaa varoonno tiinnee? Dataama tinni yoketaivaa varainnee? Mo dataama ivo yaagueeqa ari vookara ari vookarai mmooriivaa iinnee? ");
INSERT INTO waj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ivo nnau heekeera vaidivai Mariaanna mmaapuvai. Ari kataido Yakoopo Yoosiipo Yutaaso Simoonainna variaanoo. Mo ari nnunnaapuuya aavaki variaanoo, kiaa kiada hama iya innara iya yoketauduu innara ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Innara ooqoo tuduu rikioo Yisuuva iya tunoo: Kua kutaa tira vaidi forofetaivaara mmuakiaa yoosinnaiya innara yoketaakiaani ari yoosinna tuanaiyaatama ari oyaiyaata ari seenaiyaatama hama innara yoketaakiaavaivee, ");
INSERT INTO waj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","kiaa kioo iva ivaki kiisa gioonna kiaapu nniitarooya nnaasu iyayaa ari yaakuuvaitana utuoo tuqinnooduu kati hara kiada variravai. Ivakinnaaya innara ooqoo tuuvaara ivo hama Anutuuqaa mmoori ari vookara ari vookarauyauvaa ivaki kaayauma iiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iya hama innara kutaavaivee tuuvaara iva kaayauma yaata utiravai. (Matai 10:5-15; Rukaaso 9:1-6) Yisuuva ivaki pikioo vainima vau yoosinnaiyauvaki nuainno varioo gioonna kiaapuuya Anutuuqaa mmoori aataruuyauvaa vitairavai. ");
INSERT INTO waj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Vitainno varioo ari ngiaammuau yaakuuvaitana yukukidiri taarama tuduu innasi numa dida vauduu taara tida taara tida vo yoosinna vo yoosinnaiyauvaki nookiateeraivaara titoo gioonna kiaapuuyakidiri mmagia maisaiya titakiai kuateera yaagueeqaivaa iya mmioo ");
INSERT INTO waj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","yaagueeqama iya tunoo: Sa aataruuvaura mminnaiyauvaa varada kuatee. Kati yau nnaasu kurida kuatee. Sa yeennaiyauvaa varada sa utuaiyauvaa varada sa sikauyauvaa vara rida kuatee. Kati kuatee. ");
INSERT INTO waj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yuku nnabaiyauvaa ngii yukuuyauvunu uyida kuatee. Sa yaapaiyauvaa taara tida varada kuatee. Mmuaa tida mmuaa tida nnaasu varada kuatee, ");
INSERT INTO waj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","kiaa kioo iya tunoo: Fai ngia yoosinnaiyauvaki vida tauraa nnau ngii miaiyauvaki nnaasu varida yapooma yoosinnaiyauvaa pikiada vira suaivaki ii nnau iyauvaatama pikiada kuatee. ");
INSERT INTO waj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Fai ngia vo yoosinna vo yoosinnaiyauvaki nuaida varida teekiai hama iya ngiiiyara tuqinnada hama ngii kuaiyauvaa rikikiai teeda ngiingii yukuuyauvunudiri kufukuufaiyauvaa rututuooma kiada pikiada kuatee. Anutuuqo irisai maisaivaa iya mminaraivaara iya rikiaateeraivaara kufukuufaiyauvaa ngii yukuuyauvunudiri rututuooma kiaatee, ");
INSERT INTO waj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","tuduu rikiada vida gioonna kiaapuuya hanigiada ngiari mminnamminnaa maisaiyauvaa pikiaateera kuaivaa iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Iya kiaa mmida kaayau mmagia maisaiyauvo gioonna kiaapu vooya aakiaana topauyauvaa titooduu vuduu kaayau nniitarooyayaa yatari iira suuyaivaa siikaida tuqinnooduu kati hara kiada variravai. ");
INSERT INTO waj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yisuuva uu mmooriivaa mmayaayaivaa kaayau gioonna kiaapu vo yoosinna vo yoosinna varuuya rikiooduu Yutayaiya kieeta Herootoota rikieeravai. Vooya Yisuunnara tunoo: Yuvuaano nnoori apira vaidiivo putuoo kava diitoovaara yaagueeqaivo inna tasipaikio mmoori ari vookaraivaa iinoo, ");
INSERT INTO waj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","tuduu vooya tunoo: Inna Irayaavavee, tuduu vooya tunoo: Inna nnaaruaa vaidi forofetaa varuuvaa roosiima vari vaidivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tuduu Herooto innara tunoo: Inna Yuvuaano nnoori apira vaidivai. Na nnaaru kiaaduu inna nnuunaivaa rutakoovoono aanna ivoono kava diitoo varinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nnaaru Yuvuaano varuu suaivaki Herooto ari vayaanna Piriipaa nnaataivaa Herootiaanna mmuara varooduu Yuvuaano Herootaa tunoo: I vayaanna nnaataivaa varaanna aataruuvo inna hama safu aataruvaivee, tuduu rikioo Herootiaava Yuvuaanaara maisa mmooriivaa iinaraivaara Herooto ari ngiaammuauya tuduu Yuvuaanaa yuku yaakuuvaa yeena rau kiada oovi nnauvaki yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yapa kiooduu Yuvuaano tuu kuaivaara Herootiaanna kaayauma nnannatooduu inna ruputinara iikiatauduu Herooto ooqoo tuduu hama yopeema iiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yuvuaano safuuma varira yoketaa tuanaa vaidivai varuduu too Herooto inna tooduu kaayauma inna aatuuduu gioonna kiaapuuya inna ruputuaara uuvaara ooqoo tiravai. Ooqoo tuduu makemakee inna kuaivaa rikiooduu inna yoketauduu ivaara kaayauma yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herootiaava Yuvuaanaa ruputinaraivaara makemakee yaata utuoo tooduu Herootaa mmatoo suaivo nnuduu too yaata utuoo tunoo: Aanna makee na tinai ruputuaaravaivee, tuduu Herooto ari kieeta nnoonna vaidiiyaniaatama ari rapira kieetaiyaniaata Karirayaa yokovaiyaniaatama buusa pinaivaa iima kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iima kiooduu numa varuduu Herootiaanna raunnaivo numa kuaru rooduu teeda Herootoota ari tasipama yeenna nnooyaatama inna teeda varuduu iya innara kaayauma yoketairavai. Yoketauduu Herooto kiaatannaivaa tunoo: A varaanaree kianna mminnaivaa ni yaparainai na i mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","kiaa kioo kua kiaa teerama yeena rau kioo kuaivaa inna tunoo: Vo mminnaa vo mminnaivaara a ni yaparainai fai na i mminaravai. Na kaayau mminnaiyauvaara diaunoo. Fai saiyauvai i varaatainai ni yaparainai fai neenoo i mminaravee, ");
INSERT INTO waj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","tuduu rikioo vuaiha ari kaanaasi vioo inna yaparainno tunoo: Mo dee mminnaavaara na inna yaparainarannee? tuduu rikioo tunoo: Yuvuaano nnoori apira vaidiivaa nnuunaivaa vaidiiya rutaka kiada inna kieetaivaa varada ngiateeraivaara inna yaparakianee, ");
INSERT INTO waj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","tuduu rikioo kammannauduu ngioo Herootaa yaparainno tunoo: Aanna makee tinai Yuvuaano nnoori apira vaidiivaa nnuunaivaa rutaka kiada inna kieetaivaa yanaivau yapa kiada varada numa kikiai ni mianee, ");
INSERT INTO waj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","tuduu rikioo Herootaa ausaivo kaayauma mmuaararooduu ari seenaiya avuuyauvunu kua kiaa teerama yeena rau kioo kuaivaa tuuvaara yaata utuoo hama inna kuaivaa ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hama ooqoo tirainno Yuvuaanaa kieetaivaa varoo ngiaiveera ivo oovi nnauvaara haitatuura vaidi voovai titeeravai. Titooduu oovi nnauvaki vioo Yuvuaanaa nnuunaivaa rutaka kioo ");
INSERT INTO waj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kieetaivaa yanaivau yapa kioo varoo numa kiaatannaivaa mmuduu varoo ari kaanaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yapooma Yuvuaanaa nnaagiai nuaira ngiaammuauya iva putuu kuaivaa rikiada numa inna mmamma kaanaivaa varada oro oonauvaki hau kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yisuunna ngiaammuau kua varada nuauya kava vara ranada Yisuunnasi nnida nuunaida mmuakiaa ngiari uu mmooriiyauvaaraata ngiari kua kiaa mmuu aataruuyauvaaraatama inna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Inna kiaa mmuduu rikioo tooduu gioonna kiaapuuya iya suvuau kiada vauduu hama iya yeenna nnaara suaivootauduu Yisuuva ari ngiaammuauya tunoo: Nnikiai tetevana oro mmanna yoosinna voovaki na ngii kinai kiisama deeyakiatee, ");
INSERT INTO waj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","kiaa kioo iyaata sunoo kanuuvaki karoo mmanna gaanga yoosinnaivakira viravai. ");
INSERT INTO waj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Vida varuduu gioonna kiaapu vooya iya vuuvaa teeda arinaima iya teeda mmuakiaa yoosinnaivakidiri pikiada mmataivau seenada vida iya yaatarada vida iya kuaara vuu yoosinnaivaki gioonna kiaapuuyannaadee tauraa oro variravai. ");
INSERT INTO waj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Varuduu Yisuuva iya nnaagiai numa kanuuvaa pikioo tooduu gioonna kiaapuuya nnoori siriivau suvuau kiada varuduu iya puara sipisiipa raubiruuya roosiima hama ngiari haitatuuraivootauyara Yisuuva iyara kaayauma boo tioo kaayau kua yoketaiyauvaa iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iya kiaa mmuduu suaivo haatapaanara uuduu ari ngiaammuauya numa inna tunoo: Vaa suaivo haatapainoo. Aa yoosinna aavo mmanna gaanga yoosinnavaki ta variaunnanoo. ");
INSERT INTO waj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gioonna kiaapuuya titanai kuatee. Iya titanai aavakinnaaya yoosinnaiyauvaki vida yoosinna vainima vaiyauvaki vida sikauyauvaadiri yeennaiyauvaa yookaama kiada varada nnikiai nnaateeraivaara kuatee, ");
INSERT INTO waj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","tuduu rikioo iya sai tunoo: Mo ngieenoo yeennaiyauvaa iya mmiatee, tuduu rikiada iya inna yaparaida tunoo: Fai a ti titanai ta kaayau sikau yanaiyauvaadiri (200) yeennaiyauvaa yookaama varada numa iya mmiaarannee? ");
INSERT INTO waj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tuduu rikioo iya sai yaparainno tunoo: Mo naana bereetayauvai ngiiisi vainnee? Oro taatee, tuduu rikiada oro teeda numa inna tunoo: Bereeta yaaku saivai tavau taaravaitanaatama vainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Tuduu rikioo Yisuuva ari ngiaammuauya tuduu gioonna kiaapuuya ferefuruunnaiyauvunu vo kammu vo kammu variateera tuduu vooya voovau nuunama (50) varuduu vooya voovau nuunama (100) varuduu itaqitaama variravai. ");
INSERT INTO waj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Varuduu Yisuuva bereeta yaaku saivai tavau taaravaitanaatama tu kioo vainno avuuvaa reeri ngiau aapu too vainno Anutuuqaata kua yoketaivaa tioo bereetaiyauvaa kusiinnonno kioo ari ngiaammuauya gioonna kiaapuuya mmiateeraivaara mmiravai. Mmioo tavau taaravaitanaata rakau kioo iya mmuduu iya mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iya mmuduu mmuakiaaya nnooduduu iya ausaiyauvo rasituduu ");
INSERT INTO waj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ari ngiaammuauya utua yaakuuvaitana yukukidiri taaravaitana yeenna nneeda kioo arai yatiiyauvaa rupi nuunama rida tavau saiyauvai rupi nuunama rummua yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Rummua yapa kiada ivaki yeenna nnoo vaidiiya nnaasu yaaruduu kaayau (5000) ivau variravai. ");
INSERT INTO waj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iya nnaa taika kiooduu Yisuuva yaagueeqama ari ngiaammuauya titoo tunoo: Na gioonna kiaapuuya titee varinai ngieenanaa kanuuvaki karada nnoori siri sainai yoosinna Betesaitaa kuatee, ");
INSERT INTO waj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","kiaa kioo gioonna kiaapuuya ngiari yoosinnaipira titaa kiooduu vuduu too Yisuuva ari ngiaammuauya pikioo taapiivau yaaku varaanara viravai. ");
INSERT INTO waj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Vioo ivau varuduu heenauduu ari ngiaammuauya varuu kanuuvo nnoori haruunga pinaivaa vuutaivau vioo varuduu Yisuuva arivai homo mmataivau varioo ");
INSERT INTO waj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","tooduu ari ngiaammuauya yatari sagaiyauvaa utida yaagueeqama nnooriivaa ruvuatidada tooduu yuunna yaamurukaivo iyasi nnuduu hama kanuuvo viravai. Hama kanuuvo vuduu patairaarauduu Yisuuva nnoori verenoovau raa roo iyasi ngioo iya yaataraanara uuduu ");
INSERT INTO waj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","iya iva nnoori verenoovau nnuuvaa teeda mmagia maisavaivee kiaa kaayauma aatuuda kai kiririingaida ");
INSERT INTO waj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","mmuakiaaya inna teeda kaayauma aatuuda variravai. Iya aatuuda varuduu Yisuuva akiairaama iya tunoo: Tirooma variatee. Sa aatuukiatee. Na ngiaunoo, ");
INSERT INTO waj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","kiaa kioo karoo kanuuvaki iya tasipama varuduu yuunna yaamurukaivo taika kiooduu ari ngiaammuauya nnikiaraida kaayauma kumimakaida varida ");
INSERT INTO waj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","iva tauraa yeennaiyauvaa rakau kusii kioo gioonna kiaapuuya mmuuyauvaara hama arinaima rikiooduu hama ngiari tinniiyauvo rusitiravai. ");
INSERT INTO waj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iya nnoori sainai yoosinna Genesareeta oro varuduu nnoori siriivaki nnida kanuuvaa yeenaivaa haru kiada ");
INSERT INTO waj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ivaki pikiada viravai. Iya kanuuvaa pikiada vuduu ivaki varuuya Yisuunna arinaima teeravai. ");
INSERT INTO waj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Arinaima teeda seenada mmuakiaa yoosinnaiyauvakidiri nniitarooya ngiari mmaataiyauvunu vaida varuuya vitada Yisuuva varuuvakira innasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mmuakiaa yoosinna Yisuuva nuauyauvaki pinaa yoosinnaiyauvakiaata kiisa yoosinnaiyauvakiaatama gioonna kiaapuuya ngiari seena nniitarooya vitada yeenna yookaira mmatuuyaiyauvunu yapa kiada Yisuunna buruqa araivau nnaasu utuaaraivaara inna yaagueeqama yaparairavai. Mmuakiaaya inna buruqa araivau utuuya nniitarooyauvo taikooduu yoketaama hara kiada variravai. ");
INSERT INTO waj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisai vaidi vooyaata kua mmaanna kiaa mmira vaidi vooyaatama Yerusareemadiri nnuuya Yisuunnasi nnida nuunama mmuaavau variravai. ");
INSERT INTO waj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mmuaavau varida tooduu ari ngiaammuau vooya yeenna nnaara hama ngiari yaakuuyauvaa finirama kiada sabi nneeravai. Iya hama Farisaiya uu aataruuvaugiataama iirama kiada ngiari yaakuuyauvaa hama finirama kiada kati yeennaiyauvaa nneeravai. ");
INSERT INTO waj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Vaidi Farisaiyaata Yutayaa vaidi vooyaatama ngiari taato nnaakukiaiya uu aataruuvaa iiravai. Ngiari yaakuuyauvaa hama finutiri. Hama yeennaiyauvaa nnootirivee. ");
INSERT INTO waj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iya yeenna yookaira mmatuuyaivakidiri nnida ngiari yaakuuyauvaa hama finutiri. Hama yeennaiyauvaa nnootirivee. Vo aataru vo aataruuyauvo ngiari taato nnaakukiaiyasidiri nnuuyauvaa iya uuneema ngiari kaapaiyauvaata ngiari yavaa ari vookara ari vookarauyauvaatama finiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yisuunna ngiaammuau vooya hama iya uu aataru vooyauvai uuvaara Farisaiyaata kua mmaanna kiaa mmira vaidiiyaatama Yisuunna tunoo: Aaniira hama i ngiaammuauya ti taato nnaakukiaiyasidiri nnuu aataruuvaa iikiaannee? Aaniira hama iya ngiari yaakuuyauvaa finirama kiada kati yeennaiyauvaa nneeda maisama variaannee? ");
INSERT INTO waj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","tuduu rikioo Yisuuva iya sai tunoo: Nnaaruaa vaidi forofetaa Yisayaava ngia huoobavainna unnakua nnaamuruuyara fafaara roo kuaivo kutaa kuavai vainoo. Yisayaava fafaara roo tunoo: Anutuuqo tinoo: Aa gioonna kiaapu aaya mmanna kuasiiyauvo koroonno niiyara yoketaavee kiaavo hama iya aakiaiyauvo niiyara yoketainoo. ");
INSERT INTO waj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iya vaidiiya yaata tinniyaa vai kuaivaa kiaa mmida kiaanoo: Anutuuqaa aataruvaivee, kiaivaara kuminayaa niiyara kua yoketaivaa kiaanoo, tiivaivee. Yisayaava itaama fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ngia Anutuuqo tuu aataruuyauvaa pikiada vaidiiya tinniyaa vai aataruuyauvaa iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yisuuva itaa kua kiaa kioo tunoo: Mo ngia ngiingii yaata tinniyaa vai aataruuyauvaa iikiaaraivaara ngia Anutuuqo tuu kuaivaa ooqoo kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nnaaruaa vaidi Musiivaano tunoo: Ngii kaano koovaitanaara mmuduuya rida tuqinnaatee, kiaa kioo vo kua voovai tunoo: Fai gioonna kiaapu voovoono ari kaano koovaitana maisa kua tiivaa ruputikio putuaivee. Musiiva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mo ngiengieenoo kiaanoo: Fai vaidi voovoono ari kaano koovaitana tuqinnaanara mmatayaa diaa mminnaivaa iyani yapa kioo ivaara tinara: Kopaana, tinai ta ee-oo tikio aikiooma hama ari kaano koovaitana tuqinnaanaravee. Ngia itaa kua kiaanoo, tiravai. Iya kopaanavee kiaivaa oyaivo Anutuuqaa mminnaavai. Yisuuva keenaa iya tunoo: ");
INSERT INTO waj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ngia itaida ngiingii taato nnaakukiaiya uu aataruuyauvo ngiingii yaata tinniyaa vaivaa iikiaaraivaara Anutuuqaa kuaivaa hatokaavai. Ngia itaama iikiaa aataruuyauvo kaayau ari vookara ari vookarai aataruyauvai vaikiai ngia iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yisuuva keenaa gioonna kiaapuuya innasi ngiateera tuduu innasi nnuduu iya tunoo: Mmuakiaayaso, ni kuaivaa rikiada arinaima rikiaatee. ");
INSERT INTO waj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mminnaa voovai mmaanaidiri vaidi aakiaana tuoo kuai ivaara hama mminnamminnaa maisaivaa varaivai. Vaidiivaa ari aakiaivakidiri ngioo mmaanai tuoo kuai ivaara mminnamminnaa maisaivaa varaivai. ");
INSERT INTO waj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Gioonna kiaapu voovoono arinaima kua rikiaivoono ii kua ivaa arinaima rikiaivee,) tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yisuuva itaa kua kiaa kioo gioonna kiaapuuya pikioo nnau voovaki vuduu teeda ari ngiaammuauya iva mmatayaa diaa mminnaivaudiri mmataama kioo tuu kua oyaivaara inna yaparauduu rikioo ");
INSERT INTO waj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","iya sai tunoo: Ngia gioonna kiaapu kumimakaiya roosiima hama ngii tinniiyauvo rusitivai. Hama ngia arinaima rikiaanoo. Mminnaa voovai mmaanaidiri vaidi aakiaana tuoo kuai ivaara hama mminnamminnaa maisaivaa varaivai. ");
INSERT INTO waj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nnaa mminnaiyauvo hama vaidi kaanaivakiaata kuaivai. Mmanna rasookaivakinaadiri tuoo rukioo mmaanai tuoo kuaivaivee. Yisuuva itaa kua tioo mmuakiaa inneenna nnaiyauvaara yoketaa yeennayauvai nnaayauvaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iva kiaa kioo tunoo: Vaidiivaa ari aakiaivakidiri ngioo mmaanai tuoo kuai ivaara mminnamminnaa maisaivaa varaivai. ");
INSERT INTO waj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vaidi aakiaivakidiri maisa kuaivo ngioo yaataivaki kuaikio yaata utuoo mminnamminnaa maisaivaa varaivai. Kiaatanna ngiaammuauvo sabi heera aataruuvo vaidi aakiaivakidiri nniivai. Mmuara vareera aataruuvootama vaidiivaa ruputino putii aataruuvootama ");
INSERT INTO waj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","vaa nnaata vaati varaivo sabi mmuara heera aataruuvootama vaidi mminnaivaa teeno inna varaataira aataruuvootama vaidi aakiaivakidiri nniivai. Vaidiivo fai kaayau maisamaisai aataruuyauvaa iinno varioo unnakua tioo ari mmammaivaara nnaasu yaata utuoo makemakee sabi nuaira aataruuvaa iinno ari seenaiyara tinara: Ngia ni yaataraivaara ni nannatainoo, kiaa kioo maisa kuaivaa kuminayaa ari seenaiyara tioo ariiyara mannaka tioo aataru yoketaivaara kaayau kumimakainno varinaravai. ");
INSERT INTO waj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ii aataru maisa iyauvo vaidi aakiaivakidiri nniivaara kaayau mminnamminnaa maisaiyauvaa varaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yisuuva ii yoosinna ivaa pikioo vioo yoosinna taaravaitana nnutuuvaitana Turu Sitoona vainima vau yoosinnaivaki vioo nnau voovaki hara kioo varioo gioonna kiaapuuya ni teeda niisi ngiaarainnoo kiaa nnauki nnaasu hara kioo variravai. Varuduu vaa ivo vuu nnauvakira iya rikiooduu ");
INSERT INTO waj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","gioonna voovoono mmagia maisaivo ari raunnaivaa aakiaaki varuuvoono Yisuuva nnuu kuaivaa rikioo akiairaama innasi ngioo varoo inna yuku oyaivaki toorivu yau haroo variravai. ");
INSERT INTO waj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aa gioonna aavo ari voopinnaa gioonnavai. Ivo yoosinna Surofoonikiaivakidiri nnira gioonnavai. Yisuuva ii gioonna ivaa raunnaivaa aakiaivaki mmagia maisaivo varuuvaa titano kuaiveera inna yaagueeqama yapara riravai. ");
INSERT INTO waj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yapara ruduu Yisuuva Yutayaiya tauraa rikiooyara aa kua aavaudiri mmataama kioo inna sai tunoo: Kii ta tauraa nnaakaraiya yeennaiyauvaa ngiari mmiaaravee. Iya yeennaiyauvaa varada faiya mmiaarainnoo, ");
INSERT INTO waj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","tuduu rikioo ivo faivaa roosiima ariiyara yaata utuoo inna sai tunoo: Udaanga-o, a kutaa kuavai kiannanoo. Mo faiya numa nnaakaraiya yeenna nneeda kiaa araiyauvaa terenaivau tuoo kuaiyauvaa porooma nnaavaivee, ");
INSERT INTO waj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","tuduu rikioo Yisuuva inna sai tunoo: A ni kuaivaa sai yoketaama kiannaivaara ai nnauki kuanee. Vaa mmagia maisaivo i raunnaivaakidiri pikioo kuaivaivee, ");
INSERT INTO waj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","tuduu rikioo ivo ari nnauki vioo tooduu ari raunnaivo ari mmaataivau vauduu vaa mmagia maisaivo innakidiri pikioo ari ipi vioo kieeravaivee. ");
INSERT INTO waj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yisuuva yoosinna Turudiri kava vara ranoo ngioo yoosinna Sitoona yaataroo yaakuuvaitana vau yoosinnaiyauvaa nnutuuvo Dikaporiisa yaataroo numa nnoori haruunga Karirayaa mmaagaivau variravai. ");
INSERT INTO waj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Varuduu vaidi yaata duuna hama yoketaama kua tuu voovai ari seenaiyaano Yisuunnasi vitada viravai. Vida Yisuuva innayaa ari yaakuuvaa utuaiveera yaagueeqama inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yaparauduu rikioo Yisuuva vaidi yaata duunaivaa too gioonna kiaapuuya pikioo innaata vitoo ari mmaraa voovau dioo vainno ari yaaku oopuuvaitana inna yaataivaitanaki hara rada kioo ari yaaku oopuuvau kuaanuuvaa visi kioo inna mmaakiriivau haroo ");
INSERT INTO waj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","avuuvaa reeri ngiau too yaikiaivaa haa kiaa kioo inna tunoo: I yaataivo rugooqaivee, tiravai. Aa kua aavaa Yisuuva ari kuaivakidiri Epataa tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Vaidi yaata duunaivaa yaataivo rugooqooduu inna mmaakiriivo yoketauduu kuaivaa tuqinnama tiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tuqinnama tuduu rikioo Yisuuva yaagueeqama gioonna kiaapuuya kiaa mmioo tunoo: Makee ngia taivaara sa gioonna kiaapuuya kiaa mmiatee, kiaa yaagueeqama tuduaata vuaiha oro makemakee ngiari seenaiya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kiaa mmuduu rikiada ivaara kaayauma nnikiaraida tunoo: Ari mmaraa mmoori ii ivo inna yoketaa mmoorivai iivai. Iva yaata duunaiya iikiai iya tuqinnama yaata rikiaavai. Iva hama kua tiraiya iikiai iya tuqinnama kua kiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Vo suai voovaki gioonna kiaapu kaayauya nuunauduu yeennaivo vaa taika kiooduu Yisuuva ari ngiaammuauya innasi ngiateera iya tuduu innasi nnuduu iya tunoo: ");
INSERT INTO waj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Gioonna kiaapuuya taaravooma suaivaa ni tasipama nookiaavovo vaa yeennaiyauvo taika kiaivaara na iyara boo kiaunoo. ");
INSERT INTO waj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Fai na kati iya ngiari yoosinnaiyauvakira titanai vida hama yeenna nneeraida vikio aataru tammaivaki iya avuuyauvo ngioo vi ngioo viinai sabi yuku raaravai. Vooya ngiari yoosinnadiri hokoba aataruuvau niisi nniravaivee, ");
INSERT INTO waj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","tuduu rikiada ari ngiaammuauya inna sai tunoo: Mo aa koo mmuyai gaanga yoosinna aavau ta deevakidiri kaayau yeennaiyauvaa varada aa gioonna kiaapu aaya mmikiai nnaarannee? ");
INSERT INTO waj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","tuduu rikioo iya yapara ruoo tunoo: Naana bereetayauvai ngiiisi vainnee? tuduu rikiada iya inna sai tunoo: Bereeta yaaku saivai karasaidiri taaravaitana vainoo, ");
INSERT INTO waj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tuduu rikioo gioonna kiaapuuya mmatayaa variateera tuduu mmatayaa varuduu yeenna bereetaiyauvaa yaaku saivai karasaidiri taarama tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo bereetaiyauvaa kusiinnonno kioo gioonna kiaapuuya mmiateera ari ngiaammuauya mmuduu iya mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iya mmi kiada tavau kiisa vooyauvai tu kiada vauduu Yisuuva Anutuuqaata kua yoketaivaa kiaa kioo ari ngiaammuauya tunoo: Gioonna kiaapuuya mmiatee, ");
INSERT INTO waj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","tuduu rikiada mmuduu nnooduduu iya ausaiyauvo rasituduu ari ngiaammuauya yeenna nneeda kioo arai yatiiyauvaa rupi nuunama utua yaaku saivai karasaidiri taara utuavaitanaki rummua yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Gioonna kiaapu ivaki yeenna nnooya kaayau (4000) variravai. ");
INSERT INTO waj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yisuuva gioonna kiaapuuya titooduu vuduu iya vuu saivaata ari ngiaammuauyaatama kanuuvaki karoo varioo yoosinna pinaivaa nnutuuvo Daramanutaa viravai. ");
INSERT INTO waj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisai vaidi vooya Yisuunnasi nnida inna iida taaraivaara inna yaparaida tunoo: A Anutuuqaa mmoori ari vookaraivaa iinai ta teeda kiaara: Anutuuqaa yaagueeqaivo i tasipaikiainna iikiannanoo, kiaaravee, ");
INSERT INTO waj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","tuduu Yisuunna ausaivo kaayau mmuaararooduu tunoo: Ngia gioonna kiaapu makee variaiya Anutuuqaa mmoori ari vookaraivaa taaraivaara ni yapara kiaanoo. Na kua kutaavai ngii giaa ngii miaunoo. Ngia makee variaiya hama Anutuuqaa mmoori ari vookaraivaa taaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","kiaa kioo iya pikioo kava kanuuvaki karoo varioo nnoori haruungaivaa sainai vioo variravai. ");
INSERT INTO waj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yisuuva ari ngiaammuauyaatama nnoori haruungaivaa sainai vioo varuduu ari ngiaammuauya vo bereeta vooyauvaara taunnu kiada mmuaa bereetavai nnaasu varada kanuuvaki yapa kiada varada viravai. ");
INSERT INTO waj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yisuuva yaagueeqama iya tunoo: Rikiaatee. Vaidi Farisaiyaata Herootaa nnaagiai nuairaiyaatama puuqaira yeennaivo bereeta aakiaivaki too yootaivaa roosiivaara tuqinnama haitatuukiatee, ");
INSERT INTO waj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","tuduu rikiada ngiari kiaa mmi ngiari kiaa mmiida tunoo: Hama ta nnoonnama bereetaiyauvaa varada ngiaunnaivaara ivo itaa kua tinoo, ");
INSERT INTO waj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tuduu rikioo Yisuuva ngiari kiaa mmi ngiari kiaa mmuu kuaivaa arinaima rikioo iya tunoo: Ngia aaniiraida ngiingii kiaa mmi ngiingii kiaa mmiida kiaanoo: Ta hama nnoonnama bereetaiyauvaa varada ngiaunnanoo, kiaannee? Ngia homooda hama arinaima niiyara rikiaannee? Ngii vuatinniiyauvo yaagueeqainnonnee? ");
INSERT INTO waj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ngii avuuyauvo vaikiai hama ngia tuqinnama taavai. Ngii yaataiyauvo vaikiai hama ngia tuqinnama rikiaavai. ");
INSERT INTO waj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na yaaku sai bereetayauvai vaidi kaayau (5000) mmiaivaara vaa ngia taunnu kiaannee? Yeenna nneeda kioo arai yatiiyauvaa ngia rupi nuunama utuaiyauvaki ruuyauvo naana utuayauvai vairavainnee? tuduu rikiada iya inna sai tunoo: Ta utua yaakuuvaitana yukukidiri taarama yapa kieeravaivee, ");
INSERT INTO waj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","tuduu rikioo tunoo: Na bereeta yaaku saivai sainaidiri taarama kusii kiee vaidi kaayau (4000) mmiaivaara vaa ngia taunnu kiaannee? Yeenna nneeda kioo arai yatiiyauvaa ngia rupi nuunama utuaiyauvaki ruuyauvo naana utuayauvai vairavainnee? tuduu rikiada inna sai tunoo: Ta utua yaaku saivai karasaidiri taarama rummua yapa kieeravaivee, ");
INSERT INTO waj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","tuduu rikioo ivo ari vookarau mmooriivaa uuvaara iya tunoo: Itaama vaikiai hama ngia arinaima rikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama nnidada yoosinna Betesaitaa ivaki nnida tooduu gioonna kiaapuuya vaidi avu huruutauvaa vitada Yisuunnasi nnida inna utuaneera innaata kua yaagueeqama tiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kua yaagueeqama tuduu Yisuuva rikioo vaidi avu huruutauvaa yaakuuvau utuoo vitoo yoosinna tooyaivaki kioo inna avuuvaitanau kuaanuuvaa visi kioo innayaa ari yaakuuvaitana utuoo inna yaparainno tunoo: A vo mminnaa voovai taannano i avuuvau vainnee? ");
INSERT INTO waj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","tuduu rikioo vaidiivo reeti too tunoo: Na vaidiiya taukai yatari roosiikiaaya nookiaavaivee, ");
INSERT INTO waj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","tuduu rikioo Yisuuva keenaa ari yaakuuvaitana inna avuuvaitanau utuduu ivo ari avuuvaa puaisa tooduu avuuvaitana yoketauduu ivo mmuakiaa inneennavai kooyaa teeravai. ");
INSERT INTO waj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kooyaa tooduu Yisuuva inna tunoo: Ai nnauki safuuma viee sa yoosinnaivaki nookianee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama ivakidiri pikiada yoosinnaiyauvo Kaisariaa Piripii vainima vauyauvakira vida varida Yisuuva ari ngiaammuauya yaparainno tunoo: Gioonna kiaapuuya niiyara dee vaidivainnee kiaa kiada dataa kuaida kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","tuduu rikiada iya inna sai tunoo: Vooyaano kiaanoo: Yuvuaano nnoori apira vaidivaivee, kiaani vooyaano kiaanoo: Irayaavavee, kiaani vooyaano kiaanoo: Ari vo forofetaa vaidivaivee, kiaanoo, ");
INSERT INTO waj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","tuduu rikioo Yisuuva iya yaparainno tunoo: Mo ngieeta niiyara dataa kuaida kiaannee? tuduu rikioo Petorooso inna sai tunoo: A vaidi Anutuuqo i mmataama kiookuavee, ");
INSERT INTO waj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","tuduu rikioo yaagueeqama iya kiaa mmioo tunoo: Sa aa kua aavaa niiyara gioonna kiaapuuya kiaa mmiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yisuuva itaa kua kiaa kioo ari ngiaammuauya kua kooyaa kiaa mmioo tunoo: Na Vaidiivaa Mmaapuuvoono fai kaayau mmamma nniitareeraivaa varaanaravai. Fai vaidi yokovaiyaatama vaidi Anutuuqaara kati puara hudeera kieetaiyaatama Anutuuqaa kua mmaanna kiaa mmira vaidiiyaatama ni ooqoo tikiai vaidiiya ni ruputikiai na putino taaravooma suaivo taikanai na keenaa diitaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","kiaa kioo aa kua aavaa kooyaa iya kiaa mmuduu Petorooso inna vitoo mmaraa voovau oro kioo inna yaagueeqama tiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Inna yaagueeqama tuduu rikioo Yisuuva hanigia ari ngiaammuauya too Sataango Petoroosaa tasipoovaara yaagueeqa kuavai Petoroosaa tioo tunoo: Sataango, ngieera kuanee. I yaataivo vaidiiya yaataivaa roosiinoo. Hama Anutuuqaa yaataivo itaama vainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yisuuva itaa kua kiaa kioo gioonna kiaapuuyaata ari ngiaammuauyaatama tuduu innasi nnuduu iya tunoo: Fai gioonna kiaapu voovoono ni nnaagiai nninaree tioo fai ari yaata utira aataruuvaara ooqoo tioo gioonna kiaapuuya niiyara inna ruputikio na putuauneema ivo putinaraivaara ee-oo tioo ni nnaagiai ngiaivee. ");
INSERT INTO waj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Fai gioonna kiaapu voovoono ari mmatayaa variraivaara yaagueeqama yaata utuoonnonno fai yapooma hama ivo tupatupaa varinaraivootainaravai. Gioonna kiaapu voovoono hama ari mmatayaa variraivaara yaata utirainno niiyaraata ni mmayaayaivaaraatama putinaraivaara ee-oo tiivo fai tupatupaa variraivaa varaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Fai gioonna kiaapu voovoono ariiyara nnaasu yaata utuoo mmuakiaa mmatayaa diaa mminnamminnaiyauvaa varoonnonno hama tupatupaa variraivaara yaata utirainno putuoo fai dee irisai yoketaivaa Anutuuqaasidiri varaanarannee? Fai hama varaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Gioonna kiaapu voovoono hama yopeema irisai mminnaivaadiri Anutuuqaa mmioo tupatupaa variraivaa varaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aa variaa suai aavaki gioonna kiaapuuya kaayau koonnama varida hama Anutuuqaara yaagueeqakiaanoo. Aqaa suai aavaki fai gioonna kiaapu voovoono niiyaraata ni kuaivaaraatama inna mmamma maisainai fai yapooma Na Vaidiivaa Mmaapuuvo keenaa mmatayaa kava vara ranee tiee innara mmamma maisainaravai. Fai na ni Napoonna mmeekia ari vookaraivoota aangeraa yoketaiyaatama tiinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisuuva itaa kua kiaa kioo iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Fai gioonna kiaapu vooya aavaki variaiya hama putirama kiada varida teekio Anutuuqo gioonna kiaapuuyara diraivo ari yaagueeqaivaa tasipama tiinai teeda taaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yapooma yaaku saivai sainaidiri mmuaa suaivai taika kiooduu Yisuuva Petorooso Yakoopo Yuvuaanainna vitoo taapi hokobaivaura ngiarivana nnaasu viravai. Iya vidada oro ivau dida vaida tooduu Yisuunna mmammaivo hanigioo ari vookarairavai vauduu ");
INSERT INTO waj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","inna uyira rairaiyauvo poosainno pinaama mmannaammannairavai. Fai hama vaidi mmatayaa voovoono yopeema buruqa poosaivaa finino inna uyira raira poosaiyauvaa roosiinaravai. ");
INSERT INTO waj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Itaama vauduu Yisuunna ngiaammuau taaravoomaivaitana tooduu nnaaruaa vaidi putuuvaitana Irayaaya Musiiya Yisuunna tasipama kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iya kua tida varuduu Petorooso iya kuaivaa rikioo mmaraa kuaivaa Yisuunna kiaa mmioo tunoo: Nnoonna-o, ta aavaki variaunnano ti yoketainoo. Kii ta unnakua nnau taaravooma heekaaravee. Aini voovai heekada Musiinnani voovai heekada Irayaannani voovai heekaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","kiaa kioo ivoota ari tasipoovaitanaatama kaayau aatuukiaivaara Petoroosaa yaataivo vueennauduu rikioo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Itaa kua tuduu namaivo iya rummua apu kioo vauduu Anutuuqaa kuaivo nama aakiaidaadiri tuoo tunoo: Inna ni Maapu tuanaivovee. Innara na mmuduuya ruauvovee. Inna kuaivaa rikiaatee, ");
INSERT INTO waj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","tuduu akiairauduu buaa buaida tooduu hama taaravaitanaatauduu Yisuuva ari mmuaavai iya tasipama dioo vairavai. ");
INSERT INTO waj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dioo vauduu teeda diitada ivaatama taapiivau pikiada tiida varida Yisuuva yaagueeqama iya kiaa mmioo tunoo: Makee ngia taivaara sa gioonna kiaapuuya kiaa mmiatee. Na Vaidiivaa Mmaapuuvoono yapooma putuee kava diitanai teeda ngia makee taivaara gioonna kiaapuuya kiaa mmiatee, ");
INSERT INTO waj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","tuduu inna kuaivaa rikiada hama vo gioonna kiaapuuya kiaa mmirama kiada iya ngiari yapara ngiari yaparaida tunoo: Mo yapooma na putuee kava diitaanavee tii kua oyaivo dee kua oyaivainnee? ");
INSERT INTO waj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","kiaa kiada Yisuunna yaparaida tunoo: Anutuuqaa kua mmaanna kiaa mmira vaidiiya kiaanoo: Irayaavannaadee tauraa tiinaravai. Tiino Anutuuqo mmataama kioo vaidiivo nnaagiai tiinaravaivee, kiaa kuaivo aaniira iya itaa kua kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","tuduu rikioo Yisuuva iya kua sai tunoo: Kutaavai. Vaidi voovoono Irayaanna roosiivoono tauraa ngioo mmuakiaa mminnaivaa safuunaraivo nninoo. Mo Vaidiivaa Mmaapuuvaara tuu kuaivo dataamainno vainnee? Anutuuqaa kua fafaaraivo vainno ataa kua tunoo: Gioonna kiaapuuya Vaidiivaa Mmaapuuvaa mmamma nniitareeraivaa inna mmida innara ooqoo tida nniki rakammuaaravaivee, tuuvaara yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na ngii giaa ngii miaunoo. Vaa Irayaanna roosuuvo nnuduu gioonna kiaapuuya innara ngiari iikiatau mmoori maisaivaa iiravai. Anutuuqaa kua fafaaraivo vainno innara tuuvaa kaanaivaa iiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yisuuva ari ngiaammuau taaravoomaidootama tiida ngiari seena ngiaammuauyaatama sunaara tuma tooduu kaayau gioonna kiaapuuya ngiaammuauya suvuai kiooduu Anutuuqaa kua mmaanna kiaa mmira vaidiiyaata Yisuunna ngiaammuauyaatama ngiariiki ngiariiki kua yaagueeqama tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kua yaagueeqama tida varuu saivaatama mmuakiaa gioonna kiaapuuya tooduu Yisuuva tuuduu kaayauma nnikiaraida innasi seenada vida tunoo: Vainna ngiannannee? ");
INSERT INTO waj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","tuduu rikioo Yisuuva ngioo ari ngiaammuauya tunoo: Ngia aanii kuavaida iyaata kua yaagueeqama kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","tuduu rikioo vaidi voovoono gioonna kiaapuuya aakiaivakidiri inna avaivaa sai tunoo: Vitaira-o, ni maapuuvaa aakiaivaki mmagia maisaivo hara kioo varikio hama kua tiivaara na inna vitee aisi ngiaunoo. ");
INSERT INTO waj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Vo suai voovaki mmagia maisaivo inna ruputikio putuoo vainno avaivaa kiriti kiriti tikio taara kuaanuuvo tiikio yuku yaakuuvaa raduda tu kioo vaivai. Mmagia maisaivaa titaa kikio kuaiveera na i ngiaammuauya kiaukai hama iya yopeema titaavaivee, ");
INSERT INTO waj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","tuduu rikioo Yisuuva inna kuaivaa sai tunoo: Ngia makee variaa gioonna kiaapuuya hama ngia niiyara kutaavaivee tiraidaida koonnamaida variaanoo. Na hokoba suai ngii tasipama hara kiee variaukai hama ngia niiyara kutaavaivee kiaavai. Fai na naana suai ngii tasipama hara kiee varinanai ngia niiyara kutaavaivee kiaarannee? Na ngii tasipama hara kiee variee ngia ni kuaivaa rikiaaraivaara na faannaina variaunoo. Ngiaammuauvaa vitada niisi ngiatee, ");
INSERT INTO waj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","tuduu rikiada inna vitada innasi nniravai. Vitada nnuduu mmagia maisaivo Yisuunna too saivaata ngiaammuauvaa ruputuduu putuoo vainno hanigiaanigieennonno vauduu taara kuaanuuvo avaivakidiri tiiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yisuuva inna koonna tunoo: A taannano naana suai nnaakaraivo ataama variinnee? tuduu rikioo inna koova Yisuunna sai tunoo: Nnaakaraivo meediyaa ari itaama varivai. ");
INSERT INTO waj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Airi suai mmagia maisaivo ni maapuuvaa ruputu kiaanara iinno inna ruputu ikiana yapoo nnoorina ruputu yapaivai. Fai aikiooma yaagueeqaivo i tasipanai tiiyara boo tiee ti tasipanai ta yoketaama variaaravee, ");
INSERT INTO waj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","tuduu rikioo Yisuuva tunoo: A niiyara kiannanoo: Fai aikiooma yaagueeqaivo i tasipanai tiiyara boo tiee ti tasipaanaravee, kianna kua oyaivaa datai kuavainna a itaa kua kiannannee? Fai gioonna kiaapu voovoono Anutuuqaara kutaavaivee tioo fai mmuakiaa mmoori aataruuvaara tinara: Ni tasipaanavee tino rikioo fai inna tasipaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","tuduu rikioo nnaakaraivaa koova akiairauduu puaisakama kua tioo tunoo: Na kiisama aiyara kutaavaivee kiaunoo. A ni tasipanai na pinaama aiyara kutaavaivee tinaravee, ");
INSERT INTO waj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","tuduu rikioo Yisuuva gioonna kiaapuuya nnida iya suvuai kiaara uuvaa too mmagia maisaivaa yaagueeqama tunoo: A mmagia maisa hama yaata avainnaataikua varianna-o, na tinai ngiaammuauvaa aakiaivakidiri pikiee tiee kuanee. Sa keenaa innaki ngianee, ");
INSERT INTO waj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","tuduu rikioo mmagia maisaivo ngiaammuauvaa ruputuduu kai kai vuu vuu tuoo putuoo vainno hanigiaanigieenno vauduu mmagia maisaivo innakidiri vioo kieeravai. Vioo kiooduu ngiaammuauvo vaidi putiraiya roosiima vauduu gioonna kiaapu vooya tunoo: Vaa putivaivee, ");
INSERT INTO waj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","tuduu Yisuuva numa inna yaakuuvaudiri vararu utuduu diiteeravai. ");
INSERT INTO waj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Diitooduu Yisuuva gioonna kiaapuuya pikioo nnauvaki vioo kiooduu ari ngiaammuauya numa inna yaparaida tunoo: Mo dataama vaikioonno mmagia maisaivaa ta titaunnano hama kuainnee? ");
INSERT INTO waj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","tuduu rikioo Yisuuva iya sai tunoo: Yaaku vareeraivaara yaagueeqaira vaidiivoono fai aa mmagia maisa aavaa roosiivaa titano kuanaravai. Kumina vaidi voovoono fai hama yopeema titano kuanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama ii yoosinna ivaki pikiada tuma Karirayaa mmataivaki nuaida varuduu Yisuuva ari kua oyaivaa iya kiaa mminaraivaara iya vitoo nuairavai. Nuauduu gioonna kiaapuuya ivo kuanara kuaivaa rikieevoora ari ngiaammuauya nnaasu vitoo nuairavai. Vitoo nuainno varioo iya kiaa mmioo tunoo: Fai vaidi vooyaano Na Vaidiivaa Mmaapuuvaa ni vitada vaidi vooya mmikiai iya ni ruputikiai na putino taaravooma suaivo taikano Anutuuqo tinai na keenaa diitaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","tuduu rikiada hama iva tuu kua oyaivaa arinaima rikieerama kiada oyaivaara iya inna yapara kiaaraivaara aatuuravai. ");
INSERT INTO waj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Aatuuda iyaata Yisuuvaatama vidada yoosinna Kapanauma oro nnau voovaki dida vauduu Yisuuva ari ngiaammuauya yaparainno tunoo: Ngia aataruuvau nnida varida aanii kuavai ngiingiiiki ngiingiiiki yaagueeqama kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","tuduu rikiada iya kua seemuaa variravai. Vaa iya aataru tammaivau ngiari yapara ngiari yaparaida tunoo: Deevoono ari seenaiya yaataroo kieetavai varinarannee? tuuvaara iya hama inna kua sai tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hama inna kua sai tuduu Yisuuva hara kioo varioo ari ngiaammuau yaakuuvaitana yukukidiri taarama tuduu innasi nnuduu iya tunoo: Fai gioonna kiaapu voovoono ngii tauraavai varinaree tioo mmuakiaaya mmoori vareera ngiaammuauvai roosiima varioo nnaagiai tuanaavai varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","kiaa kioo nnaakaraivaa vitoo ngiari tammaivaki yapa kioo varau tu kioo vainno iya tunoo: ");
INSERT INTO waj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Fai gioonna kiaapu voovoono niiyara mmuduuya ruaivaara aa nnaakara aavaa roosii voovaara tuqinnaivoono inna niiyaraatama tuqinnainoo. Niiyara tuqinnaivoono hama niiyara nnaasu tuqinnaivai. Ni titoovaaraatama tuqinnaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tuduu Yuvuaano Yisuunna tunoo: Vitaira-o, ta taunnano vaidi voovoono i nnutuuvaa tioo vaidiiya aakiaakidiri mmagia maisaiyauvaa titaikiai kuaavai. Iqii vaidi ivo hama ti tasipama nuai vaidivaara tida ta innara ooqoo kiaunnavaivee, ");
INSERT INTO waj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","tuduu rikioo Yisuuva tunoo: Sa ivo ii mmooriivaara ooqoo kiatee. Vaidi voovoono ni nnutuuvaa tasipama Anutuuqaa mmoori ari vookaraama iira mmooriivaa iinno hama akiairaama niiyara maisavee tinaravai. ");
INSERT INTO waj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Gioonna kiaapu voovoono hama ti kuaivaara ooqoo tiivoono inna hama ti nnammutuaavai. Ivo inna ti seenavai. ");
INSERT INTO waj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na kua kutaavai ngii giaa ngii miaunoo. Na Yisuu Kirisiinna ngia ni nnaagiai nookiaivaara vaidi voovoono nnooriivaa vita ngii miivo fai irisai yoketaivaa varaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yisuuva itaa kua kiaa kioo kava tunoo: Aa nnaakara kiisa aaya niiyara kutaavaivee kiaa aaya roosiima gioonna kiaapu voovoono niiyara kutaavaivee tiivaa vaidi voovoono iva aataru yoketaivaa pikiaiveeraivaara inna yaparaivo inna aataru maisavai. Fai tauraa hama vaidiivo inna yaparaira suaivaki vaidiiya numa ivo nnaakaraivaa yaparainarainnoo kiaa sikau pinaivaa varada dutuyu inna nnuunaivaki haru kiada nnoori haruungaivaki kagaari kikio ivaki vainno putiivo inna aataru yoketaavai. ");
INSERT INTO waj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Itaama vaikio fai i yaakuuvaadiri a reeti utu reeri utinarainnoo kiaa ivaa mmuaanaa hatoka kiee kakumavai tasipama variee a tupatupaa variraivaa varaanaraivo inna yoketaavai. Fai i yaakuuvaitana vainai ikiaivo tupatupaa too variivaki kuanaraivo inna maisavai. Ikiaivo tupatupaa too variivaa hama vaidi voovoono yopeema rasuunaravai. ");
INSERT INTO waj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Ivaara Anutuuqaa kua fafaaraivo vainno tinoo: mmimmiiyauvo tupatupaa nuaikio ikiaivo tupatupaa too nnaasu variivaa hama vaidi voovoono yopeema rasuunaravee, tiivai.) ");
INSERT INTO waj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Fai i yukuuvoono i vitoo maisa aataruuvau nuainarainnoo kiaa mmuaanaa ivaa hatoka kiee mmanna apavai tasipama variee yapooma a tupatupaa variraivaa varaanaraivo inna yoketaavai. Fai i yukuuvaitana vaida ikiana i kagaari kiaaraivo inna maisavai. ");
INSERT INTO waj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Ivaara Anutuuqaa kua fafaaraivo vainno tinoo: Mmimmiiyauvo tupatupaa nuaikio ikiaivo tupatupaa too nnaasu variivaa hama vaidi voovoono yopeema rasuunaravee, tiivai.) ");
INSERT INTO waj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Fai i avuuvaadiri mminnamminnaa maisaivaa tee varaanarainnoo kiaa mmuaanaa i avuuvaa ranigaama kagaari kiee saivai huruutavai vainai yapooma Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuanaraivo inna yoketaavai. Fai i avuuvaitana vaida ikiana i kagaari kiaaraivo inna maisavai. ");
INSERT INTO waj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ivaara Anutuuqaa kua fafaaraivo vainno tinoo: Mmimmiiyauvo tupatupaa nuaikio ikiaivo tupatupaa too nnaasu variivaa hama vaidi voovoono yopeema rasuunaravee, tiivai. ");
INSERT INTO waj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gioonna kiaapuuya Anutuuqaara mmamma nniitaraivaa ikia teera roosiima varaivo yorokuuvaa haateeraivaa roosiivai. ");
INSERT INTO waj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yorokuuvo inna yoketaa mminnaavai. Fai yorokuuvo vainnonno maisainai fai ngia aaniivaadiri iikio kava yoketainarannee? Hama yopeemavee. Ngia yoroku yoketaa vaivaa roosiima varida ngii seenaiyaatama ngiingiiiyara ngiingiiiyara kua yoketaivaa tida ausa nuufa varada variatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisuuva ii yoosinna ivaki pikioo Yutayaa mmataivo nnoori Yorotaanaivaa sainai vaupinnai viravai. Vuduu rikiada keenaa gioonna kiaapuuya inna teeda innasi numa varuduu too ivo ari tirayaama kuaivaa iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kiaa mmuduu vaidi Farisai vooya innasi nnida ivo kuaivaa koonnama kiaiveera inna yaparaida tunoo: Vaidi voovoono ari nnaataivaara ooqoo tinara aataruuvo vainnee? Vara hama vainnee? ");
INSERT INTO waj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","tuduu rikioo Yisuuva sai iya yaparainno tunoo: Musiiva mmaanna tuu aataruuvo dee aataruvainno ngii giaa ngii muunnee? ");
INSERT INTO waj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","tuduu rikiada iya inna sai tunoo: Vaidi voovoono ari nnaataivaa pikiaanaree tioo ooqoo tira yanaivaa fafaara raa kioo inna mmioo titano kuaiveera kuaivaa Musiiva aikioovee kiaa kioo ee-oo tiravaivee, ");
INSERT INTO waj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","tuduu rikioo Yisuuva iya sai tunoo: Ngia vaidi Yutayaiya ngii ausa vuatinniiyauvo yaagueeqauvaara Musiiva ii aataru ivaara ee-oo tioo fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nnaaru Anutuuqo ngiau mmataivaa uu suaivaki hama ii aataru ivootairavai. Anutuuqaa fafaara roo kuaivo vainno ataa kua tinoo: Anutuuqo vaidiivaa iinno gioonnaivaa iiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ivaarainno fai vaidiivo ari kaano koovaitana pikioo nnaataivaa varoo ");
INSERT INTO waj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","inna tasipama mmuaakaraivaitana variaaravaivee, tiivai. Ivaitana hama taaravaitana varirama kiada mmuaavaitana variaavai. ");
INSERT INTO waj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anutuuqoono vaa taaravaitana nuunama kiaikiai mmuaavaitana variaivaitana sa vuaivo vuaivaa pikino sa vuaivo vuaivaa pikiaivee. Sa vaidi voovoono ivaitana vara mmarammaraama yapaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nnaagiai Yisuuva ari ngiaammuauyaatama nnauvaki varuduu rikiada ari ngiaammuauya iqii kua ivaara keenaa inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yapara ruduu rikioo Yisuuva iya sai tunoo: Vaidi voovoono ari nnaataivaara ooqoo kiaa kioo karaasa voovai varaikio mmuara vareera aataruuvo innaki vaivai. Ari nnaata tuanaivaara maisa aataruuvaa iivai. ");
INSERT INTO waj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Gioonna voovoono ari vaatiivaara ooqoo kiaa kioo vaidi voovai varaikio mmuara vareera aataruuvo innakiaatama vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yisuuva nnaakaraiya mmammaiyauvunu utuaiveera gioonna kiaapu vooyaano ngiari nnaakaraiya vitada innasi nnida varuduu inna ngiaammuauya iya ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ooqoo tuduu rikioo Yisuunna nnannatooduu ari ngiaammuauya tunoo: Pikikiai nnaakaraiya niisi ngiatee. Sa iya ooqoo kiatee. Nnaakaraivo kuaivaa rikioo ivaa iivaa roosiikiai gioonna kiaapuuya fai Anutuuqo gioonna kiaapuuyara diraivaki kuaaravai. Ivaara sa aa nnaakara aaya ooqoo kiatee. ");
INSERT INTO waj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na kua kutaavai ngii giaa ngii miaunoo. Nnaakaraiya akiairaama kuaivaa rikieeraivaa roosiima fai hama gioonna kiaapu voovoono inna roosiima iinno Anutuuqo gioonna kiaapuuyara diraivaara kutaavaivee tiivoono fai hama Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","kiaa kioo nnaakaraiya sootu utuoo iyayaa ari yaakuuvaitana utuoo tunoo: Anutuuqo ngii tasipaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yisuuva itaa kua kiaa kioo aataru ari rikioovau kuanee kiaa vuduu vaidi voovoono seenoo innasi ngioo inna yuku oyaivaki numa inna avunni dioo vainno toorivu yau hara kioo vainno inna yaparainno tunoo: Vitaira vaidi yoketaa-o, dee mmoorivai na iina tupatupaa variraivaa varaanarannee? ");
INSERT INTO waj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","tuduu rikioo Yisuuva inna sai tunoo: Aaniira niiyara yoketaavaivee kiannannee? Anutuuqo mmuaavoono nnaasu yoketaavai varinoo. Hama vaidi mmatayaa diaa voovoono yoketaavai varivai. ");
INSERT INTO waj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mmaanna tuu kuaivaa vaa a rikiaannavai. Sa gioonna kiaapu voovai ruputino putuaivee. A vaa nnaata vaati varaannaikua sa mmuara heera aataruuvaa iikianee. Sa voovai mminnaivaa mmuara varaanee. Sa unnakua kianee. Sa mmuara varee nakaaraivaa unnakua kianee. Ai kaano koovaitanaara tuqinnaanee, ");
INSERT INTO waj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tuduu rikioo ivo inna sai tunoo: Vitaira-o, vaa na ngiaammuau kiisayaa varia ree ngiee ngiee makee na yokeena aa mmuakiaa kua mmaanna aayauvaa tuqinnama iikiauvaivee, ");
INSERT INTO waj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","tuduu rikioo Yisuuva inna too vainno innara mmuduuya ruoo tunoo: Mmuaa aataruvai hama a iikiannavai. Diitee viee ai mminnamminnaa mmuakiaayauvai varee vaidi vooya mmiee irisai sikauyauvaa varee mmanna haipu gioonna kiaapuuya mmianee. Mminoonno i irisai yoketaivo ngiau aapu vainaravaivee. A iya mmi taika kiee ngiee ni nnaagiai nookianee, ");
INSERT INTO waj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","tuduu rikioo vaidiivo ari hoonahaanaiyauvo kaayauma vauyauvaara yaata utuoo nniki apu varoo hanigioo ausa mmuaararoovaa tasipama viravai. ");
INSERT INTO waj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Vuduu Yisuuva hanigia ari ngiaammuauya kiaa mmioo tunoo: Gioonna kiaapu kaayau hoona suvuaiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuaaree kiaa iikio kaayauma iya mmuaararaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","tuduu rikiada ari ngiaammuauya iva tuu kuaivaa rikiada nnikiaraida rikiooduu Yisuuva vo kuavai tunoo: Ni ngiaammuauso, gioonna kiaapuuya Anutuuqo iyara dira yoosinnaivaki kuaaree kiaa iikiaavo kaayauma iya mmuaararainoo. Puara pinaivaa nnutuuvo kameraivo kuatiri aataruuvaki kuanaree kiaa iikio inna mmuaararainoo. Gioonna kiaapu kaayau hoonahaana suvuaivo Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuanaree kiaa iikio kaayauma inna mmuaararainoo, ");
INSERT INTO waj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","tuduu rikiada ari ngiaammuauya pinaama nnikiaraida inna tunoo: Mo dataama vari gioonna kiaapuvoono Anutuuqaa yoosinnaivaki aikiooma kuanarannee? ");
INSERT INTO waj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","tuduu rikioo Yisuuva iya too vainno tunoo: Mmatayaa diaiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki hama yopeema ngiarinaidiri kuaaravai. Anutuuqoono tinai fai iya kuaaravai. Anutuuqo fai mmuakiaa mmoorivai aikiooma iinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tuduu rikioo Petorooso inna sai tunoo: Mo vaa ta ti gioonna nnaakaraata ti mminnaa mmuakiaayauvaatama pikiada i nnaagiai nookiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tuduu rikioo Yisuuva iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Fai niiyaraata ni mmayaaya yoketaivaaraatama gioonna kiaapu voovoono ari nnauvaa pikioo ari kata vayaiya pikioo ari nnunna nnayaiya pikioo ari kaano koovaitana pikioo ari nnaakaraiya pikioo ari mmataiyauvaa pikioo ");
INSERT INTO waj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","fai aa makee ta variaunna suai aavaki fai irisai iyauvaanikaraama kava kava kaayauneetu varoo nnauyauvaa varoo ari kata vayaiya vitoo ari nnunna nnayaiya vitoo ari kaanokiaiya vitoo ari nnaakaraiya vitoo mmataiyauvaa varaanaravai. Fai iyauvaa varanai ni kuaivaara vaidiiya mmoori maisaivaa inna mmikio kaayau mmuaararaivaatama varaanaravai. Fai yapooma nnaagiai variaara suaivaki ivo tupatupaa variraivaa varaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Aanna makee kaayau gioonna kiaapu tauraa variaiya fai nnaagiai variaaravai. Aanna makee kaayau gioonna kiaapu nnaagiai variaiya fai tauraa variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama Yerusareema aataruuvau vida varuduu Yisuuvannaadee tauraa vuduu iva hama aatuura kati Yerusareema vuuvaara ari ngiaammuauya nnikiarairavai. Nnikiarauduu gioonna kiaapu iya nnaagiai nnuuya aatuuravai. Aatuuda varuduu Yisuuva ari ngiaammuauya vitoo voovau kioo ngiari nnaasu sudu varida vaidiiya inna iikiaara mmooriivaara iya kiaa mmioo ");
INSERT INTO waj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","tunoo: Rikiaatee. Ta Yerusareema kuaara iikiaunnanoo. Ta ivaki vikio fai vaidi voovoono Na Vaidiivaa Mmaapuuvaa vaidi Anutuuqaara kati puara hudeera kieetaiyaata kua mmaanna kiaa mmiraiyaatama kooyaa ni vitainai iyaano na putinaraivaara kua yeena rau kiada ngiari voopinnaiya mmikiai ");
INSERT INTO waj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","iya niiyara raida kuaanuuvaa niiyaa visida ni ripiida ni ruputu kikiai na putinaravai. Na putino taara suaivaitana taikano vooma suaivaki Anutuuqo tinai na keenaa diitaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tuduu rikiada Sevetainna mmaapuuvaitana Yakoopaya Yuvuaanaya Yisuunnasi numa tunoo: Vitaira-o, ta titiiyara i yaparakiaunna kuaivaa tiini iikianee, ");
INSERT INTO waj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","tuduu rikioo Yisuuva ivaitana yapara ruoo tunoo: Na aaniivai ngiivaitanaani iikiaiveeraida ngia kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tuduu rikiada ivaitana inna sai tunoo: A gioonna kiaapuuyara dinaraivaki a tinai ta i tasipama variaaravai. Vuaivo i yaaku yaadudainningiaa varino vuaivo i yaaku geedainningiaa varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","tuduu rikioo Yisuuva sai tunoo: Ngia ni yaparakiaa kua oyaivaa hama arinaima rikiaanoo. Na nnoori toori kapikaraivaa nnaanara iikiauvakidiri ngieevaitanaata nnaarannee? Vaidiiya nnoori apira suaivaki nnooriivo iya rummua apu kiaineema mmamma nniitaraivo ni rummua apu kiaivaa ngieevaitanaata varaarannee? ");
INSERT INTO waj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","40","tuduu rikiada sai tunoo: Fai ta nneeda varaaravaivee, tuduu rikioo Yisuuva ivaitana sai tunoo: Aikioovai. Ni nnoori toori kapikaraivakidiri fai ngieevaitanaata nnaaravee. Vaidiiya nnoori apira suaivaki nnooriivo iya rummua apu kiaineema mmamma nniitaraivo ni rummua apu kiaivaa ngieevaitanaata varaaravee. Inna aikioovai. Vaidiivaitana vuaivo ni yaaku yaadudainningiaa varino vuaivo ni yaaku geedainningiaa varinaraivo hama na nakaaraivaa roosiima ee-oo tinai ivaitana variaaravai. Ii mmaata ivaitana ni Napoova vaidiiyani teerama kiaivaitana fai mminai varada variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nnaagiai ari ngiaammuau saido yaakuuvaitana Yakoopaya Yuvuaanaya tuu kuaivaa rikiooduu kaayauma ivaitanaara iya nnannateeravai. ");
INSERT INTO waj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nnannatooduu Yisuuva ari ngiaammuau mmuakiaaya aayanna tuduu innasi nnida nuunauduu iya tunoo: Vaa ngia taavai. Ngiari voopinnaiya kieeta vaidiiya ngiari seenaiyara yaagueeqama diaani ngiari nnoonnaiya iyara diaavai. ");
INSERT INTO waj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Itaama iikiaa aataruuvo sa ngiiiki vakiaivee. Ngiiikidiri vaidi voovoono ngii kieetavai varinaree tioo mmuakiaaya ngii mmoori vareera ngiaammuauvai varinaravai. ");
INSERT INTO waj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ngiiikidiri vaidi voovoono ngii tauraa varinaree tioo sikaunnaadiri yookaama kioo mmoori varaaneera viteera ngiaammuauvai roosiima varinaravai. ");
INSERT INTO waj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gioonna kiaapuuya ni mmooriivaa varaaraivaara hama Na Vaidiivaa Mmaapuuvo tiiravai. Na mmuakiaa gioonna kiaapuuya mmoori varee iya mminnamminnaa maisaiyauvaa irisaivaara putuee iya vitee yoketaivau yapaanaraivaara na tiiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama yoosinnaivaa nnutuuvo Yerikoo nnida tarada kaayau gioonna kiaapuuyaatama iya tasipama vida varuduu Timainna mmaapuuvaa nnutuuvo Batimiaava avu huruutavai aataru siriivau hara kioo varioo gioonna kiaapuuya sikaura ngiaaru tuoo variravai. ");
INSERT INTO waj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Varioo rikiooduu Yisuuva Nasareeta diaa vaidiivo nninoo tuduu rikioo innara aayanna roo tunoo: Davuitiinna oyaivakidiri diitaanna vaidi Yisuu-o, niiyara boo kianee, ");
INSERT INTO waj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tuduu rikiada gioonna kiaapu kaayauyaano inna yaagueeqama kua pikiaaneera tuduu rikioonnaata ivo puaisakama aayanna roo tunoo: Davuitiinna oyaivakidiri diitaannakuavee. Niiyara boo kianee, ");
INSERT INTO waj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","tuduu rikioo Yisuuva aataruuvau dioo vainno tunoo: Innara aayanna tikio ngiaivee, tuduu rikiada vaidi avu huruutauvaa tunoo: Sa yaata utira diitee kuanee. Iva aiyara tinoo, ");
INSERT INTO waj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","tuduu rikioo akiairauduu diitoo ari yaapa apu kioo varuuvaa rabara pikioo Yisuunnasi viravai. ");
INSERT INTO waj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Vuduu Yisuuva inna yaparainno tunoo: A aaniivai na i iikiaiveerainna kiannannee? tuduu rikioo ivo inna sai tunoo: Vitaira-o, na ni avu aavaa safuuma kava taanaraivaaraina i yaparakiaunoo, ");
INSERT INTO waj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","tuduu rikioo Yisuuva inna tunoo: Kuanee. A niiyara kiannanoo: Aikiooma ni tuqinnaanaravaivee, kiannaivaara a kati yoketaama hara kiee variannanoo, tuduu rikioo inna avuuvo makee tuduu tuqinnama tooduu Yisuunna nnaagiai aataruuvau viravai. ");
INSERT INTO waj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yisuuva ari ngiaammuauyaatama numa Yerusareema vainima nnida yoosinnaivaitana nnutuuvaitana Betepakee Betaniaa numa taapiivaa nnutuuvo Oriveeta ivau dida vauduu Yisuuva ari ngiaammuauvaitana titoo ");
INSERT INTO waj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tunoo: Oro ukuaa yoosinna ivaki vida teekio rikioo puara togii karaasa hama vaidiiya variaivo nnuunaivaki yeena harukiaivo ngii too vainai teeda rukuasaa kiada vitada niisi ngiatee. ");
INSERT INTO waj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Fai gioonna kiaapu voovoono ivaara ngii tinara: Ngia aaniira vitaannee? tinai kiatee: Udaangaivoono ivaa vitaateera ti titaikiai ta ngiaunnanoo. Ivo fai makee kava ti titanai ta kava vitada numa ai i mmiaaravaivee, kiatee, ");
INSERT INTO waj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","tuduu rikiada vida yoosinna vuuta idaa tooduu puara togiivaa sipu oyaivaki haru kioovo iya too vauduu rakuasada variravai. ");
INSERT INTO waj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Rakuasada varuduu gioonna kiaapu ivau duuya iya teeda tunoo: Mo ngia aaniivai iikiaaraida aa puara togii aavaa rukuasaannee? ");
INSERT INTO waj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","tuduu rikiada Yisuuva iya kiaa mmuu kuaivaa gioonna kiaapuuya kiaa mmuduu rikiada ee-oo tuduu vitada nniravai. ");
INSERT INTO waj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Vitada nnida ngiari yaapaiyauvaa togiivaa mmookaivau yapa kiooduu Yisuuva togiivaa mmookaivau karoo variravai. ");
INSERT INTO waj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Varuduu teeda kaayau gioonna kiaapuuya sirigaida varida vooya ngiari yaapaiyauvaa aataruuvau hooti kiooduu vooya oro mmooriivakidiri yatari hammaraiyauvaa rakau utida numa aataruuvau hootiravai. ");
INSERT INTO waj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hooti kiooduu gioonna kiaapu Yisuunna tauraa vuuyaata inna nnaagiai vuuyaatama aayanna raa rada tunoo: Anutuuqo yoketaivovee. Udaanga Anutuuqo inna titooduu tuuvo nninaraivaara ivo innara yoketaakiaivee. ");
INSERT INTO waj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ti rubuungo Davuitiiva tiiyara duneema iva tiiyara dinaraivaara Anutuuqo yoketaakiaivee. Anutuuqo ngiau aapu variivo yoketaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tuduu Yisuuva Yerusareema vioo vioo oro nuunaira nnau pinaivaki vioo mmuakiaa inneennavai haitatuunno varuduu rikioo upisiinno ukuapidi aapidiinno varuduu rikioo ivo ari ngiaammuau yaakuuvaitana yukukidiri taaramaatama vitoo yoosinna Betaniaa ivakira viravai. ");
INSERT INTO waj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Vidada oto Betaniaa vuru vauya patauduu ivaki pikiada kava vara ranada Yerusareema nnida varuduu Yisuunna yeenna rauduu ");
INSERT INTO waj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ngieeradiri dioo vainno rooru tooduu yatari nnaammuayaivaa roosuuvaa apuuvaa too oro iiraiyauvo vainoo kiaa tooduu hameetauduu mmanna apuuyauvo nnaasu vairavai. Hama nnaammuayaivo iira vaira suaivootauvaara mmanna apuuyauvo nnaasu vairavai. ");
INSERT INTO waj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Vauduu Yisuuva yatari nnaammuayaivaa tunoo: Tupaa itaavai vakianee. Fai hama vaidi voovoono keenaa i iiraivaa rasuku nnaanaravaivee, tuduu ari ngiaammuauya inna kuaivaa rikieeravai. ");
INSERT INTO waj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Rikiada Yisuuvaatama Yerusareema vuduu ivo nuunaira nnau pinaivaki vioo gioonna kiaapuuya ngiaammaiyauvaata puara sipisiipaiyauvaatama vooya mmida irisai yookaa varooyaatama gioonna kiaapuuya sikau yookaama kiada irisai varooyaatama yaagueeqama titooduu mmaanai viravai. Vuduu ivo vaidi vooya sikau yanaiyauvaa kiooduu irisai sikau mmuyaiyauvaa mmuuya parapaaraiyauvaa rauru sereguatiima kioo vaidi vooya ngiaamma mirunnaiyauvaa varau yapa kiada vooya mmida irisai yookaa varooya mmaata variraiyauvaatama rauru sereguatiima kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sereguatiima kioo iya tunoo: Sa kava mminnaiyauvaa varada nnau aakiaa aadaa vida nnida kiatee, ");
INSERT INTO waj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","kiaa kioo gioonna kiaapuuya kiaa mmioo tunoo: Anutuuqaa kua fafaara roovo vainno tinoo: Ni nnauvo mmuakiaa gioonna kiaapuuya yaaku vareera nnauvaivee. Anutuuqo itaa kua tikiainnaataida ngia mmuara furaiya iirayaama aavaki iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tuduu rikiada vaidi Anutuuqaara kati puara hudeera kieetaiyaata vaidi kua mmaanna kiaa mmiraiyaatama Yisuuva itaama uuvaara rikiada inna ruputuaaree kiaa iiravai. Gioonna kiaapuuya iva tuu kuaivaara nnikiaraida varuuvaara iya Yisuunnara aatuuda pikieeravai. ");
INSERT INTO waj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yisuuva ari ngiaammuauyaatama hannauduu rikiada ii yoosinna ivaki pikiada viravai. ");
INSERT INTO waj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Vidada oto vauya patauduu kava vara ranada aataruuvau nnida tooduu nnaammuayaivaa nnaa hammara tuukaiyauvo eeyaa aasannama taika kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Taika kiooduu Petorooso Yisuuva uuvaara yaata utuoo inna tunoo: Vitaira-o, taanee. Nnaammuayaivaa a kiannaivo vaa kutaa aasannama kiainoo, ");
INSERT INTO waj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","tuduu rikioo Yisuuva ari ngiaammuauya tunoo: Aanna makee ngii avuuvau iikiauvaa teeda ivaara yaata utida Anutuuqaara kutaavaivee kiatee. ");
INSERT INTO waj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na kua kutaavai ngii giaa ngii miaunoo. Fai gioonna kiaapu voovoono aa taapi aavaa tinara: Tavagiauruee nnoori haruungaivaki kuanee, kiaa kioo fai ari tii kuaivaara hama ivo taara yaata utuoo ivaara Anutuuqo kutaa iinaravee tino too fai Anutuuqo iinaravaivee. ");
INSERT INTO waj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ivaaraina na ngii giaa ngii miaunoo. Fai ngia yaaku varada mminnaa voovaara Anutuuqaa yaparaida kiaara: Fai kutaa ta varaaravee, tida fai ngia varaaravai. ");
INSERT INTO waj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ngia yaaku vareera suaivaki gioonna kiaapuuyara ngii nnannateenai ivaara sa yaata utiraida ngiingii ausa mmuduuyaiyauvaa iya mmiatee. Ngii Gioova ngiau aapu variivo irisaivaa ngii mminnamminnaa maisaiyauvaara hama yaata utirainno fai rugaanaraivaara iyara itaama iikiatee. ");
INSERT INTO waj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Fai ngia hama ngii ausa mmuduuyaiyauvaa iya mmiraida homo yaata utikio ngii Gioova ngiau aapu variivo hama ngii mminnamminnaa maisaiyauvaa rugaanaravaivee,) tiravai. ");
INSERT INTO waj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yisuuva ari ngiaammuauyaatama Yerusareema nnidada ivo ngioo nuunaira nnau pinaivaki nuainno varuduu vaidi Anutuuqaara kati puara hudeera kieetaiyaatama kua mmaanna kiaa mmiraiyaata vaidi yokovaiyaatama innasi nnida ");
INSERT INTO waj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","inna yaparaida tunoo: Gioono i tikiainna aa mmoori aayauvaa a iikiannannee? Dee vaidi kieetavoono i tikiainna a iikiannannee? ");
INSERT INTO waj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","tuduu rikioo Yisuuva iya sai tunoo: Kii neeta vo kuavaara ngii yaparainai fai ngia ni sai tikiai fai na ivo ni tikiai na iikiauvaara kooyaa ngii giaa ngii minai ngia rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ni giaa ni miatee. Gioono tuduu Yuvuaano nnoori apira vaidiivo gioonna kiaapuuya nnoori apuunnee? Vo Anutuuqoono tuduunno uunnee? Vara vaidiiyaano tuduunno uunnee? ");
INSERT INTO waj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","tuduu rikiada iya ngiariiki ngiariiki yaparaida tunoo: Ta dee kuavai sai kiaarannee? Fai ta inna sai kiaara: Anutuuqoono tuduu Yuvuaano iiravaivee, tikio rikioo mo fai ivo ti sai tinara: Mo ngia aaniira hama inna kuaivaara kutaavaivee tiravainnee? tinaravai. ");
INSERT INTO waj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Fai ta kiaara: Vaidiiyaano tuduu Yuvuaano iiravaivee, tikiai fai gioonna kiaapuuya ti kiaaravaivee, tiravai. Mmuakiaa gioonna kiaapuuya Yuvuaanaara tunoo: Vaidi forofetaivovee, tuuvaara vaidi kieetaiya gioonna kiaapuuyara aatuuravai. ");
INSERT INTO waj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iya itaa kua kiaa kiada Yisuunna kuaivaa sai tunoo: Hama teeta taunnavaivee, tuduu rikioo Yisuuva iya sai tunoo: Hama ngia ni kuaivaa sai kiaivaara fai na hama ngii kuaivaa sai tinaravai. Ivo ni tikiai na mmooriivaa iikiau oyaivaa fai hama na ngii giaa ngii minaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yisuuva mmatayaa diaa mminnaiyauvunudiri mmataama kioo vaidi kieetaiya tunoo: Vaidi voovoono ari vuaina mmooriivaa vara kioo hanikiaivaa rau kioo hauyauvaa utu kioo ari vuaina iiraiyauvaa kagigainara soopaivaa hanuu teerama kioo ari mmoorira haitatuura saasaaya nnau hokobaivaa heeka kiaivai. Heeka kioo vaidiiya inna mmooriivaara haitatuuda iira vooyauvai ngiari mmoori varaa irisaiyauvaa ngiariyara varaateeraivaara iya kiaa mmi kioo ngieera vo yoosinnaipi varinara kuaivai. ");
INSERT INTO waj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Vioo vioo oro ngieera yoosinnaivaki hara kioo varioo yapooma vuaina iiraiyauvaa rasukuaara suaivo nnikio mmoori nakaaraivo ari mmoori vareera ngiaammuauvaa vuaina mmooriivaara haitatuura vaidiiyasi titaikio vuaina iira vooyauvai varaanara kuaivai. ");
INSERT INTO waj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kuaikiai teeda vuainaivaara haitatuukiaiyaano akiairaikiai inna utu kiada vaida iya pinaama inna ruputida inna ripiida vuaina iiraiyauvaa irisaiyauvaa hama inna mmirama kiada kati titaa kiaavo nniivai. ");
INSERT INTO waj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ivo nnikio mmoori nakaaraivoono kava ari ngiaammuau voovai titaa kiaikio kuaikiai teeda inna vuakieetaivaa rida ruannamooqama kiada kaayau kuakuaakua maisaivaa inna tida hama innara yoketaakiaavai. ");
INSERT INTO waj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mmoori nakaaraivoono kava ari ngiaammuau voovai titaa kiaikio kuaikiai teeda inna ruputu kiaavo putivai. Ivo makemakee ari ngiaammuauya titoo varikiai vooya rida rubanikaiya vara ranada ngiaani aavata ruputuaiya putuaavai. ");
INSERT INTO waj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mmoori nakaaraivo ngiaammuaura buaama taikio kuminaikio rikioo ivo nnaagiai yaata utuoo ari mmaapu mmuaa tuanaa innara mmuduuya ruaivaa titoo tinoo: Ni maapu mmuaa tuanaavai. Fai na inna titaa kino vinai rikiada inna kuaivaa arinaima rikiada hama inna ruputuaaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kiaa kioo inna titaa kiaikio kuaikiai teeda mmooriivaara haitatuukiaiyaano inna teeda ngiari kiaa mmi ngiari kiaa mmiida kiaanoo: Ari koonna mminnaa mmuakiaayauvai varaanaraivoonno aa nninoo. Nnikiai ta inna mminnaa mmuakiaayauvai varaaraivaara inna ruputikio putuaivee, ");
INSERT INTO waj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","kiaa kiada ruputu kiada inna mmammaivaa hanikia mmaanai kagaari kiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yisuuva ii kua ivaa kiaa taika kioo vaidi kieetaiya yaparainno tunoo: Mo mmoori nakaaraivo fai dee mmoorivai iinarannee? Fai ivo numa vuainaivaara haitatuukiaiya ruputu kinai putikio ari vuaina mmooriivaa vaidi vooya mminai haitatuukiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Anutuuqaa kua fafaaraivo vaivaa vaa ngia yaarida rikiaavai. Fafaaraivo vainno tinoo: Sikau nnau heekeeraiyaano sikau voovai teeda maisavaivee kiaa kiada pikiaavai. Yaagueeqa yatariivaa pupukiaivaa mmaara hara kiaa kuabaivaa roosiima ii sikau ivo nnau ipunnaivaki vaivo inna yoketaavai. ");
INSERT INTO waj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Udaanga Anutuuqoono iira mmoorivai. Ta taunnano inna mmooriivo yoketainno ari vookarainoo. Fafaaraivo vainno itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","tuduu rikiada Yutayaiya kieetaiya Yisuuva iyayaadiri mmataama kioo tuu kuaivaa rikiada inna utida ruputuaaree kiaa kiada tooduu gioonna kiaapuuya innara mmuduuya ruduu rikiada aatuuda pikiada viravai. ");
INSERT INTO waj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Vaidi Farisaiyaata vaidi Herootaa nnaagiai nuairaiyaatama ngiari seena vooya Yisuunnasi titooduu iya innasi tiida ivo kuaivaa koonnama tioo haruruaiveera kuaiyauvaa inna yapara ruaara viravai. ");
INSERT INTO waj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Vida inna tunoo: Vitaira-o, vaa ta i taunnavai. A kua kutaa tira vaidikuavee. Gioonna kiaapuuya aiyara yaata utuaivaara hama a pinaama yaata utuannavai. Vaidi kieetaiyaraata vaidi kuminaiyaraatama a mmuaavaugiataama yaata utuannaivaara iya aiyara yaata utuaivaara hama a pinaama yaata utuannavai. A Anutuuqaa mmoori aataruuvaa safuuma mmuakiaa gioonna kiaapuuya kiaa mmiannakuavee. Ta vo kuavaara i yaparaikiai sai ti kiaa ti mmianee. Roomaaya kieetaivaasi ta sikau takiisa yapaara aataruuvo yoketaa aataruvainnee? ");
INSERT INTO waj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Fai ta yapaarannee? Vara hama yapaarannee? tuduu rikioo Yisuuva iya inna iida taaree kiaa uuvaa vaa ivo too rikioo iya tunoo: Ngia aaniira ni iida taaree kiaa numa ni iikiaannee? Sikau mmuyai voovai varada numa ni vitaikiai na taanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","tuduu rikiada sikau mmuyai voovai varada numa inna vitauduu too Yisuuva iya tunoo: Aanna giaa kieetavai mmannammannaavainno vainnee? Aanna giaa nnutuvainno vainnee? tuduu rikiada inna sai tunoo: Mo Roomaaya kieetaivaa mmannammannaivoota inna nnutuuvootama ivau vainoo, ");
INSERT INTO waj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","tuduu rikioo tunoo: Mo Roomaaya kieetaivaa mminnaiyauvaa safuuma ari mmiatee. Mo Anutuuqaa mminnaiyauvaa safuuma ari mmiatee, tuduu rikiada iya iva tuu kuaivaara kaayauma nnikiaraida yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Vaidi Satuukaiya vaidi putuuyara tunoo: Fai hama kava diitaaravaivee, tuuyakidiri vooya numa Yisuunna yaparaida tunoo: ");
INSERT INTO waj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Vitaira-o, Musiiva vo aataruvai tiiyara fafaara roo tunoo: Vaidi voovoono nnaataivaa vara kioo hama nnaakaraivaa mmateerainno putino ari nnaataivo variivaa ari kataivoono vara kioo ari vayaannara tuoo nnaakaraiyauvaa mmataanaravaivee. Musiiva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Vo suai voovaki kata vayaa yaaku saivai sainaidiri taaravaitana varuuya ngaruuvoono nnaata vara kioo hama nnaakara mmateerama kioo kati putiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Putuduu ngamiisaivo inna muaadaivaa vara kioo hama nnaakara mmateerama kioo kati putuduu yaaguaavaano inna muaadaivaa vara kioo hama nnaakara mmateerama kioo kati putuduu ");
INSERT INTO waj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","mmuakiaa kataunna nnaagiaidootama mmuai gioonnaivaa vara kiada mmuaikaraama putiravai. Putuduu nnaagiai tuanaa gioonnaivootama putiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Itaama vaikiai yapooma gioonna kiaapu putuaiya kava diitaara suaivaki fai gioonnaivo giaa nnaatavai varinarannee? Mo yaaku saivai sainaidiri taarama ii vaidi idoono inna vareeravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tuduu rikioo Yisuuva iya sai tunoo: Ngia koonnama yaata utida itaa kua kiaanoo. Mo aaniira ngia itaa kua kiaannee? Ngia hama Anutuuqaa fafaara roo kuaivaa arinaima rikiada hama inna yaagueeqaivo vaivaa tuqinnama taivaaraida ngia koonnama yaata utida itaa kua kiaanoo. ");
INSERT INTO waj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Fai gioonna kiaapu vaa putuaiya diitaara suaivaki kava diitada hama nnaata vaati varaaravee. Fai iya aangeraiya ngiau aapu variaiya roosiima variaaravee. ");
INSERT INTO waj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gioonna kiaapu vaa putuaiya kava diitaaraivaara Musiinna yanaivau vai kuaivaa vaa ngia yaarida rikiaavai. Nnaaru yatari kiisaivaki ikiaivo tooduu hama yatari apuuvaa taa tamooqoovakidiri Anutuuqo Musiinnaata kua tioo tunoo: Na i nnaakukiaiya Aaparahaamo Isaako Yakoopainna Anutuuqovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Vaidi taaravooma nnaaru putuuya inna avuuvau homo varuuvaara Anutuuqo itaa kua tiravai. Anutuuqo gioonna kiaapu vaa eeyaara putuaiya hama iya Anutuuqovee. Gioonna kiaapu variaiya Anutuuqovee. Ngia kaayauma kumimakamaida yaata utuaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tuduu vaidi kua mmaanna kiaa mmira voovoono Yisuuva vaidi Satuukaiyaata kua tuuvaa rikioo iva iya arinaima sai tuu kuaivaa rikiooduu inna yoketauduu rikioo vo kuavaara numa inna yaparainno tunoo: Dee kua mmaannavoono mmuakiaa kua mmaanna tiraivaa yaatarainnee? ");
INSERT INTO waj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","tuduu rikioo Yisuuva inna kua sai tunoo: Aa kua na tinara kua aavo mmuakiaa mmaanna tira aataruuyauvaa yaatarainoo. Anutuuqaa kua fafaaraivo vainno tinoo: Isarairaayaso, rikiaatee. Udaanga ti Anutuuqo ari mmuaa tuanaavai nnaasu varinoo. ");
INSERT INTO waj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","I Udaanga Anutuuqaara mmuduuya ruee ai ausa mmuduuya mmuakiaavai inna mmianee. Ai vaidi kaanaivaatama ai yaata vuatinniivaata ai yaagueeqaivaatama mmuakiaavai inna mmianee, ");
INSERT INTO waj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","tikio inna inanoo kua mmaanna tuuvo vainno tinoo: E aiyara tuqinnaannaneema ai seenaiyaraatama tuqinnee iyara mmuduuya ruanee. Aa kua mmaanna tuu aavaitana mmuakiaa kua mmaanna tuuyauvaa yaataraivaivee, ");
INSERT INTO waj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","tuduu rikioo kua mmaanna kiaa mmira vaidiivoono Yisuunna tunoo: Vitaira-o, aikioovai. A kua kutaavainna kiannanoo. Udaanga Anutuuqo mmuaa tuanaavai varinoo. Hama ari vo anutuuvoovootaivai. ");
INSERT INTO waj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ivaarainno gioonna kiaapu voovoono Udaanga Anutuuqaara mmuduuya ruoo ari ausa mmuduuya mmuakiaavai inna mmioo ari yaata vuatinni mmuakiaavai inna mmioo ari yaagueeqa mmuakiaavai inna mmiaivee. Iva ariiyara tuqinnaineema ari seenaiyaraatama tuqinnoo iyara mmuduuya ruaivee. Aa taara mmaanna tuu aataru aavaitana ta rikiada iikiaunnaivo inna yoketaavai. Aa aataru aavaitanaano nnaaru Anutuuqaara kati puara sipisiipaiyauvaa hudoo aataruuvaa yaataraivaivee, ");
INSERT INTO waj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","tuduu rikioo Yisuuva ivo tinniyaadiri kua tuuvaa rikioo inna kua sai tunoo: Anutuuqo gioonna kiaapuuyara diraivaa a varaanaivaarainna e muaraagainna kiisa suai varaanarainna iikiannanoo, tuduu rikiada nnaagiai hama kava vaidi voovoono yopeema vo kua vooyauvaara inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisuuva homo nuunaira nnau pinaivaki gioonna kiaapuuya kuaivaa kiaa mmioo varioo tunoo: Mo dataama kiada kua mmaanna kiaa mmira vaidiiya kiaanoo: Vaidi Anutuuqo mmataama kioovo Davuitiinna oyai tuanaivakidiri diitoovovee, kiaannee? ");
INSERT INTO waj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nnaaru Mmannasa Yoketaivoono Davuitiinna tasipama varuduu Davuitiiva kuaivaa fafaarainno tunoo: Udaanga Anutuuqoono ni Udaangaivaa tunoo: A ni yaaku yaadudainningiaa vaidi nnoonnavai varianee. Varia ree vinanai na tinai fai a ai nnammutuaiya yaatara kiaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davuitiivaano fafaara roo itaa kua Anutuuqo mmataama kioo vaidiivaara tunoo: Ni Udaangaivovee, tuuvaara hama Anutuuqo mmataama kioo vaidiivo Davuitiinna oyaivakidiri nnaasu diiteeravaivee. Yisuuva itaa kua tuduu rikiada gioonna kiaapu kaayauya inna kuaivaa rikiooduu iya yoketauduu inna kuaivaa rikiada nnaasu variravai. ");
INSERT INTO waj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Varuduu Yisuuva kuaivaa iya kiaa mmioo varioo tunoo: Kua mmaanna kiaa mmira vaidiiya iira aataruuyauvaa tuqinnama haitatuuma teeda sa iya roosiima iikiatee. Iya buruqa hokobaiyauvaa rau varada gioonna kiaapuuya yeenna yookaira mmatuuya vuutaiyauvaki nuaikiai iya teeda iyara vaidi nnoonnayavee kiateeraivaara nookiaavai. ");
INSERT INTO waj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iya nuunaira nnauyauvaki vida mmaata yoketaiyauvunura nnaasu mmuduuya rida variaavai. Iya buusaiyauvaa nneera suaiyauvaki kieetaiya varira mmaataiyauvunura nnaasu mmuduuya rida variaavai. ");
INSERT INTO waj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iya oro gioonna muaadaiya unnakua nnammari kuaivaa tida iya mminnamminnaiyauvaa ngiariiyara kati vara kiada nnaagiai oro mmanna avaiyauvakidiri hokobama yaaku varaavai. Iya itaama iikiaivaara ngiari irisai pinaa maisaivo vainaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisuuva itaa kua kiaa kioo numa nuunaira nnau pinaivaki varioo kati Anutuuqaara yapeera sikau nnaamuruuvaa vainima hara kioo varioo tooduu kaayau gioonna kiaapuuya ngiari sikauyauvaa sikau nnaamuruuvaki yapada varuduu teeravai. Iva iya too vauduu rikiada gioonna kiaapu kaayau hoona suvuauya numa kaayau sikauyauvaa yapeeravai. ");
INSERT INTO waj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Yapa kiooduu ivo too vauduu mmanna haipu gioonna muaada voovoono numa sikau kiisa kookeevaitana yapa kiooduu sikauvaitana hama pinaavai vairavai. Kiisakiata vairavai. ");
INSERT INTO waj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Vauduu too Yisuuva ari ngiaammuauya maavee tuduu innasi nnuduu iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Aa gioonna muaada mmanna haipu gioonna aavaa sikau kiisa yapa kiaivaitanoono mmuakiaa gioonna kiaapuuya sikau nnaamuruuvaki yapa kiaa sikauyauvaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gioonna kiaapu hoona suvuaiya kaayau sikau vaiyauvakidiri vooyauvai nnaasu varada yapa kiaavo gioonnaivo hama sikaunnaataivo mmuakiaa sikau innasi vaivaitana eyommaa varoo yapa kiaivai. Iva ari yeenna varaanee tii sikau eyommaakiatatana varoo sikau nnaamuruuvaki yapa kiaivaara inna sikauvaitanaano gioonna kiaapuuya yapa kiaa sikauyauvaa yaataraivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yisuuva nuunaira nnau pinaivakidiri vioo varuduu ari ngiaammuau voovoono inna tunoo: Vitaira-o, taanee. Aa sikau nnau aayauvoota sikauyauvootama yoketaa tuanaa pinaayauvaivee, ");
INSERT INTO waj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","tuduu rikioo Yisuuva inna sai tunoo: Aqaa nnau pinaa nnau aayauvaa vaa a taannanoo. Fai vaidiiya mmuakiaa aa nnau aayauvaa havarata taika kikio rikioo fai hama seena sikau voovai ari seena sikau voovai mmaataivau tasipama vainaravaivee. Fai mmuakiaavai havarata taikaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama nuunaira nnau pinaivaa pikiada ukuapi taapi Oriveeta oro hara kiada varuduu Petorooso Yakoopo Yuvuaano Adiriaasainna ngiarivana innasi vida inna tunoo: ");
INSERT INTO waj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ti kiaa ti mmianee. A kianna kuaivo daira suai vainarannee? Dee ari vookarai mmoorivai vainai fai ta teeda mmuakiaa kua a kiannaivaara yaata utida kiaara: Vainima vainaravee, kiaarannee? ");
INSERT INTO waj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","tuduu rikioo Yisuuva iya sai tunoo: Vaidi voovoono ngii unnakua kiaa kioo aataru maisaivau ngii vita yapeenoora tuqinnama haitatuukiatee. ");
INSERT INTO waj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Fai kaayau vaidiiya mmuaavai mmuaavai nnida ni nnutuuvaa ngiariiyara tida voovoono tinara: Aanna Anutuuqo mmataama kioo vaidiivoona ngiaunoo, tinai fai kaayau gioonna kiaapuuya iya unnakua kiaivaa rikiada kiaara: Kutaa kuavaivee, kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Fai gioonna kiaapuuya vainiivau rapiraivaa rikiada ngieera rapira mmayaayaivaa rikiada sa ivaara nnikiaraida aatuukiatee. Rapiraivonanaa tauraa vaino too ngiau mmata taikeera suaivo fai hama makee tino nninaravaivee. ");
INSERT INTO waj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Fai gioonna kiaapu voovaki variaiya diitada gioonna kiaapu voovaki variaiyaatama rapuaaravai. Fai vo kieeta voovoono diitoo vo kieetavaata rapinara iinai rikiada fai ngiari gioonna kiaapuuya rapuaaravai. Fai vo mmata vo mmata mmataa kuaru utinaravai. Fai vo yoosinna vo yoosinnaiyauvaki aarareeraivo vainai rikiada gioonna kiaapuuya kaayauma yeennara kiaaravai. Gioonnaivo nnaakaraivaa mmataanara suaivaki kiisama nniitareeraivaa varoo nnaagiai pinaama nniitareeraivaa varaivai. Ivaa roosiima ii aataru iyauvo nninara suaivaki tauraa kiisavai vainno nnaagiai fai pinaavai vainaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ngiengieenoo ngiingiiiyara tuqinnama haitatuukiatee. Fai vaidi vooya ngii vitada ngiari kieetaiyasi kua pinaana ngii yapaaravai. Fai iya ngii vitada ngiari nuunaira nnauyauvaki yapa kikiai vaidiiya ngii ripiikiaaravai. Ngia niiyara kutaavaivee kiaivaara iya ngii vitada vaidi kieetaiyasi vida kua pinaana ngii yapa kikiai fai ngia ni mmayaaya yoketaivaa vaidi kieetaiya kiaa mmiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tauraa gioonna kiaapuuya ni mmayaaya yoketaivaa mmuakiaa mmata variaiya kiaa mmi taika kikio nnaagiai ngiau mmataivo taikaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Fai vaidiiya ngii vitada kua pinaana ngii yapa kikiai sa ngia iya sai kiaara kuaivaara mmuaanaa yaata utida tauraa teerakiatee. Kua pinaana ngii yapeera suaivaki Anutuuqo ngia sai kiaara kuaivaa ngii yaatana yapanai rikiada ivaa sai kiatee. Ngia sai kiaara kuaivo hama ngiengieenoo kiaaravai. Fai Mmannasa Yoketaivoono ngii giaa ngii minai kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Vaidi vooyaano fai ngiari kata vayaiya vitada vaidi vooya mmikiai iya ruputikiai putuaaravai. Fai vaidiiya ngiari uru nnaakaraiya vitada vaidi vooya mmikiai ruputikiai putuaaravai. Fai nnaakaraiya ngiari kaano kooya mmooka hanigia mmida iya ruputuateeraivaara vitada vaidi vooya mmiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ngia niiyara kutaavaivee kiaivaara gioonna kiaapu kaayauya ngii teeda hama ngiiiyara mmuduuya ruaaravai. Fai gioonna kiaapu voovoono niiyara kutaavaivee tioo yaagueeqainono ari putira suaivaki Anutuuqo inna vitoo yoosinna yoketaivaki yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Gioonna kiaapuuya aa na tinara kua aavaa yaarida arinaima rikiaatee. Fai ngia teekio mminnaa maisa ari vookaraivo hama ivo diraivaki fai dioo vainaravai. Fai ivo dioo vainai teeda ngia Yutayaa variaiya ngiingii yaatu aatuuda taapiivaura seenada kuatee. ");
INSERT INTO waj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Fai gioonna kiaapu voovoono ari nnauvaa vainiivau iikiaivo sa ari mminnamminnaiyauvaa varaanara nnauvaki kuaivee. ");
INSERT INTO waj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Fai gioonna kiaapu voovoono ari mmooriivaki iikiaivo ari yaapaivaa mmoori tooyaivau yapa kiaivaa sa kava vara ranoo vioo ivaa varaivee. ");
INSERT INTO waj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Boo, ii suai ivaki gioonna nnaakara sunnaakiaiyaata gioonna nnaakara meedi ruaiyaatama kuaaraivo iya mmuaararainaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Vati pinaa rira suaivaki vivoora kiaa yaaku varaatee. ");
INSERT INTO waj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Iqii suai ivaki kaayau maisa mmuaararaivo ari vookaraivai vainno mmuakiaa mmuaararaiyauvo gioonna kiaapuuyaki vaiyauvaa yaataraanaravai. Nnaaru Anutuuqo ngiau mmata uu suaivaki varuuya varia rada nnidada makee aa suai ta variaunnaivaki variaiya hama kaayau maisa mmuaararaivo itaama vaivaa taavaivee. Fai yapooma variaaraiya hama itaama vai mmuaararaivaa taaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iqii suai ivaara Udaanga Anutuuqo paanna suaivai mmataama kioo tiravai. Fai hama paanna suaivaa yapa kinai fai gioonna kiaapuuya putu taikaaravai. Anutuuqo gioonna kiaapu ariiniee kiaa mmataama kiooyara yaata utuoo suaivaa paannavai yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Fai iqii suai ivaki gioonna kiaapu voovoono ngii tinara: Taatee. Anutuuqo mmataama kioo vaidiivo aavaki varinoo, tinai sa inna kuaivaa rikiaatee. Fai voovoono tinara: Iqiivaki varinoo, tinai sa inna kuaivaa rikiaatee. ");
INSERT INTO waj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Fai unnakua vaidi vooya nnida voovoono ariiyara tinara: Na Anutuuqo mmataama kioo vaidiivo ngiaunoo, tino fai voovoono ariiyara tinara: Na forofetaavai ngiaunoo, tinaravai. Fai itaa kua kiaaraiya ari vookara ari vookarai mmooriiyauvaa iikiaaravai. Anutuuqo gioonna kiaapu ariiniee kiaa mmataama kiaiya unnakua tiraiyaano iya unnakua kiaa kiada iya iida aataru maisaivau iya vita yapaaraivaara ari vookara ari vookarai mmooriiyauvaa iikiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Rikiaatee. Na aanna iya iikiaaraivaara na mmuaanaa ngii giaa ngii miaunoo. ");
INSERT INTO waj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ii kaayau maisa mmuaararai suai ivo taikano nnaagiai suaivaki suaivo ngioo upisiima tu kioo vaino too kuraagaivo nnino hama mmeekiaivo teeno too ");
INSERT INTO waj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","aakiapuaiyauvo ngiauvaudiri tasukua roo tuoo vino yaagueeqa mminnaa ngiau aapu vaiyauvo ngiari aataru nuairaiyauvaa pikiada sabisaabi kuaaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Itaama vainai teeda Na Vaidiivaa Mmaapuuvoono nama aakiaidaadiri kaayau ari vookarai yaagueeqaivoota ari vookarai mmeekiaivootama ni tasipanai na tiinaraivaa fai iya taaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Fai na aangeraiya titanai teeda mmuakiaa yoosinnaiyauvaki nuaida suai raari raipinnai vida suai haatapaipinnai vida tooya sainai vida tooya sainai vida Anutuuqo ariiniee kiaa mmataama kiaiya rupi nuunaida vitada innasi ngiaaravee. ");
INSERT INTO waj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na yatari nnaammuayaivaudiri mmataama kiee tinai ngia rikiaatee. Nnaammuayaivo mmunni raikiai ngia teeda kiaanoo: Nuanuuvo vainima nnikioonno mmunni rainoo, kiaavai. ");
INSERT INTO waj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mmuaikaraama ii na ngii giaa ngii miau kua iyauvaa kaanaiyauvaa ngia teeda rikikio na tiinara suaivo mmuaanaa vainima vainaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu aanna makee variaa aaya hama putiraida homo varikio suaivo nnino ii aataru iyauvo fai vainaravai. ");
INSERT INTO waj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ngiau mmataivo fai taikaanaravaivee. Ni kuaivo fai hama taikaanaravai. Fai tupatupaa vainaravaivee. ");
INSERT INTO waj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hama gioonna kiaapu voovoono na tiinara suaivaa too rikiaivai. Aangeraa ngiau aapu variaiyaatama hama teeda rikiaavai. Na inna Mmaapuuvo neetama hama tee rikiauvai. Ari ni Napoovaano nnaasu too rikiaivai. ");
INSERT INTO waj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngia hama na tiinara suaivaara arinaima teeda rikiaivaara tuqinnama mmannammanna haitatuukiatee. ");
INSERT INTO waj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na tiinaraivo aa na mmatayaa diaa mminnaivaudiri mmataama kiee tinara kuaivaa roosiima vainaravai. Vaidi voovoono ngieera vo yoosinnaivakira kuanara iinno varioo ari mmoori vareera ngiaammuauya mmooriivaa mmuaavai mmuaavai vitaama iya mmi kioo ari nnauvaki pikioo keegiana haitatuura kieetaivaa tinoo: Eenoo iya haitatuukianee, ");
INSERT INTO waj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","kiaa kioo ngieera ari voopi vioo kiaivai. Vioo kiaikiai rikiada inna ngiaammuauya ivo nninaraivaara hama rikieerama kiada variaaneema fai na tiinaraivaara ngia hama rikieerama kiada variaaravai. Fai na kiisama upisiinara kannokannoonai tiinarannee? Vara na heena tammaana tiinarannee? Vara kakaraa tauraanaivo akua tinai na tiinarannee? Vara suaivo reera kinai na tiinarannee? Ivaaraida haitatuukiatee. ");
INSERT INTO waj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na akiairaama tiinarainainnaata ngia vuru vairayaama varida kumimakakiaarainnoo. ");
INSERT INTO waj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na ngiiiyara haitatuukiateera kiau kuaivaa mmuakiaayara kiaunoo: Tuqinnama haitatuukiatee, kiaunoo. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nnaaru Anutuuqo Iyiipadiri Yutayaa gioonna kiaapuuya vitoo yoketaivau yapoovaara iya buusa pinaivaa nnutuuvo Varaigiataivaa nneeravai. Ii buusa ivaa nneera suaivaki iya bereetaivaa hama puuqaira yeennaivaa tasipama hudooyauvaa nneeravai. Iqii suai ivaa nneera suaivo vainima vauduu homo taara suaivaitana vairavai. Vauduu Anutuuqaara kati puara hudeera kieetaiyaata kua mmaanna kiaa mmira vaidiiyaatama hataumakinaa Yisuunna vitada ruputuaaree kiaa iida tunoo: ");
INSERT INTO waj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gioonna kiaapuuya nuunaida kumimakaida rapivoora ta hama buusa nneera suaivaki Yisuunna utida ruputuaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tuduu Yisuuva yoosinna Betaniaivaki vaidi voovai nnutuuvo Simoonoono nnaaru inna mmammaivau buunna hoovo vaa maafama kiooduu yoketaama varuuvaa nnauvaki hara kioo variravai. Hara kioo varioo yeenna nnoo varuduu gioonna voovoono nniravai. Vaa ivo sikau pinaivaadiri yookaama kioo heenna suuya suuda yoketaa vuuvo sikau tooriivaki vauvaa varoo numa nnuugaivaa rummua ruaimi kioo Yisuunna kieetaivau tusaa apiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tusaa apuduu gioonna kiaapu vooya iva inna uuvaa tooduu iya nnannatooduu ngiari kiaa mmi ngiari kiaa mmiida tunoo: Aaniirainno heenna suuya suuda yoketaa kuai aavaa kuminayaa kagaari kiainnee? ");
INSERT INTO waj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ivo ivaa varoo vaidiiya mmiitiri. Irisai kaayau sikau yanaiyauvaa (300) varoo gioonna kiaapu mmanna haipuuya mmiitirivee, kiaa kiada kaayau yaagueeqama inna tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tuduu rikioo Yisuuva tunoo: Pikiaatee. Ngia aaniiraida inna kiaannee? Ivo yamaa aataruvainno ni iinoo. ");
INSERT INTO waj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mmanna haipu gioonna kiaapuuya tupatupaa ngii tasipama hara kiada varikiai sikauyauvaa ngii iya mmiatainai mmiatee. Hama na tupatupaa ngii tasipama varinaravai. Ivo niiyara iinee tiivaa iivaivee. ");
INSERT INTO waj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ivo na putinai vaidiiya ni hakuaaraivaara yaata utuoo mmuaanaa ni mmammaivau tusaa apinoo. ");
INSERT INTO waj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu mmuakiaa yoosinnaiyauvaki variaiya ni mmayaaya yoketaivaa kiaa mmikiai rikiada fai aa gioonna aavo ii mmayaaya ivaatama rikiada innara yoketaama yaata utuaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tuduu Yisuunna ngiaammuau voovai nnutuuvo Yutaaso Isariooto Anutuuqaara kati puara hudeera kieetaiyasi vioo Yisuunna kooyaa iya vitainaraivaara iyasi viravai. ");
INSERT INTO waj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Vioo iyaata kua tuduu rikiada iya kaayauma sirigaida irisai sikau inna mmiaaraivaara kua kiaa teerama kieeravai. Iya kua kiaa teerama kiooduu rikioo ii suai ivakidiri iva faannama roo varia roo vioo varioo dee suai tuanaavai nnino rikioo iva Yisuunna kooyaa iya vitainaraivaara haitatuuravai. ");
INSERT INTO waj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Buainnonno tooduu Yutayaiya buusa nneeda bereetaivaa hama puuqaira yeennaivaa tasipama hudooyauvaa nneera tauraa suaivo nniravai. Ii suai ivaki iya puara sipisiipa nnaakaraiyauvaa ruputu kiada buusa Varaigiataivaa nneeravai. Ii buusa ivaa nneera suaivaki Yisuunna ngiaammuauya numa inna yaparaida tunoo: Ta dee nnauvaki vida buusa Varaigiataivaa a nnaanaraivaa aini teerakiaunnannee? ");
INSERT INTO waj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","tuduu rikioo Yisuuva ari ngiaammuau taaravaitana titoo tunoo: Ngia vidada oro yoosinna pinaivaki teekio vaidi voovoono nnoori tooriivaa apu varoo ngii saidi nninai teeda inna nnaagiai vida ");
INSERT INTO waj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","teekio ivo nnauvaki vinai rikiada ngieeta ivaki kuatee. Vida nnau nakaaraivaata kiatee: Vaidi Vitairaivo tinoo: Dee nnauvaki na ngiaammuauyaatama buusa Varaigiataivaa ta nnaarannee? tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","tikio rikioo ivoono nnau pinaivaa verenoovau vo nnau voovai vaa rupi mmaataiyauvaa teerama kiaivaa ngii vitainai ngia ivaki titiini buusaivaa teerama kiaatee, ");
INSERT INTO waj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","tuduu rikiada taaravaitana vidada yoosinna pinaivaki vida Yisuuva tuu mminnaiyauvaa teeda buusa Varaigiataivaara nnauvaki teerama kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Teerama kiooduu heenauduu Yisuuva ari ngiaammuau yaakuuvaitana yukukidiri taaramootama nnida ");
INSERT INTO waj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","nnauvaki vida ngiari mmaataiyauvunu varida yeennaiyauvaa nneeda varuduu Yisuuva iyaata kua tioo tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Fai ngiiikidiri ngiaammuau ni tasipama varioo yeenna nnaanara voovoono fai ni nnammutuaiya kooyaa ni vitainaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","tuduu rikiada ari ngiaammuauya yaata utida kaayau ausa mmuaarareera tasipama varida mmuaavai mmuaavai inna yaparaida voovoono tunoo: Mo neenoonnee? ");
INSERT INTO waj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","tuduu rikioo Yisuuva iya kuaivaa sai tunoo: Ngia ni ngiaammuau yaakuuvaitana yukukidiri taarama fai ngiiikidiri voovoono ni tasipama mmuaa yavaavakidiri mmuaavaugiataama ari yeennaivaa rabuuma nnaivoono kooyaa ni nnammutuaiya ni vitainaravai. ");
INSERT INTO waj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Vaidiivaa Mmaapuuvoono fai putinaravai. Anutuuqaa yanaivau fafaaraivo vainno ivaara tiivo aanna makee vainoo. Vaidi voovoono kooyaa Na Vaidiivaa Mmaapuuvaa ni nnammutuaiya vitainaraivoono fai irisai maisaivaa varaanaravai. Aa vaidi aavaa hama ari kaano inna mmataitiri. Hama mmoori maisaivaa iinno irisai maisaivaa varaitirivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kiaa kioo homo ari ngiaammuauyaatama yeenna nnoo varioo Yisuuva bereetaivaa vara tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo kusii kioo ari ngiaammuauya mmioo tunoo: Varaatee. Aanna ni mmatiivaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","tuduu nnaa kiooduu iva kava vuaina suuya tooriivaa vara tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo ari ngiaammuauya vuaina suuyaivaa mmuduu mmuakiaaya nneeravai. ");
INSERT INTO waj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nnaa kiooduu Yisuuva tunoo: Aanna ni kiauvai. Na kaayau gioonna kiaapuuyara yaata utuee ni kiauvaa tusaanaravai. Fai tusaa kino rikioo Anutuuqo kua yeena rau kioo karaasa aataruuvo kooyaa vainaravai. ");
INSERT INTO waj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na kua kutaavai ngii giaa ngii miaunoo. Hama fai na aavau kava vuaina suuyaivaa nnaanaravai. Vo suai voovaki na Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki fai na vuaina suuya ari vookaraivaa nnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","kiaa kioo iya Anutuuqaara kuaru voovai kiaa taika kiada taapi Oriveeta ivaura viravai. ");
INSERT INTO waj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oro ivau varuduu Yisuuva iya tunoo: Fai ngia mmuakiaaya ni pikiada vida raubiriima kiaaravai. Anutuuqaa kua fafaaraivo vainno Anutuuqo tuu kuaivaa tinoo: Na puara sipisiipara haitatuura vaidiivaa ruputu kinai fai sipisiipaiya raubiriikiaaravaivee, tiivai. ");
INSERT INTO waj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Fai itaama vainai na putino Anutuuqo ni tinai na kava diitee neennaadee Karirayaa vinai fai ngia ni nnaagiai kuaaravee, ");
INSERT INTO waj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","tuduu rikioo Petorooso inna kua sai tunoo: Hama na i pikiaanaravai. Fai mmuakiaa ni seena ngiaammuauya i pikikiai fai neenoo hama i pikiaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","tuduu rikioo Yisuuva inna sai tunoo: Na kua kutaavai i kiaa i mmiaunoo. Turau hama kakaraa nnaagiaivo akua tinai a taaravoomaneetu niiyara tinara: Hama na inna tauvaivee, tinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","tuduu rikioo Petorooso yaagueeqama inna kuaivaa sai tunoo: Fai a putinai neeta putinaravai. Hama na aiyara tinara: Hama na inna tauvaivee, tinaravaivee, tuduu ari ngiaammuau mmuakiaaya mmuai kuaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kiaa kiada iya yoosinnaivaa nnutuuvo Kisamanii vidada oro dida vauduu Yisuuva ari ngiaammuauya tunoo: Ngia aavau varikiai na oro yaaku varaanaravee, ");
INSERT INTO waj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","kiaa kioo Petorooso Yakoopo Yuvuaanainna vitoo viravai. Vioo kaayauma yaata utuduu inna yaata utuuvo hanigioo ari vookarauduu ");
INSERT INTO waj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ari ngiaammuau taaravoomaivaitana kiaa mmioo tunoo: Mmuaararaivo niiki vaikio ni ausaivo pinaama mmuaararoo ari vookarainoo. Niiyara aavau varida haitatuukiatee, ");
INSERT INTO waj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","kiaa kioo oro kiisama vo kammunni voovau vioo varoo vainno yaaku varoo vo aataru voovoono vainno atau rino sa niisi ngiaiveeraivaara yaaku varoo tunoo: ");
INSERT INTO waj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ni Napoo-o, a mmuakiaa mmoorivai iiraivaa nakaaraikuavee. Mmuaararaivo aa nnoori toori kapikarai aavaa roosiivo niisi nninaraivaara ooqoo tino pikiaivee. Inna aikioovai. Ni iikiataivaa sa iikianee. Ai iikiataivaa iikianee, ");
INSERT INTO waj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","kiaa kioo kava vara ranoo numa tooduu ari ngiaammuaudo puaisakama vuru vaida varuduu Yisuuva iya yuruuma kioo Petoroosaa tunoo: Simoono, a vuru vakiannannee? Mo dataikiai a hama mmuaa suai voovau avu tee vairama kiee vakiannannee? ");
INSERT INTO waj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","kiaa kioo iya tunoo: Ngii iinno taanaraivo ngiiisi nninarainnoo tida avu teeda vaida yaaku varaatee. Vaidiivaa mmannasaivo inna iikiataikio nnabaivo muaraagainoo, ");
INSERT INTO waj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","kiaa kioo Yisuuva kava oro yaaku varoo mmuai kuaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kiaa kioo kava vara ranoo numa tooduu ari ngiaammuaudo vurura rusi rusiida rikiada vaa vairavai. Vuru vauduu Yisuuva iyaata kua tuduu sai kua kiaaraivaara iya kumimakairavai. Kumimakauduu ");
INSERT INTO waj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yisuuva oro vooneetu yaaku varoo kava vara ranoo numa iya tunoo: Ngia homooda vuru vaida variaannee? Aikioovai. Na Vaidiivaa Mmaapuuvaa vaidi voovoono vaidi maisa vooya kooyaa ni vitainara suaivo vaa nninoo. ");
INSERT INTO waj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Taatee. Vaidi kooyaa ni vitainaraivoono aavaa nninoo. Diitakiai ta innasi kuaaravee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yisuuva homo kua tioo varuduu ari ngiaammuaudo yaakuuvaitana yukukidiri taaramaakidiri voovai nnutuuvo Yutaaso ngioo kaayau vaidiiya paipa avaikarauyauvaata tipaiyauvaatama utida inna tasipama nniravai. Vaa Anutuuqaara kati puara hudeera kieetaiyaatama vaidi kua mmaanna kiaa mmiraiyaata vaidi yokovaiyaatama iya titooduu Yisuunnasi nniravai. ");
INSERT INTO waj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yutaaso kooyaa inna vitainaraivoono vaa mmuaanaa iya kiaa mmioo tunoo: Ngia teekiai vaidi na mmootaivo inna ngia vitaara vaidiivovee. Inna puaisa utida vitada kuatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ivo itaa kua tuuvoono ngioo ngioo numa makee tuduu Yisuunna tunoo: Vitaira-o, kiaa kioo inna mmooteeravai. ");
INSERT INTO waj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mmootooduu teeda vaidi vooyaano numa Yisuunna puaisakama utu kiada vauduu ");
INSERT INTO waj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","vaidi voovoono ivau dioo vainno ari paipa avaikarauvaa nnaamuruuvakidiri utu rada kioo Anutuuqaara kati puara hudeera vaidi kieetaivaa ngiaammuau voovai yaataivaa rutaka kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Rutaka kiooduu Yisuuva vaidiiya tunoo: Ngia yaata utida kiaanoo: Mmuara vareera vaidi roosiivaivee, kiaa kiada paipa avaikaraiyauvaata tipaiyauvaatama utida ni mmaara ngiaannee? ");
INSERT INTO waj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mmuakiaa suai na nuunaira nnau pinaivaki variee mmayaayaivaa ngii giaa ngii miaaduu hama ngia ni utiravai. Nnaaru Anutuuqaa kua fafaaraivo vaivaa ngia iikiaivaa kaanaivo vakiaiveeraivaara aanna makee ngia iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tuduu rikiada ari ngiaammuau mmuakiaaya inna pikiada ngiari toovau viravai. ");
INSERT INTO waj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Vuduu ngiaammuau karaasa voovoono kati buruqa poosa nnaasu rau varoo Yisuunna nnaagiai vuduu vaidiiya inna utuduu rikioo ");
INSERT INTO waj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","iya yaakuuvaki buruqaivaa pikioo taguaada ari toovau viravai. ");
INSERT INTO waj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Vuduu vaidiiya Yisuunna vitada Anutuuqaara kati puara hudeera kieeta tuanaivaa nnauvakira vitada oro ivaki yapa kieeravai. Yapa kiooduu mmuakiaa vaidi Anutuuqaara kati puara hudeera kieetaiyaatama vaidi yokovaiyaata vaidi kua mmaanna kiaa mmiraiyaatama nuunaida varuduu ");
INSERT INTO waj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petorooso ngieeradiri Yisuunna nnaagiai vioo vioo vaidi kieeta tuanaivaa vagiaamunna aakiaivaki vioo tooduu vaidi rapiraiya mmaanaivau ikiaivaa hara kiada ivaki varuduu Petorooso oro iya tasipama ivau varioo ivaata iya ikiaivaara totooka variravai. ");
INSERT INTO waj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Varuduu vaidi Anutuuqaara kati puara hudeera kieetaiyaata vaidi kua yeena raira mmuakiaayaatama Yisuunna ruputikio putuaiveera kua pinaana inna yapaara uuduu hama kua oyaivootairavai. ");
INSERT INTO waj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kaayau gioonna kiaapuuya numa Yisuunnara unnakua tida airi kua airi kua sabi kua tida hama mmuaavau tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tuduu nnaagiai vooya diitada Yisuunnara unnakua tida tunoo: ");
INSERT INTO waj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ta rikiaunnano ivo tinoo: Aa nuunaira nnau pinaa aavaa vaidiiya heeka kiaa aavaa na havarata kino taaravooma suaivo taikanai rikiee hama vaidi yaakukidiri heekeera nnau voovai na heekaanaravaivee. Ivo itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","kiaa kiada airi kua airi kua sabi kua tida hama mmuaavau tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tuduu Anutuuqaara kati puara hudeera vaidiiya kieeta tuanaivoono diitoo mmuakiaaya vuutaivakidiri dioo vainno Yisuunna yaparainno tunoo: Iya i kiaani a hama iya kua saivaa kiannannee? Aa vaidi aaya mo dee kuavai aiki yapaavainnee? ");
INSERT INTO waj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","tuduu rikioo Yisuuva hama inna kua sai tira kua seemuaa hara kioo variravai. Varuduu kieeta tuanaivo keenaa inna yaparainno tunoo: Ti Anutuuqo yoketaivo ari Mmaapuuvaa mmataama kioovo aanna a ivonnee? ");
INSERT INTO waj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","tuduu rikioo Yisuuva inna kua sai tunoo: Yo, aanna na Anutuuqaa Mmaapuuvo ivo ni mmataama kioovovee. Ivo yaagueeqa tuanaivovee. Fai ngia teekiai Na Vaidiivaa Mmaapuuvoono inna yaaku yaadudainningiaa hara kiee variee fai nama aakiaidaadiri tiinaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","tuduu rikioo kieeta tuanaivo Yisuuva tuu kuaivaara inna ausa pirisauduu ari uyu rauyauvaa utu rapasi kioo tunoo: Sa vaidi vooya kava numa innaki kua pinaa yapaaraivaara yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ivo ari avaivakidiri koonnama tinoo: Na Anutuuqaa Mmaapuvaivee, tiivaa vaa ngia rikiaanoo. Ngia innara dataamaida yaata utuaannee? tuduu rikiada iya inna sai tunoo: Ta rikiaunnano ivo koonnama kua tiivaara fai inna aikioo ivo putinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kiaa kiada vooya Yisuunnayaa kuaanuuvaa visida buruqaivaadiri inna oori nnikiivaki hauma utida yaaku rurauma utida inna rida tunoo: Mmuakiaa kuavai rikiaannaivaa ti kiaa ti mmianee, tuduu vaidi rapiraiya inna vitada kaura puaaka tuduu ruputiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ruputuduu Petorooso mmaanai vagiaamunna aakiaivaki hara kioo varuduu vaidi kieeta tuanaivaa mmoori vareera kiaatanna voovoono ngioo varioo tooduu ");
INSERT INTO waj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petorooso ikiaivaara totooka hara kioo varuduu kiaatannaivo inna too nnaasu vainno tunoo: Eetama Nasareetaa vaidi Yisuunna tasipama nookiannavaivee, ");
INSERT INTO waj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","tuduu rikioo Petorooso yaagueeqama inna kuaivaa ooqoo tuoo tunoo: E kianna kua oyaivaa na hama arinaima rikiaunoo, kiaa kioo oro keegiaivaki dioo vauduu ");
INSERT INTO waj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","mmoori varoo kiaatannaivo inna too hanigia vaidi ivaki varuuya tunoo: Aa Yisuunna tasipa nuaira ngiaammuau voovai dinoo, ");
INSERT INTO waj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","tuduu rikioo Petorooso kava ooqoo tiravai. Tuduu kiisa suai taika kiooduu vaidi ivaki duuya Petoroosaa tunoo: Kutaa tuanaa a inna tasipama nookiannavai. Mo eeta Karirayaa diaa vaidikuavee, ");
INSERT INTO waj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","tuduu rikioo Petorooso yaagueeqa kuavai iya kiaa mmioo tunoo: Na hama kua kutaavai kiautiri. Anutuuqo ni ruputitirivee. Na kua kutaavai kiaunoo: Aa vaidi ngia kiaa aavaa hama na tauvaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iva tinee tuu saivaata kakaraa nnaagiaivo akua tiravai. Akua tuduu Yisuuva tauraa inna kiaa mmuu kuaivo vaa taunnu kioovaa kava yaata utuoo rikieeravai. Tauraa Yisuuva inna kiaa mmuu kuaivaa inna kiaa mmioo tunoo: Fai hama kakaraivo taaraneetu akua tirainno kinai rikiee a taaravoomaneetu niiyara tinara: Hama na inna tauvaivee, tinaravaivee. Itaa kua tuuvaara Petorooso rikioo inna ausaivo maisauduu rateeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Heenanaanna suaivo reera kiooduu vaidi Anutuuqaara kati puara hudeera kieetaiyaata vaidi yokovaiyaatama vaidi kua mmaanna kiaa mmiraiyaata vaidi kua yeena raira mmuakiaayaatama nuunaida kuakuaakua kiaa ivau safuuma kiada Yisuunna yaakuuvaitanau yeenaadiri ranaa rau kiada vitada vaidi Roomaaya kieetaivaa Piratuusaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mmuduu too Piratuuso inna yaparainno tunoo: A Yutayaiya kieetakuannee? tuduu Yisuuva inna kua sai tunoo: Yo, inna kutaa kiannanoo, ");
INSERT INTO waj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","tuduu vaidi Anutuuqaara kati puara hudeera kieetaiya pinaa vo kua vo kuaiyauvaa innaki yapa kiooduu too ");
INSERT INTO waj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Piratuuso keenaa inna yaparainno tunoo: Mo iya kiaivaa a hama iya kuaivaa irisai tinarannee? Aa kua mmuakiaa aayauvaa aiki yapaiyauvaa a rikiaannano datainnonnee? ");
INSERT INTO waj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","tuduu rikioo Yisuuva hama inna kua sai tuduu rikioo Piratuuso ivaara pinaama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vo nuanu vo nuanu buusaivaa nnutuuvo Varaigiataivaa nneera suaivaki vaidi oovi nnauvaki varuu voovaara gioonna kiaapuuya Piratuusaa yapara ruuvaa mmaanai titooduu tuoo viravai. ");
INSERT INTO waj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ii suai ivaki vaidi voovai nnutuuvo Paravaaso oovi nnauvaki hara kioo variravai. Iva ari saiyaata ngiari kieetaiyaatama rapira vaidi vooya ruputuduu putuuvaara kieetaiya iya vitada oovi nnauvaki yapa kiooduu variravai. ");
INSERT INTO waj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Varuduu gioonna kiaapu kaayauya nuunaida numa Piratuusaa yaparaida tunoo: Ee iikiannaneema tiiyara iikianee, ");
INSERT INTO waj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","tuduu rikioo Piratuuso iya yapara ruoo tunoo: Ngia gioonna kiaapu Yutayaiyara dira vaidi kieetaivaa na ngiiiyara yaata utuee sipuuvaa hatuaa kino tuoo ngiiisi kuanarannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Vaidi Anutuuqaara kati puara hudeera kieetaiya Yisuunnanikaraama variaaree kiaa iya nnannatooduu kuminayaa Piratuusaasi inna vitada vida kua pinaana inna yapa kioovaa vaa Piratuuso rikieeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Iqii suai ivaki vaidi Anutuuqaara kati puara hudeera kieetaiya gioonna kiaapuuya nuuna aakiaivaki nuaida varida yaagueeqama iya tunoo: Piratuusaa kiaa mmida kiatee: Yisuunna pikiee Paravaasaa mmaanai titano tuoo kuaivee. Itaa kua kiatee, ");
INSERT INTO waj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","tuduu itaama aayanna tuduu Piratuuso rikioo keenaa gioonna kiaapuuya tunoo: Vaidi ngia ivaara Yutayaiya kieetavee kiaivaara na aaniivai inna iikiaunnee? ");
INSERT INTO waj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","tuduu rikiada iya kava aayanna tida tunoo: A tinai iya yatari sagaivau inna haara kiaatee, ");
INSERT INTO waj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","tuduu rikioo Piratuuso iya yapara ruoo tunoo: Mo datainnee? Aanii tomedavai iva iinnee? tuduu rikiada iya puaisakama aayanna tida tunoo: A tinai iya yatari sagaivau inna haara kiaatee, ");
INSERT INTO waj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","tuduu rikioo gioonna kiaapuuya innara yoketaavee tuuvaara Piratuuso Paravaasaa iyara oovi nnauvakidiri titooduu mmaanai tiiravai. Tuuduu Piratuuso ari ngiaammuauya Yisuunna mmuduu teeda iya inna ripiima kiooduu vooyaano yatari sagaivau haara inna vitada viravai. ");
INSERT INTO waj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Piratuusaa rapira vaidiiya Yisuunna vitada ngiari kieetaivaa nnau pinaivo vau yoosinnaivau vida ngiari seena rapira vaidi mmuakiaaya tuduu nnida nuunaida ");
INSERT INTO waj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","buruqa kookeevaa Yisuunna apu kiada yeena ooviiyauvaa varada hovekama kiada inna kieetaivau ruvuyiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ruvuyu kiada innara unnakuaivaa ataa kua tida tunoo: Gioonna kiaapu Yutayaiya kieetakuavee. Tupatupaa varianee, ");
INSERT INTO waj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","kiaa kiada yauvaa varada inna kieetaivau rida varida kuaanuuvaa innayaa visida toorivu yau hara kiada unnakua kiaa innara yoketaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kiaa kiada innara raima kiada inna buruqa kookeevaa utu rabara kiada ari uyira rairaiyauvaa kava inna uyu kiada vitada yatari sagaivau haara viravai. ");
INSERT INTO waj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Iya vidada oro tooduu yoosinna Kureenaivakinnaa vaidi voovai nnutuuvo Simoono aataruuvaugiataa yoosinnaivaki nninaree kiaa saidi numa iya tooduu iya inna teeda kua yaagueeqama inna tunoo: Eeta Yisuunna yatari sagaivaa apuanee, tiravai. Ivo Aresadereeya Rupuuya gioovavee. ");
INSERT INTO waj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Iya Yisuunna vitada yoosinnaivaa nnutuuvo Korokataa viravai. Ii nnutu ivaa oyaivo tunoo: Kieeta mmuyai ivaki vai yoosinnaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iya ivaki vida inna mmammaivo ruputuukiaiveera vuainaivaata kupuuvaa roosuuvaa nnutuuvo miiraivaatama varada Yisuunna mmuduu rikioo ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ooqoo tuduu rikiada inna vitada yuku yaakuuvaa yatari sagaivau haara kiada inna uyira rairaiyauvaa varaaree kiaa isareeda yaatareera mminnaiyauvaa rootu rootuuda varida yaatarooyaano mmuaavai mmuaavai inna uyira rairaiyauvaa vareeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iya inna pirima hoo suaivaki suaivo ngioo yaagueeqama teeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iya innaki kua yapa kioo kuaivaa oyaivaa kooyaa fafaara reeda tunoo: Inna aanna Yutayaiya kieetaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Iya taara mmuara furai vaidiivaitana yatari sagaivaitanau haara kiada vuaivaa vitada Yisuunna yaaku yaadudainningiaa haara kiada vuaivaa vitada Yisuunna yaaku geedainningiaa haara kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Haara kiooduu gioonna kiaapuuya yatari saga oyaivau vida nnidaida varuuya Yisuunna reeri teeda vaida innara nniki rakaida rakanoo raaranoo tida inna tunoo: Ai, a nuunaira nnau pinaivaa havarata kiee kava taaravooma suaivaki heekaanaravee kiannakuavee. ");
INSERT INTO waj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aiyara yaata utuee yatari sagaivaudiri reemi ree tummuanee, ");
INSERT INTO waj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","tuduu vaidi Anutuuqaara kati puara hudeera kieetaiyaatama kua mmaanna kiaa mmira vaidiiyaatama mmuaikaraama iida innara raida ngiari kiaa mmi ngiari kiaa mmiida tunoo: Ivo ari vo gioonna kiaapuuya vitoo yoketaivau yapaivai. Hama yopeema ariinoo ari vitoo yoketaivau yapainoo. ");
INSERT INTO waj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kii makee ta teekio Anutuuqo mmataama kioo vaidi Isarairaiya kieetaivo yatari sagaivaudiri reemi roo tiinai ta innara kutaavaivee kiaaravaivee, tuduu taara vaidivaitana yatari sagaivaitanau haara kioovaitanaatama Yisuunna rakanoo raaranoo tiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tuduu suaivo ikianna tammauduu mmuakiaa mmatavai heenama kioo vaududuu suaivo hanigiooduu taikeeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Taika kiooduu Yisuuva puaisakama aayanna roo tunoo: Irooqi Irooqi rama savatanii, tiravai. Ii kua ivaa oyaivo ataa kua tunoo: Ni Anutuuqo, ni Anutuuqo, dataama vaikiai ni pikiaannannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yisuuva aayanna tuduu rikiada gioonna kiaapu vooya ivau duuya ivo aayanna tuuvaa rikiada tunoo: Rikiaatee. Ivo Irayaannara aayanna tinoo, ");
INSERT INTO waj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tuduu rikioo vaidi voovoono seenoo vioo kapuka roosuu mminnaa voovai varoo kapikaroo nnoori ari vookarauvaa nnutuuvo vinikaivakidiri rabuuma kioo seera hokobaivau kuru kioo varoo numa yatari saga oyaivaki dioo vainno reeri Yisuuva ivaa nnaiveera inna mminee kiaa tunoo: Ngia ivau iikiai ta teekio Irayaava tuma inna vitaanee kiaa tiinai ta taaravaivee, ");
INSERT INTO waj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","tuduu Yisuuva puaisakama aayanna roo putiravai. ");
INSERT INTO waj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Putuduu buruqa pinaivo nuunaira nnau pinaivaki hiruuvo mmutuuvakidiri kereetu varoo oyaivaki tuoo saivai sainai vuduu saivai sainai viravai. ");
INSERT INTO waj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Vuduu vaidi rapiraiya kieetaivo Yisuunna yatari sagaivaa oyai vunningiaa dioo vainno Yisuuva itaama putuuvaa too tunoo: Aa vaidi aavo Anutuuqaa Mmaapu tuanaavaivee, ");
INSERT INTO waj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","tuduu gioonna vooya ngieeradiri dida vaida rooru Yisuunna tooya voovai nnutuuvo Saromiiva voovai Makataraa gioonnaivaa nnutuuvo Mariaava voovai vaidi karaasa Yakoopaya Yoosiipaya kaano Mariaava dida vaida Yisuunna teeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yisuuva yoosinna Karirayaa nuau suaivaki iya inna nnaagiai nuaida innara tuqinneeravai. Iyaata gioonna vooya vaa Yisuunna tasipama Yerusareema nnuuyaatama ivaki dida vaida Yisuunna teeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yutayaiya turau kati varira suaivo vainima vauduu teeraira suaivaki upisipisiinno varuduu yoosinnaivaa nnutuuvo Arimateyaa diaa vaidi voovai nnutuuvo Yoosiipo Piratuusaasi viravai. ");
INSERT INTO waj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yoosiipo kua safuuma yeena raira vaidivai. Ivo vaidi tuanaavai varioo Anutuuqo gioonna kiaapuuyara diraivaara faannairavai. Turau kati varira suaivo vainima vauvaara iva Piratuusaasi vioo hama innara aatuurama kioo vioo Yisuunna nnabaivaa varaanaraivaara inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yaparauduu Yisuuva vaa putuuvaara Piratuuso nnikiarainno ari rapira vaidiivaa tuduu innasi numa duduu inna yaparainno tunoo: Vaa Yisuuva putiinnee? ");
INSERT INTO waj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","tuduu rikioo Yisuuva putuuvaara inna kiaa mmuduu rikioo Yoosiipaa tunoo: Yisuunna nnabaivaa varaanee, ");
INSERT INTO waj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","tuduu rikioo Yoosiipo oro buruqa poosa hokobaivaa varoo numa Yisuunna nnabaivaa hitu kioo rurauma varoo oro hakuaara oonauvaa vaa hatata teerama kioovaki yapa kioo sikau pinaivaa feena roo keegiaivaki ramuunnaama kieeravai. ");
INSERT INTO waj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ramuunnaama kiooduu Makataraa gioonnaivo Mariaavaata Yoosiipaa kaano Mariaavaatama dida vaida Yisuunna nnabaivaa hau kioovaki teeravai. ");
INSERT INTO waj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vaidi Yutayaiya kati varira pinaa suaivo taika kiooduu yoosinna Makataraa gioonnaivo Mariaavaatama Yakoopaa kaano Mariaavaata Saromiivaatama ngiari iira mmooriivaara yaata utida mminnaa kupu takua roosuuyauvaa sikauyauvaadiri yookaama kiada varada oro Yisuunna mmammaivau siika kiaaree kiaa viravai. ");
INSERT INTO waj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sudaaqaki heenanaanna vida tooduu suaivo reera kiooduu Yisuunna hau mmata nnau yoosinnaivau vida varida ");
INSERT INTO waj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","mmata nnau keegiaivaki vau sikau pinaivaara ngiari kiaa mmi ngiari kiaa mmiida tunoo: Gioono mmata nnau keegiaivaki vai sikauvaa tiini feenaanarannee? kiaa kiada reeri tooduu vaa sikau pinaivaa keegiaivakidiri feena kiooduu vauduu ");
INSERT INTO waj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","gioonnaiya oonau aakiaivaki vida oro tooduu vaidi karaasa voovai buruqa poosa hokobaivaa uyu kioovo yaaku yaadudainningiaa hara kioo varuduu teeda nnikiarauduu ");
INSERT INTO waj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","iva iya tunoo: Sa nnikiaraakiatee. Nasareetaa vaidiivaa Yisuunna vaidiiya yatari sagaivau haara kiooduu putuuvaaraida ngia buaama rada nookiaanoo. Vaa ivo diitaivai. Hama aavaki vainoo. Vaidiiya inna yapa kiaa aavaki taatee. ");
INSERT INTO waj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ngia oro ari ngiaammuauyaata Petoroosaatama kiaa mmida kiatee: Ivo ngii tauraa Karirayaa kuanara vioo varinoo. Fai ngia oro ivaki inna taaravai. Vaa nnaaru ivo mmuai kuaivaa ngii giaa ngii miravaivee. Itaa kua iya kiaa mmiatee, ");
INSERT INTO waj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","tuduu rikiada mmaanai tiida mmata nnauvakidiri pikiada seenada kaayau nnikiaraida biribiriima rada nniravai. Nnida varida iya aatuuvaara hama gioonna kiaapuuyaatama kua tira kua seemuaa viravai. ");
INSERT INTO waj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","((Sudaaqaki heenanaanna upisi saivaata Yisuuva ari putuuvakidiri diitoo tauraa Makataraa gioonnaivaa Mariaanna avuuvau kooyaa diravai. Ii gioonna ivaakidiri nnaaru Yisuuva mmagia maisa yaaku saivai karasaidiri taarama titooduu viravai. Ivoono Yisuuva inna avuuvau kooyaa duuvaara ");
INSERT INTO waj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","oro inna tasipama nuau gioonna kiaapuuya ivaara kooyaa kiaa mmiravai. Iya ratada varida ausa mmuaararoo tasipama variaivaki ");
INSERT INTO waj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yisuuva kava diitoo hara kioo varuu kuaivaata ivo inna avuuvau kooyaa duu kuaivaatama iya kiaa mmuduu rikiada unnakuavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nnaagiai iyakidiri taara vaidivaitana aataruuvau vida varida tooduu Yisuuva ari vookarau mmammaivaata iya too vauduu teeda ");
INSERT INTO waj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","kava vara ranada ngiari seenaiya kiaa mmuduu rikiada unnakuavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yisuuva nnaagiai ari ngiaammuau yaakuuvaitana yukukidiri mmuaavai yeenna nneeda varuduu tuma iya avuuvau kooyaa diravai. Duduu teeda vauduu Yisuuva kua yaagueeqama iya tiravai. Gioonna kiaapuuya inna teeda numa iya kiaa mmuduu rikiada hama ngiari tinniiyauvo rusituduu hama ngiari ausa mmuduuyaiyauvo iya tuu kuaivaa varoovaara Yisuuva kua yaagueeqama iya tiravai. ");
INSERT INTO waj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iva iya kiaa mmioo tunoo: Eeyaa yoosinnaiyauvaki ni mmayaaya yoketaivaa varada nuaida mmuakiaa gioonna kiaapuuya kiaa mmiatee. ");
INSERT INTO waj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Gioonna kiaapu voovoono ari ausa mmuduuyaivaa hanigioo niiyara kutaavaivee tioo nnoori apiraivaa varano fai Anutuuqo inna vitaanaravai. Gioonna kiaapu voovoono hama ari ausa mmuduuyaivaa hanigioo hama niiyara kutaavaivee tino Anutuuqo inna yaparaira suaivaki irisai maisaivaa inna mminaravai. ");
INSERT INTO waj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gioonna kiaapuuya niiyara kutaavaivee kiaiya yaagueeqaivo iya tasipanai aa mmoori ari vookarai aayauvaa iikiaaravai. Fai iya ni nnutuuvaa tikiai vaidiiya aakiaivaki mmagia maisaiya variaiya kuaaravai. Fai Mmannasa yoketaivo iya tasipama varinai ari vo kua vo kuaivaa kiaaravai. ");
INSERT INTO waj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Fai iya yapaiyauvaa utikio iya gutinai hama putuaaravai. Fai kapikarai nnooriivaa vaidiiya nneeda putiraivaa iya nneeda fai hama putuaaravai. Fai iya gioonna kiaapu nniitareeraiyayaa yaaku utikiai hama putuaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Udaanga Yisuu Kirisiiva iyaata kua kiaa taika kiooduu Anutuuqo inna vitoo ngiau aapu yapa kiooduu inna yaaku yaadudainningiaa hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Varuduu ari ngiaammuauya vida vo yoosinna vo yoosinnaiyauvaki nuaida varida inna mmayaayaivaa gioonna kiaapuuya kiaa mmiaa rada nuairavai. Nuauduu Udaanga Yisuu Kirisiiva iya tasipama uuduu rikiada ari vookarau mmooriiyauvaa uuduu gioonna kiaapuuya teeda tunoo: Aanna Anutuuqaa kuaivo kutaa tuanaavai vainoo, tiravai.)) ");
INSERT INTO waj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Boo Tioopiri-o, a vaidi nnoonna yoketaakuavee. Yisuuva ti tasipama varioo ivo mmoori uu mmayaayaiyauvaa kaayau vaidiiya yaata utida hakuataraatarama fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vaidiiya Yisuuva toosa hara uu mmooriivaa teeda inna mmayaayaivaa rikiada kiaa mmuuya inna mmooriivaa teeda ti kiaa ti mmuuvaa iya hakuataraatarama fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Fafaara rooduu neeta iyauvaara yaata utuee rikiee fafaarama i mmiauvaara ni yoketainoo. Na hokoba suai iya roo kua mmuakiaayauvai haitatuuma tee aa fafaara aavaa na rikiee verepidiri oyaivaudiri safuuma fafaarama i mmiaunoo. ");
INSERT INTO waj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","A Yisuuva uu mmooriivaa rikiaannaivaara kutaavaivee kianeeraivaara na aa fafaara aavaa safuuma fafaarama kiee i mmiaunoo. ");
INSERT INTO waj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herooto vaidi Yutayaiya kieetavai varuu suaivaki kati Anutuuqaara puara hudeera vaidiivaa nnutuuvo Sakariaaso hara kioo variravai. Inna oyai kiisaivaa nnutuuvo Aviaava ari nnaataivaa nnutuuvo Irisaveeto mmuaa oyai pinaivaa nnutuuvo Aroonaa oyaivakidiri diiteeravai. ");
INSERT INTO waj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ivaitana Udaanga Anutuuqaa avuuvau yoketaama hara kiada varida inna kua mmaanna tuu kuaivaata iva tuu kua mmuakiaayauvaatama rikiada yoketaama iiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Irisaveeto hama nnaakara mmateera kati varuduu hama ivaitana nnaakaraatauduu eeyaavaitana yotera ngiaabai kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sakariaasoota ari tasipama mmoori varooyaatama nuunaira nnau pinaivaki ngiari mmoori vareera suaivo nnuduu Sakariaaso Anutuuqaa avuuvau ari kati puara hudeera mmooriivaa iiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ivo iinnonno tooduu tupaa ari seenaiya iirayaama mmoori varoo vaidiiya iida tooduu Sakariaasaa nnutuuvo vairavai. Vauduu too ivo yatari rana suuda yoketaa vuuvaa varoo Udaanga Anutuuqaa nuunaira nnau pinaivaki vo atau yoketaa tuanaa voovaki vioo yeena tapiivaki ivaa mmuturinara viravai. ");
INSERT INTO waj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Vioo varuduu yatari rana mmuturira suaivaki kaayau gioonna kiaapuuya mmaanai duuya yaaku varada varuduu ");
INSERT INTO waj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","oro tooduu Udaanga Anutuuqaa aangeraa voovoono tuoo yatari rana mmuturira yeena tapiivaa yaadudainningiaa dioo vauduu ");
INSERT INTO waj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","too Sakariaaso pinaama aatuunno ari vo vuayaatavai utuoo pinaama biribiriiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Biribiruuduu aangeraivo tunoo: Sakariaaso, sa aatuunna varianee. Vaa Anutuuqo i yaaku vareera kuaivaa rikiaivai. Kiisa suai i gioonnaivo Irisaveeto i mmaapuvai mmataanaravai. Fai mmatanai eenoo inna nnutuuvaa Yuvuaano kianee. ");
INSERT INTO waj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Fai itaino i ausaivo yoketainai a sirigainaravai. Fai kaayau gioonna kiaapuuyaatama inna mmatoovaara fai sirigakiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Fai ivo Udaanga Anutuuqaa avuuvau nnoonna vaidivai varinaravai. Sa tino too ivo vuaina nnooriivaata kapikarai nnooriivaatama nnaivee. Ari mmatai suaivakidiri Mmannasa Yoketaivo fai inna aakiaivaki varioo suvuainaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Fai ivo gioonna kiaapu Isarairaiya tinai rikiada fai kaayau saiyaano hanigiada Udaanga Anutuuqaa kuaivaa keenaa rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Fai ivo Udaangaivaa tauraa vioo nnaaruaa vaidi forofetaa Irayaanna roosiima fai yaagueeqama varinaravai. Fai ngiari kookiaiya voovau varikiai ngiari mmaapuuya voovau varikiai fai yapooma ivoono iya tinai teeda mmuaavau yoketaama variaaravai. Gioonna kiaapuuya Anutuuqaa kuaivaa rikiadaata yaatareeraiya fai ivo iya tinai hanigiada safuuma variaiya tinni yoketaira aataruuvau nnaasu variaaravai. Ivo gioonna kiaapuuya tinai iya ngiari Udaangaivo nninaraivaara teerakiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tuduu rikioo Sakariaaso tunoo: Dataama na i kuaivaa rikino kutaavai vainarannee? Na ngiaabai kiauko ni naataivo yotera kiainoo, ");
INSERT INTO waj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","tuduu rikioo ivo inna sai tunoo: Ni nnutuuvo Gavirieerovee. Na Anutuuqaa avuuvau diaunoo. Ivoono ni titaikiai tiee aa na kua kiau mmayaaya yoketaa aavaa i kiaa i mminara tummuauvai. ");
INSERT INTO waj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hama a ni kua aavaara kutaavaivee kiannanoo. Anutuuqo mmataama kiai suaivaki fai ni kuaivaa kaanaivo vainaravai. A hama ni kuaivaara kutaavaivee kiannaivaara fai hama a kua tinaravai. Fai a kua seemuaa varieennanna fai na i kiaa i mmiau kuaivo kutaavai vainai rikiee fai a kava kua tinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gioonna kiaapuuya mmaanai Sakariaasaara faannaida varida ivo hokoba suai nuunaira nnau pinaivaki varuuvaara yaata utida varuduu ");
INSERT INTO waj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ivo mmaanai tuoo hama iyaata kua tira kua seemuaa varuduu iya yaata utida tunoo: Vaa ivo mmannasa ari vookaraivaa nuunaira nnau pinaivaki taivaivee, tuduu rikioo ivo hama yopeema iya kua sai tirainno mmanna yaakuuvaadiri iya vita vitairavai. ");
INSERT INTO waj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Vita vitauduu yapooma nuunaira nnau pinaivaki ari mmoori varoovo taikooduu rikioo ari nnauvakira viravai. ");
INSERT INTO waj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Vioo vioo oro hara kioo varududuu nnaagiai ari nnaataivo Irisaveeto nnaakara sunnainno yaaku sai kuraagavai ari nnauvaki nnaasu hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Hara kioo varioo tunoo: Udaanga Anutuuqoono niiyara yoketaavaivee kiaa kioo nnaakaraivaa ni mikiai hama na gioonna kiaapuuya avuuvau mmannammanna mmamma maisakiauvai. Vaa taika kiaivaivee. Irisaveeto itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Irisaveeto kuraaga yaaku saivai sainaidiri mmuaa kuraagavai nnaakara sunnainno varuduu Anutuuqo aangeraivaa nnutuuvo Gavirieeraa titooduu ivo tuoo mmata Karirayaa vau yoosinna Nasareeta ivakira viravai. ");
INSERT INTO waj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Vioo kiaatanna hama vaidi tasipama varuuvaa Anutuuqaa kuaivaa kiaa mminara viravai. Davuitiinna oyaivakidiri diitoo ngiaammuauvaa nnutuuvo Yoosiipo ii kiaatanna ivaa varaanara kuaivaa kiaa teerama kieeravai. Ii kiaatanna ivaa nnutuuvo Mariaavavee. ");
INSERT INTO waj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aangeraivoono numa inna tunoo: A yoketaamainna variannannee? Udaanga Anutuuqo i too kaayauma aiyara yoketainoo. Ivo i tasipama varinoo, ");
INSERT INTO waj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","tuduu rikioo Mariaava aangeraivo tuu kuaivaara ari vo vuayaatavai utuoo oyaivaara kaayauma yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yaata utuduu rikioo aangeraivo Mariaanna tunoo: Mariaa-o, sa aatuukianee. Anutuuqo a variannaivaa too kaayauma aiyara yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fai yapooma a nnaakara sunnainna mmaapuvai mmata kiee inna nnutuuvaa Yisuuvavee kianee. ");
INSERT INTO waj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Fai ivo kieetavai varinai gioonna kiaapu mmatayaiya innara kiaara: Anutuuqo mmuakiaa mminnamminnaavai yaataraivaa Mmaapuvovee, kiaaravai. Udaanga Anutuuqo tino fai ivo ari nnaakunna Davuitiinna mmaataivau kieetavai varinaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Fai ivo tupatupaa Yakoopaa uru nnaakaraiyara dinaravai. Dioo vainono fai hama inna diraivo taikaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tuduu rikioo Mariaava aangeraivaa tunoo: Na kiaatannavai variee hama na vaati varauvai. Na dataama kiee nnaakara sunnainarannee? ");
INSERT INTO waj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","tuduu rikioo aangeraivo inna sai tunoo: Mmannasa Yoketaivoota Anutuuqo mmuakiaa mminnamminnaavai yaataraivaa yaagueeqaivootama i rummua apinaravai. Itaama vaikiai a nnaakara sunnaakiannaivaara gioonna kiaapuuya i nnaakaraivaara kiaara: Ivo yoketaa tuanaa ari vookaraivai. Ivo Anutuuqaa Mmaapuvaivee, kiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ai nnayaanna Irisaveetaara yaata utuee rikiaanee. Ivo hama nnaakara mmatainoo kiaavo ivo yoteravai varioo vaa nnaakara sunnainoo. Inna kuraagaivo yaaku saivai sainaidiri mmuaavai vaa taikainoo. ");
INSERT INTO waj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anutuuqo inna mmuakiaa mmoori aataruvai iira nakaaraivo fai ivo iinaree kiaa kioo fai aikiooma iinaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","tuduu rikioo Mariaava inna sai tunoo: Na Udaanga Anutuuqaa mmoori varau kiaatannavaivee. Kii ivo a kianna kuaivaa ni iikiaivee, tuduu rikioo aangeraivo inna pikioo viravai. ");
INSERT INTO waj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Vuduu nnaagiai kiisa suaivo taika kiooduu Mariaava diitoo taapi suvuau yoosinnaivakira akiairauduu vioo vioo oto Yutayaa mmataivaki vau yoosinna kiisa voovakira viravai. ");
INSERT INTO waj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Vioo vioo oro Sakariaasaa nnauvaki vioo tooduu Irisaveeto ivaki varuduu too inna tunoo: A yoketaamainna variannannee? ");
INSERT INTO waj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","tuduu rikioo Irisaveeto Mariaanna kuaivaa rikioo saivaata inna nnaakaraivo inna ausaivaki korokorooravai. Korokorooduu Mmannasa Yoketaivo inna yaagueeqama tasipama varuduu ");
INSERT INTO waj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ivo pinaa kuavai tioo inna tunoo: Anutuuqo aiyara yoketairaivo mmuakiaa gioonnaiyara yoketairaivaa yaataraivai. Ii i nnaakara a mmataanara ivaara Anutuuqaa yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A ni Udaangaivaa kaano variannaikua aaniira a niiyara yaata utuee niisi ngiannano ni yoketainnee? ");
INSERT INTO waj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","A niisi ngiee niiyara yoketaavee kiannani na rikiau saivaata ni nnaakaraivo inna yoketaikio korokoroonoo. ");
INSERT INTO waj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Anutuuqo i kiaa i mmuu kuaivaa kutaa iinaravee kiannaivaara Anutuuqo aiyara yoketaikiai a yoketaakiannanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tuduu Mariaava tunoo: Ni Udaangaivaara kaayauma ni yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Anutuuqo aataru maisaivakidiri ni vitaanaraivaara ni yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Na mmanna kiaatannavai variee inna mmoori varee variauvaara niiyara yaata utiivaara ni yoketainoo. Anutuuqo yaagueeqama variivoono ari vookarai aataruuvaa niiyara iivaara mmuakiaa gioonna kiaapu aa ta variaunnaiyaata nnaagiai variaaraiyaatama niiyara yoketaavaivee kiaaravai. Anutuuqaa nnutuuvo yoketaa tuanaa ari vookaraivai vaivai. ");
INSERT INTO waj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nnaaru varuuyaatama aanna makee ta variaunnaiyaata nnaagiai variaaraiyaatama Anutuuqaara mmuduuya rikio fai Anutuuqo iyara boo tinaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gioonna kiaapuuya ngiariiyara mannaka tida ngiariiyara nnaasu yaata utuuya Anutuuqo yaagueeqama iya titooduu vida raubiriida variravai. ");
INSERT INTO waj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anutuuqo vaidi kieeta yaagueeqauya vitoo aduoo yapeeravai. Vaidi kumina aduoo varuuya vitoo aruoo yapeeravai. ");
INSERT INTO waj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gioonna kiaapu yeenna rauya ivo yeennaiyauvaa iya mmuduu iya suvuairavai. Gioonna kiaapu hoona suvuauya ivo titooduu kuminaya viravai. ");
INSERT INTO waj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ari kua kutaivaa nnaaru ti taato nnaakukiaiya kiaa mmuuvaa iinno ari mmoori vareera gioonna kiaapu Isarairaiya tasipama varuduu iya yoketaama variravai. ");
INSERT INTO waj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ivo Aaparahaamaaraata ari uru nnaakaraiyaraatama hama taunniravai. Iyara tupatupaa boo tiravaivee. ");
INSERT INTO waj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariaava itaa kua kiaa taika kioo Irisaveetaa tasipama varioonnonno taaravooma kuraaga taa kioo ari yoosinnara viravai. ");
INSERT INTO waj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mariaava vuduu Irisaveeto nnaakara mmataanara suaivo vainima nnuduu mmaapuvai mmateeravai. ");
INSERT INTO waj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mmata kiooduu mmuaa yoosinna varuuyaata ari seena tuanaiyaatama Anutuuqo innara kaayauma boo tuduu nnaakaraivaa mmata kioo kuaivaa rikiada inna tasipama sirigairavai. ");
INSERT INTO waj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sirigama kiooduu varududuu suaivo yaaku saivai sainaidiri taaravooma suaivo nnuduu rikiada gioonna kiaapuuya nnaakaraivaa mmammaivaa hatokaara nnida ari koonna nnutuuvaa Sakariaaso innara kiaara uuduu ");
INSERT INTO waj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ari kaanoono ooqoo tioo tunoo: Sa itaa kua kiatee. Inna nnutuuvo Yuvuaanovee, ");
INSERT INTO waj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","tuduu rikiada inna tunoo: Hama i seena voovoono aa nnutu aavaa varaivaivee, ");
INSERT INTO waj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","kiaa kiada iya ngiari yaakuuyauvaadiri koova inna nnutuuvaa kiaiveera mmata mmatairavai. ");
INSERT INTO waj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mmata mmatauduu too Sakariaaso yanaivau fafaara raanaraivaara tuduu oro varada inna mmuduu fafaara roo tunoo: Inna nnutuuvo Yuvuaanovee, tuduu rikiada mmuakiaaya kaayauma nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iya nnikiarau saivaata Sakariaasaa mmaakiriivo korooduu kava kua tioo Anutuuqaara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tuduu inna seena mmuakiaaya nnikiaraida aatuuda variravai. Varuduu mmuakiaa gioonna kiaapu Yutayaa mmataivau kaayau taapi suvuauvaki varuuya ii mmayaaya ivaa rikiada kaayau kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kua tida ngiari yaata tinniyaa vau kuaivaa yaata utida tunoo: Aa nnaakara aavo yokeenno fai dee mmoorivai iinarannee? kiaa kiada Udaanga Anutuuqo inna tasipama varuuvaa rikiada itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nnaakaraivaa koonna Sakariaasaa aakiaivaki Mmannasa Yoketaivo suvuai kiooduu iva nnaagiai varinaraivaara kuaivaa kiaa kookieema kioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kii ta gioonna kiaapu Isarairaiya Udaanga Anutuuqaara kiaara: Yoketaavaivee, kiaaravee. Ivo ari gioonna kiaapuuya ti tasipama iinno ti mminnamminnaa maisaiyauvaa irisaivaa yapaivaara ta innara kiaara: Yoketaavaivee, kiaaravee. ");
INSERT INTO waj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vaa ivo ari mmoori vareera vaidiivaa Davuitiinna oyaivakidiri vaidi voovai vita yapa kiaikio fai ivoono yaagueeqama varioo ti vitoo aataru yoketaivau ti yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ivaara Anutuuqo nnaaruaa vaidi forofetaa yoketaa tuanaiya ari kua kutaivaa kiaa mmioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Na ngii nnammutuaiya yaataree mmuakiaa gioonna kiaapuuya hama ngiiiyara mmuduuya ruaiya yaataraanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","kiaa kioo tunoo: Na ngii taato nnaakukiaiyara boo kiaivaara na kua kiaa teerama kiaivaa fai na iinaravaivee. Na kua yoketaa tuanaivaa yeena rau kioovaa iya kiaa mmuuvaa hama taunnukiaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","kiaa kioo ti nnaakunna Aaparahaamaa ari kua kutaivaa tiiyara tunoo: Na iya nnammutuaiya yaataree yoosinna yoketaivaki iya yapa kinai mmuakiaaya ngiari varira suaivaki iya ni mmooriivaa varada hama aatuuda variaaravai. Iya yoketaama safuuma ni avuuvau variaaravaivee. Anutuuqo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sakariaaso itaa kua kiaa kioo ari mmaapuuvaa tunoo: Ni maapu-o, eenoo Udaangaivaa tauraa viee innani aataruuvaa teerama kinai fai gioonna kiaapuuya aiyara kiaara: Anutuuqo mmuakiaa mminnamminnaavai yaataraivaa forofetaakuavee, ");
INSERT INTO waj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","tikiai a gioonna kiaapuuya kiaa mmiee tinara: Ngiingii mminnamminnaa maisaiyauvaa Anutuuqaa kiaa kookieema kikio fai ivo ngii mminnamminnaa maisaiyauvaa ruga kioo ngii vita yoketaivau yapaanaravaivee, tinaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ivo ngiau aapuuvakidiri mmeekia tai vaidiivaa titano tuoo mmuakiaaya tiiyaa taanaravai. ");
INSERT INTO waj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Gioonna kiaapu vooya upisiivaki varida putiraivaara aatuukiaiyayaa taiveeraivaara titano tiinaravai. Ivoono fai ti vitoo ausa nuufa tasipama varira aataruuvaa ti vitaakiaiveera titano tiinaravaivee. Sakariaaso itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Itaa kua kiaa kioo varuduu ari mmaapuuvo varioonnonno yokeema kiooduu rikioo inna mmuduuya riraivo pinaama Anutuuqaara vauduu ivo koo mmuyai gaanga yoosinnaivaki varioonnonno gioonna kiaapu Isarairaiya avuuvau kooyaa nninara suaivaara faannairavai. ");
INSERT INTO waj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ii Yuvuaanaa mmatoo suai ivaki yoosinna Rooma diaa vaidi kieeta pinaa voovai nnutuuvo Akusuuva gioonna kiaapu mmuakiaa yoosinnaiyauvaki varuuya nnutuuyauvaa raateeraivaara ari ngiaammuauya titooduu inna kuaivaa varada nuairavai. ");
INSERT INTO waj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ii toosa hara kioo nnutuuyauvaa reera suai ivaki vaidi voovai nnutuuvo Kuriniaaso yoosinna Suriaa gioonna kiaapuuyara diravai. ");
INSERT INTO waj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Duduu gioonna kiaapuuya ngiari diitada nnuu yoosinnaiyauvakira vida ngiari nnutuuyauvaa raateeraivaara viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Vuduu Yoosiipo Karirayaa vau yoosinna kiisaivaa nnutuuvo Nasareeta ivakidiri pikioo Yutayaa vau yoosinna kiisaivaa nnutuuvo Pitiriheema ivakira viravai. Ii yoosinna ivakidiri nnaaruaa vaidi kieeta Davuitiinna kaano inna mmateeravai. Yoosiipo Davuitiinna oyaivakidiri diitoovaara ivakira viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yoosiipo ari nnaata kua kiaa kioovaa nnutuuvo Mariaava vaa nnaakara sunnauvaatama vitoo ngiari nnutuuvaitana raateeraivaara viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Vidada oro Pitiriheema variaaraivaara tooduu vaa vida nnida vaira nnauvo suvuai kiooduu taaravaitana puaraiya yeenna nneera nnauvaki variravai. Varuduu Mariaava nnaakaraivaa mmataanara suaivo nnuduu ari mmaapu ngarunna mmata kioo too buruqaivaadiri rurauma kioo puaraiya yeenna nneeraivaki yapeeravai. ");
INSERT INTO waj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Iqii yoosinna ivaa tooyaivaki puara sipisiipara haitatuuraiya heenaki mmuyau koovau puara sipisiipaiyara haitatuuda variravai. ");
INSERT INTO waj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Haitatuuda varuduu Udaangaivaa aangeraivo iyasi tuuduu Udaangaivaa mmeekiaivo iyayaa ruvuaahooduu teeda pinaama aatuuravai. ");
INSERT INTO waj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aatuuda varuduu aangeraivo iya tunoo: Sa aatuukiatee. Rikiaatee. Na aapi tiee kua yoketaivaa mmuakiaa gioonna kiaapuuya kiaa mminai rikiada ivaara sirigakiateeraivaara ngiiisi tummuauvaivee. ");
INSERT INTO waj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aa heena aavaki Davuitiinna yoosinnaivaki gioonna voovoono nnaagiai ngii vitaanara vaidiivaa vaa mmataivai. Vaidiivaa Anutuuqo mmataama kioovaa nnutuuvo Udaanga Yisuu Kirisiinna ngiiini mmataivai. ");
INSERT INTO waj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Fai ngia ni kuaivaara taara yaata utida ngiengieenoo oro taatee. Teekio vaa nnaakaraivaa buruqaivaadiri rurauma kioo puaraiya yeenna nneeraivaki yapa kiaikio vaivaa teeda fai ngia kiaara: Kua kutaavaivee, kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aangeraivo itaa kua tuu saivaata kaayau aangeraa vooyaata tiida inna tasipama iida varida Anutuuqaara kua yoketaivaa tida tunoo: ");
INSERT INTO waj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Anutuuqo mmuakiaa mminnamminnaavai yaataraivaa oyai ari vookaraivo vainoo. Gioonna kiaapu mmatayaa variaiya Anutuuqo iyara yoketaiya inna ausa nuufaivo iya tasipama vakiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiaa kiada iya pikiada ngiau aapu vuduu teeda puara sipisiipara haitatuura vaidiiya ngiari kiaa mmi ngiari kiaa mmiida tunoo: Vikiai ta oro Pitiriheema ivaki Udaangaivo aangeraivaa tikio tuma ti kiaa ti mmii mminnaivaa taara kuaaravee, ");
INSERT INTO waj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","kiaa kiada akiairauduu oro tooduu Mariaaya Yoosiipooya hara kiada varuduu nnaakaraivo puaraiya yeenna nneeraivaki vairavai. ");
INSERT INTO waj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Vauduu teeda nnaakaraivaara aangeraivo iya kiaa mmuu kuaivaa gioonna kiaapuuya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kiaa mmuduu rikiada mmuakiaa gioonna kiaapuuya puara sipisiipara haitatuura vaidiiya tuu kuaivaara pinaama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yaata utuduu Mariaava iya tuu kua mmuakiaavai mmannammanna yaata utu kioo nnaasu variravai. Hama taunniravai. ");
INSERT INTO waj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Puara sipisiipara haitatuura vaidiiya kava vara ranada vida aangeraivo iya tuu kuaivaa kaanaivaa toovaaraata mmuakiaa kuavai ivaara tuuvaa rikioovaaraatama kua yoketaivaa Anutuuqaara kiaa rada viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yaaku saivai sainaidiri taaravooma suaivo taika kiooduu rikiada iya nnaakaraivaa mmammaivaa hatokada inna nnutuuvaa tunoo: Yisuuvavee, tiravai. Nnaakaraivo kaanaa ausaivaki hama varuu suaivaki inna nnutuuvaa aangeraivo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gioonnaiya vaa nnaakaraiya mmata kiada kabaa nnauvaa pikiada kava vara ranada ngiari nnauvaki nnida yoketaama varuuvaara Udaanga Anutuuqaa mmaanna tuu kua voovai vairavai. Yoosiipooya Mariaaya ii mmaanna tuu kua ivaa iikiaara suaivo nnuduu rikiada Yerusareema vida ngiari nnaakaraivaa Udaangaivaa mmiaara viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ii mmaanna tuu kua ivo tunoo: Ngia mmuakiaaya ngiingii mmaapu ngaruuyauvaa vitada ni mi kiada kiatee: Inna ainiyauvaivee, kiaa kiada niini yapaatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yoosiipooya Mariaaya Anutuuqaa mmaanna tuu kua voovai vauvaa iikiaara vida ngiaamma mirunna taaramannee vuaheenna roosuu nnaakaraivaitana varada hudaara viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Vuduu vaidi yoketaa voovai yoosinna Yerusareema varuuvaa nnutuuvo Simioono ivo Anutuuqaa mmayaayaivaara yaagueeqainno Isarairaiya vitaanara vaidiivaara faannainno varuduu Mmannasa Yoketaivoono inna tasipama variravai. ");
INSERT INTO waj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Vaa tauraa Mmannasa Yoketaivo inna kiaa mmioo tunoo: Fai hama a putirainna mmannammanna hara kiee variee Isarairaiyara Anutuuqo mmataama kioo vaidiivaa tee nnaagiai putinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nnaagiai Mmannasa Yoketaivo Simioonaa yaagueeqama tasipooduu rikioo ivo nuunaira nnau pinaivaki oro hara kioo varuduu Isarairaa gioonna kiaapuuya tupatupaa mmaanna tuu aataruuvaa iirayaama Yisuunna kaano koovaitana iikiaara inna vitada nnuduu ");
INSERT INTO waj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioono Yisuunna sootu pabaanama tu kioo vainno Anutuuqaara kua yoketaivaa tioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Udaanga-o, a nnaaru kua kutaa tunnaivaa aanna vaa na taunoo. Fai na i mmoori vareera vaidiivo ausa nuufa tasipama putinaravai. ");
INSERT INTO waj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ivo ti vitoo yoketaivau yapaanaraivaa vaa na ni avuuvaadiri taunoo. ");
INSERT INTO waj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Eenoo mmuakiaa gioonna kiaapuuyani inna teerama kiaannaivo tiivaa makee na tauko nninoo. ");
INSERT INTO waj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ivo mmeekia taivaa roosiima gioonna kiaapu ngiari voopinnaiya yoketaa aataruuvaa kooyaa vitainaravai. Vitaama kinai ii gioonna kiaapu Isarairaa iyakidiri diitaivaara mmuakiaa gioonna kiaapuuyaano iyara kua yoketaivaa kiaaravaivee. Simioono itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tuduu Yisuunna kaano koovaitana Simioono tuu kuaivaara nnikiarauduu ");
INSERT INTO waj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioono kua yoketaivaa iya kiaa mmi kioo nnaakaraivaa kaanaa Mariaanna tunoo: Aa nnaakara aavaa Anutuuqoono mmataama kiai aavaara gioonna kiaapu Isarairaiya fai vooya inna mmooka hanigia mmikiai vooya innara yoketaakiaaravai. Anutuuqo innaadiri atau roosiima yapa kinai fai gioonna kiaapuuya innara maisa kua tikio rikioo ");
INSERT INTO waj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","fai ngiari yaatana vai kuaivo kooyaa vainaravai. Paipaivo avaikaraivaa roosiima fai mmuaararaivo i aakiaivaki nninaravaivee. Simioono itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gioonna forofetaa voovai nnutuuvo Anaava ivo Asereenna oyaivakidiri diitoo varuuvaa koonna nnutuuvo Panueerovee. Ivo vaatiivaa varoo inna tasipama varuu nuanuuvo yaaku saivai karasaidiri taaravaitana taika kiooduu vaatiivo putiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Putuduu too muaadavai hara kioo varududuu kaayau nuanu (84) taika kiooduu ivo yotera kieeravai. Yotera kioo hama ivo nuunaira nnau pinaivaa pikieerama kioo ivo heenaivaa pataivaa nuunama kioo Anutuuqaa ari ausa mmuduuyaivaa mmioo vo suai vo suai yeennaivaa pikioo kati varioo Anutuuqaara yaaku vareeravai. ");
INSERT INTO waj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simioono kuaivaa kiaa taika kioo suaivaki ivo ngioo nnaakaraivaara Anutuuqaata kua yoketaivaa kiaa kioo innara gioonna kiaapuuya kiaa mmiravai. Anutuuqo titano tuoo Yerusareemaiya yookaama kioo vitoo yoketaivau yapaanara vaidiivaara mmuakiaa gioonna kiaapu innara faannauya ivo nnaakaraivaara kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kiaa mmuduu Yoosiipooya Mariaaya Udaanga Anutuuqaa mmaanna tuu aataruuvaa iima taika kiada kava vara ranada ngiari yoosinna Karirayaa vau yoosinna kiisaivaa nnutuuvo Nasareeta viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Oto ivaki varuduu nnaakaraivo yokeenno pinaa kiooduu inna tinniivo ari vookarauduu Anutuuqo innara kaayauma mmuduuya ruoo innara yoketairavai. ");
INSERT INTO waj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Vo nuanu vo nuanu Yisuunna kaano koovaitana Yerusareema vida buusaivaa nnutuuvo Varaigiataivaa nneeravai. ");
INSERT INTO waj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nnaagiai Yisuunna nuanuuvo yaakuuvaitana yukukidiri taaravaitana taika kiooduu teeda iya vida Yerusareema Varaigiataa buusaivaa ngiari nneerayaama nnaara viravai. ");
INSERT INTO waj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Oro iya varida yeenna nneedada yapooma yeenna nneera suaiyauvo taika kiooduu iya ngiari yooqee kava vara ranada viravai. Vida varuduu ngiaammuau kiisa Yisuuva homo Yerusareema variravai. Varuduu kaano koovaitana hama innara rikieeraida ");
INSERT INTO waj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ivo ngiari seena gioonna kiaapuuya tasipama vaa kuainoo kiaa kiada mmuaa suaivai vidada heenauduu innara buaidada tooduu hama ivo ngiari seenaiyaata ngiari oyaiyaatama tasipama variravai. ");
INSERT INTO waj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hama iya tasipama varuduu iya kava vara ranada Yerusareema nnida innara buaakiaara nniravai. ");
INSERT INTO waj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nnida innara buaidada tooduu taaravooma suaivo taika kiooduu ivo iya too vairavai. Vaa ivo nuunaira nnau pinaivaki vaidi Yutayaiya vitaira vaidiiyaatama varioo iya kuaivaa rikioo ivaara iya yaparairavai. ");
INSERT INTO waj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yaparauduu rikiada mmuakiaaya inna kua rikiooya inna tinni ari vookarauvaudiri iya sai tuuvaara nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nnikiaraida ivau varuduu kaano koovaitana numa inna teeda kaayauma nnikiaraida yaaku vuatavuataida varida kaano tunoo: Ni maapu-o, a aaniira ti pikiee itaama nookiannannee? Rikiaanee. I koovaata neetama pinaama ti ausaivaitana mmuaararaikiai ta pinaama aiyara buaama rada nookiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","tuduu rikioo iva sai tunoo: Mo ngia aaniiraida niiyara buaama rada nookiaannee? Na inna aikiooma ni Napoonna nnauvaki hara kiee variauvaa hama ngia tuqinnama teeda rikiaannee? ");
INSERT INTO waj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","tuduu rikiada ivo iya tuu kuaivaa hama iya arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hama iya rikiooduu Yisuuva iya tasipama vara ranoo vioo Nasareeta varioo iya kuaivaa rikiooduu ari kaanoono inna kuaivaata inna mmooriivaatama ari yaata tinniivaki yapeeravai. ");
INSERT INTO waj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yisuuva yokeenno varuduu ari tinniivo ari vookarauduu gioonna kiaapuuya innara yoketauduu Anutuuqootama innara yoketairavai. ");
INSERT INTO waj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Vaidiivaa nnutuuvo Tiperiaava Roomaaya kieetavai dioo vainno nuanu yaakuuvaitana yuku saivai taika kiooduu homo ivo iya kieetavai diravai. Duduu vaidiivaa nnutu vuaivo Podiiva vuaivo Piratuuso gioonna kiaapu Yutayaiyara duduu Herooto gioonna kiaapu Karirayaiyara diravai. Duduu inna vayaava Piriipo gioonna kiaapu Iturayaiyaraatama mmata pinaivaa nnutuuvo Tarakonitiinga ivaki varuuyaraatama duduu vaidi Rusaniiva gioonna kiaapu Avireneeyara diravai. ");
INSERT INTO waj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ii suai ivaki vaidiivaitana Anasaaya Kayapaaya Anutuuqaara kati puara hudeera kieetavaitana variravai. Iqii suai ivaki Sakariaasaa mmaapuuvo Yuvuaano koo mmuyai gaangaivau varuduu Anutuuqo ari kua mmayaayaivaa inna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kiaa mmuduu rikioo Yuvuaano mmuakiaa yoosinnayauvai nnoori Yorotaana siriivau vau yoosinnaiyauvaki nuainno varioo Anutuuqaa mmayaayaivaa gioonna kiaapuuya kiaa mmioo tunoo: Ngia ngiingii mminnamminnaa maisaiyauvaa pikiada hanigiada nnikiai na nnooriivaadiri ngii apino Anutuuqo ngii mminnamminnaa maisaiyauvaa rugaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ivo itaa kua tuuvaara nnaaruaa vaidi forofetaa Yisayaava ari yanaivau fafaara roo tunoo: Vaidi voovoono koo mmuyai gaanga voovau dioo vainno aayanna roo tinara: Ngia ngii kieetaivaara aataruuvaa teerairaivaa roosiima ngii Udaangaivaara teerama kiaatee. Udaangaivo ngiiisi nninaraivaara teeraida safuuma kiaatee. ");
INSERT INTO waj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mmuakiaa hoonuruuyauvaa rummua apida mmuakiaa taapiiyauvaa hanuu varadu kiaatee. Oo rakau numa rakau vai aataruuyauvaa hanuu safuuma kiada aataruuvau sikauyauvo vaiyauvaa teeda hanuu suooda kiaatee. ");
INSERT INTO waj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Fai itaikio Anutuuqo gioonna kiaapuuya vitoo aataru yoketaivau yapaanaraivaa fai mmuakiaaya taaravaivee, tinaravaivee. Yisayaava itaa kua kiaa fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaayau gioonna kiaapuuya nnida Yuvuaano nnoori ti apuaiveera kiaa innasi nnuduu rikioo Yuvuaano tunoo: Ngia gioonna kiaapu maisaso, gioono ngii giaa ngii mikiai Anutuuqo irisai maisaivaa ngii minaraivaara rikiadaida aatuuda niisi ngiaannee? ");
INSERT INTO waj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngia kutaa tuanaa ngiingii mmoori maisaiyauvaa pikiada ngiingii ausa mmuduuyaiyauvaa hanigiada mmoori yoketaivaa iikio kaanaivo kooyaa vainaravai. Sa ngiengienaidiri yaata utida kiatee: Inna Aaparahaamo ti nnaakuvavee. Ta aikiooma variaunnanoo, kiatee. Na ngii giaa ngii miaunoo. Aa sikau aayauvaadiri Anutuuqo iinaree tioo iinai vida hanigiada fai Aaparahaamaa uru nnaakaraya variaaravai. ");
INSERT INTO waj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aanna makee Anutuuqo irisai maisaivaa mminaraivo vaidiivo haivaa yatariiyauvaa oyaiyauvaki teerama kioo tu kioo vaivaa roosiivai. Yatari hama iira yoketaa vaiyauvaa hanaa rakau ikiana kagaari kiaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tuduu rikiada gioonna kiaapuuya inna yaparaida tunoo: Mo dee mmoorivai ta iikiaarannee? ");
INSERT INTO waj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","tuduu rikioo ivo iya sai tunoo: Gioonna kiaapu voovoono yaapa taaravaitana vaivoono voovai hama yaapaataivaa mmiaivee. Gioonna kiaapu voovoono yeenna vakiaivoono ari seenaiyaatama nnoo mmiaivee. ");
INSERT INTO waj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","tuduu rikiada vaidi sikau takiisa vareeraiya Yuvuaano iya nnoori apuaiveera nnida inna yaparaida tunoo: Vitaira-o, teetaatama aaniivai iikiaarannee? ");
INSERT INTO waj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","tuduu rikioo ivo iya sai tunoo: Sikauyauvaa ngii kieetaiya safuuma ngii giaa ngii miaivaugiataama varaatee. Sa ngiingiiiyara yaata utida oro hayuuma varaatee, ");
INSERT INTO waj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","tuduu rikiada rapira vaidiiya inna yaparaida tunoo: Mo tee mo. Ta aaniivai iikiaarannee? tuduu rikioo ivo iya sai tunoo: Sa gioonna kiaapuuya ruputida iya unnakua tida iya sikauyauvaa mmuara varaatee. Ngii mmoori irisai sikauyauvaara sa momonakiatee. Inna aikioovaivee kiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gioonna kiaapuuya Anutuuqo mmataama kioo vaidiivaara faannaida varida mmuakiaaya pinaama Yuvuaanaara yaata utida tunoo: Aanna Anutuuqo mmataama kioo vaidiivonnee? ");
INSERT INTO waj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","tuuvaara Yuvuaano iya mmuakiaaya tunoo: Na kati mmanna nnooriivaadiri ngii apuaunoo. Ivo ni nnaagiai nninaraivoono nnoonna vaidivai. Na vaidi kiisavai. Hama na yopeema mmoori vareera ngiaammuauya roosiima inna yuku nnabaivaitana yeenaivaitana rakuasaa kiee utu radaanaravai. Fai ivoono Anutuuqaa Mmannasa Yoketaivaa tino too ngia vaa ausa hanigiaiya ngii aakiaiyauvaki varinaravai. Hama ausa hanigiaiya fai irisai maisa ikia roosiivaa iya mminaravai. ");
INSERT INTO waj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ivoono ari savoora roosiivaadiri vuiita iiraiyauvaa rummua rusuku kioo supiya uyu ngiau kiaikio rikioo iiraiyauvo mmatayaa tuoo kuaikio iyauvaa varoo ari yeenna yapa kieera nnauvaki yapa kioo nnabaiyauvaa varoo ikia hama tasuuvaki kagaari kiaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yuvuaano itaa kua kiaa kioo ari vo kua ari vo kuaivaatama kuainnama kioo gioonna kiaapuuya mmayaaya yoketaivaa kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Kiaa mmioo gioonna kiaapuuya nnoori apu taika kioo nnaagiai Yisuunnaatama apu taika kiooduu rikioo Yisuuva yaaku varoo varuduu too ngiauvo rusiti varoo vioo sai ngioo sauduu Mmannasa Yoketaivo ngiaamma mirunnaivaa roosuuvoono tuoo tuoo tuma innayaa variravai. Varuduu rikiooduu ngiau aapuuvakidiri Anutuuqaa kuaivo tuoo tunoo: A ni Maapu tuanaakuavee. Na aiyara mmuduuya ruee na i tauko pinaama ni yoketainoo, tiravai. Herooto mmoori maisaivaa uuvaara Yuvuaano inna tuduu rikioo Herooto inna vitoo oovi nnauvaki inna yapa kieeravai. Vaa Herooto ari vayaanna nnaataivaa Herootiaanna mmuara varoovaaraatama ari vo mmoori maisamaisauyauvaa uuvaaraatama Yuvuaano inna tiravai. Herooto kava vo mmoori maisa voovai iinno Yuvuaanaa oovi nnauvaki yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tauraa toosa hareera suaivaki Yisuuva nuainno gioonna kiaapuuya Anutuuqaa mmayaayaivaa kiaa mmiaa roo nuau suaivaki inna nuanuuvo vaidi voovai yuku yaaku taika kioo vo vaidivai yaakuuvaitana vairavai. Gioonna kiaapuuya innara yaata utida tunoo: Inna Yoosiipaa mmaapu tuanaavaivee, tiravai. Yoosiipaa koova Eriiva ");
INSERT INTO waj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eriinna koova Matataava Matataanna koova Riviiva Riviinna koova Merikiiva Merikiinna koova Yanaiva Yanainna koova Yoosiipo ");
INSERT INTO waj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoosiipaa koova Matatiaava Matatiaanna koova Amooso Amoosaa koova Naumo Naumaa koova Esiriiva Esiriinna koova Nagaiva ");
INSERT INTO waj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagainna koova Mataava Mataanna koova Matatiaava Matatiaanna koova Simeeva Simeenna koova Yosekeeva Yosekeenna koova Yotaava ");
INSERT INTO waj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yotaanna koova Yovuaanaano Yovuaanaanaa koova Resaava Resaanna koova Seruvavereeva Seruvavereenna koova Seratiereeva Seratiereenna koova Neriiva ");
INSERT INTO waj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriinna koova Merekiiva Merekiinna koova Adiiva Adiinna koova Kosaamo Kosaamaa koova Eremadaamo Eremadaamaa koova Ereeva ");
INSERT INTO waj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ereenna koova Yosuaava Yosuaanna koova Eriesereeva Eriesereenna koova Yoriimo Yoriimaa koova Matataava Matataanna koova Riviiva ");
INSERT INTO waj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Riviinna koova Simioono Simioonaa koova Yutaava Yutaanna koova Yoosiipo Yoosiipaa koova Yonaamo Yonaamaa koova Eriakiimo ");
INSERT INTO waj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakiimaa koova Meriaava Meriaanna koova Menaava Menaanna koova Matataava Matataanna koova Nataano Nataanaa koova Davuitiiva ");
INSERT INTO waj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davuitiinna koova Isaiva Isainna koova Yoveteeva Yoveteenna koova Buaaso Buaasaa koova Saramoova Saramoonna koova Nasoono ");
INSERT INTO waj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoonaa koova Aminataapo Aminataapaa koova Araamo Araamaa koova Ariniiva Ariniinna koova Eseroono Eseroonaa koova Pereseeva Pereseenna koova Yutaava ");
INSERT INTO waj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yutaanna koova Yakoopo Yakoopaa koova Isaako Isaakaa koova Aaparahaamo Aaparahaamaa koova Taraava Taraanna koova Nakoroova ");
INSERT INTO waj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakoroonna koova Serukuuva Serukuunna koova Reguuva Reguunna koova Peregeeva Peregeenna koova Evereeva Evereenna koova Seraava ");
INSERT INTO waj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seraanna koova Kainaano Kainaanaa koova Arapasataava Arapasataanna koova Seemo Seemaa koova Nuvuaava Nuvuaanna koova Ramekeeva ");
INSERT INTO waj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ramekeenna koova Metusaraava Metusaraanna koova Inooko Inookaa koova Yareeto Yareetaa koova Marereeva Marereenna koova Kainaano ");
INSERT INTO waj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainaanaa koova Enosoova Enosoonna koova Seeto Seetaa koova Ataamovee. Ataamo inna Anutuuqaa mmaapuuvovee. ");
INSERT INTO waj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yisuuva nnoori Yorotaanaivakidiri kava vara ranoo nnuduu Mmannasa Yoketaivo inna aakiaivaki suvuau kioo inna vitoo koo mmuyai gaanga voovaura viravai. ");
INSERT INTO waj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Oro hara kioo varuduu taara vaidivaitana yuku yaaku taika kioo suaiyauvaki ivo muaraagakiaiveera Sataango numa inna iinno taanee kiaa inna yaparairavai. Yaparaududuu Yisuuva mmuakiaa suaivai hama yeenna nneerama kioo kati hara kioo varududuu suaivo taika kiooduu pinaama inna yeenna rairavai. ");
INSERT INTO waj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yeenna rauduu rikioo Sataango Yisuunna tunoo: A Anutuuqaa Mmaapukuavee tiee aa sikau aavaa tino too hanigioo yeenna bereetavai vakiaivee, ");
INSERT INTO waj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tuduu rikioo Yisuuva inna kuaivaa sai tunoo: Anutuuqaa kua fafaaraivo vainno tinoo: Gioonna kiaapuuya yeennaiyauvaa nnaasu nneeda iyauvaara yaata utikio hama iyauvoono iya mmannasaiyauvaa yaagueeqainaravaivee, tiivaivee. ");
INSERT INTO waj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tuduu rikioo Sataango Yisuunna vitoo verepi vioo mmuakiaa yoosinna mmataivau vauyauvaa akiairaama inna vitainno ");
INSERT INTO waj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","inna tunoo: Aa yoosinna aayauvaara dianeera yaagueeqaivaa na i mminai tee a dinaravai. Mmuakiaa mminnaa yoketaiyauvo ivaki vaiyauvaa fai na i mminaravai. Anutuuqo vaa aa mminnaa aayauvaa ni mivaivee. Fai na vaidi voovai ni miataivaa fai na inna mminaravai. ");
INSERT INTO waj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Fai a ai ausa mmuduuyaivaa ni minai na aa mminnaa mmuakiaa aayauvaa i mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","tuduu rikioo Yisuuva inna sai tunoo: Anutuuqaa kua fafaaraivo vainno tinoo: I Udaanga Anutuuqaa ai ausa mmuduuyaivaa mmiee inna mmooriivaa nnaasu iikianee, tiivaivee. ");
INSERT INTO waj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ivo itaa kua tuduu rikioo Sataango inna vitoo Yerusareema vioo nuunaira nnau pinaivaa pupukiaivau yapa kioo inna tunoo: A Anutuuqaa Mmaapukuavee tiee aavaudiri suairoommu kiee mmatayaa kuanee. ");
INSERT INTO waj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anutuuqaa kua fafaaraivo vainno tinoo: Anutuuqo ari aangeraiya titanai aiyara haitatuukiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","tikio vo kua voovai vainno tinoo: Ai yukuuvaa sikauyaadiri rusimmaurivoora kiaa iya ngiari yaakuuyauvaadiri suoodaa i sootu utuaaravaivee. Kua fafaaraivoono itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","tuduu rikioo Yisuuva inna sai tunoo: Anutuuqaa kua fafaaraivo vainno tinoo: Sa i Udaanga Anutuuqaa iinna taanee, tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","tuduu rikioo Sataango Yisuunna mmuakiaa kuavai yaparainnonno rikioo inna pikioo viravai. Mo vo suai kava inna yaparainaraivaara ivo faannainno variravai. ");
INSERT INTO waj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mmannasa Yoketaivo yaagueeqama Yisuunna tasipooduu too kava vara ranoo Karirayaa vuduu gioonna kiaapuuya iva uu mmooriivaara mmuakiaa yoosinnaiyauvaki varuuya kiaa mmuduu rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Rikiooduu ivo ngiari nuunaira nnauyauvaki nuainno varioo mmayaaya yoketaivaa iya kiaa mmuduu rikiada iya innara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yisuuva ari yokoo yoosinna Nasareetaivakira vioo vioo oro ivaki varioo kati varira suaivaki nuunaira nnauvaki ari virayaama vioo ivaki variravai. Varioonnonno diitoo Anutuuqaa kua fafaaraivaa yaarinara uuduu ");
INSERT INTO waj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","vaidi voovoono nnaaruaa vaidi forofetaa Yisayaanna yanaivaa inna mmuduu varoo yanaa hovekauvaa raduda kioo kuaivaara buainnonno tooduu inna too vauduu too yaaruoo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Na mmayaaya yoketaivaa gioonna kiaapu mmanna haipuuya kiaa mmianeeraivaara Udaangaivo ni mmataama kiaivai. Ivo itaama ni mmataama kiaivaara inna Mmannasaivo niiki varinoo. Gioonna kiaapu oovi nnauvaki variaiya mmaanai kuateeraivaara na iya kiaa mminaraivaara ivo ni titaivai. Gioonna kiaapu avu huruutaiya kava avu taateeraivaara ni titaivai. Gioonna kiaapu mmuaararaiyauvo iya suvuaiya tino too iya mmuaararaiyauvo taikaiveeraivaara ni titaivai. ");
INSERT INTO waj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ii suai ivaki Udaangaivo gioonna kiaapuuya vitoo aataru yoketaivau yapaanaraivaara iya kiaa mmianeera ni titaikiai na tummuauvaivee. ");
INSERT INTO waj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yisuuva Anutuuqaa kuaivo itaama vauvaa yaarummua taika kioo yanaivaa kava hovekama kioo yanaa haitatuura vaidiivaa mmi kioo variravai. Varuduu mmuakiaa gioonna kiaapu nuunaira nnauvaki varuuya inna teeda nnaasu vauduu ");
INSERT INTO waj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yisuuva iya tunoo: Aanna makee na kuaivaa yaaruau saivaata kaanaivo vainoo, ");
INSERT INTO waj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","tuduu rikiada mmuakiaaya innara kua yoketaivaa tida ivo kua ari vookarauvaa tuuvaara pinaama yaata utida ngiari yapara ngiari yaparaida tunoo: Aanna Yoosiipaa mmaapuvai. Mo aaniira ivo itaa kua tiinnee? tiravai. ");
INSERT INTO waj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yisuuva iya tunoo: Vaa na rikiaunoo. Fai ta tupaa tira kua voovai ngia ni tida kiaara: A tutaaqaa roosiima aiyara tuqinnaanee, kiaaravee. Ii ngia itaa kua kiaa kua oyaivaa ni tida kiaara: A iikiannani ta rikiaunna mmooriivaa a yoosinna Kapanauma iikiannaneema a yokeekianna yoosinna aavaki iikianee. Fai ngia ni itaa kua kiaaravee. ");
INSERT INTO waj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na kua kutaavai ngii giaa ngii miaunoo. Kua kutaa tira vaidi forofetaivaara mmuakiaa yoosinnaiya innara yoketaakiaani ari yoosinna tuanaiya hama innara yoketaakiaavai. ");
INSERT INTO waj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na kua kutaavai ngii giaa ngii miaunoo. Nnaaruaa vaidi Irayaava varuu suaivaki gioonna muaada kaayauya Isarairaa mmataivau variravai. Varuduu taaravooma nuanuuvo taika kiooduu vo nuanuvai tammaivaki hama vatiivo ruduu hama yeennaatauduu mmuakiaa yoosinna varuuya yeenna rairavai. ");
INSERT INTO waj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Iya yeenna rauduu hama Anutuuqo vaidi forofetaa Irayaanna titooduu vioo Isarairaa gioonna muaadaiyara tuqinneeravai. Ivo vioo Sitoonaa mmataivaki vau yoosinna kiisaivaa nnutuuvo Sarepataa ivaki varuu gioonna muaadaivaa nnaasu tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nnaaruaa vaidi forofetaa voovai nnutuuvo Irisaava varuu suaivaki Isarairaa gioonna kiaapu kaayauya mmamma buunna hooya roosuuya variravai. Anutuuqo hama iya tuqinneeravai. Suriaa vaidiivaa nnutuuvo Naimaanaa nnaasu tuqinneeravaivee, ");
INSERT INTO waj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","tuduu rikiada gioonna kiaapu nuunaira nnauvaki suvuauya inna kuaivaara iya ausa nniitarooduu ");
INSERT INTO waj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","diitada inna utu raririida yoosinna tooyaivau vida taapiivau ngiari yoosinnaivo vauvau vitada vida mmutuuvaudiri feena oogaivau kagaari kiaara iiravai. ");
INSERT INTO waj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kagaari kiaara uuduu too ivo kati iya aakiaidaadiri ari kuanee tuudaa viravai. ");
INSERT INTO waj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yisuuva kava vara ranoo vioo vioo yoosinna Kapanauma Karirayaa vau yoosinnaivaki oro varioo Yutayaiya kati varira suaivaki nuunaira nnauvaki vioo gioonna kiaapuuya Anutuuqaa mmayaayaivaa kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kiaa mmuduu rikiada ari vookarau yaagueeqaivo inna tasipooduu kuaivaa tuuvaara gioonna kiaapuuya nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nnikiarauduu vaidi voovai inna aakiaivaki mmagia maisaivo topauvo nuunaira nnauvaki varioo pinaama kai tioo mmagia maisaivo inna kiaa mmuu kuaivaa tunoo: ");
INSERT INTO waj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ai, Yisuu-o, Nasareetaa vaidikuavee. A aaniivai ti iinarainna ngiannannee? A ti ruputu taikaanara ngiannannee? Vaa na i tauvai. A Anutuuqaa vaidi yoketaa tuanaakuavee, ");
INSERT INTO waj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","tuduu rikioo Yisuuva yaagueeqama mmagia maisaivaa tunoo: Sa kua tirainna vaidiivaa aakiaivakidiri tiee kuanee, tuduu rikioo mmagia maisaivo vaidiivaa ruputuduu iya avuuvau vioo varoo mmataivau vauduu mmagia maisaivo inna aakiaivakidiri pikioo vioo kiooduu hama inna mmammaivo nniitareeravai. ");
INSERT INTO waj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hama nniitarooduu mmuakiaa gioonna kiaapuuya teeda nnikiaraida ngiari kiaa mmi ngiari kiaa mmiida tunoo: Mo aa vaidi aavo aanii kuavai ari vookarai kua aavaa tiinnee? Ivo yaagueeqa vaidivai vaidi kieetaano tirayaama mmagia maisaiyauvaa yaagueeqama tikiai kuaanoo, ");
INSERT INTO waj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","tuduu rikiada gioonna kiaapuuya teeda vida mmuakiaa vaini vainima vau yoosinnaiyauvaki varuuya Yisuuva uu mmooriivaara kiaa mmuduu rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yisuuva nuunaira nnauvakidiri pikioo Simoonaa nnauvaki vioo tooduu Simoonaa nnummuayaanna nniitarooduu pinaama ikiayanaa tooduu iya innara Yisuunna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kiaa mmuduu rikioo oro inna mmaataivaa vainiivau dioo vainno inna ikiayanaa taivo taikaiveera tuduu taikooduu akiairauduu diitoo yeennaivaa iya mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mmuduu rikioo suaivo haatapooduu teeda gioonna kiaapu vooyaano ngiari seena nniitaroo ari vookara ari vookarauya vitada Yisuunnasi nnuduu too iyayaa ari yaakuuvaitana utuoo mmuakiaaya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tuqinnooduu gioonna kiaapuuya aakiaiyauvakidiri mmagia maisaiyauvo iya pikiada tiida vida tunoo: A Anutuuqaa Mmaapu tuanaakuavee, tuduu rikioo Yisuuva iya yaagueeqama ooqoo tioo tunoo: Sa kua kiatee, tiravai. Ivo Anutuuqo mmataama kioo vaidivai varuuvaara mmagia maisaiya arinaima teeda rikieeravai. Iya innara itaama teeda rikioovaara Yisuuva iya ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Patauduu Yisuuva diitoo yoosinnaivaki pikioo oro kumina mmata voovau variravai. Varuduu gioonna kiaapuuya innara buaama rada nuaidada tooduu iya too vauduu teeda ivo iya pikieevoora kiaa ooqoo kiaaree kiaa uuduu ");
INSERT INTO waj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yisuuva iya tunoo: Na Anutuuqo gioonna kiaapuuyara dira mmayaaya yoketaivaa nuaina variee vo yoosinna vo yoosinna variaa gioonna kiaapuuyaatama kiaa mmianeera Anutuuqo ni titooduu na tiiravaivee, ");
INSERT INTO waj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","kiaa kioo nuainno varioo Yutayaiya nuunaira nnauyauvaki varioo Anutuuqaa mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Vo suai Yisuuva nnoori haruungaivaa nnutuuvo Genesareeta siriivau dioo vainno Anutuuqaa kua yoketaivaa tioo varuduu gioonna kiaapuuya Anutuuqaa kuaivaa rikiaara iida varida ngiari feena ngiari feenaida varida inna suvuairavai. ");
INSERT INTO waj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Inna suvuau kiada uuduu iva tooduu kanuu taaravaitana inna too vauduu vaa nakaaraiya utu raririima rada siriivau yapa kiada oro ngiari utua vaaheeyauvaa finida variravai. ");
INSERT INTO waj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Finida varuduu Yisuuva kanuu voovaki karoo dioo vainno ivaa nakaaraivaa Simoonaa yaparainno tunoo: Ai kanuu aavaa feenano nnoori tooyannigiataa kuaivee, tuduu rikioo feena kiooduu vuduu Yisuuva ivaki varioo gioonna kiaapuuya mmayaayaivaa kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kiaa mmi taika kioo Simoonaa tunoo: Ai kanuuvaa kava feena kino nnoori haruunga tammaa ivau vinai eenoo ai seenaiyaatama ngiingii utua vaaheeyauvaa varada ivaki kagaari kikio vinai tavauyauvaa varaatee, ");
INSERT INTO waj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tuduu rikioo Simoono sai tunoo: Nnoonna-o, ta heenagieena puruaunnanono hama tavauyauvo ti tainoo. Mo inna aikioo a tinai tee na kava utua vaaheeyauvaa kagaari kiaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","kiaa kioo ivo ari seenaiyaatama ngiari utua vaaheeyauvaa varada oro kagaari kiooduu vuduu tavauyauvo iya utua vaaheeyauvaki nnida vidada suvuai kiada vauduu iya utua vaaheeyauvo takeekiataama uuduu ");
INSERT INTO waj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ngiari seena tavau vareera vooya vo kanuuvaki varuuyara rootu maavee tida tunoo: Numa ti tasipama tavau aayauvaa varaatee, tuduu rikiada nnuduu taara kanuuvaitanaki tavauyauvo fuugiaama kioo vauduu kanuuvaitana mmeepi nnoori aakiaivaki kuataama iiravai. ");
INSERT INTO waj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kuataama uuduu Simoono Petorooso ivaa too Yisuunna yuku oyaivaki toorivu yau haroo tunoo: Udaanga-o, ni mminnamminnaa maisaivo ni suvuaivaara ni pikiee kuanee. ");
INSERT INTO waj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Petorooso ariyara nnikiarainno itaa kua tiravai. Ivootama mmuakiaa vaidiiya inna tasipooyaatama kaayau tavauyauvaa varoovaara ngiariyara nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nnikiarauduu Simoonaa vuaivaitana Sevetainna mmaapuuvaitana Yakoopaya Yuvuaanayaatama nnikiarairavai. Nnikiarauduu Yisuuva Simoonaa tunoo: Sa aatuunna varianee. Fai yapooma a tavau vareerayaama a gioonna kiaapuuya vitee niisi nninaravai. Fai a mmayaaya yoketaivaa iya kiaa mminai rikiada fai ni nnaagiai ngiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","tuduu rikiada varada vida kanuuvaitanaakidiri nnoori siriivau reemi rada ngiari mminnaa mmuakiaayauvai pikiada Yisuunna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Vo suai voovaki Yisuuva vo yoosinnavaki varuduu vaidi buunna hooya mmamma roosuuvoono innasi nniravai. Numa Yisuunna too inna yuku oyaivaki vioo varoo vainno yaagueeqama inna yaparainno tunoo: Udaanga-o, a ni mmammaivaa tuqinnaanaree tiee fai a aikiooma tuqinnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","tuduu rikioo Yisuuva ari yaakuuvaa reeti vaidiivaa mmammaivau utuoo tunoo: Fai na i tuqinnaanaravaivee. Na tino i mmammaivo yoketaakiaivee. Ivo itaa kua tuu saivaata inna mmammaivo buunna hooya mmamma roosuuvo taikeeravai. ");
INSERT INTO waj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Taika kiooduu Yisuuva yaagueeqama inna kiaa mmioo tunoo: Na i iikiauvaara sa gioonna kiaapu vooya kiaa mmianee. Akiairaama viee Anutuuqaara kati puara hudeera vaidiivaa ai mmammaivaa inna vitaama kiee i mmammaivo kava yoketaivaara nnaaruaa vaidi Musiiva tuuvaugiataama puara sipisiipaivaa kati ruputu kiee Anutuuqaara hudaanee. Hudanai rikiada gioonna kiaapuuya i mmammaivo yoketaivaara arinaima teeda rikiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","tuduu rikioonnaata Yisuuva uu mmooriivaara gioonna kiaapuuya kiaa mmuduu kaayakaayau Yisuuva iya kiaa mmuu kuaiyauvaa rikiaara nnida ivo ari vookara ari vookarau nniitarooya tuqinnaiveeraivaara innasi nniravai. ");
INSERT INTO waj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Iya itaama uuduu suai vooyauvaki Yisuuva iya pikioo kumina mmata vooyauvaki varioo yaaku varaanara viravai. ");
INSERT INTO waj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Vo suai Yisuuva gioonna kiaapuuya kua mmayaayaivaa kiaa mmioo varuu suai voovaki Farisai vaidi vooyaata kua mmaanna kiaa mmira vaidi vooyaatama diitada mmuakiaa yoosinna Karirayaa vauyauvakidiri nnida mmuakiaa yoosinna Yutayaa vauyauvakidiri nnida yoosinna Yerusareemaivakidiriaatama nnida ivaki variravai. Ivaki varuduu Udaangaivo vaidi nniitarooya tuqinneera yaagueeqaivaa Yisuunna mmuduu innaki vairavai. ");
INSERT INTO waj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Vauduu vaidi vooyaano vaidi yuku yaaku putuuvaa ari kegeennaivau vuru vauvaa taina rau varada Yisuuva varuu nnauvakira nnida Yisuunna vunnigiataa yapaara nniravai. ");
INSERT INTO waj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nnida tooduu gioonna kiaapuuya Yisuunna suvuau kiooduu hama iya inna varada Yisuunnasi ngiaara aataruuvootauduu teeda nnauvau karada tausiivaa rabara kiada gioonna kiaapuuya aakiaivaki Yisuunna vunnigiataa yuku yaaku putuu vaidiivaa kegeennaivaa utida reemma kiooduu tiiravai. ");
INSERT INTO waj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tuuduu rikioo iya ngiari yaata tinniiyauvaki vau kuaivaa Yisuunnara tunoo: Ivo aikiooma tuqinnaanaravaivee, tuu kuaivaa Yisuuva rikioo vaidi yuku yaaku putuuvaa tunoo: Boo, ni vaidivai vaa na kiauko i mminnamminnaa maisaiyauvo taikainoo, ");
INSERT INTO waj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","tuduu rikiada kua mmaanna kiaa mmiraiyaata vaidi Farisaiyaatama ngiari yaata tinniiyauvaki kuaivaa yaata utida tunoo: Dee vaidivoono ariiyara yaata utuoo Anutuuqaa roosiima kua tiinnee? Hama vaidi voovoono yopeema vaidiiya mminnamminnaa maisaiyauvaa rugaivaivee. Anutuuqo ari mmuaavoono vaidiiya mminnamminnaa maisaiyauvaa rugeeraivovee, ");
INSERT INTO waj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","tuduu rikioo Yisuuva iya yaata tinniyaa vau kuaivaa rikioo iya tunoo: Ngia aaniira ngiingii yaata tinniiyauvaki itaama yaata utida kua kiaannee? ");
INSERT INTO waj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dee kuavai yoketainnee? Dee kuavai ari vookarainnee? Fai na tinara: Vaa na kiauko i mminnamminnaa maisaiyauvo taikainoo, tinarannee? Vara na tinara: Diitee kuanee, tinarannee? ");
INSERT INTO waj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aa mmata aavau Na Vaidiivaa Mmaapuuvoono gioonna kiaapuuya mminnamminnaa maisaiyauvaa rugeeraivaa nakaaraivovee. Fai na iinai ngia ivaa taaravaivee, kiaa kioo vaidi yuku yaaku putuuvaa tunoo: Na i kiaa i mmiaunoo. Diitee ai kegeennaivaata varee ai nnauki kuanee. ");
INSERT INTO waj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ivo itaa kua tuu saivaata iya avuuvau vaidiivo diitoo ari kegeennaivaata varoo Anutuuqaara kua yoketaivaa kiaa roo ari nnauvaki viravai. ");
INSERT INTO waj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vuduu teeda gioonna kiaapuuya kaayauma nnikiaraida aatuuda Anutuuqaara kua yoketaivaa tida tunoo: Ai, makee hama ta taunna mmoori ari vookaraivaa ta taunnanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tuduu Yisuuva mmaanai vioo tooduu vaidi sikau takiisa vareeraivaa nnutuuvo Riviiva ari sikau takiisa vareera nnauvaki variravai. Varuduu too Yisuuva inna tunoo: Ni nnaagiai ngianee, ");
INSERT INTO waj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","tuduu rikioo Riviiva diitoo ari mminnamminnaa mmuakiaavai pikioo Yisuunna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yapooma nnaagiai Riviiva Yisuunnani buusaivaa ari nnauvaki iima kiooduu kaayau sikau takiisa vareera vaidi maisa vooyaata ari vo gioonna kiaapuuyaatama iya tasipama yeenna nneeravai. ");
INSERT INTO waj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yeenna nneeda varuduu Farisai vaidi vooyaata kua mmaanna kiaa mmira vaidi vooya Farisaiya mmemmaaki varuuyaatama Yisuunna ngiaammuauya tasipama kua tida yaagueeqama ooqoo tida tunoo: Mo ngia aaniira sikau takiisa vareera maisa vaidiiyaatama mmaanna tuu kuaivaa katokeera gioonna kiaapu maisaiya tasipama yeennaivaata nnooriivaatama nnaannee? ");
INSERT INTO waj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","tuduu rikioo Yisuuva iya sai tunoo: Gioonna kiaapu homoraiya hama kuminayaa nniitareeraiya tuqinneera vaidiivaasi kuaavai. Gioonna kiaapu nniitareeraiya nnaasu innasi kuaavaivee. ");
INSERT INTO waj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Hama na tiee tinai gioonna kiaapu yoketaama variaiya hanigiada yoketaama variateera na tiiravai. Na tiee gioonna kiaapuuya mminnamminnaa maisa suvuaiya tinai hanigiada yoketaama variateeraivaara na tiiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tuduu gioonna kiaapu vooyaano Yisuunna tunoo: Yuvuaanaa nnaagiai nuairaiya makemakee iya Anutuuqaara yaata utida ngiari yeenna nneeraivaara ooqoo kiaa kiada kati varida yaaku varada variaavai. Farisaiya nnaagiai nuairaiyaatama mmuaikaraama iikiaavai. Mo i ngiaammuauya kati yeennaiyauvaata nnooriiyauvaatama nneeda variaanoo, ");
INSERT INTO waj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","tuduu rikioo Yisuuva mmataira kuaivaa iya sai tunoo: Mo yaapeeri nneera suaivaki kieevatiivo gioonna kiaapuuya tasipama varikiai hama iya yopeema yeenna nneeraivaara ooqoo kiaaravai. Fai iya nnaaravai. ");
INSERT INTO waj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Fai suai voovai nninai rikiada vaidiiya kieevatiivaa vitada ruputikiai ii suai iyauvaki iya yeenna nneeraivaara ooqoo kiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yisuuva itaa kua kiaa kioo mmatayaa diaa mminnaa voovaudiri mmataama kioo tunoo: Hama gioonna kiaapu voovoono karaasa buruqaivaa rapasi kioo varoo oro nnisiivaki funnivai. Fai itaino karaasa buruqa rapasi kiaivo maisaino karaasa buruqa araivoota nnisiivootama fai hama mmuaakaraivai vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hama gioonna kiaapu voovoono vuaina suuya karaasaivaa puara nnaba funnu kiaa nnisiivaki tusaa uyivai. Fai tusaa uyu kino karaasa vuaina suuyaivo vainno yootano puara nnaba nnisiivo rusitinaravai. Rusitino rikioo vuaina suuyaivo tuoo vino rikioo puara nnabaivo maisainaravai. ");
INSERT INTO waj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Karaasa vuaina suuyaivaa puara nnaba karaasaivaki tusaa uyuaivee. ");
INSERT INTO waj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Gioonna kiaapu voovoono vuaina suuyaivaa vaa hokobama vaivaa nnoo karaasa iima kiaivaara hama mmuduuya ruaivai. Ivo tinoo: Hokobama vaivaara ni yoketainoo, tiivaivee. Yisuuva nnisi aataruuvoota karaasa aataruuvootama hama yoketaama mmuaavau vauvaara itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yisuuvaata ari ngiaammuauyaatama Yutayaiya kati varira suai voovaki yeenna vuiita mmooriivaki nuaida varuduu ari ngiaammuauya vuiitaivaa iiraiyauvaa rasuku kiada utu sisaama kiada nnabaiyauvaa feena pikiada kaanaiyauvaa nneeravai. ");
INSERT INTO waj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nneeda varuduu rikiada vaidi Farisai vooya iya teeda tunoo: Ai, mo ngia aaniira ta kati varira suaivaki ti mmaanna tira kua aataruuvaa hatokaannee? ");
INSERT INTO waj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","tuduu rikioo Yisuuva iya sai tunoo: Ngia Davuitiinna mmayaayaivo yanaivau vaivaa yaarida hama tuqinnama rikiaavai. Nnaaruaa vaidi Davuitiivaata ari tasipama nuauyaatama kaayauma iya yeenna rauduu rikioo ");
INSERT INTO waj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davuitiivaano Anutuuqaara nuunaira nnauvaki vioo yeenna bereeta kati Anutuuqaaniee kiaa yapoo yeennaiyauvaa varoo nnoo ari tasipama nuauyaatama mmuduu nneeravai. Ti mmaanna tuu kua aataruuvo vainno tunoo: Anutuuqaara kati puara hudeeraiyaano nnaasu Anutuuqaaniee kiaa yapoo yeenna bereetaiyauvaa nnaatee, tuduaata Davuitiiva ari tasipama nuauyaatama ii kua ivaa hatoka kiada nnooduu hama Anutuuqo ooqoo tiravaivee, ");
INSERT INTO waj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","kiaa kioo iya tunoo: Na Vaidiivaa Mmaapuuvoono kati varira suaivaa nakaaraivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kati varira suai voovaki Yisuuva nuunaira nnauvaki vioo mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmioo varuduu vaidi voovai yaaku yaadudaivo sorogainno taminnumaunnuunno vuuvo ivaki variravai. ");
INSERT INTO waj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ivaki varuduu kua mmaanna kiaa mmira vaidiiyaata Farisai vaidi vooyaatama Yisuuva kati varira suaivaki gioonna kiaapu yuku yaaku maisauya tuqinnaanarannee kiaa inna puaisakama teeda vairavai. Ivo koonnama iinai rikiada kua pinaivaa innaki yapaaraivaara inna puaisakama teeda vairavai. ");
INSERT INTO waj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Teeda vauduu Yisuuva iya yaatana vau kuaivaa rikioo vaidi yaaku sorogauvaa tunoo: Diitee numa aapi iya avuuyauvunu dianee, tuduu rikioo diitoo numa dioo vauduu ");
INSERT INTO waj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yisuuva mmuakiaa gioonna kiaapuuya tunoo: Na ngii yaparakiaunoo. Ta kati varira suaivaki dee mmoorivai iikiaarannee? Ti mmaanna tira kuaivo dataa kuainno tiinnee? Vara ta mmoori yoketaivaa iikiaarannee? Vara ta mmoori maisaivaa iikiaarannee? Vara ta vaidi nniitaraivaa tuqinnaarannee? Vara ta vaidiivaa ruputikio putinarannee? ");
INSERT INTO waj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","kiaa kioo mmuakiaaya haitatuuma too vaidi yaaku sorogauvaa tunoo: Ai yaakuuvaa raduda utuanee, tuduu rikioo ari yaakuuvaa raduda utuduu yoketauduu ");
INSERT INTO waj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","vaidi kua mmaanna kiaa mmiraiyaata Farisaiyaatama ivaa teeda pinaama iya ausaiyauvo nnannatooduu Yisuunna iikiaara inna mmaara kuaivaa ngiari kiaa mmi ngiari kiaa mmiida teerama kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ii suai ivaki Yisuuva taapiivaura vioo vioo oro varioo heenagieena Anutuuqaara yaaku vareeravai. ");
INSERT INTO waj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yaaku varooduduu patauduu varioo gioonna kiaapu inna nnaagiai nuairaiya ngiateera tuduu innasi nnuduu mmayaaya yoketaivaa varada nuaira ngiaammuau yaakuuvaitana yukukidiri taaravaitana nnutuuyauvaa kooyaa tiravai. ");
INSERT INTO waj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Voovai nnutuuvaa Simoono tiravai. Yisuuva inna nnutu karaasaivaa Petorooso tiravai. Voovai Petoroosaa kataivaa nnutuuvaa Adiriaaso tioo voovai nnutuuvaa Yakoopo tioo voovai nnutuuvaa Yuvuaano tioo voovai nnutuuvaa Piriipo tioo voovai nnutuuvaa Batoromaivavee tioo ");
INSERT INTO waj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","voovai nnutuuvaa Mataivavee tioo voovai nnutuuvaa Tumaaso tioo voovai Arapainna mmaapuuvaa nnutuuvaa Yakoopo tioo vaidi vooya inna mmataivaa varoovaara kaayauma rapira vaidiivaa nnutuuvaa Simoono tioo ");
INSERT INTO waj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","voovai Yakoopaa mmaapuuvaa nnutuuvaa Yutaaso tioo voovai nnutuuvaa Yutaaso Isariooto tiravai. Ivoono nnaagiai Yisuunna nnammutuaiya fai kooyaa inna vitainaraivaara kua yeena rau kieera vaidivai. ");
INSERT INTO waj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yisuuvaata ari ngiaammuauyaatama taapiivaudiri tiidada tuma hoonuruuvau dida vauduu kaayau ari nnaagiai nuairaiyaata kaayau gioonna kiaapuuya mmuakiaa yoosinna Yutayaa ivaki vauvakidiriaatama nnuduu yoosinna pinaa Yerusareemaivakidiriaatama nnuduu nnoori pinaivaa siriivau vau yoosinna Turu Sitoonaivaitanakidiriaatama nniravai. Iya ivo tinara kuaivaa rikiaaraivaaraata ivo iya nniitarooyauvaa tuqinnaanaraivaaraatama nniravai. ");
INSERT INTO waj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nnuduu rikiada mmagia maisaiyauvo gioonna kiaapuuya aakiaiyauvaki varuuyaatama innasi nnuduu ivo mmagia maisaiyauvaa titeeravai. ");
INSERT INTO waj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yisuunnakidiri yaagueeqa ari vookarauvo vioo iya tuqinnooduu rikiada mmuakiaaya inna mmammaivau utuaara iiravai. ");
INSERT INTO waj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yisuuva ari nnaagiai nuairaiya reeti too tunoo: Ngia gioonna kiaapu hama mmatayaa diaa mminnaiyauvaara mmuduuya ruaiyara Anutuuqo ngiiiyara yoketainoo. Anutuuqo gioonna kiaapuuyara diraivo vaa ngiiisi vainoo. ");
INSERT INTO waj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ngia gioonna kiaapuuya aanna makee ngii yeenna raiyara Anutuuqo ngiiiyara yoketainoo. Yapooma fai ngii yeenna rairaivo taikaanaravai. Ngia gioonna kiaapu aanna makee ngii ausaiyauvo mmuaararaiyara Anutuuqo ngiiiyara yoketainoo. Fai yapooma ngia yoketaama variaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Na Vaidiivaa Mmaapuuvaa ngia gioonna kiaapuuya niiyara yaagueeqakiaivaara fai gioonna kiaapu vooyaano hama ngiiiyara mmuduuya rida ngii ooqoo kiaa ngiiiyara maisayavee tida ngia tomedama variateera ngiiiyara kiaaravai. Ngia niiyara yaagueeqakiaiyara Anutuuqo ngiiiyara yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Fai iya ngiiiyara itaama iikio ngii ausaiyauvo yoketa yoketainai rikiada sirigaida variatee. Ngii irisai yoketaa pinaivo ngiiini ngiau aapu vaivaara sirigakiatee. Vaa iya taato nnaakukiaiyaano mmuaikaraama forofetaa tuanaiyara maisama itaama iiravaivee. ");
INSERT INTO waj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngia gioonna kiaapu mmatayaa diaa mminnaiyauvaara kaayauma mmuduuya ruaavo ngii suvuaiyara hama Anutuuqo ngiiiyara yoketainoo. Vaa ngia ngiingii irisaiyauvaa varaavaivee. ");
INSERT INTO waj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ngia gioonna kiaapu aanna makee yeennaiyauvo ngii suvuaiyara hama Anutuuqo ngiiiyara yoketainoo. Fai yapooma ivaara ngii yeenna rainaravaivee. Ngia gioonna kiaapu aanna makee ngii ausaiyauvo yoketaiyara hama Anutuuqo ngiiiyara yoketainoo. Fai yapooma ngii ausaiyauvo mmuaararainaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngia gioonna kiaapu hama Anutuuqaara yaagueeqakiaiya fai mmuakiaa gioonna kiaapuuya ngiiiyara yoketaayavee tikiai rikiada ngiingii aataruuyauvaara tuqinnama yaata utuatee. Boo, ngia yapooma fai dataakiaarannee? Fai ngia irisai maisaivaa varaaravaivee. Yutayaiya taato nnaakukiaiyaano mmuaikaraama kua yoketaivaa unnakua forofetaiyara tiravaivee. ");
INSERT INTO waj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ngia gioonna kiaapuuya ni kuaivaa rikiaiya na ngii giaa ngii miaunoo. Ngiingii nnammutuaiyara mmuduuya ruatee. Gioonna kiaapuuya hama ngiiiyara mmuduuya ruaiyara ngia mmoori yoketaivaa iyara iikiatee. ");
INSERT INTO waj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gioonna kiaapuuya ngiiiyara kua maisa kiaiya irisai kua yoketaivaa iya kiaa mmiatee. Gioonna kiaapuuya mmoori maisaivaa ngii mikiai iyara yaaku varaatee. ");
INSERT INTO waj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Gioonna kiaapu voovoono i kueennaivaa rudaunai rikiee hanigia saivaata mmianee. Gioonna kiaapu voovoono i yaapa varaayaa vaivaa ariyara varanai rikiee sa i yaapa voovai mmammayaa vakiaivaaraatama ooqoo kianee. ");
INSERT INTO waj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gioonna kiaapu voovoono mminnaa voovaara i yapara rinai mmianee. Fai voovoono i mminnaiyauvaa varoo vinai rikiee sa kava ni mianeera kianee. ");
INSERT INTO waj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gioonna kiaapuuya mmooriivaa ngiiiyara iikiaavo ngii yoketaivaara ngieeta mmuaakaraama iyara iikiatee. ");
INSERT INTO waj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ngia gioonna kiaapuuya ngiiiyara mmuduuya ruaiyara nnaasu irisai iyara mmuduuya rikio ivaara fai hama Anutuuqo irisai kua yoketaivaa ngiiiyara tinaravaivee. Mo gioonna kiaapu mminnamminnaa maisa suvuaiyaano ii aataru ivaa iikiaanoo. ");
INSERT INTO waj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ngia gioonna kiaapuuya mmoori yoketaivaa ngii miraiya nnaasu irisai mmoori yoketaivaa iya mmikio ivaara fai hama Anutuuqo irisai yoketaivaa ngii minaravaivee. Mo gioonna kiaapu mminnamminnaa maisa suvuaiyaano ii aataru ivaa iikiaanoo. ");
INSERT INTO waj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Fai ngia ngii seenaiya mminnaivaa mmikiai nnaagiai kava ngii miaaraikiainnaata ngia ivaara yaata utikio rikioo fai hama Anutuuqo irisai yoketaivaa ivaara ngii minaravaivee. Mo gioonna kiaapu mminnamminnaa maisa suvuaiyaano ngiari seenaiya irisaqirisaima mmiaaraivaara iya yaata utida ngiari mmi ngiari mmiikiaavai. ");
INSERT INTO waj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ngii nnammutuaiyara mmuduuya rida mmoori yoketaivaa iyara iikiatee. Ngiingii mminnaiyauvaa ngiingii seenaiya mmiatee. Iya mmiaara iikiaivaki sa yaata utida ta irisai varaaravee kiatee. Fai ngia itaida irisai pinaa yoketaivaa varada Anutuuqo mmuakiaa mminnamminnaayauvai yaataraivaa raunna mmaapu tuanaaya variaaravai. Gioonna kiaapuuya hama innara irisai yoketaa kua tiraiyaraata kaayau kumimakama variaiyaraatama Anutuuqo ariinoo iyara yoketaivaara ngieetama ngiingii seenaiyara mmoori yoketaivaa iida inna raunna mmaapu tuanaaya variatee. ");
INSERT INTO waj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ngii Gioova mmuakiaayara boo tiineema ngieetama ngiingii seenaiyara boo kiatee. ");
INSERT INTO waj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Gioonna kiaapuuya mmoori aataruuyauvaa iikiai teeda sa iyauvaa teeda maisayauvaivee kiatee. Fai itaikio Anutuuqo hama sai ngii mmoori aataruuyauvaara maisayauvaivee tinaravai. Sa gioonna kiaapuuyaki kua pinaivaa yapaatee. Fai itaikio hama Anutuuqo sai ngiiiki kua pinaivaa yapaanaravaivee. Gioonna kiaapuuya mmoori maisaiyauvaa ngii iikiai sa iyauvaara yaata utiraida ngii ausa mmuduuyaiyauvaa iya mmiatee. Fai itaikio Anutuuqo hama sai ngii mmoori maisaiyauvaara yaata utirainno fai rugaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gioonna kiaapu vooya ngiingii mminnaiyauvaa mmiatee. Fai itaikio Anutuuqo irisai mminnaiyauvaa ngii mino fai pinaavai ngii yaakuuyauvaki kaayauma suvuainaravai. Fai tooriivaki hatapu uyuaaneema uyinono fuugiaino saiyauvo ngii yaakuuyauvakiaatama suvuainaravai. Ngia gioonna kiaapu vooya mminnaiyauvaa yaarummua kiada mmiaaneema fai Anutuuqo irisai itaama kioo ngii minaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yisuuva itaa kua kiaa kioo mmatayaa diaa mminnaiyauvunudiri mmataama kioo tunoo: Hama yopeema vaidi avu huruutaivoono vuai vaidi avu huruutaivaata vitoo aataruuvau nuainno varioo inna vitainaravai. Fai ivaitana kuaaree kiaivaata fai aiqeeravaitana soopaivaki tiida kuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hama vo ngiaammuau voovoono ari vitairaivaa yaataraivai. Fai vitairaivo inna vitainono ivo ari vitairaivaanikaraama varinaraivo inna aikioovai. ");
INSERT INTO waj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mmummuuvo i seenaivaa avuuvaki vaivaa aaniira a tee ivaara kiannannee? Iri pinaivo i avuuvaki vaikiainnaata hama a ivaa taannanoo. ");
INSERT INTO waj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iri pinaivo i avuuvaki vaivaa hama teerama kieenna dataama kiee i seenaivaa kiannanoo: Ni gata-o, kii na i avuuvakidiri mmummu kiisaivaa feenaanaravee, kiannannee? A huoobava unnakua nnaamuru tuanaakuavee. Tauraa iri pinaivo i avuuvau vaivaa utu rada kiee eennaadee ai avuuvaa tuqinnama tee nnaagiai i seenaivaa avuuvakidiri mmummuuvaa feenaanee. ");
INSERT INTO waj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Hama yatari yoketaivau iira maisaiyauvo vaivai. Yatari maisaivau hama iira yoketaiyauvo vaivai. ");
INSERT INTO waj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngia yatari iiraiyauvaa teeda arinaima yatari oyaivaara rikiaavai. Hama ngia ooviivaudiri nnaammuaya iiraivaa rasuku varaavai. Hama ngia ooviivaudiri vuaina iiraivaa rasuku varaavai. ");
INSERT INTO waj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Vaidi yoketaa voovoono ari aakiaivaki yoketaivo vaineema ari avaivakidiri safuuma kua yoketaivaa tiivai. Vaidi maisa voovoono ari aakiaivaki maisaivo vaineema ari avaivakidiri kua maisaivaa tiivai. Vaidiivo ari aakiaivaki suvuaineema ari avaivakidiri kooyaa tiivai. ");
INSERT INTO waj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aaniira ngia niiyara Udaanga-o kiaani mo na ngii giaa ngii miau kuaivaa hameeda rikiada iikiaannee? ");
INSERT INTO waj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gioonna kiaapu voovoono niisi ngioo ni kuaivaa rikioo iivoono fai aa na tinara kua aavaudiri fai iva ii aataruuvaa kooyaa ngii giaa ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ivoono vaidi nnau heekeeraivaa roosiivai. Ivo mmata yakeevau hanuu kioo yatari yaagueeqaivaa hara kioo nnau yoketaivaa yaagueeqama heekaivai. Yaagueeqama heeka kiaivoonora tioo nnooriivo hainno pinaavai tioo inna nnauvaa havarataanara ruoo ruoo rikiaikio hama yopeema nnauvo koroovai. Vaidiivo ari nnauvaa yaagueeqama heeka kiaivaara nnooriivo inna nnauvaa ruoo ruoo rikiaikio hama yopeema nnauvo koroovai. ");
INSERT INTO waj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gioonna kiaapu voovoono vaa ni kuaivaa rikioonnaata hama iivoono vuai vaidiivo nnau heekeeraivaa roosiivai. Ivo mmata muaraagaivau hama kuabai hareera kati nnauvaa heekaivai. Heeka kiaikio nnooriivo hainno pinaavai tuoo inna nnauvaa ruoo ruoo ravagiau yautu ruaikio makee tikio kurududu tikio eeyaara mmatayaa kurummutu kioo vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yisuuva ari kua mmuakiaayauvai gioonna kiaapuuya kiaa mmi taika kioo yoosinna Kapanaumara viravai. ");
INSERT INTO waj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Oro ivaki varuduu Roomaaya rapira ngiaammuauya kieeta voovoono ivaki varuduu ari mmoori vareera ngiaammuauvo kaayau nniitaroo putinara uuduu rapiraiya kieeta vaidiivo innara mmuduuya ruoo ");
INSERT INTO waj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yisuuva nnuuvaa rikioo Yutayaa vaidi yokovaa vooya titooduu numa inna ngiaammuauvaa tuqinnaiveera Yisuunna yapara kiaara viravai. ");
INSERT INTO waj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Vidada oro Yisuunna yaagueeqama yaparaida tunoo: Ivo Roomaa vaidi ari voopinnaavai variivaara sa yaata utirainna inna kuaivaa rikiaanee. ");
INSERT INTO waj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ivo tiiyara mmuduuya ruoo ti nuunaira nnauvaa tiini heekaivai. Ivaara yaata utuee inna kuaivaa rikiaanee, ");
INSERT INTO waj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","tuduu rikioo Yisuuva iya tasipama ngioo ngioo numa nnauvaa vainima dioo vauduu rapira ngiaammuauya kieetaivo ari seena vaidiiya titooduu inna kuaivaa varada Yisuunna kiaa mmiaara innasi viravai. Vida Yisuunna inna kuaivaa kiaa mmida tunoo: Ti kieetaivo tinoo: Udaanga-o, sa niiyara yaata utuanee. Na vaidi kiisavaivee. A vaidi nnoonnakuavee. Hama na yopeema tinai a ni nnauki nninaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ivaaraina hama na aisi kuauvaivee. Kati tino too ni mmoori vareera ngiaammuauvaa mmammaivo yoketaakiaivee. ");
INSERT INTO waj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na ari vo vaidi kieetaiya mmooriivaa vareera vaidivai. Na iya mmooriivaa varee rapira ngiaammuauyara diauvaivee. Ivaara na voovai kiaunoo: Kuanee, kiauko kuaivai. Na voovai ngianee kiauko ivo nniivai. Na sikaunnaadiri yookaama kiee viteera ngiaammuau voovai kiaunoo: Aa mmoori aavaa iikianee, kiauko iivaivee. Ivo itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","tuduu rikioo Yisuuva ivo tuu kuaivaara nnikiarainno hanigia gioonna kiaapu inna nnaagiai nnuuya tunoo: Na ngii giaa ngii miaunoo. Hama na tauko vaidi Isarairaa voovoono aa vaidi aavaa roosiima yaagueeqainno niiyara kutaavaivee tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","tuduu rikiada rapira ngiaammuauya kieetaivo ari seena vaidiiya Yisuunnasi titooya kava vara ranada nnida inna nnauvaki tooduu inna ngiaammuauvaa nniitaroovo vaa taikeeravai. ");
INSERT INTO waj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Suai nnaagiai Yisuuva yoosinna Nainara vioo ari ngiaammuauyaata kaayau gioonna kiaapuuyaatama inna tasipama viravai. ");
INSERT INTO waj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vidada Yisuuva yoosinnaivaa vagiaamunna keegiaivaki vainima kuanaree kiaa tooduu gioonna muaadavoono mmaapu mmuaavai mmata kioovo putuuvaa nnabaivaa kaayau gioonna kiaapuuya tasipama yoosinnaivakidiri varada nniravai. ");
INSERT INTO waj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nnuduu too Yisuuva gioonnaivaa too innara kaayauma boo tioo tunoo: Sa rataanee, ");
INSERT INTO waj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","kiaa kioo oro nnabaivaa yapa kioo yatari sagaivau utuduu teeda ivaa varada nnuuya dida vauduu Yisuuva vaidi putuuvaa tunoo: Ni vaidi-o, na i kiaunoo: Diitaanee, kiaunoo, ");
INSERT INTO waj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","tuduu rikioo diitoo hara kioo varioo iyaata kua tuduu Yisuuva inna vita kava ari kaanaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mmuduu rikiada mmuakiaa gioonna kiaapuuya aatuuda Anutuuqaara kua yoketaivaa tida tunoo: Aa vaidi aavo forofetaa ari vookaraivainno ti tasipama varinoo, tuduu vooyaano tunoo: Aanna Anutuuqo ari gioonna kiaapuuya ti tuqinnaanaraivoono tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","kiaa kiada Yisuuva uu mmayaayaivaa mmuakiaa yoosinna Yutayaivaki vau yoosinnaiyauvaki varuuyaata vainima vau yoosinnaiyauvaki varuuyaatama gioonna kiaapuuya kiaa mmuduu rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yuvuaanaa nnaagiai nuaira ngiaammuauyaano Yisuuva uu mmayaayaivaa Yuvuaanaa kiaa mmuduu rikioo ");
INSERT INTO waj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ari ngiaammuau taaravaitana tuduu innasi nnuduu ivaitana tunoo: Oro Yisuunna yaparaida kiatee: Vara a aanna vaidi nninaravee tuukuannee? Vara ta ari voovaara faannaida haitatuukiaarannee? ");
INSERT INTO waj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","kiaa mmiateeraivaara titooduu ivaitana numa Yisuunna tunoo: Yuvuaano nnoori apira vaidiivo ti titaikiai ta i yapara kiaara ngiaunnanoo. Ta kiaunnanoo: Vara a aanna vaidi nninaravee tuukuannee? Vara ta ari voovaara faannaida haitatuukiaarannee? kiaunnanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ii suai ivaki Yisuuva ari vookara ari vookarau nniitarooyaata uuda kaayau hooyaatama tuqinnoo mmagia maisaiya vaidi aakiaiyauvaki varuuyaatama titooduu vuduu kaayau gioonna kiaapu avu huruutauya tuduu avu teeravai. ");
INSERT INTO waj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yisuuva Yuvuaanaa ngiaammuau inna yaparauvaitana tunoo: Ni kuaivaa rikiada na iikiau mmooriivaa teeda ivaara vida Yuvuaanaa kiaa mmiatee. Gioonna kiaapu avu huruutaiya vaa avu taanoo. Yuku maisaiya vaa diitada nookiaanoo. Iya mmammaiyauvunu buunna haiya roosiikiaiya vaa yoketaama variaanoo. Yaata duunaiya vaa kuaivaa rikiaanoo. Putuaiya vaa diitada variaanoo. Mmanna haipuuya vaa ni mmayaaya yoketaivaa rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Gioonna kiaapu voovoono hama niiyara taara yaata utiivaara Anutuuqo innara yoketainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tuduu rikiada Yuvuaanaa ngiaammuauvaitana kava vara ranada innasi vida varuduu Yisuuva gioonna kiaapuuya innasi nnuuya Yuvuaanaara tunoo: Ngia koo mmuyai gaanga yoosinnaivau Yuvuaanaasi vida ngia aaniivai taara viravainnee? Yuunnaivo utuduu yanaa apuuvo kuapekuapoovaa taara viravainnee? Hamavee. ");
INSERT INTO waj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngia aaniivai taara viravainnee? Ngia vaidi voovoono yaapa ari vookarauvaa apuuvaa taara viravainnee? Hamavee. Mo gioonna kiaapuuya yaapa ari vookaraiyauvaa apuaavo kaayau hoonaiyauvo iyasi suvuaiya iya vaidi kieetaiya nnauyauvaki variaavai. Hama koo mmuyai gaanga yoosinnaivaki variaavai. ");
INSERT INTO waj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngia vaidi forofetaavai taara viravainnee? Na ngii giaa ngii miaunoo. Kutaa ngia vaidi forofetaa ari vookarauvo seena vaidi forofetaiya yaataroovaa ngia taara viravaivee. ");
INSERT INTO waj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Anutuuqaa kua fafaara roovo Yuvuaanaara vainno ataa kua tinoo: Anutuuqo tinoo: Na titauko nnii vaidiivo aa nninoo. Na i tauraivaannaadee titano vioo aataruuvaa aini teerama kiaanaravaivee, tiivaivee. Fafaaraivo itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ngii giaa ngii miee kiaunoo. Yuvuaano mmuakiaa gioonna kiaapu mmatayaa variaiya yaataraivai. Itaama vaino Anutuuqo gioonna kiaapuuyara diraivaki gioonna kiaapu voovoono aduoo variivoono Yuvuaanaa yaataraivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yisuuva itaa kua tuduu rikiada mmuakiaa gioonna kiaapuuyaatama sikau takiisa vareera vaidiiyaatama Anutuuqaa aataruuvaara yoketaavaivee tiravai. Vaa Yuvuaano nnooriivaa iya apu kioovaara iya itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vaidi Farisaiyaata kua mmaanna kiaa mmiraiyaatama Anutuuqo yoketaama variateera kiaa mmuu kuaivaara ooqoo tiravai. Yuvuaano hama nnooriivaa iya apuuvaara itaama ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yisuuva tunoo: Gioonna kiaapu aanna makee variaiya deeya roosiimaida variaannee? ");
INSERT INTO waj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iya nnaakara roosiikiaiya yoosinna vuutaivaki isareeda varida ngiariiyara ngiariiyara aayanna reeda kiaanoo: Ta tooriivaa varada fee fee kiaunnani hama ngia ivaara kuaru raavai. Ta kuaru nnauvaa haraunnani hama ngia ivaara rataavaivee, kiaa kiada itaa kua kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ngia iya itaama iikiaivaa roosiima iikiaanoo. Yuvuaano nnoori apira vaidiivo ngioo yeennaivaaraata nnoori vuainaivaaraatama ooqoo kiaa kiooduu rikiada ngia innara tunoo: Mmagia maisaivo inna aakiaivaki topai vaidivaivee, ");
INSERT INTO waj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","tuduu Na Vaidiivaa Mmaapuuvoono ngiee yeennaivaata nnooriivaatama nnaukai ngia kiaanoo: Aa vaidi aavaa taatee. Ivo ariiyara yaata utuoo tarikama kioo yeenna nnooriivaa nnai vaidivai. Ivo vuaina suuyaivaa nnoo kumimakai vaidivai. Ivo sikau takiisa vareera vaidi maisaiyaata mmaanna tuu kuaivaa hatokeera gioonna kiaapu maisaiyaatama iya seenavaivee, kiaanoo. ");
INSERT INTO waj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Iya itaa kua kiaaniaata ti mmooriivaudiri Anutuuqaa tinniivo kutaa vaivo kooyaa vaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tuduu Farisai vaidi voovoono Yisuunna yaparauduu inna tasipama yeenna nnaanara inna nnauvaki viravai. Oro inna tasipama varioo rooru mmaataivau yadaa yau hara kioo vainno yeenna nnoo variravai. ");
INSERT INTO waj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Varuduu mmuai yoosinnaivakinnaa sabi nuaira gioonna voovoono Yisuuva Farisai vaidiivaa nnauvaki varioo yeenna nnoo varuu mmayaayaivaa rikioo heenna suuya suuda yoketaa vuu sikau tooriivaa vareeravai. ");
INSERT INTO waj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Varoo oro nnau aakiaivaki Yisuunna mmookainningiaadiri inna yukuuvaitana vainima dioo vainno ratoo varuduu inna vunnunnuuvo Yisuunna yukuuvaitanau tioo vioo puutauduu ari kieeta yausiivaadiri inna yukuuvaitanaudiri ruga kioo inna yukuuvaitana mmootoo heenna suuya suuda yoketaa vuuvaa inna yukuuvaitanau tuseeravai. ");
INSERT INTO waj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tusooduu Farisai vaidiivo Yisuuva inna tasipama yeenna nnaiveera tuuvoono gioonnaivaa too arinaidiri yaata utuoo tunoo: Aa vaidi aavo forofetaa tuanaavai iitiri. Aa gioonna inna yukuuvaitanau utii aavo maisama varioo mminnamminnaa maisaiyauvaa varaivaa arinaima taitirivee, ");
INSERT INTO waj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","tuduu rikioo Yisuuva inna tunoo: Simoono, na vo kuavai i kiaa i mminai rikiaanee, tuduu rikioo ivo inna sai tunoo: Vitaira-o, inna aikioovai. Ni giaa ni mianee, ");
INSERT INTO waj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","tuduu rikioo Yisuuva inna sai tunoo: Vaidi sikau mmiraivoono sikauyauvaa taara vaidivaitana mmiivai. Voovai kaayau sikauyauvaa (100) mmioo voovai kiisa sikauyauvaa (10) mmiivai. ");
INSERT INTO waj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nnaagiai hama sikaunnaataikiai taaravaitana hama sai inna mmiaavo rikioo sikau mmira vaidiivo tinoo: Inna aikioovai. Vakiaa varaatee, tiivai. Mo dee vaidivoono innara pinaama mmuduuya ruainnee? Dee vaidivoono innara kiisama mmuduuya ruainnee? ");
INSERT INTO waj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","tuduu rikioo Simoono inna sai tunoo: Mo na yaata utuauko kaayau sikauyauvaa (100) vakiaa varaivoono innara pinaama mmuduuya ruaivaivee, tuduu rikioo Yisuuva inna sai tunoo: Yo, a kutaa kuavai kiannanoo, ");
INSERT INTO waj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","kiaa kioo hanigioo gioonnaivaa too Simoonaa tunoo: Vaa aa gioonna aavaa a taannanoo. Na i nnauvaki ngiaukai hama a nnooriivaadiri ni yukuuvaitanaudiri finiannavai. Aa gioonna aavo ari vunnunnuuvaadiri ni yukuuvaitana fini kioo ari kieeta yausiivaadiri ni yukuuvaitanaudiri rugaivai. ");
INSERT INTO waj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A hama niiyara yoketainna ni mmootaannavai. Na ngiau saivaata aa gioonna aavo mmannammanna ni yukuuvaitana mmootoo nnaasu varivai. ");
INSERT INTO waj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A hama nnammariivaa varee ni kieetaivaki apuannavai. Aa gioonna aavo ni yukuuvaitanau heenna suuya suuda yoketaa kuaivaa tusaivaivee. ");
INSERT INTO waj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ivaaraina na i kiaa i mmiaunoo. Aa gioonna aavaa mminnamminnaa maisa kaayau suvuaiyauvaa vaa na ruga taika kiauvai. Ivo numa niiyara pinaama mmuduuya ruaivaara na inna mminnamminnaa maisaiyauvaa ruga kiauvo kooyaa vainoo. Gioonna kiaapu voovoono kiisa mminnamminnaa maisaiyauvo vaiyauvaa na ruga kiauko kiisama niiyara mmuduuya ruaivaivee, ");
INSERT INTO waj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","kiaa kioo Yisuuva gioonnaivaa tunoo: Vaa na kiauko i mminnamminnaa maisaiyauvo taikainoo, ");
INSERT INTO waj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","tuduu rikiada gioonna kiaapuuya inna tasipama yeenna nnooya ngiari yaata tinniyaa vau kuaivaa yaata utida tunoo: Aanna dee vaidivoono mminnamminnaa maisaiyauvaa rugaivainnee? ");
INSERT INTO waj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","tuduu rikioo Yisuuva gioonnaivaa tunoo: A niiyara kutaavaivee kiannaivaaraina na i mminnamminnaa maisaiyauvaa ruga kiee i vita yoketaivau yapaunoo. Ausa nuufa tasipama kuanee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nnaagiai suai vooyauvai taika kiooduu Yisuuva mmuakiaa yoosinna kiisaiyauvakiaata pinaiyauvakiaatama nuainno varioo Anutuuqo gioonna kiaapuuyara dira mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiaa roo nuairavai. Nuauduu ari ngiaammuau yaakuuvaitana yukukidiri taaramaatama ");
INSERT INTO waj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","gioonna vooya mmagia maisaiyauvo iya aakiaiyauvaki varuduu titooyaatama gioonna vooya nniitarooduu tuqinnooyaatama inna nnaagiai nuairavai. Vo gioonna voovai nnutuuvo Mariaava yoosinna Makataraa ivakidiri pikioo numa Yisuunna tooduu inna aakiaivakidiri mmagia maisa yaaku saivai sainaidiri taarama titooduu vuduu varuu gioonnaivo inna nnaagiai nuairavai. ");
INSERT INTO waj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Vo gioonna voovai inna tasipama nuauvaa nnutuuvo Yoqaanovee. Ivo kieeta vaidi Herootaa nnauvaara haitatuura vaidiivaa nnutuuvo Kusaanna nnaatavai. Vo gioonna voovai nnutuuvo Susanaavaata kaayau seena gioonna vooyaatama mmoori vara rada nuaida varida ngiari mminnamminnaiyauvaadiri Yisuunnaata ari ngiaammuauyaatama tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kaayau gioonna kiaapuuya vo yoosinna vo yoosinnadiri Yisuunnasi nnida suvuau kiooduu rikioo Yisuuva mmatayaa diaa mminnaivaudiri mmataama kioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Vaidi voovoono yeenna uruuyauvaa varoo oro ari mmooriivaki rututuooma roo nuaikio vooyauvai aataruuvo vaivau tuoo kuaikiai gioonna kiaapuuya ivaugiataa yuku raa rada nookiaavo rikioo ngiaammaiyauvo tuma porooma nnaavai. ");
INSERT INTO waj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Uru vooyauvai tuoo sikau tasipama vai mmataivau kuaiyauvo uruoo hama mmataivo nnammari raivaara akiairaama aasannaivai. ");
INSERT INTO waj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Uru vooyauvai tuoo ooviiyauvaki kuaikio ooviiyauvo iyauvaa tasipama uruoo raputu kiaivai. ");
INSERT INTO waj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Uru vooyauvai mmata yoketaivau tuoo kuaiyauvo yoketaama urikio too kaayau iiraiyauvo yaaku sai vaidivai yuku yaaku taika kioo vaivaivee. Yisuuva itaa kua kiaa kioo kava tunoo: Gioonna kiaapu voovoono arinaima kua rikiaivoono ii kua ivaa arinaima rikiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tuduu rikiada Yisuunna ngiaammuauya ivo uruuyauvunudiri mmataama kioo tuu kua oyaivaara inna yaparauduu rikioo ");
INSERT INTO waj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yisuuva iya sai tunoo: Anutuuqo gioonna kiaapuuyara dira kua oyaivo haumaki vaivaa fai na ngii giaa ngii minai ngiengieenoo arinaima rikiaaravai. Mo gioonna kiaapu vooya teedada mmanna avuuyauvaadiri teeda hama tuqinnama taaravai. Iya rikiadada mmanna yaataiyauvaadiri rikiada hama arinaima rikiaaravai. Hama iya tuqinnama teeda arinaima rikiaaraivaara na mmatayaa diaa mminnaa vooyauvunudiri mmataama kiee iya kiaa mmiauvai. ");
INSERT INTO waj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aanna mmatayaa diaa mminnaivaudiri na mmataama kiee kiauvaa oyaivaa rikiaatee. Uruuyauvo Anutuuqaa kuavai. ");
INSERT INTO waj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Uruuyauvo aataruuvau tuoo kuaiyauvo inna gioonna kiaapuuya Anutuuqaa kuaivaa rikieeraiya roosiivai. Iya rikiada kutaavaivee tikio Anutuuqo aataru yoketaivau iya yapeevoora Anutuuqaa kuaivo iya yaatayaa vaivaa Sataango numa varoo kuaivai. ");
INSERT INTO waj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Uruuyauvo sikau tasipama vai mmataivau tuoo kuaiyauvo inna gioonna kiaapu vooya roosiivai. Iya Anutuuqaa kuaivaa rikiada kaayau siriga tasipama varaavai. Uruuyauvo uruoo hama tuukaiyauvo kuaiyauvaa roosiima iya kiisa suai Anutuuqaa kuaivaara kutaavaivee kiaavo mminnamminnaa maisaiyauvo iya iinno taikiai iya muaraagaida Anutuuqaa aataruuvaa makee tikiai pikiaavai. ");
INSERT INTO waj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Uruuyauvo ooviivaki tuoo kuaiyauvo inna gioonna kiaapu vooya Anutuuqaa kuaivaa rikieeraiya roosiivai. Iya rikiada varidada nnaagiai ngiari mmooriiyauvaara pinaama yaata utida sikau vareeraivaara yaata utida mmamma iira aataruuvaara yaata utuaavo iyauvoono iya suvuainno Anutuuqaa kuaivaa rugaikio rikioo iiraiyauvo gaasi roosiima vaivai. ");
INSERT INTO waj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Uruuyauvo mmata yoketaivau tuoo kuaiyauvo inna gioonna kiaapu vooya roosiivai. Iya Anutuuqaa kuaivaa rikiada varada puaisakama utida safuuma yoketaama varida iya pirisaikiainnaata Anutuuqaa mmooriivaa mmannammanna iikiaavovo iira yoketaiyauvo iyaki vaivaivee. ");
INSERT INTO waj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Hama gioonna kiaapu voovoono toobaivaa subi kioo varoo oro yapa kioo kuu yavaivaa varoo toobaivau tuarapuatikama rummua apu kiaikio vaivai. Hama ivaa varoo oro terenaivaa mmemmaivaki yapa kiaivai. Gioonna kiaapuuya mmaanaidiri ngiaiya mmeekiaivaa taateeraivaara ivo toobaivaa varoo kiikoo koovau hirivai. ");
INSERT INTO waj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mmuakiaa mminnaiyauvo hataumaki vaiyauvo fai kooyaa vainaravai. Mmuakiaa mminnaiyauvaa rummua apu kiaiyauvo fai rabara kino kooyaa vainai mmuakiaaya taaravai. ");
INSERT INTO waj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ngia rikiaa kuaivaara arinaima yaata utida rikiaatee. Gioonna kiaapu voovoono ni kuaivaa arinaima rikiaivoono fai Anutuuqo ari vo kua vo kuaivaa inna kiaa mmino rikiaanaravai. Gioonna kiaapu voovoono kiisa kuaivo inna yaatana vaivoono ariiyara yaata utuoo tinara: Vaa kua vooyauvai niiki vainoo, tino rikioo fai akiairaino taunnino hama innaki kuaiyauvootainaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tuduu rikiada Yisuunna kaanoota inna kataunnaiyaatama innasi ngiaaree kiaa numa tooduu kaayau gioonna kiaapuuya inna suvuau kiooduu hama innasi nniravai. ");
INSERT INTO waj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hama innasi nnuuvaara gioonna kiaapuuyakidiri voovoono Yisuunna tunoo: Aa mmiaa i kaanoota i kataunnaiyaatama mmaanai dida vaida aita kua kiaara iikiaanoo, ");
INSERT INTO waj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","tuduu rikioo Yisuuva iya sai tunoo: Gioonna kiaapuuya Anutuuqaa kuaivaa rikiada ivaa iikiaiya iya inna ni noova ni gata vayaiyavee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Vo suai Yisuuvaata ari ngiaammuauyaatama kanuuvaki karada varuduu Yisuuva iya tunoo: Nnikiai ta nnoori haruungaivaa sainai kuaaravee, tuduu rikiada kanuuvaa feena rada ");
INSERT INTO waj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","vida varuduu Yisuuva vuru ivaki vairavai. Vuru vainno varuduu yuunna yaamurukaivo nnooriivaudiri nnuduu nnooriivo kaayau korokoroonno ketekaateenno kanuu aakiaivaki ngioo vioo iya ruputu taikaanara uuduu rikiada ");
INSERT INTO waj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ari ngiaammuauya numa inna yuruuda tunoo: Nnoonna-o, nnooriivo kiisa suai ti raputinara iinoo, tuduu rikioo Yisuuva diitoo yaagueeqama yuunnaivaata nnooriivaatama ooqoo tuduu yuunnaivo pikiooduu nnooriivo hama korokorooravai. ");
INSERT INTO waj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hama korokorooduu Yisuuva ari ngiaammuauya tunoo: Ngia aaniira hama niiyara kutaavaivee kiaannee? tuduu rikiada nnikiaraida aatuuda ngiari yapara ngiari yaparaida tunoo: Aanna dee vaidivainnee? Ivo yuunnaivaata nnooriivaatama tikiai rikiada akiairaama taikaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yisuuva ari ngiaammuauyaatama Karirayaa pikiada nnoori haruungaivau vida mmata sainai vauvaa nnutuuvo Keraseenga vuduu kanuuvo oro siriivau dioo vauduu ");
INSERT INTO waj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yisuuva reemi roo saivaata mmagia maisaiyauvo vaidiivaa aakiaivaki topau vaidiivo ii yoosinna ivaki varuuvoono Yisuunna saidi tiiravai. Ivo hokoba suai taguaada hara kioo varioo hama ari nnauvaki varirainno pikioo vaidi putuuya hau oonauyauvaki variravai. ");
INSERT INTO waj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ivoono Yisuunna too pinaama vuu vuu kai kai tioo ngioo varoo inna yuku oyaivaki vainno puaisakama aayanna roo tunoo: Yisuu-o, Anutuuqo mmuakiaa mminnamminnaavai yaataraivaa Mmaapukuavee. A aaniivai ni iinarainna ngiannannee? Na yaagueeqama i kiaunoo: Sa ni ruputuanee, kiaunoo. ");
INSERT INTO waj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Vaidiivaa aakiaivaki mmagia maisaiyauvo topauvaara Yisuuva iya tiida kuateera tuuvaara vaidiivo itaa kua tiravai. Vaa kaayauneetu mmagia maisaiyauvo vaidiivaa topauduu gioonna kiaapuuya inna vitada yeena yaagueeqaivaadiri inna yuku yaakuuvaitanau ranaa rau kiada nnauvaki yapa kiada haitatuukiaavoonnaata ivo yeena yaagueeqaivaa rannakekaama kiooduu mmagia maisaiyauvo inna topauyaano vitada koo mmuyai gaanga voovau viravai. ");
INSERT INTO waj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ii vaidi ivaa Yisuuva yaparainno tunoo: Ai nnutuuvaa kianee, tuduu rikioo mmagia maisaiyauvo kaayau inna aakiaivaki varuuyauvaara ivo tunoo: Ni nnutuuvo Kaayauvavee, ");
INSERT INTO waj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","tuduu rikiada mmagia maisaiyauvo vaidiivaa aakiaivaki varuuya Yisuuva sa ti titanai ta titi irisai soopa hokoba mmata pinnaasayaa kuaivaki kuateeraivaara yaagueeqama inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yaparauduu teeda kaayau puaraiyauvo taapiivau yeenna nneeda variravai. Yeenna nneeda varuduu mmagia maisaiyauvo puaraiya aakiaiyauvaki kuaaraivaara yaagueeqama Yisuunna yaparauduu rikioo ee-oo tuduu ");
INSERT INTO waj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","vaidiivaa aakiaivakidiri pikiada vida puaraiya aakiaiyauvaki vuduu teeda mmuakiaa puaraiya rereevau mmeepi seenada nnoori haruungaivaki vida putu taika kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Putu taika kiooduu vaidi puaraiyara haitatuuraiya ivaa teeda seenada vida mmayaayaivaa gioonna kiaapu yoosinnaivaki varuuya kiaa mmida annaanna nnauyauvaki varuuyaatama kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kiaa mmuduu rikiada gioonna kiaapuuya yoosinnaivaki pikiada Yisuuva uu mmooriivaa taara nniravai. Iya Yisuunnasi nnida tooduu vaidiivaa vaa mmagia maisaiya inna aakiaivakidiri pikioovo ari uyira rairaiyauvaa uyu rau kioo Yisuunna yuku oyaivaki varuduu ari yaataivo vaa yoketauduu gioonna kiaapuuya innara aatuuravai. ");
INSERT INTO waj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aatuuduu gioonna kiaapu Yisuuva vaidiivaa tuqinnoovaa tooyaano seena gioonna kiaapu vooya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kiaa mmuduu mmuakiaa gioonna kiaapu mmata Keraseenga vainima vau mmataivau varuuya pinaama iya aatuuvaara Yisuunna tunoo: Ti pikiee kuanee, tuduu rikioo Yisuuva iya pikioo kanuuvaki karoo kava vara ranoo kuanara iiravai. ");
INSERT INTO waj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kuanara uuduu too vaidi mmagia maisaiyauvo inna aakiaivakidiri pikioovoono Yisuunna yaagueeqama yaparainno tunoo: Kii neeta kuanaravee, tuduu rikioo Yisuuva inna ooqoo tioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ai nnauki kava vara ranee viee Anutuuqo i iima kiai kuaivaa gioonna kiaapuuya kiaa mmianee, tuduu rikioo ivo vioo yoosinna aakiaivaki nuainno varioo gioonna kiaapuuya Yisuuva inna iima kioo kuaivaa kiaa mmiaa roo nuairavai. ");
INSERT INTO waj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yisuuva nnoori haruunga sainaidiri kava vara ranoo nnuduu teeda kaayau gioonna kiaapuuya innara faannauya inna tooduu kaayauma innara iya yoketairavai. ");
INSERT INTO waj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Yoketauduu vaidi voovoono ivakinnaaya nuunaira nnauvaa kieeta voovai nnutuuvo Yairiiva Yisuunna saidi ngioo inna yuku oyaivaki ngioo varoo vainno yaagueeqama ni nnauki ngianeera inna tiravai. Ari raunna mmuaavai inna nuanuuvo yaakuuvaitana yukukidiri taaravaitana varuu kiaatannaivo putinara uuvaara inna yaparairavai. Yaparauduu rikioo Yisuuva inna tasipama vioo varuduu gioonna kiaapu kaayauya inna suvuau kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Suvuau kiooduu gioonna voovoono kabaa vira aataruuvo tupatupaa innaki vaududuu nuanu yaakuuvaitana yukukidiri taara nuanu taika kioo varuu gioonnaivo varioo tutaaqaiyasi vuduu hama iya inna tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hama inna tuqinnoovoono numa Yisuunna mmookainnidiri dioo vainno inna buruqa araivau utuduu rikioo inna kabaa vira aataruuvo makee tuduu taikeeravai. ");
INSERT INTO waj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Taikooduu rikioo Yisuuva yaparainno tunoo: Gioono ni utivainnee? tuduu rikiada mmuakiaa gioonna kiaapuuya hameetavee tuduu Petorooso inna sai tunoo: Nnoonna-o, kaayau gioonna kiaapuuya i ututuuma kiada i mmammaivau rummua sisaama rada nookiaavaivee, ");
INSERT INTO waj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","tuduu rikioo Yisuuva Petoroosaa kuaivaa sai tunoo: Vaa gioonna kiaapu voovoono ni utikio yaagueeqa ari vookaraivo niikidiri kuaivaa vaa na rikiauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","tuduu rikioo gioonnaivo Yisuuva inna toovaara rikioo biribiriinno inna yuku oyaivaki ngioo varoo vainno ari Yisuunnayaa utuuvaara gioonna kiaapuuya avuuvau Yisuunna kiaa kookieeravai. Inna kabaa vira aataruuvo taikaanaraivaara ivo numa inna utuduu makee tuduu taikoovaara Yisuunna kiaa kookieeravai. ");
INSERT INTO waj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kiaa kookieema kiooduu rikioo Yisuuva inna tunoo: Ni nunnakuavee. A yaagueeqama niiyara kiannanoo: Aikiooma ni tuqinnaanaravaivee, kiannaivaarainna a yoketaama hara kiee variannanoo. Diitee ausa nuufa tasipama kuanee. ");
INSERT INTO waj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yisuuva itaa kua tuu saivaata vaidi voovoono kieeta vaidi Yairiinna nnauvakidiri ngioo inna kiaa mmioo tunoo: Vaa i raunnaivo putinoo. Sa vitaira vaidiivaa vitee kuanee, ");
INSERT INTO waj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","tuduu rikioo Yisuuva ivo tuu kuaivaa rikioo Yairiinna tunoo: Sa ausa mmuaararee pinaama yaata utuanee. Niiyara nnaasu yaata utuee kutaavaivee kianee. Tino fai i raunnaivo yoketaama varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","kiaa kioo vioo vioo oro nnauvaki kuanaree kiaa iinno varioo mmuakiaa gioonna kiaapuuya nnauvaki vivoo kiaa Yisuuva iya ooqoo kiaa kioo Petorooso Yakoopo Yuvuaanainnaata vitoo kiaatannaivaa kaano koovaitanaatama vitoo nnauvaki viravai. ");
INSERT INTO waj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vitoo vioo tooduu kaayau gioonna kiaapuuya ivaki varida kiaatannaivaara kaayauma ratada varuduu Yisuuva oro iya tunoo: Sa rataatee. Hama kiaatannaivo putivai. Kati vuru vainoo, ");
INSERT INTO waj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","tuduu rikiada iya vaa kiaatannaivo putuuvaa teeda Yisuunnara pinaama rairavai. ");
INSERT INTO waj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Raida varuduu Yisuuva oro kiaatannaivaa yaakuuvau utuoo inna tunoo: Kuabuaa-o, diitaanee, ");
INSERT INTO waj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tuduu rikioo kava inna mmannasaivo nnabaivaki nnuduu akiairaama diiteeravai. Diitooduu too Yisuuva iya tunoo: Yeennaivaa inna mmiatee, ");
INSERT INTO waj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","tuduu rikiada kaano koovaitana kaayauma nnikiarauduu Yisuuva yaagueeqama iya tunoo: Sa na iikiau kua aavaa gioonna kiaapuuya kiaa mmiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yisuuva ari ngiaammuau yaakuuvaitana yukukidiri taarama innasi ngiateera tuduu rikiada innasi nnuduu gioonna kiaapuuyakidiri mmagia maisaiya titakiai kuateera yaagueeqaivaata nniitareeraiya tuqinnaateera yaagueeqaivaatama iya mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Iya mmioo Anutuuqo gioonna kiaapuuyara dira mmayaayaivaa gioonna kiaapuuya kiaa mmida nniitareeraiya tuqinnaateeraivaara iya tioo ");
INSERT INTO waj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","tunoo: Sa aataruuvaura mminnaiyauvaa varada kuatee. Kati kuatee. Sa yau kurida nuairaivaata varada sa utuaiyauvaa varada sa yeennaiyauvaa varada sa sikauyauvaa varada sa ngii yaapaiyauvaa taara tida varada kuatee. Mmuaa tida mmuaa tida nnaasu varada kuatee. ");
INSERT INTO waj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ngia yoosinnaiyauvaki vida teekiai tauraa nnauvaa ngii miaiyauvaki nnaasu varida yapooma yoosinnaiyauvaa pikiada vira suaivaki ii nnau iyauvaatama pikiada kuatee. ");
INSERT INTO waj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Fai ngia vo yoosinna vo yoosinnaiyauvaki nuaida varida teekiai iya hama ngii tuqinnakiai teeda ngiingii yukuuyauvunudiri kufukuufaiyauvaa rututuooma kiada ii yoosinna ivaa pikiada kuatee. Anutuuqo irisai maisaivaa iya mminaraivaara iya rikiaateeraivaara kufukuufaiyauvaa ngii yukuuyauvunudiri rututuooma kiaatee, ");
INSERT INTO waj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","tuduu rikiada Yisuunna ngiaammuauya mmuakiaa yoosinnaiyauvaki nuaida varida mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiaa rada nuaida nniitarooya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yutayaiya kieetaivo Herooto Yisuuva uu mmayaayaivaa rikioo kaayauma kumimakairavai. Gioonna kiaapu vooyaano tunoo: Yuvuaano nnoori apira vaidiivo putuoo kava diitaivaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","tuduu vooyaano tunoo: Nnaaruaa vaidi forofetaa voovoono kava diitaivaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","tuuvaara Herooto kaayauma kumimakairavai. Ivo tunoo: Vaa na kiaaduu ni ngiaammuauya Yuvuaanaa nnuunaivaa rutakeeravai. Aa vaidi aavaa na mmayaayaivaa rikiauvo inna dee vaidivainnee? kiaa kioo Yisuunna taanara iiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yisuunna ngiaammuau kua varada nuauya kava vara ranada nnida ngiari uu mmayaayaivaa Yisuunna kiaa mmiravai. Kiaa mmuduu rikioo Yisuuva iyaatama sunoo ngiarivana nnaasu yoosinna Betesaitaa viravai. ");
INSERT INTO waj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Vuduu mmuakiaa gioonna kiaapuuya iya vuuvaa teeda rikiada iya vata rada viravai. Vuduu too Yisuuva iyara yoketainno Anutuuqo gioonna kiaapuuyara dira mmayaayaivaa iya kiaa mmioo nniitarooya tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tuqinnooduu suaivo haatapaanara uuduu Yisuunna ngiaammuau yaakuuvaitana yukukidiri taaravaitana innasi nnida tunoo: Aa yoosinna aavo koo mmuyai mmanna gaanga yoosinnavai vaivaara gioonna kiaapuuya titanai kuatee. Iya aavakinnaaya yoosinnaiyauvaki vida aa vainima vai nnau aayauvakiaatama vida yeennaiyauvaa vara kiada nneeda iyauvaki vuru vakiateeraivaara titanai kuatee, ");
INSERT INTO waj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","tuduu rikioo Yisuuva iya tunoo: Mo ngieenoo yeennaiyauvaa iya mmiatee, tuduu rikiada iya inna sai tunoo: Bereeta yaaku saivai tavau taarama nnaasu tiisi vainoo. Fai a ti titanai ta oro aa gioonna kiaapu mmuakiaa aayani yeennaiyauvaa yookaama kiada varaarannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iya vaidiiya nnaasu yaaruduu kaayau (5000) ivau variravai. Yisuuva ari ngiaammuauya tunoo: Ngia gioonna kiaapuuya tikiai vooya (50) voovau varikiai vooya (50) voovau varikiai vooya (50) voovau variatee. Itaqitaama variatee, ");
INSERT INTO waj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","tuduu rikiada iya itaa kua tuduu gioonna kiaapuuya rikiada variravai. ");
INSERT INTO waj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Varuduu Yisuuva bereeta yaaku saivai tavau taaravaitanaatama tu kioo vainno avuuvaa ngiau aapu reeri too vainno iyauvaara Anutuuqaata kua yoketaivaa tioo iyauvaa kusiinnonno kioo ari ngiaammuauya mmuduu varada gioonna kiaapuuya mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mmuduu mmuakiaaya nnooduduu iya ausaiyauvo rasituduu Yisuunna ngiaammuauya iya yeenna nneeda kioo arai yatiiyauvaa rupi nuunama utua yaakuuvaitana yukukidiri taarama rummua yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Vo suai Yisuuva arivana yaaku varoo varuduu ari ngiaammuauya innasi nnuduu rikioo Yisuuva iya yaparainno tunoo: Gioonna kiaapuuya niiyara dee vaidivainnee kiaa kiada dataa kuaida kiaannee? ");
INSERT INTO waj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","tuduu rikiada iya inna sai tunoo: Vooya kiaanoo: Yuvuaano nnoori apira vaidivaivee, kiaani vooya kiaanoo: Irayaavavee, kiaani vooyaano kiaanoo: Nnaaruaa forofetaa voovoono putuoo kava diitaivaivee, kiaavaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","tuduu rikioo Yisuuva iya yaparainno tunoo: Mo ngieeta niiyara dataa kuaida kiaannee? tuduu rikioo Petorooso inna sai tunoo: A vaidi Anutuuqo i mmataama kiookuavee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tuduu rikioo Yisuuva yaagueeqama iya tunoo: Sa aa kua aavaa gioonna kiaapuuya kiaa mmiatee, ");
INSERT INTO waj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","kiaa kioo tunoo: Na Vaidiivaa Mmaapuuvo fai kaayau mmamma nniitareeraivaa varaanaravai. Fai vaidi yokovaiyaatama vaidi Anutuuqaara kati puara hudeera kieetaiyaatama kua mmaanna kiaa mmira vaidiiyaatama niiyara ooqoo tikiai fai vaidiiya ni ruputikiai na putino taara suaivaitana taikano voomaivaki Anutuuqo ni tinai na keenaa diitaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kiaa kioo vo kuavai mmuakiaaya kiaa mmioo tunoo: Fai gioonna kiaapu voovoono ni nnaagiai nninaree tioo fai ari yaata utira aataruuvaara ooqoo tioo gioonna kiaapuuya niiyara inna ruputikio na putuauneema ivo putinaraivaara mmuakiaa suai ee-oo tioo ni nnaagiai ngiaivee. ");
INSERT INTO waj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gioonna kiaapu voovoono ari mmatayaa variraivaara yaagueeqama yaata utuoonnonno fai yapooma hama ivo tupatupaa varinaraivootainaravai. Gioonna kiaapu voovoono hama ari mmatayaa variraivaara yaata utirainno niiyara putinaraivaara ee-oo tiivo fai tupatupaa variraivaa varaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Fai gioonna kiaapu voovoono ariiyara nnaasu yaata utuoo mmuakiaa mmatayaa diaa mminnamminnaiyauvaa varoonnonno hama tupatupaa variraivaara yaata utirainno putuoo fai dee irisai yoketaivaa Anutuuqaasidiri varaanarannee? Fai hama varaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Fai yapooma Na Vaidiivaa Mmaapuuvoono ni mmeekia ari vookaraivootama ni Napoonna mmeekia ari vookaraivootama aangeraa yoketaa tuanaiya mmeekia ari vookaraiyauvootama na kava mmatayaa tiinaravai. Gioonna kiaapu voovoono niiyaraata ni kuaivaaraatama inna mmamma maisainai na mmatayaa kava vara ranee tiee sai innara mmamma maisainaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na kua kutaavai ngii giaa ngii miaunoo. Fai gioonna kiaapu aavau dida vakiaa vooya hama putirama kiada varida Anutuuqo gioonna kiaapuuyara diraivaa taaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yisuuva ii kua iyauvaa kiaa taika kiooduu yaaku saivai karasaidiri taaravooma suaivo taika kiooduu ivo Petorooso Yuvuaano Yakoopainna vitoo taapiivau yaaku varaanara viravai. ");
INSERT INTO waj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Oro yaaku varoo varuduu inna oori nnikiivo hanigioo ari vookarairavai vauduu inna uyira rairaiyauvo poosainno pinaama mmannaammannairavai. ");
INSERT INTO waj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mmannaammannauduu makee tuduu taara vaidivaitana Musiiya Irayaaya innaata kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ngiau aapu vau ari vookarau mmeekiaivo ivaitanaasi vauduu Anutuuqo nnaaru ari yaatayaa vau kuaivaa iinaraivaara Yisuuva Yerusareema vioo putinaraivaara ivaitana Yisuunnaata kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kua tida varuduu Petoroosaa tasipama varuu vaidiivaitana vurura rusirusiida varida tooduu Yisuuva hanigioo ari vookarairavai vauduu Petoroosaa tasipoovaitana inna teeda vaidi taaravaitanootama inna tasipama duuvaa teeravai. ");
INSERT INTO waj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tooduu vaidiivaitana Yisuunna pikiada kuaara iida varuduu Petorooso Yisuunna tunoo: Nnoonna-o, ta aavaki variaunnano ti yoketainoo. Kii ta unnakua nnau taaravooma heekaaravee. Aini voovai heekada Musiinnani voovai heekada Irayaannani voovai heekaaravaivee. Iva kumimakainno itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ivo tuu saivaata namaivo tuoo iya rummua apu kioo vauduu kaayauma aatuuravai. ");
INSERT INTO waj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aatuuda rikiooduu Anutuuqaa kuaivo nama aakiaidaadiri tuoo tunoo: Inna ni Maapu tuanaivovee. Na inna mmataama kiee yapauvai. Inna kuaivaa rikiaatee. ");
INSERT INTO waj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Iva kiaa taika kiooduu iya tooduu Yisuuva arivana nnaasu dioo vairavai. Ii suai ivaki Yisuunna ngiaammuau taaravoomaido ngiari too kuaivaa hama kiaa kookieeraida pikiada kua seemuaa variravai. ");
INSERT INTO waj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Vauya patauduu Yisuuva ari ngiaammuau taaravoomaidootama taapiivaudiri pikiada tiida tooduu gioonna kiaapu kaayauya iya sunada nniravai. ");
INSERT INTO waj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nnuduu gioonna kiaapuuya nuuna aakiaivakidiri vaidi voovoono aayanna roo tunoo: Vitaira-o, na yaagueeqama i yaparakiaunoo. Numa ni maapuuvaa taanee. Ni maapuuvo mmuaa tuanaavaivee. ");
INSERT INTO waj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mmagia maisaivo inna ruputikio ivo akiairaama kai tioo putuoo mmatayaa vaikio taara kuaanuuvo inna avaivakidiri tiikio mmagia maisaivo hama inna pikioo virainno makemakee inna ruputikiokio maisainoo. ");
INSERT INTO waj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mmagia maisaivaa titaa kikio kuaiveera na yaagueeqama i ngiaammuauya yaparakiaukai hama iya yopeema titaavaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","tuduu rikioo Yisuuva inna kuaivaa sai tunoo: Ngia makee variaa gioonna kiaapuuya hama ngia niiyara kutaavaivee tiraidaida koonnama variaanoo. Na hokoba suai ngii tasipama hara kiee variaukai hama ngia niiyara kutaavaivee kiaavai. Fai na naana suai ngii tasipama hara kiee varinanai ngia niiyara kutaavaivee kiaarannee? Na ngii tasipama variee ngia ni kuaivaa rikiaaraivaara na faannaina variaunoo, kiaa kioo vaidiivaa tunoo: Ai mmaapuuvaa vitee aapi niisi ngianee, ");
INSERT INTO waj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","tuduu rikioo koova ari mmaapuuvaa vitoo ngioo varuduu mmagia maisaivo makee tuduu inna ruputuduu mmatayaa vioo varoo vainno yuku yaakuuvaa hannatotauduu rikioo Yisuuva yaagueeqama mmagia maisaivaa ooqoo kiaa kioo ngiaammuauvaa tuqinnama kioo kava ari koonna mmuduu teeda ");
INSERT INTO waj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","mmuakiaa gioonna kiaapuuya Anutuuqaa yaagueeqa ari vookarauvaara avai kurutooma kiada yaaku vuatavuatairavai. (Matai 17:22-23; Marakaa 9:30-32) Gioonna kiaapuuya Yisuuva uu mmoori mmuakiaayauvaara yaaku vuatavuataida varuduu Yisuuva ari ngiaammuauya tunoo: ");
INSERT INTO waj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Aa na ngii giaa ngii minara kua aavaa sa taunnuatee. Vaidiiya na Vaidiivaa Mmaapuuvaa vaidi vooya miaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","tuduu rikiada hama iva tuu kua oyaivaa arinaima rikieeravai. Ivo itaa kua tuuvaara iya kumimakakiateeraivaara Yisuuva hauma kua tuduu rikiada ivaa oyaivaara iya inna yaparakiaaraivaara aatuuravai. ");
INSERT INTO waj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yisuunna ngiaammuauya ngiariita ngiariita kua yaagueeqama tida tunoo: Tiikidiri deevoono ari seenaiya yaataroo kieetavai varinarannee? ");
INSERT INTO waj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","tuduu rikioo Yisuuva iyaki vau kuaivaa rikioo nnaakara voovai vitoo ari yaaneennigiataa yapa kioo ");
INSERT INTO waj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iya tunoo: Gioonna kiaapu voovoono niiyara mmuduuya ruaivaara aa nnaakara aavaara tuqinnaivoono inna niiyaraatama tuqinnainoo. Niiyara tuqinnaivoono ni titoovaaraatama tuqinnainoo. Ivaarainno ngiiikidiri vaidi voovoono aduoo variivoono fai tauraanaavai varinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tuduu Yuvuaano Yisuunna tunoo: Nnoonna-o, ta taunnano vaidi voovoono i nnutuuvaa tasipama tioo vaidiiya aakiaakidiri mmagia maisaiyauvaa titaikiai kuaavai. Ii vaidi ivo hama ti tasipama nuai vaidivaara tida ta innara ooqoo kiaunnavaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","tuduu rikioo Yisuuva inna kua sai tunoo: Sa inna ooqoo kiatee. Gioonna kiaapu voovoono ngii kuaivaara hama ooqoo tiivoono inna hama ngii nnammutuaavai. Ivo inna ngii seenavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Anutuuqo tino Yisuuva ngiau aapu ari kuanara suaivo vainima vauduu too ari kuanaraipira yaata utuoo Yerusareema aataruuvau kuanaree kiaa viravai. ");
INSERT INTO waj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aataruuvau vioo varioo ari kuanara kuaivaananaa tuduu rikiada vaidiiyannaadee vidada oro Samariaa gioonna kiaapuuya yoosinna voovaki iya kiaa mmikiai rikiada Yisuunnani teerakiateeraivaara iya viravai. ");
INSERT INTO waj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Vida iya kiaa mmuduu rikiada ivaki varuuya Yisuuva Yerusareema kuanaraivaara rikiada hama innara iya yoketairavai. ");
INSERT INTO waj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hama innara iya yoketauduu rikiada Yisuunna ngiaammuauvaitana Yakoopaya Yuvuaanaya tunoo: Udaanga-o, a ti tinai ta ngiau aapuuvakidiri ikiaivaa tikio tioo iya taa taputu kiaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","tuduu rikioo Yisuuva hanigia yaagueeqama ivaitana sai tunoo: Sa itaa kua kiatee, ");
INSERT INTO waj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","kiaa kioo ivootama ari tasipama nuauyaatama vida tarada ari vo yoosinnaivakira viravai. ");
INSERT INTO waj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yisuuva ari ngiaammuauyaatama aataruuvau vida varuduu vaidi voovoono numa Yisuunna tunoo: A kuanna yoosinnaiyauvaki fai neeta i tasipama kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","tuduu rikioo Yisuuva inna kua sai tunoo: Fayaiya ngiari nnaamuruuyauvaki vakiaavai. Ngiaammaiya ngiari ngiisaiyauvaki vakiaavai. Na Vaidiivaa Mmaapuuvoono hama na vuru vaira nnauvootainoo, ");
INSERT INTO waj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","kiaa kioo vaidi voovai tunoo: Ni nnaagiai ngianee, tuduu rikioo ivo inna kua sai tunoo: Udaanga-o, kii na varinono ni napoova putinai hau kiee i nnaagiai kuanaravee, ");
INSERT INTO waj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","tuduu rikioo Yisuuva inna kua sai tunoo: Pikinai vaidi koonnama variaiya putuaiya roosiikiaiyaano ngiari seena vaidi putuaiya hakuatee. Eenoo oro gioonna kiaapuuya Anutuuqo gioonna kiaapuuyara dira mmayaayaivaa kiaa mmianee, ");
INSERT INTO waj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","tuduu rikioo vaidi voovoono inna tunoo: Udaanga-o, fai na i nnaagiai kuanaravee. Kii na oro ni nnauvaki variaiya tee fai i nnaagiai kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tuduu rikioo Yisuuva inna tunoo: Gioonna kiaapu voovoono ni mmooriivaa iinnonnoonnaata ivau kuataama vaikioonnaatainno hanigioo ivo tauraa aataruuvaara yaata utiivo fai hama yopeema Anutuuqo gioonna kiaapuuyara dira mmooriivaa iinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nnaagiai Udaanga Yisuuva kaayau vaidi vooya (72) nuunama kioo iya nnutuuyauvaa tioo taara tioo taara tioo titeeravai. Ivo nnaagiai kuanara yoosinna mmuakiaayauvaki iyannaadee kuateeraivaara iya titeeravai. ");
INSERT INTO waj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iya titaanara iinno varioo iya tunoo: Mmooriivaki kaayau yeenna kaanaiyauvo nneeravaata vaikiai gioonna kiaapu vareeraiya mmuaa taaraya variaanoo. Itaama vaikio mmoori nakaaraivo yeenna vareera gioonna kiaapu vooya titanai ari mmooriivakidiri kaanaiyauvaa varada inna nnauvaki yapaateeraivaara yaaku varaatee. ");
INSERT INTO waj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na ngii titauvau kuatee. Rikiaatee. Na gioonna kiaapu fai mmararaa roosiikiaiyasi ngii titanai iyasi vida ngia puara sipisiipa nnaakaraiya roosiima tirooma variaaravai. ");
INSERT INTO waj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sa sikau rira utuaiyauvaata sa ngiaaru kiaa yeennaivaa vara rira utuaiyauvaatama sa yuku nnaba vooyauvaatama uyida varada kuatee. Sa gioonna kiaapu aataruuvau ngiaiyaata teeda kua kiatee. ");
INSERT INTO waj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ngia nnau voovaki vida ivaki variaiya tauraa kiatee: Aa nnau aavaki variaiyaki ausa nuufaivo vakiaivee, ");
INSERT INTO waj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","tikio rikioo ausa nuufai vaidiivo ivaki varino rikioo fai ngii ausa nuufaivo innaki vainaravai. Hama ausa nuufai vaidi voovai ivaki varino too ngii ausa nuufaivo ngiingiiiki vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ngii miaa nnauyauvaki nnaasu varida yeennaiyauvaata nnooriiyauvaatama ngii miaiyauvaa nnaatee. Ngiengie mmoori varaivaudiri irisaiyauvo vaiyauvaa ngii mikiai nnaaraivaara itaama variatee. Sa vo nnau teeda vo nnau teeda nookiatee. ");
INSERT INTO waj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ngia ari vo yoosinnaivaki vikiai gioonna kiaapuuya ngii tuqinnada yeennaiyauvaa ngii miaiyauvaa nnaatee. ");
INSERT INTO waj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mmuai yoosinnaivaki varida nniitaraiya tuqinnada mmuakiaa gioonna kiaapuuya kiatee: Anutuuqo gioonna kiaapuuyara diraivo ngii vainima nninoo, kiatee. ");
INSERT INTO waj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngia vo yoosinna vo yoosinnaiyauvaki vikiai gioonna kiaapuuya hama ngii tuqinnakiai oro aataruuvau dida vaida kiatee: ");
INSERT INTO waj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Kufukuufaiyauvo ngii yoosinnaivaki vaiyauvakidiri kati ti yukuuyauvunu vaiyauvaa ta ruga kikio iyauvaara Anutuuqo irisai maisaivaa ngii minaravai. Vaa Anutuuqo gioonna kiaapuuyara diraivo ngii vainima nniivaara arinaima rikiaatee, kiatee. ");
INSERT INTO waj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na ngii giaa ngii miaunoo. Anutuuqo ti yaparaira suaivaki fai gioonna kiaapu yoosinna Sutuuma maisama varuuya irisai maisaivaa pinaama varaaravai. Hama ngii tuqinneera kiaa yoosinnaiya fai ngiari irisai maisaivo Sutuuma varuuya irisai maisaivaa yaataraanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Boo, ngia gioonna kiaapu yoosinna Korasima variaiyaata yoosinna Betesaitaa variaiyaatama fai yapooma ngii mmooriivaa irisai maisaivo vainaravai. Nnaaru gioonna kiaapuuya yoosinna Turu Sitoonaivaitana maisamaisama variravai. Na Anutuuqaa mmoori ari vookara ari vookarauyauvaa ngii yoosinnaivaitanaki iikiaivaa Turu Sitoona yoosinnaivaitanaki iikiaatiri. Iya teeda vaa nnaaru hanigiada yoketaama varutiri. Gioonna kiaapuuya iya hanigiada yoketaama varuuya taateeraivaara iya ausa mmuaararoovaa varada buruqa sisiiyauvaa raida kaupaivaa ngiari kieetaiyauvunu habara apu kiada varutirivee. ");
INSERT INTO waj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anutuuqo ti yaparainara suaivaki gioonna kiaapu Turu Sitoonaiya irisai maisaivaa pinaama varaaravai. Ngia gioonna kiaapu Korasimaiyaata Betesaitaiyaatama ngii irisai maisaivo iya irisai maisaivaa yaataraanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ngia gioonna kiaapu Kapanauma variaiyaso, ngia ngiau aapu variaaree kiaiya fai Anutuuqo tinai ngia mmeepi ikia aakiaana vida kiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yisuuva itaa kua kiaa kioo ari kuaivaa varada kuateera titoo vaidiiya tunoo: Gioonna kiaapu voovoono ngii kuaivaa rikiaivoono fai ni kuaivaata rikiaanaravai. Gioonna kiaapu voovoono fai ngiiiyara ooqoo tioo niiyaraatama ooqoo tinaravai. Fai niiyara ooqoo tioo ni titoovaaraatama ooqoo tinaravaivee, tuduu rikiada ngiari tuu mmooriiyauvaara vida raubiriiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vaidi kua varada nuairaiya (72) vida raubiriida mmoori varadada kava vara ranada nnida kaayau sirigaida kiaanoo: Udaanga-o, ta i nnutu tasipama kiaunnani mmagia maisaiyauvo gioonna kiaapuuya aakiaiyauvaki variaiyauvo tiida mmaanai kuaavaivee, ");
INSERT INTO waj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","tuduu rikioo Yisuuva iya sai tunoo: Na taaduu saneetuuvo utuneema Sataango ngiauvakidiri tipannuuma kioo tuoo viravai. ");
INSERT INTO waj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rikiaatee. Vaa na yaagueeqaivaa ngii miauvaara fai ngia nuaida yapaiyauvunuaata eevariiyauvunuaatama yuku reekio hama ngii gutinaravai. Na yaagueeqaivaa ngii miauvaara ngia Sataangaa yaagueeqa mmuakiaavai yaatarakio hama mminnaa voovoono ngii ruputinaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Vo kuavai vainoo. Mmagia maisaiyauvaa kiaani kuaivaara sa sirigaida variatee. Ngii nnutuuyauvo ngiau aapu yanaivau vaivaara sirigaida ivaara yaata utida variatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yisuuva itaa kua tuu suaivaki Mmannasa Yoketaivo inna tasipama varuuvaara inna ausaivo kaayauma yoketauduu tunoo: Ni Napoo-o, a ngiau mmataivaara diraikuavee. A ai kua oyaivaa vaidi tinni ruaiyara hatauma kiee vaidi nnaakara meedi roosiima hama tinniaata kiaiyara a kiaa kookieema kiaannaivaara na aiyara yoketaakiaunoo. Ni Napoo-o, a kutaa kati iya i kiaa i mmiataikiai a iya kiaa mmiannavaivee. ");
INSERT INTO waj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ni Napoova eenoo mmuakiaa mminnaivaara diraivaa vaa a ni miannavaivee. Hama gioonna kiaapu voovoono na i Mmaapuuvaa arinaima ni taivai. Eenoo ni Napoovaano nnaasu arinaima ni taannavai. Hama gioonna kiaapu voovoono ni Napoonna i taivai. Na i Mmaapuuvoono nnaasu arinaima i tauvai. Na gioonna kiaapu voovai kooyaa i vitainaraivo ivootama fai i taanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yisuuva hanigia ari ngiaammuauya nnaasu tunoo: Aanna makee vaiyauvaa ngia taivaara Anutuuqo ngiiiyara yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na ngii giaa ngii miaunoo. Nnaaruaa vaidi forofetaa kaayauyaata kaayau kieeta vaidiiyaatama aanna makee ngia taivaa iya taatauduu ivaara faannaidada putida hama teeravai. Aanna makee ngia rikiaa kuaivaa iya rikiaatauduu iya faannaidada putida hama rikieeravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mmoori aataru radudeera vaidi voovoono Yisuunnasi ngioo inna iinno taanaree kiaa inna yaparainno tunoo: Vitaira-o, dee mmoorivai na iina tupatupaa variraivaa varaanarannee? ");
INSERT INTO waj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","tuduu rikioo Yisuuva inna kuaivaa sai tunoo: Anutuuqaa mmaanna tuu kuaivaa a yaaruannano dataa kuainno tiinnee? ");
INSERT INTO waj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","tuduu rikioo ivo inna sai tunoo: I Udaanga Anutuuqaara mmuduuya ruee ai ausa mmuduuya mmuakiaavai inna mmianee. Ai vaidi kaanaivaatama ai yaagueeqaivaata ai yaata vuatinniivaatama mmuakiaavai inna mmianee. E aiyara tuqinnaannaneema ai seenaiyaraatama tuqinnee iyara mmuduuya ruanee. Mmaanna tuu kuaivo itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","tuduu rikioo Yisuuva inna sai tunoo: A kianna kuaivo kutaa kuavai kiannanoo. Ii kua ivaa a iinna fai a tupatupaa variraivaa varaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tuduu rikioo mmoori aataru radudeera vaidiivo gioonna kiaapuuya innara safuuma variraivovee kiateeraivaara Yisuunna yaparainno tunoo: Mo ni seenaivo inna gioononnee? ");
INSERT INTO waj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","tuduu rikioo Yisuuva inna kuaivaa sai tunoo: Vaidi voovoono Yerusareema pikioo yoosinna Yerikoora kuanee kiaa vioo varikiai vaidi mmuara furaiya numa inna utida inna buruqaivaa rakuasaa kiada paati kieema inna ruputu kiada pikiaavai. Pikiaavo ivo putinara iinno varikio too ");
INSERT INTO waj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Anutuuqaara kati puara hudeera vaidi voovoono aataruuvaugiataa vioo taikio vaidi putinara iivo inna too vaikio too saigiataa vioo taroo kuaivai. ");
INSERT INTO waj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vioo taroo kuaikio rikioo Riviinna oyaivakidiriaa vaidi voovoono vioo vioo taikio inna too vaikio rikioo mmuaikaraama vioo too saigiataa vioo taroo kuaivai. ");
INSERT INTO waj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Vioo taroo kuaikio rikioo vaidi Samariaa voovoono aataruuvaugiataa numa too innara pinaama boo tioo ");
INSERT INTO waj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","aduoo varioo nnammari suuyaivaata vuaina suuyaivaatama inna uudaiyauvunu tusaa siikainno buruqa yeenaivaadiri rau kioo vitoo ari puara togiivau yapa kioo vitoo vida nnida vaira nnauvaki yapa kioo inna tuqinnaivai. ");
INSERT INTO waj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tuqinnama kioo vaivo pataikio diitoo ari utuaivakidiri taara sikauvaitana suiiraa kioo vida nnida vaira nnau nakaaraivaa mmioo tinoo: Innara tuqinnaanee. Tuqinnanai rikiee fai na kava vara ranee ngiee teenai a innani mminnaa vooyauvai yookaakiannaiyauvaara na sai i mminaravaivee, tiivaivee. ");
INSERT INTO waj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yisuuva itaa kua kiaa taika kioo mmoori aataru radudeera vaidiivaa tunoo: Mmuara furaiya ruputu kiaa vaidiivaa taaravooma vaidiiya numa inna taivaara a dataa kuainna kiannannee? Deevoono inna seena tuanaavai variinnee? ");
INSERT INTO waj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","tuduu rikioo mmoori aataru radudeera vaidiivo inna sai tunoo: Vaidi voovoono innara boo tioo innara tuqinnaivoono inna seena tuanaavaivee, tuduu rikioo Yisuuva inna sai tunoo: Eenoo viee ivo iineema mmuaikaraama iikianee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yisuuva itaa kua kiaa kioo ari ngiaammuauyaatama aataruuvau vida varida vo yoosinnavakira vida rikiooduu gioonnaivaa nnutuuvo Mataava ari nnauvaki ngianeera Yisuunna maavee tuduu rikioo ivo numa variravai. ");
INSERT INTO waj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mataanna nnunnaivaa nnutuuvo Mariaava ivaki varuuvoono numa Yisuunna mmatama varioo inna kuaivaa rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Rikiooduu Mataava aritanna pinaa mmoorivai varoovaara pinaama ausa pirisainno numa Yisuunna tunoo: Udaanga-o, hama a niiyara yaata utuannannee? Ni nunnaivo ni pikiaikiai nenetanna nnaasu pinaa mmoori varaunoo. Inna tino numa ni tasipama mmoori varaivee, ");
INSERT INTO waj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","tuduu rikioo Udaanga Yisuuva inna sai tunoo: Mataa-o, a kaayau mmooriivaara pinaama yaata utuannano i ausaivo mmuaararainoo. ");
INSERT INTO waj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mmuaa aataruvai hama aisi vainoo. Ii aataru ivaara Mariaava yaata utivaivee. Fai hama gioonna kiaapuuya ii aataru ivaa innasidiri varaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Vo suai voovaki Yisuuva ari vo kammuvau varioo yaaku varoonnonno taika kiooduu ari ngiaammuau voovoono innasi ngioo tunoo: Udaanga-o, Yuvuaano ari ngiaammuauya yaaku vareeraivaara kiaa mmuneema ti kiaa ti mmianee, ");
INSERT INTO waj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","tuduu rikioo Yisuuva iya tunoo: Ngia yaaku varaaree kiaa ataa kua yaaku varada kiatee: TiSB7 Napoo-o, i nnutuuvo mmannammanna yaagueeqa yoketaaSB9 tuanaavai nnaasu vakiaivee. A gioonna kiaapuuyara diraivaa kino too ngiaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mmuaa suai mmuaa suai mmannammanna ta nnaara yeennaiyauvaa ti mmianee. ");
INSERT INTO waj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mmuakiaa gioonna kiaapuuya mmoori maisaivaa ti mmiaani ta hama ivaara yaata utiraida ti ausa mmuduuyaiyauvaa iya mmiaunnaivaara eenoo ti mminnamminnaa maisaiyauvaara sa yaata utirainna rugaanee. Sa ti vitee ti iinno taanara tiivaki ti yapaanee, kiatee. ");
INSERT INTO waj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yisuuva itaa kua kiaa kioo kua voovaata iya tunoo: Ngiiikidiri dee vaidi voovoono aa kua aavaa na tinaraivaa iinnee? Fai ivo heena tammaaki ari seenaivaasi vioo tinara: Ni seena-o, yeenna saaba taaravooma ni minai na yapooma irisai i mminaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ni seena voovoono ngieeradiri hokoba aataruuvau nuainnonno niisi nnikiai na hama yeenna inna mminaraivootainoo. Ivaara ni mianee. ");
INSERT INTO waj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Fai ivo itaa kua tino vaidi nnau aakiaivaki variivo inna sai tinara: Ngieera kuanee. Vaa na ni sipuuvaa rau kiee ni nnaakaraiya ni tasipama vuru vakiaanoo. Hama na yopeema diitee mminnaa vooyauvai vara i mminaravee, tinoota mmannammanna inna yaparainono inna mminaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na ngii giaa ngii miaunoo. Ivo ari seena tuanaivo inna yapara ruaivaara hama iva diitoo yeennaivaa inna mminaravai. Ivo mmannammanna inna yapara ruaivaara iva diitoo inna mminaravai. ");
INSERT INTO waj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ivaara na ngii giaa ngii miaunoo. Ngia Anutuuqaa yaparaikio fai ngia yaparakiaivaa ngii minaravai. Mminnaa voovaara buaida teekio fai ngii too vainaravai. Sipuuvau rikiokio fai Anutuuqo sipuuvaa ngiiini hatuaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gioonna kiaapu Anutuuqaa yaparaivoono fai ari yaparaivaa varaanaravai. Gioonna kiaapu voovoono fai mminnaivaara buainnonno teeno fai inna too vainaravai. Gioonna kiaapu voovoono sipuuvau rinono fai Anutuuqo innani sipuuvaa hatuaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Vaidi voovoono ngiiikidiri aa na tinara kua aavaa iinarannee? Fai inna mmaapuuvo tavaura inna yaparaino fai ivo yapaivaa inna mminarannee? Hameetavee. ");
INSERT INTO waj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Fai inna mmaapuuvo kakaraa mmuyaira inna yaparaino fai eevariivaa inna mminarannee? Hameetavee. ");
INSERT INTO waj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ivaara ngia vaidi mmatayaa maisama variaiya mminnaa yoketaiyauvaa ngii nnaakaraiya mmiaa aataruuvaa vaa ngia taavai. Ngii Gioova ngiau aapu variivo ngia ngiingii nnaakaraiya mmira aataruuvaa yaataraivaivee. Fai gioonna kiaapuuya inna yapara rikio Mmannasa Yoketaivaa iya mminaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yisuuva vaidiivaa aakiaivaki mmagia maisaivo topaama kioo varuduu inna avaivo ramuunnaama kioovaa titooduu mmagia maisaivo vioo kiooduu rikioo vaidiivo kua tuuvaara gioonna kiaapuuya ivaki nuunauya pinaama nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nnikiarauduu vooyaano tunoo: Mmagia maisaiya kieetaivo Beresebuuro inna tasipama varikioonno ari yaagueeqaivaadiri mmagia maisaiya vaidi aakiaaki variaiya titaikiai kuaavaivee, ");
INSERT INTO waj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","tuduu rikiada inna iida taaraivaara vooya inna tunoo: A ari vookarai mmooriivaa iinai ta teeda kiaara: Anutuuqo inna tasipaikioonno iinoo, kiaaravee, ");
INSERT INTO waj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","tuduu rikioo Yisuuva iya tinniyaa vau kuaivaa rikioo iya tunoo: Fai gioonna kiaapuuya mmuaa mmatavau variaiya rapidada ivaudiri raubiriida mmarammaraa varida hama yopeema mmuaavau yaagueeqama varida fai taikaaravai. Fai mmuaa nnauvaki variaiya ivakidiri rapida fai vida raubiriida mmarammaraa varida fai hama mmuaavau yaagueeqama varirama kiada fai muaraagakiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Itaama vaino Sataango ari seena mmagia maisaiyaatama rapuoonnonno kinai fai mmarammaraa varida hama mmuaavau yaagueeqama varirama kiada fai muaraagakiaaravai. Ngia kiaanoo: Beresebuuro ari yaagueeqaivaa ni mikiai na mmagia maisaiya titaukai kuaanoo, kiaani ");
INSERT INTO waj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","mo ngii nnaagiai nuairaiya giaa yaagueeqavaura iya mmagia maisaiya titaani kuaavainnee? Hama Beresebuuraa yaagueeqaivoono ngii seenaiya tasipaivai. Ivaara ngia koonnama niiyara yaata utuaa kuaivo kooyaa vainoo. ");
INSERT INTO waj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Anutuuqaa yaagueeqaivo ni tasipaikiai na mmagia maisaiya titaukai kuaavai. Na itaama iikiauko Anutuuqo gioonna kiaapuuyara dira suaivo vaa ngiiisi nniivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kiaa kioo kava vo kua voovai mmataama kioo tunoo: Fai vaidi yaagueeqa voovoono ari suru veeva yau mmataivaa tu kioo vainno ari nnauvaara dioo vaino rikioo inna mminnamminnaiyauvo yoketaama vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nnaagiai vaidi yaagueeqa tuanaa voovoono numa innaata rapuoonnonno inna yaatara kino rikioo muaraagaino fai inna suru veeva yau mmataivaa ivo yaagueeqama tu kioo vaivaa ravisi varoo inna hoonaiyauvaatama varoo ari seenaiya yapa mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","kiaa kioo tunoo: Gioonna kiaapu voovoono hama niiyara yoketaivoono inna ni nnammutuaavai. Gioonna kiaapu voovoono hama ni tasipama ni mmoori varaivoono ni mmooriivaa tuayanna ruaivai. ");
INSERT INTO waj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Mmagia maisaivo vaidiivaa aakiaivakidiri pikioo vioo koo mmuyai gaanga yoosinnaiyauvaki ari varinara mmaataivaara buaama roo nuainnonno taikio kuminaikio ariita kua tioo tinoo: Fai na kava vara ranee nini nnau pikiauvaki oro varinaravee, ");
INSERT INTO waj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","kiaa kioo kava vara ranoo numa taikio ari nnauvo rupi yamaama kioo funnukama kiaikio ");
INSERT INTO waj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","mmanna nnauvai vaikio too ivaki varioo oro seena mmagia maisaiyauvo inna maisaivaa yaatareera yaaku saivai karasaidiri taaramada vitoo nnikiai iya numa inna tasipama variaavai. Aa vaidi aavaa aakiaivaki tauraa mmagia maisa mmuaavai varikio kiisama maisama varikiai nnaagiai kaayau mmagia maisaiya innaki variaavo kaayau maisama varivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yisuuva itaa kua tuu saivaata gioonna kiaapu kaayauma uuya nuuna aakiaivakidiri gioonna voovoono kua pinaivaa inna tioo tunoo: I kaano ari ausaivakidiri i mmata kioo ari nnaamma i mmuuvaara Anutuuqo innara yoketainoo, ");
INSERT INTO waj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","tuduu rikioo inna kua sai tunoo: Yo, inna aikioonna kiannanoo. Mo gioonna kiaapuuya Anutuuqaa mmayaayaivaa rikiada iikiaiyara Anutuuqo iyara pinaama yoketainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tuduu gioonna kiaapuuya inna suvuau kiada varuduu Yisuuva vo kuavai tunoo: Gioonna kiaapu aanna makee variaiya koonnama variaanoo. Iya ari vookarai mmooriivaa taara iikiaanoo. Anutuuqaa mmoori ari vookarauvaa nnaaruaa vaidi Yonaava uuvaa roosiivaa iya ivaa nnaasu taaravai. Fai hama kava voovai taaravai. ");
INSERT INTO waj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Fai Na Vaidiivaa Mmaapuuvo Yonaannanikaraama iinaravai. Nnaaru Ninivee varuu gioonna kiaapuuya Yonaava uuvaa tooneema fai ngia makee variaiya Na Vaidiivaa Mmaapuuvo iinaraivaa taaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nnaaru kieeta varuu gioonna voovoono tooya ipunna sainai ngieera ari voopidiri ngioo ngioo vaidi Soromoono tinni ruaivaasidiri kua rikiaanara nniravai. Na ngii giaa ngii miaunoo. Na aavaki variauvo Soromoonaa yaatarauvoono ngii tasipama variaunoo. Gioonnaivo ngieeradiri numa Soromoonaa kuaivaa rikioovaara yapooma Anutuuqo gioonna kiaapuuya yaparainara suaivaki fai ivoono kua pinaivaa aanna ngia variaiya ngiiiki yapa kino Anutuuqo irisai maisaivaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ninivee varuu gioonna kiaapuuya Yonaanna kuaivaa rikiada ausa hanigiada yoketaama variravai. Na ngii giaa ngii miaunoo. Na aavaki variauvo Yonaanna yaatarauvoono ngii tasipama variaunoo. Ninivee varuuya ausa hanigiada yoketaama varuuvaara yapooma Anutuuqo gioonna kiaapuuya yaparainara suaivaki fai iya kua pinaivaa aanna ngia variaiya ngiiiki yapa kikio Anutuuqo irisai maisaivaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Hama gioonna kiaapu voovoono toobaivaa subi varoo kuupaivaki hatauma yapa kiaivai. Hama yavaivaa varoo ivau tuarapuatikama rummua apu kiaikio vaivai. Gioonna kiaapuuya mmaanaidiri ngiaiya mmeekiaivaa taateeraivaara ivo toobaivaa varoo kiikoo koovau hirivai. ");
INSERT INTO waj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A gioonna kiaapu voovoono i avuuvoono i mmammaivaara mmeekia roosiivai. I avuuvo yoketaama taikiai a mmeekiaivau nuairaivaa roosiima yoketaama nookiannavai. I avuuvo upisiikiai a upisiivaki nuairaivaa roosiima hama a yoketaama nookiannavai. ");
INSERT INTO waj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ivaara mmeekiaivo iiki vaivaa upisiivoono rummua apivoora tuqinnama yaata utuanee. ");
INSERT INTO waj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Fai mmeekiaivo i aakiaivaki suvuaino hama upisiivo yopeema mmeekiaivaa rummua apinaravai. Toobaivaa subi kiaavo mmeekiaivo taivaa roosiima i aakiaivaki fai pinaavai mmeekiaivo taanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yisuuva itaa kua kiaa taika kiooduu Farisai vaidi voovoono ni tasipama yeenna nnaaneera Yisuunna tuduu inna nnauvaki vioo inna tasipama yeennaivaa nnooduu ");
INSERT INTO waj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisai vaidiivo tooduu Yisuuva hama ari yaakuuvaudiri tauraa finirama kioo kati yeennaivaa nnooduu ivaara nnikiarairavai. ");
INSERT INTO waj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nnikiarauduu Udaanga Yisuuva inna tunoo: Ngia ngii pereeta kaapa mmaanaiyauvaa fini kiaavo yoketaivaa roosiima ngii mmammaiyauvo vaikio ngii aakiaiyauvaki ngii mminnamminnaa maisaiyauvo suvuainoo. Ngia gioonna kiaapuuya unnakua kiaa kiada iya hoonahaanaiyauvaa ngiingiiiyara ravisi varada maisama variaavai. ");
INSERT INTO waj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngia yaata duunayavee. Anutuuqo ngii nnabaiyauvaa iima kiaivoono ngii aakiaiyauvaatama iivaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Fai ngia ngiingii aakiaiyauvaa tuqinnadaida mminnaiyauvo ngiiisi vaiyauvaa ngii seena mmanna haipuuya mmikio fai ngii aakiaa mmaanaiyauvootama yoketainaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Boo, ngia Farisai vaidiiya ngii irisai maisaiyauvo vainoo. Ngia kiisa mminnaa kapikarai takua roosiiyauvaa yaakuuvaitana utida mmuaavai Anutuuqaani kiadaataida ngia hama safuuma ngiingii seenaiyara tuqinneeraida hama Anutuuqaara pinaama mmuduuya ruaanoo. Ii aataru ivaitana iikiataama vaikiainnaata hama iikiaanoo. Ngia ii aataru ivaitana iidadaida vo aataruyauvai vaa ngia iikiaiyauvaatama iikiatee. ");
INSERT INTO waj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Boo, ngia Farisaiya ngii irisai maisaiyauvo vainoo. Ngia nuunaira nnauyauvaki vida mmaata yoketaiyauvunura nnaasu mmuduuya rida variaavai. Ngia yoosinna aakiaiyauvaki nookiaani gioonna kiaapuuya ngii teeda kua yoketaivaa ngiiiyara kiaiyauvaara mmuduuya ruaavai. ");
INSERT INTO waj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Boo, ngii irisai maisaiyauvo vainoo. Ngia mmata nnauyauvaa gioonna kiaapuuya hama teeraida sabi ivau nuairaivaa roosiikiaayavee tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tuduu rikioo mmoori aataru radudeera vaidi voovoono inna sai tunoo: Vitaira-o, e itaa kua ti kianna ivo inna kua maisaivaatainna ti kiannanoo, ");
INSERT INTO waj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","tuduu rikioo Yisuuva inna sai tunoo: Boo, ngia mmoori aataru radudeera vaidiyavee. Ngii irisai maisaiyauvo vainoo. Vaidiiya kaayau mmuaararai mminnaiyauvaa vaidi vooya yaapusaiyauvunu kumaata apu kiaivaa roosiima ngia gioonna kiaapuuya mmoori mmuaararaiyauvaa iya mmi kiada hama ngiengieeta kiisama iya tasipama mmuaararai mmooriivaa varaavai. ");
INSERT INTO waj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ngii irisai maisaiyauvo vainoo. Ngii rubu tabeeya forofetaiya ruputuduu putuuyara ngia sikauyauvaadiri iya mmata nnauyauvo yoketaakiaiveera funnukama yoketaama kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iyaano iya ruputu kiooduu ngieenoo iya mmata nnauyauvaa funnukama kiada ngii rubu tabeeya uuvaa teeda kiaanoo: Inna aikioovaivee, kiaanoo. ");
INSERT INTO waj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ivaara Anutuuqaa tinniyaa vau kua yoketaa fafaaraivo vainno tunoo: Na fai forofetaiyaata vaidi ni kuaivaa varada nuairaiyaatama titanai vikiai fai vaidiiyaano vooya vatada iyara kua maisaivaa tida ruputikiai putuaaravaivee. Anutuuqoono itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nnaaru ngiau mmata uu suaivakidiri gioonna kiaapuuya forofetaiya ruputua rada nnidada aanna makee homo gioonna kiaapuuya forofetaiya ruputuaanoo. Fai aanna makee variaa gioonna kiaapuuya forofetaiya ruputuaivaa irisaivaa varaaraivaara nnaaru Anutuuqo fafaarama kioo kuaivo vainoo. ");
INSERT INTO waj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nnaaru vaidi yoketaa voovai Aveeraa kuminayaa ruputu kiooduu putuduu ivakidiri iima rada nnidada vaidi voovai Sakariaasaa ruputu kioovaa irisaivo fai ngiiiki vainaravai. Iya nuunaira nnau pinaivaki vuduu yeena tapi Anutuuqaara hudeeraivo sainai vauduu vo atau yoketaa tuanaa nnau voovai sainai vauduu iya vuutaivaki Sakariaasaa ruputu kieeravai. Na ngii giaa ngii miaunoo. Ruputu kiooduu putuuvaa irisaivaa aanna makee variaa gioonna kiaapuuya varaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Boo, ngia mmoori aataru radudeera vaidiyavee. Ngii irisai maisaiyauvo vainoo. Ni kuaivaa rikiada tinni yoketaa vareera aataruuvo sipuuvaa roosiivai. Ngia hama ngii kuataikiaida hama kuaivaara kiivaa varada gioonna kiaapuuya kuaaree kiaiya sipu rairayaama ngieenoo aataruuvaa uuda rammuaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yisuuva itaa kua kiaa kioo ii nnau ivaa pikioo vioo varuduu mmoori aataru radudeera vaidiiyaata Farisai vaidiiyaatama ngiari ausaiyauvo kaayauma nnannatooduu Yisuuva haruruoo kua voovai koonnama tinai iya kua pinaivaa innaki yapaaraivaara ari vo kua ari vo kuaiyauvaara yaagueeqama inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yisuuva itaama Farisaiyaata kua tuu suaivaki kaayakaayau gioonna kiaapuuya nuunaida varuduu hama iya diaara mmaataatauduu ngiari seenaiya yukuuyauvunu diravai. Dida vauduu Yisuuva iya tasipama numa dioo vainno ari ngiaammuauya kiaa mmioo tunoo: Ngia vaidi Farisaiya puuqaira yeenna roosiikiaiyara tuqinnama haitatuukiatee. Iya unnakua kiaa iira aataruuvaara na itaa kua kiaunoo. ");
INSERT INTO waj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mmuakiaa mminnaiyauvaa rummua apu kiaiyauvaa fai rabara kino kooyaa vainaravai. Mmuakiaa mminnaiyauvo hataumaki vaiyauvo fai kooyaa vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Itaama vaikiai ngia upisiivaki hauma kiaa kuaivo fai gioonna kiaapuuya kooyaa ikiannaivau rikiaaravai. Ngia nnau aakiaiyauvaki vida sipuuyauvaa rau kiada ngiingii yaataki ngiingii yaataki murumuru kiaa kuaiyauvaa fai gioonna kiaapuuya yoosinna vuutaivaki aayanna reeda kooyaa kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ni seenayaso, na ngii giaa ngii miaunoo. Gioonna kiaapu vooya ngii mmammaiyauvunu ruputikiai putuaaraivaara sa aatuukiatee. Ngia putikiai fai iya hama yopeema kava mmoori maisaivaa ngii miaaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anutuuqaara nnaasu aatuukiateera na ngii giaa ngii miaunoo. Ivoono ngii ruputinai ngia putikio fai ivoono ikia aakiaivaki ngii yapaanaree tioo fai ngii yapaanaravaivee. Kutaa na ngii giaa ngii miaunoo. Innara aatuukiatee. ");
INSERT INTO waj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ngia taara sikau kiisakiatatana kiada fai ngia ngiaamma kiisa siganna roosii yaaku saivai varaaravai. Anutuuqo hama iyauvaara vueennainno voovai pikiaivai. ");
INSERT INTO waj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngii kieeta yaasiiyauvaa Anutuuqo yaaruoo mmuaavai mmuaavai taivai. Sa aatuukiatee. Anutuuqo ngiiiyara yaata utiraivoono ivo kaayau ngiaamma siganna roosiikiaiyauvaara yaata utiraivaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Na ngii giaa ngii miaunoo. Gioonna kiaapu voovoono ari seena gioonna kiaapuuya avuuyauvunu dioo vainno kooyaa tinara: Na aanna Yisuunna nnaagiai nuairaivovee, tinai fai Na Vaidiivaa Mmaapuuvo Anutuuqaa aangeraiya avuuyauvunu diee vaina innara kooyaa tinara: Inna ni nnaagiai nuairaivovee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gioonna kiaapu voovoono ari seena gioonna kiaapuuya avuuyauvunu dioo vainno niiyara ooqoo tinai fai yapooma Anutuuqaa aangeraiya avuuyauvunu Na Vaidiivaa Mmaapuuvo innara ooqoo tinaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Gioonna kiaapu voovoono Na Vaidiivaa Mmaapuuvaara maisavaivee tiivaa fai Anutuuqo ivaa rugaanaravai. Gioonna kiaapu voovoono Mmannasa Yoketaivaara maisavaivee tiivaa fai Anutuuqo hama ivaa rugaanaravai. Fai tupatupaa vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yapooma gioonna kiaapu vooyaano fai ngiari nuunaira nnauyauvaki ngii vitada ngiari kieetaiya avuuyauvunu kua pinaana ngii yapa kikiai sa ngia iya sai kiaara kuaiyauvaara kaayauma yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Fai ii suai ivaki Mmannasa Yoketaivo ngia sai kiaara kuaiyauvaa ngii giaa ngii minaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tuduu gioonna kiaapuuya nuuna aakiaivakidiri vaidi voovoono Yisuunna tunoo: Vitaira-o, ni napoova vaa putikio ni vaavova ari nnaasu hoonahaanaiyauvaa varainoo. Eenoo tino too saiyauvai ni miaivee, ");
INSERT INTO waj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","tuduu rikioo Yisuuva inna sai tunoo: Boo, ni vaidivai. Hama na kua pinaivaa radudeera vaidivai diauvaivee. Hama na ngii mminnaiyauvaara diee vaina itaqitaama yapaateera kiaunoo, ");
INSERT INTO waj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","kiaa kioo gioonna kiaapu mmuakiaaya tunoo: Ngiingii variraivaara tuqinnama yaata utuatee. Sa mmuakiaa mminnamminnaiyauvaara teekio ngii varaataakiaiyauvaara yaata utuatee. Gioonna kiaapu voovoono hama kaayau mminnamminnaiyauvaa varaanaraivaara varivaivee. Fai ivo kaayau hoonahaanaiyauvaa varano iyauvoono hama varira tuanaivaa yopeema inna mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","kiaa kioo Yisuuva mmatayaa diaa mminnaivaudiri mmataama kioo tunoo: Vaidi voovoono kaayau hoona suvuaivoono mmoori varaikio yeennaiyauvo kaayauma kaanaivai. ");
INSERT INTO waj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kaanaikio too ivo yaata utuoo ariiyara tinoo: Hama ni yeenna iiraiyauvaa yapaanara nnaunnaatainoo. Na dataama iikiaunnee? ");
INSERT INTO waj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Inna aikioo, fai na ataama iinaravai. Ni yeenna yapau nnauyauvaa havarata kiee fai pinaa nnauyauvai heekaanaravai. Heeka kiee ivaki ni yeennaiyauvaata ni hoonahaanaiyauvaatama yapaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Fai na itaama iina niniiyara tinara: Na vaidi yoketaavaivee. Mminnamminnaa yoketaiyauvo ni suvuainoo. Fai vo nuanu vo nuanu hama na pinaa mmooriiyauvaa varaanaravai. Fai na kati variee nnoori nnee yeenna nnee sirigaina varinaravaivee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ivo yaata utuoo itaa kua tiivaara Anutuuqo inna tinoo: A yaata duunakuavee. Fai aa heena aavaki a putinaravaivee. Mo a putino gioono aa mminnaa a yapa kiaanna aayauvaa varaanarannee? ");
INSERT INTO waj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yisuuva ii kua ivaa kiaa taika kioo tunoo: Gioonna kiaapuuya kaayau mminnamminnaiyauvaa ngiariini yapa kiaiya ii vaidi ivaa roosiikiaayavee. Iya mmatayaa diaa mminnaiyauvaa ngiariini yapaavovo suvuaikiai iya Anutuuqaa avuuvau kumina tuanaaya variaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yisuuva itaa kua kiaa kioo ari ngiaammuauya tunoo: Itaama vaikiaina na ngii giaa ngii miaunoo. Sa pinaama ngiengie mmatayaa variraivaara yaata utida sa ngiengie yeenna nnaaraivaara kaayauma yaata utuatee. Sa ngia uyira rairaiyauvaa ngiingii mmammayaa uyuaaraiyauvaara kaayauma yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hama ngia yeenna nnaaraivaara nnaasu variaavai. Hama ngia ngiingii mmammaiyauvunu funnukakiaaraivaara nnaasu ngii mmammaiyauvo vaivai. ");
INSERT INTO waj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ngia ngiaamma kuangedaiyauvaara yaata utuatee. Iya hama vuayeennaiyauvaa hau utida tau ruaa rada ngiari yeenna yapeera nnauyauvaki yapa kiaavai. Anutuuqoono yeennaiyauvaa iya mmiivaivee. Anutuuqo ngiiiyara tuqinneeraivoono ngiaasukuaiyara tuqinneeraivaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Ngiiikidiri deevoono ari varinaraivaara pinaama yaata utuoo oro hayu yapaanarannee? Hama yopeemavee. Ii ngia yaata utida ngiingii variraivaa hayu yapaaravee kiaa kua ivo kiisakiatavee. Mo ngia hama aikiooma ii kiisa kua ivaa iirama kiada aaniira ngia pinaa mmoori ari vookaraiyauvaara pinaama yaata utuaarannee? ");
INSERT INTO waj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ngia tuqinnama mauraiyauvo mmatayaa uriiyauvaara yaata utida rikiaatee. Hama iyauvo vaidi ti roosiima ngiari uyira rairaiyauvaa iima kiada variaavai. Iyauvo kati ari mmaara urikiai iyauvaa taavo yoketaivai. Na ngii giaa ngii miaunoo. Itaama mauraiyauvo urikiai iyauvaa taavo yoketaiyauvoono nnaaruaa vaidi kieetaivaa nnutuuvo Soromoono ari mmammayaa uyira raira ari vookarauyauvaa uyu kiaiyauvaa yaatara kiaivai. ");
INSERT INTO waj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ngia kiisama Anutuuqaara kutaavaivee kiaiyaso, Anutuuqo maura ikiauyauvaa yapa kiaikio makee urikiai turau vaidiiya hamuku kiada ikia mmuturuaaraiyauvaara ivo tuqinnaivai. Ivo mauraiyauvaa itaama tuqinnaineema ngiiiyaraatama tuqinnaanaravai. Ngii mmammayaa uyira rairaiyauvaa ngii minaraivaara ngia aaniira kaayauma yaata utuaannee? Fai ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dee nnoorivai nnaarannee? Dee yeennavai nnaarannee? Ivaara sa pinaama yaata utuatee. Sa ngia airi yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vaidi hama Anutuuqaa kua rikieeraiya ii mminnaa iyauvaa varaaraivaara pinaama yaata utuaavai. Ngii variraivaki ii mminnaa iyauvo hameetaivaara vaa ngii Gioova rikiaivai. ");
INSERT INTO waj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sa iyauvaara yaata utuatee. Anutuuqo gioonna kiaapuuyara diraivaa varaaraivaara tauraa yaata utuatee. Fai itaikio Anutuuqoono ii mmuakiaa mminnaa iyauvaatama ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ngia ni puara sipisiipaiya roosiikiaiya sa aatuukiatee. Fai ngii Gioova ngiiiyara yoketainno gioonna kiaapuuyara diraivaa ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ngii mminnamminnaa mmuakiaayauvai varada oro vaidi vooya mmida irisai sikauyauvaa varada oro mmanna haipu gioonna kiaapuuya mmiatee. Ngiau aapu vai mminnaa hama taikaanaraiyauvaara nnaasu yaata utida iyauvaara mmoori varaatee. Ngiau aapu vai mminnaiyauvo fai hama raubiriinno taikaanaravai. Hama vaidiiya numa iyauvaa mmuara varaaravai. Fai hama kegenaiya iyauvaa hatoka nnaaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gioonna kiaapu voovoono mmatayaa mminnaivaara mmuduuya ruoo fai ivaara nnaasu yaata utinaravai. Gioonna kiaapu voovoono ngiau aapu vai mminnaivaara mmuduuya ruoo fai ivaara nnaasu yaata utinaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mmoori vareera ngiaammuauya ngiari mmoori varaivaara ngiari buruqaiyauvaa uyu supugiaa kiada toobaiyauvaa subi teerama kiada variaaneema ngieeta itaqitaama teerama kiada variatee. ");
INSERT INTO waj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mmoori vareera ngiaammuauya iya nnoonnaivo yaapeeri buusaivakidiri nnaa kioo nninaraivaara faannakiaaneema ngieeta faannakiatee. Ivo ngioo sipuuvau rinai iya akiairainai innara hatuaaraivaara iya faannakiaavai. ");
INSERT INTO waj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mmoori vareera ngiaammuauya iya nnoonnaivo nninai teeda fai iya avu teeda vaida innara teerakiaiya fai yoketaama variaaravai. Na kua kutaavai ngii giaa ngii miaunoo. Iya itaikio too fai ivoono ari buruqaivaa uyu supugiaa kioo tinai nnikio too yeennaiyauvaa iya mminaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Fai ivo heena tammaaki nninarannee? Vara kakaraa akua tino nninarannee? Fai ngioo teenai vaa iya teerama kiaiya yoketaama variaaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aa kua aavaa rikiaatee. Vaidi voovoono nnauvaki mmuara vareera vaidiivo nninara suaivaa nnau nakaaraivo rikioo avu taitiri. Mmuara vareera vaidiivo ivaki ngioo hama yopeema sipuuvaa rukaitu kioo ngioo vioo mminnamminnaiyauvaa mmuara varaitirivee. ");
INSERT INTO waj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ivaaraida mmuaanaa teerakiatee. Hama ngia rikieera teera suaivaki Na Vaidiivaa Mmaapuuvo fai kava tiinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tuduu rikioo Petorooso inna sai tunoo: Udaanga-o, a ii mmatayaa diaa mminnaivaudiri mmataama kiee kianna kua ivaa tiiyara nnaasu kiannavainnee? Vara mmuakiaa gioonna kiaapuuyaraatama kiannavainnee? ");
INSERT INTO waj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","tuduu rikioo Yisuuva tunoo: Dee mmoori vareera ngiaammuauvoono tinni yoketaivaa varoo ari mmooriivaara hama pikieerainno mmannammanna yaagueeqama nnaasu iinnee? Itaama ii ngiaammuauvaa vaidi nnoonnaivo kieetavai inna yapa kiaikio inna nnauvaara haitatuunno seena ngiaammuauya yeenna nneera suaivaki yeennaiyauvaa duuyama kioo iya mmiivai. ");
INSERT INTO waj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ivo itaama varikio nnoonna vaidiivo ngieeradiri vara ranoo numa ari nnauvaki taikio homo yoketaama mmoori varoo varikio too ngiaammuauvaara inna yoketaivai. ");
INSERT INTO waj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na kua kutaavai ngii giaa ngii miaunoo. Ii ngiaammuau ivaa vaidi nnoonnaivoono ari hoonahaana mmuakiaayauvaara haitatuura ngiaammuauvai inna yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Fai iqii ngiaammuau ivoono hama itaama iirama kioo ariiyara yaata utuoo tinara: Nnoonnaivo hokoba suai ipi varioo hama akiairaama nninoo, kiaa kioo ari seena kiaatanna ngiaammuauya ripiinno ruputuoo pinaa yeenna nnoo nnoori kapikaraivaatama nnoo kumimakainno varinono ");
INSERT INTO waj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","yapooma hama ivo rikioo teera suaivaki nnoonnaivo ngioo inna ruputu rutaka kagaari kino ivo vaidi mmoorira haunninniiraiya variraivaki kuanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ngiaammuau voovoono ari nnoonnaivo tii kuaivaa vaa arinaima rikioonnaata vioo inna kuaivaa pikioo hama ivo tii mmooriivaa iinno teerataarairama kioo fai nnoonnaivo irisaivaa pinaama inna ripiinaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Vo ngiaammuau voovoono hama tuqinnama ivo tii kuaivaa rikioo arinaidiri sabi ivo tii mmooriivaa iinno koonnama kino fai nnoonnaivo irisai kiisama inna ripiinaravai. Vaidi voovoono vaidi voovai pinaa mmooriivaa inna mminaree kiaa ivo aikiooma iikiaiveeraivaara arinaima taa kioo rikiaa kioo inna mmino too yaagueeqama mmooriivaa varaivee. Ivo pinaa ari vookarai mmooriivaa inna mmino too yaagueeqama kioo mmooriivaa ari vookaraama varaivee. ");
INSERT INTO waj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Rapiraivo ikiaivaa roosiima mmataivau vakiaiveeraivaara na tiiravai. Ii rapira ivo ikiaivo teerayaama akiairaama taanaraivaara ni yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mmamma nniitaraivo nnoori apiraivaa roosiima fai na varaanaravai. Hama na vareera homo variauko ni ausaivo mmuaararainoo. ");
INSERT INTO waj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ngia yaata utuaani na gioonna kiaapu mmatayaiya ausa nuufaivaa mminaraivaara na tiiravainnee? Hama na ivaara tiiravai. Na ngii giaa ngii miaunoo. Iya hama ausa nuufaivaa tasipama mmuaavau varirama kiada iya mmarammaraama variaivaara na tiiravai. ");
INSERT INTO waj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aanna na variau suaivakiaata nnaagiai suaivakiaatama fai mmuaa nnauvaki yaaku saivai variaiya fai taara yaata utida taaravoomaano voovau varikiai taaramaano voovau variaaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iya mmarammaraama varida fai kookiaiya voovau varikiai mmaapuuya voovau variaaravai. Kaanokiaiya voovau varikiai iya raunnaapuuya voovau variaaravai. Nnaaputuuya voovau varikiai ngiari nnaaputuuya voovau variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yisuuva itaa kua kiaa kioo vo kuavai gioonna kiaapu kaayauya kiaa mmioo tunoo: Ngia namaivo rau kiaikiai teeda akiairaama kiaanoo: Kiisa suai vatiivo rinaravee, kiaavo vatiivo ruaivai. ");
INSERT INTO waj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ngia taavo ooruruuvo utikio ngiauvo rupikiai teeda kiaanoo: Inna suaivo taanara iinoo, kiaavo suaivo taivai. ");
INSERT INTO waj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngia huoobavainna unnakua nnaamuru tuanaayavee. Ngia ngiau mmataivaa teeda suaivo taanaraivaara arinaima teeda vatiivo ruanaraivaara arinaima taavai. Mo ngia aanna makee ta variaunna suai aavaki hama tuqinnama teeda hama ni oyaivaara arinaima rikiaavai. ");
INSERT INTO waj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ngia aaniira hama ngiengieenoo ngiingii kuaivaa kiaa safuuma kiada variraidaida kua pinaivaara dira vaidiivaasi kuaannee? ");
INSERT INTO waj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Fai vaidi voovoono kua pinaivaa iiki yapaanee kiaa i vitoo kua pinaivaara diraivaasi vivoora aataru tammaivaudiri innaata kua tiee safuuma kiaanee. A hama itaino fai ivo i vitoo kua pinaara diraivaasi vino fai ivoono oovi nnauvaara haitatuura vaidiivaa i mmino rikioo fai ivoono i vitoo oovi nnauvaki i yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na i kiaa i mmiaunoo. Fai a ivaki variee irisaivaa inna mmiee mmiee kiisa vookiata hama mmirama kiee fai mmannammanna oovi nnauvaki variee mmi taika kiee mmaanai tiee kuanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Karirayaa vaidiiya puaraiyauvaa kati Anutuuqaara ruputu hudooya ngiari mmooriivaa iida varuduu rikioo kieeta vaidi Piratuuso ari ngiaammuauya titooduu vida vooya ruputuduu putiravai. Yisuuva gioonna kiaapuuyaata kua tuu suaivaki vooyaano ii mmayaaya ivaara Yisuunna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kiaa mmuduu rikioo Yisuuva iya tunoo: Ngia yaata utida kiaanoo: Karirayaa vaidiiya Piratuuso itaama ruputuuya mminnamminnaa maisaiyauvo seena Karirayaa gioonna kiaapuuya mminnamminnaa maisaiyauvaa yaatarainoo. Iya kaayau mmamma nniitaroo maisauvaa varoovaara ngia yaata utida itaa kua kiaannee? ");
INSERT INTO waj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na ngii giaa ngii miaunoo. Hama iya mminnamminnaa maisaiyauvo mmuakiaaya mminnamminnaa maisaiyauvaa yaataraivai. Fai ngia hama ngiingii mminnamminnaa maisaiyauvaa pikiada hanigiada yoketaama varirama kiada fai iya putuneema ngieeta putuaaravee. ");
INSERT INTO waj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yoosinna Siruaama vau nnauvo havarata roo vaidi yaakuuvaitana yuku saivai sainaidiri taaravooma ruputu kiooduu putuu mmayaayaivaara yaata utuatee. Ngia ivaara yaata utida kiaanoo: Iya gioonna kiaapu Yerusareema variaiya yaatarada maisamaisama variaayaveeda kiaannee? ");
INSERT INTO waj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na ngii giaa ngii miaunoo. Hama iya mminnamminnaa maisaiyauvo mmuakiaaya mminnamminnaa maisaiyauvaa yaataraivai. Fai ngia hama ngiingii mminnamminnaa maisaiyauvaa pikiada hanigiada yoketaama varirama kiada iya putuneema fai ngieeta putuaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kiaa kioo Yisuuva mmatayaa diaa mminnaa voovaudiri mmataama kioo gioonna kiaapuuya tunoo: Vaidi voovoono vuaina mmooriivaki nnaammuayaivaa roosiivaa utu kiaikio urikio too oro iiraivaara buainnonno taikio kuminaivai. ");
INSERT INTO waj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kuminaikio rikioo vaidi mmoorira haitatuuraivaa tinoo: Taanee. Taaravooma nuanu na numa aa nnaammuaya aavaki iiraivaara buainana tauko kuminainoo. Hanaa rakammua ree kagaari kiaanee. Mo aaniira ivo uruoo kuminayaa mmataivaa nnammariivaa varainnee? ");
INSERT INTO waj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","tikio rikioo mmoorira haitatuura vaidiivo inna sai tinoo: Nnoonna-o, mmuaa nuanuvai pikinai tee na mmataivaa hanuu kiee puara naaraivaa hakua ree ivaa oyaivaki yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yapa kino rikioo iiraivo vaino too ti yoketainaravai. Hama iiraivo vainai tee inna aikioo hanaa rakammua ree kagaari kiaanee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kati varira suai voovaki Yisuuva nuunaira nnauvaki vioo mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmioo varuduu ");
INSERT INTO waj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","gioonna voovoono mmagia maisaivo numa innaki varuduu yaakuuvaitana yuku saivai sainaidiri taaravooma nuanu ivo ari vookarau pinaa nniitaroovaa varooduu mmookaivo umaagauduu hama yopeema mmookaivaa radudoo safuuma nuauvoono ivaki variravai. ");
INSERT INTO waj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ivaki varuduu Yisuuva inna too tunoo: Gioonna-o, makee i nniitaraivo taikaivee, ");
INSERT INTO waj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","kiaa kioo innayaa ari yaakuuvaitana utuu saivaata mmookaivaa raduda kioo Anutuuqaara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tuduu rikioo nuunaira nnauvaara dira vaidiivo Yisuuva kati varira suaivaki gioonnaivaa tuqinnoovaara inna nnannateeravai. Inna nnannatooduu ivo gioonna kiaapuuya tunoo: Yaaku saivai karasaidiri mmuaa suaivaki nnaasu ta mmoori varaunnavai. Ii suai iyauvaki nnaasu nnikio vaidiivo ngii nniitaraiyauvaa tuqinnaanaravai. Sa kati varira suaivaki ngii nniitaraiyauvaara ngiatee, ");
INSERT INTO waj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","tuduu rikioo Yisuuva inna tunoo: Ngia huoobavainna unnakua nnaamuru tuanaayavee. Ngia mmuakiaaya kati varira suaivaki ngii puara nnauyauvaki vida puara burimakau togiiyauvaatama rakuasaa kiada vitada oro nnooriivaa mmiaavaivee. ");
INSERT INTO waj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aa gioonna aavo Aaparahaamaa oyaivakidiri diitai aavaa Sataango nniitareera maisaivaa yeena rau kiaivaa roosiivai inna mmikio yaakuuvaitana yuku saivai sainaidiri taaravooma nuanu taika kioo itaama varivai. Mo kati varira suaivaki na inna nniitaraivo yeena roosii rau kiaivaa na tino taikaanarannee? Vara hama na tino taikaanarannee? ");
INSERT INTO waj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","tuduu rikiada Yisuunna ari nnammutuaiya iva tuu kuaivaara iya mmamma maisauduu mmuakiaa gioonna kiaapuuya Yisuuva uu mmoori yoketaivaara sirigairavai. ");
INSERT INTO waj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yisuuva tunoo: Anutuuqo gioonna kiaapuuyara diraivo inna aaniivai roosiivainnee? Na dee mmatayaa diaa mminnaavaudiri mmataama kiee ngii giaa ngii minarannee? ");
INSERT INTO waj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Anutuuqo gioonna kiaapuuyara diraivo uru kiisakiata nnaammuaya uruuvaa roosiivaa nnutuuvo masateeraivaa roosiivai. Vaidi voovoono ii uru ivaa varoo ari mmooriivaki rututuooma kiaikio uruoo yatarivai diivai. Dikiai ngiaammaiya numa inna hammaraiyauvaki ngiisaiyauvaa heeka kiada vakiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yisuuva itaa kua kiaa kioo kava iya yaparainno tunoo: Dee mmatayaa diaa mminnaavaudiri na mmataama kiee Anutuuqo gioonna kiaapuuyara diraivaara ngii giaa ngii minarannee? ");
INSERT INTO waj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Anutuuqo gioonna kiaapuuyara diraivo puuqaira yeennaivaa roosiivai. Gioonna voovoono ii yeenna ivaa varoo paravuaa saaba taaravoomaivaki hanigiaanigieema kioo yapa kiaikio vainno eyommaavai puuqaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yisuuva itaa kua kiaa kioo vioo nnoonna yoosinnaiyauvakiaata kiisa yoosinnaiyauvakiaatama nuainno varioo mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiaa roo nuainnonno Yerusareema kuanee kiaa aataruuvau vuduu ");
INSERT INTO waj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","gioonna kiaapu voovoono inna yaparainno tunoo: Udaanga-o, Anutuuqo kiisa gioonna kiaapuuya nnaasu vitoo aataru yoketaivau yapaanarannee? tuduu rikioo iya tunoo: ");
INSERT INTO waj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Keegia kiisaivaki kuaaraivaara mmannammanna yaagueeqama iikiatee. Na ngii giaa ngii miaunoo. Kaayau gioonna kiaapuuya ivaki kuaaree kiaa kiada fai hama yopeema ivaki kuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nnau nakaaraivo diitoo sipuuvaa rau kinai ngia oro mmaanaivau dida vaida sipuuvau rida kiaara: Udaanga-o, sipuuvaa tiini hatuaanee, tikio fai ivo sai tinara: Ngia deepidiriida ngiaannee? Hama na ngii yoosinnaivaa tauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","tinai fai ngia sai kiaara: Mo ta i tasipama yeenna nnooriivaa nnaunnani a ti yoosinnaivaki nuainna mmayaayaivaa ti kiaa ti mmiannakuavee, ");
INSERT INTO waj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","tikio rikioo fai ivo ngii sai tinara: Ngia deepidiriida ngiaannee? Na ngii giaa ngii miaunoo. Hama na ngii yoosinnaivaa tauvaivee. Ngia maisa mmooriivaa iira nnaamuruyavee. Ngieera kuatee. Fai nnau nakaaraivo itaa kua tinaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yapooma fai nnaaru varuu vaidiiya Aaparahaamo Isaako Yakoopainna mmuakiaa forofetaiyaatama Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki varikio Anutuuqo ngii ooqoo tinai ngia mmaanai varida teekio ngii nnannateenai fai ngiingii avaiyauvaa hakutikio ngii ausaiyauvo mmuaarareenai rataaravai. ");
INSERT INTO waj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Suai raari raipidiri suai haatapaipidiri tooya sai tooya sainaidiri ngiaa gioonna kiaapuuya Anutuuqo iyara dira yoosinnaivaki varida yeenna nnaaravai. ");
INSERT INTO waj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Makee gioonna kiaapu vooya nnaagiai variaiya fai tauraa variaaravai. Gioonna kiaapu vooya makee tauraa variaiya fai nnaagiai variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tuduu mmuai suaivaki vaidi Farisai vooya numa Yisuunna tunoo: Herooto i ruputinai putinaraivaara rikiee aa yoosinna aavaa pikiee ai yaatu kuanee, ");
INSERT INTO waj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","tuduu rikioo Yisuuva iya sai tunoo: Oro vaidi avaikarai fai mmararaa roosiivaa kiaa mmida kiatee: Na makeennaata turaunnaata mmagia maisaiyauvaa titanai vikiai nniitaraiya tuqinnee dita fai na ni mmooriivaa iima taika kiaanaravaivee, kiatee. ");
INSERT INTO waj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ivo ni ruputinara tinainnaata na makeennaata turaunnaatama ditaata nene rikiau aataruuvau kuanaravaivee. Hama dee yoosinnavaki vaidiiya forofetaiya ruputuaavai. Yerusareema ivaki nnaasu iya ruputuaavai. Fai vo yoosinnavaki ruputikio hama yoketainaravai. Koonnainaravai. ");
INSERT INTO waj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Boo, gioonna kiaapu Yerusareemaiyaso, ngia forofetaiya ruputuaani putuaani gioonna kiaapu Anutuuqo ngiiisi titeeraiya ngia sikauyauvaadiri habati kiada ruputuaani putuaavai. Kakaraa kaanaivo ari nnaakaraiyauvaa rupi nuunama ari haayaivaadiri rummua apineema na airineetu ngii rupi niniisi nuunainee kiaukai ngia niiyara ooqoo kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Rikiaatee. Vaa ngii nuunaira nnau pinaivaa Anutuuqo pikiaikio mmanna nnauvai vainoo. Na ngii giaa ngii miaunoo. Fai ngia hama kava ni taaravai. Fai yapooma ngia niiyara kiaara: Udaangaivo titooduu tuuvo nninaraivaara Anutuuqo innara yoketaakiaivee, kiaa kiada fai ngia kava ni taaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kati varira suai voovaki Yisuuva vaidi Farisai kieeta voovai nnauvaki vioo yeennaivaa nnoo varuduu teeda gioonna kiaapuuya inna puru varida teeda vauduu ");
INSERT INTO waj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","vaidi voovoono inna yuku yaakuuvo yootoovo Yisuunna avuuvau variravai. ");
INSERT INTO waj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Varuduu too Yisuuva kua mmaanna kiaa mmira vaidiiyaata Farisaiyaatama yaparainno tunoo: Ti mmaanna tuu kua aataruuvo dataa kuainno tiinnee? Fai ta kati varira suaivaki vaidi nniitaraivaa tuqinnaarannee? Vara hama tuqinnaarannee? ");
INSERT INTO waj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","tuduu rikiada iya kua seemuaa variravai. Kua seemuaa varuduu Yisuuva vaidi yuku yaakuuvo yootoovaa vitoo tuqinnama kioo titooduu viravai. ");
INSERT INTO waj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Vuduu too Yisuuva iya tunoo: Fai ngiiikidiri vaidi voovoono kati varira suaivaki inna mmaapuuvonnee vara inna puara burimakauvo doofa nnooriivaki tuoo vino rikioo fai aikiooma ivo utu raririima kati naatauvau yapaanarannee? Vara too pikiaanarannee? Fai ivo utu raririima kati naatauvau yapaanaravee, ");
INSERT INTO waj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tuduu rikiada iya hama yopeema inna kuaivaa sai tiravai. ");
INSERT INTO waj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yisuuva yeenna nneera suaivaki gioonna kiaapu vooya ngiariiyara nnaasu yaata utida mmaata yoketaiyauvunu varuduu too mmatayaa diaa mminnaa voovaudiri mmataama kioo mmuakiaaya tunoo: ");
INSERT INTO waj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Gioonna kiaapu voovoono yaapeeri yeenna nneera suaivaki aiyara aayanna tinai sa oro mmaata yoketaivau tauraa varianee. Buusa nakaaraivo vaidi voovai nnutuuvo pinaavai vaivaara aayanna raanara iinainnaata a tauraa oro mmaata yoketaivau varinarainnoo. ");
INSERT INTO waj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Fai a varino buusa nakaaraivo numa i tinara: Tiee vino rikioo vaidi nnutuuvo pinaavai vaivo aavau variaivee, tinai fai a tiee mmee nnaagiai mmaataivau oto varino i mmamma maisainaravai. ");
INSERT INTO waj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Buusa nakaaraivo aiyara aayanna tinai rikiee oro nnaagiai mmaataivau varino rikioo fai buusa nakaaraivo numa i too tinara: Ni vaidi-o, diitee numa aa mmaata yoketaa aavau varianee, tinai rikiada fai mmuakiaa gioonna kiaapu ivaki variaiya aiyara yoketaavee kiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gioonna kiaapu voovoono ariiyara mannaka tiivaa fai Anutuuqo inna vitoo aduoo yapaanaravai. Fai gioonna kiaapu voovoono tirooma varioo hama ari nnutuuvaa aruoo yapaivaa Anutuuqo vitoo aruoo yapaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kiaa kioo vaidiivo ari nnauvakira inna maavee tuuvaa tunoo: Fai a buusaivaa iinna sa ai seenaiyaraata ai kata vayaiyaraatama ai oyaiyaraata i seena hoona suvuakuaiyaraatama aayanna kianee. Fai a iyara aayanna tinai i yeennaiyauvaa nnaa kiada irisaiyauvaa i mmikiai fai a ivaudiri irisaivaa varaanarakuavee. ");
INSERT INTO waj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Fai a buusaivaa iinna mmanna haipuuyaraata vaidi yuku yaaku maisakiaiyaraatama mmudannarakiaiyaraata avu huruutakiaiyaraatama aayanna tinai numa nnaatee. ");
INSERT INTO waj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iya hama yopeema irisaiyauvaa i mmiaaraivaara fai Anutuuqo aiyara yoketainaravai. Yapooma gioonna kiaapu ausa hanigieeraiya putuaiyauvakidiri diitaara suaivaki Anutuuqo irisai yoketaivaa i mminaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tuduu rikioo vaidi voovoono Yisuunna tasipama yeenna nnoovo inna kuaivaa rikioo inna tunoo: Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki fai gioonna kiaapu voovoono yeenna nnaanaraivaara Anutuuqo kaayauma innara yoketainaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","tuduu rikioo Yisuuva inna sai tunoo: Vo suai vaidi voovoono buusa pinaivaa iima kioo gioonna kiaapu kaayauyara aayanna tiivai. ");
INSERT INTO waj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aayanna tikio rikioo buusa nnaara suaivo vainima vaikio rikioo vaa tauraa aayanna tiiyara ivo ari mmoori vareera ngiaammuauvaa titaikio oro tinoo: Ha ngiaannee? Vaa ta buusaivaa teerama kiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","tikiai rikiada iya mmuaavai mmuaavai mmuaakaraama hama iya kuataikiai ngiari vo mmooriiyauvunudiri yaadata rummua kiada kiaavai. Tauraa tiivoono mmoori vareera ngiaammuauvaa tinoo: Boo, na mmata voovai yookaama kiauvaa taanara kuanaravee. Na kiau kua aavaa a kava viee inna kiaa mmianee. ");
INSERT INTO waj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Itaa kua tikio rikioo voovoono tinoo: Na puara burimakau yaakuuvaitana sikaunnaadiri yookaama kiee varauyauvaa taanara kuanaravee. Na kiau kua aavaa a kava viee inna kiaa mmianee. ");
INSERT INTO waj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Itaa kua tikio rikioo voovoono tinoo: Na ikiataa nnaata varauvaara yaata utuee hama na yopeema kuanaravee, ");
INSERT INTO waj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","tikio rikioo mmoori vareera ngiaammuauvo numa ari nnoonnaivaa iya itaa kua kiaa kuaiyauvaa inna kiaa mmiivai. Kiaa mmikio rikiaikio kaayauma inna nnannataikio ari ngiaammuauvaa kiaa mmioo tinoo: Akiairaama viee yoosinna aataruuyauvaki buaama ree tee gioonna kiaapu mmanna haipuuyaata yuku yaaku maisakiaiyaatama avu huruutakiaiyaata mmudannarakiaiyaatama vitee ngianee, ");
INSERT INTO waj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","tikio rikioo oro iya kiaa sunoo numa ari nnoonnaivaa tinoo: Nnoonna-o, vaa a kianna kuaivaa na iima kiauko hama nnauvo suvuainoo, ");
INSERT INTO waj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tikio rikioo ari nnoonnaivo inna sai tinoo: A kava vara ranee viee aataru nnoonnaiyauvaki buaama ree tee kiisaiyauvakiaatama buaama ree teenai gioonna kiaapu ivaki variaiya i teekiai yaagueeqama tinai ngiatee. ");
INSERT INTO waj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ni nnauvo suvuakuaiveera tinai ngiatee. Na ngii giaa ngii miaunoo. Tauraa na aayanna kiauya hama numa ni buusaivaa nnaaravee. Nnoonnaivo itaa kua tiivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tuduu kaayau gioonna kiaapuuya Yisuunna tasipama nuauduu iva hanigia iya too tunoo: ");
INSERT INTO waj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Fai gioonna kiaapu voovoono niisi ngioo ari kaano koovaitanaara pinaama mmuduuya ruoo ari nnaata nnaakaraiyara pinaama mmuduuya ruoo ari kata vayaa nnunna nnayaiyara pinaama mmuduuya ruoo ari variraivaara pinaama mmuduuya ruaivo fai hama ni nnaagiai nuaira gioonna kiaapuvai varinaravee. ");
INSERT INTO waj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Gioonna kiaapu voovoono gioonna kiaapuuya ni nnaagiai nuaivaara inna ruputikio na putuauneema ivo putinaraivaara hama ee-oo tioo ni nnaagiai nniivo inna hama ni nnaagiai nuairanavai. ");
INSERT INTO waj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Fai ngiiikidiri dee vaidi voovoono nnau hokobaivaa heekaanaree tioo tauraa mminnaiyauvaa yookainara sikauyauvaa yaarummua teeno aikiooma vaino fai nnauvaa heeka taika kiaanaraivaara yaata utiinnee? Fai ivo itainaravai. Fai hama aikiooma sikauyauvo vaino fai hama yopeema heeka taikeerainno ruukama pikiaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Fai hama yaarummua teerairainno ivo tuunna kuabaiyauvaa hara kioo teeno hama sikaunnaataino rikioo fai pikianai rikiada mmuakiaa gioonna kiaapuuya nnauvaa teeda innara raikiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Innara raida fai kiaara: Aa nnau aavaa heekai vaidiivo hama yaagueeqama heeka taikeera ruukama pikiaivaivee, kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Fai vaidi kieeta voovoono ari vo kieeta vaidiivaata rapinaree kiaa kioo tauraa varioo ari rapira vaidiiya yaarummua teeno innasi kaayau (10,000) varikio rikioo vuai kieetaivaasi kaayakaayau (20,000) varikio rikioo ivaara yaata utuoo tinara: Fai ta titi yaatara titi yaatara kiaarannee? Vara hama yopeema titi yaatara titi yaataraarannee? tinaravai. ");
INSERT INTO waj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Fai hama yopeema yaataraataama vaino kieeta vuaivo ngieera homo varino rikioo vaidi kua varada nuairaiya titanai vida inna kiaara: Nnikiai fai ta hama rapiraida kati mmuaavau variaaravee, kiaaravee. ");
INSERT INTO waj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yisuuva ii kua ivaa kiaa kioo tunoo: Itaama vaino fai gioonna kiaapu voovoono ngiiikidiri ariisi vai mminnaa mmuakiaayauvai hama pikioo fai ivo hama ni nnaagiai nuaira gioonna kiaapuvai varinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yorokuuvo inna yoketaa mminnaavai. Yorokuuvo vainnonno maisainai fai ngia aaniivaadiri iikio kava yoketainarannee? Hama yopeemavee. ");
INSERT INTO waj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Maisai yorokuuvaa fai mmooriivaki mmataivaa tasipama yapa kikio rikioo fai koonnainaravai. Fai hama mmataivo yoketainaravai. Fai maisai yorokuuvaa puara naaraivaa tasipama yeenna mmaara mmataivaki yapa kikio rikioo hama yoketainaravai. Fai kati kagaari kiaaravai. Gioonna kiaapu voovoono arinaima kua rikiaivoono ii kua ivaa arinaima rikiaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tuduu vo suai voovaki sikau takiisa vareera vaidi maisaiyaata mmaanna tuu kuaivaa hatokeera maisa gioonna kiaapuuyaatama Yisuunna kuaivaa rikiaaree kiaa innasi nuunaida variravai. ");
INSERT INTO waj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nuunaida varuduu vaidi Farisaiyaata vaidi kua mmaanna kiaa mmiraiyaatama ausa pirisauduu ngiariita ngiariita kua tida tunoo: Mo aa vaidi aavo mmaanna tuu kuaivaa hatokeera gioonna kiaapu maisaiyaatama kua tioo varioo iya tasipama yeenna nnainoo, ");
INSERT INTO waj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","tuuvaara Yisuuva mmatayaa diaa mminnaivaudiri mmataama kioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ngiiikidiri dee vaidivoono aa na tinara kua aavaa hama iinnee? Vaidi voovoono yaaku sai vaidivai yuku yaaku taika kioo (100) puara sipisiipaiyauvaa virikio voovai iyakidiri raubiriikio saiyauvaa (99) koo mmuyai gaangaivau pikioo mmuaavai raubiriivaara buainnonno taikio ");
INSERT INTO waj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","inna too vaikio too inna mmuduuyaivo yoketaikio vita ari vaaveevaki hara varoo ");
INSERT INTO waj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ari nnauki vioo ari seenaiyaraata ari mmuaa yoosinnaivaki variaiyaraatama aayanna tioo tinoo: Ni puara sipisiipa vaa raubiriima kiaivaa na tee vitauvaara nnikiai ngieeta neetama sirigakiaaravee, tiivai. ");
INSERT INTO waj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na ngii giaa ngii miaunoo. Fai gioonna kiaapu vooya (99) variaiya ngiariiyara kiaanoo: Ta yoketaaya variaunnanoo. Ta dee mminnamminnaa maisaiyauvaara ausa hanigiaarannee? kiaa kiada variaiyara ngiau aapu variaiya fai hama iyara pinaama sirigakiaaravai. Gioonna kiaapu voovoono ari mminnamminnaa maisaiyauvaa fai pikioo hanigioo yoketaama varinai iya puara sipisiipaivaara sirigakiaaneema fai ngiau aapu variaiya pinaama innara sirigakiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Vo kuavaara yaata utuatee. Gioonna voovoono sikau yaakuuvaitana utikio rikioo voovai tioo vioo raubiriikio rikioo ivo aaniivai iinnee? Ivo toobaivaa subi varoo nnauvaa rupiara roo tuqinnama buainnonno taikio ");
INSERT INTO waj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","inna too vaikio too varoo ari seenaiyaraata ari mmuaa yoosinnaiyaraatama aayanna tioo tinoo: Na ni sikau raubiriima kiauvaa vaa na tauvaara nnikiai ngieeta neetama sirigakiaaravee, tiivaivee. ");
INSERT INTO waj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na ngii giaa ngii miaunoo. Iya sikauvaara sirigakiaaneema gioonna kiaapu kaayau mminnamminnaa maisa suvuai voovoono ari mminnamminnaa maisaiyauvaa pikioo hanigioo yoketaama variivaara Anutuuqaa aangeraiya fai innara pinaama sirigakiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yisuuva itaa kua kiaa kioo vaidi mmatayaa diaa voovaudiri mmataama kioo tunoo: Vaidi voovoono ari mmaapuuvaitanootama varida ");
INSERT INTO waj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ngamiisaivoono ari koonna tinoo: Napoo-o, ai mminnamminnaa saiyauvaa niini yapa kiaannaiyauvaa makee ni mianee, tikio rikioo ari koova ari mminnamminnaa saiyauvai ngarunnani yapa kiaikio vaikio rikioo saiyauvai ngamiisaivaani yapa kiaiyauvaa inna mmiivai. ");
INSERT INTO waj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mmikio varaikio kiisa suaivo taika kiaikio ari mminnamminnaidaa ari koova inna mmiiyauvaa rupi nuunama kioo varoo ari koonna nnauvaa pikioo ari vo yoosinna ngieera vaivakira vioo vioo oro ivaki hara kioo varivai. Hara kioo varioo sabisaabi ari isaraa roo nuairaivaara ari sikauyauvaa sabi kagaari kagaariima roo nuaikiokio ");
INSERT INTO waj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","sikauyauvo eeyaayauvai taika kiaikio rikioo yoosinna ivaki mmuakiaa vuayeennavai aasannaikio rikioo ngiaammuauvo hama mminnaataikio kati varivai. ");
INSERT INTO waj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kati varioonnonno rikioo oro ivaki varii vaidiivaasi vioo inna tasipama varikio rikioo ivo ari mmooriivakira inna titaikio oro inna puaraiya yeenna mminara kuaivai. ");
INSERT INTO waj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Oro yeenna nnabaiyauvaa puaraiya mmioo rikiaikio inna nnaataikio rikioo hama vaidi voovoono yeennaivaa inna mmikio rikioo ");
INSERT INTO waj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","varioonnonno rikiaikio inna yaata utiraivo kooyaa vaikio rikioo tinoo: Ni napoonna mmoori varaa ngiaammuauya kaayau yeennaiyauvo iya suvuai kioo vaikiai vooyauvai hama nnaavo kati vaikiainnaata na aavaki variauko ni yeenna raikio ni putuatainoo. ");
INSERT INTO waj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Fai na diitee ni napoonnasi viee tinara: Napoo-o, Anutuuqaa avuuvaunnaata i avuuvaunnaatama koonnama na variaunoo. ");
INSERT INTO waj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na maisama variauvaara sa niiyara ni maapuvaivee kianee. Kati tee pikianai na i mmoori vareera ngiaammuauvai roosiima varinaravee, tinaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","kiaa kioo diitoo ari koonnasi nniivai. Ngioo taikio ari koova ngieeradiri inna taikio rikioo ari ausaivo innara boo tikio seenoo numa varau tu kioo vainno inna mmootaivai. ");
INSERT INTO waj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Inna mmootaikio rikioo ari mmaapuuvo tinoo: Napoo-o, Anutuuqaa avuuvaunnaata i avuuvaunnaatama koonnama na variaunoo. Na maisama variauvaara sa niiyara ni maapuvaivee kianee, ");
INSERT INTO waj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","tikio rikioo ari koova ari mmoori vareera ngiaammuauya aayanna roo tinoo: Akiairainai yaapa yoketaa oyaivaa varada inna nnuunaivaki reemma kiaatee. Mmakaranna yoketaivaata varada inna yaaku oopuuvau uyuatee. Yuku nnabaivaitanaata varada inna yukuuvaitanau uyuatee. ");
INSERT INTO waj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Puara burimakau nnaakara kaayau nnammari raivaa oro varada numa ruputu kiada huda kikiai ta innara buusaivaa iima kiada nneeda sirigaida variaaravee. ");
INSERT INTO waj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ni maapuuvo vaa putinoo kiauvo aavaa numa varinoo. Iva vaa raubiriinoo kiauvo aanna makee vaa ni too vainoo, tikiai rikiada sirigaida variaavai. ");
INSERT INTO waj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Sirigaida variaavo ari mmaapu ngaruva mmooriivakidiri vara ranoo numa nnauvaa vainima ngioo varioo rikiaikio nooma muaaru akuaivoota kuaru raa akuaivootama inna yaataivaki kuaikio rikioo ");
INSERT INTO waj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","numa mmoori vareera ngiaammuau voovai yapara ruoo tinoo: Iya aaniivaida iikiaannee? ");
INSERT INTO waj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","tikio rikioo tinoo: I kataivo vaa vara ranoo nniivaivee. Ivo hama raubiriirama kioo kati inna mmammaivo saunaavai vaikio hama vookaravaakaraira variivaara i koova puara burimakau nnaakara nnammari rai voovai ruputivaivee, ");
INSERT INTO waj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tikio rikioo ngaruva kaayauma inna nnannataikio hama nnauvaki inna kuataikio rikioo ooqoo tiivai. Ooqoo tikio rikioo ari koova mmaanai tioo vioo yaagueeqama inna tinoo: Ha ngiannannee? ");
INSERT INTO waj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","tikio rikioo ngaruva ari koonna tinoo: Rikiaanee. Na kaayau nuanu i mmooriivaa varee hama na vo suai i avaivaa hatokauvai. Na itaa kiaukakai a hama ni seenaiyaatama isaraateera irisai maisa puara memee nnaakara voovai ni miannavaivee. ");
INSERT INTO waj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mo aa i mmaapu ngamiisa aavo mmuakiaa i mminnaiyauvaa varoo sabi nuaira gioonnaiyara kagaari kagaariima roo nuainnonno nnikiainna a puara burimakau nnaakara kaayau nnammari raivaa ruputuannanoo, ");
INSERT INTO waj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","tikio rikioo ari koova inna sai tinoo: Ni maapu-o, a tupatupaa ni tasipama variannani na mmuakiaa mminnaa niisi vaiyauvaa iini yapauvai. ");
INSERT INTO waj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I kataivo vaa putinoo kiauvo aavaa numa varinoo. Ivo vaa raubiriinoo kiauvo aanna makee vaa ni too vainoo. Ivaara aikiooma ta buusaivaa iida sirigaida variaunnanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yisuuva itaa kua kiaa kioo vo kuavai ari nnaagiai nuaira gioonna kiaapuuya kiaa mmioo tunoo: Vaidi voovoono kaayau hoona suvuaivo ari mmoori vareera ngiaammuau voovai inna mminnaiyauvaa haitatuukianeera kiaa kioo mmataama kiaikio rikioo haitatuunnonno inna mminnaiyauvaa sabi kagaari kiaikiai rikiada gioonna kiaapuuya nakaaraivaa kiaa mmiaavai. ");
INSERT INTO waj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kiaa mmiaavo rikioo inna mminnaiyauvaa haitatuuraivaara maavee tikio innasi nnikio too inna tinoo: Gioonna kiaapuuya kaayauma iiyara kiaivaara na rikiauvai. Mo na rikiauvaara a dataa kuainna kiannannee? A ni mminnaiyauvaara haitatuukianna aataruuvaa safuuma yaarummua kiee tuqinnama ni giaa ni mianee. Fai hama a keenaa ni mminnaiyauvaara haitatuunaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","tikio rikioo ivo ariiyara yaata utuoo ari yaataivaki tinoo: Boo, fai kiisa suai ivo ni mmooriivaa ravisi voovai mminaravaivee. Fai itainai na dee mmoorivai varaanarannee? Hama na yopeema yaagueeqaina mmataivaa hanuu kiee mmooriivaa varaanaravai. Fai na kati variee yeennara ngiaaru tino ni mmamma maisainaravai. ");
INSERT INTO waj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ai, vaa na rikiaunoo. Fai na mmoori iinaraivo vaa ni yaatana vainoo. Fai mmoori nakaaraivoono ni mmooriivaa ravisi voovai mminai fai na ni yaata utiraivaugiataama iinai fai gioonna kiaapuuya niiyara yoketaida ngiari nnauyauvakira niiyara maavee kiaaravee. ");
INSERT INTO waj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ivo itaa kua kiaa kioo mmuakiaa gioonna kiaapuuya mmoori nakaaraivaa irisai mmiaaraiyara tikiai ngiaavo mmuaavai mmuaavai innaata kuaivaa kiaavo tauraanaivaa tinoo: A fai naanama mmoori nakaaraivaa irisai mminarannee? ");
INSERT INTO waj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","tikio rikioo inna sai tinoo: Fai na nnammari toori kaayau (100) inna mminaravaivee, tikio rikioo tinoo: Aavau variee yanaivau saivai (50) nnaasu raa kiee saivai (50) vakiaa varaanee. ");
INSERT INTO waj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ivo itaa kua kiaa vaidi voovai tinoo: A fai naanama mmoori nakaaraivaa irisai mminarannee? tikio rikioo tinoo: Fai na yeenna utuaivaa kaayau (100) inna mminaravaivee, tikio rikioo tinoo: Inna aikioo, yanaivau vooyauvai (80) raa kiee vooyauvai vakiaa varaanee. ");
INSERT INTO waj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ivo itaama iinno tinni ruaivaa roosiima iivaara mmoori nakaaraivo inna tinoo: I tinniivo yoketainoo, tiivai. Gioonna kiaapu mmatayaa diaa mmooriivaara ngiariiyara ngiariiyara mmoori iikiaiya vaidi tinni ruaiya roosiima iikiaavai. Iya itaama iikiaivaara Anutuuqaa aataruuvau variaiya yaataraavaivee, tiivaivee. ");
INSERT INTO waj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yisuuva itaa kua kiaa kioo ivaara iya kiaa mmioo tunoo: Na ngii giaa ngii miaunoo. Mmatayaa diaa mminnaa sikauvaadiri yoketaa aataruuvaa ngii seenaiyara iikiai fai ngiiiyara yoketaayavee kiaaravai. Fai itaikiokio sikauvo taikeera suaivaki ivo tupatupaa variraivoono ngiiiyara yoketainai ngia yoketaama tupatupaa varira yoosinnaivaki variaaravai. ");
INSERT INTO waj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Gioonna kiaapu voovoono kiisa mmooriivaa hama pikieerama kioo mmannammanna yaagueeqama safuuma iinno yapooma pinaa mmooriivaatama mmuaikaraama itaama iinaravai. Gioonna kiaapu voovoono kiisa mmooriivaa koonnama iinno fai yapooma iva pinaa mmooriivaatama koonnama iinaravai. ");
INSERT INTO waj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Fai hama ngia mmatayaa diaa sikauvaara tuqinnama haitatuukio Anutuuqo ngiau aapu vaira mminnaa tuanaivaa dataama kioo ngii minarannee? Hama yopeema ngii minaravee. ");
INSERT INTO waj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Fai ngia hama Anutuuqaa mminnaa mmatayaa vaiyauvaara tuqinnama haitatuukio ivo ngii mminnaa tuanaiyauvaa dataama kioo ngii minarannee? Fai hama yopeema ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Hama mmoori vareera ngiaammuau voovoono taara vaidivaitanaani mmoori varaivai. Fai itainnonno vuai vaidiivaara nnannatoo vuai vaidiivaara mmuduuya rinaravai. Fai itainnonno vuaivaasi vioo yaagueeqama mmooriivaa iinno vuaivaara nniki rakainno kiisama mmooriivaa iinaravai. Ivaa roosiima hama ngia Anutuuqaa mmooriivaatama sikau vareera mmooriivaatama mmuaavaugiataama iikiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tuduu Farisai vaidiiya sikauvaara kaayauma mmuduuya ruuya Yisuuva itaa kua tuu kuaivaa rikiada innara raida varuduu ");
INSERT INTO waj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yisuuva iya tunoo: Gioonna kiaapuuya ngiiiyara safuuma variraiyavee kiateeraivaara ngia iya avuuyauvunu mmoori yoketaivaa iikiaanoo. Anutuuqo vaa ngii aakiaiyauvaki tuqinnama taivaivee. Gioonna kiaapuuya mmatayaa diaa mminnaiyauvaa teeda iyauvaara yaata utida kiaanoo: Yoketaa mminnaayauvaivee, kiaivaara Anutuuqo too tinoo: Kumina mminnaayauvaivee, tiivai. ");
INSERT INTO waj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Anutuuqaa mmaanna tuu kuaivaata forofetaiya tuu kuaivaatama gioonna kiaapuuya ivaaraatama puridada tuma Yuvuaano nnoori apira vaidiivaa suaivaki taikeeravai. Ii suai ivakidiri Anutuuqo gioonna kiaapuuyara dira mmayaaya yoketaivo kooyaa vaikiai gioonna kiaapuuya ivaa rikiada ivaki kuaaree kiaa kiada ivaara yaagueeqararama kiada iikiaavai. ");
INSERT INTO waj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Na ivaara ngii giaa ngii miaunoo. Ngiau mmataivo taikaanaraivo inna mmuaararainoo. Anutuuqaa kua mmaannaivaki vai kua vookiata taikaanaraivo kaayauma mmuaararainoo. ");
INSERT INTO waj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Vaidi voovoono ari nnaata tauraanaivaara ooqoo kiaa kioo karaasa voovai varaikio mmuara vareera aataruuvo innaki vainoo. Ivoono ari nnaata tauraanaivaa pikiaikio kati varikio vaidi voovoono inna varaikio mmuara vareera aataruuvo innakiaatama vainoo. ");
INSERT INTO waj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Vaidi voovoono kaayau hoona suvuaivoono hara kioo varioo buruqa haboonna kuaiyauvaata ari vookarai poosa kuaiyauvaatama uyu rau kioo mmuakiaa suai yeenna yoketaiyauvaa nnaivai. ");
INSERT INTO waj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Vaidi voovai mmanna haipuuvaa nnutuuvo Rasaruuso kaayau uudaudaivo inna mmammaivau suvuai kiaivaa vaidiiya makemakee inna vitada numa vaidi hoona suvuaivaa nnauvaa sipu oyaivaki yapa kiaavo ");
INSERT INTO waj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","hara kioo varioo vaidi hoona suvuaivo yeenna nnaikio tuoo kuai yeenna pupunuuyauvaa nnaanaree kiaa varivai. Ivo ivaki maisama varikiai rikiada faiya numa inna uudaiyauvaa boosi nnaavai. ");
INSERT INTO waj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Itaama iikiaavo ivo varioonnonno nnaagiai putikiai rikiada aangeraiya tuma inna vitada yoosinna yoketaivaki Aaparahaamo variivaki yapa kiaavo varivai. Varikio nnaagiai vaidi hoona suvuaivo putikiai vaidiiya inna nnabaivaa varada hau kiaavo ");
INSERT INTO waj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","yoosinna maisaivaa nnutuuvo Hairiisa ivaki hara kioo varikio inna mmammaivo kaayauma nniitaraikio varioo rooru taikio ngieera Aaparahaamo varikio Rasaruuso inna tasipama varikio too ");
INSERT INTO waj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","aayanna roo tinoo: Napoo-o, Aaparahaamo, niiyara boo kianee. Rasaruusaa titano ari yaaku oopuuvaa nnooriivakidiri rabuuma kioo ni mmaakiriivau harano adakiaivee. Na ikia aakiaivaki variauko ni mmammaivo kaayauma ni niitaraikiai na vuu vuu kai kai tiee variaunoo, ");
INSERT INTO waj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","tikio rikioo Aaparahaamo tinoo: Ni maapu-o, yaata utuanee. Nnaaru eenoo mmatayaa varuu suaivaki kaayau mminnamminnaa yoketaiyauvo i suvuairavai. Ii suai ivaki Rasaruuso maisama variravai. Aanna makee ivo aavaki yoketaama varikiai a maisama variannanoo. ");
INSERT INTO waj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Vo kuavai rikiaanee. Aavaki variaiya hama yopeema ngiiisi vikiai ivaki variaiya hama yopeema aapi ngiaaraivaara Anutuuqo oogai pinaivaa ti tammaivaki iima kiaikio vainoo, ");
INSERT INTO waj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","tikio rikioo vaidi hoona suvuaivo tinoo: Napoo-o, na vo kuavai yaagueeqama i kiaa i mmiaunoo. Rasaruusaa titano vioo ");
INSERT INTO waj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ni napoonna nnauvaki ni gata vayaa yaaku saivai variaiya kiaa mmioo kiaivee. Iya aa yoosinna nniitarai aavaki ngiaarainnoo, ");
INSERT INTO waj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","tikio rikioo Aaparahaamo tinoo: Nnaaru Musiivaata forofetaiyaatama tuu kua fafaaraivo vainoo. Kii iya ii kua iyauvaa yaarida rikiaatee, ");
INSERT INTO waj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tikio rikioo ivo inna sai tinoo: Napoo-o, Aaparahaamo, fai iya hama yaarida tuqinnama rikiaaravai. Fai vaidi putii voovoono diitoo iyasi vioo iya kiaa mminai fai iya hanigiada tuqinnama variaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","tikio rikioo Aaparahaamo inna sai tinoo: Iya Musiivaata forofetaiyaatama tuu kuaiyauvaa hama rikiaiya fai vaidi putuoo kava diitaivo tii kuaivaatama hama rikiada hanigiaaravaivee, tiivaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yisuuva ari nnaagiai nuairaiya tunoo: Gioonna kiaapuuya vaa ausa hanigia kiada hama yaagueeqama variaiyasi iinno taanaraivo iyasi nninai haruruaaraivo vaivai. Fai vaidi voovoono iya iinno taanaree kiaa iinai iya harurikio rikioo ii vaidi ivo irisai maisaivaa fai varaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Fai tauraa vaidi vooya inna vitada sikau pinaivaa varada dutuyu kiada inna nnuunaivaki haru kiada nnoori haruunga pinaivaki kagaari kikio nnoori aakiaivaki mmeepi vioo taika kino hama ivo aa nnaakara kiisa aaya roosii gioonna kiaapu voovai iinno taanaraivootainaravai. Fai hama ivo iinno teera aataruuvootaino inna yoketaavai. ");
INSERT INTO waj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ngiengieenoo ngiingii variraivaara tuqinnama yaata utuatee. Ngii seena voovoono mminnamminnaa maisaiyauvaa varanai ivaara inna kiatee. Tikio ivo ari mminnamminnaa maisaiyauvaara inna ausaivo hanigiano ivaa pikianai ngii ausa mmuduuyaiyauvaa inna mmida sa kava ivaara yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Fai ivo mmuaa suaivaki yaaku saivai sainaidiri taaraneetu mminnamminnaa maisaiyauvaa ngiiiyara iinno mmuakiaa suaivaa ivo hanigioo ngii tinara: Boo, neenoo iikiauvaivee, tinai ngii ausa mmuduuyaiyauvaa inna mmida sa kava ivaara yaata utuatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tuduu rikiada Udaanga Yisuu Kirisiinna kua varada nuaira vaidiiya inna tunoo: A ti iinai teeda ta aiyara pinaama yaagueeqaida kutaavaivee kiaa kiada fai hama ta muaraagakiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","tuduu rikioo Yisuuva iya sai tunoo: Kiisa uruuvaa nnutuuvo masateera uruuvaa roosiima fai ngia kiisama niiyara kutaavaivee kiaa kiada aa nnaammuaya aavaa kiaara: Ai mmaara rarukua ree oro nnoori haruungaivaki diee vainna uruanee, tikio rikioo fai nnaammuayaivo ari mmaara rarukua roo oro ivaki dioo vainno urinaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Fai ngiiikidiri vaidi voovoono ari mmoori vareera ngiaammuauvaa titano oro inna mmooriivaki varoonnonno oro inna puara sipisiipaiyauvaa haitatuunnonno yapooma mmooriivakidiri pikioo numa varino fai ivo inna tinara: Kammannai numa variee yeenna nnaanee, tinarannee? ");
INSERT INTO waj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hama ivo itaa kua tinaravai. Fai ivo tinara: Ni yeennaivaa teerama kiee ai buruqa karaasaivaa uyu supugiaa kiee numa ni yeennaivaata ni nnooriivaatama ni minai na nnaa taika kinai oro ai yeennaivaata nnooriivaatama nnaanee, tinaravee. ");
INSERT INTO waj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mmoori vareera ngiaammuauvo ivo inna tii kuaivaa iinno hama nakaaraivo inna mannaka tinaraivaara iivai. Vaa ivo kati ari ii mmooriivaa varaivai. ");
INSERT INTO waj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Fai ngia mmuaikaraama iikiaaravai. Fai yapooma na ngii minara mmooriivaa ngia iima taika kiada kiatee: Ta kati inna mmoori vareera ngiaammuauyavee. Vaa ta iikiaunna mmooriivaa kati iikiaunnavaivee, kiatee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yisuuva yoosinna Yerusareema kuanaree kiaa kioo mmata Samariaa sainai vauduu mmata Karirayaa sainai vauduu aataru vuutaidaadiri vioo vioo ");
INSERT INTO waj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","yoosinna kiisa voonataa kuanaree kiaa iinno tooduu vaidi yaakuuvaitana buunna hooya mmamma roosuuya innasi nniravai. Numa ngieeradiri dida vaida ");
INSERT INTO waj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aayanna reeda tunoo: Nnoonna vaidi Yisuu-o, tiiyara boo kianee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tuduu rikioo Yisuuva iya too tunoo: Oro Anutuuqaara puara kati hudeera vaidiiya ngii mmammaiyauvaa vitaakiatee, tuduu rikiada iya iyasi kuaaree kiaa uuvaata rikiooduu iya mmammaiyauvo yoketairavai. ");
INSERT INTO waj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yoketauduu vaidi voovoono ari mmammaivaa tooduu yoketauduu rikioo hanigia puaisakama aayanna tioo Anutuuqaara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kua yoketaivaa kiaa roo ngioo varoo Yisuunna yuku oyaivaki vainno innara yoketaavaivee tiravai. Ii vaidi ivo Samariaa vaidivai. ");
INSERT INTO waj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yisuuva inna kuaivaa rikioo mmuakiaaya tunoo: Vaidi yaakuuvaitana mmammaiyauvo yoketainoo. Vaidi yaaku saivai sainaidiri taarama taarama deepiida kuaannee? ");
INSERT INTO waj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iya hama kava vara ranada nnida Anutuuqaara kua yoketaivaa kiaavai. Aa voopinnaa vaidi aavoono nnaasu numa Anutuuqaara kua yoketaivaa tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","kiaa kioo ari voopinnaa vaidiivaa tunoo: Diitee kuanee. A niiyara kiannanoo: Aikiooma ni tuqinnaanaravaivee, kiannaivaarainna a yoketaama hara kiee variannanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tuduu vaidi Farisai vooya numa Yisuunna yaparaida tunoo: Anutuuqo gioonna kiaapuuyara diraivo daira suai nninarannee? tuduu rikioo ivo iya sai tunoo: Anutuuqo gioonna kiaapuuyara diraivo nninaraivaara ngia hama vo mminnaavai teeda kiaara: Inna Anutuuqo tiiyara diraivoonno kooyaa nninoo, kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Anutuuqo gioonna kiaapuuyara diraivo ngii tasipama vaivaara hama vaidi voovoono tinara: Taatee. Aqaavau vainoo. Iqiivau vainoo, tinaravee. ");
INSERT INTO waj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yisuuva itaa kua kiaa kioo ari nnaagiai nuairaiya tunoo: Suai voovai nninai Na Vaidiivaa Mmaapuuvo yoketaama ngiiiyara dira suaivaa ngii taatainai fai hama ngia taaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ii suai ivaki fai gioonna kiaapu vooya ngii kiaara: Iqiivaki varinoo, tikiai teeda gioonna kiaapu vooya fai ngii kiaara: Aqaavau varinoo, tikiai sa ivaa taara iya nnaagiai kuatee. ");
INSERT INTO waj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Fai ngiauvaudiri saneetuuvo akiairaama utikio too mmeekiaivo mmuakiaa ngiauvai ruvuaahaineema Na Vaidiivaa Mmaapuuvo tiinara suaivaki fai itaama mmuaikaraama tiinaravai. ");
INSERT INTO waj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Fai na tauraa kaayau mmamma nniitareeraivaa varanai aanna makee variaa gioonna kiaapu aaya ni ooqoo kiaaravee. ");
INSERT INTO waj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Na Vaidiivaa Mmaapuuvo kava tiinara suaivo Nuvuaava varuu suaivaa roosiima vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nuvuaava varuu suaivaki gioonna kiaapuuya yeenna nneeda nnoori nneeda nnaata vaatiivaa vareeraivaara yaata utu kiada vaidada Nuvuaava nnooriyaa nuaira nnauvaki vuu suaivaki iya homo itaududuu nnooriivo mmataivaa rapodaa taika kioo gioonna kiaapuuya raputu taika kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Vaidi Rooto varuu suaivaki mmuaikaraama gioonna kiaapuuya yeenna nneeda nnoori nneeda sikauyauvaadiri mminnaiyauvaa yookaida varida ngiari mminnaa vooyauvai varada vooya mmida irisai sikauyauvaa varada ngiari mmooriiyauvaki hauyauvaa utida varida ngiari nnauyauvaa heekada varida variravai. ");
INSERT INTO waj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Varududuu Rooto ari yoosinna Sutuuma pikioo suaivaki Anutuuqo tuduu ikiaivoota sikau puapusuqaa kuauvootama ngiau aapuuvakidiri tuoo gioonna kiaapuuya ruputu taika kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na Vaidiivaa Mmaapuuvo kava tiinara suaivo Rooto varuu suaivaa roosiima vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na tiinara suaivaki gioonna kiaapu voovoono ari nnauvaa vainiivau iikiaivo ari hoonahaanaiyauvo nnau aakiaivaki vaino too sa ivaa varaanara ari nnauvaki kuaivee. Itaama vaino gioonna kiaapu voovoono ari mmooriivaki iikiaivo mminnaa voovai varaanara sa kava vara ranoo kuaivee. ");
INSERT INTO waj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nnaaruaa vaidi Rootaa nnaataivo hanigia ari yoosinnaivaa toovaara yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gioonna kiaapu voovoono ari mmatayaa variraivaara yaagueeqama yaata utuoonnonno yapooma hama ivo tupatupaa varinaraivootainaravaivee. Gioonna kiaapu voovoono hama ari mmatayaa variraivaara yaata utirainno yaagueeqama varioonnonno fai tupatupaa variraivaa varaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na ngii giaa ngii miaunoo. Na tiinara heenaivaki vaidi taaravaitana mmuaa mmaatavau vakiaivaitana fai Anutuuqo vuaivaa vitoo vuaivaa pikiaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Fai gioonna taaravaitana mmuaavau varida mmoori varakio fai Anutuuqo vuainningiaa vitoo vuainningiaa pikiaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Taara vaidivaitana mmuaa mmooriivaki varada varikio fai Anutuuqo vuaivaa pikioo vuaivaa vitaanaravaivee,) ");
INSERT INTO waj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","tuduu rikiada Yisuunna nnaagiai nuairaiya inna yaparaida tunoo: Udaanga-o, a kianna kua aavo fai deevaki vainarannee? tuduu rikioo Yisuuva iya sai tunoo: Vaidi putiivaa nnabaivo vaivaki hemoonnaiya nuunaida hatoka nnaara puru variaavai. Ivaa roosiima mmuakiaa yoosinnaiyauvaki gioonna kiaapuuya nuunakiaivaki na tiinaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ari nnaagiai nuairaiya makemakee yaaku varada varikio sa iya pirisakiaiveera Yisuuva mmatayaa diaa mminnaivaudiri mmataama kioo tunoo. ");
INSERT INTO waj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kua pinaivaara dira vaidi voovoono yoosinna voovaki varioo hama Anutuuqaara aatuunno hama gioonna kiaapuuyara yoketairainno ariiyara nnaasu yaata utivai. ");
INSERT INTO waj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mmuai yoosinnaivakinnaa gioonna muaada voovoono varioo makemakee innasi ngioo inna tinoo: Eenoo ni kuaivaa rikiee vaidi voovoono kua pinaana ni yapaanaraivaa tino too pikiaivee, ");
INSERT INTO waj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","tikio rikioo kua pinaana dira vaidiivo hama inna kuaivaa rikioo iirama kioo hokoba suai mmanna yaata nnaasu rikioonnonno nnaagiai arinaima ari yaataivaa rikioo tinoo: Hama na Anutuuqaara aatuuna hama na gioonna kiaapuuyara yaata utirama kiee ");
INSERT INTO waj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","inna aikiooma aa gioonna muaada aavo tupatupaa ni yaparaikiokio ni pirisaivaara na inna kuaivaa rikiee vaidiivaa tinara: Pikiaanee, tinaravai. Fai na hama itaino aa gioonna aavo makemakee niisi nninono ni pirisainaravaivee, tiivai. ");
INSERT INTO waj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Udaanga Yisuu Kirisiiva itaa kua kiaa kioo kava tunoo: Iqii vaidi kua pinaivaara dira maisa vaidi ivo tii kuaivaa tuqinnama rikiaatee. ");
INSERT INTO waj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ivo iivaa roosiima gioonna kiaapuuya Anutuuqo ariiniee kiaa mmataama kiaiya ikiannagisanna heenagieena iya kuaiyauvaa rikiaaneera innara yaaku varakiokioo fai ivo iya kuaivaa rikiaanarannee? Vara ivo hokoba suaivaa varioo iya kuaivaa rikioonnaata hama iinarannee? ");
INSERT INTO waj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na ngii giaa ngii miaunoo. Fai ivo akiairaama iya kuaivaa rikioo iyara yoketaama iinaravee. Itaama vainai na vo kuavaara ngii yaparainaravai. Na Vaidiivaa Mmaapuuvo kava tiinara suaivaki gioonna kiaapuuya niiyara yaagueeqama kutaavaivee kiaarannee? Vara hama niiyara itaa kua kiaarannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yisuuva itaa kua kiaa kioo vaidiiya tupatupaa ngiariiyara mannaka tida ngiari seenaiya mmooka hanigia mmiraiyaatama kua tioo vaidi mmatayaa diaivaitanaudiri mmataama kioo iya tunoo: ");
INSERT INTO waj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Vaidiivaitana yaaku varaara nuunaira nnau pinaivaki viravai. Vuaivo Farisai vaidivai. Vuaivo sikau takiisa vareera vaidivai. ");
INSERT INTO waj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Vaidi Farisaivo oro dioo vainno yaaku varoo ari yaataivaadiri rikioo tunoo: Anutuuqo, hama na vaidi vooya roosiikiauvai. Ivaara na aiyara yoketaavee kiaunoo. Hama na gioonna kiaapu vooyanikaraama sikauyauvaa mmuara varee unnakua unnakua kiaa kiee gioonnaivaa sabi hauvai. Hama na aa vaidi sikau takiisa vareera aavaa roosiikiauvai. ");
INSERT INTO waj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na makemakee mmuaa Sudaaqa mmuaa Sudaaqa taara suai taara suai aiyara yaata utu kiee nnaasu vaina hama na yeenna nnauvaivee. Mmuakiaa mminnamminnaiyauvaa na vareeraiyauvaa yaaku saivai sainaidiri taarama taarama nene varee mmuaavai i mmiauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","tuduu rikioo vaidi sikau takiisa vareeraivoono numa ngieera voovaki kookama kioo vainno avuuvaa reemi mmataivaki too nnaasu vainno tunoo: Anutuuqo, niiyara boo kianee. Kaayau mminnamminnaa maisaiyauvo ni suvuainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yisuuva itaama mmataama kioo tuu kuaivaa kiaa taika kioo ari nnaagiai nuairaiya tunoo: Na ngii giaa ngii miaunoo. Anutuuqo ii vaidi sikau takiisa vareera ivaa mminnamminnaa maisaiyauvaa ruga kiaikio vioo ari nnauki Anutuuqaa avuuvau safu vaidivai varivai. Vuai vaidi Farisaivo homo inna mminnamminnaa maisaivo innaki vaikio varivai. Gioonna kiaapu voovoono ariiyara mannaka tiivaa fai Anutuuqo inna vitoo aduoo yapaanaravai. Fai gioonna kiaapu voovoono tirooma varioo hama ari nnutuuvaa aruoo yapaivaa Anutuuqo inna vitoo aruoo yapaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Gioonna kiaapu vooyaano ngiari nnaakara meediiya vitada Yisuunnasi nnuduu Yisuuva iya mmammaiyauvunu utuaiveera innasi vitada nniravai. Vitada nnuduu teeda Yisuunna ngiaammuauya iya teeda iya ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ooqoo tuduu rikioo Yisuuva nnaakaraiya maavee tuduu inna vainima nnuduu tunoo: Pikikiai nnaakaraiya niisi ngiatee. Sa iya ooqoo kiatee. Nnaakaraivo kuaivaa rikioo iva iivaa roosiikiai gioonna kiaapuuya fai Anutuuqo gioonna kiaapuuyara diraivaki kuaaravai. Ivaara sa aa nnaakara aaya ooqoo kiatee. ");
INSERT INTO waj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na kua kutaavai ngii giaa ngii miaunoo. Nnaakaraivo akiairaama kuaivaa rikioo iivaa roosiima fai gioonna kiaapu voovoono hama inna roosiima iinno Anutuuqo gioonna kiaapuuyara diraivaara kutaavaivee tiivoono fai Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki hama kuanaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tuduu vaidi Yutayaa kieeta voovoono numa Yisuunna tunoo: Vitaira vaidi yoketaa-o, dee mmoorivai na iina tupatupaa variraivaa varaanarannee? ");
INSERT INTO waj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","tuduu rikioo Yisuuva inna sai tunoo: Mo aaniira a niiyara yoketaavaivee kiannannee? Anutuuqo mmuaavoono nnaasu yoketaavai varinoo. Hama vaidi mmatayaa voovoono yoketaavai varivai. ");
INSERT INTO waj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Vaa a mmaanna tuu kuaivaa rikiaannavai. Mmaanna tuu kuaivo tinoo: A vaa nnaata vaati varaannaikua sa sabi mmuara heera aataruuvaa iikianee. Sa gioonna kiaapu voovai ruputino putuaivee. Sa voovai mminnaivaa mmuara varaanee. Sa unnakua kianee. Ai kaano koovaitanaara tuqinnaanee. Kua mmaanna tuu kuaivo itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","tuduu rikioo vaidi kieetaivo inna sai tunoo: Vaa na ngiaammuau kiisayaa varia ree ngiee ngiee makee na yokeena mmuakiaa mmaanna tuu kuaivaa tuqinnama na iikiauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","tuduu rikioo Yisuuva inna sai tunoo: Mmuaa aataruvai hama a iikiannavai. Diitee viee ai mminnamminnaa mmuakiaayauvai aisi vaiyauvaa varee vaidi vooya mmiee irisai sikauyauvaa varee mmanna haipu gioonna kiaapuuya mmianee. Mminoonno fai i irisai yoketaivo ngiau aapu vainaravai. Iya mmi taika kiee ngiee ni nnaagiai nookianee, ");
INSERT INTO waj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","tuduu rikioo vaidiivo ari hoonahaanaiyauvo kaayauma vauyauvaara yaata utuduu inna ausaivo mmuaarareeravai. ");
INSERT INTO waj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mmuaararooduu Yisuuva inna ausa mmuaararoovaa too tunoo: Gioonna kiaapu kaayau hoona suvuaiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuaaree kiaa iikiaavo kaayauma iya mmuaararainoo. ");
INSERT INTO waj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Puara pinaivaa nnutuuvo kameraivo kuatiri aataruuvaki kuanaree kiaa iikio inna mmuaararainoo. Gioonna kiaapu kaayau hoonahaana suvuaiya Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuaaree kiaa iikiaavo kaayauma iya mmuaararainoo, ");
INSERT INTO waj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","tuduu rikiada gioonna kiaapu ivaki varuuya rikiada tunoo: Mo dataama vari gioonna kiaapuvoono Anutuuqaa yoosinnaivaki aikiooma kuanarannee? ");
INSERT INTO waj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","tuduu rikioo Yisuuva iya sai tunoo: Gioonna kiaapu mmatayaiya hama yopeema iikiaa mmooriivaa fai Anutuuqoono aikiooma iinaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","tuduu rikioo Petorooso tunoo: Mo ta ti gioonna nnaakaraata ti mminnaa mmuakiaayauvaatama pikiada i nnaagiai nookiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","tuduu rikioo Yisuuva ari ngiaammuauya tunoo: Ngia kutaa kiaanoo. Na ngii giaa ngii miaunoo. Gioonna kiaapu voovoono Anutuuqo gioonna kiaapuuyara dira mmooriivaara ari nnauvaa pikioo ari nnaata nnaakaraiya pikioo ari kata vayaiya pikioo ari kaano koovaitana pikioo ");
INSERT INTO waj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","fai aa ta variaunna suai aavaki ivo iyauvaanikarai irisaiyauvaa airineetu varaanaravai. Fai yapooma nnaagiai variaara suaivaki tupatupaa variraivaa varaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yisuuva itaa kua kiaa kioo ari ngiaammuau yaakuuvaitana yukukidiri taarama vitoo ari voovau oro kioo iya tunoo: Rikiaatee. Ta Yerusareema kuaara iikiaunnano mmuakiaa kuavai forofetaa nnaaruaiya Na Vaidiivaa Mmaapuuvaa niiyara fafaara roovo fai kaanaivo vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vaidiiya ni vitada ngiari voopinnaa vaidiiya mmikiai iya ni teeda niiyara raida kua maisaivaa tida kuaanuuvaa niiyaa visida ");
INSERT INTO waj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ni ripiida ni ruputikiai fai na putuee taara suaivaitana taikanai vooma suaivaki na keenaa diitaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","tuduu rikiada Yisuunna ngiaammuauya hama arinaima rikiooduu Anutuuqo iva tuu kuaivaa oyaivaa hatauma kiooduu iya ivaara kumimakairavai. ");
INSERT INTO waj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kumimakauduu Yisuuva ari ngiaammuaudootama nnidada yoosinna Yerikoo vainima nnuduu vaidi avu huruutauvo aataru siriivau varioo gioonna kiaapuuya sikaura ngiaaru tiravai. ");
INSERT INTO waj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ngiaaru tioo varioo rikiooduu gioonna kiaapuuya vida nnidau kuaivaa rikioo vooya yaparainno tunoo: Ngia aaniira nookiaannee? ");
INSERT INTO waj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","tuduu rikiada iya inna sai tunoo: Yisuuva Nasareetaa vaidiivo aa nninoo, ");
INSERT INTO waj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","tuduu rikioo aayanna roo tunoo: Yisuu-o, Davuitiinna oyaivakidiri diiteeraikuavee. Niiyara boo kianee, ");
INSERT INTO waj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tuduu rikiada gioonna kiaapu tauraa vuuya inna yaagueeqama kua pikiaaneera tuduu rikioonnaata puaisakama aayanna roo tunoo: Davuitiinna oyaivakidiri diiteeraikuavee. Niiyara boo kianee, ");
INSERT INTO waj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","tuduu rikioo Yisuuva aataruuvau dioo vainno tunoo: Vaidi avu huruutaivaa vitada niisi ngiatee, tuduu rikiada inna vitada innasi nnuduu Yisuuva inna yaparainno tunoo: ");
INSERT INTO waj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","A aaniivai na i iikiaiveerainna kiannannee? tuduu rikioo ivo inna sai tunoo: Udaanga-o, na ni avu aavaa safuuma kava taanaraivaaraina i yaparakiaunoo, ");
INSERT INTO waj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","tuduu rikioo Yisuuva inna sai tunoo: Kava i avuuvaa taanee. A niiyara kiannanoo: Aikiooma ni tuqinnaanaravaivee, kiannaivaarainna a kati hara kiee variannanoo, ");
INSERT INTO waj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","tuduu rikioo inna avuuvo makee tuduu tuqinnama tooduu ivo Yisuunna nnaagiai vioo Anutuuqaara kua yoketaivaa kiaa roo viravai. Vuduu ivaa teeda mmuakiaa gioonna kiaapuuya Anutuuqaara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tuduu Yisuuva vioo yoosinna Yerikoo yaataraanee kiaa ");
INSERT INTO waj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","vioo varuduu sikau takiisa vareera vaidiiya kieetaivaa nnutuuvo Sakiaaso ivaki varuduu kaayau hoonaivo inna suvuauduu variravai. ");
INSERT INTO waj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ivo kakuma vaidivai mmataki dioo vainno Yisuuva inna dee vaidivainnee kiaa kioo inna taanaree tioo tooduu gioonna kiaapuuya inna suvuai kiooduu hama teeravai. ");
INSERT INTO waj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hama teerama kioo Yisuuva kuanaraipinnainnigiataa seenoo vioo gioonna kiaapuuya yaataroo yatari nnaammuayaivaa roosuuvakidiri karoo ivaki varioo inna taanaree kiaa variravai. ");
INSERT INTO waj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Varuduu Yisuuva ngioo rooru tooduu Sakiaaso ivakidiri inna too vauduu too inna tunoo: Sakiaaso, kammannai tummuanee. Na makee i nnauvaki viee i tasipama varinaravee, ");
INSERT INTO waj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","tuduu rikioo Sakiaaso akiairaama reemi roo innaata yoketaa kua tuduu pinaama inna ausaivo yoketauduu ari nnauvaki inna vitoo viravai. ");
INSERT INTO waj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vuduu teeda mmuakiaa gioonna kiaapuuya ivaitana itaama uuvaa teeda ngiariiki ngiariiki kua tida tunoo: Aa vaidi aavo mmaanna tuu kuaivaa hatokeera vaidi maisaivaa nnauvaki vioo kiainoo, ");
INSERT INTO waj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","tuduu rikioo Sakiaaso Yisuunna tunoo: Udaanga-o, rikiaanee. Na ni hoona saiyauvaa mmanna haipuuya mminaravee. Na gioonna kiaapu voovaasidiri unnakua kiaa kiee inna mminnamminnaiyauvaa varauvaa fai na taarama taaramaneetu yaaruee irisaiyauvaa inna mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","tuduu rikioo Yisuuva inna sai tunoo: Makee eeta i nnauki variaiyaatama na ngii vitee aataru yoketaivau ngii yapaunoo. Mo eeta Aaparahaamaa oyaivakidiri diitaannaivaara na ngii vitee yoketaivau ngii yapaunoo. ");
INSERT INTO waj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na Vaidiivaa Mmaapuuvoono gioonna kiaapu kumimakaiyara buainana teenai ni teeda vaikiai vitee aataru yoketaivau yapaanaraivaara na tiiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tuduu rikiada gioonna kiaapuuya inna kuaivaa rikiada varuduu Yisuuva mmatayaa diaa vaidiiyayaadiri mmataama kioo iya kiaa mmiravai. Ivo Yerusareema vainima vioo varuuvaara gioonna kiaapuuya yaata utida tunoo: Anutuuqo tiiyara dira suaivo makee tino nninaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iya itaama yaata utuduu Yisuuva mmatayaa diaa vaidiiyayaadiri mmataama kioo iya kiaa mmioo tunoo: Vaidi nnoonna voovoono ngieera vo yoosinnavakira vioo ivakidiri kieeta nnutuuvaa varoo kava vara ranoo nninaraivaara teerainno kuanara iivai. ");
INSERT INTO waj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kuanara iinno varioo tauraa ivo ari mmoori vareera ngiaammuau yaakuuvaitana tikiai innasi ngiaavo rikioo sikau yaakuuvaitana tuoo mmuaavai mmuaavai mmioo tinoo: Na oro ngieera varinai rikiada ni sikauyauvaadiri irisaima mmoori varakiai irisaiyauvaa ngii mikiai varada varida na nninara suaivaki numa ni miatee, ");
INSERT INTO waj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","kiaa kioo ngieera vioo kiaikiai ari yoosinna variaiya hama innara mmuduuya rida vaidi vooya inna nnaagiai titaani vata rada vidada oro ngieera variaiya kiaa mmida kiaanoo: Ta aa vaidi aavaara hama ti mmuduuya ruainoo. Ivo ti kieetavai varinaraivaara hama ti yoketainoo. Iya itaa kua kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Iya itaa kua kiaavoota ivo ngieera varioo kieeta nnutuuvaa varoo kava vara ranoo nniivai. Ivo nnii saivaata ari mmoori vareera ngiaammuauya yaakuuvaitana vaa ari sikauyauvaa mmuuya tikiai ngiaavo ngiari mmoori varada sikau irisaiyauvaa varaiyauvaara iya yaparaivai. ");
INSERT INTO waj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yaparaikiai rikiada tauraa mmuu ngiaammuauvo numa inna tinoo: Nnoonna-o, sikau a ni muuvaadiri na varee mmooriivaa vareenana irisai sikau yaakuuvaitana varauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","tikio rikioo inna sai tinoo: A ngiaammuau yoketaakuavee. A yoketaama ni mmoori varaannavaivee. A kiisa mmooriivaa yoketaama varaannaivaara na tinai tee a yaakuuvaitana yoosinnaiyauvaki variaiyara fai a dinaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","tikio rikioo nnaagiai sikau mmuuvoono numa inna tinoo: Nnoonna-o, sikau a ni muuvaadiri na varee mmooriivaa vareenana irisai sikau yaaku saivai varauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","tikio rikioo tinoo: Fai a irisaivaa yaaku sai yoosinnaiyauvaki variaiyara dinaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","tikio rikioo ngiaammuau voovoono numa inna tinoo: Nnoonna-o, aa sikau aavaa a ni muuvaa na kava i mmiaunoo. Na buruqaadiri rurauma kiee haumaki yapa kiauvaa i mmiaunoo. ");
INSERT INTO waj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A vaidi tinni yaagueeqainna a vaidi vooya mminnaiyauvaa varee yeennaiyauvaa hama a hau utuannaiyauvaa varaannaivaara na iiyara aatuuna i sikauvaa yapa kiauko vaivaivee, ");
INSERT INTO waj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","tikio rikioo vaidi nnoonnaivo inna tinoo: A mmoori vareera ngiaammuau maisakuavee. A kianna kuaivaa na kava aiki yapaanaravaivee. Vaa a kutaa taannani na vaidi tinni yaagueeqaina vaidi vooya mminnaiyauvaa na varee yeennaiyauvaa hama na hau utuaiyauvaa varauvaivee. ");
INSERT INTO waj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mo itaama vaikiai aaniira a hama ni sikauyauvaa varee sikau nnaamuruuvaki yapaannannee? Vaa a itaa kiannatiri. Na kava vara ranee ngiee sikau nnaamuru nakaaraivaasidiri sikau irisai kiisaivaatama varautirivee, ");
INSERT INTO waj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","kiaa kioo vaidi ivaki diaiya tinoo: Inna sikauvaa ravisi varada ngiaammuauvo sikau yaakuuvaitana utiivaa mmiatee, ");
INSERT INTO waj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","tikiai rikiada kiaanoo: Ivoono yaakuuvaitana sikauyauvaa utivaivee, ");
INSERT INTO waj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","kiaavo rikioo tinoo: Na ngii giaa ngii miaunoo. Gioonna kiaapu voovoono mminnaiyauvaa utiivaa fai na kava vo mminnaa vooyauvaatama inna mminaravai. Gioonna kiaapu voovoono hama kaayau mminnaataivo fai kiisa mminnaa innasi vaivaa na numa innasidiri ravisi varaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aa ni nnammutuaa aaya na iya kieetavai varinaraivaara hama iya mmuduuya ruaiya vitada aapi numa ni avuuvau ruputikiai putuatee. Vaidi nnoonnaivoono itaa kua tiivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yisuuva ii kua ivaa kiaa taika kioo gioonna kiaapuuya pikioo ivannaadee tauraa Yerusareema aataruuvau nniravai. ");
INSERT INTO waj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ngioo ari ngiaammuauya vitoo yoosinnaivaitana nnutuuvaitana Betepakee Betaniaa vainima vau taapi Oriveeta ivau dioo vainno ari ngiaammuauvaitana titoo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Oro ukuaa yoosinna ivaki teekio rikioo puara togii karaasa hama vaidiiya variaivaa nnuunaivaki yeena harukiaivo ngii too vainai teeda rukuasaa kiada vitada niisi ngiatee. ");
INSERT INTO waj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Fai gioonna kiaapu voovoono ivaara ngii yaparainno tinara: Ngia aaniira ivaa rakuasaannee? tinai kiatee: Udaangaivoono ivaa vitaateera ti titaikiai ta ngiaunnanoo, kiatee, ");
INSERT INTO waj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","kiaa kioo ivaitana titooduu vida Yisuuva ivaitana kiaa mmuuvaa teeravai. ");
INSERT INTO waj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Teeda puara togiivaa rakuasada varida tooduu puara togiivaa nakaaraiya numa ivaitana teeda tunoo: Ngia aaniiraida aa puara togii aavaa rakuasaannee? ");
INSERT INTO waj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","tuduu rikiada ivaitana inna sai tunoo: Udaangaivoono ivaa vitaateera ti titaikiai ta ngiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","kiaa kiada puara togiivaa vitada nniravai. Nnida ngiari yaapaiyauvaa togiivaa mmookaivau yapa kiada Yisuunna ivau yapa kiooduu variravai. ");
INSERT INTO waj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Varuduu togiivo inna vitoo vioo varuduu gioonna kiaapuuya ngiari yaapaiyauvaa aataruuvau hooti kiooduu Yisuuva ivaugiataa viravai. ");
INSERT INTO waj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Vioo vioo Yerusareema vainima vioo aataruuvo taapi Oriveeta ivaugiataa vuuvau vioo haatapoo mmeepi kaayau gioonna kiaapu inna nnaagiai nuairaiya numa sirigaida Anutuuqaara kua yoketaivaa kiaa rada nniravai. Nnida varida Yisuuva ari vookarau mmooriivaa uuvaa toovaara kua yoketaivaa Anutuuqaara puaisakama aayanna tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Puaisakama aayanna tida tunoo: Kieeta vaidiivaa Udaanga Anutuuqo titooduu tuuvo nninaraivaara ivo innara yoketaakiaivee. Ausa nuufai aataruuvo ngiau aapuuvaki vainoo. Anutuuqo ngiau aapu variivaa oyai ari vookaraivo vainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tuduu rikiada gioonna kiaapuuya nuuna aakiaivakidiri Farisai vaidi vooya Yisuunna tunoo: Vitaira-o, a yaagueeqama tinai i nnaagiai nuairaiya kua pikiaatee, ");
INSERT INTO waj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","tuduu rikioo ivo iya sai tunoo: Na ngii giaa ngii miaunoo. Iya kua seemuaa variaatiri. Aa sikau aayauvoono niiyara aayanna kiaatirivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yisuuva itaa kua kiaa kioo vioo vioo Yerusareema vainiivaudiri reemi ivaki too ivaki varuu gioonna kiaapuuyara ratoo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Boo, aanna makee ngia ausa nuufa tasipama varira aataruuvaa ngia rikiaataama vaikiainnaata hama ngia rikiaanoo. Fai ngia rikikio ngii yoketainaravai. ");
INSERT INTO waj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Suai voovai nninai ngii nnammutuaiya ngii ututuuma kiada ngii vagiaamunnaivau iriivaa rooru kiada ivaugiataa nnikiai fai hama ngia mmaanai kuaara aataruuvootainaravai. ");
INSERT INTO waj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Fai iya numa ngiiita ngii nnaakaraiyaatama rapida ngii ruputu mmatammaataivau kagaari kiada ngii nnau yoosinnaiyauvaa hannavaratataama taika kikio hama nnau heekaa sikau voovai ari mmaataivau vainaravai. Ngia hama Anutuuqo ngii vitoo aataru yoketaivau ngii yapaanara suaivaa teeda rikiaivaara ngii nnammutuaiya numa ngii itaakiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yisuuva itaa kua kiaa kioo nuunaira nnau pinaivaki vioo vaidiiya ngiaammaiyauvaata puara sipisiipaiyauvaatama vooya mmida irisai sikauyauvaa varooya yaagueeqama titoo ");
INSERT INTO waj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iya tunoo: Anutuuqaa kua fafaaraivo vainno tinoo: Ni nnauvo yaaku vareera nnauvaivee. Anutuuqaa kuaivo itaa kua tikiainnaata ngia mmuara furaiya iirayaamaida aavaki iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mmuakiaa suai Yisuuva nuunaira nnau pinaivaki mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiravai. Kiaa mmuduu rikiada vaidi Anutuuqaara kati puara hudeera kieetaiyaatama kua mmaanna kiaa mmiraiyaata vaidi kieetaiyaatama Yisuunna ruputuaaree kiaa uuduu ");
INSERT INTO waj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","hama inna ruputuaara aataruuvootairavai. Mmuakiaa gioonna kiaapuuya inna kuaivaa iya rikiaatauduu varuuvaara hama inna ruputuaara aataruuvootairavai. ");
INSERT INTO waj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Vo suai voovaki Yisuuva nuunaira nnau pinaivaki varioo mmayaaya yoketaivaa mmuakiaa gioonna kiaapuuya kiaa mmioo varuduu vaidiiya Anutuuqaara kati puara hudeera kieetaiyaatama kua mmaanna kiaa mmiraiyaata vaidi yokovaiyaatama numa ");
INSERT INTO waj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","inna yaparaida tunoo: Ti kiaa ti mmianee. Gioono i tikiainna aa mmoori aayauvaa a iikiannannee? Dee vaidi kieetavoono i tikiai a iikiannannee? ");
INSERT INTO waj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","tuduu rikioo Yisuuva iya sai tunoo: Kii neeta vo kuavaara ngii yaparainai ni giaa ni miatee. ");
INSERT INTO waj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Gioono tuduu Yuvuaano nnoori apira vaidiivo gioonna kiaapuuya nnoori apuunnee? Vo Anutuuqoono tuduunno uunnee? Vo vaidi mmatayaiyaano tuduunno uunnee? ");
INSERT INTO waj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tuduu rikiada iya ngiariiki ngiariiki yaparaida tunoo: Ta dee kuavai sai kiaarannee? Fai ta inna sai kiaara: Anutuuqoono tuduu Yuvuaano iiravaivee, tikio fai ivo ti tinara: Mo ngia aaniira hama inna kuaivaara kutaavaivee tiravainnee? ");
INSERT INTO waj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","tinai mo fai ta kiaara: Vaidiiyaano tuduu Yuvuaano iiravaivee, tikiai fai gioonna kiaapu aavaki variaiya sikauyauvaa habati kiada ti ruputuaaravai. Iya Yuvuaanaara forofetaivovee kiaivaara fai ti ruputuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iya itaa kua kiaa kiada Yisuunna kuaivaa sai tunoo: Yuvuaano nnoori apira oyaivaa hama teeta taunnavaivee, ");
INSERT INTO waj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","tuduu rikioo Yisuuva iya tunoo: Hama ngia ni kuaivaa sai kiaivaara fai na hama ngii kuaivaa sai tinaravai. Ivo ni tikiai na ni mmooriivaa iikiau oyaivaa fai hama na ngii giaa ngii minaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yisuuva itaa kua kiaa kioo aa kua aavaa mmatayaa diaa vaidiiyayaadiri mmataama kioo gioonna kiaapuuya kiaa mmioo tunoo: Vaidi voovoono ari vuaina mmooriivaa vara kioo ivaki hauyauvaa utu kioo vaidiiya inna mmooriivaara haitatuuda iira vooyauvai ngiari mmoori varaa irisaiyauvaa ngiariyara varaateeraivaara iya kiaa mmi kioo ngieera vo yoosinnaipi hokoba suai varinara kuaivai. ");
INSERT INTO waj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Vioo vioo oro ngieera yoosinnaivaki hara kioo varikio vuaina iiraiyauvaa rasukuaara suaivo nnikio mmoori nakaaraivo ari ngiaammuauvaa titaa kiaikio kuaivai. Inna mmooriivaa haitatuukiaiyaano vuaina iira irisaiyauvaa inna mmiateeraivaara kuaivai. Kuaikiai teeda iya pinaama inna ruputida inna ripiida vuaina mmooriivaa irisaiyauvaa hama inna mmirama kiada kati titaa kiaavo nniivai. ");
INSERT INTO waj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ivo nnikio mmoori nakaaraivoono kava ari ngiaammuau voovai titaa kiaikio kuaikiai rikiada kava mmuaikaraama inna ripiida ruputida kaayau kuakuaakua maisaivaa inna tida hama irisaiyauvaa inna mmirama kiada kati titaa kiaavo nniivai. ");
INSERT INTO waj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nnikio too mmoori nakaaraivo kava vo ngiaammuau voovai titaa kiaikio kuaikiai iya ivaata ruputuaavo kiau vitiika tiikiai rikiada hanikia mmaanai kagaari kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kagaari kiaavo rikioo mmoori nakaaraivo tinoo: Mo na aanii aataruvai iikiaunnee? Fai na ni maapu tuanaa na innara mmuduuya ruauvaa titaa kino vinai rikiada fai iya inna kuaivaa rikiada hama inna ruputuaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kiaa kioo inna titaa kiaikio kuaikiai teeda mmooriivaara haitatuukiaiyaano inna teeda ngiari kiaa mmi ngiari kiaa mmiida kiaanoo: Ari koonna mminnaa mmuakiaayauvai varaanaraivoono aavaa nninoo. Nnikiai ta inna ruputu kikio putinai ta inna mminnaa mmuakiaayauvai varaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","kiaa kiada inna utu raririima rada hanikia mmaanai inna kagaari kiada inna ruputu kiaavo putivaivee. Ii kua ivaa kiaa taika kioo Yisuuva gioonna kiaapuuya yaparainno tunoo: Mo dee mmoorivai fai mmoori nakaaraivo iya iikiaivaa irisai iya mminarannee? ");
INSERT INTO waj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Fai ivo numa iya ruputu kinai putikio rikioo ari vuaina mmooriivaa vaidi vooya mminai haitatuukiaaravaivee, tuduu rikiada gioonna kiaapuuya yaata utida tunoo: Ai, boo, kutaavai itaama iinarainnoo, ");
INSERT INTO waj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","tuduu rikioo Yisuuva iya puaisakama too vainno ariiyara tunoo: Anutuuqaa kua fafaaraivo vaivaa oyaivaa ni giaa ni miatee. Kua fafaaraivo vainno tinoo: Sikau nnau heekeeraiyaano sikau voovai teeda maisaivaivee kiaa kiada pikiaavai. Yaagueeqa yatariivaa pupukiaivaa mmaara hara kiaa kuabaivaa roosiima ii sikau ivo nnau ipunnaivaki vaivo inna yoketaavaivee. Anutuuqaa kuaivo itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Gioonna kiaapu voovoono nuainnonno ii sikau ivaudiri raa rabarisooma varoo ivau harurummua kioo vainno fai kaayau ari mmamma mmuyaivaa ruaimeemiinaravaivee. Fai ii sikau ivo taikiapa roo gioonna kiaapu voovai ruputino inna mmamma mmuyai sagia mmuakiaavai ruaimeemiima taika kiaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tuduu rikiada kua mmaanna kiaa mmira vaidiiyaata Anutuuqaara kati puara hudeera kieetaiyaatama Yisuuva vuaina mmooriivaara tuuvaudiri mmataama kioo kuaivaa iyaki yapoovaara rikiada iva tuu saivaata inna utuaaree kiaa kiada tooduu kaayau gioonna kiaapuuya inna suvuai kiada varuduu iyara aatuuda pikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pikiada inna haitatuuda varida vaidi vooya unnakua kiaa yoketayoketaama rada Yisuunna kuaivaa rikiaateeraivaara iya titeeravai. Yisuuva kua voovai koonnama tinai rikiada inna vitada Roomaaya kieeta vaidi yaagueeqa pinaa ruaivaa mmiaaraivaara iya titooduu viravai. ");
INSERT INTO waj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Vida Yisuunna tunoo: Vitaira-o, vaa ta rikiaunnavai. A kianna kuaivaa safuuma ti kiaa ti mmiannavai. Vaa ta i taunnavai. Vaidi kieetaiyaraata vaidi kuminaiyaraatama a mmuaavaugiataama yaata utuannavai. A hama vo vaidivai tee pikiee vo vaidivai tee kiaa mmiannavai. A Anutuuqaa mmoori aataruuvaa mmuakiaa gioonna kiaapuuya safuuma kiaa mmiannavaivee. ");
INSERT INTO waj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ti kiaa ti mmianee. Roomaaya kieetaivaasi sikau takiisa yapeera aataruuvo yoketaa aataruvainnee? Vara hama yoketaa aataruvainnee? tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tuduu rikioo Yisuuva iya inna iida taaree kiaa tuu kuaivaa vaa ivo arinaima too rikioo iya tunoo: ");
INSERT INTO waj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Sikau mmuyai voovai ni vitaakiatee. Giaa mmannammannaavoota giaa nnutuvootama ivau vainnee? ");
INSERT INTO waj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","tuduu rikiada iya inna sai tunoo: Mo Roomaaya kieetaivaa mmannammannaivoota inna nnutuuvootama aavau vainoo, tuduu rikioo Yisuuva iya sai tunoo: Mo Roomaaya kieetaivaa mminnaiyauvaa safuuma ari mmiatee. Anutuuqaa mminnaiyauvaa safuuma Anutuuqaa ari mmiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gioonna kiaapuuya avuuvau ivo koonnama kuaivaa kiaiveera iya inna yaparauduu ivo hama koonnama tirainno safuuma kuaivaa sai tuuvaara iya nnikiaraida hama kua tiraida kua seemuaa variravai. ");
INSERT INTO waj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Varuduu vaidi Satuukaiya gioonna kiaapu putuuyara tunoo: Fai hama kava diitaaravaivee, tuuyakidiri vooya numa Yisuunna yaparaida tunoo: ");
INSERT INTO waj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Vitaira-o, Musiiva vo aataruvai tiiyara fafaara roo tunoo: Vaidi voovoono nnaataivaa vara kioo hama nnaakaraivaa mmateerainno putino fai ari kataivoono inna muaadaivaa vara kioo ari vayaannara tuoo nnaakaraiyauvaa mmataanaravaivee. Musiiva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Vo suai voovaki kata vayaa yaaku saivai sainaidiri taaravaitana hara kiada varuuya ngaruuvoono nnaataivaa vara kioo hama nnaakara mmateerama kioo kati putiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Putuduu ngamiisaivo inna muaadaivaa vara kioo hama nnaakara mmateerama kioo kati putuduu ");
INSERT INTO waj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","nnaagiai yaguaavaano inna muaadaivaa vara kioo hama nnaakara mmateerama kioo putuduu mmuakiaa kataunna nnaagiainnaidootama mmuai gioonnaivaa vara kiada hama nnaakara mmateerama kiada kati putiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Putuduu nnaagiai iya gioonnaivootama putiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Itaama vaikiai yapooma gioonna kiaapu vaa putuaiya kava diitaara suaivaki fai gioonnaivo giaa nnaatavai varinarannee? Mo vaa yaaku saivai sainaidiri taarama vaidi idoono inna vara kiada putiravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tuduu rikioo Yisuuva iya sai tunoo: Gioonna kiaapuuya aanna makee variaiya nnaata vaati varaavai. ");
INSERT INTO waj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Gioonna kiaapuuya vaa hanigiada yoketaama variaiya putikio Anutuuqo iya tinai kava diitada nnaagiai yoosinna yoketaivaki varida hama nnaata vaati varaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iya aangeraiya roosiima variaaraivaara hama kava putuaaravaivee. Anutuuqo iya tinai iya kava diitaaraivaara fai iya inna raunna mmaapu tuanaaya variaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gioonna kiaapu vaa putuaiya kava diitaaraivaara Musiiva tuu kuaivo vainno ti kiaa ti mmivaivee. Nnaaru ivo yatari kiisaivaki ikiaivo tooduu hama yatari apuuvo taa tamooqoovaara ivo fafaara roo Udaangaivaara tunoo: Ni nnaakukiaiya Aaparahaamo Isaako Yakoopainna Anutuuqovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anutuuqo gioonna kiaapu vaa eeyaara putuaiya hama iya Anutuuqovee. Gioonna kiaapu variaiya Anutuuqovee. Gioonna kiaapu homo mmatayaa variaiyaata vaa putuaiyaatama Anutuuqaa avuuvau homo variaanoo, ");
INSERT INTO waj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","tuduu rikiada kua mmaanna kiaa mmira vaidi vooya inna tunoo: Vitaira-o, a yoketaamainna iya sai kiannanoo, ");
INSERT INTO waj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","tuduu iya hama kava vo kuavaara yopeema inna yaparairavai. ");
INSERT INTO waj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hama inna yaparauduu Yisuuva gioonna kiaapuuya tunoo: Mo dataama kiada gioonna kiaapuuya kiaanoo: Vaidi Anutuuqo mmataama kioovo Davuitiinna oyai tuanaivakidiri diitaivaivee, kiaannee? ");
INSERT INTO waj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davuitiiva ariinoo yanaivaa nnutuuvo Saama ivau fafaara roo tunoo: Udaanga Anutuuqoono ni Udaangaivaa tunoo: A ni yaaku yaadudainningiaa vaidi nnoonnavai varianee. ");
INSERT INTO waj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Varia ree vinanai na tinai fai a ai nnammutuaiya yaatara kiaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davuitiivaano Anutuuqo mmataama kioo vaidiivaara fafaara roo itaa kua tunoo: Ni Udaangaivovee, tuuvaara hama Anutuuqo mmataama kioo vaidiivo Davuitiinna oyaivakidiri nnaasu diiteeravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yisuuva itaa kua tuduu gioonna kiaapu kaayauya inna kuaivaa rikiada varuduu iva ari nnaagiai nuairaiya tunoo: ");
INSERT INTO waj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Kua mmaanna kiaa mmira vaidiiya iira aataruuvaa teeda tuqinnama haitatuuda sa iya roosiima iikiatee. Iya buruqa hokobaiyauvaa rau varada gioonna kiaapuuya yeenna yookaira mmatuuyaiyauvaki nuaikiai gioonna kiaapuuya iya teeda iyara vaidi nnoonnayavee kiateeraivaara nookiaavai. Iya nuunaira nnauyauvaki vida mmaata yoketaiyauvunu nnaasu variaavai. Iya buusaiyauvaa nneera suaiyauvaki kieetaiya varira mmaataiyauvunu nnaasu variaavai. ");
INSERT INTO waj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iya oro muaada gioonnaiya unnakua nnammari kuaivaa tida iya mminnamminnaiyauvaa ngiariyara kati vara kiada nnaagiai oro mmanna avaiyauvakidiri hokobama yaaku varaavai. Iya itaama iikiaivaara ngiari irisai pinaa maisaivo vainaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yisuuva nuunaira nnau pinaivaki dioo vainno reeti tooduu gioonna kiaapu kaayau hoona suvuauya numa ngiari sikauyauvaa kati Anutuuqaara yapeera sikau nnaamuruuvaki yapada variravai. ");
INSERT INTO waj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yapada varuduu Yisuuva tooduu mmanna haipu gioonna muaada voovoono sikau kiisa kookee taarakiatatana numa sikau nnaamuruuvaki yapeeravai. ");
INSERT INTO waj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yapa kiooduu too Yisuuva tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Aa gioonna muaada mmanna haipu gioonna aavo yapa kiai sikau kiisaikiatatanaano mmuakiaa gioonna kiaapuuya yapa kiaa sikauyauvaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gioonna kiaapu kaayau hoona suvuaiya kaayau sikau vaiyauvakidiri vooyauvai nnaasu varada yapa kiaavo gioonnaivo hama sikaunnaataivo mmuakiaa sikau innasi vaivaitana eeyaavaitana varoo yapa kiaivai. Iva ari yeenna varaanee tii sikau eeyaakiatatana varoo sikau nnaammuruuvaki yapa kiaivaara inna sikauvaitanaano gioonna kiaapuuya yapa kiaa sikauyauvaa yaataraivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tuduu Yisuunna nnaagiai nuaira vooyaano nuunaira nnau pinaivaara kua tida tunoo: Yoketaa ari vookarai sikau yapakiaiyauvaata mminnaiyauvaa vaidiiya kati Anutuuqaara ivaki yapakiaiyauvaatama ta taunnano ti yoketainoo, tuuvaa Yisuuva rikioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Aa ngia taa mminnaa mmuakiaa aayauvaa fai suai voovai nninai vaidiiya mmuakiaa aa nnau aayauvaa havarata taika kikio rikioo fai hama seena sikau voovai ari seena sikau voovai mmaataivau tasipama vainaravai. Fai mmuakiaavai havarata taikaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tuduu rikiada iya inna yaparaida tunoo: Vitaira-o, a kiannaivo daira suai vainarannee? Dee ari vookarai aataruvai vainai rikiada fai ta ivaudiri teeda mmuakiaa kua a kiannaivaara yaata utida kiaara: Vainima vainaravee, kiaarannee? ");
INSERT INTO waj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","tuduu rikioo Yisuuva iya sai tunoo: Vaidi voovoono ngii unnakua kiaa kioo aataru maisaivau ngii vita yapeenoora tuqinnama haitatuukiatee. Fai kaayau vaidiiya mmuaavai mmuaavai nnida ni nnutuuvaa ngiariiyara tida voovoono tinara: Aanna na Anutuuqo mmataama kioo vaidi ivoona na ngiaunoo, tino fai voovoono tinara: Ngiau mmata taikaanara suaivo vainima nninoo, tinai sa ivaa rikiada kiatee: Kutaa kuavaivee, kiatee. ");
INSERT INTO waj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Fai yoosinna voovaki variaiya diitada yoosinna voovaki variaiyaatama rapuai mmayaayaivaa rikiada mmuaa yoosinnaivaki variaiya diitada ngiari kieetaiyaatama rapuai mmayaayaivaa rikiada ivaara sa aatuukiatee. Rapiraivonnaadee tauraa vaino too ngiau mmata taikeera suaivo fai hama makee tino nninaravaivee, kiaa kioo vo kuavai iya tunoo: ");
INSERT INTO waj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Fai gioonna kiaapu voovaki variaiya diitada gioonna kiaapu voovaki variaiyaatama rapuaaravai. Fai vo kieeta voovoono diitoo vo kieetavaata rapinara iinai rikiada fai ngiari gioonna kiaapuuya rapuaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Fai kaayau mmataa kuaruuvo utino vo yoosinna vo yoosinnaiyauvaki aarareeraivo vaino kaayau nniitareeraivo vaino fai ngiau aapuuvau teekio kaayau ari vookarai mminnaiyauvo vainaraivaara gioonna kiaapuuya aatuukiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ii na kiau kua iyauvo fai nnaagiai vainaravai. Tauraa vaidi vooya ngii vitada mmoori maisaivaa ngii mida ngiari nuunaira nnauyauvakiaata oovi nnauyauvakiaatama ngii vitada kiada ngia niiyara kutaavaivee kiaivaara iya ngii vitada vaidi kieetaiyasi vida kua pinaana ngii yapa kiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yapa kikio ii suai iyauvaki inna ni mmayaaya yoketaivaa iya kiaa mmiaara suaivai. ");
INSERT INTO waj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Sa mmuaanaa ngia sai kua kiaaraiyauvaara kaayauma yaata utikio ivaara ngii mmuaararakiaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Na kuaiyauvaa ngii giaa ngii miee tinni yoketaiyauvaa ngii minai fai ngii nnammutuaiya hama ngii yaatarada ngii kuaiyauvaa hatokaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ngii kaano kooyaatama ngii gata vayaiyaata ngii seena tuanaiyaatama ngii vitada vo vaidiiya mmikiai fai iya ngiiikidiri vooya ruputikiai putuaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ngia niiyara kutaavaivee kiaivaara gioonna kiaapu kaayauya ngii teeda hama ngiiiyara mmuduuya ruaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sa yaata utuatee. Fai iya hama yopeema eeyaara ngii ruputuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Fai ngia mmannammanna yaagueeqama varidada tupatupaa variraivaa varaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ngiari voopinnaa rapira vaidiiya numa yoosinna Yerusareemaivaa ututuuma kikiai ngia teeda kiaara: Fai kiisa suai nnau yoosinnaivaa havarataaravaivee, kiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kiaa kiada ngia Yutayaa variaiya ngiingii yaatu aatuuda taapiivaura seenada kuatee. Gioonna kiaapu yoosinna Yerusareema variaiya seenada mmaanai vikiai mmooriiyauvaki variaiya sa kava yoosinnaivaki ngiatee. ");
INSERT INTO waj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ii suai ivaki Anutuuqo irisai maisa mmooriivaa ngii minaravaivee. Anutuuqaa kua fafaara mmuakiaavai roovaa kaanaivo vainaraivaara irisai maisa mmooriivaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Boo, iqii suai ivaki gioonna nnaakara sunnaakiaiyaata gioonna nnaakara meedi ruaiyaatama kuaaraivo iya mmuaararainaravaivee. Anutuuqo aa gioonna kiaapu mmuakiaa aayara nnannateeno rikioo mmoori maisaiyauvaa iya mminaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Fai ngiari voopinnaa vaidiiya ngiari paipa avaikaraiyauvaadiri varada numa vooya rutakakiai putikiai vooya yaakuuyauvaa ranaa rau kiada vitada ngiari yoosinnaiyauvakira kuaaravai. Fai iya yoosinna Yerusareema variaiyara dikiokio Anutuuqo tinai iya pikiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Iqii suai ivaki ari vookarai mminnamminnaiyauvo suaivakiaata kuraagaivakiaata aakiapuaiyauvakiaatama vainaravai. Vainai gioonna kiaapu mmuakiaa mmatayaa variaiya ngiari ausa mmuaararai tasipama varida nnoori akuaivaaraata nnooriivo pinaama korokoroovaaraatama kaayauma aatuuda variaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yaagueeqa mminnamminnaa ngiau aapuuvaki vaiyauvo ngiari aataru nuairaiyauvaa pikiada sabisaabi kuaaraivaaraata ari vookarai aataruuyauvo mmuakiaa mmataivau nninaraivaaraatama yaata utida faannaida aatuuda varida fai ngiengie vo vuayaata rikiada variaaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Itaama vainai rikiada Na Vaidiivaa Mmaapuuvoono nama aakiaidaadiri ni yaagueeqaivoota kaayau ari vookarai mmeekiaivootama ni tasipanai na tiinaraivaa fai iya taaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aa na kiau kua aavo iinara iinno varinai diitada vararu reeri taatee. Anutuuqo ngii vitoo yoketaivau ngii yapaanaraivo vainima nninaraivaara diitada vararu reeri taatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yisuuva mmatayaa diaa mminnaivaudiri mmataama kioo iya kiaa mmioo tunoo: Yatari nnaammuayaivaaraata mmuakiaa yatariiyauvaaraatama yaata utuatee. ");
INSERT INTO waj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ii yatari iyauvo mmunni raikiai ngia teeda kiaanoo: Nuanuuvo vainima nnikioonno mmunni rainoo, kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mmuaikaraama ii na ngii giaa ngii miau kua iyauvaa kaanaiyauvaa ngia teeda kiaara: Anutuuqo gioonna kiaapuuyara diraivo nninarainno iinoo, kiaaravee. ");
INSERT INTO waj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na Kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu aanna makee variaa aaya hama putiraida homo varikio suaivo nnino ii aataru iyauvo fai vainaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ngiau mmataivo fai taikaanaravaivee. Ni kuaivo fai hama taikaanaravai. Fai tupatupaa vainaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ngiengie mmatayaa variaivaara tuqinnama yaata utuatee. Pinaa yeenna nnaaraivaaraatama nnoori kapikaraivaa nnaaraivaaraatama mmatayaa diaa mminnaiyauvaa varaaraivaaraatama ngia kaayauma yaata utivoora ngiengie variaivaara tuqinnama yaata utuatee. Fai ngia ii mminnamminnaa iyauvaara nnaasu yaata utikiokio ii suai ivo fai akiairaama ngiiisi nninaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Iqii suai ivaki kobeevo haisarineema fai mmuakiaa gioonna kiaapu mmatayaa variaiyasi akiairaama nninaravai. ");
INSERT INTO waj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mmuakiaa suai tuqinnama haitatuuda varida yaaku varaatee. Ii mmuaararai iyauvo ngiiisi nninai rikiada yaagueeqama varida iyauvaa yaatara kiada Na Vaidiivaa Mmaapuuvo suai nnaagiai kava na tiinai ngia ni avuuvau yoketaama diaaraivaara tuqinnama haitatuuda varida yaaku varaatee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mmuakiaa suai ivo nuunaira nnau pinaivaki kua mmayaaya yoketaivaa gioonna kiaapuuya kiaa mmiravai. Suai ikianna iya kiaa mmuduu rikioo upisipisiinno varuduu ivo vioo taapi Oriveeta oro ivau vuru vairavai. ");
INSERT INTO waj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vauvo patauduu diitoo heenanaanna tuanaa kava nuunaira nnauvaki nnuduu mmuakiaa gioonna kiaapuuya inna kuaivaa rikiaaraivaara innasi nnida nuunairavai. ");
INSERT INTO waj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Buusaivaa nnutuuvo Varaigiataivaa nneera suaivaki gioonna kiaapu Yutayaiya bereetaivaa hama puuqaira yeennaivaa tasipama hudooyauvaa nneeravai. Ii suai ivo vainima vauduu ");
INSERT INTO waj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","vaidi Anutuuqaara kati puara hudeera kieetaiyaata vaidi kua mmaanna kiaa mmiraiyaatama Yisuunna ruputuaara aataruuvaara buaidada tooduu kaayau gioonna kiaapuuya innara mmuduuya ruuvaara aatuuravai. ");
INSERT INTO waj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aatuuduu Yisuunna ngiaammuau yaakuuvaitana yukukidiri taaramaakidiri voovai nnutuuvo Yutaaso Isariootaa aakiaivaki Sataango numa hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Varuduu Yutaaso vioo Anutuuqaara kati puara hudeera kieetaiyaata nuunaira nnau pinaivaara dira kieetaiyaatama Yisuunna kooyaa vitainaraivaara iyaatama kua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kua tuduu rikiada iya kaayauma sirigaida irisai sikauyauvaa inna mmiaaraivaara kua yeena rairavai. ");
INSERT INTO waj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iya kua yeena rau kiooduu rikioo Yutaaso ee-oo kiaa kioo ii suai ivakidiri iva faannama roo varia roo vioo varioo dee suai tuanaavai nnino rikioo iva Yisuunna kooyaa iya vitainaraivaara faannainno varioo gioonna kiaapuuya hama inna tasipaara suaivaara haitatuuravai. ");
INSERT INTO waj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gioonna kiaapu Yutayaiya buusaivaa nneeda hama puuqaira yeennaivaata bereetaivaa tasipama huda nneera suaivo nniravai. Ii suai ivaki iya puara sipisiipa nnaakaraiyauvaa ruputu kiada buusa Varaigiataivaa nneeravai. ");
INSERT INTO waj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iqii suai ivaki Yisuuva ari ngiaammuauvaitana Yuvuaanaya Petoroosaya kiaa mmioo tunoo: Oro buusa Varaigiataivaa tiini teerama kikiai ta nnaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","tuduu rikiada ivaitana inna sai tunoo: Ta dee nnauvaki vida buusaivaa teerakiaunnannee? ");
INSERT INTO waj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","tuduu rikioo Yisuuva ivaitana sai tunoo: Rikiaatee. Ngia vidada oro yoosinna pinaivaki teekio vaidi voovoono nnoori tooriivaa apu varoo ngii saidi nninai teeda inna nnaagiai vida teekio ivo nnauvaki vinai teeda ivo kuaivaki kuatee. ");
INSERT INTO waj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Vida nnau nakaaraivaa kiatee: Ti Vitairaivo tinoo: Dee nnauvaki na ni ngiaammuauyaatama buusa Varaigiataivaa nnaarannee? tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","tikio rikioo ivoono nnau pinaivaa verenoovau vo nnau voovai vaa mmaataiyauvaa ivaki teerama kiaivaa ngii vitainai ngia ivaki buusaivaa teerama kiaatee, ");
INSERT INTO waj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","tuduu rikiada ivaitana oro Yisuuva tuuvaa teeda buusaivaa teerama kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Teerama kiooduu buusa nnaara suaivo nnuduu Yisuuva ari kua varada nuaira ngiaammuauyaatama buusaivaa nnaaraivaara varioo tunoo: ");
INSERT INTO waj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ni putira suaivo vainima nninoo. Tauraa hama mmuaararaivo niiki nninai na aa buusa Varaigiataa aavaa ngii tasipama nnaanaraivaara ni yoketainoo. ");
INSERT INTO waj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na ngii giaa ngii miaunoo. Fai aa buusa aavaa hama na kava nnaanaravai. Yapooma Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki buusaivaa oyaivo kooyaa vainai na nnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","kiaa kioo Yisuuva nnoori tooriivaa tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo tunoo: Aavaa vara kiada mmuaavai mmuaavai nnaatee. ");
INSERT INTO waj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na ngii giaa ngii miaunoo. Aa suai aavakidiri varia ree viee viee hama na kava vuaina suuyaivaa nneeraatainaravai. Fai yapooma Anutuuqo gioonna kiaapuuyara dira suaivo nninai na kava nnaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","kiaa kioo ivo bereetaivaa tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo kusii kioo ari ngiaammuauya mmioo tunoo: Aanna ni mmatiivaivee. Na ngiiiyara tiee ivaa ngii miaunoo. Aavaa nneeda varida niiyara yaata utuatee, ");
INSERT INTO waj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","tuduu yeennaivaa nnaa taika kiooduu iva vuaina suuya tooriivaa varoo mmuaikaraama tu kioo vainno iya mmioo tunoo: Aa vuaina suuya toori aavo inna ni kiauvo ngiiiyara tusaanaraivovee. Ivaudiri fai Anutuuqo kua yeena rau kiai karaasa aataruuvo kooyaa vainaravaivee, tuduu nneeravai. ");
INSERT INTO waj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nnaa kiooduu tunoo: Rikiaatee. Vaidi voovoono kooyaa ni nnammutuaiya ni vitainaraivo aa makee ni tasipama yeenna nnainoo. ");
INSERT INTO waj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Na Vaidiivaa Mmaapuuvoono fai putinaravai. Anutuuqaa yanaivau fafaaraivo vainno ivaara tiivo aanna makee vainoo. Vaidi voovoono kooyaa ni nnammutuaiya ni vitainaraivo fai irisai maisaivaa varaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","tuduu rikiada ari ngiaammuauya ngiari yapara ngiari yaparaida tunoo: Fai tiikidiri deevoono kooyaa ari nnammutuaiya inna vitainarannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kiaa kiada yaagueeqama ngiari yapara ngiari yaparaida tunoo: Fai deevoono tiikidiri ti tauraanaavai varinarannee? ");
INSERT INTO waj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","tuduu rikioo Yisuuva tunoo: Ngiari voopinnaa kieeta vaidiiya ngiari seenaiyara yaagueeqama diaanoo. Iya iyara diaivaara ngiari nnoonnaiyara yoketaa kua kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iya itaama iikiaa aataruuvo sa ngiiisi vakiaivee. Ngiiikidiri vaidi voovoono ngii kieetavai variivo fai aduoo varioo ngii nnaagiainnaa tuanaavai roosiima variaivee. Ngiiikidiri vaidi voovoono ngii tauraavai variivo mmoori vareera ngiaammuauvai roosiima variaivee. ");
INSERT INTO waj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Dee vaidivoono tauraanaavai variinnee? Vaidiivo kati varioo yeennaivaa nnaivonnee? Vara vaidiivo inna yeennaivaa varoo inna mmiivonnee? Na rikiauko vaidiivo kati varioo yeenna nnaivoono tauraanaavai varinoo. Mo neenoo ngii tasipama mmoori vareera ngiaammuauvai roosiima variaunoo. ");
INSERT INTO waj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gioonna kiaapuuya mmoori maisaivaa ni uuduu hama ngia ni pikieeraida mmannammanna aanna ngia ni tasipama variaanoo. ");
INSERT INTO waj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ni Napoova tikiai na gioonna kiaapuuyara diauneema na tinai ngieetama gioonna kiaapu vooyara diaaravai. ");
INSERT INTO waj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Dida vaida na gioonna kiaapuuyara dinara suaivaki ngieeta ni tasipama yeenna nneeda nnoori nneeda ngiingii mmaataiyauvunu varida Isarairaa oyaiya yaakuuvaitana yukukidiri taaramaara kua pinaara dira kieetaya iyara diaaravai. ");
INSERT INTO waj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simoono, vaa a rikiaannannee? Vaidiivo yeenna vuiitaivaa varoo kaanaivaa voovau yapoo nnabaivaa voovau yapaineema Sataango ngii iinno taanaraivaara vaa Anutuuqaa yaparaikio ee-oo tiivai. ");
INSERT INTO waj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sataango i iinno taanaraivo vaikiai a niiyara yaagueeqakiannaivo sa taikaiveera na aiyara yaaku varaunoo. A harurueennaata kava hanigiee ni kuaivaara yaagueeqainna i seenaiya tasipanai fai iya yaagueeqama variaaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","tuduu rikioo Petorooso tunoo: Udaanga-o, vaidiiya oovi nnauvaki i yapaara iikiai fai neetaatama i tasipama kuanaravai. Fai i ruputikiai a putinai fai niitaatama ruputikiai neetama putinaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","tuduu rikioo Yisuuva tunoo: Petorooso, na i kiaa i mmiaunoo. Aanna makee fai hama kakaraivo akua tirainno kinai rikiee fai a taaravoomaneetu niiyara tinara: Hama na inna tauvaivee, tinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kiaa kioo Yisuuva ari ngiaammuauya tunoo: Tauraa na ngii titaaduu ngia ni mmayaayaivaa varada nuau suaivaki ngia sikau rira utuaiyauvaatama yeenna vara rira utuaiyauvaata yuku nnaba vooyauvaatama pikiada nuauduu mminnaa vooyauvai ngiiisi vaunnee? Vara hama ngiiisi vaunnee? tuduu rikiada iya inna sai tunoo: Ai, mo tiisi vairavaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","tuduu rikioo Yisuuva iya tunoo: Aanna makee vaidi voovoono sikau rira utuaivo vaivaata varoo yeenna vara rira utuaivo innasi vaivaatama varoo kuaivee. Vaidi voovoono hama paipaataino ari yaapaivaadiri varoo oro paipa avaikarai voovai yookaama kioo varaivee. ");
INSERT INTO waj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na ngii giaa ngii miaunoo. Anutuuqaa kua fafaaraivo vainno tinoo: Iya inna vitada vaidi maisaiya tasipama kiaavaivee. Anutuuqaa kua fafaaraivo niiyara itaa kua tuuvo makee kaanaivo vakiaivee. Mmuakiaa kuavai niiyara fafaara roovo kaanaivo vakiaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","tuduu rikiada ari ngiaammuauya tunoo: Udaanga-o, taanee. Aakara ari vookarai paipa taaravaitana tiisi vainoo, tuduu rikioo ivo iya tunoo: Inna aikioo, kua taikainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kiaa kioo ivo yoosinnaivaa pikioo viravai. Vioo taapi Oriveeta ivau tupaa ari virayaama vuduu ari ngiaammuauya inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Vuduu ivo oro ivau varuduu ari ngiaammuauya vuduu rikioo ivo iya tunoo: Iinno teeraivo ngii iinno taanaraivo ngiiisi nninarainnoo tida yaaku varaatee, ");
INSERT INTO waj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","kiaa kioo oro kiisama vo kammunnivau toorivu yau haroo yaaku vareeravai. ");
INSERT INTO waj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yaaku varoo varioo tunoo: Napoo-o, i iikiatainai mmuaararaivo aa nnoori toori kapikarai aavaa roosiivo niisi nninaraivaara ooqoo tino pikiaivee. Inna aikioovai. Ni iikiataivaa sa iikianee. Ai iikiataivaa iikianee, ");
INSERT INTO waj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","tuduu rikioo ngiau aapuuvakidiri aangeraa voovoono tuoo inna tasipooduu ivo yaagueeqauduu ");
INSERT INTO waj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","inna pinaama mmuaararooduu inna yaata utiraivo ari vookarauduu yaaku varoo varuduu kaayauma inna kausaivo kiauvaa roosiima tuoo mmataivau viravai. ");
INSERT INTO waj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Vuduu iva yaaku vara taika kioo diitoo ari ngiaammuauyasi kava vara ranoo numa tooduu iya ausaiyauvo mmuaararoovaara iya vuru vaida variravai. ");
INSERT INTO waj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Vuru vaida varuduu Yisuuva iya tunoo: Ngia aaniiraida vuru vakiaannee? Diitada yaaku varaatee. Iinno teeraivo ngii iinno taanaraivo ngiiisi nninarainnoo tida yaaku varaatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yisuuva homo kua tioo varuduu kaayau vaidiiya innasi nniravai. Nnida varuduu Yisuunna ngiaammuau yaakuuvaitana yukukidiri taaramaakidiri voovai nnutuuvo Yutaaso iya tauraa ngioo aataruuvaa iya vitaama roo nniravai. Ngioo ngioo oro Yisuunna vainima duoo vainno inna mmootaanara uuduu too ");
INSERT INTO waj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yisuuva inna tunoo: Yutaaso, a ni mmootaannaivaudiri Na Vaidiivaa Mmaapuuvaa ni nnammutuaiya kooyaa ni vitaakiaannannee? ");
INSERT INTO waj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","tuduu rikiada inna tasipama duuya iya inna iikiaaraivaa teeda inna yaparaida tunoo: Udaanga-o, ti paipa avaikaraiyauvaadiri ta iya ruputuaarannee? ");
INSERT INTO waj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Itaa kua tida rikiada iyakidiri voovoono ari paipaivaadiri Anutuuqaara kati puara hudeera vaidi kieetaivaa ngiaammuau voovai yaata yaadudainniivaa rutaka kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Rutaka kiooduu rikioo Yisuuva tunoo: Aikioo pikiaanee, kiaa kioo ngiaammuauvaa yaataivaa utuoo tuqinneeravai. ");
INSERT INTO waj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tuqinnama kioo Anutuuqaara kati puara hudeera vaidi kieetaiyaatama nuunaira nnauvaara haitatuura vaidiiyaata vaidi yokovaiyaatama Yisuunna utuaara numa ivaki duuya ivo iya tunoo: Ngia niiyara mmuararai vaidivaivee, kiaida paipa avaikaraiyauvaata tipaiyauvaatama utida ni mmaara ngiaannee? ");
INSERT INTO waj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mmuakiaa suai na ngii tasipama nuunaira nnau pinaivaki variee mmayaayaiyauvaa ngii giaa ngii miaaduu hama ngia ni utiravai. Mo inna aikioo, inna aanna ngii suaivovee. Aqaa suai aavaki inna maisai upisiivo rummua apinai iikiaara suaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yisuuva itaa kua tuduu rikiada vaidiiya inna puaisakama utu kiada vaida vitada vida vaidi Anutuuqaara kati puara hudeera kieeta tuanaivaa nnauvaki viravai. Vida varuduu Petorooso ngieeradiri inna nnaagiai vioo varuduu ");
INSERT INTO waj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","gioonna kiaapu vooya vaidi kieeta tuanaivaa vagiaamunna aakiaivaki vida ikiaivaa vuutaivaki hara kiada ivaki varuduu Petoroosootama ivaki iya tasipama variravai. ");
INSERT INTO waj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Varuduu mmoori vareera kiaatanna voovoono Petorooso ikiaivaara hara kioo varuduu inna puaisakama too nnaasu vainno tunoo: Aa vaidi aavootama inna tasipama nuaivaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","tuduu rikioo Petorooso yaagueeqama ooqoo tioo tunoo: Ai, gioonna-o, hama na inna tauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","tuduu nnaagiai kava vaidi voovootama inna too tunoo: Ai, a inna ngiaammuaukuavee, tuduu rikioo tunoo: Ai, vaidi aakua-o, hama na inna ngiaammuauvaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","tuduu rikioo nnaagiai kava vaidi voovootama inna too yaagueeqama innara tunoo: Kutaa tuanaa aa vaidi aavoota inna tasipama nuaivaivee. Ivo Karirayaa diaa vaidivaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","tuduu rikioo Petorooso inna sai tunoo: Ai, vaidi aakua-o, a kianna kuaivaa hama na arinaima rikiauvaivee. Ivo homo kua tioo varuu saivaata kakaraivo akua tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Akua tuduu Udaangaivo hanigia Petoroosaa tooduu tauraa ivo inna kiaa mmuu kuaivaa vaa taunnu kioovaa kava yaata utuoo rikieeravai. Tauraa Udaangaivo inna kiaa mmioo tunoo: Turau hama kakaraa akua tirainno kinai rikiee fai a taaravoomaneetu niiyara tinara: Hama na inna tauvaivee, tinaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iva itaa kua kiaa mmuu kuaivaa kava Petorooso yaata utuoo rikioo mmaanai vioo pinaama rateeravai. ");
INSERT INTO waj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ratooduu vaidiiya Yisuunna utu kiada vaida vooyaano innara raida inna ruputida ");
INSERT INTO waj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","buruqaivaadiri inna oori nnikiivaki hauma utida inna yaparaida tunoo: A mmuakiaa kuavai rikiaannaiyauvaa ti kiaa ti mmianee. Gioonoonno i ruputiinnee? ");
INSERT INTO waj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","kiaa kiada kaayauma inna rakanoo raaranoo tida maisa kua inna tiravai. ");
INSERT INTO waj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Itaa kua tuduu heenanaanna suaivo reera kiooduu Yutayaa vaidi yokovaa mmuakiaaya nuunaida iyakidiri vooya Anutuuqaara kati puara hudeera vaidi kieetaiyaata vooya kua mmaanna kiaa mmiraiyaatama nnida nuunaida inna vitada kua pinaana inna yapeeravai. Yapa kiada iya inna tunoo: ");
INSERT INTO waj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","A Anutuuqo mmataama kioo vaidikuavee tiee ti kiaa ti mmianee, tuduu rikioo ivo iya sai tunoo: Mo fai na ngii giaa ngii minai ngia hama ni kuaivaa rikiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Fai na kua voovai ngii yaparainai ngia hama ni kua saivaa kiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aanna na varira suaivoota nnaagiai na varinara suaivaki Na Vaidiivaa Mmaapuuvo Anutuuqo mmuakiaa yaagueeqaivaa yaataraivaa yaaku yaadudainningiaa hara kiee varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","tuduu rikiada mmuakiaaya tunoo: Mo a Anutuuqaa mmaapukuannee? tuduu rikioo Yisuuva iya sai tunoo: Yo, ngia niiyaraida inna safuuma inna mmaapuvaivee kiaanoo, ");
INSERT INTO waj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","tuduu rikiada iya tunoo: Vaa ari avaivakidiri ivo safuuma tinoo: Na Anutuuqaa mmaapuvaivee, tiivaa vaa teenoo rikiaunnavai. Sa vaidi vooya kava numa innaki kua pinaa yapaaraivaara yaata utuatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kiaa kiada iya mmuakiaaya inna vitada oro Roomaaya kieetaivaa Piratuusaa avuuvau dida vaida ");
INSERT INTO waj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","kua pinaivaki inna yapaaraivaara innara tunoo: Ta taunnano aa vaidi aavo gioonna kiaapuuya unnakua tioo Roomaa kieetaivaa sikau takiisaivaa mmiaivaara ooqoo tioo ariiyara na vaidi kieetavaivee kiaa kioo ariiyara tinoo: Na Anutuuqo mmataama kioo vaidivaivee, tiivaivee, ");
INSERT INTO waj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","tuduu rikioo Piratuuso Yisuunna yaparainno tunoo: Mo a Yutayaiya kieetakuannee? tuduu rikioo Yisuuva inna sai tunoo: Inna a kutaavai kiannanoo, ");
INSERT INTO waj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","tuduu rikioo Piratuuso Anutuuqaara kati puara hudeera kieeta vaidiiyaata gioonna kiaapu kaayau ivaki suvuai kiada varuuyaatama tunoo: Na rikiauko aa vaidi aavo hama vaidi aannoo vaidivaaraida ta inna ruputuaara iikiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","tuduu rikiada kieeta vaidiiya yaagueeqama Piratuusaa vuavi tida tunoo: Ivo kua mmayaayaivaa gioonna kiaapuuya kiaa mmiaa roo nuainnonno Karirayaiya kiaa mmioo tuma mmuakiaa yoosinnaiyauvo Yutayaa mmataivau vaiyauvaki variaiyaatama kiaa mmioo aanna makee tuma gioonna kiaapu aayaatama kiaa mminoo. Ivo iya kiaa mmikiai rikiada ivaara kaayauma kumimakaida ngiari rapu ngiari rapuukiaara iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iya itaa kua tuduu rikioo Piratuuso iya yaparainno tunoo: Aa vaidi aavo Karirayaa diaa vaidivainnee? ");
INSERT INTO waj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","kiaa kioo kieeta vaidi Herooto Yisuuva varuu mmataivaara haitatuuvaara Piratuuso rikioo innasi inna titaa kiooduu viravai. Ii suai ivaki Herooto Yerusareema varuduu iya Yisuunna vitada innasi vuduu ");
INSERT INTO waj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herooto inna too kaayauma innara sirigairavai. Iva hokoba suai varioo Yisuuva uu mmoori aataruuvaa mmayaayaivaa rikioo Yisuuva Anutuuqaa mmoori ari vookara ari vookarauyauvaa uuyauvaa taanaraivaara ivo inna taanaree kiaa iinno varuduu iya inna vitada innasi nnuduu too ivo kaayauma innara sirigairavai. ");
INSERT INTO waj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sirigainno kaayau kua kaayau kuaivaa Yisuunna yaparauduu rikioo hama ivo inna kua sai tirainno kua seemuaa variravai. ");
INSERT INTO waj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kua seemuaa varuduu Anutuuqaara kati puara hudeera vaidi kieetaiyaatama vaidi kua mmaanna kiaa mmiraiyaatama diitada kaayau kua pinaivaa innaki yapeeravai. ");
INSERT INTO waj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yapa kiooduu rikiada Herootoota ari ngiaammuau rapiraiyaatama Yisuunnara nniki rakaida kuasi tududada innara raida variravai. Itaida varida yaapa yoketaivaa innayaa apu kiada kava Piratuusaasi titooduu viravai. ");
INSERT INTO waj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tauraa Herootaya Piratuusooya ngiariiyara ngiariiyara nnannatoovaitana iqii suai ivaki ariiyara ariiyaraida yoketaama variravai. ");
INSERT INTO waj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yoketaama varuduu Piratuuso Anutuuqaara kati puara hudeera kieetaiyaraatama kieeta vaidi gioonna kiaapuuyara diraiyaraata mmuakiaa gioonna kiaapuuyaraatama aayanna tuduu innasi nnida nuunauduu ");
INSERT INTO waj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","iya tunoo: Aa vaidi aavaa ngia vitada niisi nnida kiaanoo: Gioonna kiaapuuya unnakua tii vaidivaivee, kiaani na ngii avuuvau aa vaidi aavaa yaparaina rikiaukai ngia ivo maisa mmooriivaa iivaivee kiaa kiada innaki kua pinaivaa yapa kiaivo hama oyaivootainoo. ");
INSERT INTO waj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herootoota inna yaparainno rikiaikio hama kua oyaivootaikio pikioo kava tiisi titaa kiaikio nninoo. Aa vaidi aavo hama maisa mmooriivaa iivaaraida ta kuminayaa inna ruputikio putuaiveera iikiaunnanoo. ");
INSERT INTO waj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kati na ni ngiaammuauya tinai inna ripiima kikiai na sipuuvaa hatuaa kino tuoo ngiiisi kuaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Vo nuanu vo nuanu buusa Varaigiataivaa nneera suaivaki Piratuuso vaidi voovai oovi nnauvaki varuuvaa titooduu mmaanai viravai.) ");
INSERT INTO waj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ii aataru ivo itaama vauvaara gioonna kiaapuuya mmuaavaugiataama aayanna reeda tunoo: Yisuunna ruputino putuaivee. Paravaasaa mmaanai titano tuoo kuaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tauraa Paravaaso ngiari kieetaiyaata rapuoo vaidi vooya ruputuduu putuuvaara vaidiiya inna vitada oovi nnauvaki yapa kiooduu variravai. ");
INSERT INTO waj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Varuduu Piratuuso Yisuunna mmaanai kuaiveera inna titaatauduu kava gioonna kiaapuuyaata kua tuduu rikiada ");
INSERT INTO waj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","iya puaisakama aayanna reeda tunoo: A tinai iya yatari sagaivau inna haara kiaatee, ");
INSERT INTO waj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","tuduu rikioo Piratuuso kava vooneetu iya tunoo: Mo datainnee? Aanii tomedavai ivo iivainnee? Na tauko hama vaidi aannoo vaidivai ngia innara ni kiaanoo: Ruputino putuaiveeraida kiaanoo. Ivaara na kati tinai ni ngiaammuauya inna ripiima kikiai sipuuvaa hatuaa kino tuoo ngiiisi kuaivee, ");
INSERT INTO waj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","tuduu rikiada gioonna kiaapuuya yaagueeqama mmannammanna aayanna reeda tunoo: A tinai rikiada iya yatari sagaivau inna haara kiaatee, tuduu iya kua pinaama tuuvoono Piratuusaa yaatarooduu ");
INSERT INTO waj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ivo iya inna yaparau kuaivaa rikioo ee-oo tioo Yisuunna ruputuateera tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Paravaaso ngiari kieetaiyaatama rapuoo vaidi vooya ruputuduu putuuvaara vaidiiya inna vitada oovi nnauvaki yapa kiooduu varuu vaidiivaara gioonna kiaapuuya Piratuusaa yaparaududuu titooduu mmaanai tiiravai. Tuuduu Piratuuso iya tuuvaugiataama rikioo Yisuunna vitoo oro iya mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mmuduu Yisuunna vitada vida varida tooduu Kureenaivakinnaa vaidiivaa nnutuuvo Simoono saidi ngioo aataruuvaugiataa yoosinnaivakira nninaree kiaa nnuduu teeda ravaatau inna utida yatari sagaivaa inna kumaata apu kiooduu rikioo Yisuunna nnaagiaivau viravai. ");
INSERT INTO waj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Vuduu kaayau gioonna kiaapuuya inna vata rada vuduu rikiada gioonnainnibaro aataruuvau vida varida isi kuaru kiaa rada rata rada viravai. ");
INSERT INTO waj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Vuduu rikioo Yisuuva hanigia iya tunoo: Yerusareemaa gioonnaso, sa niiyara rataatee. Ngiingiiiyaraata ngiingii nnaakaraiyaraatama rataatee. ");
INSERT INTO waj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Fai suai voovai nninai gioonna kiaapuuya kiaara: Gioonna hama nnaakaraataiya iya yoketaama variaanoo, ");
INSERT INTO waj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","kiaa kiada fai oora taapiiyauvaata kua tida kiaara: Havataama rada ti ruputuatee, kiaa kiada taapi kiisaiyauvaata kua tida kiaara: Mumunu utua rada ti rummua apu kiaatee, kiaaravai. ");
INSERT INTO waj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Na yatari karaasaivaa roosiikiauvaa vaidiiya ni ruputuaavaivee. Fai ngia yatari aasannaiyauvaa roosiikiaiya fai iya ngii dataakiaaravainnee? Mo fai ngiiita ngii ruputuaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iya vaidi taaravaitana mmuara nnaamuruuvaitanaatama vitada Yisuunna tasipama ruputuaara viravai. ");
INSERT INTO waj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Vidada oro yoosinnaivaa nnutuuvo Kieeta Mmuyai ivaki vau yoosinnaivaki oro Yisuunna yatari sagaivau haara kieeravai. Haara kiooduu vaidi maisaivaitanaatama yatari sagaivaitanau haara kiada vuaivaa vitada inna yaaku yaadudainningiaa haara kiada vuaivaa vitada inna yaaku geedainningiaa haara kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Haara kiooduu Yisuuva tunoo: Ni Napoo-o, iya ni iikiaa aataru ivaa hama arinaima teeda rikieerama kiada ni iikiaa ivaa rugaanee, tuduu rikiada rapira vaidiiya isareeda yaatareera mminnaiyauvaa rootu rootuuda varida yaatarooyaano mmuaavai mmuaavai inna uyira rairaiyauvaa vareeravai. ");
INSERT INTO waj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Varooduu gioonna kiaapuuya vainima duuyaano Yisuunna teeda nnaasu vauduu vaidi Yutayaiya kieetaiyaano innara raida tunoo: Ivo ari vo gioonna kiaapuuya vitoo yoketaivau yapaivaivee. Ivo kutaa tuanaa Anutuuqo mmataama kioo vaidivai varioo mo kii ariinoo ari vitoo yoketaivau yapaivee, ");
INSERT INTO waj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","tuduu rikiada rapira vaidiiyaatama innara raida numa inna vainima dida vaida ari vookarau kapikaroo nnooriivaa nnutuuvo vinikaivaa inna mmiaaree kiaa kiada ");
INSERT INTO waj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tunoo: A Yutayaiya kieetakuavee tiee ai vitee yoketaivau yapaanee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Fafaara roovo Yisuunna kieetainningiaa vauvo tunoo: Inna Yutayaiya kieetaivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Vaidi maisa voovai Yisuunna sainainnigiataa haara kioovoono kaayauma Yisuunna rakanoo raaranoo tioo tunoo: A vaidi Anutuuqo mmataama kioo vaidikuavee tiee aitaata tiitaatama ti vitee yoketaivau yapaanee, ");
INSERT INTO waj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","tuduu rikioo vuaivo inna kua sai yaagueeqama tioo tunoo: Hama a Anutuuqaara aatutauma kiee kiannanoo. Eeta mmuaakarai irisaivaa varaannanoo. ");
INSERT INTO waj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ta tete mmoori maisaivaa iikiaunnaivaaraida irisaivaa ta aikiooma varaunnanoo. Aa vaidi aavo kuminayainno varainoo, ");
INSERT INTO waj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","kiaa kioo Yisuunna tunoo: Yisuu-o, a vaidi kieetavai varieennainna kava tieennainna niiyara yaata utuanee, ");
INSERT INTO waj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","tuduu rikioo Yisuuva inna kua sai tunoo: Na kua kutaavai i kiaa i mmiaunoo. Fai makee eetama yoosinna yoketaivau ni tasipama varinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tuduu suaivo ikianna tammauduu mmuakiaa mmatavai heenama kioo vaududuu suaivo hanigiooduu taikeeravai. ");
INSERT INTO waj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Taikaanara uuduu rikioo buruqa pinaivo nuunaira nnau pinaivaki hiruuvo tammaa kereetu varoo saivai sainai vuduu saivai sainai viravai. ");
INSERT INTO waj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Vuduu Yisuuva puaisakama aayanna roo tunoo: Ni Napoo-o, na ni mmannasaivaa titauko aisi kuainoo, kiaa kioo putiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Putuduu vaidi rapiraiya kieetaivo Yisuuva putuuvaa too Anutuuqaara kua yoketaivaa tioo tunoo: Na tauko aa vaidi aavo yoketaa vaidi tuanaavaivee, ");
INSERT INTO waj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","tuduu rikiada mmuakiaa gioonna kiaapuuya ivaa taara nuunauya Yisuuva putuuvaa tooduu iya ausaiyauvo pinaama mmuaararooduu vara ranada ngiari nnauyauvakira viravai. ");
INSERT INTO waj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mmuakiaa gioonna kiaapuuya Yisuunna nnaagiai nuauyaata gioonnaiya Karirayaadiri inna nnaagiai nnuuyaatama ngieeradiri dida vaida ii mmuakiaa aataru inna uu iyauvaa teeravai. ");
INSERT INTO waj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yutayaiya yoosinna voovai nnutuuvo Arimateyaa diaa vaidiivaa nnutuuvo Yoosiipo yoketaama safuuma varioo Anutuuqo gioonna kiaapuuyara diraivaara faannainno variravai. Varuuvoono tauraa vaidiiya Yisuunna ruputuaara kuaivaa yeena rau kiada uu suaivaki iya tasipama varioo hama ee-oo tiravai. ");
INSERT INTO waj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ivo hama ee-oo tuuvoono Piratuusaasi vioo Yisuunna nnabaivaara yaparairavai. ");
INSERT INTO waj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yaparauduu ee-oo tuduu vioo Yisuunna nnabaivaa hitu varoo vioo buruqa poosaivaadiri rurauma varoo oro vaidiiya putikiai hakuaaree kiaa oonauvaa hatata teerama kioovaki inna hairavai. Hama vaidi nnaba voovai ivaki yapeeravaki inna hairavai. ");
INSERT INTO waj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ivo inna hau suaivo kati varira suaivaara teerama kioo suaivai. Kiisama heenauduu ngiari kati varira suaivo nniravai. ");
INSERT INTO waj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nnuuvaara gioonnaiya Karirayaadiri Yisuunna tasipama nnuuyaano Yoosiipaa vata rada Yisuunna mmata nnauvaa teeda aakiaivaki ivo Yisuunna nnabaivaa yapa kioovaata teeda ");
INSERT INTO waj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","kava vara ranada vida heenna suuya suuda yoketaa vuuyauvaata kupu takua suuda yoketaa vuuyauvaatama inna nnabaivau siika kiaaraiyauvaa teerairavai. Teerama kiooduu kati varira suaivo nnuduu teeda ngiari kua mmaanna tuu kuaiyauvaara yaata utida kati variravai, ");
INSERT INTO waj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kati varida vauya patauduu Sudaaqaki suaivo reera kiooduu gioonnaiya suuda yoketaa vuu mminnaiyauvaa vaa teerama kiooyauvaa varada Yisuunna mmata nnauvakira viravai. ");
INSERT INTO waj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Vidada oro tooduu sikau pinaivaadiri mmata nnau keegiaivaki rau kioovaa vaa feena kiooduu mmatayaa vairavai. ");
INSERT INTO waj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Vauduu teeda mmata nnauvaki oro tooduu hama Udaanga Yisuu Kirisiinna nnabaivootauduu iya ivaara ");
INSERT INTO waj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","dida vaida kaayauma yaata utida varida tooduu vaidiivaitana iya buruqaivaitana mmannaammannauvaitana iya vainima dida vauduu ");
INSERT INTO waj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","gioonnaiya kaayauma aatuuda biribiriida ngiari avuuyauvaa mmataivaki kookama kiada teeda vauduu vaidiivaitana iya tunoo: Mo vaidiiya putuaani haira mmata nnauyauvakidiri vaidiivo vaa diitoo kuaivaara ngia aaniira buaama rada nookiaannee? ");
INSERT INTO waj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ivo hama aavaki vainoo. Vaa diitaivaivee. Ivo Karirayaa varuu suaivaki ngii giaa ngii muu kuaivaara kava rikiaatee. ");
INSERT INTO waj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ivo ngii tunoo: Vaidiiya Na Vaidiivaa Mmaapuuvaa ni vitada vaidi maisaiya mmikiai iya yatari sagaivau ni haara kikio rikioo taara suai taikanai voovaki na putuauvakidiri keenaa diitaanaravaivee, tuuvaa kava rikiaatee. ");
INSERT INTO waj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Vaidiivaitana itaa kua tuuvaara iya yaataiyauvo arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Rikiooduu gioonnaiya mmata nnauvakidiri pikiada nnida Yisuunna ngiaammuau yaakuuvaitana yukukidiri mmuaavoota seena gioonna kiaapuuyaatama ngiari teeda rikioo kuaivaa kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ii gioonna iya voovai Makataraa diaa gioonnaivaa nnutuuvo Mariaavaata voovai nnutuuvo Yoqaanootama voovai Yakoopaa kaanaa nnutuuvo Mariaavaata ngiari seena gioonnaiyaatama Yisuunna kua varada nuaira vaidiiya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kiaa mmuduu rikiada iya gioonnaiya kuaiyauvaara sabi kuayauvaivee kiaa kiada rikiadaata pikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pikiooduu Petorooso diitoo seenoo vioo vioo oro mmata nnauvaki mmaanaidiri kookama reeta tooduu mmanna buruqa poosa saabaivo nnaasu ivaki vairavai. Vauduu too kava vara ranoo ngioo itaama vauvaa too rikioovaara ivo pinaama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mmuai suaivaki Yisuunna nnaagiai nuairaivaitana yoosinnaivaa nnutuuvo Emausa Yerusareema vainima vauvakira vida varida ");
INSERT INTO waj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yisuuva putuuvaara ngiari kiaa mmi ngiari kiaa mmiima rada vuduu ");
INSERT INTO waj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yisuuva ivaitana vainima ngioo ivaitana tasipama viravai. ");
INSERT INTO waj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vuduu ivaitana inna taa ruvuyauvuyama teeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tooduu rikioo Yisuuva ivaitana tunoo: Ngia aaniivaaraida ngiingii kiaa mmi ngiingii kiaa mmiima rada nookiaannee? tuduu rikiada ivau dida vauduu ivaitana ausaivaitana kaayauma mmuaararooduu ");
INSERT INTO waj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","voovai nnutuuvo Kerioopaava inna yaparainno tunoo: A mmuaavoono Yerusareema numa variee aataru mmuaararaiyauvaa naura ditara vaidiiya ivaki iikiaiyauvaa hama a tee rikiaannavainnee? ");
INSERT INTO waj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","tuduu rikioo iva sai ivaitana yaparainno tunoo: Mo dee aataruyauvai iya iikiaannee? tuduu rikiada inna sai tunoo: Mo maisa mmooriivaa iya Nasareeta diaa vaidi Yisuunna iikiaavai. Ii vaidi ivo forofetaa tuanaavai. Anutuuqaa avuuvau mmoori ari vookara ari vookaraiyauvaa iinno kua yoketaivaa ti kiaa ti mmuduu ta mmuakiaaya teeda rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Rikiooduu ti kieeta vaidiiyaata Anutuuqaara kati puara hudeera kieetaiyaatama inna vitada Roomaa vaidi kieetaivo ruputuaiveera mmuduu ivo ee-oo tuduu rikiada vaidiiya yatari sagaivau inna haara kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ivo ta Isarairaiya ti kieetavai varinaree tioo ti nnammutuaiya yaataranai ta kati hara kiada variaaraivaara ta yaata utiravai. Vo kua voovootama vainoo. Iya inna ruputuuvo vaa taara suaivaitana taikaikio aanna voomaivo vainoo. ");
INSERT INTO waj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ti seena gioonna vooya ti kiaa ti mmiaa kuaivaara kaayauma ta nnikiaraakiaunnavaivee. Heenanaanna iya vida taavo ");
INSERT INTO waj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Yisuunna mmata nnauvaki hama inna nnabaivo vaivai. Hama vaikiai teeda iya kava vara ranada nnida kiaanoo: Vaa ta taunnani aangeraiya ti kiaanoo: Vaa ivo diitoo varinoo, kiaavaivee, kiaani ");
INSERT INTO waj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ti seena vaidi vooya mmata nnauvaki vida taavo gioonnaiya kiaa kuaivo kutaa tuanaavai vaikiai hama inna taavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tuduu rikioo Yisuuva ivaitana tunoo: Mo ngia taaravaitana hama ngii yaataataivaitanavee. Nnaaruaa vaidi forofetaiya tuu kua mmuakiaa iyauvaara hama ngia akiairaikiai rikiada kutaavaivee kiaavai. ");
INSERT INTO waj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Anutuuqo mmataama kioo vaidiivo mmamma mmuaararoo varoovaudiri yaagueeqa yoketaa ari vookaraivaa varoo varinaraivaara hama ngia arinaima rikiaavaitanannee? ");
INSERT INTO waj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","kiaa kioo Yisuuva Anutuuqaa kua mmuakiaayauvai ivaitana kiaa mmioo tauraa Musiiva fafaara roo kuaivakidiriaata nnaagiai forofetaiya fafaara roo kuaivakidiriaatama innara tuuvaara taaravaitana kiaa mmiaa roo viravai. ");
INSERT INTO waj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Vida varuduu ivaitana vuu yoosinnaivo vainima vauduu too Yisuuva yoosinnaivaa yaataroo kuanee kiaa uuduu ");
INSERT INTO waj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","taaravaitana inna ravaataida tunoo: Vaa suaivo haatapaikio heenainara iinoo. Tuma ti tasipama vuru vakianee, tuduu rikioo ivaitana tasipama nnauvaki viravai. ");
INSERT INTO waj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Vioo ivaitana tasipama varioo yeenna nnaaree kiaa bereetaivaa tu kioo vainno yaaku vara kioo kusii kioo iya mmuduu teeda ");
INSERT INTO waj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","arinaima inna tooduu ivo akiairaama vioo tukaama kieeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Vioo tukaama kiooduu ngiari kiaa mmi ngiari kiaa mmiida tunoo: Ivo aataruuvau tiitaata kua tioo varioo Anutuuqaa kua mmayaayaivaa ti kiaa ti mmikio rikioo mo ti ausaiyauvo ari vookarainoo, ");
INSERT INTO waj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","kiaa kiada mmuai suaivaki diitada Yerusareema kava vara ranada vida tooduu Yisuunna ngiaammuau yaakuuvaitana yukukidiri mmuaavai gioonna kiaapu vooyaatama nuunaida varida ");
INSERT INTO waj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","tunoo: Kutaa tuanaavai Yisuuva vaa diitaivai. Vaa Simoono inna taivaivee, ");
INSERT INTO waj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","tuduu rikiada taaravaitana aataruuvau nuaida Yisuunna teeda vitada oro ngiari nnauvaki varuduu Yisuuva bereetaivaa kusii utuu suaivaki ivaitana inna arinaima too mmayaayaivaa iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kiaa mmida varuduu Yisuuva ariinoo iya tammaivaki dioo vainno tunoo: Ngii ausaiyauvo nuufama vakiaivee, ");
INSERT INTO waj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","tuduu rikiada iya inna teeda yaata utida tunoo: Vaidi mmagiavaivee, kiaa kiada nnikiaraida aatuuravai. ");
INSERT INTO waj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aatuuda varuduu Yisuuva iya tunoo: Ngia aaniira pinaama yaata utuaannee? Ngia aaniira niiyara taara yaata utuaannee? ");
INSERT INTO waj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ni yaakuuvaitana teeda ni yukuuvaitana teeda kiatee: Kutaa ivovee, kiatee. Niiyaa utida taatee. Ngia taavo hama vaidi mmagiaivo itaama vaivaivee. Ni mmuyaivoota mmammaivootama vainoo, ");
INSERT INTO waj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","kiaa kioo ari yuku yaakuuyauvaa iya vitauduu ");
INSERT INTO waj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","teeda pinaama innara sirigauvaara hama innara Yisuuvavee tida homo pinaama yaata utida varuduu Yisuuva iya yaparainno tunoo: Mo ngii yeennaivo aavaki vainnee? ");
INSERT INTO waj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","tuduu rikiada iya vaa tavauvaa hudoovaa inna mmuduu rikioo ");
INSERT INTO waj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","iya avuuyauvunu varoo nneeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nnaa kioo iya tunoo: Na homo ngii tasipama varuu suaivaki aa kua aavaa na ngii giaa ngii miravaivee. Na kiaanoo: Mmuakiaa kua fafaaraivo Anutuuqaa mmaanna kuaivakiaatama forofetaiya kuaivakiaata Saama kuaivakiaatama niiyara tuu kuaivaa kaanaivo vainaravaivee, kiaa kiee na ngii giaa ngii miravaivee. ");
INSERT INTO waj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ivo iya itaa kua kiaa mmuduu rikiooduu iya tinniiyauvo rusituduu Anutuuqaa kua fafaaraivaa arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Rikiooduu Yisuuva vo kuavai iya tunoo: Anutuuqaa kua fafaaraivo vainno tinoo: Fai Anutuuqo mmataama kioo vaidiivo mmamma nniitareeraivaa varoo putuoo taara suaivaitana taikano vooma suaivaki keenaa diitaanaravai. ");
INSERT INTO waj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Diitanai fai gioonna kiaapuuya inna nnutuuvaa rikiaiya inna mmayaayaivaa varada tauraa gioonna kiaapu Yerusareemaiya kiaa mmida nnaagiai vo yoosinna vo yoosinnaiyauvaki variaiya kiaa mmida kiatee: Ngiingii mminnamminnaa maisaiyauvaa pikiada ausa hanigiakio Anutuuqo ngii mminnamminnaa maisaiyauvaa rugaanaravaivee, kiatee. Anutuuqaa kuaivo itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aa kua fafaara aavaa kaanaivaa vaa ngiengieenoo taavaivee. ");
INSERT INTO waj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ni Napoova ngiiini kua kiaa teerama kiaivaa fai neenoo titano ngiiisi tiinaravai. Aa ngia yoosinna pinaa aavaki varida faannaikio ngiau aapuuvakidiri yaagueeqa ari vookaraivo ngiiiyaa tiinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kiaa kioo Yisuuva iyaatama vitoo oro Betaniaa kioo ari yaakuuvaitana vararu utuoo iyara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kua tuoo varuu saivaata Anutuuqo inna vitooduu ivo iya pikioo ngiau aapu viravai. ");
INSERT INTO waj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Vuduu teeda iya ngiari ausa mmuduuyaiyauvaa inna mmida innara kaayauma sirigama rada Yerusareema nniravai. ");
INSERT INTO waj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nnida iya makemakee nuunaira nnau pinaivaki varida Anutuuqaara kua yoketaivaa tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nnaaru hama ngiau mmata uu suaivaki Anutuuqaa tinniivaudiri kuaivaa vara kiaa kookieeraivoono variravai. Kua kiaa kookieeraivoono Anutuuqaa tasipama varioo inna Anutuuqovee. ");
INSERT INTO waj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ari nnaaru tuanaa ivo Anutuuqaa tasipama variravai. ");
INSERT INTO waj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Anutuuqo tuduu kua kiaa kookieeraivoono mmuakiaa mminnamminnaayauvai iiravai. Hama mminnamminnaa vooyauvai ari voovoono iiravai. Ivoono nnaasu iiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Variraivo innaki vairavai. Innaki vauvo tooba roosiima gioonna kiaapuuyani mmeekiaivo teeravai. ");
INSERT INTO waj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mmeekiaivoono heenaivaata mmeekia mmuduu hama heenaivo mmeekiaivaa rummua apiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anutuuqoono vaidiivaa nnutuuvo Yuvuaanaa titooduu ");
INSERT INTO waj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","gioonna kiaapuuya mmeekiaivaara kiaa kookieenaraivaara nniravai. Iya ivo tuu kuaivaa rikiada kutaavaivee kiateeraivaara nniravai. ");
INSERT INTO waj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ivo hama mmeekiavai. Ivo mmeekiaivaara kiaa kookieenaraivaara nniravai. ");
INSERT INTO waj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ivo nnuu suaivaki mmeekia tuanaivoono gioonna kiaapuuya mmeekiaivaa mminaraivo tuoo variravai. ");
INSERT INTO waj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ivo mmataivaa ariinoo iima kioovau tuma ivau varuduu hama gioonna kiaapuuya inna arinaima teeravai. ");
INSERT INTO waj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ivo ari mmata tuanaivau tuuduu hama ari oyaiya innara tuqinneeraida innara ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ooqoo tuduu vooyaano innara tuqinnada innara kutaavaivee tuuya Anutuuqo ari yaagueeqaivaa iya mmioo iyara ni naunna mmaapu tuanaayavee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gioonna kiaapuuya nnaakara mmataaneema hama Anutuuqo ari raunna mmaapuuya itaama mmateeravai. Vaidi mmatayaa diaivo ari iivaugiataama nnaakaraivaa mmataineema hama Anutuuqo ari raunna mmaapuuya mmateeravai. Hameetavee. Anutuuqo ariinoo ari vookaraama iiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Anutuuqaa kuaivaa kiaa kookieeraivo tuma ti tasipama vaidivai hara kioo variravai. Varuduu ta inna oyai ari vookarauvaa taannaduu ari vookarau oyaivaa ari Koovaano ari Mmaapu mmuaavaara tioo mmiravai. Mmuduu kati gioonna kiaapuuyara tuqinneeraivootama kua kutaa tiraivootama innaki suvuairavai. ");
INSERT INTO waj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuvuaano nnoori apiraivoono innara tioo aayanna roo tunoo: Ii vaidi ivaara na tauraa ngii giaa ngii miee kiaanoo: Na hama variaaduu varuuvo ni nnaagiai nninaraivoono vaa ni yaataraivaivee, tiravai. Yuvuaano itaa kua tiravaivee. ");
INSERT INTO waj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kati tiiyara tuqinneera oyaivo ariiki vaivaara ivo mmuakiaa suai mmannammanna mmuakiaaya tiiyara boo tioo nnaasu varivai. ");
INSERT INTO waj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mmaanna tuu kuaivaa Anutuuqo Musiinna kiaa mmuduu Musiivaano gioonna kiaapuuya kiaa mmiravai. Yisuu Kirisiivaano Anutuuqo kati tiiyara yaata utiraivaata kua kutaa tiraivaatama ti vitaivai. ");
INSERT INTO waj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hama gioonna kiaapu voovoono Anutuuqaa taivaivee. Ari Mmaapu mmuaavoono ari Koonnanikaraama mmuaavau inna tasipama variivoono innara kooyaa ti kiaa ti mmioo ti vitaivaivee. ");
INSERT INTO waj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yutayaa vaidi vooya Yerusareemadiri Anutuuqaara kati puara hudeera vaidiiyaata Riviinnakidiri diitoo vaidiiyaatama titooduu Yuvuaano nnoori apiraivaasi numa inna yaparauduu rikioo ivo Yisuunnara ataa kua tiravai. Iya inna yaparaida tunoo: A gioononnee? ");
INSERT INTO waj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","tuduu hama Yuvuaano kua seemuaa varirainno kooyaa iya kiaa mmioo tunoo: Hama na Misiaa vaidi Anutuuqo mmataama kioo vaidiivovee, ");
INSERT INTO waj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","tuduu rikiada kava inna yaparaida tunoo: Ai, mo a dee vaidikuannee? A aanna Irayaavannee? tuduu rikioo ivo iya sai tunoo: Hama na Irayaavavee, tuduu rikiada iya inna tunoo: A forofetaa vaidi ta aiyara faannairaikuannee? tuduu rikioo ivo sai tunoo: Hamavee, ");
INSERT INTO waj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","tuduu rikiada tunoo: Vaidi ti titaani ta ngiaunnaiya ta kava oo kiaa mmiaara kuaivaa ti kiaa ti mmianee. A dee vaidikuannee? Aiyara a dataa kuainna kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","tuduu rikioo Yuvuaano iya sai tunoo: Na koo mmuyai gaanga voovau diee vaina aayanna ree kiaunoo: Udaangaivo ngiaiveera aataruuvaa safuukiateeraivaara na kiaunoo. Nnaaruaa forofetaa vaidi Yisayaava fafaara roo kuaivaa Yuvuaano itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisaiyaano vaidi vooya titooduu nnuuyaano ");
INSERT INTO waj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yuvuaanaa yaparaida tunoo: A aiyara kiannanoo: Na hama Misiaavaivee. Na hama Irayaavavee. Na hama forofetaa ngia niiyara faannairaivovee, kiaa kiee mo aaniira a gioonna kiaapuuya nnoori apuannannee? ");
INSERT INTO waj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","tuduu rikioo Yuvuaano iya sai tunoo: Na mmanna nnooriivaadiri gioonna kiaapuuya apuauvaivee. Ngiiikidiri nnii vaidiivaa hama ngia taavaivee. ");
INSERT INTO waj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ivo ni nnaagiai nninaraivoono vaidi nnoonnavai. Na mmanna vaidi kiisavai. Hama na yopeema mmoori vareera ngiaammuauya roosiima inna yuku nnabaivaitana yeenaivaitana rakuasaa kiee utu radaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yuvuaano nnoori Yorotaanaivaadiri gioonna kiaapuuya apuuvaa sainai yoosinna Betaniaa ivaki iya itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Vauya patauduu Yuvuaano diitoo dioo vainno tooduu Yisuuva innasi ngioo varuduu Yuvuaano innara tunoo: Aavaa Anutuuqaa Puara Sipisiipa Nnaakaraivo nninoo. Gioonna kiaapuuya mminnamminnaa maisaiyauvaa varaanaraivovee. ");
INSERT INTO waj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aqaa vaidi aavaara na tauraa ngii giaa ngii miee kiaanoo: Na hama variaaduu varuuvoono ni nnaagiai nninaraivoono vaa ni yaataraivaivee. ");
INSERT INTO waj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na itaa kua kiaa kiee inna oyaivaa hama na tee rikieeravai. Ngia gioonna kiaapu Isarairaa variaiya na inna kooyaa ngii vitainaraivaara na mmanna nnooriivaadiri numa ngii apiravaivee, ");
INSERT INTO waj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","kiaa kioo Yisuunnara kiaa kookieenno tunoo: Na taaduu Mmannasa Yoketaivo ngiau aapuuvakidiri ngiaamma mirunnaivaa roosuuvoono tuoo tuoo innayaa variravai. ");
INSERT INTO waj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Anutuuqo gioonna kiaapuuya nnooriivaadiri iya apuaneera ni titoovoono tauraa ni tunoo: Fai a teeno Mmannasa Yoketaivo tuma vaidiivaayaa varinaraivo inna ivoono Mmannasa Yoketaivaa gioonna kiaapuuya mminaraivovee, tuuvaa na rikiee homo Yisuunna oyaivaara kumimakama kiee tee ");
INSERT INTO waj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","iva tuuvaa kaanaivaa kooyaa teeravai. Na ngii giaa ngii miaunoo. Ivo Anutuuqaa Mmaapu tuanaivovee. Yuvuaano itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kiaa kioo vauvo patauduu Yuvuaano diitoo kava numa ivau ari ngiaammuauvaitana tasipama dioo vainno ");
INSERT INTO waj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","tooduu Yisuuva ngioo taroo viravai. Ngioo taroo vuduu Yuvuaano inna too vainno innara tunoo: Taatee. Anutuuqaa Puara Sipisiipa Nnaakaraivo aa ngioo kuainoo, ");
INSERT INTO waj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","tuduu rikiada ari ngiaammuauvaitana iva tuu kuaivaa rikiada Yisuunna vata rada inna nnaagiaivau viravai. ");
INSERT INTO waj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Vuduu too Yisuuva hanigia ivaitana inna nnaagiai vuuvaa too ivaitana yapara ruoo tunoo: Mo ngia aaniivaaraida buaama rada ngiaannee? tuduu rikiada ivaitana inna sai tunoo: Ravai-o, a dee nnauvakiinna variannannee? tiravai. Ii nnutu Ravaivavee kiaa nnutu ivaa oyaivo tunoo: Vitaira-o, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tuduu rikioo Yisuuva ivaitana sai tunoo: Numa taatee, tuduu rikiada ivaitana numa ivo varuuvaki teeda inna tasipama varuduu suaivo haatapoo hannauduu rikiada inna tasipama vairavai. ");
INSERT INTO waj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ngiaammuau taaravaitana Yuvuaanaa kuaivaa rikiada Yisuunna nnaagiai vuuvaitana vuaivaa nnutuuvo Adiriaaso. Ivoono Simoono Petoroosaa kataivovee. ");
INSERT INTO waj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Vauya patauduu Adiriaaso tauraa makee tuduu ari vayaanna Simoonaara buaama roo tooduu inna too vauduu too tunoo: Anutuuqo mmataama kiai vaidi Misiaivaa vaa ta taunnano ti too vainoo, tiravai. Misiaa nnutuuvoota Kirisii nnutuuvootama mmuaa oyaivai. ");
INSERT INTO waj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Adiriaaso itaa kua kiaa kioo Simoonaa vitoo Yisuunnasi vuduu Yisuuva inna too tunoo: Aanna a Simoono a Yuvuaanaa mmaapukuavee. I nnutu karaasaivo Kipaasovee. Yisuuvaano itaa kua tiravai. Yutayaiya kuaivakidiri kiaa nnutuuvo Kipaasovee. Ari vo kua Ereengaivakidiri kiaa nnutuuvo Petoroosovee. Nnutu Petorooso kiaivaa oyaivoonno sikau ooravai. ");
INSERT INTO waj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Vauya patauduu Yisuuva Karirayaa kuanee kiaa vioo tooduu Piriipo inna too vauduu too tunoo: Ni nnaagiai ngianee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piriipo Betesaita diaa vaidivai. Ivo Adiriaasooya Petoroosaya yoosinnaivakinnaavai. ");
INSERT INTO waj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Piriipo oro Nataneeraara buaama roo tooduu inna too vauduu too inna tunoo: Musiiva mmaanna tuu kuaivaki fafaara rooduu vaidi forofetaa vooyaatama fafaara roo vaidiivaa vaa ta taunnanoo. Inna nnutuuvo Yisuuvavee. Nasareeta diaa vaidivai. Yoosiipaa mmaapuvaivee, ");
INSERT INTO waj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","tuduu rikioo Nataneero inna yaparainno tunoo: Mo datai mminnaa yoketaavai Nasareetadiri nniivainnee? tuduu rikioo Piriipo tunoo: Ai, numa taanee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kiaa kioo inna vitoo nnuuvaa Yisuuva too Nataneeraara tunoo: Aa vaidi aavo Isarairaa vaidi tuanaavaivee. Hama unnakuaivo innaki vaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","tuduu rikioo Nataneero Yisuunna yaparainno tunoo: Ai, dataama kiee ni taannannee? tuduu rikioo Yisuuva inna sai tunoo: A nnaammuayaivaa oyaivaki variannano hama Piriipo aita kua tirama kiaikiai neenanaa i tauvaivee, ");
INSERT INTO waj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","tuduu rikioo Nataneero inna sai tunoo: Vitaira-o, a Anutuuqaa Mmaapukuavee. A Isarairaiya kieetaikuavee, ");
INSERT INTO waj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","tuduu rikioo Yisuuva inna sai tunoo: A nnaammuayaivaa oyaivaki variannani na i tauvaara i kiaa i mmiaukainna a niiyara kutaavaivee kiannanoo. A makee taannaivaa kiisavai taannanoo. Fai yapooma nnaagiai a kaayau pinaa ari vookaraiyauvaa taanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","kiaa kioo tunoo: Na kua kutaavai i kiaa i mmiaunoo. Fai a teeno ngiauvo vioo sai ngioo sainai idaadiri Na Vaidiivaa Mmaapuuvaa niiyara aangeraiya oro teeda tuma teeda kiaaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yapooma taara suaivaitana taika kiooduu vooma suaivaki Karirayaa aakiaivaki vau kiisa yoosinnaivaa nnutuuvo Kenaa ivaki iya ngiaammuauvaa nnaataivaa varada rummuaara iiravai. Rummuaara iida varuduu Yisuunna kaano ivaki variravai. ");
INSERT INTO waj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ivaki varuduu iya Yisuunnaata ari ngiaammuauyaatama aayanna tuduu yeenna nnaara nniravai. Nnida gioonna kiaapuuya tasipama varida nuunaida yeennaiyauvaa nneedada ");
INSERT INTO waj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","vuaina suuyaivaa nnaa taika kiooduu rikioo Yisuunna kaano inna tunoo: Vaa iya vuaina suuyaivo taikaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","tuduu rikioo inna sai tunoo: Ai, mo aanna a gioonoonna itaa kua ni kiannannee? Hama i mmoorivaivee. Na mmoori nakaaraivovee. Hama ni suaivo nninoo, ");
INSERT INTO waj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","tuduu rikioo kaanoono yeenna mmira ngiaammuauya tunoo: Ivo tiivaugiataama rikiada iikiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yutayaa gioonna kiaapuuya ngiari mmammaiyauvaa finira mmaanna aataruuyauvo airi airi aataruyauvai vairavai. Ivaara pinaa kuu yavaiyauvo yaaku saivai karasaidiri mmuaavai ivau vairavai. Yavaiyauvo hama kiisa paanna yavaayauvai. Hokoba pinaa yavaayauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yisuuva yeennara haitatuuda mmiraiya tunoo: Nnooriivaa vita rada aa yavaa aayauvaki tusaatee, tuduu rikiada vita rada tusooduduu yavaiyauvaa sannaiyauvunu roberobeeduu ");
INSERT INTO waj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yisuuva iya tunoo: Inna aikioo, vita rada oro yeennaiyauvaara haitatuura vaidiivaa mmiatee, tuduu rikiada vita rada oro inna mmuduu ");
INSERT INTO waj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nnoo rikiooduu nnoori tuanaivo vaa hanigioo vuaina suuya tuanaavai vauduu ivo iya vitoovakira hama arinaima teerama kiooduu yeennara haitatuuda mmiraiya arinaima teeravai. Ivo iya vitoovakira hama arinaima toovaara ivo kieevatiivaara aayanna tuduu ");
INSERT INTO waj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nnuduu inna tunoo: Mmuakiaa vaidiiya tauraa yoketaa vuaina suuyaivaa yapa kiaani rikiada nneedada nnaa ausa rasiti varada variaani teeda nnaagiai maisai vuaina suuyaivaa yapaavai. Hama a itaama yapaannanoo. Aanna makee nnaagiainna a yoketaa vuaina suuyaivaa yapaannanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yisuuva Anutuuqaa mmoori ari vookarauvaa Karirayaa aakiaivaki vau yoosinna kiisa Kenaa ivaki tauraa toosa hara iiravai. Ivo ivaki toosa hara uu mmooriivaa uuduu teeda ari ngiaammuauya ivo uu mmooriivaa oyai tuanaa yoketaivaa teeda innara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ivo uu mmooriivo taika kiooduu ivo ari kaanootama ari kataidoota ari ngiaammuaudootama oro kiisa suai Kapanauma variravai. ");
INSERT INTO waj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yutayaiya buusaivaa nnutuuvo Varaigiataivaa iya nneera suaivo vainima nnuduu rikioo Yisuuva Yerusareemara viravai. ");
INSERT INTO waj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Vioo vioo oro nuunaira nnau pinaivaki tooduu ivaki vaidiiya puara burimakau sipisiipaiyauvaata ngiaamma mirunnaiyauvaatama vooya mmida irisai sikauyauvaa varooya hara kiada varida inna tooduu vaidi sikau yanaiyauvaa kiooduu irisai sikau mmuyaiyauvaa mmuuyaatama hara kiada varida inna teeravai. ");
INSERT INTO waj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Inna tooduu rikioo Yisuuva iibanna fiiyama kioovaadiri utuoo iya ripiinno iya puara burimakau sipisiipaiyauvaata ivakidiri ruputuoo vatooduu mmaanai tiida viravai. Vuduu rikioo ivo irisai sikau mmuyaiyauvaa mmuuya parapaaraiyauvaa rauru sereguatiima kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sereguatiima kioo vaidiiya ngiaamma mirunnaiyauvaa kiada irisai sikauyauvaa varooya tunoo: Iyauvaa varada mmaanai kuatee. Sa ngia ni Napoonna nnauvaki irisai irisai vareera aataruuvaa iikiatee, ");
INSERT INTO waj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","tuduu rikiada ari ngiaammuauya yaata utida Anutuuqaa kua fafaara voovai vauvaara iya yaata utida rikieeravai. Fafaaraivo vainno Anutuuqaa nnauvaara tinoo: I nnauvaara ni mmuduuya riraivo ni aakiaivaki kaayauma suvuainoo. Fafaaraivo vainno itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yisuuva itaama uuvaara Yutayaa vaidi vooya inna yaparaida tunoo: Gioono i tikiai a iikiannannee? Dee mmoori ari vookaraivaa fai a iino yoketainai teeda kiaara: Anutuuqo inna tasipaikio rikioo iivaivee, kiaarannee? ");
INSERT INTO waj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","tuduu rikioo Yisuuva iya sai tunoo: Aa nnau aavaa ngia havarata kikiai fai na kava taaravooma suai heeka kiaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","tuduu rikiada iya inna sai tunoo: Ai, hama yopeemavee. Aa nnau aavaa heekoo aataruuvaa vaa ta taunnavai. Taara vaidivaitana yuku yaaku taika kiada vo vaidivai yaaku saivai karasaidiri mmuaa nuanuvai (46) iya heeka taika kieeravai. Fai a aikiooma taaravooma suai heekaanarannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yisuuva hama nuunaira nnau pinaivaara itaa kua tiravai. Ivo ariiyara tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ivaara ivo nnaagiai Anutuuqo inna tuduu putuuvakidiri diitoo suaivaki ari ngiaammuauya iva itaa kua tuu kuaivaa arinaima rikieeravai. Rikiooduu Anutuuqaa kua fafaaraivaaraata Yisuuva tuu kuaivaaraatama kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yisuuva buusa Varaigiataivaa nneera suaivaki Yerusareema nuainno varuduu rikiada iva Anutuuqaa mmoori ari vookarauyauvaa uuyauvaara kaayau gioonna kiaapuuya innara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tuduu Yisuuva gioonna kiaapu mmatayaiya aakiaiyauvaki toovaara iya innara yoketaida kutaavaivee tuuvaara hama iyara inna yoketairavai. ");
INSERT INTO waj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hama vaidi voovoono gioonna kiaapuuya aakiaiyauvaki vau kuaiyauvaa inna kiaa mmiravai. Ivo ariinoo arinaima iya aakiaiyauvaki teeravai. ");
INSERT INTO waj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisai vaidi voovai nnutuuvo Nikotimaaso ivoota Yutayaiyaki kieetavai varuuvo ");
INSERT INTO waj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","heenaki Yisuunnasi vioo tunoo: Vitaira-o, vaa ta taunnavai. Anutuuqo i titaa kiaikiai a tummuannaikua a vitaira mmooriivaa iikiannanoo. Fai vaidi mmatayaa voovoono hama Anutuuqaa yaagueeqaivo inna tasipano rikioo hama Anutuuqaa mmoori ari vookaraivaa a iikiannaneema iinaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","tuduu rikioo Yisuuva inna sai tunoo: Na kua kutaavai i kiaa i mmiaunoo. Fai hama vaidi voovoono hanigioo nnaakara meedi roosiima karaasavai varioo fai hama Anutuuqo gioonna kiaapuuyara diraivaki taanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","tuduu rikioo Nikotimaaso inna sai tunoo: Mo dataama vaidi vaa yokovaa kiaivo kava hanigioo nnaakara meedi roosiima karaasavai varinarannee? Fai ivo kava ari kaanaa ausaivaki varino mmata kino too karaasavai varinarannee? ");
INSERT INTO waj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","tuduu rikioo Yisuuva inna sai tunoo: Na kua kutaavai i kiaa i mmiaunoo. Fai hama vaidi voovoono nnooriivoota mmannasaivootama mmata kiaivo hama Anutuuqo gioonna kiaapuuyara dira yoosinnaivaki kuanaravai. ");
INSERT INTO waj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mmammaivo iikiatai mmooriivo mmammaivaa mmaraavai. Anutuuqaa Mmannasaivo iikiatai mmooriivo Anutuuqaa Mmannasaivaa mmaraavai. ");
INSERT INTO waj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Anutuuqaa Mmannasaivo i mmata kinai rikiee hanigiee nnaakara meedi roosiima varianeera na i kiaa i mmiau kua ivaara sa nnikiaraakianee. ");
INSERT INTO waj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yuunnaivo ari ngiatai suaivaki ivo korokorooma roo nuaikiai a mmanna akuaivaa rikiee hama ivo kuai nniivaa taannanoo. Ivaa roosiima Anutuuqaa Mmannasaivo vaidiivaa iikio too hanigioo karaasavai variivaa hama ta taunnavaivee, ");
INSERT INTO waj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","tuduu rikioo Nikotimaaso inna yaparainno tunoo: Mo datainnee? ");
INSERT INTO waj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","tuduu rikioo Yisuuva inna sai tunoo: A vaidi nnoonnakuavee. A Isarairaa gioonna kiaapuuya vitaira vaidikuavee. Mo aaniira aa kua aavaa oyaivaa hama a tuqinnama rikiaannannee? ");
INSERT INTO waj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na kua kutaavai i kiaa i mmiaunoo. Ti yaatana vai kuaivaata ti avu tai kuaivaatama ta kiaunnani ngia mmuakiaaya hama ti kuaivaa rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na mmatayaa vai mminnaiyauvaara ngii giaa ngii miaukai hama ngia rikiaanoo. Ngiau aapu vai mminnaiyauvaara na ngii giaa ngii minai fai ngia dataama rikiaarannee? ");
INSERT INTO waj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hama vaidi voovoono ngiau aapuuvaki kuaivaivee. Na Vaidiivaa Mmaapuuvoono ivakidiri tummuaivoono vaa neneenoo nnaasu ivaki tauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nnaaru vaidi Musiiva koo mmuyai gaanga yoosinnaivaki unnakua yapaivaa kapaaqaivaadiri iima kioo ngiauvau yatari sagaivau haara kiooneema vaidiiya Na Vaidiivaa Mmaapuuvaa ngiauvau yatari sagaivau ni haara kiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Haara kikio rikioo fai gioonna kiaapu voovoono niiyara kutaavaivee tioo fai tupatupaa variraivaa varaanaravaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anutuuqo mmuakiaa gioonna kiaapu mmatayaiyara pinaama mmuduuya ruoo ari Mmaapu mmuaa tuanaa ivaa titooduu tiiravai. Gioonna kiaapu innara kutaavaivee kiaiya eeyaara putida taikeevoora titooduu tiiravai. Iya tupatupaa variraivaa varaateeraivaara titooduu tiiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ivo ari Mmaapuuvaa mmatayaa titooduu tuoo hama gioonna kiaapuuya kua pinaivaki yapaanaraivaara tiiravai. Iya vitoo aataru yoketaivau yapaanaraivaara tiiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Gioonna kiaapu voovoono innara kutaavaivee tiivaaki hama kua pinaivo innaki vaivai. Gioonna kiaapu voovoono hama innara kutaavaivee tiivaaki vaa kua pinaivo innaki vaivai. Ivo hama innara Anutuuqaa Mmaapu mmuaa tuanaivovee tiivaara kua pinaivo innaki vaivai. ");
INSERT INTO waj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kua pinaivo vaivaa aataruuvo ataama vainoo. Mmeekiaivo vaa mmatayaiyasi tiikiainnaataida iya hama innara mmuduuya ruaanoo. Iya maisa aataruuvaa vaa iida taivaara upisiivaki vai aataruuvaara mmuduuya ruaanoo. ");
INSERT INTO waj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gioonna kiaapu voovoono vaa maisa aataruuvaa iivoono hama mmeekiaivaara mmuduuya ruoo hama innasi nniivai. Mmeekiaivoono ivo maisa aataru iivaa kookieevoora kiaa hama mmeekiaivaasi nniivai. ");
INSERT INTO waj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gioonna kiaapu voovoono kua kutaivaara yaata utuoo iivoono mmeekiaivaasi nniivai. Hama arinaidiri iirainno Anutuuqo tiivaugiataama iivai. Mmeekiaivoono ivo ii mmooriivaa kookieekiaiveera mmeekiaivaasi nniivaivee. Yisuuva itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ii suai ivo taika kiooduu Yisuuva ari ngiaammuauyaatama yoosinna Yutayaivakira viravai. Vidada oro ivakinnaiya tasipama varidada iya nnoori apiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ii mmuai suai ivaki Yuvuaano vo yoosinna Sareema vainima vau yoosinnaivaa nnutuuvo Ainoona ivaki varioo gioonna kiaapuuya nnoori apiravai. Nnoori haruunga pinaivo ivaki vauvaara ivo ivaki iya nnoori apiravai. Gioonna kiaapuuya ivo iya nnoori apuaiveeraivaara mmannammanna innasi nnuduu ivo ivaki iya nnoori apiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hama oovi nnauvaki inna yapaara suaivo nnuduu iiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yutayaa vaidiiya mmamma finira mmaanna aataruuyauvaara Yuvuaanaa ngiaammuau vooyaata Yutayaa vaidi voovaatama pinaama kua yaagueeqama tiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Itaa kua tuuvaara iya Yuvuaanaasi oro inna kiaa mmida tunoo: Vitaira-o, nnaaru vaidi voovai nnoori Yorotaanaa siri sainai i tasipama dioo vauduu a innara iqii vaidi tuanaa ivovee tunnaivo aanna makee ivoono gioonna kiaapuuya nnoori apuoo varinoo. Apuoo varikiai mmuakiaa gioonna kiaapuuya i pikiada innasi kuaanoo, ");
INSERT INTO waj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","tuduu rikioo Yuvuaano iya sai tunoo: Hama giaasidiri gioonna kiaapu voovoono mminnaivaa varaivai. Anutuuqoono mmikio varaivai. ");
INSERT INTO waj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na kiaaduu vaa ngiengieenoo rikieeravai. Na kiaanoo: Hama neenoo vaidi Misiaa Anutuuqo mmataama kioovovee. Anutuuqo inna tauraa niinnaadee titooduu na nniravaivee. Na itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nnaata vaati vareera suaivaki vaatiivo safuuma ari nnaataivaa varaivai. Vaatiivaa seena ngiaammuau voovoono oro inna tasipama diivo innara faannainno varioo kati inna kuaivaa rikiaikio inna yoketaivai. Itaama iivaara ni sirigairaivo niiki vaivo vaa pinaavai vainoo. ");
INSERT INTO waj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Fai ivoono tauraa varino inna nnutuuvo pinaavai kuanaravai. Vinai fai na nnaagiai varino ni nnutuuvo hameetainaravaivee. Yuvuaano itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ivoono ngiau aapuuvakidiri tuuvoono mmuakiaaya yaataraivai. Mmatayaa diaa vaidi voovoono mmata aavau varioo mmata aavau vai mminnamminnaiyauvaara nnaasu kua tiivai. Ngiau aapuuvakidiri tuuvoono mmuakiaaya yaataroo ");
INSERT INTO waj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ari toovaaraata ari rikioovaaraatama tikiai hama gioonna kiaapu voovoono rikiaivai. ");
INSERT INTO waj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Fai gioonna kiaapu voovoono inna kuaivaa tuqinnama rikioo puaisa utino mmoori kaanaivo vainai teeda seena gioonna kiaapuuya kiaara: Anutuuqo kua tiivo kua kutaavai vaivaivee, kiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Anutuuqo titoovoono Anutuuqaa kuaivaa tiivaara iya itaa kua kiaaravai. Anutuuqo Mmannasa Yoketaivaa inna mmikio innaki suvuaikio Anutuuqaa kuaivaa tiivai. ");
INSERT INTO waj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ari Koovaano ari Mmaapuuvaara kaayauma mmuduuya ruoo inna tinoo: Mmuakiaa mminnaiyauvaara na diauneema eenoo dianee, tiivai. ");
INSERT INTO waj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gioonna kiaapu voovoono inna Mmaapuuvaara kutaavaivee tiivoono vaa tupatupaa variraivaa varaivai. Gioonna kiaapu voovoono inna Mmaapuuvaa kuaivaa hama rikiaivoono fai hama tupatupaa variraivaa varaanaravai. Anutuuqaa nnannateeraivo fai tupatupaa innayaa vainaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yisuuva gioonna kiaapuuya nnoori apuduu inna nnaagiai nuauyaano Yuvuaanaa nnaagiai nuau gioonna kiaapuuya yaataroo kuaivaa Farisaiya rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mo hama Yisuuva ariinoo nnoori apiravai. Ari ngiaammuauyaano nnaasu nnoori apiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iva uu mmooriivaa Farisaiya rikioovaara Yisuuva rikioo diitoo ari ngiaammuauyaatama Yutayaa mmataivaa pikiada kava vara ranada Karirayaa mmataivakira viravai. ");
INSERT INTO waj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iya Karirayaa vuu aataruuvau kuaaree kiaa kiada Samariaa mmataivaa vuutaidaadiri viravai. ");
INSERT INTO waj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Vidada oro ivaki vau yoosinna voovai nnutuuvo Sukaraa ivaki viravai. Nnaaru Yakoopo ari mmaapuuvaa Yoosiipaa mmuu mmataivo vainima vauduu ");
INSERT INTO waj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakoopo hanuu kioo doofa nnooriivo ivaki vauduu ikianna tammauduu Yisuuva aataru hokobaivau nnududuu inna pirisauduu doofa nnooriivaa siriivau hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Vaa ari ngiaammuauya nnida tarada yoosinnaivaki vida sikaunnaadiri yeennaiyauvaa yookaakiaara vida kieeravai. Vida kiooduu Yisuuva ivau hara kioo varioo tooduu gioonna Samariaa voovai nnooriivaa vitaanara nnuduu too Yisuuva inna tunoo: Nnooriivaa vita niita ni mianee, ");
INSERT INTO waj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","tuduu rikioo Samariaa gioonnaivo inna sai tunoo: Ai, a voopinnaa Yutayaakuavee. Nene vo Samariaa gioonnavai. Aanna a dataama kieennainna nnoorira ni yaparakiannannee? tiravai. Yutayaa gioonna kiaapuuyaata Samariaa gioonna kiaapuuyaatama makemakee ngiariiyara ngiariiyara nnannateera tasipama varuuvaara gioonnaivo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yisuuva inna kua sai tunoo: Anutuuqo gioonna kiaapuuya kati mmii aataruuvaa vaa a arinaima tee rikiee na nnoorira i yaparakiauvaa ni oyaivaa arinaima tee ni yaparakiannatiri. Na nnoori ari vookaraivaa i mmiautiri. A ivaa nnee tupatupaa variraivaa varaannatirivee, ");
INSERT INTO waj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","tuduu rikioo inna sai tunoo: Yokeera-o, hama a nnoori toori vitaanaraivootainoo. Nnooriivo hokoba soopavaki varinoo. A deevakidiri tupatupaa hara kioo varii nnooriivaa vitaanarannee? ");
INSERT INTO waj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ti nnaakuva Yakoopoono aa doofa nnoori aavaa hanuu kioo ivo ari mmaapuudoota ari puaraidootama nneeda kioovaa ti mmiravai. Iva nnoonna vaidivai variravai. A inna yaataraannakuannee? ");
INSERT INTO waj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","tuduu rikioo Yisuuva inna sai tunoo: Gioonna kiaapu voovoono aa nnoori aavaa nnaa kino fai kava inna nnoori rainaravai. ");
INSERT INTO waj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gioonna kiaapu voovoono na inna mminara nnooriivaa nnaa kino fai hama kava inna nnoori rainaravai. Nnoori na inna mminaraivo fai inna aakiaivaki nnoori rumuruuma roosiima tupatupaa varinono fai ivo tupatupaa variraivaa varaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","tuduu rikioo gioonnaivo inna sai tunoo: Yokeera-o, mo aa nnoori aavaa ni mianee. A ni minai na nnaa kiee fai hama kava ni nnoori rainai hama kava aavakidiri na numa vita ree nnaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yisuuva inna kiaa mmioo tunoo: Mo oro ai vaatiivaara aayanna tino i tasipama ngiaivee, ");
INSERT INTO waj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","tuduu rikioo gioonnaivo inna sai tunoo: Hama na vaatiaataivaivee, tuduu rikioo Yisuuva inna sai tunoo: A hama na vaatiaataivaivee kiannaivo kutaavai kiannanoo. ");
INSERT INTO waj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Vaa a yaaku saineetu vaati varaannavai. Aanna a makee vaidiivaa tasipama variannaivo hama i vaativai. A kutaavai kiannavaivee, ");
INSERT INTO waj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","tuduu rikioo ivo inna sai tunoo: Yokeera-o, vaa na tauvai. A forofetaakuavee. ");
INSERT INTO waj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ni nnaakukiaiya aa taapi aavaudiri ngiari ausa mmuduuyaiyauvaa Anutuuqaa mmiravai. Ngia Yutayaa vaidiiya kiaanoo: Yerusareema nuunaira nnau pinaivaki nnaasu ngiingii ausa mmuduuyaiyauvaa Anutuuqaa mmiatee, kiaavaivee, ");
INSERT INTO waj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","tuduu rikioo Yisuuva inna sai tunoo: Rikiaanee. Fai suai voovai nninai hama ngia gioonna kiaapuuya aa taapi aavaunnaata Yerusareemaivakiriaatama ngiingii ausa mmuduuyaiyauvaa ni Napoonna mmiaaravai. Fai sabisaabi mmuakiaa yoosinnaiyauvakidiri inna mmiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ngia gioonna kiaapu Samariaiya hama ngia ngiingii ausa mmuduuyaiyauvaa mmiraivaa oyaivaa arinaima teeda rikiaavai. Ta gioonna kiaapu Yutayaiya titi ausa mmuduuyaiyauvaa mmiaunnaivaa oyaivaa aikiooma ta teeda rikiaunnavai. Titiikidiri Anutuuqo tino gioonna kiaapuuya vitoo yoketaivau yapaanaraivo nniivai. ");
INSERT INTO waj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gioonna kiaapuuya kutaa tuanaa ni Napoonna ausa mmuduuya mmiraiya ngiari ausaiyauvakidiri kua kutaa tida ngiari ausa mmuduuyaiyauvaa mmiaara suaivo fai nninaravai. Ai, vaa nninoo. Ni Napoova gioonna kiaapuuya kua kutaa tida ngiari ausa mmuduuyaiyauvaa inna mmiaaraiyara buainno varinoo. ");
INSERT INTO waj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutuuqo inna mmannasavai. Fai gioonna kiaapuuya ngiari ausa mmuduuyaiyauvaa Anutuuqaa mmiaaraiya ngiari ausaiyauvakidiri kua kutaa tida ngiari ausa mmuduuyaiyauvaa inna mmiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tuduu rikioo Samariaa gioonnaivo inna sai tunoo: Vaa na rikiauvai. Misiaa vaidivai Anutuuqo inna mmataama kioovo fai nninaravai. Iya innara Kirisiivavee kiaivo fai nninaravai. Ivoono ngioo mmuakiaa mmooriivaara ti kiaa ti mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","tuduu rikioo Yisuuva inna sai tunoo: Mo na aita kua kiau aavo inna na ivoona iikiaunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yisuuva itaa kua tuu saivaata ari ngiaammuauya kava vara ranada nnida tooduu Yisuuva gioonnaivaata kua tioo varuduu teeda nnikiarairavai. Nnikiaraida hama voovoono gioonnaivaa tunoo: Aaniira a ngiannannee? tuduu hama voovoono Yisuunna tunoo: Aaniira innaata kua kiannannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hama itaa kua tuduu rikioo gioonnaivo ari nnoori tooriivaa pikioo kava vara ranoo vioo vioo oro yoosinnaivaki gioonna kiaapuuya kiaa mmioo tunoo: ");
INSERT INTO waj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Vaidi voovoono mmuakiaa mmoori na iikiauvaa kooyaa ni giaa ni miivaa numa taatee. Ivo Misiaivonnee? ");
INSERT INTO waj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","tuduu rikiada gioonna kiaapuuya yoosinnaivaa pikiada Yisuunna taara nniravai. ");
INSERT INTO waj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Iya nnida varuduu Yisuunna ngiaammuauya inna vuavi tida tunoo: Vitaira-o, yeenna nnaanee, ");
INSERT INTO waj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","tuduu iva iya sai tunoo: Na nnaanara yeennaivaa hama ngia taanoo, ");
INSERT INTO waj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","tuduu ari ngiaammuauya ngiari yapara ngiari yaparaida tunoo: Vaa vaidi voovoono yeennaivaa varoo inna mmiinnee? ");
INSERT INTO waj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","tuduu Yisuuva iya tunoo: Ni titeeraivoono niiyara tii kuaivaa na rikiee ivo mmoori ni muuvaa na iinana taika kino rikioo inna ni yeennavai. ");
INSERT INTO waj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ngia mmuakiaaya kiaanoo: Fai kuraaga taarama taarama taikanai yeenna kaanaivo nneeravaata vainai ta varaaravaivee, kiaavai. Na ngii giaa ngii miee kiaunoo. Yeenna mmooriiyauvaki tuqinnama haitatuuma taatee. Ngia varaateeraiyauvo vaa aikiooma kaanainno nneeravaata vainoo. ");
INSERT INTO waj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mmoori vareera vaidiivo ari mmoori varaivaa irisai kaanaivaa safuuma varoo sirigaivai. Ivaa roosiima ta gioonna kiaapuuya tupatupaa variraivaa varaateeraivaara ta iya vitada sirigakiaunnavai. Yeenna kaanaivaa vareera suaivaki yeenna hauvaa utiraiyaata yeenna kaanaivaa vareeraiyaatama mmuaavaugiataama sirigakiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ivaara nnaaru tuu kua voovai tunoo: Vaidi voovoono mmooriivaki yeenna hauvaa utikio voovoono kaanaivaa varaivaivee. Itaa kua tuuvo kutaa kuavai. ");
INSERT INTO waj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngia hama mmoori vareeraivaki na ngii titaukai ngia yeenna kaanaivaa vareeraiyavee. Ngiari vooyaano ivaki mmoori varoovakidiri ngia iya mmoori kaanaivaa varooyavee. Yisuuva mmatayaa diaa mminnaivaudiri mmataama kioo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariaa gioonna kiaapuuya yoosinna Sukaraa varuuya ii gioonna ivo tauraa vaa iya kiaa mmioo tunoo: Mmuakiaa mmoori na iikiauvaa ivo kooyaa ni giaa ni mivaivee, tuuvaara kaayau gioonna kiaapuuya ngiari ausaiyauvaa hanigiada Yisuunnara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Itaa kua tuuvaara iya innasi nnuu suaivaki yaagueeqama inna tunoo: Ti tasipama varianee, tuduu Yisuuva iya tasipama taara suai variravai. ");
INSERT INTO waj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Varuduu ivo iyaata kua tuu kuaivaara kaayau vooyaano ngiari ausaiyauvaa hanigiada innara kutaavaivee tida ");
INSERT INTO waj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","gioonnaivaa tunoo: Aanna vaa ta ausa hanigiada innara kutaavaivee kiaunnavai. Hama a kiannaivaara ta iikiaunnanoo. Iva kuaivaa ti kiaa ti mmikiai ta rikiaunnaivaara iikiaunnanoo. Vaa ta rikiaunnavai. Iva kutaa mmuakiaa gioonna kiaapu mmatayaa variraiya vitoo yoketaivau yapaanaraivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yisuuva iya tasipama varuu suaivaitana taika kiooduu ivo diitoo Karirayaara viravai. ");
INSERT INTO waj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Vaa ivo tauraa ariiyara tunoo: Vaidi forofetaivaara mmuakiaa yoosinnaiya innara yoketaakiaani ari yoosinna tuanaiya hama innara yoketaakiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ivo Karirayaara vioo vioo oro tooduu gioonna kiaapuuya innara sirigairavai. Vaa iyaata Yerusareemaivaki vida buusaivaa nnutuuvo Varaigiataivaa nneera suaivaki iva uu mmooriivaa taa kioovaara iya innara sirigairavai. ");
INSERT INTO waj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Innara sirigaida varuduu Yisuuva yoosinna kiisaivaa nnutuuvo Kenaa tauraa ivo ivaki nnoori tuanaivaadiri vuaina suuyaivaa uuvakira kava viravai. Vioo vioo oro varuduu Kapanaumaa vaidi kieeta voovoono ivaki hara kioo varuduu ari mmaapuuvo nniitaroo homo Kapanauma variravai. ");
INSERT INTO waj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ii kieeta vaidi ivo Yisuuva Yutayaa mmataivaa pikioo Karirayaa mmataivaki nnuu kuaivaa rikioo oro inna yaparainno tunoo: Kapanauma ivaki tiee ni maapuuvo kiisa suai putinara iivaa tuqinnaanee, ");
INSERT INTO waj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","tuduu rikioo Yisuuva inna tunoo: Fai ngia mmuakiaaya hama mmoori ari vookara ari vookaraivaa teeda hama ngia niiyara kutaavaivee kiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","tuduu rikioo vaidi kieetaivo tunoo: Yokeera-o, ni maapuuvo putivoora tiee akiairainai ni tasipama tummuanee, ");
INSERT INTO waj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","tuduu rikioo Yisuuva inna tunoo: Kuanee. Fai i mmaapuuvo diitoo kati hara kioo varinaravaivee, tuduu ivo Yisuunna kuaivaara kutaavaivee kiaa kioo vioo vioo ");
INSERT INTO waj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","oro tooduu ari mmoori varoo ngiaammuauya saidi nnida inna tunoo: Vaa i mmaapuuvo diitoo kati hara kioo varinoo, ");
INSERT INTO waj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","tuduu rikioo iva iya yaparainno tunoo: Dee suaivau inna nniitaraivo pikiaivainnee? tuduu rikiada iya inna sai tunoo: Nau ikianna tammaa i mmaapuuvaa ikiayanaivo taikaivaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Iqii suai ivau Yisuuva tunoo: Fai i mmaapuuvo diitoo kati hara kioo varinaravaivee, tuuvaa koova rikieeravai. Rikioo ivoota ari mmuaa nnauvaki varuuyaatama innara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yisuuva Yutayaa mmataivaa pikioo numa Karirayaa mmataivaki varuuvo Anutuuqaa mmoori ari vookarau voovai vaa tauraa iima kioo ivaa nnaagiaivau iqii mmoori ivaa iiravai. ");
INSERT INTO waj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yutayaiya buusa nneera suaivo vainima vauvaara Yisuuva Yerusareemara viravai. ");
INSERT INTO waj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusareema vagiaamunna keegia voovai nnutuuvo Puara Sipisiipaiya keegiavai vairavai. Ii keegia ivaa vainima vau nnoori haruungaivaa nnutuuvo Yutayaiya kuaivakidiri Betasataa vauduu nnau haaya yaaku saivai ivaa siriivau vairavai. ");
INSERT INTO waj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Vauduu kaayau gioonna kiaapu mmammaiyauvo maisauya iyauvaki vairavai. Gioonna kiaapu avu huruutauyaatama mmudanna rauyaata yuku yaaku putuuyaatama iyauvaki vairavai. (Iyauvaki vaida varida nnooriivo korokoroonaraivaara faannaida variravai. ");
INSERT INTO waj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Varuduu vo suai vo suai Udaangaivaa aangeraa voovoono tuoo nnooriivaki vuduu nnooriivo korokorooduu vaidiivaa mmammaivo maisauvo tauraa nnooriivaki vuuvaa mmammaivo yoketauduu nniravai.) ");
INSERT INTO waj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iya nnau haayaiyauvaki vauduu vaidi voovoono kaayau nuanu (38) nniitaroo nnaasu varuu mmanna mmuyai vaidiivootama iyauvaki vauduu too ");
INSERT INTO waj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yisuuva Yerusareema vioo ivaki inna too ivo kaayau suai ivaki varuuvaara arinaima rikioo inna yapara ruoo tunoo: I nniitaraivo taikaanaraivaara i yoketainnonnee? ");
INSERT INTO waj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","tuduu rikioo inna sai tunoo: Yokeera-o, nnooriivo korokorookiai rikiee kiaunoo: Dee vaidi voovoono ni sootu utuoo nnoori haruunga korokoroovaki ni yapaanarannee? kiaa kiee tauko hameetainoo. Na airineetu kuanaree tiee iina variee taukai vaidiiya ni yaatarada ngiari nnaasu nnoori haruungaivaki makemakee kuaavaivee, ");
INSERT INTO waj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","tuduu rikioo Yisuuva inna tunoo: Diitee ai kegeennaivaata varee kuanee, ");
INSERT INTO waj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","tuduu rikioo makee tuduu inna nniitaroovo taikooduu diitoo ari kegeennaivaata varoo viravai. Ii suai ivaki Yutayaiya kati varuu suaivo vairavai. ");
INSERT INTO waj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Vauduu Yutayaa vaidiiya nookiannaivaara mmamma tuqinnoo vaidiivaa tunoo: Aanna ta kati varira suaivai. Ai kegeennaivaata varee vaa a ti mmaanna tira kua aataru voovai hatokaannanoo, ");
INSERT INTO waj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","tuduu rikioo iya sai tunoo: Vaidi ni tuqinnaivoono ni tinoo: Ai kegeennaivaata varee kuanee, tikiai na varee ngiaunoo, ");
INSERT INTO waj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","tuduu rikiada iya inna yaparaida tunoo: Mo gioono i tinoo: Ai kegeennaivaata varee kuanee, tikiai a varee ngiannannee? ");
INSERT INTO waj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Iya itaa kua tuduu rikioo mmamma tuqinnoo vaidiivo Yisuunnara yaata vueennairavai. Gioonna kiaapuuya ivaki suvuau kioovaara Yisuuva ari voodaa vioo kiooduu vaidiivo innara yaata vueennama kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nnaagiai Yisuuva nuunaira nnau pinaivaa aakiaivaki tooduu mmamma tuqinnoo vaidiivo inna too vauduu too inna tunoo: Taanee. Vaa i mmammaivo yoketainoo. Tauraa a maisama variannavai. Nnaagiai maisa aataru pinaivo ivaa yaataraivoono aisi vainoora sa kava mminnamminnaa maisaivaa varaanee, ");
INSERT INTO waj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","tuduu rikioo ivaki pikioo vioo Yutayaa vaidiiya kiaa mmioo tunoo: Vaidiivaa nnutuuvo Yisuuvaano ni tuqinnaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","tuduu vaidi Yutayaiya ngiari kati varira suaivaki Yisuuva Anutuuqaa mmoori ari vookara ari vookarauyauvaa uuvaara ii suai ivaki toosa hara inna mmaara iiravai. ");
INSERT INTO waj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iida varuduu Yisuuva iya tunoo: Ni Napoova mmoori varoo varikiai neeta mmoori varee variaunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ivo itaa kua tuuvaara iya kaayauma inna ruputu kiaara iiravai. Vaa ivo tauraa iya kati varira suaivaki aataru voovai hatokoo nnaagiai Anutuuqaara ni Napoovavee tioo Anutuuqaa roosiima mmuaakaraama varuuvaara iya inna ruputu kiaara iiravai. ");
INSERT INTO waj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Inna ruputu kiaara uuduu Yisuuva iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Na inna Mmaapuvai variee hama na yopeema nenenaidiri mmoori vooyauvai iikiauvai. Ni Napoova iinno varii mmooriiyauvaa na tee iyauvaa nnaasu na iikiauvai. Ni Napoova ii mmooriiyauvaa na inna Mmaapuuvootama iikiauvai. ");
INSERT INTO waj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ni Napoova niiyara mmuduuya riivaara mmuakiaa mmoori ari iiyauvaa ni vitaivai. Ngia teeda nnikiaraakiateera ivo vo mmoori vooyauvai tauraa ni vitai mmooriiyauvaa yaataraanara mmooriiyauvaa fai ni vitainaravai. ");
INSERT INTO waj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ni Napoova vaa putuuya tikiai diitada hara kiada variaaneema na inna Mmaapuuvootama ni iikiatainai gioonna kiaapuuya na iinai fai iya tupatupaa variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Hama ni Napoova ariinoo gioonna kiaapu voovai kua pinaana yapa kioo yaparaivai. Kua pinaana yapa kioo yaparaira mmoori aataru mmuakiaavai vaa ari Mmaapuuvaa ni mivaivee. ");
INSERT INTO waj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Gioonna kiaapuuya kua yoketaivaa ni Napoonnara kiaaneema na inna Mmaapuuvaara niiyaraatama kua yoketaivaa kiateera ni Napoova kua pinaana yaparaira aataruuvaa ni mivaivee. Hama gioonna kiaapu voovoono na inna Mmaapuuvaa niiyara kua yoketaivaa tioo hama ni Napoova ni titoovaaraatama kua yoketaivaa tiivai. ");
INSERT INTO waj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu voovoono ni kuaivaa tuqinnama rikioo ni titoovaara kutaavaivee tiivoono tupatupaa variraivaa vaa varaivaivee. Fai hama ivo kua pinaivaki varinaravaivee. Vaa aikiooma putiraivaa iva yaatara kioo tupatupaa variraivaa varaivaivee. ");
INSERT INTO waj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na kua kutaavai ngii giaa ngii miaunoo. Suai voovai fai nninaravai. Ai, mo vaa aavaa nninoo. Fai hama ausa hanigieeraida putiraiya roosiima variaiya na Anutuuqaa Mmaapuuvaa ni kuaivaa rikiada arinaima rikiaiyaano fai aikiooma tupatupaa variraivaa varaaravai. ");
INSERT INTO waj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tupatupaa variraivaa oyaivo ni Napoova ni mikio innaki vaineema na inna Mmaapuuvaa niiki vaivai. ");
INSERT INTO waj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na Vaidiivaa Mmaapuvai variauvaara ivo kua pinaivaara dianeera ni tikiai na diauvai. ");
INSERT INTO waj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sa ivaara ngia nnikiaraakiatee. Ii suai ivo nninai rikiada vaa putuduu hau kiooya ni kuaivaa rikiada ");
INSERT INTO waj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mmata nnauvakidiri diitaaravai. Vooya vaa yoketaa mmoori varooya diitada tupatupaa variaaravai. Vooya maisa mmoori varooya diitakio kua pinaivaki iya yapa kinai ngiari mmoori maisaiyauvaa irisaiyauvaa varaaravai. ");
INSERT INTO waj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Hama na yopeema nenenaidiri mmooriivaa iikiaunoo. Anutuuqo kua ni giaa ni miivaugiataama na kua pinaivaara diee vaina iikiaunoo. Hama nini iikiatai mmooriivaa na iikiaunoo. Ivo ni titoovaa inna iikiatai mmooriivaa na iikiaunoo. Ivaara kua pinaivaki ni kuaivo safu tuanaavai vainoo. ");
INSERT INTO waj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Fai neneenoo nenenaidiri niniiyara kua voovai tino fai ni kuaivo hama kaanainaravai. ");
INSERT INTO waj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ari voovoono niiyara kuaivaa tiivo varinoo. Vaa na rikiaunoo. Ivo niiyara tii kuaivo kutaavai vainoo. ");
INSERT INTO waj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ngia Yuvuaanaa kuaivaa rikiaaraivaara vaidiiya titooduu innasi vuduu ivo niiyara kua kutaivaa tuuvaa vaa ngia rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vaidi mmatayaa voovoono niiyara kua kutaivaa tiivaa hama ni rikiaatainoo. Anutuuqo ngii vitoo aataru yoketaivau ngii yapa kiaiveeraivaaraina Yuvuaano niiyara kua kutaivaa tiivaara kati na itaa kua kiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuvuaano ngia toobaivaa subi kiaavo too ruvuaaheeraivaa roosiima varuduu ngia innara aikioovaivee tida inna mmeekiaivau kiisa suai varida inna kuaivaara sirigairavai. ");
INSERT INTO waj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ni mmooriiyauvoono Yuvuaano niiyara tuu kuaivaa yaataraivai. Ni mmooriiyauvaa ni Napoova ni muduu na iima taika kiaa mmooriiyauvoono ni oyaivaa kooyaa vitaikiai teeda gioonna kiaapuuya kiaanoo: Ari Koovaano inna titaa kiaikio tiivaivee, kiaavai. ");
INSERT INTO waj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni Napoova ni titoovoono ariinoo niiyara tiivai. Ngia hama inna kuaivaa rikiada hama inna viri nnikiivaa taavai. ");
INSERT INTO waj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ivo ni titooduu na tummuaivaara ngia hama kutaavaivee kiaivaara hama inna kuaivo ngiiiki vainoo. ");
INSERT INTO waj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ngia Anutuuqaa kua fafaaraivaa makemakee yaarida yaata utida kiaanoo: Ta ivaa yaarida tupatupaa variraivaa varaaravee, kiaa iikiaanoo. Ii kua fafaara ivo niiyara tikiainnaata ");
INSERT INTO waj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","mo ngia tupatupaa variraivaa varaaraivaara hama niiyara kutaavaivee kiaa kiada hama niisi nnida ivaa varaanoo. ");
INSERT INTO waj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Vaidiiya niiyara yoketaavee kiaiya kuaivaa hama na rikiauvai. ");
INSERT INTO waj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Vaa na ngii tauvaivee. Ngia hama Anutuuqaara mmuduuya ruaivaa vaa na tauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na ni Napoovaano ni titooduu na tummuaivaa hama ngii ausaiyauvo ni varainoo. Fai ari vo vaidi voovoono arinaidiri tiivoono nnino fai ngii ausaiyauvo inna varaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ngia ngiingiiiyara ngiingiiiyara yoketaavaivee kiaivaara sirigakiaanoo. Anutuuqo mmuaavoono ngiiiyara yoketaavee tiivaa hama ngia ivaa varaara iikiaanoo. Itaama vaikiai mo ngia dataama innara kutaavaivee kiaarannee? Hama yopeemavee. ");
INSERT INTO waj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ngia sa yaata utuatee. Hama na ngii mmaara kuaivaa ni Napoonnaata kua tinaravai. Nnaaru varuu vaidi Musiiva ngii tuqinnaanaraivaara ngia yaata utida ivaa puaisakama utuaanoo. Fai ivoono ngii mmaara kuaivaa tinaravai. ");
INSERT INTO waj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngia ivo tuu kuaivaa rikiada kutaavaivee tutiri. Ni kuaivaaraatama rikiada kutaavaivee kiaatirivee. Ivoono niiyara fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngia hama ivo fafaara roo kuaivaa rikiada kutaavaivee kiaatiri. Dataama kiada ni kuaivaaraatama rikiada kutaavaivee kiaatirinnee? Yisuuvaano Yutayaiyaata itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yisuuva ii kua ivaa kiaa taika kiooduu nnaagiai vo suai voovaki ari ngiaammuauyaatama kanuuvaki karada nnoori Karirayaa vuai nnutuuvo Tiperiaa nnoori haruungaivaa karada sainai viravai. ");
INSERT INTO waj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Vuduu teeda kaayau gioonna kiaapuuya Yisuunna nnaagiai viravai. Iva Anutuuqaa mmoori ari vookara ari vookarauyauvaa iinno nniitarooya tuqinnooduu toovaara iya inna nnaagiai viravai. ");
INSERT INTO waj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Vuduu Yisuuva ari ngiaammuauyaatama nnoori sainai taapiivau karada ivau variravai. ");
INSERT INTO waj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ii suai ivaki Yutayaiya buusa Varaigiataivaa nneera suaivo vainima vairavai. ");
INSERT INTO waj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Vauduu Yisuuva tooduu kaayau gioonna kiaapuuya innasi nnida varuduu ivo Piriipaa tunoo: Aa gioonna kiaapu kaayau aaya yeenna nnaaraivaa ta deevakidiri varaunnannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yisuuva Piriipaa iinno taanaree kiaa inna itaa kua tiravai. Vaa ivo iinaraivaa ariinoo too rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Piriipo inna kua sai tunoo: Fai ta kaayau sikauyauvaadiri yaaku vaidivaitana yuku yaaku taika kiada (200) yookaama kiada yeennaiyauvaa varada kikiai iya kiisa kiisama nnaasu nnaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","tuduu ari ngiaammuau voovai Simoono Petoroosaa kataivaa nnutuuvo Adiriaaso Yisuunna tunoo: ");
INSERT INTO waj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Aa ngiaammuau aavau dioo vai aavo bereeta yaaku saivai utu kioo tavau taaravaitanaatama utinoo. Dataama mmuakiaa gioonna kiaapu aavaki variaa aaya iyauvaa nnaarannee? ");
INSERT INTO waj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","tuduu rikioo Yisuuva tunoo: Gioonna kiaapuuya tikiai variatee, tuduu rikiada kaayau ferefuruunnaiyauvo ivau vauyauvunu hara kiada variravai. Varuduu teeda vaidiiya nnaasu yaaruduu kaayau (5000) ivau variravai. ");
INSERT INTO waj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Varuduu Yisuuva bereetaiyauvaa tu kioo vainno Anutuuqaata kua yoketaivaa kiaa kioo ari ngiaammuauya mmuduu gioonna kiaapuuya hara kiada varuuya mmiravai. Mmi kiooduu Yisuuva tavauvaitanaatama mmuaikaraama kioo iya mmuduu iya nnaataama utuuvaara nneeravai. ");
INSERT INTO waj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nnooduduu iya ausaiyauvo rasituduu rikioo Yisuuva ari ngiaammuauya tunoo: Yeenna nneeda kiaa arai yatiiyauvaa rupi nuunama yapaatee. Iya yeenna saiyauvai nnaa unaageenama pikiaarainnoo, ");
INSERT INTO waj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","tuduu rikiada iyauvaa rupi nuunama kiada yeenna bereeta yaaku saivai nneeda kioo arai yatiiyauvaa rupi nuunama utua yaakuuvaitana yukukidiri taarama rummua yapa kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yapa kiooduu teeda Yisuuva Anutuuqaa mmoori ari vookarauvaa uuvaa gioonna kiaapu ivaki varuuya teeda tunoo: Forofetaa voovai mmatayaa tiinaraivo kutaa tuanaa aanna ii vaidi ivovee, ");
INSERT INTO waj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","tuduu Yisuuva too rikiooduu iya nnida inna puaisa utida vitada kieeta vaidivai inna yapaaree kiaa uuduu rikioo ivo arivana taapiivaura keenaa viravai. ");
INSERT INTO waj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Vuduu hannainno varuduu rikiada ari ngiaammuauya nnoori haruungaivakira tiida ");
INSERT INTO waj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","siriivaudiri ngiari kanuuvaa varada nnoori sainai kava vara ranada Kapanaumara nniravai. Nnida varuduu heenauduu Yisuuva hama akiairaama kioo iyasi nniravai. ");
INSERT INTO waj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hama nnuduu yuunna yaamurukaivo nnooriivaa rummua ketekaatooduu ");
INSERT INTO waj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ari ngiaammuauya yatari sagaiyauvaa utida nnooriivaa ruvuatia rada nnoori vuutaivau nnida varida tooduu Yisuuva nnoori verenoovau raa roo iyasi ngioo ngioo kanuuvaa vainima nnuduu teeda ari ngiaammuauya kaayauma aatuuravai. ");
INSERT INTO waj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aatuuda varuduu rikioo Yisuuva iya tunoo: Sa aatuukiatee. Na ngiaunoo, ");
INSERT INTO waj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","tuduu rikiada iya innara sirigaida tunoo: Mo kanuu aavaki karee ngianee, tuduu ivaki karoo varinee tuu saivaata vaa iya yaata utua rada kuaaree kiaa vuu yoosinnaivaki kanuuvo numa diravai. ");
INSERT INTO waj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Vauya patauduu kaayau gioonna kiaapuuya homo nnoori haruunga siri sainai hara kiada varuuya yaata utida kiaanoo: Nau ta taunnano mmuaa kanuuvai nnaasu ivau vaivai. Yisuuva hama ivaki karoo ari ngiaammuauya tasipama kuaivaivee, kiaa kiada ivaara vaa iya arinaima teeda rikieeravai. Ari ngiaammuauya inna pikiada iyananaa vuuvaa vaa iya arinaima teeda rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Teeda rikiada varida tooduu vaidiiya yoosinna Tiperiaadiri ngiari kanuuyauvaa varada nniravai. Nnida Udaanga Yisuuva yeenna bereetaiyauvaa Anutuuqaata kua yoketaivaa kiaa kioo gioonna kiaapuuya mmuduu nnoovau vainima nnida ivau iiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iida varuduu gioonna kiaapu ivaki varuuya Yisuunnaraata ari ngiaammuauyaraatama buaama rada tooduu hama iya teeda vauduu teeda iyaatama sunada kanuuyauvaki karada Kapanaumara Yisuunnara buaama rada viravai. ");
INSERT INTO waj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Vidada nnoori haruunga siriivau oro tooduu Yisuuva iya too vauduu teeda inna tunoo: Vitaira-o, a daira suai ngiannakuainna numa aavau diannannee? ");
INSERT INTO waj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","tuduu rikioo ivo iya sai tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Ngia yeenna bereetaiyauvaa nneeda tooduu ngii nnaataama utuduu nnoovaaraida ngia niiyara buaama rada ngiaanoo. Hama na Anutuuqaa mmoori ari vookarauvaa iikiaaduu ngia toovaaraida ngia niiyara buaama rada ngiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yeenna nneeraiyauvo uudainaraiyauvaara sa mmoori varaatee. Yeenna ari vookaraivo tupatupaa vairaivaara mmoori varaatee. Ii yeenna ivaa fai Na Vaidiivaa Mmaapuuvoono ngii minaravai. Ni Napoova Anutuuqoono ni mmataama kioo fai a aikiooma ni mmooriivaa iinarakuavee tuuvaara na ngii minaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","tuduu rikiada iya inna yaparaida tunoo: Mo ta dee mmoorivai iida fai Anutuuqaa mmooriiyauvaa iikiaarannee? ");
INSERT INTO waj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","tuduu rikioo Yisuuva iya sai tunoo: Aa na tinara kua aavo inna Anutuuqaa mmoorivai. Ivo titoo vaidiivaara kutaavaivee kiatee, ");
INSERT INTO waj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","tuduu rikiada iya inna sai tunoo: A dee mmoori ari vookaraivai iinai fai ta teeda a itaa kua kiannaivaara kutaavaivee kiaarannee? E aanii mmoorivai iinarannee? ");
INSERT INTO waj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ti taato nnaakukiaiya koo mmuyai gaanga yoosinnaivaki varuduu yeennaivaa nnutuuvo menaivo tuuduu nneeravai. Ivaara Anutuuqaa kua fafaaraivo vainno tinoo: Ivo ngiau aapuuvakidiri yeennaivaa kiooduu tuuduu nneeravaivee. Fafaaraivo itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","tuduu rikioo Yisuuva iya sai tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Musiiva hama ngiau aapuuvakidiri tiira yeennavai ngii miravaivee. Ni Napoovaano yeenna tuanaivaa ngiau aapuuvakidiri ngii mivaivee. ");
INSERT INTO waj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Anutuuqo ngii mii yeennaivo inna ivo ngiau aapuuvakidiri tuoo tupatupaa variraivaa gioonna kiaapu mmatayaa variaiya mmiivovee, ");
INSERT INTO waj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","tuduu rikiada iya inna yaparaida tunoo: Udaanga-o, ii yeenna ivaa mmannammanna ti mmianee, ");
INSERT INTO waj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","tuduu rikioo ivo tunoo: Mo neenoo aanna yeennaivovee. Fai gioonna kiaapuuya aa yeenna aavaa nneeda tupatupaa variraivaa varaaravaivee. Gioonna kiaapu voovoono niisi nniivoono fai hama niiyara inna yeenna rainaravai. Gioonna kiaapu voovoono niiyara kutaavaivee tiivoono fai hama niiyara inna nnoori rainaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Vaa na tauraa ngii giaa ngii miaukainnaata ngia ni teedaataida hama ngia niiyara kutaavaivee kiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Gioonna kiaapu Anutuuqo ni minaraiya fai mmuaavai mmuaavai niisi ngiaaravai. Niisi nnikiai fai hama na iyara ooqoo tinaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Hama nini iikiatai mmooriivaa iinaraivaara na ngiau aapuuvakidiri tiiravai. Ni titoovaa inna iikiatai mmooriivaa na iinaraivaara ngiau aapuuvakidiri na tiiravai. Ivaaraina na hama iyara ooqoo tinaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ni titoovaa inna iikiatai mmooriivo ataama vainoo. Gioonna kiaapu iva ni miiya fai na hama voovai pikieeraina iya puaisa utuee yapooma nnaagiai suaivaki iya tinai rikiada diitada tupatupaa variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ni Napoonna inna iikiatai mmoori voovai ataama vainoo. Gioonna kiaapu mmuakiaaya na inna Mmaapuuvaa ni teeda niiyara kutaavaivee kiaiya fai tupatupaa variraivaa varaaravai. Fai yapooma nnaagiai suaivaki na iya tinai rikiada diitada tupatupaa variaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Vaa Yisuuva ariiyara tunoo: Yeennaivo ngiau aapuuvakidiri tuuvo neenoovee, tuuvaara Yutayaa vaidiiya innara hanigiaanigieera kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iya tunoo: Ai, aa vaidi aavo Yoosiipaa mmaapu Yisuuvavee. Vaa ta inna kaano koovaitana taunnavaivee. Mo aanna dataama kioonno ivo tinoo: Na ngiau aapuuvakidiri tiiravaivee, tiinnee? ");
INSERT INTO waj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","tuduu rikioo Yisuuva iya tunoo: Sa niiyara hanigiaanigieera kua kiatee. ");
INSERT INTO waj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hama gioonna kiaapu voovoono yopeema kati niisi nninaravai. Ni Napoova ni titoovoono yamayamaa kua tinono ivo numa di numa diima roo ngioo ngioo niisi nninaravai. Ivo nninai fai yapooma nnaagiai suaivaki na tino rikioo diitoo tupatupaa varinaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nnaaruaa forofetaiya roo kuaiyauvaki vo kuavai vainno tinoo: Gioonna kiaapu mmuakiaaya fai Anutuuqo kuaivaa iya kiaa mmioo iya vitainaravaivee. Kua fafaaraivo vainno kuaivo itaa kua tiivai. Gioonna kiaapu mmuakiaaya mmuaavai mmuaavai ni Napoonna kuaivaa arinaima rikiada iva iya vitai aataruuvaa arinaima taiya fai niisi ngiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hama gioonna kiaapu voovoono ni Napoonna taivaivee. Neenoo Anutuuqaasidiri tummuaivoono nnaasu ni Napoonna tauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu voovoono ausa hanigioo niiyara kutaavaivee tiivoono tupatupaa variraivaa vaa varaivaivee. ");
INSERT INTO waj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngia yeennaiyauvaa nnaa kiada variaivaa roosiima neenoo ngii yeennavai variaunoo. ");
INSERT INTO waj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nnaaru koo mmuyai gaanga mmataivau Anutuuqo ngiau aapuuvakidiri yeennaivaa nnutuuvo menaivaa ngii taato nnaakukiaiyani yapa kiooduu nnaa kiada varida nnaagiai putiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mo aa yeenna aavo ngiau aapuuvakidiri tiivaa fai gioonna kiaapu voovoono nnaivo hama putinaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aa yeenna aavo ngiau aapuuvakidiri tiivo variraivaa oyaivo neenoovee. Fai gioonna kiaapu voovoono aa yeenna aavaa nnaivoono fai tupatupaa varinaravai. Aa yeenna aavaa na inna mminaraivo inna ni mmammavai. Gioonna kiaapu mmuakiaaya tupatupaa variateera fai na putuee ni mmammaivaa iya mminaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tuduu rikiada Yutayaa vaidiiya yaagueeqama ngiari yapara ngiari yaparaida tunoo: Mo dataama kioo aa vaidi aavo ari mmammaivaa ti mminai ta nnaarannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yisuuva iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Fai ngia hama Na Vaidiivaa Mmaapuuvaa ni mmammaivaata ni kiauvaatama nneekio rikioo fai hama tupatupaa variraivo ngiiiki vainaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Gioonna kiaapu voovoono ni mmammaivaata ni kiauvaatama nnaivoono vaa tupatupaa variraivaa varaivaivee. Fai itainnonno yapooma suai nnaagiai na tino kava diitaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ni mmammaivo inna yeenna tuanaa nneeraivovee. Ni kiauvo inna nnoori tuanaa nneeraivovee. ");
INSERT INTO waj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Gioonna kiaapu voovoono ni mmammaivaa nnoo ni kiauvaa nnaivoono ni tasipama varikiai na innaki variaunoo. ");
INSERT INTO waj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ni Napoova tupatupaa variraivoono ni titooduu na tiiravai. Ivo varikiaira tiee na variaunoo. Na variauvaara fai gioonna kiaapu voovoono ni nnaivo fai tupatupaa varinaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mo aa yeenna aavo ngiau aapuuvakidiri tiivo inna neenoovee. Aa yeenna aavo hama ngii taato nnaakukiaiya nnoo yeennaivaa roosiivaivee. Iya ivaa nneeda nnaagiai putiravai. Fai gioonna kiaapu voovoono aa yeenna aavaa nnoo fai tupatupaa varinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yisuuva Kapanauma nuunaira nnauvaki gioonna kiaapuuya kua mmayaayaivaa kiaa mmuu suaivaki ari putinaraivaara ivo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yisuunna nnaagiai nuau gioonna kiaapu kaayauya iva tuu kuaivaa rikiada tunoo: Aa kua aavaa ta rikiaunnano mmuaararai kuavai. Mo deeyaano aikiooma rikiaarannee? Hama ta yopeema rikiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","kiaa kiada Yisuunna kuaivaara iya itaama yaata utida hanigiaanigieera kuaivaa tuduu inna aakiaivo vaa rikieeravai. Rikioo ivo iya tunoo: Ii na kiau kua ivaa ngia rikiaavo ngii pikiaatainnee? ");
INSERT INTO waj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Fai itaikiai Na Vaidiivaa Mmaapuuvo keenaa nene tummuaivakira vinai rikiada fai ngia teeda dataakiaarannee? Fai ni kuaivaara kutaavaivee kiaarannee? ");
INSERT INTO waj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anutuuqaa Mmannasaivoono vaidi variraivaa vaidiivaa mmiivaivee. Nnabaivoono mmanna nnabavaivee. Na kiau kua aavo Mmannasaivaa roosiivai. Fai tupatupaa variraivaa ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Na itaa kua kiaukai rikiada ngia hama vooya niiyara kutaavaivee kiaavaivee. Yisuuva itaa kua tiravai. Vooya hama innara kutaavaivee kiaaraiyara vaa Yisuuva tauraa rikieeravai. Vaidi voovoono inna nnammutuaiya kooyaa iya inna vitainaraivaaraatama vaa tauraa ivo arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yisuuva vo kua voovaata iya kiaa mmioo tunoo: Ivaaraina vaa na ngii giaa ngii miee kiaunoo: Fai Anutuuqo hama gioonna kiaapu voovai aakiaivaa yuruuno too fai hama niisi nninaravaivee, kiaunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yisuuva itaa kua tuuvaara inna nnaagiai gioonna kiaapu kaayau nuauya inna pikiada ngiari toovau viravai. ");
INSERT INTO waj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Vuduu Yisuuva iya vuuvaa too ari nnaagiai nuaira ngiaammuau yaakuuvaitana yukukidiri taarama tunoo: Ngieeta ni pikiada ngii kuatainnee? ");
INSERT INTO waj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","tuduu Simoono Petorooso inna sai tunoo: Udaanga-o, mo ta deevaasi kuaarannee? I kua kutaivo tupatupaa varira aataruuvaa kooyaa ti vitaivai. ");
INSERT INTO waj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aanna makee ta aiyara kutaavaivee kiaa kiada a Yoketaa Tuanaikua Anutuuqaasidiri tuuvaara ta rikiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","tuduu Yisuuva iya sai tunoo: Na yaakuuvaitana yukukidiri taarama ngii mmataama kiauvai. Mo ngiiikidiri voovai mmagia maisavai varinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Simoono vuai nnutuuvo Isariootaa mmaapuuvaa Yutaasaara Yisuuva itaa kua tiravai. Yisuunna ngiaammuau yaakuuvaitana yukukidiri taarama varuuvakidiri Yutaasoono Yisuunna nnammutuaiya kooyaa inna vitainaraivovee. ");
INSERT INTO waj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yisuuva iyaata kuaivaa kiaa taika kioo Karirayaa mmataivau nuairavai. Yutayaa vaidiiya inna ruputu kiaara uuvaara hama Yutayaa mmataivau inna kuatauduu Karirayaa mmataivau nnaasu nuairavai. ");
INSERT INTO waj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ii suai ivaki Yutayaiya buusa voovai nneera suaivo vainima nniravai. Ii buusa ivaa nnutuuvo Unnakua Nnauvaa buusavai. Ngiari taato nnaakukiaiya koo mmuyai gaangaivau nuaida varida unnakua nnauyauvaki varuuvaara yaata utida buusaivaa nneeravai. Iqii buusa ivo vainima nnuduu ");
INSERT INTO waj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yisuunna kataido inna tunoo: Aa mmata aavau pikiee Yutayaa mmataivaki kuanee. Gioonna kiaapuuya i nnaagiai nuairaiya ee iira mmooriiyauvaa taateeraivaara kuanee. ");
INSERT INTO waj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vaidi voovai ari nnutuuvo ngiau aapu kuanaraivaara hama ari mmooriivaa hatainaravai. Ii mmoori ee iikianna iyauvaa iinaree tiee iinna mmuakiaa gioonna kiaapuuya vitaakianee. ");
INSERT INTO waj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ari kataido itaa kua kiaa kiada hama innara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yisuuva iya tunoo: Na kuanara suaivo hama nninoo. Ngia kuaara suaivo sabi suaivai. ");
INSERT INTO waj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Gioonna kiaapu mmatayaa diaiya ngiiiyara mmuduuya ruaavai. Mo hama niiyara mmuduuya ruaavai. Na kooyaa ngiari mmoori maisaiyauvaa iya vitaakiauvaara iya niiyara nnannataavai. ");
INSERT INTO waj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ngiengie buusa nnaara kuatee. Ni suaivo hama vaama nniivaara hama na ii buusa ivakira kuanaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ivo itaa kua kiaa kioo Karirayaa ivaki hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hara kioo varuduu ari kataido buusa nnaara vida kiooduu Yisuuva varioo ivootama nnaagiai viravai. Hama ivo kooyaa virama kioo hatauma viravai. ");
INSERT INTO waj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Buusa nneera aakiaivaki Yutayaa vaidiiya innara buaama rada nuaida tunoo: Deevakiinno variinnee? ");
INSERT INTO waj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","tuduu gioonna kiaapuuya innara ngiari avuki ngiari avukiida murumuru tuduu vooyaano tunoo: Yoketaa vaidivaivee, tuduu vooyaano tunoo: Hamavee. Ivo gioonna kiaapuuya unnakua tioo varivaivee, ");
INSERT INTO waj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","tuduu Yutayaa vaidiiyara iya aatuuvaara hama gioonna kiaapu voovoono kooyaa innara tiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hama kooyaa innara tuduu buusa nneera suai saivai homo vauduu Yisuuva nuunaira nnau pinaivaki vioo gioonna kiaapuuya kua kiaa mmioo variravai. ");
INSERT INTO waj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kiaa mmioo varuduu rikiada Yutayaa kieetaiya kaayauma nnikiaraida tunoo: Aa vaidi aavaa hama vitaira voovoono inna vitaivai. Mo dataama kioo ari vo kua ari vo kuaivaa ti kiaa ti mmiinnee? ");
INSERT INTO waj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","tuduu rikioo Yisuuva iya sai tunoo: Aa na ngii giaa ngii miau kua aavo hama ni kuavai. Anutuuqo ni titoovaa kuavai. ");
INSERT INTO waj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Na ngii giaa ngii miau kuaivaa nenenaidiri yaata utuee ngii giaa ngii miaunnee? Vara Anutuuqo ni giaa ni mii kuavaina na ngii giaa ngii miaunnee? Ngia ivaara yaata utuaanoo. Rikiaatee. Fai gioonna kiaapu voovoono Anutuuqaa yaata utiivaugiataama mmooriivaa iinaree tioo fai ivo niiyara arinaima too rikioo tinara: Ivo Anutuuqo inna kiaa mmuu kuaivaa tiivaivee, tinaravai. ");
INSERT INTO waj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Vaidi voovoono arinaidiri kuaivaa tioo ariiyara yaata utuoo ni nnutuuvo ngiau aapu vakiaiveera tiivai. Neenoo ni titoovaara yaata utuee ni titoovaa nnutuuvo ngiau aapu vakiaiveera tiee kutaa kuaivaa nnaasu tiee hama unnakuaivaa kiauvai. ");
INSERT INTO waj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nnaaru Musiiva mmaanna tuu kuaivaa vaa ngii giaa ngii miravai. Mo ngia mmuaavai mmuaavai ivaa rikiadaata hatoka kiada hama safuuma variaavai. Ngia aaniira ni ruputu kiaara iikiaannee? ");
INSERT INTO waj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","tuduu rikiada gioonna kiaapu ivaki nuunauya inna tunoo: Mmagia maisaivo i aakiaivaki hara kioo varinoo. Hama ta i ruputu kiaara iikiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","tuduu rikioo Yisuuva iya sai tunoo: Na mmuaa mmoori ari vookaraivaa kati varira suaivaki iikiaukai ngia teeda nnikiaraakiaavai. ");
INSERT INTO waj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musiiva mmamma hatokoo aataruuvaa ngii miravai. Ai, hama Musiinnasidiri nniivai. Ngii rubu tabeeyakidiri nniivai. Mo mmaanna tuu aataruuvaudiri ngia ngii nnaakara meedi mmaapuuya suai yaaku saivai karasaidiri taaravooma suaivo nnikiai iya mmammaiyauvaa kati varira suaivaki hatokaavai. ");
INSERT INTO waj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Musiiva tuu kuaivaa hatokeevoora kati varira suaivakiaatama ngia nnaakaraiya mmammaiyauvaa hatokaavai. Ngia itaama iikiaani na kati varira suaivaki vaidiivaa mmamma eyommaavai tuqinnauvaara aaniira niiyara ngii ausaiyauvo nnannatainnee? ");
INSERT INTO waj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sa kuminayaa vaidiivaa teeda vaida kua pinaivaa innaki yapaatee. Kua oyaivaara tuqinnama yaata utida safuuma kiada innaki kua pinaivaa yapaatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tuduu rikiada Yerusareema diaa gioonna kiaapu vooyaano tunoo: Aa vaidi aavaa iya ruputu kiaara iikiaa vaidiivonnee? ");
INSERT INTO waj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ai, taatee. Ivo kooyaa iya tasipama kua tioo varikiai hama iya inna kiaanoo. Vaa ti kieetaiya arinaima inna teeda kiaanoo: Aanna Anutuuqo mmataama kioo vaidiivovee, kiaannee? ");
INSERT INTO waj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Anutuuqo mmataama kioo vaidiivo nnino rikioo hama gioonna kiaapu voovoono ivo nniivaki taanaravai. Aa vaidi aavo nniivaki vaa ta taunnavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yisuuva nuunaira nnau pinaivaki homo kuaivaa iya kiaa mmioo varioo kooyaa tunoo: Vaa ngia kutaa tuanaa ni taayannee? Vaa ngia na tummuaa yoosinnaivaki taayannee? Hama na nenenaidiri tiiravai. Ni titoovoono inna kutaavai. Hama ngia inna taavai. ");
INSERT INTO waj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Vaa na inna tauvai. Ivo ni titooduu na innasidiri tummuaivaara vaa na inna tauvaivee, ");
INSERT INTO waj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","tuduu rikiada vaidiiya inna utuaara uuduu inna suaivo hama nnuuvaara hama vaidi voovoono inna utiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hama utuduu iya nuunauvaki varuu gioonna kiaapu vooyaano innara kutaavaivee kiaa kiada tunoo: Anutuuqo mmataama kioo vaidi nninaraivoono aa vaidi aavo Anutuuqaa mmoori ari vookara ari vookaraiyauvaa iiyauvaa hama yopeema yaataraanaravaivee. Aanna ii vaidi ivovee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tuduu rikiada Farisai vaidiiya gioonna kiaapuuya Yisuunnara itaa kua murumuru tuu kuaivaa rikiada iyaatama Anutuuqaara puara kati hudeera vaidi kieetaiyaatama nuunaira nnauvaara dira vaidiiya titooduu Yisuunna utuaara iiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yisuuva vaidi Farisaiya tunoo: Fai na homo kiisama ngii tasipama vari kiee ni titoovaasi kava kuanaravai. ");
INSERT INTO waj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Fai na vinai ngia niiyara buaidada teekiai hama na ngii tee vainaravai. Na oro varinaraivaki hama ngia yopeema kuaaraivaara ngia niiyara buaidada teekiai hama na ngii tee vainaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","tuduu rikiada Yutayaa vaidiiya ngiari kiaa mmi ngiari kiaa mmiida tunoo: Hama ta inna taateera tiivo ivo deenataa kuanarainno tiinnee? Ivo Yutayaa gioonna kiaapuuya ari voopinnaa Ereenga yoosinnaivaki variaiyasi vioo Ereengaiya kiaa mminara kuanarannee? ");
INSERT INTO waj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ivo tinoo: Ngia niiyara buaidada teekiai hama na ngii tee vainaravai. Na oro varinaraivaki hama ngia yopeema kuaaravaivee, tiivo ari dee kuavainno tiinnee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Iya Unnakua Nnauvaa buusaivaa nneera suaiyauvo vakia roo vioo vioo taikaanara suaivo pinaa suaivai vairavai. Ii suai ivaki Yisuuva diitoo puaisakama tunoo: Gioonna kiaapu voovoono inna nnoori raino niisi ngioo nnoori nnaivee. ");
INSERT INTO waj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Anutuuqaa kua fafaaraivo vainno tinoo: Gioonna kiaapu voovoono niiyara kutaavaivee tiivaakidiri nnoori rumuruumaivo tiineema fai yoketaa nnooriivaa vaidiivo nnoo tupatupaa varira nnooriivo fai innakidiri mmannammanna tiinaravaivee. Fafaaraivo itaa kua tiivaivee. ");
INSERT INTO waj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yisuuva gioonna kiaapuuya innara kutaavaivee kiaiya Mmannasa Yoketaivaa varaaraivaara itaa kua tiravai. Ii suai ivaki Anutuuqo ari yoosinna ari vookarauvaki hama Yisuunna vita yapoovaara hama Mmannasa Yoketaivaa titooduu tiiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gioonna kiaapu vooyaano iva tuu kuaivaa rikiada tunoo: Aa vaidi aavo kutaa forofetaa vaidi ta innara faannairaivovee, ");
INSERT INTO waj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","tuduu vooyaano tunoo: Ivo Anutuuqo mmataama kioo vaidiivovee, tuduu vooyaano tunoo: Ai, hama Anutuuqo mmataama kioo vaidiivo Karirayaivakidiri nninoo. ");
INSERT INTO waj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anutuuqaa kua fafaaraivo vainno tinoo: Fai Anutuuqo mmataama kioo vaidiivo Davuitiinna oyaivakidiri diitaanaravai. Davuitiiva varuu yoosinnaivaa nnutuuvo Pitiriheemaivaki kaano ivaki variivoono inna mmataanaravaivee. Fafaaraivo itaa kua tiivaivee, ");
INSERT INTO waj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","tuduu rikiada Yisuunnara vooyaano vo yaata utiravai yaata utuduu vooyaano ngiari voovaugiataama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Itaama uuvakidiri vooyaano inna utuaaree kiaa uuduu hama voovoono inna utiravai. ");
INSERT INTO waj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hama inna utuduu rikiada nuunaira nnauvaara dira vaidiiya kava vara ranada Anutuuqaara kati puara hudeera kieeta vaidiiyaata Farisaiyaatama iyasi vuduu teeda iya yaparaida tunoo: Mo ngia aaniira hama inna utu kiada vaida vitada aapi ngiaannee? ");
INSERT INTO waj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","tuduu rikiada iya sai tunoo: Ai, mo ta rikiaunnano tauraa hama vaidi voovoono aa vaidi aavo tii kua aavaa roosiima tiivaivee, ");
INSERT INTO waj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","tuduu rikiada Farisaiya iya tunoo: Ivo ngiiitaata ngii unnakuainno tiinnee? ");
INSERT INTO waj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ti nnoonnaiyakidiriaata Farisaiyakidiriaatama dee vaidi voovoono innara kutaavaivee tiinnee? Hameetavee. ");
INSERT INTO waj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aa kumina gioonna kiaapu aaya kua mmaanna tuu kuaivaa hama rikiaiya Anutuuqo irisai maisaivaa iya mmiivaivee, ");
INSERT INTO waj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","tuduu rikioo Farisaiyakidiri duu vaidi voovai nnutuuvo Nikotimaaso vaa tauraa Yisuunnaata kua tira vaidivoono iya tunoo: ");
INSERT INTO waj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ta titi kua mmaanna tiraivaudiri hama vaidi voovoono tomeda iiraivaa irisaivaa tauraananaa kati inna mmaara kua yeena rau kiada inna mmiaaravai. Ta kua pinaana inna yapa kiada kua oyaivaara arinaima inna rikiada inna tomedaivaa irisaivaara kua yeena rau kiada inna mmiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","tuduu rikiada iya inna sai tunoo: Mo eetaata Karirayaa diaa vaidikuannee? Anutuuqaa kuaivaa yaaruee tuqinnama rikiaanee. Fai a teeno hama kaanainaravai. Hama vaidi forofetaa voovoono Karirayaadiri nniivaivee. Farisaiyaano itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","(Mmuakiaaya ngiari nnauki vida tara kiooduu Yisuuva taapi Oriveetaivaura viravai. ");
INSERT INTO waj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Vioo vioo ivaki vauvo patauduu kava vara ranoo nuunaira nnau pinaivakira nniravai. Ivaki nnuduu teeda gioonna kiaapu mmuakiaa ivaki duuya innasi nuunauduu Yisuuva hara kioo varioo kuaivaa iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kiaa mmioo varuduu Anutuuqaa kua mmaanna kiaa mmiraiyaata Farisaiyaatama gioonna sabi nuairaivaa vitada Yisuunnasi nniravai. Ii gioonna ivo ari vo vaidi voovai tasipooduu tooya inna vitada Anutuuqaa kua mmaanna kiaa mmiraiyaata Farisaiyaatama iyasi nnuduu teeda vitada Yisuunnasi nniravai. Numa gioonna kiaapuuya avuuvau ari mmaraa voovau kiada ");
INSERT INTO waj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yisuunna tunoo: Vitaira-o, aa gioonna vaati ruaa aavo ari vo vaidiivaa tasipaikiai teeda vitada tiisi ngiaani ta vitada iisi ngiaunnanoo. ");
INSERT INTO waj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aa gioonna aavaa roosiivaara Musiiva ti mmaanna kua voovai ti kiaa ti mmioo tunoo: Sikauyauvaa habati kiada innayaa kagaarikio putuaivee. Musiivaano itaa kua tiravai. Eenoo aavaara dataa kuainna kiannannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iya inna iida teekio ivo koonnama tinai kua pinaivaa innaki yapaaraivaara iya itaa kua tiravai. Itaa kua tuduu rikioo Yisuuva hama iya kua sai tirainno kookama kioo varioo ari yaaku oopuuvaadiri mmataivau fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Fafaarainno varuduu iya sai ti kiaa ti mmianeeraivaara kava kava inna yaparauduu rikioo ivo diitoo iya tunoo: Ngia hama mminnamminnaa maisaatai voovoono ivonnaadee sikauvaa habati kioo tauraa innayaa kagaariaivee, ");
INSERT INTO waj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","kiaa kioo kava kookama kioo varioo ari yaaku oopuuvaadiri mmataivau fafaara reeravai. ");
INSERT INTO waj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Yisuuva itaa kua tuduu rikiada mmuakiaaya mmuaavai mmuaavai yokovaiya tauraa Yisuunna pikiada tiida viravai. Tiida vida kiooduu Yisuuva arivai nnaasu homo ivau kookama kioo varuduu gioonnaivo homo ivau dioo vairavai. ");
INSERT INTO waj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dioo vauduu Yisuuva diitoo inna yaparainno tunoo: Gioonna-o, iya deepiida kuaannee? Hama voovoono mmannammanna aavau dioo vainno kua pinaivaa aiki yapainnee? ");
INSERT INTO waj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","tuduu rikioo inna sai tunoo: Nnoonna-o, hameeta kiaanoo, tuduu rikioo Yisuuva tunoo: Neetama hama kua pinaivaa aiki yapaunoo. Kati kuanee. Sa keenaa mminnamminnaa maisaivaa varaanee, tiravai.) ");
INSERT INTO waj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yisuuva kava nuunaira nnau pinaivaki gioonna kiaapuuyaatama kua tioo tunoo: Tooba subiaavo mmeekiaivo taineema na gioonna kiaapu mmatayaa diaiya mmeekiavai variaunoo. Gioonna kiaapu voovoono ni nnaagiai nniivo fai mmeekia taivau nnaasu kati hara kioo varioo hama upisiivaki kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","tuduu rikiada Farisaiya inna tunoo: Eenaidiri aiyara itaa kua kianna kua ivo unnakuavai kiannanoo, ");
INSERT INTO waj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","tuduu rikioo Yisuuva iya sai tunoo: Ai, hama na unnakuavai kiaunoo. Na niniiyara kiau kuaivo kutaavaivee. Na ivakidiri tummuaivaata na kuanaraivaatama vaa na tauvaara ni kuaivo kutaavaivee. Na ivakidiri tummuaivaata na kuanaraivaatama hama ngia taavai. Vaa na tauvai. ");
INSERT INTO waj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ngia mmanna mmatayaa diaaya roosiima kuaivaa niiki yapaanoo. Hama na vaidi voovai kuaivaa innaki yapaunoo. ");
INSERT INTO waj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Fai na vaidi voovaaki kuaivaa yapaanaree tiee ni kuaivo kutaavai vainai na innaki yapaanaravai. Fai hama neneenoo iinaravai. Ni Napoova ni titoovoono ni tasipama iinaraivaara na kua kutaavai innaki yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ngii kua mmaanna tuu kua voovai vainno tinoo: Fai taara vaidivaitana vaidi voovaaki kuaivaa yapa kikio mmuaavau vainai ivaara ngia kiaara: Kutaavaivee, kiaaravee. Ngii mmaanna tuu kua voovai itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na neneenoo niniiyara kiauko ni Napoova ni titoovo niiyaraatama tiivaivee, ");
INSERT INTO waj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","tuduu rikiada iya inna yaparaida tunoo: I koova deevaunno variinnee? tuduu rikioo Yisuuva iya sai tunoo: Hama ngia ni teeda hama ni Napoonnaata taanoo. Ngia aikiooma ni taatiri. Aikiooma ni Napoonnaata taatirivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yisuuva nuunaira nnau pinaivaa aakiaivaki vo nnau sikau yapeeraivaki dioo vainno ii kua iyauvaa iya kiaa mmuduu hama voovoono numa inna utiravai. Hama inna suaivo nnuuvaara hama inna utiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Hama inna utuduu Yisuuva yapooma keenaa iyaata kua tioo tunoo: Fai na ngii pikiee kuanaravai. Fai ngia niiyara buaidada teekiai hama na ngii teenai ngia ngiingii mminnamminnaa maisaiyauvaa tasipama putuaaravai. Na kuanaraivaki ngia hama yopeema kuaaravee, ");
INSERT INTO waj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","tuduu rikiada Yutayaa vaidiiya innara tunoo: Dee kuavainno ivo tinoo: Na kuanaraivaki ngia hama yopeema kuaaravee, tiinnee? Ivo ariinoo ari ruputu kioo putinaraivaara itaa kua tiinnee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tuduu rikioo Yisuuva vo kua vooyauvaatama iya tunoo: Ngia aa aduoo yoosinna aavaudiri diitaayavee. Na ngiau aapuuvakidiri diitauvaivee. Ngia aa mmata aavaudiri diitaayavee. Hama na aa mmata aavaudiri diitauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ivaaraina na ngii giaa ngii miee kiaunoo: Ngia ngiingii mminnamminnaa maisaiyauvaa tasipama putuaaravaivee, kiaunoo. Na ngii giaa ngii miauvo neenoovee kiauvaara fai ngia hama kutaavaivee tiraida fai ngia ngiingii mminnamminnaa maisaiyauvaa tasipama putuaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","tuduu rikiada iya inna sai tunoo: Mo a gioononnee? tuduu rikioo Yisuuva iya sai tunoo: Na tauraa ngii giaa ngii miau kuaivakidiri na niniiyara kiaa kuaivaa kooyaa ngii giaa ngii miauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na ngiiiyaraata ngiingii mminnamminnaa maisaiyauvaaraatama tinara kuaivo airi kuayauvai vainoo. Ivo ni titoovoono kutaa tuanaavaivee. Na ivo tii kuaivaa nnaasu gioonna kiaapuuya kiaa kookieema kiaunoo, ");
INSERT INTO waj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","tuduu rikiada ivo ari koonnara tuuvaa hama iya rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hama rikiooduu Yisuuva iya tunoo: Ngia Vaidiivaa Mmaapuuvaa ngiau aapu haara kikio rikioo ngii tinniiyauvo rusitinai na ngii giaa ngii miauvo neenoovee kiauvaa fai ngia arinaima rikiaaravai. Hama neneenoo yopeema nenenaidiri mmooriivaa iirama kiee ni Napoova ni giaa ni muu kuaivaa nnaasu kiauvaa fai ngia arinaima rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ni titoovoono ni tasipama varinoo. Ivo ari mmuduuya ruai mmooriivaa ni mikiai na iikiauko ivaara ivo ni tasipama varinoo. Hama ni pikiaikiai nenevana variaunoo, ");
INSERT INTO waj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","tuduu rikiada gioonna kiaapu kaayauya ivo itaa kua tuuvaa rikiada innara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tuduu Yisuuva innara kutaavaivee tuuya tunoo: Fai ngia ni kuaivaa rikiada iidada ngia ni nnaagiai nuaira tuanaaya variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Fai ngia itaida ngia kua kutaivaa arinaima rikiakio ivaara ngii ausaiyauvo takuasanai ngia mmamma dummukiara yoketai aataruuvaa iima rada kati kuaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","tuduu rikiada vooyaano Yisuunna sai tunoo: Aanna ta Aaparahaamaa sidinnaidiya variaunnanoo. Hama vaidi voovoono sikaunnaadiri yookaama kioo ti vitaivaivee. Mo aaniirainna a kiannanoo: Fai ngii ausaiyauvo takuasanai ngia mmamma dummukiara yoketai aataruuvaa iima rada kati kuaaravee, kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","tuduu rikioo Yisuuva iya sai tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Mminnamminnaa maisa varaivoono ataama varinoo. Mmoori nakaaraivo vaidi voovai sikaunnaadiri yookaama kioo vitoo puaisa utineema mminnamminnaa maisaivo ivaa varaivaa puaisa utivai. ");
INSERT INTO waj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Vaidi voovoono sikaunnaadiri yookaama kioo vitai ngiaammuauvo hama inna mmaapu tuanaavoono inna oyaivaki tupatupaa varinaravai. Ari mmaapu tuanaivoono nnaasu ari oyaivaki tupatupaa varinaravai. Fai ari mmaapuuvo ari sikaunnaadiri yookaama kioo vitai ngiaammuauya utuoo iya tinai teeda fai iya ngiari yaata utiraiyauvunugiataama kati kuaaravee. ");
INSERT INTO waj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ivaara fai na Anutuuqaa Mmaapuuvoono ngii utino ngii ausaiyauvo takuasanai ngia kutaa tuanaa mmamma dummukiara yoketai aataruuvaa iima rada kati kuaaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mo vaa na rikiauvai. Ngia Aaparahaamaa sidinnaidiiya variaanoo. Mo ngia aaniivaara ni ruputu kiaara iikiaannee? Ngia hama ni kuaivaa rikiaivaaraida ni mmaara ni ruputu kiaara iikiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neenoo ni Napoova ni vitaikiai tauvaara kiaukai ngia ngii gioova ngii giaa ngii miivaugiataama iikiaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tuduu rikiada iya inna sai tunoo: Mo Aaparahaamo ti rubuungovee, tuduu rikioo Yisuuva iya sai tunoo: Ngia kutaa tuanaa Aaparahaamaa sidinnaidi tuanaaya variaatiri. Ngia iva uuneema mmooriiyauvaa iikiaatirivee. ");
INSERT INTO waj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na Anutuuqaasidiri kua kutaivaa rikiee ngii giaa ngii miee variau vaidiivaa ngia ni ruputu kiaara iikiaanoo. Nnaaru Aaparahaamo hama itau mmooriivaa iiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ngia ngii gioova uuneema iikiaanoo, tuduu rikiada inna sai tunoo: Hama ta maraasoo nnaakaraya variaunnayavee. Ti Koova mmuaavai Anutuuqo varinoo, ");
INSERT INTO waj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","tuduu rikioo Yisuuva iya sai tunoo: Anutuuqo kutaa ngii Gioova varitiri. Ngia niiyara mmuduuya ruaatirivee. Na Anutuuqaa ni oyaivaasidiri tummuaivoona aavau na variaukai ngia hama niiyara mmuduuya ruaanoo. Hama na nenenaidiri tiiravai. Ivoono ni titaa kiooduu tiiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mo ngia aaniira na kiau kuaivaa hama rikiaannee? Ngia ni kuaivaa rikiaavo hama ngii iikiataikiaida hama tuqinnama rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ngia aanna Sataangaa uru nnaakarayavee. Ngii gioonna ausaivo iikiataivau ngiiita ngii iikiatainoo. Ivo nnaaru nnaaru varia roo ngioo varioo vaidiiya ruputikiai putuaa vaidivai varivai. Hama kua kutaivo innaki vaivaara hama kua kutaa mmooriivaa iivai. Ivo unnakua tioo unnakua tira oyaivo innaki vaivaara makemakee ari unnakua tiraivaugiataama tiivai. ");
INSERT INTO waj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mo na kua kutaavai ngii giaa ngii miauvaara ngia hama ni kuaivaa rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mo ngiiikidiri vaa gioono ni taikiai na mminnamminnaa maisaivaa varauvaara ngia ni kiaannee? Ai, hameetavee. Na kua kutaavai ngii giaa ngii miaukai ngia aaniira hama ni kuaivaa rikiaannee? ");
INSERT INTO waj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gioonna kiaapu voovoono Anutuuqaara mmuduuya ruaivoono inna kuaivaa arinaima rikiaivai. Ngia hama kutaa Anutuuqaara mmuduuya ruaayara tidaida hama inna kuaivaa tuqinnama rikiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tuduu rikiada vaidi Yutayaiya inna sai tunoo: Ta aiyara kiaunnanoo: A Samariaa vaidi kumimakakuavee. Mmagia maisaivo i aakiaivaki vari vaidikuavee, kiaunnaivo ta kua kutaavaida aiyara kiaunnannee? ");
INSERT INTO waj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","tuduu rikioo Yisuuva iya sai tunoo: Mo na hama mmagia maisaivo ni aakiaivaki vari vaidivaivee. Na ni Napoonna mmooriivaa yoketaama varauko inna nnutuuvo ngiau aapu kuaikiai ngiengieenooda niiyara maisa vaidivaivee kiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na nini nnutuuvaa ngiau aapu yapaanaraivaara hama na iikiaunoo. Mmuaavoono ni nnutuuvaa ngiau aapu yapaanaraivo varinoo. Ivoono kua pinaivaara diraivovee. ");
INSERT INTO waj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na kua kutaavai ngii giaa ngii miaunoo. Fai gioonna kiaapu voovoono ni kuaivaa rikioo puaisakama utuoo iinnonno fai hama putinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tuduu rikiada vaidi Yutayaiya inna sai tunoo: Aanna vaa ta taunnanoo. A kutaa mmagia maisaivo i aakiaivaki vari vaidikuavee. Vaa Aaparahaamo putuduu vaidi forofetaiyaatama putiravai. Mo a kiannanoo: Fai gioonna kiaapu voovoono ni kuaivaa rikioo puaisakama utuoo iinnonno fai hama putinaravaivee, kiannanoo. ");
INSERT INTO waj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Vaa nnaaru ti rubuungo Aaparahaamo putiravai. A innara kiannanoo: Vaa na inna yaataraunoo, kiannannee? Vaa forofetaiyaatama putiravai. A yaata utuee giaa roosiima varinarainna kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","tuduu rikioo Yisuuva iya sai tunoo: Na nini nnutuuvaa ngiau aapu yapa kiautiri. Kuminavai vaitirivee. Ni nnutuuvaa ngiau aapu yapaivo inna ni Napoova Anutuuqovee. Ngia innaraida ti Anutuuqovee tidaida ");
INSERT INTO waj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","mo ngia hama inna teeda rikiaavai. Vaa na inna tee rikiauvai. Fai na hama inna tee rikiauvaivee tiee ngii roosiima unnakua vaidivai varinaravai. Vaa na inna tee rikieenaina na inna kuaivaa rikiee puaisakama utuee iikiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na mmatayaa tiee varinara suaivaa ngii rubuungo Aaparahaamo ivaa taanaraivaara sirigairavai. Vaa ivo ivaa too sirigairavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tuduu rikiada vaidi Yutayaiya inna sai tunoo: Hama i nuanuuvo taara vaidivaitana yuku yaaku taika kioo vo vaidivai yaakuuvaitana (50) vaivaivee. Aa a nau karaasa a variannaikuainna kiannanoo: Vaa na Aaparahaamaa tauvaivee, kiannanoo, ");
INSERT INTO waj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","tuduu rikioo Yisuuva iya sai tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Aaparahaamo hama varuu suaivaki neenanaa variravai. Variaivoona aanna homo na variaunoo, ");
INSERT INTO waj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","tuduu rikiada iya sikauyauvaa habati kiada innayaa kagaariaara uuduu rikioo Yisuuva hataumakinaadiri nuunaira nnau pinaivaa pikioo mmaanai vioo kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yisuuva ari ngiaammuauyaatama vidada oro tooduu vaidiivo ari kaanaa ausaivakidiri avu huruutauvo iya too vauduu teeda ");
INSERT INTO waj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ari ngiaammuauya inna tunoo: Vitaira-o, gioono mminnamminnaa maisaivaa varaivaara aa vaidi aavo ari kaanaa ausaivakidiri avuuvo huruutainnee? Vara ariinoo mminnamminnaa maisaivaa varaivaara inna avuuvo huruutainnee? Vara ari kaano koovaitanaano mminnamminnaa maisaivaa varaivaara inna avuuvo huruutainnee? ");
INSERT INTO waj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","tuduu rikioo Yisuuva iya kuaivaa sai tunoo: Hama ariinoo mminnamminnaa maisaivaa varooduu inna avuuvo huruutairavai. Hama ari kaano koovaitana mminnamminnaa maisaivaa varooduu inna avuuvo huruutairavai. Anutuuqo inna tino rikioo inna avuuvo kava teeno inna variraivaki Anutuuqaa yaagueeqaivo kooyaa vakiaiveeraivaara ari kaanaa ausaivakidiri inna avuuvo huruutairavai. ");
INSERT INTO waj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Suaivo homo ikiannavai vaikiai ivo ni titooduu na tummuaivaa mmooriiyauvaa ta iikiaaravai. Heenaivo ngioo varinoo. Heenaivo nnino rikioo hama gioonna kiaapu voovoono fai mmooriivaa iinaravai. ");
INSERT INTO waj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Homo na mmatayaa variau suaivaki tooba subiaavo mmeekiaivo taineema na gioonna kiaapu mmatayaa diaiya mmeekiavai variaunoo. ");
INSERT INTO waj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yisuuva itaa kua kiaa kioo mmataivau kuaanuuvaa visi kioo mmataivaata kuaanuuvaatama hanigiaanigieema kioo habara kioo vaidiivaa avuuvaitanau siikairavai. ");
INSERT INTO waj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Siikama kioo inna tunoo: Viee viee oro nnoori haruunga Siruaama ivakidiri ai avuuvaitana finianee, tiravai. Nnoori haruunga Siruaama nnutuuvaa oyaivo tunoo: Titeeravaivee, tiravai. Yisuuva inna tuduu rikioo oro nnoori haruungaivakidiri ari avuuvaitana fini kiooduu inna avuuvaitana yoketauduu kati taa roo kava vara ranoo nniravai. ");
INSERT INTO waj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nnuduu ari seenaiyaatama vaa tauraa ivo ngiaaru tuduu tooyaatama innara tunoo: Ai, aa vaidi aavo tauraa ngiaaru tira vaidiivonnee? ");
INSERT INTO waj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","tuduu vooyaano tunoo: Ivovee, tuduu vooyaano tunoo: Ai, hama ivovee. Kati innanikaraivaivee, tuduu rikioo vaidiivo ariinoo tunoo: Mo aanna na ivoona iikiaunoo, ");
INSERT INTO waj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","tuduu rikiada iya inna yaparaida tunoo: Ai, mo a dataama kiaannanoonno i avuuvo tainnee? ");
INSERT INTO waj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","tuduu rikioo ivo tunoo: Vaidiivaa nnutuuvo Yisuuva ivaano mmataivaata ari kuaanuuvaatama hanigiaanigieema kioo ni avuuvaitanau siikama kioo ni tinoo: Oro nnoori haruunga Siruaamadiri ai avuuvaitana finianee, tikiai na oro nnooriivakidiri fini kiauko ni avuuvo taivaivee, ");
INSERT INTO waj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","tuduu rikiada iya inna yaparaida tunoo: Mo ivo deevakiinno variinnee? tuduu rikioo sai tunoo: Hama neeta tauvaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tuduu vaa tauraa inna avu huruutauvaa Yisuuva tuqinnoovaa ari seenaiya vitada Farisaiyasi viravai. ");
INSERT INTO waj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ii suai ivaki Yisuuva mmataivaadiri vaidiivaa avuuvaitanau siikauduu inna avuuvo too suaivaki Yutayaiya kati varira suaivai vairavai. ");
INSERT INTO waj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Vauvaara Farisaiya vaidiivaa yaparaida tunoo: Dataama kieenna ai avuuvaa yoketaama taannannee? tuduu rikioo ivo iya sai tunoo: Ivoono mmataivaa ni avuuvaitanau siikama kiooduu na fini kiaaduu ni avuuvo teeravaivee, ");
INSERT INTO waj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","tuduu rikiada Farisai vooyaano tunoo: Aa vaidi aavo hama kati varira suai aataruuyauvaa arinaima too iivaara ivo hama Anutuuqaasidiri tiivaivee, tuduu vooyaano tunoo: Hama mminnamminnaa maisa varai vaidivoono Anutuuqaa mmoori ari vookarai atai aayauvaa iinoo. Iya itaa kua kiaa kiada vooyaano vo yaata utiravai yaata utuduu vooyaano vo yaata utiravai voovaugiataama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ivaara Farisaiya kava inna yaparaida tunoo: A kiannanoo: Iva ni avuuvaa tuqinnaivaivee, kiaa innara dataa kuainna kiannannee? tuduu rikioo iya sai tunoo: Ivo forofetaavaivee, ");
INSERT INTO waj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","tuduu Yutayaa vaidiiya tauraa ivo avu huruutavai varioo nnaagiai yoketaama varuuvaara hama kutaavaivee kiaa kiada ari kaano koovaitanaara aayanna tuduu nnuduu ");
INSERT INTO waj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ivaitana yaparaida tunoo: Aanna ngii maapuvainnee? Ngia innara kiaanoo: Ta avu huruutavai mmataunnavaivee, kiaavainnee? Mo dataakiaavo aanna inna avuuvo tainnee? ");
INSERT INTO waj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","tuduu rikiada ivaitana iya sai tunoo: Vaa ta taunnanoo. Aanna ti mmaapuvai. Ta avu huruutavai inna mmata kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Makee inna avuuvo taivaara hama teeta teeda rikiaunnavaivee. Ari deevoono inna avuuvaa tuqinnaivaa hama teeta teeda rikiaunnavaivee. Inna yaparakiatee. Vaa ivo yokeevaivee. Fai ivo ariinoo ngii giaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yutayaiyara aatuuda kaano koovaitana itaa kua tiravai. Vaa Yutayaa vaidiiya kua yeena rau kiada tunoo: Fai gioonna kiaapu voovoono Yisuunnara kooyaa Anutuuqo mmataama kioo vaidiivovee tinai fai itaa kua tii gioonna kiaapuuvo nuunaira nnauvaki vivoora kiaa ta ooqoo kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iya itaa kua tuuvaara ari kaano koovaitana quiivaqaivaa tida tunoo: Vaa ivo yokeevaivee. Inna yaparakiatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kava vooneetu Farisaiya vaa tauraa avu huruutauvaara aayanna rooduu nnuduu inna tunoo: Anutuuqaa kua kutaivaa tinaraivaara kutaavaivee kianee. Vaa ta taunnavai. Ii vaidi ivo vaa mminnamminnaa maisaivaa varaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","tuduu rikioo iya sai tunoo: Ivo mminnamminnaa maisaivaa varaivainnee? Vara hama varaivainnee? Hama neeta tauvaivee. Mmuaa mmoorivai vaa na tauvai. Tauraa na avu huruutavai variauvai. Aanna makee ni avuuvaa na yoketaama taunoo, ");
INSERT INTO waj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","tuduu rikiada iya inna sai tunoo: Ivo aaniivai i iivainnee? Dataama kioo i avuuvaa iikiainna a taannanoo, ");
INSERT INTO waj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","tuduu rikioo ivo iya sai tunoo: Mo vaa na ngii giaa ngii miaukai hama ngia rikiaanoo. Mo aaniira ngia kava ivaa rikiaaraida ni yaparakiaannee? Mo ngieeta inna nnaagiaivau ngii nookiatainnee? Ngia ivaaraida ni yaparakiaannee? ");
INSERT INTO waj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","tuduu rikiada innara nnannatooduu tunoo: A inna nnaagiai nuairaikuavee. Ta Musiinna nnaagiai nuairaiyavee. ");
INSERT INTO waj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anutuuqo Musiinnaata kua tuuvaa vaa ta rikiaunnavai. Aa vaidi aavaara ta kiaunnanoo: Deedaadiri nniivainnee? kiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","tuduu rikioo ivo iya sai tunoo: Ni noonnaata mmaapuvee. Na rikiauko ngii kuaivo ari vookarainoo. Iva vaa ni avuuvaa tuqinnaikiai na ni avuuvaa taukai ngia iva ii mmoori oyaivaa hama tuqinnama taanoo. ");
INSERT INTO waj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Vaa ta rikiaunnavai. Vaidi kaayau mminnamminnaa maisa varaivaa hama Anutuuqo inna kuaivaa rikiaivai. Vaidi voovoono ari ausa mmuduuyaivaa Anutuuqaa mmioo inna kuaivaa tuqinnama rikioo iivaa Anutuuqo inna kuaivaa rikiaivai. ");
INSERT INTO waj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ngiau mmataivaa uu suaivakidiri ngioo ngioo numa aanna makee ta variaunna suaivaki vaidi voovai mmatoo suaivakidiri avu huruutavai varuuvaa vaidi voovoono inna avuuvaa tuqinneeraivaara hama ta rikiaunnanoo. ");
INSERT INTO waj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aa vaidi aavo hama Anutuuqaasidiri tiitiri. Vo mmoori vo mmooriivaa hama yopeema iitirivee, ");
INSERT INTO waj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","tuduu rikiada Yutayaa vaidiiya inna sai tunoo: I kaano koovaitana mminnamminnaa maisa suvuauvaitanaano meediyaa i mmata kiookuaano a yokeenna mminnamminnaa maisaivaa tasipama variee aanna makee a ti vitainarannee? Hama yopeema ti vitainaravee, kiaa kiada nuunaira nnau pinaivakidiri inna vitada mmaanai kiada ivaki kava nuaivoora inna ooqoo tiravai. ");
INSERT INTO waj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iya inna mmaanai titoo kuaivaa Yisuuva rikioo innara buaama roo tooduu inna too vauduu too inna tunoo: A Vaidiivaa Mmaapuuvaara kutaavaivee kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","tuduu rikioo vaidiivo inna sai tunoo: Nnoonna-o, inna gioononnee? Innara ni giaa ni minai fai na innara kutaavaivee tinaravee, ");
INSERT INTO waj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","tuduu rikioo Yisuuva inna sai tunoo: Vaa a inna taannakuavee. Na aanna ivoona aita kua kiaunoo, ");
INSERT INTO waj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","tuduu rikioo ivo inna sai tunoo: Ni Udaanga-o, na aiyara kutaavaivee kiaunoo, kiaa kioo pinaama innara mmuduuya ruoo innara yoketairavai. ");
INSERT INTO waj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Innara yoketauduu Yisuuva tunoo: Gioonna kiaapu mmatayaa variaiya yaparainaraivaara na tiiravai. Avu huruutaiya fai tuqinnama teekiai avu tuqinnama taiya avu huruutaiya roosiima variateeraivaara na iya yaparainaraivaara tiiravaivee, ");
INSERT INTO waj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","tuduu rikiada Farisai vaidi vooya inna tasipama duuyaano inna kuaivaa rikiada inna yapara rida tunoo: A tiiyarainna kiannannee? Teeta avu huruuta kiaunnaya variaunnannee? ");
INSERT INTO waj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","tuduu rikioo Yisuuva iya sai tunoo: Ngia avu huruuta kiaaya variaatiri. Hama mminnamminnaa maisaiyauvaara mmannammanna ngii mmuaararaitirivee. Ngia kiaanoo: Ta tuqinnama taunnanoo, kiaivaaraida mminnamminnaa maisaiyauvaara homo ngii mmuaararainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yisuuva itaa kua kiaa kioo tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Vaidi voovoono hama puara sipisiipaiya hanikia keegiaidaadiri virainno hanikia vovaatadaadiri karoo kuaivoono inna mmuara vareera vaidivaivee. ");
INSERT INTO waj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Keegiaidaadiri kuai vaidiivoono inna puarara haitatuura vaidivai. ");
INSERT INTO waj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Puarara haitatuuraivoono nnikio sipura haitatuura vaidiivo innara sipuuvaa hatuaa kiaikio ivo ari sipisiipaiya nnutuuyauvaa tikiai rikiada inna avaivaa arinaima rikiada innasi ngiaavo ivo iya vitoo mmaanai kuaivai. ");
INSERT INTO waj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Vioo ari sipisiipa mmuakiaayara tikiai mmaanai kuaavo ivo iya tauraa kuaikiai iya inna avaivaa arinaima rikiaivaara inna nnaagiai kuaavai. ");
INSERT INTO waj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hama ari vo vaidi voovoono tikiai rikiada inna nnaagiai kuaavai. Hama iya inna avaivaa arinaima rikiaivaara iya innara aatuuda ngiari taivau kuaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yisuuva ii kua ivaudiri mmataama kioo tuduu iya hama oyaivaa arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hama rikiooduu Yisuuva kava iya tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Neenoo puara sipisiipaiya hanikiaivaa keegia sipuuvoona iikiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ni tauraa varuu vaidiiya tuduu hama puara sipisiipaiya iya avaiyauvaa rikieeravai. Iya mmuara vareera vaidiiya roosuuvaara hama iya avaiyauvaa rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Neenoo sipuvai. Fai gioonna kiaapu voovoono niikinaadiri nnino Anutuuqo inna vitoo yoketaivau yapaanaravai. Fai ivo aakiaana vioo kava mmaanai yeennaivaara vioo ngioonno varioo yeennaivaa nnaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mmuara vareera vaidiivoono numa mmuara varoo ruputinai putikio maisamaisai mmooriivaa iya iinaraivaara nniivai. Neenoo iya tupatupaa variraivaa varada yoketayoketaama variateeraivaara ngiauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Sipisiipaiyara yoketaama haitatuuraivo neenoovee. Yoketaama haitatuuraivoono ari sipisiipaiyauvaara yaata utuoo iyara putinaraivaara hama aatuunaravai. Fai putinaravai. ");
INSERT INTO waj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Fai vaidi voovoono sipisiipara haitatuura mmooriivaara sikau irisaivaa vareeraivoono hama sipisiipara haitatuura tuanaavai varioo hama ivo sipisiipa nakaaraavoonora tuoo fai mmararaa avaikaraivo fai nnino rikioo ari taivau aatu kuanaravai. Vioo kino rikioo fai mmararaa avaikaraivo ngioo sipisiipaiya guaraatino gutinai vida raubiriikiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Vaidiivo sikau irisai varaanaraivaara nnaasu sipisiipaiyara haitatuunno hama sipisiipaiyara mmuduuya ruaivaara ari taivau aatu kuaivai. ");
INSERT INTO waj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Sipisiipaiyara yoketaama haitatuuraivo neenoovee. Ni Napoova arinaima ni taikiai na arinaima inna tauneema na ni sipisiipaiya arinaima taukai iya arinaima ni taavai. Fai na iyara putinaravai. ");
INSERT INTO waj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na ni sipisiipa vooyauvai aa hanikia aavaki hama variaiyaatama fai na iyaatama vitee nninai iya ni avaivaa rikiada iyaatama mmuaavau varikiai neenoo mmuaavoono haitatuuraivoono iyara haitatuunaravai. ");
INSERT INTO waj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na putinaraivaara ee-oo kiauvaara ni Napoova niiyara mmuduuya ruaivai. Na putuee kava diitee varinaraivaara na aikiooma putinaraivaara ee-oo kiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hama vaidi voovoono ni tinai na putinaravai. Neneenoo tiee putinaravai. Putinaraivaara ee-oo tiee kava diitee varinaraivaara ee-oo tira yaagueeqaivo niiki vainoo. Aa kua aavaa ni Napoova tikiai na rikiauvaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yisuuva itaa kua tuuvaara kava Yutayaa vaidi vooyaano vo yaata utiravai yaata utuduu vooyaano vo yaata utiravai voovaugiataama yaata utiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Vooyaano tunoo: Mmagia maisaivo inna aakiaaki hara kioo varinoo. Ivo yaata duunavai. Ngia aaniira inna kuaivaa rikiaannee? ");
INSERT INTO waj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","tuduu vooyaano tunoo: Mo mmagia maisaivo vaidi aakiaana varitiri. Hama itaa kua tiitirivee. Mo dataama mmagia maisaivo vaidi avu huruutaivaa tino rikioo avuuvaa taanarannee? Hama yopeemavee. Iya itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yutayaa gioonna kiaapuuya Yerusareemaivaki buusa voovai nnaara suaivo vainima nninoo. Ii buusa ivaa nnutuuvo Anutuuqaa Nnauvaara Yoketaira buusavai. Ii suai ivo vati rira suaivai. ");
INSERT INTO waj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nuunaira nnau pinaivaa haayaivaa nnutuuvo Soromoonaa Nnau Haayaivaki Yisuuva nuainno varuduu ");
INSERT INTO waj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yutayaa vaidi vooya numa inna ututuuma kiada inna yaparaida tunoo: Ta ti rikiaatai kuaivaa a homoonna hokobama hatauma kiee iikiannannee? Nnaaru Yutayaiyara Anutuuqo mmataama kioo vaidiivo aanna a ikuannee? Kooyaa ti kiaa ti mminai ta rikiaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","tuduu rikioo Yisuuva iya sai tunoo: Vaa na ngii giaa ngii miaukai ngia hama ivaara kua kutaavaivee kiaanoo. Ni Napoova ni giaa ni muuvaugiataama na ari vookara ari vookarai mmooriiyauvaa iikiaunoo. Inna ni mmooriiyauvoono niiyara kooyaa ngii vitainoo. ");
INSERT INTO waj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ngia hama ni puara sipisiipa tuanaaya variaivaaraida hama ngia niiyara kutaavaivee kiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ni puara sipisiipaiya ni kuaivaa rikiaiya na tuqinnama taukai ni nnaagiai ngiaavai. ");
INSERT INTO waj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngiaani na tupatupaa variraivaa iya mminai fai hama ikiaivaki kuaaravai. Hama vaidi voovoono yopeema niisidiri guaraatino iya ravisi vitaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ni Napoovaano iya ni miivoono mmuakiaaya yaataraivai. Ivaara hama vaidi voovoono yopeema numa ni Napoonnasidiri iya ravisi vitaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ni Napoovaata neetama mmuaavaitanavee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tuduu rikiada Yutayaa vaidiiya kava sikauyauvaa habati kiada innasi kagaariaara uuduu ");
INSERT INTO waj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yisuuva iya tunoo: Na kaayau yoketaa mmooriiyauvaa ni Napoova ni muduu iikiaiyauvaina iikiaunoo. Mo ngia ivaki taavo datai mmoorivaara ngia yaata utida sikauyauvaa habati kiada niisi kagaariaara iikiaannee? ");
INSERT INTO waj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","tuduu rikiada vaidi Yutayaiya inna sai tunoo: Hama iqii mmoori yoketaa iyauvaa a iikiannaiyauvaara ta sikauyauvaa habati kiada aiyaa kagaariaara iikiaunnanoo. A Anutuuqaara kua maisaivaa kiannaivaara ta sikauyauvaa habati kiada aiyaa kagaariaara iikiaunnanoo. A mmanna vaidi aakuaanoonna eenoo aiyara kiannanoo: Neenoo Anutuuqovee, kiannanoo. Ivaaraida ta sikauyauvaa habati kiada aiyaa kagaariaara iikiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","tuduu rikioo Yisuuva iya sai tunoo: Ngii mmaanna tuu kuaivaki kua fafaara voovai vainoo. Anutuuqo kua pinaivaara dira kieeta vaidiiyara tunoo: Ngia anutuuya variaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Vaa ta rikiaunnanoo. Anutuuqaa kua fafaara roo kuaivaki vai kuaivo tupatupaa kutaa kuavai vaivai. Nnaaru Anutuuqo ari kuaivaa kiaa mmuuyara tunoo: Anutuuyavee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mo niiyara ngia dataikiaida kiaannee? Anutuuqoono ni mmataama kioo ni titooduu na mmatayaa tiiravai. Na niniiyara Anutuuqaa Mmaapuvaivee kiauvaaraida ngia niiyara kiaanoo: A Anutuuqaara kua maisaivaa kiannanoo, kiaannee? ");
INSERT INTO waj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na hama ni Napoonna mmooriiyauvaa iinai ngia sa niiyara kutaavaivee kiatee. ");
INSERT INTO waj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Fai na kutaa ni Napoonna mmooriiyauvaa iinai ngia hama niiyara kutaavaivee ngii kiatainai ni mmooriiyauvaara inna aikioo kutaavaivee kiatee. Ni Napoova niiki varikiai na innaki variauvaara arinaima teeda rikiaateeraivaara na iikiau mmooriiyauvaa teeda kutaavaivee kiatee, ");
INSERT INTO waj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","tuduu rikiada iya keenaa inna utuaara uuduu ivo hataumakinaa ari toovau viravai. ");
INSERT INTO waj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nnoori Yorotaana sainai tauraa Yuvuaano gioonna kiaapuuya nnoori apuu yoosinnaivaki Yisuuva oro ivaki hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ivaki hara kioo varuduu kaayau gioonna kiaapuuya innasi nniravai. Numa varida ngiariita ngiariita kua tida tunoo: Hama Yuvuaano Anutuuqaa mmoori ari vookarauyauvaa iiravai. Aa vaidi aavaara Yuvuaano mmuakiaa kuavai tuuvoono kutaavai vainoo. ");
INSERT INTO waj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iya itaa kua tuduu kaayau gioonna kiaapu ivaki varuuya Yisuunnara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Vaidi voovai nnutuuvo Rasaruuso yoosinna Betaniaa diaa vaidivai varuuvoono pinaa nniitareeravai vareeravai. Mariaaya Mataaya nnunna nnayoovaitana ii yoosinna Betaniaa ivaki variravai. ");
INSERT INTO waj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ii gioonna Mariaava ivoono heenna suuya suuda yoketaa vuuvaara pinaa sikau kagaari kioo varoo Yisuunna yukuuvaitanau tusaa siikama kioo ari kieeta yaasiivaadiri rugoovoota ari nnayaavaatama ii yoosinna ivaki variravai. Ngiari vayaava Rasaruuso pinaa nniitareeraivaa varooduu teeda ");
INSERT INTO waj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","nnunna nnayoovaitana ngiaammuau voovai titada tunoo: Oro Yisuunna kianee: Udaanga-o, vaa a vaidi innara pinaama mmuduuya riraivo pinaa nniitareeraivaa varainoo, kianee, ");
INSERT INTO waj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","tuduu rikioo oro Yisuunna kiaa mmuduu rikioo tunoo: Ii nniitarai ivaa varaivo fai inna raputino hama eeyaara putinaravai. Ivo putinaraivo hama kati putinaravaivee. Gioonna kiaapuuya Anutuuqaara kua yoketaivaa tida inna Mmaapuuvaaraatama kua yoketaivaa kiaaraivaara fai ivo putinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yisuuva Mataannaraatama ari nnunnaivaa Mariaannaraata Rasaruusaaraatama pinaama mmuduuya riravai. ");
INSERT INTO waj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mmuduuya ruoo Rasaruuso pinaa nniitaroo kuaivaa rikioonnaata ari varuu yoosinnaivaki varuduu taara suaivaitana taikeeravai. ");
INSERT INTO waj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Taika kiooduu rikioo Yisuuva ari ngiaammuauya tunoo: Nnikiai ta kava vara ranada Yutayaa yoosinnaivaki kuaaravee, ");
INSERT INTO waj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","tuduu rikiada ari ngiaammuauya inna sai tunoo: Vitaira-o, aa heena Yutayaiya sikau habati aiyaa kagaariaara kiaipinnainni a kava kuanarainna kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","tuduu rikioo Yisuuva iya sai tunoo: Mo mmuaa suaivau yaakuuvaitana yukukidiri taarama suaivo vainoo. Ii suai iyauvunu suaivo mmannammanna taikiokio yapooma heenaivai. Itaama vaivaara gioonna kiaapu voovoono suaivau nuainno fai hama harurinaravai. Ivo mmataivo koo pataivau avuuvaa taa roo nuaivaara hama harurinaravai. ");
INSERT INTO waj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Gioonna kiaapu voovoono heenaivaki nuainno fai harurinaravai. Hama mmataivo koo pataivau nuaivaara harurinaravaivee. Yisuuva ari putinara suaivo hama vainima vauvaara itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kiaa kioo kava ivo iya tunoo: Ti seena Rasaruuso vaa vuru vaivaivee. Fai na viee inna yuruunaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","tuduu rikiada ari ngiaammuauya inna tunoo: Udaanga-o, ivo ari kati vuru vainno fai ariinoo diitoo hara kioo varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","kiaa kiada Yisuuva Rasaruuso vaa putuu kuaivaa iya kiaa mmuuvaara hama tuqinnama rikieeraida iya yaata utida tunoo: Ari kati ivo vuru vaivaarainno aavo itaa kua tinoo. ");
INSERT INTO waj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iya itaama yaata utida tuduu rikioo Yisuuva kooyaa iya kiaa mmioo tunoo: Kutaa vaa Rasaruuso putivai. ");
INSERT INTO waj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Itaama vaikiai na ngiiiyara yaata utuee hama na inna tasipama variauvaara ni yoketainoo. Ngia niiyara kutaavaivee kiateeraivaara na hama inna tasipama variauvaara ni yoketainoo. Nnikiai ta innasi kuaaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","tuduu Tumaasaa ari seenaiyaano innara tuu nnutu vuaivo Gaabivaano ari seena ngiaammuauya tunoo: Nnikiai teetama vida ti vitairaivaa tasipama putuaaraivaara kuaaravee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yisuuva yoosinnaivaki ngioo varioo rikiooduu vaa Rasaruuso putuoo mmata nnauvaki taarama taarama suai vauvaara iya inna kiaa mmuduu rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ii yoosinna ivaa nnutuuvo Betaniaa ivo Yerusareema vainima kiisama oro ngieerama vaira yoosinnavai. ");
INSERT INTO waj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kiisama ngieerama vauvaara kaayau Yutayaa gioonna kiaapuuya Mataaya Mariaayasi viravai. Innidana ausaivaitana mmuaararoovo taikaiveera ivaitanaasi viravai. ");
INSERT INTO waj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mataava Yisuuva nninara kuaivaa rikioo inna sunaanara vuduu Mariaava nnauvaki hara kioo variravai. ");
INSERT INTO waj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Varuduu Mataava oro Yisuunna tunoo: Udaanga-o, e aavaki variannatiri. Hama ni vaavova putitirivee. ");
INSERT INTO waj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mo vaa na taunoo. Fai makee eenoo Anutuuqaa yaparaino fai ivoono a yaparakiannaivaa i mminaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","tuduu rikioo Yisuuva inna sai tunoo: Fai i vayaava kava diitaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","tuduu rikioo Mataava inna sai tunoo: Vaa na rikiaunoo. Fai suai nnaagiai gioonna kiaapu putuaiya kava diitaara suaivaki ivootama iya tasipama kava diitaanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","tuduu rikioo Yisuuva inna sai tunoo: Gioonna kiaapu voovoono putuoo kava diitaanaraivaa na nakaaraivovee. Gioonna kiaapu voovoono tupatupaa variraivaa varaanaraivaa na nakaaraivovee. Fai gioonna kiaapu voovoono niiyara kutaavaivee tiivo putino vaidi kaanaivo tupatupaa varinaravai. ");
INSERT INTO waj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Fai gioonna kiaapu voovoono hama putirainno hara kioo varioo niiyara kutaavaivee tiivo fai tupatupaa varinaravai. A ivaara kua kutaavaiveenna kiannannee? Vara a ivaara unnakuavaiveenna kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","tuduu rikioo Mataava inna sai tunoo: Yo, Udaanga-o, nnaaru Anutuuqo ari Mmaapuuvaa mmataama kioo mmatayaa kuanee tuuvo aanna ivoonna a iikiannanoo. Na ivaaraina kutaavaivee kiaunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mataava kiaa kioo kava vara ranoo numa ari nnunna Mariaannaata vitoo oro mmaraa tonai voovau dioo vainno tunoo: Vitairaivo vaa aavaki nniivo aiyara tinoo, ");
INSERT INTO waj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","tuduu rikioo akiairauduu innasi viravai. ");
INSERT INTO waj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Vuduu Yisuuva hama vaama kioo yoosinnaivaki nnirama kioo homo Mataava innaata kua tuuvaki dioo vairavai. ");
INSERT INTO waj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Dioo vauduu Yutayaa gioonna kiaapuuya Mariaanna nnauvaki inna ausa mmuaararaivo taikaiveera inna tasipama varuuya tooduu ivo makee tuduu diitoo mmaanai vuduu teeda iyaatama diitada inna nnaagiaivau viravai. Mariaava diitoo vuuvaara iya yaata utida tunoo: Rasaruusaa mmata nnauvau rataanarainno ivo kuainoo, kiaa kiada iyaatama inna nnaagiaivau viravai. ");
INSERT INTO waj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yisuuva duuvaki Mariaava oro too vioo varoo inna yuku oyaivaki vairavai. Vainno tunoo: Udaanga-o, boo, mo a aavaki varunnatiri. Ni vaavova hama pututirivee, ");
INSERT INTO waj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","tuduu rikioo Yisuuva Mariaava ratoo varuuvaa too Yutayaa gioonna kiaapu inna tasipama nnuuyaatama ratada varuuvaa tooduu inna ausa vuatinniivo hanigioo ari vo ausa vuatinnivai vairavai. ");
INSERT INTO waj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Vauduu ivo iya yaparainno tunoo: Mo ngia deevaki inna haukieeravainnee? tuduu rikiada iya inna sai tunoo: Udaanga-o, a numa taanee, ");
INSERT INTO waj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","tuduu Yisuuva rateeravai. ");
INSERT INTO waj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ratooduu teeda gioonna kiaapu Yutayaiya tunoo: Ai, inna taatee. Ivo pinaama Rasaruusaara mmuduuya ruoo innara ratainoo, ");
INSERT INTO waj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","tuduu rikiada vooyaano tunoo: Iva inna aikiooma vaidi avu maisaivaa tuqinnooduu rikioo ivo avuuvaa teeravai. Iva aavau hara kioo varutiri. Rasaruuso hama pututirivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tuduu Yisuunna ausa vuatinniivo kava hanigioo ari vo ausa vuatinnivai vairavai. Vauduu rikioo ivo vioo vioo oro mmata nnauvaki tooduu vaa iya Rasaruusaa oonauvaki hau kiada sikau sipuuvaadiri rau kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Rau kiooduu too tunoo: Sikau sipuuvaa hatuaa kiaatee, tuduu rikioo vaidi putuuvaa nnunna Mataavaano Yisuunna sai tunoo: Ai, Udaanga-o, vaa maisa suudaivo kuaivaivee. Vaa ivo putii suaivo taarama taarama suai heena taika kiaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","tuduu rikioo Yisuuva inna tunoo: Vaa na i kiaa i mmiauvaivee. A niiyara kutaavaivee tiee fai Anutuuqaa mmoori ari vookaraivaa a taanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","tuduu iya sikau sipuuvaa hatuaa kiooduu Yisuuva ngiau aapu reeri too vainno tunoo: Ni Napoo-o, a ni kuaivaa rikiaannaivaara na aiyara yoketaavaivee kiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Vaa na rikiaunoo. A mmuakiaa suai ni kuaivaa rikiaannavai. Aa na tinara kua aavaa hama niniiyara tinaravai. Gioonna kiaapu aavaki diaiya a ni titoovaara kutaavaivee kiateeraivaara na tinaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","kiaa kioo kuaivaa pinaama aayanna roo tunoo: Rasaruuso tummuanee, ");
INSERT INTO waj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","tuduu rikioo vaa putuuvo diitoo ivakidiri tiiravai. Inna yuku yaakuuvaa buruqa yeenaivaadiri purupuruuma kioovaata tinniivau buruqa rummua apu kioovaatama diitoo tiiravai. Tuuduu rikioo Yisuuva iya tunoo: Innayaadiri yeenayaanaiyauvaa rukuasaa kikio kuaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tuduu rikiada gioonna kiaapu Yutayaa vooya vaa Mariaanna tasipama nnuuya Yisuuva uu mmooriivaa teeda innara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tuduu vooya vaidi Farisaiyasi vida Yisuuva uu mmooriivaara iya kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kiaa mmuduu rikiada vaidi Anutuuqaara kati puara hudeera kieetaiyaata Farisaiyaatama nuunaida vaidi kua yeena rairaiyasi vida nuunaida varida kuakuaakuaiyauvaa tida tunoo: Mo ta dataama iikiaarannee? Aqaa vaidi aavo kaayau Anutuuqaa mmoori ari vookara ari vookaraiyauvaa iivaivee. ");
INSERT INTO waj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Fai ta teeda pikikio aa mmoori aavaa mmannammanna yaagueeqama kioo iinai rikiada fai mmuakiaa gioonna kiaapuuya innara kutaavaivee kiaaravai. Fai ta itaikiai rikiada ti kieeta nnoonna yoosinna Rooma variaiya ngiari ngiaammuau rapiraiya titakiai nnida fai ti nuunaira nnau pinaivaa havarata raubiriima kiada tiita ruputu taika kikio fai hama ti nnutuaatainaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","tuduu rikioo iyakidiri ii nuanu ivaki Anutuuqaara kati puara hudeera vaidi kieeta tuanaivaa nnutuuvo Kayapaava tunoo: Ngia kumimakayavee. ");
INSERT INTO waj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hama ngia arinaima rikiaanoo. Mmuakiaa Yutayaa gioonna kiaapuuyaata putu taika kiaarainnoo. Mmuaa vaidivai mmuakiaa gioonna kiaapuuya tiiyara putinaraivo inna yoketaavaivee, ");
INSERT INTO waj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","kiaa kioo tuuvo hama arinaidiri tiravai. Anutuuqoono kiaa mmuu kuaivaa tiravai. Ii nuanu ivaki Anutuuqaara kati puara hudeera vaidi kieeta tuanaavai variravoonora tuoo Yutayaa gioonna kiaapuuyara Yisuuva putinaraivaara ivo mmuaanaa itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yisuuva hama Yutayaa gioonna kiaapuuyara nnaasu fai putinaravai. Mmuakiaa mmatavau variaa Anutuuqaa nnaakara tuanaa variaiya rupi nuunainaraivaara putinaravai. Kayapaava ivaara kiaa kioo hama oyaivaa arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ii suai ivakidiri Yutayaa kieetaiya Yisuunna ruputikio putuaiveeraivaara kua yeena rairavai. ");
INSERT INTO waj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kua yeena rauduu rikioo hama Yisuuva Yutayaa mmataivau kooyaa nuairavai. Ivo ivaki pikioo oro koo mmuyai gaanga yoosinna voovai vainima vau yoosinnaivaa nnutuuvo Eparaima ivaki ivo ari ngiaammuauya tasipama variravai. ");
INSERT INTO waj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Varuduu Yutayaiya buusa Varaigiataivaa nneera suaivo vainima vauduu gioonna kiaapuuya vo yoosinna vo yoosinnadiri Yerusareema vida iya Anutuuqaara mmamma finira aataruuvaara iida nnaagiai buusaivaa nnaaraivaara viravai. ");
INSERT INTO waj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iya oro varida Yisuunnara buaama rada nuaida oro nuunaira nnau pinaivaki nuunaida dida vaida ngiari yapara ngiari yaparaida voovoono voovai tunoo: A dataamainna yaata utuannannee? Vo fai ivo buusaivaa nnaanaraivaara nninarannee? Vo hama nninarannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Iya itaa kua tuu suaivaki vaa Anutuuqaara kati puara hudeera vaidiiyaata Farisaiyaatama teerama kioo kuaivaa yaagueeqama tida tunoo: Gioonna kiaapu voovoono ivo variivaki taivoono ti kiaa ti mmiaivee, tiravai. Iya Yisuunna utuaaraivaara itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Buusa Varaigiataivaa nneera suaivo vainima vauduu yaaku sai suaivai karasaidiri mmuaa suaivo homo vauduu too Yisuuva diitoo yoosinna Betaniaa viravai. Vaidi Rasaruuso vaa putuduu Yisuuva inna tuduu diitoovoono ivaki variravai. ");
INSERT INTO waj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ivaki varuduu ari seenaiya Yisuunnani yeennaiyauvaa huda teerama kiooduu Mataava yeennaiyauvaa iya mmuduu nneeda varuduu Rasaruuso Yisuunna tasipama yeenna nnoo variravai. ");
INSERT INTO waj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Iya yeenna nneeda varuduu Mariaava heenna suuya suuda yoketaa vuu toori kiisaivaa sikau pinaivaadiri yookaama kioovaa varoo numa Yisuunna yukuuvaitanau tusaa kioo ari kieeta yausiivaadiri rugeeravai. Ruga kiooduu suuyaivaa suuda yoketaivo nnauvaki suvuairavai. ");
INSERT INTO waj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Suvuau kiooduu Yisuunna ngiaammuau voovai nnutuuvo Yutaaso Isariooto ivo Yisuunna nnammutuaiya fai kooyaa inna vitainara ngiaammuauvoono tunoo: Ta aaniira hama aa heenna suuya suuda yoketaa kuai aavaa vaidiiya mmida irisai sikau pinaiyauvaa (300) varada gioonna kiaapu mmanna haipuuya mmiaunnannee? ");
INSERT INTO waj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Iva hama mmanna haipuuyara boo tioo itaa kua tiravai. Iva ari mmuara vareeraivaara yaata utuoo itaa kua tiravai. Iva iya sikau utuaivaa varoo nuainno varioo ariyara ivakidiri vareeravai. ");
INSERT INTO waj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","8","Yisuuva inna kuaivaa sai tunoo: Sa Mariaanna itaa kua kianee. Pikino iikiaivee. Mmanna haipu gioonna kiaapuuya tupatupaa ngii tasipama varikiai ngia iyara tuqinnaaravai. Hama na tupatupaa ngii tasipama varinaravai. Ivo heenna suuya suuda yoketaa kuaivaa ni mmammayaa tusaa apuoo varioo na putinai ni hakuaaraivaara mmuaanaa teerainno varinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yisuuva Betaniaa nnuuvaara kaayau gioonna kiaapu Yutayaiya rikiada ivakira nniravai. Hama Yisuunna nnaasu taara nniravai. Yisuuva tuduu rikioo Rasaruuso putuuvakidiri diitoovaaraatama taara nniravai. ");
INSERT INTO waj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ivaara Anutuuqaara kati puara hudeera kieetaiya vaa Yisuunnara kua kiaa teerama kiaiya Rasaruusaatama ruputikio putuaiveera kua tida yeena rairavai. ");
INSERT INTO waj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yisuuva tuduu Rasaruuso diitoovaara kaayau gioonna kiaapu Yutayaiya ngiari kieetaiya pikiada Yisuunnara kua kutaa vaidivaivee tiravai. Tuuvaara kati Anutuuqaara puara hudeera vaidi kieetaiya Rasaruusaatama ruputikio putuaiveera kua tida yeena rairavai. ");
INSERT INTO waj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Vauya patauduu kaayau gioonna kiaapuuya Varaigiataa buusaivaa nnaara Yerusareema vaa nnuuya Yisuuva ivaki nninara kuaivaa rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rikiada innara sirigaida muusa apu roosuuyauvaa rakau utida inna sunaara saidi vida varida aayanna kiaa rada tunoo: Anutuuqo yoketaivovee. Udaanga Anutuuqo inna titooduu tuuvo nninaraivaara ivo innara yoketaakiaivee. Isarairaaya kieetaivaara Anutuuqo innara yoketaakiaivee. ");
INSERT INTO waj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iya itaa kua tida varuduu Yisuuva puara togii karaasaivaara buaama kioo tooduu inna too vauduu too inna mmookaivau karoo varuduu inna vitoo nniravai. ");
INSERT INTO waj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nnaaru Anutuuqaa yanaivaki forofetaivo ivaara reeravai. Ivo ivaara kua fafaara roovo tunoo: Yoosinna Sioonaa gioonna kiaapuuya sa aatuukiatee. Taatee. Ngii kieetaivo puara togii karaasaivaa mmookaivau varikio vitoo nninoo. Fafaaraivo vauvaugiataa ii suai ivaki kaanaivo vairavai. ");
INSERT INTO waj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iqii suai ivaki Yisuunna ngiaammuauya hama arinaima kua oyaivaa rikieeravai. Yapooma Yisuuva putuoo kava diitoo ari Koonnasi vira suaivaki iya arinaima rikieeravai. Ii kua ivo innara fafaara roo kua ivaaraatama gioonna kiaapuuya innara itaama uuvaaraatama arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yisuuva Rasaruusaa tuduu putuuvakidiri diitoo suaivaki gioonna kiaapu ivaa tooya ivaara ngiari seenaiya kiaa mmiaa rada nuairavai. ");
INSERT INTO waj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kiaa mmiaa rada nuauduu rikiada Yisuuva ari vookarau mmooriivaa itaama uuvaa rikioovaara kaayau gioonna kiaapuuya nuunaida ivo ngioo varuu suaivaki inna sunaara viravai. ");
INSERT INTO waj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iya inna saidi vuduu teeda vaidi Farisaiya ngiari kiaa mmi ngiari kiaa mmiida tunoo: Mo taatee. Hama ta yopeema vo mmoorivai inna iikiaaravee. Vaa mmuakiaa gioonna kiaapuuya inna nnaagiai kuaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Gioonna kiaapuuya Yerusareema buusa nnaara vida ngiari ausa mmuduuyaiyauvaa Anutuuqaa mmiaaraivaara vuduu Ereengaa kua tira vaidi vooyaatama iya tasipama viravai. ");
INSERT INTO waj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Vida tooduu Karirayaa diaa vaidiivo kiisa yoosinnaivaa nnutuuvo Betesaitaa diaa vaidiivaa nnutuuvo Piriipoota Yerusareema varuduu Ereengaiya innasi vida tunoo: Ti vaidi-o, ta Yisuunna taara ngiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","tuduu rikioo Piriipo oro Adiriaasaa iya kuaivaa kiaa mmi kioo innaata sunoo oro Yisuunna kiaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kiaa mmuduu rikioo Yisuuva iya sai tunoo: Suaivo vaa nninoo. Na Vaidiivaa Mmaapuuvaa ni nnutuuvo ngiau aapu kuanara suaivo vaa nninoo. ");
INSERT INTO waj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na kua kutaavai ngii giaa ngii miaunoo. Yeenna vuiitaivaa uruuvo ari mmuaavai vainno hama iiraatainaravai. Fai mmataki vainno rusitioo raubiriinno uruoo iiraiyauvo kaayauyauvai vainaravai. ");
INSERT INTO waj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Fai gioonna kiaapu voovoono ari mmatayaa varinaraivaara mmuduuya ruoo ruoo fai inna variraivo raubiriinno taikaanaravai. Fai mmatayaa varira suaivaki gioonna kiaapu voovoono hama ari mmatayaa variraivaara mmuduuya rirainno fai inna variraivo hama raubiriirainno fai tupatupaa vainaravai. ");
INSERT INTO waj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Fai gioonna kiaapu voovoono ni mmooriivaa varaanaree tioo ni nnaagiai ngiaivee. Na varinaraivaki ivoota ni tasipama varinaraivaara ni nnaagiai ngiaivee. Fai ivo ni mmooriivaa varano ni Napoova irisai inna nnutuuvaa ngiau aapu yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Aanna na rikiauko ni yaata vuatinniivo hanigioo ari vo yaata vuatinnivai vainoo. Na ivaara dataa kua tinarannee? Fai na tinara: Ni Napoo-o, aa suai aavaki a mmuaararaivaa ni minaraivaa eenoo ooqoo kianee, tinarannee? Fai na hama itaa kua tinaravai. Aqaa suai aavaki na mmuaararaivaa varaanaraivaara tiiravaivee. ");
INSERT INTO waj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ni Napoo-o, a mmuaararaivaa ni mino i nnutuuvo ngiau aapu vakiaivee, tuduu rikioo ngiau aapuuvakidiri kuaivo tioo tunoo: Vaa na iikiauko ni nnutuuvo ngiau aapu vainoo. Fai na kava iino ni nnutuuvo fai kava ngiau aapu vainaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gioonna kiaapuuya iya tasipama duuya ii kua ivo ngiau aapuuvakidiri tuu kua ivaa rikiada vooyaano tunoo: Ngiaarunno akua tinoo, tuduu vooyaano tunoo: Aangeraa voovoono innaata kua tinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tuduu rikioo Yisuuva iya sai tunoo: Neenoo kuaivaa rikiee Anutuuqaara kutaavaivee tinaraivaara hama kuaivo ngiau aapuuvakidiri tiivai. Ngiengieenoo kuaivaa rikiada Anutuuqaara kutaavaivee kiateeraivaara kuaivo ngiau aapuuvakidiri tiivai. ");
INSERT INTO waj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aanna makee Anutuuqo gioonna kiaapu mmatayaa variaiyaki kua pinaivaa iyaki yapaanaravai. Fai na gioonna kiaapu mmatayaa diaiyara geedai dira vaidiivaa yaataraanaravai. ");
INSERT INTO waj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iya ngiauvau ni haara kikio rikioo na iina rikinai teeda mmuakiaa gioonna kiaapuuya iya ausaiyauvo niisi ngiatangiataivaara varida yaata utuaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iya dataama inna iikio iva putinaraivo kooyaa vainaraivaara ivo itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ivo itaa kua tuduu gioonna kiaapuuya inna sai tunoo: Vaa ta rikiaunnanoo. Ti mmaanna tuu kua voovai tinoo: Anutuuqo mmataama kioo vaidiivo fai tupatupaa varinaravaivee, tiivai. Mo ivo itaa kua tiivaara a dataama kiee kiannanoo: Vaidiivaa Mmaapuuvaa iya ngiauvau haara kiaaravaivee, kiannannee? Mo ii Vaidiivaa Mmaapu ivo inna gioononnee? ");
INSERT INTO waj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","tuduu rikioo Yisuuva iya sai tunoo: Tooba mmeekiaivo homo kiisa suai ngii tasipama vainoo. Ngii upisiinoora tida toobaivo mmeekia tai suaivaungiaa nuaida varida variatee. Gioonna kiaapu voovoono upisiivaki nuainno hama ari nuainara aataruuvaa taivai. ");
INSERT INTO waj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ngia mmeekiaivau varira gioonna kiaapu tuanaaya variateera mmeekiaivo ngii tasipama vai suaivaki ivaara kutaavaivee kiatee, tiravai. Yisuuva ii kua ivaa kiaa taika kioo iya pikioo iya inna teevoora hataumannigiataa varia roo nuairavai. ");
INSERT INTO waj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Vaa tauraa ivo iya avuuyauvunu kaayau Anutuuqaa mmoori ari vookara ari vookarauyauvaa uuduu iya iyauvaa teedaata hama innara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nnaaruaa vaidi forofetaivaa nnutuuvo Yisayaava tuu kuaivaa kaanaivo vakiaiveera iya itaama iiravai. Yisayaava tuu kuaivo tunoo: Udaanga-o, hama gioonna kiaapu voovoono ta kiaunna kua mmayaayaivaara kua kutaavaivee tiivaivee. Udaangaivo ari vookara ari vookarai mmooriiyauvaa iikio hama voovoono arinaima too rikiaivaivee. ");
INSERT INTO waj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yisayaava itaa kua tuuvaara Yisuuva uuvaa iya teeda rikiadaata hama innara kutaavaivee tiravai. Yisayaava vo kua voovai tuuvaaraatama iya Yisuuva uuvaa teeda rikiadaata hama innara kutaavaivee tiravai. Yisayaava Anutuuqo tuu kua voovai fafaara roo tunoo: ");
INSERT INTO waj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Iya ngiari avuuyauvaa teeda iya yaata tinniiyauvaa rikiada ausaiyauvaa hanigiakiai na iya tuqinneevoora kiaa na iya avuuyauvaa iikiauko upisiikiai na iya yaata tinniiyauvaa iikiauko yaagueeqaivaivee. ");
INSERT INTO waj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yisuunna mmeekia ari vookaraivaa Yisayaava too innara kua tuuvaara ii kua ivaa fafaara roo tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Yisayaava tuu kuaivo itaama vauduaata Yutayaa vaidi kieeta kaayauya Yisuunnara kutaavaivee tiravai. Iya kutaavaivee kiaa kiadaata vaidi Farisaiyara aatuuda hama iya kooyaa Yisuunnara kutaavaivee tiravai. Iya nuunaira nnauyauvaki vikiai vaidi Farisaiya iya ooqoo tivoora kiaa hama kooyaa Yisuunnara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Vaidiiya iyara vaidi yoketaayavee kiaaraivaara iya ausaiyauvo pinaama yoketairavai. Anutuuqo iyara vaidi yoketaayavee tinaraivaara iya ausaiyauvo kiisama yoketairavai. Ivaara hama iya kooyaa Yisuunnara kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yapooma Yisuuva gioonna kiaapuuyaki puaisakama kuaivaa tioo tunoo: Gioonna kiaapu voovoono niiyara kutaavaivee tiivo hama niiyara nnaasu itaa kua tiivai. Ni titoovaaraatama itaa kua tiivai. ");
INSERT INTO waj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Gioonna kiaapu voovoono ni taivoono ni titoovaatama tainoo. ");
INSERT INTO waj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tooba subiaavo mmeekiaivo taineema na mmatayaa tiee gioonna kiaapuuya mmeekiavai tiiravai. Gioonna kiaapu voovoono niiyara kutaavaivee tiivoono upisiivaki varinoora kiaa na mmeekiavai tiiravai. ");
INSERT INTO waj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hama na kua pinaivaa gioonna kiaapuuyaki yapaanaraivaara na tiiravai. Iya vitee aataru yoketaivau yapaanaraivaara na tiiravai. Fai gioonna kiaapu voovoono ni mmayaayaivaa rikioo mmanna yaata nnaasu rikioo hama iinai tee hama na kua pinaana inna yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Fai ivo hama ni mmayaayaivaa rikieerainno niiyara ooqoo tino rikioo kua pinaana inna yapaanaraivo vainoo. Na kiau kuaivo kooyaa vaivaa hama ivo rikieerainno pikino fai yapooma suai nnaagiai ivoono fai kua pinaana inna yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Hama nenenaidiri kuaivaa yaata utuee ngii giaa ngii miauvaivee. Ni Napoova ni titoovoono ariinoo kuaivaa ni giaa ni mioo itaqitaama iya kiaa mmianee tiivaugiataama na ngii giaa ngii miauvaivee. Ivaara fai yapooma suai nnaagiai na kiau kuaivaa hama rikiaivaa ni kuaivoono kua pinaana inna yapaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Vaa na rikiauvai. Ni Napoova tii kuaivaa fai gioonna kiaapu voovoono rikioo iinnonno fai tupatupaa variraivaa varaanaravai. Ivaaraina ivo ni giaa ni mii kuaivaa na ngii giaa ngii miaunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Buusa Varaigiataivaa nneera suaivo vainima vauduu mmuaa suaivai homo vauduu Yisuuva mmatayaa pikioo ari Koonnasi kuanara suaivo vaa vainima nnuuvaa vaa ivo rikieeravai. Ivo ari gioonna kiaapu mmatayaa varuuyara mmannammanna mmuduuya ruuvo ari suaivo taikaanaraivakiaatama mmannammanna iyara mmuduuya riravai. ");
INSERT INTO waj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hannauduu too Yisuuva ari ngiaammuauyaatama yeenna nneeda variravai. Iyakidiri ngiaammuau voovai Simoonaa mmaapuuvaa nnutuuvo Yutaaso Isariooto ivo Yisuunna nnammutuaiya kooyaa inna vitainara kuaivaa vaa Sataango inna yaataivaki yapeeravai. ");
INSERT INTO waj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yisuunna ari Koova mmuakiaa mminnaivaara dianeera yaagueeqaivaa inna mmuuvaa vaa ivo rikieeravai. Iva Anutuuqaasidiri tuuvo kava innasi kuanaraivaaraatama vaa ivo rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ivo itaama rikioo yeenna nnoovaata pikioo diitoo ari yaapa veraayaa diaivaa rabara kioo tauraivaa vara ari tammaivaki rairavai. ");
INSERT INTO waj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Rau kioo nnooriivaa vara kioo pereeta voovaki tusaa kioo ari ngiaammuauya yukuuyauvunu finia roo nuainno varioo tauraivaa ari tammaivaki rauvaadiri iya yukuuyauvunudiri ruga kioo ");
INSERT INTO waj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simoono Petoroosaasi ngioo inna yukuuvaitanau fininara uuduu Petorooso inna tunoo: Udaanga-o, a ni yukuuvaitanau fininarannee? ");
INSERT INTO waj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","tuduu rikioo Yisuuva inna sai tunoo: Aanna na iikiauvaa hama a rikiee taannanoo. Fai yapooma a arinaima rikiee taanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","tuduu rikioo Petorooso inna sai tunoo: Hameetavee. A vaidi nnoonnakuavee. A mmoori vareera ngiaammuauvai roosiima ni yukuuvaitanau fininarainnoo. Aannaata nnaagiai suaiyauvakiaatama sa ni yukuuvaitanaudiri finianee, tuduu rikioo Yisuuva inna sai tunoo: Fai na hama i yukuuvaitanau fininai hama a ni ngiaammuaukua varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","tuduu rikioo Simoono Petorooso inna sai tunoo: Udaanga-o, sa ni yukuuvaitanau nnaasu finianee. Ni yaakuuvaitanaata ni kieetaivaatama finianee, ");
INSERT INTO waj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","tuduu rikioo Yisuuva inna sai tunoo: Gioonna kiaapu voovoono ari mmamma eyommaavai fini kiaivoono ari mmammaivo yoketaivaara hama kava eyommaavai fininaravai. Ari kainaama rii yukuuvaitanaudiri nnaasu fininaravai. Ngia mmuakiaaya hama kainaamaataikiai yoketaama variaavo ngiiikidiri mmuaavoono hama yoketaavai varinoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Vaidi voovoono Yisuunna nnammutuaiya kooyaa inna vitainaraivaa vaa Yisuuva arinaima too rikieeravai. Ivaara ivo tunoo: Ngia mmuakiaaya yoketaama variaavo ngiiikidiri mmuaavoono hama yoketaavai varinoo, tiravai.) ");
INSERT INTO waj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ivo iya yukuuyauvunudiri fini taika kioo ari yaapa veraayaa diaivaa kava vara uyu kioo ari yeenna nnoo varuu mmaataivau variravai. Varioo iya yaparainno tunoo: Aa mmoori na ngii iikiau aavaa oyaivaa vaa ngia teeda rikiaannee? ");
INSERT INTO waj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ngia niiyara Vitaira-o, Udaanga-o, kiaanoo. Na kutaa itaama variauvaara ngia safuumaida itaa kua kiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na ngii udaangavai variee ngii vitairavai variauvoono mmoori vareera ngiaammuauvaa mmoorivai na varee ngii yukuuyauvunu finiaunoo. Ivaara ngieetama mmoori vareera ngiaammuauvaa roosiima ngiingii yuku ngiingii yukuuyauvunu finiatee. ");
INSERT INTO waj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na ngiiiyara iikiauvaa ngieetama iikiateera na mmoori vareera ngiaammuauvaa mmooriivaa mmataama kiee iikiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na kua kutaavai ngii giaa ngii miaunoo. Hama sikaunnaadiri yookaama kioo viteera ngiaammuauvo ari haitatuura nakaaraivaa yaataraivai. Kua varoo nuairaivoono hama ari titeeraivaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ngia ii kua ivaa oyaivaa arinaima teeda rikiada fai iikiokio ngii ausaiyauvo yoketainaravai. ");
INSERT INTO waj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Hama na ngii mmuakiaayara itaa kua kiaunoo. Na mmataama kiauya vaa na taunoo. Anutuuqaa kua fafaara voovai vaivaa kaanaivo aanna makee vainaravai. Kua fafaaraivo tinoo: Vaidi voovoono ni tasipama yeenna nnaivoono mmooka hanigia ni mivaivee, tiivai. ");
INSERT INTO waj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Vaidiivo ngiiikidiri aataru maisaivaa ni minaraivaara na aanna makee mmuaanaa ngii giaa ngii miaunoo. Yapooma ivo aataru maisaivaa ni minai teeda ngia niiyara kutaavaivee kiateeraivaara na mmuaanaa ngii giaa ngii miaunoo. Anutuuqo mmataama kiai vaidiivo neenoovee kiauvaara fai ngia niiyara kutaavaivee kiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu voovoono na innasi titauko kuai gioonna kiaapuuvaara yoketaivoono niiyaraatama yoketainoo. Niiyara yoketaivoono ni titoovaaraatama yoketainoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yisuuva itaa kua kiaa taika kioo rikiooduu inna ausaivo pinaama mmuaararooduu rikioo ivo kooyaa tunoo: Na kua kutaavai ngii giaa ngii miaunoo. Ngiiikidiri mmuaavoono ni nnammutuaiya kooyaa ni vitainaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","tuduu rikiada ari ngiaammuauya ngiari avuki ngiari avukiida tunoo: Ivo giaarainno itaa kua tiinnee, kiaa kaayauma kumimakairavai. ");
INSERT INTO waj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kumimakauduu Yisuuva na inna ngiaammuau ivo niiyara mmuduuya ruuvo na inna vainima hara kiee variaaduu ");
INSERT INTO waj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoono Petorooso niiyara yaaku mmayaayau ruoo ni tunoo: Deevaarainno tiinnee? Inna yaparakianee, ");
INSERT INTO waj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","tuduu rikiee na Yisuunna rainnaa utuee inna yaparainna kiaanoo: Udaanga-o, a giaarainna itaa kua kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","kiaaduu rikioo Yisuuva ni kuaivaa sai tunoo: Na bereetaivaa nnoori suukaivakidiri rabuuma kiee inna mminaraivo inna ivovee, kiaa kioo bereetaivaa rakau utuoo nnoori suukaivakidiri rabuuma kioo Simoonaa mmaapuuvaa Yutaaso Isariootaa mmiravai. ");
INSERT INTO waj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mmuduu varoo saivaata Sataango inna aakiaivaki viravai. Vuduu Yisuuva Yutaasaa tunoo: A iinaraivaa akiairaama iikianee. ");
INSERT INTO waj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ivo itaa kua tuduu rikiada ivaki varida yeenna nnooya hama ivo tuu kua oyaivaa arinaima rikieeravai. ");
INSERT INTO waj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Hama arinaima rikiada vooyaano yaata utida tunoo: Yutaaso sikau utuaivaa haitatuuvaara Yisuuva inna tinoo: Ta turau buusa nnaara yeennaiyauvaa sikaunnaadiri yookaama kiee varaanee, tiinnee? Vara sikauyauvaa varee mmanna haipuuya mmianeerainno tiinnee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iya itaama yaata utida varuduu Yutaaso bereetaivaa varoo makee tuduu mmaanai viravai. Ivo heenaanausi viravai. ");
INSERT INTO waj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutaaso mmaanai vioo kiooduu Yisuuva tunoo: Na Vaidiivaa Mmaapuuvo ni nnutuuvo ngiau aapu kuanara suaivo vaa nninoo. Na iinaraivaara Anutuuqaa nnutuuvootama ngiau aapu kuanara suaivo vaa nninoo. ");
INSERT INTO waj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na iinaraivaara fai Anutuuqaa nnutuuvo ngiau aapu vino fai ariinoo niiyara iino ni nnutuuvootama ngiau aapu kuanaravai. Fai ivo itaama iinno fai akiairaama iinaravai. ");
INSERT INTO waj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ni ngiaammuauso, na ngii tasipama variau suaivo paannama vainoo. Fai ngia niiyara buaama rada nookiaaravai. Ivaara Yutayaa vaidiiya kiaa mmiaa kuaivaa ngiiita ngii giaa ngii miee kiaunoo: Na kuanaraivaki fai hama ngia yopeema kuaaravaivee, kiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na karaasa mmaanna kua aavaa tinai rikiaatee. Ngia ariiyara ariiyara mmuduuya ruatee. Na ngiiiyara mmuduuya ruauneema ngia itaama ariiyara ariiyara mmuduuya ruatee. ");
INSERT INTO waj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Fai ngia ariiyara ariiyara mmuduuya rikiai gioonna kiaapuuya ngii teeda ngiiiyara kiaara: Yisuunna nnaagiai nuaira tuanaayavee, kiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tuduu rikioo Simoono Petorooso inna yaparainno tunoo: Udaanga-o, a deevaki kuanarainna kiannannee? tuduu rikioo Yisuuva inna sai tunoo: Na kuanaraivaki aanna makee hama a yopeema ni nnaagiai kuanaravai. Yapooma fai a ni nnaagiai kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","tuduu rikioo Petorooso inna sai tunoo: Udaanga-o, mo aanna makee aaniira hama na i nnaagiai kuanarannee? Fai na aiyara putinaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","tuduu rikioo Yisuuva inna sai tunoo: A kutaa tuanaa niiyara putinaraivaara ee-oo kiannannee? Na kua kutaavai i kiaa i mmiaunoo. Hama kakaraivo akua tirainno kinai rikiee a taaravoomaneetu niiyara tinara: Hama na inna tauvaivee, tinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yisuuva kiaa kioo ari ngiaammuauya tunoo: Sa ngii ausa mmuaarareera tasipama variatee. Anutuuqaara kutaavaivee tida niiyaraatama kutaavaivee kiatee. ");
INSERT INTO waj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ni Napoonna yoosinnaivo pinaavai vaikio kaayau nnauyauvo ivaki vainoo. Hama itaama vaitiri. Hama na ngii giaa ngii miautirivee. Ngia variaaraivaa neenoo viee teerama kiaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Fai na viee ngia variaaraivaa teerama kiee fai na kava vara ranee tiee ngii vitee nene variauvaki ngia ni tasipama variateeraivaara na ngii vitaanaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na oro varinara aataruuvaa vaa ngia taavaivee, ");
INSERT INTO waj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","tuduu rikioo Tumaaso inna tunoo: Udaanga-o, yoosinna a kuanaraivaki hama ta taunnanoo. Dataama kiada ii yoosinna ivakira vira aataruuvaa ta taarannee? ");
INSERT INTO waj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","tuduu rikioo Yisuuva inna sai tunoo: Neenoo aataruuvaa nakaaraivovee. Neenoo kua kutaivaa nakaaraivovee. Neenoo tupatupaa variraivaa nakaaraivovee. Fai hama gioonna kiaapu voovoono niikinaadiri ngioo fai hama ni Napoonnasi kuanaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngia arinaima ni taatiri. Ni Napoonnaatama arinaima taatirivee. Aqaa suai aavakidiri vaa ngia arinaima ni Napoonna teeda rikiada arinaima inna taanoo, ");
INSERT INTO waj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","tuduu rikioo Piriipo inna tunoo: Udaanga-o, ai Koonna ti vitainai fai ta teeda kiaara: Inna aikioovaivee, kiaaravee, ");
INSERT INTO waj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","tuduu rikioo Yisuuva inna sai tunoo: Piriipo, na hokoba suai ngii tasipama variaukai a hama arinaima ni taannannee? Gioonna kiaapu voovoono ni taivoono ni Napoonnaatama taivaivee. Mo a dataama kieenna kiannanoo: Ai Koonna ti vitaakianee, kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ni Napoova niiki varikiai na innaki variauvaara hama a kutaavaivee kiannannee? Na kiau kuaivaa hama nenenaidiri yaata utuee ngii giaa ngii miaunoo. Hameetavee. Ni Napoova niiki variivoono ari mmooriivaa varaivai. ");
INSERT INTO waj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ni Napoova niiki varikiai na innaki variauvaara kutaavaivee kiatee. Fai ngia hama ivaara ngii kutaavaivee kiatainai na mmoori varauyauvo kooyaa vaiyauvaa teedama niiyara kutaavaivee kiatee. ");
INSERT INTO waj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na kua kutaavai ngii giaa ngii miaunoo. Gioonna kiaapu voovoono niiyara kutaavaivee tiivoono fai na iikiau mmooriiyauvaa ivootama iinaravai. Na ni Napoonnasi kuanaraivaara ivo ii mmooriivoono na iikiauyauvaa yaataraanaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Fai ngia niiyara yaata utida vo kuavaara ni Napoonna yaparaikiai fai na iinaravai. Ni Napoonnara kua yoketaivaa kiateeraivaara neenoo ari Mmaapuuvoono na iinaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Fai ngia niiyara yaata utida vo kuavaara ni yaparaikiai fai na iinaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yisuuva itaa kua kiaa kioo tunoo: Fai ngia niiyara mmuduuya ridaida mmaanna kua na kiauyauvaa fai ngia rikiada puaisakama utida iikiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Fai neenoo ni Napoonna yaparaino ivoono niinikaraama Ngiiiyara Kua Tira Mmannasa Kua Kutaa Tiraivaa titano tuoo ngii tasipama tupatupaa varinaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Gioonna kiaapu mmatayaa kumimakama variraiya hama Anutuuqaa Mmannasa Kua Kutaa Tiraivaa teeda rikiaanoo. Hama inna teeda rikiaivaara hama inna varaanoo. Vaa ngia inna teeda rikiaanoo. Ivo aanna ngii tasipama varioo fai yapooma ngii aakiaana varinaraivaara ngia inna teeda rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Fai na hama ngii pikiee eeyaara vinai ngia viina nnaakara roosiima variaaravai. Fai na kava vara ranee ngiiisi tiinaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Fai kiisa suaivo taikanai gioonna kiaapu mmatayaa kumimakama variaiya hama kava ni taaravai. Fai ngieenoo kava ni taaravai. Na tupatupaa hara kiee variauvaara ngieeta itaama tupatupaa hara kiada variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ii suai ivaki na kava diitee varinara suaivaki na ni Napoonnaki variauvaara fai ngia arinaima rikiaaravai. Ngia niiki variaani na ngiiiki variauvaaraatama fai ngia arinaima rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Gioonna kiaapu voovoono na kua mmaanna kiauyauvaa rikioo iivoono niiyara mmuduuya ruainoo. Ivo niiyara mmuduuya ruaivaa ni Napoova innara mmuduuya rinaravai. Neetaatama fai innara mmuduuya ruee na inna tasipama varinaraivaara kooyaa inna vitainaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","tuduu rikioo Yutaaso Isariootaa ferengaava Yutaasoono Yisuunna yaparainno tunoo: Udaanga-o, mo dataama kiee fai a aiyara kooyaa ti vitainna mmatayaa kumimakama variaiya fai hama aiyara kooyaa vitainarannee? ");
INSERT INTO waj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","tuduu rikioo Yisuuva inna sai tunoo: Ai, mo gioonna kiaapu voovoono niiyara mmuduuya ruoo ni kuaivaa rikioo puaisakama utuoo iino fai ni Napoova innara mmuduuya rinaravai. Mmuduuya rinai fai neeta ni Napoovaatama innasi tiida inna tasipama variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Fai gioonna kiaapu voovoono hama niiyara mmuduuya ruoo fai hama ni kuaiyauvaa rikioo puaisakama utuoo iinaravai. Aa kua aavaa ngia rikiaa aavo hama ni kuavai. Ni Napoova ni titoovaasidiri tii kuavai. ");
INSERT INTO waj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na homo ngii tasipama variau suaivaki ii kua iyauvaa ngii giaa ngii miauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Fai yapooma Ngiiiyara Kua Tira Mmannasa Yoketaivaa ni Napoovaano na kiauvaugiataama titano tiinaraivoono fai mmuakiaa kuaiyauvaa ngii giaa ngii minaravai. Ngii giaa ngii mioo ngii tinai rikiada vaa na ngii giaa ngii miaukai rikiada vueennama kiaa kuaiyauvaa fai ngia keenaa rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na viee ausa nuufa tasipama varira aataruuvaa ngii mi kiee kuanaravai. Hama gioonna kiaapu mmatayaa variaiya ausa nuufa mmirayaama ngii minaravai. Na neneenoo nini ausa nuufa tuanaivaa ngii mi kiee na ngii pikiee kuanaravai. Sa ngii ausa mmuaarareera tasipama varida sa aatu aatuukiatee. ");
INSERT INTO waj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na ngii pikiee viee yapooma kava vara ranee ngiiisi tiinara kuaivaa na ngii giaa ngii miauvaa vaa ngia rikiaavai. Fai ngia niiyara mmuduuya rida fai na ni Napoonnasi kuanara kiau kuaivaa ngia rikiada sirigakiaaravai. Ni Napoova ni yaataraivaara ngia itaama sirigakiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ii kua na ngii giaa ngii miau ivaa kaanaivo hama vainara suaivaki na mmuaanaa ngii giaa ngii miaunoo. Fai yapooma kaanaivo vainai teeda ngia niiyara kutaavaivee kiateeraivaara na mmuaanaa ngii giaa ngii miaunoo. ");
INSERT INTO waj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gioonna kiaapu mmatayaa diaiyara geedai dira vaidiivoono nninara iinno variivaara na hama hokobama ngiiita kua tinaravai. Inna yaagueeqaivo hama yopeema ni yaataraivai. ");
INSERT INTO waj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Na ni Napoonnara mmuduuya ruauvaara gioonna kiaapu mmatayaa diaiya teeda rikiaateeraivaara mmuakiaa kuavai ivo ni tiivaugiataama na iikiaunoo. Diitada aavaki pikiada vikiai ta kuaaravee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yisuuva tunoo: Neenoo yeena vuaina tuanaivaa roosiima variaunoo. Ni Napoova mmoori nakaaraivo varinoo. ");
INSERT INTO waj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ni hammara hama iira vaivaa ni Napoova fai hatoka kagaari kioo hammara iira vainno aasannanaivaa hatoka kino too fai iiraivo oyaivakidiri kaayauma suvuai kioo vainaravai. Kaayau iiraiyauvo vakiaiveeraivaara ni Napoova itaama iivai. ");
INSERT INTO waj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na ni kua mmayaayaivaa ngii giaa ngii muuvaaraida vaa ngia yoketaaya variaanoo. ");
INSERT INTO waj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ngia niiki varikiai na ngiiiki varinai fai ta mmuaavau variaaravai. Hammaraivo fai hama oyaivaa tasipama vaino fai hama yopeema iiraivo vainaravai. Itaama vaineema ngia hama fai niiki varikio fai hama yopeema iiraivo vainaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Neenoo yeena vuaina oyaivaa roosiima variaukai ngieenoo hammaraivaa roosiima variaanoo. Gioonna kiaapu voovoono niiki varinai na innaki varino kaayau iiraiyauvo suvuainaravai. Ivaara fai gioonna kiaapu voovoono hama ni tasipama varirainno arinaidiri mmooriivaa iino rikioo fai hama kaanainaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Gioonna kiaapu voovoono hama niiki varino hammara hama iira vaivaa rakau kagaari kiaavo aasannaivaa roosiima varinoo. Yapooma hammaraiyauvaa itaineema iya iyauvaa rupi nuunama kiada ikiaivaki kagaari kikio ikiaivo taanaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Fai ngia niiki varikio ni kuaivo ngiiiki vainai vo kua vo kuayauvaara ngii iikiataiyauvaara Anutuuqaa yaparaikio fai ivo ngiiini iinaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yeena vuainaivaki kaayau iiraiyauvo vaineema ngia ni mmooriivaa iikio iiraiyauvo vainoonno ni Napoonna nnutuuvo ngiau aapu kuanaravai. Fai ngia itaama iidada ni nnaagiai nuaira tuanaaya variaiyarainno ni Napoonna nnutuuvo ngiau aapu kuanaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ni Napoova niiyara mmuduuya ruaineema na ngiiiyara mmuaikaraama mmuduuya ruaunoo. Na mmannammannama kiee ngiiiyara mmuduuya ruauvaara ni mmuduuya rira aakiaivaki variatee. ");
INSERT INTO waj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na ni Napoonna kua mmaanna iyauvaa rikiee iina inna mmuduuya rira aakiaivaki mmannammanna variaunoo. Itaama vaineema fai ngia ni kua mmaanna iyauvaa rikiada puaisakama utida iida na ngiiiyara mmuduuya rira aakiaivaki mmannammanna variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ni sirigairaivo ngiiiki vainno pinaavai vakiaiveeraivaara na ii kua ivaa ngii giaa ngii miauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aa mmaanna kua na tinara aavo ataama vainoo. Na ngiiiyara mmuduuya ruauneema ngia ngiingiiiyara ngiingiiiyara mmuduuya ruatee. ");
INSERT INTO waj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Vaidi voovoono ari seenaiyara mmuduuya ruoo hama ari mmammaivaara yaata utirainno pinaama iyara mmuduuya ruaivaara putivai. Ii mmuduuya rira ivo mmuakiaa mmuduuya riraiyauvaa yaataraivai. ");
INSERT INTO waj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Fai ngia ni kua mmaanna iyauvaa rikiada iidaida ni seena tuanaaya variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sikaunnaadiri yookaama kioo viteera ngiaammuauvo hama ari haitatuura vaidiivaa yaata tinniyaa vai kuaivaa rikiaivai. Ivaaraina na hama mmannammanna ngiiiyara ni mmoori vareera ngiaammuauyavee tinaravai. Hamavee. Na ngiiiyara kiaunoo: Ni seena tuanaayavee, kiauvaivee. Na ni Napoova ni giaa ni muu kua mmuakiaayauvai ngii giaa ngii miaiyauvaara na ngiiiyara ni seena tuanaayavee kiauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Hama ngieenoo ni mmataama kieeravai. Neenoo nnaasu ngii mmataama kiaaduu ngia ni mmooriivaa varakio iiraivo kaayau vakiaiveeraivaara na ngii mmataama kieeravai. Ngii mmoori varaivaa iiraivo tupatupaa vainaraivaara na ngii mmataama kieeravai. Fai ngia itaama iida dee aataru mminnaa voovaara ni Napoonna yaparaikio fai ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ivaaraina aa kua aavaa na ngii giaa ngii miee kiaunoo: Ngia ngiingiiiyara ngiingiiiyara mmuduuya ruatee, kiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Fai gioonna kiaapu mmatayaa diaiya hama ngiiiyara mmuduuya rikiai ivaudiri arinaima rikiaatee. Iya tauraa hama niiyara mmuduuya ruaaneemaida hama ngiiiyara mmuduuya ruaanoo. ");
INSERT INTO waj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Fai ngia kutaa tuanaa gioonna kiaapu mmatayaa diaiya roosiima varikiai fai iya ngiiiyara ti seena tuanaayavee kiaa kiada ngiiiyara mmuduuya ruaaravaivee. Hama ngia itaa kiaiya roosiima variaanoo. Neenoo iyakidiri ngii mmataama kiaukai ngia hama iya roosiima variaanoo. Ivaaraida iya hama ngiiiyara mmuduuya ruaanoo. ");
INSERT INTO waj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na tauraa ngii giaa ngii miaaduu ngia taunnu kioo kuaivaa kava rikiaatee. Na tauraa kiaanoo: Hama sikaunnaadiri yookaama kioo viteera ngiaammuauvo ari haitatuura vaidiivaa yaataroo ari vookaraama varinaravaivee, kiaivaara na ngii giaa ngii miaunoo. Fai iya mmoori maisaivaa ni mida fai ngiiitaatama ngii miaaravai. Fai iya ni kuaivaa rikiada puaisakama utida iida fai ngii kuaivaatama rikiada puaisakama utida iikiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngia niiyara kutaavaivee kiaivaaraida iya mmoori maisa mmuakiaavai ngii miaaravai. Hama ni titoovaa teeda rikiaivaaraida mmoori maisaivaa ngii miaaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na hama tuma iyaata kua kiaatiri. Hama iya niiyara mmoori maisaivaa iikiaaraivaara yaata utida mminnamminnaa maisaivaa varotirivee. Vaa na tuma kooyaa iya kiaa mmiaivaara hama iya yopeema unnakua kiaara: Hama ta rikiaunnanoo, kiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Gioonna kiaapu voovoono hama niiyara mmuduuya ruoo hama ni Napoonnaraatama mmuduuya rinoo. ");
INSERT INTO waj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mmatayaa diaiya hama iida too mmoori ari vookarauvaa na hama iyaki nuaina iikiaatiri. Hama iya niiyara mmoori maisaivaa iikiaaraivaara yaata utida mminnamminnaa maisaivaa varotirivee. Vaa na ivaa iyaki nuaina variee iikiaaduu teeda rikiadaata iya hama niiyara mmuduuya rida hama ni Napoonnaraatama mmuduuya ruaanoo. ");
INSERT INTO waj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Anutuuqaa mmaanna tuu kua voovai kaanaivo vakiaiveeraivaara iya tiiyara itaama iikiaanoo. Kua mmaanna tuu kuaivo tunoo: Iya kumina kieemaida hama niiyara mmuduuya ruaanoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ngiiiyara Kua Tiraivo fai ni Napoonnasidiri tiinaravai. Na ii Mmannasa Kua Kutaa Tira ivaa fai ni Napoonnasidiri na titano too tuoo fai niiyara kua tinaravai. ");
INSERT INTO waj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na toosa hara mmoori varaaduu ngia ni tasipama varuuya aanna homo variaivaaraida fai ngieetama niiyara kua kiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ngia niiyara kutaavaivee tiraivaara taara yaata utivoora kiaa na ii kua iyauvaa ngii giaa ngii miauvaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Fai vaidiiya nuunaira nnauyauvakidiri ngii ooqoo tida ngii titakiai fai ngia pikiada kuaaravai. Fai yapooma suai nnaagiai suaivo nninai rikiada iya ngii ruputikiai putuaaraivaara kiaara: Ta Anutuuqaa mmoori yoketaivaa iikiaunnayavee, kiaa kiada ngii ruputuaaravai. ");
INSERT INTO waj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iya hama ni Napoonna teeda rikiada hama niitaatama teeda rikiaivaara fai iya ii aataru ivaa iikiaaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Vaa na aanna makee ii kua iyauvaa ngii giaa ngii miaunoo. Fai yapooma ii na kiau kua iyauvaa iya iikio rikioo kaanaivo vainara suaivaki ngia kava rikiaaraivaara na mmuaanaa ngii giaa ngii miaunoo. Tauraa na ngii tasipama variaa suaivaki na ngii tasipama variauvaara hama na ii kua iyauvaa ngii giaa ngii miravai. ");
INSERT INTO waj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aa kiisa suai fai na ivo ni titoovaasi kuanaravee. Na kuanara iino rikioo hama vaidi voovoono ngiiikidiri diivoono ni yaparainno tinara: A deepiinna kuannannee? tinaravee. ");
INSERT INTO waj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na ii kua iyauvaa vaa mmuaanaa ngii giaa ngii miauvaara ngii ausaiyauvo pinaama mmuaararainoo. ");
INSERT INTO waj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na kua kutaavai ngii giaa ngii miaunoo. Na ngiiiyara yaata utuee ngia yoketaama variaaraivaara na kuanaravee. Hama fai na vino fai Ngiiiyara Kua Tiraivo hama ngiiisi tiinaravai. Fai na viee titano fai ivo ngiiisi tiinaravai. ");
INSERT INTO waj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Fai ivoono tuoo mmatayaa variaa gioonna SB7kiaapuuya iinai rikiada fai ngiari mminnamminnaa maisa SB9iira oyaivaa arinaima teeda rikiada safuuma variraivaa oyaivaa arinaima teeda rikiada kua pinaa iira aataruuvaa oyaivaa arinaima teeda rikiaaravai. ");
INSERT INTO waj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iya mminnamminnaa maisa iira oyaivo ataama vainoo. Hama iya niiyara kutaavaivee kiaivaara ngiari mminnamminnaa maisa iira oyaivo kooyaa vainoo. ");
INSERT INTO waj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Iya safuuma variraivaa oyaivo ataama vainoo. Na ni Napoonnasi vinai ngia hama kava ni taaraivaara fai iya safuuma variaaraivaa oyaivo kooyaa vainaravai. ");
INSERT INTO waj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kua pinaa iira aataruuvaa oyaivo ataama vainoo. Gioonna kiaapuuyara geedainni dira kieetaivaa vaa Anutuuqo kua pinaivaki inna yapa kioo inna yaatara kioovaara iya kua pinaa iira aataruuvaa oyaivo kooyaa vainaravai. ");
INSERT INTO waj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na niiki kaayau kua vaikiai na ngii giaa ngii minaraivo fai na ngii giaa ngii minai makee hama ngia yopeema rikiada varaaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Fai Mmannasa Kua Kutaa Tiraivo tuoo fai ivoono mmuakiaa kua kutaiyauvaa ngii giaa ngii mioo ngii vita vitainaravai. Fai ivo kua voovai hama arinaidiri yaata utuoo tinaravai. Kua ivo rikiaivaa nnaasu tinaravai. Tuoo fai ivo mminnaa vooyauvai nnaagiai nninaraiyauvaara ngii giaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Fai ivo ni kuaivaa rikioo ivaa nnaasu varoo ngii giaa ngii minaraivaara fai ni nnutuuvo ngiau aapu kuanaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mmuakiaa ni Napoonna mminnaiyauvo inna niiniyauvaivee. Ivaara na kiaunoo: Fai Mmannasa Kua Kutaa Tiraivo ni kuaivaa rikioo ivaa nnaasu ngii giaa ngii minai ngia rikiaaravaivee, kiaunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yisuuva itaa kua kiaa kioo tunoo: Kiisa suai fai hama ngia kava ni taaravaivee, kiaa kioo tunoo: Fai kava nnaagiai kiisa suai ngia ni taaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","tuduu rikiada ari ngiaammuau vooyaano ngiari yapara ngiari yaparaida tunoo: Aanii kua oyaivainno ivo tiita itaa kua tiinnee? Ivo tinoo: Kiisa suai fai ngia hama ni taaravai. Fai ngia kava kiisa suai nnaagiai ni taaravaivee, kiaa kioo vo kuavai tinoo: Na ni Napoonnasi kuanaraivaara itaa kua kiaunoo, tinoo. ");
INSERT INTO waj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ivo kiisa suaivee tiivo inna datai kuavainnee? Hama ivo itaa kua tii kua oyaivaa ta rikiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","tuduu rikioo Yisuuva iya inna yaparakiaaree kiaa uu kuaivaa vaa ivo too rikieeravai. Rikioo iya tunoo: Vo ngia aa na kiau kua aavaa oyaivaaraida ngiingii yapara ngiingii yapara kiaannee? Na ataa kua kiaunoo: Kiisa suai fai ngia hama ni teeraida kava fai kiisa suai nnaagiai ni taaravaivee, kiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na kua kutaavai ngii giaa ngii miaunoo. Fai ngia pinaama ratada boo tira tasipama variaaravai. Ratada varikiai fai gioonna kiaapu kumimakama mmatayaa variaiya pinaama sirigakiaaravee. Ngia ausa mmuaararai tasipama variaivo fai hanigioo yoketainaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Gioonnaivo taikio nnaakara mmateera suaivo nnikio too ari mmammaivo nniitaraanaraivaara ausa mmuaararai tasipama mmataivai. Nnaakaraivaa mmata kioo hama kava nnaagiai mmamma nniitaraivaara pinaama yaata utivai. Nnaakaraivo kooyaa hara kioo variivaara sirigainno hama ari mmamma nniitareeraivaara yaata utivai. ");
INSERT INTO waj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Itaama vaineema aanna makee ngiiita ngii ausaiyauvo mmuaararainoo. Fai na kava ngii taanara suaivaki ngii ausaiyauvo sirigainaravai. Itaino fai hama yopeema vaidi voovoono mmoori maisaivaa ngii iino ngii ausa sirigairaivo taikaanaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Fai ii suai ivo nninai ngia hama aataru mmoori mminnaa voovaara ni yaparakiaaravai. Na kua kutaavai ngii giaa ngii miaunoo. Fai iqii suai ivaki ngia ni nnutuuvaa tida aataru mmoori voovaara ni Napoonnaata kua tida yaparaikio rikioo fai ivo ngia inna yaparakiaivaa ngii minaravai. ");
INSERT INTO waj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tauraa varuu suaivaki varia rada nnidada aanna makee variaa suaivakiaatama ngia hama ni nnutuuvaa tida ni Napoonna yaparakiaavai. Yaparakiatee. Fai yaparaikio ngii sirigairaivo ngiiiki vaivo pinaavai vakiaiveera fai ni Napoova ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Na aanna ii kua iyauvaa mminnaa vooyauvunudiri mmataama kiee ngii giaa ngii miaunoo. Fai suai nnaagiai suaivo nninai hama na kava mmataira kua ngii giaa ngii minaravaivee. Fai na ni Napoonnara kua kooyaa ngii giaa ngii minaravaivee. ");
INSERT INTO waj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Fai iqii suai ivaki ngia niiyara yaata utida inna yaparakiaaravai. Hama na ngii giaa ngii miee kiaunoo: Fai neenoo innaata ngiiiyara yaaku varee kua tinaravee. Hama na itaama ngii giaa ngii miaunoo. ");
INSERT INTO waj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Anutuuqo ariinoo ngiiiyara mmuduuya ruaivaara na hama innaata ngiiiyara kua tinaravee. Ngia niiyara mmuduuya rida na Anutuuqaasidiri tummuauvaara ngia kutaavaivee kiaivaara Anutuuqo ariinoo ngiiiyara mmuduuya ruaivai. ");
INSERT INTO waj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na ni Napoonnasidiri aapi mmatayaa tummuauvai. Fai na mmata aavau pikiee kava ni Napoonnasi kuanaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","tuduu rikiada ari ngiaammuauya inna sai tunoo: Aanna vaa a kuaivaa kooyaa kiannani ta rikiaunnanoo. Hama a mminnaa voovaudiri mmataama kiee kiannanoo. ");
INSERT INTO waj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vaa ta rikiaunnanoo. A mmuakiaa mmoori aataruuyauvaata mmuakiaa mminnaiyauvaatama tee rikiaannanoo. Fai gioonna kiaapu voovoono hama vo kua vooyauvaara aita kua tioo i yaparainaravai. Vaa a mmoori aataru mmuakiaayauvai tee rikiaannaivaara ta kiaunnanoo: A Anutuuqaasidiri tummuannakuavee, kiaunnanoo. ");
INSERT INTO waj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yisuunna ngiaammuauya itaa kua tuduu rikioo iva iya sai tunoo: Mo aanna makee ngia niiyara kutaavaivee kiaannee? ");
INSERT INTO waj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Fai kiisa suai ii suai ivo nninai teeda ngia mmuakiaaya aatuuda raubiriida mmuaavai mmuaavai ngiingii nnauyauvaki vida ni pikikiai nenevana varinaravee. Mo hama kutaa nenevana variaunoo. Ni Napoova ni tasipama varinoo. Ai, ii suai ivo aavaa nninoo. ");
INSERT INTO waj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ni mmannasaivoota ngii mmannasaiya tasipama mmuaavau variivaara ngii ausaiyauvo nuufama vakiaiveeraivaara na ii kua ivaa ngii giaa ngii miaunoo. Ngia mmatayaa varikiai fai gioonna kiaapuuya mmoori maisa mmamma nniitareera mmooriiyauvaa ngii miaaravee. Sa ivaara yaata utiraida niiyara yaata utida yaagueeqama variatee. Vaa na mmatayaa diaiya mmoori maisaiyauvaa yaataraunoo, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yisuuva ii kua ivaa kiaa taika kioo avuuvaa ngiau reeri too tunoo: Ni Napoo-o, ii suai ivo vaa nninoo. Na i Mmaapuuvoono i oyai ari vookaraivaa iya vitaakiaiveeraivaara eenoo ni oyai ari vookaraivaa iya vitaakianee. ");
INSERT INTO waj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Eenoo gioonna kiaapu ni miannaiya na tupatupaa variraivaa iya mmiaiveeraivaara a mmuakiaa gioonna kiaapuuyara dira aataruuvaa vaa ni miannavai. ");
INSERT INTO waj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tupatupaa varira aataruuvo ataama vainoo. E Anutuuqo mmuaa tuanaavai kutaa variannaivaa gioonna kiaapuuya arinaima i teeda rikiada na Yisuu Kirisiinna a ni mmataama kiee ni titaannaivaata iya arinaima ni teeda rikiada fai tupatupaa variraivaa varaaravai. ");
INSERT INTO waj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na mmatayaa variau suaivaki a mmuakiaa mmoori ni miannaiyauvaa vaa na iima taika kiauvai. Na iina variau suaivaki i oyai ari vookaraivaa vaa na iya vitaakiauvai. ");
INSERT INTO waj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Boo, ni Napoo-o, tauraa a hama ngiau mmata uunna suaivaki na i tasipama variee ari vookaraama variravai. Aa paanna suai na kava i tasipama varinara suaivaki ii tauraa ari vookaraama varira ivaa a ni munnaivaa kava ni mianee. ");
INSERT INTO waj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Vaidi mmatayaa diaiyakidiri a ni miannaiya vaa na aiyara kooyaa iya kiaa kookieema kiauvai. A mmataama kiee haitatuukianna vaidiiya ni miannani iya i kuaivaa rikiada puaisakama utida iikiaavai. ");
INSERT INTO waj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Mmuakiaa kuaiyauvaa a ni giaa ni miannaiyauvaa na iya kiaa mmiaukai iya rikiada varaavai. Na aisidiri tummuaivaa iya teeda rikiada kutaavaivee kiaanoo. Anutuuqo eenoo ni titooduu na tummuaivaaraatama iya teeda rikiada kutaavaivee kiaanoo. Iya itaa kua kiaa kiada variaivaara vo kuavaatama rikiaanoo. Eenoo mmuakiaa mminnaayauvai ni miannaiyauvo aisidiri nniiyauvaivee. Aanna makee vaa ivaara iya arinaima rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na iyara yaaku varaunoo. Eenoo iya mmataama kiee haitatuukiannaivaara na iyara yaaku varaunoo. Gioonna kiaapu mmatayaa kumimakama variaiyara hama na iyara yaaku varaunoo. Vaidiiya a ni miannaiyara na yaaku varaunoo. ");
INSERT INTO waj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na utuau vaidi mmuakiaaya ainiyavee. A utuanna vaidi mmuakiaaya niiniyavee. Iya varida ni mmooriivaa varaavo ni oyai ari vookaraivo kooyaa vainoo. ");
INSERT INTO waj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Fai na aisi kuanaravai. Na paanna suai mmata aavaudiri pikiee vinai fai iyaata ni nnutuuvaatama mmata aavau variaaravai. Ni Napoo-o, a yoketaa tuanaa ari vookaraakiannakuavee. Vaa ai yaagueeqaivaata ni nnutuuvaatama a ni miannano ni nnutuuvo vaivaara iyara haitatuunna iya atau ruanee. Ta mmuaavaugiataama variaunnaneema iyaatama mmuaavaugiataama variateeraivaara iyara haitatuunna atau ruanee. ");
INSERT INTO waj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na iya tasipama variau suaivaki ai yaagueeqaivaata ni nnutuuvaatama a ni miannaivaara na yaata utuee iya haitatuuna atau ruauvai. Na iya vara hiri diaukai hama mmuakiaaya haparaida tiida kuaavo mmuaavoono nnaasu tuoo kuaivai. Ivo tuoo kuaivaara Anutuuqaa yanaivau vai kua fafaaraivo vaa kaanainoo. ");
INSERT INTO waj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aa paanna suai fai na aisi kuanaravai. Ni sirigairaivo iyaki vainno pinaavai vakiaiveeraivaara na mmatayaa variee ii kua iyauvaa iya kiaa mmiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Vaa na i kua mmayaayaivaa iya kiaa mmiaukai rikiada iya hama mmatayaa diaa aataruuyauvaara yaata utuaavai. Iya ni roosiima hama mmatayaa diaa aataruuyauvaara yaata utuaivaara gioonna kiaapu homoraiya hama iyara mmuduuya ruaavai. ");
INSERT INTO waj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hama aa mmata aavaudiri e aaya vitee kuanaraivaara na yaaku varaunoo. Sataango iya utinoora tiee eenoo iya vara hiri dianeera na i kiaa i mmiee yaaku varaunoo. ");
INSERT INTO waj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na hama mmatayaa aataruuyauvaara yaata utuauneema ni roosiima hama iyaata mmatayaa aataruuyauvaara yaata utuaavai. ");
INSERT INTO waj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Iya yoketaama vaidi tuanaaya variateeraivaara ai kua kutaivaa iya kiaa mmiee iya tasipama varianee. ");
INSERT INTO waj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Eenoo mmatayaa diaa gioonna kiaapuuyara ni titoneema neenoo ni mmayaayaivaa gioonna kiaapu homoraiya kiaa mmiateeraivaara iya titauvai. ");
INSERT INTO waj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iya yoketaama vaidi tuanaaya variateeraivaara na iyara yaata utuee na nini mmamma mmuyai mmuakiaavai i mmiaunoo. Iya kua kutaa tuanaa i mmaapu tuanaaya variateeraivaara na nini mmamma mmuyai mmuakiaavai i mmiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na hama iyara nnaasu yaaku varee aita kua kiaunoo. Iya ai mmayaayaivaa gioonna kiaapuuya kiaa mmikiai niiyara kutaavaivee kiaaraiyaraatama yaaku varee aita kua kiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Niiyara kutaavaivee kiaara mmuakiaaya mmuaa tinni mmuaa ausavai varada mmuaakaraama variateeraivaara na yaaku varaunoo. Eenoo niiki variannani na aiki variaunoo. Ni Napoo-o, ta mmuaavau itaama variaunnaneema eenoo iya tasipanai iya ti tasipama variaaravai. Eenoo kutaa ni titooduu na tummuaivaara gioonna kiaapu homoraiya kutaavaivee kiaaraivaara vaa niiyara kutaavaivee kiaiya mmuaa tinni mmuaa ausavai varada variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eenoo ni nnutuuvaa ngiau aapu yapaannani neenoo mmuaikaraama iya nnutuuyauvaa ngiau aapu yapauvai. Ta mmuaa tinni mmuaa ausavai varada variaunnaneema iyaatama mmuaa tinni mmuaa ausavai varada variateeraivaara na iya nnutuuyauvaa ngiau aapu yapauvai. ");
INSERT INTO waj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iya kutaa tuanaa mmuaa tinni mmuaa ausavai varada variaaraivaara eenoo niiki variannani neenoo iyaki variauvai. Eenoo ni titooduu na tummuaivaara gioonna kiaapu homoraiya kutaavaivee kiaaraivaara iya mmuaa tinni mmuaa ausavai varada variaaravai. Eenoo niiyara mmuduuya ruannaneema iyaraatama mmuduuya ruannaivaara gioonna kiaapu homoraiya kutaavaivee kiaaraivaara iya mmuaa tinni mmuaa ausavai varada variaaravai. ");
INSERT INTO waj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ni Napoo-o, hama a ngiau mmata uunna suaivaki eenoo niiyara pinaama mmuduuya runnaivaara oyai ari vookarauvaa ni miravai. Niiyara kutaavaivee tiraiya vaa eenoo ni miannavai. Iya ni oyai ari vookaraivaa taaraivaara na varinaraivaki ni tasipama iya variaaravai. Iya itaama ni tasipama variaaraivaara ni yoketainoo. ");
INSERT INTO waj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ni Napoo-o, a safuuma variraikuavee. Gioonna kiaapu mmatayaa diaiya hama aiyara arinaima teeda rikiaanoo. Neenoo aiyara vaa arinaima tee rikiaunoo. Eenoo ni titooduu na tummuaivaa vaa niiyara kutaavaivee kiaiya arinaima teeda rikiaanoo. ");
INSERT INTO waj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Eenoo niiyara mmuduuya ruannaneema iyaatama mmuaakaraama gioonna kiaapuuyara mmuduuya rikiai na iyaki varinaraivaara na aiyara iya kiaa kookieema kiee makemakee na aiyara iya kiaa kookieenaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yisuuva ii kua ivaa kiaa taika kioo ari ngiaammuauya vitoo vioo ivaki pikioo nnoori kiisa voovai nnutuuvo Ketaroonaa vioo karoo sainai viravai. Vioo tooduu mmooriivaki yatari oriipaiyauvo vauduu Yisuuva ari ngiaammuauyaatama ivaki viravai. ");
INSERT INTO waj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ii mmoori ivaki Yisuuva ari ngiaammuauyaatama mmuakiaa suai nuunaida varuuvaara vaa Yutaaso rikieeravai. Yutaaso Yisuunna nnammutuaiya fai kooyaa inna vitainaraivaara kua yeena raira vaidivai. ");
INSERT INTO waj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Vaidi Anutuuqaara kati puara hudeera kieetaiyaata Farisaiyaatama vaidi nuunaira nnau pinaivaara haitatuura vaidi vooya titooduu iya rapira vaidiiyaatama sunada ngiari yau mmataiyauvaata ngiari toobaiyauvaatama varada nnuduu Yutaasoono iyaata vitoo Yisuuva ari ngiaammuauyaatama varuu mmooriivaki viravai. ");
INSERT INTO waj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Vida tooduu Yisuuva vaa iya inna iikiaara mmoori mmuakiaavai rikioovoono iya saidiri numa iya too tunoo: Mo ngia giaaraida buaakiaannee? ");
INSERT INTO waj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","tuduu rikiada iya inna sai tunoo: Mo ta Nasareetaa vaidi Yisuunnaraida buaakiaunnanoo, tuduu rikioo iva iya tunoo: Mo na aanna ivovee, tiravai. Yutaaso Yisuunna nnammutuaiya fai kooyaa inna vitainaraivoono iya tasipama ivaki diravai. ");
INSERT INTO waj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yisuuva iya tunoo: Mo na aanna ivovee, tuuvaara iya hayida oro ngieerama vau mmataivau vida varada vairavai. ");
INSERT INTO waj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Vauduu rikioo Yisuuva kava iya tunoo: Mo ngia giaaraida buaakiaannee? tuduu rikiada iya kava tunoo: Mo ta Nasareetaa vaidi Yisuunnaraida buaakiaunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","tuduu rikioo Yisuuva iya tunoo: Vaa na ngii giaa ngii miauvaivee. Na aanna ivovee. Fai ngia kutaa niiyara buaida varida aa ni ngiaammuau aadaa pikikiai kuatee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ivo tauraa ari Koonnara yaaku varoo tunoo: Ni Napoo-o, a mmuakiaa ngiaammuaudaa ni miannaiyakidiri hama voovai raubiriinoo. Ivo itaa kua tuuvaara kaanaivo vauduu Yisuuva rapira vaidiiya tunoo: Ni ngiaammuaudaa pikikiai kuatee, ");
INSERT INTO waj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","tuduu rikioo ari ngiaammuau voovai nnutuuvo Simoono Petorooso ari paipa avaikaraivaa nnaamuruuvakidiri utu rada kioo Anutuuqaara kati puara hudeera vaidi kieetaivaa mmoori vareera ngiaammuau voovai yaata yaadudainniivaa rutaka kieeravai. Ii ngiaammuau ivaa nnutuuvo Marakuusovee. ");
INSERT INTO waj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yisuuva Petoroosaa tunoo: Ai paipaivaa kava ari nnaamuruuvaki uyuanee. Aa na tinara kua aavaara a dataamainna yaata utuannannee? Mmuaararaivaa roosii nnoori toori kapikaroovaa ni Napoova ni muuvaa na nnaanarannee? Vara hama na nnaanarannee? Fai na nnaanaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tuduu rikiada kaayau rapira vaidiiyaatama ngiari kieetaivoota Yutayaiya nuunaira nnau pinaivaara haitatuura vaidiiyaatama Yisuunna puaisa utu kiada vaida yeenaivaadiri inna yaakuuvaitanau rau kiada ");
INSERT INTO waj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","vitada Anutuuqaara kati puara hudeera vaidiivaa nnutuuvo Anaasaasi tauraa viravai. Vaidi voovai nnutuuvo Kayapaanna nniraangioo inna Anaasovee. Ii suai ivaki Kayapaava Anutuuqaara kati puara hudeera vaidiiya kieeta tuanaavai variravai. ");
INSERT INTO waj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Vaa ivo tauraa ari yaata tinniyaa vau kuaivaa vaidi Yutayaiya kiaa mmioo tunoo: Fai mmuaa vaidivai mmuakiaa Yutayaa gioonna kiaapuuya tiiyara putinaraivo inna yoketaavaivee. Ivo vaa tauraa ii kua ivaa itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Vaidiiya Yisuunna vitada vuduu Simoono Petoroosoota na Yisuunna ngiaammuauvo neetama inna nnaagiai tadadama rada viravai. Vuduu Anutuuqaara kati puara hudeera vaidi kieetaivo arinaima vaa ni teeravai. Vaa ivo arinaima ni toovaara neetama Yisuunna tasipama vaidi kieetaivaa nnauvaa vagiaamunna aakiaivaki viravai. ");
INSERT INTO waj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Vuduu rikioo Petorooso mmaanai nnau vagiaamunna keegianniivau duoo vauduu neenoo kieeta vaidiivo vaa arinaima ni toovoono kava vara ranee tuma keegiaivaara duu kiaatannaivaata kua tiee Petoroosaa vitee nnau vagiaamunna aakiaivaki viravai. ");
INSERT INTO waj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Vuduu too kiaatannaivo keegiaivaara duuvo Petoroosaa tunoo: A iqii vaidi ivaa ngiaammuau voovainna iikiannannee? tuduu rikioo Petorooso inna sai tunoo: Ai, hama na inna ngiaammuauvaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ii suai ivaki mmoori vareera ngiaammuauyaata rapira vaidiiyaatama iya ririkia utuduu rikiada ikiaivaa hara kiada ututuuma dida vaida totookairavai. Iya totookaida varuduu Petorooso oro iya tasipama dioo vainno ivaata totookairavai. ");
INSERT INTO waj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Anutuuqaara kati puara hudeera vaidi kieeta tuanaivo Yisuunna ari ngiaammuauyaraata ari kua mmayaayaivaaraatama yaparairavai. ");
INSERT INTO waj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yaparauduu rikioo Yisuuva inna sai tunoo: Na mmuakiaa suai mmuakiaa gioonna kiaapuuya avuuyauvunu variee nini kuaivaa iya kiaa mmiauvai. Gioonna kiaapu Yutayaiya nuunaira nnau kiisaiyauvakiaata nnoonnaivakiaatama na ni kua mmayaaya mmuakiaavai iya kooyaa kiaa mmiauvai. Hama na vo kua voovai hataumakinaa iya kiaa mmiauvai. ");
INSERT INTO waj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mo na itaa kiaukainna a aaniira ni yaparakiannannee? Gioonna kiaapuuya ni kuaivaa rikiaiya yaparakianee. Vaa iya ni kuaivaa rikiaavai. Na iya kiaa mmiaa kuaivaara iya yaparakianee, ");
INSERT INTO waj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","tuduu rikioo nuunaira nnau pinaivaara dira vaidi voovoono inna kueennaivaa rudaunno inna tunoo: A vaidi kieetakuaanoonna Anutuuqaara kati puara hudeera kieetaivaa itaa kua kiannannee? ");
INSERT INTO waj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","tuduu rikioo Yisuuva inna sai tunoo: Mo ngia dataamaida yaata utuaannee? Na koonnama kiaunnee? Vara na kutaa kuavai kiaunnee? Na kuaivaa kutaa koonnama kiau kuaivaa aa gioonna kiaapu aavaki variaa aaya kiaa kookieenai iyaatama rikiaatee. Na safuuma kutaa kuaivaa kiaukai mo aaniira kuminayaa ni ruputuannannee? tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yisuunna yaakuuvaitanau yeenaivo vauduaata kuaivaa kiaa taika kiooduu Anaaso inna titooduu Anutuuqaara kati puara hudeera vaidi kieetaivaa Kayapaannasi viravai. ");
INSERT INTO waj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Vuduu Simoono Petorooso homo dioo vainno ikiaivaara totookainno varuduu vaidi vooya ivaki varuuya inna tunoo: A inna ngiaammuau voovainna iikiannannee? tuduu rikioo Petorooso ooqoo tioo tunoo: Hama na inna ngiaammuauvaivee, ");
INSERT INTO waj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","tuduu rikioo vaidi kieetaivaa ngiaammuau voovoono Petorooso vaa inna seena tuanaivaa yaataivaa rutakoovoono tunoo: Vaa na i tauvaivee. A inna tasipama yatari oriipa mmooriivaki hara kiee variannavaivee, ");
INSERT INTO waj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","tuduu rikioo Petorooso kava ooqoo tuoo tunoo: Hameetavee, tuduu rikioo tuu saivaata kakaraivo akua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Heenanaanna suaivo reera kiooduu Yutayaa vaidiiya Yisuunna Kayapaanna nnauvakidiri vitada vidada vaidi Roomaiya kieetaivaa nnauvaki oro kiooduu ivo ivaki varuduu iya mmaanaivau diravai. Yutayaiyaano ngiari buusa Varaigiataivaa iya nnaataikiai iya ngiari voopinnaiya nnau aakiaivaki vida ngiari mmaanna aataruuvaa hatokeevoora kiaa kiada oro mmaanaivau diravai. ");
INSERT INTO waj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Iya hama nnauvaki vuduu too Piratuuso mmaanai tuoo iya yaparainno tunoo: Mo ngia dee tomedavaaraida kua pinaivaa aqaa vaidi aavaaki yapaannee? ");
INSERT INTO waj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","tuduu rikiada iya inna sai tunoo: Ivo hama maisai aataruuvaa iitiri. Hama ta aisi vitada ngiaunnatirivee, ");
INSERT INTO waj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","tuduu rikioo Piratuuso iya tunoo: Ngiengieenoo ngiingii kua mmaanna tuu aataruuvaara inna vitada kua pinaivaki inna yapa kiada inna yaparakiatee, tuduu rikiada vaidi Yutayaiya inna sai tunoo: Ta Yutayaiya gioonna kiaapuuya ruputikiai putuaaraivaara ngia Roomaiya ti ooqoo kiaavaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Vaa tauraa Yisuuva iya inna yatari sagaivau haara kikio iva putinara aataruuvaa kooyaa iya kiaa mmiravai. Kooyaa iya kiaa mmuu kuaivaa kaanaivo vakiaiveeraivaara vaidi Yutayaiya itaa kua tiravai. ");
INSERT INTO waj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Piratuuso kava vara ranoo ari nnauvaki vioo Yisuunna yaparainno tunoo: A Yutayaiya kieetakuannee? ");
INSERT INTO waj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","tuduu rikioo Yisuuva inna sai tunoo: Vara eenoonna aa kua aavaa ni yaparakiannannee? Vara ari vo vaidiyaano niiyara i kiaa i mmiaaniinna a ni yaparakiannannee? ");
INSERT INTO waj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","tuduu rikioo Piratuuso inna sai tunoo: Hama na Yutayaa vaidivai. Sa niiyara kianee: Eenoo niiki kuaivaa yapaannanoo, kianee. Ai seena mmuaa yoosinnaiyaata Anutuuqaara kati puara hudeera kieetaiyaatama i vitada niisi ngiaavai. E aanii tomeda aataruvai iikiannani iya i vitada niisi ngiaannee? ");
INSERT INTO waj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","tuduu rikioo Yisuuva inna sai tunoo: Na gioonna kiaapuuyara diee iya kiaukai iya sai niiyara yoketaa kiaa aataruuvo hama mmata aavau vaivai. Mmata aavau vaitiri. Ni nnaagiai nuairaiya niiyara rapida vaidi voovoono vaidi Yutayaiya ni iya mminaraivaara ooqoo kiaatirivee. Mo na gioonna kiaapuuyara dira aataruuvo hama mmata aavau vaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","tuduu rikioo Piratuuso inna sai yaparainno tunoo: Mo a gioonna kiaapuuyara diraikuannee? tuduu rikioo Yisuuva inna sai tunoo: Yo, a niiyara itaa kua kianna kuaivo kutaavaivee. Na gioonna kiaapuuya kua kutaivaa kiaa mminara na mmatayaa tummuaaduu ni noova ni mmata kieeravai. Gioonna kiaapu voovoono kua kutaivaa rikiaivoono ni kuaivaata rikiaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","tuduu rikioo Piratuuso inna sai yaparainno tunoo: Kua kutaivo inna dee kuavainnee? tiravai. (Matai 27:15-31; Marakaa 15:6-20; Rukaaso 23:13-25) Piratuuso itaa kua kiaa kioo kava vara ranoo mmaanai vioo vaidi Yutayaiya tunoo: Na tauko hama ivo aannoo vaidivai varinoo. ");
INSERT INTO waj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngiengie iira aataruuvo vainoo. Mmuakiaa nuanuuyauvaki ngia buusa Varaigiataivaa nneera suaivaki oovi nnauvaki varii vaidi voovaara ngia yaparakiaivaara na sipuuvaa hatuaa kino tuoo ngiiisi kuanaravai. Ngia gioonna kiaapu Yutayaiya ngiiiyara dira vaidi kieetaivaa na innani sipuuvaa hatuaa kino tuoo ngiiisi kuanarannee? ");
INSERT INTO waj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","tuduu rikiada iya puaisakama aayanna reeda tunoo: Hamavee. Sa inna titano kuaivee. Paravaasaa titano tuoo kuaivee, tiravai. Paravaaso inna kua yaatareera mmuara furai vaidivai variravai. ");
INSERT INTO waj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Itaama vauduu too Piratuuso Yisuunna vitoo ari ngiaammuauya mmuduu utida inna ripiiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ripuuduu rapira vaidi vooyaano yeena ooviiyauvaa varada hovekama kiada inna kieetaivau ruvuyu kiada yaapa kookeevaa varada innayaa apu kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Innayaa apu kiada innasi vida rakuana nnida rakuanaida varida inna tunoo: Gioonna kiaapu Yutayaiya kieetakuavee. Tupatupaa varianee. Iya itaa kua kiaa kiada inna kueennaivaa rudauravai. ");
INSERT INTO waj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Rudauma kiooduu Piratuuso kava mmaanai vioo gioonna kiaapu kaayau nuunauya tunoo: Rikiaatee. Aa vaidi aavo na tauko hama vaidi aannoo vaidivai varinoo. Na itaama tee rikiauvaara ngieetama teeda rikiaateera na inna vitee aapi ngiiisi ngiaunoo. ");
INSERT INTO waj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ivo itaa kua kiaa taika kiooduu Yisuuva mmaanai tuuduu yeena ooviivaa hovekama kiada inna kieetaivau yapa kioovo vauduu yaapa kookee kuauvaa innayaa apu kioovo vairavai. Vauduu too Piratuuso iya tunoo: Taatee. Aa ii vaidiivovee, ");
INSERT INTO waj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","tuduu rikiada vaidi Anutuuqaara kati puara hudeera kieetaiyaata nuunaira nnauvaara dira vaidiiyaatama Yisuunna teeda vaida puaisakama aayanna reeda varida tunoo: A tinai iya yatari sagaivau inna haara kiaatee, tuduu rikioo Piratuuso iya sai tunoo: Ngia itaa kua tida ngiengieenoo ivaa vitada yatari sagaivau haara kiaatee. Na tauko hama ivo vaidi aannoo vaidivai varinoo. Mo dataama na irisai maisaivaa inna mminaravainnee? ");
INSERT INTO waj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","tuduu rikiada iya inna sai tunoo: Ivo ariiyara na Anutuuqaa mmaapuvaivee tuuvaara ti mmaanna tuu kua voovai hatokeeravai. Hatokoovaara kii inna aikiooma ivo putuaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tuduu Piratuuso ii kua ivaa rikioo kaayauma aatuunno ");
INSERT INTO waj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kava Yisuunna vitoo ari nnauvaki vioo vaidiiyaki kua pinaa yapeera nnauvaki vioo Yisuunna yaparainno tunoo: A deepinnaakuainna ngiannannee? tuduu rikioo Yisuuva hama inna kua sai tiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hama inna kua sai tuduu rikioo Piratuuso inna tunoo: Aaniira hama a ni kua sai kiannannee? Na vaidi nnoonnavai. Neenoo tinai fai a mmaanai kuanaravai. Neenoo tinai fai vaidiiya yatari sagaivau i haara kiaaravai. Hama a ivaa tuqinnama rikiaannannee? ");
INSERT INTO waj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","tuduu rikioo Yisuuva inna kua sai tunoo: Ngiau aapu variivoono hama kieetavai i yapaitiri. Hama a niiyara itaa kua kiannatirivee. Itaama vaikio vaidi voovoono ni vitoo aisi nniivo mminnamminnaa maisaivaa varaivai. Tauraa ni vitoo aisi nnii vaidiivaa mminnamminnaa maisaivoono i mminnamminnaa maisaivaa yaatarakiaivaivee, ");
INSERT INTO waj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","tuduu rikioo Piratuuso dee aataruvai Yisuunna mmino ivo kati mmaanai kuanaraivaara yaata utuoo iinno varuduu vaidi Yutayaiya puaisakama aayanna reeda tunoo: Fai a tino aa vaidi aavo mmaanai tiinai a hama ti kieeta yoosinna Rooma variivaa seena tuanaakuavee. Vaidi voovoono ariiyara tinara: Na kieetavaivee, kiaa variivoono ti kieeta Rooma variivaa nnammutuaavaivee, ");
INSERT INTO waj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","tuduu rikioo Piratuuso ii kua ivaara yaata utuoo rikioo Yisuunna nnauvakidiri vitoo numa mmaanai sikau terenaivau inna yapa kioo oro kua radudeera mmaataivau hara kioo variravai. Ii sikau terena ivaa Eporai kuaivakidiri tuu nnutuuvo Kapataa tiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ii suai ivaki iya buusa Varaigiataivaa turau nnaaraivaara teeraida varuduu ikianna tammauduu Piratuuso vaidi Yutayaiya tunoo: Aanna ngii kieetavaivee, ");
INSERT INTO waj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","tuduu rikiada iya puaisakama aayanna reeda tunoo: Inna vitee ruputino putuaivee. A tinai iya yatari sagaivau inna haara kiaatee, tuduu rikioo Piratuuso iya yaparainno tunoo: Ngii kieetavaivee. Fai na tinai iya yatari sagaivau inna haara kiaarannee? tuduu rikiada Anutuuqaara kati puara hudeera vaidi kieetaiyaano inna sai tunoo: Hama ti kieeta voovootaivaivee. Ti kieeta mmuaavai yoosinna Rooma hara kioo varinoo, ");
INSERT INTO waj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","tuduu rikioo inna aikioo Piratuuso Yisuunna iya mmiravai. Iya inna vitada yatari sagaivau haara kiaaraivaara iya mmiravai. (Matai 27:32-44; Marakaa 15:21-32; Rukaaso 23:26-43) Iya tuduu rapira vaidiiya Yisuunna vitada viravai. ");
INSERT INTO waj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Vuduu Yisuuva ariinoo ari yatari sagaivaa apu varoo ivaki pikioo yoosinna voovai nnutuuvo Kieeta Mmuyai ivaki vau yoosinnaivakira viravai. Ii nnutu ivaa Eporai kuaivakidiri kiaa nnutuuvo Korokataa. ");
INSERT INTO waj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yisuuva ivaki vuduu vaidi rapiraiya inna vitada yatari sagaivau haara kieeravai. Haara kiada vaidi taaravaitanaatama yatari sagaivaitanau haara kiada vuaivaa vitada inna yaaku yaadudainningiaa haara kiada vuaivaa vitada inna yaaku geedainningiaa haara kiooduu Yisuuva ivaitana tammaivaki diravai. ");
INSERT INTO waj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Duoo vauduu yanaivaa Piratuuso fafaara roovaa iya varada Yisuunna yatari saga mmutuuvau haara kieeravai. Ii yanaa ivo tunoo: Aanna Nasareetaa vaidi Yisuuvavee. Ivo Yutayaiya kieetavaivee. ");
INSERT INTO waj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Fafaaraivo itaa kua tuduu Yisuunna yatari sagaivau haara kioo yoosinnaivo Yerusareema vainima vauvaara kaayau gioonna kiaapu Yutayaiya vida nnidaida varida ii yanaa ivaa yaariravai. Piratuuso taaravooma kuaivakidiri yanaivau reeravai. Eporai kuaivakidiriaatama Roomaiya kuaivakidiriaata Ereengaiya kuaivakidiriaatama reeravai. ");
INSERT INTO waj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ivo roo suaivaki Anutuuqaara kati puara hudeera kieetaiyaano Piratuusaa tunoo: Sa fafaara ree kianee: Aanna Yutayaiya kieetavaivee, kianee. Fafaara ree kianee: Aa vaidi aavo ariiyara tinoo: Na Yutayaiya kieetavaivee, tiivaivee, kianee. ");
INSERT INTO waj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Iya itaa kua tuduu Piratuuso iya kua sai tunoo: Na fafaara rau kuaivo inna aikioo kuavai na rauvaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Piratuuso itaa kua tuduu rapira vaidiiya vaa Yisuunna yatari sagaivau haara kiaiya inna uyira rairaiyauvaa varada ivaadiri taarama taarama mmuruooda yapa kiada iya mmuaavai mmuaavai duuyama vareeravai. Vara kiada inna yaapa varaayaa diaivo hama raubaatama funniraivootauvaa mmuaavai vauvaara tida varada ");
INSERT INTO waj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ngiari kiaa mmi ngiari kiaa mmiida tunoo: Kii fai ta hama aavaa rapasiaaravaivee. Ivau kii ta peperoovaa roosiivaa kagaari kagaariida teekio voovoono yaataraivoono ivaa varaivee, tiravai. Nnaaruaa vaidiivo Anutuuqaa yanaivau kua fafaara roovo tuuvaugiataa iya itaama uuvaara kaanaivo vairavai. Ii kua ivo tunoo: Iya ni uyira rairaiyauvaa mmuaavai mmuaavai duuyama varada ni yaapa varaayaa diaivaara peperoovaa kagaari kagaariida taavo voovoono yaataraivoono ivaa varaivaivee. Fafaaraivo itaa kua tuuvaa kaanaivaa rapira vaidiiya itaama iiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yisuunna yatari sagaivaa vainiivau gioonnaiya dida vaida Yisuunna kaanootama Yisuunna kaanaa nnunnaivo Koropaanna nnaataivo Mariaavaatama Makataraa gioonnaivo Mariaavaatama dida vairavai. ");
INSERT INTO waj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dida vauduu too Yisuuva tooduu ari kaano dioo vauduu na inna ngiaammuau ivo niiyara mmuduuya riraivootama diee vakiaaduu too ari kaanaa tunoo: Gioonna-o, aa suai aavakidiri aa ngiaammuau aavo i mmaapuvai varinaravaivee, ");
INSERT INTO waj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","kiaa kioo ni tunoo: Aa suai aavakidiri aa gioonna aavo i kaano varinaravaivee, tuduu rikiee na ii suai ivakidiri inna kaanaa vitee nini nnauki yapeeravai. ");
INSERT INTO waj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yisuuva itaa kua kiaa kioo rikiooduu ari mmoori mmuakiaayauvai taika kiooduu rikioo ivo tunoo: Ni nnoori rainoo, tiravai. Nnaaru Anutuuqaa kua fafaara roo kuaivaudiri kaanaivo itaama vairavai. ");
INSERT INTO waj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yisuuva itaa kua tuduu yavaivaki nnoori kapikaroo ari vookarauvaa nnutuuvo vinikaivo ivaki vauduu vaidiiya kapuka roosuu mminnaivaa nnooriivakidiri rabuuma kiada yatari seera hokobaivaa nnutuuvo hisoopaivau kuru kiada rooru utida Yisuunna kuasiivau yapa kiooduu ");
INSERT INTO waj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yisuuva nnoo tunoo: Vaa ni mmooriivo taikainoo, kiaa kioo vaaveevo tagiruduu putiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Putuduu Yutayaa vaidiiya kati varira suaivo vainima vauvaara ngiari mminnamminnaiyauvaa teerairavai. Turau ngiari kati varira suai yoketaa ari vookaraivo vainaraivaara iya yaata utida ngiari mminnamminnaiyauvaa teerairavai. Ngiari kati varira suaivaki vaidi putuaiya mmammaiyauvo yatari sagaiyauvunu sa vakiaiveera iya yaata utida numa Roomaa kieetaivaa Piratuusaa yaparaida tunoo: A ee-oo tinai i ngiaammuauya vaidi yatari sagaiyauvunu haara kiaiya yukuuyauvaa ruaimi kiada yatari sagaiyauvunudiri hituaaravainnee? ");
INSERT INTO waj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","tuduu kieetaivo ee-oo tuduu ari rapira vaidiiya oro teeda vuai vaidiivaa Yisuunna tasipama yatari sagaivau hiri kioovaa yukuuvaitana ruaimi kiada vida vuaivaa yukuuvaitanaatama ruaimi kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ruaimi kiada nnida Yisuunna tooduu vaa putuduu hama inna yukuuvaitana ruaimirama kiada ");
INSERT INTO waj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","rapira vaidi voovoono ari mmataivaata Yisuunna yaaneevaki hara rada kiooduu akiairaama kiauvoota nnooriivootama innakidiri tiiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tuuduu neenoo ivaa taivoono ivaara vaa na tiravai. Vaa na rikiaunoo. Na kiaa kuaivo kutaa kuavai. Ngieetama Yisuunnara kutaavaivee kiateeraivaara na kiaa kuaivaa neneeta rikiauko kutaa kuavai vainoo. ");
INSERT INTO waj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nnaaru Anutuuqaa yanaivaki kua fafaaraivo vainno tuu kuaivaa kaanaivo vauvaudiri Yisuunnara iya itaama iiravai. Ivaara Anutuuqaa kua fafaaraivo vainno tunoo: Hama inna mmuyai voovai ruaimiaaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Anutuuqaa kua fafaara voovai vainno tunoo: Iya mmataivaata haara kiaa vaidiivaa gioonna kiaapuuya taaravaivee, tiravai. ");
INSERT INTO waj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nnaagiai yoosinnaivaa nnutuuvo Arimateyaa diaa vaidiivaa nnutuuvo Yoosiipo numa Yisuunna nnabaivaa varoo kuanaraivaara Piratuusaa yaparairavai. Yoosiipo Yisuunna nnaagiai nuaira vaidivai. Yutayaa vaidiiyara aatuunno haumaki ivo Yisuunna nnaagiai nuairavai. Ivo Piratuusaa yaparauduu rikioo ee-oo tuduu Yisuunna nnabaivaa oro varoo viravai. ");
INSERT INTO waj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Vaa heenaki Yisuunnasi vuu vaidiivo Nikotimaaso suuda yoketaa vuu suuyaivaa varoo ngioo Yoosiipaa sunoo viravai. Ivo yatari rana suuda yoketaa vuuvaa nnutuuvo aroosaivaatama kupuuvaa roosuuvaa nnutuuvo miiraivaatama hanigiaanigieema mmuaavaki kioo kaayau mmuaararoovaa varoo viravai. ");
INSERT INTO waj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ii vaidi ivaitana Yisuunna nnabaivaa varada suuda yoketaa vuu suuyaivaa buruqa poosa rapasi kioovau siikama kiada inna nnabaivaa purupuruuma kieeravai. Yutayaa vaidiiya vaidi putiraiya nnabaiyauvaa teerairayaama ivaitana Yisuunna nnabaivaa itaama teerama kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yisuuva putuu mmataivau kati yatari hau utira mmatavai vairavai. Vauvaki karaasa mmata nnauvaa sikauvaki hatata kioovaki hama vaidi nnaba voovai ivaki yapoovo ivaki vairavai. ");
INSERT INTO waj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Vauduu rikiada ngiari kati varira suaivo vainima vauvaara yaata utida ngiari mminnamminnaiyauvaa safuuma teerakiaaraivaara mmata nnau hama vaidi hauvo vainima vau ivaki Yisuunna nnabaivaa varada ivaki hau kieeravai. ");
INSERT INTO waj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sudaaqaki heenanaanna hama ruvuaayeerainno homo upisiinno vauduu Makataraa diaa gioonnaivaa nnutuuvo Mariaava Yisuunna mmata nnauvakira kuanaree kiaa oro tooduu vaa mmata nnau keegiaivaki vau sikau pinaivaa ivakidiri feena kiooduu too ");
INSERT INTO waj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ivo seenoo vioo Simoono Petoroosaata Yisuuva niiyara pinaama mmuduuya rira ngiaammuauvaa niitama kiaa mmioo tunoo: Vaa iya ti Udaangaivaa nnabaivaa mmata nnauvakidiri varada iya yapa kiaipinnainni hama ta taunnanoo, ");
INSERT INTO waj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","tuduu rikiada Petoroosoota neetama ivau pikiada mmata nnauvakira viravai. ");
INSERT INTO waj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Seenada vida na Petoroosaa yaatara kiee neenanaa mmata nnauvaa taanaree kiaa ");
INSERT INTO waj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","viee viee oro kookama reeti taaduu buruqa poosaiyauvo vauduu tee hama ivaki virama kiaaduu ");
INSERT INTO waj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoono Petorooso ni nnaagiaidiri vioo ni yaatara kioo ivaki viravai. ");
INSERT INTO waj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Vioo tooduu buruqa poosa purupuruuma kiooyauvoota Yisuunna kieetaivau rau kioo buruqaivootama ivaki vairavai. Hama Yisuunna kieetaivau rau buruqaivo purupuruuma kioo buruqaiyauvaa tasipama vairama kioo ari voovau rapugiaa yoketaama kioo vairavai. ");
INSERT INTO waj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Vauduu tee na vaa tauraa mmata nnauvaa taivo neetama aakiaivaki oro tee kutaavaivee tiravai. ");
INSERT INTO waj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yisuuva putuuvakidiri kava diitaanara kuaivaa nnaaru Anutuuqaa yanaivaki roo kua fafaaraivo tuuvaa ta homo ivaara kumimakama iikiaunnavai. ");
INSERT INTO waj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ta ivaa teeda pikiada kava vara ranada titi nnaukira nniravai. ");
INSERT INTO waj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ta ngiaannaduu Mariaava mmata nnau mmaanaivau dioo vainno rateeravai. Ratoo varioo kookama kioo aakiaivaki taanee kiaa tooduu ");
INSERT INTO waj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12