﻿USE sofia;
DROP TABLE IF EXISTS sofia.vieovcb_vpl;
CREATE TABLE vieovcb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES vieovcb_vpl WRITE;
INSERT INTO vieovcb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ban đầu, Đức Chúa Trời sáng tạo trời đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Lúc ấy, đất chỉ là một khối hỗn độn, không có hình dạng rõ rệt. Bóng tối che mặt vực, và Linh Đức Chúa Trời vận hành trên mặt nước. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Đức Chúa Trời phán: “Phải có ánh sáng.” Ánh sáng liền xuất hiện. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Đức Chúa Trời thấy ánh sáng tốt đẹp nên Ngài phân biệt sáng với tối. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Đức Chúa Trời gọi sáng là “ngày,” tối là “đêm.” Đó là buổi tối và buổi sáng ngày thứ nhất. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Đức Chúa Trời lại phán: “Phải có khoảng không để phân cách nước với nước.” ");
INSERT INTO vieovcb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Vì thế, Đức Chúa Trời tạo ra khoảng không để phân cách nước dưới khoảng không và nước trên khoảng không. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Đức Chúa Trời gọi khoảng không là “trời.” Đó là buổi tối và buổi sáng ngày thứ hai. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kế đến, Đức Chúa Trời phán: “Nước dưới trời phải tụ lại, và đất khô phải xuất hiện.” Liền có như thế. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Đức Chúa Trời gọi chỗ khô là “đất” và chỗ nước tụ lại là “biển.” Đức Chúa Trời thấy điều đó là tốt đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Đức Chúa Trời phán: “Đất phải sinh thảo mộc—cỏ kết hạt tùy theo loại, và cây kết quả có hạt tùy theo loại.” Liền có như thế. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Đất sinh sản thảo mộc—cỏ kết hạt tùy theo loại, và cây kết quả có hạt tùy theo loại. Đức Chúa Trời thấy vậy là tốt đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Đó là buổi tối và buổi sáng ngày thứ ba. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Tiếp theo, Đức Chúa Trời phán: “Phải có các thiên thể để soi sáng mặt đất, phân biệt ngày đêm, chỉ định thời tiết, ngày, và năm. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Hãy có những vì sáng trên bầu trời để soi sáng mặt đất.” Liền có như thế. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Đức Chúa Trời làm ra hai thiên thể. Thiên thể lớn hơn trị vì ban ngày; thiên thể nhỏ hơn cai quản ban đêm. Ngài cũng tạo nên các tinh tú. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Đức Chúa Trời đặt các thiên thể để soi sáng mặt đất, ");
INSERT INTO vieovcb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","cai quản ngày đêm, phân biệt sáng và tối. Đức Chúa Trời thấy điều đó là tốt đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Đó là buổi tối và buổi sáng ngày thứ tư. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Đức Chúa Trời phán tiếp rằng: “Nước phải có thật nhiều cá và sinh vật. Trên mặt đất dưới vòm trời phải có chim bay lượn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Đức Chúa Trời tạo ra các giống cá lớn dưới biển, các loài cá khác tùy theo loại, và các loài chim tùy theo loại. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Đức Chúa Trời thấy điều đó là tốt đẹp. Ngài ban phước lành cho chúng và phán: “Hãy sinh sản và tăng thêm cho đầy dẫy biển. Các loài chim hãy tăng thêm nhiều trên đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Đó là buổi tối và buổi sáng ngày thứ năm. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Đức Chúa Trời lại phán: “Đất phải có các sinh vật tùy theo loại—gia súc, loài bò sát, và thú rừng mỗi loài tùy theo loại.” Liền có như thế. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Đức Chúa Trời tạo ra các loài dã thú tùy theo loại, các loài súc vật tùy theo loại, và các loài bò sát tùy theo loại. Đức Chúa Trời thấy vậy là tốt đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Đức Chúa Trời phán: “Chúng ta hãy tạo nên loài người theo hình ảnh chúng ta, giống như chúng ta, để quản trị các loài cá dưới biển, loài chim trên trời, cùng các loài súc vật, loài dã thú, và các loài bò sát trên mặt đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Vì thế, Đức Chúa Trời sáng tạo loài người theo hình ảnh Ngài. Dựa theo hình ảnh Đức Chúa Trời, Ngài tạo nên loài người. Ngài sáng tạo người nam và người nữ. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Đức Chúa Trời ban phước cho loài người và phán cùng họ rằng: “Hãy sinh sản và gia tăng cho đầy dẫy đất. Hãy chinh phục đất đai. Hãy quản trị các loài cá dưới biển, loài chim trên trời, và loài thú trên mặt đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Đức Chúa Trời phán: “Này, Ta cho các con mọi loài cỏ kết hạt trên mặt đất và mọi loài cây kết quả có hạt để dùng làm lương thực. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ta cũng ban cỏ xanh làm lương thực cho các loài thú dưới đất và loài chim trên trời.” Liền có như vậy. ");
INSERT INTO vieovcb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Đức Chúa Trời thấy mọi loài Ngài đã sáng tạo, tất cả đều tốt đẹp. Đó là buổi tối và buổi sáng ngày thứ sáu. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Như thế, trời đất và vạn vật đều được sáng tạo xong. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Đến ngày thứ bảy, công trình hoàn tất, Đức Chúa Trời nghỉ mọi việc. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Đức Chúa Trời ban phước lành và thánh hóa ngày thứ bảy, vì là ngày Ngài nghỉ mọi công việc sáng tạo. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Đó là gốc tích việc Đức Chúa Trời Hằng Hữu sáng tạo trời đất. Khi Đức Chúa Trời Hằng Hữu mới sáng tạo trời đất, ");
INSERT INTO vieovcb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","chưa có bụi cây nào trên mặt đất, cũng chưa có ngọn cỏ nào mọc ngoài đồng, và Đức Chúa Trời Hằng Hữu chưa cho mưa xuống đất, cũng chưa có ai trồng cây ngoài đồng. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tuy nhiên, hơi ẩm từ đất bay lên ngấm khắp mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Đức Chúa Trời Hằng Hữu lấy bụi đất tạo nên người và hà sinh khí vào mũi, và người có sự sống. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Đức Chúa Trời Hằng Hữu lập một khu vườn tại Ê-đen, về hướng đông, và đưa người Ngài vừa tạo nên đến ở. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Trong vườn, Đức Chúa Trời Hằng Hữu trồng các loại cây đẹp đẽ, sinh quả ngon ngọt. Chính giữa vườn có cây sự sống và cây phân biệt thiện ác. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Một con sông phát nguyên từ Ê-đen tưới khắp vườn; từ đó, sông chia ra bốn nhánh. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nhánh thứ nhất là Bi-sôn, chảy quanh xứ Ha-vi-la. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nơi ấy có vàng tinh khiết; nhũ hương và bích ngọc. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nhánh thứ nhì là Ghi-hôn, chảy vòng xứ Cút. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nhánh thứ ba là Ti-gơ, chảy sang phía đông xứ A-sy-ri. Nhánh thứ tư là Ơ-phơ-rát. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Đức Chúa Trời Hằng Hữu đưa người vào vườn Ê-đen để trồng trọt và chăm sóc vườn. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Đức Chúa Trời Hằng Hữu truyền nghiêm lệnh: “Con được tự do ăn mọi thứ cây trái trong vườn, ");
INSERT INTO vieovcb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","trừ trái của cây phân biệt thiện ác. Một khi con ăn, chắc chắn con sẽ chết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Đức Chúa Trời Hằng Hữu phán: “Người sống đơn độc không tốt. Ta sẽ tạo nên một người giúp đỡ thích hợp cho nó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Đức Chúa Trời Hằng Hữu lấy đất tạo nên các loài thú rừng, loài chim trời, và Ngài đem đến cho A-đam để xem người đặt tên thế nào. Tên A-đam đặt cho mỗi sinh vật đều thành tên riêng cho nó. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Vậy, A-đam đặt tên cho tất cả loài gia súc, loài chim trời, và loài thú rừng, nhưng A-đam chẳng tìm thấy người giúp đỡ thích hợp cho mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Đức Chúa Trời Hằng Hữu làm cho A-đam ngủ mê, lấy một xương sườn rồi lấp thịt lại. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Đức Chúa Trời Hằng Hữu dùng xương sườn đó tạo nên một người nữ và đưa đến cho A-đam. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","A-đam nói: “Đây là xương của xương tôi, thịt của thịt tôi, nên được gọi là ‘người nữ’ vì từ người nam mà ra.” ");
INSERT INTO vieovcb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Vì thế, người nam sẽ rời cha mẹ để gắn bó với vợ, hai người trở thành một. ");
INSERT INTO vieovcb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","A-đam và vợ đều trần truồng, nhưng không hổ thẹn. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Trong các loài động vật Đức Chúa Trời Hằng Hữu tạo nên, rắn là loài xảo quyệt hơn cả. Rắn nói với người nữ: “Có thật Đức Chúa Trời cấm anh chị ăn bất cứ trái cây nào trong vườn không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Người nữ đáp: “Chúng tôi được ăn các thứ trái cây trong vườn chứ. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Chỉ mỗi một cây trồng giữa vườn là không được ăn. Đức Chúa Trời phán dặn: ‘Các con không được chạm đến cây ấy; nếu trái lệnh, các con sẽ chết.’” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Con rắn nói với người nữ: “Chắc chắn không chết đâu! ");
INSERT INTO vieovcb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Đức Chúa Trời biết rõ rằng khi nào ăn, mắt anh chị sẽ mở ra. Anh chị sẽ giống như Đức Chúa Trời, biết phân biệt thiện ác.” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Người nữ nhìn trái cây ấy, thấy vừa ngon, vừa đẹp, lại quý, vì mở mang trí khôn. Bà liền hái và ăn. Rồi bà trao cho chồng đứng cạnh mình, chồng cũng ăn nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Lúc ấy, mắt hai người mở ra, họ biết mình trần truồng và liền kết lá vả che thân. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Đến chiều, nghe tiếng Đức Chúa Trời Hằng Hữu đi qua vườn, A-đam và vợ liền ẩn nấp giữa lùm cây trong vườn. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Đức Chúa Trời Hằng Hữu gọi: “A-đam, con ở đâu?” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A-đam thưa: “Con nghe tiếng Chúa trong vườn, nhưng con sợ, vì con trần truồng nên đi trốn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Đức Chúa Trời Hằng Hữu hỏi: “Ai nói cho con biết con trần truồng? Con đã ăn trái cây Ta cấm phải không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","A-đam nói: “Người nữ Chúa đặt bên con đã đưa trái cây ấy cho con, và con đã ăn rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Đức Chúa Trời Hằng Hữu hỏi người nữ: “Sao con làm như vậy?” “Rắn lừa gạt con, nên con mới ăn,” người nữ đáp. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Đức Chúa Trời Hằng Hữu quở rắn: “Vì mày đã làm điều ấy, nên trong tất cả các loài gia súc và thú rừng, chỉ có mày bị nguyền rủa. Mày sẽ bò bằng bụng, và ăn bụi đất trọn đời. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ta sẽ đặt hận thù giữa mày và người nữ, giữa hậu tự mày và hậu tự người nữ. Người sẽ chà đạp đầu mày; còn mày sẽ cắn gót chân người.” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ngài phán cùng người nữ: “Ta sẽ tăng thêm khốn khổ khi con thai nghén, và con sẽ đau đớn khi sinh nở. Dục vọng con sẽ hướng về chồng, và chồng sẽ quản trị con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ngài phán với A-đam: “Vì con nghe lời vợ và ăn trái cây Ta đã ngăn cấm, nên đất bị nguyền rủa. Trọn đời con phải làm lụng vất vả mới có miếng ăn. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Đất sẽ mọc gai góc và gai độc; con sẽ ăn rau cỏ ngoài đồng. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Con phải đổi mồ hôi lấy miếng ăn, cho đến ngày con trở về đất, mà con đã được tạc nơi đó. Vì con là bụi đất, nên con sẽ trở về bụi đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","A-đam gọi vợ là Ê-va, vì là mẹ của cả loài người. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Đức Chúa Trời Hằng Hữu lấy da thú làm áo và mặc cho A-đam và vợ người. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Đức Chúa Trời Hằng Hữu nói: “Loài người đã biết phân biệt thiện ác y như chúng ta. Nếu bây giờ họ hái trái cây sự sống để ăn, họ sẽ sống vĩnh hằng!” ");
INSERT INTO vieovcb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Vì thế, Đức Chúa Trời Hằng Hữu đuổi họ khỏi vườn Ê-đen, để khai khẩn đất mà Ngài đã dùng tạo nên loài người. ");
INSERT INTO vieovcb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Khi đuổi hai người ra, Đức Chúa Trời Hằng Hữu đặt các thiên thần cầm gươm chói lòa tại phía đông vườn Ê-đen, để canh giữ con đường dẫn đến cây sự sống. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","A-đam ăn ở với Ê-va, vợ mình, và bà có thai. Khi sinh Ca-in, bà nói: “Nhờ Chúa Hằng Hữu, tôi sinh được một trai!” ");
INSERT INTO vieovcb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Bà lại sinh A-bên, em Ca-in. Khi họ lớn lên, A-bên chăn nuôi gia súc, còn Ca-in làm nông. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Đến mùa, Ca-in lấy thổ sản làm lễ vật dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","A-bên cũng dâng chiên đầu lòng với luôn cả mỡ. Chúa Hằng Hữu đoái trông đến A-bên và nhận lễ vật, ");
INSERT INTO vieovcb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","nhưng Ngài không nhìn đến Ca-in và lễ vật của người, nên Ca-in giận dữ và gằm mặt xuống. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Chúa Hằng Hữu hỏi Ca-in: “Tại sao con giận? Sao mặt con gằm xuống? ");
INSERT INTO vieovcb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nếu con làm điều tốt thì lẽ nào không được chấp nhận? Nếu con không làm điều phải, thì hãy coi chừng! Tội lỗi đang rình rập ở cửa và thèm con lắm, nhưng con phải khống chế nó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Lúc ấy, Ca-in nói với A-bên: “Anh em mình ra ngoài đồng đi.” Khi hai anh em ra đó, Ca-in xông lại giết A-bên. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Chúa Hằng Hữu hỏi Ca-in: “A-bên, em con đâu?” Ca-in đáp: “Con không biết! Con đâu phải người trông nom nó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Chúa Hằng Hữu phán: “Con đã làm gì? Tiếng máu em con đổ dưới đất, đã thấu tai Ta. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Từ nay, con bị đuổi khỏi mảnh đất đã nhuộm máu em của con. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Dù con trồng trọt, đất cũng không sinh hoa lợi cho con nữa. Con sẽ là người chạy trốn, người lang thang trên mặt đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ca-in thưa với Đức Chúa Trời Hằng Hữu: “Hình phạt ấy nặng quá sức chịu đựng của con. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ngày nay, Chúa đuổi con khỏi đồng ruộng này; con là người chạy trốn, lang thang, và xa lánh mặt Chúa. Nếu có ai gặp con, họ sẽ giết con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Chúa Hằng Hữu đáp: “Ai giết con sẽ bị phạt bảy lần án phạt của con.” Chúa Hằng Hữu đánh dấu trên người Ca-in, để ai gặp ông sẽ không giết. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ca-in lánh mặt Chúa Hằng Hữu và đến sống tại xứ Nốt, về phía đông Ê-đen. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ca-in ăn ở với vợ, bà có thai và sinh Hê-nóc. Ca-in xây một thành và gọi thành ấy là Hê-nóc theo tên con. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hê-nóc sinh Y-rát. Y-rát sinh Mê-hu-gia-ên. Mê-hu-gia-ên sinh Mê-tu-sa-ên. Mê-tu-sa-ên sinh Lê-méc. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lê-méc lấy hai vợ. Vợ đầu tiên là A-đa và vợ sau là Si-la. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","A-đa sinh Gia-banh. Gia-banh là tổ phụ của dân ở lều và nuôi gia súc. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Em Gia-banh là Giu-banh, tổ phụ của những người đàn thụ cầm và thổi sáo. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Còn Si-la sinh Tu-banh-ca-in, người rèn các dụng cụ bằng đồng và bằng sắt. Em gái Tu-banh-ca-in là Na-a-ma. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Một hôm, Lê-méc nói với vợ: “Này, A-đa và Si-la, hãy nghe tiếng ta; hãy nghe ta, hỡi vợ của Lê-méc. Ta đã giết một người, vì nó đánh ta, và một người trẻ vì nó làm ta bị thương. ");
INSERT INTO vieovcb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ai giết Ca-in sẽ bị phạt bảy lần, còn ai giết ta sẽ bị báo thù bảy mươi bảy lần!” ");
INSERT INTO vieovcb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Sau đó, A-đam và Ê-va còn sinh một con trai nữa, đặt tên là Sết. Ê-va nói: “Đức Chúa Trời cho tôi một con trai khác, thay cho A-bên mà Ca-in đã sát hại.” ");
INSERT INTO vieovcb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sết cũng sinh con trai và đặt tên là Ê-nót. Từ đời Ê-nót, người ta bắt đầu cầu khẩn Danh Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Đây là dòng dõi A-đam. Đức Chúa Trời đã sáng tạo A-đam như hình ảnh Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ngài tạo ra người nam và người nữ. Ngay từ đầu, Ngài ban phước lành cho họ và gọi họ là “người.” ");
INSERT INTO vieovcb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Khi A-đam 130 tuổi, ông sinh một con trai giống như mình và đặt tên là Sết. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sau khi sinh Sết, A-đam còn sống thêm 800 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Vậy, A-đam thọ 930 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Khi Sết 105 tuổi, ông sinh Ê-nót. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sau khi sinh Ê-nót, Sết còn sống thêm 807 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Vậy Sết thọ 912 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Khi Ê-nót 90 tuổi, ông sinh Kê-nan. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sau khi sinh Kê-nan, Ê-nót còn sống thêm 815 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Vậy Ê-nót thọ 905 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Khi Kê-nan 70 tuổi, ông sinh Ma-ha-la-lê. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sau khi sinh Ma-ha-la-lê, Kê-nan còn sống thêm 840 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Vậy Kê-nan thọ 910 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Khi Ma-ha-la-lê 65 tuổi, ông sinh Gia-rết. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sau khi sinh Gia-rết, ông Ma-ha-la-lê còn sống thêm 830 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ma-ha-la-lê thọ 895 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Khi Gia-rết 162 tuổi, ông sinh Hê-nóc. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sau khi sinh Hê-nóc, Gia-rết còn sống thêm 800 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Vậy Gia-rết thọ 962 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Khi Hê-nóc 65 tuổi, ông sinh Mê-tu-sê-la. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Sau khi sinh Mê-tu-sê-la, Hê-nóc sống thêm 300 năm, đồng đi với Đức Chúa Trời, và ông có thêm con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hê-nóc sống được 365 năm, ");
INSERT INTO vieovcb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ông đồng đi với Đức Chúa Trời, tận hưởng liên hệ gần gũi với Ngài. Một ngày kia thình lình ông biến mất, vì Đức Chúa Trời đem ông đi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Khi Mê-tu-sê-la 187 tuổi, ông sinh Lê-méc. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sau khi sinh Lê-méc, Mê-tu-sê-la còn sống thêm 782 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Vậy, Mê-tu-sê-la thọ 969 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Khi Lê-méc 182 tuổi, ông sinh một con trai. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ông đặt tên con là Nô-ê, và nói: “Nó sẽ an ủi chúng ta lúc lao động và nhọc nhằn, vì đất đã bị Chúa Hằng Hữu nguyền rủa, bắt tay ta phải làm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sau khi sinh Nô-ê, Lê-méc còn sống thêm 595 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Vậy, Lê-méc thọ 777 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nô-ê được 500 tuổi, ông có ba con trai: Sem, Cham, và Gia-phết. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Loài người đông đúc thêm trên mặt đất và sinh nhiều con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Các con trai Đức Chúa Trời thấy con gái loài người xinh đẹp, họ liền cưới những người họ ưa thích. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Chúa Hằng Hữu phán: “Thần Linh của Ta sẽ chẳng ở với loài người mãi mãi, vì người chỉ là xác thịt. Đời người chỉ còn 120 năm mà thôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Đời đó và đời sau, trên mặt đất có người khổng lồ, do con trai Đức Chúa Trời ăn ở với con gái loài người sinh ra. Đó là những người hùng nổi danh thời cổ. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Chúa Hằng Hữu thấy loài người gian ác quá, tất cả ý tưởng trong lòng đều xấu xa luôn luôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Chúa Hằng Hữu buồn lòng và tiếc vì đã tạo nên loài người. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Chúa Hằng Hữu phán: “Ta sẽ xóa sạch khỏi mặt đất loài người Ta đã sáng tạo, từ loài người cho đến loài thú, loài bò sát, và loài chim trời. Ta tiếc đã tạo ra chúng nó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Dù vậy, Nô-ê được ơn phước của Đức Chúa Trời Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Đây là câu chuyện của Nô-ê: Nô-ê là người công chính, sống trọn vẹn giữa những người thời đó, và đồng đi với Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ông có ba con trai: Sem, Cham, và Gia-phết. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Lúc ấy, khắp đất đều đồi trụy, đầy tội ác và hung bạo trước mặt Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Đức Chúa Trời nhìn xuống địa cầu và thấy nếp sống của cả nhân loại đều hư hoại. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Đức Chúa Trời phán cùng Nô-ê: “Ta quyết định hủy diệt loài người, vì mặt đất đầy dẫy tội ác do chúng nó gây ra. Phải, Ta sẽ xóa sạch loài người khỏi mặt địa cầu! ");
INSERT INTO vieovcb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Con hãy đóng một chiếc tàu bằng gỗ bách, ngăn làm nhiều phòng, và trét nhựa cả trong lẫn ngoài. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Chiều dài chiếc tàu là 138 mét, chiều rộng 23 mét, và chiều cao 13,8 mét. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Con trổ cửa sổ chung quanh tàu, cách mái 0,46 mét, và con đặt cửa ra vào bên hông tàu. Con cũng đóng sàn ngăn tàu làm ba tầng—tầng dưới, tầng giữa, và tầng trên. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Này, Ta sẽ cho nước lụt ngập mặt đất để hủy diệt mọi sinh vật dưới trời. Tất cả đều bị hủy diệt. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Dù vậy, Ta lập giao ước với con. Con sẽ vào tàu cùng vợ con, các con trai con, và các con dâu. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Con cũng đem vào tàu tất cả các loài sinh vật để chúng giữ được sự sống với con. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Loài chim trời, loài gia súc, và loài bò sát, mỗi thứ một cặp, đực và cái sẽ đến cùng con để được sống. ");
INSERT INTO vieovcb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Con cũng trữ lương thực trong tàu cho con và cho loài vật.” ");
INSERT INTO vieovcb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Vậy, Nô-ê làm theo mọi điều Đức Chúa Trời phán dạy. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Chúa Hằng Hữu phán cùng Nô-ê: “Con và cả gia đình hãy vào tàu, vì trong đời này, Ta thấy con là người công chính duy nhất trước mặt Ta. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Con cũng đem theo các thú vật tinh sạch, mỗi loài bảy cặp, đực và cái; các thú vật không tinh sạch, mỗi loài một cặp, đực và cái; ");
INSERT INTO vieovcb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","các loài chim trời, mỗi loài bảy cặp, trống và mái, để giữ dòng giống trên mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bảy ngày nữa, Ta sẽ cho mưa trút xuống mặt đất suốt bốn mươi ngày và bốn mươi đêm. Ta sẽ xóa sạch khỏi mặt đất mọi sinh vật Ta đã sáng tạo.” ");
INSERT INTO vieovcb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nô-ê làm theo mọi điều Chúa Hằng Hữu chỉ dạy. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nô-ê được 600 tuổi khi nước lụt dâng lên. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ông vào tàu tránh nước lụt cùng vợ, các con trai, và các con dâu. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Các thú vật tinh sạch và không tinh sạch, các loài chim, và loài bò sát, từng cặp, đực và cái, trống và mái. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Chúng đều theo Nô-ê vào tàu, như lời Đức Chúa Trời chỉ dạy. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Bảy ngày sau, nước lụt dâng lên phủ mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Vào năm Nô-ê được 600 tuổi, ngày thứ mười bảy tháng Hai, mưa từ trời trút xuống như thác lũ, các mạch nước dưới đất đều vỡ tung. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mưa liên tiếp bốn mươi ngày và bốn mươi đêm. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ngày ấy, Nô-ê, vợ, ba con trai—Sem, Cham, Gia-phết—và ba con dâu vào tàu. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Cùng vào tàu với họ có các loài thú rừng, loài gia súc, loài bò sát, và loài chim trời. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Từng đôi từng cặp đều theo Nô-ê vào tàu, đại diện mỗi loài vật sống có hơi thở. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Tất cả các giống đực và cái, trống và mái, như lời Đức Chúa Trời đã phán dạy Nô-ê. Sau đó, Chúa Hằng Hữu đóng cửa tàu lại. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Suốt bốn mươi ngày, nước lụt ào ạt lan tràn, bao phủ khắp nơi và nâng chiếc tàu khỏi mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nước dâng lên cao; chiếc tàu nổi trên mặt nước. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nước tiếp tục dâng cao hơn nữa; mọi đỉnh núi cao dưới trời đều bị ngập. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Nước phủ các ngọn núi cao nhất; núi chìm sâu trong nước trên 6,9 mét. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tất cả các loài sống trên đất đều chết—loài chim trời, loài gia súc, loài thú rừng, loại bò lúc nhúc, và loài người. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mọi loài có hơi thở, sống trên mặt đất đều chết hết. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mọi sinh vật trên mặt đất đều bị hủy diệt, từ loài người cho đến loài thú, loài bò sát, và loài chim trời. Tất cả đều bị quét sạch khỏi mặt đất, chỉ còn Nô-ê và gia đình cùng mọi loài ở với ông trong tàu được sống sót. ");
INSERT INTO vieovcb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nước ngập mặt đất suốt 150 ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Đức Chúa Trời không quên Nô-ê và các loài sinh vật ở với ông trong tàu. Ngài khiến cơn gió thổi ngang qua mặt nước, nước lụt liền rút xuống. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Các mạch nước dưới đất và các nguồn nước trên trời ngưng lại, cơn mưa liền dứt. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Sau 150 ngày ngập lụt, nước hạ xuống, và dần dần rút khỏi mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Năm tháng sau, chiếc tàu mắc cạn trên núi A-ra-rát. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nước cứ hạ dần. Cho đến hai tháng rưỡi sau, các đỉnh núi mới ló dạng. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Sau bốn mươi ngày, Nô-ê mở cửa sổ trên tàu ");
INSERT INTO vieovcb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","và thả một con quạ ra ngoài; nó bay lui bay tới cho đến khi nước rút khô trên đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nô-ê cũng thả một con chim bồ câu, để xem nước rút khỏi mặt đất chưa. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Khi bồ câu không tìm được chỗ đáp xuống, nó liền bay trở về tàu với Nô-ê, vì mực nước còn cao. Nô-ê đưa tay đỡ lấy bồ câu và đưa vào tàu. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Đợi bảy ngày nữa, Nô-ê lại thả bồ câu ra khỏi tàu. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Đến chiều, bồ câu bay về, trong mỏ ngậm một lá ô-liu vừa mới ngắt. Nô-ê biết nước đã rút khỏi mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Bảy ngày sau, Nô-ê lại thả bồ câu ra, nhưng lần này bồ câu không trở lại. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Vào ngày đầu tiên của năm mới, mười tháng rưỡi từ khi cơn nước lụt bắt đầu, Nô-ê được 601 tuổi, ông mở cửa tàu nhìn ra và thấy nước đã rút cạn. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hai tháng sau, cuối cùng đất cũng khô! ");
INSERT INTO vieovcb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Đức Chúa Trời phán cùng Nô-ê: ");
INSERT INTO vieovcb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Con và gia đình hãy ra khỏi tàu. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Con cũng thả các sinh vật đã ở với con, nào loài chim, loài thú, và loài bò sát, để chúng sinh sôi nẩy nở và tăng thêm nhiều trên mặt đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nô-ê cùng vợ, các con, và các dâu đều ra khỏi tàu. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tất cả các loài thú, loài chim, và loài bò sát sống trên mặt đất cũng ra khỏi tàu với Nô-ê. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nô-ê lập bàn thờ cho Chúa Hằng Hữu, và ông bắt các loài thú và chim tinh sạch để dâng làm của lễ thiêu trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Chúa Hằng Hữu hưởng lấy mùi thơm và tự nhủ: “Ta chẳng bao giờ nguyền rủa đất nữa, cũng chẳng tiêu diệt mọi loài sinh vật như Ta đã làm, vì ngay lúc tuổi trẻ, loài người đã có khuynh hướng xấu trong lòng. ");
INSERT INTO vieovcb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Hễ đất còn thì mùa gieo và mùa gặt, tiết trời lạnh và nóng, mùa hè và mùa đông, ngày và đêm sẽ không bao giờ chấm dứt.” ");
INSERT INTO vieovcb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Đức Chúa Trời ban phước cho Nô-ê và các con. Ngài phán: “Hãy sinh sản thêm nhiều cho đầy mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Các loài thú dưới đất, loài chim trên trời, loài cá dưới biển đều khiếp sợ các con và phục quyền các con. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ta cho các con mọi loài đó làm lương thực, cũng như Ta đã cho cây trái. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tuy nhiên, con không được ăn thịt còn máu. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ta chắc chắn sẽ đòi máu của sinh mạng con hoặc từ nơi thú vật, hoặc từ tay người, hoặc nơi tay của anh em con. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kẻ giết người phải bị xử tử, vì Đức Chúa Trời đã tạo nên loài người theo hình ảnh Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Các con hãy sinh sản thêm nhiều và làm cho đầy mặt đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Đức Chúa Trời phán với Nô-ê và các con: ");
INSERT INTO vieovcb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ta lập giao ước với các con và dòng dõi các con, ");
INSERT INTO vieovcb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","cùng mọi sinh vật ở với con—các loài chim, các loài súc vật, và các loài dã thú. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ta lập giao ước với các con và các sinh vật rằng chúng chẳng bao giờ bị nước lụt giết hại nữa và cũng chẳng có nước lụt tàn phá đất nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Đức Chúa Trời phán: “Đây là dấu chỉ về giao ước Ta lập cùng các con và muôn loài trên đất trải qua các thời đại. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ta sẽ đặt cầu vồng trên mây, biểu hiện lời hứa bất diệt của Ta với con và muôn loài trên đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Khi nào Ta giăng mây trên trời, và cầu vồng xuất hiện trên mây, ");
INSERT INTO vieovcb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ta sẽ nhớ lại lời hứa với con và muôn loài: Nước lụt sẽ chẳng hủy diệt mọi sinh vật nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Khi Ta thấy cầu vồng trên mây, Ta sẽ nhớ lại lời hứa vĩnh viễn của Ta với con và mọi sinh vật trên đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Đức Chúa Trời lại phán cùng Nô-ê: “Đó là dấu chỉ về giao ước Ta đã lập giữa Ta và các sinh vật trên đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Các con trai Nô-ê đã ra khỏi tàu là Sem, Cham, và Gia-phết. (Cham là cha của Ca-na-an.) ");
INSERT INTO vieovcb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Do ba con trai Nô-ê mà mọi dân tộc trên mặt đất được sinh ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nô-ê bắt đầu cày đất và trồng nho. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ông uống rượu say, nằm trần truồng trong trại. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham, cha Ca-na-an, thấy thế, liền ra ngoài thuật cho Sem và Gia-phết. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem và Gia-phết lấy áo choàng vắt vai, đi giật lùi vào trại và phủ cho cha. Mặt họ quay ra bên ngoài, nên không nhìn thấy cha trần truồng. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Khi Nô-ê tỉnh rượu, biết được việc Cham đã làm cho mình, ");
INSERT INTO vieovcb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ông nói: “Nguyện Ca-na-an bị nguyền rủa, Nó sẽ làm nô lệ thấp hèn nhất của anh em mình.” ");
INSERT INTO vieovcb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ông tiếp: “Tôn vinh Chúa Hằng Hữu, Đức Chúa Trời của Sem, nguyện Ca-na-an làm nô lệ cho nó! ");
INSERT INTO vieovcb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nguyện Đức Chúa Trời mở rộng bờ cõi của Gia-phết, cho nó sống trong trại của Sem, và Ca-na-an làm nô lệ cho nó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Sau nước lụt, Nô-ê sống thêm 350 năm. ");
INSERT INTO vieovcb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ông qua đời năm 950 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Sau nước lụt, ba con trai Nô-ê: Sem, Cham, và Gia-phết lần lượt sinh con. Đây là dòng dõi của họ: ");
INSERT INTO vieovcb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Con trai Gia-phết là Gô-me, Ma-gót, Ma-đai, Gia-van, Tu-banh, Mê-siếc, và Ti-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Con trai Gô-me là Ách-kê-na, Ri-phát, và Tô-ga-ma. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Con trai Gia-van là Ê-li-sa, Ta-rê-si, Kít-tim, và Rô-đa-nim. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Dòng dõi họ là những dân tộc chia theo dòng họ sống dọc miền duyên hải ở nhiều xứ, mỗi dân tộc có ngôn ngữ riêng biệt. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Con trai Cham là Cút, Mích-ra-im, Phút, và Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Con trai Cút là Xê-ba, Ha-vi-la, Xáp-ta, Ra-ma, và Sáp-tê-ca. Con trai của Ra-ma là Sê-ba và Đê-đan. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cút là tổ phụ Nim-rốt, ông khởi xưng anh hùng đầu tiên trên mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ông săn bắn dũng cảm trước mặt Chúa Hằng Hữu. Phương ngôn có câu: “Anh hùng như Nim-rốt, săn bắn dũng cảm trước mặt Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Lúc đầu, vương quốc của ông bao gồm Ba-bên, Ê-rết, A-cát, và Ca-ne trong xứ Si-nê-a. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kế đó, lãnh thổ của ông bành trướng sang xứ A-sy-ri. Ông xây thành Ni-ni-ve, Rê-hô-bô-ti, Ca-la, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","và Rê-sen (giữa Ni-ni-ve và Ca-la, thủ đô của vương quốc). ");
INSERT INTO vieovcb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mích-ra-im là tổ phụ các dân tộc Lu-đim, A-na-mim, Lê-ha-bim, Náp-tu-him, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Bát-ru-sim, Cách-lu-him (từ dân này sinh ra người Phi-li-tin), và Cáp-tô-rim. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ca-na-an sinh Si-đôn, con đầu lòng. Ca-na-an là tổ phụ dân tộc Hê-tít, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Giê-bu, A-mô-rít, Ghi-rê-ga, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hê-vi, A-rê-kít, Si-nít, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","A-va-đít, Xê-ma-rít, và Ha-ma-tít. Sau đó, dòng dõi Ca-na-an tản mác ");
INSERT INTO vieovcb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","từ Si-đôn cho đến Ghê-ra tận Ga-xa, và cho đến Sô-đôm, Gô-mô-rơ, Át-ma, và Sê-bô-im tận Lê-sa. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Đó là con cháu Cham, phân chia theo dòng họ, ngôn ngữ, lãnh thổ, và dân tộc. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, anh cả của Gia-phết, là tổ phụ Hê-be. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Con trai Sem là Ê-lam, A-su-rơ, A-bác-sát, Lút, và A-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Con trai A-ram là U-xơ, Hu-lơ, Ghê-te, và Mách. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","A-bác-sát sinh Sê-lách; Sê-lách sinh Hê-be. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hê-be sinh Bê-léc (Bê-léc nghĩa là “chia rẽ” vì sinh vào lúc các dân tộc chia ra thành từng nhóm ngôn ngữ khác nhau). Người em tên Giốc-tan. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Giốc-tan sinh A-mô-đát, Sê-lép, Ha-sa-ma-vết, Giê-ra, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Ha-đô-ram, U-xa, Điết-la, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ô-ban, A-bi-ma-ên, Sê-ba, ");
INSERT INTO vieovcb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ô-phia, Ha-vi-la, và Giô-báp. Đó là các con trai Giốc-tan. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Họ định cư từ miền Mê-sa cho đến ngọn đồi Sê-pha ở phía đông. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Đó là con cháu Sem, phân chia theo dòng họ, ngôn ngữ, lãnh thổ, và dân tộc. ");
INSERT INTO vieovcb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Trên đây là dòng dõi ba con trai Nô-ê qua nhiều thế hệ, chia ra nhiều dân tộc. Cũng nhờ họ mà có các dân tộc phân tán trên mặt đất sau cơn nước lụt. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Lúc ấy, cả nhân loại đều nói một thứ tiếng. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Khi đến phương đông, họ tìm thấy đồng bằng trong xứ Si-nê-a và định cư tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Họ bảo nhau: “Chúng ta hãy làm gạch nung trong lửa, dùng nhựa làm hồ, và khởi công xây cất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Họ lại nói rằng: “Chúng ta hãy xây một thành phố vĩ đại, có cái tháp cao tận trời, danh tiếng chúng ta sẽ tồn tại muôn đời. Như thế, chúng ta sẽ sống đoàn tụ khỏi bị tản lạc khắp mặt đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Chúa Hằng Hữu xuống xem thành phố và ngọn tháp loài người đang xây. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ngài nói: “Vì chỉ là một dân tộc, nói cùng một thứ tiếng, nên họ đã bắt đầu công việc này, chẳng có gì ngăn cản được những việc họ định làm. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Chúng Ta hãy xuống và làm xáo trộn ngôn ngữ, để họ không hiểu lời nói của nhau.” ");
INSERT INTO vieovcb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Chúa Hằng Hữu làm họ tản lạc khắp mặt đất, không tiếp tục xây thành phố được. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Vì thế, thành phố đó gọi là Ba-bên (nghĩa là xáo trộn), vì Chúa Hằng Hữu đã làm xáo trộn tiếng nói cả thế giới và phân tán loài người khắp mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Đây là dòng dõi Sem: Hai năm sau nước lụt, Sem được 100 tuổi, sinh A-bác-sát. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sau khi sinh A-bác-sát, Sem còn sống thêm 500 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","A-bác-sát được 35 tuổi, sinh Sê-lách. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sau khi sinh Sê-lách, A-bác-sát còn sống thêm 403 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Khi Sê-lách được 30 tuổi, ông sinh Hê-be. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sau khi sinh Hê-be, Sê-lách còn sống thêm 403 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Khi Hê-be được 34 tuổi, ông sinh Bê-léc. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Sau khi sinh Bê-léc, Hê-be còn sống thêm 430 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Khi Bê-léc được 30 tuổi, ông sinh Rê-hu. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Sau khi sinh Rê-hu, Bê-léc còn sống thêm 209 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Khi Rê-hu được 32 tuổi, ông sinh Sê-rúc. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sau khi sinh Sê-rúc, Rê-hu còn sống thêm 207 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Khi Sê-rúc được 30 tuổi, ông sinh Na-cô. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sau khi sinh Na-cô, Sê-rúc còn sống thêm 200 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Khi Na-cô được 29 tuổi, ông sinh Tha-rê. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Sau khi sinh Tha-rê, Na-cô còn sống thêm 119 năm và sinh con trai con gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Khi Tha-rê được 70 tuổi, ông sinh Áp-ram, Na-cô, và Ha-ran. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Đây là dòng dõi Tha-rê: Tha-rê sinh Áp-ram, Na-cô, và Ha-ran. Ha-ran sinh Lót. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ha-ran mất sớm tại quê hương (xứ U-rơ của người Canh-đê), khi Tha-rê hãy còn sống. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Áp-ram và Na-cô cưới vợ. Vợ Áp-ram là Sa-rai; vợ Na-cô là Minh-ca, con gái Ha-ran. Em Minh-ca là Ích-ca. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sa-rai son sẻ, không có con. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tha-rê đem con trai là Áp-ram, con dâu Sa-rai (vợ của Áp-ram), và cháu nội là Lót (con trai Ha-ran) ra khỏi U-rơ của người Canh-đê, để đến xứ Ca-na-an. Khi đến xứ Ha-ran, họ định cư. ");
INSERT INTO vieovcb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tha-rê thọ 205 tuổi và qua đời tại Ha-ran. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Chúa Hằng Hữu phán cùng Áp-ram: “Hãy lìa quê cha đất tổ, bỏ họ hàng thân thuộc, rời gia đình mình và đi đến xứ Ta sẽ chỉ định. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ta sẽ cho con trở thành tổ phụ một dân tộc lớn. Ta sẽ ban phước lành, làm rạng danh con, và con sẽ thành một nguồn phước cho nhiều người. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ta sẽ ban phước lành cho ai cầu phước cho con, nguyền rủa người nào nguyền rủa con. Tất cả các dân tộc trên mặt đất sẽ do con mà được hạnh phước.” ");
INSERT INTO vieovcb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Vậy, Áp-ram ra đi, như lời Chúa Hằng Hữu đã dạy. Lót cùng đi với ông. Khi rời khỏi Ha-ran, Áp-ram được bảy mươi lăm tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Áp-ram đem Sa-rai, vợ mình và Lót, cháu mình, cùng tất cả cơ nghiệp—đầy tớ và súc vật đã gây dựng tại Ha-ran—đi đến xứ Ca-na-an. Họ đều đến Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Áp-ram vào sâu trong xứ Ca-na-an, đến gần Si-chem, và dựng trại bên cây sồi tại Mô-rê. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Chúa Hằng Hữu hiện ra và phán cùng Áp-ram: “Ta sẽ cho dòng dõi con xứ này.” Áp-ram lập bàn thờ cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Sau đó, Áp-ram xuống vùng đồi núi giữa Bê-tên và A-hi (Bê-tên ở phía đông, A-hi ở phía tây). Tại đó, ông dựng trại, lập bàn thờ cho Chúa Hằng Hữu, và cầu nguyện với Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ông tiếp tục đi dần về hướng nam cho đến Nê-ghép. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Lúc ấy, vì có nạn đói lớn xảy đến trong xứ, nên Áp-ram lánh sang Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Khi sắp vào lãnh thổ Ai Cập, Áp-ram bảo Sa-rai: “Tôi biết bà rất đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Nếu người Ai Cập nhìn thấy bà, lại biết bà là vợ tôi, họ sẽ giết tôi để cướp bà. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hãy nói bà là em gái tôi. Nhờ bà, họ sẽ hậu đãi và tha mạng cho tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Quả nhiên, khi đến Ai Cập, mọi người đều trầm trồ về nhan sắc Sa-rai. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Triều thần Ai Cập thấy bà liền ca tụng với Pha-ra-ôn, vua mình, và bà bị đưa vào hậu cung. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nhờ bà, vua hậu đãi Áp-ram, cho ông nhiều chiên, bò, lừa, lạc đà, và đầy tớ nam nữ. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tuy nhiên, cũng vì Sa-rai, Chúa Hằng Hữu giáng tai họa khủng khiếp trên vua Pha-ra-ôn và cả hoàng cung Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Vua Pha-ra-ôn cho gọi Áp-ram vào trách: “Sao ngươi nỡ hại ta như thế? Sao không nói người là vợ ngươi? ");
INSERT INTO vieovcb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Sao lại nói người là em gái, nên ta đã lấy làm vợ? Bây giờ, vợ ngươi đây, hãy nhận lại và đi đi!” ");
INSERT INTO vieovcb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Vua Pha-ra-ôn ra lệnh cho quân sĩ hộ tống Áp-ram, vợ, đầy tớ, và tài sản của ông ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Áp-ram và vợ rời Ai Cập đến Nê-ghép, đem theo tất cả đầy tớ và tài sản. Lót cùng đi với ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","(Áp-ram có rất nhiều súc vật, bạc, và vàng.) ");
INSERT INTO vieovcb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Từ Nê-ghép ông tiếp tục lên hướng bắc, đến gần Bê-tên, chỗ đóng trại khi trước, giữa Bê-tên và A-hi. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Đây là nơi ông đã lập bàn thờ và cầu nguyện với Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lót, người cùng đi với Áp-ram, cũng có nhiều chiên, bò, và đầy tớ. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Đất đai miền này không đủ chỗ cho súc vật của Áp-ram và Lót, vì chiên, bò quá nhiều; họ không thể sống chung. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Lại có chuyện tranh chấp giữa bọn chăn chiên của Áp-ram và Lót. Lúc ấy, người Ca-na-an và người Phê-rết sống trong xứ. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Áp-ram bảo Lót: “Nên tránh chuyện xung khắc giữa bác với cháu, giữa bọn chăn chiên của bác và của cháu, vì chúng ta là ruột thịt. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Cháu hãy lựa chọn phần đất cháu ưa thích, và chúng ta chia tay. Nếu cháu sang phía đông, bác sẽ ở phía tây; còn nếu cháu chọn phía tây, bác sẽ qua phía đông.” ");
INSERT INTO vieovcb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lót ngắm nhìn vùng đồng bằng Giô-đan phì nhiêu, nước tưới khắp nơi. Phần đất này giống như vườn của Chúa Hằng Hữu, cũng giống miền Xoa nước Ai Cập. (Lúc ấy Chúa Hằng Hữu chưa hủy diệt thành Sô-đôm và thành Gô-mô-rơ.) ");
INSERT INTO vieovcb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lót liền chọn đồng bằng Giô-đan, đem bầy súc vật và đầy tớ mình sang phía đông. Thế là bác cháu chia tay. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Áp-ram ở lại xứ Ca-na-an; còn Lót sống trong các thành phố vùng đồng bằng và dựng trại gần Sô-đôm. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Người Sô-đôm vốn độc ác và phạm tội trọng đối với Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sau khi Lót từ biệt, Chúa Hằng Hữu nói với Áp-ram: “Hãy phóng tầm mắt nhìn khắp đông, tây, nam, và bắc: ");
INSERT INTO vieovcb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tất cả vùng đất con thấy được, Ta sẽ cho con và dòng dõi con vĩnh viễn. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ta sẽ làm cho dòng dõi con nhiều như cát bụi, không thể đếm được. ");
INSERT INTO vieovcb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Con hãy đi dọc ngang và quan sát khắp nơi, vì Ta sẽ cho con vùng đất này.” ");
INSERT INTO vieovcb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Áp-ram liền dời trại đến chùm cây sồi của Mam-rê, tại Hếp-rôn, và ông lập bàn thờ cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Lúc ấy, chiến tranh xảy ra trong xứ. Am-ra-phên, vua Si-nê-a; A-ri-óc, vua Ê-la-sa; Kết-rô-lao-me, vua Ê-lam; và Ti-đanh, vua Gô-im ");
INSERT INTO vieovcb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","đem quân tấn công Bê-ra, vua Sô-đôm; Biệt-sa, vua Gô-mô-rơ; Si-náp, vua Át-ma; Sê-mê-be, vua Xê-bô-im, và vua Bê-la (tức là Xoa). ");
INSERT INTO vieovcb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Năm vua này đóng quân tại thung lũng Si-đim (tức là Biển Chết). ");
INSERT INTO vieovcb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Trong mười hai năm, họ tùng phục Kết-rô-lao-me, nhưng sang năm thứ mười ba, họ nổi loạn. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Một năm sau, Kết-rô-lao-me và các vua đồng minh đem quân chinh phạt người Rê-pha-im tại Ách-ta-rốt Cát-na-im, người Xu-xim tại Cham, người Ê-mim tại đồng bằng Ki-ri-a-ta-im, ");
INSERT INTO vieovcb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","người Hô-rít tại núi Sê-i-rơ cho đến Ên-Ba-ran gần hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Các vua quay lại Ên-mích-phát (tức là Ca-đe), xâm lược lãnh thổ người A-ma-léc và người A-mô-rít tại Ha-xa-xôn Tha-ma. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Vua Sô-đôm, vua Gô-mô-rơ, vua Át-ma, vua Xê-bô-im, và vua Bê-la (tức là Xoa) đem quân dàn trận trong thung lũng Si-đim, ");
INSERT INTO vieovcb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","để chống lại Kết-rô-lao-me, vua Ê-lam; Ti-đanh, vua Gô-im; Am-ra-phên, vua Si-nê-a; và A-ri-óc, vua Ê-la-sa—(năm vua chống bốn.) ");
INSERT INTO vieovcb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Thung lũng Si-đim có nhiều hố nhựa. Quân của vua Sô-đôm và vua Gô-mô-rơ thua chạy, một phần rơi xuống hố, phần còn lại trốn lên núi. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Quân thắng trận cướp và đem đi tất cả tài sản, lương thực trong thành Sô-đôm và Gô-mô-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Họ cũng bắt Lót—cháu Áp-ram ở Sô-đôm—và cướp đoạt tài sản. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Một người chạy thoát và đến báo tin cho Áp-ram, người Hê-bơ-rơ, ngụ tại chòm cây sồi của Mam-rê, người A-mô-rít. Mam-rê, bà con của ông là Ếch-côn, và A-ne cùng kết ước với Áp-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Khi Áp-ram hay tin Lót bị bắt, ông liền tập họp 318 gia nhân đã sinh trưởng và huấn luyện trong nhà, đuổi theo địch quân cho đến Đan. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Đang đêm, ông chia quân tiến công, đánh đuổi quân địch cho đến Hô-ba, về phía bắc Đa-mách. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ông thu hồi tất cả tài sản đã mất, cũng đem Lót, cháu mình, tài sản, cùng với phụ nữ và dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sau khi chiến thắng Kết-rô-lao-me và các vua đồng minh, Áp-ram quay về. Vua Sô-đôm ra đón người trong Thung lũng Các Vua. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mên-chi-xê-đéc, vua Sa-lem cũng là thầy tế lễ của Đức Chúa Trời Chí Cao, đem bánh và rượu ra đón Áp-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Mên-chi-xê-đéc chúc phước lành cho Áp-ram rằng: “Cầu Đức Chúa Trời Chí Cao, Ngài là Đấng sáng tạo trời đất ban phước lành cho Áp-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Đức Chúa Trời Chí Cao đáng được ca ngợi, vì Ngài đã giao nạp quân thù vào tay ngươi!” Áp-ram dâng cho Mên-chi-sê-đéc một phần mười tài sản và chiến lợi phẩm. ");
INSERT INTO vieovcb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Vua Sô-đôm yêu cầu Áp-ram: “Ông giao trả người ông bắt lại cho chúng tôi. Còn tài vật thì ông có thể giữ lại.” ");
INSERT INTO vieovcb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Nhưng Áp-ram trả lời với vua Sô-đôm: “Tôi đã thề trước Chúa Hằng Hữu là Đức Chúa Trời Chí Cao—Đấng đã sáng tạo trời đất— ");
INSERT INTO vieovcb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","rằng tôi không lấy vật gì của vua cả, dù một sợi chỉ hay một sợi dây giày cũng không, để vua đừng nói: ‘Nhờ ta mà nó giàu!’ ");
INSERT INTO vieovcb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tôi không lấy gì cả, ngoại trừ số thực phẩm mà đám gia nhân đã ăn và phần chiến lợi phẩm chia cho các chiến sĩ đã theo tôi chiến đấu. Hãy để cho A-ne, Ếch-côn, và Mam-rê lãnh phần của họ đi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Sau đó, Chúa Hằng Hữu phán cùng Áp-ram trong giấc mộng: “Đừng sợ Áp-ram. Ta sẽ bảo vệ con và cho con phần thưởng lớn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Áp-ram thổ lộ: “Thưa Chúa Hằng Hữu, Chúa sẽ cho con điều chi? Vì không con nối dõi, con phải cho Ê-li-ê-se ở Đa-mách làm người kế nghiệp!” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Áp-ram tiếp: “Chúa chẳng ban cho con cái, nên một đầy tớ sinh trong nhà con sẽ nối nghiệp con!” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Chúa Hằng Hữu đáp: “Người này sẽ không kế nghiệp con đâu, nhưng một đứa con trai do con sinh ra sẽ kế nghiệp con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ban đêm, Chúa Hằng Hữu đem Áp-ram ra sân ngắm khung trời đầy sao và bảo: “Con nhìn lên bầu trời và thử đếm sao đi! Dòng dõi con sẽ đông như sao trên trời, không ai đếm được!” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Áp-ram tin lời Chúa Hằng Hữu, nên Chúa Hằng Hữu kể ông là người công chính. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Chúa Hằng Hữu kết luận: “Ta là Chúa Hằng Hữu, Ta đã đem con ra khỏi thành U-rơ xứ Canh-đê, để cho con xứ này làm sản nghiệp.” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Áp-ram dè dặt: “Thưa Chúa Hằng Hữu, làm sao con biết chắc rằng Chúa sẽ cho con xứ này?” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Chúa Hằng Hữu phán: “Con hãy đem đến đây một con bê cái, một con dê cái, một con chiên đực—tất cả đều ba tuổi—một con chim cu gáy, và một bồ câu non.” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Áp-ram đem dâng các sinh tế này lên cho Chúa, xẻ các thú vật làm đôi, và sắp hai phần đối nhau; nhưng để nguyên các con chim. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Các loài chim săn mồi sà xuống các sinh tế, nhưng Áp-ram đuổi chúng đi. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mặt trời vừa lặn, Áp-ram chìm vào một giấc ngủ thật say. Bóng tối dày đặc ghê rợn phủ xuống bao bọc ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Chúa Hằng Hữu phán cùng Áp-ram: “Con phải biết chắc chắn, dòng dõi con sẽ kiều ngụ nơi đất khách quê người, phải phục dịch dân bản xứ, và bị áp bức suốt 400 năm. Tuy nhiên, Ta sẽ đoán phạt nước mà dòng dõi con phục dịch. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Cuối cùng dòng dõi con sẽ thoát ách nô lệ và đem đi rất nhiều của cải. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Còn con sẽ được về với tổ phụ bình an và được chôn cất sau khi sống một đời trường thọ. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Đến đời thứ tư, dòng dõi con sẽ quay lại đất nước này, vì hiện nay, tội ác người A-mô-rít chưa lên đến cực độ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Khi mặt trời lặn và trời đã tối, bỗng có một lò lửa bốc khói, và một ngọn lửa cháy giữa các sinh tế bị phân đôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ngày hôm ấy, Chúa Hằng Hữu kết ước với Áp-ram rằng: “Ta đã cho dòng dõi con đất nước này, từ sông A-rít ở Ai Cập đến sông cái Ơ-phơ-rát, ");
INSERT INTO vieovcb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","đất của các dân Kê-nít, Kê-ni, Cát-mô-ni, ");
INSERT INTO vieovcb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hê-tít, Phê-rết, Rê-pha-im, ");
INSERT INTO vieovcb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","A-mô-rít, Ca-na-an, Ghi-rê-ga, và Giê-bu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sa-rai, vợ Áp-ram, vẫn chưa có con. Bà có nuôi một nữ tì Ai Cập tên là A-ga. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Bà bảo Áp-ram: “Vì Chúa Hằng Hữu không cho tôi có con, nên ông hãy ăn ở với nó, có lẽ tôi sẽ nhờ nó mà có con.” Áp-ram nghe theo lời vợ. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Thế là sau mười năm kiều ngụ tại xứ Ca-na-an, Sa-rai đưa A-ga, nữ tì Ai Cập, làm hầu cho Áp-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Áp-ram ăn ở với A-ga, và nàng có thai. Biết mình đã có thai, A-ga lên mặt khinh bà chủ. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sa-rai bực tức và trách cứ Áp-ram: “Điều hổ nhục tôi phải chịu là tại ông cả! Tôi đưa vào vòng tay ông đứa nữ tì của tôi. Thế mà khi có thai, nó lại lên mặt. Cầu Chúa Hằng Hữu phân xử giữa tôi với ông.” ");
INSERT INTO vieovcb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Áp-ram đáp: “Bà nuôi nữ tì thì bà có quyền trên nó, bà muốn làm gì thì làm.” Bị Sa-rai đối xử khắc nghiệt, A-ga bỏ nhà chủ trốn đi. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Thiên sứ của Chúa Hằng Hữu gặp A-ga bên dòng suối nước giữa đồng hoang, trên đường đi Su-rơ, và hỏi: ");
INSERT INTO vieovcb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“A-ga, nữ tì của Sa-rai, con từ đâu đến đây và định đi đâu?” Nàng đáp: “Con trốn bà chủ Sa-rai!” ");
INSERT INTO vieovcb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Thiên sứ của Chúa Hằng Hữu phán: “Con hãy về nhà bà chủ con và phục tùng dưới tay người.” ");
INSERT INTO vieovcb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Thiên sứ lại nói: “Ta sẽ làm cho dòng dõi con gia tăng đông đảo đến nỗi không ai đếm được.” ");
INSERT INTO vieovcb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Thiên sứ nói thêm: “Con đang mang thai và sẽ sinh con trai. Hãy đặt tên nó là Ích-ma-ên (nghĩa là ‘Đức Chúa Trời nghe’), vì Chúa Hằng Hữu đã đoái thương cảnh khốn khổ của con. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Con trai con sẽ như lừa rừng. Nó sẽ chống mọi người, và ai cũng chống lại nó. Nó sẽ chống nghịch các anh em của nó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","A-ga gọi Chúa Hằng Hữu, Đấng dạy nàng là “Đức Chúa Trời Thấy Rõ.” Nàng tự nhủ: “Tôi đã thấy Chúa là Đấng đoái xem tôi!” ");
INSERT INTO vieovcb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nàng đặt tên suối nước là La-chai-roi nghĩa là “Suối của Đấng Hằng Sống đã đoái xem tôi.” Dòng suối ấy chảy giữa Ca-đe và Bê-rết. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nàng sinh một con trai. Áp-ram đặt tên con là Ích-ma-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Áp-ram đã tám mươi sáu tuổi khi Ích-ma-ên ra đời. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Khi Áp-ram chín mươi chín tuổi, Chúa Hằng Hữu lại xuất hiện và phán: “Ta là Đức Chúa Trời Toàn Năng, con hãy sống một cuộc đời hoàn hảo trước mặt Ta. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ta sẽ lập giao ước với con và làm cho dòng dõi con gia tăng bội phần.” ");
INSERT INTO vieovcb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Áp-ram sấp mặt xuống đất. Đức Chúa Trời phán với ông: ");
INSERT INTO vieovcb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Này là giao ước của Ta với con: Ta sẽ làm cho con trở nên tổ phụ của nhiều dân tộc. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ta sẽ đổi tên con. Người ta không gọi con là Áp-ram (nghĩa là cha tôn quý) nữa; nhưng gọi là Áp-ra-ham (nghĩa là cha của các dân tộc)—vì Ta cho con làm tổ phụ nhiều dân tộc. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ta cho con sinh sôi nẩy nở ra nhiều dân tộc; hậu tự con gồm nhiều vua chúa! ");
INSERT INTO vieovcb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ta lập giao ước này với con và hậu tự con từ đời này sang đời khác. Giao ước này còn mãi đời đời: Ta sẽ luôn là Đức Chúa Trời của con và Đức Chúa Trời của hậu tự con. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ta sẽ cho con và hậu tự con đất mà con đang kiều ngụ, tức đất Ca-na-an. Đó sẽ là cơ nghiệp đời đời, và Ta sẽ làm Đức Chúa Trời của họ mãi mãi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Đức Chúa Trời phán cùng Áp-ra-ham: “Phần con và hậu tự con từ đời này sang đời kia phải giữ giao ước này của Ta: Tất cả người nam trong dòng dõi con phải chịu cắt bì. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Đây là giao ước các con phải giữ, tức là giao ước lập giữa Ta và các con cùng dòng dõi sau con. Các con phải chịu cắt bì; lễ đó là dấu hiệu của giao ước giữa Ta và các con; ");
INSERT INTO vieovcb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","da quy đầu phải bị cắt đi để chứng tỏ rằng con và hậu tự con vâng giữ giao ước này. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Từ đời nay về sau, mỗi bé trai phải chịu cắt bì sau khi sinh được tám ngày; con cái sinh trong gia đình hoặc con cái của đầy tớ mua từ nước ngoài, dù không phải hậu tự, cũng phải cắt bì. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Dù sinh ra trong gia đình hay mua bằng tiền, tất cả đều phải chịu cắt bì. Giao ước Ta lập trong xác thịt con là giao ước vĩnh hằng. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ai khước từ luật lệ đó sẽ bị khai trừ ra khỏi dân tộc, vì đã vi phạm giao ước Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Đức Chúa Trời dạy thêm: “Vợ của con cũng được đổi tên, không còn gọi là Sa-rai nữa nhưng là Sa-ra (nghĩa là công chúa). ");
INSERT INTO vieovcb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ta sẽ ban phước lành cho người và cho người sinh con trai kế nghiệp. Phải, Ta sẽ ban phước lành dồi dào cho Sa-ra, cho người làm tổ mẫu nhiều dân tộc; và hậu tự người gồm nhiều vua chúa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Áp-ra-ham sấp mình xuống đất, cười thầm, và tự nhủ: “Trăm tuổi mà có con được sao? Sa-ra đã chín mươi còn sinh nở được ư?” ");
INSERT INTO vieovcb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kế đó, Áp-ra-ham thưa với Đức Chúa Trời: “Ước gì Ích-ma-ên được sống dưới ơn phước của Ngài!” ");
INSERT INTO vieovcb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Đức Chúa Trời đáp: “Sa-ra, vợ con sẽ sinh con trai. Con sẽ đặt tên nó là Y-sác. Ta sẽ lập giao ước với nó và hậu tự nó đời đời. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Còn Ích-ma-ên, Ta đã nghe lời con xin. Ta ban phước lành cho nó và cho nó sinh sôi nẩy nở đông đúc thành một dân tộc lớn. Nó sẽ làm tổ phụ mười hai vua chúa. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tuy nhiên, Ta sẽ lập giao ước với Y-sác, mà Sa-ra sẽ sinh ra cho con vào độ này sang năm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Đến đây, Chúa chấm dứt nói chuyện với Áp-ra-ham và ngự lên trời. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ngay hôm ấy, Áp-ra-ham làm lễ cắt bì cho Ích-ma-ên, con trai mình, và tất cả những người nam sinh trong nhà hay nô lệ ông đã mua về, đúng theo lời Chúa dạy. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Lúc chịu cắt bì, Áp-ra-ham đã chín mươi chín tuổi; ");
INSERT INTO vieovcb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","còn Ích-ma-ên mới mười ba. ");
INSERT INTO vieovcb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Áp-ra-ham và Ích-ma-ên chịu cắt bì cùng trong một ngày, ");
INSERT INTO vieovcb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","luôn với tất cả những người nam sinh trong nhà, và nô lệ ông đã mua về. Tất cả đều cùng chịu cắt bì với ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Chúa Hằng Hữu lại xuất hiện cùng Áp-ra-ham tại cánh đồng Mam-rê. Áp-ra-ham đang ngồi tại cửa trại dưới tàng cây sồi trong lúc trời nắng nóng. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Vừa ngước nhìn lên, ông thấy ba người đang đứng phía trước mặt; ông liền chạy ra nghênh đón và cúi rạp xuống đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Áp-ra-ham thưa: “Lạy Chúa tôi, nếu tôi được Chúa đoái thương, xin đừng bỏ qua đầy tớ Chúa. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Xin cho tôi lấy nước rửa chân Chúa và kính mời Chúa nghỉ mát dưới bóng cây. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Vì Chúa đã hạ cố đến thăm nhà đầy tớ Chúa, tôi xin đem bánh để Chúa dùng trước khi lên đường.” Họ đáp: “Được, cứ làm như ông nói.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Áp-ra-ham vội vã vào trại và bảo Sa-ra: “Mau lên! Lấy ba đấu bột lọc nhồi đi rồi làm bánh nhỏ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Áp-ra-ham chạy đến bầy gia súc, chọn một con bê béo, và bảo đầy tớ nấu dọn gấp. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Áp-ra-ham đem sữa và bơ cùng thịt con bê đã nấu xong, dọn ra trước mặt ba người ấy. Khi họ ăn, Áp-ra-ham đứng cạnh hầu bàn dưới tàng cây. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Các vị ấy hỏi: “Áp-ra-ham! Sa-ra, vợ con ở đâu?” Áp-ra-ham thưa: “Dạ ở trong trại.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Một vị bảo: “Độ một năm nữa, Ta sẽ trở lại đây thăm con; khi đó, Sa-ra, vợ con, sẽ có một con trai!” Sa-ra đứng sau lưng vị ấy tại cửa trại, nên nghe rõ lời hứa này. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Áp-ra-ham và Sa-ra đều già yếu. Sa-ra không còn hy vọng sinh con được nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nghe Chúa hứa, Sa-ra cười thầm và tự bảo: “Già cả như tôi, đâu còn được niềm vui làm mẹ nữa! Tuổi chồng tôi cũng đã quá cao!” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Chúa Hằng Hữu hỏi Áp-ra-ham: “Tại sao Sa-ra cười và tự hỏi: ‘Già cả như tôi mà còn sinh sản được sao?’ ");
INSERT INTO vieovcb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Có điều nào Chúa Hằng Hữu làm không được? Đúng kỳ ấn định, trong một năm nữa, Ta sẽ trở lại thăm con; lúc ấy, Sa-ra sẽ có một con trai.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sa-ra sợ hãi và chối: “Con có dám cười đâu!” Chúa Hằng Hữu đáp: “Thật, con đã cười.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ba vị đứng dậy lên đường qua Sô-đôm. Áp-ra-ham theo tiễn chân một quãng đường. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Chúa Hằng Hữu hỏi: “Ta có nên giấu Áp-ra-ham chương trình Ta sắp thực hiện không? ");
INSERT INTO vieovcb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Vì Áp-ra-ham sẽ thành một dân tộc lớn và cường thịnh, và sẽ làm nguồn phước cho các dân tộc trên thế giới. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ta đã chọn Áp-ra-ham để người dạy dỗ con cháu và gia nhân vâng giữ đạo Ta, làm điều công chính và cương trực; nhờ đó, Ta có thể thực thi các lời Chúa Hằng Hữu đã hứa với Áp-ra-ham.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Chúa Hằng Hữu phán cùng Áp-ra-ham: “Ta đã nghe tiếng ai oán từ Sô-đôm và Gô-mô-rơ, vì tội ác của chúng thật nặng nề. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ta sẽ xuống đó xem có đúng như vậy không. Nếu không, Ta muốn biết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hai thiên sứ đi ngay qua Sô-đôm, nhưng Chúa Hằng Hữu còn nán lại với Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Áp-ra-ham đến gần và kính cẩn hỏi: “Chúa tiêu diệt người thiện chung với người ác sao? ");
INSERT INTO vieovcb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nếu có năm mươi người công chính trong thành, Chúa có tiêu diệt hết không? Chúa sẽ không dung thứ họ vì năm mươi người ấy sao? ");
INSERT INTO vieovcb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Chắc chắn Chúa sẽ không làm việc ấy, diệt người công chính chung với người ác! Không bao giờ Chúa đối xử người công chính và người ác giống như nhau! Chắc chắn Chúa không làm vậy! Lẽ nào Vị Thẩm Phán Chí Cao của cả thế giới lại không xử đoán công minh?” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Chúa Hằng Hữu đáp: “Nếu Ta tìm được năm mươi người công chính trong Sô-đôm, Ta sẽ dung thứ cả thành vì thương số người đó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Áp-ra-ham tiếp lời: “Thưa Chúa, con mạo muội thưa với Chúa, dù con chỉ là tro bụi. ");
INSERT INTO vieovcb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Nhỡ thiếu mất năm người trong số năm mươi, vì thiếu mất năm người Chúa có tiêu diệt cả thành chăng?” Chúa Hằng Hữu đáp: “Nếu Ta tìm gặp bốn mươi lăm người công chính, Ta sẽ chẳng diệt hết đâu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Áp-ra-ham đánh bạo: “Thưa Chúa, nếu chỉ có bốn mươi người thì sao?” Chúa Hằng Hữu đáp: “Ta sẽ dung thứ cả thành vì bốn mươi người ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Áp-ra-ham năn nỉ: “Xin Chúa đừng giận, con xin thưa: Nếu chỉ có ba mươi người thì sao?” Chúa Hằng Hữu đáp: “Ta sẽ dung thứ cả thành vì ba mươi người ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Áp-ra-ham khẩn khoản: “Vì con đã đánh bạo nài xin Chúa, nên con xin hỏi—nhỡ chỉ có hai mươi người thì sao?” Chúa Hằng Hữu đáp: “Ta sẽ dung thứ thành vì hai mươi người ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Cố nài nỉ lần cuối, Áp-ra-ham thưa: “Xin Chúa đừng giận, con chỉ xin thưa một lời nữa. Nhỡ chỉ có mười người thì sao?” Chúa Hằng Hữu đáp: “Ta cũng dung thứ cả thành vì mười người ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Khi nói chuyện với Áp-ra-ham xong, Chúa Hằng Hữu ra đi. Áp-ra-ham quay về trại. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tối hôm ấy, hai thiên sứ đến cổng thành Sô-đôm và gặp Lót đang ngồi tại đó. Thấy họ đến, Lót đứng dậy nghênh đón và sấp mình xuống đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Lót mời: “Thưa hai ngài, kính mời hai ngài đến nhà tôi nghỉ tạm đêm nay. Sáng mai, hai ngài có thể dậy sớm lên đường.” Họ đáp: “Cám ơn ông, tối nay chúng tôi ở ngoài phố cũng được.” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Vì Lót sốt sắng mời mọc nên rốt cuộc họ về nhà Lót. Lót dọn tiệc lớn khoản đãi, có cả bánh không men. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Nhưng trước khi họ chuẩn bị đi nghỉ thì những người đàn ông Sô-đôm, từ trẻ đến già, của khắp thành lũ lượt kéo đến vây quanh nhà. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Chúng gọi Lót ra chất vấn: “Hai người khách vào nhà anh khi tối ở đâu? Đem họ ra cho chúng ta hành dâm!” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lót ra khỏi nhà, sập cửa lại, ");
INSERT INTO vieovcb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","và nói với họ: “Anh em ơi, đừng làm điều ác đó! ");
INSERT INTO vieovcb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tôi có hai con gái chưa chồng. Tôi sẽ dẫn chúng ra cho anh em muốn làm gì mặc ý; nhưng xin đừng làm hại hai người kia, vì họ đã đến tá túc dưới mái nhà tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bọn chúng nói: “Lui ra! Tên này đến đây kiều ngụ mà nay dám giở giọng quan tòa! Ta phải xử tội mày nặng hơn hai người kia!” Chúng xông lên ép Lót vào cửa và làm cửa gần bật tung. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Nhưng hai thiên sứ đưa tay kéo Lót vào nhà, đóng cửa lại, ");
INSERT INTO vieovcb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","và làm cho đoàn dân Sô-đôm đang vây quanh bị mù mắt, tìm cửa vào không được. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Hai thiên sứ hỏi Lót: “Gia đình ông đủ mặt ở đây chưa? Hãy đem con rể, con trai, con gái, và người nhà ra khỏi đây lập tức. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Chúng ta sắp tiêu diệt thành, vì tiếng kêu ai oán đã thấu đến tai Chúa Hằng Hữu nên Ngài sai chúng ta xuống thực thi án phạt.” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lót chạy ra báo tin cho hai rể hứa: “Hai con phải đi khỏi thành ngay! Chúa Hằng Hữu sắp tiêu diệt thành này.” Nhưng hai người ấy tưởng Lót nói đùa. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Trời gần sáng, hai thiên sứ hối thúc Lót: “Nhanh lên! Hãy đem vợ và hai con gái ra khỏi đây lập tức, kẻo ông bị tiêu diệt chung với thành này!” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Thấy Lót chần chờ, hai thiên sứ nắm tay Lót và vợ con ông, kéo ngay ra khỏi thành, đưa đến chỗ an toàn, vì Chúa Hằng Hữu thương xót họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Một thiên sứ bảo họ: “Chạy nhanh lên kẻo mất mạng! Đừng ngoảnh lại hay ngừng lại bất cứ đâu ở đồng bằng. Hãy trốn ngay lên núi, kẻo bị vạ lây!” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lót thưa: “Ôi, thưa ngài, không được đâu. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Hai ngài đã thương tình cứu mạng tôi, nhưng tôi sợ chạy lên núi không kịp. Tai họa ấy xảy ra, tôi làm sao thoát chết? ");
INSERT INTO vieovcb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nhìn kìa, có một thành nhỏ gần đây. Xin cho tôi đến ẩn náu trong thành nhỏ đó. Như thế, tôi mới mong bảo toàn mạng sống.” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Thiên sứ đáp: “Được, ta chấp thuận lời ông xin và không tiêu diệt thành nhỏ đó đâu. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Phải nhanh lên, vì ta không hành động được cho đến khi ông vào thành đó.” (Từ ngày ấy, người ta gọi thành này là Xoa, nghĩa là “thành nhỏ.”) ");
INSERT INTO vieovcb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mặt trời vừa mọc, Lót chạy đến nơi và vào thành Xoa. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Chúa Hằng Hữu lập tức cho mưa lửa và diêm sinh từ trời đổ xuống thiêu đốt Sô-đôm, Gô-mô-rơ, luôn cả các thành phố, làng mạc trong đồng bằng đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tất cả đều chết cháy: Người, cây cối, và súc vật. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nhưng vợ ông Lót ngoảnh lại nhìn và biến thành một pho tượng muối. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Áp-ra-ham dậy sớm và đi đến chỗ ông gặp Chúa Hằng Hữu hôm trước. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ngước lên nhìn về phía Sô-đôm, Gô-mo, và vùng đồng bằng, ông thấy khói đen kịt như khói lò lửa lớn cuồn cuộn tỏa lên trời. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Khi Đức Chúa Trời tiêu diệt các thành phố vùng đồng bằng, Ngài vẫn nhớ đến Áp-ra-ham và cứu Lót thoát khỏi cái chết rùng rợn của người Sô-đôm. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Sợ ở Xoa không yên, Lót dẫn hai con gái lên núi, tạm trú trong một hang đá. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Một hôm, đứa chị bảo em: “Cha đã già và bây giờ trai tráng trong vùng đều chết hết, không còn ai đến lập gia đình với chị em mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ta chỉ còn cách chuốc rượu cho cha và thay nhau ngủ với cha để lưu truyền dòng giống cho cha.” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Đêm ấy, hai cô chuốc rượu cho cha, và cô chị vào ngủ với cha; nhưng cha say quá, không biết lúc nào nó nằm xuống và lúc nào nó trở dậy. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Hôm sau, cô chị bảo em: “Này, hôm qua chị đã ngủ với cha. Đêm nay ta lại chuốc rượu cho cha, và em vào để làm việc lưu truyền dòng giống cho cha!” ");
INSERT INTO vieovcb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Đêm ấy, hai cô lại cho cha uống rượu, và cô em vào ngủ với cha, nhưng cha không biết lúc nào nó nằm xuống và lúc nào nó trở dậy. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Vậy, hai con gái của Lót do cha ruột mà mang thai. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Cô chị sinh một con trai và đặt tên Mô-áp. Ông là tổ phụ của dân tộc Mô-áp ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Cô em cũng sinh con trai và đặt tên Bên Am-mi. Ông là tổ phụ của dân tộc Am-môn ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Từ đó, Áp-ra-ham tiến xuống phía nam, đến vùng Nê-ghép, cư ngụ giữa Ca-đe và Su-rơ, sau đó, ông đi xuống thành Ghê-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Trong khi tạm cự tại đó, ông giới thiệu Sa-ra là em gái mình. Vì thế, Vua A-bi-mê-léc cho rước Sa-ra vào cung. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Đêm ấy, Đức Chúa Trời báo mộng cho vua: “Ngươi phải chết, vì người đàn bà ngươi đem vào cung đã có chồng.” ");
INSERT INTO vieovcb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Vì A-bi-mê-léc chưa đụng đến Sa-ra nên vua tự bào chữa: “Không lẽ Chúa diệt người vô tội? ");
INSERT INTO vieovcb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Áp-ra-ham đã nói: ‘Nàng là em gái tôi’ cơ mà! Và nàng cũng xác nhận: ‘Áp-ra-ham là anh tôi.’ Con thật tình không có ý làm điều sai trái.” ");
INSERT INTO vieovcb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Đức Chúa Trời đáp: “Phải, Ta biết, nên Ta ngăn ngươi phạm tội và không cho ngươi đụng đến nàng. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hãy giao trả nàng về nhà chồng. Chồng nàng sẽ cầu nguyện cho ngươi khỏi chết, vì chồng nàng là nhà tiên tri. Nếu ngươi giữ nàng lại, chắc chắn ngươi và toàn dân ngươi sẽ chết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Vua dậy sớm, triệu tập quần thần, và thuật cho họ nghe mọi việc; ai nấy đều khiếp sợ. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Vua gọi Áp-ra-ham đến và quở trách: “Ngươi gieo họa cho chúng ta làm gì? Ta đã làm gì đến nỗi ngươi đối xử với ta như thế? Ngươi làm cho ta và nước ta đều mắc tội. Ngươi thật là tệ bạc! ");
INSERT INTO vieovcb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ngươi có dụng ý gì mà lừa gạt ta như thế?” ");
INSERT INTO vieovcb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Áp-ra-ham đáp: “Tôi tưởng nơi này không có người kính sợ Chúa, e có người sẽ giết tôi để cướp vợ tôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Thật tình, nàng cũng là em tôi, em một cha khác mẹ, nhưng tôi cưới nàng làm vợ. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Khi Đức Chúa Trời sai tôi đi đây đó xa quê hương, tôi bảo nàng: ‘Dù đi đâu, xin bà cũng hãy xưng bà là em gái tôi.’” ");
INSERT INTO vieovcb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Vua A-bi-mê-léc ban tặng cho Áp-ra-ham nhiều chiên, bò, tôi trai, tớ gái; và giao trả Sa-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Vua bảo: “Cứ đi khắp nước ta, xem địa điểm nào ngươi thích, rồi định cư ở đó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Vua quay lại nói với Sa-ra: “Đây, ta trả cho anh ngươi 1.000 lạng bạc để bồi thường danh dự. Thế là danh dự ngươi thật hoàn toàn, không chút hề hấn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Áp-ra-ham cầu xin Đức Chúa Trời chữa lành cho vua, hoàng hậu, và toàn nữ tì trong hoàng tộc để họ có thể sinh sản. ");
INSERT INTO vieovcb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Vì Chúa Hằng Hữu đã phạt A-bi-mê-léc, không cho hoàng hậu và các cung nữ có con, sau khi A-bi-mê-léc bắt vợ của Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Chúa Hằng Hữu thăm viếng Sa-ra như lời Ngài đã hứa. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sa-ra thụ thai và sinh cho Áp-ra-ham một con trai trong tuổi già nua, đúng thời gian Đức Chúa Trời đã báo trước. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Áp-ra-ham đặt tên con là Y-sác ");
INSERT INTO vieovcb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","và làm lễ cắt bì cho Y-sác khi mới được tám ngày, như lời Đức Chúa Trời phán dặn. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Lúc Y-sác ra đời, Áp-ra-ham đã được 100 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sa-ra nói: “Chúa cho tôi vui cười, ai nghe tin cũng vui cười với tôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Có ai dám nói với Áp-ra-ham rằng Sa-ra sẽ cho con bú đâu? Thế mà tôi đã sinh được đứa con trai cho ông chồng già yếu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Y-sác lớn lên; đến ngày dứt sữa, Áp-ra-ham đãi tiệc ăn mừng. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sa-ra chợt thấy Ích-ma-ên—đứa con mà A-ga, người nữ tì Ai Cập, đã sinh cho Áp-ra-ham—trêu chọc Y-sác, ");
INSERT INTO vieovcb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","liền nói với Áp-ra-ham: “Ông phải đuổi mẹ con nô lệ ấy đi! Tôi không cho thằng bé đó hưởng gia tài với Y-sác con tôi đâu!” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Việc này làm Áp-ra-ham buồn phiền, vì Ích-ma-ên cũng là con trai của ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Đức Chúa Trời phán cùng Áp-ra-ham: “Con đừng buồn vì đứa con hay vì A-ga. Cứ làm như Sa-ra nói, Nhờ Y-sác mà dòng dõi con sẽ sinh sôi nẩy nở. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Vì Ích-ma-ên cũng là giống nòi con, nên Ta sẽ cho nó thành một nước.” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Sáng hôm sau, Áp-ra-ham dậy sớm, gói thức ăn và một bầu nước trao cho A-ga, đặt trên vai nàng, và bảo mẹ con lên đường. A-ga dắt con đi lang thang trong hoang mạc miền Bê-e-sê-ba. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Khi bình đã hết nước, A-ga để con dưới một bụi cây nhỏ. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Rồi nàng đi khỏi đó độ một khoảng tên bắn, vì nàng nghĩ: “Ta đâu nỡ đứng nhìn con chết khát!” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Đức Chúa Trời nghe tiếng khóc của đứa nhỏ, nên thiên sứ của Đức Chúa Trời từ trời gọi xuống: “A-ga! Có việc gì thế? Đừng sợ, vì Đức Chúa Trời đã nghe tiếng khóc của đứa nhỏ ở ngay chỗ nó nằm rồi! ");
INSERT INTO vieovcb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Hãy đứng dậy, đỡ lấy nó, và cầm tay nó vì Ta sẽ làm cho nó thành một nước lớn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Được Đức Chúa Trời mở mắt, A-ga thấy một dòng nước, liền đến múc đầy bình nước cho con uống. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Chúa Trời phù hộ đứa trẻ. Nó lớn lên, sống giữa hoang mạc, và nổi tiếng về tài bắn cung. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Khi cư ngụ tại hoang mạc Pha-ran, Ích-ma-ên được mẹ cưới cho một cô vợ người Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lúc ấy, Vua A-bi-mê-léc và Tướng Phi-côn, chỉ huy quân đội Ai Cập, đến hội đàm với Áp-ra-ham. Họ nói: “Đức Chúa Trời ban phước cho ông trong mọi việc. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Hãy nhân danh Chúa mà thề rằng ông chẳng bao giờ dối gạt ta, con trai ta, hay người kế nghiệp ta cũng như hứa sẽ giao hảo với ta và nước ta, như ta đã giao hảo với ông.” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Áp-ra-ham đáp: “Tôi xin thề!” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Sau đó, Áp-ra-ham khiếu nại với vua về vụ cái giếng mà đầy tớ vua đã dùng bạo lực chiếm đoạt. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Vua tỏ vẻ kinh ngạc: “Đây là lần đầu tiên ta nghe vụ ấy. Ta không biết ai là thủ phạm. Sao ngươi không trình báo?” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Áp-ra-ham cung hiến chiên và bò cho vua để kết ước. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Áp-ra-ham bắt bảy con chiên tơ trong bầy và để riêng ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","A-bi-mê-léc hỏi: “Ông để bảy con chiên đó riêng ra làm gì?” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Áp-ra-ham đáp: “Xin vua nhận bảy con chiên này nơi tay tôi, để xác nhận tôi đã đào cái giếng này.” ");
INSERT INTO vieovcb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Vì thế, người ta gọi chỗ này là Bê-e-sê-ba, vì tại đó hai người đã thề với nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Áp-ra-ham và A-bi-mê-léc kết ước với nhau tại Bê-e-sê-ba. Sau đó, Vua A-bi-mê-léc và Tướng Phi-côn lên đường về xứ Phi-li-tin. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Áp-ra-ham trồng một cây me tại Bê-e-sê-ba và cầu khẩn Danh Chúa Hằng Hữu tại đây. ");
INSERT INTO vieovcb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Áp-ra-ham kiều ngụ lâu ngày trong xứ Phi-li-tin. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sau đó, Đức Chúa Trời thử nghiệm Áp-ra-ham. Đức Chúa Trời gọi: “Áp-ra-ham!” Người thưa: “Có con đây.” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Chúa phán: “Hãy bắt Y-sác, đứa con một mà con yêu quý, đem đến vùng Mô-ri-a, và dâng nó làm tế lễ thiêu trên một ngọn núi Ta sẽ chỉ cho con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Vậy, Áp-ra-ham dậy sớm, thắng lừa, đem Y-sác, con mình và hai đầy tớ đi theo. Ông chặt đủ củi để dâng tế lễ thiêu, lên đường đi đến địa điểm Đức Chúa Trời đã chỉ dạy. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ngày thứ ba, Áp-ra-ham ngước lên, nhìn thấy địa điểm ấy từ nơi xa, ");
INSERT INTO vieovcb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","liền bảo hai đầy tớ: “Hai đứa ở đây giữ lừa. Ta và Y-sác lên chỗ kia. Thờ phượng xong, chúng ta sẽ trở lại.” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Áp-ra-ham lấy bó củi để dâng tế lễ thiêu chất trên vai Y-sác, con mình, và người cầm theo mồi lửa và một con dao. Hai cha con cùng đi. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Y-sác nói: “Cha ơi!” Áp-ra-ham đáp: “Có cha đây.” Y-sác hỏi: “Củi và lửa có sẵn rồi, nhưng chiên con ở đâu mà dâng tế lễ thiêu?” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Áp-ra-ham đáp: “Con ơi, Đức Chúa Trời sẽ cung ứng chiên con làm tế lễ thiêu.” Hai cha con tiếp tục đi với nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Đến chỗ Đức Chúa Trời đã chỉ định, Áp-ra-ham dựng một bàn thờ, sắp củi lên, trói Y-sác, con mình, và đem đặt lên lớp củi trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Áp-ra-ham đưa tay cầm dao để giết con. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bỗng, thiên sứ của Chúa Hằng Hữu từ trên trời gọi: “Áp-ra-ham! Áp-ra-ham!” Ông thưa: “Có con đây.” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Thiên sứ bảo: “Đừng giết đứa trẻ, cũng đừng làm gì nó cả. Vì bây giờ Ta biết ngươi kính sợ Đức Chúa Trời và không tiếc con ngươi với Ta, dù là con một của ngươi!” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Áp-ra-ham ngước mắt nhìn thấy một con chiên đực, sừng đang mắc vào bụi gai rậm phía sau mình. Ông liền bắt nó dâng tế lễ thiêu thay thế con trai mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Áp-ra-ham gọi địa điểm này là “Chúa Hằng Hữu cung ứng.” Vì thế, cho đến ngày nay, người ta có câu: “Trên núi của Chúa Hằng Hữu, điều ấy sẽ được cung ứng!” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Từ trời, thiên sứ của Chúa Hằng Hữu lại gọi Áp-ra-ham lần thứ nhì, ");
INSERT INTO vieovcb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","mà bảo: “Ta đã lấy chính Ta mà thề—Chúa Hằng Hữu phán—vì con đã làm điều ấy, không tiếc sinh mạng đứa con, dù là con một, ");
INSERT INTO vieovcb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nên Ta sẽ ban phước hạnh cho con, gia tăng dòng dõi con đông như sao trên trời, như cát bãi biển, và hậu tự con sẽ chiếm lấy cổng thành quân địch. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tất cả các dân tộc trên thế giới sẽ nhờ hậu tự con mà được phước, vì con đã vâng lời Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Vậy, Áp-ra-ham trở lại cùng hai đầy tớ; tất cả lên đường quay về Bê-e-sê-ba. Áp-ra-ham cư trú tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sau đó, có người báo cho Áp-ra-ham: “Minh-ca đã sinh con trai cho Na-cô, em ông!” ");
INSERT INTO vieovcb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Con đầu lòng tên U-xơ, các con kế là Bu-xơ, Kê-mu-ên (tổ phụ của A-ram), ");
INSERT INTO vieovcb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kế-sết, Ha-xô, Phin-đát, Díp-láp, và Bê-tu-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Bê-tu-ên là cha của Rê-bê-ca). Tổng cộng được tám người con trai từ Minh-ca. ");
INSERT INTO vieovcb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Rê-u-ma, vợ lẽ của Na-cô, sinh Tê-ba, Ga-ham, Ta-hách, và Ma-a-ca. ");
INSERT INTO vieovcb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sa-ra qua đời hưởng thọ 127 tuổi, ");
INSERT INTO vieovcb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","bà qua đời tại Ki-ri-át A-ra-ba, tức Hếp-rôn, thuộc đất Ca-na-an. Áp-ra-ham để tang và than khóc vợ. ");
INSERT INTO vieovcb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Đứng bên thi hài Sa-ra, Áp-ra-ham nói với các trưởng lão người Hê-tít: ");
INSERT INTO vieovcb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Tôi chỉ là một kiều dân, tuy sống giữa các anh, nhưng không có đất ruộng. Xin các anh bán cho tôi một miếng đất làm nghĩa trang để an táng vợ tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hê-tít đáp với Áp-ra-ham: ");
INSERT INTO vieovcb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Vâng, chúng tôi vẫn coi ông là một bậc vương hầu của Đức Chúa Trời. Ông muốn chọn nghĩa trang nào tùy ý, chúng tôi không từ khước đâu!” ");
INSERT INTO vieovcb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Áp-ra-ham cúi đầu trước mặt họ và ");
INSERT INTO vieovcb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","nói: “Các anh đã có nhã ý như thế, xin làm ơn nói giúp Ép-rôn, con Xô-ha. ");
INSERT INTO vieovcb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Vui lòng bán cho tôi hang núi Mạc-bê-la ở cuối khu đất của anh ta. Tôi xin trả đúng thời giá để mua hang ấy làm nghĩa trang cho gia đình.” ");
INSERT INTO vieovcb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Đang ngồi giữa các người Hê-tít, Ép-rôn trả lời trước mặt dân trong thành phố: ");
INSERT INTO vieovcb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Thưa ông, tôi xin biếu ông cả hang lẫn khu đất. Đây, có mọi người làm chứng, tôi xin tặng để ông an táng xác bà.” ");
INSERT INTO vieovcb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Áp-ra-ham lại cúi đầu trước mặt dân bản xứ ");
INSERT INTO vieovcb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","và đáp lời Ép-rôn trong khi dân chúng lắng tai nghe: “Không dám, tôi chỉ xin mua và trả giá sòng phẳng. Xin anh vui lòng nhận tiền, tôi mới dám an táng vợ tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ép-rôn đáp cùng Áp-ra-ham: ");
INSERT INTO vieovcb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Miếng đất trị giá 400 miếng bạc, nhưng chỗ bà con quen biết có nghĩa gì đâu! Xin ông cứ an táng bà đi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Nghe chủ đất định giá, Áp-ra-ham cân 400 miếng bạc theo cân lượng thị trường và trả cho Ép-rôn trước sự chứng kiến của người Hê-tít. ");
INSERT INTO vieovcb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Vậy, Áp-ra-ham mua cánh đồng của Ép-rôn tại Mạc-bê-la, gần Mam-rê, gồm cánh đồng có hang đá và tất cả cây cối trong cánh đồng. ");
INSERT INTO vieovcb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Tài sản đó thuộc quyền sở hữu của Áp-ra-ham có người Hê-tít chứng kiến tại cổng thành phố. ");
INSERT INTO vieovcb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Áp-ra-ham an táng vợ, là Sa-rai, tại Ca-na-an, trong hang núi Mạc-bê-la, gần Mam-rê (còn gọi là Hếp-rôn). ");
INSERT INTO vieovcb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Như vậy, Áp-ra-ham sử dụng khu đất và hang núi mua từ người Hê-tít để làm nghĩa trang cho dòng họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Tuổi tác cao, Áp-ra-ham được Chúa Hằng Hữu ban phước lành dồi dào. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Áp-ra-ham bảo người quản gia, một nô bộc lớn tuổi nhất trong nhà: “Con hãy đặt tay con trên đùi ta. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ta muốn con nhân danh Chúa Hằng Hữu, Chủ Tể trời đất, mà thề rằng con sẽ không cưới người Ca-na-an làm vợ cho con ta là Y-sác, dù ta kiều ngụ trong xứ họ; ");
INSERT INTO vieovcb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","con sẽ đi về quê hương ta, cưới cho Y-sác, con ta, một người vợ trong vòng bà con ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Quản gia đáp: “Con chỉ ngại không có cô nào chịu bỏ quê hương để đi đến xứ này lấy chồng. Con có nên đưa Y-sác về quê vợ không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Áp-ra-ham quả quyết: “Tuyệt đối không! Con không bao giờ được đem Y-sác trở lại xứ ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Chúa Hằng Hữu, Chủ Tể trời đất, đã đem ta ra khỏi nhà cha ta, nơi chôn nhau cắt rốn, đã phán dạy ta, và thề với ta: ‘Ta sẽ cho dòng giống con đất này.’ Chúa sẽ sai thiên sứ Ngài đi trước, dẫn dắt con qua đó để cưới vợ cho Y-sác. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nếu cô dâu nhất định không theo con về đây, con sẽ khỏi mắc lời thề này. Dù sao, tuyệt đối không bao giờ được đem con ta về xứ ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Quản gia đặt tay lên đùi Áp-ra-ham và thề nguyện như lời chủ dặn. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Quản gia chọn mười con lạc đà chuyên chở đủ các loại bảo vật của chủ và lên đường. Đến thành phố của Na-cô, xứ Mê-sô-pô-ta-mi, ");
INSERT INTO vieovcb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","quản gia cho lạc đà dừng lại, và chúng quỳ xuống nghỉ chân bên giếng, đúng vào giờ phụ nữ trong thành ra múc nước. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Quản gia cầu nguyện: “Lạy Chúa Hằng Hữu, Đức Chúa Trời của Áp-ra-ham, chủ con: Xin cho cô ấy gặp con hôm nay, để chứng tỏ lòng nhân từ của Chúa đối với Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Con đang đứng đây, bên giếng, và các thiếu nữ trong thành sắp ra múc nước. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Khi con xin cô nào cho con uống nước, mà cô ấy đáp: ‘Ông cứ uống đi; tôi sẽ cho bầy lạc đà ông uống nữa,’ xin Chúa cho cô ấy đúng là người Chúa chỉ định cho Y-sác, đầy tớ Chúa. Nhờ đó, con mới biết rõ Chúa đã tỏ lòng nhân từ với chủ con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Quản gia chưa dứt lời cầu nguyện thì Rê-bê-ca vác bình ra đến giếng. Nàng là con của Bê-tu-ên, cháu bà Minh-ca. Bà này là vợ Na-cô, em của Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rê-bê-ca là một thiếu nữ tuyệt đẹp và trinh trắng. Nàng xuống giếng, múc đầy bình nước, đặt trên vai, rồi bước lên. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Quản gia chạy đến nói: “Xin cô vui lòng cho tôi uống ngụm nước trong bình.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nàng dịu dàng đáp: “Thưa vâng, mời ông tự nhiên.” Vừa nói, nàng vội vã đỡ bình nước xuống, bưng mời quản gia uống. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Quản gia uống xong, nàng sốt sắng: “Để tôi múc thêm nước cho lạc đà ông uống nữa, cho đến khi nào chúng uống đã khát.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nàng nhanh nhẹn trút bình vào máng nước rồi chạy xuống giếng, và múc thêm nước cho cả đàn lạc đà uống. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Quản gia đứng lặng nhìn Rê-bê-ca, suy nghiệm xem đây có phải là cách Chúa Hằng Hữu dẫn dắt mình hay không. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Khi đàn lạc đà uống nước xong, quản gia lấy ra một chiếc khoen vàng nặng khoảng năm chỉ và một đôi vòng vàng, mỗi chiếc khoảng năm lạng. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Và hỏi: “Cô là con ai? Nhà cô có chỗ cho tôi nghỉ tạm tối nay không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nàng đáp: “Tôi là con gái ông Bê-tu-ên, cháu cụ Minh-ca. Ông nội tôi là cụ Na-cô. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nhà tôi có nhiều rơm với thức ăn cho lạc đà, và cũng có phòng trọ cho khách nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Quản gia cảm kích và cúi đầu thờ phượng Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ông nói: “Cảm tạ Chúa Hằng Hữu là Đức Chúa Trời của Áp-ra-ham, chủ con. Cảm tạ Chúa vì lòng nhân từ, thành tín đối với người, khi Ngài dắt con đến đúng ngay gia đình bà con của Áp-ra-ham.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Trong khi đó, Rê-bê-ca chạy về nhà thuật mọi chuyện cho cả nhà mẹ mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Bấy giờ Rê-bê-ca có một người anh tên là La-ban, và người vội ra chỗ người quản gia, bên giếng nước. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","La-ban, anh nàng, thấy chiếc khoen với đôi vòng vàng trên tay em, và nghe em thuật chuyện, liền chạy ra giếng. Quản gia vẫn còn đứng đó với bầy lạc đà. La-ban nói: ");
INSERT INTO vieovcb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Ông là người được Chúa Hằng Hữu ban phước. Xin mời vào, sao đứng ngoài này vậy? Nhà tôi có sẵn phòng ngủ cho ông và chỗ cho lạc đà.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Quản gia theo La-ban về nhà. La-ban đem rơm lót chỗ lạc đà nằm, cho chúng ăn, và lấy nước cho mấy người đầy tớ rửa chân. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Thức ăn đã dọn ra rồi, nhưng quản gia còn lần lữa: “Tôi không dám ăn uống trước khi nói ra điều tôi cần phải thưa.” La-ban giục: “Ông cứ nói đi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Quản gia đáp: “Tôi là đầy tớ của Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Chúa Hằng Hữu ban phước dồi dào cho chủ tôi, làm cho người ngày càng cường thịnh. Chúa Hằng Hữu cho người nhiều gia súc, bạc vàng, tôi trai tớ gái, lạc đà, và lừa. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Bà Sa-ra, chủ tôi, sinh một con trai trong tuổi già nua, và cậu con trai được hưởng trọn gia tài. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Chủ tôi buộc tôi thề không được cưới cho cậu một người nào trong số các thiếu nữ Ca-na-an, là xứ chủ tôi trú ngụ, ");
INSERT INTO vieovcb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","nhưng phải về quê cha đất tổ của chủ, và tìm cho cậu một người vợ trong gia đình chủ tôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tôi có thưa lại chủ: ‘Nếu người thiếu nữ không chịu theo tôi về thì sao?’ ");
INSERT INTO vieovcb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Chủ tôi bảo: ‘Chúa Hằng Hữu sẽ sai thiên sứ đi với anh và giúp anh thành công. Anh sẽ tìm cho con ta một người vợ trong họ hàng ta, con cháu của cha ta. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Một khi anh đã đến thăm gia đình ta, nếu họ không chịu gả, anh khỏi mắc lời thề nguyện này.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Chiều nay, khi đến giếng nước, tôi đã cầu nguyện: ‘Lạy Chúa Hằng Hữu, Đức Chúa Trời của Áp-ra-ham, chủ con, nếu Chúa cho con thành công trong công tác này, xin Chúa hướng dẫn con: ");
INSERT INTO vieovcb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Trong khi con đứng bên giếng và các thiếu nữ ra múc nước, nếu con xin cô nào cho con uống nước trong bình, ");
INSERT INTO vieovcb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","mà cô ấy đáp: “Mời ông uống nước, và tôi cũng sẽ múc nước cho các lạc đà ông uống nữa”—thì cô ấy đúng là người vợ Chúa chọn cho con trai chủ con.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tôi chưa dứt lời thầm nguyện, tôi đã thấy cô Rê-bê-ca ra đến giếng và vác bình trên vai xuống giếng múc nước. Tôi hỏi cô: ‘Xin cô cho tôi uống nước với.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Cô lập tức hạ bình xuống khỏi vai và đon đả đáp: ‘Mời ông uống nước, và tôi cũng sẽ múc nước cho các lạc đà ông uống nữa.’ Cho tôi uống đã khát xong, cô lại múc nước cho các lạc đà tôi uống. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Tôi hỏi: ‘Cô con ai?’ Cô đáp: ‘Tôi là con của Bê-tu-ên, cháu hai cụ Na-cô và Minh-ca.’ Tôi đã đeo vòng và đôi xuyến cho cô. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tôi cúi đầu thờ phượng Chúa Hằng Hữu và ca ngợi Chân Thần của chủ tôi, Áp-ra-ham, vì Ngài đã hướng dẫn tôi đi đúng đường, để cưới con gái ông về cho con trai chủ tôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Vậy, để tỏ lòng ưu ái và trung thành với chủ tôi, xin quý vị cứ thẳng thắn trả lời được hay không, để tôi biết phải làm gì bây giờ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","La-ban và Bê-tu-ên đáp: “Việc này do Chúa Hằng Hữu xếp đặt, chúng tôi đâu dám nói được hay không. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kìa, Rê-bê-ca đứng trước mặt anh đó. Anh hãy rước nó về làm vợ cho con trai chủ anh, như Chúa Hằng Hữu đã phán bảo.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Quản gia của Áp-ra-ham nghe vậy, liền quỳ xuống trước mặt Chúa Hằng Hữu ");
INSERT INTO vieovcb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","và trao các lễ vật cho Rê-bê-ca là các nữ trang bằng vàng, bằng bạc, và các bộ y phục quý giá. Quản gia cũng tặng bà Bê-tu-ên và La-ban nhiều bảo vật. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Đoạn, họ đãi tiệc ăn mừng. Ê-li-ê-se và đoàn tùy tùng ở lại nhà Bê-tu-ên đêm ấy. Sáng hôm sau, họ dậy sớm. Ê-li-ê-se yêu cầu: “Xin cho phép tôi được quay về nhà chủ tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Bà Bê-tu-ên và La-ban (anh của Rê-bê-ca) ngăn cản: “Gì mà vội thế! Cứ để cho nó ở nhà với chúng tôi đã, độ mười ngày nữa hãy đi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Nhưng quản gia thưa: “Nhờ Chúa Hằng Hữu hướng dẫn tôi nên việc đã thành công, xin thông cảm và cho phép tôi trở về trình chủ tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Họ đáp: “Để chúng tôi hỏi ý nó xem sao.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Họ gọi Rê-bê-ca vào hỏi: “Con muốn đi theo ông này không?” Nàng đáp: “Thưa vâng, con muốn đi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Vậy, họ đưa Rê-bê-ca với bà vú nuôi của nàng lên đường, đi theo quản gia và các đầy tớ của Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","La-ban chúc phước cho Rê-bê-ca: “Cầu chúc cho dòng dõi của em sẽ đông đảo hàng nghìn hàng vạn! Nguyện dòng dõi em mạnh mẽ và chiếm được cổng thành quân địch.” ");
INSERT INTO vieovcb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rê-bê-ca và các nữ tì đứng dậy, cưỡi lạc đà và đi theo quản gia. Quản gia cùng Rê-bê-ca và các đầy tớ của Áp-ra-ham lên đường. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Y-sác đang ở Nê-ghép và từ giếng La-chai-roi đến đây; vì ông đang ở miền nam. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Một buổi tối, Y-sác ra ngoài đồng suy ngẫm, chợt thấy một đoàn lạc đà. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Vừa trông thấy Y-sác, Rê-bê-ca vội vã xuống lạc đà và ");
INSERT INTO vieovcb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","hỏi Ê-li-ê-se: “Có người đang vượt qua cánh đồng đi đón chúng ta, người đó là ai?” Ông đáp: “Con trai chủ tôi đó!” Rê-bê-ca lập tức lấy tấm voan phủ mặt mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Quản gia trình báo đầy đủ mọi việc cho Y-sác. ");
INSERT INTO vieovcb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Y-sác đưa Rê-bê-ca vào trại của mẹ mình và cưới nàng làm vợ. Y-sác yêu Rê-bê-ca và được an ủi phần nào sau những ngày chịu tang mẹ. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Áp-ra-ham tái hôn và cưới Kê-tu-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Bà sinh cho người sáu đứa con: Xim-ran, Giốc-chan, Mê-đan, Ma-đi-an, Dích-bác, và Su-ách. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Giốc-chan sinh Sê-ba và Đê-đan; dòng dõi của Đê-đan là họ A-chu-rim, họ Lê-tu-chim, và họ Lê-um-mim. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ma-đi-an sinh năm con trai: Ê-pha, Ê-phe, Hê-nóc, A-bi-đa, và Ên-đa. Đó là dòng dõi bà Kê-tu-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Áp-ra-ham cho Y-sác hưởng trọn gia tài. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ông cũng cho các con thứ mỗi người một số phẩm vật và bảo họ đi qua đông phương, ở cách xa Y-sác. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Áp-ra-ham hưởng thọ 175 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Áp-ra-ham trút hơi thở cuối cùng và qua đời khi tuổi đã cao, được mãn nguyện trong cuộc sống; và ông trở về với tổ phụ mình ");
INSERT INTO vieovcb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Y-sác và Ích-ma-ên, hai con trai người, an táng người trong hang Mạc-bê-la, gần Mam-rê, thuộc cánh đồng của Ép-rôn, con trai Xô-ha, người Hê-tít ");
INSERT INTO vieovcb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Đây là cánh đồng mà Áp-ra-ham đã mua của Ép-rôn, con trai Xô-ha, người Hê-tít. Đây cũng là mộ địa của Sa-ra, vợ Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Sau khi Áp-ra-ham qua đời, Đức Chúa Trời ban phước dồi dào cho Y-sác; lúc ấy Y-sác đã dời xuống La-chai-roi ở miền nam. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Đây là dòng dõi của Ích-ma-ên, con trai Áp-ra-ham và A-ga, người Ai Cập, nữ tì của Sa-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Các con trai của Ích-ma-ên là: Trưởng nam Nê-ba-giốt, Kê-đa, Át-bê-ên, Mi-bô-sam, ");
INSERT INTO vieovcb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mích-ma, Đu-ma, Ma-sa, ");
INSERT INTO vieovcb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ha-đa, Thê-ma, Giê-thu, Na-phích, và Kết-ma. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Đó là mười hai con trai của Ích-ma-ên; họ được đặt tên theo địa điểm định cư và đóng trại. Đó là mười hai tộc trưởng của dân tộc họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ích-ma-ên hưởng thọ 137 tuổi, qua đời, và về với tổ phụ. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Dòng dõi của Ích-ma-ên định cư ở trước mặt anh em họ, từ Ha-vi-la đến Su-rơ đối ngang Ai Cập, trên đường đi A-sy-ri. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Đây là dòng dõi của Y-sác, con trai Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Khi được 40 tuổi, Y-sác cưới Rê-bê-ca, con gái của Bê-tu-ên, em của La-ban, người A-ram ở xứ Pha-đan A-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Y-sác cầu thay cho vợ mình đang son sẻ, xin Chúa Hằng Hữu cho nàng sinh con. Chúa Hằng Hữu nhậm lời nên Rê-bê-ca thụ thai. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Dường như các bào thai đánh nhau trong bụng, đến nỗi nàng than rằng: “Tôi chịu không nổi.” Nàng cầu hỏi Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Chúa Hằng Hữu đáp: “Hai con trai trong lòng ngươi sẽ trở thành hai nước chống đối nhau. Nước này mạnh hơn nước kia; đứa lớn sẽ phục dịch đứa nhỏ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Quả nhiên, Rê-bê-ca sinh đôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Đứa đầu có nhiều lông đỏ hung hung, nên được đặt tên là Ê-sau. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Đứa sau nắm gót chân anh nó, Ê-sau, lúc lọt lòng, nên có tên là Gia-cốp. Năm ấy, Y-sác đã sáu mươi tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Hai đứa trẻ lớn lên. Ê-sau là một thợ săn tài giỏi, thường xông pha nơi đồng nội và rừng xanh; còn Gia-cốp thích sống trầm lặng trong nhà, quanh quẩn bên mẹ. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Vì thế, Ê-sau được Y-sác cưng, còn Gia-cốp được mẹ yêu chiều. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Một hôm, Ê-sau đi săn về, mệt lả, và thấy Gia-cốp đang nấu nồi xúp thơm ngào ngạt. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ê-sau năn nỉ Gia-cốp: “Chao ôi, đói quá! Em cho anh ăn món súp đo đỏ đó với!” (Do đó mà Ê-sau có biệt danh là Ê-đôm, nghĩa là “đỏ.”) ");
INSERT INTO vieovcb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Gia-cốp đề nghị: “Được rồi, anh cứ trao quyền trưởng nam cho tôi, tôi cho anh ăn súp!” ");
INSERT INTO vieovcb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ê-sau đáp: “Khi người ta đói gần chết, người ta còn giữ quyền trưởng nam làm gì.” ");
INSERT INTO vieovcb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Gia-cốp nắm ngay cơ hội: “Vậy anh thề đi.” Ê-Sau bèn thề và bán quyền trưởng nam cho em mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Gia-cốp liền cho Ê-sau ăn bánh, đậu đỏ, và xúp. Ăn xong, Ê-sau đứng dậy ra đi, không đếm xỉa gì đến quyền trưởng nam cả. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Trong xứ gặp nạn đói lớn, giống như trận đói thời Áp-ra-ham. Vì thế, Y-sác dời xuống Ghê-ra, một thành phố thuộc lãnh thổ của Vua A-bi-mê-léc, nước Phi-li-tin. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Chúa Hằng Hữu hiện ra và phán cùng Y-sác: “Con đừng xuống Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Con nên vâng lời Ta mà ở lại trong xứ này. Nếu con cứ ở lại đây, Ta sẽ ở cùng con và ban phước lành cho con, vì Ta sẽ cho con và dòng dõi con đất nước này. Ta sẽ thực hiện lời thề hứa với cha con là Áp-ra-ham. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ta sẽ cho dòng dõi con gia tăng nhiều như sao trên trời, và Ta sẽ cho dòng dõi con tất cả đất đai này. Nhờ dòng dõi con mà tất cả các dân tộc trên thế giới đều được phước. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ta sẽ thực hiện điều đó, vì Áp-ra-ham đã vâng giữ điều răn và luật lệ Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Vậy, Y-sác ở lại Ghê-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Khi người dân hỏi thăm Rê-bê-ca, Y-sác giới thiệu: “Đây là em gái tôi.” Y-sác sợ rằng nếu nói “nàng là vợ tôi” thì họ sẽ giết ông đi để cướp nàng, bởi vì Rê-bê-ca là một người đàn bà tuyệt sắc. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sau một thời gian dài, A-bi-mê-léc, vua nước Phi-li-tin, nhìn qua cửa sổ và chợt thấy Y-sác hôn Rê-bê-ca. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","A-bi-mê-léc lập tức triệu Y-sác vào cung và quở trách: “Nàng quả là vợ ngươi. Sao ngươi lại bảo là em gái?” Y-sác đáp: “Vì tôi sợ người ta sẽ giết tôi đi để cướp nàng.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","A-bi-mê-léc trách: “Sao ngươi tệ vậy! Ngươi nói thế lỡ có người nào tưởng nàng chưa có chồng, đem lòng yêu say đắm mà không được đáp ứng, rồi cuồng dại làm liều thì cả dân tộc ta sẽ bị họa lây.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Vua bèn ra thông cáo: “Ai làm hại vợ chồng Y-sác sẽ bị xử tử.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Y-sác làm ruộng và thu hoạch được gấp trăm lần trong năm đó. Chúa Hằng Hữu ban phước cho Y-sác, ");
INSERT INTO vieovcb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","nên người trở nên giàu có; tài sản ngày càng gia tăng nhanh chóng. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Y-sác có nhiều đầy tớ và rất nhiều bầy chiên, bầy dê, và bầy bò đông đảo. Người Phi-li-tin ganh tức, ");
INSERT INTO vieovcb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","nên tìm cách phá hoại; họ lấy đất lấp hết các giếng của Y-sác mà các đầy tớ của cha người đã đào. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Chính Vua A-bi-mê-léc cũng trở mặt và đuổi Y-sác ra khỏi nước Phi-li-tin: “Ngươi phải rời đất nước ta, vì ngươi giàu mạnh hơn dân ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Vậy, Y-sác ra đi và di cư đến thung lũng Ghê-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Y-sác đào lại các giếng đã đào từ thời Áp-ra-ham, vì sau khi Áp-ra-ham qua đời, người Phi-li-tin đã lấp các giếng ấy. Y-sác giữ nguyên tên các giếng này đúng như cha mình đã đặt. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Đến khi các đầy tớ của Y-sác đào được một cái giếng phun nước giữa thung lũng, ");
INSERT INTO vieovcb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","bọn chăn chiên ở Ghê-ra đến tranh giành: “Giếng này là của bọn tao.” Y-sác đặt tên giếng là “Giếng Tranh Giành.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Các đầy tớ người đào được một giếng khác, bọn chăn chiên ấy cũng giành nữa, nên Y-sác đặt tên là “Giếng Thù Hận.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Y-sác dời qua một nơi khác và đào được một giếng mới, không bị ai tranh giành, nên Y-sác đặt tên là “Giếng Khoảng Khoát,” vì người nói: “Chúa đã cho chúng ta ở nơi rộng rãi; chúng ta sẽ thịnh vượng trong xứ này.” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Từ đó, Y-sác lên Bê-e-sê-ba. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Một đêm, Chúa Hằng Hữu xuất hiện và phán cùng Y-sác: “Ta là Đức Chúa Trời của Áp-ra-ham, cha con. Con đừng sợ, vì Ta ở với con và ban phước lành cho con. Ta sẽ cho dòng dõi con gia tăng đông đảo vì cớ Áp-ra-ham, đầy tớ Ta!” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Vậy, Y-sác xây một bàn thờ và thờ phượng Chúa Hằng Hữu. Ông định cư tại đó và các đầy tớ của Y-sác lại bắt đầu đào giếng. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Một hôm, Vua A-bi-mê-léc cùng với quân sư là A-hu-sát, và Phi-côn, tướng chỉ huy của ông, từ Ghê-ra đến thăm Y-sác. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Y-sác trách: “Quý ngài đã ganh ghét tôi và đuổi tôi, mà bây giờ ngài còn đến đây làm chi?” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Họ đáp: “Chúng tôi nhìn nhận rằng Chúa Hằng Hữu phù hộ ông, nên chúng tôi bàn định lập kết ước với ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Xin ông cam kết đừng bao giờ làm hại chúng tôi, như chúng tôi cũng đã không làm hại ông; trái lại, chúng tôi còn hậu đãi ông và để ông ra đi bình an. Ông là người được Chúa Hằng Hữu ban phước lành!” ");
INSERT INTO vieovcb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Y-sác chuẩn bị một bữa tiệc linh đình đãi khách, họ cùng ăn uống với nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ngày hôm sau, họ dậy sớm, long trọng thề nguyện, và lập hiệp ước bất xâm phạm. Sau đó, Y-sác tiễn họ ra về bình an. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ngay hôm ấy, các đầy tớ báo cho Y-sác rằng họ đã đào được giếng nước tốt. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Y-sác đặt tên giếng là “Giếng Thề Nguyện,” và thành phố xây tại đó được gọi là Bê-e-sê-ba (nghĩa là Giếng Thề Nguyện) cho đến ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ê-sau lập gia đình khi bốn mươi tuổi; ông cưới hai vợ: Giu-đi, con gái của Bê-ê-ri, và Bách-mát, con gái của Ê-lôn; cả hai đều là người họ Hê-tít. ");
INSERT INTO vieovcb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Các nàng dâu này gây lắm nỗi đắng cay cho ông bà Y-sác. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Y-sác tuổi cao, mắt lòa và không thấy được nữa, ông gọi Ê-sau, con trưởng nam, và nói: “Ê-sau, con!” “Dạ!” Ê-sau trả lời. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Y-sác bảo: “Cha đã già cả rồi, không còn sống được bao nhiêu ngày nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Con hãy lấy cung tên, vào rừng săn bắn, đem thịt về, nấu nướng món ăn mà cha thích nhất, ");
INSERT INTO vieovcb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","và dọn ra đây cho cha ăn, để cha chúc phước lành cho con trước khi qua đời.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Khi Y-sác và Ê-sau nói chuyện, Rê-bê-ca nghe được. Sau đó, Ê-sau đi săn thú rừng. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rê-bê-ca gọi Gia-cốp và bảo rằng: “Mẹ nghe cha con chuyện trò với Ê-sau và bảo anh con đi săn thú rừng, ");
INSERT INTO vieovcb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","rồi về nấu dọn cho cha một món ăn mà cha ưa nhất, để trước khi qua đời, cha chúc phước cho trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Con hãy nghe mẹ dặn đây. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Con hãy ra chuồng dê, bắt cho mẹ hai con dê con, mẹ sẽ nấu một món tuyệt ngon mà cha thích, ");
INSERT INTO vieovcb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","và con đem mời cha. Ăn xong, cha sẽ chúc phước lành cho con trước khi cha qua đời.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Gia-cốp đáp: “Thưa mẹ, anh con Ê-sau, có lông, còn con không có lông. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nếu cha sờ vào con, cha sẽ biết ngay là con lừa gạt; chúc phước đâu chẳng thấy, cha sẽ nguyền rủa cho thì có!” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nhưng mẹ người trấn an: “Để mẹ chịu nguyền rủa cho, con trai! Cứ nghe lời mẹ. Đi ra và bắt dê về cho mẹ!” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Gia-cốp nghe lời mẹ, ra chuồng bắt hai dê con để mẹ làm thịt. Rê-bê-ca nấu nướng một món ngon lành, đúng như sở thích của Y-sác. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rồi bà lấy áo tốt nhất của Ê-sau để tại nhà, bảo Gia-cốp mặc vào, ");
INSERT INTO vieovcb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","lại dùng da dê con bọc hai cánh tay và cổ của Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Xong đâu đó, bà giao vào tay Gia-cốp món ăn ngon và bánh. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Gia-cốp đem vào cho cha và nói rằng: “Thưa cha!” Y-sác hỏi: “Cha đây, con là đứa nào đó?” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Gia-cốp thưa: “Con là Ê-sau, con đầu lòng của cha. Con đã làm như cha dặn bảo. Đây, món thịt rừng cha thích. Mời cha ngồi dậy và ăn, rồi cha chúc phước lành cho con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Y-sác hỏi Gia-cốp: “Sao con đi săn mau quá vậy?” “Thưa cha, nhờ Đức Chúa Trời Hằng Hữu của cha giúp con gặp ngay con mồi đó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Y-sác nói với Gia-cốp: “Con lại gần đây, để cha sờ xem có phải Ê-sau, con của cha, thật không.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Gia-cốp lại gần cho cha sờ tay mình. Y-sác lẩm bẩm: “Giọng nói thì của Gia-cốp, mà tay lại của Ê-sau.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Y-sác không còn cách nào phân biệt nữa, vì rõ ràng hai tay đều có nhiều lông giống như Ê-sau, nên ông chúc phước lành cho con. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Y-sác thử lại lần nữa: “Con có phải thật là Ê-sau không?” Gia-cốp đáp: “Dạ thưa cha, chính con đây.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Y-sác bảo: “Vậy con hãy đem đĩa thịt rừng đến đây cho cha ăn, để cha chúc phước cho con.” Gia-cốp bưng đĩa thịt đến mời cha và rót rượu cho cha uống. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ăn xong, Y-sác bảo: “Con lại đây hôn cha đi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Gia-cốp đến hôn cha. Y-sác ngửi mùi thơm của áo Ê-sau và long trọng chúc phước: “Mùi hương của con trai ta chẳng khác nào hương hoa đồng nội mà Chúa Hằng Hữu ban phước! ");
INSERT INTO vieovcb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Cầu xin Đức Chúa Trời ban cho con nhiều mưa móc, cho con được mùa và cất được nhiều rượu mới. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nguyện nhiều dân tộc sẽ là đầy tớ con, nguyện họ sẽ cúi đầu trước mặt con. Nguyện con cai trị các anh em con, tất cả bà con quyến thuộc đều phục dịch con. Những ai nguyền rủa con sẽ bị nguyền rủa, và những ai cầu phước cho con sẽ được ban phước.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Y-sác vừa chúc phước xong, và Gia-cốp mới ra khỏi phòng, thì Ê-sau đi săn trở về. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ê-sau cũng nấu món ăn ngon cha thích nhất và dọn lên mời cha. Ê-sau thưa: “Cha ơi, con đem thịt rừng về đây. Mời cha ngồi dậy, dùng đĩa thịt, và cha sẽ chúc phước cho con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Y-sác hỏi: “Con là đứa nào?” Ê-sau đáp: “Con là Ê-sau, con trưởng nam của cha.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Y-sác run rẩy dữ dội hỏi: “Thế thì đứa nào mới dọn thịt rừng cho cha ăn đó? Cha đã ăn rồi và cũng chúc phước lành cho nó rồi, làm sao đổi lại được?” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ê-sau bật khóc: “Cha ơi, cha cứ chúc phước cho con với.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Y-sác đáp: “Em con đã vào đây gạt cha nên đã cướp được tất cả các lời chúc lành cha dành cho con rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ê-sau cay đắng nói: “Tên nó là Gia-cốp thật chẳng sai vì nó đã lừa con hai lần. Lần đầu cướp quyền trưởng nam của con, bây giờ, nó lại đánh cắp phước lành của con nữa. Cha ơi, cha còn dành cho con ít phước lành nào không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Y-sác đáp Ê-sau: “Cha đã lập nó làm chủ con. Cha đã cho nó dùng bà con quyến thuộc làm đầy tớ. Cha đã cho nó được mùa màng dư dật và rượu nho dồi dào—còn chi nữa đâu con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ê-sau năn nỉ: “Cha không còn để dành cho con một phước lành nào sao? Cha ơi, xin cha cứ cho con một ít phước lành.” Ê-sau quỵ xuống và khóc tức tưởi. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Cuối cùng, cha người là Y-sác nói: “Con sẽ ở một nơi cằn cỗi, khô hạn, và thiếu sương móc từ trời. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Con phải dùng gươm chiến đấu để sống còn, và con phải phục dịch em con một thời gian. Nhưng về sau con sẽ thoát ách nó và được tự do.” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Từ đó, Ê-sau ghen ghét Gia-cốp, vì Gia-cốp đã lập mưu cướp phước lành của mình. Ê-sau tự nhủ: “Cha ta gần qua đời rồi; chôn cất cha xong, ta sẽ giết Gia-cốp!” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rê-bê-ca biết được ý đồ đó của Ê-sau. Bà sai gọi Gia-cốp đến, tiết lộ âm mưu của Ê-sau, và bảo: ");
INSERT INTO vieovcb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","“Bây giờ, con nghe lời mẹ và trốn qua nhà La-ban, cậu con, ở Ha-ran. ");
INSERT INTO vieovcb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Con cứ ở đó cho đến khi nào anh con nguôi giận ");
INSERT INTO vieovcb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","và quên đi việc con đã làm. Lúc đó, mẹ sẽ tin cho con biết mà trở về nhà. Không lẽ mẹ phải mất cả hai đứa con trong một ngày sao?” ");
INSERT INTO vieovcb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rồi Rê-bê-ca nói với Y-sác: “Tôi đã chán ngấy mấy đứa con dâu người Hê-tít! Nếu Gia-cốp cưới một người vợ ngang ngược như thế, tôi thà chết còn hơn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Y-sác gọi Gia-cốp vào, chúc phước lành, và căn dặn: “Con đừng cưới vợ người Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Trái lại, con hãy lên đường, về xứ Pha-đan A-ram, đến nhà Bê-tu-ên, ông ngoại con, và cưới một cô con gái của cậu La-ban làm vợ. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Cầu Đức Chúa Trời Toàn Năng ban phước cho con, cho con đông con, cho dòng dõi con sinh sôi nẩy nở, và trở thành một nước lớn gồm nhiều dân tộc. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Cầu Chúa cho con và dòng dõi con hưởng phước lành của Áp-ra-ham, cho con làm chủ miền đất con đang kiều ngụ mà Đức Chúa Trời đã ban cho ông nội con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Vậy, Y-sác sai Gia-cốp đi qua xứ Pha-đan A-ram và đến nhà La-ban, cậu của Gia-cốp, con trai của Bê-tu-ên, người A-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ê-sau thấy Y-sác chúc phước cho Gia-cốp và bảo qua xứ Pha-đan A-ram tìm vợ; trong lúc chúc phước, người dặn Gia-cốp rằng đừng cưới vợ trong bọn con gái Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ê-sau thấy Gia-cốp vâng lời cha mẹ qua xứ Pha-đan A-ram, ");
INSERT INTO vieovcb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ê-sau biết rằng Y-sác không ưa con gái Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ê-sau đi đến Ích-ma-ên, bác mình, và cưới thêm cô vợ thứ ba. Nàng tên là Ma-ha-lát, con Ích-ma-ên, cháu nội Áp-ra-ham, em của Nê-ba-giốt. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Gia-cốp từ giã Bê-e-sê-ba và đi qua xứ Pha-đan Ha-ran. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ông đến một chỗ kia dừng chân và nghỉ đêm tại đó vì mặt trời đã lặn. Gia-cốp chọn một tảng đá gối đầu nằm ngủ. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Gia-cốp nằm mộng thấy một chiếc thang bắc liền từ đất lên trời, và các thiên sứ của Chúa lên xuống trên thang ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Chúa Hằng Hữu đứng trên đầu thang và gọi Gia-cốp: “Ta là Đấng Tự Hữu Hằng Hữu, Chân Thần của ông nội con là Áp-ra-ham và của cha con là Y-sác. Đất con đang nằm đây thuộc về con. Ta ban miền đất này cho con và cho dòng dõi con. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dòng dõi con sẽ đông như cát bụi trên mặt đất. Con sẽ mở rộng biên cương ra bốn hướng đông, tây, nam, bắc. Các dân tộc trên thế giới sẽ nhờ con và hậu tự con mà được phước. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Này, Ta ở cùng con luôn, con đi đâu, Ta sẽ theo gìn giữ đó và đem con về xứ này, vì Ta không bao giờ bỏ con cho đến khi Ta hoàn thành lời Ta đã hứa với con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Gia-cốp thức giấc và tự nhủ: “Thật Chúa Hằng Hữu ngự tại đây mà ta không biết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ông sợ hãi nói: “Nơi này thật đáng kính sợ. Đây chính là Nhà của Đức Chúa Trời, là cửa dẫn lên trời!” ");
INSERT INTO vieovcb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Gia-cốp dậy sớm, lấy tảng đá gối đầu đêm qua dựng lên làm trụ kỷ niệm, đổ dầu ô-liu trên đỉnh, ");
INSERT INTO vieovcb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","và đặt tên địa điểm này là Bê-tên (Nhà Chân Thần), thay tên cũ là Lu-xơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Gia-cốp khấn nguyện: “Nếu Đức Chúa Trời ở với con, gìn giữ con trên đường con đang đi, cho con đủ ăn đủ mặc, ");
INSERT INTO vieovcb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","và đưa con trở về nhà cha con bình an vô sự, con sẽ chọn Chúa Hằng Hữu làm Đức Chúa Trời của con. ");
INSERT INTO vieovcb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Còn tảng đá kỷ niệm này sẽ trở thành nơi thờ phượng Đức Chúa Trời, và con sẽ dâng lại cho Đức Chúa Trời một phần mười mọi vật Chúa ban cho.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Gia-cốp tiếp tục đi đường, cuối cùng đến một xứ ở phương đông. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ông thấy phía xa có ba bầy chiên đang nằm bên giếng, giữa một cánh đồng, là nơi chiên đến uống nước. Tuy nhiên, trên miệng giếng có một tảng đá lớn đậy lại. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Vì theo lệ thường, phải đợi cho các bầy súc vật họp lại đông đủ, người ta mới lăn tảng đá đi. Sau khi chúng uống xong, họ lại đặt tảng đá lên miệng giếng như cũ. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Gia-cốp đến chào các bác chăn chiên và hỏi họ từ đâu đến đây. Họ đáp: “Từ Pha-đan Ha-ran.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Gia-cốp hỏi: “Các bác có biết ông La-ban, cháu cụ Na-cô không?” Họ đáp: “Biết chứ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Gia-cốp tiếp: “Ông ấy có mạnh khỏe không?” Họ đáp: “Ông ta vẫn khỏe mạnh. Kìa, cô Ra-chên, con ông ấy, đang dẫn bầy chiên đến kia kìa!” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Gia-cốp gợi ý: “Trời hãy còn sớm, chưa đến giờ tập họp các bầy gia súc để đem về. Sao các bác không cho chúng uống nước và thả chúng đi ăn trở lại?” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Họ đáp: “Theo lệ, phải đợi các bầy súc vật tề tựu đông đủ mới lăn tảng đá đi và cho chúng uống nước, không xé lẻ được.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Lúc ấy, Ra-chên đã dẫn bầy chiên của cha đến giếng, vì cô cũng là người chăn chiên. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Biết Ra-chên là em cô cậu với mình và bầy chiên này cũng của cậu mình, nên Gia-cốp một mình đến lăn tảng đá trên miệng giếng, và múc nước cho bầy chiên của cậu mình uống. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Gia-cốp hôn Ra-chên và khóc òa lên. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Gia-cốp cho nàng biết mình là bà con, cháu gọi La-ban bằng cậu ruột. Ra-chên nghe xong, nàng vội vã chạy về báo tin cho cha. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","La-ban được tin Gia-cốp, cháu mình, đã đến, liền chạy ra đón tiếp; ông ôm chầm lấy Gia-cốp mà hôn và đưa về nhà. Gia-cốp kẻ lại mọi diễn biến cho La-ban. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","La-ban đáp: “Cháu đúng là cốt nhục của cậu.” Gia-cốp ở chơi nhà cậu một tháng và giúp việc cho cậu. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Một hôm, La-ban bảo Gia-cốp: “Không lẽ vì tình bà con ruột thịt mà cháu làm việc không công sao? Cháu muốn cậu trả lương bao nhiêu?” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","La-ban có hai con gái: Lê-a là chị và Ra-chên là em. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lê-a, cô chị, mắt bị yếu; còn cô em, Ra-chên, có nhan sắc. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Gia-cốp yêu Ra-chên nên đề nghị với cậu: “Cháu xin giúp việc cậu bảy năm nếu cậu gả cho cháu Ra-chên, con gái út của cậu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","La-ban chấp thuận ngay: “Thà cậu gả nó cho cháu, còn hơn gả cho người ngoài.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Vậy, Gia-cốp phục dịch cậu suốt bảy năm để được cưới Ra-chên; nhưng vì yêu say đắm, nên Gia-cốp coi bảy năm chỉ bằng đôi ba ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hết bảy năm, Gia-cốp nhắc La-ban: “Cháu đã giữ đúng lời cam kết, xin cậu cho cháu làm lễ cưới.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","La-ban bèn đãi tiệc lớn, mời tất cả những người trong cộng đồng đến dự lễ cưới. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tuy nhiên, trong đêm ấy, La-ban đánh tráo Lê-a thay cho Ra-chên. Trong đêm tối, Gia-cốp không nhận ra, bèn ngủ với Lê-a. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(La-ban cũng cho nữ tì Xinh-ba theo hầu Lê-a.) ");
INSERT INTO vieovcb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sáng hôm sau, Gia-cốp thức dậy mới biết sự thật; đó là Lê-a! Gia-cốp nổi giận và trách La-ban: “Sao cậu gạt cháu chi vậy? Cháu phục dịch cậu suốt bảy năm tròn chỉ vì Ra-chên. Sao cậu lật lọng thế?” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","La-ban giả lả: “Phong tục đây là thế! Không được gả em trước chị sau. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Cháu cứ đợi qua tuần trăng mật với Lê-a, cậu sẽ gả luôn Ra-chên cho, với điều kiện cháu giúp việc thêm cho cậu bảy năm nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Gia-cốp đồng ý. Sau tuần ấy, La-ban gả luôn Ra-chên cho Gia-cốp ");
INSERT INTO vieovcb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","và cho nữ tì Bi-la theo hầu Ra-chên. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Gia-cốp ăn ở với Ra-chên và yêu Ra-chên hơn Lê-a. Đúng theo giao kèo, Gia-cốp phục dịch La-ban thêm bảy năm nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Chúa Hằng Hữu thấy Lê-a bị ghét, Ngài bèn cho nàng sinh sản; còn Ra-chên phải son sẻ. ");
INSERT INTO vieovcb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lê-a thụ thai, sinh con trai đầu lòng, đặt tên là Ru-bên, và giải thích: “Chúa Hằng Hữu đã lưu ý nỗi khó khăn của tôi. Bây giờ, chồng tôi sẽ yêu tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lê-a thụ thai nữa, sinh con trai thứ nhì, đặt tên là Si-mê-ôn và giải thích: “Chúa Hằng Hữu đã nghe rằng tôi bị ghét bỏ, nên ban nó cho tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lê-a thụ thai lần thứ ba, sinh con trai, đặt tên là Lê-vi, và giải thích: “Bây giờ, chồng tôi sẽ khắng khít với tôi, vì tôi sinh được ba con trai cho người.” ");
INSERT INTO vieovcb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lần thứ tư, Lê-a thụ thai, sinh con trai, đặt tên là Giu-đa, và giải thích: “Bây giờ, tôi ca ngợi Chúa Hằng Hữu!” Sau đó, nàng thôi sinh nở một thời gian. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ra-chên thấy mình son sẻ, nên ganh tức với chị, lại trách móc Gia-cốp: “Anh phải cho tôi có con. Bằng không, tôi sẽ chết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Gia-cốp nổi giận và quát: “Anh có thay quyền Đức Chúa Trời được đâu. Chỉ một mình Ngài có quyền cho em có con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ra-chên đề nghị: “Anh cứ ngủ với nữ tì của em là Bi-la; nếu nó có con, con trẻ đó là con của em đó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Vậy, Ra-chên giao nữ tì Bi-la cho Gia-cốp làm hầu thiếp, và ông đi lại với nàng. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Gia-cốp ngủ với Bi-la. Nàng thụ thai và sinh một con trai. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ra-chên đặt tên nó là Đan và giải thích: “Đức Chúa Trời đã minh oan cho tôi, nghe lời tôi van nài, và ban cho tôi một con trai.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bi-la thụ thai lần thứ nhì và sinh một con trai nữa cho Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ra-chên đặt tên nó là Nép-ta-li và giải thích: “Tôi đã tranh đấu với chị tôi và thắng cuộc!” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Trong khi đó, Lê-a thấy mình thôi sinh nở; nàng liền giao nữ tì Xinh-ba để làm vợ cho chồng mình Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Xinh-ba thụ thai và sinh một con trai cho Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lê-a đặt tên nó là Gát, vì nàng nói: “Tôi thật may mắn!” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Xinh-ba lại thụ thai và sinh con trai thứ nhì cho Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lê-a đặt tên nó là A-se và giải thích: “Tôi vui sướng vô cùng! Các phụ nữ sẽ nhìn nhận tôi là người có phước.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Một hôm, giữa mùa gặt lúa mì, Ru-bên ra đồng ruộng, hái được mấy trái táo rừng, và đem về biếu mẹ. Ra-chên bèn xin Lê-a một vài trái. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lê-a đáp: “Em cướp chồng tôi chưa đủ hay sao mà còn muốn cướp táo của con tôi?” Ra-chên nói: “Thôi được, em lấy trái táo rừng để anh ấy ngủ với chị đêm nay.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Đến chiều tối, Gia-cốp từ ngoài đồng về nhà, Lê-a nói: “Anh phải ngủ với em đêm nay, vì em đã lấy táo rừng của con em mà trao đổi đó.” Gia-cốp cũng chấp thuận. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Đức Chúa Trời nhậm lời cầu nguyện của Lê-a và cho nàng thụ thai trở lại. Nàng sinh con trai thứ năm cho Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nàng đặt tên là Y-sa-ca (nghĩa là tiền công), và giải thích rằng: “Đức Chúa Trời đã trả công lại cho tôi vì tôi đã giao nữ tì tôi cho chồng.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lê-a thụ thai nữa, sinh con trai thứ sáu cho Gia-cốp, đặt tên là Sa-bu-luân (nghĩa là tặng phẩm), ");
INSERT INTO vieovcb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","và giải thích: “Đức Chúa Trời đã ban cho tôi nhiều tặng phẩm để đem về cho chồng tôi. Bây giờ, chàng sẽ quý trọng tôi vì tôi đã sinh cho chàng sáu con trai rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sau hết, Lê-a sinh được một con gái và đặt tên là Đi-na. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Đức Chúa Trời nhớ lại Ra-chên, nhậm lời cầu nguyện của nàng, và cho nàng sinh nở. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nàng thụ thai và sinh một con trai, nên nàng ca ngợi Chúa: “Đức Chúa Trời đã dẹp điều sỉ nhục của tôi rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nàng đặt tên con là Giô-sép và thầm nguyện: “Xin Chúa Hằng Hữu cho con thêm một đứa nữa!” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Sau khi Ra-chên sinh Giô-sép, Gia-cốp yêu cầu La-ban: “Xin cậu cho cháu về quê. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Cháu đã tận tình phục vụ cậu đúng theo giao kèo, xin cậu cho cháu đem vợ con lên đường.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","La-ban đáp: “Cháu đừng bỏ cậu. Cậu nhận định rằng bao nhiêu phước lành cậu được hưởng bấy lâu nay đều là do Chúa Hằng Hữu ban phước cho cháu cả. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Cháu muốn cậu tăng lương bao nhiêu, cậu cũng sẵn lòng!” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Gia-cốp đáp: “Cậu đã biết cháu làm việc trung tín và tận tâm phục vụ cậu bao nhiêu năm nay. Các bầy gia súc của cậu gia tăng nhanh chóng. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Trước ngày cháu đến, cậu chỉ có ít tài sản; bây giờ, súc vật cậu gia tăng gấp bội. Chúa Hằng Hữu đã ban phước lành dồi dào cho cậu qua mọi việc cháu làm. Còn phần cháu thì sao? Bao giờ cháu mới có tài sản để lo cho gia đình?” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","La-ban lại hỏi: “Cháu đòi lương hướng bao nhiêu?” Gia-cốp đáp: “Nếu cậu chấp thuận điều này, cháu sẽ trở lại làm việc cho cậu. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hôm nay, cậu để cháu đi kiểm soát các bầy gia súc của cậu. Những con chiên, con dê nào có vằn, có đốm, hoặc lông đen thì cậu để riêng cho cháu, kể là tiền công. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Từ nay về sau, nếu cậu bắt gặp con chiên, con dê nào lông trắng trong bầy gia súc của cháu, cậu cứ kể là con ăn cắp.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","La-ban đáp: “Cháu đã nói thế, cậu cũng bằng lòng.” ");
INSERT INTO vieovcb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ngay hôm ấy, La-ban chọn riêng tất cả dê và chiên lông đen, có vằn, hoặc có đốm—kể cả các con có đốm trắng—chia thành từng bầy và giao cho các con trai mình chăn, ");
INSERT INTO vieovcb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ông bảo chúng lùa tất cả đi, cách xa địa điểm La-ban và Gia-cốp đang ở đến ba ngày đường. Gia-cốp chăn bầy gia súc còn lại của La-ban. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Gia-cốp lấy những cành bạch dương, cành bồ đào, và cành ngô đồng mới nứt, lột bớt vỏ từng đường dài ");
INSERT INTO vieovcb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","và đặt cạnh các máng nước cho dê, chiên trông thấy mỗi khi chúng đến uống nước và giao phối nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Sau đó, chúng đẻ con, con nào cũng có vằn hoặc có đốm. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Gia-cốp liền bắt các con này để riêng cho mình. Gia-cốp cũng đem riêng các chiên cái của La-ban ra, cho chúng giao phối với chiên đực đen của mình. Thế là Gia-cốp gầy được nhiều bầy dê và bầy chiên cho mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Khéo hơn nữa, Gia-cốp chỉ đặt các cành lột vỏ trước các dê và chiên mập mạnh. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Các con ốm yếu vẫn tiếp tục đẻ con gầy guộc cho La-ban; chỉ những đàn con mập mạnh mới về tay Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kết quả là bầy gia súc của Gia-cốp gia tăng nhanh chóng. Gia-cốp ngày càng giàu; ông mua được nhiều nô lệ, lạc đà, lừa, và trở thành cự phú. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Gia-cốp nghe các con trai La-ban tố cáo mình sang đoạt tài sản của cha chúng để làm giàu, ");
INSERT INTO vieovcb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Gia-cốp để ý xem chừng nét mặt của La-ban và kết luận rằng ông gia đã đổi hẳn thái độ với mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Chúa Hằng Hữu phán cùng Gia-cốp: “Con hãy về quê hương, nơi chôn nhau cắt rốn. Ta sẽ bảo vệ con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Gia-cốp sai gọi Ra-chên và Lê-a ra đồng cỏ, nơi ông đang chăn bầy súc vật, ");
INSERT INTO vieovcb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","và giãi bày tâm sự: “Anh thấy cha đã đổi hẳn thái độ với anh, nhưng Đức Chúa Trời của cha anh vẫn phù hộ anh. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Hai em đã biết, anh cố sức phục vụ cha, ");
INSERT INTO vieovcb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","còn cha cứ lường gạt anh, hết gạt tiền công lại lừa đảo giao kèo, liên tiếp cả mười lần. Dù vậy, Đức Chúa Trời đâu có để cha hại anh. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Cha lập giao kèo cho anh các chiên nào có đốm để cấn trừ tiền công; thế là chiên cứ đẻ con có đốm. Cha hủy giao kèo, bảo chiên nào có sọc anh mới được bắt; thế là chiên cứ đẻ con có sọc. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Như thế, Đức Chúa Trời đã lấy tài sản của cha mà cho anh đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Việc xảy ra thế này: Khi bầy vật giao phối, anh nằm mộng thấy các con dê đực nhảy cỡn lên đều là những con có vằn, có đốm, và có vệt xám cả. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Lúc ấy, thiên sứ của Đức Chúa Trời liền nói với anh trong giấc mộng: ‘Gia-cốp!’ Anh thưa: ‘Có con đây!’ ");
INSERT INTO vieovcb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Thiên sứ bảo: ‘Con hãy nhìn lên. Các dê đực đang giao phối kia đều là những con có vằn, có đốm, và có vệt xám cả, vì Ta đã thấy cách La-ban đối xử với con. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ta là Chân Thần đã hiện ra và gặp con tại Bê-tên, nơi con xức dầu trên trụ đá và hứa nguyện với Ta. Bây giờ, con hãy đứng dậy và bỏ xứ này để trở về quê cha đất tổ.’ ” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ra-chên và Lê-a đáp: “Chúng em đâu còn gia tài hoặc sản nghiệp gì ở nhà cha nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Cha đã coi chúng em như người dưng, vì gả bán chúng em được bao nhiêu tiền thì cha tiêu xài hết. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dĩ nhiên, tất cả tài sản Đức Chúa Trời lấy nơi cha là để cho mẹ con chúng em. Bây giờ, anh cứ làm mọi điều Đức Chúa Trời dạy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Gia-cốp liền đứng dậy, đỡ vợ con lên lưng lạc đà, ");
INSERT INTO vieovcb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","lùa đi hết các bầy gia súc, di chuyển tất cả của cải đã thu trữ được tại xứ Pha-đan A-ram, và đem về xứ Ca-na-an, nơi cha mình Y-sác cư ngụ. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Thừa dịp cha bận đi hớt lông chiên, Ra-chên đánh cắp các pho tượng của gia đình. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Gia-cốp lập mưu đánh lạc hướng La-ban, người A-ram, không cho ông biết ý định hồi hương của mình, ");
INSERT INTO vieovcb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Gia-cốp đem cả gia đình và tài sản qua Sông Ơ-phơ-rát, đi thẳng về núi Ga-la-át. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ba ngày sau, được báo tin Gia-cốp đã trốn đi, ");
INSERT INTO vieovcb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","La-ban tập hợp bà con họ hàng đuổi theo Gia-cốp suốt bảy ngày, đến tận núi Ga-la-át mới bắt kịp. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Đức Chúa Trời báo cho La-ban, người A-ram, trong giấc mộng: “Dù lành hay dữ, hãy thận trọng, đừng nặng lời với Gia-cốp.” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Đuổi đến núi Ga-la-át, La-ban thấy gia đình Gia-cốp cắm trại trên sườn núi bên kia, nên La-ban và bà con họ hàng cắm trại bên này. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","La-ban hỏi Gia-cốp: “Cháu làm gì vậy? Tại sao cháu gạt cậu và áp giải các con gái cậu như tù binh? ");
INSERT INTO vieovcb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Sao lại bí mật trốn đi và đánh lạc hướng? Sao không cho cậu biết, để cậu đem ban hát, dàn nhạc tiễn đưa cho thêm phần long trọng? ");
INSERT INTO vieovcb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Sao không để cho cậu hôn từ biệt con cháu của cậu? Việc cháu làm thật là dại dột. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Cậu có quyền hại cháu, nhưng Đức Chúa Trời của cha cháu đã dặn cậu tối qua: ‘Dù lành hay dữ, hãy thận trọng, đừng nặng lời với Gia-cốp.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nay cháu mong mỏi về quê cha đất tổ nên đã ra đi, nhưng tại sao lại đánh cắp các tượng thần của cậu?” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Gia-cốp đáp: “Vì cháu sợ cậu bắt lại hai con gái của cậu nên cháu phải ra đi thình lình như thế. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Còn các tượng thần của cậu, cậu tìm thấy nơi ai, người đó phải chết. Trước mặt đông đủ anh em, cậu cứ vào soát các hành lý của cháu đi, xem có vật gì thuộc về cậu, cậu cứ việc thu hồi.” Thực tình Gia-cốp không biết Ra-chên đã đánh cắp các tượng ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Vậy, La-ban lần lượt vào lục soát các trại của Gia-cốp. Từ trại Lê-a, La-ban bước qua trại Ra-chên. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Số là, Ra-chên đã đem giấu mấy pho tượng đó dưới bành lạc đà và ngồi chận lên. La-ban soát khắp trại cũng chẳng tìm thấy tượng nào. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ra-chên giải thích: “Thưa cha, vì con có tháng, nên không đứng dậy đón rước cha được, xin cha tha thứ.” La-ban lại lục soát nhưng cũng chẳng tìm ra tượng thần đâu cả. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Gia-cốp đùng đùng nổi giận và cự La-ban: “Cháu có phải là đứa tù tội hay sao mà cậu hầm hầm rượt bắt như thế? ");
INSERT INTO vieovcb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Cậu lục soát tất cả hành lý của cháu, cậu có tìm ra vật gì thuộc quyền sở hữu của cậu không? Cậu cứ đem tang vật ra đây cho bà con hai bên xét xử. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Suốt hai mươi năm trọ tại nhà cậu, có khi nào cháu để cho chiên hoặc dê của cậu bị sẩy thai; hay có khi nào cháu ăn thịt chiên đực trong bầy cậu? ");
INSERT INTO vieovcb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Cháu chẳng bao giờ đem về cho cậu một con súc vật nào bị thú dữ cắn xé. Nếu có, cháu cũng đã bồi thường cho cậu. Thế mà cậu cứ cằn nhằn đòi cháu bồi hoàn những con bị trộm cắp ban ngày và đêm khuya. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ban ngày, cháu bị nắng nóng như thiêu; ban đêm, cháu chịu lạnh lẽo, ngủ không an giấc. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Cháu chịu đựng gian khổ như thế suốt hai mươi năm: Cháu phải làm lụng mười bốn năm chỉ vì muốn cưới hai con gái của cậu, cháu phải đầu tắt mặt tối suốt sáu năm chỉ vì mấy bầy súc vật. Thế mà cậu còn tráo trở, thay đổi giao kèo cả mười lần! ");
INSERT INTO vieovcb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nếu cháu không được sự phù hộ của Đức Chúa Trời của cha cháu, Chân Thần của Áp-ra-ham và Y-sác mà cha cháu kính thờ, chắc hẳn bây giờ cậu đuổi cháu đi với hai bàn tay trắng. Đức Chúa Trời đã thấy rõ nỗi đau khổ của cháu và nhìn nhận công khó của cháu, nên đêm qua Ngài đã xét xử công minh rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","La-ban đáp cùng Gia-cốp: “Những phụ nữ này là con gái của cậu, các đứa trẻ này là cháu của cậu. Các bầy gia súc cháu có đây cũng là của cậu. Bất cứ vật gì cháu có ngày nay cũng là tài sản của cậu hết. Có lý nào cậu lại làm hại con cháu của cậu sao. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Cháu hãy đến đây kết ước với cậu, để có một bằng chứng từ nay về sau giữa đôi bên.” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Gia-cốp liền chọn một tảng đá, dựng lên làm tấm bia, ");
INSERT INTO vieovcb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","và bảo bà con họ hàng lượm đá dồn lại làm một đống lớn quanh tấm bia. Gia-cốp và La-ban ngồi ăn bên đống đá. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Hai người đều coi nó là “Đống Đá Làm Chứng,” nhưng La-ban gọi bằng tiếng A-ram là Giê-ga Sa-ha-đu-ta, còn Gia-cốp gọi bằng tiếng Hê-bơ-rơ là Ga-lét. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","La-ban nói: “Đống đá này sẽ làm chứng giữa cháu và cậu nếu bên nào muốn xâm phạm địa giới này.” ");
INSERT INTO vieovcb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","La-ban nói tiếp, “Vì thế, đống đá này cũng được gọi là ‘Tháp Canh’ (Mích-pa)” vì La-ban giải thích: “Cầu Chúa Hằng Hữu canh giữ cháu và cậu khi ta xa cách nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Nếu cháu bạc đãi con gái cậu, mà lấy vợ khác, cháu nên nhớ rằng dù cậu không biết đi nữa, Đức Chúa Trời vẫn biết rõ. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Đống đá này làm chứng giữa cháu và cậu ");
INSERT INTO vieovcb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","về lời cam kết rằng hai bên chẳng bao giờ được vượt qua giới hạn này để tấn công nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nếu ai vi phạm giao ước này, nguyện Đức Chúa Trời của Áp-ra-ham, của Na-cô, và của tổ phụ họ tiêu diệt nó đi.” Vậy, Gia-cốp thề trước mặt Đức Chúa Trời Toàn Năng của Y-sác, cha mình, rằng sẽ luôn luôn tôn trọng biên giới này. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Gia-cốp dâng lên Đức Chúa Trời một của lễ trên đỉnh núi, mời bà con dự tiệc, và ở cả đêm với họ trên núi. ");
INSERT INTO vieovcb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Hôm sau, La-ban dậy sớm, hôn từ biệt các con gái và các cháu mình, chúc phước cho con cháu, và lên đường về quê nhà. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Gia-cốp và cả gia đình tiếp tục cuộc hành trình, thiên sứ của Đức Chúa Trời đến gặp họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Khi Gia-cốp thấy họ, ông reo mừng: “Đức Chúa Trời ngự tại nơi này!” Rồi ông gọi chỗ ấy là Ma-ha-na-im. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Gia-cốp sai người lên tận núi Sê-i-rơ trong xứ Ê-đôm, tìm Ê-sau ");
INSERT INTO vieovcb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","và thưa rằng: “Các ngươi hãy thưa với Ê-sau, chúa ta rằng Gia-cốp, đầy tớ chúa, có nói: Tôi đã ngụ tại nhà cậu La-ban cho đến ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tôi có nhiều tôi trai, tớ gái, bò, lừa, và các bầy gia súc. Nay chúng tôi sắp về tới quê nhà, xin kính tin anh rõ, mong anh vui lòng chấp thuận.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Gia nhân quay về báo Gia-cốp: “Chúng tôi đã tìm gặp Ê-sau. Ông ấy đang đem một lực lượng 400 người đến đón chủ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Gia-cốp được tin; ông phập phồng lo sợ. Để đề phòng mọi bất trắc, ông chia gia nhân làm hai toán, cho mỗi toán coi sóc một nửa số súc vật. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ông tự bảo: “Nếu anh ta, Ê-sau, tấn công toán này, toán kia có thể chạy thoát.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Gia-cốp cầu nguyện: “Lạy Đức Chúa Trời của Áp-ra-ham, ông nội con, và của Y-sác, Chúa Hằng Hữu, cha con! Chúa đã phán: ‘Con hãy trở về quê hương, sống với bà con thân thích. Ta sẽ hậu đãi con.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Thật ra, con chẳng xứng đáng gì, nhưng Chúa đã thương xót và giữ đúng tất cả lời Ngài hứa. Khi con ra đi, và khi qua sông Giô-đan chỉ có hai bàn tay trắng; mà nay con có hai đoàn người này với bao nhiêu tài sản. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Con cầu xin Chúa Hằng Hữu giải thoát con khỏi tay Ê-sau, anh con. Vì con sợ anh ấy đến đánh giết con và vợ con con. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Chúa đã hứa: ‘Chắc chắn Ta sẽ hậu đãi con và cho dòng dõi con đông như cát biển, không ai đếm được.’” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Tối hôm ấy, Gia-cốp ở lại Ma-ha-na-im và chọn các món quà để biếu Ê-sau. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Quà tặng gồm có: 200 dê cái, 20 dê đực, 200 chiên cái, 20 chiên đực, ");
INSERT INTO vieovcb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 lạc đà cái, một đàn lạc đà con, 40 bò cái, 10 bò đực, 20 lừa cái, và 10 lừa đực. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Gia-cốp giao các bầy súc vật cho đám đầy tớ, mỗi người coi sóc một bầy, và căn dặn họ: “Các anh đi trước và giữ một khoảng cách giữa các bầy súc vật.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Gia-cốp cũng dặn người dẫn bầy thứ nhất: “Khi Ê-sau gặp anh và hỏi: ‘Chủ anh là ai? Anh đi về đâu? Bầy vật này thuộc về ai?’ ");
INSERT INTO vieovcb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Anh cứ đáp: ‘Bầy vật này của Gia-cốp, đầy tớ ngài, xin kính tặng ngài Ê-sau. Gia-cốp đi sau, cũng sắp đến.’” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Gia-cốp lại dặn các đầy tớ chăn bầy khác cũng nói với Ê-sau những lời đó, ");
INSERT INTO vieovcb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","và thêm: “Này, Gia-cốp, đầy tớ ngài, đang theo sau chúng tôi.” Gia-cốp tự nhủ: “Ta gửi các tặng phẩm này trước để làm Ê-sau nguôi giận. Mong rằng nhờ đó, Ê-sau sẽ tiếp ta tử tế khi gặp mặt.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Gửi các lễ vật đi trước, tối hôm ấy, Gia-cốp ở lại trong trại. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Giữa đêm khuya, Gia-cốp thức dậy, đưa hai vợ, hai nữ tì, và mười một con trai qua suối Gia-bốc. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Sau khi ông đã đưa họ qua sông, ông gửi tất cả tài sản còn lại qua sông. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Đang một thân một mình, Gia-cốp bỗng thấy một người xuất hiện và đấu vật với mình cho đến rạng đông. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Thấy mình không thắng được, Người ấy liền đập vào hông của Gia-cốp, làm trặc xương đùi, ");
INSERT INTO vieovcb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","và bảo rằng: “Trời đã sáng, hãy để Ta đi.” Gia-cốp đáp: “Nếu Ngài không ban phước lành cho con, con không để Ngài đi đâu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Người ấy hỏi: “Tên con là gì?” Đáp rằng: “Gia-cốp.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Người liền bảo: “Tên con không phải là Gia-cốp nữa nhưng sẽ đổi lại là Ít-ra-ên, vì con đã tranh đấu với Đức Chúa Trời và người, và con đều thắng cả.” ");
INSERT INTO vieovcb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Gia-cốp thưa: “Xin cho con biết tên Ngài.” Người ấy đáp: “Con hỏi tên Ta làm gì?” Rồi Người ban phước lành cho Gia-cốp tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Gia-cốp gọi địa điểm này là Phê-niên (có nghĩa là “Đức Chúa Trời hiện diện”) và giải thích rằng ông đã đối diện cùng Đức Chúa Trời mà vẫn còn sống. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Gia-cốp khập khễnh bước ra khỏi Phê-ni-ên lúc trời rạng đông. ");
INSERT INTO vieovcb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Về sau, người Ít-ra-ên không bao giờ ăn gân đùi của các thú vật vì Gia-cốp đã bị trặc xương đùi trong cuộc lộn vật này. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ngước mặt lên, Gia-cốp thấy Ê-sau chỉ huy lực lượng 400 người tiến đến. Gia-cốp lập tức chia đàn con cho Lê-a, Ra-chên, và hai nữ tì. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hai nữ tì dẫn con họ đi trước, kế đến là Lê-a và sáu con; Ra-chên và Giô-sép đi sau cùng. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Gia-cốp vượt lên trước vợ con để đón Ê-sau và cúi rạp xuống đất bảy lần trước mặt anh mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ê-sau chạy đến ôm choàng Gia-cốp và bá lấy cổ mà hôn. Hai anh em đều khóc. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Thấy vợ con Gia-cốp tiến đến, Ê-sau hỏi: “Những người đi theo em đó là ai?” Gia-cốp đáp: “Đó là con cái Chúa đã cho em.” ");
INSERT INTO vieovcb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hai nữ tì dẫn đàn con đến cúi xuống chào Ê-sau, ");
INSERT INTO vieovcb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","kế đến là Lê-a và các con, sau hết là Ra-chên và Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ê-sau hỏi: “Các bầy súc vật đó em định làm gì?” Gia-cốp đáp: “Em xin kính dâng cho anh để anh rủ lòng thương.” ");
INSERT INTO vieovcb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ê-sau từ khước: “Anh có đủ tài sản rồi; em cứ giữ các bầy súc vật đó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Gia-cốp khẩn khoản: “Không, em nài xin anh vui lòng nhận các lễ vật ấy. Vì gặp được anh cũng như gặp được Đức Chúa Trời rồi; anh đã vui lòng tiếp đón em. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xin anh nhận lễ vật em dâng hiến, vì Đức Chúa Trời đã hậu đãi em và cho em đầy đủ mọi thứ.” Gia-cốp nài nỉ mãi cho đến khi Ê-sau nhận các lễ vật ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ê-sau nói: “Này, anh em ta hãy lên đường; anh sẽ hộ tống em.” ");
INSERT INTO vieovcb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Gia-cốp đáp: “Anh biết đám trẻ con còn yếu; bầy chiên và bò có nhiều con đang bú. Nếu ép đi nhanh, chắc chỉ một ngày là chúng bỏ mạng. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Xin anh cứ đi trước, còn em sẽ chậm rãi theo sau, đi cho vừa sức của trẻ con và thú vật đang bú, cho đến chừng tới nhà anh trên núi Sê-i-rơ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ê-sau lại nói: “Để anh bảo người ở lại dẫn đường cho em.” Gia-cốp từ khước: “Không cần, anh ạ. Anh đã tỏ lòng thương em là quý lắm rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ngay hôm ấy, Ê-sau quay về núi Sê-i-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Còn Gia-cốp đến Su-cốt, hạ trại, và dựng lều cho các bầy súc vật. Từ đó, người ta gọi địa điểm này là Su-cốt (nghĩa là nhà lều). ");
INSERT INTO vieovcb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kể từ ngày lìa xứ Pha-đan A-ram, Gia-cốp đi đường bình an đến xứ Ca-na-an, và hạ trại trước thành phố Si-chem. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Gia-cốp mua một miếng đất của anh em Si-chem, các con trai của Hê-mô, để cắm trại. ");
INSERT INTO vieovcb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Gia-cốp lập một bàn thờ tại Si-chem và đặt tên bàn thờ là Ên-ên-ô-hê, tức là Đức Chúa Trời của Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Một hôm, cô Đi-na (con gái của Lê-a và Gia-cốp) đi thăm các thiếu nữ trong thành phố. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hoàng Tử Si-chem, con Vua Hê-mô của người Hê-vi, thấy nàng, liền bắt cóc và cưỡng hiếp. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Si-chem say đắm sắc đẹp của Đi-na con gái Gia-cốp và dùng đủ lời đường mật quyến rũ cô. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Si-chem lại xin Vua Hê-mô cho hắn cưới Đi-na làm vợ. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Gia-cốp được tin, lặng người, và không nói một lời trong lúc các con trai ông còn bận chăn bầy súc vật ngoài đồng. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Vua Hê-mô, cha Si-chem, đến thăm Gia-cốp để cầu hôn cho con. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Các con trai Gia-cốp đang làm việc ngoài đồng, rất buồn rầu và giận dữ khi nghe tin Si-chem cưỡng hiếp em và gây sỉ nhục cho gia đình mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Vua Hê-mô đến yêu cầu: “Si-chem, con trai tôi, đã yêu Đi-na tha thiết. Xin hãy gả cô ấy cho con trai tôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Xin quý quyến cứ làm thông gia với chúng tôi, hai bên cưới gả với nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Quý quyến cứ định cư tại đây. Đất nước chúng tôi sẵn sàng tiếp đón quý vị. Xin quý vị ở đây buôn bán và mua tài sản đất ruộng.” ");
INSERT INTO vieovcb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Si-chem cũng thưa với Gia-cốp và các con trai ông: “Xin quý vị làm ơn cho tôi. Quý vị thách cưới cao đến thế nào, tôi cũng xin vâng. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Quý vị cứ đòi lễ vật cho nhiều, tôi xin nạp đủ số, miễn là quý vị gả cô ấy làm vợ tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Vì Si-chem lừa dối em mình, các con trai Gia-cốp đáp lời dối với Hê-mô và Si-chem cách mưu mẹo để trả thù cho em: ");
INSERT INTO vieovcb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Gả em gái cho người chưa chịu cắt bì là điều sỉ nhục, chúng tôi không thể nào chấp thuận. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nếu mỗi người nam của dân tộc các ông đều chịu cắt bì, ");
INSERT INTO vieovcb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","chúng tôi sẵn lòng cưới gả với dân tộc các ông; như thế, chúng ta sẽ thành một dân tộc thống nhất. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Nếu các ông không chịu cắt bì, chúng tôi sẽ bắt em gái lại và dọn đi xứ khác.” ");
INSERT INTO vieovcb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nghe đề nghị ấy, Hê-mô và Si-chem đều đồng ý. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Quá say mê sắc đẹp của con gái Gia-cốp, Si-chem vội vã triệu tập dân tại cổng thành, ");
INSERT INTO vieovcb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","để thúc đẩy mọi người chấp nhận đề nghị, vì Si-chem là người được tôn trọng nhất trong hoàng tộc. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hê-mô và Si-chem kêu gọi: “Anh chị em thân mến, gia đình Gia-cốp đã sống chung hòa bình với chúng ta. Vậy, hãy cho họ cư ngụ trong xứ để làm ăn buôn bán; vì xứ chúng ta đất rộng người thưa, đủ chỗ cho họ định cư. Chúng ta hãy cưới gả với họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Họ chỉ đòi một điều kiện là tất cả các người nam của chúng ta đều phải chịu cắt bì như họ. Chỉ như thế họ mới chịu đồng hóa với chúng ta thành một dân tộc thống nhất. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Anh chị em cứ chấp thuận điều kiện đó, để họ định cư với chúng ta. Tất nhiên, bao nhiêu tài sản, bầy chiên, và bầy bò của họ đều sẽ về tay chúng ta hết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Toàn dân có mặt ở cổng thành đều vâng theo lời của Hê-mô và Si-chem, và họ chịu cắt bì. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ngày thứ ba, khi họ còn đau, hai con trai Gia-cốp là Si-mê-ôn và Lê-vi, tức là anh ruột của Đi-na, rút gươm mạo hiểm xông vào, ");
INSERT INTO vieovcb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","tàn sát tất cả người nam trong thành, luôn với Hê-mô và Si-chem, và giải thoát Đi-na. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Các con trai của Gia-cốp thừa thắng xông lên và cướp phá thành phố để báo thù cho em gái. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Họ bắt các bầy chiên, bò, lừa, và thu tất cả của cải, bảo vật trong thành phố cũng như sản vật ngoài đồng ruộng. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Họ cũng bắt vợ con của người thành Si-chem và cướp đoạt tài sản trong nhà họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Gia-cốp được tin liền trách mắng Si-mê-ôn và Lê-vi: “Chúng mày làm hổ nhục cho cha giữa dân xứ này, giữa người Ca-na-an, và người Phê-rết. Chúng ta chỉ có ít người, nếu người bản xứ liên minh tấn công cha, cả gia đình chúng ta đành bị tiêu diệt.” ");
INSERT INTO vieovcb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Họ phân trần: “Thưa cha, không lẽ để nó hành hạ em chúng con như gái mãi dâm sao?” ");
INSERT INTO vieovcb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Đức Chúa Trời phán cùng Gia-cốp: “Con hãy lên định cư tại Bê-tên và lập một bàn thờ cho Ta, Đấng đã hiện ra và gặp con lúc con đang chạy trốn Ê-sau, anh con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Gia-cốp thuật lại điều này cho cả gia nhân quyến thuộc và căn dặn: “Hãy bỏ hết các thần tượng, dọn mình cho thánh sạch, và thay quần áo đi. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Chúng ta hãy đứng dậy và lên Bê-tên. Ta sẽ lập một bàn thờ cho Đức Chúa Trời, Đấng nhậm lời ta trong ngày hoạn nạn và ở cùng ta suốt các chặng đường đời.” ");
INSERT INTO vieovcb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Họ liền nạp cho Gia-cốp các pho tượng đang cất giấu và các đôi bông tai họ đang đeo. Gia-cốp đem chôn hết dưới gốc cây sồi tại Si-chem. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Gia đình Gia-cốp nhổ trại ra đi. Đức Chúa Trời làm cho dân các thành phố chung quanh khiếp sợ, và họ không dám đuổi theo các con trai Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Gia-cốp và cả gia đình đến thành phố Bê-tên, mà người Ca-na-an gọi là Lu-xơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Gia-cốp xây dựng một bàn thờ và đặt tên nơi đó là Ên-bê-tên, vì Đức Chúa Trời đã xuất hiện và gặp ông tại đây trong ngày ông chạy trốn anh mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Đê-bô-ra, vú nuôi của Rê-bê-ca, qua đời và được an táng tại Bê-tên, dưới gốc một cây sồi mang tên là A-long-ba-cúc. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Đức Chúa Trời lại xuất hiện và gặp Gia-cốp lần thứ nhì, sau khi ông lìa xứ Pha-đan A-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ngài phán: “Tên cũ của con là Gia-cốp, nhưng đừng dùng tên ấy nữa. Tên con sẽ là Ít-ra-ên.” Ngài gọi ông là Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Đức Chúa Trời dạy tiếp: “Ta là Đức Chúa Trời Toàn Năng. Con hãy sinh sôi nẩy nở, không những thành một dân tộc, nhưng thành nhiều dân tộc. Dòng dõi con sẽ có nhiều vua chúa. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ta sẽ cho con và dòng dõi con vùng đất Ta đã cho Áp-ra-ham và Y-sác.” ");
INSERT INTO vieovcb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kế đó, Đức Chúa Trời ngự lên khỏi nơi này. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Gia-cốp liền dựng tại đó một cây trụ đá, dâng lễ quán, và đổ dầu vào. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Gia-cốp gọi địa điểm này là Bê-tên (nghĩa là “Nhà Đức Chúa Trời”), vì Đức Chúa Trời đã phán với ông tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Gia-cốp cùng gia đình rời Bê-tên ra đi. Khi gần đến Ép-ra-ta, Ra-chên chuyển bụng và đau đớn dữ dội. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Trong cơn quặn thắt, Ra-chên nghe người nữ hộ sinh khích lệ: “Bà đừng sợ, vì bà sắp sinh một con trai nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ra-chên đang hấp hối và cố gắng đặt tên con là Bên-ô-ni (nghĩa là con trai tôi sinh trong sự đau đớn). Gia-cốp đổi tên con là Bên-gia-min (nghĩa là “con trai tay hữu ta”). ");
INSERT INTO vieovcb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ra-chên qua đời và được an táng tại Ép-ra-ta, (cũng gọi là Bết-lê-hem). ");
INSERT INTO vieovcb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Gia-cốp dựng bia tại ngôi mộ Ra-chên, đến ngày nay vẫn còn. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ít-ra-ên tiếp tục cuộc hành trình, đi qua tháp Ê-đa, và cắm trại để nghỉ chân. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Trong thời gian ở đó, Ru-bên vào ngủ với Bi-la, vợ lẽ của cha mình. Có người báo lại cho Gia-cốp. Đây là tên mười hai con trai của Gia-cốp: ");
INSERT INTO vieovcb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Các con của Lê-a là Ru-bên (trưởng nam của Gia-cốp), Si-mê-ôn, Lê-vi, Giu-đa, Y-sa-ca, và Sa-bu-luân. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Các con của Ra-chên là Giô-sép và Bên-gia-min. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Các con của Bi-la, nữ tì của Ra-chên là Đan và Nép-ta-li; ");
INSERT INTO vieovcb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Các con của Xinh-ba, nữ tì của Lê-a là Gát và A-se. Trừ Bên-gia-min, tất cả các con trai của Gia-cốp đều sinh tại xứ Pha-đan A-ram. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Rốt cuộc, Gia-cốp về đến nhà cha mình Y-sác tại Mam-rê, thành phố Ki-ri-át A-ra-ba (nay gọi là Hếp-rôn), cũng là nơi cư ngụ của Áp-ra-ham ngày trước. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Y-sác gặp lại con trai được một thời gian ngắn. ");
INSERT INTO vieovcb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Y-sác qua đời, hưởng thọ 180 tuổi, được hai con trai là Ê-sau và Gia-cốp an táng. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Đây là dòng dõi của Ê-sau (tức Ê-đôm): ");
INSERT INTO vieovcb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ê-sau cưới ba vợ, đều là người Ca-na-an: A-đa, con gái của Ê-lôn người Hê-tít; Ô-hô-li-ba-ma, con gái của A-na, cháu của Xi-bê-ôn, người Hê-vi; ");
INSERT INTO vieovcb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","và Bách-mát, con gái của Ích-ma-ên, em của Nê-ba-giốt. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","A-đa sinh Ê-li-pha cho Ê-sau. Bách-mát sinh Rê-u-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ô-hô-li-ba-ma sinh Giê-úc, Gia-lam, và Cô-ra. Tất cả con trai của Ê-sau ấy đều sinh tại xứ Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ê-sau đưa vợ con, gia nhân, cùng đem các bầy súc vật—tất cả tài sản gây dựng tại xứ Ca-na-an—cách xa gia đình Gia-cốp, ");
INSERT INTO vieovcb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","vì cả hai anh em đều có quá nhiều tài sản nên không thể sống chung được nữa; và xứ họ đang cư ngụ cũng không cung ứng nỗi các nhu cầu của hai gia đình đông đúc ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Vậy, Ê-sau (tức là Ê-đôm) ở trên núi Sê-i-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Đây là hậu tự của Ê-sau, tức là người Ê-đôm, sinh tại núi Sê-i-rơ: ");
INSERT INTO vieovcb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Các con trai Ê-sau: Ê-li-pha con trai của A-đa; và Rê-u-ên con trai của Bách-mát. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Con trai của Ê-li-pha là Thê-man, Ô-ma, Xê-phô, Ga-tam, và Kê-na. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Thim-na, vợ lẽ của Ê-li-pha sinh A-ma-léc. Đó là các cháu của A-đa, vợ Ê-sau. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Gia tộc Rê-u-ên, con trai của Bách-mát gồm có Na-hát, Xê-rách, Sam-ma, và Mích-xa. Ấy là các cháu của Bách-mát, cũng là vợ Ê-sau. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ê-sau cũng còn những người con trai sinh bởi Ô-hô-li-ba-ma, vợ của Ê-sau, con gái A-na, cháu ngoại Xi-bê-ôn. Tên của các con là Giê-úc, Gia-lam, và Cô-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Đây là các cháu nội của Ê-sau trở thành đại tộc trưởng: Các đại tộc là hậu tự của Ê-li-pha, con trưởng nam của Ê-sau và A-đa: Đại tộc Thê-man, đại tộc Ô-ma, đại tộc Xê-phô, đại tộc Kê-na, ");
INSERT INTO vieovcb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","đại tộc Cô-ra, đại tộc Ga-tam, và đại tộc A-ma-léc. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Các đại tộc do Rê-u-ên, thứ nam của Ê-sau và Bách-mát, sinh ra trong xứ Ca-na-an: Đại tộc Na-hát, đại tộc Xê-rách, đại tộc Sam-ma, và đại tộc Mích-xa. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Các đại tộc thuộc dòng thứ ba, là các con trai của Ê-sau và Ô-hô-li-ba-ma, con gái A-na: Đại tộc Giê-úc, đại tộc Gia-lam, và đại tộc Cô-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ấy là các con trai của Ê-sau, tức là Ê-đôm, và đó là các đại tộc của họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Các sắc tộc bản xứ, là hậu tự của Sê-i-rơ, người Hô-rít gồm Lô-than, Sô-banh, Xi-bê-ôn, A-na, ");
INSERT INTO vieovcb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Đi-sôn, Ét-xe, và Đi-san. Đó là các con trai của Sê-i-rơ, trưởng gia tộc người Hô-rít, trong đất Ê-đôm. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Con của Lô-than là Hô-ri và Hê-man. Em gái của Lô-than là Thim-na. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Con của Sô-banh là Anh-van, Ma-na-hát, Ê-banh, Sê-phô, và Ô-nam. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Con của Xi-bê-ôn là Ai-gia và A-na. (Cậu này đã tìm thấy các suối nước nóng giữa hoang mạc trong lúc chăn lừa cho cha mình.) ");
INSERT INTO vieovcb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Con của A-na là Đi-sôn và Ô-hô-li-ba-ma. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Con của Đi-sôn là Hem-đan, Ếch-ban, Ích-ran, và Kê-ran. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Con của Ét-xe là Binh-han, Xa-van, và A-can. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Con của Đi-san là U-xơ và A-ran. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Còn đây là các trưởng tộc người Hô-rít: Lô-than, Sô-banh, Xi-bê-ôn, A-na, ");
INSERT INTO vieovcb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Đi-sôn, Ét-xe, Đi-san. Đó là các trưởng tộc của người Hô-rít, ở tại xứ Sê-i-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Đây là tên các vua đã cai trị xứ Ê-đôm, trước thời vương quốc Ít-ra-ên được thành lập: ");
INSERT INTO vieovcb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bê-la, con Bê-ô, đặt ngai vua tại thủ đô Đin-ha-ba. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Sau khi Bê-la chết, Giô-báp, con Xê-rách, người Bốt-ra lên kế vị. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Sau khi Giô-báp chết, Hu-sam, người Thê-man lên kế vị. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Sau khi Hu-sam chết, Ha-đát, con Bê-đa lên kế vị. Vua này là người chỉ huy quân đội đánh bại quân Ma-đi-an tại xứ Mô-áp và dời đô về A-vít. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Sau khi Ha-đát chết, Sam-la, ở xứ Ma-rê-ca lên kế vị. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Sau khi Sam-la chết, Sau-lơ, ở xứ Rê-hô-bốt, gần Sông Cái lên kế vị. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sau khi Sau-lơ chết, Ba-anh Ha-nan, con Ách-bô lên kế vị. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Sau khi Ba-anh Ha-nan chết, Ha-đát lên kế vị. Tên thành người là Ba-u; hoàng hậu là Mê-hê-ta-bê-ên, con Mát-rết, cháu Mê-sa-háp. ");
INSERT INTO vieovcb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Đây là tên các đại tộc của Ê-sau và xứ họ ở, được gọi theo tên từng đại tộc: Thim-na, Anh-va, Giê-hết, ");
INSERT INTO vieovcb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ô-hô-li-ba-ma, Ê-la, Phi-nôn, ");
INSERT INTO vieovcb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kê-na, Thê-man, Míp-xa, ");
INSERT INTO vieovcb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mác-đi-ên, và Y-ram. Tất cả các đại tộc ấy đều là dòng dõi của Ê-sau, tổ phụ của người Ê-đôm. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Gia-cốp định cư tại xứ Ca-na-an, nơi cha mình đã cư ngụ. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Giô-sép, con Gia-cốp, đã mười bảy tuổi, thường đi chăn bầy cho cha với các anh, là con của Bi-la và Xinh-ba. Giô-sép thường mách cho cha biết các việc xấu họ làm. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Gia-cốp yêu thương Giô-sép hơn các con khác vì Giô-sép sinh ra lúc ông đã cao tuổi. Một hôm, Gia-cốp cho Giô-sép món quà đặc biệt—một cái áo choàng nhiều màu sặc sỡ. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Các anh Giô-sép ganh tị vì thấy cha thiên vị, nên họ không còn dịu ngọt với Giô-sép nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Một đêm, Giô-sép nằm mộng; sáng dậy, Giô-sép liền thuật cho các anh nghe, nên càng bị họ ganh ghét. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Giô-sép nói: “Xin các anh hãy nghe. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tối qua, tôi nằm mộng và thấy anh em chúng ta đang bó lúa ngoài đồng. Bó lúa của tôi đứng thẳng lên, còn những bó lúa của các anh đều tập hợp chung quanh và cúi mọp xuống trước bó lúa tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Các anh mỉa mai: “Thế là mày muốn làm vua chúng tao sao?” Họ càng ganh ghét Giô-sép thêm vì câu chuyện chiêm bao và vì lời nói thiếu dè dặt của Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Giô-sép lại nằm mộng và thuật cho các anh: “Các anh hãy nghe chiêm bao này của tôi: Tôi thấy mặt trời, mặt trăng, và mười một ngôi sao đều cúi rạp trước mặt tôi!” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Lần này, cha quở trách Giô-sép: “Mộng mị gì kỳ lạ thế! Không lẽ cha mẹ, anh em đều phải cúi rạp trước mặt con sao?” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Các anh càng ganh tức, nhưng cha lại lưu ý tìm hiểu ý nghĩa giấc mộng ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Một hôm, các anh Giô-sép dắt các bầy vật đến đồng cỏ Si-chem. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Gia-cốp bảo Giô-sép: “Các anh con đang chăn bầy tại Si-chem phải không? Con hãy sửa soạn, cha sẽ sai con đến chỗ các anh con.” Giô-sép trả lời: “Thưa vâng, con sẽ đi ngay.” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Giô-cốp nói: “Con hãy đi thăm xem chúng nó mạnh khỏe thế nào, bầy súc vật ra sao, rồi về cho cha biết.” Từ Hếp-rôn, Giô-sép lên đường qua Si-chem. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Nhưng Giô-sép đi lạc vào một khu hoang mạc. Một người gặp được và hỏi Giô-sép: “Cậu đi tìm ai?” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Giô-sép đáp: “Tôi đi tìm các anh tôi. Xin ông cho biết họ chăn bầy tại đâu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Người ấy nói: “Họ đi nơi khác rồi. Tôi nghe họ rủ nhau đi Đô-than.” Giô-sép tìm đến Đô-than để gặp các anh. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Thấy Giô-sép còn ở đàng xa, các anh đã âm mưu giết cậu. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Họ bàn tính với nhau: “Kìa, thằng chuyên nằm mộng sắp đến đây. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ta hãy giết nó đi, vứt xác dưới đáy giếng, và báo cho cha rằng nó bị cọp ăn, để xem các giấc mộng của nó có thành không.” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ru-bên muốn cứu Giô-sép, ông liền bàn ra: “Đừng giết nó! ");
INSERT INTO vieovcb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Đổ máu nó ra làm chi? Chỉ cần quăng nó vào giếng cạn là nó chết rồi.” Thật ra, Ru-bên lập mưu cứu Giô-sép để đưa nó về với cha an toàn. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Giô-sép vừa đến nơi, các anh xúm nhau lột chiếc áo choàng sặc sỡ ");
INSERT INTO vieovcb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","và quăng Giô-sép vào một cái giếng cạn, không có một giọt nước. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Khi các anh của Giô-sép đang ngồi ăn, họ chợt thấy một đoàn lái buôn A-rập cỡi lạc đà chở nhũ hương, dầu thơm, và nhựa thơm từ xứ Ga-la-át thẳng tiến xuống Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Giu-đa đề nghị: “Đem bán nó đi cho bọn lái buôn A-rập là lợi nhất, ");
INSERT INTO vieovcb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","chứ giết nó, rồi tìm cách phi tang khéo đến mấy cũng chẳng ích gì. Anh em đừng giết nó, vì nó là đứa em ruột thịt của chúng ta.” Họ đều chấp thuận đề nghị ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Khi các lái buôn A-rập đến nơi, họ kéo Giô-sép lên khỏi giếng và bán em cho người A-rập được hai mươi lạng bạc. Giô-sép bị đem xuống Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ru-bên không hay biết vụ bán em, nên quay lại giếng cạn tìm Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Không thấy em đâu cả, Ru-bên thất vọng, xé áo, và chạy đến bảo các em: “Đứa bé mất tích rồi. Biết làm sao bây giờ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Các anh em giết một con dê, nhúng áo choàng của Giô-sép vào máu, ");
INSERT INTO vieovcb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","rồi gửi áo về cho cha với lời nhắn: “Chúng con tìm được chiếc áo này. Xin cha xem có phải áo của Giô-sép không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Gia-cốp nhận ra áo của con nên than rằng: “Đúng là áo của con ta. Một con thú dữ đã xé xác và ăn thịt nó rồi. Giô-sép chắc chắn đã bị xé ra từng mảnh rồi!” ");
INSERT INTO vieovcb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Gia-cốp xé áo xống, mặc bao gai, và để tang cho con mình một thời gian dài. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Các con trai và con gái cố gắng an ủi cha, nhưng ông gạt đi: “Không! Cha cứ khóc nó cho đến ngày xuôi tay nhắm mắt.” Gia-cốp thương tiếc Giô-sép vô cùng. ");
INSERT INTO vieovcb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Trong khi đó, bọn lái buôn A-rập xuống Ai Cập, và họ bán Giô-sép cho Phô-ti-pha, viên quan chỉ huy đoàn thị vệ của Pha-ra-ôn, vua Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Giu-đa lìa gia đình, xuống A-đu-lam và trọ tại nhà Hy-ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Phải lòng một thiếu nữ Ca-na-an, con gái của Su-a, Giu-đa lo ngay việc cưới xin. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Hai vợ chồng sinh được con trai đặt tên là Ê-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nàng thọ thai nữa, sinh một con trai, đặt tên là Ô-nan. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nàng lại sinh thêm một con trai thứ ba và đặt tên là Sê-la. Lúc ấy, vợ chồng Giu-đa đang ở Kê-xíp. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Khi Ê-rơ đến tuổi trưởng thành, Giu-đa thu xếp cho con cưới cô Ta-ma. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ê-rơ là người gian ác, nên bị Chúa Hằng Hữu phạt chết sớm. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Giu-đa bảo Ô-nan: “Con phải cưới Ta-ma và sinh con nối dõi cho anh, đúng theo luật định.” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nhưng Ô-nan biết rằng con sinh ra cũng không thuộc về mình, nên cứ để xuất tinh ra ngoài, cho Ta-ma đừng thụ thai. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Hành động ấy không đẹp lòng Chúa Hằng Hữu, nên Ô-nan cũng chết sớm. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Giu-đa bảo Ta-ma: “Con cứ về quê mẹ và thủ tiết đợi chờ một thời gian, cho đến khi Sê-la khôn lớn” (vì ông sợ không khéo Sê-la cũng chết luôn như hai anh). Ta-ma vâng lời về nhà cha mẹ. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sau một thời gian, vợ Giu-đa qua đời. Qua kỳ tang chế, Giu-đa rủ Hy-ra đi Thim-na, thăm các nhân công chuyên hớt lông chiên của mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Có người nói với Ta-ma: “Kìa, ông gia sắp đến Thim-na để hớt lông chiên.” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ta-ma liền bỏ áo quả phụ và mang mạng che mặt. Rồi nàng đến ngồi bên cổng thành Ê-nam trên đường đi Thim-na. Ta-ma hy vọng được ông gia cho mình kết tóc xe tơ với Sê-la vì chàng đã khôn lớn rồi. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Giu-đa đến nơi, thấy Ta-ma che mặt và không biết là dâu mình, tưởng lầm là gái mãi dâm. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ông liền đến gạ gẫm: “Hãy đến ngủ với ta,” vì ông không nhận ra cô chính là con dâu mình. Ta-ma hỏi: “Ông cho tôi bao nhiêu?” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Giu-đa đáp: “Một con dê con từ bầy của tôi.” Ta-ma đề nghị: “Nhưng ông sẽ đặt cọc gì trước khi gửi dê con đến cho tôi chứ?” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ông đáp: “Nàng muốn ta đặt cọc gì đây?” Ta-ma đáp: “Chiếc nhẫn, sợi dây chuyền, và cây gậy trên tay ông đó là được rồi.” Giu-đa đồng ý, và Ta-ma thụ thai. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Nàng đứng dậy về nhà, cởi mạng che mặt, và mặc lại chiếc áo quả phụ. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Giu-đa nhờ Hy-ra đem dê con đến Ê-nam để thu lại các vật đặt cọc, nhưng Hy-ra tìm mãi không thấy người đàn bà ấy. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hy-ra hỏi người dân Ê-nam: “Cô gái mãi dâm thường ngồi bên lề đường tại Ê-nam đi đâu rồi?” Họ đáp: “Ở đây làm gì có gái mãi dâm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hy-ra quay về và nói với Giu-đa: “Tôi tìm nó không được, khi tôi hỏi dân chúng, họ quả quyết rằng trong thành phố không có gái mãi dâm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Giu-đa đáp: “Thôi, cứ để nó giữ các thứ ấy cũng được, đừng để người ta bêu riếu chúng ta. Tôi đã đúng hẹn gửi dê con cho nó, mà anh tìm nó không được, tôi đành chịu vậy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ba tháng sau, có người đến báo tin cho Giu-đa: “Ta-ma, con dâu ông, đã làm gái bán dâm lại còn chửa hoang nữa.” Giu-đa nổi giận quát: “Đem nó ra thiêu sống đi!” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Khi Ta-ma bị bắt đem đi thiêu, cô liền nhờ người đem các vật đặt cọc trình cho Giu-đa và phán: “Xin cha xét lại, xem các vật này của ai đây. Con thụ thai do người đó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Giu-đa giật mình nhìn nhận: “Ta-ma đúng hơn ta rồi. Chỉ vì ta không chịu cho Sê-la kết tóc xe tơ với nó như luật định.” Từ đó, Giu-đa kiêng nể Ta-ma. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Đến ngày lâm bồn, Ta-ma sinh đôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Trong lúc bà đang sinh, một đứa đưa tay ra trước. Bà mụ nắm tay nó cột sợi chỉ đỏ vào tay và nói: “Đứa này ra trước.” ");
INSERT INTO vieovcb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nhưng nó rút tay vào. Thấy đứa kia ra trước, bà đỡ ngạc nhiên: “Gớm! Mày ở đâu mà xông ra đây.” Vì thế, người ta đặt tên nó là Phê-rết (có nghĩa là xông ra.) ");
INSERT INTO vieovcb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Em nó lọt lòng sau, tay vẫn còn sợi chỉ đỏ, được đặt tên là Xê-rách. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Xuống đến Ai Cập, Giô-sép bị các lái buôn A-rập bán cho Phô-ti-pha, viên quan chỉ huy đoàn thị vệ của Pha-ra-ôn, vua Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Chúa Hằng Hữu ở với Giô-sép, phù hộ người trong mọi công việc tại nhà chủ Ai Cập, nên người làm gì cũng thành công tốt đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Phô-ti-pha đã nhìn nhận rằng Chúa Hằng Hữu phù hộ Giô-sép cách đặc biệt, ");
INSERT INTO vieovcb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","nên ông nể vì, trọng dụng người, và cử người làm quản gia coi sóc mọi việc trong nhà. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Từ ngày ông giao cho Giô-sép quản trị nhà cửa và mọi tài sản trong nhà, Chúa Hằng Hữu vì Giô-sép ban phước lành cho gia đình, súc vật, và tài sản của Phô-ti-pha, ");
INSERT INTO vieovcb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","vì thế ông giao trọn mọi việc cho Giô-sép, không cần bận tâm đến việc nhà nữa, ông chỉ còn chọn món ăn thích khẩu mà thôi! Giô-sép là một thanh niên rất đẹp trai, ");
INSERT INTO vieovcb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","khiến vợ của Phô-ti-pha mê mẫn. Bà dụ: “Hãy đến và nằm với tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Nhưng Giô-sép cự tuyệt: “Thưa bà, ông chủ đã ủy quyền cho tôi quản lý mọi người, mọi vật trong nhà, ");
INSERT INTO vieovcb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","và bằng lòng giao hết cho tôi, chỉ trừ một mình bà, vì là vợ của chủ. Tôi đâu dám phạm tội ác này và làm buồn lòng Đức Chúa Trời.” ");
INSERT INTO vieovcb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ngày này qua ngày khác, bà chủ cứ liên tiếp quyến rũ, nhưng Giô-sép một mực chối từ. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Một hôm, thấy Giô-sép làm việc trong nhà mà chung quanh chẳng có ai. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Bà chủ nắm áo kéo chàng lại và đòi ăn nằm. Khi Giô-sép giật áo lại không được, đành bỏ luôn chiếc áo và chạy trốn ra khỏi nhà. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Còn lại một mình, bẽ mặt, ");
INSERT INTO vieovcb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","bà chủ nham hiểm lại hô hoán lên để vu vạ: “Bọn gia nhân đâu? Ra xem! Tên nô lệ người Hê-bơ-rơ dám lẻn vào phòng định hãm hiếp tao. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tao tri hô lên, nên nó khiếp sợ chạy trốn và bỏ cả áo lại đây này.” ");
INSERT INTO vieovcb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Giữ chiếc áo làm tang vật, bà chủ đợi chồng về, ");
INSERT INTO vieovcb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","vu cáo: “Tên nô lệ người Hê-bơ-rơ ông mua về đó thật là phản trắc. Nó định hãm hiếp tôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tôi kêu cứu; nó mới khiếp sợ, chạy trốn, và bỏ lại cái áo!” ");
INSERT INTO vieovcb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Phô-ti-pha tức giận khi nghe vợ kể. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ông ra lệnh tống giam Giô-sép và xiềng lại trong ngục của hoàng triều. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Dù vậy, Chúa Hằng Hữu vẫn ở với Giô-sép trong ngục và khiến chàng được giám ngục quý mến. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Chẳng bao lâu, giám ngục ủy quyền cho Giô-sép quản lý cả lao xá và coi sóc tất cả phạm nhân. ");
INSERT INTO vieovcb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Từ ngày ấy, giám ngục khỏi bận tâm, vì Giô-sép quản trị mọi việc cách tốt đẹp hoàn hảo. Chúa Hằng Hữu cho bất cứ việc gì Giô-sép bắt tay vào cũng đều thành công mỹ mãn. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sau đó, trong hoàng cung Ai Cập, quan chước tửu và quan hỏa đầu phạm tội khi quân. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Vua Pha-ra-ôn tức giận hai viên chức ");
INSERT INTO vieovcb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","và tống giam hai viên chức vào ngục, thuộc dinh chỉ huy trưởng ngự lâm, nơi Giô-sép đang bị tù. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Viên quan chỉ huy đoàn ngự lâm cử Giô-sép trông coi hai viên chức ấy; họ bị giam tại đó lâu ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Một đêm nọ, hai viên chức trong lao nằm mơ; giấc mơ mỗi người mỗi khác. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sáng hôm sau, Giô-sép gặp họ, thấy nét mặt rầu rĩ, ");
INSERT INTO vieovcb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","nên hỏi: “Hôm nay sao hai ông buồn bã thế?” ");
INSERT INTO vieovcb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Họ đáp: “Chúng tôi thấy chiêm bao rất lạ, nhưng chẳng có ai giải nghĩa cho chúng tôi cả.” Giô-sép nói: “Giải mộng là việc của Đức Chúa Trời. Xin hai ông cứ kể cho tôi nghe.” ");
INSERT INTO vieovcb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Quan chước tửu kể lại giấc mơ cho Giô-sép: “Trong mơ, tôi thấy một cây nho. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Cây nho có ba nhánh, bắt đầu nứt lộc trổ hoa, và hoa biến thành từng chùm quả chín. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Đang cầm cái chén của vua Pha-ra-ôn trong tay, tôi liền hái nho, ép nước vào chén, và dâng lên vua.” ");
INSERT INTO vieovcb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Giô-sép giải thích: “Đây là ý nghĩa: Ba nhánh là ba ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ba ngày nữa, vua Pha-ra-ôn sẽ tha ông ra khỏi ngục. Ông được phục chức và sẽ dâng rượu cho vua như trước. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Khi sung sướng, xin ông đừng quên tôi; ông làm ơn tâu với vua Pha-ra-ôn và xin cho tôi ra khỏi ngục. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Vì thật ra, tôi bị người ta bắt từ quê hương xứ Hê-bơ-rơ bán qua đây. Ở Ai Cập tôi cũng chẳng phạm tội gì mà bị tù.” ");
INSERT INTO vieovcb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Quan hỏa đầu nghe lời giải tốt, liền thuật cho Giô-sép: “Còn tôi, trong giấc mơ, thấy ba giỏ bánh trắng đội trên đầu. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Giỏ trên cùng đựng đủ thứ bánh của vua Pha-ra-ôn, nhưng có chim trời đáp xuống rỉa ăn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Giô-sép đáp: “Đây là lời giải: Ba giỏ là ba ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ba ngày nữa, ông sẽ bị vua Pha-ra-ôn xử tử, bị treo xác lên cây, và bị chim ăn thịt.” ");
INSERT INTO vieovcb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ba ngày sau, nhằm sinh nhật vua Pha-ra-ôn, hoàng gia thết tiệc đãi quần thần. Giữa tiệc, vua sai đem quan chước tửu và quan hỏa đầu ra khỏi ngục. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Vua phục chức cho viên chước tửu, để tiếp tục dâng rượu cho vua Pha-ra-ôn như trước. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Còn quan hỏa đầu bị vua treo cổ lên cây, như lời Giô-sép giải mộng. ");
INSERT INTO vieovcb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Quan chước tửu quên bẵng Giô-sép, ông không nhớ chuyện trong ngục nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Hai năm sau, vua Pha-ra-ôn nằm mơ và thấy mình đang đứng bên bờ sông Nin. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Từ dưới sông, bảy con bò béo tốt đẹp đẽ lên bờ ăn cỏ. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tiếp đó, bảy con bò khác, gầy guộc xấu xí, từ sông Nin đi lên, đứng cạnh bảy con kia bên bờ sông. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bảy con bò gầy gò xấu xí nuốt bảy con bò béo tốt đẹp đẽ. Sau đó, vua Pha-ra-ôn thức giấc. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Vua ngủ lại và mơ lần thứ hai. Này, bảy bông lúa rắn chắc trổ ra từ một cây lúa. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kế đó, bảy bông lúa lép mọc tiếp, bị gió đông thổi héo khô. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bảy bông lúa lép khô nuốt bảy bông lúa rắn chắc. Vua Pha-ra-ôn thức giấc, biết mình nằm mơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sáng hôm sau, tinh thần xao động, vua sai mời tất cả thuật sĩ và học giả Ai Cập vào hoàng cung. Vua Pha-ra-ôn thuật lại giấc mơ, nhưng chẳng ai giải nghĩa được. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Quan chước tửu tâu với vua Pha-ra-ôn: “Hôm nay tôi mới nhớ ra, tôi thật có lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Trước đây, lúc vua Pha-ra-ôn giận quan hỏa đầu và tôi, vua đã tống giam chúng tôi vào trong dinh chỉ huy trưởng ngự lâm quân. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Một đêm kia, chúng tôi đều nằm mơ, giấc mơ mỗi người một khác. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Có một thanh niên Hê-bơ-rơ bị giam chung với chúng tôi, tên nô lệ của chỉ huy trưởng ngự lâm quân. Khi nghe thuật chiêm bao, anh ấy giải thích ý nghĩa theo giấc mơ mỗi người. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Quả nhiên, việc xảy ra đúng như lời anh ấy nói. Vua phục chức cho tôi và treo cổ viên hỏa đầu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Vua sai người gọi Giô-sép. Họ vội vã đem ông ra khỏi ngục. Sau khi cạo râu và thay áo, ông vào chầu vua Pha-ra-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Vua Pha-ra-ôn nói cùng Giô-sép: “Ta thấy chiêm bao, nhưng chẳng ai giải nghĩa được. Ta nghe nói ngươi có tài đoán mộng, nên ta cho gọi đến đây.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Giô-sép đáp: “Không phải tôi có tài gì, nhưng Đức Chúa Trời sẽ giải đáp thắc mắc cho vua.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Vua Pha-ra-ôn liền kể cùng Giô-sép: “Ta mơ thấy mình đứng bên bờ sông Nin. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Này, dưới sông, bảy con bò béo tốt đẹp đẽ lên bờ ăn cỏ. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Lại có bảy con bò khác hết sức xấu xí gầy guộc lên theo bảy con trước. Ta chưa hề thấy trong xứ Ai Cập có con bò nào xấu xí như thế. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bảy con bò gầy guộc xấu xí liền nuốt bảy con béo tốt. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ăn vào bụng rồi mà cũng như không vì vẫn gầy ốm như trước. Sau đó, ta thức giấc. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ta lại mơ thấy bảy bông lúa chắc mọc lên từ một cây lúa. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kế theo đó, bảy bông lúa lép xấu xí cũng mọc lên; chúng bị gió đông thổi héo. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Các bông lúa lép nuốt các bông lúa tốt. Ta đã kể cho các thuật sĩ nghe, nhưng chẳng ai giải được ý nghĩa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Giô-sép tâu: “Hai giấc mộng của vua Pha-ra-ôn có cùng một ý nghĩa. Đức Chúa Trời cho vua biết những việc Ngài sắp thực hiện: ");
INSERT INTO vieovcb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bảy con bò béo tốt—cũng như bảy bông lúa chắc—là bảy năm thịnh vượng được mùa. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bảy con bò gầy gò lên sau—cũng như bảy bông lúa lép bị gió đông thổi héo—là bảy năm đói kém. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Như tôi đã tâu, Đức Chúa Trời cho vua biết những việc Ngài sắp làm. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Khắp xứ Ai Cập sẽ thịnh vượng dư dật suốt bảy năm. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sau đó là bảy năm đói kém, mọi cảnh phồn thịnh trước kia của Ai Cập đều rơi vào quên lãng. Nạn đói sẽ làm cả xứ kiệt quệ. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Vì tai họa quá khủng khiếp, chẳng ai còn nhớ thời kỳ vàng son thịnh vượng nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Vua thấy chiêm bao hai lần, vì ý Đức Chúa Trời đã quyết định, Ngài sẽ sớm thực hiện việc này. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Bây giờ, vua Pha-ra-ôn nên chọn một người khôn ngoan sáng suốt làm tể tướng nước Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Vua Pha-ra-ôn cũng nên bổ nhiệm các viên chức trên khắp nước, để thu thập một phần năm hoa lợi trong bảy năm được mùa. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Lúa thu góp trong những năm được mùa sẽ tồn trữ trong kho của Vua Pha-ra-ôn tại các thành phố, ");
INSERT INTO vieovcb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","dùng làm lương thực cho dân chúng trong bảy năm đói kém. Có thế, nước Ai Cập mới khỏi bị nạn đói tiêu diệt.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Vua Pha-ra-ôn và quần thần hài lòng về lời giải của Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Vua Pha-ra-ôn bảo họ: “Còn ai hơn Giô-sép, người có Thần Linh của Đức Chúa Trời?” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Vua Pha-ra-ôn quay lại Giô-sép: “Đức Chúa Trời đã dạy cho ngươi biết mọi việc này, còn ai khôn ngoan sáng suốt hơn ngươi nữa? ");
INSERT INTO vieovcb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ngươi sẽ lãnh đạo cả nước, toàn dân sẽ vâng theo mệnh lệnh ngươi. Chỉ một mình ta lớn hơn ngươi mà thôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pha-ra-ôn lại nói với Giô-sép: “Này, ta lập ngươi cai trị toàn cõi Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Vua Pha-ra-ôn tháo nhẫn của mình đeo vào tay Giô-sép, cho mặc cẩm bào, đeo dây chuyền vàng lên cổ, và bảo: “Này! Ta lập ngươi làm tể tướng nước Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Vua cho chàng ngồi xe thứ hai của vua; phía trước có người hô lớn: “Hãy quỳ xuống.” Như thế, vua tấn phong Giô-sép làm tễ tướng Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Vua bảo Giô-sép: “Ta làm vua Pha-ra-ôn, nhưng ngươi có toàn quyền điều hành mọi việc trong nước Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Vua Pha-ra-ôn đặt tên cho Giô-sép là “Người Cứu Mạng” và gả A-sê-na (con gái của Phô-ti-phê, thầy trưởng tế thành Ôn) cho chàng. Vậy, Giô-sép nổi tiếng khắp nước Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Giô-sép được ba mươi tuổi khi nhậm chức. Từ cung vua Pha-ra-ôn nước Ai Cập, ông ra đi kinh lý khắp nước. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Trong bảy năm được mùa, lúa gạo sản xuất đầy dẫy mọi nơi. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Giô-sép thu góp lương thực từ các đồng ruộng nước Ai Cập, chở về các thành phố trung tâm của các vùng đó. Lúa gạo vùng nào đều trữ ở thành phố vùng đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Giô-sép thu lúa nhiều như cát trên bờ biển, nhiều đến nỗi không thể cân lường được. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Trước những năm đói kém, A-sê-na (vợ Giô-sép, con gái Phô-ti-phê, thầy trưởng tế thành Ôn) sinh hai con trai. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Giô-sép đặt tên con đầu lòng là Ma-na-se, vì ông nói: “Đức Chúa Trời cho ta quên mọi nỗi gian khổ tha hương.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Con thứ hai tên là Ép-ra-im, vì ông nói: “Đức Chúa Trời cho ta thịnh đạt trong nơi khốn khổ.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sau bảy năm được mùa tại Ai Cập, ");
INSERT INTO vieovcb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","đến bảy năm đói kém, đúng như lời Giô-sép đoán trước. Mọi quốc gia chung quanh đều đói; chỉ riêng Ai Cập vẫn còn lương thực. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Khi người Ai Cập bị đói, họ kéo đến hoàng cung xin vua cấp gạo. Vua bảo: “Cứ hỏi Giô-sép và làm mọi điều Giô-sép chỉ dạy.” ");
INSERT INTO vieovcb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Khi nạn đói lan rộng khắp nước, Giô-sép mở kho bán lúa cho dân, vì nạn đói thật trầm trọng trong cả nước Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Khi các nước bị đói lớn, tất cả các dân tộc đều đến Ai Cập mua lúa từ Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nghe nước Ai Cập có lúa, Gia-cốp bảo các con: “Sao các con cứ ngồi đó, nhịn đói mà nhìn nhau? ");
INSERT INTO vieovcb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Này, cha nghe bên Ai Cập có bán lúa, các con qua đó mua, để chúng ta khỏi chết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Mười người anh Giô-sép lên đường qua Ai Cập mua lúa. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Gia-cốp không cho Bên-gia-min, em Giô-sép, đi theo các anh, vì sợ bị nguy hiểm. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Vậy, các con trai Ít-ra-ên đến Ai Cập mua lúa cùng với bao nhiêu người khác, vì xứ Ca-na-an cũng bị đói lớn. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Lúc ấy, Giô-sép làm tể tướng nước Ai Cập, kiêm việc bán lúa cho dân chúng. Các anh Giô-sép đến quỳ gối, sấp mình xuống đất trước mặt ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Thấy họ, Giô-sép nhận ra ngay nhưng giả vờ không biết và gay gắt hỏi: “Các anh ở đâu tới?” Họ đáp: “Chúng tôi từ Ca-na-an đến mua lúa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Dù Giô-sép biết họ, họ vẫn không nhận ra ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nhớ lại giấc mơ về các anh ngày trước, ông quát: “Các anh làm gián điệp, đến đây do thám đất nước ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Họ phân trần: “Thưa ngài, các đầy tớ ngài đây chỉ đến mua lương thực. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Chúng tôi đều là anh em ruột, thuộc gia đình lương thiện, không phải là gián điệp.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Giô-sép quả quyết: “Không, các anh chỉ đến đây do thám để biết rõ nhược điểm của đất nước này.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Họ lại thưa: “Các đầy tớ ngài đây gồm mười hai người, anh em cùng cha, quê tại Ca-na-an. Hiện người út ở nhà với cha, còn một người mất tích.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Giô-sép đáp: “Như ta đã nói, các anh làm gián điệp. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Đây là cách ta thử các anh. Ta thề trên mạng sống của vua Pha-ra-ôn, các anh chẳng được rời khỏi Ai Cập nếu em út các anh không đến đây. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Một người trong các anh phải trở về đem em út đến, còn tất cả sẽ bị giam vào ngục. Ta sẽ kiểm chứng lời khai của các anh. Nếu nói dối, chắc hẳn các anh là gián điệp.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Sau đó, Giô-sép giam họ trong ngục ba ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ngày thứ ba, Giô-sép bảo họ: “Ta kính sợ Đức Chúa Trời, nên ta sẽ đối xử khoan hồng với các anh. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nếu các anh lương thiện, ta chỉ giam giữ một người, còn tất cả được về nhà, mang theo lương thực nuôi gia đình. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Sau đó, các anh phải trở lại đây với người em út để xác nhận lời khai của các anh. Nếu các anh nói thật, các anh sẽ được trả tự do.” Họ vâng lệnh Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Các anh em bảo nhau: “Chúng ta mắc họa vì có tội với em chúng ta. Lúc nó đau khổ tuyệt vọng van xin, chúng ta đã chẳng thương xót.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ru-bên trách: “Tôi đã bảo đừng hại đứa trẻ mà các chú không nghe. Bây giờ chúng ta phải trả nợ máu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Họ không ngờ Giô-sép nghe và hiểu, vì lúc nói chuyện ông vẫn dùng người thông dịch. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Giô-sép bước ra ngoài khóc; sau đó ông quay lại và sai người trói Si-mê-ôn trước mặt họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ông ra lệnh cho đầy tớ đổ lúa vào bao các anh, để bạc lại trong mỗi bao, cũng cấp thêm lương thực đi đường. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Các anh em chất lúa trên lưng lừa và lên đường. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Đến quán trọ, một người mở bao lúa cho lừa ăn, thấy bạc mình trong miệng bao, ");
INSERT INTO vieovcb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","liền gọi các anh em: “Này, sao người ta để bạc của tôi lại trong bao?” Họ kinh sợ, run rẩy, và bảo nhau: “Đức Chúa Trời làm gì cho chúng ta vậy?” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Họ về nhà Gia-cốp, cha mình, tại xứ Ca-na-an, và tường trình mọi việc: ");
INSERT INTO vieovcb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Tể tướng nước Ai Cập nói rất gay gắt, tình nghi chúng con làm gián điệp. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Chúng con thưa: ‘Chúng tôi là người lương thiện, không phải gián điệp. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Chúng tôi có mười hai người, anh em cùng cha, một người mất tích, người út ở nhà với cha, tại xứ Ca-na-an.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tể tướng bảo chúng con: ‘Đây là cách ta xét lời khai các anh. Hãy để một người ở đây làm con tin, còn các anh đem lương thực về nuôi gia đình. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Sau đó, các anh đưa em út đến để chứng tỏ các anh lương thiện, không làm gián điệp. Ta sẽ thả người kia và các anh được tự do đến xứ này mua lúa.’” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Khi các anh em mở bao đổ lúa ra, họ thấy bạc mỗi người vẫn còn trong bao; cả nhà đều sợ hãi. ");
INSERT INTO vieovcb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Gia-cốp than trách: “Chúng mày làm mất con tao—Giô-sép và Si-mê-ôn—bây giờ còn muốn đem Bên-gia-min đi nữa. Sao tao khổ quá thế này!” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ru-bên thưa: “Nếu con không đem em về, xin cha cứ giết hai đứa con của con. Cha giao em cho con, con xin chịu trách nhiệm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Gia-cốp đáp: “Con tao sẽ không đi với chúng mày đâu. Anh nó chết, tao chỉ còn một mình nó. Nếu nó bị nguy hiểm dọc đường, lão già này sẽ sầu khổ mà chết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nạn đói càng thêm trầm trọng. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Khi gia đình ăn hết lương thực đem từ Ai Cập về, Gia-cốp bảo các con: “Hãy đi một chuyến nữa và mua ít lương thực về dùng.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Giu-đa thưa: “Tể tướng ấy đã nghiêm khắc bảo chúng con: ‘Nếu không đem đứa út theo, đừng trở lại gặp mặt ta nữa.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nếu cha bằng lòng cho em đi, chúng con mới mua lương thực được. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Nếu không, chúng con không đi, vì tể tướng ấy nói quả quyết lắm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ít-ra-ên trách: “Sao chúng mày hại tao mà mách với ông ấy chúng mày còn một đứa em nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Họ đáp: “Ông ấy hỏi chúng con rất kỹ về gia đình: ‘Cha các anh còn sống không? Còn người em nào nữa không?’ Chúng con cứ theo đó trả lời. Làm sao biết trước ông ấy bảo phải đem em xuống?” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Giu-đa thưa với Ít-ra-ên: “Xin cha giao em cho con, chúng con xin lên đường để tất cả chúng ta—cha, chúng con, và các cháu nhỏ—khỏi chết đói. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Con xin bảo lãnh em và chịu hoàn toàn trách nhiệm. Nếu con không đem em về cho cha, con sẽ mang tội với cha suốt đời. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nếu không trì hoãn, chúng con đã đi được hai chuyến rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ít-ra-ên nói: “Đã thế, các con phải chọn sản phẩm trong xứ làm lễ vật dâng cho ông ấy—nhựa thơm, mật ong, hương liệu, hạt đào, và hạnh nhân. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Các con cũng đem theo hai phần tiền để trả lại tiền trong miệng bao, vì có lẽ họ nhầm lẫn. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Các con hãy đem em xuống đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Cầu Đức Chúa Trời Toàn Năng cho các con được ông ấy thương xót, để tha cho Si-mê-ôn và Bên-gia-min về với các con. Còn cha nếu phải mất con, cũng đành chịu chứ biết sao.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Các anh em đem lễ vật, hai phần bạc, và dẫn Bên-gia-min xuống Ai Cập; họ ra mắt Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Thấy Bên-gia-min đi với các anh, Giô-sép bảo quản gia: “Anh đưa mấy người này vào nhà và chuẩn bị dọn tiệc, vì trưa nay họ sẽ ăn với ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Quản gia vâng lệnh, dẫn các anh em vào tư dinh Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Thấy mình bị dẫn vào nhà Giô-sép, mấy anh em sợ hãi và bảo nhau: “Vì số bạc để lại trong bao, mà họ dẫn chúng ta vào đây để bắt chúng ta làm nô lệ và cướp lừa của chúng ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Các anh em bước đến gần cửa và trình với quản gia của Giô-sép: ");
INSERT INTO vieovcb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Thưa ông, kỳ trước chúng tôi đến mua lương thực, ");
INSERT INTO vieovcb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","khi về quán trọ mở bao ra, chúng tôi thấy bạc mỗi người còn nguyên trong miệng bao. Hiện chúng tôi có đem bạc ấy theo đây, ");
INSERT INTO vieovcb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","cùng với tiền mua lương thực kỳ này. Ai đã bỏ bạc vào bao, chúng tôi chẳng biết.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Quản gia đáp: “Các anh cứ an tâm, đừng sợ. Đức Chúa Trời của các anh và cha của các anh đã cho các anh bạc đó. Còn bạc mua lúa, chúng tôi đã nhận đủ.” Tiếp đó, quản gia thả Si-mê-ôn và đem anh ấy đến với họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tất cả anh em được vào dinh Giô-sép, được cho nước rửa chân, và lừa được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Các anh em soạn lễ vật dâng Giô-sép trưa hôm ấy, vì họ được mời ăn tiệc tại dinh. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Khi Giô-sép về, các anh em đem lễ vật đến dâng và quỳ gối sấp mình trước mặt ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ông chào thăm họ và hỏi: “Cha các anh còn sống không? Mạnh khỏe không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Họ đáp: “Đầy tớ ông, thân phụ chúng tôi, vẫn còn sống mạnh khỏe.” Họ sấp mình tỏ lòng tôn kính. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Giô-sép nhìn thấy Bên-gia-min, em ruột mình, liền hỏi: “Đây có phải em út mà các anh đã hứa đem đến không?” Và tiếp: “Cầu xin Đức Chúa Trời ban phước lành cho em.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Nhìn thấy em, Giô-sép vô cùng xúc động, vội đi vào phòng riêng mà khóc. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Rửa mặt xong, ông bước ra, cố giữ vẻ điềm tĩnh, Giô-sép nói: “Dọn thức ăn đi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Người nhà dọn cho Giô-sép ăn riêng, các anh em ngồi bàn khác, và người Ai Cập dự tiệc cũng ngồi riêng, vì người Ai Cập ghê tởm người Hê-bơ-rơ nên không bao giờ ăn chung. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Giô-sép xếp các anh em ngồi theo thứ tự, từ anh cả đến em út, khiến họ kinh ngạc nhìn nhau. ");
INSERT INTO vieovcb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Thức ăn từ bàn Giô-sép đưa qua bàn các anh em. Phần của Bên-gia-min nhiều gấp năm lần của các anh. Ai nấy đều ăn uống vui vẻ với Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Giô-sép ra lệnh cho quản gia: “Hãy đổ thật nhiều lúa cho họ, sức họ chở được bao nhiêu, cứ đổ đầy bấy nhiêu. Còn bạc mua lúa cứ trả lại vào bao mỗi người. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ngươi cũng hãy để chén bạc của ta vào miệng bao của người út, chung với tiền mua lúa.” Quản gia vâng lệnh Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sáng sớm hôm sau, các anh em và đoàn lừa lên đường. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Khi họ ra khỏi thành chưa xa, Giô-sép bảo quản gia: “Hãy đuổi theo những người đó, chặn họ lại hỏi: ‘Tại sao các anh lấy oán trả ân như thế? ");
INSERT INTO vieovcb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Sao nhẫn tâm đánh cắp cái chén bạc của chủ ta dùng uống rượu và bói toán? Các anh đã làm một điều ác đó!’ ” ");
INSERT INTO vieovcb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Quản gia đuổi kịp và nói với họ những lời của Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Họ ngạc nhiên: “Tại sao ông nói thế? Chúng tôi không phải hạng người xấu như ông nghĩ đâu. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Số bạc trong các bao lúa, từ Ca-na-an chúng tôi còn đem xuống trả lại cho ngài đầy đủ, lẽ nào còn ăn cắp vàng bạc trong nhà chủ ông? ");
INSERT INTO vieovcb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nếu ông tìm thấy chén bạc nơi ai, người ấy phải chết, còn chúng tôi sẽ làm nô lệ cho chủ ông.” ");
INSERT INTO vieovcb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Quản gia đáp: “Thôi được, chỉ người ăn cắp bị bắt làm nô lệ, còn tất cả vô can.” ");
INSERT INTO vieovcb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Các anh em vội vàng hạ các bao lúa trên lưng lừa xuống đất và mở ra. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Quản gia lần lượt khám từ bao của anh cả đến bao của em út. Chén bạc được tìm thấy trong bao của Bên-gia-min. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Các anh em thất vọng, xé áo, chất lúa lên lưng lừa, và trở lại thành. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Giu-đa và các anh em vào dinh Giô-sép; lúc ấy ông vẫn còn đó. Họ quỳ dưới đất, trước mặt ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Giô-sép hỏi: “Các anh làm gì thế? Không biết rằng ta có tài bói toán sao?” ");
INSERT INTO vieovcb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Giu-đa thưa: “Chúng tôi không biết phải nói năng thế nào, hay phải tự biện hộ làm sao đây, vì Đức Chúa Trời đã phạt chúng tôi về những tội ác của chúng tôi rồi. Chúng tôi và người lấy chén bạc xin trở lại làm nô lệ cho ông.” ");
INSERT INTO vieovcb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Giô-sép đáp: “Không, ta chỉ giữ người lấy chén bạc làm nô lệ cho ta, còn các anh được tự do về nhà cha.” ");
INSERT INTO vieovcb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Giu-đa bước đến gần và phân trần: “Xin cho đầy tớ ngài được biện bạch đôi lời. Xin đừng nổi giận với kẻ hèn này, vì uy quyền ngài ngang hàng với vua Pha-ra-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Trước đây, ngài hỏi chúng tôi còn cha hay anh em nào nữa không. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Chúng tôi thưa là còn cha già và đứa em út ra đời lúc cha đã cao tuổi. Anh nó đã chết. Trong số các con cùng một mẹ, nó là đứa duy nhất còn sống, nên cha cưng nó lắm. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ngài dạy chúng tôi đem nó đến cho ngài thấy mặt. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Chúng tôi thưa: ‘Nó không thể lìa cha; nếu nó đi, cha sẽ chết.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ngài lại bảo nếu em út không đến, chúng tôi không được gặp ngài nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Chúng tôi về trình lại với cha những lời ngài dạy. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Sau đó, cha bảo chúng tôi trở lại mua ít lương thực. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Chúng tôi thưa: ‘Nếu em út không đi cùng, chúng con không thể xuống đây. Vì chúng con không thể gặp tể tướng nếu không có nó.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Cha chúng tôi than: ‘Vợ ta sinh cho ta hai con trai, ");
INSERT INTO vieovcb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","một đứa đi mất, chắc đã bị thú dữ xé xác, vì đến nay vẫn chưa thấy về. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nếu chúng bay đem đứa này đi nữa, rủi nó bị nguy hiểm, thân già này sẽ sầu khổ mà chết.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Thưa ngài, mạng sống cha tôi tùy thuộc nơi mạng sống đứa trẻ. Bây giờ, nếu tôi không đem nó về nhà, ");
INSERT INTO vieovcb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","khi thấy tôi mà không thấy nó, chắc chắn cha tôi sẽ chết. Vậy, chính chúng tôi làm cho cha già chết trong sầu khổ. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kẻ hèn này đã xin cha cho bảo lãnh đứa trẻ: ‘Nếu không đem em về cho cha, con sẽ mang tội với cha suốt đời.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Vậy, xin ngài cho tôi ở lại làm nô lệ thay cho em tôi, để nó về nhà với các anh nó. ");
INSERT INTO vieovcb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Làm sao tôi có thể về với cha mà không có nó? Lẽ nào tôi phải chứng kiến thảm họa xảy đến cho cha tôi sao?” ");
INSERT INTO vieovcb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Giô-sép không thể nào đè nén cảm xúc được nữa. Ông la lớn và đuổi hết các gia nhân: “Tất cả hãy ra ngoài!” Vậy, trong phòng chỉ còn Giô-sép và các anh em. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ông khóc nức nở đến nỗi những người Ai Cập và cả hoàng cung Pha-ra-ôn đều nghe. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ông tỏ thật với các anh em: “Tôi là Giô-sép. Cha tôi còn sống không?” Trước việc quá bất ngờ, các anh em kinh ngạc sửng sốt, không trả lời được. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ông ôn tồn: “Các anh em lại đây.” Họ bước lại gần. Ông tiếp: “Tôi là Giô-sép, đứa em mà các anh đã bán qua xứ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bây giờ đừng buồn phiền trách móc nhau về việc ấy nữa, vì Đức Chúa Trời sai tôi đến đây trước để bảo toàn mạng sống các anh. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nạn đói đã hoành hành hai năm nay, và còn những năm năm mất mùa nữa. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Đức Chúa Trời đưa tôi đến đây trước để giải cứu các anh khỏi nạn đói, cho dòng dõi các anh được trường tồn. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Không phải tại các anh, nhưng Đức Chúa Trời xếp đặt cho tôi đến đây làm cố vấn cho vua và làm tể tướng, cầm quyền cả nước Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Các anh hãy về nhà gấp và thưa với cha: ‘Giô-sép, con của cha, nhắn rằng: Đức Chúa Trời đã lập con làm tể tướng nước Ai Cập. Xin cha xuống đây với con, đừng trì hoãn. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Cha sẽ sống tại xứ Gô-sen, như thế, cha sẽ sống gần con cùng các anh em, các cháu, bầy chiên, bầy bò, và mọi tài sản của cha. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Con sẽ cung cấp lương thực để cha và mọi người trong nhà ta khỏi phải đói khổ, vì còn đến năm năm đói kém nữa.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Này, các anh và Bên-gia-min, em tôi, đã chứng kiến chính tôi nói chuyện với các anh em. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Các anh em hãy thuật cho cha nghe vinh quang và uy quyền của tôi tại Ai Cập; hãy mau đưa cha đến đây.” ");
INSERT INTO vieovcb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Giô-sép ôm choàng lấy Bên-gia-min, em mình, mà khóc. Bên-gia-min cũng khóc. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Giô-sép hôn các anh và khóc. Kế đó, các anh em nói chuyện với Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Vua Ai Cập được tin anh em của Giô-sép đã đến. Vua và quần thần rất mừng. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Vua Pha-ra-ôn sốt sắng bảo Giô-sép: “Hãy bảo anh em ngươi chuẩn bị lừa trở về xứ Ca-na-an, ");
INSERT INTO vieovcb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","rước cha ngươi và toàn gia đình đến đây. Ta sẽ cho các ngươi phần đất tốt nhất của Ai Cập và các ngươi sẽ hưởng hoa màu của đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ngươi hãy lấy xe ngựa Ai Cập để cho họ đem về chở vợ con và rước cha ngươi đến đây. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Đừng tiếc tài sản mình, vì sản vật tốt nhất của Ai Cập sẽ thuộc về các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Các con trai Ít-ra-ên liền sửa soạn lên đường. Theo lệnh vua, Giô-sép cấp cho họ xe ngựa, cùng với lương thực đi đường. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Giô-sép cũng cấp y phục cho mỗi người, riêng Bên-gia-min thì được năm bộ áo và 300 lạng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Giô-sép gửi về cho cha mười con lừa chở sản vật quý của Ai Cập cùng với mười lừa cái chở gạo, bánh, và lương thực cho cha đi đường. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Giô-sép tiễn các anh em lên đường và căn dặn: “Xin đừng cãi nhau dọc đường.” ");
INSERT INTO vieovcb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Từ Ai Cập, các anh em hăm hở trở về nhà Gia-cốp, cha mình, tại xứ Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Họ hớn hở thưa: “Giô-sép hãy còn sống và làm tể tướng của nước Ai Cập!” Gia-cốp vẫn thờ ơ, lạnh lùng, và không tin lời họ. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Khi nghe các con thuật những lời Giô-sép nhắn và nhìn thấy các cỗ xe ngựa Giô-sép gửi về, tinh thần Gia-cốp liền hồi tỉnh. ");
INSERT INTO vieovcb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ông nói: “Đúng rồi, Giô-sép, con ta, còn sống. Ta sẽ đi thăm nó trước khi qua đời.” ");
INSERT INTO vieovcb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ít-ra-ên dọn tất cả đồ đạc lên đường. Đến Bê-e-sê-ba, ông dâng lễ vật lên Đức Chúa Trời của Y-sác, cha mình. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Trong khải tượng ban đêm, Đức Chúa Trời gọi ông: “Gia-cốp, Gia-cốp!” Ông đáp: “Thưa Chúa, con đây.” ");
INSERT INTO vieovcb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Chúa dạy: “Ta là Đức Chúa Trời, Đức Chúa Trời của cha con. Đừng sợ đi Ai Cập, vì Ta sẽ cho dòng dõi con thành một dân tộc lớn tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ta sẽ xuống Ai Cập với con và sẽ đưa dòng dõi con trở về. Lúc con qua đời, Giô-sép sẽ vuốt mắt con.” ");
INSERT INTO vieovcb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Gia-cốp rời Bê-e-sê-ba. Các con trai Ít-ra-ên chở cha và vợ con họ trên đoàn xe ngựa mà vua Pha-ra-ôn đã gửi đến. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Họ cũng đem theo súc vật và của cải đã gây dựng tại xứ Ca-na-an. Gia-cốp và cả gia đình đi xuống Ai Cập, ");
INSERT INTO vieovcb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","gồm các con trai, con gái, cháu trai, và cháu gái—cả dòng dõi ông. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Đây là tên con cháu Ít-ra-ên—con trai của Gia-cốp— những người đã đến Ai Cập: Ru-bên, con trưởng nam của Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Các con trai Ru-bên là Hê-nóc, Pha-lu, Hết-rôn, và Cát-mi. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Các con trai của Si-mê-ôn là Giê-mu-ên, Gia-min, Ô-hát, Gia-kin, Xô-ha, và Sau-lơ (mẹ Sau-lơ là người Ca-na-an). ");
INSERT INTO vieovcb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Các con trai của Lê-vi là Ghẹt-sôn, Kê-hát, và Mê-ra-ri. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Các con trai của Giu-đa là Ê-rơ, Ô-nan, Sê-la, Phê-rết, và Xê-rách. Ê-rơ và Ô-nan đã qua đời tại xứ Ca-na-an. Các con trai của Phê-rết là Hết-rôn và Ha-mun. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Các con trai của Y-sa-ca là Thô-la, Phu-va, Gióp, và Sim-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Các con trai của Sa-bu-luân là Sê-rết, Ê-luân, và Gia-lê-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Đây là các con trai của Lê-a sinh cho Gia-cốp tại Pha-đan A-ram, và một con gái là Đi-na, cùng con cái họ. Tổng cộng là ba mươi ba người. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Các con trai của Gát: Xi-phi-ôn, Ha-ghi, Su-ni, Ét-bôn, Ê-ri, A-rô-đi, và A-rê-li. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Các con trai của A-se là Im-na, I-sua, I-sui, Ích-vi, Bê-ri-a, và con gái là Sê-ra. Các con trai Bê-ri-a là Hê-be và Manh-ki-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Đây là các con của Xinh-ba (nữ tì mà La-ban cho Lê-a) sinh cho Gia-cốp, và con cái họ. Tổng cộng là mười sáu người. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Các con trai của Ra-chên (vợ Gia-cốp) là Giô-sép và Bên-gia-min. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","A-sê-na (con gái của Phô-ti-phê, thầy trưởng tế thành Ôn) đã sinh cho Giô-sép hai con trai tại nước Ai Cập là Ma-na-se và Ép-ra-im. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Các con trai của Bên-gia-min là Bê-la, Bê-ka, Ách-bên, Ghê-ra, Na-a-man, Ê-hi, Rô-sơ, Mốp-bim, Hốp-bim, và A-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Đây là các con trai của Ra-chên sinh cho Gia-cốp, và con cái họ. Tổng cộng là mười bốn người. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Con trai của Đan là Hu-sim. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Các con trai của Nép-ta-li là Gia-xên, Gu-ni, Giê-xe, và Si-lem. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Vậy, các con trai của Bi-la (nữ tì mà La-ban cho Ra-chên) sinh cho Gia-cốp, và con cái họ. Tổng cộng là bảy người. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tất cả con cháu Gia-cốp xuống Ai Cập, không kể con dâu, là sáu mươi sáu người. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Giô-sép đã sinh hai con trai tại Ai Cập. Vậy, tổng cộng người nhà Gia-cốp, đến Ai Cập là bảy mươi người. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Gia-cốp sai Giu-đa đi trước gặp Giô-sép để Giô-sép dẫn đường cha vào xứ Gô-sen. Vậy, họ đến Gô-sen. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Giô-sép lên xe đi đón Ít-ra-ên, cha mình, tại Gô-sen. Khi gặp nhau, ông ôm cha khóc một hồi lâu. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ít-ra-ên nói với Giô-sép: “Bây giờ cha chết thật an tâm, vì đã gặp mặt con, thấy con còn sống.” ");
INSERT INTO vieovcb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Giô-sép nói với các anh em và tất cả người nhà: “Tôi sẽ lên gặp vua Pha-ra-ôn để báo tin là các anh em và toàn gia đình tôi đã từ xứ Ca-na-an đến đây. ");
INSERT INTO vieovcb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tôi sẽ tâu: ‘Họ là mục đồng, chuyên nghề chăn nuôi gia súc. Họ đem theo bầy chiên, bầy bò, và tất cả tài sản.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Vậy, khi nào vua gọi và hỏi các anh: ‘Các ngươi làm nghề gì?’ ");
INSERT INTO vieovcb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Các anh hãy tâu: ‘Từ nhỏ đến giờ, chúng tôi chăn nuôi súc vật, cũng như tổ tiên chúng tôi.’ Như thế, vua sẽ cho các anh em ở xứ Gô-sen, vì người Ai Cập ghê tởm người chăn nuôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Giô-sép vào tâu vua Pha-ra-ôn: “Cha và anh em tôi đã từ xứ Ca-na-an đến đây, với bầy chiên, bầy bò, và mọi tài sản. Hiện nay họ ở Gô-sen.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Giô-sép đưa năm anh em đến yết kiến vua Pha-ra-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Vua Pha-ra-ôn hỏi: “Các ngươi làm nghề gì?” Họ tâu: “Chúng tôi chăn nuôi súc vật, cũng như tổ tiên chúng tôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Xứ Ca-na-an bị đói lớn, chẳng còn đồng cỏ cho súc vật nên chúng tôi đến đây cư trú. Xin vua cho chúng tôi ở xứ Gô-sen.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Vua Pha-ra-ôn bảo Giô-sép: “Cha và anh em ngươi đã đến đây. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Trong cả nước Ai Cập, hãy chọn nơi nào tốt nhất cho họ. Ta nghĩ đất Gô-sen rất thích hợp. Ngươi cũng hãy tuyển người tài giỏi trong vòng họ để chăn bầy súc vật của ta.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Giô-sép cũng đưa cha đến gặp vua. Gia-cốp chúc phước cho vua. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Vua hỏi thăm Gia-cốp về tuổi tác. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Gia-cốp đáp: “Thưa vua, tôi được 130 tuổi, đời du mục của tôi rất ngắn ngủi và cực nhọc so với đời du mục của tổ tiên tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Trước khi từ giã, Gia-cốp lại chúc phước cho vua Pha-ra-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Giô-sép chọn chỗ tốt nhất trong nước Ai Cập cho cha và các anh em định cư, tại miền Ram-se, đúng theo lệnh vua. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Tùy theo số khẩu phần, Giô-sép cung cấp lương thực cho cha và các anh em. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nạn đói trở nên quá trầm trọng. Cả xứ Ai Cập và xứ Ca-na-an đều kiệt quệ, chẳng còn lương thực. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Giô-sép bán lúa, thu hết tiền bạc trong xứ Ai Cập, xứ Ca-na-an, và chứa trong kho hoàng cung Pha-ra-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Khi tiền bạc đã hết, người Ai Cập và người Ca-na-an đến kêu cầu Giô-sép: “Xin cấp lương thực cho chúng tôi, không lẽ vì hết tiền mà chúng tôi phải chết đói sao?” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Giô-sép đáp: “Nếu hết tiền, các ngươi đem gia súc đến đổi lấy lương thực.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Vậy họ đem gia súc đến, nào là chiên, bò, ngựa, lừa, để đổi lấy lương thực nơi Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Qua năm sau, người Ai Cập lại đến xin Giô-sép: “Ông thừa biết tiền bạc chúng tôi đã cạn, gia súc ông cũng mua rồi, chúng tôi chẳng còn gì ngoài bản thân và ruộng đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tại sao ông để chúng tôi chết và đất ruộng hoang vu? Hãy mua chúng tôi và ruộng đất bằng lương thực. Chúng tôi làm nô lệ cho vua Pha-ra-ôn để đổi lấy lúa, nhờ đó chúng tôi thoát chết, đất ruộng khỏi hoang tàn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Vì nạn đói quá lớn, mọi người Ai Cập đều bán ruộng. Giô-sép mua tất cả ruộng đất cho vua; ruộng đất Ai Cập trở thành tài sản của nhà vua; ");
INSERT INTO vieovcb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","và toàn dân Ai Cập từ nam đến bắc đều phải dọn về thành phố. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tuy nhiên, Giô-sép không mua ruộng của các thầy tư tế, vì họ được vua Pha-ra-ôn cấp phát lương thực, khỏi phải bán ruộng. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Giô-sép tuyên bố với dân: “Ngày nay, ta mua các ngươi và ruộng đất cho vua Pha-ra-ôn. Đây, ta giao hạt giống để các ngươi gieo trồng. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Đến mùa gặt, hãy nạp một phần năm cho vua; còn bốn phần thuộc về các ngươi, để làm hạt giống cho mùa sau và làm lương thực cho gia đình các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Dân chúng đáp: “Ông đã cứu mạng chúng tôi. Được ông thương xót, chúng tôi vui lòng làm nô lệ cho vua Pha-ra-ôn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Vậy, Giô-sép lập ra luật này cho nước Ai Cập (đến bây giờ hãy còn): một phần năm hoa lợi của đồng ruộng phải nạp cho vua, ngoại trừ ruộng của các thầy tư tế. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ít-ra-ên định cư tại Gô-sen, nước Ai Cập, gây dựng sự nghiệp, và họ sinh sôi nẩy nở nhanh chóng. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Gia-cốp sống mười bảy năm tại Ai Cập, thọ 147 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ngày gần qua đời, Gia-cốp sai gọi Giô-sép đến bảo: “Con vui lòng giúp cha việc này: Con hãy đặt tay lên đùi cha, lấy lòng ngay thẳng thành thật mà thề là sẽ không chôn cha tại Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Khi cha qua đời, hãy đem thi thể cha ra khỏi Ai Cập, và đem chôn bên phần mộ của tổ tiên.” Giô-sép thưa: “Con sẽ làm mọi điều cha dặn.” ");
INSERT INTO vieovcb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Gia-cốp bảo: “Con hãy thề.” Vậy Giô-sép thề, còn Ít-ra-ên quỳ bên đầu giường. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sau đó ít lâu, Giô-sép hay tin cha bị đau, ông liền dẫn hai con là Ma-na-se và Ép-ra-im đến thăm. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nghe Giô-sép đến, Gia-cốp cố gắng ngồi dậy trên giường. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Gia-cốp bảo Giô-sép: “Đức Chúa Trời Toàn Năng đã hiện đến và ban phước cho cha tại Lu-xơ, xứ Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ngài bảo: ‘Ta sẽ làm cho con sinh sôi nẩy nở nhanh chóng và trở thành một dân tộc đông đảo. Ta sẽ ban xứ này cho dòng dõi con làm cơ nghiệp vĩnh viễn.’ ");
INSERT INTO vieovcb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Bây giờ, Ép-ra-im và Ma-na-se, hai đứa con trai con, đã sinh tại Ai Cập trước khi cha đến, sẽ thuộc về cha, và hưởng cơ nghiệp của cha như Ru-bên và Si-mê-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Còn những đứa con sinh sau sẽ thuộc về con và hưởng cơ nghiệp của con thế cho Ép-ra-im và Ma-na-se. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Khi cha đi đường từ Pha-đan về Ca-na-an, gần đến Ép-ra-ta, mẹ con từ biệt cha, qua đời. Cha chôn mẹ bên con đường về Bết-lê-hem.” ");
INSERT INTO vieovcb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Thấy hai con Giô-sép, Ít-ra-ên liền hỏi: “Các cháu đó phải không?” ");
INSERT INTO vieovcb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Giô-sép thưa: “Vâng, đây là hai con trai Đức Chúa Trời đã cho con tại Ai Cập.” Gia-cốp bảo: “Dẫn lại đây để cha chúc phước lành cho hai cháu.” ");
INSERT INTO vieovcb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Vì tuổi già, Ít-ra-ên không nhìn thấy rõ, nên Giô-sép dắt hai con lại gần cho cha ôm hôn chúng nó. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ít-ra-ên nói với Giô-sép: “Trước kia, cha tưởng không bao giờ thấy lại mặt con, mà bây giờ Đức Chúa Trời cho cha thấy được các cháu nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Giô-sép đỡ hai con ra khỏi đầu gối và khom lưng cúi mặt xuống đất. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Tay phải ông nắm Ép-ra-im để đưa sang phía trái Ít-ra-ên; tay trái ông nắm Ma-na-se để đưa sang phía tay phải của cha. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ít-ra-ên đặt tay phải lên đầu Ép-ra-im, đứa nhỏ; và tay trái lên đầu Ma-na-se, đứa lớn. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ông chúc phước lành cho Giô-sép: “Cầu xin Đức Chúa Trời của Áp-ra-ham và Y-sác, mà tổ phụ con đã tôn thờ, là Đức Chúa Trời đã chăn dắt con từ khi ra đời cho đến nay, ");
INSERT INTO vieovcb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","là thiên sứ đã giải cứu con khỏi mọi tai họa, xin ban phước lành cho hai đứa trẻ này, nguyện chúng nó nối danh con, cũng như danh Áp-ra-ham và Y-sác là các tổ phụ con, nguyện dòng dõi chúng nó gia tăng đông đảo trên mặt đất.” ");
INSERT INTO vieovcb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Khi thấy cha đặt tay phải lên đầu Ép-ra-im, Giô-sép không bằng lòng, nên cầm tay ấy đặt qua đầu Ma-na-se. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ông nói: “Thưa cha, cha nhầm rồi. Đứa này là con trưởng, cha nên đặt tay phải lên đầu nó.” ");
INSERT INTO vieovcb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Gia-cốp không chịu: “Cha biết chứ, không phải nhầm đâu con. Ma-na-se sẽ thành một dân tộc lớn, nhưng em nó sẽ lớn hơn, dòng dõi sẽ đông đảo vô cùng.” ");
INSERT INTO vieovcb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Gia-cốp lại chúc phước cho hai đứa trẻ: “Vì hai cháu mà sau này người Ít-ra-ên sẽ chúc nhau: Cầu Đức Chúa Trời ban cho anh được giống như Ép-ra-im và Ma-na-se.” Vậy, Gia-cốp đặt Ép-ra-im trước Ma-na-se. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ít-ra-ên nói với Giô-sép: “Cha sắp qua đời, nhưng Đức Chúa Trời sẽ ở với các con và đưa các con về quê hương Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Cha sẽ cho con phần đất nhiều hơn các anh em, là đất người A-mô-rít mà cha đã chiếm được bằng cung gươm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Gia-cốp bảo các con trai hội họp lại để nghe ông nói trước việc tương lai của họ: ");
INSERT INTO vieovcb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Các con trai Gia-cốp, hãy họp lại đây; để nghe lời của Ít-ra-ên, cha của các con. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Con trưởng nam Ru-bên, là sinh lực và sức mạnh cha, với vinh dự và quyền năng tột đỉnh. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nhưng con bồng bột như thủy triều, nên đánh mất quyền huynh trưởng. Vì con đã vào phòng cha; làm ô uế giường cha. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Hai anh em Si-mê-ôn và Lê-vi; sử dụng khí giới quá bạo tàn. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Linh hồn ta! Hãy tránh xa chúng nó; tâm linh ta! Chớ tham gia việc bất nhân. Trong căm hờn, gây cảnh thịt rơi máu đổ, và vui chơi bằng cách bắt bò cắt gân. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Cơn giận chúng nó bị nguyền rủa; vì quá độc địa và hung hăng. Cha sẽ tách chúng ra trong nhà Gia-cốp và phân tán dòng dõi hai con khắp lãnh thổ Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Giu-đa! Con được các anh em ca tụng. Vì con chiến thắng kẻ thù xâm lăng. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Sư tử tơ Giu-đa là chúa động. Các con trai của cha gặp con đều quỳ xuống. Oai hùng đem mồi về sau cuộc đi săn. Ngồi hoặc nằm uy nghi như sư tử đực. Như sư tử cái ai dám đánh thức. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Cây quyền trượng chẳng xa lìa Giu-đa, gậy chỉ huy cũng không rời khỏi hai gối chúng nó, cho đến chừng Đấng mọi người thần phục đến, là Đấng được toàn dân vâng phục người. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Con sẽ buộc lừa vào cành nho, dùng rượu nho giặt áo. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mắt con đậm màu rượu đỏ, sữa nhuộm trắng răng con. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sa-bu-luân sẽ sống tại bờ biển, có hải cảng cho tàu cập bến, ranh giới con đến gần Si-đôn. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Y-sa-ca là con lừa lực lưỡng, nằm cạnh các kiện hàng. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Đến nơi tốt đẹp liền tận hưởng, thấy cảnh vui tươi lại muốn giành, nên đành chịu cúi vai chở nặng, và buộc lòng phục dịch đàn anh. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Đan sẽ xử đoán dân mình, như những tộc khác của Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Đan là con rắn độc bên đường rình cắn vào gót ngựa, khiến kỵ sĩ nhào lăn! ");
INSERT INTO vieovcb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Lạy Chúa Hằng Hữu! Con chờ trông ơn Ngài giải cứu! ");
INSERT INTO vieovcb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gát sẽ bị quân thù đột kích, nhưng con sẽ đuổi địch chạy dài. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","A-se sản xuất nhiều thức ăn ngon, và dọn yến tiệc cho vua chúa. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nép-ta-li là nai cái thong dong, sinh ra những nai con xinh đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Giô-sép là một cây sai trái, mọc lên bên bờ suối trong xanh, cành lá vượt vách thành. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Bị cung tên kẻ thù dọa ngăm, tấn công và hãm hại. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nhưng nhờ Chúa Toàn Năng của Gia-cốp, Đấng Chăn Chiên, Vầng Đá của Ít-ra-ên, cung tên con luôn luôn vững bền, cánh tay con càng thêm lanh lợi. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Đức Chúa Trời của cha sẽ giúp đỡ; Chúa Toàn Năng ban phước và phù hộ. Con sẽ được phước hạnh dồi dào, phước lành trên trời cao, phước lành nơi đất thấp, phước lành nuôi dưỡng và sinh sản. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Phước lành cha chúc cho con sẽ cao hơn phước lành của tổ tông, lên đến các ngọn núi trường tồn. Các phước lành này sẽ ban trên Giô-sép, trên đỉnh đầu người lãnh đạo. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bên-gia-min là chó sói săn mồi, buổi sáng con tiêu diệt kẻ thù, đến chiều phân chia chiến lợi phẩm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Đó là mười hai đại tộc Ít-ra-ên và lời chúc cho mười hai con trai của ông, mỗi người một lời chúc riêng biệt. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Rồi Gia-cốp dặn bảo họ: “Cha sắp qua đời. Các con hãy chôn cha nơi phần mộ tổ tiên, trong hang đá ở cánh đồng của Ép-rôn, người Hê-tít. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Đây là hang đá trong núi của cánh đồng Mạc-bê-la, gần Mam-rê, xứ Ca-na-an, mà Áp-ra-ham đã mua của Ép-rôn người Hê-tít, để làm nghĩa trang. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Người ta đã an táng Áp-ra-ham và Sa-ra, Y-sác, và Rê-bê-ca, và cha cũng đã chôn Lê-a tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Cánh đồng và hang núi ấy do con cháu Hê-tít bán lại.” ");
INSERT INTO vieovcb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Gia-cốp dứt lời, nằm xuống giường, và nhắm mắt tắt hơi. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Giô-sép cúi xuống mặt cha, vừa hôn vừa khóc. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ông bảo các y sĩ phụ mình ướp xác cho cha. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Họ vâng lệnh, ướp xác Ít-ra-ên bốn mươi ngày, và người Ai Cập than khóc bảy mươi ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kỳ hạn than khóc đã qua, Giô-sép nói với triều đình Ai Cập: “Xin các ông vui lòng tâu vua giúp tôi: ");
INSERT INTO vieovcb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Lúc gần chết, cha buộc tôi thề phải chôn người trong phần mộ đã mua tại xứ Ca-na-an. Vậy, xin vua cho phép tôi đi chôn cất cha, rồi trở lại ngay.” ");
INSERT INTO vieovcb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Vua Pha-ra-ôn đáp: “Ngươi hãy lên đó an táng cha đúng theo lời thề.” ");
INSERT INTO vieovcb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Vậy, Giô-sép đi lên Ca-na-an mai táng cha. Các quan lớn nhỏ trong triều Pha-ra-ôn, các trưởng lão trong nước Ai Cập, ");
INSERT INTO vieovcb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","người nhà Giô-sép, các anh em, và cả gia đình đều đi dự đám tang. Chỉ còn trẻ con, bầy chiên, bầy bò ở lại Gô-sen mà thôi. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Đoàn kỵ binh và xe ngựa cũng theo hộ tống. Đám tang thật đông đảo. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Khi đến sân đạp lúa A-tát, bên kia sông Giô-đan, lễ an táng được cử hành long trọng và vĩ đại. Lễ khóc than kéo dài bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Dân Ca-na-an, tức là dân xứ ấy, thấy khóc than nơi sân đạp lúa A-tát, thì nói rằng; họ bảo nhau: “Đây là lễ khóc than vĩ đại của người Ai Cập” và gọi nơi ấy là A-bên Mích-ra-im, ở gần sông Giô-đan. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Các con trai Gia-cốp làm theo lời cha dặn; ");
INSERT INTO vieovcb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","họ chôn cha tại xứ Ca-na-an, trong hang núi của cánh đồng Mạc-bê-la, gần Mam-rê, mà Áp-ra-ham đã mua của Ép-rôn, người Hê-tít, để làm mộ địa cho gia đình. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Việc chôn cất đã xong, Giô-sép, các anh em, và những người dự đám tang đều trở lại Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Các anh Giô-sép thấy cha đã chết, họ lo sợ bảo nhau: “Có thể Giô-sép còn hằn thù ác cảm với chúng ta và sẽ thẳng tay báo thù việc ác chúng ta đã làm.” ");
INSERT INTO vieovcb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Họ sai người đến năn nỉ Giô-sép: “Trước khi qua đời, cha dặn chúng tôi ");
INSERT INTO vieovcb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","nói lại với em: ‘Xin hãy tha tội ác cho các anh con, vì chúng đã hại con.’ Bây giờ xin chú tha tội cho chúng tôi, đầy tớ Đức Chúa Trời của cha.” Nghe xong, Giô-sép khóc. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Các anh đến quỳ trước mặt Giô-sép: “Chúng tôi cũng chỉ là đầy tớ của em.” ");
INSERT INTO vieovcb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Giô-sép trấn an: “Các anh đừng sợ. Tôi thay thế Đức Chúa Trời buộc tội các anh sao? ");
INSERT INTO vieovcb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Các anh định hại tôi, nhưng Đức Chúa Trời đã đổi họa ra phước và đưa tôi đến đây để cứu bao nhiêu sinh mạng. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Vậy, các anh đừng sợ. Tôi sẽ tiếp tục cấp dưỡng cho các anh và gia đình.” Giô-sép an ủi các anh với lời lẽ thật dịu dàng. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Giô-sép và cả gia đình Gia-cốp tiếp tục sống tại Ai Cập. Giô-sép thọ 110 tuổi, ");
INSERT INTO vieovcb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","trông thấy con cháu Ép-ra-im đến đời thứ ba, và bồng ẵm các con trai của Ma-ki, cháu nội Ma-na-se. ");
INSERT INTO vieovcb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Giô-sép nói với các anh: “Tôi sắp qua đời, nhưng Đức Chúa Trời sẽ đến giúp các anh, đưa các anh ra khỏi Ai Cập, và trở về xứ Ngài đã thề hứa cho Áp-ra-ham, Y-sác, và Gia-cốp.” ");
INSERT INTO vieovcb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Giô-sép bảo các anh thề: “Khi Đức Chúa Trời cứu giúp các anh, xin hãy dời hài cốt tôi khỏi Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Vậy Giô-sép qua đời, thọ 110 tuổi. Người ta ướp xác ông và đặt trong quan tài tại Ai Cập.");
INSERT INTO vieovcb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Sau đây là tên các con trai Gia-cốp đã đem gia đình theo cha vào Ai Cập: ");
INSERT INTO vieovcb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ru-bên, Si-mê-ôn, Lê-vi, Giu-đa, ");
INSERT INTO vieovcb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Y-sa-ca, Sa-bu-luân, Bên-gia-min, ");
INSERT INTO vieovcb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Đan, Nép-ta-li, Gát, và A-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Tổng số con cháu Gia-cốp theo ông lúc ấy là bảy mươi, còn Giô-sép đã ở Ai Cập từ trước. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Giô-sép và các anh em lần lượt qua đời. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Nhưng con cháu họ sinh sôi nẩy nở rất nhanh chóng, trở thành một dân tộc lớn mạnh, tràn lan khắp vùng. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Lúc đó, Ai Cập có một vua mới. Vua này không biết gì về Giô-sép cả. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Vua nói với dân chúng: “Người Ít-ra-ên có thể còn đông và mạnh hơn dân ta nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nếu ta không khôn khéo đối phó và chặn đứng việc gia tăng dân số của họ, một mai chiến tranh bùng nổ, họ sẽ theo địch chống ta rồi kéo nhau đi hết.” ");
INSERT INTO vieovcb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Vậy, người Ai Cập đặt ra cấp cai dịch để đốc thúc việc sưu dịch, bắt người Ít-ra-ên làm việc nặng nhọc, xây thành Phi-thông và Ram-se dùng làm kho của Pha-ra-ôn, vua Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nhưng càng bị hành hạ, họ càng sinh sôi nảy nở. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Người Ai Cập lo hoảng, bắt họ làm việc càng thêm nhọc nhằn, làm cho đời họ đắng cay. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Trong công việc nhồi đất, nung gạch và mọi việc đồng áng, họ bị đối xử cách cay nghiệt, bạo tàn. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Pha-ra-ôn, vua Ai Cập, ra lệnh cho các cô đỡ của người Hê-bơ-rơ là Siếp-ra và Phu-a ");
INSERT INTO vieovcb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","phải giết tất cả các con trai sơ sinh của người Hê-bơ-rơ, còn con gái thì tha cho sống. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Nhưng các cô đỡ kính sợ Đức Chúa Trời, bất tuân lệnh vua, không sát hại các con trai sơ sinh nhưng vẫn cứ để cho chúng sống. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Vua Ai Cập đòi các cô đỡ đến để tra hỏi lý do. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Các cô tâu: “Đàn bà Hê-bơ-rơ sinh nở rất dễ, không như đàn bà Ai Cập; khi chúng tôi đến nơi, họ đã sinh rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Đức Chúa Trời ban phước cho các cô đỡ. Còn người Ít-ra-ên thì cứ gia tăng, ngày càng đông đúc. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Và vì các cô đỡ kính sợ Đức Chúa Trời, Ngài cho họ có gia đình phước hạnh. ");
INSERT INTO vieovcb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Sau đó, Pha-ra-ôn truyền lệnh cho toàn dân Ai Cập: “Ném tất cả các con trai sơ sinh của người Hê-bơ-rơ xuống sông Nin, nhưng tha cho con gái được sống.” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Bấy giờ, có một người thuộc đại tộc Lê-vi cưới một con gái Lê-vi làm vợ ");
INSERT INTO vieovcb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Họ sinh được một con trai. Thấy con mình xinh đẹp, người mẹ đem giấu đi suốt ba tháng. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Đến khi không thể giấu lâu hơn nữa, người mẹ lấy một cái thúng cói, trét nhựa thông cho khỏi thấm nước, đặt đứa bé nằm bên trong, rồi đem thúng thả bên bờ sông Nin, trong đám lau sậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Chị đứa bé đứng xa xa để trông chừng. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Một hôm, công chúa Ai Cập ra sông Nin tắm, còn các nữ tì dạo chơi dọc bờ sông. Công chúa chợt thấy cái thúng trong đám sậy, liền gọi các nữ tì vớt lên. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Mở ra, thấy một bé trai đang khóc, công chúa động lòng thương, nói rằng: “Đây là con của người Hê-bơ-rơ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Chị đứa bé liền tiến lại đề nghị với công chúa: “Con đi tìm một người đàn bà Hê-bơ-rơ để nuôi em bé này cho công chúa nhá?” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Công chúa đáp: “Phải, đi đi.” Cô bé chạy đi gọi mẹ. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Công chúa bảo mẹ đứa trẻ: “Đem em bé này về nuôi cho tôi, tôi trả công cho.” Bà ẵm nó vào lòng, đem về nhà nuôi nấng. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Khi đứa trẻ đã khôn lớn, bà dẫn nó vào cung, công chúa Ai Cập nhận làm con, đặt tên là Môi-se, vì nói rằng đã vớt nó ra khỏi nước. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Thời gian thấm thoắt, Môi-se đã trưởng thành. Một hôm ông đi thăm các anh em đồng hương, thấy người Hê-bơ-rơ phải làm lụng cực nhọc. Ông cũng thấy một người Ai Cập đánh một người Hê-bơ-rơ, dân tộc của mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nhìn quanh chẳng thấy ai, Môi-se liền giết người Ai Cập rồi đem vùi thây trong cát. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ngày hôm sau, ông lại ra thăm. Lần này Môi-se thấy hai người Hê-bơ-rơ đánh nhau. Ông nói với người có lỗi: “Đã là anh em, sao còn đánh nhau?” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Người đó hỏi vặn: “Anh là người cai trị, xét xử chúng tôi đấy à? Anh muốn giết tôi như anh giết người Ai Cập hôm qua sao?” Môi-se biết việc đã lộ, nên lo sợ lắm. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Việc đến tai Pha-ra-ôn, vua ra lệnh bắt Môi-se xử tử; nhưng ông trốn qua xứ Ma-đi-an. Đến nơi, ông ngồi bên một cái giếng. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Vừa lúc ấy, có bảy cô con gái của thầy tế lễ Ma-đi-an đến múc nước đổ vào máng cho bầy gia súc uống. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nhưng có một bọn chăn chiên đến đuổi các cô đi. Môi-se đứng ra bênh vực, rồi lấy nước cho bầy thú uống giùm các cô. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Khi Thầy Tế lễ Rê-u-ên thấy các con mình về, liền hỏi: “Sao hôm nay các con về sớm vậy?” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Các cô thưa: “Có một người Ai Cập giúp chúng con chống bọn chăn chiên, lại còn múc nước cho bầy thú uống nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Rê-u-ên hỏi: “Người ấy đâu? Sao các con bỏ đi như vậy? Ra mời anh ấy về dùng bữa.” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Môi-se đến, nhận lời ở lại với Rê-u-ên. Ông gả một trong bảy con gái là Sê-phô-ra cho Môi-se làm vợ. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Họ sinh được một con trai, đặt tên là Ghẹt-sôn, vì Môi-se nói: “Tôi ở nơi đất lạ quê người.” ");
INSERT INTO vieovcb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Khi Môi-se ở Ma-đi-an, vua Ai Cập qua đời. Người Ít-ra-ên kêu ca ta thán vì cuộc đời nô lệ cùng khổ và khóc than với Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Đức Chúa Trời nghe tiếng kêu cứu của họ, nhớ lại lời Ngài đã hứa với Áp-ra-ham, Y-sác, và Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Đức Chúa Trời đoái xem và thấu hiểu hoàn cảnh của con cháu Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Một hôm, trong lúc đang chăn bầy chiên của ông gia là Giê-trô (cũng gọi là Rê-u-ên, thầy tế lễ Ma-đi-an), Môi-se đi sâu mãi cho đến phía bên kia hoang mạc, gần Hô-rếp, núi của Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Bỗng, thiên sứ của Chúa Hằng Hữu hiện ra với ông như một ngọn lửa cháy giữa bụi cây. Môi-se thấy lửa phát ra từ bụi cây, nhưng bụi cây không bị cháy tàn. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Môi-se tự nhủ: “Lạ thật, sao bụi cây vẫn không cháy tàn. Ta lại gần xem thử.” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Chúa Hằng Hữu thấy ông từ giữa bụi cây gọi ông: “Môi-se! Môi-se!” Ông thưa: “Dạ, con đây.” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Chúa Hằng Hữu phán: “Đừng lại gần. Hãy cởi dép ra, vì nơi con đứng là đất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ta là Đức Chúa Trời của tổ tiên con, của Áp-ra-ham, Y-sác, và Gia-cốp.” Môi-se liền lấy tay che mặt vì sợ nhìn thấy Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Chúa Hằng Hữu phán: “Ta biết hết nỗi gian khổ của dân Ta tại Ai Cập, cũng nghe thấu tiếng thở than của họ dưới tay người áp bức bạo tàn. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ta xuống giải cứu họ khỏi ách nô lệ Ai Cập, đem họ đến một xứ tốt đẹp, bao la, phì nhiêu, tức là đất của người Ca-na-an, Hê-tít, A-mô-rít, Phê-rết, Hê-vi, và Giê-bu hiện nay. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Tiếng kêu van của người dân Ít-ra-ên đã thấu tận trời, và Ta đã rõ cách người Ai Cập áp bức dân Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Bây giờ Ta sai con đến gặp Pha-ra-ôn, bảo vua ấy để cho Ít-ra-ên ra khỏi Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Môi-se thưa với Đức Chúa Trời: “Con là ai mà bảo được Pha-ra-ôn phải để cho người Ít-ra-ên ra khỏi Ai Cập?” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Đức Chúa Trời hứa: “Ta sẽ đi với con, và đây là bằng cớ chứng tỏ Ta sai con: Khi con đã đem dân Ta ra khỏi Ai Cập, con sẽ đến thờ lạy Ta trên chính núi này.” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Môi-se hỏi lại: “Khi con đến nói với người Ít-ra-ên: ‘Đức Chúa Trời của tổ tiên chúng ta sai tôi đến với anh em,’ nếu họ hỏi: ‘Tên Ngài là gì?’ Thì con sẽ trả lời thế nào?” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Đức Chúa Trời đáp cùng Môi-se: “Ta là Đấng Tự Hữu Hằng Hữu, Đấng Tự Hữu đã sai con.” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Đức Chúa Trời phán tiếp cùng Môi-se: “Con nói với họ rằng: ‘Chúa Hằng Hữu, Đức Chúa Trời của tổ tiên Áp-ra-ham, Y-sác, và Gia-cốp, đã sai tôi đến với anh em.’ Chúa Hằng Hữu là tên vĩnh viễn của Ta, tên được ghi tạc qua các thế hệ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Chúa Hằng Hữu phán bảo Môi-se: “Con cũng mời các bô lão Ít-ra-ên họp lại và nói với họ: Đức Chúa Trời của tổ tiên Áp-ra-ham, Y-sác, và Gia-cốp đã hiện ra với tôi, sai tôi nói với các ông rằng: ‘Ta đã quan tâm đến các con, và thấy rõ những điều người Ai Cập đối xử với các con. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ta hứa chắc sẽ đem họ từ cảnh khổ nhục tại Ai Cập đến đất phì nhiêu của người Ca-na-an, Hê-tít, A-mô-rít, Phê-rết, Hê-vi, và Giê-bu.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Họ sẽ nghe theo con. Các bô lão sẽ đi với con đến yết kiến vua Ai Cập và nói với vua rằng: ‘Chúa Hằng Hữu, Đức Chúa Trời của người Hê-bơ-rơ, đã hiện ra với chúng tôi. Vậy, xin cho chúng tôi đi đến một nơi trong hoang mạc, cách đây chừng ba ngày đường, để chúng tôi dâng tế lễ lên Đức Chúa Trời Hằng Hữu, Đức Chúa Trời của chúng ta.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nhưng Ta biết trước, trừ khi bị áp lực phi thường, vua Ai Cập sẽ không để cho người Ít-ra-ên đi đâu. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Vì vậy, Ta sẽ vung tay hành hạ Ai Cập, làm nhiều phép lạ, rồi cuối cùng họ mới để dân Ta đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ta cũng sẽ khiến người Ai Cập rộng lòng, để khi ra đi, người Ít-ra-ên chẳng đi tay trắng. ");
INSERT INTO vieovcb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Phụ nữ Ít-ra-ên sẽ xin các người láng giềng và các bà chủ Ai Cập các món nữ trang bằng vàng, bằng bạc, và áo xống để mặc cho con cái mình. Như vậy, chính người Ai Cập lại bị người Ít-ra-ên tước đoạt của cải!” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Nhưng Môi-se nói: “Họ sẽ chẳng tin con, cũng chẳng nghe lời con, và sẽ nói: ‘Chúa Hằng Hữu đâu có hiện ra với ông.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Chúa Hằng Hữu hỏi: “Con đang cầm gì trong tay đó?” Môi-se thưa: “Dạ cây gậy.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Chúa Hằng Hữu phán: “Ném gậy xuống đất xem.” Môi-se vâng lời. Gậy liền biến thành con rắn. Môi-se chạy trốn nó. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Chúa Hằng Hữu phán: “Nắm lấy đuôi nó.” Môi-se nắm đuôi rắn, rắn lại thành gậy trong tay ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Chúa Hằng Hữu tiếp: “Với phép lạ này, họ sẽ tin Chúa Hằng Hữu, Đức Chúa Trời của tổ tiên Áp-ra-ham, Y-sác, và Gia-cốp, đã hiện ra với con.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Chúa Hằng Hữu lại phán với Môi-se: “Đặt tay vào bụng con xem.” Ông vâng lời, khi rút tay ra, thấy phong hủi nổi lên trắng như tuyết. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Chúa phán: “Đặt tay vào bụng lần nữa.” Lần này khi rút tay ra, Môi-se thấy tay mình trở lại bình thường như cũ. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Chúa Hằng Hữu phán: “Nếu họ không tin phép lạ thứ nhất, họ sẽ tin phép lạ thứ hai. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Cùng lắm, nếu họ không tin cả hai phép lạ này và không nghe lời con, lúc ấy con hãy lấy nước sông Nin lên đổ tràn trên mặt đất, nước sẽ hóa ra máu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Môi-se viện cớ với Chúa Hằng Hữu: “Chúa ơi, từ trước đến nay con vốn là người không có tài ăn nói, vì miệng lưỡi con hay ấp a ấp úng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Chúa Hằng Hữu hỏi Môi-se: “Ai tạo ra miệng? Ai có thể làm cho một người trở nên câm, điếc, hoặc mù? Có phải Ta không?” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ngài tiếp: “Bây giờ, cứ vâng lời Ta mà đi, Ta sẽ giúp đỡ mỗi khi con nói và dạy con từng lời.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Nhưng Môi-se thưa: “Lạy Chúa, xin Chúa sai một người nào khác làm việc này đi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Chúa Hằng Hữu nổi giận cùng Môi-se và phán: “Thế A-rôn, người Lê-vi, anh con thì sao? Anh ấy là một người có tài ăn nói, đang đi tìm con và sẽ mừng lắm khi thấy con. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Con sẽ kể lại cho A-rôn mọi điều Ta bảo con. Ta sẽ giúp hai anh em con trong lời ăn tiếng nói, và sẽ dạy con những điều phải làm. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A-rôn sẽ thay con nói chuyện với dân, sẽ là phát ngôn viên của con; còn con sẽ như là chúa của A-rôn vậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Con nhớ cầm theo cây gậy này để làm các phép lạ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Môi-se trở về nhà, thưa với ông gia mình là Giê-trô: “Xin cha cho con trở lại Ai Cập thăm anh em con, chẳng biết họ sống chết ra sao.” Giê-trô đáp: “Chúc con đi bình an.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Trước khi ông rời Ma-đi-an, Chúa Hằng Hữu có cho Môi-se biết rằng: “Về Ai Cập lần này, con đừng sợ gì cả, vì những người tìm giết con đã chết hết rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Môi-se đỡ vợ con lên lưng lừa, lên đường về Ai Cập, cầm trong tay cây gậy của Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Chúa Hằng Hữu nhắc Môi-se: “Đến Ai Cập, con sẽ đi gặp Pha-ra-ôn để làm các phép lạ Ta cho, nhưng nên nhớ rằng Ta sẽ làm cho vua Ai Cập cứng lòng, chưa cho dân Ta đi đâu. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Rồi, con sẽ nói với vua rằng: ‘Chúa Hằng Hữu phán: Ít-ra-ên là con trưởng nam Ta, ");
INSERT INTO vieovcb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ta có bảo ngươi cho nó đi để phụng thờ Ta, nhưng ngươi từ chối. Bây giờ, Ta sẽ giết con trưởng nam của ngươi.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Dọc đường, khi Môi-se và gia đình ông dừng chân tại một quán trọ, Chúa Hằng Hữu hiện ra gặp ông, và định giết ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Nhưng vợ Môi-se là Sê-phô-ra lấy con dao đá cắt da qui đầu dương vật của con trai mình, ném dưới chân Môi-se, la hoảng: ");
INSERT INTO vieovcb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","“Ông chồng đẫm máu của tôi ơi,” rồi Chúa Hằng Hữu để cho ông được yên. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Về phần A-rôn, Chúa Hằng Hữu có phán bảo ông: “Đi vào hoang mạc đón Môi-se.” A-rôn vâng lời, đi đến núi của Đức Chúa Trời thì gặp Môi-se. Hai người mừng rỡ chào hỏi nhau. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Môi-se thuật hết cho A-rôn mọi điều Chúa Hằng Hữu phán bảo họ phải làm, cũng cho A-rôn thấy các phép lạ họ sẽ thực hiện. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Sau đó, Môi-se cùng với A-rôn đi triệu tập các bô lão Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","A-rôn kể cho họ nghe mọi lời Chúa Hằng Hữu đã phán bảo Môi-se, và cũng làm các phép lạ cho họ thấy. ");
INSERT INTO vieovcb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Họ tin lời ông. Khi nghe rằng Chúa Hằng Hữu đã viếng thăm Ít-ra-ên, thấu rõ nỗi đắng cay của họ, các bô lão liền cúi đầu thờ lạy. ");
INSERT INTO vieovcb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Sau đó, Môi-se đi với A-rôn đến yết kiến Pha-ra-ôn, thưa rằng: “Chúa Hằng Hữu, Đức Chúa Trời của người Ít-ra-ên, có bảo chúng tôi thưa với vua: ‘Hãy để cho dân Ta đi vào hoang mạc hành lễ phụng thờ Ta.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pha-ra-ôn đáp: “Chúa Hằng Hữu là ai mà ra lệnh cho ta? Ta chẳng biết Chúa Hằng Hữu nào hết, cũng chẳng cho người Ít-ra-ên đi đâu cả.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Môi-se và A-rôn lại nói: “Đức Chúa Trời của người Hê-bơ-rơ có gặp chúng tôi thật. Nếu vua không để cho chúng tôi đi chừng ba ngày đường vào hoang mạc dâng tế lễ lên Chúa Hằng Hữu, Đức Chúa Trời của chúng tôi, thì chúng tôi sẽ bị bệnh dịch hạch hoặc gươm đao tàn sát.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pha-ra-ôn gắt: “Môi-se và A-rôn, các ngươi định xúi cho dân đình công phải không? Thôi, trở về làm việc đi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pha-ra-ôn tiếp: “Dân số ngày càng gia tăng cao mà sao hai ông lại xúi họ bỏ bê công việc.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ngay hôm ấy, Pha-ra-ôn ra lệnh cho các viên cai quản nô lệ và các đốc công: ");
INSERT INTO vieovcb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Đừng cấp rơm cho người Ít-ra-ên như trước nữa, nhưng bắt chúng phải tự kiếm lấy rơm để làm gạch. ");
INSERT INTO vieovcb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Đồng thời cứ giữ đúng chỉ tiêu sản xuất gạch như cũ. Đừng để chúng rảnh tay sinh lười, kiếm cớ đòi đi dâng tế lễ lên Đức Chúa Trời của chúng. ");
INSERT INTO vieovcb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Cứ bắt chúng làm việc càng nặng nề hơn, để chẳng còn hơi sức đâu mà nghe theo lời xúi giục dối trá.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Vậy, các viên cai quản nô lệ và các đốc công báo cho người Ít-ra-ên: “Pha-ra-ôn sẽ không cho cấp rơm như trước nữa, ");
INSERT INTO vieovcb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","mỗi người phải tự lo kiếm lấy. Nhưng lượng gạch sản xuất vẫn phải đủ số như cũ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Mọi người phân tán khắp đất Ai Cập, kiếm rạ dùng thế cho rơm. ");
INSERT INTO vieovcb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Trong khi đó các viên cai quản nô lệ một mực đốc thúc: “Ngày nào cũng phải làm đủ số gạch ngày đó như trước kia, không được thiếu một viên.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Họ lại đánh đập những người Ít-ra-ên mà chính họ đã chỉ định làm trưởng nhóm trông coi những người Ít-ra-ên khác làm việc. Họ thét: “Chúng bây chẳng được việc gì hết. Cả hôm qua lẫn hôm nay đều không đủ chỉ tiêu gạch.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Các trưởng nhóm người Ít-ra-ên đến kêu than với Pha-ra-ôn: “Sao vua cư xử ngặt nghèo với đầy tớ của vua quá. ");
INSERT INTO vieovcb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Chúng tôi không được cấp rơm, nhưng lại được lệnh phải sản xuất đủ số gạch như cũ. Chúng tôi bị đòn chỉ vì người của vua bất công, chứ chúng tôi có lỗi gì?” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Vua thản nhiên đáp: “Chỉ vì lười biếng mà các ngươi đòi đi dâng lễ vật lên Chúa Hằng Hữu chứ gì? ");
INSERT INTO vieovcb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Về làm việc đi. Chẳng ai cấp rơm cho đâu, nhưng gạch vẫn phải làm cho đủ số.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nghe xong những lời đó, các trưởng nhóm người Ít-ra-ên mới ý thức được tình hình vô cùng đen tối của mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Khi lui ra khỏi hoàng cung, họ gặp Môi-se và A-rôn đang đứng đợi, ");
INSERT INTO vieovcb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","liền nói: “Xin Chúa Hằng Hữu xử đoán hai ông, vì hai ông đã làm cho chúng tôi thành ra vật đáng tởm trước mặt Pha-ra-ôn và quần thần. Chính các ông đã trao giáo cho họ đâm chúng tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Môi-se trở về cùng Chúa Hằng Hữu, thưa: “Chúa ơi! Sao Chúa đối xử tàn tệ với dân Ngài thế này? Tại sao Chúa sai con đến đây? ");
INSERT INTO vieovcb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Vì từ lúc con đến gặp Pha-ra-ôn nói điều Chúa phán bảo, vua càng tỏ ra tàn nhẫn với dân Ngài. Thế mà Chúa vẫn không giải cứu họ!” ");
INSERT INTO vieovcb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Chúa Hằng Hữu phán cùng Môi-se: “Bây giờ con xem Ta ra tay hành hạ Pha-ra-ôn. Ta sẽ ra tay làm cho vua ấy không những để cho dân Ta đi, mà còn sẽ đuổi họ đi gấp nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Đức Chúa Trời phán cùng Môi-se: “Ta là Chúa Hằng Hữu ");
INSERT INTO vieovcb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ta đã hiện ra với Áp-ra-ham, Y-sác, và Gia-cốp với danh hiệu Đức Chúa Trời Toàn Năng; tuy nhiên, về danh hiệu Chúa Hằng Hữu, Ta không hề cho họ biết. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ta có kết lập giao ước với họ, hứa cho họ xứ Ca-na-an, lúc đó họ còn coi là nơi đất khách quê người. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Giờ đây, những lời thở than của con cháu Ít-ra-ên trong cảnh nô lệ đọa đày dưới ách Ai Cập nhắc Ta nhớ lại lời Ta đã hứa. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Vậy, hãy nói cho con cháu Ít-ra-ên biết rằng: Ta là Chúa Hằng Hữu. Ta sẽ đưa tay trừng phạt người Ai Cập, giải cứu Ít-ra-ên khỏi sự áp bức, khỏi ách nô lệ. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ta sẽ nhận họ làm dân Ta, và Ta làm Đức Chúa Trời họ. Họ sẽ biết Ta là Chúa Hằng Hữu, Đức Chúa Trời của họ giải cứu họ khỏi tay người Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ta sẽ dẫn họ vào đất Ta hứa cho Áp-ra-ham, Y-sác, và Gia-cốp. Đất ấy sẽ thuộc về họ. Ta là Chúa Hằng Hữu!” ");
INSERT INTO vieovcb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Môi-se nói lại với người Ít-ra-ên mọi lời của Chúa Hằng Hữu, nhưng họ không nghe, vì tinh thần nặng nề buồn thảm, và thể xác bị hành hạ rã rời. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Con đi yết kiến Pha-ra-ôn, vua Ai Cập lần nữa, bảo vua ấy phải để cho người Ít-ra-ên đi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nhưng Môi-se thưa: “Thưa Chúa Hằng Hữu! Người Ít-ra-ên đã chẳng nghe con, Pha-ra-ôn lại nghe con sao? Con đâu có tài thuyết phục ai.” ");
INSERT INTO vieovcb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Lần này, Chúa Hằng Hữu phán với cả Môi-se lẫn A-rôn, bảo họ phải đi gặp người Ít-ra-ên và Pha-ra-ôn vua Ai Cập, để dàn xếp việc đem người Ít-ra-ên ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Sau đây là danh sách gia trưởng của một số đại tộc Ít-ra-ên: Các con trai của Ru-bên, trưởng nam của Ít-ra-ên là Hê-nóc, Pha-lu, Hết-rôn, và Cát-mi. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Các con trai Si-mê-ôn là Giê-mu-ên, Gia-min, Ô-hát, Gia-kin Xô-ha, và Sau-lơ (mẹ ông này là người Ca-na-an.) Những con cháu này trở nên gia tộc Si-mê-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Các con trai Lê-vi, theo thứ tự tuổi tác là Ghẹt-sôn, Kê-hát, và Mê-ra-ri. Lê-vi thọ 137 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gia phả của Ghẹt-sôn gồm hai con trai là Líp-ni và Si-mê-i, về sau đều là trưởng tộc. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kê-hát có bốn con trai là Am-ram, Dít-sê-ha, Hếp-rôn, và U-xi-ên. Kê-hát thọ 133 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mê-ra-ri có hai con trai là Mách-li và Mu-si. Đó là gia tộc của Lê-vi, liệt kê theo từng gia đình. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Am-ram cưới Giô-kê-bết là cô mình, sinh A-rôn và Môi-se. Am-ram thọ 137 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Kê-hát có ba con trai là Cô-ra, Nê-phết, và Xiếc-ri. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","U-xi-ên cũng có ba con trai là Mi-sa-ên, Ên-sa-phan, và Sít-ri. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","A-rôn cưới Ê-li-sê-ba, con gái A-mi-na-đáp, em Na-ha-sôn; các con trai là Na-đáp, A-bi-hu, Ê-lê-a-sa, và Y-tha-ma. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Các con trai của Cô-ra là Át-si, Ên-ca-na, và A-bi-a-sáp. Đó là gia tộc của Cô-ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ê-lê-a-sa, con A-rôn, cưới con gái Phu-ti-ên; con trai của họ là Phi-nê-a. Đó là các trưởng tộc Lê-vi và gia đình họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","A-rôn và Môi-se là hai người đã nhận lệnh Chúa Hằng Hữu đem toàn dân Ít-ra-ên ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Chính họ đã đi yết kiến Pha-ra-ôn, vua Ai Cập, để xin cho người Ít-ra-ên ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Trong ngày Chúa Hằng Hữu phán với Môi-se tại Ai Cập, ");
INSERT INTO vieovcb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Ngài đã phán với Môi-se rằng: “Ta là Chúa Hằng Hữu. Hãy đi gặp Pha-ra-ôn, vua Ai Cập, truyền lại cho vua ấy mọi lời Ta đã phán bảo.” ");
INSERT INTO vieovcb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Và lúc ấy, Môi-se có thưa Chúa Hằng Hữu: “Con ăn nói vụng về, làm sao thuyết phục Pha-ra-ôn được?” ");
INSERT INTO vieovcb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Chúa Hằng Hữu phán bảo Môi-se: “Ta cho con làm chúa của Pha-ra-ôn, còn A-rôn làm phát ngôn viên cho con. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Con thuật cho A-rôn mọi lời Ta phán; A-rôn sẽ nói lại cho Pha-ra-ôn, để vua này cho người Ít-ra-ên ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Nhưng Ta sẽ khiến cho Pha-ra-ôn trở nên ương ngạnh, không cho dân Ta đi, nhân đó Ta càng thực hiện nhiều phép lạ hơn trong nước Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Tuy nhiên, Pha-ra-ôn vẫn tiếp tục ngoan cố, chẳng xiêu lòng. Ta sẽ ra tay đoán phạt Ai Cập một cách nặng nề để đem đạo quân Ta, là dân Ít-ra-ên, ra khỏi xứ đó. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Và Ta sẽ ra tay trừng trị Ai Cập nặng nề, rồi đem dân Ta ra. Lúc ấy, người Ai Cập mới ý thức được rằng Ta chính là Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Môi-se và A-rôn làm đúng theo lời Chúa Hằng Hữu phán với họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Lúc yết kiến Pha-ra-ôn, Môi-se đã được tám mươi tuổi, còn A-rôn tám mươi ba. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Chúa Hằng Hữu lại phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Khi nào Pha-ra-ôn đòi hỏi các con làm phép lạ để chứng tỏ các con được Đức Chúa Trời sai đến, A-rôn sẽ theo lời Môi-se quăng gậy xuống đất, gậy sẽ hóa ra rắn.” ");
INSERT INTO vieovcb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Vậy hai ông đi yết kiến Pha-ra-ôn, làm những điều Chúa Hằng Hữu phán với họ. A-rôn quăng gậy xuống đất trước mặt Pha-ra-ôn và quần thần. Gậy liền biến ra một con rắn. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pha-ra-ôn ra lệnh triệu tập các thầy pháp và các thầy phù thủy Ai Cập. Họ đến, dùng pháp thuật, cũng làm được điều A-rôn đã làm. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Gậy họ cũng biến thành rắn. Nhưng rắn của A-rôn nuốt rắn của họ đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Với lòng vẫn không lay chuyển, Pha-ra-ôn không nghe lời hai ông, đúng như Chúa Hằng Hữu đã nói trước với Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Chúa Hằng Hữu nhắc lại cho Môi-se: “Pha-ra-ôn ngoan cố, sẽ tiếp tục từ khước không cho dân Ta đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Nhưng sáng mai, con cứ đi ra bờ sông Nin gặp vua. Đừng quên cầm theo cây gậy đã biến thành rắn. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Tại đó, con sẽ nói với Pha-ra-ôn: Chúa Hằng Hữu, Đức Chúa Trời của người Hê-bơ-rơ, có sai tôi bảo với vua để cho người Ít-ra-ên đi phụng thờ Ngài trong hoang mạc, nhưng vua đã từ chối. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Bây giờ, Chúa Hằng Hữu phán: ‘Ngươi sẽ biết chính Ta là Đức Chúa Trời, vì Ta sai Môi-se lấy gậy đập nước sông Nin, nước sẽ hóa ra máu. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Cá sẽ chết, sông sẽ thối, người Ai Cập sẽ kinh tởm khi uống phải nước sông Nin ấy.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Rồi Chúa Hằng Hữu phán dặn Môi-se: “Con bảo A-rôn cầm gậy đưa về hướng các sông, suối, hồ, và tất cả các nguồn nước của Ai Cập, kể cả nước đã chứa vào vại đất, vào bình đá. Tất cả nước sẽ biến ra máu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Môi-se và A-rôn tuân hành lệnh Chúa Hằng Hữu. Trước mặt Pha-ra-ôn và quần thần, A-rôn đưa cao gậy, đập xuống nước sông Nin, nước sông biến thành máu. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Cá chết, nước thối. Người Ai Cập không uống nước sông được nữa. Khắp Ai Cập, đâu cũng thấy máu. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Các thầy pháp Ai Cập dùng pháp thuật cũng biến nước thành máu, cho nên Pha-ra-ôn vẫn ương ngạnh không nghe lời Môi-se và A-rôn, đúng như Chúa Hằng Hữu đã nói. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Vua quay về cung, lòng dửng dưng. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Người Ai Cập phải đào giếng dọc bờ sông để lấy nước uống, vì không uống nước sông Nin được. ");
INSERT INTO vieovcb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Một tuần lễ trôi qua kể từ khi Chúa Hằng Hữu giáng tai vạ trên sông Nin. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Chúa Hằng Hữu lại phán bảo Môi-se: “Con vào cung gặp Pha-ra-ôn, thưa với vua như sau: ‘Chúa Hằng Hữu phán bảo để cho dân Ta đi phụng thờ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Nếu không, Ta sẽ sai ếch nhái đến, tràn khắp bờ cõi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sông Nin sẽ đầy lúc nhúc ếch nhái. Chúng sẽ nhảy vào cung, vào tận phòng ngủ của vua, đầy cả giường. Trong nước Ai Cập, nhà nào cũng sẽ đầy ếch nhái trong lò, trong bếp, trong cả thùng nhồi bột. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ếch nhái sẽ bò lên người của mọi công dân Ai Cập, lên cả mình vua.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Rồi Chúa Hằng Hữu phán dặn Môi-se: “Hãy nói với A-rôn đưa gậy hướng về các sông, suối, hồ, để ếch nhái từ các nơi đó tràn lên khắp Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","A-rôn vâng lời, và ếch nhái tràn lan khắp nơi trong nước của xứ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Các thầy pháp dùng pháp thuật cũng làm cho ếch nhái bò lên, chỉ thêm chật đất Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pha-ra-ôn liền cho đòi Môi-se và A-rôn đến, nói: “Cầu xin Chúa Hằng Hữu đi, để Ngài cho ếch nhái lánh xa chúng ta, rồi ta sẽ để cho người Hê-bơ-rơ đi phụng thờ Ngài.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Môi-se tâu: “Xin vua vui lòng cho biết vua muốn lúc nào ếch nhái rời khỏi Ai Cập, để tôi cầu Đức Chúa Trời cho ếch nhái chết đi đúng lúc ấy, chỉ còn lại ở dưới sông Nin mà thôi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pha-ra-ôn đáp: “Ngày mai.” Môi-se nói: “Thưa vâng. Như vậy để vua biết rằng chẳng có ai như Chúa Hằng Hữu, Đức Chúa Trời của chúng tôi. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Trừ dưới sông Nin ra, ếch nhái ở những nơi khác đều sẽ chết hết.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Môi-se và A-rôn rời cung vua Pha-ra-ôn, Môi-se liền cầu xin Chúa Hằng Hữu về việc này. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Chúa Hằng Hữu thực hiện lời Môi-se xin. Ếch nhái chết la liệt từ trong nhà đến tận ngoài đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Người ta dồn xác chúng lại thành từng đống lớn, mùi hôi thối xông lên khắp nơi. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Còn Pha-ra-ôn, khi thấy mình đã thoát nạn này, liền trở lòng, chai lì, không chịu cho người Ít-ra-ên đi, đúng như Chúa Hằng Hữu đã báo trước. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Chúa Hằng Hữu lại phán dạy Môi-se: “Hãy bảo A-rôn lấy gậy đập đất, cho bụi bay lên. Bụi sẽ biến thành muỗi dày đặc trong nước Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Vậy, Môi-se và A-rôn làm theo lời Chúa phán; muỗi tràn lan khắp Ai Cập, bu đầy người dân Ai Cập, và bu đầy mình súc vật của họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Các thầy pháp thử dùng pháp thuật hóa bụi ra muỗi, nhưng không làm được. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Họ tâu Pha-ra-ôn: “Đây là ngón tay của Đức Chúa Trời.” Nhưng Pha-ra-ôn ngoan cố, không nghe Môi-se và A-rôn, như lời Chúa Hằng Hữu đã dạy. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Sau đó, Chúa Hằng Hữu phán bảo Môi-se: “Sáng mai con dậy sớm, đi ra bờ sông gặp Pha-ra-ôn, thưa với vua rằng: Chúa Hằng Hữu phán bảo vua tha cho người Ít-ra-ên ra đi, để họ phụng thờ Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Nếu không, Ngài sẽ sai vô số ruồi nhặng đến. Nhà nào cũng đầy ruồi. Ruồi sẽ bu khắp người vua, quần thần, và công dân Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Nhưng ngày đó, Ta sẽ để riêng đất Gô-sen là nơi dân Ta cư trú; nơi đó sẽ không có ruồi nhặng để ngươi biết rằng Ta là Chúa Hằng Hữu đang ngự giữa xứ này. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Chúa phân biệt người của Ngài với người của vua. Vua sẽ biết rằng Chúa Hằng Hữu là Chúa của mọi lãnh thổ. Ngày mai, việc này sẽ xảy ra.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Chúa Hằng Hữu thực hiện lời Ngài phán. Vô số ruồi nhặng đến thành từng đàn, tàn hại đất Ai Cập, bay vào cung điện Pha-ra-ôn và nhà cửa của quần thần. Khắp đất Ai Cập đều bị ruồi tàn phá. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pha-ra-ôn liền cho đòi Môi-se và A-rôn đến. Vua nói: “Đem người Hê-bơ-rơ đi dâng tế lễ lên Đức Chúa Trời của họ đi! Nhưng không được ra khỏi Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Môi-se đáp: “Không được. Chúng tôi dâng lên Chúa Hằng Hữu, Đức Chúa Trời của chúng tôi các lễ vật người Ai Cập ghê tởm. Nếu chúng tôi dâng lễ trước mặt họ, họ sẽ giết chúng tôi sao? ");
INSERT INTO vieovcb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Chúng tôi phải đi sâu vào hoang mạc chừng ba ngày đường, và dâng lễ lên Chúa Hằng Hữu, Đức Chúa Trời của chúng tôi tại đó, như Ngài đã bảo chúng tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pha-ra-ôn nhượng bộ: “Thôi được, ta cho đi vào hoang mạc để dâng lễ lên Chúa Hằng Hữu Đức Chúa Trời của các ngươi. Nhưng không được đi xa hơn nữa. Bây giờ nhanh lên và cầu nguyện cho ta.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Môi-se hứa: “Tôi sẽ xin Chúa Hằng Hữu cho vô số ruồi nhặng rời Ai Cập. Nhưng xin vua đừng đánh lừa chúng tôi như lần trước.” ");
INSERT INTO vieovcb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Rời cung vua Pha-ra-ôn, Môi-se xin Chúa Hằng Hữu cho ruồi nhặng rút đi hết. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Chúa Hằng Hữu nhậm lời Môi-se, làm cho ruồi đi hết, không còn lại một con. ");
INSERT INTO vieovcb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nhưng lòng của Pha-ra-ôn lại trở nên chai lì, và ông không cho dân Chúa đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Chúa Hằng Hữu lại phán bảo Môi-se: “Hãy đi gặp Pha-ra-ôn, nói với vua ấy: ‘Chúa Hằng Hữu, Đức Chúa Trời của người Hê-bơ-rơ, bảo vua phải để cho họ đi phụng thờ Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Nếu không cho họ đi mà cứ cầm giữ lại, ");
INSERT INTO vieovcb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","thì Chúa Hằng Hữu sẽ làm cho súc vật của người bị bệnh dịch, ngựa, lừa, lạc đà, cùng các loài gia súc khác đều phải chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Nhưng Chúa Hằng Hữu sẽ phân biệt giữa súc vật của dân Ít-ra-ên và súc vật của người Ai Cập; không một con vật nào thuộc về dân Ít-ra-ên bị chết cả.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Chúa Hằng Hữu ấn định thời hạn và phán: “Ngày mai, việc này sẽ xảy ra.” ");
INSERT INTO vieovcb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Đúng như lời Chúa Hằng Hữu, vừa sáng hôm sau, súc vật của người Ai Cập chết la liệt; nhưng súc vật của người Ít-ra-ên không hề hấn gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pha-ra-ôn sai người đi quan sát, xem thử có phải súc vật của người Ít-ra-ên đều an toàn cả không. Ngay cả khi biết rõ điều ấy là đúng, Pha-ra-ôn vẫn cứ cố chấp, không để cho người Ít-ra-ên đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Bấy giờ, Chúa Hằng Hữu phán cùng Môi-se và A-rôn: “Vốc tro trong lò đầy tay, rồi Môi-se sẽ tung tro lên trời trước mặt Pha-ra-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Tro sẽ là bụi phủ khắp nước Ai Cập, gây nên mụt nhọt lở lói đầy mình, cả người lẫn thú vật.” ");
INSERT INTO vieovcb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Vậy hai ông hốt tro trong lò và đứng trước mặt Pha-ra-ôn; Môi-se tung tro lên không, tro ấy sinh ra ung nhọt và cương mủ trên thân thể người và súc vật. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Các thầy pháp cũng bị lở lói, không còn đứng trước mặt Môi-se được nữa. Ung nhọt cũng nổi lên trên thân thể tất cả người Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Nhưng Chúa Hằng Hữu khiến lòng Pha-ra-ôn chai đá, không chịu nghe lời Môi-se và A-rôn, như Chúa Hằng Hữu đã báo trước. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Sau đó, Chúa Hằng Hữu phán bảo Môi-se: “Sáng mai con dậy sớm, đi gặp Pha-ra-ôn, nói rằng: Chúa Hằng Hữu, Đức Chúa Trời của người Hê-bơ-rơ, bảo vua để cho người Ít-ra-ên đi để họ phụng thờ Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ngài nói: Lần này Ta sẽ giáng tai họa hiểm nghèo khiến cho ngươi, quần thần và mọi công dân Ai Cập đều phải nhận thức rằng không có thần nào khác như Ta trên khắp thế giới. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ta có quyền tiêu diệt người Ai Cập ngay tức khắc. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Nhưng Ta không ra tay, vì muốn cho ngươi và cả thế gian biết quyền năng của Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nếu ngươi còn dám ra mặt ngăn cản việc ra đi của dân Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Đúng vào giờ này ngày mai, Ta sẽ giáng một trận mưa đá rất lớn, trong lịch sử Ai Cập chưa hề có trận mưa đá nào lớn như vậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Bây giờ, ngươi nên cho người dắt súc vật ở ngoài đồng về, vì mưa đá sẽ rơi, giết hại cả người lẫn súc vật còn ở ngoài đồng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Quần thần Pha-ra-ôn nghe những lời Chúa Hằng Hữu, có người lo sợ, vội sai gọi đầy tớ đem súc vật về, ");
INSERT INTO vieovcb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","nhưng cũng có người dửng dưng, không đếm xỉa đến lời Chúa Hằng Hữu, cứ để đầy tớ và súc vật ở ngoài đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Chúa Hằng Hữu phán bảo Môi-se: “Đưa tay lên trời, mưa đá sẽ rơi xuống khắp nước Ai Cập, trên người, thú vật và cây cỏ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Môi-se cầm gậy đưa lên trời, Chúa Hằng Hữu làm cho sấm động vang trời, chớp nhoáng sáng rực và mưa đá trút xuống dữ dội trên toàn xứ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Thật là một cảnh khủng khiếp chưa hề thấy trong lịch sử Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Cả nước Ai Cập bị tàn phá. Người, súc vật, cây cỏ, mùa màng còn lại ngoài đồng đều bị mưa đá hủy hoại. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Chỉ trừ Gô-sen, đất cư trú của người Ít-ra-ên, là không bị mưa đá hôm ấy. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pha-ra-ôn cho mời Môi-se và A-rôn vào, nói: “Bây giờ ta nhận biết lỗi mình. Chúa Hằng Hữu công chính, còn ta với dân ta đều sai trái cả. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Xin cầu Chúa Hằng Hữu cho ta, để Ngài chấm dứt sấm sét và mưa đá, rồi ta sẽ cho người Ít-ra-ên ra đi lập tức.” ");
INSERT INTO vieovcb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Môi-se đáp: “Ra khỏi thành, tôi sẽ đưa tay lên hướng về Chúa Hằng Hữu, sấm sét sẽ lặn, mưa đá sẽ tan. Làm thế để vua ý thức được rằng Chúa Hằng Hữu nắm quyền khắp hoàn vũ. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tuy nhiên, tôi biết vua và quần thần vẫn chưa thật tâm kính sợ Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Lúc ấy đúng vào mùa lúa mạch và cây gai trổ hoa, nên lúa mạch và cây gai đều bị mưa đá vùi dập. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Còn lúa mì và tiểu mạch không bị hại, vì chưa mọc lên. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Như thế Môi-se rời Pha-ra-ôn, ra ngoài thành, đưa tay lên hướng về Chúa Hằng Hữu. Tất cả sấm sét đều lặn, mưa đá ngừng, và mưa cũng dứt. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Vừa thấy thế, Pha-ra-ôn và quần thần lại ương ngạnh, một lần nữa phạm tội nuốt lời hứa. ");
INSERT INTO vieovcb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Vậy, Pha-ra-ôn không để cho người Ít-ra-ên ra đi, đúng như lời Chúa Hằng Hữu đã báo trước cùng Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Chúa Hằng Hữu lại phán bảo Môi-se: “Con cứ đi yết kiến Pha-ra-ôn lần nữa, nhưng nên nhớ rằng Ta đã làm cho Pha-ra-ôn và quần thần chai lì, nhân đó Ta sẽ làm thêm nhiều phép lạ khác nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Như vậy sau này con được dịp kể lại cho con cháu mình nghe những việc kỳ diệu của Ta, cùng cách Ta đối xử với người Ai Cập, để chúng nó biết rằng Ta là Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Vậy Môi-se và A-rôn đi gặp Pha-ra-ôn, nói: “Chúa Hằng Hữu, Đức Chúa Trời của người Hê-bơ-rơ, hỏi: Bao giờ ngươi mới chịu khuất phục Ta? Ngươi nên để cho dân Ta đi phụng thờ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nếu không, ngày mai Ta sẽ sai châu chấu đến, ");
INSERT INTO vieovcb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","phủ dày trên Ai Cập đến độ không còn thấy đất được nữa. Châu chấu sẽ cắn phá những gì còn sót lại sau trận mưa đá. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Châu chấu sẽ tràn vào cung ngươi, nhà của bầy tôi ngươi và nhà của mọi người Ai Cập. Đây là một tai nạn chưa hề thấy trong lịch sử nước ngươi.” Nói xong, Môi-se quay mặt đi ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Quần thần Pha-ra-ôn tâu: “Đến bao giờ dân này mới không còn là mối đe dọa cho dân ta? Vua không thấy đất nước Ai Cập đã trở nên điêu tàn hay sao? Xin vua, cứ cho họ đi phục vụ Chúa Hằng Hữu, Đức Chúa Trời của họ cho khuất mắt.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Sau đó, Môi-se và A-rôn được mời đến. Pha-ra-ôn nói: “Đi phụng thờ Chúa Hằng Hữu, Đức Chúa Trời các ngươi, đi! Nhưng phải nói cho ta biết thành phần nào trong dân sẽ ra đi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Môi-se đáp: “Tất cả nam, phụ, lão, ấu đều ra đi, cùng với cả bầy súc vật, vì tất cả chúng tôi đều phải dự lễ của Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Nghe thấy thế, Pha-ra-ôn liền nói: “Xin Chúa Hằng Hữu chứng giám, ta không thể nào để cho các ngươi đem theo tất cả con cái như thế được. Ta hiểu rõ âm mưu trong trí các ngươi rồi. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Không! Chỉ đàn ông được đi phụng thờ Chúa Hằng Hữu mà thôi. Đó là điều các ngươi đã xin.” Vậy, họ đuổi Môi-se và A-rôn ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Chúa Hằng Hữu phán bảo Môi-se: “Hãy dang tay con ra trên đất Ai Cập, đem châu chấu đến. Châu chấu sẽ cắn phá những gì mưa đá còn để lại.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Môi-se dang tay đưa gậy ra trên Ai Cập, Chúa Hằng Hữu làm cho gió đông thổi suốt ngày và đêm đó. Gió đông đem châu chấu đến. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Qua sáng hôm sau, gió đông đem châu chấu đến đầy dẫy lãnh thổ Ai Cập. Trong lịch sử nước này, chưa hề có nạn châu chấu nào tai hại đến thế, và trong tương lai cũng sẽ không có như vậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Châu chấu quá nhiều đến nỗi chúng bay phủ mặt đất, bay rợp cả trời, che hết ánh nắng. Chúng cắn hại rau cỏ và cây cối còn sót lại sau trận mưa đá, làm cho không còn cây lá xanh tươi gì nữa trên xứ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pha-ra-ôn vội vã mời Môi-se và A-rôn đến, nói: “Ta có tội với Chúa Hằng Hữu, Đức Chúa Trời các ngươi, và cũng có tội với các ngươi nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Xin tha lỗi cho ta lần này nữa mà thôi, và cầu giùm với Chúa Hằng Hữu, Đức Chúa Trời các ngươi, để Ngài thu tai họa hiểm nghèo này lại.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Môi-se rời Pha-ra-ôn, cầu khẩn Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Chúa Hằng Hữu cho gió tây thổi rất mạnh, đùa hết bầy châu chấu xuống Biển Đỏ. Trên khắp đất nước Ai Cập không còn lại một con nào. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nhưng Chúa Hằng Hữu lại làm cho lòng Pha-ra-ôn chai lì, không cho người Ít-ra-ên đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Chúa Hằng Hữu phán bảo Môi-se: “Đưa tay con lên trời, Ai Cập sẽ tối tăm.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Môi-se đưa tay lên, bóng tối dày đặc phủ khắp Ai Cập suốt ba ngày. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Trong ba ngày ấy, người Ai Cập không đi đâu được cả. Nhưng nơi người Ít-ra-ên ở vẫn có ánh sáng như thường. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pha-ra-ôn mời Môi-se đến, nói: “Đi thờ phụng Chúa Hằng Hữu đi! Các ngươi được phép đem cả trẻ con đi nữa, nhưng phải để bầy súc vật ở lại.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Môi-se đáp: “Vua phải để cho chúng tôi đem theo các lễ vật và con sinh làm tế lễ thiêu dâng lên Chúa Hằng Hữu, Đức Chúa Trời của chúng tôi. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Cả bầy súc vật sẽ đi theo chúng tôi, dù một cái móng cũng không thể để lại, vì chúng tôi sẽ dùng chúng làm lễ vật dâng lên Chúa Hằng Hữu, Đức Chúa Trời chúng tôi. Hiện nay chúng tôi chưa biết con nào sẽ được chọn, chỉ khi đến nơi mới biết được.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Vào lúc ấy, Chúa Hằng Hữu lại làm cho lòng Pha-ra-ôn chai đá, vua không cho người Ít-ra-ên đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pha-ra-ôn đuổi Môi-se: “Đi ra! Đừng bao giờ nhìn mặt ta nữa. Ngày nào ngươi trở lại gặp ta, ngày đó ngươi sẽ chết.” ");
INSERT INTO vieovcb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Môi-se đáp: “Đúng! Tôi sẽ chẳng thấy mặt vua nữa đâu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Chúa Hằng Hữu phán bảo Môi-se: “Ta sẽ giáng một tai họa cuối cùng trên Pha-ra-ôn và trên đất nước Ai Cập, rồi Pha-ra-ôn sẽ cho người Ít-ra-ên ra đi; thật ra, không phải cho ra đi, mà sẽ đuổi đi gấp. ");
INSERT INTO vieovcb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Con dặn bảo dân chúng, cả nam lẫn nữ, đều nhớ xin những người láng giềng Ai Cập các vật phẩm và nữ trang bằng vàng và bằng bạc.” ");
INSERT INTO vieovcb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Chúa Hằng Hữu làm cho người Ai Cập quý mến người Ít-ra-ên, còn Môi-se được quốc dân và quần thần Ai Cập xem là một vĩ nhân.) ");
INSERT INTO vieovcb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Môi-se nói với Pha-ra-ôn: “Đây là điều Chúa Hằng Hữu phán: ‘Vào quãng giữa đêm nay, Ta sẽ tuần hành Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Tất cả con trưởng nam của người Ai Cập sẽ chết, từ thái tử cho đến con của người nô lệ hèn mọn nhất; thậm chí con súc vật đầu lòng của họ cũng chết hết.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tiếng khóc bi thương ai oán sẽ vang khắp Ai Cập; từ xưa, việc này chưa xảy ra bao giờ, trong tương lai cũng sẽ chẳng xảy ra nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nhưng người Ít-ra-ên và thú vật của họ đều bình an vô sự, dù chó cũng chẳng lên tiếng sủa, để vua thấy rõ rằng Chúa Hằng Hữu phân biệt họ với người Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Môi-se tiếp: “Quần thần của vua sẽ chạy đến, quỳ lạy van xin tôi: ‘Xin các ông đi!’ Đến lúc ấy, tôi mới đi.” Nói xong, Môi-se bước ra khỏi cung điện Pha-ra-ôn trong cơn nóng giận. ");
INSERT INTO vieovcb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Trước đó, Chúa Hằng Hữu có phán bảo Môi-se: “Pha-ra-ôn sẽ không chịu nghe lời con, chính vì thế mà Ta có dịp làm thêm nhiều phép lạ trong xứ Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Cho nên, dù Môi-se và A-rôn đã làm nhiều phép lạ ngay trước mắt Pha-ra-ôn, vua vẫn không cho người Ít-ra-ên ra đi, vì Chúa Hằng Hữu càng khiến cho lòng vua chai lì. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Khi Môi-se và A-rôn còn ở Ai Cập, Chúa Hằng Hữu phán bảo họ: ");
INSERT INTO vieovcb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Từ nay về sau, tháng này sẽ được kể là tháng thứ nhất, tức là tháng giêng trong năm. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Phải công bố cho toàn dân Ít-ra-ên biết, vào ngày mồng mười tháng này, mỗi gia đình sẽ bắt một con chiên hay một con dê. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nếu gia đình có ít người, sẽ chung với một gia đình ít người khác trong vòng láng giềng, tính thế nào cho có đủ người ăn hết thịt. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Con chiên hay con dê này phải là một con đực, một tuổi, hoàn toàn tốt lành. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Đợi đến chiều tối ngày mười bốn tháng giêng, mỗi gia đình sẽ giết con vật đã chọn, lấy máu nó bôi lên khung cửa (hai thanh dọc hai bên và thanh ngang bên trên cửa). ");
INSERT INTO vieovcb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Vậy, mỗi nhà phải lấy máu con chiên mình sẽ ăn thịt đem bôi lên khung cửa nhà mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Đêm ấy, mỗi người sẽ ăn thịt chiên quay với bánh không men và rau đắng. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Phải quay nguyên cả con chiên trên lửa, kể cả đầu, chân, và bộ lòng. Đừng luộc thịt chín hoặc tái mà ăn. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Đừng để dành gì cả. Nếu ăn còn thừa, sáng hôm sau phải đốt đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ngày ấy sẽ được gọi là ngày lễ Vượt Qua của Chúa Hằng Hữu. Người ăn lễ phải thắt lưng gọn gàng, tay cầm gậy, chân mang giày, ăn vội vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Đêm ấy, Ta sẽ lướt qua Ai Cập; tất cả các con trưởng nam của dân này sẽ bị giết, luôn cả con đầu lòng của thú vật họ. Ta cũng sẽ trừng phạt các thần của Ai Cập, vì Ta là Chúa Hằng Hữu! ");
INSERT INTO vieovcb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Máu bôi trên khung cửa đánh dấu nhà các ngươi ở. Trong cuộc trừng phạt Ai Cập, khi thấy máu ở trước nhà nào, Ta sẽ bỏ qua nhà ấy. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Từ nay trở đi, hằng năm các ngươi phải giữ lễ này để kỷ niệm ngày Chúa Hằng Hữu giải cứu mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Thời gian hành lễ là bảy ngày. Trong suốt bảy ngày đó, phải ăn bánh không men. Ai ăn bánh có men sẽ bị trục xuất khỏi cộng đồng Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Trong ngày thứ nhất và ngày thứ bảy, sẽ có cuộc hội họp thánh. Không ai được làm việc trong những ngày đó, trừ ra việc bếp núc. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Vậy, đây là ngày Lễ Bánh Không Men các ngươi phải giữ từ thế hệ này sang thế hệ khác, để kỷ niệm ngày Ta giải thoát các ngươi khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Các ngươi chỉ ăn bánh không men từ tối ngày mười bốn cho đến tối ngày hai mươi mốt tháng giêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Trong bảy ngày ấy, không ai được giữ bánh có men trong nhà, vì nếu ai ăn bánh có men, dù là người Ít-ra-ên hay người ngoại kiều, sẽ bị trục xuất khỏi cộng đồng Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Vậy, nhớ ăn bánh không men, đừng đụng đến vật gì có men cả.” ");
INSERT INTO vieovcb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Môi-se họp các bô lão Ít-ra-ên lại, bảo họ: “Các ông lo chọn một số chiên tùy theo số gia đình, để dân chúng giết chiên, cử hành lễ Vượt Qua. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Phải hứng máu chiên trong chậu, lấy một bó bài hương thảo nhúng vào máu, đem bôi lên khung cửa (hai thanh dọc và một thanh ngang bên trên cửa). Đêm đó, không ai được ra khỏi nhà. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Trong cuộc trừng trị Ai Cập, khi Chúa Hằng Hữu đi ngang qua nhà nào có vết máu bôi trên khung cửa; Ngài sẽ vượt qua, không cho kẻ hủy diệt vào nhà ấy. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Việc hành lễ này trở thành một luật vĩnh viễn, từ thế hệ này sang thế hệ khác. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Về sau, khi Chúa Hằng Hữu đã cho các ông vào đất hứa, và khi các ông kỷ niệm ngày này, ");
INSERT INTO vieovcb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","nếu con cháu có hỏi: ‘Ý nghĩa của lễ này là gì?’ ");
INSERT INTO vieovcb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Các ông sẽ đáp: Đây là ngày kỷ niệm Chúa Hằng Hữu giải cứu chúng ta. Trong cuộc trừng phạt Ai Cập, Ngài đã bỏ qua nhà của người Ít-ra-ên, không giết hại chúng ta.” Nghe Môi-se nói xong, họ cúi đầu thờ lạy. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Vậy, người Ít-ra-ên làm mọi điều Môi-se và A-rôn dạy bảo họ theo lệnh Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nửa đêm hôm ấy, Chúa Hằng Hữu đánh phạt các con trưởng nam của người Ai Cập, từ thái tử cho đến con trưởng nam của tù nhân trong ngục tối, luôn cả con đầu lòng của thú vật họ nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pha-ra-ôn, quần thần, và mọi công dân Ai Cập đều chợt thức giấc lúc nửa đêm, vì có tiếng khóc than ai oán vang lên khắp nơi. Không nhà nào trong cả nước mà không có người chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ngay đêm ấy, Pha-ra-ôn đòi Môi-se và A-rôn đến, nói rằng: “Xin đi khỏi chúng ta! Tất cả người Ít-ra-ên cứ đi hết đi, để thờ phụng Chúa Hằng Hữu như các ông đã nói. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Cũng đem theo cả bầy súc vật đi nữa, nhưng đừng quên chúc phước lành cho ta.” ");
INSERT INTO vieovcb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Người Ai Cập hối thúc người Ít-ra-ên phải ra khỏi nước họ lập tức, vì than rằng: “Chúng ta chết cả còn gì!” ");
INSERT INTO vieovcb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Người Ít-ra-ên gói luôn cả thùng nhồi bột vào áo, trong thùng còn nguyên cả bột đã nhồi không pha men, rồi vác lên vai đem đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Họ cũng làm theo lời Môi-se dặn bảo, xin người Ai Cập các món nữ trang vàng và bạc cùng áo xống. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Chúa Hằng Hữu làm cho người Ai Cập quý mến, cho người Ít-ra-ên những gì họ xin. Thế là lần này người Ai Cập bị người Ít-ra-ên tước đoạt của cải! ");
INSERT INTO vieovcb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Vậy người dân Ít-ra-ên ra đi, từ Ram-se hướng đến Su-cốt; tổng số khoảng 600.000, không kể phụ nữ và trẻ con. Tất cả đều đi bộ. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Cũng có nhiều người ngoại tộc cùng đi với họ. Họ dẫn theo vô số súc vật. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Dọc đường, họ lấy bột mang theo từ Ai Cập, nướng thành bánh mà ăn. Đó là bột không men họ đã vội vàng bọc theo, khi bị đuổi khỏi Ai Cập, vì lúc ấy không kịp dự bị lương thực gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Thời gian người Ít-ra-ên ở Ai Cập là 430 năm. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Đúng vào ngày cuối của năm thứ 430, toàn thể quân đội của Chúa Hằng Hữu bắt đầu rời Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Vào đêm ấy, chính Chúa Hằng Hữu đã giải thoát Ít-ra-ên khỏi Ai Cập. Vậy mỗi năm cứ đến đêm này, người Ít-ra-ên tổ chức lễ tri ân Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Chúa Hằng Hữu phán dạy Môi-se và A-rôn rằng: “Đây là các quy tắc về lễ Vượt Qua: Người ngoại tộc không được ăn lễ. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Về các nô lệ người Ít-ra-ên đã mua, chỉ người nào chịu cắt bì mới được phép ăn lễ. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Đầy tớ làm mướn và người ngoại tộc tạm trú không được ăn lễ. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Thịt phải ăn nội trong nhà, đừng đem ra ngoài, cũng đừng làm gãy một cái xương nào. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tất cả cộng đồng Ít-ra-ên đều dự lễ Vượt Qua. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Người đàn ông ngoại kiều sống chung trong xã hội Ít-ra-ên muốn dự lễ Vượt Qua của Chúa Hằng Hữu thì phải chịu cắt bì, nếu không sẽ không được ăn lễ. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Quy tắc này áp dụng chung cho người sinh ra trong đất Ít-ra-ên và cho ngoại kiều tạm trú.” ");
INSERT INTO vieovcb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Người Ít-ra-ên tuân hành mọi huấn lệnh Chúa Hằng Hữu đã truyền cho Môi-se và A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Chính trong ngày đó, Chúa Hằng Hữu dẫn người Ít-ra-ên ra khỏi Ai Cập theo đội ngũ. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Người Ít-ra-ên phải hiến dâng lên Ta tất cả con đầu lòng, kể cả con đầu lòng của thú vật, vì chúng nó thuộc về Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Sau đó, Môi-se nói với dân mình: “Chúng ta phải ghi nhớ ngày hôm nay đến muôn đời, vì hôm nay là ngày Chúa Hằng Hữu ra tay toàn năng giải thoát chúng ta khỏi ách nô lệ Ai Cập. Khi kỷ niệm ngày này, không ai được ăn bánh có men. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hằng năm phải nhớ kỷ niệm ngày này, là ngày mồng mười tháng giêng, ");
INSERT INTO vieovcb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","khi Chúa Hằng Hữu đã đem chúng ta vào đất của người Ca-na-an, người Hê-tít, người A-mô-rít, người Hê-vi, và người Giê-bu rồi (đất này rất phì nhiêu, là đất Chúa Hằng Hữu đã hứa với các tổ tiên). ");
INSERT INTO vieovcb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Trong bảy ngày, anh em sẽ ăn bánh không men; đến ngày thứ bảy, phải tổ chức ngày lễ cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Trong bảy ngày, phải ăn bánh không men. Bánh có men, hoặc men sẽ không được xuất hiện ở bất cứ nơi nào trên khắp lãnh thổ. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Nhân dịp này, nhớ nói cho con cháu biết rằng: ‘Ta giữ lễ để ghi nhớ những việc Chúa Hằng Hữu đã làm cho ta khi ra khỏi Ai Cập.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Việc giữ lễ này và việc nhắc nhở luật pháp của Chúa Hằng Hữu sẽ chẳng khác gì dấu ghi trên trán và trên tay, để đừng ai quên rằng chính Chúa Hằng Hữu đã dùng tay toàn năng Ngài đem chúng ta ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Vậy, hằng năm, phải nhớ giữ lễ đúng ngày giờ đã ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Khi Chúa Hằng Hữu đã đem toàn dân vào đất Ca-na-an rồi, như lời Ngài đã hứa với các tổ tiên, ");
INSERT INTO vieovcb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","phải nhớ hiến dâng lên Chúa Hằng Hữu con trưởng nam và con đực đầu lòng của súc vật mình, vì chúng nó thuộc về Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Phải dùng chiên hoặc dê con để chuộc lại các con lừa đầu lòng, nếu lừa không được chuộc, nó phải bị giết. Dĩ nhiên, ai nấy phải chuộc con trưởng nam mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Khi nào con cái hỏi cha mẹ: ‘Lệ này có ý nghĩa gì?’ Thì đáp rằng: ‘Chúa Hằng Hữu đã ra tay toàn năng giải thoát chúng ta khỏi ách nô lệ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Khi Pha-ra-ôn ngoan cố không chịu cho chúng ta ra đi, Chúa Hằng Hữu đã đánh phạt các con đầu lòng của Ai Cập, cả con trưởng nam lẫn con đầu lòng của súc vật. Vì thế cho nên ngày nay ta hiến dâng mọi con đầu lòng lên Chúa Hằng Hữu, nhưng ta chuộc con trưởng nam lại.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Lễ này chẳng khác gì dấu ghi trên tay và trên trán để chúng ta nhớ luôn rằng Chúa Hằng Hữu đã dùng tay toàn năng Ngài giải thoát chúng ta ra khỏi Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sau khi Pha-ra-ôn để cho người Ít-ra-ên ra đi, Đức Chúa Trời không dẫn họ qua đất Phi-li-tin, là đường ngắn nhất để vào đất hứa. Ngài phán: “E khi dân chúng thấy chiến trận, họ sẽ đổi ý và quay lại Ai Cập chăng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ngài biết rằng khi gặp chiến tranh, họ có thể đổi ý mà quay về Ai Cập, mặc dù họ đã được trang bị khí giới khi rời Ai Cập. Do đó Chúa dẫn họ qua Biển Đỏ, đi vào lối hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Môi-se đem hài cốt của Giô-sép theo, vì Giô-sép có buộc con cháu Ít-ra-ên thề hứa dời hài cốt ông khi ông trối: “Chắc chắn Đức Chúa Trời sẽ thăm viếng dân ta, vậy khi ra khỏi Ai Cập, phải nhớ đem hài cốt ta theo.” ");
INSERT INTO vieovcb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Rời Su-cốt, họ dừng chân đóng trại tại Ê-tam, ven hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ban ngày Chúa Hằng Hữu dẫn lối họ bằng một trụ mây và ban đêm bằng một trụ lửa. Như vậy, họ có thể ra đi bất kể đêm ngày. ");
INSERT INTO vieovcb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Trụ mây và trụ lửa chẳng bao giờ cách xa họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Lúc ấy, Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ra lệnh cho người Ít-ra-ên quay lại về hướng Phi Ha-hi-rốt, giữa Mích-đôn và biển, ngang Ba-anh Sê-phôn, rồi đóng trại dọc bờ biển tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Làm như thế để Pha-ra-ôn nghĩ rằng người Ít-ra-ên đã đi lòng vòng vì hoang mạc mênh mông đã làm họ lạc hướng. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ta sẽ làm cho Pha-ra-ôn lại ngoan cố, đuổi theo người Ít-ra-ên. Rồi Ta sẽ rạng danh vì Pha-ra-ôn và quân đội của vua, và toàn dân Ai Cập sẽ biết Ta là Chúa Hằng Hữu.” Người Ít-ra-ên làm theo đúng như vậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Khi vua Ai Cập hay tin người Ít-ra-ên đã dứt khoát ra đi, Pha-ra-ôn và quần thần liền thay đổi ý kiến đối với người Ít-ra-ên. Họ hỏi nhau: “Tại sao ta dại dột như thế? Tại sao ta thả cho đám nô lệ ra đi?” ");
INSERT INTO vieovcb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pha-ra-ôn vội lên xe, dẫn quân đuổi theo. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Họ huy động 600 chiến xa tốt nhất của Ai Cập, do các tướng chỉ huy điều khiển. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Chúa Hằng Hữu làm cho lòng Pha-ra-ôn, vua Ai Cập cứng cỏi, nhất định đuổi theo người Ít-ra-ên, trong khi dân này ra đi dưới sự hướng dẫn tối cao. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Người Ai Cập gồm ngựa, xe, lính kỵ, lính bộ cùng Pha-ra-ôn và quân đội đuổi kịp người Ít-ra-ên, gặp họ đang cắm trại dọc bờ biển gần Phi Ha-hi-rốt, ngang Ba-anh Sê-phôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Trông thấy Pha-ra-ôn dẫn quân Ai Cập đuổi theo gần kịp, người Ít-ra-ên kêu la khiếp đảm, van xin Chúa Hằng Hữu cứu giúp. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Có người quay ra trách móc Môi-se: “Có phải vì Ai Cập không đủ đất chôn nên ông mới đem chúng tôi vào hoang mạc để vùi xác không? Nếu không, tại sao ông bắt chúng tôi bỏ Ai Cập? ");
INSERT INTO vieovcb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Lúc còn ở Ai Cập, chúng tôi đã nói trước rằng thà cứ để chúng tôi ở lại làm nô lệ còn hơn ra đi rồi chết trong hoang mạc.” ");
INSERT INTO vieovcb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nhưng Môi-se nói với họ: “Đừng sợ! Cứ vững tâm chờ xem Chúa Hằng Hữu hành động. Ngài sẽ ra tay giải cứu chúng ta. Những người Ai Cập hôm nay anh em thấy đó, sẽ không bao giờ thấy lại nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Chúa Hằng Hữu sẽ chiến đấu, còn anh em cứ yên lặng!” ");
INSERT INTO vieovcb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Chúa Hằng Hữu phán bảo Môi-se: “Đừng kêu ca nữa, nhưng cứ ra lệnh cho toàn dân tiếp tục đi tới. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Rồi con cầm gậy đưa ra trên mặt biển, nước sẽ vạch ra hai bên, chừa lối khô ráo cho người Ít-ra-ên đi qua. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ta sẽ làm cho người Ai Cập cứng lòng, một mực đuổi theo Ít-ra-ên xuống biển, Ta sẽ được tôn vinh vì Pha-ra-ôn, vì cả quân đội, chiến xa, và kỵ binh của ông ấy ");
INSERT INTO vieovcb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ta sẽ được hiển vinh chính vì họ, từ Pha-ra-ôn đến quân đội Ai Cập và ngựa xe của họ. Rồi đây toàn dân Ai Cập sẽ biết tôn vinh Ta là Chúa Hằng Hữu!” ");
INSERT INTO vieovcb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Thiên sứ của Đức Chúa Trời đang đi trước hướng dẫn Ít-ra-ên liền quay lại đi từ phía sau, còn trụ mây cũng từ phía trước dời ra sau, ");
INSERT INTO vieovcb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","đứng án ngữ giữa trại Ít-ra-ên và trại Ai Cập. Suốt đêm đó, trụ mây đứng che bóng, làm cho người Ai Cập bị tối tăm, nhưng lại rọi sáng cho người Ít-ra-ên. Vì thế hai bên không đến gần nhau được. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Môi-se đưa gậy trên biển, Chúa Hằng Hữu liền làm cho nước dồn lại, mở một lối đi băng qua biển. Suốt đêm ấy, gió đông thổi mạnh, đáy biển cạn khô, ");
INSERT INTO vieovcb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","người Ít-ra-ên đi qua biển như đi trên đất khô. Hai bên lối đi có hai bức thành bằng nước dựng đứng thẳng tắp. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Người Ai Cập tiếp tục đuổi theo. Toàn đạo quân Pha-ra-ôn, gồm xe, ngựa, kỵ binh, đều theo lối đi băng biển của người Ít-ra-ên mà tiến tới. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Trời gần sáng, từ trong trụ mây và trụ lửa, Chúa Hằng Hữu nhìn xuống quân đội Ai Cập, và làm cho họ rối loạn. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ngài tháo bánh xe chiến xa của họ, khiến họ kéo xe cực nhọc. Thấy vậy, họ bảo nhau: “Tránh xa người Ít-ra-ên mau lên! Chúa Hằng Hữu thay họ đánh người Ai Cập!” ");
INSERT INTO vieovcb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Chúa Hằng Hữu phán bảo Môi-se: “Bây giờ, con đưa tay trên biển, nước sẽ ào lại chôn vùi người Ai Cập cùng với xe và ngựa của họ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Môi-se vâng lời và vào lúc hừng đông, nước ào lại, mặt biển trở lại như cũ. Người Ai Cập cố chạy trốn, nhưng đều bị Chúa Hằng Hữu dùa vào lòng biển. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nước nhận chìm người Ai Cập, cùng với ngựa, xe của họ. Trong các quân đoàn của Pha-ra-ôn đuổi theo Ít-ra-ên xuống biển, không một ai sống sót. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Nhưng người Ít-ra-ên đã đi qua biển như đi trên cạn, hai bên họ là hai tường thành bằng nước. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Vậy, hôm ấy Chúa Hằng Hữu giải cứu người Ít-ra-ên khỏi tay người Ai Cập. Người Ít-ra-ên nhìn thấy xác người Ai Cập tấp đầy bờ biển. ");
INSERT INTO vieovcb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Chứng kiến phép lạ Chúa Hằng Hữu đã làm cho người Ai Cập, người Ít-ra-ên đem lòng kính sợ và tin tưởng nơi Ngài và Môi-se, đầy tớ của Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Bấy giờ, Môi-se và dân Ít-ra-ên hát lên bài ca này cho Chúa Hằng Hữu: “Ta ca ngợi Chúa Hằng Hữu, vì Ngài chiến thắng huy hoàng vẻ vang; Ngài đưa tay ném vào biển cả đoàn ngựa chiến lẫn quân kỵ mã. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Chúa Hằng Hữu là sức mạnh ta, bài ca của ta; Đấng giải cứu là Giê-hô-va. Chúa là Đức Chúa Trời, ta hằng ca tụng— là Đức Chúa Trời, tổ tiên ta thờ phụng! ");
INSERT INTO vieovcb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Chúa là Danh Tướng anh hùng; Tự Hữu Hằng Hữu chính là Danh Ngài! ");
INSERT INTO vieovcb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Các chiến xa và tướng sĩ của Pha-ra-ôn bị Ngài ném xuống biển. Các quan chỉ huy Ai Cập tinh luyện đều chìm lỉm dưới Biển Đỏ. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Như đá sỏi chìm xuống đáy biển sâu. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Lạy Chúa Hằng Hữu, cánh tay Ngài rạng ngời quyền uy. Lạy Chúa Hằng Hữu, tay phải Ngài đập quân thù tan nát. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ngài đánh phá địch bằng uy đức vô song. Lửa giận Ngài thiêu chúng cháy phừng như rơm rạ. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nước biển dồn lại, khí phẫn nộ Ngài thổi nhanh! Khiến nước xây như bức thành; ngay giữa lòng trùng dương man mác. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Địch quân nói: ‘Ta sẽ đuổi theo chúng và bắt được chúng. Ta vung gươm chém giết tơi bời, chia nhau cướp phá, hả hê cuộc đời.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nhưng Ngài thổi gió tới, và biển vùi lấp họ đi. Họ chìm lỉm như chì, giữa làn nước mênh mông. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Có ai như Chúa Hằng Hữu— Thần nào thánh khiết vô song như Ngài? Quyền năng, phép tắc vô nhai. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ngài dang tay phải ra, đất nuốt ngay quân thù. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Với lòng thương xót Ngài dắt dẫn và cứu chuộc dân Ngài. Trong quyền năng, Ngài đưa họ về nơi ở thánh của Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Các nước nghe tin đều khiếp kinh; hãi hùng xâm chiếm cõi lòng Phi-li-tin. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Các lãnh đạo Ê-đôm kinh hoảng; các dũng sĩ Mô-áp cũng run lay. Người Ca-na-an hồn vía lên mây. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Chúa Hằng Hữu ơi, do quyền lực Chúa, quân thù đứng trơ như đá khi người Ngài cứu chuộc đi qua. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Được Chúa đem trồng trên đỉnh núi— là nơi mà Chúa Hằng Hữu đã chọn để ngự trị, là nơi thánh do tay Ngài thiết lập nên. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Chúa Hằng Hữu sẽ cai trị mãi mãi đời đời!” ");
INSERT INTO vieovcb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ngựa xe của vua Pha-ra-ôn cùng kỵ mã đã nằm yên trong lòng biển cả, nhưng người Chúa Hằng Hữu vẫn kéo quân vượt Biển Đỏ như qua đất bằng. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nữ Tiên tri Mi-ri-am, là chị của A-rôn, đứng ra hướng dẫn các phụ nữ; mỗi người tay cầm trống nhỏ và nhảy múa. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mi-ri-am hát bài ca này: “Hát lên, ca ngợi Chúa Hằng Hữu, vì Ngài toàn thắng địch quân bạo tàn; chiến đoàn kỵ mã kiêu căng chôn vùi dưới lòng sâu của biển.” ");
INSERT INTO vieovcb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Sau đó, Môi-se dẫn người Ít-ra-ên từ Biển Đỏ đi đến hoang mạc Su-rơ. Trọn ba ngày đường họ không tìm được nước. ");
INSERT INTO vieovcb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Khi đến Ma-ra, nước tuy có, nhưng quá đắng không uống được. Chính vì thế mà nơi ấy có tên là Ma-ra (nghĩa là đắng). ");
INSERT INTO vieovcb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Dân chúng phàn nàn với Môi-se: “Chúng tôi lấy gì để uống đây?” ");
INSERT INTO vieovcb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Môi-se kêu cầu Chúa Hằng Hữu. Ngài chỉ cho ông một khúc cây, bảo ông cầm lấy ném vào nước. Nước liền hóa ra ngọt. Chính tại Ma-ra là nơi Chúa Hằng Hữu đã quy định nguyên tắc sau đây cho người Ít-ra-ên theo, để thử thách họ: ");
INSERT INTO vieovcb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Nếu các ngươi chuyên tâm lắng nghe tiếng Ta là Chúa Hằng Hữu, Đức Chúa Trời ngươi, thi hành các điều ngay điều phải Ta truyền bảo, tức là dưới mắt Ta vâng giữ điều răn Ta và luật lệ Ta thì các ngươi sẽ không mắc phải một bệnh nào Ta đã giáng trên người Ai Cập, vì Ta là Chúa Hằng Hữu, Đấng chữa bệnh các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Rồi họ đi đến Ê-lim, là nơi có mười hai suối nước và bảy mươi cây chà là, và đóng trại bên cạnh các suối nước đó. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Rời Ê-lim, đoàn người Ít-ra-ên tiếp tục lên đường, đến hoang mạc Sin (giữa Ê-lim và núi Si-nai) vào ngày mười lăm tháng hai, tính từ ngày ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ở đó, đoàn người Ít-ra-ên lại cằn nhằn Môi-se và A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Họ than khóc: “Chẳng thà chúng tôi cứ ở lại Ai Cập mà ăn thịt bánh no nê, rồi dù có bị Chúa Hằng Hữu giết tại đó đi nữa, cũng còn hơn theo hai ông vào giữa hoang mạc này để chết đói.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Chúa Hằng Hữu phán bảo Môi-se: “Ta sẽ làm bánh rơi xuống từ trời như mưa. Ngày ngày, mỗi người sẽ đi ra nhặt bánh; nhưng chỉ nhặt đủ ăn trong ngày. Ta muốn thử xem họ có vâng lời Ta không. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ngày thứ sáu họ phải nhặt gấp đôi số bánh hằng ngày.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Vậy, Môi-se và A-rôn nói với đoàn người Ít-ra-ên: “Chiều hôm nay, mọi người sẽ nhận biết chính Chúa Hằng Hữu đã dẫn anh chị em ra khỏi Ai Cập; ");
INSERT INTO vieovcb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","rồi đến sáng, sẽ chiêm ngưỡng vinh quang của Chúa Hằng Hữu, vì Ngài có nghe lời cằn nhằn oán trách rồi. Chúng tôi là ai, mà anh chị em cằn nhằn chúng tôi? ");
INSERT INTO vieovcb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Môi-se cũng nói với họ: Anh chị em sẽ nhận biết Chúa Hằng Hữu khi Ngài ban cho thịt vào buổi chiều và bánh vào buổi sáng. Thật ra, anh chị em đã oán trách Chúa chứ không phải oán trách chúng tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Môi-se nói với A-rôn: “Hãy nói với toàn dân Ít-ra-ên rằng: ‘Bây giờ, toàn dân hãy đến đây trước mặt Chúa Hằng Hữu, vì Ngài đã nghe lời cằn nhằn của anh chị em.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Trong khi A-rôn còn đang nói với toàn dân, bỗng, về phía hoang mạc, vinh quang của Chúa Hằng Hữu chói lọi trong áng mây. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ta đã nghe lời họ cằn nhằn. Con cho họ hay rằng buổi chiều họ sẽ có thịt, buổi sáng có bánh ăn dư dật để họ biết Ta là Chúa Hằng Hữu, Đức Chúa Trời của họ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Chiều hôm ấy, chim cút bay đến vô số, bao phủ cả trại. Đến sáng, chung quanh trại có một lớp sương dày. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Lớp sương tan đi, để lại trên mặt cát hoang mạc những hạt nhỏ và mịn. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Người Ít-ra-ên trông thấy, hỏi nhau: “Vật gì vậy?” Môi-se nói: “Đó là bánh Chúa Hằng Hữu cho anh chị em.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ông tiếp: “Chúa Hằng Hữu phán dạy mỗi người thu nhặt bánh ấy tùy theo nhu cầu của gia đình mình, chừng hai lít mỗi đầu người.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Người Ít-ra-ên bắt đầu đi ra nhặt bánh, ước chừng hai lít cho mỗi người. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nhưng dù có ai nhặt nhiều cũng không thừa; ai nhặt ít cũng không thiếu. Mỗi người nhặt đủ cho mình ăn. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mặc dù Môi-se có căn dặn: “Đừng ai để dành bánh đến ngày mai,” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","nhưng có người vẫn không vâng lời, để bánh lại đến sáng hôm sau, bánh hóa giòi và hôi hám. Vì thế, Môi-se giận họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Cho nên, cứ sáng ra, mỗi người đi nhặt bánh vừa đủ ăn trong ngày; và khi nắng chiếu nóng mặt đất, bánh liền tan đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ngày thứ sáu, họ nhặt gấp đôi phần bánh ngày thường, mỗi người chừng bốn lít. Các bậc huynh trưởng có đến hỏi Môi-se về việc này, ");
INSERT INTO vieovcb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ông đáp: “Theo huấn thị của Chúa Hằng Hữu, ngày mai là ngày Sa-bát thánh dành cho Chúa Hằng Hữu, mọi người đều nghỉ ngơi. Vậy, hôm nay cứ nấu nướng dư dả, để dành một phần cho ngày mai.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Phần bánh người ta để dành qua hôm sau theo lời Môi-se dặn, vẫn tốt lành, không sâu bọ, không hôi hám. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Môi-se nói: “Đó là phần ăn ngày hôm nay, vì hôm nay là ngày Sa-bát của Chúa Hằng Hữu, sẽ không có bánh trên mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mọi người sẽ nhặt bánh trong sáu ngày, nhưng ngày thứ bảy là lễ Sa-bát sẽ không có bánh.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Tuy nhiên, cũng có vài người cứ đi nhặt bánh ngày thứ bảy, nhưng chẳng được gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Chúa Hằng Hữu hỏi Môi-se: “Tại sao những người này không chịu nghe lời Ta? ");
INSERT INTO vieovcb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Hãy nhớ rằng Chúa Hằng Hữu đã cho các con ngày sa-bát, vì thế vào ngày thứ sáu Ngài ban cho các con hai ngày bánh. Trong ngày thứ bảy, không ai được ra khỏi nhà nhặt bánh.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Vậy, người ta đều nghỉ ngơi ngày thứ bảy. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Người Ít-ra-ên gọi bánh này là ma-na, nó giống như hạt ngò, sắc trắng, và có vị ngọt như bánh mật ong. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Môi-se truyền cho họ lệnh của Chúa Hằng Hữu: “Lấy hai lít ma-na để cất giữ, lưu truyền lại cho hậu thế thấy thứ bánh Chúa Hằng Hữu dùng để nuôi người Ít-ra-ên trong hoang mạc sau khi rút họ ra khỏi Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Vậy, Môi-se bảo A-rôn lấy một cái bình đổ hai lít ma-na vào, để giữ lại trước mặt Chúa Hằng Hữu từ thế hệ này sang thế hệ khác. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","A-rôn vâng lời, làm theo lệnh Chúa Hằng Hữu truyền cho Môi-se. Bình ma-na vì thế được để trong “Hòm Giao Ước.” ");
INSERT INTO vieovcb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Người Ít-ra-ên ăn ma-na trong suốt bốn mươi năm cho đến khi vào đất Ca-na-an, là nơi họ định cư. ");
INSERT INTO vieovcb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Thùng chứa được dùng để do lường ma-na là một ô-me bằng một phần mười ê-pha. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Người Ít-ra-ên ra đi từng chặng một, theo lệnh của Chúa Hằng Hữu. Từ hoang mạc Sin, họ dừng chân đóng trại tại Rê-phi-đim, nhưng ở đây không có nước. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Họ gây chuyện với Môi-se: “Nước đâu cho chúng tôi uống?” Môi-se hỏi: “Tại sao sinh sự với tôi? Anh chị em muốn thử Chúa Hằng Hữu phải không?” ");
INSERT INTO vieovcb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Nhưng vì khát quá, họ lại càu nhàu với Môi-se: “Tại sao ông đem chúng tôi ra khỏi Ai Cập làm gì? Tại sao ông dẫn chúng tôi, con cái, và súc vật chúng tôi đến đây để cùng nhau chết khát?” ");
INSERT INTO vieovcb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Môi-se kêu cầu Chúa Hằng Hữu: “Con phải làm gì đây? Họ gần đến độ lấy đá ném con rồi!” ");
INSERT INTO vieovcb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Chúa Hằng Hữu phán bảo Môi-se: “Hãy đi trước dân chúng, dẫn theo một số trưởng lão Ít-ra-ên và cầm trong tay cây gậy mà con đã đập dưới sông Nin. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ta sẽ đứng trước mặt con trên tảng đá ở Hô-rếp. Hãy đập tảng đá, nước sẽ chảy ra cho họ uống.” Môi-se làm đúng lời Chúa phán, nước từ tảng đá chảy vọt ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ông đặt tên chỗ ấy là Ma-sa và Mê-ri-ba, vì tại nơi này người Ít-ra-ên đã thử Chúa khi họ nói: “Xem thử Chúa Hằng Hữu có ở với chúng ta không?” Và cũng chính tại đó, họ đã cãi nhau với ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Lúc ấy, người A-ma-léc kéo quân đến Rê-phi-đim khiêu chiến với Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Môi-se nói với Giô-suê: “Tuyển chọn trong dân chúng một số người ra chiến đấu với quân A-ma-léc. Ngày mai, tôi sẽ cầm gậy Đức Chúa Trời, lên đứng trên đỉnh đồi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Vậy, trong khi Giô-suê dẫn đoàn quân ra chiến đấu với quân A-ma-léc, Môi-se, A-rôn, và Hu-rơ trèo lên đỉnh đồi. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Suốt thời gian đôi bên giáp trận, hễ khi nào Môi-se cầm gậy đưa lên, thì Ít-ra-ên thắng thế. Nhưng khi ông để tay xuống, bên A-ma-léc lại thắng lợi. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Dần dần, tay Môi-se mỏi. A-rôn và Hu-rơ khuân một tảng đá đến cho ông ngồi, rồi đứng hai bên đỡ tay ông lên cho đến khi mặt trời lặn. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Như thế, quân A-ma-léc bị đánh bại dưới lưỡi gươm Giô-suê. ");
INSERT INTO vieovcb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Chúa Hằng Hữu phán bảo Môi-se: “Con chép việc này vào sách để ghi nhớ, và nói với Giô-suê rằng Ta sẽ tuyệt diệt người A-ma-léc, xóa sạch vết tích của họ dưới trời.” ");
INSERT INTO vieovcb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Môi-se xây một bàn thờ, đặt tên là “Chúa Hằng Hữu Ni-xi” (nghĩa là “Chúa Hằng Hữu, ngọn cờ của tôi”). ");
INSERT INTO vieovcb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ông nói: “Giương cao ngọn cờ của Chúa Hằng Hữu lên! Vì Chúa Hằng Hữu sẽ đánh A-ma-léc từ đời này sang đời khác.” ");
INSERT INTO vieovcb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ông gia Môi-se là Giê-trô, thầy tế lễ tại Ma-đi-an, có nghe về những việc diệu kỳ Đức Chúa Trời đã làm cho Môi-se và người Ít-ra-ên, và về cách Chúa Hằng Hữu đã đem họ ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Vậy, Giê-trô dẫn vợ Môi-se là Sê-phô-ra và hai con trai đến (vì trước đó, Môi-se đã đưa vợ con về nhà ông gia). ");
INSERT INTO vieovcb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Người con thứ nhất tên là Ghẹt-sôn (vì lúc sinh, Môi-se nói: “Tôi là ngoại kiều, ở nơi đất khách quê người”), ");
INSERT INTO vieovcb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","người thứ hai tên là Ê-li-ê-se (vì Môi-se nói: “Đức Chúa Trời của tổ tiên tôi đã giúp đỡ và cứu tôi thoát khỏi lưỡi gươm Pha-ra-ôn”). ");
INSERT INTO vieovcb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Giê-trô, ông gia Môi-se, đem Sê-phô-ra và hai cháu đến nơi, khi người Ít-ra-ên đang cắm trại tại núi của Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Giê-trô sai người báo tin cho Môi-se: “Có ông gia và vợ con anh đến.” ");
INSERT INTO vieovcb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Môi-se ra đón ông gia mình, cung kính cúi đầu chào và hôn ông. Họ hỏi thăm nhau sức khỏe rồi cùng nhau vào trại. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Môi-se kể cho ông gia mình nghe mọi việc Chúa Hằng Hữu đã làm cho Pha-ra-ôn và người Ai Cập để cứu người Ít-ra-ên, cũng như tất cả nỗi khó khăn dọc đường, và cách Chúa Hằng Hữu đã cứu giúp họ trong mỗi trường hợp. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Sau khi nghe nói về những việc Chúa Hằng Hữu đã làm cho Ít-ra-ên, và về việc Ngài giải cứu họ khỏi bạo quyền Ai Cập, lòng Giê-trô hân hoan phấn khởi. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ông nói với con rể: “Cảm tạ Chúa Hằng Hữu, vì Ngài đã cứu con và toàn dân Ít-ra-ên khỏi quyền lực của Pha-ra-ôn và người Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Bây giờ cha biết rằng Chúa Hằng Hữu vĩ đại hơn tất cả các thần, vì đã giải thoát dân Ngài khỏi thế lực kiêu cường Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Giê-trô, ông gia của Môi-se dâng lên Đức Chúa Trời các lễ vật và một của lễ thiêu. Sau đó, họ cùng dùng bữa trước mặt Đức Chúa Trời, có cả A-rôn và các bô lão Ít-ra-ên tham dự. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ngày hôm sau, Môi-se ra ngồi xét xử dân chúng từ sáng đến chiều tối. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Giê-trô thấy thế, hỏi Môi-se: “Con làm gì mà ngồi một mình, còn dân phải đứng đợi từ sáng đến tối thế?” ");
INSERT INTO vieovcb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Môi-se đáp: “Trong dân chúng, nếu ai có điều gì thắc mắc, thì đến thỉnh ý Đức Chúa Trời; ");
INSERT INTO vieovcb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","còn nếu ai có việc tranh chấp, con sẽ phân xử đôi bên căn cứ theo luật Đức Chúa Trời, đồng thời dạy dỗ họ theo đường lối Ngài.” ");
INSERT INTO vieovcb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nhưng Giê-trô, ông gia Môi-se nói: “Con làm như thế không tiện. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Công việc nặng nề quá, một mình con làm sao nổi? Con sẽ kiệt quệ và dân cũng mỏi mòn. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Cầu xin Chúa Hằng Hữu phù hộ con, và xin con nghe cha khuyên một lời: Con là người đại diện của dân trước mặt Đức Chúa Trời. Con sẽ trình lên Đức Chúa Trời mọi việc khó khăn họ gặp để thỉnh ý Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Rồi con sẽ cho họ biết ý Đức Chúa Trời, và dạy dỗ họ dựa trên các nguyên tắc, luật lệ của Đức Chúa Trời, để họ theo đúng đường lối Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nhưng con nên chọn những người có khả năng, kính sợ Đức Chúa Trời, chân thật, ghét hối lộ; rồi bổ nhiệm họ vào các cấp lãnh đạo, trông coi hàng nghìn, hàng trăm, hàng năm mươi và hàng mười người. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Họ sẽ lấy công lý xử dân chúng hằng ngày. Trừ những việc quan trọng họ trình lên con, còn các việc thông thường, họ sẽ xử lấy. Như thế họ san sẻ gánh nặng với con. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nếu con nghe lời cha khuyên và nếu Đức Chúa Trời cho phép, con mới kham nổi trọng trách và dân mới an lòng, đi đến nơi đến chốn.” ");
INSERT INTO vieovcb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Môi-se nghe theo lời bàn của ông gia. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ông chọn trong những người có khả năng, chỉ định họ trông coi hàng nghìn, hàng trăm, hàng năm mươi, và hàng mười người. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Hằng ngày, họ giải quyết những việc thông thường, còn việc trọng đại, họ trình lên cho Môi-se quyết định. ");
INSERT INTO vieovcb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Sau đó ít lâu, Giê-trô từ giã Môi-se trở về xứ mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Từ Ai Cập ra đi đúng ba tháng, người Ít-ra-ên đến hoang mạc Si-nai. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Họ đi từ Rê-phi-đim đến hoang mạc Si-nai, rồi cắm trại đối diện núi. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Từ trên núi, Đức Chúa Trời gọi Môi-se, ông liền lên gặp Ngài. Chúa Hằng Hữu phán bảo ông: “Con hãy nói với nhà Gia-cốp, và lặp lại cho người Ít-ra-ên nghe những lời này: ");
INSERT INTO vieovcb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Các ngươi đã thấy việc Ta làm cho người Ai Cập, cũng đã biết Ta đem các ngươi đến với Ta bằng cách nào, chẳng khác gì dùng cánh đại bàng chở các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Vậy, nếu các ngươi vâng lời Ta và giữ lời giao ước Ta, các ngươi sẽ là dân riêng của Ta giữa vòng muôn dân trên thế giới, vì cả thế giới đều thuộc về Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Các ngươi sẽ là người thánh, phụ trách việc tế lễ cho Ta. Đó là lời con phải nói lại cho người Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Môi-se từ núi trở về, mời các trưởng lão đến, lặp lại cho họ nghe mọi lời Chúa Hằng Hữu đã phán dặn. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Họ đồng thanh đáp: “Chúng tôi xin làm mọi điều Chúa Hằng Hữu đã dạy bảo.” Môi-se trình lại các lời đó lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Chúa Hằng Hữu hứa với Môi-se: “Ta sẽ đến cùng con trong đám mây dày đặc, để dân chúng sẽ nghe Ta nói với con, và sẽ tin tưởng nơi con mãi mãi. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Bây giờ con về, bảo dân phải giặt áo xống, giữ mình thanh sạch hôm nay và ngày mai, ");
INSERT INTO vieovcb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","đến ngày thứ ba phải sẵn sàng để chiêm ngưỡng Chúa Hằng Hữu khi Chúa Hằng Hữu giáng lâm tại núi Si-nai. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Con cũng phải vạch đường ranh giới chung quanh núi, cấm không ai được vượt qua, và căn dặn dân: Phải cẩn thận, tuyệt đối không được lên núi. Người nào dù chỉ chạm đến chân núi cũng phải tội chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Đừng ai đụng đến người ấy, nhưng phải ném đá hoặc bắn tên cho chết; dù thú vật cũng phải chết như vậy. Chỉ khi nào có tiếng kèn thổi, mọi người mới có phép đến gần chân núi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Vậy, Môi-se xuống núi, bảo dân giữ mình thanh sạch, giặt áo xống. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ông căn dặn họ: “Phải giữ mình thanh sạch từ hôm nay cho đến ngày thứ ba không được đến gần đàn bà.” ");
INSERT INTO vieovcb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Đến sáng hôm thứ ba, chớp nhoáng sấm sét nổi lên, một đám mây dày đặc trùm lấy núi, tiếng kèn thổi vang động làm cho mọi người run sợ. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Môi-se dẫn dân ra khỏi trại nghênh đón Đức Chúa Trời. Họ đứng lại dưới chân núi. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Khắp Núi Si-nai đều có khói phủ kín, bay lên như từ lò lửa hực, vì Chúa Hằng Hữu giáng lâm trên núi như lửa cháy. Cả ngọn núi rung động dữ dội. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Trong khi tiếng kèn càng lúc càng vang động, Môi-se bắt đầu nói, và Đức Chúa Trời đáp lại, tiếng vang như sấm. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Như vậy, Chúa Hằng Hữu giáng lâm trên đỉnh Núi Si-nai, gọi Môi-se và ông liền lên gặp Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Sau đó, Chúa Hằng Hữu phán bảo Môi-se: “Hãy xuống núi nghiêm cấm người không được vượt ranh giới lên núi tìm xem Đức Chúa Trời, vì như thế họ phải chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ngay các thầy tế lễ muốn đến gần Chúa Hằng Hữu cũng phải giữ mình thanh sạch, nếu không cũng phải chết.” ");
INSERT INTO vieovcb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Môi-se thưa: “Thưa Chúa Hằng Hữu, chẳng có ai dám lên Núi Si-nai đâu, vì Chúa đã bảo con vạch ranh giới chung quanh núi để phân định vùng đất thánh.” ");
INSERT INTO vieovcb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Chúa Hằng Hữu phán: “Hãy xuống đem A-rôn lên đây. Đồng thời căn dặn các thầy tế lễ và toàn dân không ai được lên núi. Nếu ai bất tuân, thì phải chết.” ");
INSERT INTO vieovcb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Môi-se xuống núi căn dặn mọi người theo lời Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Đức Chúa Trời ban cho dân chúng mọi lời này: ");
INSERT INTO vieovcb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ta là Chúa Hằng Hữu, Đức Chúa Trời các ngươi, Đấng đã giải cứu các ngươi khỏi ách nô lệ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Các ngươi không được thờ thần nào khác ngoài Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Các ngươi không được làm cho mình một hình tượng nào theo hình dạng của những vật trên trời cao, hoặc trên đất, hoặc trong nước. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Các ngươi không được quỳ lạy hoặc phụng thờ các tượng ấy, vì Ta, Chúa Hằng Hữu, Đức Chúa Trời các ngươi, rất kỵ tà. Người nào ghét Ta, Ta sẽ trừng phạt họ, và luôn cả con cháu họ cho đến ba bốn thế hệ. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Nhưng người nào yêu kính Ta và tuân giữ điều răn Ta, Ta sẽ thương yêu săn sóc người ấy và con cháu họ cho đến nghìn đời. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Không được lạm dụng tên của Chúa Hằng Hữu, Đức Chúa Trời các ngươi. Ai phạm tội này, Chúa Hằng Hữu sẽ trừng phạt. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Nhớ phải giữ ngày Sa-bát làm ngày thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Các ngươi có sáu ngày để làm công việc, ");
INSERT INTO vieovcb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","nhưng ngày thứ bảy là ngày Sa-bát dành cho Chúa Hằng Hữu, Đức Chúa Trời ngươi. Trong ngày ấy, ngươi cũng như con trai, con gái, tôi trai, tớ gái, súc vật, luôn cả khách ngoại kiều trong nhà ngươi, đều không được làm việc gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Vì trong sáu ngày, Chúa Hằng Hữu tạo dựng trời, đất, biển, và muôn vật trong đó; đến ngày thứ bảy, Ngài nghỉ. Vậy, Chúa Hằng Hữu ban phước cho ngày Sa-bát và làm nên ngày thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Phải hiếu kính cha mẹ, như vậy ngươi mới được sống lâu trên đất mà Chúa Hằng Hữu, Đức Chúa Trời ban cho. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Các ngươi không được giết người. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Các ngươi không được ngoại tình. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Các ngươi không được trộm cắp. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Các ngươi không được làm chứng dối hại người lân cận mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Không được tham muốn nhà cửa, vợ, tôi trai, tớ gái, bò, lừa, hoặc vật gì khác của người lân cận mình.” ");
INSERT INTO vieovcb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Toàn dân khi nghe tiếng sấm sét, tiếng kèn vang dội, và thấy chớp nhoáng với khói bốc lên từ núi thì run rẩy sợ sệt, đứng xa ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Họ nói với Môi-se: “Xin truyền cho chúng tôi những gì Đức Chúa Trời dạy, chúng tôi sẽ vâng lời. Xin Đức Chúa Trời đừng nói trực tiếp với chúng tôi kẻo chúng tôi chết mất!” ");
INSERT INTO vieovcb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Môi-se ân cần đáp: “Anh chị em đừng sợ! Đức Chúa Trời đến đây để chứng tỏ uy quyền của Ngài, để anh chị em không dám phạm tội với Ngài nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Khi đoàn người vẫn còn đứng từ xa, Môi-se đi khuất vào trong đám mây dày đặc là nơi Đức Chúa Trời ngự. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Chúa Hằng Hữu phán dặn Môi-se nói lại với người Ít-ra-ên như sau: “Các ngươi đã nghe thấy rõ ràng Ta nói vọng xuống với các ngươi từ trên trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Vậy, đừng làm cho mình tượng bằng vàng hay bằng bạc để thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Nhưng phải làm một bàn thờ bằng đất để dâng lên cho Ta của lễ thiêu và của lễ tri ân, dùng bò hoặc chiên làm sinh tế. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Nếu các ngươi muốn làm bàn thờ bằng đá, phải dùng đá nguyên tảng, vì khi ngươi dùng các dụng cụ để đẽo đá, đá sẽ không còn tinh khiết nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Không được leo bậc thang đi lên bàn thờ. Nếu ngươi làm vậy, vài người có thể nhìn lên và thấy cơ thể ngươi trần truồng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Sau đây là những luật lệ khác các ngươi phải tuân giữ: ");
INSERT INTO vieovcb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Nếu ai mua một người Hê-bơ-rơ làm nô lệ, người ấy sẽ phục vụ trong sáu năm. Năm thứ bảy sẽ được tự do, không cần đóng tiền chuộc. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Nếu lúc bắt đầu làm nô lệ, người ấy còn độc thân, lúc ra sẽ ra một mình. Nhưng nếu đã có vợ từ trước, cả hai vợ chồng đều được tự do. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nếu người nô lệ được chủ cưới vợ cho và nếu họ có con cái, vợ con người sẽ thuộc về chủ, chỉ có người được tự do. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Nhưng nếu người ấy công nhiên nói rằng: ‘Tôi thương chủ và vợ con tôi, thà ở lại còn hơn ra đi tự do.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Người chủ sẽ đem người nô lệ đến trước Đức Chúa Trời. Sau đó trình người ấy trước mặt các thẩm phán, rồi dùng dùi xỏ tai người ấy. Người ấy sẽ làm nô lệ trọn đời. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Nếu có người bán con gái mình làm nô lệ, đến năm thứ bảy, người nô lệ sẽ không được tự do. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Nếu người chủ đã cưới nàng, sau lại không yêu thích nàng nữa, phải để cho người nhà nàng chuộc lại, chứ không được bán nàng cho người nước ngoài, vì chính chủ đã không trung thành với nàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Nếu chủ cưới người nô lệ cho con trai mình, chủ phải coi nàng như con gái mình vậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Nếu chủ đã cưới một người nô lệ, sau lại cưới vợ khác nữa, chủ không được giảm thức ăn, y phục và tình nghĩa vợ chồng với người vợ thứ nhất. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Nếu không làm theo ba điều này, chủ phải để cho nàng đi tự do, không cần đóng tiền chuộc”. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Nếu ai ra tay đánh chết người khác, sẽ bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Nhưng nếu tai nạn là do Đức Chúa Trời cho xảy ra, chứ không phải do kẻ sát nhân dự mưu, thì Ta có dự liệu một nơi cho kẻ sát nhân ẩn náu. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nếu kẻ sát nhân có dự mưu giết người, thì dù có trốn nơi bàn thờ Ta, Ta cũng bắt ra xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ai đánh cha hay mẹ mình phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ai bắt cóc một người, hoặc đem bán đi hoặc giữ lại, phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ai chửi rủa cha mẹ phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Nếu hai người cãi nhau và một người lấy đá hay dùng tay đánh, làm người kia tuy không chết nhưng bị thương, phải nằm liệt giường, ");
INSERT INTO vieovcb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","nếu nạn nhân đứng dậy chống gậy đi ra ngoài được, thì người gây thương tích sẽ được tha, nhưng phải bồi thường thiệt hại, vì nạn nhân không làm việc được trong lúc đau ốm, cùng bồi thường mọi phí khoản khác cho đến khi nạn nhân lành mạnh. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Nếu một người chủ dùng gậy đánh người nô lệ nam hay nữ của mình, và người nô lệ chết ngay tại chỗ, thì chủ phải bị trừng phạt. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Nhưng nếu người nô lệ còn sống vài ngày sau khi bị đánh, thì chủ khỏi bị trừng phạt, vì người nô lệ thuộc quyền sở hữu của chủ. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Nếu hai người trong lúc đánh nhau, vô tình gây thương tích cho một phụ nữ có mang khiến hư thai, nhưng không gây thiệt hại gì khác, thì người gây thương tích phải bồi thường theo mức chồng phụ nữ này ấn định và được phán quan chấp thuận. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Nhưng nếu phụ nữ này còn bị thiệt thòi gì khác, thì luật sau đây được áp dụng: Mạng đền mạng, ");
INSERT INTO vieovcb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","mắt đền mắt, răng đền răng, tay đền tay, chân đền chân, ");
INSERT INTO vieovcb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","phỏng đền phỏng, thương tích đền thương tích, vết đòn đền vết đòn. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Nếu chủ đánh mù mắt một người nô lệ, dù nam hay nữ, thì người nô lệ sẽ được tự do vì mắt bị mù. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Nếu chủ đánh gãy răng một người nô lệ, dù nam hay nữ, thì người nô lệ sẽ được tự do vì răng bị gãy. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Nếu một con bò húc chết người, dù đàn ông hay đàn bà, thì con bò sẽ bị ném đá cho chết; còn người chủ sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Nhưng nếu con bò có tật hay húc và chủ đã bị cảnh cáo nhưng vẫn không chịu nhốt bò lại, nếu bò này đi húc chết người, dù đàn ông hay đàn bà, thì con bò sẽ bị ném đá cho chết, và chủ bò sẽ bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Nếu thân nhân của người chết thuận cho chủ bò chuộc mạng, chủ bò phải chuộc theo giá thân nhân định. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Luật trên cũng được áp dụng nếu bò húc chết một vị thành niên trai hay gái. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Nếu bò húc chết một người nô lệ, dù nam hay nữ, thì chủ bò phải trả cho chủ người nô lệ ba mươi miếng bạc, và con bò sẽ bị ném đá cho chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Nếu ai đào một cái hầm mà không đậy lại, và nếu có con bò hay lừa ngã xuống đó, ");
INSERT INTO vieovcb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","thì chủ hầm phải trả tiền bồi thường cho chủ súc vật, và con vật chết sẽ thuộc về chủ hầm. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Nếu bò người này húc chết bò người khác, thì hai người chủ sẽ bán con bò sống chia tiền, và chia nhau con bò chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Nhưng nếu ai đã biết bò mình có tật hay húc mà vẫn không nhốt nó lại, thì người này phải đem bò đền bò, và được giữ con bò chết.” ");
INSERT INTO vieovcb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Người nào bắt trộm bò, chiên của người khác rồi đem giết hoặc bán đi, thì phải bồi thường. Nếu là bò, một thường năm. Nếu là chiên, một thường bốn. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Nếu kẻ trộm đang bẻ khóa, cạy cửa xông vào nhà và bị giết chết, thì người giết không có tội. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Nhưng nếu việc xảy ra sau khi mặt trời mọc thì kẻ đánh chết người sẽ mắc tội đổ máu. Nếu kẻ trộm không có gì để bồi thường, thì phải bán mình, vì đã phạm tội trộm. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Nếu kẻ trộm còn giữ con vật và nó còn sống, dù là bò, lừa, hay chiên, thì chỉ phải thường gấp đôi. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Người nào thả thú vật cắn phá hoa quả mùa màng, làm hư hại đồng ruộng hay vườn nho người khác, thì phải lấy hoa lợi tốt nhất trong đồng ruộng hay vườn nho mình để bồi thường. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Người nào nổi lửa trong đồng ruộng, đốt bụi gai rồi lửa cháy lan sang ruộng người khác, tàn hại mùa màng, dù đã gặt hay chưa gặt, thì phải bồi thường mọi thiệt hại. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Người nào giao tiền bạc hay đồ vật cho người khác giữ, chẳng may bị trộm và tên trộm bị bắt, thì nó phải thường gấp đôi. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Nhưng nếu không bắt được kẻ trộm, thì người giữ của phải được dẫn đến trước mặt Đức Chúa Trời để phán định về việc người này có lấy của mình giữ hay không. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Nếu có một người bị mất vật gì—dù là bò, lừa, chiên, áo xống hay bất cứ vật gì khác—và nếu người này quyết đoán rằng một người khác đã lấy, thì phải dẫn cả hai bên đến trước Đức Chúa Trời; người bị phán định là có tội phải bồi thường người kia gấp đôi. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Người nào giao lừa, bò, chiên hay bất kỳ thú vật gì cho người khác giữ, nếu con thú chết, bị thương hoặc chạy mất, và không có ai chứng kiến việc xảy ra như thế nào, ");
INSERT INTO vieovcb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","thì người giữ con vật phải thề trước Chúa Hằng Hữu rằng mình không chiếm hữu hoặc gây thiệt hại cho thú vật người kia. Như thế, sở hữu chủ phải nhận lời thề đó, và không được đòi bồi thường. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Nhưng nếu con vật bị mất trộm, thì người giữ phải bồi thường cho sở hữu chủ. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Nếu con vật bị thú rừng cắn xé, thì người giữ phải đem con vật bị xé ra làm bằng chứng và không phải bồi thường. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Người nào mượn một con vật của người khác, chẳng may vật bị thương hoặc chết trong lúc sở hữu chủ không có mặt tại đó, thì người mượn phải bồi thường. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Nhưng nếu có mặt sở hữu chủ tại đó, thì người mượn không phải bồi thường. Trường hợp con vật được cho mướn, thì tiền mướn được kể là tiền bồi thường.” ");
INSERT INTO vieovcb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Người nào quyến dụ một người con gái còn trinh chưa kết hôn với ai, và nằm với nàng, thì người ấy phải nộp sính lễ và cưới nàng làm vợ. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Nếu cha nàng nhất định từ chối việc hôn nhân này, thì người ấy phải trả một số tiền tương đương với giá trị của sính lễ. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Người nào làm phù thủy phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Người nào nằm với một con vật phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Người nào dâng tế lễ cho một thần nào khác ngoài Chúa Hằng Hữu phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Đừng áp bức ngoại kiều, phải nhớ rằng các ngươi đã là ngoại kiều tại Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Đừng áp bức các góa phụ và trẻ mồ côi. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Nếu bị áp bức, họ sẽ kêu đến Ta. Khi nghe họ kêu ca, ");
INSERT INTO vieovcb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","lửa giận Ta sẽ nổi lên, Ta sẽ sai gươm đao diệt các ngươi, như vậy vợ các ngươi sẽ thành góa phụ, con các ngươi thành mồ côi. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Người nào cho một người nghèo vay tiền, thì không được theo thói cho vay lấy lãi. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Nếu ngươi cầm áo xống của người nghèo làm của thế chân, thì phải trả áo lại trước khi mặt trời lặn. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Nếu đó là áo duy nhất của người ấy, thì lấy gì để người ấy che thân lúc ngủ? Nếu người ấy kêu đến Ta, thì Ta sẽ động lòng thương, nghe tiếng kêu xin. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Đừng nói xúc phạm đến Đức Chúa Trời, cũng đừng rủa sả các nhà lãnh đạo dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Đừng trì hoãn việc dâng lên Ta một phần mười hoa lợi ngũ cốc và rượu nho. Phải phú dâng lên Đức Chúa Trời con trưởng nam của mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Con đầu lòng của chiên và bò cũng phải được dâng lên Ta vào ngày thứ tám, sau khi đã để cho ở với mẹ nó bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Vì các ngươi đã dâng hiến đời mình cho Ta, nên không được ăn thịt của một con vật bị thú rừng cắn xé; thịt ấy phải đem cho chó ăn.” ");
INSERT INTO vieovcb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Đừng trình báo sai sự thật. Đừng hùa theo người ác để làm chứng gian. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Đừng phụ họa theo số đông để làm việc ác. Khi làm nhân chứng trong một vụ kiện, ngươi không được hùa theo số đông đi nghịch công lý; ");
INSERT INTO vieovcb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","cũng không được thiên vị người nghèo. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Nếu ai gặp bò hay lừa của kẻ thù đi lạc, thì phải dẫn nó về cho chủ nó. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nếu ai thấy lừa chở nặng phải ngã quỵ, dù đó là lừa của một người ghét mình, thì phải đỡ lừa dậy, không được làm ngơ. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Trong các vụ kiện liên hệ đến người nghèo, đừng bẻ cong công lý. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Không được cáo gian, đừng để cho người vô tội chịu án tử hình, vì Ta không dung tha việc gian ác đâu. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Đừng nhận hối lộ. Của hối lộ làm mờ mắt người tinh tường, đánh đổ lý lẽ của người ngay. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Đừng áp bức ngoại kiều. Các ngươi biết rõ tâm trạng họ như thế nào. Vì các ngươi đã từng là ngoại kiều ở Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Hãy gieo và gặt trong sáu năm, ");
INSERT INTO vieovcb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","nhưng qua năm thứ bảy, phải ngưng canh tác, để đất nghỉ. Trong thời gian ấy, những người nghèo khổ của ngươi sẽ lượm mót mà sống, còn lại thú đồng được hưởng. Lệ này cũng áp dụng cho các vườn nho và vườn ô-liu. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Các ngươi có sáu ngày để làm việc, qua ngày thứ bảy là ngày nghỉ. Như thế, bò và lừa của các ngươi, cùng với mọi người khác trong nhà, kể cả người làm, nô lệ và kiều dân, cũng được nghỉ. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Phải tuân theo mọi điều Ta đã dạy bảo. Nhớ không được nhắc đến tên của các thần khác.” ");
INSERT INTO vieovcb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Mỗi năm ba kỳ, các ngươi phải giữ lễ kính Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Phải giữ Lễ Bánh Không Men vào tháng giêng, kỷ niệm ngày các ngươi thoát khỏi Ai Cập. Phải ăn bánh không men trong bảy ngày như Ta đã dặn. Mỗi người phải mang một lễ vật dâng cho Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Phải giữ Lễ Gặt Hái, các ngươi sẽ dâng hiến các hoa quả đầu mùa của công lao mình. Phải giữ Lễ Thu Hoạch vào cuối năm, sau mùa gặt. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Hằng năm trong ba kỳ lễ này, các người nam trong Ít-ra-ên phải đến hầu trước Chúa Hằng Hữu Chí Cao. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Không được dâng máu sinh tế lên Ta chung với bánh có men. Không được dâng mỡ sinh vật đã để qua đêm. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Phải đem dâng vào nhà Chúa Hằng Hữu, Đức Chúa Trời của ngươi các hoa quả đầu mùa chọn lọc. Không được nấu thịt dê con trong sữa mẹ nó.” ");
INSERT INTO vieovcb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Đây, Ta sai một thiên sứ đi trước các ngươi, để phù hộ các ngươi lúc đi đường, và đưa các ngươi vào nơi Ta đã dự bị. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Phải kính trọng và vâng lời thiên sứ. Không được nổi loạn chống đối. Thiên sứ sẽ không bỏ qua tội ngươi đâu, vì vị này là đại diện của Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nhưng nếu các ngươi hết lòng nghe lời thiên sứ, làm mọi điều Ta dặn bảo, thì Ta sẽ nghịch thù kẻ thù nghịch ngươi, chống đối người chống đối ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Thiên sứ của Ta sẽ đi trước, đưa các ngươi vào đất của người A-mô-rít, người Hê-tít, người Phê-rết, người Ca-na-an, người Hê-vi, và người Giê-bu; còn Ta sẽ tiêu diệt các dân ấy. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Các ngươi không được thờ lạy và phục vụ thần của các dân ấy, không được bắt chước những điều họ làm. Phải nhất quyết đạp đổ và đập tan thần tượng của họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Chỉ phục vụ Chúa Hằng Hữu, Đức Chúa Trời ngươi mà thôi, rồi Ta sẽ ban phước lành cho thức ăn nước uống, làm cho bệnh tật lánh xa ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Trong cả nước sẽ không thấy có phụ nữ son sẻ hoặc hư thai; người người vui hưởng trường thọ. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ta sẽ làm cho các dân tộc trước mặt ngươi kinh hãi, dân các nước thù sẽ quay đầu chạy trốn. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ta sẽ sai ong vò vẽ đánh đuổi người Hê-vi, người Ca-na-an, và người Hê-tít khỏi trước mặt ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nhưng Ta sẽ không đuổi họ khỏi xứ trong thời hạn một năm đâu. Nếu như thế, đất sẽ thành hoang phế, thú rừng sẽ trở nên quá đông, ngươi không kiểm soát nổi. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ta sẽ đuổi họ từ từ, cho đến khi người Ít-ra-ên gia tăng đủ để choán đất. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Biên giới nước ngươi sẽ chạy từ Biển Đỏ tới biển Phi-li-tin, từ hoang mạc đến Sông Ơ-phơ-rát. Ta sẽ giao những người sống trong phần đất này vào tay ngươi, và ngươi sẽ đuổi họ ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Đừng lập ước với các dân đó hoặc dính líu gì đến các thần của họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Họ sẽ không được ở trong xứ sở của các ngươi, vì sống chung với họ, ngươi sẽ bị nhiễm tội, phụng thờ tà thần của họ và bị họ lừa bẫy.” ");
INSERT INTO vieovcb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Bấy giờ, Chúa Hằng Hữu phán bảo Môi-se: “Hãy đem A-rôn, Na-đáp, A-bi-hu, và bảy mươi trưởng lão Ít-ra-ên lên núi, rồi để họ đứng từ xa thờ lạy. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Chỉ một mình con sẽ đến gần Chúa Hằng Hữu. Ngoài ra, không một ai trong dân được lên núi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Khi Môi-se tuyên cáo với quốc dân các luật lệ Chúa Hằng Hữu truyền cho ông, toàn dân đồng thanh đáp: “Chúng tôi sẽ tuân theo mọi điều.” ");
INSERT INTO vieovcb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Môi-se ghi lại tất cả các điều luật Chúa Hằng Hữu phán. Sáng hôm sau ông dậy sớm, dựng một bàn thờ dưới chân núi. Ông cũng dựng mười hai trụ, tượng trưng cho mười hai đại tộc Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ông chỉ định một số thanh niên đi dâng tế lễ thiêu và tế lễ tri ân lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Rồi Môi-se lấy phân nửa máu của các sinh vật đổ vào một cái chậu. Phân nửa kia ông đem rảy trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ông cầm Sách Giao Ước đọc cho toàn dân nghe. Họ đáp: “Chúng tôi sẽ tuân theo mọi điều luật của Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Môi-se lấy máu trong chậu rảy trên dân và nói: “Đây là máu của giao ước Chúa Hằng Hữu đã lập với anh chị em khi Ngài ban bố luật này.” ");
INSERT INTO vieovcb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Sau đó, Môi-se đi cùng với A-rôn, Na-đáp, A-bi-hu, và bảy mươi bô lão Ít-ra-ên lên núi. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Họ được chiêm ngưỡng Đức Chúa Trời của Ít-ra-ên. Dưới chân Ngài như có cái bệ bằng ngọc xa-phia, trong như trời xanh. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Dù đã thấy Đức Chúa Trời, các lãnh đạo Ít-ra-ên không bị tiêu diệt, mà lại còn được ăn uống tự nhiên! ");
INSERT INTO vieovcb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Chúa Hằng Hữu phán bảo Môi-se: “Lên đây với Ta và đợi cho đến khi Ta giao cho bảng đá ghi khắc các luật lệ và điều răn để con dùng giáo hóa dân chúng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Vậy Môi-se cùng với người phụ tá là Giô-suê leo lên núi Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ông nói với các trưởng lão: “Các ông ở đây đợi chúng tôi trở lại. Nếu có điều gì, xin cứ hỏi hai ông A-rôn và Hu-rơ đây.” ");
INSERT INTO vieovcb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Rồi, Môi-se lên núi, đi khuất vào đám mây. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Vinh quang của Chúa Hằng Hữu phát ra khắp Núi Si-nai. Trong suốt sáu ngày, mây che phủ núi. Ngày thứ bảy, Chúa Hằng Hữu gọi Môi-se từ trong đám mây. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Dân chúng đứng dưới núi nhìn lên, thấy vinh quang sáng chói của Chúa Hằng Hữu chẳng khác gì một ngọn lửa hực trên đỉnh núi. ");
INSERT INTO vieovcb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Môi-se vào khuất trong đám mây che đỉnh núi và ở trong đó suốt bốn mươi ngày và bốn mươi đêm. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Hãy nói với người Ít-ra-ên dâng lễ vật cho Ta, và nhận lễ vật của những người có lòng chân thành. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Đây là danh sách lễ vật: Vàng, bạc, đồng; ");
INSERT INTO vieovcb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","chỉ xanh, tím, đỏ; vải gai mịn, lông dê; ");
INSERT INTO vieovcb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","da chiên nhuộm đỏ, da dê gỗ keo, ");
INSERT INTO vieovcb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","dầu thắp; chất liệu dùng làm dầu xức và hương thơm; ");
INSERT INTO vieovcb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","bạch ngọc, và các thứ ngọc khác để gắn vào ê-phót và bảng đeo ngực. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Họ sẽ làm cho Ta một đền thánh, và Ta sẽ ở giữa họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Sau đây, Ta sẽ cho con kiểu mẫu Đền Tạm và các vật dụng trong đền để con theo đó mà làm.” ");
INSERT INTO vieovcb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Hãy đóng một cái Hòm Giao Ước bằng gỗ keo, dài 1,15 mét, rộng 0,69 mét, cao 0,69 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Lấy vàng ròng bọc bên ngoài, lót bên trong, và viền chung quanh Hòm. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Đúc bốn khoen vàng gắn vào bốn góc Hòm, mỗi bên hai cái. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Làm hai cây đòn bằng gỗ keo bọc vàng, ");
INSERT INTO vieovcb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","rồi xỏ đòn vào khoen hai bên Hòm dùng làm đòn khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Cứ giữ các đòn khiêng trong khoen của Hòm, đừng lấy ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Con sẽ cất trong Hòm các bảng Giao Ước Ta sẽ cho con. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Hãy làm một nắp chuộc tội bằng vàng ròng dài 1,15 mét, rộng 0,69 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Làm hai chê-ru-bim bằng vàng dát ");
INSERT INTO vieovcb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","dính liền với nắp chuộc tội, mỗi thiên thần đứng trên một đầu nắp. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Hai thiên thần đứng đối diện nhau, nhìn xuống nắp chuộc tội, xòe cánh che trên nắp. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Đặt nắp chuộc tội trên Hòm, trong Hòm có để các bảng Giao Ước Ta sẽ cho con. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Đây là nơi Ta sẽ gặp con trên nắp chuộc tội, giữa hai thiên thần trên Hòm Giao Ước. Tại đó Ta sẽ truyền cho con mọi giới luật áp dụng cho người Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Hãy đóng một cái bàn bằng gỗ keo, dài 0,92 mét, rộng 0,46 mét, cao 0,69 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Dùng vàng ròng bọc bàn và viền chung quanh. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Đóng khung chung quanh mặt bàn. Bề rộng của khung bằng một bàn tay. Viền vàng quanh khung. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Làm bốn khoen vàng đính vào bốn chân, gần khung của mặt bàn, ở bốn góc. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Các khoen này dùng để giữ đòn khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Đòn khiêng làm bằng gỗ keo bọc vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Cũng làm đĩa, muỗng, bát, và bình bằng vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Phải luôn luôn có Bánh Thánh trên bàn trước mặt Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Hãy làm một chân đèn bằng vàng ròng, dát từ chân cho đến thân. Đài, bầu, và hoa của đèn đều dính liền nhau. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Từ thân mọc ra sáu cành, mỗi bên ba cành. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Mỗi cành mang ba hoa hạnh nhân. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Thân của chân đèn mang bốn hoa hạnh nhân. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Làm một cái đài bên dưới, mỗi hai cành mọc ra từ thân. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Đài và cành dính liền nhau, làm bằng vàng ròng dát nguyên miếng. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Làm bảy cái đèn, đem đặt trên chân đèn thế nào cho ánh sáng chiếu ra phía trước. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kéo cắt tàn tim đèn và đĩa đựng tàn cũng làm bằng vàng ròng. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Dùng 34 ký vàng ròng đủ để làm chân đèn và đồ phụ tùng. ");
INSERT INTO vieovcb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Con nhớ làm mọi thứ đúng theo kiểu mẫu Ta cho con xem trên núi này.” ");
INSERT INTO vieovcb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Hãy dùng mười tấm màn vải gai mịn làm Đền Tạm. Trên màn có thêu hình thiên thần bằng chỉ xanh, tím, và đỏ một cách tinh vi khéo léo. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Mỗi tấm màn dài 12,9 mét, rộng 1,8 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Nối năm tấm màn lại với nhau thành một tấm lớn. Vậy, trại gồm hai tấm lớn, mỗi tấm một bên. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kết vòng chỉ xanh dọc theo đường biên của hai tấm lớn, ");
INSERT INTO vieovcb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","mỗi bên năm mươi vòng, đối diện nhau. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Làm năm mươi cái móc bằng vàng để cài vào các vòng. Như vậy, hai tấm lớn được kết lại thành một cái trại làm Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Dệt mười một bức màn bằng lông dê để phủ lên trên nóc Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Mỗi tấm dài 13,8 mét, rộng 1,8 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Nối năm tấm màn lông dê lại với nhau, còn lại sáu tấm cũng nối lại. Riêng tấm thứ sáu được gập đôi lại, phân nửa cho phủ xuống trước Đền. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kết năm mươi vòng dọc theo đường biên của hai tấm lông dê lớn. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Nối hai tấm này lại với nhau bằng năm mươi móc đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Nửa tấm màn lông dê còn dư lại sẽ cho phủ xuống phía sau Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Chiều dài dư ra của các tấm màn lông dê sẽ phủ xuống hai bên hông đền, mỗi bên 0,46 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Phủ lên trên nóc trại một lớp da chiên nhuộm đỏ. Bên trên lớp này lại có một lớp da dê. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Vách Đền Tạm làm bằng ván cây keo. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Mỗi tấm ván dài 4,6 mét, rộng 0,69 mét, dựng thẳng đứng. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Mỗi tấm sẽ có hai cái mộng để ghép vào các lỗ mộng. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Dùng hai mươi tấm ván làm vách phía nam Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Dưới mỗi tấm ván, làm hai lỗ mộng bằng bạc. Vậy, phía nam có bốn mươi lỗ mộng. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Vách phía bắc cũng gồm hai mươi tấm ván. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Dưới mỗi tấm có hai lỗ mộng bạc, cộng bốn mươi lỗ mộng. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Vách phía tây cũng gồm sáu tấm ván. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tại góc của vách phía sau này, dựng thêm hai tấm ván nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Hai tấm này sẽ được ghép vào nhau bằng móc cài ở dưới và ở trên. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Vậy, vách phía sau có tất cả tám tấm ván và mười sáu lỗ mộng bạc, mỗi tấm hai lỗ. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Làm thanh ngang cho vách Đền Tạm cũng bằng gỗ keo, ");
INSERT INTO vieovcb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","mỗi phía có năm thanh ngang; phía sau, về hướng tây cũng có năm thanh ngang. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Thanh chính giữa nằm ngay giữa vách, chạy dài từ đầu này đến đầu kia của Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Bọc vàng các tấm ván vách và các thanh ngang. Làm các vòng vàng để xỏ thanh ngang. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Vậy, con hãy theo kiểu mẫu Ta cho xem trên núi này mà dựng Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","May một bức màn bằng vải gai mịn. Dùng chỉ xanh, tím, và đỏ thêu hình chê-ru-bim trên màn một cách tinh vi khéo léo. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Treo màn này trong đền. Trên bốn trụ gỗ keo bọc vàng có bốn móc vàng. Trụ được dựng trên bốn lỗ trụ bằng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Màn được móc vào các móc vàng. Phía trong màn là nơi đặt Hòm Giao Ước. Màn sẽ phân chia Nơi Thánh và Nơi Chí Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Hòm Giao Ước có nắp chuộc tội đậy bên trên được đặt ở Nơi Chí Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Bên ngoài màn, đặt cái bàn và chân đèn đối diện nhau, bàn về phía bắc, chân đèn về phía nam. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Bức màn cửa đền may bằng vải gai mịn, dùng chỉ xanh, tím, và đỏ thêu tinh vi khéo léo. ");
INSERT INTO vieovcb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Màn được treo bằng năm móc vàng trên năm trụ cây keo bọc vàng, trụ được dựng trên lỗ trụ bằng đồng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Đóng một cái bàn thờ hình vuông bằng gỗ keo, mỗi bề 2,3 mét, cao 1,4 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Bốn góc có bốn sừng được gắn dính liền với bàn thờ. Bọc đồng chung quanh bàn thờ và sừng. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Thùng đựng tro, xuổng, bồn chứa nước, đinh ba, và đĩa đựng than lửa đều làm bằng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Làm một cái rá giữ than bằng lưới đồng, bốn góc rá có bốn khoen đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Đặt rá vào bàn thờ, mép nhô ra bên trong bàn thờ sẽ giữ rá cao đến phân nửa bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Làm đòn khiêng bàn thờ bằng gỗ keo bọc đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Xỏ đòn vào các khoen hai bên bàn thờ để khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Bàn thờ được đóng bằng ván, rỗng ở giữa, như kiểu mẫu Ta cho con xem trên núi này.” ");
INSERT INTO vieovcb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Chung quanh Đền Tạm sẽ có hành lang bao bọc. Hành lang được tạo thành bằng màn vải gai mịn treo trên các trụ đồng. Trụ đồng có các móc bằng bạc và các đai cũng bằng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Hành lang phía nam, dài 46 mét, có hai mươi trụ đồng dựng trên hai mươi lỗ trụ cũng bằng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hành lang phía bắc cũng được làm như ở phía nam, dài 46 mét, có hai mươi trụ đồng dựng trên hai mươi lỗ trụ cũng bằng đồng ");
INSERT INTO vieovcb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Hành lang phía tây dài 23 mét, màn được treo trên mười trụ dựng trên mười lỗ trụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Hành lang phía đông cũng dài 23 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Hai bên cửa Đền Tạm có hai bức màn bên phải dài 6,9 mét, ");
INSERT INTO vieovcb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","mỗi bức rộng 6,9 mét, treo trên ba trụ dựng trên ba lỗ trụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Cửa vào hành lang có một bức màn dài 9,2 mét bằng vải gai mịn thêu chỉ xanh, tím, và đỏ. Màn được treo trên bốn trụ dựng trên bốn lỗ trụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Tất cả các trụ chung quanh hành lang được viền bằng bạc, có móc bằng bạc và lỗ trụ bằng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Vậy, chiều dài của hành lang là 46 mét, chiều rộng 23 mét, và chiều cao 2,3 mét, bao bọc bằng vải gai mịn. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tất cả các dụng cụ dùng trong Đền Tạm, kể cả các cái móc, đều làm bằng đồng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Hãy truyền cho người Ít-ra-ên đem dầu ô-liu nguyên chất đến để đốt đèn trong đền, đèn này phải cháy sáng luôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","A-rôn và các con trai người phải lo chăm sóc đèn cho sáng luôn cả đêm lẫn ngày trong Đền Tạm, bên ngoài bức màn, trước mặt Chúa Hằng Hữu. Đây là một quy lệ người Ít-ra-ên phải giữ mãi mãi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Con hãy tấn phong cho A-rôn, anh con, và các con trai A-rôn—Na-đáp, A-bi-hu, Ê-lê-a-sa, Y-tha-ma làm chức thầy tế lễ để họ phụng thờ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Hãy may lễ phục thánh thật trang trọng và đẹp cho A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Hãy truyền cho tất cả những người có tài năng, những người mà Ta đã ban ơn khôn ngoan, may áo lễ cho A-rôn, để biệt riêng người cho chức vụ thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bộ áo lễ này gồm có bảng đeo ngực, ê-phót, áo dài, áo lót ngắn tay có kẻ ô vuông, khăn đội đầu và dây thắt lưng. Họ cũng sẽ may áo lễ cho anh con A-rôn, và các con trai người mặc khi họ thi hành chức vụ tế lễ cho Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Họ sẽ dùng vải gai mịn, chỉ kim tuyến, chỉ xanh, tím, và đỏ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Thợ thủ công phải may Ê-phót bằng vải gai mịn, thêu kim tuyến chỉ xanh, tím, và đỏ, một cách tinh vi khéo léo. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ê-phót gồm hai vạt, nối liền nhau bằng hai cầu vai. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Dây để thắt ê-phót cũng được may bằng vải gai mịn, thêu bằng các loại chỉ dùng để thêu ê-phót. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Lấy hai viên bạch ngọc khắc tên của các con trai Ít-ra-ên trên đó, ");
INSERT INTO vieovcb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","mỗi viên khắc sáu tên, theo thứ tự ngày sinh. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Khắc các tên này theo lối khắc con dấu, rồi đem nhận hai viên bạch ngọc vào hai khung vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Gắn hai viên ngọc này trên hai vai ê-phót để làm ngọc tưởng niệm các con Ít-ra-ên. A-rôn sẽ mang tên của những người này để làm kỷ niệm trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Làm hai sợi dây chuyền bằng vàng ròng xoắn hình trôn ốc, ");
INSERT INTO vieovcb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","đem nối vào các khung vàng trên vai ê-phót.” ");
INSERT INTO vieovcb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Bảng đeo ngực ‘Công Lý’ cũng được làm bằng vải gai mịn thêu kim tuyến và chỉ xanh, tím, và đỏ một cách tinh vi khéo léo, như cách làm ê-phót vậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Bảng này hình vuông, mỗi cạnh một gang tay, may bằng hai lớp vải. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Gắn bốn hàng ngọc trên bảng. Hàng thứ nhất gồm: Hồng mã não, hoàng ngọc, và ngọc lục bảo. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Hàng thứ hai gồm: Bích ngọc, lam ngọc, và kim cương. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Hàng thứ ba gồm: Ngọc phong tín, ngọc mã não, và ngọc thạch anh tím. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Hàng thứ tư gồm: Lục ngọc thạch, bạch ngọc, và vân ngọc. Các ngọc này đều được nhận vào khung vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Vậy, mười hai viên ngọc tượng trưng cho mười hai đại tộc Ít-ra-ên. Tên của các đại tộc được khắc trên ngọc theo lối khắc con dấu. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Hãy làm hai sợi dây chuyền bằng vàng ròng xoắn hình trôn ốc. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Cũng làm hai khoen vàng, gắn vào hai góc của bảng đeo ngực. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Mỗi dây chuyền có một đầu nối với hai khoen vàng này ");
INSERT INTO vieovcb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","và một đầu nối với góc ngoài của hai khung vàng có nhận hai viên bạch ngọc trên vai ê-phót. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Làm thêm bốn khoen vàng, hai khoen gắn ở góc trong, bên dưới của bảng đeo ngực. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hai khoen gắn ở phía trước, phần dưới của hai cầu vai ê-phót, gần chỗ nối với vạt trước, bên trên thắt lưng. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Dùng dây màu xanh buộc bảng đeo ngực vào ê-phót tại các khoen vàng vừa kể, để cho bảng đeo ngực sẽ không rời khỏi ê-phót. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Như vậy, khi vào Nơi Thánh, A-rôn sẽ mang trước ngực tên các đại tộc Ít-ra-ên (trên bảng đeo ngực ‘Công Lý’), để làm một kỷ niệm thường xuyên trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Phải gắn U-rim và Thu-mim vào bảng đeo ngực, để A-rôn đeo trước ngực mình mỗi khi vào Nơi Thánh, trước mặt Chúa Hằng Hữu. Vậy, A-rôn sẽ luôn luôn mang công lý cho người Ít-ra-ên mỗi khi vào cầu hỏi Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“May áo khoác ngoài ê-phót bằng vải xanh. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Giữa áo có một lỗ để tròng đầu vào như cổ của áo giáp, phải viền cổ kỹ càng cho khỏi xơ, rách. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Dùng chỉ xanh, tím, đỏ thắt trái lựu ");
INSERT INTO vieovcb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","kết dọc theo gấu áo, xen kẽ với chuông vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","A-rôn sẽ mặc áo đó mỗi khi vào Nơi Thánh phục vụ Chúa Hằng Hữu. Tiếng chuông vàng sẽ khua khi người ra vào trước mặt Chúa Hằng Hữu. Nếu không, người sẽ chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Làm một thẻ bằng vàng ròng và khắc trên thẻ theo lối khắc con dấu như sau: ‘Thánh cho Chúa Hằng Hữu.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Dùng dây màu xanh buộc thẻ trước khăn đội đầu của A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Vậy, A-rôn sẽ luôn luôn mang thẻ ngay trước trán mình, và như thế người sẽ mang lấy trên mình những tội của người Ít-ra-ên khi họ dâng lễ vật để chuộc lỗi. Lễ vật được nhận, tội được tha, khi A-rôn mang thẻ trên trán lúc người ở trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Dệt một áo lót ngắn tay bằng chỉ gai mịn, có kẻ ô vuông. Cũng làm một khăn đội đầu bằng vải gai mịn và một dây thắt lưng thêu. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Cũng may cho các con trai A-rôn áo dài, dây thắt lưng và khăn đội đầu cho trang trọng, lịch sự. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Sau khi lấy các bộ áo đó mặc cho A-rôn và các con trai người, con phải làm lễ xức dầu, tấn phong chức tế lễ thánh cho họ để họ phục vụ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Cũng nhớ may quần lót bằng vải gai để họ mặc sát vào người từ bụng đến đùi. ");
INSERT INTO vieovcb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","A-rôn và các con trai người phải mặc quần này mỗi khi vào Đền Tạm hoặc đến gần bàn thờ trong Nơi Thánh; nếu không, họ sẽ mang tội và chết. Đây là một quy lệ áp dụng cho A-rôn và con cháu người mãi mãi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Sau đây là nghi thức lễ tấn phong chức thầy tế lễ thánh cho A-rôn và các con trai người: Bắt một con bò tơ đực và hai con chiên đực không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Lấy bột mì làm bánh lạt không men, bánh ngọt pha dầu không men và bánh kẹp tẩm dầu không men. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Để các bánh đó trong một cái giỏ để dâng lên cùng với con bò và hai con chiên. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Sau đó đem A-rôn và các con trai người đến tại cửa Đền Tạm, lấy nước tẩy rửa cho họ sạch sẽ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Lấy bộ áo lễ gồm có áo dài, áo lót ngắn tay, ê-phót, bảng đeo ngực, và dây thắt lưng mặc cho A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Đội khăn lên đầu người, trên khăn có buộc thẻ vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Lấy dầu thánh đổ lên đầu, xức cho người. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Cũng mặc áo dài cho các con trai A-rôn, thắt lưng và đội khăn lên đầu cho họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Họ sẽ làm chức thầy tế lễ thánh trọn đời. Đó là nghi lễ tấn phong A-rôn và các con trai người. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Dắt con bò tơ đực đến để A-rôn và các con trai người đặt tay trên đầu nó, ");
INSERT INTO vieovcb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","rồi giết con bò trước mặt Chúa Hằng Hữu tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Lấy ngón tay nhúng vào máu bò, bôi lên sừng bàn thờ, phần máu còn lại phải đem đổ dưới chân bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Lấy tất cả mỡ bọc bộ lòng, túi mật, hai trái thận, và mỡ bao quanh thận đem đốt trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Thịt, da, và phân bò đều phải đem ra ngoài trại đốt đi. Đó là của lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Dắt con chiên đực thứ nhất đến để A-rôn và các con trai người đặt tay trên đầu nó. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Con sẽ giết con chiên đó, lấy máu rảy khắp chung quanh bàn thờ, ");
INSERT INTO vieovcb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","còn thịt nó đem cắt ra từng miếng. Rửa sạch bộ lòng và chân, rồi đem để chung với thịt và đầu, ");
INSERT INTO vieovcb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","và đem đốt tất cả các phần đó trên bàn thờ. Đó là của lễ thiêu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Dắt con chiên đực thứ hai đến để A-rôn và các con trai người đặt tay trên đầu nó. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Con sẽ giết con chiên đó, lấy máu bôi trên trái tai bên phải của A-rôn và các con trai người, trên ngón cái tay phải và ngón cái chân phải của họ. Phần máu còn lại đem rảy khắp chung quanh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Lấy một ít máu trên bàn thờ trộn với dầu xức, đem rảy trên A-rôn và các con trai người, cùng trên áo họ. A-rôn, các con trai, và áo xống họ sẽ nên thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Vì đây là con chiên dùng để tấn phong A-rôn và các con trai người, nên con phải lấy mỡ chiên—gồm mỡ đuôi, mỡ bọc bộ lòng, với túi mật, hai trái thận và mỡ bao quanh thận, cái đùi phải của con chiên; ");
INSERT INTO vieovcb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","cũng lấy một ổ bánh, một bánh ngọt pha dầu, và một bánh kẹp từ trong giỏ đựng bánh không men ở trước mặt Chúa Hằng Hữu; ");
INSERT INTO vieovcb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","đem đặt các món này vào tay A-rôn và các con trai người, và cử hành việc dâng tế lễ đưa qua đưa lại trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Rồi lấy lại các món ấy trong tay họ, đem đốt trên bàn thờ, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Lấy cái ức của con chiên dùng để tấn phong A-rôn, dâng lên như một tế lễ đưa qua đưa lại trước mặt Chúa Hằng Hữu, sau đó phần này thuộc về con. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Dành một phần dùng trong lễ tấn phong, phần này thuộc A-rôn và các con trai người. Phần này bao gồm ức và đùi dâng lên tế lễ trước Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Cứ theo lệ này trong tương lai khi người Ít-ra-ên dâng tế lễ bình an, dành phần ức và đùi cho A-rôn và các con trai người, đó là những phần của sinh tế được họ dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Bộ áo thánh của A-rôn sẽ được truyền lại cho con cháu, người kế vị sẽ mặc bộ áo đó trong lễ tấn phong và lễ xức dầu thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Người ấy phải mặc bộ áo đó trong bảy ngày khi vào Nơi Thánh của Đền Tạm để thi hành chức vụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Nấu con chiên dùng để tấn phong tại một nơi thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","A-rôn và các con trai người sẽ ăn thịt chiên với bánh trong giỏ tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Họ ăn những thức dùng để chuộc tội cho mình trong cuộc lễ tấn phong. Ngoài họ ra, không ai được ăn những thức đó, vì là thức ăn thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Nếu thịt và bánh còn thừa lại đến sáng hôm sau, đừng ăn nhưng phải đem đốt đi, vì là thức ăn thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Đó là những thủ tục con phải theo để tấn phong A-rôn và các con trai người. Lễ tấn phong sẽ kéo dài trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Mỗi ngày phải dâng một con bò tơ đực làm lễ chuộc tội. Phải lau chùi bàn thờ cho sạch sẽ, làm lễ chuộc tội cho bàn thờ và xức dầu thánh, để thánh hóa bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Trong bảy ngày liền, con làm lễ chuộc tội và hiến dâng bàn thờ lên Chúa. Bàn thờ sẽ trở nên rất thánh, vật gì đụng đến bàn thờ sẽ được thánh hóa. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Mỗi ngày phải dâng trên bàn thờ hai con chiên một tuổi, ");
INSERT INTO vieovcb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","một con dâng vào buổi sáng, một con vào buổi tối. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Cùng với con chiên thứ nhất, dâng 2,2 lít bột mịn trộn với 1 lít dầu ép và 1 lít rượu nho dùng để làm tế lễ thức uống. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Con chiên thứ hai dâng vào buổi tối cùng với bột và dầu làm lễ chay, và rượu nho làm tế lễ thức uống. Giống như của lễ buổi sáng, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Tế lễ hằng ngày này phải được dâng liên tục từ thế hệ này sang thế hệ khác, tại cửa Đền Tạm trước mặt Chúa Hằng Hữu, là nơi Ta sẽ gặp con và nói chuyện với con. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Tại đó Ta cũng sẽ gặp người Ít-ra-ên, và vinh quang của Ta sẽ làm cho nơi này nên thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ta sẽ làm cho Đền Tạm và bàn thờ nên thánh, A-rôn và các con trai người cũng được nên thánh, để làm chức tế lễ phụng thờ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ta sẽ ở giữa người Ít-ra-ên, làm Đức Chúa Trời của họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Họ sẽ biết rằng Ta là Chúa Hằng Hữu, Đức Chúa Trời của họ. Ta đã dẫn họ ra khỏi Ai Cập để ở với họ. Ta là Chúa Hằng Hữu, Đức Chúa Trời của họ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Hãy đóng một bàn thờ xông hương bằng gỗ keo. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Mặt bàn vuông, mỗi bề 0,46 mét, cao 0,92 mét, có các sừng được gắn liền với bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Lấy vàng ròng bọc mặt bàn, cạnh bàn, các sừng và viền khắp chung quanh bàn. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Làm mỗi bên hai khoen vàng gắn ngay bên dưới đường viền, để giữ đòn khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Đòn khiêng được làm bằng gỗ keo bọc vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Bàn thờ này được đặt ở trước bức màn che Hòm Giao Ước và nắp chuộc tội trên Hòm, là nơi Ta gặp con. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Mỗi buổi sáng, lúc A-rôn sửa soạn đèn, người sẽ đốt hương thơm trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Và mỗi buổi tối, khi A-rôn đốt đèn, người cũng sẽ đốt hương. Như vậy, hương sẽ được đốt liên tục trước mặt Chúa Hằng Hữu, từ thế hệ này sang thế hệ khác. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Trên bàn thờ này không được đốt hương lạ, cũng không dâng tế lễ thiêu, tế lễ chay, hay tế lễ thức uống. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Hằng năm, A-rôn phải làm lễ chuộc tội tại bàn thờ, lấy máu con sinh tế chuộc tội bôi trên sừng bàn thờ. Lễ này phải làm mỗi năm, từ thế hệ này sang thế hệ khác, vì đây là một bàn thờ Chúa Hằng Hữu rất thánh.” ");
INSERT INTO vieovcb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Chúa Hằng Hữu phán dạy Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Khi nào con kiểm kê dân số Ít-ra-ên, mỗi công dân được kiểm kê phải nộp cho Ta một món tiền đền mạng, như thế họ sẽ không bị tai nạn gì trong cuộc kiểm kê này. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Mỗi người phải nộp nửa đồng bạc theo tiêu chuẩn tiền tệ của Nơi Thánh là lễ vật dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Các công dân từ hai mươi tuổi trở lên sẽ được kiểm kê và nộp tiền này cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Người giàu không nộp hơn, nghèo không nộp kém, vì đây là một lễ vật mỗi người dâng lên Chúa Hằng Hữu để chuộc tội cho chính mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Dùng tiền này vào công việc Đền Tạm, trước mặt Chúa Hằng Hữu, để Ta lưu ý và tha tội cho họ.” ");
INSERT INTO vieovcb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Hãy làm một cái bồn bằng đồng có chân cũng bằng đồng. Đặt bồn giữa Đền Tạm và bàn thờ, rồi đổ nước vào bồn. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","A-rôn và các con trai người sẽ rửa tay, và rửa chân tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Họ phải rửa tay và chân mình trước khi vào Đền Tạm hoặc đến gần bàn thờ để dâng tế lễ thiêu lên Chúa Hằng Hữu, nếu không họ sẽ chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Lệ này áp dụng cho A-rôn và con cháu người, từ thế hệ này sang thế hệ khác.” ");
INSERT INTO vieovcb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Hãy lựa chọn các một dược thượng hạng, gồm có: 5,7 ký nhựa thơm nguyên chất, 2,9 ký hương quế, 2,9 ký hương thạch xương bồ, ");
INSERT INTO vieovcb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","và 5,7 ký quế bì, theo cân Nơi Thánh, cùng với 3,8 lít dầu ô-liu. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Dùng các hương liệu này chế ra một thứ dầu xức thánh, theo phép hòa hương. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Dùng dầu này xức lên Đền Tạm, Hòm Giao Ước, ");
INSERT INTO vieovcb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","bàn, và dụng cụ của bàn, chân đèn và dụng cụ đốt đèn, bàn thờ xông hương, ");
INSERT INTO vieovcb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","bàn thờ dâng tế lễ thiêu và dụng cụ của bàn thờ, bồn rửa và chân bồn. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Như vậy, các vật này sẽ được thánh hóa, được dành riêng cho Chúa Hằng Hữu, bất kỳ vật gì đụng đến chúng cũng đều được thánh hóa. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Hãy xức dầu đó cho A-rôn và các con trai người, đặc cử họ làm chức tế lễ thánh phục vụ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Nói cho người Ít-ra-ên biết rằng dầu này là dầu xức thánh của Ta mãi mãi. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Không được dùng dầu này xức cho người thường, cũng không ai được chế dầu theo công thức này để dùng, vì đó là dầu thánh của Ta, cũng là dầu thánh của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Người nào chế dầu theo công thức này hoặc dùng dầu này xức cho một người thường sẽ bị trục xuất khỏi cộng đồng Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Chúa Hằng Hữu lại phán dạy Môi-se: “Hãy dùng các hương liệu gồm có tô hợp hương, loa yểm hương, phong tử hương, và nhũ hương nguyên chất, phân lượng bằng nhau. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Theo phép hòa hợp hương liệu, chế ra một thứ hương để đốt có pha muối. Hương này sẽ là thuần chất và thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Đem một ít hương này nghiền ra bột, để một ít bột hương trước Hòm Giao Ước, nơi Ta gặp con trong Đền Tạm. Hương này rất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Không ai được làm hương theo công thức này để dùng, vì đây là hương thánh của Chúa Hằng Hữu, cũng là hương thánh của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ai làm hương này cho mình sẽ bị trục xuất khỏi cộng đồng Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ta đã chọn Bê-sa-lê (con trai U-ri, cháu Hu-rơ, thuộc đại tộc Giu-đa), ");
INSERT INTO vieovcb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","cho người này đầy dẫy Thần Linh của Đức Chúa Trời, có trí khôn, khả năng, và khéo tay ");
INSERT INTO vieovcb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","để vẽ kiểu và chế tạo các vật bằng vàng, bạc và đồng, ");
INSERT INTO vieovcb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","để cắt ngọc, chạm gỗ, và làm mọi công tác nghệ thuật khác. ");
INSERT INTO vieovcb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ta cũng chọn Ô-hô-li-áp (con trai A-hi-sa-mạc, thuộc đại tộc Đan) làm phụ tá cho Bê-sa-lê. Ngoài ra, Ta còn phú tài năng khéo léo cho một số người khác để họ thực hiện các công tác Ta dặn con làm: ");
INSERT INTO vieovcb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","gồm có Đền Tạm; Hòm Giao Ước; nắp chuộc tội trên Hòm; và mọi dụng cụ khác trong Đền Tạm; ");
INSERT INTO vieovcb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","bàn thờ và đồ phụ tùng; chân đèn bằng vàng ròng và dụng cụ đốt đèn; bàn thờ xông hương; ");
INSERT INTO vieovcb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","bàn thờ dâng của lễ thiêu và đồ phụ tùng, bồn rửa; và chân bồn; ");
INSERT INTO vieovcb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bộ áo lễ thánh của Thầy Tế lễ A-rôn và áo lễ của các con trai người để họ mặc hành chức tế lễ; ");
INSERT INTO vieovcb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","dầu xức thánh và hương thơm dùng trong Nơi Thánh. Các thợ thủ công phải theo đúng những chỉ thị Ta đã phán dạy con.” ");
INSERT INTO vieovcb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Hãy bảo người Ít-ra-ên phải giữ ngày Sa-bát của Ta, vì đây là một dấu hiệu của quy ước giữa Ta và các ngươi, từ thế hệ này sang thế hệ khác. Nhờ giữ ngày này, các ngươi sẽ ý thức được rằng Ta, Chúa Hằng Hữu, đã dành riêng các ngươi cho Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Phải giữ ngày Sa-bát vì là ngày thánh. Ai xúc phạm đến ngày đó, đều sẽ bị tử hình; người nào làm bất cứ việc gì trong ngày đó sẽ bị loại trừ khỏi dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Làm việc trong sáu ngày, nhưng nghỉ ngày thứ bảy là ngày Sa-bát tức là ngày yên nghỉ và ngày thánh cho Chúa Hằng Hữu. Ai làm bất cứ việc gì trong ngày Sa-bát đều sẽ bị tử hình. ");
INSERT INTO vieovcb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Vậy, người Ít-ra-ên phải giữ ngày Sa-bát, ngày thánh của Chúa Hằng Hữu. Phải tôn trọng quy tắc này mãi mãi, từ thế hệ này sang thế hệ khác. ");
INSERT INTO vieovcb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Đây là một dấu hiệu vĩnh viễn của quy ước giữa Ta và người Ít-ra-ên. Vì Chúa Hằng Hữu đã sáng tạo trời đất trong sáu ngày, nhưng ngày thứ bảy Ngài nghỉ ngơi và tĩnh dưỡng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ở trên Núi Si-nai, sau khi đã dặn bảo Môi-se mọi điều, Chúa Hằng Hữu trao cho ông hai bảng “Giao Ước,” tức là hai bảng đá, trên đó Đức Chúa Trời đã dùng ngón tay Ngài viết các điều răn. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ở dưới núi đợi mãi không thấy Môi-se xuống, dân chúng mới kéo nhau đến gặp A-rôn và nói: “Xin ông tạo ra một vị thần để hướng dẫn chúng tôi, vì Môi-se, người đã đem chúng tôi ra khỏi Ai Cập, nay chẳng biết ra sao.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","A-rôn nói với họ: “Anh chị em tháo các vòng vàng đeo tai của vợ con rồi đem đến đây cho tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Vậy, họ đem đến cho A-rôn các vòng đeo tai bằng vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","A-rôn làm khuôn, nấu vàng, và đúc tượng một bò con. Dân chúng thấy tượng bò con liền reo lên: “Ít-ra-ên ơi! Đây là vị thần đã đem chúng ta ra khỏi Ai Cập!” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Thấy thế, A-rôn liền lập một bàn thờ trước tượng bò con, rồi tuyên bố: “Ngày mai chúng ta ăn lễ mừng Chúa Hằng Hữu!” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Hôm sau họ dậy sớm, dâng của lễ thiêu và lễ vật tri ân, rồi ngồi xuống ăn uống, và cùng nhau đứng dậy chơi đùa. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Vào lúc ấy, Chúa Hằng Hữu phán dạy Môi-se: “Bây giờ con phải xuống núi, vì đám người con dẫn ra khỏi Ai Cập nay đã hư hỏng rồi. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Họ đã vội rời bỏ đường lối Ta dạy bảo, đúc một tượng bò con, thờ lạy và dâng tế lễ cho nó, mà nói: ‘Ít-ra-ên ơi! Đây là vị thần đã đem chúng ta ra khỏi Ai Cập.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Chúa Hằng Hữu lại phán: “Ta đã rõ dân này lắm, chúng chỉ là một dân cứng đầu cứng cổ. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Vậy, con để mặc Ta tiêu diệt họ trong một cơn thịnh nộ, rồi Ta sẽ cho con cháu con thành ra một dân tộc lớn.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Nhưng Môi-se khẩn cầu Chúa Hằng Hữu, Đức Chúa Trời của ông: “Lạy Chúa Hằng Hữu, vì đâu cơn thịnh nộ của Ngài lại nổi lên tiêu diệt chính dân Chúa, là dân mà Chúa đã đưa tay toàn năng dẫn dắt ra khỏi xứ Ai Cập? ");
INSERT INTO vieovcb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Sao để cho người Ai Cập nói được rằng Đức Chúa Trời cố tình đem họ đi để tiêu diệt họ khỏi mặt đất? Vậy, xin Chúa nguôi giận và bỏ ý định trừng phạt dân Chúa. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Xin Chúa nghĩ đến các đầy tớ Chúa là Áp-ra-ham, Y-sác, và Gia-cốp; Chúa có chỉ chính mình mà thề với họ rằng: ‘Ta sẽ làm cho con cháu các ngươi đông như sao trời, Ta sẽ cho chúng nó tất cả đất này là đất Ta đã hứa, và chúng nó sẽ hưởng đất này làm sản nghiệp mãi mãi.’” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Chúa Hằng Hữu liền đổi ý, không trừng phạt họ như Ngài đã phán. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Môi-se xuống núi, trên tay cầm hai bảng “Giao Ước” có viết cả hai mặt. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Chính tay Đức Chúa Trời đã viết trên hai bảng đó. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Khi Giô-suê nghe tiếng huyên náo, liền thưa với Môi-se: “Có tiếng quân giao chiến trong trại!” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Nhưng Môi-se đáp: “Đó không phải là tiếng reo hò chiến thắng, cũng chẳng phải là tiếng rên la chiến bại, mà là tiếng hát xướng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Khi họ đến gần trại, Môi-se thấy tượng bò con và cảnh nhảy múa, liền nổi giận, ném hai bảng đá vào chân núi vỡ tan tành. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ông lấy tượng bò con đốt trong lửa, xong đem nghiền nát ra thành bột, rắc trên nước, bắt người Ít-ra-ên uống. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ông hỏi A-rôn: “Dân này đã làm gì anh mà anh khiến họ mang tội nặng nề thế này?” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","A-rôn đáp: “Xin ngài nguôi giận ngài biết dân này rõ quá, họ chỉ chuyên làm điều ác. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Họ bảo tôi: ‘Xin tạo một vị thần hướng dẫn chúng tôi, vì Môi-se, người đem chúng tôi ra khỏi Ai Cập, nay chẳng biết ra sao.’ ");
INSERT INTO vieovcb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Tôi mới bảo họ: ‘Ai có vòng vàng, tháo ra.’ Vậy họ đưa vàng cho tôi, tôi bỏ vào lửa, mới thành ra con bò con này.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Khi Môi-se thấy tình hình không thể kiểm soát được nữa (vì A-rôn đã để cho họ như vậy, tạo cơ hội cho quân thù chế giễu), ");
INSERT INTO vieovcb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","liền ra đứng ở cửa trại, kêu gọi: “Ai thuộc về Chúa Hằng Hữu, đến đây với ta!” Tất cả người Lê-vi đều tập họp bên ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ông nói với họ: “Chúa Hằng Hữu, Đức Chúa Trời của Ít-ra-ên, phán: Mỗi người phải đeo gươm vào, đi qua đi lại suốt từ cửa này đến cửa kia trong trại, và giết sạch mọi người, bất luận anh em ruột, người thân thích, láng giềng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Người Lê-vi vâng lời Môi-se, và hôm ấy có chừng 3.000 người chết. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Môi-se nói với người Lê-vi: “Hôm nay anh em đã hiến thân phục vụ Chúa Hằng Hữu, chẳng sá chi đến cả con cái, anh em ruột mình; vậy Chúa sẽ ban phước cho anh em.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ngày hôm sau, Môi-se bảo dân chúng: “Anh chị em đã phạm tội nặng nề. Nhưng bây giờ tôi sẽ lên núi cầu khẩn Chúa Hằng Hữu, mong Ngài tha tội cho anh chị em.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Vậy, Môi-se trở lên gặp Chúa Hằng Hữu, thưa rằng: “Chúa ôi! Dân này đã phạm tội rất nặng, đã tạo cho mình thần bằng vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nhưng xin Chúa tha tội cho họ, nếu không, xin xóa tên con trong sách của Ngài đi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Chúa Hằng Hữu đáp lời Môi-se: “Người nào phạm tội với Ta, tên người ấy sẽ bị xóa khỏi sách Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Còn hiện giờ, con phải dẫn dân đến nơi Ta đã bảo con. Có thiên sứ của Ta đi trước con. Tuy nhiên, đến ngày hình phạt, Ta sẽ phạt tội dân này.” ");
INSERT INTO vieovcb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Thế rồi Chúa Hằng Hữu giáng tai họa trên Ít-ra-ên, vì họ đã thờ lạy tượng bò con do A-rôn làm ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Chúa Hằng Hữu phán bảo Môi-se: “Hãy rời bỏ nơi đây, đem dân này là dân mà con đã dẫn ra khỏi Ai Cập, đi đến đất Ta đã hứa với Áp-ra-ham, Y-sác, và Gia-cốp sẽ cho con cháu họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ta sẽ sai một thiên sứ đi trước, đuổi người Ca-na-an, người A-mô-rít, người Hê-tít, người Phê-rết, người Hê-vi, và những người Giê-bu đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Đây là một vùng đất rất phì nhiêu. Tuy nhiên, Ta sẽ không cùng đi với dân này; e có thể tiêu diệt họ dọc đường, vì họ là một dân ương ngạnh.” ");
INSERT INTO vieovcb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Khi nghe Môi-se thuật lại những lời nghiêm khắc này, toàn dân đều than khóc, tháo hết đồ trang sức đang đeo ra. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Vì Chúa Hằng Hữu có phán dặn Môi-se nói với họ: “Các ngươi là một dân rất ương ngạnh. Nếu Ta đi với các ngươi chỉ một thời gian ngắn, e Ta phải tiêu diệt các ngươi mất. Bây giờ, tháo hết đồ trang sức ra, đợi xem Ta phải quyết định số phận các ngươi thế nào.” ");
INSERT INTO vieovcb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Thế nên, từ Núi Hô-rếp trở đi, người Ít-ra-ên không còn đeo đồ trang sức nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Môi-se dựng một lều ở bên ngoài và cách xa trại của dân, ông gọi lều này là Lều Hội Kiến. Trong dân chúng, nếu có ai muốn thỉnh ý Chúa Hằng Hữu, thì đến nơi này. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mỗi khi Môi-se đi ra Lều Hội Kiến này, mọi người đều đứng lên, từ cửa trại mình nhìn theo cho đến khi ông vào trong. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ngay lúc ông bước vào lều, trụ mây hạ xuống trước cửa trong khi Chúa Hằng Hữu phán với Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Khi thấy trụ mây trước cửa lều, toàn dân đều thờ lạy từ cửa trại mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Chúa Hằng Hữu đối diện nói chuyện với Môi-se như một người nói chuyện với bạn thân. Khi Môi-se về trại, Giô-suê, con trai Nun, phụ tá của ông, vẫn ở lại trong Lều Hội Kiến. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Môi-se thưa với Chúa Hằng Hữu: “Chúa bảo con dẫn dân này đi, nhưng không cho con biết Chúa sẽ sai ai đi với con, tuy Chúa có nói rằng Chúa biết rõ cá nhân con và con được Chúa đoái hoài. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nếu đúng vậy, con cầu xin Chúa hướng dẫn đường đi nước bước, cho con hiểu Ngài và luôn tìm được ân huệ Chúa. Cũng xin Chúa coi dân này là dân của Ngài.” ");
INSERT INTO vieovcb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Chúa Hằng Hữu đáp: “Chính Ta sẽ đi với con, và cho con được nghỉ ngơi thanh thản nhẹ nhàng.” ");
INSERT INTO vieovcb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Môi-se thưa: “Nếu Chúa không đi cùng, xin đừng cho chúng con đi nữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Làm sao người ta biết được rằng con và dân này được Chúa đoái hoài? Nhưng khi có Chúa đi cùng, con và dân của Ngài sẽ khác hẳn mọi dân tộc khác trên thế giới.” ");
INSERT INTO vieovcb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Chúa Hằng Hữu đáp cùng Môi-se “Ta sẽ làm theo điều con xin, vì cá nhân con được Ta thấu rõ và đoái hoài.” ");
INSERT INTO vieovcb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Môi-se lại thưa: “Xin cho con được thấy vinh quang Chúa.” ");
INSERT INTO vieovcb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Chúa Hằng Hữu đáp: “Ta sẽ làm cho lòng nhân ái của Ta bày tỏ trước mặt con, tuyên hô Danh ‘Chúa Hằng Hữu’ trước con. Ta sẽ nhân từ với người Ta chọn, và Ta sẽ thương xót người Ta muốn thương xót. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Nhưng con sẽ không thấy được vinh quang của diện mạo Ta, vì không ai thấy mặt Ta mà còn sống. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Tuy nhiên, con hãy đứng lên tảng đá này cạnh Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Khi vinh quang Ta đi ngang qua, Ta sẽ đặt con vào khe đá, và lấy tay che con. Cho đến khi Ta qua rồi, ");
INSERT INTO vieovcb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ta sẽ thu tay lại, và con sẽ thấy phía sau Ta chứ không thấy mặt Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Chúa Hằng Hữu phán bảo Môi-se: “Hãy đục hai bảng đá như hai bảng trước. Ta sẽ viết lại những lời đã viết trên hai bảng con đập vỡ. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Chuẩn bị sẵn sàng để sáng mai lên Núi Si-nai, gặp Ta tại đỉnh núi. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Không một người nào được đi theo con; cũng không ai được lảng vảng quanh núi. Không được thả thú vật ăn cỏ gần núi.” ");
INSERT INTO vieovcb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Vậy, Môi-se đục hai bảng đá như hai bảng trước. Hôm sau ông dậy sớm, lên Núi Si-nai như Chúa Hằng Hữu đã dặn, cầm theo hai bảng đá. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Chúa Hằng Hữu giáng xuống trong đám mây và đứng bên ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Chúa Hằng Hữu đi qua trước mặt Môi-se, tuyên hô danh hiệu: “Giê-hô-va! Ta là Chúa Hằng Hữu! Đức Chúa Trời có lòng thương xót, từ ái, chậm giận, đầy bác ái, và thành tín. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ta giữ lòng bác ái hàng nghìn đời; Ta sẽ tha thứ sự bất chính, vi phạm, và tội lỗi. Nhưng Ta không để kẻ phạm tội thoát hình phạt. Ta sẽ phạt con cháu họ đến ba bốn đời vì tội cha ông.” ");
INSERT INTO vieovcb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Môi-se vội vàng dập đầu xuống đất thờ lạy. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ông thưa với Chúa: “Lạy Chúa Hằng Hữu, nếu con được Chúa đoái hoài, xin Chúa cùng đi với chúng con, dù dân này ương ngạnh. Xin Chúa thứ tha sự bất chính và tội lỗi chúng con, và chấp nhận chúng con làm dân của Chúa.” ");
INSERT INTO vieovcb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Chúa Hằng Hữu đáp: “Đây, Ta kết ước với con: Trước mắt dân này, Ta sẽ làm những phép lạ chưa hề thấy trên mặt đất; toàn dân Ít-ra-ên sẽ thấy những việc đáng sợ mà Chúa Hằng Hữu làm cho họ ");
INSERT INTO vieovcb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Nhưng mọi người phải nhớ tuân theo những điều Ta truyền dạy đây, rồi Ta sẽ đuổi các dân tộc A-mô-rít, Ca-na-an, Hê-tít, Phê-rết, Hê-vi, và Giê-bu, làm họ chạy dài trước mặt các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Phải thận trọng, không được kết ước với các dân bản xứ, vì nếu làm vậy, họ sẽ sống chung và trở thành cạm bẫy dỗ dành các ngươi phạm tội. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nhưng phải đập nát bàn thờ, trụ thờ, và thần tượng của họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Các ngươi không được thờ thần nào khác, vì Danh Ngài là Chúa Kỵ Tà. Đức Chúa Trời thật ghen trong mối liên hệ với các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Tuyệt đối không được kết ước với người bản xứ, vì khi họ hành dâm chạy theo tà thần mình, cúng tế lễ vật, sẽ mời các ngươi ăn của cúng thần tượng. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Cũng đừng cưới con gái họ cho con trai mình, vì con gái họ vốn hành dâm, chạy theo các thần của họ, và sẽ xúi con trai các ngươi thờ lạy các thần ấy. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Các ngươi không được đúc thần tượng. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Phải giữ lễ Bánh Không Men trong bảy ngày như Ta đã dạy con, vào những ngày đã định trong tháng giêng, là tháng Ít-ra-ên ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Phải dâng các con đầu lòng cho Ta. Về thú vật như bò, chiên, dâng con đực đầu lòng. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Nếu là lừa, dâng một con chiên con để thay thế; nhưng nếu không thay thế, phải bẻ gãy cổ con lừa. Về con trưởng nam của các ngươi, tất cả phải được chuộc. Không ai ra mắt Ta với hai tay trắng. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Phải nghỉ ngày Sa-bát, dù trong lúc đi cày hay trong mùa gặt, chỉ được làm việc sáu ngày. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Phải mừng Lễ Gặt Hái đầu mùa và Lễ Thu Hoạch vào cuối năm. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Vậy, mỗi năm ba lần, tất cả người nam Ít-ra-ên phải đến ra mắt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Sẽ không có ai tranh chiếm đất đai các ngươi trong dịp ra mắt Chúa Hằng Hữu hằng năm ba lần như thế, vì Ta sẽ đuổi các dân tộc khác đi, mở rộng bờ cõi lãnh thổ các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Không được dâng máu sinh tế lên Ta chung với bánh có men. Cũng không được để thịt sinh tế lễ Vượt Qua lại cho đến hôm sau. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Phải đem dâng vào nhà Chúa Hằng Hữu, Đức Chúa Trời của ngươi các hoa quả đầu mùa chọn lọc. Không được nấu thịt dê con trong sữa mẹ nó.” ");
INSERT INTO vieovcb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Rồi Chúa Hằng Hữu phán bảo Môi-se: “Ghi lại những điều Ta vừa ban bố, vì dựa trên những điều này, Ta lập giao ước với con và với Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Môi-se ở trên núi với Chúa Hằng Hữu trong bốn mươi ngày và bốn mươi đêm. Suốt thời gian này, ông không ăn cũng không uống. Chúa Hằng Hữu viết các quy ước, tức là mười điều răn, vào bảng đá. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sau đó, Môi-se xuống Núi Si-nai, tay cầm hai bảng đá, ông không biết rằng mặt ông sáng rực vì đã hầu chuyện Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Khi thấy mặt Môi-se sáng như vậy, A-rôn và toàn dân Ít-ra-ên sợ không dám đến gần. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Môi-se phải gọi A-rôn và các bậc lãnh đạo trong dân, họ mới dám đến nói chuyện với ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sau đó, toàn dân Ít-ra-ên cũng đến gần. Ông truyền lại cho họ các lệnh Chúa Hằng Hữu đã ban bố trên Núi Si-nai. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Khi đã truyền xong mọi điều, Môi-se lấy màn che mặt mình lại. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Nhưng mỗi khi đi hầu chuyện Chúa Hằng Hữu, ông tháo màn đeo mặt cho đến khi ông trở ra, và truyền lại cho dân những điều Chúa Hằng Hữu dạy bảo. ");
INSERT INTO vieovcb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Vì người Ít-ra-ên thấy mặt ông sáng rực, nên Môi-se phải lấy màn che mặt cho đến khi trở lại hầu chuyện Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Môi-se triệu tập toàn dân họp lại và tuyên bố: “Đây là mệnh lệnh Chúa Hằng Hữu truyền cho chúng ta vâng giữ: ");
INSERT INTO vieovcb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mọi người chỉ được làm việc trong sáu ngày, nhưng ngày thứ bảy phải nghỉ vì là ngày Sa-bát, là ngày thánh để thờ phượng Chúa Hằng Hữu. Ai làm việc trong ngày ấy phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ngay cả lửa cũng không được nhóm lên trong ngày Sa-bát.” ");
INSERT INTO vieovcb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Môi-se nói tiếp với toàn dân: “Chúa Hằng Hữu cũng truyền rằng: ");
INSERT INTO vieovcb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mỗi người tùy tâm, trích ra trong tài sản mình có, đem dâng lên Chúa Hằng Hữu: Vàng, bạc, đồng; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","chỉ xanh, tím, đỏ; vải gai mịn, lông dê; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","da chiên nhuộm đỏ, da dê gỗ keo; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","dầu thắp; chất liệu dùng làm dầu xức và hương thơm; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","bạch ngọc, và các thứ ngọc khác để gắn vào ê-phót và bảng đeo ngực. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Ai là người khéo tay trong toàn dân, phải đến làm Đền Tạm theo như Chúa Hằng Hữu đã phán bảo: ");
INSERT INTO vieovcb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Trại và nóc trại, móc, khung, thanh ngang, trụ và lỗ trụ; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Hòm Giao Ước và đòn khiêng; nắp chuộc tội trên Hòm; màn che Nơi Thánh, ");
INSERT INTO vieovcb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","cái bàn và đòn khiêng cùng với đồ phụ tùng; Bánh Thánh; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","chân đèn, đồ dụng cụ, đèn, và dầu thắp đèn; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","bàn thờ xông hương và đòn khiêng; dầu xức thánh, hương thơm; màn che cửa Đền Tạm; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","bàn thờ dâng của lễ thiêu; rá đồng, đòn khiêng cùng đồ phụ tùng; bồn nước và chân bồn; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","màn che hành lang; trụ và lỗ trụ; màn che cửa hành lang; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","móc và dây trong hành lang Đền Tạm; ");
INSERT INTO vieovcb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","bộ áo lễ của Thầy Tế lễ A-rôn và các con trai người mặc trong lúc thi hành chức vụ trong Nơi Thánh.” ");
INSERT INTO vieovcb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Nghe xong, ai nấy cáo từ Môi-se để về trại mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Những người được cảm động, liền tự nguyện trở lại, mang theo lễ vật dâng lên Chúa Hằng Hữu để dùng cất Đền Tạm, làm dụng cụ và may áo thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Họ kéo nhau đến, cả nam lẫn nữ, với lòng tự nguyện, dâng lên Chúa Hằng Hữu các món nữ trang bằng vàng như hoa tai, nhẫn, kiềng. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Những người khác mang đến chỉ xanh, tím, đỏ, chỉ gai mịn, lông dê, da chiên nhuộm đỏ, và da dê. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Người khác lại đem dâng Chúa Hằng Hữu bạc và đồng. Người thì dâng gỗ keo, tùy theo khả năng mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Các phụ nữ khéo tay kéo chỉ xanh, tím, đỏ, và dệt vải gai mịn. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Các bà khác tình nguyện dệt lông dê, theo khả năng mình. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Các nhà lãnh đạo dân chúng đem dâng bạch ngọc và các thứ ngọc khác để gắn ê-phót và bảng đeo ngực. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Họ cũng dâng hương liệu để chế dầu xức thánh và hương thơm cùng với dầu thắp. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Vậy trong toàn dân Ít-ra-ên, dù nam hay nữ, tất cả những người sẵn lòng đóng góp để thực hiện công tác Chúa Hằng Hữu truyền bảo Môi-se, đều tự nguyện mang lễ vật đến dâng lên Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Môi-se bảo mọi người: “Chúa Hằng Hữu đã chỉ định đích danh Bê-sa-lê (con trai U-ri, cháu Hu-rơ, thuộc đại tộc Giu-đa) ");
INSERT INTO vieovcb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","làm thợ chính, vì Ngài đã cho người này đầy Thánh Linh của Đức Chúa Trời, có tài năng, thông minh, và kiến thức. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ông dùng vàng, bạc, và đồng làm ra các vật dụng tinh vi đẹp đẽ. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ông còn cắt, khảm ngọc, và chạm gỗ. Chung qui để làm mọi công việc nghệ thuật khéo léo. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Còn một người thứ hai là Ô-hô-li-áp (con trai A-hi-sa-mạc, thuộc đại tộc Đan), cũng có tài để dạy lại cho người khác kiến thức của mình như Bê-sa-lê vậy. ");
INSERT INTO vieovcb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Chúa Hằng Hữu phú cho hai người này nhiều kỹ năng về nhiều ngành như thợ bạc, thợ cắt ngọc, chạm trổ, thêu thùa (dùng chỉ xanh, tím, và đỏ), dệt sợi (dùng các sợi gai mịn) và các công việc của nghệ nhân và ngươi thiết kế.” ");
INSERT INTO vieovcb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bê-sa-lê, Ô-hô-li-áp cùng với những người khác được Chúa Hằng Hữu phú cho tài năng và sự thông minh, để thực hiện công tác xây cất Đền Tạm, và chế tạo các dụng cụ như Chúa Hằng Hữu đã phán dạy.” ");
INSERT INTO vieovcb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Vậy, Môi-se gọi Bê-sa-lê, Ô-hô-li-áp, và tất cả nghệ nhân khác đến làm việc. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Môi-se trao cho họ các vật liệu dân chúng hiến dâng như của lễ thánh để hoàn tất Đền Tạm. Nhưng dân chúng vẫn cứ tiếp tục đem dâng thêm vào mỗi buổi sáng. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Cuối cùng các người thợ phải ngưng công việc xây cất. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Họ đến gặp Môi-se và nói: “Các vật liệu dân chúng đem dâng để thực hiện công tác Chúa Hằng Hữu ấn định hiện dư nhiều quá.” ");
INSERT INTO vieovcb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Vì vậy, Môi-se ra lệnh cho người đi báo cho toàn dân hay rằng: “Mọi người nam cũng như nữ, không ai được đem dâng vật liệu làm Đền Tạm nữa. Chúng ta đã có đủ vật liệu!” Đến lúc bị cấm như vậy, người ta mới thôi. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Dân chúng hiến dâng vật liệu nhiều hơn sự cần dùng để hoàn thành toàn bộ công việc. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Một số thợ khéo trong nhóm xây dựng Đền Tạm bắt đầu dệt mười bức màn bằng chỉ gai mịn, dùng chỉ xanh, tím, và đỏ, thêu hình chê-ru-bim vô cùng tinh vi. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mười bức màn đều bằng nhau, dài 12,9 mét, rộng 1,8 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Họ nối từng năm bức màn lại với nhau thành hai tấm lớn. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Họ dùng chỉ xanh kết các vòng dọc theo đường biên của hai tấm lớn, ");
INSERT INTO vieovcb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","năm mươi vòng mỗi bên, đối diện nhau. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Người ta làm năm mươi cái móc bằng vàng, cài vào các vòng chỉ, như vậy hai tấm lớn được kết lại thành nóc Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Họ cũng dệt mười một bức màn bằng lông dê để phủ lên trên nóc Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Mười một bức màn này đều bằng nhau, dài 13,8 mét, rộng 1,8 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Năm bức màn lông dê nối lại thành một tấm lớn; còn lại sáu bức kia nối thành một tấm lớn thứ hai. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Người ta làm năm mươi cái vòng dọc theo đường biên của mỗi tấm lớn. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Họ dùng năm mươi cái móc đồng nối hai tấm lớn lại với nhau. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Lớp trên cùng của nóc đền làm bằng da chiên nhuộm đỏ và da dê. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Gỗ keo được dùng để làm vách Đền Tạm, dựng thẳng đứng. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Mỗi tấm ván dài 4,6 mét, rộng 0,69 mét, ");
INSERT INTO vieovcb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","có hai cái mộng để ghép vào các lỗ mộng. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Vách phía nam gồm hai mươi tấm ván; ");
INSERT INTO vieovcb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","dưới mỗi tấm có hai lỗ mộng bằng bạc, cộng bốn mươi lỗ mộng. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Vách phía bắc Đền Tạm cũng gồm hai mươi tấm ván, ");
INSERT INTO vieovcb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","dưới mỗi tấm có hai lỗ mộng bạc, cộng bốn mươi lỗ mộng. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Vách phía tây tức là phía sau Đền Tạm gồm sáu tấm ván, ");
INSERT INTO vieovcb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","thêm vào hai tấm nữa ở hai góc phía sau. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Các tấm ván này sẽ được ghép vào nhau bằng móc cài cả dưới lẫn trên. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Vậy, vách phía tây có tám tấm ván và mười sáu lỗ mộng bằng bạc, hai lỗ mỗi tấm. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Họ cũng làm thanh ngang cho vách Đền Tạm cũng bằng gỗ keo, ");
INSERT INTO vieovcb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","mỗi phía năm thanh, vách phía tây cũng có năm thanh. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Thanh chính giữa nằm giữa vách, chạy dài từ đầu này chí đầu kia của đền. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Người ta bọc vàng các tấm ván vách và các thanh ngang, làm các vòng vàng để xỏ thanh ngang. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Người ta may một bức màn bằng vải gai mịn, rồi dùng chỉ xanh, tím, và đỏ thêu hình chê-ru-bim vô cùng tinh vi. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Màn được móc vào bốn móc vàng của bốn trụ gỗ keo bọc vàng, trụ được dựng trên lỗ trụ bằng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Người ta cũng làm một bức màn che cửa đền bằng vải gai mịn, thêu chỉ xanh, tím, và đỏ rất tinh vi. ");
INSERT INTO vieovcb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Màn này được treo bằng năm móc vàng trên năm trụ cây keo bọc vàng. Các lỗ trụ này đều bằng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bê-sa-lê đóng một cái Hòm bằng gỗ keo dài 1,15 mét, rộng 0,69 mét, cao 0,69 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ông lấy vàng ròng bọc bên ngoài, lót bên trong và viền chung quanh. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ông làm bốn cái khoen bằng vàng gắn vào bốn góc Hòm, mỗi bên hai cái. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ông cũng làm đòn khiên bằng cây keo bọc vàng, ");
INSERT INTO vieovcb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","và xỏ đòn vào các khoen ở hai bên để khiêng Hòm đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Bê-sa-lê cũng làm nắp chuộc tội bằng vàng ròng, dài 1,15 mét, rộng 0,69 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ông làm hai chê-ru-bim bằng vàng dát dính liền với nắp chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ông làm mỗi chê-ru-bim đứng trên một đầu nắp, tất cả đều bằng vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Hai chê-ru-bim đứng đối diện nhau, xòe cánh che trên Nắp Chuộc Tội, mặt nhìn xuống nắp. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bê-sa-lê lại đóng một cái bàn bằng gỗ keo, dài 0,92 mét, rộng 0,46 mét, cao 0,69 mét, ");
INSERT INTO vieovcb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","rồi lấy vàng ròng bọc bàn và viền chung quanh. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ông đóng khung chung quanh mặt bàn, bề rộng của khung bằng một bàn tay, rồi viền vàng chung quanh khung. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ông làm bốn cái khoen bằng vàng gắn vào bốn góc, chỗ có bốn chân bàn. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Cái khoen đó gắn gần khung của mặt bàn để xỏ đòn khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Đòn khiêng làm bằng gỗ keo bọc vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ông cũng lấy vàng ròng làm các dụng cụ để trên bàn: Đĩa, muỗng, bát, và bình. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bê-sa-lê làm một chân đèn bằng vàng ròng dát, từ chân cho đến thân, đài, bầu, và hoa của đèn đều dính liền nhau. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Từ thân mọc ra sáu cành, mỗi bên ba cành. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Mỗi cành có ba cái hoa hình hạnh nhân. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Thân của chân đèn có bốn hoa hình hạnh nhân. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Cứ mỗi hai cành mọc ra từ thân, ông làm một cái đài bên dưới. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Đài và cành được làm dính liền nhau bằng vàng dát nguyên miếng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ông cũng làm bảy cái đèn, kéo cắt tim đèn, và đĩa đựng tàn bằng vàng ròng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ông dùng hết 34 ký vàng ròng để làm chân đèn và đồ phụ tùng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ông đóng một bàn thờ xông hương bằng gỗ keo. Bàn thờ hình vuông, mỗi bề 0,46 mét, cao 0,92 mét. Các sừng của bàn thờ được gắn liền với bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ông lấy vàng ròng lót mặt bàn, bọc cạnh bàn, các sừng của bàn thờ, và viền chung quanh bàn. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ông làm hai khoen vàng, gắn bên dưới đường viền của bàn, mỗi bên một cái, dùng xỏ đòn khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Đòn khiêng được làm bằng gỗ keo bọc vàng. ");
INSERT INTO vieovcb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Ông cũng chế dầu xức thánh và hương thơm thuần túy theo đúng phương pháp hòa hợp hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bàn thờ dâng tế lễ thiêu cũng được làm bằng gỗ keo, hình vuông, 2,3 mét mỗi bề, cao 1,4 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ông làm sừng ở bốn góc, dính liền với bàn thờ, rồi lấy đồng bọc bàn thờ và sừng. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ông cũng làm các đồ phụ tùng bàn thờ toàn bằng đồng: Thùng đựng tro, xuổng, bồn chứa nước, đinh ba, và đĩa đựng than lửa. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Sau đó, ông làm một cái rá giữ than bằng đồng, đặt trong bàn thờ trên mép nhô ra; rá cao đến phân nửa bề cao bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ông làm bốn khoen đồng ở bốn góc rá để giữ đòn khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Đòn khiêng được làm bằng gỗ keo bọc đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ông xỏ đòn khiêng vào các khoen đồng hai bên bàn thờ để khiêng đi. Bàn thờ được đóng bằng ván, rỗng ở giữa. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ông cũng lấy mấy tấm gương soi bằng đồng do các phụ nữ hội họp tại cửa Đền Tạm dâng lên, để làm ra bồn rửa và chân bồn. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Sau đó, ông làm hành lang. Hành lang phía nam dài 46 mét, bao bọc bằng vải gai mịn. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Có hai mươi trụ với hai mươi lỗ trụ bằng đồng, cùng với các móc và đai để gắn vào trụ bằng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Hành lang phía bắc cũng dài 46 mét, có hai mươi trụ và hai mươi lỗ trụ bằng đồng, các móc, và đai bằng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Hành lang phía tây dài 23 mét, bao bọc bằng vải gai mịn, có mười trụ và mười lỗ trụ bằng đồng, các móc, và đai bằng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Hành lang phía đông cũng dài 23 mét. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Lối vào hành lang phía đông có hai bức màn. Bức màn bên phải dài 6,9 mét, treo trên ba trụ được dựng trên ba lỗ trụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Bức màn bên trái cũng dài 6,9 mét, và treo trên ba trụ được dựng trên ba lỗ trụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Chung quanh hành lang, tất cả các bức màn đều làm bằng vải gai mịn. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Các lỗ trụ bằng đồng, các móc và đai trụ bằng bạc, và các trụ đều viền bạc, đầu trụ bọc bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Bức màn che cửa hành lang bằng vải gai mịn thêu xanh, tím, và đỏ, dài 9,2 mét, rộng 2,3 mét, tương xứng với màn bao bọc hành lang. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Màn được treo trên bốn trụ có bốn lỗ trụ làm bằng đồng, các móc bằng bạc; các trụ viền bạc, đầu trụ bọc bạc. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Đinh dùng cho Đền Tạm và hành lang đều làm bằng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Sau đây là một vài con số tổng kết các vật dụng xây cất Đền Tạm, Trại Chứng Cớ, do tay các con cháu Lê-vi thực hiện, dưới quyền quản đốc của Y-tha-ma, con Thầy Tế lễ A-rôn, theo lệnh truyền của Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Thợ chính là Bê-sa-lê, con U-ri, cháu Hu-rơ, thuộc đại tộc Giu-đa, làm được tất cả mọi việc Chúa Hằng Hữu truyền bảo Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ô-hô-li-áp, con A-hi-sa-mạc, thuộc đại tộc Đan, là những người nhiều tài năng, gồm tài chạm trổ, điêu khắc, thêu thùa, dệt chỉ xanh, tím, đỏ, và chỉ gai mịn. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tổng số vàng sử dụng trong công cuộc xây cất Đền Tạm là 994 ký, theo tiêu chuẩn cân đo Nơi Thánh. Số vàng này do mọi người hiến dâng. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Tổng số bạc là 3.420 ký, theo tiêu chuẩn cân đo Nơi Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Số bạc này thu được trong cuộc kiểm kê dân số, theo nguyên tắc 6 gam bạc mỗi đầu người. Nam công dân từ hai mươi tuổi trở lên gồm có 603.550 người. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Bạc dùng làm các lỗ mộng của khung đền và lỗ mộng các trụ của màn; một trăm lỗ mộng tốn 3.400 ký, mỗi lỗ mộng 34 ký. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Số bạc còn lại chừng 20,2 ký được dùng làm móc, đai, và dùng bọc đầu trụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Tổng số đồng dâng lên là 2.407 ký. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Số đồng này dùng làm lỗ trụ cửa ra vào Đền Tạm, bàn thờ bằng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Rá của bàn thờ này và các đồ phụ tùng khác, các lỗ trụ hành lang, các lỗ trụ cổng hành lang, và tất cả đinh dùng trong đền và hành lang. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bộ áo lễ thánh của A-rôn mặc trong lúc thừa hành chức vụ tại Nơi Thánh được các tay thợ khéo may đúng theo kiểu mẫu Chúa Hằng Hữu truyền cho Môi-se, đủ các màu sắc xanh, tím, và đỏ. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Họ chế tạo e-phót bằng vàng, sợi chỉ xanh, chỉ tím, chỉ đỏ. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Họ cán mỏng vàng, cắt thành sợi để thêu dặm vào với chỉ xanh, tím, và đỏ trên vải gai mịn, và như thế, họ chế tạo ê-phót một cách vô cùng tinh vi. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ê-phót được nối liền nhau ở bên trên bằng hai cầu vai, bên dưới có dây thắt lưng. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Thắt lưng cũng được may bằng vải gai mịn, thêu kim tuyến, chỉ xanh, tím, và đỏ vô cùng tinh vi cũng như ê-phót, đúng theo kiểu mẫu Chúa Hằng Hữu truyền cho Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Họ cắt các viên bạch ngọc, khắc tên các con trai Ít-ra-ên lên theo lối khắc con dấu để tưởng niệm con cháu Ít-ra-ên; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","rồi đem khảm trong khung vàng, đính nơi hai cầu vai của ê-phót các viên ngọc đúng theo điều Chúa Hằng Hữu đã phán dặn Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bảng đeo ngực cũng như ê-phót được may bằng vải gai mịn thêu kim tuyến, chỉ xanh, tím, và đỏ vô cùng tinh vi. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bảng này hình vuông, mỗi cạnh một gang tay, may bằng hai lớp vải. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Trên bảng đeo ngực có gắn bốn hàng ngọc. Hàng thứ nhất gồm: Hồng mã não, hoàng ngọc, và ngọc lục bảo. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Hàng thứ hai gồm: Bích ngọc, lam ngọc, và kim cương. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Hàng thứ ba gồm: Ngọc phong tín, ngọc mã não, và ngọc thạch anh tím. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Hàng thứ tư gồm: Lục ngọc thạch, bạch ngọc, và vân ngọc. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Trên mười hai viên ngọc này họ khắc tên mười hai đại tộc Ít-ra-ên theo lối khắc con dấu. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Họ làm hai sợi dây chuyền xoắn trôn ốc bằng vàng ròng. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Họ cũng làm hai cái khuôn thảm và hai cái khoen bằng vàng, rồi gắn hai khoen đó vào hai cái góc của bảng đeo ngực. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Mỗi dây chuyền có một đầu nối với hai khoen vàng gắn trên đầu bảng đeo ngực, ");
INSERT INTO vieovcb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","đầu kia nối với hai khung vàng trên hai cầu vai ê-phót. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Họ làm thêm bốn khoen vàng nữa, hai khoen gắn ở góc trong bên dưới bảng đeo ngực, gần ê-phót. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hai khoen kia gắn vào phần dưới của hai cầu vai ê-phót, về phía trước, gần chỗ nối với vạt trước ê-phót, bên trên thắt lưng. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Họ dùng dây màu xanh nối các khoen này với nhau, như vậy bảng đeo ngực sẽ nằm bên trên dây thắt lưng đã được dệt một cách tinh vi đẹp đẽ, và sẽ không rời khỏi ê-phót, đúng theo điều Chúa Hằng Hữu phán dặn Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Áo khoác ngoài ê-phót được dệt toàn màu xanh. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Giữa áo có một lỗ để tròng đầu, giống như cổ của áo giáp, quanh cổ được viền cẩn thận cho khỏi rách. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Họ dùng chỉ xanh, tím, đỏ và chỉ gai thắt trái lựu, kết dọc theo gấu áo này. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Họ cũng làm chuông nhỏ bằng vàng ròng, kết xen kẽ với trái lựu trên gấu áo. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Áo này sẽ được A-rôn mặc khi phụng sự Chúa Hằng Hữu, theo điều Ngài dạy Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Họ cũng dùng sợi gai mịn dệt áo dài cho A-rôn và các con trai người. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Họ còn dệt khăn, mũ, quần lót ngắn, toàn bằng sợi gai mịn. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Dây thắt lưng bằng vải gai mịn được thêu xanh, tím, và đỏ, như Chúa Hằng Hữu đã phán dặn Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Họ làm một thẻ vàng ròng, và khắc trên thẻ này theo lối khắc con dấu dòng chữ: “THÁNH CHO CHÚA HẰNG HỮU.” ");
INSERT INTO vieovcb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Họ dùng dây màu xanh buộc thẻ vào khăn đội đầu, như điều Chúa Hằng Hữu phán dặn Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Vậy, công việc Đền Tạm tức là Lều Hội Kiến hoàn tất đúng theo mọi điều Chúa Hằng Hữu dặn bảo Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Họ đem tất cả mọi thứ đến cho Môi-se: Lều và đồ phụ tùng, móc, khung, thanh ngang, trụ, và lỗ trụ; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","lớp da chiên nhuộm đỏ và da dê; các bức màn che trước Hòm; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Hòm Giao Ước với đòn khiêng; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","nắp chuộc tội trên Hòm; bàn và đồ phụ tùng; Bánh Thánh; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","chân đèn bằng vàng ròng, đồ phụ tùng, và dầu thắp; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","bàn thờ bằng vàng; dầu xức thánh và hương thơm; bức màn che cửa đền; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","bàn thờ bằng đồng; rá đồng, đòn khiêng, và đồ phụ tùng; bồn rửa và chân bồn; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","các bức màn che quanh hành lang; dây và đinh; cùng với tất cả đồ phụ tùng dùng trong công việc Đền Tạm; ");
INSERT INTO vieovcb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","bộ áo lễ của Thầy Tế lễ A-rôn và các con trai người mặc trong lúc thi hành chức vụ trong Nơi Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Người Ít-ra-ên thực hiện mọi điều gì Chúa Hằng Hữu đã phán dặn Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Sau khi xem xét kiểm tra lại mọi vật, Môi-se thấy họ làm đúng theo lời Chúa Hằng Hữu đã phán dạy, nên chúc phước cho họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Vào ngày mồng một tháng giêng, con phải lo dựng Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Con sẽ đặt Hòm Giao Ước trong đền, rồi dùng bức màn ngăn nơi để Hòm lại. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Đem cái bàn vào, xếp các đồ phụ tùng trên bàn. Đem chân đèn vào, thắp đèn lên. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Đặt bàn thờ xông hương bằng vàng trước Hòm Giao Ước. Treo bức màn che cửa Đền Tạm lên. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Đặt bàn thờ dâng của lễ thiêu trước cửa đền. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Đặt bồn rửa giữa Đền Tạm và bàn thờ, đổ nước vào bồn. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Dựng hành lang chung quanh Đền Tạm và treo bức màn che cửa hành lang lên. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Hãy lấy dầu thánh xức cho Đền Tạm và mọi vật ở trong đền, hiến dâng đền và mọi vật ở trong đền, như vậy Đền Tạm sẽ được thánh hóa. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Con cũng xức dầu thánh cho bàn thờ dâng tế lễ thiêu và đồ phụ tùng, hiến dâng bàn thờ. Bàn thờ sẽ nên rất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Xức dầu cho bồn rửa và chân bồn rồi hiến dâng bồn. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Sau đó, con đem A-rôn và các con trai người đến trước cửa Đền Tạm, lấy nước tắm rửa họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Mặc bộ áo lễ thánh vào cho A-rôn, xức dầu cho người, và hiến dâng người để người làm tế lễ phục vụ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Cũng đem các con trai A-rôn đến, mặc áo dài cho họ. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Xức dầu cho họ cũng như con đã xức dầu cho cha họ, để họ cũng làm thầy tế lễ phục vụ Ta. Lễ xức dầu thánh này có hiệu lực vĩnh viễn, con cháu họ sẽ làm thầy tế lễ phục vụ Ta đời đời.” ");
INSERT INTO vieovcb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Môi-se vâng lời, làm tất cả mọi điều Chúa Hằng Hữu phán bảo ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Vậy, vào ngày đầu của tháng thứ nhất, năm thứ hai, Đền Tạm được dựng lên. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Môi-se dựng Đền Tạm bằng cách đặt các lỗ trụ, dựng khung, đặt thanh ngang và dựng các trụ. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ông giăng vải trại lên trên, phủ các lớp kia bên trên vải trại, theo điều Chúa Hằng Hữu đã phán bảo ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Môi-se để các bảng “Chứng Cớ” vào Hòm Giao Ước, xỏ đòn khiêng, và đặt nắp chuộc tội lên trên Hòm. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ông đem Hòm vào Đền Tạm, rồi dùng bức màn che lại, như lời Chúa Hằng Hữu đã dạy bảo. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ông đặt cái bàn trong Đền Tạm, về phía bắc của Nơi Thánh, bên ngoài bức màn. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Và để Bánh Thánh trên bàn trước mặt Chúa Hằng Hữu, như lời Ngài phán dạy. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ông để chân đèn đối diện với cái bàn trong Đền Tạm, về phía nam của Nơi Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Thắp đèn lên trước mặt Chúa Hằng Hữu, như Ngài đã phán dặn ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ông đặt bàn thờ bằng vàng trong Đền Tạm, phía trước bức màn trong Nơi Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Đốt hương trên bàn thờ này, như Chúa Hằng Hữu đã phán dặn ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ông treo bức màn che cửa Đền Tạm lên, ");
INSERT INTO vieovcb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","rồi đặt bàn thờ dâng tế lễ thiêu trước cửa ra vào Đền Tạm. Dâng lên bàn thờ này một của lễ thiêu và của lễ chay, theo lời Chúa Hằng Hữu phán bảo ông. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ông đặt bồn rửa khoảng giữa Đền Tạm và bàn thờ. Rồi đổ nước vào. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Tại đây Môi-se, A-rôn, và các con trai A-rôn rửa tay chân. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Mỗi khi vào Đền Tạm hay đến gần bàn thờ, họ rửa tay chân sạch sẽ theo lời Chúa Hằng Hữu phán dạy Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ông dựng hành lang chung quanh Đền Tạm và bàn thờ, treo bức màn che cửa hành lang lên. Vậy, Môi-se hoàn tất mọi việc. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Có một đám mây kéo đến bao bọc Đền Tạm, và vinh quang của Chúa Hằng Hữu tràn ngập đền. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Môi-se không vào Đền Tạm được, vì đám mây dày đặc và vinh quang của Chúa Hằng Hữu đầy dẫy trong đền. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Trong cuộc hành trình của người Ít-ra-ên, mỗi khi thấy trụ mây bay lên từ nóc Đền Tạm, họ ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Nếu không thấy trụ mây bay lên, họ cứ ở lại cho đến khi trụ mây rời chỗ. ");
INSERT INTO vieovcb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Và trong suốt cuộc hành trình này, ban ngày có trụ mây của Chúa Hằng Hữu ở trên Đền Tạm; ban đêm có lửa trong mây chiếu sáng cho toàn dân Ít-ra-ên.");
INSERT INTO vieovcb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Tại Đền Tạm, Chúa Hằng Hữu gọi Môi-se, ");
INSERT INTO vieovcb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","bảo ông hướng dẫn người Ít-ra-ên dâng tế lễ như sau: “Khi một người muốn dâng sinh tế lên Chúa Hằng Hữu, phải dâng bò hay chiên bắt từ trong bầy gia súc. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Nếu ai muốn dâng bò làm tế lễ thiêu, thì phải chọn một con bò đực không tì vít. Các thầy tế lễ sẽ nhận lễ vật tại cửa Đền Tạm, trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Khi người dâng đặt tay trên đầu con sinh, nó sẽ trở thành sinh tế chuộc tội cho người đó. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Người dâng sẽ giết nó trước mặt Chúa Hằng Hữu. Các thầy tế lễ con A-rôn sẽ lấy máu dâng lên và đem rưới trên bốn cạnh bàn thờ, tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Người ấy sẽ lột da con sinh, chặt thịt ra từng miếng. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Các thầy tế lễ, con A-rôn, sẽ nhóm lửa, đốt củi trên bàn thờ, ");
INSERT INTO vieovcb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","rồi xếp các miếng thịt, cái đầu, và mỡ trên củi đang cháy trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Riêng bộ lòng và bộ giò phải được rửa sạch trước khi đem thiêu chung với những phần kia. Đó là tế lễ thiêu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Nếu ai muốn dâng chiên hay dê làm tế lễ thiêu, thì phải chọn một con đực không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Người dâng sẽ giết con sinh tại phía bắc bàn thờ, trước mặt Chúa Hằng Hữu. Các thầy tế lễ con A-rôn sẽ lấy máu rưới trên bốn cạnh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Người ấy sẽ chặt con sinh ra từng miếng. Các thầy tế lễ sẽ xếp thịt, đầu và mỡ trên củi đang cháy trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Riêng bộ lòng và bộ giò phải được rửa sạch trước khi đem thiêu chung với những phần kia. Đó là tế lễ thiêu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Nếu ai muốn dâng chim làm tế lễ thiêu lên Chúa Hằng Hữu, thì phải chọn chim cu đất hoặc bồ câu con. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Thầy tế lễ sẽ đem chim đến bàn thờ, vặn cổ cho máu chảy trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Thầy tế lễ sẽ lấy cái diều và lông ném vào chỗ đổ tro phía đông bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Thầy tế lễ sẽ nắm hai cánh xé chim ra, nhưng không cho hai phần rời nhau hẳn, rồi đốt chim trên củi đang cháy trên bàn thờ. Đó là tế lễ thiêu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Nếu có ai muốn dâng ngũ cốc lên Chúa Hằng Hữu, thì người ấy sẽ lấy bột mịn chế dầu vào, rắc nhũ hương lên trên, ");
INSERT INTO vieovcb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","rồi đem đến cho các thầy tế lễ con A-rôn. Người ấy sẽ bốc một nắm bột—tượng trưng cho toàn số bột đem dâng—trao cho thầy tế lễ đốt trên bàn thờ. Đây là một lễ thiêu dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Phần bột còn lại sẽ thuộc về A-rôn và các con trai người. Bột được đốt dâng lên Chúa Hằng Hữu là lễ vật rất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Nếu ai muốn dâng lên Chúa Hằng Hữu bánh nướng trong lò, thì người ấy có thể dâng bánh làm bằng bột mịn pha dầu không bỏ men, hoặc bánh kẹp mỏng chế dầu không men. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Nếu dâng bánh nướng trên vỉ, bánh sẽ được làm bằng bột mịn pha dầu không bỏ men. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Đem bánh bẻ vụn ra rồi đổ dầu lên trên, đây là một lối dâng ngũ cốc. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nếu muốn dâng ngũ cốc rán trong chảo, thì phải dùng dầu với bột mịn. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Các lễ vật ngũ cốc nói trên sẽ được đem đến cho thầy tế lễ để dâng trên bàn thờ lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nhưng thầy tế lễ chỉ lấy một phần lễ vật tượng trưng đốt trên bàn thờ, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Phần ngũ cốc còn lại sẽ thuộc về A-rôn và các con người. Ngũ cốc được đốt dâng lên Chúa Hằng Hữu là lễ vật rất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Đừng bỏ men vào lễ vật ngũ cốc, vì men cũng như mật, không được đốt để dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Tuy nhiên, người ta có thể dâng các món ấy làm lễ vật trong dịp dâng hoa quả đầu mùa lên Chúa Hằng Hữu, nhưng không được đốt trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Phải bỏ muối vào tất cả các lễ vật, vì muối tiêu biểu cho giao ước của Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Nếu muốn dâng ngũ cốc đầu mùa cho Chúa Hằng Hữu, thì phải giã hạt ngũ cốc còn tươi rồi đem rang đi, ");
INSERT INTO vieovcb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","xong chế dầu vào và rắc nhũ hương lên trên. ");
INSERT INTO vieovcb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Thầy tế lễ sẽ lấy một phần ngũ cốc này, đã chế dầu và nhũ hương, đem đốt để dâng hương thơm lên Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Nếu ai muốn dâng lễ vật để tạ ơn Chúa Hằng Hữu, thì người ấy có thể dâng một con bò, đực hay cái cũng được, nhưng phải là một con vật hoàn toàn, không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Người dâng sẽ đặt tay trên đầu con bò, rồi giết nó tại cửa Đền Tạm. Các thầy tế lễ con A-rôn sẽ lấy máu rảy trên bốn cạnh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Người dâng sẽ sử dụng những phần sau để dùng lửa dâng lên Chúa Hằng Hữu: Mỡ bọc ruột, và tất cả mỡ phía trên ruột, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","hai trái thận với mỡ của nó dính nơi sườn và túi mật, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","rồi các con A-rôn sẽ đem đốt trên củi đang cháy trên bàn thờ, dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Nếu lễ vật tạ ơn cho Chúa Hằng Hữu là một con chiên hay một con dê, dù đực hay cái, thì cũng phải dâng một con vật hoàn toàn, không khuyết tật. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Nếu là một con chiên, thì người dâng phải đem đến trước mặt Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","đặt tay trên đầu nó, rồi giết nó tại cửa Đền Tạm. Các thầy tế lễ con A-rôn sẽ lấy máu rưới trên bốn cạnh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Người dâng sẽ sử dụng những phần sau để dùng lửa dâng lên Chúa Hằng Hữu: Mỡ con chiên, cái đuôi chặt gần xương sống, mỡ bọc ruột, tất cả mỡ phía trên ruột, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","hai trái thận với mỡ của nó dính nơi sườn và túi mật, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","rồi thầy tế lễ sẽ đốt những phần này trên bàn thờ. Đây là một lễ thiêu dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Nếu lễ vật dâng lên Chúa Hằng Hữu là một con dê, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","thì người dâng sẽ đặt tay trên đầu nó, rồi giết nó tại cửa Đền Tạm. Các thầy tế lễ con A-rôn sẽ lấy máu rưới trên bốn cạnh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Người dâng sẽ sử dụng những phần sau để dùng lửa dâng lên Chúa Hằng Hữu: Mỡ bọc ruột, tất cả mỡ phía trên ruột, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","hai trái thận với mỡ của nó dính nơi sườn và túi mật đem đốt trên bàn thờ, ");
INSERT INTO vieovcb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","rồi thầy tế lễ sẽ đốt những phần này trên bàn thờ. Đây là một lễ thiêu dâng hương thơm lên Chúa Hằng Hữu. Tất cả mỡ đều thuộc về Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Đây là một quy lệ có tính cách vĩnh viễn, áp dụng trên toàn lãnh thổ: Không ai được ăn mỡ và máu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Chúa Hằng Hữu lại truyền dạy cho Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Hãy dạy người Ít-ra-ên về trường hợp một người vô tình vi phạm luật lệ của Chúa Hằng Hữu: ");
INSERT INTO vieovcb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Nếu một thầy tế lễ vô tình vi phạm, gây cho dân mang lỗi, thì thầy tế lễ đó phải dâng một con bò tơ không tì vít lên Chúa Hằng Hữu để chuộc tội, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","bằng cách dẫn con bò đến trước cửa Đền Tạm, đặt tay trên đầu nó, rồi giết nó trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Sau đó thầy tế lễ lấy một phần máu bò đem vào Đền Tạm, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","nhúng ngón tay vào máu, rảy bảy lần trước mặt Chúa Hằng Hữu, phía trước bức màn ngăn cách Nơi Chí Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Xong, thầy tế lễ ấy sẽ bôi máu trên các sừng bàn thờ xông hương trước mặt Chúa Hằng Hữu trong Đền Tạm. Máu còn lại đem đổ dưới chân bàn thờ dâng lễ thiêu, tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Thầy tế lễ ấy sẽ lấy tất cả mỡ con bò, mỡ bọc ruột, tất cả mỡ trên bộ lòng, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","hai trái thận với mỡ của nó dính nơi sườn và nơi túi mật, gỡ ra chung với hai trái thận, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","rồi đem đốt trên bàn thờ dâng lễ thiêu, cũng như trường hợp dâng con bò làm lễ tạ ơn. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Nhưng phần còn lại gồm da, thịt, đầu, chân, bộ lòng, phân bò, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","nghĩa là tất cả phần còn lại của nó, thầy tế lễ sẽ đem ra khỏi nơi đóng trại, tại một nơi sạch sẽ, là nơi đổ tro bàn thờ, xếp tất cả trên củi mà đốt đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Nếu toàn dân Ít-ra-ên vô tình vi phạm một điều gì Chúa Hằng Hữu cấm đoán, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","và nhận biết lỗi mình, thì họ phải dâng một con bò tơ để chuộc tội. Bò sẽ được dẫn đến cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Các trưởng lão trong dân chúng sẽ đặt tay trên đầu con bò, rồi giết nó trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Thầy tế lễ sẽ lấy một phần máu bò đem vào Đền Tạm, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","nhúng ngón tay vào máu, rảy bảy lần trước mặt Chúa Hằng Hữu, phía trước bức màn ngăn cách Nơi Chí Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Thầy tế lễ cũng sẽ bôi máu trên các sừng bàn thờ xông hương trước mặt Chúa Hằng Hữu trong Đền Tạm. Máu còn lại đem đổ dưới chân bàn thờ dâng lễ thiêu, tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Thầy tế lễ cũng lấy tất cả mỡ bò đem đốt trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Nếu thầy tế lễ làm lễ chuộc tội cho dân đúng theo thủ tục, thì lỗi họ sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Sau đó, thầy tế lễ đem con bò ra khỏi nơi đóng trại để thiêu như trường hợp tế lễ thiêu chuộc tội cho cá nhân. Đây là lễ chuộc tội cho toàn dân Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Nếu một cấp lãnh đạo Ít-ra-ên vô tình vi phạm điều gì Chúa Hằng Hữu, Đức Chúa Trời của họ cấm đoán, ");
INSERT INTO vieovcb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","và nhận biết tội mình, thì phải dâng một con dê đực không tì vít để chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Người ấy sẽ đặt tay mình trên đầu con dê, rồi giết nó tại nơi người ta giết sinh tế lễ thiêu, trước mặt Chúa Hằng Hữu. Đây là lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Thầy tế lễ sẽ lấy ngón tay nhúng vào máu dê, đem bôi lên các sừng bàn thờ dâng lễ thiêu, máu còn lại đem đổ dưới chân bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Tất cả mỡ dê sẽ được đốt trên bàn thờ, như trường hợp dâng lễ tạ ơn. Như vậy, khi thầy tế lễ làm lễ chuộc tội cho người này, lỗi người sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Nếu một công dân Ít-ra-ên vô tình vi phạm một điều gì Chúa Hằng Hữu cấm đoán ");
INSERT INTO vieovcb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","và nhận biết tội mình, thì phải dâng một con dê cái không tì vít để chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Người ấy sẽ đặt tay trên đầu con dê, rồi giết nó tại nơi người ta giết sinh tế lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Thầy tế lễ sẽ lấy ngón tay nhúng vào máu dê, đem bôi trên các sừng bàn thờ dâng lễ thiêu, máu còn lại đem đổ dưới chân bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Thầy tế lễ cũng lấy tất cả mỡ đem đốt trên bàn thờ dâng hương thơm lên Chúa Hằng Hữu như trường hợp dâng lễ tạ ơn. Như vậy, khi thầy tế lễ làm lễ chuộc tội cho người này, lỗi người sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Nếu người này muốn dâng một con chiên để làm lễ chuộc tội, thì phải chọn một con chiên cái không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Người ấy sẽ đặt tay trên đầu con chiên, rồi giết nó tại nơi người ta giết sinh tế lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Thầy tế lễ lấy ngón tay nhúng vào máu chiên, đem bôi trên các sừng bàn thờ dâng lễ thiêu, máu còn lại đem đổ dưới chân bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Thầy tế lễ cũng lấy mỡ chiên đốt trên bàn thờ, như trường hợp dâng chiên làm lễ tạ ơn lên Chúa Hằng Hữu. Như vậy, khi thầy tế lễ làm lễ chuộc tội cho người này, lỗi người sẽ được tha.” ");
INSERT INTO vieovcb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Nếu một nhân chứng đã tuyên thệ, nhưng không chịu khai những điều mình thấy và biết, thì nhân chứng đó mắc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Nếu ai đụng phải một vật không sạch như xác của thú vật không sạch (thú rừng hay gia súc) hoặc thây của một loại sâu bọ, dù không biết là mình đã đụng, thì cũng mắc tội vì người ấy đã trở nên không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Nếu người ấy đụng phải vật không sạch của loài người, bất kỳ dưới hình thức nào, thì khi biết mình đã đụng, người ấy sẽ mắc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Nếu ai thề thốt—dù để làm một việc tốt hay xấu—mà không suy nghĩ trước, khi biết được lời thề của mình là dại dột, thì người ấy sẽ mắc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Người mắc tội trong các trường hợp kể trên phải xưng tội mình, ");
INSERT INTO vieovcb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","và đem một con chiên hoặc dê cái dâng lên Chúa Hằng Hữu làm sinh tế chuộc tội, thầy tế lễ sẽ làm lễ chuộc tội cho người ấy. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Nhưng nếu người ấy không đủ sức dâng lên Chúa Hằng Hữu một con chiên, thì có thể dâng một cặp chim cu đất hay bồ câu con; một con làm tế lễ chuộc tội, một con làm tế lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Thầy tế lễ sẽ nhận chim, dâng con thứ nhất làm lễ chuộc tội, vặn cổ chim nhưng không cho đứt lìa, ");
INSERT INTO vieovcb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","lấy một phần máu rảy trên một cạnh của bàn thờ chuộc tội, phần còn lại đổ dưới chân bàn thờ. Đó là lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Thầy tế lễ dâng con chim thứ hai làm tế lễ thiêu, theo đúng thủ tục đã ấn định. Như vậy, khi thầy tế lễ làm lễ chuộc tội cho người ấy, lỗi người sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Nếu người không đủ sức dâng một cặp bồ câu làm sinh tế chuộc tội, thì có thể dâng 2,2 lít bột mịn, nhưng không đổ dầu vào, cũng không được rắc nhũ hương lên, vì đây là một lễ vật chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Người ấy sẽ đem bột đến cho thầy tế lễ, thầy tế lễ sẽ bốc bột đầy một nắm tay, tượng trưng cho toàn số bột, đem đốt trên bàn thờ cũng như đốt các lễ thiêu khác, dâng lên Chúa Hằng Hữu. Đó là lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Khi các thầy tế lễ làm lễ chuộc tội cho người đã phạm một trong các trường hợp kể trên, lỗi người sẽ được tha. Phần bột còn lại sẽ thuộc về thầy tế lễ, giống như trường hợp dâng ngũ cốc.” ");
INSERT INTO vieovcb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Nếu có ai mắc tội vì lỡ lầm xúc phạm đến một vật thánh của Chúa Hằng Hữu, người ấy phải dâng một con chiên đực không tì vít, giá trị con chiên được định theo tiêu chuẩn tiền tệ nơi thánh. Đây là lễ chuộc lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Người ấy cũng phải sửa vật thánh lại đúng như tình trạng cũ, trả thêm một phần năm giá trị của vật thánh ấy và giao số tiền này cho thầy tế lễ. Thầy tế lễ sẽ nhận con chiên làm lễ chuộc lỗi cho người ấy; người sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Nếu có ai phạm luật Chúa Hằng Hữu đã ban hành mà không biết, thì người ấy vẫn có tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Người ấy phải đem đến cho thầy tế lễ một con chiên đực không tì vít; giá trị con chiên bằng giá định sẵn. Khi thầy tế lễ làm lễ chuộc lỗi cho người ấy, người sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Đó là lễ chuộc lỗi, vì người đã có tội với Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Nếu có ai phạm tội cùng Chúa Hằng Hữu vì gian dối trong các khoản ký thác hoặc bảo chứng của người khác, hay vì trộm cắp hoặc bức hiếp anh em láng giềng, ");
INSERT INTO vieovcb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","hay vì tìm được vật người khác đã mất nhưng chối đi, thề thốt dối trá, hoặc vì một lỗi nào mà người ta thường phạm, ");
INSERT INTO vieovcb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","thì vào ngày tội trạng được xác nhận, đương sự phải hoàn trả vật mình đã lấy, hoặc đã lừa gạt, hoặc vật được ký thác cho mình, hoặc vật người khác mất mà mình tìm được, ");
INSERT INTO vieovcb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","hay bất cứ vật gì mình đã lấy do thề dối, đồng thời phải bồi thường một số tiền bằng một phần năm giá trị của vật ấy cho sở hữu chủ. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Người có tội cũng phải đem đến cho thầy tế lễ một con chiên đực không tì vít, làm sinh tế chuộc tội dâng lên Chúa Hằng Hữu; giá trị con chiên bằng giá định sẵn. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Khi thầy tế lễ làm lễ chuộc tội với Chúa Hằng Hữu, lỗi người sẽ được tha.” ");
INSERT INTO vieovcb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Hãy cho A-rôn và các con trai người biết các thể lệ về tế lễ thiêu sau đây: Lễ vật phải được giữ giữa bàn thờ suốt đêm, lửa trên bàn thờ phải cháy luôn cho đến sáng. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Thầy tế lễ sẽ mặc áo và quần ngắn vải gai vào, lấy tro của lễ vật đã cháy tàn trên bàn thờ đem đổ bên cạnh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Xong, thầy tế lễ sẽ thay áo, đem tro ra khỏi nơi đóng trại, đến một nơi sạch sẽ. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Lửa trên bàn thờ phải cháy luôn, không được tắt. Mỗi buổi sáng, thầy tế lễ phải đốt củi trên bàn thờ, đặt của lễ thiêu trên củi, và đốt mỡ của sinh tế tạ ơn. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Lửa phải được cháy luôn trên bàn thờ, không lúc nào được tắt.” ");
INSERT INTO vieovcb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Sau đây là thể lệ dâng ngũ cốc: Các con trai A-rôn sẽ dâng ngũ cốc trên bàn thờ, trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Thầy tế lễ sẽ bốc đầy một nắm tay bột mịn của ngũ cốc đem dâng, luôn với dầu và nhũ hương đã rắc lên trên bột, đem đốt phần bột tượng trưng này trên bàn thờ, dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Phần ngũ cốc còn lại sẽ dùng làm thực phẩm cho A-rôn và các con trai người, nhưng phải ăn ở một nơi thánh và không được ăn với men; họ sẽ ăn tại sân Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Tuyệt đối không được pha men vào bột này, ngay cả khi dùng bột để nướng bánh. Ta cho họ một phần lễ vật dâng cho Ta bằng lửa, phần này rất thánh, cũng như lễ vật chuộc tội và lễ vật chuộc lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nam giới trong dòng họ A-rôn đều được phép ăn những lễ vật dâng lên Chúa Hằng Hữu này. Đây là một quy luật áp dụng qua các thế hệ. Chỉ người thánh, hiến dâng mình lên Chúa mới được đụng đến tế lễ thiêu của Ngài.” ");
INSERT INTO vieovcb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Vào ngày lễ xức dầu thánh cho A-rôn và các con trai người, họ sẽ dâng lên Chúa Hằng Hữu một lễ vật ngũ cốc, thông thường gồm 2,2 lít bột mịn, phân nửa dâng vào buổi sáng, phân nửa buổi tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Bột sẽ được pha với dầu, nướng thật kỹ trên vỉ, dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Người được xức dầu thánh trong dòng họ A-rôn để kế vị A-rôn làm thầy tế lễ sẽ dâng lễ vật như vậy lên Chúa Hằng Hữu. Đây là một quy lệ áp dụng đời đời. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Toàn thể lễ vật ngũ cốc này sẽ được thiêu đốt, không ai được ăn.” ");
INSERT INTO vieovcb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Hãy cho A-rôn và các con trai người biết các thể lệ về tế lễ chuộc tội sau đây: Phải giết con sinh tế chuộc tội trước mặt Chúa Hằng Hữu, tại nơi dùng để giết sinh tế lễ thiêu. Sinh tế này rất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Thầy tế lễ đứng hành lễ chuộc tội sẽ ăn thịt con sinh tế ấy tại sân Đền Tạm, một nơi thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chỉ người thánh được đụng đến thịt sinh tế. Nếu máu sinh tế vấy vào áo thầy tế lễ, thì áo phải được giặt tại một Nơi Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Nếu đã dùng chậu đất để ngâm áo, thì phải đập vỡ chậu. Nếu dùng thùng đồng, thì phải chùi thùng và rửa cho sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Nam giới trong nhà các thầy tế lễ đều được phép ăn thịt sinh tế rất thánh này. ");
INSERT INTO vieovcb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Nhưng nếu máu của sinh tế chuộc tội được đem vào Đền Tạm để làm lễ chuộc tội trong Nơi Thánh, thì sinh tế này phải được thiêu rụi bằng lửa, không được ăn.” ");
INSERT INTO vieovcb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Đây là thể lệ về tế lễ chuộc lỗi: ");
INSERT INTO vieovcb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Phải giết con sinh tế chuộc lỗi tại nơi dùng để giết sinh tế lễ thiêu. Sinh tế này rất thánh. Máu nó được rảy khắp trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Phải dâng tất cả mỡ, gồm cả mỡ đuôi và mỡ bọc bộ lòng, ");
INSERT INTO vieovcb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","hai trái thận với mỡ của nó dính nơi sườn và túi mật. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Thầy tế lễ sẽ đốt tất cả trên bàn thờ, dùng lửa dâng lên Chúa Hằng Hữu. Đó là lễ chuộc lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nam giới trong nhà các thầy tế lễ được phép ăn thịt sinh tế rất thánh này tại một nơi chí thánh, vì đó là một lễ vật rất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Thủ tục áp dụng cho lễ chuộc tội cũng áp dụng cho lễ chuộc lỗi. Thịt sinh tế sẽ thuộc về thầy tế lễ đứng hành lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Khi dâng tế lễ thiêu, thầy tế lễ đứng hành lễ sẽ được thêm bộ da của con sinh tế. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Các lễ vật ngũ cốc được nướng trong lò, trên vỉ hay rán trong chảo sẽ thuộc về thầy tế lễ đứng dâng. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Còn mọi lễ vật ngũ cốc khác, dù có pha dầu hay không, sẽ dùng làm thực phẩm chung cho các con trai A-rôn.” ");
INSERT INTO vieovcb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Đây là thủ tục lễ tạ ơn Chúa Hằng Hữu: ");
INSERT INTO vieovcb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Nếu một người dâng sinh tế để tỏ lòng biết ơn, phải dâng lễ vật ấy cùng với bánh không men pha dầu, bánh kẹp không men tẩm dầu và bánh bột mịn pha dầu. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Cùng với lễ tạ ơn, người ấy cũng sẽ dâng bánh pha men nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Một phần các bánh này sẽ được thầy tế lễ nâng tay dâng lên Chúa Hằng Hữu. Sau đó, phần này thuộc về thầy tế lễ đứng rảy máu của con sinh tế tạ ơn. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Thịt của con sinh tế tạ ơn dâng lên để tỏ lòng biết ơn Chúa phải được ăn nội trong ngày, không được để dành qua hôm sau. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Nhưng đối với lễ vật dâng tự nguyện hoặc dâng trong lúc thề nguyện, nếu không ăn hết trong ngày, có thể để dành qua hôm sau. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Phần còn lại qua ngày thứ ba phải đem đốt đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ăn lễ vật tạ ơn trong ngày thứ ba là một việc đáng tởm, người ăn phải mang tội, người dâng lễ vật bị kể như không dâng, vì lễ vật đó không được Chúa Hằng Hữu chấp nhận. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Không được ăn thịt đã đụng phải một vật không sạch. Thịt đó phải đem đốt đi. Đối với thịt ăn được, chỉ người tinh sạch mới được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Người nào ăn thịt của sinh tế tạ ơn dâng lên Chúa Hằng Hữu trong lúc mình không tinh sạch phải bị trục xuất khỏi cộng đồng dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Nếu ai đã đụng phải một vật không sạch của loài người, loài thú hay loài sâu bọ, sau đó lại ăn thịt của sinh tế tạ ơn dâng lên Chúa Hằng Hữu, thì người ấy phải bị trục xuất khỏi cộng đồng dân chúng.” ");
INSERT INTO vieovcb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Hãy dạy người Ít-ra-ên không được ăn mỡ, dù là mỡ bò, mỡ chiên, hay mỡ dê. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Đối với mỡ của thú vật chết tự nhiên và thú vật bị thú dữ cắn xé, người ta có thể đem dùng vào những việc khác, chứ không được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Người nào ăn mỡ của một loài thú người ta dùng làm sinh tế dâng lên Chúa Hằng Hữu bằng lửa, sẽ bị trục xuất khỏi cộng đồng dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Dù sống ở đâu, cũng không ai được ăn máu, dù máu chim hay máu thú. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ai ăn máu sẽ bị trục xuất khỏi cộng đồng dân chúng.” ");
INSERT INTO vieovcb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Hãy cho dân chúng hay rằng nếu có ai dâng lễ vật tạ ơn lên Chúa Hằng Hữu thì phải đem một phần lễ vật đó đến cho Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Người dâng lễ vật tạ ơn lên Chúa Hằng Hữu phải chính tay đem mỡ và cái ức của con sinh tế đến. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Thầy tế lễ sẽ dùng lửa đốt mỡ trên bàn thờ, còn cái ức sẽ được dâng theo cách đưa qua đưa lại. Sau đó cái ức sẽ thuộc về A-rôn và các con trai người. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Thầy tế lễ nào đứng ra dâng lễ vật tạ ơn—sẽ được cái đùi phải của con sinh tế, ");
INSERT INTO vieovcb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","tức là thầy tế lễ đứng ra rảy máu và dâng mỡ của lễ vật tạ ơn. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Vậy, cái ức và cái đùi của con sinh tế tạ ơn người Ít-ra-ên dâng lên Ta sẽ thuộc về A-rôn và các con trai người. Đây là một quy lệ áp dụng vĩnh viễn. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Đó là phần của A-rôn và các con trai người, là những người được xức dầu để thi hành chức vụ tế lễ phụng thờ Chúa Hằng Hữu, phần này trích ra từ lễ vật dùng lửa dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Vì đây là phần Chúa Hằng Hữu phán dạy người Ít-ra-ên dành cho họ trong ngày họ được xức dầu tấn phong, nên cũng là phần của họ mãi mãi, qua các thế hệ.” ");
INSERT INTO vieovcb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Đó là các thể lệ về lễ thiêu, lễ dâng ngũ cốc, lễ chuộc tội, lễ chuộc lỗi, lễ tấn phong, và lễ tạ ơn. ");
INSERT INTO vieovcb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Chúa Hằng Hữu đã phán dạy Môi-se các thể lệ này trên Núi Si-nai khi Ít-ra-ên còn ở trong hoang mạc Si-nai—để họ biết cách dâng lễ vật cho Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Hãy đem A-rôn và các con trai người đến trước cửa Đền Tạm, cũng mang theo các bộ áo lễ, dầu xức thánh, giỏ bánh không men, con bò đực tơ làm sinh tế chuộc tội, và hai con chiên đực. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Đồng thời hãy triệu tập toàn dân tại đó.” ");
INSERT INTO vieovcb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Môi-se vâng lời Chúa Hằng Hữu. Toàn dân tập họp tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Môi-se tuyên bố: “Những điều tôi sắp làm đây đều theo lệnh Chúa Hằng Hữu!” ");
INSERT INTO vieovcb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Môi-se lấy nước rửa cho A-rôn và các con trai người. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ông mặc áo, thắt lưng cho A-rôn, lại mặc áo dài, ê-phót với thắt lưng thêu đẹp đẽ. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Môi-se cũng đeo bảng đeo ngực vào cho A-rôn, đặt U-rim và Thu-mim vào trong bảng đeo ngực, ");
INSERT INTO vieovcb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","đội khăn lên đầu, đeo thẻ vàng trên khăn về phía trước, đó là mão miện thánh, đúng theo điều Chúa Hằng Hữu phán dạy Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Môi-se lấy dầu thánh xức cho Đền Tạm và mọi vật bên trong để thánh hóa. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ông rảy dầu bảy lần trên bàn thờ, ông cũng rảy dầu trên các dụng cụ của bàn thờ, bồn nước, và chân bồn để thánh hóa và hiến dâng các vật này. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Môi-se đổ dầu thánh trên đầu A-rôn, như vậy A-rôn hiến thân phục vụ Chúa. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Môi-se cũng mặc áo dài cho các con trai A-rôn, thắt lưng, đội khăn cho họ như Chúa Hằng Hữu đã phán bảo ông. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Rồi ông dắt con bò tơ đực dùng làm sinh tế chuộc tội đến, A-rôn và các con trai người đặt tay trên đầu nó. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Môi-se giết con bò, dùng ngón tay bôi máu nó trên các sừng bàn thờ để thánh hóa bàn thờ. Máu còn lại ông đem đổ dưới chân bàn thờ. Vậy, ông làm lễ chuộc tội và thánh hóa bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ông Môi-se lấy tất cả mỡ bọc bộ lòng, túi mật, hai trái thận, và mỡ bao quanh thận đem đốt trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Phần còn lại của con bò gồm da, thịt, phân được ông đem ra khỏi nơi đóng trại đốt đi, như Chúa Hằng Hữu đã phán bảo Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Sau đó, Môi-se dắt con chiên dùng làm sinh tế lễ thiêu đến. A-rôn và các con trai người đặt tay trên đầu nó. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Môi-se giết con chiên này, lấy máu rảy bốn cạnh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ông chặt con chiên ra từng miếng, rồi thiêu cái đầu và mỡ của nó chung với các miếng thịt này. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Môi-se đem bộ lòng và chân chiên rửa sạch, đem thiêu trên bàn thờ. Như vậy, cả con chiên được thiêu trên bàn thờ. Đó là tế lễ thiêu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu, đúng theo điều Chúa Hằng Hữu đã phán bảo ông. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Môi-se dắt con chiên dùng làm sinh tế tấn phong đến. A-rôn và các con trai người đặt tay trên đầu nó. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Môi-se giết chiên, lấy máu bôi trên trái tai bên phải, ngón cái tay phải và ngón cái chân phải của A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Môi-se cũng bôi máu trên trái tai bên phải, trên ngón cái tay phải và ngón cái chân phải của các con trai A-rôn. Máu còn lại, ông đem rảy khắp bốn cạnh bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Môi-se lấy mỡ chiên, gồm mỡ đuôi, mỡ bọc bộ lòng, với túi mật, hai trái thận và mỡ bao quanh thận, cái đùi phải của con chiên. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ông cũng lấy từ trong giỏ đựng bánh ở trước mặt Chúa Hằng Hữu một ổ bánh không men, một ổ bánh có pha dầu và một bánh kẹp, đem để các bánh này bên trên mỡ và cái đùi phải của con chiên. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ông đặt tất cả các món trên trong tay A-rôn và các con trai người để họ dâng lên Chúa Hằng Hữu theo cách đưa qua đưa lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Xong, họ trao các món ấy lại cho Môi-se, để ông đem đốt trên bàn thờ chung với sinh tế lễ thiêu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Môi-se lấy cái ức con chiên dâng lên Chúa Hằng Hữu theo cách đưa qua đưa lại. Cái ức chiên dâng làm lễ tấn phong sẽ thuộc về Môi-se, như Chúa Hằng Hữu đã phán bảo ông. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Bấy giờ, Môi-se lấy dầu xức thánh và một ít máu trên bàn thờ đem rảy trên A-rôn và trên áo ông, cũng rảy trên các con trai A-rôn và trên áo họ. Như vậy A-rôn, các con trai người và các bộ áo lễ được thánh hóa. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Môi-se nói với A-rôn và các con trai người: “Nấu thịt tại cửa Đền Tạm để ăn với bánh ở trong giỏ dùng trong lễ tấn phong, như tôi đã dặn trước. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Thịt và bánh còn thừa phải đem đốt đi.” ");
INSERT INTO vieovcb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ông cũng dặn họ không được ra khỏi cửa Lều Hội Kiến suốt trong bảy ngày, cho đến ngày kỳ lễ tấn phong kết thúc, vì lễ này kéo dài bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ông cho họ biết, tất cả việc ông làm hôm nay đều do Chúa Hằng Hữu truyền dạy để chuộc tội cho họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Vậy họ phải túc trực đêm ngày tại cửa Đền Tạm trong bảy ngày như lời Chúa Hằng Hữu phán dạy, nếu không họ sẽ chết. ");
INSERT INTO vieovcb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","A-rôn và các con trai người vâng theo mọi lời Chúa Hằng Hữu đã phán bảo Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Tám ngày sau lễ tấn phong, Môi-se triệu tập A-rôn, các con trai A-rôn, cùng các vị trưởng lão của Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ông nói với A-rôn: “Anh hãy dâng lên Chúa Hằng Hữu một con bò con đực làm tế lễ chuộc tội, một con chiên đực làm tế lễ thiêu; cả hai con đều phải hoàn toàn, không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Anh cũng bảo người Ít-ra-ên dâng một con dê đực làm tế lễ chuộc tội; một con bò và một con chiên mỗi con một tuổi, không tì vít làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","một con bò và một con chiên đực làm tế lễ tạ ơn, và bột có pha dầu. Tất cả hãy dâng lên Chúa Hằng Hữu, vì hôm nay Ngài sẽ hiện ra với Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Theo lời Môi-se bảo, họ đem đến cửa Đền Tạm tất cả lễ vật trên. Toàn dân đều đến, đứng ra mắt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Môi-se nói với họ: “Đây là những điều Chúa Hằng Hữu phán bảo anh chị em làm, để vinh quang Ngài bày tỏ cho anh chị em.” ");
INSERT INTO vieovcb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Rồi Môi-se bảo A-rôn đến gần bàn thờ, dâng sinh tế chuộc tội và sinh tế thiêu để chuộc tội cho chính mình; rồi dâng sinh tế để chuộc tội lên Chúa Hằng Hữu cho dân, như lời Chúa dạy. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Vậy A-rôn đến gần bàn thờ, giết con bò con làm sinh tế chuộc tội cho mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Sau khi các con A-rôn lấy máu bò, A-rôn nhúng ngón tay trong máu bôi lên các sừng bàn thờ, rồi đổ phần còn lại dưới chân bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A-rôn đốt mỡ, than, và túi mật của con sinh tế chuộc tội trên bàn thờ, như Chúa Hằng Hữu phán dạy Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Còn thịt và da, ông đem ra khỏi nơi đóng trại và đốt đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","A-rôn giết con sinh tế lễ thiêu. Các con ông hứng lấy máu đem đến cho ông rảy khắp trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Các con A-rôn cũng chặt thịt ra từng miếng đem cho ông, cùng với cái đầu. A-rôn thiêu tất cả trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A-rôn lấy bộ lòng và chân con sinh tế rửa sạch, rồi cũng đem đốt trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Đến phần lễ vật của dân chúng, A-rôn bắt con dê đực giết đi, dâng lên làm lễ chuộc tội, cũng theo phương cách như trên. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ông lại dâng lễ thiêu của dân, đúng theo điều Chúa đã dạy. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","A-rôn cũng dâng ngũ cốc, bốc đầy nắm tay, đem đốt trên bàn thờ. Lễ này khác với lễ thiêu dâng vào mỗi buổi sáng. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Sau đó, A-rôn giết con bò và con chiên; đây là lễ vật tạ ơn của dân chúng. Các con ông hứng lấy máu để ông đem rảy khắp trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Họ cũng lấy mỡ của con bò và con chiên, gồm mỡ đuôi, mỡ bọc bộ lòng, cùng hai trái thận, và túi mật, ");
INSERT INTO vieovcb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","để mỡ lên trên ức của hai con sinh tế. A-rôn đốt mỡ trên bàn thờ, ");
INSERT INTO vieovcb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","còn hai cái ức và đùi được A-rôn dâng theo cách đưa qua đưa lại trước mặt Chúa Hằng Hữu, theo lời Môi-se dặn. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Sau khi đã dâng tế lễ chuộc tội, tế lễ thiêu, và tế lễ tạ ơn, A-rôn đưa tay về phía dân chúng, chúc phước cho họ, rồi ông đi xuống. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","A-rôn theo Môi-se vào Đền Tạm. Khi trở ra, hai ông liền chúc phước cho dân chúng lần nữa. Lúc ấy vinh quang của Chúa Hằng Hữu bày tỏ trước sự chiêm ngưỡng của toàn dân. ");
INSERT INTO vieovcb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Lửa lóe ra từ trước mặt Chúa Hằng Hữu, thiêu hóa sinh tế lễ thiêu và mỡ trên bàn thờ. Thấy thế, toàn dân reo mừng và cung kính sấp mình thờ lạy. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Na-đáp và A-bi-hu, hai con trai A-rôn, lấy lửa bỏ vào bình hương của mình, rồi bỏ hương lên trên, dâng một thứ lửa lạ trước mặt Chúa Hằng Hữu, trái với điều Ngài dặn bảo. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Lửa phát ra từ trước mặt Chúa Hằng Hữu thiêu họ chết ngay. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Môi-se nói với A-rôn: “Việc này xảy ra đúng theo lời Chúa Hằng Hữu đã phán: ‘Ta sẽ bày tỏ đức thánh khiết với những ai đến gần bên Ta. Và trước mặt toàn dân, Ta sẽ được tôn vinh.’” A-rôn yên lặng. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Môi-se gọi hai con trai của U-xi-ên (chú của A-rôn) là Mi-sa-ên và Ên-sa-phan đến. Ông nói với họ: “Hai em lấy xác họ khỏi nơi thánh, đem khỏi trại dùm anh.” ");
INSERT INTO vieovcb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Họ khiêng xác hai người còn mặc áo lễ ra khỏi nơi đóng trại như Môi-se đã bảo. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Môi-se nói với A-rôn và hai con trai còn lại của A-rôn là Ê-lê-a-sa và Y-tha-ma: “Đừng xõa tóc, đừng xé áo khóc than; nếu không nghe tôi, anh và hai cháu sẽ chết, và cơn giận của Chúa Hằng Hữu sẽ nổi lên cùng đoàn dân. Nhưng toàn dân Ít-ra-ên nên khóc than cái chết của Na-đáp và A-bi-hu vừa bị Chúa Hằng Hữu thiêu cháy. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Anh và hai cháu cũng nhớ đừng ra khỏi cửa Đền Tạm, nếu ai ra sẽ chết, vì dầu thánh của Chúa Hằng Hữu đã xức trên anh và hai cháu.” Họ vâng lời Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Chúa Hằng Hữu phán bảo A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Không được uống rượu nho hay rượu mạnh trước khi vào Đền Tạm. Nếu bất tuân ngươi sẽ chết. Lệnh này cũng áp dụng cho con cháu ngươi mãi mãi, ");
INSERT INTO vieovcb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","vì ngươi phải phân biệt giữa thánh và phàm, giữa thuần khiết và ô uế ");
INSERT INTO vieovcb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","và phải dạy người Ít-ra-ên các luật lệ Chúa Hằng Hữu phán bảo Môi-se ban bố cho họ.” ");
INSERT INTO vieovcb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Môi-se lại nói với A-rôn và hai con trai còn lại là Ê-lê-a-sa và Y-tha-ma: “Lấy phần ngũ cốc còn lại sau khi đã đốt đặt trên bàn thờ dâng lên Chúa Hằng Hữu, ăn bên cạnh bàn thờ. Không được pha men vào thức ăn này. Vì lễ vật ngũ cốc này đã trở nên rất thánh, ");
INSERT INTO vieovcb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","nên phải được ăn tại một nơi thánh. Đó là phần của anh và con anh, trích ra từ lễ vật dâng lên Chúa Hằng Hữu bằng lửa. Đây là những điều luật Ngài đã dạy tôi. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Nhưng còn cái ức và cái đùi của con sinh tế đã được dâng lên theo cách đưa qua đưa lại có thể ăn tại bất kỳ một nơi sạch sẽ nào. Đó là thực phẩm chung của anh, con trai và con gái anh; là phần của anh và các con trai anh trích ra từ lễ vật tạ ơn do người Ít-ra-ên dâng hiến. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Người dâng sẽ đem cái đùi và cái ức đến để dâng đưa qua đưa lại, cùng với mỡ để đốt trên bàn thờ. Sau khi đã dâng lên Chúa Hằng Hữu theo cách đưa qua đưa lại, cái đùi và cái ức sẽ thuộc về anh và các con anh. Thể thức này áp dụng mãi mãi, như Chúa Hằng Hữu đã dạy.” ");
INSERT INTO vieovcb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Môi-se tìm mãi mới thấy con dê dùng làm sinh tế chuộc tội, nó đã cháy ra than. Ông giận lắm, gọi Ê-lê-a-sa và Y-tha-ma—hai con trai còn lại của A-rôn—hỏi: ");
INSERT INTO vieovcb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Sao hai cháu không ăn thịt sinh tế chuộc tội trong nơi thánh? Đó là một vật rất thánh Chúa Hằng Hữu đã cho hai cháu, vì đã hành lễ chuộc tội cho dân chúng trước mặt Ngài, để xóa tội lỗi họ đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Này, máu con sinh tế đã không được đem vào trong Nơi Thánh; đáng lẽ hai cháu phải ăn thịt nó trong nơi thánh sạch, theo lời đã dặn.” ");
INSERT INTO vieovcb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Nhưng A-rôn đáp lời Môi-se: “Hôm nay họ đem sinh tế chuộc tội và sinh tế thiêu đến hiến dâng lên Chúa Hằng Hữu, đồng thời các việc kia cũng xảy đến cho tôi. Như vậy, không biết Chúa Hằng Hữu có vui lòng nếu tôi ăn sinh tế chuộc tội ngày hôm nay không.” ");
INSERT INTO vieovcb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Nghe điều này, Môi-se đồng ý. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Chúa Hằng Hữu phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Hãy dạy cho người Ít-ra-ên biết họ được phép ăn các loại sinh vật sống trên đất. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Các ngươi được ăn thịt con vật nào có móng chẻ đôi và nhai lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nhưng có một số loài chỉ nhai lại hoặc chỉ có móng rời nhau, thì không được ăn. Con lạc đà dù nhai lại nhưng không có móng rời, nên là loài vật không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Con chồn sống trên đá, dù nhai lại, nhưng không có móng rời, nên là loài không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Con thỏ rừng, dù nhai lại, nhưng không có móng rời nhau, cũng không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Con heo tuy có chân chẻ hai nhưng không nhai lại, cũng không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Không được ăn thịt các loài kể trên, cũng không được đụng đến xác chết của các loài ấy, vì đó là những loài không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Đối với những sinh vật sống trong nước, dù nước biển hay nước sông, hễ loài nào có vây, có vảy thì ăn được. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Nhưng nếu không vây, không vảy thì không được ăn, dù sống theo đàn hay giữa các loài khác dưới nước. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Không những không được ăn các sinh vật này lúc còn sống, nhưng cũng không ai được đụng đến xác chết các loài ấy. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Vì tất cả các sinh vật sống trong nước không vây, không vảy là những loài không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Đối với loài chim, không được ăn phượng hoàng, kên kên, ó biển, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","diều hâu, các loại chim ưng, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","các loại quạ, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","đà điểu, ó đêm, hải âu, các loại chim ưng, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","cú mèo, còng cọc, cò lửa, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","chim hạc, bồ nông, kên kên, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","các loại cò, các loại chim diệc, chim rẽ quạt, và dơi. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tất cả loài bọ có cánh và có chân đều không sạch cho các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Trong các loại bọ có cánh và nhân, các ngươi có thể ăn những con nào chân có khóp để nhảy được, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","gồm châu chấu, châu chấu nhẵn đầu, các loài dế, và cào cào. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Còn các loài bọ có cánh và bốn chân khác đều không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ai đụng đến xác chết của các loài đó đều bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ai nhặt xác các loài này phải giặt áo mình, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Loài vật nào có móng rời nhau nhưng bàn chân không chẻ hai hoặc không nhai lại là loài không sạch. Ai đụng đến xác chết các loài này phải bị ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Loài vật đi bốn chân, có vuốt là loài không sạch. Ai đụng đến xác chết các loài này phải bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ai nhặt xác các loài đó phải giặt áo mình và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Trong các sinh vật bò trên đất, những giống sau đây không sạch: Chuột chũi, chuột nhắt, rắn mối, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","cắc ké, kỳ đà, thằn lằn, kỳ nhông, và tắc kè. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ai đụng đến xác chết của các giống trên đều bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Vật gì bị xác của các giống ấy rơi trúng đều bị ô uế, dù là đồ gỗ, quần áo đồ da hay một cái bao. Phải đem vật ấy rửa, giặt đi, và vật ấy bị ô uế cho đến tối. Sau đó có thể dùng vật được thanh sạch ấy được. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Nếu xác rơi trúng một bình đất, thì đồ dùng trong bình bị ô uế, phải đập bể bình đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nếu nước trong bình ấy rơi vào thức ăn, thì thức ăn bị ô uế. Thức uống đựng trong bình cũng bị ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Nếu xác rơi trúng bếp hoặc nồi niêu, thì vật ấy bị ô uế, và phải đập bể đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nếu một suối nước, một hồ chứa nước sạch bị xác các giống ấy rơi vào, thì sẽ bị ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Nếu xác rơi trúng hạt giống chưa gieo ngoài đồng, thì hạt giống vẫn sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Nhưng nếu hạt giống ngoài đồng đã được tưới nước và bị xác rơi lên, thì hạt giống bị ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Nếu ai đụng đến xác chết một sinh vật thuộc loại ăn được, cũng bị ô uế đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ai ăn xác chết đó, cũng như người nhặt xác, phải giặt quần áo, và bị ô uế đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Mọi loài sâu bọ bò trên đất đều đáng kinh tởm, không được ăn, ");
INSERT INTO vieovcb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","dù bò bằng bụng, bằng bốn chân hay bằng nhiều chân, đều là những vật ô uế, nên không được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Đừng làm cho mình đáng kinh tởm vì đụng chúng. Đừng để các loài đó làm ô uế mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. Phải giữ mình thánh sạch, vì Ta là Thánh. Đừng để các loài sâu bọ trên đất làm ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Vì Ta là Chúa Hằng Hữu, đã đem các ngươi ra khỏi Ai Cập để làm Đức Chúa Trời của các ngươi. Phải giữ mình thánh sạch, vì Ta là Thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Đó là luật liên hệ đến các sinh vật sống trên đất, chim bay trên trời, sống dưới nước, và loài sâu bọ. ");
INSERT INTO vieovcb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Luật này phân biệt giữa sinh vật sạch và không sạch, giữa loài ăn được và loài không ăn được.” ");
INSERT INTO vieovcb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Hãy dạy cho người Ít-ra-ên biết rằng khi một người đàn bà sinh con trai, người ấy bị ô uế trong bảy ngày, như lúc có kinh. ");
INSERT INTO vieovcb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Đến ngày thứ tám, phải làm lễ cắt bì cho đứa bé trai. ");
INSERT INTO vieovcb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Trong thời gian ba mươi ba ngày sau đó, người ấy không được đụng đến một vật thánh, cũng không được vào nơi thánh, vì đây là thời gian để bà được sạch kinh. ");
INSERT INTO vieovcb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Trường hợp sinh con gái, bà bị ô uế trong hai tuần lễ, như lúc có kinh, và thời gian để sạch kinh là sáu mươi sáu ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Khi thời gian sạch kinh chấm dứt, dù đã sinh con trai hay con gái, người ấy phải đem đến cho thầy tế lễ tại cửa Đền Tạm một con chiên một tuổi để làm lễ thiêu, và một con bồ câu hoặc chim cu con để làm lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Thầy tế lễ sẽ đem dâng lên Chúa Hằng Hữu để chuộc tội cho người, và người trở nên tinh sạch sau lúc sinh sản. Đó là luật liên hệ đến trường hợp sinh con trai hay gái. ");
INSERT INTO vieovcb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Nếu những người phụ nữ không đủ sức dâng một con chiên thì phải dâng hai chim cu hoặc hai bồ câu con, con này làm lễ thiêu, con kia làm lễ chuộc tội. Thầy tế lễ sẽ chuộc tội cho người, và người sẽ được tinh sạch.” ");
INSERT INTO vieovcb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Chúa Hằng Hữu phán với Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Nếu người nào thấy trên da mình có chỗ sưng lên, hoặc nổi mụt nhọt, hoặc nổi đốm trắng, thì người ấy phải đến trình với Thầy Tế lễ A-rôn hoặc một thầy tế lễ con của A-rôn, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","để vị này khám xem người ấy có mắc bệnh phong hủi không. Nếu lông mọc trên chỗ ấy hóa trắng, và nếu chỗ ấy lõm xuống sâu hơn mặt da, đó là bệnh phong hủi. Thầy tế lễ phải tuyên bố người ấy không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Nhưng nếu đốm trắng trên da người ấy không lõm sâu xuống so với mặt da, và lông không hóa trắng, thầy tế lễ sẽ cho người này ở cách ly trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sau bảy ngày, thầy tế lễ sẽ khám lại. Nếu thấy vết thương không thay đổi, không lan ra trên da, người ấy sẽ phải ở cách ly trong bảy ngày nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Bảy ngày sau, thầy tế lễ lại khám người ấy một lần nữa. Nếu vết thương tái đi, không lan ra trên da, thầy tế lễ sẽ tuyên bố người ấy sạch. Vết thương chỉ là một mụt nhọt thường, người ấy chỉ cần giặt quần áo là được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Nhưng nếu mụt nhọt ấy bắt đầu lan ra trên da sau khi đã được khám, người ấy phải đến gặp thầy tế lễ một lần nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Thầy tế lễ khám lại, nếu thấy mụt nhọt đã lan ra trên da, sẽ tuyên bố người ấy không sạch, vì mắc bệnh phong hủi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Một người bị bệnh phong hủi phải được đem đến thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Thầy tế lễ sẽ khám, nếu thấy trên da có chỗ sưng lên, màu trắng, lông hóa trắng, và có thịt rữa tại chỗ sưng ");
INSERT INTO vieovcb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","thì bệnh phong hủi đã phát lâu ngày, và thầy tế lễ phải tuyên bố người ấy không sạch. Không cần giữ người ấy riêng ra nữa, vì người ấy rõ ràng đã mang bệnh và không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Nhưng nếu sau khi khám khắp người, thấy chứng bệnh lan trên da, tràn khắp cơ thể từ đầu đến chân, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","thì thầy tế lễ sẽ tuyên bố người ấy sạch, vì cả cơ thể đã trắng hết, người ấy khỏi bệnh. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Nhưng bất cứ khi nào thịt rữa xuất hiện trên thân thể, thì người ấy không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Nếu thầy tế lễ thấy như vậy, thì phải tuyên bố người ấy không sạch, vì đã mắc bệnh phong hủi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Nhưng nếu thịt rữa trở nên tái và hóa trắng, thì người này phải đến gặp thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Thầy tế lễ khám, nếu thấy vết lở đã hóa màu trắng thật, thì sẽ tuyên bố người ấy sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Nếu một người bị mụt nhọt và khỏi rồi, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nhưng tại nơi vừa có mụt nhọt lại nổi lên một đốm trắng hay một đốm đỏ tái, thì người này phải đem trình cho thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Thầy tế lễ sẽ khám, nếu thấy nơi ấy lõm xuống sâu hơn mặt da và nếu lông hóa trắng, thì thầy tế lễ sẽ tuyên bố người ấy không sạch, vì đó là bệnh phong hủi phát ra từ mụt nhọt. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Nhưng nếu thấy lông không hóa trắng, vết không lõm sâu hơn mặt da và có màu tái, thì thầy tế lễ sẽ cho người ấy ở cách ly trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Sau đó, nếu thấy vết ấy lan ra trên da, thì thầy tế lễ sẽ tuyên bố người ấy không sạch, vì mắc bệnh phong hủi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Nhưng nếu vết không lan ra, thì thầy tế lễ sẽ tuyên bố người ấy sạch, vì đó chỉ là vết sẹo của mụt nhọt. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Nếu một người bị bỏng và vết bỏng trở thành một đốm trắng hay một đốm đỏ tái, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","thì thầy tế lễ sẽ khám. Nếu thấy lông mọc trên vết bỏng hóa trắng và vết ấy lõm xuống sâu hơn mặt da, thì đó là bệnh phong hủi phát ra từ vết bỏng. Thầy tế lễ sẽ tuyên bố người ấy không sạch, vì mắc bệnh phong hủi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Nhưng nếu thấy lông mọc trên vết bỏng không hóa trắng, vết không lõm sâu hơn mặt da nhưng có màu tái, thì thầy tế lễ sẽ cho người ấy ở cách ly trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sau bảy ngày, thầy tế lễ khám lại, nếu thấy vết ấy lan ra trên da, thì sẽ tuyên bố người ấy không sạch, vì mắc bệnh phong hủi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Nhưng nếu vết ấy không lan ra trên da mà có màu tái, thì thầy tế lễ sẽ tuyên bố người ấy sạch, vì đó chỉ là sẹo của vết bỏng. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Nếu một người đàn ông hay đàn bà có ung nhọt trên đầu hoặc trên cằm, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","thì thầy tế lễ sẽ khám người ấy. Nếu thấy ung nhọt lõm sâu hơn mặt da, lông mọc tại đó thưa và có màu vàng, thì thầy tế lễ sẽ tuyên bố người ấy không sạch, vì phong hủi xuất hiện trên đầu hay trên cằm. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Nhưng nếu nơi ấy không lõm sâu hơn mặt da và có lông đen mọc tại đó, thì thầy tế lễ sẽ cho người ấy ở cách ly trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ngày thứ bảy, nếu thầy tế lễ khám thấy ung nhọt không lan ra, không có lông vàng, và nơi ấy không lõm sâu hơn mặt da, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","thì người ấy phải cạo lông, tóc chung quanh ung nhọt, nhưng không đụng đến ung nhọt. Thầy tế lễ sẽ cho người ấy ở cách ly bảy ngày nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sau bảy ngày, thầy tế lễ khám lại, nếu thấy ung nhọt không lan ra trên da, không lõm sâu hơn mặt da, thì sẽ tuyên bố người ấy sạch. Người ấy chỉ cần giặt quần áo mình là được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Nhưng sau đó, nếu ung nhọt lại lan ra trên da, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","thì thầy tế lễ sẽ khám lại. Nếu thấy ung nhọt đã lan ra thật, thì dù có lông vàng hay không, người ấy không sạch vì bị bệnh phong hủi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Nhưng nếu thầy tế lễ thấy ung nhọt không lan ra, lông đen mọc lên tại nơi ấy, thì sẽ tuyên bố người ấy sạch, vì đã khỏi bệnh. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Nếu một người đàn ông hay đàn bà nổi đốm trắng trên da, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","thì thầy tế lễ sẽ khám. Nếu thấy đốm trắng đục mờ, thì người ấy sạch, vì đó chỉ là sự nhiễm độc thông thường của da. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Nếu một người bị rụng tóc, đầu hói, thì người ấy sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Nếu một người bị tóc rụng trước trán, trán hói, thì người ấy sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Nhưng nếu tại chỗ hói phát ra một đốm trắng hồng, thì trường hợp này có thể là phong hủi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Thầy tế lễ phải khám, nếu thấy có đốm trắng hồng nổi trên chỗ hói, giống như phong hủi trên da thân thể, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","thầy tế lễ sẽ tuyên bố người ấy không sạch, vì mắc bệnh phong hủi trên đầu. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Người mắc bệnh phong hủi sẽ mặc áo rách, buông tóc xõa, che phần dưới của mặt lại, kêu lên: ‘Không sạch, không sạch.’ ");
INSERT INTO vieovcb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Suốt thời gian mắc bệnh, người ấy không sạch, và phải ở bên ngoài, cách khỏi nơi đóng trại.” ");
INSERT INTO vieovcb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Nếu có mốc xanh hay mốc đỏ xuất hiện trên quần áo bằng len hay bằng vải, ");
INSERT INTO vieovcb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","dù trên sợi ngang hay sợi dọc của vải hoặc len, dù trên tấm da hay trên bất cứ đồ bằng da nào. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Nếu vết mốc có màu đỏ, thì đó là chứng phong hủi của đồ vật, phải mang đến trình cho thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Thầy tế lễ sẽ khám và cho giữ đồ vật riêng ra trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ngày thứ bảy, nếu thầy tế lễ khám thấy vết mốc lan ra, thì đó là chứng phong hủi ăn lan trên đồ vật, và đồ vật ấy không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Dù mốc trên sợi ngang hay sợi dọc của đồ len hay vải, hay mốc trên đồ bằng da, thầy tế lễ sẽ đem đồ ấy đốt đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Nhưng nếu thầy tế lễ khám thấy vết mốc không lan ra (dù trên sợi ngang, sợi dọc hay trên đồ bằng da), ");
INSERT INTO vieovcb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","thì sẽ cho đem đồ vật ấy đi giặt, và giữ đồ vật riêng ra trong bảy ngày nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sau đó, nếu thầy tế lễ khám thấy vết mốc không đổi màu, dù mốc không lan ra, dù mốc ở trên bề mặt hay bề trái của đồ vật, thì cũng phải đem đồ vật ấy đốt đi vì không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Nhưng nếu khám thấy màu vết mốc phai đi sau khi giặt, thì thầy tế lễ sẽ xé bỏ phần bị mốc đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Sau đó, nếu mốc lại xuất hiện, thì lần này phải đem đồ vật ấy đốt đi, vì đó là chứng phong hủi ăn lan trên đồ vật. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Nhưng nếu sau khi đã giặt đồ vật, vết mốc biến đi, thì chỉ cần đem giặt một lần nữa, đồ vật ấy sẽ sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Đó là luật về chứng phong hủi xuất hiện trên quần áo bằng len, vải, trên da, hay đồ bằng da. Luật này dùng để phân biệt giữa đồ vật sạch và không sạch.” ");
INSERT INTO vieovcb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Khi một người phong hủi khỏi bệnh, phải làm các việc sau: ");
INSERT INTO vieovcb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Thầy tế lễ sẽ ra khỏi nơi đóng trại để khám người bệnh. Nếu thấy phong hủi biến hết, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","thầy tế lễ sẽ bảo đem đến hai con chim còn sống thuộc loại ăn thịt được, gỗ bá hương, chỉ sợi màu đỏ và cây bài hương thảo. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Thầy tế lễ sẽ cho giết một con chim trong chậu bằng đất, trên dòng nước chảy. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Sau đó, lấy con chim còn sống cùng với gỗ bá hương, chỉ sợi màu đỏ, cây bài hương thảo, đem nhúng tất cả vào trong máu của con chim vừa giết trên dòng nước, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","rảy máu trên mình người phong hủi mới khỏi bảy lần để tẩy sạch. Thầy tế lễ sẽ tuyên bố người này sạch, rồi thả con chim còn sống bay ra ngoài đồng. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Người được tẩy sạch sẽ giặt quần áo mình, cạo sạch râu tóc, tắm và được sạch. Sau đó, người này được vào nơi đóng trại, nhưng phải ở bên ngoài lều mình bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sau bảy ngày, người ấy lại cạo tóc, râu, lông mày, giặt quần áo, tắm và được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Ngày thứ tám, người ấy sẽ đem đến cho thầy tế lễ hai con chiên đực không tì vít, một chiên cái một tuổi không tì vít, 6,6 lít bột mịn pha dầu và một chén dầu ô-liu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Thầy tế lễ làm lễ tẩy sạch sẽ xếp các lễ vật cạnh bên người ấy trước mặt Chúa Hằng Hữu, tại cửa Đền Tạm, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","rồi bắt một con chiên đực cùng với nửa lít dầu làm tế lễ chuộc lỗi, dâng lên Chúa Hằng Hữu theo cách đưa qua đưa lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Xong, sẽ giết con chiên tại nơi người ta giết sinh vật dùng làm sinh tế chuộc tội và sinh tế lễ thiêu, trong một nơi thánh. Lễ vật chuộc lỗi này là một vật rất thánh; như lễ vật chuộc tội, nó sẽ thuộc về thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Thầy tế lễ sẽ lấy một ít máu của sinh tế chuộc lỗi, đem bôi trên trái tai bên phải, trên ngón cái tay phải và ngón cái chân phải của người cần được tẩy sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Sau đó, thầy tế lễ đổ một ít dầu vào lòng bàn tay trái mình, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","nhúng ngón tay phải vào dầu đó, rảy bảy lần trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Thầy tế lễ đem bôi một phần dầu trong tay lên trái tai bên phải, trên ngón cái tay phải và ngón cái chân phải của người cần được tẩy sạch (tại những nơi đã bôi máu của sinh tế chuộc lỗi). ");
INSERT INTO vieovcb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Dầu còn lại trong tay, thầy tế lễ sẽ xức lên đầu của người cần được tẩy sạch. Như vậy, thầy tế lễ chuộc lỗi cho người ấy trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Sau đó, thầy tế lễ dâng sinh tế để chuộc tội cho người phong hủi cần được tẩy sạch, rồi giết sinh tế để làm lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Thầy tế lễ dâng sinh tế lễ thiêu và lễ vật ngũ cốc trên bàn thờ. Như thế, thầy tế lễ chuộc tội cho người ấy, và người sẽ được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Nhưng nếu người ấy nghèo, không đủ sức dâng như trên, người ấy có thể đem đến một con chiên đực dùng làm sinh tế chuộc lỗi dâng theo cách đưa qua đưa lại để chuộc lỗi cho mình, 2,2 lít bột mịn pha dầu, và một chén dầu ô-liu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Tùy theo khả năng, người có thể đem hai chim cu đất hay hai bồ câu con, theo khả năng mình; một con dùng làm sinh tế chuộc tội, một con làm sinh tế lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Đó là các thứ người ấy sẽ đem đến cửa Đền Tạm vào ngày thứ tám, để được thầy tế lễ làm lễ tẩy sạch trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Thầy tế lễ sẽ lấy con chiên dùng làm sinh tế chuộc lỗi và nửa lít dầu dâng lên Chúa Hằng Hữu theo cách đưa qua đưa lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Sau đó, thầy tế lễ sẽ giết con chiên làm sinh tế chuộc lỗi, lấy một ít máu bôi trên trái tai bên phải, trên ngón cái tay phải và ngón cái chân phải của người cần được tẩy sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Thầy tế lễ cũng đổ một ít dầu vào lòng bàn tay trái mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Nhúng ngón tay phải vào dầu đó, rảy bảy lần trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kế đó, thầy tế lễ sẽ bôi dầu trên trái tai bên phải, trên ngón cái tay phải và ngón cái chân phải của người cần được tẩy sạch, tại những nơi đã bôi máu của sinh tế chuộc lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Dầu còn lại trong tay, thầy tế lễ sẽ xức lên đầu của người cần được tẩy sạch. Như thế, thầy tế lễ chuộc lỗi cho người ấy trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sau đó, thầy tế lễ dâng hai chim cu hoặc hai bồ câu con, tùy khả năng của người ấy; ");
INSERT INTO vieovcb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","một con làm tế lễ chuộc tội, một con làm tế lễ thiêu, dâng cùng với bột. Như thế, thầy tế lễ chuộc tội cho người trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Đó là luật liên hệ đến trường hợp một người phong hủi khỏi bệnh, nhưng không đủ khả năng dâng các lễ vật thông thường để được tẩy sạch.” ");
INSERT INTO vieovcb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Chúa Hằng Hữu phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Khi các ngươi vào đất Ca-na-an là nơi Ta cho Ít-ra-ên chiếm hữu, nếu có nhà nào Ta làm cho hư hại vì một loại bệnh phong hủi phát trên nhà cửa. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Chủ nhà ấy phải đến báo với thầy tế lễ: ‘Tôi thấy có một loại mốc đang phát triển trong nhà tôi.’ ");
INSERT INTO vieovcb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Thầy tế lễ sẽ ra lệnh dọn dẹp đồ đạc ra khỏi nhà trước khi đến khám, như vậy để tránh trường hợp đồ đạc trong nhà phải bị tuyên bố không sạch chung với nhà. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Khi đến khám nhà, nếu thấy trên tường nhà có những đốm xanh hoặc đỏ, trũng xuống sâu hơn mặt tường, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","thầy tế lễ sẽ niêm phong cửa nhà này lại bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sau bảy ngày, thầy tế lễ lại đến, nếu thấy những đốm ấy lan ra trên tường nhà, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","thầy tế lễ sẽ ra lệnh đục bỏ các tảng đá có đốm trên tường, khuân đá ném vào một nơi không sạch bên ngoài thành. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Thầy tế lễ cũng cho người cạo sạch bên trong nhà, hồ cạo ra phải đem đổ vào một nơi không sạch bên ngoài thành; ");
INSERT INTO vieovcb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","rồi cho người đem đá khác lấp vào chỗ đã bị đục đi, và lấy hồ tô nhà lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Nhưng nếu sau khi đã đục đá, cạo và tô nhà lại rồi mà các đốm ấy lại xuất hiện, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","thì thầy tế lễ phải đến khám lại. Nếu thấy các đốm lan ra, thì đó là chứng phong hủi phát triển trên nhà cửa, nhà ấy không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Thầy tế lễ sẽ cho phá dỡ nhà ấy, đá, gỗ, và hồ đều phải đem đổ vào một nơi không sạch bên ngoài thành. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ai vào nhà này trong thời gian nhà bị niêm phong sẽ bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Còn ai nằm hoặc ăn trong nhà ấy phải giặt quần áo mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Nếu sau khi nhà được tô lại, thầy tế lễ đến khám, thấy các đốm ấy không lan ra, thì sẽ tuyên bố nhà sạch, không còn bệnh nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Để làm lễ tẩy sạch nhà, thầy tế lễ cần hai con chim nhỏ, gỗ bá hương, chỉ sợi màu đỏ và bài hương thảo. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Thầy tế lễ sẽ giết một con chim trong chậu bằng đất, trên dòng nước chảy. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Rồi lấy gỗ bá hương, cây bài hương thảo, chỉ sợi màu đỏ, và con chim còn sống đem nhúng tất cả vào trong máu của con chim vừa giết trên dòng nước, rảy máu trên nhà bảy lần. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Căn nhà sẽ được tẩy sạch theo cách như vậy. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Rồi thầy tế lễ sẽ thả con chim còn sống bay ra đồng, bên ngoài thành. Vậy, sau khi thầy tế lễ làm lễ chuộc tội, nhà sẽ được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Đó là luật về chứng phong hủi, về ung nhọt, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","về vết mốc trên quần áo hoặc trên nhà cửa, ");
INSERT INTO vieovcb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","và về chỗ sưng hay chỗ có đốm. ");
INSERT INTO vieovcb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Luật này nhằm quy định các trường hợp được coi là sạch và các trường hợp được coi là không sạch.” ");
INSERT INTO vieovcb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Chúa Hằng Hữu phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Truyền cho người Ít-ra-ên biết rằng một người đàn ông di tinh sẽ bị coi là không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Những điều sau đây áp dụng cho trường hợp một người di tinh, và cũng áp dụng cho cả lúc người ấy ngưng di tinh nữa: ");
INSERT INTO vieovcb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Giường người ấy nằm và bất kỳ vật gì người ấy ngồi lên đều không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ai đụng đến giường người ấy phải giặt quần áo mình, phải tắm, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ai ngồi trên vật gì người ấy đã ngồi lên, phải giặt quần áo mình, phải tắm, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ai đụng đến người ấy phải giặt quần áo mình, phải tắm, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Nếu người ấy nhổ trúng phải một người sạch, người này phải giặt quần áo mình, phải tắm, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Yên ngựa, yên xe người ấy ngồi lên sẽ không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Vậy, người nào đụng đến vật gì người ấy nằm hay ngồi lên sẽ bị ô uế cho đến tối. Người có bổn phận mang những đồ vật ấy đi, phải giặt quần áo mình, phải tắm, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Nếu người ấy đụng đến ai mà không rửa tay trước, thì người bị đụng phải giặt quần áo mình, phải tắm, bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Nếu người ấy đụng đến đồ dùng bằng đất, thì đồ ấy phải bị đập vỡ, nếu là đồ dùng bằng gỗ, thì phải đem rửa sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Khi chứng di tinh chấm dứt, người ấy có bảy ngày để tẩy sạch mình, phải giặt quần áo, phải tắm tại một dòng nước chảy, và được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ngày thứ tám, người ấy sẽ đem đến cho thầy tế lễ tại cửa Đền Tạm, trước mặt Chúa Hằng Hữu hai chim cu hoặc hai bồ câu con. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Thầy tế lễ sẽ dâng một con làm tế lễ chuộc tội, một con làm tế lễ thiêu. Vậy, thầy tế lễ dâng sinh tế chuộc tội cho người ấy trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Khi một người đàn ông xuất tinh, người ấy phải tắm toàn thân trong nước, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Quần áo, cùng đồ dùng bằng da bị dính phải, phải đem giặt đi và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Người đàn ông cũng như đàn bà phải tắm sau lúc giao hợp và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Một người đàn bà có kinh sẽ bị ô uế trong bảy ngày, ai đụng đến người ấy sẽ bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Bất kỳ vật gì người ấy nằm hoặc ngồi lên đều không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ai đụng đến giường người ấy nằm thì phải giặt quần áo mình, phải tắm, và bị ô uế đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ai đụng đến vật gì người ấy ngồi lên cũng vậy. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Bất kỳ là giường người ấy nằm hay vật gì người ấy ngồi lên, hễ ai đụng vào, đều bị ô uế đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Nếu một người đàn ông giao hợp với người đàn bà trong thời gian bị ô uế, sẽ bị ô uế trong bảy ngày, giường nào người đàn ông này nằm cũng sẽ ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Nếu một người đàn bà ra máu nhiều ngày ngoài thời gian có kinh, hoặc ra máu lâu quá thời kỳ có kinh thông thường, thì người ấy sẽ không sạch suốt thời gian ra máu, cũng như lúc có kinh. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Giường nào người ấy nằm, vật gì người ấy ngồi lên sẽ không sạch, cũng như lúc có kinh. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ai đụng đến các vật ấy sẽ bị ô uế, phải giặt quần áo mình, tắm rửa, và bị ô uế cho đến tối. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Bảy ngày sau khi chứng ra máu chấm dứt, người ấy sẽ được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ngày thứ tám, người ấy sẽ đem đến cho thầy tế lễ tại cửa Đền Tạm hai chim cu hoặc hai bồ câu con. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Thầy tế lễ sẽ dâng một con làm tế lễ chuộc tội, một con làm tế lễ thiêu. Vậy thầy tế lễ làm lễ chuộc tội cho người ấy trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Như vậy, các ngươi sẽ tẩy sạch người Ít-ra-ên khi họ bị ô uế, nếu không, họ phải chết, vì làm ô uế Đền Tạm của Ta ở giữa họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Đó là luật liên hệ đến đàn ông vì chứng di tinh và xuất tinh trở nên ô uế; ");
INSERT INTO vieovcb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","liên hệ đến đàn bà có kinh, hoặc ra máu, và trường hợp đàn ông giao hợp với đàn bà đang bị ô uế.” ");
INSERT INTO vieovcb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Sau cái chết của hai con trai A-rôn trước mặt Chúa Hằng Hữu, Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Hãy dặn A-rôn, anh con rằng không phải bất cứ lúc nào cũng có thể vào Nơi Chí Thánh, bên trong bức màn, trước nắp chuộc tội trên Hòm được. Nếu bất tuân sẽ chết, vì Ta hiện diện trong đám mây bên trên nắp chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Nhưng mỗi khi vào nơi thánh, A-rôn phải đem theo một con bò đực con dâng làm tế lễ chuộc tội, và một con chiên đực dâng làm tế lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","A-rôn cũng phải tắm sạch sẽ, mặc áo dài thánh và quần ngắn, thắt lưng, đội khăn, các thứ này toàn bằng vải gai. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Người Ít-ra-ên cũng phải đem cho A-rôn hai con dê đực để dâng làm tế lễ chuộc tội, một con chiên dâng làm tế lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","A-rôn phải dâng con bò đực làm tế lễ chuộc tội cho chính mình và cho nhà mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Sau đó, người sẽ đem hai con dê đực đến cửa Đền Tạm, trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Người sẽ rút thăm xem con dê nào thuộc về Chúa Hằng Hữu, con nào thuộc về A-xa-sên. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Con dê rút thăm về phần Chúa Hằng Hữu sẽ được A-rôn dâng lên Ngài để làm sinh tế chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Còn con dê rút thăm để gánh tội sẽ được A-rôn đem trình lên Chúa Hằng Hữu, còn sống, để chuộc tội. Sau đó, nó sẽ được thả vào hoang mạc, mang theo tội của dân. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Sau khi dâng con bò đực làm lễ chuộc tội cho chính mình và nhà mình, ");
INSERT INTO vieovcb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","A-rôn sẽ gắp than cháy đỏ trên bàn thờ, trước mặt Chúa Hằng Hữu, bỏ đầy lư hương, rồi bốc hương bột đầy tay, đem vào bên trong bức màn. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ở đó, A-rôn bỏ hương lên trên than đang cháy trước mặt Chúa Hằng Hữu, để khói hương xông lên phủ kín nắp chuộc tội trên Hòm Giao Ước, như vậy A-rôn mới khỏi chết. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","A-rôn sẽ lấy một ít máu bò đực, dùng ngón tay rảy lên đầu hướng về phía đông của nắp chuộc tội, rồi rảy phía trước nắp này bảy lần. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Sau đó, A-rôn giết con dê đực làm lễ chuộc tội cho dân, đem máu vào trong màn, rảy bên trên và phía trước nắp chuộc tội như đã rảy máu bò đực trước đây. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Như vậy, người làm lễ chuộc tội cho Nơi Chí Thánh đã bị tội lỗi của người Ít-ra-ên làm cho ô uế; người cũng chuộc tội cho Đền Tạm, vì đền ở ngay giữa quần chúng không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Không một ai được phép ở trong Lều Hội Kiến, trong lúc A-rôn vào Nơi Chí Thánh làm lễ chuộc tội cho mình, nhà mình và cho toàn dân Ít-ra-ên xong, cho đến khi người từ đó đi ra. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Sau đó A-rôn sẽ ra đến bàn thờ trước mặt Chúa Hằng Hữu, làm lễ chuộc tội cho bàn thờ, lấy máu bò đực và máu dê đực bôi lên khắp các sừng của bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Người cũng lấy ngón tay rảy máu trên bàn thờ bảy lần, tẩy sạch sự ô uế của người Ít-ra-ên, và thánh hóa bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Sau khi làm xong lễ chuộc tội cho Nơi Chí Thánh, Đền Tạm, và bàn thờ, A-rôn sẽ đem con dê đực đến. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Người đặt tay mình lên đầu nó, xưng tất cả tội của người Ít-ra-ên trên đầu nó để nó mang tội của toàn dân, và một người được chỉ định sẵn sẽ đem nó vào hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Người ấy sẽ thả nó ra, con dê sẽ mang tất cả tội lỗi của dân đi vào nơi vắng vẻ, trong hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Xong, A-rôn vào Đền Tạm, cởi tất cả y phục vải gai mình đã mặc để đi vào Nơi Chí Thánh, và bỏ tất cả ở đó. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Người sẽ tắm tại một nơi thánh, mặc áo, đi ra dâng tế lễ thiêu của mình và của dân, để chuộc tội cho mình và cho dân. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Người cũng đốt mỡ của sinh tế chuộc tội trên bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Còn người đem con dê vào hoang mạc phải giặt quần áo, tắm rửa, xong mới được vào nơi đóng trại. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Về con bò đực và dê đực dùng làm sinh tế chuộc tội, máu của nó sẽ được A-rôn đem vào Nơi Chí Thánh làm lễ chuộc tội; còn da, thịt và phân của nó sẽ được đem ra khỏi nơi đóng trại đốt đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Người đốt sẽ phải giặt quần áo, tắm rửa xong mới được trở vào nơi đóng trại. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Luật sau đây có tính cách vĩnh viễn: Ngày mồng mười tháng bảy, mọi người phải hạ mình tĩnh tâm, nghỉ mọi công việc. Luật này áp dụng cho người dân bản xứ lẫn ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Vì trong ngày hôm ấy, các ngươi được chuộc tội, tẩy sạch lỗi trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Đó là một ngày lễ cuối tuần long trọng, một ngày nghỉ ngơi, mọi người phải hãm mình tĩnh tâm. Luật này áp dụng đời đời. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Thầy tế lễ được xức dầu thánh để thay thế cha mình giữ chức trưởng tế phải làm lễ chuộc tội. Người sẽ mặc áo vải gai thánh, ");
INSERT INTO vieovcb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","đứng ra làm lễ chuộc tội cho Nơi Chí Thánh, Đền Tạm, bàn thờ, cho các thầy tế lễ khác và toàn dân. ");
INSERT INTO vieovcb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Luật này không thay đổi qua các thời đại, liên hệ đến việc chuộc tội cho người dân Ít-ra-ên hằng năm, vì tội họ phạm.” Môi-se tuân theo mọi lời Chúa Hằng Hữu phán dạy. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Hãy truyền lại cho A-rôn, các con A-rôn, và toàn dân Ít-ra-ên những luật sau. Đây là điều Chúa Hằng Hữu phán bảo. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Người Ít-ra-ên nào giết một con bò, chiên hay dê làm sinh tế dâng lên Chúa ở trong nơi đóng trại hay bên ngoài trại, ");
INSERT INTO vieovcb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","mà không đem đến cửa Đền Tạm để dâng sinh tế lên Chúa Hằng Hữu, người ấy mắc tội gây đổ máu và bị truất khỏi cộng đồng dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Luật này nhằm chấm dứt việc người Ít-ra-ên giết sinh tế ở ngoài đồng, và buộc họ đem sinh tế đến cửa Đền Tạm cho thầy tế lễ. Sinh tế sẽ bị giết tại đó để dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Thầy tế lễ sẽ rảy máu trên bàn thờ của Chúa Hằng Hữu, tại cửa Đền Tạm, đốt mỡ dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Như thế, họ sẽ không còn giết thú vật cúng tế các thần dâm dục và liên lạc với chúng. Luật này áp dụng đời đời qua các thế hệ. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Nhắc cho họ nhớ luôn rằng, dù người Ít-ra-ên hay người ngoại kiều, nếu ai dâng tế lễ thiêu hay dâng một sinh tế ");
INSERT INTO vieovcb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","tại một nơi nào khác, không phải tại cửa Đền Tạm nơi dâng lễ vật lên Chúa Hằng Hữu, thì người ấy phải bị trục xuất khỏi cộng đồng dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Nếu một người Ít-ra-ên hay ngoại kiều ăn bất kỳ máu gì, Ta sẽ chống đối người ấy và trục xuất người ấy khỏi cộng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ta cho các ngươi máu để rảy trên bàn thờ, chuộc tội linh hồn mình, vì máu tiềm tàng sức sống của cơ thể sinh vật. Chính sự sống của sinh vật ở trong máu, nên máu được dùng để chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Vì thế, Ta đã cấm người Ít-ra-ên và người ngoại kiều không được ăn máu. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Trường hợp một người Ít-ra-ên hay ngoại kiều đi săn, giết một con thú hay một con chim để ăn thịt, người ấy phải trút cho ráo hết máu và lấy đất lấp máu lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Vậy, máu là sức sống của các sinh vật. Do đó Ta đã cấm người Ít-ra-ên không được ăn máu của bất kỳ sinh vật nào, vì sự sống của một sinh vật là máu của nó. Ai ăn máu, sẽ bị trục xuất. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Người nào, dù bản xứ hay ngoại kiều, ăn một con vật chết hoặc vì bị thú rừng cắn xé, phải giặt quần áo, phải tắm, bị ô uế cho đến tối, sau đó mới được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Nếu người ấy không giặt áo và không tắm, thì sẽ mang tội.” ");
INSERT INTO vieovcb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Hãy nói với người Ít-ra-ên: Ta là Chúa Hằng Hữu, Đức Chúa Trời các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Vậy, đừng bắt chước nếp sống của người Ai Cập, nơi các ngươi từ đó ra đi. Cũng đừng theo lối sống của người Ca-na-an, nơi Ta sẽ đem các ngươi vào. Đừng để cho tập tục của họ ràng buộc mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Nhưng các ngươi phải tuân theo luật lệ Ta, làm theo mọi điều Ta dạy bảo, vì Ta là Chúa Hằng Hữu, Đức Chúa Trời các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Hãy giữ luật lệ Ta, người nào tuân hành luật pháp Ta thì sống. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Không ai được quan hệ tình dục với một người bà con gần. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Không ai được quan hệ tình dục với cha mình, cũng không ai được quan hệ tình dục với mẹ mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Không ai được quan hệ tình dục với vợ của cha mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Không ai được quan hệ tình dục với chị em ruột, chị em cùng cha khác mẹ hay cùng mẹ khác cha, dù các chị em ấy được sinh ra trong nhà mình hay nhà khác. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Không ai được quan hệ tình dục với cháu gái mình, dù cháu nội hay cháu ngoại. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Không ai được quan hệ tình dục với con riêng của vợ của cha mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Không ai được quan hệ tình dục với cô mình, vì là chị em của cha mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Không ai được quan hệ tình dục với dì mình, vì là chị em của mẹ mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Không ai được quan hệ tình dục với bác gái hay thím mình, vì là vợ của chú bác mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Không ai được quan hệ tình dục với con dâu mình, vì là vợ của con trai mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Không ai được quan hệ tình dục với chị dâu hay em dâu mình, vì là vợ của anh em mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Không ai được quan hệ tình dục với một người đàn bà luôn với con gái hoặc cháu gái của người ấy, dù cháu nội hay cháu ngoại. Họ là cốt nhục của nhau. Đó là một điều ác. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Không ai được lấy chị em của vợ khi vợ còn sống. Họ sẽ trở nên cừu địch. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Không ai được giao hợp với một người đàn bà trong lúc không sạch vì có kinh nguyệt. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Không ai được giao hợp với vợ người khác, vì làm cho mình ô uế với nàng. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Không được dâng con cái mình trên lửa cho Mô-lóc, làm ô Danh Đức Chúa Trời mình. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Không được đồng tính luyến ái; đó là một tội đáng ghê tởm. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Dù nam hay nữ, không ai được giao hợp với một con thú, làm cho mình ô uế với nó; đó là một điều tà ác. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Vậy, không ai được phạm một trong các điều cấm đoán nói trên, làm ô uế mình. Đó là những điều các dân tộc khác phạm, họ làm ô uế mình, ô uế đất. Vì thế, Ta trừng phạt họ, đuổi họ ra khỏi đất mà họ đã làm ô uế trước mặt các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ngay cả đất cũng bị ô uế, nên Ta trừng phạt đất, và nó sẽ mửa mọi cư dân nó ra. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Các ngươi phải tuân giữ luật lệ Ta, không được làm một điều đáng tởm nào trong các điều trên. Luật này áp dụng cho cả người bản xứ lẫn ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Vì các dân tộc ở trên lãnh thổ này trước đây đã từng làm những điều ghê tởm đó. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Nếu không, Ta sẽ trục xuất các ngươi ra khỏi lãnh thổ, như Ta đã trục xuất những dân tộc cư ngụ trong lãnh thổ trước các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ai phạm một trong các tội đáng ghê tởm này sẽ bị trục xuất khỏi cộng đồng dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Vậy, phải vâng lời Ta, không được làm một điều nào trong các thói đáng tởm của các dân tộc ấy mà làm ô uế mình, vì Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Chúa Hằng Hữu phán dặn Môi-se nói với toàn dân Ít-ra-ên: ");
INSERT INTO vieovcb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Phải thánh khiết, vì Ta, Chúa Hằng Hữu, Đức Chúa Trời các ngươi, là thánh khiết. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Mọi người phải tôn kính cha mẹ mình, phải tuân giữ luật ngày Sa-bát, vì Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Không được thờ hình tượng, cũng không được đúc tượng các thần, vì Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Khi các ngươi dâng lễ vật tạ ơn lên Chúa Hằng Hữu, phải dâng đúng cách để được Ngài chấp nhận. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Lễ vật chỉ được ăn trong ngày dâng và ngày kế. Phần còn thừa qua ngày thứ ba phải đem đốt đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Nếu có ai ăn trong ngày thứ ba, thì đó là một điều đáng ghê tởm, lễ vật sẽ không được chấp nhận. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Người ăn sẽ mang tội vì đã xúc phạm vật thánh của Chúa Hằng Hữu và người ấy phải bị trục xuất khỏi cộng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Khi thu hoạch thổ sản, đừng gặt sạch tận góc đồng, cũng đừng mót lại phần đã sót. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Đừng vặt sạch vườn nho, đừng nhặt những trái nho đã rơi xuống đất. Hãy để các phần ấy cho người nghèo và khách tạm trú. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Không được trộm cắp, lường gạt, dối trá. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Không được dùng tên Ta thề dối, làm xúc phạm Danh Đức Chúa Trời của các ngươi. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Không được bức hiếp, cướp giựt người khác. Đừng giữ tiền thù lao của người giúp việc cho đến hôm sau. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Đừng rủa người điếc, cũng đừng đặt đá làm vấp chân người mù; nhưng phải kính sợ Đức Chúa Trời. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Không được bất công trong việc xét xử, không được phân biệt người giàu người nghèo, nhưng phải phân xử công minh. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Không được ngồi lê đôi mách, nói xấu người khác, cũng không được cáo gian làm nguy hại đến người khác, vì Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Đừng để lòng oán ghét anh chị em mình, nhưng thẳng thắn trách họ khi họ lầm lỗi: đừng để cho mình phải mang tội vì họ có lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Đừng trả thù, đừng mang oán hận, nhưng hãy yêu người khác như chính mình, vì Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Phải giữ luật Ta. Đừng cho thú vật khác giống giao hợp, đừng gieo hai thứ hạt giống trong một đám ruộng, đừng mặc áo may bằng hai thứ vải. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Nếu có ai giao hợp với một nữ nô lệ đã đính hôn với một người khác, và người nữ nô lệ chưa được chuộc, chưa tự do, thì người đó phải bị hình phạt. Nhưng không phải tử hình, vì người đàn bà chưa được tự do. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Người đàn ông có lỗi phải đem đến cửa Đền Tạm một con chiên đực làm lễ vật chuộc lỗi, dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Thầy tế lễ sẽ dâng con chiên làm tế lễ chuộc lỗi người ấy đã phạm trước mặt Chúa Hằng Hữu, thì tội ấy sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Khi đã vào đất hứa và trồng các thứ cây ăn quả, các ngươi không được ăn quả các cây ấy trong ba năm đầu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Quả thu được trong năm thứ tư phải hiến dâng lên Chúa Hằng Hữu để tôn vinh Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Đến năm thứ năm, các ngươi bắt đầu được ăn quả, và lợi tức các ngươi cũng sẽ gia tăng. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Không được ăn thịt chưa sạch máu. Không được làm thầy bói, thầy pháp. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Đừng tỉa tóc vòng quanh đầu; đừng cắt mép râu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Đừng cắt thịt mình lúc tang chế; cũng đừng xăm trên mình một dấu hiệu nào, vì Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Không được bắt con gái mình hành nghề mãi dâm, làm ô nhục nó, và khiến xã hội đầy người trụy lạc, tà ác. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Phải tuân giữ luật ngày nghỉ cuối tuần, tôn kính nơi thánh Ta, vì Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Đừng cầu hỏi thầy pháp, đồng bóng, để khỏi bị họ làm ô uế mình, vì Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Phải kính trọng người già cả, đầu râu tóc bạc. Phải tôn kính Đức Chúa Trời các ngươi. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Không được bạc đãi khách lạ kiều dân. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ngoại kiều phải được đối xử như người bản xứ, phải thương họ như chính mình, vì các ngươi đã từng là kiều dân trong nước Ai Cập. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Đừng dùng các tiêu chuẩn gian dối khi cân, đo, và đếm. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Phải sử dụng các dụng cụ đo lường chân thật và chính xác. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi, đã đem các ngươi ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Phải tôn trọng và thi hành các luật lệ Ta, cùng mọi lời Ta dạy, vì Ta là Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Hãy truyền dạy cho người Ít-ra-ên: Dù là người Ít-ra-ên hay ngoại kiều, người nào dâng con mình cho Mô-lóc phải bị xử tử. Dân trong xứ sẽ lấy đá ném vào người ấy cho chết đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Người dâng con mình cho Mô-lóc như vậy sẽ bị Ta chống nghịch, khai trừ khỏi dân, vì làm ô uế nơi thánh, xúc phạm Danh Ta. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Nhưng nếu dân trong xứ che mắt làm ngơ trước việc dâng con cho Mô-lóc, không xử tử người ấy, ");
INSERT INTO vieovcb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","thì chính Ta sẽ ra tay trừng phạt người ấy với cả gia đình họ, khai trừ người ấy và những kẻ đồng lõa ra khỏi dân chúng về tội thông dâm với Mô-lóc. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Nếu ai cầu hỏi thầy pháp, đồng bóng, thì Ta sẽ chống nghịch và khai trừ người ấy khỏi dân. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Vậy, phải làm sạch mình, phải sống thánh khiết, vì Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Phải tuân hành luật lệ Ta, vì Ta là Chúa Hằng Hữu, đã thánh hóa các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ai rủa cha hay mẹ mình phải bị xử tử. Người rủa cha mẹ mình chịu trách nhiệm về mạng sống mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Nếu một người đàn ông thông dâm với vợ người khác, thì cả hai phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Nếu một người đàn ông quan hệ tình dục với vợ của cha mình, thì cả hai phải bị xử tử, họ chịu trách nhiệm về mạng sống mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Nếu một người đàn ông quan hệ tình dục với con dâu mình, thì cả hai phải bị xử tử. Họ phải chịu trách nhiệm về mạng sống mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Hai người đồng tính luyến ái phải bị xử tử. Họ phạm một tội đáng ghê tởm, phải chịu trách nhiệm về mạng sống mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Nếu một người đàn ông lấy cả hai mẹ con, thì họ phạm tội ác. Cả ba phải bị thiêu sống để tẩy trừ tội ác khỏi dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Nếu một người đàn ông quan hệ tình dục với một con thú, thì người bị xử tử, và thú bị giết. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Nếu một người đàn bà tìm đến quan hệ tình dục với một con thú, thì người bị xử tử, và thú bị giết. Người ấy phải chịu trách nhiệm về mạng sống mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Nếu một người đàn ông lấy chị em ruột hay chị em cùng cha khác mẹ, cùng mẹ khác cha, thì đó là một điều nhục. Họ phải bị trục xuất khỏi cộng đồng. Người đàn ông phải mang tội mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Nếu một người đàn ông nằm với một người đàn bà đang có kinh, thì cả hai phải bị trục xuất khỏi cộng đồng, vì họ đã để lộ nguồn máu của nàng. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Không ai được quan hệ tình dục với dì hay cô mình vì là bà con gần. Họ phải mang tội mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Nếu một người đàn ông ăn nằm với thím mình, thì cả hai phải mang tội mình và sẽ chết tuyệt tự. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Nếu một người đàn ông lấy vợ của anh em mình, thì đó là một điều ô uế, họ sẽ chết tuyệt tự. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Vậy, phải tuân hành luật lệ Ta, vâng lời Ta dạy, để Ta không trục xuất các ngươi ra khỏi lãnh thổ mà Ta sẽ đem các ngươi vào. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Không được làm theo những thói tục của các dân tộc bị Ta đuổi ra trước các ngươi. Vì họ đã làm những điều xấu xa ấy, khiến Ta ghê tởm họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ta hứa cho các ngươi lãnh thổ họ cư ngụ, là một vùng đất phì nhiêu. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi, đã phân rẽ các ngươi với các dân tộc khác. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Vậy, các ngươi phải biết phân biệt giữa loài thú, loài chim sạch và không sạch; đừng để cho loài thú, chim, sâu bọ trên đất—là những loài vật Ta đã bảo cho các ngươi biết là không sạch—làm cho các ngươi ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Các ngươi phải sống thánh khiết cho Ta, vì Ta là Chúa Hằng Hữu thánh khiết, đã phân rẽ các ngươi với các dân tộc khác, để các ngươi thuộc về Ta. ");
INSERT INTO vieovcb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Người nào làm thầy pháp, đồng bóng, dù đàn ông hay đàn bà, đều phải bị xử tử. Họ phải bị người ta ném đá cho chết, và phải chịu trách nhiệm về mạng sống mình.” ");
INSERT INTO vieovcb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Chúa Hằng Hữu phán dặn Môi-se nói với các con trai A-rôn: “Các thầy tế lễ không được đụng đến người chết để khỏi bị ô uế; ");
INSERT INTO vieovcb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ngoại trừ trường hợp người chết là họ hàng gần—gồm cha, mẹ, con trai, con gái, anh em, ");
INSERT INTO vieovcb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","chị em còn độc thân sống gần với mình vì không có chồng. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Thầy tế lễ là người lãnh đạo của dân, nên không được để cho mình bị ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Thầy tế lễ không được cạo tóc, cắt mép râu, hay cắt thịt mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Họ phải sống thánh khiết cho Đức Chúa Trời của họ, không được xúc phạm đến Danh Ngài, để xứng đáng là người dâng tế lễ thiêu, dâng bánh lên Chúa Hằng Hữu, Đức Chúa Trời của họ. Vậy họ phải thánh khiết. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Thầy tế lễ không được kết hôn với gái mãi dâm hay đàn bà lăng loàn, cũng không nên lấy đàn bà ly dị, vì thầy tế lễ là người thánh của Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Thầy tế lễ được biệt riêng để dâng lễ vật lên Đức Chúa Trời, là người thánh, vì Ta, Chúa Hằng Hữu thánh khiết, đã thánh hóa họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Nếu con gái của thầy tế lễ làm gái mãi dâm, xúc phạm cha mình, thì người con gái ấy phải bị thiêu sống. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Thầy thượng tế là người đầu được xức dầu thánh, mình mặc áo lễ, không có phép bỏ tóc xõa, không được xé áo mình, ");
INSERT INTO vieovcb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","cũng không được đến gần xác chết, làm ô uế mình, dù người chết là cha hay mẹ mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Thầy thượng tế không được rời khỏi đền thánh của Đức Chúa Trời hoặc xúc phạm nơi đó, vì người được hiến dâng cho Đức Chúa Trời bởi sự xức dầu, Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Người chỉ được cưới gái đồng trinh làm vợ. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Người không được cưới đàn bà góa, đàn bà ly dị hay đàn bà lăng loàn, gái mãi dâm, nhưng chỉ được cưới gái đồng trinh trong đại tộc Lê-vi; ");
INSERT INTO vieovcb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","vì người không được phàm tục hóa con cháu mình giữa dân chúng. Ta, Chúa Hằng Hữu, đã thánh hóa người.” ");
INSERT INTO vieovcb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Hãy nói với A-rôn: ‘Không một ai trong con cháu ngươi—từ nay cho đến các thế hệ sau—được đứng dâng lễ vật lên Đức Chúa Trời nếu bị tật nguyền. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Đó là những người bị khiếm thị, què, thân thể biến dạng, ");
INSERT INTO vieovcb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","những người gãy chân, gãy tay, ");
INSERT INTO vieovcb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","hoặc gù lưng, còi cọc, mắt có tật, ghẻ lở, và tinh hoàn dập. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Vậy, người có tật nguyền—dù là con cháu Thầy Tế lễ A-rôn—sẽ không được đứng dâng lễ thiêu lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Tuy nhiên, họ được phép ăn lễ vật đã dâng lên Đức Chúa Trời, cả lễ vật thánh và rất thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Nhưng không được đến gần bức màn và bàn thờ, vì tật nguyền của người ấy sẽ xúc phạm nơi thánh của Ta. Ta là Chúa Hằng Hữu đã thánh hóa các nơi ấy.’ ” ");
INSERT INTO vieovcb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Môi-se lặp lại các lời này cho A-rôn, các con trai A-rôn, và toàn dân Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Hãy nói với A-rôn và các con A-rôn: Đối với các lễ vật thánh người Ít-ra-ên đem dâng lên Ta, các ngươi phải rất thận trọng để khỏi làm xúc phạm Danh Ta. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Từ nay cho đến các thế hệ về sau, thầy tế lễ nào khi đang bị ô uế, mà đến gần những lễ vật thánh người Ít-ra-ên đem dâng lên Ta, sẽ bị trục xuất khỏi đền thờ. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Trong con cháu A-rôn, nếu ai mắc bệnh phong hoặc mắc chứng di tinh, thì sẽ không được ăn những lễ vật thánh cho đến khi được sạch. Nếu ai đụng phải xác chết, đụng phải một người xuất tinh, ");
INSERT INTO vieovcb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","hoặc đụng đến một loài sâu bọ, hay một người bị ô uế vì bất kỳ lý do gì, ");
INSERT INTO vieovcb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","thì người ấy sẽ bị ô uế cho đến tối, và không được phép ăn lễ vật thánh cho đến khi tắm rửa sạch sẽ. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Khi mặt trời lặn, người ấy mới được sạch, và sau đó được ăn lễ vật thánh, vì các vật này là thực phẩm nuôi dưỡng họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Con cháu A-rôn không được ăn thịt súc vật chết hay súc vật bị thú dữ xé xác, vì sẽ làm cho mình ô uế. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Vậy họ phải vâng lời Ta; nếu không, sẽ mắc tội và phải chết, vì vi phạm luật Ta. Ta là Chúa Hằng Hữu đã thánh hóa họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ngoài con cháu A-rôn, không ai được ăn lễ vật thánh. Khách đến thăm và đầy tớ trong nhà thầy tế lễ đều không được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Nhưng người nô lệ được thầy tế lễ mua đem về, và những người sinh ra trong nhà sẽ được phép ăn lễ vật thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Nếu con gái thầy tế lễ lấy chồng không phải là thầy tế lễ, thì sẽ không được ăn lễ vật thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Nhưng nếu con gái thầy tế lễ là một góa phụ hay đã ly dị, không con, về ở với cha như thuở còn nhỏ, thì người ấy được phép ăn thực phẩm cha mình ăn. Ngoài ra, không ai khác ngoài gia đình thầy tế lễ được phép ăn cả. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Nếu có người vô tình ăn lầm lễ vật thánh, thì người này phải đền lại cho thầy tế lễ vật mình đã ăn, cộng thêm một phần năm giá trị vật ấy. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Thầy tế lễ không được xúc phạm những lễ vật thánh của người Ít-ra-ên đem dâng lên Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","mà cho người nào ăn những lễ vật thánh đó. Vì Ta là Chúa Hằng Hữu, đã thánh hóa các lễ vật ấy. Ai vi phạm luật này sẽ phải mang tội.” ");
INSERT INTO vieovcb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Hãy nói với A-rôn, các con A-rôn, và toàn dân Ít-ra-ên: Nếu một người Ít-ra-ên hay một ngoại kiều đem dâng sinh tế lễ thiêu lên Chúa Hằng Hữu, dù là lễ vật hứa dâng trong lúc thệ nguyện hoặc lễ vật tình nguyện hiến dâng, và muốn cho lễ vật mình được chấp nhận, ");
INSERT INTO vieovcb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","người ấy phải dâng một con bò, hoặc chiên, hoặc dê không tì vít, và phải là con đực. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Một con vật không toàn vẹn sẽ không được chấp nhận. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Khi một người dâng bò hoặc chiên làm lễ vật tạ ơn lên Chúa Hằng Hữu, dù là lễ vật thề nguyện hoặc lễ vật tình nguyện, sinh vật phải toàn vẹn, không khuyết tật mới được chấp nhận. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Không được dâng lên Chúa Hằng Hữu và đem thiêu trên bàn thờ một con vật mù, có tật, cụt chân, ghẻ, lở. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Một con bò hay chiên trong cơ thể có một bộ phận thừa hay thiếu có thể dùng làm lễ vật tình nguyện, nhưng không được dâng làm lễ vật thề nguyện. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Trong cả nước, không ai được dâng lên Chúa Hằng Hữu con vật có bộ phận sinh dục bị bầm, dập, vỡ hay bị thiến. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Người ngoại kiều cũng không được dâng lên Đức Chúa Trời một lễ vật không toàn vẹn, vì sẽ không được chấp nhận.” ");
INSERT INTO vieovcb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Chúa Hằng Hữu phán với Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Một con bò, con chiên hay con dê lúc mới sinh ra phải được ở với mẹ nó trong bảy ngày. Từ ngày thứ tám trở đi, nó có thể được dùng làm sinh tế lễ thiêu dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Không ai được giết cả mẹ lẫn con—dù là bò hay chiên—trong cùng một ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Khi dâng lễ vật tạ ơn lên Chúa Hằng Hữu, phải dâng đúng cách để lễ vật được nhận, ");
INSERT INTO vieovcb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","sinh tế phải được ăn trong ngày, không được để thừa đến sáng mai. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Các ngươi phải tuân hành luật lệ Ta, vì Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Không được xúc phạm đến Danh Thánh Ta, vì Ta phải được tôn kính giữa toàn dân Ít-ra-ên. Ta là Chúa Hằng Hữu, đã thánh hóa các ngươi, ");
INSERT INTO vieovcb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","đem các ngươi ra khỏi đất Ai Cập để các ngươi thuộc về Ta. Ta là Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Hãy nói với người Ít-ra-ên: Đây là những ngày lễ Chúa Hằng Hữu ấn định; các ngươi sẽ hội họp trong những ngày thánh đó. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ngày lễ Sa-bát là một ngày nghỉ long trọng, ngày nhóm họp thánh. Làm công việc trong sáu ngày, nhưng nghỉ ngày thứ bảy. Dù các ngươi ở đâu, ngày nghỉ cuối tuần cũng là ngày của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Đây là những ngày lễ thánh hằng năm được Chúa Hằng Hữu ấn định, mỗi dịp lễ phải thông báo cho toàn dân.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Lễ Vượt Qua của Chúa Hằng Hữu phải tổ chức vào tối ngày mười bốn tháng giêng. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Lễ Bánh Không Men dâng lên Chúa Hằng Hữu kéo dài bảy ngày, bắt đầu ngày mười lăm tháng giêng. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ngày đầu là ngày nhóm họp thánh, không ai được làm việc nặng nhọc. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Suốt bảy ngày, ngày nào cũng phải dâng lễ thiêu lên Chúa Hằng Hữu. Đến ngày thứ bảy, hãy tổ chức nhóm họp thánh, và không được làm những việc thông thường.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Hãy nói với người Ít-ra-ên: Khi các ngươi vào lãnh thổ Ta cho, trong vụ gặt đầu tiên, phải đem bó lúa đầu mùa đến cho thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Vào ngày sau ngày Sa-bát, thầy tế lễ sẽ đem bó lúa dâng lên Chúa Hằng Hữu theo cách đưa qua đưa lại; lễ vật sẽ được chấp nhận. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Trong cùng ngày ấy, các ngươi phải đem một con chiên đực một tuổi không tì vít làm tế lễ thiêu dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Đồng thời, cũng dâng ngũ cốc, gồm 4,4 lít bột mịn pha dầu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu, cùng với một lít rượu nho. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Không ai được ăn bánh hoặc ngũ cốc—còn tươi hay đã phơi khô—cho đến ngày hôm ấy là ngày dâng lễ vật lên Đức Chúa Trời. Luật này áp dụng vĩnh viễn qua các thế hệ, trong khắp lãnh thổ.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Từ ngày sau ngày Sa-bát, là ngày các ngươi sẽ đem dâng ngũ cốc mới thu hoạch lên Chúa, hãy đếm đủ bảy tuần lễ, ");
INSERT INTO vieovcb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","tức là đếm năm mươi ngày cho đến sau ngày Sa-bát thứ bảy, và dâng một tế lễ chay mới lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Lấy 4,4 lít bột mịn pha men, làm hai ổ bánh để dâng đưa qua đưa lại; bánh này sẽ được nướng tại nhà đem tới, làm lễ vật đầu mùa lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Cùng với bánh và rượu, các ngươi sẽ dâng bảy con chiên một tuổi không tì vít, một bò tơ đực và hai chiên đực, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Các ngươi cũng sẽ dâng một dê đực làm lễ chuộc tội, hai chiên đực một tuổi làm lễ tạ ơn. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Thầy tế lễ sẽ dâng các lễ vật này lên Chúa Hằng Hữu theo cách đưa qua đưa lại, cùng với hai ổ bánh làm bằng ngũ cốc đầu mùa. Các lễ vật này là thánh được dâng lên Chúa Hằng Hữu, và sẽ thuộc về thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ngày hôm ấy, phải thông báo triệu tập dân chúng đến dự thánh lễ, không ai được làm việc nặng nhọc. Luật này áp dụng vĩnh viễn qua các thế hệ, trong khắp lãnh thổ. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Khi gặt hái thổ sản, đừng gặt sạch tận góc đồng, cũng đừng mót lại phần đã sót. Hãy để các phần đó cho người nghèo và khách tạm trú. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Hãy nói với người Ít-ra-ên: Ngày mồng một tháng bảy là ngày nghỉ long trọng, một ngày kỷ niệm, phải thổi kèn triệu tập dân đến dự thánh lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ngày ấy không ai làm việc nặng nhọc, nhưng sẽ dâng tế lễ thiêu lên Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ngày mồng mười tháng bảy là Ngày Chuộc Tội. Toàn dân phải họp lại trong ngày thánh này, để ăn năn hối lỗi và dâng tế lễ thiêu lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Không ai làm việc trong Ngày Chuộc Tội, chỉ lo chuộc tội mình trước mặt Chúa Hằng Hữu, Đức Chúa Trời các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ai không xét mình hối lỗi hôm ấy sẽ bị trục xuất khỏi cộng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ai làm bất kỳ việc gì trong ngày ấy, Ta sẽ khai trừ người ấy khỏi cộng đồng. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Luật này áp dụng đời đời cho mọi thế hệ, trong khắp lãnh thổ. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ngày ấy là một ngày nghỉ long trọng, phải xét mình hối lỗi. Lễ này bắt đầu tối ngày chín và chấm dứt tối ngày mười tháng bảy.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Hãy nói với người Ít-ra-ên: Ngày rằm tháng bảy sẽ là Lễ Lều Tạm của Chúa Hằng Hữu. Phải giữ lễ này trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ngày thứ nhất là ngày hội họp thánh, không ai được làm việc nặng nhọc. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Trong suốt bảy ngày lễ này, ngày nào cũng phải dâng tế lễ thiêu lên Chúa Hằng Hữu. Ngày thứ tám lại là ngày hội họp thánh long trọng, cũng sẽ có lễ thiêu dâng lên Chúa Hằng Hữu. Không ai được làm việc nặng nhọc. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(Đó là những ngày lễ Chúa ấn định, phải thông báo triệu tập dân chúng đến dự các buổi họp thánh, và dùng lửa dâng lễ vật lên Chúa Hằng Hữu gồm có sinh tế, ngũ cốc, rượu—như đã ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Các ngày lễ này là những ngày nghỉ ngoài các ngày nghỉ cuối tuần thông thường; các lễ vật dâng trong các ngày ấy là những lễ vật ngoài các lễ vật thông thường, và cũng không tính đến các tế lễ khác như lễ vật khấn nguyện, và mọi lễ vật tự nguyện dâng lên Chúa Hằng Hữu.) ");
INSERT INTO vieovcb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ngày rằm tháng bảy, sau khi đã gặt hái xong, mọi người sẽ giữ lễ này cho Chúa Hằng Hữu bảy ngày, họ sẽ nghỉ ngơi để hội họp trong ngày thứ nhất và ngày thứ tám. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Vào ngày thứ nhất, các ngươi sẽ lấy nhánh cây đầy quả, cành chà là, nhánh cây đầy lá, cành dương liễu, và vui mừng trong bảy ngày trước mặt Chúa Hằng Hữu, Đức Chúa Trời các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Bảy ngày lễ trong tháng bảy hằng năm này phải được tôn trọng mãi mãi qua các thế hệ. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mọi người Ít-ra-ên sẽ ở lều trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Như vậy, từ thế hệ này qua thế hệ khác, họ sẽ tưởng niệm thời kỳ ở lều sau khi Ta đem họ ra khỏi Ai Cập. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Môi-se thông báo cho người Ít-ra-ên các ngày lễ Chúa Hằng Hữu đã ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Hãy dặn người Ít-ra-ên đem dầu ô-liu nguyên chất đến để đốt đèn cho cháy mãi. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","A-rôn người phải lo chăm sóc đèn cho sáng luôn cả đêm lẫn ngày trong Đền Tạm, bên ngoài bức màn, trước mặt Chúa Hằng Hữu. Đây là một quy lệ các ngươi phải giữ mãi mãi. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Các đèn trên chân đèn vàng ròng này phải được chăm nom thường xuyên cho cháy sáng luôn trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Lấy bột mịn làm mười hai ổ bánh, mỗi ổ dùng 4,4 lít bột. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Xếp bánh trên bàn bằng vàng ròng trước mặt Chúa Hằng Hữu thành hai hàng, mỗi hàng sáu ổ. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Lấy nhũ hương nguyên chất rắc lên mỗi hàng bánh. Đó là một lễ vật tưởng niệm dùng lửa dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mỗi ngày lễ Sa-bát, A-rôn sẽ xếp mười hai ổ bánh mới trước mặt Chúa Hằng Hữu, tượng trưng cho giao ước trường tồn đã thiết lập với người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Bánh sẽ là thực phẩm của A-rôn và các con trai người, họ sẽ ăn tại một nơi thánh, vì đây là những lễ vật rất thánh, dùng lửa dâng lên Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Một người kia có mẹ là người Ít-ra-ên, cha là người Ai Cập cùng ra đi với người Ít-ra-ên. Một hôm người này cãi nhau với một người Ít-ra-ên trong nơi đóng trại. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Trong lúc cãi vã, con trai người đàn bà Ít-ra-ên ấy xúc phạm đến Danh của Chúa Hằng Hữu. Người ta dẫn người ấy đến cho Môi-se. Người này là con của bà Sê-lô-mít, cháu bà Điệp-ri, thuộc đại tộc Đan. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Họ giữ người ấy lại, cho đến khi ý của Chúa Hằng Hữu được tỏ ra. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Đem người đã xúc phạm Danh Ta ra khỏi nơi đóng trại, những ai đã nghe người ấy nói sẽ đặt tay trên đầu người, rồi toàn dân sẽ lấy đá ném vào người cho chết đi. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Cũng báo cho dân hay rằng, ai rủa Đức Chúa Trời mình phải chịu tội. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ai xúc phạm Danh Chúa Hằng Hữu phải bị xử tử. Toàn dân sẽ ném đá cho chết. Luật này áp dụng cho cả người Ít-ra-ên và ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ai giết người sẽ bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ai giết thú vật phải bồi thường, vật sống đền vật sống. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ai gây thương tích cho người khác thế nào, phải chịu phạt bằng một thương tích thế ấy: ");
INSERT INTO vieovcb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Xương đền xương, mắt đền mắt, răng đền răng. Gây thương tích nào đền thương tích ấy. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ai giết thú vật phải bồi thường, nhưng ai giết người phải bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Luật này áp dụng chung cho người Ít-ra-ên và ngoại kiều. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Sau khi nghe lệnh của Chúa Hằng Hữu do Môi-se truyền lại, dân chúng đem người đã xúc phạm đến Danh Đức Chúa Trời ra khỏi nơi đóng trại và ném đá chết. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Trên Núi Si-nai, Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Hãy truyền cho người Ít-ra-ên: Khi đã vào đất Ta cho, phải để cho đất nghỉ vào năm thứ bảy. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Các ngươi sẽ cày cấy đồng ruộng, trồng tỉa vườn nho, thu hoa quả trong sáu năm. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Nhưng năm thứ bảy sẽ là năm đất hưu canh, năm An Nghỉ của Chúa Hằng Hữu. Không ai được làm ruộng, tỉa nho trong vườn. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Cũng đừng thu chứa hoa quả tự mọc lên trong năm đất nghỉ ngơi này. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Trong năm An Nghỉ, đất vẫn cung cấp đầy đủ thực phẩm cho mọi người: Cho ngươi, cho nô lệ, và người làm công của ngươi, cho khách tạm trú trong nhà ngươi, ");
INSERT INTO vieovcb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","cho gia súc, và luôn cả các loài thú vật sống trong đất ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Cứ bảy lần bảy năm, tức là bốn mươi chín năm. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Vào ngày mồng mười tháng bảy, là Ngày Chuộc Tội, phải thổi kèn vang lên khắp lãnh thổ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Vì năm thứ năm mươi là năm thánh, mọi người trên toàn đất nước sẽ được công bố tự do, hoan hỉ. Năm ấy mọi người có quyền lấy lại tài sản mình, người nô lệ được tự do trở về với gia đình. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Đây là một năm đầy hân hoan, hạnh phước. Các ngươi sẽ không gieo, không gặt, không hái. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Vì đất sẽ tự nó sinh sản hoa màu cho các ngươi dùng trong năm thánh đầy hạnh phước này. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Trong năm ấy, mọi người sẽ chiếm lại quyền sở hữu tài sản mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Vậy, khi mua bán tài sản, đừng lợi dụng nhau. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Phải tính cho đến Năm Hân Hỉ sắp tới, mà mua đất từ người lân cận. Còn người bán sẽ căn cứ vào số năm đến Năm Hân Hỉ sắp tới mà định giá. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Giá mua bán sẽ tăng giảm tùy theo số năm còn lại. Vì thật ra, đây chỉ là một sự mua bán số vụ mùa còn lại mà thôi. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Vậy, đừng để cho bên nào bị thiệt thòi, phải kính sợ Đức Chúa Trời. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Phải tuân hành luật pháp Ta, để có an ninh trật tự xã hội. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Đất sẽ sản xuất hoa quả, ngươi sẽ được no nê và sống yên lành. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Nếu ngươi hỏi: ‘Chúng tôi sẽ lấy gì ăn trong năm thứ bảy khi không được phép gieo và gặt?’ ");
INSERT INTO vieovcb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ta sẽ ban phước cho các ngươi được mùa gấp ba lần trong năm thứ sáu. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Khi các ngươi gieo trồng cho năm thứ tám, các ngươi vẫn ăn hoa lợi của năm thứ sáu. Thực tế, các ngươi vẫn ăn từ hoa lợi dư dật từ mùa màng cũ cho đến mùa gặt năm thứ chín.” ");
INSERT INTO vieovcb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Không được đoạn mãi đất đai, vì đất thuộc về Ta. Các ngươi chỉ là kiều dân và người chiếm hữu tạm thời. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Quyền chuộc lại đất đã bán phải được tôn trọng trong toàn lãnh thổ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Nếu một người túng thiếu, phải bán bớt một phần đất mình, thì một người bà con gần của người này có quyền chuộc đất lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Nếu người này không còn bà con để chuộc đất cho mình, nhưng về sau làm ăn khá ra, có đủ tiền để chuộc đất, ");
INSERT INTO vieovcb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","thì người ấy sẽ chiết tính tiền chuộc theo tỷ lệ thời gian, tính từ năm bán, và trả cho người đã mua một số tiền bằng giá trị những năm còn lại, rồi lấy đất về. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Trong trường hợp người này không có khả năng chuộc đất, đất đã bán sẽ thuộc về người mua cho đến Năm Hân Hỉ, rồi đất sẽ hoàn nguyên chủ vào năm ấy. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Nếu một người bán một cái nhà trong thành, thì người ấy có một năm tròn để chuộc nhà lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Nếu người bán không chuộc nhà trong thời hạn một năm nói trên, thì nhà sẽ vĩnh viễn thuộc quyền sở hữu của người mua. Đến Năm Hân Hỉ, nhà này sẽ không hoàn nguyên chủ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Nhưng nhà trong làng xóm không có thành bao bọc sẽ được đồng hóa với đất đai; như thế người bán có quyền chuộc lại và nhà sẽ hoàn lại nguyên chủ vào Năm Hân Hỉ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Tuy nhiên, đặc biệt đối với nhà của người Lê-vi, dù ở trong thành cũng sẽ được chuộc bất kỳ lúc nào. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Nếu nhà không được chuộc vào Năm Hân Hỉ, thì nhà này vẫn thuộc về người Lê-vi đã bán, vì người Lê-vi chỉ có nhà ở trong thành mà thôi. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ruộng đất ở chung quanh thành của người Lê-vi là những tài sản vĩnh viễn của họ, họ không được phép bán.” ");
INSERT INTO vieovcb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Nếu có người anh em nghèo nàn, không tự nuôi sống được, thì ngươi phải giúp người ấy, cho họ sống chung với mình như người tạm trú vậy. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Không được cho người ấy vay tiền để lấy lãi, nhưng phải kính sợ Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Cũng không được tính tiền ăn để kiếm lời, nhưng phải để cho người ấy sống với mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ta là Chúa Hằng Hữu, Đức Chúa Trời của ngươi, đã đem ngươi ra khỏi Ai Cập, để cho ngươi đất Ca-na-an và để làm Đức Chúa Trời ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Nếu có người anh em nghèo quá, phải bán mình cho ngươi, ngươi sẽ không được đãi người ấy như nô lệ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Phải coi người ấy như một người làm công hay người tạm trú. Người ấy sẽ giúp việc ngươi cho đến Năm Hân Hỉ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Lúc ấy, người sẽ đem theo con cái ra khỏi nhà ngươi, để về với nhà cửa đất đai của cha ông mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Vì mọi người Ít-ra-ên là đầy tớ Ta, được Ta đem ra khỏi Ai Cập, nên không được bán mình làm nô lệ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Và ngươi không được hà khắc với người anh em, nhưng phải kính sợ Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Muốn nuôi nô lệ, ngươi được mua người ngoại quốc ở trong các nước chung quanh, ");
INSERT INTO vieovcb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","hoặc mua con cái của những kiều dân sống chung với ngươi, dù họ đã được sinh ra trong đất ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Họ sẽ làm nô lệ suốt đời, vì họ thuộc về ngươi, và ngươi được truyền họ lại cho con mình. Còn giữa anh chị em người Ít-ra-ên với nhau, ngươi không được hà khắc. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Nếu có kiều dân sống chung với ngươi trở nên giàu có, và một người Ít-ra-ên trở nên nghèo cực, phải bán mình cho người ngoại quốc hay cho con cái của người ngoại quốc ấy, ");
INSERT INTO vieovcb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","thì người Ít-ra-ên sẽ được chuộc bởi anh hay em mình, ");
INSERT INTO vieovcb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","chú, bác, anh em họ, hay một người bà con gần nào khác trong gia đình. Người ấy cũng có thể tự chuộc mình nếu có đủ khả năng. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Người ấy sẽ tính với chủ đã mua mình xem còn lại bao nhiêu năm cho đến Năm Hân Hỉ. Tiền chuộc sẽ bằng tiền mướn một người làm công trong những năm còn lại. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Nếu còn lại nhiều năm, thì người ấy phải trả tiền chuộc gần bằng giá bán mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Nếu chỉ còn ít năm nữa là tới Năm Hân Hỉ, thì tiền chuộc sẽ là một số nhỏ tương xứng với số năm. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Vì người ấy được coi như người làm mướn hằng năm, chủ không được cư xử hà khắc. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nếu người ấy không được chuộc, thì người ấy và con cái mình sẽ được tự do trong Năm Hân Hỉ. ");
INSERT INTO vieovcb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Vì tất cả con dân Ít-ra-ên là đầy tớ của Ta, Ta đã đem họ ra khỏi Ai Cập. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Không được làm thần tượng, cũng không được thờ tượng chạm, trụ thờ hay tượng đá. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Phải tôn trọng luật ngày nghỉ cuối tuần và tôn trọng nơi thánh Ta. Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Nếu các ngươi tuân giữ luật lệ Ta, ");
INSERT INTO vieovcb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Ta sẽ cho mưa thuận gió hòa, làm cho đất sinh sản hoa màu, và cây trái sum suê. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mùa đập lúa kéo dài cho đến mùa hái nho, và mùa hái nho kéo dài đến mùa gieo mạ. Các ngươi sẽ no đầy, hưởng an ninh trong xứ. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Vì Ta cho các ngươi hòa bình, đi ngủ không phải lo sợ. Ta sẽ đuổi thú dữ khỏi đất ngươi và họa gươm đao sẽ không tàn hại xứ ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Nhưng các ngươi sẽ xua đuổi quân thù, họ sẽ ngã dưới lưỡi gươm ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Năm người đuổi một trăm, một trăm đuổi mười nghìn. Ngươi vung gươm, quân thù ngã rạp. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ta sẽ săn sóc các ngươi, gia tăng dân số ngươi, thực hiện giao ước Ta đã kết với ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Thóc lúa mùa trước ăn chưa hết, đã phải dẹp chỗ cho hoa màu mùa sau. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ta sẽ lập đền Ta để ở cùng ngươi; lòng Ta không ghét bỏ ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ta sẽ đi lại giữa các ngươi, làm Đức Chúa Trời các ngươi, và các ngươi làm dân Ta. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ta là Chúa Hằng Hữu, Đức Chúa Trời các ngươi, đã đem các ngươi ra khỏi Ai Cập, bẻ gãy ách nô lệ, làm cho các ngươi được ngước đầu lên.” ");
INSERT INTO vieovcb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Nhưng nếu các ngươi không nghe Ta, không làm theo lời Ta dạy, ");
INSERT INTO vieovcb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","phạm giao ước Ta, coi thường luật lệ Ta, không làm theo những điều răn và không vâng lời dạy của Ta ");
INSERT INTO vieovcb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","thì đây là những điều Ta sẽ làm: Ta sẽ cho các ngươi gặp sự khủng khiếp thình lình, mắc bệnh lao, bệnh sốt dữ dội, làm cho mắt hao mòn, người kiệt quệ. Các ngươi sẽ hoài công gieo giống, vì quân thù sẽ ăn quả. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ta sẽ nghịch ngươi, quân thù sẽ đánh đuổi ngươi, những người ghét ngươi sẽ cai trị ngươi, và ngươi sẽ chạy trốn dù không người đuổi theo! ");
INSERT INTO vieovcb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Nếu các ngươi vẫn chưa nghe Ta, thì Ta sẽ phạt tội các ngươi bảy lần nặng hơn. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ta sẽ hạ sức mạnh kiên cường của các ngươi và làm cho trời như sắt, đất như đồng. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Các ngươi sẽ gắng sức hoài công vì đất không sinh hoa màu, cây không kết quả. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Nếu các ngươi vẫn không nghe lời Ta, thì Ta sẽ gia tăng hình phạt gấp bảy lần vì tội lỗi các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ta sẽ sai thú dữ bắt con cái các ngươi, tiêu diệt súc vật các ngươi, làm giảm dân số và đường sá các ngươi sẽ vắng vẻ. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Nếu các ngươi vẫn cứ không chịu nghe lời Ta, vẫn trái lời dạy Ta dù bị trừng phạt nặng nề như thế, ");
INSERT INTO vieovcb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","thì Ta sẽ ra tay trừng phạt tội lỗi các ngươi bảy lần nặng hơn nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ta sẽ giáng họa gươm đao để báo trả việc bội ước của các ngươi. Khi các ngươi tụ tập vào các thành phố, Ta sẽ làm cho mắc bệnh dịch và rơi vào tay quân thù. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Khi Ta giáng nạn đói, một cái lò chứa tất cả bánh do mười bà nội trợ nấu, họ sẽ cân bánh trước khi trao cho các ngươi, các ngươi sẽ ăn mà không no. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Đến tình trạng này, nếu các ngươi vẫn không nghe lời Ta, ");
INSERT INTO vieovcb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Ta sẽ nổi giận, phạt tội các ngươi nặng gấp bảy lần. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Các ngươi sẽ ăn thịt con mình, cả trai lẫn gái. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ta sẽ phá hủy các bàn thờ xông hương cho các thần tượng trên đồi cao, bỏ xác các ngươi ngổn ngang trên tượng thần mình, vì lòng Ta sẽ ghê tởm các ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ta sẽ làm cho các thành phố hoang vắng, nơi thánh tiêu điều, vì Ta không chấp nhận tế lễ dâng hương thơm của các ngươi nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ta sẽ làm cho lãnh thổ điêu tàn. Quân thù đồn trú trên ấy phải ngạc nhiên. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ta sẽ phân tán các ngươi khắp thiên hạ, và gươm giáo vẫn bám theo sau các ngươi. Thành phố, đất đai các ngươi bị tàn phá, hoang vu. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Đến lúc ấy, đất đai sẽ được nghỉ ngơi, trong khi các ngươi ở trên đất địch, đất sẽ được nghỉ ngơi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Vì các ngươi đã không để cho đất nghỉ năm thứ bảy suốt thời gian các ngươi còn ở trên đất mình. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Đối với những người sống sót tản mác trên đất địch, Ta sẽ làm cho lòng họ bồn chồn sợ hãi, tiếng lá rơi cũng đủ làm cho họ chạy trốn, họ sẽ chạy như chạy trốn người cầm gươm, và họ sẽ ngã dù chẳng ai rượt đuổi. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Dù không người rượt đuổi, họ sẽ chạy như chạy trốn người cầm gươm, vấp vào nhau, ngã xuống, vì không có sức đương đầu với quân địch. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Các ngươi sẽ chết ở quê lạ xứ người, xác bị chôn vùi nơi đất địch. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Những ai còn sống sót sẽ xác xơ tiều tụy trên đất kẻ thù—vì tội lỗi mình và tội lỗi của tổ tiên—cũng như tổ tiên mình trước kia đã tiều tụy xác xơ. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Nhưng nếu họ xưng nhận tội mình và tội của tổ tiên phạm vì chống nghịch Ta, đi ngược lại đường lối Ta, ");
INSERT INTO vieovcb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","khiến Ta chống cự họ, đưa họ vào đất địch, nếu tấm lòng đầy tội lỗi của họ biết hạ xuống, chấp nhận hình phạt vì tội lỗi mình, ");
INSERT INTO vieovcb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","thì Ta sẽ nhớ lại giao ước Ta đã kết với Gia-cốp, Y-sác, và Áp-ra-ham, và Ta sẽ nghĩ đến đất đai của họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Đất đai được hưởng thời kỳ nghỉ ngơi suốt thời gian bị bỏ hoang. Còn họ phải chịu trừng phạt vì đã từ khước luật Ta và coi thường lệnh Ta. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Tuy nhiên, khi họ ở trong đất địch, Ta không bỏ họ, không ghét họ đến nỗi tận diệt họ đi, không hủy giao ước đã kết với họ. Ta là Chúa Hằng Hữu, Đức Chúa Trời của họ. ");
INSERT INTO vieovcb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Lúc ấy, Ta sẽ nhớ lại giao ước Ta đã lập với tổ phụ họ, khi được Ta đem ra khỏi Ai Cập trước mắt các dân tộc lân bang, để làm Đức Chúa Trời của họ. Ta là Chúa Hằng Hữu, Đức Chúa Trời của họ.” ");
INSERT INTO vieovcb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Trên đây là các luật lệ, mệnh lệnh Chúa Hằng Hữu ban bố cho người Ít-ra-ên trong lúc nói chuyện với Môi-se trên Núi Si-nai. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Hãy nói với người Ít-ra-ên: Nếu một người có lời thề nguyện đặc biệt, hiến mình lên Chúa Hằng Hữu, thì người ấy sẽ trả số tiền quy định sau đây: ");
INSERT INTO vieovcb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Đàn ông từ hai mươi đến sáu mươi tuổi, 570 gam bạc, theo cân nơi thánh; ");
INSERT INTO vieovcb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","phụ nữ, 342 gam bạc. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Thanh thiếu niên từ năm đến hai mươi tuổi, 228 gam bạc; thiếu nữ trong hạn tuổi này, 114 gam bạc. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Các em trai từ một tháng cho đến năm tuổi, 57 gam bạc; các em gái trong hạn tuổi này, 34 gam bạc; ");
INSERT INTO vieovcb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","bậc lão thành nam giới trên sáu mươi tuổi, 171 gam bạc; bậc lão thành nữ giới trên sáu mươi, 114 gam bạc. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Nếu có người nghèo quá, không theo nổi số quy định trên, thì người ấy sẽ được đưa đến gặp thầy tế lễ, và thầy tế lễ sẽ ấn định số tiền phải trả tùy theo khả năng của người này. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Nếu một người thề nguyện hiến dâng một con vật nào lên Chúa Hằng Hữu, thì sinh lễ ấy sẽ là thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Người ấy không cần thay thế, cũng không được trao đổi con vật hứa dâng, dù đổi con tốt ra con xấu hay con xấu ra con tốt cũng vậy. Nếu đổi được như thế, cả hai con đều thuộc về Chúa. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Trường hợp một người hứa dâng một con vật thuộc loại không sạch (không được phép dâng lên Chúa Hằng Hữu), người ấy sẽ đem con vật đến cho thầy tế lễ định giá, ");
INSERT INTO vieovcb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","và sẽ trả theo giá thầy tế lễ đã định. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Trường hợp một người muốn chuộc lại con vật đã hứa dâng, người ấy phải trả thêm một phần năm giá trị con vật. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Nếu một người muốn dâng ngôi nhà của mình lên Chúa Hằng Hữu, thầy tế lễ sẽ tùy theo nhà xấu tốt mà định giá. Giá ấy được giữ cố định. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Về sau, nếu người dâng muốn chuộc nhà lại, phải trả thêm một phần năm giá đã định. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Nếu một người muốn dâng một phần đất của mình lên Chúa Hằng Hữu, sự định giá đất sẽ tùy theo lượng hạt giống người ta có thể gieo trên đất ấy. Một miếng đất gieo hết mười giạ hạt giống lúa mạch, được định giá 570 gam bạc. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Nếu đất được dâng từ Năm Hân Hỉ, giá trị đất sẽ bằng giá quy định. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Nhưng nếu dâng sau Năm Hân Hỉ, thầy tế lễ sẽ tính giá tùy theo số năm còn lại cho đến Năm Hân Hỉ; vậy giá trị đất này sẽ nhỏ hơn giá quy định. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Nếu một người muốn chuộc lại đất vừa dâng, người ấy phải trả thêm một phần năm giá trị của đất. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Trường hợp người dâng không muốn chuộc đất hoặc đã bán đất cho người khác, đất sẽ không trở về với người ấy nữa. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Đến Năm Hân Hỉ, khi đất được hoàn lại nguyên chủ, phần đất này sẽ thuộc về Chúa Hằng Hữu, vì đã hiến dâng cho Ngài làm đất thánh, và sẽ được chia cho các thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Nếu một người muốn dâng lên Chúa Hằng Hữu một miếng đất người ấy đã mua chứ không phải đất thừa hưởng của gia đình, ");
INSERT INTO vieovcb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","thầy tế lễ sẽ tính giá đất ấy cho đến Năm Hân Hỉ, và nội ngày ấy, người dâng phải đem số tiền bằng giá đất vừa chiết tính đến dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Đến Năm hân Hỉ, đất này sẽ thuộc về nguyên chủ tức là người bán. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","(Việc định giá phải theo tiêu chuẩn tiền tệ và cân nơi thánh.) ");
INSERT INTO vieovcb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Không ai được hiến dâng lên Chúa Hằng Hữu các con đầu lòng của súc vật mình, dù là bò hay chiên, vì các con đầu lòng vốn thuộc về Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Nhưng nếu con vật đem dâng thuộc loại không sạch (không được phép dâng lên Chúa Hằng Hữu), thầy tế lễ sẽ định giá con vật, và người dâng phải trả thêm một phần năm giá trị con vật ấy. Nếu người dâng không chuộc theo lối trả tiền này, thì phải đem bán con vật theo giá đã định. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ngoài ra, những vật khác đã được hiến dâng lên Chúa Hằng Hữu rồi, dù là người, thú vật, hay đất đai của gia đình, thì không được đem bán hay cho chuộc, vì các lễ vật ấy đã trở nên rất thánh đối với Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Không ai được hiến dâng, hoặc chuộc lại một người can tội tử hình. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Tất cả một phần mười thổ sản, dù là ngũ cốc hay hoa quả, đều thuộc về Chúa Hằng Hữu, và là vật thánh. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Nếu ai muốn chuộc phần ngũ cốc hay hoa quả này, phải trả thêm một phần năm giá trị của nó. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Đối với thú vật, dù là bò hay chiên, cứ dùng gậy mà đếm, mỗi con thứ mười đều thuộc về Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Không ai được xét xem các con thứ mười xấu hay tốt, cũng không được đổi các con ấy. Nếu đổi, cả con đổi lẫn con bị đổi đều xem như thánh và thuộc về Chúa Hằng Hữu. Cũng không ai được chuộc các thú vật này.” ");
INSERT INTO vieovcb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Trên đây là các mệnh lệnh Chúa Hằng Hữu ban bố cho Môi-se tại Núi Si-nai để truyền lại cho người Ít-ra-ên.");
INSERT INTO vieovcb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Vào ngày mồng một tháng hai, năm thứ hai, tính từ ngày Ít-ra-ên ra khỏi Ai Cập, Chúa Hằng Hữu phán bảo Môi-se tại Đền Tạm trong hoang mạc Si-nai: ");
INSERT INTO vieovcb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Hãy kiểm kê dân số của toàn dân Ít-ra-ên tùy theo họ hàng và gia đình, liệt kê danh sách tất cả nam đinh từng người một. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Con và A-rôn phải đem tất cả người nam trong Ít-ra-ên theo từng đơn vị, từ hai mươi tuổi trở lên, là những người có khả năng phục vụ trong quân đội. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Các trưởng đại tộc sẽ đại diện cho đại tộc mình để cộng tác với con và A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Đây là danh sách những người đứng ra giúp các con: Đại tộc Ru-bên, có Ê-li-sua, con của Sê-đêu. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Đại tộc Si-mê-ôn, có Sê-lu-mi-ên, con của Xu-ri-ha-đai. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Đại tộc Giu-đa, có Na-ha-sôn, con của A-mi-na-đáp. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Đại tộc Y-sa-ca, có Na-tha-na-ên, con của Xu-a. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Đại tộc Sa-bu-luân, có Ê-li-áp, con của Hê-lôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Con cháu Giô-sép: Đại tộc Ép-ra-im, có Ê-li-sa-ma, con của A-mi-hút. Đại tộc Ma-na-se, có Ga-ma-li-ên, con của Phê-đát-su. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Đại tộc Bên-gia-min, có A-bi-đan, con của Ghi-đeo-ni. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Đại tộc Đan, có A-hi-ê-xe, con của A-mi-sa-đai. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Đại tộc A-se, có Pha-ghi-ên, con của Óc-ran. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Đại tộc Gát, có Ê-li-a-sáp, con của Đê-u-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Đại tộc Nép-ta-li, có A-hi-ra, con của Ê-nan.” ");
INSERT INTO vieovcb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Đó là những người được bổ nhiệm từ trong dân chúng, là trưởng các đại tộc của tổ phụ mình và là những người chỉ huy các đơn vị quân đội Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Môi-se và A-rôn tiếp nhận các người đã được nêu danh, ");
INSERT INTO vieovcb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","và triệu tập toàn thể dân chúng vào ngày mồng một tháng hai theo danh sách từng người một từ hai mươi tuổi trở lên, mỗi người đăng ký theo họ hàng và gia đình mình, ");
INSERT INTO vieovcb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","như Chúa Hằng Hữu đã truyền lệnh cho Môi-se. Môi-se kiểm kê dân số trong hoang mạc Si-nai: ");
INSERT INTO vieovcb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Đây là số nam đinh từ hai mươi tuổi trở lên có thể phục vụ trong quân đội, dòng dõi họ được liệt kê danh sách theo họ hàng và gia đình mình: Đại tộc Ru-bên (trưởng nam của Ít-ra-ên) có ");
INSERT INTO vieovcb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","46.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Đại tộc Si-mê-ôn ");
INSERT INTO vieovcb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","có 59.300 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Đại tộc Gát ");
INSERT INTO vieovcb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","có 45.650 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Đại tộc Giu-đa ");
INSERT INTO vieovcb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","có 74.600 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Đại tộc Y-sa-ca ");
INSERT INTO vieovcb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","có 54.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Đại tộc Sa-bu-luân ");
INSERT INTO vieovcb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","có 57.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Đại tộc Ép-ra-im con của Giô-sép ");
INSERT INTO vieovcb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","có 40.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Đại tộc Ma-na-se, con của Giô-sép ");
INSERT INTO vieovcb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ma-na-se con trai của Giô-sép có 32.200 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Đại tộc Bên-gia-min ");
INSERT INTO vieovcb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","có 35.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Đại tộc Đan ");
INSERT INTO vieovcb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","có 62.700 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Đại tộc A-se ");
INSERT INTO vieovcb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","có 41.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Đại tộc Nép-ta-li ");
INSERT INTO vieovcb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nép-ta-li có 53.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Đó là những người mà Môi-se, A-rôn, và mười hai người lãnh đạo của Ít-ra-ên đã kiểm kê, mỗi trưởng đại tộc đại diện cho đại tộc mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Tất cả những người Ít-ra-ên từ hai mươi tuổi trở lên và có khả năng phục vụ trong quân đội Ít-ra-ên đều được kiểm kê theo gia đình mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Tổng số được 603.550 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Tuy nhiên, các gia đình của đại tộc Lê-vi không được kiểm kê như người các đại tộc khác. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Đừng kiểm kê đại tộc Lê-vi, hoặc bao gồm họ trong cuộc kiểm kê dân số của người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Nhưng cử người Lê-vi đặc trách Đền Giao Ước, coi sóc tất cả vật dụng và những gì thuộc về đền. Họ phải khuân vác Đền Tạm và tất cả các vật dụng, chăm sóc và cắm trại chung quanh đền. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Khi nào cần di chuyển, người Lê-vi phải tháo gỡ Đền Tạm; và mỗi khi dân chúng cắm trại, người Lê-vi sẽ dựng đền lại. Bất cứ người nào khác đến gần Đền Tạm sẽ bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Người Ít-ra-ên phải cắm trại theo từng đơn vị, mỗi người ở trong trại riêng dưới ngọn cờ của đại tộc mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Tuy nhiên người Lê-vi phải dựng trại chung quanh Đền Giao Ước để cơn thịnh nộ không đổ xuống trên người Ít-ra-ên. Người Lê-vi phải chịu trách nhiệm chăm sóc Đền Tạm.” ");
INSERT INTO vieovcb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Người Ít-ra-ên thực thi tất cả những điều Chúa Hằng Hữu truyền bảo Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Chúa Hằng Hữu phán dạy Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Người Ít-ra-ên phải cắm trại chung quanh nhưng cách xa Đền Tạm, mỗi người phải cắm trại dưới ngọn cờ của đơn vị mình với bảng hiệu đại tộc. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Trại quân Giu-đa, Y-ca-sa, và Sa-bu-luân sẽ cắm tại phía đông, hướng mặt trời mọc với ngọn cờ và các đơn vị mình. Đây là danh sách các đại tộc, người chỉ huy, và dân số của họ: Đại tộc Giu-đa, chỉ huy là Na-ha-sôn, con A-mi-na-đáp. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Quân số của người được 74.600 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Đại tộc Y-sa-ca, chỉ huy là Na-tha-na-ên, con Xu-a. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Quân số của người được 54.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Đại tộc Sa-bu-luân, chỉ huy là Ê-li-áp, con Hê-lôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Quân số của người được 57.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Tất cả nhân số trong trại quân Giu-đa, chia từng đội ngũ, được 186.400 người. Họ sẽ đi tiên phong. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Trại quân Ru-bên, Si-mê-ôn, và Gát sẽ cắm tại phía nam, dưới ngọn cờ mình. Đây là danh sách các đại tộc, người chỉ huy, và quân số của họ: Đại tộc Ru-bên, chỉ huy là Ê-li-sua, con Sê-đêu. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Quân số của người được 46.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Đại tộc Si-mê-ôn, chỉ huy là Sê-lu-mi-ên, con Xu-ri-ha-đai. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Quân số của người được 59.300 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Đại tộc Gát, chỉ huy là Ê-li-a-sáp, con Đê-u-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Quân số của người được 45.650 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Tất cả nhân số trong trại Ru-bên, chia từng đội ngũ, được 151.450 người. Họ sẽ đi thứ nhì. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sau đó, Đền Tạm và trại quân Lê-vi sẽ ra đi chính giữa các trại quân khác. Họ sẽ ra đi theo đúng thứ tự như họ đã cắm trại, mỗi người theo hàng ngũ dưới ngọn cờ mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Trại quân Ép-ra-im, Ma-na-se, và Bên-gia-min sẽ cắm tại phía tây, dưới ngọn cờ mình. Đây là danh sách các đại tộc, người chỉ huy, và quân số của họ: Đại tộc Ép-ra-im, chỉ huy là Ê-li-sa-ma, con A-mi-hút. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Quân số của người được 40.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Đại tộc Ma-na-se, chỉ huy là Ga-ma-li-ên, con Phê-đát-su. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Quân số của người được 32.200 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Đại tộc Bên-gia-min, chỉ huy là A-bi-đan, con Ghi-đeo-ni. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Quân số của người được 35.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Tất cả nhân số trong trại quân Ép-ra-im, chia từng đội ngũ, được 108.100 người. Họ sẽ đi thứ ba. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Trại quân Đan, A-se, và Nép-ta-li sẽ cắm trại phía bắc, dưới ngọn cờ mình. Đây là danh sách các đại tộc, người chỉ huy, và quân số của họ: Đại tộc Đan, chỉ huy là A-hi-ê-xe, con A-mi-sa-đai. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Quân số của người được 62.700 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Đại tộc A-se, chỉ huy là Pha-ghi-ên, con Óc-ran. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Quân số của người được 41.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Đại tộc Nép-ta-li, chỉ huy là A-hi-ra, con Ê-nan. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Quân số của người được 53.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Tất cả nhân số trong trại quân Đan, chia từng đội ngũ, được 157.600 người. Họ sẽ đi hậu tập.” ");
INSERT INTO vieovcb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Đó là những người Ít-ra-ên được kiểm kê theo từng đại tộc. Tổng số quân sĩ trong các trại quân, chia từng đội ngũ, là 603.550. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Tuy nhiên, người Lê-vi không được kiểm kê với những người Ít-ra-ên khác, như Chúa Hằng Hữu đã truyền bảo Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Như thế, người Ít-ra-ên thực thi mọi điều Chúa Hằng Hữu đã truyền bảo Môi-se. Đó là cách mà họ bố trí các trại quân dưới ngọn cờ mình; đó cũng là cách xuất quân mỗi người theo họ hàng và chi tộc mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Đây là những người trong gia đình A-rôn và Môi-se trong thời gian Chúa Hằng Hữu phán với Môi-se trên Núi Si-nai. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Tên các con trai A-rôn là: Na-đáp, con trưởng nam, A-bi-hu, Ê-lê-a-sa, và Y-tha-ma. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Đó là tên các con trai A-rôn, tức các thầy tế lễ được xức dầu và tấn phong để phục vụ trong chức tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Tuy nhiên, Na-đáp và A-bi-hu đã ngã chết trước mặt Chúa Hằng Hữu khi họ dâng hương lên Chúa Hằng Hữu trong hoang mạc Si-nai bằng một thứ lửa Ngài không cho phép. Họ không có con trai nên chỉ có Ê-lê-a-sa và Y-tha-ma phục vụ trong chức thầy tế lễ dưới sự hướng dẫn của A-rôn, cha họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Hãy đem đại tộc Lê-vi đến, đặt họ dưới quyền Thầy Tế lễ A-rôn để họ giúp đỡ người. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Họ phải thi hành các nhiệm vụ thay cho A-rôn và toàn thể dân chúng tại Đền Tạm bằng cách phục vụ trong Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Họ phải chăm sóc tất cả vật dụng trong lều thánh, thi hành các bổn phận của người Ít-ra-ên bằng cách phục vụ trong Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Trong vòng người Ít-ra-ên họ là những người duy nhất được giao trọn cho A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Con hãy bổ nhiệm A-rôn và các con trai người làm thầy tế lễ. Bất cứ người nào khác xâm phạm vào chức vụ này sẽ bị xử tử.” ");
INSERT INTO vieovcb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ta đã chọn người Lê-vi giữa những người Ít-ra-ên để thay thế cho các con trai đầu lòng của người Ít-ra-ên. Người Lê-vi thuộc về Ta, ");
INSERT INTO vieovcb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","vì tất cả con trai đầu lòng đều thuộc về Ta. Khi Ta đánh hạ tất cả con đầu lòng tại Ai Cập, Ta đã biệt riêng cho Ta tất cả con đầu lòng của Ít-ra-ên, cả người lẫn thú vật. Họ phải thuộc về Ta. Ta là Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Chúa Hằng Hữu phán bảo Môi-se tại hoang mạc Si-nai: ");
INSERT INTO vieovcb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Hãy kiểm kê dân số người Lê-vi tùy theo gia tộc và họ hàng. Con hãy kiểm kê tất cả người nam từ một tháng trở lên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Như vậy, Môi-se kiểm kê họ đúng như lời Chúa Hằng Hữu truyền bảo mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Đây là tên các con trai Lê-vi: Ghẹt-sôn, Kê-hát, và Mê-ra-ri. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Đây là tên con trai Ghẹt-sôn: Líp-ni và Si-mê-i. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Gia tộc từ Kê-hát là: Am-ram, Dít-sa, Hếp-rôn, và U-xi-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Con trai Mê-ra-ri là: Mách-li và Mu-si. Đó là những tổ các thị tộc trong đại tộc Lê-vi. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Con cháu Líp-ni là Si-mê-i thuộc về Ghẹt-sôn; đó là dòng họ Ghẹt-sôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Tổng số người nam từ một tháng trở lên được 7.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Dòng họ Ghẹt-sôn phải cắm trại phía tây phía sau Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Người lãnh đạo gia tộc Ghẹt-sôn là Ê-li-a-sáp, con La-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Trách nhiệm của dòng họ Ghẹt-sôn tại Đền Tạm là trông coi lều, mái phủ lều, bức màn nơi cửa, ");
INSERT INTO vieovcb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","các bức màn trong hành lang, bức màn tại cửa hành lang bao quanh Đền Tạm và bàn thờ, và các sợi dây thừng cùng tất cả dịch vụ bảo quản những thứ đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Dòng họ Am-ram, Dít-sê-ha, Hếp-rôn, và U-xi-ên thuộc về Kê-hát; đó là dòng họ Kê-hát. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Tổng số người nam từ một tuổi trở lên được 8.600 người. Dòng họ Kê-hát chịu trách nhiệm chăm sóc nơi thánh. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Dòng họ Kê-hát phải cắm trại phía nam Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Người lãnh đạo gia tộc Kê-hát là Ê-li-sa-phan, con U-xi-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Họ chịu trách nhiệm chăm sóc Hòm Giao Ước, cái bàn, chân đèn, các bàn thờ, và bảo quản những thứ đó, cùng tấm màn, và các vật dụng phụ thuộc. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Đứng đầu các vị lãnh đạo đại tộc Lê-vi là Ê-lê-a-sa, con trai Thầy Tế lễ A-rôn; ông giám sát những người chịu trách nhiệm coi sóc nơi thánh. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Họ hàng Mách-li và họ hàng Mu-si thuộc về Mê-ra-ri; đó là dòng họ Mê-ra-ri. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Tổng số người nam từ một tháng trở lên được 6.200 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Người lãnh đạo gia tộc Mê-ra-ri là Xu-ri-ên, con A-bi-hai: Họ phải cắm trại phía bắc Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Người Mê-ra-ri được bổ nhiệm coi sóc các khung của Đền Tạm, các cây xà ngang, các cây cột, đế cột, cùng tất cả các vật dụng. Họ chịu trách nhiệm bảo quản những thứ đó ");
INSERT INTO vieovcb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","cùng coi sóc các cây cột và đế cột chung quanh hành lang, các cây cọc, và dây thừng. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Môi-se và A-rôn cùng các con trai người phải cắm trại ở phía đông Đền Tạm, về phía mặt trời mọc ngay trước Trại Hội Kiến. Họ phải chịu trách nhiệm coi sóc nơi thánh thay cho người Ít-ra-ên. Người nào xâm phạm đến gần nơi thánh sẽ bị xử tử. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tổng số người Lê-vi được kiểm kê theo lệnh Chúa Hằng Hữu truyền cho Môi-se và A-rôn, chia theo từng họ hàng, tức là các con trai từ một tháng trở lên, được 22.000 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Chúa Hằng Hữu phán dạy Môi-se: “Con hãy kiểm kê tất cả con trai đầu lòng người Ít-ra-ên từ một tháng trở lên, và lập bảng danh sách. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Con hãy thu nhận cho Ta người Lê-vi thay cho tất cả con đầu lòng người Ít-ra-ên, và các bầy gia súc của người Lê-vi thay cho tất cả con đầu lòng của gia súc người Ít-ra-ên. Ta là Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Như thế, Môi-se kiểm kê tất cả con đầu lòng của người Ít-ra-ên, như Chúa Hằng Hữu đã truyền bảo người. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Tổng số con trai đầu lòng liệt kê từng tên, được 22.273. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Con hãy thu nhận người Lê-vi thay cho tất cả con đầu lòng người Ít-ra-ên và gia súc của người Lê-vi thay cho gia súc của người Ít-ra-ên. Người Lê-vi sẽ thuộc về Ta; Ta là Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Về phần 273 con đầu lòng Ít-ra-ên là số trội hơn tổng số người Lê-vi, ");
INSERT INTO vieovcb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","con hãy chuộc lại bằng cách thu mỗi người năm miếng bạc theo tiêu chuẩn cân đo trong nơi thánh. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Hãy giao số bạc chuộc các người Ít-ra-ên phụ trội đó cho A-rôn và các con trai người.” ");
INSERT INTO vieovcb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Như thế, Môi-se thu bạc chuộc của những người phụ trội đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Môi-se thu được 15,5 ký bạc (theo tiêu chuẩn cân đo trong nơi thánh) của mỗi con đầu lòng người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Môi-se giao bạc chuộc đó cho A-rôn và các con trai người, đúng như lời Chúa Hằng Hữu đã truyền bảo mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Chúa Hằng Hữu phán dạy Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Hãy kiểm kê dân số người Kê-hát, tức là một gia tộc trong đại tộc Lê-vi, theo từng họ hàng và gia đình. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Con hãy kiểm kê tất cả người nam từ ba mươi đến năm mươi tuổi, trong lứa tuổi phục vụ để họ đảm nhiệm công tác tại Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Đây là công việc của người Kê-hát tại Đền Tạm: Chăm sóc các vật chí thánh. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Khi nào trại quân dời đi, A-rôn và các con trai người phải vào gỡ bức màn ngăn che nơi thánh và phủ lên Hòm Giao Ước, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","rồi phủ lên trên các tấm da cá heo, trải tấm vải màu xanh lên trên cùng, rồi sửa đòn khiêng cho ngay ngắn. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Họ sẽ trải lên bàn đựng Bánh Thánh tấm khăn xanh rồi đặt lên khăn các đĩa, tô, chén, và các bình dùng dâng rượu; Bánh Thánh dâng liên tục vẫn để y trên bàn. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Trên tất cả những vật ấy, họ phải trải một tấm khăn đỏ thẫm, và trên cùng, phủ lên các tấm da cá heo, rồi xỏ đòn khiêng vào. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Họ phải lấy một tấm khăn xanh phủ lên giá đèn để thắp sáng và các cây đèn, kéo cắt tim đèn và khay, và các bình đựng dầu để thắp đèn; ");
INSERT INTO vieovcb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","rồi bọc giá đèn và các đồ phụ tùng bằng tấm da cá heo, rồi đặt lên một đòn khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Họ cũng phải trải một tấm khăn xanh trên bàn thờ bằng vàng, và phủ lên bằng các tấm da cá heo, rồi xỏ đòn khiêng vào. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Tất cả vật dụng trong việc phục vụ tại nơi thánh phải gói lại trong một tấm vải xanh và phủ lên bằng các tấm da cá heo. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Họ phải hốt tro tại bàn thờ bằng đồng, trải lên bàn thờ một tấm vải màu tím. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Đặt tất cả khí dụng tế lễ lên trên: Các lư hương, nĩa, vá và bát dùng vào việc rảy nước, tất cả phụ tùng bàn thờ, rồi phủ lên các tấm da cá heo và xỏ đòn khiêng vào. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Sau khi A-rôn và các con trai người đậy xong nơi thánh và các khí dụng thánh, và khi trại quân sẵn sàng dời đi, dòng họ Kê-hát phải đến khuân vác, nhưng họ không được chạm đến các vật thánh kẻo bị thiệt mạng. Dòng họ Kê-hát phải khuân vác các vật dụng trong Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Thầy Tế lễ Ê-lê-a-sa, con trai A-rôn, có nhiệm vụ lo về dầu thắp đèn, hương liệu, lễ vật chay hằng dâng và dầu xức; cũng phải coi sóc cả Đền Tạm và các vật dụng bên trong, kể cả các đồ bạc và vật dụng thánh.” ");
INSERT INTO vieovcb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Chúa Hằng Hữu lại phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Đừng để gia tộc Kê-hát phải bị tiêu diệt. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Đây là điều phải làm để giữ họ khỏi chết khi vào nơi thánh. A-rôn và các con của người sẽ vào nơi đó với họ, chỉ cho mỗi người vật gì họ phải khiêng. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Tuyệt đối không ai được vào nơi đó để nhìn các vật thánh, dù chỉ trong giây lát, ai bất tuân đều phải chết.” ");
INSERT INTO vieovcb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Cũng hãy kiểm kê các con cháu Ghẹt-sôn, tùy theo gia tộc và họ hàng họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Từ ba mươi tuổi đến năm mươi tuổi, gồm những người trong lứa tuổi phục vụ, để họ đảm nhiệm công tác tại Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Đây là công việc của gia tộc Ghẹt-sôn phải làm và khiêng: ");
INSERT INTO vieovcb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Họ sẽ khiêng các bức màn của Đền Tạm, nóc của Đền Tạm, tấm da phủ nóc đền, tấm màn che cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Các màn quanh hành lang, màn che cửa hành lang, hành lang bao quanh Đền Tạm và bàn thờ, dây thừng và các dụng cụ khác. Những người thuộc gia tộc Ghẹt-sôn có nhiệm vụ di chuyển các vật ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Hết thảy công việc của con cháu Ghẹt-sôn, món chi họ phải khiêng đi, và việc chi họ phải làm đều sẽ theo lệnh A-rôn và các con trai người chỉ bảo. Họ phải giao cho người Ghẹt-sôn coi sóc các món chi phải khiêng đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Trong Đền Tạm, ấy là công việc của các họ hàng con cháu Ghẹt-sôn. Họ sẽ giữ chức phận mình dưới quyền cai trị của Y-tha-ma, con trai Thầy Tế lễ A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ngươi phải kiểm kê con cháu Mê-ra-ri, tùy theo họ hàng và gia tộc của họ, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","từ ba mươi tuổi đến năm mươi, tức là hết thảy những người trong lứa tuổi phục vụ, để họ đảm nhiệm công tác tại Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Họ sẽ khiêng khung trại, các thanh ngang, trụ và đế trụ, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","trụ hành lang, đế trụ, cọc lều, dây và các đồ phụ tùng. Khi phân công người nào khiêng vật gì phải lập danh sách rõ ràng. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Trên đây là nhiệm vụ của dòng họ Mê-ra-ri tại Đền Tạm dưới sự hướng dẫn của Y-tha-ma, con trai Thầy Tế lễ A-rôn.” ");
INSERT INTO vieovcb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Vậy, Môi-se, A-rôn, và các nhà lãnh đạo dân chúng bắt đầu kiểm kê gia tộc Kê-hát, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","gồm những người trong lứa tuổi phục vụ, từ ba mươi đến năm mươi tuổi, để đảm nhiệm công tác tại Đền Tạm, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","có được 2.750 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Đó là tổng số người Kê-hát phục vụ tại Đền Tạm do Môi-se và A-rôn kiểm kê theo lời Chúa Hằng Hữu truyền cho Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Còn con cháu Ghẹt-sôn đã được kiểm kê, tùy theo họ hàng và gia tộc của họ, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","từ ba mươi đến năm mươi tuổi, tức là hết thảy những người trong lứa tuổi phục vụ đảm nhiệm công tác tại Đền Tạm, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","cộng được 2.630. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Đó là những người về gia tộc Ghẹt-sôn đã được kiểm kê, tức là những người phục vụ trong Đền Tạm mà Môi-se và A-rôn tu bộ y theo lệnh của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Còn những người thuộc về gia tộc Mê-ra-ri đã được kiểm kê, tùy theo gia tộc và họ hàng của họ, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","từ ba mươi đến năm mươi tuổi, tức là mọi người có khả năng phục vụ trong trại, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","cộng được 3.200 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Đó là những người về các gia tộc Mê-ra-ri đã được kiểm kê. Môi-se và A-rôn kiểm kê dân số, y theo lệnh của Chúa Hằng Hữu đã cậy Môi-se truyền dạy. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Hết thảy những người Lê-vi mà Môi-se, A-rôn, và các trưởng tộc Ít-ra-ên kiểm kê, tùy theo họ hàng và gia tộc của họ, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","từ ba mươi đến năm mươi tuổi, tức là mọi người đến phục vụ và khuân vác đồ trong Đền Tạm, ");
INSERT INTO vieovcb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","cộng được 8.580 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Người ta kiểm kê người Lê-vi theo lệnh Chúa Hằng Hữu đã cậy Môi-se truyền dạy, cắt phần cho mỗi người việc mình phải làm, và vật chi mình phải khiêng đi; người ta kiểm kê dân số theo lời Chúa Hằng Hữu đã phán dạy Môi-se vậy. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Hãy dạy người Ít-ra-ên phải trục xuất những người phong hủi, người mắc bệnh lậu, và người bị ô uế vì đụng vào xác người chết ra khỏi trại quân. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Dù họ là đàn ông hay đàn bà cũng phải trục xuất để họ không làm ô uế trại quân, vì Ta ở giữa trại dân Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Người Ít-ra-ên vâng lời Chúa Hằng Hữu phán cùng Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Vậy, Chúa Hằng Hữu phán bảo Môi-se dạy người Ít-ra-ên: ");
INSERT INTO vieovcb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Khi một người—dù đàn ông hay đàn bà—phạm tội mà vi phạm luật Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","người ấy phải xưng tội, bồi thường thiệt hại do mình gây ra, cộng thêm một phần năm số ấy cho nạn nhân. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Trường hợp nạn nhân không còn bà con gần để nhận bồi thường, số bồi thường phải nộp cho Chúa Hằng Hữu, và số ấy sẽ thuộc về thầy tế lễ, cộng thêm một con chiên để làm lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Như vậy, khi người Ít-ra-ên đem dâng lên Chúa vật gì, vật ấy sẽ thuộc về các thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Những vật biệt riêng ra thánh mà mỗi người dâng sẽ thuộc về người; vật chi mỗi người ban cho thầy tế lễ, chắc sẽ thuộc về người vậy.” ");
INSERT INTO vieovcb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Hãy phán dạy người Ít-ra-ên rằng: Nếu một người đàn bà ngoại tình ");
INSERT INTO vieovcb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nhưng nàng giấu kín, không bị bắt quả tang, cũng không có nhân chứng, ");
INSERT INTO vieovcb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","và nếu người chồng đâm nghi, nổi ghen, ");
INSERT INTO vieovcb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","thì người ấy nên đưa vợ mình đến gặp thầy tế lễ, cũng đem theo một lễ vật gồm 2,2 lít bột lúa mạch không pha dầu, không rắc nhũ hương lên trên, vì là một tế lễ chay về sự ghen tuông, một tế lễ chay để ghi nhớ về tội lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Thầy tế lễ sẽ đem người đó đến trước Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","đổ nước thánh vào một cái bình bằng đất, bốc bụi dưới sàn Đền Tạm bỏ vào. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Thầy tế lễ sẽ bảo người đứng trước mặt Chúa Hằng Hữu, lột trần đầu người, đặt lễ vật hồi tưởng vào tay; còn tay thầy tế lễ cầm bình nước đắng nguyền rủa. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Thầy tế lễ bảo người ấy thề rồi nói: ‘Nếu không có ai nằm với ngươi ngoài chồng ngươi thì ngươi sẽ không chịu ảnh hưởng của nước đắng nguyền rủa này. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Nhưng nếu ngươi lỗi đạo với chồng và ngoại tình với người nam khác, ");
INSERT INTO vieovcb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","cầu Chúa Hằng Hữu khiến cho ngươi trở nên một mầm rủa sả và trù ẻo giữa vòng dân tộc ngươi, làm cho ngươi ốm lòi hông và phình bụng lên; ");
INSERT INTO vieovcb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","nước đắng rủa sả này khá chui vào ruột gan làm cho bụng ngươi phình lên và ốm lòi hông.’ Nàng sẽ nói: ‘Xin cứ đúng như thế.’ ");
INSERT INTO vieovcb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Thầy tế lễ viết những lời nguyền rủa này vào sách, rồi rửa sách trong nước đắng. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Khi người ấy uống nước đắng nguyền rủa, nó sẽ gây nhiều cay đắng trong bụng. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Thầy tế lễ sẽ lấy lễ vật hồi tưởng khỏi tay người ấy, đem dâng đưa qua đưa lại trước Chúa Hằng Hữu, rồi đem lễ vật đến trước bàn thờ, ");
INSERT INTO vieovcb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","bốc một nắm bột tượng trưng cho toàn thể lễ vật, đem đốt trên bàn thờ, rồi bảo người ấy uống nước. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Nếu người đó ngoại tình, thì nước sẽ trở nên đắng trong bụng, bụng phình lên, đùi rữa nát, dân chúng sẽ nhắc đến người ấy mỗi khi nguyền rủa, thề thốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Nhưng nếu trong sạch, thì người ấy sẽ không bị hại mà vẫn có thể sinh nở. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Đó là luật trường hợp về sự ghen tuông khi một người đàn bà, ở dưới quyền chồng mình, lỗi đạo và bị ô uế, ");
INSERT INTO vieovcb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","hoặc khi nào tính ghen phát sinh nơi người chồng mà ghen vợ mình: Người phải đem vợ đến trước mặt Chúa Hằng Hữu và thầy tế lễ sẽ làm cho nàng hết thảy điều chi luật lệ này đã truyền dạy. ");
INSERT INTO vieovcb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Người chồng sẽ không có tội, mặc dù hậu quả tai hại xảy ra cho vợ mình, trong trường hợp vợ ngoại tình thật.” ");
INSERT INTO vieovcb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Khi một người—dù đàn ông hay đàn bà—có lời khấn nguyện để làm người Na-xi-rê hiến dâng mình đặc biệt cho Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","người ấy sẽ kiêng uống rượu và thức uống làm cho say, cũng không được uống giấm làm bằng rượu hoặc bằng một chất lên men. Cả đến nước ép nho cũng không được uống và không được phép ăn nho tươi hay khô. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Suốt thời gian biệt mình riêng cho Chúa Hằng Hữu làm người Na-xi-rê, người ấy không được ăn uống bất cứ món nào từ cây nho, kể cả hạt nho và vỏ trái nho. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Suốt thời gian thề nguyện biệt mình làm người Na-xi-rê, người không được cạo đầu. Trọn những ngày người biệt mình riêng cho Chúa Hằng Hữu, làm người Na-xi-rê, tóc người cũng được biệt riêng ra thánh và người phải để cho tóc mình mọc dài, không được cắt tỉa. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Cũng không được đến gần xác chết trong suốt thời gian dâng mình cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Đừng vì cha hay mẹ, vì anh em hay chị em. Không được vì người chết làm cho mình bị ô uế, vì lời khấn nguyện hiến dâng mình cho Đức Chúa Trời vẫn ở trên đầu người ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Suốt thời gian dâng mình, người ấy phải là người thánh cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Nếu có người chết đột ngột bên cạnh làm cho người này bị ô uế, thì bảy ngày sau, người ấy sẽ cạo đầu mình và được sạch lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ngày thứ tám, người ấy sẽ đem đến cửa Đền Tạm cho thầy tế lễ hai con chim cu đất hoặc hai con bồ câu con. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Thầy tế lễ dâng một con làm lễ chuộc tội, một con làm lễ thiêu để chuộc tội cho người ấy, vì đã bị xác chết làm ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Cùng trong ngày đó, người ấy sẽ lập lại lời khấn nguyện dâng mình với Chúa Hằng Hữu, và thời gian trước khi bị ô uế không được tính vào thời gian thâm niên. Người ấy sẽ đem một con chiên đực một tuổi làm lễ chuộc lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Đây là luật cho người Na-xi-rê. Đến ngày cuối cùng của thời hạn dâng mình cho Chúa, người ấy sẽ đến trước cửa Đền Tạm, ");
INSERT INTO vieovcb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","dâng lễ vật lên Chúa Hằng Hữu gồm một con chiên đực một tuổi, không tì vít, để làm lễ thiêu; một con chiên cái một tuổi, không tì vít, làm lễ chuộc tội; một con chiên đực, không tì vít, làm lễ thù ân; ");
INSERT INTO vieovcb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","một giỏ bánh không men, gồm bánh làm bằng bột mịn pha dầu; bánh kẹp không men tẩm dầu; lễ vật ngũ cốc và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Thầy tế lễ sẽ dâng các lễ vật này lên Chúa Hằng Hữu làm tế lễ chuộc tội và tế lễ thiêu, ");
INSERT INTO vieovcb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","sau đó dâng con chiên đực, kèm theo giỏ bánh không men, ngũ cốc và rượu, làm tế lễ thù ân dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Người Na-xi-rê, tức người có lời khấn nguyện dâng mình đặc biệt cho Chúa, sẽ cạo đầu mình tại cửa Đền Tạm, lấy tóc đốt trong lửa cháy bên dưới lễ vật thù ân. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Thầy tế lễ sẽ lấy cái vai chiên (lúc ấy thịt đã chín), một cái bánh không men, một cái bánh kẹp không men, đem đặt vào tay của người Na-xi-rê. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Xong, thầy tế lễ lấy lại các món đó để dâng đưa qua lại trước Chúa Hằng Hữu (các món này cũng như cái ức dâng đưa qua đưa lại và cái đùi dâng đưa lên, là những vật thánh, về sau sẽ về phần thầy tế lễ). Sau các thủ tục trên, người Na-xi-rê lại được phép uống rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Đó là luật quy định về người Na-xi-rê đã có lời khấn nguyện. Ngoài các lễ vật quy định trên, nếu người ấy có khấn nguyện dâng thêm vật gì lúc ban đầu, thì phải thực hiện đúng như vậy.” ");
INSERT INTO vieovcb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Chúa Hằng Hữu phán dạy Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Hãy bảo A-rôn và các con trai người chúc phước cho người Ít-ra-ên như sau: ");
INSERT INTO vieovcb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Cầu xin Chúa Hằng Hữu ban phước và phù hộ anh chị em. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Cầu xin vinh quang của diện mạo Chúa Hằng Hữu soi sáng anh chị em. ");
INSERT INTO vieovcb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Cầu xin Chúa Hằng Hữu tỏ lòng nhân từ với anh chị em, làm ơn và ban bình an cho anh chị em.’ ");
INSERT INTO vieovcb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Vậy, các thầy tế lễ đặt Danh Ta trên người Ít-ra-ên, và chính Ta sẽ ban phước cho dân này.” ");
INSERT INTO vieovcb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Vào ngày dựng xong Đền Tạm, Môi-se xức dầu và thánh hóa đền, bàn thờ, đồ phụ tùng, và mọi vật bên trong. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Vào hôm ấy, các nhà lãnh đạo của Ít-ra-ên—các trưởng tộc, những người đã điều khiển cuộc kiểm kê dân số—đều đến. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Họ đem lễ vật đến trước Đền Tạm, dâng lên Chúa Hằng Hữu các lễ vật, gồm có sáu cỗ xe và mười hai con bò kéo. Cứ hai tộc trưởng dâng một cỗ xe và mỗi người dâng một con bò. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Hãy nhận các xe của họ rồi đem phân phối cho người Lê-vi, để sử dụng cho việc di chuyển Đền Tạm.” ");
INSERT INTO vieovcb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Môi-se nhận lễ vật rồi đem phân phối cho người Lê-vi. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gia tộc Ghẹt-sôn: Hai cỗ xe và bốn con bò; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","gia tộc Mê-ra-ri: Bốn cỗ xe và tám con bò. Gia tộc này đặt dưới quyền điều khiển của Y-tha-ma, con Thầy Tế lễ A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Môi-se không giao cho gia tộc Kê-hát xe cộ gì cả, vì họ có bổn phận khuân vác các vật thánh của Đền Tạm trên vai. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Các trưởng tộc cũng đem lễ vật đến dâng trên bàn thờ trong ngày bàn thờ được xức dầu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Chúa Hằng Hữu phán bảo Môi-se: “Hãy dành cho mỗi trưởng tộc một ngày để họ dâng lễ vật trong dịp cung hiến bàn thờ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Vậy, vào ngày thứ nhất, Na-ha-sôn, con A-mi-na-đáp, trưởng tộc Giu-đa, đem dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Lễ vật gồm một đĩa bạc nặng khoảng 1,5 ký, một bát bạc nặng 0,8 ký, cả đĩa và bát đều đựng đầy bột mịn trộn dầu—đó là lễ vật ngũ cốc. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Một đĩa vàng nặng 114 gam đựng đầy nhũ hương. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Một bò tơ đực, một chiên đực, một chiên con một tuổi dùng làm sinh tế thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","một dê đực dùng làm sinh tế chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","hai bò đực, năm chiên đực, năm dê đực, năm chiên con một tuổi—tất cả dùng làm lễ vật thù ân. Đó là lễ vật của Na-ha-sôn, con trai A-mi-na-đáp. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Vào ngày thứ hai, Na-tha-na-ên, con Xu-a, trưởng đại tộc Y-sa-ca, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Các lễ vật của ông gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký theo tiêu chuẩn cân đo nơi thánh: Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Na-tha-na-ên, con của Xu-a. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Vào ngày thứ ba, Ê-li-áp con của Hê-lôn, trưởng đại tộc Sa-bu-luân, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Ê-li-áp, con của Hê-lôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Vào ngày thứ tư, Ê-li-sua, con của Sê-đêu, trưởng đại tộc Ru-bên, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Ê-li-sua, con của Sê-đêu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Vào ngày thứ năm, Sê-lu-mi-ên, con Xu-ri-ha-đai, trưởng đại tộc Si-mê-ôn, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Sê-lu-mi-ên, con của Xu-ri-ha-đai. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Vào ngày thứ sáu, Ê-li-a-sáp, con Đê-u-ên, trưởng đại tộc Gát, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Một cái chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Ê-li-a-sáp, con của Đê-u-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Vào ngày thứ bảy, Ê-li-sa-ma, con A-mi-hút, trưởng đại tộc Ép-ra-im, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Một cái chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Ê-li-sa-ma, con của A-mi-hút. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Vào ngày thứ tám, Ga-ma-li-ên, con Phê-đát-su, trưởng đại tộc Ma-na-se, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Ga-ma-li-ên, con của Phê-đát-su. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Vào ngày thứ chín, A-bi-đan, con Ghi-đeo-ni, trưởng đại tộc Bên-gia-min, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của A-bi-đan, con của Ghi-đeo-ni. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Vào ngày thứ mười, A-hi-ê-xe, con của A-mi-sa-đai, trưởng đại tộc Đan, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của A-hi-ê-xe, con của A-mi-sa-đai. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Vào ngày thứ mười một, Pha-ghi-ên, con Óc-ran, trưởng đại tộc A-se, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của Pha-ghi-ên, con của Óc-ran. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Vào ngày thứ mười hai, A-hi-ra, con Ê-nan, trưởng tộc Nép-ta-li, dâng lễ vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Lễ vật người gồm có một đĩa bạc nặng 1,5 ký và một bát nặng 0,8 ký, theo tiêu chuẩn cân đo nơi thánh. Cả hai cái đều đầy bột lọc nhồi dầu, làm tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Một chén bằng vàng nặng 114 gam đựng đầy hương liệu. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Một bò đực tơ, một chiên đực, và một chiên con một tuổi làm tế lễ thiêu; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","một dê đực làm tế lễ chuộc tội; ");
INSERT INTO vieovcb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","hai bò đực, năm chiên đực, năm dê đực, và năm chiên con đực một tuổi làm tế lễ cầu an. Đó là các lễ vật của A-hi-ra, con của Ê-nan. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Đó là các lễ vật của các trưởng đại tộc người Ít-ra-ên dâng hiến trong lễ khánh thành bàn thờ, khi bàn thờ được xức dầu: Mười hai đĩa bạc, mười hai chậu bạc, mười hai chén vàng. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Mỗi đĩa bạc nặng 1,5 ký và mỗi bát nặng 0,8 ký. Tổng cộng đĩa và bát được 27,6 ký bạc, theo tiêu chuẩn cân đo nơi thánh. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Mười hai chén vàng đựng dầu hương liệu, mỗi cái cân nặng 114 gam, theo tiêu chuẩn cân đo nơi thánh, tổng cộng được 1,4 ký vàng. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ngoài ra, họ còn dâng mười hai bò đực, mười hai chiên đực, mười hai chiên con một tuổi làm sinh tế thiêu, dâng chung với lễ vật ngũ cốc; mười hai dê đực làm sinh tế chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Hai mươi bốn bò đực tơ, sáu mươi chiên đực, sáu mươi dê đực, sáu mươi chiên con một tuổi làm lễ vật thù ân. ");
INSERT INTO vieovcb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Khi Môi-se vào Đền Tạm thưa chuyện với Chúa Hằng Hữu, ông nghe tiếng Chúa Hằng Hữu phán dạy vang ra từ trên nắp chuộc tội, trên Hòm Giao Ước, giữa hai chê-ru-bim. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Chúa Hằng Hữu phán bảo Môi-se dặn A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Hãy sắp xếp bảy ngọn đèn trên chân đèn thế nào cho ánh sáng chiếu thẳng ra phía trước.” ");
INSERT INTO vieovcb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","A-rôn vâng lời, xếp cho đèn chiếu thẳng ra. Như lời Chúa Hằng Hữu phán bảo. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Chân đèn làm bằng vàng dát, từ đế cho đến hoa, theo kiểu mẫu Chúa Hằng Hữu cho Môi-se xem. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Hãy biệt riêng người Lê-vi ra khỏi toàn dân Ít-ra-ên và làm lễ thanh tẩy họ, ");
INSERT INTO vieovcb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","lấy nước thanh tẩy rảy trên họ, rồi bảo họ tự cạo sạch mình mẩy và giặt sạch áo xống. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Hãy bảo họ đem dâng một bò đực tơ và lễ vật ngũ cốc bột mịn trộn dầu, cùng với một bò đực tơ khác làm sinh tế chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Sau đó, hãy dẫn người Lê-vi đến cửa Đền Tạm trước sự chứng kiến của toàn dân. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Con sẽ trình diện người Lê-vi cho Chúa Hằng Hữu; và người Ít-ra-ên sẽ đặt tay trên họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","A-rôn sẽ dâng người Lê-vi cho Chúa Hằng Hữu như một lễ vật của người Ít-ra-ên dâng lên, để thay dân phục vụ Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Người Lê-vi sẽ đặt tay trên đầu hai con bò: Một con làm sinh tế chuộc tội, một con làm sinh tế thiêu, dâng lên Chúa Hằng Hữu để chuộc tội cho họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Xong rồi, người Lê-vi sẽ được giao cho A-rôn và các con A-rôn, giống như một lễ vật dâng lên Chúa Hằng Hữu theo lối đưa qua đưa lại; sau khi dâng, lễ vật thuộc về thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Như thế, con phân biệt người Lê-vi với những người Ít-ra-ên khác, vì người Lê-vi thuộc về Ta. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Sau khi được làm lễ thanh tẩy và hiến dâng, người Lê-vi sẽ vào Đền Tạm phục vụ Ta. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Họ được dâng cho Ta để thay thế các con trưởng nam Ít-ra-ên, và Ta chấp nhận họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Vì vào ngày Ta đoán phạt các con đầu lòng Ai Cập, Ta đã dành cho Ta tất cả con đầu lòng Ít-ra-ên, cả người lẫn gia súc. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Và bây giờ, Ta nhận người Lê-vi thay cho các con trưởng nam Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ta sẽ giao người Lê-vi cho A-rôn và các con trai (như một món quà tặng), để họ phục vụ trong Đền Tạm thay cho người Ít-ra-ên, và làm lễ chuộc tội cho người Ít-ra-ên; nhờ đó người Ít-ra-ên sẽ không bị tai họa. Vì nếu ai trong người Ít-ra-ên vào nơi thánh, thì người ấy phải mang tai họa.” ");
INSERT INTO vieovcb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Môi-se, A-rôn, và toàn dân Ít-ra-ên thực hiện mọi lời Chúa Hằng Hữu phán dạy Môi-se về người Lê-vi. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Người Lê-vi tẩy sạch mình, giặt áo xống, và A-rôn dâng họ như tế lễ đưa qua đưa lại trước mặt Chúa Hằng Hữu. A-rôn cũng làm lễ chuộc tội cho họ được thánh sạch. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Sau đó, họ vào Đền Tạm giúp A-rôn và các con A-rôn. Mọi việc đều được thực hiện đúng theo lời Chúa Hằng Hữu phán dạy Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Mỗi người Lê-vi sẽ bắt đầu cuộc đời công vụ trong Đền Tạm từ tuổi hai mươi lăm, ");
INSERT INTO vieovcb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","đến tuổi năm mươi, họ sẽ mãn nhiệm vụ. ");
INSERT INTO vieovcb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Đến tuổi đó, họ có thể phụ giúp anh em mình trong các việc tại Đền Tạm, nhưng chính họ không được đảm trách công việc. Con phải áp dụng luật lệ này khi phân công cho người Lê-vi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Khi người dân Ít-ra-ên còn ở trong hoang mạc Si-nai, vào tháng giêng, năm thứ hai tính từ ngày họ rời đất Ai Cập, Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Người Ít-ra-ên sẽ ăn lễ Vượt Qua hằng năm vào thời gian ấn định, ");
INSERT INTO vieovcb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","tối ngày mười bốn tháng này, theo đúng luật định Ta truyền dạy.” ");
INSERT INTO vieovcb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Vậy, Môi-se thông báo lễ Vượt Qua cho toàn dân. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Lễ Vượt Qua được cử hành bắt đầu tối ngày mười bốn tháng giêng ngay tại hoang mạc Si-nai, như lời Chúa Hằng Hữu phán dạy Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nhưng có mấy người đụng vào xác chết, bị ô uế, nên không được dự lễ. Những người này đến xin Môi-se và A-rôn ");
INSERT INTO vieovcb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","giải thích vì sao họ bị ô uế, và khiếu nại về việc họ bị cấm dâng sinh tế cho Chúa Hằng Hữu trong ngày đã định, là ngày toàn dân phải dự lễ. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Môi-se cho họ biết là ông sẽ cầu hỏi ý Chúa Hằng Hữu về việc này. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Chúa Hằng Hữu trả lời Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Từ nay về sau, nếu có một người Ít-ra-ên nào vì đụng vào người chết mà bị ô uế, hay phải đi xa nhà trong ngày lễ, thì người ấy cũng vẫn giữ lễ Vượt Qua cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Họ phải giữ lễ này vào chiều tối ngày mười bốn tháng hai và ăn bánh không men cùng rau đắng. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Họ cũng ăn bánh không men và rau đắng với thịt chiên. Họ không được để dành món gì đến sáng hôm sau, không được bẻ gãy một cái xương chiên nào, và họ phải theo đúng mọi chỉ thị khác về lễ Vượt Qua. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Còn người nào tinh sạch, hay không phải đi xa nhà, nhưng không chịu dự lễ, sẽ phải bị trục xuất khỏi cộng đồng Ít-ra-ên, vì đã không dâng sinh tế cho Chúa Hằng Hữu trong thời gian ấn định; người ấy phải mang tội mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Nếu có người ngoại quốc tạm trú muốn dự lễ Vượt Qua với người Ít-ra-ên và dâng sinh tế cho Chúa Hằng Hữu, thì người ấy cũng phải theo đúng mọi chỉ thị về lễ này, cùng một quy luật áp dụng cho cả người Ít-ra-ên và người ngoại quốc.” ");
INSERT INTO vieovcb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Vào ngày Đền Tạm được dựng lên, đám mây che phủ đền. Đến tối, trên Đền Tạm như có lửa cháy rực cho đến sáng hôm sau. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Và cứ thế, mây che phủ Đền Tạm ban ngày, và lửa xuất hiện ban đêm. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Mỗi khi đám mây bay lên khỏi nóc đền, người Ít-ra-ên ra đi; đến nơi nào đám mây dừng lại, họ cắm trại tại nơi ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Như vậy, lúc ra đi cũng như lúc dừng lại, họ đều tuân lệnh Chúa Hằng Hữu. Và khi nào đám mây còn dừng lại trên nóc đền, họ còn được nghỉ chân trong trại mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Khi trụ mây cứ ở trên Đền Tạm một thời gian dài, người Ít-ra-ên cũng vâng lệnh Chúa Hằng Hữu và không ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Đôi khi trụ mây dừng trên Đền Tạm chỉ một vài ngày; theo lệnh của Chúa Hằng Hữu, dân chúng cắm trại. Và sau đó, theo lệnh của Ngài, họ lại ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Có khi đám mây dừng lại vào buổi tối và sáng hôm sau đã bay lên, họ phải lập tức ra đi; và dù đám mây bay lên ban đêm hay ban ngày, họ cũng vẫn ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Nếu đám mây dừng lại trên nóc Đền Tạm vài ngày, một tháng hay một năm, thời gian ấy người Ít-ra-ên cũng dừng chân đóng trại. Nhưng bất kỳ lúc nào đám mây bay lên, họ liền ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Vậy, theo lệnh Chúa Hằng Hữu họ cắm trại; theo lệnh Chúa Hằng Hữu họ ra đi; họ tuân theo mọi điều Ngài dạy bảo Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Hãy làm hai chiếc kèn bằng bạc dát mỏng, dùng để triệu tập dân chúng hội họp và báo hiệu tháo trại lên đường. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Khi muốn triệu tập toàn dân tại cửa Đền Tạm, thì thổi cả hai kèn. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Nếu có một loa thổi lên thì các nhà lãnh đạo tức các trưởng đại tộc Ít-ra-ên sẽ họp trước mặt con. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Khi thổi kèn vang động dồn dập lần thứ nhất, đó là hiệu lệnh cho trại phía đông ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Khi kèn thổi vang động lần thứ hai, trại phía nam ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Lúc triệu tập, không được thổi kèn vang động dồn dập. Thổi kèn vang động dồn dập là hiệu lệnh xuất quân. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Người thổi kèn là các thầy tế lễ, con của A-rôn. Đây là một định lệ có tính cách vĩnh viễn, áp dụng qua các thế hệ. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Khi các ngươi vào lãnh thổ mình rồi, mỗi khi xuất quân chống quân thù xâm lăng, phải thổi kèn vang động dồn dập; Chúa Hằng Hữu sẽ nghe và cứu các ngươi khỏi quân thù. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Cũng được thổi kèn trong những ngày vui mừng, những kỳ lễ, ngày đầu tháng, lúc dâng lễ thiêu, và lễ thù ân. Tiếng kèn sẽ nhắc nhở Đức Chúa Trời nhớ đến các ngươi. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Vào ngày hai mươi tháng hai, năm thứ hai, đám mây bay lên khỏi nóc Đền Giao Ước, ");
INSERT INTO vieovcb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","và người Ít-ra-ên từ hoang mạc Si-nai lên đường. Đi đến hoang mạc Pha-ran, đám mây dừng lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Đây là lần đầu tiên họ ra đi sau khi nhận được huấn thị của Chúa Hằng Hữu do Môi-se truyền lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Đại tộc Giu-đa ra đi trước tiên, dưới ngọn cờ của tộc mình, do Na-ha-sôn, con A-mi-na-đáp chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Thứ đến là đại tộc Y-sa-ca, do Na-tha-na-ên, con Xu-a chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sau đó đến đại tộc Sa-bu-luân, do Ê-li-áp, con Hê-lôn chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Đền Tạm được tháo gỡ, các gia tộc Ghẹt-sôn và Mê-ra-ri khiêng đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Đi sau đền là đại tộc Ru-bên, dưới ngọn cờ mình, do Ê-li-sua, con Sê-đêu chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Kế sau là đại tộc Si-mê-ôn, do Sê-lu-mi-ên, con Xu-ri-ha-đai, chỉ huy; ");
INSERT INTO vieovcb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","rồi đến đại tộc Gát, do Ê-li-a-sáp, con Đê-u-ên chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Gia tộc Kê-hát ra đi, khiêng theo các vật thánh. Đền Tạm phải được dựng xong trước khi gia tộc Kê-hát đến nơi. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kế đến là đại tộc Ép-ra-im, do Ê-li-sa-ma, con A-mi-hút chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Rồi đến đại tộc Ma-na-se, do Ga-ma-li-ên, con Phê-đát-su chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Sau đó là đại tộc Bên-gia-min, do A-bi-đan, con Ghi-đeo-ni chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Đại tộc Đan hướng dẫn đạo quân hậu tập do A-hi-ê-xe, con A-mi-sa-đai, chỉ huy, đi dưới ngọn cờ mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Sau đại tộc Đan là đại tộc A-se, do Pha-ghi-ên, con Óc-ran chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Đi sau cùng là đại tộc Nép-ta-li do A-hi-ra, con Ê-nan chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Đó là thứ tự đội ngũ của người Ít-ra-ên khi họ ra đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Một hôm, Môi-se nói với anh vợ mình là Hô-báp, con Rê-u-ên, người Ma-đi-an, rằng: “Cuộc hành trình này sẽ đưa chúng ta đến đất hứa. Anh cứ theo chúng tôi, chúng tôi sẽ hậu đãi anh, vì Chúa Hằng Hữu đã hứa ban phước lành cho Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Nhưng Hô-báp đáp: “Không được. Tôi phải về quê sống với bà con thân quyến.” ");
INSERT INTO vieovcb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Môi-se năn nỉ: “Xin anh đừng bỏ về. Anh là người thông thạo việc cắm trại trong hoang mạc nên anh sẽ giúp chúng tôi rất đắc lực. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Nếu anh đi với chúng tôi, thì chúng tôi sẽ chia sẻ với anh mọi thứ phước lành Chúa Hằng Hữu ban cho chúng tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Vậy, họ rời núi Si-nai, đi đường trong ba ngày; Hòm Giao Ước của Chúa Hằng Hữu đi trước, tìm một nơi cho họ dừng chân. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Đám mây của Chúa Hằng Hữu che họ hằng ngày trong lúc đi đường. ");
INSERT INTO vieovcb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Cứ mỗi lần Hòm Giao Ước đi, Môi-se cầu khẩn: “Lạy Chúa Hằng Hữu, xin đứng lên đánh kẻ thù tan tác! Đuổi kẻ ghét Ngài chạy dài!” ");
INSERT INTO vieovcb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Và mỗi khi Hòm Giao Ước dừng lại, Môi-se cầu nguyện: “Xin Chúa Hằng Hữu trở lại với toàn dân Ít-ra-ên!” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Người Ít-ra-ên bắt đầu phàn nàn, than trách. Chúa Hằng Hữu nghe tất cả và nổi giận. Lửa của Chúa Hằng Hữu bắt đầu thiêu đốt những trại ở ven ngoài cùng của họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Họ kêu cứu với Môi-se. Môi-se kêu cầu Chúa Hằng Hữu và lửa ngừng cháy. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Môi-se đặt tên chỗ ấy là Tha-bê-ra, vì lửa của Chúa Hằng Hữu đốt cháy họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Đã thế, những người ngoại quốc đi chung với người Ít-ra-ên lại đòi hỏi, thèm thuồng, nên người Ít-ra-ên lại kêu khóc: “Làm sao được miếng thịt mà ăn! ");
INSERT INTO vieovcb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nhớ ngày nào còn ở Ai Cập, tha hồ ăn cá, ăn dưa leo, dưa hấu, ăn kiệu, hành, tỏi; ");
INSERT INTO vieovcb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","nhưng ngày nay sức lực tiêu tán vì chẳng có gì ăn ngoài ma-na trước mắt!” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ma-na mịn như hạt ngò, trong như nhựa cây. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Người ta chỉ cần nhặt lấy, đem xay hoặc giã rồi hấp chín đi để làm bánh. Bánh ma-na có vị như bánh pha dầu ô-liu. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Đêm đêm, lúc sương rơi là lúc ma-na rơi xuống quanh trại. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Các gia đình Ít-ra-ên đều ra đứng khóc lóc ở cửa trại mình. Môi-se nghe vậy, bất mãn lắm và Chúa Hằng Hữu cũng nổi giận. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Môi-se thưa với Chúa Hằng Hữu: “Sao Chúa làm cho người đầy tớ này buồn khổ? Sao Chúa không ban ơn mà cứ bắt con phải gánh vác dân này? ");
INSERT INTO vieovcb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Họ có phải là con đẻ của con đâu mà Chúa bảo con ẵm họ vào lòng như mẹ nuôi dưỡng con mình, đem họ vào đất Ngài đã hứa cho tổ tiên họ? ");
INSERT INTO vieovcb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Con lấy đâu ra thịt cho cả dân này ăn mà họ cứ khóc lóc đòi thịt? ");
INSERT INTO vieovcb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Một mình con không gánh nổi dân này, trách nhiệm con nặng nề quá! ");
INSERT INTO vieovcb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nếu Chúa cư xử với con thế này, xin thà giết con ngay đi, để con khỏi lâm vào cảnh khốn nạn, và như vậy là Chúa làm ơn cho con đó!” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Chúa Hằng Hữu phán bảo Môi-se: “Hãy chọn bảy mươi trưởng lão trong dân, đem họ vào Đền Tạm đứng với con. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ta sẽ xuống nói chuyện với con tại đó, và lấy Thần Linh trong con đặt trên những người ấy để họ chia sẻ trách nhiệm với con và con không phải gánh vác một mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Cũng bảo dân chúng phải dọn mình thanh sạch, ngày mai họ sẽ được ăn thịt. Chúa Hằng Hữu đã nghe lời khóc than của họ vì thèm thịt, vì luyến tiếc những ngày đầy đủ ở Ai Cập. Chúa Hằng Hữu sẽ cho họ thịt. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Họ sẽ ăn, không phải chỉ một hai ngày, năm mười ngày, hay vài mươi ngày. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Nhưng ăn suốt tháng, đến độ chán chê thịt, nôn cả ra lỗ mũi. Vì họ từ khước Chúa Hằng Hữu đang ở giữa họ, mà khóc than tiếc nuối Ai Cập.” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Môi-se thắc mắc: “Người Ít-ra-ên có đến 600.000 quân, thế mà Ngài sẽ cho họ ăn thịt suốt tháng sao? ");
INSERT INTO vieovcb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Nếu vậy phải giết hết bò, chiên, hoặc bắt hết cá dưới biển cho họ ăn mới đủ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Nhưng Chúa Hằng Hữu phán bảo Môi-se: “Tay của Chúa Hằng Hữu đâu có ngắn? Con chờ xem lời Ta hứa có được thực hiện hay không.” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Môi-se ra khỏi đền, kể cho dân chúng nghe mọi lời Chúa Hằng Hữu phán dạy. Ông chọn bảy mươi trưởng lão, đem họ đến đứng quanh Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Chúa Hằng Hữu ngự xuống đám mây nói chuyện với Môi-se, và lấy Thần Linh trong ông đặt trên bảy mươi trưởng lão. Khi Thần Linh ngự trên họ, các trưởng lão bắt đầu nói tiên tri, nhưng không được lâu dài. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Lúc ấy có hai trưởng lão, là Ên-đát và Mê-đát, vẫn còn ở trong trại chứ chưa đi đến Đền Tạm. Khi Thần Linh ngự trên họ, họ nói tiên tri ngay trong trại. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Một thanh niên chạy đi báo tin cho Môi-se: “Ên-đát và Mê-đát đang nói tiên tri trong trại.” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Giô-suê, con của Nun, người phụ tá của Môi-se, lên tiếng: “Xin thầy cấm họ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Môi-se đáp: “Con ganh tị giùm cho ta sao? Ta chỉ ước mong mỗi con dân của Chúa Hằng Hữu đều nói tiên tri, và Chúa Hằng Hữu đổ Thần Linh của Ngài trên mọi người.” ");
INSERT INTO vieovcb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Sau đó, Môi-se và các trưởng lão Ít-ra-ên trở về trại. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Chúa Hằng Hữu sai gió thổi chim cút từ biển đến, sa vào trại Ít-ra-ên. Chim nằm dày đặc cả một vùng, từ trại lan rộng ra khắp chung quanh, mỗi phía rộng ước chừng một ngày đường, và từ mặt đất lên cao đến quãng một thước. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Người ta lo bắt chim cút suốt cả ngày và đêm hôm ấy, và luôn cả ngày hôm sau. Mỗi người ít nhất cũng bắt được hơn 10 hô-me. Họ đem chim phơi khắp quanh trại. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Nhưng khi người ta bắt đầu ăn thịt chim, cơn phẫn nộ của Chúa Hằng Hữu nổi lên, Ngài giáng tai họa khủng khiếp trên họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Và nơi ấy được gọi là Kíp-rốt Ha-tha-va, vì là nơi chôn xác của những người tham ăn. ");
INSERT INTO vieovcb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Từ Kíp-rốt Ha-tha-va, họ lại ra đi và dừng chân tại Hát-sê-rốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mi-ri-am và A-rôn nói hành Môi-se về người đàn bà ở xứ Cút mà Môi-se cưới làm vợ. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Họ nói: “Có phải chỉ một mình Môi-se là người trung gian truyền đạt sứ mệnh của Chúa Hằng Hữu cho dân chúng đâu? Ngài không phán qua chúng ta sao?” Nhưng Chúa Hằng Hữu nghe những lời đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Môi-se là một người khiêm tốn nhất trên đời.) ");
INSERT INTO vieovcb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ngay lập tức, Chúa Hằng Hữu truyền bảo Môi-se, A-rôn, và Mi-ri-am: “Hãy đi ngay vào Đền Tạm!” Họ vâng lời. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Chúa Hằng Hữu ngự xuống trong trụ mây, đứng tại cửa Đền Tạm. Ngài gọi: “A-rôn và Mi-ri-am!” Họ cùng bước tới. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Chúa Hằng Hữu phán với họ: “Lắng nghe điều Ta phán: Nếu có những tiên tri ở giữa các con, Ta, Chúa Hằng Hữu, sẽ bày tỏ Ta trong khải tượng, Ta phán với họ trong giấc chiêm bao. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Nhưng với Môi-se, đầy tớ của Ta. Trong nhà Ta, chỉ có người là trung tín. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ta nói chuyện với người mặt đối mặt, rõ ràng, không lời bí ẩn! Người đã được chiêm ngưỡng Chúa Hằng Hữu. Thế mà các con không sợ mà nói hành Môi-se, đầy tớ của Ta sao?” ");
INSERT INTO vieovcb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Cơn thịnh nộ của Chúa Hằng Hữu nổi lên cùng họ, rồi Ngài ngự đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Vừa khi đám mây bay khỏi nóc Đền Tạm, Mi-ri-am liền bị bệnh phong hủi trắng như tuyết. A-rôn thấy thế, ");
INSERT INTO vieovcb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","liền van xin Môi-se: “Xin đừng trừng phạt chúng tôi, vì chúng tôi phạm tội và hành động điên cuồng. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Đừng để cho chị ấy như người đã chết, như một hài nhi lọt lòng mẹ với một thân thể rữa nát.” ");
INSERT INTO vieovcb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Môi-se kêu xin Chúa Hằng Hữu: “Chúa ơi! Xin Ngài chữa lành chị con.” ");
INSERT INTO vieovcb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Chúa Hằng Hữu liền bảo Môi-se: “Nếu cha nàng nhổ vào mặt nàng, thì nàng cũng phải chịu xấu hổ trong bảy ngày. Vậy nàng phải được giữ bên ngoài trại quân bảy ngày, sau đó mới được vào trại.” ");
INSERT INTO vieovcb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Và như thế, Mi-ri-am được giữ lại một nơi bên ngoài trại bảy ngày. Dân chúng không lên đường cho đến ngày Mi-ri-am được trở vào trại. ");
INSERT INTO vieovcb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Sau đó, họ từ Hát-sê-rốt ra đi. Đến hoang mạc Pha-ran, họ dừng chân cắm trại. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Con chọn trong số các nhà lãnh đạo, mỗi đại tộc một người, sai họ đi do thám Ca-na-an, đất Ta cho Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Vậy từ hoang mạc Pha-ran, Môi-se cử họ ra đi, theo lệnh Chúa Hằng Hữu. Tất cả đều là những người lãnh đạo của người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Đây là danh sách của họ: Đại tộc Ru-bên: Sam-mua, con của Xác-cua. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Đại tộc Si-mê-ôn: Sa-phát, con của Hô-ri. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Đại tộc Giu-đa: Ca-lép, con của Giê-phu-nê. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Đại tộc Y-sa-ca: Di-ganh, con của Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Đại tộc Ép-ra-im: Ô-sê, con của Nun. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Đại tộc Bên-gia-min: Phan-thi, con của Ra-phu. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Đại tộc Sa-bu-luân: Gát-đi-ên, con của Sô-đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Đại tộc Ma-na-se, con trai của Giô-sép: Ga-đi, con của Su-si. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Đại tộc Đan: A-mi-ên, con của Ghê-ma-li. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Đại tộc A-se: Sê-thu, con của Mi-ca-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Đại tộc Nép-ta-li: Nách-bi, con của Vấp-si. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Đại tộc Gát: Gu-ên, con của Ma-ki. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Đó là danh sách các thám tử Môi-se sai đi trinh sát xứ Ca-na-an. Ông đổi tên Ô-sê, con của Nun, thành Giô-suê. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Môi-se dặn họ: “Các anh đi lên miền bắc ngang qua xứ Nê-ghép đến tận vùng đồi núi; ");
INSERT INTO vieovcb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","xem thử địa thế ra sao, dân tình thế nào, đông hay thưa, mạnh hay yếu, ");
INSERT INTO vieovcb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","đất tốt hay xấu, thành thị có hào lũy kiên cố hay trống trải, ");
INSERT INTO vieovcb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","đất đai màu mỡ hay khô cằn, có nhiều cây cối hay tiêu điều. Hãy cố gắng đem về một ít hoa quả, đừng ngại ngùng.” (Lúc ấy đúng vào mùa hái nho đầu màu.) ");
INSERT INTO vieovcb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Vậy, họ ra đi trinh sát đất này, từ hoang mạc Xin tới Rê-hốp, gần Lê-bô Ha-mát. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Họ đi lên miền bắc, ngang qua xứ Nê-ghép tới Hếp-rôn, nơi con cháu A-nác là A-hi-man, Sê-sai, và Thanh-mai sinh sống. (Thành Hếp-rôn được xây trước Xô-an ở Ai Cập bảy năm.) ");
INSERT INTO vieovcb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Họ đến thung lũng Ếch-côn, cắt một chùm nho, hai người phải dùng đòn mới khiêng nổi. Họ cũng hái mấy trái thạch lựu và trái vả đem về. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Thung lũng ấy được gọi là Ếch-côn, vì các thám tử Ít-ra-ên đã hái nho ở đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Sau bốn mươi ngày do thám, họ trở về. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Họ quay về với Môi-se, A-rôn, và toàn thể người Ít-ra-ên trong hoang mạc Pha-ran. Các thám tử báo cho họ và toàn thể người Ít-ra-ên và cho xem hoa quả trong xứ. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Họ báo với Môi-se: “Chúng tôi đã vào đất ấy theo lệnh ông sai bảo chúng tôi; thật là đất tràn đầy sữa và mật. Đây là hoa quả của xứ ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Tuy nhiên, dân ở đó rất cường tráng, thành thị rộng lớn, và hào lũy kiên cố. Ngoài ra, chúng tôi có thấy bọn khổng lồ, thuộc dòng dõi A-nác ở đó nữa. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Người A-ma-léc ở Nê-ghép, người Hê-tít, người Giê-bu, và người A-mô-rít ở vùng cao nguyên, còn người Ca-na-an ở miền biển và dọc theo Thung lũng Giô-đan.” ");
INSERT INTO vieovcb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ca-lép lên tiếng để trấn an dân chúng đang nghi hoặc trước mặt Môi-se: “Chúng ta phải đi ngay vào chiếm lấy đất ấy, chúng ta thừa sức chinh phục xứ này.” ");
INSERT INTO vieovcb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Nhưng các thám tử khác nói: “Chúng ta không đủ sức đâu, vì họ mạnh hơn chúng ta.” ");
INSERT INTO vieovcb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Những người này thổi phồng những điểm bất lợi: “Đất này sẽ nuốt chửng dân ta, vì dân cư chúng nó là giống khổng lồ. ");
INSERT INTO vieovcb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Chúng tôi đã thấy bọn người khổng lồ con cháu A-nác. Họ to lớn đến độ chúng tôi cảm thấy mình bé nhỏ như những con cào cào khi đứng trước mặt họ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Nghe thế, mọi người khóc lóc nức nở. Họ khóc suốt đêm ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Họ cùng nhau lên tiếng trách Môi-se và A-rôn: “Thà chúng tôi chết ở Ai Cập hay chết trong hoang mạc này còn hơn! ");
INSERT INTO vieovcb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Tại sao Chúa Hằng Hữu đem chúng tôi đến đây để chịu đâm chém, và vợ con chúng tôi làm mồi cho địch? Thà đi trở lại Ai Cập còn hơn!” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Họ quay lại bàn với nhau: “Chúng ta nên bầu một vị lãnh tụ để đem chúng ta quay về Ai Cập!” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Môi-se và A-rôn sấp mình xuống trước mặt toàn thể người dân Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Giô-suê, con của Nun, và Ca-lép, con của Giê-phu-nê, là hai người trong toán đi trinh sát Ca-na-an về, liền xé áo mình, ");
INSERT INTO vieovcb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","khích lệ mọi người: “Xứ chúng tôi đi do thám đất đai vô cùng màu mỡ. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Nếu Chúa Hằng Hữu thương yêu giúp đỡ, Ngài sẽ đưa chúng ta vào và cho chúng ta xứ ấy, là một xứ ‘đượm sữa và mật.’ ");
INSERT INTO vieovcb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nhưng, xin anh chị em đừng nổi loạn cùng Chúa Hằng Hữu, cũng đừng sợ dân của xứ ấy, vì họ chỉ là mồi cho chúng ta. Họ không thể chống đỡ vì Chúa Hằng Hữu đứng bên chúng ta, không việc gì ta phải sợ họ!” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Nhưng mọi người lại bảo nhau lấy đá ném cho hai ông chết. Bỗng vinh quang của Chúa Hằng Hữu hiện ra tại Đền Tạm trước mặt toàn thể người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Chúa Hằng Hữu phán bảo Môi-se: “Dân này không tin Ta, khinh dể Ta cho đến bao giờ, mặc dù Ta đã làm bao nhiêu phép lạ giữa họ? ");
INSERT INTO vieovcb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ta sẽ truất quyền thừa hưởng của họ, tiêu diệt họ bằng dịch lệ tai ương, rồi sẽ làm cho dòng giống của con thành một nước lớn mạnh hơn họ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Nhưng Môi-se thưa lên Chúa Hằng Hữu: “Nếu thế, người Ai Cập sẽ nghe tin này. Vì Chúa đã dùng quyền lực phi thường đem Ít-ra-ên ra đi từ Ai Cập, ");
INSERT INTO vieovcb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","họ sẽ báo cho dân ở trong xứ này biết. Họ cũng có nghe rằng Chúa là Chúa Hằng Hữu ở với người Ít-ra-ên, hiện diện giữa Ít-ra-ên. Đám mây của Chúa dẫn đường Ít-ra-ên ngày và đêm. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Bây giờ nếu Chúa tiêu diệt Ít-ra-ên, những nước đã nghe danh tiếng Chúa sẽ nói rằng: ");
INSERT INTO vieovcb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Vì Chúa Hằng Hữu không thể nào đem Ít-ra-ên vào đất Ngài thề hứa cho họ, nên mới giết họ trong hoang mạc.’ ");
INSERT INTO vieovcb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Vậy con van nài Chúa, xin quyền năng của Chúa Hằng Hữu thể hiện cách uy nghi, như Chúa đã phán: ");
INSERT INTO vieovcb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Chúa Hằng Hữu đầy tình thương, chậm giận, hay thứ lỗi, nhưng Chúa cũng không thể không trừng phạt người có tội và dòng dõi họ.’ ");
INSERT INTO vieovcb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Xin Chúa tha tội cho dân này, vì tình thương không hề thay đổi của Chúa, cũng như Chúa đã bao lần tha thứ cho họ từ khi còn ở Ai Cập cho đến ngày nay.” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Chúa Hằng Hữu đáp: “Theo lời con xin, Ta đã tha cho họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Nhưng hiển nhiên như Ta hằng sống, vinh quang Chúa Hằng Hữu sẽ tràn ngập đất. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Trong tất cả những người thấy vinh quang Ta, sẽ không cho một ai được thấy đất đai Ta đã hứa cho tổ tiên họ. Họ đã thấy các phép lạ Ta làm tại Ai Cập cũng như ");
INSERT INTO vieovcb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","trong hoang mạc, nhưng đã mười lần không tin Ta, không vâng lời Ta. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nhưng đầy tớ Ta là Ca-lép, với một tinh thần khác biệt, đã hết lòng theo Ta; nên Ta sẽ đưa Ca-lép vào đất người đã trinh sát, và con cháu người sẽ hưởng chủ quyền đất ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Lúc ấy người A-ma-léc và người Ca-na-an đang sống trong thung lũng. Ngày mai, các ngươi sẽ quay lại, đi vào hoang mạc theo hướng Biển Đỏ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Chúa Hằng Hữu phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Những người tội lỗi này còn phàn nàn oán trách Ta cho đến bao giờ? Ta đã nghe hết những lời của người Ít-ra-ên phàn nàn rồi. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Con bảo họ rằng: ‘Hiển nhiên như Chúa Hằng Hữu hằng sống, Ta sẽ làm cho những lời kêu ca của các ngươi thành sự thật. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Các ngươi đều phải chết trong hoang mạc; tất cả những ai đã oán trách Ta, từ hai mươi tuổi trở lên, ");
INSERT INTO vieovcb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","đều không được vào đất hứa, trừ Ca-lép, con Giê-phu-nê và Giô-suê, con Nun. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Đối với con cái của các ngươi, các ngươi nói rằng chúng nó sẽ làm mồi cho địch, nhưng Ta sẽ đưa chúng nó vào đất các ngươi chê bỏ. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Còn về chính các ngươi thì thây các ngươi sẽ nằm rạp trong hoang mạc này. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Vì các ngươi bất trung, nên con cái các ngươi phải lang thang trong hoang mạc suốt bốn mươi năm, cho đến ngày những người sau cùng trong các ngươi chết trong hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Vì các ngươi đã trinh sát xứ trong bốn mươi ngày, nên các ngươi phải lang thang trong hoang mạc suốt bốn mươi năm—mỗi ngày là một năm, đó là thời gian các ngươi phải mang tội ác mình. Các ngươi sẽ ý thức được hậu quả của việc toa rập nhau chống nghịch Ta.’ ");
INSERT INTO vieovcb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ta là Chúa Hằng Hữu đã quyết định như vậy, họ phải chết trong hoang mạc này vì tội phản nghịch Ta.” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Riêng các thám tử mà Môi-se đã sai đi trinh sát xứ, khi trở về có xui cho dân chúng lằm bằm cùng Môi-se, ");
INSERT INTO vieovcb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","những người cản trở, trình báo sai trật đều bị tai vạ hành chết ngay trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Trong những người đi trinh sát xứ chỉ có Giô-suê, con trai của Nun, và Ca-lép, con trai của Giê-phu-nê còn sống được. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Môi-se thuật lại mọi lời của Chúa Hằng Hữu cho toàn dân Ít-ra-ên, nên họ vô cùng sầu thảm. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Sáng hôm sau, họ dậy sớm, leo lên núi và nói: “Chúng tôi đã phạm tội. Nhưng bây giờ chúng tôi sẵn sàng vào đất hứa. Thấy không, chúng tôi đã lên đến tận đất mà Chúa Hằng Hữu đã hứa với chúng tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Nhưng Môi-se nói: “Đã đến nước này sao còn cãi lệnh Chúa Hằng Hữu? Làm vậy anh em chỉ có thất bại. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Tự ý ra đi khi không có Chúa Hằng Hữu đi cùng, anh em sẽ bị quân thù đánh bại. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Anh em sẽ chết dưới lưỡi gươm của quân A-ma-léc và Ca-na-an, vì anh em đã chối bỏ Chúa Hằng Hữu, nên Ngài cũng từ bỏ anh em.” ");
INSERT INTO vieovcb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nhưng họ ngoan cố cứ tiến lên núi, mặc dù Môi-se và Hòm Giao Ước của Chúa Hằng Hữu vẫn chưa rời trại. ");
INSERT INTO vieovcb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Quân A-ma-léc và Ca-na-an ở trên đồi núi đổ xuống đánh giết họ và đánh đuổi họ chạy dài cho đến Họt-ma. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Hãy bảo với người Ít-ra-ên sau khi đã vào trong đất Ta cho, ");
INSERT INTO vieovcb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","và khi các ngươi dâng lên Chúa Hằng Hữu các tế lễ bằng lửa lấy từ bầy bò và bầy chiên mình để có mùi thơm đẹp lòng Chúa Hằng Hữu, hoặc tế lễ thiêu, hoặc sinh tế về những lời thề nguyện đặc biệt hay tự hiến, hoặc lễ vật dâng lên nhân kỳ lễ ");
INSERT INTO vieovcb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","thì người đem dâng tế lễ phải dâng lên Chúa Hằng Hữu một tế lễ chay là 2,2 lít bột mì mịn trộn với 1 lít dầu ô-liu. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Cứ mỗi con chiên dâng làm tế lễ thiêu, hoặc cứ mỗi sinh tế, con hãy chuẩn bị 1 lít rượu nho làm lễ quán. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Nếu sinh tế là một chiên đực, lễ vật ngũ cốc là 4,4 lít bột mịn trộn với 1,3 lít dầu ô-liu, ");
INSERT INTO vieovcb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","đồng thời cũng dâng 1,3 lít rượu nho. Đó là các lễ vật có hương thơm dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Nếu sinh tế là một bò đực tơ làm tế lễ thiêu hay làm sinh tế vì một lời hứa nguyện đặc biệt, hay vì một tế lễ cầu an cho Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","hãy đem theo con bò đực, một tế lễ chay bằng 6,6 lít bột mì trộn với 2 lít dầu ô-liu, ");
INSERT INTO vieovcb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","đồng thời cũng dâng 2 lít rượu nho. Đó là các lễ vật dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Mỗi con bò đực hay chiên đực, mỗi con chiên con hay dê con đều phải chuẩn bị dâng lễ theo cách đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Hãy chuẩn bị cách ấy cho từng con một, dâng bao nhiêu sinh tế đều phải dâng theo bấy nhiêu tế lễ chay. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Luật lệ này áp dụng chung cho người Ít-ra-ên và ");
INSERT INTO vieovcb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","người ngoại kiều khi dâng lễ vật, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Chỉ có một luật áp dụng cho cả người Ít-ra-ên lẫn ngoại kiều. Nguyên tắc này có tính cách vĩnh viễn, không thay đổi qua các thế hệ, vì trước mặt Chúa Hằng Hữu, người Ít-ra-ên cũng như người ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Các luật lệ và sắc lệnh áp dụng cho các ngươi cũng áp dụng cho ngoại kiều sống giữa các ngươi y như vậy.” ");
INSERT INTO vieovcb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Hãy nói thêm những điều này với người Ít-ra-ên. Khi đã vào trong đất Ta cho, ");
INSERT INTO vieovcb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","khi được ăn thực phẩm trong xứ đó, hãy dâng một phần thực phẩm làm lễ vật cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Hãy dâng một chiếc bánh bằng bột đầu mùa làm một tế lễ từ sân đạp lúa. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Suốt các thế hệ tương lai cũng thế, các ngươi phải dâng tế lễ này cho Chúa Hằng Hữu lấy từ trong bột đầu mùa. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Nếu ngươi vô tình không giữ một điều răn nào Chúa Hằng Hữu đã ban hành cho Môi-se, ");
INSERT INTO vieovcb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tức là điều răn của Chúa Hằng Hữu dùng Môi-se mà ban cho các ngươi từ ngày Chúa Hằng Hữu ban hành cho đến những thế hệ tương lai. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Nếu vô tình phạm tội mà cộng đồng không biết, thì cả cộng đồng phải dâng một con chiên đực làm tế lễ thiêu có mùi thơm đẹp lòng Chúa Hằng Hữu luôn với lễ chay và lễ quán như đã ấn định, và một con dê đực làm tế lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Thầy tế lễ sẽ chuộc tội cho dân chúng và lỗi họ sẽ được tha, vì đây là một sự lầm lỡ, và họ đã dâng lễ thiêu và lễ chuộc tội cho Chúa Hằng Hữu để chuộc lỗi. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Toàn thể dân chúng đều được thứ tha, kể cả người ngoại kiều, vì mọi người đều có phần trong sự lầm lỡ này. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Trường hợp cá nhân lầm lỡ, người ấy phải dâng một con dê cái một tuổi làm lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Thầy tế lễ sẽ chuộc tội cho người ấy trước mặt Chúa Hằng Hữu, lỗi người ấy sẽ được tha. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Luật về cá nhân lầm lỡ này áp dụng chung cho người Ít-ra-ên và ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Nhưng nếu một người cố tình vi phạm, dù là người Ít-ra-ên hay ngoại kiều, thì người ấy phải bị khai trừ khỏi dân chúng, vì đã xúc phạm Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Vì dám coi thường lời của Chúa Hằng Hữu, vi phạm luật lệ Ngài, nên mạng người ấy phải bị khai trừ, và phải mang lấy tội mình.” ");
INSERT INTO vieovcb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Khi họ còn ở trong hoang mạc, một hôm người ta bắt gặp một người đang nhặt củi trong ngày Sa-bát. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Người ta dẫn người ấy đến Môi-se, A-rôn, và dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Nhưng vì chưa có điều luật áp dụng cho trường hợp này, người ta giam người ấy lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Chúa Hằng Hữu phán bảo Môi-se: “Người ấy phải bị xử tử, toàn dân sẽ lấy đá ném cho người ấy chết đi bên ngoài trại.” ");
INSERT INTO vieovcb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Và đoàn dân dẫn người ấy ra ngoài trại, lấy đá ném chết theo lệnh Chúa Hằng Hữu cùng Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Chúa Hằng Hữu lại phán dặn Môi-se dạy người Ít-ra-ên: ");
INSERT INTO vieovcb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Trên áo mỗi người phải kết tua. Các tua này được đính vào lai áo bằng dây màu xanh. Lệ này áp dụng qua các thế hệ. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mỗi khi nhìn thấy các tua, các ngươi sẽ nhớ lại các luật lệ của Chúa Hằng Hữu, tuân hành luật lệ Ngài, chứ không làm theo điều lòng mình ham muốn, mắt mình ưa thích, như các ngươi đã làm khi còn theo các thần khác. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Vậy, các ngươi sẽ được nhắc nhở để thi hành lời Ta dạy, và trở nên người thánh cho Đức Chúa Trời. ");
INSERT INTO vieovcb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Đức Chúa Trời các ngươi là Chúa Hằng Hữu đã đem các ngươi ra khỏi Ai Cập. Ta là Chúa Hằng Hữu, Đức Chúa Trời của các ngươi!” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Một người tên Cô-ra, con Đít-sê-hu, cháu Kê-hát, chắt Lê-vi, âm mưu với ba người thuộc đại tộc Ru-bên là Đa-than, A-bi-ram, hai con của Ê-li-áp, và Ôn, con Phê-lết, ");
INSERT INTO vieovcb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","nổi loạn chống Môi-se. Có đến 250 người lãnh đạo Ít-ra-ên, là thành viên của hội đồng dân chúng, tham dự cuộc nổi loạn này. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Họ đến gặp Môi-se và A-rôn, nói: “Các ông chuyên quyền và lạm quyền quá! Toàn thể cộng đồng Ít-ra-ên đều là thánh và Chúa Hằng Hữu ở cùng tất cả chúng ta. Tại sao riêng hai ông tự cho mình có quyền cai trị dân của Chúa Hằng Hữu?” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Nghe vậy, Môi-se quỳ xuống đất. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ông bảo Cô-ra và đồng bọn: “Sáng mai Chúa Hằng Hữu sẽ cho biết ai là người của Ngài, ai là người thánh được gần gũi Ngài, người Ngài chọn sẽ được phép đến gần Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ông Cô-ra, và tất cả những người theo ông đều phải làm điều này: Hãy cầm lấy lư hương, ");
INSERT INTO vieovcb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","và ngày mai, trước mặt Chúa Hằng Hữu, hãy để lửa và trầm hương vào. Người nào Chúa Hằng Hữu chọn chính là người thánh. Những người Lê-vi theo ngươi thật là quá quắt!” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Môi-se lại bảo Cô-ra: “Này, con cháu Lê-vi, nghe đây! ");
INSERT INTO vieovcb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Đức Chúa Trời của Ít-ra-ên đã biệt riêng các ông khỏi cộng đồng Ít-ra-ên và đem các ông đến gần Ngài để làm công việc tại Đền Tạm của Chúa Hằng Hữu, và để các ông đứng trước mặt cộng đồng và phục vụ họ, việc ấy chưa đủ sao? ");
INSERT INTO vieovcb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ngài đã đem ông và tất cả anh em người Lê-vi đến gần Ngài, thế mà bây giờ các ông lại muốn chiếm đoạt chức tế lễ nữa. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ông và những người theo ông đã toa rập nhau để chống đối Chúa Hằng Hữu, chứ A-rôn có làm gì mà các ông oán trách?” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Nói xong, Môi-se sai người đi mời Đa-than và A-bi-ram, con Ê-li-áp, nhưng họ nói: “Chúng tôi không thèm đến đâu! ");
INSERT INTO vieovcb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ông đã bắt chúng tôi bỏ một xứ phì nhiêu để vào chết trong hoang mạc, thế mà ông còn muốn làm vua chúng tôi nữa sao? ");
INSERT INTO vieovcb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ông đâu có đem chúng tôi vào xứ phì nhiêu, cũng chẳng cho chúng tôi đồng ruộng hay vườn nho. Ông còn đánh lừa chúng tôi nữa sao?” Họ nhất định không đến gặp Môi-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Môi-se giận lắm nên thưa với Chúa Hằng Hữu: “Xin Chúa đừng nhậm tế lễ của họ! Con chẳng hề lấy gì của họ cả, dù chỉ là một con lừa, cũng không hề làm hại họ bao giờ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Rồi Môi-se bảo Cô-ra: “Ngày mai, ông và những người theo ông sẽ cùng với A-rôn đến trình diện Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Mỗi người phải lấy lư hương, bỏ hương vào, đem đến trước mặt Chúa Hằng Hữu, 250 người cầm lư hương, cả ông và A-rôn cũng sẽ cầm lư hương.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Vậy, họ bỏ lửa và hương vào lư, cầm đến đứng chung với Môi-se và A-rôn tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Vì Cô-ra đã sách động dân chúng, nên họ kéo đến phản đối Môi-se và A-rôn tại cửa Đền Tạm. Vinh quang của Chúa Hằng Hữu hiện ra trước toàn dân. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Chúa Hằng Hữu phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Hãy tránh xa họ ra, Ta sẽ tiêu diệt đám dân này tức khắc!” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Hai ông liền quỳ xuống, thưa: “Lạy Đức Chúa Trời, là Chúa Tể của linh hồn mọi người, không lẽ vì một người phạm tội, mà Chúa giận toàn dân sao?” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Con ra lệnh cho dân chúng tránh xa trại của Cô-ra, Đa-than, và A-bi-ram.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Môi-se đứng lên, đi đến trại của Đa-than và A-bi-ram, các trưởng lão cũng đi theo. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Ông kêu gọi dân chúng: “Xin anh chị em tránh xa trại của những người độc ác đó, đừng đụng đến một vật gì của họ hết, đừng để một ai phải chết vì tội của họ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Vậy, dân chúng đều tránh xa trại của Cô-ra, Đa-than, và A-bi-ram. Đa-than và A-bi-ram lì lợm ra đứng tại cửa trại, cùng với vợ và con cái lớn nhỏ của mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Môi-se nói: “Bây giờ mọi người sẽ biết rằng Chúa Hằng Hữu đã sai tôi làm công việc cho Ngài, vì những việc tôi đã làm không phải tự tôi đâu. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Nếu những người này chết cách thông thường như tất cả người khác, thì Chúa Hằng Hữu đã không sai tôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Nhưng nếu Chúa Hằng Hữu làm một điều lạ, nếu đất nứt ra nuốt sống họ và mọi vật của họ, nếu họ còn sống mà đi xuống âm phủ, thì trường hợp này có nghĩa là họ đã khinh bỉ Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Môi-se vừa dứt lời, đất dưới chân họ liền nứt ra, ");
INSERT INTO vieovcb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","nuốt chửng lấy họ và gia đình họ, luôn những người theo phe đảng Cô-ra. Tất cả tài sản họ đều bị đất nuốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Vậy họ xuống âm phủ trong lúc đang sống, đất phủ lấp họ, và như vậy họ bị diệt trừ khỏi cộng đồng dân tộc. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Người Ít-ra-ên đứng chung quanh đó nghe tiếng thét lên, đều kinh hoàng chạy trốn, sợ đất nuốt mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Lửa từ Chúa Hằng Hữu lóe ra thiêu cháy 250 người dâng hương. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Sau đó, Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Hãy dặn Ê-lê-a-sa, con trai Thầy Tế lễ A-rôn, nhặt các lư hương từ trong đám lửa ra, vì các lư hương ấy đã được thánh hóa. Cũng đem lửa trong các lư hương đi đổ ngoài xa. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Rồi lấy các lư hương của những người đã chết vì tội mình đem dát mỏng để bọc bàn thờ. Các lư hương trở nên thánh vì người ta đã dùng nó trước mặt Chúa Hằng Hữu. Tấm đồng dát mỏng bọc bàn thờ này có công dụng nhắc nhở, cảnh cáo người Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Thầy Tế lễ Ê-lê-a-sa vâng lời, lấy các lư hương đồng này, dát mỏng thành một tấm đồng dùng để bọc bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Tấm đồng này dùng để nhắc nhở, cảnh cáo người Ít-ra-ên rằng: Ngoài các thầy tế lễ là con cháu A-rôn ra, không ai được đến dâng hương trước mặt Chúa Hằng Hữu. Nếu ai bất tuân thì sẽ phải chết như Cô-ra và đồng bọn. Vậy Ê-lê-a-sa thi hành lệnh của Chúa Hằng Hữu do Môi-se truyền lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Thế nhưng, qua sáng hôm sau, dân chúng lại nổi lên trách móc Môi-se và A-rôn: “Các ông đã giết dân của Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Họ họp nhau lại để chống nghịch Môi-se và A-rôn. Nhưng khi vừa quay lại phía Đền Tạm, họ thấy đám mây bao phủ đền, đồng thời vinh quang của Chúa Hằng Hữu xuất hiện. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Môi-se và A-rôn liền đi đến trước Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Hãy tránh xa dân này ra, Ta sẽ tiêu diệt họ tức khắc.” Môi-se và A-rôn liền sấp mình xuống. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Môi-se giục A-rôn: “Anh lấy lư hương, gắp lửa trên bàn thờ vào, bỏ hương lên trên, đem ngay đến chỗ dân đứng để làm lễ chuộc tội cho họ, vì cơn phẫn nộ của Chúa Hằng Hữu đã phát ra, tai vạ đã khởi sự.” ");
INSERT INTO vieovcb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","A-rôn vâng lời Môi-se, chạy vào giữa đám dân. Vì tai vạ đã phát khởi trong dân chúng, ông bỏ hương vào lư, làm lễ chuộc tội cho dân. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","A-rôn đứng giữa người sống và người chết, thì tai vạ dừng lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Số người chết vì tai vạ này lên đến 14.700 người, không kể số người chết với Cô-ra hôm trước. ");
INSERT INTO vieovcb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Khi tai vạ đã dừng lại, A-rôn trở về trước cửa Đền Tạm, nơi Môi-se đang đứng. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Chúa Hằng Hữu phán dạy Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Hãy nói với mỗi trưởng đại tộc Ít-ra-ên đem đến một cây gậy; nghĩa là mười hai cây gậy của những người lãnh đạo mỗi đại tộc. Con phải đề tên mỗi người trên cây gậy của mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Đề tên A-rôn trên cây gậy của Lê-vi; vì phải có một cây gậy cho mỗi trưởng đại tộc. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Con đem các gậy này đặt trong Đền Tạm, trước Hòm Giao Ước, là nơi Ta sẽ gặp con. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Gậy của người được Ta chọn sẽ trổ hoa, như vậy dân chúng sẽ không còn lý do gì để phàn nàn con nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Môi-se nói lại với người Ít-ra-ên, và các trưởng tộc, bao gồm A-rôn, vâng theo huấn thị, đem gậy đến. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Môi-se đem cất mười hai cây gậy trong Đền Giao Ước trước mặt Chúa Hằng Hữu. Gậy của A-rôn nằm giữa các gậy khác. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ngày hôm sau, khi Môi-se trở vào Đền Giao Ước, ông thấy cây gậy của A-rôn—tượng trưng cho đại tộc Lê-vi—đã đâm chồi, trổ hoa và kết quả, có trái hạnh nhân đã chín! ");
INSERT INTO vieovcb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Môi-se đem các cây gậy từ trong đền Chúa Hằng Hữu cho mọi người xem, họ sững sờ đứng nhìn, và cuối cùng các trưởng tộc lấy gậy mình về. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Nhưng Chúa Hằng Hữu phán bảo Môi-se: “Đem gậy của A-rôn đặt lại trước Hòm Giao Ước, dùng nhắc nhở, cảnh cáo dân chúng về vụ nổi loạn này, để họ khỏi chết vì tai vạ và không bao giờ dám phàn nàn Ta nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Môi-se vâng lời Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Người Ít-ra-ên hoảng sợ nói với Môi-se: “Chúng tôi bị diệt! Chúng tôi bị chết hết! ");
INSERT INTO vieovcb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Nếu ai đến gần Đền Tạm của Chúa Hằng Hữu đều chết, thì chúng tôi chết hết sao! Nguy quá, chúng tôi sẽ bị tiêu diệt mất!” ");
INSERT INTO vieovcb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Chúa Hằng Hữu phán bảo A-rôn: “Con, các con trai con cùng cả gia đình con phải chịu trách nhiệm về những tội xúc phạm nơi thánh. Cũng vậy, con và các con trai con phải chịu trách nhiệm về những tội liên hệ đến chức vụ thầy tế lễ. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Tất cả những người trong đại tộc Lê-vi, họ hàng của con, là người giúp việc cho con. Tuy nhiên, chỉ có con và các con trai con được thi hành chức vụ trong Đền Giao Ước. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Các người Lê-vi khác không được đến gần các vật thánh hay bàn thờ, để họ và con khỏi phải chết. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ngoài người Lê-vi ra, không ai được phụ giúp con trong các công việc tại Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Và chỉ có các thầy tế lễ mới được thi hành chức vụ trong nơi thánh và trước bàn thờ. Nếu các nguyên tắc này được tôn trọng, cơn phẫn nộ của Ta sẽ không nổi lên với người Ít-ra-ên nữa. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Người Lê-vi đã được Chúa Hằng Hữu chọn trong người Ít-ra-ên; họ đã được dâng lên Chúa Hằng Hữu. Nay Ta giao họ cho con để giúp con trong công việc Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ta cũng ủy thác cho con chức vụ thầy tế lễ; chỉ có con và các con trai con thi hành chức vụ này trước bàn thờ và bên trong bức màn. Ngoài ra, người nào đụng đến các công việc này đều phải chết.” ");
INSERT INTO vieovcb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Chúa Hằng Hữu phán tiếp với A-rôn: “Ngoài ra, Ta còn cho các con tất cả lễ vật của người Ít-ra-ên dâng theo lối nâng tay đưa lên trước Chúa. Các lễ vật thánh đều thuộc về con và con trai con. Lệ này áp dụng vĩnh viễn. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Trừ phần được đem đốt dâng lên, phần còn lại của các lễ vật ngũ cốc, lễ vật chuộc tội, và lễ vật chuộc lỗi—sẽ rất thánh, đều thuộc về con và các con trai con. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Con phải ăn phần ấy như lễ vật rất thánh. Mọi người nam phải ăn và đó như là lễ vật rất thánh cho con. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Còn các lễ vật được dâng lên theo lối đưa qua đưa lại cũng thuộc về con. Ta ban cho các con trai và con gái con. Mọi người trong gia đình đều được phép ăn, nếu họ tinh sạch. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ta cũng cho con tất cả các lễ vật đầu mùa người ta đem dâng lên Chúa Hằng Hữu: Dầu, rượu, ngũ cốc tốt nhất. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Tất cả lễ vật đầu mùa của các thổ sản khác. Mọi người tinh sạch trong gia đình con đều được phép ăn. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Vậy, tất cả mọi vật người Ít-ra-ên dâng hiến cho Ta đều thuộc về con, kể cả các con trưởng nam và thú vật đầu lòng của họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tuy nhiên, con trưởng nam và con đầu lòng của thú vật mà đã dâng lên Chúa Hằng Hữu đều sẽ thuộc về con. Nhưng con trưởng nam và con đầu lòng của thú vật không sạch phải được chuộc lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Giá chuộc là 57 gam bạc theo cân nơi thánh, và phải chuộc lúc con trưởng nam hay con đầu lòng lên một tháng. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Đối với con đầu lòng của các loài bò, chiên, và dê thì không được chuộc, nhưng phải lấy máu rảy trên bàn thờ, lấy mỡ đem đốt, dùng lửa dâng hương thơm lên Chúa. Đó là những sinh tế thánh. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Thịt của các sinh tế này thuộc về con, đặc biệt là cái ức được đưa qua đưa lại và cái đùi bên phải. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Tóm lại, Ta cho con mọi lễ vật của người Ít-ra-ên dâng theo lối đưa qua đưa lại trước mặt Chúa Hằng Hữu. Tất cả nam lẫn nữ trong gia đình con đều được phép ăn. Đây là luật lệ vĩnh viễn, là một giao ước bất di bất dịch giữa Chúa Hằng Hữu với con và con cháu con.” ");
INSERT INTO vieovcb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Chúa Hằng Hữu tiếp: “Con sẽ không có sản nghiệp, cũng không có quyền lợi nào trong dân Ta. Vì Ta là nguồn lợi và sản nghiệp của con. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Tất cả những phần mười lợi tức của người Ít-ra-ên đem dâng lên Ta, Ta ban cho người Lê-vi vì công khó phục dịch trong Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Từ nay về sau, ngoại trừ các thầy tế lễ và người Lê-vi thì không người Ít-ra-ên nào được vào Đền Tạm để khỏi mắc tội và khỏi chết. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Người Lê-vi sẽ chịu trách nhiệm về công việc Đền Tạm, và nếu có lỗi lầm, họ sẽ mang tội. Đây là một luật có tính cách vĩnh viễn áp dụng qua các thế hệ: Người Lê-vi sẽ không thừa hưởng tài sản trong Ít-ra-ên, ");
INSERT INTO vieovcb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","vì Ta đã cho họ một phần mười lợi tức của người Ít-ra-ên, là phần dân chúng đem dâng (theo lối nâng tay dâng lên) cho Chúa Hằng Hữu, đó là phần người Lê-vi thừa hưởng. Ngoài ra, họ không được hưởng sản nghiệp nào trong dân cả.” ");
INSERT INTO vieovcb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Chúa Hằng Hữu cũng phán với Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Hãy bảo người Lê-vi rằng khi nhận được một phần mười lợi tức của người Ít-ra-ên, phải lấy một phần mười dâng lên Chúa Hằng Hữu, theo lối nâng tay dâng lên, một phần mười của một phần mười. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Lễ vật này sẽ được coi như lễ vật đầu mùa chọn lọc, như ngũ cốc dâng từ sân đạp lúa, như rượu nho dâng từ bồn ép nho của họ vậy. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Vậy trong tất cả phần mười anh em nhận được từ người Ít-ra-ên, anh em phải dành riêng một lễ vật dâng lên Chúa Hằng Hữu, và anh em hãy giao lễ vật ấy cho Thầy Tế lễ A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Trong tất cả những món quà anh em nhận được, anh em hãy dành riêng phần tốt nhất dâng lên Chúa Hằng Hữu; đó là phần biệt riêng ra thánh cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Khi người Lê-vi chọn phần tốt nhất dâng lên như vậy, lễ vật của họ mới được coi như thổ sản của họ dâng từ sân đập lúa, từ bồn ép nho mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Vì đây là phần thưởng công khó phục dịch của họ trong Đền Tạm, họ và gia đình họ được phép đem ăn bất kỳ nơi nào họ muốn. ");
INSERT INTO vieovcb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Họ sẽ không có lỗi gì cả, miễn là họ dâng lên phần tốt nhất. Vậy, để khỏi mang tội mà chết, họ không được xúc phạm lễ vật thánh của người Ít-ra-ên đã dâng lên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Chúa Hằng Hữu phán dạy Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Đây là một luật khác phải được tuân hành: Hãy nói với người Ít-ra-ên chọn một con bò cái tơ màu đỏ, không tì vít, chưa hề mang ách, ");
INSERT INTO vieovcb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","đem đến cho Thầy Tế lễ Ê-lê-a-sa. Thầy tế lễ sẽ đem con bò ra ngoài trại, và chứng kiến việc người ta giết nó. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Thầy Tế lễ Ê-lê-a-sa sẽ lấy ngón tay nhúng vào máu bò, rảy bảy lần phía trước Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Sau đó, thầy tế lễ sẽ trông coi việc thiêu con bò; cả da, thịt, máu, và phân bò đều phải thiêu hết. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Thầy tế lễ sẽ lấy cây bá hương, cành bài hương thảo, và chỉ đỏ ném vào giữa con bò đang cháy. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Xong, thầy tế lễ phải giặt áo, tắm, rồi mới vào trại và phải chịu ô uế cho đến tối hôm ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Người đốt con bò cũng phải giặt áo, tắm, và chịu ô uế cho đến tối hôm ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Một người tinh sạch sẽ hốt tro con bò chứa vào một nơi sạch sẽ bên ngoài trại. Tro này sẽ dùng làm nước tẩy uế cho người Ít-ra-ên, để tẩy sạch tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Người hốt tro phải giặt áo và chịu ô uế cho đến tối hôm ấy. Luật này có tính cách vĩnh viễn, áp dụng cho người Ít-ra-ên cũng như cho ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ai đụng vào người chết, phải bị ô uế bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Người ấy phải dùng nước tẩy uế tẩy sạch mình vào ngày thứ ba và ngày thứ bảy, thì mới được sạch. Nếu không, sẽ không được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Người nào đụng vào người chết mà không lo tẩy sạch mình là xúc phạm Đền Tạm của Chúa Hằng Hữu, và phải bị trục xuất khỏi cộng đồng Ít-ra-ên. Vì nước tẩy uế chưa được rảy trên mình nên người ấy vẫn còn ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Khi có người chết trong một trại, phải áp dụng quy tắc này: Người nào vào trại và người nào ở trong trại đều bị ô uế bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Nếu trong trại ấy có bình hay đồ chứa nào không đậy nắp, vật ấy cũng bị ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ngoài trại quân, nếu ai đụng vào một người chết vì đâm chém, hoặc đụng vào một xác chết, xương người chết hay mồ mả, người ấy bị ô uế bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Muốn tẩy sạch những người này, người ta phải lấy một ít tro của con bò thiêu làm sinh tế chuộc tội bỏ vào một cái bình, rồi lấy nước sông hay nước suối đổ vào. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Một người tinh sạch sẽ lấy cành bài hương thảo nhúng vào bình, rảy nước trên trại, trên tất cả đồ dùng trong trại, trên cả những người ở trại đó, và người đã đụng vào xương hay đụng vào người bị giết, xác chết, hay mồ mả. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Phải làm như vậy vào ngày thứ ba và ngày thứ bảy, rồi người bị ô uế phải giặt áo, tắm rửa, thì tối hôm ấy mới được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Một người ô uế không lo tẩy mình phải bị trục xuất khỏi cộng đồng Ít-ra-ên, vì đã xúc phạm đến nơi thánh của Chúa Hằng Hữu. Nếu nước tẩy uế không được rảy trên người ấy, người ấy không được sạch. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Đó là một luật có tính cách vĩnh viễn. Ngoài ra, người rảy nước sẽ phải giặt áo mình, và người nào đụng vào nước này sẽ chịu ô uế cho đến tối hôm ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Bất kỳ vật gì đã bị người ô uế đụng vào đều thành ô uế, và ai đụng vào vật ấy cũng bị ô uế cho đến tối hôm ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Toàn thể dân chúng Ít-ra-ên đi vào hoang mạc Xin vào tháng thứ nhất, họ dừng chân tại Ca-đe. Mi-ri-am qua đời và được an táng tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Khi thấy không có nước uống, dân chúng họp nhau lại chống đối Môi-se và A-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Họ hỏi Môi-se: “Thà chúng tôi chết cùng anh em chúng tôi trong lần họ chết trước mặt Chúa Hằng Hữu vừa rồi. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Tại sao ông đem dân của Chúa Hằng Hữu vào hoang mạc cho chết khát cả người lẫn súc vật? ");
INSERT INTO vieovcb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Tại sao ông bắt chúng tôi bỏ Ai Cập để vào nơi khốn nạn này, là nơi không có ai gieo giống, trồng cây vả, cây nho, cây lựu gì được, là nơi không có nước uống?” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Môi-se và A-rôn liền bỏ họ, đi đến cửa Đền Tạm, quỳ mọp xuống. Vinh quang của Chúa Hằng Hữu hiện ra, ");
INSERT INTO vieovcb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","và Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Cầm cây gậy này, rồi con và A-rôn triệu tập dân chúng lại. Trước mặt họ, con sẽ bảo vầng đá kia phun nước ra, con sẽ cho họ và bầy gia súc của họ uống nước chảy ra từ vầng đá.” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Vậy Môi-se lấy cây gậy trước mặt Chúa Hằng Hữu, theo lời Ngài phán dạy. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Môi-se cùng với A-rôn triệu tập mọi người đến bên vầng đá, xong ông nói: “Dân phản loạn, nghe đây! Chúng ta phải lấy nước từ trong vầng đá này ra cho mọi người uống sao?” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Nói xong, Môi-se vung gậy đập vào vầng đá hai lần. Nước liền bắn vọt ra lai láng. Vậy toàn dân và thú vật đều uống. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Nhưng Chúa Hằng Hữu trách Môi-se và A-rôn: “Vì các con không tin Ta, không tôn thánh Ta trước mắt người Ít-ra-ên, nên các con sẽ không dẫn họ vào đất Ta hứa cho!” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Nơi đó được gọi là nước Mê-ri-ba, vì người Ít-ra-ên đã cãi lẽ với Chúa Hằng Hữu tại đó, nhưng Ngài đã tỏ đức thánh khiết của Ngài cho họ thấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Sau đó, Môi-se sai sứ giả đi từ Ca-đe đến yêu cầu vua nước Ê-đôm rằng: “Chúng tôi là con cháu Ít-ra-ên, vào hàng em của vua. Chắc vua đã biết qua nỗi gian khổ của chúng tôi rồi. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Tổ phụ chúng tôi đã xuống Ai Cập và ở lại đó lâu ngày; người Ai Cập cư xử với chúng tôi rất bạo tàn. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Chúng tôi kêu đến Chúa Hằng Hữu; Ngài nghe, sai thiên sứ đem chúng tôi ra khỏi Ai Cập, và bây giờ chúng tôi đang ở Ca-đe, một thị trấn ở ngay biên giới quý quốc. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Xin cho chúng tôi đi nhờ qua đất của vua. Chúng tôi sẽ đi tránh đồng ruộng, vườn nho, cũng không múc nước dưới giếng mà uống. Chúng tôi sẽ đi trên đường cái, không rời khỏi chính lộ cho đến khi ra khỏi biên giới.” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Nhưng vua Ê-đôm đáp: “Không được đi qua đất nước ta. Nếu không nghe, ta sẽ đem quân ra đánh!” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Sứ giả Ít-ra-ên thưa: “Chúng tôi chỉ đi trên đường cái. Dù nước cũng không uống, nếu uống chúng tôi xin trả tiền. Chỉ xin cho chúng tôi đi qua, ngoài ra chúng tôi không xin gì khác.” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Vua Ê-đôm đáp cách cương quyết: “Không được! Các ngươi không được đi qua vùng đất của ta.” Rồi Ê-đôm kéo quân đội hùng hậu ra ngăn chặn Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Vì Ê-đôm từ chối không cho Ít-ra-ên đi qua đất mình, nên Ít-ra-ên tránh đi nơi khác. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Toàn dân Ít-ra-ên từ Ca-đe kéo đến Núi Hô-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Tại núi Hô-rơ, cạnh biên giới Ê-đôm, Chúa Hằng Hữu phán bảo Môi-se và A-rôn: ");
INSERT INTO vieovcb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“A-rôn sẽ về với tổ phụ mình, không được vào đất hứa cho Ít-ra-ên, vì hai con đã phản nghịch Ta tại Mê-ri-ba. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Môi-se, con hãy đem A-rôn và Ê-lê-a-sa lên Núi Hô-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ở đó, con sẽ lấy áo lễ của A-rôn mặc cho Ê-lê-a-sa. A-rôn sẽ qua đời tại đó.” ");
INSERT INTO vieovcb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Môi-se tuân lệnh Chúa Hằng Hữu. Ba người lên Núi Hô-rơ trước sự chứng kiến của dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Trên đỉnh núi, Môi-se lấy bộ áo lễ của A-rôn, mặc cho Ê-lê-a-sa, con A-rôn. A-rôn qua đời trên đỉnh núi này. Sau đó, Môi-se và Ê-lê-a-sa xuống núi. ");
INSERT INTO vieovcb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Khi biết A-rôn mất, toàn thể dân chúng Ít-ra-ên khóc ông suốt ba mươi ngày. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Khi Vua A-rát, người Ca-na-an, ở Nê-ghép, nghe tin người Ít-ra-ên kéo đến theo lối A-tha-rim, liền đem quân ra đánh, bắt được mấy người làm tù binh. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Lúc ấy, người Ít-ra-ên thề nguyện với Chúa Hằng Hữu rằng: “Nếu Ngài cho chúng tôi chiến thắng dân này, chúng tôi xin tiêu diệt tất cả thành của họ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Chúa Hằng Hữu nghe lời ngươi Ít-ra-ên cầu nguyện nên cho họ thắng quân Ca-na-an. Người Ít-ra-ên tận diệt quân thù, tàn phá các thành, và đặt tên vùng này là Họt-ma. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Từ Núi Hô-rơ, họ phải quay lại Biển Đỏ, đi vòng quanh để tránh đất Ê-đôm, vì thế, họ cảm thấy rất chán nản. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Họ lại xúc phạm Đức Chúa Trời và cằn nhằn với Môi-se: “Vì sao ông đem chúng tôi ra khỏi Ai Cập để chết trong hoang mạc này? Chúng tôi chẳng có nước uống, chẳng có gì ăn ngoài loại bánh đạm bạc chán ngấy này!” ");
INSERT INTO vieovcb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Chúa Hằng Hữu sai rắn lửa đến, cắn nhiều người chết. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Người ta chạy đến với Môi-se nói: “Chúng tôi có tội, vì đã nói xúc phạm đến Chúa Hằng Hữu và ông. Xin ông cầu với Chúa Hằng Hữu để Ngài đuổi rắn đi.” Môi-se cầu thay cho dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Chúa Hằng Hữu phán bảo Môi-se: “Con làm một con rắn lửa, treo trên một cây sào. Người nào bị rắn cắn chỉ cần nhìn nó là được sống.” ");
INSERT INTO vieovcb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Vậy Môi-se làm một con rắn bằng đồng, treo trên một cây sào. Hễ ai bị rắn cắn nhìn lên con rắn đồng, liền được thoát chết. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Người Ít-ra-ên tiếp tục lên đường, và dừng chân cắm trại tại Ô-bốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Từ Ô-bốt ra đi, họ cắm trại tại Y-giê A-ba-rim trong hoang mạc, về phía đông Mô-áp. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Từ đó ra đi, họ cắm trại tại thung lũng Xê-rết. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Tiếp tục lên đường, họ dừng chân phía bên kia Sông Ạt-nôn, trong hoang mạc, gần biên giới Am-môn. Sông Ạt-nôn là biên giới giữa Mô-áp và A-mô-rít. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Vì thế, trong sách “Chiến Trận của Chúa Hằng Hữu” có nói đến Va-hép ở Su-pha và triền thung lũng của Sông Ạt-nôn, ");
INSERT INTO vieovcb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","chạy dài đến đất A-rơ và biên giới Mô-áp. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Họ lại lên đường đi đến Bê-e (nghĩa là giếng nước). Tại giếng ấy, Chúa Hằng Hữu phán bảo Môi-se: “Tập họp dân lại, Ta sẽ cho họ nước uống.” ");
INSERT INTO vieovcb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Và người Ít-ra-ên hát lên rằng: “Trào nước lên, giếng hỡi! Cho ta ca ngợi! ");
INSERT INTO vieovcb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Giếng vua khơi bằng cây phủ việt, quý tộc đào với gậy nơi tay.” Rồi họ ra khỏi hoang mạc, đi đến Ma-tha-na. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Từ Ma-tha-na họ đến Na-ha-li-ên; từ Na-ha-li-ên đến Ba-mốt; ");
INSERT INTO vieovcb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","từ Ba-mốt đến thung lũng ở trong địa phận Mô-áp; qua đỉnh núi Phích-ga—từ đó có thể nhìn thấy khắp hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Người Ít-ra-ên sai sứ nói với vua A-mô-rít là Si-hôn rằng: ");
INSERT INTO vieovcb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Xin cho chúng tôi đi qua đất vua. Chúng tôi chỉ theo đường cái của vua mà đi, không vào ruộng hay vườn nho, không uống nước giếng, cho đến khi ra khỏi lãnh thổ của vua.” ");
INSERT INTO vieovcb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Nhưng Vua Si-hôn khước từ. Ông triệu tập quân đội, kéo ra đón người Ít-ra-ên trong hoang mạc, và tấn công họ tại Gia-hát. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Người Ít-ra-ên chém Vua Si-hôn, chiếm lấy đất từ Ạt-nôn đến Gia-bốc, cho đến tận biên giới nước Am-môn, vì biên cương của Am-môn rất kiên cố. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ít-ra-ên chiếm hết các thành, làng mạc của người A-mô-rít cho dân mình ở, kể cả thành Hết-bôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hết-bôn là kinh đô của Si-hôn, vua A-mô-rít. Trước kia, Si-hôn đã đánh bại vua Mô-áp, chiếm đoạt hết đất của vua này cho đến sông Ạt-nôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Cho nên, một thi sĩ đã viết: “Ta kéo đến Hết-bôn! Xây thành của Si-hôn! ");
INSERT INTO vieovcb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Vì có lửa từ Hết-bôn, một ngọn lửa từ thành của Si-hôn. Thiêu đốt thành A-rơ của Mô-áp cháy rụi, là thành ngự trị trên dòng Ạt-nôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Thống khổ cho người Mô-áp! Ngày tàn của ngươi đã tới! Này, Kê-mốt hỡi! Con trai ngươi phải lưu lạc, con gái ngươi bị tù đày, bởi tay Si-hôn, vua người A-mô-rít. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Lính ngươi bị bắn ngã, Hết-bôn bị hủy phá tàn tạ Đi-bôn, Nô-phách, Mê-đê-ba: Đều bị thiêu hủy cả.” ");
INSERT INTO vieovcb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Trong khi Ít-ra-ên còn đóng quân trong đất của người A-mô-rít, ");
INSERT INTO vieovcb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Môi-se sai người đi trinh sát Gia-ê-xe. Rồi Ít-ra-ên chiếm hết các làng mạc miền Gia-ê-xe, trục xuất người A-mô-rít đi. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Sau đó, Ít-ra-ên quay lại đi lên hướng Ba-san. Vua Ba-san là Óc kéo toàn dân mình ra chận đón Ít-ra-ên tại Ết-rê-i. ");
INSERT INTO vieovcb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Chúa Hằng Hữu phán bảo Môi-se: “Đừng sợ vua ấy, vì Ta đặt số phận dân này vào tay con. Việc đã xảy ra cho Si-hôn, vua A-mô-rít, người cai trị Hết-bôn cũng sẽ xảy ra cho vua Ba-san.” ");
INSERT INTO vieovcb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ít-ra-ên giết Vua Óc, và các con vua, thần dân của vua, không để một ai sống sót, rồi chiếm đóng đất nước Ba-san. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Sau đó, người Ít-ra-ên lại ra đi, đến đồng bằng Mô-áp, và cắm trại bên kia Sông Giô-đan, đối diện Giê-ri-cô. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ba-lác, vua Mô-áp, con Xếp-bô, thấy những việc người Ít-ra-ên làm cho người A-mô-rít. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mô-áp càng kinh hoàng vì thấy người Ít-ra-ên đông đảo quá. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Người Mô-áp bàn với các trưởng lão Ma-đi-an: “Dân này sẽ ăn nuốt chúng ta như bò ăn cỏ vậy!” Vì thế, Ba-lác, vua Mô-áp ");
INSERT INTO vieovcb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","gửi một phái đoàn đi tìm Ba-la-am, con của Bê-ô ở Phê-thô-rơ gần Sông Ơ-phơ-rát, nói rằng: “Một dân tộc đến từ Ai Cập đông như kiến, phủ đầy mặt đất, đang đóng đối diện chúng tôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Xin ông đến nguyền rủa họ, vì họ mạnh hơn chúng tôi. Có lẽ nhờ ông, chúng tôi có thể đuổi họ đi. Vì tôi biết rằng, ai được ông chúc phước sẽ được phước, còn ai bị ông nguyền rủa sẽ bị tai họa.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Các sứ giả của Ba-lác (gồm các trưởng lão Mô-áp và Ma-đi-an) bưng lễ vật trong tay đến gặp Ba-la-am trình bày tự sự. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ba-la-am nói: “Các ông nghỉ lại đây đêm nay. Tôi sẽ trả lời các ông tùy theo điều Chúa Hằng Hữu phán dạy tôi.” Vậy họ ở lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Đức Chúa Trời hiện ra hỏi Ba-la-am: “Họ là ai?” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ba-la-am thưa với Đức Chúa Trời: “Đó là những người được vua Mô-áp—Ba-lác, con Xếp-bô—sai đến. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Vua ấy nói có một dân tộc đến từ Ai Cập, đông như kiến, phủ đầy mặt đất. Vua ấy muốn tôi đến nguyền rủa dân đó để vua có thể đánh đuổi họ đi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nhưng Đức Chúa Trời phán với Ba-la-am: “Ngươi không được đi với họ, không được nguyền rủa dân kia, vì đó là dân được chúc phước!” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Vậy sáng hôm sau, Ba-la-am thức dậy, nói với các trưởng lão Ba-lác: “Các ông về đi! Chúa Hằng Hữu cấm tôi đi với các ông.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Các trưởng lão ra về, trình với Vua Ba-lác: “Ba-la-am từ chối, không đến.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tuy nhiên, Ba-lác cử một phái đoàn thứ hai đông hơn, gồm những người chức cao tước trọng hơn phái đoàn trước. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Họ đến gặp Ba-la-am và chuyển lời cho ông rằng: “Vua Ba-lác, con Xếp-bô khẩn khoản mời ông đến. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Vua hứa sẽ phong cho ông phẩm tước cao trọng và ban cho ông mọi điều gì ông muốn, miễn là ông đến nguyền rủa dân tộc kia cho vua!” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Nhưng Ba-la-am đáp: “Dù Ba-lác có cho tôi cung điện chứa đầy vàng bạc, tôi cũng không thể làm gì ngoài những điều Chúa Hằng Hữu tôi dạy bảo. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Bây giờ, xin các ông nghỉ lại đêm nay nữa, để xem Chúa Hằng Hữu có bảo thêm điều gì khác không.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Đêm đó, Đức Chúa Trời phán dạy Ba-la-am: “Nếu họ đến mời, thì cứ dậy đi với họ. Nhưng ngươi chỉ được nói điều gì Ta phán.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ba-la-am dậy, thắng lừa, và ra đi với các trưởng lão Mô-áp lúc trời sáng. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Việc ông ra đi làm cho Đức Chúa Trời buồn giận. Thiên sứ của Chúa Hằng Hữu đứng trên đường cản ông. Khi Ba-la-am và hai người đầy tớ cưỡi lừa đi qua, ");
INSERT INTO vieovcb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","con lừa thấy thiên sứ của Chúa Hằng Hữu đứng trên đường, tay cầm lưỡi gươm trần, liền đi tẽ xuống ruộng để tránh. Ba-la-am đánh nó, bắt nó phải đi lên đường cái. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Thiên sứ của Chúa Hằng Hữu đến đứng tại một khúc đường chạy qua giữa hai vườn nho, hai bên đường đều có tường nên con đường hẹp lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Khi thấy thiên sứ của Chúa Hằng Hữu, con lừa nép vào tường, làm kẹt chân Ba-la-am nên ông lại đánh nó. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Thiên sứ của Chúa Hằng Hữu đi trước, đến đứng tại một khúc đường rất hẹp, không có chỗ để quay đầu phía nào cả. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Lần này, con lừa chỉ còn cách nằm mọp xuống khi thấy thiên sứ của Chúa Hằng Hữu. Ba-la-am nổi giận lấy gậy đánh con lừa. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Chúa Hằng Hữu mở miệng con lừa, nó nói với Ba-la-am: “Con đã làm gì quấy mà ông đánh con đến ba lần?” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ba-la-am nói: “Vì mày sỉ nhục ta! Nếu có gươm trong tay, ta đã giết mày rồi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Lừa lại hỏi: “Trước nay, con không phải là con lừa ông cưỡi suốt đời sao? Có bao giờ con làm như vậy chưa?” Ba-la-am đáp: “Chưa.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Bấy giờ, Đức Chúa Trời mở mắt Ba-la-am, ông thấy thiên sứ của Chúa Hằng Hữu đứng trên đường, tay cầm gươm tuốt trần, liền vội cúi đầu, sấp mặt xuống đất. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Thiên sứ của Chúa Hằng Hữu hỏi: “Tại sao ngươi đánh con lừa ba lần? Ta đến để ngăn cản ngươi, vì đường ngươi đi dẫn đến chỗ diệt vong. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Vì con lừa thấy ta nên nó tránh ta ba lần; nếu không, ta đã giết ngươi và để cho nó sống.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ba-la-am nói với Thiên sứ của Chúa Hằng Hữu: “Tôi đã phạm tội. Tôi đã không biết thiên sứ đứng trên đường cản lối tôi. Nếu thiên sứ không vừa ý, tôi xin quay về.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Thiên sứ của Chúa Hằng Hữu phán bảo: “Cứ đi với họ, nhưng ngươi chỉ được nói lời nào Ta bảo ngươi nói.” Vậy Ba-la-am đi với các quan chức của Ba-lác. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Nghe tin Ba-la-am đến, Ba-lác ra tận đầu biên giới tiếp đón, tại một thành Mô-áp bên sông Ạt-nôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Vua Ba-lác hỏi Ba-la-am: “Ta đã gửi người đi mời lần trước, sao ông không đến? Ta không đủ sức làm cho ông được vẻ vang nhất đời sao?” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ba-la-am đáp: “Tôi đến đây rồi, nhưng tôi không được quyền nói gì hết. Trừ những lời Đức Chúa Trời bảo tôi nói.” ");
INSERT INTO vieovcb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Và Ba-la-am đi với Ba-lác đến Ki-ri-át Hu-xốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Tại đó, Ba-lác sai giết bò, chiên để cúng tế. Vua cũng sai đem lễ vật đến biếu Ba-la-am và các trưởng lão đi cùng ông. ");
INSERT INTO vieovcb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Sáng hôm sau, Ba-lác đem Ba-la-am lên đỉnh Ba-mốt Ba-anh. Từ đó có thể trông thấy phía cuối trại quân Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ba-la-am nói với Ba-lác: “Xin xây bảy bàn thờ tại đây, và đem đến cho tôi bảy con bò đực và bảy con chiên đực.” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ba-lác làm theo lời yêu cầu của Ba-la-am, cứ mỗi bàn thờ dâng một con bò và một con chiên. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Rồi Ba-la-am tâu với Ba-lác: “Xin vua đứng đó, bên cạnh của lễ thiêu mình. Tôi đi đằng này, xem có gặp Chúa Hằng Hữu không; may ra gặp được, tôi sẽ cho vua biết những điều Ngài bảo tôi.” Ba-la-am đi lên một hòn núi trọc, ");
INSERT INTO vieovcb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Đức Chúa Trời gặp ông ở đó. Ba-la-am thưa: “Tôi có dọn bảy bàn thờ, trên mỗi cái tôi dâng một con bò và một con chiên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Chúa Hằng Hữu phán bảo Ba-la-am về gặp Ba-lác, nói lại những lời Ngài dặn. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Khi Ba-la-am về, thấy Ba-lác và các trưởng lão Mô-áp vẫn đứng bên cạnh của lễ thiêu. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ba-la-am nói tiên tri rằng: “Ba-lác, vua Mô-áp mời tôi đến từ đất A-ram; từ các dãy núi miền đông. Ông bảo tôi: ‘Hãy đến nguyền rủa Gia-cốp! Nhục mạ Ít-ra-ên.’ ");
INSERT INTO vieovcb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nhưng tôi đâu dám nguyền rủa người mà Chúa Hằng Hữu không nguyền rủa! Tôi đâu dám lăng mạ người mà Đức Chúa Trời không lăng mạ! ");
INSERT INTO vieovcb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Tôi thấy họ từ đỉnh núi; nhìn họ từ đồi cao. Họ là một dân tộc sống riêng rẽ, không chịu trà trộn với các nước khác. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Con cháu của Gia-cốp nhiều như bụi. Ai có thể đếm được một phần tư dân số Ít-ra-ên? Xin cho tôi chết cái chết của người công chính; xin cho tôi qua đời giống như một người Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Vua Ba-lác sửng sốt hỏi Ba-la-am: “Ông làm gì vậy? Ta mời ông đến nguyền rủa quân thù, ông lại đi chúc phước cho họ!” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ba-la-am đáp: “Tôi đâu dám ngậm miệng không nói những gì Chúa Hằng Hữu phán bảo tôi!” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Vua Ba-lác lại nói: “Thôi, ông đi với ta đến một nơi khác, từ đó ông sẽ trông thấy một phần của dân ấy. Hãy đứng đó nguyền rủa họ cho ta!” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Rồi vua đem ông đến cánh đồng Xô-phim, lên đỉnh núi Phích-ga, xây bảy bàn thờ, dâng trên mỗi bàn thờ một con bò và một con chiên. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ba-la-am nói: “Xin vua đứng đây bên cạnh của lễ thiêu, để tôi đi gặp Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Chúa Hằng Hữu gặp Ba-la-am, bảo ông về nói lại cho Ba-lác nghe những lời Ngài phán dặn. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ông về, thấy Ba-lác vẫn đứng bên của lễ thiêu cùng với các trưởng lão Mô-áp. Ba-lác hỏi: “Chúa Hằng Hữu dạy thế nào?” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ba-la-am liền đáp: “Ba-lác, đứng lên nghe đây! Con trai Xếp-bô, lắng tai nghe lời này! ");
INSERT INTO vieovcb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Đức Chúa Trời đâu phải loài người để nói dối, hay để đổi thay ý kiến? Có bao giờ Ngài nói điều gì rồi không làm không? ");
INSERT INTO vieovcb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Và đây, tôi lại được lệnh chúc phước; vì Đức Chúa Trời ban phước họ, tôi làm sao cãi được? ");
INSERT INTO vieovcb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ngài không bắt tội Gia-cốp; cũng chẳng kể Ít-ra-ên là gian tà. Chúa Hằng Hữu là Đức Chúa Trời ở với họ; Ngài là Vua lãnh đạo họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Chúa dẫn họ ra khỏi Ai Cập; họ thấy Ngài dũng mãnh như bò rừng. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Không ai bùa ếm Gia-cốp nổi; không tà thuật nào khống chế được Ít-ra-ên. Vì đây là lúc nói về: ‘Những việc lớn lao Đức Chúa Trời đã làm cho Ít-ra-ên!’ ");
INSERT INTO vieovcb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Như sư tử, họ vùng lên; chỉ chịu nằm xuống khi nào đã ăn xong mồi bắt được, và uống máu kẻ bị giết!” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Nghe thế, Ba-lác phàn nàn Ba-la-am: “Nếu ông không nguyền rủa thì cũng đừng chúc phước cho họ chứ!” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ba-la-am đáp: “Tôi đã thưa trước rồi, tôi chỉ được quyền nói những điều Chúa Hằng Hữu phán bảo tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Một lần nữa, Vua Ba-lác đề nghị Ba-la-am: “Để ta đem ông đến một nơi khác. Mong rằng lần này ta sẽ làm vừa ý Đức Chúa Trời, và Ngài sẽ cho ông nguyền rủa họ tại đó.” ");
INSERT INTO vieovcb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Vậy, Ba-lác đưa Ba-la-am lên đỉnh núi Phê-ô, từ đó nhìn thấy hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ba-la-am lại yêu cầu Ba-lác xây bảy bàn thờ, đem đến bảy con bò và bảy con chiên. ");
INSERT INTO vieovcb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ba-lác làm theo lời yêu cầu Ba-la-am, và họ lại dâng một con bò, một con chiên trên mỗi bàn thờ. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ngay lúc ấy, Ba-la-am nhận thức rằng Chúa Hằng Hữu chỉ muốn ông chúc phước người Ít-ra-ên, nên ông không đi một nơi khác như những lần trước để tìm Chúa, nhưng quay nhìn về phía hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Xa xa, ông thấy các trại quân Ít-ra-ên, cắm riêng từng đại tộc. Được Thần của Đức Chúa Trời cảm thúc, ");
INSERT INTO vieovcb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ba-la-am nói tiên tri như sau: “Lời tiên tri của Ba-la-am, con trai Bê-ô, là người có đôi mắt mở ra, ");
INSERT INTO vieovcb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","người nghe được lời của Đức Chúa Trời, thấy được khải tượng của Đấng Toàn Năng, dù người ngã, mắt người vẫn mở: ");
INSERT INTO vieovcb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Lều của Gia-cốp; trại của Ít-ra-ên đẹp mắt thật! ");
INSERT INTO vieovcb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Như thung lũng chạy dài, như vườn tược cạnh mé sông. Như cây trầm hương được tay Chúa Hằng Hữu vun trồng, như cây bá hương mọc bên dòng nước. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Họ sẽ có nước ngọt tràn trề dư dật; con cháu họ không hề sống nơi khô hạn. Vua họ có uy quyền cao hơn A-ga; quốc vương họ hùng mạnh thăng tiến. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Đức Chúa Trời đem họ ra khỏi Ai Cập; họ trở nên dũng mãnh như bò rừng. Họ nuốt tươi các nước cừu địch. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Họ nghỉ ngơi như sư tử nằm ngủ; ai dám đánh thức? Ai chúc phước họ sẽ hưởng hạnh phước, ai nguyền rủa họ sẽ bị tai ương.” ");
INSERT INTO vieovcb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Đến đây, Vua Ba-lác không ngăn được cơn giận, hai tay đập vào nhau, lên giọng quở Ba-la-am: “Ta gọi ông đến để nguyền rủa kẻ thù cho ta, ông lại đi chúc phước họ ba lần. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Thôi ông về đi! Ta có hứa làm cho ông được vẻ vang, nhưng Chúa Hằng Hữu không cho ông hưởng vinh dự.” ");
INSERT INTO vieovcb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ba-la-am đáp Ba-lác: “Tôi đã bảo sứ giả của vua là, ");
INSERT INTO vieovcb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","dù Vua Ba-lác có cho tôi cung điện đầy vàng bạc, tôi cũng không tự mình làm điều gì được cả. Chúa Hằng Hữu phán bảo tôi nói gì, tôi phải nói đúng như vậy! ");
INSERT INTO vieovcb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Bây giờ, trước khi về, tôi xin nói trước những điều Ít-ra-ên sẽ làm cho thần dân của vua.” ");
INSERT INTO vieovcb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Và Ba-la-am tiếp: “Đây là lời tiên tri của Ba-la-am, con trai Bê-ô, người có đôi mắt mở ra, ");
INSERT INTO vieovcb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","người nghe được lời của Đức Chúa Trời, nhận thức được cao kiến của Đấng Chí Cao, thấy được khải tượng của Đấng Toàn Năng, dù người ngã, mắt người vẫn mở: ");
INSERT INTO vieovcb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Tôi thấy trong tương lai có một Ngôi Sao xuất phát từ nhà Gia-cốp; một cây gậy xuất phát từ Ít-ra-ên này sẽ đánh Mô-áp tan tành, tận diệt dòng dõi loạn lạc của Sết. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ít-ra-ên sẽ biểu dương lực lượng, chiếm Ê-đôm và Sê-i-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Vì vua uy quyền xuất phát từ nhà Gia-cốp sẽ tiêu diệt những người sống sót trong các thành thị.” ");
INSERT INTO vieovcb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Sau đó, Ba-la-am nhìn về phía người A-ma-léc, nói những lời sau đây: “A-ma-léc đứng đầu trong các quốc gia, nhưng rốt cuộc phải chịu tàn phá.” ");
INSERT INTO vieovcb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ông nhìn về phía người Kê-nít, nói tiếp: “Nơi ngươi ở thật là vững chắc; như tổ lót trên vầng đá. ");
INSERT INTO vieovcb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Thế mà Kê-nít sẽ phải điêu tàn; người A-sy-ri sẽ bắt ngươi đem lưu đày.” ");
INSERT INTO vieovcb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Để kết thúc, ông nói những lời này: “Than ôi! Khi Đức Chúa Trời ra tay, còn ai sống nổi? ");
INSERT INTO vieovcb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Chiến thuyền sẽ đến từ đảo Síp, làm cho A-sy-ri và Hê-be khốn khổ, rồi họ cũng bị tiêu diệt.” ");
INSERT INTO vieovcb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Nói xong, Ba-la-am lên đường trở về quê mình. Ba-lác cũng về cung. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Khi người Ít-ra-ên đồn trú tại Si-tim, một số người thông dâm với các phụ nữ Mô-áp. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Các phụ nữ mời họ đi dự những buổi tế thần, rồi ăn của cúng và quỳ lạy các thần đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Dần dần người Ít-ra-ên kéo nhau thờ lạy Ba-anh Phê-ô. Vì vậy Chúa Hằng Hữu nổi giận, ");
INSERT INTO vieovcb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","phán với Môi-se: “Bắt các trưởng tộc đem treo lên ngoài nắng trước mặt Chúa Hằng Hữu, để Ngài hết giận Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Môi-se ra lệnh cho các phán quan hành quyết tất cả những ai thờ lạy Ba-anh Phê-ô. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Có một người Ít-ra-ên ngang nhiên dẫn một phụ nữ Ma-đi-an về với gia đình mình, đi ngang qua trước mặt Môi-se và toàn thể cộng đồng Ít-ra-ên, trong khi họ đang khóc than tại cửa Đền Tạm. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Phi-nê-a, con Ê-lê-a-sa, cháu A-rôn, là thầy tế lễ thấy thế, liền đứng lên ra khỏi cộng đồng, lấy một cây giáo, ");
INSERT INTO vieovcb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","chạy theo người kia vào trong trại, đâm xuyên qua thân người ấy, thấu bụng người phụ nữ. Tai họa liền chấm dứt. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Tuy nhiên đã có đến 24.000 người chết vì tai họa này. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phi-nê-a, con Ê-lê-a-sa, cháu A-rôn, là thầy tế lễ, đã làm cho Ta nguôi giận, người đã nhiệt tâm đố kỵ tà thần, nên Ta không tuyệt diệt người Ít-ra-ên dù họ bất trung. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Vậy, vì Phi-nê-a đã nhiệt thành với Đức Chúa Trời, và chuộc tội cho dân, nên Ta kết ước hòa bình với người. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Chức vị tế lễ sẽ thuộc về người và con cháu người mãi mãi vì người có lòng sốt sắng về Đức Chúa Trời mình và đã chuộc tội cho dân Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Tên của người đàn ông bị giết chung với phụ nữ Ma-đi-an ấy là Xim-ri, con của Sa-lu, trưởng một tông tộc người Si-mê-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Và tên phụ nữ Ma-đi-an là Cốt-bi, con của Xu-rơ, một lãnh tụ người Ma-đi-an. ");
INSERT INTO vieovcb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Hãy coi người Ma-đi-an là kẻ thù và đánh giết họ, ");
INSERT INTO vieovcb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","vì họ đã coi các ngươi là thù nghịch khi dùng mưu kế dụ dỗ các ngươi thờ Phê-ô. Cốt-bi là con gái một nhà lãnh đạo Ma-đi-an, người phụ nữ bị giết trong ngày tai họa, và tại họa này xảy ra vì việc cúng thờ Phê-ô.” ");
INSERT INTO vieovcb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Sau tai họa này, Chúa Hằng Hữu phán bảo Môi-se và Ê-lê-a-sa, con Thầy Tế lễ A-rôn, như sau: ");
INSERT INTO vieovcb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Hãy kiểm kê tất cả người Ít-ra-ên từ hai mươi tuổi trở lên, những người có thể ra trận, theo thứ tự từng họ hàng, gia tộc.” ");
INSERT INTO vieovcb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Vậy tại đồng bằng Mô-áp, bên Sông Giô-đan, đối diện Giê-ri-cô, Môi-se, và Thầy Tế lễ Ê-lê-a-sa truyền lại lệnh ấy cho dân: ");
INSERT INTO vieovcb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Kiểm kê những người từ hai mươi tuổi trở lên, như Chúa Hằng Hữu đã phán dặn Môi-se.” Đây là những người Ít-ra-ên đã ra khỏi xứ Ai Cập: ");
INSERT INTO vieovcb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Con cháu Ru-bên là con trưởng nam của Ít-ra-ên. Từ Hê-nóc sinh ra gia tộc Hê-nóc. Từ Pha-lu sinh ra gia tộc Pha-lu. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Từ Hết-rôn sinh ra gia tộc Hết-rôn. Từ Cạt-mi sinh ra gia tộc Cát-mi. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Đại tộc Ru-bên có 43.730 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Con trai Pha-lu là Ê-li-áp, ");
INSERT INTO vieovcb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","các con trai của Ê-li-áp là Nê-mu-ên, Đa-than, và A-bi-ram. Chính Đa-than và A-bi-ram này đã cùng với Cô-ra lãnh đạo cuộc chống đối Môi-se, A-rôn, và nghịch với Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Vì thế, đất đã nứt ra nuốt họ cùng với Cô-ra. Đồng thời, có 250 người bị lửa thiêu chết, để cảnh cáo toàn dân Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Tuy nhiên, các con của Cô-ra không chết trong ngày ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Con cháu Si-mê-ôn tính từng gia tộc: Từ Nê-mu-ên sinh ra gia tộc Nê-mu-ên. Từ Gia-min sinh ra gia tộc Gia-min. Từ Gia-kin sinh ra gia tộc Gia-kin. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Từ Xê-rách sinh ra gia tộc Xê-rách. Từ Sau-lơ sinh ra gia tộc Sau-lơ. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Đó là các gia tộc của đại tộc Si-mê-ôn, có 22.200 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Con cháu Gát tính từng gia tộc: Từ Xê-phôn sinh ra gia tộc Xê-phôn. Từ Ha-ghi sinh ra gia tộc Ha-ghi. Từ Su-ni sinh ra gia tộc Su-ni. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Từ Óc-ni sinh ra gia tộc Óc-ni. Từ Ê-ri sinh ra gia tộc Ê-ri. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Từ A-rốt sinh ra gia tộc A-rốt. Từ A-rê-li sinh ra gia tộc A-rê-li. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Đó là các gia tộc của đại tộc Gát, có 40.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Có hai con trai của Giu-đa là Ê-rơ và Ô-nan đã qua đời tại Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Con cháu Giu-đa tính từng gia tộc: Từ Sê-la sinh ra gia tộc Sê-la. Từ Phê-rết sinh ra gia tộc Phê-rết. Từ Xê-rách sinh ra gia tộc Xê-rách. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Con cháu của Phê-rết gồm có: Từ Hết-rôn sinh ra gia tộc Hết-rôn. Từ Ha-num sinh ra gia tộc Ha-mun. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Đó là các gia tộc của đại tộc Giu-đa, có 76.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Con cháu Y-sa-ca tính từng gia tộc: Từ Thô-la sinh ra gia tộc Thô-la. Từ Phu-va sinh ra gia tộc Phu-ra. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Từ Gia súp sinh ra gia tộc Gia-súp. Từ Sim-rôn sinh ra gia tộc Sim-rôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Đó là các gia tộc của đại tộc Y-sa-ca, có 64.300 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Con cháu Sa-bu-luân tính từng gia tộc: Từ Sê-rết sinh ra gia tộc Se-rết. Từ Ê-lôn sinh ra gia tộc Ê-lôn. Từ Gia-lê-ên sinh ra gia tộc Gia-lê-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Đó là các gia tộc của đại tộc Sa-bu-luân có 60.500 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Riêng trường hợp Giô-sép, con cháu ông họp thành hai gia tộc mang tên hai con trai ông là Ma-na-se và Ép-ra-im. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Con cháu Ma-na-se: Từ Ma-ki sinh ra gia tộc Ma-ki. Từ Ga-la-át (con Ma-ki) sinh ra gia tộc Ga-la-át. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Con cháu của Ga-la-át là: Từ Giê-xe sinh ra gia tộc Giê-xe. Từ Hê-léc sinh ra gia tộc Hê-léc. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Từ Ách-ri-ên sinh ra gia tộc Ách-ri-ên. Từ Si-chem sinh ra gia tộc Si-chem. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Từ Sê-mi-đa sinh ra gia tộc Sê-mi-đa. Từ Hê-phe sinh ra gia tộc Hê-phe. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Xê-lô-phát, con trai Hê-phe, sinh toàn con gái là Mách-la, Nô-a, Hốt-la, Minh-ca, và Thiệt-sa, chứ không có con trai. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Đó là các gia tộc của đại tộc Ma-na-se có 52.700 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Con cháu Ép-ra-im: Từ Su-tê-la sinh ra gia tộc Su-thê-lách. Từ Bê-ka sinh ra gia tộc Bê-ka. Từ Tha-chan sinh ra gia tộc Tha-han. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Con của Su-tê-la là Ê-ran. Từ Ê-ran sinh ra gia tộc Ê-ran. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Tất cả thuộc gia tộc của đại tộc Ép-ra-im có 32.500 người. Đó là đại tộc Ma-na-se vá Ép-ra-im, con cháu của Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Con cháu Bên-gia-min tính từng đại tộc: Từ Bê-la sinh ra gia tộc Bê-la. Từ Ách-bên sinh ra gia tộc Ách-bên. Từ A-chi-ram sinh ra gia tộc A-chi-ram. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Từ Sê-phu-pham sinh ra gia tộc Sê-phu-pham. Từ Hu-pham sinh ra gia tộc Hu-pham. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Các con của Bê-la là A-rết và Na-a-man: Từ A-rết sinh ra gia tộc A-rết. Từ Na-a-man sinh ra gia tộc Na-a-man. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Đó là các gia tộc của đại tộc Bên-gia-min có 45.600 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Con cháu Đan tính từng gia tộc: Từ Su-cham sinh ra gia tộc Su-cham. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Đại tộc Đan chỉ có một gia tộc Su-cham có 64.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Con cháu A-se tính từng gia tộc: Từ Im-na sinh ra gia tộc Im-na. Từ Ích-vi sinh ra gia tộc Ích-vi. Từ Bê-ri-a sinh ra gia tộc Bê-ri-a. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Con trai Bê-ri-a là Hê-be và Manh-ki-ên: Từ Hê-be sinh ra gia tộc Hê-be. Từ Manh-ki-ên sinh ra gia tộc Manh-ki-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","A-se có một con gái tên là Sê-ra. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Đó là các gia tộc của đại tộc A-se có 53.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Con cháu Nép-ta-li tính từng gia tộc: Từ Gia-xên sinh ra gia tộc Giát-sê-ên. Từ Gu-ni sinh ra gia tộc Gu-ni. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Từ Giê-xe sinh ra gia tộc Giê-xe. Từ Si-lem sinh ra gia tộc Si-lem. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Đó là các gia tộc của đại tộc Nép-ta-li có 45.400 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Vậy tổng số những người được kiểm kê trong toàn dân Ít-ra-ên là 601.730 người. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Chia đất cho các đại tộc căn cứ trên dân số. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Đại tộc đông dân sẽ được nhiều đất hơn đại tộc ít dân. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Hãy dùng lối bắt thăm định phần, trên mỗi thăm viết tên một đại tộc. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Nhưng các đại tộc đông dân sẽ bắt thăm chia nhau những phần đất lớn, các đại tộc ít dân bắt thăm những phần đất nhỏ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Người Lê-vi được kiểm kê theo thứ tự các gia tộc: Từ Ghẹt-sôn sinh ra gia tộc Ghẹt-sôn. Từ Kê-hát sinh ra gia tộc Kê-rát. Từ Mê-ra-ri sinh ra gia tộc Mê-ra-ri. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Các tộc khác thuộc đại tộc Lê-vi là: Líp-ni, Hếp-rôn, Mách-li, Mu-si, và Cô-rê. Kê-hát sinh Am-ram, ");
INSERT INTO vieovcb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","và vợ của Am-ram là Giô-kê-bết. Khi Lê-vi còn ở Ai Cập, ông sinh Giô-kê-bết. Am-ram cưới Giô-kê-bết sinh A-rôn, Môi-se, và một con gái tên Mi-ri-am. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","A-rôn sinh Na-đáp, A-bi-hu, Ê-lê-a-sa, và Y-tha-ma. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Na-đáp và A-bi-hu chết khi dâng lửa lạ trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Tổng số người Lê-vi là 23.000, gồm nam nhi từ một tháng trở lên. Họ không được kiểm kê chung với những đại tộc Ít-ra-ên khác vì không có phần trong cuộc chia đất ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Đấy là kết quả cuộc kiểm kê do Môi-se và Thầy Tế lễ Ê-lê-a-sa phụ trách, thực hiện trong đồng bằng Mô-áp, bên Sông Giô-đan, tại một nơi đối diện Giê-ri-cô. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Không một ai trong số người được kiểm kê kỳ này có tên trong cuộc kiểm kê trước được thực hiện tại hoang mạc Si-nai do Môi-se và A-rôn phụ trách. ");
INSERT INTO vieovcb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Những người xưa đều chết cả, đúng như lời Chúa Hằng Hữu: “Họ sẽ chết trong hoang mạc.” Ngoại trừ Ca-lép, con của Giê-phu-nê, và Giô-suê, con của Nun. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Xê-lô-phát có năm người con gái là: Mách-la, Nô-a, Hốt-la, Minh-ca, và Thiệt-sa. Cha họ là Xê-lô-phát con của Hê-phe, cháu Ga-la-át, chắt Ma-ki, chít Ma-na-se. Ma-na-se là con Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Một hôm, các con gái của Xê-lô-phát đến gặp Môi-se, Thầy Tế lễ Ê-lê-a-sa, các nhà lãnh tụ, và toàn thể dân chúng hiện diện tại cửa Đền Tạm. Họ nói: ");
INSERT INTO vieovcb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Cha chúng tôi đã qua đời trong hoang mạc, nhưng không phải vì phản nghịch Chúa Hằng Hữu. Người không chết như Cô-ra và đồng bọn, nhưng qua đời tự nhiên, và không có con trai. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Chỉ vì không sinh con trai, cha chúng tôi phải bị xóa tên khỏi gia tộc mình hay sao? Không, xin cho chúng tôi đại diện cha lãnh phần đất cùng với các vị chú bác của chúng tôi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Môi-se trình việc này lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Chúa Hằng Hữu phán dạy ông: ");
INSERT INTO vieovcb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Các con gái Xê-lô-phát nói đúng. Hãy cho họ một phần đất cùng với chú bác họ, là phần đáng lẽ cha họ được hưởng. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Nhân việc này, con cũng công bố cho dân chúng biết luật này. Nếu ai chết không có con trai, con gái sẽ lãnh phần tài sản. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Nếu người ấy cũng không có con gái, tài sản sẽ thuộc về anh em ruột. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Nếu không có anh em ruột, tài sản về tay chú bác. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Nếu không có chú bác, tài sản thuộc về người trong gia tộc gần nhất còn lại. Đây là điều Chúa Hằng Hữu phán bảo Môi-se.” ");
INSERT INTO vieovcb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Sau đó, Chúa Hằng Hữu phán bảo Môi-se: “Con lên núi A-ba-rim ngắm xem đất Ta cho người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Xem xong, con sẽ qua đời như A-rôn vậy, ");
INSERT INTO vieovcb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","vì con đã chống lại lệnh Ta trong hoang mạc Xin, khi dân chúng nổi loạn. Con đã không tôn trọng Ta trước mặt họ.” (Đây là vụ “nước Mê-ri-ba” ở Ca-đe, trong hoang mạc Xin.) ");
INSERT INTO vieovcb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Môi-se thưa lên Chúa Hằng Hữu: ");
INSERT INTO vieovcb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Lạy Chúa Hằng Hữu, là Chúa của linh hồn mọi người, xin chỉ định một người thay con lãnh đạo dân chúng, ");
INSERT INTO vieovcb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","đối ngoại cũng như đối nội, để dân của Chúa Hằng Hữu không phải như chiên không người chăn.” ");
INSERT INTO vieovcb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Chúa Hằng Hữu đáp: “Giô-suê, con của Nun là người có Thần ở cùng. Trước hết, con đem người đến, đặt tay trên người. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Sau đó, dẫn người đến đứng trước mặt Thầy Tế lễ Ê-lê-a-sa với sự chứng kiến của toàn dân, rồi con sẽ ủy thác trách nhiệm cho người. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Con sẽ trao quyền cho người, và như vậy toàn dân Ít-ra-ên sẽ tuân lệnh người. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Giô-suê sẽ tham khảo với Thầy Tế lễ Ê-lê-a-sa để biết các quyết định của Chúa Hằng Hữu (nhờ bảng U-rim). Người và toàn dân sẽ tuân theo chỉ thị của Chúa Hằng Hữu trong mọi việc.” ");
INSERT INTO vieovcb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Vâng lệnh Chúa Hằng Hữu, Môi-se đem Giô-suê đến đứng trước mặt Thầy Tế lễ Ê-lê-a-sa và toàn dân. ");
INSERT INTO vieovcb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Môi-se đặt tay trên Giô-suê, ủy thác trách nhiệm như lời Chúa Hằng Hữu phán dạy ông. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Chúa Hằng Hữu phán bảo Môi-se ");
INSERT INTO vieovcb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","truyền cho dân chúng chỉ thị sau: “Các lễ vật—các thức ăn đem đốt để dâng hương thơm lên cho Ta—phải được dâng vào các thời điểm ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Lễ thiêu dâng hằng ngày: Gồm hai chiên đực một tuổi, không tì vít, dùng lửa dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Dâng một con vào buổi sáng, một con vào buổi tối. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Đồng thời cũng dâng 2,2 lít bột lễ vật ngũ cốc trộn với 1 lít dầu ép ô-liu. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Lễ thiêu dâng hằng ngày này là tế lễ dùng lửa dâng hương thơm lên Chúa Hằng Hữu, như đã được quy định tại Núi Si-nai. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ngoài ra, phải dâng chung với mỗi con chiên 1 lít rượu mạnh (lễ quán), lấy rượu đổ ra trong Nơi Thánh trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Con chiên dâng vào buổi tối cũng được dâng chung với lễ ngũ cốc và lễ quán như con chiên buổi sáng vậy, và đây cũng là lễ vật dùng lửa dâng hương thơm lên Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Lễ thiêu dâng ngày Sa-bát gồm hai chiên đực một tuổi, không tì vít, và 4,4 lít bột mịn trộn với dầu (lễ vật ngũ cốc) cùng với rượu (lễ quán). ");
INSERT INTO vieovcb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Lễ thiêu này dâng vào mỗi ngày Sa-bát, cộng thêm với lễ thiêu hằng ngày và lễ quán.” ");
INSERT INTO vieovcb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Lễ thiêu dâng lên Chúa Hằng Hữu đầu tháng gồm hai bò tơ đực, một chiên đực, và bảy chiên con đực một tuổi, không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Cũng dâng lễ vật ngũ cốc gồm bột mịn trộn dầu: 6,6 lít bột mịn trộn dầu chung với mỗi con bò, 4,4 lít bột mịn trộn dầu chung với chiên đực, ");
INSERT INTO vieovcb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","và 2,2 lít bột mịn trộn dầu chung với mỗi chiên con. Đó là các sinh tế thiêu, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Cùng với mỗi con bò, dâng 2 lít rượu (lễ quán), cùng với chiên đực, dâng 1,3 lít rượu; và 1 lít cùng với mỗi chiên con. Đó là lễ thiêu dâng hằng tháng trong năm. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Cùng với lễ thiêu, cũng dâng lên Chúa Hằng Hữu một con dê đực làm lễ chuộc tội, cộng thêm với lễ thiêu dâng hằng ngày và lễ quán.” ");
INSERT INTO vieovcb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Lễ Vượt Qua của Chúa Hằng Hữu vào ngày mười bốn tháng giêng. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Kể từ ngày mười lăm, người ta sẽ dự lễ bánh không men trong suốt bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Vào ngày lễ thứ nhất, sẽ có một cuộc hội họp thánh. Toàn dân được mời đến dự, nên không ai làm việc nặng nhọc, ");
INSERT INTO vieovcb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","nhưng sẽ dâng lễ thiêu cho Chúa Hằng Hữu. Sinh tế gồm có: Hai bò đực, một chiên đực và bảy chiên con đực một tuổi, không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Cũng dâng lễ vật ngũ cốc gồm bột mịn trộn dầu: 6,6 lít bột mịn trộn dầu chung với mỗi con bò, 4,4 lít bột mịn trộn dầu chung với mỗi chiên đực, ");
INSERT INTO vieovcb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","và 2,2 lít bột mịn trộn dầu chung với mỗi chiên con. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ngoài ra, cũng dâng một dê đực làm lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Các lễ vật này, (ngoài lễ thiêu dâng hằng ngày và lễ quán) dâng thường xuyên vào mỗi buổi sáng. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Trong bảy ngày, mỗi ngày đều phải dâng tế lễ thiêu như thế. Đó là những thức ăn đốt lên để dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Đến ngày thứ bảy cũng có một cuộc hội họp thánh, toàn dân được mời dự, nên không ai được làm các công việc thường ngày trong ngày ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Vào ngày Hoa Quả Đầu Mùa (Lễ Các Tuần), phải dâng ngũ cốc lên Chúa Hằng Hữu, gồm các hoa quả mới gặt hái được. Mọi người sẽ dự cuộc hội họp thánh, và không ai làm việc nặng nhọc. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Lễ thiêu dâng vào dịp này gồm hai bò tơ đực, một chiên đực, bảy chiên con đực một tuổi, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Cũng dâng lễ vật ngũ cốc gồm bột mịn trộn dầu: 6,6 lít bộn mịn trộn dầu chung với mỗi con bò, 4,4 lít bột mịn trộn dầu chung với mỗi chiên đực, ");
INSERT INTO vieovcb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","và 2,2 lít bột mịn trộn dầu chung với mỗi chiên con. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ngoài ra, cũng dâng một dê đực làm lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Các lễ vật này được dâng cùng với các lễ thiêu, ngũ cốc, và rượu dâng hằng ngày. Sinh tế phải là những con vật không tì vít.” ");
INSERT INTO vieovcb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Lễ thổi kèn được giữ vào ngày mồng một tháng bảy. Toàn dân sẽ dự cuộc hội họp thánh, và trong ngày lễ không ai làm việc nặng nhọc. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Lễ thiêu dâng vào dịp này gồm một bò đực, một chiên đực, bảy chiên con đực một tuổi không tì vít, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Cũng dâng lễ vật ngũ cốc gồm bột mịn trộn dầu: 6,6 lít bột mịn trộn dầu chung với con bò, 4,4 lít bột mịn trộn dầu chung với chiên đực, ");
INSERT INTO vieovcb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","và 2,2 lít bột mịn trộn dầu chung với mỗi chiên con. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ngoài ra cũng dâng con dê đực làm lễ chuộc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Các lễ vật này được dâng cùng với lễ thiêu, ngũ cốc và rượu dâng hằng ngày như đã quy định. Đó là những lễ vật dùng lửa dâng hương thơm lên Chúa Hằng Hữu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Vào ngày mồng mười tháng bảy, lại sẽ có một cuộc họp thánh. Mọi người phải hạ mình hối lỗi và không làm việc gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Lễ thiêu dâng hôm ấy gồm bò tơ đực, chiên đực, và bảy chiên con đực một tuổi không tì vít, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Cũng dâng lễ vật ngũ cốc gồm bột mịn trộn dầu: 6,6 lít bột mịn trộn dầu chung với con bò, 4,4 lít bột mịn trộn dầu chung với chiên đực, ");
INSERT INTO vieovcb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","và 2,2 lít bột mịn trộn dầu chung với mỗi chiên con. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ngoài ra, cũng dâng một con dê đực làm lễ chuộc tội. Lễ vật này được dâng cùng với lễ chuộc tội dâng trong ngày chuộc tội, lễ thiêu dâng hằng ngày, ngũ cốc, và rượu.” ");
INSERT INTO vieovcb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Vào ngày rằm tháng bảy sẽ có cuộc hội họp thánh; không ai làm việc nặng nhọc, và toàn dân sẽ giữ lễ bảy ngày cho Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Lễ thiêu dâng vào ngày thứ nhất gồm mười ba bò tơ đực, hai chiên đực, và mười bốn chiên đực một tuổi không tì vít, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Cũng dâng lễ vật ngũ cốc gồm bột mịn trộn dầu: 6,6 lít bột mịn trộn dầu chung với mỗi bò tơ đực, 4,4 lít bột mịn trộn dầu chung với mỗi chiên đực, ");
INSERT INTO vieovcb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","và 2,2 lít bột mịn trộn dầu chung với mỗi chiên con. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ngoài ra, cũng dâng một con dê đực làm lễ chuộc tội cùng với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Vào ngày thứ hai, phải dâng lễ thiêu gồm mười hai bò tơ đực, hai chiên đực, và mười bốn chiên con đực một tuổi không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Cũng dâng lễ vật ngũ cốc và rượu chung với bò, chiên đực, và chiên con theo số lượng ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Ngoài ra, dâng một con dê đực làm lễ chuộc tội, cùng với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Vào ngày thứ ba, dâng lễ thiêu gồm mười một bò tơ đực, hai chiên đực, và mười bốn chiên con một tuổi không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Cũng dâng lễ vật ngũ cốc và rượu chung với các sinh vật trên, theo số lượng ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Ngoài ra, cũng dâng một con dê đực làm lễ chuộc tội, cộng thêm với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Vào ngày thứ tư, dâng lễ thiêu gồm mười bò đực tơ, hai chiên đực và mười bốn chiên con đực một tuổi không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Cũng dâng lễ vật ngũ cốc và rượu chung với các sinh vật trên theo số lượng ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Ngoài ra, cũng dâng một con dê đực làm lễ chuộc tội, cộng thêm với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Vào ngày thứ năm, dâng lễ thiêu gồm chín bò tơ đực, hai chiên đực, và mười bốn chiên con đực một tuổi không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Cũng dâng lễ vật ngũ cốc và rượu chung với các sinh vật trên, theo số lượng ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Ngoài ra, cũng dâng một con dê đực làm lễ chuộc tội, cộng thêm với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Vào ngày thứ sáu, dâng lễ thiêu gồm tám bò tơ đực, hai chiên đực, và mười bốn chiên con đực một tuổi không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Cũng dâng lễ vật ngũ cốc và rượu chung với các sinh vật theo số ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Ngoài ra, cũng dâng một con dê đực làm lễ chuộc tội cùng với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Vào ngày thứ bảy, dâng lễ thiêu gồm bảy bò tơ đực, hai chiên đực, và mười bốn chiên con đực một tuổi không tì vít. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Cũng dâng lễ vật ngũ cốc và rượu chung với các sinh vật trên, theo số lượng ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Ngoài ra, cũng dâng một con dê đực làm lễ chuộc tội cùng với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Vào ngày thứ tám sẽ có cuộc hội họp thánh, sẽ không ai được làm những việc thường ngày vào ngày này. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Lễ thiêu dâng hôm ấy gồm một bò tơ đực, một dê đực, và bảy chiên con đực một tuổi không tì vít, dùng lửa dâng hương thơm lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Cũng dâng lễ vật ngũ cốc và rượu chung với các sinh vật trên, theo số lượng ấn định. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Ngoài ra cũng dâng một con dê đực làm lễ chuộc tội cùng với lễ thiêu dâng hằng ngày, ngũ cốc, và rượu. ");
INSERT INTO vieovcb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Đó là các lễ vật dâng lên Chúa Hằng Hữu gồm sinh tế thiêu, lễ vật ngũ cốc, rượu, hay lễ vật thù ân trong các kỳ lễ hằng năm, ngoài các lễ vật thề nguyện, và lễ vật tình nguyện.” ");
INSERT INTO vieovcb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Môi-se truyền lại cho dân chúng mọi điều Chúa Hằng Hữu phán bảo mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Môi-se nói với các vị lãnh đạo của các đại tộc Ít-ra-ên: “Chúa Hằng Hữu có truyền dạy: ");
INSERT INTO vieovcb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Nếu ai hứa nguyện với Chúa Hằng Hữu một điều gì, hoặc thề sẽ tuân giữ một lời nguyền, thì người ấy phải làm theo lời mình đã thề hoặc hứa. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Nếu một người phụ nữ còn sống trong nhà cha mình, có hứa với Chúa Hằng Hữu hoặc có thề làm một điều gì, ");
INSERT INTO vieovcb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","và khi người cha biết được lời thề của con mình nhưng không nói gì cả, thì lời thề vẫn có hiệu lực. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Nhưng nếu vừa biết được lời thề, người cha liền cấm đoán con gái mình ngay trong ngày hôm ấy, thì lời thề của nàng trở nên vô hiệu. Chúa Hằng Hữu sẽ tha thứ cho nàng vì nàng bị cha mình cấm đoán. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Nếu một người phụ nữ đã thề hoặc đã buột miệng hứa điều gì, rồi về sau có chồng, ");
INSERT INTO vieovcb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","mà người chồng biết được lời thề của vợ mình nhưng không nói gì, thì lời thề vẫn có hiệu lực. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Nhưng nếu vừa biết được lời thề, người chồng liền cấm đoán vợ mình ngay trong ngày hôm ấy, thì lời thề của nàng trở nên vô hiệu. Chúa Hằng Hữu sẽ tha thứ cho nàng. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Nhưng lời thề của một bà góa hay một bà ly dị vẫn luôn có hiệu lực. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Giả sử một người phụ nữ phát thề khi đang sống trong nhà chồng. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Khi người chồng biết được lời thề của vợ mình nhưng không nói năng, phản đối gì, thì lời thề vẫn có hiệu lực. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Nhưng nếu người chồng hủy bỏ lời thề ngay trong ngày mình biết được, thì lời thề của người vợ trở thành vô hiệu, và Chúa Hằng Hữu sẽ tha thứ cho nàng. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Vậy, người chồng có quyền chấp thuận hay hủy bỏ lời thề của vợ mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Nếu người chồng giữ im lặng trong một ngày tròn, tức là bằng lòng chấp thuận lời thề của vợ. ");
INSERT INTO vieovcb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Còn nếu người chồng đợi một thời gian rồi mới tuyên bố hủy bỏ lời thề, thì người ấy phải gánh chịu hình phạt theo như lời vợ mình đã thề.” ");
INSERT INTO vieovcb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Trên đây là những quy tắc Chúa Hằng Hữu truyền cho Môi-se, để áp dụng trong những mối liên hệ vợ chồng hoặc cha và con gái khi còn ở trong nhà cha. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Trước ngày con qua đời, con sẽ báo thù người Ma-đi-an cho người Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Môi-se nói với dân chúng: “Một số người phải được trang bị khí giới để đi báo thù người Ma-đi-an, theo lệnh Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mỗi đại tộc tuyển 1.000 người.” ");
INSERT INTO vieovcb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Và như vậy, từ trong các đại tộc Ít-ra-ên chọn 12.000 người tham dự trận này. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Môi-se ra lệnh tiến công, có Phi-nê-a, con Thầy Tế lễ Ê-lê-a-sa đem theo các dụng cụ thánh và kèn đồng cầm nơi tay. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Trong trận này, họ giết sạch những người đàn ông Ma-đi-an, như Chúa Hằng Hữu phán cùng Môi-se ");
INSERT INTO vieovcb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","kể cả năm vua Ma-đi-an là: Ê-vi, Rê-kem, Xu-rơ, Hu-rơ, và Rê-ba. Ba-la-am, con trai Bê-ô cũng chung số phận. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Đạo quân Ít-ra-ên bắt đàn bà, trẻ con Ma-đi-an, thu chiến lợi phẩm gồm bò, chiên, và của cải. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Họ đốt các thành và trang trại của người Ma-đi-an. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Họ lấy các chiến lợi phẩm, người, và súc vật, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","đem tất cả người và của cải chiếm được đến trước Môi-se, Thầy Tế lễ Ê-lê-a-sa và cộng đồng dân chúng Ít-ra-ên đang cắm trại tại đồng bằng Mô-áp, bên Sông Giô-đan, đối diện Giê-ri-cô. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Môi-se, Thầy Tế lễ Ê-lê-a-sa, và các nhà lãnh đạo cộng đồng Ít-ra-ên ra tận bên ngoài trại tiếp đón đoàn quân chiến thắng trở về. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Nhưng Môi-se giận các cấp chỉ huy quân đội lắm (họ gồm những quan chỉ huy hàng nghìn và hàng trăm quân). ");
INSERT INTO vieovcb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ông hỏi: “Tại sao các anh để cho tất cả phụ nữ Ma-đi-an sống? ");
INSERT INTO vieovcb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Chính họ là những người đã vâng lời Ba-la-am, quyến rũ người Ít-ra-ên cúng thờ Phê-ô, phạm tội trọng với Chúa Hằng Hữu, vì thế mà tai họa đã xảy ra cho dân của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Thế thì, ta phải giết hết những con trai và tất cả phụ nữ đã nằm với đàn ông, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","nhưng để cho các trinh nữ sống, và dân chúng được giữ những trinh nữ này. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Bây giờ, ai đã giết người hoặc đụng vào xác chết phải ở lại bên ngoài trại trong bảy ngày. Vào ngày thứ ba và ngày thứ bảy, phải tẩy sạch mình và người mình bắt được. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Cũng tẩy sạch áo xống, đồ dùng bằng da, bằng lông dê, và bằng gỗ.” ");
INSERT INTO vieovcb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Thầy Tế lễ Ê-lê-a-sa cũng nhắc nhở các chiến sĩ: “Đây là quy tắc Chúa Hằng Hữu truyền cho Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Vật gì có thể đưa vào lửa được như vật bằng vàng, bạc, đồng, sắt, thiếc, hoặc chì, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","thì phải đưa vào lửa đốt cho sạch. Sau đó, cũng phải dùng nước tẩy uế mà tẩy sạch nữa. Còn vật gì không chịu được lửa, thì dùng nước tẩy uế mà thôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Phải giặt sạch áo vào ngày thứ bảy và như thế anh em sẽ được sạch. Sau đó, anh em có thể vào trại.” ");
INSERT INTO vieovcb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Con sẽ cùng với Thầy Tế lễ Ê-lê-a-sa và các tộc trưởng lo kiểm kê các chiến lợi phẩm, cả người lẫn súc vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Xong, chia chiến lợi phẩm ra làm hai phần, một phần thuộc về các chiến sĩ đã ra trận, phần kia thuộc về dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Trong phần của các chiến sĩ, phải đem một phần năm trăm để dâng lên Chúa Hằng Hữu, gồm người, bò, lừa, và chiên. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Phần trích ra này sẽ đem giao cho Thầy Tế lễ Ê-lê-a-sa để dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Cũng lấy một phần năm mươi trong phân nửa của dân chúng để cho người Lê-vi, là những người có trách nhiệm phục vụ Đền Tạm của Chúa Hằng Hữu. Phần này cũng gồm có người, bò, lừa, và chiên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Môi-se và Thầy Tế lễ Ê-lê-a-sa làm theo lời Chúa Hằng Hữu phán dạy. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Chiến lợi phẩm do các chiến sĩ thu được (không kể đến một số của cải khác) gồm có: 675.000 con chiên và dê, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72.000 con bò, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61.000 con lừa, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","và 32.000 trinh nữ. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Như thế, phân nửa thuộc phần các chiến sĩ gồm có: 337.500 con chiên và dê, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","trong đó trích ra nộp cho Chúa Hằng Hữu là 675 con; ");
INSERT INTO vieovcb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36.000 con bò, trong đó trích ra nộp cho Chúa Hằng Hữu là 72 con; ");
INSERT INTO vieovcb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30.500 con lừa, trong đó trích ra nộp cho Chúa Hằng Hữu là 61 con; ");
INSERT INTO vieovcb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16.000 trinh nữ, trong đó trích ra nộp cho Chúa Hằng Hữu là 32 người ");
INSERT INTO vieovcb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Môi-se vâng lời Chúa Hằng Hữu, đem nộp cho Thầy Tế lễ Ê-lê-a-sa phần thuộc về Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Phân nửa chiến lợi phẩm thuộc về người Ít-ra-ên được Môi-se chi cho (phân nửa kia thuộc các chiến sĩ, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","phân nửa này chia cho dân chúng), gồm có: 337.000 con chiên và dê, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36.000 con bò, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30.500 con lừa, ");
INSERT INTO vieovcb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","và 16.000 trinh nữ. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Môi-se lấy hai phần trăm của phân nửa này, gồm cả người lẫn thú vật, đem cho người Lê-vi như Chúa Hằng Hữu phán bảo ông. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Các quan chỉ huy hàng nghìn và hàng trăm quân đến thưa với Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“Chúng tôi đã kiểm điểm quân số và thấy là không một ai thiệt mạng cả. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ngoài ra, chúng tôi mang đến đây các vật đã thu được: Nữ trang bằng vàng, vòng đeo tay, vòng đeo chân, nhẫn, hoa tai, và dây chuyền. Xin dâng lên Chúa Hằng Hữu làm lễ chuộc tội.” ");
INSERT INTO vieovcb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Môi-se và Thầy Tế lễ Ê-lê-a-sa nhận các lễ vật từ tay các chỉ huy. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Tổng số vàng dâng lên Chúa Hằng Hữu cân nặng 190 kg. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Các chiến sĩ đều có thu hoạch chiến lợi phẩm riêng cho mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Môi-se và Thầy Tế lễ Ê-lê-a-sa đem các lễ vật này cất vào Đền Tạm để làm một kỷ niệm của dân chúng Ít-ra-ên trước mặt Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Vì người thuộc đại tộc Ru-bên và Gát có rất nhiều súc vật, nên khi thấy đất Gia-ê-xe và Ga-la-át là một vùng thích hợp cho việc chăn nuôi, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","họ đến gặp Môi-se, Thầy Tế lễ Ê-lê-a-sa, và các nhà lãnh đạo dân chúng. Họ trình bày như sau: ");
INSERT INTO vieovcb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Chúa Hằng Hữu đã đánh bại dân của các địa phương A-ta-rốt, Đi-bôn, Gia-ê-xe, Nim-ra, Hết-bôn, Ê-lê-a-lê, Sê-ham, Nê-bô, và Bê-ôn trước mặt người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Chúa Hằng Hữu đã đánh bại các dân này cho người Ít-ra-ên. Các miền này thật là nơi lý tưởng cho bầy gia súc của chúng tôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Nếu quý ông vui lòng, xin cho chúng tôi chiếm hữu đất này, không cần phải đi qua Sông Giô-đan.” ");
INSERT INTO vieovcb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Nhưng Môi-se hỏi những người thuộc đại tộc Gát và Ru-bên: “Anh em muốn ngồi nghỉ đây trong khi anh em mình phải tiếp tục chiến đấu sao? ");
INSERT INTO vieovcb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Tại sao anh em làm cho người Ít-ra-ên nản lòng, không muốn đi vào đất Chúa Hằng Hữu đã hứa cho? ");
INSERT INTO vieovcb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Cha ông của anh em cũng đã làm y như vậy tại Ca-đê Ba-nê-a khi tôi sai họ đi thám thính Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Sau khi nhìn thấy đất ở thung lũng Ếch-côn, họ làm cho dân chúng ngã lòng, không muốn đi vào nơi Chúa Hằng Hữu hứa cho họ nữa. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Lúc ấy Chúa Hằng Hữu nổi giận, thề rằng: ");
INSERT INTO vieovcb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Không cho một người nào trong những người ra đi từ Ai Cập, từ hai mươi tuổi trở lên, được hưởng đất Ngài đã hứa cho Áp-ra-ham, Y-sác, và Gia-cốp, vì họ không hết lòng theo Ngài, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","chỉ trừ Ca-lép, con Giê-phu-nê, người Kên, và Giô-suê, con của Nun, là hai người hết lòng theo Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Và như thế, Chúa Hằng Hữu bắt chúng ta cứ đi lang thang trong hoang mạc suốt bốn mươi năm, cho đến khi tất cả thế hệ tà ác chết hết. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Và bây giờ, anh em là một lũ tội lỗi, cũng phạm tội như cha ông mình, làm gia tăng cơn thịnh nộ của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Nếu anh em từ bỏ Ngài, Ngài sẽ để cho dân chúng ở lại trong hoang mạc lâu hơn, và như vậy, chính anh em mang họa diệt vong đến cho dân tộc mình!” ");
INSERT INTO vieovcb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Nhưng họ bước đến bên Môi-se, thưa: “Chúng tôi chỉ xin lập chuồng cho bầy gia súc và xây thành cho con cái chúng tôi tại đây, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","nhưng chúng tôi sẽ mang khí giới đi trước toàn dân cho đến khi họ vào chiếm hữu đất mình. Tuy nhiên, con cháu chúng tôi cần có thành lũy bảo vệ để tránh khỏi hiểm họa dân địa phương có thể gây ra. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Chúng tôi hứa sẽ không về nhà cho đến khi toàn dân Ít-ra-ên đều an cư lạc nghiệp. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Vì chúng tôi đã nhận đất bên này sông Giô-đan (phía đông), nên chúng tôi sẽ không đòi gì thêm ở bên kia sông cả.” ");
INSERT INTO vieovcb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Nghe vậy, Môi-se nói: “Nếu anh em làm đúng như điều mình vừa nói, mang khí giới ra trận trước mặt Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","mỗi chiến sĩ đều qua sông Giô-đan, chiến đấu cho đến khi Chúa Hằng Hữu đuổi hết quân thù đi, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","sau đó anh em có thể trở về khi Chúa Hằng Hữu đã chinh phục xong toàn lãnh thổ. Lúc ấy anh em mới chu toàn trách nhiệm với Chúa Hằng Hữu và với người dân Ít-ra-ên. Đất bên phía đông sông Giô-đan sẽ thuộc quyền sở hữu của anh em, có Chúa Hằng Hữu chứng giám. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Nhưng nếu anh em không làm như điều mình đã nói, thì anh em mắc tội với Chúa Hằng Hữu, và anh em sẽ bị tội mình kết buộc. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Bây giờ, anh em cứ lo việc xây thành cho con cái mình ở, dựng chuồng cho bầy gia súc, nhưng sau đó phải nhớ làm theo lời mình đã hứa.” ");
INSERT INTO vieovcb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Những người thuộc đại tộc Gát và Ru-bên thưa: “Chúng tôi xin làm đúng theo mọi điều ông bảo. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Vợ con và súc vật của chúng tôi sẽ ở lại đây, trong những thành Ga-la-át, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","nhưng tất cả những người có nhiệm vụ quân dịch trong chúng tôi sẽ mang khí giới qua sông theo đúng lời ông dạy, có Chúa Hằng Hữu chứng giám.” ");
INSERT INTO vieovcb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Về việc này, Môi-se chỉ thị cho Thầy Tế lễ Ê-lê-a-sa, Giô-suê, con của Nun, và các trưởng tộc Ít-ra-ên ");
INSERT INTO vieovcb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","như sau: “Nếu tất cả những người có trách nhiệm quân sự trong hai đại tộc Gát và Ru-bên cùng qua sông Giô-đan với các ông, trước mặt Chúa Hằng Hữu, và khi toàn lãnh thổ đã bình định xong, thì các ông sẽ chia cho hai đại tộc ấy đất Ga-la-át. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Nhưng nếu những người vũ trang của họ không qua sông, thì họ chỉ được chia đất Ca-na-an với các đại tộc khác.” ");
INSERT INTO vieovcb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Người thuộc đại tộc Gát và Ru-bên đồng thanh: “Chúng tôi xin tuân lệnh Chúa Hằng Hữu đã truyền. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Chúng tôi xin mang khí giới qua sông, vào đất Ca-na-an trước sự chứng giám của Chúa Hằng Hữu, nhưng phần đất của chúng tôi sẽ ở bên này sông Giô-đan.” ");
INSERT INTO vieovcb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Như vậy, Môi-se cấp cho đại tộc Gát, đại tộc Ru-bên, và phân nửa đại tộc Ma-na-se, con Giô-sép, lãnh thổ của Si-hôn, vua A-mô-rít, của Óc, vua Ba-san, gồm cả đất đai lẫn thành thị. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Đại tộc Gát xây các thành Đi-bôn, A-ta-rốt, A-rô-e, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Ạt-rốt Sô-phan, Gia-ê-xe, Giô-bê-ha, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bết Nim-ra, và Bết Ha-ran. Đó là những thành có hào lũy kiên cố và có chuồng cho gia súc. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Đại tộc Ru-bên xây các thành Hết-bôn, Ê-lê-a-lê, Ki-ri-a-ta-im, ");
INSERT INTO vieovcb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nê-bô, Ba-anh Mê-ôn, và Síp-ma. Về sau, người Ít-ra-ên đổi tên hầu hết các thành này, là thành họ đã chiếm được và tái thiết. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Con cháu Ma-ki con Ma-na-se, vào xứ Ga-la-át, chiếm đất của người A-mô-rít là dân đang cư ngụ tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Vậy, Môi-se cấp cho Ma-ki đất, con cháu Ma-na-se, Ga-la-át và họ lập nghiệp tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Con cháu Giai-rơ, một con khác của Ma-na-se, đi chiếm một số thành thị nhỏ, đổi tên vùng mình chiếm đóng thành Giai-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nô-bách đánh chiếm thành Kê-nát và các thôn ấp phụ cận, rồi lấy tên mình đặt cho vùng ấy. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Sau đây là lộ trình của người Ít-ra-ên từ ngày Môi-se và A-rôn dẫn họ ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Môi-se đã ghi lại từng chặng một theo lệnh của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Họ bắt đầu cuộc hành trình vào ngày rằm tháng giêng, ngay sau lễ Vượt Qua từ Ram-se, ra đi cách ngang nhiên trước mắt mọi người Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Trong khi đó, các gia đình Ai Cập lo chôn cất con trưởng nam mình vừa bị Chúa Hằng Hữu hình phạt. Chúa Hằng Hữu cũng đoán phạt các thần Ai Cập thật nặng nề! ");
INSERT INTO vieovcb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Rời Ram-se, họ đến Su-cốt, và dừng chân cắm trại tại đó. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Rời Su-cốt, họ đến cắm trại tại Ê-tam, ven hoang mạc. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Rời Ê-tam, họ đi vòng lại Phi Ha-hi-rốt về phía đông của Ba-an Sê-phôn và cắm trại trước Mích-đôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Rời Phi Ha-hi-rốt, họ đi qua giữa Biển Đỏ, xuyên vào hoang mạc Ê-tam suốt ba ngày đường rồi cắm trại tại Ma-ra. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Rời Ma-ra, họ đến cắm trại tại Ê-lim là nơi có mười hai suối nước và bảy mươi cây chà là. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Rời Ê-lim, họ đến cắm trại bên bờ Biển Đỏ. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Rời Biển Đỏ, họ cắm trại trong hoang mạc Xin. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Rời hoang mạc Xin, họ cắm trại tại Đáp-ca. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Rời Đáp-ca, họ cắm trại tại A-lúc. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Rời A-lúc, họ cắm trại tại Rê-phi-đim, tại đó không có nước uống. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Rời Rê-phi-đim, họ cắm trại trong hoang mạc Si-nai. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Rời hoang mạc Si-nai, họ cắm trái tại Kíp-rốt Ha-tha-va. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Rời Kíp-rốt Ha-tha-va, họ cắm trại tại Hát-sê-rốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Rời Hát-sê-rốt, họ cắm trại tại Rít-ma. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Rời Rít-ma, họ cắm trại tại Ri-môn Phê-rết. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rời Ri-môn Phê-rết, họ cắm trại tại Líp-na. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Rời Líp-na, họ cắm trại tại Ri-sa. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Rời Ri-sa, họ cắm trại tại Kê-hê-la-tha. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Rời Kê-hê-la-tha, họ cắm trại tại núi Sê-phe. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Rời núi Sê-phe, họ cắm trại tại Ha-ra-đa. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Rời Ha-ra-đa, họ cắm trại tại Mác-hê-lốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Rời Mác-hê-lốt, họ cắm trại tại Ta-hát. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Rời Ta-hát, họ cắm trại tại Ta-rách. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Rời Ta-rách, họ cắm trại tại Mít-ga. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Rời Mít-ga, họ cắm trại tại Hách-mô-na. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Rời Hách-mô-na, họ cắm trại tại Mô-sê-rốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Rời Mô-sê-rốt, họ cắm trại tại Bê-nê Gia-can. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Rời Bê-nê Gia-can, họ cắm trại tại Hô-ghi-gát. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Rời Hô-ghi-gát, họ cắm trại tại Dốt-ba-tha. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Rời Dốt-ba-tha, họ cắm trại tại Áp-rô-na. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Rời Áp-rô-na, họ cắm trại tại Ê-xi-ôn Ghê-be. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Rời Ê-xi-ôn Ghê-be, họ cắm trại tại Ca-đe trong hoang mạc Xin. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Rời Ca-đe, họ cắm trại tại Núi Hô-rơ cạnh biên giới Ê-đôm. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Tại đây, Chúa Hằng Hữu phán bảo Thầy Tế lễ A-rôn lên Núi Hô-rơ. Ông vâng lời, lên núi và qua đời trên đó. Hôm ấy là ngày mồng một tháng năm, vào năm thứ bốn mươi, kể từ ngày người Ít-ra-ên ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","A-rôn qua đời tại Núi Hô-rơ, thọ 123 tuổi. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Vào lúc này, Vua A-rát, người Ca-na-an ở Nê-ghép của đất Ca-na-an, nghe tin người Ít-ra-ên kéo đến. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Rồi người Ít-ra-ên lại ra đi, rời Núi Hô-rơ và cắm trại tại Xa-mô-na. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Rời Xa-mô-na, họ cắm trại tại Phu-nôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Rời Phu-nôn, họ cắm trại tại Ô-bốt. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Rời Ô-bốt, họ cắm trại tại Y-giê A-ba-rim cạnh biên giới Mô-áp. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Rời Y-giê A-ba-rim, họ cắm trại tại Đi-bôn Gát. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Rời Đi-bôn Gát, họ cắm trại tại Anh-môn Đíp-lát-tha-im. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Rời Anh-môn Đíp-lát-tha-im, họ cắm trại tại núi A-ba-rim, trước Nê-bô. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Rời núi A-ba-rim, họ cắm trại trong đồng bằng Mô-áp, bên Sông Giô-đan, đối diện Giê-ri-cô. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Tại đây, trại của họ chạy dài ven Sông Giô-đan, từ Bết-giê-si-mốt đến A-bên Si-tim trên cánh đồng Mô-áp. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Trong thời gian họ ở gần Sông Giô-đan, trong đồng bằng Mô-áp, đối diện Giê-ri-cô Chúa Hằng Hữu phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Hãy nói với người Ít-ra-ên, khi qua Sông Giô-đan vào đất Ca-na-an rồi, ");
INSERT INTO vieovcb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","các ngươi phải đuổi hết dân bản xứ đi và tiêu hủy các tượng thờ, cả tượng đá lẫn tượng đúc, san bằng các nơi cúng tế tà thần trên đồi cao của họ. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Các ngươi được chiếm hữu đất đai của họ và sống trên đó, vì Ta đã cho các ngươi đất đó làm sản nghiệp. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Các ngươi sẽ bắt thăm chia đất với nhau. Trước hết, đất phải được phân chia cho các đại tộc. Rồi trong mỗi đại tộc, tùy theo gia đình lớn nhỏ mà phân chia, gia đình lớn được phần đất lớn, gia đình nhỏ phần đất nhỏ. Thăm sẽ định phần đất mỗi gia đình được hưởng. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Nhưng nếu các ngươi không đuổi hết dân bản xứ đi, thì những người còn lại sẽ như gai trong mắt, như chông nơi hông các ngươi, họ sẽ gây ra bao điều phiền nhiễu sau này. ");
INSERT INTO vieovcb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Và Ta sẽ hình phạt các ngươi như Ta đã định hình phạt họ vậy.” ");
INSERT INTO vieovcb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Chúa Hằng Hữu phán bảo Môi-se nói với người Ít-ra-ên: ");
INSERT INTO vieovcb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Khi các ngươi vào Ca-na-an là đất Ta cho làm sản nghiệp, giới hạn đất ấy sẽ được ấn định như sau: ");
INSERT INTO vieovcb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Về phía nam, đất gồm có hoang mạc Xin, chạy dọc theo nước Ê-đôm. Về phía nam, đất ấy sẽ từ hoang mạc Xin chạy dài theo Ê-đôm. Ranh giới phía nam sẽ chạy từ cuối Biển Chết, về hướng đông. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Biên giới phía nam của dốc núi Ạc-ráp-bim, tiếp tục chạy dài đến hoang mạc Xin, sâu xuống đến phía nam của Ca-đê Ba-nê-a, rồi từ đó chạy đến Hát-sa-át-đa, ngang qua Át-môn. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Từ Át-môn, biên giới sẽ quay qua Suối Ai Cập và dừng lại ở biển Địa Trung Hải. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Biên giới phía tây là bờ Địa Trung Hải. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Biên giới phía bắc chạy từ Địa Trung Hải cho đến Núi Hô-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Từ đó vạch một đường đến lối vào Ha-mát, qua sông Xê-đát, ");
INSERT INTO vieovcb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Xíp-rôn, và chấm dứt ở Hát-sa-ê-nan. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Biên giới phía đông sẽ bắt đầu từ Hát-sa-ê-nan chạy đến Sê-pham. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Từ đó xuống Ríp-la về phía đông của A-in, rồi tiếp tục xuống nữa cho đến khi giáp phía đông của Biển Ki-nê-rết, ");
INSERT INTO vieovcb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","và tiếp tục chạy dọc theo Sông Giô-đan, và chấm dứt ở Biển Chết. Đó là biên giới của các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Rồi Môi-se nói với người Ít-ra-ên: “Đó là đất của chín đại tộc rưỡi. Họ sẽ bắt thăm chia đất theo lệnh của Chúa Hằng Hữu, ");
INSERT INTO vieovcb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","vì đại tộc Ru-bên, Gát, và phân nửa đại tộc Ma-na-se ");
INSERT INTO vieovcb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","đã nhận phần đất mình bên bờ phía đông Sông Giô-đan, đối diện Giê-ri-cô về hướng đông.” ");
INSERT INTO vieovcb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Chúa Hằng Hữu lại phán bảo Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Sau đây là những người có trách nhiệm chia đất: Thầy Tế lễ Ê-lê-a-sa, Giô-suê, con trai của Nun, ");
INSERT INTO vieovcb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","và mỗi đại tộc một nhà lãnh đạo. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Đây là danh sách các nhà lãnh đạo các đại tộc: Ca-lép, con Giê-phu-nê, đại diện Giu-đa. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Sê-mu-ên, con A-mi-hút, đại diện Si-mê-ôn. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Ê-li-đát, con Kít-long, đại diện Bên-gia-min. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Bu-ki, con Giốc-đi, đại diện Đan. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Ha-ni-ên, con Ê-phát, đại diện Ma-na-se, con trai của Giô-sép. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kê-mu-ên, con Síp-tan, đại diện Ép-ra-im. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Ê-li-sa-phan, con Phác-nát, đại diện Sa-bu-luân. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Pha-ti-ên, con A-xan, đại diện Y-sa-ca. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","A-hi-hút, con Sê-lô-mi, đại diện A-se. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Phê-đa-ên, con A-mi-hút, đại diện Nép-ta-li. ");
INSERT INTO vieovcb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Đó là những người Chúa Hằng Hữu chỉ định đứng ra chia đất Ca-na-an cho người Ít-ra-ên.” ");
INSERT INTO vieovcb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Khi người Ít-ra-ên đang ở bên sông Giô-đan trong đồng bằng Mô-áp, đối diện Giê-ri-cô, Chúa Hằng Hữu phán dạy Môi-se: ");
INSERT INTO vieovcb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Hãy bảo người Ít-ra-ên nhường cho người Lê-vi một số thành và đất quanh thành trong phần tài sản họ nhận được. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Thành phố để người Lê-vi ở và đất để họ nuôi súc vật. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Đất này sẽ được nới rộng ra bên ngoài bức tường bao quanh thành 460 mét. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Như vậy, hai bên đông tây của thành, đất được nới ra 920 mét, hai bên nam bắc, đất cũng được nới ra 920 mét, và thành ở chính giữa. Họ sẽ được vùng đất ấy để chăn nuôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Trong số các thành các ngươi tặng người Lê-vi, phải dành sáu thành làm nơi trú ẩn cho những người ngộ sát. Ngoài ra các ngươi hãy tặng họ bốn mươi hai thành khác. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Như vậy các ngươi sẽ tặng người Lê-vi bốn mươi tám thành tất cả, luôn cả đất chung quanh thành làm bãi cỏ chăn nuôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Mỗi đại tộc sẽ đóng góp vào số các thành này tùy theo diện tích tài sản mình hưởng: Đại tộc có nhiều đất, nhiều thành, đóng góp nhiều; đại tộc có ít đóng góp ít.” ");
INSERT INTO vieovcb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Chúa Hằng Hữu phán bảo Môi-se nói với người Ít-ra-ên: ");
INSERT INTO vieovcb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Một khi các ngươi đã qua sông Giô-đan vào đất Ca-na-an, ");
INSERT INTO vieovcb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","các ngươi sẽ chọn những thành làm nơi trú ẩn cho những người ngộ sát. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Những thành này là nơi họ ẩn náu tránh người báo thù, vì họ phải được sống còn đến ngày ra tòa. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Trong sáu thành trú ẩn, ");
INSERT INTO vieovcb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","phải có ba thành bên này Sông Giô-đan và ba thành trong đất Ca-na-an. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Các thành này không những chỉ là nơi trú ẩn cho người Ít-ra-ên, mà cũng cho ngoại kiều và khách tạm trú khi họ lỡ tay giết người. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Nhưng nếu ai dùng khí cụ bằng sắt đánh chết người khác, thì người ấy phải bị xử tử vì tội sát nhân. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Hoặc nếu ai cầm đá đánh chết người khác, thì người ấy phải bị xử tử vì tội sát nhân. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Hoặc nếu ai dùng khí giới bằng gỗ đánh chết người khác, thì người ấy phải bị xử tử vì tội sát nhân. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Khi người báo thù tìm gặp sẽ tự tay giết chết kẻ sát nhân để trả nợ máu. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Nếu ai vì ghen ghét xô đẩy người khác, hoặc rình rập đợi chờ để ném vật gì giết chết người khác, ");
INSERT INTO vieovcb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","hoặc nếu ai vì thù hận vung tay đánh chết người khác, thì đều phải bị xử tử. Khi người báo thù tìm gặp, sẽ giết chết kẻ sát nhân. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Nhưng nếu ai giết người vì tình cờ, xô đẩy người khác không do ghen ghét, ném vật gì vào người khác không do dự mưu (rình rập), ");
INSERT INTO vieovcb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","hoặc ngẫu nhiên ném đá trúng phải người khác chứ không do hận thù, không cố tình hại người, ");
INSERT INTO vieovcb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","thì tòa án khi phân xử giữa người ngộ sát và người báo thù, sẽ căn cứ trên các nguyên tắc này ");
INSERT INTO vieovcb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","để giải cứu người ngộ sát khỏi tay người báo thù, và cho người ấy ở lại trong thành trú ẩn người ấy đã trốn đến. Người ấy cứ tiếp tục ở đó cho đến khi thầy thượng tế qua đời. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Nhưng nếu người ấy ra khỏi ranh giới của thành trú ẩn, ");
INSERT INTO vieovcb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","và nếu người báo thù bắt gặp, giết đi, người báo thù sẽ không mắc tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Người ấy phải ở lại trong thành ẩn náu, đến khi thầy thượng tế qua đời mới được trở về nhà mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Luật này sẽ áp dụng vĩnh viễn cho người Ít-ra-ên, bất kỳ họ ở đâu. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Kẻ sát nhân phải bị xử tử, nhưng phải có ít nhất hai nhân chứng. Một nhân chứng không đủ để kết án tử hình. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Người đã lãnh án tử hình vì giết người, không được chuộc mạng, nhưng phải đền tội. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Người chạy trốn trong thành trú ẩn, không được trả tiền chuộc mạng để về nhà trước ngày thầy thượng tế qua đời. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Đừng gây đổ máu khiến đất bị ô uế. Một khi đất đã ô uế, chỉ có máu của kẻ sát nhân mới chuộc tội cho đất được mà thôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Đừng làm ô uế đất mình, vì Ta, Chúa Hằng Hữu, ngự giữa các ngươi.” ");
INSERT INTO vieovcb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Những người đứng đầu họ Ga-la-át, là con Ma-ki, cháu Ma-na-se, chắt Giô-sép, đến thưa với Môi-se và các trưởng tộc Ít-ra-ên: ");
INSERT INTO vieovcb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“Tuân lệnh Chúa Hằng Hữu, ông có chia đất cho Ít-ra-ên theo lối bốc thăm, và cũng có giao tài sản đất đai của anh chúng tôi là Xê-lô-phát cho các con của anh chúng tôi. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Nếu các cháu lấy chồng là người thuộc đại tộc khác, phần đất của các cháu sẽ theo họ về đại tộc nhà chồng, và như vậy đất đai của chúng tôi sẽ bị thu hẹp. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Đến Năm Hân Hỉ, đất cũng chẳng hoàn lại đại tộc chúng tôi, nhưng vĩnh viễn bị sáp nhập vào đại tộc khác.” ");
INSERT INTO vieovcb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Để giải quyết vấn đề này, Môi-se nhận lệnh Chúa Hằng Hữu, rồi nói lại cho người Ít-ra-ên như sau: “Các con cháu đại tộc Giô-sép trình bày hợp lý. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Đây là lệnh của Chúa Hằng Hữu về vụ các con gái Xê-lô-phát: Họ được lấy ai làm chồng tùy ý, miễn là người chồng thuộc trong cùng một đại tộc. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Như vậy đất đai sẽ không chuyền từ đại tộc này sang đại tộc khác, nhưng mỗi người sẽ giữ đất cho đại tộc mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Mỗi người con gái nhận được đất đai làm tài sản, dù thuộc đại tộc nào, nếu lấy chồng, thì chồng phải là người trong cùng đại tộc, như vậy đất đai của đại tộc nào được giữ trong đại tộc ấy, chứ không chuyển sang đại tộc khác. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Không một sản nghiệp nào được chuyển từ đại tộc này qua đại tộc khác, vì mỗi đại tộc Ít-ra-ên phải giữ đất đai mình đã thừa hưởng.” ");
INSERT INTO vieovcb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Các con gái Xê-lô-phát tuân theo lệnh của Chúa Hằng Hữu do Môi-se truyền lại. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Các con gái của Xê-lô-phát là Mách-la, Thiệt-sa, Hốt-la, Minh-ca, và Nô-a, đều kết hôn với anh em chú bác của mình. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Các cô lấy chồng trong cùng đại tộc Ma-na-se, con Giô-sép. Như vậy đất của họ vẫn thuộc về đại tộc này. ");
INSERT INTO vieovcb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Đó là những luật lệ của Chúa Hằng Hữu phán bảo Môi-se truyền cho Ít-ra-ên khi họ đang ở trong đồng bằng Mô-áp, bên Sông Giô-đan, đối diện Giê-ri-cô.");
INSERT INTO vieovcb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Đây là huấn thị của Môi-se cho toàn dân Ít-ra-ên khi họ còn ở trong hoang mạc, bên bờ phía đông Sông Giô-đan, trong đồng bằng đối diện Su-phơ, khoảng giữa Pha-ran, Tô-phên, La-ban, Hát-sê-rốt, và Đi-xa-háp. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Theo đường Núi Sê-i-rơ, họ đi từ Núi Hô-rếp tới Ca-đê Ba-nê-a mất mười một ngày. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ngày mồng một tháng mười một năm thứ bốn mươi, Môi-se truyền lại cho dân chúng tất cả những luật lệ, chỉ thị của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Việc này xảy ra sau cuộc chiến thắng Si-hôn, vua A-mô-rít ở Hết-bôn và Óc, vua Ba-san ở Ách-ta-rốt, và Ết-rê-i. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Khi người Ít-ra-ên ở trong đất Mô-áp, phía đông Sông Giô-đan, Môi-se khởi sự giảng giải chỉ thị của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Tại Hô-rếp, Chúa Hằng Hữu, Đức Chúa Trời của chúng ta, phán rằng: ‘Các ngươi ở lại núi này đã khá lâu. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Bây giờ, đi vòng lại phía đồi núi của người A-mô-rít và những vùng lân cận, gồm cả những vùng đồng bằng, đồi núi, thung lũng ở miền nam, vùng ven biển, đất của người Ca-na-an, Li-ban, cho đến tận sông lớn tức Sông Ơ-phơ-rát. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ta cho các ngươi tất cả vùng ấy. Đó là đất Chúa Hằng Hữu đã hứa cho Áp-ra-ham, Y-sác, Gia-cốp, và con cháu họ. Các ngươi đi vào và chiếm lấy đi.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Môi-se tiếp tục: “Lúc ấy, tôi nói với anh em rằng: ‘Trách nhiệm trước dân tộc quá nặng nề, một mình tôi không gánh vác nổi. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Chúa Hằng Hữu, Đức Chúa Trời của cha chúng ta đã cho chúng ta gia tăng dân số, và ngày nay dân ta đông như sao trời.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Cầu xin Chúa Hằng Hữu, Đức Chúa Trời của cha ông ta, cứ gia tăng dân số gấp nghìn lần, và ban phước lành cho anh em như Ngài đã hứa. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Nhưng một mình tôi làm sao giải quyết hết mọi vấn đề khó khăn và tranh chấp của anh em? ");
INSERT INTO vieovcb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Thế thì, anh em nên chọn những người khôn ngoan, hiểu biết và kinh nghiệm trong đại tộc mình, để tôi cắt cử họ lãnh đạo toàn dân. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Anh em trả lời: ‘Chúng ta nên thực hiện điều ông nói.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Vậy, tôi bổ nhiệm những người được dân chúng chọn lựa làm lãnh đạo, phụ trách hàng nghìn, hàng trăm, hàng năm chục, và hàng chục người trong mỗi đại tộc. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Tôi dặn họ trong lúc xét xử phải công minh với mọi người, người Ít-ra-ên cũng như ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Không được thiên vị sang hèn, không nể người quyền quý; phải công bằng xét lý lẽ đôi bên, vì việc xét xử vốn là việc của Đức Chúa Trời. Tôi cũng dặn họ nếu thấy vụ nào khó xử, cứ mang đến cho tôi, tôi sẽ giải quyết. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Đồng thời tôi cũng có truyền cho anh em mọi luật lệ, chỉ thị khác cần phải tuân giữ.” ");
INSERT INTO vieovcb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Sau đó, chúng ta rời Hô-rếp đi xuyên hoang mạc khủng khiếp mênh mông, để vào miền đồi núi của người A-mô-rít, theo lệnh Chúa Hằng Hữu, Đức Chúa Trời chúng ta, tiến đến Ca-đê Ba-nê-a. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Tôi nói với anh em: ‘Đồi núi của người A-mô-rít này là địa đầu của lãnh thổ Chúa Hằng Hữu cho ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Anh em hãy tiến lên, chiếm lấy đất hứa như Chúa Hằng Hữu cho ta. Đừng sờn lòng, nản chí!’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Nhưng anh em đề nghị: ‘Chúng ta nên sai do thám đi trước, họ sẽ cho biết ta nên tiến lên theo lối nào, và thành nào cần phải chiếm trước.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Lời đề nghị ấy hợp lý, tôi chọn trong mỗi đại tộc một người đi do thám. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Họ đi lên vùng đồi núi, đến thung lũng Ếch-côn. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Họ hái một số hoa quả và đem về cho chúng ta. Họ báo rằng: ‘Vùng đất mà Chúa Hằng Hữu, Đức Chúa Trời chúng ta ban cho thật là phì nhiêu.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Nhưng anh em đã nổi loạn, chống lại lệnh của Chúa Hằng Hữu, Đức Chúa Trời của anh em, không chịu tiến lên. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Ở nhà, anh em nhỏ to phàn nàn với nhau: ‘Vì ghét ta nên Chúa Hằng Hữu mới dẫn ta ra khỏi Ai Cập, đem đến đây cho người A-mô-rít tiêu diệt. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Chúng ta đi đâu bây giờ?’ Lòng tôi tan nát khi nghe các anh em nói chuyện: ‘Dân ấy cao lớn hơn ta, thành của họ cao tận trời, hào lũy kiên cố. Anh em còn cho biết họ có thấy người khổng lồ A-na-kim ở đó nữa!’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Nhưng tôi nói với anh em rằng: ‘Anh em đừng sợ! ");
INSERT INTO vieovcb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Chúa Hằng Hữu, là Đức Chúa Trời của anh em, luôn luôn đi trước anh em. Ngài sẽ chiến đấu cho anh em, như anh em đã thấy Ngài chiến đấu tại Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Còn lúc ở trong hoang mạc, anh em cũng đã chứng kiến cảnh Chúa Hằng Hữu săn sóc dân ta, như một người cha cõng con trai mình qua từng chặng đường cho đến nơi này.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Bất chấp những lời tôi nói, anh em không chịu tin tưởng Chúa Hằng Hữu, Đức Chúa Trời của anh em, ");
INSERT INTO vieovcb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","mặc dù Ngài vẫn đi trước anh em, tìm cho anh em một nơi để cắm trại, dùng một trụ lửa ban đêm và một trụ mây ban ngày để dẫn đường anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Chúa Hằng Hữu nghe những lời phàn nàn của anh em, Ngài giận lắm, thề rằng: ");
INSERT INTO vieovcb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Sẽ không một ai thuộc thế hệ này được thấy đất hứa, ");
INSERT INTO vieovcb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","trừ Ca-lép, con Giê-phu-nê, là người đã hết lòng theo Chúa Hằng Hữu. Ca-lép và con cháu ông sẽ hưởng một phần đất chính bàn chân ông đã đặt lên.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Chúa Hằng Hữu cũng giận cả tôi vì lỗi của anh em, phán rằng: ‘Con cũng không được vào đất hứa!’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Còn Giô-suê, con của Nun, người đang đứng trước anh em đây, sẽ được vào đó. Anh em nên khích lệ Giô-suê, vì ông sẽ lãnh đạo Ít-ra-ên trong cuộc chiếm đóng đất hứa. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Chúa Hằng Hữu sẽ giao đất hứa cho con cái họ, lúc ấy là những em bé chưa phân biệt thiện ác. Họ bảo rằng con cái mình sẽ làm mồi cho địch; nhưng không, chính con cái họ sẽ vào chiếm đất hứa. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Còn anh em phải quay lại, đi vào hoang mạc hướng về Biển Đỏ. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Lúc ấy, anh em nói: ‘Chúng tôi có tội với Chúa Hằng Hữu. Chúng tôi xin tiến lên chiến đấu như Chúa Hằng Hữu, Đức Chúa Trời của chúng ta, đã bảo.’ Và anh em tự ý trang bị khí giới, sẵn sàng tiến lên miền đồi núi. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Chúa Hằng Hữu phán bảo tôi nói với anh em rằng: ‘Đừng tiến lên chiến đấu; họ sẽ bị quân thù đánh bại vì Ta không đi với họ.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Đây là điều tôi đã nói với anh em, nhưng anh em không nghe. Anh em đã cãi lệnh Chúa Hằng Hữu, tùy tiện tiến lên vùng đồi núi. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Người A-mô-rít ở trên đồi núi đổ ra, đuổi anh em chạy như ong vỡ tổ, đánh giết họ từ Sê-i-rơ cho đến Họt-ma. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Anh em chạy về kêu khóc với Chúa Hằng Hữu, nhưng Ngài không nghe nữa. ");
INSERT INTO vieovcb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Và anh em ở lại Ca-đe trong một thời gian dài.” ");
INSERT INTO vieovcb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“Rồi chúng ta quay lại, đi vào hoang mạc hướng về Biển Đỏ như Chúa Hằng Hữu đã bảo tôi, chúng ta phải đi vòng quanh vùng Núi Sê-i-rơ trong một thời gian rất lâu. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Một hôm, Chúa Hằng Hữu phán bảo tôi: ");
INSERT INTO vieovcb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘Con cho dân biết là họ đi quanh vùng này đủ rồi; bây giờ hãy chuyển lên hướng bắc. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Con hãy truyền lệnh này cho dân chúng: “Các ngươi sắp đi qua lãnh thổ của một nước anh em. Dân nước này là con cháu Ê-sau, sinh sống ở Sê-i-rơ, và họ sẽ sợ các ngươi, nhưng phải thận trọng, ");
INSERT INTO vieovcb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","không được gây hấn với họ. Ta sẽ không cho các ngươi đất của họ, dù một mảnh lọt bàn chân cũng không, vì Ta đã cho Ê-sau vùng Núi Sê-i-rơ này. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Khi cần thức ăn, nước uống, các ngươi phải mua của họ và trả tiền hẳn hoi. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Vì Chúa Hằng Hữu là Đức Chúa Trời đã ban phước cho mọi công việc của các ngươi, trong suốt bốn mươi năm lang thang trong hoang mạc mênh mông, Ngài vẫn ở với các ngươi, không để cho thiếu thốn gì cả.”’ ");
INSERT INTO vieovcb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Vậy, chúng ta đi qua đất của anh em mình, là con cháu Ê-sau ở Sê-i-rơ, theo đường cái A-ra-ba từ Ê-lát, và từ Ê-xi-ôn Ghê-be. Vậy chúng ta rẽ lên hướng hoang mạc Mô-áp, ");
INSERT INTO vieovcb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Chúa Hằng Hữu cảnh báo chúng ta: ‘Đừng gây hấn với người Mô-áp. Ta không cho các ngươi đất của họ, vì Ta đã cho con cháu của Lót vùng A-rơ này.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Trước kia người Ê-mim ở trong vùng ấy, họ là một giống dân hùng mạnh, đông đúc, cao lớn như người A-na-kim. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Cũng như người A-na-kim, họ được gọi là Rê-pha-im, nhưng người Mô-áp gọi họ là Ê-mim. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Còn Sê-i-rơ trước kia là đất của người Hô-rít, về sau con cháu Ê-sau đến diệt người, chiếm đất. Đó cũng là điều Ít-ra-ên sắp làm cho vùng đất Chúa Hằng Hữu cho họ.) ");
INSERT INTO vieovcb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Môi-se tiếp: “Bây giờ Chúa Hằng Hữu phán bảo chúng ta: ‘Hãy đứng dậy. Đi qua Suối Xê-rết.’ Vậy, chúng ta băng suối theo lệnh Chúa. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Từ ngày rời Ca-đe Ba-nê-a cho đến lúc băng Suối Xê-rết, tính đúng ba mươi tám năm! Trong thời gian này, Chúa Hằng Hữu ra tay tiêu diệt hết thế hệ phạm tội ở Ca-đê Ba-nê-a, từ lứa tuổi đầu quân trở lên, như lời Ngài đã thề. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Tay Chúa Hằng Hữu chống lại họ cho đến khi Ngài loại bỏ tất cả những người này. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Vậy, khi thế hệ ấy qua rồi, ");
INSERT INTO vieovcb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Chúa Hằng Hữu phán cùng tôi: ");
INSERT INTO vieovcb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Hôm nay, các ngươi sẽ đi qua biên giới Mô-áp ở vùng A-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Và khi đến gần đất của con cháu Am-môn, các ngươi không được gây hấn, vì Ta sẽ không cho các ngươi đất của họ. Ta đã cho con cháu của Lót đất ấy.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Đất này trước kia thuộc người Rê-pha-im, là một giống dân hùng mạnh, đông đúc, cao lớn như người A-na-kim; riêng người Am-môn gọi họ là Xam-xu-mim. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Họ là một dân lớn, đông, cao to như người A-na-kim. Nhưng Chúa Hằng Hữu diệt người Rê-pha-im, và người Am-môn chiếm chỗ của họ. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Đó cũng là điều Chúa làm để giúp con cháu Ê-sau, khi Ngài diệt người Hô-rít, cho người Ê-đôm đất Sê-i-rơ. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Một trường hợp tương tự khác là người A-vim cư ngụ trong các làng mạc xa xôi đến tận Ga-xa bị người ở Cáp-tô-rim đến tiêu diệt, chiếm đất.) ");
INSERT INTO vieovcb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Môi-se nói tiếp: “Rồi Chúa Hằng Hữu phán: ‘Bây giờ các ngươi lên đường, băng Sông Ạt-nôn, vào đất của Si-hôn, người A-mô-rít, vua Hết-bôn, đánh phá và chiếm cứ đất đai! ");
INSERT INTO vieovcb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Từ hôm nay, Ta làm cho muôn dân hãi hùng khi nghe nói về các ngươi, run rẩy khi đứng trước các ngươi.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Môi-se nói tiếp: “Từ hoang mạc Kê-đê-mốt, tôi sai sứ giả đến gặp Si-hôn, vua Hết-bôn, để bàn chuyện hòa bình: ");
INSERT INTO vieovcb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Xin cho chúng tôi đi qua đất vua. Chúng tôi chỉ xin đi trên đường cái, không rẽ ngang rẽ dọc. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Chúng tôi sẽ mua thức ăn nước uống, trả tiền sòng phẳng. Chỉ xin cho chúng tôi mượn đường đi qua, ");
INSERT INTO vieovcb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","cũng như con cháu Ê-sau ở Sê-i-rơ và người Mô-áp ở A-rơ đã giúp chúng tôi. Vì chúng tôi đang đi trên đường vào đất Chúa Hằng Hữu, Đức Chúa Trời chúng tôi cho chúng tôi, bên kia sông Giô-đan.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Nhưng Vua Si-hôn của Hết-bôn từ chối, vì Chúa Hằng Hữu, Đức Chúa Trời của chúng ta, đã làm cho vua ấy trở nên ương ngạnh, để giao họ cho chúng ta trừng phạt. Đó là việc đã xảy ra. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Chúa Hằng Hữu phán bảo tôi: ‘Ta đã nộp Vua Si-hôn và đất của vua vào tay con. Hãy tấn công và chiếm lấy đi đất.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Vua Si-hôn đem toàn lực ra giao chiến tại Gia-hát. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Nhưng Chúa Hằng Hữu, Đức Chúa Trời chúng ta, nạp họ cho chúng ta, cha con Si-hôn và toàn lực lượng của vua ấy bị đánh bại. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Chúng ta xâm chiếm mọi thành của họ, giết cả nam phụ lão ấu. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Chỉ giữ lại bầy gia súc và các chiến lợi phẩm đoạt được. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Vậy từ A-rô-e, một thành ở bên bờ Khe Ạt-nôn, cho đến Ga-la-át, một thành trong thung lũng, chẳng có thành nào là kiên cố quá cho chúng ta cả, vì Chúa Hằng Hữu, Đức Chúa Trời chúng ta, đã nạp tất cả vào tay chúng ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Tuy nhiên, theo lệnh Chúa, chúng ta không động đến đất của người Am-môn ở dọc mé Sông Gia-bốc, các thành ở trên núi và những nơi nào Chúa Hằng Hữu, Đức Chúa Trời chúng ta đã cấm.” ");
INSERT INTO vieovcb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“Sau đó, chúng ta quay qua bắt đường Ba-san đi lên. Vua Ba-san là Óc đem toàn lực ra nghênh chiến chúng ta tại Ết-rê-i. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Chúa Hằng Hữu phán cùng tôi: ‘Đừng sợ vua ấy, Ta nạp cả vua, dân, lẫn đất này vào tay các ngươi, các ngươi sẽ xử họ như xử Vua Si-hôn của A-mô-rít, ở Hết-bôn.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Vậy, Chúa Hằng Hữu, Đức Chúa Trời chúng ta đã phó Vua Óc và toàn quân của vua vào tay chúng ta, và chúng ta đã đánh bại, không để ai sống sót. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Chúng ta chiếm trọn sáu mươi thành trong toàn vùng Ạt-gốp, đất Ba-san. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Đó là những thành kiên cố, có lũy cao, cổng chấn song. Ngoài ra, chúng ta còn chiếm nhiều thôn ấp không có thành lũy bao bọc. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Chúng ta tiêu diệt Ba-san hoàn toàn, cũng như tiêu diệt Vua Si-hôn của Hết-bôn, hạ thành, giết hết nam phụ lão ấu. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Chỉ còn lại bầy gia súc và các chiến lợi phẩm đoạt được. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Như vậy, chúng ta chiếm hết đất của hai vua A-mô-rít, bên bờ phía đông Sông Giô-đan, từ Khe Ạt-nôn đến Núi Hẹt-môn. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Người Si-đôn gọi Núi Hẹt-môn là Si-ri-ôn, còn người A-mô-rít gọi là Sê-nia.) ");
INSERT INTO vieovcb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Tất cả các thành miền cao nguyên, miền Ga-la-át, miền Ba-san, cho đến hai thành của Vua Óc là Sanh-ca và Ết-rê-i. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Óc, vua Ba-san, là người Rê-pha-im sống sót sau cùng. Giường của vua này bằng sắt dài 4,1 mét, rộng 1,8 mét, nay còn tại Ráp-ba, một thành của người Am-môn.)” ");
INSERT INTO vieovcb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“Lúc ấy, tôi chia một phần đất vừa chiếm được cho hai đại tộc Ru-bên và Gát, từ A-rô-e bên Khe Ạt-nôn, và phân nửa núi Ga-la-át với các thành thị trong ấy. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Phần còn lại gồm phân nửa kia của núi Ga-la-át, và toàn lãnh thổ Ba-san của Óc, tức là vùng Ạt-gốp, tôi đem chia cho phân nửa đại tộc Ma-na-se. (Toàn vùng Ba-san trước kia còn được gọi là đất của người Rê-pha-im. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Giai-rơ thuộc đại tộc Ma-na-se chiếm toàn vùng Ạt-gốp tức Ba-san; vùng này chạy dài đến biên giới đất Ghê-sua và Ma-ca-thít. Ông đặt tên vùng này là Thôn Giai-rơ, tên này vẫn còn cho đến ngày nay.) ");
INSERT INTO vieovcb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Tôi cũng chia đất Ga-la-át cho Ma-ki. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Hai đại tộc Ru-bên và Gát nhận phần đất Ga-la-át; ranh giới hai bên là Khe Ạt-nôn và Sông Gia-bốc, sông này cũng là biên giới đất Am-môn. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Họ cũng nhận đất A-ra-ba với Sông Giô-đan làm giới hạn, từ Ki-nê-rết cho tới Biển A-ra-ba tức Biển Chết, dưới triền phía đông của núi Phích-ga. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Lúc ấy, tôi có dặn: ‘Chúa Hằng Hữu, là Đức Chúa Trời, đã cho anh em đất này, nhưng tất cả chiến sĩ của anh em phải qua sông, đi tiên phong chiến đấu cho tất cả các đại tộc khác. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Riêng vợ con và bầy gia súc của anh em sẽ ở lại trong các thành vừa nhận được, vì anh em có nhiều gia súc. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Anh em chỉ trở về khi nào Chúa Hằng Hữu, Đức Chúa Trời của anh em, đã cho các đại tộc khác chiếm đóng đất đai bên kia Sông Giô-đan!’” ");
INSERT INTO vieovcb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“Sau đó, tôi bảo Giô-suê: ‘Anh đã thấy điều Chúa Hằng Hữu, Đức Chúa Trời của anh, làm cho hai vua ấy. Ngài cũng sẽ xử các vua khác ở bên kia sông như vậy. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Đừng sợ họ, vì Chúa Hằng Hữu, Đức Chúa Trời của anh, sẽ chiến đấu cho anh.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Và lúc ấy, tôi cầu khẩn Chúa Hằng Hữu: ");
INSERT INTO vieovcb_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘Thưa Chúa Hằng Hữu là Đức Chúa Trời, Chúa bắt đầu cho con thấy tính cách cao cả và sức mạnh phi thường của Chúa. Vì dù trên trời hay dưới đất, có thần nào uy dũng như Chúa, làm được các việc Chúa làm? ");
INSERT INTO vieovcb_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Xin Chúa cho con qua sông Giô-đan để tận mắt ngắm nhìn đất đai phì nhiêu, núi đồi hùng vĩ, và cả dãy núi Li-ban.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Nhưng vì lỗi anh em, nên Chúa Hằng Hữu giận, không chấp nhận lời tôi xin. Ngài phán: ‘Đủ rồi! Đừng nhắc đến việc này nữa. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Nhưng cứ leo lên Đỉnh Phích-ga để chiêm ngưỡng đất hứa, vì trên ấy, con có thể nhìn khắp nơi khắp hướng, không cần phải qua Sông Giô-đan. ");
INSERT INTO vieovcb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Khi truyền giao chức vụ, con nên dùng lời khích lệ, củng cố tinh thần Giô-suê, vì Giô-suê sẽ dẫn dân chúng qua sông, chiếm lấy đất con được ngắm nhìn.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Rồi, chúng ta ở lại trong thung lũng đối diện Bết Phê-o.” ");
INSERT INTO vieovcb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“Hỡi anh em! Bây giờ xin lắng tai nghe kỹ và tuân hành những luật lệ tôi công bố. Nhờ vậy, dân ta mới mong sống còn, để đi chiếm vùng đất Chúa Hằng Hữu là Đức Chúa Trời của cha ông chúng ta ban cho. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Đừng thêm bớt điều gì vào luật này, chỉ việc tuân hành, vì đây là luật của Chúa. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Anh em đã thấy tận mắt điều Chúa Hằng Hữu làm trong vụ Ba-anh Phê-o. Chúa Hằng Hữu, Đức Chúa Trời của chúng ta, đã tiêu diệt những ai theo Ba-anh Phê-ô. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Còn ai trung thành với Chúa Hằng Hữu thì được sống cho đến hôm nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Luật lệ tôi đang dạy anh em đây là luật Chúa Hằng Hữu, Đức Chúa Trời của tôi truyền cho tôi, cũng là luật áp dụng trong lãnh thổ anh em sẽ chiếm cứ. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Nếu triệt để tuân hành luật này thì anh em trở nên khôn ngoan, thấu đáo. Những dân tộc khác khi nghiên cứu luật này sẽ trầm trồ: ‘Đây là một dân tộc khôn ngoan, trí tuệ!’ ");
INSERT INTO vieovcb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Vì làm gì có một nước nào—dù lớn đến đâu—có một vị thần ở gần bên dân, như Chúa Hằng Hữu, Đức Chúa Trời chúng ta, ở gần bên chúng ta, nghe lời chúng ta cầu khẩn? ");
INSERT INTO vieovcb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Có nước nào—dù lớn đến đâu—có được một bộ luật công chính như bộ luật tôi ban hành hôm nay? ");
INSERT INTO vieovcb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Phải hết lòng thận trọng, ghi khắc những điều mình đã thấy vào tâm khảm, suốt đời đừng quên. Cũng kể lại cho con cháu mình những điều tai nghe mắt thấy Chúa Hằng Hữu đã làm. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Như hôm tại Núi Hô-rếp, lúc anh em đứng trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, Ngài bảo tôi: ‘Hãy triệu tập dân chúng lại đây cho họ nghe lời Ta dạy, để họ biết kính sợ Ta suốt những ngày sống trên đất, và họ sẽ dạy con cái họ kính sợ Ta.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Anh em kéo đến đứng dưới chân núi, trong khi trên núi lửa cháy dữ dội, ngọn cao tận trời, mây phủ đen kịt, bóng tối dày đặc. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Từ giữa đám lửa, Chúa Hằng Hữu nói với anh em. Anh em nghe tiếng nói nhưng không thấy hình dáng Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ngài ban bố Mười Điều Răn cho anh em tuân hành, và ghi các điều răn lên hai bảng đá. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Đó là lúc Chúa Hằng Hữu phán bảo tôi dạy cho anh em luật lệ áp dụng trong lãnh thổ sắp chiếm cứ.” ");
INSERT INTO vieovcb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Vậy phải thận trọng, vì hôm ấy trên Núi Hô-rếp, khi Chúa Hằng Hữu nói với anh em từ trong đám lửa, anh em không thấy hình dáng của Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Nên đừng hành động một cách bại hoại mà làm tượng thờ theo bất kỳ hình dáng nào, dù là hình dáng đàn ông, đàn bà, ");
INSERT INTO vieovcb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","hay thú vật trên đất, chim chóc trên trời, ");
INSERT INTO vieovcb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","hoặc bất cứ loài côn trùng nào bò trên đất, hay loài cá nào dưới nước. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Cũng phải coi chừng, đừng thờ mặt trời, mặt trăng, hay các ngôi sao trên trời, vì đó chỉ là những vật Chúa Hằng Hữu, Đức Chúa Trời của anh em phân phối cho mọi người ở dưới trời. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Chúa Hằng Hữu đã cứu anh em ra khỏi cảnh dầu sôi lửa bỏng ở Ai Cập, cho anh em được làm dân của Ngài như ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Nhưng Chúa Hằng Hữu giận tôi vì anh em phạm tội. Ngài nhất quyết không cho tôi qua Sông Giô-đan, vào đất tốt đẹp Ngài hứa cho anh em làm sản nghiệp. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Tôi phải qua đời ở bên này sông, còn anh em sẽ vượt sông Giô-đan, chiếm hữu vùng đất tốt đẹp đó. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Vậy, phải thận trọng, không được quên giao ước Chúa Hằng Hữu, Đức Chúa Trời của anh em, đã kết với anh em. Đừng làm tượng thờ dưới bất kỳ hình thức nào, vì Chúa Hằng Hữu, Đức Chúa Trời của anh em đã cấm ngặt. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Vì Chúa Hằng Hữu, Đức Chúa Trời của anh em là lửa thiêu hủy; Ngài là Thần kỵ tà. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Sau này, khi ai nấy đã có con cháu đầy đàn, đã ở trong đất hứa lâu năm, nếu anh em hành động cách bại hoại, làm tượng thờ dù dưới hình thức nào, tức là khiêu khích Chúa Hằng Hữu, Đức Chúa Trời của anh em và chọc giận Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Xin trời đất chứng giám cho chúng ta hôm nay—nếu thế, anh em chắc chắn phải bị tiêu diệt khỏi lãnh thổ bên kia Giô-đan mà anh em sắp chiếm. Thời gian anh em cư trú tại đó sẽ thật ngắn ngủi. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Chúa Hằng Hữu sẽ phân tán anh em giữa các nước khác, và số người sống sót sẽ thật ít ỏi. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Tại các nước ấy, anh em sẽ thờ các thần bằng gỗ, bằng đá do người ta làm ra; các thần ấy không thấy, không nghe, không ăn, hay không ngửi. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Rồi anh em sẽ tìm kiếm Chúa Hằng Hữu, Đức Chúa Trời của anh em. Và nếu hết lòng, hết linh hồn tìm kiếm, anh em sẽ gặp Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Trong những ngày hoạn nạn khốn cùng ấy, anh em sẽ quay lại với Chúa Hằng Hữu, Đức Chúa Trời của anh em, vâng theo lời Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Chúa Hằng Hữu là Đức Chúa Trời của anh em, đầy lòng thương xót; Ngài không từ bỏ, tuyệt diệt anh em, cũng không quên giao ước Ngài đã lập với tổ tiên của anh em.” ");
INSERT INTO vieovcb_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“Trong quá khứ, tính từ khi Đức Chúa Trời tạo dựng loài người, từ góc trời này cho đến góc trời kia, có bao giờ có việc lạ thế này. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Một dân tộc nghe tiếng Đức Chúa Trời nói từ trong đám lửa, như trường hợp anh em, mà vẫn còn sống? ");
INSERT INTO vieovcb_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Có bao giờ Đức Chúa Trời dùng phép lạ, hoạn nạn, chiến tranh, các việc khủng khiếp để giải cứu một dân tộc nô lệ đang ở ngay trong nước đô hộ, như trường hợp Chúa Hằng Hữu, Đức Chúa Trời của anh em ra tay trừng trị Ai Cập ngay trước mắt anh em hay không? ");
INSERT INTO vieovcb_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Đó là những việc Ngài cho anh em thấy tận mắt, để anh em ý thức được chính Chúa Hằng Hữu là Đức Chúa Trời, ngoài ra không có thần nào khác. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Chúa cho anh em nghe tiếng Ngài vang ra từ trời để anh em được giáo hóa. Dưới đất, Ngài cho anh em thấy trụ lửa, và tiếng Ngài phát ra từ trong đám lửa. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Vì thương yêu tổ tiên chúng ta và dòng giống của tổ tiên, Ngài đích thân đem anh em ra khỏi Ai Cập bằng những phép lạ phi thường. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Ngài đánh đuổi dân các nước lớn mạnh hơn chúng ta, để đem anh em vào chiếm lấy đất họ làm sản nghiệp, như anh em thấy ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Vậy, anh em phải nhận thức và ghi khắc vào lòng rằng, trên trời, dưới đất, chỉ có Chúa Hằng Hữu là Đức Chúa Trời, chẳng có thần linh nào khác. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Anh em nhớ tuân theo các luật lệ tôi ban bố hôm nay, nhờ đó mà anh em và con cháu mai sau sẽ được thịnh vượng, vui hưởng tuổi thọ trong lãnh thổ Chúa Hằng Hữu, Đức Chúa Trời của anh em, ban cho vĩnh viễn.” ");
INSERT INTO vieovcb_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Sau đó, Môi-se ra chỉ thị, dành riêng ba thành bên bờ phía đông Sông Giô-đan ");
INSERT INTO vieovcb_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","dùng làm nơi trú ẩn cho những ai lầm lỡ giết người, không có hiềm khích trước. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Các thành đó là Bê-xe trên cao nguyên, trong hoang mạc, dành cho đại tộc Ru-bên; Ra-mốt trong Ga-la-át, cho đại tộc Gát; và Gô-lan thuộc Ba-san, cho đại tộc Ma-na-se. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Sau đây là bộ luật Môi-se ban hành cho người Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Đó là những quy định, phép tắc, luật lệ Môi-se trao cho họ sau khi ra khỏi Ai Cập, ");
INSERT INTO vieovcb_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","lúc họ đang ở trong thung lũng gần Bết-phê-o bên bờ phía đông Sông Giô-đan. (Vùng đất này đối diện Bết Phê-o, là đất của Si-hôn, vua A-mô-rít. Nhưng Môi-se và người Ít-ra-ên đánh bại vua và dân của vua ở Hết-bôn khi họ ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Họ chiếm lấy lãnh thổ này và lãnh thổ của Óc, vua Ba-san, là hai vua A-mô-rít ở phía đông Giô-đan, ");
INSERT INTO vieovcb_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","vùng đất này kéo dài từ A-rô-e, bên bờ Khe Ạt-nôn, cho đến Núi Si-ri-ôn, còn gọi là Núi Hẹt-môn, ");
INSERT INTO vieovcb_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","và tất cả miền đồng bằng bên bờ phía đông Sông Giô-đan, cho đến tận biển của đồng bằng, dưới triền núi Phích-ga.) ");
INSERT INTO vieovcb_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Môi-se kêu gọi toàn dân Ít-ra-ên tập hợp lại và nói: “Hỡi Ít-ra-ên, hãy cẩn thận lắng nghe luật lệ tôi công bố, học tập, và thực hành luật ấy! ");
INSERT INTO vieovcb_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Chúa Hằng Hữu, Đức Chúa Trời chúng ta, đã kết ước với chúng ta tại Núi Hô-rếp. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Chúa Hằng Hữu kết ước với chúng ta, là những người đang sống, chứ không phải với tổ tiên ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Từ trong đám lửa trên núi, Chúa Hằng Hữu đã đối diện nói chuyện với anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Lúc ấy, tôi đứng giữa Chúa Hằng Hữu và anh em, để truyền lại cho anh em mọi lời của Ngài, vì anh em sợ đám lửa, không dám lên núi. Ngài truyền dạy: ");
INSERT INTO vieovcb_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘Ta là Chúa Hằng Hữu, Đức Chúa Trời các ngươi, Đấng đã giải cứu các ngươi khỏi ách nô lệ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Các ngươi không được thờ thần nào khác ngoài Ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Các ngươi không được làm cho mình một hình tượng nào theo hình dạng của những vật trên trời cao, hoặc trên đất, hoặc trong nước. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Các ngươi không được quỳ lạy hoặc phụng thờ các tượng ấy, vì Ta, Chúa Hằng Hữu, Đức Chúa Trời các ngươi, rất kỵ tà. Người nào ghét Ta, Ta sẽ trừng phạt họ, và luôn cả con cháu họ cho đến ba bốn thế hệ. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Nhưng người nào yêu kính Ta và tuân giữ điều răn Ta, Ta sẽ thương yêu săn sóc người ấy và con cháu họ cho đến nghìn đời. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Không được lạm dụng tên của Chúa Hằng Hữu, Đức Chúa Trời các ngươi. Ai phạm tội này, Chúa Hằng Hữu sẽ trừng phạt. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Giữ ngày Sa-bát làm ngày thánh, như Chúa Hằng Hữu, Đức Chúa Trời ngươi, đã dạy. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Các ngươi có sáu ngày để làm công việc, ");
INSERT INTO vieovcb_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","nhưng ngày thứ bảy là ngày Sa-bát dành cho Chúa Hằng Hữu, Đức Chúa Trời ngươi. Trong ngày ấy, ngươi cũng như con trai, con gái, tôi trai, tớ gái, bò, lừa và súc vật khác, luôn cả khách ngoại kiều trong nhà ngươi, đều không được làm việc gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Nên nhớ rằng, ngươi cũng đã làm đầy tớ trong nước Ai Cập, nhưng nhờ Chúa Hằng Hữu, Đức Chúa Trời ngươi ra tay giải thoát ngươi. Vậy, phải giữ ngày lễ cuối tuần (Sa-bát). ");
INSERT INTO vieovcb_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Phải hiếu kính cha mẹ, như Chúa Hằng Hữu Đức Chúa Trời dạy ngươi, để ngươi được sống lâu và thịnh vượng trong đất Chúa Hằng Hữu, Đức Chúa Trời ngươi cho ngươi. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Không được giết người. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Các ngươi không được ngoại tình. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Các ngươi không được trộm cắp. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Các ngươi không được làm chứng dối hại người lân cận mình. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Không được tham muốn vợ, nhà cửa, đất đai, tôi trai, tớ gái, bò, lừa, hoặc vật gì khác của người lân cận mình.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Đó là mệnh lệnh Chúa Hằng Hữu đã truyền cho anh em vang ra từ trong đám lửa trên núi có mây đen bao bọc. Rồi Ngài viết những điều ấy vào hai bảng đá, trao cho tôi. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Nhưng khi anh em nghe tiếng vang ra từ trong bóng đen dày đặc, và trên đỉnh núi lại có lửa cháy dữ dội, các trưởng tộc và trưởng lão đều đến tìm tôi. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Họ nói: ‘Hôm nay chúng tôi đã thấy vinh quang và sự vĩ đại của Chúa Hằng Hữu, Đức Chúa Trời chúng ta, đã nghe tiếng Ngài phát ra từ trong đám lửa. Hôm nay chúng tôi thấy có người được nghe tiếng phán của Đức Chúa Trời mà vẫn còn sống. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Nhưng nếu chúng tôi cứ tiếp tục nghe tiếng phán của Chúa Hằng Hữu, Đức Chúa Trời chúng ta, chúng tôi sẽ chết. Đám lửa kia sẽ thiêu hủy chúng tôi. Tại sao chúng tôi phải chết? ");
INSERT INTO vieovcb_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Có ai là người trần như chúng tôi, đã nghe tiếng phán của Đức Chúa Trời Hằng Sống phát ra từ trong đám lửa, mà vẫn còn sống hay không? ");
INSERT INTO vieovcb_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Vậy, xin ông đi nghe những gì Chúa Hằng Hữu, Đức Chúa Trời chúng ta, dạy và truyền lại cho chúng tôi, chúng tôi xin vâng theo tất cả.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Nghe những lời họ nói, Chúa Hằng Hữu phán cùng tôi: ‘Ta nghe những điều họ trình bày với con rồi. Họ nói phải. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Nếu họ có lòng như vậy, hãy kính sợ Ta và vâng giữ các điều răn Ta, tương lai họ và con cháu họ sẽ rất tốt đẹp. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Bây giờ con bảo họ về trại đi. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Còn con hãy ở đây với Ta, Ta sẽ truyền cho con mọi điều răn, luật lệ, và chỉ thị; và con sẽ dạy lại họ, để họ đem ra áp dụng trong đất mà Ta ban cho.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Vậy Môi-se nói với dân chúng: “Anh em phải thận trọng thi hành mọi điều Chúa Hằng Hữu, Đức Chúa Trời của anh em truyền dạy, không sai lệch. ");
INSERT INTO vieovcb_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Cứ theo đúng đường lối Chúa Hằng Hữu, Đức Chúa Trời của anh em dạy, anh em sẽ được sống lâu, thịnh vượng, may mắn trong lãnh thổ anh em sắp chiếm cứ.” ");
INSERT INTO vieovcb_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“Chúa Hằng Hữu, Đức Chúa Trời của anh em, bảo tôi dạy anh em các luật lệ sẽ được áp dụng trong lãnh thổ chúng ta sẽ chiếm cứ. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Nếu anh em, con cháu anh em suốt đời kính sợ Chúa Hằng Hữu, Đức Chúa Trời của anh em, tuyệt đối tuân hành luật lệ Ngài, thì anh em sẽ được sống lâu. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Vậy, xin anh em lắng tai nghe kỹ các luật lệ Ngài và thận trọng tuân hành. Nhờ đó, anh em sẽ được thịnh vượng, may mắn, dân số gia tăng nhanh chóng trong vùng đất phì nhiêu, đúng như Chúa Hằng Hữu, Đức Chúa Trời của tổ tiên đã hứa. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Xin anh em lắng nghe đây: Chỉ có một mình Chúa Hằng Hữu là Đức Chúa Trời chúng ta mà thôi. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Phải hết lòng, hết linh hồn, hết sức yêu kính Chúa Hằng Hữu, Đức Chúa Trời của anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Phải ghi lòng tạc dạ những lời tôi truyền cho anh em hôm nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Cũng phải ân cần dạy dỗ những lời này cho con cái mình khi ở nhà, lúc ra ngoài, khi đi ngủ, lúc thức dậy. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Buộc những lời ấy vào tay mình, đeo trên trán mình, ");
INSERT INTO vieovcb_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ghi những lời ấy trên cột nhà và trước cổng. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Khi Đức Chúa Trời Hằng Hữu, Đức Chúa Trời của anh em đem anh em vào đất Ngài đã hứa với tổ tiên Áp-ra-ham, Y-sác, và Gia-cốp, cho anh em những thành to lớn tốt đẹp không do anh em kiến thiết, ");
INSERT INTO vieovcb_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","những ngôi nhà đầy những vật dụng không do anh em mua sắm. Những giếng nước không do anh em đào, vườn nho, vườn ô-liu không do anh em trồng. Khi ăn uống no nê, ");
INSERT INTO vieovcb_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","anh em phải thận trọng, đừng quên Chúa Hằng Hữu, Đấng đã giải thoát anh em khỏi ách nô lệ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Phải kính trọng Chúa Hằng Hữu, Đức Chúa Trời của anh em, và phục vụ Ngài. Khi anh em thề nguyện phải lấy Danh Ngài mà thề nguyện. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Không được theo các thần của các nước láng giềng, ");
INSERT INTO vieovcb_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","vì Chúa Hằng Hữu, Đức Chúa Trời của anh em ở giữa anh em là Đức Chúa Trời kỵ tà. Nếu anh em thờ các thần đó, Chúa sẽ nổi giận, trừ diệt anh em khỏi mặt đất. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Không được thử thách Chúa Hằng Hữu, Đức Chúa Trời của anh em, như anh em đã làm ở Ma-sa. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Phải tuyệt đối tuân hành các điều răn, luật lệ của Chúa Hằng Hữu, Đức Chúa Trời của anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Làm những điều phải, điều tốt dưới mắt Chúa Hằng Hữu; như vậy anh em mới được may mắn, vào chiếm được đất Chúa đã hứa cho tổ tiên chúng ta, ");
INSERT INTO vieovcb_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","và đánh đuổi quân thù trước mặt như Chúa đã phán. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Sau này, khi con cái anh em thắc mắc: ‘Ý nghĩa của điều răn, luật lệ của Chúa Hằng Hữu, Đức Chúa Trời chúng ta, phải tuân theo là gì?’ ");
INSERT INTO vieovcb_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Anh em sẽ giải thích như sau: ‘Ngày xưa, chúng ta là nô lệ của Pha-ra-ôn ở Ai Cập, nhưng Chúa Hằng Hữu đã ra tay giải thoát chúng ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Chúa Hằng Hữu dùng nhiều phép lạ phi thường, những đòn khủng khiếp trừng phạt Ai Cập, Pha-ra-ôn và hoàng gia, ngay trước mắt dân chúng ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Ngài đem dân ta ra khỏi Ai Cập, và cho chúng ta đất này như Ngài đã hứa với tổ tiên ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Chính Chúa Hằng Hữu, Đức Chúa Trời của anh em đã ban bố những luật lệ này để chúng ta triệt để tuân hành, và kính sợ Ngài, và nhờ thế, chúng ta mới được Ngài cho tồn tại đến ngày hôm nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Nếu cứ cẩn trọng tuân hành mọi luật lệ Chúa Hằng Hữu, Đức Chúa Trời của chúng ta đã truyền, chúng ta sẽ được kể là người công chính.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“Khi Chúa Hằng Hữu dẫn anh em vào đất hứa, Ngài sẽ đuổi các dân tộc sau đây: Hê-tít, Ghi-rê-ga, A-mô-rít, Ca-na-an, Phê-rết, Hê-vi, và Giê-bu. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Họ là dân của những nước lớn mạnh hơn chúng ta, nhưng Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ cho Ít-ra-ên đánh bại các dân ấy. Anh em phải tận diệt họ không thương xót, không ký hòa ước gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Cũng không được kết sui gia với họ, đừng gả con gái mình cho con trai họ, hoặc cưới con gái họ cho con trai mình, ");
INSERT INTO vieovcb_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","vì họ sẽ dụ con cái anh em thờ các thần của họ mà bỏ Chúa Hằng Hữu. Và nếu thế, Ngài sẽ nổi giận, tiêu diệt anh em tức khắc. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Anh em phải đập phá bàn thờ, nghiền nát trụ thờ, triệt hạ các tượng của A-sê-ra, cắt trụi những lùm cây, đốt sạch các tượng chạm của họ. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Vì anh em là một dân thánh của Chúa Hằng Hữu, Đức Chúa Trời của anh em; Ngài đã chọn anh em trong tất cả các dân tộc trên hoàn cầu làm dân tộc đặc biệt của Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Không phải Chúa Hằng Hữu chọn lựa và thương yêu anh em vì dân số đông. Không, so với những dân tộc khác, dân số anh em ít nhất. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Nhưng chỉ vì Chúa Hằng Hữu thương yêu anh em, và Ngài muốn giữ lời hứa với tổ tiên chúng ta. Đó là lý do Ngài đã giải thoát Ít-ra-ên khỏi ách nô lệ của Pha-ra-ôn, vua Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Vậy, phải ý thức rằng Chúa Hằng Hữu là Đức Chúa Trời duy nhất, Đức Chúa Trời thành tín. Ngài tôn trọng giao ước, và thương xót cả nghìn thế hệ những người kính yêu Ngài, tôn trọng điều răn Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Nhưng Ngài sẽ tiêu diệt không nới tay những ai ghét bỏ Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Vậy, anh em phải thận trọng, tuân hành mọi điều răn, luật lệ tôi truyền lại cho anh em hôm nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Nếu anh em tôn trọng pháp luật, Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ thương yêu anh em và thi hành giao ước Ngài đã kết với các tổ tiên. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ngài sẽ yêu quý, ban phước lành cho anh em, gia tăng dân số Ít-ra-ên. Ngài sẽ ban phước cho con cháu anh em, cho mùa màng, ngũ cốc, rượu, và dầu. Bầy gia súc sẽ được gia tăng trong lãnh thổ Ngài sắp cho anh em, theo lời Ngài hứa với tổ tiên. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Ít-ra-ên sẽ được phước hơn mọi dân tộc khác. Trong dân, sẽ không có ai son sẻ, và cho đến gia súc cũng vậy. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Chúa Hằng Hữu sẽ cho anh em không mắc bệnh tật, các bệnh hiểm nghèo anh em đã thấy tại Ai Cập sẽ không ảnh hưởng gì đến anh em, nhưng Ngài dành những bệnh ấy cho ai thù ghét anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Về phần anh em, phải diệt các dân tộc Chúa Hằng Hữu, Đức Chúa Trời của anh em đặt dưới tay anh em, không thương xót. Cũng không được thờ các thần của họ, vì đây là một cái bẫy. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Nếu anh em thắc mắc: ‘Các dân tộc ấy đông hơn dân ta, làm sao diệt họ được?’ ");
INSERT INTO vieovcb_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Đừng sợ, cứ nhớ lại những việc Chúa đã làm cho Pha-ra-ôn và Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Anh em đã chứng kiến những cuộc thử thách kinh hồn, những phép lạ, quyền lực uy dũng của Chúa Hằng Hữu, Đức Chúa Trời khi Ngài ra tay giải thoát anh em ra khỏi Ai Cập. Ngài cũng sẽ trừng trị các dân tộc anh em đang sợ như thế. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Hơn nữa, Chúa Hằng Hữu, Đức Chúa Trời của anh em cũng sẽ sai ong vò vẽ làm cho những người trốn tránh phải lộ mặt ra cho anh em diệt sạch. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Đừng sợ các dân ấy, vì Chúa Hằng Hữu là Đức Chúa Trời vĩ đại uy nghiêm ở giữa anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Chúa Hằng Hữu, Đức Chúa Trời của anh em sẽ diệt dần dần các dân tộc ấy. Không phải ngay tức khắc; nếu không, thú dữ sẽ gia tăng và đe dọa anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Dù sao, Chúa Hằng Hữu, Đức Chúa Trời của anh em cũng sẽ tiêu diệt họ hoàn toàn. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Ngài sẽ giao vua các nước ấy cho anh em, và anh em sẽ xóa tên họ khỏi mặt đất. Không một ai cưỡng nổi anh em, tất cả đều bị tiêu diệt. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Anh em phải thiêu các tượng thần họ đi. Đừng thấy các tượng ấy làm bằng vàng, bằng bạc mà ham muốn rồi giữ lại. Nếu giữ lại, các tượng ấy sẽ như bẫy cài chờ đón anh em, vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, ghê tởm các thần tượng. ");
INSERT INTO vieovcb_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Không ai được đem một vật ghê tởm vào nhà để hứng lấy họa tiêu diệt. Anh em phải tuyệt nhiên ghê tởm tượng thần, vì tượng thần là những vật bị nguyền rủa.” ");
INSERT INTO vieovcb_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“Anh em phải tôn trọng các luật lệ tôi truyền lại hôm nay để được sống còn, dân số gia tăng và vào chiếm lấy đất Chúa Hằng Hữu hứa cho các tổ tiên. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Nên nhớ rằng trong suốt cuộc hành trình bốn mươi năm nay, Chúa Hằng Hữu, Đức Chúa Trời của anh em dẫn anh em qua nhiều hoang mạc mênh mông, để làm cho anh em khổ nhục, để thử thách anh em, dò tận tâm khảm xem anh em có vâng lời Ngài hay không. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ngài làm cho anh em khổ nhục bằng cách để cho anh em đói, rồi cho ăn ma-na, một thức ăn anh em và các tổ tiên chưa hề biết. Ngài muốn dạy anh em rằng người ta sống không chỉ nhờ bánh, nhưng còn nhờ lời của Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Suốt bốn mươi năm, áo quần anh em không sờn rách, chân không sưng, không dộp. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Vậy, phải nhận thức điều này: Chúa dạy dỗ anh em như cha dạy con. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Vậy anh em hãy thuận phục pháp luật của Ngài, đi theo đường Ngài và kính sợ Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, đang dẫn anh em vào một vùng đất tốt tươi, với những suối nước, nguồn sông tuôn chảy trên các đồi, các thung lũng. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Một vùng đất mọc đầy lúa mì, lúa mạch, nho, vả, thạch lựu, ô-liu, và mật ong. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Một nơi có mật ong, thực phẩm dư dật, người người ăn uống no nê, không thiếu thốn gì cả. Đất chứa đầy quặng sắt, và mỏ đồng tìm thấy trên các vùng đồi. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Anh em sẽ ăn no nê và chúc tụng Chúa Hằng Hữu là Đức Chúa Trời, vì Ngài cho mình vùng đất tốt lành. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Nhưng phải luôn thận trọng! Đừng quên Chúa Hằng Hữu, Đức Chúa Trời của anh em, đừng bất tuân luật pháp Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Đừng để khi ăn uống no đầy, nhà cao cửa rộng, ");
INSERT INTO vieovcb_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","gia súc đầy đàn, vàng bạc, tài sản gia tăng ");
INSERT INTO vieovcb_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","mà sinh ra kiêu căng, quên Chúa Hằng Hữu, Đức Chúa Trời của anh em, Đấng đã giải thoát anh em ra khỏi ách nô lệ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Đừng quên Ngài đã dẫn anh em đi xuyên hoang mạc kinh khiếp, mênh mông, đầy rắn rết và bò cạp. Khi không nước uống, Ngài đã cho anh em nước chảy ra từ vầng đá! ");
INSERT INTO vieovcb_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ngài cho ma-na làm lương thực, thứ lương thực trước kia chưa ai biết đến. Ngài muốn dạy dỗ, thử thách anh em, trước khi cho hưởng điều tốt lành. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Vậy, phải cẩn thận, đừng thầm nghĩ: ‘Nhờ trí khôn và sức mạnh của ta, ta đã tạo dựng cơ nghiệp này.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Nhưng phải tưởng nhớ Chúa Hằng Hữu, Đức Chúa Trời của anh em, Đấng đã cho anh em trí khôn, sức mạnh để tạo dựng cơ đồ, Ngài làm điều này để thực hiện lời hứa với tổ tiên ta. ");
INSERT INTO vieovcb_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Tuy nhiên, nếu anh em quên Chúa Hằng Hữu, Đức Chúa Trời của anh em, chạy theo thờ cúng các thần khác, tôi xin cảnh cáo rằng nhất định anh em sẽ bị diệt vong, ");
INSERT INTO vieovcb_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","cũng như các quốc gia mà Chúa Hằng Hữu tiêu diệt để dành chỗ cho anh em, vì anh em không vâng lời Chúa Hằng Hữu, Đức Chúa Trời của anh em.” ");
INSERT INTO vieovcb_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“Xin anh em chú ý! Đã đến ngày anh em vượt Sông Giô-đan, sang chiếm đóng những nước lớn và mạnh hơn chúng ta. Đó là những nước có những thành lũy kiên cố, cao ngất, ");
INSERT INTO vieovcb_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","có những giống dân khổng lồ là con cháu của A-na-kim, nổi tiếng vô địch. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Tuy nhiên, Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ đi trước anh em. Như một ngọn lửa thiêu hủy, Ngài sẽ trấn áp, tiêu diệt họ, để anh em chinh phục và đuổi họ đi nhanh chóng như Chúa Hằng Hữu đã hứa. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Sau khi Chúa Hằng Hữu, Đức Chúa Trời của anh em, đuổi họ đi rồi, anh em đừng nghĩ rằng: ‘Chúa Hằng Hữu đem chúng ta vào chiếm đất này vì chúng ta là người công chính.’ Không, chính vì các dân tộc kia quái ác nên Ngài đuổi họ đi đó thôi. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Không phải vì sự công chính của anh em, mà vì sự gian ác của các dân ấy, nên Ngài đuổi họ ra, cho anh em chiếm đất họ, và cũng vì lời Ngài hứa với các tổ tiên Áp-ra-ham, Y-sác, và Gia-cốp. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Đúng thế, không phải Chúa Hằng Hữu, Đức Chúa Trời của anh em, cho anh em vùng đất tốt tươi vì anh em là người công chính. Không, anh em chỉ là những người ương ngạnh.” ");
INSERT INTO vieovcb_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“Anh em còn nhớ—đừng bao giờ quên điều này—anh em đã cả gan khiêu khích Chúa Hằng Hữu, Đức Chúa Trời của anh em, trong hoang mạc. Từ ngày ra khỏi Ai Cập cho đến nay, anh em vẫn thường nổi loạn chống Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Lúc ở Núi Hô-rếp, khi anh em khiêu khích Chúa Hằng Hữu quá độ, anh em suýt bị Ngài tiêu diệt. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Đó là lúc tôi lên núi để nhận hai bảng đá, là giao ước Chúa Hằng Hữu đã lập với anh em. Tôi ở lại trên núi bốn mươi ngày đêm, không ăn không uống. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Chúa Hằng Hữu trao cho tôi hai bảng đá, trên đó chính Đức Chúa Trời dùng ngón tay viết những lời Ngài đã nói với toàn thể anh em từ trong đám lửa trên núi, vào ngày hội hôm đó. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Cuối thời gian bốn mươi ngày đêm ấy. Chúa Hằng Hữu đã trao cho tôi hai bảng đá, đó là giao ước vừa kết lập. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Chúa Hằng Hữu phán bảo tôi: ‘Con xuống núi nhanh lên, vì đoàn dân con đem từ Ai Cập đến đây đã trở nên đồi bại rồi, họ đã vội vàng từ bỏ chính đạo Ta truyền cho, đúc cho mình một tượng thần.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Chúa Hằng Hữu cũng phán với tôi: ‘Ta đã rõ dân này, họ thật là ương ngạnh. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Để Ta diệt họ, xóa tên họ dưới trời, rồi làm cho con thành ra một dân mạnh hơn, đông hơn họ.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Tôi vội xuống núi với hai bảng đá trên tay. Lúc ấy lửa vẫn cháy rực trên núi. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Cảnh anh em quây quần quanh tượng bò con vừa đúc đập vào mắt tôi. Anh em thật đã phạm tội nặng nề cùng Chúa Hằng Hữu, Đức Chúa Trời của anh em, đã vội từ bỏ chính đạo Chúa Hằng Hữu vừa truyền cho! ");
INSERT INTO vieovcb_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Thấy thế, tôi ném hai bảng đá vỡ tan trước mắt mọi người. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Rồi, trong bốn mươi ngày đêm, tôi sấp mình xuống trước Chúa Hằng Hữu, không ăn không uống, vì tội anh em. Anh em đã làm điều Chúa Hằng Hữu ghê tởm để chọc giận Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Tôi chỉ sợ cơn thịnh nộ của Chúa Hằng Hữu nổi dậy tiêu diệt anh em. Nhưng Ngài lại nghe lời cầu xin của tôi lần đó nữa. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Riêng phần A-rôn, vì ông đã làm cho Chúa Hằng Hữu giận quá nên sắp bị giết. Tôi cầu thay cho và ông cũng được tha. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Tôi lấy vật tội lỗi, tức là tượng bò con anh em đã làm, đem đốt và nghiền ra thật nhỏ như bụi, bỏ vào khe nước từ trên núi chảy xuống. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Anh em lại còn khiêu khích Chúa Hằng Hữu tại Tha-bê-ra, tại Ma-sa, và tại Kíp-rốt Ha-tha-va. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Tại Ca-đê Ba-nê-a, khi Chúa Hằng Hữu phán bảo anh em vào chiếm đất hứa, anh em cãi lệnh Chúa Hằng Hữu, Đức Chúa Trời của anh em vì không tin Ngài. Anh em không chịu vâng lời Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Từ ngày tôi biết anh em đến nay, anh em vẫn thường xuyên nổi loạn chống Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Vậy, tôi sấp mình xuống trước Chúa Hằng Hữu suốt bốn mươi ngày đêm, vì lúc ấy Ngài sắp tiêu diệt anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Tôi thưa: ‘Lạy Chúa Hằng Hữu, xin đừng tiêu diệt dân này, là dân thuộc về Chúa. Chúa đã chuộc họ, đem họ ra khỏi Ai Cập bằng một quyền lực cao cả, một sức mạnh phi thường. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Xin Chúa nhớ các đầy tớ Ngài là Áp-ra-ham, Y-sác, và Gia-cốp, và quên đi sự bướng bỉnh, tội lỗi xấu xa của dân này. ");
INSERT INTO vieovcb_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Nếu không, người Ai Cập sẽ nói: “Vì Chúa Hằng Hữu không thể nào đem họ vào đất hứa, và cũng vì Ngài ghét họ, nên mới đem họ vào hoang mạc để giết đi.” ");
INSERT INTO vieovcb_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Họ là dân Ngài, thuộc về Chúa, là dân được Chúa giải thoát khỏi Ai Cập bằng quyền lực cao cả, bằng sức mạnh phi thường của Chúa.’ ” ");
INSERT INTO vieovcb_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“Lúc ấy, Chúa Hằng Hữu phán bảo tôi: ‘Hãy đục hai bảng đá như hai bảng trước, và làm một cái hòm đựng bằng gỗ, rồi lên núi gặp Ta, ");
INSERT INTO vieovcb_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Ta sẽ chép vào hai bảng này những điều đã được viết trên hai bảng cũ, rồi đặt hai bảng này vào Hòm Giao Ước.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Vâng lời Chúa, tôi đóng một cái hòm bằng gỗ keo, đục lại hai bảng đá như hai bảng cũ, rồi cầm hai bảng đá lên núi. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Chúa Hằng Hữu lại viết Mười Điều Răn (những điều này đã được Ngài công bố trên núi, từ trong đám lửa trước toàn thể chúng dân hôm ấy) vào hai bảng đá rồi trao cho tôi. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Tôi quay xuống núi, đặt hai bảng đá vào Hòm Giao Ước đóng sẵn, nay vẫn còn đó, đúng như lời Chúa Hằng Hữu phán dạy tôi. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(Sau đó, người Ít-ra-ên lại ra đi, từ Bê-rốt Bê-nê-gia-can đến Mô-sê-rốt. Tại đây, A-rôn qua đời và được an táng. Con A-rôn là Ê-lê-a-sa thay thế chức vụ tế lễ của cha mình. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Từ đó, toàn dân đi đến Gút-gô-đa, và từ Gút-gô-đa đến Dốt-ba-tha, là nơi có nhiều suối nước. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Lúc ấy, Chúa bắt đầu biệt riêng người Lê-vi vào việc khiêng Hòm Giao Ước của Chúa Hằng Hữu, đứng trước mặt Chúa Hằng Hữu để phục vụ Ngài, và để nhân danh Ngài chúc phước, như họ đang làm ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Vì thế, đại tộc Lê-vi không hưởng một phần đất nào như các đại tộc khác, vì họ có Chúa Hằng Hữu, Đức Chúa Trời của anh em, làm cơ nghiệp, như lời Ngài đã dạy.) ");
INSERT INTO vieovcb_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Trong dịp lên núi lần sau, tôi cũng ở lại bốn mươi ngày đêm như lần trước, và Chúa Hằng Hữu nghe lời cầu khẩn của tôi, không tuyệt diệt anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Chúa Hằng Hữu phán cùng tôi: ‘Hãy đứng lên và đi trước toàn dân, cho đến khi họ tới vùng đất Ta hứa với tổ tiên họ.’” ");
INSERT INTO vieovcb_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“Anh em ơi, điều Chúa Hằng Hữu là Đức Chúa Trời đòi hỏi anh em là phải kính sợ Chúa, bước đi trong mọi đường lối Ngài, hết lòng, hết linh hồn yêu mến, phụng sự Chúa Hằng Hữu, Đức Chúa Trời của anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Tuân hành tất cả điều răn và luật lệ của Ngài. Những điều luật tôi truyền lại cho anh em hôm nay là vì lợi ích của chính anh em đó. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Tất cả vũ trụ trời đất đều thuộc về Chúa Hằng Hữu, Đức Chúa Trời của anh em ");
INSERT INTO vieovcb_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Thế mà Ngài đem lòng yêu thương tổ tiên anh em, và nhân đó, chọn anh em trong muôn dân, như anh em thấy ngày nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Vậy, hãy tẩy sạch lòng mình đi. Đừng ngoan cố nữa. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Chúa Hằng Hữu, Đức Chúa Trời của anh em, là Thần của các thần, Chúa của các chúa, là Đức Chúa Trời vĩ đại, có quyền lực uy nghi đáng sợ. Ngài không thiên vị, không nhận hối lộ. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ngài thực thi công lý cho người mồ côi, góa bụa. Ngài yêu thương ngoại kiều, cho họ thức ăn áo mặc. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Anh em cũng phải thương người tha hương ngoại kiều, vì chính anh em đã từng kiều ngụ ở Ai Cập trước kia. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Phải kính sợ Chúa Hằng Hữu, Đức Chúa Trời của anh em, phụng sự Ngài, khắng khít với Ngài, và chỉ thề nguyện bằng Danh Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ngài là Đối Tượng tôn vinh ca ngợi, là Đức Chúa Trời của anh em. Ngài đã làm những việc vĩ đại phi thường, chính mắt anh em đã chứng kiến. ");
INSERT INTO vieovcb_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Ngày tổ tiên ta xuống Ai Cập, gia đình chỉ có vỏn vẹn bảy mươi người. Thế mà ngày nay, Chúa đã làm cho anh em đông như sao trên trời!” ");
INSERT INTO vieovcb_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“Anh em phải kính yêu Chúa Hằng Hữu, Đức Chúa Trời của anh em, tuân hành mọi điều răn, luật lệ, và chỉ thị của Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Hôm nay tôi không nói với con cái anh em, vì chúng nó chưa biết, chưa thấy sự vĩ đại, quyền lực siêu nhiên của Chúa, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","không thấy những phép lạ Ngài làm ở Ai Cập để trừng phạt Pha-ra-ôn và toàn lãnh thổ vua này, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","những việc Ngài làm cho quân đội, kỵ binh, và chiến xa Ai Cập khi họ đuổi theo Ít-ra-ên, Ngài xua nước Biển Đỏ vùi lấp, tiêu diệt họ. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Những việc Ngài làm cho anh em, từ lúc còn đi trong hoang mạc cho đến khi vào tận nơi này, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","việc Ngài làm cho Đa-than và A-bi-ram (con Ê-li-áp, cháu Ru-bên) khi họ đang ở giữa toàn dân, đất đã nứt ra nuốt sống họ cùng với mọi người trong gia đình họ, lều trại và súc vật của họ. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Những việc phi thường Chúa Hằng Hữu làm đó, anh em đã chứng kiến tận mắt rồi!” ");
INSERT INTO vieovcb_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","“Vì thế, anh em phải vâng giữ mọi mệnh lệnh của Ngài mà tôi truyền lại hôm nay, để có đủ sức đi chiếm đất bên kia sông, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","và được sống lâu dài trên đất phì nhiêu tốt đẹp mà Chúa Hằng Hữu hứa cho các tổ tiên, và cho anh em là hàng con cháu. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Vì đất anh em sẽ chiếm cứ không giống như đất Ai Cập, nơi anh em sống trước kia. Ở Ai Cập, khi gieo giống, người ta phải đạp nước và săn sóc như chăm bón vườn rau vậy. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Trái lại, đất anh em sắp hưởng gồm những đồi cao và thung lũng, là xứ có nhiều mưa, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","là nơi được Chúa Hằng Hữu, Đức Chúa Trời của anh em, chăm sóc, trông nom quanh năm suốt tháng. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Và, nếu anh em hết lòng, hết linh hồn tuân theo mọi mệnh lệnh của Chúa Hằng Hữu, Đức Chúa Trời của anh em mà tôi truyền lại cho anh em hôm nay, hết lòng yêu mến và phụng sự Ngài, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","thì Ngài sẽ cho mưa thuận gió hòa, và anh em sẽ thu hoạch ngũ cốc, rượu, dầu đầy vựa lẫm. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Ngài cũng làm cho đồng cỏ tốt tươi để nuôi bầy gia súc của anh em. Như vậy, anh em sẽ thật no đủ. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Nhưng phải thận trọng, không được thay lòng đổi dạ, bỏ Chúa Hằng Hữu, đi phụng sự và thờ các thần khác. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Nếu thế, cơn thịnh nộ của Ngài sẽ nổi lên, Ngài sẽ đóng trời lại, trời sẽ không mưa, đất không sản xuất, và anh em sẽ chết đi nhanh chóng trên đất lành Ngài vừa cho. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Vậy, phải ghi những mệnh lệnh này vào lòng dạ, khắc vào thẻ bài đeo nơi tay làm dấu và đeo lên trán làm hiệu. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Đem những mệnh lệnh này dạy cho con cái mình am tường. Luôn luôn nhắc nhở đến những mệnh lệnh này, dù lúc ngồi trong nhà, lúc đi đường, khi ngủ cũng như khi thức. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Ghi những mệnh lệnh ấy lên cửa và trên cổng nhà, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","như vậy, ngày nào đất còn ở dưới trời thì anh em và con cháu mình sẽ được trường thọ, vui hưởng xứ tốt đẹp Chúa Hằng Hữu hứa cho. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Nếu anh em thận trọng tuân hành các mệnh lệnh này, kính yêu Chúa Hằng Hữu, Đức Chúa Trời của anh em, đi theo đường lối Ngài, khắng khít với Ngài, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","thì Ngài sẽ đuổi hết dân các nước kia đi, cho anh em chiếm hữu lãnh thổ của những quốc gia lớn và mạnh hơn Ít-ra-ên. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Nơi nào anh em đặt chân đến sẽ thuộc về anh em, biên giới của lãnh thổ Ít-ra-ên sẽ chạy từ hoang mạc cho đến Li-ban, từ Sông Ơ-phơ-rát cho đến bờ tây Địa Trung Hải. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Không ai chống nổi anh em, vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, gieo rắc sự khủng khiếp, hãi hùng vào lòng dân ở tất cả những vùng đất anh em đặt chân đến, như Ngài đã hứa. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Hôm nay, tôi để anh em chọn lựa giữa phước lành và nguyền rủa: ");
INSERT INTO vieovcb_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Nếu anh em tuân lệnh Chúa Hằng Hữu, thi hành luật lệ tôi truyền hôm nay, thì anh em sẽ hưởng phước lành. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Nhưng nếu anh em không tuân lệnh Chúa Hằng Hữu, Đức Chúa Trời của anh em, lại đi phụng thờ các thần lạ, thì anh em sẽ bị nguyền rủa. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Khi Chúa Hằng Hữu, Đức Chúa Trời của anh em, đem anh em vào chiếm cứ đất hứa, anh em sẽ đặt lời chúc phước lành trên Núi Ga-ri-xim, và lời nguyền rủa trên Núi Ê-banh. ");
INSERT INTO vieovcb_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","(Hai núi này ở bên kia Sông Giô-đan, về phía tây của con đường cái, nơi có người Ca-na-an ở, trong đồng bằng đối diện Ghinh-ganh, gần rặng cây sồi của Mô-rê.) ");
INSERT INTO vieovcb_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Anh em sắp qua Sông Giô-đan, lập nghiệp trong đất mà Chúa Hằng Hữu, Đức Chúa Trời của anh em, hứa ban. Khi anh em vào đất hứa và sống tại đó, ");
INSERT INTO vieovcb_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","anh em phải luôn luôn nhớ tuân hành mọi điều răn, luật lệ tôi truyền hôm nay.” ");
INSERT INTO vieovcb_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“Đây là các luật lệ, mệnh lệnh áp dụng vĩnh viễn trong lãnh thổ Chúa Hằng Hữu, Đức Chúa Trời của các tổ tiên, cho anh em chiếm hữu: ");
INSERT INTO vieovcb_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Phải phá hủy tất cả nơi thờ cúng của các dân bản xứ đang sống trong lãnh thổ anh em sắp chiếm hữu, dù là trên núi cao, trên các đồi hay dưới cây xanh. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Phải đập phá các bàn thờ, nghiền nát các tượng thờ, thiêu hủy các trụ thờ A-sê-ra, đốt sạch các lùm cây, hạ các tượng thần chạm trổ tỉ mỉ. Như vậy, danh tính của các thần ấy bị xóa bỏ khỏi các nơi đó. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Không được thờ phượng Chúa Hằng Hữu, Đức Chúa Trời của anh em, theo cách các dân khác thờ cúng thần của họ. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Nhưng anh em phải đến nơi duy nhất Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ chọn trong lãnh thổ của các đại tộc, là nơi ngự của Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Phải đến dâng các lễ thiêu, các sinh tế, một phần mười hiến dâng, lễ vật dâng theo lối nâng tay dâng lên, lễ vật thề nguyện, lễ vật tình nguyện, chiên, và bò sinh đầu lòng. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Tại đó, mọi người sẽ cùng gia quyến mình ăn trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, lòng hân hoan vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, cho công việc mình được ban phước và thịnh vượng. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Anh em không được hành động như ngày nay nữa, ai nấy đều làm những việc mình cho là phải, ");
INSERT INTO vieovcb_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","vì anh em chưa vào vui hưởng sản nghiệp mà Chúa Hằng Hữu, Đức Chúa Trời của anh em, sắp ban cho. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Khi đã sang Sông Giô-đan, vào sống trong đất Chúa Hằng Hữu, Đức Chúa Trời của anh em cho, được nghỉ ngơi, được an ninh vì không còn tranh chiến với quân thù nữa, ");
INSERT INTO vieovcb_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","anh em phải đến nơi Chúa Hằng Hữu, Đức Chúa Trời của anh em, và nơi Chúa Hằng Hữu, Đức Chúa Trời của anh em, chọn cho Danh Ngài, để dâng các tế lễ thiêu, các sinh tế, một phần mười, lễ vật nâng tay dâng lên, và lễ vật thề nguyện. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Vợ chồng, con cái, đầy tớ, mọi người sẽ hân hoan trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, cả người Lê-vi ở chung trong thành với anh em sẽ cùng dự, vì họ sẽ không có một phần đất riêng như các đại tộc khác. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Vậy, anh em sẽ không được dâng tế lễ thiêu tại bất cứ nơi nào khác. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Nhưng chỉ dâng tại nơi Chúa Hằng Hữu chọn. Nơi này sẽ ở trong lãnh thổ của một đại tộc. Chính tại nơi ấy anh em sẽ làm theo mọi điều tôi sắp truyền đây. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Tuy nhiên, đối với thú vật làm thịt để ăn, anh em có thể giết bất cứ nơi nào như anh em giết hươu, giết linh dương ngày nay vậy. Anh em có thể ăn thịt tùy thích, vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, cho anh em không thiếu gì. Cả người không tinh sạch cũng được phép ăn. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Nhưng phải nhớ không được ăn máu. Phải đổ máu xuống đất như đổ nước vậy. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Còn đối với các lễ vật đem dâng lên, anh em không được ăn ở nhà, dù đó là một phần mười của ngũ cốc, rượu, dầu, hay chiên, bò sinh đầu lòng, hay lễ vật thề nguyện, tình nguyện, hay bất cứ một lễ vật nào khác. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Anh em chỉ được ăn các lễ vật này trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, tại nơi Ngài sẽ chọn, chung với con cái, đầy tớ mình và người Lê-vi ở trong thành. Mọi người đều hân hoan trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, vì kết quả của công việc mình. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Nhớ, không được bỏ quên người Lê-vi. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Khi Chúa Hằng Hữu, Đức Chúa Trời của anh em, mở mang bờ cõi lãnh thổ Ít-ra-ên như Ngài đã hứa, anh em sẽ tha hồ ăn thịt theo sở thích. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Và nếu nơi Chúa Hằng Hữu, Đức Chúa Trời của anh em chọn để đặt Danh Ngài ở xa quá, anh em được phép giết bò, chiên mà Chúa Hằng Hữu ban cho anh em như tôi đã dặn để ăn trong các thành mình bao nhiêu tùy ý anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Cũng như ngày nay anh em giết hươu, giết linh dương để ăn thịt. Người không tinh sạch cũng được phép ăn. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Tuy nhiên, tuyệt đối không được ăn máu, vì máu là sự sống của sinh vật, và không ai được ăn sự sống của sinh vật chung với thịt của nó. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Phải đổ máu xuống đất như đổ nước vậy, đừng ăn. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Kiêng cữ máu là một điều chính đáng dưới mắt Chúa, và nhờ vậy anh em và con cháu mình sẽ được may mắn. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Riêng các sinh vật đem dâng lên cũng như các lễ vật thề nguyện và sinh lễ thiêu, phải đem đến địa điểm mà Chúa Hằng Hữu đã chọn. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Máu của các sinh vật này sẽ được đổ trên bàn thờ của Chúa Hằng Hữu, Đức Chúa Trời của anh em, còn thịt thì anh em được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Phải thận trọng thi hành mọi điều tôi truyền cho anh em đây. Nếu anh em hành động chính đáng dưới mắt Chúa Hằng Hữu, anh em và con cháu mình sẽ được thịnh vượng mãi mãi. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Khi Chúa Hằng Hữu, Đức Chúa Trời của anh em, đã diệt các dân tộc kia, cho anh em chiếm đất rồi, ");
INSERT INTO vieovcb_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","phải coi chừng, không được bắt chước các dân tộc ấy. Đừng hỏi: ‘Các dân này thờ thần như thế nào?’ để rồi làm theo họ. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Không được thờ Chúa Hằng Hữu, Đức Chúa Trời của anh em, như cách các dân tộc ấy thờ thần của họ, vì họ làm tất cả những điều Chúa Hằng Hữu ghê tởm, như thiêu sống con trai con gái mình để tế thần. ");
INSERT INTO vieovcb_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Phải thận trọng tuân giữ các điều này đúng như tôi truyền lại, không được thêm bớt gì cả.” ");
INSERT INTO vieovcb_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“Nếu trong dân chúng có người đứng ra nói tiên tri hay có người nằm mơ đoán mộng, báo trước một điềm lạ, ");
INSERT INTO vieovcb_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","và nếu khi điềm ứng rồi, người này nói: ‘Đi thờ các thần này,’ là những thần anh em chưa biết, ");
INSERT INTO vieovcb_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","thì anh em không được nghe lời người ấy, vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, muốn thử xem anh em có yêu kính Ngài hết lòng không. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Anh em chỉ được thờ Chúa Hằng Hữu, Đức Chúa Trời của anh em, mà thôi; luôn luôn kính sợ, vâng lời, khắng khít với Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Còn người tiên tri, người nằm mơ đoán mộng kia phải bị xử tử, vì đã dạy bảo anh em bỏ Chúa Hằng Hữu, Đấng đã giải thoát anh em khỏi ách nô lệ Ai Cập. Vậy, anh em phải diệt trừ người ác trong dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Nếu có một người thân, dù là anh em ruột, con trai, con gái, vợ yêu quý hay bạn chí thân, thầm dụ anh em đi thờ thần lạ, ");
INSERT INTO vieovcb_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","thần của các nước lân bang hay của các nước xa xôi, ");
INSERT INTO vieovcb_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","anh em không được nghe lời người ấy, cũng không được thương tình che chở. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Phải giết đi! Phải ra tay ném đá người ấy trước tiên, rồi dân chúng sẽ tiếp tay sau. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Phải lấy đá ném vào người ấy cho chết đi, vì tội toan ly gián anh em với Chúa Hằng Hữu, Đức Chúa Trời của anh em, đã giải thoát anh em khỏi ách nô lệ Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Như thế, khi ai nấy trong nước nghe tin này đều phải khiếp sợ, không dám phạm tội ác này nữa. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Nếu có tin đồn về một thành trong các thành mà Chúa Hằng Hữu Đức Chúa Trời ban cho anh em, ");
INSERT INTO vieovcb_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","có những người gian ác, dụ dỗ dân trong thành đi thờ thần lạ, ");
INSERT INTO vieovcb_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","anh em phải điều tra thật kỹ lưỡng. Nếu đúng là cả thành đều phạm tội kinh khủng ấy, ");
INSERT INTO vieovcb_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","thì phải dùng gươm tuyệt diệt dân trong thành, luôn cả thú vật của họ. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Xong rồi, phải thu góp tất cả đồ đạc của họ chất giữa phố chợ, đốt đi. Đồng thời cũng phóng hỏa toàn thành, tất cả sẽ như một lễ thiêu cho Chúa Hằng Hữu, Đức Chúa Trời của anh em. Thành này sẽ vĩnh viễn là một đống tro tàn, không ai được phép xây cất lại. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Không ai được lấy một vật gì trong thành ấy, như thế Ngài mới thương tình, làm ơn cho anh em được gia tăng dân số, như Ngài đã hứa với các tổ tiên. ");
INSERT INTO vieovcb_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Vì anh em đã vâng lời Chúa Hằng Hữu, Đức Chúa Trời của anh em, tuân hành mọi luật lệ tôi truyền hôm nay, làm điều phải dưới mắt Ngài.” ");
INSERT INTO vieovcb_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","“Anh em là con dân của Chúa Hằng Hữu, Đức Chúa Trời của anh em, nên không được cắt da thịt mình hay cạo tóc phía trên trán trong dịp tang chế. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Vì người Ít-ra-ên đã là dân thánh cho Chúa Hằng Hữu, Đức Chúa Trời của anh em, và Ngài đã chọn Ít-ra-ên trong toàn thể các dân tộc trên toàn cầu cho mình. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Không được ăn thịt thú vật ô uế. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Chỉ được ăn các loại thú vật sau đây: Bò, chiên, dê, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","nai, linh dương, hươu, dê rừng, bò rừng, sơn dương, và chiên núi. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Anh em được ăn thịt con vật nào có móng chẻ đôi và nhai lại, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","tuy nhiên, không được ăn thịt lạc đà, thỏ rừng, chồn núi, vì các loại này nhai lại nhưng không có móng chẻ đôi. Vậy các loại này cũng không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Con heo tuy có móng chẻ đôi nhưng không nhai lại, nên anh em không được ăn thịt nó, cũng đừng đụng đến xác chết của loài này. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Trong các sinh vật sống dưới nước, anh em chỉ được ăn loài nào có vi và có vảy. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Loài nào không vi và không vảy là không sạch, không được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Anh em được ăn các loài chim sạch. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Trừ ra phượng hoàng, kên kên, ó biển, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","chim diều, các loại chim ưng, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","các loại quạ, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","đà điểu, ó đêm, hải âu, các loại diều, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","các loại chim cú mèo, cò lửa, chim hạc, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","bồ nông, kên kên, còng cọc, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","các loại cò, chim diệc, chim rẽ quạt, và dơi. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Ngoài ra, anh em cũng không được ăn các loại côn trùng có cánh vì không sạch. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Nhưng các loài chim có cánh sạch khác thì được ăn. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Đừng ăn một sinh vật chết tự nhiên, vì anh em đã hiến dâng mình cho Chúa Hằng Hữu, Đức Chúa Trời của anh em. Tuy nhiên, anh em có thể đem con vật ấy bán hoặc cho người ngoại kiều. Đừng nấu thịt dê con chung với sữa của mẹ nó.” ");
INSERT INTO vieovcb_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“Phải nhớ dâng một phần mười mùa màng thu hoạch hằng năm. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Tại nơi Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ chọn đặt Danh Ngài, anh em sẽ ăn phần mười mình đem dâng trước mặt Ngài. Đó là lễ vật phần mười của ngũ cốc, rượu, dầu, và các con sinh đầu lòng trong bầy gia súc. Đây là cách anh em học kính sợ Chúa Hằng Hữu, Đức Chúa Trời của anh em, suốt đời. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Nếu nơi Chúa Hằng Hữu, Đức Chúa Trời của anh em, đặt Danh Ngài xa quá, không tiện đem theo lễ vật một phần mười, ");
INSERT INTO vieovcb_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","anh em có thể đem bán các lễ vật ấy, rồi lấy tiền đem lên nơi Đức Chúa Trời đã chọn. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Đến nơi, anh em sẽ dùng tiền ấy mua bò, chiên, rượu nho, rượu mạnh, tùy sở thích, rồi ăn uống hân hoan trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, cùng với cả gia đình mình. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Tuy nhiên, đừng quên người Lê-vi, nhớ mời họ dự chung với mình, vì họ không có đất đai mùa màng như anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Cuối mỗi ba năm, tại mỗi địa phương, anh em phải đem một phần mười mùa màng thu được năm ấy vào thành, góp chung lại. ");
INSERT INTO vieovcb_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Những người Lê-vi (vì không có tài sản), người ngoại kiều, mồ côi, quả phụ sống trong địa phương này sẽ đến, ăn uống thỏa mãn. Như vậy, anh em sẽ được Chúa Hằng Hữu, Đức Chúa Trời của anh em, ban phước lành, mọi việc mình làm sẽ được thịnh vượng.” ");
INSERT INTO vieovcb_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“Cuối mỗi bảy năm là thời kỳ giải trừ nợ nần. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Các chủ nợ sẽ hủy bỏ mọi món nợ đã cho anh em mình vay mượn, không được đòi nữa, vì thời kỳ giải nợ được công bố theo lệnh Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Việc giải nợ này chỉ áp dụng giữa người Ít-ra-ên với nhau, không áp dụng cho ngoại kiều. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","Tuy nhiên, sẽ không có một người Ít-ra-ên nào nghèo khổ, vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ ban phước cho anh em trong vùng đất mà Ngài sẽ ban cho anh em, ");
INSERT INTO vieovcb_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","nếu anh em vâng lời Chúa Hằng Hữu, Đức Chúa Trời của mình, tuân hành các luật lệ tôi truyền hôm nay. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ ban phước lành dồi dào cho anh em trong đất hứa như Ngài đã nói. Ít-ra-ên sẽ cho các nước khác vay chứ không cần vay mượn ai, sẽ cai trị các nước khác chứ không phải bị trị. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Khi anh em đến đất mà Chúa Hằng Hữu, Đức Chúa Trời ban cho anh em, nếu trong lãnh thổ Ít-ra-ên có người nghèo, thì anh em không được keo kiệt nhưng phải rộng lòng, ");
INSERT INTO vieovcb_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","cho họ mượn rộng rãi để họ thỏa mãn mọi nhu cầu. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Phải cảnh giác, đừng để tư tưởng đê tiện xúi giục mình nghĩ rằng thời kỳ giải nợ sắp đến, rồi lờ anh em mình đi, không cho mượn gì cả. Nếu người nghèo kêu đến Chúa, anh em phải chịu tội. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Phải sẵn lòng cho mượn, đừng vừa cho vừa thầm tiếc, như thế mới được Chúa Hằng Hữu, Đức Chúa Trời của mình, ban phước lành, và mọi công việc của anh em mới được thịnh vượng. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Thế nào trong nước cũng có người nghèo nên tôi mới bảo anh em phải rộng lòng cho mượn.” ");
INSERT INTO vieovcb_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","“Nếu anh em mua một người Hê-bơ-rơ khác, dù đàn ông hay đàn bà, làm nô lệ, đến năm thứ bảy, người ấy phải được phóng thích. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Nhưng không được để người ấy ra đi với hai bàn tay trắng. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Khi người ấy ra đi phải cho người ấy gia súc, dầu, rượu dồi dào; phải chia sẻ cho người ấy một phần hoa màu mà Chúa Hằng Hữu, Đức Chúa Trời của anh em, đã cho anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Phải nhớ rằng anh em đã làm nô lệ trong nước Ai Cập, và đã được Chúa Hằng Hữu, Đức Chúa Trời của anh em, giải cứu. Vì vậy tôi mới truyền cho anh em lệnh này. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Trong trường hợp người nô lệ không muốn đi vì có lòng mến gia đình chủ, vì không khí hòa thuận, ");
INSERT INTO vieovcb_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","anh em là chủ, phải lấy một cái dùi, kê tai người ấy vào cửa mà xỏ, và như thế người ấy sẽ làm nô lệ trọn đời. Thể thức này cũng áp dụng cho nữ nô lệ. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Trường hợp người nô lệ ra đi, đừng buồn tiếc. Vì trong sáu năm người ấy phục dịch, anh em chỉ tốn chừng phân nửa số tiền dùng để mướn một người làm công. Và như vậy, Chúa Hằng Hữu, Đức Chúa Trời của anh em, còn ban phước lành cho mọi công việc của anh em nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","“Trong bầy gia súc, phải dành riêng các con đực đầu lòng ra cho Chúa Hằng Hữu, Đức Chúa Trời của anh em. Đừng bắt bò đực đầu lòng làm việc, cũng đừng cắt lông chiên đực đầu lòng. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Nhưng anh em và gia đình mình sẽ ăn thịt các con vật ấy hằng năm trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, tại nơi Ngài chọn. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Nếu con vật đầu lòng này bị què, mù, hoặc có tật nguyền gì khác, thì không được dâng nó cho Chúa Hằng Hữu, Đức Chúa Trời của anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Nhưng để nó ở nhà làm thịt mà ăn, cả người không tinh sạch cũng được ăn, như trường hợp người ta ăn thịt nai, thịt linh dương vậy. ");
INSERT INTO vieovcb_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Tuy nhiên, phải nhớ không được ăn máu, phải đổ máu xuống đất như đổ nước.” ");
INSERT INTO vieovcb_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","“Phải cử hành lễ Vượt Qua trong tháng A-bíp, vì chính vào tháng này, Chúa Hằng Hữu, Đức Chúa Trời của anh em, đã đem anh em ra khỏi Ai Cập trong ban đêm. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Bắt bò hoặc chiên đem dâng lên Chúa Hằng Hữu, Đức Chúa Trời của anh em, trong lễ này tại nơi Ngài sẽ chọn đặt Danh Ngài. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Anh em sẽ ăn bánh không men với thịt bò hoặc chiên trong bảy ngày. Ăn bánh không men sẽ nhắc nhở anh em luôn luôn nhớ đến bánh ăn lúc ra khỏi Ai Cập một cách vội vàng. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Không ai được giữ men trong nhà suốt bảy ngày này, và phải ăn hết thịt của sinh tế Vượt Qua trong ngày thứ nhất, không được để qua đêm. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Không được dâng sinh tế Vượt Qua tại bất kỳ nơi nào mà Chúa Hằng Hữu, Đức Chúa Trời ban cho anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","Nhưng phải dâng tại nơi Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ chọn đặt Danh Ngài, vào lúc đêm xuống, vào giờ anh em ra khỏi Ai Cập. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Anh em sẽ nấu thịt con sinh tế để ăn tại nơi Chúa Hằng Hữu, Đức Chúa Trời, và đến sáng hôm sau anh em có thể trở về nhà. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Nhưng trong sáu ngày kế tiếp, phải ăn bánh không men. Đến ngày thứ bảy, sẽ có một cuộc hội họp long trọng trước mặt Chúa Hằng Hữu, Đức Chúa Trời của anh em, và không ai được làm việc trong ngày ấy.” ");
INSERT INTO vieovcb_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","“Tính bảy tuần kể từ ngày bắt đầu mùa gặt, ");
INSERT INTO vieovcb_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","anh em sẽ mừng Lễ Các Tuần trước Chúa Hằng Hữu, Đức Chúa Trời của anh em. Lễ vật đem dâng trong dịp này là lễ vật tình nguyện, dâng nhiều ít tùy theo mùa màng Chúa cho. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Anh em sẽ cùng gia đình, đầy tớ hân hoan trước Chúa Hằng Hữu, Đức Chúa Trời của anh em, tại nơi Ngài sẽ chọn đặt Danh Ngài. Đừng quên người Lê-vi, ngoại kiều, người mồ côi, quả phụ trong địa phương mình. Nhớ mời họ chung dự. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Đừng quên rằng anh em đã từng làm nô lệ tại Ai Cập, vậy phải triệt để tuân hành lệnh này.” ");
INSERT INTO vieovcb_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","“Sau ngày lúa đã đập, nho đã ép xong, anh em sẽ ăn mừng Lễ Lều Tạm trong bảy ngày. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Anh em cùng với cả gia đình, đầy tớ mình, và người Lê-vi, ngoại kiều, người mồ côi, quả phụ trong địa phương mình hân hoan dự lễ. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Lễ này sẽ kéo dài bảy ngày tại nơi Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ chọn đặt Danh Ngài, mọi người cùng nhau vui mừng vì Chúa Hằng Hữu, Đức Chúa Trời của anh em, ban phước lành, cho được mùa và cho mọi công việc anh em làm đều thịnh vượng. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Vậy, mỗi năm ba lần, tất cả nam giới sẽ ra mắt Chúa Hằng Hữu tại nơi Ngài chọn vào dịp Lễ Bánh Không Men, Lễ Các Tuần, và Lễ Lều Tạm. Họ sẽ đem lễ vật đến dâng lên Chúa Hằng Hữu. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Mỗi người sẽ dâng tùy theo khả năng, tương xứng với số lượng lợi tức Chúa Hằng Hữu, Đức Chúa Trời của anh em, cho họ.” ");
INSERT INTO vieovcb_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","“Trong các thành Chúa Hằng Hữu, Đức Chúa Trời của anh em, sẽ cho các đại tộc Ít-ra-ên, anh em sẽ bổ nhiệm các phán quan, các chức quyền hành chánh để điều hành công lý trong dân chúng. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Không được bóp méo công lý. Không được thiên vị. Không được ăn hối lộ, vì của hối lộ làm mờ mắt người khôn, do đó lý lẽ của người ngay có thể bị bác bỏ. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Phải tuyệt đối tôn trọng công lý, đó là bí quyết sinh tồn trong đất hứa mà Chúa Hằng Hữu, Đức Chúa Trời của anh em ban cho.” ");
INSERT INTO vieovcb_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","“Không được dựng tượng thần bằng gỗ để thờ thần A-sê-ra bên cạnh bàn thờ của Chúa Hằng Hữu, Đức Chúa Trời của anh em. ");
INSERT INTO vieovcb_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Cũng không được lập một trụ thờ nào ở đó, vì đó là điều ghê tởm đối với Chúa Hằng Hữu, Đức Chúa Trời của anh em.” ");
INSERT INTO vieovcb_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","“Không được dâng lên Chúa Hằng Hữu, Đức Chúa Trời của anh em, một con bò hay một con chiên tật nguyền, vì đó là một điều ghê tởm đối với Chúa. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Nếu có ai trong lãnh thổ Ít-ra-ên vi phạm giao ước của Chúa Hằng Hữu, Đức Chúa Trời của anh em, ");
INSERT INTO vieovcb_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","phạm các trọng tội như thờ phụng các thần khác, thờ mặt trời, mặt trăng, hay ngôi sao, những điều này tôi đã nghiêm cấm. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","Anh em phải thận trọng điều tra khi nghe được tin này, và nếu thấy đúng như thế, ");
INSERT INTO vieovcb_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","thì phải điệu tội nhân, dù đàn ông hay đàn bà, ra ngoài cổng thành, lấy đá ném cho chết đi. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Tuy nhiên, ít nhất phải có hai hoặc ba nhân chứng buộc tội mới có thể xử tử phạm nhân. Chỉ một nhân chứng thì không đủ. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Các nhân chứng phải lấy đá ném vào phạm nhân trước tiên, rồi dân chúng sẽ tiếp tay. Như vậy, anh em diệt trừ người gian ác trong dân. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Nếu gặp trường hợp khó xử như liên hệ đến một vụ sát nhân, ngộ sát, một vụ kiện rắc rối, hoặc một vụ bạo hành khác, thì anh em phải đến địa điểm mà Chúa Hằng Hữu, Đức Chúa Trời của anh em sẽ chọn, ");
INSERT INTO vieovcb_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","tìm gặp các thầy tế lễ, người Lê-vi, hoặc vị phán quan đương nhiệm để trình bày nội vụ. Các vị ấy sẽ quyết định đường lối xét xử. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Anh em phải tuân hành bản án tại nơi mà Chúa Hằng Hữu chọn lựa, ");
INSERT INTO vieovcb_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","tuyệt đối vâng theo mọi chỉ thị đã nhận, không được thay đổi gì cả. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Kẻ nào ngạo mạn không vâng theo chỉ thị của phán quan và thầy tế lễ phục vụ Chúa Hằng Hữu, Đức Chúa Trời của anh em, thì phải bị xử tử. Như vậy, người ác trong Ít-ra-ên sẽ bị diệt trừ. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Dân chúng thấy vậy mà sợ, không còn dám ngạo mạn nữa.” ");
INSERT INTO vieovcb_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“Khi an cư lạc nghiệp trong đất Chúa Hằng Hữu, Đức Chúa Trời của anh em ban cho rồi, nếu anh em nghĩ đến việc lập một vị vua lên trị nước, vì thấy các nước láng giềng đều có vua, ");
INSERT INTO vieovcb_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","anh em nên nhớ lập người được Chúa Hằng Hữu, Đức Chúa Trời của anh em, chọn lựa. Người này đương nhiên sẽ là người Ít-ra-ên chứ không phải người ngoại quốc. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Vua Ít-ra-ên không được chuyên lo gây dựng cho mình một đàn ngựa đông đảo, vì nếu vậy thì sẽ đưa dân mình trở lại làm nô lệ cho Ai Cập một lần nữa. Anh em đừng quên lời Chúa Hằng Hữu đã phán: ‘Các ngươi sẽ không trở lại Ai Cập nữa.’ ");
INSERT INTO vieovcb_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Vua cũng không được tuyển nhiều cung phi để lòng bị quyến dụ, cũng không được gom góp cho mình nhiều vàng bạc. ");
INSERT INTO vieovcb_vpl VALUES ("DT17_1