﻿USE sofia;
DROP TABLE IF EXISTS sofia.vie1934_vpl;
CREATE TABLE vie1934_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES vie1934_vpl WRITE;
INSERT INTO vie1934_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ban đầu Đức Chúa Trời dựng nên trời đất. ");
INSERT INTO vie1934_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Vả, đất là vô hình và trống không, sự mờ tối ở trên mặt vực; Thần Đức Chúa Trời vận hành trên mặt nước. ");
INSERT INTO vie1934_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Đức Chúa Trời phán rằng: Phải có sự sáng; thì có sự sáng. ");
INSERT INTO vie1934_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Đức Chúa Trời thấy sáng là tốt lành, bèn phân sáng ra cùng tối. ");
INSERT INTO vie1934_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Đức Chúa Trời đặt tên sự sáng là ngày; sự tối là đêm. Vậy, có buổi chiều và buổi mai; ấy là ngày thứ nhất. ");
INSERT INTO vie1934_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Đức Chúa Trời lại phán rằng: Phải có một khoảng không ở giữa nước đặng phân rẽ nước cách với nước. ");
INSERT INTO vie1934_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ngài làm nên khoảng không, phân rẽ nước ở dưới khoảng không cách với nước ở trên khoảng không; thì có như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Đức Chúa Trời đặt tên khoảng không là trời. Vậy, có buổi chiều và buổi mai; ấy là ngày thứ nhì. ");
INSERT INTO vie1934_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Đức Chúa Trời lại phán rằng: Những nước ở dưới trời phải tụ lại một nơi, và phải có chỗ khô cạn bày ra; thì có như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Đức Chúa Trời đặt tên chỗ khô cạn là đất, còn nơi nước tụ lại là biển. Đức Chúa Trời thấy điều đó là tốt lành. ");
INSERT INTO vie1934_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Đức Chúa Trời lại phán rằng: Đất phải sanh cây cỏ; cỏ kết hột giống, cây trái kết quả, tùy theo loại mà có hột giống trong mình trên đất; thì có như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Đất sanh cây cỏ: cỏ kết hột tùy theo loại, cây kết quả có hột trong mình, tùy theo loại. Đức Chúa Trời thấy điều đó là tốt lành. ");
INSERT INTO vie1934_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Vậy, có buổi chiều và buổi mai; ấy là ngày thứ ba. ");
INSERT INTO vie1934_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Đức Chúa Trời lại phán rằng: Phải có các vì sáng trong khoảng không trên trời, đặng phân ra ngày với đêm, và dùng làm dấu để định thì tiết, ngày và năm; ");
INSERT INTO vie1934_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","lại dùng làm vì sáng trong khoảng không trên trời để soi xuống đất; thì có như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Đức Chúa Trời làm nên hai vì sáng lớn; vì lớn hơn để cai trị ban ngày, vì nhỏ hơn để cai trị ban đêm; Ngài cũng làm các ngôi sao. ");
INSERT INTO vie1934_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Đức Chúa Trời đặt các vì đó trong khoảng không trên trời, đặng soi sáng đất, ");
INSERT INTO vie1934_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","đặng cai trị ban ngày và ban đêm, đặng phân ra sự sáng với sự tối. Đức Chúa Trời thấy điều đó là tốt lành. ");
INSERT INTO vie1934_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Vậy, có buổi chiều và buổi mai; ấy là ngày thứ tư. ");
INSERT INTO vie1934_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Đức Chúa Trời lại phán rằng: Nước phải sanh các vật sống cho nhiều, và các loài chim phải bay trên mặt đất trong khoảng không trên trời. ");
INSERT INTO vie1934_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Đức Chúa Trời dựng nên các loài cá lớn, các vật sống hay động nhờ nước mà sanh nhiều ra, tùy theo loại, và các loài chim hay bay, tùy theo loại. Đức Chúa Trời thấy điều đó là tốt lành. ");
INSERT INTO vie1934_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Đức Chúa Trời ban phước cho các loài đó mà phán rằng: Hãy sanh sản, thêm nhiều, làm cho đầy dẫy dưới biển; còn các loài chim hãy sanh sản trên đất cho nhiều. ");
INSERT INTO vie1934_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Vậy, có buổi chiều và buổi mai; ấy là ngày thứ năm. ");
INSERT INTO vie1934_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Đức Chúa Trời lại phán rằng: Đất phải sanh các vật sống tùy theo loại, tức súc vật, côn trùng, và thú rừng, đều tùy theo loại; thì có như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Đức Chúa Trời làm nên các loài thú rừng tùy theo loại, súc vật tùy theo loại, và các côn trùng trên đất tùy theo loại, Đức Chúa Trời thấy điều đó là tốt lành. ");
INSERT INTO vie1934_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Đức Chúa Trời phán rằng: Chúng ta hãy làm nên loài người như hình ta và theo tượng ta, đặng quản trị loài cá biển, loài chim trời, loài súc vật, loài côn trùng bò trên mặt đất, và khắp cả đất. ");
INSERT INTO vie1934_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Đức Chúa Trời dựng nên loài người như hình Ngài; Ngài dựng nên loài người giống như hình Đức Chúa Trời; Ngài dựng nên người nam cùng người nữ. ");
INSERT INTO vie1934_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Đức Chúa Trời ban phước cho loài người và phán rằng: Hãy sanh sản, thêm nhiều, làm cho đầy dẫy đất; hãy làm cho đất phục tùng, hãy quản trị loài cá dưới biển, loài chim trên trời cùng các vật sống hành động trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Đức Chúa Trời lại phán rằng: Nầy, ta sẽ ban cho các ngươi mọi thứ cỏ kết hột mọc khắp mặt đất, và các loài cây sanh quả có hột giống; ấy sẽ là đồ ăn cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Còn các loài thú ngoài đồng, các loài chim trên trời, và các động vật khác trên mặt đất, phàm giống nào có sự sống thì ta ban cho mọi thứ cỏ xanh đặng dùng làm đồ ăn; thì có như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Đức Chúa Trời thấy các việc Ngài đã làm thật rất tốt lành. Vậy, có buổi chiều và buổi mai; ấy là ngày thứ sáu. ");
INSERT INTO vie1934_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Aáy vậy, trời đất và muôn vật đã dựng nên xong rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ngày thứ bảy, Đức Chúa Trời làm xong các công việc Ngài đã làm, và ngày thứ bảy, Ngài nghỉ các công việc Ngài đã làm. ");
INSERT INTO vie1934_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Rồi, Ngài ban phước cho ngày thứ bảy, đặt là ngày thánh; vì trong ngày đó, Ngài nghỉ các công việc đã dựng nên và đã làm xong rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Aáy là gốc tích trời và đất khi đã dựng nên, trong lúc Giê-hô-va Đức Chúa Trời dựng nên trời và đất. ");
INSERT INTO vie1934_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Vả, lúc đó, chưa có một cây nhỏ nào mọc ngoài đồng, và cũng chưa có một ngọn cỏ nào mọc ngoài ruộng, vì Giê-hô-va Đức Chúa Trời chưa có cho mưa xuống trên đất, và cũng chẳng có một người nào cày cấy đất nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Song có hơi nước dưới đất bay lên tưới khắp cùng mặt đất, ");
INSERT INTO vie1934_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Giê-hô-va Đức Chúa Trời bèn lấy bụi đất nắn nên hình người, hà sanh khí vào lỗ mũi; thì người trở nên một loài sanh linh. ");
INSERT INTO vie1934_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Đoạn, Giê-hô-va Đức Chúa Trời lập một cảnh vườn tại Ê-đen, ở về hướng Đông, và đặt người mà Ngài vừa dựng nên ở đó. ");
INSERT INTO vie1934_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Giê-hô-va Đức Chúa Trời khiến đất mọc lên các thứ cây đẹp mắt, và trái thì ăn ngon; giữa vườn lại có cây sự sống cùng cây biết điều thiện và điều ác. ");
INSERT INTO vie1934_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Một con sông từ Ê-đen chảy ra đặng tưới vườn; rồi từ đó chia ra làm bốn ngả. ");
INSERT INTO vie1934_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Tên ngả thứ nhất là Bi-sôn; ngả đó chảy quanh xứ Ha-vi-la, là nơi có vàng. ");
INSERT INTO vie1934_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Vàng xứ nầy rất cao; đó lại có nhũ hương và bích ngọc. ");
INSERT INTO vie1934_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Tên sông thứ nhì là Ghi-hôn, chảy quanh xứ Cu-sơ. ");
INSERT INTO vie1934_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tên sông thứ ba là Hi-đê-ke, chảy về phía đông bờ cõi A-si-ri. Còn sông thứ tư là sông Ơ-phơ-rát. ");
INSERT INTO vie1934_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Giê-hô-va Đức Chúa Trời đem người ở vào cảnh vườn Ê-đen để trồng và giữ vườn. ");
INSERT INTO vie1934_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Rồi, Giê-hô-va Đức Chúa Trời phán dạy rằng: Ngươi được tự do ăn hoa quả các thứ cây trong vườn; ");
INSERT INTO vie1934_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","nhưng về cây biết điều thiện và điều ác thì chớ hề ăn đến; vì một mai ngươi ăn chắc sẽ chết. ");
INSERT INTO vie1934_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Giê-hô-va Đức Chúa Trời phán rằng: Loài người ở một mình thì không tốt; ta sẽ làm nên một kẻ giúp đỡ giống như nó. ");
INSERT INTO vie1934_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Giê-hô-va Đức Chúa Trời lấy đất nắn nên các loài thú đồng, các loài chim trời, rồi dẫn đến trước mặt A-đam đặng thử xem người đặt tên chúng nó làm sao, hầu cho tên nào A-đam đặt cho mỗi vật sống, đều thành tên riêng cho nó. ");
INSERT INTO vie1934_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","A-đam đặt tên các loài súc vật, các loài chim trời cùng các loài thú đồng; nhưng về phần A-đam, thì chẳng tìm được một ai giúp đỡ giống như mình hết. ");
INSERT INTO vie1934_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Giê-hô-va Đức Chúa Trời làm cho A-đam ngủ mê, bèn lấy một xương sườn, rồi lấp thịt thế vào. ");
INSERT INTO vie1934_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Giê-hô-va Đức Chúa Trời dùng xương sườn đã lấy nơi A-đam làm nên một người nữ, đưa đến cùng A-đam. ");
INSERT INTO vie1934_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","A-đam nói rằng: Người nầy là xương bởi xương tôi, thịt bởi thịt tôi mà ra. Người nầy sẽ được gọi là người nữ, vì nó do nơi người nam mà có. ");
INSERT INTO vie1934_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Bởi vậy cho nên người nam sẽ lìa cha mẹ mà dính díu cùng vợ mình, và cả hai sẽ trở nên một thịt. ");
INSERT INTO vie1934_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Vả, A-đam và vợ, cả hai đều trần truồng, mà chẳng hổ thẹn. ");
INSERT INTO vie1934_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Vả, trong các loài thú đồng mà Giê-hô-va Đức Chúa Trời đã làm nên, có con rắn là giống quỉ quyệt hơn hết. Rắn nói cùng người nữ rằng: Mà chi! Đức Chúa Trời há có phán dặn các ngươi không được phép ăn trái các cây trong vườn sao? ");
INSERT INTO vie1934_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Người nữ đáp rằng: Chúng ta được ăn trái các cây trong vườn, ");
INSERT INTO vie1934_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","song về phần trái của cây mọc giữa vườn, Đức Chúa Trời có phán rằng: Hai ngươi chẳng nên ăn đến và cũng chẳng nên đá-động đến, e khi hai ngươi phải chết chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Rắn bèn nói với người nữ rằng: Hai ngươi chẳng chết đâu; ");
INSERT INTO vie1934_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","nhưng Đức Chúa Trời biết rằng hễ ngày nào hai ngươi ăn trái cây đó, mắt mình mở ra, sẽ như Đức Chúa Trời, biết điều thiện và điều ác. ");
INSERT INTO vie1934_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Người nữ thấy trái của cây đó bộ ăn ngon, lại đẹp mắt và quí vì để mở trí khôn, bèn hái ăn, rồi trao cho chồng đứng gần mình, chồng cũng ăn nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Đoạn, mắt hai người đều mở ra, biết rằng mình lõa lồ, bèn lấy lá cây vả đóng khố che thân. ");
INSERT INTO vie1934_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lối chiều, nghe tiếng Giê-hô-va Đức Chúa Trời đi ngang qua vườn, A-đam và vợ ẩn mình giữa bụi cây, để tránh mặt Giê-hô-va Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Giê-hô-va Đức Chúa Trời kêu A-đam mà phán hỏi rằng: Ngươi ở đâu? ");
INSERT INTO vie1934_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","A-đam thưa rằng: Tôi có nghe tiếng Chúa trong vườn, bèn sợ, bởi vì tôi lõa lồ, nên đi ẩn mình. ");
INSERT INTO vie1934_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Đức Chúa Trời phán hỏi: Ai đã chỉ cho ngươi biết rằng mình lõa lồ? Ngươi có ăn trái cây ta đã dặn không nên ăn đó chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Thưa rằng: Người nữ mà Chúa đã để gần bên tôi cho tôi trái cây đó và tôi đã ăn rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Giê-hô-va Đức Chúa Trời phán hỏi người nữ rằng: Người có làm điều chi vậy? Người nữ thưa rằng: Con rắn dỗ dành tôi và tôi đã ăn rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Giê-hô-va Đức Chúa Trời bèn phán cùng rắn rằng: Vì mầy đã làm điều như vậy, mầy sẽ bị rủa sả trong vòng các loài súc vật, các loài thú đồng, mầy sẽ bò bằng bụng và ăn bụi đất trọn cả đời. ");
INSERT INTO vie1934_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ta sẽ làm cho mầy cùng người nữ, dòng dõi mầy cùng dòng dõi người nữ nghịch thù nhau. Người sẽ giày đạp đầu mầy, còn mầy sẽ cắn gót chân người. ");
INSERT INTO vie1934_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ngài phán cùng người nữ rằng: Ta sẽ thêm điều cực khổ bội phần trong cơn thai nghén; ngươi sẽ chịu đau đớn mỗi khi sanh con; sự dục vọng ngươi phải xu hướng về chồng, và chồng sẽ cai trị ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ngài lại phán cùng A-đam rằng: Vì ngươi nghe theo lời vợ mà ăn trái cây ta đã dặn không nên ăn, vậy, đất sẽ bị rủa sả vì ngươi; trọn đời ngươi phải chịu khó nhọc mới có vật đất sanh ra mà ăn. ");
INSERT INTO vie1934_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Đất sẽ sanh chông gai và cây tật lê, và ngươi sẽ ăn rau của đồng ruộng; ");
INSERT INTO vie1934_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ngươi sẽ làm đổ mồ hôi trán mới có mà ăn, cho đến ngày nào ngươi trở về đất, là nơi mà có ngươi ra; vì ngươi là bụi, ngươi sẽ trở về bụi. ");
INSERT INTO vie1934_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","A-đam gọi vợ là Ê-va, vì là mẹ của cả loài người. ");
INSERT INTO vie1934_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Giê-hô-va Đức Chúa Trời lấy da thú kết thành áo dài cho vợ chồng A-đam, và mặc lấy cho. ");
INSERT INTO vie1934_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Giê-hô-va Đức Chúa Trời phán rằng: Nầy, về sự phân biệt điều thiện và điều ác, loài người đã thành một bực như chúng ta; vậy bây giờ, ta hãy coi chừng, e loài người giơ tay lên cũng hái trái cây sự sống mà ăn và được sống đời đời chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Giê-hô-va Đức Chúa Trời bèn đuổi loài người ra khỏi vườn Ê-đen đặng cày cấy đất, là nơi có người ra. ");
INSERT INTO vie1934_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Vậy, Ngài đuổi loài người ra khỏi vườn, rồi đặt tại phía đông vườn Ê-đen các thần chê-ru-bin với gươm lưỡi chói lòa, để giữ con đường đi đến cây sự sống. ");
INSERT INTO vie1934_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","A-đam ăn ở với Ê-va, là vợ mình; người thọ thai sanh Ca-in và nói rằng: Nhờ Đức Giê-hô-va giúp đỡ, tôi mới sanh được một người. ");
INSERT INTO vie1934_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ê-va lại sanh em Ca-in, là A-bên; A-bên làm nghề chăn chiên, còn Ca-in thì nghề làm ruộng. ");
INSERT INTO vie1934_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Vả, cách ít lâu, Ca-in dùng thổ sản làm của lễ dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","A-bên cũng dâng chiên đầu lòng trong bầy mình cùng mỡ nó. Đức Giê-hô-va đoái xem A-bên và nhận lễ vật của người; ");
INSERT INTO vie1934_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","nhưng chẳng đoái đến Ca-in và cũng chẳng nhận lễ vật của người; cho nên Ca-in giận lắm mà gằm nét mặt. ");
INSERT INTO vie1934_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Đức Giê-hô-va phán hỏi Ca-in rằng: Cớ sao ngươi giận, và cớ sao nét mặt ngươi gằm xuống? ");
INSERT INTO vie1934_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nếu ngươi làm lành, há chẳng ngước mặt lên sao? Còn như chẳng làm lành, thì tội lỗi rình đợi trước cửa, thèm ngươi lắm; nhưng ngươi phải quản trị nó. ");
INSERT INTO vie1934_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ca-in thuật lại cùng A-bên là em mình. Vả, khi hai người đang ở ngoài đồng, thì Ca-in xông đến A-bên là em mình, và giết đi. ");
INSERT INTO vie1934_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Đức Giê-hô-va hỏi Ca-in rằng: A-bên, em ngươi, ở đâu? Thưa rằng: Tôi không biết; tôi là người giữ em tôi sao? ");
INSERT INTO vie1934_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Đức Giê-hô-va hỏi: Ngươi đã làm điều chi vậy? Tiếng của máu em ngươi từ dưới đất kêu thấu đến ta. ");
INSERT INTO vie1934_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Bây giờ, ngươi sẽ bị đất rủa sả, là đất đã hả miệng chịu hút máu của em ngươi bởi chính tay ngươi làm đổ ra. ");
INSERT INTO vie1934_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Khi ngươi trồng tỉa, đất chẳng sanh hoa lợi cho ngươi nữa; ngươi sẽ lưu lạc và trốn tránh, trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ca-in thưa cùng Đức Giê-hô-va rằng: Sự hình phạt tôi nặng quá mang không nổi. ");
INSERT INTO vie1934_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nầy, ngày nay, Chúa đã đuổi tôi ra khỏi đất nầy, tôi sẽ lánh mặt Chúa, sẽ đi lưu lạc trốn tránh trên đất; rồi, xảy có ai gặp tôi, họ sẽ giết đi. ");
INSERT INTO vie1934_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Đức Giê-hô-va phán rằng: Bởi cớ ấy, nếu ai giết Ca-in, thì sẽ bị báo thù bảy lần. Đức Giê-hô-va bèn đánh dấu trên mình Ca-in, hầu cho ai gặp Ca-in thì chẳng giết. ");
INSERT INTO vie1934_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ca-in bèn lui ra khỏi mặt Đức Giê-hô-va, và ở tại xứ Nốt, về phía đông của Ê-đen. ");
INSERT INTO vie1934_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Đoạn, Ca-in ăn ở cùng vợ mình, nàng thọ thai và sanh được Hê-nóc; Ca-in xây một cái thành đặt tên là Hê-nóc, tùy theo tên con trai mình. ");
INSERT INTO vie1934_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Rồi, Hê-nóc sanh Y-rát; Y-rát sanh Nê-hu-đa-ên; Nê-hu-đa-ên sanh Mê-tu-sa-ên; Mê-tu-sa-ên sanh Lê-méc. ");
INSERT INTO vie1934_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lê-méc cưới hai vợ; một người tên là A-đa, một người tên là Si-la. ");
INSERT INTO vie1934_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","A-đa sanh Gia-banh; Gia-banh là tổ phụ của các dân ở trại và nuôi bầy súc vật. ");
INSERT INTO vie1934_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Em người là Giu-banh, tổ phụ của những kẻ đánh đàn và thổi sáo. ");
INSERT INTO vie1934_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Còn Si-la cũng sanh Tu-banh-Ca-in là người rèn đủ thứ khí giới bén bằng đồng và bằng sắt. Em gái của Tu-banh-Ca-in là Na-a-ma. ");
INSERT INTO vie1934_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lê-méc bèn nói với hai vợ mình rằng: Hỡi A-đa và Si-la! hãy nghe tiếng ta; Nầy, vợ Lê-méc hãy lắng tai nghe lời ta: ã! Ta đã giết một người, vì làm thương ta, Và một người trẻ, vì đánh sưng bầm ta. ");
INSERT INTO vie1934_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Nếu Ca-in được bảy lần báo thù, Lê-méc sẽ được bảy mươi bảy lần báo oán. ");
INSERT INTO vie1934_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","A-đam còn ăn ở với vợ mình; người sanh được một con trai đặt tên là Sết; vì vợ rằng: Đức Chúa Trời đã cho tôi một con trai khác thế cho A-bên mà đã bị Ca-in giết rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sết cũng sanh được một con trai, đặt tên là Ê-nót. Từ đây, người ta bắt đầu cầu khẩn danh Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Đây là sách chép dòng dõi của A-đam. Ngày mà Đức Chúa Trời dựng nên loài người, thì Ngài làm nên loài người giống như Đức Chúa Trời; ");
INSERT INTO vie1934_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ngài dựng nên người nam cùng người nữ, ban phước cho họ, và trong ngày đã dựng nên, đặt tên là người. ");
INSERT INTO vie1934_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Vả, A-đam được một trăm ba mươi tuổi, sanh một con trai giống như hình tượng mình, đặt tên là Sết. ");
INSERT INTO vie1934_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sau khi A-đam sanh Sết rồi, còn sống được tám trăm năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Vậy, A-đam hưởng thọ được chín trăm ba mươi tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sết được một trăm năm tuổi, sanh Ê-nót. ");
INSERT INTO vie1934_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Sau khi Sết sanh Ê-nót rồi, còn sống được tám trăm bảy năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Vậy, Sết hưởng thọ được chín trăm mười hai tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ê-nót được chín mươi tuổi, sanh Kê-nan. ");
INSERT INTO vie1934_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Sau khi Ê-nót sanh Kê-nan rồi, còn sống được tám trăm mười lăm năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Vậy, Ê-nót hưởng thọ được chín trăm năm tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kê-nan được bảy mươi tuổi, sanh Ma-ha-la-le. ");
INSERT INTO vie1934_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Sau khi Kê-nan sanh Ma-ha-la-le rồi, còn sống được tám trăm bốn mươi năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Vậy, Kê-nan hưởng thọ được chín trăm mười tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ma-ha-la-le được sáu mươi lăm tuổi, sanh Giê-rệt. ");
INSERT INTO vie1934_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Sau khi Ma-ha-la-le sanh Giê-rệt, còn sống được tám trăm ba mươi năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Vậy, Ma-ha-la-le hưởng thọ được tám trăm chín mươi lăm tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Giê-rệt được một trăm sáu mươi hai tuổi, sanh Hê-nóc. ");
INSERT INTO vie1934_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Sau khi Giê-rệt sanh Hê-nóc rồi, còn sống được tám trăm năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Vậy, Giê-rệt hưởng thọ được chín trăm sáu mươi hai tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hê-nóc được sáu mươi lăm tuổi, sanh Mê-tu-sê-la. ");
INSERT INTO vie1934_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Sau khi Hê-nóc sanh Mê-tu-sê-la rồi, đồng đi cùng Đức Chúa Trời trong ba trăm năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Vậy Hê-nóc hưởng thọ được ban trăm sáu mươi lăm tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hê-nóc đồng đi cùng Đức Chúa Trời, rồi mất biệt, bởi vì Đức Chúa Trời tiếp người đi. ");
INSERT INTO vie1934_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mê-tu-sê-la được một trăm tám mươi bảy tuổi, sanh Lê-méc. ");
INSERT INTO vie1934_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Sau khi Mê-tu-sê-la sanh Lê-méc rồi, còn sống được bảy trăm tám mươi hai năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Vậy, Mê-tu-sê-la hưởng thọ được chín trăm sáu mươi chín tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lê-méc được một trăm tám mươi hai tuổi, sanh một trai, ");
INSERT INTO vie1934_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Đặt tên là Nô-ê, mà nói rằng: Đứa nầy sẽ an ủi lòng ta về công việc và về sự nhọc nhằn mà đất bắt tay ta phải làm, là đất Đức Giê-hô-va đã rủa sả. ");
INSERT INTO vie1934_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Sau khi Lê-méc sanh Nô-ê rồi, còn sống được năm trăm chín mươi lăm năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Vậy, Lê-méc hưởng thọ được bảy trăm bảy mươi bảy tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Còn Nô-ê, khi đến năm trăm tuổi, sanh Sem Cham và Gia-phết. ");
INSERT INTO vie1934_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Vả, khi loài người khởi thêm nhiều trên mặt đất, và khi loài người đã sanh được con gái rồi, ");
INSERT INTO vie1934_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","các con trai của Đức Chúa Trời thấy con gái loài người tốt đẹp, bèn cưới người nào vừa lòng mình mà làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Đức Giê-hô-va phán rằng: Thần ta sẽ chẳng hằng ở trong loài người luôn; trong điều lầm lạc, loài người chỉ là xác thịt; đời người sẽ là một trăm hai mươi năm mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Đời đó và đời sau, có người cao lớn trên mặt đất, vì con trai Đức Chúa Trời ăn ở cùng con gái loài người mà sanh con cái; ấy những người mạnh dạn ngày xưa là tay anh hùng có danh. ");
INSERT INTO vie1934_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Đức Giê-hô-va thấy sự hung ác của loài người trên mặt đất rất nhiều, và các ý tưởng của lòng họ chỉ là xấu luôn; ");
INSERT INTO vie1934_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","thì tự trách đã dựng nên loài người trên mặt đất, và buồn rầu trong lòng. ");
INSERT INTO vie1934_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Đức Giê-hô-va phán rằng: Ta sẽ hủy diệt khỏi mặt đất loài người mà ta đã dựng nên, từ loài người cho đến loài súc vật, loài côn trùng, loài chim trời; vì ta tự trách đã dựng nên các loài đó. ");
INSERT INTO vie1934_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nhưng Nô-ê được ơn trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nầy là dòng dõi của Nô-ê. Nô-ê trong đời mình là một người công bình và trọn vẹn, đồng đi cùng Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nô-ê sanh ba con trai là Sem, Cham và Gia-phết. ");
INSERT INTO vie1934_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Thế gian bấy giờ đều bại hoại trước mặt Đức Chúa Trời và đầy dẫy sự hung ác. ");
INSERT INTO vie1934_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nầy, Đức Chúa Trời nhìn xem thế gian, thấy điều bại hoại, vì hết thảy xác thịt làm cho đường mình trên đất phải bại hoại. ");
INSERT INTO vie1934_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Đức Chúa Trời bèn phán cùng Nô-ê rằng: Kỳ cuối cùng của mọi xác thịt đã đưa đến trước mặt ta; vì cớ loài người mà đất phải đầy dẫy điều hung hăng; vậy, ta sẽ diệt-trừ họ cùng đất. ");
INSERT INTO vie1934_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ngươi hãy đóng một chiếc tàu bằng cây gô-phe, đóng có từng phòng, rồi trét chai bề trong cùng bề ngoài. ");
INSERT INTO vie1934_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Vậy, hãy làm theo thế nầy: Bề dài tàu ba trăm thước, bề ngang năm mươi thước, bề cao ba mươi thước. ");
INSERT INTO vie1934_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Trên tàu ngươi sẽ làm một cửa sổ, bề cao một thước, và chừa một cửa bên hông; ngươi sẽ làm một từng dưới, một từng giữa và một từng trên. ");
INSERT INTO vie1934_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Còn ta đây, ta sẽ dẫn nước lụt khắp trên mặt đất, đặng diệt tuyệt các xác thịt có sanh khí ở dưới trời; hết thảy vật chi ở trên mặt đất đều sẽ chết hết. ");
INSERT INTO vie1934_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nhưng ta sẽ lập giao ước cùng ngươi, rồi ngươi và vợ, các con và các dâu của ngươi, đều hãy vào tàu. ");
INSERT INTO vie1934_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Về các loài sanh vật, ngươi hãy dẫn xuống tàu mỗi loài một cặp, có đực có cái, có trống có mái, hầu cho ở cùng ngươi đặng giữ tròn sự sống; ");
INSERT INTO vie1934_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","chim tùy theo loại, súc vật tùy theo loại, côn trùng tùy theo loại, mỗi thứ hai con, sẽ đến cùng ngươi, để ngươi giữ tròn sự sống cho. ");
INSERT INTO vie1934_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Lại, ngươi hãy lấy các thứ đồ ăn đem theo, đặng để dành làm lương thực cho ngươi và các loài đó. ");
INSERT INTO vie1934_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nô-ê làm các điều nầy y như lời Đức Chúa Trời đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Đức Giê-hô-va phán cùng Nô-ê rằng: Ngươi và cả nhà ngươi hãy vào tàu, vì về đời nầy ta thấy ngươi là công bình ở trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Trong các loài vật thanh sạch, hãy đem theo mỗi loài bảy cặp, đực và cái; còn loài vật không thanh sạch mỗi loài một cặp, đực và cái. ");
INSERT INTO vie1934_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Cũng hãy đem theo những chim trời, mỗi thứ bảy cặp, trống và mái, để giữ giống ở trên khắp mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Vì còn bảy ngày nữa, ta sẽ làm mưa xuống mặt đất, trong bốn mươi ngày và bốn mươi đêm; ta sẽ tuyệt diệt khỏi đất hết các loài của ta đã dựng nên. ");
INSERT INTO vie1934_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Đoạn, Nô-ê làm theo mọi điều Đức Giê-hô-va đã phán dặn mình. ");
INSERT INTO vie1934_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Vả, khi lụt xảy ra, và nước tràn trên mặt đất, thì Nô-ê đã được sáu trăm tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Vì cớ nước lụt, nên Nô-ê vào tàu cùng vợ, các con trai và các dâu mình; ");
INSERT INTO vie1934_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","loài vật thanh sạch và loài vật không thanh sạch, loài chim, loài côn trùng trên mặt đất, ");
INSERT INTO vie1934_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","từng cặp, đực và cái, trống và mái, đều đến cùng Nô-ê mà vào tàu, y như lời Đức Chúa Trời đã phán dặn người. ");
INSERT INTO vie1934_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Sau bảy ngày, nước lụt xảy có trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nhằm năm sáu trăm của đời Nô-ê, tháng hai, ngày mười bảy, chính ngày đó, các nguồn của vực lớn nổ ra, và các đập trên trời mở xuống; ");
INSERT INTO vie1934_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","mưa sa trên mặt đất trọn bốn mươi ngày và bốn mươi đêm. ");
INSERT INTO vie1934_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Lại cũng trong một ngày đó, Nô-ê với vợ, ba con trai: Sem, Cham và Gia-phết, cùng ba dâu mình đồng vào tàu. ");
INSERT INTO vie1934_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Họ và các loài, thú rừng tùy theo loại, súc vật tùy theo loại, côn trùng trên mặt đất tùy theo loài, chim tùy theo loại, và hết thảy vật nào có cánh, ");
INSERT INTO vie1934_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","đều từng cặp theo Nô-ê vào tàu; nghĩa là mọi xác thịt nào có sanh khí, ");
INSERT INTO vie1934_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","một đực một cái, một trống một mái, đều đến vào tàu, y như lời Đức Chúa Trời đã phán dặn; đoạn, Đức Giê-hô-va đóng cửa tàu lại. ");
INSERT INTO vie1934_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nước lụt phủ mặt đất bốn mươi ngày; nước dưng thêm nâng hỏng tàu lên khỏi mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Trên mặt đất nước lớn và dưng thêm nhiều lắm; chiếc tàu nổi trên mặt nước. ");
INSERT INTO vie1934_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nước càng dưng lên bội phần trên mặt đất, hết thảy những ngọn núi cao ở dưới trời đều bị ngập. ");
INSERT INTO vie1934_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Nước dưng lên mười lăm thước cao hơn, mấy ngọn núi đều ngập. ");
INSERT INTO vie1934_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Các xác thịt hành động trên mặt đất đều chết ngột, nào chim, nào súc vật, nào thú rừng, nào côn trùng, và mọi người. ");
INSERT INTO vie1934_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Các vật có sanh khí trong lỗ mũi, các vật ở trên đất liền đều chết hết. ");
INSERT INTO vie1934_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mọi loài ở trên mặt đất đều bị hủy diệt, từ loài người cho đến loài thú, loài côn trùng, cùng loài chim trời, chỉ còn Nô-ê và các loài ở với người trong tàu mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Nước dưng lên trên mặt đất trọn một trăm năm mươi ngày. ");
INSERT INTO vie1934_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Vả, Đức Chúa Trời nhớ lại Nô-ê cùng các loài thú và súc vật ở trong tàu với người, bèn khiến một trận gió thổi ngang qua trên đất, thì nước dừng lại. ");
INSERT INTO vie1934_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Các nguồn của vực lớn và các đập trên trời lấp ngăn lại; mưa trên trời không sa xuống nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nước giựt khỏi mặt đất, lần lần vừa hạ vừa giựt; trong một trăm năm mươi ngày nước mới bớt xuống. ");
INSERT INTO vie1934_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Đến tháng bảy, ngày mười bảy, chiếc tàu tấp trên núi A-ra-rát. ");
INSERT INTO vie1934_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nước cứ lần lần hạ cho đến tháng mười; ngày mồng một tháng đó, mấy đỉnh núi mới lộ ra. ");
INSERT INTO vie1934_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Được bốn mươi ngày, Nô-ê mở cửa sổ mình đã làm trên tàu, ");
INSERT INTO vie1934_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","thả một con quạ ra; quạ liệng đi liệng lại cho đến khi nước giựt khô trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Người cũng thả một con bò câu ra, đặng xem thử nước hạ bớt trên mặt đất chưa. ");
INSERT INTO vie1934_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Nhưng bò câu chẳng tìm được nơi nào đáp chân xuống, bèn bay trở về trong tàu cùng người, vì nước còn khắp cả trên mặt đất. Nô-ê giơ tay bắt lấy bò câu, đem vào tàu lại với mình. ");
INSERT INTO vie1934_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Đoạn, người đợi bảy ngày nữa, lại thả bò câu ra khỏi tàu; ");
INSERT INTO vie1934_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","đến chiều bò câu về cùng người, và nầy, trong mỏ tha một lá Ô-li-ve tươi; Nô-ê hiểu rằng nước đã giảm bớt trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Người đợi bảy ngày nữa, thả bò câu ra; nhưng chuyến nầy bò câu chẳng trở về cùng người nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nhằm năm sáu trăm một của đời Nô-ê, ngày mồng một, tháng giêng, nước đã giựt bày mặt đất khô; Nô-ê bèn giở mui tàu mà nhìn; nầy, mặt đất đã se. ");
INSERT INTO vie1934_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Đến tháng hai, ngày hai mươi bảy, đất đã khô rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Đức Chúa Trời bèn phán cùng Nô-ê rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Hãy ra khỏi tàu, ngươi, vợ các con và các dâu ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hãy thả ra với ngươi mọi vật sống của các xác thịt đã ở cùng ngươi: nào chim, nào thú, nào côn trùng bò trên đất, hầu cho chúng nó sanh sản, và thêm nhiều trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Vậy, Nô-ê cùng vợ người, các con trai và các dâu người ra khỏi tàu. ");
INSERT INTO vie1934_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Các thú, rắn, chim cùng mọi vật hành động trên mặt đất tùy theo giống đều ra khỏi tàu. ");
INSERT INTO vie1934_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nô-ê lập một bàn thờ cho Đức Giê-hô-va. Người bắt các súc vật thanh sạch, các loài chim thanh sạch, bày của lễ thiêu dâng lên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Đức Giê-hô-va hưởng lấy mùi thơm và nghĩ thầm rằng: Ta chẳng vì loài người mà rủa sả đất nữa, vì tâm tánh loài người vẫn xấu xa từ khi còn tuổi trẻ; ta cũng sẽ chẳng hành các vật sống như ta đã làm. ");
INSERT INTO vie1934_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Hễ đất còn, thì mùa gieo giống cùng mùa gặt hái, lạnh và nóng, mùa hạ cùng mùa đông, ngày và đêm, chẳng bao giờ tuyệt được. ");
INSERT INTO vie1934_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Đức Chúa Trời ban phước cho Nô-ê cùng các con trai người, mà phán rằng: Hãy sanh sản, thêm nhiều, làm cho đầy dẫy trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Các loài vật ở trên đất, các loài chim trời, và các vật hành động trên đất, cùng các cá biển, đều sẽ kinh khủng ngươi và bị phú vào tay ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Phàm vật chi hành động và có sự sống thì dùng làm đồ ăn cho các ngươi. Ta cho mọi vật đó như ta đã cho thứ cỏ xanh. ");
INSERT INTO vie1934_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Song các ngươi không nên ăn thịt còn hồn sống, nghĩa là có máu. ");
INSERT INTO vie1934_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Quả thật, ta sẽ đòi máu của sự sống ngươi lại, hoặc nơi các loài thú vật, hoặc nơi tay người, hoặc nơi tay của anh em người. ");
INSERT INTO vie1934_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Hễ kẻ nào làm đổ máu người, thì sẽ bị người khác làm đổ máu lại; vì Đức Chúa Trời làm nên người như hình của Ngài. ");
INSERT INTO vie1934_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Vậy, các ngươi hãy sanh sản, thêm nhiều, và làm cho đầy dẫy trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Đức Chúa Trời cũng phán cùng Nô-ê và các con trai người rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Còn phần ta đây, ta lập giao ước cùng các ngươi, cùng dòng dõi các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","và cùng mọi vật sống ở với ngươi, nào loài chim, nào súc vật, nào loài thú ở trên đất, tức là các loài ở trong tàu ra, cho đến các loài vật ở trên đất. ");
INSERT INTO vie1934_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Vậy, ta lập giao ước cùng các ngươi, và các loài xác thịt chẳng bao giờ lại bị nước lụt hủy diệt, và cũng chẳng có nước lụt để hủy hoại đất nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Đức Chúa Trời lại phán rằng: Đây là dấu chỉ về sự giao ước mà ta lập cùng các ngươi, cùng hết thảy vật sống ở với các ngươi, trải qua các đời mãi mãi. ");
INSERT INTO vie1934_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ta đặt mống của ta trên từng mây, dùng làm dấu chỉ sự giao ước của ta với đất. ");
INSERT INTO vie1934_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Phàm lúc nào ta góp các đám mây trên mặt đất và phàm mống mọc trên từng mây, ");
INSERT INTO vie1934_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","thì ta sẽ nhớ lại sự giao ước của ta đã lập cùng các ngươi, và cùng các loài xác thịt có sự sống, thì nước chẳng bao giờ lại trở nên lụt mà hủy diệt các loài xác thịt nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Vậy, cái mống sẽ ở trên mây, ta nhìn xem nó đặng nhớ lại sự giao ước đời đời của Đức Chúa Trời cùng các loài xác thịt có sự sống ở trên đất. ");
INSERT INTO vie1934_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Đức Chúa Trời lại phán cùng Nô-ê rằng: Đó là dấu chỉ sự giao ước mà ta đã lập giữa ta và các xác thịt ở trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Các con trai của Nô-ê ở trong tàu ra là Sem, Cham và Gia-phết. Vả, Cham là cha của Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Aáy đó, là ba con trai của Nô-ê, và cũng do nơi họ mà có loài người ở khắp trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Vả, Nô-ê khởi cày đất và trồng nho. ");
INSERT INTO vie1934_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Người uống rượu say, rồi lõa thể ở giữa trại mình. ");
INSERT INTO vie1934_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham là cha Ca-na-an, thấy sự trần truồng của cha, thì ra ngoài thuật lại cùng hai anh em mình. ");
INSERT INTO vie1934_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Nhưng Sem và Gia-phết đều lấy áo choàng vắt trên vai mình, đi thùi lui đến đắp khuất thân cho cha; và bởi họ xây mặt qua phía khác, nên chẳng thấy sự trần truồng của cha chút nào. ");
INSERT INTO vie1934_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Khi Nô-ê tỉnh rượu rồi, hay được điều con thứ hai đã làm cho mình, ");
INSERT INTO vie1934_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","bèn nói rằng: Ca-na-an đáng rủa sả! Nó sẽ làm mọi cho các tôi tớ của anh em nó. ");
INSERT INTO vie1934_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Người lại nói rằng: Đáng ngợi khen Giê-hô-va, là Đức Chúa Trời của Sem thay; Ca-na-an phải làm tôi cho họ! ");
INSERT INTO vie1934_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Cầu xin Đức Chúa Trời mở rộng đất cho Gia-phết, cho người ở nơi trại của Sem; còn Ca-na-an phải làm tôi của họ. ");
INSERT INTO vie1934_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Sau khi lụt, Nô-ê còn sống ba trăm năm mươi năm. ");
INSERT INTO vie1934_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Vậy, Nô-ê hưởng thọ được chín trăm năm mươi tuổi, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Đây là dòng dõi của Sem, Cham và Gia-phết, ba con trai của Nô-ê; sau khi lụt, họ sanh con cái. ");
INSERT INTO vie1934_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Con trai của Gia-phết là Gô-me, Ma-gốc, Ma-đai, Gia-van, Tu-banh, Mê-siếc, và Ti-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Con trai của Gô-me là Aùch-kê-na, Ri-phát, và Tô-ga-ma. ");
INSERT INTO vie1934_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Con trai của Gia-van là Ê-li-sa và Ta-rê-si, Kít-tim và Đô-đa-nim. ");
INSERT INTO vie1934_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Do họ mà có người ta ở tràn ra các cù lao của các dân, tùy theo xứ, tiếng nói, chi phái và dân tộc của họ mà chia ra. ");
INSERT INTO vie1934_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Con trai của Cham là Cúc, Mích-ra-im, Phút và Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Con trai của Cúc là Sê-ba, Ha-vi-la, Sáp-ta, Ra-ê-ma và Sáp-tê-ca; con trai của Ra-ê-ma là Sê-la và Đê-đan. ");
INSERT INTO vie1934_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cúc sanh Nim-rốt, ấy là người bắt đầu làm anh hùng trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Người là một tay thợ săn can đảm trước mặt Đức Giê-hô-va. Bởi cớ đó, có tục ngữ rằng: Hệt như Nim-rốt, một tay thợ săn can đảm trước mặt Đức Giê-hô-va! ");
INSERT INTO vie1934_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nước người sơ-lập là Ba-bên, Ê-rết, A-cát và Ca-ne ở tại xứ Si-nê-a. ");
INSERT INTO vie1934_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Từ xứ đó người đến xứ A-si-ri, rồi lập thành Ni-ni-ve, Rê-hô-bô-ti, Ca-lách, ");
INSERT INTO vie1934_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Và thành Rê-sen, là thành rất lớn, ở giữa khoảng thành Ni-ni-ve và Ca-lách. ");
INSERT INTO vie1934_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mích-ra-im sanh họ Lu-đim, họ A-na-mim, họ Lê-ha-bim, họ Náp-tu-him, ");
INSERT INTO vie1934_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","họ Bát-ru-sim, họ Cách-lu-him (bởi đó sanh họ Phi-li-tin), và họ Cáp-tô-rim. ");
INSERT INTO vie1934_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ca-na-an sanh Si-đôn, là con trưởng nam, và Hếch, ");
INSERT INTO vie1934_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","cùng họ Giê-bu-sít, họ A-mô-rít, họ Ghi-rê-ga-sít, ");
INSERT INTO vie1934_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","họ Hê-vít, họ A-rê-kít, họ Si-nít, ");
INSERT INTO vie1934_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","họ A-va-đít, họ Xê-ma-rít, họ Ha-ma-tít. Kế đó, chi tộc Ca-na-an đi tản lạc. ");
INSERT INTO vie1934_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Còn địa-phận Ca-na-an, về hướng Ghê-ra, chạy từ Si-đôn tới Ga-xa; về hướng Sô-đôm, Gô-mô-rơ, Aùt-ma và Sê-bô-im, chạy đến Lê-sa. ");
INSERT INTO vie1934_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Đó là con cháu của Cham, tùy theo họ hàng, tiếng nói, xứ và dân tộc của họ. ");
INSERT INTO vie1934_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, tổ phụ của họ Hê-be và anh cả của Gia-phết, cũng có sanh con trai. ");
INSERT INTO vie1934_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Con trai của Sem là Ê-lam, A-su-rơ, A-bác-sát, Lút và A-ram. ");
INSERT INTO vie1934_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Con trai của A-ram là U-xơ, Hu-lơ, Ghê-te và Mách. ");
INSERT INTO vie1934_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Còn A-bác-sát sanh Sê-lách; Sê-lách sanh Hê-be, ");
INSERT INTO vie1934_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hê-be sanh được hai con trai; tên của một người là Bê-léc, vì đất trong đời người đó đã chia ra; tên của người em là Giốc-tan. ");
INSERT INTO vie1934_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Giốc-tan sanh A-mô-đát, Sê-lép, Ha-sa-ma-vết và Giê-rách, ");
INSERT INTO vie1934_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Ha-đô-ram, U-xa, Điếc-la, ");
INSERT INTO vie1934_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Ô-banh, A-bi-ma-ên, Sê-ba, ");
INSERT INTO vie1934_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ô-phia, Ha-vi-la và Giô-báp. Hết thảy các người đó là con trai của Giốc-tan. ");
INSERT INTO vie1934_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Cõi đất của các người đó ở về phía Sê-pha, chạy từ Mê-sa cho đến núi Đông phương. ");
INSERT INTO vie1934_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Đó là con cháu của Sem, tùy theo họ hàng, tiếng nói, xứ và dân tộc của họ. ");
INSERT INTO vie1934_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aáy là các họ hàng của ba con trai Nô-ê tùy theo đời và dân tộc của họ; lại cũng do nơi họ mà các dân chia ra trên mặt đất sau cơn nước lụt. ");
INSERT INTO vie1934_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Vả, cả thiên hạ đều có một giọng nói và một thứ tiếng. ");
INSERT INTO vie1934_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Nhưng khi ở Đông phương dời đi, người ta gặp một đồng bằng trong xứ Si-nê-a, rồi ở tại đó. ");
INSERT INTO vie1934_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Người nầy nói với người kia rằng: Hè! chúng ta hãy làm gạch và hầm trong lửa. Lúc đó, gạch thế cho đá, còn chai thế cho hồ. ");
INSERT INTO vie1934_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Lại nói rằng: Nào! chúng ta hãy xây một cái thành và dựng lên một cái tháp, chót cao đến tận trời; ta hãy lo làm cho rạng danh, e khi phải tản lạc khắp trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Đức Giê-hô-va bèn ngự xuống đặng xem cái thành và tháp của con cái loài người xây nên. ");
INSERT INTO vie1934_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Đức Giê-hô-va phán rằng: Nầy, chỉ có một thứ dân, cùng đồng một thứ tiếng; và kia kìa công việc chúng nó đang khởi làm; bây giờ chẳng còn chi ngăn chúng nó làm các điều đã quyết định được. ");
INSERT INTO vie1934_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Thôi! chúng ta, hãy xuống, làm lộn xộn tiếng nói của chúng nó, cho họ nghe không được tiếng nói của người nầy với người kia. ");
INSERT INTO vie1934_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Rồi, từ đó Đức Giê-hô-va làm cho loài người tản ra khắp trên mặt đất, và họ thôi công việc xây cất thành. ");
INSERT INTO vie1934_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Bởi cớ đó đặt tên thành là Ba-bên, vì nơi đó Đức Giê-hô-va làm lộn xộn tiếng nói của cả thế gian, và từ đây Ngài làm cho loài người tản ra khắp trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Đây là dòng dõi của Sem: Cách hai năm, sau cơn nước lụt, Sem được một trăm tuổi, sanh A-bác-sát. ");
INSERT INTO vie1934_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sau khi Sem sanh A-bác-sát rồi, còn sống được năm trăm năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","A-bác-sát được ba mươi lăm tuổi, sanh Sê-lách. ");
INSERT INTO vie1934_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sau khi A-bác-sát sanh Sê-lách rồi, còn sống được bốn trăm ba năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sê-lách được ba mươi tuổi, sanh Hê-be. ");
INSERT INTO vie1934_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sau khi Sê-lách sanh Hê-be rồi, còn sống được bốn trăm ba năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Hê-be được ba mươi bốn tuổi, sanh Bê-léc. ");
INSERT INTO vie1934_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Sau khi Hê-be sanh Bê-léc rồi, còn sống được bốn trăm ba mươi năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Bê-léc được ba mươi tuổi, sanh Rê-hu ");
INSERT INTO vie1934_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Sau khi Bê-léc sanh Rê-hu rồi, còn sống được hai trăm chín năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rê-hu được ba mươi hai tuổi, sanh Sê-rúc. ");
INSERT INTO vie1934_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Sau khi Rê-hu sanh Sê-rúc rồi, còn sống được hai trăm bảy năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sê-rúc được ba mươi tuổi, sanh Na-cô. ");
INSERT INTO vie1934_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sau khi Sê-rúc sanh Na-cô rồi, còn sống được hai trăm năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Na-cô được hai mươi chín tuổi, sanh Tha-rê. ");
INSERT INTO vie1934_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Sau khi Na-cô sanh Tha-rê rồi, còn sống được một trăm mười chín năm, sanh con trai con gái. ");
INSERT INTO vie1934_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Còn Tha-rê được bảy mươi tuổi, sanh Aùp-ram, Na-cô và Ha-ran. ");
INSERT INTO vie1934_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Đây là dòng dõi của Tha-rê: Tha-rê sanh Aùp-ram, Na-cô và Ha-ran; Ha-ran sanh Lót. ");
INSERT INTO vie1934_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ha-ran qua đời tại quê hương mình, tức là U-rơ, thuộc về xứ Canh-đê, khi cha người là Tha-rê hãy còn sống. ");
INSERT INTO vie1934_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aùp-ram và Na-cô cưới vợ; vợ Aùp-ram tên là Sa-rai, còn vợ Na-cô tên là Minh-ca; Minh-ca và Dích-ca tức là con gái của Ha-ran. ");
INSERT INTO vie1934_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Vả, Sa-rai son sẻ, nên người không có con. ");
INSERT INTO vie1934_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tha-rê dẫn Aùp-ram, con trai mình, Lót, con trai Ha-ran, cháu mình, và Sa-rai, vợ Aùp-ram, tức dâu mình, đồng ra khỏi U-rơ, thuộc về xứ Canh-đê, đặng qua xứ Ca-na-an. Khi đến Cha-ran thì lập gia cư tại đó. ");
INSERT INTO vie1934_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tha-rê hưởng thọ được hai trăm năm tuổi, rồi qua đời tại Cha-ran. ");
INSERT INTO vie1934_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Vả, Đức Giê-hô-va có phán cùng Aùp-ram rằng: Ngươi hãy ra khỏi quê hương, vòng bà con và nhà cha ngươi, mà đi đến xứ ta sẽ chỉ cho. ");
INSERT INTO vie1934_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ta sẽ làm cho ngươi nên một dân lớn; ta sẽ ban phước cho ngươi, cùng làm nổi danh ngươi, và ngươi sẽ thành một nguồn phước. ");
INSERT INTO vie1934_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ta sẽ ban phước cho người nào chúc phước ngươi, rủa sả kẻ nào rủa sả ngươi; và các chi tộc nơi thế gian sẽ nhờ ngươi mà được phước. ");
INSERT INTO vie1934_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Rồi Aùp-ram đi, theo như lời Đức Giê-hô-va đã phán dạy; Lót đồng đi với người. Khi Aùp-ram ra khỏi Cha-ran, tuổi người được bảy mươi lăm. ");
INSERT INTO vie1934_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aùp-ram dẫn Sa-rai, vợ mình, Lót, cháu mình, cả gia tài đã thâu góp, và các đầy tớ đã được tại Cha-ran, từ đó ra, để đi đến xứ Ca-na-an; rồi, chúng đều đến xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Aùp-ram trải qua xứ nầy, đến cây dẻ bộp của Mô-rê, tại Si-chem. Vả, lúc đó, dân Ca-na-an ở tại xứ. ");
INSERT INTO vie1934_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Đức Giê-hô-va hiện ra cùng Aùp-ram mà phán rằng: Ta sẽ ban cho dòng dõi ngươi đất nầy! Rồi tại đó Aùp-ram lập một bàn thờ cho Đức Giê-hô-va, là Đấng đã hiện đến cùng người. ");
INSERT INTO vie1934_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Từ đó, người đi qua núi ở về phía đông Bê-tên, rồi đóng trại; phía tây có Bê-tên, phía đông có A-hi. Đoạn, người lập tại đó một bàn thờ cho Đức Giê-hô-va và cầu khẩn danh Ngài. ");
INSERT INTO vie1934_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kế sau, Aùp-ram vừa đi vừa đóng trại lần lần đến Nam phương. ");
INSERT INTO vie1934_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bấy giờ, trong xứ bị cơn đói kém; sự đói kém ấy lớn, nên Aùp-ram xuống xứ Ê-díp-tô mà kiều ngụ. ");
INSERT INTO vie1934_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Khi hầu vào đất Ê-díp-tô, Aùp-ram bèn nói cùng Sa-rai, vợ mình, rằng: Nầy, ta biết ngươi là một người đàn bà đẹp. ");
INSERT INTO vie1934_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Gặp khi nào dân Ê-díp-tô thấy ngươi, họ sẽ nói rằng: Aáy là vợ hắn đó; họ sẽ giết ta, nhưng để cho ngươi sống. ");
INSERT INTO vie1934_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ta xin hãy xưng ngươi là em gái ta, hầu cho sẽ vì ngươi mà ta được trọng đãi và giữ toàn mạng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Aùp-ram vừa đến xứ Ê-díp-tô, dân Ê-díp-tô nhìn thấy người đàn bà đó đẹp lắm. ");
INSERT INTO vie1934_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Các triều thần của Pha-ra-ôn cũng thấy người và trằm trồ trước mặt vua; đoạn người đàn bà bị dẫn vào cung Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Vì cớ người, nên Pha-ra-ôn hậu đãi Aùp-ram, và Aùp-ram được nhiều chiên, bò, lừa đực, lừa cái, lạc đà, tôi trai và tớ gái. ");
INSERT INTO vie1934_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Song vì Sa-rai, vợ Aùp-ram, nên Đức Giê-hô-va hành phạt Pha-ra-ôn cùng nhà người bị tai họa lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pha-ra-ôn bèn đòi Aùp-ram hỏi rằng: Ngươi đã làm chi cho ta vậy? Sao không tâu với ta rằng là vợ ngươi? ");
INSERT INTO vie1934_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Sao đã nói rằng: người đó là em gái tôi? nên nỗi ta đã lấy nàng làm vợ. Bây giờ, vợ ngươi đây; hãy nhận lấy và đi đi. ");
INSERT INTO vie1934_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Đoạn, Pha-ra-ôn hạ lịnh cho quan quân đưa vợ chồng Aùp-ram cùng hết thảy tài vật của người đi. ");
INSERT INTO vie1934_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aùp-ram ở Ê-díp-tô dẫn vợ cùng các tài vật mình và Lót đồng trở lên Nam phương. ");
INSERT INTO vie1934_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Vả, Aùp-ram rất giàu có súc vật, vàng và bạc. ");
INSERT INTO vie1934_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","người vừa đi vừa đóng trại, từ Nam phương trở về Bê-tên và A-hi, ");
INSERT INTO vie1934_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","là nơi đã lập một bàn thờ lúc trước. ỳ đó Aùp-ram cầu khẩn danh Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Vả, Lót cùng đi với Aùp-ram, cũng có chiên, bò, và trại. ");
INSERT INTO vie1934_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Xứ đó không đủ chỗ cho hai người ở chung, vì tài vật rất nhiều cho đến đỗi không ở chung nhau được. ");
INSERT INTO vie1934_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Trong khi dân Ca-na-an và dân Phê-rê-sít ở trong xứ, xảy có chuyện tranh giành của bọn chăn chiên Aùp-ram cùng bọn chăn chiên Lót. ");
INSERT INTO vie1934_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Aùp-ram nói cùng Lót rằng: Chúng ta là cốt nhục, xin ngươi cùng ta chẳng nên cãi lẫy nhau và bọn chăn chiên ta cùng bọn chăn chiên ngươi cũng đừng tranh giành nhau nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Toàn xứ há chẳng ở trước mặt ngươi sao? Vậy, hãy lìa khỏi ta; nếu ngươi lấy bên tả, ta sẽ qua bên hữu; nếu ngươi lấy bên hữu, ta sẽ qua bên tả. ");
INSERT INTO vie1934_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lót bèn ngước mắt lên, thấy khắp cánh đồng bằng bên sông Giô-đanh, là nơi (trước khi Đức Giê-hô-va chưa phá hủy thành Sô-đôm và Gô-mô-rơ) thảy đều có nước chảy tưới khắp đến Xoa; đồng ó cũng như vườn của Đức Giê-hô-va và như xứ Ê-díp-tô vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lót bèn chọn lấy cho mình hết cánh đồng bằng bên sông Giô-đanh và đi qua phía Đông. Vậy, hai người chia rẽ nhau. ");
INSERT INTO vie1934_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aùp-ram ở trong xứ Ca-na-an, còn Lót ở trong thành của đồng bằng và dời trại mình đến Sô-đôm. ");
INSERT INTO vie1934_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Vả, dân Sô-đôm là độc ác và kẻ phạm tội trọng cùng Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sau khi Lót lìa khỏi Aùp-ram rồi, Đức Giê-hô-va phán cùng Aùp-ram rằng: Hãy nhướng mắt lên, nhìn từ chỗ ngươi ở cho đến phương bắc, phương nam, phương đông và phương tây: ");
INSERT INTO vie1934_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Vì cả xứ nào ngươi thấy, ta sẽ ban cho ngươi và cho dòng dõi ngươi đời đời. ");
INSERT INTO vie1934_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ta sẽ làm cho dòng dõi ngươi như bụi trên đất; thế thì, nếu kẻ nào đếm đặng bụi trên đất, thì cũng sẽ đếm đặng dòng dõi ngươi vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hãy đứng dậy đi khắp trong xứ, bề dài và bề ngang; vì ta sẽ ban cho ngươi xứ nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Đoạn Aùp-ram dời trại mình đến ở nơi lùm cây dẻ bộp tại Mam-rê, thuộc về Hếp-rôn, và lập tại đó một bàn thờ cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Trong đời Am-ra-phên, vua Si-nê-a; A-ri-óc, vua Ê-la-sa; Kết-rô-Lao me, vua Ê-lam, và Ti-đanh, vua Gô-im, ");
INSERT INTO vie1934_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","bốn vua hiệp lại tranh chiến cùng Bê-ra, vua Sô-đôm; Bi-rê-sa, vua Gô-mô-rơ; Si-nê-áp, vua Aùt-ma; Sê-mê-bê, vua Xê-bô-im, và vua Bê-la, tức là Xoa. ");
INSERT INTO vie1934_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Các vua nầy hiệp lại tại trũng Si-điêm, bây giờ là biển muối. ");
INSERT INTO vie1934_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Trong mười hai năm các vua nầy đều là chư-hầu của vua Kết-rô-Lao me; nhưng qua năm thứ mười ba, thì họ dấy loạn. ");
INSERT INTO vie1934_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Nhằm năm thứ mười bốn, Kết-rô-Lao-me cùng các vua đồng minh kéo quân đến dẹp dân Rê-pha-im ở đất Aùch-tê-rót-Ca-na-im, dân Xu-xin tại đất Ham, dân Ê-mim ở trong đồng bằng Ki-ri-a-ta-im, ");
INSERT INTO vie1934_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","và dân Hô-rít tại núi Sê-i-rơ, cho đến nơi Eân-Ba-ran, ở gần đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Đoạn, các vua thâu binh trở về, đến Suối Xử đoán, tức Ca-đe, hãm đánh khắp miền dân A-ma-léc, và dân A-mô-rít ở tại Hát-sát sôn-Tha-ma. ");
INSERT INTO vie1934_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Các vua của Sô-đôm, Gô-mô-rơ, Aùt-ma, Xê-bô-im và vua Bê-la, tức là Xoa, bèn xuất trận và dàn binh đóng tại trũng Si-điêm, ");
INSERT INTO vie1934_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","đặng chống cự cùng Kết-rô-Lao-me, vua Ê-lam; Ti-đanh, vua Gô-im; Am-ra-phên, vua Si-nê-a, và A-ri-óc, vua Ê-la-sa; bốn vị đang địch cùng năm. ");
INSERT INTO vie1934_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Vả, trong trũng Si-điêm có nhiều hố nhựa chai; vua Sô-đôm và vua Gô-mô-rơ thua chạy, sa xuống hố, còn kẻ nào thoát được chạy trốn trên núi. ");
INSERT INTO vie1934_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Bên thắng trận bèn cướp lấy hết của cải và lương thực của Sô-đôm và Gô-mô-rơ, rồi đi. ");
INSERT INTO vie1934_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Giặc cũng bắt Lót, là cháu của Aùp-ram, ở tại Sô-đôm, và hết thảy gia tài người, rồi đem đi. ");
INSERT INTO vie1934_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Có một người thoát được chạy đến báo điều đó cùng Aùp-ram, là người Hê-bơ-rơ. Aùp-ram ở tại lùm cây dẻ bộp của Mam-rê, là người A-mô-rít, anh của Eách-côn và A-ne; ba người nầy đã có kết-ước cùng Aùp-ram. ");
INSERT INTO vie1934_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Khi Aùp-ram hay được cháu mình bị quân giặc bắt, bèn chiêu tập ba trăm mười tám gia nhân đã tập luyện, sanh đẻ nơi nhà mình, mà đuổi theo các vua đó đến đất Đan. ");
INSERT INTO vie1934_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Đoạn Aùp-ram chia bọn đầy tớ mình ra, thừa ban đêm xông hãm quân nghịch, đánh đuổi theo đến đất Hô-ba ở về phía tả Đa-mách. ");
INSERT INTO vie1934_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Người thâu về đủ hết các tài vật mà quân giặc đã cướp lấy; lại cũng dẫn cháu mình, là Lót cùng gia tài người, đàn bà và dân chúng trở về. ");
INSERT INTO vie1934_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Sau khi Aùp-ram đánh bại Kết-rô-Lao-me và các vua đồng minh, thắng trận trở về, thì vua Sô-đôm ra đón rước người tại trũng Sa-ve, tức là trũng Vua. ");
INSERT INTO vie1934_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mên-chi-xê-đéc, vua Sa-lem, sai đem bánh và rượu ra. Vả, vua nầy là thầy tế lễ của Đức Chúa Trời Chí cao, ");
INSERT INTO vie1934_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","chúc phước cho Aùp-ram và nói rằng: Nguyện Đức Chúa Trời Chí cao, là Đấng dựng nên trời và đất, ban phước cho Aùp-ram! ");
INSERT INTO vie1934_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Đáng ngợi khen thay Đức Chúa Trời Chí cao đã phó kẻ thù nghịch vào tay ngươi! Đoạn, Aùp-ram lấy một phần mười về cả của giặc mà dâng cho vua đó. ");
INSERT INTO vie1934_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Vua Sô-đôm bèn nói cùng Aùp-ram rằng: Hãy giao người cho ta, còn của cải, thì ngươi thâu lấy. ");
INSERT INTO vie1934_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Aùp-ram đáp lại rằng: Tôi giơ tay lên trước mặt Giê-hô-va Đức Chúa Trời Chí cao, Chúa Tể của trời và đất, mà thề rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Hễ của chi thuộc về vua, dầu đến một sợi chỉ, hay là một sợi dây giày đi nữa, tôi cũng chẳng hề lấy; e vua nói được rằng: Nhờ ta làm cho Aùp-ram giàu có, ");
INSERT INTO vie1934_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","chỉ món chi của những người trẻ đã ăn, và phần của các người cùng đi với tôi, là A-ne, Eách-côn và Mam-rê; về phần họ, họ hãy lấy phần của họ đi. ");
INSERT INTO vie1934_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Sau các việc đó, trong sự hiện thấy có lời Đức Giê-hô-va phán cùng Aùp-ram rằng: Hỡi Aùp-ram! ngươi chớ sợ chi; ta đây là một cái thuẫn đỡ cho ngươi; phần thưởng của ngươi sẽ rất lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Aùp-ram thưa rằng: Lạy Chúa Giê-hô-va, Chúa sẽ cho tôi chi? Tôi sẽ chết không con, kẻ nối nghiệp nhà tôi là Ê-li-ê-se, người Đa-mách. ");
INSERT INTO vie1934_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Aùp-ram lại nói rằng: Nầy, Chúa làm cho tôi tuyệt-tự; một kẻ tôi tớ sanh đẻ tại nhà tôi sẽ làm người kế nghiệp tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Đức Giê-hô-va bèn phán cùng Aùp-ram rằng: Kẻ đó chẳng phải là kẻ kế nghiệp ngươi đâu, nhưng ai ở trong gan ruột ngươi ra, sẽ là người kế nghiệp ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Đoạn, Ngài dẫn người ra ngoài và phán rằng: Ngươi hãy ngó lên trời, và nếu ngươi đếm được các ngôi sao thì hãy đếm đi. Ngài lại phán rằng: Dòng dõi ngươi cũng sẽ như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Aùp-ram tin Đức Giê-hô-va, thì Ngài kể sự đó là công bình cho người. ");
INSERT INTO vie1934_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Đức Giê-hô-va lại phán cùng Aùp-ram rằng: Ta là Đức Giê-hô-va, Đấng đã dẫn ngươi ra khỏi U-rơ, thuộc về xứ Canh-đê, để ban cho ngươi xứ nầy làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aùp-ram thưa rằng: Lạy Chúa Giê-hô-va, bởi cớ chi tôi biết rằng tôi sẽ được xứ nầy làm sản nghiệp? ");
INSERT INTO vie1934_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Đức Giê-hô-va đáp rằng: Ngươi hãy bắt đem cho ta một con bò cái ba tuổi, một con dê cái ba tuổi, một con chiên đực ba tuổi, một con cu rừng và một con bò câu con. ");
INSERT INTO vie1934_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aùp-ram bắt đủ các loài vật đó, mổ làm hai, để mỗi nửa con mỗi bên đối với nhau, nhưng không mổ các loài chim ra làm hai. ");
INSERT INTO vie1934_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Có những chim ăn mồi bay đáp trên mấy con thú chết đó, song Aùp-ram đuổi nó đi. ");
INSERT INTO vie1934_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Vả, khi mặt trời vừa lặn, thì Aùp-ram ngủ mê; nầy một cơn kinh hãi, tối tăm nhập vào mình người. ");
INSERT INTO vie1934_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Đức Giê-hô-va phán cùng Aùp-ram rằng: Phải biết rằng, dòng dõi ngươi sẽ ngụ trong một xứ chẳng thuộc về chúng nó, làm tôi mọi cho dân xứ đó và bị họ hà hiếp bốn trăm năm. ");
INSERT INTO vie1934_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Nhưng, ta sẽ đoán phạt dân mà dòng dõi ngươi sẽ làm tôi mọi đó; rồi khi ra khỏi xứ, thì sẽ được của cải rất nhiều. ");
INSERT INTO vie1934_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Còn ngươi sẽ bình yên về nơi tổ phụ, hưởng lộc già sung sướng, rồi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Đến đời thứ tư, dòng dõi ngươi sẽ trở lại đây, vì tội lỗi của dân A-mô-rít chưa được đầy dẫy. ");
INSERT INTO vie1934_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Khi mặt trời đã lặn, thình lình sự tối mịt giáng xuống; kìa có một lò lớn khói lên, và một ngọn lửa lòe ngang qua các xác thịt đã mổ, ");
INSERT INTO vie1934_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ngày đó, Đức Giê-hô-va lập giao ước cùng Aùp-ram, mà phán rằng: Ta cho dòng dõi ngươi xứ nầy, từ sông Ê-díp-tô cho đến sông lớn kia, tức sông Ơ-phơ-rát, ");
INSERT INTO vie1934_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","là xứ của các dân Kê-nít, Kê-nê-sít, Cát-mô-nít ");
INSERT INTO vie1934_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hê-tít, Phê-rê-sít, Rê-pha-im, ");
INSERT INTO vie1934_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","A-mô-nít, Ca-na-an, Ghi-ê-ga-sít và Giê-bu-sít. ");
INSERT INTO vie1934_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Vả, Sa-rai, vợ của Aùp-ram, vẫn không sanh con; nàng có một con đòi Ê-díp-tô, tên là A-ga. ");
INSERT INTO vie1934_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sa-rai nói cùng Aùp-ram rằng: Nầy, Đức Giê-hô-va đã làm cho tôi son sẻ, vậy xin ông hãy lại ăn ở cùng con đòi tôi, có lẽ tôi sẽ nhờ nó mà có con chăng. Aùp-ram bèn nghe theo lời của Sa-rai. ");
INSERT INTO vie1934_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sau khi Aùp-ram đã trú ngụ mười năm tại xứ Ca-na-an, Sa-rai, vợ người, bắt A-ga, là con đòi Ê-díp-tô mình, đưa cho chồng làm hầu. ");
INSERT INTO vie1934_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Người lại cùng con đòi, thì nàng thọ thai. Khi con đòi thấy mình thọ thai, thì khinh bỉ bà chủ mình. ");
INSERT INTO vie1934_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sa-rai nói cùng Aùp-ram rằng: Điều sỉ nhục mà tôi bị đây đổ lại trên ông. Tôi đã phú con đòi tôi vào lòng ông, mà từ khi nó thấy mình thọ thai, thì lại khinh tôi. Cầu Đức Giê-hô-va xét đoán giữa tôi với ông. ");
INSERT INTO vie1934_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aùp-ram đáp cùng Sa-rai rằng: Nầy, con đòi đó ở trong tay ngươi, phân xử thể nào, mặc ý ngươi cho vừa dạ. Đoạn Sa-rai hành hạ A-ga, thì nàng trốn đi khỏi mặt người. ");
INSERT INTO vie1934_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Nhưng thiên sứ của Đức Giê-hô-va thấy nàng ở trong đồng vắng gần bên suối nước, nơi mé đường đi về Su-rơ, ");
INSERT INTO vie1934_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","thì hỏi rằng: Hỡi A-ga, đòi của Sa-rai, ngươi ở đâu đến, và sẽ đi đâu? Nàng thưa rằng: Tôi lánh xa mặt Sa-rai, chủ tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Thiên sứ của Đức Giê-hô-va dạy nàng rằng: Ngươi hãy trở về chủ ngươi, và chịu lụy dưới tay người. ");
INSERT INTO vie1934_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Thiên sứ của Đức Giê-hô-va lại phán rằng: Ta sẽ thêm dòng dõi ngươi nhiều, đông đảo đến đỗi người ta đếm không đặng nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Lại phán rằng: Nầy, ngươi đang có thai, sẽ sanh một trai, đặt tên là ỗch-ma-ên; vì Đức Giê-hô-va có nghe sự sầu khổ của ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Đứa trẻ đó sẽ như một con lừa rừng; tay nó sẽ địch cùng mọi người, và tay mọi người địch lại nó. Nó sẽ ở về phía đông đối mặt cùng hết thảy anh em mình. ");
INSERT INTO vie1934_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nàng gọi Đức Giê-hô-va mà đã phán cùng mình, danh là “Đức Chúa Trời hay đoái xem,” vì nàng nói rằng: Chính tại đây, tôi há chẳng có thấy được Đấng đoái xem tôi sao? ");
INSERT INTO vie1934_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Bởi cớ ấy, người ta gọi cái giếng nầy ở về giữa khoảng của Ca-đe và Bê-re, là giếng La-chai-Roi. ");
INSERT INTO vie1934_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Rồi nàng A-ga sanh được một con trai; Aùp-ram đặt tên đứa trai đó là ỗch-ma-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Vả lại, khi A-ga sanh ỗch-ma-ên cho Aùp-ram, thì Aùp-ram đã được tám mươi sáu tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Khi Aùp-ram được chín mươi chín tuổi, thì Đức Giê-hô-va hiện đến cùng người và phán rằng: Ta là Đức Chúa Trời toàn năng; ngươi hãy đi ở trước mặt ta làm một người trọn vẹn. ");
INSERT INTO vie1934_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ta sẽ lập giao ước cùng ngươi, làm cho dòng dõi ngươi thêm nhiều quá-bội. ");
INSERT INTO vie1934_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aùp-ram bèn sấp mình xuống đất; Đức Chúa Trời phán cùng người rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Nầy, phần ta đây, ta đã lập giao ước cùng ngươi; vậy ngươi sẽ trở nên tổ phụ của nhiều dân tộc. ");
INSERT INTO vie1934_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Thiên hạ chẳng còn gọi ngươi là Aùp-ram nữa, nhưng tên ngươi sẽ là Aùp-ra-ham, vì ta đặt ngươi làm tổ phụ của nhiều dân tộc. ");
INSERT INTO vie1934_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ta sẽ làm cho ngươi sanh sản rất nhiều, làm cho ngươi thành nhiều nước; và các vua sẽ do nơi ngươi mà ra. ");
INSERT INTO vie1934_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ta sẽ lập giao ước cùng ngươi, và cùng hậu tự ngươi trải qua các đời; ấy là giao ước đời đời, hầu cho ta làm Đức Chúa Trời của ngươi và của dòng dõi ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ta sẽ cho ngươi cùng dòng dõi ngươi xứ mà ngươi đang kiều ngụ, tức toàn xứ Ca-na-an, làm cơ nghiệp đời đời. Vậy, ta sẽ làm Đức Chúa Trời của họ. ");
INSERT INTO vie1934_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Đoạn, Đức Chúa Trời phán cùng Aùp-ra-ham rằng: Phần ngươi cùng dòng dõi ngươi, từ đời nọ sang đời kia, sẽ giữ sự giao ước của ta. ");
INSERT INTO vie1934_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mỗi người nam trong vòng các ngươi phải chịu phép cắt bì; ấy là giao ước mà các ngươi phải giữ, tức giao ước lập giữa ta và các ngươi, cùng dòng dõi sau ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Các ngươi phải chịu cắt bì; phép đó sẽ là dấu hiệu của sự giao ước giữa ta cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Trải qua các đời, mỗi người nam trong vòng các ngươi, hoặc sanh đẻ tại nhà, hoặc đem tiền ra mua nơi người ngoại bang, chẳng thuộc về dòng giống ngươi, hễ lên được tám ngày rồi, đều phải chịu phép cắt bì. ");
INSERT INTO vie1934_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Chớ khá bỏ làm phép cắt bì cho ai sanh tại trong nhà ngươi, hay đem tiền ra mua về; sự giao ước của ta sẽ lập đời đời trong xác thịt của các ngươi vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Một người nam nào không chịu phép cắt bì nơi xác thịt mình, sẽ bị truất ra khỏi ngoài dân sự mình; người đó là kẻ bội lời giao ước ta. ");
INSERT INTO vie1934_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Đức Chúa Trời phán cùng Aùp-ra-ham rằng: còn Sa-rai, vợ ngươi, chớ gọi là Sa-rai nữa; nhưng Sa-ra là tên người đó. ");
INSERT INTO vie1934_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ta sẽ ban phước cho nàng, lại do nơi nàng ta sẽ cho ngươi một con trai, Ta sẽ ban phước cho nàng, nàng sẽ làm mẹ các dân tộc; những vua của các dân tộc sẽ do nơi nàng mà ra. ");
INSERT INTO vie1934_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Aùp-ra-ham bèn sấp mình xuống đất, cười và nói thầm rằng: Hồ dễ người đã trăm tuổi rồi, mà sanh con được chăng? Còn Sa-ra, tuổi đã chín mươi, sẽ sanh sản được sao? ");
INSERT INTO vie1934_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Aùp-ra-ham thưa cùng Đức Chúa Trời rằng: Chớ chi ỗch-ma-ên vẫn được sống trước mặt Ngài! ");
INSERT INTO vie1934_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Đức Chúa Trời bèn phán rằng: Thật vậy, Sa-ra vợ ngươi, sẽ sanh một con trai, rồi ngươi đặt tên là Y-sác. Ta sẽ lập giao ước cùng nó, để làm giao ước đời đời cho dòng dõi của nó. ");
INSERT INTO vie1934_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ta cũng nhậm lời ngươi xin cho ỗch-ma-ên. Nầy, ta ban phước cho người, sẽ làm cho người sanh sản và thêm nhiều quá-bội; người sẽ là tổ phụ của mười hai vị công-hầu, và ta làm cho người thành một dân lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Nhưng ta sẽ lập giao ước ta cùng Y-sác, độ khoảng nầy năm tới Sa-ra phải sanh cho ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Khi Đức Chúa Trời đã phán xong, thì Ngài từ Aùp-ra-ham ngự lên. ");
INSERT INTO vie1934_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Chính ngày đó, Aùp-ra-ham bắt ỗch-ma-ên, con trai mình, và hết thảy các người nam trong nhà, hoặc sanh tại đó, hoặc đem tiền ra mua về, mà làm phép cắt bì cho, y như lời Đức Chúa Trời đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Vả, khi Aùp-ra-ham chịu phép cắt bì, thì đã được chín mươi chín tuổi; ");
INSERT INTO vie1934_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","còn ỗch-ma-ên, con người, khi chịu phép cắt bì, thì được mười ba tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Cũng trong một ngày đó, Aùp-ra-ham và ỗch-ma-ên chịu phép cắt bì, ");
INSERT INTO vie1934_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","và mọi người nam trong nhà, hoặc sanh tại đó, hoặc đem tiền ra mua nơi người ngoại bang, đồng chịu phép cắt bì với người. ");
INSERT INTO vie1934_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Đức Giê-hô-va hiện ra cùng Aùp-ra-ham nơi lùm cây dẻ bộp của Mam-rê, đang khi ngồi nơi cửa trại lúc trời nắng ban ngày. ");
INSERT INTO vie1934_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Aùp-ra-ham nhướng mắt lên, thấy ba người đứng trước mặt. Vừa khi thấy, bèn bắt từ cửa trại chạy đến trước mặt ba người đó, sấp mình xuống đất, ");
INSERT INTO vie1934_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","và thưa rằng: Lạy Chúa, nếu tôi được ơn trước mặt Chúa, xin hãy ghé lại nhà kẻ tôi tớ Chúa, đừng bỏ đi luôn. ");
INSERT INTO vie1934_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Xin các đấng hãy cho phép người ta lấy chút nước rửa chân các đấng, và xin hãy nằm nghỉ mát dưới cội cây nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tôi sẽ đi đem một miếng bánh cho các đấng ăn vững lòng, rồi sẽ dời gót lên đường; vì cớ ấy, nên mới quá bộ lại nhà kẻ tôi tớ các đấng vậy. Các đấng phán rằng: Hãy cứ việc làm như ngươi đã nói. ");
INSERT INTO vie1934_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Đoạn, Aùp-ra-ham lật đật vào trại đến cùng Sa-ra mà rằng: Hãy mau mau lấy ba đấu bột lọc nhồi đi, rồi làm bánh nhỏ. ");
INSERT INTO vie1934_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Aùp-ra-ham bèn chạy lại bầy, bắt một con bò con ngon, giao cho đầy tớ mau mau nấu dọn; ");
INSERT INTO vie1934_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","rồi lấy mỡ-sữa và sữa cùng con bò con đã nấu xong, dọn ngay trước mặt các đấng; còn người thì đứng hầu trước mặt, dưới cội cây. Vậy các đấng đó bèn ăn. ");
INSERT INTO vie1934_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Các đấng hỏi Aùp-ra-ham rằng: Sa-ra, vợ ngươi, ở đâu? Đáp rằng: Kìa, nàng ở trong trại kia. ");
INSERT INTO vie1934_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Một đấng nói rằng: Trong độ một năm nữa, ta sẽ trở lại đây với ngươi không sai, và chừng đó, Sa-ra, vợ ngươi, sẽ có một con trai. Sa-ra ở nơi cửa trại sau lưng đấng đó, nghe các lời nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Vả, Aùp-ra-ham cùng Sa-ra đã già, tuổi tác đã cao; Sa-ra không còn chi nữa như thế thường người đàn bà. ");
INSERT INTO vie1934_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sa-ra cười thầm mà rằng: Già như tôi thế nầy, dễ còn được điều vui đó sao? Còn chúa tôi cũng đã già rồi! ");
INSERT INTO vie1934_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Đức Giê-hô-va phán hỏi Aùp-ra-ham rằng: Cớ sao Sa-ra cười như vậy mà rằng: Có quả thật rằng tôi già đến thế nầy lại còn sanh sản chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Há có điều chi Đức Giê-hô-va làm không được chăng? Đến kỳ đã định, trong một năm nữa, ta sẽ trở lại cùng ngươi, và Sa-ra sẽ có một con trai. ");
INSERT INTO vie1934_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Vì Sa-ra sợ, nên chối mà thưa rằng: Tôi có cười đâu! Nhưng Ngài phán rằng: Thật ngươi có cười đó! ");
INSERT INTO vie1934_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Các đấng đều đứng dậy mà đi, ngó về phía, Sô-đôm. Aùp-ra-ham cũng theo để tiễn bước các đấng. ");
INSERT INTO vie1934_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Đức Giê-hô-va phán rằng: Lẽ nào ta giấu Aùp-ra-ham điều chi ta sẽ làm sao? ");
INSERT INTO vie1934_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","vì Aùp-ra-ham chắc sẽ được trở nên một dân lớn và cường thạnh; các dân tộc trên thế gian đều sẽ nhờ người mà được phước. ");
INSERT INTO vie1934_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ta đã chọn người đặng người khiến dạy các con cùng nội nhà người giữ theo đạo Đức Giê-hô-va, làm các điều công bình và ngay thẳng; thế thì, Đức Giê-hô-va sẽ làm cho ứng nghiệm lời Ngài đã hứa cùng Aùp-ra-ham. ");
INSERT INTO vie1934_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Đức Giê-hô-va phán rằng: Tiếng kêu oan về Sô-đôm và Gô-mô-rơ thật là quá, tội lỗi các thành đó thật là trọng. ");
INSERT INTO vie1934_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ta muốn ngự xuống, để xem xét chúng nó ăn ở có thật như tiếng đã kêu thấu đến ta chăng; nếu chẳng thật, thì ta sẽ biết. ");
INSERT INTO vie1934_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Vậy, các đấng bèn từ đó đi qua hướng Sô-đôm; nhưng Aùp-ra-ham hãy còn đứng chầu trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Aùp-ra-ham lại gần và thưa rằng: Chúa sẽ diệt người công bình luôn với người độc ác sao? ");
INSERT INTO vie1934_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ngộ trong thành có năm mươi người công bình, Chúa cũng sẽ diệt họ hết sao? Há chẳng tha thứ cho thành đó vì cớ năm mươi người công bình ở trong sao? ");
INSERT INTO vie1934_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Không lẽ nào Chúa làm điều như vậy, diệt người công bình luôn với kẻ độc ác; đến đỗi kể người công bình cũng như người độc ác. Không, Chúa chẳng làm điều như vậy bao giờ! Đấng đoán xét toàn thế gian, há lại không làm sự công bình sao? ");
INSERT INTO vie1934_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Đức Giê-hô-va phán rằng: Nếu ta tìm được trong Sô-đôm năm mươi người công bình, vì tình thương bấy nhiêu người đó ta sẽ tha hết cả thành. ");
INSERT INTO vie1934_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Aùp-ra-ham lại thưa rằng: mặc dầu tôi đây vốn là tro bụi, song tôi cũng dám cả gan thưa lại cùng Chúa. ");
INSERT INTO vie1934_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Hãy trong năm mươi người công bình rủi thiếu hết năm; vì cớ năm người thiếu Chúa sẽ diệt hết cả thành chăng? Ngài trả lời rằng: Nếu ta tìm được có bốn mươi lăm người, ta chẳng diệt thành đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aùp-ra-ham cứ thưa rằng: Ngộ trong thành chỉ có bốn mươi người công bình, thì sẽ ra sao? Ngài phán rằng: Ta sẽ chẳng diệt đâu, vì tình thương bốn mươi nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Aùp-ra-ham tiếp: Tôi xin Chúa đừng giận, thì tôi sẽ thưa: Ngộ trong đó chỉ có ba mươi người, thì sẽ ra sao? Ngài phán: Nếu ta tìm trong đó có ba mươi người, thì ta chẳng diệt đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aùp-ra-ham thưa rằng: Tôi đây cũng cả gan thưa cùng Chúa: Nếu chỉ có hai mươi người, thì lại làm sao? Ngài rằng: Vì tình thương hai mươi người đó, ta sẽ chẳng diệt thành đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Aùp-ra-ham lại thưa: Xin Chúa đừng giận, để cho tôi thưa chỉ một lần nầy nữa: Ngộ chỉ có mười người, thì nghĩ làm sao? Ngài phán rằng: Ta cũng sẽ chẳng diệt thành đâu, vì tình thương mười người đó. ");
INSERT INTO vie1934_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Khi Đức Giê-hô-va phán xong cùng Aùp-ra-ham, thì Ngài ngự đi; còn Aùp-ra-ham trở về trại mình. ");
INSERT INTO vie1934_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lối chiều, hai thiên sứ đến Sô-đôm; lúc đó, Lót đang ngồi tại cửa thành. Khi Lót thấy hai thiên sứ đến, đứng dậy mà đón rước và sấp mình xuống đất. ");
INSERT INTO vie1934_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Người thưa rằng: Nầy, lạy hai chúa, xin hãy đến ở nhà của kẻ tôi tớ, và hãy nghỉ đêm tại đó. Hai chúa hãy rửa chân, rồi sáng mai thức dậy lên đường. Hai thiên sứ phán rằng: Không, đêm nầy ta sẽ ở ngoài đường. ");
INSERT INTO vie1934_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nhưng Lót cố mời cho đến đỗi hai thiên sứ phải đi lại vào nhà mình. Người dâng một bữa tiệc, làm bánh không men, và hai thiên sứ bèn dùng tiệc. ");
INSERT INTO vie1934_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hai thiên sứ chưa đi nằm, mà các người nam ở Sô-đôm, từ trẻ đến già, tức cả dân, đều chạy đến bao chung quanh nhà. ");
INSERT INTO vie1934_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Bọn đó gọi Lót mà hỏi rằng: Những khách đã vào nhà ngươi buổi chiều tối nay ở đâu? Hãy dẫn họ ra đây, hầu cho chúng ta được biết. ");
INSERT INTO vie1934_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lót bèn ra đến cùng dân chúng ở ngoài cửa, rồi đóng cửa lại, ");
INSERT INTO vie1934_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","và nói cùng họ rằng: Nầy, tôi xin anh em đừng làm điều ác đó! ");
INSERT INTO vie1934_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Đây, tôi sẵn có hai con gái chưa chồng, tôi sẽ đưa chúng nó cho anh em, rồi mặc tình anh em tính làm sao tùy ý; miễn đừng làm chi hại cho hai người kia; vì cớ đó, nên họ đến núp bóng mái nhà tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bọn dân chúng nói rằng: Ngươi hãy tránh chỗ khác! Lại tiếp rằng: Người nầy đến đây như kẻ kiều ngụ, lại muốn đoán xét nữa sao! Vậy, thôi! chúng ta sẽ đãi ngươi bạc-tệ hơn hai khách kia. Đoạn, họ lấn ép Lót mạnh quá, và tràn đến đặng phá cửa. ");
INSERT INTO vie1934_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Nhưng hai thiên sứ giơ tay ra, đem Lót vào nhà, và đóng cửa lại, ");
INSERT INTO vie1934_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","đoạn, hành phạt bọn dân chúng ở ngoài cửa, từ trẻ đến già, đều quáng lòa mắt, cho đến đỗi tìm cửa mệt mà không được. ");
INSERT INTO vie1934_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Hai thiên sứ bèn hỏi Lót rằng: Ngươi còn có ai tại đây nữa chăng? Rể, con trai, con gái và ai trong thành thuộc về ngươi, hãy đem ra khỏi hết đi! ");
INSERT INTO vie1934_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Chúng ta sẽ hủy diệt chỗ nầy, vì tiếng kêu oan về dân thành nầy đã thấu lên đến Đức Giê-hô-va, nên Ngài sai chúng ta xuống mà hủy diệt. ");
INSERT INTO vie1934_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lót bèn đi ra và nói cùng rể đã cưới con gái mình rằng: Hãy chổi dậy, đi ra khỏi chốn nầy, vì Đức Giê-hô-va sẽ hủy diệt thành. Nhưng các chàng rể tưởng người nói chơi. ");
INSERT INTO vie1934_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Đến sáng, hai thiên sứ hối Lót và phán rằng: Hãy thức dậy, dẫn vợ và hai con gái ngươi đang ở đây ra, e khi ngươi cũng chết lây về việc hình phạt của thành nữa chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Nhưng Lót lần lữa; vì cớ Đức Giê-hô-va thương xót Lót, nên hai thiên sứ nắm lấy tai kéo người, vợ cùng hai con gái người, và dẫn ra khỏi thành. ");
INSERT INTO vie1934_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Vả, khi hai thiên sứ dẫn họ ra khỏi rồi, một trong hai vì nói rằng: Hãy chạy trốn cứu lấy mạng, đừng ngó lại sau và cũng đừng dừng bước lại nơi nào ngoài đồng bằng; hãy chạy trốn lên núi, kẻo phải bỏ mình chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lót đáp lại rằng: Lạy Chúa, không được! ");
INSERT INTO vie1934_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nầy, tôi tớ đã được ơn trước mặt Chúa; Chúa đã tỏ lòng nhân từ rất lớn cùng tôi mà cứu tròn sự sống tôi. Nhưng tôi chạy trốn lên núi không kịp trước khi tai nạn đến, thì tôi phải chết. ");
INSERT INTO vie1934_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kìa, thành kia đã nhỏ, lại cũng gần đặng tôi có thế ẩn mình. Oâi! chớ chi Chúa cho tôi ẩn đó đặng cứu tròn sự sống tôi. Thành nầy há chẳng phải nhỏ sao? ");
INSERT INTO vie1934_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Thiên sứ phán rằng: Đây, ta ban ơn nầy cho ngươi nữa, sẽ không hủy diệt thành của ngươi đã nói đó đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Mau mau hãy lại ẩn đó, vì ta không làm chi được khi ngươi chưa vào đến nơi. Bởi cớ ấy, nên người ta gọi tên thành nầy là Xoa. ");
INSERT INTO vie1934_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Khi mặt trời mọc lên khỏi đất, thì Lót vào đến thành Xoa. ");
INSERT INTO vie1934_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Đoạn, Đức Giê-hô-va giáng mưa diêm sanh và lửa từ nơi Ngài trên trời sa xuống Sô-đôm và Gô-mô-rơ, ");
INSERT INTO vie1934_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","hủy diệt hai thành nầy, cả đồng bằng, hết thảy dân sự cùng các cây cỏ ở nơi đất đó. ");
INSERT INTO vie1934_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Nhưng vợ của Lót quay ngó lại đặng sau mình, nên hóa ra một tượng muối. ");
INSERT INTO vie1934_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Aùp-ra-ham dậy sớm, đi đến nơi mà người đã đứng chầu Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ngó về hướng Sô-đôm và Gô-mô-rơ, cùng khắp xứ ở đồng bằng, thì thấy từ dưới đất bay lên một luồng khói, như khói của một lò lửa lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Vả, khi Đức Chúa Trời hủy diệt các thành nơi đồng bằng, tức là thành Lót ở, thì nhớ đến Aùp-ra-ham, cứu Lót ra khỏi chốn phá tan đó. ");
INSERT INTO vie1934_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lót ở Xoa thì sợ hãi, nên cùng hai con gái mình bỏ đó mà lên núi, ở trong một hang đá kia. ");
INSERT INTO vie1934_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Cô lớn nói cùng em mình rằng: Cha ta đã già, mà không còn ai trên mặt đất đến sánh duyên cùng ta theo như thế thường thiên hạ. ");
INSERT INTO vie1934_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hè! chúng ta hãy phục rượu cho cha, và lại nằm cùng người, để lưu truyền dòng giống cha lại. ");
INSERT INTO vie1934_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Đêm đó, hai nàng phục rượu cho cha mình; nàng lớn đến nằm cùng cha; nhưng người chẳng hay lúc nào nàng nằm, lúc nào nàng dậy hết. ");
INSERT INTO vie1934_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Qua ngày mai, chị nói cùng em rằng: Nầy, đêm hôm qua ta đã nằm cùng cha rồi; hôm nay chúng ta hãy phục rượu cho cha nữa, rồi em hãy lại nằm cùng người, để lưu truyền dòng giống cha lại. ");
INSERT INTO vie1934_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Đêm đó, hai nàng lại phục rượu cho cha mình nữa, rồi nàng nhỏ thức dậy lại nằm cùng cha; nhưng người chẳng hay lúc nào nàng nằm, lúc nào nàng dậy hết. ");
INSERT INTO vie1934_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Vậy, hai con gái của Lót do nơi cha mình mà thọ thai. ");
INSERT INTO vie1934_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nàng lớn sanh được một con trai, đặt tên là Mô-áp; ấy là tổ phụ của dân Mô-áp đến bây giờ. ");
INSERT INTO vie1934_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Người em cũng sanh đặng một con trai, đặt tên là Bên-Am-mi; ấy là tổ phụ của dân Am-môn đến bây giờ. ");
INSERT INTO vie1934_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aùp-ra-ham từ đó đi đến miền Nam, kiều ngụ tại Ghê-ra, ở về giữa khoảng Ca-đe và Su-rơ. ");
INSERT INTO vie1934_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Aùp-ra-ham nói về Sa-ra, vợ mình rằng: Nó là em gái tôi. A-bi-mê-léc, vua Ghê-ra sai người bắt Sa-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Nhưng trong cơn chiêm bao ban đêm, Đức Chúa Trời hiện đến cùng vua A-bi-mê-léc mà phán rằng: Nầy, ngươi sẽ chết bởi cớ người đàn bà mà ngươi đã bắt đến; vì nàng có chồng rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Vả, vua A-bi-mê-léc chưa đến gần người đó, nên thưa rằng: Lạy Chúa, Chúa há sẽ hủy diệt cả một dân công bình chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Người đó há chẳng nói với tôi rằng: ấy là em gái tôi chăng? và chính người nữ há chẳng nói rằng: ấy là anh tôi sao? Tôi làm sự nầy bởi lòng ngay thẳng và tay thanh khiết của tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Trong cơn chiêm bao, Đức Chúa Trời phán nữa rằng: Ta cũng biết ngươi vì lòng ngay thẳng mà làm điều đó; bởi cớ ấy, ta mới ngăn trở ngươi phạm tội cùng ta, và không cho động đến người đó. ");
INSERT INTO vie1934_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Bây giờ, hãy giao đàn bà đó lại cho chồng nó, vì chồng nó là một đấng tiên tri, sẽ cầu nguyện cho ngươi, thì ngươi mới được sống. Còn như không giao lại, thì phải biết rằng ngươi và hết thảy ai thuộc về ngươi quả hẳn sẽ chết. ");
INSERT INTO vie1934_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Vua A-bi-mê-léc dậy sớm, đòi các tôi tớ mình đến, thuật lại hết mọi lời, thì họ lấy làm kinh ngạc. ");
INSERT INTO vie1934_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Rồi, A-bi-mê-léc đòi Aùp-ra-ham mà nói rằng: Ngươi đã làm gì cho ta vậy? Ta có làm điều chi mất lòng chăng mà ngươi làm cho ta và cả nước phải bị một việc phạm tội lớn dường nầy? Đối cùng ta, ngươi đã làm những việc không nên làm đó. ");
INSERT INTO vie1934_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Vua A-bi-mê-léc lại nói cùng Aùp-ra-ham rằng: Ngươi có ý gì mà làm như vậy? ");
INSERT INTO vie1934_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Aùp-ra-ham đáp: Tôi tự nghĩ rằng: Trong xứ nầy thật không có ai kính sợ Đức Chúa Trời, thì họ sẽ vì cớ vợ tôi mà giết tôi chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Nhưng nó cũng thật là em gái tôi, em một cha khác mẹ; và tôi cưới nó làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Khi Đức Chúa Trời làm cco tôi pưu lạc xa nhà cha, thì tôi có nói với nàng rằng: Nầy là ơn của ngươi sẽ làm cho ta: Hễ chỗ nào chúng ta sẽ đi đến, hãy nói về ta: Aáy là anh tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Đoạn, vua A-bi-mê-léc đem chiên và bò, tôi trai cùng tớ gái cho Aùp-ra-ham, và trả Sa-ra vợ người lại, mà phán rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Nầy, xứ ta sẵn dành cho ngươi; ngươi thích đâu thì ở đó. ");
INSERT INTO vie1934_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Rồi vua phán cùng Sa-ra rằng: Đây, ta ban cho anh ngươi một ngàn miếng bạc; số tiền đó dùng cho ngươi như một bức màn che trước mắt về mọi việc đã xảy ra cùng ngươi; và mọi người đều sẽ cho ngươi là công bình. ");
INSERT INTO vie1934_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Aùp-ra-ham cầu xin Đức Chúa Trời, thì Ngài chữa bịnh cho vua A-bi-mê-léc, vợ cùng các con đòi người; vậy, họ đều có con. ");
INSERT INTO vie1934_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Vả, lúc trước, vì vụ Sa-ra, vợ Aùp-ra-ham, nên Đức Giê-hô-va làm cho cả nhà vua A-bi-mê-léc đều son sẻ. ");
INSERT INTO vie1934_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Đức Giê-hô-va đến viếng Sa-ra, theo như lời Ngài đã phán, và làm cho nàng như lời Ngài đã nói. ");
INSERT INTO vie1934_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sa-ra thọ thai, sanh một con trai cho Aùp-ra-ham trong khi tuổi đã già, đúng kỳ Đức Chúa Trời đã định. ");
INSERT INTO vie1934_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aùp-ra-ham đặt tên đứa trai mà Sa-ra đã sanh cho mình là Y-sác. ");
INSERT INTO vie1934_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Đúng tám ngày, Aùp-ra-ham làm phép cắt bì cho Y-sác theo như lời Đức Chúa Trời đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Vả, khi Y-sác ra đời, thì Aùp-ra-ham đã được một trăm tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sa-ra nói rằng: Đức Chúa Trời làm cho tôi một việc vui cười; hết thảy ai hay được cũng sẽ vui cười về sự của tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Lại nói rằng: Há ai dám nói với Aùp-ra-ham rằng Sa-ra sẽ cho con bú ư? vì tôi đã sanh một đứa trai trong lúc người già yếu rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Đứa trẻ lớn lên, thì thôi bú. Chính ngày Y-sác thôi bú, Aùp-ra-ham bày một tiệc lớn ăn mừng. ");
INSERT INTO vie1934_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sa-ra thấy đứa trai của A-ga, người Ê-díp-tô, đã sanh cho Aùp-ra-ham, cười cợt, ");
INSERT INTO vie1934_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","thì người nói với Aùp-ra-ham rằng: Hãy đuổi con đòi với con nó đi đi, vì đứa trai của con đòi nầy sẽ chẳng được kế nghiệp cùng con trai tôi là Y-sác đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Lời nầy lấy làm buồn lòng Aùp-ra-ham lắm, vì cớ con trai mình. ");
INSERT INTO vie1934_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Nhưng Đức Chúa Trời phán cùng Aùp-ra-ham rằng: Ngươi chớ buồn bực vì con trai và con đòi ngươi. Sa-ra nói thể nào, hãy nghe theo tiếng người nói; vì do nơi Y-sác sẽ sanh ra dòng dõi lưu danh ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ta cũng sẽ làm cho đứa trai của con đòi trở nên một dân, vì nó cũng do nơi ngươi mà ra. ");
INSERT INTO vie1934_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Aùp-ra-ham dậy sớm, lấy bánh và một bầu nước, đưa cho A-ga; để các món đó trên vai nàng, và giao đứa trai cho nàng, rồi đuổi đi. Nàng ra đi, đi dông dài trong đồng vắng Bê-e-Sê-ba. ");
INSERT INTO vie1934_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Khi nước trong bầu đã hết, nàng để đứa trẻ dưới một cội cây nhỏ kia, ");
INSERT INTO vie1934_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","đi ngồi đối diện cách xa xa dài chừng một khoảng tên bắn; vì nói rằng: Oâi! tôi nỡ nào thấy đứa trẻ phải chết! Nàng ngồi đối diện đó, cất tiếng la khóc. ");
INSERT INTO vie1934_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Đức Chúa Trời nghe tiếng đứa trẻ khóc, thì thiên sứ của Đức Chúa Trời từ trên trời kêu nàng A-ga mà phán rằng: Hỡi A-ga! Ngươi có điều gì vậy? Chớ sợ chi, vì Đức Chúa Trời đã nghe tiếng đứa trẻ ở đâu đó rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Hãy đứng dậy đỡ lấy đứa trẻ và giơ tay nắm nó, vì ta sẽ làm cho nó nên một dân lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Đoạn, Đức Chúa Trời mở mắt nàng ra; nàng bèn thấy một cái giếng nước, và đi lại múc đầy bầu cho đứa trẻ uống. ");
INSERT INTO vie1934_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Đức Chúa Trời vùa giúp đứa trẻ; nó lớn lên, ở trong đồng vắng, có tài bắn cung. ");
INSERT INTO vie1934_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nó ở tại trong đồng vắng Pha-ran; mẹ cưới cho nó một người vợ quê ở xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Về thuở đó, vua A-bi-mê-léc và Phi-côn, quan tổng binh mình, nói cùng Aùp-ra-ham rằng: Đức Chúa Trời vùa giúp ngươi trong mọi việc ngươi làm. ");
INSERT INTO vie1934_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Vậy bây giờ, hãy chỉ danh Đức Chúa Trời mà thề rằng: Ngươi sẽ chẳng gạt ta, con ta cùng dòng giống ta. Nhưng ngươi sẽ đãi ta và xứ ngươi đang trú ngụ, một lòng tử tế như ta đã đãi ngươi vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aùp-ra-ham đáp rằng: Tôi xin thề. ");
INSERT INTO vie1934_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Aùp-ra-ham phàn nàn cùng vua A-bi-mê-léc về vụ một giếng kia bị đầy tớ người chiếm đoạt. ");
INSERT INTO vie1934_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Vua A-bi-mê-léc bèn nói rằng: Ta chẳng hay ai đã làm nên nông nổi đó; chính ngươi chẳng cho ta hay trước; ngày nay ta mới rõ đây mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Đoạn, Aùp-ra-ham bắt chiên và bò, dâng cho vua A-bi-mê-léc; rồi hai người kết ước cùng nhau. ");
INSERT INTO vie1934_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Aùp-ra-ham lựa để riêng ra bảy con chiên tơ trong bầy; ");
INSERT INTO vie1934_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","thì vua A-bi-mê-léc hỏi rằng: Làm chi để bảy con chiên tơ đó riêng ra vậy? ");
INSERT INTO vie1934_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Đáp rằng: Xin vua hãy nhận lấy bảy con chiên tơ nầy mà chính tay tôi dâng cho, đặng làm chứng rằng tôi đã đào cái giếng nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Bởi cớ ấy, nên họ đặt tên chỗ nầy là Bê-e-Sê-ba; vì tại đó hai người đều đã thề nguyện cùng nhau. ");
INSERT INTO vie1934_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Vậy, hai người kết ước cùng nhau tại Bê-e-Sê-ba. Đoạn vua A-bi-mê-léc cùng quan tổng binh Phi-côn đứng dậy, trở về xứ Phi-li-tin. ");
INSERT INTO vie1934_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Aùp-ra-ham trồng một cây me tại Bê-e-Sê-ba, và ở đó người cầu khẩn danh Đức Giê-hô-va, là Đức Chúa Trời hằng-hữu. ");
INSERT INTO vie1934_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Aùp-ra-ham trú ngụ lâu ngày tại xứ Phi-li-tin. ");
INSERT INTO vie1934_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Khi mọi việc kia đã xong, thì Đức Chúa Trời thử Aùp-ra-ham; Ngài phán rằng: Hỡi Aùp-ra-ham! Người thưa rằng: Có tôi đây. ");
INSERT INTO vie1934_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Đức Chúa Trời phán rằng: Hãy bắt đứa con một ngươi yêu dấu, là Y-sác, và đi đến xứ Mô-ri-a, nơi đó dâng đứa con làm của lễ thiêu ở trên một hòn núi kia mà ta sẽ chỉ cho. ");
INSERT INTO vie1934_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Aùp-ra-ham dậy sớm, thắng lừa, đem hai đầy tớ và con mình, là Y-sác, cùng đi; người cũng chặt củi để dùng về của lễ thiêu, rồi đi đến nơi mà Đức Chúa Trời đã truyền dạy. ");
INSERT INTO vie1934_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Qua đến ngày thứ ba, Aùp-ra-ham nhướng mắt lên thấy nơi đó ở lối đằng xa, ");
INSERT INTO vie1934_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","thì nói cùng hai kẻ đầy tớ rằng: Hãy ở lại đây với con lừa; ta cùng đứa trẻ sẽ đi đến chốn kia đặng thờ phượng, rồi sẽ trở lại với hai ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aùp-ra-ham lấy củi về của lễ thiêu, chất trên Y-sác, con mình; rồi người cầm lửa và dao trong tay, và cả hai cha con đồng đi. ");
INSERT INTO vie1934_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Y-sác bèn nói cùng Aùp-ra-ham, cha mình rằng: Hỡi Cha! Người đáp: Con ơi! cha đây. Y-sác nói: Củi đây, lửa đây, nhưng chiên con đâu có đặng làm của lễ thiêu? ");
INSERT INTO vie1934_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aùp-ra-ham rằng: Con ơi! chính Đức Chúa Trời sẽ sắm sẵn lấy chiên con đặng dùng làm của lễ thiêu; rồi cả hai cha con cứ đồng đi. ");
INSERT INTO vie1934_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Họ đến chốn Đức Chúa Trời đã phán dạy; tại đó, Aùp-ra-ham lập bàn thờ, chất củi lên, trói Y-sác con mình lại, để lên đống củi trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Aùp-ra-ham bèn giơ tay ra cầm lấy dao đặng giết con mình. ");
INSERT INTO vie1934_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Thiên sứ của Đức Giê-hô-va từ trên trời kêu xuống mà rằng: Hỡi Aùp-ra-ham, Aùp-ra-ham! Người thưa rằng: Có tôi đây. ");
INSERT INTO vie1934_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Thiên sứ phán rằng: Đừng tra tay vào mình con trẻ và chớ làm chi hại đến nó; vì bây giờ ta biết rằng ngươi thật kính sợ Đức Chúa Trời, bởi cớ không tiếc với ta con ngươi, tức con một ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aùp-ra-ham nhướng mắt lên, xem thấy sau lưng một con chiên đực, sừng mắc trong bụi cây, bèn bắt con chiên đực đó dâng làm của lễ thiêu thay cho con mình. ");
INSERT INTO vie1934_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Aùp-ra-ham gọi chỗ đó là Giê-hô-va Di-rê. Bởi cớ ấy, ngày nay có tục ngữ rằng: Trên núi của Đức Giê-hô-va sẽ có sắm sẵn. ");
INSERT INTO vie1934_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Thiên sứ của Đức Giê-hô-va từ trên trời kêu Aùp-ra-ham lần thứ nhì mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Đức Giê-hô-va phán rằng: Vì ngươi đã làm điều đó, không tiếc con ngươi, tức con một ngươi, thì ta lấy chính mình ta mà thề rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","sẽ ban phước cho ngươi, thêm dòng dõi ngươi nhiều như sao trên trời, đông như cát bờ biển, và dòng dõi đó sẽ chiếm được cửa thành quân nghịch. ");
INSERT INTO vie1934_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Bởi vì ngươi đã vâng theo lời dặn ta, nên các dân thế gian đều sẽ nhờ dòng dõi ngươi mà được phước. ");
INSERT INTO vie1934_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Đoạn Aùp-ra-ham trở về nơi hai người đầy tớ; họ đứng dậy, đồng nhau đi về Bê-e-Sê-ba. Aùp-ra-ham cứ ở tại Bê-e-Sê-ba. ");
INSERT INTO vie1934_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sau các việc đó, người ta thuật lại với Aùp-ra-ham tin nầy rằng: Nầy, nàng Minh-ca cũng sanh con cho em ngươi, là Na-cô. ");
INSERT INTO vie1934_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Con trưởng nam là Uùt-xơ, em trai là Bu-xơ, Kê-mu-ên, cha của A-ram; ");
INSERT INTO vie1934_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kê-sết, Ha-xô, Phin-đát, Díp-láp và Bê-tu-ên; ");
INSERT INTO vie1934_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bê-tu-ên là người sanh Rê-be-ca. Minh-ca sanh tám người con trai đó cho Na-cô, em của Aùp-ra-ham. ");
INSERT INTO vie1934_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Còn người vợ nhỏ, tên là Rê-u-ma, cũng sanh con, là Tê-la, Ga-ham, Ta-hách và Ma-a-ca. ");
INSERT INTO vie1934_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sa-ra hưởng thọ được một trăm hai mươi bảy tuổi. Aáy là bao nhiêu năm của đời Sa-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sa-ra qua đời tại Ki-ri-át-A-ra-ba, tức là Hếp-rôn, thuộc về xứ Ca-na-an. Aùp-ra-ham đến chịu tang cho Sa-ra và than khóc người. ");
INSERT INTO vie1934_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Đoạn, Aùp-ra-ham đứng dậy trước người chết mình và nói cùng dân họ Hếch rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Ta là một khách kiều ngụ trong vòng các ngươi; xin hãy cho một nơi mộ địa trong xứ các ngươi, để chôn người thác của ta. ");
INSERT INTO vie1934_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Dân họ Hếch đáp rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Lạy Chúa, xin hãy nghe chúng tôi: giữa chúng tôi, chúa tức là một quân trưởng của Đức Chúa Trời; hãy chôn người chết của chúa nơi mộ địa nào tốt hơn hết của chúng tôi. Trong bọn chúng tôi chẳng có ai tiếc mộ địa mình, đặng chôn người chết của chúa đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Aùp-ra-ham bèn đứng dậy, sấp mình xuống trước mặt các dân của xứ, tức dân họ Hếch, ");
INSERT INTO vie1934_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","mà nói rằng: Nếu các ngươi bằng lòng cho chôn người chết ta, thì hãy nghe lời, và cầu xin Eùp-rôn, con của Xô-ha giùm ta, ");
INSERT INTO vie1934_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","đặng người nhượng cho ta hang đá Mặc-bê-la, ở về tận đầu đồng người, để lại cho đúng giá, hầu cho ta được trong vòng các ngươi một nơi mộ địa. ");
INSERT INTO vie1934_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Vả, Eùp-rôn, người Hê-tít, đang ngồi trong bọn dân họ Hếch, đáp lại cùng Aùp-ra-ham trước mặt dân họ Hếch vẫn nghe và trước mặt mọi người đến nơi cửa thành, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Không, thưa chúa, hãy nghe lời tôi: Hiện trước mặt dân tôi, tôi xin dâng cho chúa cánh đồng, và cũng dâng luôn cái hang đá ở trong đó nữa; hãy chôn người chết của chúa đi. ");
INSERT INTO vie1934_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Aùp-ra-ham sấp mình xuống trước mặt dân của xứ, ");
INSERT INTO vie1934_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","và nói lại cùng Eùp-rôn hiện trước mặt dân của xứ đang nghe, mà rằng: Xin hãy nghe, ta trả giá tiền cái đồng, hãy nhận lấy đi, thì ta mới chôn người chết ta, ");
INSERT INTO vie1934_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eùp-rôn đáp rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Thưa Chúa, hãy nghe lời tôi: một miếng đất giá đáng bốn trăm siếc-lơ bạc, mà tôi cùng chúa, thì có giá chi đâu? Xin hãy chôn người chết của chúa đi. ");
INSERT INTO vie1934_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aùp-ra-ham nghe theo lời Eùp-rôn, trước mặt dân họ Hếch cân bốn trăm siếc-lơ bạc cho người, là bạc thông dụng nơi các tay buôn bán. ");
INSERT INTO vie1934_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Vậy, cái đồng của Eùp-rôn, tại Mặc-bê-la, nằm ngang Mam-rê, nghĩa là cái đồng ruộng hang đá, các cây cối ở trong và chung quanh theo giới hạn đồng, ");
INSERT INTO vie1934_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","đều trước mặt có các dân họ Hếch cùng mọi người đến cửa thành, nhận chắc cho Aùp-ra-ham làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Sau các việc đó, Aùp-ra-ham chôn Sa-ra, vợ mình, trong hang đá của đồng Mặc-bê-la, nằm ngang Nam-rê tại Hếp-rôn, thuộc về xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Đồng và hang đá đều có các người họ Hếch nhận chắc, để lại cho Aùp-ra-ham dùng làm mộ địa. ");
INSERT INTO vie1934_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Vả, Aùp-ra-ham đã già, tuổi đã cao; trong mọi việc Đức Giê-hô-va đã ban phước cho người. ");
INSERT INTO vie1934_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Aùp-ra-ham nói cùng người đầy tớ ở lâu hơn hết trong nhà mình, có quyền quản trị các gia tài, mà rằng: Xin hãy đặt tay lên đùi ta, ");
INSERT INTO vie1934_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","và ta sẽ biểu ngươi chỉ Đức Giê-hô-va, là Đức Chúa Trời của trời và đất, mà thề rằng: ngươi không cưới một cô nào trong bọn con gái của dân Ca-na-an, tức giữa dân ấy ta trú ngụ, làm vợ cho con trai ta. ");
INSERT INTO vie1934_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nhưng hãy đi về quê hương ta, trong vòng bà con ta, cưới một người vợ cho Y-sác, con trai ta. ");
INSERT INTO vie1934_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Người đầy tớ thưa rằng: Có lẽ người con gái không khứng theo tôi về xứ nầy; vậy, có phải tôi dẫn con trai ông đến xứ mà ông đã ra đi khỏi chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aùp-ra-ham nói rằng: Hãy cẩn thận, đừng dẫn con ta về xứ đó! ");
INSERT INTO vie1934_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Giê-hô-va Đức Chúa Trời trên trời, là Đấng đã đem ta ra khỏi nhà cha ta và xứ sở ta, có phán và thề rằng: Ta sẽ cho dòng dõi ngươi xứ nầy! Chính Ngài sẽ sai thiên sứ đi trước ngươi, và nơi đó ngươi hãy cưới một vợ cho con trai ta. ");
INSERT INTO vie1934_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Nếu người con gái không khứng theo, thì ngươi sẽ khỏi mắc lời của ta biểu ngươi thề; mà dẫu thế nào đi nữa, chớ đem con ta về chốn đó. ");
INSERT INTO vie1934_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Đoạn, người đầy tớ để tay lên đùi Aùp-ra-ham chủ mình, và thề sẽ làm theo như lời người đã dặn biểu. ");
INSERT INTO vie1934_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Đoạn, người đầy tớ bắt mười con lạc đà trong bầy của chủ mình, đem theo đủ các tài vật của chủ đã giao, rồi đứng dậy đi qua xứ Mê-sô-bô-ta-mi, đến thành của Na-cô. ");
INSERT INTO vie1934_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Người cho lạc đà nằm quì gối xuống nghỉ ở ngoài thành, gần bên một giếng kia, vào buổi chiều, đến giờ của những con gái ra đi xách nước. ");
INSERT INTO vie1934_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Người nói rằng: Hỡi Giê-hô-va, Đức Chúa Trời của chủ Aùp-ra-ham tôi ơi! xin ngày nay cho tôi gặp điều mà tôi tìm kiếm, và hãy làm ơn cho chủ Aùp-ra-ham tôi! ");
INSERT INTO vie1934_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nầy, tôi đứng gần bên giếng nầy, các con gái của dân trong thành sẽ ra đi xách nước, ");
INSERT INTO vie1934_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","xin cho người gái trẻ nào mà tôi nói như vầy: “Xin nàng hãy nghiêng bình, cho tôi uống nhờ hớp nước,” mà nàng trả lời rằng: “Hãy uống đi, rồi tôi sẽ cho các lạc đà ngươi uống nữa,” là chính người mà Chúa đã định cho Y-sác, kẻ tôi tớ Ngài; và nhờ đó tôi sẽ biết rằng Chúa đã làm ơn cho chủ tôi vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Người đầy tớ chưa dứt lời, nầy, nàng Rê-be-ca vác bình trên vai đi ra. Nàng là con gái của Bê-tu-ên, Bê-tu-ên là con trai của Minh-ca, vợ Na-cô, em trai của Aùp-ra-ham. ");
INSERT INTO vie1934_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Người gái trẻ đó thật rất đẹp, còn đồng trinh, chưa gả cho ai. Nàng xuống giếng nhận đầy bình nước, rồi trở lên. ");
INSERT INTO vie1934_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Đầy tớ bèn chạy lại trước mặt nàng và nói rằng: Xin hãy cho tôi uống một hớp nước trong bình. ");
INSERT INTO vie1934_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nàng đáp rằng: Thưa chúa, hãy uống đi; rồi nàng lật đật đỡ bình xuống tay và cho người uống. ");
INSERT INTO vie1934_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Khi đỡ cho người uống xong rồi, nàng lại tiếp rằng: Tôi cũng sẽ xách cho mấy con lạc đà chúa uống nữa, chừng nào uống đã thì thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nàng lật đật đổ nước bình ra máng, chạy xuống giếng xách nước thêm nữa cho hết thảy các con lạc đà uống. ");
INSERT INTO vie1934_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Còn người ngồi làm thinh mà nhìn nàng, để cho biết Đức Giê-hô-va làm thành công việc mình đi đây hay chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Khi lạc đà vừa thôi uống, người đầy tớ bèn lấy một khoanh vàng nặng được nửa siếc-lơ và đôi xuyến nặng được mười siếc-lơ, ");
INSERT INTO vie1934_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","mà nói rằng: Nàng là con ai? xin nói cho tôi biết. Trong nhà cha nàng có chỗ nào cho tôi ở nghỉ ban đêm chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nàng đáp rằng: Tôi là con gái của Bê-tu-ên, cháu nội của Minh-ca và Na-cô. ");
INSERT INTO vie1934_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Rồi lại nói: Nhà chúng tôi có nhiều rơm và cỏ, và cũng có chỗ để cho ở nghỉ nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Người bèn cúi đầu và sấp mình xuống trước mặt Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","mà nói rằng: Đáng ngợi khen thay Giê-hô-va, là Đức Chúa Trời của chủ Aùp-ra-ham tôi! Ngài chẳng ngớt thương xót và thành thực đối cùng chủ tôi! Khi đang đi, Đức Giê-hô-va dẫn dắt tôi đến nhà anh em của chủ tôi vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Người gái trẻ đó chạy về, thuật chuyện nầy lại cho nội nhà mẹ mình. ");
INSERT INTO vie1934_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Vả, nàng Rê-be-ca có một anh, tên là La-ban. La-ban chạy đến người đầy tớ đó ở gần bên giếng. ");
INSERT INTO vie1934_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Vừa thấy khoanh vàng và đôi xuyến nơi tay em gái mình, và đã nghe chuyện Rê-be-ca thuật lại rằng: Người nầy nói vậy! thì đi đến người, đang đứng gần bên mấy con lạc đà, ở nơi giếng nước, ");
INSERT INTO vie1934_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","mà thưa rằng: Hỡi người đã được Đức Giê-hô-va ban phước! Xin mời vào. Sao đứng ngoài nầy vậy? Tôi đã sửa soạn nhà và dọn-dẹp một nơi cho mấy con lạc đà rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Người đầy tớ bèn vào nhà; La-ban cổi yên cho lạc đà, đem cỏ cùng rơm cho các thú đó; rồi lấy nước đặng rửa chân cho người đầy tớ và mấy kẻ đi theo. ");
INSERT INTO vie1934_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Đoạn, người nhà bày bữa và mời ăn; nhưng người đầy tớ nói: Không, tôi không ăn đâu, nếu chưa nói được những điều tôi cần phải nói. La-ban đáp rằng: Hãy nói đi! ");
INSERT INTO vie1934_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Người bèn nói rằng: Tôi là đầy tớ của Aùp-ra-ham. ");
INSERT INTO vie1934_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Đức Giê-hô-va đã ban phước cho chủ tôi bội phần, trở nên thạnh vượng; Ngài cho chủ tôi chiên, bò, bạc, vàng, tôi trai tớ gái, lạc đà và lừa. ");
INSERT INTO vie1934_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Vả, Sa-ra, vợ chủ tôi, trở về già, có sanh một con trai cho người; người đã giao gia tài mình lại hết cho con trai đó. ");
INSERT INTO vie1934_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Chủ tôi lại có bắt tôi thề rằng: Ngươi chớ cưới cho con trai ta một người vợ nào trong bọn con gái của dân Ca-na-an, là xứ ta đang trú ngụ; ");
INSERT INTO vie1934_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","nhưng hãy về nhà cha ta, trong vòng bà con ta, mà cưới cho nó một người vợ tại đó. ");
INSERT INTO vie1934_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tôi nói cùng chủ tôi rằng: Có lẽ người con gái không khứng theo tôi về. ");
INSERT INTO vie1934_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Chủ đáp rằng: Đức Giê-hô-va là Đấng ta phục sự sẽ sai thiên sứ theo ngươi, làm cho thành công việc ngươi đi; và ngươi sẽ cưới cho con trai ta một người vợ trong vòng bà con ta, tại nhà cha ta. ");
INSERT INTO vie1934_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Vậy, nếu khi ngươi đi về bà con ta, mà họ không khứng gả cho, thì ngươi sẽ được gỡ lời thề nặng của ngươi đã thề cùng ta đó. ");
INSERT INTO vie1934_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ngày nay, khi đi đến giếng kia, tôi có cầu rằng: Lạy Đức Giê-hô-va, Đức Chúa Trời của chủ Aùp-ra-ham tôi! Xin đoái đến mà giúp công việc của tôi đi đây cho được thành! ");
INSERT INTO vie1934_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nầy, tôi ngồi gần bên giếng nầy: cầu xin hễ người gái trẻ nào sẽ ra xách nước mà tôi nói cùng nàng rằng: Xin cho tôi uống một hớp nước trong bình; ");
INSERT INTO vie1934_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","mà sẽ trả lời rằng: Hãy uống đi, rồi tôi sẽ xách cho các lạc đà ngươi uống nữa, xin cho người gái trẻ đó là vợ mà Đức Giê-hô-va đã định cho con trai của chủ tôi! ");
INSERT INTO vie1934_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Chưa dứt lời thầm nguyện, bỗng đâu nàng Rê-be-ca vác bình trên vai đi ra, xuống giếng xách nước. Tôi nói với nàng rằng: Xin cho tôi uống hớp nước. ");
INSERT INTO vie1934_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Nàng lật đật hạ bình trên vai xuống mà nói rằng: Hãy uống đi, rồi tôi sẽ cho các lạc đà ngươi uống nữa; vậy tôi có uống và nàng cũng có cho các lạc đà uống nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Tôi bèn hỏi nàng rằng: Nàng là con gái ai? Nàng đáp: Tôi là con gái của Bê-tu-ên, cháu nội của Na-cô và Minh-ca. Tôi liền đeo cái khoanh nơi lỗ mũi và đôi xuyến vào tay nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Đoạn, tôi cúi đầu và sấp mình xuống trước mặt Đức Giê-hô-va, ngợi khen Giê-hô-va Đức Chúa Trời của chủ Aùp-ra-ham tôi, mà đã dẫn tôi vào đường chính đáng, để chọn được cho con trai người con gái của em chủ tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Vậy, bây giờ, nếu các ông muốn lấy lòng tử tế và trung tín đối cùng chủ tôi, xin hãy tỏ điều đó cho, dầu không, xin cũng nói cho biết, hầu cho tôi sẽ xây về bên hữu hay là về bên tả. ");
INSERT INTO vie1934_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","La-ban và Bê-tu-ên đáp rằng: Điều đó do nơi Đức Giê-hô-va mà ra, chúng tôi đâu nói được cùng ngươi rằng quấy hay rằng phải. ");
INSERT INTO vie1934_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kìa, Rê-be-ca đang ở trước mặt ngươi, hãy dẫn nó đi, để nó được làm vợ của con trai chủ ngươi, theo như lời Đức Giê-hô-va phán định. ");
INSERT INTO vie1934_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Đầy tớ của Aùp-ra-ham vừa nghe lời hai người nói xong, liền sấp mình xuống đất trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Người lấy đồ trang sức bằng bạc, vàng, và áo xống trao cho Rê-be-ca; rồi cùng lấy các vật quí dâng cho anh và mẹ nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Đoạn người đầy tớ cùng các người đi theo ngồi ăn uống; rồi ngủ tại đó. Qua ngày sau, khi họ đã thức dậy, người đầy tớ nói rằng: Xin hãy cho tôi trở về chủ. ");
INSERT INTO vie1934_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Nhưng anh và mẹ nàng nói rằng: Hãy cho người gái trẻ ở lại cùng chúng tôi ít ngày nữa, độ chừng mười bữa, rồi nó sẽ đi. ");
INSERT INTO vie1934_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Đầy tớ đáp rằng: Xin chớ cầm tôi trễ lại, vì Đức Giê-hô-va có làm việc đi đường tôi được thành. Hãy cho tôi đi, trở về nhà chủ tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Họ đáp rằng: Chúng ta hãy gọi người gái trẻ đó và hỏi ý nó ra sao; ");
INSERT INTO vie1934_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","bèn kêu Rê-be-ca và nói rằng: Con muốn đi cùng người nầy chăng? Nàng rằng: Tôi muốn đi. ");
INSERT INTO vie1934_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Đoạn, họ cho Rê-be-ca, em gái mình, và người vú của nàng, đi về theo người đầy tớ của Aùp-ra-ham và các kẻ đi theo. ");
INSERT INTO vie1934_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Họ chúc phước cho Rê-be-ca mà rằng: Hỡi em gái chúng ta! Chúc cho em được trở nên mẹ của ức triệu người, và cho dòng dõi em được chiếm lấy cửa thành của quân nghịch. ");
INSERT INTO vie1934_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rê-be-ca và các đòi nàng đứng dậy, lên cỡi lạc đà, đi theo người đầy tớ đó. Vậy, người đầy tớ dẫn Rê-be-ca đi. ");
INSERT INTO vie1934_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Bấy giờ Y-sác ở tại nam phương từ giếng La-chai-Roi trở về; ");
INSERT INTO vie1934_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","lối chiều, người đi ra ngoài đồng đặng suy ngẫm; nhướng mắt lên, kìa ngó thấy lạc đà đâu đi đến. ");
INSERT INTO vie1934_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Nàng Rê-be-ca cũng nhướng mắt lên, bèn chợt thấy Y-sác; liền nhảy xuống lạc đà, ");
INSERT INTO vie1934_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","và hỏi đầy tớ rằng: Người ở đằng trước mặt tôi đi lại trong đồng đó là ai: Đầy tớ thưa rằng: Aáy là chủ tôi đó. Nàng bèn lấy lúp che mặt lại. ");
INSERT INTO vie1934_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Rồi, đầy tớ thuật cho Y-sác nghe hết các việc mà mình đã làm; ");
INSERT INTO vie1934_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Y-sác bèn dẫn Rê-be-ca vào trại của Sa-ra, mẹ mình, cưới làm vợ, và yêu mến nàng. Vậy, Y-sác được giải phiền sau khi mẹ mình qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aùp-ra-ham cưới một người vợ khác, tên là Kê-tu-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Người sanh cho Aùp-ra-ham Xim-ram, Giốc-chan, Mê-đan, Ma-đi-an, Dích-bác và Su-ách. ");
INSERT INTO vie1934_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Giốc-chan sanh Sê-ba và Đê-đan; con cháu của Đê-đan là họ A-chu-rim, họ Lê-tu-chim và họ Lê-um-mim. ");
INSERT INTO vie1934_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Con trai của Ma-đi-an là Ê-pha, Ê-phe, Ha-nóc, A-bi-đa và Eân-đa. Các người trên đây đều là dòng dõi của Kê-tu-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aùp-ra-ham cho Y-sác hết thảy gia tài mình; còn cho các con dòng thứ những tiền của; ");
INSERT INTO vie1934_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","rồi, khi còn sống, người sai họ qua đông phương mà ở, cách xa con dòng chánh, là Y-sác. ");
INSERT INTO vie1934_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aùp-ra-ham hưởng thọ được một trăm bảy mươi lăm tuổi; ");
INSERT INTO vie1934_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","người tuổi cao tác lớn và đã thỏa về đời mình, tắt hơi, được qui về nơi tổ tông. ");
INSERT INTO vie1934_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Hai con trai người, Y-sác và ỗch-ma-ên, chôn người trong hang đá Mặc-bê-la tại nơi đồng của Eùp-rôn, con trai Sô-ha, người Hê-tít, nằm ngang Mam-rê. ");
INSERT INTO vie1934_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Aáy là cái đồng mà lúc trước Aùp-ra-ham mua lại của dân họ Hếch; nơi đó họ chôn Aùp-ra-ham cùng Sa-ra, vợ người. ");
INSERT INTO vie1934_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Sau khi Aùp-ra-ham qua đời, Đức Giê-hô-va ban phước cho Y-sác con trai người. Y-sác ở gần bên cái giếng La-chai-Roi. ");
INSERT INTO vie1934_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Đây là dòng dõi của ỗch-ma-ên, con trai của Aùp-ra-ham, do nơi nàng A-ga, người Ê-díp-tô, con đòi của Sa-ra, đã sanh. ");
INSERT INTO vie1934_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Và đây là tên các con trai của ỗch-ma-ên, sắp thứ tự theo ngày ra đời: Con trưởng nam của ỗch-ma-ên là Nê-ba-giốt; kế sau Kê-đa, Aùt-bê-ên, Mi-bô-sam, ");
INSERT INTO vie1934_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mích-ma, Đu-ma, Ma-sa, ");
INSERT INTO vie1934_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ha-đa, Thê-ma, Giê-thu, Na-phích, và Kết-ma. ");
INSERT INTO vie1934_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Đó là các con trai của ỗch-ma-ên và tên của họ tùy theo làng và nơi đóng trại mà đặt. Aáy là mười hai vị công hầu trong dân tộc của họ. ");
INSERT INTO vie1934_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ỗch-ma-ên hưởng thọ được một trăm ba mươi bảy tuổi, rồi tắt hơi mà qua đời, được qui về nơi tổ tông. ");
INSERT INTO vie1934_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Dòng dõi người ở trước mặt anh em mình, từ Ha-vi-la cho đến Xu-xơ, đối ngang Ê-díp-tô, chạy qua A-si-ri. ");
INSERT INTO vie1934_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Đây là dòng dõi của Y-sác, con trai Aùp-ra-ham. Aùp-ra-ham sanh Y-sác. ");
INSERT INTO vie1934_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Vả, khi Y-sác được bốn mươi tuổi, thì cưới Rê-be-ca, con gái của Bê-tu-ên và em gái của La-ban, đều là dân A-ram, ở tại xứ Pha-đan-A-ram. ");
INSERT INTO vie1934_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Y-sác khẩn cầu Đức Giê-hô-va cho vợ mình, vì nàng son sẻ. Đức Giê-hô-va cảm động lời khẩn cầu đó, nên cho Rê-be-ca thọ thai. ");
INSERT INTO vie1934_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nhưng vì thai đôi làm cho đụng nhau trong bụng, thì nàng nói rằng: Nếu quả thật vậy, cớ sao đều nầy xảy đến làm chi? Đoạn nàng đi hỏi Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Đức Giê-hô-va phán rằng: Hai nước hiện ở trong bụng ngươi, và hai thứ dân sẽ do lòng ngươi mà ra; dân nầy mạnh hơn dân kia, và đứa lớn phải phục đứa nhỏ. ");
INSERT INTO vie1934_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Đến ngày nàng phải sanh nở, nầy hai đứa sanh đôi trong bụng nàng ra. ");
INSERT INTO vie1934_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Đứa ra trước đỏ hồng, lông cùng mình như một áo tơi lông; đặt tên là Ê-sau. ");
INSERT INTO vie1934_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kế em nó lại ra sau, tay nắm lấy gót Ê-sau; nên đặt tên là Gia-cốp. Khi sanh hai đứa con nầy thì Y-sác đã được sáu mươi tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Khi hai đứa trai nầy lớn lên, thì Ê-sau trở nên một thợ săn giỏi, thường giong ruổi nơi đồng ruộng; còn Gia-cốp là người hiền lành cứ ở lại trại. ");
INSERT INTO vie1934_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Y-sác yêu Ê-sau, vì người có tánh ưa ăn thịt rừng; nhưng Rê-be-ca lại yêu Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Một ngày kia, Gia-cốp đang nấu canh, Ê-sau ở ngoài đồng về lấy làm mệt mỏi lắm; ");
INSERT INTO vie1934_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","liền nói cùng Gia-cốp rằng: Em hãy cho anh ăn canh gì đỏ đó với, vì anh mệt mỏi lắm. Bởi cớ ấy, người ta gọi Ê-sau là Ê-đôm. ");
INSERT INTO vie1934_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Gia-cốp đáp rằng: Nay anh hãy bán quyền trưởng nam cho tôi đi. ");
INSERT INTO vie1934_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ê-sau đáp rằng: Nầy, anh gần thác, quyền trưởng nam để cho anh dùng làm chi? ");
INSERT INTO vie1934_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Gia-cốp đáp lại rằng: Anh hãy thề trước đi. Người bèn thề; vậy, người bán quyền trưởng nam cho Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Rồi, Gia-cốp cho Ê-sau ăn bánh và canh phạn đậu; ăn uống xong, người bèn đứng dậy đi. Vậy, Ê-sau khinh quyền trưởng nam là thế. ");
INSERT INTO vie1934_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Trừ cơn đói kém thứ nhất trong đời Aùp-ra-ham, bấy giờ tại xứ lại có một lần nữa. Y-sác bèn đi đến A-bi-mê-léc, vua Phi-li-tin, tại Ghê-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Đức Giê-hô-va hiện đến cùng người và phán rằng: Chớ xuống xứ Ê-díp-tô; hãy ở lại xứ mà ta sẽ chỉ cho. ");
INSERT INTO vie1934_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Hãy ngụ trong xứ nầy, ta sẽ ở cùng ngươi và ban phước cho ngươi; vì ta sẽ cho ngươi cùng dòng dõi ngươi các xứ nầy và ta sẽ làm thành lời ta đã thề cùng Aùp-ra-ham, cha ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ta sẽ thêm dòng dõi ngươi nhiều như sao trên trời, sẽ cho họ các xứ nầy; hết thảy dân thế gian đều sẽ nhờ dòng dõi ngươi mà được phước; ");
INSERT INTO vie1934_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","vì Aùp-ra-ham đã vâng lời ta và đã giữ điều ta phán dạy, lịnh, luật và lệ của ta. ");
INSERT INTO vie1934_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Vậy, Y-sác ở tại Ghê-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bởi nàng Rê-be-ca sắc-sảo dung nhan, nên khi dân xứ đó hỏi thăm vợ người, thì người đáp rằng: “Aáy là em gái tôi,” e khi nói: “Aáy là vợ tôi,” thì họ sẽ giết mình chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Vả, người ngụ tại xứ đó cũng đã lâu; một ngày kia A-bi-mê-léc, vua Phi-li-tin, ngó ngang qua cửa sổ, thấy Y-sác đang giỡn chơi cùng Rê-be-ca, vợ người, ");
INSERT INTO vie1934_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","bèn đòi Y-sác mà rằng: Quả thật là vợ ngươi đó; sao có nói: Aáy là em gái tôi? Y-sác đáp rằng: Vì tôi có thầm nói: Chớ khá vì nàng mà tôi phải bỏ mình. ");
INSERT INTO vie1934_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","A-bi-mê-léc hỏi: Ngươi làm chi cho chúng ta vậy? Ngộ có một người dân đến nằm cùng vợ ngươi, ngươi làm cho chúng ta phải phạm tội! ");
INSERT INTO vie1934_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","A-bi-mê-léc bèn truyền lịnh cho cả dân chúng rằng: Kẻ nào động đến người nầy, hay là vợ người nầy, thì sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Y-sác gieo hột giống trong xứ đó; năm ấy gặt được bội trăm phần; vì Đức Giê-hô-va đã ban phước cho. ");
INSERT INTO vie1934_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Người nên thạnh vượng, của cải càng ngày càng thêm cho đến đỗi người trở nên rất lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Người có nhiều bầy chiên, bầy bò và tôi tớ rất đông; bởi cớ ấy, dân Phi-li-tin đem lòng ganh ghẻ. ");
INSERT INTO vie1934_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mấy cái giếng lúc trước đầy tớ của Aùp-ra-ham, cha người, đã đào, bây giờ đều bị dân Phi-li-tin lấp đất lại hết. ");
INSERT INTO vie1934_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","A-bi-mê-léc nói cùng Y-sác rằng: Hãy ra khỏi nơi ta, vì ngươi thạnh vượng hơn chúng ta bội phần. ");
INSERT INTO vie1934_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Vậy, Y-sác bỏ chốn nầy đi đến đóng trại tại trũng Ghê-ra và ở đó. ");
INSERT INTO vie1934_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Y-sác bèn đào lại mấy cái giếng người ta đã đào trong đời Aùp-ra-ham, cha mình, mà bị dân Phi-li-tin lấp đất lại khi Aùp-ra-ham qua đời, và đặt tên mấy giếng đó như tên của cha mình đã đặt. ");
INSERT INTO vie1934_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Các đầy tớ của Y-sác còn đào thêm giếng nơi trũng, gặp được một giếng nước mạch. ");
INSERT INTO vie1934_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Nhưng bọn chăn chiên Ghê-ra tranh giành cùng bọn chăn chiên của Y-sác, mà rằng: Nước đó của chúng ta; nên người đặt tên giếng nầy là Ê-sét. Vì bọn chăn chiên đó có tranh giành cùng mình. ");
INSERT INTO vie1934_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kế ấy, các đầy tớ đào một giếng khác, thì bị tranh giành nhau nữa; người đặt tên giếng nầy là Sít-na. ");
INSERT INTO vie1934_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Đoạn, người bỏ chỗ đó đi đào một giếng khác; về giếng nầy, họ không tranh giành nhau, nên người đặt tên là Rê-hô-bốt, mà rằng: Bây giờ Đức Giê-hô-va đã để cho chúng ta được ở rộng rãi, và ta sẽ đặng thịnh vượng trong xứ. ");
INSERT INTO vie1934_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Y-sác ở đó đi, dời lên Bê-e-Sê-ba. ");
INSERT INTO vie1934_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Đêm đó Đức Giê-hô-va hiện đến cùng người và phán rằng: Ta là Đức Chúa Trời của Aùp-ra-ham, cha ngươi; chớ sợ chi, ta ở cùng ngươi, sẽ ban phước cho và thêm dòng dõi ngươi, vì cớ Aùp-ra-ham là tôi tớ ta. ");
INSERT INTO vie1934_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Y-sác lập một bàn thờ, cầu khẩn danh Đức Giê-hô-va và đóng trại tại đó. Đoạn, các đầy tớ người đào một cái giếng tại nơi ấy. ");
INSERT INTO vie1934_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Vua A-bi-mê-léc ở Ghê-ra đi đến viếng Y-sác, có A-hu-sát, bạn mình, và Phi-côn, quan tổng binh mình, đi theo. ");
INSERT INTO vie1934_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Y-sác bèn hỏi rằng: Các người ghét tôi, đã đuổi tôi ra khỏi nơi mình, sao còn đi đến tôi mà chi? ");
INSERT INTO vie1934_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Chúng đáp rằng: Chúng tôi đã thấy rõ ràng Đức Giê-hô-va phù hộ người, nên nói với nhau rằng: Phải có một lời thề giữa chúng tôi và người, để chúng ta kết giao ước với người. ");
INSERT INTO vie1934_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Hãy thề rằng: Người chẳng bao giờ làm hại chúng tôi, như chúng tôi đã không động đến người, chỉ hậu đãi người và cho đi bình yên. Bây giờ người được Đức Giê-hô-va ban phước cho. ");
INSERT INTO vie1934_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Y-sác bày một bữa tiệc, các người đồng ăn uống. ");
INSERT INTO vie1934_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Qua ngày sau, chúng dậy sớm, lập lời thề với nhau. Rồi, Y-sác đưa các người đó đi về bình yên. ");
INSERT INTO vie1934_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Cùng trong ngày đó, các đầy tớ của Y-sác đến đem tin cho người hay về giếng họ đã đào, rằng: Chúng tôi đã thấy có nước. ");
INSERT INTO vie1934_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Người bèn đặt tên cái giếng đó là Si-ba. Vì cớ đó nên tên thành ấy là Bê-e-Sê-ba cho đến ngày nay. ");
INSERT INTO vie1934_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Khi Ê-sau được bốn mươi tuổi, cưới Giu-đít, con gái của Bê-ê-ri, người Hê-tít; và Bách-mát, con gái của Ê-lôn, cũng người Hê-tít. ");
INSERT INTO vie1934_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Hai dâu đó là một sự cay đắng lòng cho Y-sác và Rê-be-ca. ");
INSERT INTO vie1934_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Bởi Y-sác đã già, mắt làng chẳng thấy được nữa, bèn gọi Ê-sau, con trưởng nam, mà rằng: Hỡi con! Ê-sau thưa rằng: Có con đây. ");
INSERT INTO vie1934_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Người bèn nói rằng: Nầy, cha đã già rồi, chẳng biết ngày nào phải chết; ");
INSERT INTO vie1934_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","vậy bây giờ, cha xin con hãy lấy khí giới, ống tên và cung con, ra đồng săn thịt rừng cho cha, ");
INSERT INTO vie1934_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","dọn một món ngon tùy theo cha sở thích; rồi dâng lên cho cha ăn, đặng linh hồn cha chúc phước cho con trước khi chết. ");
INSERT INTO vie1934_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Vả, đang khi Y-sác nói cùng Ê-sau con trai mình, thì Rê-be-ca có nghe. Ê-sau bèn ra đồng săn thịt rừng đặng đem về cho cha. ");
INSERT INTO vie1934_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rê-be-ca nói cùng Gia-cốp, con trai mình, rằng: Nầy, mẹ có nghe cha nói cùng Ê-sau, anh con, và dặn rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Hãy đem thịt rừng về cho cha, dọn một món ngon cha ăn; đặng trước khi qua đời, cha sẽ chúc phước cho con trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Vậy, con ơi! bây giờ, hãy nghe mẹ và làm theo lời mẹ biểu: ");
INSERT INTO vie1934_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Hãy ra ngoài bầy, bắt hai dê con tốt, rồi mẹ sẽ dọn cho cha con một món ngon, tùy theo người sở thích; ");
INSERT INTO vie1934_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","con sẽ đem cho cha ăn, đặng người chúc phước con trước khi qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Gia-cốp thưa lại cùng mẹ rằng: Thưa mẹ, Ê-sau, anh con, có lông, còn con lại không. ");
INSERT INTO vie1934_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Có lẽ cha sẽ rờ mình chăng, coi con như kẻ phỉnh gạt, thì con chắc lấy cho mình sự rủa sả, chớ chẳng phải sự chúc phước đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mẹ đáp rằng: Con ơi! xin sự rủa sả đó để cho mẹ chịu; hãy cứ nghe lời mẹ, ra bắt hai dê con. ");
INSERT INTO vie1934_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Vậy, Gia-cốp đi bắt hai dê con, đem lại cho mẹ, làm món ngon, tùy theo cha sở thích. ");
INSERT INTO vie1934_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Đoạn Rê-be-ca lấy quần áo tốt nhất của Ê-sau, con trưởng nam, sẵn để trong nhà, mà mặc vào cho Gia-cốp, con út mình; ");
INSERT INTO vie1934_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","rồi người lấy da dê con bao hai tay và cổ, vì tay và cổ Gia-cốp không có lông. ");
INSERT INTO vie1934_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Rê-be-ca bèn để món ngon và bánh của mình đã dọn vào tay con út mình. ");
INSERT INTO vie1934_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Gia-cốp bưng đến cha mình và nói rằng: Thưa cha! Y-sác đáp: Có cha đây; con là đứa nào đó? ");
INSERT INTO vie1934_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Gia-cốp thưa: Tôi là Ê-sau, con trưởng nam của cha; con đã làm theo lời cha dặn biểu; xin cha dậy, ngồi ăn lấy thịt săn của con, đặng linh hồn cha sẽ chúc phước cho con. ");
INSERT INTO vie1934_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Y-sác hỏi rằng: Sao con đi săn được mau thế? Thưa rằng: Aáy nhờ Giê-hô-va Đức Chúa Trời của cha xui tôi gặp mau vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Y-sác nói cùng Gia-cốp rằng: Hỡi con! hãy lại gần đặng cha rờ thử xem có phải là Ê-sau, con của cha chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Gia-cốp bèn lại gần Y-sác; người rờ và nói rằng: Tiếng nói thì của Gia-cốp, còn hai tay lại của Ê-sau. ");
INSERT INTO vie1934_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Người chẳng nhận biết đặng vì hai tay cũng có lông như của anh, là Ê-sau. Vậy Y-sác chúc phước cho. ");
INSERT INTO vie1934_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Người lại hỏi rằng: Aáy con thật là Ê-sau, con trai ta, phải chăng? Gia-cốp thưa: Phải, con đây. ");
INSERT INTO vie1934_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Y-sác bèn nói: Hãy dọn cho cha ăn lấy thịt săn của con, đặng linh hồn cha chúc phước cho con. Gia-cốp dọn cho người ăn, cũng có đem rượu cho người uống nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Rồi Y-sác cha người nói rằng: Hỡi con! hãy lại gần và hôn cha. ");
INSERT INTO vie1934_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Gia-cốp bèn lại gần và hôn người. Y-sác đánh mùi thơm của áo con, liền chúc phước cho, và nói rằng: Nầy, mùi hương của con ta Khác nào mùi hương của cánh đồng mà Đức Giê-hô-va đã ban phước cho. ");
INSERT INTO vie1934_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Cầu xin Đức Chúa Trời cho con sương móc trên trời xuống, Được màu mỡ của đất, Và dư dật lúa mì cùng rượu. ");
INSERT INTO vie1934_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Muôn dân phải phục con, Các nước phải quì lạy trước mặt con! Hãy được quyền chủ các anh em, Các con trai của mẹ con phải quì lạy trước mặt con! Ai rủa sả con sẽ bị rủa sả lại, Ai cầu phước cho con, sẽ được ban phước lại! ");
INSERT INTO vie1934_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Vừa khi Y-sác chúc phước cho Gia-cốp xong, và vừa khi Gia-cốp lùi ra khỏi nơi cha mình, thì Ê-sau, anh người, đi săn trở về. ");
INSERT INTO vie1934_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Người cũng dọn một món ngon, dâng lên cho cha và thưa rằng: Xin dậy, ngồi ăn thịt săn của con trai cha, đặng linh hồn cha chúc phước cho con. ");
INSERT INTO vie1934_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Y-sác, cha người, hỏi: Con là đứa nào? Thưa rằng: Tôi là Ê-sau, con trưởng nam của cha. ");
INSERT INTO vie1934_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Y-sác lấy làm cảm động quá đỗi mà nói rằng: Vậy, còn đứa nào đã săn thịt rừng, và đã dâng lên cho cha đó? Trước khi con về, cha đã ăn hết rồi, và chúc phước cho nó; nó lại sẽ được ban phước vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Vừa nghe dứt lời cha, thì Ê-sau la lên một tiếng rất lớn, và rất thảm thiết mà thưa cùng cha rằng: Cha ơi! xin hãy chúc phước cho con luôn nữa! ");
INSERT INTO vie1934_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Nhưng Y-sác lại đáp: Em con đã dùng mưu kế đến cướp sự chúc phước của con rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ê-sau liền nói rằng: Có phải vì người ta gọi nó là Gia-cốp mà nó hai lần chiếm lấy vị tôi rồi chăng? Nó đã chiếm quyền trưởng nam tôi, và lại bây giờ còn chiếm sự phước lành của tôi nữa. Tiếp rằng: Cha chẳng có dành sự chúc phước chi cho tôi sao? ");
INSERT INTO vie1934_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Y-sác đáp rằng: Nầy, cha đã lập nó lên làm chủ con, và đã cho các anh em làm tôi nó; và đã dự bị lúa mì và rượu cho nó. Vậy, cha sẽ làm chi cho con đây? ");
INSERT INTO vie1934_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ê-sau thưa rằng: Cha ơi! cha chỉ có sự chúc phước đó thôi sao? Hãy chúc phước cho con với, cha! Rồi Ê-sau cất tiếng lên khóc. ");
INSERT INTO vie1934_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Y-sác cha người, đáp rằng: Nầy, nơi con ở sẽ thiếu màu mỡ của đất, Cùng sương-móc trên trời sa xuống. ");
INSERT INTO vie1934_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Con sẽ nhờ gươm mới được sống. Và làm tôi tớ cho em con. Song khi con lưu lạc rày đó mai đây, Sẽ bẻ cái ách của em trên cổ con vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ê-sau trở lòng ghét Gia-cốp vì cớ cha mình chúc phước cho người, bèn nói thầm trong lòng rằng: Ngày tang của cha đã hầu gần; vậy, ta sẽ giết Gia-cốp, em ta, đi. ");
INSERT INTO vie1934_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Họ đem lời Ê-sau, con lớn, thuật lại cùng Rê-be-ca, thì người sai gọi Gia-cốp, con út mình, mà nói rằng: Nầy, Ê-sau, anh con, toan giết con để báo thù. ");
INSERT INTO vie1934_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Vậy, bây giờ, hỡi con, hãy nghe lời mẹ, đứng dậy, chạy trốn qua nhà La-ban, cậu con, tại Cha-ran, ");
INSERT INTO vie1934_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","và hãy ở cùng người ít lâu, cho đến lúc nào cơn giận của anh con qua hết. ");
INSERT INTO vie1934_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Khi cơn giận anh con bỏ qua rồi, và nó quên việc con đã gây nên với nó, thì mẹ sẽ biểu con về. Có lẽ đâu mẹ phải chịu mất cả hai đứa trong một ngày ư? ");
INSERT INTO vie1934_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rê-be-ca nói cùng Y-sác rằng: Tôi đã chán, không muốn sống nữa, vì cớ mấy con gái họ Hếch. Nếu Gia-cốp cưới một trong mấy con gái họ Hếch mà làm vợ, tức một người con gái trong xứ như các đứa đó; thôi, tôi còn sống mà chi? ");
INSERT INTO vie1934_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Y-sác bèn gọi Gia-cốp, chúc phước cho và dặn rằng: Con chớ chọn một người vợ nào hết trong bọn con gái Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hãy đứng dậy, đi qua xứ Pha-đan-A-ram, tại nhà Bê-tu-ên, ông ngoại con, và cưới ở đó một người vợ trong các con gái của La-ban, là cậu con. ");
INSERT INTO vie1934_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Cầu xin Đức Chúa Trời toàn năng ban phước cho con, làm con sanh sản, thêm nhiều và trở nên một đám dân đông. ");
INSERT INTO vie1934_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Cầu xin Ngài ban cho con và dòng dõi con phước lành của Aùp-ra-ham, hầu cho xứ con đã kiều ngụ sẽ làm sản nghiệp cho con, tức xứ Ngài đã ban cho Aùp-ra-ham! ");
INSERT INTO vie1934_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Rồi Y-sác sai Gia-cốp đi qua xứ Pha-đan-A-ram, đến nhà La-ban, con trai Bê-tu-ên, vốn người A-ram, lại là anh của Rê-bê-ca, mẹ của Gia-cốp và Ê-sau. ");
INSERT INTO vie1934_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ê-sau thấy Y-sác đã chúc phước cho Gia-cốp, và sai đi qua xứ Pha-đan-A-ram đặng cưới vợ; và trong lúc đang chúc phước có dặn rằng: Chớ cưới vợ trong bọn con gái Ca-na-an; ");
INSERT INTO vie1934_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","lại đã thấy Gia-cốp vâng lời cha mẹ đi qua xứ Pha-đan-A-ram đó, ");
INSERT INTO vie1934_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","thì biết rằng bọn con gái Ca-na-an không vừa ý Y-sác, cha mình; ");
INSERT INTO vie1934_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","nên người bèn đi đến nhà ỗch-ma-ên (ngoài hai người vợ đã có rồi) cưới thêm nàng Ma-ha-lát, con gái của ỗch-ma-ên, cháu nội của Aùp-ra-ham và em của Nê-ba-giốt. ");
INSERT INTO vie1934_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Gia-cốp từ Bê-e-Sê-ba đi đến Cha-ran, ");
INSERT INTO vie1934_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","tới một chỗ kia, mặt trời đã khuất, thì qua đêm tại đó. Người lấy một hòn đá làm gối đầu, và nằm ngủ tại đó; ");
INSERT INTO vie1934_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","bèn chiêm bao thấy một cái thang bắc từ dưới đất, đầu đến tận trời, các thiên sứ của Đức Chúa Trời đi lên xuống trên thang đó. ");
INSERT INTO vie1934_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nầy, Đức Giê-hô-va ngự trên đầu thang mà phán rằng: Ta là Giê-hô-va Đức Chúa Trời của Aùp-ra-ham, tổ phụ ngươi, cùng là Đức Chúa Trời của Y-sác. Ta sẽ cho ngươi và dòng dõi ngươi đất mà ngươi đang nằm ngủ đây. ");
INSERT INTO vie1934_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dòng dõi ngươi sẽ đông như cát bụi trên mặt đất, tràn ra đến đông tây nam bắc, và các chi họ thế gian sẽ nhờ ngươi và dòng dõi ngươi mà được phước. ");
INSERT INTO vie1934_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nầy, ta ở cùng ngươi, ngươi đi đâu, sẽ theo gìn giữ đó, và đem ngươi về xứ nầy; vì ta không bao giờ bỏ ngươi cho đến khi ta làm xong những điều ta đã hứa cùng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Gia-cốp thức giấc, nói rằng: Thật Đức Giê-hô-va hiện có trong nơi đây mà tôi không biết! ");
INSERT INTO vie1934_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Người bắt sợ và nói rằng: Chốn nầy đáng kinh khủng thay! Đây thật là đền Đức Chúa Trời, thật là cửa của trời! ");
INSERT INTO vie1934_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Người dậy sớm, lấy hòn đá của mình dùng gối đầu, dựng đứng lên làm cây trụ, đổ dầu lên trên chót trụ đó; ");
INSERT INTO vie1934_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","rồi đặt tên chốn nầy là Bê-tên; còn nguyên khi trước tên thành là Lu-xơ. ");
INSERT INTO vie1934_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Gia-cốp bèn khấn vái rằng: Nếu Đức Chúa Trời ở cùng tôi, gìn giữ tôi trong lúc đi đường, cho bánh ăn, áo mặc, ");
INSERT INTO vie1934_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","và nếu tôi trở về bình an đến nhà cha tôi, thì Đức Giê-hô-va sẽ là Đức Chúa Trời tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Hòn đá đã dựng làm trụ đây sẽ là đền Đức Chúa Trời, Và tôi sẽ nộp lại cho Ngài một phần mười mọi của cải mà Ngài sẽ cho tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Đoạn, Gia-cốp lên đường, đi đến xứ của dân Đông phương. ");
INSERT INTO vie1934_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Người nhìn xem, thấy một cái giếng trong đồng ruộng, gần đó có ba bầy chiên nằm nghỉ, vì nơi nầy là chốn người ta cho các bầy chiên uống nước. Hòn đá đậy trên miệng giếng rất lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Các bầy chiên đều hiệp lại đó, rồi họ lăn hòn đá trên miệng giếng ra, cho các bầy uống nước; đoạn, lăn đá lại chỗ cũ, đậy trên miệng giếng. ");
INSERT INTO vie1934_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Gia-cốp hỏi mấy tay chăn chiên rằng: Hỡi các anh! các anh ở đâu đây? Bọn đó đáp rằng: Chúng tôi ở Cha-ran đến. ");
INSERT INTO vie1934_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Người hỏi: Các anh có biết La-ban, con trai Na-cô, chăng? Đáp rằng: Chúng tôi biết. ");
INSERT INTO vie1934_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Lại hỏi: Người đó được mạnh giỏi chăng? Đáp rằng: Người vẫn được mạnh giỏi, và nầy, Ra-chên, con gái người, đang đi đến cùng bầy chiên kia. ");
INSERT INTO vie1934_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Người nói: Nầy, trời hãy còn sớm, chưa phải là giờ nhóm hiệp các súc vật; vậy, các anh hãy cho bầy chiên uống nước, rồi thả đi ăn lại đi. ");
INSERT INTO vie1934_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Đáp rằng: Chúng tôi làm như vậy chẳng được; phải đợi các bầy hiệp lại đủ hết rồi, bấy giờ mới lăn hòn đá trên miệng giếng ra, cho bầy uống nước được. ");
INSERT INTO vie1934_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Vả, đang lúc người còn nói chuyện cùng bọn đó, thì Ra-chên dắt bầy chiên của cha nàng đến, vì nàng vốn là người chăn chiên. ");
INSERT INTO vie1934_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Khi vừa thấy Ra-chên, con gái La-ban, cậu mình, thì người liền lại gần lăn hòn đá ra khỏi miệng giếng, cho bầy chiên của La-ban, cậu mình, uống nước. ");
INSERT INTO vie1934_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Gia-cốp hôn Ra-chên, cất tiếng lên khóc; ");
INSERT INTO vie1934_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","rồi nói cho nàng biết rằng mình là bà con với cha nàng, tức con trai của Rê-be-ca. Nàng bèn chạy về thuật lại cho cha hay. ");
INSERT INTO vie1934_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Vừa khi nghe nói Gia-cốp, con trai của em gái mình, thì La-ban chạy đến trước mặt người, ôm choàng lấy mà hôn, rồi mời vào nhà. Gia-cốp thuật lại cho La-ban nghe các việc đã xảy qua. ");
INSERT INTO vie1934_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","La-ban bèn đáp rằng: Thật vậy, cháu là cốt nhục của cậu; rồi Gia-cốp ở một tháng cùng cậu. ");
INSERT INTO vie1934_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Đoạn, La-ban nói cùng Gia-cốp rằng: vì cớ cháu là bà con của cậu, cháu giúp công không cho cậu thôi sao? Tiền công bao nhiêu hãy nói cho cậu biết. ");
INSERT INTO vie1934_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Vả, La-ban có hai con gái, con lớn tên là Lê-a; con nhỏ tên là Ra-chên. ");
INSERT INTO vie1934_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Mắt Lê-a yếu, còn Ra-chên hình dung đẹp đẽ, vẻ mặt tốt tươi. ");
INSERT INTO vie1934_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Gia-cốp yêu Ra-chên nên nói rằng: Vì nàng Ra-chên, con út cậu, tôi sẽ giúp việc trong bảy năm. ");
INSERT INTO vie1934_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","La-ban trả lời rằng: Thà cậu gả nó cho cháu hơn là gả cho một người khác; hãy ở với cậu. ");
INSERT INTO vie1934_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Vậy, Gia-cốp vì Ra-chên, phải giúp việc trong bảy năm: nhưng bởi yêu nàng, nên coi bảy năm bằng chừng đôi ba bữa. ");
INSERT INTO vie1934_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kế đó, Gia-cốp nói cùng La-ban rằng: Hạn tôi đã mãn rồi; đâu! xin cậu hãy giao vợ tôi lại đặng tôi đến gần cùng nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","La-ban bèn mời các người trong xóm, bày một bữa tiệc; ");
INSERT INTO vie1934_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","đến chiều tối, bắt Lê-a, con gái mình, đưa cho Gia-cốp, rồi chàng đến cùng nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","La-ban lại cắt con đòi Xinh-ba theo hầu Lê-a, con gái mình. ");
INSERT INTO vie1934_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sáng bữa sau, mới biết là nàng Lê-a, thì Gia-cốp hỏi La-ban rằng: Cậu đã đãi tôi cách chi vậy? Có phải vì Ra-chên mà tôi mới giúp việc cho nhà cậu chăng? Sao cậu lừa-gạt tôi? ");
INSERT INTO vie1934_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","La-ban đáp rằng: Phong tục ở đây chẳng phải được gả em út trước, rồi chị cả sau. ");
INSERT INTO vie1934_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hãy ở với đứa nầy trọn một tuần đi, rồi ta sẽ gả luôn đứa kia cho; về đứa kia cháu phải giúp công cho cậu thêm bảy năm nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Gia-cốp theo lời, ở cùng Lê-a trọn một tuần, rồi La-ban gả Ra-chên con gái mình, cho chàng, ");
INSERT INTO vie1934_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","và cắt con đòi Bi-la theo hầu Ra-chên con gái mình. ");
INSERT INTO vie1934_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Gia-cốp đi lại cùng Ra-chên, thương yêu nàng hơn Lê-a. Vậy, người ở giúp việc nhà La-ban thêm bảy năm nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Đức Giê-hô-va thấy Lê-a bị ghét, bèn cho nàng sanh sản; còn Ra-chên lại son sẻ. ");
INSERT INTO vie1934_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lê-a thọ thai, sanh một con trai, đặt tên Ru-bên; vì nói rằng: Đức Giê-hô-va đã thấy sự cực khổ tôi; bây giờ chồng sẽ yêu mến tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nàng thọ thai nữa và sanh một con trai, đặt tên Si-mê-ôn; vì nói rằng. Đức Giê-hô-va có nghe biết tôi bị ghét, nên cho thêm đứa này. ");
INSERT INTO vie1934_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nàng thọ thai nữa và sanh một con trai; nàng rằng: Lần nầy chồng sẽ dính díu cùng tôi, vì tôi đã sanh cho người ba con trai; bởi cớ đó, đặt tên là Lê-vi. ");
INSERT INTO vie1934_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nàng thọ thai nữa, sanh một con trai, và nói rằng: Lần nầy tôi ngợi khen Đức Giê-hô-va; vì cớ ấy, đặt tên là Giu-đa. Đoạn, nàng thôi thai nghén. ");
INSERT INTO vie1934_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ra-chên thấy mình chẳng sanh con cho Gia-cốp, thì đem lòng ghen ghét chị, nói cùng Gia-cốp rằng: Hãy cho tôi có con, bằng không, tôi chết. ");
INSERT INTO vie1934_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Gia-cốp nổi giận cùng Ra-chên mà rằng: Há ta được thay quyền Đức Giê-hô-va, mà không cho ngươi sanh sản sao? ");
INSERT INTO vie1934_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ra-chên rằng: Nầy con đòi Bi-la của tôi, hãy lại cùng nó, hầu cho nó sanh đẻ thay cho tôi, đặng phần tôi bởi nó cũng có con nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Vậy, Ra-chên đưa Bi-la làm hầu Gia-cốp, và người đi lại cùng nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bi-la thọ thai, sanh một con trai cho Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ra-chên rằng: Đức Chúa Trời đã xét tôi công bình, nhậm lời tôi, nên cho tôi một con trai; vì cớ ấy, nàng đặt tên đứa trai đó là Đan. ");
INSERT INTO vie1934_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bi-la, con đòi của Ra-chên, thọ thai nữa, và sanh một con trai thứ nhì cho Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ra-chên rằng: Tôi đã hết sức chống cự với chị tôi, và tôi được thắng; vì cớ ấy, nàng đặt tên đứa trai nầy là Nép-ta-li. ");
INSERT INTO vie1934_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lê-a thấy mình thôi sanh sản, bèn bắt Xinh-ba, con đòi mình, làm hầu cho Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Xinh-ba, con đòi của Lê-a, sanh một con trai cho Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lê-a rằng: Phước biết dường bao! rồi đặt tên đứa trai đó là Gát. ");
INSERT INTO vie1934_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Xinh ba, con đòi của Lê-a, sanh một con trai thứ nhì cho Gia-cốp; ");
INSERT INTO vie1934_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","thì Lê-a rằng: Tôi lấy làm vui mừng dường bao! vì các con gái sẽ xưng ta được phước; nàng bèn đặt tên đứa trai đó là A-se. ");
INSERT INTO vie1934_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Nhằm mùa gặt lúa mì, Ru-bên đi ra đồng gặp được những trái phong già, đem về dâng cho Lê-a, mẹ mình. Ra-chên bèn nói cùng Lê-a rằng: Xin chị hãy cho tôi những trái phong già của con chị đó. ");
INSERT INTO vie1934_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Đáp rằng: Cướp chồng tao há là một việc nhỏ sao, nên mầy còn muốn lấy trái phong già của con trai tao nữa? Ra-chên rằng: ã thôi! chồng ta hãy ở cùng chị tối đêm nay, đổi cho trái phong già của con chị đó. ");
INSERT INTO vie1934_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Đến chiều, Gia-cốp ở ngoài đồng về, thì Lê-a đến trước mặt người mà nói rằng: Chàng hãy lại cùng tôi, vì tôi đã dùng trái phong già của con tôi chịu thuê được chàng; vậy, đêm đó người lại nằm cùng nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Đức Chúa Trời nhậm lời Lê-a, nàng thọ thai và sanh cho Gia-cốp một con trai thứ năm. ");
INSERT INTO vie1934_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nàng rằng: Đức Chúa Trời đã đền công tôi, vì cớ tôi đã trao con đòi cho chồng; vậy, nàng đặt tên đứa con trai đó là Y-sa-ca. ");
INSERT INTO vie1934_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lê-a thọ thai nữa, sanh một con trai thứ sáu cho Gia-cốp, ");
INSERT INTO vie1934_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","bèn nói rằng: Đức Chúa Trời ban cho tôi một vật quí báu; lần nầy chồng sẽ ở cùng tôi, vì đã sanh cho người sáu con trai rồi. Nàng đặt tên đứa con trai nầy là Sa-bu-lôn. ");
INSERT INTO vie1934_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kế đó, nàng sanh một con gái, đặt tên là Đi-na. ");
INSERT INTO vie1934_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Đức Chúa Trời nhớ lại Ra-chên, bèn nhậm lời và cho nàng sanh sản. ");
INSERT INTO vie1934_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nàng thọ thai, sanh một con trai, mà rằng: Đức Chúa Trời đã rửa sự xấu hổ cho tôi rồi; ");
INSERT INTO vie1934_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","bèn đặt tên đứa trai đó là Giô-sép; lại nói rằng: Cầu xin Đức Giê-hô-va thêm cho một con trai nữa! ");
INSERT INTO vie1934_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Khi Ra-chên đã sanh Giô-sép thì Gia-cốp thưa cùng La-ban rằng: Xin cậu cho tôi thôi, đặng trở về quê hương tôi; ");
INSERT INTO vie1934_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","xin giao vợ và con lại cho tôi, mà tôi đã được vì cớ giúp cậu, để tôi đi; bởi cậu cũng biết rằng tôi đã giúp công việc cho cậu thể nào. ");
INSERT INTO vie1934_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","La-ban đáp rằng: Ước gì cậu được nhờ ơn cháu! Cậu cũng đoán rõ ràng Đức Giê-hô-va đã vì cháu mà ban phước cho cậu vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Lại nói rằng: Cháu hãy định công giá cháu đi, rồi cậu sẽ trả cho! ");
INSERT INTO vie1934_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Gia-cốp đáp: Cậu biết tôi giúp đỡ cậu thể nào, và về tay tôi bầy súc vật cậu được ra sao. ");
INSERT INTO vie1934_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Trước khi tôi đến, súc vật của cậu thật ít, nhưng từ khi tôi đến ở, thì thêm nhiều quá bội. Đức Giê-hô-va đã ban phước cho cậu từ khi tôi bước chân vào nhà nầy; bây giờ biết chừng nào tôi sẽ được lo việc nhà tôi? ");
INSERT INTO vie1934_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","La-ban rằng: Cậu sẽ cho cháu cái gì bây giờ? Đáp rằng: Sẽ chẳng cho tôi chi cả. Nếu thuận theo lời nầy, thì tôi sẽ cho ăn và chăn bầy súc vật cậu nữa: ");
INSERT INTO vie1934_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ngày nay tôi sẽ đi kiểm soát các bầy chiên và bầy dê của cậu; trong bầy chiên bầy dê, hễ con nào có rằn, có đốm, cùng chiên sắc đen, thì tôi sẽ để riêng ra; ấy sẽ là phần công giá của tôi đó. ");
INSERT INTO vie1934_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Một mai cậu đi xem xét công giá tôi, thì lòng ngay thẳng tôi sẽ làm chứng trước mặt cậu. Hễ ở về phần bên tôi, các con dê nào không có rằn và đốm, các chiên con nào không có sắc đen, thì sẽ cho là ăn cắp. ");
INSERT INTO vie1934_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","La-ban đáp: ã thôi! được như lời cháu nói. ");
INSERT INTO vie1934_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Chính ngày đó, La-ban liền để riêng các dê đực có sọc, có đốm, các dê cái có rằn, có đốm, các vật nào có đốm trắng và các chiên con có sắc đen, giao cho mấy con trai mình; ");
INSERT INTO vie1934_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","rồi để Gia-cốp cùng mình ở cách xa nhau chừng ba ngày đường; Gia-cốp bèn chăn bầy súc vật của La-ban chỉ còn lại. ");
INSERT INTO vie1934_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Đoạn, Gia-cốp lấy nhành bạch dương, nhành bồ đào và nhành bá-tiên tươi, lột vỏ để bày lằn da trắng ở trong ra. ");
INSERT INTO vie1934_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Người để những nhành đã lột vỏ trong máng trước mặt con chiên, là nơi các thú đó đến uống; khi đến uống nước thì con chiên có giao hiệp nhau. ");
INSERT INTO vie1934_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Các con chiên ngó thấy những nhành đó mà giao hiệp nhau thì sanh chiên con có sọc, có rằn và có đốm. ");
INSERT INTO vie1934_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Gia-cốp để riêng chiên con ra, rồi để chiên cái trong bầy của La-ban trước mặt các con có sọc và có sắc đen; nhưng bầy mình thì riêng ra, không để gần bầy của La-ban. ");
INSERT INTO vie1934_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Vả, mọi lần các con chiên mạnh mập giao hiệp, thì Gia-cốp để các nhành đó dưới mắt trong máng uống nước, đặng chúng nó đối nhành mà giao hiệp cùng nhau. ");
INSERT INTO vie1934_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nhưng khi nào con chiên gầy ốm, thì người không để nhành như vậy; thế thì, các chiên con gầy ốm để về phần La-ban, còn chiên con mạnh mập lại về phần Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Vậy, người trở nên rất giàu, có nhiều bầy súc vật, tôi trai, tớ gái, lạc đà và lừa. ");
INSERT INTO vie1934_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Gia-cốp được nghe lời các con La-ban nói rằng: Gia-cốp đã lấy hết gia tài cha ta, và vì nhờ của cha ta, nên mới được giàu có dường ấy. ");
INSERT INTO vie1934_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Gia-cốp cũng để ý coi nét mặt cậu, nhận biết rằng người chẳng đối ở với mình như trước nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Đức Giê-hô-va phán cùng Gia-cốp rằng: Hãy trở về xứ của tổ phụ ngươi, chốn bà con ngươi, ta sẽ phù hộ ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Gia-cốp bèn sai người gọi Ra-chên và Lê-a đến nơi cầm bầy súc vật của mình ngoài đồng, ");
INSERT INTO vie1934_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","và nói cùng họ rằng: Ta thấy sắc mặt cha hai ngươi đối cùng ta chẳng còn như trước nữa, nhưng nhờ Đức Chúa Trời của cha ta phù hộ ta. ");
INSERT INTO vie1934_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Chính hai ngươi cũng biết rằng ta đã giúp cha hai ngươi hết sức, ");
INSERT INTO vie1934_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","còn cha hai ngươi lại khinh bạc và mười lần thay đổi công giá ta; nhưng Đức Chúa Trời không cho phép người làm hại ta chút nào. ");
INSERT INTO vie1934_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Khi người dạy rằng: Các con chiên có đốm dùng làm công giá ngươi, quả các con chiên đều sanh con ra có đốm. Còn nếu dạy rằng: Các con chiên có sọc dùng làm công giá ngươi, quả các con chiên đều sanh ra có sọc. ");
INSERT INTO vie1934_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Thế thì, Đức Chúa Trời đã bắt súc vật của cha hai ngươi cho ta đó! ");
INSERT INTO vie1934_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Đang trong lúc chiên giao hiệp nhau, ta nhướng mắt lên, chiêm bao thấy các chiên đực đang giao hiệp cùng chiên cái đều có sọc, có rằn và có đốm. ");
INSERT INTO vie1934_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Thiên sứ Đức Chúa Trời phán cùng ta trong mộng rằng: Hãy Gia-cốp! Ta bèn thưa: Có tôi đây. ");
INSERT INTO vie1934_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Thiên sứ rằng: Hãy nhướng mắt lên mà nhìn: hết thảy chiên đực đang giao hiệp cùng chiên cái đều có sọc, có rằn và có đốm; vì ta đã thấy cách La-ban ăn ở cùng ngươi rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ta đây là Đức Chúa Trời của Bê-tên, tức nơi ngươi đã thoa dầu đầu cây trụ và đã khấn vái ta. Bây giờ, hãy đứng dậy, ra khỏi xứ nầy và trở về xứ của bà con ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ra-chên và Lê-a đáp cùng người mà rằng: Chúng tôi còn một phần chi hay là cơ nghiệp chi nơi nhà cha chúng tôi chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Vì người đã gả bán chúng tôi và ăn xài hết tiền bạc bán nữa, há người chẳng đãi chúng tôi như người dưng ư? ");
INSERT INTO vie1934_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Các tài vật mà Đức Chúa Trời đoạt nơi tay cha chúng tôi tức là của chúng tôi và của con cái chúng tôi. Vậy bây giờ, chàng hãy làm theo mọi lời Đức Chúa Trời đã phán dạy. ");
INSERT INTO vie1934_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Gia-cốp bèn đứng dậy, đỡ vợ và con lên lưng lạc đà, ");
INSERT INTO vie1934_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","dẫn hết thảy súc vật và của cải mình, tức súc vật mình đã gây dựng ở Pha-đan-A-ram, đặng trở về cùng Y-sác, cha mình, ở Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Trong lúc La-ban mắc đi hớt lông chiên người, thì Ra-chên ăn cắp các pho tượng thờ trong nhà của cha mình. ");
INSERT INTO vie1934_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Gia-cốp gạt La-ban, vì không nói rằng, mình muốn đi trốn. ");
INSERT INTO vie1934_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Vậy, người đứng dậy, đem theo hết thảy tài vật mình, trốn đi ngang qua sông, thẳng tuốt về núi Ga-la-át. ");
INSERT INTO vie1934_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Đến ngày thứ ba, người ta học lại cùng La-ban rằng Gia-cốp đã trốn đi rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Người bèn đem các anh em mình đuổi theo Gia-cốp trong bảy ngày đường, và theo kịp tại núi Ga-la-át. ");
INSERT INTO vie1934_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nhưng trong cơn chiêm bao lúc ban đêm, Đức Chúa Trời đến cùng La-ban, người A-ram, mà phán rằng: Dầu lành dầu dữ, thế nào ngươi khá giữ mình đừng nói chi cùng Gia-cốp hết. ");
INSERT INTO vie1934_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Vậy, La-ban theo kịp Gia-cốp. Vả, Gia-cốp đang đóng trại trên núi; La-ban và các anh em người cũng đóng trại trên núi Ga-la-át. ");
INSERT INTO vie1934_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","La-ban nói cùng Gia-cốp rằng: Cháu đã làm chi vậy? Cháu đã gạt cậu và dẫn mấy đứa gái cậu như phu tù giặc. ");
INSERT INTO vie1934_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Sao trốn nhẹm, gạt và không cho cậu hay trước? Có lẽ cậu đưa đi rất vui vẻ, tiếng hát, tiếng đàn và tiếng trống phụ đưa. ");
INSERT INTO vie1934_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Cháu làm cách dại dột vậy, không để cho cậu hôn con trai và con gái cậu. ");
INSERT INTO vie1934_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tay cậu có đủ quyền làm hại cháu; nhưng Đức Chúa Trời của cha cháu đã mách bảo cùng cậu tối hôm qua rằng: Dầu lành dầu dữ, ngươi khá giữ mình đừng nói chi cùng Gia-cốp hết. ");
INSERT INTO vie1934_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Bây giờ, vì lòng cháu mong mỏi về nhà cha cháu, nên đã ra đi; nhưng cớ sao cháu lại ăn cắp các pho tượng cậu? ");
INSERT INTO vie1934_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Gia-cốp đáp rằng: Vì cớ tôi e cậu bắt hai người con gái lại chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nhưng tìm nơi ai được các pho tượng của cậu, thì ai đó sẽ bị chết đi! Tại trước mặt các anh em chúng ta, cậu hãy kiểm soát các món nơi tôi đi, và hãy lấy vật chi thuộc về cậu. Vả, Gia-cốp vốn không hay rằng Ra-chên đã trộm mấy pho tượng đó. ");
INSERT INTO vie1934_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Vậy, La-ban vào trại Gia-cốp, trại Lê-a, trại hai người đòi, chẳng tìm được chi cả. Đoạn, ở trại Lê-a bước ra đi vào trại Ra-chên. ");
INSERT INTO vie1934_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Vả, Ra-chên có lấy mấy pho tượng đó, giấu dưới bành lạc đà, rồi ngồi lên trên. La-ban soát lục khắp trại chẳng gặp pho tượng. ");
INSERT INTO vie1934_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nàng bèn thưa cùng cha rằng: Vì trong mình con có việc riêng của đàn bà, nên đứng dậy rước chẳng được; xin chúa chớ giận con chi hết. Người kiếm, nhưng chẳng thấy pho tượng đâu hết. ");
INSERT INTO vie1934_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Gia-cốp bèn nổi giận rầy lộn cùng La-ban, mà rằng: Tôi có án gì, tội gì, mà cậu hằm hằm đuổi theo như vậy! ");
INSERT INTO vie1934_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Cậu đã soát lục các đồ hành lý tôi, có kiếm được món chi thuộc về nhà cậu chăng? Hãy đem món đó ra trước mặt anh em tôi cùng anh em cậu, đặng họ xét đoán đôi ta. ");
INSERT INTO vie1934_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kìa, đã hai mươi năm tôi ăn ở nơi nhà cậu, chiên cùng dê cậu nào có sảo thai, và tôi chẳng hề ăn thịt chiên đực của bầy cậu bao giờ; ");
INSERT INTO vie1934_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","cũng chẳng hề đem về cho cậu một con nào bị xé; bằng có, chính tôi chịu đền đó thôi. Cậu cớ đòi luôn những con bị ăn cắp ban ngày và ăn trộm ban đêm. ");
INSERT INTO vie1934_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ban ngày tôi chịu nắng nồng, ban đêm chịu lạnh lùng, ngủ nào có an giấc được đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Đó trong hai mươi năm tôi ở tại nhà cậu là thế; trong mười bốn năm giúp việc, để được hai con gái cậu, và sáu năm đặng lãnh lấy bầy súc vật của cậu, mà cậu lại còn thay đổi mười lần công giá tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nếu Đức Chúa Trời của cha tôi, Đức Chúa Trời của Aùp-ra-ham, là Đấng mà Y-sác kính sợ, không phù hộ tôi, chắc bây giờ cậu đuổi tôi ra tay không, Đức Chúa Trời đã xem thấy nỗi đau-khổ tôi cùng công việc hai tay tôi làm, nên đêm qua Ngài đã xét công bình rồi đó. ");
INSERT INTO vie1934_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","La-ban đáp cùng Gia-cốp mà rằng: Các đứa gái nầy là con của cậu; các đứa trẻ nầy là trẻ của cậu; các bầy súc vật tức là bầy của cậu, và các vật chi cháu thấy được tức của cậu hết; ngày nay cậu sẽ làm chi được cùng các con gái hai là các cháu cậu đó? ");
INSERT INTO vie1934_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Vậy bây giờ, hè! chúng ta kết-ước cùng nhau, để dùng làm chứng cho cậu và cháu. ");
INSERT INTO vie1934_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Gia-cốp lấy một hòn đá, dựng đứng lên làm trụ; ");
INSERT INTO vie1934_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","và nói cùng các anh em mình rằng: Hãy lượm góp đá lại. Chúng bèn góp đá lại, chất thành một đống, rồi ngồi lên trên ăn bữa. ");
INSERT INTO vie1934_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","La-ban đặt trên đống đá đó là Y-ê-ga Sa-ha-đu-ta; còn Gia-cốp kêu là Ga-lét. ");
INSERT INTO vie1934_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","La-ban nói rằng: Đống đá nầy ngày nay làm chứng cho cậu và cháu đó. Cho nên chúng gọi là Ga-lét. ");
INSERT INTO vie1934_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mà cũng gọi là Mích-ba, vì La-ban có nói thêm rằng: Khi chúng ta phân cách nhau, cầu xin Đức Giê-hô-va coi sóc cậu và cháu. ");
INSERT INTO vie1934_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Nếu cháu hành hạ các con gái cậu, nếu cưới vợ khác nữa, thì hãy giữ mình! Chẳng phải người thường soi xét ta đâu, bèn là Đức Chúa Trời làm chứng cho chúng ta vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","La-ban lại nói cùng Gia-cốp rằng: Nầy đống đá, nầy cây trụ mà cậu đã dựng lên giữa cậu và cháu đây. ");
INSERT INTO vie1934_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Đống đá nầy và cây trụ nầy làm chứng rằng cậu chẳng qua khỏi đây, đi đến nơi cháu, và cháu cũng chẳng vượt khỏi đây, đi đến nơi cậu, trong khi có ý muốn làm hại nhau. ");
INSERT INTO vie1934_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Cầu xin Đức Chúa Trời của Aùp-ra-ham, Đức Chúa Trời của Na-cô, Đức Chúa Trời của cha các người đó đoán xét cho chúng ta! Gia-cốp chỉ Đấng của Y-sác, cha mình, kính sợ mà thề. ");
INSERT INTO vie1934_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Đoạn, người dâng một của lễ tại trên núi, và mời các anh em mình dùng bánh. Vậy, chúng dùng bánh, rồi ở ban đêm trên núi. ");
INSERT INTO vie1934_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","La-ban dậy sớm, hôn các con trai và các con gái mình, và chúc phước cho, rồi đi trở về nhà mình. ");
INSERT INTO vie1934_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Gia-cốp cứ đi đường, có thiên sứ Đức Chúa Trời gặp người. ");
INSERT INTO vie1934_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Khi Gia-cốp thấy các vị nầy, nói rằng: Aáy là trại quân của Đức Chúa Trời! Nên người đặt tên chỗ đó là Ma-ha-na-im. ");
INSERT INTO vie1934_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Gia-cốp sai sứ giả đến trước cùng Ê-sau, anh mình, ở trong xứ Sê-i-rơ thuộc về địa-phận Ê-đôm; ");
INSERT INTO vie1934_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","người bèn dặn rằng: Các ngươi hãy thưa cùng Ê-sau, chúa ta như vầy: Gia-cốp, kẻ tôi tớ chúa, có nói như vầy rằng: Tôi đã ngụ tại nhà La-ban đến ngày nay; ");
INSERT INTO vie1934_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","có bò, lừa, chiên, tôi trai, tớ gái; vậy, xin sai đi nói cho chúa hay trước, hầu cho nhờ được ơn trước mặt chúa tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Các sứ giả trở về nói cùng Gia-cốp rằng: Chúng tôi đã đi đến Ê-sau, anh của chủ; nầy người đang đem bốn trăm người đến để rước chủ. ");
INSERT INTO vie1934_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Gia-cốp rất sợ hãi và sầu não, bèn chia các dân đi theo, cùng các bầy chiên, bò, lạc đà ra làm hai đội, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nếu Ê-sau đến hãm đánh một trong hai đội, thì đội còn lại sẽ thoát được. ");
INSERT INTO vie1934_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Đoạn, Gia-cốp cầu rằng: Hỡi Đức Chúa Trời của tổ phụ Aùp-ra-ham tôi! Đức Chúa Trời của cha Y-sác tôi, tức là Đức Giê-hô-va! Ngài có phán dạy tôi rằng: Hãy trở về xứ ngươi và nơi bà con ngươi, rồi ta sẽ làm ơn cho ngươi! ");
INSERT INTO vie1934_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tôi lấy làm hèn mọn không đáng chịu các ân huệ và các điều thành thực mà Ngài đã làm cho kẻ tôi tớ Ngài; vì lúc trước khi qua sông Giô-đanh chỉ có cây gậy tôi, mà ngày nay tôi lại trở nên hai đội quân nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Vậy, cầu xin Đức Chúa Trời giải cứu tôi khỏi tay Ê-sau, anh tôi, vì e người đến đánh tôi và đánh luôn mẹ với con nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Vả, Ngài có nói rằng: Quả thật vậy, ta sẽ làm ơn cho ngươi, và làm cho dòng dõi ngươi đông như cát bãi biển, người ta sẽ không biết sao đếm được, vì đông đúc quá. ");
INSERT INTO vie1934_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Người ở ban đêm tại đó, lấy các vật có hiện trong tay để làm một của lễ dâng cho Ê-sau, anh mình, ");
INSERT INTO vie1934_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","là hai trăm dê cái và hai chục dê đực; hai trăm chiên cái và hai chục chiên đực; ");
INSERT INTO vie1934_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ba chục lạc đà cái có con đang bú, bốn chục bò cái và mười bò đực; hai chục con lừa cái và mười lừa con. ");
INSERT INTO vie1934_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Rồi, giao mỗi bầy riêng ra nơi tay đầy tớ mình và dặn rằng: Các ngươi hãy đi trước ta và dẫn bầy nầy cách một khoảng đến bầy kia. ");
INSERT INTO vie1934_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Người dặn tên dẫn bầy đi trước hết như vầy: Khi Ê-sau, anh ta, gặp và hỏi ngươi rằng: Ngươi ở với ai, đi đâu, và bầy súc vật trước mặt ngươi đó thuộc về ai? ");
INSERT INTO vie1934_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","thì hãy thưa rằng: Của Gia-cốp, kẻ tôi tớ chúa; ấy là một lễ gởi dâng cho Ê-sau, chúa tôi; và nầy, chính mình người đang theo sau. ");
INSERT INTO vie1934_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Gia-cốp cũng dặn y lời cho tên dẫn bầy thứ nhì, thứ ba và hết thảy người theo coi chừng các bầy, và lại nói: Khi gặp Ê-sau, các ngươi hãy nhớ lời đó, ");
INSERT INTO vie1934_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","và nói như vầy: Nầy, Gia-cốp, kẻ tôi tớ chúa, đang theo sau chúng tôi. Vì người thầm nghĩ rằng: Mình đem lễ nầy dâng trước cho Ê-sau nguôi giận đã, rồi mình sẽ giáp mặt sau; có lẽ người tiếp rước mình một cách thuận hiệp đó. ");
INSERT INTO vie1934_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Vậy, lễ nầy đem đi trước, còn người, đêm đó ở lại trại. ");
INSERT INTO vie1934_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ban đêm, người thức dậy, dẫn hai vợ, hai tên đòi và mười một đứa con mình đi qua rạch Gia-bốc. ");
INSERT INTO vie1934_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Người đem họ qua rạch, và hết thảy của cải mình qua nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Vả, một mình Gia-cốp ở lại; thì có một người vật lộn với mình đến rạng đông. ");
INSERT INTO vie1934_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Khi người đó thấy mình không thắng nổi, bèn đánh vào xương hông Gia-cốp; xương hông liền trặt trong khi vật lộn. ");
INSERT INTO vie1934_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Người đó bèn nói: Trời đã rạng đông rồi; thôi để cho ta đi; nhưng Gia-cốp đáp rằng: Tôi chẳng cho người đi đâu, nếu người không ban phước cho tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Người đó hỏi: Tên ngươi là chi? Đáp rằng: Tên tôi là Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Người lại nói: Tên ngươi sẽ chẳng làm Gia-cốp nữa, nhưng tên là Y-sơ-ra-ên, vì ngươi đã có vật lộn cùng Đức Chúa Trời và người ta; ngươi đều được thắng. ");
INSERT INTO vie1934_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Gia-cốp hỏi: Xin cho tôi biết tên người. Đáp rằng: Làm sao ngươi hỏi tên ta? Rồi người nầy ban phước cho Gia-cốp tại đó. ");
INSERT INTO vie1934_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Gia-cốp đặt tên chỗ đó là Phê-ni-ên, và nói rằng: Tôi đã thấy Đức Chúa Trời đối mặt cùng tôi và linh hồn tôi được giải cứu. ");
INSERT INTO vie1934_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Khi qua nơi Phê-ni-ên, thấy mặt trời mọc rồi; và người đi giẹo cẳng. ");
INSERT INTO vie1934_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Bởi cớ đó, cho đến ngày nay dân Y-sơ-ra-ên chẳng bao giờ ăn gân bắp vế của lối xương hông; vì người đó có đánh vào xương hông Gia-cốp, nơi gân của bắp vế. ");
INSERT INTO vie1934_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Gia-cốp nhướng mắt lên và nhìn, kìa, Ê-sau dẫn bốn trăm người đi đến. Người bèn chia các con cho Lê-a, Ra-chên, và cho hai tên đòi; ");
INSERT INTO vie1934_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","sắp hai tên đòi và con cái họ ở trước; kế đến Lê-a và con cái nàng; Ra-chên cùng Giô-sép ở sau chót. ");
INSERT INTO vie1934_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Còn người, thì đi trước họ và sấp mình xuống đất bảy lần cho đến khi tới gần anh mình. ");
INSERT INTO vie1934_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Nhưng Ê-sau chạy đến trước mặt người, ôm choàng cổ mà hôn, rồi hai anh em đều khóc. ");
INSERT INTO vie1934_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Đoạn, Ê-sau nhướng mắt lên thấy mấy người đàn bà và con cái, thì hỏi rằng: Các người mà em có đó là ai? Đáp rằng: Aáy là con cái mà Đức Chúa Trời đã cho kẻ tôi tớ anh. ");
INSERT INTO vie1934_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hai tên đòi và con cái họ lại gần người, sấp mình xuống. ");
INSERT INTO vie1934_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lê-a và các con cái nàng cũng lại gần, sấp mình xuống; đoạn, Ra-chên và Giô-sép lại gần, và sấp mình xuống. ");
INSERT INTO vie1934_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ê-sau hỏi: Toán quân anh đã gặp đi trước đó, em tính làm chi? Đáp rằng: Aáy để nhờ được ơn trước mặt chúa tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ê-sau nói: Hỡi em! anh đã được đủ rồi; vậy, hãy lấy lại vật chi của em đi. ");
INSERT INTO vie1934_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Thưa rằng: Xin anh, không. Nếu em được ơn trước mặt anh, hãy nhận lấy lễ vật bởi tay em làm ra đi; vì em thấy được mặt anh khác nào người ta thấy được mặt Đức Chúa Trời, và anh đã đẹp lòng tiếp rước em. ");
INSERT INTO vie1934_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xin anh hãy nhận lấy lễ vật em đã dâng cho anh, vì Đức Chúa Trời cho em đầy dẫy ân huệ, và em có đủ hết. Người nài xin Ê-sau quá đến đỗi phải chịu nhận lấy. ");
INSERT INTO vie1934_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ê-sau nói: Hè, ta hãy lên đường! Anh sẽ đi trước em. ");
INSERT INTO vie1934_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Gia-cốp đáp: Chúa biết rằng các đứa trả yếu lắm, và em lại mắc coi chừng chiên và bò cái đang có con bú; nếu ép đi mau chỉ trong một ngày, chắc cả bầy phải chết hết. ");
INSERT INTO vie1934_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Xin chúa hãy đi trước kẻ tôi tớ chúa, còn tôi sẽ đi tới chậm chậm theo bước một của súc vật đi trước và của các trẻ, cho đến chừng nào tới nhà chúa tại xứ Sê-i-rơ. ");
INSERT INTO vie1934_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ê-sau nói: Vậy, anh xin để lại cùng em một vài người tùy tùng của anh. Gia-cốp đáp rằng: Chi vậy? miễn em được nhờ ơn trước mặt chúa thôi! ");
INSERT INTO vie1934_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Nội ngày đó, Ê-sau bắt đường trở về Sê-i-rơ. ");
INSERT INTO vie1934_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Gia-cốp đi đến Su-cốt; bèn cất một nhà cho mình ở, và mấy cái lều cho súc vật; cho nên họ đặt tên chốn nầy là Su-cốt. ");
INSERT INTO vie1934_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Gia-cốp ở xứ Pha-đan-A-ram đến thành Si-chem thuộc về xứ Ca-na-an, được bình an. Người đóng trại trước thành, ");
INSERT INTO vie1934_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","bèn mua miếng đất chỗ người đóng trại, giá một trăm miếng bạc của con Hê-mô, cha Si-chem. ");
INSERT INTO vie1934_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nơi đó người lập một bàn thờ, đặt tên là Eân-Eân-ô-hê-Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Nàng Đi-na, con gái của Lê-a sanh cho Gia-cốp, đi ra thăm bọn con gái của xứ đó. ");
INSERT INTO vie1934_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Si-chem, con trai Hê-mô, người Hê-vít, hoàng tử xứ đó, thấy nàng, thì cướp đi, nằm với nàng và làm điếm nhục nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tâm hồn chàng vấn-vít cùng Đi-na, con gái Gia-cốp, thương mến con gái tơ đó, lấy lời ngon ngọt nói cùng nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Si-chem nói cùng Hê-mô, cha mình, rằng: Hãy cho tôi con gái nầy làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Vả, Gia-cốp hay được rằng chàng làm hư danh giá Đi-na, con gái mình, nhưng các con trai mình mắc ở ngoài đồng cùng súc vật, nên người làm thinh đến khi họ trở về. ");
INSERT INTO vie1934_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Lúc đó, Hê-mô, cha Si-chem, đến cùng Gia-cốp đặng nói chuyện cùng người. ");
INSERT INTO vie1934_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Các con trai Gia-cốp ở ngoài đồng trở về, vừa hay được việc ấy, bèn nổi nóng và giận lắm, vì việc ô danh mà Si-chem đã xui cho họ Y-sơ-ra-ên, nằm cùng con gái của Gia-cốp, là việc chẳng bao giờ nên làm. ");
INSERT INTO vie1934_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hê-mô nói cùng họ rằng: Tâm hồn Si-chem, con trai tôi, đã dan-díu cùng con gái các ông; xin hãy gả nàng cho nó làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Hãy kết sui-gia cùng nhau; các ông gả con gái cho chúng tôi, rồi cưới các con gái chúng tôi lại. ");
INSERT INTO vie1934_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Hãy ở cùng chúng tôi; xứ sẵn dành cho các ông; hãy ở, buôn bán và dựng cơ nghiệp tại đó. ");
INSERT INTO vie1934_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Si-chem thưa cùng cha và các anh em của người con gái rằng: Xin cho tôi được ơn trước mặt các ông, và điều chi các ông nói, tôi xin nạp cho. ");
INSERT INTO vie1934_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Xin hãy đòi một lễ cưới cho lớn, sính nghi cho cao, tôi xin nạp theo y lời các ông nói; nhưng hãy gả con gái đó cho tôi làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Các con trai Gia-cốp đáp lại cùng Si-chem và Hê-mô, cha chàng, cùng dùng mưu nói chuyện với họ, vì Si-chem đã làm mất danh giá của Đi-na, em gái mình. ");
INSERT INTO vie1934_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Các người ấy nói rằng: Gả em gái chúng tôi cho ai chẳng chịu phép cắt bì, ấy là một việc chúng tôi làm không được, vì sẽ là một nỗi nhuốc nhơ cho chúng tôi vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Chúng tôi sẽ nhận lời các ông được, là khi nào các ông trở nên giống như chúng tôi, tức là mọi người nam chịu phép cắt bì; ");
INSERT INTO vie1934_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","vậy, chúng tôi sẽ gả con gái chúng tôi cho các ông, và sẽ cưới con gái các ông lại; đoạn ta sẽ ở chung nhau, thành ra một dân mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Còn nếu không khứng nghe theo lời, và không chịu phép cắt bì, thì chúng tôi bắt con gái lại và đi ở nơi khác. ");
INSERT INTO vie1934_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Bao nhiêu lời họ nói làm cho đẹp dạ Hê-mô và Si-chem, con trai người. ");
INSERT INTO vie1934_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Chàng trẻ tuổi đó không ngần ngại các việc họ đã định, vì con gái của Gia-cốp đẹp lòng chàng. Vả, chàng đây là một người quí trọng hơn mọi người trong nhà cha mình. ");
INSERT INTO vie1934_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Vậy, Hê-mô và Si-chem, con trai người, đi đến cửa thành mình, nói cùng dân trong thành như vầy: ");
INSERT INTO vie1934_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Các người đó ăn ở hòa thuận giữa vòng chúng ta; vậy cho họ ở trong xứ đặng buôn bán. Nầy, xứ cũng rộng cho họ ở; chúng ta sẽ cưới con gái họ làm vợ, và gả các con gái chúng ta lại. ");
INSERT INTO vie1934_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Nhưng họ bằng lòng ở cùng chúng ta đặng thành một dân, miễn khi nào các người nam trong bọn mình phải chịu phép cắt bì chính như mọi người nam của họ vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Thế thì, há rằng các súc vật, các tài sản và các bầy của họ sẽ chẳng thuộc về chúng ta sao? thôi, ta hãy nhận theo họ điều đó đi, để họ ở chung cùng chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Mọi người đi ra cửa thành mình đều nghe theo lời Hê-mô và Si-chem, con trai người, và hết thảy người nam đi ra cửa thành mình đều chịu phép cắt bì. ");
INSERT INTO vie1934_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Đến ngày thứ ba, khi mọi người đang đau đớn, thì hai con trai Gia-cốp, là Si-mê-ôn và Lê-vi, anh nàng Đi-na, cầm mỗi người một thanh gươm, thừa khi ai nấy yên ổn, xông vào thành giết hết thảy người nam. ");
INSERT INTO vie1934_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hai người lại lấy gươm giết Hê-mô và Si-chem, con trai người, đem nàng Đi-na ra khỏi nhà Si-chem, rồi đi. ");
INSERT INTO vie1934_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Vì cớ họ làm mất danh giá em gái mình, nên các con trai Gia-cốp xông vào những xác chết và phá cướp thành; ");
INSERT INTO vie1934_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","bắt các bầy chiên, bò, lừa, cùng vật chi trong thành và ngoài đồng; ");
INSERT INTO vie1934_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","cướp đem đi hết tài vật, các con trẻ và đàn bà, cùng mọi vật chi ở trong nhà vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Gia-cốp bèn nói cùng Si-mê-ôn và Lê-vi rằng: Bay xui cho tao bối rối, làm cho dân xứ nầy, là người Ca-na-an và người Phê-rê-sít, oán ghét tao vậy. Tao đây, chỉ có ít người; nếu họ hiệp lại đánh tao, thì chắc tao và nội nhà đều bị tàn hại. ");
INSERT INTO vie1934_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Đáp rằng: Chúng tôi nỡ chịu người ta đãi em gái chúng tôi như con đĩ sao? ");
INSERT INTO vie1934_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Đức Chúa Trời phán cùng Gia-cốp rằng: Hãy chổi dậy, đi lên Bê-tên mà ở, và hãy lập nơi đó một bàn thờ cho Đức Chúa Trời, là Đấng hiện ra cùng ngươi đang lúc chạy trốn khỏi Ê-sau, anh ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Gia-cốp bèn nói cùng vợ con và mọi kẻ đi theo mình rằng: Hãy dẹp các tượng thần ngoại bang khỏi giữa các ngươi, làm cho mình được thanh sạch và thay áo xống đi. ");
INSERT INTO vie1934_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Đoạn, chúng ta hãy chổi dậy, đi đến Bê-tên, nơi đó ta sẽ lập một bàn thờ cho Đức Chúa Trời, là Đấng đã trả lời ta trong lúc nguy hiểm, và đã phù hộ ta trong khi đi đường. ");
INSERT INTO vie1934_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Họ bèn đưa cho Gia-cốp các tượng thần ngoại bang của mình, và các vòng đeo nơi tai; rồi người chôn mấy vật đó dưới gốc cây dẻ bộp, gần thành Si-chem. ");
INSERT INTO vie1934_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Đoạn, chúng khởi hành. Đức Chúa Trời bèn giáng sự kinh hãi cho các thành ở chung quanh đó, nên họ chẳng dám đuổi theo các con trai của Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Gia-cốp cùng mọi kẻ đi theo đến tại Lu-xơ (là thành Bê-tên), thuộc về xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Người lập tại đó một bàn thờ, đặt tên chốn nầy Eân-Bê-tên, vì là nơi Đức Chúa Trời đã hiện ra cùng người trong lúc chạy trốn khỏi anh mình. ");
INSERT INTO vie1934_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Khi đó Đê-bô-ra, mụ vú của Rê-be-ca, qua đời, được chôn thân dưới thành Bê-tên tại gốc dẻ bộp; nhân đó người ta gọi là cây A-lôn-Ba-cút. ");
INSERT INTO vie1934_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Khi ở xứ Pha-đan-A-ram đến, Đức Chúa Trời lại hiện ra cùng Gia-cốp nữa, ban phước cho người, ");
INSERT INTO vie1934_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","và phán rằng: Tên ngươi là Gia-cốp, sau nầy sẽ chẳng gọi Gia-cốp nữa, nhưng sẽ đặt là Y-sơ-ra-ên. Rồi Ngài đặt tên người là Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Đức Chúa Trời lại phán rằng: Ta là Đức Chúa Trời toàn năng; ngươi hãy sanh sản và thêm nhiều; một dân cho đến nhiều dân đều sẽ do nơi ngươi mà sanh, cùng các vua sẽ do nơi mình ngươi mà ra. ");
INSERT INTO vie1934_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Xứ ta đã cho Aùp-ra-ham và Y-sác thì ta sẽ cho ngươi cùng dòng dõi ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Đức Chúa Trời bèn ngự lên khỏi nơi Ngài đã phán cùng Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Người dựng một cây trụ đá tại nơi Đức Chúa Trời đã phán cùng mình, dâng lễ quán và tưới dầu vào. ");
INSERT INTO vie1934_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Đoạn, Gia-cốp đặt tên nơi Đức Chúa Trời đã phán cùng mình là Bê-tên. ");
INSERT INTO vie1934_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ỳ từ Bê-tên đi, họ còn cách Ê-phơ-rát chừng vài thôi đường, thì Ra-chên sanh nở. Việc sanh nở của người thật đau đớn. ");
INSERT INTO vie1934_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Trong khi khó sanh, bà mụ nói rằng: Đừng sợ chi, vì nàng còn một con trai nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Vả, bởi Ra-chên gần trút linh hồn, vì đang cơn hấp hối, nên người đặt đứa con trai đó tên là Bê-nô-ni; còn cha nó lại đặt tên là Bên-gia-min. ");
INSERT INTO vie1934_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Vậy, Ra-chên qua đời, được chôn bên con đường đi về Ê-phơ-rát, tức là Bết-lê-hem. ");
INSERT INTO vie1934_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Gia-cốp dựng một mộ-bia; ấy là mộ-bia của Ra-chên đến ngày nay hãy còn di tích. ");
INSERT INTO vie1934_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kế đó, Y-sơ-ra-ên đi, đóng trại ở ngoài nơi tháp Ê-đe. ");
INSERT INTO vie1934_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Vả, nhầm khi Y-sơ-ra-ên ngụ tại xứ nầy, thì Ru-bên có đến nằm cùng Bi-la, vợ lẽ của cha mình; Y-sơ-ra-ên hay được việc đó. ");
INSERT INTO vie1934_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Vả, Gia-cốp có được mười hai con trai. Con của Lê-a là Ru-bên, trưởng nam của Gia-cốp; kế nữa là Si-mê-ôn, Lê-vi, Giu-đa, Y-sa-ca và Sa-bu-lôn. ");
INSERT INTO vie1934_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Con của Ra-chên là Giô-sép và Bên-gia-min. ");
INSERT INTO vie1934_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Con của Bi-la, đòi của Ra-chên là Đan và Nép-ta-li; ");
INSERT INTO vie1934_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","và con của Xinh-ba, đòi của Lê-a, là Gát và A-se. Aáy đó là các con trai của Gia-cốp sanh tại xứ Pha-đan-A-ram. ");
INSERT INTO vie1934_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Gia-cốp đến cùng Y-sác, cha mình, ở Mam-rê, tại thành Ki-ri-át-A-ra-ba, tức là Hếp-rôn, nơi Aùp-ra-ham và Y-sác đã kiều ngụ. ");
INSERT INTO vie1934_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Y-sác hưởng thọ được một trăm tám mươi tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Người tuổi cao tác lớn, thỏa mãn về đời mình, tắt hơi, được về cùng tổ phụ. Ê-sau và Gia-cốp, hai con trai, chôn người. ");
INSERT INTO vie1934_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Đây là dòng dõi của Ê-sau, tức là Ê-đôm vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ê-sau cưới các vợ trong bọn con gái xứ Ca-na-an, là A-đa, con gái Ê-lôn, người Hê-tít; Ô-hô-li-ba-ma, con gái A-na, cháu ngoại của Xi-bê-ôn, người Hê-vít, ");
INSERT INTO vie1934_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","cùng Bách-mát, con gái ỗch-ma-ên, và là em gái của Nê-ba-giốt. ");
INSERT INTO vie1934_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","A-đa sanh Ê-li-pha cho Ê-sau; Bách-mát sanh Rê-u-ên; ");
INSERT INTO vie1934_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","còn Ô-hô-li-ba-ma sanh Giê-úc, Gia-lam và Cô-ra. Aáy đó là các con trai của Ê-sau sanh tại xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ê-sau dẫn các vợ, con trai, con gái mình, mọi người nhà, các bầy chiên, lục-súc, và tài vật mình đã gây dựng tại xứ Ca-na-an, dời qua xứ khác, cách xa Gia-cốp, em mình. ");
INSERT INTO vie1934_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Vả, vì cớ hai anh em của cải nhiều, bầy súc vật đông, xứ đang kiều ngụ không đủ đất dùng nữa, nên ở chung nhau chẳng được. ");
INSERT INTO vie1934_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Vậy, Ê-sau, tức là Ê-đôm, ở trên núi Sê-i-rơ. ");
INSERT INTO vie1934_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Đây là dòng dõi Ê-sau, tổ phụ dân Ê-đôm, ở trên núi Sê-i-rơ. ");
INSERT INTO vie1934_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Đây là tên các con trai Ê-sau: A-đa-vợ người, sanh Ê-li-pha; Bách-mát, cũng vợ người, sanh Rê-u-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Con trai của Ê-li-pha là Thê-ma, Ô-ma, Xê-phô, Ga-tham và Kê-na. ");
INSERT INTO vie1934_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Thim-na, vợ lẽ Ê-li-pha, con trai của Ê-sau, sanh A-ma-léc cho người. Đó là cháu của A-đa, vợ Ê-sau. ");
INSERT INTO vie1934_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Còn đây là con trai của Rê-u-ên: Na-hát, Xê-rách, Sam-ma và Mích-xa. Aáy là các cháu của Bách-mát, cũng vợ Ê-sau. ");
INSERT INTO vie1934_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Và mấy người nầy là con trai của Ô-hô-li-ba-ma, vợ của Ê-sau, con gái A-na, cháu ngoại Xi-bê-ôn. Nàng sanh cho Ê-sau Giê-úc, Gia-lam, và Cô-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Đây là các trưởng tộc trong vòng con cháu Ê-sau: Các con trai Ê-li-pha con trưởng nam của Ê-sau, là trưởng tộc Thê-man, trưởng tộc Ô-ma, trưởng tộc Xê-phô, trưởng tộc Kê-na, ");
INSERT INTO vie1934_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","trưởng tộc Cô-ra, trưởng tộc Ga-tham, và trưởng tộc A-ma-léc. Đó là các trưởng tộc do nơi Ê-li-pha sanh tại xứ Ê-đôm, và là các cháu của A-đa. ");
INSERT INTO vie1934_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Đây là các con trai của Rê-u-ên, con Ê-sau: trưởng tộc Na-hát, trưởng tộc Xê-rách, trưởng tộc Sam-ma, và trưởng tộc Mích-xa. Đó là các trưởng tộc do nơi Rê-u-ên sanh ra tại xứ Ê-đôm, và là các cháu của Bách-mát. ");
INSERT INTO vie1934_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Đây là các con trai của Ô-hô-li-ba-ma, vợ Ê-sau: trưởng tộc Giê-úc, trưởng tộc Gia-lam, và trưởng tộc Cô-ra. Đó là mấy trưởng tộc do Ô-hô-li-ba-ma, vợ Ê-sau, con gái của A-na, sanh ra. ");
INSERT INTO vie1934_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aáy là các con trai của Ê-sau, tức là Ê-đôm, và đó là mấy trưởng tộc của họ. ");
INSERT INTO vie1934_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Đây là các con trai của Sê-i-rơ, người Hô-rít, thuở xưa ở tại xứ đó: Lô-than, Sô-banh, Xi-bê-ôn, A-na, ");
INSERT INTO vie1934_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Đi-sôn, Eùt-xe, và Đi-san. Đó là mấy con trai của Sê-i-rơ, trưởng tộc dân Hô-rít, ở tại xứ Ê-đôm. ");
INSERT INTO vie1934_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Các con trai của Lô-than là Hô-ri và Hê-man; còn Thim-na là em gái Lô-than. ");
INSERT INTO vie1934_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Đây là các con trai của Sô-banh: Anh-van, Ma-na-hát, Ê-banh, Sê-phô, và Ô-nam. ");
INSERT INTO vie1934_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Đây là các con trai của Xi-bê-ôn: Ai-gia và A-na. Aáy là A-na có tìm đặng suối nước sôi nơi đồng vắng, trong khi chăn lừa cho Xi-bê-ôn, cha nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Đây là con cái của A-na: Đi-sôn và Ô-hô-li-ba-ma, con gái người. ");
INSERT INTO vie1934_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Đây là con trai của Đi-sôn: Hem-đan, Eách-ban, Dít-ran và Kê-ran. ");
INSERT INTO vie1934_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Đây là con trai của Eùt-xe: Binh-han, Xa-van và A-can. ");
INSERT INTO vie1934_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Đây là con trai của Đi-san: Uùt-sơ và A-ran. ");
INSERT INTO vie1934_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Còn đây là các trưởng tộc dân Hô-rít: trưởng tộc Lô-than, trưởng tộc Sô-banh, trưởng tộc Xi-bê-ôn, trưởng tộc A-na, ");
INSERT INTO vie1934_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","trưởng tộc Đi-sôn, trưởng tộc Eùt-xe, và trưởng tộc Đi-san. Đó là các trưởng tộc của dân Hô-rít, ở tại xứ Sê-i-rơ. ");
INSERT INTO vie1934_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Trước khi dân Y-sơ-ra-ên chưa có một vua nào cai trị, thì đây là các vua trị vì xứ Ê-đôm; ");
INSERT INTO vie1934_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bê-la, con trai Bê-ô, trì vì xứ Ê-đôm; tên thành người là Đin-ha-ba. ");
INSERT INTO vie1934_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Vua Bê-la băng, Giô-báp, con trai Xê-rách, người Bốt-ra, lên kế vị. ");
INSERT INTO vie1934_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Vua Giô-báp băng, Hu-sam, người xứ Thê-man, lên kế vị. ");
INSERT INTO vie1934_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Vua Hu-sam băng, Ha-đát, con trai Bê-đát, lên kế vị. Aáy là vua nầy đánh thắng dân Ma-đi-an tại đồng Mô-áp; và tên thành người là A-vít. ");
INSERT INTO vie1934_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Vua Ha-đát băng, Sam-la, người Ma-rê-ca lên kế vị. ");
INSERT INTO vie1934_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Vua Sam-la băng, Sau-lơ, người Rê-hô-bốt ở trên mé sông, lên kế vị. ");
INSERT INTO vie1934_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Vua Sau-lơ băng, Ba-anh-Ha-nan, con trai Aïc-bồ, lên kế vị. ");
INSERT INTO vie1934_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","vua Ba-anh-Ha-nan băng, Ha-đa lên kế vị. Tên thành người là Ba-u; vợ người là Mê-hê-ta-bê-ên, con gái của Mát-rết, cháu ngoại Mê-xa-háp. ");
INSERT INTO vie1934_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Đây là các trưởng tộc do nơi Ê-sau sanh ra, kể theo chi tộc, địa hạt và tên mình: trưởng tộc Thim-na, trưởng tộc Anh-va, trưởng tộc Giê-hết, ");
INSERT INTO vie1934_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","trưởng tộc Ô-hô-li-ba-ma, trưởng tộc Ê-la, trưởng tộc Phi-nôn, ");
INSERT INTO vie1934_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","trưởng tộc Kê-na, trưởng tộc Thê-man, trưởng tộc Mép-xa, ");
INSERT INTO vie1934_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","trưởng tộc Mác-đi-ên và trưởng tộc Y-ram. Đó là các trưởng tộc của Ê-đôm, tùy theo nhà ở trong xứ của họ. Tổ phụ của dân Ê-đôm là Ê-sau. ");
INSERT INTO vie1934_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Gia-cốp, tại xứ của cha mình đã kiều ngụ, là xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Đây là chuyện dòng dõi của Gia-cốp. Giô-sép, tuổi mười bảy, chăn chiên với các anh mình; người đi kết bạn cùng con của Bi-la và con của Xinh-ba, hai vợ cha mình. Giô-sép thuật lại với cha các chuyện xấu của họ nói. ");
INSERT INTO vie1934_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Vả, Y-sơ-ra-ên thương yêu Giô-sép hơn những con trai khác, vì là con muộn mình, nên may cho chàng một cái áo dài có nhiều sắc. ");
INSERT INTO vie1934_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Các anh thấy cha thương Giô-sép hơn bọn mình, bèn sanh lòng ganh ghét, chẳng có thế lấy lời tử tế nói cùng chàng được. ");
INSERT INTO vie1934_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Giô-sép có nằm chiêm bao, thuật lại cho các anh mình nghe; họ càng thêm ganh ghét nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Người nói rằng: Tôi có điềm chiêm bao, xin các anh hãy nghe tôi thuật: ");
INSERT INTO vie1934_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Chúng ta đang ở ngoài đồng bó lúa, nầy bó lúa tôi đứng dựng lên, còn bó lúa của các anh đều đến ở chung quanh, sấp mình xuống trước bó lúa tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Các anh người bèn đáp rằng: Vậy, mầy sẽ cai trị chúng ta sao? mầy sẽ hành-quyền trên chúng ta sao? Họ càng ganh ghét hơn nữa, vì điềm chiêm bao và lời nói của chàng. ");
INSERT INTO vie1934_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Giô-sép lại nằm chiêm bao nữa, thuật cùng các anh mình rằng: Tôi còn một điềm chiêm bao nữa: Nầy mặt trời, mặt trăng, và mười một ngôi sao đều sấp mình xuống trước mặt tôi! ");
INSERT INTO vie1934_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Chàng thuật chiêm bao đó lại cho cha và các anh mình nghe; nhưng cha chàng quở mà hỏi rằng: Điềm chiêm bao của mầy đó có nghĩa chi? Có phải tao, mẹ, và các anh mầy đều phải đến sấp mình xuống đất trước mặt mầy chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Các anh lấy làm ganh ghét chàng; còn cha lại ghi nhớ lấy điều đó. ");
INSERT INTO vie1934_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Các anh chàng đi chăn chiên của cha tại Si-chem. ");
INSERT INTO vie1934_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Y-sơ-ra-ên nói cùng Giô-sép rằng: Các anh con có chăn bầy chiên tại Si-chem chăng? Lại đây, đặng cha sai con đi đến chúng nó. Giô-sép đáp rằng: Có con đây. ");
INSERT INTO vie1934_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Y-sơ-ra-ên biểu rằng: Con hãy đi, xem thử các anh con ra sao, và các bầy chiên thể nào; rồi đem tin về cho cha hay. Vậy, từ trũng Hếp-rôn, người sai Giô-sép đi đến Si-chem. ");
INSERT INTO vie1934_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Có một người gặp chàng đi lạc trong đồng ruộng, liền hỏi và nói cùng chàng rằng: Ngươi tìm chi? ");
INSERT INTO vie1934_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Đáp rằng: Tôi tìm các anh tôi. Xin hãy chỉ giùm tôi họ chăn bầy chiên nơi nào. ");
INSERT INTO vie1934_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Người nói: Các anh ngươi ở đây đi rồi, vì tôi có nghe họ nói rằng: Ta hãy đi đến Đô-ta-in. Vậy, Giô-sép, đi tìm các anh mình, gặp được tại Đô-ta-in. ");
INSERT INTO vie1934_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Các anh thấy chàng đi ở đàng xa, chưa đến gần, thì đã lập mưu để giết chàng. ");
INSERT INTO vie1934_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Chúng bèn nói nhau rằng: Kìa, thằng nằm mộng đến kia! ");
INSERT INTO vie1934_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Bây giờ, nào! chúng ta hãy giết nó đi, quăng xuống một cái hố nước nào đó; đoạn ta sẽ nói rằng nó đã bị thú rừng xé ăn, rồi sẽ xem các điềm chiêm bao của nó ra sao. ");
INSERT INTO vie1934_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ru-bên nghe qua lời đó, liền giải cứu chàng ra khỏi tay các anh mà rằng: Chúng ta đừng giết chết nó; ");
INSERT INTO vie1934_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","lại tiếp: Chúng ta chớ nên làm đổ máu ra; hãy liệng nó trong cái hố nước nơi đồng vắng kia, và đừng tra tay vào mình nó. Người nói vậy, có ý muốn giải cứu chàng khỏi tay họ, để trả chàng về cùng cha mình. ");
INSERT INTO vie1934_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Vừa khi Giô-sép đến gần các anh, họ bèn lột áo chàng, là áo có nhiều sắc đang mặc trong mình; ");
INSERT INTO vie1934_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","rồi, bắt chàng đem quăng trong hố nước. Vả, hố khô cạn, chẳng có nước. ");
INSERT INTO vie1934_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Đoạn, họ ngồi lại ăn. Nhướng mắt lên chợt thấy một đoàn dân ỗch-ma-ên ở phía Ga-la-át đi đến, trên lưng lạc đà họ chở đầy thuốc thơm, nhũ hương và một dược đang đem đi đến xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Giu-đa bèn nói cùng các anh em rằng: Giết em ta mà giấu máu nó, có dùng cho ta được việc chi? ");
INSERT INTO vie1934_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Hè! hãy đem bán nó cho dân ỗch-ma-ên và đừng tra tay vào mình nó; vì nó là em, là cốt nhục của chúng ta. Các anh em đều nghe theo lời người nói. ");
INSERT INTO vie1934_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Vả, khi những lái-buôn Ma-đi-an đi ngang qua, các anh kéo Giô-sép lên khỏi hố nước, rồi bán chàng giá hai mươi miếng bạc cho dân ỗch-ma-ên đem qua xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ru-bên trở lại hố; nầy Giô-sép đâu mất rồi; bèn xé áo mình, ");
INSERT INTO vie1934_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","trở lại nơi các em mình mà rằng: Oâi! đứa trẻ đâu mất rồi! còn tôi, sẽ đi đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Các anh giết một con dê đực, rồi lấy áo Giô-sép nhúng vào trong máu; ");
INSERT INTO vie1934_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","đoạn, gởi cái áo nhiều sắc đó đem về cho cha mình và dặn nói rằng: Đây là vật chúng tôi đã kiếm được. Vậy, xin hãy nhìn coi, có phải áo của con trai cha chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Gia-cốp nhìn và nói rằng: Aáy là áo của con trai ta đó; một thú dữ đã xé cấu nó! Quả thật Giô-sép đã bị phân thây rồi! ");
INSERT INTO vie1934_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Người xé quần áo mình ra, lấy bao quấn ngang hông, và để tang lâu ngày cho con trai mình. ");
INSERT INTO vie1934_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Hết thảy con trai, con gái hiệp lại an ủi người, nhưng không chịu; bèn nói rằng: Ta để tang luôn xuống chốn âm phủ cùng con ta! Aáy đó, cha Giô-sép khóc than chàng như vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Các lái buôn Ma-đi-an đem Giô-sép đến xứ Ê-díp-tô, bán cho Phô-ti-pha, quan thị vệ của Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Trong lúc đó, Giu-đa, lìa xa các anh em mình, đến ở cùng một người A-đu-lam, tên là Hi-ra. ");
INSERT INTO vie1934_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Tại đó, Giu-đa thấy con gái của một người Ca-na-an, tên là Su-a, bèn cưới làm vợ, và ăn ở cùng nàng. ");
INSERT INTO vie1934_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nàng thọ thai, sanh được một con trai, đặt tên là Ê-rơ. ");
INSERT INTO vie1934_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nàng thọ thai nữa, sanh được một con trai đặt tên là Ô-nan; ");
INSERT INTO vie1934_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","lại sanh thêm một con trai, đặt tên là Sê-la. Vả, lúc vợ sanh sản, thì Giu-đa ngụ tại Kê-xíp. ");
INSERT INTO vie1934_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Giu-đa cưới cho Ê-rơ, con trưởng nam, một người vợ tên là Ta-ma. ");
INSERT INTO vie1934_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Nhưng Ê-rơ độc ác trước mặt Đức Giê-hô-va, nên Ngài giết người đi. ");
INSERT INTO vie1934_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Giu-đa bèn biểu Ô-nan rằng: Con hãy lại gần vợ anh con, kết bạn cùng nàng như em chồng, đặng nối dòng dõi cho anh. ");
INSERT INTO vie1934_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ô-nan biết rằng dòng dõi nầy sẽ chẳng thuộc về mình, nên đang khi đến cùng nàng, thì làm rơi rớt xuống đất, để đừng sanh dòng dõi cho anh. ");
INSERT INTO vie1934_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nhưng điều người làm vậy không đẹp lòng Đức Giê-hô-va, nên Ngài cũng giết người luôn đi. ");
INSERT INTO vie1934_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Đoạn, Giu-đa biểu Ta-ma, dâu mình, rằng: Hãy về ở góa bên nhà cha con, cho đến chừng nào Sê-la, con trai cha, sẽ trở nên khôn lớn. Vì người nói rằng: Chúng ta hãy coi chừng, e khi nó cũng chết như hai anh nó chăng. Ta-ma bèn đi về ở nhà cha mình. ");
INSERT INTO vie1934_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ngày qua tháng lại, con gái của Su-a, vợ Giu-đa, qua đời. Khi đã nguôi lòng, thì Giu-đa đi cùng bạn là Hi-ra, người A-đu-lam, lên đến nơi mấy thợ hớt lông chiên mình, tại Thim-na. ");
INSERT INTO vie1934_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Người ta cho nàng Ta-ma hay điều đó mà rằng: Nầy, ông gia ngươi đi lên Thim-na đặng hớt lông chiên. ");
INSERT INTO vie1934_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Nàng bèn cổi áo góa bụa mình ra lấy lúp che mặt, và bao phủ mình lại, rồi ngồi trước cửa thành Ê-na-im, bên con đường đi về Thim-na; làm vậy là vì nàng đã thấy Sê-la khôn lớn rồi, nhưng họ không gả mình cho chàng làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Giu-đa thấy nàng, cho là một kỵ nữ, vì nàng che mặt, ");
INSERT INTO vie1934_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","bèn lại gần mà nói rằng: Hãy cho ta đến cùng nàng; vì cớ ngươi không biết nàng là dâu mình. Nàng đáp rằng: Ngươi sẽ cho tôi món chi đặng đi đến cùng tôi? ");
INSERT INTO vie1934_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Đáp rằng: Ta sẽ gởi cho nàng một con dê con của bầy ta. Nàng hỏi: Người sẽ cho tôi một của chi làm tin, cho đến chừng nào sẽ gởi con dê? ");
INSERT INTO vie1934_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Đáp rằng: Ta sẽ cho nàng của chi làm tin bây giờ? Nàng đáp: Con dấu, dây và cây gậy của người đang cầm nơi tay. Người liền cho, đi lại cùng nàng; nàng thọ thai vì người vậy. Đoạn, nàng đứng dậy mà đi, ");
INSERT INTO vie1934_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","cổi lúp ra và mặc quần áo góa bụa lại. ");
INSERT INTO vie1934_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Giu-đa cậy bạn A-đu-lam mình đem cho con dê con đặng chuộc mấy vật tin nơi tay người đàn bà nầy; nhưng tìm nàng chẳng thấy. ");
INSERT INTO vie1934_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Bạn bèn hỏi dân tại nơi nàng ở rằng: Người kỵ nữ khi trước ở ngoài đường nơi cửa thành Ê-na-im đâu rồi? Họ đáp rằng: ỳ đây chẳng có một kỵ nữ nào hết. ");
INSERT INTO vie1934_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Bạn bèn trở về Giu-đa mà rằng: Tôi kiếm nàng không đặng; và dân nơi đó có nói: ở đây chẳng có một kỵ nữ nào. ");
INSERT INTO vie1934_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Giu-đa rằng: Nầy, tôi đã gởi dê con đến, mà bạn tìm chẳng thấy nàng; vậy, để cho nàng giữ lấy của tin đó, chẳng nên gây điều nhơ nhuốc cho chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Cách chừng ba tháng sau, người ta có học lại cùng Giu-đa rằng: Ta-ma, dâu ngươi, đã làm kỵ nữ, và vì nông nổi đó, nàng đã hoang-thai. Giu-đa đáp: Hãy đem nó ra thiêu đi. ");
INSERT INTO vie1934_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Đang khi người ta đem nàng ra, thì nàng sai đến nói cùng ông gia rằng: Xin cha hãy nhìn lại con dấu, dây và gậy nầy là của ai. Tôi thọ thai do nơi người mà có các vật nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Giu-đa nhìn biết mấy món đó, bèn nói rằng: Nàng phải hơn ta, vì ta không đưa Sê-la, con trai ta, cho nàng. Đoạn, người không ăn ở cùng nàng nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Đến kỳ sanh nở, nầy trong bụng nàng có thai đôi. ");
INSERT INTO vie1934_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Đang lúc sanh nở, một trong hai đứa đưa tay ra trước; bà mụ bắt lấy tay buộc một sợi chỉ điều, và nói rằng: Đứa nầy ra trước. ");
INSERT INTO vie1934_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Nhưng nó rút tay vào, thì đây, anh nó lại ra. Bà mụ nói rằng: Mầy, tông rách dường nầy! Họ đặt tên là Phê-rết. ");
INSERT INTO vie1934_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kế em nó ra sau, là đứa nơi tay có sợi chỉ điều, và họ đặt tên là Sê-rách. ");
INSERT INTO vie1934_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Vả, Giô-sép bị đem qua xứ Ê-díp-tô, thì Phô-ti-pha, người bản xứ, làm quan thị vệ của Pha-ra-ôn, mua chàng nơi tay dân ỗch-ma-ên đã dẫn đến. ");
INSERT INTO vie1934_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Giô-sép ở trong nhà chủ mình, là người Ê-díp-tô, được Đức Giê-hô-va phù hộ, nên thạnh lợi luôn. ");
INSERT INTO vie1934_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Chủ thấy Đức Giê-hô-va phù hộ chàng và xui cho mọi việc chi chàng lãnh làm nơi tay đều được thạnh vượng. ");
INSERT INTO vie1934_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Vậy, Giô-sép được ơn trước mặt chủ mình; chủ cắt chàng hầu việc, đặt cai quản cửa nhà, và phó của cải mình cho chàng hết. ");
INSERT INTO vie1934_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Từ khi người đặt Giô-sép cai quản cửa nhà cùng hết thảy của cải mình rồi, thì Đức Giê-hô-va vì Giô-sép ban phước cho nhà người; sự ban phước của Đức Giê-hô-va bủa khắp mọi vật của người làm chủ, hoặc trong nhà, hoặc ngoài đồng. ");
INSERT INTO vie1934_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Người giao hết của cải mình cho Giô-sép coi sóc, chẳng lo đến việc nào nữa, trừ ra các phần vật thực của mình ăn mà thôi. Vả, Giô-sép hình dung đẹp đẽ, mặt mày tốt tươi. ");
INSERT INTO vie1934_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sau các việc nầy, vợ chủ đưa mắt cùng Giô-sép, mà nói rằng: Hãy lại nằm cùng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Chàng từ chối và đáp rằng: Chủ đã giao nơi tay tôi mọi vật của người, và nầy, chủ chẳng lo biết đến việc chi trong nhà nữa; ");
INSERT INTO vie1934_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","trong nhà nầy chẳng ai lớn hơn tôi, và chủ cùng không cấm chi tôi, trừ ra một mình ngươi, vì là vợ của chủ tôi. Thế nào tôi dám làm điều đại ác dường ấy, mà phạm tội cùng Đức Chúa Trời sao? ");
INSERT INTO vie1934_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Thường ngày người dỗ dành mặc dầu, thì Giô-sép chẳng khứng nghe lời dụ dỗ nằm cùng hay là ở cùng người chút nào. ");
INSERT INTO vie1934_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Một ngày kia, Giô-sép vào nhà đặng làm công việc; vả, chẳng có người nhà nào ở đó, ");
INSERT INTO vie1934_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","thì người bèn nắm áo chàng mà rằng: Hãy nằm cùng ta! Nhưng chàng liền tuột áo để lại trong tay người mà chạy trốn ra ngoài. ");
INSERT INTO vie1934_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Khi người thấy áo còn lại nơi tay mình, và chàng đã chạy trốn ra ngoài như vậy, ");
INSERT INTO vie1934_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","bèn gọi người nhà mà nói rằng: Bay coi! Họ khéo đem vào nhà một thằng Hê-bơ-rơ để chọc ghẹo ta. Nó lại gần toan nằm cùng ta, nhưng ta la lớn lên. ");
INSERT INTO vie1934_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Vừa khi nó nghe ta cất tiếng la, thì tuột áo lại bên ta, chạy trốn ra ngoài. ");
INSERT INTO vie1934_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Người bèn để áo của Giô-sép bên mình đợi khi chủ về nhà, ");
INSERT INTO vie1934_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","học lại cùng chủ y như lời trước, rằng: Thằng nô lệ Hê-bơ-rơ mà ông khéo đem về nhà đã đến gần đặng chọc ghẹo tôi; ");
INSERT INTO vie1934_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","nhưng khi tôi cất tiếng la lên, nó tuột áo lại bên tôi, rồi chạy trốn ra ngoài. ");
INSERT INTO vie1934_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Vừa khi chủ của Giô-sép nghe lời vợ nói rằng: Đó, kẻ nô lệ ông làm điều như vậy, thì nổi giận phừng phừng, ");
INSERT INTO vie1934_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","bèn bắt chàng đem bỏ vào tù, là nơi cầm các kẻ phạm tội của vua. Vậy, chàng ở tù tại đó. ");
INSERT INTO vie1934_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Đức Giê-hô-va phù hộ Giô-sép và tỏ lòng nhân từ cùng chàng, làm cho được ơn trước mặt chủ ngục. ");
INSERT INTO vie1934_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Chủ ngục giao hết các kẻ tù trong tay Giô-sép, chẳng việc chi làm qua khỏi được chàng. ");
INSERT INTO vie1934_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Chủ ngục chẳng soát lại những việc đã ở nơi tay Giô-sép, vì có Đức Giê-hô-va phù hộ chàng, xui cho việc chi chàng làm cũng được thạnh vượng. ");
INSERT INTO vie1934_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mấy việc nầy qua rồi, xảy có quan tửu chánh và quan thượng thiện của vua Ê-díp-tô phạm đến chúa mình. ");
INSERT INTO vie1934_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pha-ra-ôn nổi giận cùng hai quan mình, là tửu chánh và thượng thiện, ");
INSERT INTO vie1934_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","bèn đem họ cần ngục tại dinh quan thị vệ, là nơi đang cầm Giô-sép. ");
INSERT INTO vie1934_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Quan thị vệ cắt phần Giô-sép hầu việc hai quan đó; họ bị ngồi ngục một ít lâu. ");
INSERT INTO vie1934_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Cùng trong một đêm, quan tửu chánh và quan thượng thiện của vua Ê-díp-tô đang bị cầm ngục, thấy một điềm chiêm bao, mỗi người một chiêm bao, và mỗi chiêm bao có ý nghĩa rõ ràng. ");
INSERT INTO vie1934_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Sáng mai, Giô-sép đến cùng họ, nhìn thấy sắc buồn bực, ");
INSERT INTO vie1934_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","bèn hỏi rằng: Ngày nay sao hai quan có sắc mặt âu sầu vậy? ");
INSERT INTO vie1934_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Đáp rằng: Chúng tôi có thấy một điềm chiêm bao mà không ai bàn giùm. Giô-sép rằng: Sự bàn chiêm bao há chẳng do nơi Đức Chúa Trời ư? Xin hãy thuật lại điềm chiêm bao của hai quan cho tôi nghe đi. ");
INSERT INTO vie1934_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Quan tửu chánh thuật điềm chiêm bao mình lại cho Giô-sép mà rằng: Trong chiêm bao, tôi thấy một gốc nho ở trước mặt tôi; ");
INSERT INTO vie1934_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","gốc nho đó lại có ba nhành. Dường như thấy nhành nảy chồi, trổ bông, chùm có trái chín thì phải. ");
INSERT INTO vie1934_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tay tôi đang cầm cái chén của Pha-ra-ôn; tôi hái nho đó, ép nước nho vào, rồi dâng tửu bôi vào tay Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Giô-sép nói: -nghiÞa chiêm bao ðoì laÌ thêÒ nâÌy: Ba nhaÌnh nho týìc laÌ ba ngaÌy. ");
INSERT INTO vie1934_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Trong ba ngày nữa, Pha-ra-ôn sẽ tha quan ra khỏi ngục, phục chức lại, quan sẽ dâng cái chén của Pha-ra-ôn vào tay người như cũ, như khi còn làm chức tửu chánh. ");
INSERT INTO vie1934_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Song khi quan được hưởng lạc lại rồi, xin nhớ đến tôi, làm ơn tâu cùng Pha-ra-ôn về nỗi tôi, và đem tôi ra khỏi chốn nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Vì tôi bị người ta bắt đem ra khỏi xứ của người Hê-bơ-rơ, và tại đây tôi cũng chẳng có làm tội gì mà bị cầm nơi lao lung nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Quan thượng thiện thấy Giô-sép bàn mộng được tốt, bèn nói: Còn trong điềm chiêm bao của tôi đây, tôi đội ba giỏ bánh trắng trên đầu; ");
INSERT INTO vie1934_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","trong giỏ cao hơn hết, có đủ món thực vật của thợ làm bánh hấp cho Pha-ra-ôn; chim đáp vào giỏ trên đầu tôi ăn các món đó. ");
INSERT INTO vie1934_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Giô-sép đáp rằng: -nghiÞa chiêm bao nâÌy laÌ, ba gioÒ, týìc laÌ ba ngaÌy. ");
INSERT INTO vie1934_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Trong ba ngày nữa, Pha-ra-ôn sẽ xử trảm quan, sai đem treo lên cây cho chim chóc ăn thịt quan vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Đến ngày thứ ba, là ngày sanh-nhựt của Pha-ra-ôn, người bèn bày tiệc đãi cả quần thần, và tha quan tửu chánh cùng quan thượng thiện ra khỏi ngục. ");
INSERT INTO vie1934_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Pha-ra-ôn phục chức quan tửu chánh lại như xưa, đặng quan nầy dân tửu bôi vào tay mình; ");
INSERT INTO vie1934_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","nhưng lại hạ lịnh đem treo quan thượng thiện, y như lời Giô-sép đã bàn ra. ");
INSERT INTO vie1934_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Đoạn, quan tửu chánh chẳng còn nhớ đến Giô-sép nữa; quên người đi. ");
INSERT INTO vie1934_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Cách hai năm sau, Pha-ra-ôn nằm chiêm bao thấy mình đứng bên bờ sông. ");
INSERT INTO vie1934_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Nầy đâu dưới sông đi lên bảy con bò mập và tốt, ăn cỏ trong bưng. ");
INSERT INTO vie1934_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Rồi nầy, bảy con bò khác, xấu dạng, gầy guộc, ở dưới sông đi theo lên sau, đến đứng gần các con bò trước trên bờ sông. ");
INSERT INTO vie1934_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bảy con bò xấu dạng, gầy guộc nuốt bảy con bò mập tốt. Pha-ra-ôn bèn thức giấc. ");
INSERT INTO vie1934_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Vua nằm ngủ lại, chiêm bao lần thứ nhì, thấy bảy gié lúa chắc, tốt tươi, mọc chung trên một cộng rạ. ");
INSERT INTO vie1934_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kế đó, bảy gié lúa khác lép và bị gió đông thổi háp, mọc theo bảy gié lúa kia. ");
INSERT INTO vie1934_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bảy gié lúa lép nuốt bảy gié lúa chắc. Pha-ra-ôn bèn thức giấc; và nầy, thành ra một điềm chiêm bao. ");
INSERT INTO vie1934_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sáng mai, tâm thần người bất định, truyền đòi các pháp-sư và các tay bác sĩ xứ Ê-díp-tô đến, thuật lại điềm chiêm bao mình cho họ nghe; nhưng chẳng có ai bàn được điềm chiêm bao đó cho vua hết. ");
INSERT INTO vie1934_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Quan tửu chánh bèn tâu cùng Pha-ra-ôn rằng: Bây giờ, tôi nhớ đến lỗi của tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ngày trước, bệ hạ nổi giận cùng quần thần, có cầm ngục quan thượng thiện và tôi nơi dinh quan thị vệ. ");
INSERT INTO vie1934_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Trong lúc đó, cùng một đêm kia, chúng tôi có thấy điềm chiêm bao, chiêm bao mỗi người đều có ý nghĩa riêng rõ ràng. ");
INSERT INTO vie1934_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tại đó, cùng chung ngục, có một người Hê-bơ-rơ, còn trẻ, kẻ gia-đinh của quan thị vệ; chúng tôi thuật lại cho chàng nghe điềm chiêm bao của mình; chàng bàn rõ ra cho ai mỗi chiêm bao nấy. ");
INSERT INTO vie1934_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Rồi ra, công việc xảy đến y như lời chàng bàn: bệ hạ phục chức tôi lại, và xử treo quan kia. ");
INSERT INTO vie1934_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pha-ra-ôn bèn sai đi đòi Giô-sép; họ lập tức tha người ra khỏi ngục, cạo mặt mày cho, biểu thay đổi áo xống, rồi vào chầu Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pha-ra-ôn phán cùng Giô-sép rằng: Trẫm có thấy một điềm chiêm bao mà chẳng ai bàn ra. Vậy, trẫm nghe rằng khi người ta thuật điềm chiêm bao lại cho, thì ngươi bàn được. ");
INSERT INTO vie1934_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Giô-sép tâu rằng: Đó chẳng phải tôi, nhưng ấy là Đức Chúa Trời đem sự bình an đáp cho bệ hạ vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pha-ra-ôn phán rằng: Nầy, trong điềm chiêm bao trẫm đang đứng bên bờ sông. ");
INSERT INTO vie1934_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nầy đâu bảy con bò mập và tốt dưới sông đi lên, đến ăn cỏ trong bưng. ");
INSERT INTO vie1934_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Rồi bảy con bò khác xấu dạng gầy guộc đi theo lên sau; thật trẫm chẳng thấy trong xứ Ê-díp-tô nầy có bò xấu dạng như vậy bao giờ. ");
INSERT INTO vie1934_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bảy con bò xấu dạng gầy guộc đó nuốt bảy con bò mập tốt trước kia, ");
INSERT INTO vie1934_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","nuốt vào bụng, mà dường như không có nuốt, vì các con bò đó vẫn xấu dạng như xưa. ");
INSERT INTO vie1934_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Trẫm bèn thức giấc; rồi lại thấy điềm chiêm bao khác, là bảy gié lúa chắc tốt tươi mọc chung trên một cộng rạ. ");
INSERT INTO vie1934_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kế đó, bảy gié lúa khác, khô, lép, bị gió đông thổi háp, mọc theo bảy gié lúa kia; ");
INSERT INTO vie1934_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","và bảy gié lúa lép đó lại nuốt bảy gié lúa chắc. Trẫm đã thuật điềm chiêm bao nầy cho các pháp-sư, nhưng không ai giải nghĩa ra được. ");
INSERT INTO vie1934_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Giô-sép tâu cùng Pha-ra-ôn rằng: Hai điềm chiêm bao của bệ hạ thấy đó đồng một nghĩa mà thôi; Đức Chúa Trời mách cho bệ hạ biết trước những việc Ngài sẽ làm. ");
INSERT INTO vie1934_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bảy con bò mập tốt đó, tức là bảy năm; bảy gié lúa chắc đó cũng là bảy năm. Aáy chỉ đồng một điềm chiêm bao vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bảy con bò xấu dạng gầy guộc lên theo sau bảy con bò kia, tức là bảy năm; và bảy gié lúa lép bị gió đông thổi háp đó, tức là bảy năm đói kém. ");
INSERT INTO vie1934_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Aáy là điều tôi đã tâu cùng bệ hạ rồi: Đức Chúa Trời có cho bệ hạ thấy những việc Ngài sẽ làm. ");
INSERT INTO vie1934_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nầy, trong khắp xứ Ê-díp-tô sẽ có bảy năm được mùa dư dật. ");
INSERT INTO vie1934_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Nhưng bảy năm đó lại liền tiếp bảy năm đói kém; dân bản xứ đều sẽ quên sự dư dật đó, và ách đói kém sẽ làm cho toàn xứ hao mòn. ");
INSERT INTO vie1934_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Và vì sự đói kém liên tiếp nầy lớn quá, nên thiên hạ chẳng còn thấy chi về sự dư dật đó nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nếu điềm chiêm bao đến hai lần cho bệ hạ, ấy bởi Đức Chúa Trời đã quyết định điều đó rồi, và Ngài mau mau lo làm cho thành vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Bây giờ bệ hạ khá chọn một người thông minh trí-huệ, lập người lên làm đầu trong xứ Ê-díp-tô, ");
INSERT INTO vie1934_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","cùng lập các ủy viên trong xứ, để góp một phần năm của số thâu vào trong bảy năm được mùa dư dật đó. ");
INSERT INTO vie1934_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Họ hãy thâu góp hết thảy mùa màng trong bảy năm được mùa dư dật sẽ đến sau nầy, cùng thâu nhập lúa mì sẵn dành cho Pha-ra-ôn, dùng làm lương để dành trong các thành, và họ hãy giữ gìn lấy. ");
INSERT INTO vie1934_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Các lương thực nầy phải để dành cho bảy năm đói kém sẽ đến trong xứ Ê-díp-tô, hầu cho xứ nầy khỏi bị diệt bởi sự đói kém đó. ");
INSERT INTO vie1934_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Các lời nầy đẹp ý Pha-ra-ôn và quần thần. ");
INSERT INTO vie1934_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pha-ra-ôn phán cùng quần thần rằng: Chúng ta há dễ tìm một người như người nầy, có thần minh của Đức Chúa Trời được sao? ");
INSERT INTO vie1934_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pha-ra-ôn phán cùng Giô-sép rằng: Vì Đức Chúa Trời xui cho ngươi biết mọi việc nầy, thì chẳng còn ai được thông minh trí-huệ như ngươi nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Vậy, ngươi sẽ lên cai trị nhà trẫm; hết thảy dân sự của trẫm đều sẽ vâng theo lời ngươi. Trẫm lớn hơn ngươi chỉ vì ngự ngôi vua mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pha-ra-ôn lại phán cùng Giô-sép rằng: Hãy xem! trẫm lập ngươi cầm quyền trên cả xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Vua liền cổi chiếc nhẫn trong tay mình, đeo vào tay Giô-sép, truyền mặc áo vải gai mịn, và đeo vòng vàng vào cổ người; ");
INSERT INTO vie1934_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","rồi, truyền cho lên ngồi xe sau xe vua, có người đi trước hô rằng: Hãy quì xuống! Aáy, Giô-sép được lập lên cầm quyền cả xứ Ê-díp-tô là vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pha-ra-ôn lại phán cùng Giô-sép: Ta là Pha-ra-ôn, nhưng nếu chẳng có ngươi, thì trong cả xứ Ê-díp-tô không có ai giơ tay đưa chân lên được. ");
INSERT INTO vie1934_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pha-ra-ôn đặt tên Giô-sép là Xa-phơ-nát-Pha-nê-ách, đưa nàng Aùch-nát, con gái Phô-ti-phê-ra, thầy cả thành Oân, cho người làm vợ. Người thường tuần hành trong xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Vả, khi Giô-sép ra mắt Pha-ra-ôn, vua Ê-díp-tô, thì người đã ba mươi tuổi. Vậy, người từ tạ Pha-ra-ôn mà đi tuần khắp xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Trong bảy năm được mùa dư dật, đất sanh sản ra đầy dẫy. ");
INSERT INTO vie1934_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Giô-sép bèn thâu góp hết thảy lương thực của bảy năm đó trong xứ Ê-díp-tô, và chứa lương thực nầy khắp các thành; trong mỗi thành, đều dành chứa hoa lợi của các ruộng ở chung quanh thành đó. ");
INSERT INTO vie1934_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Vậy, Giô-sép thâu góp lúa mì rất nhiều, như cát nơi bờ biển, cho đến đỗi người ta đếm không được, vì đầy dẫy vô số. ");
INSERT INTO vie1934_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Trước khi đến năm đói kém, thì Aùch-nát, con gái Phô-ti-phê-ra, thầy cả thành Oân, sanh cho Giô-sép hai con trai. ");
INSERT INTO vie1934_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Giô-sép đặt tên đứa đầu lòng là Ma-na-se, vì nói rằng: Đức Chúa Trời đã làm cho ta quên điều cực nhọc, và cả nhà cha ta. ");
INSERT INTO vie1934_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Người đặt tên đứa thứ nhì là Eùp-ra-im, vì nói rằng: Đức Chúa Trời làm cho ta được hưng vượng trong xứ mà ta bị khốn khổ. ");
INSERT INTO vie1934_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Bảy năm được mùa dư dật trong xứ Ê-díp-tô bèn qua, ");
INSERT INTO vie1934_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","thì bảy năm đói kém khởi đến, y như lời Giô-sép đã bàn trước. Khắp các xứ khác cũng đều bị đói, nhưng trong cả xứ Ê-díp-tô lại có bánh. ");
INSERT INTO vie1934_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Đoạn, cả xứ Ê-díp-tô đều bị đói, dân chúng đến kêu cầu Pha-ra-ôn xin lương. Pha-ra-ôn phán cùng bản dân rằng: Hãy đi đến Giô-sép, rồi làm theo lời người sẽ chỉ bảo cho. ");
INSERT INTO vie1934_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Khi khắp xứ bị đói kém, thì Giô-sép mở mọi kho lúa mà bán cho dân Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Xứ càng đói nhiều nữa; vả, vì khắp thế gian đều bị đói quá, nên đâu đâu cũng đổ đến Ê-díp-tô mua lúa nơi Giô-sép bán. ");
INSERT INTO vie1934_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Gia-cốp thấy xứ Ê-díp-tô có lúa bán ra, bèn nói cùng các con trai mình rằng: Sao bay ngơ ngẩn nhìn nhau vậy? ");
INSERT INTO vie1934_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Lại rằng: Nầy, cha nghe dưới xứ Ê-díp-tô có lúa bán; bay hãy xuống đó mua lúa cho chúng ta, hầu cho chúng ta sống và khỏi chết, chớ! ");
INSERT INTO vie1934_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Mười người anh của Giô-sép bèn xuống Ê-díp-tô đặng mua lúa. ");
INSERT INTO vie1934_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Nhưng Gia-cốp không cho Bên-gia-min, em Giô-sép, đi cùng các anh; vì nghĩ rằng: Ta nên giữ chừng, kẻo xảy ra điều rủi ro cho nó. ");
INSERT INTO vie1934_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Xứ Ca-na-an bấy giờ cũng đói, nên các con trai của Y-sơ-ra-ên cũng đổ xuống Ê-díp-tô mua lúa như các người khác. ");
INSERT INTO vie1934_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Vả, lúc nầy, chính Giô-sép cai trị trong nước, và bán lúa cho cả dân bản xứ. Các anh Giô-sép bèn đến, sấp mình xuống trước mặt người. ");
INSERT INTO vie1934_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Giô-sép thấy, nhìn biết các anh mình; nhưng giả làm mặt lạ cùng họ, nói một cách xẳng rằng: Các ngươi ở đâu đến? Đáp rằng: ỳ xứ Ca-na-an đến đặng mua lúa. ");
INSERT INTO vie1934_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Vậy, Giô-sép nhìn biết các anh mình; nhưng họ nhìn lại chẳng ra. ");
INSERT INTO vie1934_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Giô-sép nhớ lại điềm chiêm bao mình đã thấy về anh em mình, liền thét rằng: Các ngươi là thám tử, đến đây đặng dòm hành những nơi yếu óp của xứ ta. ");
INSERT INTO vie1934_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Đáp rằng: Thưa chúa, chẳng phải vậy; các tôi tớ chúa đến đặng mua lúa mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Chúng tôi đây đều là con một cha, vốn nhà lương thiện, chẳng phải là thám tử đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Người đáp lại rằng: Chẳng phải; các ngươi đến đặng dòm hành những nơi yếu óp của xứ nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Đáp rằng: Kẻ tôi tớ chúa có mười hai anh em, con của một cha, nguyên xứ Ca-na-an; nầy một người đã đi mất biệt, còn người út hiện bây giờ hãy ở lại nhà cùng cha chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Giô-sép nói: Aáy quả thật như ta đã nói, các ngươi là thám tử. ");
INSERT INTO vie1934_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Đây là điều ta thử các ngươi: Ta chỉ mạng Pha-ra-ôn mà thề rằng, hễ em út các ngươi không đến đây thì chẳng bao giờ các ngươi ra khỏi chốn nầy được. ");
INSERT INTO vie1934_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hãy sai một người nào trong bọn các ngươi về dẫn em út xuống; còn bao nhiêu thì phải ở tù lại đây. Lời các ngươi phải thử đã, rồi ta sẽ biết các ngươi nói đó có quả thật chăng. Nếu chẳng thật, thì ta chỉ mạng Pha-ra-ôn thề rằng, các ngươi là thám tử đó. ");
INSERT INTO vie1934_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Đoạn, Giô-sép truyền đem giam họ chung trong ngục ba ngày. ");
INSERT INTO vie1934_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ngày thứ ba, Giô-sép nói cùng họ rằng: Ta kính sợ Đức Chúa Trời; hãy làm như điều nầy, thì được sống. ");
INSERT INTO vie1934_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nếu các ngươi vốn nhà lương thiện, thì hãy để một người nào ở tù lại đây, còn bao nhiêu đem lương thực về nuôi đói cho nhà các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Đoạn, hãy dẫn em út xuống đây, thì lời các ngươi sẽ cho là thật, và các ngươi chẳng phải chết. Vậy, họ nghe theo. ");
INSERT INTO vie1934_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Họ bèn nói với nhau rằng: Quả thật chúng ta cam tội cùng em ta rồi; vì lúc trước ta thấy tâm hồn nó buồn thảm khi nó xin nhờ ơn, nhưng ta không khứng cho; vậy nên tai vạ nầy mới xảy đến cho chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ru-bên đáp rằng: Anh há không có nói cùng các em rằng: Chớ phạm tội nầy cùng đứa trẻ đó sao? Nhưng các em không nghe; nên bây giờ huyết nó đòi chúng ta thường lại. ");
INSERT INTO vie1934_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Vả, Giô-sép vẫn dùng người thông ngôn nói chuyện lại cùng các anh, nên họ tưởng Giô-sép chẳng nghe hiểu. ");
INSERT INTO vie1934_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Giô-sép xây mặt qua chỗ khác mà khóc. Đoạn xây mặt lại nói chuyện cùng họ; bèn bắt Si-mê-ôn trong vòng anh em, truyền trói lại trước mặt họ. ");
INSERT INTO vie1934_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Giô-sép truyền đầy tớ xúc lúa đổ đầy bao và để bạc lại trong đó cho mỗi người anh em, cũng để thêm lương thực dùng dọc đường. Đầy tớ làm y như lời. ");
INSERT INTO vie1934_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Đoạn, anh em chất mấy bao lúa lên lưng lừa, rồi đi. ");
INSERT INTO vie1934_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Đến quán, một người trong bọn mở bao ra cho lừa ăn thóc, thấy bạc mình ở tại miệng bao; ");
INSERT INTO vie1934_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","bèn nói cùng anh em rằng: Bạc của tôi trả lại, hiện trong bao tôi đây! Các anh em nhát gan, vừa nói với nhau, vừa run, mà rằng: Đức Chúa Trời đã làm chi cho chúng ta đây? ");
INSERT INTO vie1934_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Các anh em trở về cùng Gia-cốp, cha mình, tại xứ Ca-na-an, thuật lại cho người nghe mọi nỗi đã xảy đến, rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","người đang làm chúa tại xứ Ê-díp-tô nói với chúng tôi cách xẳng xớm, cho chúng tôi là thám tử. ");
INSERT INTO vie1934_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Song chúng tôi có thưa cùng người rằng: Chúng tôi vốn nhà lương thiện, nào có phải là thám tử đâu. ");
INSERT INTO vie1934_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Chúng tôi được mười hai anh em, con một cha; một người đã đi mất biệt, còn người út hiện bây giờ ở nhà cùng cha, tại xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Người làm chúa xứ đó dạy rằng: Làm như vầy, ta mới cho các ngươi là lương thiện: Hãy để lại cùng ta một người nào trong bọn các ngươi, còn bao nhiêu sẽ đem lương thực về nuôi đói cho nhà các ngươi; ");
INSERT INTO vie1934_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","đoạn, hãy dẫn em út đến cho ta. Vậy, ta mới biết rằng các ngươi chẳng phải là thám tử, nhưng là người lương thiện; ta sẽ giao em lại cho, và các ngươi sẽ được buôn bán trong xứ nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Vả, đang khi các anh em trút lúa mì ra bao, nầy đâu, trong mỗi bao có gói bạc của mỗi người; cha và các anh em thấy những gói bạc mình, đều lấy làm sợ hãi. ");
INSERT INTO vie1934_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Gia-cốp, cha họ bèn nói rằng: Bay làm mất các con tao; Giô-sép đã mất biệt, Si-mê-ôn cũng mất biệt; mà bây giờ, lại muốn dẫn Bên-gia-min đi nữa sao! Các nông nỗi nầy đều đổ lại cho tao hết! ");
INSERT INTO vie1934_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ru-bên thưa lại cùng cha rằng: Cha hãy giao em nơi tôi, tôi sẽ dẫn về cho. Ví bằng chẳng dẫn em về, thì cha hãy giết hai đứa con trai tôi đi. ");
INSERT INTO vie1934_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Nhưng Gia-cốp đáp rằng: Con út tao sẽ chẳng đi xuống với bay đâu; vì anh nó đã chết rồi, chỉ còn một mình nó mà thôi. Nếu điều rủi ro chi xảy đến cho nó nơi dọc đường bay đi, tức nhiên bay làm cho kẻ tóc bạc nầy đau lòng xót dạ xuống âm phủ. ");
INSERT INTO vie1934_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Vả, sự đói kém trong xứ lớn lắm. ");
INSERT INTO vie1934_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Khi nội nhà đã ăn hết lương thực ở xứ Ê-díp-tô đem về rồi, thì cha các người ấy dạy rằng: Bay hãy trở xuống mua một ít lương thực cho chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Giu-đa thưa: Người đó có nói quyết cùng các con rằng: Ví em út không theo xuống với các ngươi, thì sẽ không bao giờ thấy mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nếu cha cho em đi với, thì chúng tôi mới xuống Ê-díp-tô mua lương thực cho cha được. ");
INSERT INTO vie1934_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Bằng không, thì chúng tôi chẳng trở xuống đâu, vì người đó đã nói rằng: Ví em út không theo xuống với các ngươi, thì sẽ không bao giờ thấy mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Y-sơ-ra-ên quở rằng: Sao bay khéo tệ cùng tao, mà tỏ cho người ấy rằng bay còn một em nữa? ");
INSERT INTO vie1934_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Thưa rằng: Người đó hỏi kỹ càng về chúng tôi, và về bà con chúng tôi rằng: Thân-phụ các ngươi còn sống chăng? còn có một người anh em nào nữa chăng? Chúng tôi có đáp các lời hỏi đó. Há dễ biết người đó sẽ dặn chúng tôi rằng: Hãy đem em út xuống đây, sao? ");
INSERT INTO vie1934_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Giu-đa lại thưa cùng Y-sơ-ra-ên cha mình, rằng: Hãy cho đứa trẻ theo con, thì chúng tôi sẽ đứng dậy đi, hầu cho chúng ta, nào các con, nào cha, nào các cháu của cha đây đều được sống và khỏi chết. ");
INSERT INTO vie1934_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Con sẽ bảo lãnh em cho; cha sẽ cứ nơi con mà đòi em. Nếu không dẫn em về không để em trước mặt cha, thì con đây sẽ cam tội cùng cha mãi mãi. ");
INSERT INTO vie1934_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Vả, nếu không có điều dùng dằng, thì chúng tôi đã đi và về được hai lần rồi. ");
INSERT INTO vie1934_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Đoạn, Y-sơ-ra-ên, cha các anh em, nói rằng: Nếu việc đã thể kia, thì bay phải làm thể nầy: Hãy lấy trong đồ hành lý những thổ sản quí nhất của xứ ta: một ít nhũ hương và mật ong, các hương hoa và một dược, phi tử và hạnh nhân, đem dâng cho người đó làm của lễ. ");
INSERT INTO vie1934_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Hãy đem theo một số tiền bằng hai, đặng thối hồi tiền mà họ đã để lại nơi miệng bao của bay: có lẽ là một sự lộn chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Bay hãy đứng dậy đi, dẫn em út theo và trở xuống đến người đó. ");
INSERT INTO vie1934_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Cầu xin Đức Chúa Trời toàn năng xui cho bay được ơn trước mặt người, và tha đứa em kia và Bên-gia-min cho bay. Còn phần cha, nếu phải mất con, thì cha chịu phận vậy! ");
INSERT INTO vie1934_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Vậy, các anh em đem theo của lễ và một số tiền bằng hai, cùng dẫn Bên-gia-min đồng đứng dậy đi xuống Ê-díp-tô, mà ra mắt Giô-sép. ");
INSERT INTO vie1934_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Vừa khi Giô-sép thấy Bên-gia-min đi theo xuống với, bèn truyền cho quản gia rằng: Hãy đưa các người nầy vào nhà trong, bắt con gì làm thịt và nấu dọn đi; vì trưa nầy họ sẽ dùng bữa cùng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Quản gia làm theo y như lời dặn, đưa họ vào nhà Giô-sép. ");
INSERT INTO vie1934_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Anh em thấy mình phải đưa vào nhà Giô-sép, thì sợ hãi, và nói với nhau rằng: Aáy cũng vì số tiền đã để lại vào bao chúng ta lần trước, nên họ mới đem chúng ta vào chốn nầy, đặng tìm cớ xông vào đánh chúng ta, bắt chúng ta làm tôi mọi, và chiếm đoạt mấy con lừa của chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mấy anh em bèn đến gần quản gia của Giô-sép, thưa cùng người tại ngoài cửa ");
INSERT INTO vie1934_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","mà rằng: Xin chúa tha lỗi cho! anh em chúng tôi đã đến đây một lần rồi, đặng mua lương thực; ");
INSERT INTO vie1934_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","và khi trở về đến nhà quán, mở các bao ra, nầy số bạc của mỗi người đều ở tại miệng bao mình; cân nặng bao nhiêu đều y như bấy nhiêu. Nầy, chúng tôi có đem lại số bạc đó, ");
INSERT INTO vie1934_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","và cũng có đem thêm số bạc nữa đặng mua lương thực. Chẳng biết ai để bạc lại trong bao chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Quản gia đáp rằng: Mọi việc đều bình yên! đừng sợ chi cả! Aáy là Đức Chúa Trời của các ngươi, tức Đức Chúa Trời của cha các ngươi, đã ban vật quí vào bao. Còn bạc các ngươi thì đã có giao cho ta. Đoạn, người dẫn Si-mê-ôn đến cùng anh em; ");
INSERT INTO vie1934_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","rồi đưa anh em vào nhà Giô-sép, đem nước ra cho rửa chân, và cũng cho những lừa ăn cỏ nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Các anh em bèn sửa soạn của lễ, đợi trưa Giô-sép về; vì có hay rằng mình sẽ ăn bữa tại nhà nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Khi Giô-sép trở về, các anh em bèn lấy của lễ đã đem theo, dâng cho Giô-sép tại nhà; rồi cùng sấp mình xuống đất trước mặt người. ");
INSERT INTO vie1934_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Người liền hỏi thăm họ mạnh giỏi thể nào, và nói rằng: Người cha già mà các ngươi đã nói cùng ta đó được mạnh khỏe chăng? còn sống chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Đáp rằng: Kẻ tôi tớ chúa, là cha chúng tôi, vẫn mạnh khỏe và còn sống. Đoạn, họ cúi đầu và lạy. ");
INSERT INTO vie1934_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Giô-sép nhướng mắt thấy Bên-gia-min, em ruột, con trai của mẹ mình, thì hỏi rằng: Đó có phải em út mà các ngươi đã nói cùng ta chăng? Và tiếp rằng: Con út ơi! cầu xin Đức Chúa Trời làm ơn cho ngươi! ");
INSERT INTO vie1934_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Vì thấy em mình, nên Giô-sép tất lòng cảm động, lật đật bước ra ngoài, tìm nơi nào đặng khóc. Người vào phòng nhà trong và khóc. ");
INSERT INTO vie1934_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Đoạn, rửa mặt, bước ra, làm bộ chắc gan mà nói rằng: Hãy dọn bữa ăn đi. ");
INSERT INTO vie1934_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Người ta dọn cho Giô-sép ăn riêng, và cho các anh em ăn riêng. Người Ê-díp-tô ăn chung cùng người cũng dọn cho ngồi riêng nữa; vì người Ê-díp-tô có tánh gớm người Hê-bơ-rơ, nên không ăn chung được. ");
INSERT INTO vie1934_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Vậy, các anh em bèn ngồi lại trước mặt Giô-sép, lớn nhỏ tùy theo thứ tự mình, ngơ ngẩn mà nhìn nhau. ");
INSERT INTO vie1934_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Giô-sép sai đem mấy món đồ ăn trước mặt mình cho các anh em; nhưng phần Bên-gia-min lại nhiều gấp năm của các người khác. Họ uống và ăn ngon vui cùng Giô-sép. ");
INSERT INTO vie1934_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Giô-sép bèn truyền lịnh cho quản gia rằng: Hễ các người đó chở nổi bao nhiêu, thì hãy đổ lương thực cho họ đầy bao bấy nhiêu, rồi để bạc của mỗi người lại nơi miệng bao họ. ");
INSERT INTO vie1934_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Lại hãy để cái chén bằng bạc ta tại miệng bao chung với bạc mua lúa của người út nữa. Quản gia bèn làm y như lời Giô-sép dặn mình. ");
INSERT INTO vie1934_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ngày mai, trời vừa sáng, người ta cho các người đó và lừa về. ");
INSERT INTO vie1934_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Khi đi ra khỏi thành chưa xa, Giô-sép nói cùng quản gia rằng: Ngươi hãy đứng dậy, đuổi theo mấy người đó; khi theo kịp rồi, hãy nói rằng: Sao các ngươi lấy oán trả ơn như vậy? ");
INSERT INTO vie1934_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Có phải cái chén nầy là của chúa ta thường dùng uống rượu và bói chăng? Các ngươi đã làm một việc chẳng thiện đó. ");
INSERT INTO vie1934_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Quản gia theo kịp, lặp lại mấy lời ấy; ");
INSERT INTO vie1934_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","các anh em bèn đáp rằng: Sao chúa nói như vậy? Chẳng bao giờ kẻ tôi tớ chúa có tưởng làm đến việc thế nầy! ");
INSERT INTO vie1934_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Đây, từ xứ Ca-na-an chúng tôi có đem bạc đã được nơi miệng bao xuống giao lại cho người thay; dễ nào lại có ý mong ăn cắp bạc hay vàng của dinh chủ người sao? ");
INSERT INTO vie1934_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Xin cho kẻ tôi tớ nào mà người tìm được cái chén đó phải chết đi, và chính chúng tôi sẽ làm tôi mọi cho chúa. ");
INSERT INTO vie1934_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Quản gia đáp: ã thôi! hãy làm như lời các ngươi đã nói: ta tìm được chén nơi ai thì người đó sẽ làm tôi mọi cho ta đó; còn các người thì vô tội. ");
INSERT INTO vie1934_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tức thì, mỗi người lật đật hạ bao mình xuống đất và mở ra. ");
INSERT INTO vie1934_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Quản gia lục soát, bắt từ bao anh cả lần đến bao em út. Cái chén bèn tìm đặng trong bao Bên-gia-min. ");
INSERT INTO vie1934_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Mỗi người xé áo mình ra, chất bao lúa lên lưng lừa, rồi cùng trở lại thành. ");
INSERT INTO vie1934_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Giu-đa cùng anh em đồng vào đến nhà Giô-sép, người hãy còn ở nơi đó; họ bèn sấp mình xuống đất trước mặt người. ");
INSERT INTO vie1934_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Giô-sép hỏi: Các ngươi gây nên nông nỗi chi vậy? Há chẳng biết một kẻ như ta đây có tài bói sao? ");
INSERT INTO vie1934_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Giu-đa đáp: Chúng tôi sẽ nói cùng chúa làm sao? sẽ phân lại làm sao? sẽ chữa mình chúng tôi làm sao? Đức Chúa Trời đã thấu rõ điều gian ác của tôi tớ chúa rồi. Nầy, chúng tôi cùng kẻ đã bị bắt được chén nơi tay đều làm kẻ tôi tớ cho chúa. ");
INSERT INTO vie1934_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Nhưng Giô-sép đáp rằng: Ta chẳng hề có ý làm như vậy đâu! Người mà đã bị bắt được chén nơi tay sẽ làm tôi mọi ta; còn các ngươi hãy trở về nhà cha mình bình yên. ");
INSERT INTO vie1934_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Giu-đa bèn lại gần Giô-sép mà thưa rằng: Vì chúa ngang vai Pha-ra-ôn, xin lỗi chúa, chớ nổi giận cùng kẻ tôi tớ, để tôi nói một lời cho chúa nghe. ");
INSERT INTO vie1934_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Chúa có hỏi kẻ tôi tớ rằng: Các ngươi còn cha hay là anh em nào chăng? ");
INSERT INTO vie1934_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Có thưa lại cùng chúa rằng: Chúng tôi còn một cha già, cùng một con trai đã sanh muộn cho người. Anh ruột đứa nầy đã chết rồi, nên trong vòng các con của mẹ nó, nó còn một mình, và cha thương nó lắm. ");
INSERT INTO vie1934_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Vả, chúa có dặn rằng: Hãy dẫn nó xuống đến ta, hầu cho ta thấy nó được tận mắt. ");
INSERT INTO vie1934_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Và chúng tôi có thưa lại cùng chúa rằng: Đứa trẻ chẳng lìa cha được; nếu lìa ra thì cha sẽ chết. ");
INSERT INTO vie1934_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nhưng chúa lại dạy: Nếu em út không theo các ngươi xuống đây, thì các ngươi chẳng còn thấy mặt ta nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nên khi chúng tôi trở về nhà kẻ tôi tớ chúa, là cha tôi, thì chúng tôi có thuật lại cho người nghe những lời của chúa. ");
INSERT INTO vie1934_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kế ấy, cha lại biểu chúng tôi rằng: Hãy trở xuống đặng mua một ít lương thực. ");
INSERT INTO vie1934_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Chúng tôi thưa lại rằng: Không được; nhưng nếu em út đi theo cùng, thì mới trở xuống được; bằng không, thì chúng tôi không thế ra mắt người đó. ");
INSERT INTO vie1934_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kẻ tôi tớ chúa, là cha tôi, đáp rằng: Bây biết rằng vợ ta sanh cho ta hai đứa con trai; ");
INSERT INTO vie1934_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","một đứa đã từ ta đi mất-biệt; ta cũng đã nói: Chắc đã bị thú dữ xé rồi, vì đến bây giờ chưa thấy lại. ");
INSERT INTO vie1934_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nếu bây còn dắt đứa nầy đi khỏi mặt ta nữa, rủi có điều tai hại chi xảy đến cho nó, tức nhiên bây sẽ làm cho kẻ tóc bạc nầy đau lòng xót dạ mà xuống âm phủ. ");
INSERT INTO vie1934_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Cha thương em út tôi lắm đến đỗi hai linh hồn khắng khít nhau; nếu bây giờ, khi tôi trở về nơi kẻ tôi tớ chúa, là cha tôi, mà không có em út đó, ");
INSERT INTO vie1934_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","thì khi vừa thấy con út không còn nữa, chắc người sẽ chết. Nếu vậy, các tôi tớ chúa sẽ làm cho cha già tóc bạc của chúng tôi, cũng là kẻ tôi tớ chúa, đau lòng xót dạ xuống âm phủ. ");
INSERT INTO vie1934_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Vì kẻ tôi tớ nầy có chịu bảo lãnh đứa con út đó mà thưa rằng: Nếu con không đem em về cho cha, thì sẽ cam tội cùng cha mãi mãi. ");
INSERT INTO vie1934_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Vậy bây giờ, xin cho kẻ tôi tớ chúa ở tôi mọi thế cho đứa trẻ, đặng nó theo trở lên cùng các anh mình. ");
INSERT INTO vie1934_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Vì, nếu đứa trẻ không theo về, làm sao tôi dám về cùng cha tôi? Oâi, tôi nỡ nào thấy điều tai họa của cha tôi ư! ");
INSERT INTO vie1934_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Bây giờ, Giô-sép không còn thể nào cầm lòng cho đậu được trước mặt các người hầu chung quanh, bèn la lên rằng: Hãy đuổi họ ra hết thảy! Khi Giô-sép tỏ thật cùng các anh em mình, thì không có một người nào khác ở tại đó hết. ");
INSERT INTO vie1934_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Người cất tiếng lên khóc; dân Ê-díp-tô nghe và nhà Pha-ra-ôn nghe nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Giô-sép nói cùng anh em rằng: Tôi là Giô-sép. Cha tôi còn sống chăng? Nhưng trước mặt người các anh em bối rối, chẳng đáp lời được. ");
INSERT INTO vie1934_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Người lại nói rằng: Các anh em hãy lại gần tôi. Họ bèn lại gần. Người nói: Tôi là Giô-sép, em mà các anh đã bán đặng bị dẫn qua xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bây giờ, đừng sầu não, và cũng đừng tiếc chi về điều các anh đã bán tôi đặng bị dẫn đến xứ nầy; vì để giữ gìn sự sống các anh, nên Đức Chúa Trời đã sai tôi đến đây trước các anh. ");
INSERT INTO vie1934_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kìa, hai năm rồi trong xứ đã bị đói kém, và còn năm năm nữa sẽ không còn cày cấy chi, gặt hái chi được hết. ");
INSERT INTO vie1934_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Đức Chúa Trời sai tôi đến đây trước, đặng làm cho các anh còn nối dòng trên mặt đất, và nương một sự giải cứu lớn đặng giữ gìn sự sống cho anh em. ");
INSERT INTO vie1934_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Không, chẳng phải các anh sai tôi đến đây đâu, ấy là Đức Chúa Trời; Ngài dường đặt tôi làm cha Pha-ra-ôn, cai quản cả nhà người, và trị khắp xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Các anh hãy mau mau trở về cha tôi đi, và nói với người rằng: Giô-sép, con của cha, có nói như vầy: Đức Chúa Trời đã đặt tôi làm chúa cả xứ Ê-díp-tô, cha hãy xuống với tôi; xin đừng chậm trễ, ");
INSERT INTO vie1934_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","cha, các con, các cháu, các chiên, bò cùng tài vật của cha sẽ ở tại xứ Gô-sen gần tôi đây. ");
INSERT INTO vie1934_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ỳ đó tôi sẽ nuôi cha, (vì còn năm năm đói kém nữa), e khi cha, người nhà cha, và hết thảy loài vật của cha phải bị ách mà hao mòn. ");
INSERT INTO vie1934_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Này, các anh và Bên-gia-min, em tôi, đã thấy tận mắt rằng, chính miệng tôi đã nói chuyện cùng các anh em đó. ");
INSERT INTO vie1934_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Vậy, hãy thuật lại các điều vinh hiển của tôi tại xứ Ê-díp-tô, cùng mọi việc mà anh em đã thấy cho cha nghe, và hãy mau mau dời cha xuống đây. ");
INSERT INTO vie1934_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Đoạn, người ôm lấy cổ Bên-gia-min, em mình, mà khóc; Bên-gia-min cũng ôm cổ người mà khóc. ");
INSERT INTO vie1934_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Người cũng ôm các anh mình mà khóc. Đoạn, anh em nói chuyện cùng người. ");
INSERT INTO vie1934_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Lập tức, tiếng đồn đến nhà Pha-ra-ôn rằng: Anh em Giô-sép đã đến. Pha-ra-ôn và quần thần nghe lấy làm đẹp dạ. ");
INSERT INTO vie1934_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pha-ra-ôn bèn phán cùng Giô-sép rằng: Hãy dặn các anh em ngươi rằng: Hãy chở đồ lên lừa, đi trở về xứ Ca-na-an, ");
INSERT INTO vie1934_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","rước cha và người nhà của các ngươi xuống ở cùng ta. Ta sẽ nhượng cho vật tốt nhất trong xứ Ê-díp-tô, và các ngươi sẽ hưởng màu mỡ của đất. ");
INSERT INTO vie1934_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Còn ta dặn ngươi hãy nói lại cùng họ như vậy: Hãy đem xe cộ từ xứ Ê-díp-tô về cho con nhỏ và vợ mình, cùng dời cha các ngươi xuống đây. ");
INSERT INTO vie1934_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Đừng tiếc tài vật mình, vì vật tốt nhất của xứ Ê-díp-tô sẽ về phần các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Các con trai của Y-sơ-ra-ên làm y như lời; Giô-sép vâng mạng Pha-ra-ôn, đưa những xe cộ cho anh em mình và lương thực dùng trong lúc đi đường. ");
INSERT INTO vie1934_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Người cũng đưa áo xống mặc đổi thay cho mỗi người, còn Bên-gia-min, người cho trăm miếng bạc cùng năm bộ áo xống. ");
INSERT INTO vie1934_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Người cũng sai đem về cho cha mình mười con lừa chở các vật quí nhất trong xứ Ê-díp-tô, mười con lừa cái chở lúa, bánh, và lương thực để dành dùng trong khi cha đi đường. ");
INSERT INTO vie1934_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Vậy, Giô-sép đưa anh em mình lên đường. Lại dặn họ rằng: Xin anh em đừng cải lẫy nhau dọc đường. ");
INSERT INTO vie1934_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Các anh em ở Ê-díp-tô trở lên và đến xứ Ca-na-an, nơi Gia-cốp, cha mình, ");
INSERT INTO vie1934_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","thuật lại lời nầy mà rằng: Giô-sép hãy còn sống; lại ấy là người đang cai trị cả xứ Ê-díp-tô. Nhưng lòng Gia-cốp vẫn vô tình vì người không tin lời họ nói. ");
INSERT INTO vie1934_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Anh em thuật lại cho người nghe hết mọi lời Giô-sép đã nói; Gia-cốp vừa thấy các xe cộ của Giô-sép sai đem về đặng rước mình, thì tâm thần người tỉnh lại, ");
INSERT INTO vie1934_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","bèn nói rằng: Thôi, biết rồi; Giô-sép, con trai ta, hãy còn sống; ta sẽ đi thăm nó trước khi ta qua đời. ");
INSERT INTO vie1934_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Y-sơ-ra-ên ra đi, đem theo các tài vật mình. Đến Bê-e-Sê-ba, người bày của lễ dâng cho Đức Chúa Trời của Y-sác, cha mình. ");
INSERT INTO vie1934_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Trong một sự hiện thấy ban đêm kia, Đức Chúa Trời có phán cùng Y-sơ-ra-ên rằng: Hỡi Gia-cốp, Gia-cốp! Y-sơ-ra-ên đáp rằng: Có tôi đây. ");
INSERT INTO vie1934_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Đức Chúa Trời phán: Ta là Đức Chúa Trời, Đức Chúa Trời của cha ngươi. Hãy xuống Ê-díp-tô, đừng sợ chi, vì tại đó ta sẽ làm cho ngươi thành một nước lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Chính ta sẽ xuống đến đó với ngươi, và chính ta cũng sẽ dẫn ngươi về chẳng sai. Giô-sép sẽ vuốt mắt ngươi nhắm lại. ");
INSERT INTO vie1934_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Từ Bê-e-Sê-ba, Gia-cốp khởi đi; các con trai Y-sơ-ra-ên để Gia-cốp, cha mình, cùng các vợ và con mình lên xe cộ của Pha-ra-ôn đã sai đến rước những người đó. ");
INSERT INTO vie1934_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Chúng cũng đem theo các súc vật và của cải mình đã gây dựng tại xứ Ca-na-an, mà đi đến xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Vậy, Gia-cốp cùng cả nhà người, nào các con trai, nào các cháu trai, nào các con gái, nào các cháu gái, thảy đều xuống xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Đây là tên các con trai của Y-sơ-ra-ên, tức là Gia-cốp, đến xứ Ê-díp-tô: Con trưởng nam của Gia-cốp là Ru-bên. ");
INSERT INTO vie1934_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Các con trai của Ru-bên là Hê-nóc, Pha-lu, Hết-rôn, và Cạt-mi. ");
INSERT INTO vie1934_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Các con trai của Si-mê-ôn là Giê-mu-ên, Gia-min, Ô-hát, Gia-kin, Xô-ha, và Sau-lơ, tức con của người vợ xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Các con trai của Lê-vi là Ghẹt-sôn, Kê-hát, và Mê-ra-ri. ");
INSERT INTO vie1934_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Các con trai của Giu-đa là Ê-rơ, O-nan, Sê-la, Phê-rết và Sê-rách. Nhưng Ê-rơ và O-nan đã thác tại xứ Ca-na-an; con của Phê-rết là Hết-rôn, và Ha-mun. ");
INSERT INTO vie1934_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Các con trai của Y-sa-ca là Thô-la, Phu-va, Gióp và Sim-rôn. ");
INSERT INTO vie1934_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Các con trai của Sa-bu-lôn là Sê-rết, Ê-lôn, và Gia-lê-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Vả, các con trai, và một con gái tên là Đi-na, mà Lê-a sanh cho Gia-cốp khi ở tại Pha-đan-A-ram, cùng các cháu đó, hết thảy là ba mươi ba người. ");
INSERT INTO vie1934_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Các con trai của Gát là Xi-phi-ôn, Ha-ghi, Su-ni, Eùt-bôn, Ê-ri, A-rô-đi và A-rê-li. ");
INSERT INTO vie1934_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Các con trai của A-se là Dim-na, Dích-và, Dích-vi, và Bê-ri-a, cùng Sê-rách, em gái các người đó. Con của Bê-ri-a là Hê-be, và Manh-ki-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Vả, các con trai của nàng Xinh-ba sanh cho Gia-cốp, cùng các cháu đó, hết thảy là mười sáu người. Nàng là con đòi của La-ban đã cho theo hầu Lê-a, con gái mình. ");
INSERT INTO vie1934_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Các con trai của Ra-chên, vợ Gia-cốp, là Giô-sép, và Bên-gia-min. ");
INSERT INTO vie1934_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Giô-sép đã có con tại xứ Ê-díp-tô, là Ma-na-se, và Eùp-ra-im, mà Aùch-nát, con gái của Phô-ti-phê-ra, thầy cả thành Oân, đã sanh cho người. ");
INSERT INTO vie1934_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Các con trai của Bên-gia-min là Bê-la, Bê-kê, Aùch-bên, Giê-ra, Na-a-man, Ê-hi, Rô-sơ, Mốp-bim, Hốp-bim, và A-rết. ");
INSERT INTO vie1934_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Vả, các con trai của Ra-chên sanh cho Gia-cốp, cùng các cháu đó, hết thảy là mười bốn người. ");
INSERT INTO vie1934_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Con trai của Đan là Hu-sim. ");
INSERT INTO vie1934_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Các con trai của Nép-ta-li là Giát-sê-ên, Gu-ni, Dít-se, và Si-lem. ");
INSERT INTO vie1934_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Vả, các con trai của nàng Bi-la sanh cho Gia-cốp, cùng các cháu đó, hết thảy là bảy người. Nàng là con đòi của La-ban đã cho theo hầu Ra-chên, con gái mình. ");
INSERT INTO vie1934_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Các người đi đến xứ Ê-díp-tô với Gia-cốp, tức là các người do nơi Gia-cốp sanh, nếu không kể các nàng dâu, thì hết thảy là sáu mươi sáu người. ");
INSERT INTO vie1934_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Con của Giô-sép đã sanh tại Ê-díp-tô được hai. Vậy, các người thuộc về nhà Gia-cốp đi đến Ê-díp-tô, cọng hết thảy là bảy mươi người. ");
INSERT INTO vie1934_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Gia-cốp sai Giu-đa đi đến trước đặng xin Giô-sép đưa mình vào bờ cõi Gô-sen. Vậy, họ đều vào xứ Gô-sen. ");
INSERT INTO vie1934_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Giô-sép thắng xe đi lên Gô-sen, đón Y-sơ-ra-ên, cha mình. Người ra mắt cha, ôm choàng lấy người và khóc một hồi lâu. ");
INSERT INTO vie1934_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Y-sơ-ra-ên nói cùng Giô-sép rằng: Chớ chi cho cha chết bây giờ đi! vì cha đã thấy được mặt con, và biết con vẫn còn sống. ");
INSERT INTO vie1934_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Đoạn Giô-sép nói cùng anh em và người nhà cha mình rằng: Tôi sẽ lên trước tâu cho Pha-ra-ôn hay rằng: Anh em và cả nhà cha tôi, ở xứ Ca-na-an đã đến cùng tôi. ");
INSERT INTO vie1934_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Họ vốn làm nghề chăn chiên, nuôi bầy súc vật; có dẫn theo hết bầy chiên, bò và các tài vật của mình. ");
INSERT INTO vie1934_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Và khi Pha-ra-ôn truyền gọi anh em mà hỏi rằng: Các ngươi làm nghề chi? ");
INSERT INTO vie1934_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Thì hãy tâu rằng: Kẻ tôi tớ chúa cùng tổ phụ chúng tôi vẫn làm nghề nuôi súc vật từ thuở còn nhỏ cho đến giờ. Aáy hầu cho anh em đặng ở lại xứ Gô-sen, vì dân Ê-díp-tô có tánh gớm ghê hết thảy kẻ chăn chiên lắm. ");
INSERT INTO vie1934_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Giô-sép đến tâu mọi điều đó cho Pha-ra-ôn hay, và nói rằng: Cha và anh em tôi đã ở xứ Ca-na-an đến, có đem theo chiên, bò, cùng các tài vật của mình. Hiện bây giờ đang ở trong xứ Gô-sen. ");
INSERT INTO vie1934_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Người bèn đưa năm người trong bọn anh em mình vào yết kiến Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pha-ra-ôn hỏi: Các ngươi làm nghề chi? Tâu rằng: Kẻ tôi tớ bệ hạ là kẻ chăn chiên, như tổ phụ chúng tôi khi trước. ");
INSERT INTO vie1934_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Rồi lại tâu rằng: Aáy đặng kiều ngụ trong xứ mà kẻ tôi tớ bệ hạ đã đến; vì xứ Ca-na-an đói kém lớn lắm, không còn đồng cỏ chi hết cho bầy súc vật ăn. Vậy, xin phép cho kẻ tôi tớ bệ hạ ngụ tại xứ Gô-sen. ");
INSERT INTO vie1934_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pha-ra-ôn phán cùng Giô-sép như vầy: Cha và anh em ngươi đã đến cùng ngươi; ");
INSERT INTO vie1934_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","vậy, xứ Ê-díp-tô sẵn dành cho ngươi; hãy cho cha và anh em ở chốn nào tốt hơn hết trong xứ; hãy cho ở tại xứ Gô-sen vậy. Và nếu trong các người đó, ngươi biết ai giỏi, hãy đặt họ chăn các bầy súc vật của ta. ");
INSERT INTO vie1934_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Đoạn, Giô-sép dẫn Gia-cốp, cha mình, đến yết-kiến Pha-ra-ôn. Gia-cốp chúc phước cho Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pha-ra-ôn hỏi Gia-cốp rằng: Ngươi hưởng thọ được bao nhiêu tuổi? ");
INSERT INTO vie1934_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Gia-cốp tâu rằng: Những năm tôi sống ở đời phiêu lưu hết thảy là một trăm ba mươi năm; các năm của đời tôi lấy làm ngắn-ngủi và lại nhọc nhằn, chẳng bằng những năm bình sanh của tổ phụ tôi khi người ở phiêu lưu đó. ");
INSERT INTO vie1934_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Gia-cốp chúc phước cho Pha-ra-ôn một lần nữa, rồi lui ra khỏi mặt người. ");
INSERT INTO vie1934_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Vậy, Giô-sép vâng mạng Pha-ra-ôn, định chỗ ở cho cha và anh em mình, cho họ một sở đất tốt nhất trong xứ Ê-díp-tô làm sản nghiệp, tại miền Ram-se. ");
INSERT INTO vie1934_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Giô-sép, tùy theo số người, cấp lương thực cho cha, anh em và cả nhà cha mình. ");
INSERT INTO vie1934_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Vả, sự đói kém lớn lắm, nên trong khắp xứ chẳng còn lương thực nữa; xứ Ê-díp-tô và xứ Ca-na-an đều bị hao mòn vì ách đói kém đó. ");
INSERT INTO vie1934_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Giô-sép thâu hết bạc tiền trong xứ Ê-díp-tô và xứ Ca-na-an, tức giá tiền của muôn dân mua lúa; rồi chứa bạc đó vào kho Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Khi bạc tiền trong xứ Ê-díp-tô và xứ Ca-na-an đã hết, thì tất cả dân Ê-díp-tô đều đến cùng Giô-sép mà kêu rằng: Xin cho chúng tôi lương thực; lẽ nào vì cớ hết tiền mà chúng tôi phải chết trước mặt chúa sao? ");
INSERT INTO vie1934_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Giô-sép đáp rằng: Nếu hết bạc tiền rồi, hãy giao súc vật các ngươi cho ta, ta sẽ phát lương thực đổi lại. ");
INSERT INTO vie1934_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Đoạn, dân chúng bèn dẫn súc vật lại cho Giô-sép; Giô-sép phát lương thực đổi lấy ngựa, bầy chiên, bầy bò, và lừa. Năm đó, người thâu các bầy súc vật của họ mà đổi thế lương thực cho. ");
INSERT INTO vie1934_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mãn năm rồi, năm sau dân chúng lại đến kêu cùng người rằng: Chúng tôi không dấu chi chúa: tiền bạc sạch trơn, bầy súc vật đã giao cho chúa; bây giờ chỉ sẵn dành cho chúa bản thân và đất ruộng. ");
INSERT INTO vie1934_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Lẽ nào chúng tôi và đất ruộng phải hao mòn trước mặt chúa sao? Hãy mua đổi lấy lương thực chúng tôi và đất ruộng luôn đi. Vậy, chúng tôi cùng đất ruộng sẽ làm tôi mọi cho Pha-ra-ôn. Hãy cho giống chi đặng gieo, hầu cho chúng tôi sống khỏi chết, và đất không phải bỏ hoang. ");
INSERT INTO vie1934_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Giô-sép bèn mua hết thảy ruộng đất trong xứ Ê-díp-tô cho Pha-ra-ôn; vì sự đói kém thúc giục nên mọi người Ê-díp-tô đều đem bán ruộng mình; vậy, ruộng đất đều thuộc về Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Còn dân chúng, từ đầu nầy đến đầu kia, người đều dời về ở trong các thành. ");
INSERT INTO vie1934_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Song ruộng đất của những thầy cả thì Giô-sép không mua đến, vì những thầy cả có lãnh một phần lương của Pha-ra-ôn đã định; vậy, họ ăn phần lương thực của Pha-ra-ôn đã cấp cho. Thế cho nên những thầy cả chẳng đem bán đất của mình. ");
INSERT INTO vie1934_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Giô-sép nói cùng dân chúng rằng: Nầy, ta đã mua các ngươi và ruộng đất cho Pha-ra-ôn; đây, hột giống cho các ngươi đặng gieo mạ trong ruộng đó. ");
INSERT INTO vie1934_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Đến mùa gặt, phải nộp cho Pha-ra-ôn một phần năm, còn bốn phần kia để cho các ngươi làm giống gieo mạ, dùng lương thực cho mình, cho người nhà cùng cho các con nhỏ mình. ");
INSERT INTO vie1934_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Dân chúng nói rằng: Chúa đã cứu mạng chúng tôi! Cầu xin cho chúng tôi được nhờ ơn trước mặt chúa, thì sẽ làm tôi mọi cho Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Về việc đó, Giô-sép bèn định một luật, cho đến ngày nay hãy còn, buộc đất Ê-díp-tô phải nộp thuế cho Pha-ra-ôn một phần năm hoa lợi mình. Chỉ đất ruộng của những thầy cả chẳng thuộc về Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Vậy, Y-sơ-ra-ên trú ngụ tại miền Gô-sen thuộc về xứ Ê-díp-tô, gây được cơ nghiệp tại đó, sanh sản và thêm lên bội phần. ");
INSERT INTO vie1934_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Gia-cốp kiều ngụ trong xứ Ê-díp-tô được mười bảy năm, hưởng thọ được một trăm bốn mươi bảy tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Khi ngày gần chết, Y-sơ-ra-ên gọi Giô-sép, con trai mình, mà nói rằng: Nếu cha được nhờ ơn trước mặt con, xin hãy để tay lên đùi cha cậy hết lòng nhân từ và thành thực ở cùng cha, xin con đừng chôn cha tại đất Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Khi cha an-giấc cùng tổ phụ rồi, hãy đem cha ra khỏi Ê-díp-tô; chôn chung cùng mồ mả của người. Giô-sép thưa rằng: Con sẽ làm y theo lời cha dặn. ");
INSERT INTO vie1934_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Giô-sép nói: Con hãy thề đi. Giô-sép bèn thề. Đoạn, Y-sơ-ra-ên quì lạy nơi đầu giường mình. ");
INSERT INTO vie1934_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Vả, khi các việc đó qua rồi, có người nói cùng Giô-sép rằng: Nầy cha người đau; Giô-sép bèn đem Ma-na-se và Eùp-ra-im, hai đứa con trai mình, cùng đi đến. ");
INSERT INTO vie1934_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Họ cho Gia-cốp hay và nói rằng: Nầy Giô-sép, con trai ông, đến thăm ông đó; Y-sơ-ra-ên cố gượng ngồi dậy trên giường. ");
INSERT INTO vie1934_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Gia-cốp nói cùng Giô-sép rằng: Đức Chúa Trời toàn năng đã hiện ra, bà ban phước cho cha tại Lu-xơ, trong xứ Ca-na-an, ");
INSERT INTO vie1934_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","mà phán rằng: Nầy ta sẽ làm cho ngươi sanh sản và thêm nhiều, làm thành một hội dân; ta sẽ cho dòng dõi ngươi xứ nầy làm cơ nghiệp đời đời. ");
INSERT INTO vie1934_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Bây giờ, hai đứa con trai đã sanh cho con tại xứ Ê-díp-tô trước khi cha đến, là Eùp-ra-im và Ma-na-se, cũng sẽ thuộc về cha như Ru-bên và Si-mê-ôn vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Còn mấy đứa mà con sanh kế đó, thì sẽ thuộc về con; về phần hưởng cơ nghiệp, chúng nó sẽ đồng một thể cùng anh em mình. ");
INSERT INTO vie1934_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Khi cha ở Pha-đan trở về xứ Ca-na-an, thì Ra-chên chết dọc đường có mặt cha, gần Ê-phơ-rát; cha chôn người ở bên con đường đi về Ê-phơ-rát (tức là Bết-lê-hem). ");
INSERT INTO vie1934_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Y-sơ-ra-ên thấy các con trai Giô-sép, bèn hỏi rằng: Những đứa nầy là ai? ");
INSERT INTO vie1934_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Giô-sép thưa rằng: Aáy là những con trai của con mà Đức Chúa Trời đã cho tại xứ nầy. Y-sơ-ra-ên lại nói: Xin hãy đem đến đây, đặng cha chúc phước cho chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Vả, mắt của Y-sơ-ra-ên già nên làng, chẳng thấy chi nữa, bèn biểu chúng nó lại gần, ôm choàng và hôn. ");
INSERT INTO vie1934_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Y-sơ-ra-ên nói cùng Giô-sép rằng: Trước cha tưởng chẳng còn thấy được mặt con, nhưng bây giờ Đức Chúa Trời lại làm cho cha thấy được đến dòng dõi con nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Giô-sép dẫn hai đứa con trai ra khỏi hai đầu gối cha mình, rồi sấp mình xuống đất. ");
INSERT INTO vie1934_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Đoạn, người dẫn hai đứa trẻ lại gần cha; tay hữu thì dẫn Eùp-ra-im sang qua phía tả của cha, còn tay tả dắt Ma-na-se sang qua phía hữu. ");
INSERT INTO vie1934_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Y-sơ-ra-ên đưa tay mặt ra, để trên đầu Eùp-ra-im, là đứa nhỏ, còn tay trái lại để trên đầu Ma-na-se. Người có ý riêng để tay như vậy, vì Ma-na-se là đứa lớn. ");
INSERT INTO vie1934_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Rồi người chúc phước cho Giô-sép rằng: Cầu xin Đức Chúa Trời mà tổ phụ tôi là Aùp-ra-ham và Y-sác đã thờ phượng; là Đức Chúa Trời đã chăn nuôi tôi từ khi mới lọt lòng cho đến ngày nay, ");
INSERT INTO vie1934_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","thiên sứ đã cứu tôi ra ngoài vòng hoạn nạn, hãy ban phước cho hai đứa trẻ nầy; nối danh tôi và tổ phụ tôi là Aùp-ra-ham và Y-sác, và cho chúng nó thêm lên nhiều vô số trên mặt đất! ");
INSERT INTO vie1934_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Nhưng Giô-sép thấy cha mình để tay hữu trên đầu Eùp-ra-im, thì có ý bất bình, liền nắm lấy tay cha đã để lên đầu Eùp-ra-im mà tráo đổi qua đầu Ma-na-se, ");
INSERT INTO vie1934_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","rồi thưa rằng: Chẳng phải vậy, cha. Đứa nầy đầu lòng, để tay hữu cha trên đầu nó mới phải chớ. ");
INSERT INTO vie1934_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Nhưng cha người không chịu và cãi rằng: Cha biết, con, cha biết. Nó sẽ trở nên một dân; nó cũng sẽ lớn vậy, con; song thể nào em nó cũng sẽ lớn hơn và dòng dõi nó sẽ thành ra vô số nước. ");
INSERT INTO vie1934_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Trong ngày đó, người chúc phước cho hai đứa con trai nầy mà nói rằng: Aáy vì ngươi mà dân Y-sơ-ra-ên sẽ chúc phước nhau rằng: Cầu xin Đức Chúa Trời làm cho ngươi được giống như Eùp-ra-im và Ma-na-se. Vậy, Gia-cốp đặt Eùp-ra-im trước Ma-na-se. ");
INSERT INTO vie1934_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Y-sơ-ra-ên lại nói cùng Giô-sép rằng: Nầy, cha sẽ thác, nhưng Đức Chúa Trời sẽ phù hộ và đem các con trở về xứ tổ phụ. ");
INSERT INTO vie1934_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Còn cha sẽ cho con một phần đất trổi hơn các anh em, là phần đất của cha đã dùng cung-kiếm đoạt lấy của dân A-mô-rít đó. ");
INSERT INTO vie1934_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Gia-cốp gọi các con trai mình lại và nói rằng: Hãy hội lại đây, cha sẽ nói những điều phải xảy đến cho các con ngày sau. ");
INSERT INTO vie1934_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Hỡi các con trai Gia-cốp, hãy hội lại mà nghe; Nghe lời Y-sơ-ra-ên, cha của các con. ");
INSERT INTO vie1934_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Hỡi Ru-bên! con là trưởng nam của cha, Sức lực cha, và đầu tiên sự mạnh mẽ cha; Vốn có sự tôn trọng và quyền năng tột đỉnh. ");
INSERT INTO vie1934_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Con sôi trào như nước, nên sẽ chẳng phần hơn ai! Vì con đã lên giường cha. Con lên giường cha bèn làm ô làm dơ đó! ");
INSERT INTO vie1934_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Si-mê-ôn và Lê-vi là anh em ruột. Thanh gươm chúng nó thật khí giới hung tàn. ");
INSERT INTO vie1934_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Cầu cho tâm hồn cha chớ có đồng mưu, Vinh hiển cha chớ hiệp cùng hội họ; Vì họ đã giết người trong cơn giận dữ, Cắt nhượng bò đực vì ý riêng mình. ");
INSERT INTO vie1934_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Đáng rủa sả thay cơn giận dữ họ, vì thật là hung mạnh! Đáng rủa sả thay khí giận họ, vì dữ dằn thay! Ta sẽ phân chia họ ra trong nhà Gia-cốp, Tan lạc họ trong dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Hỡi Giu-đa! các anh em sẽ khen ngợi con, Tay con sẽ chận cổ quân nghịch, Các con trai cha sẽ quì lạy trước mặt con. ");
INSERT INTO vie1934_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Giu-đa là một sư tử tơ; Hỡi con! Con bắt được mồi rồi tha về. Nó sụm gối, nằm khác nào sư tử đực, Như sư tử cái; há ai dám khiến ngồi lên? ");
INSERT INTO vie1934_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Cây phủ việt chẳng hề dời khỏi Giu-đa, Kẻ lập pháp không dứt khỏi giữa chân nó, Cho đến chừng Đấng Si-lô hiện tới, Và các dân vâng phục Đấng đó. ");
INSERT INTO vie1934_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Người buộc lừa tơ mình vào gốc nho, Lừa con mình vào nhành nho tốt nhất. Người giặt áo xống mình vào rượu nho, Cùng lấy huyết nho lau áo tơi mình. ");
INSERT INTO vie1934_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mắt người đỏ vì cớ rượu, Răng người trắng vì cớ sữa. ");
INSERT INTO vie1934_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sa-bu-lôn sẽ ở nơi gành biển, Tức là nơi có tàu đậu; Bờ cõi người chạy về hướng Si-đôn. ");
INSERT INTO vie1934_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Y-sa-ca là một con lừa mạnh mẽ, Nằm nghỉ giữa chuồng; ");
INSERT INTO vie1934_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Thấy rằng sự yên ổn là tốt lành, Và đất-đai đẹp lắm thay. Người đã rùn vai vác gánh nặng, Phải vâng phục những điều sưu-dịch. ");
INSERT INTO vie1934_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Đan sẽ xử đoán dân chúng mình, Như một trong các chi phái Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Đan sẽ là một con rắn trên đường, Một con rắn lục trong chốn nẻo cùng, Cắn vó ngựa, Làm cho kẻ cỡi phải té nhào. ");
INSERT INTO vie1934_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Hỡi Giê-hô-va! tôi trông ơn chửng cứu của Ngài! ");
INSERT INTO vie1934_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Còn Gát sẽ bị một đạo binh xông đánh, Nhưng người xông đánh lại và đuổi theo. ");
INSERT INTO vie1934_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Do nơi A-se có thực vật ngon, Người sẽ cung cấp mỹ vị cho các vua. ");
INSERT INTO vie1934_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nép-ta-li là nai cái thả chuồng Nói bày nhiều lời văn hoa. ");
INSERT INTO vie1934_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Giô-sép là chồi của cây tươi tốt, Mọc gần bên suối nước; Nhành nhánh phủ bao trên ngọn tường. ");
INSERT INTO vie1934_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kẻ cầm cung đã ghẹo chọc người, Bắn tên vào, và hãm đánh; ");
INSERT INTO vie1934_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Nhờ tay Đấng toàn năng của Gia-cốp, Nên cung người vẫn bền-chắc; Nhờ Đấng Chăn chiên, là Đá của Y-sơ-ra-ên, Nên hai tay người thêm mạnh. ");
INSERT INTO vie1934_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Đức Chúa Trời của Cha sẽ giúp đỡ con; Đấng toàn năng sẽ ban phước cho con, Tức là phước lành ở chốn trời cao xuống, Cùng phước lành ở nơi vực rộng thẳm lên, Phước lành của vú, và của lòng mẹ. ");
INSERT INTO vie1934_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Phước lành cha chúc cho con vượt lần lên Cao hơn các phước lành của tổ phụ cha, Cho đến các chót núi đời đời: Các phước nầy sẽ ở nơi đầu Giô-sép, Nơi trán của chúa các anh em mình. ");
INSERT INTO vie1934_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bên-gia-min là một con chó sói hay cấu xé; Ban mai đi đánh chết mồi, Chiều phân chia mồi đã được. ");
INSERT INTO vie1934_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Các người đó là đầu trưởng của mười hai chi phái Y-sơ-ra-ên; và đó là lời của cha họ nói đang khi chúc phước cho, chúc một lời phước riêng cho mỗi người vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Đoạn, người ra lịnh cho các con trai mà rằng: Cha sẽ về nơi tổ tông, các con hãy chôn cha chung cùng tổ phụ, nơi hang đá tại đồng ruộng Eùp-rôn, người Hê-tít, ");
INSERT INTO vie1934_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","tức là hang đá ở trong đồng Mặc-bê-la, ngang Mam-rê, thuộc về xứ Ca-na-an, mà Aùp-ra-ham đã mua làm mộ địa luôn với đồng ruộng của Eùp-rôn ");
INSERT INTO vie1934_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Aáy nơi đó, người ta đã chôn Aùp-ra-ham và Sa-ra, vợ người; Y-sác và Rê-be-ca, vợ người; mà lại nơi đó cha cũng đã chôn Lê-a nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Cái đồng ruộng cùng hang đá ở tại đó đã mua của dân họ Hếch vậy. ");
INSERT INTO vie1934_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Khi trối mấy lời nầy cho các con mình xong, thì Gia-cốp để chân vào giường lại, rồi tắt hơi, được về cùng tổ tông mình. ");
INSERT INTO vie1934_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Giô-sép bèn cúi đầu xuống mặt cha mình, hôn người và khóc. ");
INSERT INTO vie1934_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Đoạn, Giô-sép biểu mấy thầy thuốc hầu việc mình, dùng thuốc thơm xông cho xác cha; thầy thuốc bèn xông cho Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Bốn mươi ngày xông thuốc hầu qua, vì ấy là hạn ngày dùng xông thuốc; dân Ê-díp-tô khóc người trong bảy mươi ngày. ");
INSERT INTO vie1934_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Khi mãn tang rồi, Giô-sép bèn nói cùng quần thần Pha-ra-ôn rằng: Nếu tôi được ơn trước mặt các ngươi, xin hãy thuật lại lời nầy cho Pha-ra-ôn nghe: ");
INSERT INTO vie1934_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Cha tôi có biểu tôi thề mà rằng: Nầy, cha sẽ chết, con hãy chôn cha nơi mộ địa ta đã mua sẵn rồi trong xứ Ca-na-an. Vậy bây giờ, tôi phải lên đó chôn cha tôi, rồi sẽ trở xuống. ");
INSERT INTO vie1934_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pha-ra-ôn bèn phán rằng: Hãy trở lên chôn cha ngươi, y như lời người đã bắt thề đó. ");
INSERT INTO vie1934_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Giô-sép dời xác cha mình trở lên chôn; quần thần Pha-ra-ôn, các bực trưởng lão trong đền, các bực trưởng lão trong xứ Ê-díp-tô, ");
INSERT INTO vie1934_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","hết thảy nội nhà Giô-sép, các anh em và nội nhà cha mình đều đi lên theo đưa với người; trong Gô-sen chỉ còn những đứa trẻ và chiên, cùng bò của họ mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Lại cũng có đem ngựa và xe theo lên nữa: thật là một đám xác rất đông thay! ");
INSERT INTO vie1934_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Khi đến sân đạp lúa của A-tát, ở bên kia sông Giô-đanh, thì họ làm lễ khóc than rất nên trọng thể tại đó; đoạn, Giô-sép để tang cha trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Dân Ca-na-an, tức là dân xứ ấy, thấy khóc than nơi sân đạp lúa A-tát, thì nói rằng: Aáy là một đám khóc than trọng thể của dân Ê-díp-tô đó! Bởi cớ ấy người ta gọi cái sân nầy tên là A-bên-Mích-ra-im ở bên kia sông Giô-đanh. ");
INSERT INTO vie1934_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Vậy, các con trai Gia-cốp làm theo lời cha trối lại, ");
INSERT INTO vie1934_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","dời xác người về xứ Ca-na-an, chôn trong hang đá của đồng Mặc-bê-la ngang Mam-rê, mà Aùp-ra-ham đã mua luôn với đồng ruộng Eùp-rôn, người Hê-tít, để dùng làm mộ địa. ");
INSERT INTO vie1934_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Chôn cha xong rồi, Giô-sép cùng các anh em và các người đi lên theo đưa xác cha, đều trở xuống xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Các anh Giô-sép thấy cha mình chết rồi, thì nói với nhau rằng: Có lẽ Giô-sép sẽ ganh ghét chúng ta, và trả thù việc ác chúng ta đã làm cho người chăng. ");
INSERT INTO vie1934_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Các anh bèn sai người đến nói cùng Giô-sép rằng: Trước khi qua đời, cha em có trối rằng: ");
INSERT INTO vie1934_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Hãy nói lại cho Giô-sép như vầy: Oâi! xin hãy tha điều ác, tội phạm của các anh con đi, vì chúng nó đã lỗi cùng con đó; nhưng bây giờ cha xin con hãy tha tội kẻ tôi tớ của Đức Chúa Trời cha. Nghe qua mấy lời nầy, Giô-sép bèn khóc. ");
INSERT INTO vie1934_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Chính các anh người đến sấp mình xuống dưới chân mà nói rằng: Các anh đây thật là kẻ tôi tớ của em đó. ");
INSERT INTO vie1934_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Giô-sép đáp rằng: Các anh đừng sợ chi, vì tôi há thay mặt Đức Chúa Trời sao? ");
INSERT INTO vie1934_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Các anh toan hại tôi, nhưng Đức Chúa Trời lại toan làm điều ích cho tôi, hầu cho cứu sự sống cho nhiều người, y như đã xảy đến ngày nay, và giữ gìn sự sống của dân sự đông đảo. ");
INSERT INTO vie1934_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Vậy, đừng sợ, tôi sẽ cấp dưỡng các anh và con cái các anh. Đoạn, Giô-sép an ủi các anh, và lấy lời êm dịu mà nói cùng họ. ");
INSERT INTO vie1934_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Giô-sép cùng nhà cha mình kiều ngụ tại xứ Ê-díp-tô; người hưởng thọ được một trăm mười tuổi. ");
INSERT INTO vie1934_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Người thấy được các con cháu Eùp-ra-im đến đời thứ ba, và cũng có được nâng niu trên gối mình các con của Ma-ki, tức con trai của Ma-na-se, nữa. ");
INSERT INTO vie1934_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kế, Giô-sép nói cùng các anh em rằng: Em sẽ chết, nhưng Đức Chúa Trời sẽ đến viếng các anh em thật; đem các anh em về xứ mà Ngài đã thề hứa cùng Aùp-ra-ham, Y-sác, và Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Giô-sép biểu các con trai của Y-sơ-ra-ên thề mà rằng: Quả thật, Đức Chúa Trời sẽ đến viếng các anh em; xin anh em hãy dời hài cốt tôi khỏi xứ nầy. ");
INSERT INTO vie1934_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Đoạn, Giô-sép qua đời, hưởng thọ được một trăm mười tuổi. Người ta xông thuốc thơm cho xác Giô-sép, và liệm trong một cái quan tài tại xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Đây là tên các con trai của Y-sơ-ra-ên, mỗi người đều dẫn người nhà mình đi với Gia-cốp đến xứ Ê-díp-tô: ");
INSERT INTO vie1934_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ru-bên, Si-mê-ôn, Lê-vi và Giu-đa; ");
INSERT INTO vie1934_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Y-sa-ca, Sa-bu-lôn và Bên-gia-min; ");
INSERT INTO vie1934_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Đan, Nép-ta-li, Gát, và A-se. ");
INSERT INTO vie1934_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Hết thảy những người bởi Gia-cốp sanh ra, được bảy mươi người; Giô-sép đã ở tại xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Vả, Giô-sép và anh em người cùng mọi kẻ đồng đời đó đều chết hết. ");
INSERT INTO vie1934_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Con cháu Y-sơ-ra-ên thêm nhiều lạ lùng, nẩy nở ra, và trở nên rất cường thạnh; cả xứ đều đầy dẫy. ");
INSERT INTO vie1934_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nhưng bấy giờ tại nước Ê-díp-tô, có một vua mới lên ngôi, chẳng quen biết Giô-sép. ");
INSERT INTO vie1934_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Vua phán cùng dân mình rằng: Nầy, dân Y-sơ-ra-ên đông và mạnh hơn chúng ta; ");
INSERT INTO vie1934_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","hè! ta hãy dùng chước khôn ngoan đối cùng họ, kẻo họ thêm nhiều lên, một mai nếu có cơn chinh chiến xảy đến, họ sẽ hiệp cùng quân nghịch đánh lại ta, và ra khỏi xứ chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Vậy, người Ê-díp-tô bèn đặt các kẻ đầu xâu để bắt dân Y-sơ-ra-ên làm xâu khó nhọc; họ xây thành Phi-thom và Ram-se dùng làm kho tàng cho Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Nhưng người Ê-díp-tô càng bắt làm khó nhọc chừng nào, dân Y-sơ-ra-ên càng thêm nhiều lên, và tràn ra chừng nấy. Người Ê-díp-tô bèn đem lòng ghen ghét dân Y-sơ-ra-ên, ");
INSERT INTO vie1934_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","bắt làm công việc nhọc nhằn, ");
INSERT INTO vie1934_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","gây cho đời dân ấy nên cay đắng, vì nỗi khổ sở nhồi đất, làm gạch và mọi việc khác ở ngoài đồng. Các công việc nầy người Ê-díp-tô bắt dân Y-sơ-ra-ên làm nhọc nhằn lắm. ");
INSERT INTO vie1934_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Vua xứ Ê-díp-tô cũng phán cùng các bà mụ của dân Hê-bơ-rơ, một người tên Siếp-ra và một người tên Phu-a, ");
INSERT INTO vie1934_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","mà rằng: Khi các ngươi đi rước thai cho người đàn bà Hê-bơ-rơ, hễ thấy sanh con trai, thì hãy làm cho chết đi; còn con gái, thì hãy để cho sống. ");
INSERT INTO vie1934_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Nhưng các bà mụ kính sợ Đức Chúa Trời, chẳng làm theo lời vua Ê-díp-tô phán dặn, đều để cho các con trai sống hết. ");
INSERT INTO vie1934_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Vua xứ Ê-díp-tô bèn đòi những bà mụ mà phán rằng: Sao các ngươi làm như vậy, để cho những con trai sống? ");
INSERT INTO vie1934_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Các bà mụ tâu rằng: Aáy tại người đàn bà Hê-bơ-rơ chẳng phải như người đàn bà Ê-díp-tô; vì họ mạnh khỏe hơn, đã sanh nở trước khi mụ đến. ");
INSERT INTO vie1934_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Đức Chúa Trời ban ơn cho những bà mụ; dân sự gia thêm và trở nên đông đúc. ");
INSERT INTO vie1934_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Aáy vậy, vì bà mụ có lòng kính sợ Đức Chúa Trời, nên Ngài làm cho nhà họ được thạnh vượng. ");
INSERT INTO vie1934_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pha-ra-ôn bèn truyền lịnh cho cả dân mình rằng: Phàm con trai của dân Hê-bơ-rơ mới sanh, hãy liệng xuống sông; còn con gái, thì để cho sống. ");
INSERT INTO vie1934_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Vả, có một người trong họ Lê-vi đi cưới con gái Lê-vi làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nàng thọ thai, và sanh một con trai; thấy con ngộ, nên đem đi giấu trong ba tháng. ");
INSERT INTO vie1934_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Nhưng giấu lâu hơn nữa không được, nàng bèn lấy một cái rương mây, trét chai và nhựa thông, rồi để đứa trẻ vào, đem thả trong đám sậy dựa mé sông. ");
INSERT INTO vie1934_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Người chị đứa trẻ đứng xa nơi đó đặng cho biết nó sẽ ra sao. ");
INSERT INTO vie1934_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Vả, bấy giờ, con gái Pha-ra-ôn xuống sông tắm, còn các con đòi đi dạo chơi trên mé sông; công chúa thấy cái rương mây đó giữa đám sậy, bèn sai con đòi mình đi vớt lên. ");
INSERT INTO vie1934_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Công chúa mở rương ra, thấy đứa trẻ, là một đứa con trai nhỏ đang khóc, bèn động lòng thương xót mà rằng: Aáy là một đứa con của người Hê-bơ-rơ. ");
INSERT INTO vie1934_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Người chị đứa trẻ bèn nói cùng công chúa rằng: Tôi phải đi kêu một người vú trong bọn đàn bà Hê-bơ-rơ đặng cho đứa trẻ bú chớ? ");
INSERT INTO vie1934_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Công chúa đáp rằng: Hãy đi đi. Người gái trẻ đó kêu mẹ của đứa trẻ. ");
INSERT INTO vie1934_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Công chúa nói rằng: Hãy đem đứa trẻ nầy về nuôi bú cho ta; ta sẽ trả tiền công cho. Người đàn bà ẵm đứa trẻ mà cho bú. ");
INSERT INTO vie1934_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Khi lớn khôn rồi, người bèn dẫn nó vào cho công chúa, nàng nhận làm con, và đặt tên là Môi-se, vì nàng nói rằng: Ta đã vớt nó khỏi nước. ");
INSERT INTO vie1934_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Vả, đang lúc đó, Môi-se đã lớn khôn rồi, ra đi đến cùng anh em mình, xem thấy công việc nhọc nhằn của họ; cũng thấy một người Ê-díp-tô đánh một người Hê-bơ-rơ trong vòng anh em mình; ");
INSERT INTO vie1934_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ngó quanh quất chẳng thấy ai, bèn giết người Ê-díp-tô đem vùi trong cát. ");
INSERT INTO vie1934_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Qua ngày sau, Môi-se đi ra nữa, thấy hai người Hê-bơ-rơ đánh lộn, bèn nói cùng người có lỗi rằng: Sao ngươi đánh người đồng loại mình? ");
INSERT INTO vie1934_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Nhưng người đó đáp rằng: Ai đặt ngươi làm vua, làm quan án cho chúng ta? Có phải muốn giết ta như đã giết người Ê-díp-tô kia chăng? Môi-se sợ, nói rằng: Chắc thật, việc nầy phải lậu rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pha-ra-ôn hay việc đó, thì tìm giết Môi-se; nhưng người trốn đi khỏi mặt Pha-ra-ôn, dừng chân tại xứ Ma-đi-an, và ngồi gần bên một cái giếng. ");
INSERT INTO vie1934_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Vả, thầy tế lễ xứ Ma-đi-an có bảy con gái; các nàng đó đến giếng xách nước đổ đầy máng đặng cho bầy chiên cha mình uống. ");
INSERT INTO vie1934_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Nhưng các kẻ chăn chiên đến đuổi đi; Môi-se bèn đứng dậy, binh vực các nàng đó và cho những bầy chiên uống nước. ");
INSERT INTO vie1934_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Khi mấy nàng trở về nhà Rê-u-ên, cha mình, thì người hỏi rằng: Sao bữa nay các con về sớm vậy? ");
INSERT INTO vie1934_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Thưa rằng: Một người Ê-díp-tô cứu chúng tôi ra khỏi tay bọn chăn chiên, và cũng có xách nước nhiều quá cho bầy chiên uống nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Cha lại hỏi rằng: Người đó bây giờ ở đâu? Sao các con bỏ người đi? Hãy mời đến đặng ăn bánh. ");
INSERT INTO vie1934_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Môi-se ưng ở cùng người nầy, người bèn gả Sê-phô-ra, con gái mình, cho Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nàng sanh một con trai; Môi-se đặt tên là Ghẹt-sôn vì nói rằng: Tôi kiều ngụ nơi ngoại bang. ");
INSERT INTO vie1934_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Sau cách lâu, vua xứ Ê-díp-tô băng; dân Y-sơ-ra-ên than thở kêu van vì phải phục dịch khổ sở; tiếng kêu van lên thấu Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ngài nghe tiếng than thở chúng, nhớ đến sự giao ước mình kết lập cùng Aùp-ra-ham, Y-sác và Gia-cốp. ");
INSERT INTO vie1934_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Đức Chúa Trời đoái lại dân Y-sơ-ra-ên, nhận biết cảnh ngộ của chúng. ");
INSERT INTO vie1934_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Vả, Môi-se chăn bầy chiên cho Giê-trô, ông gia mình, là thầy tế lễ tại xứ Ma-đi-an; dẫn bầy chiên qua phía bên kia đồng vắng, đến núi của Đức Chúa Trời, là núi Hô-rếp. ");
INSERT INTO vie1934_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Thiên sứ của Đức Giê-hô-va hiện ra cùng người trong ngọn lửa, giữa bụi gai kia. Người nhìn thấy cả bụi gai đang cháy, nhưng không hề tàn. ");
INSERT INTO vie1934_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Môi-se bèn nói rằng: Ta hãy tẻ bước lại đặng xem sự lạ lớn nầy, vì cớ sao bụi gai chẳng tàn chút nào. ");
INSERT INTO vie1934_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Đức Giê-hô-va thấy người tẻ bước lại xem, Đức Chúa Trời bèn ở giữa bụi gai gọi rằng: Hỡi Môi-se, hỡi Môi-se! Người thưa rằng: Có tôi đây! ");
INSERT INTO vie1934_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Đức Chúa Trời phán rằng: Chớ lại gần chốn nầy, Hãy cổi giầy ngươi ra, vì chỗ ngươi đang đứng là đất thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Rồi Ngài lại nói: Ta là Đức Chúa Trời của tổ phụ ngươi, Đức Chúa Trời của Aùp-ra-ham, Đức Chúa Trời của Y-sác, và Đức Chúa Trời của Gia-cốp. Môi-se liền che mặt, vì sợ nhìn đến Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Đức Giê-hô-va phán rằng: Ta đã thấy rõ ràng sự cực khổ của dân ta tại xứ Ê-díp-tô, và có nghe thấu tiếng kêu rêu vì cớ người đốc công của nó; phải, ta biết được nỗi đau đớn của nó. ");
INSERT INTO vie1934_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ta ngự xuống đặng cứu dân nầy khỏi tay người Ê-díp-tô, dẫn từ xứ ấy lên đến một xứ kia đẹp đẽ và rộng rãi, đượm sữa và mật, tức là nơi dân Ca-na-an, dân Hê-tít, dân A-mô-rít, dân Phê-rê-sít, dân Hê-vít và dân Giê-bu-sít ở. ");
INSERT INTO vie1934_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nầy, tiếng kêu rêu của dân Y-sơ-ra-ên thấu đến ta, và ta đã thấy dân Ê-díp-tô hà hiếp chúng nó thể nào; ");
INSERT INTO vie1934_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","vậy bây giờ, hãy lại đây, đặng ta sai ngươi đi đến Pha-ra-ôn, để dắt dân ta, là dân Y-sơ-ra-ên, ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Môi-se bèn thưa rằng: Tôi là ai, dám đi đến Pha-ra-ôn, đặng dắt dân Y-sơ-ra-ên ra khỏi xứ Ê-díp-tô? ");
INSERT INTO vie1934_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Đức Chúa Trời phán rằng: Ta sẽ ở cùng ngươi; nầy là điều làm dấu cho ngươi biết rằng ta đã sai ngươi đi: Khi ngươi dắt dân sự ra khỏi xứ Ê-díp-tô rồi, thì các ngươi sẽ phụng sự Đức Chúa Trời tại trên núi nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Môi-se thưa cùng Đức Chúa Trời rằng: Nầy, tôi sẽ đi đến dân Y-sơ-ra-ên, nói cùng họ rằng: Đức Chúa Trời của tổ phụ các ngươi sai ta đến cùng các ngươi; nhưng nếu họ hỏi: Tên Ngài là chi? thì tôi nói với họ làm sao? ");
INSERT INTO vie1934_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Đức Chúa Trời phán rằng: Ta là Đấng Tự Hữu Hằng Hữu; rồi Ngài lại rằng: Hãy nói cho dân Y-sơ-ra-ên như vầy: Đấng Tự Hữu đã sai ta đến cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Đức Chúa Trời lại phán cùng Môi-se rằng: Ngươi sẽ nói cho dân Y-sơ-ra-ên như vầy: Giê-hô-va, Đức Chúa Trời của tổ phụ các ngươi, Đức Chúa Trời của Aùp-ra-ham, Đức Chúa Trời của Y-sác, Đức Chúa Trời của Gia-cốp, sai ta đến cùng các ngươi. Aáy đó là danh đời đời của ta, ấy sẽ là kỷ niệm của ta trải qua các đời. ");
INSERT INTO vie1934_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Hãy đi, hội hiệp các trưởng lão Y-sơ-ra-ên, mà nói cùng họ rằng: Giê-hô-va, Đức Chúa Trời của tổ phụ các ngươi, Đức Chúa Trời của Aùp-ra-ham, Đức Chúa Trời của Y-sác, Đức Chúa Trời của Gia-cốp, đã hiện ra cùng ta mà phán rằng: Thật vậy, ta đã thăm viếng các ngươi, thấy điều họ đãi các ngươi tại xứ Ê-díp-tô, ");
INSERT INTO vie1934_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","nên ta đã phán rằng: Ta sẽ rút các ngươi ra khỏi cảnh khổ tại xứ Ê-díp-tô, đặng đem lên xứ của dân Ca-na-an, dân Hê-tít, dân A-mô-rít, dân Phê-rê-sít, dân Hê-vít, và dân Giê-bu-sít, tức là một xứ đượm sữa và mật. ");
INSERT INTO vie1934_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Dân sự sẽ vâng theo lời ngươi; vậy, ngươi và các trưởng lão Y-sơ-ra-ên hãy đi yết-kiến vua xứ Ê-díp-tô mà tâu rằng: Giê-hô-va, Đức Chúa Trời của dân Hê-bơ-rơ, đã hiện ra cùng chúng tôi. Vậy bây giờ, xin để cho chúng tôi đi đến nơi đồng vắng, cách chừng ba ngày đường đặng dâng của lễ cho Giê-hô-va Đức Chúa Trời chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Vả, ta biết rằng dẫu lấy quyền lực ép buộc vua Ê-díp-tô, thì người cũng chẳng bao giờ cho các ngươi đi! ");
INSERT INTO vie1934_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nhưng ta sẽ giơ tay ra hành xứ Ê-díp-tô bằng các phép lạ ta làm giữa xứ đó, sau rồi họ sẽ cho các ngươi đi. ");
INSERT INTO vie1934_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ta sẽ làm cho dân nầy được ơn trước mắt người Ê-díp-tô; vậy, khi nào các ngươi ra đi, thì sẽ chẳng ra đi tay không; ");
INSERT INTO vie1934_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","nhưng mỗi người đàn bà sẽ hỏi xin người nữ lân cận, cùng kẻ ở tạm nhà mình những đồ bằng vàng, bằng bạc và quần áo, mặc lấy cho con trai con gái mình. Các ngươi sẽ lột trần dân Ê-díp-tô là như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Môi-se thưa rằng: Nhưng dân đó sẽ chẳng tin và chẳng vâng lời tôi, vì sẽ nói rằng: Đức Giê-hô-va chẳng có hiện ra cùng ngươi đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Đức Giê-hô-va phán rằng: Trong tay ngươi cầm vật chi? Thưa rằng: Một cây gậy. ");
INSERT INTO vie1934_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Phán rằng: Hãy ném xuống đất đi. Người bèn ném xuống đất, gậy hóa ra một con rắn; Môi-se chạy trốn nó. ");
INSERT INTO vie1934_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy giơ tay ngươi ra nắm đuôi nó. Người giơ tay ra nắm, thì nó hườn lại cây gậy trong tay. ");
INSERT INTO vie1934_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Đức Giê-hô-va phán rằng: Aáy để cho chúng nó tin rằng Giê-hô-va, Đức Chúa Trời của tổ phụ mình, là Đức Chúa Trời của Aùp-ra-ham, Đức Chúa Trời của Y-sác, Đức Chúa Trời của Gia-cốp, đã hiện ra cùng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Đức Giê-hô-va lại phán rằng: Hãy đặt tay ngươi vào lòng. Người liền đặt vào, rồi lấy ra. Nầy, tay người nổi phung trắng như tuyết. ");
INSERT INTO vie1934_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Đoạn, Ngài phán rằng: Hãy đặt tay ngươi vào lòng lại; người bèn đặt vào, rồi lấy ra. Kìa, tay trở lại như thịt mình. ");
INSERT INTO vie1934_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Lại phán: Nếu khi nào dân đó chẳng tin ngươi và chẳng vâng theo tiếng của dấu thứ nhất, thì sẽ tin theo tiếng của dấu thứ nhì. ");
INSERT INTO vie1934_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Vả lại, nếu dân chẳng tin cả hai dấu nầy, và không vâng theo lời ngươi, thì hãy lấy nước dưới sông mà làm tràn ngập trên mặt đất; nước mà ngươi đã lấy dưới sông lên đó, sẽ thành máu trên mặt đất vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Môi-se thưa cùng Đức Giê-hô-va rằng: Oâi! lạy Chúa, từ hôm qua, hôm kia, hay là từ lúc Chúa phán dạy kẻ tôi tớ Chúa, tôi vẫn chẳng phải một tay nói giỏi, vì miệng và lưỡi tôi hay ngập ngừng. ");
INSERT INTO vie1934_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Đức Giê-hô-va bèn phán rằng: Ai tạo miệng loài người ra? hay là ai đã làm câm, làm điếc, làm sáng, làm mờ? Có phải ta là Đức Giê-hô-va chăng? ");
INSERT INTO vie1934_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Vậy bây giờ, hãy đi; ta sẽ ở cùng miệng ngươi và dạy ngươi những lời phải nói. ");
INSERT INTO vie1934_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Môi-se thưa rằng: Oâi! lạy Chúa, Chúa muốn sai ai đi, thì sai. ");
INSERT INTO vie1934_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Đức Giê-hô-va bèn nổi giận cùng Môi-se mà phán rằng: Có phải A-rôn, người Lê-vi, là anh ngươi chăng? Ta biết người đó có tài nói giỏi, và kìa, người đang đi đến đón ngươi kìa; khi thấy ngươi, chắc sẽ vui mừng trong lòng. ");
INSERT INTO vie1934_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Vậy ngươi hãy nói cùng người, và sắp để những lời trong miệng người. Khi hai ngươi nói, ta sẽ ở cùng miệng ngươi và miệng anh ngươi, dạy các ngươi những điều gì phải làm. ");
INSERT INTO vie1934_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aáy là người đó sẽ nói cùng dân sự thế cho ngươi, dùng làm miệng ngươi, còn ngươi sẽ dường như Đức Chúa Trời cho người vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ngươi hãy cầm lấy gậy nầy nơi tay, để dùng làm các dấu lạ. ");
INSERT INTO vie1934_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Môi-se bèn đi, trở về Giê-trô, ông gia mình, mà thưa rằng: Xin cha hãy cho tôi trở về nơi anh em tôi tại xứ Ê-díp-tô, đặng thăm thử họ còn sống chăng. Giê-trô bèn nói cùng Môi-se rằng: Con hãy đi bình yên. ");
INSERT INTO vie1934_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Vả, Đức Giê-hô-va có phán cùng Môi-se tại Ma-đi-an rằng: Hãy trở về xứ Ê-díp-tô, vì mấy người tìm giết ngươi đã chết hết rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Môi-se bèn đỡ vợ và con mình lên lưng lừa, trở về xứ Ê-díp-tô. Người cũng cầm cây gậy của Đức Chúa Trời theo trong tay. ");
INSERT INTO vie1934_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Đức Giê-hô-va phán cùng Môi-se rằng: Khi trở về xứ Ê-díp-tô, hãy cẩn thận về các dấu lạ của ta đã giao nơi tay ngươi mà làm trước mặt Pha-ra-ôn; nhưng ta sẽ khiến người cứng lòng chẳng cho dân sự đi. ");
INSERT INTO vie1934_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Vậy, ngươi phải tâu cùng Pha-ra-ôn rằng: Đức Giê-hô-va có phán như vầy: Y-sơ-ra-ên là con ta, tức trưởng nam ta, ");
INSERT INTO vie1934_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","nên ta có phán cùng ngươi rằng: Hãy cho con ta đi, để nó phụng sự ta, mà ngươi đã từ chối không cho nó đi. Nầy, ta sẽ giết con trai ngươi, là con trưởng nam của ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Vả, đang khi đi đường, Đức Giê-hô-va hiện ra trước mặt Môi-se nơi nhà quán, và kiếm thế giết người đi. ");
INSERT INTO vie1934_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sê-phô-ra lấy con dao bằng đá, cắt dương bì của con mình, và quăng dưới chân Môi-se, mà nói rằng: Thật, chàng là huyết lang cho tôi! ");
INSERT INTO vie1934_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Đức Giê-hô-va tha chồng; nàng bèn nói rằng: Huyết lang! là vì cớ phép cắt bì. ");
INSERT INTO vie1934_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Đức Giê-hô-va phán cùng A-rôn rằng: Hãy đi đến đồng vắng, đón rước Môi-se. A-rôn bèn đi, gặp Môi-se tại núi của Đức Chúa Trời, và hôn người. ");
INSERT INTO vie1934_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Môi-se thuật lại cho A-rôn mọi lời của Đức Giê-hô-va sai mình truyền, và các dấu lạ mà Ngài đã dạy mình làm. ");
INSERT INTO vie1934_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Vậy, Môi-se đi cùng A-rôn, nhóm lại các trưởng lão dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","A-rôn bèn thuật hết các lời của Đức Giê-hô-va đã phán cùng Môi-se, và làm những dấu lạ trước mặt dân sự. ");
INSERT INTO vie1934_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Chúng bèn tin, hiểu rằng Đức Giê-hô-va đã thăm viếng dân Y-sơ-ra-ên, và thấy điều cực khổ của mình; chúng bèn cúi đầu và thờ lạy. ");
INSERT INTO vie1934_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Kế sau, Môi-se và A-rôn đến tâu cùng Pha-ra-ôn rằng: Giê-hô-va, Đức Chúa Trời của dân Y-sơ-ra-ên có phán như vầy: Hãy cho dân ta đi, đặng nó giữ một lễ cho ta tại đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nhưng Pha-ra-ôn đáp rằng: Giê-hô-va là ai mà trẫm phải vâng lời người, để cho dân Y-sơ-ra-ên đi? Trẫm chẳng biết Giê-hô-va nào hết; cũng chẳng cho dân Y-sơ-ra-ên đi nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Môi-se và A-rôn tâu rằng: Đức Chúa Trời của dân Hê-bơ-rơ đã đến cùng chúng tôi; xin hãy cho phép chúng tôi đi vào nơi đồng vắng, cách chừng ba ngày đường, đặng dâng tế lễ cho Giê-hô-va Đức Chúa Trời chúng tôi, kẻo Ngài khiến bịnh dịch hay việc gươm dao hành chúng tôi chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Vua xứ Ê-díp-tô phán rằng: Hỡi Môi-se và A-rôn, sao các ngươi xui cho dân chúng bỏ công việc như vậy? Hãy đi làm công việc mình đi! ");
INSERT INTO vie1934_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pha-ra-ôn lại phán rằng: Kìa, dân sự trong xứ bây giờ đông đúc quá, hai ngươi làm cho chúng nó phải nghỉ việc ư! ");
INSERT INTO vie1934_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Trong ngày đó, Pha-ra-ôn truyền lịnh cho các đốc dịch và phái viên rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Các ngươi đừng phát rơm cho dân sự làm gạch như lúc trước nữa; chúng nó phải tự đi kiếm góp lấy. ");
INSERT INTO vie1934_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Nhưng các ngươi hãy hạn số gạch y như cũ, chớ trừ bớt chi cả; vì họ biếng nhác, lấy cớ mà đồng kêu lên rằng: Hè! đi dâng tế lễ cho Đức Chúa Trời chúng ta! ");
INSERT INTO vie1934_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Hãy gán công việc nặng cho chúng nó, hầu cho chúng nó mắc công việc, chẳng xiêu về lời giả dối nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Các đốc dịch và phái viên bèn ra, nói cùng dân chúng rằng: Pha-ra-ôn có phán như vầy: Ta chẳng cho các ngươi rơm nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Hãy tự đi kiếm lấy rơm ở đâu thì đi; song chẳng trừ bớt công việc các ngươi chút nào. ");
INSERT INTO vie1934_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Bấy giờ, dân chúng bèn đi rải khắp xứ Ê-díp-tô, đặng góp gốc rạ thế cho rơm. ");
INSERT INTO vie1934_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Các đốc dịch lại hối rằng: Hãy làm cho xong phần việc các ngươi, y cố định, ngày nào cho rồi ngày nấy, cũng như khi có phát rơm. ");
INSERT INTO vie1934_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Những phái viên trong vòng dân Y-sơ-ra-ên mà các đốc dịch của Pha-ra-ôn đã lập lên trên dân đó, bị đánh và quở rằng: Sao hôm qua và ngày nay, các ngươi chẳng làm xong phần định về việc mình làm gạch y như trước? ");
INSERT INTO vie1934_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Các phái viên của dân Y-sơ-ra-ên bèn đến kêu cùng Pha-ra-ôn rằng: Sao bệ hạ đãi kẻ tôi tớ như vậy? ");
INSERT INTO vie1934_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Người ta chẳng phát rơm cho, lại cứ biểu chúng tôi rằng: Hãy làm gạch đi! Nầy tôi tớ của bệ hạ đây bị đòn; lỗi tại dân của bệ hạ. ");
INSERT INTO vie1934_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nhưng vua đáp rằng: Các ngươi là đồ biếng nhác, đồ biếng nhác! Bởi cớ đó nên nói với nhau rằng: Hè! đi tế Đức Giê-hô-va! ");
INSERT INTO vie1934_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Vậy bây giờ, cứ đi làm việc đi, người ta chẳng phát rơm cho đâu, nhưng các ngươi phải nộp gạch cho đủ số. ");
INSERT INTO vie1934_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Vậy, các phái viên của dân Y-sơ-ra-ên lấy làm bối rối, vì người ta có nói cùng mình rằng: Các ngươi chẳng được trừ số gạch đã định cho mình ngày nào rồi ngày nấy. ");
INSERT INTO vie1934_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Khi lui ra khỏi Pha-ra-ôn thì họ gặp Môi-se và A-rôn đợi tại đó, ");
INSERT INTO vie1934_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","bèn nói rằng: Hai ngươi đã làm cho chúng tôi ra mùi hôi hám trước mặt Pha-ra-ôn và quần thần, mà trao thanh gươm vào tay họ đặng giết chúng tôi. Cầu xin Đức Giê-hô-va xem xét và xử đoán hai ngươi! ");
INSERT INTO vie1934_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Môi-se bèn trở về cùng Đức Giê-hô-va mà thưa rằng: Lạy Chúa! sao Chúa đã làm hại cho dân sự nầy? Chúa sai tôi đến mà chi? ");
INSERT INTO vie1934_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Từ khi tôi đi yết kiến Pha-ra-ôn đặng nhân danh Chúa mà nói, thì người lại ngược đãi dân nầy, và Chúa chẳng giải cứu dân của Chúa. ");
INSERT INTO vie1934_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: Bây giờ ngươi hãy xem những điều ta sẽ hành Pha-ra-ôn; vì nhờ tay quyền năng ép buộc vua đó sẽ tha và đuổi dân Y-sơ-ra-ên ra khỏi xứ mình. ");
INSERT INTO vie1934_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Đức Chúa Trời lại phán cùng Môi-se rằng: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ta đã hiện ra cùng Aùp-ra-ham, cùng Y-sác, và cùng Gia-cốp, tỏ mình là Đức Chúa Trời toàn năng; song về danh ta là Giê-hô-va, thì ta chưa hề tỏ cho họ biết. ");
INSERT INTO vie1934_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ta cũng có lập giao ước cùng họ, để ban xứ Ca-na-an cho, là xứ họ đã kiều ngụ như khách ngoại bang. ");
INSERT INTO vie1934_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ta cũng có nghe lời than thở của dân Y-sơ-ra-ên bị người Ê-díp-tô bắt làm tôi mọi, bèn nhớ lại sự giao ước của ta. ");
INSERT INTO vie1934_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Vậy nên, ngươi hãy nói cùng dân Y-sơ-ra-ên rằng: Ta là Đức Giê-hô-va sẽ rút các ngươi khỏi gánh nặng mà người Ê-díp-tô đã gán cho, cùng giải thoát khỏi vòng tôi mọi; ta sẽ giơ thẳng tay ra, dùng sự đoán phạt nặng mà chuộc các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ta sẽ nhận các ngươi làm dân ta, và ta sẽ làm Đức Chúa Trời của các ngươi; các ngươi sẽ biết ta là Giê-hô-va Đức Chúa Trời của các ngươi, đã rút các ngươi khỏi gánh nặng của người Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ta sẽ dắt các ngươi vào xứ ta đã thề ban cho Aùp-ra-ham, cho Y-sác, cho Gia-cốp, mà cho các ngươi xứ đó làm cơ nghiệp: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Môi-se nói lại như vậy cho dân Y-sơ-ra-ên; nhưng vì bị sầu não và việc tôi mọi nặng nề, nên chẳng nghe Môi-se chút nào. ");
INSERT INTO vie1934_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Đức Giê-hô-va bèn phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Hãy đi tâu cùng Pha-ra-ôn, vua xứ Ê-díp-tô, phải cho dân Y-sơ-ra-ên ra khỏi xứ mình. ");
INSERT INTO vie1934_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Nhưng Môi-se thưa cùng Đức Giê-hô-va rằng: Nầy, tôi là một kẻ vụng miệng; dân Y-sơ-ra-ên chẳng có nghe lời tôi, Pha-ra-ôn há sẽ khứng nghe lời tôi sao? ");
INSERT INTO vie1934_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Đức Giê-hô-va lại phán cùng Môi-se và A-rôn, bèn truyền cho hai người phải đi đến dân Y-sơ-ra-ên và Pha-ra-ôn, vua xứ Ê-díp-tô, đặng đem dân đó ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Đây là các trưởng tộc của những họ hàng dân Y-sơ-ra-ên. Các con trai của Ru-bên, tức là trưởng nam Y-sơ-ra-ên, là: Hê-nóc, Pha-lu, Hết-rôn và Cạt-mi. Đó là những họ hàng của Ru-bên. ");
INSERT INTO vie1934_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Các con trai của Si-mê-ôn là: Giê-mu-ên, Gia-min, Ô-hát, Gia-kin, Xô-ha và Sau-lơ là con của vợ xứ Ca-na-an. Đó là họ hàng của Si-mê-ôn. ");
INSERT INTO vie1934_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Đây là tên các con trai của Lê-vi, tùy theo dòng dõi của họ: Ghẹt-sôn, Kê-hát, và Mê-ra-ri. Lê-vi hưởng thọ được một trăm ba mươi bảy tuổi. ");
INSERT INTO vie1934_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Các con trai của Ghẹt-sôn, tùy theo họ hàng mình: Líp-ni và Si-mê-y. ");
INSERT INTO vie1934_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Các con trai của Kê-hát là: Am-ram, Dít-sê-ha, Hếp-rôn, và U-xi-ên. Kê-hát hưởng thọ được một trăm ba mươi ba tuổi. ");
INSERT INTO vie1934_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Các con trai của Mê-ra-ri là: Mách-li, và Mu-si. Đó là các họ hàng của Lê-vi, tùy theo dòng dõi của họ. ");
INSERT INTO vie1934_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Vả, Am-ram lấy Giô-kê-bết, là cô mình, làm vợ; nàng sanh cho người A-rôn và Môi-se. Am-ram hưởng thọ được một trăm ba mươi bảy tuổi. ");
INSERT INTO vie1934_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Các con trai của Dít-sê-ha là: Cô-rê, Nê-phết và Xiếc-ri. ");
INSERT INTO vie1934_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Các con trai của U-xi-ên là: Mi-sa-ên, Eân-sa-phan, và Sít-ri. ");
INSERT INTO vie1934_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","A-rôn cưới Ê-li-sê-ba, con gái của A-mi-na-đáp, em của Na-ha-sôn; nàng sanh cho người Na-đáp, A-bi-hu, Ê-lê-a-sa và Y-tha-ma. ");
INSERT INTO vie1934_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Các con trai của Cô-rê là: Aùt-si, Eân-ca-na và A-bi-a-sáp. Đó là các họ hàng của dân Cô-rê. ");
INSERT INTO vie1934_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ê-lê-a-sa, con trai của A-rôn, cưới con gái của Phu-ti-ên làm vợ; nàng sanh Phi-nê-a cho người. Đó là các trưởng tộc của nhà tổ phụ người Lê-vi, tùy theo họ hàng mình vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aáy, A-rôn và Môi-se nầy, tức là người mà Đức Giê-hô-va đã phán dạy rằng: Hãy tùy theo cơ đội, đem dân Y-sơ-ra-ên ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aáy là hai người tâu cùng Pha-ra-ôn, vua xứ Ê-díp-tô, đặng đem dân Y-sơ-ra-ên ra khỏi xứ đó; ấy là Môi-se và A-rôn nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Vậy, trong ngày Đức Giê-hô-va phán cùng Môi-se tại xứ Ê-díp-tô, ");
INSERT INTO vie1934_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","thì Ngài có truyền rằng: Ta là Đức Giê-hô-va, hãy tâu lại cùng Pha-ra-ôn, vua xứ Ê-díp-tô, hết thảy mọi lời ta sẽ phán cùng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Môi-se bèn thưa rằng: Nầy, tôi là người vụng miệng: Pha-ra-ôn há sẽ nghe tôi sao? ");
INSERT INTO vie1934_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy xem, ta lập ngươi như là Đức Chúa Trời cho Pha-ra-ôn, còn A-rôn, anh ngươi, sẽ làm kẻ tiên tri của ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Hãy nói lại mọi lời ta sẽ truyền dạy ngươi, rồi A-rôn, anh ngươi, sẽ tâu cùng Pha-ra-ôn, đặng người thả dân Y-sơ-ra-ên ra khỏi xứ mình. ");
INSERT INTO vie1934_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ta sẽ làm cho Pha-ra-ôn cứng lòng, và thêm nhiều dấu lạ phép k” của ta trong xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Nhưng Pha-ra-ôn sẽ chẳng nghe các ngươi đâu; ta sẽ tra tay vào đất Ê-díp-tô, dùng những sự đoán-phạt nằng-nề, đặng rút khỏi xứ đó các quân đội ta, là dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Khi nào ta tra tay vào xứ Ê-díp-tô mà rút dân Y-sơ-ra-ên ra khỏi giữa vòng người Ê-díp-tô, thì họ sẽ biết ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Môi-se và A-rôn bèn làm y như lời Đức Giê-hô-va đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Vả, khi hai người tâu cùng Pha-ra-ôn, thì Môi-se tuổi đã được tám mươi, còn A-rôn tám mươi ba. ");
INSERT INTO vie1934_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Khi nào Pha-ra-ôn truyền cho các ngươi: Hãy làm phép lạ đi, thì ngươi sẽ nói cùng A-rôn rằng: Hãy lấy gậy của anh, liệng trước mặt Pha-ra-ôn, gậy sẽ hóa thành một con rắn. ");
INSERT INTO vie1934_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Vậy, Môi-se và A-rôn đến cùng Pha-ra-ôn và làm như lời Đức Giê-hô-va đã phán dặn. A-rôn liệng cây gậy mình trước mặt Pha-ra-ôn và quần thần, gậy liền hóa thành một con rắn. ");
INSERT INTO vie1934_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Còn Pha-ra-ôn bèn đòi các bác sĩ và thầy phù chú, là những thuật-sĩ Ê-díp-tô; phần họ, cũng cậy phép phù chú mình mà làm giống in như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Mỗi người liệng gậy mình, liền hóa thành rắn; nhưng gậy của A-rôn nuốt các gậy của họ. ");
INSERT INTO vie1934_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Thế mà lòng Pha-ra-ôn vẫn cứng cỏi, chẳng nghe Môi-se và A-rôn, y như lời Đức Giê-hô-va đã phán. ");
INSERT INTO vie1934_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Đức Giê-hô-va phán cùng Môi-se rằng: Pha-ra-ôn đã rắn lòng, từ chối không để cho dân sự đi. ");
INSERT INTO vie1934_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sớm mai Pha-ra-ôn sẽ ngự ra bờ sông, ngươi hãy ra mắt người và cầm theo tay cây gậy đã biến ra con rắn đó. ");
INSERT INTO vie1934_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ngươi hãy tâu rằng: Giê-hô-va, là Đức Chúa Trời của dân Hê-bơ-rơ, sai tôi đến gần bệ hạ, đặng tâu rằng: Hãy tha cho dân ta đi, để chúng nó hầu việc ta trong đồng vắng; mà đến bây giờ ngươi không nghe ta chút nào. ");
INSERT INTO vie1934_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Đức Giê-hô-va có phán như vầy: Vì việc nầy, ngươi sẽ biết ta là Đức Giê-hô-va: Nầy ta lấy gậy trong tay ta mà đập nước ở dưới sông, nước sẽ trở nên huyết. ");
INSERT INTO vie1934_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Cá dưới sông sẽ chết, và sông sẽ hôi thúi đi; người Ê-díp-tô uống nước sông lấy làm ghê gớm. ");
INSERT INTO vie1934_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: Hãy truyền cho A-rôn rằng: Cầm lấy cây gậy anh, giơ tay ra trên nước xứ Ê-díp-tô, trên rạch, sông, bàu, và khắp mọi nơi có nước trong xứ, hầu cho nước hóa thành huyết; cả xứ Ê-díp-tô, và trong những bình chứa nước bằng gỗ, bằng đá đều sẽ có huyết hết thảy. ");
INSERT INTO vie1934_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Vậy, Môi-se và A-rôn bèn làm y như lời Đức Giê-hô-va đã dặn mình. Trước mặt Pha-ra-ôn và quần thần, A-rôn giơ gậy lên, đập nước sông, hết thảy nước sông bèn hóa thành huyết. ");
INSERT INTO vie1934_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Cá dưới sông chết, nước sông hôi-thúi, người Ê-díp-tô không thể uống được; vậy, huyết lan khắp cả xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Song các thuật sĩ cậy phù chú mình cũng làm được như vậy, lòng Pha-ra-ôn cứng cỏi, không nghe Môi-se và A-rôn chút nào, y như lời Đức Giê-hô-va đã phán. ");
INSERT INTO vie1934_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pha-ra-ôn xây đi về đền mình, lòng chẳng để về mấy điều đó chút nào. ");
INSERT INTO vie1934_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Vả, vì hết thảy người Ê-díp-tô uống nước sông chẳng được, nên đào xung quanh sông tìm nước mà uống. ");
INSERT INTO vie1934_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Sau khi Đức Giê-hô-va đập sông thì được bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: Hãy đi ra mắt Pha-ra-ôn, và tâu cùng người rằng: Đức Giê-hô-va có phán như vầy: Hãy tha cho dân ta đi, để chúng nó hầu việc ta. ");
INSERT INTO vie1934_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Nếu ngươi không tha cho đi, nầy ta sẽ giáng tai nạn ếch nhái khắp bờ cõi ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Sông sẽ sanh đông đúc ếch nhái, bò lên vào cung điện, phòng ngủ, và trên giường ngươi, vào nhà đầy tớ và dân sự ngươi, trong lò bếp, cùng nơi nhồi bột làm bánh của ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Eách nhái sẽ bò lên mình ngươi, lên mình dân sự và mọi đầy tớ ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Vậy, Đức Giê-hô-va phán cùng Môi-se rằng: Hãy truyền cho A-rôn rằng: Hãy cầm gậy giơ tay ra trên rạch, trên sông và trên bàu, khiến ếch nhái tràn lên xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","A-rôn giơ tay mình trên các sông rạch xứ Ê-díp-tô, ếch nhái bò lên lan khắp xứ. ");
INSERT INTO vie1934_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Các thuật sĩ cũng cậy phù chú mình làm y như vậy, đặng khiến ếch nhái bò lên xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pha-ra-ôn bèn đòi Môi-se và A-rôn mà phán rằng: Hãy cầu nguyện Đức Giê-hô-va, để Ngài khiến ếch nhái cách xa ta và dân sự ta; thì ta sẽ tha dân Hê-bơ-rơ đi tế Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Môi-se bèn tâu cùng Pha-ra-ôn rằng: Xin hãy định chừng nào tôi phải vì bệ hạ, đầy tớ cùng dân sự bệ hạ mà cầu khẩn Đức Giê-hô-va, để trừ ếch nhái lìa khỏi bệ hạ và cung điện, chỉ còn dưới sông mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Vua đáp rằng: Đến ngày mai. Môi-se rằng: Sẽ làm y theo lời, hầu cho bệ hạ biết rằng chẳng có ai giống như Giê-hô-va là Đức Chúa Trời chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Vậy, ếch nhái sẽ lìa xa bệ hạ, cung điện, tôi tớ, cùng dân sự của bệ hạ; chỉ còn lại dưới sông mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Môi-se và A-rôn bèn lui ra khỏi Pha-ra-ôn; Môi-se kêu cầu Đức Giê-hô-va về việc ếch nhái mà Ngài đã khiến đến cho Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Đức Giê-hô-va làm y theo lời Môi-se; ếch nhái trong nhà, trong làng, ngoài đồng đều chết hết. ");
INSERT INTO vie1934_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Người ta dồn ếch nhái lại từ đống, và cả xứ hôi thúi lắm. ");
INSERT INTO vie1934_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Nhưng Pha-ra-ôn thấy được khỏi nạn, bèn rắn lòng, chẳng nghe Môi-se và A-rôn chút nào, y như lời Đức Giê-hô-va đã phán. ");
INSERT INTO vie1934_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy truyền cho A-rôn rằng: Hãy giơ gậy anh ra, đập bụi trên đất: bụi sẽ hóa muỗi khắp cả xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Hai người làm y như vậy. A-rôn cầm gậy giơ tay ra, đập bụi trên đất, bụi liền hóa thành muỗi, bu người và súc vật; hết thảy bụi đều hóa thành muỗi trong xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Các thuật sĩ cũng muốn cậy phù chú mình làm như vậy, để hóa sanh muỗi, nhưng làm chẳng đặng. Vậy, muỗi bu người và súc vật. ");
INSERT INTO vie1934_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Các thuật sĩ bèn tâu cùng Pha-ra-ôn rằng: Aáy là ngón tay của Đức Chúa Trời; nhưng Pha-ra-ôn cứng lòng, chẳng nghe Môi-se và A-rôn chút nào, y như lời Đức Giê-hô-va đã phán. ");
INSERT INTO vie1934_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kế đó, Đức Giê-hô-va phán cùng Môi-se rằng: Nầy Pha-ra-ôn sẽ ngự ra mé sông, ngươi hãy dậy sớm, đi ra mắt người, mà tâu rằng: Đức Giê-hô-va có phán như vầy: Hãy tha cho dân ta đi, để chúng nó hầu việc ta. ");
INSERT INTO vie1934_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Vì nếu ngươi không cho đi, nầy, ta sẽ sai ruồi mòng bu nơi ngươi, quần thần, dân sự và cung điện ngươi; nhà của người Ê-díp-tô đều sẽ bị ruồi mòng bu đầy, và khắp trên đất nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Nhưng ngày đó, ta sẽ phân biệt xứ Gô-sen ra, là nơi dân ta ở, không có ruồi mòng, hầu cho ngươi biết rằng ta, Giê-hô-va, có ở giữa xứ. ");
INSERT INTO vie1934_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ta sẽ phân biệt dân ta cùng dân ngươi. Đến mai, dấu lạ nầy tất sẽ có. ");
INSERT INTO vie1934_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Đức Giê-hô-va bèn làm y như lời. Vậy, trong cung điện Pha-ra-ôn, nhà cửa của quần thần người cùng cả xứ Ê-díp-tô đều có ruồi mòng vô số, đất bị ruồi mòng hủy hoại. ");
INSERT INTO vie1934_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pha-ra-ôn bèn đòi Môi-se và A-rôn mà phán rằng: Hãy đi dâng tế lễ cho Đức Chúa Trời các ngươi trong xứ. ");
INSERT INTO vie1934_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Nhưng Môi-se tâu rằng: Làm như vậy chẳng tiện, vì các của lễ mà chúng tôi sẽ tế Giê-hô-va Đức Chúa Trời chúng tôi, là một điều gớm ghê cho người Ê-díp-tô. Nếu chúng tôi dâng của lễ gớm ghê trước mắt người Ê-díp-tô, họ há chẳng liệng đá chúng tôi sao? ");
INSERT INTO vie1934_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Chúng tôi sẽ đi trong đồng vắng, chừng ba ngày đường, dâng tế lễ cho Giê-hô-va Đức Chúa Trời chúng tôi, y như lời Ngài sẽ chỉ bảo. ");
INSERT INTO vie1934_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pha-ra-ôn bèn phán rằng: Ta sẽ tha các ngươi đi dâng tế lễ cho Giê-hô-va Đức Chúa Trời các ngươi, ở nơi đồng vắng, nhưng đừng đi xa hơn. Hãy cầu nguyện cho ta với! ");
INSERT INTO vie1934_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Môi-se tâu rằng: Nầy, tôi sẽ lui ra khỏi bệ hạ, cầu nguyện Đức Giê-hô-va cho; ngày mai ruồi mòng sẽ lìa xa Pha-ra-ôn, quần thần, và dân sự người. Nhưng xin Pha-ra-ôn chớ cứ gạt chúng tôi mà không tha dân sự đi dâng tế lễ cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Môi-se bèn lui ra khỏi Pha-ra-ôn, và cầu nguyện Đức Giê-hô-va; ");
INSERT INTO vie1934_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ngài làm y như lời Môi-se, ruồi mòng lìa xa Pha-ra-ôn, quần thần, và dân sự người, không còn lại một con nào. ");
INSERT INTO vie1934_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Nhưng lần nầy, Pha-ra-ôn lại cứng lòng nữa, không cho dân sự đi. ");
INSERT INTO vie1934_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy đi ra mắt Pha-ra-ôn mà tâu rằng: Giê-hô-va, là Đức Chúa Trời của dân Hê-bơ-rơ, có phán như vầy: Hãy tha dân ta đi, đặng chúng nó hầu việc ta; ");
INSERT INTO vie1934_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","vì nếu ngươi từ chối không tha đi, còn cầm lại nữa, ");
INSERT INTO vie1934_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nầy tay của Đức Giê-hô-va sẽ tra vào các súc vật của ngươi ngoài đồng, vào ngựa, lừa, lạc đà, bò và chiên: sẽ có dịch lệ rất lớn. ");
INSERT INTO vie1934_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Đức Giê-hô-va sẽ phân biệt súc vật của dân Y-sơ-ra-ên cùng súc vật của người Ê-díp-tô, sẽ chẳng có một con nào của dân Y-sơ-ra-ên bị chết. ");
INSERT INTO vie1934_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Đức Giê-hô-va định k” mà rằng: Đến mai, Đức Giê-hô-va sẽ làm sự đó tại trong xứ. ");
INSERT INTO vie1934_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Vừa đến mai, Đức Giê-hô-va làm sự đó, hết thảy súc vật của người Ê-díp-tô đều chết; nhưng của dân Y-sơ-ra-ên chẳng chết một con nào. ");
INSERT INTO vie1934_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pha-ra-ôn sai người đi xét, thấy chẳng có một con súc vật nào của dân Y-sơ-ra-ên chết hết. Nhưng Pha-ra-ôn rắn lòng, chẳng cho dân sự đi. ");
INSERT INTO vie1934_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Đức Giê-hô-va bèn phán cùng Môi-se và A-rôn rằng: Hãy hốt tro trong lò đầy tay các ngươi, rồi tại trước mặt Pha-ra-ôn, Môi-se sẽ vải tro đó lên trời. ");
INSERT INTO vie1934_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Tro sẽ hóa thành bụi khắp cả xứ Ê-díp-tô, và sanh nhiều ghẻ chốc cương mủ trên mình người và súc vật trong khắp cả xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Vậy, hai người hốt tro trong lò, đứng trước mặt Pha-ra-ôn, rồi Môi-se vải tro lên trời, thì sanh ra ghẻ chốc cương mủ trên mình người ta và súc vật. ");
INSERT INTO vie1934_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Các thuật sĩ đứng trước mặt Môi-se không được, vì cớ ghẻ chốc đã sanh trên mình các thuật sĩ như trên mình của hết thảy người Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Đức Giê-hô-va làm cho Pha-ra-ôn cứng lòng, không nghe Môi-se và A-rôn chút nào, y như lời Đức Giê-hô-va đã phán cùng Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: Ngươi hãy thức dậy sớm, ra mắt Pha-ra-ôn mà tâu rằng: Giê-hô-va, là Đức Chúa Trời của dân Hê-bơ-rơ, có phán như vầy: Hãy tha dân ta đi, để chúng nó hầu việc ta; ");
INSERT INTO vie1934_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","vì lần nầy ta sẽ giáng các tai nạn cho lòng ngươi, quần thần, và dân sự ngươi, hầu cho ngươi biết rằng khắp thế gian chẳng có ai bằng ta. ");
INSERT INTO vie1934_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nếu bây giờ, ta đã giơ tay ra hành hại ngươi bịnh dịch, thì ngươi cùng dân ngươi đều đã bị diệt khỏi đất rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Nhưng vì cớ nầy ta để ngươi còn sống, là cho ngươi thấy quyền năng của ta, hầu cho danh ta đồn khắp cả thiên hạ. ");
INSERT INTO vie1934_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nếu ngươi còn cản trở, không để cho dân ta đi, ");
INSERT INTO vie1934_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","thì mai, tại giờ nầy, ta sẽ làm một đám mưa đá lớn, đến đỗi tại xứ Ê-díp-tô từ khi khai sáng cho đến ngày nay chẳng có đám mưa nào giống như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Thế thì, bây giờ hãy sai đem lục súc và mọi vật thuộc về ngươi ở ngoài đồng vào, cho khỏi hiểm nghèo. Mưa đá sẽ rớt xuống trên mọi người và vật đang ở ngoài đồng không vào nhà, thì sẽ chết hết. ");
INSERT INTO vie1934_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Những kẻ nào trong quần thần Pha-ra-ôn có lòng kính sợ lời Đức Giê-hô-va, lật đật rút đầy tớ và súc vật mình về nhà; ");
INSERT INTO vie1934_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","còn kẻ nào chẳng chú ý về lời Đức Giê-hô-va, thì để đầy tớ và súc vật mình ở ngoài đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy giơ tay ngươi lên trời, làm mưa đá rớt xuống trên cả xứ Ê-díp-tô, trên mình người, súc vật, và khắp rau cỏ ngoài đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Môi-se bèn giơ gậy mình lên trời, Đức Giê-hô-va làm cho sấm động, mưa đá sa, lửa chạy trên mặt đất. Vậy, Đức Giê-hô-va khiến mưa đá sa trên xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Vả, có mưa đá sa xuống và lửa cháy rất mạnh pha lộn với, đến nỗi từ khi xứ Ê-díp-tô lập quốc đến giờ, chẳng có giống như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Thế thì, trong cả xứ Ê-díp-tô, mưa đá làm hại mọi vật ở ngoài đồng, nào người ta, nào súc vật, nào rau-cỏ, và làm gãy cây cối nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Chỉ đất Gô-sen, là nơi dân Y-sơ-ra-ên ở, chẳng có mưa đá mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pha-ra-ôn bèn truyền đòi Môi-se và A-rôn mà phán rằng: Lần nầy trẫm đã phạm tội; Đức Giê-hô-va là công bình; trẫm cùng dân sự trẫm là kẻ phạm tội. ");
INSERT INTO vie1934_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hãy cầu nguyện Đức Giê-hô-va, hầu cho tan sấm sét và mưa đá; rồi trẫm sẽ tha các ngươi đi, không đợi lâu nữa đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Môi-se bèn đáp rằng: Vừa khi tôi ra khỏi thành, tôi sẽ giơ tay lên Đức Giê-hô-va, sấm sét sẽ lặng, mưa đá sẽ tan, hầu cho bệ hạ biết rằng trái đất thuộc về Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Nhưng tôi biết rằng bệ hạ và quần thần chưa kính sợ Giê-hô-va Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Vả, trong lúc đó, lúa mạch trổ bông, cây gai có hoa, nên lúa mạch và gai bị đập nát; ");
INSERT INTO vie1934_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","còn lúa mì và tiểu mạch trổ muộn, nên không bị đập. ");
INSERT INTO vie1934_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Vậy, Môi-se lui khỏi Pha-ra-ôn, đi ra thành, giơ tay lên Đức Giê-hô-va, sấm sét và mưa đá tạnh, mưa bèn ngớt hột trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Khi Pha-ra-ôn thấy mưa, mưa đá và sấm sét đã tạnh rồi, người và quần thần lại rắn lòng, cứ phạm tội nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Vậy Pha-ra-ôn cứng lòng, không tha dân Y-sơ-ra-ên đi, y như lời Đức Giê-hô-va đã cậy Môi-se mà phán. ");
INSERT INTO vie1934_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy đi đến Pha-ra-ôn, vì ta đã làm rắn lòng người và lòng quần thần, để làm cho các dấu lạ của ta tỏ ra giữa họ, ");
INSERT INTO vie1934_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","hầu cho ngươi thuật cùng con và cháu mình những công việc to tát ta đã làm trên dân Ê-díp-tô, các dấu lạ ta đã làm giữa vòng họ, đặng các ngươi biết rằng ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Môi-se và A-rôn bèn đi đến Pha-ra-ôn mà tâu rằng: Giê-hô-va là Đức Chúa Trời dân Hê-bơ-rơ, có phán như vầy: Ngươi không chịu hạ mình trước mặt ta cho đến chừng nào? Hãy tha dân ta đi, để chúng nó hầu việc ta. ");
INSERT INTO vie1934_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nếu từ chối, không cho dân ta đi, nầy, ngày mai ta sẽ sai cào cào đến địa phận ngươi; ");
INSERT INTO vie1934_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","nó sẽ phủ rợp trên mặt đất, người ta chẳng còn thấy đất nữa; nó sẽ cắn xả những vật chi còn lại, tức vật nào trận mưa đá còn chừa lại; nó cũng cắn xả những cây mọc ngoài đồng ruộng các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","vào đầy cung điện ngươi, dinh thất của quần thần ngươi, và nhà cửa của người Ê-díp-tô: ấy là một điều tổ phụ ngươi, đến nỗi thỉ tổ ngươi, cũng chẳng bao giờ thấy từ khi họ đã có trên mặt đất cho đến ngày nay. Đoạn, Môi-se xây mặt lui ra khỏi Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Quần thần Pha-ra-ôn tâu rằng: Đến chừng nào người nầy mới thôi gài bẫy ta? Hãy tha dân ấy đi, để chúng nó hầu việc Giê-hô-va Đức Chúa Trời chúng nó! Bệ hạ há chưa biết rằng nước Ê-díp-tô đã bị nguy vong sao? ");
INSERT INTO vie1934_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Họ bèn truyền đòi Môi-se và A-rôn trở lại cùng Pha-ra-ôn; người nói rằng: Hãy đi hầu việc Giê-hô-va Đức Chúa Trời các ngươi. Hết thảy những ai là người phải đi? ");
INSERT INTO vie1934_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Môi-se tâu rằng: Chúng tôi đi, sẽ đem nam phụ lão ấu và chiên bò theo, vì về phần chúng tôi, ấy là một lễ của Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pha-ra-ôn bèn nói rằng: Cầu xin Đức Giê-hô-va ở cùng các ngươi! Hồ dễ ta cho các ngươi cùng con cái đều đi sao! Không! quả thật không cho đâu, vì các ngươi có mưu ác! ");
INSERT INTO vie1934_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Không được vậy đâu, chỉ các ngươi, là đàn ông, phải đi hầu việc Đức Giê-hô-va, vì là điều các ngươi đã xin. Đoạn, họ bèn đuổi Môi-se và A-rôn khỏi trước mặt Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy giơ tay ngươi ra trên xứ Ê-díp-tô, đặng khiến cào cào tràn lên xứ đó, cắn xả rau cỏ và mọi vật chi trên đất mưa đá còn chừa lại. ");
INSERT INTO vie1934_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Vậy, Môi-se bèn giơ gậy mình ra trên xứ Ê-díp-tô, thì Đức Giê-hô-va dẫn ngọn gió đông thổi trên xứ sòng ngày và đêm đó; qua sáng mai gió đông đã dẫn cào cào đến. ");
INSERT INTO vie1934_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Cào cào tràn lên khắp cả xứ Ê-díp-tô, và sa xuống trong địa hạt xứ ấy nhiều vô số. Trước kia chẳng bao giờ có bằng số đó, sau nầy cũng chẳng hề sẽ có bằng như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Cào cào bao phủ khắp mặt đất của cả xứ, và xứ thành ra tối tăm, cắn xả các rau cỏ ngoài đồng cùng trái cây mà mưa đá còn chừa lại; trong khắp xứ Ê-díp-tô chẳng còn chút xanh tươi chi cho cây cối hay là cho cỏ rau ở ngoài đồng ruộng nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pha-ra-ôn vội đòi Môi-se và A-rôn đến mà phán rằng: Trẫm đã phạm tội cùng Giê-hô-va Đức Chúa Trời các ngươi, và cùng các ngươi nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Nhưng bây giờ, xin xá tội cho trẫm lần nầy; và hãy cầu giùm Giê-hô-va Đức Chúa Trời các ngươi, hầu cho ít nữa Ngài khiến xa trẫm cái vạ chết nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Môi-se bèn lui ra khỏi Pha-ra-ôn, và khẩn nguyện Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Đức Giê-hô-va dẫn ngọn gió tây đến rất mạnh, đem cào cào đi đuổi xuống Biển đỏ; khắp địa hạt Ê-díp-tô chẳng còn một con cào cào nào. ");
INSERT INTO vie1934_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Nhưng Đức Giê-hô-va làm cho Pha-ra-ôn cứng lòng: người chẳng tha dân Y-sơ-ra-ên đi. ");
INSERT INTO vie1934_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy giơ tay ngươi lên trời, hầu cho trên xứ Ê-díp-tô có sự tối tăm dày đến nỗi người ta rờ đụng đến được. ");
INSERT INTO vie1934_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Vậy, Môi-se giơ tay mình lên trời, bèn có sự tối tăm rất dày trong ba ngày tại xứ Ê-díp-tô; ");
INSERT INTO vie1934_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","trong ba ngày đó người ta không thấy nhau được, không ai nhớm khỏi chỗ mình được. Nhưng trong chốn dân Y-sơ-ra-ên ở thì có ánh sáng cho họ. ");
INSERT INTO vie1934_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pha-ra-ôn bèn đòi Môi-se mà phán rằng: Hãy đi hầu việc Đức Giê-hô-va; con trẻ các ngươi đi theo nữa; chỉ bầy chiên và bò ở lại thôi. ");
INSERT INTO vie1934_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Nhưng Môi-se tâu rằng: Chính bệ hạ hãy cấp cho chúng tôi các con sinh và vật chi dùng làm của lễ thiêu để dâng cho Giê-hô-va Đức Chúa Trời chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Các bầy lục súc sẽ theo chúng tôi nữa, không còn để lại một móng chân nào; vì chúng tôi sẽ dùng mấy con thú đó mà hầu việc Giê-hô-va Đức Chúa Trời chúng tôi. Chúng tôi biết vật chi dùng để thờ phượng Đức Giê-hô-va, chỉ khi nào sẽ đến nơi đó. ");
INSERT INTO vie1934_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Nhưng Đức Giê-hô-va làm cho Pha-ra-ôn cứng lòng, nên người không khứng cho dân Y-sơ-ra-ên đi. ");
INSERT INTO vie1934_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pha-ra-ôn nói rằng: Hãy lui ra khỏi ta cho rảnh! Khá giữ mình đừng thấy mặt ta nữa, vì ngày nào ngươi thấy mặt ta thì sẽ chết! ");
INSERT INTO vie1934_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Môi-se bèn nói rằng: Bệ hạ nói phải lắm; tôi chẳng hề thấy mặt bệ hạ nữa đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Vả, Đức Giê-hô-va có phán cùng Môi-se rằng: Ta sẽ giáng cho Pha-ra-ôn và xứ Ê-díp-tô một tai vạ nữa; đoạn, người sẽ tha các ngươi đi khỏi đây. Khi người định tha đi, thì sẽ đuổi các ngươi ra khỏi đây. ");
INSERT INTO vie1934_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Vậy, hãy nói cùng dân sự và dặn rằng mỗi người bất luận nam hay nữ phải xin kẻ lân cận mình những đồ bằng bạc và bằng vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Đức Giê-hô-va làm cho dân sự được ơn trước mặt người Ê-díp-tô; Môi-se cũng là một người rất tôn trọng trong xứ Ê-díp-tô, trước mắt quần thần của Pha-ra-ôn và trước mắt dân ấy. ");
INSERT INTO vie1934_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Môi-se nói: Đức Giê-hô-va có phán như vầy: Chừng giữa đêm ta sẽ ra tuần hành xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Hết thảy con trưởng nam trong xứ Ê-díp-tô sẽ chết, từ thái tử của Pha-ra-ôn ngồi trên ngai mình, cho đến con cả của người đòi ở sau cối, và luôn mọi con đầu lòng của súc vật nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Trong cả xứ Ê-díp-tô sẽ có tiếng kêu la inh ỏi, cho đến đỗi chưa hề có, và cũng sẽ chẳng bao giờ có giống như vậy nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nhưng, trong cả dân Y-sơ-ra-ên dầu đến một con chó cũng sẽ chẳng sủa hoặc người, hoặc vật; hầu cho các ngươi biết rằng Đức Giê-hô-va phân biệt dân Y-sơ-ra-ên cùng người Ê-díp-tô là dường nào. ");
INSERT INTO vie1934_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Nầy, quần thần của bệ hạ sẽ xuống cùng tôi, sấp mình trước mặt tôi mà rằng: Ngươi và cả dân sự theo ngươi hãy đi đi! Đoạn, tôi sẽ đi ra. Môi-se bèn lui ra khỏi Pha-ra-ôn lấy làm giận lắm. ");
INSERT INTO vie1934_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Vả, Đức Giê-hô-va có phán cùng Môi-se rằng: Pha-ra-ôn chẳng khứng nghe ngươi đâu, hầu cho các dấu lạ ta thêm lên trong xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Môi-se và A-rôn bèn làm các dấu lạ trước mặt Pha-ra-ôn; nhưng Đức Giê-hô-va làm cho Pha-ra-ôn cứng lòng, nên người chẳng tha dân Y-sơ-ra-ên đi khỏi xứ mình. ");
INSERT INTO vie1934_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Tại xứ Ê-díp-tô, Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Tháng nầy định làm tháng đầu cho các ngươi, tức là tháng giêng trong quanh năm. ");
INSERT INTO vie1934_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Hãy nói cho toàn hội chúng Y-sơ-ra-ên rằng: Đến ngày mồng mười tháng nầy, mỗi gia trưởng tùy theo nhà mình phải bắt một con chiên con. ");
INSERT INTO vie1934_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nếu nhà ít người quá ăn không hết một chiên con, hãy chung cùng người rất lân cận mình, tùy theo số người; và hãy tính cho mỗi chiên con tùy sức người ăn hết. ");
INSERT INTO vie1934_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Các ngươi hãy bắt hoặc trong bầy chiên, hoặc trong bầy dê, chiên con đực hay là dê con đực, tuổi giáp niên, chẳng tì vít chi, ");
INSERT INTO vie1934_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","đoạn để dành cho đến ngày mười bốn tháng nầy; rồi cả hội chúng Y-sơ-ra-ên sẽ giết nó, vào lối chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Họ sẽ lấy huyết đem bôi trên hai cây cột và mày cửa của nhà nào ăn thịt chiên con đó. ");
INSERT INTO vie1934_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Đêm ấy họ sẽ ăn thịt chiên quay với bánh không men và rau đắng. ");
INSERT INTO vie1934_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Chớ ăn thịt nửa chín nửa sống hay là luộc trong nước, nhưng phải quay trên lửa cả và đầu, giò, với bộ lòng. ");
INSERT INTO vie1934_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Các ngươi chớ để chi còn lại đến sáng mai; nếu còn lại, hãy thiêu đi. ");
INSERT INTO vie1934_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Vậy, ăn thịt đó, phải như vầy: Dây lưng cột, chân mang giày, tay cầm gậy, ăn hối hả; ấy là lễ Vượt-qua của Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Đêm đó ta sẽ đi qua xứ Ê-díp-tô, hành hại mọi con đầu lòng xứ Ê-díp-tô, từ người ta cho đến súc vật; ta sẽ xét đoán các thần của xứ Ê-díp-tô; ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Huyết bôi trên nhà các ngươi ở, sẽ dùng làm dấu hiệu; khi ta hành hại xứ Ê-díp-tô, thấy huyết đó, thì sẽ vượt qua, chẳng có tai nạn hủy diệt các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Các ngươi hãy ghi ngày đó làm kỷ niệm; trải các đời hãy giữ làm một lễ cho Đức Giê-hô-va, tức là một lễ lập ra đời đời. ");
INSERT INTO vie1934_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Trong bảy ngày phải ăn bánh không men: vừa đến ngày thứ nhất, hãy dẹp men khỏi nhà đi; vì hễ ai ăn bánh có men từ ngày thứ nhất cho đến ngày thứ bảy, thì sẽ bị truất ra khỏi Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ngày thứ nhất, sẽ có một sự nhóm hiệp thánh; qua ngày thứ bảy các ngươi cũng sẽ có một sự nhóm hiệp thánh nữa. Trong mấy ngày đó chẳng nên làm công việc chi, chỉ lo sắm đồ ăn cho mỗi người cần ăn mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Vậy, các ngươi hãy giữ lễ bánh không men, vì chính ngày đó ta rút quân đội các ngươi ra khỏi xứ Ê-díp-tô; nên chi, trải các đời phải giữ ngày đó như một lễ lập ra đời đời. ");
INSERT INTO vie1934_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ngày mười bốn tháng giêng, chiều lại, các ngươi sẽ ăn bánh không men cho đến chiều ngày hai mươi mốt tháng đó. ");
INSERT INTO vie1934_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Trong bảy ngày không nên còn thấy men tại nhà các ngươi; vì bất luận người ngoại bang hay là người bổn xứ, hễ ai ăn bánh có men sẽ bị truất khỏi hội chúng Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Chớ nên ăn bánh có men; khắp nơi các ngươi ở đều phải ăn bánh không men. ");
INSERT INTO vie1934_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Vậy, Môi-se nhóm lại các trưởng lão Y-sơ-ra-ên mà nói rằng: Hãy đi bắt một con trong bầy cho mọi nhà các ngươi, và giết nó làm lễ Vượt-qua. ");
INSERT INTO vie1934_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Rồi hãy lấy một chùm kinh giới nhúng vào huyết trong chậu, bôi lên mày và hai cây cột cửa, đoạn, trong các ngươi chớ ai ra khỏi cửa nhà mình cho đến sáng mai. ");
INSERT INTO vie1934_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Đức Giê-hô-va sẽ đi qua đặng hành hại xứ Ê-díp-tô; khi thấy huyết nơi mày và hai cây cột cửa, Ngài sẽ vượt qua, không cho kẻ tiêu diệt vào nhà các ngươi đặng hành hại. ");
INSERT INTO vie1934_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Hãy giữ lễ nầy như một lệ lập ra đời đời cho các ngươi và con cháu các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Khi nào các ngươi vào xứ mà Đức Giê-hô-va sẽ ban cho, như lời Ngài đã phán, thì hãy giữ lễ nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Khi con cháu các ngươi hỏi rằng: Lễ nầy là nghĩa chi? ");
INSERT INTO vie1934_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Hãy đáp rằng: Aáy là của tế lễ Vượt-qua của Đức Giê-hô-va, vì khi Ngài hành hại xứ Ê-díp-tô thì Ngài đi vượt qua các nhà dân Y-sơ-ra-ên, và cứu nhà chúng ta đó. ");
INSERT INTO vie1934_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Dân Y-sơ-ra-ên bèn cúi đầu lạy, rồi đi, làm theo như lời Đức Giê-hô-va đã phán dặn Môi-se và A-rôn. ");
INSERT INTO vie1934_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Vả, khi giữa đêm, Đức Giê-hô-va hành hại mọi con đầu lòng tại xứ Ê-díp-tô, từ thái tử của Pha-ra-ôn ngồi trên ngai mình, cho đến con cả người bị tù, và hết thảy con đầu lòng của súc vật. ");
INSERT INTO vie1934_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Đang lúc ban đêm, Pha-ra-ôn, quần thần cùng hết thảy người Ê-díp-tô đều chờ dậy; có tiếng kêu la inh ỏi trong xứ Ê-díp-tô, vì chẳng một nhà nào là không có người chết. ");
INSERT INTO vie1934_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Trong đêm đó, Pha-ra-ôn bèn đòi Môi-se và A-rôn mà phán rằng: Hai ngươi và dân Y-sơ-ra-ên hãy chờ dậy, ra khỏi giữa vòng dân ta mà đi hầu việc Đức Giê-hô-va, như các ngươi đã nói. ");
INSERT INTO vie1934_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Cũng hãy dẫn bò và chiên đi, như lời các ngươi đã nói, và cầu phước cho ta nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Người Ê-díp-tô thúc giục dân Y-sơ-ra-ên ra khỏi xứ mau mau, vì nói rằng: Chúng ta đều chết hết! ");
INSERT INTO vie1934_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Vậy, dân sự đều đem bột nhồi rồi chưa men đi, và bọc những thùng nhồi bột trong áo tơi vác lên vai mình. ");
INSERT INTO vie1934_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Vả, dân Y-sơ-ra-ên có làm y theo lời Môi-se đã dặn, xin người Ê-díp-tô những đồ bằng bạc và bằng vàng cùng áo xống. ");
INSERT INTO vie1934_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Đức Giê-hô-va làm cho dân sự được ơn trước mắt người Ê-díp-tô, nên họ bằng lòng cho; và dân Y-sơ-ra-ên lột trần người Ê-díp-tô vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Dân Y-sơ-ra-ên đi từ Ram-se đến Su-cốt, số không kể con nít, được chừng sáu mươi vạn người đàn ông đi bộ. ");
INSERT INTO vie1934_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Lại có vô số người ngoại bang đi lên chung luôn với chiên, bò, súc vật rất nhiều. ");
INSERT INTO vie1934_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Chúng bèn hấp bánh không men bằng bột của mình đã đem theo từ xứ Ê-díp-tô; bột không men, vì cớ bị đuổi khỏi xứ Ê-díp-tô không thế chậm trễ, và cũng chẳng sắm kịp lương thực chi được. ");
INSERT INTO vie1934_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Vả, thì kiều ngụ của dân Y-sơ-ra-ên tại xứ Ê-díp-tô được bốn trăm ba mươi năm. ");
INSERT INTO vie1934_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Khi mãn bốn trăm ba mươi năm rồi, thì, cũng trong ngày đó, các quân đội của Đức Giê-hô-va ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Aáy là một đêm người ta phải giữ cho Đức Giê-hô-va, vì Ngài rút dân Y-sơ-ra-ên khỏi xứ Ê-díp-tô. Trải các đời, cả dân Y-sơ-ra-ên phải giữ đêm đó, để tôn trọng Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: Đây là luật lệ về lễ Vượt-qua: Phàm người ngoại bang chẳng được ăn lễ đó. ");
INSERT INTO vie1934_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Còn về phần kẻ tôi mọi, là người bỏ tiền ra mua, ngươi hãy làm phép cắt bì cho, thì họ mới được ăn. ");
INSERT INTO vie1934_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Khách ngoại bang và kẻ làm thuê cũng chẳng được phép ăn lễ đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Lễ đó chỉ ăn nội trong nhà; ngươi đừng đem thịt ra ngoài, và cũng đừng làm gãy một cái xương nào. ");
INSERT INTO vie1934_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Hết thảy hội chúng Y-sơ-ra-ên phải giữ lễ Vượt-qua. ");
INSERT INTO vie1934_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Khi một khách ngoại bang nào kiều ngụ nhà ngươi, muốn giữ lễ Vượt-qua của Đức Giê-hô-va, thì mọi người nam của họ phải chịu phép cắt bì; đoạn, họ mới được đến gần giữ lễ nầy, và được coi như người sanh trong xứ. Nhưng ai không chịu phép cắt bì, thì chẳng được ăn đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Cũng đồng một luật cho người sanh trong xứ cùng khách ngoại bang nào đến kiều ngụ giữa các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Toàn dân Y-sơ-ra-ên đều làm như lời Đức Giê-hô-va đã phán dặn Môi-se và A-rôn. ");
INSERT INTO vie1934_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Cũng trong ngày đó, Đức Giê-hô-va rút dân Y-sơ-ra-ên, tùy theo quân đội, ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Trong vòng dân Y-sơ-ra-ên bất luận người hay vật, hãy vì ta biệt riêng ra thánh mọi con đầu lòng; bởi con đầu lòng thuộc về ta. ");
INSERT INTO vie1934_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Môi-se nói cùng dân sự rằng: Hãy kỷ niệm ngày nầy, vì là ngày Đức Giê-hô-va dùng tay quyền năng rút các ngươi ra khỏi xứ Ê-díp-tô, tức là khỏi nhà nô lệ; nên chớ ai ăn bánh có men. ");
INSERT INTO vie1934_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ngày nay, nhằm tháng lúa trỗ, các ngươi ra đi. ");
INSERT INTO vie1934_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Vậy khi nào Đức Giê-hô-va đưa ngươi vào bờ cõi xứ dân Ca-na-an, dân Hê-tít, dân A-mô-rít, dân Hê-vít, và dân Giê-bu-sít rồi, là một xứ đượm sữa và mật, và là xứ Ngài đã thề cùng tổ phụ sẽ ban cho ngươi, thì đến trong tháng nầy hãy giữ lễ thánh đó. ");
INSERT INTO vie1934_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Trong bảy ngày hãy ăn bánh không men; đến ngày thứ bảy sẽ có lễ kính Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Phải ăn bánh không men trong bảy ngày; khắp cả địa hạt ngươi sẽ không thấy bánh có men, hoặc men tại nơi ngươi nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Trong ngày đó hãy giải nghĩa cho con trai ngươi rằng: Aáy vì việc Đức Giê-hô-va làm cho ta, khi ta ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Điều đó sẽ làm một dấu hiệu nơi tay ngươi, làm một kỷ niệm ghi nơi trán ở giữa cặp mắt ngươi, hầu cho luật pháp của Đức Giê-hô-va ở nơi miệng ngươi, vì Đức Giê-hô-va đã dùng tay quyền năng rút ngươi ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Hằng năm, đến k”, ngươi phải giữ lễ nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Khi Đức Giê-hô-va đã đưa ngươi vào bờ cõi xứ Ca-na-an, như Ngài đã thề cùng ngươi, và tổ phụ ngươi, khi Ngài đã ban xứ đó cho rồi, ");
INSERT INTO vie1934_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","thì hãy đem dâng cho Đức Giê-hô-va những con trưởng nam cùng cả con đầu lòng đực của súc vật ngươi, vì chúng nó đều sẽ thuộc về Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Nhưng mỗi con lừa đầu lòng, ngươi phải bắt chiên con hay là dê con mà chuộc; bằng không, ngươi hãy vặn cổ nó. Ngươi cũng chuộc mọi trưởng nam trong vòng con trai ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Vả, một mai con trai ngươi hỏi rằng: Điều đó có ý nghĩa chi? thì hãy đáp rằng: Aáy vì cớ Đức Giê-hô-va đã dùng tay quyền năng rút chúng ta ra khỏi xứ Ê-díp-tô, tức là nhà nô lệ; ");
INSERT INTO vie1934_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","và khi Pha-ra-ôn cứng lòng không tha chúng ta đi, Ngài bèn giết hết các con đầu lòng trong xứ đó, từ con trưởng nam người ta cho đến con đầu lòng súc vật. Vì cớ đó, ta dâng tế lễ cho Đức Giê-hô-va mọi con đực sanh đầu lòng, và ta chuộc con trưởng nam trong vòng con trai ta. ");
INSERT INTO vie1934_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Aáy sẽ làm một dấu hiệu nơi tay ngươi, và ấn chí nơi trán giữa cặp mắt ngươi, để nhắc cho nhớ rằng Đức Giê-hô-va đã dùng tay quyền năng rút chúng ta ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Vả, khi Pha-ra-ôn tha dân Y-sơ-ra-ên đi, Đức Chúa Trời không dẫn dân ấy đi theo đường về xứ Phi-li-tin, là đường gần hơn hết, vì Ngài nói rằng: E khi dân thấy trận mạc, dời lòng trở về xứ Ê-díp-tô chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Cho nên Đức Chúa Trời dẫn chúng đi vòng theo đường trong đồng vắng, về hướng Biển-dỏ. Dân Y-sơ-ra-ên cầm khí giới ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Môi-se dời hài cốt Giô-sép theo mình, vì Giô-sép có bắt dân Y-sơ-ra-ên thề quyết rằng: Chắc Đức Chúa Trời sẽ viếng các ngươi; hãy dời hài cốt ta theo các ngươi khỏi đây. ");
INSERT INTO vie1934_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Vả, chúng đi khỏi Su-cốt, đóng trại tại Ê-tam, ở cuối đầu đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Đức Giê-hô-va đi trước dân sự, ban ngày ở trong một trụ mây, để dẫn đường đi; ban đêm trong một trụ lửa, để soi sáng cho chúng, hầu cho được đi luôn ngày và đêm. ");
INSERT INTO vie1934_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ban ngày trụ mây chẳng bao giờ cách xa dân sự, trụ lửa ban đêm cũng vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Hãy truyền cho dân Y-sơ-ra-ên trở lại đóng trại tại trước Phi-Ha-hi-rốt, ngang Ba-anh-Sê-phôn, giữa khoảng Mít-đôn và biển. Các ngươi hãy đóng trại đối diện nơi nầy, gần biển. ");
INSERT INTO vie1934_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Chắc Pha-ra-ôn sẽ nói về dân Y-sơ-ra-ên rằng: Dân đó lạc đường bị khốn trong đồng vắng rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ta sẽ làm cho Pha-ra-ôn cứng lòng, người sẽ đuổi theo dân đó; nhưng ta sẽ vì Pha-ra-ôn và cả toán binh người được rạng danh; người Ê-díp-tô sẽ biết ta là Đức Giê-hô-va. Dân Y-sơ-ra-ên bèn làm như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Vả, họ báo cùng vua Ê-díp-tô rằng dân Hê-bơ-rơ đã trốn đi rồi. Lòng Pha-ra-ôn và quần thần đối cùng dân đó bèn thay đổi, nói rằng: Chúng ta đã làm chi vậy, tha dân Y-sơ-ra-ên đi để khỏi phục dịch ta nữa sao? ");
INSERT INTO vie1934_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pha-ra-ôn bèn thắng xe và đem dân mình theo. ");
INSERT INTO vie1934_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Người đem sáu trăm xe thượng hạng và hết thảy xe trong xứ Ê-díp-tô, trên mỗi xe đều có chiến binh cả. ");
INSERT INTO vie1934_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Đức Giê-hô-va làm cho Pha-ra-ôn, vua xứ Ê-díp-tô, cứng lòng, đuổi theo dân Y-sơ-ra-ên; nhưng dân nầy đã ra đi một cách dạn dĩ. ");
INSERT INTO vie1934_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Người Ê-díp-tô và cả ngựa xe, lính kỵ, cùng toán binh của Pha-ra-ôn đều đuổi theo dân Y-sơ-ra-ên, gặp đang đóng đồn nơi bờ biển, gần Phi-ha-hi-rốt, ngang Ba-anh-Sê-phôn. ");
INSERT INTO vie1934_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Vả, khi Pha-ra-ôn đến gần, dân Y-sơ-ra-ên ngước mắt lên, thấy dân Ê-díp-tô đuổi theo, bèn lấy làm hãi hùng, kêu van Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Chúng lại nói cùng Môi-se rằng: Xứ Ê-díp-tô há chẳng có nơi mộ phần, nên nỗi người mới dẫn chúng tôi vào đồng vắng đặng chết sao? Người đưa chúng tôi ra xứ Ê-díp-tô để làm chi? ");
INSERT INTO vie1934_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Chúng tôi há chẳng có nói cùng người tại xứ Ê-díp-tô rằng: Để mặc chúng tôi phục dịch dân Ê-díp-tô, vì thà rằng phục dịch họ còn hơn phải chết nơi đồng vắng? ");
INSERT INTO vie1934_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Môi-se đáp cùng dân sự rằng: Chớ sợ chi, hãy ở đó, rồi ngày nay xem sự giải cứu Đức Giê-hô-va sẽ làm cho các ngươi; vì người Ê-díp-tô mà các ngươi ngó thấy ngày nay, thì chẳng bao giờ ngó thấy nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Đức Giê-hô-va sẽ chiến cự cho, còn các ngươi cứ yên lặng. ");
INSERT INTO vie1934_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Đức Giê-hô-va phán cùng Môi-se rằng: Sao ngươi kêu van ta? Hãy bảo dân Y-sơ-ra-ên cứ đi; ");
INSERT INTO vie1934_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","còn ngươi hãy giơ gậy lên, đưa tay trên mặt biển, phân rẽ nước ra, thì dân Y-sơ-ra-ên sẽ xuống biển đi như trên đất cạn. ");
INSERT INTO vie1934_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Còn ta sẽ làm cho dân Ê-díp-tô cứng lòng theo dân Y-sơ-ra-ên xuống biển, rồi ta sẽ được rạng danh vì Pha-ra-ôn, cả đạo binh, binh xa, và lính kỵ người. ");
INSERT INTO vie1934_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Khi nào ta được rạng danh vì Pha-ra-ôn, binh xa, cùng lính kỵ người, thì người Ê-díp-tô sẽ rõ ràng ta là Đức Giê-hô-va vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Thiên sứ của Đức Chúa Trời đã đi trước trại quân của dân Y-sơ-ra-ên lộn lại đi sau; còn trụ mây vốn đi trước trại quân, lại ở về sau; ");
INSERT INTO vie1934_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","trụ mây đứng về giữa khoảng trại người Ê-díp-tô và trại dân Y-sơ-ra-ên, làm áng mây tối tăm cho đàng nầy, soi sáng ban đêm cho đàng kia; nên trọn cả đêm hai trại chẳng hề xáp gần nhau được. ");
INSERT INTO vie1934_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Vả, Môi-se giơ tay ra trên biển, Đức Giê-hô-va dẫn trận gió đông thổi mạnh đến đùa biển lại trọn cả đêm; Ngài làm cho biển bày ra khô, nước phân rẽ. ");
INSERT INTO vie1934_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Dân Y-sơ-ra-ên xuống biển, đi như trên đất cạn; còn nước làm thành một tấm vách ngăn bên hữu và bên tả. ");
INSERT INTO vie1934_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Người Ê-díp-tô bèn đuổi theo; hết thảy ngựa, binh xa cùng lính kỵ của Pha-ra-ôn đều theo xuống giữa biển. ");
INSERT INTO vie1934_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Vả, đến canh sáng, Đức Giê-hô-va ở trong lòng trụ mây và lửa, nhìn ra thấy trại quân Ê-díp-tô, bèn làm cho họ phải rối loạn. ");
INSERT INTO vie1934_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ngài tháo bánh xe của họ, khiến dẫn dắt cực nhọc. Người Ê-díp-tô bèn nói nhau rằng: Ta hãy trốn khỏi dân Y-sơ-ra-ên đi, vì Đức Giê-hô-va thế dân đó mà chiến cự cùng chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy giơ tay ngươi ra trên biển, nước sẽ trở lấp người Ê-díp-tô, binh xa và lính kỵ của chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Môi-se bèn giơ tay mình ra trên biển, lối sáng mai, nước trở lấp phủ đáy biển lại, người Ê-díp-tô chạy trốn bị nước chận; vậy Đức Giê-hô-va xô họ xuống giữa biển. ");
INSERT INTO vie1934_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Thế thì, nước trở lại bao phủ binh xa, lính kỵ của cả đạo binh Pha-ra-ôn đã theo dân Y-sơ-ra-ên xuống biển, chẳng còn sót lại một ai. ");
INSERT INTO vie1934_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Song dân Y-sơ-ra-ên đi giữa biển như trên đất cạn; nước làm thành vách ngăn bên hữu và bên tả. ");
INSERT INTO vie1934_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Trong ngày đó, Đức Giê-hô-va giải cứu dân Y-sơ-ra-ên thoát khỏi tay người Ê-díp-tô; dân ấy thấy người Ê-díp-tô chết trên bãi biển. ");
INSERT INTO vie1934_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Dân Y-sơ-ra-ên thấy việc lớn lao mà Đức Giê-hô-va đã làm cho người Ê-díp-tô, nên kính sợ Ngài, tin Ngài và Môi-se, là tôi tớ Ngài. ");
INSERT INTO vie1934_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Đoạn, Môi-se và dân Y-sơ-ra-ên hát bài ca nầy cho Đức Giê-hô-va, rằng: Tôi ca tụng Đức Giê-hô-va, vì Ngài rất vinh hiển oai nghiêm. Ngài đã liệng xuống biển ngựa và người cỡi ngựa. ");
INSERT INTO vie1934_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Đức Giê-hô-va là sức mạnh và sự ca tụng của tôi: Ngài đã trở nên Đấng cứu tôi. Ngài là Đức Chúa Trời tôi, tôi ngợi khen Ngài; Đức Chúa Trời của tổ phụ tôi, tôi tôn kính Ngài. ");
INSERT INTO vie1934_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Đức Giê-hô-va là một chiến sĩ; Danh Ngài là Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ngài đã ném xuống biển binh xa Pha-ra-ôn và cả đạo binh của người; Quan tướng kén chọn của người đã bị đắm nơi Biển đỏ, ");
INSERT INTO vie1934_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Những lượn sóng đã vùi lấp họ rồi; Họ chìm đến đáy biển như một hòn đá vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Hỡi Đức Giê-hô-va! Tay hữu Ngài có sức mạnh vinh hiển thay. Hỡi Đức Giê-hô-va! Tay hữu Ngài hủy quân nghịch tan đi. ");
INSERT INTO vie1934_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Bởi sự cả thể của oai nghiêm Ngài, Đánh đổ kẻ dấy nghịch cùng mình. Ngài nổi giận phừng phừng, Đốt họ cháy như rơm ra. ");
INSERT INTO vie1934_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Lỗ mũi Ngài thở hơi ra, nước bèn dồn lại, Lượn sóng đổ dựng như một bờ đê; Vực sâu đọng lại nơi rún biển. ");
INSERT INTO vie1934_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Quân nghịch rằng: Ta đuổi theo, ta sẽ đuổi kịp Ta sẽ chia phân của giặc; Tâm hồn ta sẽ thỏa nguyện nơi họ; Ta rút gươm ra, tay ta hủy diệt họ. ");
INSERT INTO vie1934_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ngài đã thở hơi ra Biển vùi lấp quân nghịch lại; Họ bị chìm như cục chì Nơi đáy nước sâu. ");
INSERT INTO vie1934_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Hỡi Đức Giê-hô-va! trong vòng các thần, ai giống như Ngài? Trong sự thánh khiết, ai được vinh hiển như Ngài. Đáng sợ, đáng khen Hay làm các phép lạ? ");
INSERT INTO vie1934_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ngài đã đưa tay hữu ra, Đất đã nuốt chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ngài lấy lòng thương xót dìu dắt Dân nầy mà Ngài đã chuộc lại; Ngài đã dùng năng lực đưa nó Về nơi ở thánh của Ngài. ");
INSERT INTO vie1934_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Các dân tộc nghe biết việc nầy đều run sợ, Cơn kinh hãi áp-hãm dân xứ Pha-lê-tin. ");
INSERT INTO vie1934_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Các quan trưởng xứ Ê-đôm bèn lấy làm bối rối; Mấy mặt anh hùng nơi Mô-áp đều kinh hồn; Cả dân Ca-na-an đều mất vía ");
INSERT INTO vie1934_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Sự hoảng hốt kinh hãi giáng cho chúng nó; Hỡi Đức Giê-hô-va! vì quyền cao nơi cánh tay Ngài, Chúng nó đều bị câm như đá, Cho đến chừng nào dân Ngài vượt qua; Cho đến khi dân mà Ngài đã chuộc, vượt qua rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Hỡi Đức Giê-hô-va! Ngài đưa dân ấy vào, và lập nơi núi cơ nghiệp Ngài, Tức là chốn Ngài đã sắm sẵn, để làm nơi ở của Ngài, Hỡi Chúa! là đền thánh mà tay Ngài đã lập. ");
INSERT INTO vie1934_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Đức Giê-hô-va sẽ cai trị đời đời kiếp kiếp. ");
INSERT INTO vie1934_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Vì ngựa của Pha-ra-ôn, binh xa, cùng lính kỵ người đã xuống biển; Và Đức Giê-hô-va đã vùi dập nước biển lên trên, Nhưng dân Y-sơ-ra-ên đi giữa biển như đi trên đất cạn. ");
INSERT INTO vie1934_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nữ tiên tri Mi-ri-am, là em gái A-rôn, tay cầm trống cơm, các đàn bà đều đi ra theo người, cầm trống cơm và múa. ");
INSERT INTO vie1934_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mi-ri-am đáp lại rằng: Hãy ca tụng Đức Giê-hô-va, vì Ngài rất vinh hiển oai nghiêm; Ngài đã liệng xuống biển ngựa và người cỡi ngựa. ");
INSERT INTO vie1934_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Đoạn, Môi-se đem dân Y-sơ-ra-ên đi khỏi Biển đỏ, đến nơi đồng vắng Su-rơ; trọn ba ngày đi trong đồng vắng, kiếm chẳng được nước đâu cả. ");
INSERT INTO vie1934_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Kế đến đất Ma-ra, nhưng vì nước tại đó đắng, uống chẳng được, nên chi chỗ nầy gọi là Ma-ra. ");
INSERT INTO vie1934_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Dân sự bèn oán trách Môi-se rằng: Chúng tôi lấy chi uống? ");
INSERT INTO vie1934_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Môi-se kêu van Đức Giê-hô-va; Ngài bèn chỉ cho người một cây gỗ, người lấy liệng xuống nước, nước bèn hóa ra ngọt. Aáy tại đó, Đức Giê-hô-va định luật lệ cùng lập pháp độ cho dân sự, và tại đó Ngài thử họ. ");
INSERT INTO vie1934_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ngài phán rằng: Nếu ngươi chăm chỉ nghe lời Giê-hô-va Đức Chúa Trời ngươi, làm sự ngay thẳng trước mặt Ngài, lắng tai nghe các điều răn và giữ mọi luật lệ Ngài, thì ta chẳng giáng cho ngươi một trong các bịnh nào mà ta đã giáng cho xứ Ê-díp-tô; vì ta là Đức Giê-hô-va, Đấng chữa bịnh cho ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Đoạn, dân sự đến đất Ê-lim; nơi đó có mười hai suối nước, và bảy mươi cây chà là; dân sự đóng trại tại đó, gần bên suối nước. ");
INSERT INTO vie1934_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Nhằm ngày mười lăm tháng hai, sau khi ra khỏi xứ Ê-díp-tô, cả hội chúng Y-sơ-ra-ên ở nơi Ê-lim đi đến đồng vắng Sin, nằm về giữa khoảng Ê-lim và Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Cả hội chúng Y-sơ-ra-ên oán trách Môi-se và A-rôn tại nơi đồng vắng, ");
INSERT INTO vie1934_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","nói cùng hai người rằng: Oâi! thà rằng chúng tôi chịu chết về tay Đức Giê-hô-va tại xứ Ê-díp-tô, khi còn ngồi kề nồi thịt và ăn bánh chán hê! Vì hai người dẫn dắt chúng tôi vào nơi đồng vắng nầy đều bị chết đói. ");
INSERT INTO vie1934_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Nầy, ta sẽ từ trên trời cao làm mưa bánh xuống cho các ngươi. Dân sự sẽ đi ra, mỗi ngày nào thâu bánh đủ cho ngày nấy, đặng ta thử dân coi có đi theo luật lệ của ta hay chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Qua ngày thứ sáu, dân sự sẽ dự bị phần đã góp, và sẽ được phần gấp bằng hai của mình thường thâu hằng ngày. ");
INSERT INTO vie1934_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Môi-se và A-rôn bèn nói cùng dân Y-sơ-ra-ên rằng: Chiều nay các ngươi sẽ nhận biết rằng ấy là Đức Giê-hô-va đã rút các ngươi ra khỏi xứ Ê-díp-tô, ");
INSERT INTO vie1934_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","và sáng mai sẽ thấy sự vinh quang của Đức Giê-hô-va, vì Ngài đã nghe lời các ngươi oán trách Ngài rồi. Vả lại, chúng ta là ai mà các ngươi oán trách chúng ta? ");
INSERT INTO vie1934_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Môi-se nói: Chiều nầy Đức Giê-hô-va sẽ phát thịt cho các ngươi ăn, rồi sáng mai bánh nhiều dư dật, vì Ngài đã nghe lời các ngươi oán trách Ngài rồi. Thế thì, chúng ta là ai? Những lời oán trách chẳng phải đổ về chúng ta đâu, nhưng về Đức Giê-hô-va vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Môi-se nói cùng A-rôn rằng: Hãy nói cho cả hội chúng Y-sơ-ra-ên rằng: Các ngươi hãy đến trước mặt Đức Giê-hô-va, vì Ngài đã nghe lời oán trách của các ngươi rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Vả, khi A-rôn nói cùng cả hội chúng Y-sơ-ra-ên, thì họ xây mặt về phía đồng vắng, thấy sự vinh quang của Ngài hiện ra trong đám mây. ");
INSERT INTO vie1934_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Ta đã nghe lời oán trách của dân Y-sơ-ra-ên. Vậy, ngươi hãy nói cùng chúng nó rằng: Lối chiều các ngươi sẽ ăn thịt; sáng mai sẽ ăn bánh no nê, và sẽ biết ta là Giê-hô-va Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Vậy, chiều lại, có chim cút bay lên phủ trên trại quân; đến sáng mai lại có một lớp sương ở chung quanh trại quân. ");
INSERT INTO vie1934_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Lớp sương đó tan đi, trên mặt đồng vắng thấy có vật chi nhỏ, tròn, như hột sương đóng trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Khi dân Y-sơ-ra-ên thấy, bèn hỏi nhau rằng: Cái chi vậy? Vì chẳng biết vật đó là gì. Môi-se bèn nói cùng dân sự rằng: Aáy là bánh mà Đức Giê-hô-va ban cho các ngươi làm lương thực đó. ");
INSERT INTO vie1934_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Nầy là lời Đức Giê-hô-va đã phán dặn: Hãy tùy sức ăn của mỗi người, và tùy số người trong trại mà góp cho mỗi tên một ô-me. ");
INSERT INTO vie1934_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Dân Y-sơ-ra-ên bèn làm như vậy, kẻ thì lượm nhiều, người thì lượm ít, ");
INSERT INTO vie1934_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","cứ lường từ ô-me; ai lượm nhiều chẳng được trội, ai lượm ít cũng chẳng thiếu; mỗi người lượm vừa đủ sức mình ăn. ");
INSERT INTO vie1934_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Môi-se nói cùng dân sự rằng: Đừng ai để dư lại cho đến sáng mai. ");
INSERT INTO vie1934_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nhưng dân sự chẳng nghe theo lời Môi-se, một vài người để dư lại đến sáng mai; thì sâu hóa ở trong, vật sanh mùi hôi hám. Môi-se bèn nổi giận cùng họ. ");
INSERT INTO vie1934_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Vậy, hằng buổi sớm mai mỗi người lượm vừa đủ sức mình ăn; khi mặt trời nắng nóng thì vật đó tan ra. ");
INSERT INTO vie1934_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Đến ngày thứ sáu, dân sự lượm lương thực gấp hai; mỗi người hai ô-me. Các hội trưởng đến thuật lại cho Môi-se rõ. ");
INSERT INTO vie1934_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Người đáp rằng: Aáy là lời Đức Giê-hô-va đã phán rằng: Mai là ngày nghỉ, tức ngày Sa-bát thánh cho Đức Giê-hô-va, hãy nướng món chi các ngươi muốn nướng, hãy nấu món chi các ngươi muốn nấu; hễ còn dư, hãy để dành đến sáng mai. ");
INSERT INTO vie1934_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Dân sự bèn để dành cho đến sáng mai, y như lời Môi-se đã truyền; vật đó chẳng sanh mùi hôi hám và cũng chẳng hóa sâu chút nào. ");
INSERT INTO vie1934_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Môi-se bèn nói rằng: Bữa nay hãy ăn đồ đó đi, vì là ngày Sa-bát của Đức Giê-hô-va; hôm nay các ngươi chẳng tìm thấy vật đó ở trong đồng đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Các ngươi lượm trong sáu ngày, nhưng qua ngày thứ bảy là ngày Sa-bát, sẽ chẳng có đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ngày thứ bảy, một vài người trong vòng dân sự ra đặng lượm lấy, nhưng tìm chẳng thấy chi hết. ");
INSERT INTO vie1934_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Các ngươi chẳng chịu vâng giữ điều răn và luật pháp ta cho đến chừng nào? ");
INSERT INTO vie1934_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Hãy suy nghĩ rằng Đức Giê-hô-va đã cho các ngươi ngày Sa-bát; vậy nên, đến ngày thứ sáu Ngài lại cho các ngươi lương thực đủ hai ngày. Trong ngày thứ bảy, mỗi người phải ở yên chỗ mình, chớ ai ra khỏi nhà. ");
INSERT INTO vie1934_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Thế thì, ngày thứ bảy dân sự đều nghỉ ngơi. ");
INSERT INTO vie1934_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Nhà Y-sơ-ra-ên đặt tên lương thực nầy là ma-na; nó giống như hột ngò, sắc trắng, mùi như bánh ngọt pha mật ong. ");
INSERT INTO vie1934_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Môi-se nói rằng: Lời Đức Giê-hô-va đã phán dặn như vầy: Hãy đổ đầy một ô-me ma-na, đặng lưu truyền trải các đời, hầu cho thiên hạ thấy thứ bánh ta đã cho các ngươi ăn nơi đồng vắng, khi ta rút các ngươi ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Môi-se lại nói cùng A-rôn rằng: Hãy lấy một cái bình đựng đầy một ô-me ma-na, để trước mặt Đức Giê-hô-va, đặng lưu truyền các đời. ");
INSERT INTO vie1934_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","A-rôn bèn để bình đó trước sự chứng cớ, hầu cho được lưu truyền y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Dân Y-sơ-ra-ên ăn ma-na trải bốn mươi năm, cho đến khi vào bờ cõi xứ Ca-na-an, là xứ có người ta ở. ");
INSERT INTO vie1934_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Vả, ô-me là một phần mười của ê-pha. ");
INSERT INTO vie1934_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Cả hội chúng Y-sơ-ra-ên đi từ đồng vắng Sin, đi từng trạm, tùy theo lịnh Đức Giê-hô-va, đóng trại tại Rê-phi-đim; ở đó chẳng có nước cho dân sự uống. ");
INSERT INTO vie1934_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Dân sự bèn kiếm cớ cãi lộn cùng Môi-se mà rằng: Hãy cho chúng tôi nước uống. Môi-se đáp rằng: Sao các ngươi kiếm cớ cãi lộn cùng ta? Sao ướm thử Đức Giê-hô-va vậy? ");
INSERT INTO vie1934_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Dân sự ở đó không có nước, bị khát, nên oán trách Môi-se mà rằng: Sao người khiến chúng tôi ra xứ Ê-díp-tô, hầu cho chúng tôi, con và các bầy súc vật phải chịu chết khát thế nầy? ");
INSERT INTO vie1934_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Môi-se bèn kêu cầu Đức Giê-hô-va mà rằng: Tôi phải xử thế nào cùng dân nầy? Thiếu điều họ ném đá tôi! ");
INSERT INTO vie1934_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Đức Giê-hô-va đáp cùng Môi-se rằng: Hãy cầm gậy của ngươi đã đập dưới sông, dẫn theo những trưởng lão Y-sơ-ra-ên, rồi đi trước mặt dân sự. ");
INSERT INTO vie1934_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nầy ta sẽ đứng đằng trước ngươi, ở trên hòn đá tại Hô-rếp kia, ngươi hãy đập hòn đá, thì nước từ đó chảy ra, dân sự sẽ uống lấy. Môi-se bèn làm như vậy trước mặt các trưởng lão Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Người đặt tên nơi nầy là Ma-sa và Mê-ri-ba, vì cớ việc cãi lộn mà dân Y-sơ-ra-ên kiếm cớ gây cùng người, và vì họ đã ướm thử Đức Giê-hô-va mà nói rằng: Có Đức Giê-hô-va ở giữa chúng ta hay chăng? ");
INSERT INTO vie1934_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Vả, khi đó, dân A-ma-léc đến khêu chiến cùng Y-sơ-ra-ên tại Rê-phi-đim. ");
INSERT INTO vie1934_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Môi-se bèn nói cùng Giô-suê rằng: Hãy chọn lấy tráng sĩ cho chúng ta, ra chiến đấu cùng dân A-ma-léc; ngày mai ta sẽ đứng nơi đầu nổng, cầm gậy của Đức Chúa Trời trong tay. ");
INSERT INTO vie1934_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Giô-suê bèn làm y như lời Môi-se nói, để cự chiến dân A-ma-léc; còn Môi-se, A-rôn và Hu-rơ lên trên đầu nổng. ");
INSERT INTO vie1934_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Vả, hễ đang khi Môi-se giơ tay lên, thì dân Y-sơ-ra-ên thắng hơn; nhưng khi người xụi tay xuống, dân A-ma-léc lại thắng hơn. ");
INSERT INTO vie1934_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Tay Môi-se mỏi, A-rôn và Hu-rơ bèn lấy đá kê cho người ngồi, rồi ở hai bên đỡ tay người lên; tay người chẳng lay động cho đến khi mặt trời lặn. ");
INSERT INTO vie1934_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Giô-suê lấy lưỡi gươm đánh bại A-ma-léc và dân sự người. ");
INSERT INTO vie1934_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy chép điều nầy trong sách làm kỷ niệm, và hãy nói cho Giô-suê biết rằng ta sẽ bôi sạch kỷ niệm về A-ma-léc trong thiên hạ. ");
INSERT INTO vie1934_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Môi-se lập lên một bàn thờ, đặt tên là “Giê-hô-va cờ xí của tôi”; ");
INSERT INTO vie1934_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","và nói rằng: Bởi vì A-ma-léc có giơ tay lên nghịch cùng ngôi Đức Giê-hô-va, nên Đức Giê-hô-va chinh chiến với A-ma-léc từ đời nầy qua đời kia. ");
INSERT INTO vie1934_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Giê-trô, thầy tế lễ xứ Ma-đi-an, ông gia của Môi-se, hay được mọi điều Đức Chúa Trời đã làm cho Môi-se cùng Y-sơ-ra-ên, là dân sự Ngài, và nghe Ngài đã dẫn dân ấy ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Người bèn dẫn Sê-phô-ra, vợ Môi-se, đã cho trở về nhà cha, ");
INSERT INTO vie1934_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","cùng hai con trai, một tên là Ghẹt-sôn, vì Môi-se đã nói rằng: Tôi kiều ngụ nơi ngoại bang; ");
INSERT INTO vie1934_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","và một tên là Ê-li-ê-se, vì người lại có nói: Đức Chúa Trời của tổ phụ tôi đã vùa giúp và giải cứu tôi khỏi gươm Pha-ra-ôn. ");
INSERT INTO vie1934_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Vậy, Giê-trô, ông gia của Môi-se, đến với hai con trai và vợ Môi-se, thăm người nơi đồng vắng, chỗ đóng trại gần bên núi Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Người bèn sai báo cùng Môi-se rằng: Ta là Giê-trô, ông gia của ngươi, ta cùng vợ ngươi và hai con trai nàng đến thăm ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Môi-se ra đón rước ông gia mình, mọp xuống và hôn người, hỏi thăm nhau, rồi vào trại. ");
INSERT INTO vie1934_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Môi-se liền thuật cho ông gia mình biết mọi điều Đức Giê-hô-va vì Y-sơ-ra-ên đã làm cho Pha-ra-ôn và người Ê-díp-tô, mọi điều khổ nhọc xảy đến cho mình dọc đường và Đức Giê-hô-va đã giải thoát dân Y-sơ-ra-ên thế nào. ");
INSERT INTO vie1934_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Giê-trô lấy làm vui mừng về các ơn mà Đức Giê-hô-va đã làm cho Y-sơ-ra-ên, giải cứu dân ấy khỏi tay người Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Giê-trô nói rằng: Đáng ngợi khen Đức Giê-hô-va thay! là Đấng đã giải cứu các ngươi ra khỏi tay người Ê-díp-tô và tay Pha-ra-ôn, và giải cứu dân sự ra khỏi quyền của người Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Bây giờ ta biết rằng Đức Giê-hô-va là lớn hơn hết các thần, vì khi người Ê-díp-tô cậy lòng kiêu ngạo dấy lên, thì Ngài thắng được chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Giê-trô, ông gia của Môi-se, bèn bày một của lễ thiêu và các lễ vật mà dâng cho Đức Chúa Trời; rồi A-rôn và các trưởng lão Y-sơ-ra-ên đến ăn bánh cùng ông gia của Môi-se, trước mặt Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Qua ngày sau, Môi-se ra ngồi xét đoán dân sự; dân sự đứng chực trước mặt người từ sớm mai đến chiều. ");
INSERT INTO vie1934_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Oâng gia thấy mọi điều người làm cho dân sự, bèn hỏi rằng: Con làm chi cùng dân sự đó? Sao con chỉ ngồi một mình, còn cả dân sự đứng chực trước mặt từ sớm mai cho đến chiều như vậy? ");
INSERT INTO vie1934_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Môi-se bèn thưa rằng: Aáy vì dân sự đến cùng tôi đặng hỏi ý Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Khi nào họ có việc chi, thì đến cùng tôi, tôi xét đoán người nầy cùng người kia, và cho họ biết những mạng lịnh và luật pháp của Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nhưng ông gia lại nói rằng: Điều con làm đó chẳng tiện. ");
INSERT INTO vie1934_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Quả thật, con cùng dân sự ở với con sẽ bị đuối chẳng sai, vì việc đó nặng nề quá sức con, một mình gánh chẳng nổi. ");
INSERT INTO vie1934_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Bây giờ, hãy nghe cha khuyên con một lời, cầu xin Đức Giê-hô-va phù hộ cho. Về phần con, hãy làm kẻ thay mặt cho dân sự trước mặt Đức Chúa Trời, và đem trình mọi việc cho Ngài hay. ");
INSERT INTO vie1934_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Hãy lấy mạng lịnh và luật pháp Ngài mà dạy họ, chỉ cho biết con đường nào phải đi, và điều chi phải làm. ");
INSERT INTO vie1934_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nhưng hãy chọn lấy trong vòng dân sự mấy người tài năng, kính sợ Đức Chúa Trời, chân thật, ghét sự tham lợi, mà lập lên trên dân sự, làm trưởng cai trị hoặc ngàn người, hoặc trăm người, hoặc năm mươi người, hoặc mười người, ");
INSERT INTO vie1934_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","đặng xét đoán dân sự hằng ngày. Nếu có việc can hệ lớn, họ hãy giải lên cho con; còn những việc nhỏ mọn, chính họ hãy xét đoán lấy. Hãy san bớt gánh cho nhẹ; đặng họ chia gánh cùng con. ");
INSERT INTO vie1934_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nếu con làm việc nầy, và Đức Chúa Trời ban lịnh cho con, con chắc sẽ chịu nổi được, và cả dân sự nầy sẽ đến chỗ mình bình yên. ");
INSERT INTO vie1934_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Môi-se vâng lời ông gia mình, làm y như mọi điều người đã dạy. ");
INSERT INTO vie1934_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Vậy, Môi-se bèn chọn trong cả Y-sơ-ra-ên những người tài năng, lập lên trên dân sự, làm trưởng cai trị, hoặc ngàn người, hoặc trăm người, hoặc năm mươi người, hoặc mười người; ");
INSERT INTO vie1934_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","họ xét đoán dân sự hằng ngày. Các việc khó họ giãi lên cho Môi-se; nhưng chính họ xét lấy các việc nhỏ. ");
INSERT INTO vie1934_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Đoạn, Môi-se để cho ông gia mình trở về xứ người. ");
INSERT INTO vie1934_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Tháng thứ ba, sau khi ra khỏi xứ Ê-díp-tô, trong ngày đó dân Y-sơ-ra-ên đến nơi đồng vắng Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Từ Rê-phi-đim ra đi, đến nơi đồng vắng Si-na-i, đóng trại tại đó, đối diện cùng núi. ");
INSERT INTO vie1934_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Môi-se bèn lên đến Đức Chúa Trời, Đức Giê-hô-va ở trên núi gọi người mà phán rằng: Ngươi hãy nói như vầy cho nhà Gia-cốp, và tỏ điều nầy cho dân Y-sơ-ra-ên: ");
INSERT INTO vie1934_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Các ngươi đã thấy điều ta làm cho người Ê-díp-tô, ta chở các ngươi trên cánh chim ưng làm sao, và dẫn các ngươi đến cùng ta thể nào. ");
INSERT INTO vie1934_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Vậy, bây giờ, nếu các ngươi vâng lời ta và giữ sự giao ước ta, thì trong muôn dân, các ngươi sẽ thuộc riêng về ta, vì cả thế gian đều thuộc về ta. ");
INSERT INTO vie1934_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Các ngươi sẽ thành một nước thầy tế lễ, cùng một dân tộc thánh cho ta. Bấy nhiêu lời đó ngươi sẽ nói lại cùng dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Môi-se đến đòi các trưởng lão trong dân sự, thuật cùng họ mọi lời Đức Giê-hô-va đã dặn mình nói lại. ");
INSERT INTO vie1934_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Cả dân sự đồng thinh đáp rằng: Chúng tôi xin làm mọi việc Đức Giê-hô-va đã phán dặn. Môi-se bèn thuật lại lời của dân sự cùng Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ngài phán rằng: Nầy, ta sẽ ở trong đám mây mịt mịt đi đến ngươi; đặng khi nào ta phán cùng ngươi, thì dân sự nghe và tin cậy ngươi luôn luôn. Đoạn, Môi-se đem lời của dân sự thưa lại cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy đi đến cùng dân sự, khiến dân giữ mình thánh sạch ngày nay và ngày mai, cùng phải giặt áo xống mình. ");
INSERT INTO vie1934_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Qua ngày thứ ba, dân khá sẵn sàng, vì ngày đó Đức Giê-hô-va sẽ giáng lâm trước mắt dân sự tại núi Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Vả, ngươi hãy phân định giới hạn cho dân sự ở chung quanh núi, và dặn rằng: Khá giữ mình đừng leo lên núi, hoặc đụng đến chân; hễ kẻ nào đụng đến thì sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Chớ ai tra tay vào mình người đó, nhưng người đó phải bị liệng đá hoặc bắn tên; bất luận vật hay người, cũng chẳng để cho sống đâu. Khi kèn thổi lên, dân sự sẽ đến gần núi. ");
INSERT INTO vie1934_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Môi-se xuống núi đến cùng dân sự, khiến họ giữ mình thánh sạch, và giặt áo xống mình. ");
INSERT INTO vie1934_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Người dặn dân sự rằng: Trong ba ngày hãy sẵn sàng chớ đến gần đàn bà. ");
INSERT INTO vie1934_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Qua sáng ngày thứ ba, có sấm vang chớp nhoáng, một áng mây mịt mịt ở trên núi, và tiếng kèn thổi rất vang động; cả dân sự ở trong trại quân đều run hãi. ");
INSERT INTO vie1934_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Môi-se bèn biểu dân ra khỏi trại quân nghinh tiếp Đức Chúa Trời; dân sự dừng lại tại chân núi. ");
INSERT INTO vie1934_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Vả, bấy giờ, khắp núi Si-na-i đều ra khói, vì Đức Giê-hô-va ở trong lửa giáng lâm nơi đó; khói ra khác nào khói của lò lửa lớn kia, và cả hòn núi đều rung động cách kịch liệt. ");
INSERT INTO vie1934_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Tiếng kèn càng vang động; Môi-se nói, Đức Chúa Trời đáp tiếng lại. ");
INSERT INTO vie1934_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Đức Giê-hô-va giáng-lâm trên chót núi Si-na-i, đòi Môi-se lên, Môi-se bèn lên. ");
INSERT INTO vie1934_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Đức Giê-hô-va phán rằng: Hãy xuống cấm dân sự đừng xông pha đến gần Đức Giê-hô-va mà nhìn, e nhiều người trong bọn phải chết chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Dầu những thầy tế lễ đến gần Đức Giê-hô-va cũng phải giữ mình thánh sạch, kẻo Ngài hại họ chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Môi-se thưa cùng Đức Giê-hô-va rằng: Dân sự chẳng được lên núi Si-na-i đâu, vì Ngài có cấm chúng tôi mà phán rằng: Hãy phân định giới hạn chung quanh núi, và phân biệt nơi đó là đất thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Đức Giê-hô-va phán rằng: Hãy đi xuống, rồi đem A-rôn lên cùng ngươi, song những thầy tế lễ và dân sự chớ xông pha đặng lên đến gần Đức Giê-hô-va, e Ngài hại họ chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Vậy, Môi-se đi xuống, nói lại cho dân sự nghe. ");
INSERT INTO vie1934_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Bấy giờ, Đức Chúa Trời phán mọi lời nầy, rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ta là Giê-hô-va Đức Chúa Trời ngươi, đã rút ngươi ra khỏi xứ Ê-díp-tô, là nhà nô lệ. ");
INSERT INTO vie1934_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Trước mặt ta, ngươi chớ có các thần khác. ");
INSERT INTO vie1934_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ngươi chớ làm tượng chạm cho mình, cũng chớ làm tượng nào giống những vật trên trời cao kia, hoặc nơi đất thấp nầy, hoặc trong nước dưới đất. ");
INSERT INTO vie1934_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ngươi chớ quì lạy trước các hình tượng đó, và cũng đừng hầu việc chúng nó; vì ta là Giê-hô-va Đức Chúa Trời ngươi, tức là Đức Chúa Trời kỵ tà, hễ ai ghét ta, ta sẽ nhân tội tổ phụ phạt lại con cháu đến ba bốn đời, ");
INSERT INTO vie1934_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","và sẽ làm ơn đến ngàn đời cho những kẻ yêu mến ta và giữ các điều răn ta. ");
INSERT INTO vie1934_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ngươi chớ lấy danh Giê-hô-va Đức Chúa Trời ngươi mà làm chơi, vì Đức Giê-hô-va chẳng cầm bằng vô tội kẻ nào lấy danh Ngài mà làm chơi. ");
INSERT INTO vie1934_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Hãy nhớ ngày nghỉ đặng làm nên ngày thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ngươi hãy làm hết công việc mình trong sáu ngày; ");
INSERT INTO vie1934_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","nhưng ngày thứ bảy là ngày nghỉ của Giê-hô-va Đức Chúa Trời ngươi: trong ngày đó, ngươi, con trai, con gái tôi trai tớ gái, súc vật của ngươi, hoặc khách ngoại bang ở trong nhà ngươi, đều chớ làm công việc chi hết; ");
INSERT INTO vie1934_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","vì trong sáu ngày Đức Giê-hô-va đã dựng nên trời, đất, biển, và muôn vật ở trong đó, qua ngày thứ bảy thì Ngài nghỉ: vậy nên Đức Giê-hô-va đã ban phước cho ngày nghỉ và làm nên ngày thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Hãy hiếu kính cha mẹ ngươi, hầu cho ngươi được sống lâu trên đất mà Giê-hô-va Đức Chúa Trời ngươi ban cho. ");
INSERT INTO vie1934_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ngươi chớ giết người. ");
INSERT INTO vie1934_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ngươi chớ phạm tội tà dâm. ");
INSERT INTO vie1934_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ngươi chớ trộm cướp. ");
INSERT INTO vie1934_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ngươi chớ nói chứng dối cho kẻ lân cận mình. ");
INSERT INTO vie1934_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ngươi chớ tham nhà kẻ lân cận ngươi, cũng đừng tham vợ người, hoặc tôi trai tớ gái, bò, lừa, hay là vật chi thuộc về kẻ lân cận ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Vả, cả dân sự nghe sấm vang, tiếng kèn thổi, thấy chớp nhoáng, núi ra khói, thì run rẩy và đứng cách tận xa. ");
INSERT INTO vie1934_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Dân sự bèn nói cùng Môi-se rằng: Chính mình người hãy nói cùng chúng tôi thì chúng tôi sẽ nghe; nhưng cầu xin Đức Chúa Trời chớ phán cùng, e chúng tôi phải chết chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Môi-se đáp rằng: Đừng sợ chi, vì Đức Chúa Trời giáng lâm đặng thử các ngươi, hầu cho sự kính sợ Ngài ở trước mặt các ngươi, cho các ngươi không phạm tội. ");
INSERT INTO vie1934_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Vậy, dân sự đứng cách tận xa, còn Môi-se đến gần đám mây đen kịt có Đức Chúa Trời ngự ở trong. ");
INSERT INTO vie1934_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Đức Giê-hô-va phán cùng Môi-se rằng: Ngươi hãy nói cho dân Y-sơ-ra-ên như vầy: Các ngươi đã thấy ta từ trên trời phán xuống cùng; ");
INSERT INTO vie1934_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","vậy, chớ đúc tượng thần bằng bạc hay bằng vàng mà sánh với ta. ");
INSERT INTO vie1934_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ngươi hãy lập cho ta một bàn thờ bằng đất, trên đó phải dâng của lễ thiêu, cùng của lễ thù ân của ngươi, hoặc chiên hay bò. Phàm nơi nào có ghi nhớ danh ta, ta sẽ đến và ban phước cho ngươi tại đó. ");
INSERT INTO vie1934_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Nếu ngươi lập cho ta một bàn thờ bằng đá, chớ dùng đá chạm, vì nếu ngươi dùng đồ để chạm thì sẽ làm đá đó ra ô uế. ");
INSERT INTO vie1934_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ngươi chớ đi từ bực thang lên bàn thờ ta, hầu cho sự lõa lồ ngươi không tố lộ. ");
INSERT INTO vie1934_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Đây là luật lệ ngươi phải truyền cho dân sự: ");
INSERT INTO vie1934_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Nếu ngươi mua một người đầy tớ Hê-bơ-rơ, nó sẽ hầu việc cho sáu năm; nhưng qua năm thứ bảy nó sẽ được thả ra, không phải thối tiền. ");
INSERT INTO vie1934_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Nếu nó vào ở một mình, thì sẽ ra một mình; nếu có vợ, thì sẽ ra với vợ. ");
INSERT INTO vie1934_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nếu người chủ cưới vợ cho, và nếu vợ sanh được con trai hay gái, thì nó sẽ ra một mình, vợ và con thuộc về chủ. ");
INSERT INTO vie1934_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Nếu kẻ tôi mọi nói rằng: Tôi thương chủ, vợ và con tôi, không muốn ra được tự do, ");
INSERT INTO vie1934_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","thì người chủ sẽ dẫn nó đến trước mặt Đức Chúa Trời, biểu lại gần cửa hay là cột, rồi lấy mũi dùi xỏ tai; nó sẽ hầu việc người chủ đó trọn đời. ");
INSERT INTO vie1934_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Nếu ai bán con gái mình làm con đòi, con gái đó không được ra như các đầy tớ kia. ");
INSERT INTO vie1934_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Nếu chủ trước đã ưng lấy con đòi làm hầu, rồi sau lại chẳng muốn, thì chủ phải biểu chuộc nàng lại, chớ không có phép gạt, rồi đem bán nàng cho kẻ ngoại bang. ");
INSERT INTO vie1934_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Nhưng nếu chủ định để cho con trai mình, thì phải xử với nàng theo phép như con gái mình vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Nếu chủ có lấy người khác, thì đối với người thứ nhất chẳng được phép giảm đồ ăn, đồ mặc, và tình nghĩa vợ chồng chút nào. ");
INSERT INTO vie1934_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Nếu người chủ không làm theo ba điều nầy, nàng được phép ra không, chẳng phải thối tiền lại. ");
INSERT INTO vie1934_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kẻ nào đánh chết một người, sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Nhược bằng kẻ đó chẳng phải mưu giết, nhưng vì Đức Chúa Trời đã phú người bị giết vào tay kẻ đó, thì ta sẽ lập cho ngươi một chỗ đặng kẻ giết người ẩn thân. ");
INSERT INTO vie1934_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Còn nhược bằng kẻ nào dấy lên cùng người lân cận mà lập mưu giết người, thì dẫu rằng nó núp nơi bàn thờ ta, ngươi cũng bắt mà giết đi. ");
INSERT INTO vie1934_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Kẻ nào đánh cha hay mẹ mình, sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Kẻ nào bắt người và bán, hoặc giữ lại trong tay mình, sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Kẻ nào mắng cha hay mẹ mình, sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Khi hai người đánh lộn nhau, người nầy đánh người kia bằng đá hay là đấm cú, không đến đỗi phải chết, nhưng phải nằm liệt giường, ");
INSERT INTO vie1934_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","nếu đứng dậy chống gậy đi ra ngoài được, người đánh đó sẽ được tha tội. Nhưng chỉ phải đền tiền thiệt hại trong mấy ngày nghỉ và nuôi cho đến khi lành mạnh. ");
INSERT INTO vie1934_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Khi người chủ lấy gậy đánh đầy tớ trai hay gái mình và chết liền theo tay, thì chắc phải bị phạt. ");
INSERT INTO vie1934_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Song nếu đầy tớ trai hay gái còn sống một hai ngày, người chủ khỏi tội, vì nó vốn là tài sản của chủ. ");
INSERT INTO vie1934_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Nếu người ta đánh nhau, đụng nhằm một người đàn bà có thai, làm cho phải sảo, nhưng chẳng bị sự hại chi khác, thì kẻ đánh nhằm đó phải bồi thường theo lời chồng người sẽ định, và trả tiền trước mặt quan án. ");
INSERT INTO vie1934_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Còn nếu có sự hại chi, thì ngươi sẽ lấy mạng thường mạng, ");
INSERT INTO vie1934_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","lấy mắt thường mắt, lấy răng thường răng, lấy tay thường tay, lấy chân thường chân, ");
INSERT INTO vie1934_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","lấy phỏng thường phỏng, lấy bầm thường bầm, lấy thương thường thương. ");
INSERT INTO vie1934_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Nếu ai đánh nhằm con mắt đầy tớ trai hay gái mình, làm cho mất đi, thì hãy tha nó ra tự do, vì cớ mất con mắt. ");
INSERT INTO vie1934_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Nếu ai làm rụng một răng của đầy tớ trai hay gái mình, thì hãy tha nó ra tự do, vì cớ mất một răng. ");
INSERT INTO vie1934_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ví có một con bò báng nhằm một người đàn ông hay đàn bà phải chết đi, con bò sẽ bị ném đá chết, người ta không nên ăn thịt nó; còn người chủ bò sẽ được vô tội. ");
INSERT INTO vie1934_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Nhưng ngộ từ trước con bò có tật hay báng và chủ đã bị mắng vốn mà không cầm giữ, nếu bò nầy còn giết một người đàn ông hay đàn bà, thì nó sẽ bị ném đá, và chủ sẽ bị xử tử nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Nhược bằng người ta định giá cho chủ bò chuộc mạng, chủ phải chuộc mạng mình y như giá đã định. ");
INSERT INTO vie1934_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Nếu bò báng nhằm một đứa con trai hay là con gái, người ta cũng sẽ chiếu theo luật nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Con bò báng nhằm một đứa đầy tớ trai hay gái, chủ bò phải trả ba chục siếc lơ bạc cho chủ nó; rồi bò sẽ bị ném đá chết. ");
INSERT INTO vie1934_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Nếu ai mở miệng hầm hay là đào hầm mà chẳng đậy lại, và nếu có bò hay là lừa té xuống đó, ");
INSERT INTO vie1934_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","chủ hầm sẽ bồi thường giá tiền cho chủ của súc vật, nhưng súc vật bị giết đó sẽ về phần mình. ");
INSERT INTO vie1934_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Bằng bò của ai báng nhằm bò của kẻ lân cận mình phải chết đi, hai người hãy bán bò sống đó, chia tiền và chia luôn con bò chết nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Nếu người chủ đã tỏ tường trước rằng bò mình có tật hay báng, mà không lo cầm giữ, chủ phải lấy bò thường bò, nhưng bò chết sẽ về phần người. ");
INSERT INTO vie1934_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ví ai bắt trộm bò hay chiên, rồi giết hoặc bán đi, thì phải thường năm con bò cho một con, và bốn con chiên cho một con. ");
INSERT INTO vie1934_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Nếu kẻ trộm đang cạy cửa mà bị bắt và đánh chết đi, thì kẻ đánh chết chẳng phải tội sát nhân. ");
INSERT INTO vie1934_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Song nếu đánh chết trong khi mặt trời đã mọc rồi, thì bị tội sát nhân. Kẻ trộm phải bồi thường; bằng chẳng có chi, thì sẽ bị bán vì tội trộm cắp mình. ");
INSERT INTO vie1934_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Nếu vật mà kẻ trộm đã lấy, hoặc bò, lừa hay chiên, hãy còn thấy sống trong tay, thì kẻ trộm phải bồi thường gấp hai. ");
INSERT INTO vie1934_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ngộ ai làm hư hại trong ruộng hay là vườn nho, thả súc vật mình vào ăn trong ruộng người khác, thì ai đó phải lấy hoa lợi tốt nhất của ruộng hay là vườn nho mình mà thường bồi. ");
INSERT INTO vie1934_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Nếu lửa nổi đốt bụi gai và cháy lan qua lúa đã bó, mùa màng, hay là đồng ruộng, thì kẻ nổi lửa đó phải bồi thường trọn mọi vật đã bị cháy. ");
INSERT INTO vie1934_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Khi ai giao tiền bạc hay đồ vật cho kẻ lân cận mình giữ, rủi bị trộm cắp tại nhà kẻ lân cận đó, nếu tên trộm đã bị bắt được, thì nó phải thường gấp hai. ");
INSERT INTO vie1934_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Nếu kẻ trộm không bị bắt được, thì chủ nhà cho gởi phải dẫn đến trước mặt Đức Chúa Trời, đặng thề rằng mình chẳng hề đặt tay vào tài vật của kẻ lân cận mình. ");
INSERT INTO vie1934_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Trong mọi việc gian lận nào, hoặc về một con bò, một con lừa, một con chiên, áo xống hay là một vật chi bị mất, mà có người nói rằng: “quả thật là đồ đó”, thì phải đem duyên cớ hai đàng đến trước mặt Đức Chúa Trời; kẻ nào bị Ngài xử phạt phải thường bồi cho kẻ lân cận mình gấp hai. ");
INSERT INTO vie1934_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Nhược bằng người nào giao lừa, bò, chiên, hoặc súc vật nào khác cho kẻ lân cận mình giữ và bị chết, gãy một giò hay là bị đuổi đi, không ai thấy, ");
INSERT INTO vie1934_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","thì hai đàng phải lấy danh Đức Giê-hô-va mà thề, hầu cho biết rằng người giữ súc vật có đặt tay trên tài vật của kẻ lân cận mình chăng. Người chủ con vật phải nhận lời thề, và người kia chẳng bồi thường. ");
INSERT INTO vie1934_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Còn nếu con vật bị bắt trộm, thì người lãnh giữ phải thường bồi cho chủ nó. ");
INSERT INTO vie1934_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Nếu con vật bị thú rừng xé chết, người lãnh giữ phải đem nó ra làm chứng, sẽ không phải bồi thường vật bị xé đó. ");
INSERT INTO vie1934_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Vì ai mượn người lân cận mình một con vật mà nó gãy một giò, hoặc bị chết, không có mặt chủ, thì ai đó phải bồi thường. ");
INSERT INTO vie1934_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Nếu chủ có mặt tại đó, thì không phải bồi thường. Nếu con vật đã cho mướn, thì giá muớn thế cho tiền bồi thường. ");
INSERT INTO vie1934_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Nếu kẻ nào hòa dụ và nằm với một người gái đồng trinh chưa hứa giá, thì kẻ đó phải nộp tiền sính và cưới nàng làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Nhược bằng cha nàng quyết từ chối không gả, thì kẻ đó phải nộp tiền bằng số tiền sính của người gái đồng trinh. ");
INSERT INTO vie1934_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ngươi chớ để các đồng cốt sống. ");
INSERT INTO vie1934_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Kẻ nào nằm cùng một con vật sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kẻ nào tế các thần khác hơn một mình Đức Giê-hô-va sẽ bị diệt. ");
INSERT INTO vie1934_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ngươi chớ nên bạc đãi khách ngoại bang, và cũng chẳng nên hà hiếp họ, vì các ngươi đã làm khách kiều ngụ tại xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Các ngươi chớ ức hiếp một người góa bụa hay là một kẻ mồ côi nào. ");
INSERT INTO vie1934_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Nếu ức hiếp họ, và họ kêu van ta, chắc ta sẽ nghe tiếng kêu của họ; ");
INSERT INTO vie1934_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","cơn nóng giận ta phừng lên, sẽ lấy gươm giết các ngươi, thì vợ các ngươi sẽ trở nên góa bụa, và con các ngươi sẽ mồ côi. ");
INSERT INTO vie1934_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Trong dân ta có kẻ nghèo nàn ở cùng ngươi, nếu ngươi cho người mượn tiền, chớ xử với họ như người cho vay, và cũng chẳng nên bắt họ chịu lời. ");
INSERT INTO vie1934_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Nếu ngươi cầm áo xống của kẻ lân cận mình làm của tin, thì phải trả cho họ trước khi mặt trời lặn; ");
INSERT INTO vie1934_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","vì là đồ chỉ có che thân, là áo xống che đậy da mình; người lấy chi mà ngủ? Nếu người đến kêu van ta, tất ta sẽ nghe lời người, vì ta là Đấng hay thương xót. ");
INSERT INTO vie1934_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ngươi chớ nên nói lộng ngôn cùng Đức Chúa Trời, và cũng đừng rủa sả vua chúa của dân sự ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ngươi chớ trễ nải mà dâng cho ta những hoa quả đầu mùa của ngươi chứa trong vựa và rượu ép chảy nơi bàn ép. Ngươi cũng phải dâng cho ta con trai đầu lòng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Về phần chiên và bò ngươi cũng hãy làm như vậy; trong bảy ngày đầu, con đầu lòng ở cùng mẹ nó, qua ngày thứ tám ngươi hãy dâng nó cho ta. ");
INSERT INTO vie1934_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Các ngươi sẽ làm người thánh của ta, chớ nên ăn thịt chi bị thú rừng xé ở ngoài đồng; hãy liệng cho chó ăn. ");
INSERT INTO vie1934_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ngươi chớ đồn huyễn; chớ hùa cùng kẻ hung ác đặng làm chứng dối. ");
INSERT INTO vie1934_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ngươi chớ hùa đảng đông đặng làm quấy; khi ngươi làm chứng trong việc kiện cáo, chớ nên trở theo bên phe đông mà phạm sự công bình. ");
INSERT INTO vie1934_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ngươi chớ tư vị kẻ nghèo trong việc kiện cáo. ");
INSERT INTO vie1934_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Nhược bằng ngươi gặp bò hay lừa của kẻ thù nghịch mình đi lạc thì buộc phải đem về cho họ. ");
INSERT INTO vie1934_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ngộ ngươi thấy lừa của kẻ ghét mình bị chở nặng phải quỵ, chớ khá bỏ ngơ, phải cứu nó cho được nhẹ. ");
INSERT INTO vie1934_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Trong cơn kiện cáo, ngươi chớ phạm quyền lợi của người nghèo ở giữa vòng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ngươi phải tránh xa các lời giả dối; chớ giết kẻ vô tội và kẻ công bình, vì ta chẳng hề tha kẻ gian ác đâu. ");
INSERT INTO vie1934_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ngươi chớ nhận của hối lộ, vì của hối lộ làm mờ mắt người thượng trí, và làm mất duyên do của kẻ công bình. ");
INSERT INTO vie1934_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ngươi chớ hiếp đáp người ngoại bang, vì các ngươi đã kiều ngụ tại xứ Ê-díp-tô, chính các ngươi hiểu biết lòng khách ngoại bang là thế nào. ");
INSERT INTO vie1934_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Trải sáu năm ngươi hãy gieo trong đất, thâu lấy hoa lợi, ");
INSERT INTO vie1934_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","nhưng qua năm thứ bảy hãy để đất hoang cho nghỉ; hầu cho kẻ nghèo khổ trong dân sự ngươi được nhờ lấy hoa quả đất đó, còn dư lại bao nhiêu, thú vật ngoài đồng ăn lấy. Cũng hãy làm như vậy về vườn nho và cây ô-li-ve. ");
INSERT INTO vie1934_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Luôn trong sáu ngày ngươi hãy làm công việc mình, nhưng qua ngày thứ bảy hãy nghỉ, hầu cho bò và lừa ngươi được nghỉ; cùng con trai của đầy tớ gái và người ngoại bang được dưỡng sức lại. ");
INSERT INTO vie1934_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ngươi khá giữ hết mọi lời ta phán cùng ngươi. Chớ xưng đến danh các thần khác; chớ cho nghe danh đó ở nơi miệng ngươi ra. ");
INSERT INTO vie1934_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Mỗi năm ba k” ngươi sẽ giữ lễ kính ta. ");
INSERT INTO vie1934_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ngươi hãy giữ lễ bánh không men; phải ăn bánh không men trong bảy ngày về mùa tháng lúa trỗ, như lời ta đã phán dặn; vì trong tháng đó ngươi ra khỏi xứ Ê-díp-tô. Lại chẳng ai nên tay không đến trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ngươi hãy giữ lễ mùa màng, tức là mùa hoa quả đầu tiên của công lao ngươi về các giống ngươi đã gieo ngoài đồng; và giữ lễ mùa gặt về lúc cuối năm, khi các ngươi đã hái hoa quả của công lao mình ngoài đồng rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Mỗi năm ba k” các người nam phải đến trước mặt Chúa, tức là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ngươi chớ dâng huyết của con sinh tế ta chung với bánh có pha men; còn mỡ của nó dâng nhằm ngày lễ kính ta, chớ để trọn đêm đến sáng mai. ");
INSERT INTO vie1934_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Những hoa quả đầu mùa của đất, ngươi phải đem đến đền thờ Giê-hô-va Đức Chúa Trời ngươi. Ngươi chớ nên nấu dê con trong sữa mẹ nó. ");
INSERT INTO vie1934_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Đây nầy, ta sai một thiên sứ đi trước mặt ngươi, đặng phù hộ trong lúc đi đường, và đưa ngươi vào nơi ta đã dự bị. ");
INSERT INTO vie1934_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Trước mặt người, ngươi khá giữ mình, phải nghe theo lời, chớ nên phản nghịch; người sẽ chẳng tha tội ngươi đâu, vì danh ta ngự trong mình người. ");
INSERT INTO vie1934_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nhưng nếu ngươi chăm chỉ nghe lời người, cùng làm theo mọi lời ta sẽ phán, ta sẽ thù nghịch cùng kẻ thù nghịch ngươi, và đối địch với kẻ đối địch ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Vì thiên sứ ta sẽ đi trước mặt, đưa ngươi vào xứ của dân A-mô-rít, dân Hê-tít, dân Phê-rê-sít, dân Ca-na-an, dân Hê-vít, và dân Giê-bu-sít, rồi ta sẽ diệt chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ngươi chớ quì lạy và hầu việc các thần chúng nó; chớ bắt chước công việc họ, nhưng phải diệt hết các thần đó và đạp nát các pho tượng họ đi. ");
INSERT INTO vie1934_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ngươi hãy hầu việc Giê-hô-va Đức Chúa Trời ngươi; Ngài sẽ ban ơn cho vật ăn uống của ngươi và tiêu trừ các bịnh hoạn giữa vòng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Trong xứ ngươi sẽ chẳng có đàn bà sảo thai hay là đàn bà son sẻ. Ta sẽ cho ngươi được trường thọ. ");
INSERT INTO vie1934_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ta sẽ sai sự kinh khiếp ta đi trước, hễ ngươi đến dân nào, ta sẽ làm cho dân ấy vỡ chạy lạc đường, và cho kẻ thù nghịch ngươi xây lưng trước mặt ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ta sẽ sai ong lỗ đi trước đánh đuổi dân Hê-vít, dân Ca-na-an, dân Hê-tít khỏi trước mặt ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ta sẽ chẳng đuổi chúng nó đi hết trong một năm đâu, e khi xứ sẽ trở nên đồng vắng, và loài thú rừng sanh sản ra đông, hại ngươi chăng; ");
INSERT INTO vie1934_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","nhưng ta sẽ đuổi chúng nó lần lần khỏi trước mặt ngươi, cho đến chừng nào số ngươi thêm nhiều và có thể cầm đất đó làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ta sẽ phân định bờ cõi ngươi từ Biển đỏ chí biển Phi-li-tin, từ đồng vắng đến sông cái; vì ta sẽ giao phú dân đó vào tay ngươi, và ngươi sẽ đuổi chúng nó khỏi mặt mình. ");
INSERT INTO vie1934_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ngươi đừng kết giao ước cùng chúng nó, hoặc cùng các thần của chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Họ sẽ chẳng ở trong xứ ngươi đâu, e khi chúng nó xui cho ngươi phạm tội cùng ta mà hầu việc các thần họ chăng; điều đó chắc sẽ thành một cái bẫy cho ngươi vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Đức Chúa Trời phán cùng Môi-se rằng: Ngươi và A-rôn, Na-đáp, và A-bi-hu cùng bảy mươi trưởng lão Y-sơ-ra-ên hãy lên cùng Đức Giê-hô-va ở đằng xa mà lạy. ");
INSERT INTO vie1934_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Chỉ một mình Môi-se sẽ đến gần Đức Giê-hô-va mà thôi, còn họ không đến gần, và dân sự cũng không lên cùng người. ");
INSERT INTO vie1934_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Môi-se bèn đến thuật lại cho dân sự mọi lời phán của Đức Giê-hô-va và các luật lệ, thì chúng đồng thinh đáp rằng: Chúng tôi sẽ làm mọi lời Đức Giê-hô-va phán dạy. ");
INSERT INTO vie1934_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Môi-se chép hết mọi lời của Đức Giê-hô-va; rồi dậy sớm, xây một bàn thờ nơi chân núi, dựng mười hai cây trụ chỉ về mười hai chi phái Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Người sai kẻ trai trẻ của dân Y-sơ-ra-ên đi dâng của lễ thiêu và của lễ thù ân cho Đức Giê-hô-va bằng con bò tơ. ");
INSERT INTO vie1934_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Môi-se lấy phân nửa huyết đựng trong các chậu, còn phân nửa thì rưới trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Đoạn, người cầm quyển sách giao ước đọc cho dân sự nghe, thì dân sự nói rằng: Chúng tôi sẽ làm và vâng theo mọi lời Đức Giê-hô-va phán chỉ. ");
INSERT INTO vie1934_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Môi-se bèn lấy huyết rưới trên mình dân sự mà nói rằng: Đây là huyết giao ước của Đức Giê-hô-va đã lập cùng các ngươi y theo mọi lời nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Đoạn, Môi-se và A-rôn, Na-đáp và A-bi-hu cùng bảy mươi trưởng lão dân Y-sơ-ra-ên đều lên núi, ");
INSERT INTO vie1934_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ngó thấy Đức Chúa Trời của Y-sơ-ra-ên, dưới chân Ngài có một vật giống bích ngọc trong ngần, khác nào như sắc trời thanh-quang. ");
INSERT INTO vie1934_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ngài chẳng tra tay vào những người tôn trọng trong vòng dân Y-sơ-ra-ên; nhưng họ ngó thấy Đức Chúa Trời, thì ăn và uống. ");
INSERT INTO vie1934_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy lên núi, đến cùng ta và ở lại đó; ta sẽ ban cho ngươi bảng đá, luật pháp và các điều răn của ta đã chép đặng dạy dân sự. ");
INSERT INTO vie1934_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Môi-se bèn chờ dậy cùng Giô-suê, kẻ hầu mình, rồi Môi-se đi lên núi Đức Chúa Trời. ");
INSERT INTO vie1934_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Người bèn nói cùng các trưởng lão rằng: Hãy đợi chúng tôi tại đây cho đến chừng nào trở về cùng các ngươi. Nầy, A-rôn và Hu-rơ ở lại cùng các ngươi, ai có việc chi hãy hỏi hai người đó. ");
INSERT INTO vie1934_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Vậy, Môi-se lên núi, mây che phủ núi. ");
INSERT INTO vie1934_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Sự vinh quang của Đức Giê-hô-va ở tại núi Si-na-i; trong sáu ngày mây phủ núi, qua ngày thứ bảy Đức Giê-hô-va ngự trong đám mây gọi Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Cảnh trạng của sự vinh quang Đức Giê-hô-va nơi đỉnh núi, trước mặt dân Y-sơ-ra-ên, khác nào như đám lửa hừng. ");
INSERT INTO vie1934_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Môi-se vào giữa đám mây, lên núi, ở tại đó trong bốn mươi ngày và bốn mươi đêm. ");
INSERT INTO vie1934_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Hãy nói cùng dân Y-sơ-ra-ên đặng họ dâng lễ vật cho ta; các ngươi hãy nhận lấy lễ vật của mọi người có lòng thành dâng cho. ");
INSERT INTO vie1934_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Nầy là lễ vật các ngươi sẽ nhận lấy của họ: vàng, bạc, và đồng; ");
INSERT INTO vie1934_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","chỉ tím, đỏ điều, đỏ sặm, vải gai mịn, lông dê, da chiên đực nhuộm đỏ, ");
INSERT INTO vie1934_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","da cá nược, cây si-tim, ");
INSERT INTO vie1934_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","dầu thắp, hương liệu đặng làm dầu xức và hương, ");
INSERT INTO vie1934_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","bích ngọc cùng các thứ ngọc khác để gắn vào ê-phót và bảng đeo ngực. ");
INSERT INTO vie1934_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Họ sẽ làm cho ta một đền thánh và ta sẽ ở giữa họ. ");
INSERT INTO vie1934_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Hãy làm đền đó y như kiểu đền tạm cùng kiểu các đồ dùng mà ta sẽ chỉ cho ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Vậy, chúng hãy đóng một cái hòm bằng cây si-tim; bề dài hai thước rưỡi, bề ngang một thước rưỡi, và bề cao cũng một thước rưỡi, ");
INSERT INTO vie1934_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","lấy vàng ròng bọc trong, bọc ngoài, và chạy đường viền chung quanh hòm bằng vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ngươi cũng hãy đúc bốn khoen bằng vàng để tại bốn góc hòm: hai cái bên hông nầy, hai cái bên hông kia, ");
INSERT INTO vie1934_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","cùng làm hai cây đòn bằng cây si-tim, bọc vàng; ");
INSERT INTO vie1934_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","rồi lòn đòn vào khoen hai bên hông hòm, để dùng đòn khiêng hòm. ");
INSERT INTO vie1934_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Đòn sẽ ở trong khoen luôn, không nên rút ra. ");
INSERT INTO vie1934_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ngươi hãy cất vào trong hòm bảng chứng mà ta sẽ ban cho. ");
INSERT INTO vie1934_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ngươi cũng hãy làm một cái nắp thi ân bằng vàng ròng, bề dài hai thước rưỡi, bề ngang một thước rưỡi. ");
INSERT INTO vie1934_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Lại làm hai tượng chê-ru-bin bằng vàng giát mỏng, để hai đầu nắp thi ân, ");
INSERT INTO vie1934_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ló ra ngoài, một tượng ở đầu nầy và một tượng ở đầu kia. ");
INSERT INTO vie1934_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Hai chê-ru-bin sẽ sè cánh ra, che trên nắp thi ân, đối diện nhau và xây mặt vào nắp thi ân. ");
INSERT INTO vie1934_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ngươi hãy để nắp thi ân trên hòm, rồi để vào trong hòm bảng chứng mà ta sẽ ban cho. ");
INSERT INTO vie1934_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ta sẽ gặp ngươi tại đó, và ở trên nắp thi ân, giữa hai tượng chê-ru-bin, trên hòm bảng chứng, ta sẽ truyền cho ngươi các mạng lịnh về dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ngươi cũng hãy đóng một cái bàn bằng cây si-tim; bề dài hai thước, bề ngang một thước, và bề cao một thước rưỡi, ");
INSERT INTO vie1934_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","bọc bằng vàng ròng, và chạy một đường viền chung quanh; ");
INSERT INTO vie1934_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","rồi lên be cho tứ vi bàn, cao chừng bốn ngón tay và chạy cho be một đường viền vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Lại đúc bốn cái khoen vàng, tra vào bốn góc nơi chân bàn. ");
INSERT INTO vie1934_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Khoen sẽ ở gần be, để xỏ đòn khiêng bàn. ");
INSERT INTO vie1934_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ngươi hãy chuốt đòn bằng cây si-tim, bọc vàng, rồi người ta sẽ dùng khiêng bàn đó. ");
INSERT INTO vie1934_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Lại hãy lấy vàng ròng mà làm dĩa, chén, chậu, và ly đặng dùng làm lễ quán. ");
INSERT INTO vie1934_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Trên bàn ngươi sẽ để bánh trần thiết cho có luôn luôn trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ngươi cũng hãy làm chân đèn bằng vàng ròng. Cái chân, cái thân, cái đài, cái bầu cùng cái hoa của đèn đều làm bằng vàng đánh giát. ");
INSERT INTO vie1934_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Hai bên thân đèn sẽ có sáu nhánh nứt ra, ba nhánh ở bên nầy và ba nhánh ở bên kia. ");
INSERT INTO vie1934_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Trong sáu nhánh nứt ra trên chân đèn, mỗi nhánh đều sẽ có ba cái đài hình như hột hạnh nhân cùng bầu và hoa. ");
INSERT INTO vie1934_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Trên thân chân đèn, lại cũng sẽ có bốn cái đài hình hột hạnh nhân, bầu và hoa. ");
INSERT INTO vie1934_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Trong sáu nhánh từ thân chân đèn nứt ra, hễ cứ mỗi hai nhánh thì dưới có một cái bầu. ");
INSERT INTO vie1934_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Bầu cùng nhánh của chân đèn đều bằng vàng ròng nguyên miếng đánh giát. ");
INSERT INTO vie1934_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ngươi cũng hãy làm bảy cái thếp đèn, đặng hễ khi thắp thì chiếu trước chân đèn. ");
INSERT INTO vie1934_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kéo bắt tim cùng đồ đựng tàn đèn cũng sẽ bằng vàng ròng. ");
INSERT INTO vie1934_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Người ta sẽ dùng một ta lâng vàng ròng làm chân đèn nầy và các đồ phụ tùng của chân đèn. ");
INSERT INTO vie1934_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Vậy, ngươi hãy xem, cứ làm y như kiểu đã chỉ cho trên núi. ");
INSERT INTO vie1934_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ngươi hãy dùng mười bức màn mà làm đền tạm, màn dệt bằng vải gai mịn, chỉ tím, đỏ điều và đỏ sặm, có thêu các hình chê-ru-bin cực xảo. ");
INSERT INTO vie1934_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Mỗi bức màn bề dài hai mươi tám thước, bề rộng bốn thước. Các bức đều đồng cỡ với nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mỗi năm bức màn sẽ kết dính lại nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ngươi hãy thắt vòng chỉ tím nơi triêng của bức màn thứ nhất ở đầu bức nguyên; và cũng làm như vậy cho đầu chót của bức màn cuối trong bức nguyên thứ nhì. ");
INSERT INTO vie1934_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Lại làm năm chục cái vòng cho bức màn thứ nhất, và năm chục cái vòng nơi đầu triêng bức nguyên thứ nhì; các vòng hai bên sẽ đối nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Cũng hãy làm năm mươi cái móc bằng vàng, rồi móc bức nguyên nầy qua bức nguyên kia, hầu cho đền tạm kết lại thành một. ");
INSERT INTO vie1934_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ngươi cũng hãy kết mười một bức màn bằng lông dê, để dùng làm bong che trên đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Bề dài mỗi bức màn ba chục thước, bề rộng bốn thước, mười một bức đồng một cỡ với nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ngươi hãy kết năm bức màn nầy riêng ra, và sáu bức màn kia riêng ra; nhưng hãy gấp đôi bức màn thứ sáu ở trước đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Lại thắt năm chục cái vòng nơi triêng màn thứ nhất, ném về cuối của bức nguyên thứ nhất, và năm chục cái vòng nơi triêng màn của bức nguyên thứ nhì; ");
INSERT INTO vie1934_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","cũng làm năm chục cái móc bằng đồng, móc vào vòng, rồi hiệp cái bong lại, để nó thành ra một. ");
INSERT INTO vie1934_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Nhưng còn dư, tức là phân nửa của bức màn dư trong bức bong nguyên, thì sẽ xủ xuống phía sau đền tạm; ");
INSERT INTO vie1934_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","phần bề dài dư trong các bức màn của bong, bên nầy một thước, bên kia một thước, thì sẽ xủ xuống hai bên hông đền tạm đặng che vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ngươi hãy làm một tấm lá phủ bằng da chiên đực nhuộm đỏ để trên bong, và kết một tấm lá phủ bằng da cá nược đắp lên trên nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ngươi cũng hãy làm những ván cho vách đền tạm bằng cây si-tim. ");
INSERT INTO vie1934_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Mỗi tấm trướng mười thước, hoành một thước rưỡi, ");
INSERT INTO vie1934_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","có hai cái mộng liền nhau; hết thảy các tấm ván vách đền tạm ngươi cũng sẽ làm như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Về phía nam đền tạm, ngươi hãy làm hai mươi tấm ván; ");
INSERT INTO vie1934_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","dưới hai mươi tấm ván hãy đặt bốn mươi lỗ mộng bằng bạc; cứ hai lỗ mộng ở dưới, để chịu hai cái mộng của mỗi tấm ván. ");
INSERT INTO vie1934_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Lại hãy làm hai mươi tấm ván về phía bắc đền tạm, ");
INSERT INTO vie1934_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","và bốn mươi lỗ mộng bằng bạc, cứ dưới mỗi tấm có hai lỗ mộng. ");
INSERT INTO vie1934_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ngươi cũng hãy làm sáu tấm ván về phía sau đền tạm, tức là về hướng tây. ");
INSERT INTO vie1934_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Về hai góc phía sau đền tạm, phải làm hai tấm ván, ");
INSERT INTO vie1934_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","khít nhau tự dưới chí trên bởi một cái khoen ở nơi đầu; hai cái góc đều làm như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Thế thì, có tám tấm ván và mười sáu lỗ mộng bằng bạc; cứ hai lỗ mộng ở dưới mỗi một tấm ván. ");
INSERT INTO vie1934_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Lại, ngươi hãy làm năm cây xà ngang bằng gỗ si-tim cho những tấm ván về phía bên nầy, ");
INSERT INTO vie1934_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","năm cây xà ngang về phía bên kia và năm cây xà ngang khác nữa về phía sau của đền tạm, tức là hướng tây. ");
INSERT INTO vie1934_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Cây xà ngang giữa sẽ ở về thân giữa những tấm ván, chạy suốt từ đầu nầy đến đầu kia. ");
INSERT INTO vie1934_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Cũng hãy lấy vàng bọc ván cùng xà ngang, và làm những khoen bằng vàng, đặng xỏ các cây xà ngang. ");
INSERT INTO vie1934_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ngươi phải dựng đền tạm y như kiểu đã chỉ cho ngươi trên núi vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ngươi hãy làm một bức màn bằng vải gai đậu mịn, chỉ tím, đỏ điều, đỏ sặm, có thêu những hình chê-ru-bin cực xảo; ");
INSERT INTO vie1934_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","rồi xủ màn đó trên bốn trụ bằng cây si-tim, bọc vàng, dựng trên bốn lỗ trụ bằng bạc; các móc trụ đều bằng vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ngươi sẽ treo màn đó vào móc dưới bức bong, rồi ở phía trong màn để hòm bảng chứng; màn nầy dùng phân biệt cho các ngươi nơi thánh và nơi chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Đoạn, hãy để cái nắp thi ân trên hòm bảng chứng, đặt trong nơi chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Bên ngoài bức màn về phía bắc đền tạm thì để cái bàn; còn cây chân đèn thì để về phía nam đối ngang cái bàn. ");
INSERT INTO vie1934_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Về cửa Trại ngươi hãy làm một bức màn bằng chỉ tím, đỏ điều, đỏ sặm, vải gai đậu mịn, có thêu cực xảo; ");
INSERT INTO vie1934_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","rồi làm cho bức màn nầy năm cái trụ bằng cây si-tim, bọc vàng; đinh nó cũng bằng vàng, và đúc năm lỗ trụ bằng đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ngươi cũng hãy đóng một bàn thờ bằng cây si-tim, hình vuông, năm thước bề dài, năm thước bề ngang, và bề cao ba thước. ");
INSERT INTO vie1934_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Nơi bốn góc bàn thờ hãy làm sừng ló ra và bọc đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Những đồ phụ tùng của bàn thờ thì hãy làm bằng đồng: bình đựng tro, vá, ảng, nỉa và bình hương. ");
INSERT INTO vie1934_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Lại làm cho bàn thờ một tấm rá bằng lưới đồng; và nơi bốn góc rá làm bốn cái khoen bằng đồng; ");
INSERT INTO vie1934_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","rồi để rá đó dưới thành bàn thờ, từ dưới chân lên đến nửa bề cao. ");
INSERT INTO vie1934_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Cũng hãy chuốt đòn khiêng bàn thờ bằng cây si-tim, bọc đồng, ");
INSERT INTO vie1934_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","rồi xỏ vào những khoen; khi khiêng đi, đòn sẽ ở hai bên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Bàn thờ sẽ đóng bằng ván, trống bộng, làm y như đã chỉ cho ngươi trên núi vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ngươi cũng hãy làm cái hành lang cho đền tạm. Về phía nam của hành lang làm bố vi bằng vải gai đậu mịn, dài trăm thước, ");
INSERT INTO vie1934_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","cùng hai chục cây trụ và hai chục lỗ trụ bằng đồng; đinh và nuông trụ thì bằng bạc. ");
INSERT INTO vie1934_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Về phía bắc cũng vậy; bố vi đó có trăm thước bề dài, hai chục cây trụ và hai chục lỗ trụ bằng đồng; đinh và nuông trụ thì bằng bạc. ");
INSERT INTO vie1934_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Bố-vi của hành lang về phía tây có năm chục thước bề dài, mười cây trụ và mười lỗ trụ. ");
INSERT INTO vie1934_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Bề ngang của hành lang phía trước, tức là phía đông, có năm chục thước: phía hữu ");
INSERT INTO vie1934_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","có mười lăm thước bố vi, ba cây trụ và ba lỗ trụ; ");
INSERT INTO vie1934_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","phía tả có mười lăm thước bố vi, ba cây trụ và ba lỗ trụ. ");
INSERT INTO vie1934_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Còn cửa hành lang có một bức màn dài hai chục thước bằng vải gai đậu mịn, chỉ tím, đỏ điều, đỏ sặm, có thêu, cùng vốn cây trụ và bốn lỗ trụ. ");
INSERT INTO vie1934_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Hết thảy trụ xung quanh hành lang đều sẽ có nhờ nuông bạc chắp lại với nhau; đinh trụ thì bằng bạc, lỗ trụ thì bằng đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Bề dài của hành lang được một trăm thước, bề ngang, mỗi phía, năm chục thước, bề cao năm thước; bố vi sẽ bằng vải gai đậu mịn, còn những lỗ trụ thì bằng đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Hết thảy đồ phụ tùng dùng về các việc phụng sự trong đền tạm, cùng cây nọc của đền tạm và cây nọc của hành lang, đều sẽ làm bằng đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ngươi hãy truyền cho dân Y-sơ-ra-ên đem đến dầu lọc ô-li-ve ép, đặng thắp đèn cho đèn sáng luôn luôn. ");
INSERT INTO vie1934_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Trong hội mạc, ở ngoài màn, trước hòm bảng chứng, A-rôn cùng các con trai người sẽ lo sửa soạn đèn, hầu cho trước mặt Đức Giê-hô-va đèn cháy luôn luôn từ tối cho đến sáng. Aáy là một luật đời đời cho dòng dõi dân Y-sơ-ra-ên phải giữ. ");
INSERT INTO vie1934_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Trong vòng dân Y-sơ-ra-ên, ngươi hãy chọn A-rôn, anh ngươi, cùng các con trai ngươi, là Na-đáp, A-bi-hu, Ê-lê-a-sa, và Y-tha-ma, lập lên làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ngươi hãy chế bộ áo thánh cho A-rôn, anh ngươi, để người được vinh hiển trang sức. ");
INSERT INTO vie1934_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Hãy truyền cho hết thảy kẻ thông minh, là người ta đã ban đầy tính trí huệ, chế bộ áo cho A-rôn, đặng biệt người riêng ra thánh, hầu cho người làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Đây là bộ áo mà họ sẽ chế: Bảng đeo ngực, ê-phót, áo dài, áo lá trong thêu, mũ và đai. Thế thì, họ sẽ chế bộ áo thánh cho A-rôn, anh ngươi, cùng các con trai người, để các người đó làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Họ sẽ dùng kim tuyến, chỉ màu tím, đỏ điều, đỏ sặm, và vải gai mịn. ");
INSERT INTO vie1934_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Họ sẽ chế ê-phót bằng kim tuyến, chỉ màu tím, đỏ điều, đỏ sặm, và vải gai đậu mịn thêu cực xảo. ");
INSERT INTO vie1934_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hai bên ê-phót làm hai đai vai, đâu đầu vào ê-phót. ");
INSERT INTO vie1934_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Đai để cột ê-phót ở phía ngoài, sẽ làm nguyên miếng một cũng như công việc ê-phót, bằng kim tuyến, chỉ tím, đỏ điều, đỏ sặm, và vải gai đậu mịn. ");
INSERT INTO vie1934_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Ngươi hãy lấy hai viên bích ngọc mà khắc các tên con trai Y-sơ-ra-ên ở trên: ");
INSERT INTO vie1934_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","sáu tên trên viên bích ngọc nầy, sáu tên trên viên bích ngọc kia, tùy theo thứ tự ngày sinh của họ. ");
INSERT INTO vie1934_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Phải khắc các tên con trai Y-sơ-ra-ên trên hai viên bích ngọc đó, như cách của thợ khắc con dấu, và khảm trong khuôn bằng vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Đoạn gắn hai viên bích ngọc đó trên hai đai vai ê-phót, dùng làm ngọc kỷ niệm về con cháu Y-sơ-ra-ên; A-rôn sẽ mang tên của họ trên hai vai mình làm kỷ niệm trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ngươi cũng hãy làm móc gài bằng vàng, ");
INSERT INTO vie1934_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","đánh hai sợi dây chuyền nhỏ bằng vàng ròng như hình dây, rồi để chuyền đánh như thế vào móc gài. ");
INSERT INTO vie1934_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Bảng đeo ngực về sự xét đoán, ngươi cũng phải làm cho cực xảo, y như ê-phót; tức là bằng kim tuyến, chỉ tím, đỏ điều, đỏ sặm, và vải gai đậu mịn. ");
INSERT INTO vie1934_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Bảng đeo ngực hình vuông và may lót; bề dài một em-ban, bề ngang một em-ban. ");
INSERT INTO vie1934_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ngươi hãy gắn bốn hàng ngọc vào bảng đeo ngực: hàng thứ nhất gắn ngọc mã não, ngọc hồng bích, và ngọc lục bửu; ");
INSERT INTO vie1934_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","hàng thứ nhì, ngọc phỉ túy, ngọc lam bửu và ngọc kim cương; ");
INSERT INTO vie1934_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","hàng thứ ba, ngọc hồng bửu, ngọc bạch mã não, và ngọc tử tinh; ");
INSERT INTO vie1934_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","hàng thứ tư, ngọc hu”nh bích, ngọc hồng mã não, và bích ngọc. Các ngọc nầy sẽ khảm vào khuôn bằng vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Số các ngọc đó hết thảy là mười hai viên, tùy theo tên các con trai Y-sơ-ra-ên; trên mỗi viên ngọc sẽ khắc tên của một trong mười hai chi phái Y-sơ-ra-ên, như người ta khắc con dấu vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ngươi hãy làm các sợi chuyền bằng vàng ròng đánh như hình dây, chuyền trên bảng đeo ngực; ");
INSERT INTO vie1934_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","rồi làm hai khoanh bằng vàng để ở hai góc đầu trên bảng. ");
INSERT INTO vie1934_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","cùng cột hai sợi chuyền vàng vào hai khoanh nơi hai đầu bảng, ");
INSERT INTO vie1934_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","và hai đầu sợi chuyền cột vào móc gài, đoạn gắn trên hai đai vai ê-phót về phía đằng trước ngực. ");
INSERT INTO vie1934_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ngươi cũng hãy làm hai cái khoanh bằng vàng nữa, để vào hai góc đầu dưới của bảng đeo ngực, về phía trong ê-phót. ");
INSERT INTO vie1934_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Lại làm hai khoanh khác nữa bằng vàng, gắn vào hai đầu dưới đai vai ê-phót ném về phía trước, ở trên đai gần chỗ giáp mối. ");
INSERT INTO vie1934_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Rồi một sợi dây màu tím sẽ cột hai cái khoanh của bảng đeo ngực lại cùng hai cái khoanh ê-phót, hầu cho nó dính với đai, đừng rớt khỏi ê-phót. ");
INSERT INTO vie1934_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Thế thì, khi nào A-rôn vào nơi thánh, sẽ mang trên lòng mình tên các con trai Y-sơ-ra-ên nơi bảng đeo ngực về sự xét đoán, đặng giữ làm kỷ niệm luôn luôn trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Trên bảng đeo ngực của sự xét đoán, ngươi hãy gắn u-rim và thu-mim vào, đặng khi A-rôn đến trước mặt Đức Giê-hô-va thì các món đó sẽ ở trên lòng mình. Aáy vậy, trước mặt Đức Giê-hô-va, A-rôn sẽ mang sự xét đoán của con trai Y-sơ-ra-ên trên lòng mình luôn luôn. ");
INSERT INTO vie1934_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Ngươi cũng hãy may áo dài của ê-phót toàn bằng vải tím. ");
INSERT INTO vie1934_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ỳ giữa áo có một lỗ tròng đầu vào; viền chung quanh, dệt như lỗ áo giáp mặt lưới, để cho khỏi tét. ");
INSERT INTO vie1934_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Nơi biên dưới hãy thắt trái lựu màu tím, đỏ điều, đỏ sặm, cùng chuông vàng nhỏ đan tréo nhau ở vòng theo viền, ");
INSERT INTO vie1934_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","nghĩa là một cái chuông rồi kế một trái lựu, ở vòng khắp chung quanh viền áo. ");
INSERT INTO vie1934_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Khi A-rôn hầu việc tế lễ, sẽ mặc áo đó; và khi vào hay ra nơi thánh trước mặt Đức Giê-hô-va, người ta sẽ nghe tiếng chuông vàng nhỏ, và A-rôn khỏi chết vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ngươi cũng hãy làm một cái thẻ bằng vàng ròng, trên đó khắc như người ta khắc con dấu, rằng: Thánh Cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Rồi lấy một sợi dây màu tím buộc thẻ đó để trên đằng trước cái mũ. ");
INSERT INTO vie1934_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Thẻ đó sẽ ở trên trán A-rôn; A-rôn gánh tội lỗi của dân Y-sơ-ra-ên phạm trong khi họ dâng của lễ thánh; thẻ đó sẽ ở nơi trán A-rôn luôn luôn, để dân sự được đẹp ý Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ngươi hãy chế một cái áo lá mặc trong bằng vải gai mịn, một cái mũ bằng vải gai mịn và một cái đai thêu. ");
INSERT INTO vie1934_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ngươi cũng hãy chế cho các con trai A-rôn áo lá, đai và mũ, hầu cho họ được vinh hiển và trang sức. ");
INSERT INTO vie1934_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Đoạn, hãy lấy các bộ áo đó mặc cho A-rôn, anh ngươi, cùng các con trai người; hãy xức dầu cho, lập và biệt riêng ra thánh, để họ làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Hãy chế cho họ quần lót trong bằng vải gai, đặng che sự lõa lồ, mặc từ ngang lưng quần cho đến bắp vế. ");
INSERT INTO vie1934_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","A-rôn cùng các con trai người sẽ mặc quần đó trong khi vào hội mạc hay là đến gần bàn thờ đặng làm việc tế lễ trong nơi thánh, thì chẳng mắc tội và chẳng chết đâu. Aáy là một mạng lịnh đời đời cho A-rôn và dòng dõi người. ");
INSERT INTO vie1934_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Đây là điều ngươi sẽ làm đặng biệt A-rôn và con trai người riêng ra thánh, để họ làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Hãy bắt một con bò tơ đực và hai con chiên đực không tì vít, dùng bột mì thiệt mịn làm bánh không men, bánh nhỏ không men nhồi với dầu, và bánh tráng không men tẩm dầu; ");
INSERT INTO vie1934_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","rồi để các bánh đó trong một giỏ dâng luôn lên cùng bò tơ đực và hai chiên đực. ");
INSERT INTO vie1934_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Đoạn, ngươi sẽ biểu A-rôn cùng các con trai người đến gần nơi cửa hội mạc, rồi lấy nước tắm cho họ. ");
INSERT INTO vie1934_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kế đó, lấy bộ áo mặc cho A-rôn, tức là áo lá mặc trong, áo dài của ê-phót, ê-phót, và bảng đeo ngực, rồi lấy đai của ê-phót thắt lưng cho người; ");
INSERT INTO vie1934_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","đoạn đội cái mũ lên đầu và để thẻ thánh trên mũ, ");
INSERT INTO vie1934_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","cùng lấy dầu xức đổ trên đầu và xức cho người. ");
INSERT INTO vie1934_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Lại biểu các con trai A-rôn đến gần mặc áo lá cho họ, ");
INSERT INTO vie1934_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","rồi lấy đai thắt lưng và đội mũ cho A-rôn cùng các con trai người. Thế thì, chức tế lễ sẽ bởi mạng lịnh định đời đời cho họ. Ngươi lập A-rôn và các con trai người là thế. ");
INSERT INTO vie1934_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Đoạn, hãy dắt con bò tơ đực lại gần trước hội mạc, A-rôn cùng các con trai người sẽ nhận tay mình trên đầu con bò đó. ");
INSERT INTO vie1934_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ngươi hãy giết bò đực trước mặt Đức Giê-hô-va, tại nơi cửa hội mạc; ");
INSERT INTO vie1934_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","rồi lấy huyết bò đó, nhúng ngón tay vào, bôi các sừng của bàn thờ, và đổ khắp dưới chân bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Cũng hãy lấy hết thảy những mỡ bọc ruột, tấm da mỏng bọc gan, hai trái cật và mỡ trên trái cật, mà đem xông trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Nhưng ở ngoài trại quân hãy thiêu hết thịt, da, và phẩn của con bò đực đó; ấy là một của lễ chuộc tội vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ngươi cũng hãy bắt một trong hai con chiên đực, A-rôn và các con trai ngươi sẽ nhận tay mình trên đầu nó; ");
INSERT INTO vie1934_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","rồi giết chiên đực đó, lấy huyết mà rưới khắp chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kế đó, sả chiên ra từng miếng, rửa sạch bộ lòng và giò đi, rồi để lên trên các miếng đã sả và đầu nó; ");
INSERT INTO vie1934_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","đoạn xông cả con chiên đực tại trên bàn thờ; ấy là một của lễ thiêu, có mùi thơm dâng cho Đức Giê-hô-va, tức là một của lễ dùng lửa dâng lên cho Đức Giê-hô-va vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Đoạn, ngươi hãy bắt con chiên đực thứ nhì, A-rôn cùng các con trai người sẽ nhận tay mình trên đầu nó; ");
INSERT INTO vie1934_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","rồi ngươi giết chiên đực đó, lấy huyết bôi nơi trái tai hữu của A-rôn và của các con trai người, trên ngón cái bàn tay mặt và ngón cái bàn chân mặt; huyết còn dư hãy rưới chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ngươi hãy lấy huyết ở nơi bàn thờ và dầu xức mà rảy trên mình và quần áo A-rôn, cùng trên mình và quần áo các con trai người. Như vậy, A-rôn cùng quần áo mình, các con trai người cùng quần áo họ sẽ được biệt riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Vì cớ chiên đực đó dùng làm lễ truyền chức, nên ngươi hãy lấy mỡ, đuôi, mỡ bọc ruột, tấm da mỏng bọc gan, hai trái cật, cùng mỡ trên trái cật và giò bên hữu, ");
INSERT INTO vie1934_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","lại lấy luôn một ổ bánh, một bánh nhỏ nhồi với dầu, và một cái bánh tráng ở trong giỏ bánh không men để trước mặt Đức Giê-hô-va; ");
INSERT INTO vie1934_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","rồi ngươi để mấy món đó trong lòng bàn tay A-rôn, và trong lòng bàn tay của các con trai người, mà đưa qua đưa lại trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Đoạn, hãy lấy ra khỏi bàn tay họ đem xông trên bàn thờ, ở trên của lễ thiêu, để cho có mùi thơm trước mặt Đức Giê-hô-va; ấy là một của lễ dùng lửa dâng lên cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Cũng hãy lấy cái o chiên đực về lễ lập A-rôn mà đưa qua đưa lại trước mặt Đức Giê-hô-va. Aáy sẽ về phần ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Vậy, ngươi sẽ biệt riêng ra thánh cái o và giò của chiên đực đã dùng làm lễ lập A-rôn cùng các con trai người, tức là o đã đưa qua đưa lại, và giò đã giơ lên. ");
INSERT INTO vie1934_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Lễ vật nầy sẽ do nơi Y-sơ-ra-ên dâng cho A-rôn cùng các con trai người tùy theo mạng lịnh đời đời đã lập, vì là một điều ban cho bởi trong các của lễ thù ân của dân Y-sơ-ra-ên, tức là một của lễ giơ lên mà họ dâng cho Đức Giê-hô-va vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Những áo thánh của A-rôn sẽ để lại cho các con trai nối sau người, để họ mặc áo đó, được xức dầu và lập trong chức tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ai trong vòng con trai người được làm thầy tế lễ thế cho người, mà đến hội mạc đặng hầu việc tại nơi thánh, thì sẽ mặc áo đó trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Đoạn, ngươi hãy bắt con chiên đực dùng làm lễ thiết lập mà nấu thịt nó trong một nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","A-rôn cùng các con trai người sẽ ăn thịt chiên đực đó, cùng bánh trong giỏ nơi cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Vậy, họ sẽ ăn các món nầy, bởi đó được chuộc tội, để lập và biệt họ riêng ra thánh; nhưng khách ngoại bang chẳng được ăn, vì các món đó đã biệt riêng ra thánh rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Nếu thịt lễ thiết lập và bánh còn dư lại đến ngày mai, ngươi hãy thiêu trong lửa, chớ nên ăn, vì là của đã biệt riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Vậy, theo mọi điều ta phán dặn, ngươi hãy làm cho A-rôn cùng các con trai người, và lập họ trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Mỗi ngày hãy dâng một con bò tơ đực đặng chuộc tội, và dâng vì bàn thờ một của lễ chuộc tội cùng xức dầu cho, để biệt bàn thờ riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Trong bảy ngày ngươi hãy làm lễ chuộc tội cho bàn thờ và biệt riêng ra thánh; bàn thờ sẽ trở nên rất thánh, phàm vật chi đụng đến đều sẽ được nên thánh vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Đây là các điều ngươi sẽ dâng lên bàn thờ: Hai chiên con một tuổi, mỗi ngày thường thường như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Buổi sớm mai ngươi hãy dâng một trong hai chiên con; con thứ nhì hãy dâng vào buổi chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Với con chiên thứ nhất, hãy dâng một phần mười bột mì mịn nhồi với một phần tư hin dầu ép, và cùng lễ quán một phần tư hin rượu nho. ");
INSERT INTO vie1934_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Về con chiên thứ nhì hãy dâng vào buổi chiều tối với một của lễ và một lễ quán y như lễ sớm mai; ấy là một của lễ thiêu, có mùi thơm dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Aáy là một của lễ thiêu mà các ngươi phải dâng luôn luôn, trải qua các đời, tại cửa hội mạc trước mặt Đức Giê-hô-va, là nơi ta sẽ giáng lâm mà phán cùng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Vậy, ta sẽ có tại đó cùng dân Y-sơ-ra-ên; chỗ nầy sẽ vì sự vinh hiển ta mà được biệt riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ta sẽ biệt hội mạc cùng bàn thờ riêng ra thánh; cùng biệt A-rôn và các con trai người riêng ra thánh nữa, đặng họ làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ta sẽ ở giữa dân Y-sơ-ra-ên, làm Đức Chúa Trời dân ấy. ");
INSERT INTO vie1934_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Dân ấy sẽ biết ta là Giê-hô-va Đức Chúa Trời của chúng nó, đã đem chúng nó ra khỏi xứ Ê-díp-tô đặng ở giữa vòng họ. Ta là Giê-hô-va Đức Chúa Trời của họ. ");
INSERT INTO vie1934_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ngươi cũng hãy đóng một cái bàn thờ bằng cây si-tim, để xông hương. ");
INSERT INTO vie1934_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Mặt bàn sẽ vuông, bề dài một thước, bề ngang một thước, và bề cao hai thước; bàn thờ sẽ có bốn sừng ló ra. ");
INSERT INTO vie1934_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ngươi hãy bọc vàng ròng trên mặt, bốn cạnh chung quanh và các sừng; còn tứ vi chạy đường viền vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Dưới đường viền đó, nơi hai bên, hãy làm hai cái khoen bằng vàng, để xỏ đòn dùng đặng khiêng. ");
INSERT INTO vie1934_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Hãy chuốt đòn khiêng bằng cây si-tim, bọc vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ngươi sẽ để bàn thờ đó trước bức màn che hòm bảng chứng đối cùng nắp thi ân trên hòm, là nơi ta sẽ gặp ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Mỗi buổi sớm mai, khi A-rôn làm đèn, sẽ xông hương tại nơi đó. ");
INSERT INTO vie1934_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Vào lúc chiều tối, khi A-rôn thắp đèn, cũng sẽ xông hương: ấy là một thứ hương phải xông trước mặt Đức Giê-hô-va luôn luôn, trải qua các đời. ");
INSERT INTO vie1934_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Trên bàn thờ nầy chớ xông hương lạ, hoặc dâng của lễ thiêu, của lễ chay hay là lễ quán nào hết. ");
INSERT INTO vie1934_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Nhưng trải qua các đời, mỗi năm một lần, A-rôn sẽ lấy huyết của con sinh tế chuộc tôi, bôi trên sừng bàn thờ nầy đặng chuộc tội cho nó. Aáy sẽ là một việc rất thánh cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Đức Giê-hô-va cũng phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Khi nào ngươi điểm số dân Y-sơ-ra-ên đặng kê sổ, mỗi tên phải nộp tiền đền mạng mình cho Đức Giê-hô-va, hầu cho khỏi mắc tai nạn chi trong khi kê sổ. ");
INSERT INTO vie1934_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kẻ nào có tên trong sổ phải nộp nửa siếc-lơ, tùy siếc-lơ của nơi thánh, cân nặng hai mươi ghê-ra; vậy, nửa siếc-lơ, tức là của dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Mọi người có tên vào sổ từ hai mươi tuổi sắp lên sẽ dâng của nầy cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Khi dâng của nầy cho Đức Giê-hô-va đặng đền mạng mình, người giàu không nộp trội, người nghèo không nộp thiếu nửa siếc-lơ. ");
INSERT INTO vie1934_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Vậy, ngươi thâu tiền đền mạng của dân Y-sơ-ra-ên, rồi dùng tiền đó vào việc hội mạc; ấy là một kỷ niệm của dân Y-sơ-ra-ên trước mặt Đức Giê-hô-va, đặng đền mạng mình. ");
INSERT INTO vie1934_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Đức Giê-hô-va lại phán cùng Môi-se nữa rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Ngươi hãy làm một cái thùng với chân thùng bằng đồng, đặng rửa mình ở trong, rồi để giữa khoảng của hội mạc và bàn thờ, và đổ nước vào. ");
INSERT INTO vie1934_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","A-rôn cùng các con trai người sẽ rửa tay và chân mình ở trong. ");
INSERT INTO vie1934_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Khi họ vào hội mạc sẽ lấy nước rửa mình, hầu cho họ khỏi chết; và khi lại gần bàn thờ đặng phụng sự, tức là xông của lễ dùng lửa dâng cho Đức Giê-hô-va, họ cũng phải giữ như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Thế thì, họ hãy rửa tay và chân, hầu cho khỏi chết. Aáy là một lệ đời đời cho A-rôn, cùng dòng dõi người trải qua các đời. ");
INSERT INTO vie1934_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Hãy góp các hương liệu tốt nhất: một dược nước năm trăm siếc-lơ; hương nhục quế phân nửa số đó, tức là hai trăm rưỡi; hương xương bồ hai trăm rưỡi; ");
INSERT INTO vie1934_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","quế bì năm trăm, đều theo siếc-lơ nơi thánh, và một hin dầu ô-li-ve. ");
INSERT INTO vie1934_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ngươi hãy lấy các hương liệu đó theo phép hòa hương, chế ra một thứ dầu thơm dùng làm dầu xức thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Đoạn, lấy xức cho hội mạc cùng hòm bảng chứng, ");
INSERT INTO vie1934_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","bàn thờ cùng các đồ phụ tùng, chân đèn cùng các đồ phụ tùng, bàn thờ xông hương, ");
INSERT INTO vie1934_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","bàn thờ của lễ thiêu cùng các đồ phụ tùng, cái thùng và chân thùng. ");
INSERT INTO vie1934_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Aáy vậy, ngươi sẽ biệt các vật nầy riêng ra thánh, hầu cho làm rất thánh, hễ món chi đụng đến, đều sẽ được nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ngươi cũng hãy xức dầu cho A-rôn cùng các con trai người, biệt họ riêng ra thánh, để làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Lại hãy nói cùng dân Y-sơ-ra-ên rằng: Về phần ta, dầu nầy sẽ là dầu xức thánh trải qua mọi đời các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Chớ nên đổ trên xác thịt loài người, và cũng đừng làm dầu nào khác theo phép hòa hương đó; dầu nầy là thánh, cũng sẽ thánh cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Hễ ai chế một thứ hòa hương giống như vậy, và đem rưới trên mình người ngoại bang, sẽ bị truất khỏi vòng dân sự. ");
INSERT INTO vie1934_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Đức Giê-hô-va phán cùng Môi-se nữa rằng: Hãy lấy các hương liệu, tức tô hiệp hương, loa yểm hương, phong chi hương, cùng thanh nhũ hương, mỗi thứ bằng nhau, ");
INSERT INTO vie1934_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","theo phép hòa hương, chế ra một thứ hương, mặn, trong và thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Hãy nghiền nó ra bột, rồi để trước hòm bảng chứng trong hội mạc, tức là nơi ta sẽ gặp ngươi: về phần các ngươi, hương nầy sẽ là một vật rất thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Còn thứ hương mà ngươi sẽ chế, chớ chế giống như phép hòa hương nầy; ấy là một vật ngươi nên biệt riêng ra thánh cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Hễ kẻ nào làm giống y như vậy đặng ngửi mùi, sẽ bị truất khỏi vòng dân sự. ");
INSERT INTO vie1934_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Đức Giê-hô-va phán cùng Môi-se nữa rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Nầy, ta đã kêu tên Bết-sa-lê-ên, con trai của U-ri, cháu của Hu-rơ, trong chi phái Giu-đa. ");
INSERT INTO vie1934_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ta đã làm cho người đầy dẫy Thần của Đức Chúa Trời, sự khôn ngoan, sự thông sáng, và sự hiểu biết để làm mọi thứ nghề thợ, ");
INSERT INTO vie1934_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","đặng bày ra và chế tạo đồ vàng, bạc và đồng, ");
INSERT INTO vie1934_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","đặng khắc và khảm ngọc, đẽo gỗ và làm được mọi thứ nghề thợ. ");
INSERT INTO vie1934_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Đây, ta lại cho một người phụ việc, tên là Ô-hô-li-áp, con trai của A-hi-sa-mạc, trong chi phái Đan. Ta cũng đã ban sự thông minh cho mọi người tài năng, hầu cho họ làm các việc ta đã phán dặn ngươi, ");
INSERT INTO vie1934_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","là hội mạc, hòm bảng chứng, nắp thi ân ở trên hòm, cùng đồ dùng trong hội mạc; ");
INSERT INTO vie1934_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","bàn thờ cùng đồ phụ tùng, chân đèn bằng vàng ròng và đồ phụ tùng, bàn thờ xông hương, ");
INSERT INTO vie1934_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","bàn thờ dâng của lễ thiêu cùng đồ phụ tùng, cái thùng và chân thùng; ");
INSERT INTO vie1934_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","áo lễ, áo thánh cho A-rôn thầy tế lễ cả, và bộ áo cho các con trai người, đặng làm chức tế lễ; ");
INSERT INTO vie1934_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","dầu xức, và hương thơm của nơi thánh. Các người đó phải làm hết thảy theo lời ta đã phán dặn ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Phần ngươi, hãy nói cùng dân Y-sơ-ra-ên rằng: Nhất là các ngươi hãy giữ ngày sa-bát ta, vì là một dấu giữa ta và các ngươi, trải qua mọi đời, để thiên hạ biết rằng ta, là Đức Giê-hô-va, làm cho các ngươi nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Vậy, hãy giữ ngày sa-bát, vì là một ngày thánh cho các ngươi. Kẻ nào phạm đến ngày đó, phải bị xử tử; kẻ nào làm một việc chi trong ngày đó, cũng sẽ bị truất khỏi vòng dân sự. ");
INSERT INTO vie1934_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Người ta sẽ làm công việc trong sáu ngày, nhưng qua ngày thứ bảy là ngày sa-bát, tức là ngày nghỉ, biệt riêng ra thánh cho Đức Giê-hô-va. Trong ngày sa-bát hễ ai làm một việc chi sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Aáy vậy, dân Y-sơ-ra-ên sẽ giữ ngày sa-bát trải các đời của họ, như một giao ước đời đời. ");
INSERT INTO vie1934_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Aáy là một dấu đời đời cho ta cùng dân Y-sơ-ra-ên, vì Đức Giê-hô-va đã dựng nên trời và đất trong sáu ngày, qua ngày thứ bảy Ngài nghỉ và lấy sức lại. ");
INSERT INTO vie1934_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Khi Đức Giê-hô-va đã phán xong cùng Môi-se tại núi Si-na-i, bèn cho người hai bảng chứng bằng đá, bởi ngón tay Đức Chúa Trời viết ra. ");
INSERT INTO vie1934_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Dân sự thấy Môi-se ở trên núi chậm xuống, bèn nhóm lại chung quanh A-rôn mà nói rằng: Nào! hãy làm các thần để đi trước chúng tôi đi, vì về phần Môi-se nầy, là người đã dẫn chúng tôi ra khỏi xứ Ê-díp-tô, chúng tôi chẳng biết điều chi đã xảy đến cho người rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","A-rôn đáp rằng: Hãy lột những vòng vàng đeo nơi tai vợ, con trai và con gái các ngươi đi, rồi đem lại cho ta. ");
INSERT INTO vie1934_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Hết thảy đều lột vòng vàng nơi tai mình mà đem lại cho A-rôn; ");
INSERT INTO vie1934_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","người nhận lấy nơi tay họ, và dùng đục làm thành một bò con đúc. Dân chúng nói rằng: Hỡi Y-sơ-ra-ên! nầy là các thần của ngươi đã đem ngươi ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","A-rôn thấy vậy, bèn lập một bàn thờ trước mặt tượng bò đó; đoạn, người la lên rằng: Sáng mai sẽ có lễ tôn trọng Đức Giê-hô-va! ");
INSERT INTO vie1934_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Sáng mai dân chúng bèn thức dậy sớm, dâng các của lễ thiêu và lễ thù ân; ngồi mà ăn uống, đoạn đứng dậy mà vui chơi. ");
INSERT INTO vie1934_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy xuống đi, vì dân mà ngươi đưa ra khỏi xứ Ê-díp-tô đã bại hoại rồi, ");
INSERT INTO vie1934_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","vội bỏ đạo ta truyền dạy, đúc một con bò tơ, mọp trước tượng bò đó và dâng của lễ cho nó mà nói rằng: Hỡi Y-sơ-ra-ên! đây là các thần đã dẫn ngươi lên khỏi xứ Ê-díp-tô! ");
INSERT INTO vie1934_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Đức Giê-hô-va cũng phán cùng Môi-se rằng: Ta đã xem thấy dân nầy, kìa là một dân cứng cổ. ");
INSERT INTO vie1934_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Vả, bây giờ hãy để mặc ta làm, hầu cho cơn thạnh nộ ta nổi lên cùng chúng nó, diệt chúng nó đi; nhưng ta sẽ làm cho ngươi thành một dân lớn. ");
INSERT INTO vie1934_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Môi-se bèn nài xin Giê-hô-va Đức Chúa Trời người rằng: Lạy Đức Giê-hô-va, sao nổi thạnh nộ cùng dân Ngài? là dân mà Ngài đã dùng quyền lớn lao mạnh mẽ đưa ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Sao để cho người Ê-díp-tô nói rằng: Ngài đưa chúng nó ra khỏi xứ đặng làm hại cho, giết đi tại trong núi, cùng diệt chúng nó khỏi mặt đất? Cầu xin Chúa hãy nguôi cơn giận và bỏ qua điều tai họa mà Ngài muốn giáng cho dân Ngài. ");
INSERT INTO vie1934_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Xin Chúa hãy nhớ lại Aùp-ra-ham, Y-sác, Y-sơ-ra-ên, là các tôi tớ Ngài, mà Ngài có chỉ mình thề cùng họ rằng: Ta sẽ thêm dòng dõi các ngươi lên nhiều như sao trên trời, ta sẽ ban cho dòng dõi đó cả xứ mà ta chỉ phán, và họ sẽ được xứ ấy làm cơ nghiệp đời đời. ");
INSERT INTO vie1934_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Đức Giê-hô-va bèn bỏ qua điều tai họa mà Ngài nói rằng sẽ giáng cho dân mình. ");
INSERT INTO vie1934_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Đoạn, Môi-se ở trên núi trở xuống, tay cầm hai bảng chứng; hai bảng chứng có viết hai bên, mặt nầy và mặt kia. ");
INSERT INTO vie1934_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Hai bảng đó là việc của Đức Chúa Trời làm ra; chữ cũng là chữ của Đức Chúa Trời khắc trên bảng. ");
INSERT INTO vie1934_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Vả, Giô-suê nghe dân chúng la lên, bèn nói cùng Môi-se rằng: Trong trại quân có tiếng chiến đấu. ");
INSERT INTO vie1934_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Môi-se đáp rằng: Chẳng phải tiếng kêu về thắng trận, cũng chẳng phải tiếng kêu về thua trận; nhưng ta nghe tiếng kẻ hát. ");
INSERT INTO vie1934_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Khi đến gần trại quân, Môi-se thấy bò con và sự nhảy múa, bèn nổi giận, liệng hai bảng chứng khỏi tay mình, bể ra nơi chân núi; ");
INSERT INTO vie1934_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","đoạn lấy bò con của chúng đã đúc đem đốt trong lửa, rồi nghiền cho đến thành ra bụi, rải trên mặt nước, và cho dân Y-sơ-ra-ên uống. ");
INSERT INTO vie1934_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Môi-se bèn nói cùng A-rôn rằng: Dân nầy làm chi anh, mà anh xui cho chúng phạm tội nặng dường ấy? ");
INSERT INTO vie1934_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","A-rôn đáp rằng: Xin chúa tôi đừng nổi giận, chúa biết rằng dân nầy chuyên làm điều ác! ");
INSERT INTO vie1934_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Họ có nói cùng tôi rằng: Hãy làm các thần đi trước chúng tôi; vì về phần Môi-se nầy, là người đã dẫn chúng tôi ra khỏi xứ Ê-díp-tô, chúng tôi chẳng biết có điều chi xảy đến cho người rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Tôi bèn nói cùng chúng rằng: Ai có vàng hãy lột ra! Họ bèn đưa cho tôi, tôi bỏ vào lửa, và bởi đó thành ra bò con nầy. ");
INSERT INTO vie1934_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Vả, Môi-se thấy dân sự buông lung, vì A-rôn để họ buông lung, đến đỗi bị sỉ nhục trong vòng các thù nghịch, ");
INSERT INTO vie1934_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","thì người đứng nơi cửa trại quân mà nói rằng: Ai thuộc về Đức Giê-hô-va, hãy đến cùng ta đây! Hết thảy người Lê-vi đều nhóm lại gần bên người. ");
INSERT INTO vie1934_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Người truyền cho họ rằng: Giê-hô-va, là Đức Chúa Trời của Y-sơ-ra-ên, có phán như vầy: Mỗi người trong các ngươi hãy đeo gươm bên mình, đi qua đi lại trong trại quân, từ cửa nầy đến cửa kia, và mỗi người hãy giết anh em, bạn hữu, và kẻ lân cận mình. ");
INSERT INTO vie1934_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Dân Lê-vi bèn làm y như lời Môi-se; trong ngày đó có chừng ba ngàn người bị chết. ");
INSERT INTO vie1934_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Vả, Môi-se đã truyền rằng: Ngày nay mỗi người trong vòng các ngươi hãy dâng tay mình cho Đức Giê-hô-va, chẳng sá chi đến con trai hay là anh em mình, hầu cho các ngươi được ơn phước vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ngày mai, Môi-se nói cùng dân sự rằng: Các ngươi đã phạm một tội rất trọng; song bây giờ ta lên đến Đức Giê-hô-va, có lẽ ta sẽ được chuộc tội các ngươi chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Vậy, Môi-se trở lên đến Đức Giê-hô-va mà thưa rằng: Oâi! dân sự nầy có phạm một tội trọng, làm cho mình các thần bằng vàng; ");
INSERT INTO vie1934_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","nhưng bây giờ xin Chúa tha tội cho họ! Bằng không, hãy xóa tên tôi khỏi sách Ngài đã chép đi. ");
INSERT INTO vie1934_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Đức Giê-hô-va phán cùng Môi-se rằng: Kẻ nào phạm tội cùng ta, ta sẽ xóa nó khỏi sách ta. ");
INSERT INTO vie1934_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Bây giờ, hãy đi, dẫn dân sự đến nơi ta đã chỉ phán. Nầy thiên sứ ta sẽ đi trước ngươi; nhưng ngày nào ta hình phạt thì sẽ phạt tội chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Đức Giê-hô-va hành phạt dân sự là vậy, vì dân sự là gốc phạm về tượng bò vàng mà A-rôn đã làm ra. ");
INSERT INTO vie1934_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: Nầy, ngươi cùng dân sự mà ngươi đã dẫn ra khỏi xứ Ê-díp-tô hãy từ đây đi lên xứ ta đã thề ban cho Aùp-ra-ham, Y-sác, và Gia-cốp, rằng: Ta sẽ ban xứ đó cho dòng dõi ngươi. ");
INSERT INTO vie1934_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ta sẽ sai một thiên sứ đi trước ngươi, và sẽ đuổi dân Ca-na-an, dân A-mô-rít, dân Hê-tít, dân Phê-rê-sít, dân Hê-vít, và dân Giê-bu-sít, ");
INSERT INTO vie1934_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","đặng đưa các ngươi vào xứ đượm sữa và mật; nhưng ta không cùng lên với ngươi đâu, vì ngươi là dân cứng cổ, e ta diệt ngươi dọc đường chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Khi dân sự nghe lời hăm nầy, bèn đều để tang, không ai đeo đồ trang sức hết. ");
INSERT INTO vie1934_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Vì Đức Giê-hô-va đã phán cùng Môi-se rằng: Hãy nói cùng dân Y-sơ-ra-ên: Các ngươi là dân cứng cổ, nếu ta cùng lên với các ngươi chỉ trong một lúc, thì ta sẽ diệt các ngươi! Vậy, bây giờ, hãy cất đồ trang sức trong mình ngươi đi, đặng ta biết liệu đãi ngươi cách nào. ");
INSERT INTO vie1934_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Thế thì, từ núi Hô-rếp, dân Y-sơ-ra-ên đã lột các đồ trang sức mình. ");
INSERT INTO vie1934_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Môi-se lấy Trại đem dựng xa ra ngoài trại quân, gọi là hội mạc, phàm ai muốn cầu khẩn Đức Giê-hô-va, thì ra đến hội mạc ở ngoài trại quân. ");
INSERT INTO vie1934_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Vừa khi Môi-se ra đến Trại, thì cả dân sự chổi dậy, mỗi người đứng nơi cửa trại mình, ngó theo Môi-se cho đến khi nào người vào trong Trại rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Vừa khi người vào đó, thì trụ mây giáng xuống dừng tại cửa Trại, và Đức Giê-hô-va phán cùng Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Cả dân sự thấy trụ mây dừng tại cửa Trại, bèn đứng dậy, rồi mỗi người đều sấp mình xuống nơi cửa trại mình. ");
INSERT INTO vie1934_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Đức Giê-hô-va đối diện phán cùng Môi-se, như một người nói chuyện cùng bạn hữu mình. Đoạn, Môi-se trở về trại quân, còn kẻ hầu trẻ của người, tên là Giô-suê, con trai của Nun, không ra khỏi Trại. ");
INSERT INTO vie1934_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Môi-se thưa cùng Đức Giê-hô-va rằng: Nầy, Chúa phán cùng tôi rằng: Hãy đem dân sự nầy lên! Song Chúa chẳng cho tôi biết Chúa sai ai đi cùng tôi. Vả, Chúa có phán rằng: Ta biết ngươi vì danh ngươi, và ngươi được ơn trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Vậy bây giờ, nếu tôi được ơn trước mặt Chúa, xin cho tôi biết đường của Chúa, để cho tôi biết Chúa và được ơn trước mặt Ngài. Xin cũng hãy nghĩ rằng dân nầy là dân của Ngài! ");
INSERT INTO vie1934_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Đức Giê-hô-va đáp rằng: Chính mình ta sẽ đi cùng ngươi, và ta sẽ cho ngươi an nghỉ. ");
INSERT INTO vie1934_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Môi-se thưa rằng: Nếu chính mình Ngài chẳng đi, xin đừng đem chúng tôi lên khỏi đây. ");
INSERT INTO vie1934_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Lấy cớ chi mà người ta sẽ biết rằng tôi cùng dân sự Ngài được ơn trước mặt Ngài? Có phải khi nào Ngài cùng đi với chúng tôi chăng? Thế thì, tôi cùng dân sự Ngài sẽ được phân biệt với muôn dân trên mặt đất. ");
INSERT INTO vie1934_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Đức Giê-hô-va phán cùng Môi-se rằng: Ta sẽ làm điều ngươi cầu xin ta, vì ngươi được ơn trước mặt ta, và ta biết ngươi bởi danh ngươi vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Môi-se thưa rằng: Tôi xin Ngài cho tôi xem sự vinh hiển của Ngài! ");
INSERT INTO vie1934_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Đức Giê-hô-va phán rằng: Ta sẽ làm cho các sự nhân từ ta phát ra trước mặt ngươi; ta hô danh Giê-hô-va trước mặt ngươi; làm ơn cho ai ta muốn làm ơn, và thương xót ai ta muốn thương xót. ");
INSERT INTO vie1934_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ngài lại phán rằng: Ngươi sẽ chẳng thấy được mặt ta, vì không ai thấy mặt ta mà còn sống. ");
INSERT INTO vie1934_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Đức Giê-hô-va lại phán: Đây có một chỗ gần ta, ngươi hãy đứng trên hòn đá; ");
INSERT INTO vie1934_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","khi sự vinh hiển ta đi ngang qua, ta sẽ để ngươi trong bộng đá, lấy tay ta che ngươi, cho đến chừng nào ta đã đi qua rồi. ");
INSERT INTO vie1934_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ta sẽ rút tay lại, và ngươi thấy phía sau ta; nhưng thấy mặt ta chẳng được. ");
INSERT INTO vie1934_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy đục hai bảng đá như hai bảng trước; rồi ta sẽ viết trên hai bảng nầy các lời đã ở nơi hai bảng kia, mà ngươi đã làm bể. ");
INSERT INTO vie1934_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ngày mai, hãy chực cho sẵn, vừa sáng lên trên đỉnh núi Si-na-i, đứng trước mặt ta tại đó. ");
INSERT INTO vie1934_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Không ai nên lên theo cùng ngươi hết, khắp núi không nên thấy có người, và chiên, bò cũng chẳng nên ăn cỏ nơi núi nầy nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Môi-se bèn đục hai bảng đá, y như hai bảng trước; dậy sớm, cầm theo tay hai bảng đó lên trên núi Si-na-i, y như lời Đức Giê-hô-va đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Đức Giê-hô-va ngự xuống trong đám mây, đứng gần bên Môi-se và hô danh Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ngài đi ngang qua mặt người, hô rằng: Giê-hô-va! Giê-hô-va! là Đức Chúa Trời nhân từ, thương xót, chậm giận, đầy dẫy ân huệ và thành thực, ");
INSERT INTO vie1934_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ban ơn đến ngàn đời, xá điều gian ác, tội trọng, và tội lỗi; nhưng chẳng kể kẻ có tội là vô tội, và nhân tội tổ phụ phạt đến con cháu trải ba bốn đời. ");
INSERT INTO vie1934_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Môi-se lật đật cúi đầu xuống đất và thờ lạy, mà thưa rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Lạy Chúa! Nếu tôi được ơn trước mặt Chúa, xin hãy đi giữa chúng tôi, vì dân nầy là một dân cứng cổ. Xin hãy tha sự gian ác cùng tội lỗi, và nhận chúng tôi làm cơ nghiệp Chúa. ");
INSERT INTO vie1934_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Đức Giê-hô-va phán rằng: Nầy, ta lập một giao ước. Trước mặt các dân sự của ngươi, ta sẽ làm các phép lạ chưa hề có làm trên cả mặt đất, hay là nơi dân nào; và toàn dân sự mà trong đó có ngươi, sẽ xem thấy việc Đức Giê-hô-va, vì điều ta sẽ làm cùng ngươi là một điều đáng kinh khiếp. ");
INSERT INTO vie1934_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hãy cẩn thận về điều ta truyền cho ngươi hôm nay. Nầy, ta sẽ đuổi khỏi trước mặt ngươi dân A-mô-rít, dân Ca-na-an, dân Hê-tít, dân Phê-rê-sít, dân Hê-vít, và dân Giê-bu-sít. ");
INSERT INTO vie1934_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Hãy cẩn thận đừng lập giao ước cùng dân của xứ mà ngươi sẽ vào, e chúng nó sẽ thành cái bẫy giữa ngươi chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nhưng các ngươi hãy phá hủy bàn thờ, đập bể pho tượng và đánh hạ các thần chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Vì ngươi đừng sấp mình xuống trước mặt Chúa nào khác, bởi Đức Giê-hô-va tự xưng là Đức Chúa Trời kỵ tà; Ngài thật là một Đức Chúa Trời kỵ tà vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Hãy cẩn thận đừng lập giao ước cùng dân của xứ đó, e khi chúng nó hành dâm cùng các tà thần chúng nó và tế các tà thần của chúng nó, có kẻ mời, rồi ngươi ăn của cúng họ chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Lại đừng cưới con gái chúng nó cho con trai ngươi, e khi con gái chúng nó hành dâm với các tà thần chúng nó, quyến dụ con trai ngươi cũng hành dâm cùng các tà thần của chúng nó nữa chăng. ");
INSERT INTO vie1934_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ngươi chớ đúc thần tượng. ");
INSERT INTO vie1934_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ngươi hãy giữ lễ bánh không men. Nhằm k” tháng lúa trỗ, hãy ăn bánh không men trong bảy ngày, như ta đã truyền dặn ngươi; vì nhằm tháng đó ngươi ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Các con trưởng nam đều thuộc về ta; cùng các con đực đầu lòng của bầy súc vật ngươi, hoặc bò hoặc chiên cũng vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Nhưng ngươi sẽ bắt một chiên con hay là dê con mà chuộc một con lừa đầu lòng. Nếu chẳng chuộc nó, ngươi hãy bẻ cổ nó. Ngươi sẽ chuộc các con trưởng nam mình; và chớ ai đi tay không đến chầu trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Trong sáu ngày ngươi hãy làm công việc, nhưng qua ngày thứ bảy hãy nghỉ, dẫu mùa cày hay mùa gặt ngươi cũng phải nghỉ vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Đầu mùa gặt lúa mì, ngươi hãy giữ lễ của các tuần lễ; và cuối năm giữ lễ mùa màng. ");
INSERT INTO vie1934_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Thường năm ba lần, trong vòng các ngươi, mỗi người nam sẽ ra mắt Chúa Giê-hô-va, là Đức Chúa Trời của Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Vì ta sẽ đuổi các dân khỏi trước mặt ngươi, ta sẽ mở rộng bờ cõi ngươi; và trong khi ngươi lên ra mắt Giê-hô-va Đức Chúa Trời ngươi, mỗi năm ba lần, thì sẽ chẳng ai tham muốn xứ ngươi hết. ");
INSERT INTO vie1934_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ngươi chớ dâng huyết của con sinh tế ta cùng bánh pha men; thịt của con sinh về lễ Vượt-qua chớ nên giữ đến sáng mai. ");
INSERT INTO vie1934_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ngươi sẽ đem dâng hoa quả đầu mùa của đất sanh sản vào đền Giê-hô-va, là Đức Chúa Trời ngươi. Ngươi chớ nấu thịt dê con trong sữa mẹ nó. ");
INSERT INTO vie1934_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Đức Giê-hô-va cũng phán cùng Môi-se rằng: Hãy chép các lời nầy; vì theo các lời nầy mà ta lập giao ước cùng ngươi và cùng Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Môi-se ở đó cùng Đức Giê-hô-va trong bốn mươi ngày và bốn mươi đêm, không ăn bánh, cũng không uống nước; Đức Giê-hô-va chép trên hai bảng đá các lời giao ước, tức là mười điều răn. ");
INSERT INTO vie1934_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Khi Môi-se tay cầm hai bảng chứng đi xuống núi Si-na-i, chẳng biết rằng da mặt mình sáng rực bởi vì mình hầu chuyện Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Nhưng A-rôn cùng cả dân Y-sơ-ra-ên nhìn Môi-se thấy mặt người sáng rực, sợ không dám lại gần. ");
INSERT INTO vie1934_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Môi-se bèn gọi họ, A-rôn cùng các hội trưởng đến gần; rồi nói chuyện cùng họ. ");
INSERT INTO vie1934_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Kế sau, cả dân Y-sơ-ra-ên đến gần, người truyền dặn các điều của Đức Giê-hô-va đã phán dặn mình nơi núi Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Môi-se thôi nói chuyện cùng họ, liền lấy lúp che mặt mình lại. ");
INSERT INTO vie1934_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Khi Môi-se vào trước mặt Đức Giê-hô-va đặng hầu chuyện Ngài, thì dở lúp lên cho đến chừng nào lui ra; đoạn ra nói lại cùng dân Y-sơ-ra-ên mọi lời Ngài đã phán dặn mình. ");
INSERT INTO vie1934_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Dân Y-sơ-ra-ên nhìn mặt Môi-se thấy da mặt người sáng rực, thì Môi-se lấy lúp che mặt mình cho đến khi nào vào hầu chuyện Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Môi-se nhóm hết hội chúng Y-sơ-ra-ên lại mà nói rằng: Đây là các việc của Đức Giê-hô-va đã phán dạy làm: ");
INSERT INTO vie1934_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Người ta sẽ làm công việc trong sáu ngày, nhưng đến ngày thứ bảy sẽ là một lễ thánh, tức là ngày sa-bát biệt riêng ra thánh cho Đức Giê-hô-va. Ai làm công việc trong ngày đó sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Nhằm ngày sa-bát chớ nổi lửa trong nhà nào của các ngươi hết. ");
INSERT INTO vie1934_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Môi-se nói cùng cả hội chúng Y-sơ-ra-ên rằng: Đây là các lời Đức Giê-hô-va đã phán dặn: ");
INSERT INTO vie1934_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Hãy lấy một lễ vật chi ở nhà các ngươi mà dâng cho Đức Giê-hô-va. Hễ người nào có lòng thành dâng cho, hãy đem lễ vật cho Đức Giê-hô-va: vàng, bạc và đồng; ");
INSERT INTO vie1934_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","chỉ tím, đỏ điều, đỏ sặm, vải gai mịn, lông dê, ");
INSERT INTO vie1934_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","da chiên đực nhuộm đỏ, da cá nược, cây si-tim, ");
INSERT INTO vie1934_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","dầu thắp, các thứ hương liệu đặng chế dầu xức và hương thơm, ");
INSERT INTO vie1934_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","bích ngọc, và các thứ ngọc khác để dùng khảm cho ê-phót và bảng đeo ngực. ");
INSERT INTO vie1934_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Trong vòng các ngươi mấy người khôn ngoan hơn hết hãy đến làm mọi điều Đức Giê-hô-va đã phán dặn; ");
INSERT INTO vie1934_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","đền tạm, trại và bong của đền tạm, móc, ván, xà ngang, trụ và lỗ trụ; ");
INSERT INTO vie1934_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","hòm bảng chứng và đòn khiêng, nắp thi ân cùng màn che nơi chí thánh; ");
INSERT INTO vie1934_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","cái bàn và đòn khiêng, các đồ phụ tùng của bàn cùng bánh trần thiết; ");
INSERT INTO vie1934_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","chân đèn, đồ phụ tùng, các đèn và dầu thắp đèn; ");
INSERT INTO vie1934_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","bàn thờ xông hương cùng đòn khiêng; dầu xức, hương liệu, và bức màn cửa đền tạm; ");
INSERT INTO vie1934_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","bàn thờ dâng của lễ thiêu và rá đồng; đòn khiêng và các đồ phụ tùng của bàn thờ; cái thùng và chân thùng; ");
INSERT INTO vie1934_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","bố vi che hành lang, trụ, lỗ trụ, và bức màn của cửa hành lang; ");
INSERT INTO vie1934_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","các nọc của đền tạm, cùng nọc và dây của hành lang; ");
INSERT INTO vie1934_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","bộ áo lễ dùng về công việc trong nơi thánh; bộ áo thánh cho A-rôn, thầy tế lễ cả, và bộ áo cho các con trai người đặng làm chức tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Cả hội chúng Y-sơ-ra-ên bèn lui ra khỏi mặt Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Mọi người có lòng cảm động, và mọi người có lòng thành, đều đem lễ vật đến dâng cho Đức Giê-hô-va, để làm công việc hội mạc, các đồ phụ tùng và bộ áo thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Phàm người nam cùng nữ, tức mọi kẻ có lòng thành, đều đến đem những hoa tai, nhẫn, khâu, kiềng, các thứ trang sức bằng vàng và hết thảy đều dâng lễ vật bằng vàng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kẻ nào ở nhà mình có chỉ tím, đỏ điều, đỏ sặm, vải gai mịn, lông dê, da chiên đực nhuộm đỏ, và da cá nược đều đem đến. ");
INSERT INTO vie1934_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Hễ ai có chi làm lễ vật bằng bạc hay bằng đồng, đều đem dâng cho Đức Giê-hô-va, và hễ ai có cây si-tim nơi nhà mình dùng hiệp về các công việc tế lễ, đều đem đến. ");
INSERT INTO vie1934_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Phàm người đàn bà khéo thì chính tay mình kéo chỉ lấy và đem đến món chi họ đã kéo rồi, chỉ tím, đỏ điều, đỏ sặm, và chỉ gai mịn. ");
INSERT INTO vie1934_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Còn mấy người đàn bà có cảm động và tài khéo thì kéo chỉ lông dê. ");
INSERT INTO vie1934_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Các bực tôn trưởng trong dân sự đem bích ngọc và các thứ ngọc khác để khảm cho ê-phót và bảng đeo ngực; ");
INSERT INTO vie1934_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","dầu thắp đèn, các hương liệu để chế dầu xức và dầu thơm. ");
INSERT INTO vie1934_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Cả dân Y-sơ-ra-ên, nam hay nữ, phàm ai có lòng cảm động xui cho mình tình nguyện quyên vào các công việc Đức Giê-hô-va đã phán dặn nơi Môi-se, đều đem dâng cho Đức Giê-hô-va các lễ tình nguyện vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Môi-se nói cùng dân Y-sơ-ra-ên rằng: Nầy Đức Giê-hô-va đã kêu danh Bết-sa-lê-ên, con trai của U-ri, cháu của Hu-rơ, trong chi phái Giu-đa. ");
INSERT INTO vie1934_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ngài phú cho người đầy dẫy Thần của Đức Chúa Trời, sự khôn ngoan, sự thông sáng, và sự hiểu biết, để làm mọi thứ nghề thợ, ");
INSERT INTO vie1934_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","đặng bày ra và làm đồ vàng, bạc và đồng, ");
INSERT INTO vie1934_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","đặng khắc và khảm các thứ ngọc, đặng chạm cây làm các đồ khéo léo. ");
INSERT INTO vie1934_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ngài lại phú cho người tài dạy dỗ, và cũng đồng ban cho Ô-hô-li-áp, con của A-hi-sa-mạc, trong chi phái Đan nữa; ");
INSERT INTO vie1934_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ngài phú cho hai người đó đầy sự khôn ngoan đặng làm các công nghệ về thợ thêu, thợ dệt nhiều màu, tức là màu tím, đỏ điều, đỏ sặm, và vải gai mịn; để bày ra và làm các thứ công nghệ khéo. ");
INSERT INTO vie1934_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Bết-sa-lê-ên, Ô-hô-li-áp và các người khôn khéo, tức là người Đức Giê-hô-va đã phú cho sự khôn ngoan và sự thông sáng đặng làm các công việc định dùng về việc tế lễ nơi thánh, đều làm mọi việc mà Đức Giê-hô-va đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Vậy, Môi-se bèn gọi Bết-sa-lê-ên, Ô-hô-li-áp, và các người khôn khéo mà trong lòng họ Đức Giê-hô-va phú sự thông sáng cùng các người có lòng cảm động xui mình đến gần, đặng làm công việc. ");
INSERT INTO vie1934_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Trước mặt Môi-se, họ thâu các lễ vật của dân Y-sơ-ra-ên đã đem đến, để làm các công việc định dùng và sự tế lễ nơi thánh. Nhưng mỗi buổi sớm mai, dân sự lại đem đến lễ vật tình nguyện nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Thế thì, các người khôn khéo làm mọi công việc của nơi thánh, đều tạm đình, ");
INSERT INTO vie1934_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","đến nỗi cùng Môi-se rằng: Dân sự đem đến dư bội phần đặng làm các công việc mà Đức Giê-hô-va đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Theo lịnh truyền của Môi-se, họ bèn đi rao từ trại quân rằng: Bất k” người nam hay nữ, chớ làm công việc về lễ vật của nơi thánh nữa! Vậy họ cấm dân sự không cho đem đến chi thêm nữa hết. ");
INSERT INTO vie1934_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Vì đã đủ các vật liệu đặng làm hết thảy công việc, cho đến đỗi còn dư lại nữa. ");
INSERT INTO vie1934_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Các người khôn khéo trong vòng những người làm công việc, dùng mười bức màn bằng vải gai đậu mịn, chỉ tím, đỏ điều, đỏ sặm, thêu hình chê-ru-bin cực xảo, mà dựng đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mỗi bức màn đều dài hai mươi tám thước, rộng bốn thước; các bức đều đồng cỡ nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Họ kết mỗi năm bức màn dính lại nhau; ");
INSERT INTO vie1934_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","thắt vòng bằng chỉ tím nơi triêng của bức màn thứ nhất, ở đầu bức nguyên; và cũng làm như vậy cho triêng của bức màn ở nơi chót trong bức nguyên thứ nhì. ");
INSERT INTO vie1934_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Họ thắt năm chục vòng theo triêng của bức màn ở đầu của bức nguyên thứ nhất, và năm chục vòng theo triêng bức màn ở chót của bức nguyên thứ nhì; các vòng đối nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Đoạn chế năm chục cái móc bằng vàng, móc bức nầy với bức kia, để cho đền tạm kết lại thành một. ");
INSERT INTO vie1934_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Kế đó, họ dùng lông dê kết mười một bức màn, để làm bong trên đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Bề dài mỗi bức màn ba mươi thước, bề rộng bốn thước: mười một bức màn đều đồng cỡ nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Họ kết năm bức màn riêng ra; và sáu bức màn khác riêng ra; ");
INSERT INTO vie1934_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","thắt năm chục cái vòng nơi triêng bức chót của bức nguyên thứ nhất, và năm chục vòng nơi triêng bức ở đầu của bức nguyên thứ nhì; ");
INSERT INTO vie1934_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","làm năm chục cái móc bằng đồng, móc bức bong hiệp lại thành một. ");
INSERT INTO vie1934_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Họ cũng làm cho đền tạm một tấm lá phủ bằng da chiên đực nhuộm đỏ, và một tấm lá phủ bằng da cá nược đắp lên trên. ");
INSERT INTO vie1934_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Họ dùng ván bằng cây si-tim làm vách cho đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Mỗi tấm ván mười thước về dài, một thước rưỡi bề ngang. ");
INSERT INTO vie1934_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Mỗi tấm có hai cái mộng liên nhau: cả ván đền tạm đều làm một cách. ");
INSERT INTO vie1934_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Vậy, họ làm ván cho đền tạm: hai chục tấm về phía nam; ");
INSERT INTO vie1934_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","dưới hai chục tấm làm bốn chục lỗ mộng bằng bạc: dưới mỗi tấm có hai lỗ mộng, để chịu hai cái mộng. ");
INSERT INTO vie1934_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Họ cũng làm hai chục tấm ván ở phía bắc đền tạm, ");
INSERT INTO vie1934_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","và bốn chục lỗ mộng bằng bạc; dưới mỗi tấm có hai lỗ mộng. ");
INSERT INTO vie1934_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Về phía đằng sau của đền tạm, tức là phía tây, họ làm sáu tấm ván, ");
INSERT INTO vie1934_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","và về hai góc sau thì làm hai tấm ván. ");
INSERT INTO vie1934_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Hai tấm ván góc ra khít với nhau từ dưới chí trên bởi một cái khoen ở nơi đầu; hai góc hai bên đều làm như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Thế thì, có tám tấm ván và mười sáu lỗ mộng bằng bạc, dưới mỗi tấm có hai lỗ mộng. ");
INSERT INTO vie1934_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Họ làm năm cây xà ngang bằng gỗ si-tim cặp mấy tấm ván về phía bên nầy của đền tạm, ");
INSERT INTO vie1934_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","năm cây xà ngang khác về phía bên kia, và năm cây xà ngang khác nữa về phía sau đền tạm, tức là phía tây. ");
INSERT INTO vie1934_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Họ làm cây xà ngang giữa, đặng lòn qua thân giữa các tấm ván từ đầu nầy đến đầu kia, ");
INSERT INTO vie1934_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","và bọc vàng mấy tấm ván. Họ làm các khoen của ván bằng vàng, đặng xỏ xà ngang qua, và bọc vàng các cây xà ngang. ");
INSERT INTO vie1934_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Họ lại chế một bức màn bằng chỉ tím, đỏ điều, đỏ sặm, và vải gai đậu mịn, thêu hình chê-ru-bin cực xảo, ");
INSERT INTO vie1934_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","rồi làm bốn cây trụ bằng gỗ si-tim, bọc vàng, cùng đinh bằng vàng; đúc bốn lỗ trụ bằng bạc cho mấy cây trụ đó. ");
INSERT INTO vie1934_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Họ cũng chế cho cửa vào Trại một tấm màn bằng chỉ tím, đỏ điều, đỏ sặm, và vải gai đậu mịn: ấy là một công việc thêu thùa. ");
INSERT INTO vie1934_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Họ cũng làm năm cây trụ cùng đinh, rồi bọc vàng trên đầu trụ, và các cây nuông; còn năm lỗ trụ thì bằng đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Đoạn, Bết-sa-lê-ên đóng hòm bằng cây si-tim, bề dài hai thước rưỡi, bề ngang một thước rưỡi, và bề cao một thước rưỡi. ");
INSERT INTO vie1934_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Người bọc vàng ròng bề trong và bề ngoài, cùng chạy đường viền chung quanh. ");
INSERT INTO vie1934_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Đúc bốn cái khoen vàng đặng gắn bốn góc: hai cái bên hông nầy, hai cái bên hông kia. ");
INSERT INTO vie1934_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Người cũng chuốt các đòn bằng cây si-tim, bọc vàng; ");
INSERT INTO vie1934_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","rồi xỏ đòn đó vào khoen hai bên hông, đặng khiêng hòm. ");
INSERT INTO vie1934_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Người cũng làm một cái nắp thi ân bằng vàng ròng, bề dài hai thước rưỡi, bề ngang một thước rưỡi. ");
INSERT INTO vie1934_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Làm hai tượng chê-ru-bin bằng vàng đánh giát để nơi hai đầu nắp thi ân, ");
INSERT INTO vie1934_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","một tượng ở đầu nầy và một tượng ở đầu kia, ló ra nơi hai đầu nắp. ");
INSERT INTO vie1934_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Hai chê-ru-bin sè cánh ra che trên nắp thi ân, đối diện nhau và xây mặt vào nắp thi ân. ");
INSERT INTO vie1934_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Người cũng đóng một cái bàn bằng cây si-tim; bề dài hai thước, bề ngang một thước, bề cao một thước rưỡi; ");
INSERT INTO vie1934_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","bọc bằng vàng ròng, và chạy một đường viền chung quanh. ");
INSERT INTO vie1934_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Lại cùng lên be cho tứ vi bàn cao chừng bốn ngón tay, và chạy cho be một đường viền vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Người đúc bốn cái khoen vàng tra vào bốn góc, tại nơi chân bàn. ");
INSERT INTO vie1934_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Các khoen ở gần nơi be để xỏ đòn vào, đặng khiêng bàn; ");
INSERT INTO vie1934_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","người chuốt đòn bằng cây si-tim, bọc vàng, đặng khiêng bàn. ");
INSERT INTO vie1934_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Lại cũng lấy vàng ròng mà làm các đồ dùng bày trên bàn: dĩa, chén, ly, và chậu, để dùng làm lễ quán. ");
INSERT INTO vie1934_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Người cũng làm chân đèn bằng vàng ròng; cái chân, cái thân, cái đài, cái bầu, và cái hoa đều làm ra bằng vàng đánh giát. ");
INSERT INTO vie1934_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Hai bên thân đèn có sáu nhánh nứt ra, ba nhánh ở bên nầy và ba nhánh ở bên kia. ");
INSERT INTO vie1934_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Trong sáu nhánh nứt ra trên thân chân đèn, mỗi nhánh đều có ba cái đài hình như hột hạnh nhân, cùng bầu và hoa. ");
INSERT INTO vie1934_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Trên thân chân đèn lại cũng có bốn cái đài hình như hột hạnh nhân, cùng bầu và hoa. ");
INSERT INTO vie1934_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Trong sáu nhánh từ thân chân đèn nứt ra, hễ cứ mỗi hai nhánh, thì dưới có một cái bầu. ");
INSERT INTO vie1934_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Bầu và nhánh của chân đèn đều bằng vàng ròng nguyên miếng đánh giát. ");
INSERT INTO vie1934_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Người cũng làm bảy cái thếp đèn, kéo bắt tim và đồ đựng tàn bằng vàng ròng. ");
INSERT INTO vie1934_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Người dùng một ta lâng vàng ròng, mà làm chân đèn và các đồ phụ tùng của chân đèn. ");
INSERT INTO vie1934_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Người cũng đóng một cái bàn thờ xông hương bằng cây si-tim, hình vuông, bề dài một thước, bề ngang một thước, và bề cao hai thước. Bàn thờ có bốn sừng ló ra. ");
INSERT INTO vie1934_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Người bọc vàng ròng trên mặt, bốn cạnh chung quanh và các sừng; tứ vi cũng chạy đường viền vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Dưới đường viền đó, nơi hai bên góc, người làm hai cái khoen vàng để xỏ đòn, đặng khiêng. ");
INSERT INTO vie1934_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Người chuốt đòn bằng cây si-tim và bọc vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Người cũng chế dầu thánh để xức, và hương thanh sạch bằng các hương liệu theo nghề thợ chế hương. ");
INSERT INTO vie1934_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Người cũng đóng bàn thờ về của lễ thiêu bằng cây si-tim, hình vuông, bề dài năm thước, bề ngang năm thước và bề cao ba thước. ");
INSERT INTO vie1934_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Người làm nơi bốn góc bàn thờ những sừng ló ra, bọc đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Rồi làm các đồ phụ tùng của bàn thờ bằng đồng: chảo nhỏ, vá, ảng, nỉa, và bình hương. ");
INSERT INTO vie1934_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Lại làm một tấm rá bằng lưới đồng để dưới thành bàn thờ, từ chân lên đến ngang giữa, ");
INSERT INTO vie1934_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","và đúc cái khoen cho bốn góc rá lưới đồng, đặng xỏ đòn khiêng. ");
INSERT INTO vie1934_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Đoạn, chuốt đòn khiêng bằng cây si-tim, và bọc đồng; ");
INSERT INTO vie1934_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","xỏ đòn vào khoen nơi hai bên bàn thờ, đặng khiêng bàn đi. Người đóng bàn thờ bằng ván, trống bộng. ");
INSERT INTO vie1934_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Người dùng các tấm gương của mấy người đàn bà hầu việc nơi cửa hội mạc, chế ra một cái thùng và chân thùng bằng đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Người cũng làm hành lang: về phía nam mấy bức bố vi của hành lang bằng vải gai đậu mịn, dài trăm thước; ");
INSERT INTO vie1934_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","hai chục cây trụ và hai chục lỗ trụ bằng đồng, đinh và nuông trụ bằng bạc. ");
INSERT INTO vie1934_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Về phía bắc, cũng một trăm thước bố vi, hai chục cây trụ và hai chục lỗ trụ bằng đồng, đinh và nuông trụ bằng bạc. ");
INSERT INTO vie1934_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Về phía tây, năm chục thước bố vi, mười cây trụ, và mười lỗ trụ bằng đồng, đinh và nuông trụ bằng bạc. ");
INSERT INTO vie1934_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Về phía trước, là phía đông, cũng năm chục thước: ");
INSERT INTO vie1934_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","nghĩa là bên hữu của hành lang mười lăm thước bố vi ba cây trụ và ba lỗ trụ; ");
INSERT INTO vie1934_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","bên tả của hành lang cũng mười lăm thước bố vi, ba cây trụ và ba lỗ trụ. ");
INSERT INTO vie1934_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Hết thảy bố vi của hành lang ở chung quanh đều bằng vải gai đậu mịn; ");
INSERT INTO vie1934_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","các lỗ trụ bằng đồng, đinh, nuông bằng bạc, và đầu trụ bọc bạc. Hết thảy trụ của hành lang đều nhờ có nuông bạc chắp với nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Tấm màn nơi cửa hành lang làm thêu thùa bằng chỉ tím, đỏ điều, đỏ sặm, và vải gai đậu mịn; bề dài hai chục thước, bề cao (tùy theo bề khổ của vải) năm thước, đồng cỡ với bề cao của các bố vi chung quanh hành lang. ");
INSERT INTO vie1934_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Bốn cây trụ và bốn lỗ trụ bằng đồng, đinh, đồ bọc đầu trụ, và những nuông đều bằng bạc. ");
INSERT INTO vie1934_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Các nọc của đền tạm và của hành lang chung quanh đều bằng đồng. ");
INSERT INTO vie1934_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Đây là sổ tổng cộng về đền tạm, là đền tạm chứng cớ theo lịnh truyền của Môi-se biểu người Lê-vi làm ra, nhờ Y-tha-ma, con trai của thầy tế lễ cả A-rôn, cai quản. ");
INSERT INTO vie1934_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bết-sa-lê-ên, con trai U-ri, cháu Hu-rơ, thuộc về chi phái Giu-đa, làm theo mọi điều Đức Giê-hô-va đã phán dặn Môi-se, ");
INSERT INTO vie1934_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","và kẻ giúp người là Ô-hô-li-áp, con trai A-hi-sa-mạc, thuộc về chi phái Đan, làm thợ chạm, kẻ bày vẽ, thợ thêu thùa bằng chỉ tím, đỏ điều, đỏ sặm, và bằng chỉ gai mịn. ");
INSERT INTO vie1934_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hết thảy vàng đã hiệp dùng vào các công việc nơi thánh (ấy là vàng dâng) được hai mươi chín ta lâng, bảy trăm ba chục siếc-lơ, theo siếc-lơ của nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Bạc của mấy người hội chúng có kể sổ tổng cộng được một trăm ta lâng, một ngàn bảy trăm bảy mươi lăm siếc-lơ, theo siếc-lơ của nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Hết thảy người nào có kể sổ, từ hai mươi tuổi sắp lên, nghĩa là sáu trăm ba ngàn năm trăm năm chục người, mỗi người nộp nửa siếc-lơ, theo siếc-lơ của nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Vậy, phải một trăm ta lâng bạc đặng đúc các lỗ trụ của nơi thánh, và lỗ trụ màn; một trăm ta lâng cho một trăm lỗ trụ, tức một ta lâng vào mỗi lỗ trụ. ");
INSERT INTO vie1934_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Còn một ngàn bảy trăm bảy mươi lăm siếc-lơ dư lại, thì dùng làm đinh trụ, bọc đầu trụ và lấy nuông chắp các trụ với nhau. ");
INSERT INTO vie1934_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Đồng đem dâng cộng được bảy chục ta lâng, hai ngàn bốn trăm siếc-lơ. ");
INSERT INTO vie1934_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Họ dùng đồng đó làm lỗ trụ của cửa hội mạc, bàn thờ bằng đồng, rá bằng đồng, các đồ phụ tùng của bàn thờ; ");
INSERT INTO vie1934_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","các lỗ trụ của hành lang chung quanh, các lỗ trụ của cửa hành lang, các nọc của đền tạm, và các nọc của hành lang chung quanh. ");
INSERT INTO vie1934_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Họ dùng chỉ màu tím, đỏ điều, đỏ sặm mà chế bộ áo định cho sự tế lễ trong nơi thánh, và bộ áo thánh cho A-rôn, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Vậy, họ chế ê-phót bằng kim tuyến, chỉ tím, đỏ điều, đỏ sặm, và vải gai đậu mịn. ");
INSERT INTO vie1934_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Họ căng vàng lá ra, cắt thành sợi chỉ mà xen cùng chỉ tím, đỏ điều, đỏ sặm, và chỉ gai mịn, chế thật cực xảo. ");
INSERT INTO vie1934_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Họ may hai đai vai ê-phót, đâu hai đầu dính lại. ");
INSERT INTO vie1934_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Đai để cột ê-phót, phía ngoài, làm nguyên miếng một y như công việc của ê-phót: bằng kim tuyến, chỉ tím, đỏ điều, đỏ sặm, và bằng chỉ gai đậu mịn, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Họ khảm trong khuôn vàng các bích ngọc có khắc tên các chi phái Y-sơ-ra-ên, như người ta khắc con dấu. ");
INSERT INTO vie1934_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Họ để các ngọc đó trên đai vai ê-phót đặng làm ngọc kỷ niệm về dân Y-sơ-ra-ên, y như lời Đức Giê-hô-va phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Họ cũng chế bảng đeo ngực cực xảo, như công việc ê-phót: bằng kim tuyến, chỉ tím, đỏ điều, đỏ sặm, và chỉ gai đậu mịn. ");
INSERT INTO vie1934_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bảng đeo ngực may lót, hình vuông, bề dài một em-ban, bề ngang một em-ban. ");
INSERT INTO vie1934_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Họ nhận bốn hàng ngọc: hàng thứ nhất, ngọc mã não, ngọc hồng bích, và ngọc lục bửu; ");
INSERT INTO vie1934_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","hàng thứ nhì, ngọc phỉ túy, ngọc lam bửu, và ngọc kim cương; ");
INSERT INTO vie1934_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","hàng thứ ba, ngọc hồng bửu, ngọc bạch mã não, và ngọc tử tinh; ");
INSERT INTO vie1934_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","hàng thứ tư, ngọc hu”nh bích, ngọc hồng mã não, và bích ngọc. Các ngọc nầy đều khảm vàng. ");
INSERT INTO vie1934_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Số ngọc là mười hai, tùy theo số danh của các con trai Y-sơ-ra-ên. Mỗi viên ngọc có khắc một tên trong mười hai chi phái Y-sơ-ra-ên như người ta khắc con dấu. ");
INSERT INTO vie1934_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Đoạn, trên bảng đeo ngực họ chế các sợi chuyền bằng vàng ròng, đánh lại như hình dây. ");
INSERT INTO vie1934_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Cũng làm hai cái móc và hai cái khoanh bằng vàng, để hai khoanh nơi hai góc đầu bảng đeo ngực; ");
INSERT INTO vie1934_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","cùng cột hai sợi chuyền vàng vào hai khoanh đó. ");
INSERT INTO vie1934_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Rồi chuyền hai đầu của hai sợi chuyền vào móc gài nơi đai vai ê-phót, về phía trước ngực. ");
INSERT INTO vie1934_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Cũng làm hai khoanh vàng khác để vào hai góc đầu dưới của bảng đeo ngực, về phía trong ê-phót. ");
INSERT INTO vie1934_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Lại làm hai khoanh vàng khác nữa để nơi đầu dưới của hai đai vai ê-phót, về phía trước, ở trên đai, gần chỗ giáp mối. ");
INSERT INTO vie1934_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Họ lấy một sợi dây màu tím, cột hai cái khoanh của bảng đeo ngực lại cùng hai cái khoanh ê-phót, hầu cho nó dính với đai và đừng rớt khỏi ê-phót, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Họ cũng chế áo dài của ê-phót bằng vải thường toàn màu tím. ");
INSERT INTO vie1934_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Cổ để tròng đầu vào, ở về chính giữa áo, như lỗ áo giáp, có viền chung quanh cho khỏi tét. ");
INSERT INTO vie1934_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Nơi trôn áo, thắt những trái lựu bằng chỉ xe mịn màu tím, đỏ điều, đỏ sặm; ");
INSERT INTO vie1934_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","lại làm chuông nhỏ bằng vàng ròng, gắn giữa hai trái lựu, vòng theo chung quanh trôn áo; ");
INSERT INTO vie1934_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","cứ một trái lựu, kế một cái chuông nhỏ, vòng theo chung quanh trôn áo dùng để hầu việc, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Họ cũng chế áo lá mặc trong bằng vải gai mịn, dệt thường, cho A-rôn cùng các con trai người; ");
INSERT INTO vie1934_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","luôn cái mũ, đồ trang sức của mũ, và quần lót trong, đều bằng vải gai đậu mịn; ");
INSERT INTO vie1934_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","cùng cái đai bằng vải gai đậu mịn, chỉ tím, đỏ điều, đỏ sặm, có thêu, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Họ cũng dùng vàng lá ròng chế cái thẻ thánh, khắc trên đó như người ta khắc con dấu, rằng: Thánh Cho Đức Giê-hô-va! ");
INSERT INTO vie1934_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Rồi lấy một sợi dây tím đặng cột để trên mũ, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Các công việc của đền tạm và hội mạc làm xong là như vậy. Dân Y-sơ-ra-ên làm y như mọi lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Họ đem đền tạm đến cho Môi-se: Trại và các đồ phụ tùng của Trại, nọc, ván, xà ngang, trụ và lỗ trụ; ");
INSERT INTO vie1934_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","bong da chiên đực nhuộm đỏ, bong da cá nược và cái màn; ");
INSERT INTO vie1934_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","hòm bảng chứng và đòn khiêng, cùng nắp thi ân; ");
INSERT INTO vie1934_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","bàn và đồ phụ tùng của bàn cùng bánh trần thiết; ");
INSERT INTO vie1934_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","chân đèn bằng vàng ròng, thếp đèn đã sắp sẵn, các đồ phụ tùng của chân đèn và dầu thắp, ");
INSERT INTO vie1934_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","bàn thờ bằng vàng, dầu xức, hương liệu, tấm màn của cửa Trại; ");
INSERT INTO vie1934_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","bàn thờ bằng đồng và rá đồng, đòn khiêng, các đồ phụ tùng của bàn thờ, thùng và chân thùng; ");
INSERT INTO vie1934_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","các bố vi của hành lang, trụ, lỗ trụ, màn của cửa hành lang, dây, nọc, hết thảy đồ phụ tùng về việc tế lễ của đền tạm; ");
INSERT INTO vie1934_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","bộ áo lễ đặng hầu việc trong nơi thánh, bộ áo thánh cho A-rôn, thầy tế lễ cả, và bộ áo của các con trai người để làm chức tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Dân Y-sơ-ra-ên làm mọi công việc nầy y như mạng lịnh của Đức Giê-hô-va đã truyền cho Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Môi-se xem các công việc làm, thấy họ đều làm y như lời Đức Giê-hô-va đã phán dặn; đoạn Môi-se chúc phước cho họ. ");
INSERT INTO vie1934_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Ngày mồng một tháng giêng, ngươi sẽ dựng đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Hãy để trong đó cái hòm bảng chứng, rồi lấy màn phủ lại. ");
INSERT INTO vie1934_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Cũng hãy đem bàn đến, chưng bày các đồ trên bàn cho có thứ tự, cùng chân đèn và thắp các đèn; ");
INSERT INTO vie1934_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","cũng hãy để bàn thờ bằng vàng dùng xông hương trước hòm bảng chứng, rồi xủ tấm màn nơi cửa đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Cũng hãy để bàn thờ về của lễ thiêu đằng trước cửa đền tạm; ");
INSERT INTO vie1934_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","và để cái thùng ở giữa khoảng hội mạc và bàn thờ; rồi đổ nước vào; ");
INSERT INTO vie1934_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","lại chừa hành lang chung quanh và xủ tấm màn nơi cửa hành lang. ");
INSERT INTO vie1934_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Đoạn, ngươi hãy lấy dầu xức mà xức đền tạm và các đồ để trong đó; biệt riêng đền tạm và các đồ phụ tùng của đền tạm ra thánh, thì sẽ làm thánh vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Cũng hãy xức dầu bàn thờ về của lễ thiêu, và các đồ phụ tùng của bàn thờ; rồi biệt riêng ra thánh, thì bàn thờ sẽ làm rất thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Cũng hãy xức dầu cho thùng và chân thùng; biệt thùng riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Đoạn, hãy dẫn A-rôn cùng các con trai người đến gần cửa hội mạc, rồi tắm họ trong nước. ");
INSERT INTO vie1934_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ngươi hãy mặc áo thánh cho A-rôn, xức dầu và biệt người riêng ra thánh; vậy người sẽ làm chức tế lễ trước mặt ta. ");
INSERT INTO vie1934_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Hãy dẫn các con trai người đến gần, rồi mặc áo lá cho họ; ");
INSERT INTO vie1934_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","xức dầu cho như ngươi đã xức cho cha họ, thì họ sẽ làm chức tế lễ trước mặt ta. Sự xức dầu sẽ phong cho họ chức tế lễ mãi mãi trải qua các đời. ");
INSERT INTO vie1934_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Môi-se làm y như mọi điều Đức Giê-hô-va đã phán dặn mình. ");
INSERT INTO vie1934_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Đến ngày mồng một tháng giêng về năm thứ hai, thì đền tạm đã dựng. ");
INSERT INTO vie1934_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Môi-se dựng đền tạm, để mấy lỗ trụ, đóng ván, thả xà ngang và dựng trụ. ");
INSERT INTO vie1934_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Người căng bong trên đền tạm, rồi trải lá phủ bong lên trên, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Đoạn, người cũng lấy bảng chứng, để trong hòm, xỏ đòn khiêng vào, để nắp thi ân lên trên hòm. ");
INSERT INTO vie1934_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Người khiêng hòm vào đền tạm và treo màn để che chỗ chí thánh, phủ hòm bảng chứng lại, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Người cũng để cái bàn trong hội mạc, về phía bắc đền tạm ở ngoài bức màn; ");
INSERT INTO vie1934_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","rồi sắp một hàng bánh ở trên, trước mặt Đức Giê-hô-va, y như lời Ngài đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Để chân đèn trong hội mạc về phía nam, đối diện cùng cái bàn. ");
INSERT INTO vie1934_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Người thắp đèn trước mặt Đức Giê-hô-va, y như lời Ngài đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Để bàn thờ bằng vàng trước bức màn trong hội mạc; ");
INSERT INTO vie1934_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","trên đó người xông hương, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Người cũng xủ màn nơi cửa đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Đoạn, người để bàn thờ về của lễ thiêu nơi cửa đền tạm, dâng trên đó của lễ thiêu và của lễ chay, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Cũng để thùng về giữa khoảng hội mạc và bàn thờ, cùng đổ nước vào đặng tắm rửa; ");
INSERT INTO vie1934_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Môi-se, A-rôn cùng các con trai của A-rôn, rửa tay và chân mình vào đó. ");
INSERT INTO vie1934_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Khi nào họ vào hội mạc và lại gần bàn thờ thì rửa mình, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Chung quanh đền tạm và bàn thờ, người cũng chừa hành lang, và xủ màn nơi cửa hành lang. Aáy, Môi-se làm xong công việc là như vậy. ");
INSERT INTO vie1934_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Aùng mây bao phủ hội mạc và sự vinh hiển của Đức Giê-hô-va đầy dẫy đền tạm, ");
INSERT INTO vie1934_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","cho đến nỗi Môi-se vào chẳng đặng, vì áng mây bao phủ ở trên và sự vinh hiển của Đức Giê-hô-va đầy dẫy đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Vả, trong các sự hành trình của dân Y-sơ-ra-ên, khi nào áng mây từ đền tạm ngự lên thì họ ra đi; ");
INSERT INTO vie1934_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","còn nếu áng mây không ngự lên thì họ cũng không đi, cho đến ngày nào áng mây ngự lên. ");
INSERT INTO vie1934_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Vì trong các sự hành trình của dân Y-sơ-ra-ên, thì áng mây của Đức Giê-hô-va ở trên đền tạm ban ngày, và có lửa ở trên đó ban đêm hiện trước mặt cả dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Đức Giê-hô-va từ trong hội mạc gọi Môi-se mà phán rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Hãy nói cùng dân Y-sơ-ra-ên rằng: Khi người nào trong vòng các ngươi dâng của lễ cho Đức Giê-hô-va, thì phải dâng súc vật, hoặc bò, hoặc chiên. ");
INSERT INTO vie1934_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Nếu lễ vật của ngươi là của lễ thiêu bằng bò, thì phải dùng con đực không tì vít, dâng lên tại cửa hội mạc, trước mặt Đức Giê-hô-va, để được Ngài đẹp lòng nhậm lấy. ");
INSERT INTO vie1934_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ngươi sẽ nhận tay mình trên đầu con sinh, nó sẽ được nhậm thế cho, hầu chuộc tội cho người. ");
INSERT INTO vie1934_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Đoạn, người sẽ giết bò tơ trước mặt Đức Giê-hô-va, rồi các con trai A-rôn, tức những thầy tế lễ, sẽ dâng huyết lên, và rưới chung quanh trên bàn thờ tại nơi cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Kế đó, lột da con sinh, và sả thịt ra từng miếng. ");
INSERT INTO vie1934_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Các con trai thầy tế lễ A-rôn sẽ châm lửa trên bàn thờ, chất củi chụm lửa; ");
INSERT INTO vie1934_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","rồi các con trai A-rôn, tức những thầy tế lễ sắp các miếng thịt, đầu và mỡ lên trên củi đã chụm lửa nơi bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Người sẽ lấy nước rửa bộ lòng và giò, rồi thầy tế lễ đem hết mọi phần xông nơi bàn thờ; ấy là của lễ thiêu, tức một của lễ dùng lữa dâng lên, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Nếu lễ vật người là của lễ thiêu bằng súc vật nhỏ, hoặc chiên hay dê, thì phải dâng một con đực không tì vít, ");
INSERT INTO vie1934_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","giết nó nơi hướng bắc của bàn thờ, trước mặt Đức Giê-hô-va; rồi các con trai A-rôn, tức những thầy tế lễ, sẽ rưới huyết chung quanh trên bàn thờ; ");
INSERT INTO vie1934_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","sả thịt từng miếng, để riêng đầu và mỡ ra; thầy tế lễ sẽ chất các phần đó trên củi đã chụm lửa nơi bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Người sẽ lấy nước rửa bộ lòng và giò; đoạn thầy tế lễ dâng và xông hết mọi phần trên bàn thờ; ấy là của lễ thiêu, tức một của lễ dùng lửa dâng lên, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Nếu lễ vật người dâng cho Đức Giê-hô-va là một của lễ thiêu bằng chim, thì phải dùng cu đất hay là bò câu con. ");
INSERT INTO vie1934_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Thầy tế lễ sẽ đem nó đến bàn thờ, vặn rứt đầu ra, rồi xông trên bàn thờ; vắt huyết chảy nơi cạnh bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Người sẽ gỡ lấy cái diều và nhổ lông, liệng gần bàn thờ, về hướng đông, là chỗ đổ tro; ");
INSERT INTO vie1934_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","đoạn xé nó ra tại nơi hai cánh, nhưng không cho rời, rồi thầy tế lễ sẽ đem xông trên bàn thờ, tại trên củi đã chụm lửa; ấy là của lễ thiêu, tức một của lễ dùng lửa dâng lên, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Khi nào ai dâng cho Đức Giê-hô-va một của lễ chay, thì lễ vật người phải bằng bột lọc có chế dầu, và để nhũ hương lên trên. ");
INSERT INTO vie1934_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Người sẽ đem đến cho các con trai A-rôn, tức những thầy tế lễ; thầy tế lễ sẽ lấy một nắm bột lọc chế dầu và hết thảy nhũ hương, đem xông làm kỷ niệm trên bàn thờ; ấy là một của lễ dùng lửa dâng lên, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Phần chi trong của lễ chay còn lại sẽ thuộc về A-rôn và các con trai người; ấy là một vật chí thánh trong các của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Khi nào ngươi dùng vật chi hấp lò làm của lễ chay, thì phải lấy bột mịn làm bánh nhỏ không men nhồi dầu, và bánh tráng không men thoa dầu. ");
INSERT INTO vie1934_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Nếu ngươi dùng vật chiên trong chảo đặng làm của lễ chay, thì phải bằng bột mịn không pha men, nhồi với dầu, ");
INSERT INTO vie1934_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","bẻ ra từ miếng và chế dầu trên. Aáy là của lễ chay. ");
INSERT INTO vie1934_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nếu ngươi dùng vật chiên trong chảo lớn đặng làm của lễ chay, thì phải bằng bột mịn với dầu. ");
INSERT INTO vie1934_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Của lễ chay đã sắm sửa như cách nầy, ngươi sẽ đem dâng cho Đức Giê-hô-va, giao cho thầy tế lễ, và ngươi sẽ đem đến bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Thầy tế lễ sẽ lấy ra phần phải dâng làm kỷ niệm, xông trên bàn thờ; ấy là một của lễ dùng lửa dâng lên, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Phần chi trong của lễ chay còn lại sẽ thuộc về A-rôn và các con trai người; ấy là một vật chí thánh trong các của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Hễ của lễ chay các ngươi dâng cho Đức Giê-hô-va, thì chớ dâng với men; vì các ngươi chớ dùng men hay mật xông với của lễ chi dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Các ngươi được dâng những vật đó cho Đức Giê-hô-va như của lễ đầu mùa; nhưng chẳng nên đốt trên bàn thờ như của lễ có mùi thơm. ");
INSERT INTO vie1934_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Phải nêm muối các của lễ chay; chớ nên dâng lên thiếu muối; vì muối là dấu hiệu về sự giao ước của Đức Chúa Trời đã lập cùng ngươi; trên các lễ vật ngươi phải dâng muối. ");
INSERT INTO vie1934_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Nếu ngươi dùng hoa quả đầu mùa đặng làm của lễ chay tế Đức Giê-hô-va, thì phải bằng gié lúa rang, hột lúa mới tán ra, ");
INSERT INTO vie1934_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","đổ dầu vào và thêm nhũ hương. Aáy là của lễ chay. ");
INSERT INTO vie1934_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Đoạn, thầy tế lễ lấy một phần hột tán ra với dầu và hết thảy nhũ hương mà xông làm kỷ niệm. Aáy là của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Phàm khi nào ai dâng của lễ thù ân bằng bò, hoặc đực hoặc cái, thì phải dâng lên trước mặt Đức Giê-hô-va, không tì vít chi. ");
INSERT INTO vie1934_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Người sẽ nhận tay mình trên đầu con sinh của mình, rồi giết nó tại cửa hội mạc; các con trai A-rôn, tức những thầy tế lễ, sẽ rảy huyết chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Do của lễ thù ân nầy, người sẽ dâng làm của lễ dùng lửa dâng cho Đức Giê-hô-va, mỡ chài và mỡ bộ lòng; ");
INSERT INTO vie1934_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","hai trái cật, mỡ trên hai trái cật nơi cạnh hông, và tấm da mỏng bọc gan, gỡ gần nơi hai trái cật. ");
INSERT INTO vie1934_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Các con trai A-rôn sẽ xông mấy món đó nơi bàn thờ trên của lễ thiêu đã chất trên củi chụm lửa rồi; ấy là một của lễ dùng lửa dâng lên, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Nếu người dâng cho Đức Giê-hô-va của lễ thù ân bằng chiên, hoặc đực hoặc cái, thì phải dâng lên không tì vít chi. ");
INSERT INTO vie1934_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Vì của lễ bằng chiên con thì phải dâng nó lên trước mặt Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","nhận tay mình trên đầu con sinh, rồi giết nó trước cửa hội mạc; các con trai A-rôn sẽ rảy huyết chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Do của lễ thù ân nầy, người phải dâng làm của lễ dùng lửa dâng cho Đức Giê-hô-va, mỡ và cái đuôi nguyên, chặt gần cuối xương sống, mỡ chài và mỡ bộ lòng; ");
INSERT INTO vie1934_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","hai trái cật, mỡ trên hai trái cật nơi cạnh hông, và tấm da mỏng bọc gan, gỡ gần nơi hai trái cật. ");
INSERT INTO vie1934_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Thầy tế lễ sẽ xông các món đó trên bàn thờ; ấy là thực vật về của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Nếu của lễ người bằng con dê cái, thì phải dâng lên trước mặt Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","nhận tay mình trên đầu con sinh, rồi giết nó trước hội mạc; các con trai A-rôn sẽ rảy huyết chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Do của lễ thù ân nầy, người phải dâng làm của lễ dùng lửa dâng cho Đức Giê-hô-va, mỡ chài và mỡ bộ lòng, ");
INSERT INTO vie1934_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","hai trái cật, mỡ trên hai trái cật nơi cạnh hông và tấm da mỏng bọc gan, gỡ gần nơi hai trái cật. ");
INSERT INTO vie1934_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Thầy tế lễ sẽ xông các món đó trên bàn thờ; ấy là thực vật về của lễ dùng lửa dâng lên có mùi thơm. Hết thảy mỡ đều thuộc về Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Aáy đó là luật lệ đời đời cho dòng dõi các ngươi, mặc dầu ở nơi nào: ngươi chẳng nên ăn mỡ hay là huyết. ");
INSERT INTO vie1934_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Hãy nói cùng dân Y-sơ-ra-ên rằng: Khi nào ai lầm lỡ mà phạm một trong các điều răn của Đức Giê-hô-va, và làm điều chẳng nên làm; ");
INSERT INTO vie1934_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","nếu là thầy tế lễ chịu xức dầu rồi mà phạm tội, và vì cớ đó gây cho dân sự phải mắc tội, thì vì tội mình đã phạm, người phải dâng cho Đức Giê-hô-va một con bò tơ không tì vít chi, đặng làm của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Người sẽ dẫn bò tơ đó đến cửa hội mạc trước mặt Đức Giê-hô-va, nhận tay mình trên đầu nó, rồi giết nó trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Thầy tế lễ chịu xức dầu rồi sẽ lấy huyết bò tơ đem vào trong hội mạc, ");
INSERT INTO vie1934_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","nhúng ngón tay mình trong huyết, rảy bảy lần trước mặt Đức Giê-hô-va, đối ngang bức màn nơi đền thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Đoạn, thầy tế lễ sẽ bôi huyết trên các sừng của bàn thờ xông hương ở trong hội mạc, trước mặt Đức Giê-hô-va, và đổ hết thảy huyết bò tơ nơi chân bàn thờ về của lễ thiêu, để trước cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Người phải gỡ những mỡ của con bò dùng làm của lễ chuộc tội, tức là mỡ chài và mỡ bộ lòng, ");
INSERT INTO vie1934_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","hai trái cật, mỡ trên hai trái cật nơi cạnh hông, tấm da mỏng bọc gan, gỡ gần nơi hai trái cật, ");
INSERT INTO vie1934_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","như gỡ các phần nầy của bò tơ dùng làm của lễ thù ân; rồi thầy tế lễ sẽ xông các món đó trên bàn thờ về của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Còn da, hết thảy thịt, đầu, giò, bộ lòng và phẩn, ");
INSERT INTO vie1934_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","tức con bò tơ nguyên, người phải đem ra khỏi trại quân đến một nơi tinh sạch, là chỗ họ đổ tro, rồi chất trên củi nơi lửa và thiêu nó đi: tức là thiêu nó tại chỗ đổ tro vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Nếu cả hội chúng Y-sơ-ra-ên vì lầm lỡ phạm một trong các điều răn của Đức Giê-hô-va, và làm điều không nên làm, mà vốn không tự biết, và vì cớ đó phải mắc tội; ");
INSERT INTO vie1934_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","nếu tội phạm ấy vừa mới lộ ra, thì hội chúng phải dâng một con bò tơ đặng làm của lễ chuộc tội, dẫn nó đến trước hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Các hội trưởng phải nhận tay mình trên đầu bò tơ, rồi giết nó trước mặt Đức Giê-hô-va; ");
INSERT INTO vie1934_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","thầy tế lễ chịu xức dầu rồi sẽ đem huyết con bò tơ vào hội mạc, ");
INSERT INTO vie1934_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","nhúng ngón tay mình trong huyết, rảy bảy lần trước mặt Đức Giê-hô-va, đối ngang bức màn. ");
INSERT INTO vie1934_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Đoạn, người sẽ bôi huyết trên các sừng của bàn thờ trong hội mạc trước mặt Đức Giê-hô-va, rồi đổ huyết hết dưới chân bàn thờ về của lễ thiêu, để trước cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Người cũng gỡ hết thảy mỡ đem xông trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Cách dâng con bò tơ nầy cũng như cách dâng con bò dùng làm lễ chuộc tội: ấy vậy, thầy tế lễ sẽ chuộc tội cho hội chúng và tội hội chúng sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Đoạn, người phải đem con bò tơ đó ra ngoài trại quân, thiêu đi như đã thiêu con bò tơ trước: ấy là của lễ chuộc tội cho hội chúng. ");
INSERT INTO vie1934_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ví bằng một quan trưởng nào, vì lầm lỡ phạm một trong các điều răn của Đức Giê-hô-va, là Đức Chúa Trời mình, mà làm điều không nên làm, và vì cớ đó mắc tội; ");
INSERT INTO vie1934_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","khi nào người ta tỏ ra cho quan trưởng đó biết tội mình đã phạm, thì người phải dẫn đến làm của lễ mình, một con dê đực không tì vít chi, ");
INSERT INTO vie1934_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","nhận tay mình trên đầu dê đực đó, rồi giết nó trước mặt Đức Giê-hô-va tại nơi giết các con sinh dùng làm của lễ thiêu: ấy là của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Thầy tế lễ sẽ nhúng ngón tay mình trong huyết của con sinh tế chuộc tội, bôi trên các sừng bàn thờ về của lễ thiêu, và đổ huyết dưới chân bàn thờ; ");
INSERT INTO vie1934_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","đoạn xông hết mỡ trên bàn thờ như cách xông mỡ về của lễ thù ân. Aáy vậy, thầy tế lễ sẽ chuộc tội cho người, và tội người sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Nếu một người nào trong dân chúng, vì lầm lỡ phạm một trong các điều răn của Đức Giê-hô-va mà làm điều không nên làm, và vì cớ đó phải mắc tội; ");
INSERT INTO vie1934_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","khi nào người ta tỏ cho người đó biết tội mình đã phạm, thì người phải vì cớ tội mình dẫn đến một con dê cái không tì vít chi, dùng làm của lễ, ");
INSERT INTO vie1934_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","nhận tay mình trên đầu con sinh tế chuộc tội, rồi giết nó trong nơi giết con sinh dùng làm của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Thầy tế lễ sẽ nhúng ngón tay mình trong huyết, bôi trên các sừng bàn thờ về của lễ thiêu, và đổ hết huyết dưới chân bàn thờ; ");
INSERT INTO vie1934_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","rồi, gỡ hết mỡ như cách gỡ mỡ về của lễ thù ân, đem xông trên bàn thờ, làm của lễ có mùi thơm dâng cho Đức Giê-hô-va. Aáy vậy, thầy tế lễ sẽ chuộc tội cho người đó, thì tội người sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Nếu của lễ chuộc tội người bằng chiên con, thì phải dâng một con cái chẳng tì vít chi, ");
INSERT INTO vie1934_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","nhận tay mình trên đầu con sinh tế chuộc tội, rồi giết nó tại nơi giết con sinh dùng làm của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Đoạn, thầy tế lễ sẽ nhúng ngón tay mình trong huyết, bôi trên các sừng bàn thờ về của lễ thiêu, và đổ hết huyết dưới chân bàn thờ; ");
INSERT INTO vie1934_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","gỡ hết mỡ như cách gỡ mỡ của chiên con dùng làm của lễ thù ân, đem xông trên bàn thờ như các của lễ dùng lửa dâng cho Đức Giê-hô-va. Aáy vậy, thầy tế lễ sẽ chuộc tội cho người đó, thì tội người sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Khi người nào làm chứng bị bắt thề rồi, và phạm tội vì không tỏ ra điều mình đã thấy hay là đã biết, thì người đó sẽ mang tội mình. ");
INSERT INTO vie1934_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Khi ai sẽ đụng đến một vật ô uế, hoặc thây của con thú nhà không tinh sạch, hoặc thây của con thú rừng không tinh sạch, hoặc thây của loài côn trùng nào không tinh sạch, mà không tự biết, thì sẽ bị ô uế và mắc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Khi ai, hoặc tự biết hay không biết, sẽ đụng đến sự ô uế nào của loài người, không cứ bị ô uế cách nào, thì cũng sẽ mắc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Khi ai nói sơ ý thề thốt làm ác hay là làm thiện, mặc dầu cách nào, trước không ngờ đến, rồi sau lại tự biết, thì ai đó sẽ mắc tội trong điều nầy hay là điều kia. ");
INSERT INTO vie1934_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Vậy, khi nào ai mắc tội về một trong các điều nầy, thì phải xưng mình phạm tội chi, ");
INSERT INTO vie1934_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","rồi vì tội mình đã phạm, dẫn đến Đức Giê-hô-va một con cái trong bầy súc vật nhỏ, hoặc chiên cái hay là dê cái, đặng làm của lễ chuộc tội; thì thầy tế lễ sẽ làm lễ chuộc tội cho người. ");
INSERT INTO vie1934_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Nếu không phương thế lo cho có một chiên cái hay là một dê cái được, thì phải vì tội mình đã phạm, đem đến cho Đức Giê-hô-va một cặp cu hay là cặp bồ câu con: một con dùng làm của lễ chuộc tội, một con dùng làm của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Người sẽ đem cặp đó đến cho thầy tế lễ; thầy tế lễ sẽ dâng trước con dùng làm của lễ chuộc tội, vặn rứt đầu gần nơi gáy cổ không gãy lìa ra; ");
INSERT INTO vie1934_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","đoạn rảy huyết của con sinh tế chuộc tội trên một phía của bàn thờ; huyết còn dư lại thì vắt dưới chân bàn thờ; ấy là một của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Còn chim kia, người phải tùy theo lệ đã định, dùng làm một của lễ thiêu. Aáy vậy, thầy tế lễ sẽ vì người đó làm lễ chuộc tội người đã phạm, thì tội người sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Nếu không phương thế lo cho có một cặp cu hay là cặp bồ câu con được, thì người vì tội mình đã phạm, phải đem một phần mười ê-pha bột lọc làm của lễ chuộc tội, không nên đổ dầu trên và cũng không nên thêm nhũ hương, vì là một của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Người sẽ đem bột đó đến thầy tế lễ; thầy tế lễ sẽ bốc một nắm làm kỷ niệm. và xông trên bàn thờ như cách xông của lễ dùng lửa dâng cho Đức Giê-hô-va: ấy là một của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Aáy vậy, thầy tế lễ sẽ vì người đó làm lễ chuộc tội người đã phạm về một trong mấy điều nầy, thì tội người sẽ được tha; bột còn dư lại sẽ thuộc về thầy tế lễ như trong cuộc của lễ chay vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Khi nào ai ở bất trung, lầm lỡ phạm đến vật thánh của Đức Giê-hô-va, thì ai đó vì sự mắc lỗi mình, phải dẫn đến Đức Giê-hô-va một con chiên đực không tì vít chi bắt ở trong bầy, đánh giá bằng siếc-lơ bạc, tùy theo siếc-lơ của đền thánh: ấy sẽ là một của lễ chuộc sự mắc lỗi. ");
INSERT INTO vie1934_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Người đó phải bồi thường và phụ thêm một phần năm giá trị của vật mình đã phạm đến nơi đền thánh, rồi giao vật đó cho thầy tế lễ. Thầy tế lễ sẽ dùng chiên con đực về của lễ chuộc sự mắc lỗi mà làm lễ chuộc tội cho người ấy, và tội người sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Khi nào ai phạm một trong các điều răn của Đức Giê-hô-va mà không tự biết, và làm điều không nên làm, thì ai đó sẽ mắc lỗi và mang lấy tội mình. ");
INSERT INTO vie1934_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Người vì sự lỗi mình phải dẫn đến thầy tế lễ một con chiên đực, không tì vít chi bắt trong bầy, tùy theo ý ngươi đánh giá; rồi thầy tế lễ sẽ làm lễ chuộc lỗi cho người đã lầm lỡ phạm tội và không tự biết, thì lỗi người sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Aáy là của lễ chuộc sự mắc lỗi: người hẳn phải mắc lỗi cùng Đức Giê-hô-va vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Khi nào ai mắc tội phạm đến Đức Giê-hô-va, hoặc nói dối cùng người lân cận mình về đồ vật gởi hay là tin mà giao cho, hoặc về một tài vật trộm cắp, hoặc giựt lấy của người lân cận mình; ");
INSERT INTO vie1934_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","hoặc nếu xí được một của mất mà nói dối về của đó, hoặc thề dối về một trong các việc người ta phạm tội được; ");
INSERT INTO vie1934_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","khi nào đã phạm và mắc lỗi như vậy, thì phải trả lại vật mình đã ăn cắp, hoặc vật đã giựt lấy, hoặc vật đã tin gởi cho, hoặc vật làm mất xí được, ");
INSERT INTO vie1934_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","hoặc về các món người đã thề dối: người phải thường nguyên lại và phụ thêm một phần năm giá trị mà giao cho chủ vật đó ngày nào mình dâng của lễ chuộc sự mắc lỗi. ");
INSERT INTO vie1934_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Tùy theo sự đánh giá của ngươi, người ấy phải bắt trong bầy một chiên đực không tì vít chi, dẫn đến thầy tế lễ mà dâng cho Đức Giê-hô-va đặng làm của lễ chuộc sự mắc lỗi mình; ");
INSERT INTO vie1934_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","thầy tế lễ sẽ làm lễ chuộc tội cho người trước mặt Đức Giê-hô-va, thì lỗi người sẽ được tha, bất luận lỗi nào người đã mắc. ");
INSERT INTO vie1934_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Hãy truyền lịnh nầy cho A-rôn cùng các con trai người: Nầy là luật về của lễ thiêu: Của lễ thiêu phải ở trên đống lửa tại bàn thờ trọn đêm cho đến sáng mai, và lửa của bàn thờ giữ cho cháy luôn. ");
INSERT INTO vie1934_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Thầy tế lễ sẽ mặc áo lá trong và quần bằng vải gai che thân mình, rồi hốt tro của lửa đã đốt của lễ thiêu trên bàn thờ, và đổ gần bên bàn thờ; ");
INSERT INTO vie1934_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","đoạn cổi áo nầy, mặc áo khác, đem tro nầy ra ngoài trại quân, đổ trong một nơi tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Lửa trên bàn thờ phải cháy luôn luôn, không nên tắt. Mỗi buổi sáng thầy tế lễ sẽ lấy củi chụm lửa thêm, sắp của lễ thiêu lên trên, và xông những mỡ về của lễ thù ân tại đó. ");
INSERT INTO vie1934_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Lửa hằng cháy luôn luôn trên bàn thờ, chẳng nên tắt. ");
INSERT INTO vie1934_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Đây là luật về của lễ chay: Các con trai A-rôn phải dâng của lễ nầy tại phía trước bàn thờ, trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Họ sẽ lấy một nắm bột lọc trong của lễ chay và dầu, cùng hết thảy nhũ hương ở trên, đem xông trên bàn thờ làm kỷ niệm về một của lễ có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Phần còn dư lại, A-rôn và các con trai người sẽ ăn không pha men, tại một nơi thánh, tức là ăn tại hành lang của hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Họ không nên nấu bột đó với men; ấy là phần ta cho họ do trong các của lễ ta, dùng lửa dâng lên; thật là một vật chí thánh như của lễ chuộc tội và của lễ chuộc sự mắc lỗi. ");
INSERT INTO vie1934_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Phàm người nam trong vòng con cái A-rôn, sẽ ăn lấy; ấy là một luật lệ đời đời cho dòng dõi các ngươi về những của lễ dùng lửa dâng cho Đức Giê-hô-va: ai đụng đến những của lễ đó sẽ nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Nầy là của lễ A-rôn và các con trai người phải dâng cho Đức Giê-hô-va trong ngày họ chịu phép xức dầu: Một phần mười ê-pha bột lọc làm của lễ chay thường thường; sáng một phân nửa, chiều một phân nửa. ");
INSERT INTO vie1934_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Của lễ đó sẽ chiên sẵn trên chảo trộn với dầu; chín rồi, ngươi phải đem đến cắt ra từ miếng sẵn dâng lên có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Con trai nào của A-rôn chịu xức dầu đặng thế cho người làm thầy tế lễ cũng phải dâng của lễ nầy. Aáy là một luật lệ đời đời trước mặt Đức Giê-hô-va: họ phải xông hết trọn của lễ nầy. ");
INSERT INTO vie1934_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Phàm của lễ chay của thầy tế lễ nào thì phải đốt hết, không nên ăn. ");
INSERT INTO vie1934_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Hãy truyền cho A-rôn và các con trai người rằng: Đây là luật về của lễ chuộc tội: Phải giết con sinh tế chuộc tội trước mặt Đức Giê-hô-va tại nơi người ta giết con sinh về của lễ thiêu; ấy là một vật chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Thầy tế lễ đứng dâng con sinh tế chuộc tội, phải ăn thịt nó trong một nơi thánh, tức là trong hành lang của hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Hễ ai đụng đến thịt con sinh sẽ nên thánh, và nếu huyết nó văng trên áo nào, thì phải giặt áo đó trong một nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Nồi đất dùng nấu thịt đó sẽ đập bể đi, nếu nồi nấu bằng đồng thì sẽ cạo và rửa nước cho sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Hễ người nam trong vòng những thầy tế lễ sẽ ăn thịt đó: ấy là một vật chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Nhưng chẳng nên ăn thịt con sinh tế chuộc tội có huyết nó đem vào hội mạc đặng làm lễ chuộc tội nơi đền thánh: hãy đốt nó đi. ");
INSERT INTO vie1934_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Đây là luật lệ về của lễ chuộc sự mắc lỗi, ấy là một vật chí thánh: ");
INSERT INTO vie1934_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Trong nơi người ta giết con sinh dùng làm của lễ thiêu, thì hãy giết con sinh tế chuộc sự mắc lỗi, rồi rưới huyết ở chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Đoạn dâng hết thảy mỡ, đuôi và mỡ chài, ");
INSERT INTO vie1934_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","hai trái cật và mỡ hai trái cật nơi cạnh hông và tấm da mỏng bọc gan, gỡ gần nơi hai trái cật. ");
INSERT INTO vie1934_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Thầy tế lễ sẽ xông hết trên bàn thờ làm của lễ dùng lửa dâng cho Đức Giê-hô-va: ấy là một của lễ chuộc sự mắc lỗi. ");
INSERT INTO vie1934_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Mọi người nam trong vòng những thầy tế lễ sẽ ăn thịt đó tại trong một nơi thánh; ấy là một vật chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Của lễ chuộc sự mắc lỗi cũng như của lễ chuộc tội, đồng một luật lệ nhau; con sinh sẽ thuộc về thầy tế lễ nào đã dùng nó làm lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Còn thầy tế lễ dâng của lễ thiêu cho ai, sẽ được miếng da của con sinh dùng làm của lễ thiêu đó. ");
INSERT INTO vie1934_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Phàm của lễ chay nào, hoặc nấu trong lò, hoặc chiên trên chảo hay là nướng trên vĩ, thì thuộc về thầy tế lễ đã đứng dâng. ");
INSERT INTO vie1934_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Phàm của lễ chay, hoặc chế dầu, hoặc khô, phải cứ một mực phân cho các con trai A-rôn. ");
INSERT INTO vie1934_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Đây là luật lệ về của lễ thù ân mà người ta phải dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Nếu ai dâng của lễ đó đặng cảm tạ, thì phải dâng chung với của lễ thù ân những bánh nhỏ không pha men, chế dầu, bánh tráng không pha men thoa dầu, bột lọc trộn làm bánh nhỏ chế dầu; ");
INSERT INTO vie1934_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","lại phải thêm bánh có pha men mà dâng với của lễ thù ân cảm tạ. ");
INSERT INTO vie1934_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Họ sẽ lấy một phần trong mỗi lễ vật làm của lễ chay giơ lên dâng cho Đức Giê-hô-va; của lễ đó sẽ thuộc về thầy tế lễ đã rưới huyết của con sinh tế thù ân. ");
INSERT INTO vie1934_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Thịt của con sinh tế cảm tạ thù ân thì phải ăn hết nội ngày đã dâng lên, không nên để sót chi lại đến sáng mai. ");
INSERT INTO vie1934_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Nếu của lễ dâng về việc thường nguyện hay là lạc ý, thì phải ăn con sinh đó nội trong ngày đã dâng lên; còn dư lại thì ăn ngày mai. ");
INSERT INTO vie1934_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nhưng phần còn dư lại đến ngày thứ ba thì phải thiêu đi. ");
INSERT INTO vie1934_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nếu ai ăn thịt của lễ thù ân trong ngày thứ ba, thì người nào dâng của lễ đó sẽ chẳng được nhậm và chẳng kể chi của lễ đó cho người nữa; ấy là một điều gớm ghê, ai ăn thịt đó sẽ mang lấy tội mình. ");
INSERT INTO vie1934_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Cũng chẳng nên ăn thịt đã đụng đến vật chi ô uế; phải thiêu đi. Còn thịt nào ăn được, ai tinh sạch mới nên ăn. ");
INSERT INTO vie1934_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ai đã bị ô uế, lại ăn thịt của lễ thù ân vẫn thuộc về Đức Giê-hô-va, thì sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Nếu ai đụng đến sự ô uế, hoặc của loài người, hoặc của loài vật hay là điều gì ghê gớm, mà lại ăn thịt của lễ thù ân vẫn thuộc về Đức Giê-hô-va, thì sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Hãy truyền cho dân Y-sơ-ra-ên rằng: Chẳng nên ăn một thứ mỡ nào của bò, chiên hay là dê. ");
INSERT INTO vie1934_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mỡ của con thú nào chết hay là bị xé sẽ được dùng về mọi việc, nhưng các ngươi không nên ăn; ");
INSERT INTO vie1934_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","vì ai ăn mỡ của những thú người ta dùng lửa dâng cho Đức Giê-hô-va, sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Trong nơi nào các ngươi ở chẳng nên ăn huyết, hoặc của loài chim hay là của loài súc vật. ");
INSERT INTO vie1934_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Phàm ai ăn một thứ huyết nào sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Đức Giê-hô-va còn phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Hãy truyền cho dân Y-sơ-ra-ên rằng: Người nào dâng của lễ thù ân cho Đức Giê-hô-va, phải đem đến cho Ngài lễ vật do trong của lễ thù ân mình. ");
INSERT INTO vie1934_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Chính tay người sẽ đem phần phải dùng lửa dâng cho Đức Giê-hô-va; tức là mỡ và cái o, cái o để đặng dùng làm của lễ đưa qua đưa lại trước mặt Đức Giê-hô-va; ");
INSERT INTO vie1934_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","rồi thầy tế lễ sẽ xông mỡ trên bàn thờ, còn cái o thì thuộc về phần A-rôn và các con trai người. ");
INSERT INTO vie1934_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Các ngươi cũng sẽ cho thầy tế lễ cái giò hữu về của lễ thù ân đặng làm của lễ giơ lên. ");
INSERT INTO vie1934_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Còn ai trong vòng các con trai A-rôn dâng huyết và mỡ của con sinh tế thù ân, thì sẽ được phần cái giò hữu. ");
INSERT INTO vie1934_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Vì trong những của lễ thù ân của dân Y-sơ-ra-ên ta lấy cái o mà họ đưa qua đưa lại trước mặt ta, và cái giò mà họ dâng giơ lên, đặng ban cho thầy tế lễ A-rôn và các con trai người, chiếu theo luật lệ đời đời mà dân Y-sơ-ra-ên phải giữ theo. ");
INSERT INTO vie1934_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aáy là phần trong những của lễ dùng lửa dâng cho Đức Giê-hô-va mà phép xức dầu sẽ truyền cho A-rôn và các con trai người trong ngày nào lập họ làm chức tế lễ trước mặt Đức Giê-hô-va; ");
INSERT INTO vie1934_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ấy là điều Đức Giê-hô-va đã phán dặn dân Y-sơ-ra-ên phải ban cho họ từ ngày họ chịu phép xức dầu. Aáy là một luật lệ đời đời trải qua các thế đại. ");
INSERT INTO vie1934_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Đó là luật về của lễ thiêu, về của lễ chay, về của lễ chuộc tội, về của lễ chuộc sự mắc lỗi, về của lễ phong chức và về của lễ thù ân, ");
INSERT INTO vie1934_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","mà Đức Giê-hô-va đã truyền cho Môi-se tại trên núi Si-na-i khi Ngài dặn biểu dân Y-sơ-ra-ên dâng của lễ mình cho Đức Giê-hô-va trong đồng vắng Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Hãy đem A-rôn cùng các con trai người, áo xống, dầu xức, con bò tơ làm của lễ chuộc tội, hai con chiên đực, và giỏ bánh không men; ");
INSERT INTO vie1934_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","rồi nhóm hiệp cả hội chúng tại cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Môi-se bèn làm y như lời Đức Giê-hô-va phán dặn, hội chúng nhóm hiệp tại nơi cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Môi-se nói cùng hội chúng rằng: Đây là các điều Đức Giê-hô-va đã phán dặn làm theo. ");
INSERT INTO vie1934_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Đoạn, Môi-se biểu A-rôn và các con trai người lại gần, rồi lấy nước rửa họ. ");
INSERT INTO vie1934_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Người mặc áo lá trong cho A-rôn, cột đai lưng, mặc áo dài, mặc ê-phót và cột đai ê-phót. ");
INSERT INTO vie1934_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Người cũng đeo bảng đeo ngực và gắn vào bảng u-rim và thu-mim, ");
INSERT INTO vie1934_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","đội cái mão lên đầu, phía trước mão buộc thẻ vàng, tức là tràng thánh, y như lời Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Kế đó, Môi-se lấy dầu xức, xức cho đền tạm và các vật ở tại đó biệt riêng ra thánh, ");
INSERT INTO vie1934_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","rảy dầu bảy lần trên bàn thờ và xức dầu cho bàn thờ cùng các đồ phụ tùng của bàn thờ, cái thùng và chân thùng, đặng biệt riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Người cũng đổ dầu xức trên đầu A-rôn, xức cho người đặng biệt riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Đoạn, Môi-se biểu các con trai A-rôn lại gần, mặc áo lá trong cho, cột đai, đội mão lên đầu, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Người biểu đem con bò tơ dùng làm của lễ chuộc tội lại gần, A-rôn và các con trai người nhận tay mình trên đầu nó. ");
INSERT INTO vie1934_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Môi-se giết nó, lấy huyết, rồi dùng ngón tay bôi huyết trên chung quanh sừng của bàn thờ, làm cho bàn thờ nên thanh sạch; đoạn đổ huyết dưới chân bàn thờ; như vậy, người biệt bàn thờ riêng ra thánh, để làm lễ chuộc tội tại đó. ");
INSERT INTO vie1934_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Người lấy hết thảy mỡ chài, tấm da mỏng bọc gan, hai trái cật với mỡ của hai trái cật, rồi đem xông trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Còn con bò, da, thịt và phẩn nó, thì người đem thiêu ở ngoài trại quân, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Người cũng biểu đem con chiên đực dùng làm của lễ thiêu lại gần, A-rôn và các con trai người nhận tay mình trên đầu nó; ");
INSERT INTO vie1934_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","rồi Môi-se giết nó và rưới huyết chung quanh trên bàn thờ; ");
INSERT INTO vie1934_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","đoạn sả thịt ra từ miếng, đem xông cái đầu, mấy miếng đó và mỡ. ");
INSERT INTO vie1934_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Người lấy nước rửa bộ lòng và giò, rồi xông trọn con chiên đực trên bàn thờ; ấy là một của lễ thiêu có mùi thơm, tức một của lễ dùng lửa dâng cho Đức Giê-hô-va, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Người cũng biểu đem con chiên đực thứ nhì lại gần, tức là con chiên đực về lễ phong chức; A-rôn và các con trai người nhận tay mình trên đầu con chiên đực đó. ");
INSERT INTO vie1934_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Môi-se giết nó, lấy huyết bôi trên trái tai hữu của A-rôn, trên ngón cái của bàn tay mặt và trên ngón cái của bàn chân mặt. ");
INSERT INTO vie1934_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Môi-se cũng biểu các con trai A-rôn đến gần, bôi huyết nơi trái tai hữu họ, trên ngón cái của bàn tay mặt và trên ngón cái của bàn chân mặt; đoạn, Môi-se rưới huyết chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Kế đó, người lấy mỡ, đuôi, hết thảy mỡ chài, tấm da mỏng bọc gan, hai trái cật với mỡ của hai trái cật và cái giò hữu; ");
INSERT INTO vie1934_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","lại lấy trong giỏ bánh không men để trước mặt Đức Giê-hô-va, một cái bánh nhỏ không men, một cái bánh nhỏ có dầu, và một cái bánh tráng, để mấy bánh đó trên những mỡ và giò hữu, ");
INSERT INTO vie1934_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","đoạn để hết thảy trong tay A-rôn và tay các con trai người; họ đưa qua đưa lại trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Môi-se lấy các món đó khỏi tay họ, đem xông nơi bàn thờ tại trên của lễ thiêu; ấy là của lễ về sự phong chức có mùi thơm, tức là của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Môi-se cũng lấy cái o của con chiên đực về lễ phong chức và đưa qua đưa lại trước mặt Đức Giê-hô-va; ấy là phần thuộc về Môi-se, y như Đức Giê-hô-va đã phán dặn người. ");
INSERT INTO vie1934_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Kế ấy, Môi-se lấy dầu xức và huyết trên bàn thờ rảy trên A-rôn và trên quần áo người, trên các con trai người và trên quần áo họ, biệt A-rôn và quần áo người, các con trai người và quần áo họ riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Đoạn, Môi-se nói cùng A-rôn và các con trai người rằng: Các ngươi hãy nấu thịt tại cửa hội mạc, và ăn tại đó với bánh ở trong giỏ về lễ phong chức, y như ta đã phán dặn rằng: A-rôn và các con trai người sẽ ăn thịt đó. ");
INSERT INTO vie1934_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Nhưng các ngươi phải thiêu thịt và bánh còn dư lại. ");
INSERT INTO vie1934_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Trong bảy ngày các ngươi không nên đi ra khỏi cửa hội mạc cho đến chừng nào những ngày phong chức mình được trọn rồi, vì việc phong chức các ngươi sẽ trải qua bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Đức Giê-hô-va đã phán dặn làm y như hôm nay người ta đã làm, để làm lễ chuộc tội cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Vậy, hãy ở trọn ngày cả đêm tại cửa hội mạc trong bảy bữa, gìn giữ mạng lịnh của Đức Giê-hô-va, hầu cho các ngươi khỏi thác, vì Ngài đã truyền dặn ta như vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","A-rôn và các con trai người làm mọi điều y như Đức Giê-hô-va cậy Môi-se truyền dặn vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Qua ngày thứ tám, Môi-se gọi A-rôn và các con trai người cùng những trưởng lão của Y-sơ-ra-ên, ");
INSERT INTO vie1934_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","rồi dạy A-rôn rằng: Hãy bắt một con bò con đực đặng làm của lễ chuộc tội, một con chiên đực làm của lễ thiêu, đều không tì vít chi, và dâng lên trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ngươi hãy nói cùng dân Y-sơ-ra-ên rằng: Các ngươi hãy bắt một con dê đực làm của lễ chuộc tội, một con bò con và một con chiên con không tì vít chi, một tuổi, đặng dùng làm của lễ thiêu, ");
INSERT INTO vie1934_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","một con bò tơ, một con chiên đực đặng dùng làm của lễ thù ân, để dâng lên trước mặt Đức Giê-hô-va, và một của lễ chay chế dầu; vì ngày nay Đức Giê-hô-va sẽ hiện ra cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Vậy, họ dẫn đến trước hội mạc những vật Môi-se đã dặn biểu; rồi cả hội chúng đến gần đứng trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Môi-se nói rằng: Đây là các điều Đức Giê-hô-va phán dặn; hãy làm đi, thì sự vinh quang của Đức Giê-hô-va sẽ hiện ra cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Đoạn, Môi-se nói cùng A-rôn rằng: Ngươi hãy đến gần bàn thờ dâng của lễ chuộc tội và của lễ thiêu của ngươi đi, để vì ngươi và vì dân sự làm lễ chuộc tội; lại cũng hãy dâng của lễ của dân sự và làm lễ chuộc tội cho họ, y như Đức Giê-hô-va đã phán dặn vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","A-rôn bèn lại gần bàn thờ, giết bò con đực dùng làm của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Các con trai người đem huyết đến; người nhúng ngón tay vào, bôi trên các sừng bàn thờ, rồi đổ huyết dưới chân bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Người lấy đem xông trên bàn thờ mỡ, hai trái cật và tấm da mỏng bọc gan của con sinh tế chuộc tội, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Còn thịt và da, người đem ra thiêu ngoài trại quân. ");
INSERT INTO vie1934_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Đoạn, người giết con sinh dùng làm của lễ thiêu. Các con trai A-rôn đem huyết đến, người rưới chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Họ cũng đem cho A-rôn thịt của lễ thiêu sả ra từ miếng và đầu, rồi người xông hết trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Đoạn, người rửa bộ lòng và các giò, đem xông trên của lễ thiêu nơi bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Người cũng dâng của lễ của dân sự; bắt con dê đực dùng làm của lễ chuộc tội cho dân sự, giết nó và dâng lên đặng chuộc tội, y như của lễ đầu tiên; ");
INSERT INTO vie1934_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","lại người cũng dâng của lễ thiêu theo luật lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Kế đó, người dâng của lễ chay, trút đầy bụm tay mình đem xông trên bàn thờ, ngoại trừ của lễ thiêu hồi ban mai. ");
INSERT INTO vie1934_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Người cũng vì dân sự giết con bò tơ và con chiên đực làm của lễ thù ân. Các con trai A-rôn đem huyết đến, và người rưới chung quanh trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Họ cũng đem đến cho người mỡ của con bò tơ và con chiên đực, đuôi, mỡ trên bộ lòng, hai trái cật, và tấm da mỏng bọc gan; ");
INSERT INTO vie1934_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","để những mỡ nầy trên o, rồi xông mỡ nơi bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Đoạn, A-rôn lấy cái o và giò hữu đưa qua đưa lại trước mặt Đức Giê-hô-va, y như Môi-se đã dặn biểu. ");
INSERT INTO vie1934_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","A-rôn giơ tay mình trên dân sự chúc phước cho; sau khi dâng của lễ chuộc tội, của lễ thiêu, và của lễ thù ân, thì người bước xuống khỏi bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Môi-se và A-rôn bèn vào hội mạc, kế lại ra chúc phước cho dân sự; sự vinh quang của Đức Giê-hô-va hiện ra cùng cả dân sự: ");
INSERT INTO vie1934_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","một ngọn lửa từ trước mặt Đức Giê-hô-va lòe ra thiêu hóa của lễ thiêu và mỡ trên bàn thờ. Cả dân sự thấy, đều cất tiếng reo mừng và sấp mặt xuống đất. ");
INSERT INTO vie1934_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Hai con trai A-rôn, Na-đáp và A-bi-hu, mỗi người đều cầm lư hương mình, để lửa vào, bỏ hương lên và dâng một thứ lửa lạ trước mặt Đức Giê-hô-va; ấy là điều Ngài không phán dặn họ. ");
INSERT INTO vie1934_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Một ngọn lửa từ trước mặt Đức Giê-hô-va lòe ra, nuốt tiêu họ và họ chết trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Môi-se bèn nói cùng A-rôn rằng: Aáy là điều Đức Giê-hô-va đã tỏ ra khi Ngài phán rằng: Ta sẽ nhờ những kẻ lại gần ta mà được tôn thánh và được vinh hiển trước mặt cả dân sự. A-rôn nín lặng. ");
INSERT INTO vie1934_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Môi-se gọi Mi-sa-ên và Eân-sa-phan, hai con trai của U-xi-ên, chú của A-rôn, mà dạy rằng: Hãy lại gần khiêng thây hai anh em các ngươi khỏi trước nơi thánh, đem ra ngoài trại quân. ");
INSERT INTO vie1934_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Vậy, họ đến gần khiêng thây còn mặc áo lá trong ra ngoài trại quân, y như lời Môi-se đã biểu. ");
INSERT INTO vie1934_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Đoạn, Môi-se nói cùng A-rôn, Ê-lê-a-sa và Y-tha-ma, hai con trai người, mà rằng: Các ngươi chớ để đầu trần và chớ xé áo mình, e khi phải chết và Đức Giê-hô-va nổi giận cùng cả hội chúng chăng; nhưng anh em các ngươi, là cả nhà Y-sơ-ra-ên, phải nên khóc vì cớ lửa thiêu hóa mà Đức Giê-hô-va nổi phừng lên. ");
INSERT INTO vie1934_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Đừng ra khỏi cửa hội mạc, e các ngươi phải chết chăng; vì dầu xức của Đức Giê-hô-va ở trên các ngươi. Họ bèn làm theo lời Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Đoạn, Đức Giê-hô-va phán cùng A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Khi nào vào hội mạc, ngươi và các con trai ngươi chớ nên uống rượu hay là uống vật chi có tánh say, e phải chết chăng: ấy là một mạng lịnh đời đời, trải các thế đại, ");
INSERT INTO vie1934_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","hầu cho các ngươi được phân biệt điều thánh và điều chẳng thánh, sự khiết và sự chẳng khiết, ");
INSERT INTO vie1934_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","và dạy dân Y-sơ-ra-ên các mạng lịnh mà Đức Giê-hô-va đã cậy Môi-se truyền dặn cho. ");
INSERT INTO vie1934_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Môi-se nói cùng A-rôn, Ê-lê-a-sa và Y-tha-ma, là hai con trai A-rôn còn lại, mà rằng: Hãy lấy của lễ chay còn dư lại về của lễ dùng lửa dâng cho Đức Giê-hô-va, và hãy ăn đi không pha men, gần bàn thờ, vì là một vật chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Phải ăn của lễ nầy tại nơi thánh, vì là phần của ngươi và của các con trai ngươi trong những của lễ dùng lửa dâng cho Đức Giê-hô-va; bởi vì đã phán dặn ta làm như vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Còn cái o dâng đưa qua đưa lại, và cái giò dâng giơ lên, ngươi, các con trai và các con gái ngươi hãy ăn tại một nơi tinh sạch, vì các điều đó đã ban cho làm phần riêng của ngươi và của các con trai ngươi, do những của lễ thù ân của dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Họ sẽ đem đến cái giò dâng giơ lên và cái o dâng đưa qua đưa lại với những mỡ định thiêu hóa, để dâng đưa qua đưa lại trước mặt Đức Giê-hô-va. Những điều đó sẽ thuộc về ngươi và các con trai ngươi chiếu theo luật lệ đời đời, y như Đức Giê-hô-va đã phán dặn vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Vả, Môi-se tìm con dê đực dùng làm của lễ chuộc tội, thấy nó đã bị thiêu, bèn nổi giận cùng Ê-lê-a-sa và Y-tha-ma, hai con trai A-rôn còn lại và nói rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Sao các ngươi không ăn thịt con sinh tế chuộc tội trong nơi thánh? Vì là một vật chí thánh mà Đức Giê-hô-va đã ban cho các ngươi, hầu gánh lấy tội của hội chúng, và làm lễ chuộc tội cho họ trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Nầy, huyết nó không có đem vào trong nơi thánh; quả đáng các ngươi ăn sinh lễ trong nơi thánh, y như lời ta đã dặn biểu. ");
INSERT INTO vie1934_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Nhưng A-rôn đáp rằng: Kìa, ngày nay họ đã dâng của lễ chuộc tội và của lễ thiêu của mình trước mặt Đức Giê-hô-va; và sau khi việc rủi nầy xảy ra, nếu lại ngày nay tôi ăn của lễ chuộc tội, há có đẹp lòng Đức Giê-hô-va chăng? ");
INSERT INTO vie1934_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Môi-se nghe lời đáp ấy, bèn nhận cho phải. ");
INSERT INTO vie1934_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Hãy nói với dân Y-sơ-ra-ên rằng: Trong các loài vật trên mặt đất, nầy là những con các ngươi được phép ăn: ");
INSERT INTO vie1934_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hễ loài vật nào có móng rẽ ra, chân chia hai và nhơi, thì các ngươi được phép ăn. ");
INSERT INTO vie1934_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nhưng chẳng nên ăn con nào chỉ nhơi không, hay là chỉ có móng rẽ không: con lạc đà, nó nhơi, nhưng không có móng rẽ; nên hãy cầm nó là loài vật không sạch; ");
INSERT INTO vie1934_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","con chuột đồng, nó nhơi, nhưng không có móng rẽ, nên hãy cầm nó là loài vật không sạch; ");
INSERT INTO vie1934_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","con thỏ rừng, nó nhơi nhưng không móng rẽ; nên hãy cầm nó là loài vật không sạch; ");
INSERT INTO vie1934_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","con heo, nó có móng rẽ, chân chia hai, nhưng không nhơi; nên hãy cầm nó là loài vật không sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Các ngươi không nên ăn thịt và cũng không nên đụng đến thây các thú đó; phải cầm là vật không sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Những loài vật ở dưới nước mà các ngươi được phép ăn, là loài vật nào, hoặc ở dưới biển, hoặc ở dưới sông, có vây và có vảy. ");
INSERT INTO vie1934_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Phàm vật nào hoặc dưới biển, hoặc dưới sông, tức các loài sanh sản trong nước, mà không có vây và chẳng có vảy, thì các ngươi không nên ăn, phải lấy làm gớm ghiếc cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Những loài nầy, khá lấy làm gớm ghiếc cho mình, chớ nên ăn thịt nó, và hãy cầm thây nó là điều gớm ghiếc. ");
INSERT INTO vie1934_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Các loài vật nào ở trong nước không có vây và chẳng có vảy, thì phải lấy làm gớm ghiếc cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Trong các loài chim, những giống các ngươi phải cầm bằng gớm ghiếc, không nên ăn, là chim ưng, chim ngạc, ó biển; ");
INSERT INTO vie1934_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","chim lão ưng và con diều, tùy theo loại chúng nó; ");
INSERT INTO vie1934_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","các thứ quạ, ");
INSERT INTO vie1934_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","chim đà điểu, chim ụt, chim thủy kê, chim bò cắc và các loại giống chúng nó; ");
INSERT INTO vie1934_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","chim mèo, chim thằng cộc, con cò quắm, ");
INSERT INTO vie1934_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","con hạc, chim thằng bè, con cồng cộc, ");
INSERT INTO vie1934_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","con cò, con diệc và các loại giống chúng nó; chim rẽ quạt và con dơi. ");
INSERT INTO vie1934_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Hễ côn trùng nào hay bay, đi bốn cẳng, thì các ngươi hãy lấy làm gớm ghiếc. ");
INSERT INTO vie1934_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Nhưng trong loại côn trùng nào hay bay và đi bốn cẳng, các ngươi được ăn con nào có cẳng đặng nhảy trên đất; ");
INSERT INTO vie1934_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","là con cào cào tùy theo loại nó, con ve tùy theo loại nó, châu chấu tùy theo loại nó, con dế tùy theo loại nó. ");
INSERT INTO vie1934_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Các loài côn trùng khác hay bay và có bốn cẳng, thì các ngươi phải lấy làm gớm ghiếc. ");
INSERT INTO vie1934_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Các ngươi sẽ vì loại đó mà bị ô uế; ai đụng đến xác chết loài đó sẽ bị ô uế cho đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ai mang xác chết loài đó phải giặt áo xống mình, và bị ô uế cho đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Các thú nào có móng rẽ ra, nhưng không có chân chia hai và không nhơi, tất phải lấy làm ô uế cho các ngươi; ai đụng đến sẽ bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Trong giống đi bốn cẳng, hễ con nào đi trên bàn cẳng, thì kể là không sạch cho các ngươi; ai đụng đến xác chết nó sẽ bị ô uế đến chiều tối; ");
INSERT INTO vie1934_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","còn ai mang xác chết nó sẽ giặt áo xống mình, và bị ô uế đến chiều tối; các loài đó là không sạch cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Trong loài đi bò trên mặt đất, nầy là những loài lấy làm không sạch cho các ngươi: con chuột nhủi, con chuột lắt, con rắn mối, tùy theo loại chúng nó; ");
INSERT INTO vie1934_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","con cắc kè, k” đà, con thạch sùng, con k” nhông và con cắc ké. ");
INSERT INTO vie1934_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Trong các loài côn trùng, những loài đó lấy làm không sạch cho các ngươi: ai đụng đến xác chết nó sẽ bị ô uế cho đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bất luận vật nào, hễ loài nầy chết rớt nhằm trên, thì đều bị ô uế, hoặc đồ bằng cây, áo xống, da, bao, tức các vật người ta thường dùng; phải ngâm đồ đó trong nước, sẽ bị ô uế cho đến chiều tối, rồi mới tinh sạch lại. ");
INSERT INTO vie1934_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Nếu vật chi của nó rớt nhằm đồ sành, các vật chi đựng ở trong đều sẽ bị ô uế; phải đập bể đồ sành đó đi. ");
INSERT INTO vie1934_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Phàm đồ ăn nào và các vật uống, mặc dầu để trong đồ sành nào mà bị nước đồ sành đó nhểu vào, sẽ lây ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Phàm vật nào bị một vài miếng xác chết nó rớt nhằm, sẽ lây ô uế; dầu lò, dầu bếp, cũng phải phá tan; nó đã bị ô uế; các ngươi phải cầm nó là ô uế vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Còn một cái suối, hoặc một hồ chứa nhiều nước, đều cứ được kể tinh sạch; nhưng hễ ai đụng đến xác chết nó thì sẽ lây ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Nếu vật chi của xác chết nó rớt nhằm trên hột giống nào người ta gieo, thì hột giống đó cứ kể tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Nhưng nếu người ta có đổ nước trên hột giống đó và nếu vật gì của xác chết rớt nhằm, thì hột giống đó sẽ bị ô uế cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Khi một con thú nào các ngươi được dùng làm thực vật chết đi, hễ ai đụng đến xác nó sẽ bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kẻ nào ăn thịt của xác nó phải giặt áo xống mình, và bị lây ô uế cho đến chiều tối; còn ai khiêng xác nó sẽ giặt áo xống, và bị ô uế cho đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Phàm loài côn trùng nào bò trên mặt đất đều là sự gớm ghiếc, không nên ăn thịt nó. ");
INSERT INTO vie1934_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Vậy, không nên ăn thịt các loài côn trùng đi bò trên mặt đất, là con nào bò bằng bụng, con nào đi bốn cẳng hay là đi nhiều cẳng, vì chúng nó là một sự gớm ghiếc. ");
INSERT INTO vie1934_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Các ngươi chớ vì một con nào trong loài côn trùng mà lây cho thân mình phải gớm ghiếc, không tinh sạch hay là ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Vì ta là Giê-hô-va Đức Chúa Trời của các ngươi; ta là thánh, nên các ngươi phải nên thánh, thì sẽ được thánh. Các ngươi chớ vì một con nào của loài côn trùng trên mặt đất mà làm lây ô uế cho thân mình. ");
INSERT INTO vie1934_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Vì ta là Đức Giê-hô-va, Đấng đã đem các ngươi ra khỏi xứ Ê-díp-tô đặng làm Đức Chúa Trời của các ngươi; các ngươi phải nên thánh, vì ta là thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Đó là luật lệ về loài súc vật, loài chim trời, các sinh vật động dưới nước và các loài côn trùng trên mặt đất, ");
INSERT INTO vie1934_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","để phân biệt con không sạch với con tinh sạch, con thú ăn được cùng con thú không ăn được. ");
INSERT INTO vie1934_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Hãy nói cùng dân Y-sơ-ra-ên rằng: Khi nào một người đàn bà thọ thai và sanh một con trai, thì phải bị ô uế trong bảy ngày, như trong k” kinh nguyệt. ");
INSERT INTO vie1934_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Qua ngày thứ tám, người ta phải làm phép cắt bì cho đứa trẻ. ");
INSERT INTO vie1934_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Đoạn, người đàn bà phải kiêng trong ba mươi ba ngày đương khi huyết mình được sạch, không nên đụng một vật thánh nào hay là đi tới nơi thánh cho đến k” làm thanh sạch được trọn rồi. ");
INSERT INTO vie1934_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Còn nếu người sanh con gái, thì sẽ bị ô uế trong hai tuần, như trong k” kinh nguyệt; phải kiêng trong sáu mươi sáu ngày hầu cho huyết mình được sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Khi k” làm mình cho thanh sạch về đứa trai hay gái đã trọn rồi, người đàn bà phải dâng cho thầy tế lễ tại cửa hội mạc một chiên con một tuổi, đặng làm của lễ thiêu, và một bò câu con hoặc một cu con đặng làm của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Thầy tế lễ sẽ dâng con sinh đó trước mặt Đức Giê-hô-va, làm lễ chuộc tội cho người; sự lưu huyết người sẽ được sạch. Đó là luật lệ về người đàn bà sanh con trai hay là con gái. ");
INSERT INTO vie1934_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Còn nếu người không thế lo cho có một chiên con, thì phải bắt hai chim cu, hoặc hai con bò câu con, con nầy dùng làm của lễ thiêu, con kia dùng làm của lễ chuộc tội; thầy tế lễ sẽ làm lễ chuộc tội cho người, và người sẽ được sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Đức Giê-hô-va lại phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Khi một người nào da trên mình nổi sưng, mụt lở, hoặc một đốm trắng, dường sẽ trở thành trên da mình một vít phung, thì người ta phải dẫn người đó đến thầy tế lễ A-rôn, hay là đến một trong các con trai người là những thầy tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Thầy tế lễ sẽ khám vít ở trên da thân người; nếu lông vít đó đã trở thành trắng, và nếu vít hủng xuống sâu hơn da thân mình, ấy là một vít phung: thầy tế lễ khám rồi sẽ định người nầy là ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Còn nếu có một đốm trắng trên da thân người, đốm không lõm xuống sâu hơn da, và nếu lông không trở thành trắng, thì thầy tế lễ phải giam người đó trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Qua ngày thứ bảy, thầy tế lễ sẽ khám người, nếu vít đó ngừng lại, không ăn lan trên da, thì phải giam người một lần thứ nhì bảy ngày nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Qua ngày thứ bảy, thầy tế lễ sẽ khám người lại; nếu vít đó đã tái, không ăn lan trên da, thì thầy tế lễ sẽ định người đó là tinh sạch; ấy là mụt lở mà thôi. Người đó phải giặt áo xống mình, thì sẽ được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Nhưng nếu sau khi người đã đến trước mặt thầy tế lễ để được định là tinh sạch, mụt lở còn phát lại trên da, thì người phải đến thầy tế lễ một lần thứ nhì. ");
INSERT INTO vie1934_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Thầy tế lễ sẽ khám cho, nếu mụt lở đã ăn lan trên da thì phải định người là ô uế; ấy là bịnh phung vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Khi có một vít phung trên người nào, thì phải dẫn người đó đi tỏ mình cùng thầy tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Thầy tế lễ khám cho; nếu có nổi sưng sắc trắng trên da làm cho lông trở thành trắng, và có một lằn thịt chín đỏ nơi chỗ sưng đó, ");
INSERT INTO vie1934_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ấy là bịnh phung thâm niên trong da của thân người, thầy tế lễ sẽ định người là ô uế, không nên giam họ, vì đã bị ô uế rồi. ");
INSERT INTO vie1934_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Còn nếu phung lở trên da, bao phủ hết da của người có vít đó, từ đầu chí chân, khắp nơi nào thầy tế lễ dòm thấy được, ");
INSERT INTO vie1934_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","thì thầy tế lễ phải khám cho; nếu phung bao phủ cùng hết thịt, thì sẽ định người có vít là tinh sạch; người đã hóa trắng cùng mình, nên được tinh sạch vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Nhưng ngày nào phát ra thịt chín đỏ, thì người bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Khi thầy tế lễ thấy thịt chín đỏ thì phải định người là ô uế; thịt chín đỏ là ô uế; ấy là bịnh phung vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Nhưng nếu thịt chín đỏ thay đi, hóa ra trắng, thì người phải đi tỏ mình cùng thầy tế lễ; ");
INSERT INTO vie1934_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","thầy tế lễ khám cho, và nếu vít đã trở thành trắng, thì phải định người có vít là tinh sạch, vì đã được tinh sạch rồi. ");
INSERT INTO vie1934_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Khi một người nào trên da thân mình có mụt chốc đã chữa lành, ");
INSERT INTO vie1934_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","và tại chỗ mụt chốc có nổi sưng sắc trắng hay là một đốm trắng hồng, thì người đó phải đi tỏ mình cùng thầy tế lễ; ");
INSERT INTO vie1934_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","thầy tế lễ khám cho; nếu cái đốm hủng sâu hơn da, và nếu lông trở thành trắng, thì thầy tế lễ phải định người là ô uế; ấy là một vít phung đã lở trong mụt chốc vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Còn nếu thầy tế lễ khám, không thấy lông trắng trong chỗ đốm, không hủng sâu hơn da, và thấy đã trở thành tái, thì hãy giam người đó trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Nếu đốm ăn lan trên da thì thầy tế lễ phải định người là ô uế; ấy là một vít phung vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Còn nếu vít cầm cự một chỗ, không ăn lan ra, ấy là thẹo của mụt chốc; thầy tế lễ phải định người là tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Khi người nào bị phỏng lửa trên da, và dấu phỏng là một đốm trắng hồng hay là trắng, ");
INSERT INTO vie1934_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","thì thầy tế lễ khám cho; nếu trong đốm lông trở thành trắng, và nếu đốm hủng sâu hơn da, ấy là bịnh phung lở trong mụt phỏng vậy. Thầy tế lễ phải định người nầy là ô uế; ấy là một vít phung. ");
INSERT INTO vie1934_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Còn nếu thầy tế lễ khám, không thấy lông trắng trong đốm, không hủng sâu hơn da, và thấy đã tái rồi, thì hãy giam người nầy trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Qua ngày thứ bảy thầy tế lễ khám người, nếu đốm ăn lan trên da, thì phải định người là ô uế; ấy là vít phung. ");
INSERT INTO vie1934_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Còn nếu đốm cầm cự một chỗ, không ăn lan trên da và tái đi, ấy là sưng phỏng. Thầy tế lễ phải định người là tinh sạch, vì là thẹo phỏng lửa. ");
INSERT INTO vie1934_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Khi nào một người nam hay nữ có vít trên đầu, hoặc nơi râu, ");
INSERT INTO vie1934_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","thì thầy tế lễ khám vít đó. Nếu vít hủng sâu hơn da, có lông nhỏ vàng vàng, thì thầy tế lễ phải định người ra ô uế; ấy là tật đòng đanh, tức là bịnh phung của đầu hay là của râu. ");
INSERT INTO vie1934_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Còn nếu khi thầy tế lễ khám vít đòng đanh, thấy vít không hủng sâu hơn da, và không thấy có lông đen, thì phải giam người có vít đòng đanh trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Qua ngày thứ bảy thầy tế lễ khám vít; nếu đòng đanh không ăn lan ra, không có lông vàng vàng, và không hủng sâu hơn da, ");
INSERT INTO vie1934_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","thì người đó phải cạo gọt, nhưng không nên cạo gọt chỗ vít đòng đanh, rồi thầy tế lễ sẽ giam người một lần thứ nhì bảy ngày nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Đoạn ngày thứ bảy, thầy tế lễ khám cho; nếu đòng đanh không ăn lan trên da, không hủng sâu hơn da, thì thầy tế lễ phải định người là tinh sạch; kẻ bịnh phải giặt áo xống mình, thì sẽ được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Nhưng nếu sau khi người đã được định là tinh sạch, đòng đanh lại còn ăn lan trên da, thì thầy tế lễ phải khám cho. ");
INSERT INTO vie1934_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Nếu đòng đanh đã ăn lan trên da rồi, thầy tế lễ không cần tìm thấy lông vàng vàng, người đã bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Nhưng nếu đòng đanh xem bộ ngừng lại, và đã lố mọc lông đen, đòng đanh đã lành: người đã được tinh sạch, và thầy tế lễ phải định người là tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Khi nào người nam hay nữ trên da thân mình có những đốm trắng, ");
INSERT INTO vie1934_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","thầy tế lễ sẽ khám cho. Nếu trên da thân người có những đốm trắng xanh, ấy là một đốm trắng lở trên da mà thôi: người vẫn tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Khi một người nào đầu rụng tóc, ấy là một người sói đầu: người vẫn tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Nếu đầu người rụng tóc về phía mặt, ấy là một người sói trán: người vẫn tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Còn nếu trong chỗ sói phía trước hay là phía sau có một vít trắng hồng, ấy là bịnh phung lở ra ở chỗ sói phía trước hay là phía sau. ");
INSERT INTO vie1934_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Thầy tế lễ phải khám cho; nếu nơi sưng của vít trong chỗ sói phía trước hay là phía sau có màu trắng hồng, giống như bịnh phung tại da của thân người, ");
INSERT INTO vie1934_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","thì người nầy bị phung, thầy tế lễ sẽ định người là ô uế; vít người ở nơi đầu. ");
INSERT INTO vie1934_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Vả, người đã bị vít phung rồi phải xé quần áo, đầu trần, che râu lại la rằng: Ô-uế! Ô-uế! ");
INSERT INTO vie1934_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Trọn lúc nào người có vít, thì sẽ bị ô uế, phải ở một mình ngoài trại quân. ");
INSERT INTO vie1934_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Khi nào lên mốc trên quần áo, như vít phung, bất luận trên quần áo bằng lông chiên hay quần áo bằng vải gai, ");
INSERT INTO vie1934_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","trên canh hay trên chỉ bằng gai, hoặc bằng lông chiên, trên da hay là trên món nào bằng da; ");
INSERT INTO vie1934_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","nếu vít đó màu xanh xanh hay đỏ đỏ, trên quần áo hoặc trên da, trên canh hoặc trên chỉ hay là trên món nào bằng da, thì phải coi như bịnh phung, đem đến tỏ cho thầy tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Thầy tế lễ sẽ khám cho, và giam món có vít ấy trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Qua ngày thứ bảy, thầy tế lễ khám vít lại; nếu vít ăn lan trên quần áo, trên canh hay chỉ, trên da hay trên món chi bằng da, thì phải coi như bịnh phung ăn luồn; món đó bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Vậy, người phải đốt quần áo, canh hay chỉ bằng lông chiên hoặc bằng gai, hoặc các món chi làm bằng da, ở trên nó mà đã bị vít, vì là một bịnh phung ăn ruồng: phải thiêu đi. ");
INSERT INTO vie1934_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Còn nếu thầy tế lễ khám, chẳng thấy vít đó ăn lan trên quần áo, trên canh hay trên chỉ, hoặc các món chi làm bằng da, ");
INSERT INTO vie1934_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","thì người hãy biểu họ đem giặt món có vít đó đi, rồi giam nó một lần thứ nhì trong bảy ngày nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Khi giặt rồi, thầy tế lễ sẽ khám lại, nếu vít đó không phai màu và cũng chẳng ăn lan ra, thì món đó là ô uế: ngươi hãy đem thiêu đi, vì là một thứ vít mốc ăn vào bề trái hay là bề mặt. ");
INSERT INTO vie1934_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Còn nếu sau khi giặt rồi, thầy tế lễ thấy vít đã tái, thì phải gỡ nó khỏi quần áo, da, canh hay chỉ đi. ");
INSERT INTO vie1934_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Nếu vít mốc còn ló lên lại trên quần áo, trên canh hay chỉ, hoặc trên món chi bằng da, thì phải coi như một vít phung, và thiêu món có vít đó đi. ");
INSERT INTO vie1934_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Nhưng quần áo, canh hay chỉ, hoặc món nào bằng da mà ngươi đã giặt, và vít đã lặn rồi, thì hãy đem giặt một lần thứ nhì nữa, đoạn sẽ được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Đó là luật lệ về vít ên mốc như phung trên quần áo bằng lông chiên hay bằng vải gai, trên canh hay chỉ, hoặc trên món chi bằng da, chiếu theo luật lệ đó mà phải định là tinh sạch hay là ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Nầy là luật lệ cho kẻ phung về ngày nó được sạch. Người ta sẽ dẫn người phung đến thầy tế lễ: ");
INSERT INTO vie1934_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","thầy tế lễ sẽ ra ngoài trại quân mà khám bịnh cho. Nếu vít phung của người bịnh lành rồi, ");
INSERT INTO vie1934_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","thì về phần người phải được sạch, thầy tế lễ sẽ truyền đem hai con chim vẫn sống và tinh sạch, cây hương nam, màu đỏ sặm và nhành kinh giới. ");
INSERT INTO vie1934_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Thầy tế lễ biểu cắt cổ một trong hai chim đó trong chậu sành, trên nước chảy. ");
INSERT INTO vie1934_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Đoạn, bắt lấy chim còn sống với cây hương nam, màu đỏ sặm, nhành kinh giới, đem nhúng trong huyết của chim kia đã cắt cổ trên nước chảy. ");
INSERT INTO vie1934_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Thầy tế lễ phải rảy huyết bảy lần trên người được sạch phung, và định người là tinh sạch, rồi thả con chim còn sống ra ngoài đồng. ");
INSERT INTO vie1934_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Kẻ được sạch sẽ giặt áo xống mình, cạo hết lông, tắm trong nước, rồi sẽ được tinh sạch. Kế đó người được vào trại quân, nhưng phải ở ngoài trại mình trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Qua ngày thứ bảy người sẽ cạo hết lông, tóc, râu, và lông mày mình, giặt quần áo và tắm mình trong nước, thì sẽ được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Qua ngày thứ tám, người bắt hai chiên con đực không tì vít chi, một chiên con cái chưa giáp năm, không tì vít chi, ba phần mười ê-pha bột lọc, chế dầu, làm của lễ chay, và một lót dầu; ");
INSERT INTO vie1934_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","thầy tế lễ làm lễ nên thanh sạch sẽ đem người đang được sạch và các vật đó đến trước mặt Đức Giê-hô-va tại cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kế đó, thầy tế lễ sẽ bắt một trong hai chiên con đực dâng làm của lễ chuộc sự mắc lỗi với một lót dầu, và đưa qua đưa lại trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Đoạn, người giết chiên con đó trong nơi thường giết các con sinh dùng làm của lễ chuộc tội và của lễ thiêu, tức là trong một nơi thánh, vì của lễ chuộc sự mắc lỗi thuộc về thầy tế lễ như của lễ chuộc tội vậy; ấy là một vật chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Thầy tế lễ sẽ lấy huyết của con sinh tế chuộc sự mắc lỗi bôi trên trái tai hữu của người được sạch, trên ngón cái tay mặt và trên ngón cái chân mặt; ");
INSERT INTO vie1934_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","đoạn lấy lót dầu đổ trong bàn tay tả mình, ");
INSERT INTO vie1934_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","nhúng ngón tay hữu vào dầu trong bàn tay tả mình, mà rảy bảy lần trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Dầu còn lại trong bàn tay mình, thầy tế lễ sẽ lấy bôi trên trái tai hữu của người được sạch, trên ngón cái tay mặt và ngón cái chân mặt, tức trên lớp huyết của lễ chuộc sự mắc lỗi. ");
INSERT INTO vie1934_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Dầu còn dư lại trong bàn tay mình, thầy tế lễ sẽ đổ trên đầu người được sạch; vậy thầy tế lễ sẽ làm lễ chuộc tội cho người trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Đoạn, thầy tế lễ sẽ dâng của lễ chuộc tội đặng làm lễ chuộc tội cho người được sạch sự ô uế mình. Kế đó, thầy tế lễ sẽ giết con sinh dùng làm của lễ thiêu, ");
INSERT INTO vie1934_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","dâng lên với của lễ chay trên bàn thờ; vậy, thầy tế lễ sẽ làm lễ chuộc tội cho người nầy, thì người nầy sẽ được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Nhưng nếu người đó nghèo nàn, không phương thế đủ dâng những lễ vật nầy, thì phải bắt một chiên con đực dùng làm của lễ chuộc sự mắc lỗi, dâng đưa qua đưa lại đặng làm lễ chuộc tội cho mình, một phần mười bột lọc chế dầu làm của lễ chay và một lót dầu. ");
INSERT INTO vie1934_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Tùy theo phương thế mình, người cũng đem nộp hai con chim cu hay là hai bò câu con; con nầy dùng làm của lễ chuộc tội, con kia dùng làm của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Qua ngày thứ tám, người phải vì sự nên thanh sạch mình, đem nộp các lễ vật nầy cho thầy tế lễ tại cửa hội mạc, trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Thầy tế lễ sẽ bắt chiên con đực định làm của lễ chuộc sự mắc lỗi, và một lót dầu, rồi dâng lên đưa qua đưa lại trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Đoạn, người giết chiên con dùng làm của lễ chuộc sự mắc lỗi, lấy huyết bôi trên trái tai hữu của kẻ được sạch, trên ngón cái tay mặt và trên ngón cái chân mặt. ");
INSERT INTO vie1934_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Rồi thầy tế lễ đổ dầu vào bàn tay tả mình, ");
INSERT INTO vie1934_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ngón tay hữu nhúng lấy dầu đổ trong bàn tay tả, rảy bảy lần trước mặt Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","và bôi trên trái tai hữu của người được sạch, trên ngón cái tay mặt và trên ngón cái chân mặt, tại nơi đã bôi huyết của lễ chuộc sự mắc lỗi. ");
INSERT INTO vie1934_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Dầu còn dư lại trong bàn tay, thầy tế lễ sẽ đổ trên đầu người được sạch, đặng làm lễ chuộc tội cho người trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Đoạn, thầy tế lễ sẽ dâng một trong hai con chim cu, hoặc một trong hai con bồ câu con, tùy theo vật họ nộp, ");
INSERT INTO vie1934_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","dâng con nầy dùng làm của lễ chuộc tội, con kia dùng làm của lễ thiêu, với của lễ chay. Vậy, thầy tế lễ sẽ làm lễ chuộc tội cho người được sạch trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Đó là luật lệ về lễ nên thanh sạch của kẻ nghèo nàn bị vít phung. ");
INSERT INTO vie1934_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Đức Giê-hô-va cũng phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Khi nào các ngươi sẽ vào xứ Ca-na-an, mà ta sẽ cho các ngươi làm sản nghiệp, nếu ta giáng một vít mốc như vít phung trong nhà nào của xứ các ngươi sẽ được làm sản nghiệp, ");
INSERT INTO vie1934_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","chủ nhà đó phải đến cáo cùng thầy tế lễ rằng: Tôi thấy như có một vít mốc trong nhà. ");
INSERT INTO vie1934_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Trước khi vào khám vít mốc đó, thầy tế lễ phải truyền họ đem đồ đạc trong nhà ra hết, hầu cho khỏi bị lây ô uế; sau dời xong, thầy tế lễ sẽ vào đặng khám nhà. ");
INSERT INTO vie1934_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Người sẽ xem vít đó, nếu nó ở nơi vách có lỗ màu xanh xanh, hoặc đỏ đỏ, bộ sâu hơn mặt vách, ");
INSERT INTO vie1934_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","thì thầy tế lễ phải đi ra đến cửa ngoài, niêm nhà lại trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ngày thứ bảy, thầy tế lễ trở lại, nếu thấy vít ăn lan ra trên vách nhà, ");
INSERT INTO vie1934_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","thì phải truyền gỡ mấy cục đá bị vít lây, liệng ra ngoài thành trong một nơi dơ dáy; ");
INSERT INTO vie1934_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","đoạn biểu người ta cạo trong nhà và chung quanh nhà, và hốt bỏ bụi cạo đó ra ngoài thành trong một nơi dơ dáy; ");
INSERT INTO vie1934_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","rồi lấy đá khác trám vào chỗ đá cũ, và đem hồ mới tô lại khắp nhà. ");
INSERT INTO vie1934_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Nhưng nếu sau khi đã gỡ mấy cục đá, cạo nhà và tô lại, vít đó trở lại lở trong nhà, ");
INSERT INTO vie1934_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","thì thầy tế lễ phải đến khám nữa. Nếu thấy vít ăn lan ra, ấy là một vít phung ăn ruồng nhà; nhà đã bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Vậy, họ phải phá nhà đi, đá, gỗ và hồ, rồi đem đổ hết thảy ngoài thành trong một nơi dơ dáy. ");
INSERT INTO vie1934_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Trong lúc niêm nhà, ai đi vào thì sẽ bị lây ô uế cho đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ai ngủ, hoặc ăn trong nhà đó phải giặt quần áo mình. ");
INSERT INTO vie1934_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Nhưng sau khi nhà đã tô rồi, nếu thầy tế lễ trở lại, khám thấy vít không ăn lan trong nhà, thì phải định nhà là tinh sạch, vì vít đó đã lành rồi. ");
INSERT INTO vie1934_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Đặng làm lễ nên thanh sạch cho nhà, người phải lấy hai con chim, cây hương nam, màu đỏ sặm và nhành kinh giới; ");
INSERT INTO vie1934_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","giết một con chim trong chậu sành, trên nước chảy, ");
INSERT INTO vie1934_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","rồi lấy cây hương nam, nhành kinh giới, màu đỏ sặm, và con chim sống, nhúng hết trong huyết con chim đã cắt cổ trên nước chảy, và rảy bảy lần trên nhà. ");
INSERT INTO vie1934_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Vậy, người dùng huyết con chim, nước chảy, con chim sống, cây hương nam, nhành kinh giới, và màu đỏ sặm đặng làm lễ khiến nhà nên thanh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Đoạn, người thả con chim sống bay ra ngoài thành đến nơi ruộng; người sẽ làm lễ chuộc tội cho nhà, thì nhà sẽ được sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Đó là luật lệ về các thứ vít phung và tật đòng đanh, ");
INSERT INTO vie1934_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","về vít mốc trên quần áo và nhà ở, như vít phung, ");
INSERT INTO vie1934_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","về chỗ sưng, chỗ lở ra và chỗ đốm, ");
INSERT INTO vie1934_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","đặng dạy cho biết khi nào ô uế, và khi nào tinh sạch. Đó là luật lệ về bịnh phung vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Đức Giê-hô-va lại phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Hãy truyền cho dân Y-sơ-ra-ên rằng: Phàm người nam nào thân mình bị bịnh bạch trược, thì vì cớ đó bị ô uế; ");
INSERT INTO vie1934_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","sự ô uế người bởi nơi bạch trược: hoặc thân mình chảy bạch trược ra hay là ứ lại, thì người bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Hễ giường nào người bịnh bạch trược nằm, đều sẽ bị ô uế: và các vật nào người ngồi trên cũng sẽ bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ai đụng đến giường người, phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ai ngồi trên vật chi mà người bịnh bạch trược đã ngồi, phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ai đụng đến mình người bịnh bạch trược, phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Nếu người bịnh bạch trược nhổ nhằm người nào tinh sạch, thì người đó phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Hễ xe nào người bịnh bạch trược ngồi lên đều sẽ bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Hễ ai đụng đến bất k” vật chi dưới mình người bịnh bạch trược, đều sẽ bị ô uế đến chiều tối. Còn ai mang các vật đó, phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ai bị người bịnh bạch trược rờ đến mà nếu người bịnh đó không rửa tay mình trong nước, thì ai đó phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Đồ sành bị người bịnh bạch trược đụng đến, phải đập bể đi, còn đồ gỗ, thì rửa trong nước. ");
INSERT INTO vie1934_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Vả, khi người nam bị bịnh bạch trược đã lành rồi, thì phải tính từ ngày lành đến bảy ngày, kế giặt quần áo mình và tắm trong nước chảy; đoạn, người sẽ được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Qua ngày thứ tám, người bắt cho mình hai chim cu, hay là hai con bò câu con, đến trước mặt Đức Giê-hô-va, tại cửa hội mạc, và đưa cho thầy tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Thầy tế lễ sẽ dâng con nầy làm của lễ chuộc tội, con kia làm của lễ thiêu; vậy, thầy tế lễ vì cớ bịnh bạch trược, sẽ làm lễ chuộc tội cho người trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Hễ người nam di tinh, phải tắm trọn mình trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Phàm quần áo và da bị dính, phải giặt rửa trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Khi nào người nam và người nữ giao cấu nhau, thì phải tắm trong nước, và bị ô uế cho đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Khi nào một người nữ có kinh nguyệt, phải chịu ô uế trong bảy ngày; hễ ai đụng đến người, sẽ bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Phàm vật gì người nằm hay ngồi trên trong lúc mình không sạch, sẽ bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ai đụng đến giường người, phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ai đụng đến vật gì người đã ngồi trên, phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Nếu có vật chi nơi giường, hoặc trên đồ người ngồi, hễ ai đụng đến, sẽ bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ví bằng một người nam giao cấu cùng người nữ đó, và sự ô uế kinh nguyệt dính người nam, thì người nam sẽ bị ô uế trong bảy ngày; phàm giường nào người nằm đều cũng sẽ bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Khi một người nữ ngoài k” kinh nguyệt mình lại có lưu huyết nhiều ngày, hoặc là bị mất quá k”, sẽ bị ô uế trọn trong lúc lưu huyết như trong lúc kinh nguyệt mình vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Trong trọn lúc lưu huyết, bất k” giường nào người nằm trên sẽ như cái giường của k” kinh nguyệt, và mọi vật nào người ngồi trên, đều sẽ bị ô uế như trong k” kinh nguyệt vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ai đụng đến các vật đó sẽ bị ô uế; phải giặt quần áo mình, tắm trong nước, và bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Khi nào huyết người nữ cầm lại rồi, phải tính từ ngày lành đến bảy ngày, đoạn sẽ được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Qua ngày thứ tám, người bắt hai con chim cu, hoặc hai con bò câu con, đem đến thầy tế lễ tại cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Thầy tế lễ phải dâng con nầy làm của lễ chuộc tội, và con kia làm của lễ thiêu; vậy, thầy tế lễ vì cớ sự lưu huyết ô uế người sẽ làm lễ chuộc tội cho người trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Thế thì, các ngươi sẽ phân cách dân Y-sơ-ra-ên ra xa sự ô uế của họ, kẻo họ làm ô uế hội mạc ta vẫn ở giữa họ, mà phải chết trong sự ô uế mình chăng. ");
INSERT INTO vie1934_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Đó là luật lệ về người nào bị bịnh bạch trược hay là vì cớ di tinh bị ô uế, ");
INSERT INTO vie1934_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","về người nữ có k” kinh nguyệt, về mọi người, hoặc nam hay nữ, bị bạch trược, và về người nam giao cấu cùng người nữ trong khi kinh nguyệt. ");
INSERT INTO vie1934_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Sau khi hai con trai của A-rôn chết trong lúc đến gần trước mặt Đức Giê-hô-va, thì Ngài phán cùng Môi-se, ");
INSERT INTO vie1934_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","mà rằng: Hãy nói cùng A-rôn, anh ngươi, chớ vào luôn luôn trong nơi thánh ở phía trong bức màn, trước nắp thi ân trên hòm bảng chứng, e người phải chết chăng; vì ta ở trong mây hiện ra trên nắp thi ân. ");
INSERT INTO vie1934_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Nầy, A-rôn sẽ vào nơi thánh như vầy: Người phải bắt một con bò đực tơ, dùng làm của lễ chuộc tội, và một con chiên đực dùng làm của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Người sẽ mặc áo lá trong thánh bằng vải gai, thân dưới mặc một cái quần bằng vải gai, thắt một đai bằng vải gai và đội trên đầu một cái mão bằng vải gai. Aáy là bộ áo thánh mà ngươi sẽ mặc lấy khi đã tắm mình trong nước. ");
INSERT INTO vie1934_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Do nơi hội chúng Y-sơ-ra-ên, người sẽ bắt hai con dê đực dùng làm của lễ chuộc tội và một con chiên đực dùng làm của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","A-rôn sẽ dâng con bò tơ mình làm của lễ chuộc tội, và người sẽ làm lễ chuộc tội cho mình và cho nhà mình. ");
INSERT INTO vie1934_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Kế đó người phải bắt hai con dê đực, đem để trước mặt Đức Giê-hô-va, tại nơi cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Đoạn, A-rôn bắt thăm cho hai con dê đực, một thăm về phần Đức Giê-hô-va, một thăm về phần A-xa-sên. ");
INSERT INTO vie1934_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","A-rôn sẽ biểu dẫn con dê đực bắt thăm về phần Đức Giê-hô-va lại gần và dâng nó làm của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Còn con bắt thăm về phần A-xa-sên, sẽ để sống trước mặt Đức Giê-hô-va, để làm lễ chuộc tội trên nó, rồi thả nó ra nơi đồng vắng đặng nó về A-xa-sên. ");
INSERT INTO vie1934_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Vậy, A-rôn sẽ dâng con bò tơ mình, là con sinh tế chuộc tội, giết nó làm lễ chuộc tội cho mình và cho nhà mình; ");
INSERT INTO vie1934_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","đoạn lấy lư hương đầy than hực đỏ trên bàn thờ trước mặt Đức Giê-hô-va, và một vốc hương bột, mà đem vào phía trong bức màn. ");
INSERT INTO vie1934_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Người phải bỏ hương trên lửa, trước mặt Đức Giê-hô-va, hầu cho ngọn khói hương bao phủ nắp thi ân ở trên hòm bảng chứng, thì người không chết. ");
INSERT INTO vie1934_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Người cũng phải lấy huyết con bò tơ đó, dùng ngón tay rảy trên nắp thi ân, về phía đông, và rảy bảy lần về phía trước nắp thi ân. ");
INSERT INTO vie1934_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Đoạn, người giết con dê đực dùng về dân chúng làm của lễ chuộc tội; đem huyết nó vào phía trong bức màn; dùng huyết con dê đực đó cũng như đã dùng huyết con bò tơ, tức là rảy trên nắp thi ân và trước nắp thi ân vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Người vì cớ sự ô uế, sự vi phạm và tội lỗi của dân Y-sơ-ra-ên phải làm lễ chuộc tội cho nơi thánh và cho hội mạc ở giữa sự ô uế của họ. ");
INSERT INTO vie1934_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Khi thầy tế lễ vào đặng làm lễ chuộc tội nơi thánh cho đến khi người ra, thì chẳng nên có ai ở tại hội mạc; vậy, người sẽ làm lễ chuộc tội cho mình, cho nhà mình, và cho cả hội chúng Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Đoạn, người ra, đi đến bàn thờ ở trước mặt Đức Giê-hô-va, đặng làm lễ chuộc tội cho bàn thờ; người lấy huyết con bò tơ đực và con dê đực, bôi chung quanh những sừng của bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Rồi dùng ngón tay rảy huyết bảy lần trên bàn thờ, làm cho bàn thờ nên sạch và thánh, vì cớ những sự ô uế của dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Khi thầy tế lễ đã làm lễ chuộc tội cho nơi thánh, cho hội mạc, và cho bàn thờ rồi, thì người phải dâng con dê đực còn sống kia. ");
INSERT INTO vie1934_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","A-rôn sẽ nhận hai tay mình trên đầu con dê đực còn sống, xưng trên nó các gian ác và sự vi phạm, tức những tội lỗi của dân Y-sơ-ra-ên, và chất trên đầu nó, rồi nhờ một người chực sẵn việc nầy mà sai đuổi nó ra, thả vào đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Vậy, con dê đực đó sẽ gánh trên mình các tội ác của dân Y-sơ-ra-ên ra nơi hoang địa. ");
INSERT INTO vie1934_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","A-rôn sẽ trở vào hội mạc, cổi bộ áo bằng vải gai mình đã mặc đặng vào nơi thánh, và để tại đó. ");
INSERT INTO vie1934_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Rồi lấy nước tắm mình trong một nơi thánh, mặc áo lại, đi ra, dâng của lễ thiêu về phần mình, và của lễ thiêu về phần dân chúng, đặng làm lễ chuộc tội cho mình và cho dân chúng. ");
INSERT INTO vie1934_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Người cũng phải lấy mỡ của con sinh tế chuộc tội mà xông trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Người nào dẫn con dê đực về phần A-xa-sên, phải giặt quần áo mình, tắm mình trong nước, đoạn mới sẽ được vào trại quân. ");
INSERT INTO vie1934_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Nhưng người ta phải đem ra ngoài trại quân con bò tơ đực và con dê đực đã dâng lên làm của lễ chuộc tội, mà huyết nó đã đem vào nơi thánh đặng làm lễ chuộc tội; rồi phải lấy da, thịt và phẩn của hai thú đó mà đốt trong lửa. ");
INSERT INTO vie1934_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Kẻ nào đứng đốt phải giặt quần áo mình, tắm mình trong nước, đoạn mới được vào trại quân. ");
INSERT INTO vie1934_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Điều nầy sẽ là một lệ định đời đời cho các ngươi: đến mồng mười tháng bảy, các ngươi phải ép linh hồn mình, không nên làm một việc nào, bất k” người bổn xứ hay là kẻ khách kiều ngụ giữa các ngươi; ");
INSERT INTO vie1934_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","vì trong ngày đó người ta sẽ làm lễ chuộc tội cho các ngươi, để các ngươi được tinh sạch: chắc các ngươi sẽ được sạch những tội lỗi mình trước mặt Đức Giê-hô-va vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Aáy sẽ là một lễ Sa-bát, một ngày nghỉ cho các ngươi, phải ép linh hồn mình; đó là một lệ định đời đời vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Thầy tế lễ đã được phép xức dầu và lập làm chức tế lễ thế cho cha mình, sẽ mặc lấy bộ áo vải gai, tức là bộ áo thánh, mà làm lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Người sẽ chuộc tội cho nơi thánh, cho hội mạc, cho bàn thờ, cho những thầy tế lễ, và cho cả dân của hội chúng. ");
INSERT INTO vie1934_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Mỗi năm một lần phải làm lễ chuộc tội cho dân Y-sơ-ra-ên, đặng làm cho sạch các tội lỗi của chúng; ấy sẽ một lệ định đời đời cho các ngươi vậy. A-rôn làm y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Hãy nói cùng cả dân Y-sơ-ra-ên rằng: Nầy là lời Đức Giê-hô-va phán dặn: ");
INSERT INTO vie1934_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Nếu một người nam trong nhà Y-sơ-ra-ên giết một con bò, một con chiên con, hoặc một con dê trong trại quân hay là ngoài trại quân, ");
INSERT INTO vie1934_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","chẳng đem đến cửa hội mạc đặng dâng cho Đức Giê-hô-va, trước đền tạm của Ngài, thì huyết sẽ đổ tội về người; người đã làm đổ huyết ra, nên sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Aáy hầu cho dân Y-sơ-ra-ên lấy của lễ mình giết ngoài đồng, dẫn đến thầy tế lễ, trước mặt Đức Giê-hô-va, tại cửa hội mạc, đặng dâng lên làm của lễ thù ân cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Thầy tế lễ sẽ rưới huyết con sinh trên bàn thờ của Đức Giê-hô-va để tại cửa hội mạc, và xông mỡ có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Dân Y-sơ-ra-ên cũng chẳng nên dâng của lễ mình cho ma quỉ nữa, mà thông dâm cùng nó. Điều nầy sẽ làm một lệ định đời đời cho họ trải qua các thế đại. ");
INSERT INTO vie1934_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Vậy, ngươi hãy nói cùng dân Y-sơ-ra-ên rằng: Phàm người nào trong vòng dân Y-sơ-ra-ên hay là kẻ khách kiều ngụ giữa họ, dâng một của lễ thiêu hay là một của lễ chi, ");
INSERT INTO vie1934_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","mà chẳng đem đến tại cửa hội mạc đặng dâng cho Đức Giê-hô-va, thì người đó sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Phàm người nào của nhà Y-sơ-ra-ên hay là kẻ khách kiều ngụ giữa họ, ăn huyết chi cũng mặc, thì ta sẽ nổi giận cùng kẻ ăn đó, truất nó khỏi dân sự mình; ");
INSERT INTO vie1934_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","vì sanh mạng của xác thịt ở trong huyết; ta đã cho các ngươi huyết rưới trên bàn thờ đặng làm lễ chuộc tội cho linh hồn mình; vì nhờ sanh mạng mà huyết mới chuộc tội được. ");
INSERT INTO vie1934_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Bởi cớ đó ta đã phán cùng dân Y-sơ-ra-ên rằng: Trong vòng các ngươi không ai nên ăn huyết; kẻ khách kiều ngụ giữa các ngươi cũng không nên ăn huyết. ");
INSERT INTO vie1934_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Còn nếu ai, hoặc dân Y-sơ-ra-ên. hoặc kẻ khách kiều ngụ giữa họ, đi săn được một con thú hay là con chim ăn thịt được, thì phải đổ huyết nó ra, rồi lấy bụi đất lấp lại; ");
INSERT INTO vie1934_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","vì sanh mạng của mọi xác thịt, ấy là huyết nó, trong huyết có sanh mạng. Bởi cớ ấy, ta đã phán cùng dân Y-sơ-ra-ên rằng: Các ngươi không nên ăn huyết của xác thịt nào; vì sanh mạng của mọi xác thịt, ấy là huyết nó; ai ăn sẽ bị truất diệt. ");
INSERT INTO vie1934_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Hễ người nào, hoặc sanh đẻ tại xứ, hoặc kẻ khách, ăn thịt của một con thú chết hay là bị xé, phải giặt quần áo mình, tắm trong nước, bị ô uế đến chiều tối, đoạn được tinh sạch lại. ");
INSERT INTO vie1934_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Còn nếu người không giặt quần áo và không tắm, thì sẽ mang tội mình. ");
INSERT INTO vie1934_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Hãy nói cùng dân Y-sơ-ra-ên rằng: Ta là Giê-hô-va Đức Chúa Trời các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Các ngươi chớ làm theo những điều người ta làm hoặc tại xứ Ê-díp-tô, là nơi các ngươi đã kiều ngụ, hoặc tại xứ Ca-na-an, là xứ ta dẫn các ngươi đi đến: chớ đi theo thói tục họ. ");
INSERT INTO vie1934_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Các ngươi hãy tuân mạng lịnh ta, gìn giữ luật pháp ta đặng noi theo: Ta là Giê-hô-va Đức Chúa Trời các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Vậy, hãy giữ luật pháp và mạng lịnh ta, người nào làm theo, thì sẽ nhờ nó mà được sống: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Chớ một ai trong vòng các ngươi đến gần cùng người nữ bà con mình đặng cấu hiệp: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Chớ cấu hiệp cùng mẹ mình; bằng cấu hiệp, tất làm nhục cho cha mẹ. ");
INSERT INTO vie1934_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Chớ cấu hiệp cùng kế mẫu, bằng cấu hiệp, ấy làm nhục cho cha mình. ");
INSERT INTO vie1934_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Chớ cấu hiệp cùng chị em mình, hoặc một cha khác mẹ, hoặc một mẹ khác cha, hoặc sanh tại trong nhà, hoặc sanh ở ngoài. ");
INSERT INTO vie1934_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Chớ cấu hiệp cùng cháu gái, hoặc cháu gái nội, hoặc cháu gái ngoại; bằng cấu hiệp, ấy là gây nhục cho mình. ");
INSERT INTO vie1934_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Chớ cấu hiệp cùng con gái của kế mẫu bởi cha mình sanh ra, vì là em gái ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Chớ cấu hiệp cùng chị em của cha ngươi; vì là cốt nhục của cha ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Chớ cấu hiệp cùng chị em của mẹ ngươi; vì là cốt nhục của mẹ ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Chớ cấu hiệp cùng bác gái hay thím ngươi; bằng cấu hiệp, ấy là gây nhục cho anh em của cha ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Chớ cấu hiệp cùng dâu ngươi; vì là vợ của con trai mình. ");
INSERT INTO vie1934_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Chớ cấu hiệp cùng chị dâu hay em dâu ngươi; nếu cấu hiệp, ấy làm nhục cho anh em ngươi vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Chớ cấu hiệp cùng một người đàn bà luôn với con gái của người đàn bà nữa. Chớ lấy cháu gái nội ngươi, hoặc cháu gái ngoại ngươi đặng cấu hiệp cùng họ; chúng nó đều là cốt nhục gần; làm vậy, ấy là một việc ác dục. ");
INSERT INTO vie1934_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Chớ lấy vợ luôn với chị em người mà cấu hiệp cùng nó gần bên vợ chánh mình đang khi người còn sống, e khi sanh ghen tương. ");
INSERT INTO vie1934_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Trong lúc người nữ có kinh nguyệt, chớ đến gần mà cấu hiệp. ");
INSERT INTO vie1934_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Chớ nằm cùng vợ người lân cận mình, mà gây cho mình bị ô uế với người. ");
INSERT INTO vie1934_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Chớ bắt con cái mình đặng dâng cho thần Mo-lóc, chớ làm ô danh Đức Chúa Trời ngươi: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Chớ nằm cùng một người nam như người ta nằm cùng một người nữ; ấy là một sự quái gớm. ");
INSERT INTO vie1934_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Chớ nằm cùng một con thú nào, mà gây cho mình bị ô uế với nó; một người đàn bà chớ nằm cùng thú vật nào; ấy là một sự quái gớm. ");
INSERT INTO vie1934_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Các ngươi chớ làm một trong mấy việc đó mà tự gây cho mình ô uế; bởi dân mà ta sẽ đuổi khỏi trước mặt các ngươi đã thành ô uế vì cớ làm các việc đó. ");
INSERT INTO vie1934_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Đất vì chúng nó mà bị ô uế; ta sẽ phạt tội ác họ; đất sẽ mửa dân nó ra vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Còn các ngươi, hoặc dân bổn xứ, hoặc kẻ khách kiều ngụ giữa các ngươi, phải giữ luật pháp và mạng lịnh ta, đừng làm một trong những điều quái gớm nầy. ");
INSERT INTO vie1934_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Vì những điều quái gớm ấy, những người ở tại xứ trước các ngươi đã làm; và đất vì cớ đó phải thành ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Vậy, chớ làm đất thành ô uế, e khi đất mửa các ngươi ra, như đã mửa dân cư trú tại xứ trước các ngươi chăng; ");
INSERT INTO vie1934_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","vì phàm ai làm một trong những điều quái gớm ấy sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Thế thì, các ngươi phải giữ điều ta phán dặn, để đừng làm theo một trong các thói tục gớm ghiếc nào đã làm trước các ngươi, và các ngươi chớ vì các thói tục đó mà gây cho mình ô uế. Ta là Giê-hô-va Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Hãy truyền cho cả hội chúng Y-sơ-ra-ên rằng: Hãy nên thánh, vì ta Giê-hô-va Đức Chúa Trời các người, vốn là thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ai nấy phải tôn kính cha mẹ mình và giữ những ngày sa-bát ta: Ta là Giê-hô-va Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Chớ xây về hình tượng và cũng chớ đúc tượng tà thần: Ta là Giê-hô-va Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Khi các ngươi dâng của lễ thù ân cho Đức Giê-hô-va, thì phải dâng một cách cho được nhậm; ");
INSERT INTO vie1934_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ăn nội trong ngày dâng đó và ngày mai; còn phần chi dư lại qua ngày thứ ba, thì phải thiêu đi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Nếu người ta để ăn đến ngày thứ ba, ấy là một điều gớm ghiếc chẳng được nhậm. ");
INSERT INTO vie1934_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ai ăn của lễ như vậy sẽ mang lấy tội ác mình, vì đã làm vật thánh của Đức Giê-hô-va ra ô độc: người đó sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Khi các ngươi gặt lúa trong xứ mình, chớ có gặt đến cuối đầu đồng, và chớ mót lại những bông còn sót; ");
INSERT INTO vie1934_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","các ngươi chớ cắn mót nho mình, đừng nhặt những trái rớt rồi, hãy để cho mấy người nghèo và kẻ khách: Ta là Giê-hô-va Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Các ngươi chớ ăn trộm ăn cắp, chớ nói dối, và chớ lừa đảo nhau. ");
INSERT INTO vie1934_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Các ngươi chớ chỉ danh ta mà thề dối, vì ngươi làm ô danh của Đức Chúa Trời mình: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Chớ ức hiếp kẻ lân cận mình, chớ cướp giựt của họ. Tiền công của kẻ làm mướn ngươi, chớ nên để lại trong nhà mình cho đến ngày mai. ");
INSERT INTO vie1934_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Chớ nên rủa sả người điếc, chớ để trước mặt người mù vật chi làm cho người vấp té; nhưng hãy kính sợ Đức Chúa Trời ngươi: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Các ngươi chớ phạm sự bất nghĩa trong việc xét đoán, chớ thiên vị người nghèo, chớ nể kẻ quyền thế; hãy cứ theo công bình mà xét đoán kẻ lân cận ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Chớ buông lời phao vu trong dân sự mình, chớ lập mưu kế nghịch sự sống của kẻ lân cận mình: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Chớ có lòng ghen ghét anh em mình; hãy sửa dạy kẻ lân cận mình, đừng vì cớ họ mà phải mắc tội. ");
INSERT INTO vie1934_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Chớ toan báo thù, chớ giữ sự báo thù cùng con cháu dân sự mình; nhưng hãy yêu thương kẻ lân cận ngươi như mình: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Các ngươi hãy giữ những mạng lịnh ta. Chớ để loài vật khác giống phủ lẫn nhau; chớ gieo ruộng ngươi hai thứ giống, và chớ mặc mình bằng áo dệt nhiều thứ chỉ. ");
INSERT INTO vie1934_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Nếu một người nam nằm và cấu hiệp cùng một đứa tớ gái đã hứa gả cho một người, nhưng chưa chuộc ra, hoặc chưa được phóng mọi; thì hai người đều sẽ bị hình phạt, mà không phải đến chết, vì đứa tớ gái chưa được phóng mọi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Người nam vì lỗi mình sẽ dẫn một con chiên đực đến trước mặt Đức Giê-hô-va tại cửa hội mạc, mà làm của lễ chuộc sự mắc lỗi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Thầy tế lễ sẽ dùng con chiên đực làm của lễ chuộc sự mắc lỗi đặng làm lễ chuộc tội cho người đã phạm, trước mặt Đức Giê-hô-va; vậy, tội người đã phạm sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Khi các ngươi sẽ vào xứ Ca-na-an, và đã trồng các thứ cây trái rồi, hãy coi các trái chiếng nó không sạch, như chưa chịu phép cắt bì; trong ba năm các ngươi hãy coi nó không sạch, chớ nên ăn; ");
INSERT INTO vie1934_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","nhưng qua năm thứ tư, các trái nó sẽ nên thánh làm của lễ khen ngợi Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Qua năm thứ năm, các ngươi phải ăn trái, hầu cho cây thêm hoa quả: Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Các ngươi chớ ăn vật chi có huyết, chớ dùng bói khoa, chớ làm thuật số. ");
INSERT INTO vie1934_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Chớ cắt mé tóc mình cho tròn, và chớ nên phá khóe râu mình. ");
INSERT INTO vie1934_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Chớ vì kẻ chết mà cắt thịt mình, chớ xăm vẽ trên mình: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Chớ nhục con gái ngươi khiến nó làm kỵ nữ, để trong xứ không có điều dâm loạn và đầy dẫy những ác dục. ");
INSERT INTO vie1934_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Các ngươi phải giữ những sa-bát ta, và tôn kính nơi thánh ta: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Các ngươi chớ cầu đồng cốt hay là thầy bói; chớ hỏi chúng nó, e vì chúng nó mà các ngươi phải bị ô uế: Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Trước mặt người tóc bạc, ngươi hãy đứng dậy, kính người già cả, và kính sợ Đức Chúa Trời ngươi. Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Khi kẻ khách nào kiều ngụ trong xứ các ngươi, thì chớ hà hiếp người. ");
INSERT INTO vie1934_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Kẻ khách kiều ngụ giữa các ngươi sẽ kể như kẻ đã sanh đẻ giữa các ngươi; hãy thương yêu người như mình, vì các ngươi đã làm khách kiều ngụ trong xứ Ê-díp-tô: Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Các ngươi chớ phạm sự bất nghĩa trong việc xét đoán, hoặc sự đo, sự cân, hay là sự lường. ");
INSERT INTO vie1934_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Các ngươi phải có cân thiệt, trái cân bằng đá đúng, một ê-pha thiệt, và một hin thiệt: Ta là Giê-hô-va, Đức Chúa Trời của các ngươi, Đấng đã dẫn các ngươi ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Vậy, các ngươi hãy gìn giữ làm theo các luật pháp và các mạng lịnh ta: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Ngươi hãy nói cùng dân Y-sơ-ra-ên rằng: Phàm ai trong dân Y-sơ-ra-ên hay là kẻ khách kiều ngụ giữa vòng họ, dùng một trong các con mình dâng cho thần Mo-lóc, thì chắc sẽ bị xử tử: dân bổn xứ phải ném đá người ấy. ");
INSERT INTO vie1934_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Còn ta sẽ nổi giận cùng người đó, truất nó khỏi dân sự mình, vì nó đã nộp con cái mình cho thần Mo-lóc, làm cho nơi thánh ta ô uế, và làm ô danh thánh ta. ");
INSERT INTO vie1934_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Nếu dân bổn xứ nhắm mắt khi người đó dâng một trong các con cái nó cho thần Mo-lóc mà chẳng giết nó đi, ");
INSERT INTO vie1934_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","thì ta đây sẽ nổi giận cùng người đó và nhà nó, rồi truất nó cùng những kẻ nào theo nó mà thông dâm cùng thần Mo-lóc, ra khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Nếu ai xây về đồng cốt và thầy bói mà thông dâm cùng chúng nó, thì ta sẽ nổi giận cùng người đó, truất nó ra khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Các ngươi hãy làm sạch mình, và hãy nên thánh, vì ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Các ngươi hãy giữ làm theo những luật pháp ta: Ta là Đức Giê-hô-va, Đấng làm cho các ngươi nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Khi một người nào chửi cha mắng mẹ mình, thì phải bị xử tử: nó đã chửi rủa cha mẹ; huyết nó sẽ đổ lại trên mình nó. ");
INSERT INTO vie1934_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Nếu người nào phạm tội tà dâm cùng vợ của người khác, hay là phạm tội tà dâm cùng vợ người lân cận mình, người nam cùng người nữ đó đều phải bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Nếu người nào nằm cùng vợ cha mình, ấy là gây nhục cho cha mình, thì hai người đều hẳn phải bị xử tử; huyết họ sẽ đổ lại trên mình họ. ");
INSERT INTO vie1934_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Nếu người nào nằm cùng dâu mình, hai người đều hẳn phải bị phạt xử tử; vì họ phạm một sự gớm ghiếc; huyết họ sẽ đổ lại trên mình họ. ");
INSERT INTO vie1934_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Nếu một người nam nằm cùng một người nam khác, như nằm cùng người nữ, thì hai người đó đều hẳn phải bị xử tử, vì họ đã làm một sự gớm ghiếc; huyết họ sẽ đổ lại trên mình họ. ");
INSERT INTO vie1934_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Nếu một người nam lấy cả mẹ và con làm vợ; ấy là một sự tà ác; hãy thiêu cả ba đi, hầu cho sự tà ác đó không còn trong vòng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Nếu một người nam cấu hiệp cùng thú vật, thì hẳn phải bị xử tử, và các ngươi hãy giết thú đó đi. ");
INSERT INTO vie1934_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Nếu một người nữ lại gần một con thú đặng cấu hiệp cùng nó, ngươi hãy giết người nữ và con thú đó đi; huyết nó sẽ đổ lại trên mình nó. ");
INSERT INTO vie1934_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Nếu một người nam lấy chị em gái mình, hoặc một cha khác mẹ, hoặc một mẹ khác cha, và họ cấu hiệp nhau; ấy là sự điếm nhục; họ sẽ bị truất khỏi trước mặt dân sự mình; người đã gây nhục cho chị em mình; người sẽ mang tội ác mình. ");
INSERT INTO vie1934_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Nếu một người nam nằm cùng một người nữ trong lúc có kinh nguyệt, và người nam lộ ra nguyên huyết của người nữ, và chính người nữ cũng lộ ra nguyên huyết mình, thì cả hai đều sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Chớ cấu hiệp cùng chị em của mẹ hay là chị em của cha ngươi, vì là gây nhục cho thân tộc mình; hai người đều sẽ mang tội ác mình. ");
INSERT INTO vie1934_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Nếu người nam nằm cùng bác gái hay thím mình, tức là gây nhục cho chú bác mình; hai người đều sẽ mang sự hình phạt của tội mình. Họ sẽ chết tuyệt tự. ");
INSERT INTO vie1934_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Nếu một người nam lấy vợ của anh em mình, ấy là sự ô uế; người đó đã gây nhục cho anh em mình. Hai người đó sẽ tuyệt tự. ");
INSERT INTO vie1934_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Các ngươi hãy gìn giữ làm theo những luật pháp và mạng lịnh ta, hầu cho xứ mà ta dẫn các ngươi đến ở không mửa các ngươi ra. ");
INSERT INTO vie1934_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Chớ nên noi theo thói tục của dân mà ta sẽ đuổi ra khỏi trước mặt các ngươi, vì họ đã làm những điều đó, và ta lấy làm gớm ghiếc lắm. ");
INSERT INTO vie1934_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ta đã phán cùng các ngươi rằng: Aáy là các ngươi sẽ được xứ của dân đó; ta cho các ngươi xứ ấy đặng làm sản nghiệp; ấy là một xứ đượm sữa và mật: Ta là Giê-hô-va, Đức Chúa Trời của các ngươi, đã phân rẽ các ngươi cùng các dân. ");
INSERT INTO vie1934_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Vậy, hãy phân biệt thú tinh sạch với thú ô uế, chim ô uế với chim tinh sạch; chớ gây cho mình ra gớm ghiếc vì loài vật, vì chim chóc, vì các loài côn trùng trên mặt đất, mà ta đã dạy các ngươi phân biệt như loài ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Đối cùng ta các ngươi hãy nên thánh, vì ta, Đức Giê-hô-va, là thánh; ta đã phân rẽ các ngươi với các dân, để các ngươi thuộc về ta. ");
INSERT INTO vie1934_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Khi nào một người nam hay nữ làm đồng cốt, hay là bói khoa, thì hẳn sẽ bị xử tử; người ta sẽ ném đá chúng nó: huyết chúng nó sẽ đổ lại trên mình chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: Hãy nói cùng những thầy tế lễ, là các con trai A-rôn, mà rằng: Thầy tế lễ chớ vì một người chết trong dân sự mà làm cho mình ra ô uế; ");
INSERT INTO vie1934_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","trừ ra vì bà con thân thích mình, vì mẹ, cha, con trai, con gái, anh em mình, ");
INSERT INTO vie1934_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","và vì chị em ruột mình còn đồng trinh, chưa chồng, thì người được vì chị em đó làm cho mình ra ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Người là đầu trưởng trong dân sự mình, chớ làm mình ra tục mà bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Các thầy tế lễ chớ nên làm sói trên đầu; chớ cạo mép râu mình, đừng cắt thịt mình. ");
INSERT INTO vie1934_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Họ sẽ biệt riêng ra thánh cho Đức Chúa Trời mình, và chớ làm ô danh Ngài, vì họ dâng cho Đức Giê-hô-va các của lễ dùng lửa thiêu; tức là thực vật của Đức Chúa Trời mình: họ phải nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Thầy tế lễ chớ nên cưới một người kỵ nữ hay là kẻ dâm ô; cũng chẳng nên cưới người bị chồng để, vì thầy tế lễ đã biệt riêng ra thánh cho Đức Chúa Trời mình. ");
INSERT INTO vie1934_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Vậy, ngươi hãy kể thầy tế lễ như thánh, vì người dâng thực vật của Đức Chúa Trời người; người sẽ là thánh cho ngươi, vì ta, Đức Giê-hô-va, là thánh, Đấng làm cho các ngươi nên thánh vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Nếu con gái thầy tế lễ đi dâm ô, tự làm nên kỵ nữ, ấy là làm ô danh cho cha nó, nó phải bị thiêu lửa. ");
INSERT INTO vie1934_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Thầy tế lễ được quyền trọng hơn các anh em mình, -đã được rưới dầu xức trên đầu mình, được biệt riêng ra thánh, để mặc mình bằng bộ áo thánh, -chẳng nên để đầu trần và xé áo mình. ");
INSERT INTO vie1934_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ngươi chớ đi đến cùng một kẻ chết, chớ vì cha hay mẹ mà làm mình ra ô uế. ");
INSERT INTO vie1934_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Người chẳng nên đi ra khỏi nơi thánh, đừng làm cho nơi thánh của Đức Chúa Trời mình ra ô uế, vì cái mão dầu xức của Đức Chúa Trời vẫn ở trên đầu người: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Người phải cưới gái đồng trinh làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Người chẳng nên cưới đàn bà góa, bị để, dâm ô hay là kỵ nữ, nhưng phải cưới một người đồng trinh trong vòng dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Người chẳng nên làm ô danh dòng họ mình giữa dân sự người, vì ta là Đức Giê-hô-va làm cho người nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Đức Giê-hô-va còn phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Hãy nói cùng A-rôn mà rằng: Phàm ai trong dòng họ ngươi, trải các đời, có một tật bịnh trong thân thể, chớ đến gần mà dâng thực vật cho Đức Chúa Trời mình. ");
INSERT INTO vie1934_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Phàm ai có một tật không được đến gần, như đây: người mù, què, sệp mũi hay là tứ chi không đều; ");
INSERT INTO vie1934_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","người gãy chân hay gãy tay, ");
INSERT INTO vie1934_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","người có bướu hay là lỏng khỏng, có vảy cá mắt hay là có ghẻ chốc, có lát hay là có hòn nang dập. ");
INSERT INTO vie1934_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Phàm con cháu thầy tế lễ A-rôn, có tật trong mình, không được đến gần dâng của lễ dùng lửa dâng lên cho Đức Giê-hô-va. Nếu có một tật trong mình, không được đến gần dâng thực vật cho Đức Chúa Trời mình. ");
INSERT INTO vie1934_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Người được ăn thực vật của Đức Chúa Trời mình, là các vật chí thánh và các vật biệt riêng ra thánh; ");
INSERT INTO vie1934_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","nhưng không được đi đến bức màn, và cũng không được đi đến gần bàn thờ, vì có tật nơi mình. Ngươi chớ làm các nơi thánh ta ra ô uế, vì ta, Đức Giê-hô-va, làm các nơi đó nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Môi-se nói như vậy cho A-rôn và các con trai người, cùng cho cả dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Hãy truyền cho A-rôn và các con trai người rằng phải kiêng cữ những của lễ thánh của dân Y-sơ-ra-ên, dâng biệt riêng ra thánh cho ta, hầu cho chúng chớ làm ô danh thánh ta: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Hãy nói với họ rằng: Phàm ai trong dòng giống các ngươi và trong vòng con cháu các ngươi đã bị ô uế, đến gần các vật thánh mà dân Y-sơ-ra-ên biệt riêng cho Đức Giê-hô-va, thì ai đó sẽ bị truất khỏi trước mặt ta: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Phàm ai là con cháu của A-rôn bị bịnh phung hay là bạch trược, thì chẳng được ăn vật biệt riêng ra thánh cho đến chừng nào được tinh sạch. Ai đụng đến một người đã bị ô uế bởi xác chết, ai có di tinh, ");
INSERT INTO vie1934_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","hay là ai đụng đến hoặc loài côn trùng, hoặc một người bị sự ô uế nào làm cho mình ô uế, thì cũng phải một thể ấy. ");
INSERT INTO vie1934_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ai đụng đến các vật đó sẽ bị ô uế đến chiều tối, không được ăn vật biệt riêng ra thánh, nhưng phải tắm mình trong nước. ");
INSERT INTO vie1934_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Sau khi mặt trời lặn, người sẽ được sạch lại, rồi mới được phép ăn các vật thánh, vì là đồ ăn của người. ");
INSERT INTO vie1934_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Người chẳng nên ăn một con thú nào chết tự nhiên hay là bị xé, hầu khỏi bị ô uế: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Vậy, họ phải giữ điều ta phán dặn, kẻo mang tội lỗi và chết chăng, vì đã làm các vật thánh nay ra ô uế: Ta là Đức Giê-hô-va làm cho họ nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Chẳng một kẻ khách ngoại bang nào được ăn vật thánh; kẻ nào ở tại nhà thầy tế lễ hay là người làm mướn, cũng chẳng được ăn vật thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Nhưng kẻ nào thầy tế lễ lấy bạc mua về, và kẻ sanh đẻ tại nhà người, thì được phép ăn đồ ăn của người. ");
INSERT INTO vie1934_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Nếu con gái của thầy tế lễ kết thân cùng kẻ khách ngoại bang, thì sẽ không được ăn vật thánh dâng giơ lên. ");
INSERT INTO vie1934_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Còn nếu con gái của thầy tế lễ đã góa hay là bị để, không có con, trở về nhà cha ở như buổi còn thơ, thì nàng sẽ được ăn đồ ăn của cha mình, nhưng chẳng kẻ khách ngoại bang nào nên ăn. ");
INSERT INTO vie1934_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Nếu ai lầm ăn một vật thánh, thì phải đền lại cho thầy tế lễ giá của vật thánh đó, và phụ thêm một phần năm. ");
INSERT INTO vie1934_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Thầy tế lễ chớ làm ô uế của lễ mà dân Y-sơ-ra-ên dâng giơ lên cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ai ăn vật thánh đã dâng như vậy sẽ mang tội mình đã phạm, vì ta là Đức Giê-hô-va làm cho các vật đó nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Hãy truyền cho A-rôn và các con trai người, cùng cho cả dân Y-sơ-ra-ên, mà rằng: Hễ người nhà Y-sơ-ra-ên hay là kẻ khách kiều ngụ giữa họ, mà dâng của lễ thiêu cho Đức Giê-hô-va, hoặc của lễ khấn nguyện, hay là của lễ lạc ý, hầu cho được nhậm, ");
INSERT INTO vie1934_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","phải dâng một con đực không tì vít chi bắt trong bầy bò, hoặc chiên con hay là dê cái. ");
INSERT INTO vie1934_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Các ngươi chớ dâng một con vật nào có tì vít, vì nó sẽ không được nhậm. ");
INSERT INTO vie1934_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Khi một người nào dâng cho Đức Giê-hô-va một của lễ thù ân bằng bò hay chiên, hoặc dâng trả lễ khấn nguyện hay là lạc ý, hầu cho con sinh được nhậm, phải không có một tì vít chi trên mình. ");
INSERT INTO vie1934_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Các ngươi chớ dâng cho Đức Giê-hô-va một con thú nào hoặc mù mắt, què cẳng, bị xé, ghẻ chốc, hay là lát; các ngươi chớ bắt nó làm của lễ dùng lửa dâng lên cho Đức Giê-hô-va trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Các ngươi được bắt một con bò hay chiên con có giò dài quá, hoặc ngắn quá mà làm của lễ lạc ý; nhưng về của lễ khấn nguyện, con thú như vầy quả sẽ chẳng được nhậm. ");
INSERT INTO vie1934_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Các ngươi chớ dâng cho Đức Giê-hô-va tại xứ mình một con thú nào hòn nang bị dập nát, rứt hay là thiến đi. ");
INSERT INTO vie1934_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Chớ nhận nơi tay kẻ khách ngoại bang một con sinh nào bị như vậy đặng dâng làm thực vật cho Đức Chúa Trời mình, vì nó đã bị hư và có tì vít trên mình, không được nhậm vì các ngươi đâu. ");
INSERT INTO vie1934_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Hễ con bò con, con chiên con hay con dê con, phải ở quẩn theo mẹ trong bảy ngày sau khi lọt lòng; nhưng qua ngày thứ tám về sau sẽ được nhậm làm của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Bất k” bò cái hay chiên cái, các ngươi chớ giết nó và con nó trong một ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Khi các ngươi dâng của lễ thù ân cho Đức Giê-hô-va, thì phải dâng thế nào cho của lễ vì các ngươi được nhậm. ");
INSERT INTO vie1934_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Của lễ đó phải ăn nội ngày, không nên để chi lại cho đến sớm mai: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Vậy, hãy giữ làm theo các điều răn ta: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Đừng làm ô danh thánh ta, thì ta sẽ được tôn thánh giữa dân Y-sơ-ra-ên: Ta là Đức Giê-hô-va làm cho các ngươi nên thánh, ");
INSERT INTO vie1934_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","tức Đấng đã đem các ngươi ra khỏi xứ Ê-díp-tô, để làm Đức Chúa Trời các ngươi: Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Hãy truyền cho dân Y-sơ-ra-ên rằng: Nầy là những ngày lễ của Đức Giê-hô-va các ngươi hãy rao truyền ra là các hội thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Người ta làm việc trong sáu ngày, nhưng qua ngày thứ bảy là ngày sa-bát, một ngày nghỉ, tức một sự nhóm hiệp thánh; đừng làm một công việc gì; ấy là lễ sa-bát của Đức Giê-hô-va trong những nơi các ngươi ở. ");
INSERT INTO vie1934_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Nầy là những lễ của Đức Giê-hô-va, tức những sự nhóm hiệp thánh, các ngươi phải rao truyền ra khi đến k” nhất định. ");
INSERT INTO vie1934_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Đến ngày mười bốn tháng giêng, vào buổi chiều tối, ấy là lễ Vượt-qua của Đức Giê-hô-va; ");
INSERT INTO vie1934_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","qua ngày rằm tháng nầy, ấy là lễ bánh không men để kính trọng Đức Giê-hô-va; các ngươi sẽ ăn bánh không pha men trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ngày đầu, các ngươi sẽ có một sự nhóm hiệp thánh, chẳng nên làm một công việc xác thịt. ");
INSERT INTO vie1934_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Trong bảy ngày các ngươi phải dâng cho Đức Giê-hô-va những của lễ dùng lửa dâng lên; đến ngày thứ bảy, sẽ có một sự nhóm hiệp thánh nữa, các ngươi đừng làm một công việc xác thịt nào hết. ");
INSERT INTO vie1934_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Hãy truyền cho dân Y-sơ-ra-ên rằng: Khi nào các ngươi đã vào xứ mà ta sẽ ban cho, và đã gặt mùa màng rồi, thì hãy đem đến cho thầy tế lễ một bó lúa đầu mùa của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Qua ngày sau lễ sa-bát, thầy tế lễ sẽ dâng bó lúa đưa qua đưa lại trước mặt Đức Giê-hô-va, hầu cho bó lúa đó được nhậm. ");
INSERT INTO vie1934_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Chính ngày dâng bó lúa đưa qua đưa lại đó, các ngươi cũng phải dâng cho Đức Giê-hô-va một chiên con giáp năm, không tì vít chi, đặng làm của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","và dâng thêm một của lễ chay bằng hai phần mười bột lọc chế dầu, làm của lễ dùng lửa dâng lên, có mùi thơm cho Đức Giê-hô-va, với một phần tư hin rượu, làm lễ quán. ");
INSERT INTO vie1934_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Các ngươi chớ ăn hoặc bánh, hoặc hột lúa rang, hoặc lúa đang ở trong gié cho đến chính ngày nầy, tức là ngày các ngươi đem dâng của lễ cho Đức Chúa Trời mình. Mặc dầu ở nơi nào, ấy là một lệ định đời đời cho con cháu các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Kể từ ngày sau lễ sa-bát, là ngày đem bó lúa dâng đưa qua đưa lại, các ngươi sẽ tính bảy tuần lễ trọn: ");
INSERT INTO vie1934_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","các ngươi tính năm mươi ngày cho đến ngày sau của lễ sa-bát thứ bảy, thì phải dâng một của lễ chay mới cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Các ngươi hãy từ nhà mình đem đến hai ổ bánh đặng làm của lễ dâng đưa qua đưa lại; bánh đó làm bằng hai phần mười bột lọc hấp có pha men: ấy là của đầu mùa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Các ngươi cũng phải dâng luôn với bánh, bảy chiên con giáp năm chẳng tì vít chi, một con bò tơ, và hai con chiên đực với của lễ chay và lễ quán cặp theo, đặng làm của lễ thiêu tế Đức Giê-hô-va: ấy là một của lễ dùng lửa xông, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Các ngươi cũng phải dâng một con dê đực đặng làm của lễ chuộc tội, và hai chiên con giáp năm, đặng làm của lễ thù ân. ");
INSERT INTO vie1934_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Thầy tế lễ sẽ lấy các của lễ đó với hai ổ bánh bằng lúa đầu mùa, và hai chiên con, dâng đưa qua đưa lại trước mặt Đức Giê-hô-va; các vật đó sẽ biệt riêng ra thánh cho Đức Giê-hô-va, và thuộc về thầy tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Các ngươi hãy rao truyền sự nhóm hiệp trong chính một ngày đó; phải có một sự nhóm hiệp thánh, chớ nên làm một công việc xác thịt nào. Aáy là một lệ định đời đời cho dòng dõi các ngươi, mặc dầu ở nơi nào. ");
INSERT INTO vie1934_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Khi các ngươi gặt lúa trong xứ mình, chớ gặt tận đầu đồng, và chớ mót lúa sót lại; hãy để phần đó cho người nghèo và cho kẻ khách ngoại bang: Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Hãy truyền cho dân Y-sơ-ra-ên rằng: Ngày mồng một tháng bảy, sẽ có cho các ngươi một ngày nghỉ, một lễ kỷ niệm lấy tiếng kèn thổi mà rao truyền, tức là một sự nhóm hiệp thánh vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Chớ làm một công việc xác thịt nào; phải dâng các của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Đức Giê-hô-va cũng phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Ngày mồng mười tháng bảy nầy là ngày lễ chuộc tội; các ngươi sẽ có sự nhóm hiệp thánh; hãy ép tâm hồn mình và dâng cho Đức Giê-hô-va các của lễ dùng lửa dâng lên. ");
INSERT INTO vie1934_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ngày đó chẳng nên làm công việc nào, vì là ngày chuộc tội, trong ngày đó phải làm lễ chuộc tội cho các ngươi trước mặt Giê-hô-va, Đức Chúa Trời mình. ");
INSERT INTO vie1934_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Trong ngày đó, hễ ai không ép tâm hồn mình, sẽ bị truất khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Và hễ ai làm một công việc gì, thì ta sẽ diệt họ khỏi dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Các ngươi chẳng nên làm công việc chi hết, ấy là một lệ định đời đời cho dòng dõi các ngươi, mặc dầu ở nơi nào. ");
INSERT INTO vie1934_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Aáy sẽ là một lễ sa-bát, một ngày nghỉ cho các ngươi; các ngươi phải ép tâm hồn mình. Ngày mồng chín tháng đó, các ngươi phải giữ lễ sa-bát mình, từ chiều nay đến chiều mai. ");
INSERT INTO vie1934_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Hãy truyền cho dân Y-sơ-ra-ên rằng: Ngày rằm tháng bảy nầy là lễ lều tạm, trải qua bảy ngày đặng tôn kính Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ngày thứ nhất sẽ có sự nhóm hiệp thánh, các ngươi chẳng nên làm một công việc xác thịt nào. ");
INSERT INTO vie1934_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Trong bảy ngày phải dâng các của lễ dùng lửa dâng cho Đức Giê-hô-va; qua ngày thứ tám, các ngươi có một sự nhóm hiệp thánh nữa, cũng dâng của lễ dùng lửa dâng cho Đức Giê-hô-va. Aáy sẽ là một hội trọng thể; chớ nên làm một công việc xác thịt nào hết. ");
INSERT INTO vie1934_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Đó là những lễ trọng thể của Đức Giê-hô-va, mà các ngươi phải rao truyền là sự nhóm hiệp thánh, đặng dâng cho Đức Giê-hô-va những của lễ dùng lửa dâng lên, của lễ thiêu, của lễ chay, của lễ thù ân, lễ quán, vật nào đã định theo ngày nấy. ");
INSERT INTO vie1934_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ngoài ra, các ngươi phải cứ giữ lễ sa-bát của Đức Giê-hô-va, cứ dâng cho Ngài các lễ vật mình, các của lễ khấn nguyện và lạc ý. ");
INSERT INTO vie1934_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Nhưng đến ngày rằm tháng bảy, khi các ngươi đã thâu-hoạch thổ sản mình rồi, hãy giữ một lễ cho Đức Giê-hô-va trong bảy ngày. Bữa thứ nhất sẽ là ngày nghỉ, và bữa thứ tám cũng sẽ là ngày nghỉ. ");
INSERT INTO vie1934_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Bữa thứ nhất, các ngươi phải lấy trái cây tốt, tàu chà là, nhành cây rậm, và cây dương liễu, rồi vui mừng trong bảy ngày trước mặt Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Mỗi năm, vào tháng bảy, các ngươi phải giữ lễ nầy cho Đức Giê-hô-va như vậy trong bảy ngày. Aáy là một lệ định đời đời cho dòng dõi các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Hết thảy ai sanh trong dòng Y-sơ-ra-ên sẽ ở nơi trại trong bảy ngày, ");
INSERT INTO vie1934_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","hầu cho dòng dõi các ngươi biết rằng khi ta đem dân Y-sơ-ra-ên ra khỏi xứ Ê-díp-tô, ta cho họ ở trong những trại: Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Aáy vậy, Môi-se truyền cho dân Y-sơ-ra-ên biết các lễ của Đức Giê-hô-va là lễ nào. ");
INSERT INTO vie1934_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Hãy truyền cho dân Y-sơ-ra-ên đem dầu ô-li-ve ép, trong sạch, đặng thắp đèn, để giữ cho đèn cháy luôn luôn. ");
INSERT INTO vie1934_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","A-rôn sẽ làm đèn đó trong hội mạc, ngoài bức màn che hòm bảng chứng, hầu cho đèn cháy luôn luôn, từ chiều tối đến sáng mai, trước mặt Đức Giê-hô-va; ấy là một lệ định đời đời cho dòng dõi các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","A-rôn sẽ để các đèn trên chân đèn bằng vàng, cho đèn cháy luôn luôn trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ngươi cũng phải lấy bột lọc, hấp mười hai ổ bánh; mỗi ổ cân nặng hai phần mười ê-pha; ");
INSERT INTO vie1934_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","đoạn sắp ra hai hàng sáu ổ trên cái bàn bằng vàng ròng trước mặt Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","cùng rắc nhũ hương thánh trên mỗi hàng, để làm kỷ niệm trên bánh, như một của lễ dùng lửa dâng trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mỗi ngày sa-bát, người ta sẽ sắp bánh nầy trước mặt Đức Giê-hô-va luôn luôn, do nơi dân Y-sơ-ra-ên cung cấp; ấy là một giao ước đời đời. ");
INSERT INTO vie1934_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Các bánh đó sẽ thuộc về A-rôn và các con trai người; họ phải ăn tại một nơi thánh, vì là vật chí thánh cho họ, bởi các của lễ dùng lửa dâng cho Đức Giê-hô-va. Aáy là một lệ định đời đời. ");
INSERT INTO vie1934_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Có một đứa con trai, mẹ là người Y-sơ-ra-ên, và cha là người Ê-díp-tô, đi ra giữa vòng dân Y-sơ-ra-ên, đánh lộn tại nơi trại quân với một người Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Đứa trai đó nói phạm đến và rủa sả danh Đức Giê-hô-va; người ta dẫn nó đến Môi-se, bèn giam nó vào ngục cho đến chừng Đức Giê-hô-va phán định phải xử làm sao. ");
INSERT INTO vie1934_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Mẹ nó tên là Sê-lô-mít, con gái của Điệp-ri, thuộc về chi phái Đan. ");
INSERT INTO vie1934_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Vả, Đức Giê-hô-va bèn phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Hãy đem kẻ đã rủa sả ra ngoài trại quân, hết thảy ai đã có nghe nó phải đặt tay mình trên đầu nó, và cả hội chúng phải ném đá nó. ");
INSERT INTO vie1934_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Đoạn hãy nói cùng dân Y-sơ-ra-ên rằng: Người nào rủa sả Đức Chúa Trời mình sẽ mang sự hình phạt của tội mình. ");
INSERT INTO vie1934_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ai nói phạm đến danh Đức Giê-hô-va hẳn sẽ bị xử tử; cả hội chúng sẽ ném đá nó: mặc dầu nó là kẻ khách ngoại bang hay là sanh trong xứ, hễ khi nào nói phạm đến danh Đức Giê-hô-va, thì sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Kẻ nào đánh chết một người nào, mặc dầu kẻ đó là ai, sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kẻ nào đánh chết một súc vật, phải thường lại, nghĩa là mạng đền mạng. ");
INSERT INTO vie1934_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Khi một người nào làm thương tích cho kẻ lân cận mình, thì người ta phải làm thương tích cho người đó lại như chính người đã làm: ");
INSERT INTO vie1934_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","gãy đền gãy, mắt đền mắt, răng đền răng. Người ta sẽ làm cho người ấy đồng một thương vít như chính người đã làm cho người khác. ");
INSERT INTO vie1934_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kẻ nào làm chết một súc vật, thì sẽ thường lại; còn kẻ nào giết chết một người, thì phải bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Bất luận kẻ khách ngoại bang hay là người trong xứ, các ngươi cũng phải dùng một luật lễ: vì ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Vậy, Môi-se nói lại cùng dân Y-sơ-ra-ên, biểu đem kẻ đã rủa sả ra khỏi trại quân rồi ném đá nó. Thế thì, dân Y-sơ-ra-ên làm y như lời Đức Giê-hô-va đã truyền dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Đức Giê-hô-va cũng phán cùng Môi-se tại trên núi Si-na-i rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Hãy truyền cho dân Y-sơ-ra-ên rằng: Khi các ngươi đã vào xứ ta sẽ ban cho rồi, thì đất phải nghỉ, giữ một lễ sa-bát cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Trong sáu năm, ngươi sẽ gieo ruộng và hớt nho mình, cùng thâu hoạch thổ sản. ");
INSERT INTO vie1934_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Nhưng năm thứ bảy sẽ là năm sa-bát, để cho đất nghỉ, tức là một năm sa-bát cho Đức Giê-hô-va; ngươi chẳng nên gieo ruộng mình hay là hớt nho mình; ");
INSERT INTO vie1934_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","chẳng nên gặt lại những chi đã tự mọc lên sau khi mùa màng, và đừng hái nho của vườn nho không hớt sửa: ấy sẽ là một năm cho đất nghỉ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Phàm vật gì mà đất sanh sản trong năm sa-bát, sẽ dùng làm đồ ăn cho ngươi, cho tôi trai tớ gái ngươi, cho kẻ làm thuê của ngươi, và cho kẻ ngoại bang kiều ngụ với ngươi; ");
INSERT INTO vie1934_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","cùng luôn cho lục súc và thú vật ở trong xứ ngươi nữa; hết thảy thổ sản dùng làm đồ ăn vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ngươi cũng hãy tính bảy tuần năm tức bảy lần bảy năm; thì giờ của bảy tuần năm nầy sẽ là bốn mươi chín năm; ");
INSERT INTO vie1934_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","rồi đến ngày mồng mười tháng bảy, tức là ngày chuộc tội, các ngươi phải thổi kèn vang trong khắp xứ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Các ngươi phải làm cho năm thứ năm mươi nên thánh, và rao truyền sự tự do cho hết thảy dân trong xứ. Aáy sẽ là năm hân hỉ cho các ngươi; ai nấy đều được nhận lại cơ nghiệp mình, và ai nấy đều trở về gia quyến mình. ");
INSERT INTO vie1934_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Năm thứ năm mươi nầy là một năm hân hỉ cho các ngươi, không nên gieo, không nên gặt vật chi đất tự sanh sản, và cũng chẳng nên hái nho không có hớt sửa, ");
INSERT INTO vie1934_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","vì là một năm hân hỉ, sẽ làm thánh cho các ngươi; phải ăn những thổ sản. ");
INSERT INTO vie1934_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Trong năm hân hỉ nầy, các sản nghiệp đều sẽ trở về nguyên chủ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nếu các ngươi bán hay là mua vật chi với kẻ lân cận mình, thì chớ lận anh em mình. ");
INSERT INTO vie1934_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ngươi sẽ cứ lấy số năm từ sau năm hân hỉ mà mua với kẻ lân cận mình; còn người, cứ lấy theo số năm có hoa lợi mà bán. ");
INSERT INTO vie1934_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Tùy theo số năm sau năm hân hỉ, ngươi sẽ bù thêm giá; tùy theo số năm ít, ngươi sẽ giảm bớt giá; vì theo số mùa gặt mà người bán cho ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Chớ ai trong vòng các ngươi làm lận kẻ lân cận mình; nhưng hãy kính sợ Đức Chúa Trời, vì ta là Giê-hô-va Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Các ngươi khá làm theo mạng lịnh ta, gìn giữ luật pháp ta và noi theo, như vậy sẽ được ăn ở bình yên trong xứ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Đất sẽ sanh sản hoa lợi cho các ngươi, các ngươi sẽ ăn no và được ở bình yên trong xứ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Vì các ngươi nói rằng: Nếu chúng tôi chẳng gieo, chẳng gặt mùa màng, thì trong năm thứ bảy sẽ lấy chi mà ăn? ");
INSERT INTO vie1934_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Năm thứ sáu, ta sẽ giáng phước cho các ngươi, và năm ấy sẽ trúng mùa bù ba năm. ");
INSERT INTO vie1934_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Năm thứ tám, các ngươi sẽ gieo và ăn hoa lợi của mùa màng cũ cho đến mùa màng mới của năm thứ chín. ");
INSERT INTO vie1934_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Đất không được đoạn mãi; vì đất thuộc về ta, các ngươi ở cùng ta như kẻ khách ngoại bang và kẻ kiều ngụ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Trong khắp xứ mà các ngươi sẽ được làm sản nghiệp, hãy cho phép chuộc đất lại. ");
INSERT INTO vie1934_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Nếu anh em ngươi trở nên nghèo, và bán một phần sản nghiệp mình, thì người bà con gần có quyền chuộc lại, phải đến chuộc phần đất anh em người đã bán. ");
INSERT INTO vie1934_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Nếu người nào không có ai được quyền chuộc lại, nhưng tự lo cho có chi chuộc lại được, ");
INSERT INTO vie1934_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","thì phải tính từ năm đã bán bồi số trội cho chủ mua, rồi người sẽ được nhận sản nghiệp mình lại. ");
INSERT INTO vie1934_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Nếu nguyên chủ không tìm đủ giá đặng trả cho, đất bán sẽ thuộc về người chủ mua cho đến năm hân hỉ; đoạn đất sẽ ra khỏi tay chủ mua và về nguyên chủ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Nếu người nào bán một cái nhà ở trong thành có vách bọc, thì có được phép chuộc lại cho đến giáp một năm sau khi bán; phép chuộc lại của người chỉ trong một năm trọn vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Còn nếu không chuộc lại trước khi giáp hạn một năm trọn, thì nhà ở trong thành có vách bọc đó sẽ về chủ mua và dòng dõi người mãi mãi; đến năm hân hỉ nhà đó không ra khỏi tay họ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Nhưng các nhà ở nơi hương thôn không có vách bọc lấy, thì kể như ruộng đất; chủ bán có phép chuộc lại; đến năm hân hỉ nhà sẽ về nguyên chủ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Còn về các thành của người Lê-vi, và về các nhà của họ ở trong thành đó, thì người Lê-vi luôn luôn có quyền chuộc lại. ");
INSERT INTO vie1934_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Ai mua của người Lê-vi một cái nhà tại trong thành người Lê-vi, đến năm hân hỉ nhà đó sẽ về nguyên chủ; vì các nhà cửa tại trong những thành người Lê-vi là sản nghiệp của họ giữa dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Những ruộng đất thuộc về thành người Lê-vi không phép bán, vì là nghiệp đời đời của họ. ");
INSERT INTO vie1934_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Nếu anh em ở gần ngươi trở nên nghèo khổ, tài sản người lần lần tiêu mòn, thì hãy cứu giúp người, mặc dầu là kẻ khách kiều ngụ, hầu cho người cứ ở cùng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Chớ ăn lời, cũng đừng lấy lợi người; nhưng hãy kính sợ Đức Chúa Trời mình, thì anh em ngươi sẽ ở cùng ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Chớ cho người vay bạc ăn lời và đừng cho mượn lương thực đặng lấy lời. ");
INSERT INTO vie1934_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ta là Giê-hô-va, Đức Chúa Trời các ngươi, Đấng đã đem các ngươi ra khỏi xứ Ê-díp-tô, đặng ban cho các ngươi xứ Ca-na-an, và làm Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Nếu anh em ở gần ngươi trở nên nghèo khổ, đem bán mình cho ngươi, chớ nên bắt người làm việc như tôi mọi; ");
INSERT INTO vie1934_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","người ở nhà ngươi như kẻ làm thuê, người ở đậu, sẽ giúp việc ngươi cho đến năm hân hỉ: ");
INSERT INTO vie1934_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","đoạn người và con cái người thôi ở nhà người, trở về nhà và nhận lấy sản nghiệp của tổ phụ mình. ");
INSERT INTO vie1934_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Vì ấy là những tôi tớ ta mà ta đã đem ra khỏi xứ Ê-díp-tô; không nên bán họ như người ta bán tôi mọi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ngươi chớ lấn lướt mà khắc bạc họ, nhưng phải kính sợ Đức Chúa Trời ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Còn tôi trai tớ gái thuộc về ngươi, thì sẽ do các dân chung quanh mình mà ra; ấy do nơi những dân đó mà các ngươi mua tôi trai tớ gái. ");
INSERT INTO vie1934_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Các ngươi cũng có phép mua tôi mọi trong bọn con cái của kẻ khách kiều ngụ nơi mình và của họ hàng chúng nó sanh ra trong xứ các ngươi; vậy, họ sẽ làm sản nghiệp của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Các ngươi để họ lại làm cơ nghiệp cho con cháu mình; hằng giữ họ như kẻ tôi mọi. Nhưng về phần anh em các ngươi, là dân Y-sơ-ra-ên, thì không ai nên lấn lướt mà khắc bạc anh em mình. ");
INSERT INTO vie1934_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Khi một khách ngoại bang hay là một người kiều ngụ nơi ngươi trở nên giàu, còn anh em ngươi ở cùng họ lại nên nghèo, đem bán mình cho kẻ khách ngoại bang kiều ngụ nơi ngươi, hay là cho một người nào trong nhà kẻ khách ngoại bang ấy, ");
INSERT INTO vie1934_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","sau khi đã đem bán mình rồi, thì sẽ có phép chuộc lại: một anh em người được chuộc người lại, ");
INSERT INTO vie1934_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","hoặc bác chú, hoặc con của bác chú; hoặc một người thân thích cũng được chuộc người lại; hay là nếu người có thế, thì chính người phải chuộc mình lấy. ");
INSERT INTO vie1934_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Người sẽ tính cùng chủ mua từ năm nào mình đã bán mình cho đến năm hân hỉ; và giá bán sẽ tính theo số năm nhiều hay ít: tức là tính như ngày công của người làm thuê vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Nếu còn nhiều năm thì hãy cứ số năm nầy, cân phân theo giá đã bán mình mà chuộc lại; ");
INSERT INTO vie1934_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","nếu đến năm hân hỉ còn ít năm, thì hãy tính với chủ mua cứ theo số năm nầy mà thối hồi số mua mình lại. ");
INSERT INTO vie1934_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Họ đối cùng chủ như một người làm thuê năm, chủ không nên lấn lướt mà khắc bạc người trước mặt ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nếu người không được chuộc lại bởi các thế ấy, đến năm hân hỉ người và các con trai người sẽ được ra tự do. ");
INSERT INTO vie1934_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Vì dân Y-sơ-ra-ên là tôi tớ ta, tức các tôi tớ ta đã đem ra khỏi xứ Ê-díp-tô. Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Các ngươi chớ làm những hình tượng; hoặc hình chạm, hoặc hình đúc; chớ dựng trong xứ mình một hòn đá nào có dạng-hình, đặng sấp mình trước mặt hình đó, vì ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Hãy giữ lễ sa-bát ta, và tôn kính nơi thánh ta. Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Nếu các ngươi tuân theo luật pháp ta, gìn giữ các điều răn ta và làm theo, ");
INSERT INTO vie1934_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","thì ta sẽ giáng mưa thuận-thì, đất sẽ sanh hoa lợi, và cây ngoài đồng sẽ kết bông trái. ");
INSERT INTO vie1934_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mùa đập lúa sẽ lần đến mùa hái nho, mùa hái nho sẽ lần đến mùa gieo mạ; các ngươi sẽ ăn no, ở bình yên trong xứ mình. ");
INSERT INTO vie1934_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Ta sẽ giáng sự bình tịnh trong nước, các ngươi ngủ không sợ ai dọa; ta sẽ diệt những loài thú dữ khỏi xứ, gươm giáo chẳng đưa qua xứ các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Các ngươi đuổi theo quân nghịch, họ sẽ bị gươm sa ngã trước mặt các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Năm người trong các ngươi sẽ đuổi theo một trăm; một trăm trong các ngươi sẽ đuổi theo một muôn, và quân nghịch sẽ bị gươm sa ngã trước mặt các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ta sẽ đoái lại cùng các ngươi, làm cho sanh sản và thêm nhiều, cùng kết lập giao ước với các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Các ngươi sẽ ăn hoa lợi cũ mình, và đem cái cũ ra đặng chừa chỗ cho cái mới. ");
INSERT INTO vie1934_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ta sẽ lập chỗ ở ta giữa các ngươi, tâm hồn ta không hề ghê gớm các ngươi đâu. ");
INSERT INTO vie1934_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ta sẽ đi giữa các ngươi, làm Đức Chúa Trời các ngươi, và các ngươi sẽ làm dân ta. ");
INSERT INTO vie1934_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ta là Giê-hô-va, Đức Chúa Trời của các ngươi, Đấng đã đem các ngươi ra khỏi xứ Ê-díp-tô, hầu cho khỏi làm tôi mọi. Ta đã bẻ gãy cái ách của các ngươi, làm cho các ngươi đi ngước đầu lên. ");
INSERT INTO vie1934_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Song nếu các ngươi không nghe ta, không làm theo các điều răn nầy, ");
INSERT INTO vie1934_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","nếu khinh bỉ mạng lịnh ta, và tâm hồn các ngươi nghịch cùng luật pháp ta, đến nỗi không làm theo những điều răn ta, mà bội sự giao ước ta, ");
INSERT INTO vie1934_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","thì nầy là những điều ta sẽ giáng cho các ngươi: Ta sẽ giáng cho các ngươi sự kinh khủng, bịnh tổn và rét làm hư mòn con mắt và nhọc mệt tâm hồn. Các ngươi gieo mạ luống công, quân thù nghịch sẽ ăn hết. ");
INSERT INTO vie1934_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ta sẽ nổi giận cùng các ngươi; các ngươi sẽ bị quân thù nghịch đánh đập; kẻ nào ghét các ngươi sẽ lấn lướt các ngươi, và các ngươi sẽ chạy trốn không ai đuổi theo. ");
INSERT INTO vie1934_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Nếu đến đỗi vậy mà các ngươi không khứng nghe ta, ta sẽ vì cớ tội phạm, thêm gấp bảy lần đặng sửa phạt các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","và ta sẽ dẹp sự kiêu ngạo về năng lực các ngươi. Ta sẽ khiến trời các ngươi cứng như sắt và đất trơ như đồng; ");
INSERT INTO vie1934_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","năng lực mình hao mòn vô ích, đất không sanh sản huê lợi, cây cối không kết bông trái. ");
INSERT INTO vie1934_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Nếu các ngươi phản đối cùng ta, và không muốn nghe ta, thì ta sẽ tùy theo tội phạm giáng tai vạ trên các ngươi gấp bảy lần nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ta sẽ sai những thú đồng đến tha con cái các ngươi đi, ăn hại súc vật, diệt số người ra ít; và đường nẻo các ngươi sẽ vắng tanh. ");
INSERT INTO vie1934_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Dẫu đến những việc ấy mà các ngươi cứ không phục sự sửa phạt ta, cứ phản đối cùng ta, ");
INSERT INTO vie1934_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","thì ta đây cũng sẽ nghịch lại cùng các ngươi, và vì cớ tội lỗi, sẽ giáng tai vạ cho các ngươi gấp bảy lần nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ta sẽ khiến gươm giáo đến trên các ngươi đặng báo thù sự giao ước ta; khi các ngươi hội hiệp trong những thành mình, ta sẽ giáng dịch hạch đến giữa các ngươi, và nộp các ngươi vào tay thù nghịch. ");
INSERT INTO vie1934_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Khi ta dẫn sự đói kém đến, mười người nữ sẽ nướng bánh của các ngươi trong một lò, cân bánh trao lại cho các ngươi; các ngươi sẽ ăn mà không no. ");
INSERT INTO vie1934_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Dẫu đến nỗi vậy, mà các ngươi cứ không khứng nghe ta, còn phản đối cùng ta, ");
INSERT INTO vie1934_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","thì ta cũng sẽ nghịch lại cùng các ngươi cách giận dữ, và vì cớ tội lỗi các ngươi, sẽ sửa phạt gấp bảy lần nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Các ngươi sẽ ăn thịt con trai con gái mình; ");
INSERT INTO vie1934_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ta sẽ hủy diệt những nơi cao các ngươi, phá đổ những hình mặt trời, và để thây các ngươi chồng trên thây của hình tượng mình, tâm hồn ta sẽ ghê gớm các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ta sẽ làm cho thành các ngươi ra vắng vẻ, các nơi thánh quạnh hiu, và ta chẳng còn hưởng mùi thơm về của lễ các ngươi nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ta sẽ làm xứ ra đồi bại, đến đỗi kẻ thù nghịch ở tại đó cũng lấy làm lạ. ");
INSERT INTO vie1934_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ta sẽ tản lạc các ngươi trong các dân và rút gươm ra đuổi theo sau các ngươi: xứ các ngươi sẽ hoang vu, thành sẽ vắng vẻ. ");
INSERT INTO vie1934_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Trọn trong lúc đất bỏ hoang vu, và các ngươi ở trong đất của kẻ thù nghịch, khi đó đất sẽ được an nghỉ hưởng những năm sa-bát. ");
INSERT INTO vie1934_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Trọn lúc đất bỏ hoang vu sẽ được an nghỉ; vì lúc các ngươi còn ở đất đó, nó không được an nghỉ trong những năm sa-bát của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Còn ai trong các ngươi sống sót lại, ta sẽ làm cho họ nhát gan trong xứ của thù nghịch mình; tiếng lá khua sẽ làm cho họ chạy trốn, khác nào chạy trốn trước lưỡi gươm, té ngã mà không ai đuổi theo. ");
INSERT INTO vie1934_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Người nầy vấp ngã trên người kia như trước ngọn gươm, vốn chẳng ai rượt đuổi theo họ; các ngươi không thể chịu nổi trước mặt quân thù nghịch mình. ");
INSERT INTO vie1934_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Các ngươi sẽ bị chết mất giữa các dân, đất kẻ thù nghịch sẽ nuốt các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ai trong các ngươi còn sống, sẽ vì cớ gian ác mình và gian ác của tổ phụ mà hao mòn trong xứ kẻ thù nghịch mình. ");
INSERT INTO vie1934_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Khi ấy, họ sẽ nhận gian ác mình, và gian ác của tổ phụ mình, những tội lỗi họ đã phạm, và sự chống trả họ đã cự cùng ta, ");
INSERT INTO vie1934_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","đến đỗi ta cũng chống trả lại, dẫn họ vào xứ kẻ thù nghịch. Bấy giờ nếu lòng không chịu cắt bì của họ sẽ tự hạ mình xuống, và sẽ phục điều sửa phạt về gian ác mình, ");
INSERT INTO vie1934_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","thì ta sẽ nhớ lại sự giao ước ta đã lập cùng Gia-cốp, cùng Y-sác, cùng Aùp-ra-ham, và ta sẽ nhớ lại xứ nầy. ");
INSERT INTO vie1934_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Vì xứ bị họ bỏ hoang sẽ được nghỉ bấy nhiêu năm sa-bát tùy theo họ bỏ hoang vu bao nhiêu: họ sẽ chịu hình phạt của gian ác mình, bởi vì đã khinh bỉ mạng lịnh ta, và tâm hồn họ đã lấy làm ghê gớm các luật pháp ta. ");
INSERT INTO vie1934_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Dẫu vậy, đang khi họ bị ở trong xứ kẻ thù nghịch mình, ta cũng chẳng bỏ họ đâu, chẳng ghê gớm họ đến phải hao mòn hết, và chẳng bội sự giao ước ta lập cùng họ đâu, vì ta là Giê-hô-va, Đức Chúa Trời của họ. ");
INSERT INTO vie1934_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ta vì họ sẽ nhớ lại sự giao ước đã lập cùng tổ phụ họ mà ta đã đem ra khỏi xứ Ê-díp-tô trước mặt các dân, đặng làm Đức Chúa Trời của họ. Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Đó là các điều lệ, mạng lịnh, và luật pháp mà Đức Giê-hô-va nhờ Môi-se, lập ra giữa ngài cùng dân Y-sơ-ra-ên, tại trên núi Si-nai-i. ");
INSERT INTO vie1934_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Hãy truyền cho dân Y-sơ-ra-ên rằng: Khi nào có ai dùng loài người mà khấn nguyện, thì ngươi hãy định giá cho; giá đó thuộc về Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Nếu ngươi định giá về một người nam từ hai mươi đến sáu mươi tuổi, thì hãy định cho năm chục siếc-lơ bạc, tùy theo siếc-lơ nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nếu là một người nữ, hãy định giá ba chục siếc-lơ bạc. ");
INSERT INTO vie1934_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Nếu là một đứa con trẻ từ năm đến hai mươi tuổi, thì hãy định giá hai chục siếc-lơ cho một đứa trai, và mười siếc-lơ cho một đứa gái. ");
INSERT INTO vie1934_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ví bằng một đứa trẻ từ một tháng đến năm tuổi, thì hãy định giá năm siếc-lơ bạc cho một đứa trai, và ba siếc-lơ bạc cho một đứa gái. ");
INSERT INTO vie1934_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Nếu một người già cả từ sáu mươi tuổi trở lên, ngươi hãy định giá mười lăm siếc-lơ bạc cho một người nam, và mười siếc-lơ bạc cho một người nữ. ");
INSERT INTO vie1934_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Bằng người khấn nguyện rất nghèo khổ, không nộp được giá tiền ngươi định, thì hãy đem đến trước mặt thầy tế lễ cho người nhất định cho. Thầy tế lễ sẽ tùy theo phương thế người khấn nguyện mà nhất định giá vậy. ");
INSERT INTO vie1934_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Nếu khấn nguyện về thú vật dùng làm của lễ dâng cho Đức Giê-hô-va, thì hễ con thú nào dâng cho Đức Giê-hô-va sẽ là vật thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Người ta không nên đổi hay là thế một con tốt cho một con xấu, hay là một con xấu cho một con tốt. Nếu thế một con nào cho một con khác, thì con nầy và con thế đều sẽ nên vật thánh. ");
INSERT INTO vie1934_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Nếu là thú vật ô uế không phép dùng làm của lễ dâng cho Đức Giê-hô-va, thì phải đem con thú đó đến trước mặt thầy tế lễ, ");
INSERT INTO vie1934_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","rồi thầy tế lễ sẽ tùy theo con thú xấu hay tốt mà định giá. Họ sẽ theo giá định của thầy tế lễ mà trả. ");
INSERT INTO vie1934_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Còn nếu muốn chuộc lại, thì phải phụ thêm một phần năm giá của ngươi định. ");
INSERT INTO vie1934_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Nếu ai biệt nhà mình ra thánh cho Đức Giê-hô-va, thì thầy tế lễ sẽ tùy theo nhà tốt hay xấu mà định giá; họ phải nhận lấy giá của thầy tế lễ đã định. ");
INSERT INTO vie1934_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Còn nếu kẻ đã biệt nhà mình ra thánh muốn chuộc nó lại, thì phải phụ thêm một phần năm giá ngươi đã định, rồi nhà sẽ thuộc về người. ");
INSERT INTO vie1934_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Nếu ai biệt một phần ruộng tổ nghiệp mình ra thánh cho Đức Giê-hô-va, thì ngươi hãy định giá tùy theo số họ gieo, nghĩa là cứ năm chục siếc-lơ bạc mỗi một ô-me mạch nha giống. ");
INSERT INTO vie1934_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Nếu biệt ruộng mình ra thánh từ năm hân hỉ, họ sẽ nhận giá ngươi định; ");
INSERT INTO vie1934_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","còn nếu họ biệt ruộng mình ra thánh sau năm hân hỉ, thì thầy tế lễ cứ theo số năm còn lại đến năm hân hỉ mà định giá ruộng, và trừ lại giá ngươi định. ");
INSERT INTO vie1934_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Nếu ngươi đã biệt ruộng mình ra thánh muốn chuộc nó lại, thì phải phụ thêm một phần năm giá ngươi định, rồi ruộng sẽ thuộc về người. ");
INSERT INTO vie1934_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Còn ví ngươi không chuộc lại, và người ta bán ruộng cho người khác, thì không được chuộc lại nữa. ");
INSERT INTO vie1934_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Khi đến năm hân hỉ, ruộng ra khỏi tay chủ mua, thì sẽ trở nên thánh, biệt riêng ra cho Đức Giê-hô-va như một sở ruộng cấm: nó sẽ làm sản nghiệp cho thầy tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Nếu ai biệt ra thánh cho Đức Giê-hô-va một sở ruộng mình mua, chớ chẳng phải của tổ nghiệp, ");
INSERT INTO vie1934_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","thì thầy tế lễ sẽ tùy theo giá ngươi định mà đánh giá đến năm hân hỉ, rồi chính trong ngày đó, người nầy phải nộp số tiền nhất định, vì là một vật biệt riêng ra thánh cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Năm hân hỉ, ruộng đó sẽ trở về chủ bán, tức là trở về nguyên chủ. ");
INSERT INTO vie1934_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Vả, phàm các giá định đều cứ theo siếc-lơ nơi thánh: một siếc-lơ giá hai chục ghê-ra. ");
INSERT INTO vie1934_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Song không ai được biệt ra thánh con đầu lòng của súc vật mình, hoặc bò, hoặc chiên, vì các con đầu lòng theo phép đã thuộc về Đức Giê-hô-va rồi. ");
INSERT INTO vie1934_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Còn nếu là một con thú không sạch, họ phải tùy theo giá ngươi định, phụ thêm một phần năm mà chuộc nó lại; nếu con thú chẳng chuộc lại, thì phải đem bán tùy theo giá định của ngươi. ");
INSERT INTO vie1934_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Phàm vật cấm, tức là hết thảy vật chi mà một người hằng dâng cho Đức Giê-hô-va do những của mình có, hoặc người, hoặc loài vật, hoặc ruộng tổ nghiệp, thì chẳng được phép bán, cũng không được phép chuộc lại; hễ vật gì cấm, thì biệt ra chí thánh cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Hễ ai đã bị phú cho Đức Giê-hô-va, thì không được phép chuộc lại, họ hẳn phải bị giết. ");
INSERT INTO vie1934_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Phàm thuế một phần mười thổ sản, bất k” vật gieo hay là hoa quả của cây, đều thuộc về Đức Giê-hô-va; ấy là một vật thánh, biệt riêng ra cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Nếu ai muốn chuộc lại vật chi về một phần mười của mình, thì phải phụ thêm một phần năm. ");
INSERT INTO vie1934_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Còn về một phần mười của bầy bò hay là chiên, tức là mọi vật chi đi ngang dưới gậy, con thứ mười sẽ là thánh, biệt riêng ra thánh cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Họ không nên phân biệt con tốt hay là con xấu, và cũng không nên đổi. Nếu đổi, thì con thú bị đổi, và con đổi, cả hai đều biệt riêng ra thánh: không phép chuộc nó lại. ");
INSERT INTO vie1934_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Đó là các mạng lịnh mà Đức Giê-hô-va truyền cho Môi-se về dân Y-sơ-ra-ên tại trên núi Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ngày mồng một tháng hai, năm thứ hai, sau khi dân Y-sơ-ra-ên ra khỏi xứ Ê-díp-tô, Đức Giê-hô-va phán cùng Môi-se ở trong hội mạc, tại đồng vắng Si-na-i, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Hãy dựng sổ cả hội dân Y-sơ-ra-ên, theo họ hàng và tông tộc của họ, cứ đếm từng tên của hết thảy nam đinh, ");
INSERT INTO vie1934_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","từ hai mươi tuổi sắp lên, tức là mọi người trong Y-sơ-ra-ên đi ra trận được; ngươi và A-rôn sẽ kê sổ chúng nó tùy theo đội ngũ của họ. ");
INSERT INTO vie1934_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Trong mỗi chi phái phải có một người giúp đỡ các ngươi, tức là người làm tộc trưởng của chi phái mình. ");
INSERT INTO vie1934_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Đây là tên những người sẽ giúp đỡ các ngươi: Về chi phái Ru-bên, Ê-lít-su, con trai của Sê-đêu; ");
INSERT INTO vie1934_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","về chi phái Si-mê-ôn, Sê-lu-mi-ên, con trai của Xu-ri-ha-đai; ");
INSERT INTO vie1934_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","về chi phái Giu-đa, Na-ha-sôn, con trai của A-mi-na-đáp; ");
INSERT INTO vie1934_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","về chi phái Y-sa-ca, Na-tha-na-ên, con trai của Xu-a; ");
INSERT INTO vie1934_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","về chi phái Sa-bu-lôn, Ê-li-áp, con trai của Hê-lôn; ");
INSERT INTO vie1934_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","về con cháu Giô-sép, nghĩa là về chi phái Eùp-ra-im, Ê-li-sa-ma, con trai của A-mi-hút; về chi phái Ma-na-se, Ga-ma-li-ên, con trai của Phê-đát-su; ");
INSERT INTO vie1934_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","về chi phái Bên-gia-min, A-bi-đan, con trai của Ghi-đeo-ni; ");
INSERT INTO vie1934_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","về chi phái Đan, A-hi-ê-xe, con trai của A-mi-sa-đai; ");
INSERT INTO vie1934_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","về chi phái A-se, Pha-ghi-ên, con trai của Oùc-ran; ");
INSERT INTO vie1934_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","về chi phái Gát, Ê-li-a-sáp, con trai của Đê-u-ên; ");
INSERT INTO vie1934_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","về chi phái Nép-ta-li, A-hi-ra, con trai của Ê-nan. ");
INSERT INTO vie1934_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Đó là những người được gọi từ trong hội chúng, vốn là quan trưởng của các chi phái tổ phụ mình, và là quan tướng quân đội Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Vậy, Môi-se và A-rôn nhận lấy các người ấy mà đã được xướng tên; ");
INSERT INTO vie1934_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","đến ngày mồng một tháng hai, truyền nhóm cả hội chúng, cứ kể tên từng người từ hai mươi tuổi sắp lên mà nhập sổ theo họ hàng và tông tộc của họ. ");
INSERT INTO vie1934_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Vậy, Môi-se kê sổ chúng nó tại đồng vắng Si-na-i, y như Đức Giê-hô-va đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Con cháu Ru-bên, là trưởng nam của Y-sơ-ra-ên, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên của hết thảy nam đinh từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Ru-bên đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","số là bốn mươi sáu ngàn năm trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Con cháu Si-mê-ôn, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên của hết thảy nam đinh từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Si-mê-ôn đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","số là năm mươi chín ngàn ba trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Con cháu Gát, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Gát đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","số là bốn mươi lăm ngàn sáu trăm năm mươi. ");
INSERT INTO vie1934_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Con cháu Giu-đa, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Giu-đa đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","số là bảy mươi bốn ngàn sáu trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Con cháu của Y-sa-ca, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Y-sa-ca đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","số là năm mươi bốn ngàn bốn trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Con cháu của Sa-bu-lôn, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Sa-bu-lôn đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","số là năm mươi bảy ngàn bốn trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Về hậu tự Giô-sép, là con cháu Eùp-ra-im, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Eùp-ra-im đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","số là bốn mươi ngàn năm trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Con cháu Ma-na-se, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Ma-na-se đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","số là ba mươi hai ngàn hai trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Con cháu Bên-gia-min, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Bên-gia-min đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","số là ba mươi lăm ngàn bốn trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Con cháu Đan, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Đan đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","số là sáu mươi hai ngàn bảy trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Con cháu A-se, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái A-se đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","số là bốn mươi mốt ngàn năm trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Con cháu Nép-ta-li, dòng dõi họ tùy theo họ hàng và tông tộc mình, cứ kể từng tên, từ hai mươi tuổi sắp lên, tức là mọi người trong chi phái Nép-ta-li đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","số là năm mươi ba ngàn bốn trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Đó là những người mà Môi-se, A-rôn, và mười hai quan trưởng Y-sơ-ra-ên kê sổ; mỗi quan trưởng kê sổ cho tông tộc mình. ");
INSERT INTO vie1934_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Thế thì, hết thảy những người trong dân Y-sơ-ra-ên đã được nhập sổ tùy theo tông tộc mình, từ hai mươi tuổi sắp lên, tức là mọi người trong Y-sơ-ra-ên đi ra trận được, ");
INSERT INTO vie1934_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","số là sáu trăm ba ngàn năm trăm năm mươi. ");
INSERT INTO vie1934_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Nhưng người Lê-vi, theo chi phái tổ phụ mình, không kê sổ chung với những chi phái khác. ");
INSERT INTO vie1934_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Vì Đức Giê-hô-va có phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Ngươi chớ kê sổ chi phái Lê-vi, và cũng đừng dựng bộ họ chung với dân Y-sơ-ra-ên; ");
INSERT INTO vie1934_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","nhưng hãy cắt phần người Lê-vi coi sóc đền tạm chứng cớ, hết thảy đồ đạc và các món thuộc về đền tạm. Aáy là người Lê-vi sẽ chuyên-vận đền tạm và hết thảy đồ đạc nó, cùng sẽ làm công việc về đền tạm và đóng trại ở chung quanh đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Khi nào đền tạm dời chỗ, thì người Lê-vi sẽ tháo dỡ nó; khi nào đền tạm dừng lại, thì họ sẽ dựng nó lên; còn người ngoại đến gần sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Dân Y-sơ-ra-ên mỗi người phải đóng ở trong trại quân mình, và mỗi trại quân, từng đội ngũ, phải đóng gần bên ngọn cờ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Nhưng người Lê-vi sẽ đóng trại chung quanh đền tạm chứng cớ, để đừng có sự giận dữ cùng hội-dân Y-sơ-ra-ên; người Lê-vi sẽ coi sóc đền tạm chứng cớ. ");
INSERT INTO vie1934_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Dân Y-sơ-ra-ên làm y như mọi điều Đức Giê-hô-va đã phán dặn Môi-se vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Dân Y-sơ-ra-ên mỗi người phải đóng trại gần bên ngọn cờ mình, ở dưới bảng hiệu của tông tộc mình, đối ngang nhau vây chung quanh hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Trại quân Giu-đa sẽ đóng tại hướng đông, về phía mặt trời mọc, với ngọn cờ và những đội ngũ của mình. Quan trưởng của người Giu-đa là Na-ha-sôn, con trai của A-mi-na-đáp; ");
INSERT INTO vie1934_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","và quân đội người, cứ theo kê sổ, cọng bảy mươi bốn ngàn sáu trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Chi phái Y-sa-ca phải đóng trại bên Giu-đa; quan trưởng của người Y-sa-ca là Na-tha-na-ên, con trai Xu-a; ");
INSERT INTO vie1934_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","và quân đội người, cứ theo kê sổ, cọng năm mươi bốn ngàn bốn trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Kế đến chi phái Sa-bu-lôn; quan trưởng của người Sa-bu-lôn là Ê-li-áp, con trai của Hê-lôn, ");
INSERT INTO vie1934_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","và quân đội người, cứ theo kê sổ, cộng năm mươi bảy ngàn bốn trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Vậy, các người đã kê sổ theo trại quân Giu-đa, từng đội ngũ, cộng một trăm tám mươi sáu ngàn bốn trăm người. Họ phải đi tiên phong. ");
INSERT INTO vie1934_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ngọn cờ của trại quân Ru-bên và những đội ngũ mình, phải đóng về hướng nam. Quan trưởng của người Ru-bên là Ê-li-su, con trai của Sê-đêu; ");
INSERT INTO vie1934_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","và quân đội người, cứ theo kê sổ, cộng bốn mươi sáu ngàn năm trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Chi phái Si-mê-ôn phải đóng trại bên Ru-bên; quan trưởng của người Si-mê-ôn là Sê-lu-mi-ên, con trai của Xu-ri-ha-đai; ");
INSERT INTO vie1934_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","và quân đội người, cứ theo kê sổ, cộng năm mươi chín ngàn ba trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Kế đến chi phái Gát; các quan trưởng của người Gát là Ê-li-a-sáp, con trai của Rê-u-ên; ");
INSERT INTO vie1934_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","và quân đội người, cứ theo kê sổ, cộng bốn mươi lăm ngàn sáu trăm năm mươi người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Vậy, các người đã kê sổ theo trại quân Ru-bên, từng đội ngũ, cộng một trăm năm mươi mốt ngàn bốn trăm năm mươi người. Họ phải đi thứ nhì. ");
INSERT INTO vie1934_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sau ấy, hội mạc sẽ đi với trại quân Lê-vi, ở giữa các trại quân khác; trại quân Lê-vi sẽ đi theo thứ tự như đã đóng, mỗi người theo hàng ngũ và theo ngọn cờ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ngọn cờ của trại quân Eùp-ra-im và những quân đội người phải đóng về hướng tây; quan trưởng của người Eùp-ra-im là Ê-li-sa-ma, con trai A-mi-hút; ");
INSERT INTO vie1934_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","và quân đội người, cứ theo kê sổ, cộng bốn mươi ngàn năm trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Chi phái Ma-na-se phải đóng trại bên Eùp-ra-im; quan trưởng của người Ma-na-se là Ga-ma-li-ên, con trai của Phê-đát-su; ");
INSERT INTO vie1934_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","và quân đội người, cứ theo kê sổ, cộng ba mươi hai ngàn hai trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Kế đến chi phái Bên-gia-min; quan trưởng của người Bên-gia-min là A-bi-đan, con trai của Ghi-đeo-ni; ");
INSERT INTO vie1934_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","và quân đội người, cứ theo kê sổ, cộng ba mươi lăm ngàn bốn trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Vậy, các người đã kê sổ theo trại quân Eùp-ra-im, từng đội ngũ, cộng một trăm tám ngàn một trăm người. Họ phải đi thứ ba. ");
INSERT INTO vie1934_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ngọn cờ của trại quân Đan và những quân đội họ phải đóng về hướng bắc. Quan trưởng của người Đan là A-hi-ê-xe, con trai của A-mi-sa-đai; ");
INSERT INTO vie1934_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","và quân đội người, cứ theo kê sổ, cộng sáu mươi hai ngàn bảy trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Chi phái A-se phải đóng trại bên Đan; quan trưởng của người A-se là Pha-ghi-ên, con trai của Oùc-ran; ");
INSERT INTO vie1934_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","và quân đội người, cứ theo kê sổ, cộng bốn mươi mốt ngàn năm trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Kế đến chi phái Nép-ta-li; quan trưởng của người Nép-ta-li là A-hi-ra, con trai của Ê-nan; ");
INSERT INTO vie1934_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","và quân đội người, cứ theo kê sổ, cộng năm mươi ba ngàn bốn trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Vậy, các người đã kê sổ theo trại quân Đan, cộng một trăm năm mươi bảy ngàn sáu trăm người. Họ theo ngọn cờ mình phải đi hậu binh. ");
INSERT INTO vie1934_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Đó là những người trong dân Y-sơ-ra-ên mà người ta tu bộ tùy theo tông tộc mình. Trong các trại quân hết thảy người đã kê sổ từng đội ngũ là sáu trăm ba ngàn năm trăm năm mươi người. ");
INSERT INTO vie1934_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Nhưng người Lê-vi không nhập sổ chung với dân Y-sơ-ra-ên, tùy theo mạng của Đức Giê-hô-va đã truyền cho Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Dân Y-sơ-ra-ên y theo mọi điều Đức Giê-hô-va đã phán dặn Môi-se, bèn đóng trại tùy theo ngọn cờ mình, và mỗi người ra đi tùy theo họ hàng và tông tộc mình. ");
INSERT INTO vie1934_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Nầy là dòng dõi của A-rôn và Môi-se, về ngày Đức Giê-hô-va phán cùng Môi-se tại trên núi Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Nầy là tên các con trai A-rôn: Trưởng nam là Na-đáp, A-bi-hu, Ê-lê-a-sa, và Y-tha-ma. ");
INSERT INTO vie1934_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Đó là tên các con trai A-rôn, tức những thầy tế lễ đã chịu phép xức dầu, và được lập lên để làm chức tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Vả, Na-đáp và A-bi-hu đã thác trước mặt Đức Giê-hô-va khi hai người dâng một thứ lửa lạ trước mặt Đức Giê-hô-va tại trong đồng vắng Si-na-i. Hai người nầy không có con. Còn Ê-lê-a-sa và Y-tha-ma làm chức tế lễ trước mặt A-rôn, là cha mình. ");
INSERT INTO vie1934_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Đức Giê-hô-va bèn phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Hãy khiến chi phái Lê-vi lại gần, đặt trước thầy tế lễ A-rôn, để người Lê-vi phục sự người. ");
INSERT INTO vie1934_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Người Lê-vi sẽ giữ chức phận của người và chức phận của cả hội chúng về trước hội mạc mà làm những công việc của đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Cũng phải coi sóc hết thảy đồ đạc của hội mạc và mọi vật chi dân Y-sơ-ra-ên giao cho đặng dùng làm công việc của đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Vậy, ngươi phải giao người Lê-vi cho A-rôn và cho các con trai người; vì đã lấy họ từ trong vòng dân Y-sơ-ra-ên mà ban trọn cho A-rôn rồi. ");
INSERT INTO vie1934_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Vậy, ngươi sẽ lập A-rôn và các con trai người, để làm chức tế lễ; người ngoại đến gần sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Nầy, từ giữa dân Y-sơ-ra-ên ta chọn lấy người Lê-vi thế cho hết thảy con đầu lòng của dân Y-sơ-ra-ên; vậy, người Lê-vi sẽ thuộc về ta. ");
INSERT INTO vie1934_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Vì hết thảy con đầu lòng đều thuộc về ta; ngày xưa khi ta hành hại các con đầu lòng trong xứ Ê-díp-tô, ta đã biệt riêng ra thánh cho ta hết thảy con đầu lòng trong Y-sơ-ra-ên, bất luận loài người hay thú vật; chúng nó đều sẽ thuộc về ta. Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Đức Giê-hô-va lại phán cùng Môi-se tại trong đồng vắng Si-na-i mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Hãy kê sổ con cháu Lê-vi, tùy theo tông tộc và họ hàng chúng nó, kê hết thảy nam đinh từ một tháng sắp lên. ");
INSERT INTO vie1934_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Môi-se bèn kê sổ người Lê-vi theo mạng của Đức Giê-hô-va, y như Ngài đã phán dặn người vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Đây là các con trai của Lê-vi kể từng tên: Ghẹt-sôn, Kê-hát, và Mê-ra-ri. ");
INSERT INTO vie1934_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Đây là tên của các con trai Ghẹt-sôn, tùy theo họ hàng mình: Líp-ni và Si-mê-y. ");
INSERT INTO vie1934_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Đây là các con trai của Kê-hát tùy theo họ hàng mình: Am-ram, Dít-sa, Hếp-rôn và U-xi-ên; ");
INSERT INTO vie1934_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","và các con trai của Mê-ra-ri, tùy theo họ hàng mình, là: Mách-li và Mu-si. Đó là những họ hàng của người Lê-vi, tùy theo tông tộc của họ. ");
INSERT INTO vie1934_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Họ hàng Líp-ni và họ hàng Si-mê-y thuộc về Ghẹt-sôn. Đó là hai họ hàng của Ghẹt-sôn vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Những người trong họ Ghẹt-sôn được tu bộ, kể mọi nam đinh từ một tháng sắp lên, số là bảy ngàn năm trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Các họ hàng của Ghẹt-sôn đóng trại về phía tây, sau đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Quan trưởng của tông tộc Ghẹt-sôn là Ê-li-a-sáp, con trai của La-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Chức phận của con cháu Ghẹt-sôn trong hội mạc là coi sóc mọi vật chi can đến đền tạm và Trại, tức là tấm bong của Trại và bức màn của cửa hội mạc, ");
INSERT INTO vie1934_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","các bố vi của hành lang, và bức màn của cửa hành lang bao phủ chung quanh đền tạm và bàn thờ, cùng dây chạc về các việc của đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Họ hàng Am-ram, họ hàng Dít-sa, họ hàng Hếp-rôn và họ hàng U-xi-ên thuộc về Kê-hát. Đó là những họ hàng của Kê-hát. ");
INSERT INTO vie1934_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Cứ kể mọi nam đinh từ một tháng sắp lên, số là tám ngàn sáu trăm người có chức phận săn sóc nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Các họ hàng của con cháu Kê-hát đóng trại bên hông đền tạm về phía nam. ");
INSERT INTO vie1934_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Quan trưởng của tông tộc Kê-hát là Ê-li-sa-phan, con trai của U-xi-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Người Kê-hát coi sóc hòm bảng chứng, cái bàn, chân đèn, các bàn thờ, và những đồ đạc của nơi thánh để dùng về việc thờ phượng, luôn với bức màn và các vật chi can đến. ");
INSERT INTO vie1934_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Tổng trưởng của người Lê-vi là Ê-lê-a-sa, con trai của thầy tế lễ A-rôn, được đặt lên quản trị những người coi sóc nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Họ hàng Mách-li và họ hàng Mu-si thuộc về Mê-ra-ri. Đó là hai họ hàng của Mê-ra-ri vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Những người trong bọn Mê-ra-ri được tu bộ, kể mọi nam đinh từ một tháng sắp lên, số là sáu ngàn hai trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Quan trưởng của tông tộc Mê-ra-ri là Xu-ri-ên, con trai của A-bi-hai. Con cháu Mê-ra-ri đóng trại bên hông đền tạm về phía bắc, ");
INSERT INTO vie1934_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","có phần coi sóc các tấm ván của đền tạm, cây xà ngang, trụ, lỗ trụ, những đồ đạc, và mọi việc thuộc về đó, ");
INSERT INTO vie1934_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","những trụ ở chung quanh hành lang và lỗ trụ, những nọc và dây chạc của trụ. ");
INSERT INTO vie1934_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Những người đóng trại trước đền tạm về phía đông, tức trước hội mạc về phía mặt trời mọc, là Môi-se, A-rôn và các con trai người, có chức phận săn sóc nơi thánh thế cho dân Y-sơ-ra-ên. Người ngoại đến gần sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Hết thảy người Lê-vi mà Môi-se và A-rôn vâng mạng Đức Giê-hô-va tu bộ, tùy theo họ hàng của họ, kể mọi nam đinh từ một tháng sắp lên, số là hai mươi hai ngàn người. ");
INSERT INTO vie1934_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: Hãy kê sổ hết thảy con trưởng nam của dân Y-sơ-ra-ên, từ một tháng sắp lên, và hãy dựng sổ tên chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ta là Đức Giê-hô-va. Ngươi phải chọn lấy cho ta người Lê-vi thế cho các con trưởng nam trong dân Y-sơ-ra-ên; cũng phải bắt súc vật của người Lê-vi thế cho mọi con súc vật đầu lòng của dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Vậy, Môi-se kê sổ các con trưởng nam của dân Y-sơ-ra-ên, y như Đức Giê-hô-va đã phán dặn người. ");
INSERT INTO vie1934_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Hết thảy những con trưởng nam kể từng tên, từ tuổi một tháng sắp lên, theo sự kê sổ họ, là hai mươi hai ngàn hai trăm bảy mươi ba người. ");
INSERT INTO vie1934_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Hãy chọn lấy những người Lê-vi thế cho hết thảy con trưởng nam của dân Y-sơ-ra-ên, và súc vật của người Lê-vi thế cho súc vật của dân Y-sơ-ra-ên; vậy, các người Lê-vi sẽ thuộc về ta. Ta là Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Còn về sự chuộc lại con trưởng nam của dân Y-sơ-ra-ên, kê sổ hơn số người Lê-vi hai trăm bảy mươi ba, ");
INSERT INTO vie1934_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","thì ngươi phải thâu mỗi người năm siếc-lơ, tùy theo siếc-lơ nơi thánh; một siếc-lơ là hai chục ghê-ra. ");
INSERT INTO vie1934_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ngươi phải giao bạc cho A-rôn và các con trai người; ấy là bạc chuộc lại những con trưởng nam trổi hơn. ");
INSERT INTO vie1934_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Vậy, Môi-se thâu bạc chuộc lại những con trưởng nam trổi hơn số người Lê-vi đã chuộc lại. ");
INSERT INTO vie1934_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Bạc mà người thâu về những con trưởng nam của dân Y-sơ-ra-ên, cộng được một ngàn ba trăm sáu mươi lăm siếc-lơ, theo siếc-lơ của nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Môi-se vâng mạng Đức Giê-hô-va, giao bạc chuộc lại cho A-rôn và các con trai người, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Trong người Lê-vi hãy dựng sổ các con cháu Kê-hát, tùy theo họ hàng và tông tộc của chúng nó, ");
INSERT INTO vie1934_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","từ ba mươi tuổi sắp lên cho đến năm mươi, tức là hết thảy người nào có thể giúp công vào hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Nầy sẽ là phần việc của con cháu Kê-hát tại trong hội mạc. Họ sẽ coi sóc nơi chí thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Khi nào dời trại quân đi, A-rôn và các con trai người sẽ đến gỡ bức màn mà bao lấy hòm bảng chứng; ");
INSERT INTO vie1934_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","đoạn đắp lên một tấm phủ bằng da cá nược, trải trên một tấm nỉ toàn bằng màu điều xanh và xỏ đòn khiêng vào. ");
INSERT INTO vie1934_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Cũng trải một tấm nỉ màu điều xanh trên cái bàn về bánh trần thiết; ở trên bàn thì sắp dĩa, chén, tộ và chậu về những lễ quán; bánh hằng trần thiết cũng sẽ có ở trên nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Rồi trải trên các vật đó một tấm nỉ màu đỏ sặm, đắp một tấm phủ bằng da cá nược và xỏ đòn khiêng vào. ");
INSERT INTO vie1934_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Cũng phải lấy một tấm nỉ màu điều xanh mà đậy chân đèn thắp, các thếp đèn, kéo hớt tim, đồ đựng tro, và các bình dầu mà người ta dùng về chân đèn. ");
INSERT INTO vie1934_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Rồi để chân đèn và hết thảy đồ phụ tùng trong một tấm phủ bằng da cá nược, để lên trên cái sề. ");
INSERT INTO vie1934_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Họ phải trải trên bàn thờ bằng vàng một tấm nỉ màu điều xanh và đắp một tấm phủ bằng da cá nược, rồi xỏ đòn khiêng vào. ");
INSERT INTO vie1934_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Lại, cũng phải lấy hết thảy đồ đạc dùng về công việc nơi thánh, để trong một tấm nỉ màu điều xanh, rồi đắp một tấm phủ bằng da cá nược và để lên trên cái sề. ");
INSERT INTO vie1934_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Phải hốt tro của bàn thờ, trải ở trên một tấm nỉ màu đỏ điều, ");
INSERT INTO vie1934_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","để lên trên hết thảy đồ đạc dùng về công việc của bàn thờ, tức là những lư hương, nĩa, vá, chén, cùng những đồ phụ tùng của bàn thờ. Rồi đắp trên bàn thờ một tấm phủ bằng da cá nược và xỏ đòn khiêng vào. ");
INSERT INTO vie1934_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Sau khi A-rôn và các con trai người đã đậy điệm nơi thánh và các đồ đạc thánh xong, khi dời trại quân đi, thì các con cháu Kê-hát phải đến đặng khiêng các đồ đạc đó; họ chẳng nên đụng vào những vật thánh, e phải chết chăng. Trong hội mạc, ấy là đồ mà các con cháu Kê-hát phải khiêng đi. ");
INSERT INTO vie1934_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Ê-lê-a-sa, con trai thầy tế lễ A-rôn, sẽ coi về dầu thắp đèn, hương-liệu, của lễ chay hằng hiến, dầu xức, cả đền tạm, và hết thảy vật chi ở trong nơi thánh với đồ phụ tùng của nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Đức Giê-hô-va lại phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Hãy làm thể nào cho tông tộc Kê-hát chớ bị truất khỏi chi phái Lê-vi, ");
INSERT INTO vie1934_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","và hãy làm điều nầy cho chúng nó, để khi đến gần nơi chí thánh, chúng nó được sống, chẳng phải chết: A-rôn và các con trai người phải đến cắt công việc cho mỗi người, và đồ chi họ phải khiêng đi. ");
INSERT INTO vie1934_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Dẫu một lát, chúng nó chớ nên vào đặng xem những vật thánh, e phải chết chăng. ");
INSERT INTO vie1934_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Cũng hãy dựng sổ các con cháu Ghẹt-sôn, tùy theo tông tộc và họ hàng họ. ");
INSERT INTO vie1934_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Từ ba mươi tuổi sắp lên cho đến năm mươi, ngươi khá kê sổ hết thảy những người nào có thể làm công việc trong hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Nầy là chức việc của các họ hàng Ghẹt-sôn, hoặc phải làm hoặc phải khiêng đồ: ");
INSERT INTO vie1934_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","họ sẽ mang những tấm màn của đền tạm và hội mạc, tấm bong của hội mạc, tấm lá-phủ bằng da cá nược ở trên, và bức màn của cửa hội mạc; ");
INSERT INTO vie1934_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","các bố vi của hành lang ở chung quanh đền tạm và bàn thờ, bức màn của cửa hành lang, những dây chạc, và hết thảy đồ dùng về các vật đó, cùng làm các công việc về những món ấy. ");
INSERT INTO vie1934_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Hết thảy công việc của con cháu Ghẹt-sôn, món chi họ phải khiêng đi, và việc chi họ phải làm điều sẽ theo lịnh A-rôn và các con trai người chỉ biểu; người phải giao cho họ coi sóc mọi món chi phải khiêng đi. ");
INSERT INTO vie1934_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Trong hội mạc, ấy là công việc của các họ hàng con cháu Ghẹt-sôn. Họ sẽ giữ chức phận mình dưới quyền cai trị của Y-tha-ma, con trai thầy tế lễ A-rôn. ");
INSERT INTO vie1934_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ngươi phải kê sổ con cháu Mê-ra-ri, tùy theo họ hàng và tông tộc của họ, ");
INSERT INTO vie1934_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","từ ba mươi tuổi sắp lên cho đến năm mươi, tức là hết thảy người nào có thể giúp công vào hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Về các công việc của con cháu Mê-ra-ri trong hội mạc, nầy là vật họ phải coi sóc và khiêng đi: những tấm ván của đền tạm, các xà ngang, trụ, lỗ trụ, ");
INSERT INTO vie1934_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","các trụ chung quanh hành lang và lỗ trụ, nọc, dây chạc, cùng hết thảy đồ đạc và các vật chi dùng về việc đó; các ngươi sẽ kê sổ từng tên những vật chi họ phải coi sóc và khiêng đi. ");
INSERT INTO vie1934_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Đó là hết thảy việc của các họ hàng Mê-ra-ri, về những công việc trong hội mạc mà họ phải làm ở dưới quyền cai trị của Y-tha-ma, con trai thầy tế lễ A-rôn. ");
INSERT INTO vie1934_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Vậy, Môi-se, A-rôn và những hội trưởng kê sổ con cháu Kê-hát, tùy theo họ hàng và tông tộc của họ, ");
INSERT INTO vie1934_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","từ ba mươi tuổi sắp lên cho đến năm mươi, tức là hết thảy người nào có thể giúp công trong hội mạc; ");
INSERT INTO vie1934_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","và những người mà người ta kê sổ, tùy theo họ hàng mình, cộng được hai ngàn bảy trăm năm mươi. ");
INSERT INTO vie1934_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Đó là những người của các họ hàng Kê-hát đã bị kê sổ, tức là hết thảy người hầu việc trong hội mạc mà Môi-se và A-rôn kê sổ, y theo mạng của Đức Giê-hô-va đã cậy Môi-se truyền dạy. ");
INSERT INTO vie1934_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Còn con cháu của Ghẹt-sôn đã bị kê sổ, tùy theo họ hàng và tông tộc của họ, ");
INSERT INTO vie1934_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","từ ba mươi tuổi sắp lên cho đến năm mươi, tức là hết thảy người có thể giúp công trong hội mạc, ");
INSERT INTO vie1934_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","cộng được hai ngàn sáu trăm ba mươi. ");
INSERT INTO vie1934_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Đó là những người về các họ hàng con cháu Ghẹt-sôn đã bị kê sổ, tức là mọi người hầu việc trong hội mạc mà Môi-se và A-rôn tu bộ y theo mạng của Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Còn những người về họ hàng con cháu Mê-ra-ri đã bị kê sổ, tùy theo họ hàng và tông tộc của họ, ");
INSERT INTO vie1934_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","từ ba mươi tuổi sắp lên cho đến năm mươi, tức là mọi người có thể giúp công trong hội mạc, ");
INSERT INTO vie1934_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","cộng được ba ngàn hai trăm. ");
INSERT INTO vie1934_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Đó là những người về các họ hàng con cháu Mê-ra-ri đã bị kê sổ. Môi-se và A-rôn lấy bộ dân, y theo mạng của Đức Giê-hô-va đã cậy Môi-se truyền dạy. ");
INSERT INTO vie1934_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Hết thảy những kẻ trong người Lê-vi mà Môi-se, A-rôn, và các quan trưởng Y-sơ-ra-ên tu bộ, tùy theo họ hàng và tông tộc của họ, ");
INSERT INTO vie1934_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","từ ba mươi tuổi sắp lên cho đến năm mươi, tức là mọi người đến đặng hầu việc và khiêng đồ trong hội mạc, ");
INSERT INTO vie1934_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","cộng được tám ngàn năm trăm tám mươi. ");
INSERT INTO vie1934_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Người ta tu bộ người Lê-vi tùy theo mạng của Đức Giê-hô-va đã cậy Môi-se truyền dạy, cắt phần cho mỗi người việc mình phải làm, và vật chi mình phải khiêng đi; người ta tu bộ dân tùy theo lời Đức Giê-hô-va đã phán dặn Môi-se vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Hãy biểu dân Y-sơ-ra-ên đuổi ra ngoài trại quân hết thảy người phung, người có bịnh bạch trược, và người vì cớ đụng đến một xác chết nào đã bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Bất luận nam hay nữ, các ngươi phải đuổi họ ra ngoài trại quân, hầu cho họ không làm cho trại quân bị ô uế, là nơi ta ngự ở trong. ");
INSERT INTO vie1934_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Dân Y-sơ-ra-ên bèn làm như vậy, đuổi họ ra khỏi trại quân, y như Đức Giê-hô-va đã truyền lịnh cho Môi-se vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Hãy nói cùng dân Y-sơ-ra-ên như vầy: Khi một người nam hay nữ phạm một trong những tội người ta thường phạm, cho đến can phạm cùng Đức Giê-hô-va, và vì cớ đó phải mắc tội, ");
INSERT INTO vie1934_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","thì người ấy phải xưng tội mình đã phạm ra, và trả tang vật lại đủ, và thêm một phần năm giá vật mà giao cho người mình đã mắc tội cùng. ");
INSERT INTO vie1934_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Nếu người nầy không còn, và không bà con nào để lãnh tang vật đó lại, thì vật ấy sẽ về Đức Giê-hô-va, tức là về thầy tế lễ, ngoại trừ con chiên đực về lễ chuộc tội mà thầy tế lễ sẽ dùng đặng chuộc tội cho người mắc tội đó. ");
INSERT INTO vie1934_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Phàm lễ vật chi biệt riêng ra thánh mà dân Y-sơ-ra-ên dâng cho thầy tế lễ, đều sẽ thuộc về người. ");
INSERT INTO vie1934_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Những vật biệt riêng ra thánh mà mỗi người dâng sẽ thuộc về người; vật chi mỗi người ban cho thầy tế lễ, chắc sẽ thuộc về người vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Hãy nói cho dân Y-sơ-ra-ên rằng: Nếu một người đàn bà lỗi đạo và phạm tội bất chánh cùng chồng, ");
INSERT INTO vie1934_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nếu có một người nam gian dâm cùng nàng mà việc nhẹm khuất mắt chồng; nếu nàng bị ô uế kín nhiệm, không có chứng cớ đối cùng nàng, và nàng không bị bắt tại trận; ");
INSERT INTO vie1934_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","nếu tánh ghen phát nơi người chồng ghen vợ mình, hoặc đã thật bị ô uế, hoặc không có bị ô uế, ");
INSERT INTO vie1934_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","thì người nầy phải dẫn vợ mình đến trước mặt thầy tế lễ, và vì nàng đem theo một phần mười ê-pha bột mạch nha dùng làm của tế lễ. Người chớ nên chế dầu vào, và cũng chẳng nên bỏ nhũ hương lên trên, vì là một của lễ chay về sự ghen tương, một của lễ chay kỷ niệm đặng nhắc tội gian ác. ");
INSERT INTO vie1934_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Thầy tế lễ sẽ biểu người nữ đến gần, đứng trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kế đó thầy tế lễ lấy nước thánh đổ vào chậu đất, hốt bụi ở trên đất của đền tạm mà bỏ trong nước. ");
INSERT INTO vie1934_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Đoạn, thầy tế lễ phải biểu người nữ đứng trước mặt Đức Giê-hô-va, lột trần đầu nàng, để của lễ kỷ niệm trên lòng bàn tay nàng, nghĩa là của lễ chay về sự ghen tương; và thầy tế lễ phải có nước đắng giáng rủa sả trong tay mình. ");
INSERT INTO vie1934_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Thầy tế lễ phải bắt người nữ thề, và nói cùng nàng rằng: Nếu chẳng một người nam nào nằm cùng ngươi, và nếu đang dưới quyền chồng ngươi không có lỗi đạo và không bị ô uế, thì chẳng phải mắc một điều hại nào của nước đắng giáng rủa sả nầy. ");
INSERT INTO vie1934_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Còn nếu đang dưới quyền chồng, mà ngươi lỗi đạo; nếu ngươi bị ô uế, và nếu một người nào khác hơn chồng đã nằm cùng ngươi ");
INSERT INTO vie1934_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","bấy giờ thầy tế lễ phải bắt người nữ lấy một lời thề trù ẻo mà thề, và nói cùng nàng rằng: Cầu Đức Giê-hô-va khiến cho ngươi trở nên một mầm rủa sả và trù ẻo giữa vòng dân sự ngươi, làm cho ngươi ốm lòi hông và phình bụng lên; ");
INSERT INTO vie1934_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","nước đắng giáng rủa sả nầy khá chun vào ruột gan làm cho bụng ngươi phình lên và ốm lòi hông. Người nữ sẽ nói rằng: A-men, a-men! ");
INSERT INTO vie1934_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Kế đó, thầy tế lễ phải viết các lời trù ẻo nầy trong một cuốn sách, rồi lấy nước đắng bôi đi. ");
INSERT INTO vie1934_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Thầy tế lễ sẽ biểu người nữ uống nước đắng giáng rủa sả, nước đắng giáng rủa sả sẽ vào trong mình nàng đặng làm cay đắng cho nàng. ");
INSERT INTO vie1934_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Đoạn, thầy tế lễ sẽ lấy khỏi tay người nữ của lễ chay về sự ghen tương, đưa qua đưa lại trước mặt Đức Giê-hô-va và dâng lên trên bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Rồi lấy một nắm của lễ chay kỷ niệm và xông trên bàn thờ; kế biểu người nữ uống nước đắng. ");
INSERT INTO vie1934_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Vả, khi nào thầy tế lễ biểu người uống nước đắng rồi, nếu quả người có bị ô uế phạm tội bất chánh cùng chồng mình, thì nước đắng giáng rủa sả sẽ vào mình làm cay đắng cho nàng, bụng nàng sẽ phình lên, hông nàng ốm lòi, và người nữ nầy sẽ làm một mầm rủa sả giữa vòng dân sự mình. ");
INSERT INTO vie1934_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Còn nếu người nữ không bị ô uế, vẫn thanh sạch, thì nàng sẽ chẳng bị một điều hại nào, và sẽ sanh con. ");
INSERT INTO vie1934_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Đó là luật lệ về sự ghen tương khi một người đàn bà, ở dưới quyền chồng mình, lỗi đạo và bị ô uế; ");
INSERT INTO vie1934_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","hoặc khi nào tánh ghen phát sanh nơi người chồng mà ghen vợ mình: người phải đem vợ đến trước mặt Đức Giê-hô-va, và thầy tế lễ sẽ làm cho nàng hết thảy điều chi luật lệ nầy truyền dạy. ");
INSERT INTO vie1934_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Người chồng sẽ vô tội, còn người đàn bà đó sẽ mang lấy tội mình. ");
INSERT INTO vie1934_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Hãy nói cho dân Y-sơ-ra-ên rằng: Bất luận người nam hay nữ, khi hứa nguyện Na-xi-rê đặng biệt mình riêng ra cho Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","thì phải kiêng cữ rượu và vật uống say; chẳng nên uống hoặc giấm rượu, hoặc giấm của vật uống say; lại cũng chẳng nên uống một thứ nước nào bằng trái nho, hay là ăn nho tươi, hoặc nho khô. ");
INSERT INTO vie1934_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Trọn trong lúc người biệt mình riêng ra, chớ ăn món chi của nho sanh sản hết, từ hột đến da. ");
INSERT INTO vie1934_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Trọn trong lúc hứa nguyện Na-xi-rê mình, chớ nên dùng dao cạo đầu; người sẽ nên thánh, và phải để tóc mọc cho đến chừng nào k” biệt mình riêng ra cho Đức Giê-hô-va đã được mãn. ");
INSERT INTO vie1934_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Trọn trong lúc người biệt mình riêng ra cho Đức Giê-hô-va chớ đến gần người chết. ");
INSERT INTO vie1934_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Người chớ vì cha hoặc vì mẹ, vì anh hoặc vì chị đã chết, mà làm cho mình bị ô uế, vì dấu chỉ sự biệt riêng ra cho Đức Chúa Trời vẫn ở trên đầu người. ");
INSERT INTO vie1934_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Trọn trong lúc hứa nguyện Na-xi-rê, người được biệt ra thánh cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Nếu ai chết thình lình gần bên người, làm cho ô uế đầu mình đã biệt riêng ra thánh, thì phải cạo đầu mình trong ngày được sạch, tức là ngày thứ bảy; ");
INSERT INTO vie1934_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","qua ngày thứ tám, người phải đem hai chim cu hay là hai bò câu con đến cho thầy tế lễ tại cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Thầy tế lễ sẽ dâng con nầy làm của lễ chuộc tội, con kia làm của lễ thiêu, và chuộc tội cho người đã phạm, vì cớ xác chết. Vậy, trong ngày đó người sẽ biệt đầu mình riêng ra thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Thế thì, người phải biệt riêng ra cho Đức Giê-hô-va những ngày về nguyện Na-xi-rê mình lại, và dâng một con chiên đực giáp năm làm của lễ chuộc sự mắc lỗi, và những ngày trước không kể nữa, vì sự Na-xi-rê mình đã bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Nầy là luật lệ về người Na-xi-rê: Khi nào những ngày Na-xi-rê mình đã mãn, người ta phải đem người đến tại cửa hội mạc; ");
INSERT INTO vie1934_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","người phải dâng của lễ mình cho Đức Giê-hô-va, tức là một con chiên con giáp năm không tì vít, làm của lễ thiêu, một con chiên cái giáp năm không tì vít, làm của lễ chuộc tội, và một con chiên đực không tì vít, làm của lễ thù ân; ");
INSERT INTO vie1934_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","một giỏ bánh không men bằng bột lọc, bánh nhỏ tưới dầu, bánh tráng không men thoa dầu, luôn với của lễ chay và lễ quán cặp theo các lễ kia. ");
INSERT INTO vie1934_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Thầy tế lễ sẽ đem những của lễ nầy đến trước mặt Đức Giê-hô-va, và dâng của lễ chuộc tội cùng của lễ thiêu của người; ");
INSERT INTO vie1934_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","rồi ngoại trừ giỏ bánh không men, dâng luôn con chiên đực làm của lễ thù ân, cùng dâng của lễ chay và lễ quán của người. ");
INSERT INTO vie1934_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Tại cửa hội mạc, người Na-xi-rê phải cạo đầu mình đã biệt riêng ra, lấy tóc bỏ vào lửa dưới của lễ thù ân. ");
INSERT INTO vie1934_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Sau khi người Na-xi-rê cạo đầu rồi, thầy tế lễ sẽ lấy cái vai chín của chiên đực, một cái bánh nhỏ không men trong giỏ, một bánh tráng không men và để trong lòng hai bàn tay người, ");
INSERT INTO vie1934_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","rồi đưa qua đưa lại trước mặt Đức Giê-hô-va: ấy là một vật thánh về thầy tế lễ với cái o đưa qua đưa lại và cái giò dâng giơ lên. Kế đó, người Na-xi-rê được phép uống rượu. ");
INSERT INTO vie1934_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Đó là luật lệ về người Na-xi-rê đã hứa nguyện, và đây là của lễ người phải dâng cho Đức Giê-hô-va về nguyện Na-xi-rê mình, ngoại trừ của lễ nào người có thể dâng thêm. Người phải theo luật lệ về sự Na-xi-rê mình mà làm theo lời hứa nguyện của mình vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Hãy nói cùng A-rôn và các con trai người mà rằng: Các ngươi phải chúc phước cho dân Y-sơ-ra-ên như vầy: ");
INSERT INTO vie1934_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Cầu xin Đức Giê-hô-va ban phước cho ngươi và phù hộ ngươi! ");
INSERT INTO vie1934_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Cầu xin Đức Giê-hô-va chiếu sáng mặt Ngài trên ngươi, và làm ơn cho ngươi! ");
INSERT INTO vie1934_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Cầu xin Đức Giê-hô-va đoái xem ngươi và ban bình an cho ngươi! ");
INSERT INTO vie1934_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Họ phải đặt danh ta trên dân Y-sơ-ra-ên như vầy, thì ta đây sẽ ban phước cho dân đó. ");
INSERT INTO vie1934_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Khi Môi-se đã dựng xong đền tạm, và đã xức dầu cùng biệt riêng ra thánh hết thảy đồ đạc của đền tạm, xức dầu và biệt riêng ra thánh bàn thờ và hết thảy đồ đạc của bàn thờ rồi, ");
INSERT INTO vie1934_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","thì các trưởng tộc của Y-sơ-ra-ên, tức là các quan trưởng về những chi phái mà đã cai trị cuộc tu bộ dân, đều đem dâng lễ vật của mình. ");
INSERT INTO vie1934_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Vậy, các quan trưởng dẫn lễ vật mình đến trước mặt Đức Giê-hô-va: Sáu xe cộ, hình như cái kiệu, và mười hai con bò đực, nghĩa là mỗi hai quan trưởng đồng dâng một xe cộ, và mỗi một người dâng một con bò đực; họ dâng lễ vật đó trước đền tạm. ");
INSERT INTO vie1934_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy thâu nhận các lễ vật của những người nầy, để dùng vào công việc hội mạc; và hãy giao cho người Lê-vi, ");
INSERT INTO vie1934_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","tức là cho mọi người tùy theo chức phận mình. ");
INSERT INTO vie1934_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Vậy, Môi-se bèn nhận lấy các xe cộ và những bò đực, giao cho người Lê-vi. ");
INSERT INTO vie1934_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Người giao cho con cháu Ghẹt-sôn hai xe cộ và bốn con bò đực, tùy theo chức phận của họ. ");
INSERT INTO vie1934_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Người giao cho con cháu Mê-ra-ri bốn xe cộ và tám con bò đực, tùy theo chức phận của họ, có Y-tha-ma, con trai thầy tế lễ A-rôn, làm quản lý. ");
INSERT INTO vie1934_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Nhưng người không có giao chi cho con cháu Kê-hát, vì họ mắc phần công việc về những vật thánh, và gánh vác những vật đó trên vai mình. ");
INSERT INTO vie1934_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Trong ngày bàn thờ được xức dầu, các quan trưởng dâng lễ vật mình trước bàn thờ về cuộc khánh thành nó. ");
INSERT INTO vie1934_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Đức Giê-hô-va phán cùng Môi-se rằng: Các quan trưởng phải đem lễ vật mình về cuộc khánh thành bàn thờ, người nầy thì ngày nay, người kia thì ngày kia. ");
INSERT INTO vie1934_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Người dâng lễ vật mình ngày đầu, là Na-ha-sôn, con trai của A-mi-na-đáp, thuộc về chi phái Giu-đa. ");
INSERT INTO vie1934_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Lễ vật người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh; cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Na-ha-sôn, con trai A-mi-na-đáp. ");
INSERT INTO vie1934_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ngày thứ hai, Na-tha-na-ên, con trai của Xu-a, quan trưởng Y-sa-ca, dâng lễ vật mình. ");
INSERT INTO vie1934_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Người dâng một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Na-tha-na-ên. con trai Xu-a. ");
INSERT INTO vie1934_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ngày thứ ba, đến quan trưởng của con cháu Sa-bu-lôn, là Ê-li-áp, con trai của Hê-lôn. ");
INSERT INTO vie1934_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Lễ vật của người là một cái dĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh; cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Ê-li-áp, con trai Hê-lôn. ");
INSERT INTO vie1934_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ngày thứ tư, đến quan trưởng của con cháu Ru-bên, là Ê-lít-su, con trai Sê-đêu. ");
INSERT INTO vie1934_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh; cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Ê-lít-su, con trai Sê-đêu. ");
INSERT INTO vie1934_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ngày thứ năm, đến quan trưởng của con cháu Si-mê-ôn, là Sê-lu-mi-ên, con trai Xu-ri-ha-đai. ");
INSERT INTO vie1934_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánhhh; cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Sê-lu-mi-ên, con trai Xu-ri-ha-đai. ");
INSERT INTO vie1934_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ngày thứ sáu, đến quan trưởng của con cháu Gát, là Ê-li-a-sáp, con trai Đê-u-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Ê-li-a-sáp, con trai Đê-u-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ngày thứ bảy, đến quan trưởng của con cháu Eùp-ra-im, là Ê-li-sa-ma, con trai A-mi-hút. ");
INSERT INTO vie1934_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Ê-li-sa-ma, con trai A-mi-hút. ");
INSERT INTO vie1934_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ngày thứ tám, đến quan trưởng của con cháu Ma-na-se, là Ga-ma-li-ên, con trai Phê-đát-su. ");
INSERT INTO vie1934_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Ga-ma-li-ên, con trai Phê-đát-su. ");
INSERT INTO vie1934_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ngày thứ chín, đến quan trưởng của con cháu Bên-gia-min, là A-bi-đan, con trai Ghi-đeo-ni. ");
INSERT INTO vie1934_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của A-bi-đan, con trai Ghi-đeo-ni. ");
INSERT INTO vie1934_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ngày thứ mười, đến quan trưởng của con cháu Đan, là A-hi-ê-xe, con trai A-mi-sa-đai. ");
INSERT INTO vie1934_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực và năm con chiên con giáp năm. Đó là lễ vật của A-hi-ê-xe, con trai A-mi-sa-đai. ");
INSERT INTO vie1934_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ngày thứ mười một, đến quan trưởng của con cháu A-se, là Pha-ghi-ên, con trai của Oùc-ran. ");
INSERT INTO vie1934_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mười siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của Pha-ghi-ên, con trai Oùc-ran. ");
INSERT INTO vie1934_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ngày thứ mười hai, đến quan trưởng của con cháu Nép-ta-li, là A-hi-ra, con trai Ê-nan. ");
INSERT INTO vie1934_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Lễ vật của người là một cái đĩa bạc nặng một trăm ba mươi siếc-lơ, một cái chậu bạc nặng bảy chục siếc-lơ, theo siếc-lơ của nơi thánh, cả hai cái đều đầy bột lọc nhồi dầu, dùng về của lễ chay; ");
INSERT INTO vie1934_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","một cái chén vàng nặng mười siếc-lơ, đầy thuốc thơm; ");
INSERT INTO vie1934_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","một con bò đực tơ, một con chiên đực, một con chiên con giáp năm, dùng về của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","một con dê đực dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","và về của lễ thù ân, hai con bò đực, năm con chiên đực, năm con dê đực, và năm con chiên con giáp năm. Đó là lễ vật của A-hi-ra, con trai Ê-nan. ");
INSERT INTO vie1934_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Aáy là những lễ vật của các quan trưởng dân Y-sơ-ra-ên dâng về cuộc khánh thành bàn thờ, khi bàn thờ được xức dầu: Mười hai đĩa bạc, mười hai chậu bạc, mười hai chén vàng; ");
INSERT INTO vie1934_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","mỗi cái đĩa bạc nặng một trăm ba mươi siếc-lơ, và mỗi cái chậu bạc nặng bảy chục siếc-lơ. Tổng cộng số bạc của các đĩa và chậu là hai ngàn bốn trăm siếc-lơ, theo siếc-lơ của nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Mười hai cái chén vàng đầy thuốc thơm, mỗi cái mười siếc-lơ, theo siếc-lơ của nơi thánh; tổng cộng số vàng của chén nặng được một trăm hai mươi siếc-lơ. ");
INSERT INTO vie1934_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Tổng cộng số bò đực về của lễ thiêu là mười hai con, với mười hai con chiên đực, mười hai con chiên con giáp năm cùng những của lễ chay cặp theo, và mười hai con dê đực dùng về của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Tổng cộng số bò đực về của lễ thù ân là hai mươi bốn con với sáu mươi con chiên đực, sáu mươi con dê đực, sáu mươi con chiên con giáp năm. Aáy là lễ vật dâng về cuộc khánh thành bàn thờ, sau khi bàn thờ được xức dầu rồi. ");
INSERT INTO vie1934_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Khi Môi-se vào hội mạc đặng hầu chuyện cùng Đức Giê-hô-va, thì người nghe Tiếng nói cùng mình từ trên nắp thi ân để trên hòm bảng chứng, ở giữa hai chê-ru-bin, người hầu chuyện cùng Đức Giê-hô-va vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Đức Giê-hô-va cũng phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Hãy nói cùng A-rôn: Khi nào người đặt các đèn, thì bảy ngọn đèn phải chiếu trên phía trước chân đèn. ");
INSERT INTO vie1934_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","A-rôn bèn làm như vậy; đặt bảy ngọn đèn trên phía trước chân đèn, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Vả, chân đèn đã làm theo cách nầy; làm bằng vàng đánh giát, cho đến cái chân và những cái hoa đều đánh giát. Aáy vậy, người ta làm chân đèn theo như kiểu mà Đức Giê-hô-va đã chỉ cho Môi-se xem. ");
INSERT INTO vie1934_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Hãy chọn lấy người Lê-vi ở trong vòng dân Y-sơ-ra-ên và dọn cho họ được sạch. ");
INSERT INTO vie1934_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Nầy là điều ngươi phải làm cho họ được sạch: Ngươi phải rảy nước rửa tội trên mình họ; họ phải cạo hết thảy cùng mình, giặt quần áo, và dọn cho mình được sạch. ");
INSERT INTO vie1934_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Đoạn, họ phải bắt một con bò đực với của lễ chay bằng bột lọc nhồi dầu cặp theo; còn ngươi bắt một con bò đực tơ thứ nhì dùng về của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","rồi biểu người Lê-vi đến gần trước hội mạc và nhóm cả hội chúng Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Vậy, ngươi phải biểu người Lê-vi đến gần trước mặt Đức Giê-hô-va, rồi dân Y-sơ-ra-ên sẽ đặt tay trên mình người Lê-vi. ");
INSERT INTO vie1934_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","A-rôn sẽ dâng người Lê-vi làm của lễ do phần dân Y-sơ-ra-ên mà đưa qua đưa lại trước mặt Đức Giê-hô-va, và họ sẽ được phần làm công việc của Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Đoạn, người Lê-vi sẽ đặt tay trên đầu hai con bò đực, và ngươi phải dâng con nầy làm của lễ chuộc tội và con kia làm của lễ thiêu cho Đức Giê-hô-va, để làm lễ chuộc tội cho người Lê-vi. ");
INSERT INTO vie1934_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Kế đó, ngươi phải biểu người Lê-vi đứng trước mặt A-rôn và các con trai người, rồi dâng họ như một của lễ đưa qua đưa lại cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Như vậy ngươi sẽ biệt riêng ra người Lê-vi với dân Y-sơ-ra-ên, và người Lê-vi sẽ thuộc về ta. ");
INSERT INTO vie1934_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Sau việc ấy, người Lê-vi sẽ đến đặng làm công việc của hội mạc. Aáy, ngươi sẽ làm cho họ được sạch và dâng như của lễ đưa qua đưa lại vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Bởi vì, giữa dân Y-sơ-ra-ên người Lê-vi ban trọn cho ta; ta đã chọn lấy họ về ta thế cho hết thảy con đầu lòng của dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Vì chưng hết thảy con đầu lòng trong dân Y-sơ-ra-ên đều thuộc về ta, bất luận người hay vật; ta đã biệt chúng nó riêng ra cho ta trong ngày ta hành hại mọi con đầu lòng tại xứ Ê-díp-tô, ");
INSERT INTO vie1934_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","và ta đã chọn lấy người Lê-vi thế cho mọi con đầu lòng của dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Bởi trong dân Y-sơ-ra-ên ta đã chọn người Lê-vi ban trọn cho A-rôn và các con trai người, đặng làm công việc của dân Y-sơ-ra-ên ở trong hội mạc, cùng làm lễ chuộc tội cho dân Y-sơ-ra-ên, hầu cho khi họ đến gần nơi thánh, chẳng có tai hại chi trong dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Vậy, Môi-se, A-rôn, và cả hội dân Y-sơ-ra-ên, đối cùng người Lê-vi làm hết mọi điều Đức Giê-hô-va đã phán dặn Môi-se về họ; dân Y-sơ-ra-ên đối cùng người Lê-vi đều làm như vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Người Lê-vi bèn làm cho mình được sạch khỏi tội, và giặt áo xống mình; rồi A-rôn dâng họ như của lễ đưa qua đưa lại trước mặt Đức Giê-hô-va, và làm lễ chuộc tội cho, để dọn họ được sạch. ");
INSERT INTO vie1934_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Sau rồi, người Lê-vi đến đặng làm công việc mình trong hội mạc trước mặt A-rôn và trước mặt các con trai người. Đối cùng người Lê-vi, người ta làm y như Đức Giê-hô-va đã phán dặn Môi-se về họ. ");
INSERT INTO vie1934_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Nầy là lệ định về người Lê-vi: Từ hai mươi lăm tuổi sắp lên, người Lê-vi phải đến nhập ban trong công việc của hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Nhưng đến năm mươi tuổi, người sẽ ra ban, chẳng làm công việc nữa; ");
INSERT INTO vie1934_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","người phải cứ giúp đỡ anh em mình trong hội mạc, coi sóc việc chi đã giao cho, nhưng không nên làm công việc nữa. Ngươi phải đối cùng người Lê-vi mà làm như vậy về chức phận của họ. ");
INSERT INTO vie1934_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Tháng giêng năm thứ hai, sau khi ra khỏi xứ Ê-díp-tô, Đức Giê-hô-va lại phán cùng Môi-se trong đồng vắng Si-na-i rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Dân Y-sơ-ra-ên phải giữ lễ Vượt-qua theo k” nhất định. ");
INSERT INTO vie1934_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Các ngươi phải giữ lễ đó theo k” nhất định, tức là ngày mười bốn tháng nầy, vào buổi chiều tối; các ngươi phải làm theo hết thảy lệ định và luật pháp về lễ đó. ");
INSERT INTO vie1934_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Vậy, Môi-se nói cùng dân Y-sơ-ra-ên để họ giữ lễ Vượt-qua. ");
INSERT INTO vie1934_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Dân Y-sơ-ra-ên giữ lễ Vượt-qua trong tuần tháng giêng, ngày mười bốn, vào buổi chiều tối, tại đồng vắng Si-na-i, làm y mọi điều Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Vả, có mấy người vì cớ xác chết mà bị ô uế, không được giữ lễ Vượt-qua trong ngày đó, bèn đến trước mặt Môi-se và A-rôn, ");
INSERT INTO vie1934_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","mà thưa cùng Môi-se rằng: Chúng tôi bị lây ô uế vì xác chết của loài người; sao tại trong dân Y-sơ-ra-ên chúng tôi phải bị cất phần dâng của lễ cho Đức Giê-hô-va theo k” đã chỉ? ");
INSERT INTO vie1934_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Môi-se đáp rằng: Hãy đợi để ta biết điều Đức Giê-hô-va sẽ truyền dạy về các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Đức Giê-hô-va bèn phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Hãy nói cùng dân Y-sơ-ra-ên rằng: Khi một người trong vòng các ngươi hay là trong vòng hậu đại các ngươi bị ô uế vì cớ xác chết, hoặc mắc đi xa, thì cũng buộc phải giữ lễ Vượt-qua cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Mấy người đó phải giữ lễ nầy ngày mười bốn tháng hai, vào buổi chiều tối, ăn bánh không men cùng rau đắng, ");
INSERT INTO vie1934_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","chớ nên để chi còn dư lại đến sáng mai, và cũng chẳng nên bẻ gãy những xương; phải giữ theo mọi luật lệ về lễ Vượt-qua vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Nhưng còn ai tinh sạch và không có đi xa, nếu chẳng giữ lễ Vượt-qua thì sẽ bị truất khỏi dân sự mình: vì người ấy chẳng dâng của lễ cho Đức Giê-hô-va trong k” nhất định; người sẽ mang lấy tội mình. ");
INSERT INTO vie1934_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Khi một khách ngoại bang kiều ngụ giữa các ngươi mà muốn giữ lễ Vượt-qua cho Đức Giê-hô-va, thì phải giữ theo lệ định và luật pháp về lễ Vượt-qua. Đồng có một luật lệ cho các ngươi, cho khách ngoại bang, và cho người nào sanh tại trong xứ. ");
INSERT INTO vie1934_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Vả, ngày người ta dựng đền tạm, thì trụ mây bao phủ đền tạm và Trại chứng cớ; ban chiều dường có một vầng lửa ở trên đền tạm cho đến sáng mai. ");
INSERT INTO vie1934_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hằng có như vậy; ban ngày trụ mây bao phủ đền tạm, và ban đêm giống như có lửa. ");
INSERT INTO vie1934_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Mỗi khi trụ mây cất lên khỏi Trại, thì dân Y-sơ-ra-ên ra đi; trong nơi nào trụ mây dừng lại, thì dân Y-sơ-ra-ên hạ trại ở đó. ");
INSERT INTO vie1934_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Dân Y-sơ-ra-ên ra đi theo mạng Đức Giê-hô-va, và hạ trại theo mạng Đức Giê-hô-va. Trọn trong lúc trụ mây ngự trên đền tạm, thì dân Y-sơ-ra-ên cứ đóng trại. ");
INSERT INTO vie1934_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Khi nào trụ mây ngự lâu trên đền tạm, thì dân Y-sơ-ra-ên vâng theo mạng Đức Giê-hô-va, chẳng hề ra đi. ");
INSERT INTO vie1934_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Nhưng khi nào trụ mây ngự ít ngày trên đền tạm, thì dân Y-sơ-ra-ên cứ vâng theo mạng Đức Giê-hô-va mà hạ trại và ra đi. ");
INSERT INTO vie1934_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Khi trụ mây ngự tại đó từ buổi chiều đến sáng mai, và khi đến sáng mai trụ mây cất lên, thì ra đi; không cứ ngày hay đêm trụ mây cất lên, thì họ ra đi. ");
INSERT INTO vie1934_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Trụ mây ngự trên đền tạm hoặc hai ngày, hoặc một tháng, hoặc lâu hơn nữa, thì dân Y-sơ-ra-ên cứ đóng trại, không hề ra đi; nhưng khi trụ mây cất lên, thì họ ra đi. ");
INSERT INTO vie1934_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Dân Y-sơ-ra-ên hạ trại và ra đi tùy theo mạng Đức Giê-hô-va; họ theo chương trình của Đức Giê-hô-va, tùy mạng Ngài đã cậy Môi-se mà truyền cho. ");
INSERT INTO vie1934_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Hãy làm hai ống loa bằng bạc, đánh giát, dùng cho ngươi để nhóm hiệp hội chúng và truyền cho các trại quân ra đi. ");
INSERT INTO vie1934_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Khi nào người ta thổi loa, toàn hội chúng sẽ nhóm lại gần bên ngươi, tại cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Nếu người ta thổi chỉ một ống loa, thì các quan trưởng, tức là các quan tướng đội-quân Y-sơ-ra-ên phải nhóm lại gần bên ngươi; ");
INSERT INTO vie1934_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","khi các ngươi thổi tiếng vang, thì những trại quân ở về hướng đông phải ra đi. ");
INSERT INTO vie1934_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Khi các ngươi thổi tiếng vang lần thứ nhì, thì những trại quân ở về hướng nam phải ra đi; người ta sẽ thổi tiếng vang khi nào các trại quân phải ra đi vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Khi nhóm hội chúng, các ngươi phải thổi, nhưng đừng thổi tiếng vang. ");
INSERT INTO vie1934_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Các con trai A-rôn, là những thầy tế lễ, sẽ thổi những ống loa. Từ đời nầy sang đời kia, ấy sẽ là một lệ định đời đời cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Khi nào trong xứ các ngươi phải ra chiến trận cùng kẻ thù nghịch xông đánh mình, thì phải thổi loa tiếng vang; Giê-hô-va, Đức Chúa Trời của các ngươi sẽ nhớ lại các ngươi, và các ngươi sẽ được giải thoát khỏi kẻ thù nghịch. ");
INSERT INTO vie1934_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Trong những ngày vui mừng, trong các lễ trọng thể và đầu tháng của các ngươi, thì phải thổi loa khi dâng những của lễ thiêu và của lễ thù ân mình; loa sẽ dùng làm kỷ niệm trước mặt Đức Chúa Trời của các ngươi. Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Xảy trong ngày hai mươi tháng hai, năm thứ hai, thì trụ mây cất lên khỏi đền tạm chứng cớ. ");
INSERT INTO vie1934_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Dân Y-sơ-ra-ên, theo chương trình đã định, ra từ đồng vắng Si-na-i, và trụ mây dừng lại tại đồng vắng Pha-ran. ");
INSERT INTO vie1934_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Vậy, dân Y-sơ-ra-ên vâng mạng của Đức Giê-hô-va cậy Môi-se truyền cho, mà ra đi lần thứ nhất. ");
INSERT INTO vie1934_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ngọn cờ của trại quân Giu-đa, tùy theo các đội ngũ mình, đi trước. Na-ha-sôn, con trai A-mi-na-đáp, thống lãnh quân đội Giu-đa. ");
INSERT INTO vie1934_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Na-tha-na-ên, con trai Xu-a, thống lãnh quân đội của chi phái Y-sa-ca. ");
INSERT INTO vie1934_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ê-li-áp, con trai Hê-lôn, thống lãnh quân đội của chi phái Sa-bu-lôn. ");
INSERT INTO vie1934_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Bấy giờ, đền tạm đã tháo dỡ, rồi con cháu Ghẹt-sôn và con cháu Mê-ra-ri khiêng đền tạm, bèn ra đi. ");
INSERT INTO vie1934_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kế đó, ngọn cờ của trại quân Ru-bên ra đi, tùy theo các đội ngũ mình. Ê-lít-su, con trai Sê-đêu, thống lãnh quân đội Ru-bên. ");
INSERT INTO vie1934_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Sê-lu-mi-ên, con trai Xu-ri-ha-đai, thống lãnh quân đội của chi phái Si-mê-ôn. ");
INSERT INTO vie1934_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ê-li-sáp, con trai Đê-u-ên, thống lãnh quân đội của chi phái Gát. ");
INSERT INTO vie1934_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Bấy giờ, các người Kê-hát khiêng những vật thánh ra đi; người ta dựng đền tạm lên đang lúc đợi họ đến. ");
INSERT INTO vie1934_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Đoạn, ngọn cờ của trại quân con cháu Eùp-ra-im ra đi, tùy theo đội ngũ mình. Ê-li-sa-ma, con trai A-mi-hút, thống lãnh quân đội Eùp-ra-im. ");
INSERT INTO vie1934_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ga-ma-li-ên, con trai Phê-đát-su, thống lãnh quân đội của chi phái Ma-na-se. ");
INSERT INTO vie1934_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","A-bi-đan, con trai Ghi-đeo-ni, thống lãnh quân đội của chi phái Bên-gia-min. ");
INSERT INTO vie1934_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Rốt lại, ngọn cờ của trại quân Đan ra đi, tùy theo các đội ngũ mình; nó làm hậu binh của các trại quân khác. A-hi-ê-xe, con trai A-mi-sa-đai, thống lãnh quân đội Đan. ");
INSERT INTO vie1934_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pha-ghi-ên, con trai Oùc-ran, thống lãnh quân đội của chi phái A-se. ");
INSERT INTO vie1934_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","A-hi-ra, con trai Ê-nan, thống lãnh quân đội của chi phái Nép-ta-li. ");
INSERT INTO vie1934_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Đó là thứ tự về sự cất binh đi của dân Y-sơ-ra-ên, tùy theo các đội ngũ mình; ấy, họ ra đi là như vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Vả, Môi-se nói cùng Hô-báp, con trai Rê-u-ên, người Ma-đi-an, tức là anh vợ mình, mà rằng: Chúng tôi đi đến xứ mà Đức Giê-hô-va có phán rằng: Ta sẽ ban xứ đó cho các ngươi. Xin anh hãy đi cùng chúng tôi, chúng tôi sẽ đãi anh tử tế; vì Đức Giê-hô-va có hứa ban ơn cho dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hô-báp đáp rằng: Tôi không đi đâu, nhưng tôi sẽ đi về xứ sở tôi, là nơi bà con tôi. ");
INSERT INTO vie1934_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Môi-se lại nói rằng: Tôi xin anh chớ bỏ chúng tôi, vì anh biết nơi nào trong đồng vắng chúng tôi có thế hạ trại được; anh sẽ dường như con mắt cho chúng tôi vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Nếu anh đi cùng chúng tôi, thì chúng tôi sẽ làm cho anh hưởng ơn lành mà Đức Giê-hô-va sẽ làm cho chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Vậy, dân Y-sơ-ra-ên ra đi từ núi Đức Giê-hô-va, đi trong ba ngày đường; hòm giao ước của Đức Giê-hô-va đi trước trong lúc ba ngày đường nầy, đặng tìm cho dân một nơi an nghỉ. ");
INSERT INTO vie1934_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Trong lúc ban ngày, khi dân Y-sơ-ra-ên dời trại quân đi, thì trụ mây của Đức Giê-hô-va ở trên họ. ");
INSERT INTO vie1934_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Khi hòm giao ước đi, thì Môi-se nói rằng: Hỡi Đức Giê-hô-va, xin chổi dậy, để kẻ thù nghịch Ngài bị tản lạc, và kẻ nào ghét Ngài chạy trốn trước mặt Ngài! ");
INSERT INTO vie1934_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Khi người ta để hòm giao ước xuống, thì Môi-se nói rằng: Hỡi Đức Giê-hô-va, xin trở lại cùng muôn vàn của Y-sơ-ra-ên! ");
INSERT INTO vie1934_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Vả, dân sự bèn lằm bằm, và điều đó chẳng đẹp tai Đức Giê-hô-va. Đức Giê-hô-va nghe, cơn thạnh nộ Ngài nổi lên, lửa của Đức Giê-hô-va cháy phừng phừng giữa dân sự và thiêu hóa đầu cùng trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Dân sự bèn kêu la cùng Môi-se; Môi-se cầu xin Đức Giê-hô-va, thì lửa ngừng lại. ");
INSERT INTO vie1934_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Người ta đặt tên chỗ nầy là Tha-bê-ra, vì lửa của Đức Giê-hô-va đã cháy giữa dân sự. ");
INSERT INTO vie1934_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Bọn dân tạp ở trong dân Y-sơ-ra-ên sanh lòng tham muốn, đến đỗi dân Y-sơ-ra-ên lại khóc nữa mà rằng: Ai sẽ cho chúng tôi ăn thịt? ");
INSERT INTO vie1934_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Chúng tôi nhớ những cá chúng tôi ăn nhưng không tại xứ Ê-díp-tô, những dưa chuột, dưa gang, củ kiệu, hành, và tỏi. ");
INSERT INTO vie1934_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Bây giờ, linh hồn chúng tôi bị khô héo, không có chi hết! Mắt chỉ thấy ma-na mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Vả, Ma-na hình như hột ngò, sắc như trân châu. ");
INSERT INTO vie1934_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Dân sự đi tản ra và hốt lấy, rồi nghiền bằng cối xay, hay là giã bằng cối giã, nấu trong một cái nồi và làm bánh; nếm giống như bánh nhỏ có pha dầu. ");
INSERT INTO vie1934_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Khi ban tối mù sương xuống trên trại quân, thì ma-na cũng xuống nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Vậy, Môi-se nghe dân sự khóc, mỗi người ở trong nhà mình, tại nơi cửa trại mình: cơn thạnh nộ của Đức Giê-hô-va nổi lên phừng phừng, ");
INSERT INTO vie1934_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","và Môi-se lấy làm buồn bực về điều đó. Môi-se bèn thưa cùng Đức Giê-hô-va rằng: Sao Ngài làm cho tôi tớ Ngài buồn? Sao tôi chẳng được ơn trước mặt Ngài, và sao Ngài lại chất gánh nặng của hết thảy dân sự nầy trên mình tôi? ");
INSERT INTO vie1934_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Tôi há có thọ thai dân nầy sao? há có sanh đẻ nó sao? mà Ngài lại phán biểu tôi rằng: Hãy ẵm dân nầy trong lòng ngươi, như người cha nuôi bồng đứa trẻ bú, cho đến xứ mà Ngài có thề hứa ban cho tổ phụ của chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Tôi sẽ có thịt ở đâu đặng phát cho cả dân sự nầy? bởi vì họ khóc về tôi mà rằng: Hãy cho chúng tôi ăn thịt. ");
INSERT INTO vie1934_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Tôi không thế một mình gánh hết dân sự nầy, vì thật là rất nặng nề cho tôi quá! ");
INSERT INTO vie1934_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nếu Chúa đãi tôi như vậy, và nếu tôi được ơn trước mặt Chúa, xin thà giết tôi đi, để tôi không thấy sự khốn nạn tôi! ");
INSERT INTO vie1934_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Hãy nhóm hiệp cho ta bảy mươi người trong bực trưởng lão Y-sơ-ra-ên, tức là những kẻ ngươi biết là trưởng lão và cai quản dân sự; hãy dẫn các người ấy đến hội mạc, đứng tại đó với ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Đoạn, ta sẽ ngự xuống, nói chuyện tại đó với ngươi; ta sẽ lấy Thần cảm ngươi mà ban cho những người đó, để họ chịu gánh nặng về dân sự với ngươi, và ngươi không phải gánh một mình. ");
INSERT INTO vie1934_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ngươi phải truyền cho dân sự rằng: Ngày mai phải dọn mình ra thánh, thì các ngươi sẽ ăn thịt. Vì chưng lỗ tai Đức Giê-hô-va có nghe các ngươi khóc mà rằng: Ai sẽ cho chúng tôi ăn thịt, vì chúng tôi lấy làm sung sướng tại xứ Ê-díp-tô, bởi cớ đó, Đức Giê-hô-va sẽ ban thịt cho các ngươi, thì các ngươi sẽ ăn. ");
INSERT INTO vie1934_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Chẳng phải các ngươi sẽ ăn thịt một ngày, hai ngày, năm ngày, mười ngày hay là hai mươi ngày đâu; ");
INSERT INTO vie1934_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","nhưng cho đến một tháng trọn, cho đến chừng nào thịt tràn ra lỗ mũi, và các ngươi ngán đi, vì các ngươi đã bỏ Đức Giê-hô-va ở giữa mình, và khóc trước mặt Ngài, mà rằng: Vì sao chúng tôi đã ra khỏi xứ Ê-díp-tô? ");
INSERT INTO vie1934_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Môi-se thưa rằng: Trong dân sự tôi đang ở đây, có sáu trăm ngàn người đàn ông, mà Ngài có phán rằng: Ta sẽ phát thịt cho dân nầy ăn trong một tháng trọn. ");
INSERT INTO vie1934_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Người ta há sẽ giết chiên và bò đến đỗi được đủ cho họ sao? hay là người ta há sẽ gom hết thảy cá dưới biển đến nỗi được đủ cho họ sao? ");
INSERT INTO vie1934_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Đức Giê-hô-va phán cùng Môi-se rằng: Tay của Đức Giê-hô-va đã vắn lại sao? Ngươi sẽ xem thử điều ta đã phán cùng ngươi có xảy đến hay chăng. ");
INSERT INTO vie1934_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Môi-se bèn đi ra, thuật lại các lời Đức Giê-hô-va cho dân sự, rồi nhóm hiệp bảy mươi người trong bực trưởng lão của dân sự, đặt để xung quanh Trại. ");
INSERT INTO vie1934_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Đức Giê-hô-va bèn ngự xuống trong mây, phán cùng Môi-se; Ngài lấy Thần cảm người và ban cho bảy mươi người trưởng lão. Vừa khi Thần ở trên bảy mươi người trưởng lão, bèn được cảm động nói tiên tri, nhưng không cứ nói mãi. ");
INSERT INTO vie1934_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Có hai người ở lại trong trại quân; một người tên là Eân-đát, một người tên là Mê-đát, được Thần cảm động, nói tiên tri tại trại quân. Hai người nầy thuộc về bọn được biên tên, nhưng không có đến hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Một đứa trai trẻ chạy thuật lại cùng Môi-se rằng: Eân-đát và Mê-đát nói tiên tri trong trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Giô-suê, con trai của Nun, là người hầu việc Môi-se, đáp lại mà rằng: Hỡi Môi-se, chúa tôi, hãy cấm chúng nó! ");
INSERT INTO vie1934_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Môi-se đáp rằng: Ngươi ganh cho ta chăng? Oâi! chớ chi cả dân sự của Đức Giê-hô-va đều là người tiên tri, và chớ chi Đức Giê-hô-va ban Thần của Ngài cho họ! ");
INSERT INTO vie1934_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Môi-se và mấy người trưởng lão đều lui vào trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Đức Giê-hô-va bèn khiến một trận gió nổi từ biển, dẫn những chim cút đến vải trên trại quân và xung quanh, bên nầy trải ra dài chừng một ngày đường đi, và bên kia trải ra dài chừng một ngày đường đi, khỏi mặt đất chừng hai thước bề cao. ");
INSERT INTO vie1934_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Dân sự đứng dậy lượm những cút trong ngày đó, đêm đó và trọn ngày sau; ai lượm ít hơn hết có mười ô-me; người ta căng nó khắp chung quanh trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Thịt vẫn còn nơi răng, chưa nhai, thì cơn giận của Đức Giê-hô-va nổi lên cùng dân sự, hành dân sự một tai vạ rất nặng. ");
INSERT INTO vie1934_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Người ta đặt tên chỗ đó là Kíp-rốt Ha-tha-va; vì tại đó người ta chôn dân sự sanh lòng tham muốn. ");
INSERT INTO vie1934_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Từ Kíp-rốt Ha-tha-va dân sự đi đến Hát-sê-rốt, rồi ngừng lại tại đó. ");
INSERT INTO vie1934_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mi-ri-am và A-rôn nói hành Môi-se về việc người nữ Ê-thi-ô-bi mà người đã lấy; vì người có lấy một người nữ Ê-thi-ô-bi làm vợ. ");
INSERT INTO vie1934_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Hai người nói rằng: Đức Giê-hô-va chỉ dùng một mình Môi-se mà thôi sao? Ngài há không dùng chúng ta mà phán nữa sao? Đức Giê-hô-va nghe điều đó. ");
INSERT INTO vie1934_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Vả, Môi-se là người rất khiêm hòa hơn mọi người trên thế gian. ");
INSERT INTO vie1934_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Thình lình Đức Giê-hô-va phán cùng Môi-se, A-rôn và Mi-ri-am rằng: Cả ba hãy ra đến hội mạc. Cả ba đều đi. ");
INSERT INTO vie1934_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Đức Giê-hô-va ngự xuống trong trụ mây đứng tại cửa hội mạc, rồi gọi A-rôn và Môi-se; hai người đều đến. ");
INSERT INTO vie1934_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ngài phán cùng hai người rằng: Hãy nghe rõ lời ta. Nếu trong các ngươi có một tiên tri nào, ta là Đức Giê-hô-va sẽ hiện ra cùng người trong sự hiện thấy, và nói với người trong cơn chiêm bao. ");
INSERT INTO vie1934_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Tôi tớ Môi-se ta không có như vậy, người thật trung tín trong cả nhà ta. ");
INSERT INTO vie1934_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ta nói chuyện cùng người miệng đối miệng, một cách rõ ràng, không lời đố, và người thấy hình Đức Giê-hô-va. Vậy, các ngươi không sợ mà nói hành kẻ tôi tớ ta, là Môi-se sao? ");
INSERT INTO vie1934_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Như vậy, cơn thạnh nộ của Đức Giê-hô-va nổi phừng phừng cùng hai người; Ngài ngự đi. ");
INSERT INTO vie1934_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Khi trụ mây rút khỏi trên đền tạm, thì kìa, Mi-ri-am đã bị phung trắng như tuyết. A-rôn xây lại phía Mi-ri-am, thấy người đã có bịnh phung. ");
INSERT INTO vie1934_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","A-rôn bèn nói cùng Môi-se rằng: Oâi, lạy chúa tôi, xin chớ để trên chúng tôi tội mà chúng tôi đã dại phạm và đã mắc lấy. ");
INSERT INTO vie1934_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Xin chớ để nàng như một đứa con sảo thịt đã hư hết phân nửa khi lọt ra khỏi lòng mẹ. ");
INSERT INTO vie1934_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Môi-se bèn kêu van cùng Đức Giê-hô-va rằng: Oâi, Đức Chúa Trời! Tôi cầu khẩn Ngài chữa cho nàng. ");
INSERT INTO vie1934_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Đức Giê-hô-va đáp cùng Môi-se rằng: Nếu cha nàng nhổ trên mặt nàng, nàng há không mang hổ trong bảy ngày sao? Nàng phải cầm riêng ngoài trại quân trong bảy ngày, rồi sau sẽ được nhận vào lại. ");
INSERT INTO vie1934_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Aáy vậy, Mi-ri-am bị cầm riêng ngoài trại quân trong bảy ngày, dân sự không ra đi cho đến chừng nào Mi-ri-am được nhận vào lại. ");
INSERT INTO vie1934_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Sau việc đó, dân sự ra đi từ Hát-sê-rốt, và hạ trại trong đồng vắng Pha-ran. ");
INSERT INTO vie1934_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Hãy sai những người đi do thám xứ Ca-na-an, là xứ ta ban cho dân Y-sơ-ra-ên. Về mỗi một chi phái, các ngươi phải sai một người đi; mỗi người làm quan trưởng của chi phái mình. ");
INSERT INTO vie1934_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Tùy theo mạng Đức Giê-hô-va, Môi-se từ đồng vắng Pha-ran sai các người nầy đi; hết thảy là quan trưởng của dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Đây là tên của các người ấy: Về chi phái Ru-bên, Sam-mua, con trai Xa-cu; ");
INSERT INTO vie1934_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","về chi phái Si-mê-ôn, Sa-phát, con trai của Hô-ri; ");
INSERT INTO vie1934_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","về chi phái Giu-đa, Ca-lép, con trai của Giê-phu-nê; ");
INSERT INTO vie1934_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","về chi phái Y-sa-ca, Di-ganh, con trai của Giô-sép; ");
INSERT INTO vie1934_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","về chi phái Eùp-ra-im, Hô-sê, con trai của Nun; ");
INSERT INTO vie1934_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","về chi phái Bên-gia-min, Phan-thi, con trai của Ra-phu; ");
INSERT INTO vie1934_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","về chi phái Sa-bu-lôn, Gát-đi-ên, con trai của Sô-đi; ");
INSERT INTO vie1934_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","về chi phái Giô-sép, nghĩa là về chi phái Ma-na-se, Ga-đi, con trai của Su-si; ");
INSERT INTO vie1934_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","về chi phái Đan, A-mi-ên, con trai của Ghê-ma-li; ");
INSERT INTO vie1934_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","về chi phái A-se, Sê-thu, con trai của Mi-ca-ên; ");
INSERT INTO vie1934_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","về chi phái Nép-ta-li, Nách-bi, con trai của Vấp-si; ");
INSERT INTO vie1934_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","về chi phái Gát, Gu-ên, con trai của Ma-ki. ");
INSERT INTO vie1934_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Đó là tên những người mà Môi-se sai đi do thám xứ. Vả, Môi-se đặt tên cho Hô-sê, con trai Nun, là Giô-suê. ");
INSERT INTO vie1934_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Vậy, Môi-se sai đi do thám xứ Ca-na-an, và dặn rằng: Từ đây hãy lên Nam phương, và vào miền núi; ");
INSERT INTO vie1934_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","rồi sẽ thấy xứ ra sao, dân sự ở đó nếu mạnh yếu thể nào, nếu số ít hay nhiều; ");
INSERT INTO vie1934_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","xứ dân đó ở thế nào, nếu tốt hay xấu; các thành dân đó ở làm sao, hoặc chỉ những nơi đóng trại hay là đồn lũy; ");
INSERT INTO vie1934_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","đất ra làm sao, nếu màu mỡ hay là xấu, có cây cối hay là không. Hãy can đảm và hái lấy trái cây xứ đó. Bấy giờ nhằm mùa nho sớm. ");
INSERT INTO vie1934_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Vậy các người đó đi lên do thám xứ, từ đồng vắng Xin cho đến Rê-hốp, đi về Ha-mát. ");
INSERT INTO vie1934_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Họ bắt từ hướng Nam đi lên, đến thành Hếp-rôn, là nơi có A-hi-man, Sê-sai và Tanh-mai, con cái của A-nác. Vả, thành Hếp-rôn đã xây từ bảy năm trước Xô-an, là thành của xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Các người đến khe Eách-côn, cắt tại đó một nhành nho có một chùm nho; và hai người khiêng lấy bằng cây sào, luôn những trái lựu và trái vả. ");
INSERT INTO vie1934_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Người ta gọi chỗ nầy là khe Eách-côn, vì có chùm nho mà dân Y-sơ-ra-ên đã cắt tại đó. ");
INSERT INTO vie1934_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Các người đi do thám xứ trong bốn mươi ngày trở về. ");
INSERT INTO vie1934_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Tới rồi, bèn đến cùng Môi-se, A-rôn và cả hội dân Y-sơ-ra-ên, trong đồng vắng Pha-ran, tại Ca-đe, mà thuật lại mọi sự cho hai người và cả hội chúng nghe, cùng đưa cho xem hoa quả của xứ. ");
INSERT INTO vie1934_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Vậy, các người ấy thuật cho Môi-se rằng: Chúng tôi đi đến xứ mà người đã sai chúng tôi đi; ấy quả thật một xứ đượm sữa và mật, nầy hoa quả xứ đó đây. ");
INSERT INTO vie1934_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mà, dân sự ở trong xứ nầy vốn mạnh dạn, thành trì thật vững vàng và rất lớn; chúng tôi cũng có thấy con cái của A-nác ở đó. ");
INSERT INTO vie1934_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Dân A-ma-léc ở miền Nam, dân Hê-tít, dân Giê-bu-sít và dân A-mô-rít ở trong núi; dân Ca-na-an ở gần biển và dọc dài theo mé Giô-đanh. ");
INSERT INTO vie1934_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ca-lép bèn làm cho dân sự, đang lằm bằm cùng Môi-se nín lặng đi, mà nói rằng: Chúng ta hãy đi lên và chiếm xứ đi, vì chúng ta thắng hơn được. ");
INSERT INTO vie1934_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Nhưng những người đi cùng Ca-lép nói rằng: Chúng ta không đi lên cự dân nầy được, vì chúng nó mạnh hơn chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Trước mặt dân Y-sơ-ra-ên, các người đó phao phản xứ mình đã do thám mà rằng: Xứ mà chúng tôi đã đi khắp đặng do thám, là một xứ nuốt dân sự mình; hết thảy những người chúng tôi đã thấy tại đó, đều là kẻ hình vóc cao lớn. ");
INSERT INTO vie1934_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Chúng tôi có thấy kẻ cao lớn, tức là con cháu của A-nác, thuộc về giống giềnh giàng; chúng tôi thấy mình khác nào con cào cào, và họ thấy chúng tôi cũng như vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Cả hội chúng bèn cất tiếng la lên, và dân sự khóc lóc trong đêm đó. ");
INSERT INTO vie1934_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Hết thảy dân Y-sơ-ra-ên lằm bằm cùng Môi-se và A-rôn; cả hội chúng nói cùng hai người rằng: Chớ chi chúng tôi đã chết trong xứ Ê-díp-tô, hay là đã chết trong đồng vắng nầy! ");
INSERT INTO vie1934_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Vì cớ nào Đức Giê-hô-va dẫn chúng tôi vào xứ nầy đặng bị gươm mà ngã? Vợ và con nhỏ chúng tôi sẽ bị làm một miếng mồi. Về phần chúng tôi, há chẳng khá trở về xứ Ê-díp-tô hơn sao? ");
INSERT INTO vie1934_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Rồi dân sự nói với nhau rằng: Chúng ta hãy lập lên một quan trưởng, và trở về xứ Ê-díp-tô đi. ");
INSERT INTO vie1934_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Môi-se và A-rôn bèn sấp mình xuống trước mặt cả hội dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Giô-suê, con trai của Nun, và Ca-lép, con trai của Giê-phu-nê, là hai người trong bọn đi do thám xứ, bèn xé quần áo mình. ");
INSERT INTO vie1934_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Hai người nói cùng cả hội dân Y-sơ-ra-ên rằng: Xứ mà chúng tôi đã đi khắp đặng do thám thật là một xứ rất tốt; ");
INSERT INTO vie1934_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","nếu Đức Giê-hô-va đẹp lòng cùng chúng ta, ắt sẽ đem chúng ta vào xứ nầy mà ban cho; ấy là một xứ đượm sữa và mật. ");
INSERT INTO vie1934_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Chỉ các ngươi chớ dấy loạn cùng Đức Giê-hô-va, và đừng sợ dân của xứ, vì dân đó sẽ là đồ nuôi chúng ta, bóng che chở họ đã rút đi khỏi họ rồi, và Đức Giê-hô-va ở cùng ta. Chớ sợ chi. ");
INSERT INTO vie1934_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Bấy giờ cả hội chúng nói ném đá hai người nầy, nhưng sự vinh quang của Đức Giê-hô-va hiện ra trên hội mạc, trước mặt dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Đức Giê-hô-va phán cùng Môi-se rằng: Dân nầy khinh ta và không tin ta cho đến chừng nào, mặc dầu các phép lạ ta làm giữa chúng nó? ");
INSERT INTO vie1934_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ta sẽ giáng cho dân sự nầy dịch lệ và tiêu diệt phần cơ nghiệp của nó đi; nhưng ta sẽ làm cho ngươi thành một dân lớn hơn và mạnh hơn nó. ");
INSERT INTO vie1934_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Môi-se thưa cùng Đức Giê-hô-va rằng: Dân Ê-díp-tô có hay rằng Chúa cậy quyền năng Chúa đem dân nầy ra khỏi họ; ");
INSERT INTO vie1934_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","và có thuật điều đó cho dân xứ nầy. Oâi Đức Giê-hô-va! người ta biết rằng Chúa ngự giữa dân nầy, Chúa hiện ra cho mắt chúng thấy, trụ mây Chúa ở trên dân nầy, và Chúa đi trước, ban ngày trong một trụ mây, ban đêm trong một trụ lửa. ");
INSERT INTO vie1934_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Nếu Chúa giết hết dân nầy như thể giết một người, thì các nước đã nghe nói về Chúa sẽ nói rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Đức Giê-hô-va không thể dẫn dân nầy vào xứ mà Ngài đã thề ban cho; bởi cớ đó, Ngài giết chết chúng nó trong đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Vả, bây giờ, tôi xin quyền năng của Chúa hiện ra cách oai nghiêm như Chúa đã nói rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Đức Giê-hô-va vốn chậm nóng giận và đầy ơn; hay xá điều gian ác và tội lỗi; nhưng không kể kẻ có tội là vô tội, và nhơn tội tổ phụ phạt con cháu trải ba bốn đời. ");
INSERT INTO vie1934_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tôi xin Chúa tha tội gian ác của dân nầy tùy theo ơn lớn của Chúa, như Chúa đã tha từ xứ Ê-díp-tô đến đây. ");
INSERT INTO vie1934_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Đức Giê-hô-va đáp rằng: Ta đã tha như lời ngươi xin. ");
INSERT INTO vie1934_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Nhưng ta chỉ sự hằng sống ta mà quả quyết rằng, sự vinh quang của Đức Giê-hô-va sẽ đầy dẫy khắp trái đất! ");
INSERT INTO vie1934_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Trong mọi người đã thấy sự vinh quang ta, phép lạ ta đã làm tại xứ Ê-díp-tô và nơi đồng vắng, là các ngươi đã thử ta mười lần và đã không nghe lời ta, ");
INSERT INTO vie1934_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","thì chẳng một ai sẽ thấy xứ mà ta thề hứa cho tổ phụ chúng nó. Chẳng ai mà đã khinh ta sẽ thấy xứ đó đâu! ");
INSERT INTO vie1934_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Nhưng vì kẻ tôi tớ Ca-lép ta không đồng lòng cùng chúng nó, theo ta một cách trung tín, thì ta sẽ đem người vào xứ mà người đã có đi, và dòng dõi người sẽ được xứ làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Dân A-ma-léc và dân Ca-na-an ở trong trũng; ngày mai các ngươi hãy trở lui lại sau, đi đến đồng vắng về hướng Biển đỏ. ");
INSERT INTO vie1934_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Đức Giê-hô-va cũng phán cùng Môi-se và A-rôn, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Ta sẽ chịu hội chúng hung dữ nầy hay lằm bằm cùng ta cho đến chừng nào? Ta đã nghe lời lằm bằm của dân Y-sơ-ra-ên oán trách ta. ");
INSERT INTO vie1934_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Hãy nói với dân chúng: Đức Giê-hô-va nói rằng: Ta chỉ sự hằng-sống ta mà thề, ta sẽ đãi các ngươi tùy theo lời ta đã nghe các ngươi nói; ");
INSERT INTO vie1934_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","những thây các ngươi sẽ ngã nằm trong đồng vắng nầy. Các ngươi mà người ta đã tu bộ, hết thảy bao nhiêu cũng vậy, từ hai mươi tuổi sắp lên, là những kẻ đã lằm bằm cùng ta, ");
INSERT INTO vie1934_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","thì chẳng hề được vào xứ mà ta đã thề cho các ngươi ở, ngoại trừ Ca-lép, con trai của Giê-phu-nê, và Giô-suê, con trai của Nun. ");
INSERT INTO vie1934_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Nhưng ta sẽ đem vào xứ những con trẻ của các ngươi mà các ngươi có nói rằng: Chúng nó sẽ bị làm một miếng mồi; rồi chúng nó sẽ biết xứ các ngươi đã chê bai. ");
INSERT INTO vie1934_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Còn những thây các ngươi sẽ ngã nằm trong đồng vắng nầy. ");
INSERT INTO vie1934_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Con cái các ngươi sẽ chăn chiên nơi đồng vắng trong bốn mươi năm, và sẽ mang hình phạt vì tội thông dâm của các ngươi, cho đến chừng nào thây của các ngươi đã ngã rạp hết trong đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Các ngươi đi do thám xứ bao nhiêu ngày, nghĩa là bốn mươi ngày, thì các ngươi cũng sẽ mang hình phạt vì tội gian ác mình bấy nhiêu năm, nghĩa là bốn mươi năm, một năm đền cho một ngày; bấy giờ các ngươi sẽ biết ta đã xây khỏi các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ta, Đức Giê-hô-va, đã phán: Ta sẽ làm điều nầy cho cả hội chúng hung dữ nầy đã hiệp lại nghịch cùng ta; chúng nó sẽ bị hao mòn và chết tại trong đồng vắng nầy. ");
INSERT INTO vie1934_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Những người mà Môi-se đã sai đi do thám xứ, khi trở về có xui cho cả hội chúng lằm bằm cùng Môi-se, ");
INSERT INTO vie1934_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","và có phao phản xứ, những người nầy đều bị một tai vạ hành chết trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nhưng trong bọn người đi do thám xứ, chỉ có Giô-suê, con trai của Nun, và Ca-lép, con trai của Giê-phu-nê, còn sống được. ");
INSERT INTO vie1934_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Môi-se thuật lại những lời nầy cho cả dân Y-sơ-ra-ên; rồi có một sự thảm sầu rất lớn trong dân sự. ");
INSERT INTO vie1934_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Đoạn, dân sự dậy sớm đi lên chót núi mà nói rằng: Chúng tôi đây sẽ đi lên tới chỗ Đức Giê-hô-va đã phán-hứa, vì chúng tôi có phạm tội. ");
INSERT INTO vie1934_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Song Môi-se nói rằng: Sao các ngươi trái mạng Đức Giê-hô-va? Sự đó sẽ chẳng may mắn đâu. ");
INSERT INTO vie1934_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Chớ đi lên đó, e các ngươi bị quân nghịch đánh bại chăng; vì Đức Giê-hô-va không còn ở giữa các ngươi nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Kìa, dân A-ma-léc và dân Ca-na-an ở đằng trước các ngươi, các ngươi sẽ bị gươm ngã rạp, bởi vì đã bội nghịch cùng Đức Giê-hô-va, Đức Giê-hô-va sẽ không ở cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Nhưng dân sự cố ý đi lên chót núi; còn hòm giao ước của Đức Giê-hô-va và Môi-se không đi ra khỏi trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Dân A-ma-léc và dân Ca-na-an ở trong núi nầy đổ xuống, đánh bại và phân thây dân Y-sơ-ra-ên cho đến Họt-ma. ");
INSERT INTO vie1934_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Hãy nói cùng dân Y-sơ-ra-ên rằng: Khi các ngươi vào xứ mà ta ban cho các ngươi đặng ở, ");
INSERT INTO vie1934_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","và các ngươi dâng cho Đức Giê-hô-va một của lễ dùng lửa đốt; hoặc một của lễ thiêu, hoặc một của lễ trả sự hứa nguyện, hoặc một của lễ lạc ý, hay là trong những lễ trọng thể, các ngươi muốn dâng cho Đức Giê-hô-va một của lễ có mùi thơm bằng bò hay chiên, ");
INSERT INTO vie1934_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","thì ai dâng lễ vật mình phải dâng cho Đức Giê-hô-va một của lễ chay bằng một phần mười ê-pha bột lọc nhồi với một phần tư hin dầu. ");
INSERT INTO vie1934_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Về mỗi con chiên con, ngươi phải dâng một lễ quán bằng một phần tư hin rượu với của lễ thiêu hay là với của lễ khác. ");
INSERT INTO vie1934_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Nhược bằng về một con chiên đực, thì ngươi phải dùng một của lễ chay bằng hai phần mười ê-pha bột lọc nhồi với một phần ba hin dầu, ");
INSERT INTO vie1934_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","và một phần ba hin rượu làm lễ quán, mà dâng có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Nhược bằng ngươi dâng một con bò tơ, hoặc làm của lễ thiêu, hoặc làm của lễ trả sự hứa nguyện hay là làm của lễ thù ân cho Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","thì phải dâng chung với con bò tơ một của lễ chay bằng ba phần mười ê-pha bột lọc nhồi với nửa hin dầu, ");
INSERT INTO vie1934_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","và dâng nửa hin rượu làm lễ quán: ấy là một của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Người ta cũng phải làm như vậy về mỗi con bò đực, mỗi con chiên đực, mỗi con chiên con, hay là mỗi con dê con. ");
INSERT INTO vie1934_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Tùy theo số con sinh mà các ngươi sẽ dâng, thì phải làm như vậy cho mỗi con. ");
INSERT INTO vie1934_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Phàm người sanh ra trong xứ phải làm như vậy, khi nào dâng một của lễ dùng lửa đốt, có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nếu một khách ngoại bang kiều ngụ trong các ngươi hay là một người nào ở giữa các ngươi từ đời nầy sang đời kia, dùng lửa dâng một của lễ có mùi thơm cho Đức Giê-hô-va, thì phải làm y như các ngươi làm vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Trong hội chúng chỉ đồng có một luật lệ cho các ngươi và cho khách ngoại bang kiều ngụ giữa các ngươi. Aáy sẽ là một lệ định đời đời cho dòng dõi các ngươi trước mặt Đức Giê-hô-va; khách ngoại bang cũng đồng như các ngươi vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Sẽ có một luật và một lệ như nhau cho các ngươi và cho khách ngoại bang kiều ngụ giữa các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Đức Giê-hô-va cũng phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Hãy nói cho dân Y-sơ-ra-ên rằng: Khi nào các ngươi đã vào xứ mà ta sẽ dẫn các ngươi vào, ");
INSERT INTO vie1934_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","và ăn bánh của xứ đó, thì các ngươi phải lấy một lễ vật dâng giơ lên cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Các ngươi phải lấy ra một cái bánh nhỏ làm lễ vật, tức là bánh đầu-tiên về bột nhồi của các ngươi; các ngươi phải dâng y một cách như dâng giơ lên lễ vật về sân đạp lúa vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Từ đời nầy sang đời kia, các ngươi phải dâng giơ lên cho Đức Giê-hô-va một lễ vật về bột nhồi đầu tiên của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Khi các ngươi lầm lỡ phạm tội, không giữ hết thảy các điều răn nầy mà Đức Giê-hô-va đã truyền cho Môi-se, ");
INSERT INTO vie1934_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","nghĩa là mọi điều chi Đức Giê-hô-va đã cậy Môi-se truyền cho các ngươi, từ ngày Đức Giê-hô-va truyền những điều răn nầy cho và về ngày sau, trong những dòng dõi sẽ đến của các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","nếu là tội phạm vì lầm lỡ mà hội chúng không hay biết, thì cả hội chúng tùy theo mạng lịnh phải dùng một con bò đực tơ dâng làm của lễ thiêu có mùi thơm cho Đức Giê-hô-va, luôn với của lễ chay cùng lễ quán cặp theo; và một con dê đực làm của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Thầy tế lễ sẽ làm lễ chuộc tội cho cả hội dân Y-sơ-ra-ên, thì tội hội chúng sẽ được tha, vì là một tội phạm lầm lỡ và vì hội chúng đã đem đến trước mặt Đức Giê-hô-va lễ vật mình, tức là một của lễ dùng lửa dâng cho Đức Giê-hô-va, luôn với của lễ chuộc tội đặng chữa sự lầm lỡ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Cả hội dân Y-sơ-ra-ên và khách ngoại bang kiều ngụ trong dân đó sẽ được tha tội, vì là bởi lầm lỡ mà cả dân sự đã phạm tội. ");
INSERT INTO vie1934_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Nhược bằng chỉ một người lầm lỡ phạm tội, thì người đó phải dâng một con dê cái giáp năm làm của lễ chuộc tội; ");
INSERT INTO vie1934_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","thầy tế lễ sẽ làm lễ chuộc tội cho người đã lầm lỡ mà phạm tội như vậy trước mặt Đức Giê-hô-va, và khi đã làm lễ chuộc tội cho người, thì người sẽ được tha. ");
INSERT INTO vie1934_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Khi lầm lỡ mà phạm tội, thì sẽ có đồng một luật lệ cho các ngươi, hoặc là người sanh giữa dân Y-sơ-ra-ên hay là khách kiều ngụ trong dân đó. ");
INSERT INTO vie1934_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Nhưng ai cố ý phạm tội, hoặc người sanh trong xứ, hay là khách ngoại bang, thì ai đó khinh bỉ Đức Giê-hô-va; người sẽ bị truất khỏi dân sự mình, ");
INSERT INTO vie1934_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","vì người đã khinh bỉ lời Đức Giê-hô-va và trái mạng của Ngài: người hẳn sẽ bị truất diệt, tội gian ác người đổ lại trên mình người. ");
INSERT INTO vie1934_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Vả, dân Y-sơ-ra-ên đang ở tại đồng vắng, gặp một người lượm củi trong ngày sa-bát; ");
INSERT INTO vie1934_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","những kẻ gặp người đang lượm củi dẫn người đến Môi-se, A-rôn, và cả hội chúng. ");
INSERT INTO vie1934_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Họ bắt người giam tù, vì điều phải làm cho người chưa nhất định. ");
INSERT INTO vie1934_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Đức Giê-hô-va bèn phán cùng Môi-se rằng: Người nầy phải phạt xử tử, cả hội chúng hãy ném đá người ngoài trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Vậy, cả hội chúng đem người ra ngoài trại quân mà ném đá, và người chết, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Hãy nói cùng dân Y-sơ-ra-ên và biểu họ từ đời nầy sang đời kia hãy làm một cái tua nơi các chéo áo mình, và trên mỗi tua kết một sợi dây màu điều. ");
INSERT INTO vie1934_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Các ngươi phải mang cái tua nầy; khi thấy nó các ngươi sẽ nhớ lại hết thảy điều răn của Đức Giê-hô-va mà làm theo, không theo tư dục của lòng và mắt mình, là điều làm cho các ngươi sa vào sự thông dâm. ");
INSERT INTO vie1934_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Như vậy, các ngươi sẽ nhớ lại mà làm theo những điều răn của ta, và làm thánh cho Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ta là Giê-hô-va, Đức Chúa Trời của các ngươi, Đấng đã đem các ngươi ra khỏi xứ Ê-díp-tô đặng làm Đức Chúa Trời của các ngươi. Ta là Giê-hô-va, Đức Chúa Trời của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Vả, Cô-rê, con trai của Dít-sê-ha, cháu của Kê-hát, chít của Lê-vi, giục theo mình Đa-than và A-bi-ram, con trai của Ê-li-áp, cùng với Oân, con trai của Phê-lết, cháu Ru-bên. ");
INSERT INTO vie1934_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Các người nầy với hai trăm năm mươi người trong dân Y-sơ-ra-ên, vốn là quan tướng của hội, nghị viên của hội đồng, có danh giá, đều hiệp nhau dấy nghịch cùng Môi-se và A-rôn, ");
INSERT INTO vie1934_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","mà rằng: Thôi đủ rồi! vì cả hội chúng đều là thánh, và Đức Giê-hô-va ngự ở trong; vậy sao các ngươi tự cao trên hội chúng của Đức Giê-hô-va? ");
INSERT INTO vie1934_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Môi-se nghe điều đó, bèn sấp mặt xuống đất, ");
INSERT INTO vie1934_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","nói cùng Cô-rê và hết thảy kẻ hiệp với người mà rằng: Sáng mai, Đức Giê-hô-va sẽ tỏ cho biết ai thuộc về Ngài và ai là thánh; Ngài sẽ khiến người đó lại gần Ngài, tức khiến người nào mà Ngài đã chọn lấy đến gần Ngài. ");
INSERT INTO vie1934_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Hỡi Cô-rê, hãy làm điều nầy: Ngươi và hết thảy kẻ hiệp với ngươi hãy cầm lư hương; ");
INSERT INTO vie1934_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","sáng mai hãy để lửa ở trong và bỏ hương ở trên trước mặt Đức Giê-hô-va. Người nào mà Đức Giê-hô-va sẽ chọn, ấy là người thánh. Hỡi con cháu Lê-vi, thôi đủ rồi! ");
INSERT INTO vie1934_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Môi-se nói cùng Cô-rê rằng: Hỡi con cháu Lê-vi, bây giờ hãy nghe. ");
INSERT INTO vie1934_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Về phần các ngươi, Đức Chúa Trời của Y-sơ-ra-ên đã biệt các ngươi riêng ra với hội chúng Y-sơ-ra-ên, và khiến các ngươi đến gần Ngài đặng làm công việc trong đền tạm của Đức Giê-hô-va, đặng chực hầu việc trước mặt hội chúng, việc ấy há là nhỏ mọn sao? ");
INSERT INTO vie1934_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ngài biểu ngươi, hết thảy anh em ngươi với con cháu Lê-vi đến gần Ngài, các ngươi lại còn kiếm chức tế lễ nữa sao? ");
INSERT INTO vie1934_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Vì vậy, ngươi và toàn bè đảng của ngươi đều hiệp lại nghịch cùng Đức Giê-hô-va! Vì A-rôn là ai mà các ngươi lằm bằm cùng người? ");
INSERT INTO vie1934_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Môi-se sai đòi Đa-than và A-bi-ram, con trai Ê-li-áp; nhưng hai người đáp rằng: Chúng tôi không đi lên đâu. ");
INSERT INTO vie1934_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Há là điều nhỏ mọn mà ngươi đã đem chúng ta ra khỏi xứ đượm sữa và mật, đặng làm cho chúng ta chết trong đồng vắng, mà ngươi lại còn muốn lấn lướt trên chúng ta nữa sao? ");
INSERT INTO vie1934_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Quả thật, ngươi không có dẫn chúng ta đến trong một xứ đượm sữa và mật đâu, ngươi không cho chúng ta đồng ruộng hay là vườn nho làm sản nghiệp đâu! Ngươi toan khoét mắt của dân nầy ư? Chúng ta không đi lên đâu. ");
INSERT INTO vie1934_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Môi-se nổi giận lắm, thưa cùng Đức Giê-hô-va rằng: Xin đừng kể đến của lễ chay chúng nó nữa; tôi không có bắt nơi chúng nó một con lừa nào, và tôi cũng không có làm hại một ai trong bọn chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Đoạn, Môi-se nói cùng Cô-rê rằng: Ngày mai ngươi và toàn bè đảng ngươi với A-rôn hãy ra mắt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Mỗi người hãy lấy lư hương mình bỏ hương ở trong, rồi mỗi người dâng lư hương mình trước mặt Đức Giê-hô-va, tức là hai trăm năm mươi cái lư hương. Ngươi và A-rôn, mỗi người cũng phải có lư hương mình. ");
INSERT INTO vie1934_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Vậy, mỗi người lấy lư hương mình để lửa vào, bỏ hương trên, rồi đứng tại cửa hội mạc luôn với Môi-se và A-rôn. ");
INSERT INTO vie1934_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Cô-rê hiệp cả hội chúng nghịch lại Môi-se và A-rôn tại cửa hội mạc; sự vinh quang của Đức Giê-hô-va hiện ra cùng cả hội chúng. ");
INSERT INTO vie1934_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Đoạn, Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Hãy tách khỏi giữa hội chúng nầy, thì ta sẽ tiêu diệt nó trong một lát. ");
INSERT INTO vie1934_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Hai người bèn sấp mặt xuống mà rằng: Oâi Đức Chúa Trời, là Chúa của thần linh mọi xác thịt! chỉ có một người phạm tội mà Chúa lại nổi giận cùng cả hội chúng sao? ");
INSERT INTO vie1934_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Hãy nói cùng hội chúng mà rằng: Hãy dan ra khỏi chung quanh chỗ ở của Cô-rê, Đa-than, và A-bi-ram. ");
INSERT INTO vie1934_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Môi-se đứng dậy, đi lại phía Đa-than và A-bi-ram; các trưởng lão Y-sơ-ra-ên đi theo người. ");
INSERT INTO vie1934_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Người nói cùng hội chúng rằng: Bây giờ, hãy dan ra khỏi trại của các người hung ác nầy, và chớ đụng đến vật chi thuộc về họ, e các ngươi sẽ chết vì những tội của họ chăng. ");
INSERT INTO vie1934_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Vậy, dân sự dan ra khỏi tứ phía chỗ ở của Cô-rê, Đa-than, và A-bi-ram. Đa-than và A-bi-ram ra đứng tại cửa trại với vợ, con trai và con nít mình. ");
INSERT INTO vie1934_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Môi-se bèn nói rằng: Nhờ điều nầy các ngươi sẽ biết rằng Đức Giê-hô-va có sai ta đặng làm các điều nầy, và ta chẳng làm sự chi tự ta. ");
INSERT INTO vie1934_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Nếu các kẻ đó chết như mọi người khác chết, nếu họ đồng chịu số phận chung như mọi người, thì Đức Giê-hô-va không có sai ta. ");
INSERT INTO vie1934_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Nhưng nếu Đức Giê-hô-va làm một sự thật mới, nếu đất hả miệng ra nuốt họ và mọi món chi thuộc về họ, nếu họ còn đang sống mà xuống âm phủ, thì các ngươi sẽ biết rằng những người nầy có khinh bỉ Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Vừa khi Môi-se nói dứt các lời nầy, đất ngay dưới chân họ bèn nứt ra; ");
INSERT INTO vie1934_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","hả miệng nuốt họ, gia quyến và hết thảy phe Cô-rê cùng tài sản của chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Các người đó còn đang sống và mọi vật chi thuộc về họ đều xuống âm phủ; đất lấp lại và chúng nó bị diệt khỏi hội chúng. ");
INSERT INTO vie1934_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Cả Y-sơ-ra-ên ở xung quanh nghe tiếng họ la, đều chạy trốn, vì nói rằng: Chúng ta hãy coi chừng, kẻo đất nuốt chúng ta chăng! ");
INSERT INTO vie1934_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Rồi một ngọn lửa từ Đức Giê-hô-va lòe ra thiêu hóa hai trăm năm mươi người đã dâng hương. ");
INSERT INTO vie1934_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Hãy nói với Ê-lê-a-sa, con trai thầy tế lễ A-rôn, biểu lượm các lư hương ra khỏi chỗ lửa cháy, và đổ lửa của các lư hương nơi xa, vì lư hương đã nên thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Còn những lư hương của các người đã phạm tội cùng sanh mạng mình, người ta phải lấy làm thành những tấm dát mỏng để bọc bàn thờ. Bởi các lư hương đã dâng trước mặt Đức Giê-hô-va đã thành thánh; những tấm dát đó sẽ dùng làm một dấu cho dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Vậy, Ê-lê-a-sa, thầy tế lễ, lấy những lư hương bằng đồng của các người bị thiêu đã dâng lên, và người ta làm thành những tấm dát mỏng để bọc bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Aáy là một kỷ niệm cho dân Y-sơ-ra-ên, để người nào ngoại dòng A-rôn chớ đến gần đặng xông hương trước mặt Đức Giê-hô-va, kẻo e đồng số phận cùng Cô-rê và bè đảng người, theo lời Đức Giê-hô-va đã cậy Môi-se truyền dạy. ");
INSERT INTO vie1934_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ngày mai, cả hội dân Y-sơ-ra-ên lằm bằm cùng Môi-se và A-rôn mà rằng: Hai người đã làm chết dân của Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Khi hội chúng đang hiệp nhau nghịch cùng Môi-se và A-rôn, thì ngó về hướng hội mạc, xảy thấy trụ mây bao phủ hội mạc, và sự vinh quang của Đức Giê-hô-va hiện ra. ");
INSERT INTO vie1934_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Môi-se và A-rôn đến đứng trước hội mạc, ");
INSERT INTO vie1934_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Hãy dan ra khỏi giữa hội chúng nầy, thì ta sẽ tiêu diệt nó trong một lát. Nhưng hai người sấp mặt xuống đất, ");
INSERT INTO vie1934_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","rồi Môi-se nói cùng A-rôn rằng: Hãy cầm lấy lư hương để lửa từ trên bàn thờ vào, bỏ hương lên trên, mau mau đi đến hội chúng và làm lễ chuộc tội cho họ; vì sự thạnh nộ của Đức Giê-hô-va đã nổi lên, và tai vạ đã phát khởi. ");
INSERT INTO vie1934_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","A-rôn bèn cầm lấy lư hương y như Môi-se đã biểu, chạy đến giữa hội chúng; kìa, tai vạ đã phát khởi giữa dân sự. A-rôn bèn bỏ hương vào, và làm lễ chuộc tội cho dân sự. ");
INSERT INTO vie1934_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Người đứng giữa kẻ chết và kẻ sống, thì tai vạ bèn ngừng lại. ");
INSERT INTO vie1934_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Có mười bốn ngàn bảy trăm người chết vì tai vạ nầy, trừ ra những kẻ đã bị chết vì cớ Cô-rê. ");
INSERT INTO vie1934_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Đoạn, A-rôn trở về cùng Môi-se tại cửa hội mạc, rồi tai vạ ngừng lại. ");
INSERT INTO vie1934_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Kế đó, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Hãy nói cùng dân Y-sơ-ra-ên và biểu rằng: Mỗi chi phái của họ phải đem nộp cho ngươi một cây gậy; nghĩa là mười hai cây gậy bởi các quan trưởng của mỗi chi phái. ");
INSERT INTO vie1934_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ngươi phải đề tên mỗi người trên cây gậy của mình, và đề tên A-rôn trên cây gậy của Lê-vi; vì phải có một cây gậy cho mỗi trưởng tộc. ");
INSERT INTO vie1934_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ngươi phải để các gậy đó trong hội mạc, trước hòm bảng chứng, là nơi ta gặp ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Hễ người nào ta chọn lấy, thì cây gậy người đó sẽ trổ hoa; vậy ta sẽ làm cho nín đi trước mặt ta những lời lằm bằm của dân Y-sơ-ra-ên đã phát ra đối nghịch cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Môi-se nói cùng dân Y-sơ-ra-ên, thì hết thảy trưởng tộc, tùy theo chi phái mình, đem nộp cho người một cây gậy, tức là mười hai cây. Gậy của A-rôn ở giữa các cây gậy khác. ");
INSERT INTO vie1934_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Môi-se để những gậy đó trong Trại bảng chứng trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ngày mai, khi Môi-se vào Trại bảng chứng, xảy thấy cây gậy A-rôn về nhà Lê-vi đã trổ hoa: nó có nứt mụt, sanh hoa và trái hạnh nhân chín. ");
INSERT INTO vie1934_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Môi-se bèn rút các cây gậy khỏi trước mặt Đức Giê-hô-va, đem đưa cho cả dân Y-sơ-ra-ên; các người đều thấy và mỗi người lấy gậy mình lại. ");
INSERT INTO vie1934_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy đem cây gậy của A-rôn để lại trước hòm bảng chứng, đặng giữ làm một dấu cho con cái phản nghịch; ngươi phải làm cho nín đi những lời lằm bằm đối nghịch cùng ta, hầu cho dân chúng chẳng chết. ");
INSERT INTO vie1934_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Môi-se làm như vậy, tức làm y như Đức Giê-hô-va đã phán dặn mình. ");
INSERT INTO vie1934_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Dân Y-sơ-ra-ên nói cùng Môi-se rằng: Nầy, chúng tôi bị diệt, chúng tôi bị chết, chúng tôi chết mất hết thảy! ");
INSERT INTO vie1934_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Phàm ai đến gần đền tạm của Đức Giê-hô-va đều chết. Có lẽ chúng tôi phải chết hết sao? ");
INSERT INTO vie1934_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Đức Giê-hô-va bèn phán cùng A-rôn rằng: Ngươi, các con trai ngươi, và tông tộc ngươi phải mang lấy những tội lỗi phạm trong nơi thánh; còn ngươi và các con trai ngươi phải mang lấy những tội lỗi phạm trong chức tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Cũng hãy biểu đến gần ngươi các anh em mình, là chi phái Lê-vi, tức tông tộc ngươi, đặng các người đó hiệp với ngươi và hầu việc ngươi; nhưng ngươi và các con trai ngươi phải ở trước Trại bảng chứng. ");
INSERT INTO vie1934_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Các người đó sẽ gìn giữ điều chi ngươi truyền dạy, và điều nào thuộc về cả Trại; chỉ không nên lại gần những vật thánh, cũng đừng lại gần bàn thờ, e khi chúng nó phải chết, và các ngươi cũng chết luôn chăng. ");
INSERT INTO vie1934_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Vậy, các người đó sẽ hiệp với ngươi coi sóc điều chi thuộc về hội mạc, và giữ công việc của Trại; một người ngoại nào chẳng nên đến gần các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Các ngươi phải coi sóc điều chi thuộc về nơi thánh và bàn thờ để đừng có sự thạnh nộ cùng dân Y-sơ-ra-ên nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Còn ta đây, trong dân Y-sơ-ra-ên ta đã chọn lấy anh em các ngươi, là những người Lê-vi, mà ban cho các ngươi, vì đã dâng cho Đức Giê-hô-va rồi, đặng làm công việc của hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Nhưng ngươi và các con trai ngươi phải kỹ lưỡng lo cho xong chức tế lễ, quản trị các điều chi thuộc về bàn thờ, và vật chi ở phía trong màn; các ngươi phải làm việc mình tại đó. Chức tế lễ của các ngươi là một việc ta phong cho như một của ban: người ngoại nào đến gần sẽ bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Đức Giê-hô-va lại phán cùng A-rôn rằng: Nầy ta cử ngươi coi sóc các lễ vật của ta thâu lấy về mọi-vật mà dân Y-sơ-ra-ên đã biệt riêng ra thánh; cứ một lệ định đời đời ta ban những lễ vật nầy cho ngươi và cho các con trai ngươi như một phần riêng mà phép xức dầu truyền cho. ");
INSERT INTO vie1934_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Trong các vật rất thánh không có thiêu hóa mà dân Y-sơ-ra-ên dâng cho ta, nầy là phần sẽ thuộc về ngươi: Hết thảy lễ vật của họ, nào của lễ chay, nào của lễ chuộc tội, nào của lễ chuộc sự mắc lỗi; những vật rất thánh nầy đều sẽ thuộc về ngươi và các con trai ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ngươi phải ăn nó trong nơi rất thánh; mọi người nam phải ăn lấy, ấy sẽ làm một vật thánh cho ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Vật nầy cũng sẽ thuộc về ngươi: Phàm lễ vật nào mà dân Y-sơ-ra-ên dâng giơ lên và đưa qua đưa lại, thì ta cứ một lệ định đời đời mà ban cho ngươi và các con trai con gái ngươi. Ai trong nhà ngươi tinh sạch sẽ được ăn các món đó. ");
INSERT INTO vie1934_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ta cũng đã ban cho ngươi những vật đầu mùa mà dân Y-sơ-ra-ên sẽ dâng cho Đức Giê-hô-va, hết thảy phần dầu, rượu ngọt và lúa miến nhất hạng. ");
INSERT INTO vie1934_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mọi hoa quả đầu mùa của đất sanh sản mà dân Y-sơ-ra-ên dâng cho Đức Giê-hô-va, đều sẽ thuộc về ngươi; ai trong nhà ngươi tinh sạch sẽ được ăn lấy. ");
INSERT INTO vie1934_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Phàm vật chi mà dân Y-sơ-ra-ên phú dâng sẽ thuộc về ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Mọi con đầu lòng của các xác thịt, hoặc ngươi, hoặc vật mà dân Y-sơ-ra-ên dâng cho Đức Giê-hô-va, đều sẽ thuộc về ngươi; nhưng ngươi phải chuộc lại con đầu lòng của loài người, và cũng phải chuộc lại con đầu lòng của thú vật ô uế. ");
INSERT INTO vie1934_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Về sự chuộc lại, ngươi phải chuộc lại những con từ một tháng trở đi, theo giá định của ngươi, là năm siếc-lơ bạc, theo siếc-lơ của nơi thánh; một siết-lơ của nơi thánh là hai mươi ghê-ra. ");
INSERT INTO vie1934_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Nhưng ngươi chớ chuộc lại con đầu lòng của bò cái, hoặc con đầu lòng của chiên cái hay là con đầu lòng của dê cái; ấy là những vật thánh. Ngươi phải rưới huyết nó trên bàn thờ, và xông mỡ nó làm của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Thịt nó sẽ thuộc về ngươi như cái o dâng đưa qua đưa lại và cái giò hữu. ");
INSERT INTO vie1934_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ta cứ lệ định đời đời ban cho ngươi, các con trai và các con gái ngươi, hết thảy lễ vật thánh mà dân Y-sơ-ra-ên dâng giơ lên cho Đức Giê-hô-va: ấy là một giao ước bằng muối đời đời, không bỏ được, trước mặt Đức Giê-hô-va cho ngươi và cho dòng dõi ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Đoạn, Đức Giê-hô-va phán cùng A-rôn rằng: Ngươi sẽ không có cơ nghiệp trong xứ dân Y-sơ-ra-ên; và chẳng sẽ có phần cho ngươi giữa dân đó; ta là phần của ngươi, và là cơ nghiệp của ngươi ở giữa dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Còn về con cháu Lê-vi, nầy ta đã ban cho làm cơ nghiệp, mọi thuế một phần mười của Y-sơ-ra-ên làm lương về công việc mình làm trong hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Dân Y-sơ-ra-ên chớ lại gần hội mạc nữa, e phải mắc tội và chết chăng. ");
INSERT INTO vie1934_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Nhưng ấy là người Lê-vi sẽ làm công việc của hội mạc; bằng có phạm tội, thì tự mang lấy; chúng nó sẽ không có phần cơ nghiệp giữa dân Y-sơ-ra-ên; ấy sẽ là một lệ định đời đời trải qua các thế đại. ");
INSERT INTO vie1934_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Vì ta đã ban cho người Lê-vi làm cơ nghiệp, những thuế một phần mười của dân Y-sơ-ra-ên dâng giơ lên cho Đức Giê-hô-va. Bởi cớ đó, ta đã phán về họ rằng: Họ sẽ không có cơ nghiệp giữa dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Ngươi cũng phải truyền cho người Lê-vi rằng: Khi nào các ngươi đã lãnh của dân Y-sơ-ra-ên thuế một phần mười mà ta đã ban về phần dân đó đặng làm cơ nghiệp của các ngươi, thì hãy lấy một phần mười của vật thuế một phần mười, mà làm của lễ dâng giơ lên cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Lễ vật dâng giơ lên của các ngươi sẽ kể như lúa mì lấy nơi sân đạp lúa, và như sự đầy dẫy của hầm rượu. ");
INSERT INTO vie1934_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Thế thì, trong những thuế một phần mười mà các ngươi lãnh nơi dân Y-sơ-ra-ên, thì cũng phải lấy ra một phần mười làm lễ vật dâng giơ lên cho Đức Giê-hô-va, và giao lễ vật của Đức Giê-hô-va đó cho A-rôn, thầy tế lễ. ");
INSERT INTO vie1934_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Trong những lễ vật lãnh được, các ngươi phải lấy ra phần tốt nhất, biệt riêng ra thánh mà dâng giơ lên cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ngươi phải nói cùng người Lê-vi rằng: Khi nào các ngươi đã dâng giơ lên phần tốt nhất của thuế một phần mười, thì sẽ kể cho người Lê-vi như huê lợi của sân đạp lúa, và như huê lợi của hầm rượu vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Các ngươi và gia quyến các ngươi phải ăn nó trong nơi nào cũng được, vì là công giá mình về việc các ngươi làm trong hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Bởi cớ ấy, khi các ngươi đã dâng giơ lên phần tốt nhất, các ngươi sẽ không mắc tội, sẽ không làm ô uế những vật thánh của dân Y-sơ-ra-ên, và các ngươi không chết đâu. ");
INSERT INTO vie1934_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Đức Giê-hô-va lại phán cùng Môi-se và A-rôn rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Nầy là lệ định của luật pháp mà Đức Giê-hô-va có truyền rằng: Hãy nói cùng dân Y-sơ-ra-ên và biểu dẫn đến người một con bò cái tơ sắc hoe, không tật không vít, và chưa mang ách. ");
INSERT INTO vie1934_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Đoạn phải giao nó cho Ê-lê-a-sa, thầy tế lễ, dẫn ra ngoài trại quân, rồi người ta giết nó trước mặt người. ");
INSERT INTO vie1934_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ê-lê-a-sa, thầy tế lễ, sẽ dùng ngón tay nhúng huyết nó rảy bảy lần phía trước của hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Người ta sẽ thiêu con bò cái tơ đó trước mắt người, là thiêu da, thịt, và huyết với phẩn nó. ");
INSERT INTO vie1934_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kế đó, thầy tế lễ sẽ lấy cây hương nam, chùm kinh giới, và màu đỏ sặm, liệng vào giữa đám lửa thiêu con bò cái tơ. ");
INSERT INTO vie1934_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Đoạn, thầy tế lễ phải giặt áo xống và tắm mình trong nước, sau rồi vào trại quân, bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Kẻ nào thiêu con bò cái tơ phải giặt áo xống và tắm mình trong nước, bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Một người tinh sạch sẽ hốt tro con bò cái tơ đổ ngoài trại quân, trong một nơi tinh sạch; người ta phải giữ tro đó cho hội dân Y-sơ-ra-ên để dùng làm nước tẩy uế: ấy là một của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Kẻ nào hốt tro con bò cái tơ phải giặt áo xống mình và bị ô uế đến chiều tối. Điều nầy sẽ làm một lệ định đời đời cho dân Y-sơ-ra-ên và cho khách ngoại bang kiều ngụ giữa dân đó. ");
INSERT INTO vie1934_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ai đụng đến một xác chết của người nào sẽ bị ô uế trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ngày thứ ba và ngày thứ bảy, người ấy phải dùng nước nầy làm cho mình được sạch, thì sẽ được sạch; còn nếu ngày thứ ba và ngày thứ bảy không làm cho mình được sạch, thì người vẫn không tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Phàm người nào đụng đến xác chết của người nào và không làm cho mình được sạch, thì sẽ gây cho đền tạm của Đức Giê-hô-va bị ô uế. Người đó sẽ bị truất khỏi Y-sơ-ra-ên; vì nước tẩy uế không có rảy trên mình người, nên người vẫn ô uế; sự ô uế của người vẫn ở trên mình người vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Nầy là luật pháp khi có một người nào chết trong trại: bất k” ai vào trại và mọi vật chi ở trong đều sẽ bị ô uế trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Phàm bình đựng nào để trống, không có nắp đậy buộc theo, sẽ bị ô uế. ");
INSERT INTO vie1934_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ngoài đồng, ai đụng đến hoặc một người bị gươm giết, hoặc một xác chết, hoặc hài cốt loài người hay là một cái mả, thì sẽ bị ô uế trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Về kẻ bị ô uế, người ta phải lấy tro của con sinh đã bị thiêu đặng chuộc tội, để trong một cái bình và đổ nước chảy lên trên. ");
INSERT INTO vie1934_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Đoạn, một người tinh sạch sẽ lấy chùm kinh giới nhúng vào nước, rồi rảy trên trại, trên các bình, trên những người có tại đó, và trên người đã đụng, hoặc những hài cốt, hoặc một người bị giết, hoặc một xác chết hay là một cái mả. ");
INSERT INTO vie1934_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ngày thứ ba và ngày thứ bảy, người tinh sạch phải rảy nước đó trên người bị ô uế, và ngày thứ bảy người tinh sạch sẽ làm cho người được sạch, Người đang được sạch phải giặt áo xống mình, tắm mình trong nước, và đến chiều tối mới được tinh sạch. ");
INSERT INTO vie1934_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Còn người nào sẽ bị ô uế mà không làm cho mình được sạch, một người như vậy sẽ bị truất khỏi hội chúng; vì người đã làm cho nơi thánh của Đức Giê-hô-va bị ô uế. Nước tẩy uế không có rưới trên mình người: người vẫn ô uế. ");
INSERT INTO vie1934_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Aáy sẽ là một lệ định đời đời cho dân sự. Người nào rảy nước tẩy uế sẽ giặt áo xống mình: kẻ nào đụng đến nước tẩy uế sẽ bị ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Phàm vật chi mà người ô uế đụng đến, đều sẽ bị lây ô uế; còn ai đụng đến người đó sẽ bị lây ô uế đến chiều tối. ");
INSERT INTO vie1934_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Tháng giêng, cả hội dân Y-sơ-ra-ên tới đồng vắng Xin; và dừng lại tại Ca-đe. Mi-ri-am qua đời và được chôn tại đó. ");
INSERT INTO vie1934_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Vả, không có nước cho hội chúng uống; chúng bèn dấy loạn cùng Môi-se và A-rôn. ");
INSERT INTO vie1934_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Dân sự cãi-lộn cùng Môi-se mà rằng: Anh em chúng tôi đã chết trước mặt Đức Giê-hô-va, chớ chi chúng tôi cũng đồng chết luôn thể! ");
INSERT INTO vie1934_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Sao người đem hội chúng của Đức Giê-hô-va vào đồng vắng nầy, làm cho chúng tôi và súc vật của chúng tôi phải chết? ");
INSERT INTO vie1934_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Sao người khiến chúng tôi đi lên khỏi xứ Ê-díp-tô đặng dẫn đến chỗ độc nầy, là nơi người ta không gieo mạ được, và chẳng có cây vả, cây nho, cây lựu, và cũng không có nước uống? ");
INSERT INTO vie1934_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Môi-se và A-rôn bèn lui khỏi mặt hội chúng, đến tại cửa hội mạc, sấp mặt xuống đất; và sự vinh quang của Đức Giê-hô-va hiện ra cùng hai người. ");
INSERT INTO vie1934_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Hãy cầm lấy cây gậy ngươi, rồi với A-rôn anh ngươi, hãy truyền nhóm hội chúng, và hai ngươi phải nói cùng hòn đá trước mặt hội chúng, thì hòn đá sẽ chảy nước ra; ngươi sẽ khiến nước từ hòn đá chảy ra cho hội chúng và súc vật của họ uống. ");
INSERT INTO vie1934_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Vậy, Môi-se cầm lấy cây gậy ở trước mặt Đức Giê-hô-va, như Ngài đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Môi-se và A-rôn truyền nhóm hội chúng đến trước hòn đá mà nói rằng: Hỡi dân phản nghịch! hãy nghe, chúng ta há dễ khiến nước chảy từ hòn đá nầy ra cho các ngươi được sao? ");
INSERT INTO vie1934_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Môi-se giơ tay lên, đập hòn đá hai lần bằng cây gậy mình. Nước bèn chảy tràn ra nhiều, hội chúng uống, và súc vật họ uống nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Đoạn, Đức Giê-hô-va phán cùng Môi-se và A-rôn rằng: Bởi vì hai ngươi không có tin đến ta, đặng tôn ta nên thánh trước mặt dân Y-sơ-ra-ên, vì cớ đó, hai ngươi sẽ không đem hội chúng nầy vào xứ mà ta đã cho nó đâu. ");
INSERT INTO vie1934_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Aáy đó là nước của Mê-ri-ba, tức là nơi dân Y-sơ-ra-ên cãi-trã cùng Đức Giê-hô-va; Ngài tự nên thánh trước mặt dân đó. ");
INSERT INTO vie1934_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Đoạn, từ Ca-đe, Môi-se sai sứ giả đi đến vua Ê-đôm đặng nói rằng: Y-sơ-ra-ên, là em vua, có nói như vầy: Vua biết các sự tai nạn đã xảy đến cho chúng tôi, ");
INSERT INTO vie1934_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","và tổ phụ chúng tôi đi xuống xứ Ê-díp-tô là làm sao? Chúng tôi đã ở lâu tại xứ Ê-díp-tô, nhưng dân xứ đó bạc đãi chúng tôi và tổ phụ chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Chúng tôi có kêu la cùng Đức Giê-hô-va; Ngài có nghe thấu tiếng kêu, bèn sai một thiên sứ dẫn chúng tôi ra khỏi xứ Ê-díp-tô. Nầy, chúng tôi hiện ở tại Ca-đe, là thành ở nơi đầu bờ cõi của vua. ");
INSERT INTO vie1934_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Xin cho phép chúng tôi đi ngang qua xứ của vua; chúng tôi sẽ chẳng đi ngang qua đồng ruộng, sẽ chẳng đi ngang vườn nho, và chúng tôi cũng sẽ chẳng uống nước các giếng; chúng tôi sẽ đi theo đường cái của vua, không xây qua bên hữu, cũng không xây qua bên tả cho đến chừng nào đã đi ngang khỏi bờ cõi của vua. ");
INSERT INTO vie1934_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Nhưng Ê-đôm đáp rằng: Ngươi chớ khá đi ngang ranh ta; bằng cượng, ta sẽ cầm gươm ra đón ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Dân Y-sơ-ra-ên tâu rằng: Chúng tôi đi theo đường cái; nếu chúng tôi và bầy súc vật chúng tôi uống nước của vua, thì chúng tôi sẽ trả tiền. Xin chỉ để đi bộ ngang qua, không chi khác nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Nhưng Ê-đôm đáp rằng: Ngươi chẳng được qua đâu! Ê-đôm bèn đem quân chúng rất đông, tay cầm binh khí, ra đón Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Aáy vậy, Ê-đôm không cho phép Y-sơ-ra-ên đi ngang bờ cõi mình; Y-sơ-ra-ên trở đi khỏi người. ");
INSERT INTO vie1934_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Cả hội dân Y-sơ-ra-ên đi từ Ca-đe đến núi Hô-rơ. ");
INSERT INTO vie1934_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Đức Giê-hô-va phán cùng Môi-se và A-rôn trên núi Hô-rơ, tại bờ cõi xứ Ê-đôm, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","A-rôn sẽ về nơi tổ phụ mình, vì người không được vào xứ mà ta đã ban cho dân Y-sơ-ra-ên đâu; bởi vì tại nước Mê-ri-ba, các ngươi đã bội nghịch điều răn ta. ");
INSERT INTO vie1934_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Hãy bắt A-rôn và Ê-lê-a-sa, con trai người, biểu đi lên núi Hô-rơ; ");
INSERT INTO vie1934_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","đoạn hãy lột áo xống A-rôn mặc cho Ê-lê-a-sa, con trai người. Aáy tại đó A-rôn sẽ được tiếp về và qua đời. ");
INSERT INTO vie1934_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Vậy, Môi-se làm y như Đức Giê-hô-va đã phán dặn; ba người đi lên núi Hô-rơ, cả hội chúng đều thấy. ");
INSERT INTO vie1934_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Môi-se lột áo xống A-rôn, mặc cho Ê-lê-a-sa, con trai người. A-rôn chết tại đó, trên chót núi; rồi Môi-se và Ê-lê-a-sa đi xuống. ");
INSERT INTO vie1934_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Cả hội chúng thấy A-rôn đã tắt hơi rồi, bèn khóc người trong ba mươi ngày. ");
INSERT INTO vie1934_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Khi vua A-rát, người Ca-na-an, ở nơi Nam phương, hay rằng Y-sơ-ra-ên theo đường do thám đi đến, bèn hãm đánh Y-sơ-ra-ên, và bắt mấy người cầm tù. ");
INSERT INTO vie1934_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Y-sơ-ra-ên bèn hứa nguyện cùng Đức Giê-hô-va rằng: Nếu Chúa phó dân nầy vào tay tôi, tất tôi sẽ diệt các thành của nó. ");
INSERT INTO vie1934_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Đức Giê-hô-va nhậm lời dân Y-sơ-ra-ên và phó dân Ca-na-an cho. Người ta diệt hết dân đó và các thành của nó, đặt tên chỗ nầy là Họt-ma. ");
INSERT INTO vie1934_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Đoạn, dân Y-sơ-ra-ên đi từ núi Hô-rơ về hướng Biển đỏ, đặng đi vòng theo xứ Ê-đôm; giữa đường dân sự ngã lòng. ");
INSERT INTO vie1934_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Vậy, dân sự nói nghịch cùng Đức Chúa Trời và Môi-se mà rằng: Làm sao người khiến chúng tôi lên khỏi xứ Ê-díp-tô đặng chết trong đồng vắng? Vì đây không có bánh, cũng không có nước, và linh hồn chúng tôi đã ghê gớm thứ đồ ăn đạm bạc nầy. ");
INSERT INTO vie1934_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Đức Giê-hô-va sai con rắn lửa đến trong dân sự, cắn dân đó đến đỗi người Y-sơ-ra-ên chết rất nhiều. ");
INSERT INTO vie1934_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Dân sự bèn đến cùng Môi-se mà nói rằng: Chúng tôi có phạm tội, vì đã nói nghịch Đức Giê-hô-va và người. Hãy cầu xin Đức Giê-hô-va để Ngài khiến rắn lìa xa chúng tôi. Môi-se cầu khẩn cho dân sự. ");
INSERT INTO vie1934_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy làm lấy một con rắn lửa, rồi treo nó trên một cây sào. Nếu ai bị cắn và nhìn nó, thì sẽ được sống. ");
INSERT INTO vie1934_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Vậy, Môi-se làm một con rắn bằng đồng, rồi treo lên một cây sào; nếu người nào đã bị rắn cắn mà nhìn con rắn bằng đồng, thì được sống. ");
INSERT INTO vie1934_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Kế đó, dân Y-sơ-ra-ên đi và đóng trại tại Ô-bốt. ");
INSERT INTO vie1934_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Đoạn, đi từ Ô-bốt và đóng trại tại Y-giê-A-ba-rim, tại đồng vắng, đối ngang Mô-áp về hướng mặt trời mọc. ");
INSERT INTO vie1934_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Họ đi từ đó đóng trại tại đèo Xê-rết. ");
INSERT INTO vie1934_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Rồi từ đó đi và đóng trại phía bên kia Aït-nôn, ở trong đồng vắng, vừa ra bờ cõi dân A-mô-rít; vì Aït-nôn là giáp-ranh của dân Mô-áp và dân A-mô-rít. ");
INSERT INTO vie1934_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Bởi cớ đó, trong sách chiến trận của Đức Giê-hô-va có nói rằng: Va-hép ở tại Su-pha, và trũng Aït-nôn, ");
INSERT INTO vie1934_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","cùng những triền trũng chạy xuống phía A-rơ, và đụng ranh Mô-áp. ");
INSERT INTO vie1934_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Từ đó dân Y-sơ-ra-ên đến Bê-re, ấy đó là cái giếng mà Đức Giê-hô-va phán cùng Môi-se rằng: Hãy nhóm hiệp dân sự, ta sẽ cho chúng nó nước. ");
INSERT INTO vie1934_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Y-sơ-ra-ên bèn hát bài nầy: Hỡi giếng, hãy tuôn lên! hãy ca hát cho nó! ");
INSERT INTO vie1934_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Giếng mà các vua chúa đã khai, Các tước vị của dân sự đã đào Với phủ việt cùng cây gậy mình! ");
INSERT INTO vie1934_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Kế đó, từ đồng vắng dân Y-sơ-ra-ên đến Ma-tha-na; rồi từ Ma-tha-na đến Na-ha-li-ên; từ Na-ha-li-ên đến Ba-mốt; ");
INSERT INTO vie1934_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","và từ Ba-mốt đến trũng ở trong bờ cõi Mô-áp, tại chót núi Phích-ga, là nơi người ta nhìn thấy đồng bằng của sa mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Vả, Y-sơ-ra-ên sai sứ giả đến Si-hôn, vua dân A-mô-rít, đặng nói rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Xin cho phép chúng tôi đi ngang qua xứ vua, chúng tôi sẽ không xây vào đồng ruộng, hay là vào vườn nho, và chúng tôi cũng sẽ không uống nước các giếng, cứ đi đường cái của vua cho đến chừng nào qua khỏi bờ cõi vua. ");
INSERT INTO vie1934_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Nhưng Si-hôn không cho phép Y-sơ-ra-ên đi ngang qua bờ cõi mình, bèn hiệp hết dân sự mình đi ra đón Y-sơ-ra-ên về hướng đồng vắng; người đến Gia-hát, chiến trận cùng Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Song Y-sơ-ra-ên dùng lưỡi gươm đánh bại người, và chiếm xứ người từ Aït-nôn đến Gia-bốc, đến dân Am-môn; vì bờ cõi dân Am-môn bền vững. ");
INSERT INTO vie1934_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Y-sơ-ra-ên chiếm hết các thành nầy, và ở trong các thành dân A-mô-rít, là ở tại Hết-bôn và trong các thành địa-hạt. ");
INSERT INTO vie1934_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Vì Hết-bôn là thành của Si-hôn, vua dân A-mô-rít, là vua đã giao chiến cùng vua trước của Mô-áp, chiếm lấy khắp hết xứ người đến Aït-nôn. ");
INSERT INTO vie1934_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Bởi cớ đó, những nhà văn sĩ nói rằng: Hãy đến Hết-bôn! Thành Si-hôn phải xây cất và lập vững! ");
INSERT INTO vie1934_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Vì có một đám lửa bởi thành Hết-bôn, Một ngọn lửa bởi thành Si-hôn mà ra; Nó thiêu đốt A-rơ của Mô-áp, Các chúa của nơi cao Aït-nôn ");
INSERT INTO vie1934_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Hỡi Mô-áp, khốn thay cho ngươi! Hỡi dân Kê-móc, ngươi đã diệt mất! Ngươi đã nộp con trai mình làm kẻ trốn tránh, Và con gái mình làm phu tù cho Si-hôn, vua A-mô-rít. ");
INSERT INTO vie1934_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Chúng ta đã bắn tên nhằm chúng nó. Hết-bôn đã bị hủy diệt cho đến Đi-bôn. Chúng ta đã làm tàn hại đến Nô-phách, Lửa đã lan đến Mê-đê-ba. ");
INSERT INTO vie1934_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Vậy, Y-sơ-ra-ên ở trong xứ dân A-mô-rít. ");
INSERT INTO vie1934_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Môi-se sai đi do thám Gia-ê-xe, chiếm các thành bổn hạt và đuổi dân A-mô-rít ở tại đó. ");
INSERT INTO vie1934_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Đoạn, dân Y-sơ-ra-ên trở lại đi lên về hướng Ba-san, Oùc, vua Ba-san, và cả dân sự người đi ra đón đặng chiến trận tại Eát-rê-i. ");
INSERT INTO vie1934_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Nhưng Đức Giê-hô-va phán cùng Môi-se rằng: Đừng sợ người, vì ta đã phó người, luôn dân sự và xứ người vào tay ngươi; ngươi khá làm cho người như đã làm cho Si-hôn, vua dân A-mô-rít ở tại Hết-bôn. ");
INSERT INTO vie1934_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Vậy, dân Y-sơ-ra-ên đánh bại Oùc, các con trai người và cả dân sự người, cho đến chừng không còn người nào ở lại; dân Y-sơ-ra-ên chiếm lấy xứ người vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Đoạn dân Y-sơ-ra-ên đi, đến đóng trại trong đồng bằng Mô-áp, bên kia sông Giô-đanh, đối-diện Giê-ri-cô. ");
INSERT INTO vie1934_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ba-lác, con trai Xếp-bô, thấy hết mọi điều Y-sơ-ra-ên đã làm cho dân A-mô-rít. ");
INSERT INTO vie1934_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Mô-áp lấy làm sợ sệt lắm và kinh khủng trước mặt dân Y-sơ-ra-ên, vì dân đó rất đông. ");
INSERT INTO vie1934_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Vậy, Mô-áp nói cùng các trưởng lão Ma-đi-an rằng: Bây giờ, đoàn dân đông nầy sẽ nuốt hết thảy chung quanh ta, khác nào con bò ăn cỏ trong đồng vậy. Đang lúc đó, Ba-lác, con trai Xếp-bô, làm vua Mô-áp. ");
INSERT INTO vie1934_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Người sai sứ giả đến cùng Ba-la-am, con trai Bê-ô, ở Phê-thô-rơ, tại trên mé sông, trong xứ của con cái dân sự mình, đặng gọi người mà nói rằng: Nầy một dân đã ra khỏi xứ Ê-díp-tô, phủ khắp mặt đất, và đóng lại đối ngang ta. ");
INSERT INTO vie1934_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Vậy, ta xin ngươi hãy đến bây giờ, rủa sả dân nầy cho ta, vì nó mạnh hơn ta. Có lẽ ta sẽ đánh bại dân nầy và đuổi nó khỏi xứ được; vì ta biết rằng kẻ nào ngươi chúc phước cho, thì được phước; còn kẻ nào ngươi rủa sả, thì bị rủa sả. ");
INSERT INTO vie1934_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Vậy, các trưởng lão Mô-áp đi cùng các trưởng lão Ma-đi-an, trong tay có lễ vật cho thầy bói, đến cùng Ba-la-am mà thuật lại những lời của Ba-lác. ");
INSERT INTO vie1934_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Người đáp rằng: Hãy ở lại đây đêm nay thì ta sẽ trả lời theo như lời Đức Giê-hô-va sẽ phán cùng ta. Các trưởng lão Mô-áp ở lại nhà Ba-la-am. ");
INSERT INTO vie1934_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Vả, Đức Chúa Trời đến cùng Ba-la-am và phán rằng: Những người ngươi có trong nhà là ai? ");
INSERT INTO vie1934_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ba-la-am thưa cùng Đức Chúa Trời rằng: Ba-lác, con trai Xếp-bô, vua Mô-áp, đã sai đến tôi đặng nói rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Nầy, một dân đã ra khỏi xứ Ê-díp-tô, phủ khắp mặt đất; hãy đến bây giờ, rủa sả dân đó cho ta; có lẽ ta sẽ đánh bại dân nầy và đuổi nó được. ");
INSERT INTO vie1934_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Đức Chúa Trời phán cùng Ba-la-am rằng: Ngươi chớ đi với chúng nó, chớ rủa sả dân nầy, vì dân nầy được ban phước. ");
INSERT INTO vie1934_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Sớm mai Ba-la-am dậy, nói cùng các sứ thần của Ba-lác rằng: Hãy trở về xứ các ngươi, vì Đức Giê-hô-va không cho ta đi cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Vậy, các sứ thần Mô-áp dậy, trở về Ba-lác mà tâu rằng: Ba-la-am từ chối đến cùng chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ba-lác lại sai nhiều sứ thần hơn và tôn trọng hơn những người trước, ");
INSERT INTO vie1934_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","đến cùng Ba-la-am mà rằng: Ba-lác, con trai Xếp-bô, có nói như vầy: Ta xin ngươi, chớ có chi ngăn cản ngươi đến cùng ta, ");
INSERT INTO vie1934_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","vì ta sẽ tôn ngươi rất vinh hiển, và làm theo mọi điều ngươi sẽ nói cùng ta. Ta xin ngươi hãy đến rủa sả dân nầy. ");
INSERT INTO vie1934_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ba-la-am đáp cùng các sứ thần của Ba-lác rằng: Dầu Ba-lác sẽ cho ta nhà người đầy vàng và bạc, ta cũng chẳng được vượt qua mạng của Giê-hô-va, Đức Chúa Trời của ta, đặng làm một việc hoặc nhỏ hay lớn. ");
INSERT INTO vie1934_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Song ta xin các ngươi cũng ở lại đêm nay, đặng ta biết Đức Giê-hô-va sẽ phán điều chi cùng ta nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Trong lúc ban đêm, Đức Chúa Trời giáng đến Ba-la-am mà phán rằng: Nếu các người ấy đến đặng gọi ngươi, hãy đứng dậy đi với chúng nó; nhưng chỉ hãy làm theo lời ta sẽ phán. ");
INSERT INTO vie1934_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Vậy, sớm mai, Ba-la-am dậy, thắng lừa cái mình và đi với các sứ thần Mô-áp. ");
INSERT INTO vie1934_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nhưng cơn thạnh nộ của Đức Chúa Trời nổi phừng lên, vì người ra đi; thiên sứ của Đức Giê-hô-va đứng trên đường đặng cản người. Vả, người đã cỡi lừa cái mình, và có hai đứa đầy tớ đi theo. ");
INSERT INTO vie1934_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Lừa cái thấy thiên sứ của Đức Giê-hô-va đứng trên đường có cây gươm trần nơi tay, bèn tẻ đường đi vào trong ruộng; Ba-la-am đánh nó đặng dẫn nó vào đường lại. ");
INSERT INTO vie1934_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nhưng thiên sứ của Đức Giê-hô-va đứng trong đường nhỏ của vườn nho có vách bên nầy và bên kia. ");
INSERT INTO vie1934_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Lừa thấy thiên sứ của Đức Giê-hô-va thì nép vào vách và ép chân Ba-la-am; người đánh nó. ");
INSERT INTO vie1934_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Thiên sứ của Đức Giê-hô-va đi tới xa hơn, đứng trong một ngả rất hẹp không chỗ nào trở qua bên hữu hay là bên tả; ");
INSERT INTO vie1934_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","lừa thấy thiên sứ của Đức Giê-hô-va bèn nằm quị dưới Ba-la-am. Nhưng Ba-la-am nổi giận, đánh lừa bằng một cây gậy. ");
INSERT INTO vie1934_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Bấy giờ, Đức Giê-hô-va mở miệng lừa ra, nó nói cùng Ba-la-am rằng: Tôi có làm chi cho người, mà người đã đánh tôi ba lần? ");
INSERT INTO vie1934_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ba-la-am đáp cùng lừa cái rằng: Aáy là tại mầy khinh nhạo ta. Chớ chi ta có cây gươm trong tay, ta đã giết mầy rồi! ");
INSERT INTO vie1934_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Lừa nói cùng Ba-la-am rằng: Tôi há chẳng phải là lừa của người mà người đã cỡi luôn đến ngày nay sao? Tôi há có thói làm như vậy cùng người chăng? Người đáp: Không. ");
INSERT INTO vie1934_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Đức Giê-hô-va bèn mở mắt Ba-la-am ra, thấy thiên sứ của Đức Giê-hô-va đứng trong đường, tay cầm một cây gươm. Người cúi đầu và sấp mặt xuống đất. ");
INSERT INTO vie1934_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Thiên sứ của Đức Giê-hô-va nói: Sao ngươi đã đánh lừa cái ngươi ba lần? Nầy, ta đi ra đặng cản ngươi, vì ta thấy ngươi đi theo một con đường dẫn mình đến nơi hư nát. ");
INSERT INTO vie1934_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Vả, con lừa cái có thấy ta, đi tẻ trước mặt ta ba lần, nếu nó không đi tẻ trước mặt ta, chắc ta đã giết ngươi rồi và để nó sống. ");
INSERT INTO vie1934_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ba-la-am bèn thưa cùng thiên sứ của Đức Giê-hô-va rằng: Tôi có phạm tội, vì chẳng biết người đã đứng trong đường đặng cản tôi, bây giờ, nếu người không bằng lòng tôi đi, tôi sẽ trở về. ");
INSERT INTO vie1934_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Thiên sứ của Đức Giê-hô-va nói cùng Ba-la-am rằng: Hãy đi cùng các người đó, nhưng chỉ hãy nói điều chi ta sẽ phán dặn ngươi. Ba-la-am bèn đi cùng các sứ thần của Ba-lác. ");
INSERT INTO vie1934_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Khi Ba-lác hay rằng Ba-la-am đến, bèn đi ra tới thành Mô-áp ở gần khe Aït-nôn, tức là ở tận bờ cõi của xứ, mà nghinh tiếp người. ");
INSERT INTO vie1934_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ba-lác nói cùng Ba-la-am rằng: Ta há chẳng sai sứ vời ngươi sao? Sao ngươi không đến ta? Ta há không tôn vinh hiển cho ngươi được sao? ");
INSERT INTO vie1934_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ba-la-am đáp cùng Ba-lác rằng: Nầy tôi đã đến cùng vua, bây giờ tôi há có thể nói ra lời gì chăng? Tôi sẽ nói điều chi Đức Chúa Trời đặt trong miệng tôi vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ba-la-am đi cùng Ba-lác, đến Ki-ri-át-Hút-sốt. ");
INSERT INTO vie1934_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ba-lác giết những bò và chiên, sai dâng cho Ba-la-am và các sứ thần đã đi với người. ");
INSERT INTO vie1934_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Khi đến sáng mai, Ba-lác đem Ba-la-am lên Ba-mốt-Ba-anh, là nơi người thấy đầu cùng trại quân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ba-la-am nói cùng Ba-lác rằng: Hãy cất tại đây cho tôi bảy cái bàn thờ, cùng sắm sẵn cho tôi bảy con bò đực và bảy con chiên đực. ");
INSERT INTO vie1934_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ba-lác làm như Ba-la-am đã nói; hai người dâng một con bò đực và một con chiên đực trên mỗi bàn thờ. ");
INSERT INTO vie1934_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Đoạn, Ba-la-am nói cùng Ba-lác rằng: Vua hãy đứng gần của lễ thiêu của vua, tôi sẽ đi; có lẽ Đức Giê-hô-va sẽ hiện ra cùng tôi chăng, tôi sẽ thuật lại cùng vua điều chi Ngài cho tôi thấy. Người đi lên một nơi cao trống trải. ");
INSERT INTO vie1934_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Đức Chúa Trời hiện ra cùng Ba-la-am, và Ba-la-am thưa cùng Ngài rằng: Tôi có lập bảy cái bàn thờ, và trên mỗi bàn thờ tôi có dâng một con bò đực và một con chiên đực. ");
INSERT INTO vie1934_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Đức Giê-hô-va để lời trong miệng Ba-la-am và phán rằng: Hãy trở về cùng Ba-lác và nói như vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ba-la-am bèn trở về cùng Ba-lác; nầy, người và các sứ thần Mô-áp đứng gần của lễ thiêu vua. ");
INSERT INTO vie1934_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ba-la-am bèn nói lời ca mình mà rằng: Ba-lác, vua Mô-áp, sai vời tôi từ A-ram, Từ những núi Đông-phương, và nói: Hãy đến rủa sả Gia-cốp cho ta! Hãy đến, giận mắng Y-sơ-ra-ên! ");
INSERT INTO vie1934_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Kẻ mà Đức Chúa Trời không rủa sả, tôi sẽ rủa sả làm sao? Kẻ mà Đức Chúa Trời không giận mắng, tôi sẽ giận mắng làm sao? ");
INSERT INTO vie1934_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Vì từ đỉnh các núi, tôi thấy người, Từ đầu cao gò đống, tôi nhìn người: Kìa, là một dân ở riêng ra, Sẽ không nhập số các nước. ");
INSERT INTO vie1934_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ai đếm được bụi cát của Gia-cốp, Ai tu bộ được phần tư của Y-sơ-ra-ên? Người công chánh thác thể nào, tôi nguyện thác thể ấy; Cuối cùng người nghĩa làm sao, tôi nguyện cuối cùng tôi làm vậy! ");
INSERT INTO vie1934_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Bấy giờ, Ba-lác nói cùng Ba-la-am rằng: Ngươi đã làm chi với ta? Ta thỉnh ngươi để rủa sả những thù nghịch ta, kìa ngươi lại chúc phước cho! ");
INSERT INTO vie1934_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Người đáp rằng: Tôi há không nên cẩn thận nói điều Đức Giê-hô-va đặt vào miệng tôi sao? ");
INSERT INTO vie1934_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ba-lác bèn nói: Vậy, hãy đến cùng ta trong một chỗ khác, là nơi ngươi sẽ thấy dân nầy, vì ngươi chỉ đã thấy ở đầu cùng nó, chớ không thấy hết; ở đó hãy rủa sả nó cho ta. ");
INSERT INTO vie1934_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Vậy, người dẫn Ba-la-am đến đồng Xô-phim, trên chót núi Phích-ga, lập bảy cái bàn thờ, và trên mỗi cái dâng một con bò đực và một con chiên đực. ");
INSERT INTO vie1934_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ba-la-am bèn nói cùng Ba-lác rằng: Hãy đứng đây gần của lễ thiêu của vua, còn tôi sẽ đi lại đó, đón Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Đức Giê-hô-va hiện ra cùng Ba-la-am, để những lời trong miệng người, mà rằng: Hãy trở về cùng Ba-lác và nói như vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ba-la-am trở về cùng Ba-lác; người và các sứ thần Mô-áp đứng gần của lễ thiêu của vua. Ba-lác hỏi: Đức Giê-hô-va có phán chi? ");
INSERT INTO vie1934_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ba-la-am bèn nói lời ca mình mà rằng: Hỡi Ba-lác, hãy đứng dậy và nghe! Hỡi con trai Xếp-bô, hãy lắng tai! ");
INSERT INTO vie1934_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Đức Chúa Trời chẳng phải là người để nói dối, Cũng chẳng phải là con loài người đặng hối cải. Điều Ngài đã nói, Ngài há sẽ chẳng làm ư? Điều Ngài đã phán, Ngài há sẽ chẳng làm ứng nghiệm sao? ");
INSERT INTO vie1934_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nầy, tôi đã lãnh mạng chúc phước; Ngài đã ban phước, tôi chẳng cải đâu. ");
INSERT INTO vie1934_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ngài chẳng xem tội ác nơi Gia-cốp, Và không thấy tà vạy trong Y-sơ-ra-ên; Giê-hô-va, Đức Chúa Trời người, ở cùng người, Trong Y-sơ-ra-ên có tiếng reo mừng của vua. ");
INSERT INTO vie1934_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Aáy là Đức Chúa Trời đã rút dân đó ra khỏi xứ Ê-díp-tô; Chúng có sức mạnh như bò rừng vậy ");
INSERT INTO vie1934_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Không có phù chú nơi Gia-cốp, Cũng chẳng có bói-khoa trong Y-sơ-ra-ên, Vì đến k” định, sẽ nói về Gia-cốp và Y-sơ-ra-ên rằng: Việc Đức Chúa Trời làm lạ là dường nào! ");
INSERT INTO vie1934_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Kìa, một thứ dân hưng lên như sư tử cái, Và vùng lên khác nào sư tử đực; Chỉ khi nào đã xé được mồi mới nằm xuống, Và uống huyết những kẻ bị thương. ");
INSERT INTO vie1934_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Bấy giờ, Ba-lác nói cùng Ba-la-am rằng: Chớ rủa sả họ, nhưng cũng đừng chúc phước cho nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ba-la-am đáp cùng Ba-lác rằng: Tôi há chẳng có nói: Tôi phải làm mọi điều Đức Giê-hô-va sẽ phán dặn sao? ");
INSERT INTO vie1934_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ba-lác lại nói cùng Ba-la-am rằng: Vậy, hãy lại, ta dẫn ngươi đến một chỗ khác; có lẽ Đức Chúa Trời sẽ ưng cho ngươi rủa sả dân nầy tại đó chăng. ");
INSERT INTO vie1934_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ba-lác bèn dẫn Ba-la-am đến chót núi Phê-ô, đối ngang đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ba-la-am nói cùng Ba-lác rằng: Tại đây, hãy lập cho tôi bảy cái bàn thờ, và sắm sẵn bảy con bò đực và bảy con chiên đực. ");
INSERT INTO vie1934_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Vậy, Ba-lác làm theo như Ba-la-am đã nói; trên mỗi bàn thờ, người dâng một con bò đực và một con chiên đực. ");
INSERT INTO vie1934_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ba-la-am thấy rõ Đức Giê-hô-va ưng ban phước cho Y-sơ-ra-ên, thì không cậy đến phù chú như những lần khác; nhưng người xây mặt về hướng đồng vắng, ");
INSERT INTO vie1934_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","nhướng mắt lên thấy Y-sơ-ra-ên đóng trại từng chi phái, và Thần Đức Chúa Trời cảm động người, ");
INSERT INTO vie1934_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","bèn nói lời ca mình mà rằng: Lời ca của Ba-la-am, con trai Bê-ô, Lời ca của người có mắt mở ra, ");
INSERT INTO vie1934_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Lời ca của người nghe lời Đức Chúa Trời, Xem sự hiện thấy của Đấng Toàn năng, Sấp mình xuống và mắt mở ra: ");
INSERT INTO vie1934_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Hỡi Gia-cốp! trại ngươi tốt dường bao! Hỡi Y-sơ-ra-ên! nhà tạm ngươi đẹp biết mấy! ");
INSERT INTO vie1934_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Nó trương ra như trũng núi, Khác nào cánh vườn ở nơi mé sông, Tợ cây trầm hương mà Đức Giê-hô-va đã trồng, Tỉ như cây hương nam ở nơi mé nước. ");
INSERT INTO vie1934_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Nước chảy tràn ngoài thùng chứa, Hột giống của người nhuần tưới dư dật, Vua người sẽ trổi cao hơn A-gát, Nước người được cao lên. ");
INSERT INTO vie1934_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Đức Chúa Trời đã dẫn người ra khỏi xứ Ê-díp-tô, Người có sức mạnh như bò rừng, Sẽ nuốt các nước, tức kẻ thù nghịch mình, Bẻ gãy xương chúng nó, đánh chúng nó bằng mũi tên mình. ");
INSERT INTO vie1934_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Người sụm xuống, nằm như sư tử đực, khác nào sư tử cái: Ai dễ khiến ngồi lên? Phước cho kẻ nào chúc phước ngươi, Rủa sả kẻ nào rủa sả ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Bấy giờ, Ba-lác nổi giận cùng Ba-la-am, vỗ tay mà nói cùng Ba-la-am rằng: Ta đã thỉnh ngươi đặng rủa sả kẻ thù nghịch ta; nầy, ngươi lại chúc phước cho chúng nó đã ba lần rồi! ");
INSERT INTO vie1934_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Vậy, bây giờ, khá chạy trở về xứ ngươi! Ta đã nói ta sẽ tôn ngươi vinh hiển, nhưng nầy, Đức Giê-hô-va đã cản ngươi nhận lãnh. ");
INSERT INTO vie1934_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ba-la-am đáp cùng Ba-lác rằng: Tôi há chẳng có nói cùng các sứ giả vua đã sai đến tôi rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Dầu Ba-lác cho tôi nhà người đầy bạc và vàng, tôi cũng chẳng được vượt qua mạng Đức Giê-hô-va để làm tự ý điều phải hay là điều quấy; tôi phải nói điều chi Đức Giê-hô-va sẽ phán! ");
INSERT INTO vie1934_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Nầy, bây giờ, tôi trở cùng dân tôi, hãy lại, tôi sẽ cáo cho vua biết điều dân nầy ngày sau cùng sẽ làm cho dân sự vua. ");
INSERT INTO vie1934_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Người bèn nói lời ca mình mà rằng: Lời ca của Ba-la-am, con trai Bê-ô, Lời ca của người có mắt mở ra; ");
INSERT INTO vie1934_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Lời ca của người nghe lời Đức Chúa Trời, Biết sự tri thức của Đấng Chí cao, Xem sự hiện thấy của Đấng Toàn năng, Sấp mình xuống mà mắt tự mở ra: ");
INSERT INTO vie1934_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Tôi thấy Người, nhưng chẳng phải bây giờ; Tôi xem Người, nhưng chẳng phải ở gần; Một ngôi sao hiện ra từ Gia-cốp, Một cây phủ việt trồi lên từ Y-sơ-ra-ên; Người sẽ đâm lủng Mô-áp từ đầu nầy tới đầu kia, Hủy diệt dân hay dấy giặc nầy. ");
INSERT INTO vie1934_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Người sẽ được Ê-đôm làm cơ nghiệp; Sẽ được Sê-i-rơ, là kẻ thù nghịch mình, làm sản nghiệp. Y-sơ-ra-ên sẽ tỏ ra sự cường thạnh mình. ");
INSERT INTO vie1934_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Đấng ra từ Gia-cốp sẽ cầm quyền, Người sẽ diệt những dân sót của thành. ");
INSERT INTO vie1934_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ba-la-am cũng thấy A-ma-léc, bèn nói lời ca mình rằng: A-ma-léc đứng đầu các nước; Nhưng sau cùng người sẽ bị diệt vong. ");
INSERT INTO vie1934_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kế đó, Ba-la-am thấy người Kê-nít, bèn nói lời ca mình rằng: Chỗ ở ngươi là bền vững, ì ngươi đóng trong hòn đá. ");
INSERT INTO vie1934_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nhưng Ca-in sẽ bị hư nát, Cho đến khi A-su-rơ bắt dẫn tù ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Người còn nói lời ca mình rằng: Oâi! khi Đức Chúa Trời đã làm các điều nầy, ai sẽ còn sống? ");
INSERT INTO vie1934_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Nhưng sẽ có những tàu từ gành Kít-tim đến, Hà khắc A-su, hà khắc Hê-be. Rồi chính người cũng sẽ bị tuyệt diệt. ");
INSERT INTO vie1934_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Đoạn, Ba-la-am đứng dậy đi về bổn xứ. Ba-lác cũng lên đường. ");
INSERT INTO vie1934_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Dân Y-sơ-ra-ên ở tại Si-tim, khởi thông dâm cùng những con gái Mô-áp. ");
INSERT INTO vie1934_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Con gái mời dân sự ăn sinh lễ cúng các thần mình; dân sự ăn và quì lạy trước các thần chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Y-sơ-ra-ên cũng thờ thần Ba-anh-Phê-ô, cơn giận của Đức Giê-hô-va bèn nổi lên cùng Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy bắt các đầu trưởng của dân sự, và treo lên trước mặt Đức Giê-hô-va, đối cùng mặt trời, để cơn giận của Đức Giê-hô-va xây khỏi Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Vậy, Môi-se nói cùng các quan án Y-sơ-ra-ên rằng: Mỗi người trong các ngươi phải giết những kẻ nào thuộc về bọn cúng thờ Ba-anh-Phê-ô. ");
INSERT INTO vie1934_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Nầy, một người trong dân Y-sơ-ra-ên dẫn một người nữ Ma-đi-an đến giữa anh em mình, hiện trước mắt Môi-se và cả hội dân Y-sơ-ra-ên, đang khi hội chúng khóc tại cửa hội mạc. ");
INSERT INTO vie1934_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Phi-nê-a, con trai Ê-lê-a-sa, cháu A-rôn, thầy tế lễ, thấy sự nầy, bèn đứng dậy giữa hội chúng, cầm một cây giáo, ");
INSERT INTO vie1934_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","đi theo người Y-sơ-ra-ên vào trong trại, đâm ngang dạ dưới của người Y-sơ-ra-ên và người nữ; tai vạ giữa dân Y-sơ-ra-ên bèn ngừng lại. ");
INSERT INTO vie1934_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Vả, có hai mươi bốn ngàn người chết về tai vạ nầy. ");
INSERT INTO vie1934_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Phi-nê-a, con trai Ê-lê-a-sa, cháu A-rôn, thầy tế lễ, đã xây dân Y-sơ-ra-ên khỏi cơn giận ta, vì lòng kỵ tà thúc giục lòng người; vậy, ta không có diệt dân Y-sơ-ra-ên trong cơn kỵ tà của ta. ");
INSERT INTO vie1934_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Bởi cớ đó, hãy cáo cùng người rằng: Ta ưng cho người sự giao ước bình yên ta; ");
INSERT INTO vie1934_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ấy về phần người và dòng dõi người sẽ là sự giao ước về một chức tế lễ đời đời, bởi vì người có lòng sốt sắng về Đức Chúa Trời mình, và có chuộc tội cho dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Vả, người Y-sơ-ra-ên bị giết chung với người nữ Ma-đi-an, tên là Xim-ri, con trai Sa-lu, quan trưởng của một tông tộc, người Si-mê-ôn. ");
INSERT INTO vie1934_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Tên người nữ Ma-đi-an bị giết là Cốt-bi, con gái Xu-rơ, đầu trưởng của một tông tộc Ma-đi-an. ");
INSERT INTO vie1934_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Hãy khuấy rối người Ma-đi-an và hãm đánh chúng nó; ");
INSERT INTO vie1934_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","vì chúng nó đã lấy mưu chước mình mà khuấy rối các ngươi, dỗ dành các ngươi về việc cúng thờ Phê-ô, và trong việc của Cốt-bi, con gái quan trưởng Ma-đi-an, là chị chúng nó đã bị giết trong ngày tai vạ, vì cớ việc cúng thờ Phê-ô. ");
INSERT INTO vie1934_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Xảy sau tai vạ nầy, Đức Giê-hô-va phán cùng Môi-se và Ê-lê-a-sa, con trai A-rôn, thầy tế lễ, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Hãy dựng sổ cả hội chúng Y-sơ-ra-ên, từ hai mươi tuổi sắp lên, tùy theo tông tộc của họ, tức là hết thảy người trong Y-sơ-ra-ên đi ra trận được. ");
INSERT INTO vie1934_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Vậy, Môi-se và Ê-lê-a-sa, thầy tế lễ, nói cùng dân Y-sơ-ra-ên trong đồng Mô-áp gần sông Giô-đanh, đối ngang Giê-ri-cô, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Hãy tu bộ dân sự từ hai mươi tuổi sắp lên, như Đức Giê-hô-va đã phán dặn Môi-se và dân Y-sơ-ra-ên, mà đã ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ru-bên, con trưởng nam của Y-sơ-ra-ên. Con trai Ru-bên là Hê-nóc; do nơi người sanh ra họ Hê-nóc; do nơi Pha-lu sanh họ Pha-lu; ");
INSERT INTO vie1934_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","do nơi Hết-rôn sanh họ Hết-rôn; do nơi Cạt-mi sanh ra họ Cạt-mi. ");
INSERT INTO vie1934_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Đó là các họ của Ru-bên, và những tên người mà người ta tu bộ, cộng được bốn mươi ba ngàn bảy trăm ba mươi. ");
INSERT INTO vie1934_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Con trai Pha-lu là Ê-li-áp. ");
INSERT INTO vie1934_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Các con trai của Ê-li-áp là Nê-mu-ên, Đa-than và A-bi-ram. Aáy là Đa-than và A-bi-ram nầy, trưởng của hội chúng dấy loạn cùng Môi-se và A-rôn, tại phe đảng Cô-rê, khi họ dấy loạn cùng Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Aáy, khi đất hả miệng ra nuốt hai người và Cô-rê cùng những kẻ đã hiệp đảng chết luôn, lúc lửa thiêu nuốt hai trăm rưởi người; họ làm gương như vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Nhưng các con trai Cô-rê không chết. ");
INSERT INTO vie1934_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Các con trai Si-mê-ôn, tùy theo họ hàng mình: do nơi Nê-mu-ên sanh ra họ Nê-mu-ên; do nơi Gia-min sanh ra họ Gia-min; do nơi Gia-kin sanh ra họ Gia-kin; ");
INSERT INTO vie1934_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","do nơi Xê-rách sanh ra họ Xê-rách; do nơi Sau-lơ sanh ra họ Sau-lơ. ");
INSERT INTO vie1934_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Đó là các họ của Si-mê-ôn: số là hai mươi hai ngàn hai trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Các con trai của Gát, tùy theo họ hàng mình: do nơi Xê-phôn sanh ra họ Xê-phôn; do nơi Ha-ghi sanh ra họ Ha-ghi; do nơi Su-ni sanh ra họ Su-ni; ");
INSERT INTO vie1934_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","do nơi Oùc-ni sanh ra họ Oùc-ni; do nơi Ê-ri sanh ra họ Ê-ri; ");
INSERT INTO vie1934_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","do nơi A-rốt sanh ra họ A-rốt; do nơi A-rê-li sanh ra họ A-rê-li. ");
INSERT INTO vie1934_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Đó là các họ của những con trai Gát, tùy theo tu bộ: số là bốn mươi ngàn năm trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Các con trai Giu-đa: Ê-rơ và Ô-nan; nhưng Ê-rơ và Ô-nan đã qua đời tại xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Các con trai Giu-đa, tùy theo họ hàng mình: do nơi Sê-la sanh ra họ Sê-la; do nơi Phê-rết sanh ra họ Phê-rết; do nơi Xê-rách sanh ra họ Xê-rách. ");
INSERT INTO vie1934_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Các con trai của Pha-rết: do nơi Hết-rôn sanh ra họ Hết-rôn; do nơi Ha-mun sanh ra họ Ha-mun. ");
INSERT INTO vie1934_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Đó là các họ của Giu-đa, tùy theo tu bộ: số là bảy mươi sáu ngàn năm trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Các con trai Y-sa-ca, tùy theo họ hàng mình: do nơi Thô-la sanh ra họ Thô-la; do nơi Phu-va sanh ra họ Phu-va; ");
INSERT INTO vie1934_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","do nơi Gia-súp sanh ra họ Gia-súp; do nơi Sim-rôn sanh ra họ Sim-rôn. ");
INSERT INTO vie1934_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Đó là các họ Y-sa-ca, tùy theo tu bộ: số là sáu mươi bốn ngàn ba trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Các con trai Sa-bu-lôn, tùy theo họ hàng mình: do nơi Sê-rết sanh ra họ Sê-rết; do nơi Ê-lôn sanh ra họ Ê-lôn; do nơi Gia-lê-ên sanh ra họ Gia-lê-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Đó là các họ của Sa-bu-lôn tùy theo tu bộ: số là sáu mươi ngàn năm trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Các con trai Giô-sép, tùy theo họ hàng mình, là Ma-na-se và Eùp-ra-im. ");
INSERT INTO vie1934_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Các con trai Ma-na-se: do nơi Ma-ki sanh ra họ Ma-ki, Ma-ki sanh Ga-la-át: do nơi Ga-la-át sanh ra họ Ga-la-át. ");
INSERT INTO vie1934_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Nầy là các con trai Ga-la-át: do nơi Giê-xe sanh ra họ Giê-xe; do nơi Hê-léc sanh ra họ Hê-léc; ");
INSERT INTO vie1934_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","do nơi Aùch-ri-ên sanh ra họ Aùch-ri-ên; do nơi Si-chem sanh ra họ Si-chem; ");
INSERT INTO vie1934_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","do nơi Sê-mi-đa sanh ra họ Sê-mi-đa; do nơi Hê-phe sanh ra họ Hê-phe. ");
INSERT INTO vie1934_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Vả, Xê-lô-phát, con trai Hê-phe, không có con trai, nhưng có con gái. Tên các con gái Xê-lô-phát là Mách-la, Nô-a, Hốt-la, Minh-ca và Thiệt-sa. ");
INSERT INTO vie1934_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Đó là các họ Ma-na-se, tùy theo tu bộ: số là năm mươi hai ngàn bảy trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Nầy là các con trai Eùp-ra-im, tùy theo họ hàng mình: do nơi Su-thê-lách sanh ra họ Su-thê-lách; do nơi Bê-ke sanh ra họ Bê-ke; do nơi Tha-chan sanh ra họ Tha-chan. ");
INSERT INTO vie1934_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Nầy là con trai của Su-thê-lách: do nơi Ê-ran sanh ra họ Ê-ran. ");
INSERT INTO vie1934_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Đó là họ của các con trai Eùp-ra-im, tùy theo tu bộ: số là ba mươi hai ngàn năm trăm người. Aáy là các con trai Giô-sép, tùy theo họ hàng mình vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Các con trai Bên gia-min, tùy theo họ hàng mình: do nơi Bê-la sanh ra họ Bê-la; do nơi Aùch-bên sanh ra họ Aùch-bên, do nơi A-chi-ram sanh ra họ A-chi-ram; ");
INSERT INTO vie1934_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","do nơi Sê-phu-pham sanh ra họ Sê-phu-pham; do nơi Hu-pham sanh ra họ Hu-pham. ");
INSERT INTO vie1934_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Các con trai Bê-la là A-rết và Na-a-man; do nơi A-rết sanh ra họ A-rết; do nơi Na-a-man sanh ra họ Na-a-man. ");
INSERT INTO vie1934_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Đó là các con trai Bên-gia-min, tùy theo họ hàng và tùy theo tu bộ: số là bốn mươi lăm ngàn sáu trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Nầy là các con trai của Đan, tùy theo họ hàng mình: do nơi Su-cham sanh ra họ Su-cham. Đó là họ của Đan; ");
INSERT INTO vie1934_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","họ Su-cham, tùy theo tu bộ: số là sáu mươi bốn ngàn bốn trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Các con trai A-se, tùy theo họ hàng mình: do nơi Di-ma sanh ra họ Di-ma; do nơi Dích-vi sanh ra họ Dích-vi; do nơi Bê-ri-a sanh ra họ Bê-ri-a. ");
INSERT INTO vie1934_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Các con trai Bê-ri-a: do nơi Hê-be sanh ra họ Hê-be; do nơi Manh-ki-ên sanh ra họ Manh-ki-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Tên của con gái A-se là Sê-rách. ");
INSERT INTO vie1934_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Đó là những họ của các con trai A-se, tùy theo tu bộ: số là năm mươi ba ngàn bốn trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Các con trai Nép-ta-li, tùy theo họ hàng mình: do nơi Giát-sê-ên sanh ra họ Giát-sê-ên; do nơi Gu-ni sanh ra họ Gu-ni; ");
INSERT INTO vie1934_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","do nơi Dít-se sanh ra họ Dít-se: do nơi Si-lem sanh ra họ Si-lem. ");
INSERT INTO vie1934_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Đó là các họ của Nép-ta-li, tùy theo họ hàng và tu bộ mình: số là bốn mươi lăm ngàn bốn trăm người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Đó là những người trong dân Y-sơ-ra-ên mà người ta tu bộ lại: số là sáu trăm một ngàn bảy trăm ba mươi người. ");
INSERT INTO vie1934_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Phải tùy theo số các danh mà chia xứ ra cho những người nầy làm sản nghiệp; ");
INSERT INTO vie1934_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","chi phái nào số dân đông thì ngươi phải cho một sản nghiệp lớn hơn, chi phái nào số dân ít, thì phải cho một sản nghiệp nhỏ hơn, tức là phải cho mỗi chi phái sản nghiệp mình cân phân cùng số tu bộ. ");
INSERT INTO vie1934_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Nhưng phải bắt thăm mà chia xứ ra; dân Y-sơ-ra-ên sẽ lãnh phần sản nghiệp mình theo tên của các chi phái tổ tông. ");
INSERT INTO vie1934_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Phải tùy sự bắt thăm mà chia sản nghiệp ra cho mỗi chi phái, hoặc số dân đông hay ít. ");
INSERT INTO vie1934_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Nầy là người Lê-vi mà người ta tu bộ lại, tùy theo họ hàng mình: do nơi Ghẹt-sôn sanh ra họ Ghẹt-sôn; do nơi Kê-hát sanh ra họ Kê-hát; do nơi Mê-ra-ri sanh ra họ Mê-ra-ri. ");
INSERT INTO vie1934_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Nầy là các họ Lê-vi: họ Líp-ni, họ Hếp-rôn, họ Mách-li, họ Mu-si, họ Cô-rê. Vả, Kê-hát sanh Am-ram. ");
INSERT INTO vie1934_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Tên vợ Am-ram là Giô-kê-bết, con gái của Lê-vi, sanh trong xứ Ê-díp-tô; nàng sanh cho Am-ram, A-rôn, Môi-se và chị của hai người là Mi-ri-am. ");
INSERT INTO vie1934_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Còn A-rôn sanh Na-đáp và A-bi-hu, Ê-lê-a-sa và Y-tha-ma. ");
INSERT INTO vie1934_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nhưng Na-đáp và A-bi-hu chết trong khi dâng một thứ lửa lạ trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Những nam đinh mà người ta tu bộ từ một tháng sắp lên, cộng được hai mươi ba ngàn; vì người Lê-vi không được kể vào số tu bộ của dân Y-sơ-ra-ên, bởi người Lê-vi không được phần sản nghiệp giữa dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Đó là sự tu bộ mà Môi-se và Ê-lê-a-sa, thầy tế lễ, làm về dân Y-sơ-ra-ên trong đồng bằng Mô-áp gần Giô-đanh, đối ngang Giê-ri-cô. ");
INSERT INTO vie1934_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Trong các người nầy không có một ai thuộc về bọn mà Môi-se và A-rôn, thầy tế lễ, đã kiểm soát khi hai người tu bộ dân Y-sơ-ra-ên tại đồng vắng Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Vì Đức Giê-hô-va có phán về bọn đó rằng: Chúng nó hẳn sẽ chết trong đồng vắng! Vậy, chẳng còn lại một tên, trừ ra Ca-lép, con trai Giê-phu-nê, và Giô-suê, con trai Nun. ");
INSERT INTO vie1934_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Các con gái của Xê-lô-phát, là con trai Hê-phe, cháu của Ga-la-át, chắt của Ma-ki, chít của Ma-na-se, thuộc về họ hàng Ma-na-se, là con trai của Giô-sép, đến gần; đây là tên của con gái người: Mách-la, Nô-a, Hốt-la, Minh-ca và Thiệt-sa. ");
INSERT INTO vie1934_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Các con gái đó đến ra mắt Môi-se, Ê-lê-a-sa thầy tế lễ, các quan trưởng, và cả hội chúng tại cửa hội mạc, mà nói rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Cha chúng tôi đã chết trong đồng vắng; người chẳng phải về phe đảng của kẻ hiệp lại nghịch cùng Đức Giê-hô-va tức là phe đảng Cô-rê; nhưng người chết vì tội lỗi mình, và không có con trai. ");
INSERT INTO vie1934_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Cớ sao danh cha chúng tôi bị trừ ra khỏi giữa họ người, bởi không có con trai? Hãy cho chúng tôi một phần sản nghiệp giữa anh em của cha chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Môi-se bèn đem cớ sự của các con gái ấy đến trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Các con gái Xê-lô-phát nói có lý; ngươi phải cho chúng nó một phần sản nghiệp giữa anh em của cha chúng nó, tức là phải giao cho chúng nó sản nghiệp của cha chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ngươi cũng phải nói cùng dân Y-sơ-ra-ên rằng: Khi một người nào chết không có con trai, thì các ngươi phải giao sản nghiệp của người lại cho con gái người. ");
INSERT INTO vie1934_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Nhược bằng không có con gái, thì phải giao sản nghiệp cho anh em người. ");
INSERT INTO vie1934_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ví bằng người không có anh em, thì phải giao sản nghiệp cho chú bác người. ");
INSERT INTO vie1934_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Nếu không có chú bác, thì phải giao sản nghiệp người cho người bà con gần hơn hết; và người ấy sẽ được lấy làm của. Aáy sẽ là một luật lệ để định cho dân Y-sơ-ra-ên, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: Hãy lên trên núi A-ba-rim nầy và nhìn xem xứ mà ta đã ban cho dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ngươi sẽ nhìn xem xứ đó, rồi ngươi cũng sẽ được về cùng tổ phụ, như A-rôn, anh ngươi, đã được về vậy; ");
INSERT INTO vie1934_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","bởi vì, tại đồng vắng Xin, các ngươi có bội nghịch mạng lịnh ta, trong lúc hội chúng cãi cọ, và vì trước mặt chúng nó, các ngươi không tôn ta nên thánh về việc nước. Aáy là nước về sự cãi cọ tại Ca-đe, trong đồng vắng Xin. ");
INSERT INTO vie1934_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Môi-se thưa cùng Đức Giê-hô-va rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Lạy Giê-hô-va là Đức Chúa Trời của thần linh mọi xác thịt, xin Ngài lập trên hội chúng một người ");
INSERT INTO vie1934_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","để vào ra trước mặt chúng nó khiến chúng nó ra vào, hầu cho hội chúng của Đức Giê-hô-va chớ như con chiên không người chăn. ");
INSERT INTO vie1934_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Đức Giê-hô-va phán cùng Môi-se rằng: Hãy chọn lấy Giô-suê con trai của Nun, người có Thần cảm động; phải đặt tay trên mình người; ");
INSERT INTO vie1934_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","rồi đem người ra mắt Ê-lê-a-sa, thầy tế lễ, và cả hội chúng, truyền lịnh cho người trước mặt họ, ");
INSERT INTO vie1934_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","và trao phần vinh hiển ngươi lại cho người, hầu cho cả hội chúng Y-sơ-ra-ên nghe người. ");
INSERT INTO vie1934_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Người phải ra mắt Ê-lê-a-sa, thầy tế lễ, rồi người sẽ vì Giô-suê cầu hỏi sự xét đoán của u-rim trước mặt Đức Giê-hô-va; theo lịnh Ê-lê-a-sa, người và cả hội chúng Y-sơ-ra-ên sẽ đi ra và đi vào. ");
INSERT INTO vie1934_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Vậy, Môi-se làm y như Đức Giê-hô-va đã phán dặn mình, chọn lấy Giô-suê để trước mặt Ê-lê-a-sa, thầy tế lễ, và trước mặt cả hội chúng, ");
INSERT INTO vie1934_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","đặt tay trên mình người, và truyền lịnh cho, y như Đức Giê-hô-va đã cậy Môi-se phán dặn vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Hãy truyền lịnh nầy cho dân Y-sơ-ra-ên mà rằng: Các ngươi phải lo dâng cho ta trong k” định lễ vật và thực vật của ta, cùng các của lễ dùng lửa dâng lên có mùi thơm cho ta. ");
INSERT INTO vie1934_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Vậy, ngươi phải nói cùng dân Y-sơ-ra-ên rằng: Nầy là của lễ dùng lửa đốt mà các ngươi sẽ dâng cho Đức Giê-hô-va: Mỗi ngày, hai con chiên con đực giáp năm, không tì vít, làm của lễ thiêu hằng hiến. ");
INSERT INTO vie1934_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ngươi phải dâng con nầy vào buổi sớm mai và con kia vào buổi chiều tối; ");
INSERT INTO vie1934_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","còn về của lễ chay, thì phải dâng một phần mười ê-pha bột lọc nhồi với một phần tư hin dầu ô-li-ve ép. ");
INSERT INTO vie1934_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Aáy là của lễ thiêu hằng hiến đã lập tại núi Si-na-i. là một của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Lễ quán sẽ bằng một phần tư hin rượu cho mỗi một chiên con. Ngươi phải dâng lễ quán bằng rượu cho Đức Giê-hô-va trong nơi thánh. ");
INSERT INTO vie1934_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ngươi phải dâng chiên con kia vào buổi chiều tối, và làm một của lễ chay và một lễ quán như buổi sớm mai; ấy là một của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Ngày sa-bát, ngươi phải dâng hai chiên con đực giáp năm, không tì vít, và hai phần mười ê-pha bột lọc nhồi dầu làm của lễ chay với lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Aáy là của lễ thiêu về mỗi ngày sa-bát, ngoại trừ của lễ thiêu hằng hiến và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Mỗi đầu tháng, các ngươi phải dâng cho Đức Giê-hô-va hai con bò đực tơ, một con chiên đực, và bảy chiên con đực giáp năm, không tì vít, làm của lễ thiêu; ");
INSERT INTO vie1934_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ba phần mười ê-pha bột lọc nhồi dầu dùng làm của lễ chay về mỗi con bò đực; hai phần mười ê-pha bột lọc nhồi dầu dùng làm của lễ chay về con chiên đực; ");
INSERT INTO vie1934_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","một phần mười ê-pha bột lọc nhồi dầu dùng làm của lễ chay về mỗi con chiên con. Aáy là một của lễ thiêu có mùi thơm, tức một của lễ dùng lửa dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Lễ quán sẽ bằng phân nửa hin rượu nho về mỗi con bò đực, một phần ba hin về con chiên đực và một phần tư hin về mỗi con chiên con. Aáy là của lễ thiêu về các đầu tháng trong năm. ");
INSERT INTO vie1934_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ngoại trừ của lễ thiêu hằng hiến và lễ quán cặp theo, cũng phải dâng cho Đức Giê-hô-va một con dê đực làm của lễ chuộc tội. ");
INSERT INTO vie1934_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Ngày mười bốn tháng giêng, phải giữ lễ Vượt-qua cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Qua ngày mười lăm sẽ là ngày lễ; phải ăn bánh không men trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ngày thứ nhất các ngươi sẽ có sự hội hiệp thánh: chớ nên làm một công việc xác thịt nào. ");
INSERT INTO vie1934_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Các ngươi phải dâng cho Đức Giê-hô-va hai con bò đực tơ, và bảy chiên con đực giáp năm, đều không tì vít, làm của lễ thiêu. ");
INSERT INTO vie1934_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Của lễ chay sẽ bằng bột lọc nhồi dầu; các ngươi phải dâng ba phần mười ê-pha về một con bò đực, hai phần mười ê-pha về con chiên đực, ");
INSERT INTO vie1934_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","và một phần mười ê-pha về mỗi chiên con, ");
INSERT INTO vie1934_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","luôn một con dê đực làm của lễ chuộc tội, đặng làm lễ chuộc tội cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Các ngươi phải dâng các lễ vật nầy, ngoài của lễ thiêu buổi sớm mai, là một của lễ thiêu hằng hiến. ");
INSERT INTO vie1934_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Mỗi bữa trong bảy ngày, các ngươi phải dâng những lễ vật ngần ấy, như thực vật về của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va. Người ta phải dâng lễ vật đó ngoài của lễ thiêu hằng hiến và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ngày thứ bảy các ngươi sẽ có sự hội hiệp thánh, chớ nên làm một công việc xác thịt nào. ");
INSERT INTO vie1934_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Trong k” lễ của các tuần, nhằm ngày hoa quả đầu mùa, khi các ngươi dâng cho Đức Giê-hô-va của lễ chay mới, thì phải có sự hội hiệp thánh; chớ nên làm một công việc xác thịt nào. ");
INSERT INTO vie1934_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Các ngươi sẽ dùng hai con bò đực tơ, một con chiên đực, và bảy chiên con đực giáp năm, đặng làm của lễ thiêu có mùi thơm cho Đức Giê-hô-va; ");
INSERT INTO vie1934_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","của lễ chay sẽ bằng bột lọc nhồi dầu, ba phần mười ê-pha về mỗi con bò đực, hai phần mười ê-pha về con chiên đực, ");
INSERT INTO vie1934_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","một phần mười ê-pha về mỗi con chiên con; ");
INSERT INTO vie1934_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","cũng phải dâng một con dê đực, để làm lễ chuộc tội cho mình. ");
INSERT INTO vie1934_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ngoài của lễ thiêu hằng hiến và của lễ chay cặp theo, các ngươi cũng phải dâng mấy lễ vật đó, không tì vít, và thêm những lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Ngày mồng một tháng bảy, các ngươi sẽ có sự nhóm hiệp thánh; chớ nên làm một công việc xác thịt nào; về phần các ngươi, ấy sẽ là một ngày người ta thổi kèn vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Các ngươi phải dùng một con bò đực tơ, một con chiên đực, và bảy chiên con đực giáp năm, không tì vít, dâng làm của lễ thiêu có mùi thơm cho Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","luôn với của lễ chay bằng bột lọc nhồi dầu, ba phần mười ê-pha về con bò đực, hai phần mười ê-pha về con chiên đực, ");
INSERT INTO vie1934_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","một phần mười ê-pha về mỗi con chiên con; ");
INSERT INTO vie1934_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","và dâng một con dê đực làm của lễ chuộc tội, để làm lễ chuộc tội cho các ngươi; ");
INSERT INTO vie1934_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","các ngươi phải dâng những lễ vật nầy ngoài của lễ thiêu đầu tháng, và của lễ chay cặp theo, của lễ thiêu hằng hiến, và của lễ chay với lễ quán cặp theo, tùy theo những lệ đã định về mấy của lễ đó, mà làm của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Ngày mồng mười tháng bảy nầy, các ngươi sẽ có sự nhóm hiệp thánh, phải ép linh hồn mình, chớ nên làm một công việc xác thịt nào. ");
INSERT INTO vie1934_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Các ngươi phải dâng một con bò đực tơ, một con chiên đực, và bảy chiên con đực giáp năm, không tì vít, làm của lễ thiêu có mùi thơm cho Đức Giê-hô-va: ");
INSERT INTO vie1934_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","của lễ chay sẽ bằng bột lọc nhồi dầu, ba phần mười ê-pha về con bò đực, hai phần mười ê-pha về con chiên đực, ");
INSERT INTO vie1934_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","một phần mười ê-pha về mỗi con chiên con. ");
INSERT INTO vie1934_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ chuộc tội mà người ta dâng trong ngày chuộc tội, của lễ thiêu hằng hiến và của lễ chay với lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Ngày rằm tháng bảy, các ngươi sẽ có sự nhóm hiệp thánh. Chớ nên làm một công việc xác thịt nào, nhưng các ngươi phải giữ một lễ cho Đức Giê-hô-va trong bảy ngày. ");
INSERT INTO vie1934_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Các ngươi phải dùng mười ba con bò đực tơ, hai con chiên đực, và mười bốn chiên con đực giáp năm, không tì vít, dâng làm của lễ thiêu, tức là của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va: ");
INSERT INTO vie1934_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","của lễ chay cặp theo sẽ bằng bột lọc nhồi dầu, ba phần mười ê-pha về mỗi con bò đực, hai phần mười ê-pha về mỗi con chiên đực, ");
INSERT INTO vie1934_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","và một phần mười ê-pha về mỗi con chiên con. ");
INSERT INTO vie1934_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Các ngươi cũng phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến, và của lễ chay với lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Ngày thứ hai, các ngươi phải dâng mười hai con bò đực tơ, hai con chiên đực, mười bốn chiên con đực giáp năm, không tì vít, ");
INSERT INTO vie1934_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","với của lễ chay và các lễ quán về những bò đực, chiên đực, và chiên con cứ theo số như lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến cùng lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Ngày thứ ba, các ngươi phải dâng mười một con bò đực, hai con chiên đực, mười bốn chiên con đực giáp năm, không tì vít, ");
INSERT INTO vie1934_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","với của lễ chay và các lễ quán về những bò đực, chiên đực và chiên con, cứ theo số như lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến, cùng của lễ chay và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Ngày thứ tư, các ngươi phải dâng mười con bò đực, hai con chiên đực, mười bốn chiên con đực giáp năm, không tì vít, ");
INSERT INTO vie1934_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","với của lễ chay và các lễ quán về những bò đực, chiên đực, và chiên con, cứ theo số như lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến, cùng của lễ chay và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Ngày thứ năm, các ngươi phải dâng chín con bò đực, hai con chiên đực, mười bốn chiên con đực giáp năm, không tì vít, ");
INSERT INTO vie1934_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","với của lễ chay và các lễ quán về những bò đực, chiên đực, và chiên con, cứ theo số như lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến, cùng của lễ chay và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Ngày thứ sáu, các ngươi phải dâng tám con bò đực, hai con chiên đực, mười bốn chiên con đực giáp năm, không tì vít, ");
INSERT INTO vie1934_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","với của lễ chay và các lễ quán về những bò đực; chiên đực, và chiên con, cứ theo số như lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến, cùng của lễ chay và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Ngày thứ bảy, các ngươi phải dâng bảy con bò đực, hai con chiên đực, mười bốn chiên con đực giáp năm, không tì vít, ");
INSERT INTO vie1934_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","với của lễ chay và các lễ quán về những bò đực, chiên đực, và chiên con, cứ theo số như lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến, cùng của lễ chay và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Ngày thứ tám, các ngươi phải có sự nhóm hiệp trọng thể; chớ nên làm một công việc xác thịt nào; ");
INSERT INTO vie1934_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","phải dùng một con bò đực, một con chiên đực, và bảy chiên con đực giáp năm, không tì vít, dâng làm của lễ thiêu, tức là của lễ dùng lửa dâng lên có mùi thơm cho Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","với của lễ chay và các lễ quán về những bò đực, chiên đực, và chiên con, cứ theo số như lệ đã định. ");
INSERT INTO vie1934_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Các ngươi phải dâng một con dê đực làm của lễ chuộc tội, ngoài của lễ thiêu hằng hiến, cùng của lễ chay và lễ quán cặp theo. ");
INSERT INTO vie1934_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Đó là những lễ vật mà các ngươi phải dâng cho Đức Giê-hô-va trong những ngày lễ trọng thể mình, đặng làm của lễ thiêu, của lễ chay, lễ quán, và làm của lễ thù ân, ngoài những của lễ hứa nguyện, và những của lễ lạc ý của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","(030-1) Môi-se nói cùng dân Y-sơ-ra-ên mọi điều Đức Giê-hô-va đã phán dặn người. ");
INSERT INTO vie1934_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","(030-2) Môi-se cũng nói cùng những quan trưởng của các chi phái Y-sơ-ra-ên rằng: Này là điều mà Đức Giê-hô-va đã phán: ");
INSERT INTO vie1934_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","(030-3) Khi một người nào có hứa nguyện cùng Đức Giê-hô-va, hoặc phát thề buộc lấy lòng mình phải giữ một sự gì, thì chớ nên thất tín. Mọi lời ra khỏi miệng người, người phải làm theo. ");
INSERT INTO vie1934_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","(030-4) Khi một người nữ, trong buổi còn thơ ấu, ở nhà cha mình, có hứa nguyện cùng Đức Giê-hô-va, và buộc lấy lòng mình phải giữ một điều chi, ");
INSERT INTO vie1934_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","(030-5) nếu người cha đã biết lời hứa nguyện nàng, và sự buộc lòng nàng tự chịu lấy, mà đối với nàng vẫn làm thinh, thì nàng phải làm y lời hứa nguyện, và giữ mọi sự buộc lòng mình mà nàng tự chịu lấy. ");
INSERT INTO vie1934_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","(030-6) Còn nhược bằng ngày nào cha nàng biết mà cấm đi, thì nàng sẽ không mắc lời hứa nguyện mình hay là các sự buộc lòng giữ mà nàng đã tự chịu lấy; Đức Giê-hô-va sẽ tha tội cho nàng, vì cha nàng cấm nàng vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","(030-7) Nếu người nữ ấy đã kết hôn, hoặc vì hứa nguyện, hoặc vì lời chi lỡ ra khỏi môi mà nàng đã chịu lấy một sự buộc mình, ");
INSERT INTO vie1934_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","(030-8) nhược bằng ngày nào chồng nàng hay mà đối cùng nàng vẫn làm thinh, thì nàng phải làm y lời hứa nguyện, và giữ những sự buộc lòng mình mà nàng tự chịu lấy. ");
INSERT INTO vie1934_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","(030-9) Còn nếu ngày nào chồng đã biết, cấm nàng đi, hủy lời hứa nguyện mà nàng mắc đó và lời gì lỡ ra khỏi môi, mà vì cớ đó nàng đã buộc lấy mình, thì Đức Giê-hô-va sẽ tha tội cho nàng. ");
INSERT INTO vie1934_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","(030-10) Lời hứa nguyện của một người đàn bà góa hoặc một người đàn bà bị để, mọi điều chi người đã buộc mình, thì phải giữ lấy. ");
INSERT INTO vie1934_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","(030-11) Nếu một người đàn bà đã hứa nguyện trong nhà chồng mình, hoặc phát thề buộc lấy lòng mình phải giữ một sự gì, ");
INSERT INTO vie1934_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","(030-12) và nếu chồng đã hay, vẫn làm thinh cùng nàng, không cấm, thì nàng phải làm y lời hứa nguyện và giữ mọi sự buộc lòng mà nàng đã tự chịu lấy. ");
INSERT INTO vie1934_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","(030-13) Nhưng nhược bằng ngày nào chồng nàng hay biết, hủy đi, thì mọi lời đã ra khỏi môi về những sự hứa nguyện, và về sự buộc lòng mình sẽ bị hủy đi; chồng nàng đã hủy các lời đó, thì Đức Giê-hô-va sẽ tha tội cho nàng. ");
INSERT INTO vie1934_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","(030-14) Chồng nàng có thế ưng hay hủy mọi sự hứa nguyện, và mọi lời thề mà nàng sẽ buộc mình đặng ép linh hồn mình. ");
INSERT INTO vie1934_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","(030-15) Nhược bằng chồng vẫn làm thinh cùng nàng ngày nay qua ngày mai, như vậy chồng ưng các sự hứa nguyện của nàng; chồng ưng, vì không nói chi ngày mà người đã hay biết. ");
INSERT INTO vie1934_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","(030-16) Còn nếu chồng hủy các sự hứa nguyện một ít lâu sau khi đã hay biết thì chồng sẽ mang sự hình phạt về tội lỗi của vợ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","(030-17) Đó là các lệ định mà Đức Giê-hô-va truyền cho Môi-se về một người chồng và vợ mình, một người cha và con gái mình, buổi thơ ấu khi còn ở nhà cha. ");
INSERT INTO vie1934_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Hãy báo thù dân Ma-đi-an cho dân Y-sơ-ra-ên; rồi ngươi sẽ được về cùng tổ phụ. ");
INSERT INTO vie1934_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Vậy, Môi-se truyền cho dân sự rằng: Trong các ngươi hãy sắm sửa binh khí mà ra trận hãm đánh dân Ma-đi-an đặng báo thù dân đó cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Về mỗi chi phái Y-sơ-ra-ên, các ngươi phải sai một ngàn lính ra trận. ");
INSERT INTO vie1934_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Vậy, trong dân Y-sơ-ra-ên người ta cứ mỗi chi phái chọn một ngàn lính, là mười hai ngàn người sắm sửa binh khí đặng ra trận. ");
INSERT INTO vie1934_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Môi-se sai mười hai ngàn người đó ra trận, tức là sai một ngàn người về mỗi chi phái, với Phi-nê-a, con trai của Ê-lê-a-sa, thầy tế lễ, đem đi theo mình, những khí giới thánh cùng kèn có tiếng vang. ");
INSERT INTO vie1934_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Vậy, chúng giao chiến cùng dân Ma-đi-an, y như Đức Giê-hô-va đã phán dặn Môi-se, và giết hết thảy nam đinh. ");
INSERT INTO vie1934_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Trong các người bị giết chúng cũng giết năm vua Ma-đi-an, là: Ê-vi, Rê-kem, Xu-rơ, Hu-rơ, và Rê-ba; cũng lấy gươm giết Ba-la-am, con trai của Bê-ô. ");
INSERT INTO vie1934_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Dân Y-sơ-ra-ên bắt đàn bà và con nít Ma-đi-an dẫn theo, cướp hết thảy súc vật, bầy chiên và của cải họ, ");
INSERT INTO vie1934_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","đốt hết những thành, nhà ở, và hương thôn chúng nó, ");
INSERT INTO vie1934_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","cũng lấy đem theo hết thảy của đoạt được, bất k” người hay vật. ");
INSERT INTO vie1934_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Chúng dẫn những kẻ bị bắt và những của đoạt được đến cho Môi-se, cho Ê-lê-a-sa, thầy tế lễ, và cho hội dân Y-sơ-ra-ên đang đóng trại tại đồng bằng Mô-áp, gần sông Giô-đanh, đối ngang Giê-ri-cô. ");
INSERT INTO vie1934_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Bấy giờ, Môi-se, Ê-lê-a-sa, thầy tế lễ, và hết thảy hội trưởng đi ra đón rước chúng binh ngoài trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Môi-se nổi giận cùng các quân trưởng, tức là quan tướng một ngàn quân và quan tướng một trăm quân đi đánh giặc nầy trở về. ");
INSERT INTO vie1934_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Môi-se nói cùng họ rằng: Các ngươi để hết thảy người nữ còn sống sao? ");
INSERT INTO vie1934_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Kìa, ấy là chúng nó theo mưu kế của Ba-la-am mà dụ dỗ dân Y-sơ-ra-ên cúng thờ Phê-ô, và phạm một tội trọng cùng Đức Giê-hô-va; và tội đó xui cho hội chúng của Đức Giê-hô-va bị tai vạ. ");
INSERT INTO vie1934_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Vậy bây giờ, hãy giết hết thảy nam đinh trong bọn con trẻ, và giết người nữ nào đã kết bạn cùng một người nam; ");
INSERT INTO vie1934_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","nhưng hãy để sống cho các ngươi hết thảy con gái chưa hề kết bạn cùng người nam. ");
INSERT INTO vie1934_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Còn về phần các ngươi, hãy đóng trại ngoài trại quân trong bảy ngày. Ai có giết một người và có đụng đến một xác chết, thì ai đó cùng kẻ bị bắt, phải dọn cho mình được sạch ngày thứ ba và ngày thứ bảy. ");
INSERT INTO vie1934_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Cũng phải làm cho sạch hết thảy áo xống, mọi vật bằng da, mọi vật bằng lông dê, và mọi đồ đạc bằng cây. ");
INSERT INTO vie1934_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Ê-lê-a-sa, thầy tế lễ, nói cùng những lính trận đi về, mà rằng: Nầy là điều luật pháp dạy mà Đức Giê-hô-va đã truyền cho Môi-se: ");
INSERT INTO vie1934_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","vàng, bạc, đồng, sắt, thiếc, chì, ");
INSERT INTO vie1934_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tức là mọi vật đưa vào lửa được, thì các ngươi phải đưa ngang qua lửa đặng luyện nó; nhưng người ta cũng phải dùng nước tẩy uế mà làm cho nó được sạch nữa. Còn mọi vật chi không đưa qua lửa được, thì phải ngâm nó trong nước. ");
INSERT INTO vie1934_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ngày thứ bảy các ngươi phải giặt áo xống mình, thì sẽ được sạch; đoạn mới được vào trại quân. ");
INSERT INTO vie1934_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Ngươi, Ê-lê-a-sa, thầy tế lễ, và các quan trưởng của những tông tộc, hãy dựng sổ về của giặc mà người ta đã đoạt được, nào người, nào vật, ");
INSERT INTO vie1934_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","rồi chia của đó cho các người đã ra trận và cho cả hội chúng. ");
INSERT INTO vie1934_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Trong phần thuộc về quân binh đã ra trận, hoặc người, hoặc bò, hoặc lừa hay chiên, ngươi phải cứ thâu một phần trong năm trăm mà đóng thuế cho Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","tức phải thâu thuế đó trong phân nửa thuộc về quân binh và giao cho Ê-lê-a-sa, thầy tế lễ, làm lễ vật dâng cho Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Còn trong phân nửa kia thuộc về dân Y-sơ-ra-ên, hoặc người, hoặc bò, hoặc lừa hay chiên, tức các súc vật, ngươi phải cứ mỗi năm chục mà để riêng ra một, và giao cho người Lê-vi có chức phận coi sóc đền tạm của Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Môi-se và Ê-lê-a-sa, thầy tế lễ, làm y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Vả, của giặc còn lại mà quân binh cướp lấy được, là sáu trăm bảy mươi lăm ngàn con chiên cái; ");
INSERT INTO vie1934_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","bảy mươi hai ngàn con bò, ");
INSERT INTO vie1934_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","sáu mươi mốt ngàn con lừa đực. ");
INSERT INTO vie1934_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Người nữ chưa kết bạn cùng người nam nào, hết thảy được ba mươi hai ngàn người. ");
INSERT INTO vie1934_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Phân nửa thuộc về kẻ đã đi trận, là ba trăm ba mươi bảy ngàn năm trăm con chiên cái, ");
INSERT INTO vie1934_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","đóng thuế cho Đức Giê-hô-va là sáu trăm bảy mươi lăm con; ");
INSERT INTO vie1934_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ba mươi sáu ngàn con bò, đóng thuế cho Đức Giê-hô-va là bảy mươi hai con; ");
INSERT INTO vie1934_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ba ngàn năm trăm con lừa đực, và đóng thuế cho Đức Giê-hô-va sáu mươi mốt con; ");
INSERT INTO vie1934_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","mười sáu ngàn người, và đóng thuế cho Đức Giê-hô-va là ba mươi hai người. ");
INSERT INTO vie1934_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Môi-se giao cho Ê-lê-a-sa, thầy tế lễ của thuế làm lễ vật dâng cho Đức Giê-hô-va, y như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Phân nửa kia thuộc về dân Y-sơ-ra-ên, tức là phân nửa mà Môi-se chia ra với phân nửa của quân binh đã đi trận, ");
INSERT INTO vie1934_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","phân nửa nầy thuộc về hội chúng, số là ba trăm ba mươi bảy ngàn năm trăm con chiên cái, ");
INSERT INTO vie1934_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ba mươi sáu ngàn con bò, ");
INSERT INTO vie1934_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ba mươi ngàn năm trăm con lừa, ");
INSERT INTO vie1934_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","và mười sáu ngàn người. ");
INSERT INTO vie1934_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Trong phân nửa nầy thuộc về dân Y-sơ-ra-ên, Môi-se cứ mỗi năm chục thì để riêng ra một, bất luận người hay vật, và giao cho người Lê-vi có chức phận coi sóc đền tạm của Đức Giê-hô-va, y như Đức Giê-hô-va đã phán dặn mình. ");
INSERT INTO vie1934_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Những quan trưởng, tức là quan tướng một ngàn quân và quan tướng một trăm quân, đến gần Môi-se ");
INSERT INTO vie1934_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","mà rằng: Những kẻ tôi tớ ông đã dựng sổ chiến sĩ, là người ở dưới quyền chúng tôi, và không thiếu một tên. ");
INSERT INTO vie1934_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Mỗi người trong chúng tôi có đem đến đồ bằng vàng mình đã được, hoặc dây chuyền, hoặc vòng, hoặc cà-rá, hoặc hoa tai, hoặc kiềng, làm lễ vật dâng cho Đức Giê-hô-va đặng chuộc tội cho mình trước mặt Ngài. ");
INSERT INTO vie1934_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Môi-se và Ê-lê-a-sa, thầy tế lễ, bèn nhận lãnh vàng, và hết thảy đồ trang sức làm công kỹ. ");
INSERT INTO vie1934_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Hết thảy vàng về lễ vật mà những quan tướng một ngàn quân và quan tướng một trăm quân dâng cho Đức Giê-hô-va, cộng là mười sáu ngàn bảy trăm năm mươi siếc-lơ. ");
INSERT INTO vie1934_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Vả, mỗi người trong quân binh đều có cướp lấy vật cho mình. ");
INSERT INTO vie1934_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Vậy, Môi-se và Ê-lê-a-sa, thầy tế lễ, nhận lãnh vàng của quan tướng ngàn quân và trăm quân, rồi đem vào hội mạc làm kỷ niệm về dân Y-sơ-ra-ên trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Vả, con cháu Ru-bên cùng con cháu Gát có bầy súc vật rất nhiều; thấy xứ Gia-ê-xe và xứ Ga-la-át là đất tiện hiệp nuôi bầy súc vật: ");
INSERT INTO vie1934_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","bèn đến thưa cùng Môi-se, Ê-lê-a-sa, thầy tế lễ, và các hội trưởng mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","A-ta-rốt, Đi-bôn, Gia-ê-xe, Nim-ra, Hết-bôn, Ê-lê-a-lê, Sê-bam, Nê-bô và Bê-ôn, ");
INSERT INTO vie1934_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","xứ mà Đức Giê-hô-va đã đánh bại trước mặt hội chúng Y-sơ-ra-ên, là một xứ tiện hiệp nuôi bầy súc vật, và các tôi tớ ông có bầy súc vật. ");
INSERT INTO vie1934_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Lại tiếp rằng: Nếu chúng tôi được ơn trước mặt ông, chớ chi ban xứ nầy cho kẻ tôi tớ ông làm sản nghiệp, xin đừng biểu chúng tôi đi ngang qua sông Giô-đanh. ");
INSERT INTO vie1934_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Nhưng Môi-se đáp cùng con cháu Gát và con cháu Ru-bên rằng: Anh em các ngươi há sẽ đi trận, còn các ngươi ở lại đây sao? ");
INSERT INTO vie1934_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Sao các ngươi xui dân Y-sơ-ra-ên trở lòng, không khứng đi qua xứ mà Đức Giê-hô-va đã cho? ");
INSERT INTO vie1934_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Aáy, tổ phụ các ngươi cũng làm như vậy khi ở từ Ca-đe-Ba-nê-a, ta sai họ đi do thám xứ. ");
INSERT INTO vie1934_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Vì tổ phụ các ngươi lên đến đèo Eách-côn, thấy xứ, rồi xui dân Y-sơ-ra-ên trở lòng, không khứng vào xứ mà Đức Giê-hô-va đã ban cho. ");
INSERT INTO vie1934_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Trong ngày đó, cơn thạnh nộ của Đức Giê-hô-va phừng lên và Ngài thề rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Những người đi lên khỏi xứ Ê-díp-tô, từ hai mươi tuổi sắp lên, sẽ chẳng hề thấy xứ mà ta đã thề ban cho Aùp-ra-ham, Y-sác, và Gia-cốp, vì các người đó không theo ta cách trung thành, ");
INSERT INTO vie1934_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","trừ ra Ca-lép, con trai của Giê-phu-nê, là người Kê-nít, và Giô-suê, con trai của Nun: hai người đó đã theo Đức Giê-hô-va cách trung thành. ");
INSERT INTO vie1934_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Aáy vậy, cơn thạnh nộ của Đức Giê-hô-va nổi phừng phừng cùng dân Y-sơ-ra-ên, Ngài làm cho dân đó đi lưu lạc trong đồng vắng bốn mươi năm, cho đến chừng nào cả dòng dõi đã làm điều ác trước mặt Đức Giê-hô-va bị tiêu diệt hết. ");
INSERT INTO vie1934_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Nầy các ngươi dấy lên thế cho tổ phụ mình, là dòng dõi tội nhân, đặng gia thêm sức thạnh nộ của Đức Giê-hô-va cùng Y-sơ-ra-ên nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Vì nhược bằng các ngươi đi tẻ Ngài ra, thì Ngài sẽ cứ để dân nầy ở trong đồng vắng, và các ngươi làm cho dân chết sạch hết vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Nhưng các người đó đến gần Môi-se mà rằng: Tại đây, chúng tôi sẽ dựng chuồng cho súc vật và thành cho con trẻ chúng tôi; ");
INSERT INTO vie1934_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","rồi chúng tôi cầm binh khí lập tức đặng đi trước dân Y-sơ-ra-ên cho đến chừng nào đưa dân ấy vào cõi đã phân định cho họ. Còn con trẻ chúng tôi phải ở trong thành kiên cố, vì cớ dân bổn xứ. ");
INSERT INTO vie1934_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Chúng tôi không trở về nhà chúng tôi trước khi mọi người trong dân Y-sơ-ra-ên chưa lãnh được sản nghiệp mình. ");
INSERT INTO vie1934_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Chúng tôi sẽ chẳng được chi với dân Y-sơ-ra-ên về bên kia sông Giô-đanh hay là xa hơn, vì chúng tôi được sản nghiệp mình ở bên nầy sông Giô-đanh, về phía đông. ");
INSERT INTO vie1934_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Môi-se đáp cùng các người rằng: Nếu các ngươi làm điều đó, nếu cầm binh khí đặng đi chiến trận trước mặt Đức Giê-hô-va, ");
INSERT INTO vie1934_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","nếu mọi người cầm binh khí đi ngang qua sống Giô-đanh trước mặt Đức Giê-hô-va, cho đến khi nào đuổi quân-nghịch chạy khỏi trước mặt Ngài, ");
INSERT INTO vie1934_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","và nếu chỉ trở về sau khi xứ đã phục trước mặt Đức Giê-hô-va, thì đối cùng Đức Giê-hô-va và Y-sơ-ra-ên, các ngươi sẽ không bị trách móc chi, và đất nầy sẽ làm sản nghiệp cho các ngươi trước mặt Đức Giê-hô-va. ");
INSERT INTO vie1934_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Còn nếu không làm như vậy, nầy các ngươi sẽ phạm tội cùng Đức Giê-hô-va, và phải biết rằng tội chắc sẽ đổ lại trên các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Vậy, hãy cất thành cho con trẻ mình, cùng dựng chuồng cho bầy súc vật và làm điều các ngươi đã nói. ");
INSERT INTO vie1934_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Con cháu Gát và con cháu Ru-bên bèn nói cùng Môi-se rằng: Các tôi tớ ông sẽ làm điều mà chúa tôi phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Con trẻ, vợ, bầy chiên, và hết thảy súc vật chúng tôi sẽ ở đây trong những thành xứ Ga-la-át; ");
INSERT INTO vie1934_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","còn hết thảy tôi tớ ông sẽ cầm binh khí, đi ngang qua, sẵn ngừa mà chiến trận trước mặt Đức Giê-hô-va, như chúa tôi đã phán dặn. ");
INSERT INTO vie1934_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Vậy, Môi-se về phần các người đó truyền lịnh cho Ê-lê-a-sa, thầy tế lễ, cho Giô-suê, con trai Nun, và cho các quan trưởng của những chi phái dân Y-sơ-ra-ên, ");
INSERT INTO vie1934_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","mà rằng: Nếu con cháu Gát và con cháu Ru-bên cầm binh khí đi ngang qua sông Giô-đanh với các ngươi đặng chiến trận trước mặt Đức Giê-hô-va, và nếu xứ phục các ngươi, thì các ngươi phải ban cho họ xứ Ga-la-át làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Nhưng nếu họ không cầm binh khí mà đi ngang qua với các ngươi, thì họ sẽ có sản nghiệp giữa các ngươi trong xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Con cháu Gát và con cháu Ru-bên thưa rằng: Chúng tôi sẽ làm điều chi mà Đức Giê-hô-va đã phán cùng kẻ tôi tớ ông. ");
INSERT INTO vie1934_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Chúng tôi sẽ cầm binh khí đi qua trong xứ Ca-na-an trước mặt Đức Giê-hô-va; nhưng chúng tôi sẽ lãnh sản nghiệp mình về phía bên nầy sông Giô-đanh. ");
INSERT INTO vie1934_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Aáy vậy, Môi-se ban cho con cháu Gát, con cháu Ru-bên, và phân nữa chi phái Ma-na-se, là con trai của Giô-sép, nước của Si-hôn, vua dân A-mô-rít, và nước của Oùc, vua xứ Ba-san, tức là ban xứ với những thành nó và các thành địa-hạt ở chung quanh. ");
INSERT INTO vie1934_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Con cháu Gát bèn xây cất Đi-bôn, A-ta-rốt, A-rô-e, ");
INSERT INTO vie1934_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Aït-rốt-Sô-phan, Gia-ê-xe, Giô-bê-ha, ");
INSERT INTO vie1934_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bết-Nim-ra, và Bết-Ha-ran, là những thành kiên cố. Cũng dựng chuồng cho bầy súc vật nữa. ");
INSERT INTO vie1934_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Con cháu Ru-bên xây cất Hết-bôn, Ê-lê-a-lê, Ki-ri-a-ta-im, ");
INSERT INTO vie1934_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nê-bô, Ba-anh-Mê-ôn, tên các thành nầy bị đổi, và Síp-ma; rồi đặt tên cho các thành nào mình xây cất. ");
INSERT INTO vie1934_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Con cháu Ma-ki, là con trai Ma-na-se, đi vào chiếm xứ Ga-la-át và đuổi người A-mô-rít ở trong đó ra. ");
INSERT INTO vie1934_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Vậy, Môi-se ban xứ Ga-la-át cho Ma-ki, là con trai Ma-na-se, và người ở tại đó. ");
INSERT INTO vie1934_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Giai-rơ, là con trai Ma-na-se, đi chiếm các thôn dân A-mô-rít, đặt tên là thôn Giai-rơ. ");
INSERT INTO vie1934_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nô-bách đi lấy thành Kê-nát với các thành địa hạt, đặt tên là Nô-bách theo chính danh mình. ");
INSERT INTO vie1934_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Nầy là các nơi đóng trại của dân Y-sơ-ra-ên khi họ ra khỏi xứ Ê-díp-tô tùy theo các đội ngũ, có Môi-se và A-rôn quản lý. ");
INSERT INTO vie1934_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Môi-se vâng mạng Đức Giê-hô-va chép sự hành trình của dân chúng, tùy theo các nơi đóng trại. Vậy, nầy là các nơi đóng trại tùy theo sự hành trình của họ. ");
INSERT INTO vie1934_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Ngày rằm tháng giêng, tức ngày sau lễ Vượt-qua, dân Y-sơ-ra-ên ra đi từ Ram-se, cách dạn dĩ, có mắt của hết thảy người Ê-díp-tô thấy. ");
INSERT INTO vie1934_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Người Ê-díp-tô chôn những kẻ mà Đức Giê-hô-va đã hành hại giữa bọn mình, tức là hết thảy con đầu lòng: Đức Giê-hô-va đã đoán xét các thần chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Dân Y-sơ-ra-ên đi từ Ram-se đến đóng trại tại Su-cốt; ");
INSERT INTO vie1934_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","rồi đi từ Su-cốt đến đóng trại tại Ê-tam, ở cuối đồng vắng. ");
INSERT INTO vie1934_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Kế đó, đi từ Ê-tam vòng về hướng Phi-Ha-hi-rốt, đối ngang cùng Ba-anh-Sê-phôn, và đóng trại trước Mít-đôn. ");
INSERT INTO vie1934_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Dân Y-sơ-ra-ên bỏ Phi-Ha-hi-rốt, đi qua giữa biển về hướng đồng vắng đi ba ngày đường ngang đồng vắng Ê-tam, rồi đóng trại tại Ma-ra. ");
INSERT INTO vie1934_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Đoạn, đi từ Ma-ra đến Ê-lim; vả, tại Ê-lim có mười hai cái suối và bảy chục cây chà-là, bèn đóng trại tại đó. ");
INSERT INTO vie1934_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Dân sự đi từ Ê-lim và đóng trại gần Biển đỏ. ");
INSERT INTO vie1934_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Đoạn, đi từ Biển đỏ và đóng trại tại đồng vắng Sin. ");
INSERT INTO vie1934_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Đi từ đồng vắng Sin và đóng trại tại Đáp-ca. ");
INSERT INTO vie1934_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Đi từ Đáp-ca và đóng trại tại A-lúc. ");
INSERT INTO vie1934_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Đi từ A-lúc và đóng trại tại Rê-phi-đim, là nơi không có nước cho dân sự uống. ");
INSERT INTO vie1934_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Dân Y-sơ-ra-ên đi từ Rê-phi-đim và đóng trại trong đồng vắng Si-na-i. ");
INSERT INTO vie1934_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Kế đó, đi từ đồng vắng Si-na-i và đóng trại tại Kíp-rốt Ha-tha-va. ");
INSERT INTO vie1934_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Đi từ Kíp-rốt-Ha-tha-va và đóng trại tại Hát-sê-rốt. ");
INSERT INTO vie1934_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Đoạn, đi từ Hát-sê-rốt và đóng trại tại Rít-ma. ");
INSERT INTO vie1934_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Đi từ Rít-ma và đóng trại tại Ri-môn Phê-rết. ");
INSERT INTO vie1934_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Đi từ Ri-môn-Phê-rết và đóng trại tại Líp-na. ");
INSERT INTO vie1934_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Đi từ Líp-na và đóng trại tại Ri-sa. ");
INSERT INTO vie1934_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Kế đó, đi từ Ri-sa và đóng trại tại Kê-hê-la-tha. ");
INSERT INTO vie1934_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Đi từ Kê-hê-la-tha đóng trại tại núi Sê-phe. ");
INSERT INTO vie1934_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Đi từ núi Sê-phe và đóng trại tại Ha-ra-đa. ");
INSERT INTO vie1934_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Đi từ Ha-ra-đa và đóng trại tại Mác-hê-lốt. ");
INSERT INTO vie1934_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Đoạn, đi từ Mác-hê-lốt và đóng trại tại Ta-hát. ");
INSERT INTO vie1934_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Đi từ Ta-hát và đóng trại tại Ta-rách. ");
INSERT INTO vie1934_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Đi từ Ta-rách và đóng trại tại Mít-ga. ");
INSERT INTO vie1934_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Đi từ Mít-ga và đóng trại tại Hách-mô-na. ");
INSERT INTO vie1934_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Đi từ Hách-mô-na và đóng trại tại Mô-sê-rốt. ");
INSERT INTO vie1934_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Đi từ Mô-sê-rốt và đóng trại tại Bê-ne-Gia-can. ");
INSERT INTO vie1934_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Đi từ Bê-ne-Gia-can và đóng trại tại Hô-Ghi-gát. ");
INSERT INTO vie1934_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Đi từ Hô-Ghi-gát và đóng trại tại Dốt-ba-tha. ");
INSERT INTO vie1934_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Đi từ Dốt-ba-tha và đóng trại tại Aùp-rô-na. ");
INSERT INTO vie1934_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Đoạn, đi từ Aùp-rô-na và đóng trại tại Ê-xi-ôn-Ghê-be. ");
INSERT INTO vie1934_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Đi từ Ê-xi-ôn-Ghê-be và đóng trại tại đồng vắng Xin, nghĩa là tại Ca-đe. ");
INSERT INTO vie1934_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kế đó, đi từ Ca-đe và đóng trại tại núi Hô-rơ, ở chót đầu xứ Ê-đôm. ");
INSERT INTO vie1934_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","A-rôn, thầy tế lễ, theo mạng Đức Giê-hô-va lên trên núi Hô-rơ, rồi qua đời tại đó, nhằm ngày mồng một tháng năm, năm thứ bốn mươi sau khi dân Y-sơ-ra-ên đã ra khỏi xứ Ê-díp-tô. ");
INSERT INTO vie1934_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Khi A-rôn qua đời trên núi Hô-rơ, người đã được một trăm hai mươi ba tuổi. ");
INSERT INTO vie1934_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Bấy giờ, vua A-rát, là người Ca-na-an, ở miền nam xứ Ca-na-an, hay rằng dân Y-sơ-ra-ên đến. ");
INSERT INTO vie1934_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Dân Y-sơ-ra-ên đi từ núi Hô-rơ và đóng trại tại Xa-mô-na. ");
INSERT INTO vie1934_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Đi từ Xa-mô-na và đóng trại tại Phu-nôn. ");
INSERT INTO vie1934_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Đi từ Phu-nôn và đóng trại tại Ô-bốt. ");
INSERT INTO vie1934_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Kế đó, đi từ Ô-bốt và đóng trại tại Y-giê-A-ba-rim, trên bờ cõi Mô-áp. ");
INSERT INTO vie1934_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Đi từ Y-giê-A-ba-rim và đóng trại tại Đi-bôn-Gát. ");
INSERT INTO vie1934_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Đi từ Đi-bôn-Gát và đóng trại tại Anh-môn-Đíp-la-tha-im. ");
INSERT INTO vie1934_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Kế ấy, đi từ Anh-môn-Đíp-la-tha-im và đóng trại tại núi A-ba-rim trước Nê-bô. ");
INSERT INTO vie1934_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Đi từ núi A-ba-rim và đóng trại tại đồng bằng Mô-áp gần sông Giô-đanh, đối ngang Giê-ri-cô. ");
INSERT INTO vie1934_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Dân Y-sơ-ra-ên đóng trại gần sông Giô-đanh, từ Bết-Giê-si-mốt chi A-bên-Si-tim trong đồng Mô-áp. ");
INSERT INTO vie1934_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Đức Giê-hô-va phán cùng Môi-se trong đồng Mô-áp gần sông Giô-đanh, đối ngang Giê-ri-cô, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Hãy truyền cùng dân Y-sơ-ra-ên mà rằng: Khi nào các ngươi đã đi ngang qua sông Giô-đanh đặng vào xứ Ca-na-an rồi, ");
INSERT INTO vie1934_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","thì phải đuổi hết thảy dân của xứ khỏi trước mặt các ngươi, phá hủy hết thảy hình tượng chạm và hình đúc, cùng đạp đổ các nơi cao của chúng nó. ");
INSERT INTO vie1934_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Các ngươi sẽ lãnh xứ làm sản nghiệp và ở tại đó; vì ta đã ban xứ cho các ngươi đặng làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Phải bắt thăm chia xứ ra tùy theo họ hàng các ngươi. Hễ ai số đông, các ngươi phải cho một sản nghiệp lớn hơn; còn hễ ai số ít, thì phải cho một sản nghiệp nhỏ hơn. Mỗi người sẽ nhận lãnh phần mình bắt thăm được; phải cứ những chi phái tổ phụ các ngươi mà chia xứ ra. ");
INSERT INTO vie1934_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Còn nếu các ngươi không đuổi dân của xứ khỏi trước mặt mình, thì những kẻ nào trong bọn họ mà các ngươi còn chừa lại, sẽ như gai trong con mắt, và như chông nơi hông các ngươi, chúng nó sẽ theo bắt riết các ngươi tại trong xứ các ngươi ở; ");
INSERT INTO vie1934_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","rồi xảy đến ta sẽ hành hại các ngươi khác nào ta đã toan hành hại chúng nó vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Hãy truyền điều nầy cho dân Y-sơ-ra-ên mà rằng: Các ngươi sẽ vào xứ Ca-na-an đặng lãnh xứ làm sản nghiệp, tức là xứ Ca-na-an khắp bốn bề: ");
INSERT INTO vie1934_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Miền nam sẽ thuộc về các ngươi, từ đồng vắng Xin chạy dài theo Ê-đôm. Aáy vậy, giới hạn của các ngươi về phía nam sẽ chạy từ đầu Biển-mặn về bên hướng đông. ");
INSERT INTO vie1934_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Giới hạn nầy chạy vòng phía nam của núi Aïc-ráp-bim, đi ngang về hướng Xin và giáp phía nam Ca-đe-Ba-nê-a; đoạn chạy qua Hát-sa-Aùt-đa, và đi ngang hướng Aùt-môn. ");
INSERT INTO vie1934_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Từ Aùt-môn giới hạn chạy vòng về lối suối Ê-díp-tô và giáp biển. ");
INSERT INTO vie1934_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Còn về giới hạn phía tây thì các ngươi sẽ có biển lớn dùng làm hạn, ấy sẽ là giới hạn về phía Tây. ");
INSERT INTO vie1934_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Nầy là giới hạn của các ngươi về phía Bắc: Từ biển lớn, các ngươi sẽ chấm núi Hô-rơ làm hạn; ");
INSERT INTO vie1934_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","từ núi Hô-rơ, các ngươi sẽ chấm tại đầu Ha-mát làm hạn; rồi giới hạn sẽ giáp tại Xê-đát. ");
INSERT INTO vie1934_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Giới hạn sẽ chạy về hướng Xíp-rôn và ăn cuối Hát-sa-Ê-nan, đó là giới hạn của các ngươi về phía Bắc. ");
INSERT INTO vie1934_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Phía đông các ngươi sẽ chấm ranh mình từ Hát-sa-Ê-nan tới Sê-pham; ");
INSERT INTO vie1934_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","rồi chạy từ Sê-pham xuống đến Ríp-la về hướng đông của A-in; đoạn chạy xuống và giáp gành biển Ki-nê-rết về phía đông. ");
INSERT INTO vie1934_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Rốt lại, giới hạn sẽ chạy xuống về phía sông Giô-đanh và giáp Biển-mặn. Đó là xứ các ngươi sẽ có, cùng các giới hạn nó xung quanh vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Môi-se bèn truyền lịnh nầy cho dân Y-sơ-ra-ên mà rằng: Aáy đó là xứ các ngươi sẽ bắt thăm chia ra mà Đức Giê-hô-va đã phán dặn cho chín chi phái và phân nửa của một chi phái. ");
INSERT INTO vie1934_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Vì chi phái con cháu Ru-bên, tùy theo tông tộc mình, và chi phái con cháu Gát, tùy theo tông tộc mình, cùng phân nửa chi phái Ma-na-se đã lãnh phần sản nghiệp mình rồi. ");
INSERT INTO vie1934_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Hai chi phái và nửa chi phái nầy đã nhận lãnh sản nghiệp mình ở phía bên kia sông Giô-đanh, đối ngang Giê-ri-cô về hướng đông, tức về phía mặt trời mọc. ");
INSERT INTO vie1934_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Đức Giê-hô-va lại phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Đây là tên những người sẽ đứng chia xứ: Ê-lê-a-sa, thầy tế lễ, và Giô-suê, con trai Nun. ");
INSERT INTO vie1934_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Các ngươi cũng phải cử mỗi chi phái chọn một quan trưởng đặng chia xứ ra. ");
INSERT INTO vie1934_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Đây là tên các người đó: Về chi phái Giu-đa, Ca-lép, con trai Giê-phu-nê; ");
INSERT INTO vie1934_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","về chi phái con cháu Si-mê-ôn, Sê-mu-ên, con trai A-mi-hút; ");
INSERT INTO vie1934_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","về chi phái Bên-gia-min, Ê-li-đát, con trai Kít-lon; ");
INSERT INTO vie1934_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","về chi phái con cháu Đan, một quan trưởng tên là Bu-ki, con trai Giốc-li; ");
INSERT INTO vie1934_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","về con cháu Giô-sép; về chi phái con cháu Ma-na-se, một quan trưởng tên là Ha-ni-ên, con trai Ê-phát; ");
INSERT INTO vie1934_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","và về chi phái con cháu Eùp-ra-im, một quan trưởng tên là Kê-mu-ên, con trai Síp-tan; ");
INSERT INTO vie1934_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","về chi phái con cháu Sa-bu-lôn, một quan trưởng tên là Ê-lít-sa-phan, con trai Phác-nát; ");
INSERT INTO vie1934_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","về chi phái con cháu Y-sa-ca, một quan trưởng tên là Pha-ti-ên, con trai A-xan; ");
INSERT INTO vie1934_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","về chi phái con cháu A-se, một quan trưởng tên là A-hi-hút, con trai Se-lu-mi; ");
INSERT INTO vie1934_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","và về chi phái con cháu Nép-ta-li, một quan trưởng tên là Phê-đa-ên, con trai A-mi-hút. ");
INSERT INTO vie1934_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Đó là những người mà Đức Giê-hô-va phán biểu đứng chia sản nghiệp cho dân Y-sơ-ra-ên trong xứ Ca-na-an. ");
INSERT INTO vie1934_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Đức Giê-hô-va phán cùng Môi-se trong đồng Mô-áp, gần sông Giô-đanh, đối ngang Giê-ri-cô, mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Hãy biểu dân Y-sơ-ra-ên do trong phần sản nghiệp mình đã có, nhường những thành cho người Lê-vi đặng ở; cho luôn một miếng đất ở chung quanh các thành đó. ");
INSERT INTO vie1934_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Người Lê-vi sẽ có những thành đặng ở; còn đất chung quanh các thành nầy sẽ dùng cho súc vật, cho sản vật, và cho hết thảy thú vật của họ. ");
INSERT INTO vie1934_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Đất chung quanh thành mà các ngươi nhường cho người Lê-vi sẽ là một ngàn thước chu vi, kể từ vách thành và ở ngoài. ");
INSERT INTO vie1934_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Vậy các ngươi phải đo, phía ngoài thành về hướng đông hai ngàn thước, về hướng nam hai ngàn thước, về hướng tây hai ngàn thước, và về hướng bắc hai ngàn thước; cái thành sẽ ở chính giữa. Đó sẽ là đất của những thành người Lê-vi. ");
INSERT INTO vie1934_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Trong số thành các ngươi sẽ nhường cho người Lê-vi, sẽ có sáu cái thành ẩn náu mà các ngươi phải chỉ cho, để kẻ sát nhân trốn tránh tại đó; ngoài sáu thành đó, các ngươi phải nhường cho người Lê-vi bốn mươi hai cái thành. ");
INSERT INTO vie1934_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Hết thảy thành các ngươi sẽ nhường cho người Lê-vi luôn với đất, số là bốn mươi tám cái. ");
INSERT INTO vie1934_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Về những thành do trong sản nghiệp của dân Y-sơ-ra-ên mà các ngươi sẽ nhường cho người Lê-vi phải lấy bớt nhiều hơn của chi phái có nhiều, và lấy bớt ít hơn của chi phái có ít; mỗi chi phái nhường cho người Lê-vi những thành cân phân theo sản nghiệp của mình sẽ được. ");
INSERT INTO vie1934_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Đoạn, Đức Giê-hô-va phán cùng Môi-se rằng: ");
INSERT INTO vie1934_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Hãy nói cùng dân Y-sơ-ra-ên rằng: Khi nào các ngươi đã đi qua sông Giô-đanh đặng vào xứ Ca-na-an, ");
INSERT INTO vie1934_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","thì phải lựa những thành dùng làm thành ẩn náu cho mình, là nơi kẻ sát nhân, vì vô ý đánh chết ai, chạy ẩn náu mình được. ");
INSERT INTO vie1934_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Những thành đó sẽ dùng làm thành ẩn náu để trốn khỏi kẻ báo thù huyết, hầu cho kẻ sát nhân không chết cho đến chừng nào ứng hầu trước mặt hội chúng đặng chịu xét đoán. ");
INSERT INTO vie1934_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Vậy, trong những thành các ngươi nhường cho, sẽ có sáu thành ẩn náu cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Các ngươi phải chỉ ba thành phía bên kia sông Giô-đanh, và lập ba thành khác trong xứ Ca-na-an; ấy sẽ là những thành ẩn náu. ");
INSERT INTO vie1934_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Sáu thành nầy sẽ dùng làm chỗ ẩn náu cho dân Y-sơ-ra-ên, luôn cho khách ngoại bang và kẻ nào kiều ngụ ở trong dân đó, để ai vì vô ý đánh chết một người có thế chạy ẩn mình tại đó. ");
INSERT INTO vie1934_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Nhưng nếu người ấy đánh bằng đồ sắt, và người bị đánh chết đi, ấy là một kẻ sát nhân; kẻ sát nhân hẳn phải bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Nếu người đánh bằng một cục đá cầm nơi tay có thế làm chết, và người bị đánh chết đi, ấy là một kẻ sát nhân; kẻ sát nhân hẳn phải bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Cũng vậy, nếu người đánh bằng đồ cây cầm nơi tay có thế làm chết, và người bị đánh chết đi, ấy là một kẻ sát nhân; kẻ sát nhân hẳn phải bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Aáy là kẻ báo thù huyết sẽ làm cho kẻ sát nhân phải chết; khi nào kẻ báo thù huyết gặp kẻ sát nhân thì phải làm cho nó chết đi. ");
INSERT INTO vie1934_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Nếu một người nào vì lòng ganh ghét xô lấn một người khác, hay là cố ý liệng vật chi trên mình nó, và vì cớ đó nó bị chết; ");
INSERT INTO vie1934_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","hoặc vì sự thù đánh bằng bàn tay, và vì cớ đó nó bị chết, thì người nào đánh đó hẳn phải bị xử tử. Aáy là một kẻ sát nhân; người báo thù huyết khi nào gặp kẻ sát nhân phải làm cho nó chết đi. ");
INSERT INTO vie1934_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Nếu vì tình cờ, vẫn hòa thuận nhau, mà người có lấn xô, hoặc liệng vật chi trên mình người kia, ");
INSERT INTO vie1934_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","hoặc nếu không phải thù nghịch chẳng có ý làm hại, lại không thấy mà làm rớt một cục đá trên mình người kia, có thế làm chết được, và nếu người chết đi, ");
INSERT INTO vie1934_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","thì cứ theo luật lệ nầy, hội chúng phải xử đoán cho kẻ đã đánh và kẻ báo thù huyết: ");
INSERT INTO vie1934_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","hội chúng sẽ giải cứu kẻ sát nhân khỏi tay người báo thù huyết, và biểu người trở về thành ẩn náu, là nơi người đã chạy ẩn mình; và người phải ở đó cho đến chừng nào thầy tế lễ thượng phẩm đã được xức dầu thánh qua đời. ");
INSERT INTO vie1934_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Nhưng nếu kẻ sát nhân đi ra ngoài giới hạn của thành ẩn náu, là nơi người đã chạy ẩn mình, ");
INSERT INTO vie1934_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","và nếu kẻ báo thù huyết gặp, giết người ở ngoài giới hạn thành ẩn náu, thì kẻ báo thù huyết sẽ không mắc tội sát nhân. ");
INSERT INTO vie1934_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Vì kẻ sát nhân phải ở trong thành ẩn náu cho đến chừng nào thầy tế lễ thượng phẩm qua đời; nhưng sau khi thầy tế lễ thượng phẩm qua đời, kẻ sát nhân sẽ được trở về trong sản nghiệp mình. ");
INSERT INTO vie1934_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Bất luận các ngươi ở nơi nào, điều nầy phải dùng làm một luật lệ xét đoán cho các ngươi trải qua các đời. ");
INSERT INTO vie1934_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Nếu ai giết một người nào, người ta sẽ cứ theo lời khai của những người chứng mà giết kẻ sát nhân; nhưng một người chứng không đủ cớ đặng giết ai. ");
INSERT INTO vie1934_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Các ngươi chớ lãnh tiền chuộc mạng của một người sát nhân đã có tội và đáng chết, vì nó hẳn phải bị xử tử. ");
INSERT INTO vie1934_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Các ngươi đừng lãnh tiền chuộc kẻ đã chạy ẩn mình trong thành ẩn náu, hầu cho nó trở về ở trong xứ sau khi thầy tế lễ qua đời. ");
INSERT INTO vie1934_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Các ngươi chớ làm ô uế xứ mà các ngươi sẽ ở; vì huyết làm ô uế xứ. Nhược bằng có kẻ làm đổ huyết ra trong xứ, nếu không làm đổ huyết nó lại, thì không thế chuộc tội cho xứ được. ");
INSERT INTO vie1934_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Vậy, các ngươi chớ làm ô uế xứ, là nơi các ngươi sẽ ở, và chính giữa đó là nơi ta sẽ ngự; vì ta là Đức Giê-hô-va ngự giữa dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Vả, những trưởng tộc Ga-la-át, là con trai Ma-ki, cháu Ma-na-se, trong dòng con cháu Giô-sép, đến gần và nói trước mặt Môi-se cùng trước mặt các tổng trưởng của những chi phái Y-sơ-ra-ên, ");
INSERT INTO vie1934_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","mà rằng: Đức Giê-hô-va có phán cùng chúa tôi bắt thăm chia xứ cho dân Y-sơ-ra-ên làm sản nghiệp, và chúa tôi có lãnh mạng Đức Giê-hô-va giao sản nghiệp của Xê-lô-phát, anh chúng tôi, cho các con gái người. ");
INSERT INTO vie1934_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Nếu các con gái kết hôn với một trong những con trai về các chi phái khác của dân Y-sơ-ra-ên, sản nghiệp chúng nó sẽ truất khỏi sản nghiệp của tổ phụ chúng tôi mà thêm vào sản nghiệp của chi phái nào chúng nó sẽ thuộc về; như vậy phần đó phải truất khỏi sản nghiệp đã bắt thăm về chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Khi đến năm hân hỉ cho dân Y-sơ-ra-ên, sản nghiệp chúng nó sẽ thêm vào sản nghiệp của chi phái nào chúng nó sẽ thuộc về; như vậy, sản nghiệp chúng nó sẽ truất khỏi sản nghiệp của chi phái tổ phụ chúng tôi. ");
INSERT INTO vie1934_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Môi-se bèn truyền các lịnh nầy của Đức Giê-hô-va cho dân Y-sơ-ra-ên mà rằng: Chi phái con cháu Giô-sép nói có lý. ");
INSERT INTO vie1934_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Nầy là điều Đức Giê-hô-va có phán về phần các con gái Xê-lô-phát: Chúng nó muốn kết thân với ai thì muốn, nhưng chỉ hãy kết thân với một trong những nhà của chi phái tổ phụ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Như vậy, trong dân Y-sơ-ra-ên, một sản nghiệp nào chẳng được từ chi phái nầy đem qua chi phái khác, vì mỗi người trong dân Y-sơ-ra-ên sẽ ở đeo theo sản nghiệp về chi phái tổ phụ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Phàm người con gái nào được một phần sản nghiệp trong một của các chi phái Y-sơ-ra-ên, thì phải kết thân cùng một người của một nhà nào về chi phái tổ phụ mình, hầu cho mỗi người trong dân Y-sơ-ra-ên hưởng phần sản nghiệp của tổ phụ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Vậy, một phần sản nghiệp nào chẳng được từ chi phái nầy đem qua chi phái kia; nhưng mỗi chi phái Y-sơ-ra-ên sẽ giữ sản nghiệp mình vậy. ");
INSERT INTO vie1934_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Các con gái Xê-lô-phát làm như Đức Giê-hô-va đã phán dặn Môi-se. ");
INSERT INTO vie1934_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mách-la, Thiệt-sa, Hốt-la, Minh-ca, và Nô-a, các con gái của Xê-lô-phát, đều kết thân cùng các con trai của cậu mình. ");
INSERT INTO vie1934_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Chúng nó kết thân trong những nhà của con cháu Ma-na-se, là con trai Giô-sép, và phần sản nghiệp họ còn lại trong chi phái tổ phụ mình. ");
INSERT INTO vie1934_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Đó là các mạng lịnh và luật lệ mà Đức Giê-hô-va đã cậy Môi-se truyền cho dân Y-sơ-ra-ên, tại trong đồng bằng Mô-áp, gần sông Giô-đanh, đối ngang Giê-ri-cô. ");
INSERT INTO vie1934_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Nầy là lời Môi-se nói cho cả Y-sơ-ra-ên, bên kia sông Giô-đanh, tại đồng vắng, trong đồng bằng, đối ngang Su-phơ, giữa khoảng Pha-ran và Tô-phên, La-ban, Hát-sê-rốt, và Đi-xa-háp. ");
INSERT INTO vie1934_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Từ Hô-rếp tới Ca-đe-Ba-nê-a, bởi đường núi Sê-i-rơ, đi mười một ngày đường. ");
INSERT INTO vie1934_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Nhằm năm bốn mươi, ngày mồng một tháng mười một. Môi-se nói cùng dân Y-sơ-ra-ên mọi điều mà Đức Giê-hô-va đã biểu người phải nói cùng họ. ");
INSERT INTO vie1934_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Aáy là sau khi người đã đánh giết Si-hôn, vua dân A-mô-rít ở tại Hết-bôn, và Oùc, vua Ba-san, ở tại Aùch-ta-rốt và Eát-rê-i. ");
INSERT INTO vie1934_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Tại bên kia sông Giô-đanh, trong xứ Mô-áp, Môi-se khởi giảng giải luật pháp nầy mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Giê-hô-va Đức Chúa Trời chúng ta có phán cùng chúng ta tại Hô-rếp mà rằng: Các ngươi kiều ngụ trong núi nầy đã lâu quá; ");
INSERT INTO vie1934_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","hãy vòng lại và đi đến núi dân A-mô-rít, cùng đến các miền ở gần bên, tức là đến nơi đồng bằng, lên núi, vào xứ thấp, đến miền nam, lên mé biển, vào xứ dân Ca-na-an và Li-ban, cho đến sông lớn, là sông Ơ-phơ-rát. ");
INSERT INTO vie1934_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Kìa, ta phó xứ nầy cho các ngươi! Hãy vào và chiếm lấy xứ mà Đức Giê-hô-va đã thề ban cho tổ phụ các ngươi, là Aùp-ra-ham, Y-sác, Gia-cốp, cùng cho con cháu của họ. ");
INSERT INTO vie1934_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Trong lúc đó ta có nói cùng các ngươi rằng: Một mình ta không đủ sức cai trị các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Giê-hô-va Đức Chúa Trời các ngươi đã gia thêm các ngươi, kìa ngày nay, các ngươi đông như sao trên trời. ");
INSERT INTO vie1934_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Nguyện Giê-hô-va Đức Chúa Trời của tổ phụ các ngươi khiến các ngươi thêm lên gấp ngàn lần và ban phước cho, y như Ngài đã phán cùng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Một mình ta làm thế nào mang lấy trách nhiệm và gánh nặng về điều tranh tụng của các ngươi? ");
INSERT INTO vie1934_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Hãy chọn trong mỗi chi phái các ngươi những người khôn ngoan, thông sáng, có tiếng, và ta sẽ lập họ lên làm quan trưởng các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Các ngươi có đáp rằng: Việc người toan làm thật tốt thay. ");
INSERT INTO vie1934_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Bấy giờ, ta chọn lấy những người quan trưởng của các chi phái, là những người khôn ngoan, có tiếng, lập lên làm quan tướng các ngươi, hoặc cai ngàn người, hoặc cai trăm người, hoặc cai năm mươi người, hoặc cai mười người, và làm quản lý trong những chi phái của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Trong lúc đó, ta ra lịnh cho những quan xét các ngươi rằng: Hãy nghe anh em các ngươi, và lấy công bình mà xét đoán sự tranh tụng của mỗi người với anh em mình, hay là với khách ngoại bang ở cùng người. ");
INSERT INTO vie1934_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Trong việc xét đoán, các ngươi chớ tư vị ai; hãy nghe người hèn như nghe người sang, đừng có sợ ai, vì sự xét đoán thuộc về Đức Chúa Trời. Phàm việc nào lấy làm rất khó cho các ngươi, hãy đem đến trước mặt ta thì ta sẽ nghe cho. ");
INSERT INTO vie1934_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Vậy, trong lúc đó, ta có truyền cho các ngươi mọi điều mình phải làm. ");
INSERT INTO vie1934_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Đoạn, bỏ Hô-rếp, chúng ta trải ngang qua đồng vắng minh-mông và gớm ghê mà chúng ta thấy kia, hướng về núi dân A-mô-rít, y như Giê-hô-va Đức Chúa Trời chúng ta đã phán dặn; rồi chúng ta đến Ca-đe-Ba-nê-a. ");
INSERT INTO vie1934_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Bấy giờ, ta nói cùng các ngươi rằng: Các ngươi đã đến núi của dân A-mô-rít mà Giê-hô-va Đức Chúa Trời chúng ta ban cho chúng ta. ");
INSERT INTO vie1934_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Kìa, Giê-hô-va Đức Chúa Trời ngươi phó xứ nầy cho ngươi; hãy đi lên, chiếm làm sản nghiệp, y như Giê-hô-va Đức Chúa Trời của tổ phụ ngươi đã phán cùng ngươi; chớ ái ngại, chớ kinh khủng. ");
INSERT INTO vie1934_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Các ngươi hết thảy bèn lại gần ta và nói rằng: Hãy sai những người đi trước chúng tôi, đặng do thám xứ và chỉ bảo về đường sá nào chúng tôi phải lên, và các thành chúng tôi phải vào. ");
INSERT INTO vie1934_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Lời nầy đẹp lòng ta; ta chọn mười hai người trong các ngươi, tức mỗi chi phái một người. ");
INSERT INTO vie1934_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Mười hai người đó ra đi. lên núi, đi đến khe Eách-côn và do thám xứ. ");
INSERT INTO vie1934_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Họ hái cầm trong tay mình những trái cây xứ đó, đem về cho chúng ta; thuật lại cùng chúng ta rằng: Xứ mà Giê-hô-va Đức Chúa Trời chúng ta ban cho thật là tốt. ");
INSERT INTO vie1934_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Nhưng các ngươi không muốn lên đó, và đã bội nghịch mạng của Giê-hô-va Đức Chúa Trời các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","lằm bằm trong trại mình mà rằng: Aáy bởi Đức Giê-hô-va ghét chúng ta, nên khiến chúng ta ra xứ Ê-díp-tô, đặng phó chúng ta vào tay dân A-mô-rít, để tiêu diệt đi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Chúng ta sẽ đi lên đâu? Anh em chúng ta làm cho chúng ta tiêu gan vì nói rằng: Aáy là một dân đông hơn và cao lớn hơn chúng ta; ấy là những thành lớn và kiên cố đến tận trời; vả lại, tại đó, chúng tôi có thấy những con cháu của dân A-na-kim. ");
INSERT INTO vie1934_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Nhưng ta nói cùng các ngươi rằng: Chớ ái ngại và chớ sợ sệt gì. ");
INSERT INTO vie1934_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Giê-hô-va Đức Chúa Trời các ngươi đi trước, chính Ngài sẽ chiến-cự cho các ngươi, như Ngài đã thường làm trước mắt các ngươi tại xứ Ê-díp-tô, ");
INSERT INTO vie1934_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","và trong đồng vắng -là nơi ngươi thấy rằng trọn dọc đường ngươi đi, cho đến khi tới chốn nầy, Giê-hô-va Đức Chúa Trời ngươi đã bồng ngươi như một người bồng con trai mình. ");
INSERT INTO vie1934_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Dầu vậy, các ngươi vẫn không tin Giê-hô-va Đức Chúa Trời các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","là Đấng đi trước dẫn các ngươi trên đường, để tìm cho các ngươi một nơi đóng trại; ban đêm trong đám lửa, ban ngày trong đám mây, đặng chỉ con đường các ngươi phải đi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Bấy giờ, Đức Giê-hô-va nghe tiếng của lời nói các ngươi, bèn nổi giận và thề rằng: ");
INSERT INTO vie1934_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Chẳng một ai của dòng dõi gian ác nầy sẽ thấy xứ tốt đẹp mà ta đã thề ban cho tổ phụ các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ngoại trừ Ca-lép, con trai của Giê-phu-nê. Người sẽ thấy xứ đó; và ta sẽ ban cho người cùng con cháu người xứ mà người đã trải qua, bởi vì người có theo Đức Giê-hô-va cách trung tín trọn vẹn. ");
INSERT INTO vie1934_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Lại, Đức Giê-hô-va vì cớ các ngươi cũng nổi giận cùng ta, mà rằng: Ngươi cũng vậy, sẽ không vào đó đâu. ");
INSERT INTO vie1934_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Giô-suê, con trai Nun, là đầy tớ ngươi, sẽ được vào đó. Hãy làm cho người vững lòng, vì ấy là người sẽ khiến dân Y-sơ-ra-ên nhận lấy xứ nầy lảm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Những con trẻ của các ngươi và các ngươi đã nói rằng sẽ thành một miếng mồi, và những con trai các ngươi hiện bây giờ chưa biết điều thiện hay là điều ác, sẽ vào xứ đó. Ta sẽ ban cho chúng nó xứ nầy làm sản nghiệp; ");
INSERT INTO vie1934_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","nhưng các ngươi hãy trở về, đi đến đồng vắng về hướng Biển đỏ. ");
INSERT INTO vie1934_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Lúc đó, các ngươi bèn đáp cùng ta mà rằng: Chúng tôi đã phạm tội cùng Đức Giê-hô-va; chúng tôi sẽ đi lên chiến trận và làm mọi điều Giê-hô-va Đức Chúa Trời chúng tôi đã phán dặn. Mỗi người trong các ngươi nịt binh khí và toan dại dột đi lên núi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Đức Giê-hô-va bèn phán cùng ta rằng: Hãy nói cùng dân sự: Chớ đi lên và chớ chiến trận, vì ta không ngự giữa các ngươi; e các ngươi bị quân thù nghịch đánh bại. ");
INSERT INTO vie1934_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ta có thuật lại những lời nầy, nhưng các ngươi không nghe ta, nghịch mạng của Đức Giê-hô-va, đầy sự kiêu ngạo, kéo đi lên núi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Bấy giờ, người A-mô-rít ở trong núi nầy, đi ra đón và đuổi các ngươi như thể đoàn ong, đánh bại các ngươi tại Sê-i-rơ cho đến Họt-ma. ");
INSERT INTO vie1934_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Khi trở về, các ngươi có khóc lóc trước mặt Đức Giê-hô-va, nhưng Đức Giê-hô-va không lắng tai và chẳng khứng nghe tiếng của các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Aáy vì thế nên các ngươi ở tại Ca-đe lâu ngày, nhiều ngày biết dường bao! ");
INSERT INTO vie1934_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Đoạn, chúng ta trở lại đi vào đồng vắng về hướng Biển đỏ, y như Đức Giê-hô-va đã phán dặn ta, và chúng ta đi vòng lâu ngày quanh núi Sê-i-rơ. ");
INSERT INTO vie1934_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Đức Giê-hô-va có phán cùng ta mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Các ngươi đi vòng núi nầy cũng đã lâu rồi, hãy trở lên hướng bắc. ");
INSERT INTO vie1934_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Hãy truyền lịnh nầy cho dân sự: Các ngươi sẽ trải qua địa phận của anh em mình, tức là con cháu Ê-sau, ở tại Sê-i-rơ, và chúng nó sẽ sợ các ngươi. Nhưng hãy giữ lấy mình, ");
INSERT INTO vie1934_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","chớ có tranh cùng chúng nó, vì ta sẽ không cho các ngươi xứ của chúng nó đâu, dầu đến nỗi một thẻo đất bằng bàn chân cũng không cho. Ta đã ban cho Ê-sau núi Sê-i-rơ làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Các ngươi sẽ dùng bạc tiền mà mua lương thực của chúng nó mà ăn, nước mà uống. ");
INSERT INTO vie1934_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Vì Giê-hô-va Đức Chúa Trời ngươi đã ban phước cho mọi công việc làm của tay ngươi; Ngài đã biết cuộc đi đường ngươi ngang qua đồng vắng lớn lao nầy. Trong bốn mươi năm nầy, Giê-hô-va Đức Chúa Trời ngươi vẫn ở cùng ngươi; ngươi không thiếu chi hết. ");
INSERT INTO vie1934_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Vậy, chúng ta có đi ngang qua cách xa anh em ta, là con cháu Ê-sau, ở tại Sê-i-rơ, và bắt đi về hướng đồng vắng Mô-áp, đặng tránh con đường đồng bằng, cùng Ê-lát và Ê-xi-ôn-Ghê-be. ");
INSERT INTO vie1934_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Đức Giê-hô-va bèn phán cùng ta rằng: Chớ đương địch và chớ chiến trận với dân Mô-áp; vì ta không cho ngươi chi trong xứ dân ấy làm sản nghiệp đâu, bởi ta đã ban A-rơ cho con cháu Lót làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Lúc trước, dân Ê-mim ở tại đó. Aáy là một dân lớn, đông, hình giềnh giàng như dân A-na-kim vậy. ");
INSERT INTO vie1934_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Người ta cũng cho dân nầy là dân giềnh giàng như dân A-na-kim; nhưng dân Mô-áp gọi họ là Ê-mim. ");
INSERT INTO vie1934_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Dân Hô-rít lúc trước cũng ở tại Sê-i-rơ; song con cháu Ê-sau diệt dân ấy, đoạt lấy xứ họ và ở thế cho, y như Y-sơ-ra-ên làm trong xứ mà Đức Giê-hô-va đã ban cho người làm sản nghiệp). ");
INSERT INTO vie1934_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Bây giờ, hãy đứng dậy, đi ngang qua khe Xê-rết. Vậy, chúng ta có đi ngang khe Xê-rết. ");
INSERT INTO vie1934_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Vả, thì giờ về các cuộc đi đường của chúng ta, từ khi lìa khỏi Ca-đe-Ba-nê-a, tới lúc đi ngang qua khe Xê-rết, cộng là ba mươi tám năm, cho đến chừng các người chiến sĩ về đời ấy đã diệt mất khỏi trại quân, y như Đức Giê-hô-va đã thề cùng các người đó. ");
INSERT INTO vie1934_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Vả lại, tay Đức Giê-hô-va cũng tra vào họ đặng diệt họ khỏi trại quân, cho đến chừng nào họ đều tiêu diệt hết. ");
INSERT INTO vie1934_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Xảy khi các người chiến sĩ đã bị tiêu diệt và chết mất khỏi dân sự, ");
INSERT INTO vie1934_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","thì Đức Giê-hô-va phán cùng ta mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Ngày nay ngươi sẽ đi ngang qua A-rơ, bờ cõi của Mô-áp, ");
INSERT INTO vie1934_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","và đến gần con cháu Am-môn. Chớ đương địch và chớ chiến trận cùng chúng nó; vì ta không cho ngươi chi hết của xứ con cháu Am-môn làm sản nghiệp, bởi ta đã ban xứ đó cho con cháu của Lót làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Nguyên xứ nầy gọi là xứ Rê-pha-im. Xưa kia dân Rê-pha-im ở đó, dân Am-môn gọi là Xam-xu-mim; ");
INSERT INTO vie1934_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ấy là một dân lớn, đông, hình giềnh giàng như dân A-na-kim. Nhưng Đức Giê-hô-va diệt dân Rê-pha-im trước mặt dân Am-môn; dân Am-môn đoạt lấy xứ của họ và ở thế cho. ");
INSERT INTO vie1934_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Aáy Ngài đã làm cho con cháu Ê-sau, ở tại Sê-i-rơ, là như vậy, khi Ngài hủy diệt dân Hô-rít trước mặt con cháu Ê-sau; họ chiếm lấy xứ dân ấy và ở thế vào chỗ cho đến ngày nay. ");
INSERT INTO vie1934_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Còn dân A-vim, ở trong những làng cho đến Ga-xa, dân Cáp-tô-rim ở từ Cáp-tô ra hủy diệt họ, và ở thế vào cho). ");
INSERT INTO vie1934_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Hãy đứng dậy đi ngang qua khe Aït-nôn. Kìa, ta đã phó Si-hôn, vua Hết-bôn, là người A-mô-rít, cùng xứ người vào tay ngươi; hãy khởi chiếm lấy và giao chiến cùng người. ");
INSERT INTO vie1934_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Ngày nay, ta khởi rải trên các dân tộc trong thiên hạ sự sợ hãi và kinh khủng về danh ngươi, đến đỗi khi nghe nói về ngươi, các dân tộc đó sẽ run rẩy và bị sự kinh khủng áp hãm trước mặt ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Bấy giờ, từ đồng vắng Kê-đê-mốt, ta sai sứ giả đến Si-hôn, vua Hết-bôn, lấy lời hòa hảo đặng nói cùng người rằng: ");
INSERT INTO vie1934_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Xin cho phép tôi đi ngang qua xứ vua; tôi đi theo đường cái luôn luôn, không xây qua bên hữu hay bên tả. ");
INSERT INTO vie1934_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Vua sẽ nhận lấy bạc bán lương thực cho, để tôi có mà ăn; sẽ nhận lấy bạc bán nước, để tôi có mà uống. Chỉ hãy để cho tôi đi ngang qua luôn, ");
INSERT INTO vie1934_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","cũng như con cháu Ê-sau ở tại Sê-i-rơ, và dân Mô-áp ở tại A-rơ đã cho phép vậy, cho đến chừng nào tôi đi qua Giô-đanh, đặng vào xứ mà Giê-hô-va Đức Chúa Trời tôi ban cho tôi. ");
INSERT INTO vie1934_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Nhưng Si-hôn, vua Hết-bôn, không khứng chúng ta đi ngang qua địa phận người; vì Giê-hô-va Đức Chúa Trời ngươi đã khiến cho tánh người ương ngạnh, lòng người cứng cỏi, để phó người vào tay ngươi, y như điều đã xảy đến ngày nay. ");
INSERT INTO vie1934_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Đức Giê-hô-va phán cùng ta rằng: kìa, từ bây giờ, ta phó Si-hôn và xứ người cho ngươi. Hãy khởi chiếm lấy xứ người đặng làm cơ nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Vậy, Si-hôn và cả dân sự người ra đón chúng ta, đặng giao chiến tại Gia-hát. ");
INSERT INTO vie1934_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Nhưng Giê-hô-va Đức Chúa Trời chúng ta phó người cho chúng ta, và chúng ta đánh bại người, các con trai cùng cả dân sự của người. ");
INSERT INTO vie1934_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Trong lúc đó, ta chiếm hết các thành người, khấn vái diệt hết các thành, cả người nam, người nữ, và các con trẻ, không chừa lại một ai. ");
INSERT INTO vie1934_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Chúng ta chỉ có cướp lấy cho phần mình súc vật và hóa tài của các thành mình đã thắng được. ");
INSERT INTO vie1934_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Từ A-rô-e, ở trên mé khe Aït-nôn, và cái thành ở trong trũng, cho đến Ga-la-át, chẳng có một thành nào lấy làm kiên cố quá cho chúng ta; Giê-hô-va Đức Chúa Trời chúng ta đã phó các thành đó cho chúng ta hết. ");
INSERT INTO vie1934_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Chỉn ngươi không có lại gần xứ của con cháu Am-môn, ở dọc khắp mé khe Gia-bốc, hoặc các thành trên núi hay là chỗ nào Giê-hô-va Đức Chúa Trời chúng ta cấm không cho chúng ta chiếm lấy. ");
INSERT INTO vie1934_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Bấy giờ, chúng ta trở lại bắt đường Ba-san đi lên. Oùc, vua Ba-san, và cả dân sự người ra đón chúng ta, đặng giao chiến tại Eách-rê-i. ");
INSERT INTO vie1934_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Đức Giê-hô-va phán cùng ta rằng: Ngươi chớ sợ, vì ta đã phó người, cả dân sự và xứ người vào tay ngươi; ngươi sẽ làm cho người như ngươi đã làm cho Si-hôn, vua A-mô-rít, ở tại Hết-bôn. ");
INSERT INTO vie1934_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Giê-hô-va Đức Chúa Trời chúng ta cũng có phó vào tay chúng ta Oùc, vua Ba-san, và cả dân sự người; chúng ta có đánh bại người đến chừng không còn lại một ai. ");
INSERT INTO vie1934_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Trong lúc đó chúng ta chiếm lấy các thành của người, không có thành nào mà mình không chiếm lấy; tức là sáu mươi cái thành và toàn miền Aït-gốp, là nước của Oùc trong xứ Ba-san. ");
INSERT INTO vie1934_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Các thành nầy vốn là đồn lũy có vách cao, cửa và cây gài; cũng có lấy những thành không có vách rất nhiều. ");
INSERT INTO vie1934_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Chúng ta khấn vái tận diệt các thành nầy, như chúng ta đã làm cho Si-hôn, vua Hết-bôn, tức là khấn vái diệt hết các thành, các người nam, người nữ, và connnnn trẻ. ");
INSERT INTO vie1934_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Nhưng chúng ta chiếm lấy về phần mình hết thảy súc vật và hóa tài của các thành ấy. ");
INSERT INTO vie1934_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Vậy, trong lúc đó, chúng ta chiếm lấy của hai vua A-mô-rít, xứ bên kia sông Giô-đanh, từ khe Aït-nnôn đến núi Hẹt-môn ");
INSERT INTO vie1934_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(dân Si-đôn gọi núi Hẹt-môn là Si-ri-ôn; còn dân A-mô-rít đặt tên là Sê-ni-rơ); ");
INSERT INTO vie1934_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","các thành của đồng bằng, toàn Ga-la-át và toàn Ba-san, cho đến Sanh-ca và Eát-rê-i, là hai thành của nước Oùc trong Ba-san. ");
INSERT INTO vie1934_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Vì về dân tộc Rê-pha-im, chỉ có một mình Oùc, vua Ba-san, còn lại. Nầy, cái giường bằng sắt của người, há chẳng còn tại Ráp-ba, thành của con cháu Am-môn sao? Bề dài giường là chín thước, bề ngang bốn thước, theo thước tay người nam). ");
INSERT INTO vie1934_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Vậy, trong lúc đó, chúng ta chiếm lấy xứ nầy. Ta cho người Ru-bên và người Gát từ xứ A-rô-e, ở trên khe Aït-nôn và phân nửa núi Ga-la-át, cùng các thành của nó. ");
INSERT INTO vie1934_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ta cho phân nửa chi phái Ma-na-se phần còn lại của núi Ga-la-át, và toàn Ba-san, nước của Oùc, tức là cả miền Aït-gốp cùng toàn Ba-san vậy. Miền ấy gọi là xứ Rê-pha-im. ");
INSERT INTO vie1934_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Giai-rơ, con trai Ma-na-se, chiếm lấy cả miền Aït-gốp cho đến giới hạn dân Ghê-su-rít và Ma-ca-thít, đặt tên mình cho các thôn xứ Ba-san, là thôn Giai-rơ, đến ngày nay hãy còn. ");
INSERT INTO vie1934_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Ta cũng cho Ma-ki xứ Ga-la-át. ");
INSERT INTO vie1934_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Về người Ru-bên và người Gát, ta cho phần Ga-la-át có ranh ở giữa khe Aït-nôn cho đến khe Gia-bốt, là giới hạn của con cháu Am-môn, ");
INSERT INTO vie1934_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","luôn với đồng bằng Giô-đanh, từ Ki-nê-rết tới biển của đồng bằng, tức là Biển mặn, dưới triền núi Phích-ga, về phía đông. ");
INSERT INTO vie1934_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Vả, trong lúc đó, ta truyền lịnh nầy cho các ngươi, mà rằng: Giê-hô-va Đức Chúa Trời các ngươi có phó xứ nầy cho các ngươi đặng nhận lấy làm sản nghiệp; hết thảy những chiến sĩ trong các ngươi phải cầm binh khí đi qua trước anh em mình, là dân Y-sơ-ra-ên. ");
INSERT INTO vie1934_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Chỉ những vợ, con trẻ, và súc vật các ngươi-ta biết rằng các ngươi có nhiều súc vật-sẽ ở lại trong những thành mà ta đã cho các ngươi, ");
INSERT INTO vie1934_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","đến chừng nào Đức Giê-hô-va cho anh em các ngươi sự an nghỉ như mình, và anh em cũng nhận được xứ mà Giê-hô-va Đức Chúa Trời các ngươi ban cho họ tại phía bên kia sông Giô-đanh; đoạn mọi người trong các ngươi sẽ trở về sản nghiệp mình mà ta đã ban cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Đang lúc ấy, ta cũng truyền lịnh nầy cho Giô-suê mà rằng: Mắt ngươi có thấy mọi điều Giê-hô-va Đức Chúa Trời các ngươi đã làm cho hai vua nầy; Đức Giê-hô-va sẽ làm như vậy cho các nước nào mà ngươi sẽ đi qua. ");
INSERT INTO vie1934_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Đừng sợ các nước đó, vì chính Giê-hô-va Đức Chúa Trời các ngươi tranh chiến cho các ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Trong lúc nầy, ta cầu khẩn cùng Đức Giê-hô-va mà rằng: ");
INSERT INTO vie1934_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Lạy Chúa Giê-hô-va, Chúa đã khởi tỏ cho kẻ tôi tớ Chúa sự oai nghiêm lớn, và cánh tay quyền năng của Chúa; vì trên trời dưới đất há có thần nào làm được việc và công sự quyền năng giống như của Chúa chăng? ");
INSERT INTO vie1934_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Tôi xin Chúa cho phép tôi đi qua xem xứ tốt tươi, núi đẹp đẽ nầy, và Li-ban ở bên kia sông Giô-đanh. ");
INSERT INTO vie1934_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Nhưng Đức Giê-hô-va, bởi cớ các ngươi, nổi giận cùng ta, không nhận lời ta, bèn phán rằng: Thôi; chớ còn nói về việc nầy cùng ta nữa. ");
INSERT INTO vie1934_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Hãy đi lên chót Phích-ga, ngước mắt ngươi lên về hướng tây, hướng bắc, hướng nam, và hướng đông mà nhìn xứ ấy, vì ngươi sẽ không đi ngang qua sông Giô-đanh nầy đâu. ");
INSERT INTO vie1934_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Song hãy truyền mạng lịnh cho Giô-suê, làm cho người vững lòng bền chí; vì ấy là người phải đi qua trước mặt dân nầy, khiến chúng nhận lấy xứ mà ngươi sẽ thấy. ");
INSERT INTO vie1934_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Aáy vậy, chúng ta có ở trong trũng, đối ngang Bết-Phê-o. ");
INSERT INTO vie1934_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Hỡi Y-sơ-ra-ên, bây giờ hãy nghe những mạng lịnh và luật lệ mà ta dạy các ngươi; hãy làm theo, để các ngươi được sống và vào xứ mà Giê-hô-va Đức Chúa Trời của tổ phụ các ngươi ban cho các ngươi nhận được. ");
INSERT INTO vie1934_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Các ngươi chớ thêm chi và đừng bớt chi về điều ta truyền cho, để giữ theo các điều răn của Giê-hô-va Đức Chúa Trời các ngươi mà ta đã truyền. ");
INSERT INTO vie1934_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Nhân dịp của Ba-anh-Phê-o, mắt các ngươi đã thấy điều Đức Giê-hô-va đã làm; vì Giê-hô-va Đức Chúa Trời ngươi có diệt khỏi giữa ngươi mọi kẻ tin theo Ba-anh-Phê-o. ");
INSERT INTO vie1934_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Còn các ngươi, là những kẻ vẫn theo Giê-hô-va Đức Chúa Trời mình, ngày nay hết thảy còn sống. ");
INSERT INTO vie1934_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Nầy đây, ta đã dạy các ngươi những mạng lịnh và luật lệ y như Giê-hô-va Đức Chúa Trời ta đã phán dặn ta, để các ngươi làm theo ở giữa xứ mình sẽ vào đặng nhận lấy. ");
INSERT INTO vie1934_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Vậy, các ngươi phải giữ làm theo các mạng lịnh và luật lệ nầy; vì ấy là sự khôn ngoan và sự thông sáng của các ngươi trước mặt các dân tộc; họ nghe nói về các luật lệ nầy, sẽ nói rằng: Dân nầy là một dân khôn ngoan và thông sáng không hai! ");
INSERT INTO vie1934_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Vả chăng, há có dân lớn nào mà có các thần mình gần như chúng ta có Giê-hô-va Đức Chúa Trời gần chúng ta, mọi khi chúng ta cầu khẩn Ngài chăng? ");
INSERT INTO vie1934_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Lại, há có nước lớn nào có những mạng lịnh và luật lệ công bình như cả luật pháp nầy, mà ngày nay ta đặt trước mặt các ngươi chăng? ");
INSERT INTO vie1934_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Chỉ hãy giữ lấy ngươi, lo canh cẩn thận linh hồn mình, e ngươi quên những điều mà mắt mình đã thấy, hầu cho chẳng một ngày nào của đời ngươi những điều đó lìa khỏi lòng ngươi: phải dạy cho các con và cháu ngươi. ");
INSERT INTO vie1934_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Hãy nhớ ngày ngươi chầu Giê-hô-va Đức Chúa Trời ngươi tại Hô-rếp, khi Đức Giê-hô-va phán cùng ta rằng: Hãy nhóm hiệp dân sự để ta khiến chúng nghe lời ta, hầu cho tập kính sợ ta đang lúc họ còn sống nơi thế thượng, và dạy lời đó cho con cái mình. ");
INSERT INTO vie1934_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Vậy, các ngươi lại gần và đứng dưới núi. Vả, núi cả lửa cháy cho đến tận trời; có sự tối tăm, mây mịt mịt và đen kịt. ");
INSERT INTO vie1934_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Từ trong lửa, Đức Giê-hô-va phán cùng các ngươi; các ngươi nghe một tiếng nói, nhưng không thấy một hình trạng nào; chỉ nghe một tiếng mà thôi. ");
INSERT INTO vie1934_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ngài rao truyền cho các ngươi biết sự giao ước của Ngài, tức là mười điều răn, khiến các ngươi gìn giữ lấy, và Ngài chép mười điều răn ấy trên hai bảng đá. ");
INSERT INTO vie1934_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Trong lúc đó, Đức Giê-hô-va cũng phán dặn ta dạy các ngươi những mạng lịnh và luật lệ, để các ngươi làm theo tại trong xứ mà mình sẽ đi vào nhận lấy. ");
INSERT INTO vie1934_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Vậy, các ngươi hãy cẩn thận giữ lấy linh hồn mình cho lắm, vì các ngươi không có thấy một hình trạng nào trong ngày Giê-hô-va Đức Chúa Trời các ngươi, từ nơi giữa lửa phán cùng các ngươi, tại Hô-rếp; ");
INSERT INTO vie1934_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","e các ngươi phải làm hư hoại cho mình chăng, và làm một tượng chạm nào, tạo hình trạng của tà thần nào, hoặc hình của người nam hay người nữ, ");
INSERT INTO vie1934_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","hoặc hình của con thú nào đi trên đất, hoặc hình của vật nào có cánh bay trên trời, ");
INSERT INTO vie1934_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","hoặc hình của loài côn trùng nào bò trên đất, hay là hình của con cá nào ở trong nước dưới đất; ");
INSERT INTO vie1934_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","lại, e khi ngươi ngước mắt lên trời thấy mặt trời, mặt trăng, các ngôi sao, tức là toàn cả thiên binh, thì ngươi bị quyến dụ quì xuống trước các vì đó, và thờ lạy các tinh tú nầy mà Giê-hô-va Đức Chúa Trời ngươi đã chia phân cho muôn dân dưới trời chăng. ");
INSERT INTO vie1934_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Còn các ngươi, Đức Giê-hô-va đã chọn và rút các ngươi khỏi lò lửa bằng sắt kia, là xứ Ê-díp-tô, để các ngươi thành một dân riêng của Ngài, y như các ngươi đã là điều đó ngày nay. ");
INSERT INTO vie1934_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Đoạn, Đức Giê-hô-va, vì cớ các ngươi, nổi giận cùng ta, có thề rằng ta không được đi ngang qua sông Giô-đanh, và chẳng đặng vào xứ tốt đẹp mà Giê-hô-va Đức Chúa Trời ngươi ban cho ngươi làm sản nghiệp. ");
INSERT INTO vie1934_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Vì ta phải chết trong xứ nầy, không đi ngang qua sông Giô-đanh được; nhưng các ngươi sẽ đi qua và nhận lấy xứ tốt đẹp ấy. ");
INSERT INTO vie1934_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Khá cẩn thận giữ lấy mình, chớ quên sự giao ước của Giê-hô-va Đức Chúa Trời các ngươi đã lập cùng các ngươi, và chớ làm tượng chạm nào, hình của vật nào mà Giê-hô-va Đức Chúa Trời ngươi đã cấm; ");
INSERT INTO vie1934_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","vì Giê-hô-va Đức Chúa Trời ngươi như một đám lửa tiêu cháy, và là Đức Chúa Trời hay kỵ tà. ");
INSERT INTO vie1934_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Khi các ngươi sẽ có con cùng cháu, và khi đã ở lâu trong xứ rồi, nếu các ngươi làm bại hoại mình, làm tượng chạm nào, hình của vật chi mặc dầu, mà hành ác trước mặt Giê-hô-va Đức Chúa Trời các ngươi để chọc Ngài nổi giận, ");
INSERT INTO vie1934_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","thì ngày nay ta bắt trời và đất làm chứng quyết cho các ngươi rằng các ngươi sẽ chết vội, và khuất mắt khỏi xứ mà mình sẽ đi nhận lấy tại bên kia sông Giô-đanh. Các ngươi chẳng ở đó lâu dài đâu, nhưng sẽ bị tận diệt. ");
INSERT INTO vie1934_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Đức Giê-hô-va sẽ tản lạc các ngươi trong các nước, chỉ còn lại số nhỏ trong các nước mà Đức Giê-hô-va sẽ dẫn các ngươi vào; ");
INSERT INTO vie1934_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ở đó các ngươi sẽ cúng thờ những thần bằng cây và bằng đá, là công việc của tay loài người làm nên, chẳng thấy, chẳng nghe, chẳng ăn, cũng chẳng ngửi. ");
INSERT INTO vie1934_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ỳ đó ngươi sẽ tìm cầu Giê-hô-va Đức Chúa Trời ngươi, và khi nào hết lòng hết ý tìm cầu Ngài thì mới gặp. ");
INSERT INTO vie1934_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Khi ngươi bị gian nan, và các việc nầy xảy đến cho ngươi, bấy giờ trong ngày cuối cùng, ngươi sẽ trở về cùng Giê-hô-va Đức Chúa Trời ngươi, và vâng theo tiếng Ngài. ");
INSERT INTO vie1934_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Vì Giê-hô-va Đức Chúa Trời ngươi là Đức Chúa Trời hay thương xót sẽ không bỏ ngươi và không hủy